﻿USE sofia;
DROP TABLE IF EXISTS sofia.gdn_vpl;
CREATE TABLE gdn_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gdn_vpl WRITE;
INSERT INTO gdn_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Yau ka Iyesu Keriso e ripakwarakwaraiyoma dai mu simaga. Oragai apunai Eburamu e momoiyoma wenatagamawa kebomawa da paunau ka kaiwawo Dewida wena-wena. Ade kaiwawo Dewida e momo-iyoma wenatagamawa kebomawa da siyareya ka Iyesu wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Apunu Eburamu e ubupu manako e gubagai Aisiki wenawena. Aisiki e ubupu manako e gubagai Diyaikapu wenawena. Diyaikapu e ubupu manako e gubagai Diyuda e yowaiyoma mete kina wenatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Diyuda e ubupu manako e gubagai-yoma Peresi yo Tara wenatagubu. Mu inamaga ka Tama. Peresi e ubupu manako e gubagai Esironi wenawena. Esironi e ubupu manako e gubagai Rama wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Rama e ubupu manako e gubagai Aminadapu wenawena. Aminadapu e ubupu manako e gubagai Nasoni wenawena. Nasoni e ubupu manako e gubagai Saramoni wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saramoni e ubupu manako e gubagai Bowasi wenawena. Bowasi e inai ka ridi Reyabu. Bowasi e ubupu manako ridi Rusi pokaiya ka e gubagai Obedi wenapupu. Obedi e ubupu manako e gubagai Diyese wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Diyese e ubupu manako e gubagai apunu kawai Dewida wenawena. Apunu kawai Dewida e ubupu manako e gubagai Soromoni wenawena. Soromoni e inai ka apunu Uriyasi e koboroi. ");
INSERT INTO gdn_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Soromoni e ubupu manako e gubagai Reyabowamu wenawena. Reyabowamu e ubupu manako e gubagai Abaidiya wenawena. Abaidiya e ubupu manako e gubagai Ata wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Ata e ubupu manako e gubagai Diyosapasi wenawena. Diyosapasi e ubupu manako e gubagai Diyoramu wenawena. Diyoramu e ubupu manako e gubagai Usiya wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Usiya e ubupu manako e gubagai Diyotamu wenawena. Diyotamu e ubupu manako e gubagai Ayasi wenawena. Ayasi e ubupu manako e gubagai Esekiya wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Esekiya e ubupu manako e gubagai Manase wenawena. Manase e ubupu manako e gubagai Amoni wenawena. Amoni e ubupu manako e gubagai Diyosaiya wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Diyosaiya e ubupu manako e gubagai Diyokonaiya e yowai-yoma mete kina wenatagubu. Mara ki makeya ka tawana Babironi ragidai bautagubu tawana Isiraero ragidai tetampu diburatampu tawana Babironi kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Tawana Isiraero ragidai tawana Babironi were ade wiratagubu bautagubu ki makeya ka apunu Diyokonaiya e ubupu manako e gubagai Siyasiyero wenawena. Siyasiyero e ubupu manako e gubagai Serababero wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababero e ubupu manako e gubagai Abiyusi wenawena. Abiyusi e ubupu manako e gubagai Eraiyakimu wenawena. Eraiyakimu e ubupu manako e gubagai Asoro wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Asoro e ubupu manako e gubagai Diyadoki wenawena. Diyadoki e ubupu manako e gubagai Akimu wenawena. Akimu e ubupu manako e gubagai Eriyudi wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eriyudi e ubupu manako e gubagai Eriyesa wenawena. Eriyesa e ubupu manako e gubagai Matanu wenawena. Matanu e ubupu manako e gubagai Diyaikapu wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Diyaikapu e ubupu manako e gubagai Diyosepa wenawena. Apunu Diyosepa e ka ridi Meri e nobomoi. Ade ridi Meri e ka Iyesu e inai. Ko Iyesu e si daikere ka mu Keriso simupu. ");
INSERT INTO gdn_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Oragai apunai Eburamu e momo-iyoma wenatagamawa popotagamawa ade wenatagamawa popotagamawa inako kwaetagamawa kebomawa da ida esida kewowena kerapu apeya apeya (14) ki makeya ka kaiwawo Dewida wenawena. Ade kaiwawo Dewida e momoiyoma wenatagamawa popotaga-mawa ade wenatagamawa popotaga-mawa inako kwaetagamawa kebomawa da ida esida kewowena kerapu apeya apeya (14) ki makeya ka tawana Babironi ragidai bautagubu tawana Isiraero ragidai tetampu diburatampu tawana Babironi kayatagubu. Ade ki eweya ka tawana Isiraero ragidai wenatagamawa popotagamawa ade wenatagamawa popotagamawa inako kwaetagamawa kebomawa da ida esida kewowena kerapu apeya apeya (14) ki makeya ka Keriso e wenawena. (v22) Takari kawaya ka Mama-nuga God ubupu e bonanai waina-piyawa wagawa apunai mosi sibu, manako e ubupu oka inako tapu, wagubu ke; (v23) ‘Aita ewa ka onowa mosi romodoyagisi manako munu uratanai wenapoto. Ko onowa ki ka apunu mo mete eba iwa. Munu wena-yagisi ki mu e si Imanuwero siyomoto. (Si Imanuwero ki mibai mete kina ko ki mibai ka ‘Mamanuga God nu mete idiwei.’) ");
INSERT INTO gdn_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Mamanuga God e okai wagubu ki makeya makeya ka Iyesu Keriso wenawena yau kena; E inai Meri ka onowa tondawa da yaraga mo si ka Diyosepa pokaiya winemupu da e uwarana ki nana. Mu didiwa eba ukwapamawa ko pa idiwa. Onowa Meri inako pa tondawa kaniyawa da Mama-nuga God e eya Keyai Tanai Bagi Kawaya kawapu e rabineya minibu siwa manako Keyai ki kasiyarai pokaiya ka e romodowena. ");
INSERT INTO gdn_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Apunu Diyosepa e ka notai eyaka mena supasupai apunai, ko e gurabai Meri romodowena empupu ka e notai wagubu ke; ‘Ki nima romodoi wagubu?’ E notai inako wagubu, ko e eba nuwaiya iyapana Meri siyamana midimama kweyamana ki pokere e ebo mena weki gwaiya wareta kwaetagubu ki meyana puru kayawagana ki nana wainapiyawa. ");
INSERT INTO gdn_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","E inako notapiyawa tondawa da Mamanuga God aneya mo tonopupu e bameya bauwena waro were maba sibu, wagubu ke; “Diyosepa, kau ka oragai apunai Dewida e wenai. Kau notagi eba koyogono ko kau gurabagi Meri ki e idai karako tepi kupi. Nau suwagani wainapi; Mamanuga God e eya Keyai Tanai Bagi Kawaya kawapu Meri rabineya minibu siwa kasiyara kwebu manako kasiyara ki pokaiya ka e romodowena. ");
INSERT INTO gdn_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ko munu uratanai aita wenayagisi ki kau e si Iyesu siyo, mibai ka e iyapanaiyoma mu bigimaga empoto surupoto manako iya tageni.” Aneya ki inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","(-) ");
INSERT INTO gdn_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","(-) ");
INSERT INTO gdn_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Apunu Diyosepa yabuwena kipu ubupu ka e aneya badidi sibu ki makeya makeya kwaewena e gurabai Meri uwapu. ");
INSERT INTO gdn_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Ko e wainai mete eba iwa ko pa idiwa kebomawa da e gubagai wenawena ka e ubupu munu ki si Iyesu sibu. Naiya ka e wainai mete eba ukwapamawa ko munu ki wenawena eweya ka mu waina nobomo ewapuru idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Apunu Erodi tawana Diyudiya ragidai kawaimaga tondawa ki makeya ka munu Iyesu natere Beteriyemu tawana Diyudiya rabineya wenawena. E wenawena eweya ka iyapana supama iyabatamawa ragidai dai ki madega posiwagau deneya idiwa ki kimpu ubumpu madega kaniyau surau deneya kayatagubu natere Diyerusaremu bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Bautagubu, manako manu inako wadumupu, tagubu ke; “Wi Diyu ragidai Kaiwawoga wauni wenawena ki e bani tondau? Nu madega posiwagau ki deneya idiweya da e supamai wauni posiwena ki tanai emipi ki pokere nu munu wenawena ki taragapamana e si tepapamana ki nana baigibi.” ");
INSERT INTO gdn_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Apunu kawai Erodi ade natere Diyerusaremu ragidai kuduba mete kina yona ki wainamupu ka mu notamaga babawena, ");
INSERT INTO gdn_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ki pokere apunu Erodi ubupu Mamanuga God bameya dobo-piyamu ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina mu bibimaga tonopupu manako manutapu, wagubu ke; “Keriso aita baiyagisi ki ka e tawana bani wenayagisi?” ");
INSERT INTO gdn_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","E inako wagubu manako mu denai tagubu ke; “E natere Beteriyemu tawana Diyudiya rabineya wenayagisi, mibai ka takari kawaya ka Mamanuga God e bonanai wainapiyawa wagawa apunai mosi oka tapu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Natere Beteriyemu tawana Diyuda rabineya, kau ka natere marai munta ko ade natere kuduba tawana Diyuda rabineya mu paunamugu kau mena ka natere kawaya, mibai kau rabinageya ka Kaiwawo kawaya mo wenayagisi. E uburoto nau iyapananiyoma Isiraero ragidai kwayubatamono tondono.’” ");
INSERT INTO gdn_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Apunu Erodi yona ki wainapupu ka e supama iyabatamawa ragidai ki mu bibimaga tonopupu bautagubu manako weki gwaiya manutapu, wagubu ke; “Wi gwede mara supama wauni posi-wena ki yabiri emupu?” ");
INSERT INTO gdn_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Mu denai tagubu manako e tadebu tonotapu, wagubu ke; “Wi natere Beteriyemu kaiwagi munu wawayai ki naigida mena kwaenepumuri empumuri manako ewa wiraiwagi baiwagi nau sidimuri da nau mete kayasugani e empani taragapani.” ");
INSERT INTO gdn_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Supama iyabatamawa ragidai yona ki wainamupu ka mu kimpu ubumpu kayatagubu kaiwa manako supama naiya mu mubo tawanamaga deneya posiwena emupu ki yabiritapu kaya-wena kaniyawa da yabaramugu munu wenawena kawareya uburawa ki mu ade emupu. ");
INSERT INTO gdn_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Mu supama ki emupu ka mu mamama kawaya wainamupu, ");
INSERT INTO gdn_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","manako kayatagubu kaiwa da munu tondawa tawai ki bautagubu. Mu tawa rabineya yampu ka mu munu ki e inai Meri mete kina ika idiwa emitampu manako kwarisitagubu ramatamaga kawareya ubumpu munu ki taragamupu e si esida tepamupu. Mu e si tepa-pamawa idiwa da kamadumpu ka mu igwamaga rabineya puyo bagibagi bowa yamayamai ade ripa otai aurere aurere kiyabumaga ebo ebo denimaga kawa-kawaya ki inako waramupu puyo kwemupu. ");
INSERT INTO gdn_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Mu ade wiratagubu kayatagamawa makeya ka mu yawata naiya bautagubu yawatai ki eba kaya-tagubu, mibai ka mu waro were emupu da mu apunu Erodi bameya eba kaya-tagamana ki nana. Mu kimpu ubumpu manako yawata kudubai mosi mu mubo tawanamugu ade kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Supama iyabatamawa ragidai ki kayatagubu eweya ka Mamanuga God e aneyai mo tonopupu kunumau kawapu manako apunu Diyosepa bameya bauwena waro were sibu, wagubu ke; “Apunu Diyosepa, kau garugaru mena kiri uburi kau ridigi munugi tetami wakapaiwagi kaiwagi tawana Idipi idiwoi, mibai ka apunu Erodi kau munugi miniyana po ki kwaenei kwaewagau. Ko wi ade wiraigamana marai ki nau ewa were kau kabuwa-niyani.” Aneya ki inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Apunu Diyosepa waro were yona ki wainapupu ka e garugaru mena kipu ubupu munu ki e inai mete kina wara-tapu kemora ki rabineya tawana Idipi deneya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Mu kayatagubu kaiwa da bautagubu ka mu ika idiwa kebomawa da apunu Erodi powena eweya ka mu ade wiratagubu mu mubo tawanamugu ade kayatagubu. Takari kawaya ka Mamanuga God e bonanai wainapiyawa wagawa apunai mosi oka inako tapu, wagubu ke; ‘Kaiwawonuga e wagubu ke; Nau gubagani tawana Idipi kamadana yabadana ki nana suwagubuwani.’ Oka badidi wagubu ki mibai wana wena-wena karako yau kena. ");
INSERT INTO gdn_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Supama iyabatamawa ragidai apunu Erodi beramupu yawata kudubai mo kayatagubu ki sisiyai Erodi waina-pupu ki ka e nuwai pupuwena. E piyara ragidai tadebu da mu kayatagamana munu uratanai mu kwamuramaga apeya ade erida ki natere Beteriyemu ade natere Beteriyemu bameya ika idiwa ki mu kuduba namutamana gawarara ki nana wagubu. Supama iyabatamawa ragidai gwede mara supama wauni posiwena emupu ki yonai apunu Erodi kataiwena ki pokere e wainapupu da piyara ragidai munu kwamuramaga apeya ade erida ki namutamana ki ka baganai. ");
INSERT INTO gdn_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Apunu Erodi berokoi yau kwae-wena ki pokaiya ka Mamanuga God takari kawaya e bonanai wainapiyawa wagawa apunai Diyeremaiya kabuwa-pupu oka tapu ki mibai wana wena-wena. Oka ki wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","‘Tawana Rama rabineya ka apena yo yadi ki mumugarai bauwena kayawena iyapana wainamupu. Ridi Raisero e munuiyoma kuduba popotagubu gawarara ki pokere e mu yadimaga kirau. Iyapana e rabinai minimana kwarisi ki nana kwaetagamu ko e rabinai eba kwarisiwena mibai ka e munuiyoma kuduba popotagubu gawarara.’ ");
INSERT INTO gdn_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Apunu Erodi powena ki makeya ka Mamanuga God e aneyai mo tono-pupu kunumau kawapu tawana Idipi rabineya apunu Diyosepa bameya bauwena manako waro were sibu, ");
INSERT INTO gdn_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","wagubu ke; “Kau kiri uburi munu ki e inai mete kina karako waratami manako wiraiwagi tawana Isiraero naiya idiwa watagau ki ade kaiwagi. Kau munugi minimana po kwaetaga-mawa ragidai ki mu kuduba popo-tagubu gawarara.” ");
INSERT INTO gdn_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Apunu Diyosepa yona ki waina-pupu ka e kipu ubupu munu ki e inai mete waratapu ade wiratagubu kaya-tagubu kaiwa da tawana Isiraero bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Mu ika bautagubu ka apunu Erodi e gubagai si ka Akerausi e mamai watai wadubu tawana Diyudiya ragidai kawaimaga tondawa ki sisiyai Diyosepa wainapupu. E kudu waina-pupu ade waro mo mete wadubu ki pokere mu ade kimpu ubumpu tawana Diyudiya kamadumpu manako kaya-tagubu kaiwa da tawana Gariri bau-tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Mu ika bautagubu ka mu ade kayatagubu kaiwa idiwa da natere mo si ka Nasareta bautagubu manako ika idiwa. Takari kawaya ka Mamanuga God e bonanai wainapamawa tagamawa ragidai Iyesu nene oka inako tamupu, tagubu ke; ‘Iyapana e tawana Nasareta apunai siyomoto.’ Oka badidi wagubu ki mibai wana wenawena karako yau kena. ");
INSERT INTO gdn_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Mara ki makeya ka iyapana siruwatamiyawa apunai Diyoni tawana Diyudiya rabineya iyapana eba idiwu tawaneya ki bauwena manako dimawagawa iyapana tadeyawa, wagawa ke; ");
INSERT INTO gdn_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki marai rogobiwena ki pokere wi beraga berokoi oragai ki wi karako kamadumuri wi notaga wirayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Takari kawaya ka Mamanuga God e bonanai wainapiyawa wagawa apunai Aisaiya apunu Diyoni nene oka yau okapupu, wagubu ke; “Apunu mosi gwabau umau e bonanai ragiragi kawaya wagau ke; Kaiwawonuga e yawatai gwaba memuri da e taneya mena baiyagisi kayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Apunu Diyoni e gwedegwedei ka eba bagi. E papa kameru kumai kau-piyawa ade e naurai taburuba papa kwakwarai pokaiya yamanamupu ki umarawa umawa. E bani ka manigowa yo tapoi borepa ki mena kupawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Natere Diyerusaremu ragidai, iyapana awana Diyoudani bameya idiwa ragidai, ade iyapana tawana Diyudiya kuduba inako ki mu e bameya bautagubu, ");
INSERT INTO gdn_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","manako mu bigi badidi kwaetagamawa ki mu tagamawa matara mu idamaga kerapumaga rikapamawa manako apunu Diyoni ubupu mu awana Diyoudani rabineya siruwatapu. ");
INSERT INTO gdn_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Parisi ragidai ade Sadusi ragidai ropani kawaya mete kina e siruwa-tamana ki nana bautagubu emitapu ki ka e ubupu mu tadebu, wagubu ke; “Wi ka motamota berokoi e munuiyoma. Nima nidibu da wi Mamanuga God e nuwa pupui wi bamagau bauwagana kwaewagau ki kudeya wakapaigubu yewe siruwaigamana ki nana baigubu? ");
INSERT INTO gdn_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Wi mibai iyaga wirapamana weta-wetara ki nana wainapiyamu ki ka wi iyaga oragai ki kuduba kamadumuri manako supasupai mena idiwoi. ");
INSERT INTO gdn_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ade eba notapiyoi da wi yona mena iwaga-mana ka baganai, iwagi ke; ‘Nu ka oragai apunai Eburamu e momoiyoma ki pokere Mamanuga God e nu waina-niyau da nu ka baganai.’ Nau nidiyani wainapumuri; Mamanuga God e nuwaiya ki ka e bowa ropani kawaya yau tadeni manako mu eyaka eyaka oragai apunai Eburamu e momoiyoma wenatagisi. ");
INSERT INTO gdn_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Karako ka ripa kerareya dokopana apunai okukunawena kewo-wena da e ripa meyana ki nana. Ripa ururutanai kuduba ki e dokopoto matau isiyapoto.” ");
INSERT INTO gdn_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Apunu Diyoni iyapana ade tadebu, wagubu ke; “Wi notaga wirawena beraga berokoi kamadumpu ki mibi-pamana ki nana ka nau awana pokaiya wi siruwaniyakani. Ko nau ewaneya ka apunu mosi baiyagisi. E kasiyarai ka kawaya esida ko nau kasiyarani ka marai munta erida. Nau apunu ki e bigabigai kwaesugana waitapana e kerarai kwakwarai bibiyopana ko nau eba bagi da nau upi ki kwaesugani. E baiyagisi ki ka e Mamanuga God e Keyai Tanai Bagi Kawaya ki kasiyarai pokaiya ade mata nonarai pokaiya wi siruwaniyoto. ");
INSERT INTO gdn_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","E diba idaiya wadubu kewowena ki pokaiya e gwaba madai ki tekwaripoto da mibai gwegwetagisi wateya ukwopomoto. Ko gwaba ki kwarai ka mugu ki pokere nusuru tepoto madaneya nakapoto. Madai gwetagubu ki e tepoto e tawaiya magara nakapoto, ko mugui ki e mata maramara urau ko ewa mo eba poyagisi ki kawareya isiyapoto.” Apunu Diyoni inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Mara ki makeya ka Iyesu tawana Gariri kamadubu awana Diyoudani papateya bauwena da apunu Diyoni uburana e awana ki rabineya siruwa-pana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Ko apunu Diyoni ubupu Iyesu notai wirapana ki nana sibu, wagubu ke, “Nau ka eba bagi da nau uburani kau siruwaniyani. Nau kau bamageya bausugubena da kau nau siruwasinibena ki ka baganai, ko kau gwede nana nau bamaneya baunugibi?” ");
INSERT INTO gdn_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ko Iyesu denai e sibu, wagubu ke; “Kau mara karako nene nau siruwasini ki ka supasupai. Nu inako kwaigomu ki ka Mamanuga God e badidi supasupai wainapiyau ki mibai wenapoto.” Apunu Diyoni yona ki wainapupu ka e ubupu Iyesu siruwapupu. ");
INSERT INTO gdn_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Iyesu awana rabineya supu ade matarau posiwagawa ki makeya ka kunuma yagarawena manako Mama-nuga God e Keyai Tanai Bagi Kawaya ki midiwari umago maba kawapu e kawareya minibu siwa ki e empupu. ");
INSERT INTO gdn_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ki makeya ka bonana mosi kunumau kawapu, wagubu ke; “Yau ka nau Gubagani. Nau nuwaneya po eyo ki pokere nau karako e mamamai suwagakani.” Bonana ki inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ki eweya ka Mamanuga God e Keyai Tanai Bagi Kawaya kawapu manako yabiriwena Iyesu bananapupu iyapana eba idiwu tawaneya kaya-tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Iyesu bani eba kupawa ko ika pa umawa wadawa da mara apunai apeya (40) kewowena eweya ka e wetei mebu. ");
INSERT INTO gdn_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","E wetei meyawa makeya ka kerapu wadewade apunai Seitani e bameya bauwena manako sibu, wagubu ke; “Kau God e Gubagai baganai ki kau nuwagi da bowa yau bani wenayagisi kupi.” ");
INSERT INTO gdn_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","E inako wagubu ko Iyesu denai e sibu, wagubu ke; “Mamanuga God e okai mosi wagubu ke; Iyapana iyamaga kerarai ka eba bani mena ko Mamanuga God e umuneya badidi wagau ki pokaiya ka mu iya wadamu.” ");
INSERT INTO gdn_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Berokoi Apunai Seitani Iyesu yonai ki wainapupu ka e wirawena Iyesu idaiya wadubu kayatagubu natere Bagi Kawaya Diyerusaremu bautagubu, manako e Iyesu wadubu Mamanuga God e Tawai iyarau kawaya ki tagaiya tapu, ");
INSERT INTO gdn_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","manako sibu, wagubu ke; “Kau God e Gubagai baganai ki kau kwarara yau sikipi wairau uburi.” E inako wagubu ade wagubu ke; “God oka inako tapu, wagubu ke; ‘Nau aneyagiyoma tonotamani eminimoto idamaga rabineya wadinimoto sumoto ki pokere kau keraragi bowa eba miniyoto.’” ");
INSERT INTO gdn_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Berokoi Apunai Seitani e Mamanuga God yonai kawareya inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Mama-nuga God e okai mosi wagubu ke; Wi nau kasiyarani matarau empamana ki nana asusu eba kwaiwogoi.” ");
INSERT INTO gdn_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Iyesu inako wagubu, ko Seitani ubupu Iyesu idaiya ade wadubu banana-pupu ewapuru kweya iyarau mo yamupu manako e tawana bagibagi kuduba madega kauwagau madega posiwagau ki kabuwapupu sibu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Kau yabaraneya kwarisinuwagi kau rama-tagi kawareya uburi nau sini tepapi manako ewa ka nau gwedegwede bagibagi yau kuduba kau negeyani.” ");
INSERT INTO gdn_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","E inako wagubu, ko Iyesu denai e nakaripupu sibu, wagubu ke; “Seitani, kau kamadisini kayanuwagi. Mamanuga God e okai mosi wagubu ke; Nu Mamanuga God e ebo mena si tepa-pomu ade e mena notapomu bigabigai kwaigomu.” ");
INSERT INTO gdn_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Iyesu yona ki wagawa makeya ka Berokoi Apunai Seitani e kamadubu kayawena, manako aneya bautagubu Iyesu waitamupu togimupu. ");
INSERT INTO gdn_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Iyapana apunu Diyoni wadumpu diburamupu ki sisiyai Iyesu wainapupu ki ka e ade wirawena tawana Gariri kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","E ika bauwena ka e ebo tawaneya natere Nasareta rabineya eba tondawa ko e kayawena kaniyawa da natere Kaponiyamu bauwena manako ika tondawa. Natere Kaponiyamu ka kaburu kawaya Gariri ki papateya tawana Teburoni yo Natari ragidai mu wairamaga kawareya. ");
INSERT INTO gdn_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","E ika tondawa ki ka Mamanuga God e bonanai waina-piyawa wagawa apunai Aisaiya takari kawaya oka badidi tapu ki mibai wana wenawena yau kena. E oka inako tapu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","‘Tawana Teburoni ade tawana Natari awana Diyoudani papasi buridere egi yawatai deneya ade tawana Gariri iyapana kwaiyanai ragidai mete idiwu ki tawanai, ");
INSERT INTO gdn_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","wi yona yau wainapumuri; Iyapana sisipu rabineya idiwu ki mu ka tanai kawaya mo emupu. Ade sisipu kudeya wainapiyamu idiwu ragidai ki mu kawarimugu ka tanai ki mete minibu siwa.’ ");
INSERT INTO gdn_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mara ki makeya ka Iyesu yona ki mibai dimawagana kerarai birikapupu. E iyapana tadeyawa, wagawa ke; “Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki marai rogobiwena. Ki pokere wi beraga berokoi oragai ki wi karako kamadu-muri wi notaga wirayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Mara ki makeya ka Iyesu kaburu Gariri papateya kaniyawa da apunu Saimoni si daikere Pita ade e yowai Enduru mete kina raubiyo nene kaburu kawaya ki papateya ika puwaritaga-mawa idiwa emitapu. Mu ka kimai wasisinai ragidai bowa madai wada-mana ki nana eboga ki kwaetagamawa. ");
INSERT INTO gdn_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ko Iyesu mu emitapu tadebu, wagubu ke; “Kebomuri nau ewaneya ubumuri. Wi karako raubiyo tepiyamu iwu ki maba nau wi kabuwaniyani da wi kaiwagi iyapana nene iwagi tetamuri.” ");
INSERT INTO gdn_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Mu Iyesu yonai wagubu ki waina-mupu ka mu garugaru mena puwari-muguma ika nakamupu kamadumpu manako kimpu ubumpu e eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Iyesu ade kayawena kaburu papateya kaniyawa ka e apunu Tabadi e gubagaiyoma Diyemesi e yowai Diyoni mete kina mamamaga mete ika waka rabineya puwarimaga badipamawa idiwa emitapu. E mu nene mete wagubu, ");
INSERT INTO gdn_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","manako garugaru mena ka mu kimpu ubumpu mamamaga ki ika waka rabineya kamadumpu manako deni mena Iyesu eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Iyesu tawana Gariri rabineya tawa tawa kuduba bauwena kayawena. E Diyu ragidai mu gurigurimaga tawai rabineya iyapana kabuwatamiyawa mu Mamanuga God e gari rabineya kai-wana e kasiyarai pokaiya idiwana ki yonai bagi kawaya dimawagawa ade iyapana sigiramaga kiyabui ebo ebo ki kuduba mete iyatamiyawa. ");
INSERT INTO gdn_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","E badidi kwaewagawa ki yonai tawana Siriya rabineya kuduba kawayawena kaya-wena ki pokere iyapana ubumpu sigira kiyabui ebo ebo wadumpu ragidai ki waratampu e bameya bautagubu. Iyapana makari kawaya wainapamawa ragidai, iyapana notamaga gogagoga-wagawa kakasimaga meme dokodoko-pupu ragidai, idamaga kerapumaga badabadamawena bisi kayawena ragidai, ade kweya kairapu iyapana giritampu mu rabinamugu idiwa ragidai ki mu kuduba kebompu Iyesu bameya bautagubu manako e ubupu mu iya-tapu. ");
INSERT INTO gdn_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Iyapana ropani kawaya tawana Gariri rabineya idiwa ragidai, natere Ida Esida Kewowena rabineya idiwa ragidai, natere Diyerusaremu rabineya idiwa ragidai, tawana Diyudiya rabineya idiwa ragidai, ade awana Diyoudani papasi buridere idiwa ragidai ki mu kuduba e ewakumapamawa iwa. ");
INSERT INTO gdn_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Iyapana ropani kawaya Iyesu ewakumapamawa iwa emitapu ki ka e kweya mo yapu manako ika kwarisi-wena tondubu. E tadeyau kabukabuwa ragidai bautagubu e kwagaramupu idiwa, ");
INSERT INTO gdn_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","manako e tadebu kabukabuwa, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Iyapana gwedewau mu nuwa-maga notamaga Mamanuga God kataipamana wainapiyamu ko mu kataimaga ka eba kawaya ki pokere mu ida kasikasi maba e bameya bautagamu ki mu mamamatogomono, mibai ka Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana watai ka mu nene. ");
INSERT INTO gdn_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Iyapana gwedewau karako yadi wadamu ragidai ki mu mete mamamatogomono, mibai ka Mamanuga God mu rabinamaga miniyoto kwarisi nuwanusuru tageni. ");
INSERT INTO gdn_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Iyapana gwedewau kwarisitagubu moyamoyakai idiwu ragidai ki mu mete mamamatogomono, mibai ka Mamanuga God e gwede tageyana gwaiyabai wagubu ki e mu tageni. ");
INSERT INTO gdn_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Iyapana gwedewau mu nuwamaga notamaga eyaka mena bagi supasupai idiwana ki mena notapiyamu ragidai ki mu mete mamamatogomono, mibai ka mu badidi notapiyamu ki kuduba mu bananapomoto. ");
INSERT INTO gdn_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Iyapana gwedewau mu kowa-muguma nuwanuwatamiyamu ragidai ki mu mete mamamatogo-mono, mibai ka Mamanuga God e uburoto mu mete nuwanuwa-tamini. ");
INSERT INTO gdn_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Iyapana gwedewau mu rabina-mugu nota bagi mena waina-piyamu ragidai ki mu mete mamamatogomono, mibai ka mu ubumoto yabumugere Mamanuga God empomoto. ");
INSERT INTO gdn_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Iyapana gwedewau kowamuguma nuwarara tagarara idiwu ki dobotamiyamu ragidai ki mu mete mamamatogomono, mibai ka Mamanuga God uburoto e eya munuiyoma mu tadeni. ");
INSERT INTO gdn_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Iyapana gwedewau Mamanuga God e nene bagi supasupai kwaetagamu manako ki pokaiya ka iyapana mu giritamiyamu pasutamiyamu ragidai ki mu mete mamamatogomono, mibai ka aita ewa ka mu Mamanuga God e gari rabineya kaiwoto e kasiyarai pokaiya idiwono. ");
INSERT INTO gdn_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nau pokanere ka iyapana wi wainanimoto siyasiya, wi tagararani-moto, wi wereyakauranimoto ade bera yonai berokoberoko ebo ebo wi narini-moto. Ko mu wi bamagau inako kwae-togomono ki ka wi mamamaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ena, mara ki baiyagisi ki ka wi mibi mamamai idiwoi, mibai ka wi puyoga kawaya ki wi nawanaga usi kunumau tondau. Iyapana wi giriniyamu pasuniyamu ki maba takari kawaya ka iyapana ubumpu Mamanuga God e bonanai wainapamawa tagamawa ragidai inako mete giritamawa pasutamawa.” ");
INSERT INTO gdn_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Wi yewe wairau iyapana kuduba mu paunamugu idiwu ki ka wi midiyaga ka aidaba maba. Ko wainapumuri; Aidaba ki kwerereyagisi e midiyai kewoyagisi ki ka wi badidi maba kwaiwagi da aidaba ki midiyai ade wenapoto? Ae, ki pa mena. Aidaba ki midiyai kewoyagisi ki ka pa mugu da iyapana isiyapomoto taisi kurakura-pomoto. ");
INSERT INTO gdn_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Wi yewe wairau iyapana kuduba mu paunamugu idiwu ki ka wi taniga duna urau ki tanai maba. Iyapana kweya kwauneya natere mo wadumupu, natere ki ka iyapana yabumugu matarau uburau ko eba weki gwaiya uburau. ");
INSERT INTO gdn_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Ade iyapana mosi duna beupoto ki ka e duna ki bani taroto? E kurari umuneya wekepoto bo? Ae, pa mena, e duna matarau taroto manako iyapana e tawai rabineya duna ki taneya idiwono. ");
INSERT INTO gdn_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ki maba, wi wiga taniga duna maba iyapana kawarimugu miniyoto siwa da mu wi iyaga bagi kawaya ki empomoto ki ka mu Mamanuga God Kunumau Tondau e si esida tepapomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Oragai apunai Mosisi gora tapu ade Mamanuga God e bonanai waina-pamawa tagamawa ragidai badidi tagubu ki nau koritapana kwenupana ki nana bausugubuwani bo? Pa mena, wi inako eba wainapiyoi. Nau eba gora oragai ki koritapana ki nana bausugu-buwani ko mu badidi tagubu ki mibai wenawagana ki nana ka nau bausugu-buwani. ");
INSERT INTO gdn_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Nau yona mibai nidiyani wainapumuri; Iyapana badidi maba idiwana ki gorai ka e wateya tondau. Iyapana gora ki wirapamana bo e okai marai munta mo surupamana ki yawatai mo pa mena. Gora oragai tampu ki mibai makeya makeya wena-yagisi kewoyagisi eweya ka kunuma yo waira kuduba gogatagisi. ");
INSERT INTO gdn_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Ki pokere iyapana gwedewau gora oragai ki marai munta mo paerepomoto bo mu kowa-muguma gora marai munta ki kamadamana ki nana kabuwatamini, ki ka aita kunumau Mamanuga God e gari rabineya ka iyapana ki maimeretagisi tariya kawareya idiwono. Ko iyapana gwedewau gora oragai ki makeya makeya kwaetogomono ade kowa-muguma kabuwatamono da mu kwae-tagamu ki kawareya mu kowamuguma inako mete kwaetogomono, ki ka aita kunumau Mamanuga God e gari rabineya ka iyapana ki kawakawaya-tagisi kebari bagi kawaya ki kawareya idiwono. ");
INSERT INTO gdn_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Nau nidiyani wainapumuri; Mamanuga God e gorai kataimugu ragidai ade Parisi ragidai mete kina ki mu wainapiyamu da; ‘Nu ka Mamanuga God e yabuiya bagi supasupai kwaigemei ragidai.’ Ko wainapumuri; Mu bagi supasupai kwaetagamu ki maba wi mete inako kwaiwagi ko ade eba wade ewaiwatamuri, ki ka Mama-nuga God wi iyapana bagi supasupai eba nidini ade e gari rabineya kunumau ki wi eba posiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Gora oragai inako wagau; ‘Kau waretagi eba mini poyo. Kau ki kwae-nuwagi ki ka iyapana kau wadinimoto idamaga gurai kau naurigeya ugwadini-moto ragiragi manako kau paeregi ki bimbinai makeya makeya bita negeni.’ Wi kataigau da takari kawaya ka oragai ragidai gora ki wainapamawa kwae-tagamawa. ");
INSERT INTO gdn_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ko nau nidiyani wainapu-muri; Kau nima waretagi bameya nuwagi pupuwagau ki ka iyapana kau wadinimoto idamaga gurai kau nauri-geya ugwadinimoto ragiragi manako kau paeregi ki denai bita negeni. Ade kau nima yona berokoi pokaiya kau waretagi kirapiyei ki ka iyapana kau wadinimoto kawakawai ragidai mu yabaramugu tamunimoto. Ade kau nima waretagi siyei da e ka notababa apunai ki kau mata nonarai ki yawateya kayanugana kwaenugei. ");
INSERT INTO gdn_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Ki pokere nau ade nidiyani wainapumuri; Kau nima puyo Mamanuga God e kepakepai kawareya tarana kwaenugei manako ki makeya ka kau notagi yagisi ke; ‘Akae, nau waretani bameya kwaesugubuwani siyasiya ki e wainapiyau tondau.’ Kau notagi inako yogono, ");
INSERT INTO gdn_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ki kau puyogi ika kamadi manako kayanuwagi kau waretagi bameya kau paeregi ki wade supasupapi ade besipi were ewa wiranuwagi baunuwagi kau puyogi ki Mamanuga God nene ika tari. ");
INSERT INTO gdn_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Kau gwede mo paerepipi ki gwawai kau iyaragi wadiniyoto kawakawai ragidai mu bamamugu kayayogono ki kau yawatau e mete wibo mena kau paeregi ki wadumuri supasupa. Kau ki eba kwaenuwagi ki ka e uburoto kau wadiniyoto idamaga gurai iyapana naurimugu ugwaditami-yamu ragiragi ragidai mu idamaga rabineya kau tamuniyoto. Tamuniyoto manako mu ubumoto kau wadinimoto supasupa manako ewa wiratagisi pinai ragidai idamaga rabineya kau tamuni-moto da mu ubumoto kau diburanimoto. ");
INSERT INTO gdn_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Nau nidiyani wainapi; Kau dibura rabineya tondowa yarowa da kau paeregi ki denai kuduba kau kewopi were.” ");
INSERT INTO gdn_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Oragai ragidai oka tampu ki wi kataigau. Mu oka inako tampu, tagubu ke; ‘Wi sipuma goragora eba rauru kawakawara kasiwaraiwogoi idiwoi.’ ");
INSERT INTO gdn_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ko nau karako wi nidiyani wainapu-muri; Apunu mo uburoto ridi mo empoto manako e rabineya ridi ki mete ukwapamana poisiyasiyai wainapono ki ka e notai ororeya mena bigiwena sipuma goragora rauru kawakawara-wena. ");
INSERT INTO gdn_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Ki pokere, kau yabugi garu berokoi kwaenugana ki nana weyaweya-niyau taininiyau ki kau kiya uburi yabugi ki wadi toporu kwenupi. Kau inako kwaenuwagi ki kau midigi kwakware-pugi bani makariyagisi ko ki ka eba gwedei mete kina mibai ka aita ewa ka kau bagi kawaya tondowa. Ko kau inako eba kwaenuwagi ki kau bani wainapiyei da kau midigi kwakwarepugi ka bagi kawaya ko aita ewa ka mu kau midigi kwakwarepugi bagi kawaya ki yadini matau kwenupomoto. ");
INSERT INTO gdn_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Ade kau idagi garu berokoi kwaenugana ki nana weyaweyaniyau taininiyau ki kau kiya idagi ki mei puru kwenupi. Kau inako kwaenuwagi ki kau midigi kwakware-pugi bani makariyagisi ko ki ka eba gwedei mete kina mibai ka aita ewa ka kau bagi kawaya tondowa. Ko kau inako eba kwaenuwagi ki kau bani wainapiyei da kau midigi kwakware-pugi ka bagi kawaya ko aita ewa ka mu kau midigi kwakwarepugi bagi kawaya ki kuduba yadini matau kwenupomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Oragai ragidai oka inako mete tampu, tagubu ke; ‘Apunu mosi e wainai kamadana wainapiyau ki ka e anika meyana puru ki okai okapoto kweyoto.’ ");
INSERT INTO gdn_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Ko nau karako nidiyani wainapumuri; Apunu mosi e wainai apunu mo mete eba iwa ko e wainai ki pa asusu ragipupu manako ridi ki ewa kayayagisi apunu kudubai mo uworoto, ki ka e nobomoi yabiri kwaewena siyasiya ki pokaiya ka ridi ki e nobomoi yabiri ki rauru kawakawarapupu. Ade apunu ridi wakeyara uwapu ki e mete kina ka ridi ki e nobomoi yabiri ki rauru kawakawarapupu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Oragai ragidai oka tampu ki wi kataigau. Mu oka inako tampu, tagubu ke; ‘Wi badidi kwaigamana ki nana gwede mo e si pokaiya gwaiyaba kaima-tana Mamanuga God bameya iwagubu ki kuduba wi makeya makeya kwaiwogoi ko eba paerepiyoi.’ ");
INSERT INTO gdn_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ko nau karako nidiyani wainapumuri; Wi gwaiyaba yonai mo iwagi ki ka wi gwede mo e si pokaiya gwaiyaba kaimatana eba iwagi. Wi kunuma si pokaiya gwaiyaba kaima-tana eba iwagi mibai ka kunuma ka Mamanuga God e tondau ki watai. ");
INSERT INTO gdn_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ade wi waira si pokaiya gwaiyaba kaimatana eba iwagi mibai ka waira ka Mamanuga God e kerarai tainipiyau uburau ki watai. Ade wi natere Diyerusaremu e si pokaiya gwaiyaba kaimatana eba iwagi mibai ka natere ki ka nu Kaiwawonuga Kawaya e naterei. ");
INSERT INTO gdn_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Ade wi wiga debaga pokaiya gwaiyaba kaimatana mete eba iwagi mibai ka wi wiga kasiyaraga pokaiya iwagi ki ka gwede mo eba wenayagisi. Wi badidi iwagi ki pokaiya ka wi debaga kumai eyaka mena kwaitana poe bo pinai eba wenapoto. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ko wi yau mena kwaiwagi; Wi wainapiyamu da gwede mo ka pa mena ki ka wi ‘pa mena’ iwagi, ade wi waina-piyamu da gwede mo ka mibai ki ka wi ‘mibai’ iwagi. Wi yona ki kawareya gwede mo iwagi, yona ki kuduba ka Berokoi Apunai e deneya bauwagau.” ");
INSERT INTO gdn_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Oragai ragidai oka tampu ki wi kataigau. Mu oka inako tampu, tagubu ke; ‘Apunu mosi e waretai yabui mini-yoto sukwana ki ka bidara wadubu apunai ki gwawai uburoto e waretai ki yabui mete miniyoto sukwana. Ade apunu mosi e waretai uwarai miniyoto siwa ki ka bidara wadubu apunai ki gwawai uburoto e waretai ki uwarai mete miniyoto siwa.’ ");
INSERT INTO gdn_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ko nau karako wi nidiyani wainapumuri; Iyapana mosi gwede berokoi mo kau bamageya kwaeyogono ki kau denai bimbina eba wadi. E kau kwanabugi garu minibu ki kau denai e eba mini ko kamadi da e kau kwanabugi tenene ki mete miniyoto ka baganai. ");
INSERT INTO gdn_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Ade kau waretagi mo bameya kau kwaenugibi siyasiya manako e denai kau midigi tatamai kweyana ki nana yagisi ki kau eba kau midigi tatamai ki mena rikapi kwei ko nusuru tatamai ki mete kwei. ");
INSERT INTO gdn_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Ade piyara apunai mosi kau e waitapana yawata eba rowarowa e igwai ketowa-pana wagau ki kau yawata rowarowai-tau ade yari e igwai ketowapi were kwei. ");
INSERT INTO gdn_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Ade iyapana mosi kau gwede-gwedegi ki genei yagisi ki kau e kwei, ade iyapana mosi baiyagisi kau gwede-gwedegi pa wadana empana ki nana yagisi ki kau eba gwandagi nuwagi ko kamadi da e yadini.” ");
INSERT INTO gdn_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Oragai ragidai oka tampu ki wi kataigau. Mu oka inako tampu, tagubu ke; ‘Wi kowaguma nota kwarikwarisi-tamiyoi ko wi iyaraguma keitamiyoi.’ ");
INSERT INTO gdn_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Ko nau karako nidiyani wainapu-muri; Wi iyaraguma ki mete nota kwarikwarisitamuri ade wi giriniyamu pasuniyamu ragidai ki mu nene ka wi Mamanuga God bameya guriguriwagi. ");
INSERT INTO gdn_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Wi inako kwaiwagi ki ka wi kunumau tondau apunai Mamanuga God e munuiyoma mibai. E yagisi ki ka e umuneya madega uburoto iyapana bagai ade eba bagai ki mu kawarimugu tapapoto, ade e yagisi ki ka e umuneya nawaya baiyagisi iyapana supasupai kwaetagamu ragidai ade eba supasupai kwaetagamu ragidai ki mu kawarimugu kaworoto. ");
INSERT INTO gdn_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Kau nota kwarikwarisi-niyamu ragidai ki mu mena denai nota kwarikwarisitamiyowa ki ka Mamanuga God kau gwede nana wadiniyoto bagi? Kau kwaenugibi ki ka eba gwede kawaya mosi. Iyapana takesi wadamu ragidai ki mu mete inako kwaetagamu. ");
INSERT INTO gdn_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ade kau kowagiyoma nuwageya po ragidai ki mu mena waretatamiyowa mete yonaiwogoi ki kau gwede bagi mo eba kwaenugibi. Mamanuga God eba kataimugu ragidai ki mu mete inako kwaetagamu. ");
INSERT INTO gdn_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Ki pokere, wi Mamaga kunumau tondau e bagi supasupai mena kwaewagau ki maba wi mete inako bagi supasupai mena kwaiwogoi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Iyesu yona ade mosi tadebu, wagubu ke; “Naigida mena idiwoi. Wi gwedegwede kuduba Mamanuga God nene kwaiwogoi ki ka eba iyapana wi eminimana ki nana kwaiwogoi ko wi weki gwaiya mena kwaiwogoi. Wi iyapana eminimana ki nana kwaiwagi ki ka wi Mamaga kunumau tondau aita puyo wi eba negeni. ");
INSERT INTO gdn_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Ki pokere wi iyapana gwedegwede-maga pa mena ragidai waitatamana wainapiyamu ki ka eba iyapana wi eminimana ki nana yonai iwagi kawaya ko giyansu mena mu waitatamuri. Iyapana midimaga pa matakawagau ragidai ki mu maba wi inako eba kwaiwogoi. Mu ka guriguri tawai rabineya ade imatau noda gongomu-tagamu iyapana mu emitamana simaga tepapamana ki nana matarau kwae-tagamu. Nau yona mibai nidiyani wainapumuri; Mu upimaga denai ka mu yewe wairau wadumpu kewowena. ");
INSERT INTO gdn_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Wi iyapana waitatamana ki nana waina-piyamu ki ka wi matarau iyapana yabumugu mu eba waitatamuri ko wi wibo mena weki gwaiya mu waitata-muri da kowaguma wi bagi badidi kwaigubu ki sisiyai mete eba kataitagisi. ");
INSERT INTO gdn_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Wi inako kwaiwagi ki ka wi Mamaga ki nu weki gwaiya badidi kwaigemei ki kuduba matarau empiyau apunai ki e uburoto denai puyo wi negeni.” ");
INSERT INTO gdn_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Wi Mamanuga God bameya gurigurigamana kwaiwagamu ki ka wi iyapana midimaga pa matakawagau ragidai ki mu maba inako eba guri-guriwogoi. Mu ka iyapana mu emita-mana ki nana guriguri tawai rabineya ade imatau mete kina matarau ubumu guriguritagamu. Nau yona mibai nidiyani wainapumuri; Mu denimaga ka mu ororeya mena wadumpu kewowena. ");
INSERT INTO gdn_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Wi gurigurigamana kwaiwagamu ki ka wi wibo tawaga rabineya kaiwuri gudu umamuri manako wi Mamaga ki nu yabunugu matarau eba empemei apunai ki e bameya guriguriwagi. Wi inako kwaiwagi ki ka wi Mamaga ki nu weki gwaiya badidi kwaigemei ki kuduba matarau empiyau apunai ki e uburoto wi bagi kawaya kwaigubu ki denai puyo wi negeni. ");
INSERT INTO gdn_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Wi Mamanuga God bameya gurigurigamana kwaiwagamu ki ka wi iyapana kwaiyanai ragidai mu buburi-maga kororai mibi pa mena rowarowa kawaya tagamu kaiwu idiwu ki mu maba wi inako eba guriguriwogoi. Mu notapiyamu da; ‘Nu rowarowa kawaya inako buburigomu ki ka e nu waina-niyoto’. Mu inako notapiyamu, ");
INSERT INTO gdn_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ko wi mu maba inako eba kwaiwogoi. Wi nuwaga notaga kuduba ki Mamanuga God e matarau empiyau ki pokere wi gwede nene wainapiyamu ki e ororeya mena kataiwena kewowena were ewa wi e bameya gurigurigubu. ");
INSERT INTO gdn_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wi Mamanuga God bameya guriguriga-mana ki wi guriguri yau maba iwagi; ‘Mamanuga, kau ka Kunumau tondei. Nu nuwanugu kau sigi bagi kawaya ki kawayayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Nu nuwanugu kau garigi rabineya kaiwana kau kasiyaragi pokaiya idiwana ki marai baiyagisi. Nu nuwanugu kau kaubo nuwageya kunumau badidi wainapiyei kwaenugei ki maba kau yewe wairau inako mete kwaenuwagi da wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Nu baninuga karako nene waina-pemei ki kau nege. ");
INSERT INTO gdn_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ade kowanuguma berokoi nu bamanugu kwaetagubu ki nu nubo notanugu deni mena surumipi ki maba berokoi nu kwaigibi ki kuduba kau mete kau kaubo notageya deni mena surupi. ");
INSERT INTO gdn_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Kau kwayubaniyo da gwede ragiragi mosi eba baiyagisi nu nukeniyoto, ade kau Berokoi Apunai bodapi da e eba baiyagisi nu giriniyoto. Kau ka Kaiwawo maramara tondei. Kau kasiyaragi ade kau tanigi kawaya ki mara-mara tondono kaniyono. Ki mibai.’ Wi inako guriguriwagi. ");
INSERT INTO gdn_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Ade yona yau mete wainapumuri; Iyapana bera berokoi mo wi bamagau kwaetagubu ki ka mu berokoi badidi kwaetagubu ki wi notagau deni mena surupumuri. Wi inako kwaiwagi ki ka wi Mamaga kunumau tondau ki e mete uburoto wi bigi badidi kwaigubu ki kuduba deni mena notagogapoto. ");
INSERT INTO gdn_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ko iyapana bera berokoi mo wi bamagau kwaetagubu ki wi notagau deni mena eba surupumuri ki ka wi Mamaga kunumau tondau ki e mete wi bigiga ki eba empoto notagogapoto. Pa mena.” ");
INSERT INTO gdn_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Wi gurigurigamana ki nana Mamanuga God e nene bani kamadu-muri ki ka wi iyapana midimaga pa matakawagau ragidai badidi kwae-tagamu ki mu maba wi inako eba kwaiwogoi. Mu ka kiyabumaga nuwa-boya kiyabui maba idiwu da iyapana mu kiyabumaga ki empamana manako ki pokaiya kataitagamana da mu Mamanuga God nene bani kamadumpu idiwu. Ko nau nidiyani wainapumuri; Mu kwaetagubu ki denai ka mu wadu-mupu kewowena. ");
INSERT INTO gdn_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Wi Mamanuga God e nene bani kamadumuri ki ka wi kiyabuga siruwapumuri monagaiwagi ade wi debaga isiwaripumuri. ");
INSERT INTO gdn_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Wi inako kwaiwagi ki ka iyapana wi midiga bagi kawaya ki empomoto manako eba kataitagisi da wi Mamanuga God nene bani kamadumpu idiwu. Wi Mamaga ki nu yabunugu eba empemei apunai ki e mena kataiya. E ka wi weki gwaiya badidi kwaiwagamu ki kuduba matarau empiyau apunai ki pokere aita ewa ka e uburoto wi badidi kwaigubu ki denai puyo negeni.” ");
INSERT INTO gdn_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Wi gwedegwedega yewe wairau eba bondaiwogoi magara miniyoi. Yewe wairau ka ketere baitagisi wi gwede-gwedega purupomoto ade wi gwede-gwedega niniyagisi. Ade kuwa ragidai mete baitagisi wi tawaga baupomoto wi bondaga magara nakamupu ki kuwa-tagisi. ");
INSERT INTO gdn_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Ko wi Mamanuga God e nene kwaiwogoi ki ka wi deniga ki e kunumau wi nene puyo tapu ki kawayayogono yarono. Kunumau ka ketere eba bai-tagisi wi puyoga ki purupomoto ade wi puyoga ki eba niniyagisi. Ade kuwa ragidai mete eba baitagisi wi deniga ki kuwatagisi. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wi yewe wairau magaraga damupumuri ki ka wi nuwaga notaga waira yau purapurai ki mena kawareya ukworono. Ko wi magaraga kunumau damupumuri ki ka wi nuwaga notaga kunuma purapurai ki mena kawareya ukworono.” ");
INSERT INTO gdn_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Wi yabuga ka wi kwakwarepuga ki dunai. Wi yabuga bagi negai kawaya ki ka wi midiga kwakwarepuga mete tanai kawaya, ");
INSERT INTO gdn_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ko wi yabuga gwaku-gwakuyagisi berokoyagisi ki ka wi midiga kwakwarepuga tanai ki sisipupoto. Ki maba, tanai wi rabinagau ki sisipuyagisi, akae, ki ka wi rabinagau sisipu kawaya umoroto.” ");
INSERT INTO gdn_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Iyapana mosi e kawakawaiyoma apeya mu bigabigamaga kwaeyogono ki ka e badidi maba mo yogono ki e umunui yodono ade wirayogono mo yogono ki e umunui mete yodono? Ki pa mena mibai ka e uburoto mosi nota kwarikwarisipono ko ade mosi keipono ade uburoto mosi e diriwai kwaeyogono ko ade mosi tagararapono. Ki maba, wi Mamanuga God e nene wainapamana wainapiyamu ki ka wi waira yau gwedegwedei nene notagogapumuri. Ade wi waira yau gwedegwedei nene wainapamana wainapiyamu ki ka wi Mamanuga God notagogapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Ki pokere, nau nidiyani wainapu-muri; Wi karako yewe idiwana ki iyai nene eba wainapiyoi. Wi masura kupamana bo awana kubamana bo midi tatamai umamana ki bani deneya baiyagisi ki nene wi eba wainapiyoi bo nuwaboyaiwogoi. Bani ka eba gwede kawaya mosi ko wi iyaga ka kawaya esida. Ade sipuma goragora ka eba gwede kawaya mosi ko wi midiga kwakwarepuga ka kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Nau keyakeyai mosi midiwari naureya nidiyani ki wi wainapumuri; Midiwari iyarau iwu ki mu upi eba kwaetagamu, mu raupomu eba kwaetagamu, ade mu bani magara nakapamana tawai pa mena, ko mu banimaga ka Mamanuga God maramara mu tageyau iyatamiyau. Mamanuga God e yabuiya wi ka kawaya esida ko midiwari mu ka erida. ");
INSERT INTO gdn_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wi yewe wairau idiwana ki iyai nene wainapiyoi nuwaboyaiwogoi ki ka wi iyaga ki pokaiya eba rowarowayagisi. Pa mena, wi iyaga piri munta mena mete eba rowarowayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Wi sipuma bo goragora umamana ki nuwaboyai mete eba wainapiyoi nuwaboyaiwogoi. Nau keyakeyai mosi paraparawasi naureya kabuwaniyani ki wi wainapumuri; Paraparawasi mu ka eba upitagamu ade mu kwakwarepu-maga sikwapamana nene mete eba wainapiyamu, ");
INSERT INTO gdn_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ko wainapumuri; Kaiwawo Soromoni e ka purapura apunai ade e gwedegwedei umapu monagawena ki tanai ka kawaya, ko e gwedegwedei ki tanai ka ade marai munta erida ko paraparawasi mu tanimaga Mamanuga God mu pa tagebu ki tanai ka kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Gwaba karako kasiga uburau ko tawiri pasumoto ki uroto kewoyagisi, ko wainapumuri; Mamanuga God gwaba kaina ki pa monagatamiyau ki ka e sipuma goragora wi negeni monaganiyoto bo? Ena e wi negeni monaganiyoto. Akae, wi sumaga Mamanuga God bameya ka marai munta erida wainapakani. ");
INSERT INTO gdn_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Ki pokere wi bani kupamana bo awana kubamana ki nene eba wainapiyoi nuwaboyaiwogoi, ade wi gwedegwede umamana ki nima negeyana ki nene mete eba notapiyoi. ");
INSERT INTO gdn_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Mamanuga God eba kataimugu ragidai tawana tawana idiwu ki mu inako notapiyamu kwaenetagamu iwu, ko wi Mamaga kunumau tondau ki e kataiya da wi bani pa mena ade gwedegwede pa mena pa idiwana ki ka eba baganai. ");
INSERT INTO gdn_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Wi e gari rabineya idiwana ki kwaenei mena kwaiwogoi ade wi nuwaga notaga e nuwaiya badidi wainapiyau ki mena supasupai makeya makeya kwaiwogoi ki ka e bani yo gwedegwede kuduba inako deni mena wi negeni. ");
INSERT INTO gdn_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Ki pokere mara marawani nene ki wi karako eba notapiyoi nuwaboya-iwogoi. Mara marawani baiyagisi ki ka wi e bitai bo e nuwaboyai kataiwagi, ko wi eba karako ki notapiyoi nuwaboya-iwogoi. Mara marawani ki ebo marawani nene ade mara karako ki ebo karako nene.” ");
INSERT INTO gdn_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Iyesu ade tadebu, wagubu ke; “Wi kowaguma emitamuri ki ka wi garugaru mena mu eba waigubatamuri da Mamanuga God wi mete eba waigubaniyoto. ");
INSERT INTO gdn_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Wi iyapana gwede maraitau tagemuri ki denai ka Mama-nuga God wi maraitau negeni, ade wi iyapana gwede kawaya daganani tagemuri ki ka Mamanuga God denai kawaya daganani wi negeni.” ");
INSERT INTO gdn_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Iyesu inako wagubu, manako ade tadebu, wagubu ke; “Kau nima waretagi e yabuiya gwede mugu marai munta mo kenepupu empipi nuwegei ki kau badidi pokere kau kiya yabugeya ripa tapai kawaya mo kenepupu ki eba empipi were nuwegei. ");
INSERT INTO gdn_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Kau gwede nana yabarayabara kau waretagi siyei, nuwegei ke; ‘Kabai, kau yabi da nau waitaniyani mugu marai munta kau yabugeya supu ki koritapani.’ Kau gwede nana inako nuwegei ko ripa tapai kawaya kau kiya yabugi kenepupu ki kau eba empipi were nuwagibi? ");
INSERT INTO gdn_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Wi ka midiga pa matakawagau ragidai. Wi yabiri ripa tapai kawaya wi wiga yabuga kenepupu ki koritapumuri da wi tawana naigida empumuri were ewa ka wi kowaguma yabumugu mugu marai munta kenepupu ki waitatamuri koritapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Gwede bagi Mamanuga God e nene ki wi taku eba tagemuri kwaenda taku ade wiratagisi wi wiga menimoto. Ade wi taene monabu bagi kawaya ki wi boyo yabaramugu eba nakapumuri kwaenda boyo dogiya mete taisi kurakurapomoto utapomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Nau suwagani ki wi naigida mena wainapumuri; Wi Mamanuga God bameya badidi iwagi ki e negeni. Wi iya yawatai kwaenepumuri ki ka e yawata ki wi kabuwaniyoto. Wi e gudui mini-muri ki ka gudu ki wi nene siwayagisi, ");
INSERT INTO gdn_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","mibai ka iyapana gwedewau Mama-nuga God bameya genetogomono ki ka e denai mu tageni. Ade iyapana gwedewau kwaenetogomono ki ka mu mibai bananapomoto. Ade iyapana gwedewau gudu minimono ki ka gudu ki mu nene siwayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Wi gwedewau munuguma mete kina ki wi yona yau wainapumuri; Wi munuga mosi baire nene yagisi ki ka wi e bowa kwemuri kupoto bo? Ae, pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Ade e menamena kupana nene yagisi ki ka wi e motamota berokoi kugura kwemuri da e ki kupoto bo? Ae, pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ki pokere wainapumuri; Wi iyapana kaina yewe wairau idiwu ki wi ka eba bagi ko wi munuguma mu bamamugu ka wi bagi mena kwaiwa-gamu puyo ebo ebo bagi mena mu tageyamu. Ki maba, Mamanuga God e ka bagi kawaya esida kunumau tondau ki apunai ki pokere nu mete kataigibi wetawetara da iyapana gwedewau e bameya genetagisi ki ka e denai puyo bagi ebo ebo ki mena mu tageni. ");
INSERT INTO gdn_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ki pokere, wi nuwagau iyapana wi bamagau badidi kwaetagamana waina-piyamu ki wi yabiri mu bamamugu inako mete kwaiwogoi. Oragai apunai Mosisi gora tapu ade Mamanuga God e bonanai wainapamawa tagamawa ragidai badidi tagubu ki mibai kuduba ka ki kena.” ");
INSERT INTO gdn_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Wi kunuma katamurui kapo-kaporoi ki rabineya kaiwuri. Bita wadamana tawanai ki katamurui ka dadarai kawaya ade yawata ki kayatagamana ka eba ragiragi ki pokere iyapana ropani kawaya yawata ki kayatagamu. ");
INSERT INTO gdn_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Ko iya yawatai ki katamurui ka kapokaporoi ade yawata ki kayatagamana ka ragiragi kawaya ki pokere iyapana eba ropani yawata ki bananamupu kayatagaubu.” ");
INSERT INTO gdn_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Iyesu iyapana ade tadebu, wagubu ke; “Mamanuga God e yonai mu mubo notamaga pokaiya beratagamu tagamu iwu ragidai ki mu wi naigida mena emitamiyoi. Mu midimaga kwakwarepu-maga matarau empumuri ka papa sipi maba moyamoyakai ko mu rabinamugu ka berokoi taku kamarai wasibena maba tayatayabadai. ");
INSERT INTO gdn_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Mu badidi kwae-tagamu ki pokaiya ka wi mu kiyabumaga kataiwagi. Gaya madai kauma eba wenapoto ade impunewa madai damaya eba wenapoto. ");
INSERT INTO gdn_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ripa iruirui kawaya ka mibai bagi kawaya naigida mena kiroto ko ripa wayowayoi ka mibai kiroto siyasiya. ");
INSERT INTO gdn_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ripa iruirui kawaya ka mibai berokoi eba kiroto, ade ripa wayowayoi ka mibai bagi kawaya eba kiroto. ");
INSERT INTO gdn_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Nau nidiyani wainapumuri; Ripa mosi e mibai eba kirau ki ka mu ripa ki meyomoto yadini matau kwenupomoto. ");
INSERT INTO gdn_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Ki maba, iyapana mu mubo notamaga pokaiya Mamanuga God e yonai beratagamu tagamu iwu ragidai ki mu badidi tagamu kwaetagamu iwu ki pokaiya ka wi mu kiyabumaga matarau emitamuri.” ");
INSERT INTO gdn_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Nau nidiyani wainapumuri; “Iyapana ropani kawaya nau sidiyamu tagamu ke; ‘Kaiwawoni, Kaiwawoni.’ Mu inako tagamu ko mu dai mena ka Mamanuga God e gari rabineya kunumau baitagisi. Iyapana gwedewau nau Mamai kunumau tondau e nuwaiya badidi wainapiyau ki makeya makeya kwaetagamu ragidai ki mu mena ka e bameya baitagisi. ");
INSERT INTO gdn_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Mamanuga God e idai gurai iyapana kuduba mu nauri-mugu ugwaditamana ragiragi ki marai baiyagisi makeya ka iyapana ropani kawaya baitagisi nau sidini, tagisi ke; ‘Kaiwawoni, Kaiwawoni, nau kau sigi pokaiya Mamanuga God e yonai dimasugekeya ade kau sigi pokaiya ka nau kweya kairapu ropani kawaya siwakeketamekeya ade matakira ebo ebo mete kwaesugekeya mibai wena-piyawa.’ ");
INSERT INTO gdn_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Mu inako tagisi ko nau denai mu tadeyani, suwagani ke; ‘Wi bani baigubu? Nau eba kataineya wiyo. Wi ka bera berokoi kwaiwagamawa ragidai ki pokere kamadisinimuri kaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Iyapana nima nau bamaneya baiyagisi manako nau yonani suwagu-buwani ki makeya makeya kwaeyogono ki e iyai badidi maba ki keyakeyai nau karako suwagani wainapumuri; E ka apunu notanotai mosi ki e tawai bebedai ki urubai rorowa kawakawaya ukwatapu supu bebeda nunutapu ki maba. ");
INSERT INTO gdn_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nawaya aniyata wagubu ade awana goya ade nusuru bauwena tawa ki kweyana gwairi kwaewagawa, ko e tawa ki bebedai rorowa kawakawaya ukwatapu nunutapu ki pokere tawa ki eba gwairiwena. ");
INSERT INTO gdn_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ko iyapana nima nau yonani yau wainapoto ko makeya makeya eba kwaeyogono ki ka e notababa apunai ki e tawai bebedai ki urubai iyaruiyaru ukwatapu nunutapu ki maba. ");
INSERT INTO gdn_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Nawaya aniyata wagubu, awana goya bauwena ade nusuru tapu tawa ki minibu da tawa ki deni mena gwairiwena rorororowena.” ");
INSERT INTO gdn_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Iyesu yona ki wagubu kewowena makeya ka iyapana kuduba e yonai wainamupu mu notamaga kowena kodabamaga kamupu, ");
INSERT INTO gdn_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","mibai ka e kabuwai ka kasiyarai kawaya ko Mama-nuga God e gorai kataimugu ragidai ki mu kabuwamaga ka kasiyarai pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Iyesu kwaunai ki kamadubu kawarawa ka iyapana ropani kawaya e ewakumamupu. ");
INSERT INTO gdn_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ki makeya ka apunu mosi sigira berokoi wadubu e kwakwarepui kwatakwatawena ki bauwena Iyesu empupu. E garugaru mena yabadubu Iyesu yabareya kwarisi-wena e ramatai kawareya ubupu manako genepupu, wagubu ke; “Kaiwa-woni, kau kaubo nuwageya ko kau nuwanuwasiniyei ki kau nau wadisini bagi.” ");
INSERT INTO gdn_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Iyesu apunu ki e nuwaboyai wainapupu ki pokere e idai roronapupu apunu ki e mideya tapu manako sibu, wagubu ke; “Nau nuwaneya kau iya negeyani ki pokere kau sigiragi ki nau karako surupakani da kewoyagisi.” Iyesu yona ki wagubu makeya ka apunu ki e sigirai garugaru mena kewowena e midi wateya wateya bauwena manako e iyawena. ");
INSERT INTO gdn_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ko Iyesu apunu ki tatama-pupu, wagubu ke; “Nau karako iyani-buwani ki sisiyai kau iyapana eba tade ko kau deni mena Mamanuga God Bameya Dobopiyamu Ragidai mu bamamugu kayanuwagi da mu kau eminimoto manako ewa kayanuwagi oragai apunai Mosisi gora tapu ki makeya makeya kwaenuwagi Mama-nuga God bameya puyo tari. Kau inako kwaenuwagi ki ka iyapana kawakawai kau eminimoto manako mibipomoto da kau sigiragi wana kewowena.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Iyesu natere Kaponiyamu rabineya bauwena ka tawana Roumi ragidai mu piyaramuguma kawaimaga mosi e ika bananapupu manako waita nene Iyesu genepupu sibu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Kaiwa-woni, nau bigabigani apunai sigira kawaya wadubu e idai kerarai bada-badamawena bisi kawayawena kebari kawareya makariwagau ukwarau.” ");
INSERT INTO gdn_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Iyesu yona ki wainapupu, ka e denai sibu, wagubu ke; “Baganai, kaigomu da nau e empani iyapani.” ");
INSERT INTO gdn_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","E inako wagubu, ko piyara apunai ki garugaru mena denai wagubu ke; “Kaiwawoni, ki pa mena. Kau ka apunu bagi kawaya ko nau ka eba bagi da kau nau tawaneya yari. Kau pa yona mena nuwagi manako nau bigabigani apunai iyayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Nau mete kina ka iyapana kawakawai dai mu kobamugu ade nau kobaneya ka piyara dai mete kina. Nau mu kayatagamana suwagani ki mu kayatagisi. Nau mu kebomana suwagani ki mu kebomoto. Ade nau bigabigani apunai nau bigani mo kwaewagana siyani ki e nau bigani ki kwaeyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Iyesu yona ki wainapupu, ka e notai wagubu ke; “Akae, apunu yau e sumai ka kawaya.” E inako notapupu manako wirawena iyapana ropani kawaya e ewakumapamawa ika ubu-mawa ki tadebu, wagubu ke; “Nau nidiyani wainapumuri; Tawana Isiraero ragidai wi paunagau ka nau apunu yau e sumai maba mo eba bananapuwani. ");
INSERT INTO gdn_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Nau yona mibai nidiyani wainapu-muri; Iyapana kwaiyanai ragidai tawana tawana kuduba madega kau-wagau madega posiwagau were bai-tagisi manako kebomono Mamanuga God e gari rabineya kunumau wi ripakwarakwaraguma Eburamu, Aisiki ade Diyaikapu mete kina mu mete ewapuru mamamatogomono bani kupomono idiwono. ");
INSERT INTO gdn_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Wi Diyu ragidai wi ka Mamanuga God e gari rabineya idiwana ki ragidai ko wi eba suma-iwagamu ki pokere Mamanuga God uburoto wi teniyoto matarau gari tagaiya sisipu rabineya isiyaniyoto manako wi ika makariwogoi uwariga sisiripiyoi ‘aige, aige’ iwogoi idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Iyesu inako wagubu manako wira-wena piyara apunai ki sibu, wagubu ke; “Kau tawageya ade kayanuwagi. Kau nau sumasinibi ki pokere kau bigabigagi apunai ki iyayagisi.” Iyesu yona ki wagawa makeya ka piyara apunai ki e bigabigai apunai deni mena iyawena. ");
INSERT INTO gdn_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ki eweya ka Iyesu apunu Pita e tawaiya kayawena. Apunu Pita e memenagui ridai muyamuyawena ika kebari kawareya ukwarawa, ");
INSERT INTO gdn_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ki pokere Iyesu kanibu e idai ridi ki kawareya tapu manako ki makeya ka e muyamuyawena ki deni mena kewowena manako e kipu ubupu kanibu Iyesu diriwai kwaewena bani dai warapupu kwebu. ");
INSERT INTO gdn_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Kemorawagawa ka iyapana ubumpu kowamuguma kweya kairapu rabinamugu idiwa ki tetampu Iyesu bameya bautagubu manako e yona mena pokaiya keyai berokoi kuduba ki siwakeketapu bautagubu kayatagubu ade sigira ragidai kuduba mete iyatapu. ");
INSERT INTO gdn_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Mamanuga God e bonanai waina-piyawa wagawa apunai Aisaiya takari kawaya wagubu oka tapu ki mibai wana wenawena yau kena. E oka tapu ki inako wagubu ke; ‘Sigira ebo ebo nu umeme dokodokonibu ki e rikapupu wadubu kayawena.’ ");
INSERT INTO gdn_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Iyapana ropani kawaya bautagubu Iyesu kwagaramupu emitapu ka e tadeyau kabukabuwa ragidai tadebu da e yo mu ewapuru waka kawareya kaburu papasi daikere kayatagamana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ki makeya ka Mama-nuga God e gorai ki kataiya apunai mosi bauwena Iyesu sibu, wagubu ke; “Sidiyei Kabukabuwa Apunai, kau kayanuwagi tawa tawa umowa ki nau kau ewakumaniyoni mete iwomu.” ");
INSERT INTO gdn_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","E inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Taku kamarai ki mu ka waira umuneya ukwapamu gawara-maga mete kina. Ade midiwari iyarau iwu ki mu ka tawamaga ripa kawareya mete kina. Ko nau Kunumau Kawa-puwani Apunai gawara nau ukwarana bo aiyatasugana ki watai mo pa mena.” ");
INSERT INTO gdn_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","E tadeyau kabukabuwa apunai mosi bauwena e sibu, wagubu ke; “Kaiwawoni, kamadisini da nau yabiri kayasugani nau mamai powena ki ononopani were ewa ki nau bausugani kau ewageya kayasugani.” ");
INSERT INTO gdn_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Apunu ki inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Iyapana keyaimaga powena ragidai ki mu mena ubumoto popotagubu ragidai onono-tamini, ko kau kiya uburi nau ewaneya yabodowa.” ");
INSERT INTO gdn_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Iyesu e tadeyau kabukabuwa ragidai mete kina waka kawareya yamupu. ");
INSERT INTO gdn_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Mu kayatagubu kaiwa ka nusuru kawaya mo garugaru mena bauwena towawa wirawena yabadubu waka rabineya posiwena da waka waunitau kaburu surana kwaewagawa. Ko Iyesu ika waka rabineya ukwarawa, ");
INSERT INTO gdn_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ki pokere e tadeyau kabukabuwa ragidai kaimupu e wadumupu yabuyabu manako simupu, tagubu ke; “Kaiwawo-nuga, nu waunitau popoigamana kwaigemei ki pokere garugaru mena waitaniyo.” ");
INSERT INTO gdn_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Wi gwede nana kudu wainapiyamu? Wi sumaga ka eba kawaya.” E inako wagubu manako ubupu ragiragi kawaya nusuru towawa tadebu manako ki makeya ka nusuru pamenawena, towawa bigawena, manako kaburu kwarisiwena ukwapu. ");
INSERT INTO gdn_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Iyapana kuduba matakira ki emupu ka mu notamaga kowena kodabamaga kamupu, tagubu ke; “Apunu yau e ka nima? E bonanai ragiragi kawaya wagubu makeya ka nusuru yo towawa e umunui wadumupu.” ");
INSERT INTO gdn_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Iyesu e tadeyau kabukabuwa ragidai mete kina waka kawareya kayatagubu kaiwa da papasi buridere Gadara ragidai mu tawanamugu bau-tagubu. Bautagubu ka iyapana apeya ika idiwa ki Iyesu emupu manako matarau bautagubu. Mu tawa rabineya eba idiwa ko popotagubu ragidai nakapiyamu wateya ki ragumaga rabineya ukwapamawa. Kweya kairapu iyapana apeya ki mu rabinamugu idiwa ki kasiyara tagemawa da mu yawira kwaetagamawa ki pokere tawana ki ragidai mu kudumugu wainapamawa ragu ki yawatai deneya eba iwa. ");
INSERT INTO gdn_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Iyapana apeya ki Iyesu ika bauwena emupu ka mu kwetagubu bonanamaga ragiragi kawaya e simupu, tagubu ke; “Nu katainugu da kau ka God e Gubagai. Nu bita wadamana marai ki eba bauwena ko nu nawananuga tondau ki pokere kau karako gwede berapana ki nana nu bamanugu baunugibi?.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Karako kweya madanai daikere eba uwama ka papa boyo ropani kawaya eba bigabigai buri sipura-tagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Kweya kairapu papa boyo ki emitampu ka mu Iyesu genemupu, tagubu ke; “Kau nu siwakekeniyana ki nana baunugibi ki kau tononiyo da nu kaigamu bo buri rabinamugu teteigamu idiwomu.” ");
INSERT INTO gdn_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Ki baganai, kaiwagi.” Iyesu inako wagubu manako ki makeya ka keyai berokoi ki kimpu ubumpu iyapana apeya ki kamaditampu matarau bautagubu kayatagubu kaiwa da bo ki rabinamugu tetetagubu. Ki makeya ka bo ki kuduba yabaramaga babawena kweya ki erida mena garugarumupu kaburu sikisiki-mupu manako nonamaga kubabu da mu kuduba popotagubu gawarara. ");
INSERT INTO gdn_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Bo baikamutagamawa ragidai ika idiwa badidi wenawena ki mu mubo yabumugere emupu ki ka mu wakapa-tagubu kayatagubu natere ki rabineya badidi wenawena sisiyai ade iyapana apeya rabinamugu kweya kairapu idiwa mu bamamugu badidi wenawena ki sisiyai mete kina iyapana tademawa iwa. ");
INSERT INTO gdn_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Iyapana yona ki wainamupu ka mu kuduba Iyesu empamana ki nana kayatagubu manako mu e bameya bautagubu ka mu e baiyonomupu da e mu tawanamaga ki kamadana kayawagana ki nana simupu. ");
INSERT INTO gdn_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Iyesu waka kawareya yapu manako wirawena e ebo tawaneya kaya-wena. ");
INSERT INTO gdn_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","E ika bauwena ka iyapana dai mu waretamaga sigirawena e idai kerarai badabadamawena bisi kaya-wena kebari kawareya ukwarawa ki kawaramupu e bameya bautagubu. Mu sumamaga kawaya Iyesu bameya ki e empupu ki pokere e sigira apunai ki sibu, wagubu ke; “Gubagani, kau kasiyara wainapi. Kau bigigi ki nau empuwani karako deni mena surupakani.” ");
INSERT INTO gdn_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Iyesu yona ki wagubu ka Mama-nuga God e gorai kataimugu ragidai ika idiwa wainamupu manako mu deni deni manu kasiwaratagamawa, tagamawa ke; “Apunu yau ka Mamanuga God e si giripiyau wainapemei.” ");
INSERT INTO gdn_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Mu inako notapamawa ko mu notamaga ki kuduba Iyesu empupu kewowena ki pokere e mu manutapu, wagubu ke; “Wi gwede nana karako nota berokoi inako wi rabinagau wainapiyamu? ");
INSERT INTO gdn_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","6","Nau e bigi surupana suwagubuwani ko wi bera umani nau sidimpu mibai ka wi wainapiyamu da ki ka pa yona da muyai pa mena. Ko nau karako yona ade mosi suwagani manako wi nau matakirani muyai kawaya empumuri. Nau Kunumau Kawapuwani Apunai iyapana bigimaga empana surupana ki nana ki kasiyarai wadubuwani ki wi karako nau mibisini-muri.” E inako wagubu manako wira-wena sigira apunai ki sibu, wagubu ke; “Kau kiri uburi kebarigi ewopi kawarapi kau tawageya kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Iyesu yona ki wagawa makeya ka apunu ki garugaru mena kipu ubupu e ebo tawaiya kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Iyapana kuduba ika idiwa matakira ki emupu ka mu notamaga kowena kudu mete wainamupu, tagubu ke; “Mamanuga God e iyapana kaina karako kasiyara kwebu ki nu yabunugere emipi.’ Mu inako tagubu manako Mamanuga God e si esida tepamupu. ");
INSERT INTO gdn_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Iyesu tawana ki kamadubu manako kayawena kaniyawa ka e iyapana wairamaga denai takesi wadawa ki apunai mosi si ka Mateyu ika takesi wadamawa wateya tondawa empupu. Empupu manako sibu, wagubu ke; “Kau karako yabi nau ewaneya kayanuwagi.” E inako wagubu, manako ki makeya ka apunu Mateyu deni mena kipu ubupu Iyesu eweya kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Mara mosi ka Iyesu e tadeyau kabukabuwa ragidai mete kina apunu Mateyu e tawaiya daiyo bautagubu. Iyapana takesi wadamawa ragidai ropani kawaya ade iyapana beramaga berokoi ki iyapana mu keitamawa ragidai ki mu dai mete bautagubu mete ika dibimupu ewapuru kupetagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Parisi ragidai iyapana ki emitampu ka mu bautagubu Iyesu e tadeyau kabukabuwa ragidai manu-tampu, tagubu ke; “Wi Nidiyau Kabu-kabuwa Apunai e ka badidi pokere iyapana takesi wadamu ade bigi kwae-tagamu ragidai ki mu mete dibimupu ewapuru kupetagamu idiwu?” ");
INSERT INTO gdn_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Iyesu mu yonamaga ki wainapupu ka e denai tadebu, wagubu ke; “Sigira ragidai ki mu mena ka muramura apunai bameya kayatagisi ko midimaga bagi ragidai ki mu ka muramura apunai ki e bameya asusu eba kayatagisi. ");
INSERT INTO gdn_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Wi kaiwagi manako Mamanuga God e okai yau nene badidi wagubu ki mibai wi kwaenepumuri empumuri. E okai inako wagubu ke; ‘Wi nau nene papa puyo pasumana ki nau eba nuwaneya, ko wi nuwaga notaga iyapana nuwanuwatamana ade mu nene kwaiwagamana ki nau nuwaneya.’ Nau eba iyapana bagi ki mu nene bausugubuwani ko nau iyapana berokoi bigibigi ki mu nene bausugubuwani da mu notamaga wirayagisi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Iyapana siruwatamiyawa apunai Diyoni e tadeyawa kabukabuwa ragidai Iyesu bameya bautagubu manako manumupu, tagubu ke; “Nu ade Parisi ragidai mete kina nu kuduba ka mara dai Mamanuga God e nene bani kame-demei pa gurigurigemei idiwei ko kau tadeyei kabukabuwa ragidai mu ka badidi pokere inako eba kwaetagamu?” ");
INSERT INTO gdn_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Wi badidi waina-piyamu? Anika waunai ki kupei kawa-reya ka apunu ewai ade ridi ewai bani eba kupomono ko nuwaboyatagisi pa idiwono bo? Ae, pa mena, bananatamini kupe ki kawareya baitagisi ki ka mu anika waunai apunai ki mete ewapuru kupetogomono ko eba nuwaboya nene idiwono. Ko mara baiyagisi da iyapana ubumoto anika waunai apunai ki yadini dokodoko kayatagisi. Mara ki makeya ka e kowaiyoma nuwaboyatagisi bani kamadini.” ");
INSERT INTO gdn_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Iyapana nota oragai ade nota waunai ki eba dibipamana ki nana ka Iyesu waigugu mosi mu ade tadebu, wagubu ke; “Iyapana mosi e midi tatamai oragai tegereyagisi ki ka e eba uburoto dabuwa tenai waunai mosi tegerepoto manako yadini oragai ki naureya popopoto. Pa mena. E inako kwaeyagisi ki ka dabuwa tenai waunai ki ewa kaporopoto manako e midi tatamai oragai ki popopupu wateya purupuruyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Ki maba; Awana waeni waunai ki wi awana kororai oragai kakokakowena rabineya eba gwepumuri. Wi ki kwaiwagi ki ka awana waeni waunai ki ebo totoripoto kawayayagisi ko awana kororai ki ka kakokakoi ki pokere wateya tondono da tegereyagisi sukwanayagisi manako awana waeni mete baiyagisi kayayagisi. Ko awana waeni waunai ki wi awana kororai papa kwakwarai wauni waka-mupu ki rabineya gwepumuri. Awana kororai ki ka nenanenaitau ki pokere awana waeni ebo totoripoto kawaya-yagisi ki ka kororai ki mete kawayayagisi manako awana waeni ade awana kororai ki ewapuru bagi kawaya idiwono.” ");
INSERT INTO gdn_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Iyesu yona ki wagawa makeya ka iyapana gurigurimaga tawai ki kwayubapiyau apunai mosi bauwena Iyesu yabareya kwarisiwena e ramatai kawareya ubupu manako sibu, wagubu ke; “Nau peteni waunitau yewe powena ki pokere kau yabodowa da nau tawa-neya kaigamu manako kau idagi e kawareya tari da e iyayagisi ade umono.” ");
INSERT INTO gdn_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Iyesu yona ki wainapupu ka e tadeyau kabukabuwa ragidai mete kina kimpu ubumpu apunu ki mete kaya-tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Iyapana mu paunamugu ka ridi mosi ika kaniyawa ko e ka kwamura ida esida kewowena kerapu apeya (12) ki rabineya sigira mena tondawa. E kobaiya ka dara maramara bauwagawa. Ridi ki e notai inako wagubu ke; ‘Nau kaniyani e midi tatamai mena geyapani ki nau iyasugani.’ E notai inako wagubu ki pokere e karako Iyesu tagere bau-wena manako e midi tatamai giyansu mena geyapupu. ");
INSERT INTO gdn_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Ko Iyesu wirawena ridi ki empupu manako sibu, wagubu ke; “Peteni, kau kasiyara wainapi. Kau sumasinibi ki pokere kau karako iyanugibi.” E yona ki wagawa makeya ka ridi ki deni mena iyawena. ");
INSERT INTO gdn_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Iyesu apunu kawai ki e tawaiya bauwena ka e tawa rabineya yapu manako iyapana ika ratapamawa apena meyamawa munu ridai powena ki pokere durere siyamawa ika idiwa emitapu. ");
INSERT INTO gdn_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Emitapu manako baiyono-tapu, wagubu ke; “Wi kuduba baiwagi kaiwagi. Munu ridai yau eba powena ko e pa ukwarau.” E inako wagubu, ko mu e gwaigwitamupu. ");
INSERT INTO gdn_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Iyapana kuduba bautagubu kaya-tagubu eweya ka Iyesu e eya mena kanibu munu ridai ki bameya bauwena e idaiya wadubu manako ki makeya ka munu ridai ki ade iyawena kipu ubupu. ");
INSERT INTO gdn_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Iyesu badidi kwaewena ki sisiyai garugaru mena kawayawena kayawena iyapana kuduba tawana ki rabineya idiwa ragidai wainamupu. ");
INSERT INTO gdn_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Iyesu natere ki kamadubu kaya-wena kaniyawa ka iyapana apeya yabumaga kenekenei e ewakumamupu manako bonanamaga ragiragi kawaya wena siyamawa, tagamawa ke; “Oragai apunai Dewida e momai; Kau nu nuwa-boyanuga wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Iyesu tawa mo yapu ka yabumaga kenekenei ragidai ki mu mete bauta-gubu e eweya tawa ki rabineya yamupu manako e mu manutapu, wagubu ke; “Wi wainapiyamu da nau wi iyaniyana ki kasiyarai nau bamaneya bo?” “Ena, Kaiwawonuga nu kau sumanimei.” ");
INSERT INTO gdn_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Mu inako tagubu ki pokere Iyesu ubupu e idai mu yabumaga kawareya tapu manako tadebu, wagubu ke; “Wi badidi sumaiwagamu ki makeya makeya wi bamagau wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","E yona ki wagawa makeya ka mu yabumaga pawena tawana ade emupu. Ko Iyesu mu umunumaga umapu, wagubu ke; “Nau wi bamagau kwaesugubuwani ki sisiyai wi iyapana eba tadeyoi.” ");
INSERT INTO gdn_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","E inako wagubu, ko mu e umunui eba wadumupu ko mu tawana ki rabineya kayatagubu kaiwa e sisiyai iyapana tademawa iwa. ");
INSERT INTO gdn_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Iyapana apeya ki iyatagubu kayatagubu eweya ka iyapana dai ki apunu mosi e rabineya kweya kairapu mo tondawa ki pokere e tenawarai bisi kayawena yona eba wagawa ki wadumpu Iyesu bameya bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Iyesu kweya kairapu ki siwakekepupu bauwena kayawena makeya ka apunu ki e tenawarai tekatekawena manako e yona supasupai kawaya ade wagubu. Iyapana kuduba ika idiwa matakira ki emupu ka mu notamaga kowena kodaba-maga kamupu, tagubu ke; “Tawana Isiraero rabineya ka nu naiya gwede mo yau maba inako eba wenawena emipi.” ");
INSERT INTO gdn_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ko Parisi ragidai Iyesu badidi kwaewena emupu ka mu tagubu ke; “Kweya kairapu mu kawaimaga kasiyara kwebu manako kasiyara ki pokaiya ka e uburau kweya kairapu siwakeketamiyau da mu bautagamu kayatagamu.” ");
INSERT INTO gdn_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Iyesu kayawena natere natere tawa tawa bauwagawa kayawagawa umawa. E Diyu ragidai mu guriguri-maga tawai rabineya iyapana tadeyawa kabukabuwa ade mu Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki yonai bagi kawaya dimawagawa umawa. Iyapana sigira-maga kiyabui ebo ebo e bameya bau-tagamawa ki ka e mu iyatamiyawa. ");
INSERT INTO gdn_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Iyapana ropani kawaya e bameya inako bautagamawa emitapu ka e mu nuwaboyamaga wainapupu, mibai mu ka gwe papa sipi mu kwayubatamiyau apunai pa mena ki maba nuwasiyasiya-tagamawa iwa. ");
INSERT INTO gdn_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Iyesu iyapana emitapu ka e wirawena e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Emitamuri, maura ka kawaya daganani ko raupomu ragidai ka eba ropani, ");
INSERT INTO gdn_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ki pokere upi apunai e bameya guriguriwogoi da e raupomu ragidai e kokoreya raupomutagamana ki nana tonotamini.” E inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Mara ki makeya ka Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya mu nene wagubu e bameya bautagubu manako e ubupu kasiyara tagebu da mu kayataga-mana keyai berokoi siwakeketamana ade iyapana sigiramaga kiyabui ebo ebo ki mete iyatamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Iyesu tonotapu ragidai ida esida kewowena kerapu apeya winetapu ki mu simaga ka yau kena; Apunu Saimoni ki e si daikere Pita sibu ade e yowai Enduru mete kina; apunu Tabadi gubagaiyoma Diyemesi ade e yowai Diyoni mete kina; ");
INSERT INTO gdn_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","apunu Piripo, apunu Batoromaiya, apunu Tomasi, ade iyapana wairamaga denai takesi wadawa apunai Mateyu mete kina; apunu Arapiyasi gubagai Diyemesi; apunu Tadeyasi; ");
INSERT INTO gdn_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","iyapana wairamaga gwandagi wagau apunai mosi si ka Saimoni; ade Iyesu yogoi ewa wagubu apunai Diyudiyasi si daikere ka Isikariyoto. ");
INSERT INTO gdn_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya ki tadebu tonotapu, wagubu ke; “Wi iyapana kwaiyanai ragidai mu bamamugu eba kaiwagi ade tawana Sameriya ragidai mu nateremaga mo rabineya mete eba kaiwuri. ");
INSERT INTO gdn_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Wi tawana Isiraero ragidai mu mena bamamugu kaiwagi, mibai mu ka gwe papa sipi yawata paeremupu kwakotagubu ki mu maba iwu. ");
INSERT INTO gdn_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Wi kaiwagi manako dimaiwogoi, iwogoi ke; ‘Nu Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki marai waunitau baiyagisi.’ ");
INSERT INTO gdn_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Wi inako dimaiwogoi manako sigira ragidai iyatamiyoi. Iyapana kwakwarepumaga kwatakwata-wena ki wi iyatamiyoi ade kweya kairapu iyapana rabinamugu idiwu ki wi mete siwakeketamiyoi da mu baitogomono kayatogomono. Iyapana dai mibai popotagubu emitamuri ki ka wi iwogoi manako mu ade iyatogomono kimono ubumono. Nau kasiyara deni mena wi puyo negebuwani ki pokere kaiwagi iyapana deni mena iyatamiyoi ko eba mu gwede mo denai wi negemana ki nene iwogoi. ");
INSERT INTO gdn_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Wi bani iwoi ki ka wi bowa madai dai mete eba tepumuri, ");
INSERT INTO gdn_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","igwa eba tepumuri, wi midiga tatamai yapakai eba tepumuri, wi kerapuga kwakwarai eba tepumuri, ade wi gunaga mete eba tepumuri ko pa ida kasikasi kaiwagi mibai ka iyapana gwedewau nau upini kwaetagamu ragidai ki mu ka upimaga ki denai mete bananapomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Wi natere bo tawa mo baiwagi manako iyapana mo wi diriwaga kwaeyogono ki ka wi e bameya yamuri idiwoi da wi natere ki kamadumuri kaiwagi makeya. Ko wi tawa yaba-yababa mo eba ukwapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Wi tawa mo yamuri ki ka wi yabiri yona inako iwagi ke; “Parau kawaya nuwabagi rabineya idiwoi.’ ");
INSERT INTO gdn_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Iyapana mosi ika nuwabagi rabineya tondau ki ka e wi parauga ki mibai wainapoto. Ko tawa ki rabineya iyapana mo inako pa mena ki ka wi parauga ki wirayagisi wi wiga wainapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ko wi tawa bo natere mo baiwagi da iyapana wi nene eba kwaetogomono ki ka wi waigugu mena inako kwaiwagi; Wi kerapuga dogiyai mena tawamaga pasipumuri. ");
INSERT INTO gdn_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Nau nidiyani wainapumuri; Mamanuga God e idai gurai iyapana kuduba wi naurigau ugwadiniyana ragiragi ki marai baiyagisi makeya ki ka tawana Sodomu yo Gomora ragidai bita maraitau yadini ko natere ki ragidai ki mu ka bita kawaya daganani bananapomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Nau karako wi tononiyakani, ko nau nidiyani wainapumuri; Papa sipi munai taku kamarai wasibena ropani kawaya paunamugu iwu ki maba ka nau wi tononiyani kaiwagi. Ki pokere motamota baibiga kwaetagamu ki maba wi mete baibigaga inako kwaiwogoi, ade wi iyapana paunamugu bagi supasupai mena kwaiwogoi idiwoi. ");
INSERT INTO gdn_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Yabu yabu idiwoi mibai ka iyapana baitagisi wi tenimoto kayatagisi mu gurigurimaga tawai rabineya mu idamaga gurai wi naurigau ugwadini-moto ragiragi manako taburuba pokaiya wi raukekenimoto girinimoto pasuni-moto. ");
INSERT INTO gdn_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Nau pokanere ka wi aita kaiwawo kawakawai ragidai mu yabaramugu ubumuri nau yonani bagi kawaya mu tademuri ade iyapana kwaiyanai ragidai mete tademuri da mu mete kina nau yonani ki wainapomoto. ");
INSERT INTO gdn_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Wi mu yabaramugu ubumu ki ka mu wi manunimana ki denai wi badidi iwagamana bo badidi maba tademana ki wi notaga eba koyogono mibai ka wi yona denai iwagamana marai baiyagisi ki ka wi yona badidi iwagamana ki nau wi kabuwaniyani. ");
INSERT INTO gdn_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wi yona denai iwagi ki ka eba wi wibo yonaga ko ki ka wi Mamaga e eya Keyai wi rabinagau tondau ki e yagisi. ");
INSERT INTO gdn_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Tatai uburoto yagisi manako e yowai poyagisi. Yowai uburoto yagisi manako e tatai poyagisi. Mamai ubu-roto yagisi manako e munuiyoma popotagisi. Munumuguma ubumoto mu inamuguma mamamuguma tagarara-tamini tagisi manako mu inamuguma mamamuguma popotagisi. ");
INSERT INTO gdn_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Nau pokanere ka iyapana wi nidimono siyasiya ade wi tagararanimono, ko iyapana nima nau eba tagararasiniyau ko giruru maba ki kobaiya tewagau buridere bauwagau ki ka aita ewa, mara kwauneya, ka Mamanuga God uburoto iyapana ki iya waunai kweyoto. ");
INSERT INTO gdn_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Mu natere mo rabineya wi girinimoto pasunimoto ki ka wi wakapaiwagi kaiwagi natere mo rabineya idiwoi. Nau yona mibai nidiyani wainapumuri; Wi kaiwagi tawana Isiraero rabineya nau yonani natere natere tawa tawa iwogoi iwoi ko wi upiga ki wi eba kewopumuri were ka nau Kunumau Kawapuwani Apunai ade wirasugani bausugani. ");
INSERT INTO gdn_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Iyapana gwede mosi kataitagamana wainapiyamu ki ka mu eba ubumoto kabuwamaga apunai ki e raurupomoto. Ade bigabiga kwaetagamu ragidai ki ka mu eba ubumoto kawakawaimuguma raurutamini. ");
INSERT INTO gdn_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kabuwawagau apunai badidi bananapoto ki e kabuwai waina-piyamu ragidai mete bananapomoto ki ka baganai. Ade kawai apunai badidi bananapoto ki e bigabigaiyoma mete bananapomoto ki ka baganai. Nau ka wi Kaiwawoga ade wi ka nau iyapana-niyoma ki pokere wainapumuri; Mu tawa apunai nau sidimono da nau ka kweya kairapu mu kawaimaga Besaboro ki ka mu tawa rabineya idiwu ragidai wi mete nidimono siyasiya.” ");
INSERT INTO gdn_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Ki pokere, wi iyapana kaina mu kudumugu eba wainapiyoi, mibai ka gwedegwede kuduba karako utamupu ki utai ka mara mosi wakayagisi, ade gwedegwede kuduba karako weke-piyamu ki kuduba ewa marai mosi matarayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Nau yona karako sisipu rabineya badidi nidiyakani ki wi nawaru puruyagisi makeya matarau iwagi, ade nau wenagugau umana misimisinibuwani ki yonai ka wi aita ewa tawa tagaiya yamuri matarau wena siyamuri da iyapana kuduba wainapomoto. ");
INSERT INTO gdn_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Iyapana wi kwakwarepuga mena minimoto poyo ko wi mibiga rabinagau ki eba minimoto poyo ki mu kudumugu wi eba wainapiyoi. Ko Mamanuga God e mena kudeya wainapiyoi mibai ka e nuwaiya ki ka e uburoto wi teniyoto manako wi kwakwarepuga ade wi mibiga rabinagau ki ewapuru bita wadamana wateya giritamini. ");
INSERT INTO gdn_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Wainapumuri, wi waibora eyaka mena pokaiya midiwari gunototo apeya gimaratamuri mibai ka midiwari ki ka maimerei munta. Mu ka maimerei munta ko mu Mamanuga God e kwayubai rabineya idiwu ki pokere mu mo asusu wairau eba kauyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","31","Ko ade wainapumuri; Mamanuga God e yabuiya ka midiwari ki maimerei munta erida ko wi ka kawakawaya esida. Wi debaga kumai eyaka eyaka ka e iyaba-pupu kewowena wi kwayubaniyau ki pokere wi kudu eba wainapiyoi.” ");
INSERT INTO gdn_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Nau suwagani wainapumuri; Iyapana nima iyapana paunamugu matarau yagisi ke, ‘Nau ka Iyesu nene’, iyapana nima inako yagisi ki ka nau mete kina nau Mamai kunumau tondau e yabareya suwagani da apunu bo ridi ki e ka nau nene. ");
INSERT INTO gdn_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ko iyapana nima iyapana paunamugu matarau yagisi ke, ‘Nau ka eba Iyesu e iyapanai’, iyapana nima inako yagisi ki ka nau mete kina aita ewa nau Mamai kunumau tondau e yabareya matarau suwagani da apunu bo ridi ki e ka eba nau nene.” ");
INSERT INTO gdn_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Wi bani wainapiyamu da nau bausuwagubuwani da iyapana nuwabagi rabineya yewe wairau idiwana ki nana. Ko ki pa mena, nau eba ki nene bau-sugubuwani. Nau iyapana purutamana ewanauwatamana ki nana bausugu-buwani. ");
INSERT INTO gdn_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Nau bausugubuwani ki pokaiya ka munumuguma ubumoto mu mamamuguma iyaratamini, ade pete-muguma ubumoto mu inamuguma iyaratamini, ade wawanepumuguma ubumoto mu naimuguma iyaratamini. ");
INSERT INTO gdn_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Wi iyaranimana ragidai ka wi wiga wenaga eyaka mena ki rabineya. ");
INSERT INTO gdn_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Iyapana nima nau maraitau nota kwarikwarisisiniyau ko e eya inai mamai kawaya daganani nota kwarikwarisitamiyau ki e kwaitana ka nau ewaneya eba uburoto kayayagisi. Ade iyapana nima nau maraitau nota kwarikwarisisiniyau ko e eya gubagai-yoma ade e peteiyoma kawaya daganani nota kwarikwarisitamiyau ki e kwaitana ka nau ewaneya eba uburoto kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Iyapana nima nuwaboya ade midi makari nau bananapakani ki maba e mete bananapana ko e tagararapiyau e eya ripa korosi ki eba kawarapiyau, iyapana ki e kwaitana ka nau ewaneya eba uburoto kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Iyapana nima e eya iyai karako tondana ki nene mena wainapiyau ade wadau doko ki e ka e eya iyai ewa wadana ki mete kaupiyau. Ko iyapana nima e eya iyai karako nene nau pokanere kaupiyau ki e ka aita ewa iya mibai ki bananapoto.” ");
INSERT INTO gdn_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Iyapana nima wi diriwaga kwaewagau ki ka e nau diriwani mete kwaewagau, ade iyapana nima nau diriwani kwaewagau ki ka e nau Tonosinibu Apunai e diriwai mete kwaewagau. ");
INSERT INTO gdn_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Iyapana nima nuwaiya ka Mamanuga God e bonanai waina-piyau wagau apunai e diriwai kwae-wagana wainapiyau manako e diriwai kwaeyogono ki ka aita ewa Mamanuga God e bonanai wainapiyau wagau apunai puyo yodono makeya ki ka iyapana ki e mete uburoto puyo ki maba mo yadini. Ade iyapana nima nuwaiya ka iyapana bagi supasupai kwaewagau apunai e diriwai kwaewagana wainapiyau manako e diriwai kwaeyogono ki ka aita ewa Mamanuga God iyapana bagi supasupai ki puyo kweyono makeya ki ka iyapana ki mete uburoto puyo ki maba mo yadini. ");
INSERT INTO gdn_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Nau yona mibai nidiyani wainapu-muri; Iyapana nima nuwaiya ka awana kasiga miniyana bo gwede mo inako wadana nau ewakumasiniyau ridai bo apunai simaga eba kawaya ki mo kweyana wainapiyau manako kweyau ki ka aita ewa e denai puyo bagi kawaya bananapoto mibai ka e nau ewakuma-siniyawa apunai bo ridai ki waitapupu.” ");
INSERT INTO gdn_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Iyesu yona ki e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya tadebu kewo-wena ka e ade kipu ubupu tawana ki kamadubu manako kayawena tawana Gariri rabineya tawa tawa dimawagawa iyapana tadeyawa kabukabuwa umawa. ");
INSERT INTO gdn_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Iyapana siruwatamiyawa apunai Diyoni dibura rabineya tondawa manako Iyesu badidi kwaewagawa umawa ki sisiyai wainapupu ka e eya tadeyau kabukabuwa ragidai dai Iyesu manupamana ki nana tonotapu. ");
INSERT INTO gdn_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Mu Iyesu bameya bautagubu manako manumupu, tagubu ke; “Kau nidi da nu wainapamu; Iyapana siruwatamiyawa apunai Diyoni apunu mosi ewa bauwagana sisiyai wagubu wainamipi ki apunai ka kau baganai bo nu apunu kudubai mosi e bauwagana nawanai idiwomu?” ");
INSERT INTO gdn_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Iyapana ki inako tagubu ko Iyesu denai tadebu, wagubu ke; “Wi wiraiwagi kaiwagi manako wi yabugere badidi empiyamu bo wainapiyamu ki sisiyai kuduba wi apunu Diyoni simuri, iwagi ke; ");
INSERT INTO gdn_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","‘Iyapana yabumaga kenekenei ki tawana ade empiyamu; iyapana kerapu-maga badabadamai bo kiyokiyoi ki iyatagubu ka iwu; iyapana kwakwarepu-maga kwatakwatawena ki ade bagi-tagubu; iyapana wenagumaga kenekenei ki yona ade wainapiyamu; popotagubu ragidai ki mu dai ade iyatagubu kimpu ubumpu ade iyapana nuwasiyasiya nene idiwu ragidai ki mu ka yona bagi kawaya ki mete wainapiyamu. ");
INSERT INTO gdn_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Iyapana nima e midi nau bamaneya eba togayogono ki ka e mibi mamamai tondono.’” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Apunu Diyoni e tonotapu ragidai ki wiratagubu kayatagubu eweya ka Iyesu iyapana ropani kawaya ika dibimupu idiwa ki apunu Diyoni e nene yona yau tadebu, wagubu ke; “Wi apunu Diyoni bameya iyapana eba idiwu tawaneya kaigubu ki ka wi gwede empamana ki nana wainapamawa? Wi gwaba mosi nusuru gipiyau ki empamana ki nana kaigubu bo? ");
INSERT INTO gdn_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Wi gwede empamana ki nana kaigubu? Wi apunu mosi e midi tatamai bagibagi monagawena ki empamana ki nana kaigubu bo? Pa mena. Iyapana midimaga tatamai bagibagi inako umamu ragidai ki mu ka kawakawai ragidai mu tawamaga bagi kawaya rabineya idiwu. ");
INSERT INTO gdn_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Ko nau sidimuri; Wi gwede empamana ki nana kaigubu? Wi Mamanuga God e bonanai wainapiyawa wagawa apunai mosi ki empamana ki nana kaigubu bo? Ena, wi ki nene kaigubu. Ko nau nidiyani wainapumuri; Apunu Diyoni e ka Mamanuga God e bonanai wainapiyau wagau apunai mosi ko e ka ade kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Mamanuga God e Okai apunu Diyoni nene inako wagubu ke; ‘Nau yonani wagana apunai ka nau bibi yabiri tonopani kau yawatagi meyoto.’ ");
INSERT INTO gdn_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Oka ki inako wagubu, ko nau ade nidiyani wainapumuri; Iyapana kuduba emitamiyamu mu paunamugu ka iyapana siruwatamiyau apunai Diyoni e mena ka kawaya esida, ko aita ewa, Mamanuga God e gari rabineya idiwana ki marai baiyagisi makeya, ki ka iyapana nima kwarisiwena munu marai munta maba tondau ki e ka ade apunu Diyoni raurupoto esida. ");
INSERT INTO gdn_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Apunu Diyoni e yonai dimawagawa makeya yabadawa da karako ka yawira ragidai ropani kawaya Mamanuga God e watai kunumau ki wadamana giripamana pasumana ki nana kwaetagamu. ");
INSERT INTO gdn_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Mamanuga God e bonanai waina-pamawa tagamawa ragidai oka badidi tampu ade oragai apunai Mosisi gora tapu mete kina ki mu kuduba ka mara ewa badidi wenawagana ki nana tagubu were ewa ka apunu Diyoni bauwena. ");
INSERT INTO gdn_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Wi nuwagau mu tagubu ki mibai wainapamana wainapumuri? Ki baganai, wi yona yau mete wainapu-muri; Mu tagubu da oragai apunai Eraidiya aita ewa ade wirawagana bauwagana ki nana ki ka mu apunu Diyoni e nene tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Wi wenaguga mete kina ki ka nau yona yau suwagu-buwani ki mibai wi naigida mena wainapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Wi karako idiwu ragidai wi iyaga badidi maba ki keyakeyai nau badidi maba suwagani? Nau nidiyani wainapu-muri; Wi ka munu rasi imatau damu-piyamu idiwu ki mu maba. Mu ka mu mubo deni deni tagamu kasiwara, tagamu ke; ");
INSERT INTO gdn_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Wi taereigamana ki nana durere siyemeya ko wi eba taereigubu. Nu nuwaboya umayoi umayoigemeya ko wi yadi eba wadumupu.’ ");
INSERT INTO gdn_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Nau nidiyani wainapumuri; Apunu Diyoni bauwena ki ka e Mamanuga God nene bani ragipupu ade awana waeni ki mo e mete eba kubabu. Ko iyapana e kwaewena ki emupu ka mu e simpu siyasiya, tagubu ke; ‘Kweya kairapu mosi e rabineya tondau.’ ");
INSERT INTO gdn_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Ade nau Kunumau Kawapuwani Apunai bausugubuwani ki ka nau bani yo awana kubabuwani manako iyapana nau sidimupu, tagubu ke; “Empumuri, e ka kupekupei ade awana kawaya daganani kubarau e yabarai baba-wagau. E takesi wadamu ragidai ade iyapana bigibigi nu tagararatamemei ragidai ki mu waretamaga.” Mu inako tagamu, ko Mamanuga God e katai ka kawaya esida. Iyapana gwedewau Mamanuga God e yonai wainapomoto mibipomoto ki mu ka e katai mibai ki mete kataitagisi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Iyesu kayawena tawa tawa natere natere kunuma kasiyarai pokaiya matakira ebo ebo kwaewagawa ki iyapana mu yabumugere matarau emupu. Ko mu notamaga eba wirawena ade mu beramaga berokoi ki mu eba kamadumpu ki pokere e natere ki ragidai nakaritapu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“Akae, natere Korasini ragidai. Akae, natere Betaida ragidai. Wi ka bita kawaya daganani bananapumuri. Nau matakira kawakawaya wi paunagau kwaesugekeya. Nau matakira ki maba natere Taya yo natere Saidoni ragidai mu bamamugu kwaesugubena ki ka mu ororeya mena mu beramaga berokoi ki kamadumpena mu notamaga wira-mpena Mamanuga God kabuwampena manako gwedegwede tegetegerei umampena ku pasitagumpena ade mibi nuwaboyai idimpena. ");
INSERT INTO gdn_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Nau yona mibai nidiyani wainapumuri; Mamanuga God e idai gurai iyapana naurigau ugwa-diniyana ragiragi ki marai baiyagisi ki ka e natere Taya yo natere Saidoni ragidai kawaya daganani nuwanuwa-tamini ko e wi maraitau nuwanuwa-niyoto. ");
INSERT INTO gdn_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ade wi natere Kaponiyamu ragidai; Wi bani wainapiyamu da wi wibo kasiyaraga pokaiya esida kunumau yamuri, ko nau nidiyani wainapumuri; Pa mena, wi ka deni mena erida bita wadamana wateya sumuri. Nau matakira kawakawaya wi paunagau kwaesugekeya. Nau matakira ki maba natere Sodomu ragidai mu bamamugu kwaesugubena empena ki ka mu nateremaga ki eba giriwagubena ko mu karako mete idimpibena. ");
INSERT INTO gdn_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Nau yona mibai nidiyani wainapumuri; Mamanuga God e idai gurai iyapana wi naurigau ugwadiniyana ragiragi ki marai baiyagisi ki ka e natere Sodomu ragidai mu kawaya daganani nuwanuwatamini ko e wi maraitau nuwanuwaniyoto.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ki makeya ka Iyesu Mamanuga God bameya parauwena, wagubu ke; “Mamai, kau ka kunuma yo waira Kaiwawoi ki pokere nau kau parau-niyakani. Gora kataimugu ragidai ade katai ebo ebo kataitagubu ragidai ki mu bamamugu ka kau yonagi wekepipi. Ko iyapana karako munu rasi maba idiwu ki mu mena bamamugu ka kau notagi matarapipi. ");
INSERT INTO gdn_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ena, Mamai, kau kaubo nuwageya wainapipi da ki ka baganai ki pokere kau inako kwaenugibi.” ");
INSERT INTO gdn_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Iyesu e Mamai bameya inako parauwena kewowena ka e iyapana ade tadebu, wagubu ke; “Nau Mamai gwedegwede kuduba tegebu umani sidibu. E mena e eya Gubagai nau kataisinibu wetawetara ade nau niya mena ka nau Mamai kataipuwani wetawetara. Ade iyapana gwedewau nau naubo nuwaneya winetapuwani da mu nau Mamai kataipamana ragidai ki mu mena ka nau Mamai mete kataipomoto. ");
INSERT INTO gdn_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Wi gwedewau bita kawaya kawara-piyamu ki pokere wi wairoroigubu kasiyaraga kewowena ragidai ki wi kuduba nau bamaneya baiwagi manako nau aiyata wi negeyani. ");
INSERT INTO gdn_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Nau kewatani kawarapakani ki wi mete wadumuri wi kwepokaragau tamuri manako nau kwaesugakani ki wi nau emisinimuri makeya makeya kwaiwogoi. Wi inako kwaiwogoi ki ka wi aiyata bananapu-muri mibai ka nau kwarisisugubuwani moyamoyakai tondakani. ");
INSERT INTO gdn_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Nau kewatani ki daikerei wi kawarapamana ki nana negeyakani ki bitai ka eba bisi kawaya ko tekatekai.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Mara eba rowarowa kewowena eweya ka Iyesu e tadeyau kabukabuwa ragidai mete kina aiyata marai ki makeya yawata mo kaya-tagubu manako yawatau ka mu kokora mo bameya bautagubu. E tadeyau kabukabuwa ragidai kokora ki kawareya kaiwa ka mu gwaba mosi ki madai dai asusu toporupamawa tepa-mawa idamugu kotopamawa manako madai mibai ki kupamawa kaiwa. ");
INSERT INTO gdn_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Mu inako kupamawa kaiwa ki ka Parisi ragidai dai mu emitampu manako mu bautagubu Iyesu simupu, tagubu ke; “Kau kowakowagiyoma buri emitami. Nu aiyatanuga marai ki makeya mu inako kwaetagamu ki ka mu goranuga ki raurupiyamu.” ");
INSERT INTO gdn_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Takari kawaya oragai apunai Dewida badidi kwaewena ki bususui mu oka tampu ki wi iyaba-mupu kataigubu bo pa mena? E kowakowaiyoma mete kina wetei metapu, ");
INSERT INTO gdn_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","manako oragai apunai Dewida Mamanuga God e Tawai rabineya yapu bani buredi ki iyapana Mamanuga God nene puyo ika naka-mupu ki dai e tepupu kubabu ade dai mete tepupu e kowakowaiyoma tagebu kupamupu. E inako kwaewena, ko gora wagau da bani ki ka Mamanuga God bameya dobopiyamu ragidai ki mu mena kupomoto. ");
INSERT INTO gdn_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Ade oragai apunai Mosisi gora tapu ki wi iyabamupu bo pa mena? Gora wagau da Mamanuga God bameya dobopiyamu ragidai ki mu ka aiyata marai ki makeya mete kina Mamanuga God e Tawai rabineya upitogomono. Mu aiyata marai ki kaisi raurupiyamu ko Mamanuga God e yabuiya ka mu eba paerepiyamu. ");
INSERT INTO gdn_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Nau nidiyani wainapumuri; Mamanuga God e Tawai ka gwede mo kawaya ko ade gwede mo kawaya esida ki karako bauwena. ");
INSERT INTO gdn_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Oka mo wagubu ke; ‘Wi papa nau nene puyo pasumu ki nau eba nuwaneya, ko wi nuwaga notaga iyapana nuwanuwatamana mu nene kwaiwagamana ki nana ki nau nuwaneya.’ Wi yona ki mibai kataigu-mpena ki ka wi karako nari yonai pa asusu iwagamu ki eba iwagumpena. ");
INSERT INTO gdn_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Kunumau Kawapu Apunai e ka aiyata marai ki debai. E ka esida, ko aiyata marai ka erida.” ");
INSERT INTO gdn_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Iyesu tawa ki kamadubu manako kayawena guriguri tawai mo yapu. ");
INSERT INTO gdn_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Tawa ki rabineya ka apunu mosi e idai kiyokiyowena bisi kayawena ika tondawa. Ko mara ki ka aiyata marai ki pokere iyapana dai Iyesu naigida mena empamana da e aiyata marai ki makeya gwede mo paerepana manako mu ki pokaiya e siyamana wirawira ki nana ika mete bautagubu. Bautagubu manako manumupu, tagubu ke; “Sigira ragidai ki nu aiyata marai ki makeya mu iyatamomu bo pa mena? Nu goranuga ki nene badidi wagau?” ");
INSERT INTO gdn_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Wi papaga sipi mosi aiyata marai ki makeya uruba mo rabineya kauyagisi ki ka wi sumuri papa ki tainipumuri iyapumuri bo pa mena? Ena, wi sumuri tainipumuri iyapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Papa sipi ki ka eba gwede kawaya mosi ko iyapana ka kawaya esida ki pokere nu sigira ragidai aiyata marai ki makeya waita-tamomu ki ka nu gora eba raurupemei.” ");
INSERT INTO gdn_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","E inako wagubu manako wirawena idai kiyokiyoi apunai ki sibu, wagubu ke; “Kau idagi roronapi.” Apunu ki e idai roronapiyawa makeya ka e idai ki garugaru mena supasupawena iyawena e idai daikere ki maba wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Parisi ragidai Iyesu kwaewena ki emupu ka mu tawa ki kamadumpu manako e minimana po ki keketai kupamawa. ");
INSERT INTO gdn_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Parisi ragidai Iyesu minimana po keketai kupamawa ki e eya wainapupu ki pokere e kipu ubupu tawana ki kamadubu kayawena. Iyapana ropani kawaya e ewakumamupu kayatagubu. Iyapana dai mu sigiramaga mete kina ki ka e mu kuduba iyatapu, ");
INSERT INTO gdn_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ko e mu tatamatapu tadebu da mu e sisiyai ki iyapana eba tademana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","E inako kwaewena ki ka Mamanuga God e bonanai wainapiyawa wagawa apunai Aisaiya takari kawaya oka tapu ki mibai wenawagana ki nana. Oka ki wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","‘Mamanuga God inako wagau; Yau ka nau bigabigani apunai winepuwani. Nau nuwaneya po eyo ade e mamamai nau suwagakani. Nau Keyaini ki nau e rabineya tapuwani ade nau kasiyara kwe-buwani da iyapana kuduba, madega kauwagau madega posiwagau e umuneya nau notani bagi supasupai ki kataipamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Iyapana e siyomoto siyasiya ki e denai eba yagisi ade e bonanai ragiragi kawaya eba yagisi. Natere natere imatau ka mu e bonanai eba wainapomoto. ");
INSERT INTO gdn_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Iyapana gwedewau kasiyaramaga pa mena ragidai ki mu bamamugu ka e kwarisiyagisi naigida mena kwayubatamono, ade iyapana gwedewau waitamaga pa mena da mu notamaga kauwena ragidai ki e mu togitamini. E inako kwae-yogono yarono da nota bagi supasupai baiyagisi nota oragai kuduba raurutamini kewoyagisi makeya. ");
INSERT INTO gdn_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E mu waitatamana ki nana ka iyapana tawana tawana kuduba mu notamaga e bameya nota-pomono ade e nawanai idiwono.’ Oragai apunai Aisaiya e Mamanuga God yonai oka inako tapu. ");
INSERT INTO gdn_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ki makeya ka iyapana dai ubumpu apunu mosi kweya kairapu e rabineya tondawa ki pokere e yabui kenewena ade e tenawarai bisi kayawena yona eba wagawa ki wadumpu Iyesu bameya bautagubu. Iyesu apunu ki iyapupu manako e yabui papupu makeya ki ka e tawana empupu ade yona mete wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Iyapana ropani kawaya ika idiwa Iyesu matakira kwaewena ki emupu ka mu notamaga kowena kodabamaga kamupu manako mubo manu kasiwara-tagamawa, tagamawa ke; “Apunu yau ka oragai apunai Dewida e momai ki nawanai nu idiwei ki e baganai bo?” ");
INSERT INTO gdn_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Parisi ragidai iyapana inako tagubu wainamupu ka mu denai tagubu ke; “Ki pa mena. Kweya kairapu kawai-maga Besaboro e rabineya tondau kasiyara kweyau manako kasiyara ki mena pokaiya ka e kweya kairapu kuduba ki siwakeketamiyau.” ");
INSERT INTO gdn_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Mu inako tagubu, ko mu nuwa-maga notamaga ka Iyesu ororeya mena empupu kewowena ki pokere e denai tadebu, wagubu ke; “Tawana mosi ki ragidai nuwarara tagarara kande kasiwaratogomono idiwono ki ka mu purutagisi mu mubo mubo kayatagisi manako tawanamaga ki gumoroyagisi gwaba umuroto. Ade iyapana tawa eyaka mena bo natere eyaka mena rabineya purupomoto kandetogomono idiwono ki ka mu iyamaga giriyagisi mu mubo mubo kayatagisi. ");
INSERT INTO gdn_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Ki maba, Berokoi Apunai Seitani e ebo kowaiyoma mete kande kasiwaratogomono ki ka e kasiyarai badidi maba uburono, mibai ka e kowakowaiyoma purupurutagubu mu mubo mubo idiwu. ");
INSERT INTO gdn_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Wi iwagamu da nau kweya kairapu kawaimaga Besaboro e kasiyarai tegeyau pokaiya kweya kairapu siwakeketamakani, ko nau e kasiyarai pokaiya kwaesugubena maba ki ka wi wiga kowaguma nima kasiyarai pokaiya kweya kairapu ki siwakeke-tamuimbena? Besaboro mu mete kasiyara tageyau bo? Wi wiga kowa-guma ki manutamuri da mu muga tagisi. ");
INSERT INTO gdn_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Nau ka eba Besaboro e kasiyarai pokaiya kwaesugakani ko nau Mamanuga God e eya Keyai ki kasiyarai pokaiya kweya kairapu siwakeke-tamakani bautagamu kayatagamu. Ki pokaiya ka wi kataiwagi da Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki marai wana wi bamagau bauwena. ");
INSERT INTO gdn_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Iyapana mosi nuwaiya ka kasiyara apunai mosi e tawai baupana e gwede-gwedei kuwawagana wainapiyau ki ka e yabiri kayayagisi kasiyara apunai ki yadini e idai kerarai umeme dokodoko-poto taroto were ewa tawa ki yaroto apunu ki e gwedegwedei kuwayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Iyapana nima nau diriwani eba kwaewagau ki ka e nau tagararasiniyau, ade iyapana nima nau eba waitasiniyau nau iyapananiyoma eba waratamiyau ki ka e mu daburitamiyau. ");
INSERT INTO gdn_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Nau suwagani wainapumuri; Iyapana berokoi badidi kwaetagubu bo tagubu ki kuduba ka Mamanuga God empoto surupoto e tagaiya deni mena kwenupoto. Ko iyapana nima uburoto Mamanuga God e eya Keyai ki siyoto siyasiya ki ka Mamanuga God iyapana ki e bigi empana notagogapana ki yawatai pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Iyapana gwedewau nau Kunumau Kawapuwani Apunai nau sidimoto siyasiya ki ka Mamanuga God mu bigimaga ki empana surupana yawatai mete kina. Ko iyapana gwedewau ubumoto Mamanuga God e eya Keyai Tanai Bagi Kawaya ki siyomoto siyasiya ki ka Mamanuga God mu bigimaga ki empoto ko mara karako ade mara ewa ka e mu bigimaga ki eba surupoto.” ");
INSERT INTO gdn_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Ripa iruirui kawaya ki e ka mibai bagi mena kiroto, ade ripa wayowayoi ki e ka mibai berokoi mena kiroto. Wi ripa mibai empumuri ki pokaiya ka wi kataiwagi da ripa bani ka iruirui ade ripa bani ka wayowayoi. ");
INSERT INTO gdn_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Wi ka motamota berokoi ki e momoiyoma. Wi rabinagau ka nota berokoi mena posiwena ki pokere wi badidi maba wi umunuga pokaiya yona bagi iwagi? Ki pa mena. Iyapana nima yona berokoi e umuneya wagau ki ka e rabineya berokoi badidi notapiyau ki mena makeya e umuneya posiwagau. ");
INSERT INTO gdn_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ki maba, apunu bagai ki e nuwai notai ka taniwena ki pokere e bagi mena kwaewagau. Ko apunu berokoi e nuwaiya notaiya ka berokoi mena posiwena ki pokere e berokoi mena kwaewagau. ");
INSERT INTO gdn_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Nau nidiyani wainapumuri; Mamanuga God e idai gurai iyapana kuduba wi naurigau ugwadiniyana ragiragi ki marai baiyagisi makeya ki ka e uburoto wi yewe wairau yona mibai pa mena kororai iwagamawa ki kuduba e mete matarapoto denai negeni. ");
INSERT INTO gdn_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Wi yona supasupai iwagubu bo yona eba supasupai iwagubu wi yonaga ki pokaiya ka e wi iyapana bagi nidini bo iyapana berokoi nidini.” ");
INSERT INTO gdn_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ki makeya ka Mamanuga God e gorai kataimugu ragidai ade Parisi ragidai dai mete kina bautagubu Iyesu simupu, tagubu ke; “Nidiyei Kabukabuwa apunai, nu nuwanugu kau matakira mo kwaenuwagi da nu empamu.” ");
INSERT INTO gdn_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Wi karako idiwu ragidai wi beraga ka eba bagi ade wi Mamanuga God bameya rauru kawa-kawara ki berai maba kwaiwagamu idiwu ki pokere wi kunuma matakirai empamana ki nana iwagamu. Ko matakira inako mo wi bamagau eba wenayagisi. Mamanuga God e bonanai wainapiyawa wagawa apunai Diyouna e bameya badidi wenawena, waigugu ki mena maba wi bamagau wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Oragai apunai Diyouna mara apeya eyaka iyana kawaya mo rabineya tondawa ki maba ka nau Kunumau Kawapuwani Apunai mara apeya eyaka waira rabineya surani tondoni. ");
INSERT INTO gdn_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Oragai apunai Diyouna dimawagawa makeya ka tawana Niniwe ragidai mu notamaga wirawena mu beramaga berokoi kuduba kamadumpu. Ko wi inako eba kwaigubu ki pokere Mamanuga God e idai gurai iyapana kuduba wi naurigau ugwadiniyana ragiragi ki marai baiyagisi ki ka tawana Niniwe ragidai ki mu mete ubumoto mu idamaga gurai wi naurigau ugwadini-moto ragiragi. Oragai apunai Diyouna e ka apunu kawaya, ko nau suwagani wainapumuri; E ka ade erida ko karako bauwena apunai ki e ka kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ade takari kawaya ka tawana Seba ragidai mu ridimaga kawai mosi tawana uwama kawaya were yabadubu apunu kawai Soromoni e notai supasupai pokaiya dimawagawa ki yonai waina-pana ki nana. Apunu Soromoni e ka kawaya, ko nau suwagani wainapu-muri; E ka ade erida ko karako bau-wena apunai ki e ka kawaya esida. Ki pokere Mamanuga God e idai gurai iyapana naurigau ugwadiniyana ragiragi ki marai baiyagisi ki ka ridi kawai ki e mete uburoto e idai gurai iyapana karako idiwu ragidai wi naurigau ugwadiniyoto ragiragi. ");
INSERT INTO gdn_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nau nidiyani wainapumuri; Keyai berokoi iyapana mosi kamadini bai-yagisi kayayagisi ki ka e aiyata tondana aiyatawagana tawai waunai mosi kwaenepono umono. E wata bagi mosi eba bananapoto, ");
INSERT INTO gdn_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ki ka e notai yagisi ke; ‘Nau karako ade wirasugani wata naiya tondekeya ki wateya ade kaya-sugani.’ E notai inako yagisi manako e wirayagisi baiyagisi ki ka e tawa memupu waramupu monagamupu bagi kawaya ki empoto, ");
INSERT INTO gdn_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ki pokere e mamamayagisi kayayagisi e kowaiyoma e maba ko ade berokoi kawakawaya esida ida daikere kewowena daikere apeya (7) ki waratamini manako mu baitagisi ewapuru iyapana ki e rabineya ika idiwono. Naiya, keyai berokoi eyaka mena iyapana ki rabineya tondawa makeya, ki ka iyapana ki bagasitau tondawa. Ko karako ka keyai berokoi ropani kawaya e rabineya idiwu ki pokere e iyai ka berokoi kawaya. Iyapana mara karako bera berokoi kwaetagamu idiwu ragidai ki mu ka bita kawaya ki maba bananapomoto.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Iyesu iyapana inako tadeyawa kabukabuwa tondawa makeya ka e eya inai ade e eya yowaiyoma mete kina ika bautagubu. Mu tawa rabineya eba yamupu ko ika matarau ubumawa Iyesu kawarana da mu e mete yonatagamana ki nana ki yonai mena tawa rabineya tonomupu. ");
INSERT INTO gdn_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Mu yona mena tonomupu manako iyapana mosi ubupu Iyesu sibu, wagubu ke; “Kau inagi ade kau yowagi-yoma mete kina bautagubu tawa ureya ubumu kau mete yonaigamana ki nana tagamu.” ");
INSERT INTO gdn_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","E inako wagubu, ko Iyesu e denai sibu, wagubu ke; “Nau inai ka nima? Ade nau yowaniyoma ka gwedewau?” ");
INSERT INTO gdn_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","E inako wagubu ade wirawena e tadeyau kabukabuwa ragidai emitapu manako iyapana tadebu wagubu ke; “Nau tadeyakani kabukabuwa ragidai yau emitamuri. Mu ka nau nau yowani-yoma ade nau inaniyoma. ");
INSERT INTO gdn_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Iyapana gwedewau nau Mamai kunumau tondau e nuwaiya badidi wainapiyau ki makeya makeya kwaetogomono ki mu ka mibai nau yowaniyoma, nau egapuniyoma, ade nau inaniyoma.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Mara eyaka mena ki rabineya ka Iyesu tawa ki kamadubu manako kayawena kaburu kawaya ki papateya bauwena kwarisiwena ton-dubu manako e iyapana ika tadeyawa kabukabuwa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Iyapana ropani kawaya eba bigabigai bautagubu e yonai wainapamana ki nana e kwagara-mupu idiwa ki pokere Iyesu waka mosi ika kaburu papateya uburawa ki kawareya yapu tondawa ko iyapana kuduba ka kaburu ki papateya wairau idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","E yona marai kawai kuduba waigugu were tadeyawa manako paunau ka e waigugu mosi inako tadebu, wagubu ke; “Apunu mosi ka momai dai urana kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","E momai ki urawa umawa da momai dai yawatau kerapu dabireya gwegwetagubu manako midiwari garugaru mena bautagubu momai ki kupampu gawarara. ");
INSERT INTO gdn_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Momai dai ka e yaroyaro kawareya upu manako momai ki garugaru mena ugwadubu susukwana. Ko waira ki ka eba kawaya, ");
INSERT INTO gdn_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ki pokere madega ubupu urabu ki ka momai ki garugaru mena suratagubu, mibai ka witai waira rabineya eba supu. ");
INSERT INTO gdn_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ade momai dai ka gwabau gaya kakapareya gwegwetagubu wenatagubu ko gwaba ubupu niniuraurapupu ki pokere wenatagubu ko mibai eba kipu. ");
INSERT INTO gdn_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Ko momai dai ka e waira bageya upu manako ugwede susukwanapupu wenatagubu kawakawayatagubu mibai kipu. Dai ka mibai apunai ida daikere mena (100) kipu, dai ka mibai apunai apeya eyaka (60) kipu, ade dai ka apunai eyaka mena ida esida mena (30) inako kipu. ");
INSERT INTO gdn_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Wi wenaguga mete kina ki ka wi nau waiguguni yau suwagu-buwani ki mibai naigida mena wainapu-muri.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Iyesu yona ki wagubu eweya ka e tadeyau kabukabuwa ragidai e bameya bautagubu manako manumupu, tagubu ke; “Kau badidi pokere iyapana waigugu were tadeyei?” ");
INSERT INTO gdn_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Mu inako tagubu ko Iyesu denai tadebu, wagubu ke; “Mamanuga God e gari rabineya idiwana ki yonai weke-wekei ki mibai kuduba ka nau wi mena nidiyakani ko mu eba tadeyakani. ");
INSERT INTO gdn_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Iyapana nima Mamanuga God e yonai mibai wainapupu wadubu doko ki ka e yona waunai mosi ade wainapoto yadini manako Mamanuga God e eya katai iyapana ki e rabineya kawaya-yagisi. Ko iyapana nima yona ki eba wainapupu wadubu doko ki ka e ewa mo eba yadini ade marai munta waina-pupu ki mete gogayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Nau iyapana waigugu were tadeyakani ki mibai ka mu yabutamiyamu ko mu mibai eba empiyamu. Ade mu wenagu-mugere wainapiyamu ko mu mibai eba wainapiyamu. ");
INSERT INTO gdn_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","15","Mu inako kwae-tagamu ki ka Mamanuga God e bonanai wainapiyawa wagawa apunai Aisaiya takari kawaya oka tapu ki mibai wena-wena yau kena. Oka ki wagubu ke; ‘Wi wenaguga wi wiga bodamupu. Wi yabuga wi wiga kenemupu. Ade wi rabinagau wi wiga gudu uma-mupu. Ki pokere wainapiyoi, wainapiyoi, ko wi mibai eba wainapumuri. Yabu tamiyoi, yabu tamiyoi, ko wi mibai eba empumuri. Wi empamana eba wainapiyamu. Wi wainapamana eba wainapiyamu. Wi kataigamana mete eba waina-piyamu. Wi wainampena ki ka wi mibai mete bananampena manako wi notaga wirawagubena wi Mamaga God nau bamaneya da nau iya wi negebena.’ ");
INSERT INTO gdn_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Iyesu Mamanuga God e okai ki kawareya inako wagubu manako e tadeyau kabukabuwa ragidai ki ade tadebu, wagubu ke; “Ko wiyo, wi ka wi yabuga pokaiya empiyamu ade wi wenaguga pokaiya wainapiyamu ki pokere mamamaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Nau yona mibai suwagani wainapumuri; Oragai Mamanuga God e bonanai wainapamawa tagamawa ragidai ropani kawaya ade iyapana ropani kawaya naiya idiwa mete kina ki mu ka wi karako empiyamu ki mu mete empamana wainapamawa ko mu eba emupu. Ade wi karako waina-piyamu ki mu mete wainapamana wainapamawa ko mu eba wainamupu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Apunu momai urawa ki waigugui mibai nau karako suwagani wainapu-muri; ");
INSERT INTO gdn_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Iyapana gwedewau Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki yonai wainapomoto ko mu mibai naigida eba kataitagisi, ki mu ka momai yawatau kerapu dabireya gwegwetagubu ki maba. Iyapana ki mu ka Mamanuga God e yonai waina-pomoto ko Berokoi Apunai Seitani garugaru mena baiyagisi mu notamaga yadini gogapoto manako yona badidi wainamupu ki e surupoto. ");
INSERT INTO gdn_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Momai yaroyaro kawareya gwegwetagubu ki mibai ka yau kena; Iyapana dai Mamanuga God e yonai wainapomoto manako mamamatagisi, ");
INSERT INTO gdn_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ko yona ki mibai mu rabinamugu eba supu tawa-wena ki pokere mu rowarowa kawaya eba mamamatogomono. Mu yona ki pokaiya berokoi mosi bananapomoto bo iyapana dai ubumoto mu giritamini pasutamini ki ka mu Mamanuga God e yonai ki garugaru mena notagoga-pomoto ewamugere wiratagisi. ");
INSERT INTO gdn_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ade momai gwabau gaya kakapareya gwegwetagubu ki mibai ka yau kena; Iyapana dai Mamanuga God e yonai wainapomoto ko mu mubo iyamaga nene mena notapomono ade waira yau purapurai empomono yabumaga midiyayogono. Mu notamaga ka ki mena kawareya ukworono manako nota ki uburoto Mamanuga God e yonai badidi wainamupu ki utapoto da mu mibimaga mo eba kiroto. ");
INSERT INTO gdn_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ko iyapana dai ka e momai waira bageya upu ki maba. Mu ka Mamanuga God e yonai wainapomoto sumapomoto manako mu mibimaga mete kiroto. Dai ka mu mibimaga apunai ida daikere mena (100) kiroto, dai ka mu mibimaga apunai apeya eyaka (60) kiroto, ade dai ka mu mibimaga apunai eyaka mena ade ida esida mena (30) kiroto.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Iyesu waigugu ade mosi tadebu, wagubu ke; “Wi Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki keyakeyai mosi nau nidiyani wainapumuri; Ki ka apunu mosi momai bagibagi dai tepupu e kokoreya upu ki maba. ");
INSERT INTO gdn_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Kemora mo rabineya iyapana kuduba ukwapamawa tetamugu ka apunu ki e iyarai mosi gwaba berokoi ki momai dai tepupu apunu ki e kokoreya bauwena manako momai bagi kawaya ki kawarimugu ka e momai berokoi ki kwisipupu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Momai bagi kawaya upu ki kawayawena supupu ki kaparimugu ka gwaba berokoi ki mete wenatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Wenatagubu emupu ka upi ki apunai e bigabigaiyoma dai e bameya bautagubu manako simupu, tagubu ke; “Bada, kau momai bagi mena upi ko badidi pokere ka gwaba berokoi ki mete kaparimugu wenatagubu.” ");
INSERT INTO gdn_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Upi apunai yona ki wainapupu ka e denai wagubu ke; “Nau iyarani mo bauwena ki kwaewena.” E inako wagubu manako mu e ade manumupu, tagubu ke; “Kau nuwageya nu kaigamu gwaba berokoi ki kwai-pamu isiyapamu bo?” ");
INSERT INTO gdn_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ko e denai tadebu, wagubu ke; “Pa mena, wi inako kwaiwagi ki ka wi kwaenda momai bagi dai mete kwaipu-muri, ");
INSERT INTO gdn_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ki pokere karako pa idiwomu yamomu da maura marai baiyagisi were. Nu inako kwaigomu ki ka momai bagi ade gwaba berokoi ki ewapuru kawakawayatagisi manako maura marai baiyagisi ki ka nau raupomu ragidai tonotamani da mu yabiri gwaba berokoi ki kwaipomoto bawapomoto matau pasumoto manako ewa ka mu mibai bagi ki raupomutagisi nau tawani rabineya nakapomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Iyesu iyapana waigugu were inako tadebu ko kawareya ade wagubu ke; “Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki keyakeyai mosi nau karako wi nidiyani wainapu-muri; Ki ka apunu mosi ripa damaya madai tepiyau urau ki maba. ");
INSERT INTO gdn_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Ripa dai mu madimaga ka kawakawaya ko damaya madai rabineya ka momai rasirasi. Momai marai munta eyaka mena inako ki kauyagisi wairau suroto wena-yagisi ki ka aita ripa kawaya mo wena-yagisi ragaragapoto manako midiwari baitagisi ragai ki kawareya tawatagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Iyesu waigugu mosi iyapana ade tadebu, wagubu ke; “Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki keyakeyai ade mosi nau karako wi nidiyani wainapumuri; Ki ka ridi mosi bani buredi kawaya-wagana domai marai munta mo yadini suguna mete wirapoto taroto manako suguna ki kawayayagisi yaroto ki maba.” ");
INSERT INTO gdn_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Iyesu waigugu mena pokaiya iyapana ropani kawaya tadeyawa umawa ko e yona matarau mo mu eba tadebu. ");
INSERT INTO gdn_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Mamanuga God e bonanai waina-piyawa wagawa apunai mosi naiya oka tapu ki mibai wenawagana ki nana ka e inako kwaewena. Oka ki wagubu ke; ‘Mamanuga God kunuma waira yamanapupu makeya yabadawa da karako e yonai mibai iyapana eba kataitagamana ki nana wekepupu ki yonai ka nau waigugu mena pokaiya mu tadeyani.’ ");
INSERT INTO gdn_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Iyesu iyapana ropani kawaya ki kamaditapu tawa rabineya yapu ton-dubu makeya ka e tadeyau kabukabuwa ragidai e bameya bautagubu manako manumupu, tagubu ke; “Kaiwawonuga, kau gwaba momai berokoi kokorau wenawena ki waigugui nuwagibi ki mibai kau karako matarau nuwagi da nu wainapamu.” ");
INSERT INTO gdn_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Mu inako tagubu, ki pokere Iyesu denai tadebu, wagubu ke; “Momai bagi upu apunai ki e ka nau Kunumau Kawapuwani Apunai. ");
INSERT INTO gdn_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Kokora ki ka waira kuduba madega kauwagau madega posiwagau, ade momai bagi ka iyapana kuduba ki aita ewa Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki ragidai. Gwaba berokoi ki momai kwisipupu ka Berokoi Apunai Seitani e iyapanaiyoma, ");
INSERT INTO gdn_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ade iyara apunai ki ka Berokoi Apunai Seitani e eya. Maura marai ki ka mara siyareya, ade raupomutagamana ragidai ki mu ka Mamanuga God e aneyaiyoma. ");
INSERT INTO gdn_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Mu gwaba berokoi ki kwaimpu matau isiyamupu ki maba mara siyareya ");
INSERT INTO gdn_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ka nau Kunumau Kawapuwani Apunai nau aneyaniyoma tonotamani da mu nau garini rabineya kayatagisi gwede kuduba iyapana bigi tageyau ade iyapana gwedewau berokoi kwaetagamu ragidai ki mu kuduba mete kina purutamini damutamini, ");
INSERT INTO gdn_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","manako tetamini mata maramara urau ki nonareya isiyatamini. Isiyatamini manako mu ika yadi kimono uwarimaga sisiripomono ‘aige, aige’ togomono idiwono. ");
INSERT INTO gdn_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Mara ki makeya ka Mamanuga God e eya iyapanaiyoma bagi supasupai kwaetagamawa ragidai ki mu tanimaga madega maba tapapoto manako mu e gari rabineya idiwono. Wi wenaguga mete kina ki ka wi nau waigugu suwagubuwani yau ki mibai naigida mena wainapumuri.” ");
INSERT INTO gdn_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Iyesu inako wagubu manako waigugu dai ade tadebu, wagubu ke; “Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki keyakeyai ade mosi nau karako wi nidiyani wainapumuri. Ki ka apunu mosi waira ukwapupu rabineya purapura bagi kawaya mo bananapupu ki maba. E purapura ki empupu ade utapupu kamadubu manako mibi mamamai garugaru mena kayawena e ebo gwedegwedei kuduba tepupu nidapupu manako denai bowa madai wadubu ki pokaiya ka e wirawena waira ki gimarapupu. E waira gimara-pupu kewowena ki ka purapura waira rabineya ki mete e nene. ");
INSERT INTO gdn_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Ade Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki keyakeyai ade mosi ka yau kena; Ki ka purapura deni deni nida kasiwarawagau apunai mosi taene bagi kawaya mo kwaenepiyau umau ki maba. ");
INSERT INTO gdn_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","E taene bagi kawaya mo bananapoto ki ka e wirayagisi kaya-yagisi e ebo purapurai kuduba nidapoto manako denai bowa madai yadini ki pokaiya ka e kayayagisi taene bagi kawaya ki gimarapoto. ");
INSERT INTO gdn_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Ade Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki keyakeyai ade mosi ka yau kena; Ki ka iyapana kimai wasisinai ragidai puwarimuguma tempu kaya-tagubu kaburu rabineya nunumupu manako raubiyo kiyabumaga ebo ebo waramupu ki maba. ");
INSERT INTO gdn_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Mu puwari-muguma tainitamini borau positagisi ki ka mu raubiyo kwanapomoto. Raubiyo bagi ki mu kodemaga rabineya nunu-moto ko berokoi ki mu isiyapomoto. ");
INSERT INTO gdn_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Mara siyarai ki marai baiyagisi ki ka inako maba wenayagisi. Mamanuga God e aneyaiyoma kayatagisi iyapana bagi supasupai ragidai mu paunamugu iyapana beramaga berokoi ki kwana-tamini, ");
INSERT INTO gdn_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","manako tetamini mata maramara urau ki nonareya isiyatamini. Isiyatamini manako mu ika yadi kimono uwarimaga sisiripomono ‘aige, aige’ togomono idiwono.” ");
INSERT INTO gdn_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Iyesu waigugu ki wagubu kewo-wena ka e tadeyau kabukabuwa ragidai ki emitapu manako manutapu, wagubu ke; “Nau keyakeyai karako suwagu-buwani ki mibai wi wainamupu bo pa mena?” “Ena, nu wainamipi.” ");
INSERT INTO gdn_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Mu inako tagubu ki pokere Iyesu denai tadebu, wagubu ke; “Nau keyakeyai mo wi nidiyani wainapumuri; Mamanuga God e gorai kataimugu ragidai ubumoto nau sumasinimoto manako Mamanuga God e gari rabineya kayatagisi yona waunai mete kataitagisi ki ka mu tawa apunai e tawai rabineya kaniyau e gwedegwedei waunai ade oragai ewapuru tepiyau ki maba.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Iyesu waigugu kuduba ki wagubu kewowena ka e tawana ki kamadubu, ");
INSERT INTO gdn_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","manako wirawena e ebo tawaneya ade kayawena. E guriguri tawai rabineya Mamanuga God e yonai iyapana tadeyawa kabukabuwa tondawa. Iyapana ropani kawaya e yonai wagawa ki wainapamawa ka mu notamaga kowena, tagamawa ke; “Apunu yau ka yona kawaya kawaya yau bani wainapupu bauwena wagau? Nota yau ka nima e kwebu? E matakira ebo ebo mete kwaewagau ki kerarai ka badidi? ");
INSERT INTO gdn_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","E ka ripa meyau kaitepiyau tawa wadau apunai ki e gubagai. E inai ka Meri ade e yowaiyoma ka Diyemesi yo Diyosepa yo Saimoni yo Diyudiyasi. ");
INSERT INTO gdn_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Ade e egapuiyoma ka nu mete yewe idiwei. E ka pa tawa munai ko e katai kawaya yau ka e bani wadubu?” ");
INSERT INTO gdn_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Iyapana inako tagubu manako Iyesu simpu siyasiya tagararamupu. Ko Iyesu iyapana tadebu, wagubu ke; “Mamanuga God e bonanai wainapiyau wagau apunai ki e ka tawana tawana umono manako iyapana e wiwirapomono e diriwai kwaetogo-mono ko e wirayagisi e ebo tawaneya baiyagisi ki ka e eya iyapanaiyoma e eba wiwirapomono ade e diriwai mete eba kwaetogomono.” ");
INSERT INTO gdn_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Iyapana ika idiwa e eba suma-mupu ki pokere natere ki rabineya ka e matakira ropani kawaya eba kwaewena. ");
INSERT INTO gdn_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Mara ki makeya ka tawana Gariri ragidai mu kawaimaga si ka Erodi Iyesu sisiyai wainapupu, ");
INSERT INTO gdn_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","manako e kowakowaiyoma tadebu, wagubu ke; “Apunu yau kena e ka bani iyapana siruwatamiyawa apunai Diyoni powena ki ade iyawena kipu ubupu ki pokere e kasiyara wadubu matakira ebo ebo inako kwaewagau.” ");
INSERT INTO gdn_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","5","Apunu Erodi inako wagubu ki mibai ka e naiya e yowai Piripo e wainai si ka Erodiyasi kuwawena uwapu ki pokere iyapana siruwatamiyawa apunai Diyoni ubupu e kawareya kawareya sisibapiyawa, wagawa ke; “Kau nadawagi kuwanugibi ki kau gora raurupipi bera berokoi kwaenugibi.” Apunu Diyoni inako wagawa tondawa ki pokere apunu Erodi gagayawena Diyoni deni mena miniyana po wainapupu. Ko e Diyu ragidai mu kudumugu mete wainapupu mibai ka iyapana kuduba kataimugu da apunu Diyoni e ka Mamanuga God e bonanai wainapiyawa wagawa apunai mosi. Apunu Erodi iyapana kudumugu wainapupu ki pokere e piyara ragidai tadebu da mu Diyoni pa wadamana e idai kerarai umamana dokodoko manako diburapamana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Ki eweya, iyapana apunu Erodi wenawena marai ki kupei kupe-tagamawa idiwa ki mareya ka ridi Erodiyasi e petei bauwena apunu Erodi e daiyoi bautagubu ragidai mete mamamatagamana ki nana mu yabara-mugu taerewagawa kaniyawa yabadawa. Apunu Erodi munu ridai ki badidi kwaewena empupu ka e rabinai bagiwena, ");
INSERT INTO gdn_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","manako gwaiyaba kaimatana e sibu, wagubu ke; “Nau mibai nidiyakani; Kau gwede mo nene wainapiyei nuwagi ki kuduba nau kau negeyani.” ");
INSERT INTO gdn_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Apunu Erodi inako wagubu, manako munu ridai ki e inai nuwaiya badidi wainapiyawa ki e kataiya ki pokere e denai wagubu ke; “Nau nuwaneya kau tegeyana ka yau kena; Iyapana siruwa-tamiyawa apunai Diyoni e gobai wi karako memuri puru manako e debai ki wi yogo kawareya tamuri nau tegemuri.” ");
INSERT INTO gdn_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Apunu Erodi yona ki wainapupu ka e nuwaboyawena. Ko e ororeya mena e daiyoi bautagubu ragidai mu yabumugu munu ridai ki gwaiyaba kaimatana sibu ki pokere e piyara ragidai tadebu da mu munu ridai ki nuwaiya badidi ki makeya makeya kwaetagamana ki nana wagubu, ");
INSERT INTO gdn_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","manako mu e umuneya kayatagubu apunu Diyoni dibura rabineya tondawa ki e gobai mempu puru. ");
INSERT INTO gdn_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Mempu puru manako e debai yogo mo kawareya tampu wadumpu bautagubu munu ridai ki kwemupu, manako e ubupu yogo ki wadubu kayawena e inai kwebu. ");
INSERT INTO gdn_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Apunu Diyoni e tadeyau kabukabuwa ragidai e powena sisiyai wainamupu ka mu bautagubu e kwakwarepui wadumpu kayatagubu ononomupu. Ki eweya ka mu kayatagubu apunu Diyoni powena sisiyai ki kuduba Iyesu simupu. ");
INSERT INTO gdn_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Iyesu apunu Diyoni powena sisiyai wainapupu ka e tawana ki kamadubu waka kawareya iyapana eba idiwu tawanai mo kayawena e ebo mena ika tondana ki nana. Ko iyapana e kaya-wena sisiyai wainamupu ki ka mu e kayawena ki deneya kaburu papateya kerapumugu kayatagubu kaiwa e duwareya buri bautagubu manako e nawanai ika idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Iyesu buri bau-wena waka kamadana wairau surana kwaewagawa ka e iyapana ropani kawaya bautagubu e nawanai ika idiwa emitapu manako e mu nuwaboyamaga wainapupu ubupu sigiramaga ebo ebo ki iyatapu. ");
INSERT INTO gdn_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Kemorawagawa makeya ka e tadeyau kabukabuwa ragidai e bameya bautagubu manako simupu, tagubu ke; “Madega surana kwaewagau, ko tawana yau ka tawa pa mena ki pokere kau iyapana ropani kawaya yau karako tonotami da mu kayatagisi tawa tawa bani dai mu mubo gimarapomoto teyomoto kupomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Mu inako tagubu, ko Iyesu mu emitapu denai tadebu, wagubu ke; “Ae, mu eba kayatagisi ko wi wiga baniga dai tepumuri tagemuri da mu kupomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","E yona ki wagubu ka mu denai tagubu ke; “Akae, nu ka bani buredi ida daikere mena ade raubiyo apeya ki mena yewe temipi.” ");
INSERT INTO gdn_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Ki baganai, bani ki tepumuri nau tegemuri.” ");
INSERT INTO gdn_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","E inako wagubu manako iyapana kuduba dewarepa kawareya idiwana ki nana tadebu. E bani buredi ida daikere mena ade raubiyo apeya mete kina ki tepupu esida kunumau yabu tapu e Mamai bameya parauwena manako bani buredi ki gerepupu e tadeyau kabukabuwa ragidai tagebu manako mu ubumpu iyapana tagempu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Iyapana kuduba bani ki kupampu matetagubu manako mu kupampu kewowena eweya ka Iyesu e tadeyau kabukabuwa ragidai bani pirai ki kwanamupu kode rabineya nunumupu ka kode ida esida kewowena kerapu apeya (12) positagubu. ");
INSERT INTO gdn_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ko mara ki makeya ka iyapana ropani kawaya eba bigabigai bani ki kupampu matetagubu. Apunu mena ka kuduba 5000, ko ridi yo munu mete kina ki mu eba iyabatampu. ");
INSERT INTO gdn_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Iyapana bani ki kupampu kewo-wena eweya ka Iyesu e tadeyau kabu-kabuwa ragidai tadebu, wagubu ke; “Wi yabiri waka kawareya kaburu papasi daikere kaiwagi ko nau ka ewa ika bausugani.” E inako wagubu manako wirawena iyapana kuduba ika dibimupu idiwa ki tonotapu mu mubo tawana-mugu tawanamugu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Iyapana kayatagubu kewowena eweya ka Iyesu e eya mena kwaunai mo yapu manako e eya mena e Mamai bameya ika guriguriwagawa tondawa da kemorawena. ");
INSERT INTO gdn_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Kemora ki rabineya ka nusuru towawa wirawena waka kaburu paunau gipiyawa kaniyawa, ");
INSERT INTO gdn_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","da mara waunitau dumai tarana kwaewagawa ka Iyesu kipu ubupu supu e kerareya kaburu kawareya e tadeyau kabukabuwa ragidai mu ewamugu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","E kayawena kaniyawa da mu bamamugu bauwagana kwaewagawa ka mu e kaburu kawareya e kerareya mu denemugu yabadawa emupu ki ka mu kudu ebotau wainamupu didiguramaga wagubu, tagubu ke; “Guba diyayai mo bauwagau.” Mu inako tagamawa kwetagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Ko Iyesu garugaru mena tadebu wagubu ke; “Yau ka nau, ki pokere kudu eba kwaiwogoi ko kasiyarai kawaya idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Apunu Pita Iyesu yonai ki waina-pupu ka e denai wagubu ke; “Kaiwa-woni, ki kau baganai ki kau nuwagi da nau mete kina nau kerapuneya kaburu kawareya kau bamageya kaniyani.” ");
INSERT INTO gdn_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Ki baganai, yabi.” Iyesu inako wagubu manako apunu Pita kipu ubupu waka kamadubu e kerareya kaburu kawareya Iyesu bameya kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","E kaburu kawareya kaniyawa ka e nusuru kasiyarai kawaya bauwena e weupana kwenupana kwaewagawa ki kudeya wainapupu. E kudu wainapiyawa makeya ka e kaburu rabineya surana kwaewagawa ki pokere e bonanai ragiragi kawaya wagubu ke; “Kaiwawoni, nau kaburu rabineya surakani ki pokere waitasini.” ");
INSERT INTO gdn_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","E inako wagubu, ko Iyesu garugaru mena e idaiya wadubu manako sibu, wagubu ke; “Pita, kau badidi pokere kau notagi apeya apeya inako wainapiyei? Kau kawaya daganani nau eba sumasiniyei.” ");
INSERT INTO gdn_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Mu waka kawareya positagubu makeya ka nusuru kewowena. ");
INSERT INTO gdn_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Iyesu e tadeyau kabukabuwa ragidai matakira ki emupu ka mu e si tepamupu, tagubu ke; “Mibai, kau ka Mamanuga God e eya Gubagai.” ");
INSERT INTO gdn_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Mu waka kawareya ade kaya-tagubu kaiwa da papasi buridere tawana Genesare bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Iyapana ika idiwa Iyesu kiyabui emupu ka mu garugaru mena kimpu ubumpu tawa tawa kayatagubu sigira ragidai tetampu Iyesu bameya bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Mu e midi tatamai mena geyapamana da mu iyatagamana ki nana e genemupu, manako sigira ragidai ki e midi tatamai geyamupu makeya ki ka mu kuduba iyatagubu gawarara. ");
INSERT INTO gdn_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Parisi ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina natere Diyerusaremu were bautagubu manako Iyesu manumupu, tagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Kau tadeyei kabukabuwa ragidai badidi pokere nu goranuga oragai ki nu ripakwarakwaranuguma nu kabuwanimawa kebomawa ki mu raurupiyamu mu idamaga gora ki pokaiya eba siruwapiyamu were bani kupamu?” ");
INSERT INTO gdn_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Wi gwede nana wi wiga goraga naigida mena wiwira-piyamu ko Mamanuga God e gorai tapu ki wi raurupiyamu? ");
INSERT INTO gdn_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Mamanuga God e okai wagubu ke; ‘Kau inagi mamagi naigida mena wiwiratamiyowa ade mu umunumaga wadowa’. Ade e okai mosi inako wagubu ke; ‘Iyapana nima e eya inai mamai tadebu siyasiya ki ka wi denai e minimuri poyo.’ ");
INSERT INTO gdn_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Mamanuga God e okai inako wagubu ko wi wibo nuwagau iwagamu da iyapana mosi e inai mamai nuwasiyasiya nene idiwu ki emitamini manako yagisi ke; ‘Nau wi waitaniyana gwede mo negeyana ko nau gwede ki winepuwani Mamanuga God nene tapuwani ki pokere nau wi negeyana ka eba baganai.’ ");
INSERT INTO gdn_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","E inako yagisi ki ka wi iwagi ke; ‘Baganai, kau inagi mamagi eba waitatamiyowa.’ Ko wi iyapana inako tadeyamu ki ka wi paerepiyamu Mamanuga God e gorai tapu ki wi raurupiyamu manako wi wibo kabuwaga ade wi wibo kaisiga ki mena makeya makeya kwaiwagamu. ");
INSERT INTO gdn_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Wi ka wi midiga pa matakawagau ragidai. Oragai apunai Aisaiya takari kawaya wi karako kwaiwagamu idiwu ki uwamau empupu manako wi nene oka mibai inako tapu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Mamanuga God e wagau; Iyapana yau nau sini pa umunumaga pokaiya tagamu wiwirasiniyamu, ko mu nuwamaga notamaga ka uwama kawaya, eba nau bamaneya. ");
INSERT INTO gdn_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Mu tagamu da mu nau sini tepa-piyamu ko mu kwaetagamu ki mibai ka pa mena. Mu muga goramaga iyapana naiya mu mubo notamaga pokaiya kwaetagamawa iwa ki mena mu makeya makeya kwaetagamu ade mu kowamuguma mete kabuwatamiyamu iwu. Ko gora kuduba mu wiwirapiyamu ki ka eba nau gorani. Pa mena.’ Oragai apunai Aisaiya wi sisiyaga inako wagubu.” ");
INSERT INTO gdn_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Iyesu iyapana ropani kawaya ika idiwa ki mu nene wagubu bautagubu manako tadebu, wagubu ke; “Nau yona yau suwagani ki mibai wi naigida mena wainapumuri kataiwagi wetawetara; ");
INSERT INTO gdn_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Wi gwede mosi wi umunugere kupumuri ki ka eba bani ki wi bigi negeni. Ko wi wibo rabinagau berokoi notapiyamu manako wi umunuga pokaiya matarau iwagamu ki mena wi bigi negeyau.” ");
INSERT INTO gdn_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Iyesu yona ki wagubu kewowena eweya ka e tadeyau kabukabuwa ragidai e bameya bautagubu manako simupu, tagubu ke; “Parisi ragidai kau yonagi ororeya mena nuwagibi ki mu wainamupu gagayatagubu ko kau ki wainapipi bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Mu inako tagubu, ko Iyesu denai tadebu wagubu ke; “Gwede ripai kuduba ki nau Mamai kunumau tondau e idere eba utapu ki ripai ka e aita ewa uburoto kwaitamini, ");
INSERT INTO gdn_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ki pokere wi Parisi ragidai mu nene eba wainapiyoi. Mu ka iyapana yabumaga kenekenei ragidai mu kawakawaimuguma, ade mu muga mete yabumaga kenekenei ki pokere mu yawata paerepiyamu. Yabui kenekenei apunai mosi ki eba uburoto e waretai yabui kenekenei ki e idaiya yadini yawata kabuwapoto. E inako kwaeyogono ki ka mu ewapuru yawata paerepomoto bobau gwepomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Iyesu yona ki wagubu ka apunu Pita denai wagubu ke; “Kau waigugu nuwagibi ki mibai kau matarau nu kabuwaniyo.” ");
INSERT INTO gdn_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ko Iyesu denai mu kuduba tadebu, wagubu ke; “Wi mete kina mu maba notababa wadamu bo? ");
INSERT INTO gdn_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Wi badidi pokere eba wainapiyamu? Bani kiyabui ebo ebo kupumuri ki suroto wi rabinagau tondono manako ewa baiyagisi kayayagisi. Ki ka eba bani ki wi nuwaga notaga bigi kweyau, ");
INSERT INTO gdn_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ko ki ka wi wibo rabinagau berokoi badidi wainapiyamu manako wi umunugere matarau iwagamu ki mena wi bigi negeyau. ");
INSERT INTO gdn_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Wi wibo nuwaga notaga nota berokoi ebo ebo wainapiyamu taininiyau ki pokaiya ka wi minimini popoiwagamu, deni deni rauru kawakawaraiwagamu, taku maba igida yauda asusu yabayababa iwu, kuwaiwagamu, yona beraiwagamu ade yanuwe teyateyama iwagamu. ");
INSERT INTO gdn_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Nota berokoi ebo ebo inako ki wi bigi negeyau, ko wi idaga eba siruwapiyamu were bani kupamu eba ki wi bigi negeyau.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Iyesu tawana ki kamadubu kaya-wena kaniyawa da tawana mosi natere Taya yo natere Saidoni bamamugu ika bauwena, ");
INSERT INTO gdn_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ka tawana Kainani ragidai mu ridimaga mosi ika tondawa ki Iyesu bameya bauwena manako e bonanai ragiragi kawaya sibu, wagubu ke; “Oragai apunai Dewida e momai, kau nau nuwaboyani wainapiyei bo pa mena? Kweya kairapu berokoi mosi nau peteni rabineya tondau ki pokere e makariwagau naigida eba ukwarau.” ");
INSERT INTO gdn_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Ridi ki inako wagubu, ko Iyesu yona daikere eba wagubu ki pokere e tadeyau kabukabuwa ragidai e bameya bautagubu manako simupu, tagubu ke; “Kau ridi yau tonopi da e kayayagisi mibai ka e midi togatoga nene yona-wagau tondau.” ");
INSERT INTO gdn_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Mu inako tagubu, ko Iyesu denai wagubu ke; “Tawana Isiraero ragidai papa sipi maba yawata paeremupu kwakotagubu kayatagubu ki mu nene mena ka nau Mamai nau tonosinibu kawapuwani.” ");
INSERT INTO gdn_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","E yona ki wagawa makeya ka ridi ki Iyesu yabareya kwarisiwena e ramatai kawareya ubupu manako sibu, wagubu ke; “Kaiwawoni, kau nau waitasini.” ");
INSERT INTO gdn_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","E inako wagubu, ko Iyesu denai wagubu ke; “Nau munu rasi banimaga tepani takumuguma kupamana nene isiyapani ki ka eba baganai.” ");
INSERT INTO gdn_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Iyesu inako wagubu, ko e waigugu wagubu ki mibai ka ridi ki wainapupu ki pokere e denai wagubu ke; “Kaiwawoni, kau yona mibai nuwagibi, ko munu rasi ki mu banimaga kupomono da pirai gwetagisi ki ka taku mete kupomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Iyesu yona ki wainapupu ka e denai sibu, wagubu ke; “Ridi, kau kawaya daganani nau sumasiniyei ki pokere kau petegi nene badidi wainapiyei ki nau kwaesugani.” Iyesu yona ki wagawa makeya ka ridi ki e petei deni mena iyawena. ");
INSERT INTO gdn_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Iyesu tawana ki kamadubu kayawena kaburu Gariri papateya bauwena manako kanibu kwaunai mo yapu kwarisiwena tondubu. ");
INSERT INTO gdn_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","E ika tondawa ka iyapana ropani kawaya e bameya ika bautagubu. Mu kowa-muguma idamaga kerapumaga bada-badamawena ragidai, yabumaga kenekenei ragidai, idamaga kerapu-maga korekorei ragidai, tenawarimaga badabadamawena bisi kayawena yona eba tagamawa ragidai, ade iyapana sigiramaga kiyabui ebo ebo ragidai ki mu tetamawa ika bautagamawa Iyesu yabareya nakatamawa manako e ubupu mu kuduba iyatapu. ");
INSERT INTO gdn_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Iyapana tenawarimaga badabadamawena bisi kayawena yona eba tagamawa ragidai ki mu ka yona ade tagubu, idamaga kerapumaga korekorei ragidai ki mu ka ade supasupatagubu, iyapana idamaga kerapumaga badabadamawena bisi kayawena ragidai ki mu ubumpu kerapumugu kayatagubu, ade iyapana yabumaga kenekenei ragidai ki mu ka tawana ade emupu. Iyapana kuduba ika idiwa matakira ki emupu ka mu nota-maga kowena kodabamaga kamupu manako tawana Isiraero ragidai mu Mamamaga God ki e si mu esida tepamupu. ");
INSERT INTO gdn_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Iyesu e tadeyau kabukabuwa ragidai mu nene wagubu bautagubu, manako tadebu, wagubu ke; “Nau iyapananiyoma yau mu nuwaboyamaga wainapakani. Mu dai ka tawana uwama kawaya were bautagubu mara apeya eyaka nu mete yewe idiweya ko mu banimaga ka pa mena. Nau mibi wetei mu tonotamani ki ka mu yamono da yawatau kasiyaramaga kewoyagisi wairorotagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Iyesu inako wagubu ko e tadeyau kabukabuwa ragidai denai e manumupu, tagubu ke; “Tawana yau ka gwabau iyapana eba idiwu tawanai ki pokere nu kaigamu iyapana ropani kawaya yau waitatamamu ki ka mu banimaga ki nu bani maba tepamu tageyamu da mu kupomoto?” ");
INSERT INTO gdn_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Mu inako tagubu, ko Iyesu mu manutapu, wagubu ke; “Wi masura boromai badibadi ika nunumupu?” Mu denai tagubu ke; “Nu masura ida daikere kewowena daikere apeya ki mena yewe temipi ade menamena maimerei munta eba ropani dai mete temipi.” ");
INSERT INTO gdn_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Iyesu yona ki wainapupu ka e iyapana kwarisitagamana waira kawareya idiwana ki nana wagubu, ");
INSERT INTO gdn_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","manako e masura ida daikere kewo-wena daikere apeya ki ade menamena ki mete tepupu kunumau esida Mamanuga God bameya parauwena. E bani ki gerepupu e tadeyau kabu-kabuwa ragidai tagebu manako mu bani ki temupu iyapana tagemupu kaya-tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Mara ki makeya ka iyapana ropani kawaya ki kuduba bani ki kupampu matetagubu. Mu kupamawa idiwa da kamadumpu ka e tadeyau kabukabuwa ragidai bani pirai kwana-mupu kode rabineya nunumupu manako kode ida daikere kewowena daikere apeya (7) positagubu. ");
INSERT INTO gdn_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Iyapana ropani kawaya bani ki kupampu matetagubu apunu mena ka kuduba 4000 ko ridi yo munu mete kina ki mu eba iyabatampu. ");
INSERT INTO gdn_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ko Iyesu iyapana tonotapu kaya-tagubu manako e tadeyau kabukabuwa ragidai mete waka rabineya yamupu tawana Magadani kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Ki eweya ka Parisi ragidai ade Sadusi ragidai Iyesu kerareya wadamana da e yona mo paerepana bo eba paerepana ki empamana ki nana e bameya bautagubu manako manumupu, tagubu ke; “Kau kunuma kasiyarai pokaiya matakira mo kwaenuwagi da nu kau eminiyamu.” ");
INSERT INTO gdn_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Iyesu yona ki wainapupu ka e denai tadebu, wagubu ke; “Madega surau gugu beuwagau empiyamu ki ka wi iwagi ke; ‘Gugu beuwena ki pokere marawani ka kwamura puruyagisi’, ");
INSERT INTO gdn_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ade wi didiburu oroguma pinipini-wagau empiyamu ki ka wi iwagi ke; ‘Oroguma pinipiniwena ki pokere kemora nene ka nawaya baiyagisi.’ Wi ka kunuma yo waira kiyabumaga empiyamu manako ki pokaiya ka wi kataiwagamu da nawaya baiyagisi bo kwamura uburoto. Ko Mamanuga God karako kwaewagau ki mibai wi badidi pokere eba empiyamu bo wainapiyamu? ");
INSERT INTO gdn_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Wi karako idiwu ragidai wi beraga ka eba bagi ade Mamanuga God bameya ka wi rauru kawakawara ki berai maba kwaiwagamu ki pokere wi kunuma matakirai empamana ki nana iwagamu ki mo nau eba kwaesugani. Mamanuga God e bonanai wainapiyawa wagawa apunai Diyouna matakira badidi kwae-wena ki kawareya mena nau wi kabuwa-niyani.” Iyesu inako wagubu manako kamaditapu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Mu waka kawareya kayatagubu kaiwa ka Iyesu e tadeyau kabukabuwa ragidai wainamupu da mu masura dai eba temupu. ");
INSERT INTO gdn_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ko Iyesu tadebu, wagubu ke; “Nau suwagani wainapumuri; Parisi ragidai ade Sadusi ragidai mete kina mu banimaga bedebedepupu ki wi naigida mena empiyoi kaisipiyoi kwaenda mu banimaga kinokinoi ki wi pasiniyoto giriniyoto.” ");
INSERT INTO gdn_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Iyesu yona ki wagubu ka e tadeyau kabukabuwa ragidai babatagubu manako mu mubo mubo deni deni manu kasiwaratagamawa, tagamawa ke; “Nu masuranuga dai eba temipi ki pokere e inako wagau bo?” ");
INSERT INTO gdn_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Mu notamaga badidi wagawa ki Iyesu ororeya mena kataiwena ki pokere e manutapu, wagubu ke; “Wi badidi pokere masura dai eba temupu ki kawareya iwagamu? Wi sumaga nau bamaneya ka eba kawaya. ");
INSERT INTO gdn_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Nau keyakeyai suwagubuwani ki mibai wi eba wainamupu bo? Nau naiya bani buredi ida daikere mena gerepuwani iyapana uratanai mena 5000 tagebuwani kupampu matetagubu gawarara ki ka wi bani pirai uburawa ki kode badibadi positampu? Wi ki wainapiyamu bo pa mena? ");
INSERT INTO gdn_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Ade nau masura ida daikere kewowena daikere apeya gerepuwani iyapana 4000 tagebuwani kupampu matetagubu ki ka wi bani pirai uburawa ki kode badibadi positampu?” ");
INSERT INTO gdn_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Nau eba bani kaina nene suwagubuwani ko nau Parisi ragidai ade Sadusi ragidai mu banimaga bedebedepupu ki wi naigida mena empamana kaisipamana ki nana suwagubuwani. Ko wi badidi pokere keyakeyai ki mibai eba wainamupu?” ");
INSERT INTO gdn_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Iyesu yona ki wagubu ka e tadeyau kabukabuwa ragidai wainamupu da e eba bani kaina bedebedepupu kinokino-wena ki nene wagubu ko e Parisi ragidai ade Sadusi ragidai mu kabuwamaga ki naigida mena empamana kaisipamana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Ki eweya ka Iyesu e tadeyau kabukabuwa ragidai mete kina natere Sisaraiya Piripai ade natere dai bameya bameya mete kina ki deneya kaya-tagubu. Mu yawatau kayatagubu kaiwa ka Iyesu mu manutapu, wagubu ke; “Nau Kunumau Kawapuwani Apunai nau nene ka iyapana badidi tagamu?” ");
INSERT INTO gdn_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Mu dai tagamu da kau ka iyapana siruwatamiyawa apunai Diyoni, ade dai tagamu da kau ka oragai apunai Eraidiya ade wiranugibi baunugibi, ade dai tagamu da kau ka Mamanuga God e bonanai wainapiyawa wagawa apunai Diyeremaiya bo ade e waretai mosi.” ");
INSERT INTO gdn_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Mu inako tagubu manako Iyesu mu ade manutapu, wagubu ke; “Ko wiyo, wi wainapiyamu da nau ka nima?” ");
INSERT INTO gdn_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","E inako wagubu ka apunu Saimoni si daikere Pita denai wagubu ke; “Kau ka Mesaiya. Kau ka nu Iya Negeyana Apunai Keriso. Kau ka Mamanuga God mara-mara tondau apunai e eya Gubagai.” ");
INSERT INTO gdn_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Apunu Pita inako wagubu manako Iyesu denai e sibu, wagubu ke; “Apunu Diyouna e gubagai Saimoni, kau yona mibai nuwagibi ki pokere mamama-nugowa. Kau yona inako nuwagibi ki ka eba iyapana kaina mo kau kabuwanibu ko nau Mamai kunumau tondau e mena kau kabuwanibu ki makeya kau nuwagibi. ");
INSERT INTO gdn_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Apunu Pita, nau nidiyani wainapi; Kau sigi ka waigugu ko ki mibai ka ‘bowa’ ki pokere bowa ki kawareya ka nau bebedani kaupani nau tawani yadani manako nau sumasiniyamu ragidai kau pokagere ropanitagisi ade mu sumamaga ragiragiyagisi. Po kasiyarai ki baiyagisi nau sumasiniyamu ragidai ki bodata-mana kwaeyogono ko po kasiyarai ki mu eba raurutamini bo bodatamini. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Mamanuga God e gari kunumau ki kasiparai nau kau negeyani ki pokere kau yewe wairau gwede mo bodapana eba wenawagana nuwagi ki ka Mamanuga God usi kunumau ki e mete bodapoto da eba wenayagisi. Ade kau yewe wairau gwede mo wenawagana ki nana baganai nuwagi ki ka Mamanuga God usi kunumau ki e mete baganai yagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Iyesu inako wagubu manako wirawena e tadeyau kabukabuwa ragidai mu umunumaga umapu, wagubu ke; “Nau ka wi Iya Negeyana Apunai Keriso ko yona ki wi iyapana eba tademuri.” ");
INSERT INTO gdn_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Naiya ka Iyesu e powagana sisiyai e tadeyau kabukabuwa ragidai matarau eba tadebu ko karako ade ewa ka e mu inako tadebu, wagubu ke; “Nau natere Diyerusaremu kayasugani manako iyapana kawakawai Mamanuga God bameya dobopiyamu ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina ki mu ubumoto nau wadisinimoto bita midi makari kawaya daganani tegeni. Mu nau wadisinimoto deni mena susinimoto poyo ko mara apeya eyaka kewoyagisi eweya ka nau ade iyasugani kirani uburani.” ");
INSERT INTO gdn_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Iyesu e powagana sisiyai matarau inako wagubu wainapupu ka apunu Pita ubupu Iyesu wadubu paere bananapupu mubo kayatagubu manako e ubupu Iyesu sisibapupu, wagubu ke; “Kaiwawoni, mu kau bamageya inako kwaetogomono ki ka Mamanuga God mu bodatamini da kau bamageya inako eba wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","E inako wagubu ko Iyesu wira-wena e empupu manako denai sibu, wagubu ke; “Pita, kau ka Seitani. Kau nau yawatani bodapiyei ki pokere nau taganeya kayanuwagi. Kau eba nau Mamai God e nuwaiya ki nuwegei ko kau iyapana kaina mu notamaga ki nuwegei.” ");
INSERT INTO gdn_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Iyesu inako wagubu manako ade wirawena e tadeyau kabukabuwa ragidai kuduba tadebu, wagubu ke; “Iyapana nima nuwaiya nau ewaneya kayawagana wainapiyau ki ka e gwedegwede kuduba e eya iyai nene wainapiyau ki kamadini manako e bita makari nau pokanere bananapana ki kudeya e eba wainapono ko kasiyarai kawaya uburoto e eya korosi kawara-poto yabadini nau ewaneya uburoto kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Iyapana nima e ebo iyai karako nene wainapiyau ki ka e eya iyai ewa nene ki e kaupiyau. Ko iyapana nima nau pokanere e eya iyai karako nene kaupiyau ki ka aita ewa ka e iya mibai bananapoto yadini. ");
INSERT INTO gdn_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Iyapana mosi e eya iyai karako nene wainapiyau ade waira purapurai kuduba, madega kauwagau madega posiwagau ki tepiyau niniyapiyau, ki ka e poyagisi makeya ka e gwedegwedei ki kuduba kamadini kayayagisi ko denai mo eba yadini. E eya iyai mibai ki e kaupupu kewowena. ");
INSERT INTO gdn_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Nau Kunumau Kawapuwani Apunai uburani nau Mamai e tanai bagi kawaya ki kasiyarai pokaiya nau aneyaniyoma tetamani mete kawamamu makeya ki ka iyapana kuduba, madega kauwagau madega posiwagau mu badidi kwae-tagamawa ki makeya mena ka nau mu denai tageyani. ");
INSERT INTO gdn_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Nau yonani yau nidiyakani ki wi naigida mena wainapu-muri; Wi karako idiwu ragidai nau Kunumau Kawapuwani Apunai kaiwawo-sugana ki marai baiyagisi emisinimuri were ka wi dai popoiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Mara ida daikere kewowena daikere eyaka mena ki eweya ka Iyesu ubupu apunu Pita, apunu Diyemesi ade Diyemesi e yowai Diyoni mete kina waratapu mu muga mena kweya kawaya mo yampu kwauneya positagubu. ");
INSERT INTO gdn_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Mu ika idiwa ka Iyesu e midi kuduba wirawena ebo wenawena. E kiyabui wirawena tanai ka madega sinini maba ade e midi tatamai poe kawaya wirawena taniwena ki mu mete emupu. ");
INSERT INTO gdn_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Mu empamawa idiwa ka oragai popotagubu ragidai Mosisi yo Eraidiya mataratagubu bautagubu Iyesu mete yonatagamawa idiwa ki mu emitampu. ");
INSERT INTO gdn_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Emitamawa ka apunu Pita ubupu Iyesu inako sibu, wagubu ke; “Kaiwawoni, nu wi mete yewe idiwei ka bagi kawaya. Kau nuwageya ki ka nau karako nabonabo apeya eyaka yewe yadani, mosi kau nene, mosi apunu Mosisi nene ade mosi apunu Eraidiya nene.” ");
INSERT INTO gdn_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Apunu Pita yona ki wagawa makeya ka oroguma poe tanai kawaya mo mu kawarimugu kawapu manako bonana mosi oroguma rabineya mete bauwena, wagubu ke; “Yau ka nau Gubagani. Nau nuwaneya po eyo ki pokere e mamamai nau suwagakani. E mena yonai ki wi wainapiyoi idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Iyesu e tadeyau kabukabuwa ragidai bonana ki wainamupu ka mu notamaga kowena kudu mete wainamupu manako gwairitagubu nikapu mempu wairau ukwampu. ");
INSERT INTO gdn_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ko Iyesu mu bamamugu bauwena geyatapu manako tadebu wagubu ke; “Kimuri ubumuri ko kudu eba wainapiyoi.” ");
INSERT INTO gdn_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","E inako wagubu ka mu yabu tampu manako mu Iyesu e ebo mena ika uburawa emupu. ");
INSERT INTO gdn_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Mu kweya were wiratagubu kawamawa ka Iyesu mu tatamatapu, wagubu ke; “Wi karako badidi yabugere matarau waro were maba emupu ki sisiyai wi iyapana eba tademuri. Nau Kunumau Kawapuwani Apunai posugani ade iyasugani kirani uburani eweya ka wi iyapana tademuri.” ");
INSERT INTO gdn_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Iyesu inako wagubu ka e tadeyau kabukabuwa ragidai ki e manumupu, tagubu ke; “Gora kataimugu ragidai badidi pokere tagamu da oragai apunai Eraidiya e yabiri baiyagisi?” ");
INSERT INTO gdn_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Mu apunu Eraidiya nene inako tagamu ki mibai. E yabiri baiyagisi gwedegwede kuduba okukuna-yagisi. ");
INSERT INTO gdn_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ko nau ade suwagani wainapu-muri; Oragai apunai Eraidiya e ororeya mena wirawena bauwena ko iyapana e gogomupu manako mu mubo nuwamugu e bameya berokoi badidi kwaetagamana wainamupu ki mu kwaetagubu. Ki kwaitana ka iyapana ubumoto Kunumau Kawapuwani Apunai nau bamaneya inako mete kwaetagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Iyesu yona ki wagawa makeya ka e tadeyau kabukabuwa ragidai katai-tagubu da e wagubu ki ka e iyapana siruwatamiyawa apunai Diyoni ki e nene wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Mu ade wiratagubu iyapana ropani kawaya ki mu bamamugu bautagubu ka apunu mosi Iyesu bameya bauwena e yabareya kwarisiwena e ramatai kawareya ubupu, ");
INSERT INTO gdn_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","manako sibu, wagubu ke; “Nidiyei Kabukabuwa Apunai, nau gubagani e nuwaboyai ki kau wainapi. Kweya kairapu mosi e rabineya tondau ki e wadau kwisikwisi-piyau ku kawareya matau kwenupiyau ade awanau mete kwenupiyau. ");
INSERT INTO gdn_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Nau e wadubuwani kau tadeyei kabukabuwa ragidai mu bamamugu bausugubuwani da mu e iyapamana ki nana, ko mu kwaetagubu ko e eba iyawena.” ");
INSERT INTO gdn_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Apunu ki inako wagubu, ko Iyesu denai wagubu ke; “Wi nau eba sumasini-yamu ragidai. Wi nau matesiniyamu idiwu. Nau mara badibadi yabaranugu wi mete yewe idiwomu da wi nau suma-sinimuri? Ko baganai, munu ki wadu-muri nau bamaneya kebomuri.” ");
INSERT INTO gdn_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Mu munu ki wadumpu bautagubu ka Iyesu kweya kairapu munu ki rabineya tondawa ki siwakekepupu bauwena kayawena manako ki makeya ka munu ki deni mena iyawena. ");
INSERT INTO gdn_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ki eweya ka Iyesu e tadeyau kabukabuwa ragidai mubo mena e bameya bautagubu manako manumupu, tagubu ke; “Nu badidi pokere keyai berokoi ki simipi ko e eba bauwena kayawena?” ");
INSERT INTO gdn_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Mu inako manumupu, ko Iyesu denai tadebu wagubu ke; “Ki mibai wi sumaga ka eba kawaya. Ko nau nidiyani wainapumuri; Ripa damaya madai ki bonai rabineya ka rasirasi. Wi marai munta ki maba nau mibai sumasinimuri ki ka wi kweya yau simuri, iwagi ke; ‘Kau kiya kiri uburi buri kayanuwagi’, wi inako iwagi ki ka kweya ki kiroto uburoto kayayagisi. Wi nau inako sumasiniyoi ki ka wi badidi iwagi ki kuduba wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Ko wi kweya kairapu yau maba siwakekepamana ki ka wi yabiri Mamanuga God e nene bani kamadumuri ade guriguriwagi were ewa e siwakekepumuri da e baiyagisi kaya-yagisi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Iyesu e tadeyau kabukabuwa ragidai kuduba tawana Gariri rabineya bautagubu dibimupu idiwa ka Iyesu mu tadebu, wagubu ke; “Iyapana ubumoto Kunumau Kawapuwani Apunai nau nidani tagisi manako iyapana dai ki mu idamaga rabineya tamusinimoto, ");
INSERT INTO gdn_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","da mu nau susinimoto poyo. Mu nau susinimoto poyo, ko mara apeya eyaka kewoyagisi eweya ki nau ade iyasugani kirani uburani.” Iyesu e tadeyau kabukabuwa ragidai yona ki wainamupu ka mu nuwaboya-tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Mu natere Kaponiyamu bautagubu ka Mamanuga God e Tawai ki takesi wadamu ragidai bautagubu apunu Pita manumupu, tagubu ke; “Wi Nidiyau Kabukabuwa Apunai ki e nu wairanuga denai takesi tarau bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“Ena, e takesi tarau.” Pita inako wagubu ko e tawa rabineya yapu ka Iyesu wirawena e sibu, wagubu ke; “Saimoni, kau badidi wainapiyei? Iyapana gwedewau waira yau kawakawaimuguma mu bamamugu takesi tamoto? Iyapana kwaiyanai ragidai mu mena takesi ki tamoto bo taubanuwai ragidai mete kina?” ");
INSERT INTO gdn_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Ki ka iyapana kwaiyanai ragidai ki mu mena takesi ki tamoto.” Pita inako wagubu ko Iyesu denai e sibu, wagubu ke; “Baganai, inako ki ka nu taubanuwai ragidai waira ki denai takesi eba tamana. ");
INSERT INTO gdn_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Ko Mamanuga God e tawai ki takesi wadamu ragidai nu bamanugu eba gunaratagamana ki nana ka kau kayanuwagi kimai kaburu kwenupi manako menamena yabiri tainipi ki e kodabai ki kau wadi waka manako e rabineya ka kau nu takesi tamana ki bowai madai ika emani. Kau bowa madai ki wadi manako kaya-nuwagi takesi wadamu ragidai mu bamamugu nau yo wi ewapuru takesinuga tari.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Mara ki makeya ka Iyesu e tadeyau kabukabuwa ragidai e bameya bautagubu manako manumupu, tagubu ke; “Kunumau, Mamanuga God e gari rabineya nima si ka kawaya esida?” ");
INSERT INTO gdn_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ko Iyesu munu marai munta mo nene wagubu bauwena wadubu mu yabaramugu tapu, ");
INSERT INTO gdn_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","manako tadebu, wagubu ke; “Nau yona mibai nidiyani wainapumuri; Iyapana kawakawai wi notaga munu rasi mu notamaga maba ki ka wi Mamanuga God e bameya kaiwuri e gari rabineya bagi kawaya idiwoi. Ko wi notaga eba munu rasi mu notamaga maba ki ka wi Mamanuga God e bameya eba kaiwuri ade e gari rabineya eba idiwoi. ");
INSERT INTO gdn_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Nima iyapana yabaramugu ebo kwarisiyagisi manako munu marai munta yau e notai maba tondono ki ka aita ewa Mamanuga God e gari rabineya ka iyapana ki kawaya-yagisi. ");
INSERT INTO gdn_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Ade iyapana nima nau sini pokaiya munu yau maba e diriwai kwaewagau ki ka e nau diriwani mete kwaewagau. ");
INSERT INTO gdn_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Ko iyapana nima uburoto nau sumasiniyau apunai bo ridai ki pisipisipoto da e sumai nau bamaneya ki kauyagisi, akae, iyapana ki ka aita bita kawaya mo bananapoto. Iyapana e wadumpena bowa bisi kawaya mo taburuba pokaiya kwimpena e gobaiya umampena manako egi rabineya kwenumpena ki ka e nene baganai. ");
INSERT INTO gdn_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Gwede marai kawai iyapana tainitamiyau da mu paerepiyamu bigi kwaetagamu, ko iyapana nima e waretai ki e kerareya wadau da e bigi kwaewagau, akae, iyapana ki ka aita berokoi kawaya eba marai bananapoto. ");
INSERT INTO gdn_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Ki pokere, kau idagi bo kau kerapugi daikere berokoi kwaenugana ki nana taininiyau da kau sumagi ki pokaiya kaupana kwaenugei, ki kau kaubo uburi kau idagi bo kau kerapugi ki mei puru kwenupi. Kau idagi bo kau kerapugi daikere mena pokaiya kanenenugowa umowa da ewa iya maramara tondana kaniyana ki iyai bananapi ki ka bagi kawaya. Ko kau idagi bo kau kerapugi daikere daikere pokaiya inako umowa da mu aita ewa kau wadinimoto mata maramara urau ki nonareya kwenuni-moto ki ka berokoi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Ade kau yabugi daikere berokoi kwaenugana ki nana taininiyau da kau sumagi ki pokaiya kaupana kwaenugei, ki kau kaubo uburi kau yabugi ki wadi toporu kwenupi. Kau yabugi eyaka mena bagi ki mena pokaiya umowa da ewa iya maramara tondana kaniyana ki iyai bananapi ki ka bagi kawaya. Ko kau yabugi daikere daikere pokaiya inako umowa da mu aita ewa kau wadinimoto mata maramara urau ki nonareya kwenunimoto ki ka berokoi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Wi munu rasi yau maba eba waigubatamiyoi mibai ka mu aneya-muguma ka maramara kunumau nau Mamai e yabareya ubumu. ");
INSERT INTO gdn_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Iyapana Mamanuga God e yawatai paeremupu ragidai ki mu waratamana iya waunai tageyana ki nana ka nau Kunumau Kawapuwani Apunai bausugubuwani. ");
INSERT INTO gdn_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Nau keyakeyai mo suwagani waina-pumuri; Apunu mosi e papaiyoma sipi ropani kawaya apunai ida daikere mena (100) manako e papaiyoma ki mu paunamugu papa sipi eyaka mena mo yadini kaupoto ki ka e badidi kwae-yagisi? Nau nidiyani wainapumuri; E papaiyoma dai ki kuduba 99 ki gwabau kamaditamini manako papa eyaka mena wadubu kaupupu ki e kwaenei kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","E kwaenepono umono da bananapoto ki ka e papa eyaka mena ki e nene mamama kawaya wainapoto ko e papaiyoma ropani kawaya eba waditapu nunutapu ki mu nene ka e mamama maraitau wainapoto. ");
INSERT INTO gdn_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ki maba, wi Mamaga kunumau tondau e eba nuwaiya e munui eyaka mena yau maba mo yawata paerepoto kwakoyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Iyesu ade tadebu, wagubu ke; “Kau waretagi mosi berokoi mo kau bamageya kwaeyagisi ki kau yabiri e bameya kayanuwagi manako wi apeya wiga mena e paerei kwaewena ki wadumuri supasupa. E kau yonagi wainapoto ki ka baganai, ");
INSERT INTO gdn_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ko e kau yonagi ki eba wainapiyau ki kau uburi kau kowagiyoma apeya bo apeya eyaka inako waratami e bameya kaiwagi manako e badidi wagau ki mu mete wainapomoto. Kau inako kwaenuwagi ki kau Mamanuga God e okai wagubu ki makeya kwaenugei. Oka ki wagubu ke; ‘Iyapana apeya bo apeya eyaka baitagisi gwede ewapuru emupu ki tagisi matara ki ka wi mu yonamaga ki mibipumuri.’ ");
INSERT INTO gdn_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Ko paere kwaewena apunai ki uburoto kau kowagiyoma mu yonamaga mete eba wainapoto ki kau kayanuwagi iyapana ika Mamanuga God nene dibipiyamu idiwu ragidai kuduba mu paunamugu uburi nuwagi da mu mete kina e badidi kwaewena ki sisiyai mu wainapomoto. Ko e mu yonamaga mete eba wainapoto ki kau e deni mena kamadi kayanuwagi. Mamanuga God tagararapiyamu ragidai ade takesi wadamu ragidai mu bama-mugu wi badidi kwaiwagamu ki maba kau e bameya inako mete kwaenuwagi tagararapi. ");
INSERT INTO gdn_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Nau wi kuduba yona mibai nidiyani wainapumuri; Wi yewe wairau gwede mo bodapamana eba wena-wagana iwagi ki ka Mamanuga God usi kunumau gwede ki mete bodapoto da eba wenayagisi. Ade wi yewe wairau gwede mo wenawagana ki nana baganai iwagi ki ka Mamanuga God usi kunumau gwede ki nene mete baganai yagisi. ");
INSERT INTO gdn_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Ade nau yona yau mete suwagani wainapumuri; Wi apeya yewe wairau gwede mo nene wi nuwaga notaga eyaka mena pokaiya guriguriwagi ki ka nau Mamai kunumau tondau wi badidi iwagubu ki makeya makeya e kwae-yagisi. ");
INSERT INTO gdn_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Mibai, wi apeya bo apeya eyaka nau sini pokaiya ewapuru dibipu-muri idiwoi ki ka nau mete kina ika wi paunagau.” ");
INSERT INTO gdn_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ki makeya ka apunu Pita Iyesu bameya bauwena manako manupupu, wagubu ke; “Kaiwawoni, nau waretani nau girisiniyono pasusiniyono ki ka nau mara badibadi e paere nau bamaneya kwaewena ki nau notaneya deni mena surupani? Nau mara ida daikere kewo-wena daikere apeya ki kwaesugani ka baganai bo? ");
INSERT INTO gdn_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Apunu Pita inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Kau eba mara ida daikere kewowena daikere apeya mena inako kwaenuwagi ko maramara kawareya kawareya ka kau e badidi paerepiyau ki kau notageya deni mena surupi. ");
INSERT INTO gdn_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Ki pokere, Mamanuga God e gari rabineya kunumau ka badidi maba ki nau karako keyakeyai mosi wi kabuwaniyani wainapumuri; Mara mosi ka apunu kawai mo ubupu iyapana e bameya gwedegwede sikwatagubu ki denai e kweyamana ki nana mu yona-maga tonopupu. ");
INSERT INTO gdn_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Mu denai kweya-mana marai ki bauwena ka e kowa-kowaiyoma dai tonotapu kayatagubu yabiri e bigabigai apunai mosi ki bowa madai kawaya daganani eba iyaba-pamana makai e bameya sikwawena apunai ki wadumpu bautagubu e yabareya tamupu. ");
INSERT INTO gdn_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Bigabiga apunai ki sikwa kawaya daganani kwaewena denai tarana ki makai eba wadubu ki pokere apunu kawai ki ubupu bigabiga apunai ki sibu, wagubu ke; ‘Kau ridigi munugiyoma mete kina ade kau gwedegwedegi kuduba ki iyapana baitagisi tepomoto manako mu bowa madai wi deniga tamoto ki nau yadani.’ ");
INSERT INTO gdn_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Bigabiga apunai yona ki waina-pupu ka e kwarisiwena e ramatai kawareya ubupu manako e kawai ki genepupu sibu, wagubu ke; ‘Bada, kau nuwagi nau bamaneya ki eba pupu-yogono ko nawananugowa. Nau sikwasugubuwani ki denai kuduba nau ewa were kau negeyani.’ ");
INSERT INTO gdn_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","E inako wagubu ka apunu kawai ki e notai wirawena e bigabigai apunai ki e nuwaboyai wainapupu manako e ubupu apunu ki e bameya badidi sikwawena ki kuduba deni mena surupupu pa tonopupu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Bigabiga apunai ki tawa ki kama-dubu bauwena kayawena kaniyawa ka e waretai mosi ika bananapupu. E waretai ki ka naiya bowa madai eba ropani bigabiga apunai ki e bameya sikwawena ko bigabiga apunai ki e waretai karako empupu ka e kanibu e gobaiya wadubu manako ragiragi kawaya sibu, wagubu ke; ‘Kau naiya nau bamaneya sikwa-nugibi ki denai kau karako mena tege.’ ");
INSERT INTO gdn_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","E waretai yona ki wainapupu ka e kwarisiwena e ramatai kawareya ubupu manako bigabiga apunai ki sibu, wagubu ke; ‘Kabai, kau nuwagi nau bamaneya eba pupuyogono ko nawananugowa. Nau sikwasugubuwani ki denai kuduba nau ewa were kau negeyani.’ ");
INSERT INTO gdn_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","E inako wagubu, ko bigabiga apunai ki e waretai ki e nuwaboyai eba wainapupu ko e wadubu diburapupu ika tondana da e sikwa-wena ki denai kuduba bodapana were. ");
INSERT INTO gdn_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Bigabiga ragidai dai ki mu wareta-maga badidi kwaewena emupu ka mu gagayatagubu manako kayatagubu kawaimaga sisiya ki kuduba simupu. ");
INSERT INTO gdn_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Apunu kawai ki yona ki wainapupu ka e bigabiga apunai ki e nene ade wagubu bauwena manako nakaripupu sibu, wagubu ke; ‘Kau ka berokoi. Kau bigabiga beranugei. Kau genesinibi ki pokere kau bowa madai kawaya daganani nau bamaneya sikwanugibi ki kuduba nau deni mena surupuwani notagogapuwani. ");
INSERT INTO gdn_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Nau kau nuwanuwa-nibuwani ki pokere kau mete kina ka kau waretagi e nuwaboyai wainapena.’ ");
INSERT INTO gdn_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Apunu kawai ki e nuwai e bigabigai apunai ki bameya pupuwena manako e wadubu diburapupu ika tondana bita wadana da e sikwawena ki denai kuduba bodapana were.” ");
INSERT INTO gdn_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Iyesu keyakeyai ki wagubu kewo-wena ka e wirawena e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Nau keyakeyai suwagubuwani ki maba ka wi kowaguma paere wi bamagau badidi kwaetagamu ki kuduba wi notagau deni mena surupumuri. Wi inako eba kwaiwagi ki ka nau Mamai kunumau tondau e uburoto apunu kawai ki e bigabigai apunai bameya badidi kwae-wena ki maba e wi bamagau inako mete kwaeyagisi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Iyesu yona ki wagubu kewowena ka e tawana Gariri kama-dubu kayawena kaniyawa da tawana Diyudiya bauwena ka e awana Diyoudani purupupu papasi daikere bauwena tondawa. ");
INSERT INTO gdn_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Iyapana ropani kawaya e ewakumapamawa iwa ki e mu ika iyatapu. ");
INSERT INTO gdn_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","E ika tondawa ka Parisi ragidai dai bautagubu e manupamana da e yona mo paerepana manako mu ki pokaiya e wadamana ki nana e bameya bautagubu manako simupu, tagubu ke; “Apunu mosi e ebo nuwaiya e wainai pa ragipana wainapiyau ki ka nu goranuga wagau da ki ka baganai bo eba baganai?” ");
INSERT INTO gdn_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Mu inako tagubu, ko Iyesu denai mu manutapu, wagubu ke; “Mamanuga God e okai ki wi iyabamupu bo pa mena? E okai wagubu da e kunuma waira yamanapupu makeya ki ka e ridi yo apunu ewapuru yamanatapu. ");
INSERT INTO gdn_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","E mu yamanatapu manako wagubu ke; ‘Apunu mosi karako e inai mamai kamaditamini ridi mosi uworoto manako mu apeya wainai nobomoi ewapuru eyaka mena idiwono.’ ");
INSERT INTO gdn_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Naiya ka mu mubo mubo idiwa ko karako ka mu ewapuru eyaka mena idiwu ki pokere Mamanuga God ridi yo apunu inako dibitapu ki ka iyapana mo eba baiyagisi mu wade purupurutamini.” ");
INSERT INTO gdn_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Iyesu inako wagubu wainamupu ka Parisi ragidai ki denai e manumupu, tagubu ke; “Kau nuwegei ki mibai maba ki ka oragai apunai Mosisi badidi pokere nu goranuga tapu, wagubu ke; ‘Apunu mosi nuwaiya ka e wainai ragipana wainapiyau ki ka e anika meyana puru ki yonai oka pokaiya taroto manako e ridi ki tonopoto deni mena kayayagisi.” ’ ");
INSERT INTO gdn_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Mu inako tagubu, ko Iyesu denai wagubu ke; “Wi rabinaga ka ragiragi kawaya ki pokere ka oragai apunai Mosisi gora ki wi nene tapu. Ko kerareya Mamanuga God iyapana yamanatapu makeya ka inako pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Nau yona mibai nidiyani wainapumuri; Ridi mosi rauru kawakawara ki berai mo eba kwaewena ko e nobomoi uburoto e wainai ki pa asusu ragipoto manako kayayagisi ridi kudubai mosi uworoto, ki ka apunu ki e wainai yabiri ki rauru kawakawarapupu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Iyesu e tadeyau kabukabuwa ragidai yona ki wainamupu ka mu Iyesu simupu, tagubu ke; “Waina nobomo inako idiwana ki ka nu ridi eba tauwa-mana ko pa idiwana wainapemei.” ");
INSERT INTO gdn_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Nau yona suwagu-buwani ki iyapana kuduba eba waina-pomoto ko Mamanuga God yona ki wainapamana notai tagebu ragidai ki mu mena ka yona ki mibai waina-pomoto. ");
INSERT INTO gdn_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Mibai ebo ebo ki pokaiya ka iyapana dai ridi eba tauwamu; Dai wenatagubu siyasiya ki pokere, dai ka iyapana mu kwakwarepumaga rigamupu ki pokere, ade dai ka Mamanuga God e gari kunumau ki mena diriwai kwae-tagamu ki pokere mu ridi eba tauwamu. Iyapana gwedewau yona yau wainapa-mana wainapiyamu ki ka baganai mu wainapomoto.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Iyapana dai mu munumuguma tetampu Iyesu bameya bautagubu da e idai mu kawarimugu tarana mu nene guriguriwagana ki nana. Ko e tadeyau kabukabuwa ragidai ubumpu iyapana ki nakaritampu baiyonotampu. ");
INSERT INTO gdn_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Mu inako kwaetagamawa ko Iyesu tadebu, wagubu ke; “Munu rasi nau bamaneya kebomono ki wi mu yawata-maga eba bodapiyoi. Mu ka nau Mamai God e gari rabineya kaiwoto e kasiyarai pokaiya bagi kawaya idiwono.” ");
INSERT INTO gdn_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E inako wagubu manako e idai munu ki kawarimugu tapu waditapu bagi manako ewa kamaditapu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Mara mosi ka apunu mosi Iyesu bameya bauwena manako manupupu, wagubu ke; “Sidiyei Kabukabuwa Apunai, nau bagi badidi maba kwae-sugani da nau denai iya waunai banana-pani maramara tondoni kaniyoni?” ");
INSERT INTO gdn_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Apunu ki inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Kau gwede bagi nene nau manusinibi ki mibai ka badidi? Mamanuga God e eya mena ka bagi. Kau e gorai tapu ki makeya makeya kwaenugowa ki kau iya ki wadi.” ");
INSERT INTO gdn_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Iyesu inako wagubu, ko apunu ki denai wagubu ke; “Nau gora bani wadana makeya makeya kwaesugana ki nana nuwegei?” E inako wagubu, ko Iyesu denai wagubu ke; ‘Iyapana mo eba mini poyo; Kau waretagi eba raurupi e wainai eba wadi; Gwedegwede mo eba kuwa-nuwagi; Kau waretagi badidi kwaewena empipi ki kau bera eba nuwagi; ");
INSERT INTO gdn_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Kau inagi mamagi wiwiratamiyowa ade kau kiya nene wainapiyei ki maba kau kowagiyoma mu nene inako mete wainapiyowa.” ");
INSERT INTO gdn_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Iyesu inako wagubu, ko apunu ki denai wagubu ke; “Gora nuwagibi ki nau makeya makeya naigida mena kwaesugekeya yabedekeya da karako, ko ki kawareya ka nau gwede kwaesugani?” ");
INSERT INTO gdn_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Apunu ki inako wagubu, ko Iyesu ade sibu, wagubu ke; “Kau nuwageya bagi kawaya tondana wainapiyei ki kau kayanuwagi kau gwedegwedegi kuduba tepi iyapana gwedegwedemaga pa mena imagei ragidai tage manako ewa yabi nau ewaneya uburi. Kau inako kwaenuwagi ki kau denai bagi kawaya mosi aita kunumau bananapi.” ");
INSERT INTO gdn_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Apunu ki e gwedegwedei ka ropani kawaya ki pokere e Iyesu yonai ki wainapupu ka e nuwaboyawena nuwasiyasiya nene e tagai wirapupu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Iyesu apunu ki nuwasiyasiya nene inako kayawena empupu ka e wirawena e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Iyapana gwedegwedemaga ropani kawaya ragidai mu Mamanuga God sumapamana ade e gari rabineya kunumau kaiwana idiwana ka ragiragi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Yawata ki katamurui ka tainugu umunai ki maba. Papa kawaya ‘kameru’ kwaitana tainugu umunai ki teyagisi ki ka e daikere eba baiyagisi kayayagisi, mibai ka tainugu umunai ka marai munta ko papa ki ka kawaya. Ko nau suwagani wainapumuri; Papa kawaya ‘kameru’ ki tainugu umuneya tewagana ki ka ade matarau ko iyapana mu gwedegwedemaga ropani kawaya ragidai ubumana Mamanuga God sumapamana ade e gari rabineya kaiwana idiwana ki ka ragiragi kawaya.” ");
INSERT INTO gdn_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Iyesu e tadeyau kabukabuwa ragidai yona ki wainamupu ka mu notamaga kowena manako e manu-mupu, tagubu ke; “Akae, inako ki ka nima iya waunai yadini?” ");
INSERT INTO gdn_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Mu inako tagubu, ko Iyesu mu emitapu manako denai tadebu, wagubu ke; “Iyapana wi wiga kasiyaraga pokaiya iya ki eba wadumuri ko Mamanuga God e badidi yagisi ki e umuneya ka gwedegwede kuduba ade wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Apunu Pita yona ki wainapupu ka e denai wagubu ke; “Kau wainapi, nu ka tawanuga kuduba kamadimpi kau ewageya kaigibi ki pokere denai ka nu gwede yadamu?” ");
INSERT INTO gdn_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","E inako wagubu, ko Iyesu mu kuduba tadebu, wagubu ke; “Nau yona mibai nidiyani wainapumuri; Mara ewa, nau Kunumau Kawapuwani Apunai kaiwawo kemai tanai bagi kawaya ki kawareya tondoni makeya, ki ka wi nau ewakumasiniyamu ragidai ida esida kewowena kerapu apeya (12) ki wi kawakawaiwagi manako wi kemaga kawareya idiwoi tawana Isiraero ragidai kunu ida esida kewowena kerapu apeya (12) kuduba ki mu yabiyabirimuguma idiwoi. ");
INSERT INTO gdn_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Iyapana gwedewau wi tawaga, wi yowaguma tataguma, wi inaguma mamaguma, wi munuguma bo wi wairaga inako ki kuduba nau pokanere kamaditamuri kaiwagi, ki ka wi denai kawaya daganani wadumuri manako maramara idiwana kaiwana ki iyai wi mete wadumuri. ");
INSERT INTO gdn_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Iyapana ropani kawaya karako yewe wairau kawakawayatagubu idiwu ki mu ka mara mosi maimeretagisi ewa ubumoto. Ade iyapana ropani kawaya karako maimeretagubu idiwu ki mu ka mara mosi kawakawayatagisi yabiri ubumoto.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki keyakeyai mosi nau karako wi kabuwaniyani wainapumuri; Mara mosi nawaru dumai tarawa makeya ka apunu kawai mosi ubupu iyapana e upi kwaetagamana ki nana mu kwaene-maga kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Mu mara eyaka mena upitagamana ki denimaga bowa madai baura eyaka mena wadamana ki yonai e mu mete ewapuru tagubu mibimupu manako ewa tonotapu e kokoreya kayatagubu upitagamawa. ");
INSERT INTO gdn_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Madega kaidenai pisikanawagawa makeya ka e ade ubupu kanibu iyapana dai ika imatau pa ubumawa iwa emitapu. ");
INSERT INTO gdn_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Emitapu manako e mu mete tadebu, wagubu ke; “Wi kaiwagi nau upini kwaiwagi ki ka nau wi deniga kemora nene negeyani.” ");
INSERT INTO gdn_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","E inako wagubu manako mu mete kina e kokoreya kayatagubu. Madega paunau wadawa makeya ade madega kekerawagawa makeya ka e inako mete kwaewena iyapana dai e kokoreya tonotapu. ");
INSERT INTO gdn_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Kemora nene ka e ade ubupu iyapana dai ika pa ubumawa iwa ki emitapu manako tadebu, wagubu ke; ‘Wi madega kawaya yau gwede nana pa asusu giripiyamu iwu?’ ");
INSERT INTO gdn_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","E inako wagubu ka mu denai tagubu ke; ‘Ki mibai ka iyapana mo e upi kwaigamana ki nana nu eba nidibu.’ Mu inako tagubu ki pokere apunu kawai ki iyapana ki mete tadebu, wagubu ke; ‘Baganai, wi kaiwagi nau kokoraneya upiwagi.’ ");
INSERT INTO gdn_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Kemorawagawa makeya ka apunu kawai ki ubupu e kobaiya upiwagawa apunai mosi sibu, wagubu ke; ‘Kau nau upini kwaetagamawa ragidai ki mu nene nuwagi baitagisi manako mu upitagamawa ki denimaga tage. Ewa bautagubu ragidai mu denimaga ki kau yabiri tage ko yabiri bautagubu ragidai mu denimaga ki kau siyarai tage.’ ");
INSERT INTO gdn_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Iyapana kemora nene bautagubu ragidai ki mu ka yabiri bautagubu manako mu denimaga bowa madai baura eyaka mena ki mu eyaka eyaka wadumupu. ");
INSERT INTO gdn_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Iyapana didiburu bau-tagubu ragidai ki emupu ka mu nota-maga wagubu ke; ‘Nu ka didiburu mena baigibi muya nunumeya idiweya da kemorawena ki pokere nu ka bani deninuga kawaitau yadamu.’ Mu notamaga inako wagubu ko mu mete bowa madai baura eyaka mena ki mena wadumupu. ");
INSERT INTO gdn_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Mu ki mena wadumupu ki pokere mu apunu kawai ki e bameya gunaratagubu, tagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Iyapana yau mu ka kemora nene bautagubu eba rowarowa upitagamawa ko nu ka didiburu mena baigibi kau upigi kwaigemeya muya nunumeya da karako kemorawena. Kau bowa madai baura eyaka mena mu tagebi ki kau nu mete negebi ko ki ka eba supasupai.’ ");
INSERT INTO gdn_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Mu inako tagubu, ko apunu kawai ki wirawena e upi kwaewagawa apunai ki mosi sibu, wagubu ke; ‘Kabai, nau eba paerepuwani kau bamageya berokoi mo eba kwaesugubuwani. Nau didiburu kau mete ewapuru iwagibi mibimipi da kau nau upini mara eyaka mena upi-nugowa ki nau kau denigi bowa madai baura eyaka mena negeyani. ");
INSERT INTO gdn_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Kau denigi ki wadi kau tawageya kaya-nuwagi. Nau siyarai bautagubu ragidai ade wi yabiri baigubu ragidai wi deniga kawayai eyaka mena negebuwani ki ka nau naubo mena. ");
INSERT INTO gdn_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nau naubo bowani madai pokaiya badidi kwaesugana wainapakani ki nau kwaesugani, ko kau wainapiyei da ki ka eba baganai bo? Nau ewa bautagubu ragidai denai kawaya tagebuwani ki nene kau nuwaroronugei bo?” ");
INSERT INTO gdn_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Iyesu keyakeyai ki wagubu ade tadebu wagubu ke; ‘Iyapana gwedewau karako siyareya ubumu ki mu ka aita yabiri ubumoto ade iyapana gwedewau karako yabiri ubumu ki mu ka aita siyareya ubumoto.” ");
INSERT INTO gdn_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya mete kina kayatagubu natere Diyerusaremu yawatau yamawa ka e mu waditapu paere bananatapu mubo mena kayatagubu manako tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nau suwagani wainapu-muri; Nu karako natere Diyerusaremu kaigamu ki ka iyapana ubumoto Kunumau Kawapuwani Apunai nau wadisinimoto iyapana kawakawai, Mamanuga God bameya dobopiyamu ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina ki mu idamaga rabineya nau tamusinimoto. Mu idamaga rabineya tamusinimoto manako iyapana ki ubumoto mu idamaga gurai nau naurineya ugwadi-sinimoto ragiragi, tagisi ke; ‘Kau kaubo beragi ki pokere karako denai ponuwagi.’ Mu inako tagisi, ");
INSERT INTO gdn_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","manako wadisinimoto kwaiyanai ragidai mu idamaga rabineya tamusinimoto manako mu ubumoto nau waegeyageyamasinimoto, wikuku pokaiya raukekesinimoto manako ewa susinimoto poyo. Nau mibai posugani ko mara apeya eyaka kewoyagisi eweya ka nau ade iyasugani kirani uburani.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ki makeya ka apunu Tabadi e wainai ubupu e gubagaiyoma apeya waratapu Iyesu bameya bautagubu. Ridi ki Iyesu yabareya kwarisiwena e ramatai kawareya ubupu manako e nuwaiya badidi wainapiyawa ki e Iyesu kwaewagana ki nana gwaiyabapupu. ");
INSERT INTO gdn_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Kau nuwageya gwede?” Iyesu inako wagubu manako ridi ki denai wagubu ke; “Nau nuwaneya ka yau kena; Kau nau gwaiyabasini da kau Kaiwawo-nuwagi makeya ki ka nau gubaganiyoma apeya yau kau madanigeya idiwono, mosi kau idagi garu deneya ade mosi kau idagi tenene ki deneya.” ");
INSERT INTO gdn_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ridi ki inako wagubu ka Iyesu denai e sibu, wagubu ke; “Kau nuwegei ki mibai kau kiya eba kataigeya.” E inako wagubu manako wirawena ridi ki e gubagaiyoma ki tadebu, wagubu ke; “Nau nuwaboya nene awana suwakarai kubarani makari bananapani ki wi mete kubamuri baganai bo?” ");
INSERT INTO gdn_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","“Ena, nu baganai.” Mu inako tagubu, ko Iyesu mu ade tadebu, wagubu ke; “Baganai, nau nuwaboya nene awana suwakarai kubarani ki wi mete kubamuri. Ko iyapana nima nau idani garu deneya tondana ade nima nau idani tenene deneya tondana ki sisiyai ka nau eba suwagani. Iyapana gwedewau nau Mamai mu watamaga ki winepupu ragidai ki mu mena ka aita kaiwoto wata ki idiwono.” ");
INSERT INTO gdn_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Iyesu e tadeyau kabukabuwa ragidai ida esida mena ki apunu Diyemesi yo Diyoni mu sisiyamaga ki wainamupu ka mu bamamugu rabina-maga pupuwena. ");
INSERT INTO gdn_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ko Iyesu ubupu e tadeyau kabukabuwa ragidai kuduba mu nene wagubu bautagubu manako tadebu, wagubu ke; “Wi kataigau da Mamanuga God tagararapiyamu ragidai mu kawakawaimuguma ubumoto mu mubo kasiyaramaga pokaiya gwede mo togomono ki ka mu kobamugu idiwu ragidai ki mu umunumaga yodomono makeya makeya kwaetogomono. ");
INSERT INTO gdn_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ko wi bamagau ka inako pa mena. Wi mo nuwagau kawaigamana wainapiyamu ki ka wi yabiri kwarisiwagi wi kowaguma mu bigabigamaga kwaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ade wi mo nuwagau yabiri ubumana waina-piyamu ki ka wi yabiri kowaguma mu ewamugu ubumoi mu bitamaga kawara-piyoi. ");
INSERT INTO gdn_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Nau Kunumau Kawapuwani Apunai mete kina inako kwaesugakani. Eba iyapana ubumana nau bigani kwaetagamana ki nana bausugubuwani ko nau uburana mu bigamaga kwae-sugana ki nana nau bausugubuwani. Nau posugani manako nau pokanere ka iyapana ropani kawaya mu bigimaga kuduba rikayagisi deni mena goga-yagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Iyesu e tadeyau kabukabuwa ragidai mete kina natere Diyeriko kamadamana kayatagamana kwae-tagamawa ka iyapana ropani kawaya mu ewakumatampu. ");
INSERT INTO gdn_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Iyapana apeya yabumaga kenekenei ika yawata kwaiya idiwa ki Iyesu ika yabadawa sisiyai wainamupu ka mu bonanamaga ragiragi kawaya patamupu, tagubu ke; “Oragai apunai Dewida e momai, kau nu nuwaboyanuga wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Mu inako tagamawa ka iyapana ropani kawaya ika ubumawa iyapana apeya ki yona kerekeretagamana ki nana nakaritampu ko mu bonanamaga ragiragi kawaya kawareya kawareya ade wena siyamawa, tagamawa ke; “Oragai apunu Dewida e momai, kau nu nuwaboyanuga wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Iyesu yona ki wainapupu ka e yawatau ubupu iyapana apeya ki mu nene wagubu bautagubu manako tadebu, wagubu ke; “Wi nuwagau nau gwede wi nene kwaesugani?” ");
INSERT INTO gdn_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","E inako wagubu ka mu denai tagubu ke; “Kaiwawonuga, nu nuwa-nugu ka kau nu yabunuga wadi papi da nu tawana empamu.” ");
INSERT INTO gdn_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Mu inako tagubu wainapupu ka Iyesu mu nuwaboyamaga wainapupu manako mu yabumaga geyapupu. E mu yabumaga geyapiyawa makeya ka iyapana ki tawana matarau emupu manako mu kimpu ubumupu Iyesu eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Mu kebomawa da natere Diyerusaremu bameya bau-tagamawa ka mu ripa ‘oripi’ wena-tagubu kweyai ki yamupu manako natere marai munta mo si ka Bepage bautagubu. Mu ika bautagubu ka Iyesu ubupu e tadeyau kabukabuwa ragidai apeya tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“Wi natere buri yabaranugu ki yabiri kaiwagi manako papa ‘donki’ mosi e munui mete kina taburuba pokaiya yawata uwareya umatampu ki ika emitamuri. Wi papa ‘donki’ ki e munui mete kina taburubamaga rikapumuri manako bananatamuri kebomuri. ");
INSERT INTO gdn_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Ko iyapana mosi wi eminiyoto, yagisi ke; ‘Wi badidi pokere inako kwaiwagamu?’, e inako yagisi ki ka wi denai e simuri, iwagi ke; ‘Nu Kaiwawonuga papa ‘donki’ yau e munui mete kina ki mu nene wagubu. E garugaru ade tonotamini wiratagisi baitagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Iyesu inako wagubu ki ka Mama-nuga God e bonanai wainapiyawa wagawa apunai mosi oka tapu ki mibai wenawena. E okai ki inako wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","‘Tawana Saiyoni ragidai yona yau tade; Wi Kaiwawoga kwarisiwena papa ‘donki’ kawareya wi nene yabadau empumuri. E papa ‘donki’ ki munai kawareya yabadau.’ ");
INSERT INTO gdn_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Iyesu e tadeyau kabukabuwa ragidai apeya ki kayatagubu manako mu natere buri bautagubu ka mu Iyesu badidi tadebu ki makeya makeya kwaetagubu. ");
INSERT INTO gdn_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Mu papa ‘donki’ ki e munui mete kina tetampu wiratagubu bautagubu ade mu muga midimaga tatamai rikatampu papa ki kawarimugu nakatampu manako Iyesu yapu papa ‘donki’ ki kawareya tondubu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","E kayawena kaniyawa ka iyapana ropani kawaya ika ubumawa ki mu mete kina mu midimaga tatamai dai rikatamawa yawatau nakapamawa ade dai ka ripa kwarai meyamawa naka-pamawa da Iyesu ki kawareya bauwagana kayawagana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Iyapana dai yabiritagubu ade dai ewatagubu inako kayatagubu yamawa manako mu ewapuru mena Iyesu paraupamawa Mamanuga God e si tepapamawa, tagamawa ke; “Ousana kaiwa kaiwa. Oragai apunai Dewida e momai, nu kau sigi tepapemei. Mamanuga God kau wadiniyoto bagi. Kau karako Mamanuga God e kasiyarai pokaiya baunugibi. Mamanuga God usi kunumau tondau e si nu karako tepapemei.” Iyapana inako tagamawa. ");
INSERT INTO gdn_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Iyesu natere Diyerusaremu bau-wena ka iyapana kuduba notamaga kowena purere igida yauda bautaga-mawa, tagamawa ke; ‘Apunu yau e ka nima?’ ");
INSERT INTO gdn_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ko iyapana e ewakumapamawa mete bautagubu ragidai ki mu denai tagubu ke; “Apunu yau e ka Mamanuga God e bonanai wainapiyau wagau apunai mosi si ka Iyesu. E ka natere Nasareta tawana Gariri rabineya ki mu iyapana-maga mosi.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Iyesu Mamanuga God e Tawai ki rabineya kayawena manako iyapana ika deni deni nida kasiwaratagamawa idiwa ki nakaritapu siwakeketapu. Bowa madai deni deni nida kasiwaratagamawa ragidai ki mu wataramaga ki e korita-pupu isiyapupu ade midiwari bowa madai nene nidatagamawa ragidai ki mu kebarimaga ki e mete tarapupu isiya-pupu, ");
INSERT INTO gdn_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","manako tadebu, wagubu ke; “Takari kawaya ka mu Mamanuga God e okai mosi inako tampu, tagubu ke; ‘Nau Tawani ki ka guriguri tawai.’ Mamanuga God e okai inako wagubu, ko wi ka kuwa ragidai yewe maramara weki gwaiya kuwaiwagamu idiwu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Mamanuga God e Tawai rabineya ka iyapana yabumaga kenekenei ade tagamaga korekorei Iyesu bameya bautagubu manako e mu iyatapu. ");
INSERT INTO gdn_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ko Mamanuga God bameya dobopiyamu ragidai ade gora kataimugu ragidai mete kina Iyesu bagi kawaya badidi kwaewagawa emupu, ade munu rasi Mamanuga God e Tawai rabineya e si tepapamawa idiwa ki mu yonamaga mete wainamupu, ki ka mu nuwamaga pupuwena. Munu rasi ki inako taga-mawa ke; ‘Oragai apunai Dewida e momai, nu kau sigi tepapemei.’ ");
INSERT INTO gdn_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Iyapana kawakawai ki Iyesu bameya bautagubu manako simupu, tagubu ke; “Mu yona tagamu ki kau wainapiyei bo pa mena?” “Ena, nau wainapakani. Ko Mama-nuga God e okai ki wi iyabamupu bo? Oka ki wagubu ke; ‘Mamanuga, kau munu rasi kabuwatapi da mu kau sigi bagi kawaya ki tepapiyamu.’” ");
INSERT INTO gdn_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Iyesu inako wagubu manako iyapana ki kamaditapu natere Diyerusaremu kamadubu kayawena umawa da natere Betani bauwena manako e kemora ki ika ukwapu. ");
INSERT INTO gdn_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Mu ika ukwampu nawaru puru-wena manako natere Betani kama-dumpu kayatagubu kaiwa ka Iyesu wetei mebu. ");
INSERT INTO gdn_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","E wetei meyawa ka e yabu tapu manako ripa damaya mo buri yawata kwaiya uburawa ki empupu. Ko ki ka eba damaya madai kirau ki marai ki pokere e ripa ki bameya bauwena ka e damaya madai mo eba empupu. E kwarai mena empupu ki pokere e ripa ki sibu, wagubu ke; “Kau mibigi ewa eba kiroto.” Iyesu yona ki wagubu makeya ka ripa ki deni mena surawena. ");
INSERT INTO gdn_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","E tadeyau kabukabuwa ragidai badidi wenawena emupu ka mu nota-maga kowena kodabamaga kamupu, tagubu ke; “Ripa damaya yau badidi maba garugaru mena inako surawena?” ");
INSERT INTO gdn_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Nau yona mibai nidiyani wainapumuri; Wi notaga eba apeya apeya ko eyaka mena Mamanuga God sumapiyoi ki ka nau ripa damaya bameya badidi kwaesugubuwani ki maba wi mete inako kwaiwagi. Ko eba ki mena. Wi kweya buri simuri, iwagi ke; ‘Kau kiya kiri uburi kayanuwagi egi suri’, wi inako iwagi ki ka kweya ki eya kiroto uburoto kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Wi Mamanuga God bameya guriguri pokaiya gwede mo nene geneiwagi ki ka wi notaga eyaka mena inako nota-pumuri, iwagi ke; ‘Nau karako suwagu-buwani ki wenayagisi.’ Wi inako sumaiwagi ki ka wi iwagubu ki wana e negeni.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Iyesu wirawena Mamanuga God e Tawai rabineya ade kanibu manako iyapana ika idiwa ki tadeyawa kabukabuwa tondawa ka Mamanuga God bameya dobopiyamu ragidai ade iyapana kawakawai dai ki e bameya bautagubu manako manumupu, tagubu ke; “Kau nima kasiyara negebu were kwaenugei? Kasiyara ki nima negebu?” ");
INSERT INTO gdn_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Yabiri ka nau wi manuniyani denai sidimuri were ewa ka nau nima kasiyara tegebu ki sisiyai wi nidiyani. ");
INSERT INTO gdn_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Apunu Diyoni iyapana siruwatamana ki nana bauwena ki ka e Mamanuga God wagubu ki pokaiya kwaewagawa bo iyapana kaina mo wagubu were kwaewagawa? Wi ki iwagi da nau wainapani.” Kawakawai ragidai e manui ki wainamupu ka mu denai e badidi siyamana ki nana dibimupu deni deni tagamawa kasiwara idiwa. Mu inako tagamawa ke; “Nu denai iwagamu da; ‘Apunu Diyoni, e ka Mamanuga God wagubu umuneya kwaewagawa’, nu inako iwagamu ki ka apunu ki denai nidiyoto, yagisi ke; ‘Baganai, ko wi badidi pokere apunu Diyoni e yonai eba sumamupu?’ ");
INSERT INTO gdn_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Ko nu iwagamu da; ‘Apunu Diyoni, e ka iyapana kaina mo wagubu umuneya kwaewagawa’, nu inako iwagamu ki ka nu iyapana-nuguma pakasi ragidai badidi tagisi, mibai ka mu kuduba wainapiyamu da apunu Diyoni e ka Mamanuga God e bonanai wainapiyawa wagawa ki apunai mosi.” ");
INSERT INTO gdn_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Kawakawai ragidai inako waina-mupu ki pokere mu denai Iyesu simupu, tagubu ke; “Nima Apunu Diyoni tono-pupu ki nu eba katainugu.” Iyesu yona ki wainapupu ka e denai wagubu ke; “Baganai, wi nau eba sidimupu ki pokere nima kasiyara nau tegebu pokaiya kwaesugakani ki sisiyai nau wi mete eba nidiyani.” ");
INSERT INTO gdn_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Iyesu inako wagubu, ade wagubu ke; “Wi karako badidi wainapiyamu; Apunu mosi e gubagaiyoma apeya mete idiwa manako mara mosi ka e ubupu e gubagai yabiri wenawena ki e bameya bauwena manako sibu, wagubu ke; ‘Gubagani, kau karako kokorau kaya-nuwagi upinuwagi.’ ");
INSERT INTO gdn_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","E inako wagubu ko e gubagai ki basarawena, denai wagubu ke; ‘Pa mena, nau eba nuwa-neya’. E inako wagubu ko ewa ka e notai ade wirapupu manako kokorau kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Ki eweya ka apunu ki wirawena e gubagai mosi ki e bameya kayawena manako e mete sibu da e kokorau kayawagana upiwagana ki nana. E gubagai ki garugaru mena wagubu ke; ‘Baganai, eba wainapi, nau kokorau kayasugani’. E inako wagubu ko ewa ka e notai wirapupu manako kokorau eba kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Karako sidimuri da nau wainapani; Munu nima ubupu e mamai umunui wadubu, yabiri ki kena bo ewa ki kena?” Iyesu yona ki wagubu ka kawakawai ragidai ki denai tagubu ke; “Munu yabiri ki kena.” Mu inako tagubu, manako Iyesu denai tadebu, wagubu ke; “Nau yona mibai nidiyani wainapumuri; Iyapana takesi wadamu ragidai ade ridi yawata kawakawareya iwu ragidai ki mu ka aita wi raurunimoto Mamanuga God e gari rabineya yabiri kaiwoto, ko wi ka ewaiwagi. ");
INSERT INTO gdn_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Apunu Diyoni wi bamagau bauwena yawata supasupai kabuwa-nibu, ko e yonai ki wi eba wainamupu sumamupu. Takesi wadamu ragidai ade ridi yawata kawakawareya iwu ragidai e yonai wainamupu sumamupu manako mu beramaga berokoi kamadumpu ki wi yabugere emitampu ko wi wiga beraga berokoi ki wi eba kamadumpu ade wi notaga eba wiramupu.” ");
INSERT INTO gdn_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Iyesu ade tadebu, wagubu ke; “Nau keyakeyai ade mosi suwagani wainapumuri; Waira apunai mosi e gari umapu manako ripa ‘waeni’ ki momai dai tepupu gari ki rabineya upu. Ki eweya ka e ripa madai ki botopamana watai yamanapupu manako iyapana e upi ki kwayubapamana watai iyarau mo mete wadubu. Wadubu kewowena ka e iyapana dai mu nene wagubu bau-tagubu manako gwaiyabatapu, wagubu ke; “Wi nau upini yau naigida mena kwayubapiyoi manako maura marai ki makeya ka wi madai dai wi wiga tepiyoi ko dai nau nene nakapiyoi. Nau niya ka tawana mo kayasugani umoni da ewa marai mosi ade bausugani.” E inako wagubu manako kamaditapu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Maura marai bauwena ka e ubupu e bigabigaiyoma ripa madai dai tepa-mana ki nana upi kwayubapamawa ragidai ki mu bamamugu tonotapu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ko mu ika bautagubu ka upi kwayubapamawa ragidai ki ripa madai mo mu eba tagempu ko mu ubumpu iyapana ki tetampu mo guda-pamawa da pa tonomupu kayawena, mo minimupu poyo ade mosi bowa were minimupu. ");
INSERT INTO gdn_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ki eweya ka upi ki apunai e bigabigaiyoma ragidai ropani kawaya inako ade tonotapu kayatagubu. Ko mu iwa da buri bautagubu ka upi kwayuba-pamawa ragidai ubumpu yabiri bau-tagubu ragidai bamamugu badidi kwaetagamawa ki maba mu ewa bautagubu ragidai ki mu bamamugu inako mete kwaetagubu. ");
INSERT INTO gdn_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Upi apunai e bigabigaiyoma inako tonotamiyawa da kewowena ka e eya gubagai tonopupu. E notai wagubu ke; ‘Nau niya gubagani tonopani ki ka mu e naigida mena wiwirapomoto waina-pakani.’ ");
INSERT INTO gdn_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Ko e gubagai kayawena umawa da buri upi kwayubapamawa ragidai bamamugu bauwagana kwae-wagawa ka mu e yabadawa emupu manako mu mubo mena tagubu ke; ‘Waira yau ewa wadana apunai ki bauwena yau kena ki pokere karako miniyamu poyo da e gwedegwedei yau kuduba ka aita nu tepamu.’ ");
INSERT INTO gdn_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Mu inako tagubu manako mu munu ki wadumpu dokodoko gari tagaiya kwenumupu manako minimupu poyo.” ");
INSERT INTO gdn_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Iyesu keyakeyai ki wagubu kewowena ka e iyapana ki ade manutapu, wagubu ke; “Wi badidi wainapiyamu; Waira ki apunai e eya aita wirayagisi baiyagisi ki ka e upi kwayubapamawa siyasiya ragidai ki mu bamamugu badidi kwaeyagisi?” ");
INSERT INTO gdn_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Iyesu inako wagubu ka kawakawai ragidai ki denai e simupu, tagubu ke; “Mu berokoi kwaetagubu ki pokere e mu tetamini namutamini manako ewa e upi kwayubapamana ragidai kudubai dai ki mu nene yagisi baitagisi manako mu ubumoto e upi naigida mena kwayuba-pomono da maura marai baiyagisi ki ka mu bani tepomoto manako daikere apunu kawai ki e nene nakapomoto.” ");
INSERT INTO gdn_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Iyapana ki inako tagubu manako Iyesu denai mu tadebu, wagubu ke; “Mamanuga God e okai ki wi iyaba-mupu bo pa mena? Oka ki wagubu ke; ‘Wi tawa wadamu ragidai waina-mupu da e ka bebeda berokoi ki pokere kwenumupu. Ko Mamanuga God bebeda ki wadubu ade wowo bebedai kaupupu. Nu Kaiwawo-nuga ki kwaewena ka bagi kawaya nu yabunugere emipi.’” ");
INSERT INTO gdn_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Iyesu Mamanuga God e okai kawareya inako wagubu manako ade tadebu, wagubu ke; “Mamanuga God wi wataga e gari rabineya winepupu tapu ki e koritapoto iyapana kudubai mibi-maga kipu ragidai ki mu tageni da mu ika idiwono. ");
INSERT INTO gdn_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Nau nidiyani wainapu-muri; Iyapana kaiwoto da bebeda ki pokaiya pisipisitamini gwepomoto ki ka mu bidara yadini midimaga purupuru-tagisi. Ade bebeda ki mu kawarimugu kauyagisi ki ka mu tauniyoto kwere-kwerere.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Mamanuga God bameya dobo-piyamu ragidai ade Parisi ragidai mete kina wainamupu da Iyesu keyakeyai ki wagubu ki ka e mu nene wagubu, ");
INSERT INTO gdn_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ki pokere mu gagayatagubu e wadamana yawatai kwaenepamawa. Ko mu e eba wadumupu mibai ka mu pakasi ragidai ropani kawaya ika idiwa ki mu kudu-mugu wainamupu. Pakasi ragidai tagubu da Iyesu e ka Mamanuga God e bonanai wainapiyawa wagawa apunai mosi. ");
INSERT INTO gdn_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Iyesu waigugu pokaiya iyapana ade tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki keyakeyai mosi ka yau kena; Apunu kawai mosi e gubagai anikawagana ki kupei kawaya mo okukunawena. ");
INSERT INTO gdn_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","E okukunawena kewowena ka e bigabiga-iyoma dai tonotapu da mu kayataga-mana iyapana bibitapu ragidai ki waratamana kupe kawareya bautaga-mana ki nana. E bigabigaiyoma kaya-tagubu iyapana tademupu, ko iyapana ki basaratagubu eba bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ko apunu kawai ki e bigabigaiyoma dai ade tonotapu tadebu, wagubu ke; ‘Wi kaiwagi nau bibitapuwani ragidai inako tademuri, iwagi ke; ‘Nau kupe yau okukunasugubuwani kewowena. Nau papaniyoma burumakau munumuguma mete kina ki nau namutapuwani bani teyamipi nawananimei ki pokere wi kuduba kupe yau kawareya garugaru mena baiwagi.’ ");
INSERT INTO gdn_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","E bibi tonotapu ragidai kayatagubu yona ki iyapana tademupu ko iyapana basaratagubu umunumaga eba wadumpu ko mu mubo nuwamugu nuwamugu mena kwaetagubu. Mosi e ebo kokoreya kayawena ade mosi e ebo baikamu wateya ki kayawena. Mu inako kwaetagubu, ");
INSERT INTO gdn_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ade mu dai ubumpu bibi ragidai ki tetampu giritampu pasutampu manako ewa taunimupu popo. ");
INSERT INTO gdn_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Iyapana kwaetagubu siyasiya ki sisiyai apunu kawai ki wainapupu manako e nuwai pupuwena e piyara-iyoma dai tonotapu kayatagubu berokoi kwaetagubu ragidai ki kuduba namu-tampu gawarara manako mu natere-maga mete pasumupu. ");
INSERT INTO gdn_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Ki eweya ka e bigabigaiyoma ragidai mu nene wagubu bautagubu manako tadebu, wagubu ke; ‘Nau gubagani anikawagana ki kupei nau ororeya mena okukunasugubuwani kewowena. Ko iyapana bibimaga tonopuwani ragidai ki mu ka eba bagi da mu bautagamana makai, ");
INSERT INTO gdn_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ki pokere wi karako kaiwagi imatau ade yawata kawakawareya iyapana ropani kawaya pa asusu ika idiwu ki waratamuri da mu kupe yau kawareya baitagisi.’ ");
INSERT INTO gdn_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","E inako wagubu manako e bigabigaiyoma kayatagubu imatau ade yawata kawa-kawareya iyapana bagi ade eba bagi ki kuduba waratampu bautagubu tawa kuduba posiwena. ");
INSERT INTO gdn_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Apunu kawai ki iyapana bau-tagubu ragidai mu emitamana ki nana tawa rabineya yapu manako e apunu mosi ika tondawa ki e anika monagai eba umapu ki empupu sibu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Kabai, kau anika monagai eba umapi ki pokere kau badidi maba nau tawaneya baunugibi?’ E inako wagubu, ko apunu ki yona daikere mo eba wagubu ko pa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","E pa tondawa ki pokere apunu kawai ki e bigabigaiyoma tadebu, wagubu ke; ‘Apunu yau wadumuri e idai kerarai umamuri dokodoko manako gari tagaiya sisipu rabineya kwenupumuri. E ika makariyogono uwarai sisiripono yadi kirono tondono.” ");
INSERT INTO gdn_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Iyesu keyakeyai ki wagubu kewowena ka e iyapana ki ade tadebu, wagubu ke; “Mamanuga God e iyapana ropani kawaya bibitapu ko e iyapana eba ropani winetapu.” ");
INSERT INTO gdn_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Ki makeya ka Parisi ragidai mubo mena paeretagubu Iyesu beraberapa-mana manupamana da e yona mo paerepana manako mu ki pokaiya e wadamana ki nana ki keketai kupamawa. ");
INSERT INTO gdn_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Mu ubumpu mu muga tademawa kabukabuwa ragidai ade apunu Erodi e kowaiyoma dai mete kina ki tonotampu kayatagubu Iyesu bameya bautagubu manako simupu, tagubu ke; “Nidiyei kabukabuwa apunai, nu katainugu da kau iyapana eba beratamiyei ko kau yona mibai mena nuwegei. Iyapana kawakawai kau bamageya bautagamu ki kau bera yonai eba nuwegei beratamiyei. Ade iyapana pakasi ragidai kau bamageya bautagamu ki kau mu mete eba beratamiyei yona kudubai mosi nuwegei. Pa mena. Kau maramara yona eyaka mena Mamanuga God e yawatai ki yonai mibai ki mena kawareya kawareya iyapana kabuwatamiyei. ");
INSERT INTO gdn_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ki pokere, kau badidi wainapiyei ki kau karako kiya nuwagi da nu wainapamu; Nu tawana Roumi ragidai mu kawaimaga Sita bameya nu wairanuga denai takesi tamana ki nene ka nu goranuga badidi wagau? Nu takesi ki tamana ka baganai bo eba baganai?” ");
INSERT INTO gdn_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Iyapana ki Iyesu wadamana ki nana dayaya yonai tagamawa ki Iyesu ororeya mena kataiwena ki pokere e denai tadebu, wagubu ke; “Wi ka midiga pa matakawagau ragidai. Wi badidi pokere nau wadisinimana ki nana dayaya yonai iwagamu? ");
INSERT INTO gdn_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ko baganai, wi takesi tamana ki bowai madai mo tegemuri da nau empani.” Mu bowa madai mo wadumpu kwemupu, ");
INSERT INTO gdn_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","manako e mu manutapu, wagubu ke; “Yau ka nima keyai bowa madai yau naureya tondau? Nima si bowa madai yau naureya okamupu?” ");
INSERT INTO gdn_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","E inako wagubu ka mu denai tagubu ke; “Yau ka tawana Roumi ragidai mu kawaimaga Sita e keyai ki naureya tondau.” Mu inako tagubu, manako Iyesu denai wagubu ke; “Baganai, ki pokere apunu kawai Sita e nene ki wi e ebo kwemuri, ade Mamanuga God e nene ki wi e ebo kwemuri.” ");
INSERT INTO gdn_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Iyesu yona ki wagubu ka iyapana ki mu notamaga kowena denai siyamana babatagubu manako kamadumpu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Mara eyaka mena ki rabineya ka Sadusi ragidai dai Iyesu bameya bau-tagubu. Sadusi ragidai mu ka iyapana inako tadeyamu, tagamu ke; ‘Nu popoigamu ki ka nu ewa eba iyaigamu ade kimamu ubumamu.’ ");
INSERT INTO gdn_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Sadusi ragidai ki Iyesu bameya bautagubu manako simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, oragai apunai Mosisi nu goranuga inako tapu, wagubu ke; ‘Apunu mosi e wainai munu eba wenapoto manako e nobomoi poyagisi, ki ka apunu ki e yowai koboro ki uworoto manako munu wenapoto ki aita popai apunai ki e watai yadini.’ ");
INSERT INTO gdn_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Kau karako wainapi; Iyapana ida daikere kewowena daikere apeya (7) nu mete yewe idiweya manako mu tata-maga ridi mo uwapu. E ridi mo uwapu ko e munu eba wenapupu manako apunu ki powena. E powena ki pokere e yowai koboro ki uwapu ko e mete powena ko munu mo eba wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Mu inako kwaetagamawa yamawa da iyapana ida daikere kewowena daikere apeya (7) koboro ki uwamupu ki mu kuduba popotagubu gawarara ko munu mo eba wenawena. ");
INSERT INTO gdn_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Ko siyareya ka ridi ki e eya mete powena. ");
INSERT INTO gdn_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kau karako nuwagi da nu wainapamu; Mara kwauneya iyapana popotagubu ragidai ade iyatagisi kimoto ubumoto makeya ki ka ridi ki nima wainai? Mibai ka e iyapana ida daikere kewowena daikere apeya (7) ki tauwapu.” ");
INSERT INTO gdn_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sadusi ragidai ki inako tagubu ko Iyesu denai tadebu, wagubu ke, “Wi paerepiyamu kawaya daganani. Wi Mamanuga God e yonai eba kataigau ade e kasiyarai mete eba kataigau. ");
INSERT INTO gdn_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Iyapana popotagubu ragidai ade iyatagisi kimoto ubumoto makeya ki ka mu eba anikatagisi. Mu ka aneya kunumau idiwu ki mu maba inako idiwono. ");
INSERT INTO gdn_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ko iyapana popotagubu ragidai ewa ade iyatagamana kimana ubumana ki yonai ka Mamanuga God e okai wi kabuwanibu kewowena. Ko e yonai ki wi bani eba iyabamupu bo? E okai ki wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Apunu Eburamu e Mamai God ka nau. Apunu Aisiki e Mamai God ka nau. Ade apunu Diyaikapu e Mamai God ka nau.’” Iyesu ubupu Mamanuga God e okai kawareya inako wagubu manako ade tadebu, wagubu ke; “Mamanuga God e ka eba iyapana kwakwarepumaga ononopiyamu puwawagau ki mu Mamamaga. E ka popai ragidai mu keyaimuguma iyaiya idiwu ki mu Mamamaga, ki pokere e okai wagubu ke; ‘Apunu Eburamu e Mamai God ka nau. Apunu Aisiki e Mamai God ka nau. Ade apunu Diyaikapu e Mamai God ka nau.” ");
INSERT INTO gdn_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Iyapana ropani kawaya Iyesu kabuwai ki wainamupu ka mu nota-maga kowena. ");
INSERT INTO gdn_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Iyesu badidi wagubu ki pokaiya Sadusi ragidai yona denai tagamana babatagubu ki sisiyai Parisi ragidai wainamupu manako mu bautagubu ewapuru dibimupu. ");
INSERT INTO gdn_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Mu ewapuru dibimupu manako mu paunamugu ka Mamanuga God e gorai kataiya apunai mosi ubupu Iyesu manupana da e yona mo paerepana ki nana e manupupu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Nidiyei Kabukabuwa Apunai, Mamanuga God e gorai ropani kawaya nakapupu ki paunamugu gora bani ka kawaya esida?” ");
INSERT INTO gdn_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","E inako wagubu, manako Iyesu denai e sibu, wagubu ke; “Gora kawai ka yau kena; ‘Mamanuga God e eya mena ka Kaiwawo. Wi nuwaga notaga ade wi mibiga kuduba e mena mara-mara nota kwarikwarisipiyoi idiwoi.’ ");
INSERT INTO gdn_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Gora ki mena ka kawaya esida, ");
INSERT INTO gdn_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","ade gora ki kobaiya ka yau kena; ‘Kau kiya nene wainapiyei ki maba kau kowagi-yoma mu nene mete wainapiyowa.’ ");
INSERT INTO gdn_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Gora apeya yau mena ka kawakawaya. Mamanuga God e bonanai wainapamawa tagamawa ragidai badidi tagubu ade oragai apunai Mosisi gora badidi tapu ki kuduba ka gora apeya yau mu koba-mugu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Parisi ragidai ika bautagubu dibimupu idiwa ki pokere Iyesu mu manutapu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Wi badidi wainapiyamu; Wi Iya Negeyana Apunai Keriso ki e ka nima e momai?” E inako wagubu manako mu denai tagubu ke; “E ka oragai apunai Dewida e momai.” ");
INSERT INTO gdn_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Mu inako tagubu ko Iyesu mu ade tadebu, wagubu ke; “Keriso ka oragai apunai Dewida e momai ki yonai ka mibai maba ki ka Mamanuga God e Keyai badidi pokere apunu Dewida kabuwapupu da e uburoto Keriso e eya Kaiwawoi siyana ki nana sibu? Mama-nuga God e okai wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Nau Mamai God nau Kaiwawoni sibu, wagubu ke; Kau nau madanani garu deneya tondowa da nau kau iyaragiyoma kuduba kwanatamani kau kerapugi kobaiya nakatamani kewoyagisi were.’ ");
INSERT INTO gdn_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Oragai apunai Dewida ubupu wi Iya Negeyana Apunai Keriso e eya Kaiwawoi sibu, ko ade badidi maba ka e eya Kaiwawoi sibu Keriso ki ade apunu Dewida e eya momai?” ");
INSERT INTO gdn_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Iyesu yona ki wagubu ka Parisi ragidai yona denai tagamana babatagubu. Mara ki makeya ade ewa ka iyapana dai eba bautagubu Iyesu manumupu. ");
INSERT INTO gdn_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ko Iyesu wirawena e tadeyau kabukabuwa ragidai ade iyapana ropani kawaya mete kina ki tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Mamanuga God e gorai kataimugu ragidai ade Parisi ragidai ki mu ka oragai apunai Mosisi e watai wadumupu, ");
INSERT INTO gdn_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ki pokere mu Mamanuga God e yonai tagamu ki wi wainapiyoi makeya makeya kwaiwogoi. Ko mu kwaetagamu ki kawareya wi inako eba kwaiwogoi, mibai ka mu yona tagamu ki mu muga paerepiyamu ko eba kwaetagamu. ");
INSERT INTO gdn_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Mu mubo goramaga bisi kawaya ki mu wadamu pakasi ragidai mu kwepokaramugu tamu. Ko iyapana gora ki makeya kwaetagamana ki nana muya nunumu ki ka kawakawai ragidai ki pa ubumu mu emitamiyamu ko eba waitatamiyamu. ");
INSERT INTO gdn_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Iyapana mu emitamana ki nana ka mu Mamanuga God e yonai dai oka-piyamu mu yabaramugu painipiyamu ade mu idamugu katama maba umamu. Mu midimaga tatamai umamu ki kisiyarai rorowa kawakawaya taini-piyamu iwu. ");
INSERT INTO gdn_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Poraga kawareya ka mu iyapana mu emitamana wiwiratamana ki nana kebari bagi kawaya kawareya idiwu ade guriguri tawai rabineya ka mu kawai gisipiyamu kawakawai ragidai mu watamaga bagi kawaya ki kawareya idiwu. ");
INSERT INTO gdn_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Mu nuwamugu kayatagamana imatau iwana da iyapana ropani kawaya ika idiwu mu emitamana naigida mena parautamana ki nana manako tagamana ke; ‘Wi ka nu Nidiyamu Kabukabuwa Ragidai’. ");
INSERT INTO gdn_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Mu inako kwaetagamu, ko nau nidiyani wainapumuri; Wi wiga kowaguma eba tademuri da mu ka wi ‘Nidiyamu Kabukabuwa Ragidai’, mibai ka wi Nidiyau Kabukabuwa Apunai ka eba ropani ko eyaka mena. ");
INSERT INTO gdn_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ade yewe wairau ka wi iyapana kaina mo eba simuri da e ka wi ‘Mamaga’, mibai ka wi Mamamaga eyaka mena ka kunumau tondau. ");
INSERT INTO gdn_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ade wi Kaiwawoga ka Keriso e eya mena ki pokere iyapana kaina mo wi Kaiwawoga eba simuri. ");
INSERT INTO gdn_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Iyapana nima wi paunagau kawaiwagana wainapiyau ki ka e kwarisiyagisi e kowaiyoma mu bigabigamaga kwaeyogono. ");
INSERT INTO gdn_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Iyapana nima e ebo si tepapiyau ki ka aita ewa ka e kwarisiyagisi suroto. Ko ade iyapana nima e ebo kwarisiwena tondau ki ka aita ewa ka e kawayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","14","Iyesu ade wagubu ke; “Akae, Mamanuga God e gorai kataigau ragidai ade Parisi ragidai, wi ka aita bita kawaya bananapumuri. Wi ka midiga pa matakawagau ragidai. Mamanuga God e gari kunumau ki katai iyapana kataitagamana katamurui ki kasiparai ka wi umamupu dokodoko. Wi wiga ka katai ki eba kataigamana wainapiyamu ade iyapana katai ki kataitagamana wainapiyamu kaiwu mu yawatamaga ki wi bodapiyamu. ");
INSERT INTO gdn_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Akae, Mamanuga God e gorai kataigau ragidai ade Parisi ragidai, wi ka aita bita kawaya bananapumuri. Wi ka midiga pa matakawagau ragidai. Iyapana eyaka mena kwaitana e notai wirapa-mana da wi kwaiwagamu ki maba e mete inako kwaewagana ki nana ka wi ubumu tawana tawana igida yauda egi kawareya mete kina kwaeneiwagamu iwu. Wi iyapana mo inako bananapumuri ki ka wi beraga berokoi e kabuwapumuri da e wi badidi kwaiwagamu ki maba e inako mete kwaeyogono. Ko berokoi e kwae-yogono ka kawaya esida ki pokere e yo wi bita wadamana tawaneya baiwagi ki ka e bita kawaya daganani esida bananapoto. ");
INSERT INTO gdn_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","Akae, wi yabuga kenekenei iyapana waratamiyamu yawata paere-piyamu kabuwatamiyamu ragidai. Wi ka aita bita kawaya bananapumuri. Wi iyapana tadeyamu, iwagamu ke; ‘Nima uburoto Mamanuga God e Tawai ki si pokaiya gwede mo gwaiyaba kaimatana yagisi manako gwaiyaba wagubu ki e ewa eba kwaeyagisi, ki ka baganai, eba gwedei mete kina. Ko e uburoto bowa yamayamai Mamanuga God e Tawai rabineya ki si pokaiya gwaiyaba kaima-tana ki yagisi, ki ka gwaiyaba wagubu ki e makeya makeya kwaeyogono ko eba paerepoto.’ ");
INSERT INTO gdn_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Wi inako iwagamu ki mibai ka wi yabuga ka kenekenei ade wi ka notababa ragidai. Gwede ka kawaya esida? Bowa yamayamai ki kena bo Mamanuga God e Tawai ki kena? Nau nidiyani wainapumuri; Gwede yamayamai tawa rabineya ki kuduba ka tawa ki pokaiya Mamanuga God e nene. ");
INSERT INTO gdn_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Ko wi iyapana inako mete tadeyamu, iwagamu ke; ‘Nima uburoto Mamanuga God e kepakepai ki si pokaiya gwede mo gwaiyaba kaimatana yagisi manako gwaiyaba wagubu ki e ewa eba kwaeyagisi, ki ka baganai, eba gwedei mete kina. Ko e uburoto puyo kepakepa kawareya tampu ki si pokaiya gwaiyaba kaimatana ki yagisi, ki ka gwaiyaba wagubu ki e makeya makeya kwae-yogono ko eba paerepoto.’ ");
INSERT INTO gdn_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Wi yabuga kenekenei ragidai. Gwede ka kawaya esida? Kepakepa ki kena bo puyo kepakepa kawareya ki kena? Nau nidiyani wainapumuri; Gwede kepa-kepa kawareya ki kuduba ka kepakepa ki pokaiya Mamanuga God e nene. ");
INSERT INTO gdn_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Iyapana nima uburoto kepakepa ki si pokaiya gwede mo gwaiyaba kaimatana yagisi ki ka e puyo kepakepa kawareya nakamupu ki kuduba simaga pokaiya gwaiyaba kaimatana ki mete wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ade iyapana nima uburoto Mama-nuga God e Tawai ki si pokaiya gwede mo gwaiyaba kaimatana yagisi ki ka e tawa ki apunai e si pokaiya gwaiyaba kaimatana ki mete wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ade ki kwaitana; Iyapana nima uburoto kunuma si pokaiya gwede mo gwaiyaba kaimatana yagisi ki ka e Mamanuga God e kemai ade kema kawareya tondau apunai ki mu simaga pokaiya gwaiyaba kaimatana ki mete wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","Akae, Mamanuga God e gorai kataigau ragidai ade Parisi ragidai, wi ka aita bita kawaya bananapumuri. Wi ka midiga pa matakawagau ragidai. Wi ka gwedegwedega kuduba naigida mena damupiyamu manako damu ida esida mena ki damui eyaka mena ka wi Mamanuga God nene tamu. Ena, eba wi gwedegwedega ki mena ko kusura kwarai yo gumai ebo ebo inako ki wi mete tepiyamu naigida mena damu-piyamu. Ko Mamanuga God e gorai kawakawai karako suwagani ki wi eba wainapiyamu kwaiwagamu; Wi Iyapana bamamugu supasupai kwaiwagamana ki wi eba kwaiwagamu, wi iyapana eba nuwanuwatamiyamu, ade wi badidi kwaiwagamana iwagamu ki wi eba kwaiwagamu. Damu eyaka mena Mamanuga God nene tamana ki ka baganai ko e gorai kawakawai ki wi mete makeya makeya kwaigamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Wi yabuga kenekenei iyapana waratamiyamu yawata paerepiyamu kabuwatamiyamu ragidai, wi ka badidi maba ki keyakeyai nau karako wi nidiyani wainapumuri; Wi ka apunu mosi e kapai rabineya kwagama marai munta supu ki empupu tekwaripupu kwenupupu ko buwamuku kawaya e kapai rabineya supu ki e eba empupu ko mete kubabu, ki wi ka apunu ki maba. ");
INSERT INTO gdn_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","Akae, Mamanuga God e gorai kataigau ragidai ade Parisi ragidai, wi ka aita bita kawaya bananapumuri. Wi ka midiga pa matakawagau ragidai. Wi kapaga yo wi yogoga tagai mena ki wi siruwapiyamu da iyapana wi emini-mana baganai tagamana ki nana, ko wi rabinagau berokoi posiwena uburau ki wi utapiyamu kapoi ade taisi teyateyama ki mena kwaiwagamu idiwu. ");
INSERT INTO gdn_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Wi yabuga kenekenei Parisi ragidai, nau yona yau nidiyani ki wi wainapumuri; Wi kapaga yo wi yogoga ki rabinai yabiri siruwapumuri ki ka tagai mete taniyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","Akae, Mamanuga God e gorai kataigau ragidai ade Parisi ragidai, wi ka aita bita kawaya bananapumuri. Wi ka midiga pa matakawagau ragidai. Popotagubu ragidai mu rakimaga iyapana tarapiyamu bagi kawaya monagapiyamu, ki wi ka ade raki ki maba. Raki kawareya ka tanai kawaya ko raki rabineya ka popai ragidai mu suwanamaga ade mu midimaga kwakwarepumaga puwawena ika uburau. ");
INSERT INTO gdn_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ki maba, iyapana wi midiga kwakwarepuga empiyamu ka bagi kawaya ko wi midiga pa matakawagau. Wi rabinagau ka bigi mena posiwena uburau.” ");
INSERT INTO gdn_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","Iyesu ade wagubu ke; “Akae, Mamanuga God e gorai kataigau ragidai ade Parisi ragidai, wi ka aita bita kawaya bananapumuri. Wi ka midiga pa matakawagau ragidai. Mamanuga God e bonanai wainapamawa taga-mawa ragidai ade bagi supasupai kwaetagamawa ragidai naiya mena popotagubu ononotampu ki mu ononotampu rakimaga ki wi karako naigida mena monagapiyamu ade kwayubapiyamu. ");
INSERT INTO gdn_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Wi iwagamu ke; ‘Nu ripakwarakwaranuguma ubumpu Mamanuga God e bonanai waina-pamawa tagamawa ragidai namutampu ki ka mu idiwa makeya nu ika mete idimpena ki ka mu berokoi kwaetagubu ki maba nu inako eba kwaigumpena.’ ");
INSERT INTO gdn_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","32","Wi inako iwagamu, ko nau nidiyani wainapumuri; Wi ripakwarakwaraguma nene iwagamu ki ka wi wiga nene mete iwagamu, mibai wi ka mu momo-muguma. Ko baganai, mu naiya Mamanuga God e bonanai wainapamawa tagamawa ragidai namutamawa ki bigi wi karako wadumuri riyapumuri yamuri kewopumuri. ");
INSERT INTO gdn_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Wi ka motamota berokoi e munuiyoma ade wi motamota e munuiyoma mete wenatamiyamu. Mamanuga God wi bita negeyana watai ki wi badidi maba baibigapumuri? ");
INSERT INTO gdn_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Nau nidiyani wainapumuri; Nau bonanani wainapamana tagamana ragidai yo katai ragidai yo wi nidimana kabukabuwa ragidai ki mu kuduba nau wi bamagau tonotamani manako mu nau yonani togomono iwono. Ko nau kataineya da aita ewa ka wi ubumuri manako mu dai wi namutamuri, dai wi ripa korosi naureya ikokotamuri da popotagisi, dai wi tetamuri guriguri tawai rabineya raukeketamuri, ade dai wi siwakeketamuri tawa tawa kaya-tagisi. ");
INSERT INTO gdn_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Wi mu bamamugu inako kwaiwagi ki pokere wainapumuri; Iyapana naiya ubumpu bagi supasupai apunai Eiboro minimpu poyo ade e eweya supasupai kwaetagamawa ragidai mete namutamawa kebomawa da apunu Barakaiya e gubagai Sekaraiya Mama-nuga God e Tawai rabineya ‘Puyo Tamu Watarai’ ade ‘Wata Tanai Bagi’ ki paunau minimpu poyo, mu berokoi ki kuduba kwaetagamawa ki denai ka bita wi bananapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ena, nau yona mibai nidiyani wainapumuri; Iyapana kuduba naiya namutampu popotagubu ragidai mu bimbinamaga ka wi karako idiwu ragidai wadumuri.” ");
INSERT INTO gdn_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Iyesu ade wagubu ke; “Natere Diyerusaremu ragidai, natere Diyerusaremu ragidai. Mamanuga God e bonanai wainapiyamu ragidai ki wi namutamiyamu ade e bibi tonotapu ragidai ki wi bowa were tauniyamu popo. Kokoroku inai e munuiyoma e mabui kobaiya nakatamiyau kwayuba-tamiyau ki maba ka nau maramara wi kuduba nau idani rabineya dibiniyana ki nana wainapekeya ko wi nau bodabodasinimawa. ");
INSERT INTO gdn_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Ko wainapumuri, karako nau kamadiniyani kayasugani manako wi tawaga gumoroyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ade nau yonani yau mete wainapumuri; Waunitau ka wi nau mo eba emisinimuri, ko mara baiyagisi da wi iwagi ke; ‘Kau Mamanuga God e kasiyarai pokaiya baunugibi ki pokere e kau wadiniyoto bagi,’ wi yona ki iwagi makeya ka wi nau ade emisinimuri.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Iyesu Mamanuga God e Tawai ki kamadubu kayawena kaniyawa ka e tadeyau kabukabuwa ragidai e bameya bautagubu e tawa bagi kawaya ki naigida mena empana ki nana simupu. ");
INSERT INTO gdn_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ko e tadebu, wagubu ke; “Wi gwedegwede yau kuduba em-piyamu? Nau yona mibai suwagani wainapumuri; Tawa yau bowa pokaiya wadumupu ki ka iyapana ewa marai mosi baitagisi baupomoto giripomoto pasumoto manako bowa mo kawareya pasimupu ki kuduba mu yadini rorororo isiyapomoto kewoyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Iyesu ripa ‘oripi’ wenatagubu kweyai ki kawareya tondawa makeya ka e tadeyau kabukabuwa ragidai mubo mena e bameya bautagubu manako manumupu, tagubu ke; “Kau nidi; Nuwaboya yo midi makari nene nuwagibi ki gwede mara baiyagisi? Kau wiranugana baunugana marai ade mara siyarai ki marai bauwagana ki nu gwede matakirai empamu da nu kataigamu mete idiwomu?” ");
INSERT INTO gdn_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Wi kwayubaga naigida mena kwaiwogoi yabu yabu idiwoi kwaenda iyapana baitagisi wi beranimoto kerapugau yadini. ");
INSERT INTO gdn_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Iyapana ropani kawaya nau ewaneya baitagisi nau sini pokaiya beratagisi, tagisi ke; ‘Nau ka wi Iya Negeyana Apunai Keriso.’ Mu inako beratagisi manako iyapana ropani kawaya notamaga wirapomoto da mu sumatamini. ");
INSERT INTO gdn_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Wi ta yo yawira ki sisiyai wainapumuri, ade ta yo yawira kwaetagamana kwaetagisi ki sisiyai mete wainapumuri. Ko kudu eba wainapiyoi. Ta yo yawira ki kuduba wenayagisi ko mara siyarai tondau, eba bauwagana kena. ");
INSERT INTO gdn_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tawana tawana ka natere mo uburoto natere kudubai mo mete yawiratagisi, ade tawana mo kawaimaga e iyapanaiyoma tetamini kayatagisi tawana mo kawaimaga e iyapanaiyoma mete kandetagisi. Tawana dai ka kapoi kawaya daganani uburoto ade tawana dai ka waira nutanuta mete baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ko nuwaboya yau kuduba ka ridi munu wenapana tagai urau ki makarai maba. Makarai kawaya ka ewa baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Mara ki baiyagisi makeya ka iyapana ubumoto wi dai tenimoto iyara ragidai mu idamaga rabineya naka-nimoto manako mu ubumoto wi girini-moto pasunimoto manako namunimoto. Nau pokanere ka iyapana kuduba, madega kauwagau madega posiwagau wi tagararanimoto. ");
INSERT INTO gdn_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Mara ki makeya ka nau sumasiniyamu ragidai ropani kawaya mu sumamaga kaupomoto manako kowamuguma tagararatamono deni deni yogo kasiwaratogomono. ");
INSERT INTO gdn_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Ki makeya ka Mamanuga God e yonai beratagamu mubo nuwamugu nuwa-mugu tagamu ragidai ropani kawaya mete baitagisi iyapana kerapumugu waditamono notamaga wirapomono. ");
INSERT INTO gdn_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Mara ki makeya ka berokoi e upi kawayayagisi kayayagisi ki pokere iyapana ropani kawaya mu rabinamugu ka nota kwarikwarisi ki notai nusuru-yagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ko iyapana gwedewau ragiragi kawaya ubumoto giruru maba kobaiya tetetagisi kaiwono da mara siyarai baiyagisi ki mu ka iya waunai yadini. ");
INSERT INTO gdn_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Iyapana tawana tawana kuduba, madega kauwagau madega posiwagau, ki ka mu Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki yonai bagi kawaya yau wainapomoto kewoyagisi were ewa ka mara siyarai ki baiyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Mamanuga God e bonanai wainapiyawa wagawa apunai Daniyero wagubu da aita ewa ka Berokoi Kawaya mosi baiyagisi manako wata bagi kawaya e eba uburana watai ki wateya e uburoto. (Nima yona yau iyabapono ki ka e yona yau mibai ki naigida mena notapono.) Wi berokoi ki ika uburono empumuri, ");
INSERT INTO gdn_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ki ka wi tawana Diyudiya ragidai garugaru mena wakapaiwagi kweyau kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Iyapana mosi tawa tagaiya yapu tondau ki e eba suroto e ebo gwedegwedei tawa rabineya nakapupu ki tepoto. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ade iyapana mosi kokorau umau ki ka e eba wirayagisi e midi tatamai ki kai tawau kayayagisi. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Akae, mara ki makeya ridi mosi mibi romodoi bo munu wawayai mete kina ki ka e badidi maba wakapayagisi garugaru kaya-yagisi? ");
INSERT INTO gdn_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ade ki maba, wi Mamanuga God bameya guriguriwogoi da berokoi ki nusuru marai bo aiyata marai ki makeya eba baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Mibai, mara ki makeya ka nuwaboya yo bita kawaya daganani wenayagisi. Mamanuga God ubupu waira yo gwedegwede kuduba yamanatapu makeya idiweya kebomeya da karako ka iyapana bita inako mo eba emupu. Ade ewa, mara siyareya, ka mu bita inako mo mete eba empomono. Ko paunau ka bita kawaya yau wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Mamanuga God e bita ade nuwaboya ki marai yadini rowarowa ki ka iyapana mo eba tondono ko mu kuduba popo-tagisi gawarara. Ko e eya iyapanaiyoma winetapu ragidai ki mu nene e waina-piyau ki pokere e mara ki yadini rogobi da mu eba popotagisi ko idiwono. ");
INSERT INTO gdn_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Mara ki makeya iyapana mo baiyagisi wi nidiyoto, yagisi ke; ‘Kebo-muri empumuri, Keriso yewe bauwena tondau,’ bo ade mo yagisi ke; ‘Keriso bauwena burida tondau,’ iyapana mosi baiyagisi inako yagisi ki ka wi e yonai ki eba sumapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Iyapana dai ubumoto beratagisi, tagisi ke; ‘Nau ka Keriso.’ Ade dai beratagisi, tagisi ke; ‘Nau ka Mamanuga God e bonanai wainapuwani makeya nidiyakani yau kena.’ Mu inako tagisi manako mu matakiramaga marai kawai mete kwaetogomono wi kabuwanimono. Mu iyapana beratamini manako kasiyara-tagisi ki ka mu ubumoto Mamanuga God e eya iyapanaiyoma winetapu ragidai ki mu notamaga mete wira-pomoto. ");
INSERT INTO gdn_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Ki pokere wi wibo kwayubaga kwaiwogoi yabu yabu idiwoi. Gwedegwede kuduba aita ewa wenayagisi ki sisiyai nau karako yabiri nidibuwani yau kena. ");
INSERT INTO gdn_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Iyapana dai wi nidimoto, tagisi ke; ‘Empumuri, e bauwena iyapana eba idiwu tawaneya buri tondau’, mu inako tagisi ki ka wi rabinaga pakarayagisi mu ewamugu eba kaiwagi. Ade mu tagisi ke; ‘Empumuri, e nu bamanugu yewe bauwena tawanugu tondau’, mu inako tagisi ki ka wi mu yonamaga ki mete eba sumapumuri. ");
INSERT INTO gdn_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Yangwara wadau kunuma kuduba miniyau siwa ki maba ka Kunumau Kawapuwani Apunai nau marani baiyagisi manako iyapana kuduba nau inako matarau emisini-moto. ");
INSERT INTO gdn_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ko nau waigugu yau suwagani ki wi wainapumuri; Gwede mosi powena ika ukwarau ki ka midiwari kusuketa ika mete dibipomoto e kwakwarepui ki kupamana ki nana baitagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Bita makari kawaya ki marai kewoyagisi ki ka madega sisipupoto manako siragamu ewa eba taniyagisi. Supama kunumau gwegwetagisi manako kunuma kasiyarai mubo mubo geyageyatagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Mara ki makeya ka iyapana tawana tawana kuduba, madega kauwagau madega posiwagau, Kunumau Kawapuwani Apunai nau matakirani kunumau kwaesugani ki mu empomoto manako yadi kimono apena meyomono. Ki makeya ka Kunumau Kawapuwani Apunai nau tanini bagi kawaya ade nau kasiyarani mete kina kunumau oroguma kawareya ade kaworoni ki wi nau emisinimuri. ");
INSERT INTO gdn_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Bawiwi kawaya ki yogono makeya ka nau aneyaniyoma tonotamani manako tawana tawana kuduba, madega kauwagau madega posiwagau, kunuma waira kerareya, ki mu kayatagisi nau iyapananiyoma winetapuwani ragidai kuduba kwanatamini manako wata eyaka mena damutamini.” ");
INSERT INTO gdn_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Iyesu inako wagubu, ade tadebu, wagubu ke; “Karako keyakeyai ripa damaya naureya kabuwaniyani ki wi wainapumuri; Ripa damaya mibai toporuyagisi gumai bagi kawaya posiwagana kwaeyogono ki ka wi kataigau da bodu marai waunitau baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Baganai, wi gwedegwede kuduba nidibuwani ki mibai wena-yogono empiyoi ki ka wi mete kataiwagi da mara siyarai ka waunitau. ");
INSERT INTO gdn_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Nau yona mibai suwagani wainapu-muri; Nau yonani yau kuduba nidi-buwani ki mibai matarayagisi empu-muri were ka wi dai yewe wairau idiwu ragidai ewa popoiwagi. ");
INSERT INTO gdn_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Kunuma waira kuduba gogatagisi, ko nau yonani badidi suwagubuwani ki eba gogayagisi ko maramara tondono kaniyono.” ");
INSERT INTO gdn_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Nau gwede mara kemorau bo nawarau ade wirasugani bausugani ki ka iyapana kuduba wi eba kataigau, aneya kunumau idiwu mete eba katai-mugu, ade nau niya Mamanuga God e eya Gubagai ki nau mete eba kataineya. Nu Mamanuga God e eya mena mara ki kataiya. ");
INSERT INTO gdn_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Iyapana oragai apunai Nowa tondawa makeya badidi kwaetagamawa idiwa ki maba ka nau Kunumau Kawa-puwani Apunai ade wirasugana bau-sugana makeya iyapana inako mete kwaetagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Oragai takari kawaya awana goya kawaya ki eba bauwena makeya ka iyapana bani kupamawa, awana kubamawa, apunu ridi tauwa-mawa ade petemuguma apunu tauwa-mawa, mu inako kwaetagamawa kebomawa da apunu Nowa waka kawaya ki kawareya yapu posiwena. ");
INSERT INTO gdn_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Mara ki makeya ka iyapana eba kataimugu da awana goya kawaya ki yabadawa, ko goya kawaya ki bauwena iyapana kuduba bibiyotapu gawarara. Nau Kunumau Kawapuwani Apunai ade wirasugana bausugana marai ka inako wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Nau bausugani ki ka iyapana apeya upitagamu idiwu ki nau mo yadani ko mosi kamadani. ");
INSERT INTO gdn_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ridi apeya bani madai musupiyamu idiwu ki nau mo yadani ko mosi kamadani. ");
INSERT INTO gdn_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Ki pokere wi wibo kwayubaga kwaiwogoi yabu yabu idiwoi. Nau wi Kaiwawoga gwede mara ade wira-sugana bausugana marai ki wi eba kataigau. ");
INSERT INTO gdn_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Nau yona yau mete suwagani ki wi naigida mena wainapu-muri; Tawa apunai e eba kataiya da kuwa apunai kemorau gwede madega baiyagisi. E kataiwagubena ki ka e dagurai tondibena manako kuwa apunai ki eba bauwagubena e tawai baupena. ");
INSERT INTO gdn_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Baganai, ki maba nau nawanani yabu yabu idiwoi. Wi wainapiyoi da nau eba bausugana marai ki nau Kunumau Kawapuwani Apunai ade wirasugani bausugani.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Bigabiga apunai nima e upi eba kamadau ko e notai supasupai kawaya mena kwaewagau ki e bameya badidi wenayagisi ki nau karako wi nidiyani wainapumuri; Kawai apunai tawa kamadini kayayogono ki ka e bigabiga apunai ki e nene yagisi baiyagisi manako siyoto da e yabiyabiri uburono manako e kowaiyoma bigabiga ragidai kuduba mu upimaga badidi upitagamu ki makeya mu denimaga tageyono. ");
INSERT INTO gdn_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Bigabiga apunai ki uburoto e upi wadubu ki naigida mena kwayubapono kwaeyogono tondono da apunu kawai ki ade wirayagisi baiyagisi e empoto, ki ka apunu kawai ki e mamamai yagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ena, nau mibai suwagani wainapu-muri; Bigabiga apunai ki e upi naigida mena inako kwayubapono kwaeyogono tondono ki ka tawa apunai ki e tepapoto kawaiyagisi manako siyoto, yagisi ke; ‘Nau tawani ade nau gwedegwedeni kuduba ki kau mete kwayubapiyowa.’ ");
INSERT INTO gdn_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Ko bigabiga apunai ki e berai eba bagi ki ka e upi naiya wadubu ki naigida eba kwayubapono ko e notai yagisi ke; ‘Nau kawaini e wirawagana bauwagana marai ki e paerepupu rowarowa kawaya umau wadau’. ");
INSERT INTO gdn_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","E inako notapono manako e eya kawai gisipono e kowaiyoma bigabiga ragidai ridi yo apunu ki tauniyono makari tageyono ade bani kawaya daganani kupono awana suwakarai mete kuburono da e yabarai babayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ko ki makeya ka tawa apunai ki ade wira-yagisi baiyagisi manako bigabiga apunai ki nainipoto. ");
INSERT INTO gdn_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","E eba nawanawagawa ki pokere apunu kawai ki baiyagisi bigabiga apunai ki yadini gudapoto bidara kweyoto manako ewa yadini iyapana midimaga pa matakawagau ragidai mu watamugu kwenupoto. Kwenupoto manako e ika yadi kirono uwarai sisiripono tondono.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Iyesu ade tadebu, wagubu ke; “Mara ki makeya wi Mamanuga God e gari rabineya badidi maba kaiwana ki keyakeyai mosi ka yau kena; Onowa ida esida mena ki mu duna-muguma temupu anika waunai apunai ki bananapamana nawanai kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Onowa ki mu paunamugu ida daikere mena ka notanotai ko ade ida daikere ka notababa ragidai. ");
INSERT INTO gdn_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Notababa ragidai ki mu dunamuguma mena temupu ko duna awanai yapaka ki mu eba temupu. ");
INSERT INTO gdn_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ko onowa notanotai ki mu ka mu duna-muguma ki awanai yapaka mete temupu. ");
INSERT INTO gdn_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Anika apunai ki garugaru eba bauwena ki pokere onowa ki kuduba pa nawana idiwa da paunau ka mu yabu-maga towena manako oro wadumpu. ");
INSERT INTO gdn_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Tedera paunau ka apunu mosi ubupu e bonanai ragiragi kawaya wagubu ke; ‘Anika apunai bauwagana kwaewagau, wi kebomuri e banana-pumuri.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","E yona ki wagubu ka onowa ida esida ki kuduba wakapa giritagubu kimpu ubumpu mu dunamuguma wade kawakawayamupu, ");
INSERT INTO gdn_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ko notababa ragidai ki mu dunamuguma awanai kewowena ki pokere mu ubumpu notanotai ragidai ki tademupu, tagubu ke; ‘Wi dunaga awanai dai nu negemuri, mibai ka nu dunanuguma awanai ki kewowena.’ Mu inako tagubu, ");
INSERT INTO gdn_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","ko onowa notanotai ki denai mu tademupu, tagubu ke; ‘Pa mena, nu nubo denenugu mena minimipi ki pokere dai wi nege-mana ka eba baganai. Wi kaiwagi wi wibo awanaga ki gimarapumuri.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Mu inako tagubu manako notababa ragidai ki ubumpu mu dunamuguma awanai ki gimarapamana ki nana kayatagubu. Mu kayatagubu ewamugu ka anika apunai ki bauwena. Onowa notanotai ida daikere mena ki mu ka okukuna-tagubu kewowena ika nawana idiwa ki pokere anika apunai ki bauwena ka e mu emitapu waratapu tawa rabineya anika kupei kupetagamana ki nana yamupu manako ewa gudu umamupu. ");
INSERT INTO gdn_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Notababa ragidai iwa da ewa bautagubu ka mu gudu umampu ki tagaiya wadedetagamawa, tagamawa ke; ‘Kaiwawonuga, Kaiwawonuga, kau gudu nu nene kwaipi.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Mu inako tagubu, ko apunu ki denai tadebu, wagubu ke; ‘Ki pa mena, nau eba kataineya wiyo.’” ");
INSERT INTO gdn_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Iyesu keyakeyai ki wagubu kewowena ka e iyapana ade tadebu, wagubu ke; “Nau gwede mara bo gwede madega bausugani ki wi eba kataigau ki pokere yabu yabu idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Iyesu mu ade tadebu, wagubu ke; “Mara ki makeya wi Mamanuga God e gari rabineya badidi maba kaiwana ki keyakeyai mosi ka yau kena; Apunu kawai mosi tawana uwama kawaya mo kayawagana kwaewagawa ki pokere e bigabigaiyoma apeya eyaka ki mu nene wagubu bautagubu manako e gwede-gwedei kuduba mu idamaga rabineya nakapupu da mu kwayubapamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Mu eyaka eyaka kataimaga kawayai ki makeya makeya ka e bowa madai mu tagebu. Mosi ka e bowa madai 5000 kwebu, mosi ka e 2000 kwebu, ade mosi ka e 1000 kwebu. E inako kwaewena manako kamaditapu tawana mo kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Bowa madai 5000 wadubu apunai ki e kayawena bowa madai ki pokaiya upi mo kwaewagawa manako bowa madai ki kawayawagawa yarawa da e kawareya ade 5000 wadubu. ");
INSERT INTO gdn_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Bowa madai 2000 wadubu apunai ki e mete inako kwaewena. E kayawena bowa madai ki pokaiya upiwagawa yarawa da bowa madai ki kawareya ka e ade 2000 wadubu. ");
INSERT INTO gdn_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ko bowa madai 1000 wadubu apunai ki e upi mo eba kwae-wena ko e ubupu apunu kawai ki e bowai madai wadubu kayawena uruba ukwapupu manako rabineya wekepupu. ");
INSERT INTO gdn_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Apunu kawai ki umawa wadawa da mara rowarowa kawaya kewowena eweya ka e ade wirawena bauwena manako e bigabigaiyoma mu nene wagubu bautagubu tadebu, wagubu ke; ‘Nau bowa madai wi kwayubapamana ki nana negebuwani ki wi karako tepumuri baiwagi da nau empani.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Bowa madai 5000 wadubu apunai ki e yabiri bauwena manako wagubu ke; ‘Bada emani, kau bowa madai 5000 nau idani rabineya tapi ko ki pokaiya ka nau upisugekeya da kawareya ade 5000 wadubuwani karako negeyakani yau kena.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","E yona ki wagubu ka apunu kawai ki denai e sibu, wagubu ke; ‘Kau midigi eba togawena ko kau upi bagi kawaya kwaenugibi apunai. Nau marai munta negebuwani ki kau naigida mena kwayubapiyeya ki pokere nau karako kawaya daganani negeyani ki kau mete kwayubapiyowa. Kau yabi da nau mete ewapuru idiwomu mamamaigomu.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ki eweya ka bowa madai 2000 wadubu apunai ki e mete bauwena manako wagubu ke; ‘Bada emani, kau bowa madai 2000 nau idani rabineya tapi ko ki pokaiya ka nau upisugekeya da kawareya ade 2000 wadubuwani karako negeyakani yau kena.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","E yona ki wagubu ka apunu kawai ki denai e sibu, wagubu ke; ‘Kau midigi eba togawena ko kau upi bagi kawaya kwaenugibi apunai. Nau marai munta negebuwani ki kau naigida mena kwayubapiyeya ki pokere nau karako kawaya daganani negeyani ki kau mete kwayubapiyowa. Kau yabi da nau mete ewapuru idiwomu mamamaigomu.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Siyarai ka bowa madai 1000 wadubu apunai ki e mete bauwena manako wagubu ke; ‘Bada, nau kataineya da kau midigi kwakwarepugi ka tayatayabadai. Kau eba upinugibi kokoreya ki kau bani tepiyei ade kau momai eba upi wateya ki kau raupomunugei. ");
INSERT INTO gdn_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Nau kau kudugeya wainapekeya ki pokere kau bowagi madai ki nau tepuwani waira rabineya wekepuwani ko ki kuduba nau karako ade negeyakani yau kena.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Bigabiga apunai yona ki wagubu wainapupu ka apunu kawai ki denai e sibu, wagubu ke; ‘Kau ka berokoi ade kau ramatagi ka togatogai upi eba kwaenugei apunai. Nau eba upisugubuwani kokoreya ki nau bani tepakani ade nau momai eba upuwani wateya ki nau raupomusugakani ki kau katainugibi nuwegei? ");
INSERT INTO gdn_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Baganai, kau katainugibi ki pokere bowa madai negebuwani ki kau wadubena kayanugubena bowa madai kawayawagau wateya tapena da nau karako wirasugubuwani bausugubuwani ki kau bowa madai dai kawareya tapena ki nau mete tegebena.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Apunu kawai ki inako wagubu manako e bigabigai-yoma tadebu, wagubu ke; ‘Bowa madai 1000 apunu yau kwebuwani ki wi wadmuri bowa madai kawaya daganani 10000 wadubu apunai ki e kwemuri. ");
INSERT INTO gdn_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Nau nidiyani wainapumuri; Iyapana nima marai munta wadubu ki pokaiya uburau upi naigida mena kwaewagau kwayubapiyau ki kawareya ka e ropani kawaya bananapoto ade e bondai ki mete uburono. Ko iyapana nima e bameya marai munta uburau ki kawareya ka e mo eba yadini ade marai munta e bameya uburau ki mete gogayagisi. ");
INSERT INTO gdn_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Wi apunu berokoi yau karako wadumuri sisipu tawaneya gari tagaiya kwenupu-muri. E ika yadi kirono e uwarai sisiri-pono tondono.’ Apunu kawai ki inako wagubu.” ");
INSERT INTO gdn_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Iyesu mu ade tadebu, wagubu ke; “Nau Kunumau Kawapuwani Apunai kaiwawosugani nau aneyaniyoma bananasinimoto kaworoni makeya ki ka wi nau kepakepani tanai bagi kawaya ki kawareya tondoni emisinimuri. ");
INSERT INTO gdn_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","33","Iyapana kuduba, madega kauwagau madega posiwagau ki mu baitagisi Kunumau Kawapu apunai e yabareya dibipomoto idiwono manako papa sipi yo papa gote kwayuba-tamiyamu ragidai mu papamuguma badidi maba purupiyamu papa sipi daikere nakapiyamu ade papa gote daikere nakapiyamu ki maba ka e uburoto iyapana bagi supasupai kwae-tagamawa ragidai tetamini e idai garu deneya nakatamini ade eba supasupai kwaetagamawa ragidai ki tetamini e idai tenene deneya nakatamini. ");
INSERT INTO gdn_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","E inako kwaeyagisi kewoyagisi eweya ka wi Kaiwawoga uburoto e idai garu deneya idiwu ragidai ki tadeni, yagisi ke; ‘Nau Mamai wadinibu bagi ragidai wi karako kebomuri manako e kunuma waira kerareya wi wataga e gari rabineya yamanapupu ki rabineya ka wi e kasiyarai pokaiya idiwoi. ");
INSERT INTO gdn_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Nau wetei mesiniyawa makeya ka wi nau bani tegemupu kububuwani, ade nau awana gobani wagawa ki makeya ka wi nau awana tegemupu kubabuwani. Nau gogai wi bamagau bausugubuwani ki wi nau diriwani kwaigubu, ");
INSERT INTO gdn_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ade nau sipumani pa mena ki wi nau sipuma-sinimupu. Nau sigirasugubuwani ki wi nau kwayubasinimawa ade nau dibura rabineya tondekeya ki wi nau kasiyara tegemana ki nana nau daiyoni baigubu.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","E inako yagisi ki ka iyapana bagi supasupai kwaetagamawa ragidai denai e siyomoto, tagisi ke; ‘Kaiwawonuga, kau gwede mara wetei meniyawa manako nu bani kau negemipi, ade kau gwede mara awana gobagi wagawa manako nu awana kau negemipi? ");
INSERT INTO gdn_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kau gwede mara nu bamanugu iyapana gogai maba baunugibi manako nu kau diriwagi kwaigibi ade gwede mara ka kau sipumagi pa mena manako nu kau sipumanimpi? ");
INSERT INTO gdn_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kau gwede mara sigiranugibi manako nu kau eminimpi bo kau gwede mara dibura rabineya tondeya manako nu kau daiyogi baigibi?’ Mu inako tagisi, ");
INSERT INTO gdn_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ko wi Kaiwawoga denai yagisi ke; ‘Nau yona mibai nidiyani wainapumuri; Wi ubumpu nau iyapananiyoma kupamu siyasiya iwu ragidai mu diriwamaga kwaigubu ki ka wi nau diriwani mete kwaigubu ki kena.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","E inako yagisi manako ade wirayagisi iyapana e idai tenene deneya ubumu ragidai ki tadeni, yagisi ke; ‘Mamanuga God e kowagai rabineya idiwu ragidai, wi paepereiwagi kamadisinimuri kaiwagi. Berokoi Apunai Seitani e aneyaiyoma mete kina mu watamaga mata maramara urau ki tawaneya Mamanuga God yamanapupu ki wateya ki wi mete ika kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Nau wetei mesiniyawa makeya ki wi nau bani eba tegemupu, ade nau awana gobani wagawa ki makeya ka wi nau awana mete eba tegemupu. ");
INSERT INTO gdn_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Nau gogai wi bamagau bausugubuwani ki wi nau diriwani eba kwaigubu, ade nau sipumani pa mena ki ka wi nau eba sipumasinimpu. Nau sigirasugubuwani ade dibura rabineya tondekeya ki wi nau nene eba kwaigamawa.’ ");
INSERT INTO gdn_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","E inako yagisi ki ka mu denai tagisi ke; ‘Kaiwawonuga, kau gwede mara wetei menibu, bo awana gobagi wagubu, bo kau iyapana gogai maba baunugibi, bo kau sipumagi pa mena, bo kau sigiranugibi bo ade dibura rabineya tondeya manako nu kau eba eminimpi waitanimpi?’ Mu inako tagisi, ");
INSERT INTO gdn_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","ko wi Kaiwawoga denai yagisi ke; ‘Nau yona mibai nidiyani wainapumuri; Wi nau iyapananiyoma kupamu siyasiya iwu ragidai mu diriwamaga eba kwaigubu ki ka wi nau diriwani mete eba kwaigubu ki kena.’ E inako yagisi, ");
INSERT INTO gdn_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","manako uburoto iyapana ki tonotamini bita maramara wadamana ki tawaneya kayatagisi. Ko iyapana bagi supasupai kwaetagamawa ragidai ki mu e tonotamini iya maramara idiwana ki wateya kayatagisi idiwono.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Iyesu yona yau kuduba iyapana kabuwatapu kewowena ka e wirawena e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Wi kataigau da mara apeya yabaranugu ka ‘Mamanuga God Nu Raurunibu Poragai’ ki marai. ");
INSERT INTO gdn_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","Poraga ki kawareya ka iyapana ubumoto nau Kunumau Kawapuwani Apunai wadisinimoto piyara ragidai mu idamaga rabineya nau tamusinimoto manako mu ubumoto nau ripa korosi naureya susinimoto poyo.” ");
INSERT INTO gdn_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Mara ki makeya ka iyapana kawakawai ade Mamanuga God bameya dobopiyamu ragidai mete kina ewapuru mena Mamanuga God bameya dobo-piyamu ragidai kawaimaga si ka Kaipasi e tawaiya dibimupu, ");
INSERT INTO gdn_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","manako mu Iyesu wekei gwaiya wadamana minimana po ki keketai kupamawa. ");
INSERT INTO gdn_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Iyapana ropani kawaya ika poraga kawareya bautagubu ki pokere kawakawai ragidai ki tagubu ke; “Iyapana ropani kawaya yewe bautagubu ki ubumana nu yawirani-mana kudeya ki pokere kamadamu da poraga yau kewoyagisi were ewa ka nu apunu ki yadamu.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ki makeya ka Iyesu apunu mosi si ka Simiyoni e bameya natere Betani rabineya tondawa. Apunu Simiyoni e ka naiya sigira berokoi mo wadubu e kwakwarepui kwatakwatawena, ko e karako iyawena. ");
INSERT INTO gdn_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Mu kupetagamawa idiwa ka ridi mosi ripa otai aurai bagi kawaya awana kororai mo rabineya minibu ki wadubu Iyesu bameya bauwena. Awana ki denai ka kawaya daganani, ade awana kororai ka mu bowa si ‘arabata’ pokaiya yamanamupu. Ridi ki Iyesu bameya bauwena manako ripa otai bagi kawaya ki Iyesu debaiya kwebu wira. ");
INSERT INTO gdn_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Iyesu e tadeyau kabukabuwa ragidai ridi ki badidi kwaewena emupu ka mu rabina-maga urabu manako mu mubo mena inako tagubu ke; “Ridi yau awana bagi kawaya ki gwede nana pa giripupu? ");
INSERT INTO gdn_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","E kayawagubena iyapana gimarampena manako denai bowa madai kawaya daganani kwempena ki e wadubena iyapana gwedegwedemaga pa mena imagei ragidai ki tagebena.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Ko mu badidi notapamawa ki Iyesu e ororeya mena kataiwena ki pokere e tadebu, wagubu ke; “Ridi yau kamadumuri midimama eba kwemuri. E bauwena nau nene badidi kwaewena ka bagi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Gwedegwedemaga pa mena imagei ragidai ki mu ka maramara wi mete idiwoi da wi mu waitatamiyoi, ko nau marani rogobiwena da nau ewa wi mete eba idiwomu. ");
INSERT INTO gdn_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ridi yau badidi kwaewena ki kuduba bagi mena. Nau posugana marai waunitau ki pokere e karako bauwena nau monagasinibu awana bagi kawaya yau nau debaneya kwebu wira. ");
INSERT INTO gdn_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Nau mibai nidiyani wainapumuri; Iyapana tawana tawana idiwu aita ewa nau yonani bagi kawaya wainapomoto ki ka mu ridi yau nau nene badidi kwaewena ki sisiyai mete waina-pomoto manako e werei togomono.” ");
INSERT INTO gdn_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Iyesu yona ki wagubu makeya ka e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya apunai mosi si ka Diyudiyasi si daikere ka Isikariyoto e kipu ubupu Mamanuga God bameya dobopiyamu ragidai ki mu bamamugu kayawena, ");
INSERT INTO gdn_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","manako manutapu, wagubu ke; “Nau karako waitaniyani da wi Iyesu wekei gwaiya wadumuri ki ka wi denai nau gwede tegemuri?” Mu bowa madai apunai eyaka mena ade ida esida mena (30) ki iyabamupu kwemupu, ");
INSERT INTO gdn_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ki pokere apunu Diyudiyasi kayawena Iyesu wadana mu idamaga rabineya tarana ki yawatai kwaenepiyawa umawa. ");
INSERT INTO gdn_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","‘Parawa Pa Pasumana Kupei’ ki marai yabiri bauwena ki makeya ka Iyesu tadeyau kabukabuwa ragidai e bameya bautagubu manako simupu, tagubu ke; “Kau nuwageya nu tawa bani rabineya yamamu tawiyaigamu da kau ‘Mamanuga God Nu Raurunibu Poragai’ ki kupei kupenuwagi?” ");
INSERT INTO gdn_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Mu inako tagubu manako e denai tadebu, wagubu ke; “Wi natere Diyerusaremu kaiwagi, manako apunu mosi ika bananapumuri ki wi simuri, iwagi ke; Nu Nidiyau Kabukabuwa Apunai nu tononibu wagubu ke; Nau marani wana bauwena ki pokere kau tawageya ka nau tadeyakani kabu-kabuwa ragidai mete kina ‘Mamanuga God Nu Raurunibu Poragai’ ki kupei ika kupeigamu.” ");
INSERT INTO gdn_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Iyesu inako tadebu tonotapu manako mu kayatagubu natere ki rabineya e wagubu ki makeya makeya kwaetagubu ‘Mamanuga God Nu Raurunibu Poragai’ ki ika tawiyatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Kemorawagana kwaewagawa ka Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya mete ika dibimupu kupetagamawa idiwa, ");
INSERT INTO gdn_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","manako paunau ka e ubupu mu tadebu, wagubu ke; “Nau yona mibai nidiyani wainapumuri; Waunitau ka apunu mosi wi paunagau uburoto nau yogoni yagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Iyesu yona ki wagubu wainamupu ka mu notamaga kowena nuwaboya-tagubu manako mu eyaka eyaka e manumupu, tagubu ke; “Kaiwawoni, kau nau nene nuwegei bo? Kau eba nau nene nuwegei?” ");
INSERT INTO gdn_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ko Iyesu tadebu, wagubu ke; “Ki ka apunu eyaka mena mosi karako nau mete ewapuru bani pikapana ki nana awanau kaupiyau yogo yau kawareya nau mete ewapuru kupemei apunai ki waunitau nau nidani yagisi. ");
INSERT INTO gdn_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Takari kawaya ka Mamanuga God e bonanai wainapamawa tagamawa ragidai ubumpu nau Kunumau Kawapuwani Apunai posugana ki yonai oka tamupu. Ko apunu nima nau nidani yagisi ki e ka aita bita kawaya daganani bananapoto. Akae, apunu ki eba wenawagubena ki e nene baganai.” ");
INSERT INTO gdn_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Iyesu yona ki wagubu ka e yogoi tapu apunai Diyudiyasi e empupu manako wagubu ke; “Sidiyei Kabu-kabuwa Apunai, kau nau nene nuwegei bo? Kau eba nau nene nuwegei?” E inako wagubu, ko Iyesu denai e sibu wagubu ke; “Kau kiya yona ki nuwagibi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Mu kupetagamawa idiwa da paunau ka Iyesu bani buredi mo wadubu Mamanuga God bameya parauwena piripiri gerepupu manako e tadeyau kabukabuwa ragidai tagebu, tadebu, wagubu ke; “Bani buredi yau ka nau kwakwarepuni ki pokere tepumuri kupumuri.” ");
INSERT INTO gdn_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","E inako wagubu manako kapa mo wadubu Mamanuga God bameya ade parauwena manako tagebu tadebu, wagubu ke; “Wi kuduba awana yau piripiri kubamuri. ");
INSERT INTO gdn_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Awana ‘waeni’ daragai yau ka nau darani. Nau Mamai uburana iyapana ropani kawaya mu bigimaga deni mena surupana ki nana gwaiyabawena ki mibai wenawagana ki nana ka nau karako posugani manako nau darani baiyagisi kaworoto. ");
INSERT INTO gdn_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Nau yona mibai nidiyani wainapumuri; Awana daragai yau ka nau ewa mo eba kubarani. Ko aita ewa nau Mamai God e gari rabineya e kasiyarai pokaiya tondoni makeya ki nau awana ‘waeni’ waunai mosi wi mete ewapuru kubamamu.” ");
INSERT INTO gdn_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Iyesu yona ki wagubu kewowena ka mu Mamanuga God e si umayo pokaiya tepamupu manako kayatagubu kaimpu ripa ‘oripi’ wenatagubu kweyai ki yampu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Mu kayatagubu kaiwa ka Iyesu yona mo mu ade tadebu, wagubu ke; “Nau kataineya da kemora yau rabineya ka wi kuduba nau kamadisinimuri kudu wakapaiwagi kaiwagi, mibai ka takari kawaya ka Mamanuga God e bonanai wainapiyawa wagawa apunai mosi nau nene oka inako tapu, wagubu ke; ‘Mamanuga God wagubu ke; Aita ewa ka nau papa sipi kwayubatamiyau apunai miniyani manako papa sipi kuduba daburipomoto mu mubo mubo kayatagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Iyesu inako tadebu, manako ade tadebu wagubu ke; “Nau posugani ade iyasugani kirani uburani ki nau yabiri kayasugani tawana Gariri rabineya wi nawanaga ika tondoni.” ");
INSERT INTO gdn_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Apunu Pita yona ki wainapupu ka e denai wagubu ke; “Mu dai ka bani kau kamadinimoto kudu wakapatagisi kayatagisi ko nau kau eba kamadiniyani kayasugani.” ");
INSERT INTO gdn_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Apunu Pita inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Pita, nau mibai nidiyani wainapi; Kemora yau rabineya ka kau mara apeya eyaka nuwagi bodaboda da kau eba kataigeya nau. Kau inako beranugowa manako ewa ka kokoroku yagisi manako nawaru puruyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Iyesu inako wagubu, ko apunu Pita e midi minibu, wagubu ke; “Akae, nau inako eba suwagani. Kau ponuwagi ki ka nau mete posugani.” Apunu Pita inako wagubu manako Iyesu tadeyau kabukabuwa ragidai kuduba Pita umunui kawareya ki mu mete tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Mu kayatagubu kaiwa da tawana Gesemane bautagubu ka Iyesu mu munatapu, wagubu ke; “Wi yewe idiwoi ko nau niya mena kayasugani nau Mamai bameya gurigurisugani.” ");
INSERT INTO gdn_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","E inako wagubu manako ubupu apunu Pita ade apunu Tabadi e gubagaiyoma apeya ki mu mena waratapu mete kayatagubu. Ki makeya ka Iyesu nuwaboya kawaya wainapupu ade e rabinai giriwena pasuwena, ");
INSERT INTO gdn_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ki pokere e kowakowaiyoma ki emitapu tadebu, wagubu ke; “Nau karako nuwaboya kawaya wainapakani ade nau rabinaneya po mete wainapakani ki pokere wi nau mete yabu yabu yewe idiwoi ko oro eba ukwopoi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","E inako tadebu kamaditapu kanibu e ebo mena ubupu manako kwarisiwena wairau ukwapu e Mamai bameya guriguriwena, wagubu ke; “Mamai, berokoi nau karako banana-pani ki kau surupi bo? Kau wainapiyei da baganai ki kau baunuwagi nau nuwaboyani kerarai kapa tegebi ki kau wadi kwenupi. Ko Mamai, kau kaubo nuwageya ki kwaenuwagi ko eba nau nuwaneya ki kau kwaenuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Iyesu inako guriguriwena manako e ade wirawena bauwena ka e tadeyau kabukabuwa ragidai apeya eyaka ki ika ukwapamawa emitapu. Emitapu, wade yabuyabutapu, manako e apunu Pita empupu sibu, wagubu ke; “Nau eba rowarowa kanibuwani ko wi apeya eyaka badidi pokere nau mete yabu yabu eba idiwei? ");
INSERT INTO gdn_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Yabu yabu idiwoi, ade Mamanuga God bameya guriguriwogoi da gwede mosi eba baiyagisi wi kerapugau yadini. Wi nuwaga notaga ka wi bani kasiyara wainapiyamu ko wi kwakwarepuga ka kasiyarai pa mena.” ");
INSERT INTO gdn_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Iyesu inako tadebu manako wirawena kanibu e Mamai bameya ade guriguriwena, wagubu ke; “Mamai, kau kapa tegebi ki nau kamadana yawatai pa mena ki ka baganai, nau kubarani. Eba nau nuwaneya ki kau kwaenuwagi ko kau kaubo nuwageya ki kwaenuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","E inako guriguriwena manako ade wirawena bauwena e kowakowaiyoma ki yabumaga ade bisi kayawena ukwa-pamawa emitapu. ");
INSERT INTO gdn_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","E mu emitapu kamaditapu ade kanibu e Mamai bameya naiya guriguri-wena ki kawareya ade guriguriwena. ");
INSERT INTO gdn_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","E guriguriwagawa da kamadubu ka e wirawena bauwena e kowakowaiyoma ki ade ukwapamawa idiwa emitapu manako wade yabuyabutapu tadebu, wagubu ke; “Wi oro mena ukwapamu idiwu bo? Ko karako kewowena. Nau Kunumau Kawapuwani Apunai nau marani wana bauwena da nau nidani wagubu apunai ki baiyagisi nau wadi-siniyoto manako iyapana beramaga berokoi ragidai mu idamaga rabineya nau tamusiniyoto. ");
INSERT INTO gdn_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ki pokere, kimuri ubumuri da kaigomu. Nau yogoni tapu apunai ki wana bauwena empumuri.” ");
INSERT INTO gdn_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Iyesu yona ki wagawa makeya ka mu apunu Diyudiyasi ika matarau bauwena emupu. E ka Iyesu e tadeyau kabukabuwa ragidai ida esida kewo-wena kerapu apeya ki apunai mosi. Diyu ragidai mu kawakawaimuguma ade Mamanuga God bameya dobo-piyamu ragidai mete kina ki mu iyapana ropani kawaya tonotampu ta yo kepata inako temupu apunu Diyudiyasi mete ika bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yawatau ka yogo tapu apunai ki iyapana ki inako tadebu, wagubu ke; “Nu kaigamu buri baigamu ki wi nau mena emisiniyoi manako apunu ki nau kiyauyauponi ki e wi naigida mena wadumuri dokodoko kaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Apunu Diyudiyasi inako tadebu, ki pokere mu karako bautagubu ka e deni mena kayawena Iyesu bameya bauwena manako paraupupu, wagubu ke; “Sidiyei Kabukabuwa Apunai, kaiwa kaiwa.” E inako wagubu, manako kanibu Iyesu kiyauyaupupu. ");
INSERT INTO gdn_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ko Iyesu apunu Diyudiyasi empupu manako sibu, wagubu ke; “Nau waretani, kau badidi kwaenugana wainapiyei ki kau garugaru mena kwaenuwagi.” E yona ki wagubu makeya ka iyapana ki Iyesu waipara mena wade dokodokomupu ubumawa. ");
INSERT INTO gdn_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ko Iyesu mete iwa apunai mosi ubupu e kerebai wadubu iyara apunai ki mosi e wenagui mebu puru. Bidara wadubu apunai ki e ka Mamanuga God bameya dobopiyamu ragidai kawaimaga ki e bigabigai apunai mosi. ");
INSERT INTO gdn_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ko Iyesu wirawena kereba wadubu apunai ki sibu, wagubu ke; “Kau kerebagi wadi wateya ade tari. Iyapana gwedewau kereba sumeya kwaetagamu ragidai ki mu ka aita kereba pokaiya popotagisi. ");
INSERT INTO gdn_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Nau naubo nuwaneya kwaesugubena ki ka nau Mamai kabuwapena manako e aneyaiyoma ropani kawaya eba bigabigai nau waitasinimana ki nana kunumau tonotapena kawampena nau waitasinimpena, ko ki wi wainapiyamu bo pa mena? ");
INSERT INTO gdn_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Nau Mamai inako sibena ki ka e bonanai wainapamawa tagamawa ragidai takari kawaya oka tampu ki mibai eba wenawagubena, ko nau eba sibuwani mibai ka nau nuwaneya oka ki wenawagana ki nana.” ");
INSERT INTO gdn_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Iyesu inako wagubu manako wirawena iyapana ropani kawaya ika bautagubu ki mu emitapu tadebu, wagubu ke; “Nau ka eba yawiyawirai. Wi ta yo kepata wi tawagau kamadumpena pa baigumpena, ko wi gwede nana ki mete temupu nau yawirani baigubu? Nau maramara Mamanuga God e Tawai rabineya wi nidiyekeya kabukabuwa tondekeya ko wi badidi pokere mara ki makeya nau eba wadisinimupu? ");
INSERT INTO gdn_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ko baganai; Mamanuga God e bonanai waina-pamawa tagamawa ragidai takari kawaya oka tampu ki mibai karako wenayagisi.” Iyesu yona ki wagubu wainamupu ka e tadeyau kabukabuwa ragidai kuduba e kamadumpu wakapatagubu garugaru mena kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Iyapana ki Iyesu wadumpu dokodoko kayatagubu kaiwa da Mamanuga God bameya dobopiyamu ragidai kawaimaga si ka Kaipasi e tawaiya bautagubu. Diyu ragidai kawakawaimuguma ade Mamanuga God e gorai kataimugu ragidai kuduba mete kina ika dibimupu idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Apunu Pita Iyesu eweya weke-wagawa yabadawa da tawa ki kakapareya tewena imatau bauwena manako kanibu iyara ragidai ika idiwa ki mu paunamugu tondubu. E Iyesu bameya badidi wenawagana ki empana ki nana ika tondawa. ");
INSERT INTO gdn_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Mamanuga God bameya dobo-piyamu ragidai ade Diyu ragidai mu kawakawaimuguma mete kina ki mu nuwamugu Iyesu minimana po waina-mupu ki pokere e paere mo kwaewena ki mu beratagamana ade matarapamana ki yawatai mu kwaenepamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Iyapana ropani kawaya bautagubu mu mubo mubo beratagamawa ko mu rabinamaga ka eba eyaka mena ki pokere mu mibai mo eba bananamupu. Mu mubo mubo inako manu kasiwara-tagamawa idiwa da paunau ka iyapana apeya ubumpu, ");
INSERT INTO gdn_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","manako tagubu ke; “Apunu yau wagubu ki nu wainamipi, e wagubu ke; ‘Mamanuga God e Tawai ki nau koritapani manako mara apeya eyaka rabineya ka nau tawa ki waunai ade yadani.’” ");
INSERT INTO gdn_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Iyapana apeya ki inako tagubu wainamupu ka Mamanuga God bameya dobopiyamu ragidai mu kawaimaga ubupu Iyesu sibu, wagubu ke; “Mu yona tagubu ki denai kau mo nuwagi bo pa mena? Mu gwede yonai tagubu?” ");
INSERT INTO gdn_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","E inako wagubu, ko Iyesu kererewena yona denai mo eba wagubu ki pokere Mamanuga God bameya dobopiyamu ragidai kawaimaga ki ubupu e ade sibu, wagubu ke; “Maramara tondau apunai Mamanuga God e kau eminiyau ki pokere e yabuiya karako matarau nuwagi da nu wainapamu; Mamanuga God e eya Gubagai ade nu Iya Negeyana Apunai Keriso ki kau baganai bo?” ");
INSERT INTO gdn_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","E yona ki wagubu ka Iyesu denai e sibu, wagubu ke; “Ena, ki kau ba nuwegei. Ko nau wi kuduba nidiyani wainapumuri; Nau Kunumau Kawapuwani Apunai aita ewa uburani nau Mamai Kasiyarai Kawaya Esida Apunai e idai garu deneya tondoni ki wi nau emisinimuri manako nau kunumau oroguma kawareya ade wirasugani kaworoni ki wi nau mete emisinimuri.” ");
INSERT INTO gdn_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Iyesu yona ki wagubu makeya ka Mamanuga God bameya dobopiyamu ragidai mu kawaimaga ki e yabui dara wirawena manako e ubupu e eya midi tatamai wadubu tegere manako iyapana ika idiwa ki manutapu, wagubu ke; “E yona berawena Mamanuga God e si giripupu ki wi wainamupu bo? E eya wagubu ki nu kuduba wainamipi kewowena ki pokere e paere kwaewena iwagamana matara ki yonai nu kwaene-pemeya idiweya ki kwaenei karako kewowena. ");
INSERT INTO gdn_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Apunu yau Mamanuga God bameya berawagau ki pokere wi wainapiyamu da nu karako e bameya badidi kwaigamu?” E inako wagubu ka kawakawai ragidai ki mu kuduba ubumpu ewapuru mena mu idamaga gurai Iyesu naureya ugwadumpu ragiragi, tagubu ke; “E Mamanuga God e si giripiyau ki pokere e denai karako poyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Mu inako tagubu manako mu dai ubumpu Iyesu kiyabuiya tepotepo-pamawa ade minimawa ade dai e kwanabeya minimawa manako waegeyageyamapamawa, tagamawa ke; ");
INSERT INTO gdn_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“Ki nima nunibu? Kau nu Iya Negeyana Apunai Keriso baganai ki ka kau nima nunibu ki e si nuwagi da nu wainapamu.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ki makeya ka apunu Pita ika imatau tondawa manako Mamanuga God bameya dobopiyamu ragidai kawaimaga e bigabigai munu ridai mosi bauwena e empupu sibu, wagubu ke; “Kau mete kina ka tawana Gariri apunumaga Iyesu mete iwa apunai mosi eminiyakani.” ");
INSERT INTO gdn_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Munu ridai ki inako wagubu ko Pita iyapana kuduba yabaramugu denai wagubu bodaboda, wagubu ke; “Kau apunu nima nene nuwegei? Kau yonagi ki nau eba wainapakani.” ");
INSERT INTO gdn_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Apunu Pita inako wagubu manako kipu ubupu kanibu tawa kakapareya uburawa. E ika uburawa ka munu ridai ade mosi bauwena e empupu manako iyapana ika idiwa ki tadebu, wagubu ke; “Apunu burida ka tawana Nasareta apunai Iyesu mete iwa apunai mosi.” ");
INSERT INTO gdn_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","E inako wagubu ko Pita ade wagubu bodaboda, wagubu ke; “Mamanuga God nau emisiniyau; Apunu ki nene iwagamu ki nau eba kataineya.” ");
INSERT INTO gdn_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Mu idimupu eba rowarowa ka iyapana ika idiwa ki Pita naigida mena yabu dokodokomupu manako simupu, tagubu ke; “Nu katainugu da kau ka e mete iwa apunai mosi, mibai kau ka tawana Gariri ragidai mu bonanamaga nuwegei.” ");
INSERT INTO gdn_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Pita yona ki wainapupu ka e midi minibu, wagubu ke; “Apunu ki nene iwagamu ki e nau eba kataineya. Mamanuga God e kataiya da nau yona mibai suwagakani. Nau berasugakani ki ka e kowaga tegeni ka baganai.” Apunu Pita yona ki wagawa makeya ka e kokoroku mo wagubu wainapupu, ");
INSERT INTO gdn_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","manako e wenagui paparawena Iyesu naiya badidi wagubu ki wainapupu. Iyesu naiya e inako sibu, wagubu ke; ‘Kemora yau rabineya ka kau mara apeya eyaka nuwogowa bodaboda da kau eba kataigeya nau. Kau inako beranugowa manako ewa ka kokoroku yagisi manako nawaru puruyagisi.’ Iyesu naiya inako wagubu ki makeya makeya apunu Pita wainapupu manako e kipu ubupu matarau kayawena yadi kawaya daganani kipu. ");
INSERT INTO gdn_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Nawaru dumai tarawa ka Mamanuga God bameya dobo-piyamu ragidai ade Diyu ragidai kawakawaimuguma kuduba mete kina Iyesu badidi maba minimana po ki keketai kupamawa. ");
INSERT INTO gdn_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Mu wadumupu e idai umamupu dokodoko manako bananamupu kayatagubu tawana Roumi ragidai piyaramuguma mu kawaimaga Pairasi bameya bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Iyesu yogoi wagubu apunai Diyudiyasi mu Iyesu wadumupu sisiyai wainapupu ka e rabinai wirawena e badidi paerepupu ki wainapupu, manako e bowa madai apunai eyaka mena ade ida esida mena (30) naiya kwemupu ki tepupu Mamanuga God bameya dobopiyamu ragidai ade Diyu ragidai kawakawaimuguma mete kina ki mu bamamugu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","E mu bamamugu bauwena ka e tadebu, wagubu ke; “Nau kwaesugubuwani siyasiya. Iyesu berokoi mo eba kwae-wena ki pokere nau e nidai suwagu-buwani ki nau paerepuwani kawaya daganani.” Apunu Diyudiyasi inako wagubu ko mu denai tagubu ke; “Ki ka eba nuyo ko kau kaubona.” ");
INSERT INTO gdn_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Mu inako tagubu ka apunu Diyudiyasi bowa madai kuduba ki tepupu Mamanuga God e Tawai rabineya isiyapupu manako kamaditapu bauwena kayawena kanibu e ebo kwikwiwena. ");
INSERT INTO gdn_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mamanuga God bameya dobo-piyamu ragidai bowa madai ki kwana-mupu manako tagubu ke; “Nu bowa madai yau Mamanuga God e Tawai nene tamamu ki ka nu goranuga raurupamu mibai ka bowa madai yau ka yogo tampu ki bowai madai.” ");
INSERT INTO gdn_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Mu yona ki kawareya tagamawa idiwa da mu rabinamaga eyakamenawena ka mu kayatagubu kurari yamanawagawa apunai mosi e bameya bowa madai ki pokaiya waira mo gimaramupu. Waira ki rabineya ka mu kwaiyanai ragidai popotagamana ki ika ononotamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Mara ki makeya yabadawa da karako ka iyapana waira ki si ‘Apunu Darai Waira Yau Wadubu’ ki tagamawa. ");
INSERT INTO gdn_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Mamanuga God e bonanai waina-piyawa wagawa apunai Diyeremaiya takari kawaya oka tapu ki mibai wena-wena yau kena. E oka tapu ki inako wagubu ke; ‘Tawana Isiraero ragidai mu rabina-maga eyakamenawena manako mu bowa madai apunai eyaka mena ade ida esida mena (30) ki tempu apunu powagana ki e yogoi tamupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Bowa madai ki pokaiya ka mu kurari yamanawagawa apunai mosi e wairai gimaramupu. Mamanuga God nau sidibu ki makeya makeya inako wenawena.’ Oragai apunai Diyeremaiya e oka inako tapu. ");
INSERT INTO gdn_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Mu Iyesu wadumpu apunu Pairasi bameya bautagubu e yabareya tamupu manako tawana Roumi kawaimaga ki ubupu Iyesu manupupu, wagubu ke; “Kau Diyu ragidai mu Kaiwawomaga kawai ki kau baganai bo?” E inako manupupu manako Iyesu denai wagubu ke; “Ena, ki kau ba nuwegei.” ");
INSERT INTO gdn_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Iyesu inako wagubu ka Mamanuga God bameya dobopiyamu ragidai ade Diyu ragidai kawakawaimuguma mete kina e kawareya kawareya naripamawa bera ropani kawaya siyamawa ko e yona denai mo eba wagubu. ");
INSERT INTO gdn_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","E yona denai mo eba wagubu ki pokere apunu Pairasi Iyesu ade sibu, wagubu ke; “Mu rowarowa kawaya kau mena kekeniyamu idiwu ko mu yona tagamu ki kau wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Ko Iyesu yona denai mo eba wagubu, ki pokere apunu kawai ki e notai babawena. ");
INSERT INTO gdn_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Kwamura makeya makeya ‘Mamanuga God Nu Raurunibu Poragai’ poragatagamawa ki kawareya ka tawana Roumi piyaramuguma mu kawaimaga ubupu dibura gudui kwai-pupu manako dibura apunai eyaka mena nima iyapana e si tagamawa ki apunai dibura kamadubu manako pa bauwena kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Karako ka apunu mosi si ka Barabasi ika diburawena tondawa. E si kawayawena kayawena iyapana kuduba wainamupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Iyapana kuduba ika bautagubu dibimupu idiwa ki apunu Pairasi mu emitapu manako e ubupu mu manutapu, wagubu ke; “Wi nuwagau nau karako nima e idai rikapani da e baiyagisi kayayagisi? Nau apunu Barabasi e idai rikapani baiyagisi kayayagisi bo apunu Iyesu si daikere Keriso tagamu ki e idai rikapani bai-yagisi kayayagisi?” ");
INSERT INTO gdn_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Apunu Pairasi yona ki wagubu ki mibai ka e kataiya da Diyu ragidai mu kawakawaimuguma gunaratagubu ki pokere mu Iyesu wadumpu e idai rabineya tamupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Apunu Pairasi e idai gurai iyapana naurimugu ugwaditamana ragiragi ki kemai kawareya tondawa makeya ka e eya wainai bauwena yona mo e bameya tonopupu sibu, wagubu ke; ‘Apunu ki e berokoi mo eba kwaewena ki pokere kamadi. Nau kemorau e waro were empuwani manako e pokaiya ka nau oro naigida eba ukwapuwani.’ E yona inako tonopupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Mamanuga God bameya dobo-piyamu ragidai ade Diyu ragidai mu kawakawaimuguma mete kina ki garugaru mena bautagubu iyapana pakasi ragidai mu rabinamaga kupa-mpu, tagubu ke; “Apunu Pairasi wi ade manuniyoto ki ka wi apunu Barabasi e idai rikapana da bauwagana kayawagana ki nana iwagi ko mu ubumoto apunu Iyesu pa minimana po ki yonai iwagi.” ");
INSERT INTO gdn_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Apunu kawai Pairasi iyapana ade manutapu, wagubu ke; ‘Wi nuwagau nau nima e idai rikapani da e baiyagisi kayayagisi?’ Ko mu denai tagubu ke; ‘Nu nuwanugu kau apunu Barabasi e idai rikapi da e baiyagisi kayayagisi.’ ");
INSERT INTO gdn_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Mu inako tagubu ki pokere apunu Pairasi mu ade manutapu, wagubu ke; “Ko apunu Iyesu si daikere Keriso tagamu ki e bameya ka nau karako badidi kwaesugani?” E yona ki wagubu ka mu kuduba tagubu ke; ‘Ripa korosi naureya mini-muri poyo.’ ");
INSERT INTO gdn_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Mu inako tagubu ki pokere apunu Pairasi mu ade manutapu, wagubu ke; “E poyagisi ki mibai ka badidi? E gwede paere kwaewena?” Ko mu naiya tagubu ki kawareya mu bonanamaga ragiragi kawaya ade tagamawa ke; “Ripa korosi naureya minimuri poyo.” ");
INSERT INTO gdn_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Iyapana inako kawareya kawareya tagamawa ki pokere apunu Pairasi e notai wagubu ke; ‘Iyapana yau nau bonanani eba wadamu ade mu waunitau yawira kwaetagamana kwaetagamu.’ E notai inako wagubu ki pokere e iyapana kuduba yabaramugu waigugu mo kwaewena e idai bigi siruwapupu manako tadebu, wagubu ke; “Apunu yau powagana ki yonai ka wi iwagubu ko eba nau suwagubuwani, ki pokere e poyagisi ki bimbinai ka aita wi wadumuri ko eba nau yadani.” ");
INSERT INTO gdn_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","E inako wagubu, ko iyapana ropani kawaya ki denai tagubu ke; “E poyagisi ki bimbinai nu yadamu ade nu mununuguma mete yadini ki ka baganai, eba gwedei mete kina.’ ");
INSERT INTO gdn_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Iyapana yona ki tagubu waina-pupu ka apunu Pairasi ubupu dibura rabineya tondawa apunai Barabasi e idai kerarai rikapupu tonopupu bau-wena kayawena. Ko e piyara ragidai tadebu da mu Iyesu wikuku pokaiya raukekepamana ki nana wagubu manako ewa ubupu Iyesu wadubu mu idamaga rabineya tapu, wagubu ke; “Wi apunu yau wadumuri ripa korosi naureya minimuri poyo.” ");
INSERT INTO gdn_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Piyara ragidai ki Iyesu wadumpu kawaimaga tawai rabineya kaimpu manako kowamuguma nene tagubu bautagubu ewapuru mena ika dibimupu idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Mu e eya midi tatamai rika-mupu manako midi tatamai daragai bagi kawaya mo wadumpu monaga-mupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mu impunewa tempu e debaiya painimupu ade guna mosi wadumpu e idai garu tampu kwempu manako e yabareya kwarisitagubu mu ramatamaga kawareya ubumupu e waegeyageyamapamawa parau bera-tagamawa siyamawa, tagamawa ke; “Kaiwa kaiwa, Diyu ragidai mu Kaiwawomaga Kawaya.” ");
INSERT INTO gdn_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Mu inako tagubu manako ubumpu Iyesu kiyabuiya tepotepopamawa ade guna idaiya wadubu ki mu wadumpu e debaiya kawareya kawareya minimawa. ");
INSERT INTO gdn_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Mu e inako waegeyageyamapamawa da kamadumpu ka mu midi tatamai daragai bagi kawaya ki ade rikamupu e ebo gwedegwedei ade umamupu kwemupu manako ripa korosi naureya minimana po ki nana wadumpu kaya-tagubu. ");
INSERT INTO gdn_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Piyara ragidai ki Iyesu wadumpu kayatagamawa yamawa ka mu tawana Sairini apunumaga mo si ka Saimoni ika yawatau bananamupu. Mu e Iyesu korosi kawarapana ki nana simupu manako apunu Saimoni ubupu ripa korosi ki kawarapupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Mu Iyesu wadumpu yampu tawana mo si ka ‘Gorogata’ bautagubu ko tawana ki si mibai ka Deba Suwana. ");
INSERT INTO gdn_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ika bautagubu ka mu ripa otai suwakarai mosi wadumpu awana ‘waeni’ mete wiramupu manako awana ki Iyesu kubarana ki nana kwemupu. E awana ki piri munta remopupu ko e eba nuwaiya kubarana wainapupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ki eweya ka mu Iyesu wadumpu ripa korosi naureya ikokomupu manako e midi tatamai rikamupu. Mu yanuwa munta mo mete kwaetagubu da nima si yanuwa ki rabineya yabiri bauwena ki ka e ubupu Iyesu midi tatamai ki e wadubu. ");
INSERT INTO gdn_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Mu inako kwaetagamawa da kewowena ka mu kwarisitagubu e ika empamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Iyesu debaiya ripa korosi naureya ka mu e badidi pokere powagana ki kerarai oka inako tamupu; ‘Yau ka Iyesu, Diyu ragidai mu Kaiwawomaga’. ");
INSERT INTO gdn_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Mu iyapana berokoi apeya mete ripa korosi naureya ikokotampu, mosi ka Iyesu e idai garu deneya ade mosi ka e idai tenene deneya. ");
INSERT INTO gdn_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Iyapana ika esidaeridatagamawa kaiwa kebomawa Iyesu emupu ka mu debamaga gipamawa e waegeyageyama-pamawa siyamawa, tagamawa ke; ");
INSERT INTO gdn_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","‘Kau karako kiri uburi kwaenuwagi. Kau naiya nuwagibi da kau Mamanuga God e Tawai ki koritapana mara apeya eyaka rabineya ade wadana ki nana nuwagibi ki pokere kau Mamanuga God e Gubagai mibai ki kau karako iyanuwagi ripa korosi ki kamadi kawari da nu kau eminiyamu.” ");
INSERT INTO gdn_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Mamanuga God bameya dobopiyamu ragidai, Mamanuga God e gorai kataimugu ragidai, ade Diyu ragidai mu kawakawaimuguma mete kina ki mu bautagubu Iyesu inako mete gwaigwita-pamawa, tagamawa ke; ");
INSERT INTO gdn_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“E iyapana iyatamiyawa ko e eya iyawagana ka badidi pokere e kasiyarai pa mena? E mibai tawana Isiraero ragidai nu Kaiwawonuga ki ka e ebo ripa korosi ki kamadini kaworoto da nu yabunugere e empamu sumapamu. ");
INSERT INTO gdn_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","E wagubu da e Mamanuga God sumapiyau ade wagubu da e ka Mamanuga God e eya Gubagai ki pokere e mibai wagubu ki ka Mamanuga God karako e iyapoto da nu empamu.” ");
INSERT INTO gdn_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Iyapana kawakawai ki inako tagubu ade iyapana berokoi apeya e madanai daikere daikere ikokotampu ki mu mete kina Iyesu inako waegeya-geyamamupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Madega paunau wadawa makeya ka tawana kuduba sisipu umapu, ko ade madega kanibu kekerawagawa napusi apeya eyaka wadawa makeya ka sisipu ki ade negawena. ");
INSERT INTO gdn_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Sisipu ki ade negawagawa makeya ka Iyesu e bonanai ragiragi kawaya wagubu ke; “Eroi, Eroi, rama sabaktani.” Ki mibai ka inako; ‘Mamani God, Mamani God, kau badidi pokere nau kamadisinibi?’ ");
INSERT INTO gdn_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Iyapana dai ika ubumawa e yonai ki wainamupu ka mu tagubu ke; “Wainapumuri, e oragai apunai Eraidiya e wenai siyanau.” ");
INSERT INTO gdn_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Apunu ki mosi dabuwa tenai mo wadubu garupupu awana suwakarai mo rabineya kaupupu manako sikurupupu Iyesu umuneya tapu da e kubarana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ko mu dai tagubu ke; “Kamadi, idiwomu da empomu. Oragai apunai Eraidiya baiyagisi e iyapoto bo?” ");
INSERT INTO gdn_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ko Iyesu e bonanai ragiragi kawaya ade wagubu manako e nonai toporuwena powena. ");
INSERT INTO gdn_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Iyesu powagawa makeya ka aukwara mosi Mamanuga God e Tawai rabineya gudu maba uburawa ki paunau tegerewena esida da erida. Waira nutanuta kawaya mo mete bauwena ade bowa susukwanatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mamanuga God e iyapanaiyoma naiya popotagubu ragidai ki mu dai uruba rabineya ade iyatagubu kimpu ubumpu. ");
INSERT INTO gdn_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Iyesu ade iyawena kipu ubupu eweya ka iyapana popotagubu ade iyatagubu kimpu ubumpu ragidai ki Mamanuga God e naterei Diyerusaremu rabineya matara-tagubu manako iyapana ropani kawaya mu yabumugere emitampu. ");
INSERT INTO gdn_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Piyara ragidai kawaimaga ade e kobaiya idiwa ragidai mete kina ika Iyesu empamawa idiwa ki waira nutanuta ade gwedegwede kuduba wenawena ki mete emupu ka mu notamaga kowena kudu mete waina-mupu manako tagubu ke; “Mibai, apunu yau e ka Mamanuga God e eya Gubagai.” ");
INSERT INTO gdn_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","56","Ridi ropani kawaya ika uwamautau Iyesu empamawa ubumawa mu paunamugu ka ridi Meri Magidarini, apunu Diyemesi yo Diyose mu inamaga si ka Meri, ade apunu Tabadi e wainai. Iyesu naiya tawana Gariri rabineya umawa wadawa ki makeya ka ridi ropani kawaya ki e ewakumapamawa waitapamawa wadamawa tekateka iwa. ");
INSERT INTO gdn_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Kemorawagana kwaewagawa ka purapura apunai mosi si ka Diyosepa ika bauwena. E ka Iyesu ewakuma-piyawa umawa apunai mosi tawana Arimateya were bauwena. ");
INSERT INTO gdn_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","E kaya-wena apunu kawai Pairasi e yabareya ubupu manako Iyesu kwakwarepui wadana ononopana ki nana ki genei wagubu. Apunu Pairasi wagubu da baganai, ");
INSERT INTO gdn_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ki pokere apunu Diyosepa kayawena Iyesu kwakwarepui wadubu kwarisi aukwara waunai mosi pokaiya gerowopupu, ");
INSERT INTO gdn_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","manako wadubu kayawena ragu waunai mosi ki e eya nene gimarapupu ki rabineya tapu. Tapu manako bowa kawaya mosi gwairipupu kanibu ragu umunai ki minibu bodapupu manako kamadubu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ridi Meri Magidarini ade e waretai si ka Meri ki mu ika uwamautau ubumawa manako apunu Diyosepa badidi kwaewena ki kuduba mu yabumugere emupu. ");
INSERT INTO gdn_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Nawaru puruwena aiyata marai ki makeya ka Mamanuga God bameya dobopiyamu ragidai mu kawakawai-muguma ade Parisi ragidai dai mete kina apunu Pairasi bameya kayatagubu, ");
INSERT INTO gdn_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","manako simupu, tagubu ke; “Kawainuga, bera apunai powena e naiya iyaiya tondawa makeya badidi wagubu ki nu notapemei. E inako wagubu ke; ‘Nau posugani ko mara apeya eyaka eweya ki nau ade iyasugani kirani uburani.’ ");
INSERT INTO gdn_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","E inako wagubu ki pokere kau nuwagi da piyara ragidai kayatagisi ragu ki katamurui dagurapomono da mara apeya eyaka kewoyagisi werena. Wi inako eba kwaiwagi ki ka e tadeyawa kabukabuwa ragidai kwaenda kai baitagisi e kwakwarepui ki kuwatagisi kayatagisi manako iyapana beratamini, tagisi ke; ‘E iyawena kipu ubupu.’ Mu inako bera-tagisi ki ka mu yonamaga ki kawaya-yagisi kayayagisi. E naiya eya berawena ki ka maraitau erida ko mu karako ewa inako beratagisi ki ka kawaya esida.” ");
INSERT INTO gdn_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Apunu Pairasi yona ki wainapupu ka e denai wagubu ke; “Baganai, wi piyara ragidai bananatamuri kaiwagi manako wi badidi wainapiyamu ki wi makeya kwaiwogoi ragu ki naigida mena kwayubapiyoi.” ");
INSERT INTO gdn_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","E inako wagubu manako mu kayatagubu iwa da buri bautagubu ka mu ragu katamurui rima umamupu manako ripa otai mo rima ki kawareya pasimupu da iyapana rima ki koritapomoto ki ka mu idamaga kewoi bowa ki naureya tondono ki mu em-pomoto. Mu inako kwaetagubu manako piyara ragidai ki ika dagura ubumana ki nana kamaditampu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Diyu ragidai aiyatamaga marai ki idiwa da kewowena manako ukwampu nawaru dumai tarawa ka ridi Meri Magidarini ade e waretai si ka Meri ki kimpu ubumpu Iyesu kwakwarepui tampu ki ragui empamana ki nana kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Garugaru mena ka waira nutanuta kawaya mo bauwena manako ki makeya ka Mamanuga God e aneyai mosi kunumau kawapu bowa kawaya ragu umunai bodapupu ki gwairipupu ragu madaneya tapu manako yapu bowa ki kawareya tondubu ki mu yabumugere emupu. ");
INSERT INTO gdn_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Aneya ki e kiyabui sinini tanai ka yangwara maba ade e midi tatamai ka poe kawaya midiwari weyaku ki maba. ");
INSERT INTO gdn_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Piyara ragidai ika gopara ubumawa aneya ki emupu ka mu kudu ebotau wainamupu didiguramaga wagubu manako iyapana popai ki maba notamaga gogagogawena. ");
INSERT INTO gdn_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ko aneya ridi ki inako tadebu, wagubu ke; “Wi notaga eba koyogono, kudu eba wainapiyoi. Nau kataineya da ripa korosi naureya minimpu poyo yewe ragu tampu apunai Iyesu e midi kwakwarepui ki wi empamana ki nana baigubu. ");
INSERT INTO gdn_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Ko e yewe eba ukwarau. E naiya nidibu ki makeya makeya e iyawena kipu ubupu kayawena. Mu e tampu watai yau kena ki wi karako kebomuri empumuri. ");
INSERT INTO gdn_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ko karako garugaru mena kaiwagi e tadeyau kabukabuwa ragidai tademuri, iwagi ke; ‘Iyesu iyawena kipu ubupu yabiri kayawena tawana Gariri rabineya wi nawanaga ika tondau ki pokere karako kaiwagi e ika bananapumuri.’ Nau karako nidibuwani ki wi naigida mena wainapumuri.” ");
INSERT INTO gdn_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Aneya yona ki wagubu ka ridi ki garugaru mena ragu kamadumpu Iyesu kowakowaiyoma tademana ki nana mibi didigurai garugarumupu kayatagubu, ko mu mamama mete wainamupu. ");
INSERT INTO gdn_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Ki makeya ka Iyesu garugaru mena bauwena mu yabaramugu ubupu manako parautapu, wagubu ke; “Kaiwa kaiwa.” Mu e yonai ki wainamupu ka mu e yabareya kwarisitagubu ramata-maga kawareya ubumpu e kerareya wadumpu doko manako e si esida tepamupu. ");
INSERT INTO gdn_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ko Iyesu tadebu, wagubu ke; “Kudu eba wainapiyoi ko karako kaiwagi nau kowaniyoma nau sumasiniyamu ragidai ki mu tademuri, iwagi ke; ‘Wi kaiwagi manako tawana Gariri rabineya ika bananasinimuri.’” Iyesu inako tadebu. ");
INSERT INTO gdn_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ridi ki ragu kamadumpu wira-tagubu kayatagamawa ka piyara ragidai ika katamuru dagurapamawa ubumawa ki wiratagubu natere Diyerusaremu kayatagubu manako badidi wenawena mu yabumugere emupu ki sisiyai mu Mamanuga God bameya dobopiyamu ragidai mu kawakawaimuguma tade-mupu. ");
INSERT INTO gdn_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Mamanuga God bameya dobopiyamu ragidai ki yona ki waina-mupu ka mu Diyu ragidai kawakawai-muguma mete dibimupu mu badidi kwaetagamana ki yonai tagamawa kasiwara manako bowa madai kawaya daganani tempu piyara ragidai ki tagempu, ");
INSERT INTO gdn_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","tadempu, tagubu ke; “Wi yona yau mena iyapana tadeyoi, iwogoi ke; ‘Nu kemorau ukwepemeya tetanugu ka e tadeyawa kabukabuwa ragidai bautagubu e midi kwakwarepui ki kuwatagubu kayatagubu.’ Wi inako mena iwogoi, ");
INSERT INTO gdn_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ko wi ukwapamawa sisiyai ki wi kawaiga wainapana manako ki pokaiya bita negeyana ki kudeya ki wi eba wainapiyoi. Yawata ki ka nu mena yadamu supasupa.” ");
INSERT INTO gdn_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Diyu ragidai kawakawaimuguma inako tagubu ki pokere piyara ragidai bowa madai ki temupu manako kawa-kawai ragidai ki mu badidi kwaetaga-mana ki nana tademupu ki mu makeya makeya kwaetagubu. Mu bera yonai iyapana tademupu ki kawayawagawa yabadawa da karako Diyu ragidai inako mete wainapiyamu. ");
INSERT INTO gdn_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu eyaka mena ki kimpu ubumpu tawana Gariri kayatagubu manako kweya mosi ki Iyesu naiya mena kabuwatapu ki ika bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Mu Iyesu emupu ka mu e si tepapamawa ko mu dai notamaga apeya apeya mete wagawa. ");
INSERT INTO gdn_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ko Iyesu mu bamamugu bauwena, manako tadebu, wagubu ke; “Kunuma waira ki kasiyarai kuduba ka nau tegebu wadu-buwani, ");
INSERT INTO gdn_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ki pokere kimuri ubumuri tawana tawana kuduba, madega kauwagau madega posiwagau ki kaiwagi iyapana bani bani idiwu ki tadeyoi iwoi da mu nau ewakuma-sinimono. Mamanuga God e si pokaiya ade e Gubagai nau sini pokaiya ade e eya Keyai Tanai Bagi Kawaya ki e si pokaiya ka wi mu siruwatamiyoi, ");
INSERT INTO gdn_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ade yona kuduba nau nidibuwani ki wi kaiwagi mu tadeyoi kabukabuwa iwoi da nau yona kuduba suwagubuwani ki mu makeya makeya kwaetagamana ki nana. Nau suwagani wainapumuri; Wi inako kwaiwogoi ki ka nau maramara wi mete idiwomu yamomu da mara siyarai ki baiyagisi.” Iyesu inako wagubu. Ika kewowena. ");
INSERT INTO gdn_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Mamanuga God e Gubagai Iyesu Keriso e yonai bagi kawaya ki kerarai ka yau kena. ");
INSERT INTO gdn_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Takari kawaya ka Mamanuga God e bonanai wainapiyawa wagawa apunai Aisaiya Mamanuga God e okai yau tapu, wagubu ke; ‘Nau bibini yabiri kayawagana wagana apunai ki nau yawata yabiyabiri tonopani da e kau yawatagi meyoto taniyagisi. ");
INSERT INTO gdn_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Iyapana eba idiwu tawaneya ka e bonanai ragiragi kawaya inako wagau ke; ‘Kaiwawonuga e yawatai gwaba memuri da e taneya baiyagisi kayayagisi.’ ’ ");
INSERT INTO gdn_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Oragai apunai Aisaiya oka inako tapu ki pokere mara ki bauwena makeya ka apunu Diyoni iyapana eba idiwu tawaneya ubupu iyapana siruwa-tamiyawa dimawagawa, wagawa ke; “Wi beraga berokoi oragai ki wi karako kamadumuri wi notaga wirayagisi da nau uburani wi siruwaniyani manako Mamanuga God e uburoto wi bigiga ki kuduba deni mena surupoto.” ");
INSERT INTO gdn_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","E yona inako wagawa manako tawana Diyudiya ade natere Diyerusaremu ragidai e empamana ki nana kebomupu ika bautagubu. Bautagubu ka mu berokoi badidi kwaetagamawa ki tagubu matara mu idamaga kerapumaga rikapamawa manako apunu Diyoni ubupu mu awana Diyoudani rabineya siruwatapu. ");
INSERT INTO gdn_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Apunu Diyoni e gwedegwedei ka eba bagi. E papa kameru kumai kau-piyawa ade e naurai taburubai ka papa kwakwarai pokaiya yamanamupu ki e umarawa umawa. E bani ka manigowa yo tapoi borepa ki mena kupawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","E dimawagawa iyapana tadeyawa, wagawa ke; “Apunu nau ewaneya baiyagisi e kasiyarai ka kawaya daganani esida ko nau kasiyarani ka maraitau erida. Nau e bigabigai kwaesugana waitapana e kerarai kwakwarai ki rikapana ko nau eba bagi da nau upi ki kwaesugani. ");
INSERT INTO gdn_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Nau awana pokaiya wi siruwaniyakani ko e uburoto Mamanuga God e Keyai Tanai Bagi Kawaya ki pokaiya wi siruwaniyoto.” Apunu Diyoni inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Mara ki makeya ka Iyesu natere Nasareta tawana Diyudiya rabineya ki kamadubu kayawena yabadawa da apunu Diyoni bameya bauwena manako Diyoni ubupu Iyesu wadubu awana Diyoudani rabineya siruwapupu. ");
INSERT INTO gdn_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Iyesu awana rabineya supu ade matarau posiwagawa makeya ka e kunuma yagarawena empupu manako Mamanuga God e Keyai Tanai Bagi Kawaya ki midiwari umago maba kawapu e kawareya tondubu, ");
INSERT INTO gdn_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","manako bonana mosi kunumau kawapu ki wagubu ke; “Kau ka nau Gubagani. Nau nuwaneya po kau ki pokere nau karako kau mamamagi suwagakani.” Bonana ki inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ki makeya, garugaru mena, ka Mamanuga God e Keyai Tanai Bagi Kawaya bauwena Iyesu sibu yabiripupu da e iyapana eba idiwu tawaneya ki kayawagana ki nana, ");
INSERT INTO gdn_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ki pokere e kipu ubupu manako tawana ki kayawena mara apunai apeya (40) rabineya e eya mena ika umawa wadawa. Ko Berokoi Apunai Seitani maramara e bameya bauwagawa e beraberapiyawa ade e rabinai kupawa. Papa kamarai ika mete idiwa ko Mamanuga God e aneyaiyoma bautagubu Iyesu kwayubapamawa. ");
INSERT INTO gdn_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Iyapana apunu Diyoni wadumpu diburamupu eweya ka Iyesu tawana Gariri rabineya bauwena Mamanuga God e yonai bagi kawaya ki dimai wagawa iyapana tadeyawa, wagawa ke; ");
INSERT INTO gdn_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","“Mara wana bauwena. Iyapana ubumana nau Mamai God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki marai wana bauwagana kwaewagau. Ki pokere wi beraga berokoi ki wi karako kamadumuri wi notaga wirayagisi manako yona bagi kawaya yau mena wainapumuri sumapumuri.” E inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Mara ki makeya ka Iyesu kaburu Gariri papateya kaniyawa da apunu Saimoni e yowai Enduru mete kina raubiyo nene kaburu kawaya ki papateya ika puwaritagamawa idiwa emitapu. Mu ka kimai wasisinai ragidai bowa madai wadamana ki nana ika ebogatagamawa. ");
INSERT INTO gdn_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ko Iyesu mu emitapu manako tadebu, wagubu ke; “Kebomuri nau ewaneya ubumuri. Wi karako raubiyo tepiyamu iwu ki maba nau wi kabuwaniyani da wi kaiwagi iyapana nene iwagi tetamuri.” ");
INSERT INTO gdn_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Iyesu yona ki wagubu wainamupu ka mu garugaru mena puwarimaga tampu kamadumpu manako kimpu ubumpu e eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Mu kayatagubu kaburu papateya kebomawa da apunu Tabadi e gubagai-yoma Diyemesi yo Diyoni mete kina ika wakamaga rabineya puwarimaga badipamawa idiwa emitampu. ");
INSERT INTO gdn_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Iyesu garugaru mena apunu Diyemesi yo Diyoni mu nene wagubu manako mu kimpu ubumpu mu mamamaga Tabadi e kowakowaiyoma mete kina ika waka rabineya kamaditampu manako sumpu deni mena Iyesu eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Mu kayatagubu kaiwa da natere Kaponiyamu bautagubu ka mu ika idiwa da aiyata marai ki makeya ka mu guriguri tawai ki rabineya yamupu manako Iyesu ika dimawagawa iyapana tadeyawa kabukabuwa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ko iyapana ika idiwa e yonai ki waina-mupu ka mu notamaga kowena kodaba-maga kamupu mibai ka Iyesu e yonai ki kasiyarai ka kawaya ko iyapana kawakawai Mamanuga God e gorai kataimugu ragidai ki mu yonamaga ka kasiyarai pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Iyesu ika dimawagawa tondawa manako ki makeya ka keyai berokoi apunu mosi rabineya tondawa ki ika bauwena Iyesu empupu manako e bonanai ragiragi kawaya Iyesu sibu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Iyesu, tawana Nasareta apunai, kau nuwageya gwede nu bamanugu berapana ki nana? Kau nu giriniyana ki nana baunugibi bo? Nau kataineya kau. Kau ka Mamanuga God e umunui wadei apunai bagi kawaya.” ");
INSERT INTO gdn_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ko Iyesu wirawena keyai berokoi apunu ki rabineya tondawa ki empupu manako e bonanai ragiragi kawaya siwakekepupu sibu, wagubu ke; “Kau kererenuwagi apunu yau kamadi baunuwagi matarau kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","E yona ki wagubu makeya ka keyai berokoi ki apunu ki ragiragi kawaya wadubu kwisikwisipupu manako e kwewena bauwena kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Ko iyapana kuduba Iyesu badidi kwaewena emupu ka mu notamaga kowena mu mubo mubo kowamuguma mete manu kasiwaratagamawa, tagamawa ke; “Yau ka badidi? Yau ka kabuwa waunai mosi bo? Apunu yau e kasiyarai ka kawaya esida. E keyai berokoi siwakeketamiyau wagau ki ka mu e bonanai wadamu bautagamu kayatagamu.” Iyapana inako tagubu, ");
INSERT INTO gdn_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","manako Iyesu badidi kwaewena ki sisiyai garugaru mena tawana Gariri rabineya kawayawena kayawena iyapana kuduba wainamupu. ");
INSERT INTO gdn_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Iyesu kipu ubupu e tadeyau kabukabuwa ragidai ade apunu Diyemesi yo Diyoni mete kina waratapu guriguri tawai ki kamadumpu manako kaimpu apunu Saimoni yo Enduru mu tawamugu yamupu. ");
INSERT INTO gdn_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Tawa ki rabineya ka apunu Saimoni e memenagui ridai muyamuyawena ika ukwarawa ki sisiyai mu Iyesu simupu, ");
INSERT INTO gdn_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","manako e kanibu ridi ki waitapupu e idaiya wadubu kipu ubupu. Ridi ki kirawa uburawa makeya ka e sigirai ki garugaru mena kewo-wena manako e kanibu mu diriwamaga kwaewena bani warapupu tagebu. ");
INSERT INTO gdn_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Madega kanibu supu kemora-wagawa ka iyapana dai kayatagubu sigira ragidai ade keyai berokoi mu rabinamugu idiwa ragidai inako tetampu Iyesu bameya bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Natere ki ragidai kuduba ika bautagubu tawa ki ureya ubumawa, ");
INSERT INTO gdn_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","manako Iyesu ubupu iyapana sigiramaga ebo ebo ki iyatamiyawa ade keyai berokoi mu dai rabinamugu idiwa ki mete siwakeke-tamiyawa bautagamawa kayataga-mawa. Keyai berokoi ki kuduba katai-mugu da Iyesu ka nima ko mu yona ki matarau eba tagamana ki nana ka e mu tatamatapu. ");
INSERT INTO gdn_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Mu ukwapamawa da nawaru dumai tarawa ka Iyesu kipu ubupu iyapana yabumaga sipeya tawa ki kamadubu kanibu e ebo mena gari tagaiya e Mamai bameya guriguri-wagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Ko apunu Saimoni e kowaiyoma mete kina Iyesu kwaenei kayatagubu kwaenepamawa iwa da bananamupu, ");
INSERT INTO gdn_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","manako simupu, tagubu ke; “Natere yau ragidai kuduba kau kwaeneniyamu.” ");
INSERT INTO gdn_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ko Iyesu denai tadebu, wagubu ke; “Nau Mamai e yonai iyapana kuduba tadeyana ki nana nau tono-sinibu bausugubuwani ki pokere nu yewe mena eba idiwomu ko tawana tawana mete kaigamu da nau ika mete dimasugoni umoni.” ");
INSERT INTO gdn_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Iyesu inako wagubu manako tawana Gariri rabineya tawa tawa umawa wadawa ade Diyu ragidai mu gurigurimaga tawai rabineya mete kina Mamanuga God e yonai wagawa umawa. E keyai berokoi dai mete siwakeketamiyawa bautagamawa kayatagamawa. ");
INSERT INTO gdn_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Apunu mosi sigira berokoi mo wadubu e kwakwarepui kwatakwata-wena ki Iyesu bameya bauwena parau-pupu e yabareya kwarisiwena e ramatai kawareya ubupu manako genepupu sibu, wagubu ke; “Kau kaubo nuwageya nau nene wainapiyei ki kau wadisini bagi.” ");
INSERT INTO gdn_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Iyesu apunu ki e nuwaboyai wainapupu ki pokere e idai roronapupu sigira apunai ki e mideya tapu manako sibu, wagubu ke; “Nau nuwaneya kau iya negeyani ki pokere kau sigiragi nau karako surupakani da deni mena kewoyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Iyesu yona ki wagawa makeya ka apunu ki e sigirai garugaru mena kewowena e midai wateya wateya bauwena manako e iyawena. ");
INSERT INTO gdn_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ko Iyesu apunu ki tatamapupu sibu tonopupu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Nau karako iyanibuwani ki sisiyai kau iyapana eba tade ko kau deni mena Mamanuga God bameya dobopiyamu ragidai mu bamamugu kayanuwagi da mu kau eminimoto manako ade kau sigiragi kewowena ki mu mete em-pomoto manako ewa kayanuwagi oragai apunai Mosisi gora tapu ki makeya makeya kwaenuwagi papa kumerekumere Mamanuga God bameya puyo tari. Kau inako kwaenuwagi ki ka iyapana kawakawai ki kau eminimoto manako mibipomoto da kau sigiragi wana kewowena.” ");
INSERT INTO gdn_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","E inako sibu ko apunu ki e umunui eba wadubu ko e kayawena Iyesu e badidi maba iyapupu ki sisiyai tawa tawa wagawa umawa ki pokere Iyesu tawana tawana matarau eba umawa ko e gari tagaiya wekei gwaiya mena umawa. Ko iyapana ropani kawaya tawana tawana maramara e bameya bautagamawa. ");
INSERT INTO gdn_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Mara dai kewowena eweya ka Iyesu ade wirawena natere Kaponiyamu e ebo tawaneya bauwena manako e bauwena sisiyai kawayawena kayawena iyapana ropani kawaya wainamupu e empamana ki nana diriwai bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Bautagubu ka tawa rabineya, katamuru ade imatau iyapana posiwena tawa rabineya yamana watai mo pa mena. Iyesu tawa rabineya kabuwagawa tondawa ki makeya, ");
INSERT INTO gdn_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ka iyapana apeya apeya mu waretamaga e idai kerarai badabadamawena bisi kayawena ki gagara umampu rabineya kaumpu ki kerorampu ika bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Mu nuwa-mugu apunu ki wadamana Iyesu bameya yamana ki nana ko tawa rabineya iyapana posiwena ki pokere mu apunu ki mibi gagarai wadumpu tawa tagaiya yampu manako Iyesu tondawa kawareya tawa tagai wadu-mpu bebere apunu ki mibi gagarai taburuba pokaiya kwimpu kaumpu Iyesu rabineya supu. ");
INSERT INTO gdn_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Mu sumamaga kawaya daganani Iyesu bameya ki e empupu ki pokere e sigira apunai ki sibu, wagubu ke; “Gubagani, kau beragi berokoi ki nau empuwani da karako surupakani.” ");
INSERT INTO gdn_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Iyesu yona ki wagubu ka iyapana kawakawai Mamanuga God e gorai kataimugu ragidai ika idiwa waina-mupu manako mu notamaga wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“E ka badidi pokere inako wagau? Mamanuga God e mena nu beranuga berokoi ki empiyau surupiyau. Apunu yau ka berawagau Mamanuga God e si giripiyau ade e eya si tepapiyau wainapemei.” ");
INSERT INTO gdn_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Mu inako notapamawa, ko Iyesu mu notamaga ki e garugaru mena empupu manako manutapu, wagubu ke; “Wi karako gwede nana sidiyamu da nau Mamanuga God e si giripakani? ");
INSERT INTO gdn_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Nau e bigi surupana suwagubuwani ko wi bera umani nau sidimupu mibai ka wi wainapiyamu da ki ka pa yona da muyai pa mena. Ko nau karako yona ade mosi suwagani manako wi nau matakirani muyai kawaya empumuri. ");
INSERT INTO gdn_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Nau Kunumau Kawapuwani Apunai iyapana beramaga berokoi empana surupana ki kasiyarai wadubuwani kawapuwani ki wi karako nau mibisinimuri.” E inako wagubu, manako wirawena sigira apunai ki sibu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Nau suwagani wainapi; Kau kiri uburi gagaragi wadi kawarapi kau tawageya kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Iyesu yona ki wagubu makeya ka apunu ki kipu ubupu iyapana yabu-mugu e gagarai wadubu kawarapupu manako garugaru mena bauwena kayawena. Iyapana ika idiwa matakira ki emupu ka mu notamaga kowena kodabamaga kamupu manako Mamanuga God si tepamupu, tagubu ke; “Nu naiya inako mo eba emipi.” ");
INSERT INTO gdn_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Iyesu ade wirawena kayawena kaburu Gariri papateya bauwena ka iyapana ropani kawaya e bameya bautagubu manako e ubupu dima-wagawa Mamanuga God e yonai mu tadeyawa kabukabuwa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","E tadeyawa kabukabuwa tondawa da kamadubu ade kayawena kaniyawa ka e apunu Aropiya e gubagai si ka Riwai ika empupu. Apunu Riwai e ka tawana ki mu wairamaga denai ‘takesi’ wadawa ki apunai mosi ika ‘takesi’ wateya tondawa. Ko Iyesu apunu Riwai empupu manako sibu, wagubu ke; “Kau karako yabi nau ewaneya uburi.” E inako wagubu manako apunu Riwai kipu ubupu e eweya kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Ki eweya ka Iyesu e tadeyau kabukabuwa ragidai mete kina apunu Riwai e tawai rabineya kupetagamawa idiwa. Iyapana ‘takesi’ wadamawa ragidai ade beramaga eba bagi ki pokere iyapana mu tagararatampu ragidai ropani kawaya mete kina Iyesu ewakumapamawa iwa manako mu dai e mete ika kupetagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Parisi Mamanuga God e gorai kataimugu ragidai iyapana ki Iyesu mete kupe-tagamawa idiwa emitampu ka mu ubumpu Iyesu tadeyau kabukabuwa ragidai tademupu, tagubu ke; “E badidi pokere bera berokoi kwaetagamu ragidai ki mu mete ewapuru kupe-tagamu idiwu?” ");
INSERT INTO gdn_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Iyesu mu yonamaga ki wainapupu ka e denai tadebu, wagubu ke; “Sigira ragidai ki mu mena ka muramura apunai bameya kayatagisi, ko midimaga bagi ragidai ki mu ka muramura apunai ki e bameya asusu eba kayatagisi. Nau ka eba iyapana bagi supasupai ki mu nene bausugubuwani ko iyapana berokoi bigibigi ki tadeyana da mu nau bamaneya kebomana ki nana nau bausugubuwani. ");
INSERT INTO gdn_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Mara mosi ka iyapana siruwa-tamiyawa apunai Diyoni e tadeyau kabukabuwa ragidai ade Parisi ragidai dai mete kina gora pokaiya Mamanuga God nene bani kamadumpu idiwa, manako iyapana dai Iyesu bameya bautagubu e manumupu, tagubu ke; “Apunu Diyoni e tadeyau kabukabuwa ragidai ade Parisi ragidai mu tadeyamu kabukabuwa ragidai mete kina ki mu kuduba ka Mamanuga God nene bani kamadumpu idiwu ko kau tadeyei kabukabuwa ragidai ki mu ka badidi pokere inako eba kwaetagamu?” ");
INSERT INTO gdn_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Iyapana ki inako tagubu ko Iyesu denai waigugu were tadebu, wagubu ke; “Anika waunai kupei ki kawareya ka apunu ewai ade ridi ewai bani eba kupomoto ko pa idiwono bo? Ae, pa mena. Bananatamini kupe ki kawareya baitagisi ki ka mu eba nuwaboya nene idiwono ko anika waunai ki mete kupetogomono idiwono. ");
INSERT INTO gdn_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Ko mara baiyagisi da iyapana ubumoto anika waunai apunai ki yadini dokodoko kayatagisi. Mara ki makeya ka e kowai-yoma nuwaboyatagisi bani kamadini.” ");
INSERT INTO gdn_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Iyapana nota oragai ade nota waunai ki eba dibipamana ki nana ka Iyesu waigugu were ade tadebu, wagubu ke; “Gwedegwede oragai mo tegereyagisi ki ka wi dabuwa tenai oragai mo wadumuri ki naureya tamuri popopumuri. Ko wi dabuwa tenai waunai mo wadumuri tamuri popopu-muri ki ka dabuwa tenai waunai ki ewa kaporopoto manako gwedegwede oragai ki wi popomupu wateya purupuruyagisi. ");
INSERT INTO gdn_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Ade keyakeyai mosi ka yau kena; Awana ‘waeni’ waunai ki wi awana kororai papa kwakwarai waunai pokaiya yamanamupu ki rabineya gwepumuri. Awana kororai ki ka nenanenaitau ki pokere awana ‘waeni’ ebo totoripoto kawayayagisi ki ka kororai ki mete kawayayagisi. Ko wi awana ‘waeni’ waunai ki awana kororai oragai kakokakowena rabineya gwepu-muri ki ka awana ‘waeni’ waunai ki totoripoto kawayayagisi ko awana kororai ki ka kakokakoi ki pokere wateya mena tondono da baurayagisi manako awana ‘waeni’ ki mete baiyagisi kayayagisi.” Iyesu waigugu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aiyata marai ki makeya ka Iyesu e tadeyau kabukabuwa ragidai mete kina tawana mo kayatagubu manako yawatau kokora mo kawareya bau-tagubu. Bautagubu ka Iyesu e tadeyau kabukabuwa ragidai gwaba maba mosi ki madai kupemei kena ki asusu toporu-pamawa tepamawa kaiwa. ");
INSERT INTO gdn_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Parisi ragidai mu emitampu ka mu bautagubu Iyesu simupu, tagubu ke; “Kau kowa-kowagiyoma buri emitami. Nu aiyata-nuga marai mu inako kwaetagamu ki ka mu nu goranuga ki giripiyamu.” ");
INSERT INTO gdn_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Mu inako tagubu, ko Iyesu denai tadebu, wagubu ke; “Takari kawaya oragai apunai Dewida badidi kwaewena ki bususui mu oka tampu ki wi iyaba-mupu kataigubu bo pa mena? E kowakowaiyoma mete kina wetei metapu, ");
INSERT INTO gdn_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","manako e Mamanuga God e Tawai rabineya yapu bani buredi ki iyapana Mamanuga God nene puyo ika nakamupu ki dai e tepupu kubabu. Mara ki makeya ka apunu Abayata Mamanuga God bameya dobopiyamu ragidai mu kawaimaga tondawa. Oragai apunai Mosisi nu goranuga tapu da bani ki kena ka Mamanuga God bameya dobopiyamu ragidai ki mu mena ku-pomoto ko apunu Dewida e ka bani ki dai tepupu kubabu ade dai e kowakowai-yoma mete tagebu kupamupu.” ");
INSERT INTO gdn_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Iyesu inako wagubu manako siyareya ka e mu ade tadebu, wagubu ke; “Mamanuga God e ubupu aiyata marai ki iyapana kuduba nu baginuga nene tapu ko eba nu aiyata marai ki si tepapamana ki nana nakanibu. ");
INSERT INTO gdn_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Kunumau Kawapu Apunai e ka aiyata marai ki debai. E ka kawaya esida ko aiyata marai ki ka e kobaiya.” ");
INSERT INTO gdn_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ki eweya ka Iyesu wirawena guriguri tawai ki ade kayawena manako tawa ki rabineya ka e apunu mosi e idai daikere kiyokiyowena bisi kayawena ika tondawa empupu. ");
INSERT INTO gdn_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ko mara ki ka aiyata marai ki pokere iyapana dai Iyesu naigida mena empamana da e gwede mo paerepana manako mu ki pokaiya e siyamana wirawira ki nana ika bautagubu. E apunu idai kiyokiyoi ki aiyata marai ki iyapoto bo pa mena? Mu inako nota-pamawa. ");
INSERT INTO gdn_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Ko Iyesu apunu ki sibu, wagubu ke; “Kau yabi yewe iyapana yabaramugu uburi.” ");
INSERT INTO gdn_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","E inako wagubu, manako wirawena iyapana ika idiwa ki tadebu, wagubu ke; “Aiyata marai ki ka nu bagi kwaigomu bo berokoi kwaigomu? Ade nu iyapana iyatamomu bo giritamomu? Nu goranuga ki nene badidi wagau?” Ko iyapana ki denai mo eba tagubu. ");
INSERT INTO gdn_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Iyesu mu emitapu manako e rabinai berokowena. Ko e mu nuwaboyamaga mete wainapupu mibai ka mu tagamawa mama ade mu rabina-maga ka ragiragi kawaya. Ko e idai kiyokiyoi apunai ki empupu manako sibu, wagubu ke; “Kau idagi roronapi.” E idai roronapupu makeya ka e idai ki garugaru mena supasupawena. ");
INSERT INTO gdn_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Parisi ragidai Iyesu kwaewena ki emupu ka mu garugaru mena tawa ki kamadumpu bautagubu kayatagubu manako apunu Erodi e kowaiyoma mete dibimupu Iyesu minimana po ki yanuwei teyamawa. ");
INSERT INTO gdn_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Iyesu e tadeyau kabukabuwa ragidai mete kina kaburu kawaya si Gariri tagamu ki papateya kayatagubu, manako iyapana ropani kawaya mu ewakumatampu. Iyapana ki mu ka tawana Gariri yo tawana Diyudiya ki ragidai. ");
INSERT INTO gdn_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Mu dai ka tawana Idumeya yo natere kawaya Diyerusaremu were bautagubu ade mu dai ka awana Diyoudani papasi buridere ade natere Saidoni yo Taya ki deneya bautagubu. Mu kuduba ka Iyesu e badidi kwaewena ki sisiyai wainamupu ki pokere mu karako e empamana ki nana ika bau-tagubu. ");
INSERT INTO gdn_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Iyapana ropani kawaya inako bautagubu tawana kuduba posiwena ki pokere Iyesu ubupu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Waka mo wadumuri da nau waka rabineya tondoni mibai ka iyapana yau kuduba nau tatarasiniyamu kapisinimana kwaetagamu.” ");
INSERT INTO gdn_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Iyesu sigira ragidai ropani kawaya iyatapu ki pokere sigira ragidai ade dai bautagubu mu kowamuguma tataratamawa mibai ka mu nuwamugu ka garugaru mena Iyesu bameya bautagamana da e mu iyatamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Iyapana rabina-mugu keyai berokoi idiwa ki mu mete ika bautagubu manako mu Iyesu emupu ki ka mu e yabareya gwaigwiritagubu bonanamaga ragiragi kawaya e simupu, tagubu ke; “Kau ka Mamanuga God e Gubagai.” ");
INSERT INTO gdn_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ko Iyesu keyai berokoi ki tatamatapu ragiragi kawaya tadebu, wagubu ke; “Nau ka nima ki sisiyai wi iyapana eba tadeyoi.” ");
INSERT INTO gdn_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Iyesu kwaunai mo yapu posiwena manako e ebo nuwaiya iyapanai ki mu nene wagubu e bameya bautagubu, ");
INSERT INTO gdn_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","manako apunu ida esida kewowena kerapu apeya (12) winetapu tadebu, wagubu ke; “Wi ka nau tononiyana ragidai. Nau yonani nidiyani ki wi wainapiyoi mete iwomu manako nau kasiyara negeyani were ewa ka wi kaiwagi nau yonani ki dimaiwogoi iwoi, ");
INSERT INTO gdn_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ade keyai berokoi iyapana dai mu rabinamugu idiwu ki wi mete siwakeketamiyoi.” ");
INSERT INTO gdn_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iyesu e winetapu ragidai ida esida kewowena kerapu apeya mu simaga ka yau kena; Saimoni si daikere Pita sibu; ");
INSERT INTO gdn_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","apunu Tabadi e gubagaiyoma Diyemesi yo Diyoni simaga waunai Bowanagesi tadebu (Simaga Bowanagesi ki mibai ka gaiya). ");
INSERT INTO gdn_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Ade iyapana dai simaga ka; Enduru yo Piripo yo Batoromaiya yo Mateyu yo Tomasi, ade apunu Arapiyasi e gubagai si ka Diyemesi. Ade dai ka apunu Tadeyasi yo apunu Saimoni mosi. Apunu Saimoni e ka iyapana wairamaga gwandagi wagau ki apunai. ");
INSERT INTO gdn_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Ko siyarai ka apunu Diyudiyasi si daikere ka Isikariyoto. E ka Iyesu e yogoi ewa wagubu ki apunai. ");
INSERT INTO gdn_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ki eweya ka Iyesu ade wirawena e tondawa tawaiya kayawena ko iyapana ropani kawaya e ewakumamupu mete kayatagubu. E tadeyau kabukabuwa ragidai mete kina bani kupetagamana kwaetagamawa ko mu kupetagamana yawatai mo pa mena mibai ka iyapana ropani kawaya ika bautagubu mu kwagaratampu idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Iyesu inai ade e eya yowaiyoma sisya ki wainamupu ka mu kimpu ubumpu e bananapamana tawamugu tamana ki nana, mibai ka mu wainamupu da e yabarai babawena. ");
INSERT INTO gdn_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Mamanuga God e gorai kataimugu ragidai natere Diyerusaremu were bautagubu ki Iyesu badidi kwaewena emupu ki ka mu e wereyakauramupu, tagubu ke; “Keyai berokoi mu kawai-maga Besaboro e rabineya tawawena tondau kasiyara kweyau manako kasiyara ki pokaiya ka e keyai berokoi kuduba siwakeketamiyau.” ");
INSERT INTO gdn_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Mu inako tagubu ko Iyesu mu nene wagubu e bameya bautagubu manako e waigugu were mu tadebu, wagubu ke; “Berokoi Apunai Seitani e ka badidi maba uburoto ade e eya siwakekeyagisi? Ki pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Tawana mosi ki ragidai nuwarara tagarara kande kasiwaratogomono idiwono ki ka mu purupurutagisi mu mubo mubo kayatagisi manako mu tawanamaga ki gumoroyagisi gwaba umoroto. ");
INSERT INTO gdn_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Ade iyapana tawa eyaka mena rabineya ewa nauwa idiwono ki ka mu iyamaga giriyagisi mu mubo mubo kayatagisi. ");
INSERT INTO gdn_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ki maba, Berokoi Apunai Seitani e ebo kowaiyoma mete purupomoto kande kasiwaratagisi ki ka e kasiyarai garugaru mena kewoyagisi. ");
INSERT INTO gdn_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Iyapana nima nuwaiya ka apunu kasiyarai mosi e tawai baupana e gwedegwedei kuwawagana wainapiyau ki ka e yabiri kasiyara apunai ki yadini e idai kerarai umoroto doko-doko taroto manako ewa tawa ki yaroto apunu ki e gwedegwedei kuwayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Iyesu inako wagubu, ade wagubu ke; “Nau suwagani wainapumuri; Iyapana berokoi badidi kwaetagubu bo tagubu ki kuduba ka Mamanuga God empoto deni mena surupoto nota-gogapoto. ");
INSERT INTO gdn_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ko iyapana nima Mama-nuga God e eya Keyai Tanai Bagi Kawaya ki siyoto siyasiya ki e paerei ka Mamanuga God eba empoto surupoto ko e bigi ki maramara tondono kaniyono.” ");
INSERT INTO gdn_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Iyesu yona ki wagubu mibai ka iyapana dai e simupu, tagubu ke; ‘Keyai berokoi mosi e rabineya tawawena tondau.’ ");
INSERT INTO gdn_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ki makeya ka Iyesu inai ade e eya yowaiyoma mete kina ika bautagubu. Mu tawa ki rabineya eba yamupu ko ika tawa ureya ubumawa Iyesu mu bama-mugu kawarana ki nana ki yonai mena tawa rabineya tonomupu. ");
INSERT INTO gdn_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Iyapana ropani kawaya Iyesu kwagaramupu ika idiwa yona ki wainamupu ka mu Iyesu simupu, tagubu ke; “Kau inagi ade kau kiya yowagiyoma mete kina bautagubu kau nene tagamu.” ");
INSERT INTO gdn_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ko Iyesu denai tadebu, wagubu ke; “Nau inai ka nima? Nau yowani-yoma ka gwedewau?” ");
INSERT INTO gdn_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","E inako wagubu manako wirawena iyapana ika kwagaramupu idiwa ki kuduba emitapu, tadebu, wagubu ke; “Nau kwagara-siniyamu mete idiwei ragidai wi kuduba ka nau yowaniyoma ade nau inaniyoma. ");
INSERT INTO gdn_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Iyapana gwedewau nau Mamai God e badidi wagau ki wainapiyamu makeya makeya kwaetagamu ragidai ki mu ka mibai nau yowaniyoma, nau egapuni-yoma, ade nau inaniyoma.” ");
INSERT INTO gdn_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Mara mosi ka Iyesu kaburu Gariri papateya iyapana ade tadeyawa kabukabuwa tondawa. Iyapana ropani kawaya eba bigabigai bautagubu e yonai wainapamana ki nana e kwagara-mupu idiwa ki pokere Iyesu waka mosi ika kaburu papateya uburawa ki kawareya yapu tondawa ko iyapana kuduba ka kaburu ki papateya wairau idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","E yona marai kawai kuduba waigugu were tadeyawa manako paunau ka e inako wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Nau yona yau suwagani wainapu-muri; Apunu mosi e momai dai urana ki nana kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","E momai ki urawa umawa da momai dai kerapu dabireya gwegwetagubu manako midiwari garugaru mena bautagubu momai ki kupampu gawarara. ");
INSERT INTO gdn_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Momai dai ka e yaroyaro kawareya upu manako momai ki garugaru mena ugwadubu susukwana. Ko waira ki ka eba kawaya, ");
INSERT INTO gdn_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ki pokere madega ubupu urabu ki ka momai ki garugaru mena suratagubu mibai ka witai waira rabineya eba supu. ");
INSERT INTO gdn_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ade momai dai ka gwabau gaya kakapareya gwegwetagubu wenatagubu ko gwaba ubupu niniuraurapupu ki pokere wenatagubu ko mibai eba kipu. ");
INSERT INTO gdn_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Ko momai dai ka e waira bageya upu manako ugwede susukwanapupu wenatagubu kawakawayatagubu mibai kipu. Dai ka mibai apunai eyaka mena ida esida mena (30) kipu, dai ka mibai apunai apeya eyaka (60) kipu, ade dai ka mibai apunai ida daikere mena (100) inako kipu. ");
INSERT INTO gdn_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Wi wenaguga mete kina ki ka wi nau yonani yau suwagubuwani ki mibai naigida mena wainapumuri.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Ki eweya Iyesu e tadeyau kabu-kabuwa ragidai ida esida kewowena kerapu apeya (12) ade e ewakumapa-mawa ragidai mete kina mu muga mena e mete ika idiwa ki makeya ka mu e manupupu, tagubu ke; “Kau yona waigugu were nuwagibi ki mibai ka badidi?” ");
INSERT INTO gdn_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Mu inako tagubu ko Iyesu denai tadebu, wagubu ke; “Wi Mamanuga God e gari rabineya idiwana ki yonai wekewekei ki mibai kuduba nau matarau wi nidiyakani ko iyapana gwedewau gari ki tagaiya idiwu ragidai ki ka nau waigugu mena pokaiya mu tadeyakani, ");
INSERT INTO gdn_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","da mu; ‘Yabutamono, yabutamono ko mibai eba empomoto. Wainapomono wainapomono ko mibai eba waina-pomoto. Mu wainampena ki ka mu notamaga wirawagubena Mamanuga God bameya manako e mu bigimaga ki empena surupena mu tagamugu kwenupena.’” ");
INSERT INTO gdn_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Iyesu inako wagubu, manako manutapu, wagubu ke; “Nau momai upu ki waigugui suwagubuwani ki ka eba waigugu wekewekei. Wi waigugu ki mibai eba wainamupu ki ka wi badidi maba waigugu were ewa suwagani ki mibai wainapumuri? ");
INSERT INTO gdn_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Waigugu suwagubuwani ki mibai ka yau kena; Momai urau apunai ki e ka Mamanuga God e yonai wagau apunai. ");
INSERT INTO gdn_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Mara mosi ka momai upu ki kerapu dabireya gwegwetagubu ko ki mibai ka yau kena; Iyapana dai Mamanuga God e yonai wainapomoto ko Berokoi Apunai Seitani garugaru mena baiyagisi yona waina-mupu ki surupoto. ");
INSERT INTO gdn_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Momai yaroyaro kawareya gwegwetagubu ki mibai ka yau kena; Iyapana dai Mamanuga God e yonai wainapomoto mamamatagisi, ");
INSERT INTO gdn_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ko yona ki mibai mu rabinamugu eba supu tawawena ki pokere mu yona ki pokaiya berokoi mosi bananapomoto bo iyapana dai baitagisi mu giritamini pasutamini ki ka mu Mamanuga God e yonai ki garugaru mena notagoga-pomoto. ");
INSERT INTO gdn_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ade momai gwabau gaya kakapareya gwegwetagubu ki mibai ka yau kena; Iyapana dai Mamanuga God e yonai wainapomoto, ");
INSERT INTO gdn_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ko mu mubo mubo iyamaga nene mena notapomono ade waira yau purapurai empomono yabumaga midiyayogono. Mu notamaga ka ki mena kawareya ukworono manako nota ki uburoto Mamanuga God e yonai badidi wainamupu ki utapoto da mu mibimaga mo eba kiroto. ");
INSERT INTO gdn_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ko iyapana dai ka e momai waira bageya upu ki maba. Mu ka Mamanuga God e yonai wainapomoto sumapomoto manako mu mibimaga mete kiroto. Dai ka mu mibimaga apunai eyaka mena ade ida esida mena (30) kiroto, dai ka mu mibimaga apunai apeya eyaka (60) kiroto, ade dai ka mu mibimaga apunai ida daikere mena (100) kiroto.” ");
INSERT INTO gdn_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Iyesu inako wagubu ade tadebu, wagubu ke; “Apunu mosi duna beupoto ki ka e duna ki bani taroto? E digumau taroto bo kurari umuneya wekepoto bo? Ae, e duna ki matarau taroto da tanai tawa rabineya miniyoto siwa. ");
INSERT INTO gdn_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Ki maba, wi weki gwaiya badidi kwaiwagamu ki ka ewa marai mosi matarayagisi. Ade wi gwede mosi utapiyamu ki utai ka ewa marai mosi wakayagisi matarayagisi. ");
INSERT INTO gdn_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ki pokere wi wenaguga mete kina ki ka wi nau yonani suwagubuwani yau ki mibai naigida mena wainapumuri wetawetara. ");
INSERT INTO gdn_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Wi yona badidi maba wainapu-muri ki wi naigida mena notapumuri wainapumuri. Wi kawareya kawareya inako wainapiyoi yamoi ki ka wi mibai wainapumuri ade mibai ki kawareya mete wainapumuri. ");
INSERT INTO gdn_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Iyapana nima Mamanuga God e yonai mibai waina-pupu wadubu doko ki ka e yona waunai mosi ade wainapoto yadini. Ko iyapana nima yona ki eba wainapupu wadubu doko ki ka e ewa mo eba yadini ade marai munta wainapupu ki mete gogayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Iyesu inako wagubu ade tadebu, wagubu ke; “Mamanuga God e gari rabineya idiwana kaiwana ki waigugui mosi ka yau kena; Iyapana mosi momai dai uroto kamadini, ");
INSERT INTO gdn_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","manako e tawaiya kayayagisi ukworono ade kirono uburono inako kwaeyogono umono. Ko momai upu ki badidi maba waira rabineya ugwede susukwanatapu positagubu ki ka eba apunu ki e kwae-wena. ");
INSERT INTO gdn_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Ki ka waira ebo kwaewena manako momai ki ugwede susukwanatapu matarau positagubu kawakawayatagubu kwarai wenapupu supupu manako ewa mibai kipu. ");
INSERT INTO gdn_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Mibai kipu ki raiyagisi ki ka raupomu marai wana bauwena ki pokere apunu ki e kerebai yadini baiyagisi mibai ki meme kaikirapoto raupomuyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Iyesu inako wagubu ade tadebu, wagubu ke; “Mamanuga God e kasiyarai pokaiya e gari rabineya idiwana ki ka badidi maba? Ki keyakeyai nu gwede naureya iwagamu? ");
INSERT INTO gdn_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ki ka ripa damaya madai ki maba. Ripa dai ki mu madi-maga ka kawakawaya ko damaya madai rabineya ka momai rasirasi. Momai marai munta eyaka mena inako ki kauyagisi wairau suroto wenayagisi, ");
INSERT INTO gdn_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ki ka ripa kawaya mo wenayagisi ragai isiyapoto manako midiwari baitagisi ragai ki kawareya tawatagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Iyesu waigugu were iyapana inako tadeyawa kabukabuwa tondawa. Mu e waigugu wagubu ki mibai wainamupu ki ka e waigugu waunai mosi kawareya ade tadebu. Ko mu eba wainamupu ki ka e yona waunai mosi mu eba tadebu. ");
INSERT INTO gdn_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","E waigugu mena pokaiya wagawa umawa ko yona matarau mo iyapana eba tadeyawa. Ko e eya tadeyau kabukabuwa ragidai mete muga mena ewapuru idiwa ki ka e waigugu were wagawa ki mibai kuduba mu bamamugu matarapiyawa. ");
INSERT INTO gdn_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Mara ki kemoreya ka Iyesu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Kebomoi da nu waka kawareya kaburu papasi daikere kaigamu.” ");
INSERT INTO gdn_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","E yona ki wagawa ka e eya waka rabineya tondawa ki pokere e tadeyau kabukabuwa ragidai kimpu ubumpu iyapana ropani kawaya ika idiwa ki kamaditampu e eweya waka kawareya positagubu manako mu ewapuru mena kayatagubu. Ko waka dai mete kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Mu kayatagubu kaiwa da nusuru kawaya mo bauwena towawa wirawena yabadubu waka rabineya posiwena manako waka waunitau kaburu surana kwaewagawa. ");
INSERT INTO gdn_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ko Iyesu waka nikareya kunuwana tapu ukwarawa, ki pokere e tadeyau kabukabuwa ragidai kaimpu e wadumpu yabuyabu simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, nu popoigamana kwaigemei ko kau nu nene wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Mu inako tagubu manako Iyesu yabuwena kipu ubupu e bonanai ragiragi kawaya nusuru yo towawa ki tadebu, wagubu ke; “Purupuruiwagi! Bigabigaiwagi!” E yona ki wagawa makeya ka nusuru puruwena, towawa bigawena, manako kaburu kwarisiwena daumoro ukwapu. ");
INSERT INTO gdn_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ko Iyesu e tadeyau kabukabuwa ragidai emitapu tadebu, wagubu ke; “Wi gwede nana kudu kwaiwagamu? Wi nau sumasinimpena ki ka wi kudu eba wainampena ko wi nau eba suma-siniyamu ki pokere wi kudu mete wainapiyamu.” ");
INSERT INTO gdn_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Mu notamaga kowena kudu ebotau wainamupu manako mu mubo mena tagubu ke; “Apunu yau ka nima? Nusuru yo towawa e wagubu umuneya bigabigatagubu.” ");
INSERT INTO gdn_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Iyesu e tadeyau kabukabuwa ragidai mete kina waka kawareya kayatagubu kaiwa da papasi daikere Gerasini ragidai mu tawanamugu bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Bautagubu ka Iyesu waka kamadubu kanibu wairau supu manako apunu mosi iyapana popotagubu ononotampu ki rakimaga kawareya tondawa ki Iyesu empupu e diriwai yabadubu. Keyai berokoi apunu ki rabineya tondawa ki pokere e yabarai babawena, ");
INSERT INTO gdn_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","raki ki kawareya ukwarawa. Iyapana e wadamana kwarisi ki kwaetagamawa ko e kasiyarai ka kawaya daganani ki pokere e iyapana weutamiyawa isiyatamiyawa. ");
INSERT INTO gdn_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Mu maramara e idai kerarai taburuba ragiragi kawaya pokaiya umamawa dokodoko ko e kwikwi gengemupiyawa manako taburuba ki purupurutagamawa ki pokere iyapana karako e kamadumpu e ebo mena umawa wadawa. ");
INSERT INTO gdn_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","E kemora nawaru kweyau umawa raki kawareya tondawa kwewagawa bowa were e eya midi minimini sipasipara-piyawa mibai darai umawa wadawa. ");
INSERT INTO gdn_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Apunu ki yabu tapu Iyesu buri empupu ka e diriwai garupupu Iyesu yabareya bauwena manako e paraupana ki nana kwarisiwena e ramatai kawareya ubupu. ");
INSERT INTO gdn_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Ko Iyesu apunu ki empupu manako keyai berokoi e rabineya tondawa ki mete empupu manako e keyai berokoi ki siwakeke-pupu sibu, wagubu ke; “Kau apunu yau rabineya tondei ki karako kamadi baunuwagi kayanuwagi.” E inako wagubu siwakekepupu ko keyai berokoi ki denai bonanai ragiragi kawaya Iyesu sibu, wagubu ke; “Iyesu, Kawainuga God kunumau tondau e Gubagai ka kau. Kau gwede berapana ki nana nau bamaneya baunugibi? Kawainuga God e yabuiya ka nau suwagakani yau kena; Nau eba girisini kwaenda makari nau bamaneya baiyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Keyai berokoi ki inako wagubu, ko Iyesu e manupupu, wagubu ke; “Kau sigi ka badidi?” “Nu keyai berokoi ropani kawaya yewe dibimipi idiwei, ki pokere nau sini ka Damu Kawaya.” ");
INSERT INTO gdn_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Keyai berokoi ki inako wagubu manako kawareya kawareya nuwasiyasiya nene Iyesu siyawa, wagawa ke; “Waira kudubeya eba tononiyo ko waira orageya yewe idiwomu.” ");
INSERT INTO gdn_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Karako ka kweya madani daikere papa boyo ropani kawaya buri sipura-tagamu iwu, ");
INSERT INTO gdn_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ki pokere keyai berokoi papa boyo ki emitampu ka mu Iyesu genepamawa kawareya kawareya siyamawa, tagamawa ke; “Kau nuwagi, manako nu kaigamu bo buri rabina-mugu teteigamu idiwomu.” ");
INSERT INTO gdn_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","“Ki baganai, kaiwagi.” Iyesu inako wagubu, manako keyai berokoi apunu ki kamadumpu matarau bautagubu kayatagubu bo ki rabinamugu tete-tagubu. Ki makeya ka bo ropani kawaya eba iyabapamana makai kuduba 2000 kwaitana mu yabaramaga babawena kweya ki erida mena garugarumupu kaburu sikisikimupu manako nonamaga kubabu popotagubu gawarara. ");
INSERT INTO gdn_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Baikamu ragidai ika idiwa gwede wenawena ki emupu ka mu wakapa-tagubu kayatagubu tawa tawa iyapana tademupu manako iyapana waratampu kayatagubu Iyesu bameya mu mubo yabumugere empamana ki nana bau-tagubu. ");
INSERT INTO gdn_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Bautagubu ka mu apunu ki naiya keyai berokoi ropani kawaya e rabineya idiwa ki ika monagawena bagi kawaya tondawa emupu. Empamawa ka mu notamaga kowena kudu mete wainamupu. ");
INSERT INTO gdn_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ko bo baikamu-tagamawa ragidai ubumpu apunu ki sisiyai ade bo popotagubu ki sisiyai mete kina iyapana tademawa, ");
INSERT INTO gdn_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ki pokere tawana ki ragidai Iyesu kawareya kawareya baiyonopamawa da e mu tawanamaga ki kamadana kayawagana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Iyesu waka kawareya ade kayawagana kwaewagawa ka wadubu bagi apunai ki e ewakumapupu mete kayatagamana ki nana ika bauwena. ");
INSERT INTO gdn_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ko Iyesu apunu ki munapupu, sibu, wagubu ke; “Kau kowagiyoma mu bamamugu kayanuwagi. Mamanuga God e notai kawaya daganani kau nene wainapupu. E kau nene bagi kawaya badidi kwaewena ki sisiyai kuduba kau iyapana tawageya idiwu ki tadeyowa da mu mete wainapomoto.” ");
INSERT INTO gdn_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Iyesu inako wagubu manako apunu ki kayawena tawana Dekaporisi rabineya Iyesu e bameya badidi kwaewena ki sisiyai iyapana tadeyawa umawa. Iyapana kuduba yona ki wainamupu ka mu notamaga kowena. ");
INSERT INTO gdn_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Iyesu ade wirawena waka kawareya kayawena kaburu papasi daikere bauwena manako iyapana ropani kawaya bautagubu e ika banana-mupu kwagaramupu idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Iyesu ika kaburu papateya uburawa ka guriguri tawai ki kwayubapiyau apunai mosi si ka Yairusi bauwena Iyesu empupu manako garugaru mena e diriwai yabadubu e yabareya kwarisiwena ramatai kawareya ubupu manako nuwasiyasiya nene Iyesu gigipiyawa, wagawa ke; ");
INSERT INTO gdn_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","“Nau peteni marai sigirawena powagana kwaewagau ki pokere kau yabodowa nau tawaneya mete kaigamu kau idagi e kawareya tari da e iyayagisi ade umono.” ");
INSERT INTO gdn_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Apunu ki Iyesu inako gigipiyawa da bananapupu ko iyapana ropani kawaya Iyesu paupunampu mete kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Iyapana ropani kawaya ki mu paunamugu ka ridi mosi ika kaniyawa. Kwamura ida esida kewowena kerapu apeya (12) ki rabineya ka e sigira mena tondawa. E kobaiya ka dara maramara bauwagawa. ");
INSERT INTO gdn_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Sigira ki kataimugu ragidai e iyapamana ki nana kawareya kawareya muramura kweyamawa ko e sigirai ki eba kewowena ko e maramara makari wainapiyawa tondawa. Mu e iyapamana ki denai ka e bowai madai tagebu gawarara ko e eba iyawena ko e sigirai ki kawayawagawa yarawa. ");
INSERT INTO gdn_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ridi ki Iyesu sisiyai wainapupu ki pokere e empana ki nana karako iyapana paunamugu e tagere bauwena. ");
INSERT INTO gdn_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","E kaniyawa da e notai wagubu ke; “Nau karako kaniyani e aukwarai mena geyapani ki nau bani iyasugani.” ");
INSERT INTO gdn_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","E notai inako wagubu manako kanibu Iyesu bameya bauwena e aukwarai ki giyansu mena geyapupu. E aukwarai geyapiyawa makeya ka e rabineya e ebo mena wainapupu da e kobaiya dara bauwagawa ki kewowena ade e sigirai ki mete garugaru mena kewowena. ");
INSERT INTO gdn_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Ki makeya ka Iyesu e nuwaiya mena wainapupu da e kasiyarai mo bauwena kayawena ki pokere e iyapana paunamugu wirawirawagawa yabu tarawa, wagawa ke; “Nau aukwarani ka nima geyapupu?” ");
INSERT INTO gdn_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","E inako wagubu ko e tadeyau kabukabuwa ragidai denai e simupu, tagubu ke; “Empiyei, karako iyapana ropani kawaya bautagubu kau paupunanimpu ki geyaniyamu, ko kau nima geyanibu were nuwegei?” ");
INSERT INTO gdn_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Mu inako tagubu ko Iyesu nima geyapupu ki e nene yabu tarawa tondawa, ");
INSERT INTO gdn_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ki pokere ridi ki e ebo mena wainapupu da e sigirai kewowena ki kudu mibi didigurai bauwena Iyesu yabareya kwarisiwena e ramatai kawareya ubupu manako e geyapupu sisiyai ki kuduba wagubu matara. ");
INSERT INTO gdn_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ko Iyesu ridi ki empupu denai sibu, wagubu ke; “Peteni, kau sumasinibi ki pokere kau karako iyanugibi. Kau sigiragi wana kewowena ki pokere kau rabinagi kwarisiyagisi nuwabagi rabineya mibi mamamai kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Iyesu inako wagawa makeya ka iyapana dai apunu Yairusi bibi bau-tagubu simpu, tagubu ke; “Kau petegi powena. Nu Nidiyau Kabukabuwa Apunai ki ororeya mena bauwagubena ki ka baganai ko kau petegi karako wana powena ki pokere apunu ki siyo da e wirayagisi kayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Mu inako tagubu ko Iyesu e wenagui mena yona ki wainapupu kamadubu manako wirawena apunu Yairusi sibu, wagubu ke; “Kau notagi eba koyogono ko nau mena sumasiniyowa.” ");
INSERT INTO gdn_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","E inako wagubu iyapana kuduba munatapu manako apunu Yairusi ade e eya tadeyau kabukabuwa ragidai Pita yo Diyemesi ade Diyemesi yowai Diyoni mete kina ki mu mena mete kayatagamana ki nana wagubu manako waratapu apunu Yairusi tawaiya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Mu apunu Yairusi tawaiya bau-tagubu ka Iyesu iyapana ika yadi wadamawa nuwamaga notamaga giri kandiwagawa ki emitapu, ");
INSERT INTO gdn_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","manako e kanibu tawa rabineya yapu iyapana ki tadebu, wagubu ke: “Wi gwede apenai meyamu? Munu ridai ki eba powena ko e pa ukwarau.” ");
INSERT INTO gdn_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","E inako wagubu ko mu e gwaigwitapamawa ki pokere e iyapana ki baiyonotapu bautagubu matarau kayatagubu. E eya ade munu ridai ki inai mamai ade e tadeyau kabukabuwa ragidai apeya eyaka mete kina ki mu mena tawa rabineya munu ki bameya idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Iyesu kanibu munu popai ki bameya bauwena e idaiya wadubu manako sibu, wagubu ke; “Tarita kumi!” (Yona ki mibai ka; ‘Munu ridai, nau nidiyani wainapi; Kau kiri uburi!’) ");
INSERT INTO gdn_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","43","Iyesu inako wagawa makeya ka munu ridai ki garugaru mena iyawena kipu ubupu kanibu yabadubu. Tawa rabineya idiwa ragidai matakira ki emupu ka mu notamaga kowena kodabamaga kamupu didiguramaga mete wagubu. Ko Iyesu mu umunumaga umapu tadebu, wagubu ke; “Iyapana eba tademuri. Wi petega wana iyawena ki pokere karako bani dai kwemuri kupoto.” Ko munu ridai iyawena ki e kwamurai ka ida esida kewowena kerapu apeya (12). ");
INSERT INTO gdn_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Iyesu tawana ki kamadubu manako e tadeyau kabukabuwa ragidai mete kina e ebo tawaneya ade kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Aiyata marai ki makeya ka e guriguri tawai rabineya Mamanuga God e yonai iyapana tadeyawa kabukabuwa tondawa. Iyapana ropani kawaya e yona wagawa ki wainapamawa ka mu notamaga kowena, tagamawa ke; “Apunu yau ka yona kawaya kawaya yau bani wainapupu bauwena wagau? Nota yau ka nima kwebu? E matakirai ebo ebo mete kwaewagau ki kerarai ka badidi? ");
INSERT INTO gdn_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","E ka ridi Meri e gubagai ki gwedegwede marai kawai ripa pokaiya yamanawagau ki apunai. E yowaiyoma ka Diyemesi yo Diyose yo Diyudiyasi yo Saimoni, ade e egapuiyoma ka nu mete yewe idiwei.” Iyapana inako tagubu manako Iyesu simpu siyasiya tagarara-mupu. ");
INSERT INTO gdn_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ko Iyesu iyapana tadebu, wagubu ke; “Mamanuga God e bonanai wainapiyau wagau apunai tawana tawana umono da iyapana e wiwira-pomono e diriwai kwaetogomono. Ko e wirayogono e ebo tawaiya baiyogono ki ka e eya iyapanaiyoma e eba wiwira-pomono ade e diriwai mete eba kwaetogomono.” ");
INSERT INTO gdn_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Mu Iyesu eba sumamupu ki pokere e natere ki rabineya matakira kawaya mo eba kwaewena. E idai sigira ragidai dai mena mu kawarimugu nakapupu manako mu iyatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Tawana ki ragidai e eba sumamupu ki pokere e notai babawena nuwaboyawena. ");
INSERT INTO gdn_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya (12) mu nene wagubu bautagubu manako kasiyara tagebu da mu tawana tawana kayatagamana keyai berokoi siwakeketamana ki nana. E tadebu, wagubu ke; “Wi apeya tawana anu kaiwagi ade wi apeya tawana anu kaiwagi.” E inako tadbu tonotapu, ");
INSERT INTO gdn_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ade wagubu ke; “Wi kaiwagi ki ka wi yawata gwedegwedei mete eba tepu-muri. Igwa, masura, bowa madai ki kuduba wi kamaditamuri, ");
INSERT INTO gdn_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ko wi kerapuga tatamai ade wi midiga tatamai eyaka eyaka ki mena umamuri wi gunaga mena tepumuri kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Wi kaiwagi iwoi da natere mo baiwagi manako iyapana mo wi nene kwaewagau ki ka wi e bameya ukwapu-muri ko wi tawa yabayababa mo eba ukwapumuri. ");
INSERT INTO gdn_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ko wi natere mo baiwagi da iyapana wi nene eba kwaetogomono ade wi yonaga eba wainapomono ki ka wi waigugu mena inako kwaiwagi; Wi kerapuga dogiyai mu tawamaga mena pasipumuri manako kamaditamuri kaiwagi. Mu waigugu ki empomoto ki ka mu notamaga yagisi ke; ‘Akae, nu beranuga ka eba bagi ki pokere mu waigugu mena nu bamanugu kwaetagubu yau kena.” ’ ");
INSERT INTO gdn_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Iyesu inako tadebu tonotapu manako mu kayatagubu tawana tawana bautagamawa dimatagamawa iwa, tagamawa ke; “Wi beraga berokoi kamadumuri ade wi notaga wirayagisi Mamanuga God bameya.” ");
INSERT INTO gdn_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Mu inako tagamawa manako keyai berokoi ropani kawaya mete siwakeketamawa bau-tagamawa kayatagamawa. Ade mu sigira ragidai ropani kawaya mete iyatamawa awana dobiri monamonai maba ki pokaiya mu kwakwarepumaga pasipamawa. ");
INSERT INTO gdn_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","16","(-) ");
INSERT INTO gdn_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","19","Apunu kawai Erodi e ka e yowai Piripo e wainai si ka Erodiyasi kuwawena uwapu ki pokere iyapana siruwatamiyawa apunai Diyoni e kawareya kawareya sisibapiyawa, wagawa ke; “Kau nadawagi gwede nana kuwanugibi? Kau ki kwaenugibi ki kau gora raurupipi bera berokoi kwaenugibi.” Apunu Diyoni inako wagubu ki pokere ridi Erodiyasi gagayawena e deni mena miniyana po wainapupu. Ko apunu Erodi e tatamapupu piyara ragidai tadebu da mu apunu Diyoni e idai kerarai umamana pa diburapamana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Apunu Erodi wainapupu da apunu Diyoni e ka tanai supasupai bagi kawaya ki apunai ade e kudeya mete wainapupu ki pokere e tatamai inako wagubu. Apunu Diyoni badidi yonawagawa ki ka apunu Erodi nuwaiya yona ki wainapana waina-piyawa ko e yonai ki wainapiyawa ki ka e notai mete babawagawa. ");
INSERT INTO gdn_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Ki eweya mara mosi ka ridi Erodiyasi apunu Diyoni bameya badidi kwaewagana notapiyawa ki matara-wena. Apunu Erodi wenawena kupei ki marai bauwena ka iyapana kawakawai e kobaiya idiwu ragidai yo piyara ragidai mu kawakawaimuguma yo tawana Gariri ragidai mu kawakawai-muguma dai mete kina ika Erodi bameya daiyo bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Mu kupetagamawa idiwa ka ridi Erodiyasi e petei bauwena mu mamamatagamana ki nana mu yabaramugu taerewagawa kaniyawa yabadawa. Apunu Erodi e daiyoi bautagubu ragidai mete kina e taerewagawa ki empamawa ki ka mu rabinamaga bagiwena manako apunu Erodi ubupu munu ridai ki sibu, wagubu ke; “Kau nuwageya gwede ki kau nuwagi manako gwede ki kuduba ka nau kau negeyani.” ");
INSERT INTO gdn_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","E inako sibu manako gwaiyabapupu, wagubu ke; “Nau mibai nidiyakani; Kau nuwa-geya gwede nene wainapiyei ki kuduba nau kau negeyani. Nau kasiyarani daikere ki nau mete negeyani.” ");
INSERT INTO gdn_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Apunu Erodi inako wagubu ko munu ridai ki e inai bameya kayawena manako manupupu, wagubu ke; “Inani, nau gwede tegeyana ki nana siyani?” “Mu iyapana siruwatamiyawa apunai Diyoni e gobai meyamana puru ade e debai kau negemana ki nene nuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","E inai inako wagubu, ki pokere munu ridai ki garugaru mena apunu Erodi bameya ade kayawena, manako sibu, wagubu ke; “Nau nuwaneya kau tegeyana ka yau kena; Iyapana siruwatamiyawa apunai Diyoni e gobai wi karako memuri puru manako e debai yogo kawareya tamuri tege-muri.” ");
INSERT INTO gdn_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Apunu Erodi yona ki waina-pupu ka e nuwaboyawena ko e ororeya mena iyapana ropani kawaya ki mu yabumugu munu ridai ki gwaiyaba kaimatana sibu ki pokere e apunu Diyoni e tatamai ade wagana ki yawatai pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","E piyara apunai mo sibu da e kayawagana apunu Diyoni e gobai meyana puru ki nana wagubu manako apunu ki kayawena apunu Diyoni e gobai mebu puru. ");
INSERT INTO gdn_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","E gobai mebu puru kewowena ka e debai ki yogo kawareya tapu manako wadubu kanibu munu ridai ki kwebu manako e ubupu yogo ki wadubu e inai kwebu. ");
INSERT INTO gdn_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ko apunu Diyoni e tadeyau kabukabuwa ragidai e powena sisiyai wainamupu ka mu bautagubu e kwakwarepui wadu-mupu ononomupu. (v14) Iyesu badidi kwaewagawa umawa ki sisiyai kawayawena kayawena manako apunu Erodi sisiya ki mete wainapupu. Iyapana dai Iyesu nene inako tagubu ke; “Iyapana siruwatamiyawa apunai Diyoni powena ki ade iyawena wirawena bauwena yau kena ki pokere e upi kasiyarai kawaya kwaewagau.” (v15) Ko dai tagubu ke; “E ka bani oragai apunai Eraidiya ade wirawena bauwena.” Ko ade dai tagubu ke; “E ka Mamanuga God e bonanai wainapiyau wagau apunai mosi ki naiya idiwa tagamawa ki maba mosi.” (v16) Mu inako tagamawa ki apunu Erodi mete wainapupu, manako e wagubu ke; “Ki mibai, e ka apunu Diyoni ade wirawena bauwena yau kena. Nau suwagubuwani manako mu apunu Diyoni e gobai mempu puru powena ko e karako ade iyawena wirawena bauwena yau kena.” ");
INSERT INTO gdn_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Iyesu e tadeyau kabukabuwa ragidai ade wiratagubu bautagubu manako mu badidi kwaetagamawa ade iyapana badidi tademawa teyateyama ki sisiyai kuduba mu makeya makeya Iyesu simupu. ");
INSERT INTO gdn_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Mu kupetagamana kwaetagamawa ko iyapana ropani kawaya mu bama-mugu bautagamawa ade kayatagamawa bautagamawa ade kayatagamawa ki pokere mu bani kupamana babatagubu. Babatagubu ki pokere Iyesu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Iyapana yau kamaditamamu nu nubo mena tawana mosi iyapana pa mena tawanai ki kaigamu da wi ika naigida mena aiyataiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","E inako wagubu manako mu waka kawareya positagubu mubo mena kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Iyapana ika idiwa ragidai mu kayatagamawa emitampu ki ka mu kimpu ubumpu mu kayatagamawa ki deneya kaburu papateya garugarumupu manako Iyesu duwareya naiya buri bautagubu e nawanai ika idiwa. Tawana ki ragidai ropani kawaya ika mete bautagubu ewapuru mena dibi-mupu idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Iyesu waka kawareya kaniyawa da bauwena manako iyapana ropani kawaya ika bautagubu e nawanai idiwa emitapu ki ka e mu nuwaboyamaga wainapupu. Mu ka papa sipi kwayuba-tamiyau apunai pa mena ki maba idiwa. E mu nuwaboyamaga wainapupu ki pokere e ubupu yona marai kawai mu tadeyawa kabukabuwa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","E inako tadeyawa kabukabuwa tondawa da kemorawagana kwae-wagawa ka e tadeyau kabukabuwa ragidai bautagubu e simupu, tagubu ke; “Madega surana kwaewagau ko tawana yau ka tawa pa mena, ");
INSERT INTO gdn_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ki pokere kau iyapana kwagaraniyamu yau karako tonotami da mu tawanamugu tawana-mugu kayatagisi bani tepomoto teyomoto kupomoto.” ");
INSERT INTO gdn_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Mu inako tagubu ko Iyesu mu emitapu manako denai tadebu, wagubu ke; “Ae, wi inako eba iwagi. Wi wiga baniga ki dai tepumuri tagemuri da mu kupomoto.” E yona ki wagubu ka mu denai tagubu ke; “Akae, nu gwede tageyamu? Nu kaigamu bani dai gimarapamu tageyamu kupomoto bo? Mu ka ropani kawaya ko bani ki denai ka kawaya daganani. Bowa madai kawaya 200 yau ka maraitau.” ");
INSERT INTO gdn_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Mu inako tagubu, ko Iyesu mu manutapu, wagubu ke; “Wi yawata masurai nu nuga denenugu badibadi temupu? Kaiwagi empumuri.” E inako wagubu, manako mu kaimpu emupu ade bautagubu, tagubu ke; “Nu bani buredi ka ida daikere mena ade raubiyo apeya ki mena temipi.” ");
INSERT INTO gdn_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Mu inako simupu manako Iyesu denai tadebu, wagubu ke; “Ki baganai. Sumuri iyapana tademuri da mu dewarepa yau kawareya mu mubo mubo damupomoto idiwoto kayatagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","E inako wagubu, manako e kowakowaiyoma ki kaya-tagubu iyapana ki tademupu, dai 100 idimpu, dai 50 idimpu, mu inako kayatagubu iyapana damutamawa iwa. ");
INSERT INTO gdn_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ko Iyesu bani buredi ida daikere mena ade raubiyo apeya mete kina ki tepupu esida yabu tapu e Mamai bameya parauwena manako bani buredi ki gerepupu e tadeyau kabukabuwa ragidai tagebu manako mu bani ki tempu iyapana tagempu kayatagubu. E raubiyo apeya ki mete purupupu iyapana kuduba tagemana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","44","Ko mara ki makeya ka iyapana ropani kawaya eba bigabigai apunu mena kuduba 5000 bani ki kupampu matetagubu. Mu kupetagamawa idiwa da kamadumpu ka e tadeyau kabukabuwa ragidai bani pirai kwana-mupu kode rabineya nunumupu ka kode ida esida kewowena kerapu apeya (12) positagubu. ");
INSERT INTO gdn_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Iyapana bani kupampu kewowena ka Iyesu ubupu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Wi yabiri waka kawareya kaburu papasi buridere tawana Betaida kaiwagi ko nau ka iyapana ropani kawaya yau tonotamani kayatagisi were wi ewagau ika bau-sugani.” ");
INSERT INTO gdn_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","E inako wagubu kuwenatapu ade wirawena iyapana kuduba ika dibimupu idiwa ki tonotapu kayatagubu manako ewa kwaunai mosi yapu e Mamai bameya ika guriguriwagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Kemorawagawa ka waka wana kaburu paunau kaniyawa ko Iyesu e ebo mena borau tondawa. ");
INSERT INTO gdn_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nusuru towawa wirawena waka gipiyawa kaniyawa ki pokere e tadeyau kabu-kabuwa ragidai waka barapamana ka ragiragi kawaya ki e mu emitapu. Nawaru dumai waunitau tarana kwaewagawa ka Iyesu kipu ubupu supu e kerareya kaburu kawareya e tadeyau kabukabuwa ragidai mu ewamugu kayawena. E kayawena kaniyawa da mu bamamugu bauwena ade wade ewaiwatamana kwaewagawa, ");
INSERT INTO gdn_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","ka mu e kerareya kaburu kawareya yabadawa emupu manako kudu ebotau wainamupu didiguramaga mete wagubu, tagubu ke; “Ki ka guba diyayai mo bauwena.” Mu inako tagamawa kwetagamawa idiwa mibai ka e ika yabadawa ki mu kuduba matarau emupu manako notamaga kowena. Ko Iyesu garugaru mena tadebu, wagubu ke; “Yau ka nau ki pokere kudu eba kwaiwogoi ko kasiyarai kawaya idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","E inako wagubu kanibu waka kawareya yapu posiwena manako ki makeya ka nusuru bigawena. E tadeyau kabukabuwa ragidai e kwaewena ki emupu ka mu notamaga kowena kodabamaga kamupu, ");
INSERT INTO gdn_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","mibai ka mu notamaga ka ragiragi kawaya. Iyesu naiya bani buredi gerepupu iyapana tagebu ko matakira ki mibai ki mu naigida eba wainamupu. ");
INSERT INTO gdn_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Mu waka kawareya ade kaya-tagubu kaiwa da papasi buridere tawana Genesare bautagubu. Mu waka taburubai wadumpu kwimpu, ");
INSERT INTO gdn_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","manako waka ika kamadamana kwaetagamawa ka iyapana ika idiwa ki Iyesu kiyabui emupu, ");
INSERT INTO gdn_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","manako mu garugaru mena kimpu ubumpu tawa tawa kayatagubu Iyesu bauwena sisiyai iyapana tademawa iwa. Tawana ki ragidai yona ki wainamupu ka mu sigira ragidai mibi gagarai tetampu manako tawa tawa Iyesu bani umawa ki mu e bameya ika bautagamawa. ");
INSERT INTO gdn_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","E tawa tawa bau-wagawa ki ka mu sigira ragidai imatau nakatamawa da mu Iyesu midai geyapamana bo pa mena ki ka mu e midi tatamai mena geyapamana da mu ki pokaiya iyatagamana ki nana. Iyapana gwedewau e geyapamawa ki ka mu iyatagamawa. ");
INSERT INTO gdn_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","4","Parisi ragidai ade Diyu ragidai dai mete kina mu ripakwarakwara-muguma gora tampu ki mu makeya makeya naigida mena kwaetagamu idiwu. Mu bani kupomoto ki ka mu naiya goramaga badidi wagau ki makeya makeya kwaetagisi mu idamaga siruwapomoto were ewa bani ki kupo-moto. Mu bani gimarapomoto ki ka mu naiya bani ki naigida mena siruwa-pomoto were ewa tawiyatagisi ade kapa yo kurari yo gwedegwede kuduba inako ki mu asusu eba siruwapomoto ko oragai ragidai badidi kwaetagamawa ki maba mu makeya makeya inako kwae-togomono siruwapomono. Parisi ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina natere Diyerusaremu were bautagubu ki mu kaimpu Iyesu kwagaramupu idiwa manako e tadeyau kabukabuwa ragidai gora pokaiya idamaga eba siruwamupu ko bani pa kupamawa idiwa ki mu emitampu, ");
INSERT INTO gdn_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ki pokere mu Iyesu manu-mupu, tagubu ke; “Nu ripakwarakwara-nuguma goranuga oragai kabuwanimpu kebomawa ki kau tadeyei kabukabuwa ragidai badidi pokere raurupiyamu idamaga eba siruwapiyamu were bani tepiyamu kupamu?” ");
INSERT INTO gdn_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Mu inako tagubu ko Iyesu denai wagubu ke; “Wi ka midiga pa mataka-wagau ragidai. Ko wi kwaiwagamu ki nene ka oragai apunai Aisaiya takari kawaya uwamau empupu manako e oka mibai inako tapu, wagubu ke; ‘Mamanuga God e wagau; Iyapana yau nau sini pa umunumaga pokaiya tagamu wiwirasiniyamu, ko mu nuwamaga notamaga ka uwama kawaya, eba nau bamaneya. ");
INSERT INTO gdn_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Mu tagamu da mu nau sini tepa-piyamu ko mu kwaetagamu ki mibai ka pa mena. Mu muga goramaga iyapana naiya mu mubo notamaga pokaiya kwaetagamawa iwa ki mena mu makeya makeya kwaetagamu ade mu kowa-muguma mete kabuwatamiyamu iwu. Ko gora kuduba mu wiwirapiyamu ki ka eba nau gorani. Pa mena.’ Oragai apunai Aisaiya wi nene inako wagubu, ");
INSERT INTO gdn_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","ki kawareya nau karako wi nidiyakani yau kena; Mamanuga God e gorai ki wi wadumpu tagagau kwenu-mupu ko iyapana kaina mu yonamaga ki wi wadamu doko wi rabinagau tamu makeya makeya kwaiwagamu.” ");
INSERT INTO gdn_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Iyesu inako wagubu, ade tadebu, wagubu ke; “Mamanuga God e yonai ki wi wadamu kiyokiyo wi tagagau tamu ko wi wibo kabuwaga ki wi naigida mena wiwirapiyamu esida tepapiyamu. ");
INSERT INTO gdn_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Oragai apunai Mosisi Mamanuga God e gorai tapu, wagubu ke; ‘Kau inagi mamagi wiwiratamiyowa ade mu naigida mena kwayubatamiyowa. Iyapana nima e eya inai mamai kiratamono tadeyono siyasiya ki ka e denai poyagisi.’ ");
INSERT INTO gdn_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Oragai apunai Mosisi inako wagubu ko wi ka wibo nuwagau inako iwagamu ke; ‘Iyapana mosi e inai mamai nuwasiyasiya nene idiwu ki emitamini manako yagisi ke; ‘Nau wi waitaniyana gwede mo negeyana ko nau gwede ki winepuwani Mamanuga God nene tapuwani ki pokere nau wi negeyana ka eba baganai.’ ");
INSERT INTO gdn_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","E inako yagisi ki ka wi iwagi ke; ‘Ki ka bagi kawaya. Gwedegwede Mamanuga God nene tapi ki kau inagi mamagi eba tage.’ ");
INSERT INTO gdn_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ko wi iyapana inako tadeyamu ki ka wi paerepiyamu Mamanuga God e gorai raurupiyamu manako wi wibo kabuwaga ade wi wibo kaisiga ebo ebo ki mena kwaiwagamu. Wi gwedegwede marai kawai yau maba mete paere-piyamu kwaiwagamu.” ");
INSERT INTO gdn_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Iyesu iyapana ropani kawaya ika idiwa ki mu nene ade wagubu bau-tagubu manako tadebu, wagubu ke; “Nau yona yau suwagani ki mibai wi kuduba naigida mena wainapumuri; ");
INSERT INTO gdn_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","16","Wi gwede mosi umunugere kupu-muri ki ka eba bani ki wi bigi negeni. Ko wi wibo notaga pokaiya waina-piyamu matarau kwaiwagamu ki mena wi bigi negeyau.” ");
INSERT INTO gdn_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Iyesu iyapana ropani kawaya ki kamaditapu tawa yapu ki ka e tadeyau kabukabuwa ragidai e bameya bau-tagubu manako manumupu, tagubu ke; “Kau nuwagibi ki mibai ka badidi?” ");
INSERT INTO gdn_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Mu inako tagubu, ko e denai tadebu, wagubu ke; “Wi mete notababa wadamu bo? Wi badidi pokere eba wainapiyamu? Bani kiyabui ebo ebo kupemei ki ka eba bani ki uburoto wi bigi negeni. ");
INSERT INTO gdn_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Bani kupumuri ki suroto wi rabinagau tondono manako ewa baiyagisi kayayagisi. Ki ka eba bani ki uburoto wi nuwaga notaga bigi kweyoto. Pa mena.” Iyesu yona ki wagubu ki ka e bani kuduba ka bagi mena ki yonai wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ko Iyesu mu ade tadebu, wagubu ke; “Ki ka wi wibo rabinagau waina-piyamu ade matarau kwaiwagamu ki mena wi bigi negeyau. ");
INSERT INTO gdn_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wi wibo nuwagau notagau nota berokoi waina-piyamu ki pokaiya ka wi taku maba igida yauda asusu iwu, kuwaigamu, minimini popoiwagamu, ");
INSERT INTO gdn_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","mibi anikai sipuma goragora rauru kawakawara kasiwaraiwagamu, wibo kapoiwagamu, bera berokoi ebo ebo kwaiwagamu, kowaguma weyaweyatamiyamu, midimama berai kwaiwagamu, nuwaroroiwagamu, kowaguma yanuwe-maga teyamu, wibo yabara kawa-kawaraiwagamu, wi notaga pa mena maba babaibitau inako kwaiwagamu iwu. ");
INSERT INTO gdn_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Nota berokoberoko yau kuduba wi wibo rabinagau wainapiyamu ade ewa matarau kwaiwagamu ki mena wi bigi negeyau.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Iyesu tawana ki kamadubu kayawena kaniyawa da tawana mosi natere Taya bameya bauwena manako tawa mo yapu. E eba nuwaiya iyapana e empamana ki nana ko e bauwena sisiyai ki kawayawena kayawena iyapana kuduba wainamupu. ");
INSERT INTO gdn_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Ridi kwaiyanai mosi ika mete tondawa ki Iyesu bauwena sisiyai wainapupu. E ka eba Diyu ragidai mu ridimaga ko e ka tawana Sairoponisiya mu ridimaga mosi. ");
INSERT INTO gdn_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Keyai berokoi mosi ridi ki e petei rabineya tondawa ki pokere ridi ki karako garugaru mena bauwena Iyesu yabareya kwarisiwena e ramatai kawareya ubupu manako Iyesu genepupu da e uburana keyai berokoi e petei rabineya tondawa ki siwakeke-pana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ko Iyesu denai e waigugu were sibu, wagubu ke; “Nau yabiri munu rasi bani tageyani da mu kupomoto mate-tagisi. Ko mu banimaga taku nene isiyapani ki ka eba baganai.” ");
INSERT INTO gdn_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","E inako wagubu ko ridi ki Iyesu waigugui ki mibai wainapupu manako denai sibu, wagubu ke; “Kaiwawoni, kau yona mibai nuwagibi ko munu rasi banimaga kupomono da pirai gwetagisi ki ka taku mete kupomoto.” ");
INSERT INTO gdn_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Iyesu yona ki wainapupu manako denai e sibu, wagubu ke; “Kau yona denai bagi kawaya nuwagibi ki pokere kau tawageya kayanuwagi. Keyai berokoi kau petegi rabineya tondawa ki karako wana bauwena kayawena.” ");
INSERT INTO gdn_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Iyesu inako wagubu manako ridi ki kayawena e tawaiya bauwena ka e petei iyawena midi bagi kawaya kebari kawareya ukwarawa empupu. Keyai berokoi ki ororeya mena e kamadubu bauwena kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Iyesu natere Taya kikireya ki kamadubu kayawena umawa da tawana Saidoni bauwena manako kayawena kaniyawa da tawana Dekaporisi bau-wena ade surawa da kaburu Gariri papateya bauwena. ");
INSERT INTO gdn_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","E ika bauwena ka iyapana dai ki apunu mosi e wenagui kenekenei yona naigida eba wagawa ki wadumpu Iyesu bameya bautagubu, manako genemupu, tagubu ke; “Kau yabi kau idagi apunu yau kawareya tari da e iyayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Iyesu apunu ki wadubu paere mu mubo mena kaimupu manako e idai gurai apeya apunu ki e wenagui umuneya daikere daikere nunupu. Nunupu toporupupu ade e idai gurai tepopupu apunu ki e tenawarai kawareya tapu. ");
INSERT INTO gdn_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","E inako kwaewena wirawena kunumau esida yabu tapu e nonai warapupu manako e apunu ki sibu, wagubu ke; “Epata!” (Ki mibai ka; ‘wenagugi paparayagisi.’) ");
INSERT INTO gdn_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Iyesu yona ki wagawa makeya ka apunu ki e wenagui paparawena ade e tenawarai tekatekawena manako e yona supasupai kawaya wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ko Iyesu wirawena bauwena iyapana tadebu, wagubu ke; “Nau apunu yau wadubuwani bagi ki sisiyai wi iyapana eba tademuri.” E kawareya kawareya inako tatamatamiyawa umunumaga umarawa ko mu e umunui kwenumupu manako tawana tawana kayatagubu iyapana tademawa iwa. ");
INSERT INTO gdn_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Iyapana sisiya ki wainamupu ka mu notamaga kowena Iyesu e si esida tepapamawa, tagamawa ke: “Apunu Iyesu badidi kwaewagau ki kuduba bagi mena. Wenagui kenekenei iyapanai ki yona wainapiyau ade yona eba wagau ki karako yona wagau.” Mu inako tagamawa. ");
INSERT INTO gdn_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Mara ki makeya ka iyapana ropani kawaya ade dai bautagubu dibi-pamawa idiwa ko mu banimaga ka pa mena. Mu banimaga ka pa mena ki pokere Iyesu mu nuwaboyamaga waina-pupu manako e tadeyau kabukabuwa ragidai mu nene wagubu bautagubu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Nau iyapanani-yoma yau mu nuwaboyamaga waina-pakani. Mu dai ka tawana uwama kawaya were bautagubu mara apeya eyaka nu mete yewe idiweya ko mu banimaga ka pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nau mibi wetei mu tonotamani ki ka mu yamono da kasiyaramaga yawatau kewoyagisi wairorotagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Iyesu inako tadebu ko e tadeyau kabukabuwa ragidai denai tagubu ke; “Tawana yau ka tawa pa mena ki pokere bani ki nu bani tepamu tageyamu da mu kupomoto?” ");
INSERT INTO gdn_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Mu inako tagubu ko Iyesu mu manutapu, wagubu ke; “Wi masura boromai badibadi ika nunumupu?” Mu denai tagubu ke; “Nu masura ida daikere kewowena daikere apeya ki mena yewe temipi.” ");
INSERT INTO gdn_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Iyesu yona ki wainapupu ka e iyapana kwarisitagamana wairau idiwana ki nana wagubu. E masura ida daikere kewowena daikere apeya ki e idaiya tepupu kunumau esida Mama-nuga God bameya parauwena manako bani ki geretapu e tadeyau kabukabuwa ragidai tagebu manako mu bani ki tempu iyapana tagempu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Ko raubiyo rasirasi eba ropani ika mete idiwa ki mu tempu Iyesu kwemupu manako e Mamanuga God bameya ade parauwena. E parauwagawa da kamadubu, iyapana tagemana ki nana wagubu manako e tadeyau kabukabuwa ragidai raubiyo ki mete tempu iyapana tagempu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","9","Mara ki makeya ka iyapana ropani kawaya kuduba 4000 kwaitana bani ki kupa-mpu matetagubu. Mu kupamawa idiwa da kamadumpu ka e tadeyau kabu-kabuwa ragidai bani pirai kwanamupu kode rabineya nunumupu manako kode ida daikere kewowena daikere apeya positagubu. ");
INSERT INTO gdn_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ko Iyesu iyapana tonotapu kaya-tagubu manako e tadeyau kabukabuwa ragidai mete waka rabineya yamupu mu mubo mena tawana Daromanuta kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ki eweya ka Parisi ragidai dai Iyesu kerareya wadamana da e yona mo paerepana bo eba paerepana ki empa-mana ki nana e bameya bautagubu manako manumupu, tagubu ke; “Kau kunuma kasiyarai pokaiya matakira mo kwaenuwagi da mibai bo bera ki nu kau eminiyamu.” ");
INSERT INTO gdn_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Iyesu yona ki wainapupu ka e midi togawena e debai gipupu manako e denai tadebu, wagubu ke; “Iyapana karako idiwu ragidai wi badidi pokere matakira nene maramara nau sidiyamu iwu? Nau yona mibai suwagakani; Nau matakira inako mo wi eba kabuwa-niyani empumuri.” ");
INSERT INTO gdn_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","E inako wagubu kamaditapu waka kawareya ade yapu manako e kowakowaiyoma mete kina kaburu ki papasi buridere kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Mu waka kawareya kayatagubu kaiwa ka Iyesu e tadeyau kabukabuwa ragidai wainamupu da mu masura dai eba temupu. Mu bani buredi eyaka mena ki mena wadumpu. ");
INSERT INTO gdn_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ko Iyesu waigugu were tadebu, wagubu ke; “Nau suwagani wainapumuri; Parisi ragidai ade apunu Erodi mete kina mu banimaga bedebede-pupu ki wi naigida mena empiyoi kaisipiyoi kwaenda mu banimaga kinokinoi ki wi pasiniyoto giriniyoto.” ");
INSERT INTO gdn_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Iyesu yona ki wagubu ka e tadeyau kabukabuwa ragidai baba-tagubu manako mu mubo mubo deni deni manu kasiwaratagamawa, tagamawa ke; “Nu masura dai eba tempi ki pokere e inako wagau bo?” ");
INSERT INTO gdn_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","18","Mu inako manu kasiwara-tagamawa idiwa ki Iyesu kataiwena ki pokere e manutapu, wagubu ke; “Wi badidi pokere masura dai eba tempu ki kawareya iwagamu? Nau waiguguni suwagubuwani ki mibai wi wainamupu bo eba wainamupu? Wi yabuga mete kina ko wi badidi pokere eba em-piyamu? Wi wenaguga mete kina ko wi badidi pokere eba wainapiyamu? Wi notaga mete kina bo pa mena? ");
INSERT INTO gdn_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Nau naiya bani buredi ida daikere mena gerepuwani iyapana uratanai mena 5000 tagebuwani kupampu matetagubu gawarara ki ka wi bani pirai uburawa ki kode badibadi positampu? Wi ki waina-piyamu bo pa mena?” E inako manutapu manako mu denai tagubu ke; “Nu kode ida esida kewowena kerapu apeya (12) inako positampi.” ");
INSERT INTO gdn_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Mu inako tagubu manako Iyesu mu ade manutapu, wagubu ke; “Baganai, ko nau bani buredi ida daikere kewowena daikere apeya geretapuwani iyapana 4000 tagebuwani kupampu matetagubu ki ka wi bani pirai uburawa ki kode badibadi positampu?” Ko mu denai tagubu ke; “Nu kode ida daikere kewowena daikere apeya (7) inako positampi.” ");
INSERT INTO gdn_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Mu inako tagubu ko Iyesu tadebu, wagubu ke; “Baganai, wi matakira ki kuduba emupu ko wi badidi pokere matakira ki mibai eba kataigubu?” ");
INSERT INTO gdn_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Mu natere Betaida bautagubu ka iyapana ubumpu apunu mosi e yabui kenekenei ki wadumpu Iyesu bameya bautagubu manako genemupu, tagubu ke; “Kau yabi manako kau idagi apunu yau e yabui kawareya tari da e yabui payagisi tawana empoto.” ");
INSERT INTO gdn_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Mu inako tagubu ki pokere Iyesu kanibu apunu ki e idaiya wadubu bananapupu gari tagaiya kayatagubu manako e yabui ki puwapupu. Puwapiyawa da kamadubu ka e idai daikere daikere e yabui kawareya nakapupu ade kamadubu manako sibu, wagubu ke; “Kau gwede mo empiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Iyesu inako wagubu manako apunu ki iyarau esida yabu tapu igida yauda yabu tapu, wagubu ke; “Nau iyapana emitamakani ko nau yabuni keyai kaniyau yabadau iyapana ripa maba kaiwu kebomu emitamakani.” ");
INSERT INTO gdn_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","E inako wagubu ki pokere Iyesu e idai daikere daikere apunu ki e yabui kawareya ade naka-pupu ade kamadubu manako ki makeya ka apunu ki e yabui bonai keyai kani-yawa yabadawa ki kewowena manako e tawana naigida mena empiyawa. ");
INSERT INTO gdn_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ko Iyesu apunu ki e ebo tawaiya tonopupu sibu, wagubu ke; “Kau natere buri eba kayanuwagi ko kau kaubo tawageya ki deni mena kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Ki eweya ka Iyesu e tadeyau kabukabuwa ragidai mete kina natere Sisaraiya Piripai ade natere dai bameya bameya mete kina ki deneya kayatagubu. Mu yawatau kayatagubu kaiwa ka Iyesu mu manutapu, wagubu ke; “Wi karako iwagi da nau wainapani; Iyapana nau sini badidi tagamu?” ");
INSERT INTO gdn_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","“Mu dai tagamu da kau ka iyapana siruwatamiyawa apunai Diyoni ade wiranugibi baunigibi, ade dai tagamu da kau ka oragai apunai Eraidiya ade wiranugibi baunugibi, ade dai tagamu da kau ka Mamanuga God bonanai wainapiyei nuwegei ki apunai mosi.” ");
INSERT INTO gdn_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Mu inako tagubu ki pokere Iyesu mu ade manutapu, wagubu ke; “Ko wiyo, wi wainapiyamu da nau ka nima?” E inako wagubu ka apunu Pita denai e sibu, wagubu ke; “Kau ka nu Iya Negeyana Apunai Keriso.” ");
INSERT INTO gdn_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Apunu Pita yona ki wagubu ka Iyesu ubupu e tadeyau kabukabuwa ragidai ki kuduba mu umunumaga umapu, wagubu ke; “Ki kau mibai nuwegei ko nau sisiyani ki wi iyapana eba tadeyoi.” ");
INSERT INTO gdn_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Naiya ka Iyesu e powagana sisiyai e tadeyau kabukabuwa ragidai matarau eba tadebu ko karako ka e tadebu, wagubu ke; “Nau Kunumau Kawapuwani Apunai aita bita midi makari kawaya daganani mo bananapani. Iyapana kawakawai, Mamanuga God bameya dobopiyamu ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina ki mu kuduba nau tagarara-sinimoto manako nau wadisinimoto susinimoto poyo. Nau mibai posugani ko mara apeya eyaka kewoyagisi eweya ka nau ade iyasugani kirani uburani.” ");
INSERT INTO gdn_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Iyesu e powagana sisiyai matarau inako wagubu ki pokere apunu Pita kanibu Iyesu bananapupu mu mubo mena paeretagubu manako e Iyesu sisibapupu. ");
INSERT INTO gdn_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ko Iyesu wirawena e tadeyau kabukabuwa ragidai emitapu manako denai Pita sisibapupu, wagubu ke; “Pita, kau ka Seitani ki pokere nau taganeya kayanuwagi. Kau ka eba nau Mamai God e nuwaiya badidi ki nuwegei ko kau iyapana kaina mu notamaga ki nuwegei.” ");
INSERT INTO gdn_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Iyesu ubupu iyapana ropani kawaya ade e tadeyau kabukabuwa ragidai mete kina ki mu nene wagubu bautagubu manako tadebu, wagubu ke; “Iyapana nima nuwaiya ka nau ewaneya kayawagana wainapiyau ki ka gwedegwede e eya iyai nene waina-piyau ki kuduba e kamadini manako nau ripa korosi kawareya makarisugani ki maba e mete bita makari nau pokanere bananapana ki kudeya e eba wainapoto ko kasiyarai kawaya e eya korosi ki kawarapoto yabadini nau ewaneya uburoto. ");
INSERT INTO gdn_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Iyapana nima e ebo iyai karako nene wainapiyau ki ka e eya iyai ewa nene ki e kaupiyau. Ko iyapana nima nau pokanere ade nau yonani bagi kawaya ki pokaiya e eya iyai karako nene kaupiyau ki ka e iya mibai aita ewa yadini. ");
INSERT INTO gdn_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Iyapana mosi e eya iyai karako nene wainapiyau ade waira gwedegwedei kuduba, madega kauwagau madega posiwagau ki tepiyau manako poyagisi, ki ka e poyagisi makeya ka e gwedegwedei kuduba ki kamadini kayayagisi ko denai mo eba yadini. E eya iyai mibai ki e kaupupu kewowena. ");
INSERT INTO gdn_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","E ebo gwede-gwedei ki pokaiya iya mibai ki ade wadana ki yawatai mo pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Mara karako idiwei ki rabineya ka iyapana mu mubo notamaga berokoi pokaiya kwae-tagamu iwu ade Mamanuga God bameya rauru kawakawara ki berai maba kwaiwagamu idiwu. Ki pokere nima nau pokanere bo nau yonani pokaiya iyapana ki mu yabaramugu midimamayagisi ki ka nau Kunumau Kawapuwani Apunai uburani nau Mamai e tanai pokaiya nau aneyaniyoma bagi kawaya mete wirasugani bausugani makeya ki ka nau ridi bo apunu ki mete midimamapani.” ");
INSERT INTO gdn_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Iyesu mu ade tadebu, wagubu ke; “Nau yonani yau nidiyakani ki wi naigida mena wainapumuri; Wi yewe idiwu ragidai Mamanuga God e gari rabineya idiwana ki kasiyarai matara-yagisi wi yabugere empumuri were ewa ka wi dai popoiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Mara ida daikere kewowena daikere eyaka mena ki eweya ka Iyesu ubupu apunu Pita yo Diyemesi yo Diyoni waratapu mu muga mena kweya kawaya mo yampu kwauneya posi-tagubu. Mu Iyesu empamawa idiwa ka e kiyabui ade e midi kuduba wirawena ebo wenawena ki mu emupu, ");
INSERT INTO gdn_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ade e midi tatamai poe kawaya ki mete wirawena nainiwara kawareya wadawa ki mu mete emupu. Iyapana gwede-gwede bigibigi ki taniwagana siruwa-pemei ki tanai ka maraitau ko e midi tatamai poe ki tanai ka bagi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Mu inako empamawa idiwa ka oragai ragidai Eraidiya yo Mosisi Iyesu bameya mataratagubu mete yona-tagamawa ubumawa ki mu mete emitampu. ");
INSERT INTO gdn_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Emitamawa ka apunu Pita ubupu Iyesu sibu, wagubu ke; “Nidiyei Kabukabuwa Apunai, nu yewe wi mete idiwei ka bagi kawaya ki pokere karako ka nu nabonabo apeya eyaka yewe waditamamu, mosi ka kau nene, mosi ka apunu Mosisi e nene, ade mosi ka apunu Eraidiya e nene.” ");
INSERT INTO gdn_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Apunu Pita e kowaiyoma apeya ki mete kina kudu ebotau wainapamawa ki pokere e babawena yona ki wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ki makeya ka oroguma kawapu mu ruputapu manako bonana mosi oroguma rabineya mete bauwena, wagubu ke; “Yau ka nau Gubagani. Nau nuwaneya po eyo ki pokere e mena yonai ki wi wainapiyoi idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Mu bonana ki wainapamawa ka mu kokakokaratagubu notamaga babawena. Mu yabu tamawa ko mu iyapana mo eba emupu ko Iyesu e eya mena ika uburawa emupu. ");
INSERT INTO gdn_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Mu kweya were wiratagubu kawamawa ka Iyesu mu umunumaga umapu, wagubu ke; “Wi gwedegwede kuduba karako yabugere emupu ki sisiyai wi iyapana eba tadeyoi. Nau Kunumau Kawapuwani Apunai posugani ade iyasugani were ka wi nau sisiyani yau iyapana tademuri.” ");
INSERT INTO gdn_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","E wagubu ki mu e umunui wadu-mupu ko mu mubo mubo deni deni manu kasiwaratagamawa, tagamawa ke; “E powagana ade iyawagana yonai wagubu ki mibai ka badidi?” ");
INSERT INTO gdn_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Mu inako tagubu manako wiratagubu Iyesu manumupu, tagubu ke; “Mamanuga God e gorai kataimugu ragidai ka badidi pokere oragai apunai Eraidiya yabiri bauwagana ki nana tagamu?” ");
INSERT INTO gdn_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","13","Mu inako tagubu ko Iyesu denai tadebu, wagubu ke; “Mu apunu Eraidiya nene tagamu ki mibai, ko nau suwagani wainapumuri; Oragai apunai Eraidiya e ka ororeya mena wirawena bauwena manako iyapana e bameya berokoi badidi kwaetagamana wainamupu ki mu Mamanuga God e okai apunu Eraidiya nene wagubu ki makeya makeya mena kwaetagubu. Apunu Eraidiya e ororeya mena bauwena gwedegwede kuduba okukunawena kewowena nau Kunumau Kawapuwani Apunai nau yawatani mebu. Ko Mamanuga God e okai nau nene badidi wagubu ki wi mete wainapumuri. Oka ki wagubu da iyapana aita ubumoto Kunumau Kawapuwani Apunai nau tagararasinimoto manako bita midi makari tegeni.” ");
INSERT INTO gdn_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Iyesu e tadeyau kabukabuwa ragidai apeya eyaka ki mete kweya kawareya ade wiratagubu kawamawa da kweya kerareya bautagamawa ka mu kowamuguma ika kamaditampu ragidai ki iyapana ropani kawaya mete idimpu wiwirampu ika idiwa emitampu. Mu ka iyapana kawakawai Mamanuga God e gorai kataimugu ragidai mete yona deni deni tagamawa kasiwara idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Iyapana ika idiwa ki Iyesu yabadawa emupu ka mu wakapa giritagubu manako garugaru mena e diriwai bameya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ko Iyesu e tadeyau kabukabuwa ragidai ki manutapu, wagubu ke; “Wi gwede yonai deni deni yewe mu mete iwagamawa kasiwara idiwa?” ");
INSERT INTO gdn_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","E inako wagubu manako apunu mosi iyapana paunamugu ika uburawa ki bauwena denai wagubu ke; “Nidiyei Kabukabuwa Apunai, nau karako nau gubagani wadubuwani kau bamageya bausugu-buwani mibai ka keyai berokoi mosi e rabineya tondau ki pokere e yabarai babawena yona eba wagau. ");
INSERT INTO gdn_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Keyai berokoi ki nau gubagani wadau wairau kwenupiyau manako e umunui gipoporai bauwagau uwarai sisiripiyau manako e idai kerarai kuduba patoto-tagamu. Nau kau tadeyei kabukabuwa ragidai keyai berokoi ki siwakeke-pamana ki nana tadebuwani ko mu siwakekemupu ko e eba bauwena kayawena.” Apunu ki inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Iyesu yona ki wainapupu manako iyapana emitapu tadebu, wagubu ke; “Wi nau eba sumasiniyamu ragidai, wi nau matesiniyamu idiwu. Nau mara badibadi yabaranugu wi mete yewe idiwomu da wi nau sumasinimuri? Nau mara badibadi wi bitaga kawaraponi yaroni tondoni? Ko baganai, munu ki wadumuri kebomuri da nau e empani.” ");
INSERT INTO gdn_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Iyesu inako wagubu manako iyapana dai kayatagubu munu ki wadumpu e bameya bautagubu. Mu e bameya bautagamana kwaetagamawa ka keyai berokoi ki Iyesu empupu manako munu ki wadubu kwisipupu gwairiwena wairau ukwapu wiriwiri-wagawa pisi kandawa e umunui gipoporai bauwagawa. ");
INSERT INTO gdn_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Munu ki inako kwaewagawa ki Iyesu empupu manako e wirawena munu ki mamai sibu, wagubu ke; “Kau gubagagi kwamura badibadi inako kwaewagawa?” Ko apunu ki wagubu ke; “E munu marai munta makeya berokoi yau banana-pupu. ");
INSERT INTO gdn_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Keyai berokoi yau nau gubagani mara ropani kawaya wadawa ku kawareya kwenupiyawa mata urana po ki nana kwaewagawa. E awanau kwenupiyawa nonai kubarana ki nana inako mete kwaewagawa. Ki pokere nau nidiyani wainapi; Kau karako nu nuwaboyanuga wainapiyei bo pa mena? Kau kasiyaragi mete kina ki kau nuwagi manako nau gubagani iyayagisi.” Apunu ki inako wagubu, ");
INSERT INTO gdn_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ko Iyesu denai e sibu, wagubu ke; “Kau badidi pokere inako nuwegei? Kau nau sumasiniyei bo eba sumasiniyei? Kau nau sumasini ki nau gwedegwede kuduba kau bamageya kwaesugani.” ");
INSERT INTO gdn_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Iyesu yona ki wagubu ka munu ki mamai e bonanai ragiragi kawaya wagubu ke; “Nau sumaniyakani ko nau notani mete apeya apeya ki pokere kau waitasini nau notani wirapi da nau kau mena sumaniyoni.” ");
INSERT INTO gdn_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Ki makeya ka Iyesu wirawena iyapana ropani kawaya e bameya ika kebomawa emitapu ki pokere e wira-wena e bonanai ragiragi kawaya pokaiya keyai berokoi ki siwakekepupu sibu, wagubu ke; “Kau sigi ka Keyai Berokoi Wenagugi Kenekenei Umunugi Bodabodai. Nau karako nidiyakani; Kau baunuwagi deni mena kayanuwagi ko ewa mo eba wiranuwagi munu yau rabineya.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Keyai berokoi ki Iyesu yonai wainapupu ka e kwewena munu ki wadubu ragiragi kawaya kwisikwisi-pupu wairau kwenupupu manako matarau bauwena kayawena. E bau-wena kayawena makeya ka munu ki powena maba ika wairau ukwapu ki pokere iyapana kuduba tagubu ke; “Munu ki wana powena.” ");
INSERT INTO gdn_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ko Iyesu kanibu munu ki e idaiya wadubu bagipupu manako munu ki iyawena kipu ubupu. ");
INSERT INTO gdn_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Iyesu tawa rabineya kanibu manako e tadeyau kabukabuwa ragidai e bameya bautagubu weki gwaiya giyansu mena e simupu, tagubu ke; “Nu keyai berokoi ki siwakekemipi ko e badidi pokere eba bauwena kayawena?” ");
INSERT INTO gdn_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ko Iyesu denai tadebu, wagubu ke; “Guriguri mena pokaiya ka wi keyai berokoi yau kwaitana siwakekepumuri manako e baiyagisi kayayagisi ko wi inako eba guriguriwagi ki ka e eba baiyagisi kayayagisi.” Iyesu inako tadebu. ");
INSERT INTO gdn_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","31","Mu tawa ki kamadumpu manako tawana Gariri bautagubu kayatagubu. Iyesu nuwaiya ka e tadeyau kabukabuwa ragidai mu mubo mena yona mo kabuwatamana ki nana wainapiyawa ko e eba nuwaiya iyapana kuduba e yonai ki kataitagamana ki nana. E tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Iyapana ubumoto Kunumau Kawapuwani Apunai nau nidani tagisi manako wadisinimoto iyapana dai mu idamaga rabineya nau tamusinimoto da mu nau susinimoto poyo. Mu nau susinimoto poyo ko mara apeya eyaka kewoyagisi eweya ki nau ade iyasugani kirani uburani.” ");
INSERT INTO gdn_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Iyesu inako wagubu ko e tadeyau kabukabuwa ragidai yona ki eba waina-mupu. E mibai badidi wagubu ki mu e manupamana ko mu kudu mete waina-pamawa ki pokere e eba manumupu. ");
INSERT INTO gdn_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Mu natere Kaponiyamu bautagubu tawa rabineya yampu ka Iyesu e tadeyau kabukabuwa ragidai manutapu, wagubu ke; “Yawatau ka wi gwede yonai deni deni iwagamawa kasiwara kebomawa?” ");
INSERT INTO gdn_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ko nima mu paunamugu ka kawaya esida ki sisiyai mu deni deni tagamawa kasiwara kebomawa ki pokere Iyesu mu manutapu ki ka mu midimama waditapu kerekereretagubu idiwa ko yona denai mo eba tagubu. ");
INSERT INTO gdn_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ko Iyesu kwarisiwena tondubu manako e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya (12) ki tadebu, wagubu ke; “Iyapana nima yabiri uburana wainapiyau ki ka e naiya yabiri eba uburoto ko e kwarisiyagisi e kowaiyoma mu bigabigamaga kwae-yogono.” ");
INSERT INTO gdn_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","E inako wagubu manako munu marai munta mo wadubu e wereyeya tapu manako tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Iyapana nima nau sini pokaiya munu yau maba e diriwai kwaewagau ki ka e nau diriwani mete kwaewagau. Ade iyapana nima nau diriwani kwae-wagau ki ka e eba nau mena diriwani kwaewagau ko e nau Tonosinibu Apunai e diriwai mete kwaewagau.” ");
INSERT INTO gdn_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Iyesu inako wagubu manako apunu Diyoni ubupu e sibu, wagubu ke; “Nidiyei Kabukabuwa Apunai, apunu mosi kau sigi pokaiya keyai berokoi mo siwakekepiyawa ki nu emipi ko e ka eba nu mete ewapuru iwei ki pokere e badidi kwaewagawa ki nu e kamadana ki nana simipi.” ");
INSERT INTO gdn_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Apunu Diyoni inako wagubu ko Iyesu denai wagubu ke; “Ae, wi e inako eba bodampena mibai ka iyapana nima nau sini pokaiya matakira kwaeyagisi ki ka e garugaru mena eba wirayagisi nau sini giripoto. ");
INSERT INTO gdn_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Nima nu eba tagarara-niyau ki e ka nu waretanuga ko eba nu iyaranuga. ");
INSERT INTO gdn_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Nau yona mibai nidiyani wainapumuri; Wi ka nau iyapananiyoma ki pokere iyapana nima wi diriwaga kwaeyagisi awana kasiga bo inako mo wi negeni ki ka aita ewa ka e denai bagi kawaya mo bananapoto.” ");
INSERT INTO gdn_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Iyesu inako wagubu ade tadebu, wagubu ke; “Iyapana nima uburoto munu marai munta nau sumasiniyau yau maba e kerareya yadini da e nau kamadisiniyoto ki iyapanai ka aita ewa bita kawaya daganani mo bananapoto. Akae, iyapana e wadumpena bowa kawaya mosi taburuba pokaiya kwi-mpena e gobaiya umampena egi kwenumpena ki ka e nene baganai. ");
INSERT INTO gdn_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","44","Ki pokere, kau idagi daikere berokoi kwaenugana ki nana weyaweyaniyau ki kau idagi ki mei puru kwenupi. Kau idagi daikere bagi ki mena pokaiya umowa wadowa da ewa iya maramara tondana kaniyana ki iyai bananapi ki ka bagi kawaya. Ko kau idagi berokoi ki mete inako umowa wadowa da ewa mata nonarai tawaneya kayanuwagi ki ka berokoi kawaya. Mata nonarai ki eba poyagisi ko maramara kau uraniyono tondono. ");
INSERT INTO gdn_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","46","Ade kau keraragi daikere berokoi kwaenugana ki nana weyaweyaniyau ki kau keraragi ki mei puru kwenupi. Kau keraragi daikere bagi ki mena pokaiya kanenenugowa umowa wadowa da ewa iya maramara tondana kaniyana ki iyai bananapi ki ka bagi kawaya. Ko kau keraragi berokoi ki mete inako umowa wadowa da mu ewa kau mata nonareya kwenunimoto ki ka berokoi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Ade kau yabugi berokoi kwaenugana ki nana weyaweyaniyau ki kau yabugi ki wadi toporu kwenupi. Kau yabugi daikere bagi ki mena pokaiya umowa wadowa da ewa Mamanuga God e kasiyarai pokaiya e gari rabineya kani tondowa ki ka bagi kawaya. Ko kau yabugi berokoi ki mete umowa wadowa da mu ewa kau mata nonareya kwenunimoto ki ka berokoi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","49","Mata ki tawaneya ka ‘motamota rasirasi wi rabinagau idiwono ki eba popotagisi ade mata nonarai ki mu eba popomoto.’” Iyesu inako wagubu manako ade tadebu, wagubu ke; “Puyo kuduba Mamanuga God bameya nakapiyamu ki midiyawagana ki nana ka mu aidaba mete kawareya kweyamu wira. Ko wainapumuri; Mu aidaba pasumu ku wenawagau ki maba ka mata kaworoto iyapana kuduba wi uraniyoto manako Mamanuga God yabuiya ka midiyai ewa wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Aidaba ki ka gwede mo midiyai bagi kawaya ko aidaba ki kwerereyagisi midiyai ki kewoyagisi ki ka wi badidi maba kwaiwagi da aidaba ki midiyai ade wenapoto? Ki pokere, aidaba midiyai bagi kawaya ki maba wi mete inako idiwoi ade deni deni kwayuba kasiwaraiwogoi idiwoi.” Iyesu waigugu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Iyesu tawana ki kamadubu manako kayawena kaniyawa da tawana Diyudiya bauwena ka e awana Diyoudani purupupu papasi daikere bauwena tondawa. Iyapana ropani kawaya e bameya bautagubu kwagara-mupu idiwa manako e ubupu Mama-nuga God e yonai mu tadeyawa kabu-kabuwa tondawa. E tawana tawana umawa wadawa ki ka e maramara inako mena kwaewagawa umawa. ");
INSERT INTO gdn_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","E ika tondawa ka Parisi ragidai dai bautagubu e manupamana da e yona mo paerepana manako mu ki pokaiya e wadamana ki nana e bameya bautagubu manumupu, tagubu ke; “Apunu mosi e ebo nuwaiya e wainai ragipana waina-piyau ki ka baganai bo eba baganai?” ");
INSERT INTO gdn_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Mu inako tagubu ko Iyesu denai manutapu, wagubu ke; “Oragai apunai Mosisi gora tapu e ki nene badidi wagubu?” ");
INSERT INTO gdn_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ko mu denai tagubu ke; “Oragai apunai Mosisi e gora inako tapu, wagubu ke; ‘Apunu mosi e wainai ragipana wainapiyau ki ka e yabiri uburoto anika meyana puru ki yonai okapoto manako ewa ridi ki tonopoto deni mena kayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Mu inako tagubu ko Iyesu denai tadebu, wagubu ke; “Wi rabinaga ka ragiragi kawaya ki pokere ka oragai apunai Mosisi gora ki wi nene inako tapu. ");
INSERT INTO gdn_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Ko naiya mena, kunuma waira kerareya Mamanuga God iyapana yamanatapu makeya ki ka e ridi yo apunu ewapuru yamanatapu. ");
INSERT INTO gdn_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","E inako kwaewena ki pokere apunu mosi karako e inai mamai kamaditamini ridi mosi uworoto manako mu apeya wainai nobomoi ewapuru eyaka mena idiwono. ");
INSERT INTO gdn_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Naiya ka mu mubo mubo idiwa ko karako ka mu ewapuru eyaka mena inako idiwono. ");
INSERT INTO gdn_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Ki pokere waina-pumuri; Mamanuga God ridi yo apunu inako dibitapu ki ka iyapana eba baitagisi mu wade purupurutamini.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Mu ade wiratagubu yampu tawa rabineya idiwa ka e tadeyau kabu-kabuwa ragidai bautagubu Iyesu simupu da e yona ki kawareya mu ade kabuwatamana ki nana tagubu, ");
INSERT INTO gdn_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ki pokere Iyesu mu ade tadebu, wagubu ke; “Apunu mosi uburoto e wainai ragipoto manako ewa kayayagisi ridi kudubai mosi uworoto ki ka apunu ki e wainai yabiri ki rauru kawakawarapupu. ");
INSERT INTO gdn_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ade ridi mosi uburoto e nobomoi ragipoto manako ewa kayayagisi apunu kudubai mosi uworoto ki ka ridi ki e nobomoi yabiri ki mete rauru kawa-kawarapupu.” ");
INSERT INTO gdn_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Iyapana munumuguma tetampu kebompu Iyesu bameya bautagubu da e idai mu kawarimugu tarana waditamana bagi ki nana. Ko e tadeyau kabukabuwa ragidai ubumpu munu rasi ki inamuguma mete kina nakaritampu baiyonotampu, tagubu ke; “Wi kaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Mu inako tagamawa ki Iyesu wainapupu manako e rabinai beroko-wena tadebu, wagubu ke; “Munu rasi nau bamaneya kebomu ki wi eba bodatamiyoi mibai mu ka nau Mamai God e gari rabineya e kasiyarai pokaiya bagi kawaya idiwono. ");
INSERT INTO gdn_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Nau yona mibai nidiyani wainapumuri; Iyapana kawakawai wi notaga munu rasi mu notamaga maba ade wi mu maba Mamanuga God e umunui wadumuri sumapumuri ki ka wi e bameya mete kaiwuri e gari rabineya bagi kawaya idiwoi. Ko wi notaga eba munu rasi mu notamaga maba ki ka wi e bameya eba kaiwuri ade e gari rabineya ki wi eba idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Iyesu inako wagubu manako munu rasi ki taiyatapu e idai mu kawarimugu tapu manako waditapu bagi. ");
INSERT INTO gdn_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Iyesu ade kayawagana kwae-wagawa ka apunu mosi garugaru mena bauwena e yabareya kwarisiwena e ramatai kawareya ubupu manako sibu, wagubu ke; “Sidiyei Kabukabuwa Apunai bagi, nau badidi kwaesugani da nau iya waunai bananapani maramara tondoni kaniyoni?” ");
INSERT INTO gdn_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","E inako wagubu ko Iyesu denai wagubu ke; “Kau gwede nana nau apunu bagi sidibi? Mamanuga God e eya mena ka bagi. ");
INSERT INTO gdn_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ko kau manusinibi ki denai nau nidiyani; Mamanuga God e gorai kuduba ki kau kataigeya; ‘Iyapana mo eba mini poyo; Kau waretagi eba raurupi e wainai eba wadi; Gwede-gwede mo eba kuwanuwagi; Kau waretagi badidi kwaeyagisi emani ki kau bera eba nuwagi; Kau rabinageya bera berokoi mo eba wainapiyowa ade iyapana eba beratamiyowa; Kau inagi mamagi tagisi ki mu umunumaga wadi ade mu naigida mena wiwiratamiyowa.” ");
INSERT INTO gdn_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Iyesu yona ki wagubu ka apunu ki denai e ade sibu, wagubu ke; “Sidiyei Kabukabuwa Apunai, nau munu marai munta tondekeya makeya kaniyekeya da karako ka nau Mamanuga God e gorai tapu ki kuduba nau naigida mena wiwirapekeya tondekeya.” ");
INSERT INTO gdn_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","E inako wagubu ko Iyesu apunu ki empupu e nene wainapupu manako sibu, wagubu ke; “Kau gwede mo eyaka mena yau eba kwaenugibi; Kau kaya-nuwagi kau gwedegwedegi kuduba tepi iyapana gwedegwedemaga pa mena ragidai tage manako ewa yabi nau ewaneya uburi. Kau inako kwaenuwagi ki kau denai bagi kawaya mo aita kunumau bananapi.” ");
INSERT INTO gdn_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Apunu ki e gwedegwedei marai kawai ropani kawaya ki pokere e Iyesu yonai ki wainapupu ka e notai kauwena e gwedegwedei nene wainapiyawa manako e nuwaboyawena Iyesu eweya eba kayawena ko nuwasiyasiya nene e tagai wirapupu deni mena kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Iyesu apunu ki kayawena empupu ka e wirawena e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Iyapana gwedegwedemaga ropani kawaya ki Mamanuga God e umunui wadamana sumapamana ade e gari rabineya kaiwana idiwana ki ka ragiragi kawaya.” ");
INSERT INTO gdn_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","E inako wagubu ka e tadeyau kabukabuwa ragidai mu notamaga babawena. Ko Iyesu mu ade tadebu, wagubu ke; “Mununiyoma, nau nidiyani wainapumuri; Iyapana Mamanuga God sumapamana ade kaiwana e gari rabineya idiwana ki ka ragiragi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Yawata ki katamurui ka tainugu umunai ki maba. Papa kawaya ‘kameru’ kwaitana tainugu umunai ki teyagisi ki ka e daikere eba baiyagisi kayayagisi mibai ka tainugu umunai ka marai munta ko papa ki ka kawaya. Ko nau suwagani wainapumuri; Papa kawaya ‘kameru ‘tainugu umunai ki teyagisi ki ka ade matarau ko iyapana gwedegwede-maga ropani kawaya Mamanuga God sumapamana e gari rabineya kaiwana idiwana ki ka ragiragi kawaya.” ");
INSERT INTO gdn_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Iyesu tadeyau kabukabuwa ragidai yona ki wainamupu ka mu notamaga kowena kodabamaga kamupu manako tagubu ke; “Akae, inako ki ka nima iya waunai yadini?” ");
INSERT INTO gdn_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Mu inako tagubu ko Iyesu mu emitapu manako denai tadebu, wagubu ke; “Iyapana wi wiga mena iya ki eba wadumuri ko Mamanuga God wi iyaniyana yagisi ki ka wi e bameya kaiwuri e gari rabineya e kasiyarai pokaiya idiwoi. Mamanuga God e badidi yagisi ki e umuneya ka gwedegwede kuduba wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Iyesu inako wagubu ko apunu Pita ubupu e sibu, wagubu ke; “Kau wainapi; Nu ka gwedegwedenuga kuduba kama-dimpi kau ewageya kaigibi ki pokere denai ka nu gwede yadamu?” ");
INSERT INTO gdn_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Apunu Pita inako wagubu ko Iyesu denai wagubu ke; “Nau mibai suwagani wainapumuri; Wi gwedewau nau pokanere bo nau yonani bagi kawaya yau pokaiya wi tawaga bo wi kokoraga bo wi inaguma, mamaguma, yowaguma, tataguma, munuguma bo inako ki kuduba kamaditamuri manako kaiwagi tawana mo idiwoi, ");
INSERT INTO gdn_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ki ka denai wi tawaga yo wi kokoraga ropani-yagisi ade iyapana ropani kawaya wi inamamatamuri yowatatatamuri gubagatamuri idiwoi. Ko wi nau Mamai e umunui inako wadoi kwaiwogoi ki ka iyapana dai mete baitagisi wi girini-moto. Ko mara waunai baiyagisi ki makeya ka wi iya mara mara idiwana kaiwana ki iyai wadumuri. ");
INSERT INTO gdn_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Iyapana gwedewau yewe wairau kawakawaya-tagubu idiwu ki mu ka mara mosi maimeretagisi ewa ubumoto. Ade iyapana gwedewau karako maimere-tagubu idiwu ki mu ka mara mosi kawakawayatagisi yabiri ubumoto.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Mu kayatagubu natere kawaya Diyerusaremu yawateya yamawa ka Iyesu yabiriwena ko e tadeyau kabu-kabuwa ragidai mu notamaga kowena e eweya kayatagubu. Iyapana dai mu ewamugu yamawa ki mu mete kudu wainapamawa. Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya (12) ki mu nene ade wagubu kaimpu e madaneya ubumpu manako iyapana e bameya badidi kwaetagamana ki sisiyai e tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Nau suwagani wainapumuri; Nu karako natere Diyerusaremu kaigamu ki ka apunu mosi uburoto Kunumau Kawapuwani Apunai nau yogoni yagisi manako iyapana kawakawai, Mamanuga God bameya dobopiyamu ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina ki mu idamaga rabineya nau tamusiniyoto. Mu idamaga rabineya tamusiniyoto manako mu ubumoto mu idamaga gurai nau naurineya ugwadisinimoto ragiragi, tagisi ke; ‘Kau kaubo beragi ki pokere karako denai ponuwagi.’ Mu inako tagisi manako ubumoto nau wadisinimoto iyapana kwaiyanai ragidai mu idamaga rabineya tamusinimoto, ");
INSERT INTO gdn_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","manako mu ubumoto nau waegeyageyamasinimono gwaigwitasinimono tepoteposinimono manako ewa susinimoto poyo. Nau mibai posugani ko mara apeya eyaka kewoyagisi eweya ka nau ade iyasugani kirani uburani.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Apunu Tabadi e gubagaiyoma Diyemesi yo Diyoni kaimpu Iyesu bameya bautagubu manako manumupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, nu nuwanugu ka kau gwede mosi nu nene kwaenuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Mu inako tagubu manako Iyesu denai wagubu ke; “Wi nuwagau gwede ki wi karako nau kabuwasinimuri da nau wainapani.” ");
INSERT INTO gdn_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","E inako wagubu, manako mu tagubu ke; “Nu nuwanugu ka yau kena; Kau aita ewa Mamanuga God e gari rabineya e taneya tondowa makeya ki kau nuwagi manako nu apeya kau madanigeya idiwomu, mosi kau idagi garu deneya ade mosi kau idagi tenene ki deneya.” ");
INSERT INTO gdn_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Mu inako tagubu ko Iyesu denai tadebu, wagubu ke; “Wi yona baba-piyamu ki pokere wi inako sidiyamu. Nau nuwaboya nene awana suwakarai kubarani ki wi mete kubamuri baganai bo? Nau nuwaboya nene siruwasugani ki wi mete inako siruwaiwagi bo?” ");
INSERT INTO gdn_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“Ena, nu baganai.” Mu inako tagubu ko Iyesu mu ade tadebu, wagubu ke; “Baganai, nau nuwaboya nene awana suwakarai kubarani ki wi mete kubamuri ade nau nuwaboya nene siruwasugani ki wi mete inako siruwaiwagi. ");
INSERT INTO gdn_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ko iyapana gwedewau nau idani garu deneya bo nau idani tenene deneya idiwana ki sisiyai ka eba nau suwagani. Iyapana gwedewau nau Mamai mu watamaga ki winepupu ragidai ki mu mena ka aita kaiwoto wata ki idiwono.” ");
INSERT INTO gdn_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Iyesu e tadeyau kabukabuwa ragidai dai ki apunu Diyemesi yo Diyoni mu sisiyamaga ki wainamupu ka mu bamamugu rabinamaga pupuwena. ");
INSERT INTO gdn_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ko Iyesu ubupu e tadeyau kabu-kabuwa ragidai kuduba mu nene wagubu bautagubu manako tadebu, wagubu ke; “Wi kataigau da iyapana kwaiyanai ragidai mu kawakawai-muguma kasiyaramaga pokaiya gwede mo tagisi ki ka mu kobamugu idiwu ragidai ubumoto mu umunumaga yadini makeya makeya kwaetogomono. Ade iyapana kawakawai ki mu kawarimugu esida ragidai badidi tagisi ki ka kawakawai ragidai ki ubumoto mu umunumaga mete yadini makeya makeya kwaetogomono. ");
INSERT INTO gdn_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Ko wi bamagau ka inako pa mena. Wi mo nuwagau kawaigamana wainapiyamu ki ka wi naiya kwarisiwagi wi kowaguma mu bigabigamaga kwaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ade wi mo nuwagau yabiri ubumana waina-piyamu ki ka wi naiya kwarisiwagi kowaguma mu ewamugu ubumoi ade mu bitamaga kawarapiyoi. ");
INSERT INTO gdn_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Nau Kunumau Kawapuwani Apunai mete kina inako kwaesugakani. Eba iyapana ubumana nau bigani kwaetagamana ki nana bausugubuwani ko nau uburana mu bigamaga kwaesugana ki nana nau bausugubuwani. Nau posugani manako nau pokanere ka iyapana ropani kawaya mu bigimaga kuduba rikayagisi deni mena gogayagisi. ");
INSERT INTO gdn_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Mu kayatagubu kaiwa da natere Diyeriko bautagubu ade kayatagubu kaiwa ka iyapana ropani kawaya Iyesu e tadeyau kabukabuwa ragidai mete kina bananatampu mete kayatagubu. Yawata kwaiya ka apunu mosi e yabui kenekenei bowa madai nene gene-wagawa ika tondawa. Apunu ki ka apunu Simiyasi e gubagai si ka Basimiyasi. ");
INSERT INTO gdn_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tawana Nasareta apunai Iyesu ika yabadawa sisiyai ki apunu Basimiyasi wainapupu manako e bonanai ragiragi kawaya wena siyapu, wagubu ke; “Iyesu, oragai apunai Dewida e wenai, kau nau nuwaboyani wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","E inako wagubu ka iyapana bau-tagubu e nakarimupu simpu tagubu ke; “Kau yona kamadi.” Mu inako tagubu ko e bonanai ragiragi kawaya kawareya kawareya ade wena siyanawa, wagawa ke; “Apunu Dewida e wenai, kau nau nuwaboyani wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Iyesu ubupu iyapana tadebu, wagubu ke; “Wi apunu ki simuri da e yabadini.” E inako wagubu manako iyapana kaimpu apunu yabui kenekenei ki simupu, tagubu ke; “Kau kiri uburi kau notagi kasiyara wainapiyowa. E kau nene wagau nawananiyau.” ");
INSERT INTO gdn_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Mu inako tagubu wainapupu ka apunu Basimiyasi e aukwarai wadubu waka kwenupupu bagi ubupu manako Iyesu diriwai garugaru mena kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","E bameya bauwena ka Iyesu wirawena e empupu manako manu-pupu, wagubu ke; “Kau nuwageya nau gwede kwaesugani kau bamageya?” Ko e denai wagubu ke; “Sidiyei Kabukabuwa Apunai, kau yabuni wadi papi da nau tawana empani.” ");
INSERT INTO gdn_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ko Iyesu denai wagubu ke; “Ki baganai, kayanuwagi. Kau sumasinibi ki pokere kau karako iyanugibi.” Iyesu yona ki wagawa makeya ka apunu ki e yabui papupu tawana empupu manako e kipu ubupu Iyesu eweya kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Mu kebomawa da natere Diyerusaremu bautagamana kwaetagamawa ka mu ripa ‘oripi’ wenatagubu kweyai ki yamupu manako natere marai munta mo si ka Betani bautagubu kamadumpu kayatagubu da natere mo si ka Bepage bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Ika bautagubu ka Iyesu e tadeyau kabukabuwa ragidai apeya tadebu, wagubu ke; “Wi yabiriwagi natere buri yabaranugu ki kaiwagi manako papa ‘donki’ mosi taburuba pokaiya yawata uwareya kwimupu uburau ki ika empumuri, ko papa ‘donki’ ki kawareya ka iyapana mo naiya eba kayawena. Wi papa ‘donki’ ki e taburubai rikapumuri manako bananapumuri kebomuri. ");
INSERT INTO gdn_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Ko iyapana mo wi eminiyoto, yagisi ke; ‘Wi gwede nana inako kwaiwagamu?’, e inako yagisi ki ka wi denai e simuri, iwagi ke; ‘Nu Kaiwawonuga papa ‘donki’ yau nene wagubu ko e garugaru mena ade tonopoto wirayagisi baiyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Iyesu inako wagubu manako e tadeyau kabukabuwa ragidai apeya ki kayatagubu papa ‘donki’ buri yawata uwareya tawa katamuruiya kwimupu ki emupu manako mu kaimpu papa ki rikapamupu. ");
INSERT INTO gdn_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","Rikapamawa ka iyapana ika idiwa ragidai mu emitampu manako manutampu, tagubu ke; “Wi gwede nana asusu baigubu papa ‘donki’ munai yau e taburubai rikapiyamu?” ");
INSERT INTO gdn_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Iyapana ki inako tagubu ko Iyesu tadeyau kabukabuwa ragidai ki Iyesu badidi tadebu ki mu makeya makeya iyapana tademupu manako iyapana ki denai tagubu ke; “Baganai, papa ‘donki’ ki wadumuri kaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Mu papa ‘donki’ ki wadumpu bautagubu manako mu muga midimaga tatamai rikatampu tempu papa ki tagaiya nakamupu manako Iyesu yapu papa donki ki kawareya tondubu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Tondubu kayawena kaniyawa ka iyapana ropani kawaya mu mete kina mu midimaga tatamai rikatamawa yawatau nakapamawa ade dai ka ripa kwarai meyamawa nakapamawa da Iyesu bauwagana ki kawareya kaya-wagana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Iyapana dai yabiri-tagubu ade dai ewatagubu inako kaya-tagubu yamawa manako ewapuru mena Iyesu paraupamawa ade Mamanuga God e si tepapamawa, tagamawa ke; “Ousana kaiwa kaiwa. Mamanuga God e si nu karako tepapemei. E kau wadiniyoto bagi. Kau karako Mamanuga God e kasiyarai pokaiya baunugibi. ");
INSERT INTO gdn_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","E kau wadiniyoto bagi. Kau ka nu ripakwarakwaranuga Dewida kaiwawowena e watai wadana nu kwayubaniyana tondana ki nana baunugibi. Mamanuga God usi kunumau tondau e si nu karako tepapemei.” ");
INSERT INTO gdn_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Iyesu natere Diyerusaremu bau-wena ka e Mamanuga God e Tawai rabineya kanibu gwedegwede kuduba empiyawa wiwirapiyawa ko kemora-wagana kwaewagawa ki pokere e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya mete wira-tagubu kayatagubu natere Betani bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Mu ika ukwampu nawaru puru-wena manako natere Betani kamada-mana kwaetagamawa ka Iyesu wetei mebu. ");
INSERT INTO gdn_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","E wetei meyawa ka e yabu tapu manako ripa damaya kwarai buri empupu ki pokere e madai dai kupana wainapupu kayawena. Ko ki ka eba damaya madai kirau ki marai ki pokere e buri bauwena ka e damaya madai mo eba empupu. ");
INSERT INTO gdn_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","E kwarai mena empupu ki pokere e ripa damaya ki sibu, wagubu ke; “Kau mibigi ewa eba kiroto. Iyapana mo kau mibigi eba kupoto.” Iyesu yona ki wagubu ki ka e tadeyau kabukabuwa ragidai mu kuduba wainamupu. ");
INSERT INTO gdn_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mu natere Diyerusaremu ade bautagubu ka Iyesu kanibu Mamanuga God e Tawai rabineya kayawena manako iyapana ika deni deni nida kasiwaratagamawa idiwa ki emitapu manako nakaritapu siwakeketapu. Bowa madai deni deni nida kasiwara-tagamawa idiwa ragidai ki mu watara-maga ki e koritapupu isiyapupu ade midiwari bowa madai nene nida-tagamawa ragidai ki mu kebarimaga ki e mete tepupu isiyapupu. ");
INSERT INTO gdn_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Iyapana gwedegwede marai kawai tepamana Mamanuga God e Tawai rabineya kebomana kwaetagamawa ki ka e mu yawatamaga bodapupu, ");
INSERT INTO gdn_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","manako iyapana kabuwatapu tadebu, wagubu ke; “Mamanuga God e okai wagau; ‘Nau Tawani ki ka guriguri tawai ki rabineya iyapana tawana tawana kuduba, madega kauwagau madega posiwagau ki baitagisi nau bamaneya guriguritogomono idiwono.’ Ko wi ka yona ki eba waina-piyamu. Wi ka kuwa ragidai yewe maramara weki gwaiya kuwaiwagamu idiwu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Iyapana kawakawai, Mamanuga God bameya dobopiyamu ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina Iyesu kwaewena sisiyai ki wainamupu ka mu e minimana po yanuwei teyamawa. Ko iyapana ropani kawaya Iyesu eweya kayatagubu e yonai kasiyarai kawaya ki waina-pamawa e si tepapamawa iwa ki pokere kawakawai ragidai ki e kudeya mete wainapamawa. ");
INSERT INTO gdn_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Kemora nene ka Iyesu e kowakowaiyoma mete kina natere Diyerusaremu kamadumpu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Mu ukwampu nawaru puruwena ka mu didiburu kayatagubu kebomawa da ripa damaya ki bameya bautagubu manako ripa ki kwarai, ragai ade witai kuduba suratagubu emupu. ");
INSERT INTO gdn_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Mara yomi ka Iyesu ripa ki sibu ki apunu Pita wainapupu ki pokere e wagubu ke; “Sidiyei Kabukabuwa Apunai, kau ripa burida emani. Kau yomi ripa ki sibi ko karako ka surawena.” ");
INSERT INTO gdn_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Apunu Pita inako wagubu ko Iyesu denai wagubu ke; “Nau mibai nidiyani wainapumuri; Wi notaga eyaka mena Mamanuga God sumapumuri, ");
INSERT INTO gdn_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ki ka wi kweya buri simuri, iwagi ke; ‘Kau kiri uburi egi kayanuwagi’, ki ka kweya ki kiroto uburoto egi kayayagisi. Ko wi notaga apeya apeya notapiyoi were simuri ki ka e eba kiroto uburoto kayayagisi. Wi notaga eyaka mena iwagi ke; ‘Nau karako suwagubuwani ki wenayagisi’, wi notaga inako yagisi ki ka wi iwagubu ki wana wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Ki pokere, nau karako yona mo ade suwagani wainapumuri; Wi Mamanuga God bameya guriguri pokaiya gwede mo nene geneiwagi ki ka wi notaga eyaka mena inako notapu-muri, iwagi ke; ‘Nau karako suwagu-buwani ki wenayagisi.’ Wi inako sumaiwagi ki ka wi iwagubu ki wana e negeni. ");
INSERT INTO gdn_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Ade yona yau mete wainapu-muri; Iyapana bera berokoi mo wi bamagau kwaewena manako wi rabinaga berokowena ki ka wi naiya berokoi ki wi notagau deni mena surupumuri notagogapumuri manako ewa ubumuri guriguriwagi. Wi inako kwaiwagi ki ka Mamanuga God kunumau tondau wi wiga bigiga ki mete empoto deni mena surupoto. ");
INSERT INTO gdn_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ko iyapana mo bera berokoi wi bamagau kwaewena manako wi berokoi ki wi notagau eba surupumuri notagogapumuri ki ka Mamanuga God kunumau tondau wi wiga bigiga ki mete eba notagogapoto.” ");
INSERT INTO gdn_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mu natere Diyerusaremu ade bautagubu ka Iyesu Mamanuga God e Tawai rabineya ade kayawena manako iyapana kawakawai, Mamanuga God bameya dobopiyamu ragidai, Mama-nuga God e gorai kataimugu ragidai, ade iyapana kawakawai dai mete kina ki e bameya bautagubu, ");
INSERT INTO gdn_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","manako manumupu, tagubu ke; “Kau nima kasiyara negebu were kwaenugei? Kasiyara ki nima negebu?” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ko Iyesu denai mu tadebu, wagubu ke; “Yabiri nau wi manuniyani denai sidimuri were ewa ka nau nima kasiyara tegebu ki sisiyai wi nidiyani. ");
INSERT INTO gdn_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Nau yonani ka yau kena; Apunu Diyoni iyapana siruwatamana ki nana bauwena ki ka e Mamanuga God wagubu ki pokere kwaewagawa bo iyapana kaina mo wagubu were kwae-wagawa? Wi ki iwagi da nau wainapani.” ");
INSERT INTO gdn_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Kawakawai ragidai e manui ki wainamupu ka mu mubo mubo deni deni manu kasiwaratagubu, tagubu ke; “Nu denai iwagamu da; ‘Apunu Diyoni, e ka Mamanuga God wagubu umuneya kwaewagawa’, nu inako iwagamu ki ka apunu ki denai inako nidiyoto, yagisi ke; ‘Baganai, ko wi badidi pokere apunu Diyoni e yonai eba sumamupu?’ ");
INSERT INTO gdn_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Ko nu iwagamu da; ‘Apunu Diyoni, e ka iyapana kaina mo wagubu umuneya kwaewagawa’, nu inako iwagamu ki ka nu iyapananuguma pakasi ragidai badidi tagisi?” (Mu iyapana kudumugu mete wainapamawa mibai ka pakasi ragidai kuduba wainamupu da apunu Diyoni e ka Mamanuga God e wagubu umuneya bauwena ade e ka Mamanuga God e bonanai wainapiyawa wagawa ki apunai mosi.) ");
INSERT INTO gdn_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Kawakawai ragidai kudu mete wainapamawa ki pokere mu denai Iyesu simupu, tagubu ke; “Nima apunu Diyoni tonopupu ki nu eba katainugu.” Iyesu yona ki wainapupu ka e denai tadebu, wagubu ke; “Baganai, wi nau eba sidimupu ki pokere nima kasiyara tegebu ki sisiyai nau wi mete eba nidiyani.” Iyesu denai inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Iyesu keyakeyai mo tadebu, wagubu ke; “Apunu mosi e gari umapu manako ripa ‘waeni’ ki momai dai tepupu gari ki rabineya upu. Ki eweya ka e ripa madai ki botopamana watai yamanapupu manako iyapana e upi ki kwayubapamana ragidai wata-maga iyarau mo mete wadubu. Wadubu kewowena ka e iyapana dai nene wagubu bautagubu manako gwaiyaba-tapu, wagubu ke; “Wi nau upini yau naigida mena kwayubapiyoi manako maura marai ki makeya ka wi madai dai wi wiga tepiyoi ko dai wi nau nene nakapiyoi. Nau niya ka tawana mo kayasugani umoni da ewa marai mosi ade bausugani.” E inako wagubu manako kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Maura marai bauwena ka e ubupu e bigabigai apunai mosi ripa madai ki dai tepana ki nana upi kwayubapamawa ragidai ki mu bamamugu tonopupu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ko e ika bauwena ka mu e ripa madai ki eba kwemupu ko mu e wadumupu pa gudapamawa da tono-mupu ida kasikasi wirawena kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ki eweya ka upi ki apunai e bigabigai apunai ade mosi tonopupu manako e kayawena umawa da buri bauwena ka upi ki kwayubapamawa ragidai e mete wadumupu e debai minimupu sukwana ade midimama berai e bameya kwaetagubu manako e mete pa ida kasikasi tonomupu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ki eweya ka upi apunai ki e bigabigai ade mosi tonopupu ko e umawa da buri bauwena ka upi ki kwayubapamawa ragidai e wadumupu minimupu poyo. Upi apunai ki e bigabigaiyoma ragidai ropani kawaya inako eyaka eyaka tonotamiyawa kayatagamawa ko mu iwa da buri bautagamawa ka upi ki kwayuba-pamawa ragidai iyapana ki kuduba giritamawa pasutamawa. Dai mu taunimawa popo ade dai mu pa bidara tagemawa ida kasikasi tonotamawa kayatagamawa. ");
INSERT INTO gdn_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Mu inako kwaetagamawa yamawa da siyareya ka upi apunai ki e bigabiga-iyoma kuduba inako tonotapu kewo-wena. E eya gubagai nuwaiya po apunai ki e mena ika e bameya tondawa. E notai wagubu ke; ‘Nau niya gubagani tonopani ki ka mu e naigida mena wiwirapomoto wainapakani.’ E inako wainapupu manako e eya gubagai ki tonopupu kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","E gubagai kayawena umawa da mu bamamugu bauwagana kwaewagawa ka upi kwayubapamawa ragidai ki mu mubo mena tagubu ke; ‘Waira yau ewa wadana apunai bauwena yau kena ki pokere karako miniyamu poyo da e gwedegwedei yau kuduba ka aita nu tepamu.’ ");
INSERT INTO gdn_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Mu inako tagubu manako kaimpu apunu ki e gubagai ki deni mena minimupu poyo manako gari tagaiya kwenumupu.” ");
INSERT INTO gdn_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Iyesu keyakeyai ki wagubu manako manutapu, wagubu ke; “Waira ki apunai e gubagai powena ki bimbinai ka e badidi kwaeyagisi? Nau suwagani wainapumuri; E baiyagisi manako upi kwayubapamawa siyasiya ragidai ki tetamini namutamini manako mu upimaga ka e kowaiyoma kudubai dai tageni. ");
INSERT INTO gdn_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mamanuga God e okai tampu ki wi iyabamupu bo pa mena? Oka ki wagubu ke; ‘Wi tawa wadamu ragidai waina-mupu da e ka bebeda berokoi ki pokere kwenumupu. Ko Mamanuga God bebeda ki wadubu ade wowo bebedai kaupupu. ");
INSERT INTO gdn_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Nu Kaiwawonuga ki kwaewena ka bagi kawaya.’” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Diyu ragidai kawakawaimuguma wainamupu da Iyesu waigugu wagubu ki ka e mu nene wagubu ki pokere mu e wadamana ki nana mete wainamupu. Ko mu iyapana ropani kawaya ika idiwa mu kudumugu mete wainapamawa ki pokere mu e kamadumpu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ki eweya ka kawakawai ragidai ki ubumpu Parisi ragidai dai ade apunu Erodi e kowaiyoma dai mete kina Iyesu beraberapamana manupamana da e yona mo paerepana manako mu ki pokaiya e wadamana ki nana e bameya tonomupu. ");
INSERT INTO gdn_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Mu e bameya bautagubu manako dayaya yonai inako tagubu ke; “Nidiyei kabukabuwa apunai, nu katainugu da kau iyapana eba beratamiyei ko kau yona mibai mena nuwegei. Iyapana kawakawai kau bamageya bautagamu ki kau bera yonai mo eba nuwegei mu beratamiyei. Ade iyapana pakasi ragidai kau bamageya bautagamu ki kau mu mete eba beratamiyei yona kudubai mosi nuwegei. Pa mena. Kau maramara yona eyaka mena Mamanuga God e yonai mibai ki mena kawareya kawareya nuwegei. Ki pokere nu karako kau nidimei ki kau wainapi; Nu tawana Roumi ragidai mu kawaimaga Sita e bameya nu wairanuga denai takesi tamamu ki kau wainapiyei baganai bo eba baganai? ");
INSERT INTO gdn_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Nu takesi ki tamamu bo eba tamamu?” Mu inako tagubu, ko Iyesu e rabineya wainapupu da; ‘Mu ka nau bamaneya dayayatagamu nau kerapuneya wadamu’, ki pokere e denai tadebu, wagubu ke; “Wi gwede nana inako manusiniyamu kerapuneya wadamu? Bowa madai mo tegemuri da nau empani.” ");
INSERT INTO gdn_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Mu kayatagubu bowa madai mo wadumpu bautagubu kwemupu manako e bowa madai ki empupu tadebu, wagubu ke; “Yau ka nima keyai bowa madai yau naureya tondau? Nima si bowa madai yau naureya okapupu?” E inako wagubu ka mu denai tagubu ke; “Yau ka tawana Roumi ragidai mu kawaimaga Sita e keyai ki naureya tondau.” ");
INSERT INTO gdn_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Mu inako tagubu, manako Iyesu denai tadebu, wagubu ke; “Baganai, apunu kawai Sita nene ki wi e ebo kwemuri ade Mamanuga God nene ki wi e ebo kwemuri.” Iyesu yona ki wagubu ka iyapana ki mu notamaga kowena denai siyamana babatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ki makeya ka Sadusi ragidai dai Iyesu manupamana ki nana e bameya bautagubu. (Sadusi ragidai mu iyapana inako tadeyamu, tagamu ke; “Nu popoigamu ki ka nu ewa eba iyaigamu kimamu ubumamu.”) ");
INSERT INTO gdn_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Sadusi ragidai ki Iyesu bameya bautagubu manako e simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, oragai apunai Mosisi nu goranuga inako tapu, wagubu ke; ‘Apunu mosi e wainai munu eba wenapoto ko e nobomoi poyagisi ki ka apunu ki e yowai koboro ki uworoto manako munu e wenapoto ki aita popai apunai ki e watai yadini. ");
INSERT INTO gdn_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Karako tawana mosi ka iyapana ida daikere kewowena daikere apeya (7) ika idiwa manako mu tatamaga ridi mo uwapu. E ridi mo uwapu ko e munu eba wenapupu manako apunu ki powena. ");
INSERT INTO gdn_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","E powena ki pokere e yowai koboro ki uwapu ko e mete powena ko munu mo eba wenawena. Munu eba wenawena ki pokere e yowai ade mosi ubupu koboro ki ade uwapu manako e mete powena ko munu mo eba wenawena. ");
INSERT INTO gdn_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Mu inako kwaetagamawa yamawa da iyapana ida daikere kewowena daikere apeya (7) koboro ki uwamupu ki mu kuduba popotagubu gawarara ko munu mo eba wenawena. Ko siyareya ka ridi ki e eya mete powena. ");
INSERT INTO gdn_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kau karako nuwagi da nu wainapamu; Mara kwauneya ka iyapana popotagubu ragidai ade iyatagisi kimoto ubumoto makeya ki ka ridi ki nima wainai? Mibai ka e iyapana ida daikere kewowena daikere apeya (7) ki tauwapu.” ");
INSERT INTO gdn_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Mu inako tagubu, ko Iyesu denai Sadusi ragidai ki tadebu, wagubu ke, “Wi kawaya daganani paerepiyamu. Wi Mamanuga God e yonai eba kataigau ade e kasiyarai mete eba kataigau. ");
INSERT INTO gdn_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Iyapana popotagubu ragidai ade kimoto ubumoto makeya ki ka mu eba anikatagisi. Mu ka aneya kunumau idiwu ki maba inako idiwono. ");
INSERT INTO gdn_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ko iyapana popotagubu ragidai ewa ade iyatagamana kimana ubumana ki yonai ka oragai apunai Mosisi oka tapu kewowena ko e yonai ki mibai wi bani eba wainapiyamu bo? Mara mosi ka oragai apunai Mosisi kayawena kaniyawa da e ripa mo beuwena empupu manako e Mamanuga God e bonanai inako wainapupu, wagubu ke; ‘Apunu Eburamu e Mamai God ka nau. Apunu Aisiki e Mamai God ka nau. Apunu Diyaikapu e Mamai God ka nau.’ ");
INSERT INTO gdn_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Oragai apunai Mosisi Mamanuga God e bonanai inako wainapupu ki mibai nau karako wi nidiyani wainapumuri; Oragai ragidai Eburamu yo Aisiki yo Diyaikapu ki mu ka orageya mena popotagubu gawarara ko mu keyai-muguma iyaiya idiwu ki pokere Mamanuga God wagubu ke; ‘Mu Mamamaga God ka nau.’ Ko wi waina-piyamu da iyapana popotagisi ki mu ewa eba iyatagisi kimoto ubumoto ki pokere wi kawaya daganani paere-piyamu.” Iyesu inako tadebu. ");
INSERT INTO gdn_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Mamanuga God e gorai ki kataiya apunai mosi ika uburawa mu waina-tamiyawa ki Iyesu yona denai bagi kawaya Sadusi ragidai tadeyawa ki wainapupu manako e kanibu Iyesu bameya bauwena e sibu, wagubu ke; “Mamanuga God e gorai ropani kawaya nakapupu ki paunamugu gora bani ka kawaya esida?” ");
INSERT INTO gdn_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","E inako wagubu manako Iyesu denai e sibu, wagubu ke; “Gora kawai ka yau kena; ‘Tawana Isiraero ragidai, wi wainapumuri; Mamanuga God e eya mena ka Kaiwawo. ");
INSERT INTO gdn_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Ade wi nuwaga notaga, wi mibiga kuduba ade wi kasiyaraga kuduba ki pokaiya ka wi maramara wi Mamaga God e mena nota kwarikwarisipiyoi idiwoi.’ ");
INSERT INTO gdn_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Gora kawai mosi ka yau kena; ‘Kau kiya nene wainapiyei ki maba kau kowagiyoma mu nene mete wainapiyowa.’ Gora apeya yau mena ka kawakawaya.” ");
INSERT INTO gdn_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Iyesu inako wagubu manako apunu ki ubupu denai wagubu ke; “Sidiyei Kabukabuwa Apunai, kau yona mibai kawaya nuwegei. Mamanuga God e eya mena ka Kaiwawo. Tawana tawana kuduba, madega kauwagau madega posiwagau ka kaiwawo mo e maba pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Nu nuwanuga notanuga ade nu kasiyaranuga kuduba ki pokaiya Mamanuga God kawaya daganani nota kwarikwarisipomu ade nu kowanuguma mu nene mete notatamomu idiwomu ki ka gora kawakawaya esida. Nu papa pasumei puyo Mamanuga God kweyemei bo denai gwede mo inako kwaigemei ki kuduba ka erida.” ");
INSERT INTO gdn_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Apunu ki yona supasupai kawaya inako wagubu ki pokere Iyesu denai e sibu, wagubu ke; “Kau yona mibai nuwagibi. Nau wainapakani da kau waunitau Mamanuga God sumapi e umunui wadi manako e gari rabineya e kasiyarai pokaiya uburi.” Iyesu inako wagubu wainamupu ka iyapana ika idiwa kudu mete waina-mupu ko mu manu mo e eba simupu. ");
INSERT INTO gdn_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Iyesu Mamanuga God e Tawai ki rabineya iyapana tadeyawa kabu-kabuwa tondawa ka e mu manutapu, wagubu ke; “Mamanuga God e gorai kataimugu ragidai ka badidi pokere tagamu da ‘Nu Iya Negeyana Apunai Keriso e ka oragai apunai Dewida e momai?’ ");
INSERT INTO gdn_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Nau suwagani wainapumuri; Takari kawaya ka Mamanuga God e Keyai Tanai Bagi Kawaya oragai apunai Dewida kabuwapupu manako e ubupu oka yau tapu, wagubu ke; ‘Nau Kaiwawoni God nau Kaiwawoni sibu, wagubu ke; Kau nau madanani garu deneya tondowa da nau kau iyaragiyoma kuduba kwanatamani kau kerapugi kobaiya nakatamani kewoyagisi were.’ ");
INSERT INTO gdn_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Oragai apunai Dewida ubupu Keriso e eya Kaiwawoi sibu, ko ade badidi maba ka e eya Kaiwawoi sibu Keriso ki ade apunu Dewida e eya momai?” Iyesu inako wagubu manako iyapana pakasi ragidai ropani kawaya ika idiwa ki mibi mamamai e yonai ki waina-pamawa. ");
INSERT INTO gdn_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ko Iyesu ubupu iyapana ade tadeyawa kabukabuwa, wagawa ke; “Yabu yabu idiwoi kwaenda Mamanuga God e gorai kataimugu ragidai baitagisi wi kerapugau yadini. Iyapana mu emitamana ki nana ka mu monagamaga rorowa kawakawaya inako umamu imatau kaiwu kebomu da iyapana ropani kawaya ika idiwu ki mu emitamana wiwiratamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Guriguri tawai rabineya ka mu kawai gisipiyamu kawakawai ragidai mu watamaga bagi kawaya ki kawareya idiwu. Ade poraga kawareya ka iyapana mu emitamana simaga tepapamana ki nana ka mu iyapana yabaramugu kebari bagi kawaya kawareya idiwu. ");
INSERT INTO gdn_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ridi koboro mu gwedegwedemaga ade mu tawamaga kuduba ki mu asusu tepiyamu ko mu beramaga ka badidi maba ki iyapana eba kataigamana ki nana ka mu ubumu iyapana yabaramugu guriguri rowarowa kawaya tagamu. Mu inako kwaetagamu ki pokere mu aita ewa denai bita banana-pomoto ki bitai ka kawaya esida.” ");
INSERT INTO gdn_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Iyesu kanibu Mamanuga God e Tawai rabineya iyapana bowa madai Mamanuga God nene puyo tamawa watai ki madaneya tondubu manako iyapana ika bautagamawa bowa madai dai puyo nakapamawa ki mu emitami-yawa. Gwedegwedemaga ropani kawaya ragidai bautagamawa bowa madai kawaya daganani nunumawa, ");
INSERT INTO gdn_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ko ridi koboro mosi e gwedegwedei pa mena ki bauwena bowa madai waibora apeya ki mena ika nunupu. ");
INSERT INTO gdn_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Iyesu e tadeyau kabukabuwa ragidai mu nene wagubu bautagubu, manako tadebu, wagubu ke; “Nau yonani yau nidiyani wainapumuri; Iyapana kuduba bowa madai ika nunumawa mu ka puyo maraitau nakapamawa ko ridi koboro ki e mena ka puyo kawaya daganani tapu. ");
INSERT INTO gdn_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Gwedegwede ropani kawaya ragidai ki mu ka tagamaga mesi mete nakamupu ko ridi koboro ki e gwedegwedei ka pa mena ko waibora marai munta e bameya tondawa ki kuduba e Mamanuga God nene tapu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Iyesu Mamanuga God e Tawai ki kamadana kwaewagawa ka e tadeyau kabukabuwa apunai mosi e bameya bauwena manako sibu, wagubu ke; “Nidiyei Kabukabuwa Apunai, tawa bagi kawaya bowa bagibagi pokaiya wadumupu yau emani.” ");
INSERT INTO gdn_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ko Iyesu denai e sibu, wagubu ke; “Kau gwede-gwede yau kuduba empiyei? Nau yona mibai nidiyani wainapi; Tawa yau bowa pokaiya wadumupu ki ka iyapana ewa marai mosi baitagisi baupomoto giri-pomoto pasumoto manako bowa eyaka mena kwaitana mo e wateya eba tondono ko mu kuduba rorororotagisi kewoyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ki eweya, Iyesu ripa ‘oripi’ wenatagubu kweyai ki kawareya yapu tondawa ka e Mamanuga God Tawai ki bamanugutau burida empupu. Apunu Pita yo Diyemesi yo Diyoni yo Enduru mu muga mena e bameya bautagubu manako manumupu, tagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Kau kabuwaniyo; Nuwaboya marai nene nuwagibi ki gwede mara baiyagisi? Ade mara ki bauwagana ki nu gwede matakirai empamu da nu kataigamu mete idiwomu?” ");
INSERT INTO gdn_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ko Iyesu denai tadebu, wagubu ke; “Yabu yabu idiwoi da iyapana eba baitagisi wi beranimoto wi notaga wirapomoto. ");
INSERT INTO gdn_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Iyapana ropani kawaya nau ewaneya baitagisi nau sini pokaiya beratagisi, tagisi ke; ‘Nau ka eyo.’ Mu inako beratagisi manako ubumoto iyapana ropani kawaya kerapumugu waditamini notamaga wirapomoto da mu sumatamini. ");
INSERT INTO gdn_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Wi ta yo yawira sisiyai wainapumuri ade ta yo yawira kwaetagamana kwaetagisi ki sisiyai mete wainapumuri. Ko kudu eba wainapiyoi. Ta yo yawira ki kuduba wenayagisi ko mara siyarai tondau eba bauwagana kena. ");
INSERT INTO gdn_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Tawana tawana ka natere mo uburoto natere kudubai mo mete yawira-tagisi, ade tawana mo kawaimaga e iyapanaiyoma tetamini kayatagisi tawana mo kawaimaga e iyapanaiyoma mete kandetagisi. Tawana ebo ebo ka tawana mosi waira nutanuta baiyagisi ade tawana mosi ka kapoi kawaya uburoto. Ko nuwaboya yau ki ka ridi munu wenapana tagai urau ki makarai maba. Makari kawaya ka ewa baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Wi wibo kwayubaga kwaiwogoi idiwoi. Iyapana wi tenimoto kawakawai ragidai mu bamamugu idamaga gurai wi naurigau ugwadinimoto ragiragi manako guriguri tawai rabineya wi nunimoto. Nau pokanere ka wi aita kawakawai ragidai mu yabaramugu ubumuri nau sisiyani mu tademuri wainapomoto. ");
INSERT INTO gdn_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Yabiri ka iyapana tawana tawana kuduba, madega kauwagau madega posiwagau nau yonani bagi kawaya yau wainapomoto kewoyagisi were ewa ka mara siyarai ki baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Tawana tawana ebo ebo iyapana aita ubumoto wi tenimoto idamaga gurai wi naurigau ugwadinimoto ragiragi ki ka wi denai iwagamana ki nene kudu eba wainapiyoi ko yabarayabara ubumoi. Wi yona denai iwagamana marai baiyagisi ki ka wi pa yona iwagi manako ki makeya ka Mamanuga God e eya Keyai Tanai Bagi Kawaya wi kabuwaniyoto manako wi yona ki mena makeya makeya iwagi. ");
INSERT INTO gdn_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Tatai uburoto yagisi manako e yowai poyagisi. Yowai uburoto yagisi manako e tatai poyagisi. Mamai uburoto yagisi manako e munuiyoma popotagisi. Munumuguma ubumoto mu inamuguma mamamuguma tagarara-tamini tagisi manako mu inamuguma mamamuguma popotagisi. ");
INSERT INTO gdn_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Nau pokanere ka iyapana wi kiranimono beroberoko ko iyapana nima nau eba tagararasiniyoto ko giruru maba kobaiya teyagisi buridere baiyagisi ki ka mara siyareya ka Mamanuga God uburoto iyapana ki iya waunai kweyoto.” ");
INSERT INTO gdn_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Aita ewa ka ‘Berokoi Kawaya’ mosi baiyagisi manako e eba uburana watai ki wateya uburoto. (Nima yona yau iyabapono ki ka e yona yau mibai ki naigida mena notapono.) Wi berokoi ki ika uburono empumuri ki ka wi tawana Diyudiya ragidai garugaru mena wakapaiwagi kweyau kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Iyapana mosi imatau tondau ki ka e eba yaroto e ebo gwedegwedei tawa rabineya nakapupu ki tepoto. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ade iyapana mosi kokorau umau ki ka e eba wirayagisi e midi tatamai ki kai tawau kayayagisi. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Akae, mara ki makeya ka ridi mosi mibi romodoi bo munu wawayai mete kina ki ka e badidi maba wakapayagisi garugaru kayayagisi? ");
INSERT INTO gdn_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Mamanuga God bameya guriguriwagi da berokoi ki nusuru mareya eba baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Mibai, mara ki makeya ka nuwaboya ade bita kawaya daganani wenayagisi. Kerareya Mamanuga God waira gwedegwede kuduba yamanapupu makeya idiweya kebomeya da karako ka iyapana bita inako mo eba bananamupu. Ade ewa, mara siyareya ki nu bita inako mo mete eba bananapamu. Ko paunau ka bita kawaya yau wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Mamanuga God e bita ade nuwaboya ki marai yadini rowarowa ki ka iyapana mo eba tondono ko mu kuduba popotagisi gawarara. Ko e eya iyapanaiyoma winetapu ragidai ki mu nene e wainapiyau ki pokere e mara ki yadini rogobi da mu eba popotagisi ko idiwono. ");
INSERT INTO gdn_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Mara ki makeya iyapana mo baiyagisi wi nidiyoto, yagisi ke; ‘Kebo-muri empumuri, Keriso yewe bauwena tondau.’ Bo ade mo yagisi ke; ‘Keriso burida bauwena tondau.’ Iyapana mo baiyagisi inako yagisi ki ka wi e yonai ki eba sumapumuri. ");
INSERT INTO gdn_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Iyapana dai ubumoto beratagisi, tagisi ke; ‘Nau ka Keriso.’ Ade dai beratagisi, tagisi ke; ‘Nau ka Mamanuga God e bonanai wainapuwani nidiyakani yau kena.’ Mu inako tagisi manako mu matakiramaga marai kawai mete kwaetogomono wi kabuwanimono. Mu iyapana beratamini ade Mamanuga God e iyapanaiyoma winetapu ragidai mu notamaga wira-pamana ki nana mete kwaetogomono, ");
INSERT INTO gdn_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ki pokere wi wibo kwayubaga kwaiwogoi idiwoi. Gwedegwede kuduba aita ewa wenayagisi ki sisiyai nau karako yabiri nidibuwani yau kena.” ");
INSERT INTO gdn_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Bita kawaya ki marai kewoyagisi ki ka madega sisipupoto manako siragamu ewa eba taniyagisi. ");
INSERT INTO gdn_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Supama kunumau gwegwetagisi manako kunuma kasiyarai mubo mubo geyageyatagisi. ");
INSERT INTO gdn_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Mara ki makeya ka Kunumau Kawapuwani Apunai nau kasiyarani kawaya tanini bagi kawaya mete oroguma kawareya ade kaworoni ki wi nau emisinimuri. ");
INSERT INTO gdn_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Nau aneyaniyoma tonotamani manako tawana tawana kuduba, madega kauwagau madega posiwagau ki mu kayatagisi Mamanuga God e winetapu ragidai kuduba kwana-tamini ewapuru mena damutamini.” ");
INSERT INTO gdn_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Iyesu inako wagubu ade tadebu, wagubu ke; “Karako waigugu ripa damaya naureya kabuwaniyani ki wi wainapumuri; Ripa duwapiyau empu-muri ki wi kataigau da bodu marai waunitau baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Baganai, wi gwedegwede kuduba nidibuwani ki mibai wenayogono empiyoi ki wi mete kataiwagi da mara siyarai ka waunitau. ");
INSERT INTO gdn_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Nau yona mibai suwagani wainapu-muri; Nau yonani yau kuduba nidi-buwani ki mibai matarayagisi wi yabugere empumuri were ka wi dai karako idiwu ragidai ewa popoiwagi. ");
INSERT INTO gdn_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Kunuma waira kuduba gogatagisi ko nau yonani suwagubuwani ki eba gogayagisi ko maramara tondono kaniyono.” ");
INSERT INTO gdn_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Nau gwede mara kemorau bo nawarau ade wirasugani bausugani ki ka iyapana kuduba wi eba kataigau, aneya kunumau idiwu mete eba katai-mugu, ade Mamanuga God e eya Gubagai nau niya mete kina ka mara ki eba kataineya. Nau Mamai e eya mena mara ki kataiya. ");
INSERT INTO gdn_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ki pokere yabu yabu idiwoi wi kyayubaga mete kwaiwogoi mibai ka mara ki gwede mara baiyagisi ki wi eba kataigau. ");
INSERT INTO gdn_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Mara ki badidi maba baiyagisi ki nau karako suwagani; Apunu kawai mosi e tawana mo kaya-yagisi ki ka e naiya e bigabigaiyoma ragidai mu upimaga purupoto mubo mubo denemugu tageni ade katamuru uburau apunai gwaiyabapoto da e yabu yabu tondono. ");
INSERT INTO gdn_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Baganai, katamuru uburau apunai yabu tarau tondau ki maba ka wi mete inako yabu tamiyoi idiwoi mibai ka tawa apunai gwede mara ade wirayagisi baiyagisi ki wi eba kataigau. E kemora nene baiyagisi bo kemora paunau baiyagisi bo mara dumai tarono ki makeya baiyagisi bo nawaru puruyagisi didiburu mena baiyagisi bo, ki wi eba kataigau. ");
INSERT INTO gdn_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","E garugaru mena baiyagisi manako wi oro were naininiyoto ki ka eba baganai. ");
INSERT INTO gdn_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nau karako wi nidiyakani ki nau eba wi nene mena suwagakani ko iyapana kuduba mu nene mete suwagakani yau kena; Yabu yabu idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Mara ki makeya ka iyapana kawakawai, Mamanuga God bameya dobopiyamu ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina Iyesu weki gwaiya minimana po ki keketai kupamawa. Mara ki tetaiya ka iyapana poragamaga kawaya ki mu si ‘Mamanuga God Nu Raurunibu Poragai’ tagamu ade poraga ki rabineya ka kupe mosi ki mu si ‘Parawa Pa Pasumana Kupei’ tagamu ki mete kina. ");
INSERT INTO gdn_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Iyapana kawakawai ki Iyesu wadamana sisiyai tagamawa ko mu iyapana yawiratagamana kudumugu mete wainapamawa ki pokere mu mubo mena tagubu ke; “Iyapana ropani kawaya yewe poraga nene bautagubu ki ubumana nu yawiranimana kudeya ki pokere kamadamu da poraga yau kewoyagisi were ewa yadamu.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ki makeya ka Iyesu apunu mo si ka Simiyoni si daikere ka ‘Kwata Apunai’ ki e bameya natere Betani rabineya bauwena. Mu kupetagamawa idiwa ka ridi mosi ripa otai aurai bagi kawaya awana kororai mo rabineya minibu ki wadubu bauwena. Ripa otai ki si ka ‘nada’ ko ki denai ka kawaya daganani. Awana kororai ki mu bowa ‘arabata’ pokaiya yamanamupu. Ridi ki Iyesu bameya bauwena awana kororai ki minibu sukwana manako e ripa otai bagi kawaya ki Iyesu debaiya kwebu wira. ");
INSERT INTO gdn_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Iyapana dai tawa rabineya Iyesu mete idiwa ki ridi ki inako kwaewena emupu ka mu rabinamaga urabu mu mubo mena tagubu ke; “Ridi yau awana bagi kawaya ki gwede nana pa kwebu wira? ");
INSERT INTO gdn_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","E wadubena kayawagubena iyapana gimarampena manako denai bowa madai kwempena ki e wadubena iyapana gwedegwedemaga pa mena ragidai tagebena ki ka baganai.” Mu inako tagubu manako mu ridi ki sisiba-pamawa. ");
INSERT INTO gdn_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ko Iyesu denai wagubu ke; “Ridi yau kamadumuri midimama eba kwemuri. E bauwena nau nene badidi kwaewena ki ka bagi kawaya. ");
INSERT INTO gdn_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Gwede-gwede pa mena ragidai ki mu ka maramara wi mete idiwoi da wi mu waitatamiyoi ko nau marani rogobi-wagau da nau wi mete eba idiwomu. ");
INSERT INTO gdn_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ridi yau e ebo nuwaiya badidi waina-pupu nau nene kwaewena ki kuduba bagi mena. Nau posugana marai ka waunitau ki pokere e karako bauwena nau monagasinibu awana bagi kawaya yau nau debaneya kwebu wira. ");
INSERT INTO gdn_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Nau mibai nidiyani wainapumuri; Iyapana tawana tawana idiwu aita ewa nau yonani bagi kawaya wainapomoto ki ka mu ridi yau e nau nene badidi kwae-wena ki sisiyai mete wainapomoto manako e werei togomono.” ");
INSERT INTO gdn_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Iyesu yona ki wagubu makeya ka e tadeyau kabukabuwa apunai mosi si ka Diyudiyasi si daikere ka Isikariyoto kipu ubupu kayawena iyapana kawakawai Mamanuga God bameya dobopiyamu ragidai ki mu bamamugu bauwena manako tadebu, wagubu ke; “Nau karako waitaniyani da wi Iyesu weki gwaiya wadumuri.” ");
INSERT INTO gdn_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","E yona ki wagubu wainamupu ka kawakawai ragidai ki mu rabinamaga bagiwena poyo manako mu denai e simupu, tagubu ke; “Ki ka bagi kawaya. Kau inako waitaniyo ki ka nu denai aita bowa madai dai kau negeyamu.” Mu inako tagubu ki pokere apunu Diyudiyasi kayawena Iyesu wadamana minimana po ki yawatai kwaenepiyawa umawa. ");
INSERT INTO gdn_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Mara karako mena idiwono da marawani ka mu ‘Parawa Pa Pasumana Kupei’ ki kupetagisi. Ko karako ka mu bususumaga wagubu ki mu makeya makeya kwaetagisi papa sipi munai mo ugwadinimoto poyo ki pokere Iyesu tadeyau kabukabuwa ragidai e bameya bautagubu manako simupu, tagubu ke; “Kau nuwageya nu bani kaigamu tawiyaigamu da kau ‘Mamanuga God Nu Raurunibu Poragai’ ki kupei kupenuwagi?” ");
INSERT INTO gdn_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ko Iyesu ubupu e tadeyau kabukabuwa ragidai apeya tonotapu tadebu, wagubu ke; “Wi yabiriwagi natere Diyerusaremu baiwagi manako apunu mosi ika yawatau awana miniyoto kawarapoto kaniyono empumuri ki e eweya kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","E tawa bani yaroto ki wi mete ika yamuri manako wi tawa ki apunai ika tondau ki simuri, iwagi ke; Nu Nidiyau Kabukabuwa Apunai wagubu ke; ‘Nau watani bani da nau tadeyakani kabukabuwa ragidai mete kina ‘Mama-nuga God Nu Raurunibu Poragai’ ki kupei ika kupeigamu?’ ");
INSERT INTO gdn_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Wi manu inako iwagi manako nu kupenuga watai kawaya mosi ki mu ororeya mena okukunatagubu kebari mempu kewo-wena ki e yaroto ika tawa rabinai tetaiya wi kabuwaniyoto. Nu baninuga ki wi ika tawiyaiwagi manako nu ika kupeigamu.” ");
INSERT INTO gdn_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Iyesu inako wagubu manako mu kayatagubu natere ki rabineya bautagubu ka mu Iyesu badidi wagubu ki makeya makeya banana-mupu manako mu ika tawiyatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Kemorawagana kwaewagawa ka Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya mete kina ika bautagubu manako mu tawa ki rabineya kupetagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ko Iyesu tadebu, wagubu ke; “Nau yona mibai nidiyani wainapumuri; Wi ba bananasinimpu baigubu yewe mete kupemei idiwei ko waunitau ka apunu mosi wi paunagau uburoto nau yogoni yagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Iyesu yona ki wagubu wainamupu ka mu notamaga kowena nuwaboya-tagubu manako mu eyaka eyaka e manupamawa, tagamawa ke; “Kau nau nene nuwegei bo? Kau eba nau nene nuwegei?” ");
INSERT INTO gdn_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ko Iyesu denai tadebu, wagubu ke; “Ki ka wiyo, nau nidiyakani kabukabuwa ragidai ida esida kewo-wena kerapu apeya ki mosi. Karako tena yau kawareya nau mete ewapuru kupemei apunai mosi ki waunitau uburoto nau nidani yagisi. ");
INSERT INTO gdn_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Takari kwaya ka Mamanuga God e bonanai wainapamawa tagamawa ragidai ubumpu Kunumau Kawapuwani Apunai nau aita posugana ki yonai okamupu. Ko apunu nima nau nidani yagisi ki ka aita ewa ka e bita kawaya daganani bananapoto. Akae, apunu ki eba wenawagubena ki ka e nene baganai.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Mu kupetagamawa idiwa da paunau ka Iyesu bani buredi mo wadubu Mamanuga God bameya parauwena piripiri gerepupu manako e tadeyau kabukabuwa ragidai tagebu, wagubu ke; “Bani buredi yau ka nau kwakwarepuni ki pokere tepumuri kupumuri.” ");
INSERT INTO gdn_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","E inako wagubu manako ade kapa mo wadubu Mamanuga God bameya ade parauwena manako tagebu ewapuru mena kubamupu. ");
INSERT INTO gdn_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Kubamawa da kamadumpu ka e tadebu, wagubu ke; “Awana ‘waeni’ daragai yau ka nau darani. Nau Mamai naiya iyapana ropani kawaya mu iyamaga nene gwaiyaba kaimatanawena ki mibai wenawagana ki nana ka nau karako posugani manako nau darani baiyagisi kaworoto. ");
INSERT INTO gdn_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Nau yona mibai suwagani wainapumuri; Awana daragai yau ki nau ewa mo eba kubarani. Ko aita ewa, nau Mamai God e gari rabineya e kasiyarai pokaiya tondoni makeya ki ka nau awana ‘waeni’ waunai mosi kubarani.” ");
INSERT INTO gdn_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Iyesu yona ki wagubu kewowena ka mu Mamanuga God e si umayo pokaiya tepamupu manako kayatagubu kaimpu ripa ‘oripi’ wenatagubu ki kweyai yamupu. ");
INSERT INTO gdn_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Mu kayatagubu kaiwa ka Iyesu yona mo tadebu, wagubu ke; “Nau kataineya da wi kuduba waunitau nau kamadisinimuri kudu wakapaiwagi kaiwagi mibai ka takari kawaya ka Mamanuga God e bonanai wainapiyawa wagawa apunai mosi nau nene oka inako tapu, wagubu ke; ‘Aita ewa ka Mamanuga God papa sipi kwayuba-tamiyau apunai miniyoto poyo manako papa sipi kuduba daburipomoto mu mubo mubo kayatagisi.’” ");
INSERT INTO gdn_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Iyesu inako wagubu manako ade tadebu, wagubu ke; “Nau posugani ade iyasugani kirani uburani ki nau yabiri kayasugani tawana Gariri rabineya wi nawanaga ika tondoni.” ");
INSERT INTO gdn_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Apunu Pita yona ki wainapupu ka e denai wagubu ke; “Kau nidiyei kabukabuwa ragidai dai ka bani kau kamadinimoto kudu wakapatagisi kayatagisi ko nau kau eba kamadiniyani kayasugani.” ");
INSERT INTO gdn_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Apunu Pita inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Pita, nau mibai nidiyani wainapi; Kemora yau rabineya ka kau mara apeya eyaka nuwogowa bodaboda da kau eba kataigeya nau. Kau inako nuwogowa were ewa ka kokoroku apeya yagisi manako nawaru puruyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Iyesu inako wagubu ko apunu Pita e midi minibu, wagubu ke; “Akae, nau inako eba suwagani ko kau ponuwagi ki ka nau mete posugani.” Apunu Pita inako wagubu manako Iyesu tadeyau kabukabuwa ragidai kuduba Pita umunui kawareya ki mu mete tagubu. ");
INSERT INTO gdn_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Mu kayatagubu kaiwa da tawana Gesemane bautagubu ka Iyesu mu munatapu, wagubu ke; “Wi yewe idiwoi ko nau niya mena kaniyani nau Mamai bameya gurigurisugani.” ");
INSERT INTO gdn_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","E inako wagubu manako ubupu apunu Pita yo Diyemesi yo Diyoni ki mu mena waratapu mete kayatagubu. Ki makeya ka Iyesu nuwaboya kawaya wainapupu ade e rabinai giriwena pasuwena ki pokere e kowakowaiyoma ki emitapu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","“Nau karako nuwaboya kawaya daganani wainapakani ade nau rabinani giripakani pasurakani. Wi yewe yabu yabu idiwoi ko oro eba ukwopoi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","E inako tadebu kamaditapu kanibu e ebo mena ubupu manako kwarisiwena wairau ukwapu e Mamai bameya guriguriwena, wagubu ke; “Mamai, berokoi nau karako bananapani ki kau surupi bo?” ");
INSERT INTO gdn_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ade wagubu ke; “Mamai, Mamai, kau badidi wainapiyei nuwagi ki kuduba wenayagisi. Nau nuwaboyani kerarai kapa tegebi ki nau eba kubarana wainapakani ki pokere kapa ki wadi kayanuwagi. Ko Mamai, kau kaubo nuwageya ki kwaenuwagi ko eba nau nuwaneya ki kau kwaenuwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Iyesu inako guriguriwena manako e ade wirawena bauwena ka e tadeyau kabukabuwa ragidai ki ika ukwa-pamawa emitapu. Emitapu, wade yabuyabutapu, manako e apunu Pita si daikere Saimoni empupu sibu, wagubu ke; “Saimoni, kau ukwerei bo? Nau eba rowarowa kanibuwani ko kau yabu eba tondei. ");
INSERT INTO gdn_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Yabu yabu idiwoi ade Mama-nuga God bameya guriguriwogoi da gwede mosi eba baiyagisi wi rabinaga kweyoto wira. Wi nuwaga notaga ka bani kasiyara wainapiyamu ko wi kwakwarepuga ka kasiyarai pa mena.” ");
INSERT INTO gdn_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Iyesu inako tadebu manako wirawena kanibu e Mamai bameya naiya guriguriwena ki kawareya ade guriguriwena. ");
INSERT INTO gdn_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","E guriguriwagawa da kamadubu ka e ade wirawena bauwena manako e kowakowaiyoma ki yabu-maga ade bisi kayawena ukwapamawa emitapu. Emitapu ade wade yabu-yabutapu ko mu yona denai e siyamana ki mu babatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ko Iyesu ade kanibu e Mamai bameya guriguriwagawa da kamadubu manako ade wirawena bauwena ka e kowakowaiyoma ki ade ukwapamawa emitapu. Emitapu ka e tadebu, wagubu ke; “Wi oro mena ukwapamu idiwu. Ko karako kewowena. Kunumau Kawa-puwani Apunai nau marani wana bauwena da nau nidani wagubu apunai baiyagisi nau wadisiniyoto manako iyapana beramaga berokoi ragidai mu idamaga rabineya nau tamusiniyoto. ");
INSERT INTO gdn_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ki pokere kimuri ubumuri da kaigomu. Nau yogoni wagubu apunai ki burida bauwena empumuri.” ");
INSERT INTO gdn_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Iyesu yona ki wagawa makeya ka mu apunu Diyudiyasi ika matarau bauwena emupu. E ka Iyesu e tadeyau kabukabuwa ragidai ida esida kewo-wena kerapu apeya ki apunai mosi. Diyu ragidai mu kawakawaimuguma yo Mamanuga God bameya dobopiyamu ragidai yo Mamanuga God e gorai kataimugu ragidai mete kina ki mu iyapana ropani kawaya tonotampu karako ta yo kepata inako temupu apunu Diyudiyasi bananamupu mete bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yawatau ka yogo wagubu apunai ki iyapana ki tadebu, wagubu ke; “Nu kaigamu usi baigamu ki ka wi nau mena emisiniyoi manako apunu ki nau kiyauyauponi ki e wi naigida mena wadumuri dokodoko kaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Apunu Diyudiyasi inako tadebu ki pokere mu karako bautagubu ka e deni mena kanibu Iyesu bameya bauwena manako paraupupu sibu, wagubu ke; “Sidiyei Kabukabuwa Apunai.” E inako wagubu manako Iyesu kiyauyaupupu. ");
INSERT INTO gdn_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","E kiyauyaupiyawa emupu ka iyapana ki kaimpu Iyesu wade doko-dokomupu ubumawa. ");
INSERT INTO gdn_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ki makeya ka Iyesu mete iwa apunai mosi kereba wadubu iyara apunai ki mosi e wenagui mebu puru. Bidara wadubu apunai ki e ka Mamanuga God bameya dobopiyamu ragidai kawaimaga e bigabigai apunai mosi. ");
INSERT INTO gdn_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ko Iyesu iyapana ki emitapu manako tadebu, wagubu ke; “Nau ka eba yawiyawirai. Wi ta yo kepata wi tawagau kamaditampena pa baigu-mpena ka baganai ko wi gwede nana ki mete temupu nau yawirani baigubu? ");
INSERT INTO gdn_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Nau maramara Mamanuga God e Tawai rabineya wi nidiyekeya kabu-kabuwa tondekeya ko wi badidi pokere mara ki makeya nau eba wadisinimupu? Ko baganai; Mamanuga God e bonanai wainapamawa tagamawa ragidai takari kawaya e yonai oka badidi tampu ki mibai karako wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Iyesu yona ki wagubu wainamupu ka e tadeyau kabukabuwa ragidai kuduba e kamadumpu wakapatagubu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ko yaraga mosi aukwara mena utawena ika Iyesu eweya kaniyawa ki iyara ragidai e emupu manako mu e wadamana ki nana wadumupu paeremupu e aukwarai mena wadumupu rika, ");
INSERT INTO gdn_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ki pokere apunu ki ni matarau wakapawena kayawena. ");
INSERT INTO gdn_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Iyapana ki Iyesu wadumpu dokodoko kayatagubu kaiwa da Mamanuga God bameya dobopiyamu ragidai mu kawaimaga tawaiya bau-tagubu. Diyu ragidai kawakawai-muguma kuduba Iyesu siyamana wirawira ki nana mete ika bautagubu dibimupu idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Apunu Pita Iyesu eweya weke-wagawa yabadawa da tawa ki kakapareya tewena imatau bauwena manako kanibu iyara ragidai mata pasumpu ika idiwa ki mu paunamugu tondubu mete mata empiyawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Iyapana kawakawai Iyesu siyamana wirawira ki nana ika dibimupu idiwa ki mu nuwamugu e paerei mo kwaene-pamana bananapamana da mu ki pokaiya e minimana po ki nana ko mu kwaenepamawa idiwa ko mibai mo eba bananamupu. ");
INSERT INTO gdn_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Iyapana ropani kawaya ubumpu mu mubo nuwamugu nuwa-mugu beratagamawa ko mu rabinamaga ka eba eyaka mena ki pokere mu mibai mo eba bananamupu. ");
INSERT INTO gdn_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Mu inako tagamawa idiwa da tagamawa idiwa da paunau ka iyapana dai ubumpu bera inako tagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Apunu yau wagubu ki nu wainamipi, e wagubu ke; ‘Mamanuga God e Tawai iyapana idamugu wadumupu ki nau koritapani manako mara apeya eyaka rabineya ka nau tawa ki waunai ade yadani. Ko tawa nau yadani ki ka eba iyapana mu idamugere wadamu ki maba nau yadani.’ E inako wagubu ki nu wainamipi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Iyapana ki inako tagubu ko mu mete rabinamaga ka eba eyaka mena ki pokere mu mibai mo eba bananamupu. ");
INSERT INTO gdn_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ki makeya ka mu kawaimaga ki ubupu Iyesu manupupu, wagubu ke; “Yona mu tagubu ki kau denai mo nuwagi bo pa mena? Kau sisiyagi tagubu ki kau wainapiyei mibai bo bera?” ");
INSERT INTO gdn_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","E inako manupupu ko Iyesu yona denai mo eba wagubu ko pa tondawa ki pokere mu kawaimaga ki ubupu e ade manupupu, wagubu ke; “Mamanuga God si tepapemei e Gubagai ki kau baganai bo? Nu Iya Negeyana Apunai Keriso ki kau baganai? Kau kiya sisiyagi karako matarau nuwagi da nu wainapamu.” ");
INSERT INTO gdn_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Mamanuga God bameya dobo-piyamu ragidai kawaimaga yona ki wagubu ka Iyesu denai e sibu, wagubu ke; “Ki ka nau. Nau ka Kunumau Kawapuwani Apunai. Aita ewa ka nau uburani nau Mamai Kasiyarai Kawaya Apunai e idai garu deneya tondoni ki wi nau emisinimuri manako nau kunumau oroguma kawareya ade wirasugani bausugani ki wi nau mete emisinimuri.” ");
INSERT INTO gdn_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Iyesu yona ki wagawa makeya ka Mamanuga God bameya dobopiyamu ragidai mu kawaimaga ki e yabui dara wirawena manako e ubupu e eya midi tatamai wadubu tegere manako iyapana ika idiwa ki manutapu, wagubu ke; “E yona berawena Mamanuga God e si giripupu ki wi wainamupu bo? E eya wagubu ki pokere yona yau yewe kewowena wainapakani. ");
INSERT INTO gdn_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Apunu yau Mamanuga God bameya berawagau ki pokere wi wainapiyamu da nu karako e bameya badidi kwaigamu?” E inako wagubu manako kawakawai ragidai ki kuduba ewapuru mena mu idamaga gurai Iyesu naureya ugwadumpu ragiragi, tagubu ke; “E Mamanuga God e si giripiyau ki pokere e denai karako poyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Mu inako tagubu manako mu dai kimpu ubumpu Iyesu tepotepopamawa mu idamaga e yabui bodapamawa ade dai e kwanabeya minimawa manako waegeyageyamapamawa, tagamawa ke; “Ki nima nunibu? Kau mibai Mamanuga God e Gubagai ki kau nima nunibu ki e si nuwagi da nu wainapamu.” Ta ragidai dai mete bautagubu e minimawa. ");
INSERT INTO gdn_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ki makeya ka apunu Pita ika imatau tondawa manako Mamanuga God bameya dobopiyamu ragidai kawaimaga e bigabigai kwaewagawa munu ridai mosi ika bauwena e em-pupu. ");
INSERT INTO gdn_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","E Pita ika mata empiyawa tondawa empupu manako yabu doko-dokopupu sibu, wagubu ke; “Kau tawana Nasareta apunumaga Iyesu e mete iwa eminibuwani.” ");
INSERT INTO gdn_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ko Pita denai wagubu bodaboda, wagubu ke; “Kau nima nene nuwegei? Kau yonagi ki nau eba wainapakani.” E inako wagubu manako kipu ubupu kanibu tawa kakapareya uburawa manako ki makeya ka kokoroku wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","E ika uburawa ka ridi ki ade bauwena e empupu manako wirawena iyapana ika idiwa ki tadebu, wagubu ke; “Apunu burida ka mu wadumupu apunai ki e mete iwa apunai mosi e kiyabui empakani.” ");
INSERT INTO gdn_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","E inako wagubu, ko Pita ade wagubu bodaboda. Mu idimpu eba rowarowa ka iyapana ika idiwa ki Pita naigida mena yabu dokodokomupu manako simupu, tagubu ke; “Nu katainugu da kau ka e mete iwa apunai mibai kau ka tawana Gariri apunai.” ");
INSERT INTO gdn_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Apunu Pita yona ki wainapupu ka e midi minibu, wagubu ke; “Apunu ki nene iwagamu ki nau eba kataineya. Mamanuga God e kataiya da nau yona mibai suwagakani.” ");
INSERT INTO gdn_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","E yona ki wagawa makeya ka e kokoroku ade wagubu wainapupu manako e wenagui paparawena Iyesu naiya badidi wagubu ki wainapupu. Iyesu naiya e inako sibu, wagubu ke; ‘Kemora yau rabineya ka kau mara apeya eyaka nuwogowa bodaboda da kau eba kataigeya nau, ko ki eweya ka kokoroku apeya yagisi manako nawaru puruyagisi.’ Iyesu naiya inako wagubu ki makeya makeya Pita wainapupu manako e rabinai makariwena yadi kipu. ");
INSERT INTO gdn_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Nawaru dumai tarawa ka Diyu ragidai mu kawakawaimuguma kuduba yonatagubu kewowena ade mu rabinamaga eyakamenawena ki pokere mu Iyesu wadumpu e idai umamupu dokodoko manako bananamupu kaya-tagubu piyara ragidai mu kawaimaga Pairasi bameya bautagubu. ");
INSERT INTO gdn_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Bautagubu ka apunu Pairasi ubupu Iyesu manupupu, wagubu ke; “Diyu ragidai mu kaiwawo-maga kawai ki kau baganai bo?” Iyesu denai e sibu, wagubu ke; “Ena, ki kau ba nuwegei.” ");
INSERT INTO gdn_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Iyesu inako wagubu ko iyapana kawakawai Mamanuga God bameya dobopiyamu ragidai bautagubu e kawareya kawareya naripamawa bera ropani kawaya siyamawa, ");
INSERT INTO gdn_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ki pokere apunu Pairasi wirawena Iyesu ade sibu, wagubu ke; “Kau yona denai mo nuwagi bo pa mena? Mu rowarowa kawaya kau mena kekeniyamu idiwu ko kau pa tondei.” ");
INSERT INTO gdn_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ko Iyesu yona denai mo eba wagubu ki pokere apunu Pairasi e notai babawena. ");
INSERT INTO gdn_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","7","Karako ka iyapana dai dibura-tagubu ika idiwa. Mu naiya yawira kayatagubu kawakawai ragidai dai namutampu ko mu paunamugu ka apunu mo si ka Barabasi ika mete tondawa. Diyu ragidai mu bususumaga ka kwamura makeya makeya ‘Mama-nuga God Nu Raurunibu Poragai’ poragatagamawa ki kawareya ka mu dibura apunai mo eyaka mena e si tagamawa manako apunu Pairasi dibura gudui kwaipiyawa manako si tagamawa apunai ki pa bauwagawa kayawagawa. ");
INSERT INTO gdn_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Mu bususumaga inako ki pokere iyapana karako apunu Pairasi bameya bautagubu manako simupu, tagubu ke; “Kau kwamura makeya makeya kwae-nugei ki kau karako mete kwaenuwagi dibura gudui ade kwaipi bo?” ");
INSERT INTO gdn_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","10","Iyapana inako tagubu ko apunu Pairasi e rabineya mena wainapupu da Mamanuga God bameya dobopiyamu ragidai ki mu nuwarorotagubu ki pokere mu Iyesu wadumupu e idai rabineya tamupu. E notai inako wagubu ki pokere e denai iyapana ki manutapu, wagubu ke; “Wi nuwagau nau uburani manako Diyu ragidai wi kaiwawoga yau e idai rikapani da e baiyagisi kayayagisi bo?” ");
INSERT INTO gdn_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ko Diyu ragidai kawakawai-muguma ki garugaru mena bautagubu iyapana ika idiwa ki mu rabinamaga kupamupu, tagubu ke; “Iyesu bauwagana kayawagana ki nana eba iwagi ko apunu Barabasi e si iwagi da e baiyagisi kayayagisi.” Mu inako tagubu ki pokere iyapana kuduba apunu Barabasi e si tagubu. ");
INSERT INTO gdn_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ko apunu Pairasi iyapana ade manutapu, wagubu ke; “Ko Diyu ragidai wi kaiwawoga siyamawa apunai yau e bameya ka nau badidi kwaesugani?” ");
INSERT INTO gdn_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","E yona ki wagubu ka iyapana mu bonanamaga ragiragi kawaya denai tagubu ke; “Wadumuri ripa korosi naureya ikokopumuri da e poyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Mu inako tagubu ki pokere apunu Pairasi iyapana ki ade manutapu, wagubu ke; “E poyagisi ki mibai ka badidi? E paere badidi kwaewena?” Ko mu kawareya kawareya bonanamaga ragiragi kawaya tagamawa ke; “Wadumuri ripa korosi naureya ikoko-pumuri da e poyagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Apunu Pairasi yona ki wainapupu ka e iyapana rabinamaga bagiwagana ki nana dibura gudui kwaipupu manako apunu Barabasi matarau bauwena kayawena. Ki eweya ka e ubupu piyara ragidai tadebu da mu Iyesu kuwe pokaiya minimana ki nana wagubu manako ewa kanibu Iyesu wadubu mu idamugu tapu, wagubu ke; “Wadumuri ripa korosi naureya e minimuri poyo.” ");
INSERT INTO gdn_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Piyara ragidai ki Iyesu wadumpu mu kawaimaga tawai rabineya kaimpu manako kowamuguma nene tagubu bautagubu ewapuru mena ika dibimupu idiwa. ");
INSERT INTO gdn_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Mu aukwara daragai bagi kawaya mo wadumpu Iyesu monaga-mupu ade impunewa tempu e debaiya painimupu, ");
INSERT INTO gdn_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","manako waegeyageyama-pamawa, tagamawa ke; “Kaiwa kaiwa, Diyu ragidai Kaiwawomaga Kawaya.” ");
INSERT INTO gdn_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Mu inako tagamawa, e debaiya auda were minimawa ade e kiyabuiya tepotepopamawa manako e yabareya ramatamaga kawareya ubumpu parau beratagamawa. ");
INSERT INTO gdn_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Mu inako waegeya-geyamapamawa da kamadumpu, aukwara daragai bagi kawaya ki ade rikamupu e ebo midi tatamai ade umampu kwempu manako ripa korosi naureya minimana po ki nana wadu-mpu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Piyara ragidai ki Iyesu wadumpu kayatagamawa ka tawana Sairini apunu-maga mo si ka Saimoni ika gwabau gari tagaiya yabadawa da yawatau banana-mupu. Bananamupu ka mu e Iyesu korosi kawarapana ki nana simupu manako apunu Saimoni ubupu ripa korosi ki kawarapupu. (Apunu Saimoni e ka Arekisanda yo Rupai mu mama-maga.) ");
INSERT INTO gdn_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Mu Iyesu wadumpu kaimpu tawana mo si ka ‘Gorogata’ tagamu ki bautagubu. Si ‘Gorogata’ ka keyakeyai ko ki mibai ka Deba Suwana. ");
INSERT INTO gdn_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ika bautagubu ka mu ripa otai suwakarai mosi awana ‘waeni mete wiramupu ki Iyesu kubarana ki nana e kwemupu ko e awana ki eba kubabu. ");
INSERT INTO gdn_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","25","Didiburu madega kaidenai pisikanawagawa makeya ka mu Iyesu ripa korosi naureya ikokomupu manako piyara ragidai ubumpu e midi tatamai rikamupu ki yanuwa munta mo pokaiya nida kasiwaratagubu. Nima si yanuwa ki rabineya yabiri bauwena ki e ubupu Iyesu midi tatamai ki e wadubu. ");
INSERT INTO gdn_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Iyesu powagana ki kerarai ka mu oka pokaiya inako tamupu, “Yau ka Diyu ragidai mu Kaiwawomaga’. ");
INSERT INTO gdn_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","28","Mu Iyapana berokoi apeya mete ripa korosi naureya ikokotampu ki mosi ka Iyesu e idai garu deneya ade mosi ka e idai tenene ki deneya. Mu inako kwaetagubu ki ka Mamanuga God e okai takari kawaya badidi wagubu ki makeya makeya mu kwaetagubu. Oka ki wagubu ke; ‘Kuwa ragidai mu paeremaga bimbinai banana-mupu ki daikere e mete bananapupu.’ ");
INSERT INTO gdn_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Iyapana ika esidaeridatagamawa kaiwa kebomawa Iyesu emupu ka mu debamaga gipamawa e waegeyageyama-pamawa, tagamawa ke; ‘Kau karako kiri uburi da nu kau eminiyamu. Kau naiya nuwagibi da kau Mamanuga God e Tawai ki koritapana mara apeya eyaka rabineya tawa waunai mo ade wadana nuwagibi, ");
INSERT INTO gdn_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ki pokere karako kau kiya kasiyaragi pokaiya ripa korosi ki kamadi kawari iyanuwagi da nu kau eminiyamu.” ");
INSERT INTO gdn_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Mamanuga God bameya dobopiyamu ragidai ade Mamanuga God e gorai kataimugu ragidai ki mu mete kina Iyesu gwaigwitapamawa, tagamawa ke; “E iyapana iyatamiyawa ko e eya iyawagana ka badidi pokere e kasiyarai pa mena. ");
INSERT INTO gdn_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","E mibai tawana Isiraero ragidai nu Kaiwawonuga ade nu Iya Negeyana Apunai Keriso ki ka e ebo ripa korosi ki kamadini kaworoto da nu yabunugere empamu manako sumapamu.” Iyapana apeya e madanai daikere daikere ikokotampu ki mu mete kina Iyesu inako waegeyageyama-pamawa. ");
INSERT INTO gdn_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Madega paunau wadawa makeya ka tawana kuduba sisipu umapu ko ade madega kanibu kekerawagawa napusi apeya eyaka wadawa makeya ka sisipu ki ade negawena. ");
INSERT INTO gdn_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Sisipu ki ade negawagawa makeya ka Iyesu e bonanai ragiragi kawaya wagubu ke; “Eroi, Eroi, rama sabaktani.” Ki mibai ka; ‘Mamani God, Mamani God, kau badidi pokere nau kamadisinibi?’ ");
INSERT INTO gdn_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Iyapana dai ika ubumawa e yonai ki wainamupu, ka mu tagubu ke; “Wainapumuri, e oragai apunai Eraidiya nene wena siyanau.” ");
INSERT INTO gdn_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Apunu mosi dabuwa tenai mo wadubu garupupu awana suwakarai rabineya kaupupu manako sikurupupu Iyesu umuneya tapu da e kubarana ki nana manako wagubu ke; “Idiwomu empomu. Oragai apunai Eraidiya baiyagisi e ripa korosi naureya yadini pakara bo?” ");
INSERT INTO gdn_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ko Iyesu e bonanai ragiragi kawaya wagubu manako e nonai toporuwena powena. ");
INSERT INTO gdn_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Iyesu powagawa makeya ka aukwara mosi Mamanuga God e Tawai rabineya gudu maba uburawa ki paunau tegerewena, esida da erida. ");
INSERT INTO gdn_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Piyara apunai mosi ika ripa korosi kerareya uburawa ki Iyesu bonanai ragiragi kawaya wagubu ki wainapupu ade e badidi maba powena ki mete empupu ki ka e wagubu ke; “Mibai, apunu yau e ka Mamanuga God e eya Gubagai.” ");
INSERT INTO gdn_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ridi dai ika uwamau Iyesu em-pamawa ubumawa mu paunamugu ka ridi Meri Magidarini, ridi Saromi, ade apunu Diyemesi marai yo apunu Diyose mu inamaga si ka Meri. ");
INSERT INTO gdn_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Iyesu naiya tawana Gariri rabineya umawa wadawa ki makeya ka ridi ki e wadamawa tekateka waitapamawa iwa. Ade ewa, e natere Diyerusaremu kayawena ki makeya ka ridi ropani kawaya dai ki e mete ewakumapamawa, ko mu mete kina karako bautagubu ika empamawa ubumawa. ");
INSERT INTO gdn_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","43","Diyu ragidai mu kawaimaga mosi si ka Diyosepa. E tawanai ka Arimasiya. Iyapana e werei tagamawa mibai ka e berai bagi kawaya. E maramara Mamanuga God notapiyawa ade Mamanuga God e gari rabineya kaiwana idiwana ki marai bauwagana nawanai mete tondawa. Kemora nene ka apunu Diyosepa yabarayabara apunu Pairasi bameya kayawena manako Iyesu kwakwarepui ki genei wagubu da e wadana onono-pana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Apunu Pairasi Iyesu powena yonai ki wainapupu ka e wakapa giriwena piyara apunai mo nene wagubu manako manupupu, wagubu ke; “E ororeya mena powena ki mibai?” ");
INSERT INTO gdn_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","“Ena, e ororeya mena powena.” Apunu Pairasi yona ki wainapupu ka e ubupu apunu Diyosepa kayawagana Iyesu kwakwarepui ononopana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Apunu Diyosepa kayawena aukwara bagi kawaya mo gimarapupu wadubu kayawena ripa korosi kerareya bauwena manako e kowaiyoma mete kina Iyesu kwakwarepui ripa korosi naureya wadumupu kwarisi manako aukwara ki pokaiya gerowomupu. Gerowopamawa da kamadumpu ka mu e kwakwarepui wadumpu kayatagubu ragu mosi ki iyapana idamugu ukwa-mupu ki rabineya tamupu manako bowa kawaya mosi gwairimupu ragu umunai ki minimupu bodamupu. ");
INSERT INTO gdn_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Mu inako kwaetagamawa ki ka mu ridi Meri Magidarini yo apunu Diyose e inai si ka Meri mu yabumugu kwaetagubu. ");
INSERT INTO gdn_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Diyu ragidai aiyatamaga marai ki idiwa da kewowena makeya ka ridi Meri Magidarini, ridi Saromi ade apunu Diyemesi e inai si ka Meri ki kimpu ubumpu ripa otai aurai bagi kawaya dai gimaratampu da mu ewa kayatagamana Iyesu powena e kwakwarepui monagapamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pura kawaiya didiburu mena madega posiwagawa makeya ka mu kimpu ubumpu Iyesu kwakwarepui ragu rabineya tampu ki empamana ki nana kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Mu kayatagubu kaiwa da yawatau ka mu muga manu kasiwara-tagubu, tagubu ke; “Bowa kawaya ragu katamurui minimpu bodampu ki nima waitaniyoto da nu gwairipamu?” (Mibai ka bowa ki ka kawaya eba marai.) ");
INSERT INTO gdn_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Mu inako manu kasiwaratagamawa kaiwa da buri bautagubu ka mu yabu tampu manako bowa ki ororeya mena gwairiwena emupu. ");
INSERT INTO gdn_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Emupu manako ragu rabineya kaimpu yabu tampu ka mu yaraga mosi e midi tatamai poe rowarowa kawaya umapu ki mu idamaga garu deneya ragu rabineya tondawa emupu. Empamawa ka mu notamaga kowena kodabamaga kamupu. ");
INSERT INTO gdn_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ko apunu ki mu tadebu, wagubu ke; “Wi notaga eba koyogono. Nau kataineya da wi tawana Nasareta apunumaga Iyesu ripa korosi naureya minimpu poyo yewe ragu tampu ki e midi kwakwarepui empamana ki nana baigubu. Ko e yewe eba ukwarau. E ororeya mena iyawena kipu ubupu kayawena. Mu tampu watai yau karako yewe empumuri. ");
INSERT INTO gdn_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Wi karako kaiwagi e tadeyau kabukabuwa ragidai apunu Pita e kowaiyoma mete tademuri, iwagi ke; ‘Iyesu naiya mena nidibu da e yabiri kayawagana tawana Gariri rabineya wi nawanaga ika tondana ki nana wagubu ki pokere wi karako e eweya kaiwagi tawana Gariri rabineya e bananapumuri.” ");
INSERT INTO gdn_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Apunu ki inako wagubu ko ridi ki kudu wainamupu ragu kamadumpu manako yona mo eba tagubu ko mibi didigurai garumupu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Iyesu pura kawaiya didiburu mena ade iyawena kipu ubupu ka e yabiri ridi Meri Magidarini e bameya matarawena. Ridi ki ka naiya keyai berokoi ida daikere kewowena daikere apeya (7) e rabineya idiwa manako Iyesu mu siwakeketapu ki ridai. ");
INSERT INTO gdn_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","E Iyesu iya-wena empupu ka e kayawena Iyesu tadeyau kabukabuwa ragidai Iyesu nene nuwaboyatagamawa yadi wadamawa idiwa ki mu bamamugu bauwena manako e Iyesu iyawena matarau empupu ki sisiyai mu tadebu. ");
INSERT INTO gdn_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Mu e yonai ki wainamupu ko mu e eba sumamupu. ");
INSERT INTO gdn_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ki eweya ka Iyesu e tadeyau kabukabuwa ragidai apeya tawana mo kayatagubu yawatau kaiwa manako Iyesu kiyabui wirawena ebo mo wenawena ki mu emupu. ");
INSERT INTO gdn_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Mu ade wiratagubu kayatagubu kowamuguma tademupu ko mu yonamaga ki ka mu kowamuguma ki eba sumamupu. ");
INSERT INTO gdn_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Siyareya ka Iyesu e tadeyau kabukabuwa ragidai ida esida kewo-wena kerapu eyaka mena bani ku-pamawa idiwa manako e eya mu bamamugu matarawena. E iyawena kipu ubupu ki sisiyai ka iyapana dai naiya bautagubu mu tademupu ko mu yonamaga ki eba mu sumamupu. Mu rabinamaga ka ragiragi kawaya ki pokere Iyesu mu sisibatapu manako tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","“Karako kimuri ubumuri tawana tawana kuduba, madega kauwagau madega posiwagau ki kaiwagi nau yonani bagi kawaya yau iyapana tadeyoi iwoi. ");
INSERT INTO gdn_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Iyapana nima nau sumasiniyoto ade nau sini pokaiya siruwayagisi ki ka e iya waunai yadini. Ko iyapana nima nau eba sumasiniyoto ki ka e bita bananapoto. ");
INSERT INTO gdn_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Nau sumasinimono ragidai mu ka nau kasiyarani pokaiya matakira ebo ebo kwaetogomono; Nau sini pokaiya ka mu keyai berokoi siwakeketamono da keyai berokoi ki matarau baitogomono kayatogomono. Mu tenawarimaga ka wirayagisi da mu yona naiya eba tagamawa ki mu togomono. ");
INSERT INTO gdn_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Motamota berokoi mu metamini ki ka mu eba popotagisi ade mu awana berokoi mo kubomoto ki ka mu mete eba popotagisi. Mu idamaga sigira ragidai kawarimugu nakapomono ki ka sigira ragidai ki iyatagisi.” ");
INSERT INTO gdn_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Nu Kaiwawonuga Iyesu yona ki wagubu kewowena ka kasiyara mo kawapu e wadubu tepapupu kunumau yapu kayawena manako Mamanuga God e idai garu deneya e tapu tondubu. ");
INSERT INTO gdn_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ko e tadeyau kabukabuwa ragidai ki mu kayatagubu tawana tawana, madega kauwagau madega posiwagau ki e sisiyai iyapana tademawa iwa. Nu Kaiwawonuga mu kasiyara tageyawa manako kasiyara ki pokaiya ka mu matakira ebo ebo mete kwaetagamawa iwa. Iyapana matakira ki empamawa pokaiya ka mu yonamaga ki mete mibipamawa sumapamawa. Ika kewowena. ");
INSERT INTO gdn_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Kaiwa kaiwa apunu Teopirasi, nau parauniyakani kawaya kau bamageya. Nu paunanugu badidi wenawena ki sisiyai ka iyapana ropani kawaya naigida mena wainamupu were oka-mupu. ");
INSERT INTO gdn_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ade gwede wenawena yabumugere empamawa iyapana tademawa kebomawa ragidai badidi tagubu ki iyapana ki makeya makeya oka tamupu. ");
INSERT INTO gdn_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Nau kawaini Teopirasi, kerareya badidi wenawena yabadawa da karako ki bususui nau mete naigida mena kataisugana ki nana ka nau iyapana manutamekeya ade oka dai mete iyabapekeya manako karako ka nau bususu ki kuduba makeya makeya kau bamageya okapana wainapakani. ");
INSERT INTO gdn_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Iyapana naiya kau badidi ka-buwanimawa ki mibai kau naigida mena wainapana wetawetara ki nana ka nau karako oka yau kau nene tarakani. ");
INSERT INTO gdn_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Yabiri badidi wenawena ka yau kena; Apunu Erodi tawana Diyudiya ragidai mu kawaimaga tondawa ki makeya ka Mamanuga God bameya dobopiyau apunai mosi si ka Sekaraiya ika tondawa. Apunu Sekaraiya e ka Mamanuga God bameya dobopiyamu ragidai dai mu debaimaga si ka Abaidiya e kobaiya tondawa upiwagawa. Apunu Sekaraiya e wainai si ka Erisabeta. E mete kina ka oragai apunai Aroni e momai. ");
INSERT INTO gdn_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Mamanuga God yabuiya ka apunu Sekaraiya e wainai mete kina iya bagi supasupai mena idiwa. Nu Kaiwawonuga e gorai kuduba ki mu naigida mena wiwirapamawa makeya makeya kwaetagamawa idiwa. Mu paeremaga mete pa mena. ");
INSERT INTO gdn_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Ridi Erisabeta e ka kagara tondawa da karako ka e nobomoi mete kina ewapuru maguratagubu. ");
INSERT INTO gdn_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Mara mosi ka apunu Sekaraiya e kowaiyoma mete kina Mamanuga God bameya dobopiyamu ki upi kwae-tagamawa, ");
INSERT INTO gdn_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","manako ki makeya ka e kowaiyoma ki apunu Sekaraiya wine-mupu da e kayawagana nu Kaiwawo-nuga e Tawai rabineya gwede mosi aurai bagi kawaya Mamanuga God e kepakepai kawareya pasurana ki nana. Mamanuga God bameya dobopiyamu ragidai mu goramaga pokaiya ka mu maramara inako kwaetagamawa mu waretamaga mo winepamawa da e upi ki kwaewagana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Apunu Sekaraiya e ebo mena tawa ki rabineya kanibu manako e gwede aurai bagi kawaya ki pasurana madegai wadawa makeya ka iyapana ropani kawaya ika imatau Mamanuga God bameya guriguritagamawa ubumawa. ");
INSERT INTO gdn_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ki makeya ka Mamanuga God e aneyai mosi e bameya ika matarawena gwede aurai bagi kawaya pasumu ki kepakepai idanuga garu deneya ika uburawa. ");
INSERT INTO gdn_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Apunu Sekaraiya aneya ki empupu ka e notai kowena kudu mete waina-pupu, ");
INSERT INTO gdn_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ko aneya ki e sibu, wagubu ke; “Sekaraiya, kau kudu eba wainapiyowa. Kau Mamanuga God bameya gwede nene gurigurinugeya ki e wainapupu mibipupu ki pokere kau wainagi Erisabeta ka aita romodoyagisi manako kau gubagagi ki wenayagisi. Ko e wenayagisi ki kau e si Diyoni siyo. ");
INSERT INTO gdn_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kau gubagagi wenayagisi ki pokaiya ka kau mamama wainapiyowa ade iyapana ropani kawaya ka e mamamai mete mamamatogomono. ");
INSERT INTO gdn_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nu Kaiwawonuga e yabuiya ka kau gubagagi ki apunu kawai mosi uburoto. E awana ‘waeni’ ade awana suwakarai mo eba kuboroto, mibai ka e wenayagisi makeya ka Mamanuga God uburoto e eya Keyai Tanai Bagi Kawaya kau gubagagi bameya tonopoto e rabineya posiyagisi kasiyara kweyoto. ");
INSERT INTO gdn_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kau gubagagi pokaiya ka tawana Isiraero ragidai ropani kawaya mu notamaga wirayagisi da mu ubumoto nu Kaiwawonuga mu Mamamaga God siyomoto. ");
INSERT INTO gdn_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Oragai apunai Eraidiya kasiyarai kawaya uburawa ki maba ka kau gubagagi kasiyarai kawaya uburoto yawata yabiyabiri kayayagisi nu Kaiwawonuga e yawatai meyoto. E iyapana kawakawai mu notamaga wirapoto da mu munumuguma notatamono, ade iyapana Mamanuga God e yonai tagararamupu ragidai ki e mu mete wiratamini da mu iya bagi supasupai idiwana ki yawatai naiya kataitagubu ko tagararamupu ki yawatai mu ade kataitagisi. Nu Kaiwawonuga e eya iyapanaiyoma mu nuwamaga notamaga ki e wirapoto da mu Kaiwawonuga e nawanai idiwono.” ");
INSERT INTO gdn_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Aneya yona ki wagubu manako apunu Sekaraiya denai e sibu, wagubu ke; “Nau badidi kataisugani da yona yau ka mibai? Nau ka apunu magurai ade nau ridini e mete magurawena.” ");
INSERT INTO gdn_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Ko aneya ki denai wagubu ke; “Nau ka Gebiro, karako Mamanuga God e yabareya uburakani. E nau tonosinibu da nau yona bagi kawaya yau kau nidiyana ki nana bausugubuwani, ");
INSERT INTO gdn_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ko nau nidibuwani ki kau eba mibisinibi ki pokere nau karako kau nidiyani wainapi; Mamanuga God e winepupu marai baiyagisi ki ka nau suwagubuwani ki mibai makeya makeya wenayagisi. Ko kau nau yonani ki eba sumapipi ki pokere Mamanuga God uburoto kau umunugi deni mena bodapoto manako kau pa tondowa yarowa da nau gwaiyaba nidibuwani ki mibai matara-yagisi makeya ki kau tenawarigi tekatekayagisi manako kau yona ade nuwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Apunu Sekaraiya aneya ki mete yonatagamawa makeya ka iyapana kuduba ika imatau e nawanapamawa ubumawa. Ko e garugaru eba bauwena ki pokere mu notamaga babawena, tagubu ke; “E badidi pokere Mamanuga God e Tawai rabineya rowarowa kawaya inako tondau?” Mu inako tagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Apunu Sekaraiya matarau bauwena ki ka e yona wagana kwaewagawa ko gwede mo e bonanai bodapupu ki pokere e yona mo eba wagubu ko idai mena pokaiya keyai kwaewagawa. Iyapana e bameya badidi wenawena ki emupu ka mu notamaga wagubu ke; “E ka bani waro were maba mosi Mamanuga God e Tawai rabineya empupu ki pokere e inako kwaewagau.” ");
INSERT INTO gdn_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Apunu Sekaraiya e upi Mamanuga God e Tawai rabineya kewopupu manako ade wirawena e ebo tawaiya kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Mara dai kewowena eweya ka e wainai Erisabeta romodo-wena. E romodowena siragamu ida daikere ki rabineya ka e tawa rabineya mena tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","E wagubu ke; “Nau Kaiwawoni karako nau waitasinibu. E nuwai notai kawaya daganani nau nene wainapiyawa ki pokere nau kagara tondekeya manako iyapana kuduba nau emisinimawa ki midimamai e wadubu kwenupupu.” ");
INSERT INTO gdn_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Ridi Erisabeta romodowena siragamu ida daikere kewowena ki makeya ka Mamanuga God ubupu aneya Gebiro ade tonopupu kunumau kawapu tawana Gariri bauwena manako e kayawena natere mo si ka Nasareta bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ika bauwena ka e kayawena onowa mo si ka Meri bameya bauwena. Onowa Meri e ka apunu mo mete eba iwa ko e yaraga mo si ka Diyosepa pokaiya tonabamupu da e uwarana ki nana. Apunu Diyosepa e ka oragai apunai Dewida e momai. ");
INSERT INTO gdn_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Aneya ki bauwena Meri sibu, wagubu ke; “Meri, kaiwa kaiwa. Nu Kawainuga God e nuwaiya po kau. E kawaya daganani kau notaniyau da karako kau wadiniyoto bagi.” Aneya ki Meri inako paraupupu. ");
INSERT INTO gdn_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Onowa Meri parau ki wainapupu ka e notai babawena, inako notapupu; “Ki ka gwede parui parausiniyau?” ");
INSERT INTO gdn_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Ko aneya e ade sibu, wagubu ke; “Meri, kau notagi eba koyogono. Nu Kawainuga God e notai kawaya daganani kau nene wainapiyau ki pokere karako ka e deni mena kau wadiniyoto bagi. ");
INSERT INTO gdn_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Nau suwagani wainapi; Kau romodonuwagi manako munu uratanai wenayagisi ki kau e si Iyesu siyo. ");
INSERT INTO gdn_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","E kaiwawoyagisi manako iyapana tagisi ke; “Mamanuga Kawai Kunumau Tondau e Gubagai ka yau kena.” Takari kawaya ka oragai apunai Dewida ubupu kaiwawowena ko karako ka nu Kawainuga God kaworoto kasiyara e Gubagai kweyoto manako e uburoto e ripakwarakwarai Dewida e watai yadini kaiwawoyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","E kaiwawoyogono manako uburono tawana Isiraero ragidai maramara kwayubatamono tondono ko e kasiyarai ki eba kewoyagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Aneya yona ki wagubu ka Meri denai e sibu, wagubu ke; “Nau apunu mo mete eba iweya. Nau pa tondekeya ki pokere nau munu asusu badidi wenapani?” ");
INSERT INTO gdn_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Ko aneya denai e sibu, wagubu ke; “Nu Kawainuga God e eya Keyai Tanai Bagi Kawaya ki kaworoto kau rabinageya miniyoto siwa manako e kasiyarai kau kawarigeya tondono. Ki pokere munu bagi kawaya ki aita wenayagisi ki e ka nu Kawainuga God e ebo nene manako iyapana tagisi ke; “Mamanuga God e Gubagai ka yau kena.” ");
INSERT INTO gdn_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Nau suwagani wainapi; Kau rakarakagi Erisabeta e ka kagara tondawa da magurawena ko Kawainuga God wagubu ki pokere e karako romodowena. E romodo matara-pupu siragamui ka ida daikere kewo-wena daikere eyaka mena. ");
INSERT INTO gdn_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Nu Kawainuga God e kasiyarai pokaiya badidi yagisi ki e umuneya ka gwedegwede kuduba wenayagisi.” Aneya ki inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Onowa Meri yona ki wainapupu ka e denai aneya ki sibu, wagubu ke; “Baganai, nau ka Kaiwawoni e bigabigai kwaesugakani ki ridai ki pokere e badidi wagubu ki makeya nau bamaneya wenayagisi.” E inako wagubu manako aneya ki e kamadubu kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Mara ki makeya ka onowa Meri kipu ubupu manako garugaru mena natere mosi kweyau ika tawana Diyudiya rabineya ki kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","E kayawena kaniyawa da natere ki bauwena ka e kanibu apunu Sekaraiya tawaiya yapu manako e rakarakai Erisabeta ika paraupupu. ");
INSERT INTO gdn_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Ridi Erisabeta parau ki wainapiyawa makeya ka e rabineya munu ki geyageyawena manako Mamanuga God e Keyai Tanai Bagi Kawaya kawapu ridi Erisabeta kawareya minibu siwa, ");
INSERT INTO gdn_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","manako Erisabeta ubupu e bonanai ragiragi kawaya Meri sibu, wagubu ke; “Ridi kuduba nu paunanugu ka Mamanuga God kau mena kawaya daganani wadinibu bagi ade munu kau aita wenapi e mete kina ka Mamanuga God deni mena yadini bagi. ");
INSERT INTO gdn_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Ko nau ka eba bagi da nau Kaiwawoni e eya inai nau daiyoni bauwagana mamama kawaya yau nau tegeyana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Nau suwagani wainapi; Kau nau parau-siniyeya ki makeya ka munu nau romodoneya ki mamamawena yapu kawapu. ");
INSERT INTO gdn_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nu Kaiwawonuga kau bamageya badidi kwaewagana wagubu ki kau sumapipi ki pokere e deni mena wadiniyana bagi ki mamamai kau wainapiyowa tondowa.” Ridi Erisabeta inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Ko onowa Meri Mamanuga God e si tepapupu, wagubu ke; “Nau nuwani notani pokaiya karako nau Kaiwawoni e si esida tepa-pakani. ");
INSERT INTO gdn_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Nau Mamai God e ka nau Iyasinibu Apunai ki pokere nau rabinaneya ka nau mamama kawaya wainapakani. ");
INSERT INTO gdn_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Nau ka pa iyapana kaina eba bagi ade e bigabigai mena kwae-sugakani ki ridai, ko e nau nene wainapiyau ki pokere nau mibi mamamai tondakani. Mara karako ade ewa ka iyapana kuduba Mamanuga God nau wadisinibu bagi ridai sidimono. ");
INSERT INTO gdn_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Mamanuga God e kasiyarai ka kawaya daganani esida. E gwede kawaya mosi nau nene kwae-wena ki pokere iyapana nau inako sidimono. Mamanuga God e si ka bagi kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Iyapana naiya idiwa, karako idiwei ade ewa mete idiwono ragidai nu gwedewau e mayapemei ki ka e nu nuwanuwaniyono ade wadiniyono bagi. ");
INSERT INTO gdn_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","E idai roronapupu manako e kasiyarai pokaiya ka e matakira ebo ebo kwaewagawa. Iyapana yabara kawakawaratagamawa ragidai mu notamaga ade mu muga mete kina ki e daburitapu mubo mubo kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Yewe wairau kawakawayatagubu ragidai ki mu simaga ka e erida nunupu ade iyapana simaga wekewena ragidai ki mu simaga ka e esida tepapupu. ");
INSERT INTO gdn_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Wetei idiwu ragidai ki e bani yo gwedegwede bagibagi tagebu ko gwedegwedemaga ropani kawaya ragidai ki mu e ida kasikasi tonotapu. ");
INSERT INTO gdn_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","E nu ripakwarakwaranuguma badidi gwaiyabatapu ki e notai eba gogawena. E bigabigaiyoma tawana Isiraero ragidai nu nuwanuwaniyana ade toginiyana ki nana ka e bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Nu ripakwarakwaranuga Eburamu e momoiyoma ka nuyo. Mamanuga God nu eba notagoganibu ko e maramara nu notaniyau, nu nuwanuwaniyau ade nu wadiniyau bagi.” ");
INSERT INTO gdn_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Onowa Meri umayo pokaiya yona ki wagubu manako e rakarakai Erisabeta mete ika idiwa da siragamu apeya eyaka kewowena eweya ka e ade wirawena e ebo tawaneya kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Ridi Erisabeta e munu wenapana marai ki bauwena ka e munu uratanai wenapupu. ");
INSERT INTO gdn_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Nu Kaiwawonuga ridi Erisabeta bameya bagi kawaya badidi kwaewena ki sisiyai e kowaiyoma, e rakarakaiyoma ade e tawanai eyaka mena ragidai kuduba wainamupu manako mu ika bautagubu e mete ewapuru mamamatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Munu ki wenawena e purai eyaka mena kewowena ki eweya ka iyapana e kwakwarepui wakapamana ki nana bautagubu. Mu e mamai ebokowai siyamana ki wainapamawa, ");
INSERT INTO gdn_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ko e inai mu bodatapu, wagubu ke; “Pa mena, nu e si Diyoni siyamu.” ");
INSERT INTO gdn_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","E inako wagubu ko mu e denai simupu, tagubu ke; “Akae, ki badidi? Kau ewagi mu paunamugu ka iyapana mo si ka Diyoni ki pa mena wainapemei.” ");
INSERT INTO gdn_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Munu ki mamai e bonanai boda-pupu tondawa ki pokere iyapana mu idamaga pokaiya keyai kwaetagubu simpu da e munu ki si wagana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","E yona ki wainapupu ka e oka tarana gwedegwedei nene keyai kwae-wena manako e oka okapupu ki inako wagubu ke; “E si ka Diyoni”. Iyapana e okai okapupu ki emupu ka mu nota-maga kowena kodabamaga kamupu. ");
INSERT INTO gdn_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Apunu Sekaraiya oka ki okapupu makeya ka e bonanai ade matarawena manako e yona supasupai ade wagawa Mamanuga God e si esida tepapiyawa. ");
INSERT INTO gdn_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Tawana ki ragidai e ade yonawagawa ki matakirai emupu ka mu wakapa giritagubu notamaga kowena manako mu badidi emupu ki sisiyai ka tawana Diyudiya kweyau ki tawa tawa garugaru mena kawayawena kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Iyapana kuduba yona ki wainapamawa ka mu manu kasiwaratagamawa, tagamawa ke; “Munu ki kawayayagisi ki ka e gwede upi kwaeyogono?” Mu yona ki tagamawa mibai ka mu kuduba kataimugu da nu Kaiwawonuga e eya kasiyarai munu ki bameya mete kina. ");
INSERT INTO gdn_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ki makeya ka Mamanuga God e Keyai Tanai Bagi Kawaya munu ki e mamai Sekaraiya rabineya posiwena kasiyara kwebu da e uburana mara ewa badidi wenawagana ki yonai iyapana tadeyana ki nana. E ubupu wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Nu Kaiwawonuga e ka tawana Isiraero ragidai nu Mamanuga God ki pokere e si nu karako esida tepapemei. E nu bamanugu bauwena gwede umanibu dokodoko ki e rikapupu. ");
INSERT INTO gdn_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","E nu Iyaniyana Apunai kasiyarai kawaya mo tonopupu nu bamanugu bauwena da nu e pokaiya iya wadamana ki nana. E tonopupu apunai ki e ka Mama-nuga God e bigabigai apunai Dewida e momai. ");
INSERT INTO gdn_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Takari kawaya ka Mamanuga God e bonanai wainapamawa taga-mawa e nene idiwa ragidai badidi wainamupu ki mu makeya makeya inako okamupu, tagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","‘Nu iyaranuguma mu idamaga rabineya idiwei ki e nu rikaniyana ki nana gwaiyabawena, ade nu giriniyamu pasuniyamu ragidai ki mu kasiyaramaga ki e mete bodapoto.’ ");
INSERT INTO gdn_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nu ripakwarakwaranuguma ki e nuwanuwatamana ki nana wagubu, ade e gwaiyabai bagi kawaya mu bamamugu wagubu ki e eba notagogapoto. ");
INSERT INTO gdn_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","74","E ubupu nu ripakwarakwara-nuga Eburamu badidi gwaiyaba sibu ki maba e karako nu bamanugu inako mete kwae-yagisi. Nu iyaranuguma mu idamaga rabineya idiwei ki e nu rikaniyoto teniyoto da nu kudu pa mena yabarayabara e bigabigai mena kwaigomu. ");
INSERT INTO gdn_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","Nu yewe wairau idiwei ki ka nu maramara e nene mena idiwomu ade supasupai bagi mena kwaigomu.” ");
INSERT INTO gdn_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Apunu Sekaraiya Mamanuga God e okai kawareya inako wagubu, ade wagubu ke; “Gubagani, aita ewa ka iyapana kau nidimoto, tagisi ke; ‘Kau ka Iyarau Tondau Apunai e bonanai wainapiyei nuwegei ki apunai.’ Kau ka nu Kaiwawonuga e yawatai meyana ki nana yabiri kayanuwagi manako e baiyagisi kau ewageya taneya mena kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Kau e iyapanaiyoma tade da mu bigimaga kuduba ki ka Mamanuga God e notaiya deni mena surupoto manako ki pokaiya ka mu iya yadini. ");
INSERT INTO gdn_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Mamanuga God e ka nu ragiragi kawaya eba nidiyoto ko e nu nuwaboyanuga wainapoto ade nuwanuwaniyoto. E iyai tanai bagi kawaya ki e kunuma were tonopoto kaworoto nu bamanugu baiyagisi, ");
INSERT INTO gdn_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","manako iyapana kuduba yewe sisipu idiwei ade po kasiyarai nu umanibu dokodoko rabineya idiwei ki nu kawarinugu ka tanai ki miniyoto siwa. Nuwabagi rabineya idiwana yawatai ki e nu kabuwaniyoto.” Apunu Sekaraiya ewa badidi wenawagana yonai ki inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Mu munumaga wenawena ki kawayawagawa ade nota supasupai mete wadawa. E iyapana eba idiwu tawaneya e ebo mena tondawa umawa da e tawana Isiraero ragidai mu yabara-mugu uburana ki marai bauwena ki makeya ka e iyapana bamamugu matarau bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Mara ki makeya ka apunu kawai mosi si ka Sita Ogatasi yona tono-pupu tawana Roumi rabineya iyapana kuduba mu mubo tawanamugu kayatagamana simaga tamana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ki makeya ka apunu Kwiriniyasi tawana Siriya kwayuba-piyawa tondawa. Iyapana naiya mu simaga inako eba tamawa, ");
INSERT INTO gdn_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ko mu kawaimaga wagubu ki pokere iyapana tawana tawana idiwa ki karako wira-tagubu mu mubo tawanamugu kaya-tagubu manako simaga ika tamupu. ");
INSERT INTO gdn_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Mara ki makeya ka apunu Diyosepa natere Nasareta tondawa. Natere ki ka tawana Gariri rabineya. Apunu Diyosepa e ka oragai apunai Dewida e momai mosi ki pokere e karako oragai apunai Dewida e naterei si ka Beteriyemu e si ika tarana ki nana kayawena. (Natere Beteriyemu ka tawana Diyudiya rabineya.) ");
INSERT INTO gdn_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","6","E kipu ubupu onowa Meri ki mu e uwarana tonabamupu ki bananapupu manako natere Beteriyemu kayatagubu. Ko onowa Meri e ka romodo matarapupu ki pokere mu kaiwa idiwa da bautagubu ka e munu wenapana makarai waina-pupu. ");
INSERT INTO gdn_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","E munu wenapana makarai wainapiyawa ko natere Beteriyemu rabineya ka iyapana posiwena ukwapamana watai pa mena ki pokere mu idiwa da e gubagai amu suwakarai ki wenawena ki ka e ubupu munu ki aukwara pokaiya sikwapupu manako kanibu papa burumakau bani kupamu ki tenamaga mo rabineya tapu ika ukwarawa. ");
INSERT INTO gdn_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Kemora ki rabineya ka papa sipi baikamutagamawa ragidai dai ika gwabau mu papamuguma kwayuba-tamawa idiwa, ");
INSERT INTO gdn_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","manako Mamanuga God e aneyai mosi mu bamamugu matarawena. Mu aneya ki empamawa idiwa ka Mamanuga God e eya sinini tanai mu kawarimugu kawapu tawana minibu siwa manako mu kudu waina-mupu didiguramaga mete wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Ko aneya ki mu tadebu, wagubu ke; “Kudu eba wainapiyoi. Nau yona bagi wadubuwani kawapuwani iyapana tawana tawana kuduba wi rabinaga bagiwagana mamamaigamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Kemora yau rabineya ka wi Iya Negeyana Apunai wenawena oragai apunai Dewida e tawaneya. Munu wenawena ki e ka Keriso, wi Kaiwawoga. ");
INSERT INTO gdn_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ko e badidi maba wenawena ki nau karako wi nidiyani da wi kaiwagi e empumuri mibipumuri; Wi munu wawayai aukwara pokaiya sikwamupu papa burumakau bani kupamu ki tenai rabineya tampu ukwarau ki e kwaenei kwaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Aneya yona ki wagubu kewowena ka aneya ropani kawaya eba bigabigai kunumau mamataratagubu kawamupu Mamanuga God e si esida tepapamawa, tagamawa ke; ");
INSERT INTO gdn_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Mamanuga God kunumau esida tondau e mena si nu tepapemei, ade waira kawareya ka e iyapanaiyoma nuwaiya po ki mu kuduba ka nuwabagi rabineya idiwono.” ");
INSERT INTO gdn_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Aneya ropani kawaya ki inako tagubu ade wiratagubu kunumau kaya-tagubu ka iyapana ika gwabau idiwa ki deni deni tagubu kasiwara, tagubu ke; “Edama, natere Beteriyemu kaigamu da Kaiwawonuga e gwede yonai wagubu ki nu kwaenepamu empamu.” ");
INSERT INTO gdn_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Mu inako tagubu manako kimpu ubumpu garugaru mena kayatagubu kaiwa da ridi Meri yo apunu Diyosepa mete kina mu bamamugu bautagubu manako mu munu wawayai ika tena rabineya ukwarawa ki emupu. ");
INSERT INTO gdn_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Mu e emupu ka mu aneya munu ki e yonai badidi tadebu ki mu iyapana ika idiwa kabuwatampu. ");
INSERT INTO gdn_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Iyapana yona ki wainamupu ka mu kuduba notamaga kowena kodabamaga kamupu. ");
INSERT INTO gdn_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Ko ridi Meri e ka yona ki kuduba wadubu doko e rabineya mena notapiyawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Papa sipi baikamutagamawa ragidai ade wiratagubu kayatagubu. Aneya bauwena mu badidi tadebu ki mu makeya makeya yabumugere emupu ki pokere mu Mamanuga God mamama-pamawa ade e si esida mena tepa-pamawa kaiwa. ");
INSERT INTO gdn_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Pura eyaka mena kewowena eweya ka mu gubagamaga e kwakwarepui wakapamana ki marai bauwena manako aneya naiya ridi Meri eba romodowena makeya e munu wenapana si Iyesu siyana sibu ki mu makeya makeya kwaetagubu e si Iyesu simupu. ");
INSERT INTO gdn_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Oragai apunai Mosisi e gorai wagubu da ridi munu wenapoto ki ka e pura dai pa tondono manako pura ki kewoyogono makeya ka kiroto uburoto puyo mosi Mamanuga God bameya taroto. Gora inako wagubu ki pokere apunu Diyosepa e wainai Meri mete kina idiwa da gora badidi wagubu ki kwaetagamana marai bauwena ki ka mu munumaga ki wadumpu natere Diyerusaremu kayatagubu manako mu munumaga ki Mamanuga God nene tamupu. ");
INSERT INTO gdn_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Mu inako kwaetagubu ki mibai ka Mamanuga God e okai mosi wagubu ke; “Munu uratanai amu suwakarai mo wenayagisi ki ka e inai mamai mu munumaga ki yadini Mamanuga God nene tamoto.” ");
INSERT INTO gdn_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ade e okai mosi wagubu ke; “Munu wenayagisi ki ka e inai mamai midiwari umago apeya bo midiwari wabarauwa munai apeya inako tepomoto manako Mamanuga God bameya puyo naka-pomoto.” Oka ki inako wagubu ki pokere Iyesu e inai mamai kayatagubu gora badidi wagubu ki makeya kwae-tagubu. ");
INSERT INTO gdn_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Mara ki makeya ka apunu mosi si ka Simiyoni ika natere Diyerusaremu rabineya tondawa. E ka apunu bagi mosi Mamanuga God mayapiyawa tondawa ki apunai. Mamanuga God uburana tawana Isiraero ragidai waditamana bagi ki marai bauwagana ki nana ki nawanai e tondawa ade Mamanuga God e eya Keyai Tanai Bagi Kawaya ki e rabineya mete minibu siwa. ");
INSERT INTO gdn_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Mamanuga God e Keyai naiya mena e kabuwapupu da nu Kaiwawonuga uburana Keriso tonopana gwaiyabai wagubu ki marai ka apunu Simiyoni e yabere empoto were ewa poyagisi, ");
INSERT INTO gdn_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ki pokere Mamanuga God e Keyai ki karako bauwena apunu Simiyoni yabiripupu da e Mamanuga God e Tawai rabineya kanibu. Ki makeya ka Iyesu e inai mamai gora badidi wagubu ki makeya makeya mu munumaga bameya kwaetagamana ki nana ika bautagubu, ");
INSERT INTO gdn_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","manako apunu Simiyoni mu emitapu ka e kanibu mu munumaga ki wadubu taiyapupu manako Mamanuga God e si esida tepapupu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Kaiwawoni, kau naiya nau badidi gwaiyabasinibi ki kau karako makeya kwaenugibi ki pokere karako kau bigabigagi apunai nau eba bodasini ko nau nuwabagi rabineya waira yau kamadani. ");
INSERT INTO gdn_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Nu Iya Negeyana Apunai tonopipi ki e karako nau naubo yabunere empuwani. ");
INSERT INTO gdn_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Iyapana kuduba, madega kauwagau madega posiwagau nu iyanuga yawatai ki kau mebi. ");
INSERT INTO gdn_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Munu yau pokaiya ka iyapana kwaiyanai ragidai kau tanigi matarau empomoto ade e pokaiya ka kau iyapanagiyoma Isiraero ragidai nu sinuga mete kawayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Iyesu e inai mamai apunu Simiyoni mu munumaga nene badidi wagubu ki wainamupu ka mu notamaga kowena kodabamaga kamupu, ");
INSERT INTO gdn_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ko apunu Simiyoni mu emitapu waditapu bagi manako e munu ki inai Meri yona yau sibu, wagubu ke; “Nau nidiyani wainapi; Mamanuga God kau gubagagi yau winepupu da e pokaiya ka tawana Isiraero ragidai ropani kawaya pisipisi-tamini gwepomoto ko ade e pokaiya ka tawana Isiraero ragidai ropani kawaya iya mete yadini. E pokaiya ka Mama-nuga God e nuwaiya badidi wainapiyau ki matarayagisi ko ade iyapana ropani kawaya e mete wereyakaurapomoto. ");
INSERT INTO gdn_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Iyapana ropani kawaya mu wekemaga ki e matarapoto ko kau kiya ka nuwaboya kawaya mosi aita ewa kau rabinageya ta maba ugwadiniyoto makari negeni.” Apunu Simiyoni inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","37","Mamanuga God e bonanai wainapiyawa wagawa ridai mosi si ka Ana ika mete tondawa. E ka apunu Panuero e petei. E kunui ka Asi. Ridi ki e naiya anikawena apunu naureya tondawa ka kwamura ida daikere kewowena daikere apeya (7), ko e nobomoi powena kwamura rowarowa kawaya (84) kewowena ki rabineya ka e koboro tondawa da karako magura-wena. Kemora nawaru ka e Mamanuga God e Tawai rabineya Mamanuga God e si tepapiyawa ade mara dai Mamanuga God nene bani kamadawa e bameya guriguriwagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Apunu Simiyoni ridi Meri siyawa da kewowena ki makeya ka ridi Ana ika mete bauwena manako Mamanuga God paraupupu. Mamanuga God natere Diyerusaremu ragidai iyatamana ki nana ki nawanai ika idiwa ragidai ki mu bamamugu ka e munu ki sisiyai mu tadeyawa. ");
INSERT INTO gdn_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Apunu Diyosepa e wainai Meri mete kina Mamanuga God e gorai badidi wagubu ki makeya makeya kwaetagubu kewowena ki ka mu kimpu ubumpu wiratagubu mu mubo nateremaga Nasareta tawana Gariri rabineya ki ade kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Mu ika bautagubu idiwa ka mu munumaga ki kawayawagawa yarawa ade Mamanuga God e deni mena wadubu bagi ki pokere e nuwai notai supasupai mena kwaewagawa ade katai ebo ebo e rabineya posiwena. ");
INSERT INTO gdn_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Iyesu munu waunai e kwamurai ka ida esida kewowena kerapu apeya (12) kewowena ki makeya ka e inai mamai mete kayatagubu natere Diyerusaremu rabineya poraga kawaya mo ika kupamana ki nana. Poraga kawaya ki ka Diyu ragidai e si ‘Mamanuga God Nu Raurunibu Poragai’ ki tagubu. Kwamura eyaka eyaka ki rabineya poraga marai ki bauwagawa ki ka Iyesu e inai mamai poraga ki kawareya kayatagamawa. ");
INSERT INTO gdn_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Poraga ki kewowena ka mu ade wiratagubu tawanamugu kayatagubu manako mu wainamupu da mu munu-maga ki iyapana kaparimugu mete ika kawarawa ko ki pa mena. Mu e ika natere Diyerusaremu rabineya kamadumpu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Mu kaya-tagubu kaiwa da yawatau ukwapamana kwaetagamawa ka mu munumaga ki eba emupu ki pokere mu kayatagubu tawa tawa ki mu kowamuguma bama-mugu e kwaenepamawa iwa. ");
INSERT INTO gdn_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Mu e kwaenepamawa iwa ko eba banana-mupu ki pokere mu wiratagubu natere Diyerusaremu ade kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Ika bautagubu ka mu e kwaenei kwaene-tagamawa iwa da mara apeya eyaka kewowena eweya ka mu Mamanuga God e Tawai rabineya e ika tondawa emupu. E iyapana tadeyamu kabukabuwa ragidai ki mu paunamugu tondawa mu yonamaga wainapiyawa ade yona denai mu mete manutamiyawa. ");
INSERT INTO gdn_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Iyapana kuduba e denai supasupai kawaya wagawa ki wainapamawa ka mu notamaga kowena e nene ebotau wainapamawa. ");
INSERT INTO gdn_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","E inai mamai e kwaenepamawa iwa da iyapana kawakawai ragidai ki mu paunamugu ika tondawa emupu ka mu mete notamaga kowena manako e inai kanibu e bameya bauwena empupu sibu, wagubu ke; “Gubagani, kau gwede nana nu yabunuga minibi kayanugibi? Nau mamagi mete kina nu notanuga kowena kau kwaenegi kwaigemeya.” ");
INSERT INTO gdn_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Ko Iyesu denai wagubu ke; “Wi gwede nana nau kwaeneni kwaiga-mawa? Nau Mamai e Tawai rabineya tondana ki nana ko ki wi kataigau bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ko e badidi wagubu ki mibai mu eba wainamupu. ");
INSERT INTO gdn_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Iyesu ubupu mu mete kayatagubu sumawa da mu nateremaga Nasareta ki ade bautagubu manako e inai mamai wiwiratamiyawa ade mu umunumaga wadawa tondawa. Ko e inai ka badidi wenawena yau kuduba e ebo mena rabineya notapiyawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Mu munumaga Iyesu kawayawagawa yarawa ade e notai mete kawayawagawa yarawa. Mamanuga God ade iyapana mete kina e nene ebotau wainapamawa ade e mamamai tagamawa. ");
INSERT INTO gdn_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Apunu Sita Taibiriyasi tawana Roumi ragidai mu kawaimaga tondawa kaniyawa da kwamura ida esida kewowena kerapu daikere kewo-wena (15) ki makeya ka apunu Ponsiyasi Pairasi tawana Diyudiya ragidai mu kawaimaga tondawa, apunu Erodi ka tawana Gariri ragidai mu kawaimaga tondawa, apunu Erodi e yowai Piripo ka tawana Isuriya yo Tarakoniyasi ragidai mu kawaimaga tondawa, apunu Raisaniyasi ka tawana Abirini ragidai mu kawaimaga tondawa, ");
INSERT INTO gdn_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ade apunu Anasi yo apunu Kaipasi ki mu ka Mamanuga God bameya dobo-piyamu ragidai kuduba mu kawakawai-muguma idiwa. Mara ki makeya ka apunu Sekaraiya e gubagai Diyoni ika iyapana eba idiwu tawaneya tondawa. Mamanuga God e yonai e bameya bauwena, ");
INSERT INTO gdn_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","manako e ubupu tawa tawa awana Diyoudani bameya ki kayawena dimawagawa umawa iyapana tadeyawa, wagawa ke; “Wi beraga berokoi ki wi karako kamadumuri wi notaga wira-yagisi da nau wi siruwaniyani manako Mamanuga God uburoto wi bigiga ki empoto surupoto.” ");
INSERT INTO gdn_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Takari kawaya ka Mamanuga God e bonanai wainapiyawa wagawa apunai Aisaiya oka yau tapu, wagubu ke; “Apunu mosi gwabau umau e bonanai ragiragi kawaya wagau ke; ‘Kaiwawonuga e yawatai gwaba memuri da e taneya baiyagisi kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Gonu kuduba ki wi waira utapu-muri da posiyagisi ade kweya kuduba ki kwarisitagisi manako dobu wenapoto. Yawata ninoki tapu ki supasupayagisi ade yawata bowa ganaganai ki kuduba momomoi wenapoto, ");
INSERT INTO gdn_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","manako iyapana kuduba, madega kauwagau madega posiwagau ki ka mu Mamanuga God e Iya Negeyau Apunai mu yabumugere empomoto.” ");
INSERT INTO gdn_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Iyapana ropani kawaya apunu Diyoni bameya bautagubu da e mu siruwatamana ki nana, ko e mu tadebu wagubu ke; “Wi ka motamota berokoi e munuiyoma. Nima nidibu da wi Mama-nuga God e nuwa pupui wi bamagau bauwagana kwaewagau ki kudeya wi wakapaigubu yewe siruwaigamana ki nana baigubu? ");
INSERT INTO gdn_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Wi mibai iyaga wirapamana wainapiyamu ki ka wi iya oragai ki kuduba kamadumuri supasupai mena kwaiwogoi. Ade eba notapiyoi da wi yona mena iwagamana ka baganai, iwagi ke; ‘Nu ka oragai apunai Eburamu e momoiyoma ki pokere Mamanuga God e nu wainaniyau da nu ka baganai.’ Nau nidiyani wainapumuri; Mamanuga God e nuwaiya ki ka e bowa ropani kawaya yau tadeni manako mu eyaka eyaka oragai apunai Eburamu e momoi-yoma wenatagisi. ");
INSERT INTO gdn_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Karako ka ripa kerareya dokopana apunai okukuna-wena kewowena da e ripa ki meyana kwaewagau. Ripa ururutanai kuduba ki e dokopoto matau isiyapoto.” ");
INSERT INTO gdn_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Apunu Diyoni inako wagubu ki ka iyapana e denai manumupu, tagubu ke; “Nu badidi kwaigamu?’ ");
INSERT INTO gdn_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Ko e denai tadebu, wagubu ke; “Kau nima midigi tatamai apeya ki kau mo wadi kau waretagi midi tatamai pa mena apunai ki kwei. Ade kau nima bani mete kina ki kau waretagi bani pa mena apunai dai kwei.” ");
INSERT INTO gdn_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Iyapana wairamaga denai ‘takesi’ wadamawa ragidai dai apunu Diyoni mu siruwatamana ki nana e bameya bautagubu manako manumupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, nu badidi kwaigamu?” ");
INSERT INTO gdn_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Ko e denai tadebu, wagubu ke; “Iyapana wairamaga denai mempu puru tampu ki mena makeya wi takesi wadoi ko ki kawareya wi wibo nuwagau asusu eba tepiyoi.” ");
INSERT INTO gdn_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Piyara ragidai dai mete kina bautagubu e manumupu, tagubu ke; “Ko nuyo, nu ka badidi kwaigamu?” Ko e denai tadebu, wagubu ke; “Iyapana eba keraputaisini pokaiya mu gwedegwedemaga tepiyoi ade iyapana yabayababa eba naritamiyoi. Wi upiga badidi kwaiwagamu ki denai wadamu ki mena mamamai iwogoi ko eba kaupuwaiwogoi.” ");
INSERT INTO gdn_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Apunu Diyoni inako dimawagawa ka iyapana notamaga kipu ubupu, tagubu ke; “Apunu yau ka bani nu Iya Negeyana Apunai Keriso ba bauwena yau kena.” ");
INSERT INTO gdn_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Mu inako wainapamawa ki sisiyai apunu Diyoni wainapupu ki pokere e iyapana ki kuduba yona yau tadebu, wagubu ke; “Nau ka awana pokaiya wi siruwaniyakani ko nau ewaneya ka apunu mosi baiyagisi. E kasiyarai ka kawaya esida ko nau kasiyarani ka maraitau erida. Nau e bigabigai kwaesugana waitapana e kerarai kwakwarai rikapana ko nau eba bagi da nau upi ki kwaesugani. E baiyagisi ki ka e Mamanuga God e Keyai Tanai Bagi Kawaya ki kasiyarai pokaiya ade mata nonarai pokaiya wi siruwaniyoto. ");
INSERT INTO gdn_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","E diba idaiya wadubu kewowena ki pokaiya e gwaba madai ki tekwaripoto da mibai gwegwetagisi wateya ukwo-pomoto ko gwaba ki kwarai ki ka mugu ki nusuru tepoto madaneya nakapoto. Gwaba mibai gwetagubu ki e tepoto e tawaiya magara nakapoto ko mugui ki e mata maramara urau ko ewa mo eba poyagisi ki wateya isiyapoto.” ");
INSERT INTO gdn_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Apunu Diyoni e bonanai ragiragi kawaya yona ebo ebo iyapana tadeyawa teyateyama. Ade e ubupu Mamanuga God e yonai bagi kawaya ki mete dimawagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ko apunu kawai Erodi e nuwai pupuwena apunu Diyoni bameya mibai ka Diyoni ubupu e nakaripupu, wagubu ke; “Kau berokoi kwaenugibi kau nadawagi Erodiyasi kuwanugibi uwapi.” Apunu Erodi e eba berokoi ki mena kwaewena ko e berokoi ebo ebo dai mete kwaewagawa ki pokere Diyoni ubupu e inako nakari-pupu. ");
INSERT INTO gdn_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Apunu Erodi berokoi kuduba kwaewena ki kawareya ka e yau mete kwaewena; E apunu Diyoni wadubu dibura rabineya tapu. ");
INSERT INTO gdn_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Apunu Diyoni iyapana kuduba siruwatapu kewowena eweya ka e Iyesu mete siruwapupu. Ki eweya, Iyesu guriguriwagawa ki makeya, ka kunuma gudui siwawena, ");
INSERT INTO gdn_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","manako Mamanuga God e eya Keyai Tanai Bagi Kawaya midiwari umago maba kawapu Iyesu kawareya tondubu, manako bonana mosi kunuma were kawapu, wagubu ke; “Kau ka nau Gubagani. Nau nuwaneya po kau ki pokere kau mamamagi nau karako wainapakani.” Bonana ki inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","38","Iyesu bauwena Mamanuga God e upi kerarai birikapupu ki makeya ka e kwamurai apunai eyaka mena kewo-wena ida esida mena (v30). Iyapana naiya wenamaga eyaka mena wenatagamawa kebomawa da siyarai Iyesu wenawena mu simaga ka yau kena; (v38) Kerareya ka Mamanuga God apunu Adamu pasipupu. Adamu ubupu manako e gubagai Seti wenawena. Seti ubupu manako e gubagai Inosi wenawena. (v37) Inosi ubupu manako e gubagai Keinani wenawena. Keinani ubupu manako e gubagai Marareo wenawena. Marareo ubupu manako e gubagai Diyere wenawena. Diyere ubupu manako e gubagai Inoki wenawena. Inoki ubupu manako e gubagai Mesusera wenawena. (v36) Mesusera ubupu manako e gubagai Remeki wenawena. Remeki ubupu manako e gubagai Nowa wenawena. Nowa ubupu manako e gubagai Semu wenawena. Semu ubupu manako e gubagai Apakesedi wenawena. Apakesedi ubupu manako e gubagai Keinani wenawena. (v35) Keinani ubupu manako e gubagai Sira wenawena. Sira ubupu manako e gubagai Iba wenawena. Iba ubupu manako e gubagai Pereki wenawena. Pereki ubupu manako e gubagai Reu wenawena. Reu ubupu manako e gubagai Seroki wenawena. (v34) Seroki ubupu manako e gubagai Neyo wenawena. Neyo ubupu manako e gubagai Tera wenawena. Tera ubupu manako e gubagai Eburamu wenawena. Eburamu ubupu manako e gubagai Aisiki wenawena. Aisiki ubupu manako e gubagai Diyaikapu wenawena. Diyaikapu ubupu manako e gubagai Diyuda wenawena. Diyuda ubupu manako e gubagai Peresi wenawena. Peresi ubupu manako e gubagai Esironi wenawena. Esironi ubupu manako e gubagai Anai wenawena. Anai ubupu manako e gubagai Atamini wenawena. (v33) Atamini ubupu manako e gubagai Aminadapu wenawena. Aminadapu ubupu manako e gubagai Nasoni wenawena. Nasoni ubupu manako e gubagai Saramoni wenawena. Saramoni ubupu manako e gubagai Bowasi wenawena. Bowasi ubupu manako e gubagai Obedi wenawena. Obedi ubupu manako e gubagai Diyese wenawena. (v32) Diyese ubupu manako e gubagai Dewida wenawena. Dewida ubupu manako e gubagai Natani wenawena. Natani ubupu manako e gubagai Matata wenawena. Matata ubupu manako e gubagai Mena wenawena. (v31) Mena ubupu manako e gubagai Mereya wenawena. Mereya ubupu manako e gubagai Erayakimi wenawena. Erayakimi ubupu manako e gubagai Diyonamu wenawena. Diyonamu ubupu manako e gubagai Diyosepa wenawena. Diyosepa ubupu manako e gubagai Diyuda wenawena. Diyuda ubupu manako e gubagai Simiyoni wenawena. (v30) Simiyoni ubupu manako e gubagai Riwai wenawena. Riwai ubupu manako e gubagai Matata wenawena. Matata ubupu manako e gubagai Diyorimi wenawena. Diyorimi ubupu manako e gubagai Eriyesa wenawena. (v29) Eriyesa ubupu manako e gubagai Diyosuwa wenawena. Diyosuwa ubupu manako e gubagai Eri wenawena. Eri ubupu manako e gubagai Eremadamu wenawena. Eremadamu ubupu manako e gubagai Kotami wenawena. Kotami ubupu manako e gubagai Adi wenawena. Adi ubupu manako e gubagai Meruki wenawena. (v28) Meruki ubupu manako e gubagai Narai wenawena. Narai ubupu manako e gubagai Siyasiyero wenawena. Siyasiyero ubupu manako e gubagai Serababero wenawena. Serababero ubupu manako e gubagai Resa wenawena. (v27) Resa ubupu manako e gubagai Diyonani wenawena. Diyonani ubupu manako e gubagai Diyoda wenawena. Diyoda ubupu manako e gubagai Diyoseki wenawena. Diyoseki ubupu manako e gubagai Semaini wenawena. Semaini ubupu manako e gubagai Matataiyasi wenawena. Matataiyasi ubupu manako e gubagai Masu wenawena. (v26) Masu ubupu manako e gubagai Nagui wenawena. Nagui ubupu manako e gubagai Esiri wenawena. Esiri ubupu manako e gubagai Neuma wenawena. Neuma ubupu manako e gubagai Aimosi wenawena. (v25) Aimosi ubupu manako e gubagai Matataiyasi wenawena. Matataiyasi ubupu manako e gubagai Diyosepa wenawena. Diyosepa ubupu manako e gubagai Diyanai wenawena. Diyanai ubupu manako e gubagai Meruki wenawena. Meruki ubupu manako e gubagai Riwai wenawena. Riwai ubupu manako e gubagai Matata wenawena. (v24) Matata ubupu manako e gubagai Erai wenawena. Erai ubupu manako e gubagai Diyosepa wenawena. Diyosepa ubupu manako e gubagai Iyesu wenawena. (v23) Iyapana Iyesu mamai Diyosepa simupu, ko Iyesu e ka eba apunu Diyosepa e gubagai mibai. ");
INSERT INTO gdn_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Mamanuga God e Keyai Tanai Bagi Kawaya Iyesu rabineya posiwena kasiyara kwebu manako Iyesu awana Diyoudani kamadubu wirawena ki makeya ka Mamanuga God e Keyai ki bauwena e yabiripupu bananapupu iyapana eba idiwu tawaneya ki kaya-tagubu. ");
INSERT INTO gdn_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Mu ika bautagubu ka Berokoi Apunai Seitani ubupu Iyesu bameya bauwena manako mara apunai apeya kewowena (40) ki rabineya ka e maramara Iyesu beraberapiyawa kerapu taisinipiyawa. Mara ki rabineya ka Iyesu bani eba kupawa ko e maramara pa umawa wadawa da ewa wetei mebu. ");
INSERT INTO gdn_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","E wetei meyawa makeya ka Seitani e bameya bauwena sibu, wagubu ke; “Kau God e Gubagai baganai ki kau nuwagi da bowa yau bani wenayagisi kupi.” E inako wagubu, ");
INSERT INTO gdn_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ko Iyesu denai e sibu, wagubu ke: “Mamanuga God e okai mosi inako wagubu ke; ‘Iyapana iyamaga kerarai ka eba bani mena.” ");
INSERT INTO gdn_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Ko Seitani ade ubupu Iyesu yabiri-pupu ewapuru iyarau mo yamupu manako namari maba mo garugaru mena wadubu tawana tawana, madega kauwagau madega posiwagau ki kuduba minibu siwa matarau emupu. Empamawa ka Seitani wirawena Iyesu sibu wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","“Gwedegwede bagibagi yau kuduba empiyei ki kasiyarai mete kina ki nau kau negeyani. Yau kuduba ka nau nene ki pokere nau nuwaneya iyapana mo kweyana wainapani ki nau e kweyani. ");
INSERT INTO gdn_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Ko kau naiya nau parausini nau yabaraneya kwarisinuwagi ramatagi kawareya uburi nau sini tepapi were ewa ki nau bagibagi yau kuduba kau negeyani.” E inako wagubu, ");
INSERT INTO gdn_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ko Iyesu denai e sibu, wagubu ke: “Mamanuga God e okai mosi wagubu ke; ‘Nu Mamanuga God e ebo mena si tepapomu ade e mena notapomu bigabigai kwaigomu.” ");
INSERT INTO gdn_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Berokoi Apunai Seitani Iyesu yonai ki wainapupu bananapupu natere kawaya Diyerusaremu kayatagubu manako e Iyesu wadubu Mamanuga God e Tawai ki tagaiya iyarau yamupu manako sibu, wagubu ke; “Kau God e Gubagai baganai ki kau kwarara yau sikipi wairau uburi.” E inako wagubu, ade wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","“God oka yau tapu, wagubu ke; ‘Nau aneyaniyoma tonotamani eminimoto naigida mena kwayubanimoto.’ ");
INSERT INTO gdn_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Ade e oka yau mete tapu; ‘Aneya idamaga rabineya kau wadinimoto sumoto ki pokere kau keraragi bowa eba miniyoto.’” Berokoi Apunai Seitani e Mamanuga God yonai kawareya inako wagubu, ");
INSERT INTO gdn_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ko Iyesu wirawena e empupu manako denai sibu, wagubu ke; “Mamanuga God e okai mosi inako wagubu ke; ‘Wi nau kasiyarani matarau empamana ki nana asusu eba kwaiwogoi.” ");
INSERT INTO gdn_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Berokoi Apunai Seitani e Iyesu beraberapiyawa kerapu taisinipiyawa da kewowena manako kamadubu kayawena. Ko e eba deni mena kamadubu kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Mamanuga God e Keyai Tanai Bagi Kawaya Iyesu rabineya posiwena ki kasiyarai pokaiya ka e wirawena tawana Gariri ade kayawena. E ika bauwena ki sisiyai garugaru mena kawayawena kayawena tawana ki rabineya iyapana kuduba wainamupu. ");
INSERT INTO gdn_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","E Diyu ragidai mu gurigurimaga tawai ebo ebo ki rabineya iyapana tadeyawa kabukabuwa umawa ade iyapana kuduba e mamamai tagamawa e si esida mena tepapamawa. ");
INSERT INTO gdn_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ki eweya ka Iyesu e naiya kwempu kawaya ki wateya natere Nasareta ade bauwena. Aiyata marai ki makeya ka e maramara guriguri tawaiya kayawagawa ki pokere e karako ika Nasareta bauwena ka e inako mete kwaewena guriguri tawaiya yapu. E iyapana paunamugu Mamanuga God e okai mo iyabapana ki nana bagi ubupu, ");
INSERT INTO gdn_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","manako mu kaimpu Mamanuga God e bonanai wainapiyawa wagawa apunai Aisaiya takari kawaya oka badidi okapupu wikumupu ki Iyesu kwemupu manako e wiku ki rikapupu wadubu rorona manako yona yau iyabapupu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","‘Mamanuga God e nau winesinibu, manako e eya Keyai nau rabinaneya tapu minibu siwa da nau kayasugana e yonai bagi kawaya iyapana imagei ragidai tadeyana ki nana. Umatampu dokodoko ragidai mu idamaga kerapumaga rikawagana sisiyai mu tadeyana ki nana ka e nau tonosinibu. Iyapana yabumaga kenewena ki tawana ade empamana ade iyapana bita kawaya wadamu ki bitamaga tekatekawagana ki nana ka nau bausugubuwani. ");
INSERT INTO gdn_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Mamanuga God e iyapanaiyoma iyatamana ki marai bauwena ki sisiyai nau mu tadeyani.’ ");
INSERT INTO gdn_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Iyesu oka ki iyabapupu kewowena ade wikupupu tawa ki kawaimaga ade kwebu manako kwarisiwena tondubu. Iyapana kuduba tawa ki rabineya e yabu dokopamawa idiwa, ");
INSERT INTO gdn_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","manako e tadebu, wagubu ke; “Nau oka yau iyabapekeya ki mibai karako wi yabugere makeya makeya matarawena.” ");
INSERT INTO gdn_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Iyapana kuduba e badidi wagubu ki wainamupu ka mu mamamatagubu mibai ka e yonai ka midiyai kawaya. Ko mu ade notamaga babawena mu mubo mubo tagubu ke; “E ka apunu Diyosepa e gubagai diyayai wainapemei ko e badidi maba yona bagi kawaya inako wagau?” ");
INSERT INTO gdn_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Ko Iyesu denai tadebu, wagubu ke; “Nau kataineya da iyapana tagamu yonai ki wi wirapumuri nau sidimuri, iwagi ke; ‘Iyapana Iyatamiyei Apunai, kau karako kiya iyanuwagi.’ Ade wi yona yau mete sidimuri, iwagi ke; ‘Kau natere Kaponiyamu rabineya badidi kwaenugeya wainamipi ki maba kau karako kau kiya tawanageya yewe mete kwaenuwagi da nu kau eminiyamu.’ ");
INSERT INTO gdn_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ko nau karako kawareya ade suwagani wainapumuri; Mamanuga God e bonanai wainapiyau wagau apunai e ebo tawaneya baiyagisi ki ka e eya iyapanaiyoma e diriwai eba kwae-tagisi. ");
INSERT INTO gdn_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Nau nidiyani wainapumuri; Naiya takari kawaya Mamanuga God e bonanai wainapiyawa wagawa apunai Eraidiya tondawa ki makeya ka ridi koboro ropani kawaya tawana Isiraero rabineya idiwa. Kwamura apeya eyaka ade siragamu ida daikere kewowena daikere eyaka mena ki rabineya ka nawaya mo eba bauwena ki pokere tawana kuduba ka kapoi kawaya ubupu. ");
INSERT INTO gdn_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Koboro taubanuwai ropani kawaya ika mibi wetei idiwa ko Mamanuga God e eba ubupu oragai apunai Eraidiya mu waitamaga nene tonopupu. Pa mena. Ridi kwaiyanai mosi ki tawana Saidoni natere Sarepita rabineya koborowena ki e mena bameya ka e apunu Eraidiya tonopupu. ");
INSERT INTO gdn_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ade Mamanuga God e bonanai wainapiyawa wagawa apunai Eraisa tondawa ki makeya ka tawana Isiraero taubanuwai ropani kawaya mu kwakwarepumaga kwatakwatawena. Mu ropani kawaya inako sigiratagubu idiwa ko oragai apunai Eraisa mu mo eba iyatapu ko e ubupu tawana Siriya ragidai mu apunumaga Namani ki e mena iyapupu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Iyapana kuduba guriguri tawai ki rabineya Iyesu yonai wagubu ki waina-mupu ka mu nuwamaga pupuwena, ");
INSERT INTO gdn_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","manako mu kimpu ubumpu e weumpu kwenumpu matarau bautagubu manako tainimupu gari tagaiya kayatagubu. Mu nateremaga ka kweya mo kwauneya ki pokere mu e kwarareya kaupamana ki nana wainamupu. ");
INSERT INTO gdn_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Ko Iyesu mu yabumaga minibu manako mu pauna-mugu bauwena kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ki eweya ka Iyesu natere Kaponiyamu tawana Gariri rabineya ki kayawena umawa da bauwena manako aiyata marai ki makeya ka e iyapana ika idiwa mete tadeyawa kabukabuwa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Iyapana kuduba e yonai wainamupu ki mu notamaga kowena kodabamaga kamupu mibai ka e yonai ki kasiyarai ka kawaya. ");
INSERT INTO gdn_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Diyu ragidai gurigurimaga tawai ki rabineya ka apunu mosi ika mete kina ki e rabineya kweya kairapu mosi tondawa. Apunu ki Iyesu empupu ka e bonanai ragiragi kawaya kwewena wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Iyesu tawana Nasareta apunai, kau nu bamanugu badidi kwaenugana ki nana baunugibi? Kau nu giriniyana ki nana baunugibi bo? Nau kataineya kau. Kau ka Mamanuga God e bibi tononibu apunai bagi kawaya.” ");
INSERT INTO gdn_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","E inako wagubu, ko Iyesu keyai berokoi apunu ki rabineya tondawa ki empupu manako siwakekepupu ragiragi kawaya sibu, wagubu ke; “Kau yona kererenuwagi apunu yau kamadi baunuwagi kayanuwagi.” E inako wagubu makeya ka keyai berokoi ki apunu ki wadubu kwisipupu iyapana yabaramugu kwenupupu manako bauwena kayawena. Ko apunu ki bidara mo eba wadubu. ");
INSERT INTO gdn_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Iyapana kuduba Iyesu matakira badidi kwaewena ki emupu ka mu notamaga kowena mu mubo mubo kowamuguma mete manu kasiwara-tagubu, tagubu ke; “Yau ka badidi? Yau ka kabuwa waunai mosi bo? Apunu yau e kasiyarai ka kawaya. E keyai berokoi siwakeketamiyau wagau ki ka mu e bonanai wadamu bautagamu kaya-tagamu.” ");
INSERT INTO gdn_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Mu inako tagamawa manako Iyesu badidi kwaewena ki sisiyai tawana ki rabineya tawa tawa kawayawena kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Iyesu Diyu ragidai mu guriguri-maga tawai ki kamadubu manako apunu Saimoni tawaiya kayawena. E ika bauwena ka apunu Saimoni e memenagui ridai ki muyamuyawena ika ukwarawa ki sisiyai mu Iyesu simupu, ");
INSERT INTO gdn_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ki pokere e kanibu ridi kebari kawareya ukwarawa ki e madaneya ubupu manako e bonanai ragiragi kawaya sigira ki baiyonopupu. Ki makeya ka ridi ki e muyai ki kewowena manako e deni mena kipu ubupu kanibu mu diriwamaga kwaewena bani dai warapupu tagebu. ");
INSERT INTO gdn_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Kemorawagana kwaewagawa ki makeya ka iyapana ubumpu mu kowa-muguma sigisigirai ropani kawaya sigiramaga ebo ebo ki tetampu Iyesu bameya bautagubu manako e ubupu e idai mu eyaka eyaka kawarimugu tapu da mu kuduba iyatagubu gawarara. ");
INSERT INTO gdn_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kweya kairapu iyapana dai rabina-mugu idiwa ki e mete siwakeketapu da mu matarau bautagubu bonanamaga ragiragi kawaya tagubu ke; “Kau ka Mamanuga God e Gubagai.” Kweya kairupu ki mu kataimugu da e ka Keriso ki pokere e mu tatamatapu da mu e sisiyai matarau eba tagamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Mu ukwapamawa da nawaru dumai tarawa ki makeya ka Iyesu e eya mena kipu ubupu iyapana kuduba yabumaga sipeya gari tagaiya kayawena. Ko iyapana e kwaenepamawa iwa da bananamupu manako munamupu da e mu eba kamaditamana kayawagana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Ko e denai tadebu, wagubu ke; “Iyapana Mamanuga God e gari rabineya e kasiyarai pokaiya idiwana ki yonai bagi kawaya ka nau iyapana tawana tawana kuduba mu mete tadeyana ki nana. Nau Mamai ki nene nau tonosinibu bausugubuwani ki pokere nau yewe mena eba tondoni ko tawana tawana mete kayasugani dimasugoni umoni.” ");
INSERT INTO gdn_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Iyesu tawana tawana umawa wadawa Diyu ragidai mu gurigurimaga tawai rabineya dimawagawa iyapana tadeyawa kabukabuwa umawa. ");
INSERT INTO gdn_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Mara mosi ka Iyesu kaburu kawaya Genesare papateya uburawa manako iyapana ropani kawaya Mamanuga God e yonai wainapamana ki nana ika bautagubu e kwagarampu paupunampu ubumawa. ");
INSERT INTO gdn_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ika kaburu papateya ka waka apeya ika nakamupu ki kimai ragidai kaburu papateya puwarimuguma ika siruwatamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Waka ki mosi ka apunu Saimoni e nene manako Iyesu waka ki kawareya yapu apunu Saimoni sibu, wagubu ke; “Kau waka riyapi da kaburu kaniyoto.” Apunu Saimoni waka riyapupu manako Iyesu waka ki rabineya tondawa iyapana ropani kawaya kaburu papateya idiwa ki tadeyawa kabukabuwa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","E yonawagawa da kewowena ka e apunu Saimoni ade sibu, wagubu ke; “Kau kowagiyoma mete kina waka riyapumuri kaburu paunau kaniyoto manako raubiyo nene puwari nunumuri.” ");
INSERT INTO gdn_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Ko apunu Saimoni denai e sibu, wagubu ke; “Sidiyei Kabukabuwa Apunai, kemora ka nu kimaigemeya idiweya da nawaru yabunugu puruwena ko nu raubiyo mo eba wadimipi. Ko kau nuwegei ki pokere nau puwari ade kaupani ka baganai.” ");
INSERT INTO gdn_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Apunu Pita e kowaiyoma mete kina puwari ki nunu-mupu ka puwari rabineya raubiyo posiwena da puwari waunitau purupuru-tagamana kwaetagubu, ");
INSERT INTO gdn_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ki pokere mu kowamuguma waka mosi kawareya ki kebomana mu waitatamana ki nana ida were taunimupu. Mu bautagubu ka mu ewapuru raubiyo kuduba waramupu waka apeya positampu da waka apeya ki waunitau kaburu sumana kwae-tagubu. ");
INSERT INTO gdn_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Apunu Saimoni si daikere ka Pita raubiyo ropani kawaya ki empupu ka e Iyesu yabareya kwarisiwena e ramatai kawareya ubupu manako sibu, wagubu ke; “Kaiwawoni, nau ka apunu berokoi bigibigi ki pokere nau kamadisini kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","10","Mu raubiyo ropani kawaya temupu ki matakirai ka apunu Saimoni e iyapanaiyoma ade e kowaiyoma apunu Tabadi gubagaiyoma Diyemesi yo Diyoni mete kina emupu manako mu notamaga kowena kodabamaga ka-mupu. Ko Iyesu wirawena apunu Saimoni sibu, wagubu ke; “Kau kudu eba wainapiyowa. Kau karako raubiyo tepipi ki maba ka mara karako ade mara ewa ki kau iyapana tepiyowa.” ");
INSERT INTO gdn_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Ki makeya ka mu wakamuguma tainitampu borau nakatampu manako gwedegwede kuduba ika kamaditampu Iyesu eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Mara mosi Iyesu natere mo bauwena ka apunu mosi sigira berokoi mo wadubu e kwakwarepui kwatakwatawena ki ika tondawa. Apunu ki Iyesu bauwena empupu ka e garugaru mena yabadubu Iyesu yabareya gwairiwena nikapu mebu manako genepupu sibu, wagubu ke; “Kaiwawoni, kau kaubo nuwageya nau nene wainapiyei ki kau nau wadisini bagi.” ");
INSERT INTO gdn_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Iyesu apunu ki e nuwaboyai wainapupu ki pokere e idai roronapupu e mideya tapu manako sibu, wagubu ke; “Nau nuwaneya kau iya negeyani ki pokere kau sigiragi ki nau karako surupakani da kewoyagisi.” Iyesu yona ki wagawa makeya ka apunu ki e sigirai garugaru mena kewowena e midai wateya wateya bauwena manako e iyawena. ");
INSERT INTO gdn_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Ko Iyesu apunu ki tatama-pupu sibu, wagubu ke; “Nau karako iyanibuwani ki sisiyai kau iyapana eba tade ko kau deni mena Mamanuga God bameya dobopiyamu ragidai mu bama-mugu kayanuwagi da mu kau eminimoto manako ewa kayanuwagi oragai apunai Mosisi gora tapu ki makeya makeya kwaenuwagi puyo Mamanuga God bameya tari da iyapana ki empomoto ki mu kataitagisi da kau sigiragi wana kewowena.” ");
INSERT INTO gdn_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Iyesu apunu ki tatamapupu ko e bameya badidi kwaewena ki sisiyai garugaru mena kawayawena kayawena iyapana tawana tawana wainamupu ki pokere iyapana ropani kawaya eba bigabigai Iyesu bameya bautagamawa e yonai wainapamana ade e uburana mu sigiramaga ebo ebo ki iyatamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Ko mara dai ka Iyesu tawana tawana matarau eba umawa ko e gari tagaiya e ebo mena guriguriwagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Mara mosi Iyesu iyapana tadeyawa kabukabuwa tondawa ka Parisi ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina ika bautagubu e yonai wainapamawa empamawa idiwa. Mu ka natere natere kuduba tawana Gariri rabineya, tawana Diyudiya rabineya, ade natere Diyerusaremu were mete bau-tagubu. Iyesu yonawagawa makeya ka Mamanuga God iyapana iyatamana ki kasiyarai e rabineya posiwena, ");
INSERT INTO gdn_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","manako ki makeya ka iyapana dai ki mu waretamaga sigirawena e idai kerarai badabadamawena bisi kaya-wena gagara rabineya tamupu ki wadumpu ika bautagubu. Mu nuwa-mugu tawa rabineya yamana apunu ki wadamana Iyesu yabareya tamana ki nana, ");
INSERT INTO gdn_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ko tawa rabineya iyapana posiwena yamana watai pa mena ki pokere mu apunu ki wadumpu tawa tagaiya yamupu manako Iyesu tondawa kawareya tawa tagai wadumpu bebere apunu ki mibi gagarai taburuba pokaiya kwimpu kaumpu iyapana paunamugu Iyesu yabareya supu. ");
INSERT INTO gdn_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Mu sumamaga kawaya daganani Iyesu bameya ki Iyesu empupu ki pokere e sigira apunai ki sibu, wagubu ke; “Waretani, kau bigigi ki nau empuwani karako surupakani.” ");
INSERT INTO gdn_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Iyesu yona ki wagubu ka Mama-nuga God e gorai kataimugu ragidai ade Parisi ragidai ika idiwa wainamupu manako mu mubo mubo manu kasiwaratagamawa, tagamawa ke; “Apunu yau ka nima? Mamanuga God e mena nu biginuga empiyau surupiyau ki pokere apunu yau berawagau Mamanuga God e si giripiyau.” ");
INSERT INTO gdn_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Mu inako notapamawa ko mu notamaga ki kuduba ka Iyesu empupu ki pokere e wirawena mu manutapu, wagubu ke; “Wi gwede nana inako notapiyamu wereyakaurasiniyamu? ");
INSERT INTO gdn_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","24","Nau sigira apunai yau e bigi surupana ki nana suwagubuwani ko wi bera umani nau sidimupu mibai ka wi wainapiyamu da ki ka pa yona da muyai pa mena. Ko nau karako yona ade mosi suwagani manako wi nau matakirani muyai kawaya empumuri. Nau Kunumau Kawapuwani Apunai iyapana bigimaga empana surupana ki kasiyarai wadubuwani ki wi karako nau mibisinimuri.” E inako wagubu manako wirawena sigira apunai ki sibu, wagubu ke; “Kau kiri uburi kebarigi ewopi kawarapi kau tawageya kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Iyesu yona ki wagawa makeya ka apunu ki iyapana kuduba yabumugu garugaru mena kipu ubupu e kebari ewopupu kawarapupu manako mibi mamamai Mamanuga God e si tepapupu e ebo tawaiya kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Iyapana kuduba ika idiwa matakira ki emupu ka mu notamaga kowena kudu mete wainamupu manako Mamanuga God e si esida tepapamawa, tagamawa ke: “Karako ka nu gwede bagi kawaya mosi nu nubo yabunugere emipi.” ");
INSERT INTO gdn_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ki eweya ka Iyesu tawa ki kamadubu matarau bauwena manako iyapana wairamaga denai takesi tamawa ki wadawa apunai mosi si ka Riwai ika takesi wadawa wateya tondawa empupu. Empupu manako sibu, wagubu ke; “Kau karako yabi nau ewaneya uburi mete kaigamu.” ");
INSERT INTO gdn_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","E inako wagubu manako apunu Riwai deni mena kipu ubupu e gwedegwedei kuduba ika kamadubu manako Iyesu eweya kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Mara mosi ka apunu Riwai e ebo tawaiya kupe kawaya mo Iyesu nene kwaewena. Iyapana takesi wadamawa ragidai ropani kawaya ade iyapana dai ki mete kina ika bautagubu Iyesu mete kupetagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Parisi ragidai ade mu kowamuguma Mamanuga God e gorai kataimugu ragidai mete kina Iyesu ika iyapana mete kupetagamawa idiwa emitampu ka mu gagayatagubu manako kaimpu Iyesu tadeyau kabukabuwa ragidai manutampu, tagubu ke; “Wi badidi pokere takesi wadamu ragidai ade iyapana bigi kwaetagamu nu tagararatamemei ragidai ki mu mete kupeiwagamu idiwu?” ");
INSERT INTO gdn_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Iyesu mu yonamaga ki wainapupu ka e denai tadebu, wagubu ke; “Sigira ragidai ki mu mena ka muramura apunai bameya kayatagisi ko midimaga bagi ragidai ki mu ka muramura apunai ki e bameya asusu eba kayatagisi. ");
INSERT INTO gdn_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Nau ka eba iyapana bagi supasupai ki mu nene bausugubuwani ko nau iyapana bigi kwaetagamu ragidai ki mu nene bausugubuwani da mu notamaga wirayagisi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Iyapana dai Iyesu bameya bau-tagubu manako simupu, tagubu ke; “Apunu Diyoni e tadeyau kabukabuwa ragidai ade Parisi ragidai mu tadeyamu kabukabuwa ragidai mete kina ki mu kuduba ka mara dai Mamanuga God nene bani kamadamu pa guriguritagamu idiwu ko kau tadeyei kabukabuwa ragidai mu ka badidi pokere inako eba kwaetagamu ko mu bani kupamu ade awana mete kubamu?” ");
INSERT INTO gdn_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Iyapana ki inako tagubu ko Iyesu denai tadebu, wagubu ke; “Wi badidi wainapiyamu? Anika waunai kupei ki kawareya ka apunu ewai ade ridi ewai bani eba kupomono ko pa idiwono bo? Ae, pa mena, bananatamini kupe ki kawareya baitagisi ki ka mu eba nuwa-boya maba idiwono ko anika waunai ki apunai mete kupetogomono idiwono. ");
INSERT INTO gdn_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Ko mara baiyagisi da iyapana anika waunai apunai ki yadini dokodoko kayatagisi. Mara ki makeya ka e kowa-iyoma nuwaboyatagisi bani kamadini.” ");
INSERT INTO gdn_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Iyapana nota oragai ade nota waunai ki eba dibipamana ki nana ka Iyesu keyakeyai mosi mu ade tadebu, wagubu ke; “Iyapana mosi e midi tatamai oragai tegereyagisi ki ka e eba uburoto e midi tatamai waunai mosi tegerepoto tenai yadini manako oragai ki naureya popopoto. Pa mena. E inako kwaeyagisi ki ka e midi tatamai waunai ki giripoto ade dabuwa tenai wadubu ki ka eba dabuwa oragai ki mete kiyabu-maga eyaka mena. ");
INSERT INTO gdn_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","38","Ki maba; Awana ‘waeni’ waunai ki wi awana kororai papa kwakwarai waunai wakamupu ki rabineya gwepumuri. Awana kororai ki ka nenanenaitau ki pokere awana ‘waeni’ ebo totoripoto kawayayagisi ki ka kororai ki mete kawayayagisi. Ko wi awana ‘waeni’ waunai ki awana kororai oragai kakokakowena ki rabineya gwepumuri ki ka awana ‘waeni’ waunai ki totoripoto kawayayagisi ko awana kororai ki ka kakokakoi ki pokere wateya tondono da baurayagisi manako awana ‘waeni’ ki baiyagisi kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ade keyakeyai mosi ka yau kena; Iyapana awana ‘waeni’ waunai kubomoto ade oragai mete kubomoto ki ka mu waunai ki kamadini oragai mena wainapomono mibai ka awana ‘waeni’ oragai ka midiyai bagi kawaya ko awana ‘waeni’ waunai ka midiyai pa mena.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aiyata marai ki makeya ka Iyesu e tadeyau kabukabuwa ragidai mete kina tawana mo kayatagubu manako yawatau ka mu kokora mo kawareya bautagubu. E tadeyau kabukabuwa ragidai kokora ki kawareya kaiwa ka mu gwaba mosi ki madai dai asusu toporu-pamawa tepamawa idamugu koto-pamawa manako madai mibai ki kupa-mawa kaiwa. ");
INSERT INTO gdn_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ko Parisi ragidai dai mu emitampu manako manutampu, tagubu ke; “Wi badidi pokere inako kwaiwagamu? Nu goranuga aiyata marai nene badidi wagau ki wi raurupiyamu.” ");
INSERT INTO gdn_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Ko Iyesu denai iyapana ki tadebu, wagubu ke; “Takari kawaya oragai apunai Dewida badidi kwaewena ki bususui mu oka tampu ki wi iyabamupu kataigubu bo pa mena? E kowakowai-yoma mete kina wetei metapu, ");
INSERT INTO gdn_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","manako oragai apunai Dewida Mamanuga God e Tawai rabineya yapu bani buredi ki iyapana Mamanuga God nene puyo ika nakamupu ki dai e tepupu kubabu ade dai mete tepupu e kowakowaiyoma tagebu kupamupu. E inako kwaewena, ko gora wagau da bani ki ka Mamanuga God bameya dobopiyamu ragidai ki mu mena kupomoto.” ");
INSERT INTO gdn_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Iyesu inako wagubu, ade tadebu, wagubu ke; “Kunumau Kawapu Apunai e ka aiyata marai ki Debai. E ka kawaya esida ko aiyata marai ki ka erida.” ");
INSERT INTO gdn_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Aiyata marai mosi ka Iyesu Diyu ragidai mu gurigurimaga tawai mo yapu manako e ubupu iyapana ika tadeyawa kabukabuwa tondawa. Apunu mosi ika tondawa e idai garu ka kiyokiyowena bisi kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ko mara ki ka aiyata marai ki pokere Mamanuga God e gorai kataimugu ragidai ade Parisi ragidai dai mete kina ika bautagubu Iyesu naigida mena empamana ki nana idiwa. Mu wainamupu da e sigira ragidai aiyata marai ki makeya iyatamini bo gwede mo paerepoto gora raurupoto ki ka mu ubumoto e pari wirawirapomoto. ");
INSERT INTO gdn_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Mu inako notapamawa ko mu notamaga ki ka Iyesu e ororeya mena empupu kewowena ki pokere e apunu idai kiyokiyowena apunai ki sibu, wagubu ke; “Kau yabi yewe iyapana yabara-mugu uburi.” E inako wagubu manako apunu ki kipu ubupu kanibu iyapana kuduba mu yabaramugu ubupu. ");
INSERT INTO gdn_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Ko Iyesu iyapana tadebu, wagubu ke; “Wi nau sidimuri da nau wainapani; Aiyata marai ki ka nu bagi kwaigomu bo berokoi kwaigomu? Ade nu iyapana iyatamomu bo giritamomu? Nu goranuga ki nene badidi wagau?” ");
INSERT INTO gdn_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","E wirawena mu kuduba emitamiyawa da kamadubu manako ade wirawena idai kiyokiyoi apunai ki sibu, wagubu ke; “Kau idagi roronapi.” Apunu ki e idai roronapiyawa makeya ka e idai ki garugaru mena supasupawena. ");
INSERT INTO gdn_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Kawakawai ragidai matakira ki emupu ka mu nuwamaga pupuwena manako mu mubo mubo tagamawa kasiwara Iyesu bameya badidi kwaetagamana ki keketai kupamawa. ");
INSERT INTO gdn_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Mara ki makeya ka Iyesu e eya mena kweya mo yapu posiwena manako kemora ki rabineya ika Mamanuga God bameya guriguriwagawa tondawa da nawaru puruwena. ");
INSERT INTO gdn_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Nawaru puru-wagawa ka e ubupu e tadeyau kabu-kabuwa ragidai ki mu nene wagubu bautagubu manako apunu mena ida esida kewowena kerapu apeya winetapu mu simaga e ‘Tononotapu Ragidai’ tadebu. E winetapu ragidai eyaka eyaka mu simaga ka yau kena; ");
INSERT INTO gdn_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Apunu Saimoni ki e si daikere Pita sibu ade Saimoni e yowai Enduru mete kina. Apunu Diyemesi yo apunu Diyoni, apunu Piripo yo apunu Batoromaiya, ");
INSERT INTO gdn_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","apunu Mateyu yo apunu Tomasi, apunu Arapiyo gubagai si ka Diyemesi, apunu Saimoni mosi (e ka iyapana wairamaga gwandagi wagau ki apunai mosi), ");
INSERT INTO gdn_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","apunu Diyemesi gubagai si ka Diyudiyasi ade apunu Diyudiyasi Isikariyoto. E ka Iyesu yogoi wagubu ki apunai. ");
INSERT INTO gdn_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Iyesu e tonotapu ragidai mete kina kweyau kawamawa da dobu mo bau-tagubu ka e tadeyau kabukabuwa ragidai ropani kawaya e ika kwagara-mupu ubumawa. Iyapana ropani kawaya natere natere kuduba tawana Diyudiya rabineya ade natere Diyerusaremu ade natere Taya yo Saidoni egi papasi deneya ki mete ika bautagubu e kwagaramupu ubumawa. ");
INSERT INTO gdn_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","19","Mu nuwamugu e badidi kabuwawagawa ki wainapamana ade e uburana mu sigiramaga ebo ebo ki mete iyatamana ki nana ika bautagubu. Iyesu kasiyarai e rabineya ki matarau bau-wagawa kayawagawa da iyapana iyatagamawa ki pokere mu kuduba e geyapamana manako iyatagamana ki nana wainapamawa. Iyapana gwedewau keyai berokoi mu giritamiyawa ki mu mete bautagamawa manako mu iya-tagamawa. ");
INSERT INTO gdn_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Iyesu ubupu e tadeyau kabu-kabuwa ragidai emitapu manako tadebu, wagubu ke; “Wi gwabau idiwu ragidai karako mamamaiwogoi, mibai ka Mamanuga God e gari rabineya kaiwana idiwana watai ki ka wi nene. ");
INSERT INTO gdn_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Wi karako wetei idiwu ragidai ki wi mete mamamaiwogoi, mibai ka aita ewa ki ka wi mateiwagi. ");
INSERT INTO gdn_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Nau Kunumau Kawapuwani Apunai nau pokanere ka iyapana wi wainanimoto siyasiya, wi tagarara-nimoto, wi wereyakauranimoto ade wi iyapana berokoi nidini. Ko mu wi bamagau inako kwaetogamu ki ka wi mamamaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Mara ki baiyagisi ki ka wi mibi mamamai taereiwogoi mibai ka wi puyoga kawaya ka kunumau wi nawanaga tondau. Wi giriniyamu pasuniyamu ragidai ki mu bodamuguma ka naiya mena Mamanuga God e bonanai wainapamawa tagamawa ragidai ki inako mete giritamawa pasutamawa. ");
INSERT INTO gdn_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Akae, gwedegwede ropani kawaya wi bamagau uburau ragidai. Wi karako mamamaiwagamu ki ewa kewo-yagisi. ");
INSERT INTO gdn_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Akae, wi karako mateigubu idiwu ragidai. Aita ewa ka wi nuwaboyaiwagi mibi wetei idiwoi. Akae, wi karako gwaita wadamu ragidai. Aita ewa ka wi apena meyoi ade yadi kimoi. ");
INSERT INTO gdn_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Akae, wi gwedewau iyapana wi werega tagamu wi siga esida tepapiyamu ragidai. Naiya takari kawaya ka iyapana inako mete kwaetagamawa. Mu dai beratagamawa tagamawa da ‘nu ka Mamanuga God e bonanai wainapemei iwegemei ragidai’, manako iyapana mu weremaga tagamawa.” ");
INSERT INTO gdn_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Iyesu mu ade tadebu, wagubu ke; “Nau wainasiniyamu ragidai, nau karako wi nidiyani ki wi naigida mena wainapumuri; Wi iyaraguma ki wi ubumuri mu nota kwarikwarisitamuri, ade wi wainaniyamu siyasiya ragidai ki mu bamamugu ka wi denai bagi mena kwaiwagi. ");
INSERT INTO gdn_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Wi simaganiyamu ragidai ki denai ka wi mu waditamuri bagi, ade wi giriniyamu pasuniyamu ragidai ki denai ka wi mu nene Mamanuga God bameya guriguriwagi. ");
INSERT INTO gdn_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Iyapana mosi kau kwanabugeya miniyoto ki kau denai e eba mini ko kamadi da e kau kwanabugi daikere mete miniyoto ka baganai. Ade iyapana mosi kau nusurugi tatamai yadini ki kau e eba bodapi ko kamadi da e kau midigi tatamai mosi mete yadini ka baganai. ");
INSERT INTO gdn_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Iyapana mosi kau gwedegwedegi ki genei yagisi ki kau e kwei, ade iyapana mosi kau gwedegwedegi mo pa wadubu ki kau eba nuwagi kasiwara ade wadi. ");
INSERT INTO gdn_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Kau nuwageya iyapana kau bamageya badidi kwaetagamana wainapiyei ki kau yabiri mu bamamugu inako mete kwaenuwagi. ");
INSERT INTO gdn_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Kau nota kwarikwarisiniyamu ragidai ki mu mena kau denai nota kwarikwarisitamiyowa ki ka Mamanuga God badidi pokere ki pokaiya kau wadiniyoto bagi? Kau kwaenugibi ki ka eba gwede kawaya mosi. Bigi kwae-tagamu ragidai ki mu mete kina inako deni deni nota kwarikwarisi kasiwara-tagamu idiwu. ");
INSERT INTO gdn_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Ade iyapana bagi mena kau bamageya kwaetagamu ragidai ki mu mena bamamugu kau bagi kwaenugowa ki ka Mamanuga God badidi pokere ki pokaiya kau wadini-yoto bagi? Kau kwaenugibi ki ka eba gwede kawaya mosi. Bigi kwaetagamu ragidai ki mu mete kina inako kwae-tagamu. ");
INSERT INTO gdn_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Ade kau gwede mosi iyapana mo kwebi manako kau notapiyei da e uburoto kau suruwagi ki denai wirapana negeyana wainapiyei ki ka Mamanuga God badidi pokere ki denai kau wadiniyoto bagi? Bigi kwaetagamu ragidai ki mu mete kina ka mu mubo kowamuguma bigi kwaetagamu ragidai gwede mosi tageyamu ki mu suruwa-maga ade denai wirapamana tagemana ki wainapiyamu. ");
INSERT INTO gdn_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Wi inako eba kwaiwogoi ko yau mena kwaiwogoi; Wi iyaraguma nota kwarikwarisitamiyoi ade mu bamamugu bagi mena kwaiwogoi. Wi iyapana gwede mo tagemuri ki ka mu denai wi suruwaga wirapamana negemana ki eba wainapiyoi. Wi bagi supasupai mena inako kwaiwogoi yamoi ki ka wi deniga kawaya ki wi aita ewa wadumuri ade wi ka mibai Mamanuga God Iyarau Tondau Apunai e munuiyoma. Wainapumuri; Berokoi kwaetagamu ragidai ade puyo wadamu ko denai parau eba tagamu ragidai ki ka Mamanuga God mu mete waitatamiyau. ");
INSERT INTO gdn_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Ki pokere Mamanuga God wi nuwanuwaniyau ki maba wi kowaguma inako mete nuwanuwa-tamiyoi.” ");
INSERT INTO gdn_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Wi kowaguma emitamuri ki ka wi garugaru mu eba waigubatamuri da Mamanuga God wi mete eba waiguba-niyoto. Ade wi idaga gurai wi kowaguma naurimugu eba ugwaditamuri ragiragi da Mamanuga God e idai gurai wi naurigau mete eba ugwadini ragiragi. Iyapana berokoi wi bamagau badidi kwaetagubu ki wi deni mena notagogapumuri. Wi inako kwaiwagi ki ka berokoi wi badidi kwaigubu ki kuduba ka Mamanuga God mete notagogapoto. ");
INSERT INTO gdn_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Wi kowaguma puyo werenatamiyoi ki ka Mamanuga God wi mete puyo werenaniyoto. E negeni ki ka wi idagau posiyagisi siwagapoto iyapana poka nunumu dompiyamu ade kawareya kawareya nunumu dompiyamu posiwagau siwagapiyau ki maba posiyagisi siwagapoto. Ko wi iyapana gwede maraitau tagemuri ki denai ka Mamanuga God wi maraitau negeni, ade wi iyapana gwede kawaya daganani tagemuri ki ka Mamanuga God denai kawaya daganani wi negeni.” ");
INSERT INTO gdn_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Iyesu inako wagubu manako keyakeyai mo tadebu, wagubu ke; “Iyapana yabui kenekenei apunai mosi ki ka e eba uburoto e waretai yabui kenekenei ki e idaiya yadini yawata kabuwapoto. Pa mena. E inako kwae-yogono ki ka mu apeya ewapuru yawata paerepomoto bobau sumoto. ");
INSERT INTO gdn_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Iyapana gwede mosi kataitagamana wainapiyamu ki ka mu eba ubumoto kabuwamaga apunai ki e raurupomoto. Ko e badidi kabuwatamiyau ki mu kataitagisi kewoyagisi ki ka mu katai-maga ka kabuwamaga apunai ki e katai mete eyaka mena. ");
INSERT INTO gdn_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Kau nima kau waretagi e yabuiya gwede mugu marai munta mo kene-pupu empipi nuwegei ki ka kau badidi pokere naiya kau kiya yabugeya ripa tapai kawaya mo kenepupu ki eba empipi were nuwegei. ");
INSERT INTO gdn_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Kau gwede nana kau waretagi siyei, nuwegei ke; ‘Kabai, kau yabi da nau waitaniyani mugu marai munta kau yabugeya supu ki koritapani.’ Kau gwede nana inako nuwegei ko ripa tapai kawaya kau kiya yabugi kenepupu ki kau eba empipi were nuwagibi? Wi ka midiga pa matakawagau ragidai. Wi yabiri ripa tapai kawaya wi wiga yabuga kenepupu ki koritapumuri da wi tawana naigida empumuri were ewa ka wi kowaguma yabumugu mugu marai munta kene-pupu ki waitatamuri koritapumuri.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Ripa iruirui kawaya ki mibai berokoi eba kiroto ade ripa wayowayoi ki mibai bagi eba kiroto. ");
INSERT INTO gdn_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ripa mibai kirau ki pokaiya ka wi ripa makamaga kataiwagi. Damaya madai ki siporo eba wenapoto ade impunewa ki madai kauma eba wenapoto. ");
INSERT INTO gdn_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ki maba, iyapana bagai ki e nuwai notai ka taniwena ki pokere e bagi mena kwaewagau ko iyapana berokoi ki e nuwai notai ka berokoi mena posiwena uburau ki pokere e berokoi mena kwaewagau. Iyapana nima e nuwai notai nota bagi mena notapiyau ki e umuneya ka yona bagi mena bauwagau, ko iyapana nima e nuwai notai nota berokoi mena notapiyau ki e umuneya ka yona berokoi mena bauwagau.” ");
INSERT INTO gdn_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Iyesu mu ade tadebu, wagubu ke; “Wi badidi pokere kawareya kawareya ‘Kaiwawoni, Kaiwawoni’ sidiyamu ko nau nidiyakani ki wi makeya makeya eba kwaiwagamu? ");
INSERT INTO gdn_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Iyapana nima nau bamaneya baiyagisi manako nau yonani suwagubuwani ki e makeya makeya kwaeyogono ki e iyai badidi maba ki keyakeyai nau karako wi kabuwaniyani wainapumuri; ");
INSERT INTO gdn_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","E ka apunu mosi e tawai bebedai uruba rorowa kawa-kawaya ukwatapu bebeda nunutapu ubumu ki maba. Awana goya bauwena tawa ki kweyana gwairi kwaewagawa ko tawa ki bebedai ragiragi kawaya uburawa ki pokere tawa ki eba gwairi-wena. ");
INSERT INTO gdn_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Ko iyapana nima nau yonani pa wainapoto ko makeya makeya eba kwaeyogono ki ka e apunu mosi e tawai bebedai uruba iyaruiyaru ukwapupu kaupupu ki e maba. Awana goya bauwena tawa ki minibu manako tawa ki bebedai deni mena siwawena gwairi-pupu ki pokere tawa ki rorororowena manako awana kawarapupu kaya-wena.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Iyesu dimawagawa tondawa da kamadubu manako kipu ubupu kayawena umawa da natere Kaponiyamu bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Natere Kaponiyamu rabineya ka apunu kawai mosi tawana Roumi were bauwena ika tondawa. Piyara ragidai mu kawaimaga ka eyo. Apunu ki e bigabigai nuwaiya po apunai mosi sigirawena powagana kwaewagawa. ");
INSERT INTO gdn_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Piyara apunai ki Iyesu sisiyai wainapupu ki pokere e ubupu Diyu ragidai mu kawakawaimuguma dai bibi tonotapu da mu Iyesu siyamana bauwagana manako uburana sigira apunai ki iyapana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Mu kayatagubu Iyesu bameya bautagubu manako mu nuwamaga notamaga eyaka mena e simupu, tagubu ke; “Nu tononibu apunai ka apunu bagi kawaya ki pokere kau nu mete kaigamu manako e bigabigai apunai sigirawena ki kau iyapi. ");
INSERT INTO gdn_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Piyara apunai ki nu Diyu ragidai nu nene ebotau wainapiyau ade nu gurigurinuga tawai ki e nu nene mete wadubu.” ");
INSERT INTO gdn_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Mu Iyesu inako simupu manako bananamupu mete kayatagubu. Mu umunamawa da tawa kikireya bautagamana kwaetagamawa ka piyara apunai ki yona mo ade tonopupu, wagubu ke; “Wi kaiwagi Kaiwawo apunai ki simuri da e nau tawaneya eba umunoto. Nau ka eba gwede mo bagi kwaesugubuwani da e nau bamaneya baiyagisi, ");
INSERT INTO gdn_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ade nau e bameya surana ki mete eba baganai. Ko wi simuri da e wateya mena ika uburoto yagisi ki ka nau bigabigani apunai iyayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Nau mete kina ka iyapana kawakawai dai mu kobamugu. Mu gwede mo tagisi ki nau makeya makeya kwaesugani. Ade iyapana dai nau kobaneya. Nau mu kayatagamana suwagani ki mu kaya-tagisi ade mu kebomana suwagani ki mu kebomoto. Ade nau bigabigani apunai nau bigani mo kwaewagana siyani ki ka e nau bigani ki kwaeyagisi. Ko ki maba wi karako Iyesu simuri da e yona mena yagisi manako e umuneya ka nau bigabigani apunai iyayagisi.” Piyara apunai ki yona inako tonopupu manako iyapana kayatagubu Iyesu bameya bautagubu yona ki makeya makeya e simupu. ");
INSERT INTO gdn_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Iyesu yona ki wainapupu ka e notai wagubu ke; “Akae, apunu ki e sumai ka kawaya.” E inako notapupu manako wirawena iyapana ropani kawaya e eweya umunamawa ki tadebu, wagubu ke; “Nau suwagani wainapumuri; Tawana Isiraero ragidai wi paunagau ka nau iyapana yau e sumai maba mo eba bananapuwani.” ");
INSERT INTO gdn_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Bibi ragidai ki wiratagubu kaya-tagubu piyara apunai e tawaiya ade bautagubu ki ka mu sigira apunai ki iyawena ika tondawa emupu. ");
INSERT INTO gdn_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Eba rowarowa ki eweya ka Iyesu e tadeyau kabukabuwa ragidai ade iyapana ropani kawaya mete kina e bananamupu natere Naini kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Natere Naini kikireya gari umampu teta nakampu ki bameya bautagamawa ka mu natere ki ragidai yaraga mosi powena keroramupu gari tagaiya ononopamana ki nana ika kebomawa emitampu. Powena apunai ki e inai ka koboro, e gubagai eyaka mena ki po-wena. Ko tawa ki ragidai ropani kawaya ridi ki mete bautagubu kebomawa. ");
INSERT INTO gdn_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Nu Kaiwawonuga koboro ki empupu ki ka e nuwaboyai kawaya daganani wainapupu manako sibu, wagubu ke: “Kau yadi eba kirowa.” ");
INSERT INTO gdn_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E inako wagubu manako kanibu e idai gerowo kawareya tapu. Ki makeya ka onodiba ragidai ubumpu doko manako Iyesu ubupu powena apunai ki sibu, wagubu ke; “Munu waunai, nau nidiyani wainapi; Kau kiri uburi.” ");
INSERT INTO gdn_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Iyesu yona ki wagawa makeya ka powena apunai ki ade iyawena kipu ubupu bagi tondubu manako yona daikere wagubu. Ko Iyesu munu ki wadubu e inai kwebu. ");
INSERT INTO gdn_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Iyapana kuduba matakira ki emupu ka mu notamaga kowena kudu mete wainamupu manako Mamanuga God e si tepamupu, tagubu ke; “Kau yonagi wagau apunai kawaya mosi nu paunanugu bauwena. Mamanuga God e iyapanaiyoma nu iyaniyana ki nana ka e karako apunu yau tonopupu nu bamanugu bauwena yau kena.” ");
INSERT INTO gdn_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Mu inako tagamawa manako Iyesu e badidi kwaewena ki sisiyai kawayawena kayawena tawana Diyudiya rabineya ade tawana tawana Diyudiya bameya ki mete kina ka iyapana kuduba e badidi kwaewena sisiyai mu kuduba waina-mupu gawarara. ");
INSERT INTO gdn_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Iyapana siruwatamiyawa apunai Diyoni e kowakowaiyoma e bameya bautagubu manako Iyesu badidi kwae-wagawa umawa ki sisiyai e kabuwa-mupu. ");
INSERT INTO gdn_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","E yona ki wainapupu ka e kowakowaiyoma apeya ki ade tonotapu da mu manu yau nu Kaiwawonuga manupamana, tagamana ke; “Apunu nu nawanai idiwei ki kau baganai bo nu apunu kudubai mosi bauwagana ki e nawanai idiwomu?” ");
INSERT INTO gdn_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Iyapana apeya ki Iyesu bameya bautagubu ka mu e simupu, tagubu ke; “Iyapana siruwatamiyawa apunai Diyoni kau manunimana ki nana nu tononibu baigibi. Nu karako kau manunimei yau kena; ‘Apunu nu nawanai idiwei ki kau baganai bo nu apunu kudubai mosi bauwagana ki e nawanai idiwomu?” ");
INSERT INTO gdn_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Iyapana apeya ki Iyesu bameya bautagubu ki makeya ka Iyesu iyapana sigiramaga ebo ebo iyatamiyawa, keyai berokoi iyapana giritamiyawa ki siwakeketamiyawa, ade iyapana yabu-maga kenekenei ki dai mete iyatamiyawa da mu tawana ade empamawa, ");
INSERT INTO gdn_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ki pokere e denai mu tadebu, wagubu ke; “Wi wiraiwagi kaiwagi manako wi yabugere badidi empiyamu bo waina-piyamu ki kuduba wi apunu Diyoni simuri, iwagi ke; ‘Iyapana yabumaga kenekenei ki tawana ade empiyamu; iyapana kerapumaga badabadamai bo kiyokiyoi ki iyatagubu ka iwu; iyapana kwakwarepumaga kwatakwatawena ki ade iyatagubu; iyapana wenagumaga kenekenei ki yona ade wainapiyamu; popotagubu ragidai ki mu dai ade iyatagubu kimpu ubumpu, ade gwabau idiwu ragidai ki mu ka yona bagi kawaya mete wainapiyamu. ");
INSERT INTO gdn_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Iyapana gwedewau mu midimaga nau bamaneya eba togawagau ragidai ki mu ka mibi mamamai idiwono.’ Wi apunu Diyoni inako simuri.” Iyesu inako tadebu. ");
INSERT INTO gdn_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Apunu Diyoni e tonotapu ragidai ki wiratagubu kayatagubu eweya ka Iyesu iyapana ropani kawaya ika dibimupu idiwa ki apunu Diyoni e nene yona yau tadebu, wagubu ke; “Wi naiya apunu Diyoni bameya iyapana eba idiwu tawaneya kaigubu ki ka wi gwede empamana ki nana kaigubu? Wi gwaba mosi nusuru gipiyau ki empamana ki nana kaigubu bo? ");
INSERT INTO gdn_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Wi gwede empa-mana ki nana kaigubu? Wi apunu mosi e gwedegwedei bagibagi monagawena ki empamana ki nana kaigubu bo? Pa mena, iyapana gwedegwede bagibagi umamu ragidai ki mu ka upi eba kwaetagamu ko mu ka kawakawai ragidai mu tawamaga bagi ki rabineya pa idiwu. ");
INSERT INTO gdn_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Ko karako nau sidimuri; Wi mibai gwede empamana ki nana kaigubu? Wi Mamanuga God e bonanai wainapiyawa wagawa apunai mosi ki e empamana ki nana kaigubu bo? Ena, wi ki nene kaigubu. Ko nau nidiyani wainapumuri; Apunu Diyoni e ka eba Mamanuga God e bonanai wainapiyawa wagawa apunai ki mena ko e ka ade kawaya esida, ");
INSERT INTO gdn_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","mibai ka Mamanuga God e okai e nene inako wagubu ke; ‘Nau yonani wagana apunai ka nau bibi yabiri tonopani da e kau yawatagi meyoto.’ ");
INSERT INTO gdn_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Oka ki inako wagubu ko nau ade nidiyani wainapumuri; Iyapana kuduba emitamiyamu mu paunamugu ka apunu Diyoni e mena ka kawaya esida. Ko aita ewa Mamanuga God e gari rabineya idiwana ki marai baiyagisi makeya ka iyapana nima munu marai munta maba tondau ki e ka ade apunu Diyoni raurupoto esida.” ");
INSERT INTO gdn_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Iyapana pakasi ragidai kuduba ade takesi wadamu ragidai mete kina Iyesu e yonai ki wainamupu ka mu tagubu ke; “Ki mibai, Mamanuga God e yawatai kabuwaniyau ki ka supasupai kawaya.” Mu inako tagubu ki mibai ka apunu Diyoni ororeya mena mu siruwatapu. ");
INSERT INTO gdn_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Ko Parisi ragidai ade Mamanuga God e gorai kataimugu ragidai ki mu notamaga ka eba wirawena ade Mamanuga God mu nene kwaewena ki mu tagararamupu ki pokere apunu Diyoni mu eba siruwatapu. ");
INSERT INTO gdn_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Ko Iyesu iyapana ika idiwa ki ade tadebu, wagubu ke; “Wi karako idiwu ragidai wi iyaga badidi maba ki keya-keyai nau badidi maba suwagani? ");
INSERT INTO gdn_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Wi ka munu rasi imatau yanuwatagamu ki mu maba. Mu ka mu mubo deni deni tagamu kasiwara, tagamu ke; ‘Wi taereigamana ki nana nu kainaga minimei ko wi eba taereiwagamu.’ Bo ade tagamu ke; ‘Nu nuwaboya umayoi iwegemei ko wi yadi eba kimu.’ ");
INSERT INTO gdn_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Nau keyakeyai ki suwagubuwani ki mibai ka yau kena; Iyapana siruwatamiyawa apunai Diyoni bauwena ki ka e Mama-nuga God nene bani kamadubu ade awana ‘waeni’ mo e mete eba kubabu. Ko wi e kwaewena ki emupu ki ka wi e simpu siyasiya, iwagubu ke; ‘Kweya kairapu mosi e rabineya tondau.’ ");
INSERT INTO gdn_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Ade nau Kunumau Kawapuwani Apunai bausugubuwani ki ka nau bani yo awana kubabuwani manako wi nau sidimupu, iwagubu ke; ‘Empumuri, e ka kupekupei ade awana kawaya daganani kubarau e yabarai babawagau. E takesi wadamu ragidai ade iyapana bigibigi nu tagarara-tamemei ragidai ki mu waretamaga.’ ");
INSERT INTO gdn_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Wi inako iwagamu ko iyapana gwede-wau Mamanuga God e yonai suma-pomoto ki mu kataitagisi da Mamanuga God e notai ka mibai supasupai bagi kawaya esida.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Parisi apunai mosi Iyesu nene bibi tonopupu da e bauwagana e tawaiya mete kupetagamana ki nana wagubu ki pokere Iyesu ika bauwena tawa rabineya kanibu tondubu manako mete kupetaga-mana kwaetagamawa. ");
INSERT INTO gdn_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Natere ki rabineya ka ridi mosi bigi mena kwae-wagawa ridai ki ika mete tondawa. Iyesu bauwena Parisi apunai ki e tawaiya kupewagawa tondawa ki sisiyai ridi ki wainapupu manako e karakara mosi ki mu bowa pokaiya yamanamupu ki rabineya e ripa otai aurai bagi kawaya mo minibu ki e wadubu Iyesu bameya kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","E Iyesu tagere bauwena e kerareya ubupu manako yadi kipu. E yadi kirawa ki yabui iwai supu Iyesu kerarai pasipupu manako ridi ki kwarisi-wena tondubu e yabui iwai Iyesu kerareya ki e debai kumai rowarowa kawaya pokaiya surupupu. Surupupu kewowena ka e Iyesu kerarai kiyauyau-pupu manako ewa ripa otai aurai bagi kawaya ki wadubu e kerarai kawareya kwebu wira. ");
INSERT INTO gdn_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Parisi apunai ki ridi ki badidi kwaewena empupu ka e notai wagubu ke; “Apunu yau Mamanuga God e bonanai mibai wainapibena waguibena ki ka e ridi yau karako e midi geyapiyau ki e iyai berokoi mete kataiwagubena, mibai ka ridi yau ka bigibigi.” E notai inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Ko Iyesu apunu ki empupu manako sibu, wagubu ke; “Saimoni, nau yona mo kau nidiyana wainapakani.” E inako wagubu ka apunu Saimoni denai wagubu ke; “Sidiyei Kabukabuwa Apunai, kau badidi wainapiyei ki kau sidi.” ");
INSERT INTO gdn_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Ko Iyesu keyakeyai mo e sibu, wagubu ke; “Iyapana apeya mu ka apunu kawai mosi e bameya bowa madai dai sikwatagubu. Mosi ka bowa madai kawaya daganani (500) sikwa-wena ko mosi ka bowa madai maraitau (50) ki mena sikwawena. ");
INSERT INTO gdn_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Iyapana apeya bowa madai sikwatagubu ki denai wirapamana marai bauwena ki ka mu bowa madai pa mena ki pokere apunu kawai ki mu nuwaboyamaga wainapupu manako mu sikwamaga ki kuduba e deni mena surupupu. Ko nau karako kau manuniyani; Mu apeya ki mu paunamugu ka nima mamama kawaya mu kawaimaga ki e bameya wainapupu?” ");
INSERT INTO gdn_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Iyesu inako wagubu manako apunu Saimoni denai wagubu ke; “Nau wainapakani da bowa madai kawaya daganani sikwawena apunai e sikwai surupupu ki kena.” “Ena, kau yona mibai nuwagibi.” ");
INSERT INTO gdn_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Iyesu inako wagubu manako wira-wena ridi ki empupu manako apunu Saimoni ade sibu, wagubu ke; “Kau ridi yau empiyei? Nau kau tawageya bausugubuwani ki kau nau kerarani siruwapana awanai mo eba tegebi. Ko ridi yau ka e eya yabui iwai pokaiya nau kerarani siruwapupu manako ewa e debai kumai pokaiya nau kerarani surupupu. ");
INSERT INTO gdn_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Nau tawageya bausugu-buwani ki kau diriwani eba kwaenugibi nau eba kiyauyausinibi. Ko ridi yau ka nau tawageya bausugubuwani ki makeya ka e nau kerarani mena kiyauyaupiyawa tondawa da karako yau kena. ");
INSERT INTO gdn_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Kau awana monamonai nau debaneya eba kwebi wira ko ridi yau e ka ripa otai aurai bagi kawaya nau kerapuni kawareya kwebu wira. ");
INSERT INTO gdn_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Nau nidiyani wainapi; Ridi yau e paere ropani kawaya kwaewena ki kuduba nau karako deni mena surupuwani kewowena ki pokere e kawaya daganani nau nota kwarikwarisi-siniyau. Ko iyapana nima paere marai munta kwaewena manako nau uburani paere marai munta ki surupani ki denai ka iyapana ki uburoto maraitau mena nau nota kwarikwarisisiniyono. ");
INSERT INTO gdn_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Iyesu inako wagubu manako wirawena ridi ki empupu sibu, wagubu ke; “Kau bigi badidi kwaenugibi ki kuduba nau deni mena surupakani kau tagageya kwenupakani.” ");
INSERT INTO gdn_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Iyapana ika bani kupamawa idiwa Iyesu yonai ki wainamupu ka mu mubo mubo umana misimisitagawa, tagamawa ke; “Apunu yau ka nima? E wagubu da e bigi deni mena surupana kwenupana ki nana wagau.” ");
INSERT INTO gdn_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Mu inako tagubu ko Iyesu ridi ki ade sibu, wagubu ke; “Kau sumagi pokaiya ka kau iya bananapipi ki pokere naigida mena nuwabagi rabineya kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Mara dai kewowena eweya ka Iyesu tawana tawana natere natere kayawena Mamanuga God e gari rabineya e kasiyarai pokaiya badidi maba idiwana ki yonai bagi kawaya dimawagawa umawa. E tadeyau kabukabuwa ragidai ida esida kewo-wena kerapu apeya, ");
INSERT INTO gdn_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ade naiya sigira ebo ebo wadumupu keyai berokoi mu rabinamugu idiwa ko Iyesu mu iyatapu ridi dai ki mu mete kina e mete kaya-tagubu. Ridi ki mu simaga ka yau kena; Mosi ka Meri si daikere Magidarini tagubu (naiya ka keyai berokoi kuduba ida daikere kewowena daikere apeya (7) e rabineya idiwa ko Iyesu berokoi ki kuduba siwakeketapu gawarara), ");
INSERT INTO gdn_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","mosi ka Diyona (e nobomoi ka kaiwawo Erodi e piyaraiyoma mu kawaimaga mosi si ka Kusa), ade mosi ka Susana. Ridi ki kena ade ridi ropani kawaya dai mete kina karako Iyesu ade e tadeyau kabukabuwa ragidai mete kayatagubu mu waitatamawa iwa. ");
INSERT INTO gdn_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Iyapana tawana tawana bautagubu Iyesu empamana ade e yonai waina-pamana ki nana e kwagaramupu idiwa manako e mu paunamugu ubupu waigugu were tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Apunu mosi ka momai dai urana kayawena. E momai ki urawa umawa ka momai dai kerapu dabireya gwegwe-tagubu manako midiwari garugaru mena bautagubu momai ki kupampu gawarara. ");
INSERT INTO gdn_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Momai dai ka e yaroyaro kawareya upu. Momai ki ugwadubu susukwana ko garugaru mena sura-tagubu mibai ka witai waira rabineya eba supu ade waira ki awana pa mena. ");
INSERT INTO gdn_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ade momai dai ka gwabau gaya kakapareya gwegwetagubu wenatagubu ko gwaba niniuraurapupu ki pokere wenatagubu ko mibai eba kipu. ");
INSERT INTO gdn_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ko momai dai ka e waira bageya upu manako ugwede susukwanapupu wenatagubu kawakawayatagubu momai eyaka eyaka mibai apunai ida daikere mena (100) kipu.” Iyesu inako wagubu ade wagubu ke; “Wi wenaguga mete kina ki ka wi nau waigugu suwagubuwani yau mibai naigida mena wainapumuri wetawetara.” ");
INSERT INTO gdn_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ki eweya ka e tadeyau kabukabuwa ragidai e manumupu, tagubu ke; “Kau waigugu nuwagibi ki mibai ka badidi?” ");
INSERT INTO gdn_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Ko e denai tadebu, wagubu ke; “Mamanuga God e gari rabineya idiwana ki yonai wekewekei ki mibai kuduba ka nau matarau wi nidiyakani ko iyapana dai ki nau waigugu mena pokaiya mu tadeyakani da mu yabu tamono ko mibai eba empomoto ade wainapomono ko mibai eba kataitagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Iyesu inako wagubu, ade tadebu, wagubu ke; “Waigugu suwagubuwani ki mibai ka yau kena; Momai upu ki ka Mamanuga God e eya yonai. ");
INSERT INTO gdn_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Momai ki kerapu dabireya gwegwetagubu ki mibai ka yau kena; Iyapana dai mu ka Mamanuga God e yonai wainapomoto ko Berokoi Apunai Seitani garugaru mena baiyagisi mu notamaga yadini gogapoto manako yona ki surupoto da mu yona ki eba sumapomoto ade iya waunai mete eba yadini. ");
INSERT INTO gdn_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Momai yaroyaro kawareya gwegwetagubu ki mibai ka yau kena; Iyapana dai mu ka Mamanuga God e yonai wainapomoto mamamatagisi ko yona ki mibai mu rabinamugu eba supu tawawena ki pokere gwede mo mu sumamaga nukepana empana ki nana baiyagisi ki ka mu Mamanuga God e yonai ki garugaru mena notagogapomoto. ");
INSERT INTO gdn_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ade momai gwabau gaya kakapareya gwegwetagubu ki mibai ka yau kena; Iyapana dai mu ka Mamanuga God e yonai wainapomoto ko mu waira yau gwedegwedei empomono yabumaga midiyayogono ade mu mubo gwede-gwedemaga kawayawagana ki nana mete wainapomono ki pokere Mama-nuga God e yonai wainamupu ki mu notamaga ki utapoto manako mu mibimaga mo eba kiroto raiyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ko iyapana dai mu ka e momai waira bageya upu ki maba. Mu ka Mamanuga God e yonai wainapomoto sumapomoto mu rabinamugu yadini doko manako kasiyarai kawaya ubumono da mu mibimaga bagi kawaya kirono.” ");
INSERT INTO gdn_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Iyesu ade tadebu, wagubu ke; “Iyapana mosi duna beupoto ki ka e duna ki bani taroto? E digumau taroto bo kurari umuneya wekepoto bo? Ae, pa mena, e duna matarau taroto manako iyapana e bameya baitagisi ki ka duna tanai tawa miniyau siwa ki mu empomoto. ");
INSERT INTO gdn_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Wi gwedegwede kuduba weki gwaiya kwaiwagamu ki ka ewa marai mosi matarayagisi. Ade wi gwedegwede kuduba utapiyamu ki utai ka ewa marai mosi wakayagisi matarayagisi taneya tondono. ");
INSERT INTO gdn_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ki pokere wi yona badidi maba wainapumuri ki wi naigida mena notapumuri wainapumuri. Iyapana nima yona mibai wainapupu wadubu doko ki ka e yona waunai mosi ade wainapoto yadini. Ko iyapana nima yona ki eba wainapupu wadubu doko ki ka e ewa mo eba yadini ade marai munta wadubu ki mete gogayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Iyesu e eya inai ade e eya yowai-yoma mete kina e bameya bautagubu ko iyapana ropani kawaya e kwagara-pamawa idiwa ki pokere mu e bameya bautagamana mete yonatagamana ki ka ragiragi kawaya. ");
INSERT INTO gdn_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Iyapana mosi bauwena Iyesu sibu, wagubu ke; “Kau inagi ade kau yowagiyoma mete kina bautagubu tawa ureya ubumu kau nene tagamu.” ");
INSERT INTO gdn_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Ko Iyesu denai wagubu ke; “Iyapana gwedewau nau Mamai God e badidi wagau ki wainapiyamu makeya makeya kwaetagamu ragidai ki mu mena ka mibai nau yowaniyoma ade nau inaniyoma.” ");
INSERT INTO gdn_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Mara mosi ka Iyesu e tadeyau kabukabuwa ragidai mete kina waka mo kawareya yamupu manako e ubupu mu tadebu, wagubu ke; “Waka yau kawareya kaburu papasi daikere kaigomu.” E inako wagubu manako kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Mu kayatagubu kaiwa ka Iyesu e yabui towena ki pokere e kwarisiwena ukwarawa. Garugaru mena ka nusuru kawaya mo bauwena towawa wirawena yabadubu waka rabineya posiwena manako waka waunitau kaburu surana kwaewagawa. ");
INSERT INTO gdn_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Iyesu e tadeyau kabu-kabuwa ragidai kaimpu e wadumpu yabuyabu simupu, tagubu ke; “Kaiwawonuga, Kaiwawonuga, nu popoigamana kwaigemei.” Iyesu yabuwena kipu ubupu ragiragi kawaya nusuru towawa tadebu manako ki makeya ka nusuru pamenawena ade towawa bigawena manako kaburu kwarisiwena ukwapu. ");
INSERT INTO gdn_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Ko Iyesu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Wi sumaga ka bani?” E inako wagubu ko mu notamaga kowena kudu mete wainapamawa mu mubo mubo tagamawa kasiwara, tagamawa ke; “Apunu yau ka nima? E bonanai ragiragi kawaya wagubu manako nusuru yo towawa e bonanai wadumupu.” ");
INSERT INTO gdn_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Iyesu e tadeyau kabukabuwa ragidai mete kina tawana Gariri kamadumpu waka kawareya kaya-tagubu kaiwa da papasi daikere Gerasini ragidai mu tawanamugu bautagubu. ");
INSERT INTO gdn_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Iyesu waka kamadubu kanibu wairau surawa ki makeya ka apunu mosi bauwena e ika bananapupu. Apunu ki ka natere ki mu apunumaga mosi ko kweya kairapu dai e rabineya idiwa. E ebo tawaiya eba tondawa ko mara ropani kawaya ka e iyapana popai kwakwarepumaga ragu rabineya naka-pamawa ki mu watamugu ukwarawa. E sipuma eba umarawa ko ni matarau umawa. ");
INSERT INTO gdn_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","E Iyesu empupu ki ka e kwewena Iyesu yabareya gwairiwena ukwapu manako e bonanai ragiragi kawaya wagubu ke; “Iyesu, Kawainuga God Kunumau Tondau e Gubagai ka kau. Kau gwede berapana ki nana nau bamaneya baunugibi? Nau nidiyani; Kau eba girisini.” ");
INSERT INTO gdn_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","E yona ki wagubu ki mibai ka Iyesu ororeya mena kweya kairapu e rabineya tondawa ki siwakekepupu. Naiya, mara ropani kawaya ka keyai berokoi ki apunu ki wadubu doko kasiyara kweyawa. E bigawagana ki nana ka iyapana kawareya kawareya e idai kerarai taburuba pokaiya umamawa dokodoko, ko e kwikwi gengemu-wagawa taburuba ki purupurutagamawa manako kweya kairapu ki e yabiripiyawa da e iyapana eba idiwu tawaneya ki kayawagawa umawa. ");
INSERT INTO gdn_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Ko Iyesu apunu ki empupu manako kweya kairapu e rabineya tondawa ki manupupu, wagubu ke; “Kau sigi ka badidi?” “Nau sini ka Damu Kawaya.” E inako wagubu ki mibai ka kweya kairapu ropani kawaya apunu ki e rabineya idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Kweya kairapu ki kawareya kawareya nuwasiyasiya nene Iyesu siyamawa, tagamawa ke; “Bita wadamana tawaneya waira kobaiya ki kau eba tononiyo.” ");
INSERT INTO gdn_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Karako ka kweya madanai daikere eba uwama ka papa boyo ropani kawaya eba bigabigai buri sipuratagamawa idiwa. Kweya kairapu papa boyo ki emitampu ka mu Iyesu kawareya kawareya siyamawa, tagamawa ke; “Kau nuwagi manako nu kaigamu bo buri rabinamugu teteigamu idiwomu.” “Ki baganai, kaiwagi.” Iyesu inako wagubu, ");
INSERT INTO gdn_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","manako kweya kairapu ki kuduba apunu ki kamadumpu matarau bautagubu kayatagubu manako bo ki rabinamugu tetetagubu. Ki makeya ka bo ki kuduba mu yabaramaga babawena kweya ki erida mena garugarumupu kaburu sikisikimupu manako nonamaga kubabu popotagubu gawarara. ");
INSERT INTO gdn_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Bo baikamutagamawa ragidai ika idiwa gwede wenawena ki kuduba emupu ka mu wakapatagubu kaya-tagubu tawa tawa iyapana tademawa iwa, ");
INSERT INTO gdn_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","manako iyapana ki waratampu kayatagubu Iyesu bameya mu mubo yabumugere empamana ki nana bau-tagubu. Bautagubu ka mu apunu ki naiya kweya kairapu e rabineya idiwa ko karako kamadumpu kayatagubu ki e yabarai supasupawena monagawena ika Iyesu kerareya bagi kawaya tondawa emupu. Mu matakira ki emupu ka mu notamaga kowena kudu mete waina-pamawa. ");
INSERT INTO gdn_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ko bo baikamutagamawa ragidai ubumpu mu mubo yabumugere apunu ki badidi maba iyawena emupu ki sisiyai kuduba mu kowamuguma kabuwatampu. ");
INSERT INTO gdn_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Tawana Gerasini ragidai kuduba yona ki wainamupu ka mu kudu ebotau wainamupu didigura-maga mete wagubu manako mu Iyesu baiyonomupu ki pokere e waka rabineya ade yapu posiwena kamaditapu kaya-wena. ");
INSERT INTO gdn_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Iyawena apunai ki Iyesu mete kayatagamana ki nana wagubu ko Iyesu e munapupu sibu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ae, ki pa mena. Kau wiranuwagi kau tawageya kayanuwagi manako Mamanuga God kau nene bagi kawaya badidi kwaewena ki sisiyai kuduba kau kowagiyoma tade.” Iyesu inako wagubu manako apunu ki kayawena natere ki rabineya e bameya Iyesu badidi kwaewena ki sisiyai kuduba iyapana tadeyawa umawa. ");
INSERT INTO gdn_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Iyesu waka kawareya ade wira-wena kayawena kaburu papasi daikere bauwena ka iyapana kuduba e nawanai ika idiwa ki e paraupamawa ade e diriwai kwaetagamawa. ");
INSERT INTO gdn_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","42","Ki makeya ka Diyu ragidai gurigurimaga tawai ki debai apunai mosi ika bauwena Iyesu yabareya kwarisiwena e ramatai kawareya ubupu. Apunu ki e petei eyaka mena ki e kwamurai ka ida esida kewowena kerapu apeya (12) ki e sigirawena powagana kwaewagawa ki pokere apunu ki Iyesu gigipiyawa da e tawaiya e mete kayatagamana ki nana wagubu. Iyesu mete kayatagubu ko iyapana ropani kawaya e kwagaramupu paupuna-mpu mete kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Iyapana ropani kawaya ki mu paunamugu ka ridi mosi ika kaniyawa ki kwamura ida esida kewowena kerapu apeya (12) rabineya sigira mena tondawa ko e kobaiya dara maramara bauwagawa. Iyapana e iyapamana kwaetagamawa ko e eba iyawena. ");
INSERT INTO gdn_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Ridi ki iyapana paunamugu Iyesu tagere ika kaniyawa manako e giyansu mena kanibu Iyesu midi tatamai ki madanai mena geyapupu manako ki makeya ka e kobaiya bau-wagawa ki deni mena kewowena. ");
INSERT INTO gdn_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Ko Iyesu wirawena iyapana manutapu, wagubu ke; “Ki nima nau geyasinibu?” Iyapana kuduba tagubu bodaboda ki pokere apunu Pita kanibu Iyesu sibu, wagubu ke; “Kaiwawoni kau emani, iyapana ropani kawaya karako kau kwagaranimpu ki geyaniyamu.” ");
INSERT INTO gdn_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Ko Iyesu wagubu ke; “Kasiyara mo nau rabinaneya bauwena kayawena ki nau wainapuwani ki pokere nau kataineya da iyapana mosi nau geyasinibu.” ");
INSERT INTO gdn_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Ridi ki wainapupu da e kwaewena ki wekepana yawatai pa mena ki pokere e kudu mibi didigurai bauwena Iyesu kerareya kwarisiwena e ramatai kawareya ubupu manako iyapana kuduba yabaramugu ka e gwede nana Iyesu geyapupu ade e badidi maba garugaru mena iyawena ki sisiyai kuduba e wagubu matara. ");
INSERT INTO gdn_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Ko Iyesu ridi ki empupu manako denai sibu, wagubu ke; “Peteni, kau sumagi ki pokaiya kau iyanugibi. Kau sigiragi wana kewowena ki pokere nuwabagi rabineya kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Iyesu yona ki wagawa makeya ka iyapana mosi apunu Yairusi e tawai deneya bauwena apunu Yairusi sibu, wagubu ke; “Kau petegi powena. Nu Nidiyau Kabukabuwa Apunai yau wauneya bauwagubena ki ka baganai ko kau petegi karako powena ki pokere siyo da e wirayagisi kayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Iyesu yona ki e wenagui mena wainapupu kamadubu manako apunu Yairusi sibu, wagubu ke; “Kau notagi eba koyogono ko nau mena sumasiniyowa ki kau petegi ade iyayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Mu tawau bautagubu ka Iyesu iyapana kuduba munatapu manako apunu Pita yo Diyoni yo Diyemesi ade munu ridai ki e inai mamai mete kina ki mu mena waratapu tawa rabineya yamupu. ");
INSERT INTO gdn_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Iyapana kuduba ika idiwa munu ki powena ki yadi wadamawa apenai meyamawa ki pokere Iyesu mu tadebu, wagubu ke; “Wi gwede apenai meyamu? Munu ridai ki eba powena ko e pa ukwarau.” ");
INSERT INTO gdn_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","E inako wagubu ko mu kataimugu da munu ki mibai powena ki pokere mu e gwaigwitapamawa. ");
INSERT INTO gdn_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ko Iyesu kanibu munu popai ki idaiya wadubu manako sibu, wagubu ke; “Peteni, nau nidiyani wainapi; Kau kiri uburi.” ");
INSERT INTO gdn_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Ki makeya ka munu ridai ki e keyai ade bauwena e rabineya yapu ugwadubu iyaiya manako e garugaru mena kipu ubupu. Ko Iyesu mu tadebu, wagubu ke; “Wi bani dai kwemuri kupoto.” ");
INSERT INTO gdn_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Munu ridai ki e inai mamai mu notamaga kowena kodabamaga kamupu ko Iyesu mu tatamatapu da mu petemaga badidi maba iyawena ki sisiyai mu iyapana eba tademana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","2","Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya mu nene wagubu bautagubu manako e kasiyara tagebu da mu kayatagamana kweya kairapu ebo ebo siwakeketamana ade iyapana sigira-tagubu ragidai mete iyatamana ki nana. E kasiyara inako tagebu manako Mamanuga God e gari rabineya idiwana ki yonai iyapana tademana ki nana mu tonotapu, ");
INSERT INTO gdn_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","tadebu, wagubu ke; “Yawata gwedegwedei, guna, igwa, masura, bowa madai, ade gwedegwede raragai inako ki kuduba wi kamadumuri pa ida kasikasi kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Wi tawa mo baiwagi manako iyapana mo wi nene kwaewagau ki ka wi e bameya ukwapu-muri idiwoi da wi natere ki kamadu-muri makeya, ko wi tawa yabayababa mo eba ukwapumuri. ");
INSERT INTO gdn_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ko wi natere mo baiwagi manako iyapana wi nene eba kwaetogomono ki ka mu beramaga berokoi matarapamana ki nana ka wi waigugu yau mena kwaiwagi; Wi kerapuga dogiyai mu tawamaga katamuruiya mena pasipumuri. Mu waigugu ki empomoto ki mu kataitagisi da mu paeremupu.” ");
INSERT INTO gdn_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Iyesu inako tadebu manako mu kayatagubu kaiwa tawana tawana tawa tawa Mamanuga God e yonai bagi kawaya iyapana tademawa ade sigira ragidai mete iyatamawa iwa. ");
INSERT INTO gdn_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Tawana Gariri ragidai mu kawai-maga Erodi gwedegwede yau kuduba wenawena ki sisiyai wainapupu ka e notai babawena. Iyapana dai tagubu da iyapana siruwatamiyawa apunai Diyoni naiya powena ki ade iyawena kipu ubupu, ");
INSERT INTO gdn_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","dai tagubu da oragai apunai Eraidiya ade wirawena bauwena, ade dai tagubu da Mamanuga God e bonanai wainapiyawa wagawa apunai mosi ki naiya takari kawaya tondawa ko powena ki ade iyawena kipu ubupu bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Apunu Erodi iyapana yonamaga ki wainapupu ka e notai babawena, wagubu ke; “Nau apunu Diyoni e gobai meyamana puru ki yonai suwagubuwani ko apunu karako bauwena matakira ebo ebo kwaewagau wainapakani ki e ka nima?” Apunu Erodi e notai inako wagubu manako e Iyesu empana ki nana ki yawatai kwaenepiyawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Iyesu e tadeyau kabukabuwa ragidai ade wiratagubu bautagubu manako mu badidi kwaetagamawa ki sisiyai mu makeya makeya Iyesu simupu. Simpu kewowena ka e mu waratapu iyapana kamaditampu manako mu mubo mena kayatagubu natere mo si ka Besaida bautagubu. ");
INSERT INTO gdn_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Ko mu tawana bani deneya kaya-tagamawa ki iyapana ropani kawaya mu emitampu manako ewakumatampu kayatagubu mu bamamugu ade bau-tagubu. Iyesu iyapana nuwaboyamaga wainapupu ki pokere e mu diriwamaga kwaewena Mamanuga God e gari rabineya idiwana ki yonai mu tadeyawa ade sigira ragidai mete iyatamiyawa. ");
INSERT INTO gdn_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Madega kanibu kekerawagawa ka Iyesu tadeyau kabukabuwa ragidai e bameya bautagubu manako simupu, tagubu ke; “Madega surana kwaewagau ko tawana yau ka tawa pa mena ki pokere iyapana ropani kawaya yau tonotami da mu tawa tawa kayatagisi ukwapamana watai kwaenepomoto ade bani kupamana ki mete kwaenetagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Mu inako tagubu ko Iyesu mu emitapu manako denai tadebu, wagubu ke; “Ae, ki inako pa mena. Wi wiga baniga dai tagemuri da mu kupomoto.” Ko mu denai e simupu, tagubu ke; “Akae, nu bani buredi ida daikere mena ade iyana apeya ki mena nu nuga masuranuga temipi, ko iyapana yau ka ropani kawaya eba bigabigai. Nu kaigamana mu banimaga gimarapamana ki nene nuwegei bo?” ");
INSERT INTO gdn_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","(Iyapana ika damumupu idiwa ka ropani kawaya, uratanai mena ka kuduba 5,000.) Ko Iyesu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Wi kaiwagi iyapana tademuri da damu mo rabineya ka iyapana 50 idiwoto ade mosi rabineya ka 50 idiwoto, mu inako idiwoto kaya-tagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","E tadeyau kabukabuwa ragidai kaimpu iyapana makeya makeya inako nakatampu kewowena, ");
INSERT INTO gdn_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ka Iyesu bani buredi ida daikere mena ade iyana apeya ki mete tepupu pairawena esida kunumau yabu tapu Mamanuga God bameya parauwena manako bani ki gerepupu e tadeyau kabukabuwa ragidai tagebu da mu bani ki iyapana tagemana ki nana wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Iyapana kuduba bani ki kupampu matetagubu manako ki eweya ka Iyesu kowakowai-yoma bani pirai kwanamupu kode rabineya nunumupu manako kode ida esida kewowena kerapu apeya posi-tagubu. ");
INSERT INTO gdn_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Mara mosi ka Iyesu e eya mena guriguriwagawa tondawa manako e tadeyau kabukabuwa ragidai e bameya bautagubu. Ko Iyesu mu manutapu, wagubu ke; “Sidimuri; Iyapana tawana tawana idiwu ki mu nau nene badidi tagamu? Mu wainapiyamu da nau ka nima?” ");
INSERT INTO gdn_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Ko mu denai e simupu, tagubu ke; “Mu dai wainapiyamu da kau ka iyapana siruwatamiyawa apunai Diyoni. Ade dai tagamu da kau ka oragai apunai Eraidiya ade wiranugibi baunugibi. Ade dai tagamu da kau ka takari kawaya Mamanuga God e bonanai wainapiyeya nuwegeya ko ponugibi manako ade iyanugibi kipi ubupi ki apunai.” ");
INSERT INTO gdn_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Mu denai inako tagubu manako Iyesu mu ade manutapu, wagubu ke; “Ko wiyo, wi wainapiyamu da nau ka nima?” E yona ki wagubu ka apunu Pita denai e sibu, wagubu ke; “Kau ka nu Iya Negeyana Apunai Keriso, Mamanuga God e nene.” ");
INSERT INTO gdn_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Apunu Pita inako wagubu, ko Iyesu mu umunumaga umapu da mu yona ki iyapana mo eba siyamana ki nana, ");
INSERT INTO gdn_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","manako ade tadebu, wagubu ke; “Nau Kunumau Kawapuwani Apunai aita ewa midi makari kawaya mo bananapani. Iyapana kawakawai, Mamanuga God bameya dobopiyamu ragidai, ade Mamanuga God e gorai ki kataimugu ragidai mete kina ki mu kuduba ka nau tagararasinimoto manako ubumoto nau wadisinimoto susinimoto poyo. Nau posugani ko mara apeya eyaka kewoyagisi eweya ka nau ade iyasugani kirani uburani.” ");
INSERT INTO gdn_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","E inako wagubu manako mu kuduba ade tadebu, wagubu ke; “Iyapana nima nuwaiya nau ewaneya kayawagana wainapiyau ki ka gwedegwede kuduba e eya iyai nene wainapiyau ki kuduba e kamadini manako nau ripa korosi kawareya makarisugani ki maba e mete bita makari nau pokanere maramara bananapana ki kudeya e eba wainapono ko kasiyarai kawaya e eya korosi maba kawarapoto yabadini nau ewaneya uburoto. ");
INSERT INTO gdn_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Iyapana nima e eya iyai karako yewe wairau ki nene wainapiyau ki ka e eya iyai ewa nene ki e kaupiyau. Ko iyapana nima nau pokanere e eya iyai karako nene kaupiyau ki ka aita ewa ka iya mibai bananapoto yadini. ");
INSERT INTO gdn_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Iyapana nima waira yau gwede-gwedei kuduba tepiyau ko e eya iyai ewa nene ki e kaupiyau manako e poyagisi ki ka e aita ewa gwede yadini? ");
INSERT INTO gdn_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Iyapana nima nau pokanere bo nau yonani suwagubuwani ki pokaiya midimamayagisi ki ka aita ewa nau Kunumau Kawapuwani Apunai nau Mamai ade e aneyaiyoma bagi kawaya mete kina mu tanimaga pokaiya ade wirasugani bausugani makeya ki nau uburani iyapana ki mete midimamapani. ");
INSERT INTO gdn_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Nau yona yau mibai wi nidiyakani; Wi karko idiwu ragidai Mamanuga God e kasiyarai matarayagisi wi yabugere empumuri were ewa ka wi dai popoiwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Iyesu yona ki wagubu makeya pura eyaka mena kwaitana kewowena eweya ka e apunu Pita yo Diyoni yo Diyemesi waratapu mu mubo mena guriguritagamana ki nana kweya mo yamupu. ");
INSERT INTO gdn_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Iyesu guriguriwagawa makeya ka e kiyabui wirawena ebo wenawena ade e midi tatamai poe kawaya ki mete wirawena taniwena sinini tawana kuduba minibu siwa. ");
INSERT INTO gdn_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Garugaru mena ka iyapana apeya ika mataratagubu Iyesu mete yonatagamawa ubumawa. Mosi ka oragai apunai Mosisi ade mosi ka oragai apunai Eraidiya. ");
INSERT INTO gdn_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kunuma tanai bagi kawaya kawapu mu kawarimugu minibu siwa manako Mamanuga God e ebo nuwaiya winepupu tapu ki makeya Iyesu natere Diyerusa-remu rabineya bita bananapana powagana ki sisiyai mu e mete tagamawa ubumawa. ");
INSERT INTO gdn_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Apunu Pita e kowaiyoma mete kina ukwapamawa ki yabutagubu ki ka mu Iyesu kiyabui tanai kawaya ki emupu ade iyapana apeya e mete yonatagamawa ubumawa ki mu mete emitampu. ");
INSERT INTO gdn_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Iyapana apeya ki Iyesu kamadamana kwaetagamawa ka apunu Pita ubupu Iyesu sibu, wagubu ke; “Kaiwawoni, nu yewe wi mete idiwei ka bagi kawaya. Karako ka nu nabonabo apeya eyaka yewe waditamamu, mosi ka kau nene, mosi ka oragai apunai Mosisi e nene, ade mosi ka oragai apunai Eraidiya e nene. (Apunu Pita yona ki wagawa ka e notai babawena wagawa.) ");
INSERT INTO gdn_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","E yona ki wagawa makeya ka oroguma kawapu mu ruputapu ki pokere mu notamaga kowena kudu mete wainapamawa. ");
INSERT INTO gdn_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Ko bonana mosi oroguma rabineya mete bauwena, wagubu ke; ‘Yau ka nau Gubagani. Nau e winepuwani ki pokere e mena yonai ki wi wainapiyoi idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Bonana ki yona inako wagubu kewowena eweya ka mu Iyesu e eya mena ika uburawa emupu. E tadeyau kabukabuwa ragidai apeya eyaka ki mu yabumugere badidi emupu ade waina-mupu ki mu mubo mena notapamawa idiwa ko sisiya ki mu iyapana mo eba simupu. ");
INSERT INTO gdn_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Nawaru puruwena ka Iyesu e tadeyau kabukabuwa ragidai mete kweya kawareya ade wiratagubu kawamawa manako mu kweya kerareya bautagamawa makeya ka iyapana ropani kawaya mu ika bananatampu. ");
INSERT INTO gdn_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Iyapana ropani kawaya ki mu pauna-mugu ka apunu mosi ika uburawa e bonanai ragiragi kawaya wagubu ke; “Nidiyei Kabukabuwa Apunai, nau nidiyakani wainapi; Kau waitasini nau gubagani eyaka mena yau emani. ");
INSERT INTO gdn_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Maramara ka keyai berokoi mosi garugaru mena bauwagau kwewagau nau gubagani wadau wairau kwenupiyau da e idai kerarai kuduba patototagamu manako e umunai gipoporai bauwagau uwari sisiripiyau. Keyai berokoi ki kawareya kawareya e makari kweyau ko garugaru mena eba kamadau. ");
INSERT INTO gdn_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kau tadeyei kabukabuwa ragidai mu keyai berokoi ki siwakekepamana ki nana nau tadebuwani, ko mu siwakekemupu ko e eba bauwena kayawena.” ");
INSERT INTO gdn_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Apunu ki inako wagubu, ko Iyesu denai wagubu ke; “Wi nau eba suma-siniyamu ragidai. Wi paerepiyamu kawaya daganani. Nau mara badibadi yabaranugu wi mete yewe idiwomu? Nau mara badibadi wi bitaga kawaraponi yaroni tondoni?” E inako wagubu manako wirawena apunu ki sibu, wagubu ke; “Baganai, kau gubagagi wadi nau bamaneya yabi.” ");
INSERT INTO gdn_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Munu ki yabadawa makeya ka keyai berokoi ki e ragiragi kawaya minibu wairau kwenupupu manako munu ki e idai kerarai kuduba patoto-tagubu. Ko Iyesu e bonanai ragiragi kawaya keyai berokoi ki siwakekepupu, munu uratanai ki iyapupu manako wadubu e mamai kwebu. ");
INSERT INTO gdn_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Iyapana kuduba Mamanuga God e kasiyarai kawaya ki emupu ka mu notamaga kowena kodabamaga mete kamupu. Iyesu bagi kawaya badidi kwae-wagawa umawa ki kawareya iyapana deni deni tagamawa kasiwara idiwa ki pokere Iyesu wirawena e tadeyau kabukabuwa ragidai tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Nau karako wi nidiyani ki wi notaga eba gogayagisi; Iyapana ubumoto nau Kunumau Kawapuwani Apunai nau yogoni tagisi manako iyapana dai ki mu idamaga rabineya nau tamusinimoto.” ");
INSERT INTO gdn_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","E inako wagubu ko mu notamaga ka gwede mo bodapupu da mu yona ki mibai eba wainamupu. Mu e manupamana ko mu kudu mete waina-mupu ki pokere eba manumupu. ");
INSERT INTO gdn_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Mara mosi ka Iyesu e tadeyau kabukabuwa ragidai mu paunamugu nima ka kawaya esida ki sisiyai mu mubo deni deni tagamawa kasiwara idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Mu notamaga badidi nota-pamawa ki Iyesu e ororeya mena kataiwena ki pokere e munu mosi wadubu e madaneya tapu, ");
INSERT INTO gdn_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","manako tadebu, wagubu ke; “Iyapana nima nau sini pokaiya munu yau maba e diriwai kwaewagau ki ka e nau diriwani mete kwaewagau. Ade iyapana nima nau diriwani kwaewagau ki ka e nau Tonosinibu Apunai ki e diriwai mete kwaewagau. Nau yona mibai suwagani wainapumuri; Wi wainapiyamu da wi paunagau nima ka erida ki e ka esida, ade wi wainapiyamu da wi paunagau nima ka esida ki e ka erida.” ");
INSERT INTO gdn_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Iyesu inako wagubu, ko apunu Diyoni ubupu e sibu, wagubu ke; “Nidiyei Kabukabuwa Apunai, apunu mosi kau sigi pokaiya kweya kairapu siwakeketamiyawa ki nu emipi, ko e ka eba nu mete ewapuru iwei ki pokere e badidi kwaewagawa ki nu e kamadana ki nana simipi.” ");
INSERT INTO gdn_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Apunu Diyoni inako wagubu, ko Iyesu wirawena e tadeyau kabukabuwa ragidai apunu Diyoni mete kina denai tadebu, wagubu ke; “Ae, wi e inako eba bodampena, mibai ka iyapana nima wi eba tagararaniyau ki e ka wi waretaga.” ");
INSERT INTO gdn_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Mamanuga God e Iyesu ade tepapana kunumau kayawagana ki marai rogobiwena ki makeya ka Iyesu natere Diyerusaremu kayawagana ki nana wainapupu ki pokere e kipu ubupu deni mena natere ki yawatai kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","E kowakowaiyoma yabiri tonotapu e nene okukunatagamana ki nana ki mu kayatagubu kaiwa da yawatau ka mu tawana Sameriya ragidai mu nateremaga mo bautagubu. ");
INSERT INTO gdn_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Natere ki ragidai wainamupu da Iyesu natere Diyerusaremu kayawagawa ki ka mu gagayatagubu e diriwai eba kwaetagubu ko baiyonomupu. ");
INSERT INTO gdn_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Iyesu e tadeyau kabukabuwa ragidai Diyemesi yo Diyoni yona ki wainamupu ka mu nuwamaga pupuwena manako wira-tagubu Iyesu simupu, tagubu ke; “Kaiwawonuga, kau badidi wainapiyei? Nu Mamanuga God siyamu da mata nonarai kunuma were kaworoto natere yau ragidai ki uratamini popo bo?” ");
INSERT INTO gdn_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Mu inako tagubu, ko Iyesu mu nakaritapu, ");
INSERT INTO gdn_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","manako mu natere ki kamadumpu natere mo kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Mu yawatau kayatagubu kaiwa ka apunu mosi Iyesu bameya bauwena manako sibu, wagubu ke; “Kau tawana bani kayanuwagi ki nau mete kina kau ewakumaniyoni umoni.” ");
INSERT INTO gdn_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","E inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Taku kamarai ki mu gawaramaga mete kina ade midiwari iyarau iwu ki mu tawamaga mete ripa kawareya wadamu ko nau Kunumau Kawapuwani Apunai nau ukwarana bo aiyatasugana gawarani mo pa mena.” ");
INSERT INTO gdn_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","E apunu ade mosi sibu, wagubu ke; “Kau yabi nau ewaneya uburi mete kaigamu.” Ko apunu ki denai wagubu ke; “Kaiwawoni, kamadisini da nau yabiri kayasugani nau mamai powena ki ononopani were ewa ka nau bausugani kau ewageya kayasugani.” ");
INSERT INTO gdn_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Apunu ki inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Iyapana keyaimaga powena ragidai ki mu mena ubumoto popotagubu ragidai onono-tamini, ko kau upigi ka yau kena; Iyapana kebomana Mamanuga God e gari rabineya idiwana ki yonai kau dimanugowa umowa.” ");
INSERT INTO gdn_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ade apunu mosi bauwena Iyesu sibu, wagubu ke; “Kaiwawoni, nau kau ewageya kayasugani ko kau naiya tonosini da nau niya iyapananiyoma parautamani were ewa ka nau uburani kau ewageya kaniyani.” ");
INSERT INTO gdn_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","E inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Iyapana nima Mama-nuga God e upi kwaewagau ko ade wirawagau ewere kayawagana ki wainapiyau ki e kwaitana ka Mama-nuga God e gari rabineya e kasiyarai pokaiya idiwana ki upi eba kwaeyagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ki eweya ka nu Kaiwawonuga e tadeyau kabukabuwa ragidai ropani kawaya (72) ki winetapu da mu e upi kwaetagamana ki nana. E tawana tawana ewa kayawagana wainapiyawa ki tawanai ka e mu apeya tawana mo tonotapu ade apeya tawana mo tono-tapu. E inako kwaewena, ");
INSERT INTO gdn_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","manako yona yau tadebu, wagubu ke; ‘Maura ka kawaya daganani ko raupomu ragidai ka eba ropani ki pokere upi apunai bameya guriguriwogoi da e raupomu ragidai e kokoreya raupomutagamana ki nana tonotamini. ");
INSERT INTO gdn_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Karako wi kaiwagi, ko nau nidiyani wainapumuri; Wi ka papa sipi munai ki maba ko taku kamarai wasibena ki mu paunamugu ka nau wi tononiyakani. ");
INSERT INTO gdn_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Wi kaiwagi ki ka bowa madai ki sikwai bo igwa bo kerapuga tatamai inako ki wi eba tepiyoi ko ida kasikasi mena kaiwagi. Ade wi iyapana yawatau bananatamuri ki wi eba ubumoi mu parautamiyoi kwaenda wi madega kewopumuri. ");
INSERT INTO gdn_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Wi tawa mo yamuri ki ka wi yabiri yona yau mena iwagi ke; “Parau kawaya nuwabagi pokaiya.” ");
INSERT INTO gdn_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Iyapana mosi ika nuwabagi rabineya tondau ki ka e wi parauga ki mibai wainapoto. Ko tawa ki rabineya iyapana mo inako pa mena ki ka wi parauga iwagubu ki wirayagisi wi wiga rabinagau mete wadumuri kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Wi tawa mo yamuri ki ka wi tawa ki mena rabineya kupeiwogoi idiwoi ko eba tawa roroneya iwoi. Iyapana ubumoto bani yo awana wi negemoto ki ka baganai, ki ka wi upiga kwaiwagamu ki denai. ");
INSERT INTO gdn_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Wi natere mo baiwagi manako iyapana ika idiwu wi diriwaga kwae-tagisi ki ka baganai, mu bani negemoto ki wi kupumuri. ");
INSERT INTO gdn_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Sigira ragidai dai ika mete kina ki wi ubumuri mu iyatamuri ade iyapana tademuri, iwagi ke; “Wi Mamanuga God e gari rabineya kaiwana idiwana ki marai waunitau wi bamagau baiyagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Ko wi natere mo baiwagi manako iyapana ika idiwu wi diriwaga eba kwaetagisi ki ka wi imatau ubumuri manako iyapana ika idiwu ki yona yau mena tademuri, iwagi ke; ");
INSERT INTO gdn_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“Wi tawanaga dogiyai nu kerapunugu pasipupu ki nu wiga wairagau minimei gwepemei. Ko wainapumuri; Mamanuga God e gari rabineya kaiwana idiwana ki marai wana rogobiwena.” Wi inako mena mu tademuri. ");
INSERT INTO gdn_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Nau nidiyani wainapu-muri; Iyapana bigimaga denai wadamana ki marai baiyagisi ki ka natere Sodomu ragidai bita maraitau yadini ko wi diriwaga eba kwaetagubu ragidai ki mu ka bita kawaya daganani bananapomoto. ");
INSERT INTO gdn_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Akae, natere Korasini ragidai. Akae, natere Betaida ragidai. Wi ka aita ewa bita kawaya daganani bananapu-muri. Matakira kawakawaya wi paunagau wenawena ki wi yabugere emupu ko wi notaga eba wirawena. Natere Taya yo natere Saidoni ragidai matakira ki maba empena ki ka mu ororeya mena mu beramaga berokoi ki kamadumpena mu notamaga wirawagu-bena Mamanuga God kabuwampena manako mu ubumpena gwedegwede tegetegerei umampena ku pasitagu-mpena ade mibai nuwaboyai idimpena. ");
INSERT INTO gdn_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Mamanuga God e idai gurai wi naurigau ugwadiniyana ragiragi ki marai baiyagisi ki ka e uburoto natere Taya yo natere Saidoni ragidai kawaya daganani nuwanuwatamini ko e wi maraitau nuwanuwaniyoto. ");
INSERT INTO gdn_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ade natere Kaponiyamu ragidai, wi waina-piyamu da wi wibo kasiyaraga pokaiya esida kunumau yamuri, ko nau nidiyani wainapumuri; Ki pa mena. Mamanuga God e deni mena wi erida nununiyoto giriniyoto.” ");
INSERT INTO gdn_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Iyesu inako wagubu manako e tadeyau kabukabuwa ragidai yona yau mete tadebu, wagubu ke; “Iyapana gwedewau wi yonaga wainapiyamu ki ka mu nau mete wainasiniyamu. Ade iyapana gwedewau wi tagararaniyamu ki ka mu nau mete tagararasiniyamu. Ade iyapana gwedewau nau tagarara-siniyamu ki ka mu nau Tonosinibu Apunai ki e mete tagararapiyamu.” ");
INSERT INTO gdn_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Iyesu e tadeyau kabukabuwa ragidai ropani kawaya (72) ki mibi mamamai ade wiratagubu Iyesu bameya bautagubu manako simupu, tagubu ke; “Kaiwawonuga, nu kweya kairapu kau sigi pokaiya siwakeketameya ki ka mu nu umununuga wadamawa bautagamawa kayatagamawa.” ");
INSERT INTO gdn_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Mu inako tagubu, ko Iyesu denai mu tadebu, wagubu ke; “Berokoi Apunai Seitani e gwairiwena kauwena yangwara maba kunuma were kawapu ki nau empuwani. ");
INSERT INTO gdn_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Nau nidiyani wainapumuri; Nau kasiyara kuduba negebuwani da wi ubumuri wi iyaraga Seitani e raurupumuri manako e kasiyarai kuduba ki wi bamagau pamenayagisi. Nau kasiyara wi nege-buwani da wi motamota berokoi bo tori bo gwede berokoi inako ki wi taisi kurakuratamuri ko mu bidara wi eba negeni. ");
INSERT INTO gdn_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Nau yona yau nidibuwani ki kuduba ka mibai ko nau ade nidiyani wainapumuri; Keyai berokoi wi umunuga wadumupu bautagubu kaya-tagubu ki pokaiya wi eba mamama-iwogoi ko Mamanuga God wi siga kunumau okapupu ki mena pokaiya wi mamamaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ki makeya ka Mamanuga God e eya Keyai Tanai Bagi Kawaya Iyesu rabineya posiwena mamama kwebu manako e mibi mamamai Mamanuga God bameya parauwena, wagubu ke; “Mamai, kau ka kunuma yo waira ki Kaiwawoi ki pokere nau parauniyakani. Gora kataimugu ragidai ade katai ebo ebo kataitagubu ragidai ki mu bama-mugu ka kau yonagi wekepipi, ko iyapana karako munu rasi maba idiwu ki mu mena bamamugu ka kau notagi matarapipi. Ena, Mamai, kau kaubo nuwageya wainapipi da baganai ki pokere kau inako kwaenugibi.” ");
INSERT INTO gdn_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Iyesu Mamanuga God bameya inako parauwena kewowena ki ka e ade wagubu ke; “Nau Mamai gwedegwede kuduba tegebu nau umani sidibu. E mena e eya Gubagai nau kataisinibu wetawetara ade nau niya mena ka nau Mamai kataipuwani wetawetara. Ade iyapana gwedewau ki nau naubo nuwaneya winetapuwani da mu nau Mamai kataipamana ragidai ki mu mete kina ka nau Mamai kataipomoto.” ");
INSERT INTO gdn_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Iyesu yona ki wagubu kewowena ka e wirawena e tadeyau kabukabuwa ragidai mu mubo mena yona yau tadebu, wagubu ke; “Gwedegwede iyapana eba empiyamu ki wi yabugere empiyamu ki pokere mamamaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Nau yona mibai nidiyani wainapu-muri; Oragai Mamanuga God e bonanai wainapamawa tagamawa ragidai ropani kawaya ade kawakawai ragidai ropani kawaya mete kina ki mu ka wi karako badidi empiyamu ki mu mete empamana wainapamawa ko mu eba emupu. Ade wi karako badidi wainapiyamu ki mu mete wainapamana wainapamawa ko mu eba wainamupu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Mamanuga God e gorai kataiya apunai mosi Iyesu kerareya wadana ki nana e bameya bauwena manako manupupu, wagubu ke; “Sidiyei Kabukabuwa Apunai, nau badidi maba kwaesugani da nau denai maramara tondana kaniyana ki iyai yadani?” ");
INSERT INTO gdn_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Ko Iyesu denai e sibu, wagubu ke; “Kau manugi ki denai ka Mamanuga God e okai rabineya ka badidi wagau? Kau oka ki iyabapipi ki mibai kau badidi maba wainapiyei?” ");
INSERT INTO gdn_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Iyesu inako wagubu manako apunu ki denai wagubu ke; “Mamanuga God e okai wagubu ke; ‘Kau nuwagi notagi, kau mibigi ade kau kasiyaragi kuduba ki pokaiya nu Kaiwawonuga God deni mena nota kwarikwarisi-piyowa’, ade wagubu ke; ‘Kau kiya nene nota kwarikwarisinugei ki maba kau waretagi kau madanigeya tondau iyapanai ki e mete inako nota kwari-kwarisipiyowa.’ ");
INSERT INTO gdn_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Apunu ki inako wagubu, manako Iyesu denai e sibu, wagubu ke; “Kau yona mibai nuwagibi ki pokere kau inako mena kwaenugowa ki kau iya tondowa kaniyowa.” ");
INSERT INTO gdn_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Ko apunu ki e nuwaiya ka e ebo notai utautapana wainapiyawa ki pokere e Iyesu ade manupupu, wagubu ke; “Mamanuga God e okai iyapana madaninugu idiwu nene wagubu ki ka iyapana gwedewau?” ");
INSERT INTO gdn_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","E inako wagubu ko Iyesu denai e sibu, wagubu ke; “Nau keyakeyai mo karako suwagani ki kau wainapi; Apunu mosi natere Diyerusaremu kamadubu natere Diyeriko yawatai ki kayawena surawa da yawatau ka kuwa ragidai bautagubu e minimupu weumpu kwenumpu. E gwedegwedei ki mu rikamupu kuwamupu manako kawareya kawareya gudapamawa da e powagana kwaewagawa ka mu e pa kamadumpu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Mu kayatagubu eweya ka Mama-nuga God bameya dobopiyau apunai mosi yawata ki surawa. E bidara wadubu apunai ki buri empupu ka e paerewena tagai wirapupu deni mena kayawena, ko e eba waitapupu. ");
INSERT INTO gdn_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ki eweya ka kunu Riwai mu apunumaga mosi yawata ki mete surawa. Ko e mete kina bidara wadubu apunai ki empupu manako paerewena tagai wirapupu deni mena kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Siyarai ka tawana Sameriya ragidai mu apunumaga mosi ika yawatau surawa da bidara wadubu apunai ki buri empupu. E nuwaboyai wainapupu, ");
INSERT INTO gdn_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ki pokere e kanibu e bameya bauwena manako awana monamonai mosi ade awana ‘waeni’ mete kina ki tepupu apunu ki e kwatai kawareya pasipupu manako sikwapupu. E kwatai sikwapupu kewowena ka e apunu ki wadubu e ebo papai ‘donki’ ki kawareya tapu manako togipupu kayatagubu kaiwa da tawa mo bau-tagubu ka e bidara wadubu apunai ki ika tawa rabineya tapu manako ika kwayubapiyawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Nawaru puruwena ka e bowa madai bauburai apeya warapupu tawa ki apunai mosi kwebu manako sibu, wagubu ke; ‘Bidara wadubu apunai yau kau kwayubapiyowa. Kau bowa madai e pokaiya kwenupi ki nau ade wirasugani bausugani makeya ka nau ki kuduba denai makeya makeya kau negeyani.’ E inako wagubu.” ");
INSERT INTO gdn_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Iyesu keyakeyai ki wagubu kewowena ka e Mamanuga God e gorai kataiya apunai ki manupupu, wagubu ke; “Karako kau badidi wainapiyei? Iyapana apeya eyaka bautagubu bidara wadubu apunai ki emupu, ko mu paunamugu nima ubupu nu kowa-nuguma madaninugu idiwu mu bamamugu bagi kwaigemei ki maba apunu ki bameya kwaewena?” ");
INSERT INTO gdn_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Gora kataiya apunai ki denai wagubu ke; “Nau wainapakani da apunu bauwena e nuwaboyai waina-pupu ki kena.” E inako wagubu manako Iyesu denai e sibu, wagubu ke; “Kau yona mibai nuwagibi ki pokere kayanuwagi ki maba kau mete inako kwaenugowa.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Iyesu e tadeyau kabukabuwa ragidai mete kayatagubu iwa da natere mo bautagubu ka ridi mosi si ka Mata mu bibitapu ki pokere mu e tawaiya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Ridi Mata e yowai Meri kanibu nu Kaiwawonuga bameya kwarisiwena tondubu manako e yona-wagawa ki yonai naigida mena waina-piyawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ko ridi Mata e eba tondubu ko e tawiya ade upi marai kawai tawa rabineya e ebo mena kwaewagawa ki pokere Iyesu badidi yonawagawa ki e eba wainapupu. E yowai bameya eba bagi wainapupu manako e kanibu Iyesu empupu sibu, wagubu ke; “Kaiwawoni, nau niya mena karako wi tawiyaga kwaesugakani. Nau yowani nau eba waitasiniyau ki kau empiyei bo pa mena? Kau siyo da e yabadini nau waitasiniyoto.” ");
INSERT INTO gdn_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Ridi Mata inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Mata, Mata, kau upi marai kawai kwaenugei ki nene notapiyei ki pokere kau rabinagi urau. ");
INSERT INTO gdn_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Ko gwede mo eyaka mena ka kawaya esida. Kau yowagi Meri e ka supasupai bagi kawaya kwaewena. E nau yonani wainapana ki diriwai kwaewagau ki pokere iyapana mo eba baiyagisi e bodapoto.” ");
INSERT INTO gdn_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Mara mosi Iyesu Mamanuga God bameya guriguriwagawa tondawa da kewowena ki makeya ka e tadeyau kabukabuwa apunai mosi e bameya bauwena manako sibu, wagubu ke; “Kaiwawoni, iyapana siruwa-tamiyawa apunai Diyoni e ka e eya tadeyau kabukabuwa ragidai mu badidi maba Mamanuga God bameya guriguritagamana ki nana ki yawatai mu kabuwatapu. Kau mete kina nu inako kabuwaniyo.” ");
INSERT INTO gdn_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","E inako wagubu manako Iyesu denai tadebu, wagubu ke; “Wi Mamanuga God bameya guriguriwagi ki ka wi inako iwagi ke; ‘Mamanuga, nu nuwanugu kau sigi bagi kawaya ki kawayayagisi. Nu nuwanugu kau garigi rabineya kaiwana kau kasiyaragi pokaiya idiwana ki marai baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Kau nu baninuga maramara negeyowa, ");
INSERT INTO gdn_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ade nu kowanuguma berokoi nu bamanugu kwaetagubu ki nu nubo notanuga deni mena surumipi ki maba berokoi nu kwaigibi ki kuduba kau mete kau kaubo notageya deni mena surupi. Kau kwayubaniyo da gwede ragiragi mo eba baiyagisi nu nukeniyoto.’ Wi inako guriguriwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Iyesu yona ki wagubu kewowena ka e tadeyau kabukabuwa ragidai ade tadebu, wagubu ke; “Nau keyakeyai mo suwagani wainapumuri; Tedera paunau kau waretagi mosi e bameya kaya-nuwagi e gudui mini, nuwagi ke; ‘Kabai, iyapana mo kemora yau rabineya nau bamaneya bauwena ko nau diguma kororo ki pokere bani dai waitasini da nau tawiyasugani bani kweyani.’ Kau inako nuwagi, ");
INSERT INTO gdn_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ko kau waretaga ki denai yagisi ke; ‘Kau badidi pokere nau girisiniyei? Nau gudu umapuwani ade nau ridini mununiyoma mete kina ukwepemei ki pokere nau eba uburani bani kau negeyani.’ ");
INSERT INTO gdn_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iyesu inako wagubu manako ade wagubu ke; Keyakeyai suwagubuwani ki mibai wi wainapu-muri; Kau apunu ki bameya kawareya kawareya genenugowa tondowa ki ka e kemora ki rabineya gudu kwaipoto bani negeni. Ki ka eba kau e waretai ki pokere e uburoto bani ki negeni ko kau midimama eba wadinibu ko kawareya kawareya e gudui miniyeya genepiyeya tondeya ki pokere e uburoto bani dai tepoto kau negeni. ");
INSERT INTO gdn_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Ki maba, wi Mamanuga God bameya badidi iwagi ki e negeni ade wi iya yawatai kwaenepumuri ki ka e yawata ki wi kabuwaniyoto ade wi e gudui minimuri ki ka gudu ki wi nene siwayagisi, ");
INSERT INTO gdn_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","mibai ka iyapana gwedewau Mamanuga God bameya genetogomono ki ka e denai mu tageni ade iyapana gwedewau kwaenetogo-mono ki ka mu mibai bananapomoto ade iyapana gwedewau gudu minimono ki ka gudu ki mu nene siwayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Wi gwedewau munuguma mete kina ki wi yona yau wainapumuri; Wi munuga mosi menamena kupana nene yagisi ki ka wi e motamota berokoi kugura kwemuri bo? Ae, pa mena, wi menamena ki kwemuri. ");
INSERT INTO gdn_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Ade e midiwari bonai kupana nene yagisi ki ka wi e sisiya kawakawaya pakira ki kwemuri kupoto bo? Ae, pa mena, wi midiwari bonai ki kwemuri. ");
INSERT INTO gdn_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ki pokere wainapumuri; Iyapana wi ka eba bagi ko wi munuguma mu bamamugu ka wi bagi mena kwaiwagamu ade puyo bagi mena mu tageyamu. Ko Mamanuga God e ka bagi kawaya esida kunumau tondau ki apunai ki pokere wi mete kataigau da nima uburoto e bameya geneyagisi ki denai ka e uburoto e eya Keyai Tanai Bagi Kawaya iyapana ki puyo kweyoto.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Kweya kairapu mosi apunu mo e umunai bodapupu da e yona eba wagawa ki Iyesu siwakekepupu manako kweya kairapu ki matarau bauwena kayawagawa makeya ka apunu ki yona supasupai ade wagubu. Iyapana ropani kawaya Iyesu matakira kwaewena ki emupu ka mu notamaga kowena kodabamaga mete kamupu, ");
INSERT INTO gdn_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ko dai tagubu ke; “Kweya kairapu mu kawai-maga Besaboro e rabineya tondau kasiyara kweyau manako kasiyara ki pokaiya ka e kweya kairapu kuduba ki siwakeketamiyau.” ");
INSERT INTO gdn_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Iyapana dai inako tagubu ade dai nuwamugu Iyesu kerareya wadamana ki nana e simupu, tagubu ke; “Kau kunuma kasiyarai pokaiya matakira mo kwaenuwagi da nu empamu.” ");
INSERT INTO gdn_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Mu inako tagubu ko mu nuwa-maga notamaga ki Iyesu kataiwena kewowena ki pokere e denai tadebu, wagubu ke; “Tawana mosi ki ragidai nuwarara tagarara kande kasiwaratogomono idiwono ki ka mu purupurutagisi mu mubo mubo kaya-tagisi manako mu tawanamaga ki gumoroyagisi gwaba umuroto. Ade iyapana tawa eyaka mena rabineya ewa nauwa idiwono ki ka mu iyamaga giriyagisi mu mubo mubo kayatagisi. ");
INSERT INTO gdn_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Ko ki maba, Berokoi Apunai Seitani e ebo kowaiyoma mete kande kasiwara-tagisi ki ka e kasiyarai badidi maba uburono? Ki pa mena. Wi iwagamu da nau keyai berokoi mu kawaimaga Besaboro e kasiyara tegeyau pokaiya keyai berokoi siwakeketamakani, ko ki badidi maba? Keyai berokoi mu kawai-maga nau rabinaneya tondibena ki ka nau badidi maba nau niya kowaniyoma ki siwakeketapena? ");
INSERT INTO gdn_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Ade Besaboro e kasiyarai pokaiya nau kwaesugubena maba ki ka wi wiga kowaguma nima kasiyarai pokaiya keyai berokoi ki siwakeketamuimbena? Besaboro mu mete kasiyara tageyau bo? Nau nidiyani wainapumuri; Wi wiga kowaguma ki manutamuri da mu tagisi. ");
INSERT INTO gdn_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Nau Mamanuga God e kasiyarai pokaiya keyai berokoi ki siwakeketamakani bautagamu kayatagamu manako ki pokaiya ka wi kataigamana da Mamanuga God e gari rabineya kaiwana idiwana ki marai wi bamagau bauwena.” ");
INSERT INTO gdn_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Iyesu inako wagubu, ade wagubu ke; “Apunu kasiyarai kawaya ta yo kepata tepoto e ebo tawai taububarai purupono koyagai tondono ki ka kuwa apunai eba baiyagisi e tawai ki baupoto bo e gwedegwedei giripoto. ");
INSERT INTO gdn_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Ko kasiyara kawaya esida apunai mosi baiyagisi tawa apunai ki e tai ade e kepatai taoropoto ki ka e tawa apunai ki raurupoto e tawaiya yaroto. Tawa apunai e sumai ka e tai ade e kepatai ki bamamugu tondau, ko ki ka eba baganai. Kasiyara kawaya esida apunai ki baiyagisi ki ka e tawa apunai ki raurupoto e gwedegwedei kuduba tepoto nidapoto. ");
INSERT INTO gdn_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Nau nidiyani wainapumuri; Iyapana nima nau diriwani eba kwaewagau ki ka e nau tagararasiniyau. Ade nima nau nene iyapana eba wara-tamiyau ki ka e mu daburitamiyau.” ");
INSERT INTO gdn_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Iyesu inako wagubu, ade tadebu, wagubu ke; “Nau nidiyani wainapu-muri; Keyai berokoi iyapana mosi kamadini baiyagisi kayayagisi ki ka e tondana aiyatawagana tawanai waunai mo kwaenepono umono. E wata bagi mosi eba bananapoto ki ka e notai yagisi ke; ‘Nau karako ade wirasugani wata naiya tondekeya ki kayasugani.’ ");
INSERT INTO gdn_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","E notai inako yagisi manako e wirayagisi baiyagisi ki ka e tawa meme warawaramupu monagamupu bagi kawaya ki empoto, ");
INSERT INTO gdn_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ki pokere e mamamayagisi kayayagisi e kowaiyoma ida daikere kewowena daikere apeya (7) e maba ko ade berokoi esida ki waratamini manako mu baitagisi ewapuru mena ika idiwono. Naiya keyai berokoi eyaka mena iyapana ki rabineya tondawa ki makeya ka e bagasitau tondawa ko karako ka keyai berokoi ropani kawaya e rabineya tawatagubu idiwu ki pokere e iyai ka berokoi kawaya.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Iyesu yona ki wagawa makeya ka ridi mosi ika iyapana paunamugu uburawa ki e bonanai ragiragi kawaya wagubu ke; “Ridi nima kau wenanibu ade e amui kau kubabi ki ridai ka mibi mamamai tondono.” ");
INSERT INTO gdn_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Ko Iyesu denai wagubu ke; “Kau yona ki nuwegei ko iyapana gwedewau Mamanuga God e yonai wainapomono makeya makeya kwaetogomono ragidai ki mu ka mibi mamamai idiwono.” E inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Iyapana ropani kawaya Iyesu kwagaramupu ubumawa ka e wirawena mu tadebu, wagubu ke; Iyapana karako idiwu ragidai wi beraga ka eba bagi. Wi kunuma matakirai ki empamana ki nana iwagamu ko matakira inako mo wi bamagau eba wenayagisi. Oragai apunai Diyouna badidi kwaewena ki mena maba wi bamagau matarayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Mamanuga God e takari kawaya apunu Diyouna pokaiya tawana Niniwe ragidai e kasiyarai empamana ki nana kabuwatapu ki maba ka e karako nau Kunumau Kawapuwani Apunai nau pokanere iyapana karako idiwu ragidai e kasiyarai wi kabuwaniyoto. ");
INSERT INTO gdn_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Naiya takari kawaya ka tawana Seba mu ridimaga kawai mosi tawana uwama kawaya were yabadubu apunu Soromoni e notai supasupai pokaiya dimawagawa ki yonai wainapana ki nana bauwena. Apunu Soromoni e ka apunu kawaya ko nau suwagani wainapumuri; E ka ade erida ko apunu karako bauwena apunai ki e mena ka kawaya esida. Ko e yonai ki wi eba wainapiyamu ki pokere Mamanuga God e idai gurai wi naurigau ugwadiniyana ragiragi ki marai baiyagisi ki ka ridi kawai ki e mete uburoto e idai gurai iyapana karako idiwu ragidai wi naurigau ugwadiniyoto ragiragi. ");
INSERT INTO gdn_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Oragai apunai Diyouna dimawagawa makeya ka tawana Niniwe ragidai mu notamaga wirawena manako mu beramaga berokoi kuduba kamadumpu. Ko wi inako eba kwaigubu ki pokere Mamanuga God e idai gurai iyapana kuduba wi naurigau ugwadiniyana ragiragi ki marai baiyagisi ki ka tawana Niniwe ragidai ki mu mete ubumoto mu idamaga gurai wi naurigau ugwadini-moto ragiragi. Oragai apunai Diyona e ka apunu kawaya, ko nau suwagani wainapumuri; E ka ade erida ko karako bauwena apunai ki e mena ka kawaya esida.” ");
INSERT INTO gdn_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Iyesu iyapana ade tadebu, wagubu ke; “Iyapana mosi e duna beupoto ki ka e duna ki eba wekepoto bo kurari umuneya taroto. Pa mena. E matarau taroto da iyapana e tawai rabineya yamoto ki ka mu duna ki tanai em-pomoto. ");
INSERT INTO gdn_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Ki maba, wi yabuga ka wi midiga kwakwarepuga ki dunai. Wi yabuga bagi negai kawaya ki ka wi midiga kwakwarepuga ade wi notaga ki mete tanai kawaya. Ko wi yabuga gwakugwakuyagisi berokoyagisi ki ka wi midiga kwakwarepuga ade wi notaga tanai ki sisipupoto. ");
INSERT INTO gdn_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Ki pokere naigida mena idiwoi kwaenda tanai wi rabinagau ki sisipu umoroto. ");
INSERT INTO gdn_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Wi nuwaga notaga tanai mena ade wi midiga daikere mo sisipu rabineya eba tondau ki ka iyapana duna pasumu tanai miniyau siwa ki maba tanai ka wi midiga kwakwarepuga kuduba miniyoto siwa.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Iyesu yona ki wagubu kewowena ka Parisi apunai mosi bauwena e bibipupu da e mete kayatagamana e tawaiya bani ewapuru kupetagamana ki nana wagubu. Iyesu apunu ki banana-pupu e tawaiya yapu manako kupe wateya kwarisiwena tondubu. ");
INSERT INTO gdn_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Mu kupetagamana kwaetagamawa ka Diyu ragidai mu goramaga pokaiya idamaga siruwapiyamu ki makeya Iyesu eba kwaewena ki pokere Parisi apunai ki Iyesu empupu manako e notai babawena. ");
INSERT INTO gdn_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Ko nu Kaiwawonuga wirawena apunu ki sibu, wagubu ke; “Wi Parisi ragidai ka wi kapaga yo wi yogoga ki tagai mena siruwapiyamu da iyapana wi eminimana tagamana da wi ka baganai. Ko wi rabinagau ka berokoi posiwena kapoi mena kwaiwagamu idiwu. ");
INSERT INTO gdn_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Wi ka notababa ragidai. Wi midiga kwakwarepuga yamanapupu apunai ki ka e eba wi kwakwarepuga ki mena yamanapupu ko e wagubu umuneya ka wi nuwaga notaga mete wenapupu. ");
INSERT INTO gdn_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Nau nidiyani wainapu-muri; Gwede bani wi kapaga yo wi yogoga rabineya posiwena uburau ki wi tepumuri iyapana imagei ragidai tagemuri. Wi inako kwaiwagi ki ka wi nuwaga notaga ade wi kwakwarepuga bigi posiwena ki mete taniyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Akae, Parisi ragidai, wi ka aita bita kawaya bananapumuri. Wi ka kusura gumai ade kwarai ebo ebo ki tepiyamu naigida mena damupiyamu manako damu ida esida mena ki damu eyaka mena ki wi Mamanuga God nene tamu. Ko iyapana bamamugu supasupai kwaiwagamana ki wi eba kwaiwagamu ade Mamanuga God e wi eba nota kwarikwarisipiyamu. Wi ki mete kwaigumpena ko eba damu eyaka mena Mamanuga God kweyamana ki mena wainampena. ");
INSERT INTO gdn_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","Akae, Parisi ragidai, wi ka aita bita kawaya bananapumuri. Guriguri tawai rabineya ka wi kawai gisipiyamu kawakawai ragidai mu watamaga bagi kawaya ki kawareya idiwu. Wi ka imatau kaiwu kebomu da iyapana wi eminimana paraunimana naigida mena wiwiranimana ki nana kwaiwagamu. ");
INSERT INTO gdn_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Akae, wi ka aita bita kawaya bananapumuri. Popotagubu ragidai mu rakimaga gwaba utapupu ki iyapana eba empiyamu ki pokere kawareya asusu kaiwu kebomu da ki pokaiya bigitagamu ki maba ka wi mete kina iyapana bigi tageyamu.” ");
INSERT INTO gdn_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Iyesu yona inako wagubu ki Mamanuga God e gorai kataiya apunai mosi wainapupu manako e Iyesu sibu, wagubu ke; “Nidiyei Kabukabuwa Apunai, kau Parisi ragidai inako tadeyei ki kau Mamanuga God e gorai kataigibi ragidai ki nu mete nidiyei siyasiya.” ");
INSERT INTO gdn_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","E inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Akae, Mamanuga God e gorai kataigau ragidai, wi mete kina ka aita bita bananapumuri. Wi wibo goraga ragiragi kawaya ki wi iyapana kwepokaramugu bita nakapiyamu ko iyapana wi goraga ki makeya makeya kwaetagamana ki nana muya nunumu ki ka wi mu eba waitatamiyamu. ");
INSERT INTO gdn_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","48","Akae, wi ka aita bita bananapu-muri. Naiya takari kawaya ka wi ripakwarakwaraguma ubumpu Mama-nuga God e bonanai wainapamawa tagamawa ragidai ki namutamawa manako ononotamawa. Ko mu ononotampu watamaga ki wi karako monagatamiyamuki pokere mu berokoi badidi kwaetagamawa ki wi mibi-piyamu. Mu yo wi paerega ka eyaka mena. ");
INSERT INTO gdn_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Wi inako kwaiwagamu ki pokere Mamanuga God e katai pokaiya ka e inako wagubu ke; ‘Nau bonanani wainapamana tagamana ragidai ade nau bigabiganiyoma ragidai mete kina ki nau tonotamani iyapana paunamugu nau yonani togomono iwono ko iyapana ubumoto mu dai namutamini ade dai mu giritamini pasutamini.’ ");
INSERT INTO gdn_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Nau nidiyani wainapumuri; Mamanuga God e kunuma waira yamanapupu makeya yabadubu da karako ka wi ripakwara-kwaraguma paerepamawa e bonanai wainapamawa tagamawa ragidai ki mu namutamawa kebomawa ko ki bimbinai ka wi karako idiwu ragidai wadumuri. ");
INSERT INTO gdn_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Naiya takari kawaya mu apunu Eiboro minimpu poyo yabadawa da Mamanuga God e Tawai rabineya ‘Puyo Tamu Watarai’ ade ‘Wata Tanai Bagi’ ki paunau ka mu ubumpu apunu Sekaraiya minimpu poyo, mu berokoi kuduba kwaetagamawa ki bimbinai ka wi wadumuri. Ena, nau yona mibai nidiyani wainapumuri; Iyapana kuduba namutampu popotagubu ragidai mu bimbinamaga ka wi karako idiwu ragidai wadumuri. ");
INSERT INTO gdn_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","Akae, Mamanuga God e gorai kataigau ragidai, wi ka aita bita kawaya bananapumuri. Iyapana Mamanuga God e notai kataitagamana ki katamuruiya kaiwana ki katamurui ka wi kasipara tamu. Wi wiga ka nota ki eba kataigamana wainapiyamu ade iyapana nota ki kataitagamana wainapiyamu kaiwu ragidai ki mu yawatamaga ki wi bodapiyamu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","54","Iyesu wata ki kamadubu bauwena kayawagawa makeya ka Mamanuga God e gorai ki kataimugu ragidai ade Parisi ragidai mete kina e kerareya wadamana da e yona mo paerepana manako mu ki pokaiya e wadamana ki nana ki yawatai kwaene-pamawa. Mu e kawareya kawareya pari wirawirapamawa, manupamawa ade ragiragi kawaya wereyakaurapamawa. ");
INSERT INTO gdn_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Mara ki makeya ka iyapana ropani kawaya eba iyabapamana makai Iyesu e yonai wainapamana ki nana dibimupu tatara kasiwaratagamawa idiwa manako Iyesu ubupu e tadeyau kabukabuwa ragidai naiya mu muga mena yona yau tadebu, wagubu ke; “Nau nidiyani wainapumuri; Parisi ragidai mu banimaga bedebedepupu ki wi naigida mena empiyoi kaisipiyoi kwaenda mu banimaga kinokinoi ki wi pasiniyoto. Nau waigugu suwagubuwani ki mibai ka yau kena; Parisi ragidai mu ka pa midimaga matakawagau ragidai. ");
INSERT INTO gdn_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Gwedegwede kuduba iyapana uta-piyamu ki utai ka mara mosi wakayagisi, ade gwedegwede kuduba wekewekei ki ewa marai mosi matarayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Wi yona ebo ebo sisipu iwagubu ki kuduba ka nawarau matarayagisi, ade wi yona ebo ebo wi tawaga gudu umampu rabineya umana misimisi iwagubu ki yonai ka iyapana tawa tagaiya yamoto wena siyomoto da iyapana kuduba waina-pomoto. ");
INSERT INTO gdn_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Kowaniyoma, nau nidiyani wainapu-muri; Iyapana wi kwakwarepuga mena minimoto poyo ko gwede mosi kawareya eba kwaetagisi ki mu kudumugu wi eba wainapiyoi. ");
INSERT INTO gdn_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wi nima kudeya waina-pamana ki e nau karako wi kabuwa-niyani; Mamanuga God e mena kudeya wi wainapiyoi. E wi namuniyana ki kasiyarai wadubu ade wi teniyana bita wadamana tawaneya isiyaniyana ki kasiyarai e mete wadubu. Ena, nau nidiyani wainapumuri; E mena kudeya wi wainapiyoi. ");
INSERT INTO gdn_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","7","Iyapana midiwari gunototo ida daikere mena tepomoto iyapana gimarapomoto ki ka mu denai marai munta waibora daragai apeya ki mena yadini mibai ka midiwari ki ka rasirasi. Ko wainapumuri; Midiwari ki ka rasirasi ko Mamanuga God e ka mu mo eyaka mena kwaitana eba notagogapupu. E yabuiya ka midiwari ki maimerei munta erida ko wi ka kawakawaya esida. Wi debaga kumai eyaka eyaka ki e iyaba-pupu kewowena wi notananiyau ki pokere wi kudu eba wainapiyoi.” ");
INSERT INTO gdn_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Iyesu inako wagubu, ade wagubu ke; “Nau suwagani wainapumuri; Nima uburoto iyapana paunamugu matarau yagisi ke; ‘Nau ka Iyesu e nene’, nima inako yagisi ki ka aita ewa ka nau Kunumau Kawapuwani Apunai mete uburani manako Mamanuga God e aneyaiyoma mu yabaramugu suwagani ke; ‘Iyapana yau ka nau nene.’ ");
INSERT INTO gdn_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Ko nima uburoto iyapana paunamugu matarau yagisi ke; ‘Nau ka eba Iyesu e iyapanai’, nima inako yagisi ki ka aita ewa ka nau mete uburani manako Mamanuga God e aneyaiyoma mu yabaramugu suwagani ke; ‘Iyapana yau ka eba nau nene.’ ");
INSERT INTO gdn_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Iyapana nima uburoto Kunumau Kawapuwani Apunai nau sidiyoto siyasiya ki ka Mamanuga God iyapana ki e bigi deni mena surupana yawatai mete kina. Ko iyapana nima uburoto Mamanuga God e eya Keyai Tanai Bagi Kawaya ki siyoto siyasiya ki ka Mamanuga God iyapana ki e bigi deni mena surupana yawatai pa mena. ");
INSERT INTO gdn_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Iyapana wi tenimoto mu guriguri-maga tawai rabineya bo kawakawai ragidai ebo ebo mu yabaramugu wi nakanimoto manako nidimoto wirawira ki ka wi taububaraga badidi iwagamana ki pore eba wainapiyoi. ");
INSERT INTO gdn_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Wi yona denai iwagamana marai baiyagisi ki ka Mamanuga God e eya Keyai Tanai Bagi Kawaya wi badidi iwagamana kabuwanibu ki makeya mena wi iwagi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Iyapana ropani kawaya ki mu paunamugu ka apunu mosi kanibu Iyesu sibu, wagubu ke; “Sidiyei Kabukabuwa Apunai, nau tatai siyo da nu mamanuga e buderi ki e purupoto daikere nau tegeni ade daikere e eya yadini.” ");
INSERT INTO gdn_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Apunu ki inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Kabai, ki ka wi wibo keteketega. Nau ka eba wi paunagau uburana wi gwedegwedega purupana negeyana ki upi wadubuwani.” ");
INSERT INTO gdn_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","E inako wagubu ade iyapana kuduba tadebu, wagubu ke; “Wi kwayubaga naigida kwaiwogoi idiwoi kwaenda kapoi ade nuwaroro ki notai wi umaniyoto dokodoko. Wi gwedegwedega mete kina bo pa mena ki ka asusu. Ki ka eba wi gwedegwedega ki pokaiya wi iya mibai wadumuri.” ");
INSERT INTO gdn_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Iyesu inako wagubu manako keyakeyai yau tadebu, wagubu ke; “Mara mosi ka purapura apunai mosi e kokorai maura kawaya daganani yabadubu, ");
INSERT INTO gdn_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","manako e notai wagubu ke; ‘Nau banini magara nakapana tawai ororeya mena posiwena, ");
INSERT INTO gdn_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ki pokere nau inako kwaesugani; Nau banini magara nakapana tawai oragai dai nau koritatamani ade tawa waunai kawakawaitau dai nau waditamani manako nau banini magara ade nau gwedegwedeni kuduba ki nau bonda ika nakapani. ");
INSERT INTO gdn_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Nau inako kwaesugani manako nau niya sidisugani, suwagani ke; ‘Nau karako bani yo gwedegwede kwamura ropani kawaya nene bonda nakapuwani ki pokere nau pa aiyata-sugoni mibi mamamai bani irimagere kuponi ade awana kuboroni tondoni.’ ");
INSERT INTO gdn_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Apunu ki e notai inako wagubu, ko Mamanuga God e sibu, wagubu ke; ‘Kau ka notababa apunai. Kemora yau rabineya ka kau ponuwagi manako kau banigi ade kau gwedegwedegi kiya nene bonda nakapipi ki nima tepoto?” ");
INSERT INTO gdn_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Iyesu keyakeyai ki wagubu manako iyapana ade tadebu, wagubu ke; “Nau suwagubuwani ki mibai ka yau kena; Iyapana gwedewau magara usi kunumau ki nene eba wainapiyamu ko mu muga kwakwarepumaga yewe wairau ki mena wainapiyamu gwedegwedei damupiyamu ki mu bamamugu ka apunu yau bameya wenawena ki maba mu bamamugu inako mete wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Ki eweya ka Iyesu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Nau nidiyani wainapumuri; Wi karako yewe idiwana ki iyai nene eba wainapiyoi. Wi masura kupamana bo midi tatamai umamana ki bani deneya baiyagisi ki nene wi eba wainapiyoi bo nuwaboyaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Bani ka eba gwede kawaya mosi ko wi iyaga ka kawaya esida. Ade sipuma goragora ka eba gwede kawaya mosi ko wi midiga kwakwarepuga ka kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Nau keyakeyai mosi midiwari ogaoga naureya suwagani ki wi wainapumuri; Midiwari ki mu upi eba kwaetagamu, mu raupomu eba kwaetagamu, ade mu bani magara nakapamana tawai pa mena, ko Mamanuga God maramara mu bani tageyau. Wainapumuri; Mamanuga God e yabuiya wi ka kawaya esida ko midiwari mu ka erida ki pokere wi bani nene eba wainapiyoi bo nuwaboya-iwogoi. ");
INSERT INTO gdn_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Kau yewe wairau tondana ki iyai nene mena notapiyowa kwaenepiyowa yarowa ki pokaiya kau wainapiyei da kau iyagi piri munta rowarowayagisi yaroto bo? Ki pa mena. ");
INSERT INTO gdn_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nau nidiyani wainapumuri; Wi notaga pokaiya kwaenepiyoi yamoi manako ki pokaiya wi iyaga piri munta maba eba rowarowayagisi ki ka wi gwede nana waira yau e gwedegwedei nene wainapiyamu nuwaboyaiwagamu? ");
INSERT INTO gdn_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ade nau keyakeyai mosi paraparawasi naureya nidiyani ki wi wainapumuri; Paraparawasi mu ka eba upitagamu ade mu kwakwarepumaga nene eba wainapiyamu. Ko wainapu-muri; Apunu kawai Soromoni e ka purapura apunai ade e gwedegwedei umapu monagawena ka tanai kawaya, ko e gwedegwedei ki tanai ka ade marai munta erida ko paraparawasi mu tanimaga Mamanuga God mu pa tagebu ki tanai ka kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Gwaba karako kasiga bagi kawaya uburau ko tawiri pasumoto ki uroto kewoyagisi. Ko wainapumuri; Mamanuga God gwaba kaina ki pa monagatamiyau ki ka e sipuma goragora wi negeni monaganiyoto bo? Ena, e wi negeni monaganiyoto. Akae, wi sumaga Mamamanuga God bameya ka marai munta erida wainapakani. ");
INSERT INTO gdn_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Wi bani kupamana bo awana kubamana ki nene eba wainapiyoi bo nuwaboyaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Mamanuga God eba kataimugu ragidai tawana tawana idiwu ki mu inako kwaetagamu kwaenetagamu iwu, ko wi Mamaga kunumau tondau e kataiya da wi bani pa mena ade gwedegwede pa mena pa idiwana ka eba baganai. ");
INSERT INTO gdn_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Wi e gari rabineya e kasiyarai pokaiya idiwana ki kwaenei mena kwaiwagi ki ka bani yo gwedegwede inako ki kuduba e deni mena wi negeni. ");
INSERT INTO gdn_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Kowaniyoma, wi ka eba ropani ko nau nidiyani wainapumuri; Wi notababa eba wadoi mibai ka wi Mamaga e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki puyoi e nuwaiya wi negeyana wainapiyau. ");
INSERT INTO gdn_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Wi wiga gwedegwedega nidapumuri manako denai bowa madai wadumuri ki wi iyapana imagei ragidai tagemuri, ade wi magaraga yewe wairau eba bondaiwogoi ko wi nuwaga notaga kunuma magarai aita ewa eba goga-wagana ki kawareya ukworono. Usi kunumau ka kuwa ragidai eba baitagisi wi gwedegwedega kuwatagisi ade ketere eba baitagisi wi gwedegwedega purupomoto. ");
INSERT INTO gdn_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Wi magaraga yewe wairau damupiyoi ki ka wi nuwaga notaga magara ki mena kawareya ukworono. Ko wi magaraga kunumau damupiyoi ki ka wi nuwaga notaga kunuma gwedegwedei ki mena kawareya ukworono.” ");
INSERT INTO gdn_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Iyesu inako wagubu ade wagubu ke; “Apunu kawai mosi e bigabigaiyoma e nawanai idiwu ki maba wi inako mete idiwoi. Apunu kawai ki uburoto anika kupei kawareya kayayagisi ki ka e bigabigaiyoma e tawai ki kwayubapomono idiwono. E ade wirayagisi baiyagisi gudu miniyono ki ka mu yabu idiwu ki pokere gudu garugaru mena kwaipomoto. Ki maba wi mete kina wi midiga tatamai uma-muri duna pasumuri manako nawana yabu yabu idiwoi. ");
INSERT INTO gdn_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Bigabiga ragidai yabu yabu nawana idiwono da mu kawaimaga ade wirayagisi baiyagisi mu emitamini ki ka e mu mamamamaga yagisi. Ena, nau nidiyani wainapumuri; E eya gwedegwedei bagi ki e rikapoto nakapoto manako e bigabigaiyoma tadeni da mu idiwoto manako e eya uburoto mu banimaga warapoto tageni. ");
INSERT INTO gdn_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Wainapumuri; Mu kawaimaga tedera paunau bo nawaru sisipui teyonono makeya baiyagisi manako e biga-bigaiyoma e nawanai yabu yabu idiwu ki emitamini ki ka e mu mamamamaga kawaya yagisi. ");
INSERT INTO gdn_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ko wi yona yau mete naigida mena wainapumuri; Tawa apunai ki kuwa apunai gwede madega bauwagana ki madegai kataiwagubena ki ka e dagurai tondibena da kuwa apunai e tawai eba baupena. ");
INSERT INTO gdn_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ki maba, nau Kunumau Kawapuwani Apunai ade wirasugana bausugana marai ki wi eba kataigau ki pokere wi mete kina yabu yabu nau nawanasiniyoi idiwoi mibai ka wi notapiyoi da nau eba bausugana marai ki nau bausugani.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Apunu Pita yona ki wainapupu ka e Iyesu manupupu, wagubu ke; “Kaiwa-woni, kau keyakeyai nuwagibi ki kau nu nene mena nuwagibi bo iyapana kuduba ki mu nene mete nuwagibi?” ");
INSERT INTO gdn_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","E inako wagubu, ko nu Kaiwawo-nuga wirawena denai e sibu, wagubu ke; “Bigabiga apunai mosi e upi eba kamadau ko e notai supasupai mena upiwagau ki ka tawa apunai uburoto bigabiga apunai ki tepapoto siyoto da e tawa ki gwedegwedei kuduba mete kwayubapono ade e kowaiyoma bigabiga ragidai upitagamu ki mu denimaga makeya makeya tageyana ki upi e mete kwaeyogono. ");
INSERT INTO gdn_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","E upi bagi kawaya inako kwaeyogono tondono da tawa apunai ki ade wirayagisi baiyagisi e empoto ki ka apunu kawai ki uburoto e bigabigai apunai ki mamamapoto. ");
INSERT INTO gdn_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Ena, nau nidiyani wainapumuri; Bigabiga apunai bagi kawaya inako upiyogono ki ka tawa apunai uburoto e tepapoto manako siyoto, yagisi ke; ‘Nau tawani ade nau gwedegwedeni kuduba ki debai nau karako kau tamuniyakani.’ ");
INSERT INTO gdn_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Ko bigabiga apunai ki e notai yagisi ke; ‘Nau kawaini wirawagana bau-wagana marai ki e bani paerepupu rowarowa kawaya umau wadau’, e inako notapoto manako e eya kawai gisipono e kowaiyoma bigabiga ragidai ridi yo apunu ki tauniyono makari tageyono ade bani kawaya daganani kupono awana suwakarai kuburono da e yabarai babayagisi, ");
INSERT INTO gdn_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","e inako kwaeyogono ki makeya ka tawa apunai ki ade wirayagisi baiyagisi manako e bigabigai apunai ki nainipoto. Tawa apunai ade wirawagana bauwagana ki e eba nawanapiyawa ki pokere apunu kawai ki uburoto e bigabigai apunai ki gudapoto bita kweyoto manako yadini iyapana e umunui eba wadamu ragidai ki mu paunamugu kwenupoto. ");
INSERT INTO gdn_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Iyapana nima bigabiga upi kwaewagau manako tawa apunai e upi badidi kwaewagana sibu ki e kataiwena ko e nawana eba tondau ade upi wadubu ki e eba kwaewagau, ki ka aita ewa ka auda kawaya iyapana ki meyoto. ");
INSERT INTO gdn_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Ko iyapana nima bigabiga upi kwaewagau ko tawa apunai e upi badidi kwaewagana sibu ki e naigida eba wainapupu ki pokere e kwaeyogono manako gwede mo paerepoto, ki ka auda maraitau iyapana ki meyoto. Iyapana nima gwede kawaya daganani wadubu ki ka e makeya kawaya daganani ade wirapoto. Ade nima e idaiya gwede kawaya daganani naka-mupu ki ka e makeya kawaya daganani ade wirapoto.” ");
INSERT INTO gdn_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Iyesu mu ade tadebu, wagubu ke; “Nau waira yau kawareya tawiri pasurana ki nana bausugubuwani ko tawiri ki naiya mena beuwagubena ka baganai. ");
INSERT INTO gdn_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Siruwa mosi nau nawanani tondau. Nau siruwa ki bitai ororeya mena bananapena ki ka baganai ko karako ka bita ki nau nawanani tondau ki pokere nau nuwaboya mete waina-pakani. ");
INSERT INTO gdn_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Wi bani wainapiyamu da wi nuwabagi rabineya yewe wairau idiwana ki nana nau bausugubuwani? Ki pa mena. Nau eba ki nene bausugu-buwani. Nau wi puruniyana ewanauwa-niyana ki nana bausugubuwani. ");
INSERT INTO gdn_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Mara karako ade yabaranugu esida yamomu ki ka iyapana ida daikere mena tawa eyaka mena idiwu ki mu ewanauwa-tagisi. Apeya eyaka ubumoto apeya iyaratamini bo ade apeya ubumoto apeya eyaka iyaratamini. ");
INSERT INTO gdn_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Mamai uburoto e gubagaiyoma iyaratamini ade e gubagaiyoma ubumoto mu mama-maga iyarapomoto. Inai uburoto e peteiyoma iyaratamini ade e peteiyoma ubumoto mu inamaga iyarapomoto. Memenagui uburoto e wawanepui iyarapoto ade e wawanepui uburoto e memenagui iyarapoto.” ");
INSERT INTO gdn_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Iyesu iyapana inako tadebu ade tadebu, wagubu ke; “Wi oroguma piniyogono empumuri ki wi notaga garugaru mena yagisi ke; ‘Nawaya bauwagana kwaewagau.’ Manako nawaya baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Ade wi kaukabokabo empumuri ki ka wi notaga garugaru mena yagisi ke; ‘Kwamura uburana kwaewagau.’ Manako kwamura uburoto. ");
INSERT INTO gdn_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Wi ka midiga pa mataka-wagau ragidai. Wi kunumau ade wairau badidi wenawagau ki kiyabui empiyamu manako ki pokaiya ka wi kataigubu da nawaya baiyagisi, nusuru baiyagisi, bo kwamura marai uburoto. Ko wi gwede nana Mamanuga God karako badidi kwaewagau ki empiyamu ko wi empiyamu ki mibai wi eba kataigubu? ");
INSERT INTO gdn_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Bagi ka bani kena ade berokoi ka bani kena ki wi badidi pokere eba kataigubu? ");
INSERT INTO gdn_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Iyapana mosi kau paerepipi ki denai kau wadiniyoto wade supasupanimana ragidai mu bamamugu kayayagisi ki ka wi wiga mena paere ki wadumuri supasupa kwaenda idai gurai wi naurigau ugwadiniyau ragiragi apunai ki uburoto kau wadiniyoto pinai ragidai mu idamugu tamuniyoto manako mu ubumoto kau diburanimoto. ");
INSERT INTO gdn_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Nau suwagani wainapumuri; Kau dibura ki rabineya tondowa yarowa da kau paeregi ki denai kuduba kau kewopi were ki kau ade baunuwagi kayanuwagi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Mara ki makeya ka iyapana dai bautagubu Iyesu simupu, tagubu ke; “Tawana Gariri ragidai dai ki Mamanuga God nene puyo naka-pamawa ki makeya ka apunu Pairasi e piyaraiyoma bautagubu iyapana ki namutampu gawarara.” ");
INSERT INTO gdn_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Mu inako tagubu ko Iyesu denai mu tadebu, wagubu ke; “Wi bani wainapiyamu da tawana Gariri ragidai ki mu bigimaga ka kawaya esida ki pokere mu berokoi ki bananamupu ko ade tawana Gariri ragidai dai ki mu bigimaga ka marai munta ki pokere mu bita eba banana-mupu. Wi inako wainapiyamu bo? ");
INSERT INTO gdn_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Nau nidiyani wainapumuri; Wi wiga beraga berokoi ki wi eba kamadumuri ade wi notaga eba wirayagisi ki ka mu popotagubu ki maba wi mete inako popoiwagi. ");
INSERT INTO gdn_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ade iyapana ropani kawaya (18) tawana Siramu rabineya idiwa da tawa iyarau kawaya ki rorororowena mu kawarimugu kawapu namutapu gawarara ki wi wainapiyamu da mu bigimaga ka kawaya esida ko iyapana dai ki natere Diyerusaremu rabineya idiwa ki mu bigimaga ka pa mena? ");
INSERT INTO gdn_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Nau kawareya ade suwagani wainapumuri; Ki pa mena, ko wi wiga beraga berokoi eba ki kamadumuri ade wi notaga eba wirayagisi ki ka mu popotagubu ki maba wi kuduba inako mete gogaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Iyesu inako wagubu manako keyakeyai mo tadebu, wagubu ke; “Apunu kawai mosi e wairai kawareya ka ripa damaya ika uburawa. E ripa ki madipana ki nana kawareya kawareya empiyawa ko ripa ki eba madipupu ko ururutanai uburawa. ");
INSERT INTO gdn_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Mara mosi ka e ubupu e wairai ki kwayubapiyawa apunai sibu, wagubu ke; ‘Nau kwamura apeya eyaka rabineya ripa yau madipana ki nana empekeya kwaepekeya ko e mibai eba kipu ki pokere karako ripa yau mei kaiyara. Ripa yau ka waira pa danapiyau.’ ");
INSERT INTO gdn_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","E inako wagubu ko e wairai ki kwayubapiyawa apunai denai inako wagubu ke; ‘Kabai, kamadamu da kwamura eyaka mena yau kewoyagisi were empamu. Nau mugu ripa kerareya nakapani demanapani da mibai kiroto bo pa mena ki nu ika kataigamu. ");
INSERT INTO gdn_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Ripa ki kwamura yabaranugu yau rabineya mibai kiroto ki ka baganai ko pa mena ki kau ewa sidi manako nau meyani kaiyara.’” ");
INSERT INTO gdn_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aiyata pa idiwana ki marai mosi ka Iyesu Diyu ragidai mu gurigurimaga tawai rabineya kabuwawagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Tawa ki rabineya ka ridi mosi ika mete tondawa ki kwamura ropani kawaya (18) ki rabineya keyai berokoi mosi e tagai wadubu korekore ki pokere kutokuto umawa. ");
INSERT INTO gdn_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Iyesu ridi ki empupu manako e bameya yabadana ki nana wagubu manako sibu, wagubu ke; “Ridi, kau sigiragi ki nau karako rikapakani da kau iyanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","E idai ridi ki kawareya tapu ki makeya ka ridi ki e tagai supasupawena bagi ubupu manako e Mamanuga God si tepapupu. ");
INSERT INTO gdn_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Iyesu aiyata pa idiwana marai ridi ki iyapupu ki pokere guriguri tawai ki debai apunai mosi e nuwai pupuwena manako e ubupu iyapana tadebu, wagubu ke; “Pura eyaka mena ki rabineya ka nu mara ida daikere kewo-wena daikere eyaka mena upigomu. Wi nuwagau iyaigamana wainapiyamu ki ka wi upi marai ki makeya baiwagi ko eba aiyata marai ki makeya baiwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","E inako wagubu ko nu Kaiwawo-nuga denai e sibu, wagubu ke; “Wi ka midiga pa matakawagau ragidai. Wi mete kina ka aiyata marai ki makeya upiwagamu. Wi papaga burumakau bo ‘donki’ ki wi aiyata marai ki makeya rikatamiyamu awana tageyamu bo pa mena? Ena, wi tageyamu. ");
INSERT INTO gdn_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Ridi yau e ka oragai apunai Eburamu e momai ko Berokoi Apunai Seitani kwamura ropani kawaya (18) ki rabineya e wadubu doko giripiyawa tondawa. Wi badidi pokere iwagamu da gwede e umapu dokodoko ki nu aiyata marai ki makeya eba rikapamu?” ");
INSERT INTO gdn_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Iyesu yona ki wagubu ki pokaiya ka e iyaraiyoma mu debamaga musupupu. Ko iyapana pakasi ragidai e bagi kawaya kuduba kwaewagawa ki emupu ka mu e mamamai tagamawa. ");
INSERT INTO gdn_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Iyesu iyapana manutapu, wagubu ke; “Mamanuga God e gari rabineya e kasiyarai pokaiya idiwana ki ka badidi maba? Ki keyakeyai nu gwede naureya iwagamu? ");
INSERT INTO gdn_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nau suwagani wainapu-muri; Ki ka ripa damaya madai rabineya momai rasirasi ki maba. Apunu mosi ka momai marai munta inako yadini uroto ki ka ripa kawaya mo wenayagisi ragai isiyapoto manako midiwari baitagisi ragai ki kawareya tawatagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Iyesu iyapana ade manutapu, wagubu ke; “Mamanuga God e gari rabineya e kasiyarai pokaiya idiwana ki badidi maba ki keyakeyai nau karako gwede naureya suwagani? ");
INSERT INTO gdn_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nau suwagani wainapumuri; Ki ka ridi mosi bani buredi kawayawagana domai marai munta mo wadau suguna mete wirapiyau manako suguna ki kawayawagau yarau ki maba.” ");
INSERT INTO gdn_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Iyesu natere Diyerusaremu yawateya kayawena kaniyawa ki ka e tawa tawa natere natere bauwagawa kabuwawagawa inako kwaewagawa kaniyawa, ");
INSERT INTO gdn_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","manako iyapana mosi e manupupu, wagubu ke; “Kaiwawoni, Mamanuga God e iyapana kuduba iya waunai tageni bo iyapana dai mena iya ki tageni?” E inako wagubu, ko Iyesu denai wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Kunuma katamurui ka kapokapori munta ki pokere kasiyara-iwagi nisi kandoi da wi katamuru ki teteiwagi. Nau nidiyani wainapumuri; Iyapana ropani kawaya katamuru ki tetetagamana kwaetogomono ko mu eba tetetagisi. ");
INSERT INTO gdn_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Mara baiyagisi da tawa apunai uburoto gudu umoroto manako wi tawa katamuruiya ubumuri gudu minimuri, iwagi ke; ‘Kaiwawonuga, kau gudu nu nene kwaipi da nu yamamu.’ Ko e denai yagisi ke; ‘Wi bani baigubu? Nau eba kataineya wiyo.’ ");
INSERT INTO gdn_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ko wi denai iwagi ke; ‘Nu bani yo awana kau mete ewapuru dibipemeya kupemeya ade kau ubureya nu imatanugu kabuwaniyeya.’ ");
INSERT INTO gdn_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ko e denai yagisi ke; ‘Wi bani baigubu? Nau eba kataineya wiyo. Wi ka berokoi kwaigamawa ragidai ki pokere kamadisinimuri kaiwagi.’ ");
INSERT INTO gdn_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Mara ki makeya ka wi yabu tamuri manako oragai apunai Eburamu yo Aisiki yo Diyaikapu ade Mamanuga God e bonanai wainapamawa tagamawa ragidai kuduba ki mete kina ika Mamanuga God e gari rabineya idiwono emitamuri. Nau suwagani wainapumuri; Mara ki makeya ka e uburoto gari tagaiya wi isiyaniyoto manako wi yadi wadoi wi uwariga meme kaikirapiyoi ‘ikui akui’ iwogoi. ");
INSERT INTO gdn_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Iyapana tawana tawana kuduba, madega kauwagau madega posiwagau ki deneya baitagisi Mamanuga God e gari rabineya kaiwoto kupe wateya wata yadini idiwono. ");
INSERT INTO gdn_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Mara ki makeya ka iyapana karako ewa ubumu ragidai ki mu yabiritagisi ade iyapana karako yabiri ubumu ragidai ki mu ka ewa ubumoto.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Mara ki makeya ka Parisi ragidai dai Iyesu bameya bautagubu, tagubu ke; “Apunu kawai Erodi kau nuniyana po wainapiyau ki pokere kau tawana yau kamadi kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Mu inako tagubu ko Iyesu denai mu tadebu, wagubu ke; “Wi kaiwagi taku kamarai apunai ki simuri, iwagi ke; ‘Kau wainapi; Nau karako ade marawani kweya kairapu iyapana rabinamugu idiwu ki siwakeketamoni ade sigira ragidai mete iyatamoni ko mara ki tetaiya ka nau upi ki kewopani.’ Wi kaiwagi e inako simuri, ");
INSERT INTO gdn_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","mibai ka karako, marawani ade mara ki tetaiya ka nau tawana tawana umoni da siyarai ka nau natere Diyerusaremu bausugani. Mu ubumoto Mamanuga God e bonanai wainapiyau wagau apunai natere kudubai mo rabineya minimoto poyo ki ka eba baganai. ");
INSERT INTO gdn_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Akae, natere Diyerusaremu, natere Diyerusaremu; Kau iyapanagiyoma ubumu Mamanuga God e bonanai wainapiyamu tagamu ragidai ki mu namutamiyamu ade e bigabigaiyoma kau bamageya tonotamiyau ki mu bowa were mete namutamiyamu. Kokoroku ridai e munuiyoma e mabui kobaiya sikwatamiyau ki maba ka nau mara badibadi taganugu kayawena nau idani rabineya wi idiwana wainapekeya ko wi nau bodabodasinimawa. ");
INSERT INTO gdn_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Wainapu-muri; Nau kamadiniyani kayasugani ki ka wi tawaga gumoroyagisi. Wi nau ewa mo eba emisinimuri ko wi idiwoi yamoi da wi iwagi ke; ‘Kaiwawonuga e si kasiyarai pokaiya baunugibi Apunai, Mamanuga God kau wadiniyoto bagi,’ wi inako sidimuri ki makeya ka wi nau ade emisinimuri.” ");
INSERT INTO gdn_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Aiyata pa idiwana marai mo bauwena ki makeya ka Iyesu Parisi ragidai mu kawaimaga mosi e tawaiya kupewagana kayawena. Iyapana ika dibimupu idiwa ki mu e naigida mena empamawa idiwa, ");
INSERT INTO gdn_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","manako ki makeya ka apunu mosi e idai kerarai kurukurupawena ika Iyesu bameya bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Iyesu wirawena Mamanuga God e gorai kataimugu ragidai ade Parisi ragidai mete kina ika idiwa ki manutapu, wagubu ke; “Karako ka aiyata marai ki pokere nau apunu yau iyapani ki nau gora raurupani bo?” ");
INSERT INTO gdn_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","E inako wagubu ko mu yona denai mo eba tagubu ki pokere e wirawena sigira apunai ki wadubu iyapupu manako tonopupu kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Ko Iyesu iyapana ki ade manutapu, wagubu ke; “Aiyata marai ki makeya wi munuga bo wi papaga mosi urubau kauyagisi ki ka wi sumuri e tainipumuri bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","E inako wagubu ko mu denai tagamana babatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Iyapana ropani kawaya ika kupe ki kawareya bautagubu ki mu kuduba nuwamugu ka kebari bagi kawareya idiwana kwaetagamawa ko mu tonau eba idiwana wainapamawa. Iyesu mu emitapu manako e keyakeyai yau mu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Apunu mosi anikawagana ki kupei nene wi bibiniyoto ki ka wi kebari bagi kawareya eba idiwuri kwaenda iyapana kawai mosi baiyagisi, ");
INSERT INTO gdn_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","manako kupe ki kwaewagau apunai wi nidiyoto, yagisi ke; ‘Wi riyaiwagi tonau idiwoi da apunu kawai yau kebari bagi ki kawareya tondini.’ E inako yagisi manako wi iyapana yabu-mugu riyaiwagi tonau idiwuri ki ka wi midimama wadiniyoto. ");
INSERT INTO gdn_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Ko nau karako wi nidiyani yau kwaiwagi; Iyapana mosi wi bibiniyoto ki ka wi naiya kaiwuri tonau idiwoi manako kupe kwaewagau apunai ki wi bamagau baiyagisi nidini, yagisi ke; ‘Edamani, kebomuri kebari bagi kawaya yau kawareya idiwuri.’ E inako yagisi banananiyoto ki ka iyapana ika mete idiwu ragidai wi eminimoto manako wi siga esida tepapomoto. ");
INSERT INTO gdn_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Nau nidiyani wainapumuri; Iyapana nima e ebo si tepapiyau ki ka aita ewa ka e kwarisiyagisi, ko iyapana nima e ebo kwarisiwena ki ka aita ewa ka e kawayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Iyesu inako wagubu manako wirawena kupe ki apunai sibu, wagubu ke; “Kau madegau bo kemorau tawiya mo kwaenuwagi ki kau kowagiyoma bo kau rakarakagiyoma bo purapura ragidai ki tawa madanigeya idiwu ki mu eba bibitami, mibai ka mu aita ewa kau kwaenugibi ki denai kwaetagisi kau bibinimoto. ");
INSERT INTO gdn_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Kau kupe mo kwaenuwagi ki kau iyapana kaikayokayoi, iyapana tagamaga kaikirai, iyapana idamaga kerapumaga kiyokiyoi bo badabadamai, ade iyapana yabumaga kenekenei, iyapana inako ki kau bibitami. ");
INSERT INTO gdn_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Kau inako kwaenuwagi ki ka Mamanuga God kau wadiniyoto bagi. Kau kwae-nugibi ki denai ka iyapana ki kau eba negeni, ko bagi supasupai mena kwae-tagamu ragidai ade iyatagamana kimana ubumana ki marai baiyagisi makeya ki kau denai bagi kawaya mo bananapi.” ");
INSERT INTO gdn_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Iyesu yona ki wagawa ka apunu mosi ika kupewagawa tondawa ki yona ki wainapupu manako e ubupu Iyesu sibu, wagubu ke; “Iyapana gwedewau kupe kawaya Mamanuga God e gari rabineya ki kawareya kupetogomono ki ka mu mibi mamamai idiwono.” ");
INSERT INTO gdn_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","E inako wagubu ko Iyesu denai wagubu ke; “Nau keyakeyai mo suwagani wainapumuri; Apunu mosi poraga kawaya mo kwaewagana ki okukunawena manako iyapana ropani kawaya e bameya bautagamana ki nana mu kabuwatapu. ");
INSERT INTO gdn_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","E okukunawena kewowena ka e bigabigai apunai mosi bibi tonopupu da e kayawagana iyapana bibitapu ragidai ki garugaru mena kebomana ki nana tadeni. ");
INSERT INTO gdn_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Bibi apunai ki kayawena iyapana tadeyawa umawa ko mu kuduba yona ewa nauwa tagamawa. Yabiri bameya bauwena apunai ki e wagubu ke; ‘Kabai, nau bausugana ko nau kokora mo wadubuwani ki empana ki nana kaya-sugani ki pokere nau poraga kawareya ika eba bausugani.’ ");
INSERT INTO gdn_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ade apunu mosi wagubu ke; ‘Kabai, nau bausugana ko nau burumakau ida daikere mena waunitau yewe tepuwani waira waunai kawareya nakatamana kayasugani ki pokere nau poraga kawareya ika eba bausugani.’ ");
INSERT INTO gdn_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Ade apunu mosi wagubu ke; ‘Nau bausugana ko nau waunitau yewe anikasugubuwani ki pokere nau poraga kawareya ika eba bausugani.’ ");
INSERT INTO gdn_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Bibitapu ragidai ki mu kuduba basaratagubu ki pokere bibi apunai ki ade wirawena bauwena iyapana badidi tagubu ki sisiyai kuduba poraga kwae-wagawa apunai ki sibu. E yona ki wainapupu ka e nuwai pupuwena manako e bibi apunai ki ade tonopupu, wagubu ke; ‘Kau garugaru mena kaya-nuwagi natere imatau bo kareya ubumu iwu ragidai, iyapana kaikayokayoi bo mu idamaga kerapumaga kiyokiyoi bo badabadamai bo mu yabumaga kenekenei ragidai ki inako waratami da mu poraga yau kawareya baitagisi.’ ");
INSERT INTO gdn_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Bibi apunai ki kayawena ade wirawena bauwena ka e poraga kwae-wagawa apunai ki sibu, wagubu ke; ‘Kabai, kau sidibi ki nau makeya makeya kwaesugubuwani iyapana waratapuwani bautagubu ko tawa eba posiwena ko wata ade uburau.’ ");
INSERT INTO gdn_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","E inako wagubu ki pokere apunu kawai ki bibi e ade tonopupu, wagubu ke; ‘Nau nuwaneya ka nau tawani yau posiyagisi ki pokere gari tagaiya mete kayanuwagi manako iyapana bani bani idiwu ki kau gigitami waratami baunuwagi. ");
INSERT INTO gdn_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Nau nidiyani wainapi; Iyapana naiya bibitapuwani ragidai ki mu mo eba baiyagisi nau banini yau siko kupoto. Ki pa mena.’” Iyesu keyakeyai ki wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Iyapana ropani kawaya Iyesu bananamupu mete kayatagubu kaiwa manako e wirawena mu emitapu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Iyapana nima nau ewaneya yabodono ki ka e nuwai notai nau mena bamaneya tondono. E inai mamai bo e wainai bo e munui-yoma bo e yowaiyoma tataiyoma bo e egapuiyoma bo e eya iyai mete kina ki nene kawaya daganani notapono ko nau maraitau notasiniyono ki ka e eba yabadini nau ewaneya kayayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Iyapana nima nuwaboya midi makari nau bananapani ki e mete bananapana ko e eya korosi maba ki e eba kawara-pana wainapiyau ko e kamadau, iyapana e kwaitana ki e eba yabadini nau ewaneya kayayagisi. Pa mena.” ");
INSERT INTO gdn_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Iyesu inako wagubu, ade tadebu, wagubu ke; “Wi mosi tawa kawaya mo wadana wainapiyau ki ka e yabiri kwarisiyagisi naigida mena notapoto, yagisi ke; ‘Bowa madai nau bamaneya uburau ki ka tawa yau kwaitana yadani kewopani ki denai maka yadini bo?’ ");
INSERT INTO gdn_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","E inako eba notapoto were kwaeyagisi ki ka e bani tawa bebedai mena nunuroto manako e bowai madai ki kewoyagisi. E tawa paunau kamadini ki ka iyapana e gwaigwitapomoto, tagisi ke; ");
INSERT INTO gdn_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","‘Apunu yau tawa wadana wainapiyawa ko e tawa wadawa da paunau kamadubu.’ ");
INSERT INTO gdn_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Nau keyakeyai mo ade nidiyani wainapumuri; Tawana mo kawaimaga uburana tawana mo kawaimaga mete kandetagamana wainapiyau ki ka e yabiri kwarisiyagisi naigida mena nota yadini were yawira kayayagisi. E notai yagisi ke; ‘Ta ragidai kuduba 10,000 nau bamaneya ko nau iyaraniyoma mu ka ropani kawaya 20,000 ki pokere nu kasiyaraigamu mu raurutamamu ki baganai bo?’ ");
INSERT INTO gdn_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","E wainapoto da ki eba baganai ki ka e iyaraiyoma kebomono makeya ki ka e dobo yonai garugaru mena tonopoto. ");
INSERT INTO gdn_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ki maba, wi mosi nuwagau nau ewaneya kebomana wainapiyamu ko wi wiga gwedegwedega bo wi wiga notaga kuduba ki wi eba kamadamana wainapiyamu ki ka wi kwaitana nau ewaneya eba kebomuri.” ");
INSERT INTO gdn_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Nau nidiyani wainapumuri; Aidaba ki ka gwede mosi midiyai bagi kawaya ko aidaba ki kwerereyagisi midiyai ki kewoyagisi ki ka wi badidi maba kwaiwagi da aidaba ki midiyai ade wenapoto? Ae, ki ka eba baganai. ");
INSERT INTO gdn_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Midiyai ki kewoyagisi ki ka wi aidaba ki wadumuri pa mugu kwenupumuri. Iyapana bani kokorau kawayawagana ki nana ni tepiyamu waira mete wira-piyamu ki ka baganai, kasiyarai mete kina. Ko aidaba midiyai pa mena ki ka pa mugu da deni mena kwenupamana ki nana. Wi wenaguga mete kina ki ka wi nau yonani yau suwagubuwani ki naigida mena wainapumuri wetawetara.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Mara mosi ka iyapana wairamaga denai takesi ki wadamawa ragidai ade iyapana tagararatampu ragidai mete kina Iyesu e yonai wainapamana ki nana e bameya ika bautagubu. ");
INSERT INTO gdn_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Mamanuga God e gorai kataimugu ragidai ade Parisi ragidai mete kina iyapana ki inako Iyesu bameya bautagubu emitampu ki ka mu ungwerogwerorotagubu, tagubu ke; “Apunu yau e ka iyapana bigibigi tagararatamemei ragidai ki mu diriwa-maga kwaewagau mete kupetagamu idiwu ki pokere e paerepiyau.” ");
INSERT INTO gdn_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Mu inako tagubu ki pokere Iyesu keyakeyai mosi mu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Wi paunagau iyapana mosi e papai-yoma sipi ropani kawaya (100) manako e eyaka mena yadini kaupoto ki ka e badidi kwaeyagisi? Nau nidiyani wainapumuri; E papaiyoma dai ki (99) ki e gwabau kamaditamini manako e kiroto uburoto papa eyaka mena wadubu kaupupu ki e kwaenei kaya-yagisi. ");
INSERT INTO gdn_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","E kwaenepono umono da bananapoto ki ka e mibi mamamai papa ki yadini e gobaiya kaupoto, ");
INSERT INTO gdn_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","manako kawarapoto e tawaiya ade kayayagisi. E tawau baiyagisi ki ka e kowaiyoma ade tawa e madaneya idiwu ragidai ki mu nene yagisi baitagisi manako tadeni, yagisi ke; ‘Nau papani sipi wadubuwani kaupuwani ki nau ade bananapuwani ki pokere kebomuri karako nau mete mamamaigamu.’” ");
INSERT INTO gdn_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Iyesu inako wagubu manako ade tadebu, wagubu ke; “Nau nidiyani wainapumuri; Nau keyakeyai yau suwagubuwani ki maba kunumau ka iyapana ropani kawaya (99) mu paeremaga pa mena ki mu nene ka Mamanuga God e aneyaiyoma mamamatagisi ko ki mamamai ka erida. Ko iyapana eyaka mena e berai berokoi kwaewagawa ki kamadini manako e notai wirayagisi ki ka mu e nene mamama kawaya esida wainapomoto.” ");
INSERT INTO gdn_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Iyesu mu ade tadebu, wagubu ke; “Ridi mosi e bameya bowa madai bauburai ida esida mena manako e eyaka mena yadini kaupoto ki ka e badidi kwaeyagisi? E duna beupoto tawa meme warawarayagono kwaenepono tondono. ");
INSERT INTO gdn_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","E bananapoto ki ka e kowaiyoma ade e tawa madaneya idiwu ragidai ki mu nene yagisi baitagisi, manako e uburoto mu tadeni, yagisi ke; ‘Nau bowani madai wadubuwani kaupuwani ki nau ade bananapuwani ki pokere kebomuri karako nau mete mamamaigamu.’” ");
INSERT INTO gdn_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Iyesu inako wagubu, ade wagubu ke; “Nau nidiyani wainapumuri; Nau keyakeyai yau suwagubuwani ki maba iyapana eyaka mena kwaitana e berai berokoi kwaewagawa ki kamadini e notai wirayagisi ki ka Mamanuga God e aneyaiyoma kunumau e nene kawaya daganani mamamatagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Iyesu mu ade tadebu, wagubu ke; “Apunu mosi e gubagaiyoma apeya, ");
INSERT INTO gdn_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","manako mara mosi ka e gubagai marai e bameya bauwena sibu, wagubu ke; ‘Mamai, kau buderigi purupi nau nene karako tege.’ E inako wagubu ki pokere apunu ki e wairai ade e gwedegwedei kuduba purupupu e gubagaiyoma apeya ki mu denemugu denemugu tagebu. ");
INSERT INTO gdn_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Mara dai kewowena eweya ka e gubagai marai ki ubupu e gwedegwedei kuduba ki tepupu manako kipu ubupu e mamai kamadubu tawana uwama kawaya mo kayawena. E ika tondawa ka e midi kwakwarepui tainipiyawa poisiyasiyai wainapiyawa kwaewagawa ki mena pokaiya bowa madai ki deni mena giripupu gawarara. ");
INSERT INTO gdn_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","E inako kwaewagawa tondawa yarawa da e gwedegwedei ade e bowai madai kuduba e bameya ki kewowena makeya ka kapoi kawaya mo tawana ki rabineya ubupu. Munu ki mibai wetei tondawa, ");
INSERT INTO gdn_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ki pokere e ubupu tawana ki apunai mosi bameya bagibagiwagana ki nana kayawena. Apunu ki e boiyoma baikamuwagana ki upi kwebu, ");
INSERT INTO gdn_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ko mu bani mo e eba kwemupu ki pokere e ika baikamuwagawa tondawa ka e bo mugumaga kabuma rabineya ki dai kupana wainapupu. ");
INSERT INTO gdn_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","E inako kwaewagawa nuwasiyasiya nene tondawa kaniyawa da siyareya ka nota supasupai e bameya ade bauwena. E notai wagubu ke; ‘Nau mamai e bigabigaiyoma mu digumamugu ka bani kawaya daganani posiwena uburau ko nau yewe mibi wetei tondakani posugana kwaesugakani. ");
INSERT INTO gdn_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Nau karako tawana yau kamadani wirasugani nau mamai bameya ade kayasugani manako siyani, suwagani ke; ‘Mamai, nau paerepuwani kawaya daganani. Kau bamageya ade Mamanuga God bameya ka nau bigi kwaesugekeya. ");
INSERT INTO gdn_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Nau naiya kau gubagagi sidibi ko karako nau paerepuwani ki pokere nau wadisini pa bigagi kwaesugana apunai sidi.’ ");
INSERT INTO gdn_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","E notai inako wagubu manako e kipu ubupu wirawena e mamai bameya ade kayawena. E kayawena kaniyawa da e mamai tawai ki kikireya bauwagana kwae-wagawa ki ka e mamai yabu tapu e gubagai buri yabadawa empupu manako e nuwaboyai wainapupu garupupu e bameya bauwena barabarapupu ade kiyauyaupupu. ");
INSERT INTO gdn_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ko e gubagai wagubu ke; ‘Mamai, nau paerepuwani kawaya daganani. Kau bamageya ade Mamanuga God bameya ka nau bigi kwaesugekeya. Kau naiya nau gubagagi sidibi ko karako nau paerepuwani ki pokere wadisini pa bigagi kwaesugana apunai sidi.’ ");
INSERT INTO gdn_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","E inako wagubu ko e mamai ubupu e bigabigaiyoma ragidai mu nene wagubu bautagubu manako tadebu, wagubu ke; ‘Wi garugaru mena kaiwagi gwedegwede bagibagi dai tepumuri nau gubagani monagapumuri. E idaiya katama nakapumuri ade e kerareya kerapu kwakwarai mete umamuri, ");
INSERT INTO gdn_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","manako kaiwuri papa buyaga kawaya mo minimuri poyo da nau gubagani bauwena ki nu mamamapamu kupe-igamu. ");
INSERT INTO gdn_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Nau gubagani yau powena ko e ade iyawena. E kwakowena ko karako ade wirawena bauwena.’ E mamai inako wagubu manako e gubagai nene kupe kawaya mo bagipupu. ");
INSERT INTO gdn_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Ki makeya ka e gubagai kawai kokorau upiwagawa umawa manako e wirawena yawatau yabadawa da tawa kikireya bauwagana kwaewagawa ki ka e iyapana kainagatagamawa ade taeretagamawa ki mumugarai waina-pupu. ");
INSERT INTO gdn_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","E bigabiga apunai mosi em-pupu manako manupupu, wagubu ke; ‘Mu gwede taerei taeretagamu?’ ");
INSERT INTO gdn_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Ko e denai wagubu ke; ‘Kau yowagi e midi kwakwarepui bagi kawaya ade wira-wena bauwena ki pokere e mamama-pamana ki nana ka kau mamagi papa buyaga kawaya mo minibu poyo.’ ");
INSERT INTO gdn_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","E yona ki wainapupu ka e gagaya-wena tawau eba yarana wainapupu ki pokere e mamai matarau bauwena e gubagai tawau yarana ki nana gigipupu. ");
INSERT INTO gdn_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Ko e gubagai ki e mamai inako sibu, wagubu ke; ‘Mamai, nau suwagani wainapi; Nau kwamura ropani kawaya kau umunugi wadekeya kau bigagi makeya makeya kwaesugekeya ko kau papa marai munta mo kwaitana eba wadibi tegebi da nau kowaniyoma mete mamamaigamana ki nana. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Ko kau gubagagi ki kau buderigi kuduba tepupu giripupu ridi yawata kawakawareya mu pokamugere isiya-pupu gawarara ki ade wirawena bau-wena ki kau e nene papa buyaga kawaya ki minibi poyo.’ ");
INSERT INTO gdn_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","E inako wagubu ko e mamai denai e sibu, wagubu ke; ‘Gubagani, kau ka maramara nau mete yewe idiwei ki pokere gwedegwede kuduba nau nene ki ka kau nene. ");
INSERT INTO gdn_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Ko nu kupe yau kwaigamu mamamaigamu ki mibai ka kau yowagi yau e ka powena maba ko e karako ade iyawena. E kwakowena ko karako ade wirawena bauwena.” Iyesu keyakeyai ki wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Iyesu e tadeyau kabukabuwa ragidai keyakeyai mo ade tadebu wagubu ke; “Purapura apunai mosi e bigabigai apunai upi kwebu da e gwedegwedei kuduba ki kwayubapana ki nana wagubu. Ki eweya mara mosi ka iyapana dai bautagubu purapura apunai ki simupu, tagubu ke; ‘Kau gwedegwedegi kwayubapiyau apunai ki e ka kau gwedegwedegi dai pa danapiyau.’ ");
INSERT INTO gdn_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Iyapana ki inako tagubu ki pokere apunu kawai ki e bigabigai apunai ki e nene wagubu bauwena manako sibu, wagubu ke; ‘Kau sisiyagi tagamu wainapakani ki mibai ka badidi? Kau upigi negebuwani ki nau karako kau koritaniyakani ade nau gwedegwedeni badibadi danapipi ki kawayai kau garugaru mena nau kabuwasini. ");
INSERT INTO gdn_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Gwedegwede kwayubapiyawa apunai yona ki wainapupu ka e notai wagubu ke; ‘Nau upi kwaesugekeya ki nau kawaini karako nau koritasiniyoto ki pokere nau badidi kwaesugani? Nau ka eba kasiyarani mete kina da nau diba kandani bo upi ragiragi kawaya mo inako kwaesugani. Ade nau pa tondoni genesugoni ki ka nau midimama wadisiniyoto. ");
INSERT INTO gdn_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ko nau badidi kwae-sugani ki nau karako wainapakani manako nau upi yau kamadani ki ka iyapana baitagisi nau waretasinimoto manako mu tawamugu tawamugu nau bibisinimono ade nau diriwani mete kwaetogomono.’ ");
INSERT INTO gdn_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","E inako notapupu manako ubupu iyapana gwedewau apunu kawai ki e gwedegwedei naiya sikwatagubu ragidai ki mu eyaka eyaka e bameya bautagamana ki nana wagubu. Mu bautagubu ka e ubupu yabiri bauwena apunai ki manupupu, wagubu ke; ‘Kau badibadi sikwanugibi?’ ");
INSERT INTO gdn_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Ko e denai wagubu ke; ‘Nau awana monamonai karakara ropani kawaya apunai ida daikere mena (100) ki sikwasugubuwani.’ Ko gwedegwede kwayubapiyawa apunai denai wagubu ke; ‘Pa mena, kau sikwanugibi ki okai kau karako wadi kwarisi manako apunai apeya ade ida esida mena (50) ki mena tari.’ ");
INSERT INTO gdn_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ki eweya ka e wirawena apunu ade mosi manupupu, wagubu ke; ‘Ade kau ka badibadi sikwanugibi?’ Ko e denai wagubu ke; ‘Nau gwaba madai baike ropani kawaya (1000) ki sikwasugubuwani.’ E inako wagubu ko gwedegwede kwayubapiyawa apunai ki denai e sibu, wagubu ke; ‘Kau sikwanugibi ki okai kau karako wadi kwarisi manako maraitau (800) ki mena tari.’” ");
INSERT INTO gdn_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Iyesu keyakeyai ki wagubu kewo-wena ka e iyapana ade tadebu, wagubu ke; “Kwayuba siyasiyawagawa apunai e upi kewowagana ki eweya e badidi maba tondana ki nene mete notapiyawa ki pokere apunu kawai ki e eba nakari-pupu ko e empupu manako baganai sibu.” Iyesu inako wagubu manako ade wagubu ke; “Waira yau notai wadamu doko ragidai badidi maba waira yau gwedegwedei pokaiya mu kowamuguma mete deni deni waita kasiwaratagamana idiwana ki notai maramara notapiyamu ki maba ka Mamanuga God e tanai mu rabinamugu minibu siwa ragidai iya aita ewa nene ki inako maba mete notampibena, ko mu kawaya daganani inako eba notapiyamu. ");
INSERT INTO gdn_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Nau nidiyani wainapumuri; Wi waira yau e gwede-gwedei pokaiya iyapana waretatamuri da wi waira yau e gwedegwedei mete kina kamaditamana marai baiyagisi ki ka mu kunumau wi mamamanimoto manako wi iya maramara idiwana kaiwana tawanai ki rabineya mibi mamamai posiwagi. ");
INSERT INTO gdn_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Iyapana gwedewau gwede maraitau wadumupu ki naigida mena kwayubapomoto ki ka mu aita ewa gwede kawaya mo yadini ki mete naigida mena kwayubapomoto. Ko iyapana gwedewau gwede maraitau wadumupu ki kwayuba siyasiyapomoto ki ka mu aita ewa gwede kawaya mo yadini ki mete kwayuba siyasiyapomoto. ");
INSERT INTO gdn_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Kau nima waira yau e gwedegwedei naigida eba kwayubapiyei ki ka kau keyaigi ki puyoi badidi maba kwayubapi? ");
INSERT INTO gdn_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Ade kau nima iyapana mosi e gwedegwedei naigida eba kwayubapiyei ki ka kau kiya gwedegwedegi badidi maba kwayubapi? Ki pa mena ki pokere kau gwede bagi mo eba wadi. ");
INSERT INTO gdn_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Bigabiga kwaewagau apunai ki e kawakawaiyoma apeya ki ka e badidi maba mo yogono e umunui yodono ade wirayogono mo yogono e umunui yodono? Ki pa mena, mibai ka e uburono mosi nota kwarikwarisipono ko mosi keipono ade uburono mosi e diriwai kwaeyogono ko mosi tagararapono. Ki maba, wi Mamanuga God e nene waina-piyoi ki ka wi waira yau gwedegwedei notagogapumuri. Ko wi waira yau gwedegwedei nene wainapiyoi idiwoi ki ka wi Mamanuga God notagogapumuri.” ");
INSERT INTO gdn_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Parisi ragidai mu notamaga ka bowa madai kawareya ukwarawa ki pokere Iyesu waira yau gwedegwedei ki sisiyai inako wagubu wainamupu ki ka mu e gwaigwitamupu ade mu madagura-maga e bameya memupu. ");
INSERT INTO gdn_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Ko Iyesu tadebu, wagubu ke; “Wi ka iyapana yabumugu midiga pa matakawagau, ko wainapumuri; Mamanuga God e ka wi nuwaga notaga ki e empiyau. Gwede-gwede marai kawai ki iyapana waina-piyamu da ki ka kawakawaya ki ka Mamanuga God e yabuiya ki mibai ka pa mena. ");
INSERT INTO gdn_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Gora oragai ade Mamanuga God e bonanai wainapamawa tagamawa ragidai oka badidi tamupu ki kuduba tondawa yabadawa da iyapana siruwa-tamiyawa apunai Diyoni bauwena makeya. Ko ki eweya ka Mamanuga God e gari rabineya kaiwana idiwana ki yonai bagi kawaya ki mena ka iyapana wainapamana wainapiyamu. Iyapana kuduba gari ki rabineya kaiwana ki nana nisi kandamu, ");
INSERT INTO gdn_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ko nau nidiyani wainapumuri; Iyapana badidi maba idiwana ki gorai ka wateya tondau. Kunuma yo waira gogawagana ki ka matarau ko iyapana gora ki wirapamana e okai marai munta mo surupamana ki ka ragiragi kawaya. ");
INSERT INTO gdn_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Apunu mosi e wainai ragipoto manako ridi mo ade uworoto ki ka e wainai naiya ki rauru kawakawarapupu. Ade apunu mosi ridi wakeyara mo uworoto ki ka ridi ki e nobomoi yabiri ki e rauru kawakawarapupu.” ");
INSERT INTO gdn_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Iyesu mu ade tadebu, wagubu ke; “Mara mosi ka purapura apunai mosi tondawa ki maramara e gwedegwedei bagibagi mena monagawagawa ade bani bagibagi ki mena kupawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Apunu ki e tawai ki katamuruiya ka iyapana apunu mosi si ka Yasarusi ki mideya kwata mena posiwena uburawa ki wadumpu ika tampu manako e bani nene ika genewagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Purapura apunai bani kupawa ki pirai gwetagamawa ki ka apunu Yasarusi bani mugui ki kupana wainapiyawa. Taku bautagamawa e kwatai ki remoremopamawa. ");
INSERT INTO gdn_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Mara mosi ka nuwasiyasiya nene tondawa apunai ki e powena manako aneya kunuma were kawampu e wadumpu oragai apunai Eburamu e madaneya kunumau tamupu. Purapura apunai ki e mete powena manako iyapana e wadumupu ononomupu. ");
INSERT INTO gdn_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","E popai ragidai mu watamugu bauwena ki ka e bita yo midi makari kawaya ika bananapupu manako e yabu tapu apunu Yasarusi usi oragai apunai Eburamu e idai garu deneya uwamau ika bagi kawaya tondawa empupu, ");
INSERT INTO gdn_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ki ka e bonanai ragiragi kawaya wena siyapu, wagubu ke; ‘Mamai Eburamu, kau nau nene wainapiyei bo pa mena? Nau mata yau nonareya midi makari kawaya daganani bananapuwani ki pokere apunu Yasarusi siyo da e idai gurai awanau kaupoto kaworoto nau tenawarineya taroto da nau sinamuni pikapoto.’ ");
INSERT INTO gdn_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Apunu ki inako wagubu, ko oragai apunai Eburamu denai e sibu, wagubu ke; ‘Gubagani, nau yonani yau suwagani wainapi; Kau naiya iyaiya tondeya makeya ki kau gwedegwede kuduba bagi mena ki kawareya tondeya ko apunu Yasarusi e ka mugu ki mena kawareya tondawa. Karako ka e yewe mamamayogono tondono ko kau ika makarinugowa tondowa. ");
INSERT INTO gdn_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Nau yona yau mete nidiyani wainapi; Kau yo nu paunanugu ka uruba kawaya. Iyapana mosi nu mete yewe idiwei ki uruba kawaya ki raurupana kau bamageya bauwagana ki yawatai mo pa mena. Ade iyapana mosi kau bamageya mete idiwu ki uruba kawaya raurupana nu bamanugu bauwagana ki mete yawatai mo pa mena.’ Oragai apunai Eburamu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Purapura apunai yona ki waina-pupu ka e denai wagubu ke; ‘Akae, Mamai Eburamu, kau nau nene waina-piyei ki kau apunu Yasarusi tonopi da e nau mamai e tawaiya kayayagisi, ");
INSERT INTO gdn_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","manako nau yowaniyoma ida daikere mena ika idiwu ki tadeni da nau paerepuwani ki denai makari tawaneya yewe bausugubuwani ki mu mete inako eba paerepomoto kwaenda mu mete kina yewe baitagisi berokoi kawaya yau bananapomoto.’ ");
INSERT INTO gdn_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Apunu ki inako wagubu ko oragai apunai Eburamu denai e sibu, wagubu ke; ‘Ae, pa mena. Oragai apunai Mosisi ade Mamanuga God e bonanai waina-pamawa tagamawa ragidai oka badidi tamupu ki kuduba mu bamamugu uburau ki pokere mu yona ki mena wainapomono.’ ");
INSERT INTO gdn_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Ko purapura apunai ki wagubu ke; ‘Ae, mamai Eburamu, yona ki mena pokaiya ka mu notamaga eba wirayagisi. Ko iyapana mosi powena ki iyayagisi ade kiroto uburoto manako yona ki tadeni ki ka mu e bonanai waina-pomoto manako mu bigimaga ki mu kamadini notamaga wirayagisi.’ ");
INSERT INTO gdn_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Apunu ki inako wagubu ko oragai apunai Eburamu denai e sibu, wagubu ke; ‘Mu oragai apunai Mosisi ade Mamanuga God e bonanai waina-pamawa tagamawa ragidai badidi tagubu ki eba wainapomoto suma-pomoto ki ka mu badidi maba iyapana mosi powena ko ade iyayagisi kiroto uburoto ki e yonai wainapomoto sumapomoto? Ki pa mena.’” Iyesu keyakeyai ki iyapana tadebu. ");
INSERT INTO gdn_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Iyesu e tadeyau kabukabuwa ragidai yona yau tadebu, wagubu ke; “Gwedegwede marai kawai iyapana pisipisitamini da mu paerepomoto bigi kwaetagisi ko iyapana nima e waretai ki e kerareya wadau da e bigi kwaewagau ki ka aita ewa ka e bita kawaya mo bananapoto. ");
INSERT INTO gdn_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Akae, iyapana bowa bisi kawaya mo wadumpena taburuba pokaiya kwimpena iyapana ki e gobaiya umampena manako egi rabineya kwenumpena ki ka e nene baganai. Iyapana nima munu marai munta mosi e kerareya wadau manako munu ki bigi kwaewagau ki denai ka iyapana ki aita bita kawaya esida bananapoto. ");
INSERT INTO gdn_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Ki pokere wi yabu yabu idiwoi. Wi yowaga bo wi tataga gwede mo paerepoto bigi kwaeyagisi ki ka wi e nakaripumuri. Ko e bigi kwaewena ki kamadini e notai wirayagisi ki ka wi e badidi paerepupu ki wi notagau deni mena surupumuri. ");
INSERT INTO gdn_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Ena, nau nidiyani wainapumuri; E mara eyaka mena ki rabineya wi bamagau bigi kawareya kawareya ida daikere kewowena daikere apeya (7) ki kwaeyagisi ko ade mara ki rabineya ida daikere kewowena daikere apeya (7) ki wirayagisi wi bamagau yagisi ke; ‘Nau paerepuwani ki nau karako deni mena kamadakani’, e inako yagisi ki ka wi e bigi badidi kwaewena ki wi notagau deni mena surupumuri.” ");
INSERT INTO gdn_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Iyesu tonotapu ragidai e simupu, tagubu ke; “Kaiwawonuga, kau nu sumanuga wadi kawaya.” ");
INSERT INTO gdn_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Mu inako tagubu ko e denai mu tadebu, wagubu ke; “Nau nidiyani wainapumuri; Ripa damaya madai ki bonai rabineya ka rasirasi. Wi sumaga marai munta ki maba nau sumasinimuri ki ka wi ripa kauma yau simuri, iwagi ke; ‘Kau kiya siwanuwagi kayanuwagi egi rabineya wenanuwagi,’ wi inako iwagi ki ka ripa ki wi umunuga yadini kayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Iyesu ade wagubu ke; “Apunu kawai mosi e bigabigai apunai kokorau diba kandono bo papa sipi kwayuba-tamono da madega bigayagisi manako e tawau baiyagisi ki ka apunu kawai ki e eba paraupoto, yagisi ke; ‘Kau garugaru yabi aiyatanuwagi manako nau bani warapuwani yau kupi.’ E inako eba yagisi, ");
INSERT INTO gdn_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ko e yagisi ke; ‘Kau kayanuwagi siruwanuwagi monaganuwagi manako nau tawiyani kwaenuwagi tege kupani were ewa ka kau kiya kupenuwagi.’ ");
INSERT INTO gdn_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Bigabiga apunai e upi ka biga mena ki pokere wi badidi wainapiyamu; Apunu kawai uburoto e bigabigai apunai upi kwaewena ki denai paraupoto bo? Ae, pa mena. ");
INSERT INTO gdn_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ki maba, nau nidibuwani ki wi makeya makeya kwaiwogoi da kewoyagisi ki ka wi inako mena iwagi ke; “Nu ka pa bigabiga ragidai. E nu kwaiwagamana nidibu ki mena nu makeya makeya kwaigibi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Iyesu natere Diyerusaremu kaya-wena kaniyawa da tawana Sameriya yo tawana Gariri paunau ika bauwena kaniyawa, ");
INSERT INTO gdn_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ki ka e natere mo bau-wena. Ika bauwena ka e iyapana ida esida mena sigira berokoi mo wadumpu kwakwarepumaga kwatakwatatagubu ki ika kebomawa bananatapu. Mu Iyesu bameya eba kaimupu ko uwamau buri mu mubo mubo ubumawa, ");
INSERT INTO gdn_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","manako mu bonanamaga ragiragi kawaya Iyesu wenawenamupu, tagubu ke; “Kaiwawo-nuga Iyesu, kau nu nene wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Mu inako tagubu manako Iyesu mu emitapu tadebu, wagubu ke; “Baganai, Mamamanuga God e bameya dobopiyamu ragidai mu bamamugu kaiwagi da mu wi kwakwarepuga empomoto.” E inako wagubu manako mu kayatagubu kaiwa da yawatau ka mu sigiramaga ki deni mena kewowena. ");
INSERT INTO gdn_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Apunu ki mosi ika kaniyawa da e sigirai kewowena ki wainapupu ki ka e mamamawena manako wirawena e bonanai ragiragi kawaya Mamanuga God e si tepapiyawa yabadawa da Iyesu bameya bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","E ika bauwena ka e Iyesu yabareya kwarisiwena manako e iyawena ki denai paraupupu. Apunu ki ka tawana Sameriya mu iyapanamaga mosi. ");
INSERT INTO gdn_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","18","Ko Iyesu iyapana manutapu, wagubu ke; “Nau iyapana sigiratagubu ragidai ida esida iyatapuwani ko badidi pokere ka iyapana kwaiyanai apunai yau e mena wirawena Mamanuga God paraupiyau? E kowaiyoma ida daikere kewowena daikere apeya apeya (9) ki mu mete bautagumpena Mamanuga God e si tepampena.” ");
INSERT INTO gdn_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Iyesu inako wagubu manako wirawena iyawena apunai ki empupu sibu, wagubu ke; “Baganai, kau kiri uburi kayanuwagi. Kau nau sumasinibi ki pokere kau iyanugibi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Parisi ragidai dai Iyesu manu-mupu, tagubu ke; “Nu Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki marai ka gwede mara baiyagisi?” Mu inako tagubu ko e denai tadebu, wagubu ke; “Mamanuga God e gari rabineya idiwana marai ki baiyagisi ki ka eba matarau baiyagisi da wi yabugere empumuri. ");
INSERT INTO gdn_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Iyapana mo eba yagisi ke; ‘Empumuri, e yewe bauwena tondau’, bo yagisi ke; ‘Empumuri, e burida bauwena tondau.’ Mu inako eba tagisi mibai ka Mamanuga God e gari rabineya e kasiyarai pokaiya idiwana ki kasiyarai ororeya mena bauwena wi rabinagau uburau.” ");
INSERT INTO gdn_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Iyesu inako wagubu manako wirawena e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Mara baiyagisi da wi ubumuri nau Kunumau Kawapuwani Apunai nau marani empamana ki nana wainapiyoi ko wi eba empumuri. ");
INSERT INTO gdn_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Iyapana dai baitagisi wi nidini, tagisi ke; ‘Empumuri, e burida bauwena tondau’, bo tagisi ke; ‘Empumuri, e yewe bauwena tondau.’ Mu inako togomono ki ka wi notaga pakarayagisi mu ewamugu kwaene igida yauda eba yabu tamiyoi iwoi. ");
INSERT INTO gdn_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Yangwara wadau kunuma kuduba miniyau siwa ki maba nau Kunumau Kawapuwani Apunai nau marani baiyagisi ki ka iyapana kuduba ki maba nau emisinimoto. ");
INSERT INTO gdn_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Ko yabiri ka nau nuwaboya ade bita makari kawaya daganani bananapani. Iyapana karako idiwu ragidai ki mu ubumoto nau keisinimoto ade midi ragiragisinimoto. ");
INSERT INTO gdn_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Iyapana oragai apunai Nowa tondawa makeya badidi kwaetagamawa ki maba nau Kunumau Kawapuwani Apunai ade wirasugani bausugani makeya ka iyapana inako ade kwae-tagisi. ");
INSERT INTO gdn_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Awana goya kawaya ki eba bauwena makeya ka iyapana bani kupamawa awana kubamawa ade anikatagamawa petemuguma apunu tauwamawa. Mu inako kwaetagamawa kebomawa da apunu Nowa waka ki kawareya yapu posiwena makeya ka goya kawaya ki bauwena iyapana kuduba bibiyotapu gawarara. ");
INSERT INTO gdn_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Ade oragai apunai Rote tondawa makeya iyapana badidi kwaetagamawa idiwa ki maba ka iyapana mara ki baiyagisi makeya inako mete kwae-tagisi. Mu bani kupamawa awana kubamawa deni deni nida kasiwara-tagamawa upitagamawa ade tawa-tagamawa. ");
INSERT INTO gdn_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Mu inako kwaetagamawa yamawa da apunu Rote natere Sodomu kamadubu kayawena ki makeya ka mata nonarai gwisi berokoi mete kina kunumau kawapu mu uratapu popo-tagubu gawarara. ");
INSERT INTO gdn_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Iyapana naiya inako wakapa giritagubu ki maba ka nau Kunumau Kawapuwani Apunai ade wirasugani bausugani marai baiyagisi ki ka iyapana inako mete kwaetagisi. ");
INSERT INTO gdn_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Mara ki baiyagisi ki ka iyapana mosi tawa tagaiya tondau ki ka e gwedegwedei tawa rabineya kamadubu ki tepana kai eba suroto, ade iyapana mosi kokorau upiwagau ki ka e eba wirayagisi e tawaiya kayayagisi. Pa mena. ");
INSERT INTO gdn_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Oragai apunai Rote e wainai bameya badidi wenawena ki wi naigida mena wainapumuri. ");
INSERT INTO gdn_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Iyapana nima e eya iyai karako yewe wairau ki nene wainapiyau ki ka e eya iyai aita ewa nene ki e kaupiyau. Ko iyapana nima nau pokanere e eya iyai karako yewe wairau ki kaupiyau ki ka e eya iyai aita ewa nene ki e yadini. ");
INSERT INTO gdn_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Nau nidiyani wainapumuri; Kemora ki rabineya ka iyapana apeya kebari eyaka mena kawareya ukwopomono manako nau eyaka mena yadani ko mosi kamadani. ");
INSERT INTO gdn_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","36","Ade mara ki makeya ka ridi apeya ripa madai musupomono idiwono manako nau eyaka mena yadani ko mosi kamadani.” ");
INSERT INTO gdn_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Iyesu yona ki wagubu ka e tadeyau kabukabuwa ragidai e manu-mupu, tagubu ke; “Kaiwawonuga, kau nuwagibi ki bani wenayagisi?” Ko e denai wagubu ke; “Nau waigugu yau suwagani ki wi wainapumuri; Gwede mosi powena e kwakwarepui ika ukwarau ki ka midiwari kusuketa e kwakwarepui ki kupamana ki nana ika mete dibipomoto.” ");
INSERT INTO gdn_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Iyesu e tadeyau kabukabuwa ragidai mu notamaga eba kauwagana ko maramara Mamanuga God bameya guriguritagamana ki nana ka e keyakeyai yau mu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“Natere mo rabineya ka wade supasupa apunai mo tondawa ki Mamanuga God eba mayapiyawa ade iyapana mete eba wiwiratamiyawa. ");
INSERT INTO gdn_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Natere ki rabineya ka ridi koboro mosi mete ika tondawa ki maramara wade supasupa apunai ki e bameya bau-wagawa siyawa, wagawa ke; ‘Nau iyarani mosi nau girisiniyana ki nana kwaewagau ki pokere waitasini berokoi yau kuduba kau wade supasupapi.’ ");
INSERT INTO gdn_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Mara ropani kawaya ka wade supasupa apunai ridi ki e bonanai eba wainapiyawa ko siyareya ka e notai wagubu ke; ‘Nau Mamanuga God e kudeya eba wainapakani ade iyapana mu umunumaga mete eba wadakani, ");
INSERT INTO gdn_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ko ridi koboro yau e ka maramara nau waweresiniyau ki pokere nau e waita-pani e nuwaboyai ki wade supasupa-pani. Nau ki eba kwaesugani ki ka e maramara nau waweresiniyono tondono da nau midini togayagisi.’” ");
INSERT INTO gdn_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Nu Kaiwawonuga keyakeyai ki wagubu manako ade tadebu, wagubu ke; “Wade supasupa apunai eba bagi ki e badidi wagubu ki wi naigida mena wainapiyoi. ");
INSERT INTO gdn_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ko ade wainapumuri; Mamanuga God e eya iyapanaiyoma maramara kemora nawaru e bameya waita nene guriguritogomono ki ka e mu waitatamini ade mu nuwaboyamaga wade supasupapoto bo pa mena? E mu garugaru waitatamini bo eba garugaru waitatamini? ");
INSERT INTO gdn_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Nau nidiyani wainapu-muri; E garugaru mena mu waitatamini ade mu nuwaboyamaga garugaru mena yadini supasupa. Ko nau Kunumau Kawapuwani Apunai ade wirasugana bausugana ki marai baiyagisi makeya ki ka nau suma ragidai yewe wairau mete bananatamani bo?” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Iyapana dai wainamupu da mu muga ka baganai ki pokere mu muga simaga tepapamawa ade kowamuguma mu simaga kaupamawa ki mu nene ka Iyesu keyakeyai yau wagubu. E wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Mara mosi ka iyapana apeya Mamanuga God e Tawai rabineya guriguritagamana ki nana kayatagubu. Apunu ki mosi ka Parisi apunai ade mosi ka iyapana wairamaga denai takesi ki wadawa apunai. ");
INSERT INTO gdn_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Parisi apunai ki wata mo e ebo mena ubupu manako Mamanuga God bameya guriguri inako wagubu ke; ‘Mamai God, iyapana supasupai mo nau maba pa mena ki pokere nau parau-niyakani kawaya daganani. Nau ka eba iyapana kuduba kwaetagamu ki maba kwaesugakani. Nau ka eba kapokapoi, nau ka eba beraberai, nau ka eba sipuma goragora rauru kawakawarasugakani. Nau parauniyakani da nau ka eba takesi wadau apunai buri ki e maba. ");
INSERT INTO gdn_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Pura eyaka mena ki rabineya ka nau mara apeya kau nene bani kamadakani ade nau gwedegwedeni damupakani ida esida ki damu eyaka mena ki nau kau nene tarakani.’ E inako guriguriwena. ");
INSERT INTO gdn_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Takesi wadawa apunai ki e ka mibi nuwaboyai digumau uburawa midimama diyayai e gobai kaupupu manako giyansugiyansu mena inako guriguriwena, wagubu ke; ‘Mamai God, nau ka berokoi bigibigi ki pokere nau nuwaboyani ki kau wainapi waitasini.’” ");
INSERT INTO gdn_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Iyesu keyakeyai ki wagubu manako ade wagubu ke; “Nau nidiyani wainapumuri; Mamanuga God e ka takesi wadawa apunai ki e bigi empupu deni mena surupupu ki pokere Mama-nuga God e yabuiya ka apunu ki supasupai bagi kawaya wirawena e tawaiya kayawena. Ko apunu ki mosi e guriguri ki e eba mibipupu mibai ka iyapana nima e eya si tepapiyau ki ka aita ewa e kwarisiyagisi ko iyapana nima e eya si kaupiyau ki ka aita ewa e kawayayagisi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Iyapana dai ki mu munumuguma wawayai temupu kebompu Iyesu bameya bautagubu e idai mu debamugu tarana ki nana. E tadeyau kabukabuwa ragidai iyapana ki emitampu nakari-tampu, ");
INSERT INTO gdn_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ko Iyesu munu rasi ki e bameya bautagamana ki nana wagubu manako iyapana tadebu, wagubu ke; “Munu rasi nau bamaneya kebomono ki wi mu yawatamaga eba bodapiyoi. Munu yau kwaitana ki mu ka nau Mamai God e gari rabineya e kasiyarai pokaiya kaiwoto idiwono. ");
INSERT INTO gdn_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Nau yona yau suwagani ki wi notaga eba goga-yagisi; Iyapana kawakawai wi notaga munu rasi mu notamaga maba ki ka wi Mamanuga God bameya kaiwuri e gari rabineya bagi kawaya idiwoi. Ko wi notaga eba munu rasi mu notamaga maba ki ka wi e bameya eba kaiwuri ade e gari rabineya eba idiwoi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Diyu ragidai mu kawaimaga mosi Iyesu bameya bauwena manako manu-pupu, wagubu ke; “Sidiyei Kabukabuwa Apunai Bagi, nau badidi kwaesugani da nau iya maramara tondana kaniyana ki iyai bananapani?” ");
INSERT INTO gdn_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Apunu ki inako wagubu ko Iyesu denai e sibu, wagubu ke; “Kau gwede nana nau apunu bagi sidibi? Mamanuga God e mena ka bagi. ");
INSERT INTO gdn_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ko kau manu-sinibi ki denai nau nidiyani; Mamanuga God e gorai oka tampu ki kuduba kau kataigeya; ‘Kau waretagi eba raurupi e wainai eba wadi; Iyapana mo eba mini poyo; Gwedegwede mo eba kuwa-nuwagi; Kau waretagi badidi kwaewena empipi ki kau bera eba nuwagi; Kau inagi mamagi tagubu ki mu umunumaga wadi naigida mena wiwiratami.” ");
INSERT INTO gdn_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Iyesu inako wagubu ko apunu ki, wagubu ke; “Nau munu marai munta tondekeya makeya ki ka Mamanuga God e gorai tapu ki kuduba nau naigida mena wiwirapekeya tondekeya da karako kawayasugubuwani.” ");
INSERT INTO gdn_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","E yona wagubu ki Iyesu waina-pupu manako e apunu ki empupu denai yona yau sibu, wagubu ke; “Kau gwede mo eyaka mena yau mete kwaenuwagi; Kau kayanuwagi kau gwedegwedegi kuduba tepi iyapana gwedegwedemaga pa mena imagei ragidai tage manako ewa yabi nau ewaneya uburi. Kau inako kwaenuwagi ki kau denai bagi kawaya mosi aita ewa kunumau bananapi.” ");
INSERT INTO gdn_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Apunu ki e gwedegwedei ka ropani kawaya ki pokere e Iyesu yonai ki wainapupu ka e nuwaboyawena. ");
INSERT INTO gdn_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Iyesu apunu ki nuwaboyawena empupu manako wagubu ke; “Iyapana gwedegwedemaga ropani kawaya ragidai mu Mamanuga God e umunui wadamana sumapamana ade e gari rabineya kaiwana idiwana ki ka ragiragi kawaya. ");
INSERT INTO gdn_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Yawata ki katamurui ka tainugu umunai ki maba. Papa kawaya kameru kwaitana tainugu umunai teyagisi ki ka e daikere eba baiyagisi kayayagisi mibai ka tainugu umunai ka marai munta ko papa ki ka kawaya. Ko nau ade suwagani wainapumuri; Papa kameru ki tainugu umunai teyagisi ki ka ade matarau ko iyapana mu gwede-gwedemaga ropani kawaya ragidai ubumana Mamanuga God sumapamana manako e gari rabineya kaiwana idiwana ki ka ragiragi kawaya.” ");
INSERT INTO gdn_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Iyapana yona ki wainamupu ka mu Iyesu manumupu, tagubu ke; “Akae, ki inako ki ka nima kwaitana iya yadini?” ");
INSERT INTO gdn_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Mu inako tagubu, ko Iyesu denai mu tadebu, wagubu ke; “Iyapana wi wiga mena iya ki eba wadamana makai ko Mamanuga God badidi yagisi ki e umuneya ka gwedegwede kuduba wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Apunu Pita yona ki wainapupu ka e denai wagubu ke; “Kau wainapi, nu ka tawanuga kuduba kamadimpi kau ewageya kaigibi.” ");
INSERT INTO gdn_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Ko Iyesu denai e sibu, wagubu ke; “Ena, kau yona mibai nuwegei. Nau karako suwagani ki wi wainapumuri; Iyapana gwedewau Mamanuga God e gari rabineya idiwana ki yonai iyapana tademana ki nana wi tawaga bo wi wainaguma bo wi yowaguma tataguma bo wi inaguma mamaguma bo wi munuguma inako ki kuduba kamadita-muri manako kaiwagi tawana mo idiwoi, ");
INSERT INTO gdn_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ki ka denai wi tawaga ropani-yagisi ade iyapana ropani kawaya wi inamamatamuri yowatatatamuri idiwoi. Ade mara waunai baiyagisi makeya ki ka wi iya maramara idiwana kaiwana ki iyai mete wadumuri.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya ki mu nene wagubu waratapu mu mubo mena idiwa manako tadebu, wagubu ke; “Nu karako natere Diyeru-saremu kaigamu ki ka Mamanuga God e bonanai wainapamawa tagamawa ragidai takari kawaya nau Kunumau Kawapuwani Apunai nau yonani badidi okamupu ki kuduba makeya makeya wenayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Iyapana nau wadisini-moto iyapana kwaiyanai ragidai mu idimaga rabineya nau tamusinimoto manako mu ubumoto nau waegeya-geyamasinimoto, wereyakaurasinimoto ade tepoteposinimoto. ");
INSERT INTO gdn_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Mu nau kuwe pokaiya raukekesinimoto manako susinimoto poyo. Nau posugani ko mara apeya eyaka kewoyagisi eweya ki nau ade iyasugani kirani uburani.” ");
INSERT INTO gdn_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Iyesu inako wagubu ko e tadeyau kabukabuwa ragidai e yonai ki mibai eba wainamupu. E yonai wagubu ki ka gwede mosi mu notamaga utapupu diyayai. Mu mibai eba wainamupu ki pokere e badidi wagubu ki mu baba-tagubu. ");
INSERT INTO gdn_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Iyesu natere Diyeriko kikirau bauwagana kwaewagawa ka apunu mosi e yabui kenewena ika yawata kwaiya bowa madai nene genewagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","E iyapana ropani kawaya ika kebomawa mu ratabamaga waina-pupu ki pokere e iyapana dai manutapu, wagubu ke; “Yau ka gwede ratabai wagau?” ");
INSERT INTO gdn_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Ko mu denai tagubu ke; “Ki ka tawana Nasareta apunai Iyesu e yabadau.” ");
INSERT INTO gdn_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Apunu ki yona ki wainapupu ka e bonanai ragiragi kawaya wena siyapu, wagubu ke; “Iyesu, oragai apunai Dewida e wenai, kau nau nene wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","E inako wagubu ki ka iyapana e yabareya ika ubumawa ki e nakarimupu yona kamadana ki nana simupu ko e bonanai ragiragi kawaya kawareya kawareya ade wena siyanawa, wagawa ke; “Oragai apunai Dewida e wenai, kau nau nene wainapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Iyesu yona ki wainapupu ka e yawatau ubupu manako iyapana tadebu da mu apunu yabui kenekenei ki wadamana e bameya bautagamana ki nana tadebu. E bameya bauwena ka e apunu ki empupu manako manupupu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Kau nuwageya nau gwede kwaesugani kau bamageya?” Ko e denai wagubu ke; “Sidiyei Kabukabuwa Apunai, kau yabuni wadi papi da nau tawana empani.” ");
INSERT INTO gdn_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","E inako wagubu manako Iyesu denai e sibu, wagubu ke; “Ki ka baganai, kau tawana emani. Kau nau sumasinibi ki pokere karako iyanugibi.” ");
INSERT INTO gdn_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Iyesu yona ki wagawa makeya ka apunu ki e yabui papupu tawana empupu manako e kipu ubupu Iyesu eweya kayawena Mamanuga God paraupiyawa kaniyawa. Iyapana kuduba matakira ki emupu ka mu Mamanuga God e si esida mena tepapamawa. ");
INSERT INTO gdn_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Iyesu natere Diyeriko bauwena ki ka e deni mena kayawagana kwaewagawa. ");
INSERT INTO gdn_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Natere ki rabineya ka purapura apunai mosi ika tondawa. E ka iyapana wairamaga denai takesi wadamawa ragidai mu kawaimaga si ka Sakiyasi. ");
INSERT INTO gdn_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","E nuwaiya Iyesu empana ki nana wainapiyawa ko e ka apunu rogobi munta ki pokere iyapana ropani kawaya ika ubumawa ki mu e bodamupu da e Iyesu eba empupu. ");
INSERT INTO gdn_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Iyesu yawatau yabadawa ki ka apunu Sakiyasi yabiri garupupu Iyesu empana ki nana ripa rowarowai mo yapu kawareya tondubu. ");
INSERT INTO gdn_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Iyesu kaniyawa da ripa ki kerareya bauwena ka e pairawena iyarau yabu tapu apunu Sakiyasi ika tondawa empupu manako e sibu, wagubu ke; “Sakiyasi, kau garugaru mena kawari. Nau karako kau tawageya kau mete idiwomu.” ");
INSERT INTO gdn_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Apunu Sakiyasi yona ki wainapupu ka e garugaru mena wairau kawapu Iyesu diriwai kwaewena manako mibi mamamai bananapupu e tawaiya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Iyesu apunu Sakiyasi tawaiya kayawena ki iyapana emupu manako mu ungwerogwerorotagubu, tagubu ke; “Apunu yau e ka bigibigi apunai ki e tawaiya daiyo kayawena.” ");
INSERT INTO gdn_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Ko apunu Sakiyasi kipu ubupu Iyesu sibu, wagubu ke; “Kaiwawoni, kau wainapi; Nau gwedegwedeni daikere ki nau karako iyapana imagei ragidai tageyani ade nau iyapana beratapuwani mu gwedegwedemaga kuwasugubuwani ki ka nau denai apeya apeya kawareya mu ade tageyani.” ");
INSERT INTO gdn_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Apunu Sakiyasi yona inako wagubu wainapupu ka Iyesu denai e sibu, wagubu ke; “Sakiyasi, kau mete kina ka oragai apunai Eburamu e wenai. Kau iyapanagiyoma mete kina wi bamagau ka iya karako bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","11","Iyapana gwedewau Mamanuga God e yawatai paeremupu kwakotagubu ragidai ki mu tetamana iya tageyana ki nana ka nau Kunumau Kawapuwani Apunai yewe wairau bausugubuwani.” Natere Diyerusaremu ka eba uwama bamanugutau ki makeya ka Iyesu yona ki wagubu. Iyapana ropani kawaya Iyesu yonai wainapamawa ki mu notamaga wagubu da Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki marai bauwagana kwaewagawa ki pokere Iyesu ubupu keyakeyai mo mu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Nau apunu kawai mosi e bususui suwagani wainapumuri; Apunu ki tawana uwama kawaya mo kayawagana da e kaiwawo-wagana ki kasiyarai ika wadana manako ewa ade wirawagana bauwagana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","E waunitau kayawagana kwaewagawa makeya ki ka e bigabiga-iyoma ida esida kewowena ki mu nene wagubu bautagubu manako e bowa madai purupupu mu eyaka eyaka tagebu, tadebu, wagubu ke; ‘Wi bowa madai yau tepumuri pokaiya upiwogoi da nau bausugani makeya ki ka nau bowa madai negebuwani ki kawayai empani. Ki kawayawena bo pa mena.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Apunu ki kipu ubupu kayawena ko e eya iyapanaiyoma mu nuwamugu ka e pa mena ki pokere mu bibi ragidai tonotampu da e tawana bani kayawena ki mu mete kayatagamana manako tagamana ke; ‘Nu eba nuwanugu apunu yau nu kawainuga uburono.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Mu inako tagubu ko apunu ki e kaiwawo kasiyarai wadubu manako ade wirawena e ebo tawaneya ade bauwena. E ika bauwena ka e garugaru mena e bigabigaiyoma ragidai mu nene wagubu bautagubu manako tadebu, wagubu ke; ‘Nau bowa madai negebuwani ki kawayai wi karako kabuwasinimuri da nau empani.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Yabiri ubupu apunai ki bauwena e inako sibu, wagubu ke; ‘Kaiwawoni emani, kau bowa madai nau idani rabineya tapi ki pokaiya ka nau upisugekeya da kawareya ade ida esida mena tepuwani karako negeyakani yau kena.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","E yona ki wagubu ka apunu kawai ki denai e sibu, wagubu ke; ‘Kau ka bigabiga apunai bagi upi supasupai mena kwaenugibi apunai. Nau marai munta negebuwani ki kau naigida mena kwayubapiyeya ade kau midigi eba togawena ki pokere nau karako natere ida esida mena kau idageya nakatamakani da kau mu kawaimaga uburi kwayubatamiyowa.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Ki eweya ka e bigabigai apunai ade mosi bauwena e yabareya ubupu manako sibu, wagubu ke; ‘Kaiwawoni emani, kau bowa madai nau idani rabineya tapi ki pokaiya ka nau upisugekeya da kawareya ade ida daikere tepuwani karako negeyakani yau kena.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","E yona ki wagubu ka apunu kawai ki denai e sibu, wagubu ke; ‘Nau karako natere ida daikere mena kau idageya nakatamakani da kau mu kawaimaga uburi kwayubatamiyowa.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","21","Siyarai ka e bigabigai apunai ade mosi bauwena e inako sibu, wagubu ke; ‘Kaiwawoni, nau kataineya da kau midigi kwakwarepugi ka tayatayabadai. Gwedegwede eba kau nene ki kau tepiyei ade kau momai eba upi ki wateya ki kau raupomunugei. Nau kau kudugeya wainapekeya ki pokere kau bowagi madai ki nau wadubuwani pa wekepuwani karako ade negeyakani yau kena.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Apunu kawai ki yona ki wainapupu ka e denai wagubu ke; ‘Kau paerepipi upi supasupai eba kwaenugibi. Kau kaubo nuwagibi ki pokaiya ka nau karako denai bita kau negeyani. Kau kaubo nuwagibi da gwedegwede eba nau nene ki nau tepakani ade momai nau eba upuwani ki wateya ki nau raupomu-sugakani. ");
INSERT INTO gdn_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Kau badidi kwaenugubena ki yonai nau karako kau nidiyani; Kau kayanugubena bowa madai kawaya-wagau ki wateya tapena da nau karako wirasugubuwani bausugubuwani ki kau bowa madai dai kawareya nau mete tegebena.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Apunu kawai ki inako wagubu manako e bigabigaiyoma dai ika ubumawa ki tadebu, wagubu ke; ‘Bowa madai eyaka mena kwebuwani ki wi wadumuri bowa madai ida esida mena tepupu apunai ki e kwemuri.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Ko mu denai e simupu, tagubu ke; ‘Ko kaiwawonuga, apunu ki ka ororeya mena bowa madai kawaya daganani ida esida mena ki e tepupu kewowena.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Mu inako tagubu, ko apunu kawai ki denai wagubu ke; ‘Nau nidiyani wainapumuri; Iyapana nima marai munta wadubu ki pokaiya upi naigida mena kwaewagau kwayubapiyau ki kawareya ka e ropani kawaya banana-poto. Ko iyapana nima e bameya marai munta uburau ki kawareya ka e mo eba yadini ade marai munta e bameya uburau ki mete deni mena gogayagisi.’ ");
INSERT INTO gdn_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E inako wagubu, manako ade tadebu, wagubu ke; ‘Wi karako kaiwagi nau iyaraniyoma ki nau eba kaiwawosugana ki nana tagubu ki mu kuduba tetamuri nau yabuneya yewe namutamuri.’” ");
INSERT INTO gdn_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Iyesu yona ki iyapana tadebu kewowena manako yabiriwena natere Diyerusaremu kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","E ripa ‘oripi’ wenatagubu kweyai ki kerareya natere Bepage yo Betani bamamugu bauwagana kwaewagawa ki ka e tadeyau kabukabuwa ragidai apeya yabiri tonotapu, ");
INSERT INTO gdn_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","tadebu, wagubu ke; “Wi yabiriwagi natere buri yabaranugu ki kaiwagi manako wi ika baiwagi ki ka wi papa ‘donki’ mosi taburuba pokaiya kwimupu uburau ki ika empumuri ko papa ‘donki’ ki kawareya ka iyapana mo naiya eba kayawena. Wi papa ki e taburubai rikapumuri manako banana-pumuri kebomuri. ");
INSERT INTO gdn_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Ko iyapana mo wi eminiyoto, yagisi ke; “Wi gwede nana inako kwaiwagamu papa ki e taburubai rikapiyamu,” e inako yagisi ki wi denai e simuri, iwagi ke; “Nu Nidiyau Kabukabuwa Apunai e papa ‘donki’ yau nene wagubu.” ");
INSERT INTO gdn_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Mu kayatagubu kaiwa da buri bautagubu ki ka Iyesu badidi tadebu ki mu makeya makeya bananamupu. ");
INSERT INTO gdn_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Mu papa ‘donki’ ki rikapamawa makeya ka papa ki apunai mu tadebu, wagubu ke; “Wi asusu gwede nana baigubu papa ‘donki’ ki taburubai rikapiyamu?” ");
INSERT INTO gdn_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Ko mu denai tagubu ke; “Nu Nidiyau Kabukabuwa Apunai papa ‘donki’ yau nene wagubu.” ");
INSERT INTO gdn_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Mu inako tagubu manako papa ‘donki’ ki rika-mupu wadumpu Iyesu bameya kaya-tagubu. Mu ika bautagubu ka mu muga midimaga tatamai rikatampu papa ki tagaiya nakamupu manako Iyesu waitamupu da e yapu papa ‘donki’ ki kawareya tondubu kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","E papa ki kawareya kayawena kaniyawa ka iyapana ropani kawaya mu muga midimaga tatamai rikatamawa yawatau nakapamawa manako Iyesu ki kawareya bauwagawa kayawagawa. ");
INSERT INTO gdn_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Iyesu kayawena kaniyawa da ripa ‘oripi’ wenatagubu kweyai ki warateya natere Diyerusaremu deneya surawa ki makeya ka e ewakumapamawa ragidai ropani kawaya mu bonanamaga eyaka mena Mamanuga God e si tepapamawa manako gwedegwede bagibagi mu mubo yabumugere emupu ki nene ka mu e paraupamawa iwa, ");
INSERT INTO gdn_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","tagamawa ke; “Kau ka nu Kaiwawonuga. Kau karako Mamanuga God e kasiyarai wadibi nu nene baunugibi. E kau wadiniyoto bagi. ");
INSERT INTO gdn_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Iyapana inako tagubu ki yonai ka Parisi ragidai dai ika ubumawa ki mu wainamupu manako mu kaimpu Iyesu simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, kau kowakowagiyoma ki ragiragi kawaya tade da mu kerekerere-tagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Mu inako tagubu, ko Iyesu denai mu tadebu, wagubu ke; “Nau nidiyani wainapumuri; Mu kerekereretagisi ki ka bowa urida ki iyapana maba bonana-maga ragiragi kawaya yona ki tagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Iyesu natere Diyerusaremu bameya bauwagana kwaewagawa ka e natere ki empupu yadi kipu, ");
INSERT INTO gdn_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","manako wagubu ke; “Natere Diyerusaremu ragidai, nau nuwaneya po wi nuwabagi rabineya idiwana ki yawatai naigida mena kataigamana ki nana ko wi yabuga kenewena ki pokere wi yawata ki eba empiyamu. ");
INSERT INTO gdn_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Wi iyaraguma ewa baitagisi wi naterega kawaya yau kwagarapomoto. Wi wakapaigamana yawatai kuduba ki mu deni mena bodapomoto manako wi gariga rauru-pomoto. ");
INSERT INTO gdn_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Mamanuga God ubupu wi iyaniyana wadiniyana bagi ki nana wi bamagau bauwena ko wi mara ki eba empamana wainamupu ki pokere wi iyaraguma ki baitagisi imatau wi ridiguma munuguma mete kina kuduba nunimoto isiyanimoto. Wi tawaguma bowa pokaiya waditampu ki kuduba mu wade rorororotamini da bowa eyaka mena kwaitana mo e wateya eba tondono.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Ki eweya ka Iyesu Mamanuga God e Tawai rabineya kanibu manako iyapana ika deni deni nida kasiwara-tagamawa idiwa ki siwakeketapu. ");
INSERT INTO gdn_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","E tadebu, wagubu ke; “Mamanuga God e okai mo inako wagubu ke; ‘Nau Tawani ka guriguri tawai ki rabineya iyapana baitagisi nau bamaneya guriguritogo-mono idiwono.’ Ko wi ka yona ki eba wainapiyamu. Wi ka kuwa ragidai maba maramara tawa yau rabineya wekei gwaiya dibipiyamu idiwu.” ");
INSERT INTO gdn_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Iyesu maramara Mamanuga God e Tawai rabineya iyapana tadeyawa kabukabuwa tondawa. Mamanuga God bameya dobopiyamu ragidai, Mama-nuga God e gorai kataimugu ragidai, ade iyapana kawakawai dai mete kina e minimana po ki yanuwei teyamawa, ");
INSERT INTO gdn_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ko iyapana pakasi ragidai ropani kawaya e yonai marai kawai badidi wagawa ki kuduba wainapamana wainapamawa ki pokere kawakawai ragidai ki e minimana po ki yawatai mo mu eba bananamupu. ");
INSERT INTO gdn_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Mara mosi Iyesu Mamanuga God e Tawai rabineya e yonai bagi kawaya ki dimawagawa iyapana tadeyawa kabukabuwa tondawa ka Mamanuga God bameya dobopiyamu ragidai, Mamanuga God e gorai katai-mugu ragidai ade kawakawai ragidai dai ki mete kina e bameya bautagubu, ");
INSERT INTO gdn_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","manako simupu, tagubu ke; “Kau karako nidi; Kau kasiyara nima negebu were kwaenugei? Kasiyara ki nima negebu?” Mu inako tagubu, ");
INSERT INTO gdn_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ko Iyesu denai mu tadebu, wagubu ke; “Nau manu mosi wi manuniyani. Wi nau sidimuri; ");
INSERT INTO gdn_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Apunu Diyoni iyapana siruwatamana ki nana bauwena ki ka e Mamanuga God wagubu ki pokere kwaewagawa bo iyapana kaina mo wagubu were kwae-wagawa?” ");
INSERT INTO gdn_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Kawakawai ragidai e manui wagubu ki wainamupu ka mu mubo deni deni manu kasiwaratagubu, tagubu ke; “Nu denai badidi siyamu? Nu iwagamu da; ‘Mamanuga God wagubu e umuneya kwaewena’, ki ka e denai yagisi ke; ‘Baganai, ko wi badidi pokere apunu Diyoni e yonai eba sumamupu?’ ");
INSERT INTO gdn_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Ko nu iwagamu da; ‘Iyapana kaina wagubu were e kwaewena’, ki ka iyapana ropani kawaya yewe bautagubu ki mu gagayatagisi manako bowa were nu namunimoto mibai ka mu kuduba wainapiyamu da apunu Diyoni e ka Mamanuga God e bonanai ki waina-piyawa wagawa apunai mosi.” ");
INSERT INTO gdn_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Kawa-kawai ragidai ki mu mubo mubo inako tagubu manako mu denai Iyesu simupu, tagubu ke; “Nima apunu Diyoni sibu were kwaewagawa ki nu eba katainugu.” ");
INSERT INTO gdn_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Iyesu yona ki wainapupu ka e denai wagubu ke; “Baganai, wi nau eba sidimupu ki pokere nima kasiyara nau tegebu ki sisiyai nau mete eba suwagani.” ");
INSERT INTO gdn_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Ki eweya ka Iyesu keyakeyai mo iyapana tadebu, wagubu ke; “Apunu mosi e ka ripa ‘waeni’ ki momai upu manako iyapana dai mu nene wagubu bautagubu gwaiyabatapu, wagubu ke; ‘Wi nau upini yau naigida mena kwayubapiyoi. Maura marai baiyagisi ki ka wi madai dai wi wiga nene tepiyoi ko ade dai nau nene nakapiyoi. Nau tawana mo kayasugani umoni da ewa marai mosi ade wirasugani bausugani.’ E inako wagubu manako kipu ubupu kayawena mara rowarowa kawaya tawana mo tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Maura marai bauwena ki makeya ka apunu ki ripa madai e eya nene ki dai tepana ki nana e bigabigai apunai mosi tonopupu upi kwayubapamawa ragidai ki mu bamamugu kayawena. Ko e ika bauwena ka mu ripa madai ki dai e eba kwemupu ko mu e pa guda-pamawa da tonomupu ida kasikasi wirawena kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Upi ki apunai ubupu e bigabigai apunai ade mosi tonopupu ko e kayawena umawa da buri bauwena ka upi kwayubapamawa ragidai ki e mete gudapamawa ade midimama berai e bameya kwaetagamawa manako pa ida kasikasi tonomupu wirawena kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Ki eweya ka upi ki apunai e bigabigai apunai ade mosi tonopupu ko e mete kayawena umawa da buri bauwena ki ka mu e mete bidara kwemupu manako wadumpu gari tagaiya kwenumupu. ");
INSERT INTO gdn_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Mu berokoi kawareya kawareya inako kwaetagamawa ki pokere upi ki apunai e notai babawena, wagubu ke; ‘Nau karako badidi kwaesugani? Nau niya gubagani ki nau nuwaneya po ki e nau tonopani ki ka mu e naigida mena wiwirapomoto wainapakani.’ E notai inako wagubu ki pokere e eya gubagai ki tonopupu. ");
INSERT INTO gdn_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Ko upi kwayubapamawa ragidai ki e gubagai ki ika yabadawa emupu ki ka mu mubo tagubu ke; ‘Waira yau ewa wadana apunai ki e eya bauwena ki pokere karako miniyamu poyo manako e gwedegwedei yau kuduba ki aita nu tepamu.’ Mu mubo inako tagubu, ");
INSERT INTO gdn_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","manako mu apunu ki e gubagai ki wadumpu gari tagaiya kwenumupu manako minimupu poyo.” Iyesu keyakeyai ki wagubu kewowena ka e iyapana ika idiwa ki mu manutapu, wagubu ke; “Waira ki apunai e gubagai powena ki bimbinai ka e upi kwayuba-pamawa ragidai mu bamamugu badidi kwaeyagisi? ");
INSERT INTO gdn_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nau nidiyani wainapu-muri; E baiyagisi manako kwayuba siyasiya kwaetagamawa ragidai ki tetamini namutamini manako mu upimaga ki e tepoto kwayuba ragidai kudubai dai ki mu idamaga rabineya nakapoto.” Iyapana e yonai ki wainamupu ka mu tagubu ke; “Ae, inako eba wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Mu inako tagubu ko Iyesu mu emitapu manako manutapu, wagubu ke; “Ko Mamanuga God e okai ki kawareya nau karako suwagani ki mibai ka badidi? Oka ki wagubu ke; ‘Wi tawa wadamu ragidai waina-mupu da e ka bebeda berokoi ki pokere kwenumupu. ");
INSERT INTO gdn_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Nau nidiyani wainapumuri; Iyapana kaiwono da bebeda ki pokaiya pisipisitamini gwepomoto ki ka mu bidara yadini mu midimaga purupuru-tagisi. Ade bebeda ki mu kawarimugu kauyagisi ki ka mu tauniyoto kwere-kwerere.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Mamanuga God bameya dobo-piyamu ragidai ade Mamanuga God e gorai kataimugu ragidai mete kina Iyesu waigugu wagubu ki wainamupu ki ka mu deni mena e wadamana wainamupu mibai ka mu kataimugu da e waigugu wagubu ki ka e mu nene wagubu. Ko mu iyapana kudumugu mete waina-pamawa, ");
INSERT INTO gdn_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ki pokere kamadumpu manako mara bagi mosi ewa bauwagana da mu e wadamana ki nawanai idiwa. Mu dayaya tagamana ragidai dai e bameya tonotampu da mu e kerareya wadamana manupamana manako e yona mo paerepana ki pokaiya ka mu e wadamana piyara ragidai mu kawai-maga e idai rabineya tamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Dayaya ragidai ki Iyesu bameya bautagubu manako simupu, tagubu ke; “Nidiyei kabukabuwa apunai, nu katai-nugu da kau iyapana eba beratamiyei ko kau badidi kabuwanugei ki kau yona mibai mena nuwegei. Iyapana kawa-kawai kau bamageya bautagamu ki kau bera yonai mo eba nuwegei. Ade iyapana pakasi ragidai kau bamageya bautagamu ki kau mu mete eba bera-tamiyei yona kudubai mosi nuwegei. Pa mena. Kau maramara yona eyaka mena Mamanuga God e yonai mibai ki mena nuwegei. ");
INSERT INTO gdn_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ki pokere nu karako kau nidimei ki kau wainapi; Nu tawana Roumi ragidai mu kawaimaga Sita bameya nu wairanuga denai takesi tamamu ki kau wainapiyei baganai bo eba baganai? ");
INSERT INTO gdn_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Nu takesi ki tamamu, bo eba tamamu?” Mu inako tagubu ko mu rabinamugu e kerareya wadamana ki notai nota-pamawa ki Iyesu e ororeya mena empupu kewowena ki pokere e denai mu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Bowa madai mo tegemuri da nau empani. Yau ka nima keyai bowa madai yau naureya tondau? Mu nima si bowa madai yau naureya okamupu?” E inako wagubu ka mu denai tagubu ke; “Yau ka tawana Roumi ragidai mu kawaimaga Sita e keyai ki naureya tondau.” ");
INSERT INTO gdn_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Mu inako tagubu, ki pokere Iyesu denai mu tadebu wagubu ke; “Baganai, apunu kawai Sita nene ki wi e ebo kwemuri ade Mamanuga God nene ki wi e ebo kwemuri.” ");
INSERT INTO gdn_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Iyesu yona ki wagubu ka iyapana ki mu notamaga kowena e denai siyamana babatagubu. Mu iyapana paunamugu e yona mo paerepana da mu ki pokaiya e wadamana ki nana wainapamawa ko mu e wadamana yawatai mo eba bananamupu. ");
INSERT INTO gdn_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Iyapana Sadusi ragidai dai ki Iyesu manupamana ki nana e bameya bau-tagubu. Sadusi ragidai mu ka iyapana inako tadeyamu, tagamu ke; ‘Nu popoigamu ki ka nu ewa eba iyaigamu kimamu ubumamu. ");
INSERT INTO gdn_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Mu Iyesu bameya bautagubu manako simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, oragai apunai Mosisi nu goranuga inako tapu, wagubu ke; ‘Apunu mosi e wainai munu eba wenapoto ko e nobomoi poyagisi ki ka apunu ki e yowai uburoto koboro ki uworoto manako munu wenayagisi ki aita popai apunai ki e watai yadini. ");
INSERT INTO gdn_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Karako tawana mosi ka iyapana ida daikere kewowena daikere apeya (7) ika idiwa manako mu tatamaga ridi mo uwapu ko e munu eba wenapupu manako apunu ki powena. ");
INSERT INTO gdn_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","E powena ki pokere e yowai koboro ki uwapu ko e mete munu mo eba wenapupu manako powena. ");
INSERT INTO gdn_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","E powena ki pokere e yowai ade mosi ubupu koboro ki ade uwapu manako e mete powena ko munu mo eba wenawena. Mu inako kwaetaga-mawa yamawa da iyapana ida daikere kewowena daikere apeya (7) koboro ki uwamupu ki mu kuduba popotagubu gawarara ko munu mo eba wenawena. ");
INSERT INTO gdn_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ko siyareya ka ridi ki e eya mete powena. ");
INSERT INTO gdn_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kau karako nuwagi da nu wainapamu; Mara kwauneya iyapana popotagubu ragidai ade iyatagisi kimoto ubumoto makeya ki ka ridi ki nima wainai? Mibai ka e iyapana ida daikere kewowena daikere apeya (7) ki tauwapu.” ");
INSERT INTO gdn_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Mu inako tagubu ko Iyesu denai Sadusi ragidai ki tadebu, wagubu ke, “Ridi yo apunu yewe wairau idiwu ki ka mu anikatagamu, ");
INSERT INTO gdn_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ko iyapana gwedewau Mamanuga God e wainapiyau da mu ka baganai ki mu popotagisi ade kimoto ubumoto waira waunai kawareya idiwono ki ka mu eba anikatagisi. ");
INSERT INTO gdn_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Mu ka aneya kunumau idiwu ki mu maba inako idiwono manako ewa eba popotagisi. Mu ororeya mena popotagubu ko ade iyatagubu kimpu ubumpu ki pokere mu Mama-nuga God e eya munuiyoma idiwono. ");
INSERT INTO gdn_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Iyapana popotagubu ragidai ade iyatagisi kimoto ubumoto ki yonai ka oragai apunai Mosisi matarau nu kabuwanibu. E gwabau ripa mo beu-wena empupu ki bususui rabineya ka e ubupu Mamanuga God nene inako wagubu ke; ‘Apunu Eburamu e Mamai God ka nau. Apunu Aisiki e Mamai God ka nau. Apunu Diyaikapu e Mamai God ka nau.’ ");
INSERT INTO gdn_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","E inako wagubu ki mibai ka yau kena; Oragai ragidai Eburamu yo Aisiki yo Diyaikapu ki mu ka orageya mena popotagubu ko mu keyaimuguma ka iyaiya idiwu ki pokere Mamanuga God wagubu ke; ‘Mu Mamamaga God ka nau.’ E ka eba popai ragidai mu Mamamaga ko e ka iyapana keyaimaga iyaiya idiwu ragidai ki mu Mamamaga. E yabuiya ka nu kuduba iyaiya idiwei.” ");
INSERT INTO gdn_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Mamanuga God e gorai kataimugu ragidai ika idiwa ki Iyesu denai badidi wagubu wainamupu ki ka mu e simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, kau yona denai bagi kawaya nuwagibi.” ");
INSERT INTO gdn_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ki eweya ka iyapana mo eba ubupu Iyesu manupupu mibai ka mu kuduba e kudeya mete wainamupu. ");
INSERT INTO gdn_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Iyesu mu manutapu, wagubu ke; “Iyapana badidi pokere tagamu da; ‘Keriso e ka oragai apunai Dewida e momai?’ ");
INSERT INTO gdn_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Oka ‘Umayo’ rabineya ka oragai apunai Dewida oka inako tapu, wagubu ke; ‘Nau Mamai God nau Kaiwawoni sibu, wagubu ke; Kau nau madanani garu deneya tondowa, ");
INSERT INTO gdn_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","da nau kau iyaragiyoma kuduba kwanatamani kau kerapugi kobaiya nakatamani kewoyagisi were.’ ");
INSERT INTO gdn_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Oragai apunai Dewida e ka Keriso e eya Kaiwawoi sibu ko ade badidi maba ka e eya Kaiwawoi sibu ki ade apunu Dewida e eya momai?” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Iyapana ropani kawaya e yonai ki wainapamawa ki pokere Iyesu wira-wena e eya tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Yabu yabu idiwoi kwaenda Mamanuga God e gorai kataimugu ragidai wi kerapugau yadini. Mu ka iyapana mu emitamana ki nana mu monagamaga rorowa kawakawaya inako umamu ade imatau kaiwu kebomu da iyapana ika idiwu ki mu emitamana wiwiratamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","Guriguri tawai rabineya ka mu kawai gisipiyamu kawakawai ragidai mu watamugu idiwu ade poraga kawareya ka mu kebari bagi kawaya kawareya idiwana wainapiyamu. ");
INSERT INTO gdn_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ridi koboro ragidai mu gwedegwedemaga ade mu tawamaga kuduba mete kina ki mu tepiyamu araratagamu ade iyapana mu emitamana ki nana ka mu iyapana yabaramugu ubumu guriguri rowarowa kawaya tagamu. Mu inako kwaetagamu ki pokere mu aita ewa denai bita banana-pomoto ki bitai ka kawaya esida.” ");
INSERT INTO gdn_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Iyesu wirawena manako iyapana gwedegwedemaga ropani kawaya ragidai bautagamawa Mamanuga God e Tawai rabineya ‘Puyo Nakapemei Wateya’ bowa madai kawaya daganani ika nunumawa ki e mu emitapu. ");
INSERT INTO gdn_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Ki makeya ka ridi koboro mosi e gwedegwedei pa mena ika bauwena bowa madai waibora apeya ki mena ika nunupu, ");
INSERT INTO gdn_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","manako Iyesu ubupu yona yau iyapana tadebu, wagubu ke; “Nau yona mibai wi nidiyani wainapumuri; Iyapana kuduba bowa madai ika nunumawa mu ka puyo maraitau tamawa ko ridi koboro yau kena ki e mena ka puyo kawaya daganani esida tapu. ");
INSERT INTO gdn_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Gwedegwede-maga ropani kawaya ragidai ka mu tagamaga mesi mete nakamupu ko ridi koboro yau e gwedegwedei ka pa mena ko waibora marai muta e bameya tondawa ki kuduba e Mamanuga God nene tapu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Iyesu e tadeyau kabukabuwa ragidai Mamanuga God e Tawai ki taragapamawa, tagamawa ke; “Tawa bagi kawaya bowa bagibagi pokaiya wadumupu ade puyo bagibagi Mamanuga God nene nakamupu ki empumuri.” Mu inako tagubu ko Iyesu denai mu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Wi yau kuduba empiyamu ki nene ka nau karako wi nidiyani wainapumuri; Mara baiyagisi da iyapana tawa yau bowa pokaiya wadumupu ki mu baupomoto giripomoto pasumoto manako bowa eyaka mena kwaitana mo e wateya eba tondono ko mu kuduba rorororotagisi kewoyagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Iyesu inako wagubu manako e tadeyau kabukabuwa ragidai denai e manumupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, kau kabuwaniyo; Nuwaboya marai nene nuwagibi ki gwede mara baiyagisi? Ade mara ki bauwagana ki nu gwede matakirai empamu da nu kataigamu mete idiwomu?” ");
INSERT INTO gdn_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ko Iyesu denai mu tadebu, wagubu ke; “Yabu yabu idiwoi da iyapana eba baitagisi wi beranimoto wi kerapugau yadini. Iyapana ropani kawaya nau ewaneya baitagisi nau sini pokaiya beratagisi, tagisi ke; ‘Nau ka eyo’, bo ade tagisi ke; ‘Mara wana bauwena.’ Mu inako togomono ki ka wi mu ewamugu eba kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Wi ta yo yawira sisiyai wainapumuri ade ta yo yawira kwaetagamana kwaetagamu ki sisiyai mete wainapumuri ki ka wi kudu eba wainapiyoi. Ta yo yawira ki kuduba wenayagisi ko mara siyarai tondau eba bauwagana kena.” ");
INSERT INTO gdn_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Iyesu inako wagubu, ade wagubu ke; “Tawana tawana ka natere mo uburoto natere kudubai mo mete yawiratagisi, ade tawana mo kawai-maga e iyapanaiyoma tetamini kaya-tagisi tawana mo kawaimaga e iyapanaiyoma mete kandetagisi. ");
INSERT INTO gdn_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Tawana mosi ka waira nutanuta baiyagisi ade tawana mosi ka kapoi kawaya mete uburoto. Tawana tawana berokoi ebo ebo inako wenayagisi ade kunumau keyai ebo ebo mete matara-yagisi ki ka iyapana kudu wainapomoto. ");
INSERT INTO gdn_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Ko naiya ka iyapana ubumoto wi tenimoto wi girinimoto pasunimoto manako guriguri tawai rabineya mu idamaga gurai wi naurigau ugwadini-moto ragiragi manako diburanimoto. Nau pokanere ka wi aita kaiwawo ade kawakawai ragidai mu yabaramugu ubumuri, ");
INSERT INTO gdn_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ko ki ka mara bagi da wi ubumuri nau yonani kawakawai ragidai ki mu mete tademuri. ");
INSERT INTO gdn_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Mara ki ewa baiyagisi ko wi taububuraga badidi maba iwagamana ki nene wi karako eba notapiyoi bo nuwaboyaiwogoi. ");
INSERT INTO gdn_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Nau nidiyani wainapumuri; Mu wi wirawira-nimoto bo manunimoto ki ka wi denai badidi iwagamana ki yonai nau naubo wi kabuwaniyani manako wi ki makeya mena iwagi. Wi yona iwagi ki ka mu wi yonaga denai tagamana ki mu baba-tagisi ade wi yonaga ki mu eba boda-pomoto. ");
INSERT INTO gdn_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Wi inaguma mamaguma bo wi yowaguma tataguma bo wi rakaraka-guma bo wi kowaguma ki mu ubumoto wi tenimoto kawakawai ragidai mu idamaga rabineya wi nakanimoto. Mu ubumoto wi dai mete namunimoto. ");
INSERT INTO gdn_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Nau pokanere ka iyapana kuduba wi keinimoto ade wi girinimoto pasuni-moto, ");
INSERT INTO gdn_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ko wi kudu eba wainapiyoi. Wi debaga kumai eyaka mena kwaitana mo eba siwayagisi. ");
INSERT INTO gdn_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Wi watagau mena ragiragi kawaya ubumoi ki ka wi iya bananapumuri. ");
INSERT INTO gdn_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Piyara ragidai natere Diyerusa-remu kwagarapomoto ubumono emita-muri ki wi kataiwagi da natere ki waunitau giriyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Mara ki makeya ka wi tawana Diyudiya ragidai garugaru mena wakapaiwagi kweyau kaiwagi. Wi gwedewau natere ki rabineya idiwu ki wi natere ki kamadumuri ade wi gwedewau gari tagaiya idiwu ki wi natere ki rabineya eba kaiwuri. ");
INSERT INTO gdn_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Mara ki ka iyapana mu paeremaga bimbinai ki wadamana marai. Mamanuga God e okai badidi wagubu ki mibai wenawena yau kena. ");
INSERT INTO gdn_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Akae, mara ki makeya ridi mosi mibi romodoi bo munu wawayai mete kina ki ka e badidi maba wakapa-yagisi garugaru kayayagisi? Mara ki makeya ka bita kawaya daganani waira yau kawareya kaworoto ade Mamanuga God e uburoto iyapana kowaga tageni. ");
INSERT INTO gdn_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Wi iyaraguma ubumoto wi dai kereba pokaiya namunimoto ade ubumoto wi dai tenimoto diburanimana ki nana tawana tawana madega kauwagau madega posiwagau ki kayatagisi wi nakanimoto. Iyapana kwaiyanai ragidai baitagisi natere Diyerusaremu inako giripomono pasumono yamono da mu maramaga ki kewoyagisi makeya. ");
INSERT INTO gdn_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Mara ki makeya ka matakira ebo ebo madega yo siragamu yo supama mu naurimugu wenayagisi ki iyapana empomoto. Egi towawa kawaya daganani totori wenapoto manako iyapana tawana tawana kuduba egi mumugarai ki kudeya wainapomoto babatagisi. ");
INSERT INTO gdn_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Nuwaboya kawaya ki marai baiyagisi ki ka iyapana waira kawareya gwede berokoi badidi wenawagana ki kudeya wainapomoto manako mu kiyabumaga giyagisi, mibai ka mara ki makeya ka kunuma kasiyarai kuduba geyageyatagisi. ");
INSERT INTO gdn_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Mara ki makeya ka nau Kunumau Kawapuwani Apunai nau kasiyarani kawaya ade nau tanini bagi kawaya oroguma kawareya ade kaworoni ki mu nau emisinimoto. ");
INSERT INTO gdn_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Wi yau kuduba wenayogono empumuri ki ka wi kimuri ubumuri pairaiwagi kunumau esida yabu tamuri mibai ka Mamanuga God wi wadiniyana bagi iya negeyana ki marai ka waunitau.” Iyesu inako wagubu, ");
INSERT INTO gdn_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ade tadebu, wagubu ke; “Karako keyakeyai ripa damaya ade ripa dai ki mu naurimugu suwagani ki wi wainapumuri; ");
INSERT INTO gdn_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ripa duwapiyau empumuri ki wi kataigubu da bodu marai waunitau baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ki maba, gwedegwede kuduba nidibuwani ki mibai wenayogono empumuri ki wi mete kataiwagi da Mamanuga God e gari rabineya kaiwana e kasiyarai pokaiya idiwana ki marai waunitau baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Nau yona mibai suwagani wainapumuri; Nau yonani yau kuduba nidibuwani ki mibai matarayagisi wi yabugere empumuri were ewa ka wi dai waira yau kamadumuri. ");
INSERT INTO gdn_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Kunuma waira kuduba gogayagisi ko nau yonani suwagubuwani ki eba gogayagisi ko maramara tondono kaniyono. ");
INSERT INTO gdn_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Wi kwayubaga naigida mena kwaiwogoi ade wi notaga bani yo awana kawaya daganani kubamana ki nene eba notapiyoi. Ade wi waira yau iyai nene eba notapiyoi bo nuwaboya-iwogoi kwaenda mara ki garugaru mena baiyagisi wi naininiyoto. ");
INSERT INTO gdn_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Iyapana tawana tawana kuduba mu bamamugu ka mara ki baiyagisi mu nainitamini, ");
INSERT INTO gdn_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ki pokere maramara yabu yabu idiwoi. Wi maramara Mamanuga God bameya guriguriwogoi da e wi waitaniyoto kasiyara negeni da berokoi ki kuduba wenayagisi ki ka wi berokoi ki baibigapumuri manako aita ewa mara kwauneya ki ka wi Kunumau Kawapuwani Apunai nau yabaraneya ubumuri.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Iyesu maramara Mamanuga God e Tawai rabineya dimawagawa iyapana tadeyawa kabukabuwa tondawa ko kemorawagawa ka e kayawena ripa ‘oripi’ wenatagubu kweyai ki yapu. ");
INSERT INTO gdn_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Ko maramara nawaru puruwagawa didiburu ka iyapana kuduba e yonai wainapamana ki nana Mamanuga God e Tawai rabineya ade bautagamawa manako ika dibipamawa e kwagarapamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Diyu ragidai mu poragamaga mo si ‘Parawa Pa Pasumana Kupei’ ki si daikere ‘Mamanuga God Nu Raurunibu Poragai’ tagamu ki marai rogobiwena. ");
INSERT INTO gdn_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Mamanuga God bameya dobopiyamu ragidai ade e gorai katai-mugu ragidai mete kina Iyesu wadamana ki nana wainamupu. Ko mu iyapana kudumugu mete wainapamawa ki pokere mu e minimana po ki yawatai kwaenepamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ki makeya ka Berokoi Apunai Seitani bauwena Iyesu e tadeyau kabukabuwa ragidai ida esida kewo-wena kerapu apeya ki apunai mosi si ka Diyudiyasi si daikere ka Isikariyoto e rabineya supu e notai wirapupu. ");
INSERT INTO gdn_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Apunu Diyudiyasi kipu ubupu kaya-wena Mamanuga God bameya dobo-piyamu ragidai ade Mamanuga God e Tawai ki kwayubapiyamu ragidai mete kina mu bamamugu bauwena manako e badidi maba Iyesu wadana mu idamaga rabineya tarana ki yonai mu mete tagamawa. ");
INSERT INTO gdn_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","E yona ki wagubu wainamupu ka kawakawai ragidai ki mu rabinamaga bagiwena poyo manako mu denai e simupu, tagubu ke; “Ki ka bagi kawaya. Kau inako waitaniyo ki nu denai aita bowa madai dai kau negeyamu.” ");
INSERT INTO gdn_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Apunu Diyudiyasi baganai wagubu manako kayawena iyapana yabumaga sipeya Iyesu wadana kawakawai ragidai mu idamaga rabineya tarana ki yawatai kwaenepiyawa umawa. ");
INSERT INTO gdn_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mu idiwa da ‘Parawa Pa Pasumana Kupei’ ki kawareya papa sipi naumana pasumana manako ‘Mamanuga God Nu Raurunibu Poragai’ ki kupei kupetaga-mana ki marai bauwena, ");
INSERT INTO gdn_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ki ka Iyesu ubupu apunu Pita yo Diyoni tadebu, wagubu ke; “Wi yabiri kaiwagi ‘Mama-nuga God Nu Raurunibu Poragai’ ki kupei okukunaiwagi manako nu kupeigamu.” ");
INSERT INTO gdn_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Ko mu e manumupu, tagubu ke; “Kau nuwageya nu kaigamu tawa bani rabineya tawiyaigamu.” ");
INSERT INTO gdn_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","E denai wagubu ke; “Wi natere buri baiwagi ki ka apunu mosi ika yawatau awana minibu kawarapupu kaniyau ki wi bananapumuri. Apunu ki bani kayayagisi ki wi e ewakumapumuri mete kaiwagi manako e tawa bani yaroto ki wi mete ika yamuri, ");
INSERT INTO gdn_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","manako tawa ki apunai ika tondau ki simuri, iwagi ke; Nu Nidiyau Kabukabuwa Apunai wagubu ke; ‘Nau watani bani da nau tadeyakani kabukabuwa ragidai mete kina ‘Mamanuga God Nu Rauru-nibu Poragai’ ki kupei ika kupeigamu?’ ");
INSERT INTO gdn_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Wi inako iwagi manako nu kupenuga watai kawaya mosi tawa rabinai tetaiya ki mu kebari ororeya mena mempu kewowena ki e wi kabuwaniyoto. Nu baninuga ki wi ika tawiyaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Iyesu inako tadebu tonotapu manako mu kayatagubu natere ki bautagubu ki ka mu Iyesu yona badidi wagubu ki makeya makeya bananamupu manako mu bani ika tawiyatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Mu bani kupamana madegai wadawa makeya ka Iyesu e tonotapu ragidai mete kina kupetagamana wateya ika bautagubu idiwa, ");
INSERT INTO gdn_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","manako e mu tadebu, wagubu ke; “Nau mara rowarowa kawaya wi mete ‘Mamanuga God Nu Raurunibu Poragai’ yau kupeigamana ki nana nau nuwani notani wadawa notapekeya yabedekeya. Nu kupe yau kupeigamu eweya ka nau nuwaboya ade midi makari bananapani. ");
INSERT INTO gdn_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Nau suwagani wainapumuri; Nu yewe kupeigemei ki ka pa keyakeyai. Nau kupe yau ewa mo eba kupesugani ko yaroni da aita ewa Mamanuga God e gari rabineya kupe mibai wenayagisi were ki nau ade kupesugani.” ");
INSERT INTO gdn_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Iyesu inako wagubu manako kapa mo wadubu Mamanuga God bameya parauwena manako tagebu, wagubu ke; “Wi kapa yau wadumuri wi wibo eyaka eyaka piripiri kubamuri. ");
INSERT INTO gdn_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Nau yona mibai nidiyani wainapumuri; Awana daragai yau kena ki nau ewa mo eba kubarani. Ko aita ewa, nu Mamanuga God e gari rabineya kaiwana idiwana ki marai baiyagisi makeya ki nau ade kubarani.” ");
INSERT INTO gdn_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Iyesu inako wagubu manako ki eweya ka e bani buredi mo wadubu Mamanuga God bameya parauwena gerepupu manako e tadeyau kabu-kabuwa ragidai tagebu, wagubu ke; “Bani buredi yau ka nau midini kwakwarepuni ki nau wi nene tarakani. Wi bani yau kupoi ki ka nau wi nene badidi kwaesugubuwani ki wi notapiyoi ade nau mete notasiniyoi.” ");
INSERT INTO gdn_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Mu kupetagubu kewowena eweya ka e naiya kwaewena ki maba kawareya ade kwaewena kapa wadubu tagebu, manako tadebu, wagubu ke; “Awana daragai ‘waeni’ yau ka nau darani manako nau darani wi nene baiyagisi kaworoto ki pokaiya ka Mamanuga God gwaiyaba waunai mosi yagisi. ");
INSERT INTO gdn_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Ko wainapumuri; Nau yogoni wagana apunai ki karako nu mete ewapuru yewe bani yau kupemei. ");
INSERT INTO gdn_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Nau Kunumau Kawapuwani Apunai posugana ki marai ka Mamanuga God e ororeya mena winepupu tapu, ko ‘akae’, nau yogoni wagana apunai ki e ka aita bita kawaya daganani bananapoto.” ");
INSERT INTO gdn_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Iyesu inako wagubu ki ka e tadeyau kabukabuwa ragidai mu mubo mubo manu kasiwaratagamawa, tagamawa ke; “Nu paunanugu ki nima uburoto inako kwaeyagisi?” ");
INSERT INTO gdn_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Ki makeya ka Iyesu e tadeyau kabukabuwa ragidai mu paunamugu nima ka kawaya esida ki yonai kawareya mu deni deni tagamawa kasiwara idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Ko Iyesu ubupu mu tadebu, wagubu ke; “Mamanuga God eba kataimugu ragidai mu kawakawaimuguma ki mu kasiyara mete wadumpu ki pokere mu gwede mo tagisi ki ka mu kobamugu idiwu ragidai mu umunumaga mete yadini. Ade mu kobamugu idiwu ragidai ki mu ubumu kawakawaimuguma ki mu simaga esida tepapiyamu, tagamu ke; ‘Nu kawakawainuguma ki mu nu nene kwaetagamu.’ ");
INSERT INTO gdn_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Ko wi mu maba eba kwaiwogoi. Wi paunagau nima nuwaiya kawai uburana wainapiyau ki ka e kwarisiyagisi munu marai munta maba tondono, ade nima nuwaiya ka debai uburana wainapiyau ki ka e kwarisi-yagisi e kowaiyoma mu bigabigamaga kwaeyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Iyapana nima ka kawai? Iyapana kebari bagi kawareya tondau bani kupau ki kena bo iyapana bani warapiyau bigabiga upi kwaewagau ki kena? Ki ka kebari kawareya tondau iyapanai ki kena. Ko nau karako nidiyani ki wi naigida mena wainapu-muri; Nau wi paunagau bausugubuwani ki ka nau wi bigaga kwaesugubuwani.” ");
INSERT INTO gdn_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Iyesu inako wagubu ade tadebu wagubu ke; “Bita ebo ebo nau bamaneya bauwagawa ki wi nau eba kamadisinimawa ko wi maramara nau mete idiweya, ");
INSERT INTO gdn_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ki pokere nau iyapana yabaramugu kawai uburana ki kasiyarai nau Mamai tegebu ki kwaitana ka nau kasiyara wi mete negeyakani. ");
INSERT INTO gdn_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Nau kasiyarani pokaiya ka wi nau Mamai e gari rabineya nau mete idiwomu bani kupomu ade awana kubomomu. Wi kawakawaiwagi manako wi kemaga kawareya idiwoi wi idaga gurai tawana Isiraero ragidai kunu ida esida kewo-wena kerapu apeya (12) kuduba ki mu naurimugu ugwaditamiyoi ragiragi.” ");
INSERT INTO gdn_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Iyesu ade wagubu ke; “Saimoni, Saimoni, nau suwagani wainapi; Mu bani wakapiyamu kwakwarai ebo nakapiyamu ade mibai ebo nakapiyamu ki maba ka Berokoi Apunai Seitani bauwena wi kuduba nuteteniyana eminiyana ki nana manui wadubu ki Mamanuga God mibipupu, ");
INSERT INTO gdn_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ko Saimoni, nau kau nene gurigurisugu-buwani da kau sumagi eba kauyagisi. Kau kamadisini ko ade wiranuwagi baunuwagi makeya ki kau kowagiyoma togitamiyowa kasiyara tageyowa.” ");
INSERT INTO gdn_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Iyesu yona ki wagubu ka apunu Pita denai e sibu, wagubu ke; “Kaiwa-woni, kau diburanuwagi ki ka nau mete diburasugani ki baganai, ade kau ponuwagi ki nau kau pokagere posugani ki mete baganai.” ");
INSERT INTO gdn_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Apunu Pita inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Pita, nau nidiyani wainapi; Kemora yau rabineya ka kau mara apeya eyaka nuwagi bodaboda da kau eba kataigeya nau. Kau inako nuwagi were ewa ka kokoroku yagisi manako nawaru puruyagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Iyesu inako wagubu manako wirawena e tadeyau kabukabuwa ragidai kuduba tadebu, wagubu ke; “Nau naiya mena wi tononiyekeya manako wi bowaga madai ki sikwai bo wi igwaga bo wi kerapuga kwakwarai bo inako ki kuduba wi kamadamana pa ida kasikasi kaigamana suwagubuwani ki ka wi mibi wetei iwa bo?” “Pa mena, nu bagi kawaya iweya.” ");
INSERT INTO gdn_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Mu inako tagubu manako Iyesu mu ade tadebu, wagubu ke; “Naiya ka wi ida kasikasi kaigubu ko karako ka nima bowa madai bo e igwai mete kina ki ka e gwedegwede ki tepoto, ade iyapana nima e kerebai pa mena ki ka e kayayagisi e eya midi tatamai nidapoto manako denai bowa madai yadini ki pokaiya ka e kereba gimarapoto. ");
INSERT INTO gdn_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Nau yona mibai wi nidiyani wainapumuri; Mamanuga God e okai nau nene takari kawaya okamupu ki mibai karako wenawagana kwaewagau. Oka ki wagubu ke; ‘Kuwa ragidai mu pauna-mugu ki mu e mete ika tamupu.’ Oka wagubu ki kuduba wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Iyesu inako wagubu ki pokere e tadeyau kabukabuwa ragidai denai e simupu, tagubu ke; “Kaiwawonuga, kau emani. Nu kerebanuga apeya yewe mete temipi.” Ko e denai wagubu ke; “Kewowena.” ");
INSERT INTO gdn_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Iyesu natere ki kamadubu bau-wena kayawena manako maramara tondawa wateya ripa ‘oripi’ wenatagubu kweyai ki kawareya yapu. E tadeyau kabukabuwa ragidai e ewakumamupu eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Mu kayatagubu kaiwa da ika bautagubu ka Iyesu mu tadebu, wagubu ke; “Wi yewe guriguriwogoi idiwoi kwaenda gwede berokoi mosi baiyagisi wi kerapugau yadini.” ");
INSERT INTO gdn_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","E inako wagubu manako kamadi-tapu kanibu nu bowa kwenupemei kaniyau da kasiyarai kewowagau surau ki rowarowai makai maba ika kwarisi-wena e ramatai kawareya ubupu manako e ebo mena ika e Mamai bameya guriguriwagawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","E guriguri yau guriguriwena, wagubu ke; “Mamai, kau nuwageya ki kau nuwaboya karako kapa tegebi ki wadi kwenupi. Ko kau kaubo nuwageya ki kwaenuwagi ko eba nau nuwaneya ki kau kwaenuwagi.” ");
INSERT INTO gdn_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","E inako guriguri-wena makeya ka aneya mo kunumau kawapu e togipupu kasiyara kwebu. ");
INSERT INTO gdn_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","E mibi nuwaboyai e Mamai bameya kawareya kawareya ragiragi kawaya ade guriguriwagawa manako e kiyabuiya ka muya dara maba bau-wagawa wairau tompiyawa. ");
INSERT INTO gdn_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Iyesu inako guriguriwagawa tondawa da kamadubu ka e ade kipu ubupu kanibu e tadeyau kabukabuwa ragidai mu bamamugu bauwena manako mu nuwaboyatagubu ki pokere wairorotagubu ika ukwapamawa emitapu. ");
INSERT INTO gdn_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Emitapu ka e tadebu, wagubu ke; “Wi gwede oroi wadamu? Wi kimuri ubumuri guriguriwogoi kwaenda gwede berokoi mosi baiyagisi wi kerapugau yadini.” ");
INSERT INTO gdn_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Iyesu yona ki wagawa makeya ka e tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya ki apunai mosi si ka Diyudiyasi iyapana ropani kawaya waratapu umunamawa mete ika bau-tagubu. Apunu Diyudiyasi ubupu Iyesu paraupana kiyauyaupana ki nana yabadubu e bameya bauwena, ");
INSERT INTO gdn_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ko Iyesu e empupu, wagubu ke; “Diyudiyasi, kau gwede nana nau Kunumau Kawa-puwani Apunai kiyauyau pokaiya nau nidani nuwegei?” ");
INSERT INTO gdn_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Iyesu e tadeyau kabukabuwa ragidai mu bamamugu badidi wena-wagana kwaewagawa ki emupu ka mu Iyesu simupu, tagubu ke; “Kaiwawo-nuga, nu kerebanuga pokaiya taububara-nuga ubumamu bo?” ");
INSERT INTO gdn_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Mu inako tagubu manako mu mosi garugaru mena ubupu e kerebai wadubu iyara apunai ki mosi e wenagui mebu puru. Bidara wadubu apunai ki e ka Mamanuga God bameya dobopiyamu ragidai mu kawaimaga e bigabigai apunai mosi. ");
INSERT INTO gdn_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Ko Iyesu mu tadebu, wagubu ke; “Kamadumuri, wi inako mo eba kwaiwagi.” E inako wagubu manako e idai roronapupu bidara wadubu apunai ki e wenagui kawareya tapu iyapupu. ");
INSERT INTO gdn_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Iyesu wirawena Mamanuga God bameya dobopiyamu ragidai, Mama-nuga God e Tawai ki kwayubapiyamu ragidai ade iyapana kawakawai dai ki mete ika bautagubu ki mu tadebu, wagubu ke; “Nau ka eba yawiyawirai ko wi gwede nana ta yo kepata temupu nau yawirani baigubu? ");
INSERT INTO gdn_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Nau mara-mara Mamanuga God e Tawai rabineya iyapana tadeyekeya kabukabuwa tondekeya ko wi badidi pokere mara ki makeya nau eba wadisinimupu? Ko wi maraga karako wana bauwena da sisipu e kasiyarai kawayayogono yarono.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Iyapana ki Iyesu wadumpu dokodoko kayatagubu kaiwa da Mamanuga God bameya dobopiyamu ragidai mu kawaimaga e tawaiya bautagubu. Ko apunu Pita mu ewamugu weki gwaiya kaniyawa. ");
INSERT INTO gdn_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Iyapana ika imatau mata pasumpu idiwa ki pokere Pita ika bauwena ka e kanibu mu paunamugu mata empiyawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ko bigabiga munu ridai mosi Pita ika mata empiyawa tondawa empupu ki ka e iyapana ika idiwa ki tadebu, wagubu ke; “Apunu ki kena ka mu wadumupu apunai e waretai mosi e kiyabui diyayai empakani.” ");
INSERT INTO gdn_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","E inako wagubu ko Pita e midi minibu denai sibu, wagubu ke; “Ridi, kau apunu ki nene nuwegei ki e nau eba kataineya.” ");
INSERT INTO gdn_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Eba rowarowa eweya ka apunu mosi bauwena Pita ika empupu manako sibu wagubu ke; “Nau kataineya da kau ka mu wadumupu apunai ki e waretai mosi.” E inako wagubu ko Pita denai ade wagubu gogagoga, wagubu ke; “Kabai, nau pa mena.” ");
INSERT INTO gdn_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Madega napusi eyaka mena kwaitana kewowena eweya ka apunu ade mosi bauwena ragiragi kawaya wagubu ke; “Apunu ki kena ka tawana Gariri ragidai mu iyapanamaga ki pokere nu kataigibi wetawetara da e ka wadumupu apunai ki e mete iwa apunai mosi.” ");
INSERT INTO gdn_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Ko Pita denai ade wagubu ke; “Kabai, kau badidi nuwegei ki nau eba kataineya.” E yona ki wagawa makeya ka e kokoroku daikere wagubu wainapupu. ");
INSERT INTO gdn_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Ko nu Kaiwawonuga wirawena Pita ika empupu manako ki makeya ka apunu Pita e wenagui paparawena Iyesu yona naiya wagubu ki wainapupu. Iyesu naiya e sibu, wagubu ke; ‘Kemora yau rabineya ki kau mara apeya eyaka nuwogowa bodaboda da kau eba kataigeya nau manako ki eweya ka kokoroku yagisi nawaru puruyagisi.’ ");
INSERT INTO gdn_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Iyesu naiya inako wagubu ki makeya makeya Pita wainapupu manako e rabinai makariwena kipu ubupu gari tagaiya kayawena yadi kawaya daganani kipu. ");
INSERT INTO gdn_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Iyara ragidai Iyesu wadumupu dokodoko ki mu ubumpu e waegeya-geyamapamawa ade minimawa, ");
INSERT INTO gdn_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ade e yabui bodapamawa, siyamawa, tagamawa ke; “Kau pa yabaragi pokaiya nuwagi da nu wainapamu; Ki nima nunibu?” ");
INSERT INTO gdn_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Mu inako tagamawa ade kira yonai ebo ebo e mete siyamawa wereyakaurapamawa. ");
INSERT INTO gdn_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Nawaru puruwena ka iyapana kawakawai, Mamanuga God bameya dobopiyamu ragidai mu kawakawai-muguma, ade Mamanuga God e gorai kataimugu ragidai mete kina Iyesu pari wirawirapamana ki nana ika bautagubu dibimupu idiwa. Mu Iyesu wadamana yabaramugu tamana ki nana tagubu, ");
INSERT INTO gdn_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","manako e bauwena ka mu e manu-mupu, tagubu ke; “Kau karako matarau nidi da nu wainapamu; Nu Iya Nege-yana Apunai Keriso ki kau baganai bo?” Mu inako tagubu ko Iyesu denai wagubu ke; “Nau wi matarau nidiyani ki wi nau eba sumasinimuri, ");
INSERT INTO gdn_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ade nau wi manuniyani ki wi denai nau eba sidimuri wainapakani. ");
INSERT INTO gdn_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Ko mara karako ade ewa ka Mamanuga God Kasiyarai Kawaya Esida Apunai e idai garu deneya ka nau Kunumau Kawa-puwani Apunai ika tondoni ki wi nau emisinimuri.” ");
INSERT INTO gdn_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","E inako wagubu ki pokere mu denai e simupu, tagubu ke; “Kau inako nuwagibi ki kau mete nuwegei da kau ka Mamanuga God e eya Gubagai bo?” Ko e denai wagubu ke; “Wi wiga iwagubu da nau ka eyo.” ");
INSERT INTO gdn_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Iyesu yona ki wagubu makeya ka kawakawai ragidai ki denai tagubu ke; “E eya wagubu ki nu kuduba wainamipi kewowena ki pokere e kwaewena siyasiya ki mibai tagamana matara ragidai ki mu nene nu eba kwaene-igomu.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Kawakawai ragidai kuduba kimpu ubumpu Iyesu wadumpu kayatagubu apunu Pairasi bameya bautagubu e yabareya tamupu, ");
INSERT INTO gdn_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","manako Iyesu naripamawa tagamawa ke; “Apunu yau nu iyapananuguma mu kerapumugu wadawa waratamiyawa yawata kwaiya kayawagawa ki nu e emipi matara ki pokere nu e wadimpi yewe baigibi. Nu kawainuga Sita e bameya wairanuga denai takesi tamana kwaigemeya ki e nu bodabodaniyawa ade e eya wagawa da e ka nu Kaiwawonuga ade nu Iya Negeyana Apunai Keriso.” ");
INSERT INTO gdn_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Iyapana inako tagubu ki pokere apunu Pairasi wirawena Iyesu manu-pupu, wagubu ke; “Kau Diyu ragidai mu kaiwawomaga kawai ki kau baganai bo?” E inako manupupu, manako Iyesu denai wagubu ke; “Ki kau ba nuwegei.” ");
INSERT INTO gdn_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Apunu Pairasi yona ki wainapupu ka e wirawena Mamanuga God bameya dobopiyamu ragidai ade iyapana ropani kawaya ika dibimupu idiwa ki mu tadebu, wagubu ke; “Apunu yau e paerei mo nau eba bananapuwani da nau ki pokaiya nau idani gurai e naureya ugwadani ragiragi.” ");
INSERT INTO gdn_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Ko iyapana ki mu ragiragi kawaya ade tagubu ke; “Apunu yau e uburau e kabuwai pokaiya nu iyapananuguma mu rabinamaga wadau gayagaya. E naiya tawana Gariri rabineya kwae-wagawa umawa da karako yewe Diyudiya rabineya bauwena inako mete kabuwawagau umau.” ");
INSERT INTO gdn_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Apunu Pairasi yona ki wainapupu ka e mu manutapu, wagubu ke; “Apunu yau e ka tawana Gariri ragidai mu iyapanamaga mosi bo?” ");
INSERT INTO gdn_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","“Ena, e ka tawana ki apunai.” Mu inako tagubu ki pokere apunu Pairasi ubupu Iyesu wadubu tawana Gariri ragidai mu kawaimaga si ka Erodi bameya tonopupu. Mara ki makeya ka apunu Erodi ika natere Diyerusaremu rabineya daiyo bauwena. ");
INSERT INTO gdn_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Apunu Erodi Iyesu empupu ki ka e rabinai bagiwena mibai ka e rowarowa kawaya Iyesu sisiyai mena wainapiyawa ade e empana ki nana mete waina-piyawa. E nuwaiya ka Iyesu kunuma kasiyarai pokaiya matakira dai kwaewagana da e empana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","E manu ebo ebo Iyesu manupiyawa ko Iyesu yona denai mo eba wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Mamanuga God bameya dobopiyamu ragidai ade e gorai kataimugu ragidai mete kina ki kaimpu Iyesu madaneya ubumpu e ragiragi kawaya naripamawa. ");
INSERT INTO gdn_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Apunu Erodi e piyaraiyoma mete kina Iyesu bainamapamawa ade e waegeyageyamapamawa da kama-dumpu ka mu midi tatamai bagi kawaya mo wadumpu umampu kwempu manako tonomupu wirawena kaiwawo Pairasi bameya ade kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Naiya ka apunu Pairasi yo apunu Erodi mu nuwarara tagarara idiwa ko mara ki makeya ka mu waretatagubu nuwa-maga notamaga eyakamenawena. ");
INSERT INTO gdn_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Apunu Pairasi ubupu Mamanuga God bameya dobopiyamu ragidai, iyapana kawakawai ade iyapana kuduba mete kina ki mu nene wagubu bautagubu, ");
INSERT INTO gdn_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","manako tadebu, wagubu ke; “Wi apunu yau wadumupu nau yabaraneya tamupu manako iwagubu da e ka iyapana kerapumugu wadawa ade waratamiyawa yawata kwaiya kayatagamawa. E paerei nene ki nau wi yabaragau e manupuwani, ko wi e siyamu wirawira ki mibai mo nau eba bananapuwani. ");
INSERT INTO gdn_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Apunu Erodi e mete kina apunu yau e paerei mo eba bana-pupu ko e ade pa tonopupu wirawena nau bamaneya bauwena ki pokere nau nidiyakani yau kena; Apunu yau gwede mo eba kwaewena siyasiya da e ki pokaiya denai poyagisi. ");
INSERT INTO gdn_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","17","Nau piyara ragidai tadeyani da mu pa wikuku pokaiya e raukekepomoto manako ewa tonopomoto baiyagisi kayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Iyapana ropani kawaya ika idiwa apunu Pairasi wagubu ki wainamupu ki ka mu bonanamaga ragiragi kawaya patamupu, tagubu ke; “Wi apunu yau minimuri poyo ko nu nene ka wi apunu Barabasi e idai rikapumur da e baiyagisi kayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Naiya mena ka apunu Barabasi natere Diyerusaremu rabineya iyapana waratapu kawakawai ragidai mu yawiramaga bautagubu. E iyapana dai mete namutapu ki pokere gwawai ka piyara ragidai e wadumpu dibura-mupu.) ");
INSERT INTO gdn_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Apunu Pairasi e nuwaiya ka Iyesu e idai rikapana bauwagana kayawagana wainapiyawa ki pokere e iyapana notamaga wirawagana ki nana mu ade tadebu. ");
INSERT INTO gdn_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Ko mu denai mu bonana-maga ragiragi patapamawa, tagamawa ke; “Ripa korosi naureya minimuri poyo. Ripa korosi naureya minimuri poyo.” ");
INSERT INTO gdn_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Mu inako tagubu, ko apunu Pairasi mu kawareya ade tadebu, wagubu ke; “E poyagisi ki mibai ka badidi? E bera berokoi badidi kwae-wena? Apunu yau gwede mo eba kwaewena siyasiya da ki pokaiya e denai poyagisi. Nau piyara ragidai tadeyani da mu pa wikuku pokaiya e raukekepomoto manako ewa tono-pomoto baiyagisi kayayagisi.” ");
INSERT INTO gdn_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Apunu Pairasi inako wagubu ko tawana ki ragidai mu bonanamaga ragiragi kawaya ade patapamawa, tagamawa ke; “Ripa korosi naureya minimuri poyo.” Mu kawareya kawareya inako patapamawa idiwa da siyareya ka mu yonamaga ki mibai wenapupu. ");
INSERT INTO gdn_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Apunu Pairasi wainapupu da baganai manako e iyapana ki mu umunumaga wadubu Iyesu minimana po ki yonai wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Iyapana nuwa-mugu ki makeya makeya ka apunu Pairasi ubupu iyapana waratapu ade dai mete namutapu apunai Barabasi e idai kerarai rikapupu bauwena kayawena ko Iyesu ka e wadubu iyapana idamaga rabineya tapu da mu e bameya badidi kwaetagamana notapamawa ki mu kwaetagamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Piyara ragidai ki Iyesu wadumpu kayatagamawa ka mu tawana Sairini apunumaga mosi si ka Saimoni ika gari tagaiya yabadawa bananamupu. Mu simupu da e Iyesu waitapana ripa korosi ki kawarapana tagubu ki pokere e Iyesu eweya ubupu ripa korosi ki kawarapupu. ");
INSERT INTO gdn_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Iyapana ropani kawaya Iyesu ewakumapamawa mu paunamugu ka ridi dai e nene yadi wadamawa ade e apenai meyamawa. ");
INSERT INTO gdn_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ko Iyesu wira-wena mu emitapu manako tadebu, wagubu ke; “Ridi kuduba natere Diyerusaremu ragidai, nau nidiyani wainapumuri; Wi nau nene eba yadi wadoi ko wi wiga nene ade wi munuguma ki mu nene yadi wadoi. ");
INSERT INTO gdn_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Mara yabadau da iyapana tagisi ke; ‘Ridi kagara munu eba wenatampu ade munu amu eba tageyamu ridai ki mu mamamatogomono.’ ");
INSERT INTO gdn_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Mara ki makeya ka iyapana kweya siyomoto, tagisi ke; ‘Kweya, kau purunuwagi kawari utaniyo’, ade kwaunai mo siyomoto, tagisi ke; ‘Kau utaniyo da nu kau gwaiyageya idiwomu.’ ");
INSERT INTO gdn_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Iyapana karako ubumu ripa kasiga e bameya berokoi kwaetagamu ki ka ripa sura-yogono makeya ki mu berokoi badidi kwaetagisi?” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Mu Iyesu minimana po ki nana wadumpu kayatagamawa ka mu iyapana apeya bera berokoi kwaetagubu ki denai taunimana popo ki mete waratampu. ");
INSERT INTO gdn_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mu kayatagubu yamawa da kweya mo si ka ‘Deba Suwana’ tagubu ki ika bautagubu ka mu Iyesu ripa korosi naureya ikokomupu manako iyapana apeya beramaga berokoi ki mete ika ikokotampu, mosi e idai garu deneya ade mosi e idai tenene ki deneya. ");
INSERT INTO gdn_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ko Iyesu e Mamai paraupupu, wagubu ke; “Mamai, iyapana karako nau bamaneya badidi kwaetagamu ki mu bigimaga kau deni mena surupi notagogapi. Mu badidi kwaetagamu ki mibai mu muga eba kataimugu.” Piyara ragidai ki mu nuwamugu ka Iyesu e midi tatamai wadamana waina-mupu ki pokere mu yanuwa marai munta mo kwaetagubu manako nima si yanuwa ki rabineya yabiri bauwena ki e ubupu Iyesu midi tatamai ki e wadubu. ");
INSERT INTO gdn_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Iyapana ika gayopamawa ubu-mawa ade Diyu ragidai mu kawakawai-muguma mete kina ki mu ewapuru Iyesu waegeyageyamapamawa, tagamawa ke; “E naiya iyapana dai iyatamiyawa ki pokere e mibai nu Iya Negeyana Apunai Keriso maba ki Mamanuga God e winepupu kawapu ki ka e ebo kasiyarai pokaiya iyayagisi ripa korosi ki kamadini kaworoto da nu empamu.” ");
INSERT INTO gdn_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Piyara ragidai dai ika bautagubu ki mu mete ubumpu e waegeyageyama-pamawa ade awana suwakarai mo si ka ‘winiga’ wadumpu e kubarana ki nana kwempu, ");
INSERT INTO gdn_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","manako simpu, tagubu ke; “Kau mibai Diyu ragidai mu kaiwawo-maga ki kau kiya iyanuwagi da nu kau eminiyamu.” ");
INSERT INTO gdn_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ko Iyesu e kawareya ka mu oka mosi ripa naureya minimupu. Oka ki wagubu ke; ‘Yau ka Diyu Ragidai mu Kaiwawomaga.’ ");
INSERT INTO gdn_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Apunu berai berokoi mosi ki mu ika Iyesu madani daikere ikokomupu ki e mete kina ka Iyesu waegeyageyama-pupu, wagubu ke; “Kau Keriso baganai ki kau nuwagi da nu yo kau ewapuru iyaigamu.” ");
INSERT INTO gdn_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Ko e waretai ika Iyesu madanai daikere ikokomupu ki e waretai ki nakaripupu sibu, wagubu ke; “Kau Mamanuga God e kudeya wainapiyei bo pa mena? Mu idamaga gurai nu naurinugu mete ugwadumpu ragiragi. ");
INSERT INTO gdn_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Nu ka bera berokoi kwaigemeya ki pokere bimbinai nu karako bita yau wademei ko apunu yau e ka bera berokoi mo inako eba kwaewena.” ");
INSERT INTO gdn_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","E inako wagubu manako ade wirawena Iyesu sibu, wagubu ke; “Iyesu, kau kasiyaragi pokaiya tondowa ki makeya ki kau nau eba notagogasini.” ");
INSERT INTO gdn_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","E inako wagubu ko Iyesu e empupu manako denai sibu, wagubu ke; “Nau suwagani wainapi; Karako ka nau yo kau ewapuru mena Paradaisi kaigamu.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Madega paunau wadawa ki makeya ka tawana kuduba sisipu umapu ko ade madega kanibu kekera-wagawa napusi apeya eyaka wadawa ki makeya ka sisipu ki ade negawena. ");
INSERT INTO gdn_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","Ki makeya ka aukwara mosi Mamanuga God e Tawai rabineya gudu maba uburawa ki paunau tegerewena. ");
INSERT INTO gdn_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Ko Iyesu e bonanai ragiragi kawaya wagubu ke; “Mamai, nau keyaini ki nau kau idageya tarakani.” E inako wagubu manako e nonai toporuwena powena. ");
INSERT INTO gdn_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Piyara ragidai mu kawaimaga mosi ika Iyesu yabareya uburawa ki badidi wenawena empupu ki ka e Mamanuga God e si esida tepapupu, wagubu ke; “Mibai, apunu yau e ka bagi supasupai apunai mosi karako powena yau kena.” ");
INSERT INTO gdn_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Iyapana ropani kawaya ika gayo bautagubu ki badidi wenawena emupu ki ka mu mibi nuwaboyai mu tagamaga wiramupu tawamugu tawamugu ade kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Ko Iyesu e ebo kowai-yoma ade ridi dai ki Iyesu naiya tawana Gariri rabineya umawa wadawa mete ewakumapamawa iwa ragidai ki mu ika uwamautau Iyesu empamawa ubumawa. ");
INSERT INTO gdn_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Diyu ragidai mu kawaimaga mosi si ka Diyosepa. E naterei ka Arimateya tawana Diyudiya rabineya. E berai ka bagi supasupai kawaya ki pokere iyapana e werei tagamawa. E maramara Mamanuga God notapiyawa ade Mamanuga God e gari rabineya kaiwana idiwana ki marai bauwagana ki nawanai e mete tondawa. E ka Diyu ragidai mu kawaimaga mosi ko e kowaiyoma Iyesu bameya badidi kwae-tagamana tagubu ki e eba mibipupu. ");
INSERT INTO gdn_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Apunu Diyosepa kipu ubupu kayawena apunu Pairasi e yabareya ubupu manako Iyesu kwakwarepui wadana ononopana ki genei wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Ki eweya ka e kayawena Iyesu kwakwarepui ripa korosi naureya wadubu kwarisi manako aukwara mo pokaiya gerowopupu wadubu ragu mosi ki iyapana mu idamugu ukwamupu ki rabineya tapu. Ragu ki rabineya ka mu iyapana mo naiya ika eba ononomupu. ");
INSERT INTO gdn_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Karako ka bagibagi siyarai ko marawani ka Diyu ragidai mu aiyata-maga marai ki pokere karako kemora nene ka iyapana okukunatagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ridi ki tawana Gariri rabineya Iyesu ewakumapamawa iwa da ika bautagubu ragidai ki mu apunu Diyosepa eweya kayatagubu manako e Iyesu kwakwarepui badidi maba ragu tapu ki mu yabumugere emupu. ");
INSERT INTO gdn_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Mu ade wiratagubu mu tawamugu kaya-tagubu manako ripa otai aurai bagibagi dai mete okukunatagubu Iyesu kwakwarepui monagapamana ki nana nakamupu. Ko Diyu ragidai mu gora-maga wagubu ki mu makeya makeya kwaetagubu aiyata marai ki makeya pa aiyatatagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Pura kawai nawaru dumai tarawa ki makeya ka ridi ki kimpu ubumpu ripa otai aurai bagi kawaya naiya okukunatagubu ki tempu ragu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Mu ika bautagubu ka mu bowa kawaya ragu umunai minimpu bodampu ki gwairiwena emupu. ");
INSERT INTO gdn_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Mu ragu rabineya kaimpu ko nu Kaiwawonuga Iyesu e kwakwarepui ki mu ragu rabineya mo eba emupu, ");
INSERT INTO gdn_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ki pokere mu notamaga babawena. Garugaru mena ka iyapana apeya mu midimaga tatamai sinini tanai kawaya ki bautagubu ika madanimugu ubumpu. ");
INSERT INTO gdn_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Ridi ki wiratagubu mu emitampu ka mu didiguramaga wagubu kudu kwarisitagubu nikapu mempu. Ko iyapana apeya ki tagubu ke; “Wi gwede nana baigubu iyawena tondau apunai ki e kwaenei yewe popai ragidai mu watamugu kwaeneiwagamu? ");
INSERT INTO gdn_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","E yewe eba ukwarau ko e iyawena kipu ubupu. E naiya tawana Gariri rabineya wi badidi nidibu ki wi wainamupu bo pa mena? ");
INSERT INTO gdn_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","E nidibu, wagubu ke; ‘Mu ubumoto Kunumau Kawapuwani Apunai nau wadisinimoto iyapana beramaga berokoi mu idamaga rabineya nau tamusinimoto. Mu wadisinimoto ripa korosi naureya nau susinimoto poyo ko mara apeya eyaka kewoyagisi eweya ki nau ade iyasugani kirani uburani.” ");
INSERT INTO gdn_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Ridi ki iyapana apeya yona tagubu ki wainamupu ki ka mu notamaga paparawena Iyesu naiya badidi tadebu ki mibai mete wainamupu, ");
INSERT INTO gdn_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","manako mu ragu ki kamadumpu wiratagubu kayatagubu badidi wenawena emupu ki sisiyai mu Iyesu tadeyau kabukabuwa ragidai ida esida kewowena kerapu eyaka mena ade iyapana dai mete kina ika idiwa ki mu tademupu. ");
INSERT INTO gdn_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ridi ki mu simaga ka yau kena; Meri Magidarini yo Diyona yo apunu Diyemesi e inai si ka Meri. Ridi ki ade ridi dai mete kina mu badidi yabumugere emupu ki sisiyai kuduba mu Iyesu tonotapu ragidai tademupu, ");
INSERT INTO gdn_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ko mu yona ki waina-mupu ka mu ubumpu ridi ki bera umani tadempu, mibai ka mu wainamupu da ridi ki bani babatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Ko apunu Pita yona ki wainapupu ka e kipu ubupu garupupu ragu empana kayawena. E ika bauwena ka e kuwena ragu rabineya yabu tapu manako gerowo mena ika ukwarawa empupu ko gwede mo ika eba empupu. E notai kowena manako e wirawena tawau kayawena ki ka e badidi wenawena empupu ki mena notapiyawa kaniyawa. ");
INSERT INTO gdn_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Mara eyaka mena ki makeya ka Iyesu e tadeyau kabukabuwa ragidai apeya natere kawaya Diyerusaremu kamadumpu natere Emeyasi kaya-tagubu. (Natere Emeyasi ka eba natere Diyerusaremu bameya ko yawata ki ka rowarowaitau.) ");
INSERT INTO gdn_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Mu yawata ki kaya-tagubu kaiwa ka mu natere Diyerusa-remu rabineya badidi wenawena ki sisiyai tagamawa, ");
INSERT INTO gdn_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","manako ki makeya ka Iyesu mu tagamugu bauwena mu madanimugu ubupu mete kayatagubu kaiwa. ");
INSERT INTO gdn_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","E mete kayatagubu kaiwa ki mu emupu ko mu notamaga surupupu ki pokere mu e gogomupu. ");
INSERT INTO gdn_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Mu e gogopamawa ko e eya mu manutapu, wagubu ke; “Wi gwede yonai yewe deni deni iwagamu kaiwu?” Iyesu inako wagubu ki ka iyapana ki mu kiyabumaga nuwaboya kiyabui ubumupu, ");
INSERT INTO gdn_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","manako apunu ki mosi si ka Kiropasi denai Iyesu inako sibu, wagubu ke; “Natere Diyerusaremu rabineya mara badibadi taganugu kayawena ki rabineya badidi wenawena ki iyapana kuduba kataimugu ko bani kau mena eba kataigeya bo?” ");
INSERT INTO gdn_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","E inako wagubu, ko Iyesu denai wagubu ke; “Gwede wenawena?” E inako wagubu manako mu denai e simupu, tagubu ke; “Nu ka tawana Nasareta apunai Iyesu e sisiyai iwegemei. E ka Mamanuga God e bonanai wainapiyawa wagawa apunai mosi. E yonai ka kasiyarai kawaya ade e Mamanuga God yabuiya nu paunanugu badidi wagawa kwaewagawa ki ka iyapana kuduba nu yabunugere empemeya. ");
INSERT INTO gdn_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Ko Mamanuga God bameya dobopiyamu ragidai ade nu kawakawainuguma mete kina ki mu e wadumpu piyara ragidai mu idamaga rabineya tamupu manako mu ubumpu mu idamaga gurai e naureya ugwa-dumpu ragiragi manako ripa korosi naureya minimupu poyo. ");
INSERT INTO gdn_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Nu nota-mipi da e ka tawana Isiraero ragidai nu bitanuga rikapana ade nu iyaniyana wadiniyana bagi ki apunai, ko e karako powena. Ko ade wainapi; Mu ubumpu e ripa korosi naureya minimpu poyo ka mara apeya eyaka kewowena, ");
INSERT INTO gdn_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","23","ko karako didiburu nawaru dumai tarawa makeya ka ridi dai nu mete idiwei ki kimpu ubumpu ragu ki rabineya Iyesu kwakwarepui tampu ki empamana ki nana kayatagubu. Mu ika bautagubu ka mu e kwakwarepui eba emupu ki pokere wiratagubu bautagubu nu nidimupu, tagubu ke; ‘Nu aneya dai waro were maba ika emitampi ki nu nidimupu, tagubu ke; ‘Iyesu e ka ade iyawena kipu ubupu’. Ridi ki bautagubu inako tagubu ki ka mu naininimupu wakapa girigibi, ");
INSERT INTO gdn_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","manako nu kowanuguma dai kimpu ubumpu ragu ki empamana ki nana kayatagubu. Mu ika bautagubu ka mu ridi ki badidi tagubu ki makeya makeya emupu ko mu Iyesu e eya eba emupu.” ");
INSERT INTO gdn_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Iyapana apeya ki inako tagubu ko Iyesu denai mu tadebu wagubu ke; “Wi ka notababa ragidai. Takari kawaya Mamanuga God e bonanai waina-pamawa tagamawa ragidai badidi tagubu oka tampu ki wi garugaru eba wainapiyamu sumapiyamu. ");
INSERT INTO gdn_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Mu ororeya mena tagubu da Keriso yabiri bita ade midi makari bananapoto were ewa kunumau kayayagisi Mamanuga God e kasiyarai pokaiya e taneya tondono, ko oka ki wi bani eba kataigubu bo?” ");
INSERT INTO gdn_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Iyesu inako wagubu manako ubupu oragai apunai Mosisi ade Mosisi eweya Mamanuga God e bonanai wainapamawa tagamawa ragidai kuduba Iyesu nene oka badidi tampu ki kuduba makeya makeya mu kabuwatamiyawa kaniyawa. ");
INSERT INTO gdn_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Mu kayatagubu kaiwa da natere Emeyasi bautagamana kwaetagamawa ka Iyesu gwe mu kamaditamana tawana mo kayawagana diyayai kwaewagawa, ");
INSERT INTO gdn_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ko mu e munamupu, tagubu ke; “Tawana kemorawagau ki pokere nu mete yewe ukwapamu.” Mu inako tagubu manako Iyesu mu mete tawau kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Mu tawau bautagubu idiwa da kupetagamana kwaetagamawa ka e ubupu bani buredi mo wadubu e Mamai bameya parauwena manako gerepupu piripiri tagebu. ");
INSERT INTO gdn_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","E tageyawa makeya ka iyapana ki mu notamaga paparawena e kiyabui matarau emupu manako ki makeya ka Iyesu gogawena bani kayawena manako mu e ewa eba emupu. ");
INSERT INTO gdn_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Ko mu mubo deni deni tagubu kasiwara, tagubu ke; “Nu yawatau e mete iwegemeya kebomeya manako e Mamanuga God e yonai ki mibai matarapiyawa kabuwaniyawa wainamipi ki ka yona ki nu geyanibu nu rabinanugu mata maba urabu.” ");
INSERT INTO gdn_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Mu inako tagubu manako garu-garu mena kimpu ubumpu wiratagubu natere Diyerusaremu kayatagubu manako Iyesu e tadeyau kabukabuwa ragidai ida esida kewowena kerapu eyaka mena ade iyapana dai mete kina ika dibimupu idiwa ki mu bamamugu bautagubu. ");
INSERT INTO gdn_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Bautagubu ka iyapana ika idiwa ki ubumpu mu tademupu tagubu ke; “Nu Kaiwawonuga ade iyawena kipu ubupu ki mibai. Apunu Saimoni e Iyesu matarau empupu.” ");
INSERT INTO gdn_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Mu inako tagubu manako iyapana apeya ki ubumpu Iyesu ika yawatau banana-mupu mu yabumugere badidi emupu ki sisiyai kuduba mu kowamuguma tadempu, tagubu ke; “E bani buredi gerepupu nu negeyawa ki makeya ka nu notanuga paparawena manako nu e kiyabui matarau emipi.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Iyapana apeya yona ki tagamawa makeya ka Iyesu e eya garugaru mena bani bauwena mu paunamugu ubupu manako tadebu, wagubu ke; “Wi notaga kwarisiyagisi nuwabagi rabineya idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","E inako wagubu ko mu notamaga kowena kudu mete wainapamawa. Mu notamaga wagubu da mu bani guba mo bauwena emupu. ");
INSERT INTO gdn_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Ko Iyesu mu ade tadebu, wagubu ke; “Wi gwede nana didiguraga wagau? Ade wi gwede nana wi rabinagau nota apeya apeya waina-piyamu? ");
INSERT INTO gdn_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Nau idani kerarani empu-muri ki ka wi kataiwagi da yau ka nau. Ade wi nau geyasinimuri ki ka wi mete kataiwagi wetawetara da nau ka eba guba mosi. Guba ka pa keyai ade e midi kwakwarepui ka pa mena, ko nau midini kwakwarepuni mete kina.” ");
INSERT INTO gdn_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Iyesu inako wagubu manako e idai kerarai mu kabuwatapu. ");
INSERT INTO gdn_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Mu mamamatagubu ko mu notababa mete wadumpu ade mu yabumugere badidi emupu ki mu eba sumamupu ki pokere Iyesu mu manutapu, wagubu ke; “Bani boromai mo wi bamagau mete kina bo?” ");
INSERT INTO gdn_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","E inako wagubu manako mu raubiyo boromai ki pirai daikere wadumpu e kwempu, ");
INSERT INTO gdn_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","manako e raubiyo ki wadubu mu yabumugu kubabu. ");
INSERT INTO gdn_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ko iyesu mu ade tadebu, wagubu ke; “Oragai apunai Mosisi ade Mamanuga God e bonanai waina-pamawa tagamawa ragidai ade oka Umayo okamupu ragidai ki mu kuduba nau nene badidi tagubu oka tampu ki mibai kuduba karako wenawena yau kena. Nau naiya wi mete idiweya ki ka nau yona ki wi mete nidiyekeya.” ");
INSERT INTO gdn_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","E inako wagubu manako mu Mamanuga God e okai kuduba ki mibai wainapamana ki nana ka e mu nota-maga gudui kwaipupu, ");
INSERT INTO gdn_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","manako tadebu, wagubu ke; “Naiya, takari kawaya ka mu Mamanuga God e okai inako tampu, tagubu ke; ‘Keriso yabiri bita ade midi makari bananapoto poyagisi manako mara apeya eyaka kewoyagisi eweya ki e ade iyayagisi kiroto uburoto.’ ");
INSERT INTO gdn_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Iyapana beramaga berokoi kamadamana mu nuwamaga notamaga wirawagana da Mamanuga God mu bigimaga empana deni mena surupana ki nana ki yonai ka wi nau kasiyarani pokaiya yabiri natere Diyerusaremu rabineya dimaiwogoi manako ewa kimuri ubumuri tawana tawana kuduba, madega kauwagau madega posiwagau ki kaiwagi iyapana tadeyoi iwoi. ");
INSERT INTO gdn_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Wi yau kuduba wi wibo yabugere emupu ki pokere matarau iwagi. ");
INSERT INTO gdn_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Nau nidiyani wainapumuri; Nau Mamai God wi puyo negeyana gwaiyabai wagubu ki nau wi bamagau tonopani. Ko wi natere yau eba kamadumuri ko yewe nawanaiwogoi da Mamanuga God e kasiyarai kunumau ki tonopoto wi kawarigau kaworoto miniyoto siwa were ewa ki wi kaiwagi nau dimani iwogoi iwoi.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ki eweya ka Iyesu e kowakowai-yoma waratapu natere ki kamadumpu kayatagubu natere Betani kikireya bautagubu manako e idai mu kawari-mugu bagipupu waditapu bagi. ");
INSERT INTO gdn_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","E mu waditamiyawa bagi ki makeya ka Mamanuga God e wadubu tepapupu e kasiyarai pokaiya kunumau yapu kayawena. ");
INSERT INTO gdn_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","E kowaiyoma e kayawena yarawa inako emupu ki ka mu e taraga-mupu manako mibi mamamai wira-tagubu natere Diyerusaremu ade kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Mu Mamanuga God e Tawai rabineya maramara Mamanuga God paraupamawa e si esida tepapamawa idiwa. Ika kewowena. ");
INSERT INTO gdn_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kunuma waira kerareya ka Yona Apunai tondawa. E ka Mamanuga God mete idiwa. Yona Apunai ki e ka ade God. ");
INSERT INTO gdn_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","E kunuma waira kerareya Mamanuga God bameya tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Gwedegwede kuduba mo bani eba bauwena ko Yona Apunai e pokaiya ka Mamanuga God gwedegwede kuduba yamatapu. ");
INSERT INTO gdn_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Yona Apunai ki e ka Iya Kerarai, ade Iya Kerarai ki e ka iyapana kuduba nu Dunanuga bauwena. ");
INSERT INTO gdn_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Duna ki tanai tawana sisipu minibu siwa ko tanai ki bodapamana yawatai mo pa mena. ");
INSERT INTO gdn_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Mamanuga God e ubupu apunu mo si ka Diyoni tonopupu bauwena. ");
INSERT INTO gdn_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","E tanai ki sisiyai iyapana tadeyana da mu e wagubu ki pokaiya Tanai Apunai ki sumapamana ki nana. ");
INSERT INTO gdn_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Apunu Diyoni e ka eba Tanai ki apunai ko e Tanai Apunai e sisiyai wagana ki nana bau-wena. ");
INSERT INTO gdn_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Tanai mibai kawapu yewe wairau bauwena karako iyapana kuduba nu kawarinugu miniyau siwa. ");
INSERT INTO gdn_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Yona Apunai kawapu yewe wairau tondawa. E pokaiya ka Mamanuga God waira yo kunuma kuduba yamanatapu, ko e bauwena ki ka e eya iyapanaiyoma e gogomupu. ");
INSERT INTO gdn_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","E eya tawaneya bau-wena ko e eya iyapanaiyoma mu nuwa-mugu ka e pa mena ade e diriwai ki mu eba kwaetagubu. ");
INSERT INTO gdn_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ko nu dai ki e diriwai kwaigibi sumamipi ki pokere Mamanuga God nu e munuiyoma nidibu. ");
INSERT INTO gdn_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Nu ka eba inanuguma mamanuguma mu pokamugere iya waunai ki wadimpi ko Mamanuga God e eya mena iya ki nu negebu. ");
INSERT INTO gdn_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Yona Apunai e iyapana kaina nu maba wenawena manako nu paunanugu tondawa. Mamanuga God e eya Gubagai eyaka mena ka eyo ki pokere e kasiyarai tanai bagi kawaya ki nu matarau emipi. E ka mibai kawaya. E nu deni mena nota kwarikwarisiniyau ki pokere nu bitanuga ki nu nubo wadamana ki e deni mena rikapupu manako puyo iya waunai nu negebu. ");
INSERT INTO gdn_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Apunu Diyoni ubupu e bonanai ragiragi kawaya Iyesu sisiyai iyapana tadeyawa, wagawa ke; “Nau naiya mena nidibuwani, suwagubuwani ke; ‘Nau ewaneya ka apunu mosi baiyagisi ko e ka apunu kawaya. Apunu ki e nau raurusinibu mibai ka e kunuma waira kerareya tondawa yabadawa da karako.’ Apunu ki nene suwegekeya apunai e karako bauwena yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Apunu ki nu kuduba deni mena notaniyau ade bagi mena kawareya kawareya nu negeyau. ");
INSERT INTO gdn_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Nu goranuga ki ka Mamanuga God ubupu oragai apunai Mosisi pokaiya nu negebu, ko yona mibai ade iya waunai ki puyoi ka e Iyesu Keriso pokaiya nu negebu. Nu bitanuga ki nu nubo wadamana ki e rikapupu manako deni mena nu wadinibu bagi. ");
INSERT INTO gdn_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Nu iyapana kuduba Mamanuga God nu yabunugere mo eba emipi ko e madaneya ka e eya Gubagai mena tondau. E ka e eya Mamai maba. E ka ade God ki pokere nu e kataipamu ki ka nu e Mamai mete kataipamu. (v28) Apunu Diyoni awana Diyoudani papasi buridere tawana Betani bameya iyapana siruwatamiyawa tondawa, ");
INSERT INTO gdn_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","manako Diyu ragidai mu kawakawaimuguma natere Diyerusaremu rabineya idiwa ki mu ubumupu Mamanuga God bameya dobopiyamu ragidai ade mu kobamugu upitagamu ragidai dai mete kina ki tonotampu apunu Diyoni bameya bautagubu manako manumupu, tagubu ke; “Kau ka nima?” ");
INSERT INTO gdn_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Ko apunu Diyoni denai yona mo eba wekepupu ko e matarau mu tadebu, wagubu ke; “Nau ka eba wi Iya Negeyana Apunai Keriso.” ");
INSERT INTO gdn_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","E inako wagubu ko mu e kawareya ade manumupu, tagubu ke; “Ko kau ka nima? Kau ka bani oragai apunai Eraidiya ade baunugibi bo?” “Ae, nau ka eba eyo.” Apunu Diyoni inako wagubu waina-mupu ka mu e ade manumupu, tagubu ke; “Mamanuga God e Bonanai Wainapiyei Nuwegei Apunai ki kau baganai bo?” “Ki pa mena, nau ka eba eyo.” ");
INSERT INTO gdn_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Apunu Diyoni inako wagubu, ki pokere iyapana e kawareya ade manumupu, tagubu ke; “Ko kau kiya nidi; Kau ka nima? Nu tononimpu ragidai kau yonagi denai wainapamana ki nawanai idiwu ki pokere kau kiya sisiyagi karako matarau nuwagi da nu wainapamu manako nu kaigamu mu tadeyamu.” ");
INSERT INTO gdn_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ko apunu Diyoni denai mu tadebu, wagubu ke; “Nau ka gwabau yonasugakani tondakani apunai. Mamanuga God e bonanai wainapiyawa wagawa apunai Aisaiya naiya wagawa tondawa ki kawareya nau karako ade suwagakani yau kena; ‘Kaiwawonuga e yawatai ki wi gwaba memuri da e taneya baiyagisi kayayagisi.’” ");
INSERT INTO gdn_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Apunu Diyoni manupamana empamana bautagubu ragidai dai ki ka Parisi ragidai. Mu e yonai ki waina-mupu ka mu e ade simupu, tagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","“Kau nuwagibi da kau ka eba nu Iya Negeyana Apunai ade kau ka eba oragai apunai Eraidiya ade kau ka eba Mamanuga God e Bonanai Wainapiyei Nuwegei apunai. Kau ki kuduba pa mena nuwegei ko kau iyapana gwede nana siruwatamiyei?” ");
INSERT INTO gdn_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ko apunu Diyoni denai mu tadebu, wagubu ke; “Nau uburakani awana pokaiya iyapana siruwa-tamakani, ko wi paunagau ka apunu mosi bauwena uburau ko wi e eba kataigau. ");
INSERT INTO gdn_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","E nau ewaneya bau-wena ko e ka ade apunu kawaya eba nau maba. Nau e bigabigai kwaesugana ko nau ka eba bagi da nau waitapani e kerarai kwakwarai ki taburubai rikapani.” ");
INSERT INTO gdn_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","(-) ");
INSERT INTO gdn_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Nawaru puruwena ka apunu Diyoni ubupu Iyesu ika yabadawa empupu manako e iyapana ika idiwa ki tadebu, wagubu ke; “Mamanuga God e Papa Sipi Munai burida yabadau ki wi empumuri. E ka iyapana kuduba, madega kauwagau madega posiwagau nu biginuga surupana kwenupana ki apunai. ");
INSERT INTO gdn_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Nau naiya suwagubuwani da; ‘Nau ewaneya ka apunu mo baiyagisi. E ka apunu kawaya eba nau maba, mibai ka e nau raurusinibu kunuma waira kerareya tondawa yabadawa da karako bauwena.’ Apunu ki nene suwegekeya ki apunai karako wana bauwena yau kena. ");
INSERT INTO gdn_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Wi tawana Isiraero ragidai e kataipamana ki nana ka nau bausugu-buwani manako awana pokaiya wi siruwaniyakani. Ko e kiyabui ki nau naiya mo eba empuwani.” ");
INSERT INTO gdn_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Apunu Diyoni Iyesu sisiyai inako wagubu manako ade wagubu ke; “E kiyabui nau naiya mo eba empuwani ko Mamanuga God e sidibu da nau awana pokaiya wi siruwaniyana ki nana manako ade sidibu, wagubu ke; ‘Nau niya Keyaini kaworoto apunu mo kawareya miniyoto siwa emani, apunu ki ka aita uburoto nau Keyaini Tanai Bagi Kawaya ki kasiyarai pokaiya iyapana siruwatamini’. E inako wagubu manako ki eweya ka nau Mamanuga God e eya Keyai midiwari umago maba kawapu apunu burida yabadau ki e kawareya tondubu empuwani. ");
INSERT INTO gdn_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Ki pokere nau nidiyakani yau kena; Apunu burida bauwena ki e ka Mamanuga God e eya Gubagai.” ");
INSERT INTO gdn_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Nawaru puruwena ka apunu Diyoni e kowakowaiyoma apeya mete ika idiwa, ");
INSERT INTO gdn_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","manako e yabu tapu Iyesu ika yabadawa empupu. Empiyawa manako e kowakowaiyoma ki tadebu, wagubu ke; “Mamanuga God e Papai Sipi Munai nu biginuga surupana ki nana bauwena ki yabadau buri empumuri.” ");
INSERT INTO gdn_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Mu yona ki wainamupu ka mu kimpu ubumpu apunu Diyoni kamadumpu manako Iyesu eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Mu Iyesu eweya kayatagubu kaiwa ka e wirawena mu emitapu manako manutapu, wagubu ke; “Wi nima kwaenepiyamu?” Ko mu denai tagubu ke; “Nidiyei Kabukabuwa Apunai, kau tawagi ka bani?” ");
INSERT INTO gdn_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","“Kebomuri empumuri.” Iyesu inako wagubu manako mu e bananamupu mete kayatagubu. Ko ki ka kemora nene, madega napusi apeya apeya wadawa makeya ki pokere mu Iyesu mete kaya-tagubu kaiwa da e tondawa tawaneya bautagubu ki ka mu kemora ki rabineya e mete ika ukwamupu. ");
INSERT INTO gdn_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Iyapana apeya apunu Diyoni e yonai wainamupu Iyesu ewakumamupu ki mosi ka Enduru. E tatai ka Saimoni si daikere ka Pita. ");
INSERT INTO gdn_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Apunu Enduru garugaru mena kayawena e tatai Saimoni kwaenepiyawa umawa da bananapupu manako sibu, wagubu ke; “Nu Iya Negeyana Apunai Keriso ki e nu matarau emipi.” ");
INSERT INTO gdn_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","E inako wagubu manako e tatai ki bananapupu Iyesu bameya kayatagubu. Mu bautagubu ka Iyesu yabu tapu apunu Saimoni ika yabadawa empupu, manako e sibu, wagubu ke; “Kau ka apunu Diyoni e gubagai. Kau sigi ka Saimoni ko nau kau sigi daikere Kepasi nidiyakani.” (Si Kepasi yo Pita ki ka yona eyaka mena ko ki mibai mu mubo yonamugere ka ‘bowa’.) ");
INSERT INTO gdn_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Nawaru puruwena ka Iyesu tawana Gariri kayawagana wainapupu. E apunu mo si ka Piripo ika yawatau bananapupu manako sibu, wagubu ke; “Kau yabi da nau mete kaigamu.” ");
INSERT INTO gdn_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","(Apunu Piripo e ka apunu Pita yo Enduru mu mete tawanamaga eyaka mena natere Betaida were bautagubu.) ");
INSERT INTO gdn_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Apunu Piripo ubupu kayawena e waretai Nataniyero bananapupu manako sibu, wagubu ke; “Mamanuga God e bonanai wainapamawa tagamawa ragidai ade oragai apunai Mosisi mete kina nu Iya Negeyana Apunai bauwagana sisiyai oka tampu, apunu ki karako bauwena nu yabunugere matarau emipi. E ka apunu Diyosepa e gubagai si ka Iyesu, tawana Nasareta were bauwena.” ");
INSERT INTO gdn_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Apunu Nataniyero yona ki waina-pupu ka e denai wagubu ke; “Gwede bagi mosi tawana Nasareta were eba bauwagana wainapakani.” Ko Piripo e ade sibu, wagubu ke; “Kau yabi emani.” ");
INSERT INTO gdn_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Iyesu apunu Nataniyero ika yabadawa empupu ka e iyapana ika idiwa ki tadebu, wagubu ke; “Apunu burida yabadau ki e wi empumuri. E ka tawana Isiraero taubanuwai. E bameya ka bera mo pa mena.” ");
INSERT INTO gdn_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Apunu Nataniyero bauwena e eya sisiyai Iyesu iyapana tadeyawa ki wainapupu ka e kanibu Iyesu manu-pupu, wagubu ke; “Nau naiya kau mete eba idiweya ko kau badidi maba nau kataisinibi?” Ko Iyesu denai e sibu, wagubu ke; “Kau waretagi Piripo nau sisiyani kau eba nidibu kau ripa damaya kerareya gwaiya buripo tondeya ki makeya ka nau yewe tondekeya kau eminibuwani.” ");
INSERT INTO gdn_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Apunu Nataniyero yona ki waina-pupu ka e denai wagubu ke; “Nidiyei Kabukabuwa Apunai, kau ka Mamanuga God e eya Gubagai. Kau ka tawana Isiraero ragidai nu Kaiwawonuga kawaya.” ");
INSERT INTO gdn_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Ko Iyesu denai e sibu, wagubu ke; “Nataniyero, kau ripa damaya kerareya gwaiya buripo tondeya manako nau yewe tondekeya kau eminibuwani ki sisiyai nidibuwani wainapipi ki pokere kau nau sumasinibi. Ko ki ka eba matakira kawaya mosi. Matakira kawa-kawaya ki kau ewa were emani.” ");
INSERT INTO gdn_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E inako wagubu manako wirawena iyapana ika idiwa ki tadebu, wagubu ke; “Nau yona mibai wi nidiyani wainapu-muri; Ewa ka wi kunuma gudui kwaipoto uburono empumuri ade Mamanuga God e eya aneyaiyoma Kunumau Kawa-puwani Apunai nau kawarineya yamono kawomono ki mete empumuri.” ");
INSERT INTO gdn_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","2","Mara apeya kewowena eweya ka tawana Gariri ragidai natere Kaina rabineya anika kupei mo kupetagubu manako Iyesu e inai mete kina ade e tadeyau kabukabuwa ragidai ika mete kupe ki kawareya bautagubu. ");
INSERT INTO gdn_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Mu kupetagamawa idiwa da paunau ka awana ‘waeni’ kubamawa ki kewowena ki pokere Iyesu inai kanibu e sibu, wagubu ke; “Gubagani, awana ‘waeni’ ki kewowena.” ");
INSERT INTO gdn_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Ko Iyesu denai e sibu, wagubu ke; “Inai, kau gwede nana inako sidibi? Nau marani tondau, mana bauwagana kena.” ");
INSERT INTO gdn_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","E inako wagubu, ko e inai kanibu bani tawiyatagamawa ragidai ki tadebu, wagubu ke; “Nau gubagani wi badidi nidini ki wi e umuneya makeya makeya kwaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Karako Diyu ragidai mu goramaga ka ropani kawaya. Goramaga ki mosi ka mu idamaga kerapumaga naigida mena siruwapamana ki nana ki pokere tawa ki rabineya ka mu awana kororai kawakawaya ida daikere kewowena daikere eyaka mena ika nakamupu. Awana kororai ki ka mu bowa pokaiya yamanatampu. ");
INSERT INTO gdn_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Ko Iyesu tawiya ragidai ki tadebu, wagubu ke; “Kaiwagi awana kasiga minimuri awana kororai yau posita-muri.” E inako wagubu manako mu kayatagubu e umunui wadumpu makeya makeya kwaetagubu awana kororai kuduba ki awana positampu. ");
INSERT INTO gdn_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Ko Iyesu mu ade tadebu, wagubu ke; “Awana minimupu ki dai wi karako kapa rabineya gwepumuri manako kupe yau kwaewagau apunai kwemuri da e yabiri kuburoto.” E badidi wagubu ki mu makeya makeya kwaetagubu, ");
INSERT INTO gdn_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ko awana kasiga ki karako awana ‘waeni’ bagi kawaya mo wenapupu ki pokere mu apunu ki kapa kwemupu ki ka e babawena, wagubu ke; “Awana midiyai bagi kawaya yau ka bani bauwena?” Tawiya ragidai ki mu kataimugu ko Iyesu badidi kwaewena sisiyai ki mu eba tagubu matara ki pokere apunu ki kanibu anikawena apunai ki sibu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“Nu kupe inako kwaigemei ki ka nu awana ‘waeni’ midiyai bagi kawaya yabiri iyapana tageyamu manako mu awana ki kubomono idiwono da matetagisi ki ka nu awana ‘waeni’ rerarerai ki kawareya mu tageyamu. Ko kau ka awana midiyai bagi kawaya yau wadibi doko tondeya yabedeya da karako kupe siyareya iyapana tageyei.” ");
INSERT INTO gdn_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Iyesu matakira mo naiya inako eba kwaewena. E tawana Gariri natere Kaina rabineya matakira kerarai yau birikapupu manako e tadeyau kabukabuwa ragidai e kasiyarai tanai bagi kawaya ki emupu sumamupu. ");
INSERT INTO gdn_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Kupe ki kewowena eweya ka Iyesu e inai ade e eya yowaiyoma ade e tadeyau kabukabuwa ragidai mete kina kayatagubu natere Kaponiyamu bau-tagubu manako e mara dai ika tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Diyu ragidai mu poragamaga kawaya si ‘Mamanuga God Nu Raurunibu Poragai’ tagamu ki marai ka waunitau ki pokere Iyesu poraga ki kupei mete kupetagamana ki nana natere Diyerusaremu kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ika bauwena ka e Mamanuga God e Tawai rabineya kanibu manako iyapana ika papa burumakau yo papa sipi yo midiwari umago yo bowa madai mete kina inako deni deni nida kasiwara-tagamawa idiwa emitapu. ");
INSERT INTO gdn_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Emitami-yawa ka e nuwai pupuwena manako e taburuba mo wadubu koyapupu wikukupupu manako papa ki kuduba siwakeketapu bautagubu kayatagubu. E bowa madai deni deni nida kasiwara-tagamawa idiwa ragidai mu watara-maga wade rorororopupu ade mu bowamaga madai kuduba ki e mete tepupu isiyapupu. ");
INSERT INTO gdn_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","E inako kwaewena manako e bonanai ragiragi kawaya iyapana ika midiwari umago nida-tagamawa idiwa ragidai ki mu tadebu, wagubu ke; “Wi midiwari yau kuduba tepumuri kaiwagi. Nau Mamai e Tawai rabineya ka wi bowa madai pokaiya deni deni inako eba nida kasiwara-iwogoi idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","E tadeyau kabukabuwa ragidai e badidi kwaewena emupu ki ka mu Mamanuga God e okai iyapana naiya okamupu ki mo wainamupu. Oka ki wagubu ke; ‘Mamai, nau kau Tawagi nene wainapakani ki pokere nau rabinaneya muya warapiyau.’ ");
INSERT INTO gdn_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ko Diyu ragidai mu kawakawai-muguma Iyesu bameya ade bautagubu manako simpu ragiragi, tagubu ke; “Nima kasiyara negebu pokaiya kwaenugei? Kau kasiyaragi mete kina ki kau matakira mo kwaenuwagi da nu kau eminiyamu.” ");
INSERT INTO gdn_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Mu inako tagubu ko Iyesu denai mu tadebu, wagubu ke; “Mamanuga God e Tawai yau koritapumuri manako mara apeya eyaka rabineya ki nau mo ade yadani kewopani.” ");
INSERT INTO gdn_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","21","Iyesu ka e eya kwakwarepui ki waigugui wagubu ko mu wainamupu da e mibai tawa wadana nene wagubu ki pokere mu denai e simupu, tagubu ke; “Tawa yau ka mu kwamura ropani kawaya (46) ki rabineya wadamawa yamawa da kewomupu. Ko kau mara apeya eyaka rabineya tawa yau maba mo ade wadana nuwegei bo?” ");
INSERT INTO gdn_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Iyesu powena ade iyawena kipu ubupu eweya ka e tadeyau kabukabuwa ragidai mu notamaga baurawena e kwakwarepui waigugui wagubu ki mibai wainamupu. Mamanuga God e okai badidi wagubu ade Iyesu e eya badidi wagubu ki yonai kuduba mu mete sumamupu. ");
INSERT INTO gdn_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Iyesu ‘Mamanuga God Nu Raurunibu Poragai’ ki kawareya natere Diyerusaremu rabineya tondawa ki makeya ka e kunuma kasiyarai pokaiya matakira ebo ebo kwaewagawa ki pokere iyapana ropani kawaya e sumamupu. ");
INSERT INTO gdn_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Mu e sumapamawa ko e denai mu eba sumatapu mibai ka mu nuwamaga notamaga kuduba ki e empupu kewowena. ");
INSERT INTO gdn_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Iyapana mu muga sisiyamaga e eba siyamana ki nana mibai ka mu nuwamaga notamaga kuduba ki e ororeya mena kataiwena. ");
INSERT INTO gdn_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Apunu mo si ka Nikodimasi. E ka Parisi apunai Diyu ragidai mu kawaimaga mosi. ");
INSERT INTO gdn_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Kemora mo rabineya ka e Iyesu bameya bauwena manako sibu, wagubu ke; “Nidiyei Kabukabuwa Apunai, nu katainugu da Mamanuga God kau winenibu manako kau e yonai nu kabuwaniyana ki nana baunugibi. E kasiyarai kau eba negebena ki ka matakira kawakawaya kwaenugei ki kau eba kwaenugubena.” ");
INSERT INTO gdn_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Apunu Nikodimasi inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Nau yona mibai kau nidiyani wainapi; Kau wena waunai wenanuwagi ki kau aita Mamanuga God e gari rabineya mara-mara tondowa kaniyowa. Ko kau wena waunai inako eba wenanuwagi ki kau iya waunai ki eba wadi ade Mamanuga God e kasiyarai pokaiya e gari rabineya maramara eba tondowa kaniyowa.” ");
INSERT INTO gdn_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Iyesu inako wagubu wainapupu ka apunu Nikodimasi babawena manako e denai wagubu ke; “Nau ka apunu kawaya ko nau badidi maba ade wenasugani? Nau inani rabineya tesugani ade wena-sugani bo?” ");
INSERT INTO gdn_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Ko Iyesu ade wagubu ke; “Nau yona mibai kau nidiyani wainapi; Kau awana ade Mamanuga God e eya Keyai ki kasiyarai pokaiya eba wenanuwagi ki kau Mamanuga God e gari rabineya eba kaniyo. ");
INSERT INTO gdn_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Nu inanuguma mamanuguma mu ka nu kwakwarepunuga mena wenapiyamu, ko nu keyainuga iyai ki ka Mamanuga God e ebo mena e eya Keyai pokaiya nu negeyau. ");
INSERT INTO gdn_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ki pokere, kau ade wenanugana yonai nidibuwani ki kau notagi eba babayogono. ");
INSERT INTO gdn_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Nau keyakeyai mo suwagani wainapi; Obo ki ebo yawateya baiyagisi kayayagisi. Kau e mumugarai wainapi ko obo ki bani deneya bauwagau ade bani deneya kayawagau ki kau eba kataigeya. Ki maba, wi Mamanuga God e Kasiyarai pokaiya wenaiwagi ki ka wi iya waunai ki mibai mete kataiwagi ko wi badidi maba wena waunai ki wenaigubu ki wi eba kataigau.” ");
INSERT INTO gdn_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Apunu Nikodimasi yona ki waina-pupu ka e kawareya Iyesu ade manu-pupu, wagubu ke; “Ko ki ka badidi maba?” ");
INSERT INTO gdn_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Iyesu apunu Nikodimasi empupu manako denai e sibu, wagubu ke; “Nikodimasi, kau ka apunu kawaya tawana Isiraero ragidai mu tadeyei kabukabuwa apunai mosi, ki pokere nau nidibuwani ki kuduba kau katai-nugubena. ");
INSERT INTO gdn_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Nau yona mibai kau nidiyani wainapi; Nu badidi emipi bo wainamipi ki sisiyai nu wi nidimei ko nu yonanuga ki wi eba sumapiyamu. ");
INSERT INTO gdn_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Ki pokere, nau yewe wairau badidi matarau empuwani ki sisiyai suwaga-kani manako wi nau eba sumasiniyamu ki ka nau kunuma ki wi eba empiyamu ki sisiyai suwagani ki ka wi nau mete eba sumasinimana diyayai wainapakani. ");
INSERT INTO gdn_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Kunumau Kawapuwani Apunai nau niya mena ka kunuma usi empuwani. ");
INSERT INTO gdn_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Oragai apunai Mosisi e eya iyapanaiyoma iyatamana ki nana ka e gwabau ubupu motamota keyakeyai mo kaitepupu ripa teyapu naureya umapu. Ki maba ka iyapana ubumoto Kunumau Kawapuwani Apunai nau wadisinimoto ripa naureya iyarau nau bagisinimoto, ");
INSERT INTO gdn_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","da iyapana nima nau sumasiniyono ki ka e iya waunai yadini manako mara-mara tondono kaniyono. ");
INSERT INTO gdn_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Mamanuga God e iyapana kuduba, madega kau-wagau madega posiwagau wi kawaya daganani nota kwarikwarisinibu ki pokere e eya Gubagai eyaka mena wi iyaga nene nau tonosinibu da iyapana nima nau sumasiniyono ki ka e eba giriyagisi poyagisi ko maramara tondono kaniyono. ");
INSERT INTO gdn_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Mamanuga God ubupu nau tonosinibu kawapuwani ki ka nau iyapana kuduba wi iya waunai negeyana ki nana bausugubuwani ko eba nau idani gurai wi naurigau ugwa-diniyana ragiragi ki nana bausugu-buwani. ");
INSERT INTO gdn_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Iyapana nima nau sumasiniyau ki ka e baganai. Mamanuga God eba uburoto e idai gurai iyapana ki e naureya ugwadini ragiragi. Ko iyapana nima Mamanuga God e Gubagai eyaka mena nau eba sumasiniyau ki ka e ororeya mena paerepupu ki pokere Mamanuga God ororeya mena e idai gurai iyapana ki e naureya ugwadubu ragiragi kewo-wena. ");
INSERT INTO gdn_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nau Mamai wi dunaga nau tonosinibu yewe wairau kawapuwani, ko wi bigiga pokaiya sisipu ki diriwai mena kwaiwagamu. Wi nuwagau tanai apunai nau pa mena ki pokere Mamanuga God e idai gurai wi naurigau ugwadau ragiragi. ");
INSERT INTO gdn_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Iyapana nima bera berokoi kwaewagau ki ka e tanai apunai nau midi ragiragisiniyau mibai ka e eba nuwaiya tanai ki deneya kayayagisi da tanai tawana miniyoto siwa manako e berai berokoi ki kuduba matarapoto. ");
INSERT INTO gdn_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Ko iyapana nima yona mibai mena wainapiyau ade makeya makeya kwaewagau ki ka e tanai ki deneya kayayagisi manako tanai ki tawana miniyoto siwa e upi bagi kawaya Mamanuga God e kasiyarai pokaiya kwaewena ki kuduba matarapoto.” ");
INSERT INTO gdn_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","24","Iyesu yona ki wagubu kewo-wena eweya apunu Diyoni eba dibura-wena ki makeya ka Iyesu e tadeyau kabukabuwa ragidai mete kina tawana Diyudiya kayatagubu. Mu ika bau-tagubu manako mara dai ika iyapana siruwatamawa idiwa. Apunu Diyoni e ka tawana Aenoni natere Sarimi bameya ika iyapana siruwatamiyawa tondawa mibai ka tawana ki ka awana kawaya. Iyapana ropani kawaya e bameya bautagamawa. ");
INSERT INTO gdn_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Mara ki makeya ka apunu Diyoni e kowakowaiyoma dai ubumpu nu idanuga kerapunuga rikapamana bususui ki kawareya Diyu apunai mosi mete deni deni tagamawa kasiwara idiwa. ");
INSERT INTO gdn_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Mu apunu Diyoni bameya bautagubu manako simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, nu naiya awana Diyoudani papasi buridere mete idiweya manako kau apunu mosi bauwagana ki e sisiyai nu nidiyeya, apunu ki karako bauwena iyapana buri siruwatamiyau. Iyapana kuduba karako e bameya kayatagamu ko kau mu kamadiniyamu.” ");
INSERT INTO gdn_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Mu inako tagubu ko apunu Diyoni ubupu denai mu tadebu, wagubu ke; “Mamanuga God e ebo mena kataiya. E nima kasiyara kweyoto ki apunai uburoto upi makeya makeya kwae-yogono. Ko e nima kasiyara eba kweyoto ki apunai eba uburoto upi ki kwaeyagisi. ");
INSERT INTO gdn_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Wi kataigau da nau naiya mena nidibuwani da nau ka eba wi Iya Negeyana Apunai Keriso. Nau ka Iya Apunai ki e yawata gewagewai bausugu-buwani. ");
INSERT INTO gdn_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Anikawagana apunai ki e mena ridi uworoto ko e tagawaiwitai e madaneya mena pa uburono e waretai ki e bonanai mena wainapono ade e mamamai yogono. Nau karako mamama ki maba wainapakani. ");
INSERT INTO gdn_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","E ka esida ko nau ka erida. E kasiyarai ka kawaya-yogono yarono ko nau kasiyarani ka mareyayogono surono.” ");
INSERT INTO gdn_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Apunu Diyoni inako wagubu, ade wagubu ke; “Kunumau Kawapu Apunai e mena ka kawaya. Iyapana ade gwedegwede kuduba ka e kobaiya. Yewe wairau wenawena apunai ki ka yewe wairau ki yonai mena e kataiya. Ko kunuma were kawapu apunai ki e ka kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","E badidi usi empupu bo wainapupu ki sisiyai e yogono ko iyapana e yonai ki eba wainapamana wainapomoto ade e eba sumapomoto. ");
INSERT INTO gdn_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Ko iyapana nima Kunumau Kawapu Apunai e yonai wainapiyau ade sumapiyau ki ka Mamanuga God badidi kwaewagau ki e mete mibipiyau. ");
INSERT INTO gdn_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Mamanuga God e Tonopupu Apunai ki e rabineya ka Mamanuga God e eya Keyai ki tanai posiwena minibu siwa ki pokere apunu ki yonayogono ki ka e Mamanuga God e eya yonai ki mena makeya makeya yogono tondono. ");
INSERT INTO gdn_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mamanuga God e Gubagai kawaya daganani nota kwarikwarisipiyau ki pokere e ubupu gwedegwede kuduba e Gubagai idaiya nakapupu. ");
INSERT INTO gdn_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Iyapana nima Mamanuga God e Gubagai sumapiyau ki ka maramara tondana kaniyana iyai ki e mete wadubu kewo-wena. Ko iyapana nima Mamanuga God e Gubagai e yonai kwenupiyau ki ka iya waunai ki e eba yadini ade Mamanuga God e nuwai iyapana ki bameya maramara pupuyogono tondono.” ");
INSERT INTO gdn_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","3","Parisi ragidai mu kataitagubu da Iyesu e iyapanaiyoma siruwa-tamiyawa ka ropani kawaya ko apunu Diyoni e iyapanaiyoma siruwatamiyawa ka eba ropani. Mu notamaga ki ka Iyesu e ororeya mena kataiwena ki pokere e kipu ubupu tawana Diyudiya kamadubu manako ade wirawena tawana Gariri kayawena. (Ki ka eba Iyesu e eya ubupu iyapana siruwatapu ko ki ka e tadeyau kabukabuwa ragidai mu kwaetagubu.) ");
INSERT INTO gdn_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Tawana Diyudiya yo Gariri paunau ka tawana Sameriya. Iyesu nuwaiya ka tawana ki mete kayawagana waina-pupu, ");
INSERT INTO gdn_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","6","ki pokere e ika bauwena ka e ade kaniyawa da madega paunau wadawa makeya ka e natere mo si ka Saika bauwena. E ika bauwena ka e midi makariwena ki pokere e kanibu awana usirai mo uruba rabineya ki madaneya kwarisiwena tondubu. Takari kawaya ka oragai apunai Diyaikapu uruba ki ukwapupu manako waira ki e gubagai Diyosepa umani sibu ki pokere iyapana karako awana usirai ki si Oragai Apunai Diyaikapu Awanai Usirai simupu. ");
INSERT INTO gdn_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Iyesu e tadeyau kabukabuwa ragidai natere ki rabineya bani dai gimarapamana ki nana kayatagubu ko Iyesu e eya mena ika awana usirai ki madaneya tondawa. E ika tondawa ka tawana Sameriya ragidai mu ridimaga mosi awana miniyana ki nana ika bauwena manako Iyesu ridi ki sibu, wagubu ke; “Awana dai mini tege da nau kubarani.” ");
INSERT INTO gdn_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Karako ka Diyu ragidai yo tawana Sameriya ragidai mu rabinamaga ka mubo mubo eba eyaka mena ki pokere ridi ki denai Iyesu sibu, wagubu ke; “Kau ka Diyu apunai ko nau ka Sameriya ridai. Kau badidi pokere nau awana miniyana negeyana nuwegei?” ");
INSERT INTO gdn_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","E inako wagubu ko Iyesu denai wagubu ke; “Mamanuga God e puyo kau negeyana wagubu ki kau katainugubena ade nau karako awana miniyana tegeyana nidibuwani apunai nau mete kataisinibena ki kau nau genesinibena manako nau iya maramara idiwana ki awanai kau negebena.” ");
INSERT INTO gdn_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Iyesu inako wagubu manako ridi ki e ade sibu, wagubu ke; “Bada, uruba yau ka rowarowa kawaya ko kau awana kororai mo eba wadibi. Iya awanai nene nuwagibi ki kau badidi maba mini? ");
INSERT INTO gdn_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Nu ripakwarakwaranuga Diyaikapu awana usirai yau ukwapupu manako e eya munuiyoma ade e papaiyoma mete kina awana yau kubamawa. Ko kau karako nuwegei da kau ka nu kawainuga Diyaikapu e maba ko ade esida bo?” ");
INSERT INTO gdn_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ridi ki inako wagubu ko Iyesu e ade sibu, wagubu ke; “Iyapana nima awana yau kuburoto ki ka e aita awana gobai ade yogono. ");
INSERT INTO gdn_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Ko iyapana nima awana nau kweyani ki kuburoto ki ka e aita ewa awana gobai eba yogono. Awana nau e kweyani ki aita e rabineya awana yabai maba maramara usirapono manako e iya maramara tondono kaniyono.” ");
INSERT INTO gdn_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Ridi ki yona ki wainapupu ka e denai Iyesu sibu, wagubu ke; “Bada, kau awanagi ki mini tege kubarani da nau awana gobani eba yogono manako ewa awana yau ki kai mo eba umoni.” ");
INSERT INTO gdn_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Ko Iyesu denai e sibu, wagubu ke; “Kau kayanuwagi kau nobomogi siyo bananapi mete ewapuru nau bamaneya baiwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Nau nobomoni pa mena.” Ridi ki inako wagubu, ");
INSERT INTO gdn_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","manako Iyesu denai wagubu ke; “Kau yona mibai nuwagibi. Kau karako nobomogi pa mena. Kau naiya apunu ida daikere mena tauwapi da kamaditapi ko apunu karako mete iwu ki e ka eba kau nobomogi.” ");
INSERT INTO gdn_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Ridi ki e eya sisiyai siyawa ki wainapupu ka e denai wagubu ke; “Sidiyei Kabukabuwa Apunai, nau wainapakani da kau ka Mamanuga God e bonanai wainapiyei nuwegei apunai mosi. ");
INSERT INTO gdn_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Nu Sameriya ragidai nu ripakwarakwaranuguma kweya yau kawareya Mamanuga God bameya guriguritagamawa idiwa. Ko wi Diyu ragidai wi iwagamu da Mamanuga God e si tepapamana watai ka natere Diyerusaremu rabineya.” ");
INSERT INTO gdn_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","24","Ridi ki inako wagubu ko Iyesu denai e sibu, wagubu ke; “Ridi, nau yona yau nidiyani ki kau naigida mena wainapi; Kau ka nu tawana bani rabineya gurigurigamana ki nene notapiyei. Ko ki ka eba gwede kawaya mosi. Mamanuga God e ka eba iyapana kaina maba ko e ka ade Keyai ki pokere nu e bameya gurigurigamu ki ka nu nuwanuga notanuga eyaka mena e mena sumapamu were e eya Keyai ki pokaiya mibai supasupai mena e bameya gurigurigamu. Nu guriguri-gamana watai ka asusu yabayababa eba wata eyaka mena ko nu badidi maba gurigurigamana ki ka eba asusu. Mara baiyagisi, ena mara ki wana bauwena, da iyapana ubumoto Mamanuga God bameya supasupai mena inako guriguritogomono idiwono. Ko wi Sameriya ragidai wi ka nima si tepa-piyamu bameya guriguriwagamu ki e wi naigida eba kataigau. Iya ka Diyu ragidai nu paunanugu baiyagisi ki pokere nu nima si tepapemei ki nu mena katainugu. Nau yona yau nidi-buwani ki kau naigida mena wainapi.” ");
INSERT INTO gdn_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Iyesu inako wagubu manako ridi ki denai wagubu ke; “Nau kataineya da Mesaiya ki ka nu Iya Negeyana Apunai Keriso e baiyagisi ki ka e iya waunai wadamana yonai ki kuduba nu ka-buwaniyoto.” ");
INSERT INTO gdn_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ko Iyesu denai wagubu ke; “Iya Negeyana Apunai ki karako bauwena kau mete yonaigemei nau yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ki makeya ka e tadeyau kabu-kabuwa ragidai ade wiratagubu bau-tagubu. Mu Iyesu ridi ki mete yona-tagamawa emitampu ki ka mu baba-tagubu ko mu yona mo e eba simupu; ‘Kau nuwageya gwede?’ bo ‘Kau badidi pokere ridi ki mete yonaiwagamu?’ Mu inako mo eba manumupu. ");
INSERT INTO gdn_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Ridi ki awana kororai ika kama-dubu manako wirawena garugaru mena natere ki kayawena iyapana ika idiwa tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Kebomuri da apunu mosi nau naiya badidi kwae-sugekeya ki sisiyai kuduba matarau nau sidibu ki empumuri. E ka nu Iya Negeyana Apunai Keriso burida ba bauwena bo?” ");
INSERT INTO gdn_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Ridi ki inako wagubu manako e iyapana bananatapu Iyesu bameya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Iyapana ki waunai kebomawa makeya ka Iyesu e tadeyau kabukabuwa ragidai ika bani waramupu manako Iyesu simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, kau yabi bani dai kupi.” ");
INSERT INTO gdn_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Ko e denai mu tadebu, wagubu ke; “Nau naubo banini dai nau bamaneya uburau ko bani ki wi eba kataigau.” ");
INSERT INTO gdn_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Mu wainamupu da e pa bani kaina nene wagubu ki pokere mu mubo manu kasiwaratagubu, tagubu ke; “Iyapana mo bani dai tepupu bauwena e kwebu bo?” ");
INSERT INTO gdn_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ko Iyesu denai wagubu ke; “Nau banini ka nau Mamai God e badidi wagubu ki kuduba nau kwaesugani ade e upi tegebu ki kuduba nau kewopani. Nau banini ka ki kena. ");
INSERT INTO gdn_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Wi iwagamu da; ‘Siragamu apeya apeya kewoyagisi ki ka maura marai baiyagisi’. Ko nau waigugu mo suwagani wainapumuri; Wi yabuga kokora empumuri. Bani kuduba wana raiwena da raupomuigomu. ");
INSERT INTO gdn_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Raupomutagamu ragidai ka aita denai gwede bagi mosi yadini, mibai ka maramara idiwana kaiwana bani ki mu tepiyamu. Ko upitagamu ragidai ade raupomutagamu ragidai ki ka aita ewa ka mu ewapuru mena mamamatogo-mono idiwono. ");
INSERT INTO gdn_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Wi iwagamu da; ‘Apunu mosi upiyagisi ade mosi raupomuyagisi’. Wi inako iwagamu ki ka wi yona mibai iwagamu. ");
INSERT INTO gdn_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Kokora ki nau wi raupomuigamana ki nana tononiyani kokora ki ka iyapana dai ki naiya mena upitagubu ko wi ka bani ki pa irimagere mena raupomuiwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","40","Tawana Sameriya ragidai ki Iyesu bameya bautagubu ka mu e diriwai kwaetagubu manako simupu, tagubu ke; “Kau eba kayanuwagi ko nu mete yewe idiwomu.” Mu inako tagubu ki pokere Iyesu mara apeya mu mete ika idiwa. Ridi ki naiya badidi kwae-wagawa ki sisiyai Iyesu e matarau sibu ki pokere ridi ki ubupu Iyesu sisiyai iyapana tadeyawa umawa. Iyapana yona ki wainamupu ka mu dai Iyesu sumamupu. ");
INSERT INTO gdn_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Iyesu Mamanuga God e yonai ika Sameriya rabineya iyapana tadeyawa kabukabuwa tondawa da kamadubu ka mu ropani kawaya e yonai sumamupu, ");
INSERT INTO gdn_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","manako mu ridi ki simupu, tagubu ke; “Kau naiya nidibi ko karako ka nu e yonai nu nubo wenagunugere waina-mipi ki pokere nu e sumapemei. E ka iyapana kuduba, madega kauwagau madega posiwagau nu Iya Negeyana Apunai ki ba bauwena yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Mara apeya ki kewowena eweya ka Iyesu tawana ki kamadubu manako tawana Gariri kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","E iyapana naiya tadebu, wagubu ke; ‘Mamanuga God e bonanai wainapiyau wagau apunai ki tawana tawana umono da iyapana e diriwai kwaetogomono ko e ebo tawaneya baiyagisi ki ka e eya iyapanaiyoma e diriwai eba kwaetagisi.’ ");
INSERT INTO gdn_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Iyesu iyapana naiya inako tadebu ko e karako tawana Gariri bauwena ki ka e eya iyapanaiyoma ika idiwa e diriwai mete kwaetagubu. E natere Diyerusa-remu rabineya ‘Mamanuga God Nu Raurunibu Poragai’ ki kawareya badidi kwaewagawa ki mu mubo yabumugere emupu kewowena ki pokere mu karako e mamamai kwaetagamawa. ");
INSERT INTO gdn_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Iyesu ika tondawa da kamadubu, manako wirawena natere Kaina ade kayawena. Natere Kaina rabineya ka e naiya awana kasiga mo wirapupu manako awana ‘waeni’ wenapupu ki tawanai. Natere ki rabineya ka apunu kawai mosi ika bauwena ki e gubagai sigira kawaya mo ukwarawa. Ko e gubagai ki natere Kaina rabineya eba tondawa ko e natere Kaponiyamu tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Apunu ki Iyesu ika bau-wena sisiyai wainapupu ka e kayawena e bameya bauwena manako sibu, wagubu ke; “Nau gubagani sigirawena powagana kwaewagau ki pokere kau nau mete kaigamu natere Kaponiyamu manako nau gubagani iyapi.” ");
INSERT INTO gdn_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Ko Iyesu denai wagubu ke; “Wi nau matakirani empiyamu ki wi nau sumasiniyamu ko wi nau matakirani eba empiyamu ki wi nau eba sumasiniyamu.” ");
INSERT INTO gdn_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Iyesu inako wagubu ko apunu ki e ade sibu, wagubu ke; “Kaiwawoni, nau yona mibai kau nidiyakani; Nau gubagani powagana kwaewagau ki pokere garugaru mena yabi da nau mete kaigamu.” ");
INSERT INTO gdn_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Apunu ki yona ki kawareya inako wagubu ki pokere Iyesu e empupu, manako denai sibu, wagubu ke; “Kau gubagagi eba poyagisi. Kau wiranuwagi kau kaubo tawageya kayanuwagi.” Apunu ki Iyesu yonai ki sumapupu manako e wirawena e ebo tawaneya kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","E kayawena kaniyawa da yawatau ka e kowakowaiyoma dai ki natere Kaponiyamu were bibi bau-tagubu, tagubu ke; “Kau gubagagi iyawena tondau.” ");
INSERT INTO gdn_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Munu ki e mamai yona ki waina-pupu ka e bibi bautagubu ragidai ki denai manutapu, wagubu ke; “E gwede mara iyawena?” Ko mu tagubu ke; “Ki ka mara yomi madega napusi eyaka mena wadawa ki makeya ki ka e midi muyai ki kewo-wena manako e iyawena.” ");
INSERT INTO gdn_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Munu ki e mamai yona ki wainapupu ka e notai wagubu ke; “Akae, mara yomi madega napusi eyaka mena ki makeya ka Iyesu nau sidibu, wagubu ke; ‘Kau gubagagi eba poyagisi.” E notai ki notapiyawa kaniyawa da e tawaiya bauwena ki ka e eya ade e wainai ade e munuiyoma kuduba mete kina Iyesu sumamupu. ");
INSERT INTO gdn_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Iyesu karako tawana Gariri tondawa. Naiya mena, e tawana Diyudiya eba kayawena ki makeya, ka e awana ‘waeni’ ki matakirai ika kwae-wena. Ko e karako ade bauwena ka e munu iyapupu ki matakirai kwaewena. ");
INSERT INTO gdn_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ki eweya ka Iyesu ade wirawena natere Diyerusaremu rabineya Diyu ragidai mu poragamaga mosi ika kwaetagamawa ki kupei kupewagana ki nana kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Natere Diyerusaremu gari umampu ki katamurui mosi si ka ‘Papa Sipi Katamurui’ tagamawa. Katamuru ki bameya ka kaburu mosi ika mete kina ki mu yona Iburu were si Betata tagamu. Ade kaburu ki papateya ka mu nabonabo ida daikere mena waditampu ika ubumawa. ");
INSERT INTO gdn_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Nabonabo ki rabineya ka sigira ragidai ropani kawaya mu kerapumaga kiyokiyoi bo mu yabumaga kenekenei bo mu ida-maga kerapumaga badabadamai inako ki ika ukwapamawa idiwa. Mu kaburu ki giwagana empamana ki nawanai idiwa, ");
INSERT INTO gdn_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","mibai ka makeya makeya ka Mamanuga God e aneyai mosi kawapu kaburu ki gipiyawa da awana euna-piyawa manako iyapana nima awana eunapiyawa makeya kaburu ki yabiri surawa ki e gwede sigirai wadubu ki ka e iyawagawa. ");
INSERT INTO gdn_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Apunu mosi ika ukwarawa ki rowarowa kawaya kwamura (38) ki rabineya maramara sigira mena ukwarawa. ");
INSERT INTO gdn_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Iyesu ika bauwena manako apunu ki empupu manupupu, wagubu ke; “Kau nuwageya iyanuwagi bo?” ");
INSERT INTO gdn_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Ko sigira apunai ki denai wagubu ke; “Bada, nau rowarowa kawaya yewe nawana ukwerekeya ko nau kowa-kowani pa mena ki pokere aneya bauwagau kaburu yau gipiyau ki ka nau surana kwaesugakani ko iyapana maramara nau wade ewaiwasiniyamu yabiri sumu.” ");
INSERT INTO gdn_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Apunu ki inako wagubu ko Iyesu e sibu, wagubu ke; “Kau kiri uburi kau kebarigi ewopi kawarapi kayanuwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Iyesu yona ki wagawa makeya ka sigira apunai ki iyawena kipu ubupu manako e kebari ki ewopupu wadubu kaniyawa yabadawa. Ko mara ki ka Diyu ragidai mu aiyatamaga marai da mu kaisi gwede mo eba kawarapamana ki nana, ");
INSERT INTO gdn_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ki pokere kawakawai ragidai apunu ki iyawena emupu ki ka mu e sisibamupu, tagubu ke; “Kau goranuga giripiyei. Yau ka nu aiyatanuga marai ko kau kebarigi gwede nana kawarapiyei?” ");
INSERT INTO gdn_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Ko e denai mu tadebu, wagubu ke; “Nau iyasinibu apunai e sidibu da nau kebarini ewopana kawarapana ki nana wagubu ki pokere nau karako kawarapuwani kaniyakani yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Diyu ragidai yona ki wainamupu ka mu e ade manumupu, tagubu ke; “Nidibu apunai ka nima?” ");
INSERT INTO gdn_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Mu inako tagubu ko e denai wagana ki e babawena mibai ka iyapana ropani kawaya ika mete kina ko Iyesu mu paunamugu bani bauwena kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Mara dai eweya ka Iyesu apunu ki Mamanuga God e Tawai rabineya ade bananapupu manako sibu, wagubu ke; “Kau sigiragi wana kewowena. Kau naigida mena umowa ade bera berokoi mo eba kwaenugowa ki ka aita ewa bita kawaya mosi kau bamageya eba bai-yagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Iyesu inako wagubu ko apunu ki kayawena Diyu ragidai mu kawakawai-muguma bamamugu bauwena manako tadebu, wagubu ke; “Nau iyasinibu apunai ka Iyesu.” ");
INSERT INTO gdn_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","E inako wagubu ki pokere mara ki makeya ka Diyu ragidai Iyesu bita makari kweyamana ki kerarai birikamupu. E aiyata marai rabineya sigira apunai ki iyapupu ki pokere mu ubumpu e kiramupu. ");
INSERT INTO gdn_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ko Iyesu denai mu tadebu, wagubu ke; “Nau Mamai aiyata mo eba tondau ki pokere nau mete kina aiyata mo eba tondoni.” ");
INSERT INTO gdn_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Diyu ragidai mu kawakawai-muguma e yonai ki wainamupu ka mu nuwamaga pupuwena mibai ka e eba mu aiyatamaga marai ki mena rauru-pupu ko e mete wagubu da; ‘Mamanuga God e ka nau Mamai”. Mu wainamupu da e eya si tepapupu ki pokere mu e minimana po ki yanuwei mete teyamawa. ");
INSERT INTO gdn_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Ko Iyesu denai mu tadebu, wagubu ke; “Nau yona mibai wi nidiyani waina-pumuri; Nau Mamai God e eya Gubagai ka nau ki pokere nau naubo nuwaneya ki nau gwede mo eba kwaesugakani ko nau Mamai badidi wainapiyau nau kabuwasiniyau ki mena nau makeya makeya kwaesugakani. ");
INSERT INTO gdn_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Nau Mamai e nuwaiya po nau ki pokere e badidi wainapiyau ki kuduba e nau kabuwa-siniyau. Wi nau matakirani yau emupu ki ka eba gwede kawaya mosi ko wi nau Mamai aita ewa badidi kabuwasiniyoto kwaesugani empumuri ki ka wi notaga babayagisi. ");
INSERT INTO gdn_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Nau Mamai uburoto iyapana popotagubu ragidai iyatamini kimoto ubumoto ki maba ka nau mete kina uburani iyapana nau naubo nuwaneya iyatamana wainapakani ki ka nau mu waitatamani iyatamani. ");
INSERT INTO gdn_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Nau Mamai eba uburoto e idai gurai iyapana wi naurigau ugwadiniyoto ragiragi. Kasiyara ki kuduba ka e nau tegebu da nau uburani nau idani gurai wi naurigau ugwadani ragiragi. ");
INSERT INTO gdn_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Nau uburani inako kwaesugani ki ka wi nau Mamai e si tepapiyamu ki maba ka wi nau sini mete tepapumuri. Nau Mamai nau tonosinibu ki pokere iyapana gwedewau nau Mamai God e si tepapiyamu ki ka mu e Gubagai nau sini mete tepapi-yamu, ade iyapana gwedewau nau sini eba tepapiyamu ki ka mu nau Mamai e si mete eba tepapiyamu. ");
INSERT INTO gdn_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Nau yona mibai wi nidiyani wainapumuri; Iyapana nima nau yonani wainapiyau ade nau Tonosinibu Apunai e mete sumapiyau ki ka maramara tondana kaniyana iyai ki e wadubu kewowena. Po watai ki e raurupupu karako iya wateya tondau ki pokere e berokoi badidi naiya kwaewagawa ki bimbinai e aita mo eba bananapoto. ");
INSERT INTO gdn_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Nau yona mibai wi nidiyani wainapu-muri; Mara yabadau, ena, mara ki wana bauwena da iyapana popotagubu ragidai Kunumau Kawapuwani Apunai nau bonanani wainapomoto manako iyatagisi kimoto ubumoto. ");
INSERT INTO gdn_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Nau Mamai e ka wi iyaniyau ki apunai ko e karako kasiyara ki kuduba nau tegebu da nau uburani wi iya negeyani. ");
INSERT INTO gdn_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Kunumau Kawapuwani Apunai ka nau ki pokere nau Mamai ubupu nau idani gurai iyapana kuduba wi naurigau ugwadana ragiragi ki upi nau tegebu. ");
INSERT INTO gdn_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ki pokere, nau karako wi nidibuwani ki wi wainapiyoi ko eba babaiwogoi. Mara yabadau da popotagubu ragidai uruba rabineya ukwapamu nau bonanani wainapomoto kimoto ubumoto, ");
INSERT INTO gdn_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","manako nima bagi kwae-wagawa ki e kiroto uburoto maramara tondana kaniyana ki iyai yadini, ko nima berokoi kwaewagawa ki e kiroto uburoto manako e paerepupu ki denai yadini.” ");
INSERT INTO gdn_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Iyesu Diyu ragidai ade tadebu, wagubu ke; “Nau badidi kwaesugakani ki ka nau naubo kasiyarani pokaiya eba kwaesugakani ko nau Mamai badidi sidiyau ki makeya makeya ka nau idani gurai wi naurigau ugwadiniyakani ragiragi ade mibai supasupai mena kwaesugakani. Nau naubo nuwaneya eba kwaesugakani ko nau Tonosinibu Apunai e nuwaiya badidi ki mena makeya makeya nau upisugakani. ");
INSERT INTO gdn_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Nau naubo sisiyani suwagani ki ka wi bera umani nau sidimuri. ");
INSERT INTO gdn_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","33","Ko iyapana mosi e naiya mena bauwena nau sisiyani wagubu. Wi apunu Diyoni manupamana empamana ki nana wi iyapanaguma dai e bameya tonotampu manako e ubupu nau sisiyani mibai kawaya matarau wagubu ki wi waina-mupu kewowena. Ki pokere wi mete kataigubu da nau niya sisiyani karako suwagakani ki mibai. ");
INSERT INTO gdn_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Apunu Diyoni ubupu nau sisiyani wagubu ki ka nau nene eba gwede kawaya mosi ko wi iya waunai wadamana ki nana ka nau karako e badidi nau nene wagubu ki kawareya wi ade nidiyakani. ");
INSERT INTO gdn_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Apunu Diyoni e ka duna maba bauwena urawa ko wi mara eba ropani e mamamai kwaigubu. ");
INSERT INTO gdn_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Nau nidiyani wainapumuri; Apunu Diyoni badidi nau nene wagubu ki kuduba ka erida ko nau Mamai upi tegebu makeya makeya kwaesugakani matakirai empumuri ki kuduba ka esida. Wi nau matakirani ki empumuri ki ka Mamanuga God nau tonosinibu ki wi mete kataiwagi. ");
INSERT INTO gdn_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Nau Tonosinibu Apunai e ubupu nau sisiyani mete wagubu ko e bonanai ki wi eba wainamupu ade e kiyabui ki wi mete eba emupu. ");
INSERT INTO gdn_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","E nau tonosinibu ko wi nau eba sumasiniyamu mibai ka nau Mamai e yonai ki wi rabinagau eba supu. ");
INSERT INTO gdn_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Mamanuga God e okai ki wi maramara iyabapiyamu idiwu, mibai ka wi wainapiyamu da oka ki pokaiya ka wi iya maramara idiwana kaiwana ki iyai bananapumuri. ");
INSERT INTO gdn_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Ko nau suwagani wainapumuri; Mamanuga God e okai kuduba ka nau sisiyani mena wagau ki pokere wi nau bamaneya baigumpena ki ka nau iya waunai ki wi negebena. Ko wi nau bamaneya eba baigamana wainapiyamu ki pokere iya waunai ki wi eba wadumuri ");
INSERT INTO gdn_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Nau eba iyapana nau sini tepapamana ki nana yona yau suwagu-buwani. ");
INSERT INTO gdn_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Ko wi badidi maba idiwu ki nau kataineya. Ade nau mete kataineya da wi nuwaga notaga Mamanuga God nene eba notapiyamu. ");
INSERT INTO gdn_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Nau Mamai e kasiyarai pokaiya bausugubuwani ko wi nau diriwani eba kwaiwagamu. Ko iyapana mosi e ebo kasiyarai pokaiya baiyagisi ki ka wi e diriwai garugaru mena kwaiwagi. ");
INSERT INTO gdn_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Wi badidi maba Mamanuga God sumapumuri? Ae, pa mena. Wi wibo siga tepapamana ki nana yabara kawakawaraiwagamu idiwu ko Mamanuga God e nuwaiya badidi ki kwaiwagamana da e wi mamamaga wagana ki diriwai wi eba kwaiwagamu. Ki pokere wi badidi maba e sumapumuri? Ki pa mena. ");
INSERT INTO gdn_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Nau nidiyani wainapumuri; Nau Mamai e yabareya ki nau eba uburani nau idani gurai wi naurigau ugwadani ragiragi. Oragai apunai Mosisi e uburoto inako kwaeyagisi. Wi wainapiyamu da oragai apunai Mosisi wi waitaniyoto manako wi iya waunai wadumuri. ");
INSERT INTO gdn_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ko nau ade nidiyani wainapumuri; Oragai apunai Mosisi nau okani tapu ki yonai wi sumampena ki ka wi karako nau mete sumasinimpena. ");
INSERT INTO gdn_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","E nau okani tapu ko wi oka ki eba sumapiyamu ki pokere nau yonani suwagubuwani ki wi mete eba sumapiyamu.” Iyesu Diyu ragidai inako tadebu. ");
INSERT INTO gdn_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ki eweya, ‘Mamanuga God Nu Raurunibu Poragai’ ki marai waunitau ka Iyesu waka kawareya kaburu kawaya Gariri papasi buridere kayawena. (Kaburu ki si daikere ka Taibiriyasi.) ");
INSERT INTO gdn_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","E sigira ragidai dai iyatamiyawa ki matakirai ka iyapana ropani kawaya mu mubo yabumugere emupu ki pokere mu karako e ewakumapamawa iwa. ");
INSERT INTO gdn_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","4","Iyesu kwaunai mo yapu manako e tadeyau kabukabuwa ragidai mete ika idiwa. ");
INSERT INTO gdn_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Idiwa da e yabu tapu manako iyapana ropani kawaya e deneya ika umuna-mawa emitapu ki ka e wirawena apunu Piripo sibu, wagubu ke; “Kau badidi wainapiyei, iyapana ropani kawaya urida umunamu ko mu banimaga ki nu bani tepamu tageyamu da mu kupo-moto?” ");
INSERT INTO gdn_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","(Iyesu e ewa badidi kwae-wagana ki e kataiya ko e nuwaiya ka Piripo e nuwai notai naigida mena empana wetawetara ki nana ki pokere e yona ki wagubu.) ");
INSERT INTO gdn_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Ko apunu Piripo denai wagubu ke; “Kaiwawoni, iyapana ka ropani kawaya ko bani denai ka kawaya daganani. Nu kaigamu mu banimaga gimarapamu manako iyapana eyaka eyaka bani piripiri tageyamu ki ka bowa madai apunai ida daikere mena (200) ki maraitau wainapakani.” ");
INSERT INTO gdn_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Apunu Piripo inako wagubu ko Iyesu e tadeyau kabukabuwa apunai mosi si ka Enduru (e ka apunu Saimoni si daikere Pita e yowai) ki e ubupu Iyesu sibu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Munu mosi yewe bauwena ki e masurai bani buredi ida daikere mena ade menamena apeya ki mete tepupu bauwena. Ko ki ka eba bani kawaya. Iyapana ropani kawaya bani ki kupomoto ka mu eba denemugu-yagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Ko Iyesu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Iyapana kuduba tademuri da mu dewarepa yau kawareya idiwoto.” Ko iyapana ropani kawaya ika dibimupu idiwa mu paunamugu uratanai mena ka kuduba 5,000 kwaitana. ");
INSERT INTO gdn_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Iyesu bani buredi ki tepupu e Mamai bameya parauwena manako iyapana kuduba bani ki tagebu. E menamena apeya ki mete tepupu inako ade kwaewena manako iyapana kuduba bani ki kupamawa idiwa da matetagubu. ");
INSERT INTO gdn_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Ki eweya ka Iyesu e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Wi kaiwagi bani pirai ki kuduba kwanapumuri kode rabineya nunumuri ko mo eba kamadumuri.” ");
INSERT INTO gdn_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","E inako wagubu ki pokere mu kaimpu bani pirai ki naigida mena kwanapamawa kode rabineya nunumawa da kewowena ka kode ida esida kewowena kerapu apeya (12) ika positagubu. Ko bani kawaya ki kerarai ka bani buredi ida daikere mena ade menamena apeya mete kina ki iyapana kuduba kupampu matetagubu. ");
INSERT INTO gdn_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Iyapana ropani kawaya ika idiwa Iyesu matakira kawaya ki kwaewena emupu ka mu tagubu ke; “Mibai, apunu yau ka Mamanuga God e Bonanai Wainapiyau Wagau Apunai nawanai idiweya ki karako bauwena yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Mu inako tagubu ko Iyesu e rabineya mena wainapupu da mu e wadamana doko mu kawaimaga watai tamana ki nana wainapamawa ki pokere e ade wirawena e ebo mena kweyau kaya-wena. ");
INSERT INTO gdn_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Kemora nene ka Iyesu e tadeyau kabukabuwa ragidai sumpu kaburu papateya idiwa. ");
INSERT INTO gdn_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Mu Iyesu nawanai ika idiwa da kemorawena ko e eba bauwena ki pokere mu waka rabineya positagubu manako wiratagubu kaburu ki kawareya natere Kaponiyamu deneya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Mu kaiwa idiwa da nusuru kawaya mo bauwena towawa wirawena waka gipiyawa kaniyawa. ");
INSERT INTO gdn_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Mu bara-tagamawa kaiwa da kaburu paunau ka mu yabu tampu manako Iyesu e kerareya ika kaburu kawareya waka deneya yabadawa ki emupu. Em-pamawa ka mu notamaga kowena kudu ebotau wainapamawa. ");
INSERT INTO gdn_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Ko Iyesu mu tadebu, wagubu ke; “Yau ka nau. Kudu eba wainapiyoi.” ");
INSERT INTO gdn_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Mu e yonai wagubu ki wainamupu ka mu e mamamai kwaetagubu waitamupu waka rabineya posiwena manako ki makeya ka mu garugaru mena kaburu papasi buridere mu kayatagamana tawanai ki bau-tagubu. ");
INSERT INTO gdn_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Mu ukwampu nawaru puruwena ka iyapana ropani kawaya kaburu papasi daikere idiwa ki Iyesu kwaenei kwaetagamawa. E tadeyau kabukabuwa ragidai ka yomi mu muga mena waka kawareya kayatagubu ki mu emitampu ko Iyesu e eya ka bani kayawena? Mu inako wainapamawa manu kasiwara-tagamawa idiwa. ");
INSERT INTO gdn_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Yomi ka Iyesu bani buredi dai tepupu Mamanuga God bameya parauwena iyapana tagebu ko ki wateya ka tawana Taibiriyasi ragidai karako waka ropani kawaya tempu ika bautagubu. ");
INSERT INTO gdn_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Mu bautagubu Iyesu kowakowaiyoma mete kina kwaene-tamawa da pa mena manako mu iyapana ika idiwa ragidai ki mete waratampu wakamuguma kawareya Iyesu kwaenei natere Kaponiyamu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ika bautagubu ka mu Iyesu banana-mupu manako manumupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, kau gwede mara yewe baunugibi?” ");
INSERT INTO gdn_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Ko Iyesu denai mu tadebu, wagubu ke; “Nau yona mibai wi nidiyani waina-pumuri; Nau yomi bani negebuwani kupampu mateigubu ki pokere wi nau kwaeneni kwaigamawa ko nau matakira kwaesugubuwani emupu ki mibai wi eba sumamupu. ");
INSERT INTO gdn_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bani kaina kupemei garugaru mena kewowagau ki diriwai eba kwaiwagi ko iya maramara idiwana kaiwana iyai ki bani mena diriwai kwaiwagi. Nau Kunumau Kawapuwani Apunai bani ki wi negeyana ki nana bausugubuwani mibai ka nau Mamai God iya ki wi negeyana ki nana nau winesinibu tonosinibu kawapuwani.” ");
INSERT INTO gdn_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Iyesu inako wagubu manako mu denai e simupu, tagubu ke; “Nu badidi maba kwaigamu da Mamanuga God badidi wagubu ki upi nu makeya makeya kwaigomu?” ");
INSERT INTO gdn_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Ko Iyesu denai mu tadebu, wagubu ke; “Nau Mamai God e nuwaiya ka wi nau mena sumasinimana ki nana. E ki nene nau tonosinibu.” ");
INSERT INTO gdn_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","31","E inako wagubu ko mu denai e ade simupu, tagubu ke; “Takari kawaya nu ripakwarakwaranuguma gwabau iwa wadamawa ki makeya ka mu bani mo si ka ‘mana’ ki kupamawa iwa. Oragai ragidai Mamanuga God e okai mo inako tampu, tagubu ke; ‘Mamanuga God mu Kunuma Bani kupamana ki nana tagebu.’ Kau kiya gwede matakira ki maba mo kwaenuwagi da nu matakira ki empamu manako kau sumaniyamu.” ");
INSERT INTO gdn_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Iyapana ki inako tagubu ko Iyesu denai mu tadebu, wagubu ke; “Nau yona mibai wi nidiyani wainapumuri; Oragai apunai Mosisi e ka Kunuma Bani mibai mu eba tageyawa. Kunuma Bani mibai ki ka nau Mamai God e mena wi negeyau. ");
INSERT INTO gdn_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bani ki kena ka kunuma were kawapu. Iyapana nima bani ki kupoto ki ka e iya maramara tondana kaniyana ki iyai yadini.” ");
INSERT INTO gdn_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Iyapana yona ki wainamupu ka mu tagubu ke; “Nidiyei Kabukabuwa Apunai, kau bani ki nu negeyana nuwegei ki kau maramara nu negeyowa.” ");
INSERT INTO gdn_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Ko Iyesu mu ade tadebu, wagubu ke; “Nau niya ka iya ki bani. Iyapana nima nau diriwani kwaeyagisi ade nau bamaneya baiyagisi ki ka e wetei eba wainapono. Ade iyapana nima nau sumasiniyoto ki ka e awana gobai eba yogono. ");
INSERT INTO gdn_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Nau ororeya mena nidibuwani kewowena da wi nau emisiniyamu ko wi nau eba sumasiniyamu. ");
INSERT INTO gdn_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Ko iyapana gwedewau nau Mamai uburoto mu notamaga wirapoto da mu nau bamaneya baitagisi, iyapana ki nau eba tagararatamani bo kamaditamani. ");
INSERT INTO gdn_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Nau kunuma were kawapuwani ki ka eba nau naubo nuwaneya ki kwae-sugana ki nana nau bausugubuwani ko nau Tonosinibu Apunai e nuwaiya badidi ki makeya makeya kwaesugana ki nana ka nau bausugubuwani. ");
INSERT INTO gdn_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Nau Tonosinibu Apunai e nuwaiya ka nau iyapana kuduba tegebu ki mo eba wadana kaupana ki nana wagubu. Mara kwauneya ka nau suwagani manako mu kuduba iyatagisi ade kimoto ubumoto. ");
INSERT INTO gdn_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Nau Mamai e nuwaiya ka inako wainapiyau; Iyapana nima e Gubagai nau emisiniyau ade nau sumasiniyau ki ka iya maramara tondana kaniyana iyai ki e yadini. Mara kwauneya ka nau suwagani manako iyapana ki ade kiroto uburoto.” ");
INSERT INTO gdn_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Iyesu wagubu da; ‘Nau ka iya kunuma were kawapuwani ki bani’, e inako wagubu ki pokere Diyu ragidai yona ki wainamupu ki ka mu umunu kawakawaratagamawa, tagamawa ke; ");
INSERT INTO gdn_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","“E inai mamai ki nu katainugu. E ka eba kunuma were kawapu ko e ka apunu Diyosepa e gubagai.” ");
INSERT INTO gdn_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Mu inako tagubu ko Iyesu denai mu tadebu wagubu ke; “Wi umunu kawakawara ki kamadumuri. ");
INSERT INTO gdn_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Iyapana asusu nau bamaneya eba baitagisi ko nau Mamai iyapana nima nene yagisi, iyapana ki nau bamaneya baiyagisi. Mara kwauneya ki nau suwagani manako iyapana ki ade iyayagisi kiroto uburoto. ");
INSERT INTO gdn_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Mamanuga God e bonanai wainapamawa tagamawa ragidai naiya oka tamupu, tagubu ke; ‘Mamanuga God iyapana kuduba tadeyono kabukabuwa.’ Oka ki inako wagau ki pokere nau suwagani wainapumuri; Iyapana nima nau Mamai God e kabuwa yonai tapu ki naigida mena wainapiyau e rabineya surau ki ka e nau bamaneya mete baiyagisi. ");
INSERT INTO gdn_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Iyapana kuduba wi paunagau ka mo eyaka mena kwaitana nau Mamai e kiyabui eba empupu. Nau Mamai bameya tondekeya apunai nau niya mena e kiyabui matarau empuwani. ");
INSERT INTO gdn_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Nau yona mibai wi nidiyani wainapumuri; Iyapana nima nau sumasiniyau ki ka iya maramara tondana kaniyana iyai ki e wadubu kewowena. ");
INSERT INTO gdn_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Iya ki bani ka nau. ");
INSERT INTO gdn_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Wi ripakwarakwaraguma mu ka naiya gwabau bani ‘mana’ ki kupamawa iwa ko mu kuduba popotagubu gawarara. ");
INSERT INTO gdn_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Ko iyapana nima kunuma were kawapu ki bani kupoto ki ka e eba poyagisi ko maramara tondono kaniyono. ");
INSERT INTO gdn_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nau ka kunuma were kawapuwani. Nau ka maramara idiwana kaiwana ki bani. Bani ki nau wi negeyani ki ka nau niya midini kwakwarepuni ki nau iyapana kuduba, madega kauwagau madega posiwagau wi iyaga nene tarani. Iyapana nima bani ki kupoto ki ka e maramara tondono kaniyono.” ");
INSERT INTO gdn_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Diyu ragidai Iyesu yonai wagubu ki wainamupu ka mu notamaga baba-wena mu bonanamaga ragiragi kawaya mubo mubo deni deni tagamawa kasiwara, tagamawa ke; “Apunu yau ka badidi maba nu e midi kwakwarepui kupamana ki nana wagau?” ");
INSERT INTO gdn_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Ko Iyesu denai wagubu ke; “Nau yona mibai wi nidiyani wainapumuri; Wi Kunumau Kawapuwani Apunai nau midini kwakwarepuni eba kupumuri ade nau darani mete eba kubamuri ki ka iya wi rabinagau ka popai. ");
INSERT INTO gdn_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Nima nau midini kwakwarepuni kupoto bo ade nau darani mete kuburoto ki ka iya maramara tondana kaniyana iyai ki e wadubu kewowena manako mara kwauneya ka nau uburani e iyapani da e ade kiroto uburoto. ");
INSERT INTO gdn_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Nau midini kwakwarepuni ki ka bani mibai. Ade nau darani ki ka awana mibai. ");
INSERT INTO gdn_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Iyapana nima nau midini kwakwarepuni kupoto ade nau darani mete kuburoto ki e yo nau ka ewapuru eyaka mena. E nau mete idiwomu ade nau e mete idiwomu. ");
INSERT INTO gdn_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Nau Mamai nau tonosinibu ki e ka maramara tondau ki apunai ki pokere nau mete maramara tondoni. Ko ki maba, iyapana nima nau midini kwakwarepuni kupoto ki ka nau pokanere ka e mete maramara tondono kaniyono. ");
INSERT INTO gdn_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bani mibai kunuma were kawapu ki ka eba wi ripakwarakwara-guma bani kupamawa ade ewa popo-tagubu ki bani maba. Iyapana nima kunuma bani nau kweyani ki kupoto ki ka e eba poyagisi ko iya maramara tondono kaniyono.” ");
INSERT INTO gdn_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Iyesu natere Kaponiyamu guriguri tawai rabineya yona ki iyapana kuduba kabuwatamiyawa tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Iyesu e tadeyau kabukabuwa ragidai yona ki wainamupu ka mu ropani kawaya dai tagubu ke; “Yona yau ka ragiragi kawaya nu eba wainapamana wainapemei.” ");
INSERT INTO gdn_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Mu mubo mubo inako notapa-mawa ko mu nuwamaga notamaga ki kuduba Iyesu empupu kewowena ki pokere e tadebu, wagubu ke; “Nau midini kwakwarepuni wi kupamana ki nana suwagubuwani ki pokere wi notababa wadumpu ade nau kamadi-sinimana kaigamana wainapiyamu bo? ");
INSERT INTO gdn_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Baganai, ko nau ade suwagani wainapumuri; Nau Kunumau Kawapuwani Apunai ade wirasugani nau naiya tondekeya wataneya ki ade tondoni emisinimuri ki ka wi badidi iwagi? ");
INSERT INTO gdn_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Mamanuga God e eya Keyai ki e mena wi iya negeyau ko wi wiga mena ka kasiyaraga pa mena. Nau yonani nidibuwani ki rabineya ka nau Mamai e eya Keyai ika mete kina. Ki pokere, nau yonani suwagubuwani ki pokaiya ka wi iya wadumuri.” ");
INSERT INTO gdn_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Iyesu ewakumapamawa ragidai mu paunamugu ka iyapana dai e naigida mena eba sumamupu ade mu paunamugu ka aita ewa yogo wagana apunai ki mete kina. Ko ki kuduba ka Iyesu e ororeya mena kataiya ki pokere e mu ade tadebu, wagubu ke; “Nau kataineya da wi dai nau mete eba sumasiniyamu, ");
INSERT INTO gdn_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ki pokere nau naiya mena nidibuwani da iyapana asusu nau bamaneya eba baitagisi ko iyapana gwedewau nau Mamai uburoto mu rabinamaga wirapoto ki mu mena nau bamaneya baitagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Iyesu ewakumapamawa ragidai yona ki wainamupu ka mu ropani kawaya mu midimaga togawena manako wiratagubu mu mubo mubo kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Mu ropani kawaya inako kayatagubu ki pokere Iyesu e eya tadeyau kabukabuwa ragidai ida esida kewowena kerapu apeya (12) ki mu mete manutapu, wagubu ke; “Ade wi mete kina nau kamadisinimana kaigamana wainapiyamu bo?” ");
INSERT INTO gdn_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Ko apunu Saimoni si daikere Pita ubupu denai wagubu ke; “Kaiwawoni, nu kau kamadiniyamu ki ka nu bani kaigamu? Nu Iya Negeyana Yonai ki kau mena nu nidiyei. ");
INSERT INTO gdn_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Nu katainugu da Mamanuga God e eya winepupu ade tonopupu apunai tanai bagi kawaya ki kau kiya mena.” ");
INSERT INTO gdn_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Apunu Saimoni inako wagubu, manako Iyesu denai wagubu ke; “Nau iyapana ida esida kewowena kerapu apeya (12) wi winenibuwani, ko nau nidiyani wainapumuri; Wi paunagau apunu eyaka mena ka Berokoi Apunai Seitani e bigabigai.” ");
INSERT INTO gdn_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Iyesu yona ki wagubu ki ka e apunu Saimoni mosi si daikere ka Isikariyoto e gubagai Diyudiyasi ki e nene wagubu. Apunu Diyudiyasi e ka Iyesu e tadeyau kabukabuwa apunai mosi ko e ka ade Iyesu e yogoi ki wagana apunai. ");
INSERT INTO gdn_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Diyu ragidai mu kawakawaimuguma Iyesu minimana po ki nana wainapamawa ki pokere Iyesu tawana Diyudiya mo eba kayawena ko e tawana Gariri rabineya mena umawa wadawa. ");
INSERT INTO gdn_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Diyu ragidai mu poragamaga mo si ka ‘Nabonabo Poragai’ tagamu ki marai rogobiwena, ");
INSERT INTO gdn_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","manako Iyesu e eya yowaiyoma e bameya bautagubu, simupu, tagubu ke; “Kau tawana yau kamadi tawana Diyudiya ade kaya-nuwagi manako kau matakiragi mo ika kwaenuwagi da kau tadeyei kabu-kabuwa ragidai matakira ki empomoto manako kau sumanimoto. ");
INSERT INTO gdn_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Kau yewe Gariri rabineya weki gwaiya kwaenugei ki ka iyapana kau eba eminimoto sumanimoto ko kau kayanuwagi ika poraga kawaya ki kawareya kau matakiragi matarau kwaenugowa ki ka iyapana kuduba kau eminimono sumanimono.” ");
INSERT INTO gdn_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","(Mu inako tagubu mibai ka mu mete kina e eba sumamupu.) ");
INSERT INTO gdn_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Ko Iyesu denai mu tadebu, wagubu ke; “Wi wainapiyamu da nau naubo nuwaneya mena kwaesugakani, ko ki pa mena. Nau marani tondau, mana bauwagana kena, ko wi maraga ka asusu. ");
INSERT INTO gdn_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Nau iyapana rabinamugu bigi posiwena uburau ki empuwani matarau suwagakani ki pokere iyapana kuduba nau midi ragiragisiniyamu. Ko mu wi mo eba kiraniyamu. ");
INSERT INTO gdn_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ki pokere baganai, wi wibo poraga ki kawareya kaiwagi ko nau marani eba bauwena ki pokere nau yewe tondoni.” ");
INSERT INTO gdn_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Iyesu inako wagubu manako e tawana Gariri rabineya ika tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Iyesu yowaiyoma poraga ki kawareya kayatagubu ka e mete kina mu ewamugu kipu ubupu weki gwaiya kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ko Diyu ragidai mu kawakawaimuguma ka poraga ki kawareya Iyesu nene kwaenetagamawa yabu tamawa idiwa, tagamawa ke; “Apunu ki bani? E baiyagisi bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","13","Iyapana pakasi ragidai mete kina Iyesu nene tagamawa ko mu kawakawaimuguma kudumugu waina-pamawa ki pokere e sisiyai ki mu weki gwaiya mena umana misimisi were manu kasiwaratagamawa idiwa. Dai tagamawa ke; “E ka apunu bagi kawaya mosi.” Ko dai tagamawa ke; “Pa mena, e ka iyapana kuduba nu beraniyau.” ");
INSERT INTO gdn_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Poraga ki paunau ka Iyesu kaya-wena Mamanuga God e Tawai ki rabineya bauwena manako ika iyapana tadeyawa kabukabuwa tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","E yonawagawa wainamupu ka Diyu ragidai kawakawaimuguma mu nota-maga babawena manako mu tagubu ke; “E ka pakasi apunai mosi ko e gwede ba yona kawaya kawaya inako wagau?” ");
INSERT INTO gdn_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Mu inako tagamawa ko Iyesu denai mu tadebu, wagubu ke; “Nau Mamai God nau tonosinibu ki pokere nau karako nidiyakani ki ka eba nau naubo yonani ko nau Mamai badidi kabuwasiniyau ki mena nau makeya makeya suwagakani. ");
INSERT INTO gdn_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Nau Mamai God e yonai wi nidiyakani bo ade nau naubo notani pokaiya suwagakani ki wi naigida kataigamana wainapiyamu ki ka wi Mamanuga God e nuwaiya badidi ki makeya makeya kwaiwogoi were kataiwagi. ");
INSERT INTO gdn_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Iyapana nima e ebo kasiyarai pokaiya kwaewagau ki ka e ebo kawai gisipiyau. Ko iyapana nima e tonopupu apunai e si tepapiyau kwae-wagau ki ka e mibai mena kwaewagau. E bameya ka bera mo pa mena. ");
INSERT INTO gdn_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Oragai apunai Mosisi ubupu gora wi negebu ko wi gora ki makeya makeya eba kwaiwagamu. Wi kwaigumpena ki ka wi eba nau susinimana po wainampena.” ");
INSERT INTO gdn_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Iyesu yona ki wagubu ka iyapana kuduba denai tagubu ke; “Kau ka bani keyai berokoi mosi kau yabaragi giripiyau ki pokere kau babanugibi nuwegei. Iyapana nima kau nuniyana po wainapiyau?” ");
INSERT INTO gdn_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","23","Ko Iyesu denai wagubu ke; “Nau ubupuwani apunu mosi aiyata marai ki makeya iyapuwani ki pokere wi wakapa girigubu nau kirasiniyamu. Ko wi mete kina aiyata marai inako upiwagamu. Munu uratanai mosi wenayagisi ki ka mara ida daikere kewowena daikere apeya eyaka (8) ki kewoyagisi makeya ki ka wi oragai apunai Mosisi gora badidi tapu ki makeya makeya aiyata marai ki mete kwaiwagamu. (Ko ki ka eba oragai apunai Mosisi gora ki yabiri tapu ko ki ka wi ripakwarakwaraguma bususu ki kerarai birikamupu.) Ki pokere, nau apunu ki aiyata marai deni mena iyapuwani ki ka wi badidi pokere nau kirasiniyamu? Wi mete aiyata marai ki makeya upiwagamu. ");
INSERT INTO gdn_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Nari asusu yabayababa eba iwogoi ko naigida empumuri wetawetara were iwagi.” Iyesu inako tadebu. ");
INSERT INTO gdn_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Natere kawaya Diyerusaremu rabineya ka iyapana pakasi ragidai dai ki Iyesu ika emupu manako mu mubo deni deni manu kasiwaratagamawa, tagamawa ke; “Kawakawai ragidai apunu mo minimana po yanuwei teyamawa ki apunu yau baganai bo? ");
INSERT INTO gdn_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","E bauwena nu matarau nidiyau kabukabuwa umau ko mu badidi pokere e eba miniyamu poyo? Kawakawai ragidai mu notamaga karako wirawena da mu mete wainapiyamu da e ka nu Iya Negeyana Apunai Keriso bo?” ");
INSERT INTO gdn_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Mu inako tagubu ade tagubu ke; “Ko badidi? Nu Iya Negeyana Apunai Keriso baiyagisi ki ka nu e tawana bani deneya bauwagana ki nu eba kataigamana ki nana ko apunu yau e bauwena tawanai ki nu katainugu.” ");
INSERT INTO gdn_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Iyesu mu yonamaga ki wainapupu ka e Mamanuga God e Tawai rabineya e bonanai ragiragi kawaya wagubu ke; “Wi iwagubu ke; ‘E inai mamai ki nu katainugu.’ Ko nau nidiyani wainapu-muri; Nau tawana bani deneya bausugubuwani ki wi eba kataigau. Nau ka eba nau naubo kasiyarani pokaiya bausugubuwani. Nau Tonosinibu Apunai e ka mibai mena kwaewagau ki apunai, ko e wi eba kataigau. ");
INSERT INTO gdn_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Nau kataineya eyo mibai ka nau e bameya tondekeya manako e nau tonosinibu yewe wairau kawapuwani.” ");
INSERT INTO gdn_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Iyesu yona ki wagubu makeya ka Diyu ragidai mu kawakawaimuguma e wadamana kwaetagubu ko e wadamana marai eba bauwena ki pokere mu e kamadumpu. Iyapana dai e wadamana wainamupu, ");
INSERT INTO gdn_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ko ade dai e sumamupu, tagubu ke; “Nu wainapemei da nu Iya Negeyana Apunai Keriso ka apunu yau baganai. E matakirai kwaewagau ki ka mu takari kawaya Keriso bauwagana matakira kwaewagana tagubu ki matakirai maba e karako makeya makeya kwaewagau yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Parisi ragidai iyapana Iyesu sisiyai inako umana misimisi tagamawa idiwa wainamupu ka mu ubumpu Mamanuga God bameya dobopiyamu ragidai mete kina piyara ragidai dai Iyesu wadamana ki nana tonotampu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Ko Iyesu wagubu ke; “Nau wi mete mara rowarowa kawaya eba idiwomu. Nau waunitau ade wirasugani nau Tono-sinibu Apunai e bameya ade kayasugani, ");
INSERT INTO gdn_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","manako wi nau kwaeneni kwaiwogoi ko wi nau ewa mo eba emisinimuri mibai ka nau kayasugana tawanai ki wi kwaitana eba kaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Diyu ragidai mu kawakawai-muguma yona ki wainamupu ka mu babatagubu mu mubo deni deni manu kasiwaratagamawa, tagamawa ke; “Apunu yau ka bani kayawagana da nu e ewa mo eba empamana ki nana wagau? E tawana Gurisi rabineya Diyu ragidai dai ika idiwu tawanai ki kayawagana manako tawana ki ragidai yona mo tadeyana kabukabuwa ki nana wagau bo? ");
INSERT INTO gdn_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","E wagubu da; ‘Wi nau kwaeneni kwaiwogoi ko wi nau ewa mo eba emisinimuri’, ade wagubu da; ‘Nau kayasugana tawanai ki wi kwaitana eba kaiwagi’, e inako wagubu ki mibai ka badidi?” Mu inako tagamawa. ");
INSERT INTO gdn_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Mu poragamaga siyareya ka mu maramaga kawai manako ki makeya ka Iyesu ubupu e bonanai ragiragi kawaya wagubu ke; “Iyapana nima awana gobai wagau ki ka e nau bamaneya baiyagisi awana kuburoto. ");
INSERT INTO gdn_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Mamanuga God e okai mo wagubu ke; ‘Iyapana nima nau sumasiniyono ki ka Iya Maramara Idiwana Awanai ki yabai e rabineya usirapono tondono.” ");
INSERT INTO gdn_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Iyesu Iya Awanai nene wagubu ki ka e Mamanuga God e Keyai ki waigugui wagubu. Ko ki ka e Mama-nuga God bameya kunuma taneya yarana were ewa puyo ki tonopana ki nana wagubu. Iyapana nima uburoto e sumapoto ki ka Mamanuga God e eya Keyai iyapana ki kweyoto. ");
INSERT INTO gdn_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Iyapana ropani kawaya Iyesu yonai ki wainamupu ka mu dai tagubu ke; “Mamanuga God e Bonanai Waina-piyau Wagau Apunai ki nawanai nu idiweya ki apunai karako wana bau-wena yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ade dai tagubu ke; “E ka Nu Iya Negeyana Apunai Keriso.” Ko dai tagubu ke; “Pa mena. Apunu yau e ka tawana Gariri ragidai mu apunumaga mosi ko Keriso e ka tawana Gariri were eba bauwagana wainapemei. ");
INSERT INTO gdn_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Mamanuga God e okai mo wagubu ke; ‘Nu Iya Negeyana Apunai Keriso e ka oragai apunai Dewida e momai. E ka oragai apunai Dewida e naterei Beteriyemu rabineya wenayagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Iyapana Iyesu sisiyai inako mubo mubo tagamawa ko mu rabinamaga ka eba eyaka mena. ");
INSERT INTO gdn_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Mu dai e wadamana wainapamawa ko mu e eba wadumupu. ");
INSERT INTO gdn_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Piyara ragidai Iyesu wadamana ki nana bautagubu ko eba wadumupu ki ade wiratagubu Mamanuga God bameya dobopiyamu ragidai ade Parisi ragidai mete kina mu bamamugu bautagubu. Bautagubu manako kawakawai ragidai ki ubumpu mu manutampu, tagubu ke; “Wi badidi pokere apunu ki eba wadu-mupu ko pa baigubu?” ");
INSERT INTO gdn_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Ko piyara ragidai ki denai tagubu ke; “Apunu ki e yonai ka kasiyarai kawaya. Iyapana mo e maba inako pa mena.” ");
INSERT INTO gdn_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Kawakawai ragidai yona ki wainamupu ka mu denai kiratampu, tagubu ke; “E wi mete rabinaga wira-pupu ki pokere wi e eba wadumupu baigubu bo? ");
INSERT INTO gdn_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","49","Wi pakasi ragidai ka bani Mamanuga God e kowagai rabineya idiwu ki pokere oragai apunai Mosisi nu goranuga tapu ki wi eba wainapiyamu. Ko nu kawakawai ragidai ade Parisi ragidai mete kina ki nu ka apunu beraberai ki e yonai mo nu eba sumapemei.” ");
INSERT INTO gdn_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Ki makeya ka Parisi ragidai mu iyapanamaga mosi naiya Iyesu bameya weki gwaiya bauwena apunai si ka Nikodimasi ki e ubupu e kowaiyoma ki inako tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Nu goranuga tapu ki inako wagau; ‘Iyapana mosi e waretai siyoto wirawira ki ka yabiri e waretai ki uburoto e eya yonai yagisi wainapamu da nu e paerei ki kerarai kwaenepamu mibai bo bera. Ki eweya ka nu ubumamu e bita kweyamu bo ade eba kweyamu.” ");
INSERT INTO gdn_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Apunu Nikodimasi inako wagubu ko mu ubumpu e mete kiramupu, tagubu ke; “Kau mete banipo tawana Gariri ragidai mu iyapanamaga mosi bo? Kau Mamanuga God e okai tampu ki naigida mena empena ki kau katai-nugubena da Mamanuga God e bonanai wainapana wagana apunai ki e ka tawana Gariri were eba baiyagisi.” Mu inako tagubu, ");
INSERT INTO gdn_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","manako kimpu ubu-mpu mu mubo mubo tawanamugu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Iyesu ripa ‘oripi’ wenatagubu kweyai ki yapu kayawena ukwapu nawaru puruwena, ");
INSERT INTO gdn_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","manako ade wirawena Mamanuga God e Tawai ki rabineya bauwena. Bauwena ka iyapana ropani kawaya e bameya bautagubu manako e kwarisiwena tondubu ika yona mu tadeyawa kabukabuwa tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Ki makeya ka iyapana kawakawai Mamanuga God e gorai kataimugu ragidai ade Parisi ragidai dai mete kina ridi mosi wadumpu Iyesu bameya bautagubu. Ridi ki ka mibi anikai ko e nobomoi rauru kawakawarapupu apunu mo mete iwa ki mu emupu matara ki pokere mu ridi ki karako wadumpu bautagubu iyapana ropani kawaya ki mu yabaramugu tamupu. ");
INSERT INTO gdn_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Tamupu manako Iyesu simupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, ridi yau ka e nobomoi rauru kawakawarapupu apunu mo mete iwa da nu mu emitampi matara. ");
INSERT INTO gdn_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Oragai apunai Mosisi nu goranuga tapu da ridi mosi mibi anikai inako kwaeyagisi ki ka nu bowa pokaiya e miniyamu poyo. Ko kau ridi yau nene badidi wainapiyei? Nu e miniyamu poyo bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Mu manu ki tagubu mibai ka mu nuwa-mugu Iyesu yona denai paerepana da mu ki pokaiya e wadamana ki nana wainamupu. Ko Iyesu yona mo eba wagubu ko e kuwena e idai gurai pokaiya waira pa okapiyawa. ");
INSERT INTO gdn_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Mu e kawareya kawareya ade manupamawa empamawa idiwa ki pokere e pairawena mu emitapu manako tadebu, wagubu ke; “Baganai, kau nima wainapiyei da kau bigigi pa mena ki kau yabiri kiri uburi bowa pokaiya ridi yau mini.” ");
INSERT INTO gdn_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","E inako wagubu manako ade kuwena waira ade pa okapiyawa. ");
INSERT INTO gdn_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Iyapana e yonai ki wainamupu ka mu eyaka eyaka ridi ki kamadumpu kayatagubu. Kawakawai ragidai mu yabiri kimpu ubumpu kayatagubu manako mu ewamugu ka iyapana kuduba kayatagubu gawarara. Ko ridi ki ebo mena Iyesu mete ika idiwa. ");
INSERT INTO gdn_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Iyesu ade pairawena manako ridi ki empupu manupupu, wagubu ke; “Ridi, iyapana bani kayatagubu? Karako nima kau nidiyoto wirawira?” ");
INSERT INTO gdn_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Ko ridi ki denai e sibu, wagubu ke; “Kaiwawoni, iyapana mo yewe pa mena.” E inako wagubu manako Iyesu denai wagubu ke: “Nau mete kina kau eba nidiyani ki pokere kau pa kayanuwagi. Ko kau bera berokoi kwaenugibi ki kau ewa inako mo eba kwaenuwagi.” Iyesu inako sibu. ");
INSERT INTO gdn_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Iyesu iyapana ade tadebu, wagubu ke; “Nau ka iyapana kuduba wi Tanai Negeyakani Apunai. Iyapana nima nau ewaneya yabadini ki ka e sisipu rabineya eba tondono ko e iya yawatai ki taneya maramara tondono kaniyono.” ");
INSERT INTO gdn_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Parisi ragidai yona ki wainamupu ka mu denai e simupu, tagubu ke; “Kau kiya sisiyagi nuwegei ade kau kiya sigi tepapiyei ki pokere kau yonagi ki mibai pa mena.” ");
INSERT INTO gdn_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Ko Iyesu denai mu ade tadebu, wagubu ke; “Nau niya sisiyani suwagu-buwani ki ka nau eba berasugubuwani mibai ka nau tawana bani were bausugu-buwani ki ade kayasugani ki ka nau naubo mena kataineya. Ko tawana ki wi mo eba kataigau. ");
INSERT INTO gdn_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Wi ka waira yau notai pokaiya nari kasiwaraiwagamu idiwu ko nau wi mo eba nariniyakani. ");
INSERT INTO gdn_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Wi bera berokoi kwaiwagamu ki denai mo nau wi nidibena ki ka nau yona mibai mena wi nidibena mibai ka nau Tono-sinibu Apunai badidi kabuwasinibu ki mena nau makeya makeya mena wi nidibena. ");
INSERT INTO gdn_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Wi wiga goraga rabineya ka mu oka inako tampu, tagubu ke; ‘Iyapana apeya gwede mo ewapuru emupu ki baitagisi ewapuru tagisi matara ki mibai.’ ");
INSERT INTO gdn_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ki pokere, wainapumuri; Nau naiya badidi empuwani sisiyai suwagubuwani ki ka eba nau niya mena suwagubuwani ko ki ka ade nau Mamai tonosinibu ki e mete nau sisiyani ki wagubu. Ki pokere, nau yonani yau nidibuwani ki mibai.” ");
INSERT INTO gdn_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Iyesu inako wagubu, ko iyapana ki e ade manumupu, tagubu ke; “Ko kau mamagi ka bani?” Ko Iyesu denai wagubu ke; “Nau Mamai mete kina ki e wi eba kataigau. Wi nau kataisinimpena ki ka wi nau Mamai mete kataigumpena. Ko wi eba kataigau nau ki pokere nau Mamai ki e wi mete eba kataigau.” ");
INSERT INTO gdn_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Iyesu Mamanuga God e Tawai rabineya ‘Puyo Nakapiyamu Wateya’ ika iyapana yona ki tadeyawa kabukabuwa tondawa. Ko e marai eba bauwena ki pokere mu e eba wadumupu. ");
INSERT INTO gdn_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Iyesu mu ade tadebu, wagubu ke; “Nau kamadiniyani kayasugani ki ka wi nau kwaeneni kwaiwogoi ko wi beraga berokoi ki pokere wi bigiga pokaiya ka wi aita popoiwagi. Nau kayasugani tawanai ki wi kwaitana eba kaiwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Iyesu inako wagubu ki pokere Diyu ragidai mu kawakawaimuguma ubumpu mu mubo deni deni manu kasiwaratagamawa, tagamawa ke; “Nu e eweya eba kaigamana wagubu ki mibai ka badidi? E ebo wadewagana ki yonai wagubu bo?” ");
INSERT INTO gdn_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Ko Iyesu denai mu tadebu, wagubu ke; “Wi ka waira yau ragidai ko nau ka kunuma apunai. Wi ka yewe wairau wenaigubu ko nau ka pa mena. ");
INSERT INTO gdn_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Nau Mamai Tonosinibu Kawapuwani Apunai ka nau baganai ko nau sisiyani ki nau ororeya mena wi nidibuwani kewowena. Wi eba mibipumuri da nau ka eyo ki ka wi wibo paerega pokaiya popoiwagi, ko ki ka wi wibona.” ");
INSERT INTO gdn_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Iyesu inako wagubu ko mu e ade manumupu, tagubu ke; “Ko kau ka nima?” ");
INSERT INTO gdn_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","E denai mu ade tadebu, wagubu ke; “Ki nau ororeya mena wi nidibuwani kewowena. Nau wi wade supasupaniyana ki nana yona kawaya daganani mo kawareya ade nidiyana wainapakani ko nau Tonosinibu Apunai badidi wagau ki mena nau makeya makeya wi nidiyani. E badidi wagau ki kuduba ka mibai.” ");
INSERT INTO gdn_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Iyesu inako wagubu ko mu eba wainamupu da e Mamanuga God nene wagubu ki pokere e mu ade tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","“Wi nau Kunumau Kawapuwani Apunai aita iyarau bagisinimuri makeya ki wi kataiwagi da nau ka eyo. Ki makeya ka wi mete kataiwagi da nau yona kuduba wi nidiyekeya ki ka nau Mamai badidi kabuwasiniyawa ki mena nau makeya makeya wi nidiyekeya. ");
INSERT INTO gdn_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Nau Tono-sinibu Apunai e ka maramara nau mete ewapuru idiwei. E nau eba kamadisini-yoto mibai ka nau badidi kwaesugakani ki ka nau e nuwaiya badidi ki mena kwaesugakani.” ");
INSERT INTO gdn_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Iyesu yona ki wagubu makeya ka iyapana ropani kawaya e sumamupu. ");
INSERT INTO gdn_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Iyesu ubupu Diyu ragidai e sumamupu ki tadebu, wagubu ke; “Wi nau yonani nidibuwani ki makeya makeya kwaiwogoi ki ka wi mibai nau iyapananiyoma. ");
INSERT INTO gdn_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ade wi nau yonani nidibuwani ki mibai mete wainapumuri ki ka yona mibai ki uburoto berokoi badidi umanibu dokodoko ki rikapoto manako wadiniyoto bagi.” ");
INSERT INTO gdn_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Iyesu inako wagubu ko mu denai e simupu, tagubu ke; “Nu ka oragai apunai Eburamu e ripakwarakwaraiyoma. Nu ka eba yabayababa da iyapana nu wadinimoto dokodoko manako nu mu bigamaga kwaigomu. Ko kau gwede nana nidiyei da gwede mosi nu umanibu dokodoko? Gwede mosi nu eba umanibu dokodoko wainapemei.” ");
INSERT INTO gdn_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Ko Iyesu denai wagubu ke; “Nau yona mibai wi nidiyani wainapumuri; Iyapana nima bera berokoi kwaewagau ki ka nota berokoi ki e wadubu doko-doko. ");
INSERT INTO gdn_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Bigabiga mena kwaewagau apunai ki e ka kawai apunai e tawaiya maramara eba tondono. Ko kawai apunai ki e eya gubagai ki e ka mara-mara e mamai tawaiya tondono. ");
INSERT INTO gdn_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Ki pokere, Mamanuga God e Gubagai nau uburani nota berokoi wi umanibu dokodoko ki rikapani ki ka nota berokoi ki deni mena kewoyagisi ko ewa mo wi eba umaniyoto dokodoko. ");
INSERT INTO gdn_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Nau kataineya da wi ka oragai apunai Eburamu e momai. Ko nau yonani kabuwaniyakani ki wi rabinagau eba supu ki pokere wi nau susinimana po mete wainapiyamu. ");
INSERT INTO gdn_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Nau Mamai badidi kabuwasinibu ki makeya makeya nau wi nidiyakani ko wi wibo mamaga badidi nidiyau ki mena wi makeya makeya kwaiwagamu.” ");
INSERT INTO gdn_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Iyesu inako wagubu ko mu denai tagubu ke; “Nu mamanuga ka Eburamu.” Ko Iyesu mu ade tadebu, wagubu ke; “Wi mibai apunu Eburamu e munu-iyoma maba ki ka wi e badidi kwae-wagawa ki maba wi mete inako kwaigu-mpena, ko wi ki eba kwaiwagamu. ");
INSERT INTO gdn_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Nau Mamai yona mibai mena nau sidibu ki mena nau wi nidiyakani ko wi nau susinimana po ki nana waina-piyamu. Oragai apunai Eburamu bera inako mo eba kwaewena, ");
INSERT INTO gdn_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","ki pokere wi mamaga ka eba Eburamu. Wi mamaga ka apunu kudubai mosi. E berai badidi kwaewagau kabuwaniyau ki wi karako makeya makeya kwaiwagamu.” Iyesu inako wagubu ko mu denai tagubu ke; “Nu ka eba yawata kawa-kawareya wenaigibi. Nu Mamanuga ka God eya mena.” ");
INSERT INTO gdn_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Ko Iyesu denai mu tadebu, wagubu ke; “Wi Mamanuga God e munuiyoma maba idimpibena ki ka wi nuwaga notaga nau bamaneya tondibena, mibai ka nau naubo asusu eba bausugubuwani ko nau Mamai nau tonosinibu yewe kawapuwani. ");
INSERT INTO gdn_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Nau nidiyani wainapumuri; Wi mamaga ka wi wenaguga bodapupu ki pokere nau yonani suwagakani ki wi naigida eba wainapiyamu. ");
INSERT INTO gdn_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Wi mamaga ka Berokoi Apunai Seitani ki pokere wi nuwagau ka e badidi kwaewagau ki wi kawareya inako mete kwaiwagamana waina-piyamu. Berokoi Apunai Seitani e ka kerareya mena minimini popo kwae-wagawa. E ka yona bera kuduba ki mamai, mibai ka e rabineya ka bera mena posiwena. ");
INSERT INTO gdn_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Nau yona mibai mena wi nidiyakani ko wi ubumu wi mamaga Seitani e diriwai mena kwaiwagamu ki pokere nau yonani ki wi eba sumapiyamu. ");
INSERT INTO gdn_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Nau bera berokoi mo eba kwaesugubuwani emisinimupu. Nau yona mibai mena wi nidiyekeya ki pokere wi nau sumasini-mpena, ko wi nau eba sumasiniyamu. ");
INSERT INTO gdn_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Mamanuga God e munuiyoma ki mu ka e yonai wainapomono sumapomono. Ko wi ka eba e munuiyoma ki pokere e yonai ki wi mete eba wainapamana sumapamana wainapiyamu.” ");
INSERT INTO gdn_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Iyesu inako wagubu, ko Diyu ragidai gagayatagubu manako denai tagubu ke; “Nu mibai iwegemei; Kau ka tawana Sameriya ragidai mu apunu-maga mosi. Kau rabinageya ka kweya kairapu mosi tawawena tondau.” ");
INSERT INTO gdn_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Mu inako tagubu, ko Iyesu denai mu tadebu, wagubu ke; “Kweya kairapu mosi nau rabinaneya eba tondau. Nau Mamai God e si mena nau tepapakani ko wi ubumu nau sini kaupiyamu. ");
INSERT INTO gdn_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Nau ka eba iyapana nau sini tepapamana ki nana suwagakani. Nau Mamai e mena nau sini tepapiyau ko ki e ewa nau nene uburoto yagisi. ");
INSERT INTO gdn_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Nau yona mibai wi nidiyani wainapumuri; Iyapana nima nau yonani wainapoto makeya makeya kwaeyagisi ki ka karako ade aita ewa ki e eba poyagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Diyu ragidai yona ki wainamupu ka mu Iyesu kawareya ade kirapamawa, tagamawa ke; “Karako ka nu kataigibi kewowena da keyai berokoi mosi kau rabinageya tondau. Oragai apunai Eburamu e powena ade Mamanuga God e bonanai wainapamawa tagamawa ragidai ki mu mete popotagubu gawarara ko kau nuwagibi da, ‘Iyapana nima nau yonani wainapoto makeya makeya kwaeyagisi ki ka e eba poyagisi’, kau inako nuwagibi ki badidi maba? ");
INSERT INTO gdn_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nu ripakwarakwaranuga kawai Eburamu e ka naiya takari kawaya mena powena ade Mamanuga God e bonanai waina-pamawa tagamawa ragidai ki mu mete popotagubu gawarara. Ko kau ka nima? Kau wainapiyei da mu kuduba ka kau kobageya bo? Nu wainapemei da kau kiya kawai gisipiyei.” ");
INSERT INTO gdn_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","55","Mu inako tagubu, ko Iyesu denai mu tadebu, wagubu ke; “Nau niya sini tepapibena maba ki ka nau yonani mibai pa mena. Ko karako ka eba nau niya sini tepapakani ko nau Mamai God e mena nau sini tepapiyau. Wi iwagamu da; ‘E ka nu Mamanuga God’, ko nau suwagani wainapumuri; Nau Mamai ki e wi eba kataigau. Nau niya mena e kataipuwani. Nau suwagubena da, ‘Nau eba kataineya eyo’, ki ka nau wi maba berasugubena. Ko nau Mamai God e nau kataipuwani kewowena ki pokere e badidi wagau ki nau makeya makeya kwaesugakani. ");
INSERT INTO gdn_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Wi ripakwarakwaraga Eburamu nau wenasugana yonai takari kawaya wainapupu ki ka e nau nene mamamawena. Ade e nau wenasugu-buwani emisinibu ki ka e ade mamama kawaya daganani mete wainapupu.” ");
INSERT INTO gdn_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Diyu ragidai yona ki wainamupu ka mu Iyesu kawareya ade kirapamawa, tagamawa ke; “Kau ka munu waunai. Kau kwamuragi ka eba apunai apeya ade ida esida mena (50) kewowena. Oragai apunai Eburamu e ka ororeya mena powena were kau wenanugibi ko kau e matarau empipi nuwegei?” ");
INSERT INTO gdn_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Mu inako tagubu ko Iyesu denai wagubu ke; “Nau yona mibai wi nidiyani wainapumuri; Oragai apunai Eburamu eba wenawena makeya ki ka nau tondekeya yabedekeya da karako.” ");
INSERT INTO gdn_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Iyesu yona ki wagawa ka iyapana e bowa were minimana po kwaetagubu. Ko e weki gwaiya Mamanuga God e Tawai ki kamadubu bauwena kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Iyesu yawatau kaniyawa ka e apunu mosi e inai rabineya yabui kenekenei wenawena ki ika tondawa empupu. ");
INSERT INTO gdn_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Empupu manako e tadeyau kabukabuwa ragidai bautagubu Iyesu manumupu, tagubu ke; “Nidiyei Kabukabuwa Apunai, apunu ki e inai rabineya inako e yabui kenekenei wenawena ki mibai ka badidi? E eya paerepupu ki pokere, bo e inai mamai paeremupu ki pokere e yabui kene-wena?” ");
INSERT INTO gdn_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Ko Iyesu denai mu tadebu, wagubu ke; “Apunu yau e yabui kenewena ki ka eba e eya kwaewena bo e inai mamai paeremupu. Ki pa mena. E yabui kene-wena ki kerarai ka yau kena; E pokaiya ka Mamanuga God matakira mosi kwaeyagisi manako iyapana Mamanuga God e kasiyarai kawaya matarau em-pomoto. ");
INSERT INTO gdn_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Iyapana mosi, nawarau ki ka e upiyogono ko kemorau ki ka e pa tondono. Ki maba, nau Mamai tonosinibu e upi ki nu nawarau mena yodomu ko mara baiyagisi da sisipu umoroto da nu e upi kwaigamana ki yawatai mo pa mena. ");
INSERT INTO gdn_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Nau yewe wairau tondakani ki ka nau iyapana kuduba, madega kauwagau madega posiwagau wi dunaga.” ");
INSERT INTO gdn_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Iyesu inako wagubu manako waira tepopupu e idaiya kotopupu da dogiya wenapupu manako kanibu apunu ki e yabuiya dogiya pasipupu. ");
INSERT INTO gdn_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","E dogiya pasipupu kewowena ka e apunu ki sibu, wagubu ke; “Kau kayanuwagi kaburu Saromi rabineya kau kiyabugi siruwapi.” (Yona ‘Siramu’ ki mibai ka ‘Tonopupu’.) Apunu ki kayawena e kiyabui buri siruwapupu manako e wirawena yabadawa makeya ki wana e yabui pawena tawana empupu. ");
INSERT INTO gdn_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Naiya ka apunu ki maramara yawata kwaiya bowa madai nene genewagawa tondawa ki pokere e kowaiyoma ade iyapana e naiya badidi maba genewagawa tondawa empamawa ki karako e emupu ki ka mu babatagubu mu mubo deni deni manu kasiwara-tagamawa, tagamawa ke; “Apunu naiya genewagawa tondawa ki apunai yau baganai bo e ka apunu kudubai mosi?” ");
INSERT INTO gdn_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Dai tagubu ke; “Ki e baganai.” Ko ade dai tagubu ke; “Pa mena, ki eba eyo ko apunu e maba mosi.” Mu inako tagamawa idiwa ki pokere apunu ki e eya wagubu ke; “Ki nau yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","E inako wagubu manako mu e manumupu, tagubu ke; “Ko kau yabugi badidi maba pawena karako tawana empiyei?” ");
INSERT INTO gdn_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Ko e denai wagubu ke; “Apunu si Iyesu tagamu ki e bauwena nau yabuni dogiya pokaiya pasipupu manako sidibu da nau kiyabuni kaburu Siramu rabineya siruwapana wagubu. Manako nau kiyabuni siruwapekeya ki makeya ka nau yabuni pawena tawana empuwani.” ");
INSERT INTO gdn_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Iyapana yona ki wainamupu ka mu tagubu ke; “Karako kau iyanibu apunai ki e ka bani?” Ko e denai wagubu ke; “Ki nau eba kataineya.” ");
INSERT INTO gdn_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","Iyesu dogiya wadubu kotopupu apunu yabui kenekenei ki e yabui pasipupu ade wadubu papupu ki ka pura kawaiya aiyata marai ki makeya ki pokere iyapana apunu ki wadumpu Parisi ragidai mu bamamugu kaya-tagubu. ");
INSERT INTO gdn_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Mu ika bautagubu ka kawakawai ragidai ki e yabui badidi maba pawena ki nene e manumupu manako e ubupu denai wagubu ke; “Apunu mosi dogiya wadubu kotopupu nau yabuni pasipupu manako nau kiyabuni siruwapekeya ki makeya ka nau yabuni pawena tawana empuwani.” ");
INSERT INTO gdn_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Parisi ragidai yona ki wainamupu ka mu dai tagubu ke; “Kwaewena apunai ki e goranuga raurupiyau ade nu aiyata-nuga marai ki kaisi e mete giripiyau ki pokere nu katainugu da e ka eba Mamanuga God e tonopupu bauwena.” Ko dai ki tagubu ke; “E ka eba berokoi mibai ka e matakira bagi kawaya ebo ebo kwaewagau nu empemei.” Mu rabinamaga ka eba eyaka mena ki pokere mu mubo mubo deni deni tagamawa kasiwara idiwa. ");
INSERT INTO gdn_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Mu apunu yabui kenewena Iyesu iyapupu ki ade manumupu, tagubu ke; “Kau nuwagibi da apunu ki ubupu kau iyanibu ki pokere kau wainapiyei da e ka nima?” Ko e denai wagubu ke; “Nau waina-pakani da e ka Mamanuga God e bonanai wainapiyau wagau apunai mosi.” ");
INSERT INTO gdn_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Diyu ragidai mu kawakawai-muguma ki mu wainamupu da apunu ki ka bani eba e yabui kenekenei wena-wena ki pokere mu e inai mamai nene tagubu bautagubu, ");
INSERT INTO gdn_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","manako manu-tampu, tagubu ke; “Wi gubagaga yabui kenekenei e inai rabineya wenawena tagamu ki apunu yau baganai bo? E badidi kwaewena da e karako tawana empiyau?” ");
INSERT INTO gdn_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Kawakawai ragidai inako tagubu manako e inai mamai denai tagubu ke; “Nu katainugu da e ka nu gubaganuga ade nu mete katainugu da e ka e yabui kenekenei inako wenawena, ");
INSERT INTO gdn_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ko e karako badidi maba e yabui bagiwena tawana empiyau ki nu eba katainugu. Nu gubaganuga ka apunu kawaya eba munu gegeyai ki pokere e ebo manupu-muri da e badidi maba iyawena ki sisiyai e eya yagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Mu inako tagubu mibai ka mu Diyu ragidai kawakawai-muguma mu kudumugu mete waina-pamawa. Kawakawai ragidai ki ororeya mena purumupu ade mu rabinamaga eyakamenawena da iyapana nima yagisi ke; ‘Iyesu, e ka nu Iya Negeyana Apunai Keriso’, nima inako yagisi ki e si mu deni mena surupomoto manako e ewa mu gurigurimaga tawai rabineya eba kaniyoto. ");
INSERT INTO gdn_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Kawakawai ragidai inako tagubu ki pokere iyawena apunai ki e inai mamai karako tagubu ke; “Nu gubaganuga ka apunu kawaya eba gegeya ki pokere e badidi maba iya-wena ki sisiyai e eya yagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Parisi ragidai ubumpu apunu yabui kenekenei e inai rabineya wenawena ki e nene ade tagubu bau-wena manako kawareya e ade manu-mupu, tagubu ke; “Mamanuga God kau eminiyau ki pokere e yabuiya eba beranuwagi. Nu kataigibi kewowena da iyanibu apunai e ka apunu berokoi, ko kau badidi wainapiyei?” ");
INSERT INTO gdn_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Mu inako tagubu ko e denai wagubu ke; “E berokoi bo bagai ki nau eba kataineya ko nau nota eyaka mena yau mena wainapakani; Naiya ka nau yabuni kenekenei ko karako ka nau yabuni pawena tawana empakani.” ");
INSERT INTO gdn_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","E inako wagubu ko Parisi ragidai e ade manumupu, tagubu ke; “Ko e badidi kwaewena da kau yabugi bagiwena?” ");
INSERT INTO gdn_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","E denai wagubu ke; “Nau yona ki ororeya mena wi nidibuwani kewowena ko nau yonani ki wi eba wainamupu bo? Wi badidi pokere yona ki ade wainapamana ki nana iwagamu? Banipo wi mete kina e kowakowai kaigamana ki nana wainapiyamu bo?” ");
INSERT INTO gdn_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Apunu ki inako wagubu ki pokere Parisi ragidai ubumpu denai e nakari-mupu mu bonanamaga ragiragi kawaya simupu, tagubu ke; “Kau ka bera apunai ki e waretai mosi ko nu ka oragai apunai Mosisi e kowakowai eweya iwei ragidai. ");
INSERT INTO gdn_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Nu katainugu da oragai apunai Mosisi e ka Mamanuga God e bonanai mena wainapiyawa wagawa ko bera apunai ki e tawana bani were bauwena ki nu eba katainugu.” ");
INSERT INTO gdn_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Mu inako tagubu ko iyawena apunai ki denai wagubu ke; “Akae, yau ka badidi? E nau yabuni wadubu papupu ko e tawana bani were bau-wena ki wi eba kataigau? ");
INSERT INTO gdn_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Nu iyapana kuduba katainugu da berokoi kwae-tagamu ragidai mu bonanamaga ka Mamanuga God eba wainapiyau. Ko iyapana e mena si tepapiyamu ade e mena umunui wadamu ragidai ki mu bonanamaga ka e wainapiyau. ");
INSERT INTO gdn_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Kunuma waira kerareya yabadawa da karako ka iyapana mosi nau maba e inai rabineya yabui kenekenei wena-wena ki nau iyasugubuwani maba mo eba iyawena. ");
INSERT INTO gdn_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Ki pokere nau waina-pakani da Mamanuga God apunu yau eba tonopena ki ka e matakira kawaya yau maba mo eba kwaewagubena.” ");
INSERT INTO gdn_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Apunu ki inako wagubu ko mu e ade nakarimupu, tagubu ke; “Kau ka bigi rabineya wenanugibi ko kau karako uburei nu kawakawai ragidai nu nidiyana kabukabuwa ade nu wadiniyana supasupa ki nana kwaenugei bo?” Mu inako tagubu manako ubumpu apunu ki weumpu kwenumpu da e guriguri tawai ki kamadubu kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Mu apunu ki weumpu kwenumpu ki sisiyai Iyesu wainapupu manako e apunu ki ewa bananapupu ki ka e sibu, wagubu ke; “Kunumau Kawapu Apunai ki e kau sumapiyei bo?” ");
INSERT INTO gdn_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Ko e denai wagubu ke; “Sidiyei Kabukabuwa Apunai, e ka nima ki kau nau sidi da nau e sumapani.” ");
INSERT INTO gdn_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","E inako wagubu manako Iyesu denai wagubu ke; “Kau ororeya mena e empipi ko karako ade mete yonaigemei nau yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Iyesu yona ki wagubu makeya ka apunu ki kwarisiwena e ramatai kawareya ubupu manako wagubu ke; “Kaiwawoni, nau kau sumaniyakani.” ");
INSERT INTO gdn_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Ko Iyesu iyapana ika idiwa ki mu tadebu, wagubu ke; “Nau yewe wairau kawapuwani ki mibai ka nau iyapana kuduba wi wadiniyana supasupa ki nana bausugubuwani. Wi yabuga kenekenei ade sisipu idiwu ragidai ki wi yabuga ka payagisi tawana empumuri, ko wi yabuga bagi ade tawana em-piyamu wainapiyamu ragidai ki wi yabuga ka aita keneyagisi da wi tawana eba empumuri.” ");
INSERT INTO gdn_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Parisi ragidai dai mete ika idiwa yona ki wainamupu ka mu Iyesu manumupu, tagubu ke; “Kau nu mete yabunuga kenekenei nidiyei bo?” ");
INSERT INTO gdn_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Ko Iyesu denai wagubu ke; “Wi yabuga kenewagubena ki ka wi Mamanuga God e yawatai naigida eba kataigumpena ki pokere wi paerega ki denai ki wi eba wadumpena. Ko wi iwagamu da; ‘Nu yawatanuga ki nu naigida mena empemei’, wi inako iwagamu, ki pokere wi badidi paere-mupu ki denai wi nawanaga tondau.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Iyesu waigugu mosi mu tadebu, wagubu ke; “Nau yona mibai wi nidiyani wainapumuri; Iyapana nima papa sipi kwagaramaga katamuruiya ki eba kaniyau ko gari asusu raurupiyau, ki e ka kuwa apunai. ");
INSERT INTO gdn_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ko papa sipi kwayubatamiyau apunai ki e ka gari katamuruiya kaniyau, ");
INSERT INTO gdn_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","manako katamuru uburau apunai gudu kwaipoto manako kaniyana apunai ki baiyagisi kwagara ki rabineya kaniyoto. E kwagara rabineya kaniyoto yogono ki ka papa sipi mu muga mamamaga ki e bonanai wainapomoto manako e mu simaga eyaka eyaka yogono waina-pomoto ki ka mu e bameya kebomoto manako e mu waratamini matarau baitagisi. ");
INSERT INTO gdn_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Matarau baitagisi kewoyagisi ki ka mu mamamaga ki yabiriyagisi yagisi manako mu e bonanai waina-pomoto e eweya kayatagisi. ");
INSERT INTO gdn_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ko apunu kudubai mosi baiyagisi yagisi ki ka mu e bonanai wainapomoto babapomoto manako e kudeya wakapatagisi kaya-tagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Iyesu yona ki wagubu ko waigugu ki mibai mu naigida eba wainamupu. ");
INSERT INTO gdn_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Ko Iyesu mu ade tadebu, wagubu ke; “Nau yona mibai wi nidiyani wainapumuri; Papa sipi mu kwagara-maga ki katamurui ka nau. ");
INSERT INTO gdn_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Naiya mena, nau eba bausugubuwani makeya, ki ka kuwa ragidai ropani kawaya bautagamawa kayatagamawa ko papa sipi mu bonanamaga wainapamawa babapamawa. ");
INSERT INTO gdn_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Katamuru ka nau ki pokere iyapana nima kwagara rabineya kaniyoto nau uburakani bamaneya baiyagisi ki ka e iya waunai bananapoto manako kayayagisi bani igida yauda asusu kupono umuno. ");
INSERT INTO gdn_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Kuwa apunai ki e ka kuwawagana ade wi nuniyana giriniyana pasuniyana ki nana baiyagisi ko nau ka iya waunai wi negeyana ki nana bausugubuwani. Nau iya kororai wi eba negeyani ko iya mibai bagi kawaya ki mena nau wi negeyani. ");
INSERT INTO gdn_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Nau ka papa sipi wi naigida mena kwayubaniyana ki apunai ki pokere nau niya iyani nene eba wainapakani ko wi iyaga nene wainapakani. Nau wi nene posugani ki mete baganai. ");
INSERT INTO gdn_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","13","Papa sipi mu mamamaga e ka papa sipi ki apunai ki pokere e papaiyoma ki e naigida mena kwayubatamiyau. Ko e waitapiyau apunai ki e ka papa sipi ki naigida eba kwayubatamiyau. Papa ki ka eba e nene ki pokere taku wasibena yawira baiyagisi ki ka e kudu wakapa-yagisi papa ki kamaditamini kayayagisi manako papa ki daburipomoto mubo mubo kayatagisi. ");
INSERT INTO gdn_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Ko nau ka papa sipi wi naigida mena kwayubaniyakani apunai. Nau kataineya wiyo ade wi kataigau nau. ");
INSERT INTO gdn_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","Nau Mamai nau nota kwarikwarisisiniyau ade nau e nota kwarikwarisipakani ki maba ka nau wi mete inako nota kwarikwarisiniyakani. Nau niya iyani nene eba wainapakani ko nau wi iyaga nene wainapakani. Nau wi nene posugani ki mete baganai. ");
INSERT INTO gdn_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Nau papaniyoma sipi ka eba yewe mena idiwu ko nau tawana tawana kayasugani mu kwanatamani manako mu kuduba nau bonanani wainapomoto nau ewaneya kebomoto. Nau wata eyaka mena mu damutamani manako nau niya mena ika uburoni mu kwayubatamoni. ");
INSERT INTO gdn_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Nau Mamai God e nuwaiya po nau mibai ka nau naubo nuwaneya ka nau niya iyani nau iyapananiyoma mu nene tarani. Ko ewa ka nau iyani ki ade yadani. ");
INSERT INTO gdn_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Nau Mamai kasiyara tegebu ade ragiragi kawaya sidibu da nau naubo nuwaneya ki nau niya iyani wi nene tarani ade ewa ade yadani. Ki pokere, iyapana nau asusu eba susinimoto poyo ko nau naubo nuwaneya ki mu makeya makeya kwaetagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Iyesu inako wagubu ki pokere Diyu ragidai mu mubo mubo yona ki kawareya tagamawa. ");
INSERT INTO gdn_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Mu dai tagubu ke; “Kweya kairapu mosi e rabineya tondau ki pokere e babawena wagau. Kamadamu, e bonanai ki nu gwede nana kawareya kawareya wainapamu.” ");
INSERT INTO gdn_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ko dai tagubu ke; “Kweya kairapu mosi e rabineya tondibena maba ki ka e yona bagi kawaya yau eba wagubena. Keyai berokoi iyapana yabumaga kenekenei inako eba iyatapena.’ ");
INSERT INTO gdn_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Mara ki makeya ka Diyu ragidai natere kawaya Diyerusaremu rabineya mu poragamaga mo si tagamu ‘Duna Pasumana Poragai’ ki poragatagamawa idiwa. Ki ka nusuru marai. ");
INSERT INTO gdn_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Iyesu Mamanuga God e Tawai rabineya Oragai Apunai Soromoni Wateya kaniyawa, ");
INSERT INTO gdn_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","manako Diyu ragidai ropani kawaya bautagubu e kwagara-mupu manako simupu, tagubu ke; “Nu mara rowarowa kawaya kau yona matarau nuwagana wainapamana ki nawanai idiweya ko kau yona matarau mo nu eba nidibi. Karako nuwagi da nu wainapamu; Nu Iya Negeyana Apunai Keriso ki kau baganai bo?” ");
INSERT INTO gdn_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Ko Iyesu denai wagubu ke; “Nau wi ororeya mena nidibuwani ko wi nau eba sumasiniyamu. Nau Mamai e kasiyarai pokaiya kwaesugakani ki wi naigida mena emisinimpena ki ka wi nau sumasinimpena. ");
INSERT INTO gdn_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Ko wi ka eba nau papaniyoma sipi. Nau bonanani ki wi eba wainapiyamu ade wi nau eba sumasiniyamu. ");
INSERT INTO gdn_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Nau papaniyoma sipi mu ka nau bonanani wainapiyamu. Nau kataineya muyo ade mu kataimugu nau ki pokere mu nau ewakumasiniyamu, ");
INSERT INTO gdn_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","manako maramara idiwana kaiwana iyai ki nau mu tageyani. Mu karako ade aita ewa eba popotagisi ade iyapana mo eba baiyagisi nau taorosiniyoto. ");
INSERT INTO gdn_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Nau Mamai gwedegwede kuduba tegebu ki ka kawaya esida ki pokere iyapana mo eba baiyagisi nau iyapananiyoma nau Mamai e idaiya taoropoto. ");
INSERT INTO gdn_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Nau Mamai ade nau nu ka ewapuru eyaka mena.” ");
INSERT INTO gdn_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Iyesu yona ki wagawa ka Diyu ragidai mu nuwamaga pupuwena manako mu bowa dai temupu e minimana po kwaetagamawa. ");
INSERT INTO gdn_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Ko Iyesu mu ade tadebu, wagubu ke; “Nau Mamai upi bagi kawaya ebo ebo tegebu ki nau wi bamagau kwaesugekeya emisinimawa ko nau badidi maba paerepuwani da wi ki pokaiya karako nau bowa were susinimana po kwaiwagamu?” ");
INSERT INTO gdn_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Ko Diyu ragidai denai e simupu, tagubu ke; “Kau ka eba gwede bagi mo kwaenugeya da nu ki denai kau nuniyamu ko kau Mamanuga God e si giripiyei ki gwawai ka nu karako kau nuniyamu. Kau ka iyapana kaina ko kau ade nuwegei da kau ka God.” ");
INSERT INTO gdn_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Mu inako tagubu ko Iyesu denai wagubu ke; “Wi goraga rabineya ka oka mosi inako wagau ke; ‘Wi kuduba ka wi Mamaga God nau maba.’ ");
INSERT INTO gdn_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Mamanuga God e okai tapu ki kuduba mibai mena ki pokere iyapana takari kawaya e yonai ki wainapamawa ki ka e mu ropani kawaya simaga ‘God Nau Maba’ tadebu. ");
INSERT INTO gdn_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","Ko nau ka Mamanuga God e eya gubagai mibai ki pokere wi gwede nana sidiyamu da nau e si giripakani? E ebo nau winesinibu manako tonosinibu yewe wairau kawapuwani. ");
INSERT INTO gdn_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","E nuwaiya badidi ki nau makeya makeya kwae-sugakani da wi nau sumasinimana ki nana. Ko wi wainapiyamu da nau yona badidi suwagakani ki ka eba e wagubu ki makeya makeya nau suwagakani ki ka eba nau yonani suwagubuwani ki pokaiya nau sumasinimuri, ");
INSERT INTO gdn_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ko nau matakirani kwaesugakani empumuri ki mena pokaiya nau sumasinimuri. Wi nau matakirani ki empumuri sumapu-muri ki ka wi kataiwagi da nau Mamai ade nau nu ka ewapuru eyaka mena.” ");
INSERT INTO gdn_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Iyesu yona ki wagawa ka Diyu ragidai e wadamana dokodoko kwae-tagubu ko e mu yabumaga minibu kwekwe wirawira kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Iyesu ade wirawena kayawena awana Diyoudani papasi buridere apunu Diyoni naiya iyapana siruwa-tamiyawa ki wateya bauwena tondawa, ");
INSERT INTO gdn_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","manako iyapana ropani kawaya e bameya bautagubu, tagubu ke; “Apunu Diyoni matakira kawaya mo eba kwaewena ko e ubupu apunu yau nene badidi wagubu ki kuduba mibai kawaya.” ");
INSERT INTO gdn_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Iyesu ika tondawa ka iyapana ropani kawaya e sumamupu. ");
INSERT INTO gdn_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Mara ki makeya ka apunu mosi si ka Yasarusi sigirawena. Apunu ki e egapuiyoma ka Meri yo Mata. Mu nateremaga ka Betani ki ka tawana Diyudiya rabineya. ");
INSERT INTO gdn_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","(Ridi Meri e ka awana otai bagi kawaya mo wadubu nu Kaiwawonuga Iyesu e kerareya kwebu wira manako e ebo debai kumai pokaiya Iyesu kerarai surusurupupu ki ridai.) ");
INSERT INTO gdn_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Apunu Yasarusi sigirawena ki pokere e egapuiyoma ubumpu Iyesu bibi tonomupu, tagubu ke; “Kaiwawo-nuga, yona yau tonopemei ki kau wainapi; Kau waretagi nuwegei apunai ki sigirawena.” Mu bibi inako tonomupu. ");
INSERT INTO gdn_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Iyesu yona ki wainapupu ka e wagubu ke; “Iyapana Mamanuga God e si tepapamana ki nana ka apunu Yasarusi sigira yau wadubu. E sigirawena ko e eba poyagisi manako iyapana nau Mamai God Gubagai nau sini mete tepapomoto.” ");
INSERT INTO gdn_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Iyesu ka ridi Meri yo Mata mu tatamaga Yasarusi mete kina mu nene ebotau wainapiyawa, ");
INSERT INTO gdn_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ko e Yasarusi sigirawena sisiyai wainapupu ki ka e midi mena ragiwena garugaru mu bamamugu eba kayawena ko mara apeya ika pa tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","E mara apeya pa tondawa da kamadubu manako e tadeyau kabukabuwa ragidai tadebu, wagubu ke; “Karako ade wiraigamu tawana Diyudiya kaigamu.” ");
INSERT INTO gdn_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","E inako wagubu ka mu denai tagubu ke; “Nidiyei Kabukabuwa Apunai, waunitau yewena ka Diyu ragidai kau bowa were nunimana po ki nana ika kwaetagamawa ko kau karako mu bamamugu ade kaigamana ki nana nuwegei?” ");
INSERT INTO gdn_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Mu inako tagubu, ko Iyesu waigugu were denai wagubu ke; “Mara eyaka mena rabineya ki ka madega posiwagau ade surau. Nu nawarau kaigamu ki ka nu madega taneya yawata empamu ki pokere gwede mo nu eba pisipisiniyoto. ");
INSERT INTO gdn_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Ko kemorayagisi sisipu umoroto duna pa mena kaigamu ki ka nu yawata eba empamu manako nu gwepamu bidara yadamu.” ");
INSERT INTO gdn_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Iyesu inako wagubu manako ade tadebu, wagubu ke; “Nu waretanuga Yasarusi ukwarau ki pokere nau e wadana yabuyabu ki nana kayasugani.” ");
INSERT INTO gdn_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","13","E apunu Yasarusi mibi powena ki yonai wagubu ko mu eba wainamupu ko Yasarusi pa ukwarawa wainamupu, ki pokere mu denai tagubu ke; “Kaiwawonuga, e pa oro kirau ki ka baganai, e ukworono da ewa kiroto uburoto.” ");
INSERT INTO gdn_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Mu inako wainamupu babamupu ki pokere Iyesu mu matarau tadebu, wagubu ke; “Apunu Yasarusi e ororeya mena powena. ");
INSERT INTO gdn_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Nau wi nene wainapakani ki pokere nau mamama mete kwaesugakani. Nu naiya e bameya kaigumpena ki ka wi nau maraitau sumasinimpena ko karako ka wi nau kawaya daganani sumasinimuri. Ko kayo, kaigamu da empamu.” ");
INSERT INTO gdn_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Iyesu inako wagubu manako apunu Tomasi si daikere ka Nasuruwa simupu ki ubupu e kowaiyoma ki tadebu, wagubu ke; “Bananapamu kaigamu da iyapana e minimoto poyo ki ka mu nu mete nunimoto popo ki baganai.” ");
INSERT INTO gdn_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mu kayatagubu kaiwa da bau-tagubu ka apunu Yasarusi powena ragu tampu mara apeya apeya kewowena ki sisiyai Iyesu wainapupu. ");
INSERT INTO gdn_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Tawana Betani ka eba uwama ko natere Diyerusaremu bameya, ");
INSERT INTO gdn_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ki pokere Diyu ragidai ropani kawaya ridi Mata yo Meri mu tatamaga powena ki mu rabinamaga minimana kwarisi ki nana ika yadi bautagubu. ");
INSERT INTO gdn_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ridi Mata Iyesu yabadawa sisiyai wainapupu ka e kipu ubupu e nawanai kayawena kaniyawa da yawatau bananapupu. Ko e yowai Meri ka tawau mena tondawa. ");
INSERT INTO gdn_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Ridi Mata Iyesu bananapupu manako sibu, wagubu ke; “Kaiwawoni, kau yewe tondibena ki ka nau inasi eba powagubena. ");
INSERT INTO gdn_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Ko nau kataineya da kau karako Mamanuga God bameya genenuwagi ki kau gwede nene nuwegei ki e uburoto kau negeni.” Ridi Mata inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Ko Iyesu denai e sibu, wagubu ke; “Kau inapugi powena ko e ade kiroto uburoto.” ");
INSERT INTO gdn_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Ko Ridi Mata wagubu ke; “Nau kataineya; Mara kwauneya, popotagubu ragidai kuduba ade iyatagisi kimoto ubumoto idiwono ki makeya ki ka e mete kiroto uburoto.” ");
INSERT INTO gdn_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Ko Iyesu denai wagubu ke; “Popo-tagubu ragidai iyatagisi kimoto ubumoto mu iyamaga kerarai ka nau ki pokere nau sumasiniyamu ragidai popotagisi ki ka mu ade iyatagisi. ");
INSERT INTO gdn_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Wi nau sumasiniyoi idiwoi ki ka wi eba popoiwagi ko mara-mara idiwoi kaiwoi. Nau yonani yau kau sumapiyei bo pa mena?” ");
INSERT INTO gdn_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Iyesu ridi Mata inako sibu manako e denai wagubu ke; “Kaiwawoni, nau ororeya mena kau sumanibuwani kewowena. Kau ka Mamanuga God e tononibu kawapi apunai ade nu Iya Negeyana Apunai. Kau ka Mamanuga God e Gubagai yewe wairau tondana ki nana Mamanuga God naiya mena gwaiyabawena ki makeya kau baunugibi.” ");
INSERT INTO gdn_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Ridi Mata inako wagubu manako wirawena tawau kayawena e yowai Meri giyansu mena sibu, wagubu ke; “Nu Nidiyau Kabukabuwa Apunai bauwena kau nene wagubu.” ");
INSERT INTO gdn_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Ridi Meri yona ki wainapupu ka e garugaru mena kipu ubupu Iyesu bananapana diriwai kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","(Iyesu mu tawa-mugu eba bauwena ko ridi Mata e muguta bananapupu ki wateya buri tondawa.) ");
INSERT INTO gdn_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Diyu ragidai tawa rabineya Meri rabinai minimana kwarisi ki nana bautagubu idiwa ki Meri inako garugaru mena bauwena kayawena emupu ki ka mu notamaga wagubu ke; “E ka bani e inarai ononomupu wateya yadi kirana ki nana kayawena.” Mu inako nota-mupu ki pokere mu garugaru mena kimpu ubumpu e eweya kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Ridi Meri Iyesu empupu e bameya bauwena manako nuwasiyasiya nene e yabareya kwarisiwena e ramatai kawareya ubupu yadi kipu manako sibu, wagubu ke; “Kaiwawoni, kau yewe tondibena ki nau inasi eba powagubena.” ");
INSERT INTO gdn_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Iyesu Meri yadi kirawa empupu ade Diyu ragidai mete bautagubu ki mu mete yadi wadamawa emitapu ki ka e nuwaboyawena e rabinai makariwena manako manutapu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","“Yasarusi powena e kwakwarepui ki wi bani tamupu ki nau kabuwasini-muri.” “Kaiwawonuga, kau yabi emani.” ");
INSERT INTO gdn_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Mu inako tagubu manako Iyesu yadi kipu. ");
INSERT INTO gdn_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Iyesu yadi kirawa emupu ka Diyu ragidai dai tagubu ke; “E ka e waretai Yasarusi e nene wainapiyau ki pokere yadi kirau.” ");
INSERT INTO gdn_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Ko dai tagubu ke; “E ka apunu mosi e yabui kenekenei iyapupu ko karako e eya waretai Yasarusi sigira-wena ki ka e badidi pokere garugaru mena eba bauwena e iyapupu.” Mu inako tagubu. ");
INSERT INTO gdn_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Iyesu nuwaboya kawaya daganani ade wainapupu kanibu ononomupu wateya bauwena manako ragu tamupu ki empupu. Iyapana bowa kawaya mosi ragu umuneya minimpu bodampu ki pokere Iyesu mu tadebu, wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Bowa yau weupumuri kwenupu-muri.” E yona ki wagubu ka powena apunai ki e egarai Mata bauwena e sibu, wagubu ke; “Kaiwawoni, e powena ka mara apeya apeya kewowena ki pokere e kokowawena wainapakani.” ");
INSERT INTO gdn_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Ko Iyesu denai e sibu, wagubu ke; “Mata, nau ororeya mena nidibuwani ki kau notagi gogawena bo? Nau sumasini ki kau Mamanuga God e kasiyarai bagi kawaya mo emani.” ");
INSERT INTO gdn_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","E inako wagubu ka iyapana bowa ki gwairimupu manako Iyesu ubupu e yabui kunuma esida empupu e Mamai bameya parauwena, wagubu ke; “Mamai, nau rabinaneya mena nidi-buwani ki kau ororeya mena wainapipi kewowena ki pokere nau karako parauniyakani kawaya daganani kau bamageya. ");
INSERT INTO gdn_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Nau kataineya da kau maramara nau nuwani notani empiyei ko iyapana yewe idiwu kau tonosinibi kawapuwani ki sumapamana ki nana ka nau karako matarau kau parauniyakani yau kena.” ");
INSERT INTO gdn_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","E inako wagubu manako wira-wena e bonanai ragiragi kawaya wagubu ke; “Yasarusi, nau suwagani wainapi; Kau kiri uburi yabi matarau baunuwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Iyesu yona ki wagawa makeya ka powena apunai ki iyawena kipu ubupu yabadubu matarau bauwena. Ko mu e idai kerarai kiyabui kuduba mete aukwara tenai pokaiya sikwamupu ki pokere e matarau bauwagawa ka Iyesu iyapana tadebu, wagubu ke; “E idai kerarai ade e kiyabui gerowo mete kina ki rikapumuri da e baiyagisi kayayagisi.” E inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Diyu ragidai ropani kawaya Meri daiyoi bautagubu Iyesu badidi kwae-wena emupu ki ka mu e sumamupu, ");
INSERT INTO gdn_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ko dai wiratagubu Parisi ragidai mu bamamugu kayatagubu manako e kwaewena sisiyai kuduba mu tade-mupu. ");
INSERT INTO gdn_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Tademawa wainamupu ka Parisi ragidai ade Mamanuga God bameya dobopiyamu ragidai mete kina ubumpu kawakawai ragidai mete ewapuru dibimupu manako tagubu ke; “Apunu yau e matakirai kawaya kawaya kwaewagau ki pokere karako ka nu badidi kwaigamu? ");
INSERT INTO gdn_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu e kamadamu manako e maramara inako kwaeyogono yarono ki ka iyapana kuduba e suma-pomoto manako tawana Roumi ragidai mu piyaramuguma baitagisi Mamanuga God e Tawai ade nu nuga tawananuga gwedegwedenuga mete kina ki kuduba giripomoto pasumoto.” ");
INSERT INTO gdn_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Karako mu paunamugu ka apunu mosi si ka Kaipasi ika tondawa. Kwamura ki rabineya ka e Mamanuga God bameya dobopiyamu ragidai mu kawaimaga tondawa ki pokere e ubupu e kowaiyoma ki tadebu, wagubu ke; “Wi ka nota mo wainapiyamu bo wi kuduba notababa wadamu? ");
INSERT INTO gdn_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Nau suwagani wainapumuri; Nu kuduba popoigamu ki ka eba baganai ko iyapana mosi nu kuduba nene poyagisi ki ka bagi kawaya.” ");
INSERT INTO gdn_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Kwamura ki rabineya ka apunu Kaipasi Mamanuga God bameya dobopiyamu ragidai mu kawaimaga tondawa ki pokere e yona ki wagubu. Ko ki ka eba e ebo nuwaiya wainapupu wagubu ko Mamanuga God e kabuwapupu da Iyesu Diyu ragidai mu pokamugere powagana ki nana manako e ubupu yona ki wagubu. ");
INSERT INTO gdn_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Ko Iyesu e ka eba Diyu ragidai mu nene mena poyagisi ko Mamanuga God e iyapana-iyoma kuduba tawana tawana idiwei ki dibiniyana da nu rabinanuga eyaka-menawagana ki nana ka e poyagisi. ");
INSERT INTO gdn_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Mara ki makeya ka Diyu ragidai mu kawakawaimuguma Iyesu wada-mana ki nana ki kerarai birikamupu manako e minimana po yanuwei tagamawa, ");
INSERT INTO gdn_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ki pokere Iyesu tawana Diyudiya rabineya matarau eba umawa ko e weki gwaiya iyapana eba idiwu tawanai ki deneya kayawena umawa da natere mo si ka Eparimi bauwena manako e tadeyau kabukabuwa ragidai mete ika idiwa. ");
INSERT INTO gdn_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Diyu ragidai mu poragamaga kawaya si ‘Mamanuga God Nu Raurunibu Poragai’ tagamu ki rogobiwena ki pokere iyapana ropani kawaya mu mubo mubo tawanamaga kamadumpu mu idamaga kerapumaga rikapamana manako ewa poraga ki kupamana ki nana natere Diyerusaremu kayatagubu. ");
INSERT INTO gdn_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Ika bautagubu ka mu Mamanuga God e Tawai rabineya Iyesu nene yabu tamawa mu mubo deni deni umana misimisi were manu kasiwaratagamawa, tagamawa ke; “Wi badidi wainapiyamu; E poraga yau kawareya baiyagisi bo pa mena?.” ");
INSERT INTO gdn_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Mu inako tagamawa mibai ka Mamanuga God bameya dobopiyamu ragidai ade Parisi ragidai mete kina iyapana ragiragi kawaya tademupu, tagubu ke; “Wi apunu Iyesu tawa bani empiyamu ki wi nu nidimuri da nu e yadamu.” ");
INSERT INTO gdn_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","‘Mamanuga God Nu Raurunibu Poragai’ ka mara ida daikere kewowena daikere eyaka mena yabaranugu makeya, ko karako ka Iyesu natere Betani apunu Yasarusi powena ko ade iyawena ki e tawaiya ade bauwena. ");
INSERT INTO gdn_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Mu Iyesu nene bani teyampu manako e apunu Yasarusi mete ika bani kupamana wateya idiwa. Ko ridi Mata bani wara-piyawa mu tageyawa. ");
INSERT INTO gdn_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Ki makeya ka ridi Mata e yowai Meri ubupu ripa otai aurai bagi kawaya mo si ka ‘nada’ ki denai mete kawaya daganani karakara maba mo rabineya minibu ki wadubu bauwena. E kanibu Iyesu e kerarai kawareya ripa otai ki kwebu wira manako ewa e ebo debai kumai rowarowa kawaya ki pokaiya Iyesu kerarai surusurupupu manako ripa otai aurai bagi kawaya ki aurai tawa rabineya posiwena. ");
INSERT INTO gdn_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","6","Iyesu e tadeyau kabukabuwa apunai mosi si ka Diyudiyasi si daikere ka Isikariyoto ridi ki badidi kwaewena empupu ki ka e wagubu ke; “Ridi yau badidi pokere awana bagi kawaya ki pa kwebu wira? E wadubena manako iyapana dai gimarampena da e denai kawaya daganani bowa madai 300 kwaitana kwempena ki e wadubena iyapana gwedegwedemaga pa mena imagei ragidai ki tagebena.” Apunu Diyudiyasi e ka Iyesu e yogoi wagana apunai. E yona ki wagubu ki ka e eba iyapana gwedegwedemaga pa mena ragidai mu nuwaboyamaga wainapupu ki pokere wagubu ko Iyesu e tadeyau kabukabuwa ragidai mete kina mu bowamaga madai sini kororai ki e bameya tondawa ki pokere e bowa madai ki dai mete kuwawagana waina-piyawa. ");
INSERT INTO gdn_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Ko Iyesu apunu Diyudiyasi sibu, wagubu ke; “Kau gwede nana ridi yau siyei siyasiya? Kamadi. Nau posugubena ki ka e ripa otai bagi kawaya yau pokaiya nau kwakwarepuni monaga-pena, ko e karako nau marani rogobi-wagau ki makeya bauwena nau monaga-sinibu. ");
INSERT INTO gdn_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Gwedegwede pa mena ragidai ki mu ka maramara wi mete yewe idiwoi da wi mu waitatamiyoi. Ko nau marani rogobiwena da nau wi mete eba idiwomu.” ");
INSERT INTO gdn_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Diyu ragidai ropani kawaya Iyesu natere Betani bauwena ki sisiyai waina-mupu ki ka mu e diriwai ika bautagubu. Mu eba Iyesu mena empamana ki nana bautagubu ko apunu Yasarusi powena ade iyawena ki sisiyai mu wainamupu ki pokere mu e mete empamana ki nana bautagubu. ");
INSERT INTO gdn_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Mu Yasarusi iyawena ki matakirai mu yabumugere emupu ka mu Iyesu sumamupu ko mu muga kawakawaimuguma naiya sumatamawa ragidai ki mu kamaditampu ki pokere kawakawai ragidai ki mu rabinamaga berokowena manako gwawai apunu Yasarusi mete minimana po waina-mupu. ");
INSERT INTO gdn_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Nawaru puruwena ka iyapana ropani kawaya ika ‘Mamanuga God Nu Raurunibu Poragai’ ki kawareya bau-tagubu ki Iyesu ika natere Diyerusaremu yabadawa sisiyai wainamupu. ");
INSERT INTO gdn_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Waina-pamawa ka mu notowiya kwarai dai temupu manako e bananapamana nawanai kayatagubu. Mu ewapuru mena mu bonanamaga ragiragi kawaya tagamawa ke; “Kaiwa kaiwa! Nu karako Mamanuga God e si tepapemei. Kau ka nu Isiraero ragidai nu Kaiwawonuga kawaya karako Mamanuga God e kasiyarai pokaiya nu nene baunugibi. Mamanuga God kau karako wadiniyoto bagi.” ");
INSERT INTO gdn_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Iyapana inako tagamawa manako Iyesu papa ‘donki’ munai mo empupu wadubu kawareya tondubu yabadawa. Mamanuga God e okai mosi Iyesu nene inako wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","‘Natere Saiyoni ragidai, wi kudu eba wainapiyoi. Wi Kaiwawoga papa ‘donki’ munai mosi kawareya baiyagisi empumuri.’ ");
INSERT INTO gdn_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Iyesu e tadeyau kabukabuwa ragidai eba kataimugu da oka ki ka Iyesu e yonai. Ko e powena ade iya-wena kipu ubupu Mamanuga God e taneya posiwena tondawa eweya ki ka mu notamaga paparawena da mu Mamanuga God e okai Iyesu nene inako wagubu ki mibai kuduba wainamupu. Iyapana badidi makeya makeya e nene kwaetagubu ki mu mete wainamupu. ");
INSERT INTO gdn_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Iyapana ropani kawaya apunu Yasarusi powena ko Iyesu kasiyarai pokaiya ade iyawena kipu ubupu matarau emupu ragidai ki mu kaya-tagubu sisiya ki mu kowamuguma tademawa iwa, ");
INSERT INTO gdn_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ki pokere iyapana ropani kawaya matakira ki sisiyai wainamupu karako Iyesu bameya bautagubu. ");
INSERT INTO gdn_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ko Parisi ragidai iyapana ropani kawaya Iyesu diriwai inako kwaetagamawa emitampu ki ka mu nuwarorotagubu, tagubu ke; “Emita-muri, nu eba kasiyaraigemei ko iyapana kuduba karako apunu ki sumapiyamu e eweya mena kayatagamu.” ");
INSERT INTO gdn_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","‘Mamanuga God Nu Raurunibu Poragai’ ki kawareya ka iyapana kwaiyanai yona Guriki tagamu ragidai dai Mamanuga God e si tepapamana ki nana ika mete bautagubu. ");
INSERT INTO gdn_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Bautagubu manako kaimpu natere Betaida tawana Gariri rabineya mu apunumaga mosi si ka Piripo simupu, tagubu ke; “Kabai, nu nuwanugu ka Iyesu empamu.” ");
INSERT INTO gdn_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Apunu Piripo yona ki wainapupu ka e kayawena e waretai Enduru sibu manako mu apeya kayatagubu Iyesu simupu. ");
INSERT INTO gdn_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Ko Iyesu mu tadebu, wagubu ke; “Nau Kunumau Kawapuwani Apunai nau sini tepapamana marai karako bauwena yau kena. ");
INSERT INTO gdn_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Nau yona mibai wi nidiyani wainapumuri; Nu momai mosi umamu ki ka e eya ropayagisi puwayagisi ko mibai waunai miniyoto daburi. Ko momai ki tawau mena tondono ki ka e mibai eba kiroto ade mibai waunai mete eba miniyoto daburi. ");
INSERT INTO gdn_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ki kwaitana, iyapana nima e ebo mena iyai nene wainapiyau ki ka e eya iyai aita ewa nene ki e kaupiyau. Ko iyapana nima yewe wairau ki iyai nene eba notapiyau ko ewa iyai ki nene mena notapiyau ki ka e maramara tondana kaniyana ki iyai ewa yadini. ");
INSERT INTO gdn_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Iyapana nima nuwaiya ka nau upini kwaeyagisi ki ka e yabadini nau ewaneya uburoto manako nau bani kayasugani tondoni tawanai ki ka e mete ika baiyagisi manako nau mete ewapuru ika idiwomu. Iyapana nima inako kwae-yagisi ki e si ka nau Mamai God empoto tepapoto.” ");
INSERT INTO gdn_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Iyesu ade wagubu ke; “Karako nau nuwaboya wainapakani ko nau badidi suwagani; ‘Mamai, bita kawaya nau karako bananapani ki kau surupi bo?’ Ae pa mena, nau inako eba suwagani mibai ka nau bita kawaya yau wadana ki nana bausugubuwani. ");
INSERT INTO gdn_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Ki pokere Mamai, kau kaubo nuwageya ki kwaenuwagi da kau sigi nau pokanere kawayayagisi.” Iyesu yona ki wagawa makeya ka bonana mosi kunumau inako wagubu ke; “Iyapana nau sini tepapamana ki nana ki nau ororeya mena kwaesugu-buwani ade ewa mete kwaesugani.” ");
INSERT INTO gdn_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Iyapana ropani kawaya ika ubumawa bonana ki wainamupu ka mu tagubu ke; “Ki ka bani gaiya wagau.” Ko ade dai tagubu ke; “Ae, ki ka eba gaiya ko ki ka bani aneya mosi kunumau e nene wagubu.” ");
INSERT INTO gdn_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Iyapana inako tagamawa ko Iyesu wagubu ke; “Bonana wainamupu ki wi nene bauwena ko eba nau nene bau-wena. ");
INSERT INTO gdn_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Nau Mamai God iyapana kuduba, madega kauwagau madega posiwagau e idai gurai wi naurigau ugwadana ragiragi ki marai karako bauwena yau kena. Nau Mamai uburana waira yau notai ki kerarai apunai wadana kwenupana ki marai bauwena. ");
INSERT INTO gdn_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Iyapana nau susinimoto poyo ade nau bagisinimoto makeya ki ka nau iyapana kuduba tetamani da mu nau bamaneya baitagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Iyesu inako wagubu ki ka e badidi maba powagana ki sisiyai wagubu. ");
INSERT INTO gdn_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Ko iyapana denai tagubu ke; “Mamanuga God e gorai oragai apunai Mosisi kwebu ki wagau da nu Iya Negeyana Apunai Keriso ki e eba poyagisi ko maramara tondono kaniyono. Nu wainapemei da nu Iya Negeyana Apunai ki kau baganai ko kau badidi pokere nuwegei da mu kau nunimana poyo ade kau baginimana ki nana nuwegei. Kau ka Kunumau Kawapi Apunai baganai bo?” ");
INSERT INTO gdn_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Ko Iyesu mu ade tadebu, wagubu ke; “Tanai Apunai mara eba rowarowa wi mete yewe idiwoi ki pokere e taneya iwoi kwaenda sisipu baiyagisi wi bodaniyoto. Iyapana nima sisipu umau ki ka e tawana eba empiyau ko pa asusu umau. ");
INSERT INTO gdn_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ko Tanai Apunai karako wi bamagau tondau ki pokere wi e suma-piyoi ki ka wi e munuiyoma idiwoi.” Iyesu yona ki wagubu kewowena ka e kayawena e ebo mena wekewena. ");
INSERT INTO gdn_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","E naiya iyapana yabumugu matakira ropani kawaya kwaewagawa empamawa ko mu e eba sumapamawa. ");
INSERT INTO gdn_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Takari kawaya ka oragai apunai Aisaiya iyapana ki mu sisiyamaga oka pokaiya inako tapu, wagubu ke; ‘Kaiwawonuga, kau yonagi iwagibi ki mu eba sumamupu. Kau kasiyaragi ki mu matarau mete emupu ko mu denai kau eba sumanimpu.’ ");
INSERT INTO gdn_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Iyapana Iyesu eba sumamupu mibai ka oragai apunai Aisaiya ade wagubu ke; ");
INSERT INTO gdn_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","‘Mamanuga God mu yabumaga kenepupu ade mu notamaga gogapupu ki pokere mu mibai eba bananamupu. E wagubu ke; Mu nau bamaneya bautagumpena ki ka nau mu iyatapena ko mu nau bamaneya eba bautagubu.’ ");
INSERT INTO gdn_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Oragai apunai Aisaiya oka ki tapu mibai ka e takari kawaya Iyesu bau-wagana ki tanai empupu were wagubu. ");
INSERT INTO gdn_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Iyapana kawakawai dai Iyesu sumamupu ko mu e sumamupu ki sisiyai mu matarau eba tagubu mibai ka mu Parisi ragidai mu kudumugu mete wainamupu. Parisi ragidai mu kasiyara-maga ka iyapana simaga guriguri tawai rabineya surupamana ki nana, ");
INSERT INTO gdn_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ki pokere iyapana kawakawai ki mu notamaga wagubu ke; ‘Nu Iyesu sisiyai iwagamu ki ka Parisi ragidai ubumoto nu sinuga guriguri tawai rabineya surupomoto siwakekenimoto.’ Mu inako notapamawa mibai ka mu eba nuwa-mugu iyapana mu simaga giripomoto. Mu nuwamugu iyapana mu weremaga tagamana ki nene mena wainapamawa ko Mamanuga God uburana mu were-maga wagana ki nene mu eba waina-pamawa. ");
INSERT INTO gdn_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Ko Iyesu e bonanai ragiragi kawaya iyapana tadebu, wagubu ke; “Nima nau sumasiniyau ki ka e eba nau mena sumasiniyau ko nau Tonosinibu Apunai e mete sumapiyau. ");
INSERT INTO gdn_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Iyapana nima nau emisiniyau ki ka e nau Tonosinibu Apunai e mete empiyau. ");
INSERT INTO gdn_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Nau Tanai Apunai yewe wairau kawapuwani manako iyapana nima nau sumasiniyono ki ka e sisipu rabineya eba umono. ");
INSERT INTO gdn_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Iyapana nima nau yonani wainapiyau ko makeya makeya eba kwaewagau ki ka eba nau uburani nau idani gurai e naureya ugwadani ragiragi. Nau eba ki nene bausugubuwani. Nau ka iyapana wi iya negeyana ki nana bausugubuwani. ");
INSERT INTO gdn_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Iyapana nima nau tagararasiniyau bo nau yonani eba wadau ki ka eba nau uburani nau idani gurai e naureya ugwadani ragiragi. Pa mena. Aita ewa, mara kwauneya, ka nau yonani suwagubuwani wainapupu ko kwenupupu ki yonai ka uburoto e naureya ugwadiniyoto ragiragi. ");
INSERT INTO gdn_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Nau yona mibai wi nidiyakani yau kena; Nau ka eba nau naubo kasiyarani pokaiya suwagubuwani ko nau Mamai Tonosinibu Apunai badidi sidibu ki mena nau makeya makeya wi nidi-buwani. ");
INSERT INTO gdn_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Nau kataineya da iyapana e yonai sumapomoto ade yadini ki mu ka maramara idiwana kaiwana ki iyai mete yadini. Ki pokere, nau badidi nidiyakani ki nau eba asusu nidiyakani ko nau Mamai badidi wi nidiyana wagubu ki makeya makeya nau wi nidiyakani.” Iyesu inako wagubu. ");
INSERT INTO gdn_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","3","Marawani ki ka ‘Mamanuga God Nu Raurunibu Poragai’ ki kupei kupetagamana marai ko karako kemora nene ka Iyesu e tadeyau kabukabuwa ragidai mete bani dai kupamawa idiwa. Berokoi Apunai Seitani e ka ororeya mena apunu Saimoni e gubagai si ka Diyudiyasi si daikere ka Isikariyoto e rabinai wira-pupu da e Iyesu yogoi wagana ki nana wainapiyawa. Iyesu kataiya da e naiya e Mamai bameya tondawa ade e mete kataiya da e waira yau kamadana e Mamai bameya ade kayawagana ki marai rogobiwena. E mete kataiya da e eya Mamai e kasiyarai kuduba ki e kwebu wadubu kewowena. Iyesu e kerareya mena e kowakowai-yoma nene maramara nota kwarikwarisi-tamiyawa tondawa yabadawa da karako e mu kamaditamana marai rogobiwena ki ka e mu inako mete nota kwari-kwarisitamiyawa. ");
INSERT INTO gdn_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Mu kupetagamawa idiwa ki makeya ka e mu paunamugu kipu ubupu e midi tatamai rikapupu ade surusuru mo wadubu e naureya umapu, ");
INSERT INTO gdn_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","awana wadubu kabuma mo rabineya kwebu wira manako e kanibu e tadeyau kabukabuwa ragidai eyaka eyaka mu kerapumaga bigi siruwapiyawa. E bigi siruwapupu kewowena ka e surusuru e naureya umapu ki pokaiya mu kerapu-maga ki surusurupiyawa. ");
INSERT INTO gdn_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","E inako siruwatamiyawa yabadawa da apunu Pita bameya bauwena ki ka Pita e notai babawena Iyesu sibu, wagubu ke; “Kaiwawoni, nau kerarani bigi ki kau eba siruwapi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Ko Iyesu denai e sibu, wagubu ke; “Nau kwaesugakani ki kau karako eba kataigeya ko ewa were ki kau mibai ki katainuwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Ko apunu Pita ade wagubu bodaboda, wagubu ke; “Kau ka nau Kaiwawoni kawaya ki pokere nau kerarani bigi ki kau eba siruwapi.” Apunu Pita inako wagubu ko Iyesu denai wagubu ke; “Nau kau keraragi bigi eba siruwapani ki nau kau mete eba eyaka mena.” ");
INSERT INTO gdn_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Apunu Saimoni si daikere ka Pita yona ki wainapupu ka e wagubu ke; “Kaiwawoni, kau eba nau kerarani bigi mena siruwapi ko nau idani yo nau debani ki mete siruwapi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Ko Iyesu wagubu ke; “Iyapana nima awanau siruwawena ki e midi ka kuduba tanai kawaya ko e kerarai mena dogiyapiyau. Wi kuduba ka tanai mena ko wi paunagau apunu mo eyaka mena ka bigibigi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","(E yogoi wagana apunai ka nima ki Iyesu e kataiya ki pokere e wagubu ke; ‘Wi paunagau apunu mo eyaka mena ka bigibigi’.) ");
INSERT INTO gdn_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Iyesu mu kerapumaga bigi siruwa-piyawa da kamadubu, e midi tatamai ade wadubu umapu manako wirawena kanibu e wateya ade tondubu. Tondubu manako mu tadebu, wagubu ke; “Nau karako wi bamagau badidi kwaesugu-buwani ki mibai wi wainamupu bo pa mena? ");
INSERT INTO gdn_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nau ka wi Nidiyakani Kabukabuwa Apunai sidiyamu ade wi Kaiwawoga sidiyamu ki ka wi mibai iwagamu. ");
INSERT INTO gdn_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ki pokere, nau wi Kaiwawoga ade wi Nidiyakani Kabukabuwa Apunai wi kerapuga bigi siruwapuwani ki ka wi mete kina deni deni inako waita kasiyaraiwogoi idiwoi. ");
INSERT INTO gdn_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Nau keyakeyai yau kwaesugubuwani ki mibai ka wi keyakeyai ki empamana manako makeya makeya kwaigamana iwana ki nana nau kabuwanibuwani. ");
INSERT INTO gdn_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Nau yona mibai wi nidiyani wainapu-muri; Bigabiga ragidai ki mu eba ubumoto mu kawakawaimuguma raurutamini, ade bibi kayatagubu ragidai ki mu eba ubumoto mu tonotampu ragidai ki raurutamini. ");
INSERT INTO gdn_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Wi nau nidibuwani yau makeya makeya kwaiwogoi ki ka wi mibi mamamai mete idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Iyesu inako wagubu, ade wagubu ke; “Nau ka eba wi kuduba nene suwagubuwani. Nau winenibuwani ragidai wi kuduba nau kataineya. Mamanuga God e okai naiya tapu inako wagubu ke; ‘Apunu ki nau mete ewapuru kupeigibi apunai ki e nau tagararasinibu manako nau yogoni wagubu’. Oka ki mibai karako waunitau matarayagisi empumuri. ");
INSERT INTO gdn_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Nau yona yau karako wi nidiyakani da wi mibai aita ewa wenayagisi empumuri ki ka wi kataiwagi da Kunumau Kawapuwani Apunai ka nau yau kena. ");
INSERT INTO gdn_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Nau yona mibai wi nidiyani wainapumuri; Iyapana nima nau tonopana apunai ki e diriwai kwaeyagisi ki ka e nau diriwani mete kwaeyagisi. Ade iyapana nima nau diriwani kwaeyagisi ki ka e nau Tonosinibu Apunai ki e diriwai mete kwaeyagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Iyesu yona ki wagubu eweya ka e rabinai makariwena nuwaboya waina-pupu manako yona matarau mu tadebu, wagubu ke; “Nau yona mibai wi nidiyani wainapumuri; Wi paunagau ka apunu mosi nau yogoni yagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","E tadeyau kabukabuwa ragidai yona ki wainamupu ka mu babatagubu mu mubo mubo empepe kasiwara-tagubu, tagubu ke; “E ka nima nene wagau?” ");
INSERT INTO gdn_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Iyesu madaneya ka e tadeyau kabukabuwa apunai mosi ki e nuwaiya po apunai ki ika tondawa, ");
INSERT INTO gdn_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","manako apunu Saimoni si daikere ka Pita apunu ki yabu gedegedepupu sibu, wagubu ke; “Kau manupi; E nima nene wagau?” ");
INSERT INTO gdn_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Apunu ki riyawena Iyesu madaneya kanibu sibu, wagubu ke; “Kaiwawoni, kau yogogi wagana apunai ka nima?” ");
INSERT INTO gdn_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Ko Iyesu denai e sibu, wagubu ke; “Nau karako yawi yau kawareya bani yadani kupani daikere kweyani ki apunai ka nau yogoni yagisi.” E inako wagubu manako bani mosi wadubu pikapana ki nana awana mo rabineya kaupupu manako wirawena apunu Saimoni Isikariyoto e gubagai si ka Diyudiyasi kwebu. ");
INSERT INTO gdn_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Apunu Diyudiyasi bani ki wadubu makeya ka Berokoi Apunai Seitani e rabineya supu manako Iyesu e sibu, wagubu ke; “Kau badidi kwaenugana wainapiyei ki kau garugaru mena kwaenuwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","E tadeyau kabukabuwa ragidai kuduba mete ika kupetagamawa idiwa yona ki waina-mupu ka mu notamaga babawena. ");
INSERT INTO gdn_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Apunu Diyudiyasi e ka mu bowamaga madai ki sini kororai kwayubapiyawa apunai ki pokere Iyesu apunu Diyudiyasi yona ki sibu ki ka mu notamaga wagubu da e Diyudiyasi kayawagana poraga bani dai gimarapana bo gwedegwede imagei ragidai bowa madai dai tageyana ki nana sibu. ");
INSERT INTO gdn_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Ko apunu Diyudiyasi bani ki wadubu manako garugaru mena kipu ubupu kemora ki rabineya tawa ki kamadubu kayawena. ");
INSERT INTO gdn_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Apunu Diyudiyasi bauwena kayawena eweya ka Iyesu ubupu e kowakowaiyoma tadebu, wagubu ke; “Nau Kunumau Kawapuwani Apunai nau sini karako kawayayagisi. Nau badidi kwaesugani ki pokaiya ka nau Mamai e si mete kawayayagisi. ");
INSERT INTO gdn_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","E Gubagai nau badidi kwaesugani ki pokaiya ka nau Mamai e si kawayayagisi, ade nau Mamai badidi kwaeyagisi ki pokaiya ka nau sini garugaru mena mete kawayayagisi. ");
INSERT INTO gdn_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Mununiyoma, nau suwagani wainapumuri; Nau mara eba rowarowa kawaya wi mete yewe idiwomu. Nau Diyu ragidai naiya tadebuwani ki maba nau karako wi mete nidiyakani yau kena; Nau karako kayasugana tawanai ki wi eba kaiwagi. ");
INSERT INTO gdn_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Nau gora waunai mosi wi negeyakani yau kena; Wi denideni kwayuba kasiwaraiwogoi idiwoi. Nau wi nota kwarikwarisiniyekeya ki maba wi kowaguma mete inako nota kwari-kwarisitamiyoi. ");
INSERT INTO gdn_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Wi inako kwaiwogoi idiwoi ki ka iyapana kuduba wi eminimoto manako kataitagisi da wi ka mibai nau yonani wainapiyamu kwaiwagamu idiwu ragidai.” ");
INSERT INTO gdn_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Iyesu inako wagubu manako apunu Saimoni si daikere ka Pita denai e manupupu, wagubu ke; “Kaiwawoni, kau tawana bani kayanugana nuwegei?” Ko Iyesu denai e sibu, wagubu ke; “Nau kayasugana tawanai ki kau karako nau mete eba kaigamu ko ewa marai mosi ki kau nau bamaneya ika baunuwagi.” ");
INSERT INTO gdn_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Ko apunu Pita e ade manupupu, wagubu ke; “Kaiwawoni, nau badidi pokere karako kau ewageya eba kayasugani? Kau ponuwagi ki ka nau kau nene mete posugani ka baganai.” ");
INSERT INTO gdn_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Ko Iyesu denai e sibu, wagubu ke; “Kau mibai nau nene ponuwagi bo? Nau nidiyani wainapi; Kemora yau rabineya ka kau mara apeya eyaka nuwagi bodaboda da kau eba kataigeya nau. Kau inako nuwogowa bodaboda manako ki eweya ka kokoroku yagisi nawaru puruyagisi.” ");
INSERT INTO gdn_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Iyesu e tadeyau kabukabuwa ragidai ade tadebu, wagubu ke; “Wi notaga eba koyogono kudu eba wainapiyoi. Nau Mamai God e mena sumapiyoi ade nau mete sumasiniyoi. ");
INSERT INTO gdn_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Nau Mamai e tawai rabineya ka wata ropani kawaya uburau. Ki pokere yewe idiwoi mibai ka nau kayasugani wi wataga yamanapani. Nau wi wataga ki eba yamanapena maba ki ka nau yona yau matarau wi eba nidibena. ");
INSERT INTO gdn_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Nau wi wataga yamanapani kewoyagisi ki ka nau ewa ade wirasugani bausugani manako nau wi teniyani da nau yo wi ewapuru kaigamu nau tondana tawanai ki ika ewapuru idiwomu. ");
INSERT INTO gdn_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Tawana nau kayasugani ki yawatai ki wi kataigau.” ");
INSERT INTO gdn_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Iyesu inako wagubu ko apunu Tomasi babawena denai e sibu, wagubu ke; “Kaiwawoni, kau tawana bani kayanugei ki nu eba katainugu ki pokere nu tawana ki yawatai badidi maba empamu manako ika baigamu?” ");
INSERT INTO gdn_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Ko Iyesu denai e sibu, wagubu ke; “Nau ka Yawata, nau ka Yona Mibai ade nau ka wi Iya Negeyana ki Apunai. Iyapana nima nuwaiya nau Mamai God e bameya kayawagana wainapiyau ki ka e yabiri nau bamaneya baiyagisi manako nau sini pokaiya ka e nau Mamai bameya kayayagisi. Nau Mamai bameya kaiwagamana yawatai kudubai mo pa mena. ");
INSERT INTO gdn_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Wi nau naigida mena kataisinimuri ki ka wi nau Mamai e mete kataiwagi. Wi nau emisinimpu kewowena ki pokere nau Mamai ki e wi mete emupu kewowena. Nau Mamai ki e wi kataigau.” ");
INSERT INTO gdn_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Iyesu inako wagubu ko apunu Piripo denai wagubu ke; “Kaiwawoni, nu nuwanugu ka kau Mamagi nu kabuwaniyo da nu e empamu.” ");
INSERT INTO gdn_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Ko Iyesu denai e sibu, wagubu ke; “Piripo, nau mara rowarowa kawaya wi mete yewe idiweya ko kau eba kataigeya nau bo? Iyapana nima nau emisiniyau ki ka e nau Mamai mete empiyau. Ko kau gwede nana nau Mamai wi kabuwaniyana ki nana nuwegei? ");
INSERT INTO gdn_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Nau ka nau Mamai mete ewapuru eyaka mena ade e ka nau mete ewapuru eyaka mena. Nau yona suwa-gakani ki kau sumapiyei bo pa mena?” Iyesu apunu Piripo inako sibu manako ade wirawena e tadeyau kabukabuwa ragidai kuduba emitapu tadebu, wagubu ke; “Nau yona yau nidibuwani ki ka eba nau naubo kasiyarani pokaiya wi nidibuwani. Nau ade nau Mamai ki nu ka ewapuru eyaka mena ki pokere e ebo kasiyarai pokaiya badidi kwae-wagau nau kabuwasiniyau ki mena nau makeya makeya kwaesugakani manako wi kabuwaniyakani. ");
INSERT INTO gdn_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Nau ade nau Mamai nu ka ewapuru eyaka mena yonai nidibuwani ki wi naigida mena wainapumuri sumapumuri. Ko wi nau yonani suwagubuwani ki eba sumapu-muri ki ka wi nau matakirani nau Mamai e kasiyarai pokaiya kwae-sugekeya emisinimawa ki sumapumuri. ");
INSERT INTO gdn_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Nau yona mibai wi nidiyakani yau kena; Iyapana nima nau sumasiniyoto ki ka nau badidi kwaesugekeya ki maba e mete kwaeyagisi. Ko eba ki mena. Nau ka aita ewa nau Mamai bameya kayasugani ki pokere nau badidi maba kwaesugekeya ki ka maraitau erida ko nau sumasiniyau apunai badidi maba kwaeyagisi ki ka kawaya esida. ");
INSERT INTO gdn_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Wi gwede mosi nene nau sini pokaiya geneiwagi ki nau kwaesugani manako nau Mamai e si nau pokanere kawaya-yagisi. ");
INSERT INTO gdn_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Wi gwede mosi nau sini pokaiya geneiwagi ki kuduba nau kwaesugani.” ");
INSERT INTO gdn_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Wi nau nene notapiyoi idiwoi ki ka wi nau gorani nidibuwani ki makeya makeya kwaiwogoi, ");
INSERT INTO gdn_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","17","manako nau Mamai siyani da e wi Waitaga mosi wi nene tonopoto. Wi Waitaga ki kena ka nau Mamai e eya Keyai Mibai Bagi Kawaya maramara wi mete idiwana kaiwana ki nana baiyagisi. Iyapana nau Mamai mete tagararaniyamu ragidai ki ka e Keyai Mibai Bagi Kawaya ki mu eba yadini mibai ka mu e eba em-pomoto ade e eba kataitagisi. Ko wi e kataipumuri mibai ka e wi rabinagau maramara tondono kaniyono.” ");
INSERT INTO gdn_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Nau deni mena wi eba kamadini-yani kayasugani ko nau ewa marai mosi ade wirasugani wi bamagau bausugani. ");
INSERT INTO gdn_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Mara eba rowarowa yabaranugu ki ka iyapana nau Mamai mete tagarara-niyamu ragidai nau ewa mo eba emisinimoto. Ko wi nau ade emisini-muri. Nau iyaiya tondoni ki pokere wi mete inako iyaiya idiwoi. ");
INSERT INTO gdn_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Mara ki baiyagisi makeya ki ka wi kataiwagi da nau Mamai mete ewapuru eyaka mena idiwei ki maba wi nau mete ewapuru eyaka mena idiwomu ade nau wi mete ewapuru eyaka mena idiwomu. ");
INSERT INTO gdn_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Iyapana nima nau gorani tapuwani ki makeya makeya kwaewagau ki ka e nau nota kwarikwarisisiniyau. E nau nota kwarikwarisisiniyono tondono ki ka nau Mamai e mete inako nota kwarikwarisipono tondono ade nau e mete notaponi e bameya bausugoni.” ");
INSERT INTO gdn_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Iyesu inako wagubu manako Apunu Diyudiyasi (e ka eba Diyudiyasi Isikariyoto ko apunu Diyudiyasi kudubai mosi) ki e ubupu denai wagubu ke; “Kaiwawoni, kau gwede nana nu mena bamanugu baunugana nuwegei ko kau tagararaniyamu ragidai ka badidi pokere pa mena?” ");
INSERT INTO gdn_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Apunu Diyudiyasi inako wagubu, ko Iyesu denai e sibu, wagubu ke; “Iyapana nima nau nota kwarikwarisi-siniyau ki ka nau gorani tapuwani ki e makeya makeya mete kwaeyogono manako nau Mamai notai e bameya yodono ade nau mete ewapuru e bameya baigamu idiwomu. ");
INSERT INTO gdn_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ko iyapana nima nau eba nota kwarikwarisisiniyau ki ka nau gorani tapuwani ki e mete eba wadau. Nau yona yau nidiyakani ki ka eba nau naubo yonani ko ki ka nau Mamai Tonosinibu Apunai ki e yonai. ");
INSERT INTO gdn_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Nau karako wi mete yewe ewapuru idiwei ki pokere nau yona yau karako matarau wi nidiyakani, ");
INSERT INTO gdn_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ko nau wi kamadiniyani kayasugani eweya ki ka nau Mamai God uburoto wi Waitaga mosi ki ka e eya Keyai Tanai Bagi Kawaya ki nau sini pokaiya wi nene tonopoto manako e uburoto gwedegwede kuduba wi kabuwaniyoto. Nau yona kuduba naiya nidibuwani ko wi notaga gogawena ki e wi notaga ade yadini papara manako wi nau yonani ki kuduba wainapumuri. ");
INSERT INTO gdn_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Nau nuwabagi wi bamagau tarakani. Nuwabagi ki nau niya rabina-neya tondau ki nau wi negeyakani. Iyapana nau tagararasiniyamu ragidai ki mu ka nuwabagi ki maba mo eba wainapomoto wi negeni. Ki pokere, wi notaga eba koyogono kudu eba wainapiyoi. ");
INSERT INTO gdn_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Nau wi kamadiniyana kayasugana ade ewa mete wirasugana bausugana ki yonai nau ororeya mena wi nidibuwani kewowena. Wi nau yonani ki naigida mena sumampena nota kwarikwarisisinimpena ki ka nau Mamai bameya ade kayasugana yonai nidibuwani ki mibai wi wainampena ade nau mamamani mete kwaigumpena mibai ka nau Mamai e ka kawaya esida ko nau ka e kobaiya. ");
INSERT INTO gdn_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Ko ewa badidi wenawagana yonai nidibuwani ki mibai aita ewa wenayagisi empumuri ki ka wi nau sumasinimuri. ");
INSERT INTO gdn_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Waira yau wadubu apunai Seitani yabadau ki pokere nau yona rowarowa kawaya wi mete yewe eba iwogomu. E kasiyarai mo nau bamaneya pa mena, ");
INSERT INTO gdn_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ko iyapana kuduba, madega kauwagau madega posiwagau mu naigida mena kataigamana ki nana da nau nuwani notani nau Mamai bameya tondau ki pokere nau Mamai badidi wagubu ki makeya makeya nau karako kwaesugani. Ki pokere, tawa yau kamadamu kaigamu.” ");
INSERT INTO gdn_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Iyesu e tadeyau kabukabuwa ragidai waigugu were ade tadebu, wagubu ke; “Nau ka ripa ‘waeni’ ko nau Mamai e ka ripa ki kwayubapiyau apunai. ");
INSERT INTO gdn_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Nau ragini mibai eba kiroto ki ka nau Mamai nau ragini ki purupoto isiyapoto. Ko nau ragini mibai kiroto ki ka e nau ragini ki meyoto warapoto taniyagisi manako mibai kawaya daganani ewa kiroto. ");
INSERT INTO gdn_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ko wiyo, nau yonani nidibuwani ki pokaiya ka wi nuwaga notaga ororeya mena taniwena. ");
INSERT INTO gdn_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Wi nau mete ewapuru eyaka mena idiwoi ki ka ade nau wi mete ewapuru eyaka mena idiwomu. Ripa ragai mosi naureya kaiyarayagisi ki ka e mibai eba kiroto. Ko ragai ki ripa naureya tondono ki ka e mibai kiroto. Ki maba, wi wibo mena idiwoi ki ka wi mibiga eba kiroto. Ko wi nau naurineya idiwoi ki ka wi mibiga kiroto.” ");
INSERT INTO gdn_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Iyesu inako wagubu ade wagubu ke; “Ripa eya ka nau ko wi ka nau ragi-niyoma. Iyapana nima nau naurineya nau mete eyaka mena idiwomu ade nau e mete eyaka mena idiwomu ki ka e mibai kawaya daganani kiroto. Ko wi nau kamadisinimuri nau naurineya eba idiwoi ki ka wi wibo kasiyaraga pokaiya gwede mo kwaiwagi ki mibai eba wenapoto. ");
INSERT INTO gdn_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Iyapana nima nau mete ewapuru eyaka mena eba idiwomu ki apunai bo ridai ka ripa ragai gwiya-mupu surawena ki maba surayagisi manako ewa tepomoto mata pasumoto. ");
INSERT INTO gdn_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Wi nau mete ewapuru eyaka mena idiwomu ade nau yonani suwagubuwani ki wainapumuri wi rabinagau suroto tawayagisi ki ka wi gwede mosi nene wainapiyamu ki wi nau Mamai simuri manako wi badidi simupu ki kuduba e uburoto wi negeni. ");
INSERT INTO gdn_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Wi mibiga inako kiroto ki ka wi nau yonani mibai wainapiyamu kwaiwagamu ragidai manako nau Mamai e si wi pokagere kawayayagisi. ");
INSERT INTO gdn_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Nau Mamai kawaya daganani nau nota kwarikwarisisiniyau ki maba nau wi mete kawaya daganani nota kwarikwarisiniyakani ki pokere wi inako idiwoi ki ka nau maramara wi nota kwarikwarisiniyoni tondoni. ");
INSERT INTO gdn_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nau Mamai e umunui nau wadakani ki pokere e nau nota kwarikwarisisiniyau. Ki maba, wi nau gorani tapuwani ki makeya makeya kwaiwogoi ki ka nau wi maramara inako mete nota kwarikwarisiniyoni tondoni. ");
INSERT INTO gdn_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Nau yona yau nidibuwani da wi nau pokanere mibi mamamai deni mena wainapamana idiwana ki nana. ");
INSERT INTO gdn_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Nau gorani tapuwani ka yau kena; Nau wi nota kwarikwarisiniyakani ki maba wi inako mete denideni nota kwari-kwarisiwogoi ade kwayuba kasiwara-iwogoi idiwoi. ");
INSERT INTO gdn_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Iyapana nima e kowaiyoma kawaya daganani nota kwarikwarisitamiyau ki ka e eya midi kwakwarepui ki tagararapoto ade e kowaiyoma nene poyagisi ki mete baganai. E nuwaiya po muyo ki pokere e inako kwaeyagisi. ");
INSERT INTO gdn_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Wi nau nidi-buwani ki makeya makeya kwaiwogoi idiwoi ki ka wi nau kowaniyoma mibai. ");
INSERT INTO gdn_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Nau bigabiga ragidai wi eba nidiyakani ko nau kowaniyoma mibai wi nidiyakani. Bigabiga apunai ki e kawai ki notai e eba kataiya. Ko nau Mamai badidi sidibu ki yonai kuduba nau wi nidibuwani kataigubu kewo-wena ki pokere wi ka eba bigabiga ragidai ko wi ka mibai nau kowani-yoma. ");
INSERT INTO gdn_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Wi eba nau winesinimpu ko nau wi winenibuwani da wi kaiwagi maramara idiwana kaiwana ki mibai wi rabinagau kimono manako wi nau sini pokaiya gwede mo nene iwagi ki kuduba ka nau Mamai uburoto wi negeni. ");
INSERT INTO gdn_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ki pokere, nau gorani negeyakani ka yau kena; Wi deni deni nota kwarikwarisiwogoi ade kwayuba kasiwaraiwogoi idiwoi.” ");
INSERT INTO gdn_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Iyesu inako wagubu, ade tadebu, wagubu ke; “Nau tagararasiniyamu ragidai baitagisi wi girinimoto pasuni-moto ki wi wainapumuri da mu naiya nau mete inako girisinimawa pasusini-mawa. ");
INSERT INTO gdn_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Wi mu mete ewapuru idimpena ki ka mu wi diriwaga kwaetagumpena. Ko nau wi winenibuwani da wi waira yau notai ki kamadamana ki nana suwagu-buwani ki pokere karako ka iyapana ki mu nuwamugu wi pa mena. ");
INSERT INTO gdn_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nau naiya mena nidibuwani da bigabiga apunai eba uburoto e kawai ki raurupoto. Nau nidibuwani ki mibai wi wainapumuri; Iyapana nau girisinimupu ki ka mu wi mete girinimoto ade nau suwagubuwani ki nau umununi mu wadumupu ki ka wi iwagi ki wi umunuga mu mete yadini. ");
INSERT IN