﻿USE sofia;
DROP TABLE IF EXISTS sofia.gdg_vpl;
CREATE TABLE gdg_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gdg_vpl WRITE;
INSERT INTO gdg_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Antuyawino neturakkanneno gagginafuwera i Jesu Kristo a gaka i Ari David a gaka kappayi Abraham. ");
INSERT INTO gdg_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","I Abrahamino ama i Isaac a ama i Jacob a ama payi Juda andino kakkolaꞌngera. ");
INSERT INTO gdg_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","I Judeno amara Fares anni Zara, e i Tamarino inara. I Faresino ama i Esrom a ama i Aram. ");
INSERT INTO gdg_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","I Aramino ama i Aminadab a ama i Naason a ama i Salmon. ");
INSERT INTO gdg_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","I Salmonino ama i Boaz, e i Rahabino inana. I Boazino ama i Obed, e i Ruth ino inana. I Obedino ama i Jesse, ");
INSERT INTO gdg_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","e i Jesse ino ama i Ari David. I David ino ama i Solomon, e ino inana, atawa i Urias a inatawa i David. ");
INSERT INTO gdg_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","I Solomonino ama i Roboam a ama i Abias a ama payi Asa. ");
INSERT INTO gdg_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","I Aseno ama i Josafat a ama i Joram a ama i Ozias. ");
INSERT INTO gdg_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","I Oziasino ama i Joatam a ama i Acaz a ama payi Ezekias. ");
INSERT INTO gdg_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","I Ezekiasino ama i Manases a ama i Amon a ama payi Josias. ");
INSERT INTO gdg_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","I Josiasino ama i Jeconias andino kakkolaꞌngera sin neyangnganino Judyuwera sey Babilonia ta mearipannira. ");
INSERT INTO gdg_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Wasin nasinduweno inanawanino Judyuwera sino lubbunda, neyanaki Salatiel a i Jeconiasino amana. I Salatielino ama i Zorobabel. ");
INSERT INTO gdg_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","I Zorobabelino ama i Abiud a ama i Eliakim a ama payi Azor. ");
INSERT INTO gdg_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","I Azorino ama i Sadoc a ama i Akim a ama payi Eliud. ");
INSERT INTO gdg_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","I Eliud ino ama i Eleazar a ama i Matan a ama payi Jacob. ");
INSERT INTO gdg_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","I Jacob ino ama i Jose, e i Jose ino atawa i Maria a ina i Jesus a maingnganan si Kristo. ");
INSERT INTO gdg_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Kunnantu, karaꞌappatira a gagginafuwi Jesu Kristo mangiyafu ki Abraham makkiyad ki Ari David. Karaꞌappatira kappay mangiyafu ki Ari David makkiyad sino inanawanino Judyuwera sino lubbunda ta mearipannira sey Babilonia. Karaꞌappatira kappay mangiyafu sino inanawanda sino lubbunda makkiyad sino neyanakanino maingnganan si Kristo. ");
INSERT INTO gdg_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Antuyawino istoriyeno neyanakani Jesu Kristo. Neturatuwi Maria a inana a meatawa ki Jose, udde sin liyera a matawa, naammuwan si mabussitin gafu sino pannakadameno Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","I Jose a mangatawana sikwana, minakkurug sino lintiyi Moises, udde ammena anggamma meyatatalli Maria. Antuweno dinandamma si ikatwena a awana makaammu. ");
INSERT INTO gdg_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Wasin aggadandammannenay, agyanino angheli Afu Dios a nappadda sikwana si tenap, e nassapit si, “Jose a gaka i David, ammeka mattalawa mangatawa ki Maria, se ino nabussitanna, naggabwat sino pannakadameno Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Lalakineno iyanaꞌnga, e ingnganannuna si Jesus, se antuneno misalak sino tolenera sino liwaꞌda.” ");
INSERT INTO gdg_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Nakwa ammin yaw takesi meyakkuruwino nepasapiti Afu Dios sino tata a gumalabbunna a kunna si, ");
INSERT INTO gdg_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Mabussiꞌneno tata a balatanga ammena kepay nasengged, e miyanaꞌnga si lalakiya maingnganan si Emmanuel,” anggamma sapitan, ana i Dios sikwatam. ");
INSERT INTO gdg_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wasin nafati Jose, kinurungngeno sinapitino anghel e inatawana i Maria, ");
INSERT INTO gdg_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","udde ammena dinuruwi Maria kiyad si ammena neyanakino abbingnga. E wasin neyanak, nginani Jose si Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Neyanaki Jesus sey Betlehem a lubbunna Judea sin natturayani Ari Herodes. Wasinoy, agyanino inangngira sey Jerusalem a naggabwat sino lattakanna sinag a nalalaingira a mituldu nu sanneno anggamma sapitannino bitunira. ");
INSERT INTO gdg_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Wasin ginamwangira sinay, nabbebutira a nassapit si, “Sintawino agyananino bawuwa neyanaka ariyeno Judyuwera? Se initamiyeno nappaddanino bituna senyalneno neyanakanna, e antuweno inangkami sitawa maddayaw sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Wasin diningngaggi Herodes inay, nappelalotino dararanna, kunna kappayino korwanira a tolay sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Antu gafuna, nepaayangngeno pangafuwanirana padi andino mammesturuwerana lintig, e nebebuꞌna sikwara nu sintawino keyanakanino Kristo. ");
INSERT INTO gdg_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","“Sey Betlehem sito probinsiya a Judea,” nesombaꞌda. “Se antuweno nepeturakki Dios sino gumalabbunna siꞌina kunna si, ");
INSERT INTO gdg_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘Ino Betlehem a sakoꞌma Judea, antuweno kapapatiyan sino madayawira a lubbunna Judea, se antuneno paggabwatanino matturaya mifuyut anna mimut sino tolekira a gakagaka i Israel.’” ");
INSERT INTO gdg_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wasinoy, nepaayi Herodes inayira a nalalainga mituldu sino anggamma sapitannino bitunira takesi tatabbannera a ira pelang, e naammuwanna sikwareno fustuwa tiyemponeno nappaddanino bitun. ");
INSERT INTO gdg_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wasin naammuwannan, dinundunnera sey Betlehem e sinapiꞌna si, “Umangkayu sinay, e tufukandaw si nalawad inaya kaluꞌbit. Nu sumpalandaw, mulikayuna sitaw ta itulduyu sikwak takesi umangngappaya maddayaw sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Wasin nabalina nattunino ari sikwara, ginikkatira, e nappelalotino aangganda, se initara kappayino bituna initara siꞌin. Nefuyuꞌnera makkiyad sino batungngeno balaya agyananino kaluꞌbit, kasena nittud. ");
INSERT INTO gdg_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Sinallungira sino balay, e initareno kaluꞌbit anni Maria a inana. Namaliturira a naddayaw sino kaluꞌbit, kasera nelawanino nakkakangina a neyangkalinda, e neyaꞌdara sikwaneno rigalura a bulawan, bambanguwa insensuwa ngananda si frankinsens, anna mirra. ");
INSERT INTO gdg_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Wasin manawiran, nepatenappi Dios sikwara si ammerana muli ki Herodes, antu gafuna, tangananino nallakaranda a nuli sino lubbunda. ");
INSERT INTO gdg_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Wasin inanawinnino nalalaingira, nappadda ki Jose ino tata a angheli Afu Dios si tenap, e sinapiꞌna sikwana si, “Gumabwakka, e ibukalnuweno kaluꞌbit annino inana ta umangkayu sey Egipto. Agyangkayu sinay kiyad si itulduk si mulikayu, se ino gakkaddi Herodes, paintufuꞌngeno kaluꞌbit ta ipapapatena.” ");
INSERT INTO gdg_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Wasinoy, ginabwati Jose e neikkaꞌneno kaluꞌbit annino inana si tangngana gafi ta umangngira sey Egipto. ");
INSERT INTO gdg_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Antuweno nagyananda kiyad sino natayani Herodes. Nakwenay takesi meyakkuruwino nepasapiti Afu Dios sino gumalabbunna a kunna si, “Inayangkuweno Abbingku a manaw sey Egipto.” ");
INSERT INTO gdg_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Wasin nalasini Herodes a binalabaliyampelangino nalalaingira, nappelalotino bunguꞌna. E sinapiꞌna sino sindalunera ta umangngira mamapatay sino amminira a kaluꞌbita lalakiya maddawun kiyad si adwarun sey Betlehem anda sino weweꞌnginna a lulubbun. Se ammuna si antuweno fustuwa kabayangngeno tiyempowa nappaddanino bitun se ammena kinalyawanino sinapitino nalalaingira sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Gafu sinaya nakwa, neyakkuruwino nepasapiti Dios sino gumalabbunna a i Jeremias a kunna si, ");
INSERT INTO gdg_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Madingngag sey Rameno nappelalota tangiꞌda gafu sino loneno nakanda. Tangitani Raquelino abbingngera. Ammena anggamma mabambayan, nu ammena lud aggetangatangit, se awaninnino abbingngera.” ");
INSERT INTO gdg_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Wasin natayinni Herodes, nappaddeno tata a angheli Afu Dios ki Jose si tenap sin nagyananda sey Egipto, ");
INSERT INTO gdg_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","e sinapiꞌna si, “Gumabwakka ta iyanomino kaluꞌbit annino inana ta mulikayu sey lubbundawa Israel, se natayinnino nassapit si mapapatayino kaluꞌbit.” ");
INSERT INTO gdg_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Antu gafuna, ginikkatira e nuliyera sey Israel. ");
INSERT INTO gdg_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Udde wasin diningngaggi Jose si nepataliyi Arkelao a abbingi Herodes a matturay sey Judea, mattalawa muli sinay. Nepatenakkappayi Afu Dios ki Jose ta umangngira magyan sey probinsiya a Galilea. ");
INSERT INTO gdg_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Inangngira nagyan sey Nazaret. Nakwenay takesi meyakkuruwino nepasapiti Dios sino gumalabbunna mappeafu ki Kristo a kunna si, “Maingngananna si taga-Nazaret.” ");
INSERT INTO gdg_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Wasin tiyempowa nagyanangkepera Jesus sey Nazaret, inangngi Juan a Gumabawtisar sino kalolowata sakoꞌma Judea, e nanuldu sino tolayira a inang naningngag sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Sinapiꞌna si, “Iboboliyuweno liwaꞌdaw, se araꞌniyennino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","I Juanino sinapiti Isaias a gumalabbun sin nassapitanna si, “Antuneno mikulakulawu sey kalolowata massapit si, ‘Idadandawino lakarannino Afuyu a gumamwang takesi nalawanneno dalana pallakaranna.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ino barawasiyi Juan, naangwa si duꞌduꞌna kamelyu anna gaddangino sintaronna. Ino aꞌakkananna, durun anna diyuna ayokan. ");
INSERT INTO gdg_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Inang sikwaneno tolayira a naggabwat sey Jerusalem anda sino ammina lulubbunna Judea anda sino lulubbuna nassalidadammang sino wawwanga Jordan. ");
INSERT INTO gdg_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Nepunnureno liwaꞌda, kaseyira binawtisarani Juan sino wawwanga Jordan. ");
INSERT INTO gdg_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Udde wasin naita i Juanino odduwera a Fariseo anda Saduceo a umang mappabawtisar sikwana, sinapiꞌna sikwara si, “Mayan umangkayuwa massalasangkun sitaw? Inyeno nassapit sikwayu si meliꞌwakayu sino kastiguwi Dios nu mabawtisarangkayu? ");
INSERT INTO gdg_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Ammena dama, nu ammeyu abbu ipaita sino aggangwayu si gakkuruwa neboboliyuweno liwaꞌdaw. ");
INSERT INTO gdg_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Ammeyu kappay nganan si meliꞌwakayu sino kastiguna se i Abrahamino gagginafuyu, se massiki iyawira a batu, dama i Dios a pabbalin si gakagaka i Abraham. ");
INSERT INTO gdg_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Inona kastiguwi Dios sikwayu, meyamparig si wataya nedadana paggabba si kayu, e kadda kayuwa ammena mammunga si nalawad, mefungalla magabba e masikkulan.” ");
INSERT INTO gdg_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Wasinoy, netuluyna a nassapit si, “Aneno metufara gumamwanga napatig amma sikwak. Gafu sinaya kinapatingnga, ammek meannunga mattammit sino sapatuꞌna. Bawtisarantakayu pelang si danum ta mepaita si iboboliyuweno liwaꞌdaw, udde sikwana, bawtisarannakayuna sino Espirituwi Dios anna si afuy. ");
INSERT INTO gdg_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Antuneno mangukum sino tolayira. Meyamparig si tolaya aneno miyawa pittaꞌma sino apaya naaggik. E ino nabbaggat, iyalangnga, udde ino pittapanna, itakkumma sino afuya ammena maaddap.” ");
INSERT INTO gdg_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Sinoya tiyempowa namawtisarani Juan sino tolayira, ginamwangi Jesus a naggabwat sey Galilea e inang sino wawwanga Jordan ta mappabawtisar ki Juan. ");
INSERT INTO gdg_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Udde amme anggammi Juan, e sinapiꞌna si, “Ikkanaꞌngaddino mappabawtisar sikwam. Mayan ikkammangke ino umang mappabawtisar sikwak?” ");
INSERT INTO gdg_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Udde sinombati Jesus si, “Kadde, massiki akwannu, se antuweno meannunga akwanta takesi tuntulanta amminino anggammi Dios a makwa.” Wasinoy, binawtisarani Juan. ");
INSERT INTO gdg_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Wasin nasinduwa nabawtisarani Jesus, ginaꞌdangin sino dappit, e kakaꞌmeng kelanga nabukkatanino langit. E naitaneno Espirituwi Dios a naddassa kunnangke kalapatiya naffun sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","E agyanino naddamit sey langita nassapit si, “Antuyawino iiddukangkuwa Abbingku, e maanggammakungke gafu sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Wasinoy, nefuyutino Espirituwi Diosi Jesus sino kalolowat takesi tutunggungani Ofag. ");
INSERT INTO gdg_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Nagyan sinay si appatafuluwa aw anna gafiya awana nangapangngan, kasena giniꞌneno bisinna. ");
INSERT INTO gdg_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wasinoy, i Ofagga gumatutunggung, inang sino agyananna e sinapiꞌna si, “Nu gakkuruwa ikkeno Abbingi Dios, sapitannu sitawira a batu ta mabbaliyera si maakkan.” ");
INSERT INTO gdg_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Udde sinombati Jesus si, “Ino neturakka sapiti Dios, kunna si, ‘Bakkampelanga maakkanino ikabiyangnga tolay, nu ammena kappelud ammina sapitanni Dios.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Wasinoy, nefuyuti Ofag sino nadiosana lubbuna Jerusalem, e nepataꞌdangnga sino kataꞌnangana partineno Templo. ");
INSERT INTO gdg_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","E sinapiꞌna si, “Nu gakkuruwa ikkeno Abbingi Dios, mallattuka, se ino neturakka sapiti Dios, kunna si, ‘Tunanni Diosino anghelnera ta imutandaka. Tampayandaka takesi ammeka makalowan, massiki ino takkim, ammena mabiyaran si batu.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Sinombati Jesus si, “On, udde kungkappayino neturakka sapiti Dios si, ‘Ammemmad dalodawanni Dios a Afum.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Waso kunnenoy, nefuyuti Ofag sino ataꞌnangingke a kulud, e nepaitana sikwaneno ammina patturayan sito lubag andino kinabaꞌnanda. ");
INSERT INTO gdg_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Sinapiti Ofag sikwana si, “Iyaꞌdak ammin yaw sikwam, nu mamalitugga a maddayaw sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Udde sinombati Jesus si, “Manokan, Ofag! Se kunnino neturakka sapiti Dios si, ‘Dayawandonaddi Dios a Afuyu, e antu nabbelangino passerbiyandaw.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Wasinoy, inanawi Ofag, e agyanino anghelira a ginamwanga nanuffun sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Wasin diningngaggi Jesus si nabaluri Juan, nuli sey Galilea. ");
INSERT INTO gdg_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Udde ammena nagyan sey Nazaret, nu ammena lud nagyan sey Capernaum, tata a lubbun sino dappiꞌna bebaya Galilea a sakoꞌmeno Zabulon anni Neftali siꞌin. ");
INSERT INTO gdg_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Nakwenay takesi meyakkuruwino nepasapiti Dios ki Isaias a gumalabbunna a kunna si, ");
INSERT INTO gdg_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ino Galilea a sakopanneno lubagga neyaꞌda sino gakagakara Zabulon andino gakagakara Neftali, a agyan sino dappiꞌna bebay anna sino dammangngeno wawwanga Jordan, antuweno agyananino bakkannira a Judyu. ");
INSERT INTO gdg_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Ino tolayira sinay, kunnangke nagyanira si lammuk, e kunnangke ireno iturayanino katayan se awana innanamanda. Udde sitoya, aneno itanda a natuyagga sirwat, se nappadda sikwareno mappabaggaw sino nakanda.” ");
INSERT INTO gdg_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Mangiyafu sinoya tiyempo, neyafuwi Jesus a nanulduwa nassapit si, “Iboboliyuweno liwaꞌdaw, se araꞌniyennino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Wasin tata si awa malallakari Jesus sino dappiꞌna bebaya Galilea, initaneno adwera a makkolaka gumattafukul, da Simon a isamura si Pedro anni Andres. Iyattureno tafukulda sino bebay. ");
INSERT INTO gdg_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Sinapiꞌna sikwara si, “Mebulungkayu sikwak takesi pabbalintakayu si kunnangke gumattafukul si tolay.” ");
INSERT INTO gdg_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Inanawandanino tafukulda e nebulunira sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Sin aggelakalakarira sino dappiꞌna bebay, inita kappayi Jesusino adwera a makkolaka da Santiago anni Juan a abbingira i Zebedeo. Aggatakayira andino amara sino abanda a mamiyangay sino tafukulda. Inayanira i Jesus, ");
INSERT INTO gdg_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","e inanawandanino abanda annino amara, e nebulunira pay ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Nannodoyuwi Jesus sino ammina probinsiya a Galilea. Nanuldu sino sinagogera a nangibanyag sino nalawara damag mappeafu sino patturayani Dios, anna nepabbattunoyneno naddadaruma a takitino tolayira annino dyaꞌna baggira. ");
INSERT INTO gdg_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Naddinnamino inangangwa i Jesus kiyad sino ammina sakopanna Siria, antuweno inang sikwaneno ammina matakitira anna madyatanira a kakunneno naunagganira si narakkatta espiritu, ino makkoldatira, andino paralitikuwera, e nepabbattunoynera ammin. ");
INSERT INTO gdg_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Antu gafuna, odduweno tolayira a dinandan sikwana a naggabwat sey Galilea, sino Tafuluwera a Lubbun, sey Jerusalem anda sino korwana lubbunna Judea, anna sino dammangngeno wawwanga Jordan. ");
INSERT INTO gdg_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Wasin inita i Jesusino odduwera a tolay, nanuꞌdu sino kulud e nattuttud sinay. Wasin nakkakarampattino adalannera sino agyananna, ");
INSERT INTO gdg_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","sinulduwannera. Sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Nagasatino tolayira a nangammu si pobiriyera si pannakadama a mangwa sino panggammani Dios nu awana duffunna, se ireno mesapat sino patturayanna. ");
INSERT INTO gdg_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","“Nagasatino tolayira a aggalowino nakanda gafu sino liwaꞌda, se bambayanira i Dios. ");
INSERT INTO gdg_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","“Nagasatino tolayira a tagatulutuluk sino urayi Dios, se appandeno ammina nekariyi Dios. ");
INSERT INTO gdg_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","“Nagasatino tolayira a kabbatandangke a mangwa sino panggammani Dios, se duffunannera ta damara a akwan. ");
INSERT INTO gdg_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","“Nagasatino tolayira a naallak si korwana tolay, se allakkannira payi Dios. ");
INSERT INTO gdg_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","“Nagasatino tolayira a pittatandeno nakanda sino panggammani Dios, se iraneno mita sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","“Nagasatino tolayira a mappalawad sino abbafarulunino kasittolerera, se ireno mebilang si abbingi Dios. ");
INSERT INTO gdg_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","“Nagasatino tolayira a melopalopet gafu sino pangwanda sino panggammani Dios, se ireno mesapat sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","“Nagasakkayu nu atatallandakayu anna ilopalopeꞌdakayu anna massisiriyera a massapit si narakkat mappeafu sikwayu gafu sino nanguruwandaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Nappelaloꞌnaddino aanggandaw, se nedadumeno labuta neyimfuni Dios para sikwayu sey langit. Se ino akwanda sikwayu, kunna kappayino nakwa sino gumalabbunira siꞌin.” ");
INSERT INTO gdg_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Netuluyi Jesus a nanuldu, e sinapiꞌna si, “Ikkayuwa mangurug sikwak, meyampariggayu si asin sino tolayira sito lubag. Udde nu dumantakino asin, ammenan dama a pulinino peꞌna. Awaninna serbina, e metakkubbelang, e pappipiꞌnakkanino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Meyampariggayu kappay si sirwata mawwaldag sino nakammino tolayira sito lubag. Dandammandonad si nu wara lubbun sino munsuꞌnga kulud, maitengke. ");
INSERT INTO gdg_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Awangkappay misigi si lampara, kasena abbungan si angngoran, nu ammena lud itappat takesi itan amminino taabbalayireno akwanda. ");
INSERT INTO gdg_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Kunna kappay sikwayu, ammeyu nad ilefangngino angnguruddaw, nu ammekayu lud massirwat sino ammina tolay takesi itandeno nalawara aggangwayu e dayawandana i Dios a Amayu sey langit.” ");
INSERT INTO gdg_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Wasinoy, sinapikkappayi Jesus si, “Ammeyu nad dandamman si inangngak sitawa mappaibbat sino lintiyi Moises andino neturakkino gumalabbunira, nu ammek lud inang sitaw takesi iyakkuruggu amminino sinapiꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Sapitangku gakkurug sikwayu, makkiyad si ana kepay yo lubag anna langit, awaningke a maawan sino ana sino lintiyi Dios, massiki ino kaabbafawana sapit onnu ino tata a tulnak, kiyad si makwa amminino gakkaddi Dios. ");
INSERT INTO gdg_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Antu gafuna, nu wara ammena mangurug sino massiki kalalampawana lintiyi Dios anna antu kappayino itulduna sino korwanira, mebilang si kaabbafawan sino patturayani Dios. Udde ino mangurug sino lintig e itulduna pay sino korwanira, mebilang si napatig sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Udde ino sapitangku sikwayu, nu ammena nalawarino annuntuldaw sino lintiyi Dios amma sino Fariseowera andino mammesturuwerana lintig, ammeyu dama a mesapat sino patturayanna.” ");
INSERT INTO gdg_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Netuluyi Jesus a nassapit si, “Diningngaddawino lintiya netuldu sino gagginafutamira siꞌina kunna si, ‘Ammeyu nad mamapatay, se nu wara mamapatay, maukum anna makastigu.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Udde sapitangku sikwayu si massiki ino mabbungut sino bulunna, maukum. Ino kappay tolaya miyatatal sino bulunna a massapit si “Awana serbim,” medarum sino pangafuwanira. E ino kappay tolaya massapit sino bulunna si “Abulka,” meannunga metakkub sino afuy sey infiyernu. ");
INSERT INTO gdg_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Antu gafuna, nu wara iwaꞌlaꞌnu ki Dios sino Templo, e madandammu si wara pabbungutanino bulunnu sikwam, ");
INSERT INTO gdg_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","anawannu naddino iwaꞌlaꞌnu ta umangka abbu mappakoli sikwana, kaseka muliya miwaꞌlat sino iyaꞌdam ki Dios. ");
INSERT INTO gdg_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","“Nu wara manggamma midarum sikwam, malangka nadda umang sikwana ta makitatabbagga si nalawad. Se nu ammem akwan inay, idarundaka sino huwes, iyalawaꞌdaka sino pulis, e mabalugga. ");
INSERT INTO gdg_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Sapitangku gakkurug sikwam si ammeka makalawan sino abbaluran kiyad si mapagan amminino multam.” ");
INSERT INTO gdg_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Diningngaddokappayino netuldu sikwara siꞌina kunna si, ‘Ammekayu nad makibulun.’ ");
INSERT INTO gdg_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Udde sapitangku sikwayu si ino lalakiya aggatulang si tata a bafay e imallanna, nakibulunin sino nakamma. ");
INSERT INTO gdg_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Antu gafuna, nu ino diwanana matamino paggabwatanino palliwatannu, tuketannu ta itakkummu. Se tawwareno makuranganino baggim si tata a partina amma sino awana kurangnga, e metakkugga sey infiyernu. ");
INSERT INTO gdg_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","E nu ino kappay diwanana kamaꞌnuweno paggabwatanino palliwatannu, gaꞌbungannu ta itakkummu. Se tawwareno makuranganino baggim si tata a partina amma sino awana kurangnga, e metakkugga sey infiyernu.” ");
INSERT INTO gdg_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Aneno netuldu kappay siꞌina kunna si, ‘Nu ikatwayino lalakiyeno atawana, wara nad iyaꞌdana si turakka pangitan si nakkatwayira.’ ");
INSERT INTO gdg_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Udde sapitangku sikwayu si ino lalakiya mikatway sino atawana a bakkanna gafu sino akkibulunino bafay, malliwat. Liwaꞌna se pabbalinneno bafay si makibulun nu mangatawa kappay. E ino kappay lalakiya mangatawa si bafaya nekatway, makaliwakkappay si makibulun.” ");
INSERT INTO gdg_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Netuluyi Jesus a nassapit si, “Diningngaddokappayino netuldu sino gagginafutamira siꞌina kunna si, ‘Ammeyu nad talekkuranino nekariyu, nu ammeyu lud akwanino nesapatayu ki Afu Dios.’ ");
INSERT INTO gdg_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Udde sapitangku sikwayu si ammekayungke nad massapata. Ammeyu nad passapateno langit, se antuweno pattutturani Dios a matturay. ");
INSERT INTO gdg_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Ammeyu naggappay passapateno lubag, se antuweno pitappatanna sino takkina, onnu sey Jerusalem, se antuweno lubbunino madandayawa Ari. ");
INSERT INTO gdg_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Massiki ino uluyu, ammeyu nad passapata, se ammeyu dama a mapafuraw onnu mapangisitino massiki tata a abuk. ");
INSERT INTO gdg_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Unoyneno sapitandopelang si ‘On’ onnu ‘Awan’ nu gakkuruwino ikarim, a ammeyu dagganan si sapata. Se massiki sanna a idaggayu, maggabwat ki Satanas.” ");
INSERT INTO gdg_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Diningngaddokappayino netuldu sikwara siꞌina kunna si, ‘Nu wara tolaya manaral sino mateno bulunna, madaral kappenaddino matana, e ino tolaya manammu sino ngipanneno bulunna, matammu kappenaddino ngipanna.’ ");
INSERT INTO gdg_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Udde sapitangku sikwayu si ammeyu nad mabbalat sino tolaya mangwa si narakkat sikwayu, nu ammekayu lud mangwa si kunnayaw. Nu wara manipang sino diwanana paringilnu, purayannu ta sipangnganna kappayino tafik. ");
INSERT INTO gdg_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Nu wara kappay midarum sikwam e pammultandaka si barawasi, nalawad nu iyaꞌdangkappayino tafalnu. ");
INSERT INTO gdg_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","E nu wara mipatut sikwama mattu sino iggamma si takilometro, massiki nu attunnu si adwa a kilometro. ");
INSERT INTO gdg_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Nu wara marang sikwam, aꞌdannu, e nu wara kappay takkawanda sikwam, ipatakkom.” ");
INSERT INTO gdg_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Diningngaddawino netuldu sikwara siꞌina kunna si, ‘Anggammandonaddino bafulundawira, e kababannaddawino kakkalingayuwera.’ ");
INSERT INTO gdg_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Udde sapitangku sikwayu si anggammandonaddino kakkalingayuwera anna ikararandonaddino milopalopetira sikwayu ");
INSERT INTO gdg_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","takesi maita si gakkuruwa abbindakayuwi Dios a Amayu sey langit. Se i Dios, pawwaldanneno sinag sino ammina tolay, massiki narakkat onnu nalawad. E purananna kappay sino lubangngeno naggaddangnga tolay anna sino lubangngeno bakkanna naggaddang. ");
INSERT INTO gdg_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Nu ino pelang manggam sikwayuweno anggammandaw, wara kad labuꞌdaw ki Dios? Massiki ino naingapira a gumattuki si buwit, damara a mangwa si kunnenoy. ");
INSERT INTO gdg_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","E nu ino pelang bafulundawireno pannakammandaw, sanna kaddino kedumandaw sino korwanira? Se massiki ino ammera nangammu ki Dios, akwanda kappay. ");
INSERT INTO gdg_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Kunnantu, maawag si awaningke nad pakkuranganino kinalawaddaw a kakunna i Dios a Amayu sey langita awaningke pakkuranganna.” ");
INSERT INTO gdg_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Netuluyi Jesus a nanuldu, e sinapiꞌna si, “Itandaw ta nu mangwakayu si nalawad, ammeyu ipaita si korwana tolay ta dayawandakayu. Se nu kunnenoyino akwandaw, awanna a labut si appandaw sino Amayu sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“Antu gafuna, nu mangaꞌdakayu si duffun sino mekakallakkira, ammeyu nad ipaita anna padidingngag sino odduwera a tolay a kunneno akwanino massasannakammira sino paddayawanda anna sino dalan takesi medayawira. Sapitangku gakkurug sikwayu, inapparanino labuꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Antuweno nu wara iyaꞌdayuwa duffun sino mekakallakkira, ammeyu nad ipakaammu massiki sino kadikkattana bulundaw ");
INSERT INTO gdg_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","takesi awana makaammu. E ino Amayuwa mita sino akwandawa amme maammuwanna korwan, antuneno mallabut sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Sinapikkappayi Jesus si, “Nu makkararaggayu, ammeyu nad tuntulannino aggangweno massasannakammira, se angganda a mattaꞌdagga makkararag sino paddayawanda anna sino paddarambalanna dalan takesi itanireno tolayira. Sapitangku gakkurug sikwayu, inapparanino labuꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Udde nu makkararagga, sumallungka si kwartuwa ikka pelang e iyakuꞌnu, kaseka makkararag ki Dios a Amama ammena maita. E ino Amama mita sino akwannuwa amme maammuwanna korwan, antuneno mallabut sikwam. ");
INSERT INTO gdg_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Sino kararaddaw, ammeyu nad musar si odduwa sapit a ammeyu dandammannino anggamma sapitan a kunneno aggangweno tolayira a amme nangammu ki Dios. Kunnenayino akwanda se aridda si madingngaggino kararadda gafu sino kasoddangnga. ");
INSERT INTO gdg_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Ammeyu tuntulannino akkararadda, se ino Amayu sey langit, ammunanino awandaw liyeyuwa arangngan. ");
INSERT INTO gdg_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Kunna nad yawino akkararaddaw. ‘Amamiya ana sey langit, madayonaddino ngannu. ");
INSERT INTO gdg_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Gumamwangngaddino patturayannu takesi maangweno panggammannu sito lubag a kunna pay sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Iyaꞌdam sikwamiyeno makkana awammi sitawa aw. ");
INSERT INTO gdg_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Pakomannuweno liwaꞌmi se pakomammi kappayino nakaliwatira sikwami. ");
INSERT INTO gdg_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Duffunandakami ta ammekami matutunggungan e meliꞌwakami si narakkat.’ ");
INSERT INTO gdg_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Pakomandonaddino malliwatira sikwayu, se nu pakomandawira, pakomandakayu kappayino Amayu sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Udde nu ammeyuwera pakoman, amme kappay pakomanino Amayu sey langitino liwaꞌdaw.” ");
INSERT INTO gdg_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Wasinoy, netuluyi Jesus a nassapit si, “Nu mallantangkayuwa mangngan, ammeyu nad ipaita si malowino nakandaw a kunneno aggangweno massasannakammira. Se angganda a maammuwanino tolayira si mallantangira a mangngan, antuweno ammera lawarannino baggira. Sapitangku gakkurug sikwayu, inapparanino labuꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Antuweno nu mallantangkayuwa mangngan, mimutungkayu nad anna mallagguggayu ");
INSERT INTO gdg_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","takesi awana mangammu si mallantangkayuwa mangngan, nu bakkampelangi Dios a Amayuwa ammena maita. Se itanneno akwandawa amme maammuwanna korwan, e antuneno mallabut sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Ammekayu mampat si kinabaꞌnang sito lubag, se ino kukwayu sitaw, naladda a darallanna anay anna lati, e aneno tolayira a sumallunga mattakaw. ");
INSERT INTO gdg_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Antu nad ampattandawino kinabaꞌnandaw sey langit, se awaningke a anay anna latiya manaral, e awangkappaya makatallunga mattakaw. ");
INSERT INTO gdg_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Se ino kakuruwanna, ino agyananino kinabaꞌnandaw, antu kappayino agyananino nakandaw.” ");
INSERT INTO gdg_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ino mata, antuweno gumansirwaꞌna baggi. Antu gafuna, nu nalawarino angngitama mittata ki Dios, mabbaggawino nakammu. ");
INSERT INTO gdg_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Udde nu narakkattino angngitam, lammuk kepayino nakammu. Nu sapitannu si nabaggawino nakammu gampade lammuk kena, gakkuruwingke a lammuk kepay.” ");
INSERT INTO gdg_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Ammena dama nu adweno amungngeno tata a aripan, se anggammanneno tata e kaꞌganneno tata. Ipatingnga kappayino tata e balawanneno tata. Antu gafuna, nu pirakino aggadandammandaw, ammeyu dama a mangwa sino panggammani Dios. ");
INSERT INTO gdg_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Antuwenayino gafuna a sapitangku sikwayu, ammekayu nad maddararan mappeafu sino akkanan, inuman, anna barawasiya maawaddaw sitawa biyag. Ammena kad napatiyino biyag anna baggiyu amma sino akkanan anna barawasi? Gafu se i Diosino nangaꞌda sino biyag anna baggiyu, antu kappayino mangaꞌda sino maawaddaw. ");
INSERT INTO gdg_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Dandammandonaddino mammanukira. Ammera mabbini, ammera ke maggani, awangkappay alanda a pimfunan sino akkananda, udde ammera mabisinan, se iyaꞌdeno Amayu sey langitino akkananda. Ammekayu kad napatig amma sino mammanukira? ");
INSERT INTO gdg_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Ino tata kappay, massiki nu makadaradararangkayu, ammeyu dama a pasoddannino biyaddaw si massiki taorappelang. ");
INSERT INTO gdg_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“Mayan maddararangkayu kappay mappeafu sino pabbarawasiyu? Itandawino addokallino sabungira sino danak. Ammera mattarabafu anna massinnun, ");
INSERT INTO gdg_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","udde sapitangku sikwayu, massiki i Ari Solomon a nabaꞌnangngingke, awana barawasina a mekunna sino kinalawarirenaya sabung. ");
INSERT INTO gdg_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Nu kunnenayino kinalawara iyaꞌda i Dios sino kaddattira sino danaka mabiyayira pelang si tata si aw e masikkulanira si kadaramaꞌna, ammena kaggappay mangaꞌda sino barawasiya awandaw? Mayan kurang kepayino annalaꞌdaw sikwana? ");
INSERT INTO gdg_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Antu gafuna, ammekayu nad maddararana massapit si, ‘Sintomatino pappammi sino akkanammi anna inumammi andino pabbarawasimi?’ ");
INSERT INTO gdg_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Se antuweno kabbatannino tolayira a amme nangammu ki Dios. Udde sikwayu, ammuweno Amayu sey langit si awandawira ammin inay. ");
INSERT INTO gdg_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Antu gafuna, pittatandonaddino nakandawa maddandam sino patturayani Dios andino annuntuldaw sino naggaddangnga pakwana sikwayu, e iyaꞌdanana ammin inaya awandaw. ");
INSERT INTO gdg_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Kunnantu, ammeyu nad paddararananino makwa nu daramat. Se ino makwa nu daramat, kaseyuna dandamman sinoy. Se fustuwennino dyata lawumandaw kadda aw, e ammeyu nad dadagganan.” ");
INSERT INTO gdg_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Netuluyi Jesus a nanulduwa nassapit si, “Ammeyu nad ukumannino bafulundawira takesi ammerakayu pay ukumanni Dios a makastigu. ");
INSERT INTO gdg_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Se ino angngukundaw sino bafulundawira, kunna kappeneno angngukumi Dios sikwayu. Nu awana allaꞌdaw sikwara, ammerakayu pay allakkanni Dios. ");
INSERT INTO gdg_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Kunnangke aggitannuweno bibissangnga ana sino mateno bulunnu, a ammem magiꞌneno dokalla ana sino matam. ");
INSERT INTO gdg_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Ansannu massapit sino bulunnu si ariyannuweno ana sino matana a ammem maiteno ana sitan matam? ");
INSERT INTO gdg_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Ikka a massasannakam, ariyannubbuweno ana sino matam takesi nalawarino angngitam, kasem dama a ariyanino ana sino mateno bulunnu.” ");
INSERT INTO gdg_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Netuluyi Jesus a nassapit si, “Ammeyu ipatuta manuldu sino tolayira a mangayoyung sino nadiosana sapiti Dios se ammera anggamma dingngaggan. Meyampariyira si atu onnu bafuy, se massiki nu nangineno iyaꞌdam sino nabunguta atu, katandaka kepay, e massiki nu perlasino itakkummu sino bafuy, pappipiꞌnakkanna pelang.” ");
INSERT INTO gdg_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Sinapikkappayi Jesus si, “Kanayungkayu nadda marang ki Dios, e iyaꞌdana sikwayuweno arangngandaw. Ituluydokappaya mintufuk sikwana sino awandaw, e sumpalandaw. Itulutuluydokappaya mattottok, e mabukkatanino sawang ta makatallungkayu. ");
INSERT INTO gdg_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Se massiki inyeno marang ki Dios, maaꞌdan. Massiki inyeno mintufuk, makasumpal, e massiki inyeno mattottok, mabukkatanino sawang para sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Dandammandaw, ikkayuwa mapparanak, nu tinapayino arangngannino abbindaw, aꞌdandokad si batu? ");
INSERT INTO gdg_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Onnu nu bilisino arangnganna, aꞌdandokad si ulag? ");
INSERT INTO gdg_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Ikkayuwa narakkatta tolay, ammuyuwa mangaꞌda si nalawad sino abbindaw. Mannanotinna ki Dios a Amayu sey langit, nalawanneno iyaꞌdana sikwara a marang sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","“Kunnantu, akwandonad sino kasittoleyuweno anggandawa akwanda sikwayu, se antuweno anggamma sapitannino ammina lintiyi Moises andino tulduweno gumalabbunira.” ");
INSERT INTO gdg_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Sumallungkayu nad sino bibissangnga lamwangan, se nalaweno lamwangan annino dalana umang sey infiyernu, e odduweno sumallung anna mallakad sinay. ");
INSERT INTO gdg_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Udde bibissangngino lamwangan anna madyatino dalana umang sino biyaya mannayun, e bisangngira ke a makasumpal.” ");
INSERT INTO gdg_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Palanandawino massisiriyera a gumalabbuna gumamwang sikwayu, se nannakammino kaitanda a kunnangke karnero, udde ino gakkuruwa aggangwara, manarallira a kunnangke sumarona atu. ");
INSERT INTO gdg_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ino pimunuwandaw sikwara, ino aggangwara, a kakunneno kayu, ino bungareno kaimunuwanda. Se ino uway, ammena mammunga si ubas, e ino anifung, ammena mammunga si igos. ");
INSERT INTO gdg_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ino nalawara kayu, nalawabbayino bungana, udde ino narakkatta kayu, narakkakkappepayino bungana. ");
INSERT INTO gdg_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Se ammena dama a mammungeno nalawara kayu si narakkat, e ammena kappay dama a mammungeno narakkatta kayu si nalawad. ");
INSERT INTO gdg_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ammina kayuwa narakkattino bungara, meyamfungallira a magabba takesi metunguwera. ");
INSERT INTO gdg_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Kunnantu, damayuwa maimunuwanino massisiriyera a gumalabbun gafu sino aggangwara.” ");
INSERT INTO gdg_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“Ino mesapatirana sino patturayani Dios, bakkanna amminira a mingngan sikwak si Afura, nu bakkampelangino mangwera sino panggammani Ama sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Nanu madaꞌnganeno awa pangukumani Dios sino tolayira, odduneno massapit sikwak si, ‘Afu, Afu, isapaꞌdakami nad sino patturayannu se nanuldukami sino mappeafu sikwam, anna inusarmi kappayino ngannuwa nappaanaw si narakkatta espiritu anda sino nangwammi si odduwa kakkaꞌbaw.’ ");
INSERT INTO gdg_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Udde ino itabbagguna sikwara, ‘Ammetakayu inammu. Manokayu sitaw, ikkayuwa nangwa si narakkat.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Amminira a tolaya maningngag anna mangurug sinaya sinapikku, meyampariyira si nalainga tolaya namataꞌdag si balay sino utunna batu. ");
INSERT INTO gdg_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Wasinoy, nattalannab, naddokallino wawwang, e natuyaggappayino bayabbag, udde ammena naanseno balay, se nafundasiyon si batu. ");
INSERT INTO gdg_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Udde ino tolaya naningngag sinaya sinapikku e ammena kuruwan, meyamparig si pangababulana tolaya namataꞌdag si balay sino karatan. ");
INSERT INTO gdg_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Wasin nuran, naddokallino wawwang anna natuyaggino bayabbag, naletwarino balay e nadaral.” ");
INSERT INTO gdg_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Wasin nasinduwi Jesus a sinapit ammin inay sino tolayira a nakkakarampat, nakkaꞌbawira sino annulduna, ");
INSERT INTO gdg_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","se ino nepanulduna, maitengke si wara turena, a bakkanna kakunneno annulduweno mammesturuwerana lintig. ");
INSERT INTO gdg_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Wasin maddawuti Jesus sino kulud, odduweno tolaya dinandan sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Agyanino lalakiya nakkutalla inaraꞌni sikwana. Namalitud sino aꞌlangnga a nakiggimallak sikwana si, “Afu, nu anggammu, damaraka pabbattunoyan.” ");
INSERT INTO gdg_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Inappangani Jesusino nakkutal, kasena sinapit si, “On, anggangku si mabbattunoykan. Maariyen yan kutalnu.” E kakaꞌmeng kelanga naariyeno kutalna. ");
INSERT INTO gdg_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","E sinapikkappayi Jesus si, “Ammem sapitan yaw si massiki sanna a tolay, nu ammem lud umang mappaita sino padi ta itanna nu naariyennino kutalnu. Kasem iyaꞌda sikwaneno netuni Moises siꞌina mewaꞌlat ki Dios takesi wara pangammuwanino tolayira si gakkuruwa nabbattunoykan.” ");
INSERT INTO gdg_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Wasin ginamwangi Jesus sey Capernaum, agyanino kapitanna sindaluwa taga-Roma a inang nanambal sikwana. Nakiggimallak sikwana a nassapit si, ");
INSERT INTO gdg_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Afu, aneno aripangku sey balaya nabayinna matakit. Ammena makaanikkad e madyataningke.” ");
INSERT INTO gdg_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","“Umangngetam mantu ta pabbattunoyangku,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Udde sinapitino kapitan si, “Massiki ammekan umang, Afu, se ammena meannunga sumallungka sino balek. Sapitannumpelang si mabbattunoyin, e ammuk si mabbattunoyinnino aripangku. ");
INSERT INTO gdg_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Se massiki ikkanak, aneno mangituray sikwak, e ana payino sindalukira a iturayangku. Nu sapitangku sino tata si ‘Umangka,’ umang, e nu sapitangku kappay sino tata si ‘Gumamwangka sitaw,’ gumamwang, e nu sapitangku kappay sino aripangku si ‘Akwannu yaw,’ akwanna.” ");
INSERT INTO gdg_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Nakkaꞌbawi Jesus sino naningngagganna sinay, e sinapiꞌna sino tolayira a dinandan sikwana si, “Gakkurug yo sapitangku sikwayu, awana dinambalkuwa tolay sikwayuwa gakagaka i Israel a kunnenoyino kinatuyangngeno angngurungnga. ");
INSERT INTO gdg_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Dandammandaw yaw, odduneno bakkannira a Judyu a mesapat sino patturayani Dios a maggabwat si palulubbun, e makiaꞌlangirana a mangngan sikwara Abraham, Isaac, anni Jacob. ");
INSERT INTO gdg_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Udde ino Judyuwera a mesapaꞌnad sino patturayani Dios, metakkufirana sino kalammukana aroyu sikwana, e mattatarangitirana anna mangngarangaritammirana.” ");
INSERT INTO gdg_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wasinoy, sinapiti Jesus sino kapitan si, “Umanokan, se ino kinurungnguwa makwa, nakwen.” Nabbattunoyinnino aripanneno kapitan sinoyingke a orat. ");
INSERT INTO gdg_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Wasin tata si aw, inangngi Jesus sino balera Pedro, e initaneno katuwangani Pedro a bafaya aggaidda se mababannag. ");
INSERT INTO gdg_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Inappanganneno kamattino bafay, e kakaꞌmeng kelanga naariyeno babannangnga. Ginabwat e pinakkanna i Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Wasin maggafiyen, neyanda ki Jesusino odduwera a naassaddan. E nepaanoneno narakkattira a espiritu sino sapiꞌna pelang, e nepabbattunoyneno amminira a matakit. ");
INSERT INTO gdg_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Nakwenay takesi meyakkuruwino nepasapiti Dios ki Isaias a gumalabbunna a kunna si, “Antuwengkepayino nari sino dyaꞌneno baggitam annino takittam.” ");
INSERT INTO gdg_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Wasin tata si fuwab, inita i Jesusino odduwera a tolaya inaribumbung sikwana, e sinapiꞌna sino adalannera si, “Maddammangetam.” ");
INSERT INTO gdg_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Udde inaraꞌniyeno tata a mesturuna lintig e sinapiꞌna si, “Afu mesturu, mebulunak sikwam massiki sintawino umangngannu.” ");
INSERT INTO gdg_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Sinombati Jesus a nassapit si, “Massiki ino amutitira, aneno agwefa pabbalayanda, andino mammanukira, aneno umuꞌdera, udde ikkanaka Abbingnga Tolay, awana fustu si pagyanangku.” ");
INSERT INTO gdg_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Agyangkappayino adalanna a nassapit si, “Afu, mebulunak sikwam, udde mattarongka, ta umangku abbu itanammi amak.” ");
INSERT INTO gdg_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Mebulungkan sikwak,” kunni Jesus. “Purayannuweno natay ta itanammino bulunnera a kunnangke natayira kappay se ammera mangurug sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wasinoy, nattakayi Jesus andino adalannera si abang e ginikkatira. ");
INSERT INTO gdg_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Nadaꞌnganira si kalipappag sino tangngana bebay, e lumannannaddino abanda gafu sino palunga medaladaluyak sikwara. Udde i Jesus, aggakaturug. ");
INSERT INTO gdg_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Inanda inafat, e sinapiꞌda si, “Afu, isalaꞌdakami, se malimattetamun!” ");
INSERT INTO gdg_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wasinoy, “Mayan mattalokayu? Mayan kurang kepayino annalaꞌdaw sikwak?” kunna. Ginabwat e nepassiyanaꞌngeno kalipappag andino palung, e nassiyanakkiran. ");
INSERT INTO gdg_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nakkaꞌbawirangke ammin, e sinapiꞌda si, “Sanneno katolena yaw? Massiki ino kalipappag andino palung, kuruwandeno sapitanna.” ");
INSERT INTO gdg_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Wasin naddammanda Jesus, ginaꞌdangira sino sakopanna Gadarenowera. Agyanino adwera a lallakiya naunaggan si narakkatta espirituwa naggabwat sino attanammana nanambal sikwana. Kattalatalawira se nappelalotino tansiꞌda, antuweno awaninna makaturira mallakad sinay. ");
INSERT INTO gdg_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Paꞌlata initara i Jesus, nakkulawuwera a nassapit si, “Ikka a Abbingi Dios, sanneno gakkannu sikwami? Inangka sitawa mappaidam sikwami massiki ammena kepay nadaꞌngeno fustuwa kaukumammi?” ");
INSERT INTO gdg_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ammena kura aroyu sino agyananda, agyanino odduwera a bafuya maddukiruk. ");
INSERT INTO gdg_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Antuweno nappekakallakkino narakkattira a espiritu ki Jesus a nassapit si, “Nu paanawandakami sitawira a tolay, purayandakamiya munag sinayira a bafuy.” ");
INSERT INTO gdg_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","“Kadde, umangkayu,” kunni Jesus. Kunnantu, inanawandeno lallakiyera e inangngira inunag sino bafuyira. Kakaꞌmeng kelanga naddadaraddaggino bafuyira a naddawut, nangawwatira sino dabbaꞌngeno bebay, nadaraꞌnira, e nalimattira ammin. ");
INSERT INTO gdg_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ino mindaggira sino bafuy, nabbafukalira a inang sino kaaraꞌniyana lubbun, e nepadamadda sino tolayira ammin inaya nakwa, pati ino nakwa sino lallakiyera a naunaggan sino narakkattira a espiritu. ");
INSERT INTO gdg_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Antu gafuna, ino amminira a tolay sinaya lubbun, inangngira ki Jesus ta tatabbanda. Wasin initara i Jesus, nakiggimallakkira sikwana ta anawanneno lubbunda. ");
INSERT INTO gdg_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wasinoy, nattakera Jesus sino abang e naddammangira sino lubbunna. ");
INSERT INTO gdg_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Waso kunnenoy, agyanino niyangngira sikwana si tolaya paralitikuwa aggaidda. Inita i Jesusino talaꞌda sikwana, e sinapiꞌna sino paralitiku si, “Ikka a kolakku, pattuyaggannuweno nakammu, se napakomaninnino liwaꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Wasinoy, ino mammesturuwerana lintiya nagyan sinay, kunda sino nakanakanda si, “Iyana tolay, ikunnananino baggina ki Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Udde ammuwi Jesusino ana sino nakanda, e sinapiꞌna si, “Mayan narakkattino dandammandaw? ");
INSERT INTO gdg_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Naladda maꞌlura massapit si ‘Napakomanino liwaꞌnu’ amma sino ‘Gumabwakka ta umanokan.’ ");
INSERT INTO gdg_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Udde nu kunnenoy, sapitangku mantuweno madyat takesi ipaitak si ikkanakino Abbingnga Tolaya aneno kalintiyanna sito lubagga mamakoma si liwat.” E sinapiꞌna sino paralitiku si, “Gumabwakka, appannu yan iddam, ta umanokan.” ");
INSERT INTO gdg_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","E ginabwatino tolay, e inanawin. ");
INSERT INTO gdg_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Nakatalawino tolayira a nita sinay, e dinayora i Dios gafu se neyaꞌdana si tolayino kalintiyana mangwa si kunnenoy. ");
INSERT INTO gdg_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Nanawi Jesus sinay, e wasin aggelakalakad, initaneno gumattuki si buwita mingngan si Mateo a aggatuttud sino ofisinana. “Mebulungka sikwak,” kunni Jesus. Ginabwati Mateo e nebulun sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wasin aggekakkanda Jesus andino adalannera sey balera Mateo, odduweno ginamwangira a gumattuki si buwit annino korwanira a minalliwata tolay, e nakikkanira. ");
INSERT INTO gdg_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Wasin initeno Fariseowereno inangwana, sinapiꞌda sino adalannera si, “Ansanna lang makikkanino mesturuyu sino gumattukiyera si buwit andino korwanira a minalliwata tolay?” ");
INSERT INTO gdg_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Udde diningngaggi Jesusino nebebuꞌda, e sinapiꞌna a niyamparig si, “Inyeno mawag si doktor, nu bakkampelangino matakit? ");
INSERT INTO gdg_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Ammek inang sitawa mayag sino naggaddangngira a tolay, nu ammena lurino malliwatira. Umandonad adalannino fustuwa anggamma sapitannino nepeturakki Dios a kunna si, ‘Aanggangkuweno aggikallaꞌdaw sino bafulundawira amma sino iwaꞌlaꞌdaw sikwak.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Wasinoy, inangngino adalanira i Juan a Gumabawtisar ki Jesus, e sinapiꞌda si, “Ikkami andino Fariseowera, aneno awa mallantangkamiya mangngan. Udde ino adalannuwera, ammera akwan. Sanneno gafuna?” ");
INSERT INTO gdg_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Sinabbira i Jesus a niyamparig si, “Nu wara makkasar, kundokad si amme makikkanino bafulunino mangatawa a inayanna? Udde dumaꞌnganeno tiyempowa meanaw sikwareno mangatawa, kaserana mallantanga mangngan.” ");
INSERT INTO gdg_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Sinapikkappayi Jesus a niyamparig si, “Awana tolaya miyappit si bawu sino gamita sinnun. Se makkassannino bawu e ilabbenneno deꞌna, e maampapissayino naappitan. ");
INSERT INTO gdg_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Awangkappaya miyekwa si talifawu sino dadana sinan anganga gaddang, se battakanna. Mesayukino tayug anna madaral kappayino gaddang. Ino bawuwa tayug, bawu kappenaddino gaddanga keyekwanna takesi mabbalanayunira a adwa.” ");
INSERT INTO gdg_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Wasin aggesapasapiti Jesus sikwara, ginamwangino tata a turena Judyu. Namalitud sino aꞌlangnga e sinapiꞌna si, “Pappateneno abbingkuwa bafay, udde umangngu abbu appangan ta mabiyag.” ");
INSERT INTO gdg_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nebuluni Jesus sikwana e dinandangkappayino adalannera. ");
INSERT INTO gdg_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Agyanino tata a bafay sinaya aggedada si karadwa si run. Inaraꞌni sino likuri Jesus, e sinenggenneno barawasina. ");
INSERT INTO gdg_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Se kunna sino nakamma si, “Massiki nu senggerangku nabbelangino barawasina, mabbattunoyakun.” ");
INSERT INTO gdg_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Nabbaliwiti Jesus, initaneno bafay, e sinapiꞌna sikwana si, “Ikka a abbingku, pattuyaggannuweno nakammu. Gafu sino angngurungngu sikwak, nabbattunoykan.” E nabbattunoyin gakkurug. ");
INSERT INTO gdg_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Wasin ginamwanda Jesus sino baleneno turay, initaneno mamalyotira andino nakkakarampattira a tolaya makkanawakaw, ");
INSERT INTO gdg_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","e sinapiꞌna si, “Umanokayu sitan, se ammena natay yan balatang, naturubbelang.” Kinakkatawanino tolayira i Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Wasin nepallawannera, sinallung sino agyananino balatang, e iniggammanneno kamaꞌna. E ginabwatin. ");
INSERT INTO gdg_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Antu gafuna, naddinnamag inaya inangwa i Jesus sino ammina weweꞌnginna lulubbun. ");
INSERT INTO gdg_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Wasin inanawi Jesus sinaya balay, dinandanino adwera a lallakiya lappat, e nekulawura a nassapit si, “Ikka a Gaka i David, allakkannakami!” ");
INSERT INTO gdg_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Wasin sinallungi Jesus sino balay, sinallungira kappay. E nebebuꞌna sikwara si, “Kuruwandaw si damaka ariyanino lappaꞌdaw?” “On, Afu,” kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wasinoy, sinukkalli Jesusino matara e sinapiꞌna si, “Gafu sino angnguruddaw sikwak, makwennino anggandaw.” ");
INSERT INTO gdg_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","E makaiteran. Sinutunnerangke a nassapit si, “Ammeyu sapasapitan si massiki sanna a tolayino nakwa sikwayu!” ");
INSERT INTO gdg_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Udde wasin inanawira, neyanannera a sinapasapit inaya inangwa i Jesus si ammina weweꞌnginnenaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Wasin umanawiran, agyanino niyamwangira sino agyanani Jesus si lalakiya ammena makadamit se naunaggan si narakkatta espiritu. ");
INSERT INTO gdg_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Nepaanawi Jesusino narakkatta espiritu sikwana, e nakadamitinnino lalaki. Nakkaꞌbawingke ino tolayira e sinapiꞌda si, “Awangkepaya initamiya kunnenoy sino ammina lulubbun sito Israel.” ");
INSERT INTO gdg_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Udde agyanino Fariseowera a nassapit si, “Ino afafuweno narakkattira a espiritu ino nangaꞌda sikwana sinaya pannakadamana a mappaanaw si narakkatta espiritu.” ");
INSERT INTO gdg_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Nannodoyuwi Jesus sino lulubbuna manuldu sino sinagogarera a mibanyag sino nalawara damag mappeafu sino patturayani Dios. Nappabattunoy kappay sino matakitira, massiki sanneno takit anna dyaꞌneno baggira. ");
INSERT INTO gdg_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Wasin inita i Jesusino odduwera a tolay, inallaꞌngera, se kakallakkira anna awana pappaduffunanda a kundangke karnerowa awana mimut sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Antuweno sinapiꞌna sino adalannera si, “Meyamparig si apayino tolayira a mawag si manuldu sikwara. Odduwen naddino magani, udde bisangngira ke ino maggani. ");
INSERT INTO gdg_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Arangngandonad ki Dios a makwan apay ta manundun si korwanira a manulduwa meyamparig si maggani.” ");
INSERT INTO gdg_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Wasin tata si aw, inayani Jesusino karadwera a adalanna, e nakkakarampattira. Neyaꞌdana sikwareno kalintiyana mappaanaw si narakkatta espiritu anna mari si ammina klasena takit anna dyaꞌna baggi. ");
INSERT INTO gdg_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Irayawino nganganino karadwera a apostol: ino palungu, i Simon a nginaliꞌna si Pedro, e ana kappayi Andres a kolaꞌnga, da Santiago anni Juan a abbingira i Zebedeo, ");
INSERT INTO gdg_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","da Felipe anni Bartolome, da Tomas anni Mateo a gumattuki si buwit, i Santiago a abbingi Alfeo anni Tadeo, ");
INSERT INTO gdg_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","i Simon a ngananda si Patriota se ikaloneno lubbunna, anna i Judas Iscariote a antuneno mallaku ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Dinunduni Jesus inayira a karadwa a adalanna, e sinunnera a nassapit si, “Ammekayu umang sino lulubbunino bakkannira a Judyu. Ammekayu kappay umang sino lulubbun sey Samaria, ");
INSERT INTO gdg_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","nu ammekayu lud umang sino bafuluntamira a gakagaka i Israel a kundangke naawana karnero. ");
INSERT INTO gdg_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Kadda umangngandaw, ibanyaddaw si araꞌniyennino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Pabbattunoyandawino matakitira anna pangngangolindawino natayira. Pabbattunoyandokappayino nakkutallira anna paanawandawino narakkattira a espiritu. Awana pinagandaw sinaya pannakadama a neyaꞌdak sikwayu, antuweno ammeyu naggappay ipapageno duffundaw. ");
INSERT INTO gdg_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ammekayu miyangkalin si dokalla pirak onnu massiki dipilata. ");
INSERT INTO gdg_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ammekayu kappay miyangkalin si pasiking, pamataliyandaw si barawasi anna sapatut, anna tokud. Ino duffunandaw, ireno mimut sikwayu, se ino mattarabafu, meannunga maaꞌdan si ikatolena. ");
INSERT INTO gdg_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Kadda lubbuna umangngandaw, mintufukkayu si tolaya manggamma mappadilot sikwayu, e antu naddino pagyanandaw kiyad si umanokayu sinaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Nu maddilokkayu sino balay, sapitandaw si ‘Bindisiyonandakayu naddi Dios.’ ");
INSERT INTO gdg_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Nu nalawarino appadiloꞌda sikwayu, gakkuruwa mabindisiyonanira, udde nu ammera meannunga mabindisiyonan, ammena makwa. ");
INSERT INTO gdg_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Nu gumamwangkayu si tata a lubbun onnu balay, e ammerakayu paddilotan anna ammera kappay anggamma dingngaggannino sapitandaw, tattakandawino lafuk sino takkiyu sino anawandaw sinay ta antuweno pangammuwanda si ireno makammu sino kakastiguwanda. ");
INSERT INTO gdg_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Gakkurug yo sapitangku sikwayu, nanu madaꞌngeno pangukumani Dios si ammina tolay, nadammaꞌneno kastiguweno tolayira sinay amma sino kastiguweno taga-Sodomera andino taga-Gomorrera.” ");
INSERT INTO gdg_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Netuluyi Jesus a nassapit si, “Dingngaggandaw yaw. Dundunantakayu sino narakkattira a tolay a kundawingke ino karnerowa umang sino agyananino kattalatalawira a sumarona atu. Antu gafuna, palanandonaddino akwanda sikwayu e awangkappenad balawanda sikwayu. ");
INSERT INTO gdg_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Mappalangkayu nad, se doꞌmandakayu anna idarundakayu, e siwaꞌwattandakayu sino sinagogarera. ");
INSERT INTO gdg_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Gafu sino angnguruddaw sikwak, medarungkayu kappay sino gubernadorira anda sino ariyera, e antuneno wayayuwa mipakaammu sino nalawara damag sikwara anda sino iturayandera a bakkanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Nu imbistigarandakayu, ammeyu paddararananino isombaꞌdaw annino sapitandaw, se sinoyna a orat, mepakaammu sikwayuweno fustuwa sapitandaw. ");
INSERT INTO gdg_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Se bakkanna ikkayuweno paggabwatanna, nu amme lud ipadandammino Espirituwi Dios a Amayu ino sapitandaw. ");
INSERT INTO gdg_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Sinoyna a tiyempo, ananeno midarumira si kolaꞌda sino tatturayira ta papatayanda. Kunna kappayino akwanneno mapparanakira sino abbinda. Inona kappay aanakira, kontarandeno mapparanaꞌdera ta ipapapaterera. ");
INSERT INTO gdg_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Amminna a tolay, kababannaddakayu gafu sino kesapatandaw sikwak. Udde nu mattalaginaggayuwa mangurug kiyad si madaꞌngeno uddina, mesalakkayu. ");
INSERT INTO gdg_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Nu ilopalopeꞌdakayu si tata a lubbun, mabbukalkayuwa umang si korwan. Gakkurug yo sapitangku sikwayu, nanu muliyaka Abbingnga Tolay, ammeyu kepay binalinino nepangwak sikwayuwa umang manuldu sino ammina lulubbunna Israel. ");
INSERT INTO gdg_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Awana madala napatig amma sino mesturuna. Awangkappaya aripanna naturay amma sino amungnga. ");
INSERT INTO gdg_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kunnantu, maanggammaddino madal nu mekunneno lawumanna sino mesturuna, e kunna kappay sino aripan, nu mekunna sino amungnga. Ikkanakino afuyu, e gafu se ilopalopeꞌdakino tolayira a massapit si ikkanaki Beelzebub a afafuna narakkattira a espiritu, kumaralla narakkattingkeneno sapitanda mappeafu sikwayuwa kataabbalayangku.” ");
INSERT INTO gdg_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Antu gafuna, ammekayu mattalaw si tolay, se ammina neyimad anna ammena naammuwan sito ingkein, mepaita anna maammuwanna so maddagguna aw. ");
INSERT INTO gdg_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ino sapitangku sikwayuwa ikkayu pelang, ipakaammuyu nad si ammina tolay. Ino sapitangku sikwayuwa awana korwana makadingngag, ikokwayu nadda sapitan ta dingngaggan ammina tolay. ");
INSERT INTO gdg_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Ammekayu nad mattalaw sino tolayira a manggamma mamapatay sikwayu, nu ammekayu lud mattalaw ki Dios. Se ino tolayira, damara a mamapatay si baggi, udde ammera dama a papatayannino kararuwa, udde i Dios, damana a mangastigu si baggi anna kararuwa sey infiyernu. ");
INSERT INTO gdg_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Udde dandammandonaggappayino aggangwa i Dios a Amayu sino dinattira. Damayu pelanga gatangannino adwaggiya dinnat si sentabo. Udde awana massiki tata sikwara a matay anna madaꞌnag nu ammena purayan. ");
INSERT INTO gdg_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Mannanotinna sikwayuwa tolay. Se massiki ino abuꞌdaw, ammuneno bilangnga. ");
INSERT INTO gdg_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Antu gafuna, ammekayu nad mattalaw, se ipatingngeno kadda tata sikwayu amma sino dinnattira.” ");
INSERT INTO gdg_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Massiki sanna a tolaya massapit sino aꞌlangino tolayira si mangurug sikwak, antu kappayino itaꞌdaggu sino aꞌlangi Ama sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Udde ino tolaya miyimad si mangurug sikwak sino aꞌlangino tolayira, kunna kappayino sapitangku sino aꞌlangi Ama sey langit.” ");
INSERT INTO gdg_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Sinapikkappayi Jesus si, “Ammeyu nad nganan si ino inangngangku sito lubag ino mappaibbat si pakkakontaranino tolayira. Se ino kakuruwanna, antuweno dumaggattanneno pattatarukkiyanda anna pakkakaratwayanda. ");
INSERT INTO gdg_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Gafu se ammera ammina mangurug sikwak, makkakontaraneno matatamera andino masasinera, e massiki ino makkatuwanganira. ");
INSERT INTO gdg_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Inona kalingeno tolay, maggabwatira sino kataabbalayannangkepay. ");
INSERT INTO gdg_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Massiki sanna a tolaya dodokkallino agganggamma sino mapparanaꞌngera amma sino agganggamma sikwak, ammena meannunga mebilang si adalangku. Kunna kappayino tolaya dodokkallino agganggamma sino abbingngera amma sino agganggamma sikwak, ammena kappay meannunga mebilang si adalangku. ");
INSERT INTO gdg_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","E massiki sanna kappaya tolaya ammena makattamma madyatan anna matay gafu sino angngurungnga sikwak, ammena kappay meannunga mebilang si adalangku. ");
INSERT INTO gdg_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Se ino tolaya mikalow sino biyangnga, matekappena. Udde ino tolaya matay gafu sino angngurungnga sikwak, ananeno biyaya mannayuna iyaꞌda i Dios sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Massiki sanna a tolaya mangawat sikwayu, ikkanakino inawaꞌna, e ino mangawat sikwak, inawaꞌna kappayino nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Nu wara mappadilot sino manuldu sino sapiti Dios gafu se ibilangnga si pannakabaggiyi Dios, parefuneno appanna a labut sino labuta appannino manuldu. Ino kappay mappadilot sino naggaddangnga tolay gafu se ibilangnga si tolayi Dios, parefuneno appanna a labut sino labuta appannino naggaddangnga tolay. ");
INSERT INTO gdg_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","E massiki ino mappainum si tatasa a danum sino kaabbafawana adalangku gafu se adalangku, sapitangku si gakkuruwingke a malabutan.” ");
INSERT INTO gdg_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Wasin nasinduwi Jesus a nattun sino karadwera a adalanna, inanaw sinay e inang nanuldu anna nangibanyag sino weweꞌnginna lulubbun. ");
INSERT INTO gdg_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","I Juan a Gumabawtisar, aggabaluggepay sinoya tiyempo. Wasin diningngangngeno inangangwa i Kristo, dinundunneno korwanira a adalanna ");
INSERT INTO gdg_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ta umanda bebutan ki Jesus si, “Ikkeno nekariyi Dios a gumamwang onnu wara kepay korwan si taronantam?” ");
INSERT INTO gdg_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Sinombati Jesus si, “Mulikayu ki Juan ta umandaw sapitan sikwaneno inita anna diningngaddaw, ");
INSERT INTO gdg_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","ino lappat, makaitera, ino pilay, makalakarira, ino nakkutal, nabbattunoyira, ino bangngag, makadingngaggira, ino natay, nangngangoliyera, e ino nalawara damag, mebanyag sino mekakallakkira. ");
INSERT INTO gdg_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Itulduyu kappay sikwana si nagasatino tolaya awana daladudwana mappeafu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Wasin manawinnino adalanira i Juan, agyanino sinapiti Jesus sino tolayira sinay mappeafu ki Juan. Kunna si, “Sin inangngandaw sino agyanani Juan sey kalolowat, sanneno ginakkaddawa inita? Tata kadda tolaya kunnangke sikalla ipapallelenna bayabbag? ");
INSERT INTO gdg_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Nu bakkan, sanna mantuweno inandaw inita? Tata kadda tolaya nalawaringke ino barawasina? Bakkan, se ino mabbarawasiyera si kunnenay, ino balena ariyeno agyananda. ");
INSERT INTO gdg_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Sanna mat antuweno gakkuruwa inandaw inita? Tata kadda gumalabbun? On, gakkurug, tata a gumalabbun, udde ino kakuruwanna, nangatu amma si gumalabbun. ");
INSERT INTO gdg_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Se i Juanino sapitannino neturakka sapiti Dios a kunna si, ‘Ananeno dundunangkuwa maunta sikwama midadan sino pallakarannu.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Netuluyi Jesus a nassapit si, “Gakkurug yo sapitangku sikwayu, awana tolaya neyanak sito lubagga nangatu amma ki Juan, udde massiki nu kunnenoy, ino kaabbafawana tolaya mesapat sino patturayani Dios, nangatu amma sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Mangiyafu sino nanulduwani Juan kiyad sito ingkein, anera a mipatuta mangibanyag mappeafu sino patturayani Dios, e anera kappaya mipatuta mesapat sinaya patturayanna. ");
INSERT INTO gdg_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Se ino neturakkino gumalabbunira andino lintiyi Moises, nelabbunira ammin mappeafu sino patturayani Dios, kase ginamwangi Juan e neyafuwa neyakkuruwino nelabbunda. ");
INSERT INTO gdg_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","E nu anggandawa kuruwannino sinapitino tata sikwara, maawatandaw si i Juan, antuwi Elias a nelabbunna a muli. ");
INSERT INTO gdg_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ikkayuwa maningngag, dandammandonaddino diningngaddaw.” ");
INSERT INTO gdg_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Sinapikkappayi Jesus si, “Sannadeno kekunnanino tolayira sito ingkein? Mekunnera si abbinga aggatuttud sino aꞌlangino allakuwana ayanino bulundera a makkarayam. Kunnino bulundera si, ");
INSERT INTO gdg_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Massiki sanneno akwammi, ammekayu medagga. Nanontakkami, udde ammekayu nanalip. Nababbinungakami, udde ammekayu nattangit.’ ");
INSERT INTO gdg_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ireno kekunnandaw, se awaningke a anggandawa dingngaggan. Se i Juan, nallantanga mangngan anna ammena ninum, e sinapiꞌdaw si, ‘Naunaggan si narakkatta espiritu.’ ");
INSERT INTO gdg_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","E ikkanaka Abbingnga Tolay, nakikkan anna nakiinumak sikwayu, e sinapiꞌdaw si, ‘Itandaw inaya tolay! Malawot anna minabbobok anna mebumbulun sino gumattukiyera si buwit andino korwanira a minalliwat!’ Udde massiki nu kunnenoyino sapitandaw, maita si gakkuruwa naggabwat ki Diosino tuldumi anni Juan gafu sino salinunuꞌna sino biyayino manguruwira.” ");
INSERT INTO gdg_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Wasinoy, nebuya i Jesusino tolayira a nagyan sino lulubbuna nangwanna si oodduwa kakkaꞌbaw, se ammera nabboboli sino liwaꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Sinapiꞌna si, “Kakallakkayuna a taga-Corazin anna taga-Betsaida! Se oodduweno kakkaꞌbawa inangwak sino lubbundaw, udde ammekayu nabboboli sino liwaꞌdaw. Nannud sey Tiro anna sey Sidonino nangwangku sinayira a kakkaꞌbaw, nabayiran nadda nabbarawasi si nakarumisanga sinnun anna nabburayit si lallang sino ulura a mangipaita si nabboboliyera. ");
INSERT INTO gdg_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Sapitangku sikwayu si nalamponeno kastiguweno taga-Tirowera andino taga-Sidonira amma sikwayu naso awa pangukumani Dios sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ikkayu kappaya taga-Capernaum, ariddonakuy si meyantokayu kiyad sey langit. Gampade madyadyatangkayuna a kunnangke metakkuggayu sey infiyernu. Se oodduweno kakkaꞌbawa inangwak sino lubbundaw, udde ammekayu nabboboli sino liwaꞌdaw. Nannud sey Sodomeno nangwangku sinayira a kakkaꞌbaw, nabboboliyeran nad, e agyangkepenaddino lubbunda sito ingkein. ");
INSERT INTO gdg_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Sapitangku sikwayu si nalamponeno kastiguweno taga-Sodomera amma sikwayu naso awa pangukumani Dios sino tolayira.” ");
INSERT INTO gdg_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Sinoya tiyempo, nakkarari Jesus a nassapit si, “Ama, ikka a Afu sey langit anna sito lubag, mappasalamatak sikwam, se ino kakuruwan mappeafu sikwaka ammem nepakaammu sino nalaingira anna diyadalira a tolay, antuweno nepakaammum sino awana adalda. ");
INSERT INTO gdg_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Mappasalamatak sikwam, Ama, sinaya nakwa, se antuweno panggammannu.” ");
INSERT INTO gdg_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wasinoy, sinapiti Jesus sino tolayira si, “Ikkanakino nitalakkani Ama si amammin. Awana makaammu sikwak nu bakkanni Ama, e awangkappaya makaammu ki Ama nu bakkannappelanga Abbingnga andino tolayira a pilingkuwa pangipakaammuwan. ");
INSERT INTO gdg_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ikkayu ammina naayang anna madyatan, umangkayu sikwak ta pimwangantakayu. ");
INSERT INTO gdg_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Tuntulandawino sapitangku anna mappatuldukayu sikwak ta massiyanakkino nakandaw, se nannakammak anna ammek iyantawino baggik. ");
INSERT INTO gdg_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Ammekayu madyatana mangwa sino ipaangwak sikwayu se ammetakayu padyatan.” ");
INSERT INTO gdg_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Wasin tata a Sabadu a aggimwanganino Judyuwera, nallakadda Jesus sino aggumana namulan si trigo. Nabisinanino adalannera, antuweno nangappera sino dawana trigo e binulaꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Udde nagyanino Fariseowera a nangita sino inangwara e sinapiꞌda ki Jesus si, “Itannuweno akwanino adalannuwera, kontarandeno lintiddama kammarallino maggani sino awna aggimwangan.” ");
INSERT INTO gdg_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Sinabbira i Jesus si, “Ammeyu kad binaseno inangwa i Ari David andino bafulunnera sin nabisinanira? ");
INSERT INTO gdg_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Sinallungi David sino balayi Dios e inappaneno tinapaya newaꞌlat ki Dios a kunnino lintig si ino pelang padiyeno mangngan sinay. Udde nakkanna kepay anna nangngangkappayino bafulunnera. ");
INSERT INTO gdg_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Dandammandonaggappayino neturak sino lintiyi Moises a kunna si ino padiyera a mattarabafu sino Templo sino awna aggimwangan, kontarandeno lintig, udde bakkanna liwaꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Sapitangku sikwayu si sito ingkein, ana sitawino napatig amma sino Templo. ");
INSERT INTO gdg_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Aneno nepeturakki Dios a kunna si, ‘Aanggangkuweno aggikallaꞌdaw sino bafulundawira amma sino iwaꞌlaꞌdaw sikwak.’ Nannud naawatandawino anggamma sapitan inay, ammeyu nad nepaliwatino awana liwaꞌna. ");
INSERT INTO gdg_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Se ikkanaka Abbingnga Tolayino ana kalintiyanna a massapit sino damana a maangwa sino awna aggimwangan.” ");
INSERT INTO gdg_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Wasin inanawi Jesus sinay, inang sino tata a sinagoga. ");
INSERT INTO gdg_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Agyan sinayino lalakiya pilayino tata a kamaꞌna. Agyangkappayino tolayira a manggam si wara pidarumanda ki Jesus, antuweno nassapitanda si, “Damana kad sino lintiddama mappabattunoy si matakit sino awna aggimwangan?” ");
INSERT INTO gdg_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Sinombati Jesus a nassapit si, “Nu wara sikwayuwa madaꞌnino karnerona si bitu sino awna aggimwangan, ammena kad umang appan? ");
INSERT INTO gdg_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Nabalorino tolay amma sino karnero, antu gafuna, damana sino lintiddama manuffun sino bafuluntamira sino awna aggimwangan.” ");
INSERT INTO gdg_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","E sinapiꞌna sino lalakiya pilayino kamaꞌna si, “Soꞌyarannu yan kamaꞌnu.” Sinoꞌyanna e nappiyen a kunneno tafika kamaꞌna. ");
INSERT INTO gdg_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Udde inanawino Fariseowera ta umanda pattatarabban nu ansandeno mamapatay ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Ammuwi Jesusino gakkadda, antuweno inanaw sinay. Odduweno tolayira a dinandan sikwana, e nepabbattunoyneno amminira a matakit. ");
INSERT INTO gdg_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Udde sinunnera si ammera sapasapitannino mappeafu sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Inangwanenay takesi meyakkuruwino nepeturakki Dios ki Isaias a kunna si, ");
INSERT INTO gdg_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Antuyawino aripangkuwa pinilik. Antuweno iiddukangku anna mappaanggam sikwak. Dundunangkuweno Espirituk a magyan sikwana takesi ipakaammuneno kinagaddangku sino bakkannira a Judyu si palulubbun. ");
INSERT INTO gdg_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Ammena makisosombat anna ammena ikokweno damiꞌna. Ammena kappay ikokweno sapitanna sino padaladalan. ");
INSERT INTO gdg_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Ammena gaꞌbungannino napattuta sikal anna ammena addappannino gaaaddappa lampara, anggamma sapitan, ammena purayanino tolaya nadismaya onnu talekkuranino tolaya nakafuyino angngurungnga, nu ammena lud duffunan. Akwanna ammin inay kiyad si meyakkuruwino naggaddangnga urek. ");
INSERT INTO gdg_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","E antuweno innanaman ammina tolay si kesalakanda.” ");
INSERT INTO gdg_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Wasin namitta, agyanino niyangngira ki Jesus si lalakiya lappat anna ammena makadamit se naunaggan si narakkatta espiritu. Nepaanawi Jesusino narakkatta espiritu, e makaiten anna makadamitinnino lalaki. ");
INSERT INTO gdg_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Nakkaꞌbawino tolayira, e sinapiꞌda si, “Antuwen nakuy yawino gaka i Ari David a aggataronantam?” ");
INSERT INTO gdg_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Udde wasin diningngaggino Fariseowera, sinapiꞌda si, “Bakkangkena! Ino pannakadamana a mappaanaw sino narakkattira a espiritu, awana korwan si nangaꞌda sikwana nu bakkanni Beelzebub a afafuna narakkattira a espiritu.” ");
INSERT INTO gdg_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Udde ammuwi Jesusino ana sino nakanda, antuweno nassapitanna sikwara si, “Nu maggagarunutino tolayira sino tata a lubbun, madaralnenaya lubbun. Kunna kappay sino taabbalayira onnu talubbunira, nu massasarombatira, makkakaratwayira. ");
INSERT INTO gdg_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Kunna kappay ki Satanas. Nu paanawanneno bafulunnera a narakkatta espiritu, kontaranneno bagginangkepay, e gakkuruwa madarallino patturayanna. ");
INSERT INTO gdg_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Kundaw si i Beelzebub ino nangaꞌda sino pannakadamaka mappaanaw si narakkatta espiritu. Nu gakkuruwinay, ino adalandawira a mappaanokappay si narakkatta espiritu, inya mantuweno naggabwatanino pannakadamara? Ira kappayino mipakurug si nabbakabakkannino sapitandaw. ");
INSERT INTO gdg_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Se ino kakuruwanna, ino Espirituwi Diosino nangaꞌda sino pannakadamaka mappaanaw si narakkatta espiritu, e antuweno pangammuwandaw si anen sikwayuweno patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Awana makatallung sino balayino natuyagga tolay ta takawanneno kukwana nu ammena abbu baluran, kasena dama a ibukalino kukwana. Gakkuruwa natuyaggi Satanas, udde inaffukkun, e antuweno damaka paanawannino narakkatta espiritu. ");
INSERT INTO gdg_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ino ammena mebulun sikwak, ireno kumontara sikwak, e ino ammena manuffuna mampat sino tolayira sikwak, ireno mappakakaratway. ");
INSERT INTO gdg_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Kunnantu, sapitangku sikwayu si massiki sanna a liwatino tolay anna massiki sanna a sapitanda a narakkat mappeafu si korwan, dama i Dios a pakoman, fera pelang sino massapit si narakkat mappeafu sino Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Massiki ino massapit si narakkat mappeafu sikwaka Abbingnga Tolay, dama a mapakoman inay, udde ino massapit si narakkat mappeafu sino Espirituwi Dios, ammena dama a mapakoman inaya liwaꞌna si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Sinapikkappayi Jesus a niyamparig si, “Pakkunnandonaddino angngitayu sino kayu andino bungana. Nu ibilandaw si nalawarino tata a kayu, nalawannaggappayino bungana sino angngitayu. Nu ibilandokappay si narakkattino tata a kayu, narakkaꞌnaggappayino bungana sino angngitayu. Se ino bunganeno kaimunuwanino kayu. ");
INSERT INTO gdg_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ikkayuwa massalasangkun, ansanandawino massapit si nalawad a narakkakkayuwa tolay? Se ino sapitanna tolay, maggabwappelang sino nakamma. ");
INSERT INTO gdg_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ino nalawara tolay, nalawarino sapitanna, se nalawallurino ana sino nakamma. Udde ino narakkatta tolay, narakkakkappayino sapitanna, se narakkattino ana sino nakamma. ");
INSERT INTO gdg_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Dandammandaw yawa sapitangku sikwayu. Naso awa pangukumani Dios sino tolayira, irangkepeneno manombat sino ammina sinapiꞌda a awana serbina. ");
INSERT INTO gdg_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Se ino sapitannino kadda tata sikwayu, antuneno usaranni Dios a mangukum sikwayu, e iraneno mangipaita si nalliwakkayu onnu awan.” ");
INSERT INTO gdg_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Wasinoy, sinapitino korwanira a mammesturuwerana lintig andino Fariseowera si, “Afu mesturu, mangipaitaka nad si kakkaꞌbawa senyal ta pangammuwammi si naggabwat ki Diosino pannakadamam.” ");
INSERT INTO gdg_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Udde nesombati Jesus si, “Narakkattingke ino tolayira sito ingkein se sinalekkurandeno gakkuruwa Dios. Patutandaka mipaita si kakkaꞌbawa senyal, udde awana mepaitak nu bakkampelangino senyal a kunneno nakwa ki Jonas a gumalabbun siꞌin. ");
INSERT INTO gdg_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Se i Jonas, nagyan sino kuyungngeno dokalla lamis si tallu aw anna tallu gafi, e kunna kappay sikwaka Abbingnga Tolay, magyanak kappay sino tanangku si tallu aw anna tallu gafi. ");
INSERT INTO gdg_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Nu madaꞌnganeno awa pangukumani Dios sino tolayira, paliwatandakayuneno taga-Nineveyira, se nebobolireno liwaꞌda sin diningngaddeno tulduwi Jonas, udde ikkayu, massiki anen sikwayuweno napatig amma ki Jonas, ammekayu kepay mangurug. ");
INSERT INTO gdg_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ino kappay bafaya ari sey Seba siꞌin, paliwatandakayuna kappay sinaya aw, se naggabwat si aroyuwengke a lubbuna inang naningngag sino kinalainga netulduwi Ari Solomon. Udde ikkayu, massiki anen sikwayuweno napatig amma ki Solomon, ammeyu anggamma dingngaggannino tulduna.” ");
INSERT INTO gdg_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Netuluyi Jesus a niyamparig si, “Nu manawino narakkatta espirituwa nunag si tolay, umang mannodoyug sino kalolowata awana danumma a mintufuk si pimwanganna. E nu awana sumpalanna, ");
INSERT INTO gdg_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","kunna sino nakamma si, ‘Muliyak sino balaya naggabwatangku.’ Muli, e madaꞌnganeno balaya awangkepay nepatali sikwana e nadalusan anna nalawad amma siꞌin. ");
INSERT INTO gdg_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","E umang mayag si pituwa espirituwa narakkat amma sikwana takesi makiagyanira sikwana. Kakallakkingke inaya tolay amma sino palunguwa katolena. Kunna kappeneno makwa sino narakkattira a tolay sito ingkein.” ");
INSERT INTO gdg_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Wasin aggedamadamikkepayi Jesus sino tolayira, ginamwangino inana andino kakkolaꞌngera sino balaya agyananna, e sinaronanda sino lawan se angganda a tatabban. ");
INSERT INTO gdg_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Agyanino nassapit sikwana si, “Anara inam andino kakkolaꞌnguwera sino lawan, e ana kanuweno angganda a sapitan sikwam.” ");
INSERT INTO gdg_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Sinapiti Jesus si, “On lud, udde ana kappayino korwanira a ibilangku si inak anda kakkolakku.” ");
INSERT INTO gdg_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","E netuldaꞌngeno adalannera e sinapiꞌna si, “Ira yanino inak andino kakkolakkuwera, ");
INSERT INTO gdg_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","se ino mangwa sino panggammani Ama sey langit, ireno ibilangku si inak anda kakkolakku.” ");
INSERT INTO gdg_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Sinoya aw, nanawi Jesus sino balay e inang sino dappiꞌna bebay. ");
INSERT INTO gdg_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Gafu se odduweno tolaya inaribumbung sikwana, inang nattuttud si abang sino utunna danum e nagyanino tolayira sino gaꞌdang. ");
INSERT INTO gdg_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Odduweno netulduna sikwara si amparig. Sinapiꞌna sikwara si, “Aneno tolaya inang nawwarit si aggik. ");
INSERT INTO gdg_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Wasin aggewarawarit, naddattuweno korwana aggik sino dammingnga dalan, e inaꞌnamino mammanukira. ");
INSERT INTO gdg_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ino korwana newariꞌna, naddattu sino kabatuwana bisangkeno lubangnga. Gafu se naimpitino lubangnga, nalanira a nattufu. ");
INSERT INTO gdg_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Udde wasin nasinaniran, nalelayira, se awana naggamutanda. ");
INSERT INTO gdg_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Ino korwangkappay, naddattu sino kasasitan, e neyindanino asita nattufu e ilintuꞌdanino mula. ");
INSERT INTO gdg_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Udde ino korwana newariꞌna, naddattuwera si nalawara lubag, nattufuwera e nammungeran. Aneno nammunga si tatut, ana kappayino nammunga si annammafulu, e ana kappayino nammunga si tallufulu.” ");
INSERT INTO gdg_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","E inabambutani Jesus a sinapit si, “Ikkayuwa maningngag sitawa ampariggu, dandammandonaddino diningngaddaw.” ");
INSERT INTO gdg_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wasinoy, inaraꞌniyeno adalanira i Jesus sikwana, e nebebuꞌda si, “Mayan passibbelanga ampariyino usarannuwa manuldu sino tolayira?” ");
INSERT INTO gdg_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Sinombati Jesus si, “Ipakaammuwi Dios sikwayuweno ammena nepakaammu siꞌin mappeafu sino patturayanna, udde ammena nepakaammu sino korwanira a tolay. ");
INSERT INTO gdg_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Se ino tolaya manggamma mangwa sino diningngangnga, madadaggananneno angngawaꞌna, udde ino tolaya ammena mangwa sino diningngangnga, massiki ino bissangnga ammuna, maawanna. ");
INSERT INTO gdg_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Antu gafuna, ampariyino usarangkuwa manuldu sikwara, se massiki nu aggitanda, ammera maimunuwan, anna massiki nu dingngagganda, ammera maawatan. ");
INSERT INTO gdg_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Ireno keyakkuruwanino nepeturakki Dios ki Isaias a gumalabbuna kunna si, ‘Massiki nu aggadingngagganda, ammera maawatan. E massiki nu aggitanda, ammera maimunuwan. ");
INSERT INTO gdg_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Se nataggatinnino ulura. Ammutandeno layadda anna makkiꞌdammira. Se nu ammera kunninoy, tantaro nu makaitera, makadingngaggira, anna makaawatira, e muliyera sikwak ta pabbattunoyangkuwera.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Netuluyi Jesus a nassapit si, “Udde ikkayu, nagasakkayu se makaita anna makadingngaggayu. ");
INSERT INTO gdg_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Gakkurug yo sapitangku sikwayu, odduwenin gumalabbunira anna naggaddangngira a tolaya nanggamma mita sino initayu, udde ammera naita, e angganda kappaya dingngaggannino diningngaddaw, udde ammera nadingngag. ");
INSERT INTO gdg_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Dingngaggandawino anggamma sapitannino amparig mappeafu sino inang nawwarit si aggik. ");
INSERT INTO gdg_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Ino bukalla naddattu sino dalan, antuweno ampariyino tolayira a maningngag sino tuldu mappeafu sino patturayani Dios udde ammera maawatan, kase gumamwangi Ofag e ariyanna sino nakandeno diningngadda. ");
INSERT INTO gdg_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ino naddattu sino kabatuwan, ireno tolaya manggamma mangurug sino diningngadda a tuldu. ");
INSERT INTO gdg_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Udde ammena sumallung sino nakandeno sapit, antu gafuna, nu wara gumamwang si dyaꞌda onnu nu madyatanira gafu sino angngurudda sinaya sapit, talekkurandeno angngurudda. ");
INSERT INTO gdg_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ino kappay bukalla naddattu sino kasasitan, ireno tolaya maningngag sino sapiti Dios, udde nakungkulino nakanda gafu sino paddararananda sino maawadda sino biyadda andino bumaꞌnangnganda, e antuweno mabbung sino sapita diningngadda, e awana ketupakkanna. ");
INSERT INTO gdg_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ino kappay naddattu sino nalawara lubag, ireno tolaya maningngag sino sapiti Dios e maawatanda, e aneno pattupakkanna sino biyadda. Mekunnera sino mula a mammunga si tatut, annammafulu, onnu tallufulu.” ");
INSERT INTO gdg_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Wasinoy, niyampariggappayi Jesus a nassapit si, “Ino makwa sino patturayani Dios, kunnangke ino makwa sino tolaya nawwarit si nalawara bukal sino umana. ");
INSERT INTO gdg_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Wasin tata si gafiya aggakaturuwira, inangngino kalingana a nawwarit si bukalla kaddat sino uma a namulan sino nalawara bukal. ");
INSERT INTO gdg_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dinarokallira kiyad si nammungera, kasena naimunuwan si wara kaddat. ");
INSERT INTO gdg_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Inangngino aripannino makwan uma sikwana e sinapiꞌda si, ‘Afu, ammena kad nalawarino bukalla newariꞌnu sino umam? Sintawino naggabwatanino kaddat?’ ");
INSERT INTO gdg_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“ ‘Aneno kalingaka nangwa sinay,’ sinapitino makwan uma. “ ‘Anggammu ta umammiya fiꞌdutannino kaddat?’ kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“ ‘Ammeyu, se tafiꞌduꞌdonalangino apay,’ sinapiꞌna sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","‘Purayandaw ta dumarokkallira kiyad sino kaganiyanna. Itulduꞌnga sino magganiyera ta palungunda a fiꞌdutannino kaddat e rappattanda ta sikkulanda, kasera ganinino apay e umanda iyekwa sino alangku.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Wasinoy, niyampariggappayi Jesus a nassapit si, “Ino patturayani Dios, meyamparig si tata a bukalla mustasa a nemuleno tolay sino umana. ");
INSERT INTO gdg_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Antuweno kabibissangngana bukal sino ammina bukal, udde nu mattufu e dumokallin, antuweno kadodokkallana mula sino gardin a kunnangke kallakayuweno kataꞌnangnga, e damana mammanuka pumukanino tangatangana.” ");
INSERT INTO gdg_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Wasinoy, niyampariggappayi Jesus si, “Ino patturayani Dios, meyamparig si lebadura a ilamurino bafay si odduwa arina, e massiki bisangke, palattagganna amminino arina a kelamuranna.” ");
INSERT INTO gdg_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Passiya ampariyino inusari Jesus sino nanulduwanna sino tolayira. Awana sinapiꞌna sikwara nu ammena nusar si amparig. ");
INSERT INTO gdg_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Antuweno inangwana sino nanulduwanna sikwara ta meyakkuruwino nepasapiti Dios sino gumalabbunna siꞌina kunna si, “Amparingngeno usarangkuwa manuldu sikwara. Itulduꞌnga sikwareno ammena nepakaammu nangiyafu sin naparatuwan yo lubag.” ");
INSERT INTO gdg_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Wasinoy, inanawani Jesusino tolayira e sinallung sino balay. Dinandanino adalannera e sinapiꞌda si, “Ituldum sikwamiyeno anggamma sapitannino amparig mappeafu sino kaddatta nattufu sino uma.” ");
INSERT INTO gdg_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Sinapiti Jesus si, “Ino nawwarit sino nalawara bukal, ikkanaka Abbingnga Tolay, ");
INSERT INTO gdg_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","e ino uma, antu yo lubag. Ino nalawara bukal, ireno tolaya mesapat sino patturayani Dios, e ino kaddat, ireno tolayi Ofag. ");
INSERT INTO gdg_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ino kalingaka nawwarit sino bukalla kaddat, antuwi Ofag. Ino pagganiyan, antuweno uddina aw, e ino nagganiyera, ino anghelira. ");
INSERT INTO gdg_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ino narrappattanda sino kaddat ta masikkulan, kunna kappeneno makwa sino uddina aw, ");
INSERT INTO gdg_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","se ikkanaka Abbingnga Tolay, dundunangkuneno anghelkuwera ta ampattanda anna ariyandeno ammina tolaya mangwa si palliwatanino bafulundera andino mangwera si narakkat. ");
INSERT INTO gdg_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Itakkudderana sino afuya ammena maaddap, e mattatarangitirana anna mangngarangaritammirana. ");
INSERT INTO gdg_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Udde ino naggaddangngira a tolayi Dios, mangngilikilitirana sino patturayanino Amara a kunnangke sinag. Ikkayuwa maningngag sitaw, dandammandonaddino diningngaddaw.” ");
INSERT INTO gdg_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Netuluyi Jesus a niyamparig si, “Ino patturayani Dios, meyamparig si kinabaꞌnangnga nekokkob si uma. Sinumpalanino tata a tolay, e maanggammingke. Sinabbunanna kappay, e inangnga nelaku amminino kukwana ta iyatangnga sinaya lubag.” ");
INSERT INTO gdg_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Sinapikkappayi Jesus si, “Ino tata kappaya ampariyino patturayani Dios, kakunnaneno gumallakuwa mintufuk si kalalawarana perlas. ");
INSERT INTO gdg_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wasin initaneno tata a nabaloringke, inanaw e nelakuna amminino kukwana ta wara iyatangnga sinaya perlas.” ");
INSERT INTO gdg_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","48","Netuluyi Jesus a nassapit si, “Ino patturayani Dios, meyampariggappay si tafukula itakkufino manafukulira sino bebay e makanna amminino naddadaruma a lamis. Wasin napannuwen, nelabbedda sino dappit e nattutturira a mamimpili sino kinannara. Ino nalawara mesira, neyekwara sino aggekwanda, udde ino narakkattira, netakkudda. ");
INSERT INTO gdg_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Kunna kappeneno makwa sino uddina aw. Gumamwangino anghelira a umang mipassig sino narakkattira a tolay sino naggaddangngira. ");
INSERT INTO gdg_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Itakkuddaneno narakkattira sino afuya ammena maaddap, e mattatarangitirana anna mangngarangaritammirana. ");
INSERT INTO gdg_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Maawatandaw ammin inay?” kunni Jesus sikwara. “On,” kunnino adalannera. ");
INSERT INTO gdg_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","E sinapikkappayi Jesus si, “Nu kunnenoy, maawatandonaggappay si ino mesturuna lintiyi Moises a manguruggappay sino itulduk mappeafu sino patturayani Dios, mekunna si makwan balaya ammuna a usarannino dadan annino bawuwa neyimfunna.” ");
INSERT INTO gdg_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Wasin nasinduwi Jesus a nituldu sinayira a amparig, inanaw sinaya lubbun, ");
INSERT INTO gdg_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","e nuli sino lubbuna dinokallanna. Inang nanuldu sino sinagogara, e nakkaꞌbawino naningngaggira sikwana. E sinapiꞌda si, “Sintawino nangappanna sinaya kinalaingnga annino pannakadamana a mangwa si kakkaꞌbaw? ");
INSERT INTO gdg_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Bakkangkad yanino abbingino kalapanteru? Bakkangkaddi Maria ino inana, e da Santiago, Jose, Simon, anni Judasino kakkolaꞌngera? ");
INSERT INTO gdg_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Amme kappekad magyanino kakkolaꞌngera a bafabbay sitaw? Sintomantuweno nappanna ammin sinaya kinalaingnga anna pannakadamana?” ");
INSERT INTO gdg_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Antuweno ammera anggamma maningngag sikwana e ammera kuruwan. Antu gafuna, sinapiti Jesus sikwara si, “Massiki sintawa lubbuna umangnganino gumalabbun, dayawannino tolayira, fera pelang sino kalubbunannera andino kataabbalayannera.” ");
INSERT INTO gdg_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Gafu se awana angngurudda sikwana, awana oddu si kakkaꞌbawa inangwana sinay. ");
INSERT INTO gdg_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Sinoya tiyempo, naammuwani Herodes a turay sey Galilea ino inangangwa i Jesus, ");
INSERT INTO gdg_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","e sinapiꞌna sino kaduffunannera si, “Antuwi Juan a Gumabawtisar a nangngangoli. Antu gafuna, aneno pannakadamana a mangwa si kakkaꞌbaw.” ");
INSERT INTO gdg_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Antuwenayino sinapiti Herodes gafu sino nakwa siꞌin. Se nepadoꞌmana i Juan e nepabalunna a nakadenan, gafu sino nallangngani Juan sikwana. Se i Herodes, inatawaneno ipangnga a i Herodias a ataweno kolaꞌnga a i Felipe. E namipidya a sinapiti Juan sikwana si mekontara sino lintig nu atawanteno ataweno kolatta. ");
INSERT INTO gdg_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Antuweno anggammi Herodes a papapatayi Juan, udde nattalaw sino tolayira, se ibilanda i Juan a gumalabbun. ");
INSERT INTO gdg_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Udde wasin nadaꞌngeno awa neyanakani Herodes, nassaleno balatanga abbingi Herodias sino aꞌlangino ammina inayanna a makilanggak. Nappelalotino langgaki Herodes sino nassalanna. ");
INSERT INTO gdg_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Antu gafuna, nassapata a nakkari sino balatang si iyaꞌdana sikwaneno massiki sanna a anggamma. ");
INSERT INTO gdg_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Wasinoy, sinuntulino balatangino netunino inana, e sinapiꞌna ki Herodes si, “Ino anggangku, iyaꞌdam sikwak sito ingkeinino uluwi Juan a Gumabawtisar a neyekwa si duyug.” ");
INSERT INTO gdg_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Malowino nakammi Ari Herodes sin diningngangngenay, udde gafu se nassapata sino aꞌlangino inayannera, sinapiꞌna si makweno arangngannino balatang, ");
INSERT INTO gdg_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","e nepafutulna i Juan sino abbaluran. ");
INSERT INTO gdg_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Neyekwareno uluna si duyug, e neyanda sino balatang, e neyaꞌdana sino inana. ");
INSERT INTO gdg_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wasin naammuwanino adalanira i Juanino nakwa sikwana, inanda inappeno baggina e netananda, kasera inang netuldu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Wasin naammuwani Jesusino nakwa, nanaw sinay e nattakay si abanga inang sino awana matotolay ta mittata sinay. Udde wasin naammuwanino tolayira sino lulubbuna inanaw, ginikkatira e nallakarira a dinandan sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Wasin ginaꞌdangi Jesus, initaneno odduwa tolay, e inallaꞌngera, e nepabbattunoyneno matakitira. ");
INSERT INTO gdg_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Wasin maffuwafin, inangngino adalannera sikwana, e sinapiꞌda si, “Fuwafin, gampade awana bafalay sitaw. Panawannuweno tolayira ta umangngira maggatang si akkananda sino kaaraꞌniyanira a lubbun.” ");
INSERT INTO gdg_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Sinapiti Jesus sikwara si, “Massiki ammeran umanaw. Ikkayunnino mamakkan sikwara.” ");
INSERT INTO gdg_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","E sinapiꞌda sikwana si, “Lima ke a tinapay anna adwaggiya tinapeno ana sitaw.” ");
INSERT INTO gdg_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","“Iyandaw taw,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Nepattuttunneno tolayira sino kakaddattan. E inappaneno lima a tinapay andino adwaggiya tinapa, kasena sinangaw sey langita mappasalamat ki Dios. Ginaradwaneno tinapay e neyaꞌdana sino adalannera e neyannera sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Nangnganira ammin e nabattuwira. Inampattino adalannereno nabuna a tinapaya ginaradwa i Jesus, e napannuweno karadwera a basket. ");
INSERT INTO gdg_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ino kaodduweno lallakiyera a nangngan, limarifuwera, fereno bafabbayira andino aanakira. ");
INSERT INTO gdg_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wasinoy, nepattakayi Jesusino adalannera sino abang ta mauntera nadda maddammang, e nataka mappaikkat sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Wasin nepaikkaꞌneran, nittata a nanuꞌdu sino kulud ta makkararag. Wasin lammukin, agyangkepay sinay, ");
INSERT INTO gdg_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","udde ino abanga nattakayanino adalannera, agyanin sino tangnganeno bebay. Mikiikiyino abang gafu sino palung se dambalandeno bayabbag. ");
INSERT INTO gdg_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Wasi marrifarifaddin, dinandananira i Jesus a nallakad sino utunna danum. ");
INSERT INTO gdg_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Udde wasin naiteno adalannera a mallakad sino utunna danum, nakatalawira. Nakkulawuwera gafu sino talora, se aridda si banig. ");
INSERT INTO gdg_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Udde nalani Jesus a naddamit sikwara e sinapiꞌna si, “Ammekayu mattalaw! Ikkanak yaw.” ");
INSERT INTO gdg_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wasinoy, sinapiti Pedro si, “Afu, nu gakkuruwa ikka yan, ayandak ta umangngak sitana mallakad sino utunna danum.” ");
INSERT INTO gdg_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Umangka taw,” kunni Jesus. Naddassi Pedro sino abang e nallakad sino utunna danuma inang ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Udde wasin initaneno palung gafu sino tuyangngeno bayabbag, nakatalaw e lumannaddin nad. Nakkulawuwa nassapit si, “Afu, isalakannak!” ");
INSERT INTO gdg_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Kinangkamani Jesus a ginafutino kamatti Pedro. “Mayan kurang kepayino annalaꞌngu sikwak? Mayan naddaladudwaka?” kunna sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Wasinoy, nattakayira sino abang, e ilammattino bayabbag. ");
INSERT INTO gdg_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Dinayawino nattakayira sino abangi Jesus, e sinapiꞌda si, “Gakkuruwa ikkeno Abbingi Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Wasin nakadammangiran, ginamwangira sey Genesaret, ");
INSERT INTO gdg_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","e naimunuwanino tolayira i Jesus. Nepaayaddeno matakitira sino ammina weweꞌnginna lulubbun ta iyandera sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Nakiggimallakkira si senggeran naddino matakitireno leleneno barawasina. E amminira a nanengged, nabbattunoyira. ");
INSERT INTO gdg_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Wasin tata si aw, agyanino Fariseowera andino mammesturuwerana lintiya naggabwat sey Jerusalem a inang ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","Nabbebutira sikwana si, “Mayan kontaranino adalannuwereno gagangaya inillalupattam sino gagginafutamira? Se mangnganira a ammera tuntulannino fustuwa ammaggu.” ");
INSERT INTO gdg_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Sinombati Jesus a nassapit si, “Massiki ikkayu, kontarandawino lintiyi Dios ta tuntulandawino gagangaya aggangwayu. ");
INSERT INTO gdg_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Se ino lintiyi Dios, kunna si ‘Dayawannura amam anni inam,’ anna ‘Nu wara massapit si narakkat sino amana onnu sino inana, mapapatenad.’ ");
INSERT INTO gdg_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Udde tangananino itulduyu. Se sapitandaw si nu wara iduffun naddino tolay sino amana onnu inana, massiki nu ammena iyaꞌda. Damana a irason sikwara a massapit si, ‘Ino iduffungku nad sikwayu, nekarikunna iwaꞌlat ki Dios.’ ");
INSERT INTO gdg_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","E sapitandaw si nu kunnenoyino akwanna, massiki nu ammena iyaꞌda sino mapparanaꞌngereno iyaꞌdana nad sikwara. Gafu sinaya aggangwayu, pataliyandawino sapiti Dios sino tulduyungkepay. ");
INSERT INTO gdg_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ikkayuwa massannakam! Gakkuruwino nepelabbuni Dios ki Isaias mappeafu sikwayuwa kunna si, ");
INSERT INTO gdg_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Iyawira a tolay, bifidda pelangino paddayora sikwak, udde aroyuweno nakanda sikwak. ");
INSERT INTO gdg_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Awana serbineno paddayawanda sikwak, se ituldureno lintiya inangwana tolay, e sapitanda si antuweno lintiggu.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wasinoy, neparaꞌniyi Jesusino odduwera a tolay e sinapiꞌna sikwara si, “Dingngaggandaw yaw takesi maawatandaw. ");
INSERT INTO gdg_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Bakkannino ipaunangnga tolay sino wangiꞌneno mappadakkut sikwana sino aꞌlangi Dios, nu ammena lurino narakkatta sapita maggabwat sino bifingnga.” ");
INSERT INTO gdg_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Inaraꞌniyeno adalannera sikwana e sinapiꞌda si, “Ammengkad inammu si malowino nakammino Fariseowera sino sinapiꞌnu?” ");
INSERT INTO gdg_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Sinombati Jesus a niyamparig si, “Ammina mula a amme nemula i Ama a ana sey langit, mafiꞌdutirana. ");
INSERT INTO gdg_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ammekayu maburuburung sikwara. Kakunnareno lappatta mifuyut sino kasillappaꞌda. E nu ifuyutino lappattino kasillappaꞌna, madaꞌnira a adwa sino dabbak.” ");
INSERT INTO gdg_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Wasinoy, sinapiti Pedro si, “Ituldum sikwamiyeno anggamma sapitannino sinapiꞌnu mappeafu sino mappadakkut si tolay sino aꞌlangi Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Sinapiti Jesus si, “Massiki ikkayu, ammeyu kepay maawatan? ");
INSERT INTO gdg_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Ammeyu kad ammu si massiki sanna a ipaunangnga tolay sino wangiꞌna, umang sino kuyungnga, kasena kappay mallawan? ");
INSERT INTO gdg_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Udde ino ipalawanna sino wangiꞌna, maggabwat sino nakamma, e antuweno mappadakkut sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Se ino nakamma tolayino paggabwatanino ammina narakkatta dinandamma a metupak si narakkatta aggangwa a kunnayaw: ino mamapatay, ino makibulun, ino makidurug sino bakkanna atawana, ino mattakaw, ino massisiri, annino mamaraparal. ");
INSERT INTO gdg_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Irayawino mappadakkut si tolay sino aꞌlangi Dios. Udde ino pangngananna tolaya ammena tuntulannino fustuwa ammaggu, bakkan inayino mappadakkut sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wasinoy, inanora Jesus sinay, e inangngira sino sakopanna Tiro anna Sidon. ");
INSERT INTO gdg_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Agyanino tata a bafaya bakkanna Judyu a taga-Canaan a nagyan sinay. Inaraꞌni ki Jesus e nakiggimallak sikwana si, “Afuwa gaka i David, allakkannak. Se madyataningke ino balatanga abbingkuwa naunaggan si narakkatta espiritu.” ");
INSERT INTO gdg_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Udde amme sinombatani Jesus. Antu gafuna, inaraꞌniyeno adalannera sikwana e sinapiꞌda si, “Akwannuweno anggamma ta panawannun, ta ammenan dumaladandana mappalingag.” ");
INSERT INTO gdg_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Udde sinapiti Jesus si, “Awana korwan si nanundunani Dios sikwak, nu bakkampelang sino gakagakera i Israel a meyamparig si naawana karnero.” ");
INSERT INTO gdg_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Udde inang kappayino bafaya namalitud sino aꞌlangnga. “Afu, duffunandak abbu,” kunna. ");
INSERT INTO gdg_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","E sinabbi Jesus a niyamparig si, “Ammena fustu nu fulattanteno akkananna abbing e iyaꞌdata sino atu.” ");
INSERT INTO gdg_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","“On lud, Afu,” kunnino bafay, “udde massiki ino atuwera, akkanandeno butta a madaraꞌnag sino pangngananino afura.” ");
INSERT INTO gdg_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","E sinapiti Jesus si, “Natuyag gakkuruwino angngurungngu sikwak. Makweno arangngannu.” E kakaꞌmeng kelanga nabbattunoyino balatanga abbingnga. ");
INSERT INTO gdg_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Wasinoy, inanawi Jesus e inang sino dappiꞌna bebaya Galilea. Nanuꞌdu sino kulud e nattuttud sinay. ");
INSERT INTO gdg_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Odduweno tolayira a inang sikwana a nibulun sino matakitira. Agyanino pilayira, ino lappattira, ino ammera makalakad, ino ammera makadamit, andino korwanira. Newaggarera sino aꞌlangi Jesus, e nepabbattunoynera ammin. ");
INSERT INTO gdg_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Gafu sinoy, nakkaꞌbawino tolayira sin initareno ammera makadamita maddamitiran, ino ammera makalakara mallakariran, ino pilayira a nabbattunoyiran, annino lappattira a makaiteran. E dinayora i Dios a Diosino gakagakera i Israel. ");
INSERT INTO gdg_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Wasinoy, inayani Jesusino adalannera e sinapiꞌna si, “Maallakkanak sitawira a tolay, se kaꞌlu awina nagyanira sikwatam, e naambutinnino akkananda. Ammekira anggamma panawan nu ammera kepay nangngan, tantaro nu maffunawira sino dalan.” ");
INSERT INTO gdg_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","“On lud,” kunnino adalannera sikwana, “udde sintawino pangappantam si akkanan sito kalolowata makabalin sino kunnayawa kaoddura?” ");
INSERT INTO gdg_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","“Pidyeno tinapeyu sitan?” kunni Jesus. “Pitu ke,” kunda, “e ana kappayino bisangnga tinapa.” ");
INSERT INTO gdg_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wasinoy, nepattutturi Jesusino odduwera a tolay. ");
INSERT INTO gdg_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Inappaneno pituwa tinapay annino tinapa, e nappasalamat ki Dios, kasena ginaradwa e neyaꞌdana sino adalannera, e neyannera sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Nangnganira ammin e nabattuwira. Wasin nasinduwera, inampaꞌdeno nabuna, e pituwa basketino pinannura sino nabuna. ");
INSERT INTO gdg_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ino bilangino nangnganira, appatarifuwera a lallaki, fereno bafabbayira andino aanakira. ");
INSERT INTO gdg_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wasinoy, nepaanawi Jesusino tolayira, kasena nattakay si abanga umang sino sakopanna Magadan. ");
INSERT INTO gdg_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Agyanino Fariseowera andino Saduceowera a inang ki Jesus, se angganda a dalodawan. Antu gafuna, inaranda si mipaita si kakkaꞌbawa senyal sey langit ta pangammuwanda si gakkuruwa i Diosino nanundun sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Udde sinabbi Jesus si, “Nu sumallappino sinag e malidaga sey langit, sapitandaw si, ‘Awana uran nu daramat.’ ");
INSERT INTO gdg_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Si kagigiꞌbaꞌna kappay, nu mallibaga sey langit e madduladulam, sapitandaw si, ‘Muran nakuy.’ Damayuwa distun nu muran onnu awan nu itandawino langit, udde ammeyu kena ammuweno anggamma sapitannino senyala ipaita i Dios sino makwa sito ingkein. ");
INSERT INTO gdg_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Narakkattingke ino tolayira sito ingkein se sinalekkurandeno gakkuruwa Dios. Patutandaka mipaita si kakkaꞌbawa senyal, udde awana mepaitak nu bakkampelangino senyal a kunneno nakwa ki Jonas siꞌin.” Sinapiti Jesus inay, kasenera inanawan. ");
INSERT INTO gdg_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Wasin nakadammanda Jesus sino bebay, dinandammino adalannera si nakalyawanda a nabbalibal si tinapay. ");
INSERT INTO gdg_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Sinapiti Jesus sikwara si, “Palanandawino lebadureno Fariseowera andino Saduceowera.” ");
INSERT INTO gdg_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Wasin diningngaddeno sinapiꞌna, nattatarabbanda si, “Ino nassapitanna sinay, se ammetam nabbalibal si tinapay.” ");
INSERT INTO gdg_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Ammuwi Jesusino pattatarabbanda, antuweno kunna sikwara si, “Sandolang paddararananino awana tinapeyu? Kurang kepayino annalaꞌdaw sikwak! ");
INSERT INTO gdg_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ammeyu kepay maawatanino pannakadamak? Nakalyawandawinnino lima a tinapaya nakabalin sino limarifuwera a tolay? Pidya a basketino pinannuyu sino nabuna? ");
INSERT INTO gdg_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Onnu ino pituwa tinapaya nakabalin sino appatarifuwera a tolay, pidya a basketino pinannuyu sino nabuna? ");
INSERT INTO gdg_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Mayan ammeyu kepay maawatan si bakkanna tinapayino sapitangku sikwayu? Ino sinapikku, palanandonaddino lebadureno Fariseowera andino Saduceowera.” ");
INSERT INTO gdg_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wasinoy, naawatanda si ino sapitanni Jesus si palananda, bakkannino lebadurana tinapay, nu ammena lurino tulduweno Fariseowera andino Saduceowera. ");
INSERT INTO gdg_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Wasin ginamwanda Jesus sino sakopanna Cesarea Filipos, nebebuꞌna sino adalannera si, “Sanneno sapitannino tolayira mappeafu sikwak?” ");
INSERT INTO gdg_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","“Aneno massapitira si ikka i Juan a Gumabawtisar. Kunnino korwanira si ikka i Elias, e kungkappayino korwanira si ikka i Jeremias onnu korwana gumalabbun siꞌin,” kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","“Udde ikkayu pay,” sinapiti Jesus, “sanneno kundaw mappeafu sikwak?” ");
INSERT INTO gdg_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Sinabbi Pedro si, “Ikkeno Kristo a Abbingino aggabiyaya Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Sinapiti Jesus si, “Nagasakka, Simon a abbingi Jonas, se bakkanna tolayino nipakaammu sikwam sinay, nu ammena luri Ama sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Antu gafuna, kunnayawino sapitangku sikwam. Nginalittaka si Pedro, ino anggamma sapitan, batu. Iyawa batuweno pamataꞌdaggangku sino balek a ireno ammina manguruwirana sikwak, e massiki ino pannakadamana katayan, ammenerana maaffut. ");
INSERT INTO gdg_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Iyaꞌdaꞌnga sikwamino kalintiyannu a meyamparig si tulbika pabbukkat sino patturayani Dios. Massiki sanneno iyallangngu sito lubag, iyallang kappayi Dios a ana sey langit, e massiki sanneno purayannu sito lubag, purayangkappayi Dios a ana sey langit.” ");
INSERT INTO gdg_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wasinoy, sinutuningke i Jesusino adalannera si ammera nad ituldu si massiki sanna a tolay si antuweno Kristo. ");
INSERT INTO gdg_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Mangiyafu sinoya tiyempo, nepakaammuwi Jesus sino adalannereno makwana sikwana so maddagguna aw. Sinapiꞌna si, “Maawa umangngak sey Jerusalem e padyatandaꞌngeno pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwan. Papapateraꞌnga, udde pangngangolindaꞌnga i Dios sino mekatalluwa aw.” ");
INSERT INTO gdg_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Wasinoy, nebakkangi Pedro e nebuyana a nassapit si, “Ammeka nad massapit si kunnenoy! Amme purayani Dios a makwa sikwam inay.” ");
INSERT INTO gdg_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Nabbaliwiti Jesus e sinapiꞌna ki Pedro si, “Aroyuwannak, Satanas! Talantanandak, se ino dandammannu, bakkannino panggammani Dios, nu ammena lurino panggammanna tolay.” ");
INSERT INTO gdg_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wasinoy, sinapiti Jesus sino adalannera si, “Ino manggamma mesapat sikwak, talekkuranna naddino urenangkepay. Kunnangke buttunganna naddino krusna, se inona urekino tuntulanna, massiki antuweno ipatena. ");
INSERT INTO gdg_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Se ino mikalow sino biyangnga, matekappena. Udde ino matay gafu sino angngurungnga sikwak, ananeno biyaya mannayuna iyaꞌda i Dios sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Se sanna kaddino pallawaranneno tolay nu akwana amminino kinabaꞌnang sito lubag, e matena e makastigu si makkikiyad? Awan! Se awana kinabaꞌnangnga damana a italyat sino biyangnga ki Dios. ");
INSERT INTO gdg_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Se ikkanak Abbingnga Tolay, muliyaꞌnga a kebulunanino anghelkuwera a mangipaita sino kedayawani Ama, kasek labutanino kadda tolaya meannung sino inangangwana. ");
INSERT INTO gdg_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Gakkurug yo sapitangku sikwayu, aneno korwanira sikwayu sitawa ammera matay makkiyad si itandaka Abbingnga Tolaya mangiyafuwa matturay.” ");
INSERT INTO gdg_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Wasin nallaꞌwutino annamma aw, inayani Jesus da Pedro andino makkolakira a da Santiago anni Juan, e ira pelangino nanuꞌdu sino tata a ataꞌnanga kulud. ");
INSERT INTO gdg_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Wasin agyananda sinay, initareno nangkakwanino baggiyi Jesus. Ino mutungnga, mangngilikilita kunnangke sinag, e ino barawasina, karririyeno furona. ");
INSERT INTO gdg_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wasinoy, nappaddara Moises anni Elias, e makitatabbira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Naddamippayi Pedro e kunna si, “Afu, nalawad se ayawetam sitaw. Nu anggammu, mangwak si talluwa bawi sitaw ta akwamino tata, akwa i Moisesino tata, anna akwa i Eliasino tata.” ");
INSERT INTO gdg_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Wasin aggedamadamikkepay, nakulmutanira ammin si karririya dulam. E agyanino damita naggabwat sino dulamma nassapit si, “Antuyawino iiddukangkuwa Abbingku e maanggammakungke gafu sikwana. Dingngaggandonaddino sapitanna.” ");
INSERT INTO gdg_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Wasin naningngagganino adalanira i Jesus sinaya damit, nassakabbira gafu sino talora. ");
INSERT INTO gdg_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Inaraꞌniyanira i Jesus e inappangannera, e sinapiꞌna si, “Gumabwakkayu. Ammekayu mattalaw.” ");
INSERT INTO gdg_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Wasin sinangawira, awana korwan si initara, nu bakkampelangi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Wasin aggedawadawutira sino kulura nagyananda, netuni Jesus sikwara si, “Ammeyu itutulduwenaya nepaita sikwayu si massiki sanna a tolay makkiyad si mangngangoliyaka Abbingnga Tolay.” ");
INSERT INTO gdg_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Wasinoy, nebebutino adalannera si, “Mayan sapitan mantuweno mammesturuwerana lintig si muli nad abbuwi Elias a gumalabbun siꞌin, kasena gumamwangino Kristo a nekariyi Dios?” ");
INSERT INTO gdg_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","“Gakkuruwa muli abbuwi Elias ta idadanna ammin,” nesombati Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","“Udde sapitangku sikwayu si ginamwanginni Elias, udde ammera naimunuwan, nu ammena lud ingkelamangino inangwara sikwana. Kunna kappeneno appadyaꞌda sikwaka Abbingnga Tolay.” ");
INSERT INTO gdg_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Gafu sinaya sinapiti Jesus, naawataninnino adalannera si i Juan a Gumabawtisarino sapitanna. ");
INSERT INTO gdg_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Wasin ginamwanganda sino kaodduwanna tolay, agyanino tata a lalaki sikwara a inaraꞌni ki Jesus e namalitud sino aꞌlangnga. ");
INSERT INTO gdg_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","Sinapiꞌna si, “Afu, allakkannu abbu yo abbingkuwa makkoldat. Nu makkoldat, madyataningke, se namipidyena naletwad sino afuy anna sino danum. ");
INSERT INTO gdg_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Neyangkun sino adalannuwera udde ammera a mapabattunoy.” ");
INSERT INTO gdg_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","“Ikkayuwa tolay sito ingkein, awaningke angnguruddaw anna ammekayu matulduwan!” kunni Jesus sikwara. “Naansa matino panguruwandawa nabayakunna nakiigyan sikwayu? Makapidyak kepaya manus sikwayu? Iyandaw sikwakino abbing.” ");
INSERT INTO gdg_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","E sinapiꞌna sino narakkatta espiritu si umanaw, e inanawannenaya abbing, e kakaꞌmeng kelanga nabbattunoy. ");
INSERT INTO gdg_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Wasin inowimpelang adalannera, inangngira nabbebut ki Jesus si, “Mayan ammemi mapaanaw inaya nunag sikwana?” ");
INSERT INTO gdg_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","“Gafu se kurang kepayino annalaꞌdaw sikwak,” netabbi Jesus. “Gakkurug yo sapitangku sikwayu, massiki nu wara angnguruddaw a mekunna sino kabibissangngana bukalla mustasa, damayuwa sapitan sitawa kulud si ‘Malikka,’ e gakkuruwa malit. Awaningke a ammena dama sikwayu. ");
INSERT INTO gdg_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Udde ino kunnenaya narakkatta espiritu, ammena umanaw nu ino mappaanaw sikwana, ammena mallantanga mangngan anna aggekarakararag.” ");
INSERT INTO gdg_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Wasin tata si awa nakkakarampaꞌda Jesus andino adalannera sey Galilea, sinapiti Jesus sikwara si, “Ikkanaka Abbingnga Tolay, araꞌniyenna meyalawatak sino tolayira ");
INSERT INTO gdg_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","e papatayandak, udde pangngangolindaꞌnga i Dios sino mekatalluwa aw.” Wasin diningngaggino adalannerenay, malowingke ino nakanda. ");
INSERT INTO gdg_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Wasin ginamwanda Jesus andino adalannera sey Capernaum, inangngino gumattukiyera si buwiꞌna Templo ki Pedro e nebebuꞌda si, “Pagampayino mesturuyuweno buwiꞌna Templo?” ");
INSERT INTO gdg_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","“One,” kunni Pedro. Wasin sinallungi Pedro sino balaya agyanani Jesus, naunta i Jesus a naddamit e sinapiꞌna si, “Simon, sanneno masapiꞌnu? Inyeno pappapaganino ariyera sito lubag si buwit? Ino abbindangkepay onnu ino korwana tolay?” ");
INSERT INTO gdg_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","“Ino korwana tolay,” kunni Pedro. Sinapikkappayi Jesus si, “Nu kunnenoy, ammena antu maawag si mappageno abbinda. ");
INSERT INTO gdg_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Udde ammetammad mangwa sino kalowanino nakanda sikwatam, antu gafuna, umangka mamanwet sino bebay. Ino palunguwa banwetannu, pagangngangannu, e maitamino dipilata a damata a ipaga a adwa. Appannu ta umangngu iyaꞌda sikwara ta mapaganino buwitta.” ");
INSERT INTO gdg_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Sinoya tiyempo, inangngino adalanira i Jesus sikwana e sinapiꞌda si, “Inya sikwamiyeno kapatiyan sino patturayani Dios?” ");
INSERT INTO gdg_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Antuweno nayi Jesus si abbing e nepataꞌdangnga sino naraꞌlanganda. ");
INSERT INTO gdg_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","E sinapiꞌna si, “Gakkurug yo sapitangku sikwayu, nu ammeyu angkakwanino nakandaw ta mekunnakayu si abbing, ammeyu dama a mesapat sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Ino kapatiyan sino patturayani Dios, antuweno mipaabbafaw sino baggina ta mekunna sitawa abbing. ");
INSERT INTO gdg_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","E massiki inyeno mawat si abbafawa tolay a kakunna yawa abbing gafu sino angngurungnga sikwak, ikkanakino inawaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Udde ino manutunggung ta malliwatino tata a abbafawa tolaya mangurug sikwaka mekunna si abbing, tawwaren nu meyakad sino buꞌloneno dokalla aggilingana batu ta malimat sino bebay amma sino ituluyneno manutunggung. ");
INSERT INTO gdg_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Kakallakkino tolayira sito lubag gafu sino odduwa katutunggunganda. Ammena dama a maari inay, udde kakallakkingke ino tolaya manutunggung. ");
INSERT INTO gdg_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Antuweno nu kamaꞌnu onnu ino takkimino paggafuwanino palliwatannu, gaꞌbungannu ta itakkummu. Se tawwareno nagaꞌbunganino tata a kamaꞌnu onnu takkim e mabiyagga si makkikiyad amma sino sikkakamakka anna sittatakkika a metubba sino afuy sey infiyernu. ");
INSERT INTO gdg_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","E nu ino matangkappayino paggafuwanino palliwatannu, tuketannu ta itakkummu. Se tawwareno tafiyangka si mata e mabiyagga si makkikiyad amma sino nadduwammangino matama metubba sino afuy sey infiyernu.” ");
INSERT INTO gdg_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Itandaw ta ammeyu pappoporayanino massiki tata a abbafawa tolaya kakunnana yawa abbing. Se gakkurug yo sapitangku sikwayu, ino anghelira a mimut sikwara, kanayunira a umaꞌlang ki Ama sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Se ikkanak Abbingnga Tolay, ino inangngangku sito lubag, takesi isalakkuweno minalliwatira a kunnangke natantangira. ");
INSERT INTO gdg_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Sanneno masapiꞌdaw? Nu wara tolaya makangkwa si tatuta karnero e naawanino taggi, sanna nakuyino akwanna? Gakkuruwa anawanneno asamafulu si asama maggarab sino kakuluran ta umangnga tufukannino naawana karnero. ");
INSERT INTO gdg_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Gakkurug yo sapitangku sikwayu, nu daꞌnganneno taggiya naawan, dodokkallino aanggamma sikwana amma sino asamafuluwera e asama ammena naawan. ");
INSERT INTO gdg_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Kunna kappay sino Amayu sey langit, ammena anggam si mekatwayino massiki tata sino kaabbafawana tolay sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Nu wara kolaꞌngu si angnguruwa nakaliwat sikwam, umangka a makitatabbag sikwana a ikkayu pelang ta ituldum sikwaneno liwaꞌna. Nu dingngagganneno sapitannu, nalawad se muliyeno abbafarulundaw. ");
INSERT INTO gdg_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Udde nu ammena anggamma dingngaggan, mayagga si tata onnu adwa a bulunnu takesi wara adwa onnu talluwa manaꞌdag sino pattatabbandaw. ");
INSERT INTO gdg_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Nu ammena kepay maningngag, ipakaammum sino bafulunnuwera a mangurug nu makkakarampakkayu ammin. E nu ammena kepay dingngaggannino sapitandaw, ibilandawin si tolaya amme nangammu ki Dios onnu narakkatta kunnangke gumattuki si buwit. ");
INSERT INTO gdg_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Gakkurug yo sapitangku sikwayu, massiki sanneno iyallandaw sito lubag, iyallang kappayi Dios a ana sey langit, e massiki sanneno purayandaw sito lubag, purayangkappayi Dios a ana sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Sapitangku kappay sikwayu, nu wara massiki adwa sikwayuwa mittata si nakam sino parangnganda ki Ama sey langit, gakkuruwa akwanneno arangnganda. ");
INSERT INTO gdg_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Se massiki nu adwa onnu talluweno makkakarampat gafu sino angngurudda sikwak, agyanak sinaya mebulun sikwara.” ");
INSERT INTO gdg_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Wasinoy, inangngi Pedro ki Jesus e sinapiꞌna si, “Afu, mamipidyangkuwa pakomanino bulungkuwa aggeliwaliwat sikwak? Makkiyad si mamippitu?” ");
INSERT INTO gdg_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Bakkampelanga mamippitu, nu ammena lud mamippitufulu e pitu,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Se ino makwa sino patturayani Dios, meyamparig si kunnayaw. Aneno tata a ariya nanandam si mappapaga sino gatutino ofisiyalnera. ");
INSERT INTO gdg_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Wasin neyafunana mappapaga, neyanda sikwaneno tata ofisiyalna a nakagatut si parifurifuwa pirak. ");
INSERT INTO gdg_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Ammena makapaga inaya ofisiyal, antuweno sinapitino ari si melakuweno ammina kukwana, anna melaku kappay, pati sino atawana andino abbingngera ta mearipannira ammin takesi mapaganino gatuꞌna. ");
INSERT INTO gdg_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Udde namaliturino ofisiyal sino aꞌlangino ariya nakiggimallakka nassapit si, ‘Afu, allakkannak! Anusandak abbu ta pagangkuna ammin.’ ");
INSERT INTO gdg_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Gafu sino kunnenoy, naallakkino ari, ammenan nepapageno gatuꞌna, e nepaanonan. ");
INSERT INTO gdg_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Wasin nallawanin inaya ofisiyal, dinambalneno bulunna a ofisiyala nakagatut sikwana si tatut. Pinattalna e sinapiꞌna sikwana si, ‘Pagannuweno gatuꞌnu!’ ");
INSERT INTO gdg_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Namaliturino bulunna e nakiggimallakka nassapit si, ‘Allakkannak! Anusandak abbu ta pagangkuna ammin.’ ");
INSERT INTO gdg_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Udde ammena inallak e nepabalunna makkiyad si mapaganino gatuꞌna. ");
INSERT INTO gdg_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Wasin initeno bulundera a ofisiyalino inangwana, malowino nakanda, e inanda netuldu sino ariyeno nakwa. ");
INSERT INTO gdg_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Wasin naammuwanino ari, nepaayangngeno ofisiyala nakagatut sikwana e sinapiꞌna si, ‘Narakkattingke ino aggangwam! Ammek nepapageno gatuꞌnu sin nakiggimallakka sikwak. ");
INSERT INTO gdg_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Inallattaka. Mayan ammem inallakkino bulunnuwa kunna payino inangwak sikwam?’ ");
INSERT INTO gdg_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Gafu se nappelalotino bungutino ari, nepabalunna ta madyatan makkiyad si mapaganna ammina gatuꞌna.” ");
INSERT INTO gdg_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Wasinoy, neyabambuti Jesus a nassapit si, “Kunna kappenenayino akwani Ama sey langit sino kadda tata sikwayu, nu ammeyu gakkuruwa pakomanino kasittoleyu.” ");
INSERT INTO gdg_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Wasin nasinduwi Jesus a sinapit ammin inay, nanaw sey Galilea, e inang sino sakoꞌma Judea sino dammangngeno wawwanga Jordan. ");
INSERT INTO gdg_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Odduweno dinandan sikwana e nepabbattunoyneno matakitira sinay. ");
INSERT INTO gdg_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Agyangkappayino Fariseowera a inang ki Jesus ta kakkapanda a balabaliyan, e nebebuꞌda si, “Sino lintiddam, damana kadda ikatwayino lalakiyeno atawana, massiki sanneno gafuna?” ");
INSERT INTO gdg_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Nesombati Jesus si, “Ammeyu kad binaseno neturakka sapiti Dios mappeafu sino namaratuwanna si tolay? Ino neturak, kunna si ino inangweno namaratu sin gafugafuna, nangwa si lalaki anna bafay. ");
INSERT INTO gdg_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","E sinapiꞌna si, ‘Antu gafuna, anawanino lalakiyeno mapparanaꞌngera takesi makikofung sino atawana, e mabbaliyera si tata.’ ");
INSERT INTO gdg_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Antuweno ammerana adwa, nu ammerallud nittata. Kunnantu, amme nad pakkatwayanna tolayino nepamungi Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","“Udde mayan kunnino lintiyi Dios si mangaꞌdeno lalaki sino atawana si turakka pangitan si nakkatwayira, kasena panawan?” kungkappayino Fariseowera. ");
INSERT INTO gdg_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Sinabbi Jesus si, “Gafu pelang sino kinataggatino uluyu, antuweno nepurayi Moises si ikatweyuweno atawayu, udde sin gafuna, bakkanna kunnenoy. ");
INSERT INTO gdg_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Antuweno sapitangku sikwayu, ino lalakiya mikatway sino atawana, fera pelang nu millalaki, kasena mangatawa si korwan, makibulun se atawana kepayino palunguwa atawana.” ");
INSERT INTO gdg_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Wasinoy, sinapitino adalanira i Jesus sikwana si, “Nu kunnenaya ammena dama a makkatwayino matawa, tawwarennino ammetam mangatawa.” ");
INSERT INTO gdg_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Sinapikkappayi Jesus si, “Gakkurug inaya sinapiꞌdaw, udde bakkanna ammina tolay e damara a attammanino ammena mangatawa, ino pelang nangaꞌdani Dios si pannakadamara a miyattam. ");
INSERT INTO gdg_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Naddadarumeno gafuna a amme mangataweno lallakiyera. Ino korwan, neyanakira a kurangino kinalalakira, ino korwan, gafu se nalassitanira, e ino korwanira kappay, ammera mangatawa takesi pittatandeno nakanda sino passerbiyanda ki Dios sino patturayanna. Ino makattamma mangwa si kunnenoy, akwanna nad.” ");
INSERT INTO gdg_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Wasin tata si aw, agyanino tolayira a niyang sino anaꞌdera ki Jesus takesi itappaꞌneno kamaꞌna sikwara anna ikararannera. Inallangnganino adalannera, ");
INSERT INTO gdg_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","udde sinapiti Jesus si, “Purayandawino anakira ta umangngira sikwak, e ammeyuwera allangngan. Se ino kakunnara, ireno dama a mesapat sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","E netappaꞌneno kamaꞌna a mamindisiyon sikwara, kasena inanaw. ");
INSERT INTO gdg_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Wasinoy, agyanino buwanaka inang ki Jesus. “Afu mesturu, sanneno nalawara akwangku takesi maappakino biyaya mannayun?” kunna. ");
INSERT INTO gdg_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Sinapiti Jesus sikwana si, “Mayan bebutannu sikwak nu sanneno nalawad? Se i Dios pelangino nalawad. Nu anggammuwa maaꞌdan si biyaya mannayun, kuruwannu naddino lintiyi Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","“Sannenaya lintig?” kungkappayino buwanak. “Ammeka mamapatay, ammeka makibulun, ammeka mattakaw, ammeka manistigu si bakkanna gakkurug, ");
INSERT INTO gdg_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","dayawannuweno mapparanaꞌnguwera, anna anggammannuweno kasittolema kunna payino agganggammu sino baggim,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Sinapikkappayino buwanak si, “Kinuruggu ammin inaya lintig. Sanna kepayino maawa akwangku?” ");
INSERT INTO gdg_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Sinapiti Jesus si, “Nu anggammu si awana pakkurangannu, umangngu ilaku amminino kukwam ta iyaꞌdam sino pobiriyereno pallakuwannu, ta ananeno kinabaꞌnangngu sey langit. Nu inangwamunnenay, kaseka muli sitaw e mebulungka sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Wasin diningngaggino buwanakino sinapiꞌna, kakaꞌganna a inanaw, gafu se baꞌnangngingke. ");
INSERT INTO gdg_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Wasinoy, sinapiti Jesus sino adalannera si, “Gakkurug yo sapitangku sikwayu, madyata mesapatino baꞌnangnga tolay sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Sapitangku kappay si mas naladdeno attaffutino kamelyu sino abbuꞌna bilat amma sino kesapatanino baꞌnangnga tolay sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Nappelalotino kaꞌbawino adalannera sin diningngaddenay, e sinapiꞌda si, “Nu kunnenoy, inya maꞌneno mesalakan?” ");
INSERT INTO gdg_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Sinulangnganira i Jesus, e sinapiꞌna si, “Ino tolay, awana damana a akwana misalak sino bagginangkepay. Udde i Dios, damana akwan ammin.” ");
INSERT INTO gdg_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Wasinoy, sinapiti Pedro si, “Ikkami mappaye? Se inanawamminnino amammimmi ta mebulungkami sikwam. Sannaneno labuꞌmi?” ");
INSERT INTO gdg_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","“Gakkurug yo sapitangku sikwayu,” kunni Jesus, “nu mapabawuna yo lubag, maiteno kedayawangkuwa Abbingnga Tolay, se mattutturaꞌnga sino tronoka matturay. E ikkayuwa adalangku, mattuttuggayuna kappay si karadwa a tronowa makituray sikwak sino tolekira a mekunnera sino gakagakeno karadwa a abbingi Israel. ");
INSERT INTO gdg_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Massiki inya a manganaw sino balena, ino kakkolaꞌngera, ino mapparanaꞌngera, ino anaꞌngera andino lubangnga gafu sikwak, oodduneno appanna amma sino inanawanna, e maaꞌdangkappay si biyaya mannayun. ");
INSERT INTO gdg_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Udde odduweno meyantaw sito ingkeina metabbafana, e odduwera kappaya abbafaw sito ingkein a meyantona.” ");
INSERT INTO gdg_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Sinapiti Jesus si, “Ino makwa sino patturayani Dios, meyamparig si kunnayaw. Aneno makwan kaubasana naggiꞌbatta inang nintufuk si tandananna a mattarabafu sino kaubasanna. ");
INSERT INTO gdg_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Agyanireno dinaꞌngana e nakitulag sikwara si paganneno innawanino kadda tata sikwara, kasenera dinunduna mattarabafu. ");
INSERT INTO gdg_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Wasin alas nuwebe si gigiꞌbat, nallawangkappayino makwan lubag, e initaneno gitutturanira sino allakuwan. ");
INSERT INTO gdg_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Sinapiꞌna sikwara si, ‘Umangkayu pay mattarabafu sino kaubasangku ta tandanantakayu si fustu.’ ");
INSERT INTO gdg_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","E inangngira. “Wasi tangnganaw anna alas tres, kunna kappayino inangweno makwan lubag. ");
INSERT INTO gdg_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Wasin maffuwafin, inang kappay sino allakuwan e ana kappayino initana sinaya gitutturanira kappay. Sinapiꞌna sikwara si, ‘Mayan mappatatokayu pelanga aggatuttud?’ ");
INSERT INTO gdg_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“ ‘Awan lura pakitandanammi,’ kunda sikwana. “E sinapitino makwan lubag si, ‘Umangkayu mantu mattarabafu sino kaubasangku.’ ");
INSERT INTO gdg_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Wasin massiꞌlappin, sinapitino makwan lubag sino katalaꞌnga si, ‘Ayannuweno mattarabafuwera ta iyaꞌdamino tandanda. Iyafum sino nauddiyera a inang nattarabafu kiyad sino nauntera.’ ");
INSERT INTO gdg_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Waso kunnenoy, ginamwangino nangiyafuwera a nattarabafu si fuwab, e natandananira si innawan. ");
INSERT INTO gdg_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Antu gafuna, wasin ginamwangino nauntera a nattarabafu, aridda si oodduweno tandanda, gampade nekunna kappekena a innawanino neyaꞌda sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Wasin inapparenaya tandanda, narririyera sino makwan lubag e sinapiꞌda si, ");
INSERT INTO gdg_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘Ino nauddiyera, taorappelangino nattarabafuwanda, udde ikkami, nappafufuwaggamiya nattarabafu e nasinasinangkami. Mayan nekunnamino tandammi?’ ");
INSERT INTO gdg_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Udde sinapitino makwan lubag sino tata sikwara si, ‘Kolak, ammetaka dinarogat, se nattatabbanta si innawanino annandangku sikwam. ");
INSERT INTO gdg_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Appannuweno tandannu e umanokan. Nekunnakino tandanino nauddiyera sino tandandaw se antuweno anggangkuwa akwan. ");
INSERT INTO gdg_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Awangkadda kalintiyangkuwa mangwa sino anggangku sino pirakkungkepay? Onnu umimalka gafu se inallakkuwera?’ ” ");
INSERT INTO gdg_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Wasinoy, neyabambuti Jesus a sinapit si, “Kunnenayino amparingngeno sinapikkuwa ino abbafawira sito ingkein, meyantawirana, e ino meyantawira sito ingkein, metabbaferana.” ");
INSERT INTO gdg_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Sinoya umangnganda Jesus sey Jerusalem, nebakkangngeno karadwa a adalanna ta tatabbannera a ira pelang, e sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Dingngaggandaw. Sitoya, umangngetam sey Jerusalem. Nanu gumamwangetam sinay, ikkanaka Abbingnga Tolay, meyalawataꞌnga sino pangafuwanirana padi andino mammesturuwerana lintig. Sentensiyandaꞌnga a mapapatay, ");
INSERT INTO gdg_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","iyalawaꞌdak sino bakkannira a Judyu ta pappoporayandak anna siwaꞌwattandak, kaserak ilansa sino krus. Udde sino mekatalluwa aw, pangngangolindaꞌnga i Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Wasinoy, inang ki Jesusino atawa i Zebedeo andino adwera a abbingnga, e namalitud sino aꞌlangnga a marang. ");
INSERT INTO gdg_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Sanneno anggammu?” kunni Jesus. “Nu madaꞌngeno patturayannu, purayannu nad yo adwera a abbingkuwa makituttud sikwam, tata sino padiwanannu, tata sino padawim,” kunna sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Udde sinabbi Jesus si, “Ammeyu ammuweno arangngandaw. Damayu kadda attammanino lawumangkuna a dyat?” “On, damami,” kunda. ");
INSERT INTO gdg_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Sinapikkappayi Jesus si, “Gakkuruwa madyatangkayuna a kunna kappayino kadyatangku. Udde ino mattutturira sino padiwanangku anna sino padawik, awana kalintiyangkuwa mamili, se piniliyenni Ameno mattutturira sinay.” ");
INSERT INTO gdg_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Wasin diningngaggino tafuluwera a bulundenay, nabbungutira sino adwera a makkolak. ");
INSERT INTO gdg_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Gafu sino kunnenoy, inamungira ammini Jesus, e sinapiꞌna si, “Ammuyu si ino matturayira sito lubag, ipatuꞌdeno panggammanda sino iturayanda, e ino kappay pangafuwanira, ipaitareno kinaturera. ");
INSERT INTO gdg_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Udde ammena nad kunninoyino akwandaw. Se nu wara sikwayuwa manggamma medayaw, passerbiyanna naddino bafulunnera. ");
INSERT INTO gdg_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","E ino manggamma mabbali si kapatiyan, paaripanna naddino baggina sino bafulunnera. ");
INSERT INTO gdg_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Tuntulandaꞌngadda Abbingnga Tolay, se ammek inang sito lubagga mappaserbi, nu ammena lud ta masserbiyak sino tolayira anna takesi iyaꞌdakino biyagguwa panubbut sino kaodduwan.” ");
INSERT INTO gdg_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Wasin umanawanda Jesus sey Jerico, odduwa tolaya dinandan sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Agyanino adwera a lappatta aggatuttud sino dammingino dalan. Wasin diningngadda si mattaꞌlifi Jesus, nekokwara a nassapit si, “Ikka a gaka i David, allakkandakami!” ");
INSERT INTO gdg_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Inallangnganireno odduwa tolay ta suminakkira nad, udde neyangkakokwara lura nassapit si, “Afu, ikka a gaka i David, allakkandakami!” ");
INSERT INTO gdg_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wasinoy, nitturi Jesus e inayannera e nebebuꞌna si, “Sanneno anggandawa akwangku sikwayu?” ");
INSERT INTO gdg_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","“Afu, anggammiya makaita,” kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Naallakki Jesus sikwara e sinukkalneno matara. Kakaꞌmeng kelanga makaitera e dinandanira sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Wasin makkataminda Jesus sey Jerusalem, araꞌniyeran sey Betfage sino kulura Olivo. Nepauntaneno adwera a adalanna ");
INSERT INTO gdg_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","a sinapiꞌna si, “Umangkayu sino madompaka lubbun. Addatandaw sinay, maitayuneno neyakadda asno annino ubbunna. Uttarandaw ta iyandaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Nu wara mabbebut sinaya akwandaw, sapitandaw si, ‘Awannino Afutam,’ e purayannana a appandawira.” ");
INSERT INTO gdg_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Nakwenay takesi meyakkuruwino nepasapiti Dios sino gumalabbunna a kunna si, ");
INSERT INTO gdg_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Ituldum sino talubbuna Jerusalem, ‘Itandaw, gumamwanginnino Ariyuwa nipaabbafaw sino baggina a mattakay si ubbunna asno.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wasinoy, inangngino adwera a adalan e inangwareno netuni Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Neyandeno asno annino ubbunna ki Jesus, e neyekwareno tafalda sino darurura, kase nattakayi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ino odduwera a tolay sinay, neyafaꞌdeno tafalda sino dalan. Ino korwanira, nangappera si simiꞌna kayu e neyafaꞌda kappay sino dalana mangipaita sino angngiyatalda ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ino tolayira sino katamanna andino dumandanira sikwana, nekokwara a nassapit si, “Madandayawino gaka i David! Madandayokappenaddino dinunduni Afu Dios si pannakabaggina! Madandayawi Dios sey langit!” ");
INSERT INTO gdg_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Wasin ginamwangi Jesus sey Jerusalem, nakungkul amminino tolayira sinay e sinapiꞌda si, “Inyada yaw?” ");
INSERT INTO gdg_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","“Antuwi Jesus a gumalabbuna naggabwat sey Nazaret sino probinsiya a Galilea,” nesombatino tolayira a nebumbulun ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Wasinoy, sinallungi Jesus sino Templo, e nepaanona amminino mallakuwera andino maggatangira sinay. Iletwanneno lamisaanino gumatalyatira si pirak, kunna kappay sino tutturino gumalakuwera si kalapati. ");
INSERT INTO gdg_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Sinapiꞌna sikwara si, “Neturak sino sapiti Dios si ‘Ino balek, maingnganan si pakkararan ammina tolay.’ Udde ino inangwayu, nepabbaliyu si paddarogatandaw sino kasittoleyu.” ");
INSERT INTO gdg_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wasinoy, agyanino lappattira andino pilayira a inang ki Jesus sino Templo, e nepabbattunoynera. ");
INSERT INTO gdg_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Udde nabbungutino pangafuwanirana padi andino mammesturuwerana lintig sin naitereno kakkaꞌbawa inangwa i Jesus andino abbingira a mikakkulawuwa massapit si, “Madandayawino gaka i David!” ");
INSERT INTO gdg_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Antuweno sinapiꞌda sikwana si, “Ma, ammem madingngaggino sapitanda?” “On, madingngaggu,” kunni Jesus. “Ammeyu kad binaseno neturakka sapiti Dios a kunna si, ‘Sinulduwani Diosino abbingira andino kaluꞌbitira a maddayaw si fustu sikwana?’ ” ");
INSERT INTO gdg_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Wasinoy, inanawannera sinaya lubbun, e inang sey Betania ta midda sinay. ");
INSERT INTO gdg_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Wasi kadaramaꞌna a mulira Jesus sino lubbun, nabisinan. ");
INSERT INTO gdg_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Initaneno kayuwa igos sino dammingnga dalan e inaraꞌniyanna, udde awana initana si bungana, ino pelang adonnera. Antuweno nassapitanna sino kayu si, “Ammekanna mammunga.” E kakaꞌmeng kelanga naganguweno kayu. ");
INSERT INTO gdg_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Wasin initeno adalannerenaya nakwa, nakkaꞌbawira e sinapiꞌda si, “Mayan naganguwengkelang inaya kayuwa igos?” ");
INSERT INTO gdg_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Sinabbi Jesus si, “Gakkurug yo sapitangku sikwayu, nu natalanggaddino angnguruddaw ki Dios a ammekayu maddaladudwa, damayuwa akwan inaya inangwak sino kayu. Bakkampelang inay, nu ammeyu lud dama a sapitan sito kulud si ‘Meyalikka e meyassagga sino bebay,’ e gakkuruwa makwa. ");
INSERT INTO gdg_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Massiki sanneno arangngandaw ki Dios, appandaw, nu natalanggaddino angnguruddaw sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Wasinoy, nuliyi Jesus sino Templo. Sin aggetutulduwanna, inang sikwaneno pangafuwanirana padi andino korwanira a pangafuwanna Judyu. Nebebuꞌda si, “Sanneno kalintiyannuwa mangwa sino inangwamira? Inyeno naggabwatanna yana kalintiyannu?” ");
INSERT INTO gdg_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Sinabbi Jesus sikwara si, “Ana payino ibebukku abbu sikwayu. Nu sombatandaw, kaseppay itulduweno naggabwatanino kalintiyangkuwa mangwa sito inangwakira. ");
INSERT INTO gdg_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Antuyawino ibebukku. Inyeno naggabwatanino kalintiyani Juan a mamawtisar? Ki Dios onnu si tolay?” Wasinoy, nakkakibikibebutira a nassapit si, “Sanneno isombattam? Nu kuntam si i Diosino naggabwatanino kalintiyanna, tantaro nu sapitanna sikwatam si ‘Nu kunnenoy, mayan ammekayu nangurug sikwana?’ ");
INSERT INTO gdg_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Udde nu kuntam si tolepelangino naggabwatanna, kattalataloneno akwanino tolayira sikwatam, se kuruwanda ammin si gumalabbuni Juan.” ");
INSERT INTO gdg_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Antuweno sinapiꞌda ki Jesus si, “Ammemi inammu.” “Nu kunnenoy,” kunni Jesus, “ammeppemantu sapitan sikwayu nu inyeno naggabwatanino kalintiyangkuwa mangwa sitawira a akwangku.” ");
INSERT INTO gdg_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Wasinoy, netuluyi Jesusino sapitanna sikwara a niyamparig si, “Agyanino tolaya adwereno abbingnga a lallaki. Wasi tata si aw, sinapiꞌna sino palungu si, ‘Umangka mattarabafu sino kaubasan.’ ");
INSERT INTO gdg_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","“ ‘Ammek,’ kunna, udde naddadandam, e inang kappelang. ");
INSERT INTO gdg_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Wasinoy, inang kappayino amana sino uddiya abbingnga e parefuweno sinapiꞌna sikwana. ‘On, umangngak,’ kunna, udde ammena karud inang.” ");
INSERT INTO gdg_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","E kunni Jesus si, “Inya sikwara a adweno nangwa sino panggammanino amara?” “Ino palungu,” kunda. “Gakkurug yan,” kunni Jesus, “e gakkuruggappayino sapitangku sikwayu si ino minalliwatira a tolaya kakunneno gumattukiyera si buwit andino maayotira a bafabbay, maunterana sikwayuwa mesapat sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Se inang sitawi Juan a Gumabawtisar e netulduna sikwayuweno akwandonad takesi maggaddangkayu ki Dios, udde ammeyu kinurug. Udde ino gumattukiyera si buwit andino maayotira a bafabbay, ireno nangurug. E massiki sin initayuweno inangwara, ammekayu kepay nabboboli ta kuruwandopayino tulduna.” ");
INSERT INTO gdg_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Sinapikkappayi Jesus si, “Dingngaggandokappayino tata a amparig. Agyanino tata tolaya nakamulamula si ubas sino lubangnga. Inalasangngeno nammulanna, nangwa si pamappattanna sino bungana, e namataꞌdag si garita a pagyananino pindagganna. Wasin nabalinin inoy, nepaimuꞌna sino makikasamakkira, e inang nagyan si aroyuwa lubbun. ");
INSERT INTO gdg_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","“Wasin nadaꞌngeno abbafuwat si ubas, dinundunino makwan lubaggino aripannera a umang sino makikasamakkira a mappa sino ballena. ");
INSERT INTO gdg_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Udde wasin ginamwangira, dinoꞌmanino makikasamakkira e siniwasiwaꞌwattandeno tata, pinapatereno tata, e ilapalappaddeno tata kiyad si natay. ");
INSERT INTO gdg_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Wasinoy, nandadundungkappayino makwan lubag si oodduwa aripanna amma sino palunguwera, udde kunna kappayino inangweno makikasamakkira sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ino kauddiyana dinundunna sikwara ino abbingngangkepay, se kunna sino nakamma si ‘Ammuk si iyatalda yaw se abbingku.’ ");
INSERT INTO gdg_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Udde wasin initeno makikasamakkireno abbingnga, sinapiꞌda si, ‘Antuwen yawino millalupat sito lubag. Papatayantam ta akwatamunnino illalupattanna nad.’ ");
INSERT INTO gdg_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Dinoꞌmanda e nelawanda sino kaubasan, kasera pinapatay. ");
INSERT INTO gdg_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Nu kunnenoy,” kunni Jesus, “nu muliyeno makwan lubag, sannadeno akwanna sino makikasamakkira?” ");
INSERT INTO gdg_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","“Kattalataloneno ammapatena sikwara a narakkatta tolay, kasena ipabalattino lubangnga si korwana tolaya matalakka mangaꞌda sino ballena nu abbafuwat,” nesombaꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Sinapikkappayi Jesus sikwara si, “Ammeyu kepekad binasa yawa nepeturakki Dios a kunna si, ‘Ino batuwa inammayino mamataꞌdaggira si balay, antuweno nepabbaliyi Dios si kapatiyana batuwa mappatuyag sino balay. Antuweno inangwa i Dios, e kakkaꞌbawingke sikwatam.’ ");
INSERT INTO gdg_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Antu gafuna, sapitangku sikwayu si bakkanninna ikkayuwa Judyuweno iturayani Dios, nu ammena lurino tolayira a mangwa sino panggammanna. ");
INSERT INTO gdg_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ino tolaya madaꞌnag sitawa batu, makarattu, udde ino tolaya kadaꞌnanino batu, mamaꞌmakka mabbali si lafuk.” ");
INSERT INTO gdg_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Wasin diningngaggino pangafuwanirana padi andino Fariseowera inayira a ampariyi Jesus, naammuwanda si ireno sapitanna, ");
INSERT INTO gdg_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","e angganda a doꞌman. Udde mattalawira sino tolayira, se nebilanda i Jesus si tata a gumalabbun. ");
INSERT INTO gdg_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Wasinoy, niyampariggappayi Jesus a nassapit si, ");
INSERT INTO gdg_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ino makwa sino patturayani Dios, meyamparig si kunnayaw. Agyanino tata a ariya naddadana mappakasar sino abbingnga a lalaki. ");
INSERT INTO gdg_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Wasin nadadanin ammin, dinundunneno korwana aripanna ta umanda ayanino inayannera a makikasar. Udde ino inayannera, ammera inang. ");
INSERT INTO gdg_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Antuweno nanundungkappay sino korwana aripanna a umang mayag sikwara ta sapitanda si, ‘Umangngetam makikasar se nadadanin ammin. Napartiyennino nepatafanera a baka e nalutuwen ammin.’ ");
INSERT INTO gdg_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Udde ino inayannera, ammerera nepilingalinga, nu ammera lud netuluyino akwanda. Ino tata, inang sino umana, ino tata kappay, inang sino allakuwanna. ");
INSERT INTO gdg_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Ino korwanira, dinoꞌmandeno aripannera e pinadyatandera, kaserera pinapatay. ");
INSERT INTO gdg_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","“Nabbungubungutino ari e dinundunneno sindalunera a umang mamapatay sino namapatayira sino aripannera anna massikkul sino lubbunda. ");
INSERT INTO gdg_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","E sinapitino ari sino korwanira a aripanna si, ‘Nadadaninnino kasar, udde ino tolayira a inayangku, ammera meannunga umang. ");
INSERT INTO gdg_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Umangkayu nad sino daladalana kaodduwanna tolay e ayandawino ammina itandaw sinay.’ ");
INSERT INTO gdg_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Inangngino aripannera e inayanda amminino naitara a tolay, ino nalawad anna massiki ino narakkattira. E napannuweno pakkasaran sino balena ari. ");
INSERT INTO gdg_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Wasinoy, sinallungino ariya makitatabbag sino makikasarira, e initaneno tata a ammena nabbarawasi si meannung si kasar. ");
INSERT INTO gdg_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","‘Kolak,’ kunna sikwana, ‘mayan inangka sitawa ammeka nabbarawasi si meannung si kasar?’ Udde ammena nakadamit. ");
INSERT INTO gdg_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Antuweno sinapitino ari sino aripannera si, ‘Balurandawino kamaꞌna anna takkina ta itakkuddaw sino kalammukan sino lasin ta makatangatangit anna mangngarangaritamma sinay.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","E neyabambuti Jesus a nassapit si, “Odduweno ayanira i Dios, udde bisangke ino pilinna a mesapat sino patturayanna.” ");
INSERT INTO gdg_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wasinoy, inanawino Fariseowera e inanda nattatarabban nu sanneno ibebuꞌda ki Jesus, tantaro nu mabalabaliyan e massapit si kedarumanna. ");
INSERT INTO gdg_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Dinundundeno adalandera andino korwanira a buyuti Herodes a umang ki Jesus. Wasin dinaꞌngara, sinapiꞌda si, “Afu, ammumi si gakkurug ammina sapitannu, e gakkuruggappayino ituldum mappeafu sino panggammani Dios. Ammumi kappay si awana padumannu si tolay, massiki nu wara turera, nu ammena lud nakkakarunneno ituldum sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kunnantu, sanneno dandammannu mappeafu sitaw? Kontara sino lintiddama Judyu nu pagammiyeno buwit sino Emperador sey Roma?” ");
INSERT INTO gdg_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Udde ammuwi Jesusino narakkatta gakkadda, antuweno sinapiꞌna sikwara si, “Ikkayuwa massasannakam, mayan kalakannandak? ");
INSERT INTO gdg_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Paitayu mantu sikwakino piraka ipagayu sino buwit.” Wasin nepaitara sikwana, ");
INSERT INTO gdg_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","nebebuꞌna sikwara si, “Inyeno makwan letratu anna angan sitaw?” ");
INSERT INTO gdg_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","“Ino Emperador,” kunda sikwana. “Nu kunnenoy,” kunni Jesus, “ino akweno Emperador, iyaꞌdayu sikwana, e ino akwa i Dios, iyaꞌdayu pay ki Dios.” ");
INSERT INTO gdg_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Sin naningngagganda sinay, nakkaꞌbawira, e inanawanda. ");
INSERT INTO gdg_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Sinoy kappaya aw, ana kappayino Saduceowera a inang ki Jesus. Ireno tata a buyuꞌna Judyu a massapit si ammena mangngangoliyeno natayira. ");
INSERT INTO gdg_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Sinapiꞌda sikwana si, “Afu mesturu, sapitannino lintiyi Moises si, ‘Nu matayino lalakiya awana abbingnga, atawan naddino kolaꞌngeno balu takesi nu wara abbinda, antuneno guman abbingino natay.’ ");
INSERT INTO gdg_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Agyanino pituwera a makkakarolaka lallaki sito agyanammi. Nangataweno palungu, udde nataya awana abbingnga. Antuweno inataweno metufarino balu, ");
INSERT INTO gdg_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","udde natekappaya awana abbinda. Kunna kappayino nakwa sino mekatalluwa kolaꞌda, mampesino korwanira a kakkolaꞌda kiyad sino mekapitu. ");
INSERT INTO gdg_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Wasin natayira ammin, natekappayino bafay. ");
INSERT INTO gdg_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Kunnantu, naso awa pangngangoliyanino natayira, inyana sikwara a pituweno makwan atawa sinaya bafay? Se inatawara ammin.” ");
INSERT INTO gdg_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Sinombati Jesus si, “Natamakayu, se ammeyu ammuweno neturakka sapiti Dios e ammeyu kappay ammuweno pannakadamana. ");
INSERT INTO gdg_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Se nanu mangngangoliyeno natayira, ammeran mangatawa, nu ammera lud mekunna sino anghelira sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Nu mappeafu kappay sino pangngangoliyanino natayira, kunnangke ammeyu binaseno neturakka sinapiti Dios sikwayuwa kunna si, ");
INSERT INTO gdg_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ikkanakino Diosi Abraham, i Isaac, anni Jacob.’ Antuweno nassapitanna si massiki natayiran, nabiyayira kepay sikwana. Ino anggamma sapitan, mangngangoliyeno natayira, se i Dios, bakkanna Diosino natayira, nu ammena lurino aggabiyayira.” ");
INSERT INTO gdg_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Nakkaꞌbawingke ino tolayira sin diningngaddenaya netulduwi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Wasin diningngaggino Fariseowera si sininakkino Saduceowera sino sinapiti Jesus, nakkakarampattira e inangngira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Ino tata sikwara a nalainga mesturuna lintig, antuweno nangakkapa namalabali ki Jesus a nabbebut si, ");
INSERT INTO gdg_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Afu mesturu, sanneno kapatiyana tun sino ammina lintiyi Dios?” ");
INSERT INTO gdg_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Netabbi Jesus si, “ ‘Anggammannu naddi Dios a Afum, e pittatannuweno ammina nakammu, ammina urem, annino ammina kinalaingngu sikwana.’ ");
INSERT INTO gdg_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Antuwenayino kapatiyana tuni Dios. ");
INSERT INTO gdg_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Ino mekadwa a kapatiyan, mekunna sino palungu, a kunna si, ‘Anggammannu naddino kasittolem a kunna payino agganggammu sino baggim.’ ");
INSERT INTO gdg_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Iyawira a adwa a tuni Dios, ireno kefungallanino ammina lintiyi Moises andino neturakkino gumalabbunira.” ");
INSERT INTO gdg_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Wasin nakkakarampakkepayino Fariseowera, nabbebukkappayi Jesus sikwara a nassapit si, ");
INSERT INTO gdg_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Sanneno masapiꞌdaw mappeafu ki Kristo? Inyeno gagginafuna?” “Gaka i David,” kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Nebebukkappayi Jesus si, “Nu kunnenoy, mayan Afu mantuweno nepingngani David sikwana? Se kunnayawino nepesapitino Espirituwi Dios ki David: ");
INSERT INTO gdg_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Sinapiti Afu Dios ki Kristo a Afuk: Mattuttugga sito padiwanangku kiyad si affutangkuweno kalingam.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Netuluyi Jesus a nassapit si, “Nu ingnganani Daviri Kristo si Afuna a matturay sikwana, ansandolang kun si gaka i David?” ");
INSERT INTO gdg_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Awaningke sikwara a makasombat, e mangiyafu sinoy, awaninna naturira mabbebut sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Wasinoy, sinapiti Jesus sino tolayira andino adalannera si, ");
INSERT INTO gdg_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ino mammesturuwerana lintig andino Fariseowera, ireno ana kalintiyanna a manuldu sino lintiyi Moises, ");
INSERT INTO gdg_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","antuweno kuruwandonad ammina ituldura sikwayu. Udde ammeyu nad tuntulannino aggangwara, se ammera akwanino ituldura. ");
INSERT INTO gdg_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Dadagganandeno lintig e patutandeno tolayira a manuntul, gampade awangkena iduffunda sikwara. Kunnangke pattunda si nadammat, udde ammera manuffuna mattu. ");
INSERT INTO gdg_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ammina akwanda, akwanda ta itanino tolayira e iyataldera. Antuweno padokkallandeno piittungan sino korwana neturakka sapiti Dios a ibabbadda sino kirera anna sino gissipatanda, e pataꞌnanganda kappayino barebayino barawasira. ");
INSERT INTO gdg_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Nu umangngira makipangngan, pilinda a pakitutturanino pangafuwanira, e pilinda kappaya pattutturanino attutturanna napatiya tolay sino sinagoga. ");
INSERT INTO gdg_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Angganda a medayawa mapakumusta sino mangita sikwara kadda mallakarira sino palengki, e angganda kappaya maingnganan si mesturu. ");
INSERT INTO gdg_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Udde ikkayu, ammeyu purayan si ingnganandakayuweno bafulundawira si mesturu, se makkakarolakkayu ammin e ikkanappelangino mesturuyu. ");
INSERT INTO gdg_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ammeyu kappenad ingnganan si amayuweno massiki inya a kakkolaꞌdaw sito lubag, se tata ke ino Amayuwa i Dios sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ammeyu kappay purayannino bafulundawira a mingngan si afu sikwayu, se ikkanappelanga Kristoweno afuyu. ");
INSERT INTO gdg_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ino masserbi sino bafulunnera, antuneno kapatiyan sikwayu. ");
INSERT INTO gdg_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Se ino miyantaw sino baggina, itabbafa i Dios, udde ino mitabbafa sino baggina, iyantonana.” ");
INSERT INTO gdg_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","Netuluyi Jesus a nassapit si, “Kakallakkayuna a mammesturuwerana lintig anda Fariseo! Massasannakangkayu! Kunnangke iyakuꞌdawino kayatana sumallungan naddino tolayira sino patturayani Dios. Se ammeyu anggamma mesapat sino patturayanna anna iloꞌdokappayino tolayira a manggam. ");
INSERT INTO gdg_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Kakallakkayuna a mammesturuwerana lintig anda Fariseo! Massasannakangkayu! Se balabaliyandawino bafaluwera ta appandawino kukwara andino bafalera, e makkararaggayu si asoddag ta pangalladdaw sino narakkatta aggangwayu. Nadammattingkeneno kastiguyu! ");
INSERT INTO gdg_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Kakallakkayuna a mammesturuwerana lintig anda Fariseo! Massasannakangkayu! Se maddadammangkayu sino bebaya umang mannodoyug si palulubbun takesi mawiskayu si massiki tata a mabbali si adalandaw. Nu wara awisandaw, tuntulandeno aggangwayu kiyad si marrarakkattira amma sikwayu, e kumarallingkeneno kastigura sey infiyernu. ");
INSERT INTO gdg_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Kakallakkayuna! Kunnangke lappakkayuwa mifuyut si dalan se manuldukayu, massiki awana ammuyu. Se itulduyu si nu wara misapata sino Templo, bakkanna liwaꞌna nu ammena akwanino nesapatana, udde nu ino bulawan sino Temploweno isapatana, liwaꞌna nu ammena akwan. ");
INSERT INTO gdg_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Lappakkayu anna ammekayu makadandam! Sanna kaddino mas napatig? Ino bulawan onnu ino Templo a nappabali sino bulawan si nadiosan? ");
INSERT INTO gdg_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Itulduyu kappay si nu wara misapata sino assikkulanda sino mewaꞌlat ki Dios, bakkanna liwaꞌna nu ammena akwanino nesapatana, udde nu ino newaꞌlat sino assikkulanino isapatana, liwaꞌna nu ammena akwan. ");
INSERT INTO gdg_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Lappakkayu gakkurug! Sanna kaddino mas napatig? Ino newaꞌlat onnu ino assikkulana nappabali sino newaꞌlat si nadiosan? ");
INSERT INTO gdg_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Ino assikkulanino mas napatig, e ino misapata sino assikkulan, bakkampelang inayino isapatana, nu ammena kappelurino newaꞌlat sinay. ");
INSERT INTO gdg_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","E ino misapata sino Templo, bakkampelang inayino isapatana, nu ammena kappeluri Dios a makwan balay. ");
INSERT INTO gdg_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Kunna kappayino misapata sino langit, bakkampelang inayino isapatana, nu ammena kappelurino tronowi Dios anna i Dios a aggatuttud sinaya matturay. ");
INSERT INTO gdg_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Kakallakkayuna a mammesturuwerana lintig anda Fariseo! Massasannakangkayu! Se nattalaginaggayuwa mangaꞌda sino pakkatafuluneno mulayu, massiki ino kaddatta meusar si rikadu, udde ammeyu tuntulannino napatiya tunino lintiya massapit si naggaddangngaddino akwandaw sino bafulundaw, naallakkayu nad sikwara, anna matalakkayu. Ira nad yawino tuntulandaw e tuluyandokappayino korwan. ");
INSERT INTO gdg_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Gakkuruwa lappakkayuwa mifuyut! Kakunnayuweno tolaya paparanneno ilak sino inumanna, gampade sillunanneno kamelyu si tasillunan. Se maddararangkayu sino bibissangnga liwaꞌdaw, gampade ammeyu dandammannino darokkalla liwaꞌdaw. ");
INSERT INTO gdg_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Kakallakkayuna a mammesturuwerana lintig anda Fariseo! Massasannakangkayu! Se uwatandawino lasinneno tasayu andino likunneno duyuddaw ta tuntulandawino lintig, gampade narakkattino iyekwayu sinay se naggabwat sino kinadarogaꞌdaw. ");
INSERT INTO gdg_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Lappakkayuwa Fariseo! Palungundonadda dalusanino dolammeno tasa a mibbatta mangwa si kunnenoy e nadalus kappeneno lasinna. ");
INSERT INTO gdg_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Kakallakkayuna a mammesturuwerana lintig anda Fariseo! Massasannakangkayu! Kakunnayuweno pantiyona napinturan si nafuraw. Nalawaringke a itan, udde napannu si tulangnga natay andino korwana kaddadakkut. ");
INSERT INTO gdg_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Mekunnakayu sinay se nalawarino aggangwayu sino angngitana tolay, udde ino kakuruwanna, massasannakangkayu anna passiya narakkattino ana sino nakandaw. ");
INSERT INTO gdg_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Kakallakkayuna a mammesturuwerana lintig anda Fariseo! Massasannakangkayu! Se mangwakayu si nalawara pantiyonin gumalabbunira a pinapatayino gagginafuyuwera siꞌin e artiyandokappayino pantiyonin naggaddangngira a tolay. ");
INSERT INTO gdg_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","E sapitandaw si, ‘Nu nagyangkami nad sin tiyempowenin gagginafumiyera, ammekami nad nesapata namapatay sin gumalabbunira.’ ");
INSERT INTO gdg_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Gafu se kunnenayino sapitandaw, ipunnuyu si gakagakarakayuweno namapatayira sin gumalabbunira. ");
INSERT INTO gdg_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Ara mantu, itupaꞌdawino neyafuwenin gagginafuyuwera. ");
INSERT INTO gdg_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Kunnangke ulaggayuwa manuntul sino aggangwenin gagginafuyu. Ammeyu maliꞌwanino kakastiguwandaw sey infiyernu! ");
INSERT INTO gdg_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Se manundunaꞌnga sikwayu si gumalabbunira, mammesturuwera, andino korwanira a nangammu sino sapiti Dios ta tulduwandakayu. Papatayandoneno korwanira anna ilansayuneno korwanira si krus. Siwasiwaꞌwattandoneno korwanira kappay sino sinagogayuwera, e massiki sintawino pabbukalanda, daladaddaggandawirana ta padyatandawira. ");
INSERT INTO gdg_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Gafu sinay, makastigukayuna a kunnangke ikkayuweno mikaru sino namapatayanda sino ammina naggaddangnga tolay sito lubag nangiyafu ki Abel kiyad ki Zacarias a abbingi Barakias a pinapatayin gagginafuyuwera sino nallatanneno Templo annino assikkulan. ");
INSERT INTO gdg_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Gakkurug yo sapitangku sikwayu, ikkayuwa tolay sito ingkein, makastigukayuna gafu sino napapatayanda ammin.” ");
INSERT INTO gdg_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","Wasinoy, sinapiti Jesus si, “Ikkayuwa tolay sito Jerusalem a nallapalappag anna namapatay sino gumalabbunira andino korwanira a dinunduni Dios! Namipidyantakayuwa anggamma paraꞌnin sikwak ta imutantakayu a kunnangke ino akwanino upa a mangakkab sino piyaꞌngera, udde ammeyu anggam. ");
INSERT INTO gdg_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Antu gafuna, ikkayunnino makammu, se anawandakayuwi Dios. ");
INSERT INTO gdg_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Sapitangku sikwayu si ammerakunna maita makkiyad sino awa passapitandona si ‘Madandayawino gumamwanga dinunduni Dios.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Wasin umanawi Jesus sino Templo, inaraꞌniyeno adalannera ta ipaitara sikwaneno kinalawanneno Templo andino bafalay sino lebanna. ");
INSERT INTO gdg_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Udde sinapiꞌna si, “On, itandawira nad. Gakkurug yo sapitangku sikwayu, madaꞌnganeno awa madarallira ammin. Awaningkena tata si batuwa mabattang sino agyananna, se maduduwirana ammin.” ");
INSERT INTO gdg_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Wasinoy, inangngira sino kulura Olivo, e nattutturi Jesus. Inaraꞌniyeno adalannera a ira pelang, e sinapiꞌda si, “Ituldum abbu sikwami nu naanseno kaangwannenaya sinapiꞌnu, anna sannaneno senyala pilasinammi si araꞌniyennino puliyannu annino pakkiyaranna yo lubag?” ");
INSERT INTO gdg_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Netabbi Jesus si, “Palanandaw ta ammekayu mabalabaliyan. ");
INSERT INTO gdg_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Se odduweraneno gumamwanga massapit si, ‘Ikkanaki Kristo a dinunduni Dios a matturay,’ e odduneno balabaliyanda. ");
INSERT INTO gdg_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Dingngaggandokappeneno maggagarubattira sino araꞌni sikwayu annino damag mappeafu sino gubat sey korwana lubbun, udde ammekayu nad mattalaw. Maawag si makwerana yaw, udde bakkangkepayino uddina aw. ");
INSERT INTO gdg_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Se maggagubaꞌneno naddadaruma a lulubbun, mampesino patturayandera. Ananeno nafulota bisin e maluniggappena si palulubbun. ");
INSERT INTO gdg_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Udde amminira yaw, gafuna pelangino kadyatan a kunnangkeno loneno kuyungnga gapapanak. ");
INSERT INTO gdg_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Sinoyna a tiyempo, doꞌmandakayuna ta padyatandakayu anna papatayandakayu. Ammina tolay, kababannaddakayuna gafu sino kesapatandaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","E odduneno manalekkud sino angngurudda sikwak, e kababannaddeno bafulundera e idarundera. ");
INSERT INTO gdg_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Odduneno gumamwanga massisiriya massapit si gumalabbunira i Dios, e odduneno balabaliyanda. ");
INSERT INTO gdg_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Gafu se umoodduweno narakkat, bumibissangngino agganggammino kaodduwan. ");
INSERT INTO gdg_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Udde ino mattalaginara mangurug kiyad si madaꞌngeno uddina, mesalakanna. ");
INSERT INTO gdg_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","E ino nalawara damag mappeafu sino patturayani Dios, mebanyangnga si palulubbun sito lubag takesi dingngaggan ammina tolay, kasena madaꞌngeno uddina aw.” ");
INSERT INTO gdg_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Netuluyi Jesus a nassapit si, “Meyakkurungngeno nelabbuni Daniel a ananeno ‘kattalatalawingke a manandaral’ a mattaꞌdag sino nadiosana agyanan. (Ino mabbasa sitaw, maawatanna naddino anggamma sapitan.) ");
INSERT INTO gdg_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Nu itandonenay, ino magyanira sey Judea, mabbukalira nadda umang sino kakuluran. ");
INSERT INTO gdg_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Inona agyan sino lasinneno balena, ammenan nad sumallunga mappa si iyangkalinna. ");
INSERT INTO gdg_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Kunna kappeneno magyan sino umana, ammenan nad umapita mappa sino barawasina. ");
INSERT INTO gdg_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Sinoyna a tiyempo, kakallaꞌngeno mabussitira andino mappasusuwera. ");
INSERT INTO gdg_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ikararaddaw ta ammena nad medemmuweno pabbukalandaw si aggururan onnu si awna aggimwangan. ");
INSERT INTO gdg_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Se sinoyna a tiyempo, nappelaloꞌneno dyat, e awana kakunnana mangiyafu sin naparatuwanna yo lubag kiyad to ingkein, e ammenan mepipidwa si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Nu amme nad dinandammi Dios a arananino awnenaya kadyatan, awan nadda mabuna si tolay sito lubag. Udde gafu sino allaꞌnga sino pinilinera a tolena, aranannana.” ");
INSERT INTO gdg_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Netuluyi Jesus a nassapit si, “Sinoyna a tiyempo, nu wara massapit sikwayu si ‘Itandaw, ayawinnino Kristo’ onnu ‘Anen sinay,’ ammeyu kuruwan. ");
INSERT INTO gdg_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Se odduneno massan Kristo andino massasanlabbuna massapit si ireno dinunduni Dios. Mipaiterana si kakkaꞌbawa senyal anna milagro takesi balabaliyanda naddino tolayira, massiki ino tolayira a piniliyi Dios, nu damana. ");
INSERT INTO gdg_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Kunnantu, mappalangkayu, se dinadangkuwa sinapitira yaw sikwayu. ");
INSERT INTO gdg_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Antu gafuna, nu wara massapit si ‘Itandaw, agyanino Kristo sino kalolowat,’ ammeyu nad umang itan. Nu sapitanda kappay si ‘Itandaw, ana sitawa ammena mappadda,’ ammeyu kuruwan. ");
INSERT INTO gdg_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Se ino puliyangkuwa Abbingnga Tolay, kunnangke ino kilata itan ammina tolay nu mangilat sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Gakkuruwingke a makwerenay a kunnangke ino sapitanda si, ‘Massiki sintawino agyananino natay, antuweno pakkakarampattanino mammanukira.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Nanu masindu ammin inaya dyat, mallammuꞌngeno sinag anna ammenana maddakkag. Madaraꞌnangngeno bitunira, se maguyaddino ammina ana sey langit. ");
INSERT INTO gdg_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ananeno senyal sey langita pilasinan si araꞌniyennino puliyangkuwa Abbingnga Tolay, e maloneno nakam ammina tolay sito lubag gafu se araꞌniyennino kaukumanda. Itandaꞌnga a Abbingnga Tolaya maggabwat sey langita mebulun si dulam. Itandana kappayino pannakadamak andino nappelalota kedayawangku. ");
INSERT INTO gdg_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Ananeno natuyagga damiꞌna tangguyub, e dundunangkuneno anghelkuwera sino pampangnga yo lubag ta pakkakarampattandeno tolekira a pinilik sino palulubbun sito lubag.” ");
INSERT INTO gdg_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Wasinoy, sinapiti Jesus si, “Dandammandonaddino kayuwa igos ta wara padalandaw. Nu mallalimuddutino tangatangana e mandadaron, ammuyu si araꞌniyennino dawun. ");
INSERT INTO gdg_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Kunna kappay, nu itandawa makwa ammina sinapikku sikwayu, ammuyun si araꞌniyennino puliyangku. ");
INSERT INTO gdg_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Gakkurug yo sapitangku sikwayu, ananeno korwanira sikwayuwa ammera matay liyeya meyakkurug amminino sinapikku. ");
INSERT INTO gdg_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Maawanneno langit anyo lubag, udde ammenana maawanino sapikku si makkikiyad, nu ammena lud meyakkurug ammin.” ");
INSERT INTO gdg_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Sinapikkappayi Jesus si, “Awana makaammu nu sannaneno aw anna oratta keyakkuruwanino sinapikku mappeafu sino puliyangku. Ino anghelira sey langit, ammera ammu, anna massiki ikkanaka Abbingnga Tolay, ammek kappay ammu. Se awana mangammu nu bakkampelangi Dios a Ama. ");
INSERT INTO gdg_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Inona akwanino tolayira sino awa puliyangkuwa Abbingnga Tolay, kunnaneno nakwa sino tiyempowi Noe. ");
INSERT INTO gdg_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Se sinoya tiyempo liyeya nallinang sito lubag, netulutuluyda a nangngan, napparinum, anna nangatawa kiyad sino awa sinallunda Noe sino dokalla abanga inangwana. ");
INSERT INTO gdg_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ammera inammu si araꞌniyenna makwa sikwareno kattalatalaw kiyad si nallinang sito lubag e nalimattira ammin. Kunnana kappayino makwa sino puliyangkuwa Abbingnga Tolay. ");
INSERT INTO gdg_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Sinoyna a aw, nu warana adwa a lallakiya mattarabafu sino umara, maappaneno tata e mabattangino tata. ");
INSERT INTO gdg_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nu warana adwa a bafabbaya aggegiligiling, maappaneno tata e mabattangino tata. ");
INSERT INTO gdg_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Antu gafuna, kanayungkayu nadda maddadan, se ammeyu ammuweno awa puliyanino Afuyu. ");
INSERT INTO gdg_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","“Dandammandaw yaw. Nu ammu naddino makwan balayino oratta gumwanganino gumatakaw, ammena nad maturug ta amme makatallungino gumatakaw. ");
INSERT INTO gdg_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Kunnantu, kanayungkayu nadda maddadan, se ikkanaka Abbingnga Tolay, gumamwangaꞌnga sino oratta ammeyu innanaman si gumamwangangku.” ");
INSERT INTO gdg_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Niyampariyi Jesus a nassapit si, “Ino matalak anna madandamma aripan, antuweno dotukanino amungnga a makammu sino korwana aripanna anna mangaꞌda sino akkananda si kadda aw. ");
INSERT INTO gdg_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Nagasat inaya aripan nu magamwanganino amungnga a mangwa sino nepakwana. ");
INSERT INTO gdg_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Gakkurug yo sapitangku sikwayu, gafu se matalak, dotukangkappayino amungnga a makammu sino ammina kukwana. ");
INSERT INTO gdg_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Udde nu narakkaꞌnad inaya aripan, kunna nakuy sino nakamma si, ‘Mabayaggepayino puliyanino amungku.’ ");
INSERT INTO gdg_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","E padyatanneno bafulunnera a aripan, e makakakkan anna makininumira andino bafulunnera a minabbobok. ");
INSERT INTO gdg_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","E kakaꞌmeng kelanga gumamwangino amungnga sino aw anna oratta amme innanaman inaya aripan. ");
INSERT INTO gdg_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Kastigunnangkena e isapaꞌna sino korwanira a ammena matalakka metakkub sey infiyernu takesi mattatarangitirana anna mangngarangaritammira.” ");
INSERT INTO gdg_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Netuluyi Jesus a nassapit si, “Ino manggammira a mesapat sino patturayani Dios sino puliyangku, meyampariyira si tafuluwa bafalatanga nappa si sittatara a lampara ta umanda dambalannino lalakiya mangatawa. ");
INSERT INTO gdg_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ino lima sikwara, pangababulannira, udde ino limera, nadandammira. ");
INSERT INTO gdg_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ino limera a pangababulan, niyangkalinira sino lamparara, udde nakalyawanda a nangappa si reserbara a lana. ");
INSERT INTO gdg_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Udde ino nadandammira, niyangkalinira sino lamparara anna reserbara a lana. ");
INSERT INTO gdg_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Gafu se ammena nalana ginamwangino lalakiya mangatawa, natatukappira e nakaturuwanira. ");
INSERT INTO gdg_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Wasin tangngenna gafi, aneno nikulawuwa nassapit si, ‘Anennino mangatawa! Umandaw dambalan!’ ");
INSERT INTO gdg_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Ginabwatino tafuluwera a bafalatang e nedadandeno lamparara. ");
INSERT INTO gdg_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Sinapitino limera a awana reserbara sino bafulundera si, ‘Aꞌdandakami abbu sino lanayu, se gaaaddappinnino lamparami.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","‘Ammena dama,’ kunnino nadandammira, ‘se ammena makabalinino reserbami sikwatam ammin. Umangkayullang sino allakuwan ta maggatangkayu si akwayu.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Antuweno inangngira naggatang. Udde wasin inanawiran, ginamwanginnino lalakiya mangatawa. Ino limera a bafalatanga aggatarona naddadan, nebulunira sino lalakiya sinallung sino pakkasaran, e neyakutinnino lamwangan. ");
INSERT INTO gdg_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Ammena mabayag e ginamwangino bafalatangira a inang naggatang, e nekokwara a nassapit si, ‘Afu, Afu! Sumallungkami pay!’ ");
INSERT INTO gdg_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Udde sinombatino mangatawa si, ‘Ammena dama, se ammetakayu ammu.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wasinoy, neyabambuti Jesus a nassapit si, “Antuweno kanayungkayu nadda maddadan, se ammeyu ammuweno aw anna oraꞌneno puliyangku.” ");
INSERT INTO gdg_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Netuluyi Jesus a nassapit si, “Ino makwana sino patturayani Dios sino puliyangku, meyamparig si kunnayaw. Aneno tata a lalakiya naddadana umang si aroyuwa lubbun. Inayanneno aripannera ta italaꞌngeno kinabaꞌnangnga sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Inaꞌdanneno kadda tata sikwara sino piraꞌnga a meannung sino kinalainda. Ino tata, naꞌdanna si limarifu, ino tata, naꞌdanna si adwarifu, e ino tata kappay, naꞌdanna si tarifu, kasena inanaw. ");
INSERT INTO gdg_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","“Wasinoy, ino nitalakkanna si limarifu, nalana nenigosiyona, e nagganansiya si limarifu kappay. ");
INSERT INTO gdg_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Kunna kappayino nitalakkanna si adwarifu, adwarifu kappayino ganansiyana. ");
INSERT INTO gdg_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Udde ino nitalakkanna si tarifu, inangnga nekokkob inaya pirakino amungnga. ");
INSERT INTO gdg_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Wasin nabayin, nuliyennino amunda a nitalak si pirak sikwara, e inayannera ta ammunna nu pidyeno ganansiyara. ");
INSERT INTO gdg_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Inang sikwaneno nitalakkanna si limarifu, neyaꞌdaneno tafulurifu, e sinapiꞌna si, ‘Afu, limarifuweno netalaꞌngu sikwak. Ayokappayino limarifuwa ganansiyak.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","‘Nalawarino inangwam,’ kunnino amungnga. ‘Nalawad anna matalakka a aripan. Gafu se natalakka sino bissangnga neyaꞌdak sikwam, oodduneno italakku sikwam. E mesapakka kappaya makilanggak sikwak.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Wasinoy, inampay sikwaneno nitalakkanna si adwarifu, neyaꞌdaneno appatarifu, e sinapiꞌna si, ‘Afu, adwarifuweno netalaꞌngu sikwak. Ayokappayino adwarifuwa ganansiyak.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","‘Nalawarino inangwam,’ kunnino amungnga. ‘Nalawad anna matalakka a aripan. Gafu se natalakka sino bissangnga neyaꞌdak sikwam, oodduneno italakku sikwam. E mesapakka kappaya makilanggak sikwak.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Wasinoy, inampay sikwaneno nitalakkanna si tarifu, neyaꞌdaneno tarifu, e sinapiꞌna si, ‘Afu, ammuk si ammemungke nu wara bissang. Se magganansiyaka sino ammem nallingattan a kunnangke buwatannuweno ammem nemula. ");
INSERT INTO gdg_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Antuweno mattalawak sikwam e nekokkogguweno piraꞌngu. Ayawin sitaw, iyulikun.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","‘Narakkat anna natarukkangke a aripan,’ kunnino amungnga. ‘Nu ammum si kunnenoya magganansiyak sino ammek nallingattan anna buwatangkuweno ammek nemula, ");
INSERT INTO gdg_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","mayan ammem mantu nebangkuweno pirakku takesi wara nad appangku si ganansiya sito nuliyangku?’ ");
INSERT INTO gdg_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","E sinapitino amungnga sino korwana aripanna si, ‘Appandaw yaw tarifuna ta iyaꞌdayu sino aripanna aneno tafulurifuna. ");
INSERT INTO gdg_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Se ino matalakka musar sino kinalaingnga, madadagganan takesi oodduweno ana sikwana, udde ino ammena matalak anna matarut, massiki ino bissangnga ana sikwana, maawanna. ");
INSERT INTO gdg_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","E inaya aripanna awana serbina, itakkuddaw sino kalammukan takesi mattangit anna mangngaritamma sinay.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Netuluyi Jesus a nassapit si, “Nanu muliyaka Abbingnga Tolaya mangipaita sino kedayawangkuwa mebulun sino ammina anghel, mattutturaꞌnga a matturay anna mangukum. ");
INSERT INTO gdg_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Amminna a tolay sito lubag, makkakarampattirana a umaꞌlang sikwak, e ipassigguneno naggaddangngira sino korwanira a kunnangke ino akwanino mimut si animala mipassig sino karnero annino galding. ");
INSERT INTO gdg_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ino naggaddangngira a tolaya meyamparig si karnero, iyekwakirana sino padiwanangku, e ino meyampariyira si galding, iyekwakirana sino padawik. ");
INSERT INTO gdg_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ikkanaka ari, sapitangkuna sino tolayira sino padiwanangku si, ‘Ikkayuwa inallakki Ama, umangkayu taw e sumallungkayu ta makiagyangkayu sino patturayani Dios a nedadanna para sikwayu nangiyafu sin naparatuwanna yo lubag. ");
INSERT INTO gdg_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Se nabisinanak e pinakkandak, nauwawak e pinainundak. E massiki ammerak kalubbunan, nepadiloꞌdak. ");
INSERT INTO gdg_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Wasin awana barawasik, binarawasiyandak. Wasin natakitak, inimuꞌdak. Wasin nabalurak, binisitarak.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ino naggaddangngira a tolay, isombaꞌdana si, ‘Afu, kanseno nangitammi sikwama nabisinan e pinakkammika, onnu nauwoka e pinainummika? ");
INSERT INTO gdg_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Kanseno nappadilotammi sikwam onnu namarawasiyammi sikwam? ");
INSERT INTO gdg_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Kansa kappayino natakitannu e inimuꞌmika, onnu nabalugga e binisitamika?’ ");
INSERT INTO gdg_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ikkanaka ari, sapitangkuna si, ‘Gakkurug yo sapitangku sikwayu, sin nangwandawira sinay sino massiki tata a kaabbafawana kolakku, ikkanakino nangwandaw.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Sapitangkuna kappay sino tolayira sino padawik si, ‘Ikkayuwa meannunga makastigu, umaroyukayu sikwak! Agyangkayuna sino afuya ammena maaddappa nedadan para ki Ofag andino anghelnera. ");
INSERT INTO gdg_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Se sin nabisinanak, ammerak pinakkan, e sin nauwawak, ammerak pinainum. ");
INSERT INTO gdg_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Sin inangngak sino lubbundaw, ammerak nepadilot, e sin awana barawasik, ammerak binarawasiyan. Sin natakitak anna nabalurak, ammerak binisita.’ ");
INSERT INTO gdg_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Isombaꞌdana sikwak si, ‘Afu, kanseno nangitammi sikwama nabisin onnu nauwaw, awana pagyanannu onnu awana barawasim, natakit onnu nabalugga, e ammemika dinuffunan?’ ");
INSERT INTO gdg_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","E kungkuna a ari si, ‘Gakkurug yo sapitangku sikwayu, sin ammeyu dinuffunanino tata a kaabbafawana kolakku, ikkanakino ammeyu dinuffunan.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Wasinoy, inabambutani Jesus a nassapit si, “Iranayawino makastigu si makkikiyad, udde inona naggaddangngira a tolay, maaꞌdanirana si biyaya mannayun.” ");
INSERT INTO gdg_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Wasin nasinduwi Jesus a nassapit sinay, sinapiꞌna sino adalannera si, ");
INSERT INTO gdg_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ammuyu si adwa aw kaseneno fiyestana Laꞌwutan, e ikkanaka Abbingnga Tolay, meyalawataꞌnga ta melansak sino krus.” ");
INSERT INTO gdg_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Sinoya aw, nakkakarampattino pangafuwanirana padi andino korwanira a pangafuwanna Judyu sino balayi Caifas a afafuna padi ");
INSERT INTO gdg_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ta pattatarabbanda nu ansandeno mappadoꞌma ki Jesus a awana makaammu takesi papapatera. ");
INSERT INTO gdg_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Udde sinapiꞌda si, “Ammetammad iyindan sino fiyesta, tantaro nu makungkulino tolayira.” ");
INSERT INTO gdg_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Wasin agyanda Jesus sey Betania, inangngira sino balera Simon a nakkutal siꞌin. ");
INSERT INTO gdg_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Sin aggekakkanira, inaraꞌni ki Jesusino tata a bafaya niggam si beduruwa naangwa si alabastrowa napannu si nangina a bambangug, e nesibungnga sino uluna. ");
INSERT INTO gdg_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Wasin initeno adalannera, nabbungutira, e sinapiꞌda si, “Mayan tatangganna pelangino bambangug? ");
INSERT INTO gdg_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Nelakuna nad si nangina, ta wara iyaꞌdana sino mekakallakkira.” ");
INSERT INTO gdg_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Udde ammuwi Jesusino sapitanda, e sinapiꞌna si, “Sandolang balawan inaya bafay? Nalawarino inangwana sikwak. ");
INSERT INTO gdg_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Se ino mekakallakkira, kanayuna anera sikwayu, udde sikwak, ammek mabaya makiigyan sikwayu. ");
INSERT INTO gdg_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nesibungngeno bambangug sikwak takesi idadanneno baggik liyeneno ketanammangku. ");
INSERT INTO gdg_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Gakkurug yo sapitangku sikwayu, massiki sintawa lubbun sito lubaggino kebanyanneno nalawara damag, masapikkappeneno inangwa yawa bafay ta panandammanino tolayira sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Wasinoy, ino tata sino karadwera a adalani Jesus a i Judas Iscariote, inang sino pangafuwanirana padi, ");
INSERT INTO gdg_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","e sinapiꞌna si, “Pidyeno iyaꞌdayu sikwak nu duffunantakayuwa manoꞌma ki Jesus?” E naꞌdanda si tallufuluwa pirak. ");
INSERT INTO gdg_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Mangiyafu sinay, neyafunana manandam sino nalawara tiyempowa pappadoꞌmanna ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Wasin awa pangiyafuwanino fiyestana Tinapaya Awan Lebadurana, inangngino adalanira i Jesus sikwana, e nebebuꞌda si, “Sintawino anggammuwa pidadanammi sino akkanantam sino fiyestana Laꞌwutan?” ");
INSERT INTO gdg_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Sinapiꞌna si, “Umangkayu sey Jerusalem sino agyananino tata a lalakiya ammutam, e sapitandaw sikwana si, ‘Kunnino Afumi si nadaꞌngennino katayanna, e sitawin baleyuweno pakipangnganammi ammin sino fiyestana Laꞌwutan.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wasinoy, inangweno adalannereno netuni Jesus, e nedadandeno pamuwadda. ");
INSERT INTO gdg_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Wasin gafenin, nakiaꞌlangi Jesus sino karadwera a adalanna a mangngan. ");
INSERT INTO gdg_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Wasin aggekakkanira, sinapiti Jesus si, “Gakkurug yo sapitangku sikwayu, aneno tata sikwayuwa makipangngan sikwaka mangifuyut sino manggammira a mamapatay sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Malowingkeno nakanda, e nappatapataliyera a nabbebut sikwana si, “Afu, ikkanaꞌngalangino sapitannu?” ");
INSERT INTO gdg_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Sinabbi Jesus si, “Ino meyindan sikwaka misosaw si tinapay sito malukung, antuneno mangwa sinay. ");
INSERT INTO gdg_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ikkanaka Abbingnga Tolay, gakkuruwa matayaꞌnga takesi meyakkuruwino nepeturakki Dios siꞌin. Udde kakallappeneno mangifuyut sino manggammira a mamapatay sikwak. Unoyna nad nu ammena neyanak!” ");
INSERT INTO gdg_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wasinoy, naddamiti Judas a antuneno mangifuyut sino manggammira a mamapatay ki Jesus. Sinapiꞌna si, “Afu, ikkanaꞌngalangino sapitannu?” “Nu antuweno sapitannu, antu,” netabbi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Wasin aggekakkanira kepay, nappa i Jesus si tinapay e nappasalamat ki Dios, kasena ginaradwa e neyannena sino adalannera a nassapit si, “Appandaw yaw ta akkanandaw, se antuyawino baggik.” ");
INSERT INTO gdg_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","E nangappa kappay si kopa a napannu si diyuna ubas, e nappasalamat ki Dios, kasena neyaꞌda sikwara, e sinapiꞌna si, “Minungkayu ammin sitaw, ");
INSERT INTO gdg_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","se antuyawino adaka mamakurug sino bawuwa tulagi Dios. Se mebubbuneno adak takesi odduneno tolaya mapakomanino liwaꞌda. ");
INSERT INTO gdg_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Sapitangku sikwayu si ammekunna uminum si diyuna ubas kiyad sino awa makiinumak sikwayu si bawuwa diyuna ubas sino patturayani Ama.” ");
INSERT INTO gdg_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Wasinoy, nakkantera si paddayaw ki Dios, e nanawira sinay e inangngira sino kulura Olivo. ");
INSERT INTO gdg_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Wasinoy, sinapiti Jesus sino adalannera si, “Sito kappaya gafi, ikkayu ammin, anawandaꞌnga e mabbukalkayu gafu sino makwana sikwak, se antuweno anggamma sapitannino nepeturakki Dios a kunna si, ‘Papatayangkuneno mimut sino karnerowera, e makkakaratwayiran.’ ");
INSERT INTO gdg_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Udde nu pangngangolindaꞌnga i Dios, untanantakayuna a umang sey Galilea.” ");
INSERT INTO gdg_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Wasinoy, sinapiti Pedro si, “Massiki nu mabbukal amminino bafulungkuwera gafu sino makwana sikwam, ammetaka anawan.” ");
INSERT INTO gdg_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Kunni Jesus sikwana si, “Gakkurug yo sapitangku sikwam, sito gafi, liyeya massirallotino lalung, namiꞌluwannakunna a neimad.” ");
INSERT INTO gdg_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Sinapikkappayi Pedro si, “Massiki nu matayaꞌnga a melot sikwam, ammetakangkena iyimad.” Kunna kappayino sinapitino ammina bafulunnera a adalan. ");
INSERT INTO gdg_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Wasinoy, inanda Jesus andino adalannera sino kakayuwana mingngan si Getsemani, e sinapiꞌna sikwara si, “Mattuttuggayu sitaw ta umangngak makkararag seoy.” ");
INSERT INTO gdg_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ino pelang nebulunna, da Pedro andino adwera a abbingi Zebedeo. Mangiyafu sinoy, malowingkeno nakamma e maddararan, ");
INSERT INTO gdg_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","e sinapiꞌna sikwara si, “Nappelalotingkeno loneno nakangkuwa kunnangke antuweno ipatek. Agyangkayu sitaw ta makipabbiraggayu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Wasinoy, nebakkangi Jesus sikwara, kasena nassakabba makkarara massapit si, “Ama, nu damana, iliꞌwarak sitawa dyata araꞌniyenna makwa sikwak. Udde bakkan naddino anggangkuweno makwa, nu ammena lurino panggammannu.” ");
INSERT INTO gdg_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Wasin nuliyi Jesus sino agyananino talluwera a adalanna, dinaꞌnganera a maturug. Antuweno sinapiꞌna ki Pedro si, “Ma, ammekayu kad makattamma makipabbirag sikwak si taoraꞌlang? ");
INSERT INTO gdg_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ammekayu maturug, nu ammekayu lud makkararag, takesi ammekayu matutunggungan. Se ammukino nakandaw, anggandawa mangurug, udde nakafuy langino baggiyu.” ");
INSERT INTO gdg_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Nebakkang kappayi Jesus a nakkarara nassapit si, “Ama, nu ammek meliꞌwa sitawa dyata makwana sikwak, iyattangku, takesi makweno panggammannu.” ");
INSERT INTO gdg_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nuli kappay sino agyananino talluwera a adalanna, e dinaꞌnganera kappaya aggakaturug, se matatukappirangke. ");
INSERT INTO gdg_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Inanawannera kappay, e nepiꞌluna a nakkararag, e antu kappayino nekararangnga. ");
INSERT INTO gdg_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Wasinoy, nan-uli sino talluwera, e sinapiꞌna si, “Aggakaturuggayu kepaya mimwang? Nadaꞌngennino oratta keyalawatangkuwa Abbingnga Tolay sino minalliwatira a tolay. ");
INSERT INTO gdg_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Gumabwakkayu, se anennino mappadoꞌma sikwak. Antam dambalan.” ");
INSERT INTO gdg_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Wasin aggedamadamikkepayi Jesus, ginamwangi Judas a tata sino karadwera a adalanna. Odduweno tolaya nebulun sikwana a nassisaset anna nassibafaꞌgung. Ireno dinundunino pangafuwanirana padi andino korwanira a pangafuwanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Agyanino sinapiti Judas sino bafulunnera ta maimunuwanda i Jesus. Kunna si, “Inona ummangku, antuneno doꞌmandaw.” ");
INSERT INTO gdg_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Kinangkamani Judas a inaraꞌni ki Jesus e sinapiꞌna si, “Afu, ayokami.” E inummana. ");
INSERT INTO gdg_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Sinapiti Jesus si, “Akwannunnino gakkannu.” Inaraꞌniyeno tolayira ki Jesus, e dinoꞌmanda. ");
INSERT INTO gdg_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ino tata a buluni Jesus a aggataꞌdag sinay, sinuꞌnuꞌneno saseꞌna, e binakangngeno aripannino afafuna padi e nagingaranino layangnga. ");
INSERT INTO gdg_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Udde sinapiti Jesus sikwana si, “Iyimfunnu yan saseꞌna. Se ino mamapataya musar si saset, saseꞌpeneno ipatena. ");
INSERT INTO gdg_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Ammengkad ammu si nu marangngak si duffun ki Ama, manundun si kawalufulu si adwarifuwa anghela misalak sikwak? ");
INSERT INTO gdg_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Udde nu antuweno akwangku, ansanna meyakkuruwino neturakka sapiti Dios a sapitanna si maawag si makwa yaw?” ");
INSERT INTO gdg_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Wasinoy, sinapiti Jesus sino tolayira si, “Ma, narakkattaka tolay ta nassisaset anna nassibafaꞌgungkayuwa umang manoꞌma sikwak? Kadda awa aggatutturak sino Templo a manuldu sikwayu. Mayan bakkanna sinayino nanoꞌmandaw sikwak? ");
INSERT INTO gdg_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Udde nakwa ammin yaw takesi meyakkuruwino nepeturakki Dios sino gumalabbunira.” Sin nassapitani Jesus sinay, nabbafukal amminino adalannera e nananawanda. ");
INSERT INTO gdg_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Wasin dinoꞌmanda i Jesus, neyanda sino balayi Caifas a afafuna padiya nakkakarampattanino mammesturuwerana lintig andino korwanira a pangafuwanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Dumadandani Pedro sino gafanda kiyad si ginamwang sino kalawatan inaya balay, e inang nakituttud sino gwardiyera kesi itanneno makwa ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ino pangafuwanirana padi andino korwanira a nakkakarampat, niintufukira si pamakurudda a pappaliwatanda ki Jesus, massiki nu ammena gakkurug, ta akiranda a pamapatayan sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Udde awana sinumpalanda, massiki odduweno manistigu si siri mappeafu sikwana. Wasinoy, agyanino adwera a tolaya ");
INSERT INTO gdg_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","nassapit si, “Iyawa tolay, sinapiꞌna si damana a darallannino Templowi Dios, kasena pataꞌdaggan si tallu aw.” ");
INSERT INTO gdg_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wasinoy, nattaꞌdaggino afafuna padi, e sinapiꞌna ki Jesus si, “Ma, awana isombaꞌnu sino ipaliwaꞌda sikwam?” ");
INSERT INTO gdg_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Udde sininappelangi Jesus. Antuweno sinapikkappayino afafuna padi si, “Isapatammad ki Dios a aggabiyag ta ituldum sikwami nu gakkuruwa ikka i Kristo a Abbingnga.” ");
INSERT INTO gdg_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","“On, gakkuruwino sinapiꞌnu,” kunni Jesus. “Udde ino sapitangku sikwayu, itandaꞌnga a Abbingnga Tolaya aggatuttud sino padiwanani Dios a mannakadama. Itandak kappena a muliya maggabwat sey langita mebulun si dulam.” ");
INSERT INTO gdg_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Wasin diningngangngenay, pinissayino afafuna padiyeno barawasinangkepaya mangipaita sino bunguꞌna, e sinapiꞌna si, “Ikunnaneno baggina ki Dios! Anna kepayino awantama manistigu? Diningngaddam amminino narakkatta sinapiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Sanneno ureyuwa makwa sikwana?” “Nalliwat, e mapapatenad!” kunda. ");
INSERT INTO gdg_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","E ilupaluppandeno mutungnga anna sinatampalanda. Ino korwanira, sinipasipanda ");
INSERT INTO gdg_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","a nassapit si, “Ikka a Kristo, nu gumalabbungka, sapitannu nu inyeno nanipang sikwam.” ");
INSERT INTO gdg_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Aggatuttuggepayi Pedro sino kalawatan sin inaraꞌniyeno tata a balatanga aripan sikwana, e sinapiꞌna si, “Massiki ikka, nebumbulangka ki Jesus a taga-Galilea.” ");
INSERT INTO gdg_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Udde neimanna sino naraꞌlanganda ammin, e sinapiꞌna si, “Ammek ammu yan sapitannu.” ");
INSERT INTO gdg_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Wasinoy, inangngi Pedro sino pampangnga kalawatana araꞌni sino lamwangan. Udde agyangkappayino balatanga aripanna nangita sikwana, e sinapiꞌna sino tolayira sinay si, “Inaya lalaki, nebumbulun ki Jesus a taga-Nazaret.” ");
INSERT INTO gdg_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Udde neimaggappayi Pedro a nassapit si, “Isapatak si ammek inammu inaya tolay.” ");
INSERT INTO gdg_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Ammena mabayag e inaraꞌniyeno tolayira sinay e sinapiꞌda si, “Gakkuruwa tataka sikwara, se melasin sino addamiꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","E nesapata i Pedro si, “Massiki matayak nu ammena gakkurug yo sapitangku. Ammek gakkuruwa ammu yana tolay.” Assapiꞌna lang sinoy, nassirallotinnino lalung. ");
INSERT INTO gdg_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","E dinandammi Pedroweno sinapiti Jesus a “Liyeya massirallotino lalung, namiꞌluwannakunna neimad.” E nallawani Pedro e nakatangatangit. ");
INSERT INTO gdg_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Wasin gigiꞌbattin, nammamitingino ammina pangafuwanirana padi andino korwanira a pangafuwanna Judyu, e nattatarabbanda nu ansanneno ammapatera ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","E binaludda, kasera inang neyalawat ki Gubernador Pilato. ");
INSERT INTO gdg_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","I Judas a nifuyut sino nanoꞌmera ki Jesus, naammuwanna si nasentensiyani Jesus a matay, e nammoboli sino inangwana. Wasinoy, neyulineno tallufuluwa pirak sino pangafuwanirana padi andino korwanira a pangafuwan, ");
INSERT INTO gdg_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","e sinapiꞌna si, “Nakaliwatak, se nepadoꞌmakino tolaya awana liwaꞌna.” “Awaninna ammumi sitan,” kunda sikwana. “Ikka pelangino makammu.” ");
INSERT INTO gdg_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Netakkufi Judasino tallufuluwa pirak sino lawummeno Templo, kasena inanaw e inang nappattal. ");
INSERT INTO gdg_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Inaꞌnamino pangafuwanirana padiyeno pirak, e sinapiꞌda si, “Kontara sino lintiddama meyekwa yawa pirak sino aggiittungantam sito Templo, se pagana biyangnga tata a tolay.” ");
INSERT INTO gdg_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","E nattatarabbanda nu sanneno keusaranneno pirak, e dinandanda si iyatanda sino lubangnga tata a maddweng si banga ta pabbalinda si attanamman sino bakkanna kalubbunanda. ");
INSERT INTO gdg_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Antu gafuna, maingnganan inaya lubag si Lubangnga Ada kiyad sito ingkein. ");
INSERT INTO gdg_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Antuweno neyakkuruwanino neturakki Jeremias a gumalabbun siꞌina kunna si, “Inappareno tallufuluwa piraka nattatarabbanino gakagakera i Israel si fustuwa pagana, ");
INSERT INTO gdg_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","e neyatanda sino lubangngeno maddweng si banga, a antuweno sinapiti Afu Dios sikwaka makwa.” ");
INSERT INTO gdg_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Wasinoy, nepaaꞌlanda i Jesus sino gubernador, e inimbistigarino gubernadora nabbebut si, “Ikkeno Arina Judyu?” “Nu antuweno sapitannu, antu,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Udde wasin nepaliwatino pangafuwanirana padi andino korwanira a pangafuwan, awana nesombaꞌna. ");
INSERT INTO gdg_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Antu gafuna, sinapiti Pilato si, “Ammengkad madingngaggino odduwa ipaliwaꞌda sikwam?” ");
INSERT INTO gdg_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Udde ammayingke sinombati Jesus sino nepaliwaꞌda, antuweno nakkaꞌbawino gubernador. ");
INSERT INTO gdg_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ino gagangayino gubernador, kadda fiyestana Laꞌwutan, aneno tata a pallawananna a balud, massiki inyeno anggammino tolayira a arangngan. ");
INSERT INTO gdg_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Sinoya tiyempo, agyanino tata a balura naddinnamag gafu sino kinarakkaꞌneno inangwana a mingngan si Jesus Barrabas. ");
INSERT INTO gdg_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Antu gafuna, wasin nakkakarampattino odduwera a tolay, nebebuti Pilato sikwara si, “Inyeno anggandawa pallawanangku, i Jesus Barrabas onnu i Jesus a maingnganan si Kristo?” ");
INSERT INTO gdg_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Kunnenoyino nebebuꞌna, se ammuna si neyalawaꞌda i Jesus sikwana gafu sino apalda. ");
INSERT INTO gdg_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Ino tata kappay, wasin aggatuttuggepayi Pilato sino tuttunna ukum, nepetulduweno atawana si, “Ammeka lumaꞌlaka mangastigu sitana tolaya awana liwaꞌna, se kattalatalawino sinenakku sino gafi mappeafu sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Udde ino pangafuwanirana padi andino korwanira a pangafuwan, sinutunggungandeno tolayira sinay takesi arangnganda ki Pilato a i Barrabasino pallawananna e i Jesusino papapatena. ");
INSERT INTO gdg_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Antu gafuna, wasin nebebukkappayino gubernador nu inya sikwara a adweno angganda a pallawananna, nesombaꞌda si, “I Barrabas!” ");
INSERT INTO gdg_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","“Nu kunnenoy, sanna mantuweno akwangku ki Jesus a mingngan si Kristo?” kunni Pilato. “Ilansam si krus!” kunda ammin. ");
INSERT INTO gdg_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","“Ma? Sanna maꞌlurino liwaꞌna?” kunni Pilato. Udde neyangkakulawura si, “Ilansam si krus!” ");
INSERT INTO gdg_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Wasin magiꞌna i Pilato si awaninna damana akwan se araꞌniyenna maguluguluweno tolayira, nappaappa si danum e binagguwanneno kamaꞌna sino naraꞌlanganda, e sinapiꞌna si, “Antuyawino mangipaita si ammek lumaꞌlaka mamapatay sitawa tolay. Ikkayuneno makammu!” ");
INSERT INTO gdg_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","E sinombat amminino tolayira si, “Kadde, ikkami andino gakagakamiyereno makammu sino katayanna!” ");
INSERT INTO gdg_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wasinoy, nepallawani Pilatowi Barrabas, udde i Jesus, nepasiwaꞌwaꞌna, kasena neyalawat sino sindaluwera ta ilansara si krus. ");
INSERT INTO gdg_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Wasinoy, netallungino sindaluwera i Jesus sino balayino gubernador, e inaribumbung amminino sindalunera. ");
INSERT INTO gdg_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Binoyanganda e binarawasiyanda si ataꞌnanga barawasiya nalibaga a kunnangke barawasina ari. ");
INSERT INTO gdg_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Binalikokawandeno nasasit, e nesingaꞌda sikwana a kunnangke koronana. Nepiggandeno diwanana kamaꞌna si sikal a kunnangke senyalneno kinaarina. E namaliturira sino aꞌlangnga a nassandayaw sikwana, e sinapiꞌda si, “Madayoka nadda Arina Judyu!” ");
INSERT INTO gdg_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ilupaluppanda, kasera inappeno sikalla nepaigganda sikwana ta antuweno nepamompolda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Wasin nasinduwera a nappoporay sikwana, inarireno nebarawasira sikwana, e nepatalira kappayino dadana barawasina, kasera neyang sino pilansanda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Wasin agyanira kepay sino dalan, dinambaldeno tata a lalakiya taga-Cirene a mingngan si Simon, e pinatuꞌda a nepabuttungino krusi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Wasin ginamwangira sey Golgota, ino anggamma sapitan, ino agyananino takataꞌnga ulu, ");
INSERT INTO gdg_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","painumanda si tayuwa nalamuran si aꞌduwa mappaaranan si malow. Udde wasin sininsimanna, ammena ininum. ");
INSERT INTO gdg_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","E nelansara sino krus. Wasinoy, nabbabinnunutira a naggaradwa sino barawasina, ");
INSERT INTO gdg_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","kasera nattuttura mindag sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Aneno nepikkaꞌda sino kalekeneno uluna a neturakkanino nepaliwaꞌda sikwana a kunna si, “Antuyawi Jesus a Arina Judyu.” ");
INSERT INTO gdg_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Nelansara kappayino adwera gumattakaw sino krusda, tata sino padiwananna, tata sino padawina. ");
INSERT INTO gdg_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ino nattaꞌlifira, wawwarangngiwangnganda a aꞌayoyungana massapit si, ");
INSERT INTO gdg_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Matta kunnu si darallannuweno Templo, kasem kappay pataꞌdaggan si tallu aw? Nu kunnenoy, salakannu antu yan baggim! Nu gakkuruwa Abbindaka i Dios, mulluggan sitan krus!” ");
INSERT INTO gdg_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Kunna kappay, ino pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwan, inaꞌayoyunganda kappayi Jesus a nassapit si, ");
INSERT INTO gdg_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nesalaꞌngeno korwana tolay, udde ammena makaisalak sino bagginangkepay. Antu ke kanuweno Arina Israel. Nu gakkuruwinay, umullungngad sino krus, e manguruggami sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Talakkanna kanuwi Dios e kunna si antuweno Abbingnga. Itantam antu nu anggammi Dios a misalak sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Massiki ino gumattakawira a nelansa si krus sino idangnga, nakiayoyungira kappay sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Wasin alas doseyin, nallammuk ammina palulubbun kiyad si tallu orat. ");
INSERT INTO gdg_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Wasin araꞌniyen si alas tres si fuwab, nekokwa i Jesus a naddamit a nassapit si, “Eli, Eli, lama sabaktani?”, ino anggamma sapitan, “Diosku, Diosku, mayan inanawandak?” ");
INSERT INTO gdg_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wasin diningngaggino korwanira a nagyan sinay, sinapiꞌda si, “Ayanna i Elias.” ");
INSERT INTO gdg_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Nalayawino tata sikwara a inang nangappa si kunnangke kapat. Nesosona si kilam, kasena pinakaw si biltak ta iyaddangnga ki Jesus ta sussupanna. ");
INSERT INTO gdg_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Udde kunnino korwanira si, “Ammembu, ta itantam nu gumamwangi Elias a misalak sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Wasinoy, nakkulawuwi Jesus e natayin. ");
INSERT INTO gdg_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Neyindana napissayino kortina a nanaldak sino Kadidiosana Kwartuneno Templo, a neyafu sino kalekay kiyad sino difafa. Nalunig e nabbartakino batuwera. ");
INSERT INTO gdg_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Nabukkatanino tanammira e nangngangoliyeno odduwera a tolayi Dios a natay siꞌin, ");
INSERT INTO gdg_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","e nallawanira sino tananda. Wasin nangngangoliyenni Jesus, inangngira sey Jerusalem a Nadiosana Lubbun, e odduweno nangita sikwara. ");
INSERT INTO gdg_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Wasin nagiꞌneno kapitanna sindalu andino bafulunnera a mindag ki Jesusino alunig, e initara ammina nakwa, nakatalawira, e sinapiꞌda si, “Gakkurug ikka a Abbingi Dios iyawa tolay.” ");
INSERT INTO gdg_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Oddu kappayino bafabbaya aggadipat sino makwa. Ireno nebumbuluna nanuffun ki Jesus sin naggabwatanda sey Galilea. ");
INSERT INTO gdg_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ino korwan sikwara, i Maria Magdalena, i Maria a inara Santiago anni Jose, annino atawa i Zebedeo. ");
INSERT INTO gdg_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Wasin fuwafin, ginamwangino tata a baꞌnangnga tolaya taga-Arimatea a mingngan si Jose a tata kappaya nangurug ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Inang ki Pilato a narang sino baggiyi Jesus, e sinapiti Pilato si damana a appan. ");
INSERT INTO gdg_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Inappa i Jose ino baggina, e binaꞌbattanna si bawuwa nafurawa sinnun. ");
INSERT INTO gdg_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Neyekwana sino tanamma nad a bawuwa nepangwana a neyabbut si batuwa kunnangke agweb, kasena nangalleling si daꞌdap a paggakuꞌna sino tanam, e inanawin. ");
INSERT INTO gdg_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Agyan sinera Maria Magdalena annino kanganna a i Maria a aggatuttura inaꞌlang sino tanam. ");
INSERT INTO gdg_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Sinoya aw, antuweno paddadananino Judyuwera para sino kadaramaꞌna a awna aggimwangan. Sinoya awna aggimwangan, inangngino pangafuwanirana padi andino Fariseowera ki Pilato, ");
INSERT INTO gdg_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","e sinapiꞌda sikwana si, “Afu, madandammi si sin aggabiyaggepay inaya massisiriya tolay, sinapiꞌna si mangngangolina si tallu aw. ");
INSERT INTO gdg_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Antu gafuna, nalawad nu paindangnguweno tanam kiyad si mekatalluwa aw, tantaro nu umang takawannino adalannereno baggina, kasera sapitan si nangngangoliyen. Nu kunnenoyino akwanda, oodduneno balabaliyanda sinaya sirira amma sino binalabaliyani Jesus sin nassisiriyanna si antuweno Kristo.” ");
INSERT INTO gdg_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","“Mangappakayu mantu si sindalu ta paindaddaw si nalawarino tanamma,” kunni Pilato. ");
INSERT INTO gdg_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Antuweno inanawira e inanda minarkanino batuwa sellanneno tanam ta malasinda nu wara mabbukkat. E nibattangira si sindaluwa mindag. ");
INSERT INTO gdg_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Wasin nasinduweno awna aggimwangan e gigiꞌbattinna Linggu, inang initara Maria Magdalena annino kanganna a i Maria sino tanammi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kakaꞌmeng kelanga nalunig si natuyag, se naddassino tata a angheli Dios a naggabwat sey langit. Kinaroringngeno batuwa nesellad sino tanam, kasena nattutturan. ");
INSERT INTO gdg_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Karririyeno mutungnga a kunnangke kilat e nakafurawingke ino barawasina. ");
INSERT INTO gdg_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nayyaꞌyakkino mindaggira gafu sino talora, e naletwarira a kundangke natay. ");
INSERT INTO gdg_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Udde sinapitino anghel sino bafabbayira si, “Ammekayu mattalaw. Ammuk si tufukandawi Jesus a nelansa sino krus. ");
INSERT INTO gdg_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Udde awanin sitaw, se nangngangoliyen a antuweno sinapiꞌna sikwayu. Umandaw itanino newagganna, ");
INSERT INTO gdg_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","e kangkamandawa umang ituldu sino adalannera a nangngangoliyen, e untanandakayuwa umang sey Galilea. Itandona sinay. Aggadandammandaw yawa sinapikku sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Antu gafuna, nakkangkamira a inanaw sino tanam. Nakatalawira udde maanggammira kappay, e nalayawira a inang nituldu sino adalannera. ");
INSERT INTO gdg_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Wasin aggepalapalayawira, kakaꞌmeng kelanga dinambalira i Jesus, e sinapiꞌna si, “Sintawino angandaw?” Inaraꞌniyera sikwana, namaliturira, e inawakandeno takkina a naddayaw sikwana. ");
INSERT INTO gdg_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","“Ammekayu mattalaw,” kunni Jesus sikwara. “Umandaw ituldu sino kakkolakkuwera ta umangngira sey Galilea e maitaraꞌnga sinay.” ");
INSERT INTO gdg_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Wasin nakaanawinnino bafabbayira, inang sino lubbuna Jerusalemino korwanira a sindaluwa nindag sino tanammi Jesus, e nepakaammura sino pangafuwanirana padi ammina nakwa. ");
INSERT INTO gdg_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Antu gafuna, nammamitingino pangafuwanirana padi andino korwanira a pangafuwan, e nattatarabbandeno akwanda nad. E ino inangwara, pinasussukandeno sindaluwera si odduwa pirak, ");
INSERT INTO gdg_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","e sinapiꞌda sikwara si, “Kunna nad yawino sapitandaw sino tolayira. ‘Sino gafiya aggakaturuggami, ginamwangino adalanira i Jesus e sinakoreno baggina.’ ” ");
INSERT INTO gdg_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Sinapiꞌda kappay si, “Ammekayu mattalaw tantaro nu maammuwanino gubernador yaw, se ikkamiyeno makammuwa makitatabbag sikwana ta ammerakayu ansan.” ");
INSERT INTO gdg_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Antuweno inappeno sindaluwereno pirak e inangwareno netuldu sikwara. Antu gafuna, kiyad sito ingkein, antu kepayino sapasapitannino Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Wasinoy, inangngino kadwafulu si tata a adalani Jesus sey Galilea, sino kulura netulduwi Jesus si umangnganda. ");
INSERT INTO gdg_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Wasin initara i Jesus sinay, naddayawira sikwana, udde ino korwanira, naddaladudwera. ");
INSERT INTO gdg_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Inaraꞌniyanira i Jesus, e sinapiꞌna si, “Neyaꞌda sikwakino ammina kalintiyan sey langit anna sito lubag. ");
INSERT INTO gdg_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Antu gafuna, dundunantakayuwa umang sino ammina lulubbun sito lubag ta tulduwandaw ammina tolay ta mabbaliyera si adalangku. Bawtisarandawira a mangipaita si mesapatira ki Ama, sikwaka Abbingnga, annino Espirituna, ");
INSERT INTO gdg_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","e tulduwandawira a mangurug sino ammina netungku sikwayu. Aggadandammandokappay si kanayunaka mebulun sikwayu kiyad sino uddina aw.”");
INSERT INTO gdg_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Antuyawino nalawara damag mappeafu ki Jesu Kristo a Abbingi Dios. ");
INSERT INTO gdg_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Nangiyafu yaw sin neyakkuruwino neturakki Isaias a gumalabbuni Dios siꞌin a antuweno sinapiti Dios sino Abbingnga. Sinapiꞌna si, “Dingngaggannu, ananeno dundunangku a maunta sikwama midadan sino pallakarannu. ");
INSERT INTO gdg_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Antuneno mikulakulawu sey kalolowata massapit si, ‘Idadandawino lakarannino Afuyu a gumamwang takesi nalawanneno dalana pallakaranna.’ ” ");
INSERT INTO gdg_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Neyakkuruwinay sin nappaita i Juan a Gumabawtisar sey kalolowat. Nanuldu sino inangngira naningngag sikwana. Sinapiꞌna sikwara si, “Iboboliyu naddino liwaꞌdawira e mappabawtisarkayu takesi pakomani Diosino liwaꞌdawira.” ");
INSERT INTO gdg_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Odduweno tolayira a inang naningngag sikwana a naggabwat sey Jerusalem anda sino ammina lulubbunna Judea. Nepunnurereno liwaꞌda, kasenera binawtisaran sino wawwanga Jordan. ");
INSERT INTO gdg_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ino barawasiyi Juan, naangwa si duꞌduꞌna kamelyu anna gaddangino sintaronna. Ino pay nepakkatolena, durun anna diyuna ayokan. ");
INSERT INTO gdg_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Netutulduna sino tolayira si, “Araꞌniyennino gamwanganino tolaya napatig amma sikwak. Massiki ino muttad sino gakanneno sapatuꞌna, ammek meannunga mangwa, gafu sino nappelalota kinapatingnga. ");
INSERT INTO gdg_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Sitoya, bawtisarantakayu pelang si danum, udde sikwana, bawtisarandakayuna sino Espirituwi Dios.” ");
INSERT INTO gdg_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Sinoya tiyempowa nabbawtisarani Juan sino tolayira, ginamwangi Jesus a naggabwat sey Nazaret a lubbun sino probinsiya a Galilea, e binawtisarani Juan sey wawwanga Jordan. ");
INSERT INTO gdg_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Wasin ginaꞌdanginni Jesus sino danum, initaneno langita nabbukkat annino Espirituwi Dios a kunnangke kalapatiya maddassa maffun sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Agyanino naddamit sey langita nassapit si, “Ikkeno Abbingkuwa iiddukangku, e maanggammakungke sikwam.” ");
INSERT INTO gdg_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Wasinoy, nefuyutino Espirituwi Diosi Jesus sey kalolowat. ");
INSERT INTO gdg_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Nagyan sinay si appatafuluwa aw e dinalodawi Satanas a nanutunggung sikwana. Agyanino sumaronira a animal sinaya agyananna, udde agyangkappayino anghelira a nanuffun sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Wasin nabalurani Juan, nuliyi Jesus sey Galilea a nanuldu sino nalawara damaga naggabwat ki Dios. ");
INSERT INTO gdg_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Sinapiꞌna si, “Nadaꞌngennino tiyempowa piyakkuruwani Dios sino sinapiꞌna. Araꞌniyennino patturayanna. Iboboliyu mantuweno liwaꞌdawira anna manguruggayu sino nalawara damag.” ");
INSERT INTO gdg_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Wasi tata si awa malallakari Jesus sino dappiꞌna bebaya Galilea, initaneno adwera a makkolaka gumattafukul a da Simon anni Andres. Iyattureno tafukulda sino bebay. ");
INSERT INTO gdg_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Sinapiꞌna sikwara si, “Mebulungkayu sikwak takesi pabbalintakayu si kunnangke gumattafukul si tolay.” ");
INSERT INTO gdg_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Inanawandanino tafukulda e nebulunira sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Sin aggelakalakarira sino dappiꞌna bebay, inita kappayi Jesusino adwera a makkolak a da Santiago anni Juan a abbingira i Zebedeo. Aggatakayira sino abanda a mamiyangay sino tafukulda. ");
INSERT INTO gdg_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Inayanira kappayi Jesus, e inanawandanino amara andino tandanandera sino abang, e nebulunira pay ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Wasinoy, inanda Jesus sey Capernaum. Sin awna aggimwangan, sinallungira sino sinagoga, e neyafuwi Jesus a nanuldu. ");
INSERT INTO gdg_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Nakkaꞌbawino tolayira sino annulduna, se nanuldu sikwara a mangipaita si aneno kalintiyanna a manuldu, a ammena nekunna sino annulduweno mammesturuwerana lintig. ");
INSERT INTO gdg_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ana sinayino lalakiya naassaddan si narakkatta espiritu. ");
INSERT INTO gdg_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","Kakaꞌmeng kelanga nakkulawuwa nassapit si, “Sanna maꞌlurino gakkannu sikwami, Jesus a taga-Nazaret? Ginamwangka kadda manaral sikwami? Ammutakan. Ikkeno Abbingi Dios a awana liwaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Udde “Suminakkan!” kunni Jesus sino narakkatta espiritu. “Anawannun yana tolay!” ");
INSERT INTO gdg_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Nepakkoldatino narakkatta espirituweno lalaki anna nepakkulawuna, kasena inanawan. ");
INSERT INTO gdg_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Nakkaꞌbawino anera sinay, e nakkapakipakibebutira a massapit si, “Sanna yaw? Nedumengke yawa bawuwa tulduna! Se massiki ino narakkattira a espiritu, kuruwandeno sapitanna e manawira!” ");
INSERT INTO gdg_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Antu gafuna, nalana naddinnamino mappeafu ki Jesus sino lulubbunna Galilea. ");
INSERT INTO gdg_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Wasin nallawanda Jesus sino sinagoga, nangawwatira sino balera Simon anni Andres. Nebulungkappera Santiago anni Juan. ");
INSERT INTO gdg_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Wasin ginamwangira, aggaiddeno katuwangani Simon a bafay se mababannag, e sinapiꞌda ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Inaraꞌniyani Jesus, e ginafuꞌneno kamaꞌna ta duffunanna a gumabwat. Kakaꞌmeng kelanga naariyeno babannangnga, e pinakkannera. ");
INSERT INTO gdg_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Wasin sumallappinnino sinag, neyanda ki Jesusino amminira a matakit andino naassaddanira. ");
INSERT INTO gdg_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Nakkakarampat amminino tolayira sinaya lubbun sino lasinneno balaya agyanani Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Odduweno nepabbattunoyi Jesus a matakit, massiki naddadarumeno takiꞌda, e oddu ke ino nepaanona a narakkatta espirituwa inassad sino tolayira, udde nepasinaꞌngera, se ammura si antuweno Abbingi Dios. ");
INSERT INTO gdg_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Wasin marrifarifad si kadaramaꞌna, ginabwati Jesus e nebakkang sino lubbun takesi mittata a makkararag. ");
INSERT INTO gdg_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Wasin ginabwaꞌda Simon andino bafulunnera, inanda inintufuk. ");
INSERT INTO gdg_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Wasin sinumpalanda, sinapiꞌda sikwana si, “Tufukandakeno tolayira.” ");
INSERT INTO gdg_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Udde sinapiꞌna sikwara si, “Umangngetam abbu pay sino weweꞌnginna lulubbun ta manulduwappay sinay, se antuwenayino gakkagguwa inangngan sitaw.” ");
INSERT INTO gdg_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wasinoy, nannodoyuwira sino lulubbunna Galilea, e kadda lubbuna inangnganda, nanulduwi Jesus sino tolayira sino sinagogarera, e nepaanoneno narakkattira a espirituwa inassad sino korwanira. ");
INSERT INTO gdg_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Waso kunnenoy, agyanino nakkutalla inang ki Jesus. Namalitud sino aꞌlangnga a nakiggimallak sikwana a massapit si, “Nu anggammu, damaraka pabbattunoyan.” ");
INSERT INTO gdg_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Inallakki Jesus, e inappanganna. Sinapiꞌna si, “On, anggangku si mabbattunoykan. Maariyen yan kutalnu.” ");
INSERT INTO gdg_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Kakaꞌmeng kelanga naariyeno kutalna. ");
INSERT INTO gdg_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wasinoy, nepaanawi Jesus, e sinutunna si, ");
INSERT INTO gdg_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Ammem sapitan yaw si massiki sanna a tolay, nu ammem lud umang mappaita sino padi ta itanna nu naariyennino kutalnu. Kasem iyaꞌda sikwaneno netuni Moises siꞌina mewaꞌlat ki Dios takesi wara pangammuwanino tolayira si gakkuruwa nabbattunoykan.” ");
INSERT INTO gdg_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Udde wasin inanawino lalaki, minamammalna so ingkelanga tolayino nakwa sikwana. Antu gafuna, amme makaangngi Jesus si ingkelanga lubbun, tantaro nu odduweno tolayira a dumambal sikwana, nu ammena lud nagyan sino kalolowata aroyu sino lubbun. Udde oddu kepayino tolayira a naggabwat si palulubbuna inang sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Wasin nallaꞌwutino pipidya a aw, nuliyi Jesus sey Capernaum, e naddidingngagganino tolayira a ginamwangin sino balena. ");
INSERT INTO gdg_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","E nakkakarampattira sinay makkiyad si awaninna pagyananino korwanira, massiki sino lamwangan. Wasin manulduwi Jesus sino sapiti Dios sikwara, ");
INSERT INTO gdg_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","aneno ginamwangira a appata lallakiya nabbolig si tolaya paralitiku. ");
INSERT INTO gdg_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Udde ammera dama a mearaꞌni ki Jesus gafu sino kaodduweno tolayira. Antu gafuna, neuneꞌda sino atap, e inabbutandeno ataꞌmeno batuwi Jesus, kasera nepatabbafeno tolaya paralitikuwa aggaidda sino bolig. ");
INSERT INTO gdg_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Wasin inita i Jesusino annalaꞌda sikwana, sinapiꞌna sino paralitiku si, “Kolak, napakomaninnino liwaꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Agyanino mammesturuwerana lintiya aggatuttud sinay, e kunda sino nakanda si, ");
INSERT INTO gdg_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Sanna lang kunnenayino sapitanna? Ikunnananino baggina ki Dios. Se bakkangkabbelangi Diosino makapakoma si liwat?” ");
INSERT INTO gdg_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Udde ammuwi Jesusino ana sino nakanda, e sinapiꞌna si, “Ma, ansanna lang kunnayanino dinandandaw? ");
INSERT INTO gdg_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Naladda maꞌlura massapit si ‘Napakomanino liwaꞌnu’ amma sino ‘Gumabwakka, appannuweno iddam e umanokan.’ ");
INSERT INTO gdg_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Udde nu kunnenoy, sapitangku mantuweno madyat takesi ipaitak sikwayu si ikkanakino Abbingnga Tolaya aneno kalintiyanna sito lubagga mamakoma si liwat.” ");
INSERT INTO gdg_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","E sinapiꞌna sino paralitiku si, “Gumabwakka, appannu yan iddam, ta umanokan.” ");
INSERT INTO gdg_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Wasinoy, ginabwatino lalaki, inappaneno iddana, e inanawin, a aggitanino tolayira. Amminira a ana sinay, nakkaꞌbawira e dinayora i Dios a sapitanda si, “Ammetangkepay nakaita si kunnayaw!” ");
INSERT INTO gdg_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Wasinoy, inang kappayi Jesus sino dappiꞌna bebaya Galilea. Odduweno tolayira a nakkakarampat sino agyananna, e sinulduwannera. ");
INSERT INTO gdg_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Wasin malallakari Jesus, initana i Levi a abbingi Alfeo. Aggatutturi Levi sino ofisinana abbuwitan, se antuweno tarabafuna. “Mebulungka sikwak,” kunni Jesus. Ginabwati Levi e nebulun sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wasinoy, nangnganda Jesus andino adalannera sino balera Levi, e odduwera a nakikkana gumattuki si buwit annino korwanira a minalliwata tolay. Se odduwera a nebulun ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Wasin initeno mammesturuwerana lintiya Fariseo si nakikkani Jesus sino tolayira a kunnenoy, nebebuꞌda sino adalannera si, “Ansanna lang makikkan sino gumattukiyera si buwit andino korwanira a minalliwata tolay?” ");
INSERT INTO gdg_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Diningngaggi Jesusino pattatarabbanda, e sinapiꞌna a niyamparig si, “Inyeno mawag si doktor, nu bakkampelangino matakit? Ammek inang sitawa mayag sino naggaddangngira a tolay, nu ammena lurino malliwatira.” ");
INSERT INTO gdg_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Wasi tata si aw, nallantanga mangnganino adalanira i Juan a Gumabawtisar andino Fariseowera. E agyanino inangngira ki Jesus, e sinapiꞌda si, “Ino adalanira i Juan andino Fariseowera, aneno awa mallantangira a mangngan. Udde ino adalannuwera, ammera akwan. Sanneno gafuna?” ");
INSERT INTO gdg_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Sinabbira i Jesus a niyamparig si, “Nu wara makkasar, kundokad si amme makikkanino bafulunino mangatawa a inayanna? Mangnganira, se narakkat nu lantangandeno mangngan nu wara kepay sino agyanandeno mangatawa. ");
INSERT INTO gdg_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Udde dumaꞌnganeno tiyempowa meanaw sikwareno mangatawa, antuneno pallantanganda a mangngan.” ");
INSERT INTO gdg_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Sinapikkappayi Jesus a niyamparig si, “Awana tolaya miyappit si bawu sino gamita sinnun. Se makkassannino bawu e ilabbenneno deꞌna, e maampapissayino naappitan. ");
INSERT INTO gdg_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Awangkappaya miyekwa si talifawu sino dadana sinan angang a gaddang, se battakanna, mesayukino tayug, anna madaral kappayino gaddang. Ino bawuwa tayug, bawu kappenadda gaddangino keyekwanna.” ");
INSERT INTO gdg_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Wasi tata si awna aggimwanganna Judyu, nallakadda Jesus sino aggumana namulan si trigo. E ino adalannera, nappera sino dawana e binulaꞌda. ");
INSERT INTO gdg_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Udde initeno Fariseowera, e nabbebutira ki Jesus si, “Ma, sanna lang kunnayanino akwanino adalannuwera? Kontarandeno lintiddama kammarallino maggani so awna aggimwangan.” ");
INSERT INTO gdg_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Sinabbira i Jesus si, “Ammeyu kepekad binaseno inangwa i Ari David andino bafulunnera sin nabisinanira? ");
INSERT INTO gdg_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Sinallungi David sino balayi Dios e inappaneno tinapaya newaꞌlat ki Dios a kunnino lintiya kammaralla akkanannino bakkanna padi. Udde nakkanna kepay e naꞌdanneno bafulunnera. Nakwenay sin tiyempowa i Abiatarino afafuna padi.” ");
INSERT INTO gdg_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Sinapikkappeluri Jesus si, “Ammena pinaratuwi Diosino tolayira a mearipan sino lintig mappeafu sino awna aggimwangan, nu ammena lud inangweno awna aggimwangan si pallawaranino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Antu gafuna, ikkanaka Abbingnga Tolayino ana kalintiyanna a massapit sino damana a maangwa sino awna aggimwangan.” ");
INSERT INTO gdg_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Wasin tata si aw, inang kappayi Jesus sino sinagoga. Agyan sinayino lalakiya pilayino tata a kamaꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Agyangkappayino tolayira a mallakkap ki Jesus nu pabbattunoyanneno lalaki sino awna aggimwangan, ta wara pidarumanda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Sinapiti Jesus sino lalakiya pilayino kamaꞌna si, “Umangka sito naraꞌlangammi.” ");
INSERT INTO gdg_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Kasena nepakibebut sino tolayira si, “Sanneno anggammino lintiddama akwantam sino awna aggimwangan? Mangwetam si nalawad onnu narakkat? Misalak si tolay onnu mamapatay?” Udde aggasisinakkira. ");
INSERT INTO gdg_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Nabbunguti Jesus a nangita sikwara, e malowino nakamma gafu se nataggatino ulura anna awana allaꞌda. Sinapiꞌna sino lalakiya pilay si, “Soꞌyarannu yan kamaꞌnu.” Sinoꞌyanna, e napiyen. ");
INSERT INTO gdg_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Gafu sinay, nallawanino Fariseowera e inangngira nakitatabbag sino buyutira i Ari Herodes nu ansandeno mamapatay ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Wasinoy, nanora Jesus andino adalannera sinay, e inangngira sino dappiꞌneno bebaya Galilea. Odduweno tolayira a dinandan sikwara a naggabwat sey Galilea. Odduwera kappaya naggabwat sey Judea, ");
INSERT INTO gdg_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Jerusalem, Idumea, dammangngeno wawwanga Jordan, annino naggabwatira sey Tiro anna Sidon, kunna kappay sino weweꞌnginda. Inangngira ki Jesus, se diningngaddeno ammina inangangwana. ");
INSERT INTO gdg_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Gafu sino kaodduweno tolayira, sinapiti Jesus sino adalannera si umangngira mappa si abang ta pattutturanna a manuldu takesi amme pidakkannino odduwera a tolay. ");
INSERT INTO gdg_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Se odduwennino nepabbattunoyna, antuweno inaribumbunganino matakitira takesi appanganda nad. ");
INSERT INTO gdg_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Ino kappay tolayira a naunaggan si narakkatta espiritu, kadda itanda i Jesus, nassakabbira sino aꞌlangnga a nepakkulawuweno narakkattira a espiritu sikwara si, “Ikkeno Abbingi Dios.” ");
INSERT INTO gdg_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Udde netutuni Jesus sikwara si ammera nad massapit sino mappeafu sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Wasinoy, nanuꞌduwi Jesus sino kakuluran, inayanneno tolayira a anggamma, e dinandanira sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Sikwara a dinandan sikwana, namili si karadwa, e iningnganannera si apostolna, a iraneno kanayuna mebumbulun sikwana anna iraneno dundunanna a umang manuldu. ");
INSERT INTO gdg_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Aꞌdannera kappay si pannakadama a mappaanaw sino narakkatta espirituwa inassad. ");
INSERT INTO gdg_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Iyawireno karadwa a pinilina: i Simon a nginaliꞌna si Pedro, ");
INSERT INTO gdg_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","da Santiago anni Juan a abbingira i Zebedeo a nginaliꞌnera si Boanerges, ino anggamma sapitan, natansitira a kunnangke addug, ");
INSERT INTO gdg_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","da Andres, Felipe, Bartolome, Mateo, Tomas, Santiago a abbingi Alfeo, Tadeo, Simon a ngananda si Patriota se ikaloneno lubbunna, ");
INSERT INTO gdg_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","anni Judas Iscariote a antuneno mallaku sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Wasin nuliyenda Jesus andino adalannera sino balaya agyananda, nakkakarampakkappayino tolayira, e ammeran makapangngan. ");
INSERT INTO gdg_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Wasin diningngaggino wawwayinera, inanda inappa sinay, se sinapiꞌda si nansetin. ");
INSERT INTO gdg_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Agyangkappayino mammesturuwerana lintiya naggabwat sey Jerusalem a nassapit si, “Inunaggi Beelzebub a afafuweno narakkattira a espiritu. Antuweno nangaꞌda sikwana sino pannakadamana a mappaanaw sino narakkattira a espiritu.” ");
INSERT INTO gdg_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Antu gafuna, inayanira i Jesus, e niyampariya nassapit sikwara si, “Ansanna lang paanawani Satanas ino bagginangkepay? ");
INSERT INTO gdg_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Nu maggagarunutino tolayira sino tata a lubbun, madaralnenaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Kunna kappay sino taabbalayira, nu massasarombatira, makkakaratwayira e maawanino taabbalay. ");
INSERT INTO gdg_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Kunna kappay ki Satanas. Nu paanawanneno bafulunnera a narakkatta espiritu, kontarannera, e ammena mabayag, awaninna patturayanna. ");
INSERT INTO gdg_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Awana makatallung sino balayino natuyagga tolay ta takawanneno kukwana nu ammena abbu baluran, kasena dama a ibukalino kukwana. Gakkuruwa natuyaggi Satanas, udde inaffukkun, e antuweno damaka paanawannino narakkatta espiritu. ");
INSERT INTO gdg_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Sapitangku sikwayu si gakkurug, damana a mapakomanino massiki sanna a liwatino tolay anna massiki sanna a sapitanda a narakkat mappeafu si korwan. ");
INSERT INTO gdg_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Udde ino massapit si narakkat mappeafu sino Espirituwi Dios, ammenangke mapakomanino liwaꞌna, se antuweno liwaꞌna si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Antuwenayino sinapiti Jesus, se sapitanda si naunaggan si narakkatta espiritu. ");
INSERT INTO gdg_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wasinoy, ginamwangino ina i Jesus andino kakkolaꞌngera sino balaya agyananna. Nagyanira sino lasin, e nepaayadda i Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Odduwera a tolaya nattuttud sino lebanna, e ireno nassapit si, “Anara inam andino kakkolaꞌnguwera sino lasin, e paayaddaka.” ");
INSERT INTO gdg_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Sinapiti Jesus si, “On lud, udde ana kappayino korwanira a ibilangku si inak anda kakkolakku.” ");
INSERT INTO gdg_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nallangalanga sino tolayira a aggatuttud sino lebanna, kasena sinapit si, “Irayanino inak andino kakkolakkuwera, ");
INSERT INTO gdg_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","se ino mangwa sino panggammani Dios, ireno ibilangku si inak anda kakkolakku.” ");
INSERT INTO gdg_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Wasinoy, nanuldu kappayi Jesus sino dappiꞌna bebaya Galilea. Gafu se odduweno tolaya inaribumbung sikwana, inang nattuttud sino abang so utunna danum e nagyanino tolayira sino gaꞌdang. ");
INSERT INTO gdg_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Odduweno netulduna sikwara si amparig. Sino nanulduwanna sikwara, sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Dingngaggandaw. Aneno tolaya inang nawwarit si aggik. ");
INSERT INTO gdg_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Wasin aggewarawarit, naddattuweno korwana aggik sino dammingnga dalan, e inaꞌnamino mammanukira. ");
INSERT INTO gdg_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Ino korwana newariꞌna, naddattu sino kabatuwana bisangkeno lubangnga. Gafu se naimpitino lubangnga, nalanira a nattufu. ");
INSERT INTO gdg_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Udde wasin nasinaniran, nalelayira, se awana naggamutanda. ");
INSERT INTO gdg_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Ino korwangkappay, naddattu sino kasasitan, e neyindanino asita nattufu e ilintuꞌdanino mula, antuweno ammeran nakapabbunga. ");
INSERT INTO gdg_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Udde ino korwana newariꞌna, naddattuwera si nalawara lubag, nattufuwera e dinarokkallira, anna nammungera. Aneno nammunga si tallufulu, ana kappayino nammunga si annammafulu, e ana kappayino nammunga si tatut.” ");
INSERT INTO gdg_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","E inabambutani Jesus a sinapit si, “Ikkayuwa maningngag sitawa ampariggu, dandammandonaddino diningngaddaw.” ");
INSERT INTO gdg_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Wasin inanawino kaodduwana tolay, inaraꞌniyeno karadwera a adalani Jesus andino korwanira a mebumbulun sikwara, e nabbebutira nu sanneno anggamma sapitannino amparingngera. ");
INSERT INTO gdg_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Sinapiti Jesus sikwara si, “Ipakaammuwi Dios sikwayuweno ammena nepakaammu siꞌin mappeafu sino patturayanna. Udde ino korwanira a tolaya ammena manggamma mangurug sikwak, passiya ampariyino sapitangku sikwara, ");
INSERT INTO gdg_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","takesi massiki nu aggitanda, ammera maimunuwan, anna massiki nu dingngagganda, ammera maawatan. Se nu maawatanda, tantaro nu umaꞌlangira ki Dios e pakomanneno liwaꞌdera.” ");
INSERT INTO gdg_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Wasinoy, sinapikkappayi Jesus sikwara si, “Ma, ammeyu kaggepay maawatan inaya amparig? Nu kunnenoy, ansandomaꞌna mangawat sino korwana ampariggu? ");
INSERT INTO gdg_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Kunnayawino anggamma sapitan. Ino aggika newarit, antuweno sapiti Dios. Ino inang nawwarit, antuweno mangibanyag sinaya sapit. ");
INSERT INTO gdg_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ino dalana naddattuwanino korwana aggik, antuweno keyampariyanino tolayira a maningngag sino tuldu, udde malana gumamwangi Satanas, e ariyanna sino nakandeno diningngadda. ");
INSERT INTO gdg_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ino kabatuwana naddattuwanino korwan, ireno tolayira a manggamma mangurug sino dingngagganda a tuldu. ");
INSERT INTO gdg_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Udde ammena sumallungino sapit sino nakanda, antu gafuna, nu wara gumamwang si dyaꞌda onnu nu madyatanira gafu sino angngurudda sinaya sapit, talekkurandanino angngurudda. ");
INSERT INTO gdg_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ino kasasitana naddattuwanino korwana aggik, ireno tolaya maningngag sino sapiti Dios, ");
INSERT INTO gdg_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","udde nakungkulino nakanda gafu sino paddararananda sino maawadda sino biyadda. Angganda kappaya bumaꞌnang anna odduweno angganda a ampattan sito lubag, e antuweno mabbung sino sapita diningngadda, e awana ketupakkanna. ");
INSERT INTO gdg_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Udde ino nalawara lubagga naddattuwanino korwana aggik, ireno tolaya maningngag sino sapiti Dios e kuruwanda, e aneno pattupakkanna sino biyadda. Mekunnera sino mula a mammunga si tallufulu, annammafulu, anna tatut.” ");
INSERT INTO gdg_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Sinapikkappayi Jesus a niyamparig si, “Wara kad mitaggab si lampara, kasena kallabban si angngoran onnu iyekwana so gukamma katri? Awan, nu ammena lud itappat ta masirwatan ammin. ");
INSERT INTO gdg_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Kunna kappayino neyampariggu, se ammina neimad onnu ammena nepakaammu sito ingkein, mepakaammuna ta maawatanino anggamma sapitan so maddagguna aw. ");
INSERT INTO gdg_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ikkayuwa maningngag, dandammandonaddino diningngaddaw.” ");
INSERT INTO gdg_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Netuluyi Jesus a nassapit si, “Aggadandammandonaddino diningngaddawa sinapikku, se nu antuweno akwandaw, ooddu kepayino maawatandaw, e ana kappayino idagga i Dios sino angngawaꞌdaw. ");
INSERT INTO gdg_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Se ino tolaya manggamma mangwa sino diningngangnga, madadaggananneno angngawaꞌna, udde ino tolaya ammena mangwa sino diningngangnga, massiki ino bisangnga ammuna, maawanna.” ");
INSERT INTO gdg_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Sinapikkappayi Jesus si, “Kunnayawino tata kappaya keyampariyanino patturayani Dios. Aneno tolaya inang nawwarit si aggik sino umana. ");
INSERT INTO gdg_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Wasin nasinduwenna nawwarit, inangwaneno gagangaya akwanna, a maturug si gafi anna mattarabafu si aw. E ino newariꞌna, nattufu anna dinokkal, udde ammena ammu nu ansanneno nepattufuna. ");
INSERT INTO gdg_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Se ino lubabbelangino mappatufu anna mappamunga sino mula. Mattufu, dumokkal, anna maddawa, kasena mabbaggat. ");
INSERT INTO gdg_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","E nu malutuwen, magganiyennino nammula se aggaraniyen.” ");
INSERT INTO gdg_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Sinapikkappayi Jesus si, “Sannadeno pikunnantam onnu piyampariyantam sino patturayani Dios? ");
INSERT INTO gdg_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Meyamparig sino bukalla mustasa, a antuweno kabibissangngana bukal sino ammina mula. ");
INSERT INTO gdg_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Udde nu memula, mattufu e dumokkal, e mabbali si kadodokkallana mula sino gardin. Mattangatanga si taraꞌnang, kiyad si dama a pumukanino mammanukira.” ");
INSERT INTO gdg_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Odduweno kunnenaya ampariya inusari Jesus sino nanulduwanna sino sapiti Dios sino tolayira. Sinulduwannera kiyad sino damara a maawatan. ");
INSERT INTO gdg_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Awana netulduna sikwara a ammena nusar si amparig, udde nu ira pelang andino adalannera, netulduna sikwareno anggamma sapitannino amparingngera. ");
INSERT INTO gdg_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Wasin fuwafin sinoya aw, sinapiti Jesus sino adalannera si, “Maddammangetam.” ");
INSERT INTO gdg_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Antuweno nattakayira sino abanga aggatutturani Jesus, e inanawandeno odduwera a tolay. Agyangkappayino korwana abanga nebulun sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wasinoy, kakaꞌmeng kelanga nakkalipappag, e dinaluyakanino palungino abanda si danum, e lumannaddiran nad. ");
INSERT INTO gdg_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Udde i Jesus, aggakaturuwa naffungan sino likunneno abang. Ginammiyanino adalannera a kunda si, “Afu, ma, purayannu si malimattetam?” ");
INSERT INTO gdg_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ginabwati Jesus, e sinapiꞌna sino kalipappag si, “Lumammakkan.” Sinapiꞌna kappay sino palung si, “Suminakkayu.” E ilammattinnino kalipappag anna nassiyanakkinnino palung. ");
INSERT INTO gdg_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Kase sinapiti Jesus sino adalannera si, “Mayan mattalokayu? Awangkepekad talaꞌdaw sikwak?” ");
INSERT INTO gdg_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nappelalotino kaꞌbora e nakkakibikibebutira si, “Sanneno katolena yaw? Se massiki ino kalipappag andino palung, kuruwandeno sapitanna.” ");
INSERT INTO gdg_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wasinoy, netuluyda Jesus a naddammang sino bebaya Galilea kiyad si ginaꞌdangira sino sakopanna Gerasenowera. ");
INSERT INTO gdg_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Wasin inulluwi Jesus sino abang, dinambalino tata lalakiya naunaggan si narakkatta espiritu. Inaya lalaki, naggabwat sino agwefa attanammanda, ");
INSERT INTO gdg_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","se antu pelangino pagagyananna. Awana makabalud sikwana, massiki nu kadeneno ikawadda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Namipidyandana binalurino kamaꞌna anna takkina, udde ginatagattaꞌneno kadena sino kamaꞌna anna dinaralneno ana sino takkina. Awangkappaya makafuwad sikwana se nappelalotino tuyangnga. ");
INSERT INTO gdg_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Aw anna gafi, aggelakalakad sino katanamman anda sino kakuluran a mangakkulawu anna daladalunneno baggina si batu. ");
INSERT INTO gdg_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Udde wasin nedipaꞌna i Jesus, nalayawa inang dinambal sikwana, e namalitud sino aꞌlangnga. ");
INSERT INTO gdg_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","E nakkulawuwa nassapit si, “Jesus a Abbingi Dios a Kapatiyan, sanneno gakkannu sikwak? Isapatam ki Dios si ammerak paidaman!” ");
INSERT INTO gdg_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Antuweno sinapiꞌna, se sinapitinni Jesus sino inassadda narakkatta espiritu si, “Anawannun yana tolay!” ");
INSERT INTO gdg_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wasinoy, nepakibebuti Jesus si, “Sanneno angannu?” E sinabbino narakkatta espiritu si, “Rinifuweno angangku, se oddukami.” ");
INSERT INTO gdg_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","E namipidya a nakiggimallakkino narakkatta espiritu ki Jesus ta ammenera nad panawan sinaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Agyan sinayino odduwera a bafuya maddukiruk sino sannaꞌnga kulud. ");
INSERT INTO gdg_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","E nakiggimallakkino narakkattira a espiritu ki Jesus si, “Purayandakami ta munaggami sino bafuyira.” ");
INSERT INTO gdg_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Nepurayira i Jesus. Inanawandeno lalaki e inangngira nunag sino bafuyira. Naddadaraddaggino bafuyira a naddawut, nangawwatira sino dabbaꞌngeno bebay, nadaraꞌnira, e nalimattira ammin. Ino kaodduweno bafuyira, inang si adwarifu. ");
INSERT INTO gdg_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ino mindaggira sino bafuy, nabbafukalira a inang nituldu sinaya nakwa sino kalubbunandera anda sino sinaꞌlifandera. Antuweno inang initeno tolayireno nakwa. ");
INSERT INTO gdg_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Wasin ginamwangira sino agyananda Jesus, initareno lalakiya naunaggan siꞌin. Aggatuttud sinaya nabbarawasi anna nuliyennino nalawara nakamma. E nakatalawira ammin. ");
INSERT INTO gdg_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ino tolayira a nakaita sino nakwa sino lalakiya naunaggan andino nakwa sino bafuyira, netutuldura kappay sino korwanira. ");
INSERT INTO gdg_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Gafu sinoy, nakiggimallakkira ammin ki Jesus ta anawanna naddino lubbunda. ");
INSERT INTO gdg_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Wasin mattakayinni Jesus sino abang, nakiggimallakkino lalakiya inanawanino narakkattira a espirituwa mebulun nad sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Udde amme anggammi Jesus, nu ammena lud sinapit sikwana si, “Nalawad nu mulikan sey baleyu ta sapitannu sino wawwayimira amminino inangwa i Afu Dios sikwam annino nepikallaꞌnga sikwam.” ");
INSERT INTO gdg_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Nanawino lalaki, e inang nannodoyug sino ammina sakoꞌma tafuluwa lubbun a ngananda si Decapolis a nituldu sino inangwa i Jesus sikwana. E nakkaꞌbaw amminino tolayira a naddingngag sino netulduna. ");
INSERT INTO gdg_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Wasinoy, nabang kappera Jesus a nuli sino dammangnga bebay. Wasin inasipiran, odduweno tolayira a inaribumbung sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","E ginamwangino tata a pangafuwanna sinagoga a mingngan si Jairo. Wasin initana i Jesus, namalitud sino aꞌlangnga. ");
INSERT INTO gdg_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Nakiggimallakka nassapit si, “Gapapatayinnino abbingkuwa bafay. Umangngu nad abbu appangan ta mabbattunoyin kesi mabiyabbay.” ");
INSERT INTO gdg_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nebuluni Jesus sikwana. Dinandangkappayino odduwera a tolaya makkatutuꞌyurira a umaraꞌni sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Agyan sinayino tata bafaya aggedada si karadwa si run. ");
INSERT INTO gdg_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nadyataningke sino odduwa nappaagasanna, e nagastunan amminino kukwana, udde ammena nabbattunoy, nu ammena lud dinaggattino takiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Gafu se diningngangnganino mappeafu ki Jesus, nakilasilasi sino tolayira takesi araꞌniyanneno likuri Jesus. E sinenggenneno barawasina. ");
INSERT INTO gdg_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Se kunna sino nakamma si, “Massiki nu senggerangku nallangino barawasina, mabbattunoyakun.” ");
INSERT INTO gdg_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Assenggenna lang sino barawasina, ilammattinnino adana, e giniꞌnana si awaninnino takiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Udde i Jesus, giniꞌnana si aneno nallawana pannakadamana. Antuweno nabbaliwit sino likunna, e nebebuꞌna sino tolayira si, “Inyeno nanengged sino barawasik?” ");
INSERT INTO gdg_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nesombatino adalannera si, “Maitamino kaodduwana tolaya maddadaraꞌlin sino lebannu, e ibebuꞌnu kepay nu inyeno nanengged sikwam?” ");
INSERT INTO gdg_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Udde nallangalanga kepayi Jesus ta itanna nu inyeno nanengged sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Gafu se inammuweno bafayino nakwa sikwana, inaraꞌni ki Jesus a mayyaꞌyak sino talona, namalitud sino aꞌlangnga, e nepunnuneno ammina inangwana. ");
INSERT INTO gdg_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Sinapiti Jesus sikwana si, “Ikka a abbingku, gafu sino angngurungngu sikwak, nabbattunoykan. Manokana nalawannaddino nakammu. Ammenan muliyeno takiꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Wasin aggetatabbangkepayi Jesus sino bafay, ginamwangino naggabwatira sey balera Jairo, e sinapiꞌda sikwana si, “Ammetamun talantanannino mesturu, se natayinnino abbingngu.” ");
INSERT INTO gdg_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Udde amme nepilingalinga i Jesusino sinapiꞌda ki Jairo, nu ammena lud sinapit sikwana si, “Ammeka maddararan. Pattuyaggannu lurino annalaꞌngu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Amme nepurayi Jesus a dinandanino tolayira sikwana, da Pedro pelang anda Santiago anni Juan a makkolakino nebulunna. ");
INSERT INTO gdg_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Wasin ginamwangira sino balera Jairo, inita i Jesus si madadammuluweno odduwera a tolay, e makkanawakawira a mattatarangit anna mababbinungera. ");
INSERT INTO gdg_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wasin sinallungi Jesus, nebebuꞌna sikwara si, “Mayan makkanawakokayu anna mattatarangit? Ammena natayino abbing. Maturubbelang.” ");
INSERT INTO gdg_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Kinakkatawanino tolayira i Jesus. Antu gafuna, nepallawannera ammin, kasena inayanino mapparanakireno abbing andino talluwera a adalanna, e sinallungira sino agyananino abbing. ");
INSERT INTO gdg_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ginafuti Jesusino kamaꞌna, e sinapiꞌna si, “Talita kum.” Ino anggamma sapitan, “Ikka a abbing, gumabwakkan.” ");
INSERT INTO gdg_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Kakaꞌmeng kelanga ginabwatino abbing e nalallakad. Inaya abbing, mabambalatangin se karadwennino runna. Nappelalotino kaꞌbawino nitera. ");
INSERT INTO gdg_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Netutuni Jesus sikwara si ammera nad sapitannino initara si massiki sanna a tolay. E sinapiꞌna sikwara Jairo si pakkananda naddino abbing. ");
INSERT INTO gdg_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Wasinoy, inanora Jesus andino adalannera sinay, e inangngira sino lubbuna dinokallanna. ");
INSERT INTO gdg_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Wasin nadaꞌngeno awna aggimwangan, nanulduwi Jesus sino sinagogara. Nakkaꞌbawino odduwa tolaya naningngag sino tulduna, e sinapiꞌda si, “Sintawireno nangappanna sinay? Sintawino nappanna sinaya kinalaingnga? Ansanna lang ammuwa mangwa si kakkaꞌbaw? ");
INSERT INTO gdg_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Bakkangkad yanino kalapanteruwa abbingi Maria? Bakkangkaggappaya kolaꞌda Santiago, Jose, Judas, anni Simon? Ammena kaggappay magyanino kakkolaꞌngera a bafabbay sitaw?” Antuweno ammera anggamma maningngag sikwana e ammera kuruwan. ");
INSERT INTO gdg_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Wasinoy, sinapiti Jesus sikwara si, “Massiki sintawa lubbuna umangnganino gumalabbun, dayawannino tolayira, fera pelang sino kalubbunannera, sino wawwayinera, andino kataabbalayannera.” ");
INSERT INTO gdg_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Gafu se awana angngurudda sikwana, awana inangwa i Jesus si kakkaꞌbaw sinay, nu bakkampelangino nappabattunoyanna sino bisangngira a natakita inappanganna. ");
INSERT INTO gdg_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","E nakkaꞌbawi Jesus sino ammera nanguruwan sikwana. Waso kunnenoy, nannodoyudda Jesus sino lulubbun sinaya umang manuldu. ");
INSERT INTO gdg_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","E inayanneno karadwera a adalanna ta dundunannerana si aggadwa. Neyaꞌdana sikwareno kalintiyana mappaanaw si narakkatta espiritu. ");
INSERT INTO gdg_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Sinunnera si ammera nad miyangkalin si massiki sanna a awanda sino pannodoyuwanda. Ammera nad miyangkalin si makkan, pasiking, onnu pirak, ino pelang tokuddeno iyangkalinda. ");
INSERT INTO gdg_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Damara a massapatut, udde ammera nad miyangkalin si pamataliyanda. ");
INSERT INTO gdg_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Sinapiꞌna kappay sikwara si, “Kadda lubbuna umangngandaw, e wara mayag sikwayu sino balera, antu naddino pagyanandaw kiyad si umanokayu sinaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Udde nu wara lubbun si umangngandaw, e awana mappadilot sikwayu anna ammera anggamma dingngaggannino tulduyu, umanokayu sinay, e so agganoyu, tattakandawino lafuk sino takkiyu ta antuweno pangammuwanda si ireno makammu sino kakastiguwanda.” ");
INSERT INTO gdg_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Waso kunnenoy, ginikkatino adalannera, e inangngira nanuldu sino tolayira ta ibobolira naddino liwaꞌdera. ");
INSERT INTO gdg_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Nepaanoreno odduwa narakkatta espirituwa inunag sino tolayira, e ilanandeno odduwera a matakit e nabbattunoyira. ");
INSERT INTO gdg_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Naammuwani Ari Herodes sey Galilea ino inangangwa i Jesus, se naddinnamino angani Jesus si palulubbun. Aneno korwana tolaya nassapit si, “Antuwi Juan a Gumabawtisar a nangngangoli. Antu gafuna, aneno pannakadamana a mangwa si kakkaꞌbaw.” ");
INSERT INTO gdg_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ino korwanira, kunda si, “Antuwi Elias.” Ino korwanira kappay, sinapiꞌda si, “Gumalabbun inay, a kunneno gumalabbunira siꞌin.” ");
INSERT INTO gdg_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Udde wasin diningngaggi Ari Herodesino inangwa i Jesus, sinapiꞌna si, “Antuwenayi Juan a Gumabawtisar a nepafutulku. Sanna lang nangngangoli kappay?” ");
INSERT INTO gdg_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Kunnenoyino sinapiti Herodes gafu sino inangwana siꞌin. Se nepadoꞌmana i Juan e nepabalunna a nakadenan, gafu sino nallangngani Juan sikwana. Se i Herodes, inatawaneno ipangnga a i Herodias a ataweno kolaꞌnga a i Felipe. ");
INSERT INTO gdg_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","E namipidya a sinapiti Juan sikwana si mekontara sino lintig nu atawanteno ataweno kolatta. ");
INSERT INTO gdg_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Antu gafuna, nabbungutingke i Herodias ki Juan, e anggamma a papapatay, udde gafu ki Herodes, ammena dama a akwan. ");
INSERT INTO gdg_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Se neyatalli Herodes i Juan, se ammuna si naggaddang anna nadiosana tolay, e antuweno ammena nepuray si mapapatayi Juan. Massiki nu makungkulino nakamma nu dingngagganneno itulduwi Juan, anggamma kepaya dingngaggan. ");
INSERT INTO gdg_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Udde nadaꞌngeno tiyempowa nawayani Herodias a mappapapatay ki Juan, sino awa neyanakani Herodes. Inayani Herodesino ofisiyalnera, ino afafuwerana sindalu, andino napapatiyira a tolay sey Galilea takesi makilanggakira sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","E sinallungino balatanga abbingi Herodias sino agyananda Herodes andino inayannera, e nassala sinay. Nappelalotino langgaꞌda Herodes sino nassalanna, antuweno nassapitanna sikwana si, “Massiki sanneno anggammu, ituldum ta iyaꞌdak sikwam.” ");
INSERT INTO gdg_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Nesapatana kappay si, “Massiki sanneno arangngannu, massiki ino kagadwaneno patturayangku, iyaꞌdak sikwam.” ");
INSERT INTO gdg_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nallawanino balatang e inang nabbebut sino inana si, “Sanneno arangngangku?” “Ino uluwi Juan a Gumabawtisar,” kunnino inana. ");
INSERT INTO gdg_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nakkangkamino balatanga nuli ki Ari Herodes, e sinapiꞌna sikwana si, “Ino anggangku, iyaꞌdam sikwak sito ingkeinino uluwi Juan a Gumabawtisar a neyekwa si duyug.” ");
INSERT INTO gdg_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Malowino nakammi Ari Herodes sin diningngangngenay, udde gafu se nassapata sino aꞌlangino inayannera, maatalla ammena mangwa sino nekarina sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Antu gafuna, dinundunnanino tata a sindaluwa umang mangappa sino uluwi Juan. Inangngino sindalu sino abbaluran e finutulanna. ");
INSERT INTO gdg_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Neyekwana si duyuwino ulu, e neyangnga sino balatang, kase neyaꞌdeno balatang sino inana. ");
INSERT INTO gdg_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Wasin naammuwanino adalanira i Juanino nakwa sikwana, inanda inappeno baggina e netananda. ");
INSERT INTO gdg_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Wasinoy, nuliyeno apostolira ki Jesus, e sinapiꞌda sikwaneno ammina inangwara anna netuldura sino nannodoyuwanda. ");
INSERT INTO gdg_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Udde gafu se odduwa tolaya mappatapataliya umang mita ki Jesus, ammeran makapangngan. Antuweno sinapiti Jesus sino adalannera si, “Umangngetam sino awana matotolena ta mimwangetam.” ");
INSERT INTO gdg_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","E nattakayira si abanga umang sino awana matotolena. ");
INSERT INTO gdg_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Udde odduweno nita sikwara sino inanawanda, e naimunuwandera. Nalayawino tolayira a naggabwat sino lulubbunda, e inuntanandara Jesus sino umangnganda. ");
INSERT INTO gdg_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Wasin ginaꞌdangi Jesus, initaneno odduwa tolay, e inallaꞌngera, se kundangke karnerowa awana mimut sikwara. Antu gafuna, odduweno netulduna sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Wasin maffuwafin, inangngino adalannera sikwana, e sinapiꞌda si, “Fuwafin, gampade awana bafalay sitaw. ");
INSERT INTO gdg_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Panawannuweno tolayira ta umangngira maggatang si akkananda sino kaaraꞌniyana lubbun.” ");
INSERT INTO gdg_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Udde sinapiti Jesus sikwara si, “Ikkayunnino mamakkan sikwara.” E sinabbadda si, “Anggammuwa sapitan si ikkamiyeno umang maggatang si tinapaya nabbalor si pipidya a rifu ta ipakkammi sikwara?” ");
INSERT INTO gdg_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Nebebuti Jesus si, “Pidyeno tinapeyu? Umandaw itan.” E inanda inita, kasera sinapit sikwana si, “Lima ke a tinapay anna adwaggiya tinapa.” ");
INSERT INTO gdg_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wasinoy, sinapiti Jesus sino adalannera ta garadwandeno tolayira ta pattutturandera sino kakaddattan. ");
INSERT INTO gdg_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","E naggagaradwera a nattuttud, aneno sittatut, ana payino allalimafulu. ");
INSERT INTO gdg_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Inappa i Jesusino lima a tinapay andino adwaggiya tinapa, kasena sinangaw sey langita mappasalamat ki Dios. Ginaradwaneno tinapay e neyaꞌdana sino adalannera ta iyannera sino tolayira. Kunna kappayino inangwana sino adwaggiya tinapa ta iyannera kappay. ");
INSERT INTO gdg_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Nangnganira ammin e nabattuwira. ");
INSERT INTO gdg_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Inampattino adalannereno nabuna a tinapay anna tinapa a ginaradwa i Jesus, e napannuweno karadwera a basket. ");
INSERT INTO gdg_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ino kaodduweno lallakiyera a nangngan, limarifuwera, fereno bafabbayira andino aanakira. ");
INSERT INTO gdg_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Sassindu langa namakkani Jesus sino tolayira, nepattakenanino adalannera sino abang, ta maunteran nadda maddammanga umang sey Betsaida. E nataki Jesus a mappaikkat sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Wasin nepaikkaꞌneran, nanuꞌdu sino kulud ta makkararag. ");
INSERT INTO gdg_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Wasin nallammukin, agyaninnino abanga nattakayanino adalannera sino tangnganeno bebay, e i Jesus, agyangkepay sino kulura nittata. ");
INSERT INTO gdg_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Nedipaꞌnera, e initana si madyatanira a mamaluwa sino abang, se dambalandeno bayabbag. Wasin marrifarifaddin, dinandananira i Jesus a nallakad so utunna danum. Laꞌwutannera nad, ");
INSERT INTO gdg_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","udde sin naitara a mallakad sino utunna danum, nakatalawirangke e nakkulawuwera, se aridda si banig. Udde nalana naddamiti Jesus sikwara a sinapiꞌna si, “Ammekayu mattalaw! Ikkanak yaw.” ");
INSERT INTO gdg_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nakitakay sikwara, e ilammattino bayabbag. Nangkakaꞌbawino adalannera, ");
INSERT INTO gdg_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","se massiki initareno nappaodduwanna sino tinapay, ammera naawatanino anggamma sapitan mappeafu sino pannakadamana, se kunnangke nataggakkepayino ulura. ");
INSERT INTO gdg_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Wasin nakadammangiran, ginamwangira sey Genesaret, e neyakaddeno abang sino dappiꞌneno bebay. ");
INSERT INTO gdg_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Aggulludda lang sino abang, naimunuwanino tolayira i Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","E nakkangkamira a nipakaammu sino lulubbun a anenni Jesus. E ammina tolaya naddingngag, nu wara matakit sino bafulundera, ibolidda a iyang sino massiki sintawa agyananna. ");
INSERT INTO gdg_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","E massiki sintawa inangngani Jesus, dokalla lubbun onnu bibissang onnu sino sittata ke a bafalay, netarondeno matakitira sino pangannanna. E nakiggimallakkira si senggeran naddino matakitireno leleneno barawasina. E amminira a nanengged, nabbattunoyira. ");
INSERT INTO gdg_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Wasin tata si aw, agyanino Fariseowera andino mammesturuwerana lintiya naggabwat sey Jerusalem a inang ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Initara a mangngampelangino korwanira a adalani Jesus a nadakkukkepayino kamaꞌda, anggamma sapitan, ammera sinuntulino gagangena Judyu mappeafu sino fustuwa ammaggu. ");
INSERT INTO gdg_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Se ino Judyuwera, kumarallino Fariseowera, ammera mangngan nu ammera abbu mamagguwa manuntul sino gagangaya inillalupaꞌda sino gagginafurera. ");
INSERT INTO gdg_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Nu maggabwatira kappay sino allakuwan, ammera mangngan nu ammera abbu warsiyanino baggira si danum. Oddu kappayino korwana gagangaya inillalupaꞌda sino gagginafurera, a kunnangke ino aggangwara a malliꞌnaw si tasa, kapatera, anna kanderu. ");
INSERT INTO gdg_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Antu gafuna, inayira a Fariseo anda mammesturuwerana lintig, nebebuꞌda ki Jesus si, “Mayan amme tuntulannino adalannuwereno gagangaya inillalupattam sino gagginafutamira? Sanda lang mangngana ammera tuntulannino fustuwa ammaggu?” ");
INSERT INTO gdg_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Sinombati Jesus sikwara si, “Gakkuruwino nelabbuni Isaias siꞌin mappeafu sikwayuwa massasan mangurug ki Dios. Se neturaꞌnga si, ‘Iyawira a tolay, bifidda pelangino paddayora sikwak, udde aroyuweno nakanda sikwak. ");
INSERT INTO gdg_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Awana serbineno paddayawanda sikwak, se ituldureno lintiya inangwana tolay, e sapitanda si antuweno lintiggu.’ ");
INSERT INTO gdg_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Gakkuruwa akwandawino neturakki Isaias, se purayandawino lintiyi Dios ta tuntulandawino gagangeyuwa inangwa pelangnga tolay.” ");
INSERT INTO gdg_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Netuluyi Jesus a nassapit si, “Nalaingkayungke a mammay sino lintiyi Dios ta tuntulandawino gagangaya aggangwayu. ");
INSERT INTO gdg_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Se ino nepeturakki Dios ki Moises, kunna si, ‘Dayawannura amam anni inam,’ anna ‘Nu wara massapit si narakkat sino amana onnu sino inana, mapapatenad.’ ");
INSERT INTO gdg_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Udde tangananino itulduyu. Se ino itulduyu, nu wara iduffun naddino tolay sino amana onnu inana, massiki nu ammena iyaꞌda. Damana a irason sikwara a massapit si, ‘Ino iduffungku nad sikwayu, korban, anggamma sapitan, nekarika iwaꞌlat ki Dios.’ ");
INSERT INTO gdg_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","E nu kunnenoyino sapitanna, iyallandaw si makkikiyarino panuffunanna sino amana anna inana. ");
INSERT INTO gdg_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Gafu sinaya aggangwa a itulduyu sino tolayira, ammayandawino sapiti Dios. Ooddu kappayino akwandawa kunnenay,” kunni Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wasinoy, neparaꞌniyi Jesusino odduwera a tolay, e sinapiꞌna si, “Dingngaggandaw ammin yaw takesi maawatandaw. ");
INSERT INTO gdg_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Bakkannino ipaunangnga tolay sino wangiꞌneno mappadakkut sikwana sino aꞌlangi Dios, nu ammena lurino narakkatta sapita maggabwat sino bifingnga. ");
INSERT INTO gdg_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ikkayuwa maningngag, dandammandonaddino diningngaddaw.” ");
INSERT INTO gdg_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Wasin inanawani Jesusino tolayira e sinallung sino balay, nebebutino adalannera nu sanneno anggamma sapitan inaya sinapiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Sinapiti Jesus si, “Ma, massiki ikkayu, ammeyu kappay maawatan? Ammeyu kad ammu si massiki sanna a akkananna tolay, ammena dama a mappadakkut sikwana so aꞌlangi Dios? ");
INSERT INTO gdg_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Se ammena sumallung sino nakamma, nu ammena lud sino kuyungnga, kasena kappay mallawan.” (Gafu sinaya sinapiti Jesus, nepakaammuna si damatam akkanan ammina makkan, e bakkanna liwat.) ");
INSERT INTO gdg_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Netuluy kappayi Jesus a nassapit si, “Ino maggabwat sino nakamma tolayino mappadakkut sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Se ino nakamma tolayino paggabwatanino ammina narakkatta dinandamma, a metupak si narakkatta aggangwa a kunnayaw: ino makidurug sino bakkanna atawana, ino mattakaw, ino mamapatay, ino makibulun, ");
INSERT INTO gdg_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ino mingaꞌrun, ino mangwa si narakkat sino bafulunnera, ino mamalabali, ino mangwa si kaꞌatatalla ammena mafuwaddan, ino mimal, ino mamaraparal, ino massangkatolay, annino ammena manandam sino nalawara akwanna. ");
INSERT INTO gdg_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Amminira yaw, maggabwatira sino nakamma tolay, e ireno mappadakkut sikwana sino aꞌlangi Dios.” ");
INSERT INTO gdg_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Wasinoy, nanawi Jesus sinay, e inang sino sakopanna Tiro. Nagyan sino tata a balaya dinaꞌngana, e anggamma si awana mangammu si agyan sinay, udde naammuwanda kappay. ");
INSERT INTO gdg_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Agyanino tata bafaya naunagganino abbingnga a bafay si narakkatta espiritu. Wasin diningngangnga si ana i Jesus sinay, nakkangkama inang sino agyananna. E namalitud sino aꞌlangnga. ");
INSERT INTO gdg_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nakiggimallak sikwana ta paanawanneno narakkatta espirituwa inunag sino abbingnga. Inaya bafay, neyanak sey Fenisia, a sakopanna Siria, e Griegoweno damiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Sinabbi Jesus sikwana a niyamparig si, “Mangngan nad abbuweno abbingira kiyad si mabattuwira. Se ammena fustu nu fulattanteno akkananna abbing e iyaꞌdata sino atu.” Ino anggamma sapitan, ino Judyuwera abbuweno duffunanna, kaseneno bakkannira a Judyu. ");
INSERT INTO gdg_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","“Gakkurug yan, Afu,” kunnino bafay, “udde massiki ino atuwera, akkanandeno butta a madaraꞌnag sino pangngananino anakira.” ");
INSERT INTO gdg_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Sinapikkappayi Jesus si, “Gafu sinaya sombaꞌnu, damamunna umanaw. Inanawaninnino narakkatta espirituweno abbingngu.” ");
INSERT INTO gdg_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Inanawinnino bafay, e dinaꞌnganeno abbingnga a aggaidda sino katri, se inanawinnino narakkatta espiritu sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Wasinoy, nanawi Jesus sey Tiro, inang sey Sidon anda sino sakoꞌma Decapolis, kasena nuli sino bebaya Galilea. ");
INSERT INTO gdg_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Agyanino tata lalakiya bangngag anna ammena makadamita neyangngino tolayira ki Jesus. Nakiggimallakkira sikwana ta appangannenaya lalaki ta mabbattunoy. ");
INSERT INTO gdg_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Nearoyuwi Jesusino lalaki sino tolayira ta ira pelanga adwa, kasena netulatino tamuruna sino layangngeno lalaki, e nefurayelna kappayino luppana sino dilana. ");
INSERT INTO gdg_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Sinangaw sey langita makaannangat, e sinapiꞌna sino damiꞌda si, “Efata,” anggamma sapitan, “Mabukkatangka.” ");
INSERT INTO gdg_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kakaꞌmeng kelanga makadingngaggino lalaki e nalawaringkappayino addamiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Netuni Jesus sino tolayira a ammera nad sapasapitan si massiki sanna a tolay. Udde massiki nu namipidyanna a netun sikwara, nanuyagganda lullanga mipakaammu. ");
INSERT INTO gdg_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Amminira a naningngag, nakkaꞌbawirangke, e sinapiꞌda si, “Passiya nalawarino ammina akwanna. Massiki ino bangngaggira, paddingngaggannera, e ino ammera makadamit, paddamitannera.” ");
INSERT INTO gdg_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Sinoya tiyempo, nakkakarampakkappayino odduwera a tolay sino agyanani Jesus, e naambutanira si akkanan. Antu gafuna, inayani Jesusino adalannera e sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Maallakkanak sitawira a tolay, se kaꞌlu awinna nagyanira sikwatam, e naambutinnino akkananda. ");
INSERT INTO gdg_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Nu paanawangkuwera a ammera kepay nangngan, tantaro nu wara maffunaw sikwara sino dalan, se aroyuweno naggabwatanino korwanira.” ");
INSERT INTO gdg_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","“On lud,” kunnino adalannera sikwana, “udde sintawino pangappantam si akkanan sito kalolowat ta wara ipakkantam sikwara?” ");
INSERT INTO gdg_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","“Pidyeno tinapeyu?” nebebuti Jesus. “Pitu ke,” kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wasinoy, nepattutturi Jesusino odduwera a tolay. Inappaneno pituwa tinapay, e nappasalamat ki Dios. Kasena ginaradwa, e neyaꞌdana sino adalannera ta iyannera sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Agyangkappayino bisangnga tinapa. Nappasalamakkappayi Jesus, e nepeyannena kappay. ");
INSERT INTO gdg_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Nangnganira ammin kiyad si nabattuwira. Wasin nasinduwera a nangngan, inampattino adalannereno nabuna, e napannuweno pituwa basket. ");
INSERT INTO gdg_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ino bilangino nangnganira, umang si appatarifu. Wasinoy, nepaanawi Jesusino tolayira, ");
INSERT INTO gdg_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","kasena nakitakay sino adalannera sino abang ta maddammangira a umang sino sakoꞌma Dalmanuta. ");
INSERT INTO gdg_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Agyanino Fariseowera a inang ki Jesus ta makisombatira sikwana. Gafu se angganda a dalodawan, inaranda si mipaita si kakkaꞌbawa senyal sey langit ta pangammuwanda si gakkuruwa i Diosino nanundun sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Nakaannangatti Jesus gafu sino loneno nakamma, e sinapiꞌna si, “Mayan ipatutino tolayira sito ingkein a mipaitak si kakkaꞌbawa senyal sikwara? Gakkuruwino sapitangku sikwayu, awaningke a ipaitak sikwara.” ");
INSERT INTO gdg_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wasin sinapiꞌnenay, inanawannera, e nattakayira kappay andino adalannera sino abang ta maddammangira sino bebay. ");
INSERT INTO gdg_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Nakalyawanino adalannera a nabbalibal si tinapay, e tata ke ino tinapaya ana sikwara sino abang. ");
INSERT INTO gdg_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Sinapiti Jesus sikwara si, “Palanandawino lebadureno Fariseowera andino lebadura i Herodes.” ");
INSERT INTO gdg_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Wasin diningngaggino adalannereno sinapiꞌna, nattatarabbanda si, “Ino nassapitanna sinay, se ammetam nabbalibal si tinapay.” ");
INSERT INTO gdg_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ammuwi Jesusino pattatarabbanda, antuweno kunna sikwara si, “Sandolang paddararananino awana tinapeyu? Nataggakkad yan uluyu ta ammeyu kepay maawatanino pannakadamak? ");
INSERT INTO gdg_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ayan yan matayu, udde ammeyu maiteno inangwak. Ayangkappay yan layaddaw, udde ammeyu madingngaggino sapitangku. Nakalyawandawingkaddino ");
INSERT INTO gdg_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ginaradwaka lima a tinapaya neyanneyu sino limarifuwera a tolay? Pidya a basketino napannu sino inampaꞌdawa nabuna?” “Karadwa,” kunnino adalannera. ");
INSERT INTO gdg_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ino pituwa tinapaya ginaradwaka nakkanino appatarifuwera a tolay, pidya a basketino napannu sino nabuna?” kunni Jesus sikwara. “Pitu,” kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","“Nu kunnenoy, mayan ammeyu kepay maawatanino anggangkuwa sapitan?” kunni Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wasin ginamwangira sey Betsaida, agyanino niyangngira si lalakiya lappat ki Jesus. Nakiggimallakkira sikwana ta appanganna naddino lappat kesi mabbattunoy. ");
INSERT INTO gdg_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Kinewiri Jesusino lappat e neyangnga sino lasinneno lubbun. Iluppanneno matana, kasena inappangan, e nebebuꞌna si, “Waren itannu?” ");
INSERT INTO gdg_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Nallangalangeno lappat e sinapiꞌna si, “Anen. Maitakino tolayira. Kunnangke kayuwera, udde mallakarira.” ");
INSERT INTO gdg_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Inappangangkappayi Jesusino mateno lappat. Nalladdang, e naariyennino lappaꞌna, e nalawarinnino angngitana si ammin. ");
INSERT INTO gdg_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Kase nepaanawi Jesus a nassapit si, “Manokan sey baleyu. Ammekan massippal sino lubbuna inanawanta.” ");
INSERT INTO gdg_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wasinoy, inanda Jesus sino lulubbuna sakopanna Cesarea Filipos. Sin aggelakalakaranda, nebebuti Jesus sino adalannera si, “Sanneno sapitannino tolayira mappeafu sikwak?” ");
INSERT INTO gdg_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Nesombaꞌda si, “Aneno massapitira si ikka i Juan a Gumabawtisar. Kunnino korwanira si ikka i Elias, e kungkappayino korwanira si ikkeno tata gumalabbun siꞌina nangngangoli.” ");
INSERT INTO gdg_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","“Udde ikkayu pay,” kunni Jesus, “sanneno kundaw mappeafu sikwak?” Sinabbi Pedro si, “Ikka i Kristo a nekariyi Dios a gumamwang.” ");
INSERT INTO gdg_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","E netuni Jesus sino adalannera si ammerangke nad ituldu si massiki sanna a tolayino katotolena. ");
INSERT INTO gdg_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Nepakaammuwi Jesus sino adalannereno makwana sikwana so maddagguna aw. Sinapiꞌna si, “Ikkanaka Abbingnga Tolay, maawag si madyatanakungkena. Ammayandakino pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwan. Papapateraꞌnga, udde mangngangoliyaꞌnga sino mekatalluwa aw.” ");
INSERT INTO gdg_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nalawarino nepassapiti Jesus sikwara sinay. Antuweno nebakkangi Pedro e nebuyana ta ammena nad sapitannino kunnenoy. ");
INSERT INTO gdg_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Nabbaliwiti Jesus e sinulangnganneno adalannera, kasena inallangngani Pedro. “Aroyuwannak, Satanas! Se ino dandammannu, bakkannino panggammani Dios, nu ammena lurino panggammanna tolay.” ");
INSERT INTO gdg_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wasinoy, inayani Jesusino odduwera a tolay andino adalannera, e sinapiꞌna sikwara si, “Ino manggamma mesapat sikwak, talekkuranna naddino urenangkepay. Kunnangke buttunganna naddino krusna, se inona urekino tuntulanna, massiki antuweno ipatena. ");
INSERT INTO gdg_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Se ino mikalow sino biyangnga, matekappena. Udde ino matay gafu sino angngurungnga sikwak andino pangibanyanna sino nalawara damag, ananeno biyaya mannayuna iyaꞌda i Dios sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Se sanna kaddino pallawaranneno tolay nu akwana amminino kinabaꞌnang sito lubag, e matena e makastigu si makkikiyad? ");
INSERT INTO gdg_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Awan, se awana kinabaꞌnangnga damana a italyat sino biyangnga ki Dios. ");
INSERT INTO gdg_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Gakkuruwa minalliwatino tolayira sito ingkein e ammerangke tuntulannino urayi Dios. Udde ino tolaya maatalla manaꞌdag sikwak andino itulduk, maatallak kappena a mitaꞌdag sikwana ki Dios nu muliyak. Se ikkanaka Abbingnga Tolay, muliyaꞌnga a kebulunanino anghelira i Dios a mangipaita sino kedayawani Ama.” ");
INSERT INTO gdg_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Sinapikkappayi Jesus sikwara si, “Gakkurug yo sapitangku sikwayu, aneno korwanira sikwayu sitawa ammera matay makkiyad si itandeno pannakadama i Dios sino patturayanna.” ");
INSERT INTO gdg_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Wasin nallaꞌwutino annamma aw, inayanira i Jesus da Pedro, Santiago, anni Juan, e ira pelangino nanuꞌdu sino tata a ataꞌnanga kulud. Sin agyananda sinay, initareno nangkakwanino baggiyi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","E ino barawasina, naffurawa mangngilikilit. Ino kafurona, awaningke kakunnana sito lubag. ");
INSERT INTO gdg_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wasinoy, nappaddara Elias anni Moises, e nakitatabbira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Naddamippayi Pedro e kunna si, “Afu, nalawad se ayawetam sitaw. Mangwakamin lud si talluwa bawi, tata sikwam, tata ki Moises, anna tata kappay ki Elias.” ");
INSERT INTO gdg_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ino nassapitanna sinay, se ammena inammuweno sapitanna, gafu sino nappelalota talora. ");
INSERT INTO gdg_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Kakaꞌmeng kelanga nakulmutanira si dulam, e aneno damita naggabwat sino dulamma kunna si, “Antuyawino iiddukangkuwa Abbingku. Dingngaggandonaddino sapitanna.” ");
INSERT INTO gdg_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Nallangalangeno adalanira, udde awana korwan si initara, nu bakkampelangi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Wasin aggedawadawutira sino kulura nagyananda, netuni Jesus sikwara si, “Ammeyu itutulduwenaya initayu si massiki sanna a tolay makkiyad si ikkanaka Abbingnga Tolay e mangngangoliyaꞌnga.” ");
INSERT INTO gdg_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kinuruwino adalannereno netunna sikwara e awana korwan si nassapitanda, udde nattatarabbanda a tallu nu sanneno anggamma sapitannino sinapiꞌna a mangngangoli kappay. ");
INSERT INTO gdg_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","E nebebuꞌda sikwana si, “Mayan sapitannino mammesturuwerana lintig si muli nad abbuwi Elias a gumalabbun siꞌin, kasena gumamwangino Kristo a nekariyi Dios?” ");
INSERT INTO gdg_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","E nesombati Jesus sikwara si, “Gakkuruwa muli abbuwi Elias ta idadanna ammin. Udde ana kappayino nepeturakki Dios mappeafu sikwaka Abbingnga Tolay. Sapitanna si odduwa dyatino lawumangku e melopalopetak kappay. ");
INSERT INTO gdg_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Udde gakkuruggappayino sapitangku sikwayuwa ginamwanginni Elias, e ingkelanga inangweno tolayira sikwana, a antuweno nepeturakki Dios mappeafu sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Wasin ginamwanda Jesus sino agyananino korwanira a adalanna, initara a odduweno tolaya inaribumbung sikwara. Agyangkappayino mammesturuwerana lintiya makisosombat sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Wasin nedipatino tolayira i Jesus, nakkaꞌbawira, e nalayawira a dinambal sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","“Ma, sanneno passasarombatandaw?” kunni Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","E sinombatino tata sino tolayira e sinapiꞌna si, “Afu, neyangku nad sikwamino abbingkuwa lalaki, se naassaddan si narakkatta espirituwa mappaabul sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Kadda sumruweno inassad sikwana, malletwad, malluluweno wangiꞌna, mangngaratungutino ngipanna, e kumintal ammina baggina. Inarangku sino adalannuwera si paanawanda naddino inassad sikwana, udde ammera dama a akwan.” ");
INSERT INTO gdg_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","“Ikkayuwa tolay sito ingkein, awaningke angnguruddaw!” kunni Jesus sikwara. “Naansa matino panguruwandawa nabayakunna nakiigyan sikwayu? Makapidyak kepaya manus sikwayu? Iyandaw sikwakino abbing.” ");
INSERT INTO gdg_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Neyandeno abbing sikwana. Angngita langino narakkatta espiritu ki Jesus, nepakkoldaꞌneno abbinga inassaddanna, e nabbalabalituweno abbing sino lubagga malluluweno wangiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Nebebuti Jesus sino ameno abbing si, “Kanseno nangiyafuwanna yana takiꞌna?” “Gagangena kiyad sin kabbingnga,” kunnino amana. ");
INSERT INTO gdg_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“Namipidya a netubbeno narakkatta espiritu anna neyassamma sino danum takesi papatayanna nad. Nu wara damama akwan, allakkandakami ta duffunandakami.” ");
INSERT INTO gdg_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","“Sannu lang sapitan si ‘Nu wara damaka akwan’?” kunni Jesus sikwana. “Nu manguruwino tolay ki Dios, awana ammena dama a makwa.” ");
INSERT INTO gdg_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Nekokweno amana a nassapit si, “Manguruwak. Udde pantatuyaggannu naddino angnguruggu se kurang kepay.” ");
INSERT INTO gdg_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Wasin inita i Jesus si umoodduweno tolayira a umaribumbung sikwara, sinapiꞌna sino narakkatta espiritu si, “Ikka a narakkatta espirituwa mappabangngag anna mappaabul sitana abbing, anawannun ta ammekan muli sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Nakkulawuweno narakkatta espiritu, e nappelalotino nepappakoldaꞌna sino abbing, kasena inanaw. Ammenan manikkarino abbinga mallanga natay, antuweno odduwa nassapit si, “Natayin.” ");
INSERT INTO gdg_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Udde iniggammani Jesusino kamaꞌna e ginabwaꞌnan, e nattaꞌdaggin. ");
INSERT INTO gdg_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Wasin sinallunda Jesus andino adalannera sino balaya pagyananda a ira pelang, nebebuꞌda sikwana si, “Mayan ammemi mapaanaw inaya inassad sikwana?” ");
INSERT INTO gdg_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","E nesombati Jesus si, “Ino kunnenaya espiritu, ammena umanaw, nu amme makkararino mappaanaw sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Waso kunnenoy, inanawanda Jesus inaya lubbun e nallakarira sino probinsiya a Galilea. Amme anggammi Jesus si maammuwanino tolayireno pattaꞌlifanda, ");
INSERT INTO gdg_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","se maddagguna tulduwanneno adalannera. Sinapiꞌna sikwara si, “Ikkanaka Abbingnga Tolay, araꞌniyenna meyalawatak sino tolayira ta papatayandak, udde mangngangoliyaꞌnga so mekatalluwa aw.” ");
INSERT INTO gdg_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Udde amme inammuweno adalanira i Jesusino anggamma sapitannino sinapiꞌna, e nababangira a nabbebut sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Wasin ginamwanda Jesus sey Capernaum, sinallungira sino balaya pagyananda, e nebebuti Jesus sino adalannera si, “Sanneno nassasarombatandaw sey dalan?” ");
INSERT INTO gdg_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Udde sininakkira, se ino nassasarombatanda, nu inyeno kapatiyan sikwara ammin. ");
INSERT INTO gdg_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wasinoy, nattutturi Jesus. Inayanneno karadwera a adalanna, e sinapiꞌna sikwara si, “Ino manggamma mebilang si kapatiyan, ipaabbafona naddino baggina a passerbiyanna amminino bafulunnera.” ");
INSERT INTO gdg_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nayi Jesus si tata abbing e nepataꞌdangnga sino naraꞌlanganda, kasena inawakan e sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Ino mangawat sino abbafawa tolaya kakunna yawa abbing gafu sino angngurungnga sikwak, ikkanakino inawaꞌna, e ino mangawat sikwak, inawaꞌna kappayino nanundun sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wasinoy, sinapiti Juan ki Jesus si, “Afu, aneno initamiya tolaya mappaanaw si narakkatta espirituwa usaranneno ngannu, e inallangngammi gafu se bakkanna buluntam.” ");
INSERT INTO gdg_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","“Ammeyu allangngan,” kunni Jesus sikwara, “se ino mangwa si kakkaꞌbawa musar sino ngangku, ammena malana massapit si narakkat mappeafu sikwak. ");
INSERT INTO gdg_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Se ino ammena kumontara sikwatam, antuweno buluntam. ");
INSERT INTO gdg_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Gakkurug yo sapitangku sikwayu, ino manuffun sikwayu, massiki ino mappainum pelang si tatasa a danum sikwayu gafu se adalannakayuwi Kristo, gakkuruwingke a malabutan.” ");
INSERT INTO gdg_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Udde ino manutunggung ta malliwatino tata a abbafawa tolaya mangurug sikwak a mekunna si abbing, tawwaren nu mabassinanino buꞌlona si dokkalla aggilingana batu ta metuꞌyud sino bebay amma sino ituluyneno manutunggung. ");
INSERT INTO gdg_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Kunnantu, nu ino kamaꞌnuweno paggafuwanneno palliwatannu, gaꞌbungannu nad. Se tawwareno nagaꞌbunganino tata a kamaꞌnu e mabiyagga si makkikiyad amma sino sikkakamakka a metubba sino afuya ammena maaddap sey infiyernu. ");
INSERT INTO gdg_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","E nu ino takkimino paggafuwanneno palliwatannu, gaꞌbungannu nad. Se tawwareno nagaꞌbunganino tata a takkim e mabiyagga si makkikiyad amma sino sittatakkika a metubba sino afuy sey infiyernu. ");
INSERT INTO gdg_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","E nu ino matangkappayino paggafuwanneno palliwatannu, tuketannu. Se tawwareno tafiyangka si mata e mabiyagga si makkikiyad sino patturayani Dios amma sino nadduwammangino matama metubba sino afuy sey infiyernu. ");
INSERT INTO gdg_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Se sey infiyernu, ammena matayino uꞌgitira a mangngan sino baggira e ino afuy, ammena maaaddap. ");
INSERT INTO gdg_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Ammina tolay, kakkapandeno dyat ta mallawarino aggangwara a kunnangke ino makkana maasinan nad takesi damana a mewaꞌlat ki Dios. ");
INSERT INTO gdg_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ino asin, aneno serbina, udde nu maariyeno peꞌna, ammenan dama a mampapet. Dandammandonaddino serbineno asin e makkaduduffungkayu takesi nalawarino abbafarulundaw.” ");
INSERT INTO gdg_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Wasinoy, inanora Jesus sey Capernaum e inangngira sino sakoꞌma Judea, kasera naddammang sino wawwanga Jordan. Nakkakarampakkappayino odduwera a tolay sino agyananna, e sinulduwannera, se antuweno gagangaya aggangwana. ");
INSERT INTO gdg_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ana kappayino Fariseowera a inang ki Jesus ta kakkapanda a balabaliyan, e kunda sikwana si, “Sino lintiddam, damana kadda ikatwayino lalakiyeno atawana?” ");
INSERT INTO gdg_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Sinabbira payi Jesus si, “Sanna kaddino netutuni Moises sikwayu siꞌin?” ");
INSERT INTO gdg_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","“Nepalubusi Moises a mangweno lalaki si turakka pangitan si nakkatwayira, kasena paanawannino atawana,” nesombaꞌda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Sinapiti Jesus sikwara si, “Gafu pelang sino kinataggatino uluyuweno nanurakkani Moises si kunnayan. ");
INSERT INTO gdg_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Udde sin gafuna a naparatu yo lubag, pinaratuwi Diosino lalaki anna bafay. ");
INSERT INTO gdg_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Antu gafuna, anawanino lalakiyeno mapparanaꞌngera takesi makikofung sino atawana, ");
INSERT INTO gdg_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","e mabbaliyera si tata. Antuweno ammerana adwa, nu ammerallud nittata. ");
INSERT INTO gdg_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Kunnantu, amme nad pakkatwayanna tolayino nepamungi Dios.” ");
INSERT INTO gdg_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Wasin nulira Jesus sino balera, neyambabebutino adalannereno mappeafu sinaya sinapiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Sinapiti Jesus sikwara si, “Ino lalakiya mikatway sino atawana, kasena mangatawa si korwan, makaliwat sino atawana se makibulun si korwan. ");
INSERT INTO gdg_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Mampesino bafaya mikatway sino atawana, kasena mangatawa si korwan, makaliwakkappay si makibulun.” ");
INSERT INTO gdg_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Agyanino tolayira a niyang sino anaꞌdera ki Jesus takesi appangannera nad anna bindisiyonannera. Udde inallangnganino adalanira i Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Wasin binalawi Jesusino akwanda, nabbungut sikwara, e sinapiꞌna si, “Purayandawino anakira ta umangngira sikwak, e ammeyuwera allangngan. Se ino kakunnara, ireno dama a mesapat sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Gakkurug yo sapitangku sikwayu, nu ammeyu talakkanni Dios a kakunneno annalakkino abbing, ammekayu makatallung sino patturayanna.” ");
INSERT INTO gdg_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wasinoy, inakkuyneno anakira, e netappaꞌneno kamaꞌna sikwara a namindisiyon. ");
INSERT INTO gdg_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Wasin aggegigikkaꞌda Jesus a umanaw sinay, agyanino lalakiya nalayawa inang sikwana. Namalitud sino aꞌlangnga e sinapiꞌna si, “Ikka a nalawara Afu, sanneno akwangku takesi maaꞌdanak si biyaya mannayun?” ");
INSERT INTO gdg_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Sinapiti Jesus sikwana si, “Mayan nganandak si nalawad? Se awana nalawad, nu bakkampelangi Dios. ");
INSERT INTO gdg_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Ammumino lintiyi Dios a kunna si, ‘Ammeka mamapatay, ammeka makibulun, ammeka mattakaw, ammeka manistigu si bakkanna gakkurug, ammeka mamalabali, e dayawannuweno mapparanaꞌnguwera.’” ");
INSERT INTO gdg_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","“Afu mesturu,” kunnino lalaki sikwana, “kiyad sin kabbingku, kinuruggu ammin yana lintig.” ");
INSERT INTO gdg_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Sinulangngani Jesusino lalaki e inanggammanna, e sinapiꞌna si, “Ana kepayino tata a pakkurangannu. Umangngu ilaku amminino kukwam ta iyaꞌdam sino pobiriyereno pallakuwannu, ta ananeno kinabaꞌnangngu sey langit. Nu inangwamunnenay, kaseka muli sitaw e mebulungka sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Wasin diningngangngeno sinapiti Jesus, malowingkeno nakamma, e kakaꞌganna a inanaw, gafu se baꞌnangngingke. ");
INSERT INTO gdg_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wasinoy, nallangalanga i Jesus sino adalannera, kasena sinapit sikwara si, “Madyatingke a mesapatino bafaꞌnangngira sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Nakkaꞌbawira sin diningngaddenay, udde nepidwa kepayi Jesus a nassapit si, “Ikkayuwa abbingku, gakkuruwa madyatingke a mesapatino tolayira sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Mas naladdeno attaffutino kamelyu sino abbuꞌneno bilat amma sino kesapatanino baꞌnangnga tolay sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Nangkakaꞌbokappayino adalannera, e nebebuꞌda sikwana si, “Nu kunnenoy, inya maꞌneno mesalakan?” ");
INSERT INTO gdg_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Sinulangngannera, kasena sinapit si, “Ino tolay, awana damana a akwan a misalak sino bagginangkepay. Udde i Dios, damana akwan ammin. Antuweno makadama a misalak si tolay.” ");
INSERT INTO gdg_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wasinoy, naddamiti Pedro, e sinapiꞌna si, “Ikkami mappaye? Se inanawamminnino amammimmi ta mebulungkami sikwam.” ");
INSERT INTO gdg_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","“Gakkurug yo sapitangku sikwayu,” kunni Jesus, “ino manganaw sino balena, ino kakkolaꞌngera, ino mapparanaꞌngera, ino anaꞌngera, andino lubangnga gafu sikwak annino pangibanyanna sino nalawara damag, ");
INSERT INTO gdg_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","oodduneno meyaꞌda sikwana sito katolena amma sino inanawanna. Oodduneno maappana a balay, kakkolak, mapparanak, aanak, anna lubag, udde madyatangkappay. E naso maddagguna aw, maaꞌdanna si biyaya mannayun. ");
INSERT INTO gdg_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Odduweno meyantaw sito ingkein a metabbafana sinoya aw, e odduwera kappaya abbafawa tolay sito ingkein a meyantona.” ");
INSERT INTO gdg_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Sinoya umangnganda Jesus sey Jerusalem, nauunta i Jesus sino bafulunnera. Nakkaꞌbawino adalannera e nattalokappayino korwanira a tolaya dumandan sikwana. Wasinoy, inayani Jesusino karadwera a adalanna e nebakkangngera, kasena sinapit sikwareno makwana sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Dingngaggandaw,” kunni Jesus sikwara. “Sitoya, umangngetam sey Jerusalem. Nanu gumamwangetam sinay, ikkanaka Abbingnga Tolay, meyalawataꞌnga sino pangafuwanirana padi andino mammesturuwerana lintig. Sentensiyandaꞌnga a mapapatay, kaserak iyalawat sino bakkannira a Judyu. ");
INSERT INTO gdg_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Pappoporayandaꞌnga, luluppandak, siwaꞌwattandak, kaserak papatayan. Udde sino mekatalluwa aw, mangngangoliyaꞌnga.” ");
INSERT INTO gdg_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wasinoy, inaraꞌnira Santiago anni Juan a abbingi Zebedeo ki Jesus, e sinapiꞌda si, “Afu, ana naddino arangngammi sikwam.” ");
INSERT INTO gdg_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","“Sanneno anggandawa akwangku sikwayu?” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","“Nu madaꞌngeno kedayawannu sino patturayannu, makituttuggami nad sikwam, tata sino padiwanannu, tata sino padawim,” kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Sinapiti Jesus sikwara si, “Ammeyu ammuweno arangngandaw. Damayu kadda attammanino dyata lawumangku? Damayu kadda matay a kunnangkeno ipatek?” ");
INSERT INTO gdg_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","“On, damami,” kunda. E sinapiti Jesus sikwara si, “Gakkuruwa madyatangkayu a kunna kappayino kadyatangku. Matekayu kappay a kunneno ipatek. ");
INSERT INTO gdg_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Udde ino mattutturira sino padiwanangku anna sino padawik, awana kalintiyangkuwa mamili, se piniliyenni Diosino mattutturira sinay.” ");
INSERT INTO gdg_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Wasin diningngaggino tafuluwera a bulundeno inaranda Santiago anni Juan, nabbungutira sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Antu gafuna, inamungira ammini Jesus, e sinapiꞌna sikwara si, “Ammuyu si ino mebilangira a matturay sito lubag, ipatuꞌdeno panggammanda sino iturayanda, e ino kappay pangafuwanira, ipaitareno kinaturera. ");
INSERT INTO gdg_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Udde ammena nad kunninoyino akwandaw. Se nu wara sikwayuwa manggamma medayaw, passerbiyanna naddino bafulunnera. ");
INSERT INTO gdg_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","E ino manggamma mabbali si kapatiyan, paaripanna naddino baggina si ammina tolay. ");
INSERT INTO gdg_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Se massiki ikkanaka Abbingnga Tolay, ammek inang sito lubagga mappaserbi, nu ammena lud ta masserbiyak sino tolayira anna takesi iyaꞌdakino biyagguwa panubbut sino kaodduwan.” ");
INSERT INTO gdg_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wasinoy, ginamwanda Jesus andino adalannera sey Jerico. Wasin umanawanda, odduwa tolaya nebulun sikwara. Agyanino lappatta aggatuttud sino dammingino dalana makipalimut, i Bartimeoweno nganna, a abbingi Timeo. ");
INSERT INTO gdg_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Anningngangnga lang si ana i Jesus a taga-Nazaret, nekokwana a nassapit si, “Jesus, gaka i David, allakkandak!” ");
INSERT INTO gdg_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Odduweno tolayira a nallang sikwana ta suminaꞌngad, udde neyangkakokwana lura nassapit si, “Ikka a gaka i David, allakkandak!” ");
INSERT INTO gdg_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nitturi Jesus e sinapiꞌna si, “Ayandaw taw.” Inayandeno lappat, e sinapiꞌda sikwana si, “Pattuyaggannu naddino nakammu. Mattaꞌdagga se paayaddaka.” ");
INSERT INTO gdg_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Aꞌari langi Bartimeo sino tafalna, e ginabwatin a inaraꞌni ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","E sinapiti Jesus sikwana si, “Sanneno anggammuwa akwangku sikwam?” “Afu, anggangkuwa makaita,” kunnino lappat. ");
INSERT INTO gdg_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","“Damamunna umanaw. Makaitakan gafu sino angngurungngu sikwak,” kunni Jesus sikwana. Kakaꞌmeng kelanga makaiteno lappat e dinandan ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Wasin makkataminda Jesus sey Jerusalem, agyaniran sino nallatanna Betfage anna Betania, adwa a lubbuna araꞌni sino kulura Olivo. Nepaunta i Jesusino adwera a adalanna ");
INSERT INTO gdg_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","a sinapiꞌna si, “Umangkayu sino madompaka lubbun. Addatandaw sinay, maitayuneno neyakadda ubbunna asno a ammena kepay natakayan. Ubbarandaw ta iyandaw sitaw. ");
INSERT INTO gdg_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Nu wara mabbebut sikwayu si, ‘Sandolang ubbaran yan?’, kundaw sikwana si, ‘Awannino Afutam, e lanannana a peuli.’” ");
INSERT INTO gdg_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wasinoy, inangngira, e nesaꞌbaldeno ubbunna asno. Nagyan sino dammingngeno dalana neyakad sino lamwanganino tata a balay. Wasin ubbarandan, ");
INSERT INTO gdg_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","nebebutino tolayira a aggataꞌdag sinay si, “Sandolang ubbaran yan?” ");
INSERT INTO gdg_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Nesombaꞌdeno netuni Jesus sikwara, antuweno nepurayireno nangita sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Neyandeno ubbun ki Jesus. Neyafaꞌdeno tafalda sino daruruna, kase nattakayi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Odduweno tolayira sinaya niyafak sino tafalda sino dalan. Ino korwanira pay, nangappera si iddadona simit sino uma, kasera neyafakkappay sino dalan, a mangipaita sino angngiyatalda ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ino tolayira so katamanna andino dumandanira sikwana, nekokwara a nassapit si, “Madandayawi Dios! Madandayokappenaddino dinunduni Afu Dios si pannakabaggina! ");
INSERT INTO gdg_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Madandayonaddino matturena a kakunna i Ari David a gagginafutam! Madandayawi Dios sey langit!” ");
INSERT INTO gdg_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Wasin ginamwangira sey Jerusalem, sinallungi Jesus sino Templo, e initana amminino ana sinay. Gafu se gafenin, inanaw, e inangngira andino karadwera a adalanna sey Betania. ");
INSERT INTO gdg_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Wasi kadaramaꞌna a mulira Jesus sey Jerusalem a naggabwat sey Betania, nabisinan. ");
INSERT INTO gdg_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Aneno nedipaꞌna a kayuwa igosa iddadaron, e inaraꞌniyanna ta itanna nu wara bungana. Udde wasin araꞌniyen, passiya adonino initana, se bakkangkepayino pammunganna igos. ");
INSERT INTO gdg_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Antuweno nassapitani Jesus sino kayu si, “Mangiyafu sito ingkein, ammekanna mammunga.” E diningngaggino adalannereno sinapiꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Wasin ginamwangira sey Jerusalem, sinallungi Jesus sino Templo, e nepaanoneno mallakuwera andino maggatangira sinay. Iletwanneno lamisaanino gumatalyatira si pirak, kunna kappay sino tutturino gumalakuwera si kalapati. ");
INSERT INTO gdg_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Nepalammaꞌna kappayino miggammira si karga a mangan sino lawummeno Templo. ");
INSERT INTO gdg_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Sinulduwanneno tolayira, e kunna si, “Neturak sino sapiti Dios si ‘Ino balek, maingnganan si pakkararan ammina tolay.’ Udde ino inangwayu, nepabbaliyu si paddarogatandaw sino kasittoleyu.” ");
INSERT INTO gdg_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Diningngaggino pangafuwanirana padi andino mammesturuwerana lintig inoya inangwa i Jesus, e nattatarabbanda nu ansandeno mamapatay sikwana. Se nattalawira sikwana, gafu se nakkaꞌbaw amminino tolayira sino annulduna. ");
INSERT INTO gdg_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Wasin mallammukin, inanora Jesus andino adalannera sinaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Wasi kagigiꞌbaꞌna, sinaꞌlifanda Jesusino kayuwa igos, e initara a naganguwen, pati sino gamuꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Dinandammi Pedroweno sinapiti Jesus sino kayu, kasena sinapit sikwana si, “Afu, itannu kadda, ino kayuwa ginerannu, naganguwen.” ");
INSERT INTO gdg_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Sinapiti Jesus sikwara si, “Wara nad angnguruddaw ki Dios. ");
INSERT INTO gdg_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Gakkurug yo sapitangku sikwayu, nu kuruwandaw si meyakkuruwino sapitandaw a ammekayungke maddudwa, damayuwa sapitan sito kulud si, ‘Meyalikka e meyassagga sino bebay,’ e gakkuruwa makwa. ");
INSERT INTO gdg_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Antu gafuna, sapitangku sikwayu, massiki sanneno arangngandaw ki Dios sino kararaddaw, dandammandonad si inappayun, e gakkuruwingke a meyaꞌda sikwayu. ");
INSERT INTO gdg_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Kadda makkararaggayu, nu wara nakaliwat sikwayu, pakomandonad, takesi pakomampayi Dios a Amatam sey langitino liwaꞌdawira. ");
INSERT INTO gdg_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Udde nu ammekayu mamakoma, ammerakayu pena pakomanino Amatam sey langit.” ");
INSERT INTO gdg_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Wasinoy, ginamwanginda Jesus sey Jerusalem. Wasin malallakari Jesus sino lawumma Templo, inaraꞌniyeno pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwan. ");
INSERT INTO gdg_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nebebuꞌda sikwana si, “Sanneno kalintiyannuwa mangwa sino inangwamira? Inyeno naggabwatanna yana kalintiyannu?” ");
INSERT INTO gdg_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Sinapikkappayi Jesus sikwara si, “Aneno ibebukku sikwayu. Nu masombatandaw, kaseppena sapitannino naggabwatanino kalintiyangkuwa mangwa sito inangwakira. ");
INSERT INTO gdg_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Antuyawino ibebukku. Inyeno naggabwatanino kalintiyani Juan a mamawtisar? Ki Dios onnu si tolay?” ");
INSERT INTO gdg_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Wasinoy, nakkakibikibebutira a nassapit si, “Sanneno isombattam? Nu kuntam si i Diosino naggabwatanino kalintiyanna, tantaro nu sapitanni Jesus si ‘Nu kunnenoy, mayan ammekayu nangurug sikwana?’ ");
INSERT INTO gdg_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Udde nu kuntam si tolepelangino naggabwatanna, kattalatalaw inay!” Ino nassapitanda sinay, se nattalawira sino tolayira, se kuruwanda ammin si tata a gumalabbuni Juan. ");
INSERT INTO gdg_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Antu gafuna, sinapiꞌda ki Jesus si, “Ammemi inammu.” Kunni Jesus sikwara si, “Ammeppemantu sapitan sikwayu nu inyeno naggabwatanino kalintiyangkuwa mangwa sitawira a akwangku.” ");
INSERT INTO gdg_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wasinoy, netuluyi Jesusino sinapiꞌna sikwara, udde neyamparingnga. Sinapiꞌna si, “Agyanino tata a tolaya nammula si odduwa ubas. Inalasangngeno nammulanna, nangwa si pamappattanna sino bungana, e namataꞌdag si garita a pagyananino pindagganna. Wasin nabalin inoy, nepaimuꞌna sino makikasamakkira, e inang nagyan si aroyuwa lubbun. ");
INSERT INTO gdg_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Wasin nadaꞌngeno abbafuwat si ubas, dinundunino makwan lubaggino tata a aripanna a umang sino makikasamakkira a mappa sino ballena. ");
INSERT INTO gdg_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Udde wasin ginamwang, dinoꞌmanino makikasamakkira, siniwasiwaꞌwattanda, kasera nepaanawa kamakamaꞌna pelang. ");
INSERT INTO gdg_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Wasinoy, nanundungkappayino makwan lubag si tata a aripanna. Udde pinopompaꞌdeno uluna e neyatatalda. ");
INSERT INTO gdg_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Nandadundungkappay si tata, e pinapatera. Kunnenayino inangwara sino ammina dinundunna, binadabadduꞌdeno korwanira e pinapatereno korwan. ");
INSERT INTO gdg_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Waso kunnenoy, tatakeinnino nabuna a dundunanna. Antuweno iiddukannangke a abbingnga. Dinundunna kappay sikwara, se kunna sino nakamma si ‘Ammuk si iyatalda yaw se abbingku.’ ");
INSERT INTO gdg_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Udde wasin initeno makikasamakkira, sinapiꞌda si, ‘Antuwen yawino millalupat sito lubag. Papatayantam ta akwatamun!’ ");
INSERT INTO gdg_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Dinoꞌmandan e pinapatera, kasera netakkufino baggina sino lasinneno kaubasan.” ");
INSERT INTO gdg_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Wasinoy, kunni Jesus si, “Sannadeno akwanino makwan lubag sikwara a makikasamak? Umangngerana papatayan, kasena ipabalattino lubangnga si korwan. ");
INSERT INTO gdg_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Ammeyu kepekad binaseno nepeturakki Dios a kunna si, ‘Ino batuwa inammayino mamataꞌdaggira si balay, antuweno nepabbaliyi Dios si kapatiyana batuwa mappatuyag sino balay. ");
INSERT INTO gdg_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Antuweno inangwa i Dios, e kakkaꞌbawingke sikwatam.’ ” ");
INSERT INTO gdg_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Sin diningngaddenay, anggammino afafuwerana Judyu a doꞌmani Jesus, se naawatanda si ireno ampariyanna. Udde nattalawira sino tolayira, antuweno inanawanda. ");
INSERT INTO gdg_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Waso kunnenoy, nanundunino afafuwerana Judyu si korwanira a Fariseo andino korwanira a buyuti Herodes a umang mabbebut ki Jesus, tantaro nu mabalabaliyan e massapit si kedarumanna. ");
INSERT INTO gdg_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Inangngira sikwana, e sinapiꞌda si, “Afu, ammumi si gakkurug ammina sapitannu. Ammumi kappay si awana padumannu si tolay, massiki nu wara turera, nu ammemira lud tulduwan ammin sino kakuruwan mappeafu sino panggammani Dios. Kunnantu, ituldummad sikwami nu kontara sino lintiddama Judyu nu pagammiyeno buwit sino Emperador sey Roma. Pagammi onnu awan?” ");
INSERT INTO gdg_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Udde inattalani Jesusino gakkadda a mamalabali sikwana, antuweno sinapiꞌna sikwara si, “Mayan kalakannandak? Aꞌdandaꞌmantu si pirak ta itangku.” ");
INSERT INTO gdg_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Wasin inaꞌdanda si pirak, kunna sikwara si, “Makwan letratu anna angan sitaw?” “Ino Emperador sey Roma,” kunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","“Nu kunnenoy,” kunni Jesus, “ino akweno Emperador, iyaꞌdayu sikwana, e ino akwa i Dios, iyaꞌdayu pay ki Dios.” Sin naningngagganda sinay, nakkaꞌbawira ammin sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ana kappayino Saduceowera a inang ki Jesus. Ireno tata a buyuꞌna Judyu a massapit si ammena mangngangoliyeno natayira. Sinapiꞌda sikwana si, ");
INSERT INTO gdg_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Afu, kunnino lintiddama neturakki Moises, ‘Nu wara matawa a awana abbinda e matayino lalaki, atawan naddino kolaꞌngeno balu takesi nu wara abbinda, antuneno guman abbingino natay.’ ");
INSERT INTO gdg_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Agyanino pituwera a makkakarolaka lallaki. Nangataweno palungura, udde nataya awana abbinda. ");
INSERT INTO gdg_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Antuweno inataweno metufarino balu, udde natekappaya awana abbinda. Kunna kappay sino mekatalluwa kolaꞌda. ");
INSERT INTO gdg_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Nappatapataliyeno pituwera a makkakarolaka inatawenaya bafay, e natayira ammina awana abbinda, kase pay natayino bafay. ");
INSERT INTO gdg_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kunnantu, naso awa pangngangoliyanino natayira, inyana sikwara a pituweno makwan atawa sinaya bafay? Se inatawara ammin.” ");
INSERT INTO gdg_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Sinombatanira i Jesus si, “Natamakayu, se ammeyu ammuweno neturakka sapiti Dios e ammeyu kappay ammuweno pannakadamana. ");
INSERT INTO gdg_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Se nanu mangngangoliyeno natayira, ammeran mangatawa, nu ammera lud mekunna sino anghelira sey langit. ");
INSERT INTO gdg_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Nu mappeafu kappay sino pangngangoliyanino natayira, kunnangke ammeyu binaseno nepeturakki Dios ki Moises sino istoriyaneno gumatagatangnga kayu. Ino neturak sinay, kunna si sinapiti Dios ki Moises si, ‘Ikkanakino Diosi Abraham, i Isaac, anni Jacob.’ Antuweno sinapiꞌna si massiki natayiran, nabiyayira kepay sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ino anggamma sapitan, mangngangoliyeno natayira, se i Dios, bakkanna Diosino natayira, nu ammena lurino aggabiyayira. Antuweno gakkuruwingke a natamakayu.” ");
INSERT INTO gdg_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Agyanino mesturuna lintiya naningngag sino nattatarabbanda Jesus andino Saduceowera. Gafu se diningngangnga si nalawarino sombati Jesus sikwara, inaraꞌni sikwana a nabbebut si, “Sanneno kapatiyana tun sino ammina lintiyi Dios?” ");
INSERT INTO gdg_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Netabbi Jesus si, “Antuyawino kapatiyana tuni Dios. ‘Ikkayuwa gakagaka i Israel, dingngaggandaw yaw. Tatakeno Afutama i Afu Dios, awana korwan. ");
INSERT INTO gdg_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Anggammannu naddi Dios a Afum, e pittatannuweno ammina nakammu, ammina urem, ammina kinalaingngu, annino ammina tuyangngu sikwana.’ ");
INSERT INTO gdg_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Ino kappay mekadwa a kapatiyan, kunnayaw, ‘Anggammannu naddino kasittolema kunna payino agganggammu sino baggim.’ Awana korwana tuni Dios a napatig amma sitawira.” ");
INSERT INTO gdg_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","“Afu, gakkuruwino sinapiꞌnu,” kunnino mesturuna lintig. “Gakkuruwa tata ke i Dios e awana korwan. ");
INSERT INTO gdg_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Gakkuruggappaya anggammantammad e pittatantamino ammina nakantam, kinalaintam, annino tuyaddam sikwana, e anggammantangkappenaddino kasittoletama kunna payino agganggantam sino baggitam. Mas nalawad nu kuruwantam inayira a adwa a tun amma sino miwaꞌlatetam si animal ki Dios anna miyaꞌdetam si korwan sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Wasin diningngaggi Jesusino nalawara sombaꞌna, sinapiꞌna sikwana si, “Araꞌniyennino kesapatannu sino patturayani Dios.” Kiyad sinoy, awaninna makaturira mabbebut ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Wasin panulduwani Jesus sino Templo, sinapiꞌna si, “Mayan kunnino mammesturuwerana lintig si gaka i Ari David ino Kristo? ");
INSERT INTO gdg_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Se i Daviringkepayino nappadandammanino Espirituwi Dios a nassapit si, ‘Sinapiti Afu Dios ki Kristo a Afuk: Mattuttugga sito padiwanangku kiyad si affutangkuweno kalingam.’ ");
INSERT INTO gdg_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Nu ingnganani David ino Kristo si Afuna a matturay sikwana, ansanda lang sapitan si gaka i David?” Anggammino odduwera a tolaya maningngag sino sapitanna. ");
INSERT INTO gdg_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Sin nanulduwanna sikwara, sinapiꞌna kappay si, “Palanandawino mammesturuwerana lintig takesi ammeyu tuntulannino aggangwara. Se angganda a mabbarawasi si ataꞌnang anna nalawad takesi malasin si napatiyira. Angganda kappaya medayawa mapakumusta sino mangita sikwara kadda mallakarira sino palengki. ");
INSERT INTO gdg_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Pilinda kappaya pattutturanino attutturanna napatiya tolay sino sinagoga, e kunna kappay nu umangngira makipangngan, pilinda a pakitutturanino pangafuwanira. ");
INSERT INTO gdg_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Massannakammira sino baluwera a bafabbay se akiranda a pangappan sino kukwara andino bafalera, e makkararira si asodda kararag se angganda a kallabbanino narakkatta aggangwara. Nadammattingkeneno kastigura.” ");
INSERT INTO gdg_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wasinoy, inaraꞌniyi Jesus sino aggiittungan si pirak sino Templo, e nattuttura nabbuya sino tolayira a miittung si pirak. Odduweno bafaꞌnangngira a niittung si odduwa pirak. ");
INSERT INTO gdg_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ginamwangino tata a pobiriya balu, e niittung si adwa a dipilata, a mabbalor si tata a sentabo. ");
INSERT INTO gdg_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Nepaaraꞌniyi Jesusino adalannera, e sinapiꞌna sikwara si, “Gakkurug yo sapitangku sikwayu, oodduweno neyittungino pobiriya balu amma sino ammina neyittungino korwanira. ");
INSERT INTO gdg_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Se ino korwanira, neyaꞌdara pelangino sobraneno kinabaꞌnanda, udde ino balu, massiki pobiri, neyaꞌdana amminino kabiyayanna.” ");
INSERT INTO gdg_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Wasin mallawanda Jesus sino Templo, sinapitino tata adalanna si, “Afu, itannu. Nalawaringke yo Templo andino bafalayira sito lebanna. Kakkaꞌbokappayino batuwera a inusarda se darokkallirangke anna nalawarira.” ");
INSERT INTO gdg_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","“On lud,” kunni Jesus, “itandawira nad ammin yana darokkalla balay, se madaꞌnganeno awa madarallira ammin. Awaningkena tata si batuwa mabattang sino agyananna, se maduduwirana.” ");
INSERT INTO gdg_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Wasinoy, inangngira sino kulura Olivo, e nattutturi Jesus a midipat sino Templo. Inaraꞌnira Pedro, Santiago, Juan, anni Andres sikwana a ira pelang, e sinapiꞌda si, ");
INSERT INTO gdg_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Ituldum abbu sikwami nu naanseno kaangwannenaya sinapiꞌnu, anna sannaneno senyala pilasinammi si araꞌniyennino keyakkuruwanda.” ");
INSERT INTO gdg_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Netabbi Jesus si, “Palanandaw ta ammekayu mabalabaliyan. ");
INSERT INTO gdg_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Se odduweraneno gumamwanga massapit si ira kanuweno Kristo a dinunduni Dios a matturay, e odduneno balabaliyanda. ");
INSERT INTO gdg_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Dingngaggandokappeneno maggagarubattira sino araꞌni sikwayu annino damag mappeafu sino gubat sey korwana lubbun, udde ammekayu nad mattalaw. Maawag si makwerana yaw, udde bakkangkepayino uddina aw. ");
INSERT INTO gdg_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Se maggagubaꞌneno naddadaruma a lulubbun, mampesino patturayandera. Maluniggappena si palulubbun, e ananeno nafulota bisin. Udde amminira yaw, gafuna pelangino kadyatana kunnangkeno loneno kuyungnga gapapanak. ");
INSERT INTO gdg_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Mappalangkayu nad, se doꞌmandakayuna e idarundakayu anna siwaꞌwattandakayu sino sinagogarera. Gafu sino angnguruddaw sikwak, medarungkayu kappena sino gubernadorira anda sino ariyera, e antuneno wayayuwa mipakammu sikwara sino nalawara damag. ");
INSERT INTO gdg_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Se inaya nalawara damag, mebanyangngad abbu si palulubbun, kasena madaꞌngeno uddina aw. ");
INSERT INTO gdg_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Nu doꞌmandakayuna e imbistigarandakayu, ammeyu paddararananino sapitandaw, se sinoyna a orat, mepakaammu sikwayuweno fustuwa sapitandona. Se bakkanna ikkayuweno paggabwatanna, nu amme lud ipadandammino Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Sinoyna a tiyempo, ananeno midarumira si kolaꞌda sino tatturayira ta papatayanda. Kunna kappayino akwanneno mapparanakira sino abbinda. Inona kappay aanakira, kontarandeno mapparanaꞌdera ta ipapapaterera. ");
INSERT INTO gdg_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Ammina tolay, kababannaddakayuna gafu sino kesapatandaw sikwak. Udde nu natalanggaggayuwa mangurug kiyad si madaꞌngeno uddina, mesalakkayu.” ");
INSERT INTO gdg_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Netuluyi Jesus a nassapit si, “Itandoneno ‘kattalatalawingke a manandaral’ a mattaꞌdag sino bakkanna kalintiyanna a pattaꞌdaggan. (Ino mabbasa sitaw, maawatanna naddino anggamma sapitan.) Nu maitayuna, ino magyanira sey Judea, mabbukalira nadda umang sino kakuluran. ");
INSERT INTO gdg_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Inona agyan sino lasinneno balena, ammenan nad sumallunga mappa sino maawangnga. ");
INSERT INTO gdg_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Kunna kappeneno magyan sino umana, ammenan nad umapita mappa sino barawasina. ");
INSERT INTO gdg_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Sinoyna a tiyempo, kakallaꞌngeno mabussitira andino mappasusuwera. ");
INSERT INTO gdg_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ikararaddaw ta ammena nad makwa yaw nu aggururan. ");
INSERT INTO gdg_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Se sinoyna a tiyempo, nappelaloꞌneno dyat, e awana kakunnana mangiyafu sin naparatuwanna yo lubag kiyad to ingkein, e ammenan mepipidwa si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Nu amme nad dinandammi Dios a arananino awnenaya kadyatan, awan nadda mabuna si tolay sito lubag. Udde gafu sino allaꞌnga sino pinilinera a tolena, aranannana.” ");
INSERT INTO gdg_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Netuluy kappayi Jesus a nassapit si, “Sinoyna a tiyempo, nu wara massapit sikwayu si ‘Itandaw, ayawinnino Kristo’ onnu ‘Anen sinay,’ ammeyuwera kuruwan. ");
INSERT INTO gdg_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Se odduneno massan Kristo andino massasanlabbuna massapit si ireno dinunduni Dios. Mipaiterana si kakkaꞌbawa senyal anna milagro takesi balabaliyanda naddino tolayira, massiki ino tolayira a piniliyi Dios, nu damana. ");
INSERT INTO gdg_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kunnantu, mappalangkayu, se dinadangkunna sinapitira yaw sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Nanu masindunenaya tiyempona dyat, mallammuꞌngeno sinag anna ammenana maddakkag. ");
INSERT INTO gdg_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Madaraꞌnangngeno bitunira, se maguyaddino ammina ana sey langit. ");
INSERT INTO gdg_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Antuneno pangitanino tolayira sikwaka Abbingnga Tolaya maggabwat sey langita mebulun si dulam. Itanda kappeneno nappelalota pannakadamak andino kedayawangku. ");
INSERT INTO gdg_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Dundunangkuneno anghelkuwera sino papampangnga yo lubag ta pakkakarampattandeno tolekira a pinilik sino palulubbun sito utunna lubag.” ");
INSERT INTO gdg_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Wasinoy, sinapiti Jesus si, “Dandammandonaddino kayuwa igos ta wara padalandaw. Nu mallalimuddutino tangatangana e mandadaron, ammuyu si araniꞌyennino dawun. ");
INSERT INTO gdg_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Kunna kappay, nu itandawa makweno sinapikku sikwayu, ammuyun si araꞌniyennino puliyangku. ");
INSERT INTO gdg_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Gakkurug yo sapitangku sikwayu, ananeno korwanira sikwayu sitawa ammera matay liyeya meyakkurug amminino sinapikku. ");
INSERT INTO gdg_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Maawanneno langit anyo lubag, udde ammenana maawanino sapikku si makkikiyad, nu ammena lud meyakkurug ammin.” ");
INSERT INTO gdg_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Sinapikkappayi Jesus si, “Awana makaammu nu sannaneno aw anna oratta keyakkuruwanino sinapikku mappeafu sino puliyangku. Ino anghelira sey langit, ammera ammu, anna massiki ikkanaka Abbingnga Tolay, ammek kappay ammu. Se awana mangammu nu bakkampelangi Dios a Ama. ");
INSERT INTO gdg_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Mappalangkayu nad e kanayungkayuwa maddadan, se ammeyu ammu nu naansa a makwa. ");
INSERT INTO gdg_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","“Ino keyampariyanna yaw, ino tata tolaya umang si aroyuwa lubbun, e italaꞌngeno balena sino aripannera. Kadda tata sikwara, aꞌdannera si tarabafura, e itunna kappay sino mindag sino lamwangan ta nalawannaddino aggimuꞌna. ");
INSERT INTO gdg_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Kunnantu, maddadangkayu, se ammeyu ammu nu naanseno puliyangkuwa makwan balay, nu fufuwab, tangngana gafi, araꞌni si aw, onnu si gigiꞌbat. ");
INSERT INTO gdg_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Antuweno maddadangkayu, tantaro nu kakaꞌmeng kelanga muliyak e madaꞌngatakayuwa aggakaturug. ");
INSERT INTO gdg_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Iyawira a sinapikku sikwayu, sapitangku kappay sino ammina tolay, takesi maddadangkayu ammin.” ");
INSERT INTO gdg_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Wasin adwa aw kepay kaseneno fiyestana Judyu a mingngan si Laꞌwutan annino fiyesta a pangngananda si tinapaya awana lebadurana, nattatarabbanino pangafuwanirana padi andino mammesturuwerana lintig nu ansandeno mappadoꞌma ki Jesus a awana makaammu takesi papapatera. ");
INSERT INTO gdg_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","E sinapiꞌda si, “Ammetammad iyindan sino fiyesta, tantaro nu makungkulino tolayira.” ");
INSERT INTO gdg_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Wasin agyanda Jesus sey Betania, inangngira sino balera Simon a nakkutal siꞌin. Sin aggekakkanira, ginamwangino tata a bafaya niggam si beduruwa naangwa si alabastrowa napannu si nangina a bambanguwa mingngan si nardo. Binukkatanneno beduru e nesibungnga sino uluwi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nabbungutino korwanira a nagyan sinay, e sinapiꞌda si, “Mayan tatangganna pelangino bambangug? ");
INSERT INTO gdg_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nelakuna nad, se ino balorna, nasuruk sino masweldu si tarun. Nu kunna nad inayino inangwana, wara nad meyaꞌdana sino mekakallakkira.” E inaallangngandeno bafay. ");
INSERT INTO gdg_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Udde sinapiti Jesus si, “Sandolang allangngan? Purayandopelang. Nalawarino inangwana sikwak. ");
INSERT INTO gdg_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Se ino mekakallakkira, kanayuna anera sikwayu, e massiki sanna a orat, damayuwera a duffunan nu anggandaw. Udde sikwak, ammek mabaya makiigyan sikwayu. ");
INSERT INTO gdg_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","E iyawa bafay, inangwaneno damana a akwan sikwak. Nesibungngeno bambangug sikwak takesi idadanneno baggik liyeneno ketanammangku. ");
INSERT INTO gdg_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Gakkurug yo sapitangku sikwayu, massiki sintawa lubbun sito lubaggino kebanyanneno nalawara damag, masapikkappeneno inangwa yawa bafay ta panandammanino tolayira sikwana.” ");
INSERT INTO gdg_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Wasinoy, i Judas Iscariote a tata sino karadwera a adalani Jesus, inang sino pangafuwanirana padi ta makitulag nu sanneno akwanna a manuffun sikwara ta doꞌmanda i Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Maanggammingkeno padiyera sin diningngaddeno sinapiti Judas, e nekarira si aꞌdanda si pirak. Antu gafuna, neyafuwenni Judas a manandam sino nalawara tiyempowa pappadoꞌmanna ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Nadaꞌngeno awa pangiyafuwanino fiyestana Tinapaya Awana Lebadurana, a antu kappayino awa pamartiyanda sino ubbunna karnerowa isirara sino fiyestana Laꞌwutan. Inangngino adalanira i Jesus sikwana, e nebebuꞌda si, “Sintawino anggammuwa pidadanammi sino akkanantam sino fiyestana Laꞌwutan?” ");
INSERT INTO gdg_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Antuweno dinunduni Jesusino adwera a adalanna a nassapit si, “Umangkayu sey lubbuna Jerusalem, e ananeno madambaldawa lalakiya mattu si tagafa a danum. Dandanandona sino balaya umangnganna, ");
INSERT INTO gdg_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","e sapitandaw sino makwan balay si, ‘Kunnino Afumi, sintawino kwartuwa pakipangnganammi andino adalangkuwera sino fiyestana Laꞌwutan?’ ");
INSERT INTO gdg_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Ipaitanana sikwayuweno nangkalekaya dokkalla kwartuwa ana amminino maawaddam. Sinayino pidadanandaw sino pamuwaddam sino fiyesta.” ");
INSERT INTO gdg_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wasinoy, ginikkatino adwera a adalanna, e inangngira sey Jerusalem. Nesaꞌbalda gakkuruwino sinapiti Jesus sikwara, e nedadandeno pamuwadda. ");
INSERT INTO gdg_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Wasi gafenin, ginamwanda Jesus andino karadwera a adalanna sinaya balay. ");
INSERT INTO gdg_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Wasin aggekakkanira, sinapiti Jesus sikwara si, “Gakkurug yo sapitangku sikwayu, aneno tata sikwayuwa makipangngan sikwaka mangifuyut sino manggammira a mamapatay sikwak.” ");
INSERT INTO gdg_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Malowino nakanda, e nappatapataliyera a nabbebut sikwana si, “Ikkanaꞌngalangino sapitannu?” ");
INSERT INTO gdg_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Nesombati Jesus si, “Gakkuruwa tata sikwayuwa karadwa, tata a makisosaw sikwak si tinapay sito malukung. ");
INSERT INTO gdg_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Se ikkanaka Abbingnga Tolay, gakkuruwa matayak takesi meyakkuruwino nepeturakki Dios siꞌin. Udde kakallappeneno mangifuyut sino manggammira a mamapatay sikwak. Unoyna nad nu ammena neyanak!” ");
INSERT INTO gdg_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Wasin aggekakkanira kepay, nappa i Jesus si tinapay e nappasalamat ki Dios, kasena ginaradwa e neyannena sino adalannera a nassapit si, “Appandaw, se antuyawino baggik.” ");
INSERT INTO gdg_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","E nangappa kappay si kopa a napannu si diyuna ubas, e nappasalamat ki Dios, kasena neyaꞌda sikwara e ininumira ammin. ");
INSERT INTO gdg_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","E sinapiꞌna sikwara si, “Antuyawino adak a mamakurug sino bawuwa tulagi Dios. Se mebubbuneno adak takesi odduneno tolaya mapakomanino liwaꞌda. ");
INSERT INTO gdg_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Gakkurug yo sapitangku sikwayu, ammekunna uminum si diyuna ubas kiyad sino awa uminumak si bawuwa diyuna ubas sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Wasinoy, nakkantera si paddayaw ki Dios, e nanawira sinay e inangngira sino kulura Olivo. ");
INSERT INTO gdg_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Sinapiti Jesus sino adalannera si, “Ikkayu ammin, anawandaꞌnga e mabbukalkayu, se antuweno anggamma sapitannino nepeturakki Dios a kunna si, ‘Papatayangkuneno mimut sino karnerowera, e makkakaratwayiran.’ ");
INSERT INTO gdg_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Udde nu pangngangolindaꞌnga i Dios, untanantakayuna a umang sey Galilea.” ");
INSERT INTO gdg_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Wasinoy, sinapiti Pedro si, “Massiki nu mabbukal amminino bafulungkuwera, ammetaka anawan.” ");
INSERT INTO gdg_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Kunni Jesus sikwana si, “Gakkurug yo sapitangku sikwam, sito gafi, liyeya ipidweno lalunga massirallot, namiꞌluwannakunna neimad.” ");
INSERT INTO gdg_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Udde nepatukkappayi Pedro a nassapit si, “Massiki nu matayaꞌnga a melot sikwam, ammetakangkena a iyimad.” Kunna kappayino sinapitino ammina bafulunnera a adalan. ");
INSERT INTO gdg_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Inanda Jesus andino adalannera sino kakayuwana mingngan si Getsemani, e sinapiꞌna sikwara si, “Mattuttuggayu sitaw ta umangngak makkararag.” ");
INSERT INTO gdg_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ino pelang nebulunna, da Pedro, Santiago, anni Juan. Mangiyafu sinoy, malowingkeno nakamma e maddararan, ");
INSERT INTO gdg_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","e sinapiꞌna sikwara si, “Nappelalotingkeno loneno nakangku a kunnangke antuweno ipatek. Agyangkayu taw e mabbiraggayu.” ");
INSERT INTO gdg_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Wasinoy, nebakkangi Jesus sikwara, kasena nassakabba makkararag, a nu damana, ammena nad meyakkuruwino dyata makwana sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“Ama,” sinapiꞌna, “damama mangwa si ammin. Antuweno arangngangku si ammem iyakkurug iyawa dyata araꞌniyen a makwa sikwak. Udde bakkan naddino anggangkuweno makwa, nu ammena lurino panggammannu.” ");
INSERT INTO gdg_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Wasin nuliyi Jesus sino agyananino talluwera a adalanna, dinaꞌnganera a maturug. Antuweno sinapiꞌna ki Pedro si, “Simon, maturugga? Ammeka kad makapabbirag si taoraꞌlang? ");
INSERT INTO gdg_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ammekayu maturug, nu ammekayu lud makkararag, takesi ammekayu matutunggungan. Se ammukino nakandaw, anggandawa mangurug, udde nakafuy langino baggiyu.” ");
INSERT INTO gdg_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nebakkang kappayi Jesus a nakkararag, e nepidwaneno arangnga. ");
INSERT INTO gdg_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Nuli kappay sino agyananino talluwera a adalanna, e dinaꞌnganera kappaya aggakaturug, se matatukappirangke. Inafaꞌnera e ammera inammuweno isombaꞌda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Wasin piꞌlunana muli, sinapiꞌna sikwara si, “Aggakaturuggayu kepaya mimwang? Kundenin! Se nadaꞌngennino oratta ikkanaka Abbingnga Tolay, meyalawatakun sino minalliwatira a tolay. ");
INSERT INTO gdg_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Gumabwakkayu, se anennino mappadoꞌma sikwak. Antam dambalan.” ");
INSERT INTO gdg_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Wasin aggedamadamikkepayi Jesus, ginamwangi Judas a tata sino karadwera a adalanna. Odduweno tolaya nebulun sikwana a nassisaset anna nassibafaꞌgung. Ireno dinundunino pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Agyanino sinapiti Judas sino bafulunnera ta maimunuwanda i Jesus. Kunna si, “Inona ummangku, antuneno doꞌmandaw. Iyanoyuna e lawarandawa gafutan.” ");
INSERT INTO gdg_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Antuweno wasin ginamwangiran, nakkangkami Judas a inaraꞌni ki Jesus. “Afu,” kunna sikwana, e inummana a kunnangke ikalona. ");
INSERT INTO gdg_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","E dinoꞌmanda i Jesus e ginafuꞌda si nalawad. ");
INSERT INTO gdg_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Udde ino tata a bulunna a aggataꞌdag sinay, sinuꞌnuꞌneno saseꞌna, e binakangngeno aripannino afafuna padi e nagingaranino layangnga. ");
INSERT INTO gdg_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Wasinoy, sinapiti Jesus sikwara si, “Ma, narakkattaka tolay ta nassisaset anna nassibafaꞌgungkayuwa umang manoꞌma sikwak? ");
INSERT INTO gdg_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Kadda awa agyanak sino Templo a manuldu sikwayu. Mayan bakkanna sinayino nanoꞌmandaw sikwak? Udde maawag si makwa yaw ta meyakkuruwino nepeturakki Dios.” ");
INSERT INTO gdg_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Waso kunnenoy, nabbafukal amminino adalannera e inanawanda i Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Agyanino tata buwanaka dinandan ki Jesus a nattafal pelang si ulat. Kinakkapanda a doꞌman e ginafuꞌdeno nepattafalna, ");
INSERT INTO gdg_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","udde newarsina e nalayawa nabbukala awaningke barawasina. ");
INSERT INTO gdg_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Neyanda i Jesus sino balayino afafuna padiya nakkakarampattanino pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Dumadandani Pedro sino gafanda kiyad si ginamwang sino kalawatannenaya balay. Nakituttud sino gwardiyera a makigarenu. ");
INSERT INTO gdg_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ino pangafuwanirana padi andino korwanira a nakkakarampat, niintufukira si pamakurudda ta paliwatanda i Jesus ta ipapapatera, udde awana sinumpalanda, ");
INSERT INTO gdg_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","se massiki odduweno nanistigu si siri mappeafu sikwana, ammena nakkakarunneno sinapiꞌda. ");
INSERT INTO gdg_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wasinoy, nattaꞌdaggino korwanira a manistigu si siri mappeafu sikwana. Sinapiꞌda si, ");
INSERT INTO gdg_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Ino diningngammiya sinapiꞌna, darallanna kanuweno Templotama inangwana tolay, e si unangnga talluwa aw, mamataꞌdagganu si tata a bakkanna tolayino mangwa.” ");
INSERT INTO gdg_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Udde massiki kunnenoyino netistigura, ammena nakkunneno nepassapiꞌda. ");
INSERT INTO gdg_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wasinoy, nattaꞌdaggino afafuna padi sino naraꞌlanganda, e sinapiꞌna ki Jesus si, “Ma, awana isombaꞌnu sino ipaliwaꞌda sikwam?” ");
INSERT INTO gdg_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Udde sininappelangi Jesus a ammena sinombat. Antuweno nabbebukkappayino afafuna padi sikwana si, “Ikka kaddino Kristo a Abbingino madandayawa Dios?” ");
INSERT INTO gdg_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","“On, ikkanak,” kunni Jesus. “Itandaꞌnga a Abbingnga Tolaya aggatuttud sino padiwanani Dios a mannakadama. Itandak kappena a muliya maggabwat sey langita mebulun si dulam.” ");
INSERT INTO gdg_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Sin diningngangngenay, pinissayino afafuna padiyeno barawasinangkepaya mangipaita sino bunguꞌna, e sinapiꞌna si, “Anna kepayino awantama manistigu? ");
INSERT INTO gdg_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Diningngaddam amminino sinapiꞌna a ikunnaneno baggina ki Dios. Sanneno ureyuwa makwa sikwana?” E sinombatira ammin si mapapatenad. ");
INSERT INTO gdg_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ilupaluppanino korwanira. Inabbungandeno mutungnga, kasera sinatampalan e sinapiꞌda si, “Kunnu si gumalabbungka. Sapitannu nu inyeno nanampal sikwam.” Kunna kappayino gwardiyera a niyanaw sikwana, sinusultuꞌda. ");
INSERT INTO gdg_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Agyangkepayi Pedro sino kalawatan sin inaraꞌniyeno tata a balatanga aripannino afafuna padi. ");
INSERT INTO gdg_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Wasin initana i Pedro a maggarenu, inimuꞌnakkanna, kasena sinapit si, “Massiki ikka, nebumbulangka ki Jesus a taga-Nazaret.” ");
INSERT INTO gdg_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Udde neimanna a nassapit si, “Ammek ammu yan sapitannu. Ammek maawatan.” Ginabwati Pedro e inang sino pampangnga kalawatana araꞌni sino dalan. E antuwempayino nassirallotanino lalung. ");
INSERT INTO gdg_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Inita kappayino balatang sinay, e sinapiꞌna sino korwanira a tolay si, “Inaya lalaki, tata kappay sikwara.” ");
INSERT INTO gdg_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Udde neimaggappayi Pedro. Ammena mabayag e sinapikkappayino tolayira sinay si, “Gakkuruwa tataka a bulunna, se taga-Galileaka kappay.” ");
INSERT INTO gdg_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Udde nesapata i Pedro a nassapit si, “Massiki matayak nu ammena gakkurug yo sapitangku. Ammek gakkuruwa ammu yan tolaya sapitandaw.” ");
INSERT INTO gdg_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Assapiꞌna lang sinoy, nassirallokkappayino lalung. Dinandammi Pedroweno sinapiti Jesus a “Liyeya ipidweno lalunga massirallot, namiꞌluwannakunna neimad.” E nakatangit gafu sino loneno nakamma. ");
INSERT INTO gdg_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Wasin gigiꞌbattin, nammamitingino pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwan, ira ammina aneno turera a mangukum, e nattatarabbanda nu sanneno akwanda ki Jesus. Wasinoy, binaluddeno kamaꞌna, kasera inang neyalawat ki Gubernador Pilato. ");
INSERT INTO gdg_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Nebebuti Pilato sikwana si, “Ikkeno Arina Judyu?” “Nu antuweno sapitannu, antu,” nesombati Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Odduweno nepaliwatino pangafuwanirana padi sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Antuweno nebebuti Pilato sikwana si, “Diningngangnguweno odduwa nepaliwaꞌda sikwam. Awangkad mesombaꞌnu?” ");
INSERT INTO gdg_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Udde amme pelang sinombati Jesus, antuweno nakkaꞌbawi Pilato. ");
INSERT INTO gdg_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Ino gagangayi Gubernador Pilato, kadda fiyestana Laꞌwutan, aneno tata a pallawananna a balura pilinino tolayira. ");
INSERT INTO gdg_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Sinoya tiyempo, odduweno balurira a nakapapatay si tolay sin nakiyubattanda sino gubiyernu, e i Barrabasino nganino tata. ");
INSERT INTO gdg_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Waso kunnenoy, nakkakarampattino odduwera a tolay sino agyanani Pilato, e inaranda si mappalawan nad si tata a balud, se antuweno aꞌakwanna. ");
INSERT INTO gdg_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Sinapiti Pilato si, “Anggandaw ta pallawanangkuweno Arina Judyu?” ");
INSERT INTO gdg_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Kunnenoyino nebebuꞌna, se ammuna si neyalawatino pangafuwanirana padiyi Jesus sikwana gafu sino apalda. ");
INSERT INTO gdg_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Udde sinutunggunganino pangafuwanirana padiyeno tolayira takesi i Barrabasino arangnganda a mallawan. ");
INSERT INTO gdg_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","“Nu kunnenoy,” kunni Pilato, “sanna mantuweno akwangku sitawa tolaya nganandaw si Arina Judyu?” ");
INSERT INTO gdg_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","“Ilansam si krus!” kunda a nekulawu. ");
INSERT INTO gdg_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","“Ma? Sanna maꞌlurino liwaꞌna?” kunni Pilato. Udde neyangkakulawura si, “Ilansam si krus!” ");
INSERT INTO gdg_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Gafu se anggammi Pilato a panggammanino tolayira, nepallawanna i Barrabas, udde i Jesus, nepasiwaꞌwaꞌna, kasena neyalawat sino sindaluwera ta ilansara si krus. ");
INSERT INTO gdg_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Netallungino sindaluwera i Jesus sino balayino gubernador, e inayanda amminino bafulundera a sindalu. ");
INSERT INTO gdg_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Binarawasiyanda i Jesus si ataꞌnanga barawasiya nalibaga a kunnangke barawasina ari. Binalikokawandeno nasasit, e nesingaꞌda sikwana a kunnangke koronana. ");
INSERT INTO gdg_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","E nassandayawira sikwana a nassapit si, “Madayoka nadda Arina Judyu!” ");
INSERT INTO gdg_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Pinopompolda anna ilupaluppanda, e namaliturira a nassandayaw sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Wasin nasinduwera a nappoporay sikwana, inarireno nebarawasira sikwana a nalibaga, e nepatalira kappayino dadana barawasina, kasera neyang sino pilansanda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Wasin agyanira kepay sino dalan, dinambaldeno tata tolaya umang sey Jerusalem a naggabwat sino agguman, e pinatuꞌda a nepabuttungino krusi Jesus. Inaya tolay, i Simon a taga-Cirene a amara Alejandro anni Rufo. ");
INSERT INTO gdg_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Neyanda i Jesus sey Golgota, ino anggamma sapitan, ino agyananino takataꞌnga ulu. ");
INSERT INTO gdg_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Wasin ginamwangira sinay, painumanda i Jesus si tayuwa nalamuran si mirra a mappaaranan si malow, udde ammena ininum. ");
INSERT INTO gdg_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","E nelansara sino krus. Wasinoy, ginaradwareno barawasina, e nabbabinnunutira ta itanda nu sanneno appannino kadda tata sikwara. ");
INSERT INTO gdg_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Alas nuwebe si gigiꞌbattino nilansanda ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Aneno neturakka itulduneno nepaliwat sikwana a kunna si “Arina Judyu.” ");
INSERT INTO gdg_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Agyangkappayino adwera a gumattakawa neyindana nelansa si krus, tata sino padiwananna, tata sino padawina. ");
INSERT INTO gdg_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Antuweno neyakkuruwanino nepeturakki Dios a kunna si, “Nebilang sino narakkattira a tolay.” ");
INSERT INTO gdg_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ino nattaꞌlifira, wawwarangngiwangnganda a aꞌayoyungana massapit si, “Matta kunnu si darallannuweno Templo, kasengkappay pataꞌdaggan si talluwa aw? ");
INSERT INTO gdg_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Nu kunnenoy, salakannu antu yan baggim ta mulluggan sitan krus!” ");
INSERT INTO gdg_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Massiki ino pangafuwanirana padi andino mammesturuwerana lintig, inaꞌayoyunganda kappayi Jesus a massapit si, “Nesalaꞌngeno korwana tolay, udde ammena makaisalak sino bagginangkepay. ");
INSERT INTO gdg_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nu itantammaddi Kristo a Aritama gakagakana Israel a umullug sino krusna, manguruwetammad sikwana.” Massiki ino adwera a nelansa si krus sino idangnga, nakiayoyungira kappay. ");
INSERT INTO gdg_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Wasin alas doseyin, nallammukino palulubbun kiyad si tallu orat. ");
INSERT INTO gdg_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Wasin alas tresin si fuwab, nekokwa i Jesus a naddamit a nassapit si, “Eloi, Eloi, lama sabaktani?”, ino anggamma sapitan, “Diosku, Diosku, mayan inanawandak?” ");
INSERT INTO gdg_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wasin diningngaggino korwanira a nagyan sinay, sinapiꞌda si, “Dingngaggandokadda, ayanna i Elias.” ");
INSERT INTO gdg_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Nalayawino tata sikwara a inang nangappa si kunnangke kapat. Nesosona si kilam, kasena pinakaw si biltak ta iyaddangnga ki Jesus ta sussupanna. “Itantamma nu gumamwangi Elias a miyullug sikwana sino krus,” kunna. ");
INSERT INTO gdg_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Wasinoy, nakkulawuwi Jesus e natayin. ");
INSERT INTO gdg_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Neyindana napissayino kortina a nanaldak sino Kadidiosana Kwartuneno Templo, a neyafu sino kalekay kiyad sino difafa. ");
INSERT INTO gdg_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Wasin initeno kapitanna sindaluwa agyan sino aꞌlangnga krusino nepappatayi Jesus, sinapiꞌna si, “Gakkurug ikka a Abbingi Dios yawa tolay.” ");
INSERT INTO gdg_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Agyangkappayino bafabbayira a aggadipat sino makwa. Ino korwan sikwara, i Maria Magdalena, i Salome, anni Maria a inara Jose anni Santiago a Bibissang. ");
INSERT INTO gdg_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Inayira a bafabbayino nebumbulun ki Jesus a nanuffun sikwana sin nagyananna sey Galilea. Agyangkappay sinayino odduwera a bafabbaya nebulun ki Jesus sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Inaya aw, awna paddadananino Judyuwera sino awanda sino awna aggimwangan. Wasin fuwafin, ");
INSERT INTO gdg_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","agyani Jose a taga-Arimatea a naturira inang ki Pilato a marang sino baggiyi Jesus. I Jose, tata a madayawa afafuweno Judyuwera a mattaron sino gumwanganino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Nakkaꞌbawi Pilato sin nadingngangnga si natayinni Jesus, e nepaayangngeno kapitanna sindalu ta bebutanna nu gakkurug. ");
INSERT INTO gdg_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Sinapitino kapitan si gakkuruwa natay, antuweno neoni Pilato si umang appanni Jose ino baggiyi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Inang neyulluwi Jose ino baggiyi Jesus sino krus, e binaꞌbattanna si nafurawa sinnuna bawuwa ginatangnga. Neyekwana si tanamma neyabbut si batuwa kunnangke agweb, kasena nangalleling si daꞌdap a paggakuꞌna sino tanam. ");
INSERT INTO gdg_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Agyangkappera Maria Magdalena anni Maria a ina i Jose a nangita sino netanammani Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Wasin massiꞌlappin si awna aggimwangan, inanda Maria Magdalena, Salome, anni Maria a ina i Santiago a naggatang si bambangug takesi umanda iyekwa sino baggiyi Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Wasi gigiꞌbaꞌna Linggu, ginikkatira a inang sino tanamma. Siniltakinni sinag sin ginamwanganda. ");
INSERT INTO gdg_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Wasin agyanira kepay sino dalan, nattatarabbanda si, “Inyeno ayantama mangalleling sino daꞌdapa gagaluꞌneno tanam?” ");
INSERT INTO gdg_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Kunnenoyino nattatarabbanda, se dokal maꞌlurino batu. Udde wasin ginamwangira, initara a naariyennino batu. ");
INSERT INTO gdg_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Sinallungira sino tanam, e aneno initara a buwanaka nabbarawasi si nafurawa aggatuttud sino padiwananda. E nalaꞌgatira a nakaita sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Sinapitino buwanak sikwara si, “Ammekayu mattalaw. Ammuk si tufukandawi Jesus a taga-Nazaret a nelansa sino krus. Udde awanin sitaw, se nangngangoliyen. Itandaw, antuyawino niwagganda sikwana. ");
INSERT INTO gdg_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Manokayun ta umandaw ituldu ki Pedro andino korwanira a adalanna si untanandakayuwi Jesus a umang sey Galilea. Itandona sinay a kunna kappayino sinapiꞌna sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nallawanino bafabbayira sino tanam, e nalayawira a nanaw. Nalaꞌgatirangke e mayyaꞌyakkira sino talora. Awana nassapitanda si massiki sanna a tolay, se nappelalotino talora. ");
INSERT INTO gdg_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Wasin gigiꞌbaꞌna Lingguwa nangngangoliyani Jesus, naunta a nappadda ki Maria Magdalena a antuweno nappaanawanna si pituwa narakkatta espiritu. ");
INSERT INTO gdg_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Inangngi Maria sino agyananino adalanira i Jesus a aggetangatangitira kepay gafu sino loneno nakanda. Sinapiꞌna si initana i Jesus. ");
INSERT INTO gdg_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Udde massiki diningngaddeno sinapiꞌna a nangngangoliyenni Jesus anna nappadda sikwana, ammera kinurug. ");
INSERT INTO gdg_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Wasinoy, nappadda kappayi Jesus sino adwera a adalanna sin aggelakalakarira a umang sino agguman, udde ammena nekunneno kaitanna. ");
INSERT INTO gdg_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Nuliyeno adwera a adalan e netuldura sino bafulundera, udde ammerera kappaya kinurug. ");
INSERT INTO gdg_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Wasinoy, nappadda i Jesus sino kadwafuluwera si tata a adalanna sin aggekakkananda. Inallangngannera gafu se awaningke a angngurudda anna nataggatino ulura, se ammera kinuruwino nakaitera sikwana a nangngangoliyen. ");
INSERT INTO gdg_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Sinapiꞌna sikwara si, “Umangkayu si ammina lulubbun to lubag ta ibanyaddawino nalawara damag si ammina tolay. ");
INSERT INTO gdg_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ino tolaya mangurug anna mabawtisaran, mesalakanna, udde ino tolaya ammena mangurug, makastiguna. ");
INSERT INTO gdg_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Kunnayawino senyala ipaiteno manguruwira. Paanawandeno narakkattira a espiritu gafu sino pannakadameno ngangku, e makadamitira si korwana damita ammera kinalakammu. ");
INSERT INTO gdg_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Massiki nu makaiggammira si ulag onnu makainumira si kappatay, awana makwa sikwara. Damara a appanganino matakitira, e mabbattunoyira.” ");
INSERT INTO gdg_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Wasin nasinduwenni Jesus a nakitatabbag sikwara, netulluwen sey langit e nattuttud sino padiwanani Dios. ");
INSERT INTO gdg_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","E inangngino adalannera a nangibanyag sino nalawara damag sino ammina lulubbun. Dinuffunanira i Afu Jesus e nepaitana si gakkuruwino netuldura gafu sino kakkaꞌbawa senyala nepaangwana sikwara.");
INSERT INTO gdg_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Antuyawino turakku sikwama madandayawa Afu Teofilo. Odduwereno nanurak mappeafu sino ammina naangwa sito agyanantam. ");
INSERT INTO gdg_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Ino neturaꞌda, ino netuldu sikwamiyeno nangitera mangiyafu sin gafuna anna inang nangibanyag mappeafu ki Afu Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Gafu se nabbababebutak mappeafu sinayira a naangwa mangiyafu sino gafuna, dinandangku si nalawad nu urnusangkuwenaya istoriya, kasek iturak sikwam. ");
INSERT INTO gdg_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Se anggangku si ammunnungke si gakkuruwino ammina netuldu sikwam. ");
INSERT INTO gdg_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Sin natturayani Ari Herodes sey Judea, agyanino padiya mingngan si Zacarias a tata sino buyutino papadiyera a gakagakera i Abias. I Elisabet a atawana, gaka kappayi Aaron a padi siꞌin. ");
INSERT INTO gdg_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ira a matawa, naggaddangngira sino angngita i Dios, se kinurudda amminino tunna anna lintingnga. ");
INSERT INTO gdg_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Udde awana abbinda, se lupatti Elisabet e lakay anna bakattiran. ");
INSERT INTO gdg_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Wasi tata si aw, nadaꞌngeno batangngino buyutira i Zacarias a masserbi ki Dios sino Templo. ");
INSERT INTO gdg_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ino gagangayino papadiyera, mabbibinnunutira nu sanneno tarabafuweno kadda tata sikwara, e i Zacariasino nabbunuta sumallung sino Templo a massikkul si bambangug. ");
INSERT INTO gdg_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Wasin sikkulannanino bambangug sino dolam, makkararimpayino odduwera a tolay sino lasin. ");
INSERT INTO gdg_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Kakaꞌmeng kelanga nappaddeno angheli Afu Dios sikwana a aggataꞌdag sino padiwananneno assikkulanda si bambangug. ");
INSERT INTO gdg_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Nalaꞌgati Zacarias sin initana e nakatalawingke. ");
INSERT INTO gdg_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Udde sinapitino anghel si, “Ammeka mattalaw, Zacarias, se diningngaggi Diosino kararangngu. Manaꞌnga i Elisabet a atawam si lalaki, e ingnganannuna si Juan. ");
INSERT INTO gdg_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Maanggangkayungkena, e oddu kappeneno tolayira a maanggam gafu sino keyanakanna, ");
INSERT INTO gdg_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","se napatiyingkena so angngita i Afu Dios. Maawag si ammenangkena minum si diyuna ubas onnu korwana kabbok, se sino liyena kepaya meyanak, anenneno Espirituwi Dios sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Odduneno bafulunnuwera a gakagaka i Israel a pulinna ki Dios a Afura. ");
INSERT INTO gdg_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Mauntana sino dundunanni Afu Dios a Kristo. Inona pannakadamana, kakunneno pannakadama a neyaꞌdeno Espirituwi Dios ki Elias a gumalabbun siꞌin. Pakkapakakolinnera a matatama sino passasarombatanda, e pulinna kappayino nammayira ki Dios sikwana takesi mekunneno nakanda sino naggaddangngira a tolay. Antuneno akwanna takesi maddadanino tolayira sino gumamwanganino Afura.” ");
INSERT INTO gdg_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wasinoy, sinapiti Zacarias sino anghel si, “On, udde ansangku mangammu si makwa yan a lakayakun anna bakattinnino atawak?” ");
INSERT INTO gdg_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Sinapikkappayino anghel si, “Ikkanaki Gabriel a masserbi ki Dios, e antuweno nanundun sikwaka mipakaammu sitawa nalawara damag sikwam. ");
INSERT INTO gdg_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Udde gafu se ammem kuruwannino sinapikku, ammekana makadamit kiyad sino awa makwenay. Se gakkuruwingke a meyakkuruwino sinapikku nu madaꞌnganeno awa piniliyi Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Wasinoy, ino tolayira sino lasin, taronandeno pallawananni Zacarias, e nakkaꞌbawira se nabayingke sino unangngeno Templo. ");
INSERT INTO gdg_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Wasin nallawan, ammenan makadamit. Antuweno naammuwanda si aneno nepaita i Dios sikwana sino unangngeno Templo. Gafu se ammenan makadamit, sengyappelangino akkitatabbangnga sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Wasin nasinduwennino batangngi Zacarias sino Templo, kasena nuli sey lubbunda. ");
INSERT INTO gdg_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ammena nabayag e nabussiti Elisabet a atawana, e lima dakka ammena nallawalawan sino balera. ");
INSERT INTO gdg_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","Kunna sino nakanakamma si, “Gakkuruwa inallaꞌngaki Afu Dios. Se inarineno neyatatallangku sino tolayira gafu sino awana abbingku.” ");
INSERT INTO gdg_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Wasin annamma dakkinnino bussiti Elisabet, dinunduni Diosino anghelna a i Gabriel sey Nazaret a tata a lubbun sino probinsiya a Galilea. ");
INSERT INTO gdg_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Se aneno nepesapiꞌna sino tata a balatanga ammena kepay nasenggera neturatuwa meatawa ki Jose a gaka i Ari David. I Maria ino nganna. ");
INSERT INTO gdg_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Inangngino anghel sikwana, e sinapiꞌna si, “Maanggangka nad, se inallaꞌdaka i Dios, e imutandaka.” ");
INSERT INTO gdg_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Nakungkulino nakammi Maria sino sinapitino anghel, e pakadadandammanna nu sanneno anggamma sapitan. ");
INSERT INTO gdg_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","“Ammeka mattalaw, Maria,” kunnino anghel sikwana. “Se inallaꞌdaka i Dios. ");
INSERT INTO gdg_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Mabussikkana, e lalakiyeno iyanaꞌngu, e nganannuna si Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Napatingnga e maingngananna si Abbingi Dios a Kapatiyan. Pabbalinna kappayi Dios si ari a kakunna i Ari David a gagginafuna siꞌin, ");
INSERT INTO gdg_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","e antuneno matturay sino tolenera a gakagaka i Jacob si makkikiyad. Awaningkena pakkiyaranneno patturayanna.” ");
INSERT INTO gdg_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Wasinoy, sinapiti Maria sino anghel si, “On, udde ansanna a makwa yaw, a awangkepay nanengged sikwak?” ");
INSERT INTO gdg_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Sinabbino anghel si, “Umangnga sikwamino Espirituwi Dios, e gafu sino pannakadamana, makweno sinapikku. Antu gafuna, nadiosanneno iyanaꞌngu e maingngananna si Abbingi Dios. ");
INSERT INTO gdg_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Dandammannuwi Elisabet a wayima kunda si lupat. Massiki bakattin, nabussikkepay, e annamma dakkinnino bussiꞌna a lalaki. ");
INSERT INTO gdg_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Se awana amme dama a akwani Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Antuweno sinapiti Maria si, “Ayawaka aripanni Afu Dios. Makwa nad sikwakino sinapiꞌnu.” Wasinoy, inanawinnino anghel. ");
INSERT INTO gdg_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ammena nabayag, ginikkati Maria e nakkangkama inang sino tata lubbun sino kakuluran sey Judea ");
INSERT INTO gdg_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","a agyananda Zacarias. Wasin ginamwang sinay, sinallung sino balera, e nappakaammu ki Elisabet sino ginamwanganna. ");
INSERT INTO gdg_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Anningngallangi Elisabet sino damiti Maria, nanikkarino kaluꞌbit sino kuyungnga anna inangngino Espirituwi Dios sikwana, ");
INSERT INTO gdg_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","antuweno nekokwana a sinapit si, “Ikkeno binindisiyonani Dios amma sino ammina bafabbay, e bindisiyonanna kappayino kaluꞌbita iyanaꞌnguna! ");
INSERT INTO gdg_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Sanneno katolek ta inangka maddoraw sikwak, ikka a ineno Afuk? ");
INSERT INTO gdg_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Se anningngaggu langino damiꞌnu, nanikkarino kaluꞌbit sino kuyungku gafu sino aanggamma. ");
INSERT INTO gdg_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Nagasakka se kinurungngu si meyakkuruwino sinapiti Afu Dios sikwam.” ");
INSERT INTO gdg_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Wasinoy, sinapiti Maria si, “Dayawangkungke i Afu Dios, ");
INSERT INTO gdg_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","e nappelalotino aanggangku gafu sikwana a mangisalak sikwak, ");
INSERT INTO gdg_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","se dinandandaka abbafawa aripanna. Antuweno mangiyafu sito ingkein, sapitannino amminira a tolay si nagasatak ");
INSERT INTO gdg_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","gafu sino kakkaꞌbawa inangweno mannakadama a Dios sikwak. Awana kakunnaneno kedayawanna. ");
INSERT INTO gdg_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Minangkallak sino amminira a tolaya miyatal sikwana mangiyafu sino pappalunguwera kiyad sino gakagakarera. ");
INSERT INTO gdg_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Ipaitaneno pannakadamana sino akwanna, se affutanneno natansitira a tolaya miyantaw sino baggira. ");
INSERT INTO gdg_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Ariyanneno pannakadameno matturayira e iyantoneno abbafawira a tolay. ");
INSERT INTO gdg_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Aꞌdanneno mekakallakkira sino ammina nalawara awanda, udde ino bafaꞌnangngira, paanawannera a kamakamaꞌda pelang. ");
INSERT INTO gdg_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","Duffunandetama tolena a gakagaka i Israel, se aggadandammanneno nekarina sin gagginafutamira. ");
INSERT INTO gdg_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","Se akwanneno nekarina ki Abraham a allakkanna annino gakagakanera si makkikiyad.” Antuweno sinapiti Maria a naddayaw ki Dios. ");
INSERT INTO gdg_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Nakiagyani Maria sikwara Elisabet si talluwa dakkag, kasena inanaw sey balera. ");
INSERT INTO gdg_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Wasin nadaꞌngeno panakani Elisabet, lalakiyeno neyanaꞌnga. ");
INSERT INTO gdg_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Wasin naammuwanino kalubbunandera andino wawwayirereno dokalla allakki Dios sikwara, maanggammira kappay. ");
INSERT INTO gdg_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Wasin walu awinnino kaluꞌbit, a antuweno pakkugitanda sikwana, nakkakarampattira ammin. Angganda a ingnganan sino nganino amana a i Zacarias, ");
INSERT INTO gdg_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","udde kunnino inana si, “Bakkan. I Juanino pingngantam sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","“On, udde awana wayiyu si mingngan si kunnayan,” kunnino tolayira sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Antuweno sinengyattanda i Zacarias ta ammunda nu sanneno anggamma a pingngan sino kaluꞌbit. ");
INSERT INTO gdg_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Narangngi Zacarias si panurakkanna, e ino neturaꞌnga, “Juanino anganna.” Nakkaꞌbaw amminino nagyanira sinay. ");
INSERT INTO gdg_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Kakaꞌmeng kelanga nakadamiti Zacarias, e nedandayona i Dios. ");
INSERT INTO gdg_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Nakkaꞌbaw amminino kalubbunandera, e naddinnamag inaya nakwa sino ammina lulubbun sino kakuluran sey Judea. ");
INSERT INTO gdg_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ammina naningngag, aggadandammandenay e kunda si, “Sannadeno pabbalinannenaya kaluꞌbit?” Se maiten si anen sikwaneno pannakadama i Dios. ");
INSERT INTO gdg_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Wasinoy, naaꞌdani Zacarias sino Espirituwi Dios, e nallabbuna nassapit si, ");
INSERT INTO gdg_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Dayawantami Dios a Afutama gakagaka i Israel, se umang sitawa manuffun anna manubbut sikwatama tolena. ");
INSERT INTO gdg_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Se dundunanneno mannakadama a mangisalak sikwatam a antuweno gaka i Ari David a aripanna. ");
INSERT INTO gdg_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Antu kappayino nekarina a nepasapit sino nadiosanira a gumalabbunna siꞌin, ");
INSERT INTO gdg_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","sin nassapitanda si isalaꞌdetam sino kalingatamira anda sino ammina makkababannag sikwatam. ");
INSERT INTO gdg_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Antuweno keyakkuruwanneno sinapiꞌna sino gagginafutamira a allakkannera, annino pipaitanna si akwanneno netulangnga sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","Se nassapata ki Abraham a gagginafutam si ");
INSERT INTO gdg_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","isalaꞌdetam sino kalingatamira takesi ammetam mattalawa masserbi sikwana ");
INSERT INTO gdg_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","anna takesi nadiosanetam anna naggaddang sino angngitana sito katoletam. ");
INSERT INTO gdg_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","“E ikka paya abbingku, ikkaneno maingnganan si gumalabbuni Dios a Kapatiyan, se mauntaka sino Afutam ta idadannuweno tolayira sino gamwanganna. ");
INSERT INTO gdg_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Ituldumma sikwara si isalakanira i Dios gafu sino kapakomanino liwaꞌda. ");
INSERT INTO gdg_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Se naallakkingke i Dios a Afutam. Antu gafuna, aneno dundunanna a maggabwat sey langita misalak sikwatam. Ino gamwanganna, meyamparig sino lattakanna sinag si gigiꞌbat, ");
INSERT INTO gdg_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","se nu gumamwang, waldandetama tolaya ana si lammuka mattalawa matay, e tulduwandetam sino akwantammad takesi massiyanaꞌngeno nakantam.” Antuweno nelabbuni Zacarias. ");
INSERT INTO gdg_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Wasinoy, dinokkallino abbingnga, e nattuyaggino angngurungnga ki Dios. Wasin dokallin, inang nagyan sino kalolowat kiyad si nadaꞌngeno tiyempowa piyafuwanna a manuldu sino kasittolenera a gakagaka i Israel. ");
INSERT INTO gdg_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Sinoya tiyempo, netunino Emperadorna Roma a i Augusto si mappalista amminino tolayira a iturayanna. ");
INSERT INTO gdg_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Iyawa palunguwa nappalistanda sino tolayira, nakwa sin i Kirenio ino gubernador sey Siria. ");
INSERT INTO gdg_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Antu gafuna, inang amminino tolayira a mappalista sino lubbuna nagyananino gagginafurera siꞌin. ");
INSERT INTO gdg_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","I Jose pay, ginikkata naggabwat sey Nazaret a lubbunna Galilea a inang sey Betlehem a lubbunna Judea, se antuweno lubbuni Ari David siꞌina gagginafuna. ");
INSERT INTO gdg_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Nebulungkappayi Maria a neturatuwa atawanna a umang mappalista. Gapapanakin sin inangnganda, ");
INSERT INTO gdg_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","e wasin agyaniran sinay, nadaꞌngennino tiyempona a manak. ");
INSERT INTO gdg_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","E neyanaꞌngeno parutara abbingnga a lalaki. Binaꞌbattanna si lampin, kasena nepaidda sino lutungnga aggayam, se awaninna pagyananda sino balaya paffunduwanda nad. ");
INSERT INTO gdg_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Sinoya gafi, agyanino tolayira sino pastowa mindag sino karnerorera. ");
INSERT INTO gdg_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kakaꞌmeng kelanga nappaddeno tata a angheli Afu Dios sikwara, e nawaldanira sino kilikiliꞌneno kinalawari Dios. E nakatalawirangke. ");
INSERT INTO gdg_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","“Ammekayu mattalaw,” kunnino anghel sikwara. “Se inangngak sitawa mipakaammu sikwayu sino nalawara damaga mappaanggam si ammina tolay. ");
INSERT INTO gdg_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Se sito gafi, neyanak sey lubbuni Ari David ino mangisalak sikwayu, a antuweno Kristo a Afutam. ");
INSERT INTO gdg_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Kunnayawino pangammuwandaw si gakkuruwino sinapikku. Sumpalandoneno kaluꞌbita nabaꞌbattan si lampina nepiddara si lutungnga aggayam.” ");
INSERT INTO gdg_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Wasinoy, nappaddeno odduwera a anghela naggabwat sey langit, e nedandayora i Dios a sapitanda si, ");
INSERT INTO gdg_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Madandayawi Dios sey langit, e nasiyanaꞌngeno nakammino tolayira sito lubagga mappaanggam sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wasin nuliyeno anghelira sey langit, natatarabbanino gumaindaggira si karnero si, “Umangngetam sey Betlehem ta itantamino nakwa sinaya nepakaammuwi Afu Dios sikwatam.” ");
INSERT INTO gdg_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wasinoy, nakkangkamira a inang, e sinumpalandara Maria anni Jose, e initareno kaluꞌbita nepaiddara sino lutungnga aggayam. ");
INSERT INTO gdg_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Wasin initareno kaluꞌbit, netuldureno sinapitino anghel sikwara mappeafu sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Nakkaꞌbaw amminino naningngaggira sino sinapitino gumaindaggira. ");
INSERT INTO gdg_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","E i Maria, neuluna ammin inaya nakwa, e aggadandammanna. ");
INSERT INTO gdg_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Wasinoy, nanawinnino gumaindaggira sey pasto. Nakakkantera a naddayaw ki Dios gafu sino initara anna diningngadda, se nakwa amminino sinapitino anghel sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Wasin walu awnanino kaluꞌbit, nepakugiꞌda e iningngananda si Jesus, se antuweno sinapitino anghel sikwara liyena a neluwaring. ");
INSERT INTO gdg_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","Wasin nadaꞌngeno awa panuntulanda nad sino netunino lintiyi Moises mappeafu sino bawuwa nanak, inanda Jose anni Maria sey Jerusalem ta umanda iwaꞌlat ki Diosino sinapit inaya lintiya adwaggiya funay onnu adwaggiya ubbunna kalapati. Neyangkalinda kappayino kaluꞌbit ta idutunda ki Afu Dios. Se ino kappay neturak sinaya lintiyi Afu Dios, kunna si, “Maawa medutung ki Afu Diosino ammina parutara abbinga lalaki.” ");
INSERT INTO gdg_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Agyanino tata lakay sey Jerusalem a mingngan si Simeon. Naggaddangnga tolay anna natalanggadda manuntul sino lintiyi Dios. Aggataronanneno Kristo a nekariyi Dios a mangisalak sino bafulunnera a gakagaka i Israel. Ana sikwaneno Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","E nepakaammuweno Espirituwi Dios sikwana si ammena matay kiyad si maitaneno Kristo a nekariyi Dios a gumamwang. ");
INSERT INTO gdg_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Sinoya aw, nefuyutino Espirituwi Dios i Simeon a umang sino Templo. Antu gafuna, wasin niyangnganino mapparanakira i Jesus sikwana sino Templo ta akwandeno netunino lintig mappeafu sikwana, agyaninni Simeon sinay. ");
INSERT INTO gdg_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Inappaneno kaluꞌbit e naddayaw ki Dios a nassapit si, ");
INSERT INTO gdg_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“Afu, massiki nu matayakuna aripannu, se nassiyanakkinnino nakangku. Se sitoya, neyakkuruwino nekarim sikwak, ");
INSERT INTO gdg_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","se initakunnino dinundunnuwa mangisalak sino tolayira, ");
INSERT INTO gdg_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ino nedadannuwa maammuwan ammina tolay. ");
INSERT INTO gdg_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Antuweno kunnangke sirwata mawwaldag sino nakammino bakkannira a Judyu ta maammuwandeno kesalakanda. E antu kappayino kadayawammiya gakagaka i Israel.” ");
INSERT INTO gdg_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nakkaꞌbawino mapparanakira i Jesus gafu sino sinapiti Simeon mappeafu sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","E binindisiyonanira i Simeon, kasena sinapit ki Maria si, “Iyawa abbingngu, dinotukani Dios, e gafu sikwana, odduna sikwatama gakagaka i Israel a mesalakan, udde oddu kappena sikwatama madaral gafu se ammera kuruwan. Se antuneno kunnangke senyala mangipaita si mesalakanino tolayira, udde odduneno makkontara sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Gafu sino akwanda sikwana, maammuwanino ana sino nakammino tolayira. E ikka a inana, malowingkeneno nakammu gafu sino akwanda sikwana a kunnangke nasuduk si nataramma saset.” ");
INSERT INTO gdg_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Agyangkappay sinayino gumalabbun a tata a bakatta mingngan si Ana a abbingi Fanuel a gaka i Aser. Pitu runa naddiꞌnera annino atawana, ");
INSERT INTO gdg_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","kasena nabalu, e kasamafulu e appata runnan. Kanayuna inang sino Templo, se aw anna gafi, naddayaw ki Dios a makkararag anna mallantanga mangngan. ");
INSERT INTO gdg_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Sinoya oratta aggedamadamikkepayi Simeon sikwara Jose, inaraꞌniyi Ana sikwara, e nappasalamat ki Dios sino initana. E nangiyafu sinoy, nassapit mappeafu sino kaluꞌbit sino amminira a tolaya aggatarongkappay sino kesalakanda a gakagaka i Israel. ");
INSERT INTO gdg_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Wasin inangwenda Jose anni Maria ino ammina sapitannino lintiyi Afu Dios, nuliyera sino lubbunda a Nazaret sino probinsiya a Galilea. ");
INSERT INTO gdg_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Dinokalli Jesus a natuyag e nappelalotino kinalaingnga, se dinuffunani Dios. ");
INSERT INTO gdg_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","42","Wasin karadwennino runi Jesus, nebulun sino mapparanaꞌngera a inang sey Jerusalem, se gagangera a kadda run, umangngira makifiyesta sino fiyestana Laꞌwutan. ");
INSERT INTO gdg_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Wasin nasinduwennino fiyesta, ginikkaꞌda Jose a muli sino lubbunda, udde nabattangi Jesus sey Jerusalem a ammera inammu, ");
INSERT INTO gdg_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","se aridda si nebulun sino korwanira a bafulundera. Tata si awdana nallakad, kasera naammuwan si awan, e nebebuꞌda sino wawwayirera andino inammurera. ");
INSERT INTO gdg_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Gafu se ammera sinumpalan, nuliyera sey Jerusalem takesi tufukanda sinay. ");
INSERT INTO gdg_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Wasin mekatallu awin, sinumpalanda i Jesus sino Templo a nakituttud sino mammesturuwerana lintiya maddingngag anna mabbababebut sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Nakkaꞌbawira ammina naningngag sikwana gafu sino kinalaingnga a manombat sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Nakkaꞌbokappayino mapparanaꞌngera a nita sikwana sinay, e sinapitino inana si, “Abbingku, mayan kunnenayino inangwam sikwami? Naddararangkamingke anni amama miintufuk sikwam.” ");
INSERT INTO gdg_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","“Mayan aꞌintufukandak? Ammeyu kad ammu si maawa agyanak sito balayi Amak?” netabbi Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Udde ammera naawatanino anggamma sapitan. ");
INSERT INTO gdg_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wasinoy, nebuluni Jesus sikwara a nuli sey Nazaret. Kinurungnga amminino panggammanda. E ino inana, aggadandammanna ammin inaya nakwa. ");
INSERT INTO gdg_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","I Jesus, dinokal e nadadaggananino kinalaingnga. Nan-aanggammi Dios sikwana, kunna kappay sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Wasin kadwafuluwen si lima a runino patturayani Emperador Tiberio, i Poncio Pilatoweno gubernador sey Judea. I Herodesino matturay sey Galilea, e ino kolaꞌnga a i Felipe ino matturay sey Iturea anna sey Traconite. I Lisaniasino matturay sey Abilene. ");
INSERT INTO gdg_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Ino afafuwerana padi sinoya tiyempo, da Anas anni Caifas. Sinoy kappaya tiyempo, agyanino sinapiti Dios ki Juan a abbingi Zacarias sin nagyananna sino kalolowat, ");
INSERT INTO gdg_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","e neyafunana nanuldu. Inang sino tolayira sino nassalidadammanga wawwanga Jordan, e sinapiꞌna sikwara si, “Iboboliyu naddino liwaꞌdawira e mappabawtisarkayu takesi pakomani Diosino liwaꞌdaw.” ");
INSERT INTO gdg_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Inaya inangwa i Juan, antuweno neyakkuruwanino neturakki Isaias a gumalabbun siꞌina kunna si, “Ananeno mikulakulawu sey kalolowata massapit si, ‘Idadandawino lakarannino Afuyuwa gumamwang takesi nalawanneno dalana pallakaranna. ");
INSERT INTO gdg_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ino nad akwandaw, tabbunandaw ammina alungung anna passimpandaw ammina kulud anna mukag. Nu wara nalliku, paggaddangngandaw anna pallawarandawino narakkat sino dalan ");
INSERT INTO gdg_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","takesi ammina tolay, itandeno dundunanni Dios a mangisalak sikwara.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Odduweno tolayira a inang ki Juan a mappabawtisar. Sinapiꞌna sikwara si, “Mayan umangkayuwa massalasangkun sitaw? Inyeno nassapit sikwayu si meliꞌwakayu sino kastiguwi Dios nu mabawtisarangkayu? ");
INSERT INTO gdg_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ammena dama, nu ammeyu abbu ipaita sino aggangwayu si gakkuruwa neboboliyuweno liwaꞌdaw. Ammeyu kappay sapitan si meliꞌwakayu sino kastiguna se i Abrahamino gagginafuyu, se massiki iyawira a batu, dama i Dios a pabbalin si gakagaka i Abraham. ");
INSERT INTO gdg_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Inona kastiguwi Dios sikwayu, meyamparig si wataya nedadana paggabba si kayu, e kadda kayuwa ammena mammunga si nalawad, mefungalla magabba e masikkulan.” ");
INSERT INTO gdg_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Antuweno nabbebutino tolayira ki Juan a nassapit si, “Sanna antuweno akwammi?” ");
INSERT INTO gdg_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","E sinabbangnga si, “Kunnayawino nalawara akwandaw. Nu wara adwa si barawasiyu, iyaꞌdayu naddino tata sino awana akwana. Kunna kappay nu wara akkanandaw, aꞌdandonaddino awana akkananna.” ");
INSERT INTO gdg_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Agyangkappayino gumattukiyera si buwita inang mappabawtisar, e sinapiꞌda si, “Afu mesturu, sanna payino nalawara akwammi?” ");
INSERT INTO gdg_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","“Ammekayu mattuki si sobra sino fustuwa paganino tolayira,” netabbangnga sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Agyangkappayino sindaluwera a nabbebut sikwana si, “Ikkami mappaye, sanneno nalawara akwammi?” Sinapiti Juan sikwara si, “Ammeyu tantalawannino massiki sanna a tolay onnu massisiriya midarum sikwara ta appandawino piraꞌda, nu ammekayu lud maanggam sino swelduyu.” ");
INSERT INTO gdg_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Gafu sino netulduwi Juan, minnanamengkeinnino tolayira si malana gumamwangino Mesias, e kunda sino nakanakanda si, “Antuwen nakuyino Kristo a aggataronantam.” ");
INSERT INTO gdg_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Udde kunni Juan sikwara si, “Aneno napatig amma sikwaka mepatali. Massiki ino muttad sino gakanneno sapatuꞌna, ammek meannunga mangwa gafu sino kinapatingnga. Bawtisarantakayu pelang si danum, udde bawtisarannakayuna sino Espirituwi Dios anna si afuy. ");
INSERT INTO gdg_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Antuneno mangukum sino tolayira. Meyamparig si tolaya aneno miyawa pittaꞌma sino apaya naaggik. E ino nabbaggat, iyalangnga, udde ino pittapanna, itakkumma sino afuya ammena maaddap.” ");
INSERT INTO gdg_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Kunnenayino sinapiti Juan sino tolayira, e oddu kappaya netulduna sikwara sino nibanyanna sino nalawara damag sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Nebuyana kappayi Gubernador Herodes gafu sino namulattanna ki Herodias a ataweno kolaꞌnga andino korwana narakkatta inangangwana. ");
INSERT INTO gdg_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Antuweno nadaꞌngeno tiyempowa nepabaluri Herodesi Juan, e nadaggananinnino liwaꞌna. ");
INSERT INTO gdg_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Sin ammena kepay nabaluri Juan, odduweno tolaya binawtisaranna, e nappabawtisar kappayi Jesus. Wasin makkararaggepay sinay, kakaꞌmeng kelanga nabukkatanino langit, ");
INSERT INTO gdg_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","e naddassino Espirituwi Dios sikwana a kunnangke kalapati. E agyanino naddamit sey langita nassapit si, “Ikkeno Abbingkuwa iiddukangku, e maanggammakungke gafu sikwam.” ");
INSERT INTO gdg_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Wasin nangiyafuwani Jesus a manuldu, mattallufuluwennino runna. E nebilangino tolayira si antuweno abbingi Jose. I Jose ino abbingi Eli a ");
INSERT INTO gdg_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","abbingi Matat. I Matatino abbingi Levi a abbimpayi Melki. I Melkiyeno abbingi Jane a abbimpayi Jose. ");
INSERT INTO gdg_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","I Jose ino abbingi Matatias a abbimpayi Amos. I Amosino abbingi Nahum a abbingi Esli a abbimpayi Nage. ");
INSERT INTO gdg_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","I Nage ino abbingi Maat a abbingi Matatias a abbingi Semei a abbingi Jose a abbimpayi Juda. ");
INSERT INTO gdg_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","I Judeno abbingi Joana a abbingi Resa a abbingi Zorobabel a abbingi Sealtiel a abbimpayi Neri. ");
INSERT INTO gdg_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","I Neriyeno abbingi Melki a abbingi Adi a abbingi Cosam a abbingi Elmodam a abbimpayi Er. ");
INSERT INTO gdg_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","I Erino abbingi Josue a abbingi Eliezer a abbingi Jorim a abbingi Matat a abbimpayi Levi. ");
INSERT INTO gdg_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","I Leviyeno abbingi Simeon a abbingi Judas a abbingi Jose a abbingi Jonan a abbimpayi Eliakim. ");
INSERT INTO gdg_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","I Eliakimino abbingi Melea a abbingi Mena a abbingi Matata a abbingi Natan a abbimpayi David. ");
INSERT INTO gdg_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","I David ino abbingi Jesse a abbingi Obed a abbingi Boaz a abbingi Salmon a abbimpayi Naason. ");
INSERT INTO gdg_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","I Naasonino abbingi Aminadab a abbingi Aram a abbingi Arni a abbingi Esron a abbingi Fares a abbimpayi Juda. ");
INSERT INTO gdg_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","I Judeno abbingi Jacob a abbingi Isaac a abbingi Abraham a abbingi Tare a abbimpayi Nacor. ");
INSERT INTO gdg_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","I Nacorino abbingi Serug a abbingi Ragau a abbingi Peleg a abbingi Heber a abbimpayi Selah. ");
INSERT INTO gdg_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","I Selahino abbingi Cainan a abbingi Arfaxad a abbingi Sem a abbingi Noe a abbimpayi Lamec. ");
INSERT INTO gdg_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","I Lamecino abbingi Matusalem a abbingi Enoc a abbingi Jared a abbingi Mahalaleel a abbimpayi Cainan. ");
INSERT INTO gdg_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","E i Cainanino abbingi Enos a abbingi Set a abbingi Adam a abbimpayi Dios. ");
INSERT INTO gdg_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Wasin inanawi Jesus sino wawwanga Jordan, aneno Espirituwi Dios sikwana e antuweno nifuyut sikwana a inang sino kalolowat. ");
INSERT INTO gdg_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Nagyan sinay si appatafuluwa aw anna gafi e dinalodawi Ofagga sinutunggungan. Awaningke nangapangngan sikwana sinoya tiyempo, antuweno nabisiningke. ");
INSERT INTO gdg_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wasinoy, sinapit i Ofag sikwana si, “Nu gakkuruwa ikkeno Abbingi Dios, sapitannu sitawa batu ta mabbali si maakkan.” ");
INSERT INTO gdg_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Udde sinombati Jesus si, “Ino neturakka sapiti Dios, kunna si, ‘Bakkampelanga maakkanino ikabiyangnga tolay.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Waso kunnenoy, nefuyuti Ofaggi Jesus si ataꞌnanga kulud, e si takimmatan, nepaita sikwaneno ammina patturayan sito lubag. ");
INSERT INTO gdg_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","E sinapiti Ofag si, “Iyaꞌdak sikwamino kalintiyana matturay sino ammin inay takesi akwamino kinabaꞌnanda, se neyaꞌda ammin sikwak, e damaka iyaꞌda kappay sino massiki sanna a anggangkuwa pangaꞌdan. ");
INSERT INTO gdg_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Maddayoka mantu sikwak ta akwam ammin.” ");
INSERT INTO gdg_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Udde sinombati Jesus si, “Kunnino neturakka sapiti Dios si, ‘Dayawandonaddi Dios a Afuyu, e antu nabbelangino passerbiyandaw.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Wasinoy, nefuyuti Ofaggi Jesus sey Jerusalem, e nepataꞌdangnga sino kataꞌnangana partineno Templo, e sinapiꞌna si, “Nu gakkuruwa ikkeno Abbingi Dios, mallattuka taw, ");
INSERT INTO gdg_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","se ino neturakka sapiti Dios, kunna si, ‘Tunanni Diosino anghelnera ta imutandaka. ");
INSERT INTO gdg_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Tampayandaka takesi ammeka makalowan, massiki ino takkim, ammena mabiyaran si batu.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Udde sinombati Jesus si, “On, udde kungkappayino neturakka sapiti Dios si, ‘Ammemmad dalodawanni Dios a Afum.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Wasin inangwen ammini Ofaggino damana a panutunggung ki Jesus, inanawanna ta mattaron si korwana tiyempona. ");
INSERT INTO gdg_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Waso kunnenoy, nuliyi Jesus sey Galilea a ana sikwaneno pannakadameno Espirituwi Dios. Naddinnamino mappeafu sikwana sino ammina lulubbun sinay. ");
INSERT INTO gdg_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Nanuldu sino sinagogarera, e naddayaw ammina tolay sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Wasinoy, inang sey Nazaret a antuweno lubbuna naddokallanna. Wasin nadaꞌngeno awna aggimwangana Sabadu, inang sino sinagoga, se antuweno gagangena. E nattaꞌdagga mibasa sino sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Neyaꞌdara sikwaneno nalukuta neturakkanino nepeturakki Isaias a gumalabbun siꞌin. Binoꞌliyanna e sinumpalanna yawa neturakka kunna si, ");
INSERT INTO gdg_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Ana sikwakino Espirituwi Dios, se piniliraka umang manuldu sino nalawara damag sino mekakallakkira. Dinundundaka mangipakaammu sino balurira si mallawanirana, ino lappattira, makaiterana, andino madyatanira, maduffunanirana, ");
INSERT INTO gdg_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","takesi mepakaammu si ammina tolaya nadaꞌngennino tiyempowa pipaitani Dios sino allaꞌnga sikwara.” ");
INSERT INTO gdg_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Wasin nasinduwi Jesus a nibasa sinay, ilukuꞌna kappayino turak, neyulina sino nangaꞌda sikwana, kasena nattuttura nanuldu, e aggitan amminino tolayira sinay. ");
INSERT INTO gdg_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Sinapiꞌna sikwara si, “Inaya neturakka sapiti Dios a nebasak, meyakkuruwin sito ingkeina aggadingngaggayu kepay sito sapitangku.” ");
INSERT INTO gdg_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Dinayaw amminino tolayira e nakkaꞌbawira sino kinalawanneno sinapiꞌna. E kunda si, “Bakkangkad yanino abbingi Jose?” ");
INSERT INTO gdg_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wasinoy, sinapiti Jesus sikwara si, “Ammuk si sapitandaw sikwak yawa palanut, ‘Doktor, agasannu abbuweno baggimungkepay,’ a ino anggandawa sapitan, akwangku nad sito lubbuntamino kakkaꞌbawa diningngaddawa inangwak sey Capernaum.” ");
INSERT INTO gdg_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","E netuluy kappayi Jesus a sinapit si, “Gakkurug yo sapitangku sikwayu, awana gumalabbun si medayaw sino lubbunnangkepay. ");
INSERT INTO gdg_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Dandammandonaddino nakwa sin tiyempowi Elias. Awaningke uran sito Israel si kappata run si gadwa, e dokallino bisin si palulubbun. Odduweno kakallakkira a balu sito lubbuntam sinoya tiyempo, ");
INSERT INTO gdg_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","udde bakkanna ireno nanundunani Dios ki Elias a duffunan, nu ammena lud dinunduna nanuffun sino tata a baluwa taga-Serepta sino sakopanna Sidon a bakkanna kalubbunantam. ");
INSERT INTO gdg_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Kunna kappayino nakwa sin tiyempoweno gumalabbuna i Eliseo. Odduweno tolayira sito Israel a nakkutal, udde awana nepabbattunoyna sikwara. I Naaman pelanga taga-Siria ino nepabbattunoyna.” ");
INSERT INTO gdg_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Nappelalotino bungutino ammina tolayira sino sinagoga sin naningngagganda sinay. ");
INSERT INTO gdg_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Nattaꞌdaggira ammin, ginafuꞌda i Jesus, e nelawanda sino lubbun. Neyanda sino munsuꞌngeno kulura agyananino lubbunda se angganda a ituꞌyud sino dabbak. ");
INSERT INTO gdg_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Udde nallakari Jesus sino nallalatanda e inanaw. ");
INSERT INTO gdg_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Wasinoy, inangngi Jesus sey Capernaum a tata a lubbun sey Galilea. Inang nanuldu sino tolayira sino sinagoga sino awna aggimwangan. ");
INSERT INTO gdg_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","E nakkaꞌbawira sino annulduna, se melasin sino sapitanna si aneno kalintiyanna a manuldu. ");
INSERT INTO gdg_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Agyanino lalaki sinaya naunaggan si narakkatta espiritu, e nakkulawuwa nassapit si, ");
INSERT INTO gdg_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Sanna maꞌlurino gakkannu sikwami, Jesus a taga-Nazaret? Ginamwangka kadda manaral sikwami? Ammutakan. Ikkeno Abbingi Dios a awana liwaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Udde “Suminakkan!” kunni Jesus sino narakkatta espiritu. “Anawannun yana tolay!” E iletwarino narakkatta espirituweno lalaki sino naraꞌlanganino tolayira, kasena inanawana ammena inansa. ");
INSERT INTO gdg_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Nakkaꞌbawira ammin, e nattatarabbira a nassapit si, “Sanna lang mannakadameno sapiꞌna? Se massiki ino narakkattira a espiritu, aneno turena anna pannakadamana a massapit si umanawira, e manawiran.” ");
INSERT INTO gdg_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Gafu sinoy, naddinnamino mappeafu ki Jesus si ammina palulubbun sinay. ");
INSERT INTO gdg_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Wasinoy, inanawi Jesus sino sinagoga e inang sino balera Simon. Wasin ginamwang sinay, nappelalotino babannangngeno katuwangani Simon a bafay, e sinapiꞌda sikwana ta duffunanna. ");
INSERT INTO gdg_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Inaraꞌniyi Jesus sino iddana e sinapiꞌna si maari naddino babannangnga. E naariyen gakkurug, e ginabwatino bafay e pinakkannera. ");
INSERT INTO gdg_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Wasin sumallappinnino sinag, neyangngino tolayira ki Jesusino ammina matakit si massiki sanna a takit. Inappanganneno kadda tata, e nabbattunoyira. ");
INSERT INTO gdg_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Nepaanona kappayino narakkattira a espiritu sino odduwera a tolaya nunagganda. E sin umanawanda, nakkulawuwera a nassapit si, “Ikkeno Abbingi Dios.” Udde inallangngannera ta suminakkira, se ammura si antuweno Kristo a dinunduni Dios. ");
INSERT INTO gdg_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Wasi marrifarifad si kadaramaꞌna, inanawi Jesus sinaya lubbun e inang sino awana matotolena. Antuweno inang inintufukino tolayira, e wasin sinumpalanda, inaranda si ammena nad umanaw sino lubbunda. ");
INSERT INTO gdg_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Udde sinapiꞌna si, “Maawag si itulduk sino korwangkappaya lubbunino nalawara damag mappeafu sino patturayani Dios, se antuweno gafuna a dinundundak.” ");
INSERT INTO gdg_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Antuweno nannodoyuwa inang sino lulubbunna Judea a nanuldu sino sinagogarera. ");
INSERT INTO gdg_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Wasin tata si aw, aggataꞌdaggi Jesus sino dappiꞌna bebaya Genesaret a manuldu sino sapiti Dios, e inaribumbunganino odduwera a tolay se angganda a dingngaggan. ");
INSERT INTO gdg_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Inita i Jesusino adwa a abang sino dappiꞌna bebaya inanawanino gumattafukulira a inang nunab sino tafukulda. ");
INSERT INTO gdg_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","E nattakay sino tata a abanga akwa i Simon, e inarangnga ki Simon ta paroyunna si bissang sino dappit. E nattuttura nanuldu sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Wasin nasinduwa nanuldu, sinapiꞌna ki Simon si, “Palitannuweno abangngu sino agyananino ataꞌnanga danum ta itakkuddawino tafukuldaw.” ");
INSERT INTO gdg_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","“On, Afu,” kunni Pedro, “udde nappaawkamiya nanafukul, e awaningke a naappami. Udde nu antuweno sapitannu, itakkummi kappayino tafukulmi.” ");
INSERT INTO gdg_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Antuweno netakkudda kappayino tafukulda, e wasin nelabbedda, odduweno inappara kiyad si gapapissayino tafukulda. ");
INSERT INTO gdg_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","E kinulafattandeno bafulundera sino tata a abang ta umandera duffunan. Inangngira e pinannureno adwera a abang si lamis kiyad si galalannaddira. ");
INSERT INTO gdg_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Wasin inita i Simon Pedro inaya nakwa, namalitud sino aꞌlangi Jesus e sinapiꞌna si, “Afu, anawandak, se minalliwataka tolay.” ");
INSERT INTO gdg_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Kunnenayino sinapiti Pedro, se nakkaꞌbawira andino bafulunnera sino kaodduweno sinafukulda. ");
INSERT INTO gdg_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Nakkaꞌbokappayino bafulundera sino tata a abang a da Santiago anni Juan a abbingi Zebedeo. Wasinoy, sinapiti Jesus ki Simon si, “Ammeka mattalaw, se mangiyafu sito ingkein, ammekan manafukul si lamis, nu ammeka lud mangawis si tolay ta manguruwira sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Antuweno wasin neyaꞌdandeno abanda, inanawanda ammin e nebulunira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Wasin tata si aw, agyani Jesus sino tata a lubbuna agyananino tata a lalakiya nakkutal amminino baggina. Wasin initana i Jesus, inang namalitud sino aꞌlangnga a nakiggimallakka nassapit si, “Afu, nu anggammu, damaraka pabbattunoyan.” ");
INSERT INTO gdg_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Inappangani Jesusino nakkutal, kasena sinapit si, “On, anggangku si mabbattunoykan. Maariyen yan kutalnu.” E kakaꞌmeng kelanga naariyeno kutalna. ");
INSERT INTO gdg_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Wasinoy, netuni Jesus sikwana si, “Ammem sapitan yaw si massiki sanna a tolay, nu ammem lud umang mappaita sino padi ta itanna nu naariyennino kutalnu. Kasem iyaꞌda sikwaneno netuni Moises siꞌina mewaꞌlat ki Dios takesi wara pangammuwanino tolayira si gakkuruwa nabbattunoykan.” ");
INSERT INTO gdg_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Udde massiki antuweno netunna, kumaral lullanga naddinnamino mappeafu ki Jesus. Antu gafuna, odduwengke ino tolayira a inang sikwana a maningngag sino tulduna anna mappaari sino takiꞌda. ");
INSERT INTO gdg_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Udde kanayuna inangngi Jesus sino kalolowat ta mittata a makkararag. ");
INSERT INTO gdg_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Wasin tata si awa nanulduwi Jesus sino tata a balay, agyanino Fariseowera andino mammesturuwerana lintiya nakituttud sikwana. Naggabwatira sino palulubbunna Galilea anna Judea, mampay sey Jerusalem. Ana ki Jesusino pannakadama i Dios a mappabattunoy sino matakitira. ");
INSERT INTO gdg_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Wasinoy, agyanino ginamwangira a nabbolig si tolaya paralitiku. Kinakkapanda a itallung sino balay ta iyanda sino agyanani Jesus, ");
INSERT INTO gdg_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","udde ammena dama gafu sino kaodduweno tolayira. Antu gafuna, neuneꞌda sino ataꞌmeno balay, inabbutandeno batuwi Jesus, kasera nepatabbafeno bolig sino aꞌlangi Jesus sino tangngeno tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Wasin inita i Jesusino annalaꞌda sikwana, sinapiꞌna sino lalaki si, “Napakomaninnino liwaꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Wasin diningngaggino Fariseowera andino mammesturuwerana lintig inay, kunda sino nakanakanda si, “Sanneno katolena a ikunnaneno baggina ki Dios? Se bakkangkabbelangi Diosino makapakoma si liwat?” ");
INSERT INTO gdg_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Udde ammuwi Jesusino ana sino nakanda, e sinapiꞌna si, “Ma, ansanna lang kunnayanino dinandandaw? ");
INSERT INTO gdg_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Naladda maꞌlura massapit si ‘Napakomanino liwaꞌnu’ amma sino ‘Gumabwakka ta umanokan.’ ");
INSERT INTO gdg_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Udde nu kunnenoy, sapitangku mantuweno madyat takesi ipaitak sikwayu si ikkanakino Abbingnga Tolaya aneno kalintiyan sito lubagga mamakoma si liwat.” E sinapiꞌna sinoya paralitiku si, “Ino sapitangku sikwam, gumabwakka, appannu yan iddam, e umanokan.” ");
INSERT INTO gdg_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","E kakaꞌmeng kelanga ginabwatino tolay sino naraꞌlanganda ammin, inappaneno iddana, e inanawa maddandayaw ki Dios. ");
INSERT INTO gdg_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","E amminira a nagyan sinay, nakkaꞌbawirangke anna nakatalaw, e naddayawira ki Dios a nassapit si, “Kakkaꞌbawingkeno naitatam sito aw!” ");
INSERT INTO gdg_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Wasin nasinduwenay, nallawani Jesus e initaneno gumattuki si buwita mingngan si Levi a aggatuttud sino ofisinana. “Mebulungka sikwak,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","E ginabwati Levi, inanawanna ammin, e nebulun ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wasinoy, inangngira sino balera Levi, e odduweno nedadanna a akkananna pappagamwangnga ki Jesus. Odduwera kappayino ginamwanga gumattukiyera si buwit andino korwanira a tolay, e nakikkanira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Wasinoy, ino korwanira a Fariseo andino bafulundera a mammesturuwerana lintig, binaloreno initara. E sinapiꞌda sino adalanira i Jesus si, “Mayan makikkan anna makiinungkayu sino gumattukiyera si buwit andino korwanira a minalliwata tolay?” ");
INSERT INTO gdg_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Udde i Jesusino nanombat sikwara, e sinapiꞌna si, “Inyeno mawag si doktor, nu bakkampelangino matakit? ");
INSERT INTO gdg_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ammek inang sitawa mayag sino naggaddangngira a tolay, nu ammena lurino minalliwatira takesi mabboboliyera.” ");
INSERT INTO gdg_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Agyanino korwanira a tolaya nassapit ki Jesus si, “Ino adalanira i Juan, dayandanira a mallantanga mangngan anna makkararag, e kunna kappay sino adalanireno Fariseowera. Udde ino adalannuwera, ammera akwan, nu ammera lud mangngan anna minum.” ");
INSERT INTO gdg_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Sinabbira i Jesus a niyamparig si, “Nu wara makkasar, kundokad si amme makikkanino bafulunino mangatawa a inayanna? ");
INSERT INTO gdg_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Udde dumaꞌnganeno tiyempowa meanaw sikwareno mangatawa, kaserana mallantanga mangngan.” ");
INSERT INTO gdg_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Sinapikkappayi Jesus a niyamparig si, “Awana tolaya mappissay si bawuwa barawasi takesi iyappiꞌna sino dadan. Se nu antuweno akwanna, darallanneno bawu, e ammena meannungino bawuwa sinnun sino keappitanna. ");
INSERT INTO gdg_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Awangkappaya miyekwa si talifawu sino dadana sinan anganga gaddang, se battakanna, mesayukino tayug, anna madaral kappayino gaddang. ");
INSERT INTO gdg_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ino bawuwa tayug, bawu kappenadda gaddangino keyekwanna. ");
INSERT INTO gdg_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Ino tata kappay, ino nawama minum sino dadana tayug, ammena anggamma sinsimanino bawu, se kunna si nalawarino dadana nawamanna.” ");
INSERT INTO gdg_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Wasin tata a Sabadu a aggimwanganino Judyuwera, malallakadda Jesus sino aggumana namulan si trigo. E ino adalannera, nangappera sino dawana trigo, irurunda, kasera binulak e nakkanda. ");
INSERT INTO gdg_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Udde nagyanino korwanira a Fariseo a nassapit sikwara si, “Mayan kontarandawino lintiddama kammarallino maggani sino awna aggimwangan?” ");
INSERT INTO gdg_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Sinabbira i Jesus si, “Ammeyu kad binaseno inangwa i Ari David andino bafulunnera sin nabisinanira? ");
INSERT INTO gdg_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Sinallungi David sino balayi Dios, nangngan sino tinapaya newaꞌlat ki Dios a kunnino lintiya kammaralla akkanannino bakkanna padi, e naꞌdanna kappayino bafulunnera.” ");
INSERT INTO gdg_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","E inabambutani Jesus a nassapit si, “Ikkanaka Abbingnga Tolayino ana kalintiyanna a massapit sino damana a maangwa sino awna aggimwangan.” ");
INSERT INTO gdg_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Wasin tata kappaya awna aggimwangan, inangngi Jesus sino tata a sinagoga ta manuldu. Agyan sinayino lalakiya pilayino diwanana kamaꞌna. ");
INSERT INTO gdg_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Agyangkappayino korwanira a mammesturuwerana lintig anda Fariseowera a mallakkap ki Jesus nu pabbattunoyanneno lalaki sino awna aggimwangan, se mintufukira si ipaliwaꞌda sikwana ta wara pidarumanda. ");
INSERT INTO gdg_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Udde ammuwi Jesusino ana sino nakanda, e sinapiꞌna sino lalakiya pilayino kamaꞌna si, “Gumabwakka ta umangka sito naraꞌlangammi.” E ginabwat e inang sino aꞌlanda. ");
INSERT INTO gdg_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Wasinoy, sinapiti Jesus sikwara si, “Bebutangku sikwayu nu sanneno anggammino lintiddama akwantam sino awna aggimwangan. Mangwetam si nalawad onnu narakkat? Misalak si tolay onnu mamapatay?” ");
INSERT INTO gdg_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Ilangalanganera ammin, kasena sinapit sino lalakiya pilay si, “Soꞌyarannu yan kamaꞌnu.” Sinoꞌyanna, e napiyen. ");
INSERT INTO gdg_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Udde nabbungubungutingke ino mallakkappira, e nattatarabbanda nu sanneno akwanda ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Sinoya tiyempo, nanuꞌduwi Jesus sino tata kulud, e nappafafiya nakkararag ki Dios. ");
INSERT INTO gdg_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wasin kagigiꞌbaꞌnenoy, inayanneno adalannera, e namili si karadwa sikwara a ngananna si apostolna, se dundunannera a umang manuldu. ");
INSERT INTO gdg_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Irayawino nganganino pinilinera: i Simon (a nginanna si Pedro) anni Andres a kolaꞌnga, da Santiago anni Juan, da Felipe anni Bartolome, ");
INSERT INTO gdg_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","da Mateo anni Tomas, i Santiago a abbingi Alfeo, i Simon (a ngananda si Patriota se ikaloneno lubbunna), ");
INSERT INTO gdg_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","i Judas a abbingi Santiago, anni Judas Iscariote a antuneno mallaku ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Wasin naddawuꞌda Jesus andino apostolnera, nitturira sino nakkanafana nakkakarampattanino odduwera a adalanna andino odduwera kappaya tolaya naggabwat sey Judea anna sey Jerusalem anda sino lulubbuna Tiro anna Sidon a araꞌni sino bebay. ");
INSERT INTO gdg_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Inangngira sinay se angganda a dingngaggannino sapitanni Jesus, e ino matakitira, angganda si pabbattunoyannera. Inangkappayino naunagganira si narakkatta espiritu, e nepaanoneno inunag sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Amminino nagyanira sinay, anggandangkenadda appangan, se aneno pannakadama sikwana a mappabattunoy si takit. E nepabbattunoynera ammin. ");
INSERT INTO gdg_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wasinoy, ilangngiyi Jesusino adalannera, e sinapiꞌna sikwara si, “Nagasakkayuwa pobiri, se mesapakkayuna sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","“Nagasakkayuwa mabisin sito ingkein, se mabattuggayuna. “Nagasakkayuwa mattangit sito ingkein, se makkatawakayuna. ");
INSERT INTO gdg_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","“Nagasakkayu nu kababannaddakayu anna ammerakayu anggam anna iyatataldakayu anna massapitira si narakkat mappeafu sikwayu gafu sino angnguruddaw sikwaka Abbingnga Tolay. ");
INSERT INTO gdg_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Nu kunnenayino akwanda sikwayu, maanggangkayungke nad e ilalattuyuweno aanggandaw, se dokallingke ino labuꞌdaw sey langit. Se ino akwanda sikwayu, kakunnaneno inangweno gagginafurera sino gumalabbunira i Dios siꞌin. ");
INSERT INTO gdg_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Udde kakallakkayuwa baꞌnang, se inappayunnino mappaanggam sikwayu e awaninna innanamandaw. ");
INSERT INTO gdg_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“Kakallakkayuwa mabattug sito ingkein, se mabisinangkayuna. “Kakallakkayuwa makkatawa sito ingkein, se maloneno nakandaw e mattangikkayuna. ");
INSERT INTO gdg_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“Kakallakkayu nu dayawandakayu ammina tolay gafu se akwandopelangino panggammanda, se kakunnana kappayino nepaddayawino gagginafurera sino massisiriyera a gumalabbun siꞌin.” ");
INSERT INTO gdg_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Netuluyi Jesus a nassapit si, “Ino sapitangku sikwayuwa maningngag sikwak, anggammandonaddino kakkalingayuwera. Nalawannaggappayino akwandaw sino makkababannag sikwayu. ");
INSERT INTO gdg_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Ino magged sikwayu, arangngandonad ki Dios si bindisiyonannera, e ikararandokappayino mappadyatira sikwayu. ");
INSERT INTO gdg_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Nu wara manipang sino tata a paringilnu, passipangngu kappayino tafik, e nu wara mappa sino kadwattaꞌmeno barawasim, iyaꞌdangkappayino tata. ");
INSERT INTO gdg_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Aꞌdannu naddino massiki inya a marang sikwam, e nu wara mappa sino kukwayu, ammeyu sapitan si iyulina. ");
INSERT INTO gdg_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Akwandonad sino kasittoleyuweno anggandawa akwanda sikwayu. ");
INSERT INTO gdg_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Nu ino pelang manggam sikwayuweno anggammandaw, wara kad labuꞌdona ki Dios? Se massiki ino minalliwatira, anggammanda payino manggam sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","E nu ino pelang mangwa si nalawad sikwayu ino pangwandaw si nalawad, wara kad labuꞌdona sinay? Se massiki ino minalliwatira, kunna kappay inayino akwanda. ");
INSERT INTO gdg_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","E nu ino pelang ammuyuwa miyuli sino takkawandeno patakkawandaw, wara kad labuꞌdona? Se massiki ino minalliwatira, patakkawandeno bafulundera se innanamanda a meyuliyeno nepatakkora. ");
INSERT INTO gdg_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Ammena nad kunninoyino akwandaw, nu ammeyu lud anggammannino kakkalingayuwera, e mangwakayu si nalawad sikwara. Mappatakkokayu sikwara massiki ammeyu innanaman si iyulira. Se nu kunnenayino akwandaw, dokallino labuꞌdaw ki Dios, e mebilangkayu si abbingi Dios a Kapatiyan. Se i Dios, naallak sino narakkattira a tolay andino ammera mappasalamat sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","“Maawag si minangkallakkayu a kakunna i Dios a Amayuwa minangkallak. ");
INSERT INTO gdg_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Antuweno ammeyu nad ukumannino bafulundawira ta sapitandaw si makastiguwera nad takesi ammerakayu pay ukumanni Dios a makastigu, nu ammeyu lud pakomanino bafulundawira ta pakomandakayu payi Dios. ");
INSERT INTO gdg_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Naallakkayuwa mangaꞌda sino bafulundawira e naallappena i Dios a mangaꞌda sikwayu a ino angngaꞌdana, kunnangke natattad, nakuyukuyun, e mesawal. Se ino kaodduweno iyaꞌdayu, antu kappeneno kaodduweno iyaꞌdana sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Niyampariyi Jesus sikwara a nassapit si, “Dama kadda ifuyutino lappattino bulunna a lappat? Nu kunnenoyino akwanda, madaꞌnira a adwa sino dabbak. ");
INSERT INTO gdg_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Awangkappaya madala napatig amma sino mesturuna, udde nu nabalinnanino adalna, mekunnen sino mesturuna. ");
INSERT INTO gdg_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Mayan aggitannuweno bibissangnga ana sino mateno bulunnu, a ammem magiꞌneno dokalla ana sino matam? ");
INSERT INTO gdg_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Ansannu massapit sino bulunnu si, ‘Ariyangkuweno ana sino matam,’ a ammem maiteno ana sitan matam? Ikka a massasannakam, ariyannubbuweno ana sino matam takesi nalawarino angngitam, kasem dama a ariyanino ana sino mateno bulunnu.” ");
INSERT INTO gdg_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Sinapikkappayi Jesus si, “Ino nalawara kayu, ammena mammunga si narakkat, e ammena kappay mammungeno narakkatta kayu si nalawad. ");
INSERT INTO gdg_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Ino kaimunuwanna kayu ino bungana, se ino uway, ammena mammunga si igos, e ino anifung, ammena mammunga si ubas. ");
INSERT INTO gdg_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Kunna kappay sikwatama tolay. Ino nalawara tolay, nalawarino sapitanna se nalawarino ana sino nakamma. Udde ino narakkatta tolay, narakkattino sapitanna se narakkattino ana sino nakamma. Se ino sapitanna tolay, maggabwappelang sino ana sino nakamma.” ");
INSERT INTO gdg_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Netuluyi Jesus a nassapit si, “Mayan kundaw si ikkanakino Afuyu, gampade ammeyu kuruwannino sapitangku? ");
INSERT INTO gdg_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Ino umang sikwaka maningngag sino sapitangku e kuruwanna, kunnayawino piyampariyangku. ");
INSERT INTO gdg_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Mekunna si tolaya namataꞌdag si balay, a nakkokkob sino lubag kiyad si dinaꞌnganeno batu e antuweno namataꞌdagganna. Wasin nalum, kinaꞌnaneno balay, udde ammena naansa, se nalawarino akkepataꞌdangnga. ");
INSERT INTO gdg_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Udde ino tolaya naningngag sino sapikku e ammena kuruwan, mekunna si tolaya namataꞌdag si balay sino pelang utunna lubagga awana fundasiyonna a mappatuyag sinay. Antuweno wasin nalum, naladda pelanga nagabba, e nadarallingke.” ");
INSERT INTO gdg_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Wasin nasinduwi Jesus a netuldu ammin inay sino tolayira, inang sey Capernaum. ");
INSERT INTO gdg_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Agyan sinayino kapitanna sindaluwa taga-Roma a aneno aripanna a ikalona. Inaya aripan, matakit e gapapatayin. ");
INSERT INTO gdg_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Wasin diningngaggino kapitan si ana i Jesus, dinundunneno korwanira a pangafuwanna Judyu ta umanda ayani Jesus a mappabattunoy sino aripanna. ");
INSERT INTO gdg_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Inangngira ki Jesus e nakiggimallakkira a nassapit si, “Inaya kapitan, meannunga duffunannu, ");
INSERT INTO gdg_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","se anggammandetama Judyu e nappepataꞌdag si sinagogatam.” ");
INSERT INTO gdg_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wasinoy, nebuluni Jesus sikwara. Wasin araꞌniyeran sino balayino kapitan, dinundunino kapitanino korwanira a bafulunna a umang manambal ki Jesus ta sapitanda si, “Afu, ammekampelang maddutung, se ammena meannunga sumallungka sino balek. ");
INSERT INTO gdg_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","E kunna kappay sikwak, ammek meannunga umaraꞌni sikwam. Antuweno sapitannumpelang, e mabbattunoyinnino aripangku. ");
INSERT INTO gdg_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Se massiki ikkanak, aneno mangituray sikwak, e ana payino sindalukira a iturayangku. Nu sapitangku sino tata si ‘Umangka,’ umang, e nu sapitangku kappay sino tata si ‘Gumamwangka sitaw,’ gumamwang, e nu sapitangku sino tata a aripangku si ‘Akwannu yaw,’ akwanna.” ");
INSERT INTO gdg_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Nakkaꞌbawi Jesus sin naningngagganna sinay. Inaꞌlangngeno odduwa tolaya nebulun sikwana, e sinapiꞌna si, “Sapitangku sikwayu, awana tolaya initaka kunnenoyino kinatuyangngeno angngurungnga, massiki sikwatama gakagaka i Israel.” ");
INSERT INTO gdg_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Wasin nuliyeno dinundunireno kapitan, nadaꞌngareno aripanna a nabbattunoyin. ");
INSERT INTO gdg_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Ammena nabayag e inanda Jesus andino adalannera sino lubbuna ngananda si Nain, e odduweno tolayira a nebulun sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Wasin araꞌniyeran sino lamwanganneno lubbun, nadambaldeno odduwera a tolaya umang mitanam sino lalakiya natay. Inaya natayino tata ke a abbingino balu. ");
INSERT INTO gdg_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Naallakkani Jesusino inaneno natay sin naitana, e sinapiꞌna sikwana si, “Ammekan mattangit.” ");
INSERT INTO gdg_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","E inaraꞌniyi Jesus e iniggammanneno longun takesi mitturino mabboliyira. Wasin nitturira, sinapiꞌna sino natay si, “Buwanak, gumabwakka.” ");
INSERT INTO gdg_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","E ginabwatino natay e naddamit. E sinapiti Jesus sino inana si, “Ayaninnino abbingngu. Nabiyayin.” ");
INSERT INTO gdg_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Ino tolayira a nagyan sinay, nakatalawira ammin e naddayawira ki Dios. Sinapitino korwanira si, “Mannakadameno gumalabbuna inang sito agyanantam.” Sinapikkappayino korwanira si, “Ginamwangi Dios a misalak sikwatama tolena.” ");
INSERT INTO gdg_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Naddinnamino mappeafu ki Jesus andinaya inangwana sino lulubbunna Judea anda sino lellebanna a lubbun. ");
INSERT INTO gdg_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ino adalanira i Juan a Gumabawtisar, maꞌangngira sikwana sino abbalurana nipadamag sikwana ammin inaya inangangwa i Jesus. Antuweno inayanneno adwera a adalanna, ");
INSERT INTO gdg_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","e dinundunnera ki Afu Jesus ta bebutanda nu antuweno nekariyi Dios a gumamwang onnu wara kepay korwan si mataronan. ");
INSERT INTO gdg_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Wasin ginamwangira ki Jesus, sinapiꞌda si, “Dinundundakamiyi Juan a Gumabawtisar ta bebutammi nu ikkeno nekariyi Dios a gumamwang onnu wara kepay korwan si taronammi.” ");
INSERT INTO gdg_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Sinoya ginamwanganda, odduwera a tolaya nepabbattunoyi Jesus sino naddadaruma a takiꞌda, oddu kappaya tolaya nepaanoneno narakkatta espirituwa nunag sikwara, e oddu kappay tolaya inarineno lappaꞌda. ");
INSERT INTO gdg_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wasinoy, sinapiꞌna sino dinundunira i Juan si, “Mulikayu ki Juan ta umandaw sapitan sikwaneno inita anna diningngaddaw, ino lappat, makaitera, ino pilay, makalakarira, ino nakkutal, nabbattunoyira, ino bangngag, makadingngaggira, ino natay, nangngangoliyera, e ino nalawara damag, mebanyag sino mekakallakkira. ");
INSERT INTO gdg_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Itulduyu kappay sikwana si nagasatino tolaya awan daladudwana mappeafu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Wasin nanawinnino dinundunira i Juan, agyanino sinapiti Jesus sino tolayira sinay mappeafu ki Juan. Kunna si, “Sin inangngandaw sino agyanani Juan sey kalolowat, sanneno ginakkaddawa inita? Tata kadda tolaya kunnangke sikalla ipapallenna bayabbag? ");
INSERT INTO gdg_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Nu bakkan, sanna mantuweno inandaw inita? Tata kadda tolaya nalawaringke ino barawasina? Bakkan, se ino mabbarawasiyera si kunnenay anna warawara sikwara, ino balena ari ino agyananda. ");
INSERT INTO gdg_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Sanna mat antuweno gakkuruwa inandaw inita? Tata kadda gumalabbun? On, gakkurug, tata a gumalabbun, udde ino kakuruwanna, nangatu amma si gumalabbun. ");
INSERT INTO gdg_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Se i Juanino sapitannino nepeturakka sapiti Dios a kunna si, ‘Ananeno dundunangkuwa maunta sikwama midadan sino pallakarannu.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Netuluyi Jesus a nassapit si, “Sapitangku sikwayu, awana tolaya neyanak sito lubagga nangatu amma ki Juan, udde massiki nu kunnenoy, ino kaabbafawana tolaya mesapat sino patturayani Dios, nangatu amma sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Ino kaodduwan sino naningngaggira ki Jesus, massiki ino gumattukiyera si buwit, kinurudda si gakkuruwino nepasapiti Dios ki Juan, antuweno nappabawtisarira ki Juan sin nanulduwanna kepay. ");
INSERT INTO gdg_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Udde ino Fariseowera andino mammesturuwerana lintig, inammereno panggammani Dios si akwanda, e ammera nappabawtisar ki Juan. ");
INSERT INTO gdg_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Sinapikkappayi Jesus si, “Sannadeno pikunnangku sino tolayira sito ingkein? Sanneno kakunnara? ");
INSERT INTO gdg_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Mekunnera si abbinga aggatuttud sino aꞌlangino allakuwana ayanino bulundera a makkarayam. Kunnino bulundera si, ‘Massiki sanneno akwammi, ammekayu medagga. Nanontakkami, udde ammekayu nanalip. Nababbinungakami, udde ammekayu nattangit.’ ");
INSERT INTO gdg_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ireno kekunnandaw, se awaningke a anggandawa dingngaggan. Se i Juan, nallantanga mangngan anna ammena ninum, e sinapiꞌdaw si, ‘Naunaggan si narakkatta espiritu.’ ");
INSERT INTO gdg_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","E ikkanaka Abbingnga Tolay, nakikkan anna nakiinumak sikwayu, e sinapiꞌdaw si, ‘Itandaw inaya tolay! Nalawot anna minabbobok anna mebumbulun sino gumattukiyera si buwit andino korwanira a minalliwat!’ ");
INSERT INTO gdg_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Udde massiki nu kunnenoyino sapitandaw, maita si gakkuruwa naggabwat ki Diosino tuldumi anni Juan gafu sino salinunuꞌna sino biyayino manguruwira.” ");
INSERT INTO gdg_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Wasin tata si aw, agyanino Fariseo a mingngan si Simon a nayag ki Jesus ta umang mangngan sino balera. Antuweno inangngi Jesus a mangngan sinay. ");
INSERT INTO gdg_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Sinaya lubbun, agyanino minalliwata bafay. Wasin diningngangnga si ana i Jesus a makikkan sino balayino Fariseo, inang sinaya niyangkalin si nalawaringke a beduruwa napannu si bambangug. ");
INSERT INTO gdg_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Wasin sinallung sinay, inang sino likuri Jesus. Gafu se matattangit, nabateno takkiyi Jesus sino kalaluwana, e finunatanna sino abuꞌnga. Inamammaneno takkina, kasena binubbuwan sino bambangug. ");
INSERT INTO gdg_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Wasin initeno Fariseo a nayag ki Jesus inaya inangwana, kunna sino nakamma si, “Nu gakkurungngadda gumalabbun yawa tolay, ammuna nad nu sanneno katolenenaya bafaya miiggam sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wasinoy, sinapiti Jesus sino Fariseo si, “Simon, aneno sapitangku sikwam.” “Ma, Afu mesturu, sanneno sapitannu?” kunna. ");
INSERT INTO gdg_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Wasinoy, niyampariyi Jesus a nassapit si, “Agyanino tata a tolaya nappagatut si pirak sino adwera a tolay. Ino tata, limatutino ginatuꞌna, e ino tata, limafulu. ");
INSERT INTO gdg_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Gafu se ammera makapaga, ammenan nepapaga. Inyana sikwara a adweno dodokkallino agganggamma sino nappagatut sikwara?” ");
INSERT INTO gdg_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Sinombati Simon si, “Tantaro nu ino tolaya dodokkallino gatuꞌna a ammenan pagan.” “On, gakkurug yan,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Ilangngineno bafay, kasena sinapit ki Simon si, “Itannu yawa bafay. Inayandak sino balem, udde awana nepaappam si danum ta unafangkuweno takkika gagangetam, udde yawa bafay, inunafanneno takkik sino kalaluwana e finunatanna sino abuꞌnga. ");
INSERT INTO gdg_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ammerak kappay dinambala inumma a antuweno gagangetam, udde iyawa bafay, aggeuummanneno takkik kiyad sino ginamwangangku. ");
INSERT INTO gdg_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ammengkappay ilananino abukku, udde antu, binubbuwanneno takkik si bambangug. ");
INSERT INTO gdg_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Sapitangku mantu sikwam, ino dokalla agganggamma nepaitana sikwak, antuweno mangipaita si napakomanino odduwa liwaꞌna. Udde ino tolaya bisangke ino liwaꞌna a napakoman, bisangke kappayino agganggamma ipaitana.” ");
INSERT INTO gdg_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wasinoy, sinapiti Jesus sino bafay si, “Napakomanin amminino liwaꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ino korwanira a makikkan, kunda sino nakanakanda si, “Sanneno katolena yaw a massiki ino liwat, pakomanna?” ");
INSERT INTO gdg_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Udde sinapikkappayi Jesus sino bafay si, “Gafu sino angngurungngu sikwak, nesalakangkan. Manokan a nalawannaddino nakammu.” ");
INSERT INTO gdg_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ammena nabayag, inang nannodoyuwi Jesus sino lulubbuna mangibanyag sino nalawara damag mappeafu sino patturayani Dios. Nebulunino karadwera a adalanna, ");
INSERT INTO gdg_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","andino korwanira a bafabbaya nepabbattunoyna sino takiꞌda anna nappaanawanna sino narakkattira a espirituwa nunag sikwara. Inayira a bafabbay, i Maria Magdalena a nappaanawanna si pituwa narakkatta espiritu, ");
INSERT INTO gdg_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","i Juana a atawa i Cusa a katalakki Herodes, i Susana, andino odduwera kappaya bafulundera. Ino inangwara ammin, nangaꞌdera sino kukwara a iduffunda sikwara Jesus andino adalannera. ");
INSERT INTO gdg_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Wasi tata si aw, odduwa tolaya maggagamwang sino agyanani Jesus a naggabwat sino lulubbuna inangnganna. Wasin nakkakarampattiran, niyampariyi Jesus a nanuldu sikwara si, ");
INSERT INTO gdg_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Aneno tolaya inang nawwarit si aggik sino umana. Wasin aggewarawarit, naddattuweno korwana aggik sino dammingnga dalan, nappipiꞌnakkanino tolayira, e inaꞌnamino mammanukira. ");
INSERT INTO gdg_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Ino korwana newariꞌna, naddattu sino kabatuwana bisangkeno lubangnga. Wasin nattufuwera, nalanira a nalelay, se nammennino nattufuwanda. ");
INSERT INTO gdg_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Ino korwangkappay, naddattuwera sino kasasitan, e neyindanino asita nattufu e ilintuꞌdanino mula. ");
INSERT INTO gdg_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Udde ino korwana newariꞌna, naddattuwera si nalawara lubag, nattufuwera e nammungera si sittatut.” E inabambutani Jesus a nassapit si, “Ikkayuwa maningngag sito ampariggu, dandammandonaddino diningngaddaw.” ");
INSERT INTO gdg_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Wasinoy, nabbebutino adalanira i Jesus sikwana nu sanneno anggamma sapitan inaya amparingnga. ");
INSERT INTO gdg_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Sinabbira i Jesus si, “Ipakaammuwi Dios sikwayuweno ammena nepakaammu siꞌin mappeafu sino patturayanna, udde sino korwanira, amparibbelangino usarangkuwa manuldu sikwara, takesi massiki nu aggitanda, ammera maimunuwan, anna massiki nu aggadingngagganda, ammera maawatan. ");
INSERT INTO gdg_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Antuyawino anggamma sapitan inaya ampariggu. Ino aggika newarit, antuweno sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ino naddattu sino dammingngeno dalan, antuweno keyampariyanino tolayira a maningngag sino sapiti Dios, kase gumamwangi Ofag e ariyanna sino nakandeno sapita diningngadda takesi ammera mangurug anna mesalakan. ");
INSERT INTO gdg_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ino naddattu sino kabatuwan, ireno tolaya manggamma mangurug sin naningngagganda, udde ammena sumallungino sapit sino nakanda, e nu wara gumamwang si dyaꞌda, talekkurandeno angngurudda. ");
INSERT INTO gdg_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ino naddattu sino kasasitan, ireno tolaya maningngag sino sapiti Dios, udde nakungkulino nakanda gafu sino paddararananda sino maawadda, ino bumaꞌnangnganda, andino pangwanda sino mappaanggam sikwara sito lubag, antuweno mabbung sino sapita diningngadda e ammena makapammunga. ");
INSERT INTO gdg_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ino kappay naddattu sino nalawara lubag, ireno tolaya nalawarino aggangwara a kuruwandangke ino sapiti Dios a diningngadda. Iyimfunda sino nakanda e mattalaginarira a mangurug sinay kiyad si wara pattupakkanna sino biyadda.” ");
INSERT INTO gdg_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Niyampariggappayi Jesus a nassapit si, “Awana tolaya mitaggab si lampara, kasena kallabban onnu iyekwana sino gukamma katri, nu ammena lud itappat takesi masirwatanino sumallungira. ");
INSERT INTO gdg_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Kunna kappayino neyampariggu, ammina neimad onnu ammena nepakaammu sito ingkein, mepakaammuna ta maawatanino anggamma sapitan sino maddagguna aw. ");
INSERT INTO gdg_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Lawarandonadda dingngaggannino sapitangku, se ino tolaya manggamma mangwa sino dingngagganna, madadaggananneno angngawaꞌna, udde ino tolaya ammena mangwa sino dingngagganna, massiki ino bisangnga aringnga si ammuna, maawanna.” ");
INSERT INTO gdg_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Wasinoy, ginamwangino ina i Jesus andino kakkolaꞌngera sino agyananna, udde ammera makaaraꞌni sikwana gafu sino kaodduweno tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","E agyanino nituldu ki Jesus si, “Anara inam andino kakkolaꞌnguwera sino lasin, e anggandaka a itan.” ");
INSERT INTO gdg_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Udde sinabbira i Jesus si, “On, udde aneno korwanira a ibilangku si inak anda kakkolakku, ireno maningngag sino sapiti Dios e akwanda.” ");
INSERT INTO gdg_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Wasin tata si aw, sinapiti Jesus sino adalannera si, “Mangngetam sey dammangnga bebay.” E nattakayira si abang e nanawiran. ");
INSERT INTO gdg_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Wasin aggedadammangira, nakaturuwani Jesus. Kakaꞌmeng kelanga nakkalipappag e gapapannuwennino abanda si danum e ngananda si lumannaddiran. ");
INSERT INTO gdg_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Antuweno ginammiyanda i Jesus a sinapiꞌda si, “Afu, Afu, malimattetamun!” Ginabwati Jesus, e sinunneno kalipappag andino palung ta suminakkira, e ilammattinnino kalipappag anna nassiyanakkinnino palung. ");
INSERT INTO gdg_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Wasinoy, sinapiꞌna sino adalannera si, “Mayan naawaninnino annalaꞌdaw sikwak?” Udde nakkaꞌbawira anna nakatalawira e nakkakibikibebutira si, “Sanneno katolena yaw? Se massiki ino kalipappag andino palung, tunannera e kuruwandeno sapitanna.” ");
INSERT INTO gdg_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Wasinoy, netuluyda Jesus a naddammang sino bebay kiyad si ginamwangira sino sakopanna Gerasa a dammangngeno Galilea. ");
INSERT INTO gdg_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Wasin ginaꞌdangira e inulluwi Jesus sino abang, dinambalino tata a lalakiya naggabwat sinaya lubbuna naunaggan si narakkatta espiritu. Inaya lalaki, nabaya aggaboyang anna ammena magyan sino balay se magyampelang sino agwefa attanammanda. ");
INSERT INTO gdg_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","29","Namipidya a pinadyatanino narakkatta espiritu, e massiki balurannino kalubbunannera e kadenandeno kamat anna takkina, garattatanneno kadena e ifuyutino narakkatta espiritu sinaya kalolowat. Antuweno wasin initana i Jesus, nakkulawu e namalitud sino aꞌlangnga. Nekokwana a nassapiti si, “Jesus a Abbingi Dios a Kapatiyan, sanneno gakkannu sikwak? Makiggimallakkak sikwam ta ammerak paidaman!” Antuweno sinapiꞌna, se sinapitinni Jesus si umanonaddino narakkatta espirituwa inassad sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Wasinoy, nebebuti Jesus si, “Sanneno angannu?” “Rinifurifu,” nesombaꞌna, se odduweno narakkatta espirituwa inassad sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","32","Agyan sinayino odduwera a bafuya maddukiruk sino sannaꞌnga kulud. Nakiggimallakkino narakkattira a espiritu ki Jesus si ammenera pabonan sino bituwa awana pakkiyaranna a kakastiguwanda, nu ammenera lud purayan ta munaggira sino bafuyira. E nepurenera. ");
INSERT INTO gdg_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Wasinoy, inanawanino narakkattira a espirituweno lalaki e inangngira nunag sino bafuyira. Naddadaraddaggino bafuyira a naddawut, nangawwatira sino dabbaꞌngeno bebay, nadaraꞌnira, e nalimattira ammin. ");
INSERT INTO gdg_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Wasin initeno mindaggira sino bafuy inaya nakwa, nabbafukalira a inang nituldu sino kalubbunandera anda sino sinaꞌlifandera. ");
INSERT INTO gdg_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Antuweno inang initeno tolayireno nakwa. Wasin ginamwangira sino agyananda Jesus, initareno lalakiya inanawanino narakkattira a espirituwa aggatuttud sino aꞌlangi Jesus a nabbarawasiyen anna nalawarinnino nakamma. Antu gafuna, nakatalawira ammin. ");
INSERT INTO gdg_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ino nakaitera sino nakwa, netuldura sino korwanira nu ansanna nabbattunoyino lalakiya naunaggan. ");
INSERT INTO gdg_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Amminira a naggabwat sino sakopanna Gerasa, nakiggimallakkira ki Jesus ta umanonad sinaya lubbunda, se nappelalotino talora. Antuweno nattakera Jesus sino abang ta umanawira. ");
INSERT INTO gdg_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Ino lalakiya inanawanino narakkattira a espiritu, nakiggimallak ki Jesus ta mebulun nad sikwana, udde sinapiti Jesus si, ");
INSERT INTO gdg_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Nalawad nu mulikan sey baleyu ta sapitannu amminino inangwa i Dios sikwam.” Nanawino lalaki, e awana ammena inangngan sino lubbunda a nituldu sino inangwa i Jesus sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Wasin nulira Jesus sino dammangnga bebay, maanggammino odduwera a tolaya nappagamwang sikwana, se aggataronanda. ");
INSERT INTO gdg_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Wasinoy, ginamwangino tolaya mingngan si Jairo a tata a pangafuwan sino sinagoga sinay. Namalitud sino aꞌlangi Jesus e nakiggimallak ta mebulun sikwana a muli sino balena, ");
INSERT INTO gdg_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","se gapapatayinnino tata ke a abbingnga a bafaya karadweno runna. Wasin aggelakalakari Jesus a umang sinay, nasalpitin sino odduwera a tolaya nebulun sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Ino tata sikwara, ino bafaya aggedada si karadwa si run. Massiki kanayuna mappaagas, awana makapabbattunoy sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Inaraꞌni sino likuri Jesus e sinenggenneno leleneno barawasina. Assenggenna lang sino barawasina, ilammattinnino adana. ");
INSERT INTO gdg_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Sinapiti Jesus si, “Inyeno nanengged sikwak?” Udde tatatata sikwara, sinapiꞌda si bakkannira. E sinapiti Pedro si, “Afu, odduweno tolayira a maddadaraꞌlina manalpit sikwam.” ");
INSERT INTO gdg_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Udde sinapiti Jesus si, “Aneno nanengged sikwak, se giniꞌnak si aneno pannakadama a nallawan sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Wasin naimunuwanino bafay si ammuwi Jesusino inangwana, inaraꞌni sikwana a mayyaꞌyak, e namalitud sino aꞌlangnga. Sinapiꞌna sikwana sino naraꞌlanganino tolayira ino gafuneno nanenggeranna sikwana andino nabbattunoyanino takiꞌna. ");
INSERT INTO gdg_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","E sinapiti Jesus sikwana si, “Ikka a abbingku, gafu sino angngurungngu sikwak, nabbattunoykan. Manokan a nalawannaddino nakammu.” ");
INSERT INTO gdg_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Wasin makitatabbaggepayi Jesus sino bafay, ginamwangino naggabwat sey balera Jairo a nassapit sikwana si, “Ammetamun talantanannino mesturu, se natayinnino abbingngu.” ");
INSERT INTO gdg_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Udde diningngaggi Jesus inaya sinapiꞌna ki Jairo, e sinapiꞌna sikwana si, “Ammeka maddararan. Pattuyaggannu lurino angngurungngu sikwak, e mabbattunoyneno abbingngu.” ");
INSERT INTO gdg_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Wasin ginamwanda Jesus sino balera Jairo, awana nepatallungi Jesus a nebulun sikwana, fera pelang sikwara Pedro, Juan, anni Santiago, andino mapparanakireno abbing. ");
INSERT INTO gdg_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Amminino tolayira a ana sinay, tantangitanda anna babbinungandeno abbing. Udde sinapiti Jesus sikwara si, “Ammekayu mattangit. Ammena natayino abbing, maturubbelang.” ");
INSERT INTO gdg_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Kinakkatawanda i Jesus, se ammuran si natayin. ");
INSERT INTO gdg_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Udde iniggammani Jesusino kamaꞌneno abbing e sinapiꞌna sikwana si, “Ikka a abbing, gumabwakkan.” ");
INSERT INTO gdg_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Nangngangoliyeno abbing e ginabwatin. E sinapiti Jesus a pakkananda. ");
INSERT INTO gdg_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nakkaꞌbawino mapparanaꞌngera, udde sinunira i Jesus si ammera sapasapitan inaya nakwa si massiki sanna a tolay. ");
INSERT INTO gdg_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Wasin tata si aw, inayani Jesusino karadwera a adalanna, e nakkakarampattira. E naꞌdannera si pannakadama anna kalintiyana mappaanaw sino ammina narakkatta espiritu anna mappabattunoy sino matakitira. ");
INSERT INTO gdg_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","E dinundunnera ta umangngira mibanyag mappeafu sino patturayani Dios anna mappabattunoy sino matakitira. ");
INSERT INTO gdg_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Netunna sikwara si, “Ammekayu miyangkalin si massiki sanna a awandaw sino pannodoyuwandaw. Ammekayu miyangkalin si tokud, pasiking, maakkan, pirak, onnu pamataliyandaw. ");
INSERT INTO gdg_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Nu wara mayag sikwayu sino balera, antu naddino pagyanandaw kiyad si umanokayu sinaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Udde nu wara lubbuna umangngandaw, e awana mappadilot sikwayu anna ammera anggamma dingngaggannino tulduyu, umanokayu sinay, e so agganoyu, tattakandawino lafuk sino takkiyu ta antuweno pangammuwanda si ireno makammu sino kakastiguwanda.” ");
INSERT INTO gdg_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wasinoy, ginikkatino adalannera e inangngira nannodoyug sino lulubbuna mangibanyag sino nalawara damag anna mappabattunoy sino matakitira. ");
INSERT INTO gdg_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Wasin nadingngaggi Gubernador Herodes sey Galilea ammin inaya inangangwa i Jesus, nakungkulino nakamma, se aneno nassapitira si nangngangoliyenni Juan a Gumabawtisar. ");
INSERT INTO gdg_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ino korwanira, sinapiꞌda si nappaddenni Elias, e ino korwanira kappay, sinapiꞌda si aneno gumalabbun siꞌina nangngangoli. ");
INSERT INTO gdg_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Udde i Herodes, sinapiꞌna si, “Nepafutulku ke i Juan. Inyada inaya tolaya sapitanda?” E mangiyafu sinoy, aggadandammanna nu ansanneno mita ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Wasin nuliyeno apostolira ki Jesus, netuldura sikwaneno ammina inangwara. E nebulun sikwara a inang sino lubbuna Betsaida a ira pelang. ");
INSERT INTO gdg_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Udde wasin inammuwanino tolayira si inangngira sinay, dinandanandera. E inaꞌlangira i Jesus e sinulduwannera mappeafu sino patturayani Dios. Nepabbattunoyna kappayino matakitira sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Wasin maffuwafin, inangngino adalannera sikwana e sinapiꞌda si, “Paanawannuweno tolayira ta umangngira mita si akkananda anna paturuwanda sino kaaraꞌniyanira a lubbun anna bafalay, se gakkuruwingke a awana bafalay sitaw.” ");
INSERT INTO gdg_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Udde sinapiti Jesus sikwara si, “Ikkayunnino mamakkan sikwara.” E sinabbadda si, “Lima ke a tinapay anna adwaggiya tinapeno ana sitaw. Anggammu si umangkami maggatang si akkanan yo odduwera a tolay?” ");
INSERT INTO gdg_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Antuweno sinapiꞌda se ino kaodduweno lallakiyera pelang, inang si limarifu. Udde sinapikkappayi Jesus sino adalannera si, “Pattutturandawira si allalimafulu.” ");
INSERT INTO gdg_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","E antuweno inangwara. ");
INSERT INTO gdg_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Wasinoy, inappa i Jesusino lima a tinapay annino adwaggiya tinapa, ginaradwana e neyaꞌdana sino adalannera ta iyannera sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Nangnganira ammin e nabattuwira, kase inampattino adalannereno nabuna, e karadwa a basketino pinannura. ");
INSERT INTO gdg_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Wasin tata si aw, nittata i Jesus a makkararag, ino pelang adalannereno bulunna. Wasin nasindu, nebebuꞌna sikwara si, “Sanneno sapitannino tolayira mappeafu sikwak?” ");
INSERT INTO gdg_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","“Aneno massapitira si ikka i Juan a Gumabawtisar. Kunnino korwanira si ikka i Elias, e kungkappayino korwanira si ikkeno tata gumalabbun siꞌina nangngangoli,” nesombaꞌda. ");
INSERT INTO gdg_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","“Udde ikkayu pay,” kunni Jesus, “sanneno kundaw mappeafu sikwak?” Sinabbi Pedro si, “Ikka i Kristo a nekariyi Dios a gumamwanga matturay.” ");
INSERT INTO gdg_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","E netuni Jesus sikwara si ammera naggepay sapitannino katotolena si massiki sanna a tolay. ");
INSERT INTO gdg_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","E netuluyna a nassapit si, “Ikkanaka Abbingnga Tolay, maawa madyatanakungkena. Inona pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwan, ammayandak e papapateraꞌnga, udde pangngangolindaꞌnga i Dios sino mekatalluwa aw.” ");
INSERT INTO gdg_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wasinoy, inayani Jesusino odduwera a tolay andino adalannera, e sinapiꞌna sikwara ammin si, “Ino manggamma mesapat sikwak, talekkuranna naddino urenangkepay. Kunnangke buttunganna naddino krusna kadda aw, se inona urekino tuntulanna, massiki antuweno ipatena. ");
INSERT INTO gdg_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Se ino mikalow sino biyangnga, matekappena. Udde ino matay gafu sino angngurungnga sikwak, ananeno biyaya mannayuna iyaꞌda i Dios sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Se sanna kaddino pallawaranneno tolay nu akwana amminino kinabaꞌnang sito lubag, e matena e makastigu si makkikiyad? ");
INSERT INTO gdg_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Ino tolaya maatalla manaꞌdag sikwak andino itulduk, maatallak kappena a mitaꞌdag sikwana ki Dios nu muliyak. Se ikkanaka Abbingnga Tolay, muliyaꞌnga a mangipaita sino kedayawangku andino kedayawani Ama andino anghelnera. ");
INSERT INTO gdg_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Gakkurug yo sapitangku sikwayu, aneno korwanira sikwayu sitawa ammera matay makkiyad si itandeno patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Wasin nallaꞌwutino talingguwan nangiyafu sin nassapitani Jesus sinay, inayannara Pedro, Juan, anni Santiago, e nanuꞌduwera sino tata a kulud ta makkararira. ");
INSERT INTO gdg_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Wasin aggekarakarari Jesus, nangkakweno baggina, e ino barawasina, naffurawa mangngilikilit. ");
INSERT INTO gdg_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","31","Wasinoy, nappaddeno adwera a lallakiya mangngilikilikkappayino baggira a makitatabbag ki Jesus a da Moises anni Elias. Ino sapitanda, ino araꞌniyenna katayanna sey Jerusalem a keyakkuruwanino planowi Dios. ");
INSERT INTO gdg_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Naturudda Pedro, e wasin nafatira, initareno mangngilikilitani Jesus andino adwera a lalakiya nakitaꞌdag sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Wasin gaaanawino adwera a lallaki sino agyanani Jesus, sinapiti Pedro sikwana si, “Afu, nalawad se ayawetam sitaw. Mangwakamin lud si talluwa bawi, tata sikwam, tata ki Moises, anna tata kappay ki Elias.” Kunnenayino sinapiꞌna, se ammena inammuweno sapitanna. ");
INSERT INTO gdg_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Wasin aggedamadamikkepay, kakaꞌmeng kelanga nakulmutanira ammin si dulam. Naselladdanda Jesus, e nakatalawino adalannera. ");
INSERT INTO gdg_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","E aneno damita naggabwat sino dulamma kunna si, “Antuyawino Abbingkuwa pinilik. Dingngaggandonaddino sapitanna.” ");
INSERT INTO gdg_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Wasin nibbattino naddamit, i Jesus pelanginnino initara. Inaya adalannera, awaningke a nassapitanda mappeafu sinaya initara makkiyad si inanawi Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Wasi kadaramaꞌna, naddawuꞌda Jesus sino kulud, e odduweno tolayira a nanambal sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","E agyanino tata sikwara a lalakiya nakkulawuwa nassapit si, “Afu mesturu, allakkannu abbu yo abbingku se tatatata ke, ");
INSERT INTO gdg_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","e naunaggan si narakkatta espiritu. Kadda umassad sikwana, makkulawu, makkoldat, anna malluluweno wangiꞌna. Padyatannangke ino baggina e ammenangke pimwangan. ");
INSERT INTO gdg_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Inarangku sino adalannuwera si paanawanda naddino inassad sikwana, udde ammera dama a akwan.” ");
INSERT INTO gdg_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","“Ikkayuwa tolay sito ingkein, awaningke angnguruddaw anna ammekayu matulduwan!” kunni Jesus. “Naansa matino panguruwandawa nabayakunna nakiigyan sikwayu? Makapidyak kepaya manus sikwayu?” Kasena sinapit sino ameno abbing si, “Iyangnguweno abbingngu sitaw.” ");
INSERT INTO gdg_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Wasin umaraꞌniyeno abbing ki Jesus, iletwarino narakkatta espiritu e nakkoldat. Udde nepaanawi Jesusino narakkatta espiritu e nepabbattunoyneno abbing, kasena neuli sino amana. ");
INSERT INTO gdg_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","E nakkaꞌbaw amminino tolayira sino pannakadama i Dios a initara sino inangwa i Jesus. Wasin aggakaꞌbokepayino tolayira sino ammina inangangwa i Jesus, sinapiꞌna sino adalannera si, ");
INSERT INTO gdg_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ammeyu kalyawan yawa sapitangku sikwayu. Ikkanaka Abbingnga Tolay, araꞌniyenna meyalawatak sino tolayira kesi akwanda sikwakino massiki sanna a angganda.” ");
INSERT INTO gdg_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Udde ino adalannera, ammera ammuweno anggamma sapitannino sinapiꞌna, se neimaggepay takesi ammera maawatan, e nattalawira a mabbebut sikwana mappeafu sinay. ");
INSERT INTO gdg_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Wasinoy, nattatarukkiyeno adalannera nu inyeno kapatiyan sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Udde ammuwi Jesusino ana sino nakanda, antuweno nayag si tata a abbing e nepataꞌdangnga sino idangnga. ");
INSERT INTO gdg_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","E sinapiꞌna sikwara si, “Ino mangawat sino abbafawa tolaya kakunna yawa abbing gafu sino angngurungnga sikwak, ikkanakino inawaꞌna, e ino mangawat sikwak, inawaꞌna kappayino nanundun sikwak. Se ino kaabbafawan sikwayu, antuweno kapatiyan.” ");
INSERT INTO gdg_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wasinoy, sinapiti Juan ki Jesus si, “Afu, aneno initamiya tolaya mappaanaw si narakkatta espiritu a usaranneno angannu, e inallangngammi se bakkanna buluntam.” ");
INSERT INTO gdg_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","“Ammeyu allangngan,” kunni Jesus, “se ino ammena kumontara sikwayu, antuweno bulundaw.” ");
INSERT INTO gdg_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Wasin araꞌniyennino puliyani Jesus sey langit, neyakkannangke a umang sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","E nanundun si maunta sikwana a umang sino tata lubbunna Samaria ta midadanira sino awanna. ");
INSERT INTO gdg_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Udde ino tolayira sinay, ammera anggamma umangngi Jesus sino lubbunda, se ammura si umang sey Jerusalem a lubbunino Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Wasin diningngadda Santiago anni Juan a adalannerenay, sinapiꞌda sikwana si, “Anggammu ta arangngammi ki Dios ta manaꞌnag si afuy takesi masikkulanira?” ");
INSERT INTO gdg_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Udde inaꞌlangi Jesus sikwara e inallangngannera. ");
INSERT INTO gdg_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","E inangngira si korwana lubbun. ");
INSERT INTO gdg_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Wasin aggelakalakarira, agyanino tolaya nassapit ki Jesus si, “Mebulunak sikwam massiki sintawino umangngannu.” ");
INSERT INTO gdg_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Sinombati Jesus si, “Massiki ino amutitira, aneno agwefa pabbalayanda, andino mammanukira, aneno umuꞌdera, udde ikkanaka Abbingnga Tolay, awana fustu si pagyanangku.” ");
INSERT INTO gdg_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Sinapikkappayi Jesus si korwana tolay si, “Mebulungka sikwak.” Udde sinabbangnga si, “Afu, mebulunak sikwam, udde mattarongka, ta umangku abbu itanammi amak.” ");
INSERT INTO gdg_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Udde sinabbi Jesus si, “Purayannuweno natay ta itanammino bulunnera a kunnangke natayira kappay se ammera mangurug sikwak. Udde inonad akwannu, umangka mibanyag mappeafu sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Ana kappayino tata a nassapit ki Jesus si, “Afu, mebulunak sikwam, udde umangku abbu ituldu sino kabalekira.” ");
INSERT INTO gdg_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Udde sinabbi Jesus si, “Ino tolaya maraduwa makalalangngi, awana serbineno tarabafuna. Kunna kappayino tolaya manggamma mebulun sikwaka ammena pittatanino nakamma sino angngurungnga sikwak, ammena dama a masserbi sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Wasin nasindu inoy, namiliyi Jesus si kawalufuluwera si adwa a korwana tolay sino adalannera, e dinundunnera si siggadwa ta mauntera a umang manuldu sino lulubbuna umangngannana. ");
INSERT INTO gdg_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","E sinapiꞌna sikwara si, “Meyamparig si apayino tolayira a mawag si manuldu sikwara. Odduwen naddino magani, udde bisangngira ke ino maggani. Arangngandonad ki Dios a makwan apay ta manundun si korwanira a manulduwa meyamparig si maggani. ");
INSERT INTO gdg_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Umangkayu! Udde mappalangkayu, se dundunantakayu sino narakkattira a tolaya kundawingke ino karnerowa umang sino agyananino kattalatalawira a sumarona atu. ");
INSERT INTO gdg_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ammekayu miyangkalin si pirak, pasiking, onnu pamataliyandawa sapatut, e ammeyu talantanannino umangngandawa makitatabbag nu wara dambalandaw sino dalan. ");
INSERT INTO gdg_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Nu sumallungkayu sino tata a balay, sapitandaw sino agyanira sinay si, ‘Bindisiyonandakayu naddi Dios.’ ");
INSERT INTO gdg_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Nu meannungira a mabindisiyonan, gakkuruwa mabindisiyonanira, udde nu ammera meannunga mabindisiyonan, ammena makwa. ");
INSERT INTO gdg_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Nu wara mappadilot sikwayu, antuweno pagyanandaw e ammekayu malalit. Ammekayu kappay maatalla mangngan anna minum sino iyaꞌlanda sikwayu, se ino mattarabafu, meannunga matandanan. ");
INSERT INTO gdg_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Antu gafuna, massiki sanna a lubbuna umangngandaw, nu paddilotandakayu, akkanandawino iyaꞌlanda sikwayu. ");
INSERT INTO gdg_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Pabbattunoyandawino matakitira, e sapitandaw sino tolayira sinay si, ‘Araꞌniyen sikwayuweno patturayani Dios.’ ");
INSERT INTO gdg_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Udde nu umangkayu si tata a lubbun e ammerakayu anggamma paddilotan onnu dingngaggan, umangkayu sino dalan e sapitandaw sikwara si, ");
INSERT INTO gdg_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Massiki ino lafuꞌngeno lubbundawa sinikkap sino takkimi, tattakammi takesi antuweno pangammuwandaw si ikkayuweno makammu sino kakastiguwandaw. Udde dandammandonad si inaraꞌniyeno patturayani Dios sikwayu, gampade inammeyu.’ Antu naddino sapitandaw sikwara,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","“Se sapitangku sikwayu, nanu madaꞌngeno pangukumani Dios sino ammina tolay, nadammaꞌneno kastiguweno tolayira sinay amma sino kastiguweno taga-Sodomera.” ");
INSERT INTO gdg_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","Wasinoy, netuluyi Jesus a nassapit si, “Kakallakkayuwa taga-Corazin anna taga-Betsaida! Se oodduweno kakkaꞌbawa inangwak sino lubbundaw, udde ammekayu nabboboli sino liwaꞌdaw. Nannud sey Tiro anna sey Sidonino nangwangku sinayira a kakkaꞌbaw, nabayiran nadda nabbarawasi si nakarumisanga sinnun anna nabburayit si lallang sino ulura a mangipaita si nabboboliyera. ");
INSERT INTO gdg_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Antuweno nalamponeno kastiguweno taga-Tirowera andino taga-Sidonira amma sikwayu naso awa pangukumani Dios sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ikkayu kappaya taga-Capernaum, ariddonakuy si meyantokayu kiyad sey langit. Gampade madyadyatangkayuna a kunnangke metakkuggayu sey infiyernu.” ");
INSERT INTO gdg_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Sinapiti Jesus sino adalannera si, “Ino maningngag sino sapitandaw, ikkanakino diningngangnga. E ino mammayira sikwayu, ikkanakino inammera, e ino mammay sikwak, i Dios a nanundun sikwakino inammera.” ");
INSERT INTO gdg_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Wasin nuli sikwaneno kawalufuluwera si adwa a dinunduni Jesus a manuldu, nappelalotino aangganda, e sinapiꞌda si, “Afu, massiki ino narakkattira a espiritu, kinuruddakami sin nusarammi sino ngannuwa mappaanaw sikwara.” ");
INSERT INTO gdg_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","“On,” kunni Jesus, “se initaki Satanas a naddaꞌna naggabwat sey langita kunnangke ino kilat nu mangilat. ");
INSERT INTO gdg_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Gakkuruwa aꞌdantakayu sino pannakadama a mangaffut sino ammina pannakadama i Satanas, e massiki ipiꞌnaꞌdawino ulag anna mallagama, awana maansa sikwayu. ");
INSERT INTO gdg_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Udde bakkannad inaya pannakadamayuwa mangaffut sino narakkattira a espirituweno mappaanggam sikwayu, nu ammena lurino mappaanggammad sikwayu ino nelistanino angandaw sey langit.” ");
INSERT INTO gdg_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Sinoy kappaya tiyempo, maanggammingke i Jesus gafu sino Espirituwi Dios, e nakkarara nassapit si, “Ama, ikka a Afu sey langit anna sito lubag, mappasalamatak sikwam, se ino kakuruwan mappeafu sikwaka ammem nepakaammu sino nalaingira anna diyadalira a tolay, antuweno nepakaammum sino awana adalda. Mappasalamatak sikwam, Ama, sinaya nakwa, se antuweno panggammannu.” ");
INSERT INTO gdg_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","E sinapiti Jesus sino odduwera a tolay si, “Ikkanakino nitalakkani Ama si amammin. Awana makaammu sikwak nu bakkanni Ama, e awangkappaya makaammu ki Ama nu bakkannappelanga Abbingnga andino tolayira a pilingkuwa pangipakaammuwan.” ");
INSERT INTO gdg_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Wasinoy, nallangngiyi Jesus sino adalannera, e sinapiꞌna sikwara pelang si, “Nagasaꞌna amminino mita sino initayuwa inangwak. ");
INSERT INTO gdg_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Sapitangku sikwayu si odduweno gumalabbunira anna ariyera a nanggamma mita sino initayu, udde ammera naita, e angganda kappaya dingngaggannino diningngaddaw, udde ammera nadingngag.” ");
INSERT INTO gdg_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wasin tata si aw, agyanino mesturuna lintiya inang ki Jesus ta dalodawanna. Sinapiꞌna si, “Afu mesturu, sanneno akwangku takesi maaꞌdanak si biyaya mannayun?” ");
INSERT INTO gdg_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Sinabbi Jesus si, “Sanneno sapitannino neturakka lintiya Moises? Sanneno angngawaꞌnu sinay?” ");
INSERT INTO gdg_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Nesombakkappayino mesturuna lintig si, “Ino nepeturakki Dios, kunna si, ‘Anggammannu naddi Dios a Afum, e pittatannuweno ammina nakammu, ammina urem, ammina tuyangngu, annino ammina kinalaingngu sikwana.’ E kunna kappay si, ‘Anggammannu naddino kasittolem a kunna payino agganggammu sino baggim.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","“Gakkurug yana nesombaꞌnu,” kunni Jesus. “Nu antuweno akwannu, maaꞌdangka si biyaya mannayun.” ");
INSERT INTO gdg_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Udde anggam inaya mesturuna lintiya ipaita si fustuweno akwanna, antuweno nebebuꞌna kappay ki Jesus si, “Inyera kaddino kasittoleka anggammangku nad?” ");
INSERT INTO gdg_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Wasinoy, niyampariyi Jesus a nassapit si, “Agyanino kakunnatama Judyu a naggabwat sey Jerusalem a maddawuta umang sey Jerico. Wasin agyangkepay sino dalan, dinoꞌmanino tulisanira e inappereno ammina ana sikwana, pati sino barawasina, e binadabadduꞌda kiyad si gapapatayin, kasera inanawan. ");
INSERT INTO gdg_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","“Wasinoy, agyangkappayino padina Judyu a maddawut sinaya dalan, udde wasin initanenaya tolay, ilisiyanna e ilaꞌwutanna. ");
INSERT INTO gdg_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Agyangkepayino gakagaka i Levi a kaduffunanino padiyera sino Templo a nallakad sinaya dalan. Wasin dinaꞌnganenaya tolay, inaraꞌniyanna ta itanna, kasena ilisiyangkappay e ilaꞌwutanna. ");
INSERT INTO gdg_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","“Udde ammena nabayag, agyangkappayino tata a taga-Samaria a maddawut sinay. Wasin initanenaya Judyu, naallak sikwana, ");
INSERT INTO gdg_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","inaraꞌniyanna e inagasanneno biyannera si lana anna tayug, kasenera binabbad. Netakena sino kabayuna, neyangnga sino affunduwanino tolayira, e inimuꞌna sinay. ");
INSERT INTO gdg_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Wasin kadaramaꞌna, inaꞌdanna si pirakino makwan balay e sinapiꞌna si, ‘Imutannu, ta nanu muliyak, kaseꞌnga dagganan yaw nu kurang.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wasin nasinduwi Jesus a niyamparig, inabambutanna a nassapit si, “Sino nakammu, inya sikwara a talluweno nangipaita si gakkuruwa agganggam si kasittolay sino pinadyatanino tulisanira?” ");
INSERT INTO gdg_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","“Ino naallak sikwana,” kunnino mesturuna lintig. Sinabbi Jesus si, “Umangka mantu ta akwannu pay.” ");
INSERT INTO gdg_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Netuluyda Jesus andino adalannera a nallakad kiyad si ginamwangira sino lubbuna agyananino tata a bafaya mingngan si Marta, e nepadiloꞌnera. ");
INSERT INTO gdg_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Agyangkappayino kolaki Marta a i Maria. Aggatuttud sino aꞌlangi Jesus a maddingngag sino itulduna. ");
INSERT INTO gdg_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Udde i Marta, maburuburung gafu sino odduwa idadanna para sikwara. Inaraꞌni ki Jesus e sinapiꞌna si, “Afu, mayan purayannu si ikkanappelangino midadan sino awandawa aggatuttubbelangino kolakku? Ituldum ta duffunandak.” ");
INSERT INTO gdg_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Udde netabbi Afu Jesus sikwana si, “Marta, Marta, maburuburungkangke gafu sino kaodduweno akwannu. ");
INSERT INTO gdg_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Udde tata pelangino maawa akwan. Antuweno kalalawarana piniliyi Maria, e ammenan maari sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Wasin tata si aw, inangngi Jesus a makkararag. Wasin nasinduwenna nakkararag, sinapitino tata a adalanna sikwana si, “Afu, tulduwandakami abbuwa makkarara kunnangke ino inangwa i Juan a nanuldu sino adalannera.” ");
INSERT INTO gdg_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Sinapiti Jesus sikwara si, “Nu makkararaggayu, kunnayawino sapitandaw: ‘Ama, madayonaddino ngannu. Gumamwangngaddino patturayannu sito lubag. ");
INSERT INTO gdg_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Iyaꞌdam sikwamiyeno makkana awammi si kadda aw. ");
INSERT INTO gdg_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Pakomannuweno liwaꞌmi, se pakomammi kappayino nakaliwatira sikwami. Duffunandakami ta ammekami matutunggungan.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Sinapikkappayi Jesus si, “Gangngariyan ta wara tata sikwayuwa aneno bulunna, e umang sino balayino bulunna si tangngana gafi ta sapitanna sikwana si, ‘Aꞌdandak abbu si maakkan, ");
INSERT INTO gdg_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","se aneno bulungkuwa mabbiyahe a gaggamwangnga sey balay, e awana ipakkangku sikwana.’ ");
INSERT INTO gdg_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Udde sumombatino ana sino balaya massapit si, ‘Mayan disturbundakami? Naggakukkamin e maturuggami ammin. Matarutakunna gumabwata mangaꞌda sikwam.’ ");
INSERT INTO gdg_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Nu kunnenoy, sanneno akwanino bulunna? Ino sapitangku sikwayu, massiki nu ammena gumabwatino bulunna gafu se bulunna, nu ipatuꞌna a marang, gumabwatino bulunna ta iyaꞌdaneno ammina awanna. ");
INSERT INTO gdg_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Kunnantu, kunnayawino sapitangku sikwayu. Kanayungkayu nadda marang ki Dios, e iyaꞌdana sikwayuweno arangngandaw. Ituluydokappaya mintufuk sikwana sino awandaw, e sumpalandaw. Ituluydokappaya mattottok, e mabukkatanino sawang ta makatallungkayu. ");
INSERT INTO gdg_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Se massiki inya a marang ki Dios, maaꞌdan, e massiki inyeno mintufuk, makasumpal. E massiki inyeno mattottok, mabukkatanino sawang para sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Se dandammandaw, ikkayuwa mapparanak, nu bilisino arangngannino abbindaw, aꞌdandokad si ulag? ");
INSERT INTO gdg_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Onnu nu iꞌluwino arangnganna, aꞌdandokad si mallagama? ");
INSERT INTO gdg_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Ikkayuwa narakkatta tolay, nu ammuyuwa mangaꞌda si nalawad sino abbindaw, mannanotinna ki Dios a Amayu sey langit, iyaꞌdaneno Espirituna sikwayuwa marang sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Wasin tata si aw, nepaanawi Jesusino narakkatta espirituwa nappaabul sino tata a lalaki. Wasin inanawino narakkatta espiritu, makadamitingkappayino lalakiya inanawanna, e nakkaꞌbawino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Udde sinapitino korwanira sikwara si, “I Beelzebub a afafuweno narakkattira a espirituweno nangaꞌda sikwana si pannakadamana a mappaanaw si narakkatta espiritu.” ");
INSERT INTO gdg_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ino korwanira kappay, angganda a dalodawanni Jesus, antuweno inaranda sikwana si mangwa si kakkaꞌbawa mangipaita si i Diosino nanundun sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Udde ammuwi Jesusino ana sino nakanda, antuweno nassapitanna sikwara si, “Nu maggagarunutino tolayira sino tata a lubbun, madaralnenaya lubbun. Kunna kappay sino taabbalayira, nu massasarombatira, makkakaratwayira. ");
INSERT INTO gdg_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Kunna kappay ki Satanas. Nu kontaranneno bafulunnera a narakkatta espiritu, madarallino patturayanna. Antuweno sapitangku sikwayu se sinapiꞌdaw si i Beelzebub ino nangaꞌda sino pannakadamaka mappaanaw si narakkatta espiritu. ");
INSERT INTO gdg_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Nu gakkuruwinay, ino adalandawira a mappaanokappay si narakkatta espiritu, inya mantuweno naggabwatanino pannakadamara? Ira kappayino mipakurug si nabbakabakkannino sapitandaw. ");
INSERT INTO gdg_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Se ino kakuruwanna, ino Espirituwi Diosino nangaꞌda sino pannakadamaka mappaanaw si narakkatta espiritu, e antuweno pangammuwandaw si anen sikwayuweno patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“I Satanas, meyamparig si natuyagga tolaya aneno armasna. Nu indagganneno balena, awana makatakaw sino kukwana. ");
INSERT INTO gdg_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Udde nu gubattannino natuyag amma sikwana e affutanna, iyanoneno armasa nanalakkanino kalingana, kasena appannino kukwana takesi iyannena sino bafulunnera. ");
INSERT INTO gdg_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Ino ammena mebulun sikwak, ireno kumontara sikwak, e ino ammena manuffun sikwaka mampat sino tolayira, ireno mappakakaratway sikwara.” ");
INSERT INTO gdg_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Netuluyi Jesus a niyamparig si, “Nu manawino narakkatta espirituwa nunag si tolay, umang mannodoyug si kalolowata awana danumma a mintufuk si pimwanganna. E nu awana sumpalanna, kunna sino nakamma si, ‘Muliyak sino balaya naggabwatangku.’ ");
INSERT INTO gdg_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Muli e madaꞌnganeno balaya nadalusan anna nalawad amma siꞌin. ");
INSERT INTO gdg_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","E umang mayag si pituwa narakkatta espirituwa mas narakkat amma sikwana takesi makiagyanira sikwana. Kakallakkingke inaya tolay amma sino palunguwa katolena.” ");
INSERT INTO gdg_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Wasin sinapiti Jesus inay, agyanino tata a bafay sino tolayira sinaya nikokwa a nassapit si, “Nagasatingke ino niyanak anna nappasusu sikwam!” ");
INSERT INTO gdg_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","“On,” kunni Jesus a sinombat, “udde mas nagasatino tolayira a maningngag sino sapiti Dios e kuruwanda.” ");
INSERT INTO gdg_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Wasin umoodduweno tolayira a umaribumbung ki Jesus, netuluyna a nassapit si, “Narakkattingke ino tolayira sito ingkein se patutandaka mipaita si kakkaꞌbawa senyal, udde awana mepaita sikwara nu bakkampelangino senyal a kunneno nakwa ki Jonas a gumalabbun siꞌin. ");
INSERT INTO gdg_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Se ino nakwa ki Jonas, antuweno senyala nangipaita sikwara sey Nineve si i Diosino nanundun sikwana. E kunna kappeneno makwa sikwaka Abbingnga Tolay, e antuneno senyala mangipaita sino tolayira sito ingkein si i Dios kappayino nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Nu madaꞌnganeno awa pangukumani Dios sino tolayira, paliwatandakayuneno bafaya ari sey Seba siꞌin, se naggabwat si aroyuwengke a lubbuna inang naningngag sino kinalainga netulduwi Ari Solomon. Udde ikkayu, massiki anen sikwayuweno napatig amma ki Solomon, ammeyu anggamma dingngaggannino tulduna. ");
INSERT INTO gdg_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ino kappay taga-Nineveyira, paliwatandakayuna kappay, se nebobolireno liwaꞌda sin diningngaddeno tulduwi Jonas, udde ikkayu, massiki anen sikwayuweno napatig amma ki Jonas, ammekayu kepay mangurug.” ");
INSERT INTO gdg_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Wasinoy, netuluyi Jesus a niyamparig si, “Awana misigi si lampara, kasena itawu onnu abbungan si angngoran, nu ammena lud itappat takesi masirwatanino tolayira a sumallung. ");
INSERT INTO gdg_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Ino matam, antuweno gumansirwaꞌna baggim. Antu gafuna, nu nalawarino angngitama mittata ki Dios, nabaggawino nakammu. Udde nu narakkattino angngitam, lammuk kepayino nakammu. ");
INSERT INTO gdg_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Mappalangka mantu, tantaro nu sapitannu si nabaggawino nakammu gampade lammuk kena. ");
INSERT INTO gdg_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Udde nu nabaggawino nakammuwa awaningke a lammuk sikwam, masirwatan amminino akwannu a kunnangke anaka sino natuyagga sirwat.” ");
INSERT INTO gdg_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Wasin nasinduwi Jesus a nanuldu, inayanino tata a Fariseo ta umangngira mangngan, antuweno inangngi Jesus sino balena e nakituttura nangngan. ");
INSERT INTO gdg_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Udde nakkaꞌbawino Fariseo sin initana a amme namagguwi Jesus a metuntul sino gagangera. ");
INSERT INTO gdg_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Antuweno sinapiti Jesus sikwana a niyamparig si, “Ikkayuwa Fariseo! Kakunnayuweno tolaya muwappelang sino lasinneno tasa andino likunneno duyug, se dalusandawino baggiyu, udde purayandawino nakandawa napannu si kinadarogat anna narakkat. ");
INSERT INTO gdg_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ikkayuwa pangababulan! I Dios a nangwa sino baggitam, antu kappayino nangwa sino nakantam, antuweno nadalus nad ammin. ");
INSERT INTO gdg_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Kunnantu, ino nad akwandaw, mangaꞌdakayu sino ana sikwayu sino mekakallakkira, se nu madalusanino nakandaw, nadalusin ammin. ");
INSERT INTO gdg_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Kakallakkayuna a Fariseo, se nattalaginaggayuwa mangaꞌda ki Dios sino pakkatafuluneno mulayu, massiki ino kaddatta meusar si rikadu, udde ammeyu akwanino mas napatig sikwana a antuweno pangwandaw si naggaddang sino bafulundaw andino panggammandaw sikwana. Ira nad yawino akwandaw e ituluydokappayino korwan. ");
INSERT INTO gdg_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Kakallakkayuna a Fariseo, se anggandawa pattutturanino attutturanna napatiya tolay sino sinagoga anna anggandokappaya medayawa mapakumusta sino mangitera sikwayu kadda mallakaggayu sino palengki. ");
INSERT INTO gdg_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","“Kakallakkayuna, se kakunnayuweno tanamma awana markana a pappiꞌnakkanino tolayira, e makaliwatira se ammera inammu si tanammino pappiꞌnakkanda.” ");
INSERT INTO gdg_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wasinoy, sinapitino tata a mesturuna lintig si, “Afu mesturu, sin nassapitannu sinay, nesapaꞌdakamiya neyatatal.” ");
INSERT INTO gdg_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","E sinapiti Jesus si, “Kakallakkayuna kappaya mammesturuwerana lintig, se dadagganandawino lintig e patutandawino tolayira a manuntul, gampade awangkena iduffundaw sikwara. Kunnangke pattundawira si nadammat, udde ammekayu manuffuna mattu. ");
INSERT INTO gdg_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Kakallakkayuna, se mangwakayu si nalawara pantiyonin gumalabbunira a pinapatayino gagginafuyuwera siꞌin. ");
INSERT INTO gdg_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Udde sino pangwandaw sinay, ipaitayu si anggandaw inaya inangweno gagginafuyuwera, se ireno namapatay, udde ikkayu payino mangwa sino pantiyonin pinapaterera. ");
INSERT INTO gdg_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Antuweno mangipaita sino kinalaingi Dios, se sinapiꞌna siꞌin si, ‘Ananeno gumalabbunira anna apostolira a dundunangku sikwara, udde papatayandaneno korwanira anna padyatandaneno korwanira.’ ");
INSERT INTO gdg_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Antu gafuna, ino tolayira sito ingkein, makastiguwerana gafu sino napapatayanino amminira a gumalabbun mangiyafu sin naparatuwan yo lubag, ");
INSERT INTO gdg_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","mangiyafu sin napapatayani Abel kiyad sino napapatayani Zacarias a pinapatayin gagginafuyuwera sino nallatanneno assikkulan annino Templo. On, gakkuruwino sapitangku sikwayu, ino tolayira sito ingkein, makastiguwerana gafu sino napapatayanda ammin! ");
INSERT INTO gdg_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Kakallakkayuna a mammesturuwerana lintig, se kunnangke netawuyuweno tulbika pabbukkat sino pangammuwanino tolayira ki Dios. Ammeyu anggamma mesapat sino patturayanna e tipaddandawino tolayira a manggam se ammeyuwera tulduwan sino kakuruwan mappeafu sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Wasin inanawi Jesus sino balay inaya Fariseo, ino mammesturuwerana lintig andino Fariseowera, neyekwareno ammina damara a mangontara sikwana. Oddu kappayino nebebuꞌda ");
INSERT INTO gdg_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","se angganda a balabaliyan tantaro nu wara isombaꞌna sikwara si damara a pappaliwatan sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Sinoy kappaya tiyempo, nakkakarampattino parifurifuwera a tolay kiyad si massasaralpitiran. Sinatabbag abbuwi Jesusino adalannera, e sinapiꞌna si, “Palanandawino lebadureno Fariseowera, anggamma sapitan, ino passasannakammanda. ");
INSERT INTO gdg_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Se ammina neyimad anna ammena naammuwan sito ingkein, mepaita anna maammuwan naso maddagguna aw. ");
INSERT INTO gdg_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Antuweno massiki sanneno sapitandaw si gafi ta meyimad, mepakaammuna so aw, e ino idumidumiyu sino neyakuta kwartu, mekulawuna ta dingngaggan ammina tolay.” ");
INSERT INTO gdg_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Sinapikkappayi Jesus sino adalannera si, “Ino sapitangku sikwayuwa bafulungku, ammekayu nad mattalaw sino mamapatayira si baggina tolay pelang, se antu pelangino pakkiyaranneno pannakadamara, ");
INSERT INTO gdg_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","nu ammena luri Diosino pattalawandaw. Se nu ariyani Diosino biyangnga tolay, ana kappayino pannakadamana a mitakkub sikwara sey infiyernu. Antu gafuna, antu naddino pattalawandaw. ");
INSERT INTO gdg_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Udde dandammandonaggappayino aggangwa i Dios sino dinnattira. Damayu pelanga gatangannino lima a dinnat si adwa a sentabo. Udde amme kalyawani Diosino massiki tata sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Mannanotinna sikwayuwa tolay. Se massiki ino abuꞌdaw, ammuneno bilangnga. Antu gafuna, ammekayu nad mattalaw, se ipatingngeno kadda tata sikwayu amma sino dinnattira.” ");
INSERT INTO gdg_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Netuluyi Jesus a nassapit si, “Sapitangku sikwayu, massiki sanna a tolaya massapit sino aꞌlangino tolayira si mangurug sikwaka Abbingnga Tolay, antu kappayino itaꞌdaggu sino aꞌlangino anghelira i Dios. ");
INSERT INTO gdg_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Udde ino tolaya miyimad si mangurug sikwak sino aꞌlangino tolayira, kunna kappayino sapitangku sino aꞌlangino anghelira i Dios. ");
INSERT INTO gdg_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Massiki inyeno massapit si narakkat mappeafu sikwaka Abbingnga Tolay, dama a mapakoman inaya liwaꞌna, udde ino massapit si narakkat mappeafu sino Espirituwi Dios, ammena dama a mapakoman inaya liwaꞌna si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Nu doꞌmandakayu ta idarundakayu sino sinagogera anna iyaꞌlandakayu sino gubernadorira andino korwanira a turay, ammeyu paddararananino isombaꞌdaw annino sapitandaw, ");
INSERT INTO gdg_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","se sinoyna a orat, ipakaammuneno Espirituwi Dios sikwayuweno fustuwa sapitandaw.” ");
INSERT INTO gdg_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wasinoy, agyanino tata sino kaodduwana naddamit, e sinapiꞌna si, “Afu mesturu, sapitannu sino kolakku ta iballayannak sino illalupattammi.” ");
INSERT INTO gdg_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Udde nesombati Jesus si, “Inyeno nangaꞌda sikwak si kalintiyangkuwa mangukum sikwayuwa mappaballay sino illalupattandawa makkolak?” ");
INSERT INTO gdg_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","E netuluyna a nassapit sikwara ammin si, “Mappalangkayu ta ammekayu matutunggungana mangaꞌrun sino akweno bafulundawira, se ino kukwana tolay, bakkanna antuweno mappabiyag sikwana, massiki sanneno kinabaꞌnangnga.” ");
INSERT INTO gdg_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Antuweno niyampariyani Jesus si, “Agyanino baꞌnangnga tolaya aggodduweno ganinna sino lubangnga. ");
INSERT INTO gdg_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Antuweno kunna sino nakanakamma si, ‘Sannadeno akwangkuwa kurangin yo alangkuwera a pangekwangku sino ammina ginanik? ");
INSERT INTO gdg_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ay, on karud, kunnayawino akwangku. Sassatangku yo alangkuwera ta mappaan-angwak si dodokkal takesi makabalina pangekwangku sino ginanik andino korwana kukwak. ");
INSERT INTO gdg_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Kaseꞌnga sapitan sito baggik si, Nagasataka tolay! Se anen amminino awangku si pipidya a run. Mimwangakunna. Ino penalang akwangku, mangngan, minum, annino mappaanggam sikwak.’ ");
INSERT INTO gdg_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Udde sinapiti Dios sikwana si, ‘Pangababulangka a tolay, se sitawa gafi, matekan. Inyaneno makangkwa sino kukwama inampaꞌnu para sikwamungkepay?’ ” ");
INSERT INTO gdg_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Wasinoy, inabambutani Jesus a nassapit si, “Kunnenayino makwa sino tolayira a mampat si kinabaꞌnangnga para sikwara pelang, udde pobiriyera sino angngita i Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Wasinoy, sinapiti Jesus sino adalannera si, “Antuwen inayino gafuna a sapitangku sikwayu, ammekayu nad maddararan mappeafu sino akkanan anna barawasiya maawaddaw sitawa biyag. ");
INSERT INTO gdg_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Se napatiyino biyag anna baggiyu amma sino akkanan anna barawasi. ");
INSERT INTO gdg_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Dandammandonaddino gayangira. Ammera mabbini, ammera ke maggani, awangkappay alanda a pimfunanda sino akkananda, udde massiki kunnenoy, ammera mabisinan, se iyaꞌda i Diosino akkananda. Ammekayu kad napatig amma sino mammanukira? ");
INSERT INTO gdg_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Ino tata kappay, massiki nu makadaradararangkayu, ammeyu dama a pasoddannino biyaddaw si massiki taorappelang. ");
INSERT INTO gdg_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Nu ammeyu dama a pasoddannino biyaddaw si massiki taorappelang, ammekayu nad maddararan sino korwana maawaddaw sitawa biyaddaw. ");
INSERT INTO gdg_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“Itandawino addokallino sabungira sino danak. Ammera mattarabafu anna massinnun, udde sapitangku sikwayu, massiki i Ari Solomon a nabaꞌnangngingke, awana barawasina a mekunna sino kinalawarirenaya sabung. ");
INSERT INTO gdg_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Nu kunnenayino kinalawara iyaꞌda i Dios sino kaddattira sino danaka mabiyayira pelang si tata si aw e masikkulanira si kadaramaꞌna, ammena kaggappay mangaꞌda sino barawasiya awandaw? Mayan kurang kepayino annalaꞌdaw sikwana? ");
INSERT INTO gdg_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Antu gafuna, ammeyu nad aggadandammannino akkanandaw annino inumandaw e ammeyuwera paddararanan, ");
INSERT INTO gdg_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","se antuweno kabbatannino tolayira a amme nangammu ki Dios. Udde sikwayu, ammuwi Dios a Amayu si awandaw ammin inay. ");
INSERT INTO gdg_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Kunnantu, pittatandonaddino nakandawa manandam sino patturayani Dios, e iyaꞌdanana ammin inaya awandaw. ");
INSERT INTO gdg_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“Ammekayu nad mattalaw, massiki bisangkayu ke, se anggammi Dios si isapaꞌdakayu sino patturayanna. ");
INSERT INTO gdg_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Antu gafuna, ilakuyuweno kukwayu ta iyaꞌdayuweno kalakuwanna sino mekakallakkira. Unoyneno mampakkayu si kinabaꞌnandaw sey langit a kunnangke iyekwayu si pitaka a ammena manaral anna ammena maambutino baggaꞌna, se awana makatakaw sinay anna awana manaral. ");
INSERT INTO gdg_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Se ino kakuruwanna, ino agyananino kinabaꞌnandaw, antu kappayino agyananino nakandaw.” ");
INSERT INTO gdg_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","36","Netuluyi Jesus a nassapit sino adalannera si, “Kanayungkayu nadda maddadan a kunnangke ino aripannira a aggataron sino amunda a inang nakikasar. Aggabarawasiyera anna aggasirwatira takesi nanu gumamwangino amunda e mattottok, lananda a bukkatan. ");
INSERT INTO gdg_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","38","Nagasatirenaya aripan nu daꞌngannino amunda a aggataron anna aggadadan, massiki nu tangngenna gafi onnu araꞌniyen si awino gumamwanganna. Sapitangku sikwayu si mamataliyeno amunda, pattutturanneno aripannera, e pakkanannera. ");
INSERT INTO gdg_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","“Dandammandonaggappay yaw. Nu ammu naddino makwan balayino oratta gamwanganino mattakaw, maddadan nad ta ammena makatallungino mattakaw. ");
INSERT INTO gdg_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Massiki ikkayu, maawa aggadadangkayu, se gumamwangaꞌnga a Abbingnga Tolay sino oratta ammeyu innanaman si gamwangangku.” ");
INSERT INTO gdg_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Wasinoy, sinapiti Pedro si, “Afu, ikkami pelanga adalannuweno nassapitannu sinaya amparig onnu ammina tolay?” ");
INSERT INTO gdg_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Sinombatangkappayi Afu Jesus a niyamparig si, “Ino matalak anna madandamma aripan, antuweno dotukanino amungnga a makammu sino korwana aripanna anna mangaꞌda sino akkananda si kadda aw. ");
INSERT INTO gdg_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Nagasat inaya aripan nu magamwanganino amungnga a mangwa sino nepakwana. ");
INSERT INTO gdg_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Gakkurug yo sapitangku sikwayu, gafu se matalak, dotukangkappayino amungnga a makammu sino ammina kukwana. ");
INSERT INTO gdg_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","“Udde nu kunninaya aripan sino nakamma si, ‘Mabayaggepayino puliyanino amungku,’ e padyatanneno bafulunnera a aripanna lallaki onnu bafabbay, e makakakkan, makininum, anna mabbobok, ");
INSERT INTO gdg_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","kakaꞌmeng kelanga gumamwangino amungnga sino aw anna oratta ammena ininnanama. Kastiguningkeneno amungnga a isapaꞌna sino kakastiguwanino ammerera matalak. ");
INSERT INTO gdg_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ino aripanna nangammu sino anggammino amungnga si akwanna, udde ammena akwan, nadammaꞌneno kastiguna. ");
INSERT INTO gdg_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Udde ino aripanna amme nangammu sino anggammino amungnga si akwanna, makastigu kappay nu makaliwat, udde ammena nadammat. Se ino tolaya odduweno netalak sikwana, oddu kappaya mainnanama a maggabwat sikwana, e ino tolaya oodduweno netalak sikwana, ooddu kappeneno mainnanama a maggabwat sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Sinapikkappayi Jesus a niyamparig si, “Inangngak sito lubagga miyang si afuy e anggangku si gumigillayafin nad. ");
INSERT INTO gdg_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Maawa madyatanakungke, antuweno aggalowino nakangku kiyad si madaꞌngenay. ");
INSERT INTO gdg_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Nganandonakuy si inangngak sito lubagga mappaibbat sino pakkakontaranino tolayira, udde bakkan, se inangngaka mappakakaratway sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Antu gafuna, mangiyafu sito ingkein, makkakontarera. Nu limera a taabbalay, kontaranino talluweno adwera, e ino adwa, kontarandeno talluwera. ");
INSERT INTO gdg_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Ino matatamera andino masasinera, makkakontarera, e massiki ino makkatuwanganira. Makkakontarera ammin.” ");
INSERT INTO gdg_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wasinoy, sinapiti Jesus sino odduwera a tolay si, “Nu itandaw si madduladulam sey diraya, sapitandaw si ‘Gauran,’ e muran gakkurug. ");
INSERT INTO gdg_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","E nu giꞌnandaw si abbaggino paggabwatanino leled, sapitandaw si ‘Napatu sito aw,’ e gakkurug. ");
INSERT INTO gdg_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ikkayuwa massasan mangurug! Nu malasindawino senyal sito lubag anna sey langit, mayan ammeyu maawatanino anggamma sapitannino senyala ipaita i Dios mappeafu sikwak?” ");
INSERT INTO gdg_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Netuluyi Jesus a niyamparig si, “Mayan ammekayu makadandam sino nalawara akwandaw? ");
INSERT INTO gdg_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Gangngariyan, nu wara manggamma midarum sikwam, iyekwamungkenaddino damama makipakoli sikwana nu agyangkayu kepay sino dalan. Se nu ammem akwan inay, idarundaka sino huwes, iyalawaꞌdaka sino pulis, e ibaluddaka. ");
INSERT INTO gdg_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Sapitangku sikwam si ammeka makalawan sino abbaluran kiyad si mapagan amminino multam.” ");
INSERT INTO gdg_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Sinoy kappaya tiyempo, agyanino ginamwangira sino agyanani Jesus e sinapiꞌda sikwaneno nakwa sino korwanira a taga-Galilea a nepapapatayi Gubernador Pilato sino aggewawaꞌlatanda sino animalda ki Dios. ");
INSERT INTO gdg_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Sinapiti Jesus si, “Ariddonakuy si nadammattino liwat inayira a taga-Galilea amma sino ammina kalubbunandera a taga-Galilea gafu se kunnenayino akkapapatera. ");
INSERT INTO gdg_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Udde bakkan. Sapitangku sikwayu, nu ammeyu iboboliyeno liwaꞌdaw, matekayuwa makastiguwa kakunnara. ");
INSERT INTO gdg_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Kunna kappayino kadwafuluwera si waluwa natabbunan sin nagabbanino ataꞌnanga balay sey Siloe a sakoꞌma Jerusalem. Ariddokappay si ireno kararakkattana tolay amma sino ammina korwana magyan sey Jerusalem? ");
INSERT INTO gdg_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Bakkangkappay. Sapitangku kappay sikwayu, nu ammeyu iboboliyeno liwaꞌdaw, kunna kappeneno makwa sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wasinoy, niyampariyi Jesus a nassapit si, “Agyanino tata tolaya aneno kayuwa igosa nemula sino lubangnga. Umangnga aꞌitan nu wara bungana, udde awan. ");
INSERT INTO gdg_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Antu gafuna, sinapiꞌna sino pattarabafunna sino lubangnga si, ‘Talluruninna maꞌangngak sitawa mita nu nammungen yawa kayu, udde awaningke a bungana. Gabbannun, se kengana pelangino nemulanna a lubag.’ ");
INSERT INTO gdg_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","“Udde sinapitino pattarabafunna si, ‘Afu, ammembu pagabba massiki sito pelanga run ta kokkofangkuneno lellebanna ta ekwanangku si abonu. ");
INSERT INTO gdg_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Nu mammungen nanu tarun, nalawad, udde nu ammena mammunga, kasemma pagabba.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Wasin tata Sabadu a awna aggimwangan, nanulduwi Jesus sino sinagoga. ");
INSERT INTO gdg_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Agyan sinayino tata a bafaya nepaddungkuwino narakkatta espiritu si kadwafulu si waluwa run, e ammena makagaddangnga mattaꞌdag. ");
INSERT INTO gdg_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Wasin inita i Jesus, inayanna e sinapiꞌna sikwana si, “Nabbattunoyinnino takiꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","E inappanganna, e kakaꞌmeng kelanga naggaddangnga nattaꞌdag e nedandayona i Dios. ");
INSERT INTO gdg_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Wasinoy, nabbungutino afafuneno sinagoga, se awna aggimwanganino nappabattunoyani Jesus sino bafay. Antuweno sinapitino afafu sino tolayira si, “Annamma aw nabbelangino pattarabafuwantam. Antu naddino awa umangngandawa pappaagasan, a bakkan sino awna aggimwangan.” ");
INSERT INTO gdg_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Sinabbi Jesus si, “Ikkayuwa massasannakam! Kadda tata sikwayu, uttaranneno baka onnu kabayuna ta umangnga painuman, massiki awna aggimwangan. ");
INSERT INTO gdg_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","E sitoya, anen sikwatam iyawa bafaya gaka i Abraham, a kunnangke binaluri Satanas si kadwafulu si waluwa run. Ammena kad nalawad nu pabbattunoyangku sino takiꞌna ta mawayan, massiki sino awna aggimwangan?” ");
INSERT INTO gdg_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Naatallanino kumontarera ki Jesus gafu sinaya nesombaꞌna. Udde ino korwanira a tolay, maanggammirangke gafu sino kakkaꞌbawira a inangangwana. ");
INSERT INTO gdg_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Wasinoy, sinapiti Jesus si, “Sanna kaddino piyampariyangku sino patturayani Dios? Sanneno kekunnanna? ");
INSERT INTO gdg_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Meyamparig si tata a bukalla mustasa a nemuleno tata a tolay sino gardinna. Nattufu e dinokal kiyad si kunnangke kayuweno kataꞌnangnga, e damenna mammanuka pumukanino tangatangana.” ");
INSERT INTO gdg_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Sinapikkappayi Jesus si, “Sanneno piyampariyangku sino patturayani Dios? ");
INSERT INTO gdg_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Mekunna si lebadura a ilamurino bafay si odduwa arina, e massiki bisangke, palattagganna amminino arina a kelamuranna.” ");
INSERT INTO gdg_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Wasinoy, netuluyi Jesus a inang sey Jerusalem, e niittud sino lulubbuna taꞌlifanna ta manuldu sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Agyanino nabbebut sikwana si, “Afu, bisangngira ke kaddino mesalakan?” E sinombati Jesus si, ");
INSERT INTO gdg_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","25","“Iyekwayungke naddino damayuwa sumallung sino bibissangnga sumallungan sey langit se wara kepay wayayu. Se nu iyakutinnino makwan balay, odduneno mangakkapa sumallung, udde ammenan dama. Massiki nu mattottokira a massapit si, ‘Afu, bukkatannu abbu,’ sapitanneno makwan balay si, ‘Ammetakayu inammu.’ ");
INSERT INTO gdg_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","E sapitanda si, ‘Ammurakami se ikkamiyeno nakikkan anna nakiinum sikwam e nanulduka ke sino lubbummi.’ ");
INSERT INTO gdg_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Udde sapitanna kappay si, ‘Gakkuruwa ammetakayu inammu. Manokayun tan, ikkayu ammina mangwa si narakkat.’ ");
INSERT INTO gdg_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Gakkuruwa mattatarangitirana anna mangngarangaritammirana nu itandara Abraham anni Isaac anni Jacob andino ammina gumalabbunira a mesapat sino patturayani Dios, gampade sikwara, ammera makatallung. ");
INSERT INTO gdg_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Udde odduneno tolaya maggabwat si palulubbuna mesapat sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Se aneno abbafawira sito ingkeina meyantawirana, e aneno meyantawira sito ingkeina metabbaferana.” ");
INSERT INTO gdg_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Wasin sinapitinni Jesus inay, ginamwangino korwanira a Fariseo, e sinapiꞌda sikwana si, “Nalawad nu umanoka sitaw, se anggandaka i Herodes a papapatay.” ");
INSERT INTO gdg_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Udde netabbi Jesus sikwara si, “Umandaw sapitan sinaya mamoposung si itulutuluyku kepaya mappaanaw si narakkatta espiritu anna mappabattunoy sino matakitira, udde ammena mabayag, se gababalininnino tarabafuk. ");
INSERT INTO gdg_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Gakkuruwa araꞌniyenna mapapatayak, udde itulutuluyku kepaya umang sey Jerusalem, se kunnangke ammena meannunga mapapatayino gumalabbun, nu bakkan sinay.” ");
INSERT INTO gdg_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","Wasinoy, sinapiti Jesus si, “Ikkayuwa taga-Jerusalem a nallapalappag anna namapatay sino gumalabbunira andino korwanira a dinunduni Dios! Namipidyantakayuwa anggamma paraꞌnin sikwak ta imutantakayu a kunnangke ino akwanino upa a mangakkab sino piyaꞌngera, udde ammeyu anggam. ");
INSERT INTO gdg_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Antu gafuna, ikkayunnino makammu, se anawandakayuwi Dios. Sapitangku sikwayu si ammerakunna maita makkiyad sino awa passapitandona si, ‘Madandayawino gumamwanga dinunduni Dios.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Wasin tata a Sabadu a awna aggimwangan, inangngi Jesus a nakikkan sino baleneno tata a pangafuwanna Fariseowera, e aggitanino tolayira nu sanneno akwanna, ");
INSERT INTO gdg_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","se agyangkappay sinayino tata a lalakiya nallullud. ");
INSERT INTO gdg_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Nebebuti Jesus sino mammesturuwerana lintig andino Fariseowera a agyan sinay si, “Damana sino lintiddama mappabattunoy si matakit sino awna aggimwangan?” ");
INSERT INTO gdg_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Udde aggasisinakkira. E inappangani Jesus inaya matakit e nabbattunoyin, kasena nepaanaw. ");
INSERT INTO gdg_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wasinoy, sinapiti Jesus sikwara si, “Nu wara abbindaw onnu massiki bakayuwa madaꞌnag si bitu, ammeyu kad kangkamana umang ilabbed?” ");
INSERT INTO gdg_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","E ammera makasombat. ");
INSERT INTO gdg_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wasinoy, inita i Jesus si ino korwanira a inayanino Fariseo, pinilireno attutturanino napatiyira a tolay. Antu gafuna, kunnayawino netuni Jesus sikwara ammin. ");
INSERT INTO gdg_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Nu wara mayag sikwam si mangngan, ammeka nad mattuttud sino attutturanino napatiyira a tolay, tantaro nu wara inayanda si napatig amma sikwam. ");
INSERT INTO gdg_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Se nu gumamwangino napatiya tolay, kase umangngino makwan balay sikwam e sapitanna si, ‘Ammeka mattuttud sitan, se antuweno pattutturanna.’ Nu kunnenoy, maatallangka, se palitandaka e umangka makituttud sino likud. ");
INSERT INTO gdg_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Antu gafuna, ino nad akwannu nu maayangka si mangngan, umangka makituttud sino likud. Se nu kunnenoy, nu itandakeno makwan balay, umangnga sapitan sikwam si, ‘Narakkat yan pattutturannu, akkanin taw ta mattuttugga sito nalawara tuttud.’ E medayokana sino naraꞌlanganino korwanira a naayan. ");
INSERT INTO gdg_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Se ino miyantaw sino baggina, metabbafana, udde ino mitabbafa sino baggina, meyantona.” ");
INSERT INTO gdg_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wasinoy, sinapiti Jesus sino nayag sikwana si, “Nu wara iyayangngu si maakkan, bakkampelangino bafulunnuwera, ino kakkolaꞌnguwera andino korwana wayim, andino bafaꞌnangnga kalubbunandawino ayannu, se ayandaka pena e matalyatanino ginastum sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Ino nad akwannu, ayannu kappayino mekakallakkira, ino paralitikuwera, ino pilayira, andino lappattira, ");
INSERT INTO gdg_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","e ammera makatalyat sikwam. Nagasakka nu kunnenayino akwannu, se i Diosneno mallabut sikwam naso awa pangngangolinneno tolayira a naggaddang sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Wasin diningngaggino tata a nakikkan inaya netuni Jesus, sinapiꞌna si, “Gakkuruwa nagasaꞌneno mesapata makilanggak sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Sinombatani Jesus si ampariya nassapit si, “Agyanino tata a tolaya nidadan si odduwa makkan, e odduweno inayannera. ");
INSERT INTO gdg_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Wasin nadadanin ammin, dinundunneno aripanna ta umang mituldu sino inayannera si, ‘Antamun ta umangngetam mangngan.’ ");
INSERT INTO gdg_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Udde kadda tata sino inayannera, narrasonira e ammera inang. Ino sinapitino tata, ‘Ammek umang se aneno ginatangkuwa lubag e umangku nad itan. Ituldumma sino amungngu.’ ");
INSERT INTO gdg_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Ino kappay sinapitino tata, ‘Ammek umang se aneno ginatangkuwa tafuluwa baka, e umangku nad kakkapanira a itarabafu. Ituldumma sino amungngu.’ ");
INSERT INTO gdg_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Sinapikkappayino tata si, ‘Aꞌatawak, antuweno ammek makaang.’ ");
INSERT INTO gdg_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Wasinoy, nuliyeno aripan sino amungnga e sinapiꞌna ammin. Nabbungutingke ino amungnga e sinapiꞌna sino aripanna si, ‘Kadde, kangkamannu mantu ta umangka sino ammina daladalanna yawa lubbun ta ayannuweno mekakallakkira, ino paralitikuwera, ino pilayira, andino lappattira ta umangngira mangngan.’ ");
INSERT INTO gdg_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","E inangngino aripan. Wasin nuli sino amungnga, sinapiꞌna si, ‘Afu, naangwennino nepangwam sikwak, udde ana kepayino damana a pagyanan.’ ");
INSERT INTO gdg_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","E sinapikkappayino amungnga si, ‘Umangka sino daladalan sino lasinna yawa lubbun anda sino kaaroyuwana pagyanan ta patutannuweno tolayira sinaya umang mangngan takesi mapannu yo balek. ");
INSERT INTO gdg_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Se gakkurug yo sapitangku sikwam, awaningke massiki tata sikwara a palunguwa inayangkuwa maninsim sino nedadangkuwa maakkan.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Wasi tata si aw, odduweno tolayira a dumadandan ki Jesus. Inaꞌlang sikwara e sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Ino manggamma mesapat sikwak ta mabbali si adalangku, dodokkal naddino agganggamma sikwak amma sino agganggamma sino mapparanaꞌngera, ino atawana andino anaꞌngera, ino kakkolaꞌngera, anna massiki ino baggina, se nu ammena kunninoy, ammena dama a mabbali si adalangku. ");
INSERT INTO gdg_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Se ammena dama a mabbaliyeno tolay si adalangku nu ammena buttungannino krusna a manuntul sikwak, massiki antuweno ipatena. ");
INSERT INTO gdg_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Dandammandonad abbuweno dyaꞌneno mabbali si adalangku. Gangngariyan, nu wara sikwayuwa mamataꞌdag si dokalla balay, nalawad nu dandammanna abbu nu pidyeno magastuna takesi maammuwanna nu makabalinino piraꞌnga kiyad sino kabalinanna. ");
INSERT INTO gdg_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Se nu ammena akwan inoy, tantaro nu iyafuna e makkiyabbelang sino arina e mambutino piraꞌnga. Amminira a mita sinay, kakkatawandana ");
INSERT INTO gdg_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","a massapit si, ‘Itandokadda! Neyafuna pelang, ammenan metuluy.’ ");
INSERT INTO gdg_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ino tata kappaya amparingnga, nu wara ari si tafulurifuweno sindaluna e umang makiyubat sino ariya adwafulurifuweno sindaluna, dandammanna nad abbu nu damara a affutannino kagubaꞌda. ");
INSERT INTO gdg_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Nu innanamanna si maaffutira, manundun si umang manambal sino kakontarana nu aroyuwera kepay takesi bebutanda nu sanneno angganda ta ammera nad makkakwa. ");
INSERT INTO gdg_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Kunna kappay sikwayu, nu anggandawa mabbali si adalangku, dandammandonad abbuweno kinadyaꞌna. Se ammena dama a mabbaliyeno tolay si adalangku, nu ammena anawan ammina ana sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Niyampariggappayi Jesus a nassapit si, “Ino asin, aneno serbina, udde nu dumantakin, ammenan dama a pulinino peꞌna. ");
INSERT INTO gdg_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Awaningke a serbina, massiki sino lubag onnu meyabonu, metakkummabbelang. Ikkayuwa maningngag, dandammandonaddino diningngaddaw.” ");
INSERT INTO gdg_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Odduweno gumattukiyera si buwit andino korwanira a nganannino Judyuwera si minalliwata maꞌangnga maningngag sino itulduwi Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Antuweno nadadumulino Fariseowera andino mammesturuwerana lintiya nassapit si, “Itandaw yana tolay! Mayan anggamma a tatabbannino minalliwatira a tolay anna makikkan sikwara.” ");
INSERT INTO gdg_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Antu gafuna, kunnayawino ampariyi Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Gangngariyan, nu wara tata sikwayuwa makangkwa si tatuta karnero e naawanino tata, sannadeno akwanna? Ammenada anawanino asamafulu si asama maggarab sino pasto ta umangnga tufukannino naawana karnero kiyad si sumpalanna? ");
INSERT INTO gdg_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","E nanu masumpalanna, maanggammingkena e buttunganna a iyamwang sey balena. ");
INSERT INTO gdg_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nanu gumamwang sinay, ayannaneno bafulunnera andino kalubbunannera e sapitanna si, ‘Makilanggakkayu sikwak, se sinumpalangkunnino karneroka naawan!’ ” ");
INSERT INTO gdg_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","E inabambutani Jesus a nassapit si, “Sapitangku sikwayu si maanggammirangke sey langit nu mabboboliyeno tata a minalliwata tolay amma sino aangganda sino asamafulu e asama aridda si naggaddangngira e ammera nad mabboboli.” ");
INSERT INTO gdg_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Netuluyi Jesus a niyamparig si, “Gangngariyan, nu wara bafaya aneno tafuluwa dipilatana e natantangino tata, sanneno akwanna? Ammenada misigi si lampara e pakakekeranneno balena ta tufukanna kiyad si sumpalanda? ");
INSERT INTO gdg_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","E nanu masumpalanna, ayanneno bafulunnera andino kalubbunannera e sapitanna si, ‘Makilanggakkayu sikwak, se sinumpalangkunnino dipilataka natantang!’ ");
INSERT INTO gdg_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Kakunnana kappay inay,” kunni Jesus, “makilanggakino anghelira ki Dios nu mabboboliyeno massiki tata a minalliwata tolay.” ");
INSERT INTO gdg_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Wasinoy, netuluyi Jesus a niyamparig e sinapiꞌna si, “Agyanino tata tolaya adweno abbingnga a lallaki. ");
INSERT INTO gdg_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Sinapitino uddi si, ‘Ama, appangkunnino ipaillalupaꞌnu sikwak.’ Antuweno ginaradweno amareno illalupattanda a makkolak. ");
INSERT INTO gdg_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Wasin nallaꞌwutino pipidya a aw, nelakuweno uddiyeno ammina ballena e inang si aroyuwa lubbun. Wasin agyanin sinay, ginastuna amminino piraꞌnga si linoloko. ");
INSERT INTO gdg_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Wasin awaninnino piraꞌnga, agyanino nafulota bisin sinaya lubbuna agyananna, e awaningkein sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Antu gafuna, inang nakitandan sino tata a tolay sinay, e dinundunna sino agyananino bafuynera ta antuweno gumapakkan sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Gafu sino bisinna, anggamma nadda mangngan massiki sino ilangagga ipakkanna sino bafuyira, udde awana nangaꞌda sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Wasin makadandam, kunna sino nakanakamma si, ‘Amminira a tandanani ama, ana amminino angganda a akkanan, gampade ayawak sitawa matay si bisin. ");
INSERT INTO gdg_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Muliyak lullang sey balay ta sapitangku ki ama si: Ama, nalliwatak ki Dios e kunna kappay sikwam. ");
INSERT INTO gdg_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Ammekun meannunga mebilang si abbingngu, udde nu damana, makitandanak sikwam.’ ");
INSERT INTO gdg_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“Sin nanandammanna sinay, ginikkata muli sino agyananino amana. Wasin aroyu kepay sino balera, nelasinino amana. Gafu se inallaꞌnga, nalayawa nanambal sikwana, inawakanna, kasena inumma. ");
INSERT INTO gdg_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","E sinapitino abbingnga si, ‘Ama, nalliwatak ki Dios e kunna kappay sikwam. Ammekun meannunga mebilang si abbingngu.’ ");
INSERT INTO gdg_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","“Udde inayanino amaneno aripannera e sinapiꞌna si, ‘Kangkamandaw. Umandaw appannino kalalawarana barawasi ta ibarawasiyu. Sakkalangandokappay anna sapatutandaw. ");
INSERT INTO gdg_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Umandokappay appannino katatafana ubbunna baka ta partindaw takesi isiratam e mallalanggaketam, ");
INSERT INTO gdg_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","se iyawa abbingku, kunnangke natay, udde ana sitawa nabiyag, naantawan, udde nuli kappay.’ E neyafurana mallanggak. ");
INSERT INTO gdg_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Udde ino palunguwa abbingnga, ana kepay sino umara. Wasin umapitin e araꞌniyen sino balera, diningngangngeno mattokarira andino massasaralera, ");
INSERT INTO gdg_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","antuweno inayanneno tata a aripan ta bebutanna nu sanneno akwanda. ");
INSERT INTO gdg_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","‘Nuliyeno kolaꞌngu,’ kunnino aripan sikwana, ‘antuweno nepapartiyi amayuweno katatafana baka se nepagamwangnga a awana naansa sikwana.’ ");
INSERT INTO gdg_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","“Wasinoy, nabbungutino kolaꞌnga e ammena sinallung. Antu gafuna, nallawanino amana a nangaallakka mayag sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Udde sinombata nassapit si, ‘Ammek. Pipidya a runa nattarabafuwak a kunnangke aripannu e kinuruggu ammina sinapiꞌnu. Udde ammerakungke inaꞌdan si massiki ubbunna galding pelang ta wara pakiyayangku sino bafulungkuwera. ");
INSERT INTO gdg_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Udde wasin nuliyeno abbingnguwa naggastu sino kukwam si mimbafay, antuweno nepapartimino katatafana bakatam.’ ");
INSERT INTO gdg_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","“E sinapitino amana si, ‘Ikka a abbingku, ammena nad kunninoy. Se kanayuna anaka sikwak, e ammina ana sikwak, akwangkappay. ");
INSERT INTO gdg_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Udde mallanggaketammad, se ino kolaꞌngu, kunnangke natay, udde ana sitawa nabiyag, naantawan, udde nuli kappay.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Wasinoy, niyampariggappayi Jesus a nassapit sino adalannera si, “Agyanino tata a baꞌnangnga tolaya netalaꞌnga amminino kukwana sino tata a tolaya tandananna. Netattifudda sikwana si gagastumpelangino nitalakkanneno piraꞌnga. ");
INSERT INTO gdg_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Antu gafuna, nepaayino baꞌnang e sinapiꞌna si, ‘Sanna yawa diningngaggu mappeafu sikwam? Iyulimino listaanneno netalakku sikwam, se ariyantaka sino tarabafum.’ ");
INSERT INTO gdg_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","“Wasinoy, kunnino nitalakkanna sino nakanakamma si, ‘Sannadeno akwangkuwa ariyandakunnino amungku sino tarabafuk? Ammek dama a mattarabafu si nadammat e maatallaka mappalimut. ");
INSERT INTO gdg_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Ay, on karug, ammukunnino akwangku takesi nanu maariyak sino tarabafuk, wara kepena bafulungku si manggamma mappadilot sikwak sino bafalerera.’ ");
INSERT INTO gdg_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Wasinoy, inayanneno ammina nakagatutira sino amungnga. Sinapiꞌna sino tata si, ‘Pidyeno gatuꞌnu sino amungku?’ ");
INSERT INTO gdg_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","‘Tatuta lata a lana,’ kunna. ‘Appannu yo risibum. Mattuttugga ta ituraꞌnguweno limafulu,’ sinapitino nitalakkanino baꞌnang. ");
INSERT INTO gdg_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Sinapiꞌna kappay sino tata si, ‘Ikka paye, pidyeno gatuꞌnu?’ ‘Tarifu si salofa trigo,’ kunna. E sinapitino nitalakkanino baꞌnang si, ‘O, appannu yo risibum ta ituraꞌnguweno waluwatut.’ ");
INSERT INTO gdg_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Wasin naammuwanino amungngeno inangwana, dinayoneno kinasirifino nitalakkanna se dinandammeno ikatolena so maddagguna aw. Se gakkuruwa nasirifino tolayira a amme mangurug ki Dios amma sino manguruwira, se ammura a dandammannino pallawaranda. ");
INSERT INTO gdg_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Antu gafuna, sapitangku sikwayu si usarandonaddino kinabaꞌnandaw sito lubagga panuffun sino kasittoleyuwera ta nanu madaꞌnganeno awa awaninna serbineno pirak, paggamwangandakayuna sey langita pagyanandaw si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Netuluyi Jesus a nassapit si, “Ino matalak sino bisangnga neyaꞌda sikwana, matalak kappaya maaꞌdan si oddu, e ino ammena matalak sino bisangnga neyaꞌda sikwana, ammena kappay matalakka maaꞌdan si oddu. ");
INSERT INTO gdg_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Nu ammekayu matalakka musar sino kinabaꞌnandaw sito lubag, ansannana a metalak sikwayuweno gakkuruwa kinabaꞌnang sey langit? ");
INSERT INTO gdg_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Akwa i Diosino ammina kinabaꞌnandaw sito lubag, e nu ammekayu matalakka musar sino akwana, ansannana manalakka mangaꞌda sikwayu si kinabaꞌnang sey langita akwayungkepay? ");
INSERT INTO gdg_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Ammena dama nu adweno amungngeno tata a aripan, se anggammanneno tata e kaꞌganneno tata. Ipatingnga kappayino tata e balawanneno tata. Antu gafuna, nu pirakino napatig sikwayu, ammeyu dama a masserbi ki Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Wasin diningngaggino Fariseowera inayira a sinapiti Jesus, nekakkatawara, se aanggandeno pirak. ");
INSERT INTO gdg_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","E sinapiti Jesus sikwara si, “Nalawarino akwandaw sino aꞌlangino tolayira ta sapitanda si naggaddangkayu, udde ammuwi Diosino ana sino nakandaw. Udde palanandaw, se ino napatig sino tolayira, narakkat ki Dios. ");
INSERT INTO gdg_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ino lintiyi Moises andino neturakkino gumalabbunira, natuntul kiyad sino tiyempowi Juan a Gumabawtisar. Mangiyafu sinay, nebanyino nalawara damag mappeafu sino patturayani Dios, e ipatut amminino tolayira a mesapat. ");
INSERT INTO gdg_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Udde ammena anggamma sapitan inay si ammena matuntulino lintiyi Dios, se naladda a maawan yo lubag anna langit amma sino kaabbafawanna sapiꞌneno lintig. ");
INSERT INTO gdg_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Kakunnaneno sapitannino lintig mappeafu sino angngatawa. Ino lalakiya mikatway sino atawana e mangatawa si korwan, malliwata makibulun. E ino kappay lalakiya mangatawa si bafaya nekatway, malliwakkappaya makibulun.” ");
INSERT INTO gdg_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","E netuluyi Jesus a nanuldu, e sinapiꞌna si, “Agyanino tata a baꞌnangnga tolaya aggabarawasi si nalawad anna kanayuna makilanggak anna mangngan sino anggamma akkanan. ");
INSERT INTO gdg_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Agyangkappayino pobiriya tolaya mingngag si Lazaro a nagguruguririno baggina. Kadda awa magyan sino lamwanganneno balena baꞌnang. ");
INSERT INTO gdg_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Anggamma nadda mamisin sino madaraꞌnag sino lamisaana pangngananino baꞌnang. E ino atuwera, dindilandeno gurinna. ");
INSERT INTO gdg_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Wasin natay inaya pobiri, neyangngino anghelira sino agyanani Abraham sey langit. Wasin natekappayino baꞌnang, netananda, ");
INSERT INTO gdg_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","e inang sey Hades a agyananino natayira. Nappelalotino kinadyaꞌna sinay. E wasin sinangaw, nedipaꞌna i Abraham e ana i Lazaro sino idangnga. ");
INSERT INTO gdg_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Antuweno nekokwana a nassapit si, ‘Afu Abraham, allakkandak ta dundunannuwi Lazaro ta isosoneno tamuruna si danum ta pattakkanna yo dilak takesi mallaꞌbat. Se nappelalotingke ino dyakku sino patuna yo afuy.’ ");
INSERT INTO gdg_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","“Udde kunni Abraham si, ‘Ikka a abbingku, dandammannu nadda sin kabiyangngu, ana sikwamino ammina anggammu, e i Lazaro, passiya dyatino ilawumma. Udde sitoya, makilanggakin sitaw, e ikkanino madyatan. ");
INSERT INTO gdg_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Bakkampelang inay, se nalawengke ino nallatantam e awana makadammang. Ino manggammira a umang sitana maggabwat sitaw, ammera makaang, e ino anera sitan, ammera dama a umang sitaw.’ ");
INSERT INTO gdg_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","“Wasinoy, sinapitino baꞌnang si, ‘Nu kunnenoy, Afu, arangngangku si dundunannuwi Lazaro sey balera ama, ");
INSERT INTO gdg_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","takesi tulduwanneno limera a kakkolakkuwa ana sinay takesi ammera kappay umang sitawa agyananna nappelalota dyat.’ ");
INSERT INTO gdg_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","“Udde sinapiti Abraham si, ‘Massiki ammena umang, se ana sikwareno neturakki Moises andino gumalabbunira, e damara a matulduwan sinay nu pilingalingara.’ ");
INSERT INTO gdg_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","“ ‘On, Afu Abraham,’ kungkappayino baꞌnang, ‘udde tantaro nu ammera kuruwan. Udde nu wara maggabwat sino agyananino natayira a umang sikwara, iboboliraneno liwaꞌda.’ ");
INSERT INTO gdg_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","“Udde sinapikkappayi Abraham si, ‘Nu ammera kuruwannino neturakki Moises andino gumalabbunira, ammera kappay mangurug massiki nu wara mangngangoli si natay.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Wasinoy, sinapiti Jesus sino adalannera si, “Gakkuruwa gumamwangino katutunggungan ta malliwatino tolayira, udde kakallaꞌngeno tolaya paggabwatan inaya tutunggung. ");
INSERT INTO gdg_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Tawwareno meyakad sino buꞌloneno dokalla aggilingana batu, kasena metuꞌyud sino bebay amma si ituluyneno manutunggung e malliwatino massiki tata sitawira a kaabbafawana tolaya mangurug sikwak. ");
INSERT INTO gdg_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Antu gafuna, palanandonaddino akwandaw. “Nu malliwat sikwamino kolaꞌngu si angngurug, tulduwannu, e nu ibobolina, pakomannu. ");
INSERT INTO gdg_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Massiki nu mamippituwa malliwat sikwam si tata si aw e mamippitu kappaya umang mappakapakoli sikwam, maawag si pakomannu kappay.” ");
INSERT INTO gdg_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","E sinapitino apostolnera sikwana si, “Afu, pattuyaggannuweno angngurummi.” ");
INSERT INTO gdg_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","E nesombaꞌna sikwara si, “Massiki bibissangngino angnguruddaw a kakunneno kabibissangngana bukal, damayuwa sapitan sitawa kayu si ‘Mafiꞌdukkana e memulaka sino bebay,’ e gakkuruwa makwa.” ");
INSERT INTO gdg_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Netuluyi Jesus a nassapit si, “Gangngariyan ta wara tata sikwayuwa aneno aripanna a naggabwatinna naradu onnu nindag si karnero, sapitangkaddino makwan aripan sikwana si umang mangngan? ");
INSERT INTO gdg_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Bakkanna kunnenoy, nu ammena lud sapitanna si, ‘Umangka mamatali, kaseka midadan si akkanangku e indaggandak kiyad si masinduwak, kaseka pena mangngan.’ ");
INSERT INTO gdg_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","E amme mappasalamatino makwan aripan sikwana gafu sino nangwanna sino nepakwana. ");
INSERT INTO gdg_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Kunna kappay sikwayu. Nu inangwayun amminino nepakwa i Dios sikwayu, ammeyu nad dandamman si wara midayaw sikwayu, nu ammeyu lud sapitan si, ‘Aripangkami pelang. Inangwami pelangino baligasommi.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Wasin umangnganda Jesus sey Jerusalem, nallakarira sino nallatanna Samaria anna Galilea. ");
INSERT INTO gdg_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Wasin gagagamwangiran sino tata a lubbun, inang dinambalino tafuluwera a nakkutal, udde ammera inaraꞌni sikwara Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","Nakkulawuwera a nassapit si, “Afu Jesus, allakkandakami!” ");
INSERT INTO gdg_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Wasin initera i Jesus, sinapiꞌna si, “Umangkayu mappaita sino padiyera ta itanda nu naariyennino kutaldaw.” E inangngira, e wasin agyanira kepay sino dalan, naariyennino kutalda. ");
INSERT INTO gdg_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Wasin initeno tata sikwara si nabbattunoyin, nuli ki Jesus e nekokwaneno damiꞌna a naddayaw ki Dios. ");
INSERT INTO gdg_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Namalitud sino aꞌlangi Jesus a nappasalamat sikwana. Inaya tolay, taga-Samaria a bakkanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","E sinapiti Jesus si, “Ammena kad tafuluwereno nepabbattunoyku? Sintomatino asamira? ");
INSERT INTO gdg_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Mayan ammera nuliya mappasalamat ki Dios? Iyo pelang tata a bakkanna Judyuweno nuli.” ");
INSERT INTO gdg_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","E sinapiꞌna sinaya tolay si, “Mattaꞌdagga ta umanokan. Nabbattunoykan gafu sino angngurungngu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Wasin tata si aw, agyanino Fariseowera a nabbebut ki Jesus nu naanseno pangiyafuwanino patturayani Dios. Sinapiti Jesus sikwara si, “Awanna a senyala mangipaita sino pangiyafuwanino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Awangkappena makasapit si ‘Itannu, ana sitaw!’ onnu ‘Ana sinay!’ Se ino kakuruwanna, anen sito agyanandawino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wasinoy, sinapiti Jesus sino adalannera si, “Gumamwangngeno tiyempona dyata anggandawingke a itanino puliyangkuwa Abbingnga Tolay, udde ammeyuna maita se bakkangkepaya tiyempona. ");
INSERT INTO gdg_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ananeno massapitira si ‘Umandaw itan se anen sinay!’ onnu ‘Umangkayu sitaw se ayawin taw!’ Udde ammeyuwera kuruwanna umang mangita. ");
INSERT INTO gdg_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Se ino puliyangkuwa Abbingnga Tolay, kunnangke ino kilat nu mangilat, maita si ammina palulubbun. ");
INSERT INTO gdg_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Udde liyeya makwenay, maawag si odduwa lawumangkuwa dyat e ammayandakino tolayira sito ingkein. ");
INSERT INTO gdg_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Inona akwanino tolayira liyeneno puliyangku, kunnaneno nakwa sin tiyempowi Noe. ");
INSERT INTO gdg_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Se sinoya tiyempo, itulutuluyda a nangngan, napparinum, anna napparatawa kiyad sino awa sinallunda Noe sino dokalla abanga inangwana. E nallinang sito lubag e nalimattira ammin. ");
INSERT INTO gdg_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kunna kappayino nakwa sin tiyempowi Lot. Amminino tolayira sey Sodoma a agyananna, itulutuluyda a makakakkan anna makininum, maggatang anna mallaku, mammula anna mamataꞌdag si balay ");
INSERT INTO gdg_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","kiyad sino awa inanawanda Lot sinay lubbun. E nadaꞌnino afuy annino gumigillayafa batuwa mingngan si asufre a naggabwat sey langit, e nasikkulanira ammin. ");
INSERT INTO gdg_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Kunna kappeneno makwa sino awa pappaitangkuwa Abbingnga Tolay. ");
INSERT INTO gdg_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Sinoyna a tiyempo, ino agyan sino lasinneno balena, ammenan makatallunga mangappa sino kukwana. Kunna kappeneno magyan sino umana, ammenan makauli sino balera. ");
INSERT INTO gdg_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Dandammandonaddino nakwa sino atawa i Lot, a nallangngi sino inanawanna e nabbali si asin. ");
INSERT INTO gdg_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","“Ino mikalow sino biyangnga, matekappena. Udde ino matay gafu sino angngurungnga sikwak, maaꞌdanna si biyaya mannayun. ");
INSERT INTO gdg_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Sapitangku sikwayu si nu gafiyeno puliyangku e ananeno adwera a maddurug, maappaneno tata e mataꞌngeno tata. ");
INSERT INTO gdg_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","E ananeno adwera a bafabbaya mabbayu, maappaneno tata e mataꞌngeno tata. ");
INSERT INTO gdg_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","E ana kappeneno adwera a lallakiya mattarabafu sino umara, maappaneno tata e mataꞌngeno tata.” ");
INSERT INTO gdg_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wasinoy, nabbebutino adalannera si, “Afu, sintoneno kakwanna yaw?” Sinabbi Jesus a niyamparig si, “Massiki sintawino agyananino natay, antuweno pakkakarampattanino mammanukira.” ");
INSERT INTO gdg_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Wasinoy, niyampariyi Jesus a nanuldu sino adalannera ta maammuwanda si kanayunira nadda makkararag e ammera matappag. ");
INSERT INTO gdg_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Sinapiꞌna si, “Agyanino huwes sino tata a lubbuna awaningke talona ki Dios anna awana atalna sino kasittolena. ");
INSERT INTO gdg_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Agyangkappayino balu sinaya lubbuna maꞌang sikwana a marang si duffuna massapit si, ‘Duffunandaꞌngad takesi ammerak affutannino kakontarak.’ ");
INSERT INTO gdg_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Amme nepilingalingeno huwes, udde wasin nabayin, dinandamma si, ‘Gakkuruwa awana talok ki Dios, mampesino kasittolekira, ");
INSERT INTO gdg_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","udde gafu se daddisturbundak yawa balu, massiki duffunangkumpelang, tantaro nu matappaggakun sino puluuliyanna.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","E inabambutani Jesus a nassapit si, “Dandammandonad inay. Massiki narakkatta tolayino huwes, dinuffunanneno balu, ");
INSERT INTO gdg_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","e mannanotinna ki Dios, duffunanneno pinilinera a tolena a kanayuna makiggimallak sikwana si aw anna gafi. Talantananna kadda manuffun sikwara? ");
INSERT INTO gdg_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Ammena, nu ammena lud malana manuffun sikwara. Udde massiki tan nu kunnenoy, bisangngira ke nakuyino mattalaginad si angngurug naso puliyangkuwa Abbingnga Tolay.” ");
INSERT INTO gdg_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Wasinoy, agyanino sinatabbira i Jesus a tolaya ngananda si naggaddangngira e balawandeno kasittolerera. Antuweno niyampariyi Jesus si kunnayaw. ");
INSERT INTO gdg_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Agyanino adwa a tolaya inang sino Templo ta makkararira. Fariseoweno tata e gumattuki si buwitino tata. ");
INSERT INTO gdg_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Wasin sinallungira, aggataꞌdaggino Fariseo a ikararanneno bagginangkepaya nassapit si, ‘Mappasalamatak sikwam Dios, se bakkannaka minalliwat a kakunneno korwanira a tolay, kumaral inaya gumattuki si buwit. Se ammek naingap, ammek massisiri, anna ammek kappay makibulun. ");
INSERT INTO gdg_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Mamidwaka mallantanga mangngan si kadda linggu e iyaꞌdakino pakkatafuluneno ammina ganansiyak.’ ");
INSERT INTO gdg_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","“Udde ino gumattuki si buwit, aroyuweno nattaꞌdagganna sino Fariseo andino korwanira a tolay. Aggaokab se maatalla sumangaw sey langit e pakatotottofanneno taꞌgangnga gafu sino piboboliyanna sino liwaꞌna. Ino nekararangnga, ‘Dios, maallakka nad sikwaka minalliwat.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","E inabambutani Jesus a nassapit si, “Sapitangku sikwayu, inaya gumattuki si buwitino inanawa naggaddang ki Dios se napakomanino liwaꞌna, a bakkannino Fariseo. Se ino miyantaw sino baggina, metabbafana, udde ino mitabbafa sino baggina, meyantona.” ");
INSERT INTO gdg_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Wasin tata si aw, agyanino tolayira a niyang sino bawisangngira a abbinda ki Jesus takesi appangannera nad anna bindisiyonannera. Udde wasin initeno adalannera, inallangngandera. ");
INSERT INTO gdg_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Udde inayani Jesusino abbingira, e sinapiꞌna sino adalannera si, “Purayandawino anakira ta umangngira sikwak, e ammeyuwera allangngan. Se ino kakunnara, ireno dama a mesapat sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Gakkurug yo sapitangku sikwayu, nu ammeyu talakkanni Dios a kakunneno annalakkino abbing, ammekayu makatallung sino patturayanna.” ");
INSERT INTO gdg_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Agyanino tata a afafuna Judyu a nabbebut ki Jesus si, “Ikka a nalawara Afu, sanneno akwangku takesi maaꞌdanak si biyaya mannayun?” ");
INSERT INTO gdg_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Sinapiti Jesus sikwana si, “Mayan nganandak si nalawad? Se awana nalawad, nu bakkampelangi Dios. ");
INSERT INTO gdg_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Ammumino lintiyi Dios a kunna si, ‘Ammeka makibulun, ammeka mamapatay, ammeka mattakaw, ammeka manistigu si bakkanna gakkurug, e dayawannuweno mapparanaꞌnguwera.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","“Afu mesturu,” kunnino tolay sikwana, “kiyad sin kabbingku, kinuruggu ammin yana lintig.” ");
INSERT INTO gdg_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Wasin diningngaggi Jesus inay, sinapiꞌna sikwana si, “Ana kepayino tata a pakkurangannu. Umangngu ilaku amminino kukwam ta iyannem sino pobiriyereno pallakuwannu, ta ananeno kinabaꞌnangngu sey langit. Nu inangwamunnenay, kaseka muli sitaw e mebulungka sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Udde wasin diningngangngenaya sinapiti Jesus, malowingke ino nakamma, se baꞌnangngingke. ");
INSERT INTO gdg_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Wasin inita i Jesus si malowino nakamma, sinapiꞌna si, “Madyatingke a mesapatino bafaꞌnangngira sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Mas naladdeno attaffutino kamelyu sino abbuꞌneno bilat amma sino kesapatanino baꞌnangnga tolay sino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Ino naningngaggira sinay, sinapiꞌda si, “Nu kunnenoy, inya maꞌneno mesalakan?” ");
INSERT INTO gdg_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Sinabbira i Jesus si, “Ino amme dama a akwanna tolay, damana ki Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","E sinapiti Pedro si, “Ikkami paye? Se inanawammiyeno bafalemi e nebulungkami sikwam.” ");
INSERT INTO gdg_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","“Gakkurug yan,” kunni Jesus, “e sapitangku sikwayu si ino manganaw sino balena, ino atawana, ino kakkolaꞌngera, ino mapparanaꞌngera, andino aanaꞌngera gafu sino patturayani Dios, ");
INSERT INTO gdg_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","oodduneno iyaꞌda i Dios sikwana sitawa biyag, e naso uddina aw, maaꞌdanna si biyaya mannayun.” ");
INSERT INTO gdg_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wasinoy, neyaroyuwi Jesusino karadwera a adalanna, e sinapiꞌna sikwara si, “Dingngaggandaw. Sitoya, umangngetam sey Jerusalem, e meyakkurungngeno ammina neturakkino gumalabbunira mappeafu sikwaka Abbingnga Tolay. ");
INSERT INTO gdg_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Se meyalawataꞌnga sino bakkannira a Judyu, e pappoporayandaꞌnga, iyatataldaꞌnga, anna luluppandak, ");
INSERT INTO gdg_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","kaseraꞌnga siwaꞌwattan anna papatayan. Udde sino mekatalluwa aw, mangngangoliyaꞌnga.” ");
INSERT INTO gdg_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Udde ammayingke naawatanino adalannerenaya sinapiꞌna, se neyimad sikwareno anggamma sapitan e ammera maattalan. ");
INSERT INTO gdg_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Wasin makkatanda Jesus sey Jerico, agyanino lappatta aggatuttud sino dammingngeno dalana makipalimut. ");
INSERT INTO gdg_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Wasin diningngangnga si odduwereno tolaya mallaꞌwut, nebebuꞌna nu sanneno makwa. ");
INSERT INTO gdg_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","E sinapiꞌda si, “Mattaꞌlifi Jesus a taga-Nazaret.” ");
INSERT INTO gdg_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Antuweno nekokwana a nassapit si, “Jesus, gaka i David, allakkandak!” ");
INSERT INTO gdg_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Inallangnganino nauntera ta suminaꞌngad, udde neyangkakokwana lullanga nassapit si, “Ikka a gaka i David, allakkandak!” ");
INSERT INTO gdg_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nitturi Jesus e sinapiꞌna si iyaraꞌnira sikwaneno lappat. Wasin neyaraꞌnira, nebebuti Jesus sikwana si, “Sanneno anggammuwa akwangku sikwam?” ");
INSERT INTO gdg_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Afu, anggangkuwa makaita,” kunnino lappat. ");
INSERT INTO gdg_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","“Makaitakan,” kunni Jesus. “Nabbattunoykan gafu sino angngurungngu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Kakaꞌmeng kelanga makaiteno lappat e dinandan ki Jesus a maddayaw ki Dios. Amminira a nakaita sinaya nakwa, nedandayora kappayi Dios. ");
INSERT INTO gdg_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Wasin ginamwanda Jesus sey Jerico, mangawwatira nad. ");
INSERT INTO gdg_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Udde agyan sinayino tata a baꞌnangnga afafuweno gumattukiyera si buwita mingngan si Zakeo. ");
INSERT INTO gdg_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Anggamma itani Jesus, udde ammena dama, se abbafawingke e odduweno tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Antu gafuna, nalayaw e naunta ki Jesus, kasena nunek sino tata a kayuwa sikumoru takesi maitana i Jesus nu mallaꞌwut. ");
INSERT INTO gdg_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Wasin nabbatuwinni Jesus sino agyanani Zakeo, sinangona e sinapiꞌna si, “Zakeo, umulluggan, se maawag si umangngak sey balem sito aw.” ");
INSERT INTO gdg_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nakkangkama inulluwi Zakeo, e maanggammingke a nibulun ki Jesus sino balena. ");
INSERT INTO gdg_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Udde amminira a nangita, nadadumulira a nassapit si, “Mayan umang magyan sino balayino minalliwata tolay?” ");
INSERT INTO gdg_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Wasin agyaniran sino balena, nattaꞌdaggi Zakeo e sinapiꞌna ki Jesus si, “Afu, iyaꞌdakino kagadwaneno kukwak sino mekakallakkira. E massiki inyeno dinarogakku, iyulik sikwaneno mamin-appata kaodduneno inappak.” ");
INSERT INTO gdg_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Antuweno sinapiti Jesus si, “Sitawa aw, neyafuwenna mesalakan yawa taabbalay. Se gafu sinaya sinapiti Zakeo, nepaitana si gakkuruwa gaka i Abraham. ");
INSERT INTO gdg_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","E ikkanaka Abbingnga Tolay, ino pelang gakkagguwa inang sito lubag ino mintufuk sino narakkattira a tolay ta mesalakanira.” ");
INSERT INTO gdg_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Odduwa tolaya naningngag sinaya sinapiti Jesus, e netuluyna a nanuldu sikwara. Gafu se araꞌniyeran sey Jerusalem, aridda si nu gumamwangira sinay, mangiyafuwennino patturayani Dios. Antu gafuna, kunnayawino neyamparingnga. ");
INSERT INTO gdg_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","“Agyanino napatiya tolaya inang si aroyuwa lubbun takesi dotukanda si ari, e nanu muli sino lubbunna, mangiyafuwenna a matturay. ");
INSERT INTO gdg_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Udde liyena a inang, inayanneno tafuluwera a aripanna, e inaꞌdanneno kadda tata si pirak e sinapiꞌna si, ‘Paoddundaw yawa pirak kiyad sino puliyangku.’ ");
INSERT INTO gdg_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“Udde kababannino kalubbunannera, antuweno nanundunira si dumandan sikwana a umang massapit sino manotuk sikwana si amme anggammino tolayira si antuweno arira. ");
INSERT INTO gdg_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Massiki kunnenoyino inangwara, nadotukangkappay si ari, e nuli sino lubbunda. “Wasin gamwangnga, nepaayangngeno aripannera a naꞌdanna si pirak takesi bebutanna nu pidyeno ganansiyara. ");
INSERT INTO gdg_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Ginamwangino tata, e sinapiꞌna si, ‘Afu, ino ganansiyak sino piraꞌngu, namittafuluweno neyaꞌdam.’ ");
INSERT INTO gdg_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Nalawarino inangwam,’ kunnino ari. ‘Nalawagga a aripan. Gafu se natalakka sino bisangnga neyaꞌdak sikwam, patturayantakana si tafuluwa lubbun.’ ");
INSERT INTO gdg_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","“Ginamwangkappayino tata a aripanna, e sinapiꞌna si, ‘Afu, ino ganansiyak sino piraꞌngu, namillimeno neyaꞌdam.’ ");
INSERT INTO gdg_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Sinapikkappayino ari si, ‘Patturayantakana si lima a lubbun.’ ");
INSERT INTO gdg_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Ginamwampayino tata a aripanna, e sinapiꞌna si, ‘Afu, ayawin tawino piraꞌngu. Binabaꞌbattangku si panyok e neyimfungku, ");
INSERT INTO gdg_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","se nattalawak sikwam se nabungukka a tolay. Se magganansiyaka sino ammem nallingattan a kunnangke buwatannuweno ammem nemula.’ ");
INSERT INTO gdg_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","‘Narakkakka a aripan,’ kunnino ari. ‘Ino sinapiꞌnungkepayino pangukungku sikwam. Ammungkena a nabungutaka tolaya magganansiya sino ammek nallingattan anna buwatangkuweno ammek nemula. ");
INSERT INTO gdg_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Mayan ammem mantu nebangkuweno pirakku takesi wara nad appangku si ganansiya sito nuliyangku?’ ");
INSERT INTO gdg_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Wasinoy, sinapitino ari sino aggataꞌdaggira sinay si, ‘Appandawino piraꞌnga ta iyaꞌdayu sino nagganansiya si tafulu.’ ");
INSERT INTO gdg_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","“ ‘On, afu,’ kunda, ‘udde anennino tafulu sikwana.’ ");
INSERT INTO gdg_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","“ ‘Gakkurug,’ kunnino ari, ‘udde sapitangku sikwayu, ino matalakka musar sino neyaꞌda sikwana, madadaggananna, udde ino ammena matalak, massiki ino bisangnga ana sikwana, maawanna. ");
INSERT INTO gdg_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","E ira a kumontara sikwaka amme nanggamma ikkanakino matturay sikwara, iyandawira sitaw ta papatayandawira sito aꞌlangku.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Wasin nasinduwi Jesus a niyamparig, netuluyda a umang sey Jerusalem, e naunta i Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Wasin araꞌniyeran sey Betfage anna sey Betania sino kulura Olivo, nepauntaneno adwera a adalanna a nassapit si, ");
INSERT INTO gdg_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“Umangkayu sino madompaka lubbun. Addatandaw sinay, maitayuneno neyakadda ubbunna asnowa ammena kepay natakayan. Ubbarandaw ta iyandaw sitaw. ");
INSERT INTO gdg_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Nu wara mabbebut sikwayu si, ‘Sandolang ubbaran yan?’, kundaw sikwana si, ‘Awannino Afutam.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Inangngino dinundunnera, e neyakkurug amminino sinapiti Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Wasin ubbarandeno lufinneno ubbun, sinapitino makangkwa si, “Mayan ubbarandaw yan?” ");
INSERT INTO gdg_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","“Awannino Afutam,” nesombaꞌda. ");
INSERT INTO gdg_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","E neyandeno ubbun ki Jesus. Neyekwareno tafalda sino daruruna, kasera nepattakayi Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Wasin nattakayinni Jesus, neyafakkino tolayireno tafalda sino dalan. ");
INSERT INTO gdg_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Wasin araꞌniyeran sey Jerusalem a maddawut sino kulura Olivo, maanggammingke ino odduwera a nebulun sikwana, e nekokwareno damiꞌda a maddayaw ki Dios gafu sino ammina kakkaꞌbawa initara. ");
INSERT INTO gdg_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Sinapiꞌda si, “Madandayawino ariya dinunduni Afu Dios si pannakabaggina! Nalawarinnino abbafaruluntam ki Dios gafu sikwana! Madandayawi Dios sey langit!” ");
INSERT INTO gdg_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ino korwanira a Fariseo a nedagga sino tolayira a umang sey Jerusalem, sinapiꞌda ki Jesus si, “Afu mesturu, pasinakkannuweno bafulunnuwera.” ");
INSERT INTO gdg_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Udde sinabbira i Jesus si, “Gakkurug yo sapitangku sikwayu, nu suminakkira, mepataliyeno batuwera a maddayaw sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Wasin makkataminda Jesus sey Jerusalem, initaneno lubbun e nattangit gafu sino allaꞌnga, ");
INSERT INTO gdg_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","e sinapiꞌna si, “Kakallakkayuna a ayan sitan Jerusalem! Nu ammuyu nad sito ingkein nu ansandawa makipakapakoli ki Dios! Udde nabaya inammeyu, e sitoya, ammeyun melasin. ");
INSERT INTO gdg_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Madaꞌnganeno awa balikungkunganneno sindaluweno kalingayuwereno lubbundaw, e tappannandeno pangannandaw takesi ammekayu makalawan. ");
INSERT INTO gdg_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Darallandaneno lubbundaw e marappakkayu ammin. Awaningke massiki tata a batuwa mabattang sino agyananna. Kunnanenayino makwa sikwayu se ammeyu nelasinino ginamwangani Dios a misalaꞌngad sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Wasin ginamwangi Jesus sey Jerusalem, inang sino Templo, e nepaanoneno mallakuwera sinay. ");
INSERT INTO gdg_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Sinapiꞌna sikwara si, “Neturak sino sapiti Dios si, ‘Ino balek, maingnganan si pakkararanna tolay.’ Udde ino inangwayu, nepabbaliyu si paddarogatandaw sino kasittoleyu.” ");
INSERT INTO gdg_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Kadda aw, nanulduwi Jesus sino Templo. E ino pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a afafuweno tolayira, nattatarabbanda nu ansandeno mamapatay ki Jesus, ");
INSERT INTO gdg_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","udde awana dinandanda si damara akwan, se amminino tolayira, angganda a dingngaggannino tulduna. ");
INSERT INTO gdg_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Wasin tata si awa agyani Jesus sino Templo a manuldu anna mibanyag sino nalawara damag sino tolayira, inang sikwaneno pangafuwanirana padi, ino mammesturuwerana lintig, andino korwanira a pangafuwan. ");
INSERT INTO gdg_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nebebuꞌda sikwana si, “Sapitannu nad sikwami nu sanneno kalintiyannuwa mangwa sino inangwamira. Inyeno naggabwatanna yana kalintiyannu?” ");
INSERT INTO gdg_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Sinabbira i Jesus si, “Ana payino ibebukku sikwayu. Sapitandaw sikwak ");
INSERT INTO gdg_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","nu inyeno naggabwatanino kalintiyani Juan a mamawtisar? Ki Dios onnu si tolay?” ");
INSERT INTO gdg_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","E nakkakibikibebutira a nassapit si, “Sanneno isombattam? Nu kuntam si i Diosino naggabwatanino kalintiyanna, tantaro nu sapitanna si ‘Nu kunnenoy, mayan ammekayu nangurug sikwana?’ ");
INSERT INTO gdg_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Udde nu kuntam si tolepelangino naggabwatanna, lapalappaggandetam amminino tolayira, se kuruwanda si tata a gumalabbuni Juan.” ");
INSERT INTO gdg_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Antuweno sinapiꞌda si, “Ammemi inammu nu inyeno naggabwatanna.” ");
INSERT INTO gdg_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Sinapikkappayi Jesus si, “Ammeppemantu sapitan sikwayu nu inyeno naggabwatanino kalintiyangkuwa mangwa sitawira a akwangku.” ");
INSERT INTO gdg_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wasinoy, nanuldu kappayi Jesus sino tolayira a niyamparig si, “Agyanino tata a tolaya nammula si odduwa ubas, kasena nepaimut sino makikasamakkira. Inang nagyan si aroyuwa lubbun e nabayag sinay. ");
INSERT INTO gdg_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Wasin nadaꞌngeno abbafuwat si ubas, dinundunino makwan lubaggino tata a aripanna a umang sino makikasamakkira ta appanneno ballena. Udde wasin ginamwang, siniwasiwaꞌwattanino makikasamakkira, kasera nepaanawa kamakamaꞌna pelang. ");
INSERT INTO gdg_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Antuweno nandadundungkappayino makwan lubag si tata a aripanna. Udde kunna kappayino inangwara, sinawasiwaꞌwattanda e neyatatalda, kasera nepaanawa awana neyaꞌdara sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Antu gafuna, nandadundungkappay si mekatalluwa aripanna, e binibiyaranda, kasera netakkub sino lasinneno kaubasan. ");
INSERT INTO gdg_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Wasinoy, sinapitino makwan lubag si, ‘Sannadeno akwangku? Dundunangkuweno abbingkuwa iiddukangku, se ammuk si iyataldana.’ ");
INSERT INTO gdg_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","“Udde wasin initeno makikasamakkira, sinapiꞌda si, ‘Antuwen yawino millalupat sito lubag. Papatayantam ta akwatamunnino illalupattanna.’ ");
INSERT INTO gdg_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","E nelawanda sino kaubasan, kasera pinapatay.” E sinapiti Jesus si, “Sannadeno akwanino makwan lubag sikwara a makikasamak? ");
INSERT INTO gdg_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Umangngerana papatayan, kasena ipabalattino lubangnga si korwan.” Wasin diningngaggino tolayirenay, sinapiꞌda si, “Bakkanna kunnayan!” ");
INSERT INTO gdg_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Udde sinulangngannera e sinapiꞌna si, “Nu kunnenoy, sanna mantuweno anggamma sapitan yawa nepeturakki Dios? ‘Ino batuwa inammayino mamataꞌdaggira si balay, antuweno nepabbaliyi Dios si kapatiyana batuwa mappatuyag sino balay.’ ");
INSERT INTO gdg_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Ino tolaya madaꞌnag sitawa batu, makarattu, udde ino tolaya kadaꞌnanino batu, mamaꞌmakka mabbali si lafuk.” ");
INSERT INTO gdg_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Wasin diningngaggino mammesturuwerana lintig andino pangafuwanirana padi inaya ampariyi Jesus, anggandana doꞌman, se ammura si ireno ampariyanna. Udde mattalawira sino tolayira, ");
INSERT INTO gdg_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","antu gafuna, aggataronira si wara pappadoꞌmanda sikwana. Ino inangwara, pinirakandeno korwanira a lallaki ta massasan manguruwira a umang ki Jesus. Sinundera a mabbebut ki Jesus takesi nu wara isombaꞌna si damara a pidaruman sikwana, kasera doꞌman e iyalawaꞌda sino gubernadora taga-Roma a turay sinaya lubbunda. ");
INSERT INTO gdg_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Inangngira ki Jesus, e nebebuꞌda si, “Afu mesturu, ammumi si fustu amminino sapitannu annino ituldum. Ammumi kappay si awana padumannu si tolay, nu ammem lud itulduweno kakuruwan mappeafu sino panggammani Dios a akwanna tolay. ");
INSERT INTO gdg_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ituldummad sikwami nu kontara sino lintiddama Judyu nu pagammiyeno buwit sino Emperador sey Roma. Pagammi onnu awan?” ");
INSERT INTO gdg_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Udde ammuwi Jesus si angganda a balabaliyan, antuweno sinapiꞌna sikwara si, ");
INSERT INTO gdg_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Mipaitakayu abbu si pirak sikwak. Makwan letratu anna angan sitaw?” ");
INSERT INTO gdg_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","“Ino Emperador sey Roma,” kunda sikwana. “Nu kunnenoy,” kunni Jesus, “ino akweno Emperador, iyaꞌdayu sikwana, e ino akwa i Dios, iyaꞌdayu pay ki Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Naaffutira sino sinapiti Jesus e ammeran dama a balabaliyan, nu ammera lud sininak, se nakkaꞌbawira sino netabbangnga. ");
INSERT INTO gdg_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Agyangkappayino Saduceowera a inang ki Jesus. Ireno tata a buyuꞌna Judyu a massapit si ammena mangngangoliyeno natayira. Sinapiꞌda sikwana si, ");
INSERT INTO gdg_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“Afu mesturu, kunnino lintiddama neturakki Moises, ‘Nu wara matawa a awana abbinda e matayino lalaki, atawan naddino kolaꞌngeno balu takesi nu wara abbinda, antuneno guman abbingino natay.’ ");
INSERT INTO gdg_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Agyanino pituwera a makkakarolaka lallaki. Nangataweno palungura, udde nataya awana abbinda. ");
INSERT INTO gdg_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Antuweno inatawa kappayino metufad, udde natekappaya awana abbinda. ");
INSERT INTO gdg_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Kunna kappay sino mekatalluwa kolaꞌda, kiyad si nappatapataliyeno pituwera a nangatawa sino balu, udde natayira ammina awana abbinda. ");
INSERT INTO gdg_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Wasinoy, natekappayino bafay. ");
INSERT INTO gdg_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Kunnantu, naso awa pangngangoliyanino natayira, inyana sikwara a pituweno makwan atawa sinaya bafay? Se inatawara ammin.” ");
INSERT INTO gdg_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Sinombatanira i Jesus si, “Gakkuruwa mapparataweno tolayira sito lubag sito ingkein, ");
INSERT INTO gdg_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","udde bakkanna kunnenoy sey langit, se ino ibilangi Dios si meannunga mangngangoli anna mesapat sikwana sinay, ammeranna matatawa sinay, ");
INSERT INTO gdg_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","se kakunnaraneno anghelira a ammera matay si makkikiyad. Iraneno abbingi Dios se pangngangolinnerana. ");
INSERT INTO gdg_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","“Nu mappeafu kappay sino pangngangoliyanino natayira, massiki i Moises, taꞌdagganna si mangngangolineno matayira. Se ino neturaꞌnga mappeafu sino gumatagatangnga kayu, sapitanna si i Afu Diosino Dios da Abraham, Isaac, anni Jacob. Antuweno neturaꞌnga massiki nabayirana natay. ");
INSERT INTO gdg_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ino anggamma sapitan, mangngangoliyeno natayira, se i Dios, bakkanna Diosino natayira, nu ammena lurino aggabiyayira, se amminira a mangurug, aggabiyayira sikwana.” ");
INSERT INTO gdg_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wasinoy, sinapitino korwanira a mammesturuwerana lintig si, “Afu, nalawarino nesombaꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","E mangiyafu sinoy, awaninna naturira mabbebut sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Wasinoy, sinapiti Jesus sikwara si, “Mayan sapitanda si gaka i Ari David ino Kristo? ");
INSERT INTO gdg_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Se massiki i David, neturaꞌnga sino leburuna Salmo si, ‘Sinapiti Afu Dios ki Kristo a Afuk: Mattuttugga sito padiwanangku ");
INSERT INTO gdg_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","kiyad si affutangkuweno kalingam.’ ” ");
INSERT INTO gdg_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","E netuluyi Jesus a nassapit si, “Nu ingnganani David ino Kristo si Afuna a matturay sikwana, ansanda lang sapitan si gaka i David?” ");
INSERT INTO gdg_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Wasin aggadingngag amminino tolayira, sinapiti Jesus sino adalannera si, ");
INSERT INTO gdg_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Palanandawino mammesturuwerana lintig, se angganda a mabbarawasi si ataꞌnang anna nalawad takesi malasin si napatiyira, anna angganda kappaya medayawa mapakumusta sino mangita sikwara kadda mallakarira sino palengki. Pilinda kappaya pattutturanino attutturanna napatiya tolay sino sinagoga, e kunna kappay nu umangngira makipangngan, pilinda a pakitutturanino pangafuwanira. ");
INSERT INTO gdg_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Balabaliyandeno baluwera a bafabbay takesi appandeno kukwara andino bafalera, e makkararira si asodda kararag se angganda a kallabbanino narakkatta aggangwara. Nadammattingkeneno kastigura.” ");
INSERT INTO gdg_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Wasinoy, nallangalanga i Jesus, e initaneno bafaꞌnangngira a miittung si pirak sino aggiittungan si pirak sino Templo. ");
INSERT INTO gdg_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Initana kappayino tata a pobiriya baluwa niittung si adwa a sentabo. ");
INSERT INTO gdg_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","E sinapiti Jesus si, “Gakkurug yo sapitangku sikwayu, oodduweno neyittungino pobiriya balu amma sino neyittungino korwanira. ");
INSERT INTO gdg_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Se ino korwanira, neyaꞌdara pelangino sobraneno kinabaꞌnanda, udde ino balu, massiki pobiri, neyaꞌdana amminino kabiyayanna.” ");
INSERT INTO gdg_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Ino korwanira a adalanna, nattatarabbandeno kinalawarino Templo, se nadindingan si nalawara batu anna naartiyan sino korwana kaanggamma newaꞌlaꞌda ki Dios. E sinapiti Jesus si, ");
INSERT INTO gdg_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Madaꞌnganeno awa ammina maitayu sito Templo, madarallirana ammin, e awaningkena massiki tata a batuwa mabattang sino agyananna, se maduduwirana.” ");
INSERT INTO gdg_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Wasinoy, nabbebutino adalannera si, “Afu mesturu, naansaneno kakwannenaya sinapiꞌnu, anna sannaneno senyala pimunuwammi si araꞌniyenna makwa?” ");
INSERT INTO gdg_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","E sinabbira i Jesus si, “Palanandaw ta ammekayu mabalabaliyan. Se odduweraneno gumamwanga massapit si ira kanuweno Kristo anna kundana kappay si araꞌniyennino uddina aw. Udde ammeyuwera kuruwan. ");
INSERT INTO gdg_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Nu dingngaggandaw si ana gubat anna gulu, ammekayu mattalaw. Maawag si makwerana yaw, udde bakkangkepayino uddina aw.” ");
INSERT INTO gdg_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Netuluyna a nassapit si, “Maggagubaꞌneno naddadaruma a lulubbun, mampesino patturayandera. ");
INSERT INTO gdg_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Ana kappeneno natuyagga alunig, nafulota bisin, anna takita mamapatay si odduwa tolay si palulubbun. Ana kappeneno mepaita sey langita kattalatalawa senyal anna kakkaꞌbaw. ");
INSERT INTO gdg_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Udde liyeya makwenay, doꞌmandakayuna e ilopalopeꞌdakayu, idarundakayuna sino sinagoga e ibaluddakayu. Gafu sino angnguruddaw sikwak, iyaꞌlandakayu sino ariyera anda gubernadorira. ");
INSERT INTO gdg_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","E antuneno wayayuwa mituldu sino nalawara damag mappeafu sikwak. ");
INSERT INTO gdg_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Pattuyaggandawino nakandaw, e ammeyu paddararananino isombaꞌdona, ");
INSERT INTO gdg_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","se ikkanaꞌngeno mangaꞌda sikwayu sino fustuwa sapitandaw anna kinalainga amme dama a sombatanino kakontarayuwera. ");
INSERT INTO gdg_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Sinoy kappena a tiyempo, massiki ino mapparanaꞌdawira, ino kakkolaꞌdawira, ino wawwayiyuwera, andino bafulundawira, idarundakayuna sino turayira, e mapapateneno korwan sikwayu. ");
INSERT INTO gdg_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Ammina tolay, kababannaddakayuna gafu sino kesapatandaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Udde ino kakuruwanna, awana maawan si massiki tata pelanga abuꞌdaw nu bakkanna urayi Dios. ");
INSERT INTO gdg_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","E nu mattalaginaggayuwa mangurug sikwak massiki madyatangkayu, maaꞌdangkayu si biyaya mannayun.” ");
INSERT INTO gdg_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Sinapikkappayi Jesus si, “Nu itandona si odduwa sindaluwa mabbalikungkung sey Jerusalem, antuwenneno pangammuwandaw si araꞌniyennino kadarallanna. ");
INSERT INTO gdg_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Nu maitayunnenay, ino magyanira sey Judea, mabbukalira nadda umang sino kakuluran. Ino anera sey Jerusalem, mabbakwetira nad, e ino anera sino agguman, ammera nad umapit sino lubbun. ");
INSERT INTO gdg_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Se antuwenneno tiyempowa pangastiguwana keyakkuruwanino ammina nepeturakki Dios siꞌin. ");
INSERT INTO gdg_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Sinoyna a tiyempo, kakallaꞌngeno mabussitira andino mappasusuwera. Se madyataningkeneno tolayira sitawa lubbun sinoya tiyempo, se antuweno pangastiguwani Dios sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ino korwanira, matayirana si gubat, e ino korwanira kappay, appanderana e iyandera si aroyuwa lubbun ta paripandera. E ino lubbuna Jerusalem, affutanneno bakkannira a Judyu, e iranneno matturay kiyad si palammattannira i Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Ananeno senyala maita sino sinag, dakkag, anda sino bitunira a kattalatalawingke. E amminneno tolayira sito lubag, makadaradararanirana e nappelaloꞌneno talora sino natuyagga ungungngeno palungira sino bebay. ");
INSERT INTO gdg_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Maffunawirana sino talora a aggadandam sino kattalatalawa makwa sito lubag, se makungkul ammina maita sey langit. ");
INSERT INTO gdg_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","E itandaꞌnga a Abbingnga Tolaya muliya mebulun si dulam, e maitaneno pannakadamak andino kinadiosku. ");
INSERT INTO gdg_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Antu gafuna, nu mangiyafunenaya makwa, maanggangkayu nadda minnanama sino puliyangku. Pattuyaggandonaddino nakandaw, se araꞌniyennino kesalakandaw.” ");
INSERT INTO gdg_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Wasinoy, niyampariyi Jesus si, “Dandammandonaddino kayuwa igos andino korwanira a kayu. ");
INSERT INTO gdg_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Nu mallalimuddutira, ammuyun si araꞌniyenna maddawun. ");
INSERT INTO gdg_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Kunna kappay, nu itandawa makwenaya sinapikku, ammuyun si araꞌniyennino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“Gakkurug yo sapitangku sikwayu, ananeno korwanira a tolaya aggabiyag sito ingkeina ammera matay liyeya meyakkurug amminino sinapikku. ");
INSERT INTO gdg_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Maawanneno langit anyo lubag, udde ammenana maawanino sapikku si makkikiyad, nu ammena lud meyakkurug ammin.” ");
INSERT INTO gdg_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Netuluyi Jesus a nassapit si, “Mappalangkayu takesi ammeyu aggadandammannino pallanggakandaw andino parinumandaw, anna mappalangkayu kappay takesi ammeyu paddararananino awandaw sito lubag. Se nu kunnenoyino akwandaw, malaꞌgakkayuna sino puliyangku. ");
INSERT INTO gdg_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Se kakaꞌmana pelangino puliyangku, e malaꞌgaꞌna ammina tolay si palulubbun sito lubag a kakunnaraneno mammanuka makanna si silu. ");
INSERT INTO gdg_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Kunnantu, kanayungkayu nadda maddadan, e makkararaggayu takesi pattuyagganni Diosino angnguruddaw takesi damayuwa iyattammino ammina makwa sikwayu, e maanggangkayuna a umaꞌlang sikwaka Abbingnga Tolay.” ");
INSERT INTO gdg_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Sinoya tiyempo, kadda awa manulduwi Jesus sino Templo e kadda gafi, umang magyan sino kulura Olivo. ");
INSERT INTO gdg_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Antu gafuna, maggiꞌbattino tolayira a umang sino Templo ta dingngaggandeno tulduna. ");
INSERT INTO gdg_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Araꞌniyenna gumamwangino fiyestana Judyu a mingngan si Laꞌwutana pangngananda si tinapaya awana lebadurana. ");
INSERT INTO gdg_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","E ino pangafuwanirana padi andino mammesturuwerana lintig, iniintufuꞌda nu ansandeno mamapatay ki Jesus a ammena maammuwan, se mattalawira sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Wasinoy, nunaggi Satanas ki Judas Iscariote a tata sino karadwera a adalani Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","E inang sino pangafuwanirana padi andino afafuweno mindaggira sino Templo ta makitulag sikwara nu sanneno akwanna ta meyalawaꞌna i Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Maanggammirangke, e nekarira si aꞌdanda si pirak. ");
INSERT INTO gdg_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Inanggammani Judas, e neyafunana mintufuk si akwanna a mallaku ki Jesus a amme maammuwanino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Nadaꞌngennino awna fiyesta a mingngan si Tinapaya Awana Lebadurana, a antuweno pamartiyanda si ubbunna karnero para sino fiyesta a mingngan si Laꞌwutan. ");
INSERT INTO gdg_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Antuweno dinunduni Jesus da Pedro anni Juan e sinapiꞌna si, “Umandaw idadanino akkanantam sino fiyesta.” ");
INSERT INTO gdg_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“Sintawino anggammu si pidadanammi?” kunda. ");
INSERT INTO gdg_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","E sinapiꞌna si, “Umangkayu sey Jerusalem. Nu gumamwangkayu sinay, ananeno madambaldawa lalakiya inang nanab. Dandanandona sino balaya umangnganna, ");
INSERT INTO gdg_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","e sapitandaw sino makwan balay si, ‘Kunnino Afumi, sintawino kwartuwa pakipangnganammi andino adalangkuwera sino fiyestana Laꞌwutan?’ ");
INSERT INTO gdg_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Ipaitanana sikwayuweno nangkalekaya dokalla kwartuwa anen amminino maawaddam. Sinayino pidadanandaw sino pamuwaddam sino fiyesta.” ");
INSERT INTO gdg_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Wasinoy, inangngira a adwa e nesaꞌbalda gakkuruwino sinapiti Jesus sikwara. E nedadandeno akkananda para sino fiyesta. ");
INSERT INTO gdg_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Wasin nadaꞌngeno fustuwa orat, nakitutturi Jesus sino apostolnera a mangngan. ");
INSERT INTO gdg_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Sinapiꞌna sikwara si, “Maanggammakungke a makiaꞌlang sikwayuwa mangngan sito fiyestana Laꞌwutan, liyeka madyatan. ");
INSERT INTO gdg_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Se sapitangku sikwayu si ammek kappay mangngan si kunnayawa fiyesta kiyad si meyakkuruwino keyampariyanna sino patturayani Dios sey langit.” ");
INSERT INTO gdg_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wasinoy, nangappa i Jesus si kopa a napannu si diyuna ubas e nappasalamat ki Dios, kasena sinapit si, “Appandaw yaw ta minungkayu. ");
INSERT INTO gdg_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Se gakkurug yo sapitangku sikwayu, mangiyafu sito ingkein, ammekunna minum si diyuna ubas kiyad si gumamwangino patturayani Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Wasinoy, nappa si tinapay e nappasalamat ki Dios, kasena ginaradwa e neyaꞌdana sikwara a nassapit si, “Antuyawino baggika mewaꞌlat para sikwayu. Kunnanayawino akwandaw takesi panandandaw sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Wasin nasinduwera a nangngan, kunna kappayino inangwana sino kopa a inappana e sinapiꞌna si, “Iyawa inuman, antuweno mangipaita sino bawuwa tulagi Dios sino tolayira. Ino kebubbuwanneno adak sino katayangku, antuneno keyakkuruwan inaya bawuwa tulag. ");
INSERT INTO gdg_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Udde sapitangku kappay sikwayu si ino mallakuna sikwak, ana sikwatama nakikkan. ");
INSERT INTO gdg_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Se ikkanak Abbingnga Tolay, gakkuruwa matayak takesi meyakkuruwino nepeturakki Dios siꞌin, udde kakallappeneno mallaku sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","E nakkakibikibebutira nu inya sikwareno mangwa sinay. ");
INSERT INTO gdg_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Wasinoy, nassasarombatino adalanira i Jesus nu inya sikwareno kapatiyan. ");
INSERT INTO gdg_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Sinapiti Jesus sikwara si, “Ino ariyera andino korwanira a matturay sito lubag, ipatuꞌdeno panggammanda sino iturayanda, gampade angganda kepaya maingnganan si Minadduffun. ");
INSERT INTO gdg_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Udde bakkan nadda kunnenoy sikwayu, nu ammena lud, ino kapatiyan sikwayu, ibilangnga naddino baggina si kunnangke antuweno kauddiyan, e ino palungu sikwayu, paaripanna naddino baggina sikwayu ammin. ");
INSERT INTO gdg_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Inyeno mas napatig, ino mattuttura mangngan onnu ino masserbi sikwana? Bakkangkaddino passerbiyanneno napatig? Udde sitoya, ayawaka afuyuwa masserbi sikwayuwa kunnangke aripan. ");
INSERT INTO gdg_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ikkayuweno nakilawum sino ammina dyakku e ammerak inanawan, ");
INSERT INTO gdg_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","e ino neyaꞌda i Ama sikwak, kunna kappeneno iyaꞌdak sikwayu, se neyaꞌdana sikwakino kalintiyangkuwa matturay, e antu kappayino akwangku sikwayu ");
INSERT INTO gdg_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","takesi makipangngangkayuna sikwak sino patturayangku anna mattuttuggayu kappay si tronowa makituray sikwak sino gakagakeno karadwera a abbingi Israel.” ");
INSERT INTO gdg_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Wasinoy, sinapiti Jesus ki Pedro si, “Simon, dingngaggannu yo sapitangku. Inarangngi Satanas si murenadda manalodaw sikwayu ammin takesi itanna nu wara mekatway sikwayu a kunnangke sissika mekatway sino baggaꞌna nu meittap. ");
INSERT INTO gdg_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Udde nekararantaka, Simon, takesi ammem ibbattanino angngurungngu sikwak, e nanu mabbobolika, maawag si pattuyaggannuweno angngurungngeno bafulunnuwera.” ");
INSERT INTO gdg_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","E sinapiti Pedro si, “Afu, naddadanakun e massiki nu mabaluraꞌnga onnu matayak, ammetaka anawan.” ");
INSERT INTO gdg_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","“Kunnenayino sapitannu,” sinapiti Jesus, “udde ino kakuruwanna, Pedro, liyeya massirallotino lalung nu gigiꞌbat, namiꞌluwannakunna neimad.” ");
INSERT INTO gdg_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Wasinoy, sinapiti Jesus sikwara si, “Sin dinunduntakayuwa awana neyangkalindaw si pirak, pasiking, anna pamataliyan si sapatut, nakurangangkayu sino awandaw?” “Awan,” kunda. ");
INSERT INTO gdg_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","“Udde sitoya, tangananin,” kunni Jesus. “Ino ana pirak anna pasikingnga, iyangkalinna nad. Ino awana saseꞌna, maggatangngad, massiki nu ilakuneno tafalna ta wara iyatangnga. ");
INSERT INTO gdg_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Se meyakkuruwin sikwakino neturakka sapiti Dios a kunna si, ‘Nebilang si tulisan.’ Sitoya, araꞌniyenna meyakkurug amminino neturakkino gumalabbunira mappeafu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","“Afu, ayaw sitawino adwa a saset,” netabbadda. “Kundenin,” kunna sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Wasinoy, nanora Jesus andino adalannera sey Jerusalem, e inangngira sino kulura Olivo, se antuweno aꞌangnganda kadda gafi. ");
INSERT INTO gdg_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Wasin ginamwangira sinay, sinapiꞌna sikwara si, “Makkararaggayu takesi ammekayu matutunggungan.” ");
INSERT INTO gdg_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","E inaroyuwannera si bisang, e namalitura makkararag. ");
INSERT INTO gdg_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“Ama,” kunna, “nu antuweno anggammu, ammem iyakkurug iyawa dyata araꞌniyenna makwa sikwak. Udde bakkan naddino panggammangkuweno makwa, nu ammena lurino panggammannu.” ");
INSERT INTO gdg_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","E nappadda sikwaneno anghela naggabwat sey langita nappatuyag sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Gafu se malowingke ino nakamma, ginakkurungngangke ino nakkararag, e ino lingaꞌna, mammapattak sino lubag a kunnangke ada. ");
INSERT INTO gdg_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Wasin nasinduwenna nakkararag, nuli sino agyananino adalannera, e dinaꞌnganera a maturug, se naayangngira gafu sino nappelalota loneno nakanda. ");
INSERT INTO gdg_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","E sinapiꞌna si, “Mayan maturuggayu? Mafakkayu ta makkararaggayu takesi ammekayu matutunggungan.” ");
INSERT INTO gdg_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Wasin aggedamadamikkepayi Jesus, ginamwangino odduwera a tolaya nefuyuti Judas a tata sino karadwera a adalanna. Inaraꞌni ki Jesus takesi ummanna, ");
INSERT INTO gdg_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","udde sinapiti Jesus si, “Judas, mayan pabbalinnuweno umma a senyalneno agganggam si senyalneno pallakuwannu sikwaka Abbingnga Tolay?” ");
INSERT INTO gdg_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Wasin initeno adalanira i Jesusino nakwa sikwana, sinapiꞌda si, “Afu, makipatekami?” ");
INSERT INTO gdg_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","E binakino tata a adalanneno aripannino afafuna padi e nagingaranino diwanana layangnga. ");
INSERT INTO gdg_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Udde sinapiti Jesus si, “Kundenin!” E inappanganneno layino aripan e nabbattunoy. ");
INSERT INTO gdg_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Wasinoy, sinapiꞌna sino pangafuwanirana padi, ino afafuweno mindaggira sino Templo, andino korwanira a pangafuwana inang nanoꞌma sikwana si, “Ma, tulisanak ta nassisasekkayu anna nassibafaꞌgunga umang sitaw? ");
INSERT INTO gdg_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Mayan ammerak dinoꞌman sino Templo a kadda awkena a nagyanak sinaya manuldu sikwayu? Udde sitawa gafi, nepurerakayuwi Dios a mangwa sino anggandaw e nawayanino matturay sino lammuk.” ");
INSERT INTO gdg_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Wasinoy, dinoꞌmanda i Jesus e neyanda sino balayino afafuna padi. I Pedro, dumadandan sino gafanda. ");
INSERT INTO gdg_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Udde wasin nafuyino tolayira sino kalawatannenaya balay ta maggarenuwera, inangngi Pedro a nakigarenu sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Initeno tata a aripanna balatang se nasirwatan sino afuy, sinulangnganna, e sinapiꞌna si, “Iyana tolay, tata a buluni Jesus.” ");
INSERT INTO gdg_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Udde neimaddi Pedro e sinapiꞌna si, “Ammek inammu inaya tolay.” ");
INSERT INTO gdg_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ammena nabayag, agyangkappayino tata a lalakiya nimunu sikwana, e sinapiꞌna si, “Ikkeno tata sikwara.” Udde sinapiti Pedro si, “Bakkan.” ");
INSERT INTO gdg_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Wasin taorattin, agyangkappayino tata a lalakiya nipatuta nassapit si, “Gakkuruwa bulundaka i Jesus, se taga-Galileaka kappay.” ");
INSERT INTO gdg_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","“Ammek ammu yan sapitandaw,” netabbi Pedro. Wasin aggedamadamikkepay, nassirallotinnino lalung. ");
INSERT INTO gdg_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","E nallangngiyi Afu Jesus e sinulangnganna i Pedro. Wasinoy, dinandammi Pedroweno sinapiti Afu Jesus sikwana a liyeya massirallotino lalung sinaya aw, namiꞌluwannanna a neimad. ");
INSERT INTO gdg_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","E inanaw e nakatangatangit. ");
INSERT INTO gdg_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ino mindaggira ki Jesus, inaꞌayoyunganda anna sinapatampalanda. ");
INSERT INTO gdg_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Inammuꞌdeno matana, kasera sinapit si, “Sapitannu nu inyeno nanultuk sikwam.” ");
INSERT INTO gdg_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","E oddu kappayino sinapasapiꞌda a mangayoyung anna mikakkatawa sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Wasin sumiltakinni sinag, neyanda i Jesus sino agyananino nakkakarampattira a pangafuwanna padi, mammesturuwerana lintig, anna korwana pangafuwanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Sinapiꞌda sikwana si, “Ituldum nu ikkeno Kristo.” Sinabbira i Jesus si, “Massiki nu itulduk, ammeyu kappay kuruwan, ");
INSERT INTO gdg_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","e nu wara bebutangku sikwayu, ammeyu kappay sombatan. ");
INSERT INTO gdg_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Udde mangiyafu sito ingkein, ikkanaka Abbingnga Tolay, mattutturak sino padiwanani Dios a mannakadama.” ");
INSERT INTO gdg_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","E nebebuꞌda kappay si, “Nu kunnenoy, Abbindaka mantuwi Dios?” “Nu antuweno sapitandaw, antu,” kunna. ");
INSERT INTO gdg_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","E sinapiꞌda si, “Sanna kepayino awantama manistigu? Se ikkanetamungkepayino naningngag sino sinapiꞌna.” ");
INSERT INTO gdg_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wasinoy, nattaꞌdaggira ammin e neyanda i Jesus ki Gubernador Pilato. Wasin ginamwangira sinay, ");
INSERT INTO gdg_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","sinapiꞌdeno liwaꞌna. Kunda si, “Dinoꞌmammi yawa tolaya maggulu sino kalubbunammiyera a Judyu. Sapitanna kappay si ammera nad paganino buwit sino Emperador, e kunna kappay si antuweno Kristo a nekariyi Dios a matturena sikwami.” ");
INSERT INTO gdg_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Antuweno nebebuti Pilato ki Jesus si, “Ikkeno Arina Judyu?” “Nu antuweno sapitannu, antu,” nesombati Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","E sinapiti Pilato sino pangafuwanirana padi andino korwanira a tolay si, “Awana naammuwangku si liwaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Udde nepatuꞌda a nassapit si, “Gafu sino itulduna, nagulugulu ammina tolay, mangiyafu sino probinsiya a Galilea makkiyad sito Judea, e sitoya ginamwangin sitaw.” ");
INSERT INTO gdg_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Wasin diningngaggi Pilato inay, nebebuꞌna nu taga-Galilea i Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Wasin naammuwanna si naggabwati Jesus sey Galilea a patturayani Herodes, nepeyangnga i Jesus sikwana, se agyani Herodes sey Jerusalem sinoya tiyempo. ");
INSERT INTO gdg_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Maanggammingke i Herodes sin initana i Jesus, se nabayinna diningngangngeno mappeafu sikwana, e anggamma mita sino kakkaꞌbawa akwanna. ");
INSERT INTO gdg_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Antu gafuna, odduweno nebebuꞌna sikwana, udde amme pelang sinombatani Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Ino pangafuwanirana padi andino mammesturuwerana lintig, nantatuyaggira a nappaliwat sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","E nakipakkatawa anna nakiayoyungi Herodes sino sindalunera ki Jesus. Binarawasiyanda si ataꞌnanga nalawaringke a kunnangke barawasina ari, kasena nepeyuli ki Pilato. ");
INSERT INTO gdg_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Nangiyafu sinoya aw, nalawarinnino abbulunda Herodes anni Pilato, se gagangaya makkontarera siꞌin. ");
INSERT INTO gdg_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Wasinoy, nepaayi Pilatoweno pangafuwanirana padi andino korwanira a afafuna Judyu andino korwanira a tolay, ");
INSERT INTO gdg_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","e sinapiꞌna sikwara si, “Nedarundaw yawa tolay sikwaka sapitandaw si gulugulunneno tolayira ta kumontarera sino gubiyernu. Udde sitoya, inimbistigarku sino naraꞌlangandaw e awana naammuwangku si pamakurug sino nepaliwaꞌdaw sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Massiki i Herodes kappay, awana naammuwanna si liwaꞌna, antuweno nepeyulina sikwak. Awaningke a inangwana yawa tolaya meannunga ipatena. ");
INSERT INTO gdg_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Antuweno ipasiwaꞌwakku pelang, kasek palawanan.” ");
INSERT INTO gdg_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Ino nassapitanna sinay, se maawa mipalawan si tata a balud kadda fiyestana Laꞌwutan, se antuweno gagangena. ");
INSERT INTO gdg_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Udde ino tolayira sinay, naggagarindanira a nikulawu si, “Papatayannu! I Barrabasino ilawannu!” ");
INSERT INTO gdg_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","(Inaya Barrabas, nebalud se ginuluneno tolayira sey Jerusalem ta kontarandeno gubiyernu, e ana kappayino pinapatena.) ");
INSERT INTO gdg_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Udde i Pilato, anggamma si i Jesusino ilawanna, antuweno nakitatabbaggappay sino tolayira, ");
INSERT INTO gdg_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","udde nekulakulawura si, “Ilansam! Ilansam si krus!” ");
INSERT INTO gdg_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Nepiꞌlu kappayi Pilato a nakitatabbag sikwara, e sinapiꞌna si, “Sanna maꞌlurino liwaꞌna? Awana ammuk si inangwana a paggafuwanneno katayanna. Massiki ipasiwaꞌwakku pelang ta pelawangku.” ");
INSERT INTO gdg_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Udde nangkakulawuwera a mipatut si melansa i Jesus si krus kiyad si inaffuꞌda i Pilato, ");
INSERT INTO gdg_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","e neonnampelangino angganda. ");
INSERT INTO gdg_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Nepelawanneno angganda si ilawanna a antuweno nabalud gafu sino nagguluwanna annino namapatayanna, e neyalawaꞌna i Jesus sikwara takesi akwandeno angganda a akwan sikwana. ");
INSERT INTO gdg_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Wasinoy, neyanawino sindaluwera i Jesus ta umanda ilansa si krus. Wasin agyanira kepay sino dalan, nadambaldeno tata a lalakiya i Simon a taga-Cirene a umang sey Jerusalem a naggabwat sino agguman. Dinoꞌmanda e nepatuꞌda a nepabuttungino krus, kasera nepadandan ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Oddu kappayino tolayira a dinandan ki Jesus, e agyangkappayino bafabbayira a mattatarangit gafu sino loneno nakanda. ");
INSERT INTO gdg_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ilangngiyera i Jesus e sinapiꞌna si, “Ikkayuwa bafabbaya taga-Jerusalem, bakkan nadda ikkanakino tangitandaw, nu ammena lurino baggiyungkepay andino anaꞌdawira. ");
INSERT INTO gdg_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Se nappelaloꞌneno dyat sitawa lubbun kiyad si sapitanneno tolayira si, ‘Nagasatino bafabbayira a ammera nanak anna ammera nappasusu.’ ");
INSERT INTO gdg_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Gafu sinaya dyaꞌda, arangnganneno tolayira si maddabbakino kulurira ta matabbunanira. ");
INSERT INTO gdg_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Se nu kunnayawino akwanda sikwaka awana liwakku, sannadeno makwa sikwayuwa minalliwat? Se nu sikkulandeno nabiyaya kayu, mannanotinna sino nagabba e naganguwen.” ");
INSERT INTO gdg_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Agyangkappayino adwera a tulisana nebulunda ki Jesus a umanda papatayan. ");
INSERT INTO gdg_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Wasin ginamwangira sino ingngananda si Takataꞌnga Ulu, nelansara i Jesus sino krus. Inayira a adwa a tulisan, nelansarera kappay si korwana krus, tata sino padiwanani Jesus, e tata sino padawina. ");
INSERT INTO gdg_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","E sinapiti Jesus si, “Ama, pakomannuwera, se ammera ammuweno akwanda.” Ino sindaluwera, nabbabinnunutanda nu ansandeno maggaradwa sino barawasiyera i Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ino pay tolayira, aggataꞌdaggira a mabbuya. Ino afafuwerana Judyu, nangayoyungira a massapit si, “Nesalaꞌngeno korwana tolay. Isalaꞌnga nad antuweno bagginangkepay, nu gakkuruwa antuweno Kristo a piniliyi Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Inayoyungangkappayino sindaluwera. Inaraꞌniyanda ta iduwawanda si kilam, ");
INSERT INTO gdg_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","e sinapiꞌda si, “Nu gakkuruwa ikkeno Arina Judyu, isalaꞌngu mantu yan baggim.” ");
INSERT INTO gdg_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Ana maꞌlurino neturakka nepikkaꞌda sino batuwi Jesus a kunna si, “Antuyawino Arina Judyu.” ");
INSERT INTO gdg_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Massiki ino tata tulisana nekrusda, inayoyunganna kappayi Jesus a nassapit si, “Bakkangkadda ikkeno Kristo? Isalaꞌngu mantuweno baggim anna ikkami pay!” ");
INSERT INTO gdg_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Udde ino bulunna a tulisana nekrus, inallangnganna a nassapit si, “Ma, ammeka mattalaw ki Dios? Nakkakarunnetama nasentensiyana matay, ");
INSERT INTO gdg_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","udde ikkaneta, fustuweno kastiguta se antuweno salinunuꞌneno liwatta, udde sikwana, awana liwaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","E sinapiꞌna ki Jesus si, “Afu Jesus, dandammannaꞌnga nu mulika a matturay.” ");
INSERT INTO gdg_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","E sinapiti Jesus sikwana si, “Gakkurug yo sapitangku sikwam. Sitawa aw, mebulungkan sikwak sey langit.” ");
INSERT INTO gdg_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","Wasin araꞌniyen si alas dose, kakaꞌmeng kelanga naddukiꞌlap, e nallammuk si palulubbun kiyad si alas tres. ");
INSERT INTO gdg_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","E neyindana napissayino kortinaneno Templo e nagadwa. ");
INSERT INTO gdg_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Nekokwa i Jesus a naddamit e sinapiꞌna si, “Ama, italakkuweno kararuwak sikwam.” Wasin sinapiꞌnenay, natayin. ");
INSERT INTO gdg_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Wasin initeno kapitanna sindaluwenaya nakwa, dinayona i Dios a nassapit si, “Gakkuruwa awana liwaꞌna yawa tolay!” ");
INSERT INTO gdg_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Ino kappay tolayira a aggataꞌdag sinaya mabbuya, initara kappayino nakwa, e inanawira a totottofandeno taꞌganda gafu sino loneno nakanda. ");
INSERT INTO gdg_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Udde amminino bafulunira i Jesus andino bafabbayira a nebulun sikwana a naggabwat sey Galilea, nagyanira sino aroyu e initareno nakwa. ");
INSERT INTO gdg_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Agyanino lalakiya mingngan si Jose a taga-Arimatea a tata lubbun sino probinsiya a Judea. Nalawad anna naggaddangnga tolay a aggataron sino gumamwanganino patturayani Dios. Massiki tata a pangafuwanna Judyu, ammena anggammino planowino bafulunnera andino inangwara ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Inangngi Jose ki Pilato a narang sino baggiyi Jesus, ");
INSERT INTO gdg_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","kasena inang neyulluwino baggina sino krus e binaꞌbattanna si nafurawa sinnun. Neyekwana sino tanamma neyabbut si batuwa kunnangke agwefa ammena kepay neusar. ");
INSERT INTO gdg_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Wasin pangwanna sinay, araꞌniyenna mangiyafuweno awna aggimwangan, se fuwamma Biyernes a awa pidadananino Judyuwera sino awanda sino awna aggimwangan. ");
INSERT INTO gdg_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ino bafabbayira a nebulun ki Jesus a naggabwat sey Galilea, dinandananda i Jose e initareno agyananneno tanam andino niyekwani Jose sino baggiyi Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Wasinoy, nanawira ta umanda idadanino lana anna bambanguwa iyekwarana sino baggina. Udde sino kadaramaꞌna a awna aggimwangan, nagyanira sino balera a mimwang, se antuweno lintiyino Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Wasi awna Linggu, naggiꞌbattino bafabbayira a inang sino tanammi Jesus e neyangkalindeno bambanguwa nedadanda. ");
INSERT INTO gdg_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Wasin ginamwangira sinay, initara si naariyennino batuwa aggakuꞌneno tanam, ");
INSERT INTO gdg_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","e sinallungira, udde ammera nadaꞌngeno baggiyi Afu Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Nakungkulino nakanda a maddandam sinaya nakwa. Kakaꞌmeng kelanga nappaddeno adwera a lallakiya mangngilikilitino barawasira a nakitaꞌdag sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Nokabbino bafabbayira gafu sino nappelalota talora, udde sinapitino lallakiyera sikwara si, “Mayan tufukandawino nabiyag sino agyananino natay? ");
INSERT INTO gdg_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Awaninni Jesus sitaw, se nangngangoliyen. Ma, nakalyawandawino sinapiꞌna sikwayu sin nagyanandaw sey Galilea ");
INSERT INTO gdg_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","a maawag si meyalawatino Abbingnga Tolay sino minalliwatira ta ilansara sino krus, udde mangngangolina sino mekatalluwa aw?” ");
INSERT INTO gdg_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","E nadandandeno sinapiti Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Wasin nuliyera, sinapiꞌda sino karattaddayira a adalani Jesus andino bafulundereno nakwa. ");
INSERT INTO gdg_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Inayira a bafabbay, da Maria Magdalena, i Juana, anni Maria a ina i Santiago, e ana kappay korwanira a bulunda. Ireno inang nituldu sino apostolira sino nakwa, ");
INSERT INTO gdg_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","udde amme kinuruwino apostolireno sinapiꞌda, se aridda si sinenaꞌda pelang. ");
INSERT INTO gdg_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Udde i Pedro, nalayawa inang sino agyananino tanam. Wasin ginamwang sinay, inokabba nisirib sino dolammeno tanam, udde awana initana, ino pelang sinnuna nepamaꞌbaꞌda. E inanawa aggadandam nu sanneno nakwa sino baggiyi Jesus. ");
INSERT INTO gdg_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Sinoy kappaya aw, agyanino adwera a nebulun ki Jesus siꞌina umang sey Emaus a nasuruk si karattaddaya kilometroweno kaaroyuna sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Wasin aggelakalakarira, pattatabbandeno ammina nakwa. ");
INSERT INTO gdg_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Wasin aggetatabbira kepay, inaraꞌniyi Jesus e nebulun sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Udde massiki initara, ammera naimunuwan, se kunnangke wara nallefang sino matara. ");
INSERT INTO gdg_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Sinapiti Jesus sikwara si, “Sanneno pattatabbandoya?” Nitturira, e maitengke si malowino nakanda. ");
INSERT INTO gdg_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","E sinapitino tata sikwara a i Cleopas si, “Ikka pelang nakuyino magyan sey Jerusalem a ammena kepay nangammu sino nakwa sinay sino nallaꞌwuta aw.” ");
INSERT INTO gdg_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","“Sanneno nakwa?” kunni Jesus. “Ino nakwa ki Jesus a taga-Nazaret,” nesombaꞌda. “Tata a gumalabbun, e maita si anggammanni Dios gafu sino pannakadamana a manuldu anna mangwa si kakkaꞌbaw, e anggammangkappayino tolayira. ");
INSERT INTO gdg_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Udde ino pangafuwanirana padi andino matturayira sikwatam, neyalawaꞌda sino gubernador ta masentensiyana matay, e nelansara sino krus. ");
INSERT INTO gdg_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Antuweno ininnanamamiya misalaꞌngad sikwatama gakagaka i Israel. E sitoya, mekatalluwa awin kiyad sin nakwannenay. ");
INSERT INTO gdg_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ino kappay tata, nakkaꞌbokami sino sinapitino korwanira a bulummiya bafabbay. Naggiꞌbattira a inang sino tanamma, ");
INSERT INTO gdg_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","udde ammera kanu nadaꞌngeno baggina. E nuliyera a massapit si ana kanuweno nappadda a anghel sikwara a nituldu si nangngangoliyen. ");
INSERT INTO gdg_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Inang kappayino korwanira a bulummi sino tanam e gakkuruwino sinapitino bafabbayira, se ammera kappay inita i Jesus.” ");
INSERT INTO gdg_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wasinoy, sinapiti Jesus sikwara si, “Ikkayuwa kurangino annandamma! Mayan madyata kuruwandawino ammina sinapitino gumalabbunira? ");
INSERT INTO gdg_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Maawatandonad si maawa madyatanino Kristo, kasena medayaw.” ");
INSERT INTO gdg_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","E nepakaawati Jesus sikwareno anggamma sapitan amminino neturakka sapiti Dios mappeafu sikwana, mangiyafu sino palunguwera a neturakki Moises kiyad sino ammina neturakkino gumalabbunira. ");
INSERT INTO gdg_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Wasin araꞌniyeran sino lubbuna umangnganda, ituluy kepenaddi Jesus a mallakad, ");
INSERT INTO gdg_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","udde sinawiranda, e sinapiꞌda sikwana si, “Middetamun sitaw, se gafenin.” Antuweno inang sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Wasin mangnganiran, nappa i Jesus si tinapay e nappasalamat ki Dios, kasena ginaradwa e neyaꞌdana sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","E kunnangke naariyennino nallefang sino matara e naimunuwandan, udde kakaꞌmeng kelanga naawan. ");
INSERT INTO gdg_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","E nakkakibikibebutira si, “Antu kappay, se nallawarino nakanta sin agyanantam sey dalan sin pitulduwanna sikwata sino neturakka sapiti Dios.” ");
INSERT INTO gdg_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Ginikkatiran e nuliyera sey Jerusalem. Dinaꞌngareno karattaddayira a adalanna andino korwanira a nakkakarampat sinay. ");
INSERT INTO gdg_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Sinapitino adalanira si, “Gakkuruwa nangngangoliyi Afu Jesus, se nappadda ki Simon!” ");
INSERT INTO gdg_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","E sinapippayino adwereno nakwa sikwara sino dalan annino nimunuwanda ki Jesus sin naggaradwanna sino tinapay. ");
INSERT INTO gdg_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Wasin aggedamadamikkepayino adwera, kakaꞌmeng kelanga nappadda i Jesus sino naraꞌlanganda. “Nasiyanaꞌngaddino nakandaw,” kunna sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Udde nalaꞌgatira e nakatalawirangke, se aridda si baniyino initara. ");
INSERT INTO gdg_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Antuweno nassapitanna sikwara si, “Mayan nakatalokayu? Mayan maddaladudwakayu si gakkuruwa nangngangoliyak? ");
INSERT INTO gdg_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Itandaw yo kamakku anda yo takkik ta kuruwandaw si gakkuruwa ikkanak. Gafutandak ta manguruggayu. Se ino banig, awana baggi anna tulangnga, gampade ana sikwak, e damayuwa itan.” ");
INSERT INTO gdg_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Wasin sinapiꞌnenay, nepaitana sikwareno kamaꞌna andino takkina. ");
INSERT INTO gdg_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Udde ammera kepay kinurug gafu se nappelalotino kaꞌbora andino aangganda, antuweno sinapikkappayi Jesus sikwara si, “Wara maakkan sitan?” ");
INSERT INTO gdg_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Inaꞌdanda si sinunuwa lamis, ");
INSERT INTO gdg_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","e nakkanna sino aꞌlanda. ");
INSERT INTO gdg_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Wasinoy, sinapiꞌna sikwara si, “Inayira a nakwa, ireno sinapikku sikwayu sin nagyanangku kepay sikwayu siꞌin, a maawag si meyakkurug amminino neturakki Moises andino gumalabbunira andino ana sino leburuwa Salmo mappeafu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","E winaldanneno nakanda takesi maawatandeno neturakka sapiti Dios, ");
INSERT INTO gdg_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","e sinapiꞌna sikwara si, “Kunnayawino neturak mappeafu sikwak. Maawag si madyatan anna matayino Kristo, kasena mangngangoli sino mekatalluwa aw. ");
INSERT INTO gdg_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Maawaggappay si mebanyag si ammina lubbun sito lubagga mangiyafu sito Jerusalem si pakomani Diosino liwatino tolayira a mabboboli sino liwaꞌdera gafu sino angngurudda sikwak. ");
INSERT INTO gdg_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Ikkayuneno manaꞌdag si gakkuruwa nakwa sikwak ammin inaya neturak. ");
INSERT INTO gdg_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Dundunangkuna sikwayuweno Espirituwi Dios a nekariyi Amak. Mattarongkayu sito Jerusalem kiyad si meyaꞌda sikwayuweno pannakadama a maggabwat sey langit.” ");
INSERT INTO gdg_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Wasinoy, nefuyuꞌnera sey Betania. Wasin ginamwangira sinay, netayangngeno kamaꞌna a mamindisiyon sikwara. ");
INSERT INTO gdg_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Wasin aggebibindisiyonannera kepay, inanawannera se netulluwen sey langit. ");
INSERT INTO gdg_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","E naddayawira sikwana, kasera nuli sey Jerusalem a nappelalotino aangganda. ");
INSERT INTO gdg_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","E kanayunirana maꞌang sino Templo a maddayaw ki Dios.");
INSERT INTO gdg_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Sin liyeya naparatu yo lubag, anennino naingnganan si Sapita mangipakaammu ki Dios. Iyawa Sapit, nekanayun ki Dios, se antu, Dios kappepay. ");
INSERT INTO gdg_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Anen inaya Sapit ki Dios sin awangkepaya naparatu. ");
INSERT INTO gdg_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Antuweno nepamaratuwi Dios si ammin, e awaningke a naparatu, nu bakkanna gafu sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","E antu kappayino paggabwatanino biyangnga amammina meyamparig si sirwata mawwaldag sino nakammino tolayira. ");
INSERT INTO gdg_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Iyawa sirwat, waldanneno lammuka ana sino tolayira, e ino lammuk, ammena makaaddap sinaya sirwat. ");
INSERT INTO gdg_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Agyanino tolaya dinunduni Dios a mingngan si Juan. ");
INSERT INTO gdg_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ino nanundunani Dios sikwana, ipakaammuneno sirwat takesi ammina tolay, dingngagganda e kuruwanda nad. ");
INSERT INTO gdg_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Bakkanni Juanino sirwat, nu ammena lud ginamwang pelanga mipakaammu mappeafu sinaya sirwat. ");
INSERT INTO gdg_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Se aneno ginamwang kappaya antuweno gakkuruwa sirwata mawwaldag sino ammina nakammino tolayira. ");
INSERT INTO gdg_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Inaya naingnganan si Sapit, inang sito lubag, e massiki antuweno nepamaratuwi Dios sino tolayira, ammera kappay naimunuwan. ");
INSERT INTO gdg_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Massiki inang sino gakkuruwa lubbunna, inammera kappay. ");
INSERT INTO gdg_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Udde agyampayino nanggammira sikwana e nanguruwira. Ireno niyaꞌdanna si kalintiyana mabbali si abbingi Dios. ");
INSERT INTO gdg_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ino nabbaliyanda si abbingi Dios, bakkannino gagangena tolaya meyanak sito lubag, se ammena naggabwat sino gakkanna tolaya mabbing, nu ammena lud naggabwat sino pannakadama i Dios a Amara. ");
INSERT INTO gdg_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Inaya Sapit, nabbali si tolay e nakilubbun sikwami. Minangkallakka tolay e passiyingke a gakkuruwino sinapiꞌna. Initamiyeno kinalawanna a antuweno kinalawarino tatatata ke a Abbingi Dios a naggabwat sino Amana. ");
INSERT INTO gdg_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Nassapiti Juan mappeafu sikwana, nekunna si, “Antuwen yawino sinapikku sin nassapitangku sikwayu si, ‘Ino metufad sikwak, nangatu amma sikwak, se anen massiki sin ammek kepay neyanak.’ ” ");
INSERT INTO gdg_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Gafu sino dokalla angngikallaꞌnga, kanayuna madadaggananino nalawara iyaꞌdana sikwatama mangurug. ");
INSERT INTO gdg_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ino lintiyi Dios ino nepakaammuwi Moises, udde ino nepaita i Jesu Kristo, antuweno kakuruwan mappeafu ki Dios annino angngikallaꞌnga sikwatam. ");
INSERT INTO gdg_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Awaningke a tolaya nakaita ki Dios, udde ino tatatata ke a Abbingnga a kakunnana a agyan sikwana, antuweno nipakaammu mappeafu ki Amana. ");
INSERT INTO gdg_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Wasinoy, aneno papadiyera andino Levitera a kaduffunanda a inang ki Juan. Dinundunireno pangafuwanirana Judyu sey Jerusalem ki Juan ta ibebuꞌda nu sanneno katolena. ");
INSERT INTO gdg_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Amme neyimaddi Juanino kakuruwan, nu ammena lud nepunnuwa nassapit si, “Bakkannakino Kristo a dinunduni Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","“Inyaka mat?” kunda sikwana. “Ikka nalangi Elias a gumalabbun siꞌina kunda si muli kappay?” “Bakkan,” kunni Juan. E nekunda kappay si, “Tantaro nu ikkeno gumalabbuna aggataronammi?” “Bakkampay,” kunna. ");
INSERT INTO gdg_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","“Nu kunnenoy, inyaka mat? Ituldum mantu ta warana a sapitammi sino nanundunira sikwami. Sanneno sapitannu mappeafu sikwam?” ");
INSERT INTO gdg_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","“Ikkanakino neyakkuruwanino neturakki Isaias a gumalabbun siꞌina sapitanna si wara magyan sey kalolowata mikulawu sino tolayira si, ‘Pallawarandawino dalana pangannanino Afutama gumamwang.’ ” ");
INSERT INTO gdg_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Wara so kunnenoy, inayira a dinundunino Fariseowera, ");
INSERT INTO gdg_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","kunda kappay ki Juan, “Nu bakkangkeno Kristo onnu i Elias onnu ino gumalabbuna gumamwang, sangka lang mantuwa mamawtisar?” ");
INSERT INTO gdg_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Sinabbi Juan si, “Danum pelangino pamawtisarku sino tolayira, udde ana sikwayu sito ingkeinino ammeyu naimunuwan nu inya. ");
INSERT INTO gdg_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Antuweno metufad sikwak. Ino kakuruwanna, massiki ino muttad sino gakanneno sapatuꞌna, ammena meannunga akwangku se medayawingke amma sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Amminira yawa nakwa, nakwera ammin sey Betania sino dammangngeno wawwanga Jordan a nababbawtisarani Juan. ");
INSERT INTO gdg_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Waso kadaramaꞌnenoy, inita i Juani Jesus a umaraꞌni, e sinapiꞌna si, “Itandaw lud, antuyanino karnerowa neyaꞌda i Dios a mewaꞌlat takesi ariyanneno liwaꞌna tolayira sito lubag. ");
INSERT INTO gdg_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Antuyanino sinapikkuwa metufad sikwaka nangatu amma sikwak, se anen massiki sin ammek kepay neyanak. ");
INSERT INTO gdg_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Massiki ikkanak siꞌin, ammek naimunuwan nu inya. Udde ino gakkagguwa mamawtisar sino tolayira si danum, takesi mepakaammu sikwayuwa gakagaka i Israel si antuweno dinunduni Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","33","Nepakaammuwi Juanino nakwa e sinapiꞌna si, “Sin pittana, ammek gakkuruwa naimunuwan nu inya, udde i Dios a nanundun sikwaka mamawtisar sino tolayira si danum, sinapiꞌna sikwak si, ‘Maitammeno Espirituk a maddassag sino tata tolay ta magyan sikwana, e antuneno mamawtisar sino tolayira sino Espirituk.’ E gakkuruwa initakino Espirituwi Dios a kunnangke kalapatiya naddassag ki Jesus e nagyan sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Gafu sino nitangku sinay, itaꞌdaggu si antuweno Abbingi Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Waso kadaramaꞌna kappay inoy, agyanda Juan annino adwera a adalanna. ");
INSERT INTO gdg_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Nedipaꞌna i Jesus a mattaꞌlib, e sinapiꞌna si, “Antuwenayino karnerowa neyaꞌda i Dios a mewaꞌlat.” ");
INSERT INTO gdg_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wasin diningngaggino adwera a adalanino sinapiti Juan, dinandanira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Nallangiyi Jesus, initanera a dumandan, e nebebuꞌna si, “Wara sapitandaw?” E sinabbadda si, “Rabbi, sintawino pagyanannu?” (Ino anggamma sapitannino Rabbi, Mesturu.) ");
INSERT INTO gdg_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","E sinapiti Jesus sikwara si, “Intam ta maitayu.” Antu gafuna, nebulunira ki Jesus e inanda initeno pagyananna, e nagyanira sinay si alas kwatro kiyad si gafi. ");
INSERT INTO gdg_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ino tata sikwara a naningngag sino sinapiti Juan anna dinandan ki Jesus, i Andres a kolaki Simon Pedro. ");
INSERT INTO gdg_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Kinangkamanna a sinufuki Simon e sinapiꞌna sikwana si, “Sinumpalammiyeno Mesias.” (Ino anggamma sapitan, ino Kristo a dinunduni Dios sito lubagga matturay.) ");
INSERT INTO gdg_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Neiyangnga i Simon ki Jesus. Sinulangngani Jesusi Simon, kasena sinapit sikwana si, “Ikka i Simon a abbingi Juan. Nganandakana si Cefas.” (Iyawa angan, kakunna i Pedro a ino anggamma sapitan, batu.) ");
INSERT INTO gdg_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Waso metufara aw, dinandammi Jesus a umang sey probinsiya a Galilea. Sinumpalannani Felipe a kalubbunanda Andres anni Pedro a taga-Betsaida, e sinapiꞌna sikwana si, “Mebulungka sikwak ta mabbalika si adalangku.” ");
INSERT INTO gdg_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","I Felipe, inangnga inintufuki Natanael, e wasin sinumpalanna, nekunna sikwana si, “Sinumpalamminnino tolaya neturakki Moises sino leburuwa neturakkanino lintig anna neturak kappayino gumalabbunira siꞌin. Antuwi Jesus a taga-Nazaret a abbingi Jose.” ");
INSERT INTO gdg_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Sinabbi Natanael si, “Ma, wara kad nalawad si maggabwat sey Nazaret?” “Anta lud ta itannu,” kunni Felipe. ");
INSERT INTO gdg_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Wasin inita i Jesusi Natanael a umaraꞌni, sinapiꞌna si, “Antuwenayino gakkuruwa gaka i Israel a awaningke nassisiriyanna.” ");
INSERT INTO gdg_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","“Sanneno nangammuwannu sikwak?” kunni Natanael. E kunni Jesus sikwana si, “Initatakan sin aggatutturannu sino fungalla kayuwa igos sin ammeraka kepay inayani Felipe.” ");
INSERT INTO gdg_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","“Afu, ikka maꞌlurino Abbingi Dios,” kunni Natanael, “ikkeno Ariya aggataronammi sito Israel.” ");
INSERT INTO gdg_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","E nekunni Jesus si, “Ma, kuruwannumpay si ikkanaki Kristo gafu sino nassapitangku si initataka sino fungalla kayu? Oddu kepeneno maitayuwa kakkaꞌbaw amma sinoy.” ");
INSERT INTO gdg_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","E sinapiti Jesus sikwara ammin si, “Gakkurug yo sapitangku sikwayuwa maitayuneno langita mabukkatan andino anghelira i Dios a muluuliya maddassag anna sumullu sikwaka Abbingnga Tolay.” ");
INSERT INTO gdg_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Wasino mekatalluwa aw, aneno kasar sey Cana a tata a lubbunna Galilea. Ana sinayino ina i Jesus, ");
INSERT INTO gdg_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","e naayangkappayi Jesus andino adalannera. ");
INSERT INTO gdg_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Wasin naambutinnino tayug, sinapitino ina i Jesus sikwana si, “Naambutinnino tayuwa inumanda.” ");
INSERT INTO gdg_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","E nekunni Jesus si, “Ina, ammemmad sapitannino akwangku. Ammena kepay nadaꞌngeno tiyempoka mangipaita sino pannakadamak.” ");
INSERT INTO gdg_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","E sinapitino inana sino kaduffunandera sinay si, “Akwandaw massiki sanneno pakwana sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Aneno gagangena Judyu mappeafu sino fustuwa akwanda a mamaggu. Antu gafuna, aneno annammira a darokkalla angang sinaya madanuman si lima lateno kadda tata. ");
INSERT INTO gdg_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","E kunni Jesus sino kaduffunandera si, “Pannundawino angangira si danum.” E pinannura amminino angang. ");
INSERT INTO gdg_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Sinapikkappayi Jesus sikwara si, “Maggauggayu takesi iyandaw sino makammu sino kasaran.” Antuweno inangwara, ");
INSERT INTO gdg_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","e nabbaliyen si tayuwino danum, e sininsimanino makammu. Gafu se ammena ammuweno naggabwatanino nalawara tayug, se ino pelang kaduffunandereno nakaammu, nepaayangngeno lalakiya makkasar, ");
INSERT INTO gdg_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","e sinapiꞌna sikwana si, “Sannera yaw, se gagangayino tolayira a iyuntara a iyannayino nalawara tayug, takesi nanu nakaodduwerana ninum, kasera ilawanino narakkatta tayug. Udde ikka, tangananino inangwam se nangambutannuwa nelawanino kalalawaran.” ");
INSERT INTO gdg_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Inaya inangwa i Jesus sey Cana a tata a lubbunna Galilea, antuweno palunguwa kakkaꞌbawa inangwana a mangipaita sino pannakadamana. E nanguruwino adalannera sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Wasin nabalinin inoy, inanda Jesus annino inana, ino kakkolaꞌngera andino adalannera sey Capernaum. Ammera mabaya magyan sinay. ");
INSERT INTO gdg_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Wasin araꞌniyennino fiyestana Judyu a ngananda si Laꞌwutan, inanda Jesus sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Sinallung sino Templo, e dinaꞌnganeno mallakuwera si baka, karnero, anna kalapatiya mewaꞌlat ki Dios, andino gumatalyatira si pirak. ");
INSERT INTO gdg_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Nangwa i Jesus si lufira siwaꞌwaꞌna, e nepaanoneno mallakuwera, e dinulinneno ammina karnerowera andino bakera sino lawan. Newariꞌneno pirakino gumatalyatira, e iletwanna kappayino lamisaandera. ");
INSERT INTO gdg_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Sinapiꞌna sino gumalakuwera si kalapati si, “Ilawandawira yan! Ammeyu pabbalin si allakuwan yo balayi Amak!” ");
INSERT INTO gdg_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Wasin initennino adalanira i Jesusino inangwana, dinandandeno neturak sino sapiti Dios a sapitanna si, “Afu Dios, ino nappelalota angngikalok sino balem, antuneno katayangku.” ");
INSERT INTO gdg_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Gafu sino inangwa i Jesus sino Templo, sinapitino pangafuwanirana Judyu sikwana si, “Sanneno kakkaꞌbawa ipaitam sikwami ta ipakurungnguweno kalintiyannuwa mangwa si kunnenoy?” ");
INSERT INTO gdg_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Sinabbi Jesus si, “Darallandaw yo balayi Dios ta pattaꞌdaggangku kappay si tallu aw.” ");
INSERT INTO gdg_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","“Ma?” kunnino Judyuwera. “Mepataꞌdangngu kappay si tallu aw iyawa Templo? Gampade napataꞌdag yaw si appatafulu e annamma run.” ");
INSERT INTO gdg_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Udde ino balayi Dios a sinapiti Jesus, ino bagginangkepay. ");
INSERT INTO gdg_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Antuweno wasin natayi Jesus e nangngangoli kappay, dinandammino adalannera inoya sinapiꞌna, e nattalaginarino angngurudda sino neturakka sapiti Dios annino sinapiti Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Odduweno nangurug ki Jesus sinoya nakifiyestanna sey Jerusalem, se initareno kakkaꞌbawa senyala inangwana. ");
INSERT INTO gdg_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Udde amme nattalakki Jesus si gakkuruwino angngurudda sikwana, gafu se ammuna amminino nakamma tolay. ");
INSERT INTO gdg_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Ammena maawag si wara massapit sikwana mappeafu sino tolayira, se ammunanino ana sino nakanda. ");
INSERT INTO gdg_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Agyanino tata a pangafuwanna Judyu a Fariseo a mingngan si Nicodemo. ");
INSERT INTO gdg_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Wasi tata gafi, inangngi Nicodemo ki Jesus e sinapiꞌna si, “Afu, ammumi si i Diosino nanundun sikwama manuldu sikwami. Se awaningke a makaangwa sino kakkaꞌbawa senyala inangwam nu awani Dios sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","E sinabbi Jesus si, “Gakkurug yo sapitangku sikwam, awana tolaya mesapat sino patturayani Dios nu ammena mepidwa a meyanak.” ");
INSERT INTO gdg_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","E nebebuti Nicodemo si, “Damana kadda mepidwa a meyanakino tolay nu dokallin? Ma, damana a muli sino kuyungino inana ta meyanak kappay?” ");
INSERT INTO gdg_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","E nekungkappayi Jesus si, “Gakkurug yo sapitangku sikwam, ammena mesapatino tolay sino patturayani Dios nu ammena meyanak si danum annino Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Se ino iyanakino tolay, antuweno abbing inaya tolay. Udde ino mepidwa a meyanak sino Espirituwi Dios, antuweno abbingi Dios. ");
INSERT INTO gdg_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ammeka mantu makkaꞌbaw sito sapitangkuwa mepidwakayu nadda meyanak. ");
INSERT INTO gdg_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Se massiki madyata maawatanino makwa, makwa kappay. Kakunnaneno bayabbag, ammetam ammuweno naggabwatanna onnu ino iraꞌbunna, se kiyara anggamma, antuweno pabbayabbagganna, udde madingngaddangkepayino ungungnga. Kakunna kappayino makwa sino amminira a meyanak sino Espirituwi Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","E nebebukkappayi Nicodemo si, “Ansanna lang makweno kunnenoy?” ");
INSERT INTO gdg_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","E sinapiti Jesus sikwana si, “Ma, ikka keneno tata a madayawa mesturu sito Israel, gampade ammengkepay maawatan yaw? ");
INSERT INTO gdg_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Gakkurug yo sapitangku sikwam. Ino sapitammi sikwayu, antuweno inammumi annino initami. Udde ammeyu kepay kuruwan. ");
INSERT INTO gdg_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Nu ammeyu kinuruwino sinapikku mappeafu sino makwa sito lubag, ansandawino mangurug nu wara sapitangku mappeafu sey langit? ");
INSERT INTO gdg_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Awaningke a sinullu sey langit takesi itulduneno ana sinay, nu bakkannappelanga Abbingnga Tolaya naggabwat sinay. ");
INSERT INTO gdg_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","Inona makwa sikwak, kakunneno nakwa sino sinan ulagga nedikkatti Moises si kayu e netayangnga sin nannodoyuwanda sey kalolowat. Se ikkanak kappaya Abbingnga Tolay, maawag si melansaꞌnga sino krus anna metayak ");
INSERT INTO gdg_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","takesi nu inyeno mangurug sikwak, maaꞌdan si biyaya mannayun,” kunni Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Gafu se nappelalotino agganggammi Dios sino tolayira sito lubag, dinundunneno tatatata ke a Abbingnga a matay, takesi ammina mangurug sikwana, ammera makastigu, nu ammera lud maaꞌdan si biyaya mannayun. ");
INSERT INTO gdg_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Se amme dinunduni Diosino Abbingnga sito lubag ta kastigunneno tolayira, nu ammena lud ta isalaꞌngera. ");
INSERT INTO gdg_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Amminira a mangurug sikwana, ammera makastigu. Udde ino ammera mangurug, naukumiran a makastiguna, se ammera mangurug sino tatatata ke a Abbingi Dios. ");
INSERT INTO gdg_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Antuyawino gafuna a makastiguwerana: inang sito lubaggino sirwata mawwaldag sino nakammino tolayira, udde paanggandeno lammuk amma sino sirwat, se narakkattino aggangwara. ");
INSERT INTO gdg_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Se ino mangwera si narakkat, kaꞌgandeno sirwat, e ammera anggamma umaraꞌni sinay, tantaro nu maiteno kinarakkaꞌda. ");
INSERT INTO gdg_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Udde ino tolayira a manuntul sino kakuruwan, angganda a umaraꞌni sino sirwat takesi mepaita si i Diosino naggabwatanino nalawara akwanda. ");
INSERT INTO gdg_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Wasin nasinduwenoy, inanda Jesus andino adalannera sey probinsiya a Judea, e nagyanira sinaya mamawtisar sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","I Juan kappay, mamawtisar sey Enon a araꞌni sey Salim se odduwa danum sinay. Madadarandanino tolayira a umang sikwana ta mappabawtisarira, ");
INSERT INTO gdg_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","se amme kepay nabaluri Juan sinoy. ");
INSERT INTO gdg_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ino adalanira i Juan, nakitukkiyera sino tata a Judyu mappeafu sino abbawtisarda. ");
INSERT INTO gdg_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Gafu sino kunnenoy, inangngino adalannera sikwana, e sinapiꞌda si, “Afu, madandammuwenin bulunnu sin nagyanantam sey dammangnga Jordan a antuwenin sinapiꞌnu sikwami? Sitoya, mamawtisaringkappay, e antuweno angan amminino tolayira.” ");
INSERT INTO gdg_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Sinabbi Juan si, “Ammekayu maddararan sinay, se awana tolaya makaangwa si kunnenay nu amme urayi Dios. ");
INSERT INTO gdg_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Diningngaddawin sinapikkuwa bakkannakino Kristo, nu ammerak lud dinunduni Dios a maunta sikwana ta paddadanangkuweno tolayira a mangurug sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ino keampariyanna, kakunneno bulunino lalakiya mangatawa a makammuwa midadan sino kasar. Massiki bakkanna antuweno mangatawa sino bafay, maanggangkappaya makikasar, se dingngagganneno sapitannino bulunna. Kunnantu, ikkanaka nidadan sino tolayira sino gamwanganino Kristo, maanggammak kappay sito ingkein. ");
INSERT INTO gdg_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Umoddu naddino maddayaw sikwana e bumibissangngino dumandan sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ino naggabwat sito lubag, akwa yo lubag pelang, e ino pelang ammuna sapitan, ino mappeafu sino ana sito lubag. Udde ino naggabwat sey langit, medayaw amma sino ammina naggabwat sito lubag. ");
INSERT INTO gdg_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Massiki sapitanneno initana annino diningngangnga, kunnangke awana mangurug sino sapitanna. ");
INSERT INTO gdg_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Udde ino manguruwira sikwana, itaꞌdadda si gakkuruwino sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Se ino dinunduni Dios, awana sapitanna nu bakkampelangino nepasapiti Dios sikwana, se ana sikwaneno ammina pannakadameno Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Gafu se nappelalotino agganggammi Dios sino Abbingnga, netalaꞌngeno ammin sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Ino mangurug sino Abbingnga, mabiyangnga si makkikiyad. Udde ino ammena mangurug sikwana, ammena maaꞌdan si biyaya mannayun, nu amme lud kastiguni Dios si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Ino Fariseowera, diningngadda si oddu kanuweno dinandan ki Jesus annino binawtisarannera amma sino binawtisarani Juan. ");
INSERT INTO gdg_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Udde si kakurungnga, bakkanni Jesusino mamawtisar, nu bakkampelangino adalannera. ");
INSERT INTO gdg_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Wasin inammuwanda Jesus si kunnenayino diningngaggino Fariseowera, nanawira sey Judea ta muliyera sey Galilea. ");
INSERT INTO gdg_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Maawag si mallakarira sey probinsiya a Samaria, ");
INSERT INTO gdg_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","e ginamwangira sey Sicar a tata a lubbun sinay. Inaya lubbun, araꞌni sino lubagga neyaꞌda i Jacob sino abbingnga a i Jose siꞌin. ");
INSERT INTO gdg_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Agyangkappay sinayino bufuna kinokkofani Jacob. Naayangnginni Jesus a mallakad se tangnganawin, e nattuttud sino arurungngenaya bufun. ");
INSERT INTO gdg_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","E ino adalannera, inangngira sino lubbun ta maggatangira si akkananda. Wasino inanawiran, agyanino ginamwanga bafaya taga-sinaya umang manab sino bufun, e sinapiti Jesus sikwana si, “Makiinumak abbuwi.” ");
INSERT INTO gdg_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","“Ma, ansangka mangke makiinum sikwak, gampade Judyuka anna Samaritanak?” kunnino bafay. (Se ino Judyuwera, kaꞌganda usarannino akwana Samaritanowera.) ");
INSERT INTO gdg_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","E netabbi Jesus si, “Nannud inammumino iyaꞌda i Dios anna nu inyaka marang si danum, ikka naddino marang sikwak ta iyaꞌdak sikwamino danuma mappabiyag.” ");
INSERT INTO gdg_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","E sinapitino bafay si, “Afu, ataꞌnang yo bufun e awana panammu. Sintomantuweno pappannu sino danuma mappabiyag? ");
INSERT INTO gdg_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Lambawannu kaddino gagginafutama i Jacob a nappaillalupat sitawa bufun sikwami? Se iyawa bufun, antuweno panafanda andino anaꞌngera, anna pinumanino ayandera.” ");
INSERT INTO gdg_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Sinapikkappayi Jesus si, “Ino uminum sito danumma yaw a bufun, mauwokappena. ");
INSERT INTO gdg_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Udde ino uminum sino danuma iyaꞌdak, awaninna a mauwaw sikwana. Se ino danuma iyaꞌdak, mabbali si kunnangke bitufuta ammena mabbat sino dolamma baggina, e mangaꞌda sikwana si biyaya mannayun.” ");
INSERT INTO gdg_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Wasinoy, kunnino bafay si, “Afu, aꞌdannaꞌmantu sino danummuwi, takesi ammekuna mauwaw anna ammekungkappena mannotonut sitawa manab.” ");
INSERT INTO gdg_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","E sinapiti Jesus si, “Angka ayanino atawam ta mulikayu taw.” ");
INSERT INTO gdg_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","“Awana atawak,” kunnino bafay. E sinapiti Jesus si, “Gakkurug yan sinapiꞌnuwa awana atawam, ");
INSERT INTO gdg_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","se namillimakana nangatawa, e ino lalakim sito ingkein, bakkanna atawam. Antuweno gakkuruwino sinapiꞌnu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","E sinabbino bafay si, “Afu, gumalabbungka ikka. Ana mantuweno ibebukku sikwam. ");
INSERT INTO gdg_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Sintawino fustuwa paddayawantam ki Dios? Sitawa kulurino paddayawanino gagginafumi ki Dios. Udde ikkayuwa Judyu, sapitandaw si sey Jerusalem pelangino fustuwa paddayawantam ki Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Wasinoy, sinapiti Jesus sikwana si, “Kuruwannu naddino sapitangku sikwam, madatangngeno awa bakkan sito kulud anna bakkangkappay sey Jerusalemino paddayawanino tolayira ki Dios a Amatam. ");
INSERT INTO gdg_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ikkayuwa Samaritano, ammeyu inammuwi Dios a dayawandaw, udde ikkamiya Judyu, ammumiyeno dayawammi se ino mangisalak si ammina tolay, neyanaka Judyu. ");
INSERT INTO gdg_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Ino kakuruwanna, nadatangnginnino awa ino gakkuruwira a maddayaw ki Dios, maggabwatino addayora so nakanda a bakkampelang sino bifidda ta tuntulandeno kakuruwana kinadiosna, se antuweno anggammi Dios a akwanino maddayawira sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Se i Dios, espirituwa ammena maita. Kunnantu, ino maddayaw sikwana, dayawanna nad sino nakamma a tuntulanneno gakkuruwa kinadiosna.” ");
INSERT INTO gdg_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Wasinoy, kunnino bafay si, “Ammukun si gumamwangngeno Mesias a mingngan si Kristo, e ipakaammuneno ammina ammetam inammu.” ");
INSERT INTO gdg_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Netabbi Jesus si, “Ino sinapiꞌnuwa gumamwang, ikkanak inaya makitatabbag sikwam.” ");
INSERT INTO gdg_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Wasin aggedamadamikkepayi Jesus, ginamwangino adalannera. Nakkaꞌbawira a nita ki Jesus a makitatabbag si bafay. Udde awan sikwara a nappakibebut nu sanneno awanna bafay onnu nu sanneno gafuna a makitatabbi Jesus sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Waso kunnenoy, inanawanino bafayino gafana e nuli sino lubbunda. Sinapiꞌna sino kalubbunannera si, ");
INSERT INTO gdg_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Antam itanino lalakiya nassapit sikwak sino ammina inangangwak. Adasi antuweno Kristo a dinunduni Dios?” ");
INSERT INTO gdg_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","E inangngira ammin sino agyanani Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Wasin aꞌanawino bafay, sinapitino adalanira i Jesus sikwana si, “Afu, mayan ammeka mangngan?” ");
INSERT INTO gdg_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Udde sinapiꞌna si, “On, se aneno akkanangkuwa ammeyu ammu.” ");
INSERT INTO gdg_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Antuweno nakkakibikibebutino adalannera si, “Warada niyang si akkananna?” ");
INSERT INTO gdg_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Wasinoy, sinapiti Jesus sikwara si, “Ino akkanangkuwa mamiyag sikwak, antuweno pangwangku sino anggammino nanundun sikwak anna balinangkuweno nepakwana sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Aneno assapitandawa ‘Appata dakkino taronan, kasena aggarani.’ Udde ino sapitangku sikwayu, aggaraniyen sito ingkein. Itandonaddino tolayira a umaraꞌni sikwatam. Ireno ampariyangku si maganiyen nad ingkein. ");
INSERT INTO gdg_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Antuweno nalawad nu iyafuyunnino maggani. Gakkuruwa malabutangkayuna sino akwandawa mappakurug sino tolayira sikwak takesi maaꞌdanira si biyaya mannayun. Kunnantu, ino nabbiniyera sino sapiti Dios, makilanggakira sikwayuwa maggarani. ");
INSERT INTO gdg_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gakkuruggappayino assapitanda si, ‘Tateno mabbini, tangananino maggani.’ ");
INSERT INTO gdg_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Dinunduntakayuwa maggani sino ammeyu nayangngan, e sitoya, malabutangkayuwa maggani sino nayangnganino korwanira.” ");
INSERT INTO gdg_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Odduwera a Samaritano sinaya lubbuna nangurug ki Jesus gafu sino nassapitanino bafay si, “Sinapiꞌna sikwakino ammina inangangwak.” ");
INSERT INTO gdg_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Antu gafuna, wasin inangngira ki Jesus, inaranda si magyan nad sikwara. E nagyan sinay si adwa aw. ");
INSERT INTO gdg_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Oddu kappayino nangurug sikwana gafu sino tulduna. ");
INSERT INTO gdg_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","E sinapiꞌda sino bafay si, “Ino angngurummi sito ingkein, bakkampelanga gafu sino sinapiꞌnu, nu ammena lud gafu se diningngammiyeno tulduna, e ammumin si gakkuruwa antuweno dinunduni Dios a mangisalak si ammina tolay sito lubag.” ");
INSERT INTO gdg_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Wasin adwa awinda Jesus sinay, nanawira sey Samaria, e inangngira sey probinsiya a Galilea a antuweno naddokallanna. ");
INSERT INTO gdg_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","I Jesusingkepayino nassapit si, “Awana gumalabbun si dayawannino kalubbunannera.” ");
INSERT INTO gdg_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Udde wasin ginamwangira sey Galilea, maanggammino kalubbunannera a nappagamwang sikwana, se initara amminino kakkaꞌbawa inangwana sey Jerusalem sin nakifiyestanda sinay. ");
INSERT INTO gdg_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Waso kunnenoy, nulira Jesus sey Cana a lubbunna Galilea a antu kappayino nappabaliyanna sino danum si tayug. Ana sinayino tata ofisiyalna gubiyernuwa matakitino abbingnga a lalaki sey Capernaum. ");
INSERT INTO gdg_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Wasin diningngaggino ofisiyal si ginamwangi Jesus sey Galilea a naggabwat sey Judea, inang nappekakallak sikwana ta umangngad sey Capernaum ta pabbattunoyanneno abbingnga a gapapatayin. ");
INSERT INTO gdg_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","E sinapiti Jesus sikwana si, “Ammeyu maꞌlud mangurug nu awana itandaw si kakkaꞌbaw.” ");
INSERT INTO gdg_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Udde sinapikkappayino ofisiyal si, “Afu, anta lud, tantaro nu matayino abbingku.” ");
INSERT INTO gdg_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","“Umanokan,” kunni Jesus, “nabbattunoyinnino abbingngu.” Kinurungngeno sinapiti Jesus, e nanawin. ");
INSERT INTO gdg_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Wasin agyangkepay sino dalan sino metufara aw, dinambalneno aripannera a umang mipakaammu sino nabbattunoyanino abbingnga. ");
INSERT INTO gdg_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Nebebuꞌna nu kanseno nabbattunoyanna. E kunda si, “Madikig singgafiyeno naariyanneno patuna.” ");
INSERT INTO gdg_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Nadandammino ama si antuweno oratta nassapitani Jesus si, “Nabbattunoyinnino abbingngu.” Antu gafuna, amminira a taabbalay, nanguruwira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Antuwenayino mekadwa a kakkaꞌbawa senyala inangwa i Jesus sey Galilea. Inangwanan inay sin nuliyanna a naggabwat sey Judea. ");
INSERT INTO gdg_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Wasin nabalin inoy, aneno fiyestana Judyu sey Jerusalem e inangngi Jesus a makifiyesta. ");
INSERT INTO gdg_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Sey Jerusalem a araꞌni sino lalamwanganino karnerowera, aneno nabissokunga addiyutana nganannino Judyuwera si Betsata. Sino lebanna, aneno limera a kunnangke bawi, ");
INSERT INTO gdg_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","a antuweno passiyonganino odduwera a matakita tolay. Agyanino lappat, pilay, andino natayino gadweno baggira. Nagyanira sinaya mattaron sino pabwalanino danum, ");
INSERT INTO gdg_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","se nu korwan kanu, aneno angheli Afu Dios a massibbuwa makkingkibung sino danum e ino mapalunguwa massibbu sinay nu makibung, maariyeno massiki sanna a takiꞌna. ");
INSERT INTO gdg_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Agyanino tata a lalaki sinaya tallufulu e walu runinna matakit. ");
INSERT INTO gdg_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wasin inita i Jesus, inammuwanna si nabayinna natakit, e kunna sikwana si, “Anggammuwa maari yan ikalom ya?” ");
INSERT INTO gdg_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","E netabbino matakit si, “Afu, anggangku, udde awana misibbu sikwak nu makibungino danum. Kinakkapangkumpaya inang, udde nauntananak.” ");
INSERT INTO gdg_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Nekunni Jesus sikwana si, “Gumabwakkan, appannu yan afaꞌngu, e umanokan.” ");
INSERT INTO gdg_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Kakaꞌmeng kelanga naariyeno takiꞌna, inappaneno afaꞌnga, e nanawin. Inoya awa nabbattunoyanna, Sabadu, a antuweno pimwanganino Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Antu gafuna, sinapitino pangafuwanirana Judyu sino lalakiya naariyeno takiꞌna si, “Sannu lang aggaiggamman yan afaꞌngu a kontara sino lintiddam sito awa aggimwangantam?” ");
INSERT INTO gdg_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","E sinabbino lalaki si, “On lud, udde ino nari sino takikku, antuweno nassapit sikwak si appangkuweno afakku ta manawakun.” ");
INSERT INTO gdg_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","E nebebuꞌda sikwana si, “Inyeno nituldu sikwam si kunnenoy?” ");
INSERT INTO gdg_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Udde ammena inammuwenaya lalaki nu inyeno nari sino takiꞌna, se nelallamuri Jesus sino kaodduwanna tolay e inalluweta inanaw. ");
INSERT INTO gdg_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ammena nabayag, dinaꞌnga i Jesusino lalaki sino Templo, e sinapiꞌna sikwana si, “Itannu, nabbattunoykan. Ammekampena malliwat takesi awanimpena a kura narakkatta makwa sikwam.” ");
INSERT INTO gdg_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wasinoy, inanawino lalaki e inangnga sinapit sino pangafuwanirana Judyu si i Jesusino nari sino takiꞌna. ");
INSERT INTO gdg_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Antuweno nangiyafuwanda a nilopalopetan ki Jesus, se kunnenayino inangwana so awa aggimwanganda. ");
INSERT INTO gdg_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","E sinapiti Jesus sikwara si, “I Dios a Amak, ammena ibbattanino tarabafuna a mimut si tolay massiki sino awna aggimwangan, e antu naggappayino akwangku.” ");
INSERT INTO gdg_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Wasin sinapiꞌneno kunnenoy, nambubungutino pangafuwanirana Judyu sikwana e angganda si papatayanda, se ammena pelang kinontareno lintig mappeafu sino awna aggimwangan, nu ammena kappelud nekunnaneno baggina ki Dios sino nassapitanna si Amana i Dios. ");
INSERT INTO gdg_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Wasinoy, sinapikkappayi Jesus sikwara si, “Gakkurug yo sapitangku sikwayu. Ikkanaka Abbingi Dios, awana damaka akwan nu ikkanappelang itata, nu ammeꞌlubbelang akwanino itangkuwa akwani Ama. Se ammina akwani Ama, antu kappayino akwangku. ");
INSERT INTO gdg_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Se i Ama, anggammandaka Abbingnga, antuweno ipaitana sikwak ammina akwanna. E ana kappeneno ipakwana sikwaka kakkaꞌbaw amma sinaya inangwak takesi makkaꞌbokayu pena. ");
INSERT INTO gdg_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Se i Ama, pangngangolinneno natay, e kunna kappeneno akwangkuwa Abbingnga, se biyayangkuneno anggangkuwa biyayan. ");
INSERT INTO gdg_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Se bakkanni Ameno mangukum si massiki sanna a tolay, nu ammena lud neyaꞌda sikwaka Abbingngeno kalintiyana mangukum, ");
INSERT INTO gdg_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","takesi dayawandaꞌngeno ammina tolay a kunna payino addayora ki Ama. Ino ammena maddayaw sikwak, ammera kappay dayawanni Ama a nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Gakkurug yo sapitangku sikwayu, ino maddingngag sino sapitangku anna manguruggappay sino nanundun sikwak, mabiyangnga si makkikiyad. Ammenana makastigu se nalliꞌwen sino kakastiguwan si katayan, e naaꞌdanin si biyaya mannayun. ");
INSERT INTO gdg_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Gakkuruggappay yo sapitangku sikwayu. Ino ammina tolay, kunnangke natayira se nekatwayira ki Dios. Udde nadaꞌngennino awa massiki ino kunnangke natayira, dingngaggandeno sapitangkuwa Abbingi Dios, e nu manguruwira sino diningngadda, biyayangkuwera si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Se i Ama pelangino mangaꞌda si biyag, e kunna kappay sikwaka Abbingnga, se neyaꞌdana sikwakino kalintiyana mangaꞌda si biyag. ");
INSERT INTO gdg_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","E neyaꞌdana kappay sikwaka Abbingngeno kalintiyana mangukum sino tolayira, se ikkanakino Abbingnga Tolay. ");
INSERT INTO gdg_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ammekayu nad makkaꞌbaw sito sinapikku, se madaꞌnganeno awa amminira a natay, dingngaggandaneno damikku, ");
INSERT INTO gdg_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","e mangngangoliyerana ammin. Ino nangwera si nalawad, maaꞌdanirana si biyaya mannayun, udde ino nangwera si narakkat, maukumirana anna makastiguwerana si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Awana damaka akwan nu ikkanappelanga itata. Sino pangukumangku sino tolayira, kanayungkuwa tuntulannino sapitanni Ama sikwak. Antu gafuna, fustuweno akwangkuwa mangukum, se bakkannino anggangkuweno tuntulangku, nu bakkannino panggammanino nanundun sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Nu ikkanappelangino mamakurug sino baggikungkepay, ammena nalang makuruwino sapitangku. ");
INSERT INTO gdg_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Udde ana kappayi Ama a mamakurug mappeafu sikwak, e ammuk si gakkuruwino sapitanna. ");
INSERT INTO gdg_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","“Aneno dinundundawa inang ki Juan a nappakibebut sikwana, e sinapiꞌneno kakuruwan mappeafu sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","Ammek karug awannino tolaya mamakurug mappeafu sikwak, udde nepadandangku pelang sikwayuweno sinapiti Juan takesi kuruwandonad e mesalakangkayu. ");
INSERT INTO gdg_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","I Juan, meamparig si massirwata lampara, se ino tulduna, nawwaldag sino nakammino tolayira. Maanggangkayuwa naningngag sino tulduna si bisangnga tiyempo. ");
INSERT INTO gdg_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Udde sitoya, aneno mamakurug sikwayu si gakkuruwino sapitangku e nadadammat amma sino sinapiti Juan. Ino akwangkuwera a ipakwa i Ama sikwak, ireno mappakurug si i Ameno nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","I Ama a nanundun sikwak, antuwengkepayino mamakurug mappeafu sikwak, udde ammeyungke diningngaggino damiꞌna anna ammeyu kappay initeno akkakokwana. ");
INSERT INTO gdg_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Ammeyu nepattalaginarino sapiꞌna sino nakandaw se ammeyu mangurug sikwaka dinundunna. ");
INSERT INTO gdg_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Adaadalandawino sapiti Dios a nepeturaꞌnga siꞌin se natalanggaggayu si sumpalandaw sinayino kabiyayandaw si makkikiyad. Ikkanakino nasapit sinaya neturak, ");
INSERT INTO gdg_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","udde ammeyu kepay anggamma mangurug sikwak takesi aꞌdantakayu nad si biyaya mannayun. ");
INSERT INTO gdg_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ammek tarakannino pidayawanino tolayira sikwak, ");
INSERT INTO gdg_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","udde ammuk si ino kedayawandawino tarakandaw se awaningke agganggandaw ki Dios. ");
INSERT INTO gdg_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ino inangngangku sitaw, dinundundaki Ama si pannakabaggina, udde inammerak. Gampade nu wara korwana gumamwanga urenangkepay, antuweno iyataldaw. ");
INSERT INTO gdg_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ammeyungke dama a mangurug sikwak, se ino pelang anggandaw, ino pakkadayadayawandawingkepay, e ammeyu tarakannino pidayawan naddino gakkuruwa Dios sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Ammeyu nad dandamman si ikkanakino midarum sikwayu ki Ama, se ino midarum sikwayu ino neturakki Moises. Innanamandaw si mesalakangkayu nu kuruwandaw inaya neturaꞌnga, udde ammeyu kinurug, ");
INSERT INTO gdg_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","se nannud kinuraddaw inay, kuruwandak kappenad, se ikkanakino nasapit sinaya neturaꞌnga. ");
INSERT INTO gdg_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Udde gafu se ammeyu kinurug inaya neturaꞌnga, ansandawino mangurug nu sapitangku pelang?” ");
INSERT INTO gdg_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Wasin nallaꞌwutino pipidya aw, naddammanda Jesus andino adalannera sino bebaya Galilea a ngananda kappay si bebaya Tiberias. ");
INSERT INTO gdg_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Odduwera a tolaya dinandan sikwara, se initareno kakkaꞌbawa inangwana sino natakitira. ");
INSERT INTO gdg_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Nanuꞌdura Jesus sino kulud e nattutturira sinay. ");
INSERT INTO gdg_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Sinoya aw, araꞌniyennino fiyestana Judyu a ngananda si Laꞌwutan. ");
INSERT INTO gdg_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Wasin nedipati Jesusino odduwera a tolaya umang sino agyananda, sinapiꞌna ki Felipe si, “Sintawino pappantam si ipakkantam sino tolayira ya?” ");
INSERT INTO gdg_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ammuwi Jesusino akwanna, udde nebebuꞌna pelang inay, ta pangitanna nu sanneno akwani Felipe. ");
INSERT INTO gdg_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","E sinabbi Felipe si, “Massiki pipidya a rifuweno iyatantam si akkananda, ammena makabalin sikwara, massiki aggabisangnganda pelang.” ");
INSERT INTO gdg_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Wasinoy, sinapitino tata adalanna a i Andres a kolaki Simon Pedro si, ");
INSERT INTO gdg_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Aneno tata abbinga lalakiya nabbalibal si lima bila a tinapay anna adwaggiya tinapa. Udde ma, makabalin yaw sino odduwera a tolay?” ");
INSERT INTO gdg_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","“Pattutturandawira abbu,” kunni Jesus sino adalanira. Kakaddattan sinay, e antuweno nattutturanino tolayira. Kalimarifuweno kaodduweno lallakiyera, fera pelangino bafabbayira andino aanakira. ");
INSERT INTO gdg_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Inappa i Jesusino tinapay, nappasalamat ki Dios, kasena nepeyannay sino adalannera sino tolayira a aggatuttud sinay. Kunna kappayino inangwana sino tinapa, e nangngan amminino tolayira kiyad si nassongkalira. ");
INSERT INTO gdg_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Wasin nabattuwiran ammin, sinapiti Jesus sino adalannera si, “Amamungandawino nabuna ta awana madadak.” ");
INSERT INTO gdg_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Inamamundeno binuneno tolayira sino lima a tinapay, e karadwa a basketino napannu sino namamaꞌmakka binunara. ");
INSERT INTO gdg_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Wasin initeno tolayira inoya kakkaꞌbawa inangwa i Jesus, sinapiꞌda si, “Antuwen yawino gumalabbuna aggataronantama umang sito lubag.” ");
INSERT INTO gdg_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Udde i Jesus, nelasinna si patutanda a mabbali si arira, antuweno inanawannera e inang nagyan sino kulura itata. ");
INSERT INTO gdg_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Wasin mallammukin, inangngino adalanira i Jesus sino dappiꞌna bebay. ");
INSERT INTO gdg_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","Nattakayira si abang ta maddammangira sey Capernaum. Lammukin, udde amme kepay ginamwangi Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Kakaꞌmeng kelanga nabbayabbag si natuyag e nappalungino danum. ");
INSERT INTO gdg_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Wasin nabaya nappaluwera a kinaꞌnareno lima onnu annamma kilometro, initara i Jesus a mallakad sino utunna danuma mararaꞌni sikwara, e nakatalawirangke. ");
INSERT INTO gdg_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Udde sinapiti Jesus si, “Ammekayu mattalaw se ikkanak.” ");
INSERT INTO gdg_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","E kasera pay maanggamma nappatakay ki Jesus, e kakaꞌmeng kelanga ginamwangira sino umangnganda. ");
INSERT INTO gdg_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Wasi kagigiꞌbaꞌna, ino kaodduwana tolaya naanawan sey dammang, aggataronanda i Jesus. Se initara si ammena nakitakay sino adalannera, gampade ammura si awana korwana abang sinay a pattakayanna. ");
INSERT INTO gdg_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wasinoy, ginamwangino korwanira a abanga naggabwat sey Tiberias a inasip sino gaꞌdang a araꞌni sino pamakkanani Jesus sino tolayira sin nabalininna nappasalamat ki Dios. ");
INSERT INTO gdg_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Wasin naammuwanino tolayira si awani Jesus andino adalannera, nattakayira sinayira a abang a inang sey Capernaum ta tufukanda i Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Wasin ginaꞌdangino tolayira sey Capernaum, sinumpalanda i Jesus, e sinapiꞌda sikwana si, “Afu, kanseno ginamwangannu sitaw?” ");
INSERT INTO gdg_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","E sinabbi Jesus si, “Gakkurug yo sapitangku sikwayu, tufukandak, bakkanna gafu se naawatandawino kakkaꞌbawa inangwak, nu ammena lud gafu se pinakkantakayu e nabattuggayu. ");
INSERT INTO gdg_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Bakkan naddino maakkana madarallino aggadandammandaw, nu ammena lurino maakkana mabbalanayun, a antuweno mangaꞌda si biyaya mannayun. Ino mangaꞌda sinaya maakkan sikwayu, ikkanaka Abbingnga Tolay, se ikkanakino nitalakkani Dios a Ama sinaya kalintiyan.” ");
INSERT INTO gdg_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Wasinoy, nebebutino tolayira sikwana si, “Sanna mantuweno nalawara akwammi takesi tuntulammiyeno panggammani Dios?” ");
INSERT INTO gdg_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","E netabbi Jesus sikwara si, “Ino anggammi Dios a akwandaw, manguruggayu nad sikwaka dinundunna.” ");
INSERT INTO gdg_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Wasinoy, kunda kappay sikwana si, “Sanna mantuweno kakkaꞌbawa senyala ipaitam sikwami takesi manguruggami sikwam? Wara nad akwannu, ");
INSERT INTO gdg_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","se i Moises, pinakkanneno gagginafutamira si mana sin nagyananda sey kalolowat. Kunna kappayino nepeturakki Dios a kunna si, ‘Pinakkandera si maakkana naggabwat sey langit.’ ” ");
INSERT INTO gdg_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Sinabbi Jesus si, “Gakkurug yo sapitangku sikwayu, bakkanni Moisesino nangaꞌda sino maakkana naggabwat sey langit, nu bakkan luri Ama. E ino nakkanda siꞌin a naggabwat sey langit, bakkan inayino gakkuruwa maakkana iyaꞌda i Dios sikwayu sito ingkein. ");
INSERT INTO gdg_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Se ino gakkuruwa maakkana iyaꞌda i Dios, antuweno maggabwat sey langita mangaꞌda si biyaya mannayun sino tolayira.” ");
INSERT INTO gdg_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","E sinapiꞌda sikwana si, “Afu, aꞌaꞌdandakami si kunnayana maakkan.” ");
INSERT INTO gdg_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Wasinoy, sinapiti Jesus sikwara si, “Ikkanakino anggamma sapitannino maakkana mangaꞌda si biyag. Se ino umang sikwaka mangurug, ammenana mabisinan anna ammenana mauwaw. ");
INSERT INTO gdg_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Udde ikkayu, massiki initarakun, ammekayu kepay mangurug. Antu kappayino sinapikku sikwayu siꞌin. ");
INSERT INTO gdg_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Amminneno netalakki Ama sikwak, manguruwirana sikwak. E amminira a mangurug sikwak, ammekirana ammayan. ");
INSERT INTO gdg_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Se ammek naddassa naggabwat sey langit takesi akwangkuweno panggammangku, nu ammena lurino panggammanino nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","40","E ino panggammani Ama a nanundun sikwak, imutangkungke ino netalaꞌnga sikwak takesi awaningkena malallag sikwara, nu ammekira lud pangngangolin ammin naso uddina aw. Se anggamma si ammina mangammu anna mangurug sikwaka Abbingnga, mabiyayirana si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Wasinoy, adadumulino Judyuwera gafu sino sinapiti Jesus si antuweno maakkana naggabwat sey langit. ");
INSERT INTO gdg_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","E sinapiꞌda si, “Bakkangkad yawi Jesus, a abbingi Jose? Ammutangkeneno inana anna amana. Sannalang kun si naddassa naggabwat sey langit?” ");
INSERT INTO gdg_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Netabbi Jesus sikwara si, “Ammekayu madadumul. ");
INSERT INTO gdg_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Awana makaumang sikwaka mangurug, nu amme ipadandammi Ama a nanundun sikwakino panguruwanda, e iraneno pangngangolingku so uddina aw. ");
INSERT INTO gdg_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Se aneno neturakkino gumalabbunira siꞌina kunna si, ‘Ammina tolay, tulduwanirana i Dios.’ Nu inyereno maningngag sino sapitanni Ama takesi matulduwanira sikwana, ira kappeneno umang sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ammena anggamma sapitan si aneno nangita ki Ama, se awana nakaita sikwana nu bakkannappelanga naggabwat sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Gakkurug yo sapitangku sikwayu, ino tolaya mangurug sikwak, mabiyangnga si makkikiyad, ");
INSERT INTO gdg_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","se ikkanakino maakkana mangaꞌda si biyag. ");
INSERT INTO gdg_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ino gagginafuyuwera siꞌin, nangnganira si mana sin nagyananda sey kalolowat, udde natayira kappay. ");
INSERT INTO gdg_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Udde ayawino maakkana naggabwat sey langit, e ino mangngan sitaw, ammenanna a matay. ");
INSERT INTO gdg_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Ikkanakino maakkana naggabwat sey langita mangaꞌda si biyag, e ino mangngan sitawa maakkan, mabiyag si makkikiyad. Iyawa maakkan, antuweno baggika iyaꞌdak takesi damana a mabiyag ammina tolay si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Waso diningngaggino Judyuwera inoy, nassasarombatira a nassapit si, “Ansallang iyaꞌdenaya tolayino baggina ta akkanantam?” ");
INSERT INTO gdg_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Antuweno sinapiti Jesus sikwara si, “Gakkurug yo sapitangku sikwayu, nu ammeyu akkanan yo baggika Abbingnga Tolay anna nu ammeyu inuman yo adak, ammekayu mabiyag si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Se ino mangngan sino baggik anna uminum sino adak, iraneno mabiyag si makkikiyad e pangngangolingkuwerana so uddina aw. ");
INSERT INTO gdg_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Se ino baggik, antuweno gakkuruwa maakkan, e ino adak, antuweno gakkuruwa mainum. ");
INSERT INTO gdg_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Ino mangngan sino baggik anna uminum sino adak, mattalaginad sikwak e mattalaginarak pay sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","I Ama a nanundun sikwak, antuweno fungalla biyag, e mabiyayak gafu sikwana. Kunna kappayino mangngan sikwak, mabiyaggappay gafu sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ikkanakino kakuruwana maakkana naggabwat sey langit, a bakkanna kakunneno inakkanino gagginafutamira siꞌin. Se ino nangnganira sinay, natayira kappay. Udde ino mangngan sitawa maakkan, mabiyag si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Antuwenayino sinapiti Jesus sin nanulduwanna sino sinagoga sey Capernaum. ");
INSERT INTO gdg_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Wasin diningngaggino nebulunira ki Jesusino sinapiꞌna, oddu sikwara a nassapit si, “Ammenangke masillunino tulduna. Wara manggamma maddingngag si kunnayan?” ");
INSERT INTO gdg_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Massiki awana nituldu ki Jesus, ammuna a adadumulira, antuweno sinapiꞌna sikwara si, “Ma, kapaꞌlaꞌdaw yaw? ");
INSERT INTO gdg_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Mannanotinna nanu itandaka Abbingnga Tolaya sumulluwa muli sino naggabwatangku. ");
INSERT INTO gdg_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ino mangaꞌda si biyag ino Espirituwi Dios, e awaningke damadamana tolay. Ino sinapikkuwera sikwayu, naggabwatira ammin sino Espirituwi Dios, antu gafuna, mangaꞌdera si biyaya mannayun, nu kuruwandaw. ");
INSERT INTO gdg_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Udde ana sikwayuweno ammera mangurug sikwak.” Kunnenoyino sinapiti Jesus, se gagangaya ammuneno ammenera mangurug sikwana anna nu inyaneno mangilaku sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Sinapikkappayi Jesus si, “Antu gafuna a sinapikku sikwayu si awaningke makaang sikwaka mangurug, nu amme ipadandammi Ama sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Gafu sinaya sinapiꞌna, odduwera a nebulun ki Jesus a nattalekkud, e ammeran nebumbulun sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Antu gafuna, sinapiti Jesus sino karadwera a adalanna si, “Ikkayu paye, manokayu pay?” ");
INSERT INTO gdg_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Sinabbi Simon Pedro si, “Afu, waremmangke korwan si dumandanammi? Ikka pelangino manuldu sino mangaꞌda si biyaya mannayun. ");
INSERT INTO gdg_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Natalanggaggami si ikkeno nadiosana dinunduni Dios sito lubag a matturay.” ");
INSERT INTO gdg_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","E kunni Jesus sikwara si, “Bakkangkadda ikkanakino namili sikwayuwa karadwa? Gampade ana kepayino tata sikwayuwa aripanni Satanas.” ");
INSERT INTO gdg_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Ino anggamma sapitan, i Judas a abbingi Simon Iscariote, se massiki nu antuweno tata sino karadwera a piniliyi Jesus, antu kappeneno mangilaku sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Wasin nabalinin inoy, nannodoyubbelangi Jesus sey Galilea. Ammena inang sey Judea, se ammuna a ino pangafuwanirana Judyu sinay, angganda a papatayan. ");
INSERT INTO gdg_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Udde wasin araꞌniyennino fiyestana Judyu a ngananda si fiyestana Bawiyera, ");
INSERT INTO gdg_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","sinapitino kakkolakira i Jesus a lallaki sikwana si, “Manoka sito Galilea ta itanino adalannuwera sinay yan kakkaꞌbawa akwannu. ");
INSERT INTO gdg_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Ino tolaya manggamma maddinnamag, ammena magagyan sino bibissangnga lubbun, se ammena kura maammuwanino akwanna. Nu wara akwannu si kakkaꞌbaw, ipaitammad si ammina tolay.” ");
INSERT INTO gdg_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Kunnenayino sinapiꞌda se massiki ireno kakkolaꞌnga, ammera kappay nangurug sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Wasinoy, kunni Jesus sikwara si, “Ammena kepay nadaꞌngeno tiyempoka umang sinay. Udde sikwayu, massiki sanna a tiyempo, damayuwa umang. ");
INSERT INTO gdg_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Ammena dama a kababannaddakayuweno tolayira sito lubag, udde sikwak, kababannaddak se sapitangkuweno kinarakkaꞌneno akwanda. ");
INSERT INTO gdg_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Umangkayu mantu makifiyesta. Ammek kepay dama a umang se ammena kepay nadaꞌngeno tiyempok.” ");
INSERT INTO gdg_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Antuwenayino sinapiti Jesus, e natak sey Galilea. ");
INSERT INTO gdg_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Wasin inanawino kakkolakira i Jesus a inang nakifiyesta sey Jerusalem, sumalatannabbi Jesus a dumandan. ");
INSERT INTO gdg_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Ino pangafuwanirana Judyu, iniintufuꞌda i Jesus sino fiyestaan. “Sintomat inoy?” kunda. ");
INSERT INTO gdg_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Ino tolayira a naamung sinay, nadadumulira mappeafu sikwana. Aneno nassapitira si, “Nalawara tolayi Jesus,” udde ino korwanira, sinapiꞌda si, “Bakkan, se balabaliyanneno tolayira.” ");
INSERT INTO gdg_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Udde adadumulira pelang se mattalawira si dingngaggannino pangafuwandera. ");
INSERT INTO gdg_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Wasin mattangngennino fiyesta, inangngi Jesus sino Templo e nanuldu sinay. ");
INSERT INTO gdg_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","E nakkaꞌbawino pangafuwanirana Judyu e sinapiꞌda si, “Sintawino nappanna sino kinalaingnga, a ammena kena nadal?” ");
INSERT INTO gdg_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wasin diningngaggi Jesusino sinapiꞌda, sinabbangngera si, “Ino itulduk sikwayu, bakkanna naggabwat sikwak, nu ammena lud naggabwat ki Dios a nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Ino manggamma mangwa sino panggammani Dios, antuneno mangammu nu naggabwat ki Diosino itulduk onnu sino nakangku pelang. ");
INSERT INTO gdg_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Se ino manuldu sino naggabwat sino nakammangkepay, tufukanna pelangino kedayawanna. Udde ino manggam si madayawino nanundun sikwana, passiya gakkuruwino sapitanna anna awaningke poposunganna. ");
INSERT INTO gdg_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Bakkangkaddi Moisesino nangaꞌda sikwayu sino lintig? Udde awaningke sikwayuwa manuntul sinaya lintig. Se nu tuntulandonad, ammeraꞌngad ngangatana papatayan.” ");
INSERT INTO gdg_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Sinabbino tolayira si, “Nansekkan! Inya maꞌlurino mangngangata mamapatay sikwam?” ");
INSERT INTO gdg_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Wasinoy, sinapiti Jesus si, “Namittak ke a nappabattunoy si natakit sino awna aggimwangan, e kapaꞌlaꞌdaw, ");
INSERT INTO gdg_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","massiki ana kappayino akwandaw sinoya aw. Se aneno netuni Moises sikwayuwa inillalupaꞌna sino gagginafunera a kugitandonaddino abbindawira sino mekawaluwa awda. Massiki nu medemmu sino awna aggimwangan, akwandokappay. ");
INSERT INTO gdg_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Nu antuweno akwandaw sino awna aggimwangan takesi tuntulandawino netuni Moises mappeafu sino kugit, sangkayu lang nabbungut sikwak gafu sino nariyangku sino takiꞌneno lalaki sino awna aggimwangan? ");
INSERT INTO gdg_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ammeyu nad balawannino naitayuwa inangwak, nu ammeyu lud dandammannino kinalawanna.” ");
INSERT INTO gdg_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Waso kunnenoy, ino korwanira a taga-Jerusalem, sinapiꞌda si, “Bakkangkad yawino tolaya anggammino pangafuwantamira a papatayan? ");
INSERT INTO gdg_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Mayan nurepelanga manuldu sino kaodduwanna tolaya awana makkontara sikwana? Adasi ammura si antuweno Kristo a nekariyi Dios a gumamwang? ");
INSERT INTO gdg_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Bakkan nakuy, se nanu gumamwangino Kristo, awangkanuwa mangammu sino paggabwatanna, udde iyana tolay, ammutam amminino naggabwatanna.” ");
INSERT INTO gdg_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Wasinoy, nekokwa i Jesus a naddamit sino nanulduwanna sino Templo, e sinapiꞌna si, “Kundaw si ammurak anna ammuyu kappayino naggabwatangku. Udde ino kakuruwanna, bakkanna naggabwat so nakangkuweno inangngangku sitaw, nu ammena lud aneno nanundun sikwak. Antuweno gakkuruwa naggabwatangku, udde sikwayu, ammeyu inammu. ");
INSERT INTO gdg_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Udde ikkanak, ammuk, se antuweno naggabwatangku, e antu kappayino nanundun sikwak sitaw.” ");
INSERT INTO gdg_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wasin sinapiti Jesus inoy, anggammino pangafuwandera si doꞌmanda, udde ammera dama a akwan, se ammena kepay nadaꞌngeno tiyempona. ");
INSERT INTO gdg_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Udde massiki nu kunnenoy, odduwera a nangurug sikwana, e sinapiꞌda si, “Antu nakuyino Kristo. Se massiki nu wara korwana gumamwang, awan nakuy oddu si akwanna a kakkaꞌbaw amma sitawa tolay.” ");
INSERT INTO gdg_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Wasin diningngaggino Fariseowera inaya sapitannino tolayira mappeafu ki Jesus, ira andino pangafuwanirana padi, dinundundeno gwardiyerana Templo a umang manoꞌma ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Gafu sinoy, sinapiti Jesus si, “Ammena mabayino pagyanangku sikwayu, e muliyakun sino nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Iintufukandaꞌnga, udde ammeraꞌnga masumpalan, se ammekayuna makaang sino pagyanangku.” ");
INSERT INTO gdg_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wasinoy, nakkakibikibebutino pangafuwanirana Judyu a kunda si, “Sintodeno anganna a ammetamma masumpalan? Umang nakuy sino lulubbuna agyananino kasiJudyutamira ta tulduwanna kappayino bakkannira a Judyu a ana sinay. ");
INSERT INTO gdg_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Kunna si iintufukantamma, udde ammetam masumpalan. Kunna kappay si ammetamma makaang sino pagyananna. Sanna nakuyino anggamma sapitan?” kunda. ");
INSERT INTO gdg_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ino kauddiyana awna fiyesta, antuweno kapatiyan. Sinoya aw, nattaꞌdaggi Jesus e nekokwana a nassapit si, “Nu inyeno mauwaw, umang nad sikwak ta uminum ");
INSERT INTO gdg_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","se aneno nepeturakki Dios a kunna si, ‘Massiki inyeno mangurug sikwak, magyanna sikwaneno mangaꞌda si biyaya kunnangke danuma kanayuna mabwal sino bitufut.’ ” ");
INSERT INTO gdg_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ino anggamma sapitannino danuma kunni Jesus, antuweno Espirituwi Dios a meyaꞌdana sino manguruwira sikwana. Udde sinoya tiyempo, amme kepay neyaꞌdeno Espiritu, se ammena kepay nuliyi Jesus sey langit ta madayaw. ");
INSERT INTO gdg_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Wasin diningngaggino tolayireno sinapiti Jesus, sinapitino korwanira si, “Gakkuruwa antuweno gumalabbuna aggataronantam.” ");
INSERT INTO gdg_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Ino korwanira, sinapiꞌda si, “Antuweno Kristo a dinunduni Dios.” Udde ino pay korwanira, kunda si, “Bakkan, se naggabwat sey Galilea, e bakkan sinayino paggabwatanino Kristo. ");
INSERT INTO gdg_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Se kunnino nepeturakki Dios si iyaka i Ari David ino Kristo e meyanak sey Betlehem a lubbuni David siꞌin.” ");
INSERT INTO gdg_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Antu gafuna, ammena nakkakarunneno nakammino tolayira mappeafu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ino korwanira, angganda a doꞌman, udde awaningke makaturira manoꞌma sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wasinoy, nuliyeno gwardiyerana Templo sino agyananino pangafuwanirana padi andino Fariseowera, e nebebutino nanundunira sikwara si, “Mayan ammeyu dinoꞌman ta neiyandaw sitaw?” ");
INSERT INTO gdg_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","E sinabbino gwardiyera si, “Awaningke kakunnaneno addamiꞌna!” ");
INSERT INTO gdg_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","E sinapitino Fariseowera si, “Ma, massiki ikkayu, nabalabaliyangkayu kappepay? ");
INSERT INTO gdg_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Wara sikwamiya tatturay anna Fariseo a mangurug sikwana? ");
INSERT INTO gdg_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ino odduwera a tolaya nangurug sikwana, awaningke ammura mappeafu sino lintiddam. Kastigunira naddi Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Agyanino tata sikwara a Fariseo a i Nicodemo a antuweno inang nakitatabbag ki Jesus siꞌin. Sinapiꞌna sikwara si, ");
INSERT INTO gdg_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Udde sino lintiddam, ammena dama a paliwatannino tata tolay, nu ammetambu imbistigaran ta ammuntamino inangwana.” ");
INSERT INTO gdg_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","E netabbino bulunnera sikwana si, “Ma, taga-Galileaka kappay ta duffunannu? Adalannu kappenaddino nepeturakki Dios takesi maammuwannu si awaningke a gumalabbuna maggabwat sey Galilea.” ");
INSERT INTO gdg_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wasinoy, inanawiran sey balera. ");
INSERT INTO gdg_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Udde i Jesus, inang sey kulura Olivo. ");
INSERT INTO gdg_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Waso kadaramaꞌna, naggiꞌbatti Jesus a nuli sino Templo, e inaribumbungan amminino tolayira sinay. Nattutturi Jesus, kasena nanuldu sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wasinoy, ginamwangino korwanira a mammesturuwerana lintig andino Fariseowera a niyang sino tata a bafaya dinoꞌmanda a nakidurug si bakkanna atawana. Nepataꞌdadda sino naraꞌlanganino tolayira. ");
INSERT INTO gdg_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","E sinapiꞌda ki Jesus si, “Afu, iyawa bafay, dinaꞌngamiya nakidurug si bakkanna atawana. ");
INSERT INTO gdg_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Kunnino lintiyi Moises si malapalappaꞌngaddino kunnayana bafay kiyad si matay. Udde sikwam, sanneno masapiꞌnu?” ");
INSERT INTO gdg_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Kunnenoyino sinapiꞌda ki Jesus se angganda si wara paggafuwanda a midarum sikwana. Udde i Jesus, aggaoꞌmabbelanga panuraꞌngeno tamuruna sino lafuk. ");
INSERT INTO gdg_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Wasin patotonutandeno nappakibebut sikwana nu sanneno masapiꞌna, ginabwat e sinapiꞌna sikwara si, “Nu inya sikwayuweno awana liwaꞌna, antu naddino maunta a mallappag sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Kasena kappay inoꞌmadda manurak sino lafuk. ");
INSERT INTO gdg_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Wasin diningngaddenaya sinapiti Jesus, nassittatera a inanaw a naunteno kalakayanda kiyad si inanawira ammin. Da Jesus pelangino natak annino bafaya aggataꞌdaggepay sino aꞌlangnga. ");
INSERT INTO gdg_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Ginabwati Jesus e sinapiꞌna sino bafay si, “Antomatiran? Awana natak si mangastigu sikwam?” ");
INSERT INTO gdg_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“Awan, Afu,” kunnino bafay. E nekunni Jesus sikwana si, “Massiki ikkanak, ammetaka pay kastigun. Manokan lud, udde ammemun ipidwa a malliwat.” ");
INSERT INTO gdg_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Wasin nanuldu kappayi Jesus sino tolayira, sinapiꞌna si, “Ikkanakino kunnangke sirwata mawwaldag sino nakammino tolayira sito lubag. Nu inyeno dumandan sikwak, ammena mallakad so lammuk se mawaldan sitawa sirwata mangaꞌda si biyaya mannayun.” ");
INSERT INTO gdg_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","E sinapitino Fariseowera sikwana si, “Ammena makurug yana sapitannu se taꞌdaggannungkepayino baggim.” ");
INSERT INTO gdg_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","E netabbi Jesus si, “Massiki nu ikkanakungkepayino manaꞌdag sino baggik, gakkurubbayino sapitangku, se ammukino naggabwatangku annino iraꞌbungku. Udde sikwayu, ammeyu inammuweno naggabwatangku annino iraꞌbungku. ");
INSERT INTO gdg_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ino akwandawa mangukum sikwak, nabbakabakkan se dandammandopelangino maitayu. Udde sikwak, awana ukumangku. ");
INSERT INTO gdg_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Udde nu wara ukumangku, fustuweno angngukungku, se bakkannappelangino mangukum, nu ammena lud ikkami anni Ama a nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Se neturak sino lintiddaw a kakuruwanino sapitannino adwera a tolay nu makkunneno ammakurudda. ");
INSERT INTO gdg_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ino tata a manaꞌdag sikwak, ikkanakungkepay, e ino mekadwa, i Ama a nanundun sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Wasinoy, binebuꞌda si, “Sintawino agyanani Amama kunnu?” E kunni Jesus si, “Ammerak gakkuruwa ammu anna ammeyu kappay ammuwi Ama. Se nannud ammurak, ammuyu naggappayi Amak.” ");
INSERT INTO gdg_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Sinapiti Jesus amminira yaw sin nanulduwanna sino Templo a araꞌni sino aggiittunganda si pirak. Udde massiki aneno pangafuwanira sinay, awana manoꞌma sikwana, se ammena kepay nadaꞌngeno tiyempona. ");
INSERT INTO gdg_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Wasinoy, sinapikkappayi Jesus sikwara si, “Anawantakayuna, e pakaiintufukandaꞌnga. Udde ammekayuna makaang sino agyanangku, se matekayuna a ammena napakomanino liwaꞌdaw.” ");
INSERT INTO gdg_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Antu gafuna, nattatarabbanino pangafuwanirana Judyu si, “Ansannada sinapit si ammetam makaang sino agyananna? Papatayannaneno baggina e?” ");
INSERT INTO gdg_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Sinapikkappayi Jesus sikwara si, “Ikkayu, naggabwakkayu sito lubag, e ino pelang mappeafu sito lubaggino ammuyu. Udde ikkanak, naggabwatak sey langit, antuweno tangananino nakangku sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Antu gafuna, sinapikku si matekayuwa ammena napakomanino liwaꞌdaw, se antuneno gakkuruwa makwa nu ammeyu kuruwan si ikkanakino sinapikku.” ");
INSERT INTO gdg_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","“Ma, inyaka maꞌlud?” kunda sikwana. E sinabbi Jesus si, “Ino sinapasapikku sikwayu nangiyafu siꞌin kiyad sito ingkein. ");
INSERT INTO gdg_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Oddu kappenaddino sapitangkuwa mappaliwat sikwayu. Udde ino pelang ipakaammuk sino tolayira sito lubag ino diningngaggu sino nanundun sikwak, a gakkurug amminino sapitannera.” ");
INSERT INTO gdg_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Udde ammera naawatan si i Dios a Amana ino sinapiti Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Antu gafuna, sinapikkappayi Jesus sikwara si, “Nanu itayaddaka Abbingnga Tolay sino krus, kaseyuna maammuwan si ikkanakino sinapikku. Maammuwandona kappay si awana akwangku si maggabwat sino nakangku, nu ammek lud sapitampelangino netulduwi Ama. ");
INSERT INTO gdg_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ino nanundun sikwak, kanayuna mebumbulun sikwak. Ammenak pittatan, se ino kanayuna akwangku ino panggammanna.” ");
INSERT INTO gdg_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Odduwera a nangurug sikwana sin diningngaddenaya sinapiꞌna. ");
INSERT INTO gdg_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Wasinoy, sinapiti Jesus sino Judyuwera a nangurug sikwana si, “Nu mattalaginaggayuwa manuntul sino netulduk sikwayu, gakkuruwa ikkayuweno adalangku. ");
INSERT INTO gdg_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Maammuwandawino kakuruwan mappeafu sikwak, e inaya kakuruwan, antuweno mappawaya sikwayu sino kinaaripandaw.” ");
INSERT INTO gdg_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Wasinoy, sinabbino Judyuwera si, “Gakagakarakami i Abraham, e awangkepay nangaripan sikwami. Sannu lang sapitan si mapawayangkami?” ");
INSERT INTO gdg_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Sinapikkappayi Jesus sikwara si, “Gakkurug yo sapitangku sikwayu, massiki sanna a tolaya malliwat, ino liwatino nangaripan sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ino aripan, damana a paanawan sino balayino nangaripan sikwana, udde ino abbingino makwan balay, ammena paanawan, se abbingnga si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Antu gafuna, nu ikkanaka Abbingi Diosino mangipawaya sikwayu sino kinaaripandaw, gakkuruwingke a mawayangkayu. ");
INSERT INTO gdg_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Ammuk si gakagakarakayuwi Abraham, udde massiki kunnenoy, anggandak kepaya papatayan, se ammayandawino sapitangku. ");
INSERT INTO gdg_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ino pelang nepaita i Ama sikwak ino sapitangku. Kunna kappayino akwandaw, se ino tuntulandaw ino diningngaddaw sino amayu.” ");
INSERT INTO gdg_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Sinapitino Judyuwera si, “Awana korwan si naggaka sikwami, nu bakkampelangi Abraham.” Udde netabbi Jesus si, “Nu gakkurungngadda gakagakarakayuwi Abraham, tuntulandonaddino inangangwana. ");
INSERT INTO gdg_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Se itandaw, anggandaka papatayan, nu sapitangku pelang sikwayuweno kakuruwana diningngaggu ki Dios. Bakkanna kunnenoyino inangwa i Abraham. ");
INSERT INTO gdg_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Inayira a akwandaw, kakunneno aggangweno gakkuruwa amayu.” E sinapiꞌda si, “Bakkangkamiya banayi, se tata ke ino amamiya i Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Sinapikkappayi Jesus sikwara si, “Nannud gakkuruwa i Diosino amayu, anggandaꞌngaggappay se antuweno naggabwatangku sin inangngangku sitaw. Bakkanna urekungkepayino inangngangku sitaw, nu ammena lud antuweno nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mayan ammeyu maawatanino sapitangku? On se ammeyu anggamma dingngaggan. ");
INSERT INTO gdg_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Kakunnayuweno amayuwa i Ofag. Ino anggamma, antuweno anggandawa akwan. Gumapapatay nangiyafu siꞌin kiyad sito ingkein. Kababannangngeno kakuruwan se passiya siriyeno ana sikwana. Nu massisiri, tuntulanna pelangino gagangena, se sariyon anna antuweno fungalla ammina siri. ");
INSERT INTO gdg_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Udde ikkanak, passiya gakkuruwino sapitangku sikwayu, e antuweno gafuna a ammerak kuruwan. ");
INSERT INTO gdg_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Inya sikwayuweno mangitaꞌdag si wara liwakku? Awan. Nu gakkurug ammina sapitangku, mayan ammerak kuruwan? ");
INSERT INTO gdg_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ino abbingira i Dios, dingngaggandeno sapitanna sikwara. Ino gafuna a ammeyu dingngaggannino sapitanna sikwayu, bakkangkayuwa abbingnga.” ");
INSERT INTO gdg_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wasinoy, sinapitino pangafuwanirana Judyu ki Jesus si, “Gakkuruwingke ino sinapiꞌmiya taga-Samariaka a kalingami, anna naassaddangka kappay.” ");
INSERT INTO gdg_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","“Ammek naassaddan,” netabbi Jesus, “se dayawangkuwi Ama. Udde ikkayu, ayoyungandak. ");
INSERT INTO gdg_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ammek mappedayaw, udde aneno makammu sino kedayawangku, e antu kappeneno manaꞌdag sikwak anna mangukum sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Gakkurug yo sapitangku sikwayu, nu inyeno mangurug sito itulduk, ammenana matay si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Wasinoy, sinapikkappayino Judyuwera si, “Awaninna daladudwami si gakkuruwa inassaggan. Massikira Abraham andino gumalabbunira siꞌin, natayira ammin, gampade sapitannu kepay si nu inyeno mangurug sino tuldum, ammeran matay. ");
INSERT INTO gdg_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Nadayoka kad amma sino gagginafutamira a da Abraham andino gumalabbunira, a natayiran? Inyakangkekun?” ");
INSERT INTO gdg_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","E sinabbi Jesus si, “Nu ikkanaꞌngaddino mipadayaw sino baggikungkepay, awana serbina. Udde i Ama a kundaw si Diosdaw, antuweno midayaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ammeyu inammu, udde ikkanak, ammukungke. Nu kungku nad si ammek inammu, massisiriyaꞌngad a kunna pay sikwayu. Udde gakkuruwa ammuk, e akwangkuweno sapitanna. ");
INSERT INTO gdg_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Maanggammingke i Abraham a gagginafuyu siꞌin sin naammuwanna si maitananeno gamwangangku sito lubag, e gakkuruwa naitanan e maanggammingke.” ");
INSERT INTO gdg_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Sinapitino Judyuwera si, “Awangkepay limafuluneno runnu, e ansannuweno nita ki Abraham?” ");
INSERT INTO gdg_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","E sinabbi Jesus si, “Gakkurug yo sapitangku sikwayu, sin amme kepay neyanaki Abraham, nagyanakun.” ");
INSERT INTO gdg_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Antuweno naꞌnamira si batu e lappagganda naddi Jesus, udde inalluweti Jesus a inanaw sino Templo. ");
INSERT INTO gdg_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Wasin malallakari Jesus, initaneno tata a lalakiya neyanaka lappat. ");
INSERT INTO gdg_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","E nappakibebutino adalannera si, “Afu, inyeno makwan liwat sino nalappattannenaya lalaki?” ");
INSERT INTO gdg_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","E sinabbi Jesus si, “Bakkanna liwaꞌneno nalappattanna, anna bakkangkappaya liwatino mapparanaꞌngera, nu ammena lud nalappat takesi maiteno pannakadama i Dios a mappabattunoy sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Akwantammaddino nepakweno nanundun sikwak se kunnangke aw kepay, a ino anggamma sapitan, aggabiyayetangkepay. Se nanu matayetam, awaninna damatama akwan a kunnangke gafiya ammetam makatarabafu. ");
INSERT INTO gdg_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Udde kawarak kepay sito lubag, kakunnakino sirwata mawwaldag sino nakamma tolay.” ");
INSERT INTO gdg_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Wasin sinapiti Jesus inoy, nalluppa sino lubag, e nepalluyaꞌnga, kasena neaffuriyat sino mateno lappat, ");
INSERT INTO gdg_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","e sinapiꞌna sikwana si, “Umangka mimutung sino nabissokunga addiyutan sey Siloe.” (Ino anggamma sapitannino Siloe, Dinundun.) Inang nimutungino lalaki, e sino nuliyanna sino balena, nakaiten. ");
INSERT INTO gdg_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Wasin initeno kalubbunannera andino nitera sikwana sin nappalimutanna siꞌin, sinapiꞌda si, “Bakkangkad yanino kanayuna aggatuttura mappalimut?” ");
INSERT INTO gdg_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Nekunnino korwanira si, “On, antu,” udde kumpayino korwanira si, “Bakkan, udde nakkamutungira pelang.” Wasinoy, sinapitino lalaki si, “On, ikkanakin nappalimut siꞌin.” ");
INSERT INTO gdg_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","E nebebuꞌda si, “Ansangka lang mantu makaita?” ");
INSERT INTO gdg_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","E sinabbangnga si, “Agyanino tolaya mingngan si Jesus, nepalluyaꞌngeno luppana sino lubag, kasena neaffuriyat sino matak, e sinapiꞌna si, ‘Umangka mimutung sey Siloe.’ Inangngak sinay, e wasin nimutungak, nakaitakumpay.” ");
INSERT INTO gdg_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","E sinapiꞌda sikwana si, “Sintawino agyananna?” “Inta, ammek ammu,” kunnino lalaki. ");
INSERT INTO gdg_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Waso kunnenoy, neyandeno lalakiya nabbattunoyino lappaꞌna sino Fariseowera. ");
INSERT INTO gdg_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Awna aggimwanganino nangwani Jesus si luyak a nepagasna sino lappattino lalaki. ");
INSERT INTO gdg_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","E nebebutino Fariseowera sino lalaki nu sanneno nakwa sikwana a naariyeno lappaꞌna. E nepidwana a sinapit si, “Inafuriyatanneno matak si luyak, e wasin nimutungak, nakaitakumpay.” ");
INSERT INTO gdg_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Antu gafuna, sinapitino korwanira a Fariseo si, “Amme dinunduni Diosino tolaya nangwa si kunnayan, se ammena tuntulannino lintig mappeafu sino awna aggimwangan.” Udde ino korwanira, sinapiꞌda si, “Makaangwa kaddino minalliwat si kakkaꞌbawa kunnayan?” E naggaradweran. ");
INSERT INTO gdg_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Gafu so kunnenoy, finuꞌngaddangkappayino Fariseowera sino lalaki si, “Nu sikwam, sanneno masapiꞌnu mappeafu sikwana, se kunnu si nepabbattunoydaka?” E sinabbangnga si, “Tata lura gumalabbun.” ");
INSERT INTO gdg_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Udde amme kinuruwino pangafuwanirana Judyu si lappat siꞌin udde nabbattunoyin, antu gafuneno nappaayanda sino mapparanaꞌngera, ");
INSERT INTO gdg_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","e nebebuꞌda si, “Abbindokad yaw? Gakkurug kadda lappat sin neyanakanna? Sanna mat ta makaita mantu?” ");
INSERT INTO gdg_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","E sinabbino mapparanaꞌngera si, “On, abbimmi pay yan, e gakkuruwa lappat sin neyanakanna. ");
INSERT INTO gdg_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Udde ammemi ammuweno gafuna a makaiten sito ingkein, anna ammemi kappay ammu nu inyeno nappabattunoy sikwana. Futandawingkepay sikwana se dokallingkena e ammunanino itabbangngera.” ");
INSERT INTO gdg_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Antuwenoyino sinapiꞌda se mattalawira sino pangafuwanirana Judyu. Se natatarabbanda si nu wara massapit si i Jesusino Kristo a nekariyi Dios, ammeran mebilanga Judyu. ");
INSERT INTO gdg_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Antu gafuna a sinapitino mapparanaꞌngera si antuwengkepayino paffutanda. ");
INSERT INTO gdg_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wasinoy, inayangkappayino pangafuwanirana Judyuweno lalakiya lappat siꞌin, e sinapiꞌda si, “Massapataka ki Dios si gakkuruwino sapitannu, se ino nappabattunoy sikwam, ammumi si minalliwat.” ");
INSERT INTO gdg_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","E sinabbino lalaki si, “Ammek ammu nu minalliwat onnu bakkan. Ino pelang ammuk, lappattak siꞌin, udde sitoya, makaitakun.” ");
INSERT INTO gdg_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","E binebuꞌda kappay sikwana si, “Sanneno inangwana sikwam a makaitakan?” ");
INSERT INTO gdg_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","E sinapiꞌna kappay si, “Sinapikku kenain sikwayu, udde ammeyu kuruwan. Ma, anggandokaggappaya dingngaggan? Anggandokaggappaya mabbali si adalanna?” ");
INSERT INTO gdg_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wasinoy, nassapasapitanda si, “Ikka keneno adalanna, udde sikwami, adalandakamiyi Moises. ");
INSERT INTO gdg_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Se ammumi si sinatabbi Diosi Moises, udde iyana tolay, ammemi inammuweno naggabwatanna.” ");
INSERT INTO gdg_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Sinapitino lalaki si, “Makkaꞌbawak sitan. Nepabbattunoydak, gampade ammeyummangke inammuweno naggabwatanna. ");
INSERT INTO gdg_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ammutangkena si amme dingngagganni Diosino minalliwatira, udde dingngagganneno maddayawira sikwana annino mangwera sino panggammanna. ");
INSERT INTO gdg_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Makkiyad sin gafuna yo lubag, awana nadingngag si tolaya mappabattunoy si neyanaka lappat. ");
INSERT INTO gdg_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Nu ammena nad naggabwat ki Dios, ammena nad makaangwa si kunnayaw.” ");
INSERT INTO gdg_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","E sinapitino pangafuwanira sikwana si, “Neyanakka a minalliwat, e sandakami lang tulduwan?” Wasin sinapiꞌdenoy, nepaanoran. ");
INSERT INTO gdg_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Wasin diningngaggi Jesus a nepaanoreno lappatta nepabbattunoyna, inintaraꞌnga, e wasin sinumpalanna, sinapiꞌna sikwana si, “Mangurugga sino Abbingnga Tolay?” ");
INSERT INTO gdg_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","E sinabbino lalaki si, “Afu, ituldum nu inya takesi manguruwak sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","E sinapiti Jesus si, “Naitamun se antuweno makitatabbag sikwam ingkein.” ");
INSERT INTO gdg_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“Afu, manguruwak sikwam,” kunnino lalaki, e namalitura naddayaw sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Wasinoy, sinapikkappayi Jesus si, “Inangngak sito lubag ta melasinino ammera nangammu ki Dios andino nangammuwera sikwana. Ino ammera nangammu ki Dios a meyampariyira si lappat, pabbattunoyangkuwera ta makaitera. Udde ino makkun si ammura i Dios, kunnangke malappattirana.” ");
INSERT INTO gdg_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ino Fariseowera a agyan sinay, diningngaddeno sinapiꞌna, e sinapiꞌda sikwana si, “Ma, anggammu kadda sapitan si lappakkami kappay?” ");
INSERT INTO gdg_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","E sinabbi Jesus si, “Nannud gakkuruwa lappakkayu, awan nadda liwaꞌdaw. Udde gafu se kundaw si makaitakayu, antu gafuna a ana kepayino liwaꞌdaw.” ");
INSERT INTO gdg_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Wasinoy, niyampariyi Jesus a nassapit si, “Gakkurug yo sapitangku sikwayu. Nu wara kulunganino karnero e amme sumallungino tolay sino fustuwa lamwanganna, nu ammena lud munek sino alasangnga, gumatakaw anna tulisan inaya tolay. ");
INSERT INTO gdg_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Se ino gumaimut sino karnerowera, sumallung sino fustuwa lamwangan. ");
INSERT INTO gdg_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Antuweno patallungannino gwardiya neno lamwangan, e ayanneno karneronera. E nu taiingnganannera, maimunuwandeno damiꞌna, e umaddanira sikwana, kasenera pallawanan. ");
INSERT INTO gdg_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Nu nelawannera ammin, ifuyuꞌnera e dumandanira sikwana, se ammureno damiꞌna. ");
INSERT INTO gdg_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ammerangkelang kedadandanan si korwana tolay, nu ammera lud mabbukal, se ammera inammuweno damiꞌna.” ");
INSERT INTO gdg_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Antuweno ampariyi Jesus sino tolayira, udde ammera naawatan nu sanneno anggamma sapitan. ");
INSERT INTO gdg_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Wasinoy, niyampariggappayi Jesus a nassapit si, “Gakkurug yo sapitangku sikwayu, ikkanakino kunnangke lamwangana sumallunganino karnerowera. ");
INSERT INTO gdg_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Amminira a naunta sikwaka nanuldu si bakkanna gakkurug, kunnangke gumatakawira anna tulisan. Udde ammayira kinuruwino karnerok. ");
INSERT INTO gdg_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Ikkanakino kunnangke lamwangan. Massiki inyeno sumallung sikwak, mesalakanira. Ireno kunnangke karneroka sumallung anna mallawan a kanayuna nalawarino garafanda. ");
INSERT INTO gdg_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ino gakkanneno gumatakaw, awana korwan nu bakkampelangino mattakaw, mamapatay, anna manaral. Udde ikkanak, inangngak sitaw takesi maaꞌdan naddino tolayira si nalawara biyaya awana kakunnana. ");
INSERT INTO gdg_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ikkanakino kalalawarana gumaimut si karnero. Ino nalawara gumaimut, iyaꞌdaneno biyangnga takesi mesalakanira. ");
INSERT INTO gdg_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Udde nu ino mindag sino karnerowera ino matandanampelang a bakkannino makwan karnero, e nu wara itanna si sumarona atu, mabbukal e anawanneno indagganna a karnero. E katannino sumarona atuweno korwanira a karnero, e mawarawarakino korwanira. ");
INSERT INTO gdg_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ino gafuneno nabbukalanino matandanan, bakkanna akwaneno karnerowera e ammenera ikalow. ");
INSERT INTO gdg_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Udde ikkanakino kalalawarana gumaimut si karnero. Se ino nangammuwangku sino karnerokira annino nangammuwanda sikwak, kakunnana kappayino nangammuwangku ki Ama annino nangammuwanna sikwak. E iyaꞌdak kappayino biyaggu takesi mabiyayira. ");
INSERT INTO gdg_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Ana kappayino korwanira a karnerok a ammena kepay nedagga sito kulungan. Iyangkuwera nad sitaw ta dingngagganda kappayino damikku, takesi mittateno kaaramunganda ammin e tata ke ino mimut sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Iiddukannaki Ama se iyaꞌdakino biyaggu takesi mangngangoliyak kappena. ");
INSERT INTO gdg_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Awaningke a makapapatay sikwak nu bakkanna urekungkepay, se aneno kalintiyangkuwa mangaꞌda sino biyaggu e ana kappayino kalintiyangkuwa mappauli, se antuweno netuni Ama sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Wasinoy, naggadwa kappayino Judyuwera gafu sinayira a sinapiti Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Odduwera a nassapit si, “Inanset se naassaddan. Sanna maꞌlura dingngaggandaw sitan sapitanna ya?” ");
INSERT INTO gdg_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Udde ino korwanira, sinapiꞌda si, “Ino naassaddan, ammera makasapit si kunnenoy. Damana kadda mappabattunoy si lappattino dimonyu?” ");
INSERT INTO gdg_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Wasin tiyempona irid, agyanin fiyesta sey Jerusalem a ngananda si fiestana Kewaꞌlatanino Templo. ");
INSERT INTO gdg_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Agyani Jesus sinoya fiyesta a malallakad sino Palayari Solomon sino Templo. ");
INSERT INTO gdg_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Inaribumbunganino Judyuwera, e sinapiꞌda si, “Naansa maꞌneno pitulduwannu sino kakuruwan? Ituldumun nad sikwami nu ikkeno Kristo a nekariyi Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","E sinapiti Jesus si, “Netulduk kena sikwayu, udde ammeyu kinurug. Ino kakkaꞌbawa inangwak gafu sino pannakadama i Ama, ireno mitaꞌdag sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Udde ammekayu mangurug se bakkangkayuwa karnerok. ");
INSERT INTO gdg_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Se ino karnerokira, dingngaggandeno damikku e ammukira kappay. Antu gafuna, dumandanira sikwak, ");
INSERT INTO gdg_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","e aꞌdangkuwera si biyaya mannayun. Ammerangke mekatway ki Dios si makkikiyad, e awangkappaya makafulat sikwara sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Se i Ama a nitalak sikwara sikwakino kapatiyan si ammin, e awaningke makafulat sikwara sino aggimuti Ama. ");
INSERT INTO gdg_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Se ikkami anni Ama, mittatakami.” ");
INSERT INTO gdg_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Wasin sinapiti Jesus inoy, naꞌnangkappayino Judyuwera si batuwa ilappadda nad sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","E sinapiti Jesus si, “Odduweno nalawara inangwak sikwayuwa nepaangwa i Ama sikwak. Sanna sikwareno gafuna a lappaggandak?” ");
INSERT INTO gdg_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","E sinabbino Judyuwera si, “Bakkannino nalawara inangwamino pallappaggammi sikwam, nu ammena lurino pangababilannu ki Dios. Toleka pelang, udde ikunnamino baggim sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Sinapiti Jesus si, “Udde aneno nepeturakki Dios sino kundawa lintiddaw mappeafu sino pangafuwandawira siꞌina kunna si, ‘Ikkanaki Dios, e sapitangku si dioskayu kappay.’ ");
INSERT INTO gdg_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Ammutam si ammenan maangkakweno nepeturakki Dios. Nu diosino nepingnganna sino tolayira a nappasapitanna sino sapiꞌna, ");
INSERT INTO gdg_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","sandolang sapitan si ababilangkuwi Dios gafu se sinapikku si ikkanakino Abbingnga? Se ikkanakino pinilina anna dinundunna sito lubag. ");
INSERT INTO gdg_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Nu ammeꞌngad akwanino kakkaꞌbawa paangwa i Ama sikwak, massiki nu ammekayu mangurug sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Udde nu antuweno akwangku, massiki ammeyu kuruwannino sapitangku, kuruwandonad yawa akwangkuwera, takesi maammuwandawa ana i Ama sikwak anna anappay sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Wasinoy, kinakkapanda kappaya doꞌmani Jesus, udde nalliꞌwa sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Nuliyi Jesus sino dammangngeno wawwanga Jordan, inang sino pitta a nabbawtisarani Juan sino tolayira, e nagyan sinay. ");
INSERT INTO gdg_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Odduwa tolaya inang sikwana. Sinapiꞌda si, “Awana inangwa i Juan si kakkaꞌbaw, udde gakkurug ammina sinapiꞌna mappeafu sitawa tolay.” ");
INSERT INTO gdg_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","E odduwereno nangurug sikwana sinay. ");
INSERT INTO gdg_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","2","Agyanino makkakarolakira a nagyan sey Betania a da Maria, Marta, anni Lazaro. Iyawa Maria, antuweno nisibug si bambangug sino takkiyi Afu Jesus, kasena finunatan sino abuꞌnga. Wasinoy, nalowani Lazaro, ");
INSERT INTO gdg_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","e nanundunda Maria anni Marta si umang mangipakaammu ki Jesus, e sinapiꞌna si, “Afu, malowanino iiddukannuwa bulunnu.” ");
INSERT INTO gdg_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Wasin diningngaggi Jesus inoy, sinapiꞌna si, “Inaya kalona, bakkanna katayanino pattupakkanna, nu ammena lud nakwa inay takesi madayawi Dios anna madayawak kappaya Abbingnga.” ");
INSERT INTO gdg_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","I Jesus, iiddukannangke ino talluwera a makkakarolak. ");
INSERT INTO gdg_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Udde massiki diningngangnga a malowani Lazaro, ammena nalana inang se nagyangkepay sinay si adwa aw, ");
INSERT INTO gdg_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","kasena nekun sino adalannera si, “Muliyetamun sey Judea.” ");
INSERT INTO gdg_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","“Afu, ammena kepay nabayino pallappaggan naddino Judyuwera sinay sikwam, gampade anggammu kepaya muliyetam sinay?” kunda. ");
INSERT INTO gdg_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Udde sinapiti Jesus si, “Kadde, awana makwa sikwatam. Karadwa orattino tata si aw, e ammena meduffuweno tolaya mallakad si aw, se maiteno lakaranna. ");
INSERT INTO gdg_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Udde ino mallakad si gafi, meduffu, se awana sirwaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","E sinapikkappayi Jesus si, “Maturuwinni Lazaro a buluntam, udde angku gammiyan.” ");
INSERT INTO gdg_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","E sinapitino adalannera si, “Afu, nalawad nu maturug, se maariyeno kalona.” ");
INSERT INTO gdg_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Aridda si gakkuruwa naturuwi Lazaro, udde ino anggammi Jesus a sapitan, natayin. ");
INSERT INTO gdg_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Antu gafuna, sinapiꞌnan sikwara si, “Natayinni Lazaro, ");
INSERT INTO gdg_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","udde nalawad se awanak sinay sin natayanna, takesi mattuyangngeno angnguruddaw gafu sino itandaw. Ara, intamun ta antam itan.” ");
INSERT INTO gdg_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","I Tomas a ngananda si Siping, sinapiꞌna sino bafulunnera a adalan si, “Mebulunetam sikwana, takesi nu papatayanda, matayetam pay ammin.” ");
INSERT INTO gdg_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Wasin ginamwanda Jesus sey Betania, naammuwanda si kappata awinni Lazaro a netanam. ");
INSERT INTO gdg_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Gafu se tallu ke a kilometroweno kaaroyuna Betania sey Jerusalem, ");
INSERT INTO gdg_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","odduwera a taga-Jerusalem a inang namambay sikwara Marta anni Maria gafu sino natayanino kolaꞌda. ");
INSERT INTO gdg_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Wasin diningngaggi Marta a araꞌniyenda Jesus a gumamwang, inangngira dinambal. Udde i Maria, natak sino balera. ");
INSERT INTO gdg_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Sinapiti Marta ki Jesus si, “Afu, nu nagyangka nad sitaw, ammena nad natayino kolaꞌmi. ");
INSERT INTO gdg_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Udde massiki kunnenoy, ammuk si iyaꞌdana i Dios sikwamino ingkelamanga arangngannu.” ");
INSERT INTO gdg_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","E sinapiti Jesus si, “Mangngangolineno kolaꞌngu.” ");
INSERT INTO gdg_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","“On, ammuk si mangngangolina so uddina awa meyindan sino pangngangoliyanino amminira a natay,” netabbi Marta. ");
INSERT INTO gdg_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","E sinapikkappayi Jesus si, “Ikkanakino mappaangngangoli si natay anna ikkanakino mangaꞌda si biyag. Ammina mangurug sikwak, massiki nu matayira, mabiyayira kappay si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","E amminira a aggabiyag, nu manguruwira sikwak, ammera matay si makkikiyad. Kuruwannu yaw?” ");
INSERT INTO gdg_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","“On, Afu,” kunni Marta, “kuruwangku si ikkeno Kristo a Abbingi Dios a nekarina a umang sito lubag.” ");
INSERT INTO gdg_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Wasin sinapiti Marta inay, nuli sino balera, kinulafattanna i Maria, kasena nedumidumiya, “Ginamwangino Afutam e paayaddaka.” ");
INSERT INTO gdg_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Wasin diningngaggi Maria inay, ginabwat e nakkangkama inang dinambal ki Jesus, ");
INSERT INTO gdg_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","se ana kepera Jesus sino patabboka nanambalani Marta sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ino tolayira a nagyan sino balaya namambay ki Maria, initareno ginabwatanna, e dinandananda, se aridda si umang sino tanam ta mattangit sinay. ");
INSERT INTO gdg_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wasin ginamwangi Maria sino agyananda Jesus, namalitud sino aꞌlangnga, e sinapiꞌna si, “Afu, nu nagyangka nad sitaw, ammena nad natayino kolaꞌmi.” ");
INSERT INTO gdg_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Wasin inita i Jesus si mattatarangiꞌda Maria andino bafulunnera, malowingke ino nakamma, ");
INSERT INTO gdg_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","e sinapiꞌna si, “Sintawino nitanammandaw sikwana?” E sinapiꞌda si, “Afu, antam itan.” ");
INSERT INTO gdg_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","E nattangippayi Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","E sinapitino tolayira si, “Itandaw, dokallingke ino angngikalona ki Lazaro.” ");
INSERT INTO gdg_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Udde sinapitino korwanira si, “Nepabbattunoyneno lappatta tolay. Mayan awaningke inangwana takesi ammena nad natayi Lazaro?” ");
INSERT INTO gdg_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Wasin ginamwangira sino tanam, nallalow kappayino nakamma. Agwefino nitanammanda a nagakutan si batu. ");
INSERT INTO gdg_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","“Ariyandaw yan batu,” kunni Jesus. “On, Afu, udde nabuyukin, se kappata awinna netanam,” kunni Marta a kolakino natay. ");
INSERT INTO gdg_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","E sinapiti Jesus sikwana si, “Ammek kad sinapit sikwam, a nu mangurugga, maitammeno kedayawani Dios?” ");
INSERT INTO gdg_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wasinoy, inarireno batu. Sinangawi Jesus, kasena nekun si, “Ama, mappasalamatak se dingngaggandak. ");
INSERT INTO gdg_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ammuk si aggadingngaggandak, udde sapitangku yaw gafu sino tolayira sitaw, takesi kuruwanda si ikkeno nanundun sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Wasin sinapiꞌnenoy, nekulawuna a nassapit si, “Lazaro, mallawangkan.” ");
INSERT INTO gdg_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","E nallawanino nataya naburiburan si sinnunino kamaꞌna andino takkina, e nababbaddangkappayino uluna. E sinapiti Jesus sino tolayira si, “Ubbarandaw takesi makaanawin.” ");
INSERT INTO gdg_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ino Judyuwera a inang namambay sikwara Maria, initara inaya inangwa i Jesus. Antu gafuna, oddu sikwareno nangurug sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Udde ino korwanira, inangngira sino Fariseowera e netuldureno inangwa i Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Waso kunnenoy, ino Fariseowera andino pangafuwanirana padi, nepaayaddeno korwanira a pangafuwanirana Judyu, e nattatarabbira. Sinapiꞌda si, “Sanna matino akwantam? Se inaya tolay, odduweno kakkaꞌbawa akwanna. ");
INSERT INTO gdg_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Nu purayantam pelang, mangurungnga ammina tolay sikwana, e antuneno pabbalinda si afura. Dingngaggannino taga-Romera a matturay sikwatam, umangngirana sitaw, e darallandeno Templotam anna ammina patturayantam.” ");
INSERT INTO gdg_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Udde naddamiti Caifas, a afafuna padi sinoya run, e sinapiꞌna si, “Awaningke ammuyu. ");
INSERT INTO gdg_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ammeyu kad ammu si unoyneno tata ke ino matay ta mabiyayino kalubbunannera amma sino matayetam ammin?” ");
INSERT INTO gdg_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Inaya sinapiti Caifas, bakkanna naggabwat sino nakammangkepay, udde gafu se antuweno afafuna padi, nepelabbuni Dios sikwana si matena i Jesus takesi mabiyayino kalubbunanna a Judyu. ");
INSERT INTO gdg_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","E bakkampelangino kalubbunanna a Judyu, nu ammena lud ammina abbingi Dios a magyan si palulubbun, takesi mittatera ammin. ");
INSERT INTO gdg_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Nangiyafu sinoya aw, natatarabbanino pangafuwanirana Judyu nu ansanda a mamapatay ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Antu gafuna, amme nappaddara Jesus sey Judea, nu ammera lud inang sey Efraim, tata a lubbuna araꞌni sino danak. Antuweno nagyananda Jesus andino adalannera. ");
INSERT INTO gdg_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Araꞌniyennino fiyestana Judyuwera a ngananda si Laꞌwutan. Odduwera a inang sey Jerusalem a naggabwat si palulubbun, takesi akwandeno gagangera a mappadalus sino baggira so liyena fiyesta. ");
INSERT INTO gdg_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Pakaiintufukanda i Jesus, e wasin naaramamungira sino Templo, nakkakibikibebutira si, “Sanneno madandandaw? Ammenada gumamwang sito fiyesta ya?” ");
INSERT INTO gdg_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Se ino pangafuwanirana padi andino Fariseowera, sinapiꞌda si nu wara makaammu sino agyanani Jesus, itulduna nad sikwara takesi ipadoꞌmara. ");
INSERT INTO gdg_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Wasin annamma aw kepay aseneno fiyestana Laꞌwutan, inang kappera Jesus sey Betania a lubbuni Lazaro a nepangngangolina. ");
INSERT INTO gdg_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","E nidadanira si pamuwafanda Jesus, e i Marteno mallaꞌgak. I Lazaroweno tata a makikkan sikwara Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wasinoy, nangappa i Maria si kagadwana litrowa nangina a bambanguwa passiya nardo. E nesibungnga sino takkiyi Jesus, kasena finunatan sino abuꞌnga, e medadarngiyopino bangungnga sino balay. ");
INSERT INTO gdg_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Udde i Judas Iscariote a adalani Jesus a antuneno milaku sikwana, sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Sanna mat ta ammena ilaku inaya bambangug ta wara meyaꞌda sino mekakallakkira? Se ino balorna, mekunna sino sweldu si tarun.” ");
INSERT INTO gdg_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ino nassapitani Judas sinoy, bakkanna gafu se ikaloneno mekakallakkira, nu bakkan lud gafu se asoꞌdino kamaꞌna. Se antuweno miggam sino piraꞌda, e gastunna nu anggamma se antuweno gagangena. ");
INSERT INTO gdg_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Udde sinapiti Jesus ki Judas si, “Purayannu pelangi Maria. Se neyimfunnenaya bambangug takesi antuweno naunta a nelana sino baggik para sino ketanammangku. ");
INSERT INTO gdg_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Se ino mekakallakkira, kanayunira a ana sikwayu, udde ikkanak, ammek kanayuna ana sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Waso kunnenoy, odduweno Judyu a naningngag si ana i Jesus sey Betania, antuweno inangngira sinay. Udde bakkampelangi Jesusino anda itan, nu ammera luggappay umang itani Lazaro a nepangngangolina. ");
INSERT INTO gdg_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Kunnantu, ino pangafuwanirana padi, nattatarabbandeno akwanda a mamapatekappay ki Lazaro, ");
INSERT INTO gdg_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","se gafu sikwana, odduweno Judyuwera a nekatway sikwara e nanguruwira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Wasi kadaramaꞌna, diningngaggino odduwera a tolaya inang nakifiyesta si gumamwanginni Jesus sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","E nappera si adonna ayog ta umangngira dumambal sikwana, e nekulawura si, “Madandayawi Dios! Madandayokappenaddino dinunduni Afu Dios si pannakabaggina! Madandayawino Aritam sito Israel.” ");
INSERT INTO gdg_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","I Jesus, nattakay si ubbunna asnowa nepaappana. Antuweno neyakkuruwanino nepeturakki Dios siꞌina kunna si, ");
INSERT INTO gdg_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Ikkayuwa talubbuna Jerusalem, ammekayu mattalaw se gumamwanginnino Ariyuwa mattakay si ubbunna asno.” ");
INSERT INTO gdg_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ino adalanira i Jesus, ammera kepay naawatan si iyawa makweno meyakkuruwanino neturak. Udde wasin nuliyi Jesus sey langit, antuweno nanandammanda sitawa neturak mappeafu sikwana e gakkuruwa nakwa sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ino tolayira a nita sino nappaangngangoliyani Jesus ki Lazaro sin inayanna e nallawan, netulutuluyda a nipakaammu sino nakwa. ");
INSERT INTO gdg_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Antu gafuna, odduweno inang dinambal ki Jesus, se diningngaddenaya kakkaꞌbawa senyal a inangwana. ");
INSERT INTO gdg_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Antuweno nattatarabbanino Fariseowera si, “Itandaw kadda, awana serbineno inangwatam. Se ammina tolay, dumandanira sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Agyanino bakkannira a Judyu a naggabwat sey Grecia a inang nakifiyesta sey Jerusalem ta dayawanda i Dios. ");
INSERT INTO gdg_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Inangngira ki Felipe a taga-Betsaida a sakoꞌma Galilea, e sinapiꞌda si, “Afu, anggammi nad tatabbanni Jesus.” ");
INSERT INTO gdg_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Inangngi Felipe ki Andres ta itulduneno sinapiꞌda, kasera nabbuluna inang nituldu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","E sinapiti Jesus sikwara si, “Nadaꞌngennino tiyempowa ikkanaka Abbingnga Tolay, medayawak sino katayangku. ");
INSERT INTO gdg_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Gakkurug yo sapitangku sikwayu, ino katayangku, kunnangke ino kemulanino bukal. Se nu ammena memula, mittata pelang. Udde nu memula e madaral, mammunga si oddu. ");
INSERT INTO gdg_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Nu ikalowino tolayino biyangnga sito lubag, matekappena. Udde nu ammena ikalowino biyangnga sito lubag, mabiyangnga si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Nu inyeno manggamma masserbi sikwak, dumandan nad sikwak, takesi massiki sintawino agyanangku, antu kappayino agyananna. E amminira a masserbi sikwak, dayawannirana i Ama.” ");
INSERT INTO gdg_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Sinapikkappayi Jesus si, “Sitoya, makukungkulino nakangku, e sannadeno sapitangku? Adasi arangngangku si, ‘Ama, iliꞌwanaꞌngad sitawa makwana sikwak’? Ammena dama, se antuweno gakkagguwa inangngan sito lubag.” ");
INSERT INTO gdg_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Kasena sinapit si, “Ama, akwannu pelang sikwakino anggammu takesi maiteno kedayawannu.” E agyanino damita naggabwat sey langita kunna si, “Nepaitakino kedayawangku gafu sino inangwam, e ipaitak kappena gafuna sino makwa sikwam.” ");
INSERT INTO gdg_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ino tolayira a aggataꞌdag sinay, nadingngaddeno damit, e kunnino korwanira si addug. Udde ino korwanira, kunda si anghela makitatabbag sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Wasinoy, sinapiti Jesus sikwara si, “Inaya diningngaddawa damit, bakkampelanga gafu sikwakino naddamitanna, nu ammena lud gafu sikwayu, takesi manguruggayu. ");
INSERT INTO gdg_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Sito ingkein nadaꞌngennino kaukumanino tolayira sito lubagga ammera mangurug, sito ingkein nadaꞌngengkappayino naaffutani Satanas a matturay sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Udde nu ikkanak, nu metayaꞌnga, awisangkuweno tolayira sino palulubbun ta manguruwira sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Antuwenayino sinapiti Jesus, a nangipakaammu sino katayannana a metayag sino krus. ");
INSERT INTO gdg_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Wasinoy, sinapikkappayino tolayira si, “Ino sapitannino lintiddam, mabiyayino Kristo si makkikiyad. Ansannu lang kun si metayangngad si krusino Abbingnga Tolay? Inya kappelud yana Abbingnga Tolay?” ");
INSERT INTO gdg_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","E sinapiti Jesus sikwara si, “Ikkanakino kunnangke sirwata mawwaldag sikwayu, e ammena mabayag e anawantakayu. Dumandangkayu nad sikwak se kawarak sikwayu takesi ammekayu malammukan. Se ino mallakad si lammuk, ammena inammuweno iraꞌbunna. ");
INSERT INTO gdg_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Sitoya a ayawak kepaya sirwat, manguruggayu nad sikwak takesi mabbalikayu si tolaya mawaldanino nakanda.” Wasin sinapiti Jesus inoy, inanawannera e ammenan nappadda sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Massiki odduwennino kakkaꞌbawa senyala inangwa i Jesus a initeno tolayira, ammera kepay mangurug sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Antuweno neyakkuruwanino nelabbuni Isaias siꞌina kunna si, “Afu Dios, kunnangke awaningke a mangurug sino sinapiꞌmi, e ammera kappay nepilingalingeno nepaitama pannakadamam.” ");
INSERT INTO gdg_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Neturak kappayi Isaiasino gafuneno ammera nanguruwana sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Ilappattira i Dios e nepattaggaꞌneno nakanda takesi ammera makaita anna makaawat onnu muli sikwana ta pabbattunoyannera nad.” ");
INSERT INTO gdg_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Kunnenayino sinapiti Isaias se initaneno kinadiosi Jesus siꞌin, e antuweno nassapitanna sino mappeafu sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Udde massiki kunnenoy, odduweno pangafuwanirana Judyu a nangurug ki Jesus. Udde ammera nepakaammuweno nanguruwanda se mattalawira si kastigunireno Fariseowera ta ammera mebilang si bafulundera a Judyu. ");
INSERT INTO gdg_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Se aanggandeno kedayawanda sino tolayira amma sino kedayawanda ki Dios. ");
INSERT INTO gdg_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Waso kunnenoy, nekokwa i Jesusino nassapit si, “Ino mangurug sikwak, bakkannappelangino kuruwanna, nu bakkangkappelurino nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Ino mangita sikwak, maitana kappayino nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Inangngak sito lubagga kunnangke sirwat takesi ino manguruwira sikwak, ammera magyan sino lammuk. ");
INSERT INTO gdg_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","“Ino tolaya maningngag sino sapitangku udde ammena kuruwan, bakkannakino mangukum sikwana. Se ammek inang sito lubagga mangukum si tolay, nu ammek lud inang sitawa mangisalak sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Udde aneno mangukum sino tolaya mammay sikwak anna amme mangurug sino sapitangkuwera. Inaya sapitangkuwera, iraneno mangukum sikwana so uddina aw. ");
INSERT INTO gdg_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Se awana sinapikkuwa naggabwat sino nakangkungkepay, nu ammena luri Ama a nanundun sikwakino nituldu sino sinapikkuwera andino assapikku. ");
INSERT INTO gdg_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Ammuk si ino tulduna, antuweno paggabwatanino biyaya mannayun. Antu gafuna, massiki sanneno itulduna a sapitangku, antu pelangino isapikku.” ");
INSERT INTO gdg_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Wasi tata si gafi liyeya mangiyafuweno fiyestana Laꞌwutan, ammuwenni Jesus si nadaꞌngennino tiyempowa anawanna sito lubag ta muliyen ki Amana. Inaanggammangke ino tolenera sito lubag, e ipaitaneno agganggamma sikwara makkiyad sino katayanna. ");
INSERT INTO gdg_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Wasinoy, mamuwadda Jesus andino adalannera. Nepadandamminni Satanas ki Judas a abbingi Simon Iscariote si antuwenoya gafiyeno pappadoꞌmanna ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","I Jesus, ammuna si neyaꞌda i Amaneno ammina pannakadamana sikwana, e ammuna kappay si i Diosino naggabwatanna anna antu kappayino puliyannana. ");
INSERT INTO gdg_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Antu gafuna, nattaꞌdaggi Jesus, inarineno lumbonna, e nabbakwat si tuwalya. ");
INSERT INTO gdg_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Kasena nekwa si danum sino angngoran e neyafuna a munab sino takkiyeno adalannera, e finunatannera sino tuwalya a nebakwaꞌna. ");
INSERT INTO gdg_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Wasin dinaꞌngenni Jesusi Simon Pedro, sinapiꞌna ki Jesus si, “Afu, mayan ikkammangke ino munab sito takkik?” ");
INSERT INTO gdg_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","E kunni Jesus si, “Ammengkepemaꞌlud maawatan yo akwangku, udde maawatannu kappenalang.” ");
INSERT INTO gdg_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","E sinapikkappayi Pedro si, “Ammenangke dama si ikkeno munab sito takkik.” Udde nekunni Jesus si, “Nu ammek unafan yan takkim, ammekan mebilang si adalangku.” ");
INSERT INTO gdg_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","E sinapiti Pedro si, “Afu, nu kunnenoy, bakkampelang yo takkikino unafannu, nu bakkan lud massiki yo kamakku anna uluk.” ");
INSERT INTO gdg_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Sinabbi Jesus si, “Ino tolaya nakadiyutin, ammenan nad mandadiyut, se nadalusin. Ino pelang takkina naddino maunafan. E ikkayu, nadalusangkayu ammin, fera pelangino tata.” ");
INSERT INTO gdg_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ino gafuneno nassapitani Jesus si aneno tata a ammena nadalusan, se inammunanino mappadoꞌmana sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Wasin nabalininni Jesus a nunab sino takkirera, neallungnga kappayino lumbonna e nakituttuggappay sikwara. Kasena nebebuꞌna sikwara si, “Maawatandawino inangwak sikwayu? ");
INSERT INTO gdg_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Nganandak si Mesturu anna Afu, e nalawad yana sapitandaw se gakkuruwingke. ");
INSERT INTO gdg_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Nu ikkanaka Afu anna Mesturuyuweno nunab sino takkiyu, meannung nu kunnenoy kappayino akwandawa makkaunaunab si takki. ");
INSERT INTO gdg_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Inangwak inay ta wara tuntulandaw takesi akwandopayino kunneno inangwak sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Gakkurug yo sapitangku sikwayu, awana aripanna napatig amma sino amuna, e awangkappaya nadundun si napatig amma sino nanundun sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Gafu se maawatandawiran inay, maanggangkayu nu akwandaw.” ");
INSERT INTO gdg_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Sinapikkappayi Jesus si, “Bakkanna ikkayu amminino nassapitangku, se ammukino nakandawa pinilik. Udde pinilitakayu ammin takesi meyakkuruwino nepeturakki Dios a kunna si, ‘Ino nakikkan sikwak, nabbali si kalingak.’ ");
INSERT INTO gdg_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Sapitangku yaw sikwayu liyena a makwa, takesi nanu makwa, kuruwandaw si ikkanakino Kristo a dinunduni Dios. ");
INSERT INTO gdg_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Gakkurug yo sapitangku sikwayu, ino tolaya maningngag sino dundunangku, dingngaggandak kappay. E ino maningngag sikwak, dingngagganda kappayino nanundun sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Wasin sinapitira i Jesus inoy, malowingke ino nakamma, e sinapiꞌna si, “Gakkurug yo sapitangku, aneno tata sikwayuwa milaku sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Wasinoy, makkaititeno adalannera se ammera ammu nu inya sikwareno sapitanna. ");
INSERT INTO gdg_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ino nattuttud sino aruruwi Jesus, antuweno adalanna a iiddukannangke. ");
INSERT INTO gdg_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","E sinengyattani Simon Pedro ta futanna ki Jesus nu inya sikwareno sapitanna. ");
INSERT INTO gdg_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wasinoy, nassandiyinaya adalanna ki Jesus, e binebuꞌna si, “Afu, inya sikwamiyeno sinapiꞌnu?” ");
INSERT INTO gdg_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","E sinapiti Jesus sikwana si, “Ino pangaꞌdangku sito isosoka tinapay, antuwenay.” E nesosoneno tinapay, asena neyaꞌda ki Judas a abbingi Simon Iscariote. ");
INSERT INTO gdg_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Addiwawa langi Judas sino tinapay, inunagginni Satanas sikwana. E nekunni Jesus sikwana si, “Kangkamannuwa akwanino ana sino nakammu.” ");
INSERT INTO gdg_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Ino korwanira a makikkana adalanna, ammera naawatanino gafuna a kunnenoyino sinapiꞌna ki Judas. ");
INSERT INTO gdg_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Gafu se i Judasino gumaiggam sino piraꞌda, ariyino korwanira si dundunanni Jesus a umang maggatang si maawadda sino fiyesta, onnu umang mangaꞌda si pirak sino mekakallakkira. ");
INSERT INTO gdg_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Wasin nakkaninni Judasino tinapay, nallawanin. Sin nallawananna, gafiyenin. ");
INSERT INTO gdg_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Wasin inanawinni Judas, sinapiti Jesus si, “Ino makwana sikwak, antuweno mipaita sino kedayawangkuwa Abbingnga Tolay, e gafu sikwak, maita kappayino kedayawani Dios. ");
INSERT INTO gdg_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","E nu ipaitakino kedayawani Dios, ipaitana kappayino kedayawangkuwa Abbingnga, e malana makwa. ");
INSERT INTO gdg_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","“Ikkayuwa abbingku, ammek mabayag sikwayu. Tufukandaꞌnga, udde sapitangku kappay sikwayuweno sinapikku sino pangafuwanirana Judyu si, ‘Ammekayu makaang sino umangngangku.’ ");
INSERT INTO gdg_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Antuyawino bawuwa itungku sikwayu. Makkaaanggangkayu nad. Kunna payino inangwaka manggam sikwayu, antu naddino akwandawa makkaaanggam. ");
INSERT INTO gdg_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Se nu makkaaanggangkayu, antuneno pangammuwanino ammina tolay si adalantakayu.” ");
INSERT INTO gdg_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Wasinoy, nebebuti Simon Pedro si, “Afu, sintomatino angannu?” E sinabbi Jesus si, “Ammeka makadandan sikwak ingkein, udde dumandangka kappena.” ");
INSERT INTO gdg_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","E sinapikkappayi Pedro si, “Afu, mayan ammek makadandan sikwam sito ingkein? Massiki nu matayak gafu sikwam, damana pelang sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","E sinapiti Jesus si, “Sapitannungkelang si massiki mateka para sikwak. Udde gakkurug yo sapitangku sikwam, ammena kepay madaꞌngeno passirallotanino lalung, namiꞌluwannakunna a neimad.” ");
INSERT INTO gdg_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Wasinoy, sinapikkappayi Jesus sino adalannera si, “Ammekayu maddararan, nu ammeyu lud pattuyaggannino angnguruddaw ki Dios e pattuyaggandokappayino angnguruddaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Se odduwa pagyananna tolay sino balayi Ama sey langit, e mauntaka umang sinay ta midadanak si pagyanandaw. Ammek sapitan yaw nu bakkanna gakkurug. ");
INSERT INTO gdg_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","E nu nedadaninnino pagyanandaw, muliyak kappena a mappa sikwayu takesi makiigyangkayu pay sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Ammuyunnino dalana umang sino umangngangku.” ");
INSERT INTO gdg_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Wasinoy, sinapiti Tomas si, “Afu, ammemi inammuweno umangngannu, e ansanneno angngammumi sino dalana umang sinay?” ");
INSERT INTO gdg_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","E sinabbi Jesus si, “Ikkanakino dalan, se ikkanakino paggabwatanino kakuruwan andino mangaꞌda si biyag. Awana makaang ki Ama, nu bakkannakino pangannanna. ");
INSERT INTO gdg_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Nu gakkuruwa ammurak, ammuyu payi Ama. E mangiyafu sito ingkein, gakkuruwa ammuyun anna initayun.” ");
INSERT INTO gdg_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Wasinoy, sinapiti Felipe si, “Afu, ipaitammaddi Amam sikwami ta matalanggaggami.” ");
INSERT INTO gdg_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","E sinabbi Jesus si, “Felipe, nabayak sikwayu, gampade ammenak kepay inammu? Ino nangita sikwak, initanangkappayi Ama. Ansannu kappay sapitan si ipaitaki Ama sikwayu? ");
INSERT INTO gdg_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Ma, ammem kuruwan si anak ki Ama e ana kappayi Ama sikwak? Amminino sinapikku sikwayu, bakkanna naggabwat sino nakangkungkepay, nu ammena lud naggabwat ki Ama. Ammingkappaya akwangku, nepakwa i Ama a ana sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Kuruwandonad si anak ki Ama e ana i Ama sikwak. Nu ammeyu kuruwan gafu sino sapitangku, kuruwandonad gafu sino kakkaꞌbawira a akwangku. ");
INSERT INTO gdg_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Gakkurug yo sapitangku sikwayu, massiki inyeno mangurug sikwak, akwanna kappayino kakkaꞌbawa akwangku. E ooddu kappayino damana a akwan amma sino inangwak, gafu se muliyaꞌnga ki Ama. ");
INSERT INTO gdg_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","E massiki sanneno arangngandaw ki Ama gafu sino nittatandaw sikwak, akwangku takesi madayawi Ama mappeafu sino akwangkuwa Abbingnga. ");
INSERT INTO gdg_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Massiki sanneno arangngandaw sikwak gafu sino annalaꞌdaw sikwak, akwangkuwa akwan.” ");
INSERT INTO gdg_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Wasinoy, sinubburani Jesusino sapitanna si, “Nu gakkuruwa anggandak, akwandawino sapitangku. ");
INSERT INTO gdg_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","E arangngangku ki Ama ta manundun si mepatali sikwaka manuffun sikwayu ta antuweno magyan sikwayu si makkikiyad. Ino Espirituneno anggangkuwa sapitan, e antuweno mangipakaammu sikwayu sino kakuruwan. ");
INSERT INTO gdg_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ino tolayira a ammera mangurug sikwak, ammera dama a maaꞌdan sino Espirituwi Dios, se ammera maimunuwan anna ammera maammuwan. Udde ikkayu, ammuyun, se araꞌniyen sikwayu e magyanna sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Massiki anawantakayu, ammetakayu purayan se muliyaꞌnga kappay sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ammena mabayag e ammerakunna itanino ammera mangurug sikwak sito lubag, udde ikkayuwa mangurug, itandaꞌnga kappay. E gafu se mabiyayak kappena, mabiyaggayu kappay si makkikiyad. ");
INSERT INTO gdg_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Nu madaꞌnganenaya aw, antuneno pangammuwandaw si anak ki Ama, anakayu sikwak, e anak kappay sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Ino tolaya maningngag sito sapitangku e kuruwanna, antuweno manggam sikwak. E ino manggam sikwak, anggammampayi Ama. E anggammangku kappepay, e ipakaammuk ammin sikwaneno mappeafu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Wasinoy, sinapiti Judas (bakkanni Judas Iscariote) si, “Afu, mayan ikkami pelangino pappakaammuwannu mappeafu sikwam a bakkan lud sino amminira a tolay sito lubag?” ");
INSERT INTO gdg_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","E sinabbi Jesus si, “Ino manggam sikwak, akwanneno sapitangku, e anggammanni Ama. Kunnantu, ikkami anni Ama, umangkami magyan sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Udde ino tolaya amme manggam sikwak, ammena akwanino sapitangku. Ammena naggabwat sikwakino netulduka diningngaddaw, nu ammena lud naggabwat ki Ama a nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Sapitangkuwera ammin yaw sito ayawak kepay sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Udde dundunanna i Ameno Espirituna a manuffun sikwayuwa mangipakaammu mappeafu sikwak. Antuneno manuldu sikwayu si ammina ammeyu kepay inammu anna ipadandammana sikwayuweno ammina sinapikku. ");
INSERT INTO gdg_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ammekayu maddararan anna mattalaw, se passiyanakkangkuweno nakandaw. Ino siyanaꞌnga nakamma iyaꞌdak sikwayu, bakkannino kunnino tolayira sito lubag, nu ammena lud mekunna sino nasiyanakka nakangku. ");
INSERT INTO gdg_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Diningngaddawino sinapikkuwa anawantakayu udde muliyaꞌnga kappay sikwayu. Nu gakkuruwa anggandak, maanggangkayu nad, se umangngak ki Ama a napatig amma sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Dadanangkuwa sapitan yaw sikwayu, takesi nanu makwa, mattuyaggino angnguruddaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Ammek bayannino makitatabbag sikwayu, se gumamwanginni Satanas a antuweno matturay sino tolayira sito lubag. Awana kalintiyanna sikwak, ");
INSERT INTO gdg_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","udde purayangku sino akwanna sikwak takesi maammuwan amminino tolayira si anggangkuwi Ama e akwangku amminino ipakwana sikwak. “Ara, intamun ta umanawetamun sitaw.” ");
INSERT INTO gdg_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Wara sinoy, sinapikkappayi Jesus si, “Ikkanakino gakkuruwa fungalla ubas e i Ameno mimut. ");
INSERT INTO gdg_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Ariyanna ammina tangaka ammena mammunga, udde ino tangakira a mammunga, ariyanneno korwana garangona a kunnangke dalusannera takesi umodduweno bungara. ");
INSERT INTO gdg_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Kakunnayuweno tangakira a mammunga se nadalusangkayu gafu sino sinapikkuwa nattalaginad sino nakandaw. ");
INSERT INTO gdg_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Mattalaginaggayu sikwak ta mattalaginarappay sikwayu. Ino tanganeno ubas, ammena mammunga nu naari sino fungalna. Kakunnayu kappay, ammekayu mammunga nu ammekayu mattalaginad sikwaka fungalla ubas. ");
INSERT INTO gdg_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Ikkanakino kunnangke fungalla ubas e ikkayuweno kunnangke tangakira. Ino mattalaginarira sikwak, anappay sikwara, e mammungera si oddu. Udde nu awanak sikwayu, ammekayu makaangwa si nalawad. ");
INSERT INTO gdg_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ino tolaya ammena mattalaginad sikwak, metakkufa kunnangke naariya tanga. Nu maganguwen, amunganda, kasera iramba sino afuy ta masikkulan. ");
INSERT INTO gdg_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Udde nu mattalaginaggayu sikwak anna aggadandammandawino sinapikku e akwandaw, massiki sanneno arangngandaw ki Ama, iyaꞌdana sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Nu mammungakayu si oddu, antuweno kedayawani Ama e antu kappayino mangipaita si gakkuruwa ikkayuweno adalangku. ");
INSERT INTO gdg_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Anggammantakayu a kunnangke ino agganggammi Ama sikwak. Mattalaginaggayu nad sikwak takesi maammuwandawino agganggangku sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Nu akwandawino sapitangku sikwayu, maammuwandawino agganggangku sikwayu. Kakunnana kappay sikwak, akwangku ammina sapitanni Ama, e maammuwangkunnino agganggamma sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Sinapikkuwera yaw sikwayu takesi mallanggakkayungke a kunna pay sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Antuyawino itungku sikwayu, makkaaanggangkayu a kunna payino agganggangku sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ino kadodokkallana agganggamma dama a ipaiteno tata tolay, nu matay takesi mabiyayino bafulunnera. ");
INSERT INTO gdg_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","E ikkayuweno bafulungku nu akwandawino sapitangku sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Sitoya, ammetakayu nganan si aripan, nu bakkan lud buluntakayu. Se ino aripan, ammena inammuweno dinandammino amuna, udde ammina diningngaggu ki Ama, sinapikku ammin sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Bakkanna ikkayuweno namili sikwak, nu ammena lura ikkanakino namili sikwayu e dinotukantakayu takesi mammungakayu si oddu, e mabbalanayun naddino bungayuwa nalawad. Kunnantu, massiki sanneno arangngandaw ki Ama gafu sino nittatandaw sikwak, iyaꞌdana sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Antu kappay yawino itutungku sikwayu, makkaaanggangkayu nad.” ");
INSERT INTO gdg_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Wasinoy, sinapikkappayi Jesus si, “Kababannaddakayuneno tolayira a ammera mangurug sikwak, udde ammekayu nad makkaꞌbaw sinay, nu ammeyu lud dandamman si kinababannaddak abbu. ");
INSERT INTO gdg_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Nannud nekunneno nakandaw sikwara a ammena mangurug, anggammandakayu nad se kakunnarakayu. Udde bakkanninna kakunnarakayu se pinilitakayuwa mekatway sikwara, e antuweno gafuna a kababannaddakayu. ");
INSERT INTO gdg_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Dandammandonaddino sinapikku sikwayuwa awana aripanna napatig amma sino amuna. Nu nelopalopeꞌdak, ilopalopeꞌdakayu kappena. Nu ammera kinuruwino sinapikku, ammera kappena kuruwannino sapitandaw. ");
INSERT INTO gdg_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Akwandana ammin yaw sikwayu, gafu sino nittatandaw sikwak, se ammera ammuweno nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Nannud ammek inang sitawa nanuldu sikwara, bakkan nadda liwaꞌdeno ammera panguruwan sikwak. Udde gafu se ginamwangak, awana parrasonda sino liwaꞌda. ");
INSERT INTO gdg_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Ino makkababannag sikwak, kababannangnga kappayi Ama. ");
INSERT INTO gdg_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Bakkan nadda liwaꞌdeno ammera panguruwan sikwak, nu awan nadda nepaitak si kakkaꞌbawa awana korwan si makaangwa. Udde massiki initareno inangwak, kababannaddakami anni Ama. ");
INSERT INTO gdg_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Udde nakwa yaw, takesi meyakkuruwino neturak sino lintidda a kunna si, ‘Kababannaddak, massiki awana gafuna.’ ” ");
INSERT INTO gdg_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","E sinapikkappayi Jesus si, “Dundunangkuneno Espiritu a maggabwat ki Ama a manuffun sikwayu. Antuneno mangipakaammu sino kakuruwan mappeafu ki Dios, e taꞌdaggandak kappena. ");
INSERT INTO gdg_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Massiki ikkayu kappay, taꞌdaggandaꞌnga se kiyad sin nangiyafuwangkuwa manuldu, nebumbulungkayu sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Dinadangkuwa sinapit sikwayu yaw takesi ammekayu mapaꞌlatan sino makwana sikwayu e ammeyu ibbattanino angnguruddaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Se ammerakayuna ibilang si bafulunda a Judyu. E madaꞌnganeno awa ino mamapatay sikwayu, nganannana si nalawara passerbina ki Diosino akwanna. ");
INSERT INTO gdg_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Kunnanenayino akwanda gafu se ammerakami ammu anni Ama. ");
INSERT INTO gdg_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Dinadangkuwa sinapit yaw sikwayu takesi nanu akwanda sikwayu, madandandaw si sinapikkun sikwayu.” Sinubburangkappayi Jesusino sapitanna si, “Ammek sinapit yaw sikwayu siꞌin se nagyanak kepay sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Udde sapitangkun sikwayu sito ingkein se gauuliyakun sino nanundun sikwak. Udde mayan awaningke sikwayuwa mabbebut nu sintawino angangku? ");
INSERT INTO gdg_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","On, se malowino nakandaw sino sinapikku. ");
INSERT INTO gdg_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Udde gakkuruwino sapitangku sikwayu, pallawarandokappay nu umanawak. Se nu ammek umanaw, ammena dama a gumamwangino manuffun sikwayu. Udde nu umanawak, dundunangkuna sikwayu. ");
INSERT INTO gdg_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nanu gumamwang, ipakaammuna sino tolayira si nabbakabakkannino annandanda mappeafu sino liwat. Ipakaammuna kappay si nabbakabakkannino annandanda mappeafu sino kinagaddangku andino pangukumanna i Dios sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Mappeafu sino liwat, ipakaammuna si liwaꞌdeno ammera nanguruwan sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Mappeafu sino kinagaddangku, ipakaammuna si gakkuruwa naggaddangngak. Ino pangammuwanda, umangngak ki Ama e ammerakunna maita. ");
INSERT INTO gdg_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Mappeafu sino pangukumani Dios sino tolayira, ipakaammuna si naukumin e makastiguna i Satanas a turayino ammera mangurug. ");
INSERT INTO gdg_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Oddu kappenaddino anggangkuwa ituldu sikwayu, udde madyakkepaya dandammandaw. ");
INSERT INTO gdg_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Udde kadde, se nanu gumamwangino Espirituwi Dios a mangipakaammu sino kakuruwan, antuneno mifuyut sino nakandaw ta maammuwandaw amminino kakuruwan. Ino sapitanna, ammena maggabwat sino nakammangkepay, nu ammena lud sapitannino diningngangnga ki Dios. E ituldunana kappay sikwayuweno makwa so maddagguna aw. ");
INSERT INTO gdg_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Madayawak gafu sikwana, se idutungngana sikwayuweno anggangkuwa ipakaammu. ");
INSERT INTO gdg_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Ammina akwi Ama, akwak kappay, antu gafuna a sinapikku si ino anggangkuwa ipakaammu ino idutungnga sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Wasinoy, sinapikkappayi Jesus si, “Ammena mabayag e ammerakunna itan, udde ammena kappay mabayag e itandak kappena.” ");
INSERT INTO gdg_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Ino korwanira a adalanna, nakkakibikibebutira si, “Sanneno anggamma sapitan? Kunna si ammena mabayag e ammetam maita e ammena kappay mabayag e itantamma kappay. E kunna kappay si gafu se umang ki Amana. ");
INSERT INTO gdg_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Sanneno anggamma sapitannino ammena mabayag? Ammetam maꞌlud maawatan.” ");
INSERT INTO gdg_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Ammuwi Jesus si angganda a mabbebut sikwana, antu gafuna, sinapiꞌna sikwara si, “Ma, makkakibikibebukkayu mappeafu sino sinapikkuwa ammena mabayag e ammerakunna itan e ammena kappay mabayag e itandak kappena? ");
INSERT INTO gdg_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Gakkurug yo sapitangku sikwayu, mattangikkayu anna mabbinungakayuna, udde maanggammeno tolayira a ammera mangurug sikwak. Malowingke ino nakandaw, udde mapataliyanna si nappelalota langgak. ");
INSERT INTO gdg_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ino keampariyanna, ino bafaya gaaanak. Maddararan se nadaꞌngennino panakanna. Udde nanu mallawanino kaluꞌbit, kalyawannaneno lona, se maanggammingke gafu sino kaluꞌbit. ");
INSERT INTO gdg_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Kunna kappay sikwayu, malowino nakandaw sito ingkein. Udde makkaititetamma kappay, e nappelaloꞌneno langgaꞌdaw. E awanna makaari sinaya langgaꞌdaw. ");
INSERT INTO gdg_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Nanu madaꞌnganenaya tiyempo, awanin nadda ibebuꞌdaw sikwak. Gakkurug yo sapitangku sikwayu, massiki sanneno arangngandona ki Ama, iyaꞌdanana sikwayu gafu sino nittatandaw sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Makkiyad sito ingkein, awangkepay inarandaw gafu sino nittatandaw sikwak. Sitoya, marangkayu ta maaꞌdangkayuna takesi maanggangkayungke.” ");
INSERT INTO gdg_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Wasinoy, sinubburani Jesusino sinapiꞌna si, “Amminino sinapikku sikwayu, passiya ampariyino nepassapikku. Udde madaꞌnganeno awa ammek iyampariyino sapitangku sikwayu, nu ammek lud sapitanningke a ipakaammu sikwayuweno mappeafu ki Ama. ");
INSERT INTO gdg_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Nanu madatangngenoya aw, antuneno parangngandaw gafu sino nittatandaw sikwak. Bakkannaꞌngaddino marang ki Ama para sikwayu, ");
INSERT INTO gdg_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","se anggammandakayuwi Ama, gafu se anggandak anna kuruwandokappay si naggabwatak sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Gakkuruwa naggabwatak ki Ama e inangngak sito lubag, e sitoya, anawangku yo lubag ta muliyak ki Ama.” ");
INSERT INTO gdg_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Waso kunnenoy, sinapitino adalannera si, “Itannu, maawatamminnino sinapiꞌnu se ammemun neyamparig. ");
INSERT INTO gdg_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Sitoya, ammumin si ammum ammin. Massiki ino ana sino nakammiya ibebuꞌmi nad sikwam, ammumun. Antuweno panguruwammi si naggabwakka ki Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Sinapiti Jesus si, “Manguruggayun? ");
INSERT INTO gdg_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Se araꞌniyennino tiyempowa makakaratwekayu. Tatatata sikwayuweno umang sino balenangkepay, e matakak. Udde ammek gakkuruwa matak, se kanayuna ana i Ama sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Sinapikku yaw sikwayu takesi massiyanakkino nakandaw gafu sino nittatandaw sikwak. Padyatandakayuneno tolayira a ammera mangurug sikwak, udde pattuyaggandonaddino nakandaw, se inaffukkunnino matturay sito lubag.” ");
INSERT INTO gdg_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Wasin sinapiti Jesus sinoy, sinangaw sey langita mikararag si, “Ama, nadaꞌngennino tiyempok. Ipaitamino kedayawangkuwa Abbingngu takesi ipaitak kappeneno kedayawannu. ");
INSERT INTO gdg_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Se neyaꞌdam sikwakino kalintiyana matturay sino ammina tolay, takesi aꞌdangku si biyaya mannayunino ammina tolaya netalaꞌngu sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","E antuyawino biyaya mannayun, ino pangammuwanda sikwam a tata ke a gakkuruwa Dios annino pangammuwanda kappay sikwak a Jesu Kristo a dinundunnu. ");
INSERT INTO gdg_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Nepaitak sito lubaggino kedayawannu, se inangwak amminino nepakwam sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Sitoya, Ama, pulindak sitan agyanannu takesi medayawak kappay a kunneno nedayawangku sin nagyanangku sikwam sin ammena kepay naparatu yo lubag.” ");
INSERT INTO gdg_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Ino tolemira a pinilim sito lubagga netalaꞌngu sikwak, nepakaammuk sikwareno kinadiosnu. Tolemira, e netalaꞌnguwera sikwak. Kinuruddeno sinapiꞌnu, ");
INSERT INTO gdg_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","e sitoya, naammuwandan si ikkeno naggabwatanino ammina inangwak anna sinapikku. ");
INSERT INTO gdg_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Se kinuruddeno netulduk sikwara a sinapiꞌnu sikwak, e ammuran si ikkeno naggabwatangku anna ikkeno nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Ino ikararangku, bakkanna ammina tolay, nu ammena lurino tolayira a netalaꞌngu sikwak, se akwamira. ");
INSERT INTO gdg_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Ammina akwak, akwamira kappay, e ammina akwam, akwakira kappay, e madayawak gafu sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Sitoya, anawangku yo lubag e muliyak sikwam, udde ino tolayira a netalaꞌngu sikwak, matakira sito lubag. Ikka a nadiosana Ama, imutannuwera sino pannakadamam takesi mittateno nakanda a kunna payino nakanta. ");
INSERT INTO gdg_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Sin agyanangku sikwara, inimukkuwera gafu sino pannakadamama neyaꞌdam sikwak. Awaningke sikwara a nekatway sikwak, fera pelangino tata a manggamma mekatway, takesi meyakkuruwino neturak sino sapiꞌnu. ");
INSERT INTO gdg_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Sitoya, araꞌniyennino puliyangku sikwam. Antu gafuna, sapitangku yaw sikwam takesi dingngaggandera liyekira a anawan takesi maanggammirangke a kunna pay sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Netulduk sikwareno ammina sinapiꞌnu sikwak, antu gafuna a kababannireno tolayira a ammera mangurug sikwak, se nekunnera sikwaka tangananino nakanda sino nakammeno ammera mangurug. ");
INSERT INTO gdg_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ammek arangngan si iyanomira sito lubag, nu ammek lud arangngan si imutannuwera takesi ammayira affutanni Satanas. ");
INSERT INTO gdg_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Se amme nekunneno nakanda sino nakammino tolayira a ammena mangurug, se nekunnera sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Gafu sino sapiꞌnuwa kakuruwan, ilasinnuwera sino narakkat takesi akwanda pelangino panggammannu, se passiya gakkuruwino sapiꞌnu. ");
INSERT INTO gdg_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Dundunangkuwera si umang manuldu sino sapiꞌnu sino tolayira sito lubag a kunna payino nanundunannu sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Iyaꞌdak sikwamino baggik ta matayak para sikwara takesi melasinira sino narakkat ta akwanda pelangino panggammannu.” ");
INSERT INTO gdg_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Bakkampelang yo adalangkuwereno ikararangku, nu ammena lud amminirana a mangurug sikwak gafu sino ituldura mappeafu sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Ama, ikararaggu si mittata naddino nakanda a kunna payino nakanta, takesi kuruwannino tolayira si ikkeno nanundun sikwak. Mittatera nad sikwata a kunneno anak sikwam anna anaka sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Neyaꞌdak sikwareno pannakadama a neyaꞌdam sikwak, takesi mittateno nakanda a kunna payino nakanta. ");
INSERT INTO gdg_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Anak sikwara e anaka kappay sikwak takesi mittatengke ino nakanda, takesi maammuwanino tolayira sito lubag si ikkeno nanundun sikwak, e maammuwanda kappay si nekunneno agganggammu sikwara sino agganggammu sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Ama, anggangku si ino tolayira a netalaꞌngu sikwak, mesapatira sikwak sey langit ta itandeno kinadiosku. Inaya kinadiosku, neyaꞌdam sikwak se inanggammannak sin ammena kepay naparatu yo lubag. ");
INSERT INTO gdg_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","“Ama a naggaddang, ino ammera mangurug sikwak, ammeraka inammu. Udde ammutaka, e iyawira a adalangku, ammura si ikkeno nanundun sikwak. ");
INSERT INTO gdg_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Se nepakaammuk sikwareno kinadiosnu, e pakadadagganangkuweno ipakaammuk sikwara takesi makkaaanggammira a kunna payino agganggammu sikwak, e anaꞌnga sikwara si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Wasin nasinduwenni Jesus a nakkararag, inanawira andino adalannera e naddammangira sino alungunga Kidron. Aneno nafudduka kayuwa olibo sinay, e antuweno inangnganda. ");
INSERT INTO gdg_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","I Judas a nilaku ki Jesus, ammuneno agyananda se dayandana umanda Jesus andino adalannera sinay. ");
INSERT INTO gdg_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Antu gafuna, inangngi Judas sinaya nifuyut sino sindaluwera andino gwardiyana Templo a dinundunino pangafuwanirana padi andino Fariseowera. Nassirwatira anna narmasira. ");
INSERT INTO gdg_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Gafu se ammuwi Jesus amminino makwa sikwana, inangngera dinambal e sinapiꞌna si, “Inyeno tufukandaw?” ");
INSERT INTO gdg_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","E kunda si, “I Jesus a taga-Nazaret.” “Ikkanak,” kunni Jesus. I Judas a nilaku sikwana, nakitaꞌdag sino sindaluwera. ");
INSERT INTO gdg_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Assapiꞌlangi Jesus si “Ikkanak,” ninunurira e naletwarira. ");
INSERT INTO gdg_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Wasinoy, nebebukkappayi Jesus si, “Inya maꞌlurino tufukandaw?” E sinapiꞌda kappay si, “I Jesus a taga-Nazaret.” ");
INSERT INTO gdg_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","“Ikkanak kungkummangke sikwayu,” kunni Jesus. “Nu ikkanakino tufukandaw, ammeyu nad idagga yo bafulungkuwera.” ");
INSERT INTO gdg_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Antuweno sinapiꞌna takesi meyakkuruwino sinapiꞌna sino Amana si awaningke nawawan sino tolayira a netalaꞌnga sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","I Simon Pedro, agyanino saseꞌna, e sinuꞌnuꞌna, e binakangnga i Malco a aripannino afafuna padi, e nagingaranino diwanana layangnga. ");
INSERT INTO gdg_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Sinapiti Jesus ki Pedro si, “Iyalangngu yan saseꞌnu. Aringngu nalang si ammayangkuweno ipalawumi Ama sikwak?” ");
INSERT INTO gdg_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wasinoy, ino sindaluwera, ino kapitanda, andino gwardiyerana Judyu, dinoꞌmanda i Jesus e binaluddeno kamaꞌna. ");
INSERT INTO gdg_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Ino palunguwa niyangnganda i Anas a katuwangani Caifas a afafuna padi sinoya run. ");
INSERT INTO gdg_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","I Caifasino nassapit sino Judyuwera si unoyneno tata ke ino matay ta mabiyayino kalubbunannera. ");
INSERT INTO gdg_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Da Simon Pedro annino tata kappaya adalani Jesus, dinandanira sikwana. Inaya bulunna, ammuneno afafuna padi, antu gafuna, nebulun ki Jesus a sinallung sino alasangngeno kalawatanna balay. ");
INSERT INTO gdg_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Udde i Pedro, natak sino lasin. E nuliyeno bulunna, e sinatabbangngeno bafaya mindag sino lamwangan nu dama i Pedro a sumallung, kasena nepatallung. ");
INSERT INTO gdg_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","E sinapitino bafay ki Pedro si, “Bakkangka kaggappayino adalannenaya tolay?” “Bakkan,” kunni Pedro. ");
INSERT INTO gdg_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Gafu se laꞌbat sinoy, nafuyino aripannira andino gwardiyera, e naggarenuwera. E inang kappayi Pedro a nakigarenu sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Wasinoy, ino dadana afafuna padiya i Anas, inimbistigarna i Jesus mappeafu sino adalannera annino tulduna. ");
INSERT INTO gdg_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","E sinabbi Jesus si, “Ammina netulduk, sinapikku so aꞌlangino tolayira. Kanayunaka manuldu sino pakkakarampattan amminino Judyu a sinagogara annino Templo. Awaningke a sinapikku si likilikud. ");
INSERT INTO gdg_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Mayan ikkanakino pabbebutannu a bakkannino tolayira a naningngag sikwak? Ira naddino pabbebutannu se inammureno sinapikku.” ");
INSERT INTO gdg_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Wasin sinapiti Jesus inoy, sinipangngino tata a gwardiya, e sinapiꞌna si, “Ansanna lang kunnayanino annabbangngu sino afafuna padi?” ");
INSERT INTO gdg_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","E sinapikkappayi Jesus sikwana si, “Nu wara narakkat sino sinapikku, sapitannu. Udde nu gakkuruwino sinapikku, mayan sinipangngak?” ");
INSERT INTO gdg_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Waso kunnenoy, nepeiyangi Anasi Jesus a aggabalud ki Caifas a afafuna padi. ");
INSERT INTO gdg_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","I Pedro, agyangkepay sinaya maggarenu, e nabbebutino korwanira sikwana si, “Bakkangka kaggappayino tata adalannenaya tolay?” “Bakkan,” kungkappayi Pedro a neimad. ");
INSERT INTO gdg_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Ino tata a aripannino afafuna padi, a wayi kappayino giningarani Pedro, sinapiꞌna si, “Bakkangka kaddino tata a initaka mamumbulun sikwana sino fudduk?” ");
INSERT INTO gdg_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Udde neimaggappayi Pedro, e nassirallotinnino lalung. ");
INSERT INTO gdg_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Waso gigiꞌbattin, neanawino pangafuwanirana Judyuwi Jesus sino balayi Caifas, e neyanda sino balayi Gubernador Pilato. Udde ammera sinallung sino balena gubernador, gafu sino gagangera a nu sumallungira sino balena bakkanna Judyu, ammera dama a makikkan sino fiyestana Laꞌwutan se mebilangira a nadakkut. ");
INSERT INTO gdg_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Gafu sinoy, nallawani Gubernador Pilato a nakitatabbag sikwara, e sinapiꞌna si, “Sanneno ipaliwaꞌdaw sitana tolay?” ");
INSERT INTO gdg_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","E sinabbino pangafuwanira si, “Nu bakkan nadda minalliwat, ammemi nad neyang sikwam.” ");
INSERT INTO gdg_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","E sinapiti Pilato sikwara si, “Ikkayu pelangino makammu, ukumandawingkepaya metuntul sino lintiddaw.” E sinabbadda si, “Udde ikkamiya Judyu, awana kalintiyammiya mamapatay si tolay.” ");
INSERT INTO gdg_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Kunnenoyino nakwa takesi meyakkuruwino sinapiti Jesus mappeafu sino ipatena. ");
INSERT INTO gdg_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Waso kunnenoy, sinallung kappayi Pilato sino balena, e nepaayangnga i Jesus. E nebebuꞌna si, “Ikkeno Arina Judyu?” ");
INSERT INTO gdg_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","E sinabbi Jesus si, “Iyana ibebuꞌnu, naggabwakkad sino nakammu onnu wara korwana nassapit sikwam?” ");
INSERT INTO gdg_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","E sinapiti Pilato si, “Ma, aringngu si Judyuwak? Ino kalubbunannu andino pangafuwanirana padiyu, ireno nangidarum sikwam sikwak. Sanna maꞌlurino liwaꞌnu?” ");
INSERT INTO gdg_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","E sinabbi Jesus si, “Ino kinaturek, tanganan sino turayira sito lubag. Se nannud ariyak sito lubag, nakiyubaꞌnaddino tolekira takesi ammeraꞌngad dinoꞌmanino Judyuwera. Udde ino kakuruwanna, bakkan sito lubaggino naggabwatanino kinaturek.” ");
INSERT INTO gdg_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","“Nu kunnenoy, arika mantu?” kunni Pilato. E sinapiti Jesus si, “Ikkeno nassapit si ariyak. Ino gafuna a inangngak sito lubagga neyanak, takesi ipakaammukino kakuruwan. Massiki inyeno manggam sino kakuruwan, dingngaggandeno sapitangku.” ");
INSERT INTO gdg_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","“Adasi wara kakuruwan?” kunni Pilato. Wasinoy, nallawangkappayi Pilato, e sinapiꞌna sino Judyuwera si, “Awaningke a naammuwangku si liwaꞌna. ");
INSERT INTO gdg_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Udde aneno gagangeyuwa kadda fiyestana Laꞌwutan, wara ilawangku si tata balud. Anggandomantu ta pallawanangkuweno ariyuwa Judyu?” ");
INSERT INTO gdg_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","“Bakkan yan! I Barrabasino anggammiya ilawannu,” kunda a nekulawu. I Barrabas, gumattakawa nangontara sino gubiyernu. ");
INSERT INTO gdg_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Waso kunnenoy, nepasiwaꞌwatti Pilatowi Jesus sino sindalunera. ");
INSERT INTO gdg_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","E binalikokawandeno nasasit, e nesingaꞌda ki Jesus a kunnangke koronana, kasera kappay nepabbarawasi si nalibaga a kunnangke barawasina ari. ");
INSERT INTO gdg_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","E nappatapataliyera a inaraꞌni sikwana a nassapit si, “Madayoka nadda Arina Judyu,” e sinipasipanda. ");
INSERT INTO gdg_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Wasinoy, nallawangkappayi Pilato, e sinapiꞌna sino Judyuwera si, “Itandaw, ipaaꞌlangkuna sikwayu takesi maammuwandaw si awana ammuk si liwaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","E nallawani Jesus a nasingatan si asit anna nabbarawasi si nalibaga. E sinapiti Pilato sikwara si, “Itandaw yawa tolay.” ");
INSERT INTO gdg_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Wasin initeno pangafuwanirana padi andino gwardiyera i Jesus, nekulawura si, “Papatayannun! Ilansam si krus!” Udde sinapiti Pilato sikwara si, “Ikkayungkepemantuweno milansa sikwana si krus, se nu ikkanak, awana ammuk si liwaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","E sinapitino Judyuwera si, “Udde aneno lintimmi, e gafu sinaya lintig, matenad, se sinapiꞌna si antuweno Abbingi Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Wasin diningngaggi Pilatowenaya sinapiꞌda, nangkakatalaw. ");
INSERT INTO gdg_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","E sinallung kappay sino balena e nebebuꞌna ki Jesus si, “Sintomaꞌlurino naggabwatannu?” Udde amme sinabbi Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","“Mayan ammeka sumabbag?” kunni Pilato. “Ammengkad ammu si aneno kalintiyangkuwa mangipalawan sikwam onnu mangipalansa sikwam si krus?” ");
INSERT INTO gdg_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","E sinabbi Jesus si, “Awana kalintiyannu sikwak nu amme nad neyaꞌda i Dios. Antu gafuna, ino nangiyalawat sikwak sikwam, nadammattino liwaꞌna amma sikwam.” ");
INSERT INTO gdg_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Wasin diningngaggi Pilato inoy, anggammangkein si ipalawanna i Jesus. Udde ino Judyuwera, nekulawuramman a nassapit si, “Nu pallawanannu yan, gakkuruwingke si ammem taꞌdagganino Emperador, nu bakkan lurino kalingana. Se massiki inyeno massapit si ariyeno bagginangkepay, mekontara sino Emperador.” ");
INSERT INTO gdg_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Wasin diningngaggi Pilatowenaya nekulawura, nepalawanna i Jesus sino balena, kasena inang nattuttud sino attutturanna ukum. Inaya attutturanna ukum, agyan sino natuping si batuwa mingngan si Gabata sino damiꞌna Judyu. ");
INSERT INTO gdg_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Sin nattutturanna sinay, araniꞌyen si tangnganaw sino awa pidadananino Judyuwera para sino fiyesta. Sinapiti Pilato sino Judyuwera si, “Antuyawino ariyu.” ");
INSERT INTO gdg_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Udde neangkakulawura si, “Papatayannun! Papatayannun! Ilansam si krus!” E nebebuti Pilato sikwara si, “Anggandaw ta pelansakino ariyu si krus?” E sinabbino pangafuwanirana padi si, “Awana korwan si arimi nu bakkampelangino Emperador.” ");
INSERT INTO gdg_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Antuweno neyalawatimpelangi Pilatowi Jesus sikwara ta melansara si krus. ");
INSERT INTO gdg_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Wasinoy, inappennino sindaluwera i Jesus, e nepabuttundeno krusna, e neyanda sino kulura ngananda si Agyananna Takataꞌnga Ulu, a Golgoteno nganna sino damiꞌna Judyu. ");
INSERT INTO gdg_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Antuwenayino nilansanda ki Jesus sino krus. E agyangkappayino adwera a lalaki a nelansara sino krusdera, e nepattangara i Jesus sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Aneno neturakki Pilato a nepeekwana sino krusi Jesus a kunna si, “I Jesus a taga-Nazaret, ino Arina Judyu.” ");
INSERT INTO gdg_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Odduwa Judyuweno nakabasa sinoy se araꞌniyeno nilansanda ki Jesus sey Jerusalem, e neturak sino damiꞌna Judyu, Roma, anna Griego. ");
INSERT INTO gdg_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Antu gafuna a inangngino pangafuwanirana Judyu ki Pilato e sinapiꞌda si, “Pataliyannuweno neturaꞌnguwa ‘Arina Judyu,’ takesi ituraꞌngu si, ‘Sinapiꞌna si antuweno Arina Judyu.’ ” ");
INSERT INTO gdg_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Udde netabbi Pilato si, “Ino neturakkun, ammenan maangkakwa.” ");
INSERT INTO gdg_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Wasin nelansennino sindaluwera i Jesus, inappareno barawasina e ginaradwara a appat. E inappara kappayino ataꞌnanga barawasina a awana natubburanna. ");
INSERT INTO gdg_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","E nattatarabbanda si, “Nalawad nu ammetam pissayan, ta pabbabinnunutantam ta itantam nu inyeno makangkwa.” E antuweno inangwara. Kunnenoyino nakwa ta meyakkuruwino nepeturakki Dios a kunna si, “Ginaradwareno barawasik, e nabbinnunutandeno barawasika ataꞌnang.” ");
INSERT INTO gdg_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Agyanino aggataꞌdag sino idangngeno krusi Jesus, a ino inana, ino kolakino inana, i Maria a atawa i Cleofas, anni Maria Magdalena. ");
INSERT INTO gdg_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Inita i Jesusino adalana iiddukanna a aggataꞌdag sino idangngeno inana, e sinapiꞌna ki inana si, “Ina, ibilangngu yan si abbingngu.” ");
INSERT INTO gdg_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Kasena nekun sino adalanna si, “Ibilangngu yan si inam.” E makkiyad sinoy, inayanino adalani Maria a makiigyan sino balena. ");
INSERT INTO gdg_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Wasinoy, ammuwenni Jesus si inangwanan amminino nepakwa i Dios sikwana, e sinapiꞌna si, “Mauwawak,” takesi meyakkuruwino nepeturakki Dios. ");
INSERT INTO gdg_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Aneno malukung sinaya napannu si kilam. Nesosawino sindaluwera si manusup sinaya tayug, kasera nebabbad si kallakayuwa hisopo, e netayadda ta sussupanni Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wasin sinussupi Jesus inoya tayug, sinapiꞌna si, “Neyakkuruwin.” E nalluntay se natayin. ");
INSERT INTO gdg_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Ino pangafuwanirana Judyu, inangngira ki Pilato ta arangnganda si pabanduna sino sindaluwereno takkiyeno nelansarera takesi malanira a matay e maariyennino baggira sino krusda. Antuweno inangwara se ino metufara awino awna aggimwangan, e napatiyingke se meyindan sino fiyesta, e ammera anggam si agyangkepayino baggira sino krus. ");
INSERT INTO gdg_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Antu gafuna, inangngino sindaluwera, e binandureno takkiyeno adwera a nelansa sino krus so aruruwi Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Udde wasin nadaꞌngara i Jesus, ammera binanduweno takkina, se initara si natayin. ");
INSERT INTO gdg_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Udde ino inangweno tata a sindalu, nedukkalneno sayyangnga sino kanawiti Jesus, e nallawaninnino ada anna danum. ");
INSERT INTO gdg_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ino nakaita sitawa nakwa, taꞌdagganneno kakuruwanna takesi manguruggayu pay. Gakkuruwino sapitanna se ammuneno nakwa. ");
INSERT INTO gdg_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Nakwa ammin inoy takesi meyakkuruwino nepeturakki Dios a kunna si, “Awana mabandu si massiki tata sino tulangnga.” ");
INSERT INTO gdg_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","E ana kappayino nepeturaꞌnga a kunna si, “Aggitandaneno dinukkalda.” ");
INSERT INTO gdg_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Wasin nabalinin inoy, agyani Jose a taga-Arimatea a inang ki Pilato ta arangnganneno baggiyi Jesus. I Jose, nangurug ki Jesus, udde ammena nepakaammuweno nanguruwanna se mattalaw sino pangafuwanirana Judyu. Nepurayi Pilato, antuweno inangnga inappeno baggiyi Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nebulun sikwana i Nicodemo, a antuweno tolaya inang nakitatabbag ki Jesus si tata gafi. Wasin inangngira, neyangkalini Nicodemo si tallufuluwa kilowa bambanguwa mirra anna aloe. ");
INSERT INTO gdg_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Inappareno baggiyi Jesus, e binaꞌbattanda si sinnuna naekwanan si bambangug, se antuweno gagangena Judyu nu mitanammira si natay. ");
INSERT INTO gdg_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Aneno nafudduka mula a araꞌni sino nilansanda ki Jesus. E ana kappayino bawuwa tanamma agweb sinaya awangkepay netanam. ");
INSERT INTO gdg_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Gafu se araꞌniyennino awna aggimwangan, anna araꞌniyenaya tanam, antuweno netanandani Jesus sinay. ");
INSERT INTO gdg_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Wasi gigiꞌbaꞌna Lingguwa lammuk kepay, inanda Maria Magdalena sino tanammi Jesus, e initana si naariyennino batuwa gagaluꞌneno tanam. ");
INSERT INTO gdg_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","E nalayawa inang sikwara Simon Pedro annino tata a adalana iiddukani Jesus, e sinapiꞌna sikwara si, “Inappareno baggiyeno Afutam sino tanamma, e ammemi inammuweno niyangnganda sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Antu gafuna, inanda Pedro annino tata a adalan sino tanam. ");
INSERT INTO gdg_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Nalayawira a adwa, udde natuyagga malayawino buluni Pedro amma sikwana, e inuntananna a ginamwang sino tanam. ");
INSERT INTO gdg_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","E inokabba nisirib sino tanam, e initaneno sinnuna nepamaꞌbaꞌda ki Jesus, udde ammena sinallung. ");
INSERT INTO gdg_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Wasinoy, ginamwangi Simon Pedro, e nangawwata sinallung sino tanam, e initaneno sinnuna nepamaꞌbaꞌda ki Jesus a newagga sinay. ");
INSERT INTO gdg_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","E initana kappayino sinnuna nepamabbadda sino uluwi Jesus a nalukuta nepassig sino nepamaꞌbaꞌda sino baggina. ");
INSERT INTO gdg_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Kasena pay sinallungino buluni Pedro, e initana kappay ammin, antuweno nanguruwanna si nangngangoliyi Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Udde ammera kepay naawatanino nepeturakki Dios a sapitanna si maawag si mangngangoliyi Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wasinoy, inanawinnino adwera adalan. ");
INSERT INTO gdg_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Udde i Maria Magdalena, natak sino tanamma makatangatangit. Wasin aggetangatangit, inokabba nisirib sino tanam, ");
INSERT INTO gdg_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","e aneno adwera a anghela initana a nabbarawasiyera si nafuraw. Aggatutturira sino newagganino baggiyi Jesus. Ino tata, nagyan sino nalunananna, e ino tata, nagyan sino kuyatanna. ");
INSERT INTO gdg_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","E sinapiꞌda sikwana si, “Sanneno itangiꞌnu?” E sinabbi Maria si, “Inappareno baggiyeno Afumi, e ammek inammuweno niyangnganda sikwana.” ");
INSERT INTO gdg_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Assapiꞌna lang sinoy, nabbaliwit, e initana i Jesus a aggataꞌdag sinay, udde ammena naimunuwan. ");
INSERT INTO gdg_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","E sinapiti Jesus si, “Sanneno itangiꞌnu? Inyeno tufukannu?” Ino dinandammi Maria, aringnga si antuweno gumaimut sino mulera sinay, antu gafuneno nassapitanna si, “Afu, nu ikkeno niyanaw sikwana, sapitannu nu sintawino niyangngannu sikwana ta angku appan.” ");
INSERT INTO gdg_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","“Maria,” kunni Jesus. E inaꞌlangi Maria sikwana a sinapiꞌna si, “Rabboni.” (Ino anggamma sapitan sino damiꞌna Judyu, Mesturu.) ");
INSERT INTO gdg_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Sinapiti Jesus si, “Ammerak iggamman, se ammek kepay nuli ki Ama. Umangngu lud ituldu sino kakkolakkuwera si muliyak ki Ama a Amayu kappay anna ki Diosku a Diosdokappay.” ");
INSERT INTO gdg_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Waso kunnenoy, inangngi Maria a netuldu sino adalanira si initana i Afu Jesus, e nepakaammuneno sinapiꞌna sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Wasi gafinenoya Linggu, nakkakarampattino adalanira i Jesus, e nealladdoreno balay se mattalawira sino pangafuwanirana Judyu. E kakaꞌmeng kelanga initara i Jesus a nakitaꞌdag sikwara, kasena nekun si, “Nasiyanaꞌngaddino nakandaw.” ");
INSERT INTO gdg_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Wasin sinapiꞌnenoy, nepaitaneno kamaꞌna andino kanawiꞌna sikwara. Maanggammingke ino adalannera se initareno Afura. ");
INSERT INTO gdg_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","E sinapikkappayi Jesus sikwara si, “Nasiyanaꞌngaddino nakandaw. Dundunantakayu a kunna payino nanundunani Ama sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Kasenera inallafan e sinapiꞌna si, “Maaꞌdangkayu si Espirituwi Dios, ");
INSERT INTO gdg_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","takesi nu inyeno ituldum si napakomanino liwaꞌna, pinakomaninni Dios. Udde nu inyeno ituldum si ammena napakomanino liwaꞌna, amme kappay pinakomani Dios.” ");
INSERT INTO gdg_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Wasin nappadda i Jesus sino adalannera, awan sikwara i Tomas a ngananda si Siping a tata sino karadwera a adalanna. ");
INSERT INTO gdg_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Antuweno sinapitino korwanira a adalan sikwana si initara i Afu Jesus. E sinapiti Tomas sikwara si, “Nu ammek itan anna giꞌnanino gafanna lansa sino kamaꞌna, anna nu ammek appanganino kanawiꞌna, ammekungke mangurug sitan.” ");
INSERT INTO gdg_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Waso metufara Linggu, nakkakarampakkappayino adalanira i Jesus, e agyani Tomas. Nealladdoreno kayatan, udde kakaꞌmeng kelang sinallungi Jesus a nakitaꞌdag sikwara. E sinapiꞌna si, “Nasiyanaꞌngaddino nakandaw.” ");
INSERT INTO gdg_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Kasena nekun ki Tomas si, “Itannu yo kamakku anna giꞌnannuweno pilaꞌna, appangannu kappay yo kanawikku. Ammeka maddaladudwa ta manguruggan.” ");
INSERT INTO gdg_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","E sinapiti Tomas si, “Ikkeno Afuk annino Diosku.” ");
INSERT INTO gdg_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","E sinapiti Jesus sikwana si, “Nanguruggan se initarak. Maanggammino manguruwira, massiki ammerak itan.” ");
INSERT INTO gdg_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Oddu kappayino kakkaꞌbawa senyala nepaita i Jesus sino adalannera a ammena neturak sitawa leburu. ");
INSERT INTO gdg_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Udde iyawira a neturak sitaw, neturakkira takesi kuruwandawa i Jesusino Kristo a Abbingi Dios. E nu manguruggayu sikwana, mabiyaggayu si makkikiyad gafu sino nittatandaw sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Wasin nallaꞌwutino pipidya a aw, nappadda kappayi Jesus sino adalannera sino dappiꞌneno bebaya Tiberias. Kunnayawino nepappaddana. ");
INSERT INTO gdg_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Nakkakarampaꞌda Simon Pedro, i Tomas a ngananda si Siping, i Natanael a taga-Cana a lubbunna Galilea, ino adwera a abbingi Zebedeo, annino adwera kappaya adalani Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","E sinapiti Simon Pedro sino bulunnera si, “Umangngak manigay.” E sinapiꞌda si, “Mangkami pay sikwam.” E nattakayira si abanga inang nanigay, udde awaningke inappara si pafafi. ");
INSERT INTO gdg_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Wasin galalattakinnino sinag, agyani Jesus a aggataꞌdag sino dappiꞌna bebay, udde ammera maimunuwan. ");
INSERT INTO gdg_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","E sinapiꞌna sikwara si, “Wara inappayu?” “Awaningke,” kunda. ");
INSERT INTO gdg_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","E sinapiꞌna sikwara si, “Tanandaw yan sigeyu sitan padiwananneno abang, ta wara maappayu.” E sinandeno sigera, e ammeran meaꞌdangino sigay gafu so kaodduweno kinannara. ");
INSERT INTO gdg_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Waso kunnenoy, ino adalana iiddukani Jesus, sinapiꞌna ki Pedro si, “Antuwenayino Afutam.” Wasin diningngaggi Simon Pedro inay, nabbarawasiyen se nalluꞌbung, e nakkangkama nallattu sino danuma umang ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ino korwanira a adalan, natakira sino abanga mamuꞌbut sino sigaya napannu sino kinannara. Ammena aroyuweno dappit se tatut si metro pelang. ");
INSERT INTO gdg_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Wasin ginaꞌdangira sino dappit, initareno lamisa netunu sino afuya narrarang, e ana kappayino tinapay. ");
INSERT INTO gdg_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","E sinapiti Jesus sikwara si, “Miyangkayu sitaw sino bawuwa kinannayu.” ");
INSERT INTO gdg_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","E nuliyi Simon Pedro sino abang, e neyaꞌdangnganino sigaya napannu si darokkalla lamis. Kadwatut si limafulu e talluweno kaodduna, udde massiki kunnenoyino kaodduna, ammena napissayino sigay. ");
INSERT INTO gdg_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","E sinapiti Jesus sikwara si, “Akkayun taw ta mindadanetamun.” Awaningke naturid sikwara a mappakibebut sikwana nu inya, se ammura si i Afu Jesus. ");
INSERT INTO gdg_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Wasinoy, inappa i Jesusino tinapay andino lamisira, e neyannena sikwara. ");
INSERT INTO gdg_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Antuweno piꞌluna a nappaddani Jesus sino adalannera kiyad sin nangngangoliyanna. ");
INSERT INTO gdg_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Wasin nasinduwerana nindadan, sinapiti Jesus ki Simon Pedro si, “Ikka Simon a abbingi Juan, dokallino agganggammu sikwak amma sino agganggandera?” E sinapiti Pedro si, “On, Afu, ammum si anggantaka.” E sinapiti Jesus si, “Nu kunnenoy, imutannuweno tolekira a kunnangke karnero.” ");
INSERT INTO gdg_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","E nepidwa i Jesus a sinapit si, “Ikka Simon a abbingi Juan, anggammak kad?” E sinapikkappayi Pedro si, “On, Afu, ammum si anggantaka.” E sinapiti Jesus si, “Nu kunnenoy, imutannuweno tolekira a kunnangke karnero.” ");
INSERT INTO gdg_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Nepiꞌluwi Jesus a nebebut si, “Ikka Simon a abbingi Juan, gakkurug kadda anggammak?” Malowino nakammi Pedro se namipiꞌluwenna nebebuti Jesus sikwana nu anggammanna, e sinapiꞌna si, “Afu, ammum ammin, e ammum si anggantaka.” E sinapikkappayi Jesus sikwana si, “Imutannu mantuweno tolekira a kunnangke karnero.” ");
INSERT INTO gdg_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Sinubburani Jesusino sinapiꞌna sikwana si, “Gakkurug yo sapitangku sikwam, sin kabbingngu, ikkangkepayino nabbarawasi e inangka sino aanggammu, udde nanu malakekan, isoꞌyannuweno kamaꞌnu e baluranda takesi iyandakana sino ammem anggamma angan.” ");
INSERT INTO gdg_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Sinapiti Jesus inoy se nipakaammuneno makwana ki Pedro so katayanna takesi antuneno kedayawani Dios. Wasinoy, sinapiti Jesus sikwana si, “Dumandangka sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Wasinoy, nabbaliwiti Pedro, e initaneno adalana iiddukani Jesus a dumandan sikwara. Antuwenayino adalana nassandig ki Jesus sin namuwafanda a nappakibebut sikwana nu inyeno milaku sikwana. ");
INSERT INTO gdg_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Wasin inita i Pedro inaya adalan, sinapiꞌna ki Jesus si, “Afu, sannaneno makwa sikwana?” ");
INSERT INTO gdg_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","E sinapiti Jesus sikwana si, “Nu anggangku si mabiyag kiyad sino puliyangku, awana biyangngu sitan. Dumandangka pelang sikwak.” ");
INSERT INTO gdg_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Gafu se sinapiti Jesus inoy, nadingngag amminino nanguruwira si ammena matay inaya adalan. Udde bakkanna kunnenoyino sinapiti Jesus, sinapiꞌna pelang si, “Nu anggangku si mabiyag kiyad sino puliyangku, awana biyangngu sitan.” ");
INSERT INTO gdg_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ikkanakino adalani Jesus a nassapitanna sinoy. Taꞌdaggangku si gakkuruwino neturak sitaw, se ikkanak kappayino nanurak sitaw, e ammumi si gakkurug amminino ana sitaw. ");
INSERT INTO gdg_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Odduweno korwanira a inangwa i Jesus a ammek neturak. Se nu meturakkira nad ammin, ammena nad dama a meekwa sito lubaggino leburuwa keturakkanda.");
INSERT INTO gdg_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","Sino pittana turakku sikwam Teofilo, sinapikku ammina inangwa i Jesus annino netulduna makkiyad sin nangiyafuwanna a nanuldu ");
INSERT INTO gdg_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","kiyad sin netulluwanna sey langit. Wasin ammena kepay netullu sey langit, aneno netulduna sino pinilinera a apostolna, e ino netulduna, naggabwat sino Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Wasin nabalininnino natayanna annino nangngangoliyanna, kanayuna mappadda sikwara si appatafuluwa aw, e odduweno inangwana a panguruwanda sino nangngangoliyanna. Sinoy kappaya tiyempo, nanuldu sikwara mappeafu sino patturayani Dios. ");
INSERT INTO gdg_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Wasin tata si aw, nakkakarampattira, e sinapiti Jesus sikwara si, “Ammekayu umanaw sito Jerusalem, ta taronandawino Espirituwi Dios a nekariyi Ama a iyaꞌdana sikwayu. Antuweno netulduk sikwayu siꞌin, si, ");
INSERT INTO gdg_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","‘I Juan, binawtisaranneno tolayira si danum, udde ammena mabayag e mabawtisarangkayuna sino Espirituwi Dios.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Wasin nakkakarampaꞌda Jesus annino apostolnera, nepakibebuꞌda sikwana si, “Afu, sito ingkeininnino pariyannu sino Romera a matturay sikwatam takesi ikkanetamma a Judyuweno matturekappay sito agyanantam?” ");
INSERT INTO gdg_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","E sinabbi Jesus si, “I Ama pelangino makammu nu sanneno makwana so maddagguna aw anna nu naansa a makwa, e ammena dama a ipakaammuna sikwayu. ");
INSERT INTO gdg_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Udde nanu gumamwangino Espirituwi Dios a magyanna sikwayu, ananeno pannakadama i Dios sikwayu, e ikkayuweno mangitaꞌdag sikwak. E itattulduyuneno ammuyu mappeafu sikwak sino tolayira sito Jerusalem, anna sino ammina korwana lulubbunna Judea anna Samaria, kiyad si ammina lulubbun sito lubag.” ");
INSERT INTO gdg_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Wasin sinapiti Jesus inay, netullu sey langit, e sinangora makkiyad si nalefangngan si dulam. ");
INSERT INTO gdg_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Wasin aggatangawanda kepayino netulluwanna sey langit, kakaꞌmeng kelang nappaddeno adwera a anghela nafurawino barawasira a nattaꞌdag sino arurudda. ");
INSERT INTO gdg_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“Ikkayuwa taga-Galilea,” kunda, “mayan aggatangokayu sey langit? I Jesus a initayuwa netullu sey langit, muli kappena so maddagguna aw, e ino netulluwanna a nebulun si dulam, kunna kappeneno aggulina.” ");
INSERT INTO gdg_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Wasinoy, inanawino apostolira sino kulura Olivo, e nuliyera sey Jerusalem, takilometroweno kaaroyuna. ");
INSERT INTO gdg_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Wasin ginamwangira sey Jerusalem, inangngira sino balaya pagyananda, e inunekira sino kwartu sino kalekay. Irara Pedro, Juan, Santiago, Andres, Felipe, Tomas, Bartolome, Mateo, Santiago a abbingi Alfeo, Simon a mingngan si Patriota se ikaloneno lubbunna, anni Judas a abbingnga korwana Santiago. ");
INSERT INTO gdg_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Amminirenay, dayandanira a mittata a makkararag, massiki ino bafabbayira a bulunda, pati i Maria a ina i Jesus, annino kakkolaꞌngera. ");
INSERT INTO gdg_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Aneno tata si awa nakkakarampattino manguruwira, e ino kaoddura, umang si kadwatut si adwafulu. Nattaꞌdaggi Pedro e sinapiꞌna si, ");
INSERT INTO gdg_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Kakkolakku, ammena dama si ammena meyakkuruwino nepeturakkino Espirituwi Dios ki David siꞌin mappeafu ki Judas a nifuyut sikwara a nanoꞌma ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Nebilangi Judas sikwamiya karadwa a apostol, se pinili kappayi Jesus a manuffun sino tarabafumi.” ");
INSERT INTO gdg_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","(Antuyawino nakwa ki Judas. Ino piraka tandanna sino narakkatta inangwana, neatangnga si lubag, e antuweno nappatayanna. Nadaꞌnag e nabattakino kuyungnga e nallawanino sinena. ");
INSERT INTO gdg_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Wasin naammuwanino taga-Jerusalemireno nakwa sikwana, nginandenaya lubag si Aceldama, ino anggamma sapitan, Lubagga Nebubbuwanna Ada.) ");
INSERT INTO gdg_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","E sinubburani Pedroweno sapitanna a, “Antuweno neturakki David siꞌin sino leburuna Salmo, ‘Maanawan naddino balena e awanin nadda magyan sinay.’ Ana kappayino neturakka kunna si, ‘Wara nad mepatali sikwana sino tarabafuna.’ ");
INSERT INTO gdg_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","“Kunna antu, pilintammaddino mepatali ki Judas a bulummiya mangitaꞌdag sino pangngangoliyani Afu Jesus. Ino nad pilintam, tata sino nebumbulunira sikwami sin kawara i Afu Jesus sikwatam makkiyad sin namawtisarani Juan kiyad sin netulluwani Jesus sey langit,” kunni Pedro. ");
INSERT INTO gdg_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Ino nakkakarampattira, nitulduwera si adwa a anganna lallaki ta pamiliyanda, da Matias anni Jose Barsabas a ngananda kappay si Justo. ");
INSERT INTO gdg_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Kasera nekararag si, “Afu Dios, gafu se ammumino nakammino ammina tolay, ipakaammum sikwamiyeno pinilim sikwara a adwa ");
INSERT INTO gdg_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","a mepatali ki Judas sino kinaapostolna, se inanawani Judasino tarabafuna e inang sino keannunganna a pagyanan.” ");
INSERT INTO gdg_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","E nabbubunutira nu inyeno napili sikwara a adwa, e i Matiasino napili, e antuweno nedagga sino kadwafulu si tata a apostolira. ");
INSERT INTO gdg_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Wasin nadatangngino awna Pentecostes, nakkakarampat amminino nanguruwira ki Jesus si tata a balay. ");
INSERT INTO gdg_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Kakaꞌmeng kelanga aneno diningngadda a unguwa naggabwat sey langita kunnangke ungungnga natuyagga bayabbag, e malitangngira ammin sino balaya nagyananda. ");
INSERT INTO gdg_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","E naitareno mallanga gatangnga afuya nawwarak e naddattu sino kadda tata sikwara ammin. ");
INSERT INTO gdg_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","E naaꞌdanira ammin sino Espirituwi Dios annino pannakadamana, e naddamitira si naddadaruma a damita ammera inammu, se ino Espirituweno nangwa. ");
INSERT INTO gdg_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Sinoya tiyempo, nagyan sey Jerusalemino Judyuwera a nattalaginara manuntul sino lintiyi Dios a naggabwat si ammina lulubbun. ");
INSERT INTO gdg_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Wasin diningngaddeno ungug, odduwera a inang sino agyananino manguruwira. E nakkaꞌbawira ammin, se sin diningngaddeno sapitannino manguruwira, kadda tata diningngangngeno damiꞌneno naggabwatanna a lubbun. ");
INSERT INTO gdg_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Gafu se nakkaꞌbawira, kunda si, “Ma, bakkanna taga-Galilea irayaw ammina maddamit? ");
INSERT INTO gdg_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Santam lang dingngaggannino damit sino naggabwatantamira? ");
INSERT INTO gdg_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Anera sikwatamino naggabwat sey Partia, Media, anna sey Elam. Anera kappayino naggabwat sey Mesopotamia, Judea, Capadocia, Ponto, anna sey Asia. ");
INSERT INTO gdg_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Ino korwan sikwatam, naggabwatira sey Frigia, Pamfilia, anna sey Egipto, andino korwan, naggabwatira si lulubbunna Libya a araꞌni sey Cirene. Ino korwangkappay, naggabwatira sey Roma a mappasyar sitaw. ");
INSERT INTO gdg_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Judyuweno korwan, e ino korwan, bakkanna Judyu udde tuntulandeno gagangena Judyu. Ino korwan sikwatam, naggabwatira sey Creta anna sey Arabia. Udde massiki sintawino naggabwatantam, kadda tata dingngagganneno gagangaya damiꞌna a ituldureno kakkaꞌbawira a inangwa i Dios. ");
INSERT INTO gdg_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Sanneno anggamma sapitan inoy?” kunda a nakkakibikibebut se nappelalotino kaboꞌra anna madyatanira a manandam. ");
INSERT INTO gdg_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Udde ino korwan, pinayappakandera pelanga kunda si, “Nabokira yana tolay.” ");
INSERT INTO gdg_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Waso kunnenoy, nattaꞌdaggi Pedro andino karattaddaya bulunnera a apostol, e nekokwana a naddamit sino tolayira e sinapiꞌna si, “Ikkayuwa bulungkuwa Judyu anna ikkayu ammina magyan sito Jerusalem, dingngaggandak abbu ta ituldukino anggamma sapitannino diningngaddaw. ");
INSERT INTO gdg_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ariddaw si nabukira yawa tolay, gampade bakkan, se awana mabok nu alas nuwebe si gigiꞌbat. ");
INSERT INTO gdg_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Udde inoya initayuwa nakwa sikwami, antuweno neyakkuruwanino nelabbuni Joel siꞌin, a kunna si, ");
INSERT INTO gdg_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Antuyawino kunni Dios. Naso mauddiyera a aw, dundunangkuneno Espirituk a munag si ammina tolay. Ino anaꞌdawira a lallaki anna bafabbay, manulduwerana sino petulduk sikwara. Ino bafuwanakira, ananeno ipaitak sikwara a kunnangke tenap. Massiki ino lallakayira, mappatenappaꞌnga sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Se ammina aripangkuwa masserbi sikwak, massiki bafay onnu lalaki, paunaggangkuweno Espirituk sikwara ta ituldureno ipakaammuk. ");
INSERT INTO gdg_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","E ananeno kakkaꞌbawa ipaitak sey langit anna sito lubag. Ino senyala ipaitak, ada, afuy, anna kattalatalawa atok. ");
INSERT INTO gdg_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Mallammuꞌngeno sinag e mallibaganeno dakka mallanga ada, kasena dumatangngino mappakaꞌbawa awa awana kakunnana a gamwanganino Afuyu sito lubag. ");
INSERT INTO gdg_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","E amminira a nangurug sikwana, mesalakanirana ta ammera makastigu.’ Antuweno nelabbuni Joel.” ");
INSERT INTO gdg_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","E sinubburani Pedroweno sinapiꞌna a kunna si, “Ikkayuwa bafulungkuwa gakagaka i Israel, dingngaggandaw yo sapitangku mappeafu ki Jesus a taga-Nazaret. Sinaꞌdaggani Dios si dinundunna i Jesus gafu sino odduwa kakkaꞌbawa senyala a amme makwana tolaya nepakwana sikwana. Ammuyu yaw se nakwa sito agyanandaw. ");
INSERT INTO gdg_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","I Dios, neyakkurungngeno dinandamma siꞌina iyalawaꞌna i Jesus sikwayu, e ikkayuweno namapatay sikwana se neyalawaꞌdaw sino narakkattira a tolay takesi ilansara sino krus. ");
INSERT INTO gdg_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Udde nepangngangoliyi Dios se ammena dama a mefuwad sino katayan. ");
INSERT INTO gdg_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","I Jesusino niyakkurug sino nelabbuni David siꞌina kunna si, ‘Afu, ammek mattalaw se ammuk si kanayungka a mebumbulun sikwak. ");
INSERT INTO gdg_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Kunnantu, maanggammak e dandayawantaka. E ammek mattalawa matay se aneno innanamangku. ");
INSERT INTO gdg_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Se ammuk si ammerak makalyawan sino agyananino natayira. Ammem purayan si mananawu yo baggik, se ikkanakino mattalaginara masserbi sikwam. ");
INSERT INTO gdg_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Nepakaammum sikwakino aggangwa a tuntulangku takesi mabiyayak, e mallanggakakungke se mebulunak sikwam si makkikiyad.’ Antuweno neturakki David,” kunni Pedro. ");
INSERT INTO gdg_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Sinapikkappayi Pedro si, “Ikkayuwa kakkolakku, anggangkuwa ipakaammu sikwayuweno mappeafu sinaya neturakkino gagginafutama i David. Bakkanna baggineno sinapiꞌna, se natayi David, netananda siꞌin, e ana kepayino tanamma ingkein. ");
INSERT INTO gdg_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Udde gafu se gumalabbuni Diosi David, ammuneno nekariyi Dios sikwana. Ino nekariyi Dios, ananeno gaka i David a mepatali sikwana a matturay so maddagguna aw. ");
INSERT INTO gdg_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Inammu kappayi Davirino akwanna i Dios so maddagguna awa pangngangolinnaneno Kristo a pinilina a matturay, se neturakki David si, ‘Ammena nepuray sino agyananino natayira, ammena mananawuweno baggina sino tanamma.’ ");
INSERT INTO gdg_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ino sinapiꞌna, awana korwan nu bakkanni Jesus, se antuweno nepangngangoliyi Dios. Ikkamiyeno manaꞌdag si nangngangoli se initami ammin sin nangngangoliyanna. ");
INSERT INTO gdg_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Netulluwi Jesus sey langit e nattuttud sino padiwanani Dios a Amana. E inappaneno kalintiyanna a manundun sino Espirituna sikwami, a antuweno nekariyi Dios. Ino nakwa ingkeina initayu anna diningngaddaw, antuweno inangweno Espirituwi Dios a dinunduni Jesus sikwami. ");
INSERT INTO gdg_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","E massiki i David ino nanurak mappeafu sino mattuttud sino padiwanani Dios sey langit, bakkannino baggineno sinapiꞌna, nu bakkanni Jesus, sin nassapitanna si, ‘Kunni Afu Dios ki Afuk, mattuttugga sito padiwanangku, ");
INSERT INTO gdg_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","makkiyad si affutangku ammina kalingam.’ ");
INSERT INTO gdg_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Sitoya, ammundonadda gakagaka i Israel si i Jesus a nelansayu sino krus, antuweno Kristo a nekariyi Dios siꞌina gumamwang, e antuweno pinilina a matturay si ammin.” ");
INSERT INTO gdg_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Wasin diningngaggino tolayireno sinapiti Pedro, dokallino bobolira e nepakibebuꞌda ki Pedro andino korwanira a apostol si, “Sanna mantuweno akwammi, kakkolak?” ");
INSERT INTO gdg_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","E sinabbi Pedro si, “Iboboliyuweno liwaꞌdaw ta mappabawtisarkayuwa mangipakaammu si manguruggayu ki Jesu Kristo, takesi pakomani Diosino liwaꞌdaw, e iyaꞌdananeno Espirituna sikwayu. ");
INSERT INTO gdg_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Se antuweno nekariyi Afu Dios a iyaꞌdana sikwatama Judyu andino gakagakatamira, massiki sino tolayira a ana sey aroyu, se iyaꞌdananeno Espirituna sino amminira a tolaya pinilina a mangurug.” ");
INSERT INTO gdg_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Oddu kappayino sinapiti Pedro a panulduna sikwara a kunna si, “Malliꞌwakayu nad sino ammaꞌgangnga i Dios sino narakkattira a tolay sito ingkein.” ");
INSERT INTO gdg_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Odduweno nangurug sino sinapiꞌna e nappabawtisarira. Sinoya aw, inang si tallurifuweno nedagga sino manguruwira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Netupaꞌda a madal anna manuntul sino tulduweno apostolira. Nakkakarampattira anna nakikkanira sino tinapaya panandanda sino natayani Jesus. Kunna kappaya mittatera a makkararag. ");
INSERT INTO gdg_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Odduweno kakkaꞌbawa nepaangwa i Dios sino apostolira, e nakkaꞌbaw amminino tolayira. ");
INSERT INTO gdg_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","E netupak amminino manguruwira ki Jesus a makkakarampat, e ammina kukwara, akwara ammin. ");
INSERT INTO gdg_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Nelakureno lubadda onnu kukwara e neannera sino bafulundera a meannung sino awannino kadda tata sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Kadda awa nakkakarampattira sino Templo sey Jerusalem. Makkakikikkanira sino bafalera, e nappelalotino langgaꞌda sino nangwanda sinay. ");
INSERT INTO gdg_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Naddandayawira ki Dios, e iyatallira amminino tolayira gafu sino nalawara aggangwara. Kadda aw aneno isalakani Dios a medagga sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Wasin tata si aw, inanda Pedro anni Juan sino Templo si alas tres si fuwab, se antuweno akkararanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Agyanino lalakiya neyanaka pilay sino Templo. Kadda awa boliyandenaya pilaya iyang sino lamwangana mingngan si Kalalawaran takesi makilimut sino tolayira a sumallung sinay. ");
INSERT INTO gdg_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Wasin initanara Pedro anni Juan a sinallung, inarangnga si aꞌdanda nad si limuꞌna. ");
INSERT INTO gdg_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Sinulangnganda Pedro anni Juanino pilay, e sinapiti Pedro si, “Itandakami.” ");
INSERT INTO gdg_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","E initanera gakkurug se innanamanna si wara iyaꞌdara sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Udde sinapiti Pedro, “Awaningke a pirakku, udde ino ana sikwak, antuweno iduffungku sikwam. Gafu sino pannakadama i Jesu Kristo a taga-Nazaret, gumabwakka ta mallakagga.” ");
INSERT INTO gdg_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Kasena iniggammanino diwanana kamattino pilay e dinuffunanna a nattaꞌdag. Kakaꞌmeng kelanga nattuyaggino takkina, ");
INSERT INTO gdg_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","nappaꞌlata nattaꞌdag e malallakarin. Kasena nebulun sikwara a sinallung sino Templo, e malallakara malallattuwa maddandayaw ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Amminino tolayira sinay, initara a malallakad anna maddayaw ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Wasin naimunuwanda a antuwenin pilaya aggatuttud sino lamwangana Kalalawaran a makilimut, nakkaꞌbawira ammin sino nakwa sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Wasin gumafafutino pilay sikwara Pedro anni Juan, nitturira sino naatappana palayanneno Templo a ngananda si Palayari Solomon. E odduweno tolayira a nalayawa inang sikwara, se nakkaꞌbawira. ");
INSERT INTO gdg_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Wasin inita i Pedroweno tolayira, nekunna sikwara si, “Ikkayuwa bafulungkuwa gakagaka i Israel, sangkayu lang makkaꞌbaw anna aggatulang sikwami? Nganandonakuy si nepabbattunoymi yawa lalaki gafu sino pannakadamami anna kinalawammi. ");
INSERT INTO gdg_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Gampade bakkanna ikkami, nu ammena luri Dios a dayawannino gagginafutamira a da Abraham, Isaac, anni Jacob ino nappabattunoy sikwana, takesi medayawi Jesus a Aripanna. Udde ikkayu, neyalawaꞌdawi Jesus sino matturayira, e wasin dinandammi Gubernador Pilato si pallawananna naddi Jesus, inammeyu. ");
INSERT INTO gdg_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Nadiosan anna naggaddangngi Jesus, gampade inammeyu, anna inarandaw ki Pilato ta pallawananneno tata a gumapapatay. ");
INSERT INTO gdg_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Nepapapateyuweno mangifuyut sino tolayira si kabiyayan, udde nepangngangoliyi Dios, e ikkamiyeno mangipakurug se initamiya nangngangoliyen. ");
INSERT INTO gdg_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Iyawa pilaya itandaw anna naimunuwandaw, naariyennino pilena e nattuyag gafu sino pannakadama i Jesus. E ammina initayuwa nakwa sino aꞌlandaw, nakwa pelang gafu sino angngurummi ki Jesus annino annalaꞌmi sino pannakadamana. ");
INSERT INTO gdg_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Kakkolakku, ammuk si ammeyu inammuwa i Jesusino dinunduni Dios sin nepapapateyu. Massiki ino turetamira, ammera inammu. ");
INSERT INTO gdg_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Udde ino inangwayu, antuweno neyakkuruwanino nepeturakki Dios siꞌin, se amminino gumalabbunira i Dios, sinapiꞌda si madyatanneno Kristo a dundunanna, kasena matay. ");
INSERT INTO gdg_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","Mabbobolikayu antu e mulikayu ki Dios takesi pakomanneno liwaꞌdawira. ");
INSERT INTO gdg_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Se nu antuweno akwandaw, ipadatangnga i Diosino tiyempowa passiyanakkan anna pattuyagganneno nakandaw, e dundunanna kappayi Jesus a ino Kristo a pinilina a matturay sikwatam. ");
INSERT INTO gdg_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Udde sito ingkein, magyan naddi Jesus sey langit makkiyad si madatangngino awa pappabawuwani Dios si ammin, se antuweno nepasapiti Dios sino nadiosana gumalabbunnera siꞌin. ");
INSERT INTO gdg_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","I Moises a gumalabbunna siꞌin, sinapiꞌna si, ‘Manundunna i Afu Dios sikwayu si tata gumalabbunna a kakunnak. Buluntangkappaya gaka i Israel. Kuruwandonad amminino sapitannana sikwayu. ");
INSERT INTO gdg_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Se massiki inyaneno ammena mangurug sikwana, mekatwena sino tolayira i Dios ta makastigu si makkikiyad.’ ");
INSERT INTO gdg_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","I Samuel kappay andino amminira a gumalabbuna netufad sikwana, ana kappayino nelabbunda mappeafu sino makweran sito aw. ");
INSERT INTO gdg_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Neakkuruwin sikwatamino nepekariyi Dios sino gumalabbunira. Nesapatetangkappay sino tulagi Dios sino gagginafutam, se sinapiꞌna ki Abraham siꞌina, ‘Gafu sino gakagakam, maduffunanna amminino tolayira sito lubag.’ ");
INSERT INTO gdg_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Antu gafuna, ikkanetama Judyuweno palunguwa nanundunani Dios sino Aripanna a i Kristo takesi duffunandetama mappaboboli ta talekkurantamino narakkatta aggangwatam.” ");
INSERT INTO gdg_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Wasin aggesapasapiꞌda Pedro anni Juan sino tolayira, agyanino ginamwangira sinaya papadi, Saduceo, annino afafuweno gumaindaggira sino Templo. ");
INSERT INTO gdg_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","Nabbungutira se netuldura Pedro a nangngangoliyi Jesus a antuweno pammakurug si mangngangoli kappena amminino natayira. ");
INSERT INTO gdg_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Antu gafuna, dinoꞌmandera e nebaluddera kiyad sino kadaramaꞌna, kaserera bistigaran, se gafenin. ");
INSERT INTO gdg_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Udde massiki kunnenoy, odduweno nangurug sikwara a nakadingngag sino sinapiꞌda Pedro. E ino kaodduweno lallakiyera pelanga nanguruwin ki Jesus, mallimarifuwera ammin. ");
INSERT INTO gdg_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Waso kadaramaꞌna, nakkakarampat sey Jerusalemino turayirana Judyu, ino pangafuwandera, andino mammesturuwerana lintig. ");
INSERT INTO gdg_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Nammamitingira anda Anas a afafuna padi, anda Caifas, Juan, Alejandro, andino korwanira a wawwayira Anas. ");
INSERT INTO gdg_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","E nepaayaddara Pedro anni Juan e nepaaꞌlandera, e binebuꞌda si, “Sintawino naggabwatanino pannakadamayuwa nappabattunoy sinaya pilay? Inyeno nangaꞌda si kalintiyandawa nangwa sinay?” ");
INSERT INTO gdg_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Naturiri Pedro gafu sino pannakadameno Espirituwi Dios e sinabbangnga si, “Ikkayuwa tatturay anda pangafuwan, ");
INSERT INTO gdg_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","nu ino pimbistigarandaw sikwami e mappeafu sino nalawara nakwa sito pilay anna nu ansanna a nabbattunoy, ");
INSERT INTO gdg_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","dingngaggandaw ta itulduk sikwayuweno gafuna, mampesino ammina kakkolattama gakagaka i Israel. Iyawa lalakiya aggataꞌdag sino aꞌlandawa pilay siꞌin, awaninna gigiꞌnanna gafu sino pannakadama i Jesu Kristo a taga-Nazaret. Antuweno nelansayu sino krus, udde nepangngangoliyi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Antu kappayino neamparig sino nepeturakki Dios a kunna si, ‘Ino batuwa inammeyu, ikkayuwa mamaꞌdak si balay, antuweno kapapatiyana batuwa mappatuyag si balay.’ ");
INSERT INTO gdg_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","I Jesus pelangino dama a misalak sikwatam. Se awana korwan si dinunduni Dios sito lubagga mangisalak sikwatam, nu bakkampelang.” ");
INSERT INTO gdg_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Wasin initeno tatturayirana Judyuweno kinaturidda Pedro anni Juan a nanabbag, nakkaꞌbawira, kumaral se ammura si awana adalda. Udde dinandanda a nebumbulunira ki Jesus siꞌin. ");
INSERT INTO gdg_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","E awaninna masapiꞌda sikwara Pedro, se agyanino lalakiya naariyeno pilena a aggataꞌdag sino arurudda. ");
INSERT INTO gdg_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Antu gafuna, nepaanorara Pedro sino aꞌlanda, takesi mittatera a mattatarabbag. ");
INSERT INTO gdg_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Kasera sinapit si, “Sanneno akwantam sinayira a tolay? Se ino kakkaꞌbawa inangwara, naammuwan amminino tolayira sito Jerusalem, e ammetam dama a iyimad. ");
INSERT INTO gdg_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Ino nad akwantam, tipaddantamira takesi umibbattira a manuldu mappeafu ki Jesus takesi ammena umoodduweno makadingngag.” ");
INSERT INTO gdg_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Waso kunnenoy, inayanda kappera Pedro anni Juan, e netutundangke sikwara si ammeran massapit onnu manuldu mappeafu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Udde sinabbadda Pedro anni Juan si, “Dandammandopay nu sanneno mepangngatta akwammi sino aꞌlangi Dios. Kuruwammiyeno sinapiti Dios onnu kuruwammikayu? ");
INSERT INTO gdg_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Nu ikkami, ammemi dama a iyibbattino ituldu sino initami anna diningngammi ki Jesus.” ");
INSERT INTO gdg_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Waso kunnenoy, dinaggakkappayino tatturayira a manantalaw anna manipad sikwara, kaserera nepaanaw, gafu se awana pangiyafuwanda a mangastigu sikwara, se odduweno tolayira a maddandayaw ki Dios gafu sino kakkaꞌbawa inangwara. ");
INSERT INTO gdg_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Se ino lalakiya naariyennino pilena, nallaꞌwut si appatafuluweno dawunna. ");
INSERT INTO gdg_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Wasin nepallawandara Pedro anni Juan, inangngira sino bafulundera a nangurug ki Jesus, e nepakaammureno sinapitino pangafuwanirana padi andino korwanira a pangafuwan. ");
INSERT INTO gdg_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Wasin diningngaggino nanguruwireno sinapiꞌda Pedro, nittatera a nakkararag ki Dios, e sinapiꞌda si, “Afu Dios a namaratu sino langit, yo lubag, ino bebay, annino ammina igyanda, ");
INSERT INTO gdg_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ino Espiritumino naggabwatanino neturakkino gagginafumiya i David a nasserbi sikwam siꞌin, a kunna si, ‘Sandalang mabbungutino bakkannira a Judyu ki Dios? Sandalang dinandamma mangwa si awana ketupakkanna? ");
INSERT INTO gdg_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Ino ariyera andino tatturayira sito lubag, nattatarabbira ta maddadanira a makiyubat ki Dios anna sino Kristo a pinilina a matturay.’ ");
INSERT INTO gdg_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","E sitoya, Afu Dios, neyakkuruwinnino nelabbuni David, se i Herodes anni Poncio Pilato, mampesino bakkannira a Judyu andino kasittolemiya gakagaka i Israel, nakkakarampattira sito Jerusalem, e nattatarabbanda a papatayani Jesus a nadiosana Aripannu a pinilima matturay. ");
INSERT INTO gdg_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","E pinapatera gakkurug, udde gafu se ikkeno turay, ino inangwara, neakkurubbelangino dinandammu siꞌin. ");
INSERT INTO gdg_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Sitoya, Afu Dios, dingngaggannu naddino panantalora sikwamiya masserbi sikwam, e patturirandakamiya mituldu sino sapiꞌnu. ");
INSERT INTO gdg_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Paitammaddino pannakadamam takesi pabbattunoyammiyeno malowanira anna oddu naggappayino kakkaꞌbawa akwammi gafu sino pannakadama i Jesus a nadiosana Aripannu,” kunda. ");
INSERT INTO gdg_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Wasin nasinduwera a nakkararag, nagguyaddino balaya nagyananda, napatuyaggino nakanda ammin gafu sino pannakadameno Espirituwi Dios, e nattuririran gakkuruwa nangibanyag sino sapiꞌna. ");
INSERT INTO gdg_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ino nanguruwira ki Jesus, nittata pelangino nakanda. Awana mattanatanig sikwara, nu ammera lud akwa ammin. ");
INSERT INTO gdg_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Ino apostolira kappay, natuyaggino pannakadamara a mangipakaammu mappeafu sino nangngangoliyani Jesus. E odduweno duffuni Dios sikwara ammina nangurug. ");
INSERT INTO gdg_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Awana nakkurang sikwara, se ino nallubaggira annino nabbalayira, nelakura, ");
INSERT INTO gdg_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","e neyaꞌdareno nallakuwanda sino apostolira takesi iyannera sino nanguruwira a mawag si duffun. ");
INSERT INTO gdg_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Kunnenoyino inangwa i Jose a taga-Chipre a gaka i Levi. Ino nepingnganino apostolira sikwana, i Bernabe, anggamma sapitan, mappalampaw sino nakammino bafulunnera. ");
INSERT INTO gdg_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Ino inangwana, nallaku si lubag e neaꞌdaneno nallakuwanna sino apostolira. ");
INSERT INTO gdg_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Udde agyangkappayino tafalayira a da Ananias anni Safira a nallaku si lubag. ");
INSERT INTO gdg_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Nattatabbanda a tafalaya iyimfunino dagganeno nallakuwanda, kase inangngi Ananias a niyaꞌda sino daggana sino apostolira, e kunna si, “Antu ammin yawino nallakuwammi.” ");
INSERT INTO gdg_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","E kunni Pedro sikwana si, “Ananias, mayan nepuremi Satanas a matturay sikwama sinsiriyannuweno Espirituwi Dios anna nesussuꞌnguweno dagganeno nallakuwandaw? ");
INSERT INTO gdg_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Sin ammeyu kepay nelakuweno lubag, akwayu, e sin nelakuyun, akwayu kappayino pagana. Ansannu maꞌlud dinandamma inangwa inay a kunnu si neyaꞌdam amminino pagana, gampade awan? Bakkanna tolayino nasisiriyannu, nu bakkan luri Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Anningngallangi Ananias sinoy, naletwad e natay. E ammina naddingngag, nakatalawira. ");
INSERT INTO gdg_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Sinallungino bafuwanakira e binaꞌbattandeno baggina, kasera nelawan e netananda. ");
INSERT INTO gdg_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Waso nallaꞌwutino tallu orat, ginamwangino atawana. Ammena pelang ammu nu sanneno nakwa. ");
INSERT INTO gdg_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","E kunni Pedro sikwana si, “Ituldum nu gakkuruwa antu ammin yawino nallakuwandaw?” E kunna si, “On, antu ammin yan.” ");
INSERT INTO gdg_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","E kunni Pedro si, “Mayan nattatabbandawa dalodawannino Espirituwi Afu Dios? Aneran sino kayatanino nattanammira sino atawam, e andaka kappay ilawan.” ");
INSERT INTO gdg_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","E kakaꞌmeng kelanga naletwad e natay sino aꞌlangi Pedro. Sinallungino bafuwanakira e initara a natayin, e nelawanda a umang itanam sino aruruwino atawana. ");
INSERT INTO gdg_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","E amminino nanguruwira andino naddingngaggira sinoy, nappelalotino talora. ");
INSERT INTO gdg_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","14","Ino pakkakarampattanino nanguruwira, ino Palayari Solomon sino Templo. Ino ammera nangurug, massiki iyataldeno manguruwira, mattalawira a meamung sikwara. Udde umoodduweno lallakiyera andino bafabbayira a manguruwa medagga sikwara. Odduweno kakkaꞌbawa inangweno apostolira a initeno tolayira. ");
INSERT INTO gdg_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Antu gafuna, neyandeno matakitira sino dammingnga dalan e nepaiddarera sino dayod anna sino afaꞌda, se iyindadda nu mattaꞌlifi Pedro, takesi massiki nu masiyongannera sino alinona, maariyeno kalora. ");
INSERT INTO gdg_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Odduwera a inang sey Jerusalem a naggabwat sino weweꞌnginna a lulubbuna niyang sino bafulundera a malowan andino naunagganira si narakkatta espiritu, e nabbattunoyira ammin. ");
INSERT INTO gdg_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Wasin kunnenoy, ino afafuna padi andino bulunnera a Saduceo, nafulotingke ino illira sino apostolira. E nattatarabbanda nu sanneno akwanda. ");
INSERT INTO gdg_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Antu gafuna, nepadoꞌmareno apostolira e nepebaluddera. ");
INSERT INTO gdg_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Udde sinoya gafi, agyanino tata a angheli Afu Dios a inang sino abbaluran e binukkatanneno aggakuꞌneno kayatan. Nepalawannera, e nekunna si, ");
INSERT INTO gdg_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Umangkayu sino Templo e manuldukayu sino tolayira mappeafu sito bawuwa biyaya iyaꞌda i Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Wasi gigiꞌbat, kinuruddeno sinapitino anghel, sinallungira sino Templo, e nanulduwera sinay. Inowira afafuna padi andino bafulunnera, inayanda amminino pangafuwanira a Judyu ta mammamitingira. Kasera naddundun si pulis sino abbaluran ta appandeno apostolira takesi bistigarandera. ");
INSERT INTO gdg_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Udde wasin sinallungira sinay, awanino apostolira, e nuliyera ta ituldura sino pangafuwanira. ");
INSERT INTO gdg_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Sinapiꞌda si, “Awanira. Wasin ginamwangkami sino abbaluran, initamiya nakandaduwan e agyanino gwardiyera. Udde wasin binukkatammiyeno kayatan, awanira sino dolam.” ");
INSERT INTO gdg_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Wasin diningngaggino kapitanna pulisna Templo andino pangafuwanira a padi inoy, naburuburungira nu sanneno metufara makwa. ");
INSERT INTO gdg_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Udde agyanino ginamwanga nituldu si, “Ino nebaluddawira, aneran sino Templo a manuldu sino tolayira.” ");
INSERT INTO gdg_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Antu gafuna a inangngino pulisira annino kapitanda sino Templo e inappareno apostolira. Udde inalalerera a inappa, se mattalawira sino tolayira a mangita, tantaro nu mabbungutira e lapalappaggandera. ");
INSERT INTO gdg_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Wasin neyandeno apostolira sino nakkakarampattanino pangafuwanira, nepataꞌdaddera sino naraꞌlanganda. E inallangnganireno afafuna padi, a kunna si, ");
INSERT INTO gdg_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Inangangwamingke sikwayuwa ibbattandawinnino manuldu mappeafu sinaya tolay. Udde aggeakakwandokepay makkiyad si diningngag amminino ayawira to Jerusalem. Bakkan si antu ke yan, ipaliwaꞌdokappay sikwamiyeno natayanna.” ");
INSERT INTO gdg_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Udde sinabbadda Pedro andino korwanira a apostol, e sinapiꞌda si, “On, se i Dios naddino kuruwammi, a bakkanna tolay. ");
INSERT INTO gdg_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Se ikkayu, gakkuruwa pinapateyuwi Jesus e nelansayu sino krus. Udde i Dios a dinayawino gagginafutamira, nepangngangolina. ");
INSERT INTO gdg_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","E nepatuttunna sino padiwananna sey langit takesi antuweno matturay anna misalak sikwatam. Inangwanenay tantaro nu ibobolitama gakagaka i Israelino liwattamira takesi pakomanna. ");
INSERT INTO gdg_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ikkamiya apostolino mituldu si gakkurug ammin yaw, mampesino Espirituwi Dios a neyaꞌdana sino manguruwira sikwana.” ");
INSERT INTO gdg_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Wasin diningngaggino pangafuwanireno sinapiti Pedro, nappelalotino bunguꞌda sino apostolira e anggandera a papatayan. ");
INSERT INTO gdg_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Udde agyanino tata sikwara a Fariseo a i Gamalielino anganna. Mesturuna lintiya iyatal amminino tolayira. Nattaꞌdagga nassapit si, “Pallawanantamira abbu si bisang.” ");
INSERT INTO gdg_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nepallawandera, kasena kun si, “Ikkayuwa kakkolakkuwa gakagaka i Israel, dandammantammad si nalawarino akwantam sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Se bakkanna antu ke yawino nakwa. Se siꞌin, ana kappay tata a lalakiya i Teudas a nassangkatolay, e inang si appatatutino lallakiyera a dinandan sikwana. Udde wasin pinapatera, nakkakaratwayira a dinandan sikwana, e awaninna tupaꞌngeno neyafuna. ");
INSERT INTO gdg_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ginamwang kappayi Judas a taga-Galilea sin nallistanino gubiyernu sino tolayira. Oddu kappaya dinandan sikwana, udde wasin pinapatera kappay, nakkakaratwekappayino dinandanira sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Kunnantu, antuyawino kungku sikwayu, pallawanantamira pelang. Purayantamira, se nu naggabwappelang si tolay iyawa ituldura, awangkappena pattupakkanna. ");
INSERT INTO gdg_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Udde nu nakammi Dios, ammetamira maaffut, se tantaro nu i Diosino kontarantam.” ");
INSERT INTO gdg_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Kinuruwino pangafuwanireno sinapiti Gamaliel. Nepatallundereno apostolira, e nepasiwaꞌwaꞌdera, e sinapiꞌda kappay sikwara si, “Ammekayunna manuldu mappeafu ki Jesus,” kaserera nepaanaw. ");
INSERT INTO gdg_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Maanggammingke ino apostolira sino anawanda, se nebilangira i Dios a mepangngatta melopalopet gafu sino angngurudda ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Kadda aw itupaꞌdeno manuldu anna mangibanyag sino Templo anda sino bafalayira si i Jesusino Kristo a dinunduni Dios. ");
INSERT INTO gdg_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Wasinoy, umoodduweno manguruwira ki Jesus. Udde ino Judyuwera a maddamit si Griego, umilliyera sino Judyuwera a maddamit si Hebreo. Ino ririra, nalaꞌwutanino bafaluwera a bulunda sino niyannayanda si pirak kadda aw. ");
INSERT INTO gdg_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Antu gafuna, ino karadwera a apostol, inayandeno ammina manguruwira, e sinapiꞌda sikwara si, “Pittatammi naddino mangibanyag sino sapiti Dios, bakkanna antu aꞌlangammiyeno miyannay si pirak. ");
INSERT INTO gdg_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Kunna antu, kakkolak, mamilikayu sikwayu si pituwa lallakiya matalaꞌdawa ammuyu si aneno pannakadameno Espirituwi Dios sikwara anna nalaingira, ta ireno talakkantama miyannay si pirak, ");
INSERT INTO gdg_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","takesi ikkami, ipatatamiyeno makkararag anna mangibanyag sino sapiti Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Amminira a nakkakarampat, anggandeno sinapitino apostolira, e irayawino pinilira. Ino pitta a pinilira, i Esteban. Natuyaggino angngurungnga e maita si aneno pannakadameno Espirituwi Dios sikwana. Ino korwanira, da Felipe, Procoro, Nicanor, Timon, Parmenas, anni Nicolas a taga-Antiokia. Bakkanna Judyu i Nicolas udde tuntulanneno gagangena Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ira a pitu, nepaaꞌlandera sino apostolira, e ino apostolira, nepotundeno kamaꞌda sino ulura e nekararaddera. ");
INSERT INTO gdg_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Waso kunnenoy, naddidingngaggandeno sapiti Dios e inodduwereno nangurug ki Jesus sey Jerusalem. Massiki ino papadiyerana Judyu, oddu sikwareno nangurug. ");
INSERT INTO gdg_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","I Esteban, odduweno kakkaꞌbawa senyala inangwana a initeno tolayira, se dinuffunani Dios e naaꞌdan sino pannakadameno Espirituna. ");
INSERT INTO gdg_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Udde agyanino Judyuwera sey Jerusalem a taga-Cirene anda taga-Alejandria a nesapat sino sinagoga a nepingnganda si Sinagogana Mibbattin Si Kinaaripan. Ira andino korwanira a Judyu a taga-Cilicia anda taga-Asia, nakisombatira ki Esteban. ");
INSERT INTO gdg_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Udde ammera a maaffut, se dinuffunanino Espirituwi Dios e nalainga nanombat. ");
INSERT INTO gdg_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Antu gafuna, pinasussukandeno korwanira a tolay ta massisiriyera a mappaliwat sikwana a kunda si, “Diningngammiyi Esteban a mangilopalopet ki Moises anni Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Passilaꞌbundeno tolayira, ino pangafuwanira, andino mammesturuwerana lintig takesi mabbungutira ki Esteban. Antuweno nanoꞌmanda ki Esteban, kasera neyang sino pakkakarampattanino tatturena Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","E nagyanino inayandera a nanistigu si siriya nekunda si, “Iyawa lalaki, kanayuna mangilopalopet sito nadiosana Templotam andino lintiyi Moises. ");
INSERT INTO gdg_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Se diningngammiyeno sinapiꞌna a darallanna i Jesus a taga-Nazaret yawa Templo e angkakwanneno gagangetama netulduwi Moises.” ");
INSERT INTO gdg_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Amminira a nakkakarampat sinay, pakatulatulangnganda i Esteban, e initareno mutungnga e kunnangke mutungnga anghel. ");
INSERT INTO gdg_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Wasin kunnenoy, binebutino afafuna padi ki Esteban si, “Gakkurug kad yawa pappaliwatanda sikwam?” ");
INSERT INTO gdg_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Sinombati Esteban a kunna si, “Aꞌamak anda kakkolakku, dingngaggandawino sapitangku. Siꞌin, i Dios a madandayaw, nappadda ki Abraham a gagginafutam sin nagyangkepay sey Mesopotamia sin ammena kepay inang sey Haran. ");
INSERT INTO gdg_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","E kunna sikwana si, ‘Anawannuweno lubbunnu andino wawwayimira ta umangka sino lubagga itulduk sikwam.’ ");
INSERT INTO gdg_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","E inanawannanino lubbunna Caldeo e inang nagyan sey Haran. Wasin natayino amana, nefuyuti Dios sito lubbuna agyanantam ingkein. ");
INSERT INTO gdg_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Sin inangnganna sitaw, awana neyaꞌda i Dios si lubag sikwana, massiki taefampelang. Udde nekariyi Dios sikwana si iyaꞌdananeno lubag sikwana takesi paillalupaꞌna sino gakagakanera, massiki awangkepay abbingnga sinoy. ");
INSERT INTO gdg_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","“Sinapikkappayi Dios ki Abraham si, ‘Inona gakagakamira, umangngirana a magyan sey korwana lubbun. E paripandera e madyatanirana si unangnga appatatuta run. ");
INSERT INTO gdg_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Udde kastigungkuneno mangaripannira sikwara, takesi anawanda inaya lubbun ta muliyerana sitawa lubag takesi antuneno paddayawanda sikwak.’ ");
INSERT INTO gdg_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","E netuldu kappayi Dios ki Abraham si kugitanneno aanaꞌngera a lallaki takesi antuweno panandanda sino tulagi Dios sikwara. Wasin neyanakino abbingi Abraham a i Isaac, nepakugiꞌna sin mekawaluwa aw. Kinugippayi Isaacino abbingnga a i Jacob. Kunna kappayino inangwa i Jacob sino karadwa a abbingnga a lallakiya ireno gagginafutamira siꞌin. ");
INSERT INTO gdg_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Udde ino abbingira i Jacob, inilliyereno kolaꞌda a i Jose, e nelakura sino taga-Egiptowera e neparipanda sinay. Udde ana i Dios sikwana ");
INSERT INTO gdg_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","e dinuffunanna sino ammina pakadyatanna. E inaꞌdanna si laing anna kinalawad takesi talakkanni Faraon a arina Egipto. E dinotukani Faraoni Jose si gubernadorna palulubbun sey Egipto anna mangituray sino ammina kukwana. ");
INSERT INTO gdg_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","“Wasin nallaꞌwutino pipidya a run, dokalla bisinino nakwa sino lulubbunna Egipto, kunna kappay sey Canaan, e madyadyatanino tolayira sinay. Ino gagginafutamira, awana pappanda si akkananda. ");
INSERT INTO gdg_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Wasin naammuwani Jacob a aneno makkan sey Egipto, dinundunneno anaꞌngera a ireno gagginafutama umang maggatang si akkananda. Antuweno pittana a inangnganda sinay. ");
INSERT INTO gdg_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Wasin pidwara a inang sinay, nepakaammuwi Jose sikwara si antuweno kolaꞌda. E naammuwampayi Faraon a ireno kakkolaki Jose. ");
INSERT INTO gdg_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","“Wasinoy, nepaayi Jose ino amana a i Jacob, ino kakkolaꞌngera, andino kataabbalayannera ta umangngira mabbafalay sey Egipto. Kawalufuluwera si lima ammin. ");
INSERT INTO gdg_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Inangngira antu sey Egipto e natayi Jacob sinay, mampesino aanaꞌngera. ");
INSERT INTO gdg_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Udde ino tulanda, neyulira sino lubbunda a Sikam e sinananda sino lubagga ginatangi Abraham siꞌin sino anakira i Hamor. ");
INSERT INTO gdg_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Wasin araꞌniyennino awa meyakkuruwino nekariyi Dios ki Abraham, umoodduwennino gagginafutamira sey Egipto. ");
INSERT INTO gdg_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","E nappatapataliyeno ariyera kiyad si mepataliyeno ariya amme nangammu sino mappeafu ki Jose. ");
INSERT INTO gdg_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Inaya ari, binalabaliyanneno gagginafutamira e nepatuꞌna a nepelawanino kaluꞌbiꞌdera kesi matayira. ");
INSERT INTO gdg_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Antuwenoyino tiyempowa neyanakani Moises a nalawaringke a kaluꞌbit. Tallu dakkino nimutanino inana. ");
INSERT INTO gdg_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","E wasin napatutira a nilawan e inanawanda, dinaꞌngeno bafaya abbingi Faraon, e nepadokalna a kunnangke abbingnga. ");
INSERT INTO gdg_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Natulduwan sino ammina adalino Egiptowera, e nabbali si gumasassapit anna madayawino aggangwana. ");
INSERT INTO gdg_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Wasin appatafuluwa runi Moises, nadandamma a dorawanino kakunnanera a gakagaka i Israel. ");
INSERT INTO gdg_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Initaneno tata sikwara a paidamannino tata a Egipto. Inangnga dinuffunan e nebalaꞌna anna pinapateneno Egipto. ");
INSERT INTO gdg_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Se ariyi Moises si maawatanino kasiJudyunera si antuweno piniliyi Dios a mappawaya sikwara sino kinaaripanda, udde ammera naawatan. ");
INSERT INTO gdg_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Waso kadaramaꞌna, initaneno adwera a kasiJudyunera a maggunut, e kinakkapannera a iwaranna kunna si, ‘Sangkayu maggunuta makkolak?’ ");
INSERT INTO gdg_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","“Udde ino tata a nalliwat, netuꞌyunna i Moises a kunna si, ‘Inyeno naddundun sikwama umang mangituray anna mangukum sikwami? ");
INSERT INTO gdg_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ma, papatayannak a kunna kappayino inangwam sino tata a Egipto singgafi?’ ");
INSERT INTO gdg_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nakatalawi Moises sin naningngagganna sinay, e nabbukala inang sey lubbuna Midian. Nangatawa sinay e antuweno neyanakanino adwera a abbingnga a lallaki. ");
INSERT INTO gdg_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Wasin nallaꞌwutino appatafuluwa run, nagyani Moises sino kabatuwana araꞌni sey kulura Sinai. E nappaddeno angheli Dios sikwana sino aggagatangnga kallakayu. ");
INSERT INTO gdg_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Nakkaꞌbawi Moises sino initana, e inaraꞌniyanna takesi imuꞌnakkannangke. Udde kakaꞌmeng kelanga diningngangngeno damiti Afu Dios a kunna si, ");
INSERT INTO gdg_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Ikkanaki Dios a dinayawino gagginafumira a da Abraham, Isaac, anni Jacob.’ Nayyaꞌyakki Moises sino talona e ammenan sinulangngan. ");
INSERT INTO gdg_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","E sinapikkappayi Dios sikwana si, ‘Ariyannu yan sapatuꞌnu se nadiosana lubaggino pattaꞌdaggannu. ");
INSERT INTO gdg_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Initakino kadidyatino tolekira sey Egipto. Diningngagguweno ikimawidda e nanabbafaka manuffun sikwara. Akkanin, ta dundunantaka a muli sey Egipto.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","E sinubburani Estebanino sapitanna si, “Iyana Moises, antuweno inammayino kasiJudyunera sin nassapitanda si, ‘Inyeno naddundun sikwama umang mangituray anna mangukum sikwami?’ Gampade antu keneno dinunduni Dios a matturay anna mappawaya sikwara sino kinaaripanda, e inangwana gafu sino duffunino anghela nappadda sikwana sino aggagatangnga kallakayu. ");
INSERT INTO gdg_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","I Moises kappayino nifuyut sikwara sino panawanda sey Egipto. Odduweno inangwana a kakkaꞌbaw sinay, anna sin naddammanganda sino Nalibaga a Bebay, kunna kappay sin appatafuluwa runa nifuyutanna sikwara sey kalolowat. ");
INSERT INTO gdg_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","I Moises kappayino nituldu sino gagginafutamira a gakagaka i Israel si, ‘Manundunna i Dios si tata a gumalabbunna a kakunnak. Buluntangkappaya gaka i Israel.’ ");
INSERT INTO gdg_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Sin nakkakarampattino gagginafutamira sey kalolowata araꞌni sey Sinai, i Moises kappayino sinatabbangnga anghel. Inappaneno neturakka sapiti Dios a mangaꞌda si biyag, takesi ikkanetam payino millalupat. ");
INSERT INTO gdg_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Udde ino gagginafutamira, inammera i Moises, e ammera kinuruwino sinapiꞌna, se aggadandammandeno gagangera sey Egipto. ");
INSERT INTO gdg_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Antu gafuna, wasin nabayinni Moises sino kulud, sinapiꞌda ki Aaron si, ‘Ipangwandakami si sinandiosa mifuyut sikwatam, se ammemi inammu nu sanneno nakwa sitana Moises a nangilawan sikwatam sey Egipto.’ ");
INSERT INTO gdg_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","E nangwera si sinan ubbunna baka, e newaꞌlaꞌdeno pinartira sino sinan ubbunda, kasera nakkakarayama aggangganda sino inangwarangkepay. ");
INSERT INTO gdg_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Antu gafuna, sinalekkuranira i Afu Dios takesi murayira a maddayaw sino sinag, dakkag, andino bitunira. Kunna kappayino nepeturakki Dios sino tata a gumalabbunna siꞌina kunna si, ‘Ikkayuwa gakagaka i Israel, bakkanna ikkanakino niwaꞌlatandaw sino pinartiyu sin appatafuluwa runa nagyanandaw sino kalolowat. ");
INSERT INTO gdg_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Se neyangkalindawino bawineno sinandiosdawa i Moloc annino sinan bituna diosdawa i Refam. Antuweno inangwayuwa sinandiosa dayawandaw. Antu gafuna, paanawantakayu ta umangkayu sey lubbuna mas aroyu sey Babilonia.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Netupakki Esteban a sinapit si, “Wasin nagyanino gagginafutamira sino kalolowat, nagyan sikwareno balaya tolda a mangipakurug si ana i Dios sikwara. Inaya tolda, inangwara a panuntul sino nepaita i Dios ki Moises si tuntulanda nad. ");
INSERT INTO gdg_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Wasin natayi Moises, nepataliyi Josue a mifuyut sikwara a umang sitawa lubag. E ino tolda a inillalupaꞌda, neyangkalinda sin nappanda sitawa lubag sino dadanira a tolay sitawa nepaanawi Dios. E inaya tolda, antuweno paddayawanda ki Dios kiyad sino tiyempowi Ari David. ");
INSERT INTO gdg_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Inanggammani Diosino aggangwa i David. E inilyawi David ki Dios nu annutanna a mangwa si nalawara balayi Dios takesi antuweno paddayawanino gakagakera i Jacob sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Udde bakkanni David ino namataꞌdag, nu ammena luri Solomon a abbingnga. ");
INSERT INTO gdg_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“Massiki nu kunnenoy, i Dios a Madandayaw, bakkanna balaya inangwana tolayino pagyananna, se neturakkin tata a gumalabbunna siꞌin si, ");
INSERT INTO gdg_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ino langitino pattutturangkuwa matturay, e ino lubag, antuweno piwaggangku sito takkik. Massiki sanna a balaya akwandaw, ammena meannunga pagyanangku. ");
INSERT INTO gdg_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Se ikkanakino nangwa si ammin, kunni Afu Dios.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sinapikkappayi Esteban si, “Nataggatingke ino uluyu. Kakunnayuweno tolayira a amme nangammu ki Dios se ammekayu maningngag sino sapiꞌna. Tuntulandokappayino gagginafutamira siꞌina kinontarareno Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Se awana gumalabbuni Dios siꞌin si ammena nelopalopetino gagginafutamira. Massiki ino nangipakaammuwera sino gamwangani Kristo a awana liwaꞌna, pinapaterera kappay. E wasin ginamwangi Kristo, ikkayu kappayino nitittik sikwana e nepapapateyu. ");
INSERT INTO gdg_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Bakkan nadda kunnenoy, se ikkayuweno nillalupat sino lintiyi Dios a nepeyaꞌdana sino anghelira siꞌin, udde ammeyu kinurug.” ");
INSERT INTO gdg_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Wasin diningngaggino pangafuwanirana Judyuweno sinapiti Esteban, nabbungubungutira anna nangngarangaritammira. ");
INSERT INTO gdg_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Udde i Esteban, gafu sino pannakadameno Espirituwi Dios a ana sikwana, sinangaw sey langit e initaneno kinalawari Dios, mampay ki Jesus a aggataꞌdag sino padiwananna. ");
INSERT INTO gdg_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","“Itandaw inay,” kunna. “Maitakino langita aggabukkat, annino Abbingnga Tolay a i Jesus a aggataꞌdag so padiwanani Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Wasin diningngaddenoy, inammuꞌdeno layadda e nakakkulawuwera. Naggagarindanira a nanoꞌma ki Esteban. ");
INSERT INTO gdg_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Neyanda sino lasinneno lubbunda takesi lapalappagganda. Ino tistiguwera a nappaliwat sikwana, netaꞌdeno tafalda sino tata a lalakiya i Saulo takesi damara makilappag. ");
INSERT INTO gdg_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Wasin aggelalappagganda i Esteban, nakkarara kunna si, “Afu Jesus, appannu yo kararuwak.” ");
INSERT INTO gdg_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Kasena namalitud e nekokwana a nassapit si, “Afu Jesus, ammem ipaliwat sikwara yo akwanda,” e natayin. ");
INSERT INTO gdg_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","3","Sinoya awa natayani Esteban, antu gafuneno nappadyatandangke sino manguruwira ki Jesus sey Jerusalem. Agyanino lallakiyera a kanayuna maddayaw ki Dios a inang nitanam ki Esteban, e nattatarangitira. Udde i Saulo, aanggammeno natayani Esteban, e odduweno inangwana a nappadyat sino manguruwira. Sinallungngeno gibbafalayan, dinoꞌmanneno nanguruwira, massiki lalaki onnu bafay, e nepeyangngera sino abbaluran. Antu gafuna, amminino manguruwira, fereno apostolira, nakkakaratwayira a nabbukala inang sino lulubbunna Judea anna Samaria. ");
INSERT INTO gdg_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ino nanguruwira a nakkakaratway, massiki sintawino inangnganda, nebanyaddeno sapiti Dios mappeafu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","I Felipe ino tata sikwara. Inang sino tata lubbunna Samaria, e nebanyangnga sino tolayira sinay si i Jesusino Kristo a dinunduni Dios. ");
INSERT INTO gdg_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Wasin diningngaggino tolayireno sinapiti Felipe anna initareno kakkaꞌbawa inangwana, kinurudda amminino sinapiꞌna. ");
INSERT INTO gdg_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Se odduwera a narakkatta espirituwa nunag sino tolayira a nepaanona, e nakkulawuwera a nanaw. Odduwera kappayino paralitiku andino pilaya nepabbattunoyna. ");
INSERT INTO gdg_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Antu gafuna, maanggammingke ino tolayira sinay. ");
INSERT INTO gdg_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Udde agyangkappay sinayino tata a lalakiya gumasalamangka a i Simon, e nakkaꞌbaw ammina tolay sey Samaria gafu sino aꞌakwanna. Itattulduna si antuweno madayaw. ");
INSERT INTO gdg_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Massiki sanna a tolay sinay, nanguruwira sino sinapiꞌna, e dinandanda si antuweno nadiosana ngananda si Natuyaggino Pannakadamana. ");
INSERT INTO gdg_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Dinandanira sikwana se nabayinna masassalamangka, e nakkaꞌbawira sino aꞌakwanna. ");
INSERT INTO gdg_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Udde wasin nanguruwira sino nalawara damaga netulduwi Felipe mappeafu sino patturayani Dios anna mappeafu ki Jesu Kristo, nappabawtisarira ammin, bafabbay anna lallaki. ");
INSERT INTO gdg_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Massiki i Simon, nangurubbay e nappabawtisar, kasena nebumbulun ki Felipe, e nakkaꞌbaw sino initana a kakkaꞌbawa dama i Felipe a akwan. ");
INSERT INTO gdg_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Wasin nadingngaggino apostolira sey Jerusalem si kinuruwino taga-Samaria ino sapiti Dios, dinundundara Pedro anni Juan sinay. ");
INSERT INTO gdg_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Wasin ginamwangira sinay, nekararaddeno nanguruwira takesi maaꞌdanira sino Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Se awangkepayino Espirituwi Dios sikwara, se nabawtisaranira pelang sino angani Jesus ta ipaitareno nanguruwanda sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Kasera nepotunino kamaꞌda sino tolayira, e naaꞌdanira sino Espirituwi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Wasin inita i Simon si naaꞌdanira sino Espirituwi Dios sin nipotunanino apostolira sino kamaꞌda sikwara, nipadda si pirak sikwara, ");
INSERT INTO gdg_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","e nekunna si, “Iyaꞌdayu pay sikwak inaya pannakadama takesi massiki sanneno pipotunangku sito kamakku, maaꞌdanira pay sino Espirituwi Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Udde sinapiti Pedro sikwana si, “Masikkulan naddino piraꞌngu sey infiyernu, pati sikwam, se anggammuwa gatangannino iyaꞌda i Dios a ammena papaga. ");
INSERT INTO gdg_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Ammena dama a mesapakka sito tarabafumi, se ammuwi Dios si ammena nalawarino nakammu. ");
INSERT INTO gdg_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Ibobolim mantuweno narakkatta nakammu, e makkararagga ki Afu Dios takesi pakomandaka sino kunnayana nakammu. ");
INSERT INTO gdg_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Se maitak si nappelalotino illim anna ammeka makaliꞌwa sino liwaꞌnu.” ");
INSERT INTO gdg_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","E sinabbi Simon si, “Kallakkandappay ta ikararaddak ki Afu Dios takesi ammena pay makwa sikwak yana sinapiꞌdaw.” ");
INSERT INTO gdg_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Wasin nasinduwenda Pedro anni Juan a nanuldu sino sapiti Dios anna nassapit sino initara annino diningngadda sino nebumbulunanda ki Afu Jesus, nuliyera sey Jerusalem. E nitturira sino lulubbunna Samaria a lakaranda takesi mangibanyera sino nalawara damag mappeafu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Wasin kunnenoy, agyanino tata a angheli Afu Dios a inang ki Felipe a nassapit sikwana si, “Gumikkakka ta umangka sino kalasada a iraꞌbunna sey Gaza a maggabwat sey Jerusalem.” Antuweno dalana mangan sino kalolowat. ");
INSERT INTO gdg_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Ginikkati Felipe a inang. Wasin agyangkepay sey dalan, aneno nedipaꞌna a lalakiya nattakay si kalesa. Inoya lalaki, taga-Etiopia a odduweno kalintiyanna se antuweno gumaiggam sino pirakino bafaya ari a ngananda si Candace. Naggabwat sey Jerusalem, se inang sinaya naddayaw ki Dios. Mababbasa sino leburuwa neturakki Isaias, a tata a gumalabbuni Dios siꞌin. ");
INSERT INTO gdg_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Sinapitino Espirituwi Dios ki Felipe si, “Maraꞌnika sikwana.” ");
INSERT INTO gdg_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","E nalayawa inaraꞌni sikwana, e diningngangngeno basanino lalakiya neturakki Isaias. E nekunni Felipe sikwana si, “Maawatannu yan babbasannu ya?” ");
INSERT INTO gdg_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Sinabbino ofisiyal si, “Ansanneno akkaammuk nu awana mituldu sikwak?” E inayanna i Felipe a makitakay sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Ino babbasanna ino neturakka sapiti Dios a kunna si, “Kunnangke karnerowa iyanda sey pamartiyan. Kunna kappayino ubbunna karnerowa massiyanak nu usipanda, se nannakanakam pelang. ");
INSERT INTO gdg_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Neyatatalda, e passibbelang siriyeno ipaliwaꞌda sikwana. Awanna a makasapit mappeafu sino gakagakana, se nakkiyarinnino biyangnga sito lubag.” ");
INSERT INTO gdg_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","E nepakibebutino ofisiyal ki Felipe, “Inyeno sapitannino gumalabbun sitaw? Ino bagginangkepay onnu korwana tolay?” ");
INSERT INTO gdg_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","E neyafuwenni Felipe a nanuldu sikwana. Sinapiꞌna si i Jesusino sapitannino binasana, kasena netuluy makkiyad si nepakaammuna amminino nalawara damag mappeafu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Wasinoy, aneno dinaꞌngara a danum. “Ayawa danum,” kunnino ofisiyal ki Felipe. “Damana nu bawtisarannak?” ");
INSERT INTO gdg_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","“Nu gakkuruwingke a kuruwannuweno netulduk, damana,” kunni Felipe. “On, manguruwak,” kunnino ofisiyal. “Kuruwangku si i Jesu Kristoweno Abbingi Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Nepitturino ofisiyalino kalesa, e nulluwira a adwa. E naddassira sino danum, e binawtisarani Felipe. ");
INSERT INTO gdg_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Wasin ginaꞌdangira, neanawino Espirituwi Diosi Felipe, e ammayin initeno ofisiyal. E netuluyna a inang sino lubbunna, e maanggammingke. ");
INSERT INTO gdg_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","I Felipe, kakaꞌmeng kelanga ginamwang sey Azoto, kasena inang si lulubbuna mibanyag sino nalawara damag mappeafu ki Jesus kiyad si ginamwang sey Cesarea. ");
INSERT INTO gdg_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Udde i Saulo, tantalawannera kepayino manguruwira ki Jesus e anggamma si papatayannera. Antu gafuna, inang sino afafuna padi ");
INSERT INTO gdg_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","e narang si turakka ipaitanana sino Judyuwera sino sinagogera sey Damasco, takesi nu wara daꞌnganna si dumandan ki Jesus, lallaki onnu bafabbay, aneno turena a manoꞌma sikwara ta iyangngera sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Wasin makkatami Saulo sey lubbuna Damasco, kakaꞌmeng kelanga nalebaddan si mangngilikilita baggawa naggabwat sey langit. ");
INSERT INTO gdg_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Naletwad, kasena diningngaggino damita kunna si, “Saulo, Saulo, mayan padyatannak?” ");
INSERT INTO gdg_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","“Inyaka, Afu?” kunni Saulo. “Ikkanaki Jesus a padyatannu. ");
INSERT INTO gdg_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Mattaꞌdagga antu ta umangka sinaya lubbun, e ananeno mituldu sikwam sino akwannuna.” ");
INSERT INTO gdg_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ino lallakiyera a bafuluni Saulo, nassiyanakkira, se nadingngaddeno damit, udde awana initara si tolay. ");
INSERT INTO gdg_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Kasena nattaꞌdaggi Saulo e nallangalanga, udde ammena makaita. E kinewidda a neyang sey Damasco. ");
INSERT INTO gdg_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Tallu awa ammena makaita e ammena kappay nangngan anna ininum. ");
INSERT INTO gdg_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Waso kunnenoy, agyanino tata a mangurug ki Jesus sey Damasco a mingngan si Ananias. Nappaita i Jesus sikwana si kunnangke tenap, e kunna si, “Ananias.” “Ma, sanneno sapitannu, Afu?” kunni Ananias. ");
INSERT INTO gdg_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","E kunni Afu Jesus sikwana si, “Gumikkakka ta umangka sino kalasada a mingngan si Naggaddang, e pakibebuꞌnu sey balera Judasino lalakiya taga-Tarso a mingngan si Saulo. Ana sinaya aggekarakararag. ");
INSERT INTO gdg_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Se aneno nepaitak sikwana si kunnangke tenappa sinallungino tata a lalakiya mingngan si Ananias, a nipotun sino kamaꞌna sikwana takesi makaitengkappay.” ");
INSERT INTO gdg_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Udde sinabbi Ananias si, “On, Afu, udde odduwa tolaya naddingngaggangku mappeafu sinaya lalaki andino kattalatalawa inangwana sino tolemira sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","E sitoya, anen sito Damasco a ana kanuweno kalintiyanna a neyaꞌdeno afafuna padiya manoꞌma sikwami ammina maddayaw sikwam.” ");
INSERT INTO gdg_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Udde kungkappayi Jesus sikwana si, “Umangka lud, se antu keneno pinilika umang mangipakaammu mappeafu sikwak sino bakkannira a Judyu anda sino arirera, andino kasittolemira kappaya gakagaka i Israel. ");
INSERT INTO gdg_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","E ipakaammuk kappena sikwaneno kaodduneno attammannana a dyat gafu sikwak.” ");
INSERT INTO gdg_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Waso kunnenoy, inangngi Ananias e sinallung sino balaya nagyanani Saulo e nepotunneno kamaꞌna sikwana, e kunna si, “Kolaka Saulo, i Afutama Jesus a nappadda sikwam sey dalan sin inangngannu sitaw, dinundunnak sikwam ta makaitaka kappay anna maaꞌdangka sino Espirituwi Dios annino pannakadamana.” ");
INSERT INTO gdg_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Kakaꞌmeng kelang naariyeno kunnangke sissib sino mata i Saulo, e nakaitemmanin. Ginabwat e nabawtisaran. ");
INSERT INTO gdg_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Wasin nabawtisaranin, nangngan e nappoliyennino baggina. Waso kunnenoy, nakikofungi Saulo sino manguruwira ki Jesus sey Damasco si pipidya aw. ");
INSERT INTO gdg_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","E inang sino sinagogeno Judyuwera sinaya nanuldu mappeafu ki Jesus, a i Jesus, antuweno Abbingi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nakkaꞌbawira ammina naddingngag sikwana, e nekunda si, “Ma, bakkangkad yawino nangilopalopet sikwara a naddayaw ki Jesus sey Jerusalem? Bakkangkadda inang sitaw takesi doꞌmanneno nanguruwira ta iyangngera sino pangafuwanirana padi?” kunda. ");
INSERT INTO gdg_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Udde nadadaggananino kinalaingi Saulo a manuldu mappeafu ki Jesus. Ino Judyuwera sey Damasco, ammera makatabbag sino nappakuruwanna a i Jesusino Kristo a dinunduni Dios. ");
INSERT INTO gdg_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Wasin nallaꞌwutinnino pipidya aw, nattatarabbanino Judyuwereno pamapatayanda ki Saulo. ");
INSERT INTO gdg_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Kadda gafi anna aw, lakkappandeno lamwanganneno lubbunda takesi papatayanda i Saulo nu mallawan. Udde naammuwani Sauloweno angganda a akwan. ");
INSERT INTO gdg_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Antu gafuna, wasin tata si gafi, inayanino sinulduwannera, nepittunda si luꞌdug, kasera sinuwewaya netabbafa sino lasinneno ataꞌnanga tupingngeno lubbunda kesi makabukal. ");
INSERT INTO gdg_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Wasin nuliyenni Saulo sey Jerusalem, anggamma a medagga sino manguruwira ki Jesus. Udde mattalawira sikwana, se ammera kuruwan si gakkuruwa mangurug ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Udde dinuffunani Bernabe. Netulunna sino apostolira, e netulduna sikwareno nepangita i Saulo ki Afu Jesus sino dalan annino sinapiti Afu Jesus sikwana. Nepadamangnga kappay sikwareno turiri Saulo a nanuldu mappeafu ki Jesus sey Damasco. ");
INSERT INTO gdg_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Antuweno nebumbulunani Saulo sikwara sey Jerusalem, e naturiringke a manuldu mappeafu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Inang kappaya nakitatabbag sino Judyuwera a Griegoweno damiꞌda, udde wasin nasassarombatira, angganda a papatayan. ");
INSERT INTO gdg_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Udde wasin naammuwanino bafulunnera a mangurug inaya angganda a akwan, binulunda i Saulo a inang sey Cesarea, kasera nepabon sey Tarso. ");
INSERT INTO gdg_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Wasinoy, awaninna kadyatanino manguruwira sino lulubbunna Judea, Galilea, anna Samaria. Nantatuyaggino angngurudda e inoodduwera, gafu se ammerangke sinulyatino anggammi Afu Dios, e dinuffunanireno Espirituna. ");
INSERT INTO gdg_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","I Pedro, inang si lulubbuna maddoraw sino manguruwira ki Jesus. Wasin tata si aw, inangnga kappay dinorawanino tolayira i Dios sey Lidda, ");
INSERT INTO gdg_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","e nesaꞌbalna sinayino tata a lalakiya i Eneas, a aggaidda si walurun se paralitiku. ");
INSERT INTO gdg_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Sinapiti Pedro sikwana si, “Eneas, pabbattunoyandaka i Jesu Kristo. Gumabwakka ta iyimfunnu yan afaꞌngu.” E ginabwatinni Eneas. ");
INSERT INTO gdg_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Odduwa tolay sey Lidda anna Saron a nita ki Eneas, e nanguruwira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Agyanino tata bafaya mangurug ki Jesus sey Joppe a mingngan si Tabita. (Ino anganna si Griego, Dorcas, anggamma sapitan, Utta.) Odduweno nalawara inangwana, anna minangkallak sino pobiriyera. ");
INSERT INTO gdg_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Wasin agyani Pedro sey Lidda, nalowani Dorcas e natay. Diniyuꞌda, kasera neekwa sino nangkalekaya kwartu. ");
INSERT INTO gdg_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Araꞌni sey Joppe ino Lidda. Antuweno wasin diningngaggino manguruwira ki Jesus sey Joppe a nagyani Pedro sey Lidda, nanundunira si adwa a lallakiya mayag sikwana. Wasin ginamwangira, sinapiꞌda si, “Kangkamannu abbu ta umangngetam sey lubbummi.” ");
INSERT INTO gdg_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Ginikkati Pedro e nebulun sikwara. Wasin ginamwangi Pedro sino balayino natay, nefuyuꞌda sino nangkalekaya kwartu. E inaribumbunganino bafaluwera i Pedro a mattatarangit, e nepaitareno barawasiya dineti Dorcas a duffunna sikwara sin liyena a matay. ");
INSERT INTO gdg_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Nepaulluwira ammini Pedro, kasena namalitura nakkararag. Wasin nasinduwen, inaꞌlangngeno natay e kunna si, “Tabita, gumabwakka.” Nalladdangi Dorcas e wasin initana i Pedro, ginabwat. ");
INSERT INTO gdg_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Iniggammani Pedroweno kamaꞌna e nepataꞌdangnga, kasena inayanino bafaluwera andino korwanira a mangurug ki Jesus, e nepaitana i Dorcas a nabiyayin. ");
INSERT INTO gdg_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Iyawa nakwa, naddinnamag si ammina lubbuna Joppe, e odduweno nangurug ki Afu Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Nabayi Pedro sey Joppe sino balera Simon a midadan si ilakuna a gaddang. ");
INSERT INTO gdg_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Agyanin sey Cesarea ino tata a lalakiya mingngan si Cornelio. Antuweno kapitanino tatutira a sindaluwerana taga-Italia. ");
INSERT INTO gdg_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Massiki bakkanna Judyu i Cornelio, nanguruwira ammina taabbalay ki Dios anna naddayawira sikwana. Odduwa duffunna sino pobiriyera a Judyu, e kanayuna makkararag ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Wasi tata si fuwab si alas tres, aneno nepaita i Dios sikwana, e initaneno tata a angheli Dios a inang sikwana, a kunna si, “Cornelio.” ");
INSERT INTO gdg_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Nakatulangngi Cornelio sino anghel gafu sino talona e kunna si, “Ma, Afu?” Sinabbino anghel si, “Aggadandammandaka i Dios se diningngangngeno kararangngu e anggammeno nepanuffunnu sino pobiriyera. ");
INSERT INTO gdg_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Manundungka mantu si umang sey Joppe ta paayangnguwi Simon a mingngangkappay si Pedro. ");
INSERT INTO gdg_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Magyan sey balera Simon a midadan si ilakuna a gaddang, a ana sino dappiꞌna bebay.” ");
INSERT INTO gdg_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Wasin inanawinnino anghel, nayi Cornelio si adwa a aripanna, anna tata a sindaluna a manuffun sikwana a maddayokappay ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Netulduna sikwara amminino nakwa sikwana, kasenera nepabon sey Joppe. ");
INSERT INTO gdg_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Waso kadaramaꞌna si tangnganawa agyaninnino dinundunira i Cornelio sino dalana makkatam sey Joppe, inuneki Pedro sino ataꞌmeno balera ta umang makkararag. ");
INSERT INTO gdg_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Nabisinan e gakakkanin, udde wasin kalutunda kepayino akkananna, aneno nepaita i Dios sikwana a kunnangke tenap. ");
INSERT INTO gdg_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Initana a nabbukkatino langit, e aneno kunnangke dokalla ulatta sumatabbafa a nebassinino appata suyuna. ");
INSERT INTO gdg_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ino nagyan sino ulat, ammina makkarekay sito lubag, ino makkurekureꞌgawangngira anda makakkayafira, a kammaralla akkanannino Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","E aneno diningngangnga a damita massapit si, “Pedro, gumabwakka ta mamartika si isiram.” ");
INSERT INTO gdg_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Udde sinabbi Pedro si, “Ammek, Afu. Se ammek kepay nalliwata massira si kunnayawa kammaral sikwamiya Judyu.” ");
INSERT INTO gdg_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","E diningngangnga kappayino damita kunna si, “Ino sinapiti Dios si nalawara akkanan, ammemmad kammarallan.” ");
INSERT INTO gdg_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Namiꞌluwa naangwenoy, kase netulluweno ulat sey langit. ");
INSERT INTO gdg_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Waso pakadadandammanni Pedro nu sanneno keanganino initana, sinumpalanino dinundunira i Cornelioweno balera Simon, e aggataꞌdaggiran sino lamwangan. ");
INSERT INTO gdg_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Nepakibebuꞌda nu antuweno balaya nagyanani Simon Pedro. ");
INSERT INTO gdg_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Udde i Pedro, aggadandammanna kepayino keanganino nepaita i Dios sikwana, e sinapitino Espirituwi Dios sikwana si, “Aneno talluwera a lallakiya mintufuk sikwam. ");
INSERT INTO gdg_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Umulluggan, e ammeka maddaladudwa a mebulun sikwara, se ikkanakino nanundun sikwara.” ");
INSERT INTO gdg_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Inulluwi Pedro e nekunna sino lallakiyera si, “Ikkanakino tufukandaw. Sangkayu lang inang taw?” ");
INSERT INTO gdg_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","“Dinundundakamiyi Kapitan Cornelio, se kunnino tata a angheli Dios sikwana si ayammika kanu sey balemi takesi dingngagganna amminino sapitannu. I Cornelio, nalawaringke a tolaya maddayaw ki Dios, e ammina kasittolemira a Judyu, iyatalda,” kunda. ");
INSERT INTO gdg_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Nepatallungira i Pedro takesi middera sinay. Wasi kadaramaꞌna, ginikkati Pedro e nebulun sikwara, e nebulungkappayino korwanira a manguruwa taga-Joppe. ");
INSERT INTO gdg_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Wasin ginamwangira sey Cesarea sino mekadwa aw, aneno nakkakarampattira sey balera Cornelio se inayanneno wawwayinera andino kakkawamannera. ");
INSERT INTO gdg_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Tattallung kepayi Pedro, dinambali Cornelio e namalitud sino aꞌlangnga a maddayaw sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Udde nepataꞌdaggi Pedro e nekunna si, “Mattaꞌdagga se tolayak paya kakunnam.” ");
INSERT INTO gdg_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","E sinallungira sino balaya mattatabbag. Wasin inita i Pedroweno odduwa tolaya nakkakarampat, ");
INSERT INTO gdg_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","sinapiꞌna sikwara si, “Inammuyunnino gagangemiya Judyu a kammarallammiyeno mebumbulun onnu maddoraw si bakkanna Judyu. Udde nepakaammuwi Dios sikwak si ammena dama a kammarallangkuweno massiki sanna a tolay. ");
INSERT INTO gdg_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Antu gafuna, wasin inayandak, inangngaka tagatulutuluk. Dingngaggangku mantu nu sanneno gafuna a nepaayaddak.” ");
INSERT INTO gdg_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Wasinoy, sinapiti Cornelio si, “Wasin mekappata aw si kunnayawa alas tres, aggekarakararak sito balemi. Kakaꞌmeng kelanga aneno nattaꞌdag sino aꞌlangkuwa nabbarawasi si mangngilikilit. ");
INSERT INTO gdg_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Sinapiꞌna si, ‘Cornelio, diningngaggi Diosino kararangngu e aggadandammanneno nepanuffunnu sino pobiriyera. ");
INSERT INTO gdg_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Manundungka si umang sey Joppe a mayag ki Simon Pedro. Magyan sey balera Simon a midadan si ilakuna a gaddang, a ana sino dappiꞌna bebay.’ ");
INSERT INTO gdg_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Antu gafuna, nepaayaddaka e nalawarimmangke se inangka pay. Sitoya, ayokami ammin sitawa aggitani Dios, ta dingngaggammi amminino sinapiꞌna si ipakaammummad.” ");
INSERT INTO gdg_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Waso kunnenoy, sinapiti Pedro si, “Maitakun si awana padumani Dios si tolay. ");
INSERT INTO gdg_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Se massiki sanna a tolay si ingkelamanga lubbun, nu maddayawira ki Dios anna mangwera si naggaddang, damanera a pabbalin si tolena. ");
INSERT INTO gdg_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Ammuyunnino nalawara damaga nepakaammuwi Dios sikwamiya gakagaka i Israel a damana a mebumbulunino tolayira sikwana gafu sino inangwa i Jesu Kristo a Afu ammina tolay. ");
INSERT INTO gdg_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ammuyungkappayino nalawara nakwa sino lulubbunna Israel a neyafu sey Galilea sin nasinduwennino nanulduwani Juan annino namawtisaranna. ");
INSERT INTO gdg_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Neyaꞌda i Diosino Espirituna annino pannakadamana ki Jesus a taga-Nazaret, takesi massiki sanneno inangnganna, passiya nalawarino inangwana, e nepabbattunoyna amminino pinadyatanira i Ofag, se ana i Dios sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Ikkamiya apostol, initami amminino inangwana sey Jerusalem anna sino korwana lulubbunna Judyu. Ireno namapatay sikwana se nelansara sino krus. ");
INSERT INTO gdg_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Udde wasin mekatalluwa aw, nepangngangoliyi Dios. Nepaitana ");
INSERT INTO gdg_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","sikwami, e nakikkangkami sikwana sin nangngangoliyanna. Ammina tolay, ammera inita, nu bakkangkami pelanga piniliyi Dios a manaꞌdag sino nangngangoliyanna. ");
INSERT INTO gdg_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Dinundundakamiya umang mangibanyag sino nalawara damag mappeafu sikwana anna mangipakaammu si antuweno piniliyi Dios a mangukum si ammina tolay, massiki ino natayin annino nabiyayira kepay. ");
INSERT INTO gdg_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Antu kappayino sinapitino amminira a gumalabbun siꞌin sin sinapiꞌda si, ‘Amminira a mangurug sikwana, mapakomanino liwaꞌda gafu sino inangwana.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Wasin aggedamadamikkepayi Pedro, inangnginnino Espirituwi Dios sikwara ammina naningngag. ");
INSERT INTO gdg_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ino Judyuwera a mangurug ki Jesus a nebumbulun ki Pedro, nakkaꞌbawira se neyaꞌda i Diosino Espirituna sino bakkannira a Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Ammura si nakwa se diningngaddera a maddamit si naddadaruma a damita ammera inammu anna maddayaw ki Dios. Antuweno sinapiti Pedro sino bulunnera si, ");
INSERT INTO gdg_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Iyawira a tolay, naaꞌdanira sino Espirituwi Dios a kunna payino ikkanetam. Waremmangke miyallang si mabawtisaranira?” ");
INSERT INTO gdg_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Waso kunnenoy, sinapiti Pedro sikwara si mappabawtisarira nadda mangipaita si manguruwiran ki Jesus. Wasin nabawtisaraniran, inaranda ki Pedro si magyan nad sikwara si pipidya aw. ");
INSERT INTO gdg_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Waso kunnenoy, ino apostolira andino korwanira a mangurug ki Jesus sey Judea, nadingngadda si ana kappayino bakkannira a Judyu a nangurug sino sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Wasin nuliyenni Pedro sey Jerusalem, binalawino manguruwira a manggamma manuntul kepay sino gagangena Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","E kunda si, “Sangka lang inang sino balayino bakkannira a Judyu e nakikkangka kappay sikwara?” ");
INSERT INTO gdg_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Wasin diningngaggi Pedroweno sapitanda, sinapiꞌna amminino nakwa sikwana makkiyad sino gafuna, a nekunna si, ");
INSERT INTO gdg_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Wasin agyanak sey Joppe a nakkararag, aneno nepaita i Dios sikwak si kunnangke tenap, e initakino sumatabbafa a kunnangke ulatta nebassinino appata suyuna a naggabwat sey langit, e naddattu sino aruruggu. ");
INSERT INTO gdg_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Wasin inimuꞌnakkangkungke, ana amminino nganganna makkarekayira, aggayam anna sumaron, mammanukira, anna makkurekureꞌgawangngira. ");
INSERT INTO gdg_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Nadingngagguweno damita massapit si, ‘Pedro, gumabwakka ta mamartika si isiram.’ ");
INSERT INTO gdg_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Udde sinabbaggu si, ‘Ammek, Afu, se awangkepay inakkangku si kammaral sikwamiya Judyu.’ ");
INSERT INTO gdg_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Nassapikkappayino maddamit sey langita kunna si, ‘Ammem kammarallannino sinapiti Dios a nalawara akkanan.’ ");
INSERT INTO gdg_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Namiꞌluwa nakwa yaw, kasena netullu ammin sey langit. ");
INSERT INTO gdg_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","“Sinoya netulluwanna, ginamwangino talluwera a lallakiya taga-Cesarea sino balaya nagyanangku. Inandak inayan ta umangngak sinay. ");
INSERT INTO gdg_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","E sinapitino Espirituwi Dios sikwak si ammeꞌngad maddaladudwa a mebulun sikwara. Iyawira a annamma kakkolattam a taga-Joppe, nebulunira pay sikwak, e inangkami ammin sey balera Cornelio sey Cesarea. ");
INSERT INTO gdg_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wasin ginamwangkami, sinapiti Cornelio sikwamiyeno anghela nappadda sikwana sino balena annino sinapiꞌna anghel a, ‘Manundungka si umang sey Joppe a mayag ki Simon Pedro. ");
INSERT INTO gdg_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Ituldunana sikwayu nu sanneno kesalakandawa taabbalay.’ ");
INSERT INTO gdg_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Wasin neyafuka manuldu, inangngino Espirituwi Dios sikwara a kunna payino ikkanetam sin gafuna. ");
INSERT INTO gdg_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","E dinandangkuweno sinapiti Afu Jesus a, ‘Nabbawtisari Juan si danum, udde mabawtisarangkayuna sino Espirituwi Dios.’ ");
INSERT INTO gdg_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Nu kunnenoy a neyaꞌda i Diosino Espirituna sikwara a bakkanna Judyu a kunna payino ikkanetam sin nanguruwantam ki Afu Jesu Kristo, inyak kadda miyallang sino akwani Dios?” ");
INSERT INTO gdg_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Wasin nadingngaddenoy, neibbaꞌda a mabbalaw sikwana, e naddayawira ki Dios a kunda si, “Nu kunna mantu, massiki ino bakkannira a Judyu, inallakkira i Dios, ta damara a mabboboli takesi mabiyayira si makkikiyad.” ");
INSERT INTO gdg_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Kiyad sin pinapatayino Judyuwera i Esteban, nadyatanino manguruwira e nakkakaratwayira. Anereno inang sey Fenicia, Chipre, anna sey Antiokia, e nanulduwera mappeafu ki Jesus, udde ino kasiJudyurera pelangino sinulduwanda. ");
INSERT INTO gdg_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Udde ana kappayino korwanira a taga-Chipre anna taga-Cirene a inang sey Antiokia, e netuldura kappayino nalawara damag mappeafu ki Afu Jesus sino bakkannira a Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Gafu se aneno pannakadama i Dios sikwara a manuldu, odduwereno nangurug ki Afu Jesus anna manuntul sino anggamma. ");
INSERT INTO gdg_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Wasin nadingngaggino manguruwira sey Jerusalem si aneno manguruwira sey Antiokia, dinundunda i Bernabe sinay. ");
INSERT INTO gdg_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Wasin ginamwang sinay, maanggam se initana a nikallakki Dios sikwara, e sinunnera si mattalaginarira nadda mangurug ki Afu Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Nalawaringke a tolayi Bernabe, natuyaggino pannakadameno Espirituwi Dios sikwana, anna natuyag kappayino angngurungnga. Antuweno odduwera a nesapat sino nanguruwira ki Afu Jesus sinay. ");
INSERT INTO gdg_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Waso kunnenoy, inangngi Bernabe sey Tarso a mintufuk ki Saulo. ");
INSERT INTO gdg_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Wasin dinaꞌngana, netulunna sey Antiokia. Taruningke ino nebumbulunanda sino nanguruwira sinay, e odduwa tolayino sinulduwanda. Ino nanguruwira ki Jesu Kristo sey Antiokia, ireno palunguwa naingnganan si Kristiyano. ");
INSERT INTO gdg_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Sin nagyananda Bernabe anni Saulo sinay, agyanino gumalabbunira i Dios a inang sey Antiokia a naggabwat sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ino tata sikwara a mingngan si Agabo, nattaꞌdag sino pakkakarampattanda, e nepalabbunino Espirituwi Dios sikwana si ananeno dokalla bisin sito lubag. (Inaya nelabbunna, neyakkuruwin sin tiyempowi Emperador Claudio.) ");
INSERT INTO gdg_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Antu gafuna, nattatarabbanino manguruwira si duffunandeno kakkolaꞌdera sey Judea. Tatatata sikwara, neyaꞌdaneno damana a neyaꞌda, ");
INSERT INTO gdg_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","kasera neyaꞌda ammin sikwara Bernabe anni Saulo ta iyanda sino pangafuwanirana manguruwira sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Sinoya tiyempo, neyafuwi Ari Herodes a mappadyat sino korwanira a mangurug ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Nepafutulna i Santiago a kolaki Juan. ");
INSERT INTO gdg_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Wasin initana a maanggammino Judyuwera sino inangwana, nepadoꞌmana kappayi Pedro. Nakwa yaw sin tiyempona fiyesta a ngananda si Laꞌwutan a pangngananda si tinapaya awana lebadurana. ");
INSERT INTO gdg_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Wasin dinoꞌmanda i Pedro, nepabaluri Herodes, e nepaindangnga si kadwafulu si annamma sindalu, e mepatapataliyeno aggappatira. Se dinandamma si nanu mabalininnino inaya fiyesta, ukumannana i Pedro takesi papapatena sino aꞌlangino Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Kunna antu, nabaluri Pedro, udde ino manguruwira ki Jesus, ginakkuruddangke a nangikararag sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Nadaꞌngeno tata a gafiya ino kagigiꞌbaꞌna, antuweno pappapapatayan naddi Herodes ki Pedro. Naturuwi Pedro sino nallatanino adwera a sindalu, a nakadenan si adwa a kawad, e ana kappayino mindag sino lamwanganino abbaluran. ");
INSERT INTO gdg_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Kakaꞌmeng kelanga nagyanino tata a angheli Afu Dios a inang sino aggiddani Pedro e nabbaggawingke ino kwartuna. Ginunggunino angheli Pedro ta gammiyanna, e kunna si, “Gumabwaꞌkan.” E naariyennino kawarira sino kamaꞌna. ");
INSERT INTO gdg_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Sinapikkappayino anghel sikwana si, “Inggurannu yan barawasim anna massapatukka.” E ginakkuruwi Pedro, e sinapikkappayino anghel sikwana si, “Mattafalka ta dumandangka sikwak.” ");
INSERT INTO gdg_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Dinandan sino anghel e nallawanira sino abbaluran. Udde ammena inammu si gakkuruwino akwanino anghel sikwana, aringnga si tenaꞌma pelang. ");
INSERT INTO gdg_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Ilaꞌwutandeno pitta a gwardiya annino mekadwa a gwardiya, kasera ginamwang sino baliyanga aggakuꞌna kayatana mallawan sino abbaluran. Nabukkataningkelang e nallawanira. Wasin aggelakalakarira sino kalasada, naawaningkelangino anghel. ");
INSERT INTO gdg_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Waso kunnenoy, naammuwani Pedroweno nakwa sikwana, e nekunna si, “Ammuk si gakkurug yaw. Dinunduni Diosino anghelna a misalak sikwak ta ammerak mapapatayi Herodes anna ammena makweno innanamanino Judyuwera a makwa sikwak.” ");
INSERT INTO gdg_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Wasin binalonenaya nakwa sikwana, inang sey balera Maria a ina i Juan Marcos. Odduweno tolayira a makkararag sinay. ");
INSERT INTO gdg_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Sinottoki Pedroweno lamwangan, e inang initeno aripanna bafaya i Roda nu inyeno nanottok. ");
INSERT INTO gdg_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Udde wasin inimunuwanneno damiti Pedro, nakalyawanna a nebukkatino lamwangan gafu sino aanggamma, e nalayawa nuliya nangipakaammu si ana i Pedro sino lamwangan. ");
INSERT INTO gdg_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Inansekka,” kunda sikwana. Udde nepagekwana si gakkurug. “Anghelna yan,” kunda. ");
INSERT INTO gdg_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Amme pelang ibbattani Pedroweno manottok. Wasin binukkatandanino lamwangan, nakkaꞌbawira sin naitara i Pedro. ");
INSERT INTO gdg_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Sinengyattannera ta suminakkira, kasena sinapit sikwareno nilawanani Dios sikwana sino abbaluran. “Itulduyu yaw sikwara Santiago annino korwanira a kakkolattam,” kunna. Kasena inanawa inang si korwana lubbun. ");
INSERT INTO gdg_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Wasin kadaramaꞌna, nakungkulingke ino nakammino gwardiyera. “Sanna lang naawani Pedro?” kunda. ");
INSERT INTO gdg_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Nepataraki Herodes i Pedro, udde ammera nasumpalan. Antuweno binistigarneno gwardiyera e sinapiꞌna si mapapatayira. Kase inanawi Herodes sey Judea e inang nagyan sey Cesarea. ");
INSERT INTO gdg_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Wasin nagyani Herodes sey Cesarea, nabbungubungut sino tolayira sey Tiro anna sey Sidon. Antu gafuna, mintufukira si pappaangganda sikwana, se ino patturayanneno pappanda si akkananda. Pinalungura a sinatabbi Blasto a mimut sino balayi Herodes takesi duffunannera, kasera inang ki Herodes a mappekakallak. ");
INSERT INTO gdg_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Wasin nadatangnginnino awa piniliyi Herodes, nabbarawasi si barawasina ari, nattuttud sino tronona, e naddiskursu sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Wasin nasinduwen, nekokweno tolayira a nassapit si, “Tata a diosino naddamit, bakkanna tolepelang.” ");
INSERT INTO gdg_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Gafu se ammena sinapit si dayawanda nabbelangi Dios, pinapatayino angheli Diosi Herodes, inuꞌgitino baggina, kasena natay. ");
INSERT INTO gdg_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Sinoya tiyempo, inooddu kappayino tolayira a naddingngag anna nangurug sino sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Da Bernabe anni Saulo, wasin nabalininnino nanundunanda sikwara sey Jerusalem, nuliyera sey Antiokia, e nebuluni Juan Marcos sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ino manguruwira sey Antiokia, ana sikwareno mangipakaammu sino ipakaammuwi i Dios andino manulduwera sino sapiti Dios. Irara Bernabe, Simeon a ngananda si Ngisit, Lucio a taga-Cirene, Saulo, anni Manaen a pinadokallino ama i Gubernador Herodes. ");
INSERT INTO gdg_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Wasin tata si aw, nallantanga mangnganino manguruwira takesi makkararira anna maddayawira ki Dios. E kunnino Espirituwi Dios sikwara, “Dotukandora Bernabe anni Saulo a masserbi sikwak se aneno pakwak sikwara.” ");
INSERT INTO gdg_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Nakkararira kappay anna nallantangira kappaya mangngan, kasera nepotunino kamaꞌda sikwara Bernabe anni Saulo, e nepagikkaꞌdera. ");
INSERT INTO gdg_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Waso kunnenoy, nepabonino Espirituwi Dios da Bernabe anni Saulo, e inangngira sey Seleucia, kasera nattakay si bafora umang sey Chipre a naffu si danum. ");
INSERT INTO gdg_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","E nebulunda i Juan Marcos a manuffun sikwara. Wasin ginamwangira sey Salamina a lubbunna Chipre, nepakaammureno sapiti Dios sino sinagogereno Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Wasinoy, dinodoyudda ammina lubbunna Chipre makkiyad si ginamwangira sey Pafo. E dinatanda sinayino tata a Judyu a gumasalamangka a massapit si gumalabbuni Dios, gampade bakkan. Ino anganna, i Bar-Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Iyawa tolay, buluni Sergio Paulo a gubernadorna Chipre. Ino gubernador, mautakka tolay, e nepaayangngara Bernabe anni Saulo se anggamma a dingngaggannino sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Udde ino gumasalamangka (a i Elimasino anganna si damiꞌna Griego), kinontaranara Bernabe anni Saulo takesi ammena manguruwino gubernador ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Udde i Saulo, a mingngangkappay si Pablo, natuyaggino pannakadameno Espirituwi Dios sikwana e pakatulatulangnganna i Elimas, ");
INSERT INTO gdg_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","e sinapiꞌna si, “Ikka a abbingnga Diablo, kontarannu ammina nalawad. Nalaingkangke a mamalabali si tolay e pabbalinnu si siriyeno gakkuruwa sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Sitoya, kastigundaka i Afu Dios e malappakka takesi awaningke a itannu si pipidya aw.” Assapiꞌna lang sinoy, awaninna itani Elimas e kumarakarabakafa mintufuk si mangewid sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Wasin initeno gubernadorino nakwa sikwana, nangurug ki Afu Jesus, se nakkaꞌbaw gafu sino pannakadamana a netuldura. ");
INSERT INTO gdg_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Waso kunnenoy, nanora Pablo sey Pafo, e nattakayira si bafora umang sey Perge, tata a lubbun sino probinsiya a Pamfilia. Wasin ginamwangira sinay, inanawanirani Juan Marcos e nuli kappay sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","E netuluyda Pablo a umang sey Antiokia a sakopanna probinsiya a Pisidia. Wasin Sabadu a awna aggimwangan, inangngira sino sinagogeno Judyuwera e nakitutturira. ");
INSERT INTO gdg_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Wasin nabasennino lintiyi Moises andino turakkino korwanira a gumalabbuni Dios, aneno nepasapitino pangafuwanirana sinagoga sikwara Pablo a kunda si, “Kakkolak, nu wara sapitandaw sino tolayira sitawa mappatuyag sino nakanda, itulduyun.” ");
INSERT INTO gdg_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Waso kunnenoy, nattaꞌdaggi Pablo e sinengyattannera ta suminakkira, e sinapiꞌna si, “Ikkayuwa kakunnaka gakagaka i Israel anna ikkayu kappaya bakkanna Judyu a maddayaw ki Dios, dingngaggandawino itulduk. ");
INSERT INTO gdg_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ino Dios a dayawantama gakagaka i Israel, pinilineno gagginafutamira. Wasin nagyanira sey Egipto a bakkanna lubbunda, dinuffunannera e inoodduwera, kasena nepaiteno dokalla pannakadamana a nepawaya sikwara sino kinaaripanda sinay. ");
INSERT INTO gdg_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Wasin appatafuluwa runa malallakarira sino kalolowat, neyattammeno aꞌakwandera e inimuꞌnera. ");
INSERT INTO gdg_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Wasin ginamwangira sey Canaan, nepangaffuꞌnera sino pituwa a lubbun sinay takesi ino tolenereno makangkwa sino lubadda. ");
INSERT INTO gdg_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Mangiyafu sin inangnganda sey Egipto kiyad si akwaranino lubag, kalimatut si limafuluwa run. “Wasinoy, dinotukani Diosino ukumira a mepatapataliya matturay sikwara makkiyad sino tiyempowi Samuel a gumalabbunna. ");
INSERT INTO gdg_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Sinoya tiyempo, narangngira si arira, e dinotukanna i Saulo a abbingi Kis a gakagaka i Benjamin ta antuweno arira si appatafuluwa run. ");
INSERT INTO gdg_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Kasena inariyi Saulo, e nepatalina i David ta antuweno arira. Kunnayawino sinapiti Dios mappeafu ki David, ‘I David a abbingi Jesse, antuweno anggangku se akwanna amminino sapitangku.’ ");
INSERT INTO gdg_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","I David kappayino gagginafuwi Jesus a dinunduni Dios a mangisalak sikwatama gakagaka i Israel, a antuweno nekarina siꞌin. ");
INSERT INTO gdg_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Sin liyeyi Jesus a umang manuldu, nagyaninni Juan a manuldu sikwatam ammina gakagaka i Israel ta ibobolitammaddino liwattamira anna mappabawtisaretammad. ");
INSERT INTO gdg_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Wasin araꞌniyenna mabalini Juan sino nadundunanna, sinapiꞌna sino tolayira si, ‘Ariddonakuy si ikkanakino dinunduni Dios a mangisalak sikwayu, gampade bakkan. Ino mepatali sikwakino taronandaw, e mearipannaꞌngad sikwana, udde ammek meannunga mangwa se madayawingke.’ ");
INSERT INTO gdg_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ikkayuwa kakkolakkuwa gakagaka i Abraham, anna ikkayu kappaya bakkanna Judyu a maddayaw ki Dios, ikkanetamino nappakaammuwani Dios nu ansanneno akkesalakantam. ");
INSERT INTO gdg_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Udde ino tolayira sey Jerusalem andino tatturayira, ammera inammu si i Jesusino dinunduni Dios a mangisalak sikwara, se ammera naawatanino babbasanda kadda Sabadu a neturakkino gumalabbunira i Dios siꞌin. Udde neyakkurudda payino neturakkino gumalabbunira se nepapapatera i Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Massiki awana gafuneno pamapatayanda sikwana, inaranda ki Pilato si papatayanna. ");
INSERT INTO gdg_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Wasin inangwarenoy e neyakkuruwin amminino neturak mappeafu sikwana, nepaarira sino krus e sinannanda. ");
INSERT INTO gdg_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Udde nepangngangoliyi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","E odduwa awa napappadda i Jesus sikwara a nebumbulun sikwana a naggabwat sey Galilea a inang sey Jerusalem. E sitoya, ireno mangipakaammu mappeafu ki Jesus sikwatama Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Antuweno inangngammi sitawa mituldu sino nalawara damag sikwayu. Ino nekariyi Dios sino gagginafutamira siꞌin, ");
INSERT INTO gdg_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","antuweno neakkurug sikwatama gakagakara, se sitoya, nepangngangolina i Jesus. Antu kappayino sapitannino neturak sino mekadwa a Salmo a kunna si, ‘Ikkeno abbingku. Sitoya, ipakaammuk si ikkanakino amam.’ ");
INSERT INTO gdg_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Ana kappayino neturak sino sapiti Dios mappeafu sino nangngangoliyani Jesus ta ammena mananawuweno baggina si makkikiyad, e sinapiꞌna si, ‘Iyaꞌdaꞌnga sikwayuweno nalawara nekarik ki David a gakkuruwingke a makwa.’ ");
INSERT INTO gdg_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","E ana kappay neturak sino korwana Salmo a kunna si, ‘Ikkeno nappili sikwaka masserbi sikwam, e ammem purayan si mananawuweno baggik.’ ");
INSERT INTO gdg_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bakkanni David ino sapitannenay, se wasin binalinnanino nepakwa i Dios sikwana sino katolena, natay. Sinananda sino tanammino gagginafunera, kasena nananawu. ");
INSERT INTO gdg_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Udde i Jesus, ammena nananawu, se nepangngangoliyi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Kakkolak, anggangku si maammuwandaw yaw, gafu sino inangwa i Jesus, dama i Dios a pakomanino liwattam. ");
INSERT INTO gdg_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Se gafu sikwana, ibilangi Dios si naggaddangngino massiki sanna a tolaya mangurug, udde awan sikwatama mebilang si naggaddang sino angngitana gafu sino panguruwantam sino lintiyi Moises. ");
INSERT INTO gdg_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Kunna mantu, mappalangkayu takesi ammena makwa sikwayuweno sinapitino gumalabbunira i Dios siꞌin a kunna si, ");
INSERT INTO gdg_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Itandaw, ikkayuwa mangilopalopet sikwak, aneno akwangku sino katoleyuwa kakkaꞌbaw, udde matekayu pelang, se ammeyu kuruwan, massiki wara mituldu sikwayu.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Wasin nabalininnino sinapiti Pablo, nallawanira anni Bernabe sinaya sinagoga, e inayanireno tolayira si manuldu kappay sino metufara Sabadu ta tubburandeno netuldura. ");
INSERT INTO gdg_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Wasin nallawaninnino tolayira, odduweno nebumbulun sikwara Pablo a Judyu anna bakkanna Judyu a manuntul sino aggangwana Judyu. Nakitatabbadda Pablo sikwara, e netuldura si mattalaginarira nadda manalak sino allakki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Waso metufara Sabadu, maggi ammina tolay sinaya lubbun, nakkakarampattira a nakidingngag sino sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Udde waso initeno Judyuwereno odduwa tolay, inilliyerangke, neyatatalda i Pablo, e kinontarareno sinapiꞌna. ");
INSERT INTO gdg_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Udde naturibbelanda Pablo anni Bernabe a nassapit si, “Maawag si ikkayuwa Judyuweno palunguwa passapitammi sino sapiti Dios. Udde gafu se inammeyu, kunnangke ukumandawino baggiyungkepaya ammekayu meannunga maaꞌdan si biyaya mannayun. Antuweno anawammikayu e umangkamiya manuldu sino bakkannira a Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Se kunnayawino sinapiti Afu Dios sikwami, ‘Pinilitakayu si kunnangke sirwat sino bakkannira a Judyu ta tulduwandaw ammina tolay sito lubag takesi mesalakanira.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Wasin diningngaggino bakkannira a Judyuweno sinapiti Pablo, maanggammira e dinayora i Dios gafu sino diningngadda a sapiꞌna. E ino piniliyera i Dios ta mabiyayira si makkikiyad, nanguruwira. ");
INSERT INTO gdg_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Waso kunnenoy, naddidingngaggandeno sapiti Dios mappeafu ki Afu Jesus si palulubbun sinay. ");
INSERT INTO gdg_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Udde ino Judyuwera a amme mangurug, sinussuwandeno tatturayira a lallaki sinaya lubbun andino bafaꞌnangngira a bafabbaya maddayaw ki Dios takesi padyatandara Pablo anni Bernabe. E nepaanorera sinaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Sinattaꞌda Pabloweno lafuk sino takkira ta pangammuwanino tolayira si ireno makammu sino kastigura, kasera inang sey Iconio. ");
INSERT INTO gdg_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Udde ino nanguruwira ki Jesus sey Antiokia, nafulotino aangganda se natuyaggino pannakadameno Espirituwi Dios sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Wasin inanda Pablo anni Bernabe sey Iconio, inangwara kappayino inangwara sey Antiokia, se inangngira sino sinagogeno Judyuwera, e gafu sino nanulduwanda, odduweno nanguruwa Judyu anna bakkanna Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Udde ino Judyuwera a mammaya mangurug, sinussuwandeno bakkannira a Judyu takesi kababannaddeno manguruwira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Udde massiki kunnenoy, nabayadda Pablo anni Bernabe sinay e naturirirangke a manuldu mappeafu ki Jesus. E nepaita i Jesus si gakkuruwino ituldura mappeafu sino allaꞌnga, se inaꞌdannera si pannakadamara a mangwa si kakkaꞌbaw. ");
INSERT INTO gdg_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Naggadweno tolayira sinaya lubbun, se aneno dinandan sino Judyuwera a ammera mangurug, e ino korwanira, dinandanira sino apostolira. ");
INSERT INTO gdg_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Waso kunnenoy, ino Judyuwera andino bakkannira a Judyu andino tatturerera, nattatarabbanda si padyatandara Pablo anna lapalappaggandera takesi matayira. ");
INSERT INTO gdg_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","Udde wasin naammuwanda Pabloweno pamapatayanda nad sikwara, nabbukalira a inang sey Listra anna sey Derbe andino korwana lulubbuna sakopanna Licaonia. ");
INSERT INTO gdg_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","E nanulduwera kappay sino nalawara damag mappeafu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Wasin agyanira sey Listra, agyanino lalakiya pilaya ammena nakakkapana nallakad kiyad sin neyanakanna. ");
INSERT INTO gdg_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Wasin aggatuttura maddingngag sino sapitanni Pablo, sinulangngani Pablo, e naimunuwanna si kuruwanna si damana a maariyeno pilena. ");
INSERT INTO gdg_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","E nekokwana a nassapit si, “Mattaꞌdagga.” Gabwat kunnino lalaki e nallakarin. ");
INSERT INTO gdg_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Wasin initeno tolayireno inangwa i Pablo, nekulawura sino damiꞌda a Licaonia, a kunda si, “Irayawino diostama nabbali si tolaya naddassag sikwatam.” ");
INSERT INTO gdg_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","E nginandera si anganino diosdera. I Bernabe, nginanda si Zeus, e i Pablo, nginanda si Hermes se antuweno kanayuna maddamit. ");
INSERT INTO gdg_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ino templowa paddayawanda ki Zeus, ana sey lasinneno lubbunda. Waso kunnenoy, ino padira, neyangngeno bakera a torowa nagunggunan si sabung sino lamwanganino lubbun, se angganda ammina miwaꞌlat sikwara Pablo se ira kanuweno diosda. ");
INSERT INTO gdg_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Wasin naammuwanda Bernabe anni Pabloweno angganda a akwan, pinipissereno barawasirangkepaya pitanda si malowino nakanda. Nekangkanda sino tolayira, e nekokwara a nassapit si, ");
INSERT INTO gdg_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Sannemmangke yan akwandoya? Tolekami pelanga kakunnayu. Ino gakkammiya inang sitaw, ipakaammumi sikwayuweno nalawara damag mappeafu ki Jesus, takesi talekkurandawino aggangwayuwa awana pattupakkanna e kuruwandawino aggabiyaya Dios a namaratu sino langit, yo lubag, ino bebay, andino ammina igyanda. ");
INSERT INTO gdg_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Siꞌin, nepureneno kakunnayuwa bakkanna Judyu a mangwa sino angganda a akwan. ");
INSERT INTO gdg_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Udde ammena inibbatta mangipaita sino kinalawanna sikwara sino odduwa duffunna, se antuweno mangaꞌda si uran andino pattufuwanino mula ta wara ikabiyaddaw takesi maanggangkayu.” ");
INSERT INTO gdg_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Udde massiki sinapiti Pablo inay, nadyataningke a mallang sino tolayira takesi ammera miwaꞌlat sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Waso kunnenoya agyanira kepay sey Listra, ginamwangino Judyuwera a naggabwat sey Antiokia anna sey Iconio. Sinussuwandeno tolayira e ilapalappadda i Pablo, kasera binuꞌbuta nelawan sino lubbunda, se aridda si natayin. ");
INSERT INTO gdg_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Udde wasin inaribumbunganino manguruwira, ginabwakkappay e nuli sino lubbunda. Wasi kadaramaꞌna, inanda Pablo anni Bernabe sey Derbe. ");
INSERT INTO gdg_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Wasin ginamwanda Pablo anni Bernabe sey Derbe, nepakaammureno nalawara damag, e odduweno nanguruwira ki Jesus. Kasera nuli sey Listra anna sey Iconio, e nangawwatira sey Antiokia a sakopanna Pisidia, ");
INSERT INTO gdg_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ta pattuyaggandeno angnguruwino nanguruwira. Sinapiꞌda sikwara si, “Massiki sanneno makwa sikwayu, mattalaginaggayu nadda mangurug, se maawag si mallawumetam ammin si odduwa dyat liyetama medagga sino patturayani Dios sey langit.” ");
INSERT INTO gdg_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Kadda lubbuna inangnganda, nanotuꞌda Pablo si pangafuwanirana mangurug. Nakkararira anna nallantangira a mangngan, e netalaꞌdera ki Afu Jesus a kinurudda takesi antuweno mimut sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Wasin nallaꞌwuꞌda Pablo anni Bernabe sey probinsiya a Pisidia, ginamwangira sey probinsiya a Pamfilia. ");
INSERT INTO gdg_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","Nanulduwera mappeafu ki Jesus sey Perge, kasera inang sey Atalia. ");
INSERT INTO gdg_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","E nattakayira si bafora nuli sey Antiokia a sakopanna Siria. Se ino manguruwira sinay, ireno namaikkata nikararag sikwara Pablo takesi duffunanira i Afu Dios a mangwa sino pakwana. E binalindanino nepakwana sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Wasin ginamwangira sinay, nepakakarampaꞌdeno manguruwira, e netuldura amminino nepakwa i Dios sikwara. Netuldura kappayino nepakaammuwi Dios a massiki ino bakkannira a Judyu, damara a mangurug. ");
INSERT INTO gdg_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Nabayira sey Antiokia a nakiigyan sino manguruwira sinay. ");
INSERT INTO gdg_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Waso kunnenoy, agyanireno naggabwat sey Judea a inang sey Antiokia, e nanulduwera sino manguruwira ki Jesus a kunda si, “Ammekayu mesalakan nu ammekayu mappakugita metuntul sino lintiyi Moises.” ");
INSERT INTO gdg_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Udde da Pablo anni Bernabe, ammera anggammino sinapiꞌda e nakisosombatira sikwara. Antu gafuna, nattatarabbanino nanguruwira a pabonanda Pablo anni Bernabe andino korwanira a manguruwa umang sey Jerusalem takesi bebutanda sino apostolira andino pangafuwanirana manguruwira mappeafu sino nassasarombatanda. ");
INSERT INTO gdg_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","E nepagikkaꞌdera. Wasin nekwera sey probinsiya a Fenicia anna Samaria, nesisippalda a nepadamag sino manguruwira a nanguruwinnino bakkannira a Judyu ki Jesus. E maanggammingke ino manguruwira a naddingngag sinay. ");
INSERT INTO gdg_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Wasin ginamwangira sey Jerusalem, maanggammino manguruwira andino pangafuwandera andino apostolira a nappaamwang sikwara. E sinapiꞌda Pablo amminino inangwara a duffuni Dios sikwara a manuldu sino lulubbuna inangnganda. ");
INSERT INTO gdg_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Udde nattaꞌdaggino korwanira a Fariseowera a manguruggappay ki Jesus, e nekunda si, “Tulduwantammaddino bakkannira a Judyu ta mappakugitira anna tuntulanda kappayino korwana lintiyi Moises.” ");
INSERT INTO gdg_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Antuweno nammamitingino apostolira andino pangafuwanirana manguruwira takesi pattatarabbanda. ");
INSERT INTO gdg_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Wasin nabayirana mattatarabbag, nattaꞌdaggi Pedro, e kunna si, “Kakkolakku, aggaammundaw si ikkanakino piniliyi Dios sikwatam siꞌina umang mibanyag sino nalawara damag sino bakkannira a Judyu takesi dingngagganda anna kuruwanda. ");
INSERT INTO gdg_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","I Dios a nakaammu sino ana sino nakammino tolayira, nepaitana si anggammeno nanguruwanino bakkannira a Judyu, se neyaꞌdaneno Espirituna sikwara a kunna kappayino nepangaꞌdana sikwatam. ");
INSERT INTO gdg_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Awana naddadarumanneno inangwana sikwatam, se inarina kappepayino narakkat sino nakanda gafu sino nanguruwanda. ");
INSERT INTO gdg_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Nu kunna mantu, mayan subukandawi Dios a patutandawino bakkannira a Judyu a manuntul sino lintiyi Moises? Se massiki ikkanetama Judyu andino gagginafutamira siꞌin, ammetam nakatuntul. Santam lang paidammanino bakkannira a Judyu a sapitantam si tuntulanda ammin inay? ");
INSERT INTO gdg_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Ammena nad kunninoy, se kuruwantam si mesalakanetam gafu pelang sino allakki Afu Jesus, e kunna kappay sikwara.” ");
INSERT INTO gdg_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Wasin nasinduwenni Pedro, sininakkino tolayira a maddingngag sikwara Bernabe anni Pablo sino pitulduwanda sino kakkaꞌbawa nepaangwa i Dios sikwara sin inangnganda sino bakkannira a Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Wasin nasinduwennino sinapiꞌda, nepataliyi Santiago a kunna si, “Kakkolak, dingngaggandaꞌngad. ");
INSERT INTO gdg_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Assapikkepayi Simon Pedro sino palunguwa nipaitani Dios sino allaꞌnga sino bakkannira a Judyu a namili sikwara si mesapat sino tolenera. ");
INSERT INTO gdg_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Iyawa inangwa i Dios, nekunna sino neturakkino gumalabbunnera siꞌina kunda si, ");
INSERT INTO gdg_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Kunni Afu Dios si, Naso maddagguna aw, muliyak kappay sikwayuwa Judyu ta gabwatangku kappayino nadaralla balayi Ari David e pabbawungkuneno patturayanna. ");
INSERT INTO gdg_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","Antuneno akwangku takesi anggandaka ammunino korwanira a tolay, amminino bakkannira a Judyu a pinilika mabbali si tolek. ");
INSERT INTO gdg_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Kunnenoyino sinapiti Afu Dios a nepakaammuna siꞌin.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Nekungkappayi Santiago si, “Ino ana sino nakangku, ammetammad paidammanino bakkannira a Judyu a mangurug ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Turakkantamira lud ta ituldutam pelang sikwara a ammera nad mangngan si newaꞌlat si sinandiosira anna ammera massira si ada onnu napattalla animala ammena naariyeno adana, anna ammera makidurug si bakkanna atawara. ");
INSERT INTO gdg_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Se ammu amminino Judyu inayira a lintig, se kiyad siꞌin, babbasanda kadda Sabaduweno lintiyi Moises sino ammina sinagoga sino palulubbun. Antuweno nalawad nu tuntulandenay, takesi ammena malowino nakammino kakkolaꞌdera a nanguruwa Judyu.” ");
INSERT INTO gdg_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Wasinoy, ino apostolira andino pangafuwanira andino amminira a manguruwa nakkakarampat sinay, nattatarabbanda si mamiliyera sikwara si lallakiya mebulun sikwara Pablo anni Bernabe a umang sey Antiokia. Ino pinilira, da Judas a ngananda kappay si Barsabas anni Silas, a ireno iyatal amminino manguruwira. ");
INSERT INTO gdg_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Antuyawino nepaappara a turak sikwara: “Ikkamiya kakkolaꞌdawa apostol anna pangafuwan sito Jerusalem, antuyawino turaꞌmi sikwayuwa bakkanna Judyu a mangurug sitan Antiokia, Siria, anna Cilicia. ");
INSERT INTO gdg_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Nadingngammiya agyanino inang sitana naggabwat sitawa bafulummiya nangungkul sikwayu gafu sino netuldura sikwayu. Udde bakkanna ikkamiyeno naggabwatanino netuldura. ");
INSERT INTO gdg_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Antu gafuneno nattatarabbammi e nappilikami si umang sitana miyang sito turaꞌmi e mebulunira sikwara Bernabe anni Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Da Bernabe anni Pablo, ireno nadikkatta bulummiya nangipusta sino angaꞌda a masserbi ki Afutama i Jesu Kristo. ");
INSERT INTO gdg_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Pinilimi kappera Judas anni Silas a mebulun sikwara a manaꞌdag sino sapitanna yawa turaꞌmi. ");
INSERT INTO gdg_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Ino anggammiya sapitan sikwayu, antu kappayino anggammino Espiritu Dios, se nepadandamma sikwami si ammemikayu paidammana manuntul sino ammina lintiyi Moises. Ira nabbelang yawino tuntulandaw. ");
INSERT INTO gdg_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Ammekayu nad mangngan sino newaꞌlaꞌda si sinandiosira, ammekayu massira si ada, ammekayu massira si napattalla animala ammena naariyeno adana, anna ammekayu makidurug si bakkanna atawayu. Nalawad nu anusandawa tuntulan yawa sinapiꞌmi. Antuwen inoyino anggammiya sapitan sikwayu.” ");
INSERT INTO gdg_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Wasin neturaꞌdenoya turak, nepabondeno umangngira sey Antiokia. Wasin ginamwangira sinay, nepakakarampaꞌdeno manguruwira, kasera neduwaweno turak. ");
INSERT INTO gdg_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Wasin binasarenoya turak, maanggammirangke gafu sino nalawara sapitanna. ");
INSERT INTO gdg_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Oddu kappayino netuldura Judas anni Silas sikwara a mapattuyag sino angngurudda, se mangipakaammuwera kappay sino ipakaammuwi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Wasin nabayiran sinay, angganda a muli sino naggabwatanda. E nalawarino nepamaikkatino manguruwira sikwara sino nuliyanda sino nanundunira sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Udde i Silas, anggamma a mabattang sinay. ");
INSERT INTO gdg_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Da Pablo anni Bernabe, nagyanira sey Antiokia a manuldu anna mangibanyag mappeafu ki Afu Jesus. Oddu kappayino bafulundera a manuffun sikwara a nanuldu sinay. ");
INSERT INTO gdg_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Wasin nallaꞌwutino pipidya aw, sinapiti Pablo ki Bernabe si, “Anta dorawanino kakkolattera sino lulubbuna nitulduwanta sino sapiti Afu Dios ta itanta nu manantawiran.” ");
INSERT INTO gdg_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","I Bernabe, anggamma a ibumbuluni Juan Marcos. ");
INSERT INTO gdg_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Udde i Pablo, ammena anggam, se wasin nagyananda sey Pamfilia, inanawanira i Juan Marcos e ammena netupakka nanuffun sikwara sino tarabafura. ");
INSERT INTO gdg_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Gafu sinoy, nappelalotino nepattutukkira, kasera nakkatway. Inayani Bernabe i Marcos, e nattakayira si bafora inang sey Chipre. ");
INSERT INTO gdg_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","I Pablo, inayanna payi Silas a bulunna. Nekararanino manguruwira ta duffunanira i Dios sino ammina anganda, kasera inanaw. ");
INSERT INTO gdg_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Inanannereno lulubbun sey Siria anna sey Cilicia a mappatuyag sino angnguruwino manguruwira. ");
INSERT INTO gdg_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Waso kunnenoy, inanda Pablo anni Silas sey Derbe anna sey Listra, e antuweno nanaꞌnganda ki Timoteo a tata a mangurug ki Jesus. Judyuweno inana a manguruggappay ki Jesus, udde Griegoweno amana. ");
INSERT INTO gdg_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Dinayaw amminino manguruwira i Timoteo sey Listra anna Iconio. ");
INSERT INTO gdg_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Anggammi Pablo a ibumbuluni Timoteo sikwara. Udde gafu se ammu amminino tolayira sinay si ammena nakugiti Timoteo se bakkanna Judyuweno amana, nepakugiti Pablo, takesi ammena malowino nakammino kasiJudyura sino lulubbuna umangngandana. ");
INSERT INTO gdg_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Sino ammina inangnganda Pablo, nepakaammura sino manguruwireno neturakkino apostolira andino pangafuwanira sey Jerusalem, e sinapiꞌda si nalawad yawa tuntulan. ");
INSERT INTO gdg_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Antu gafuna, nattuyaggino angnguruwino manguruwira sino lulubbun, e kadda aw, madadaggananira. ");
INSERT INTO gdg_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Waso kunnenoy, inang kappera Pablo sey Frigia anna sey Galacia, se inallangnganireno Espirituwi Dios sino umangnganda nadda manuldu sey Asia. ");
INSERT INTO gdg_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Wasin ginamwangira sino pampangnga probinsiya a Misia, dinandanda a umang sino probinsiya a Bitinia, udde inallangnganira kappayino Espirituwi Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Antu gafuna, ilaꞌwutanda pelangino Misia e nangawwatira sey Troas. ");
INSERT INTO gdg_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Wasi gafi, agyanino nepaita i Dios ki Pablo si kunnangke tenap, e naitaneno tata a lalakiya taga-Macedonia a aggataꞌdagga mappekakallak sikwana a kunna si, “Umangkayu sito Macedonia ta duffunandakami.” ");
INSERT INTO gdg_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Gafu se nepaita i Afu Diosino kunnenoy, ginikkakkamiya inang sey Macedonia, se inammumi si antuweno anggammi Afu Dios a angammiya panulduwan sino nalawara damag. ");
INSERT INTO gdg_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Wasin ginikkakkami sey Troas, nattakekami si bafora nangawwat sey Samotracia. Wasin kadaramaꞌna, inangkamin sey Neapolis. ");
INSERT INTO gdg_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Naddassaggami sinay e nallakaggamiya inang sey Filipos a kadodokkallana lubbunna Macedonia. Ino kaodduwanna tolay sinaya lubbun, taga-Romera. Nagyangkami sinay si pipidya aw. ");
INSERT INTO gdg_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Wasin awna aggimwangan, nallawangkami sino lubbun e inangkami sino dappiꞌna wawwang, se dinandammi si wara pakkararanna Judyu sinay. Nattuttuggami e nakitatabbaggami sino bafabbayira a nakkakarampat sinay. ");
INSERT INTO gdg_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Ino tata a naddingngag sikwami e i Lydia a taga-Tiatira a gumalaku si nangina a sinnun. Massiki bakkanna Judyu, maddayaw ki Dios, e dinuffunani Dios takesi naawatanneno sinapiti Pablo e kinurungnga. ");
INSERT INTO gdg_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nappabawtisarda Lydia annino kataabbalayanna, kaserakami inayana kunna si, “Nu innanamandaw si gakkuruwa manguruwak ki Afu Jesus, umangkayu magyan sey balemi.” E pinatuꞌdakamiya inayan e inangkami. ");
INSERT INTO gdg_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Wasin tata si awa inangngammi anda Pablo sino akkararan, dinambaldakamiyeno aripanna balatanga naunaggan si narakkatta espirituwa mappalabbun sikwana sino makwana so maddagguna aw. Gafu sinaya aꞌakwanna, odduweno piraka inappeno nangaripannira sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Dinandanandakami anda Pablo e nekulakulawuna si, “Iyawira a tolay, aripannira i Dios a Kasoꞌdan! Ipakaammura sikwayuweno kesalakandaw!” ");
INSERT INTO gdg_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Odduwenna awa kunna pelang inoyino aꞌakwanna makkiyad si natappaggi Pablo. E inaꞌlangngeno balatang, kasena sinapit sino inunag sikwana si, “Gafu sino pannakadama i Jesu Kristo, anawannun.” E kakaꞌmeng kelanga inanawino inunag sino balatang. ");
INSERT INTO gdg_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Wasin naammuwanino nangaripannira sikwana a awaninna pangappanda si pirak, dinoꞌmandara Pablo anni Silas e binalabuꞌbuꞌdera a neiyang sino agyananino tatturayireno lubbunda. ");
INSERT INTO gdg_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Nepaaꞌlandera sino turayira e sinapiꞌda si, “Judyuwera yaw, e gulunda yo lubbuntam, ");
INSERT INTO gdg_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","se ituldureno ammena mepangngat sino lintiddam. Rometam e ammetam dama a tuntulannino gagangena korwan.” ");
INSERT INTO gdg_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","E amminino tolayira, nakkulawuwera se nabbungubungutira sikwara Pablo. Nepabboyangino turayirara Pablo anni Silas, e nepasiwaꞌwaꞌdera. ");
INSERT INTO gdg_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Wasin siniwasiwaꞌwattandera, nebaluddera. E sinapiꞌda sino afafuneno abbaluran si aggaindaggannerangke. ");
INSERT INTO gdg_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Gafu se antuweno sinapiꞌda sikwana, neangngera sino tangngana abbaluran e sinalpiꞌneno takkira si kayu. ");
INSERT INTO gdg_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Wasin tangngenna gafi, makkararadda Pablo anni Silas e makakkantera a maddayaw ki Dios, e aggadingngaggino korwanira a balud. ");
INSERT INTO gdg_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Kakaꞌmeng kelanga nalunig si natuyag e naguyaguyaddino abbaluran e nabukkatanino kayatanira. Naari amminino kawarino balurira. ");
INSERT INTO gdg_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Nafatino afafuneno abbaluran, initana a nabukkatanino kayatanira, e ngananna si nabbukal amminino balurira. Sinuꞌnuꞌneno saseꞌna e papatayanna naddino baggina. ");
INSERT INTO gdg_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Udde nekokwa i Pablo a nassapit si, “Ammem papatayan yan baggim. Ayokami ammin sitaw.” ");
INSERT INTO gdg_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Nappaappeno afafuneno abbaluran si sirwat sino bulunna. Nakkangkama sinallung sino agyananda Pablo anni Silas, e namalitud sino aꞌlanda a mayyaꞌyak gafu sino talona. ");
INSERT INTO gdg_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Kasenera nepallawan, e sinapiꞌna sikwara si, “Afu, sanneno akwangku takesi mesalakanak?” ");
INSERT INTO gdg_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","“Mangurugga ki Afu Jesus ta mesalakangka, massiki ino kataabbalayannu,” nekunda sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Kasera netulduweno sapiti Dios sikwara ammina taabbalay. ");
INSERT INTO gdg_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Massiki tangnga kepena gafi, neyangngino afafuneno abbaluran da Pablo sino agyananino danum takesi unafanneno biyaddera. Wasin nasinduwenoy, nappabawtisarira a taabbalay. ");
INSERT INTO gdg_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Kasera inayanda Pablo anni Silas sino balera, e pinakkandera. Maanggammirangke a taabbalay gafu sino nanguruwanda ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Waso kadaramaꞌna, nanundunino tatturayira si pulisa umang sino afafuneno abbaluran ta sapitanda si, “Palawanandora Pablo anni Silas.” ");
INSERT INTO gdg_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Antu gafuna, sinapitino afafuneno abbaluran sikwara Pablo si, “Sinapitino tatturayira a damayuna mallawan. Manokayun, a ikkayu pelangino nakaammu.” ");
INSERT INTO gdg_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Udde sinapiti Pablo sino pulisira, “Siniwaꞌwatandakami sino naraꞌlanganino tolayira, gampade awana liwaꞌmi, e nebaluddakami kappay. Ammena dama a mangwa si kunnayan sino tolaya Roma. Sitoya, pallawanandakamiya awana nangammu. Ammena dama, umangngaddino tatturayira a milawan sikwami ta ammunino tolayira si awana liwaꞌmi.” ");
INSERT INTO gdg_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Inang netulduweno pulisireno sinapiꞌda Pablo sino tatturayira. Nakatalawira sin diningngadda si Roma kappera Pablo anni Silas. ");
INSERT INTO gdg_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Inangngira sey kwara Pablo a nappekakallak, kaserera nelawan e inaranda si manawira sinaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Wasin nallawanda Pablo anni Silas sino abbaluran, inangngira sey balera Lydia. Sinatabbaddeno manguruwira a nakkakarampat sinaya nappatuyag sino angngurudda, kasera inanaw sinaya lubbun. ");
INSERT INTO gdg_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Waso kunnenoy, nassisippalda Pablo anni Silas sey Amfipolis anna Apolonia, kasera ginamwang sey Tesalonica a agyananino tata a sinagoga. ");
INSERT INTO gdg_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Inangngi Pablo sinaya sinagoga a manuldu mappeafu sino sapiti Dios, se antuweno gagangena, e antuweno inangwana si talluwa Sabadu. ");
INSERT INTO gdg_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ino netulduna, ino neturak sino sapiti Dios a kunna si madyatan naddi Kristo e matay, kasena mangngangoli. “I Jesus a ipakaammuk sikwayu, antuwi Kristo a dinunduni Dios a matturay,” kunna. ");
INSERT INTO gdg_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Aneno korwanira a Judyu a kinuruddeno sinapiti Pablo, e nedaggera sikwara Pablo anni Silas. Oddu kappayino nangurug sino Griegowera a bakkanna Judyu a maddayaw ki Dios, anda sino bafabbayira a bafaꞌnang. ");
INSERT INTO gdg_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Udde ino Judyuwera a ammera mangurug, inimallira, e inamamundeno narakkattira a tolaya matarut, takesi gulundeno lubbun. Ginamwandeno balera Jason se tufukandara Pablo anni Silas takesi iyandera nad sino pammamitinganino tolayira. ");
INSERT INTO gdg_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Udde wasin ammerera masumpalan, binuꞌbuꞌdara Jason andino korwanira a mangurug e neiyandera sino tatturayirana lubbun. E nekokwara a nassapit si, “Inayira a tolaya nakkungkul sino tolayira si korwana lulubbun, inangngira kappay sitaw. ");
INSERT INTO gdg_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","E iyawa Jason, nepadiloꞌnera sino balera. E amminira, ammera tuntulannino lintiyino Emperador, se sapitanda si aneno korwana ariya i Jesus kanuweno anganna.” ");
INSERT INTO gdg_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Naburuburungino tatturayira andino tolayira sin diningngaddenoy. ");
INSERT INTO gdg_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","Nepappagarara Jason si odduwa pirak a iyulira nu awaninna narakkat si akwanda Pablo, kaserera nepaanaw. ");
INSERT INTO gdg_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Wasin massiꞌlappin, nepaanawino manguruwirara Pablo anni Silas a umang sey Berea. Wasin ginamwangiran sinay, inangngira sino sinagogana Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ino Judyuwera sinay, nannakammira amma sino taga-Tesalonicera, se angganda a dingngaggannino damag mappeafu ki Jesus, e kadda aw adalandeno neturakka sapiti Dios takesi ammunda nu gakkuruwino tulduwi Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Odduwera a Judyu a mangurug, e oddu kappaya bafaꞌnangnga bafabbay anda lallakiya Griegowa mangurug. ");
INSERT INTO gdg_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Udde wasin diningngaggino Judyuwera sey Tesalonica si manuldu kappayi Pablo sino sapiti Dios sey Berea, inangngira sinay e sinussuwandeno tolayira takesi kababannadda kappera Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Ino manguruwira, kinangkamanda a nepagikkaꞌda Pablo a umang sino dappiꞌna bebay. Udde da Silas anni Timoteo, nabattangira sey Berea. ");
INSERT INTO gdg_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ino nitulurira ki Pablo, nakkiyarira sey Atenas, kasera nuli sey Berea a umang mituldu sino sinapiti Pablo sikwara Silas anni Timoteo a makkangkamira nadda dumandan sikwana sey Atenas. ");
INSERT INTO gdg_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Wasin pattaronani Pablo sikwara Silas anni Timoteo sey Atenas, malowingke ino nakamma gafu sino odduwengke a initana a sinandiosdera. ");
INSERT INTO gdg_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Antuweno inangnganna sino sinagogana Judyu a manuldu sikwara andino bakkannira a Judyu a maddayaw ki Dios. Kadda aw kappaya umang sino pakkakarampattanino tolayira ta tatabbannera. ");
INSERT INTO gdg_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Nagyangkappayino mammesturuwerana Epicureo anda Estoico a nakisombat sikwana. Sinapitino korwan sikwara si, “Sannera kanu payino sapitanna yaw?” Udde kumpayino korwanira si, “Kunnangke itulduneno diosdera sey agyananda.” Sinapiꞌdenay gafu sino nibanyani Pablo mappeafu ki Jesus annino pangngangoliyan. ");
INSERT INTO gdg_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Antu gafuna, neyanda i Pablo sino pakkakarampattanino konsisaldera a ngananda si Areopago, e kunda sikwana si, “Anggammiya ammuwan iyawa bawuwa tuldum. ");
INSERT INTO gdg_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Se ino korwana sinapiꞌnu, bawuwa dingngammi yan, e anggammi nadda maammuwan nu sanneno anggamma a sapitan.” ");
INSERT INTO gdg_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(Antuwenoyino sinapiꞌda ki Pablo se ira ammina taga-Atenas annino ginamwangira sey Atenas, paangganda a mituldu anna maddingngag si bawuwa tuldu.) ");
INSERT INTO gdg_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Wasinoy, nattaꞌdaggi Pablo sino aꞌlanda, e nekunna si, “Ikkayuwa taga-Atenas, ammuka gakkuruwandawa dayawannino diosdawira. ");
INSERT INTO gdg_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Se wasin nannodoyuwak sito lubbundaw, odduweno initaka paddayawandaw sino diosdawira. E initak kappayino tata a awwaꞌlatandawa aneno neturakka kunnayaw: ‘Antuyawino awwaꞌlatan sino dios a ammemi kepay inammu.’ Ino dayawandawa ammeyu inammu, antuweno ipakaammuk sikwayu. ");
INSERT INTO gdg_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Antuweno Dios a namaratu sito lubag anna si amammina ana sitaw, e ammena magyan si balaya inangwana tolay, se antuweno matturay sey langit anna sito lubag. ");
INSERT INTO gdg_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","E ammena awannino iyaꞌdana tolay sikwana, se antuweno naggabwatanna ammina maawangnga tolay, massiki ino angaꞌda anna ingkelamang. ");
INSERT INTO gdg_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Antuweno namaratu sino palunguwa tolaya naggabwatan ammina nganganna tolay sito lubag. Dinandamma kappay siꞌin nu ansanna kabayino patturayanino kadda tata a lubbun annino fustuwa pakkiyaranino lubbunda. ");
INSERT INTO gdg_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Inangwana yaw takesi dandammanda a mintufuk sikwana, tantaro nu sumpalanda sino pakkarabakafanda a mintufuk sikwana, se ammena aroyu sikwatam ammin. ");
INSERT INTO gdg_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Kakunneno neturakkino tata sikwayuwa kunna si, ‘Gafu pelang sikwaneno natolayantam annino panikkarantam annino katotoletam.’ Kunna kappayino neturakkino bulundawa gumaturak siꞌina sinapiꞌna si, ‘Inangwaretami Dios a abbingnga.’ ");
INSERT INTO gdg_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Nu gakkuruwa abbindetami Dios, ammetammad nganan si kunnangke sinandiosa bulawan onnu gumbang onnu batuwa inangwana tolay gafu sino kinalainda. ");
INSERT INTO gdg_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Siꞌin, nepurayi Diosino narakkatta akwanino tolayira, se ammera kepay inammuwi Dios. Udde sitoya, sinapiꞌna sino ammina tolaya mabboboliyera nad sino narakkatta inangwara. ");
INSERT INTO gdg_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Se dinandammeno awa pangukumannana si ammina tolay sito lubag. Agyangkappayino tolaya pinilina a mangukum, e naggaddangngeno angngukumma. Nepakurungnga sino ammina tolay si antuweno pinilina gafu sino nangngangoliyanna.” ");
INSERT INTO gdg_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Wasin diningngaddeno sinapiti Pablo mappeafu sino nangngangoliyanino natay, nekakkataweno korwanira, udde sinapikkappayino korwanira si, “Anggammi kappaya dingngaggan yan sapitannu.” ");
INSERT INTO gdg_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Wasinoy, inanawanira i Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Udde agyanino dinandanira sikwana, e nanguruwira ki Jesus. Tata sikwara i Dionisio a turena Areopago, e agyangkappayino tata a bafaya mingngan si Damaris, e agyangkappayino korwanira. ");
INSERT INTO gdg_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Wasin inanawi Pablo sey Atenas, inang sey Corinto. ");
INSERT INTO gdg_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","E dinambalna sinayino Judyu a neyanak sey Ponto a mingngan si Akila annino atawana a i Priscila. Gaggamwanda a naggabwat sey Italia, gafu se sinapiti Emperador Claudio a manonad amminino Judyu sey Roma a kapitalna Italia. Dinorawanira i Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Gafu se nakakarunnera si tarabafuwa mangwa si tolda, nakikofung sikwara a makitarabafu. ");
INSERT INTO gdg_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Kadda awna aggimwangan, inangngi Pablo sino sinagogana Judyu a manuldu sino Judyuwera andino bakkannira a Judyu takesi manguruwira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Wasin ginamwanda Silas anni Timoteo a naggabwat sey Macedonia, nepatatenni Pabloweno manulduwa mipakurug sino Judyuwera a i Jesusino Kristo a dinunduni Dios. ");
INSERT INTO gdg_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Udde wasin kinontareno Judyuwera anna nassapasapitanda i Pablo, newawangngeno lafuk sino barawasina a mipaita si mibbattinna manuldu sikwara, e kunna si, “Kunna mantu, nu ammekayu mesalakan, bakkanna liwakku yan, liwaꞌdawingkepay. Mangiyafu sitaw, umangngak manuldu sino bakkannira a Judyu.” ");
INSERT INTO gdg_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Waso kunnenoy, inanawanira i Pablo e inang nanuldu sino balayi Ticio Justo a bakkanna Judyu a maddayaw ki Dios. Ino balena, ana sino aruruwino sinagoga. ");
INSERT INTO gdg_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Udde i Crispo a afafunenaya sinagoga andino kataabbalayannera, nanguruwira ki Jesus. Oddu kappay sikwara a taga-Corinto a nangurug sin diningngaddeno tulduwi Pablo, e nappabawtisarira ammin. ");
INSERT INTO gdg_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Wasin tata si gafi, nappatenappi Afu Jesus ki Pablo e sinapiꞌna si, “Ammeka mattalaw. Manulduka lud, e ammem ibbattan, ");
INSERT INTO gdg_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","se mebumbulunak sikwam. Imutantaka takesi awana mangansa sikwam, se oddu kepaya tolay sitawa lubbuna pabbalingku si tolek.” ");
INSERT INTO gdg_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Antu gafuna, nagyani Pablo sinay si manikadwarun si gadwa a manuldu sino sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Wasin nepataliyi Galion a naggubernador sey Acaya, nittateno Judyuwera a amme manguruwa inang nanoꞌma ki Pablo, dinoꞌmanda e neyanda sino pangukuman ta idarunda sino gubernador. ");
INSERT INTO gdg_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","E kunda si, “Iyawa tolay, manuldu si tanakwana paddayaw ki Dios a mekontara sino lintimmi.” ");
INSERT INTO gdg_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Wasin maddamiꞌnaddi Pablo, sinapiti Galion sino Judyuwera si, “Nannud wara liwaꞌna yan onnu inangwana si narakkat, dingngaggangku naddino sapiꞌdawa Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Udde gafu se ino nattatarukkiyandaw mappeafu pelang nu inyeno sapitannino lintiddaw, onnu ino anggamma sapitan inoy, ikkayuneno makammu, se ammek anggam yan.” ");
INSERT INTO gdg_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","E nepaanonera sino pangukuman. ");
INSERT INTO gdg_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Si kunna, nelasseꞌda i Sostenes a afafuneno sinagoga, e sinusultuꞌda sino aꞌlangino pangukuman, udde amme nepilingalinga i Galion. ");
INSERT INTO gdg_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Nabayi Pablo sey Corinto, kasena inanawanino manguruwira sinay, e inang sey Cencrea. E nebulunda Priscila anni Akila sikwana. Wasin ginamwangira sinay, nappausipi Pablo ta paitana si binalinnanino nekarina ki Dios. Kasera nattakay si bafora inang sey Siria. ");
INSERT INTO gdg_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","21","Wasin nitturira sey Efeso, inangngi Pablo sino sinagoga a nanuldu sino Judyuwera. Nappekakallakkira sikwara si mabayangngadda magyan sinay, udde ammena anggam. “Nu panggammani Dios, muliyaꞌnga sitaw,” kunna. Inanawannera, e nattakekappay si bafora inang sey Siria, udde da Priscila anni Akila, nabattangira sinay. ");
INSERT INTO gdg_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Wasin ginamwangi Pablo sey Cesarea, nallakara inang sey Jerusalem ta itanneno manguruwira sinay, kasena inang sey Antiokia. ");
INSERT INTO gdg_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Udde ammena nabayag, ginikkakkappaya umang maddoraw sino lulubbunna Galacia anna Frigia a manuldu sino manguruwira ta mattuyaggino angngurudda. ");
INSERT INTO gdg_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Agyanino tata a Judyu a ginamwang sey Efeso a taga-Alejandria a i Apolosino anganna. Nalainga manuldu e odduweno ammuna mappeafu sino nepeturakki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Nalappatta manuldu mappeafu ki Afu Jesus, e gakkuruwino netulduna, se sinulduwanda siꞌin. Udde ino pelang inammuneno netulduwi Juan annino namawtisaranna sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Wasin ginamwang sey Efeso, naturiringke a nanuldu sino sinagoga. Diningngadda Priscila anni Akileno tulduna, e inayanda sey balera takesi lawaranda a ituldu sikwaneno ammena kepay nadingngag mappeafu ki Jesus andino planowi Dios para sikwara a mangurug. ");
INSERT INTO gdg_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Wasin anggammi Apolos a umang sey Acaya, dinuffunanino manguruwira sey Efeso e nanurakkira sino manguruwira sey Acaya ta paamwanganda i Apolos. Wasin ginamwangi Apolos sinay, dokallino neduffunna sikwara a nangurug gafu sino allakki Dios sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","Se inaffuꞌneno Judyuwera sino nattatarukkiyanda sino aꞌlangino tolayira. Inaffuꞌnera se nalainga misapit sino sapiti Dios a mamakurug si i Jesusino Kristo a dinunduni Dios. ");
INSERT INTO gdg_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Wasin nagyani Apolos sey Corinto, nallakari Pablo sino kakulurana inang sey Efeso. Wasin ginamwang sinay, dinaꞌnganeno korwanira a mangurug, ");
INSERT INTO gdg_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","e kunna sikwara si, “Naaꞌdangkayu sino Espirituwi Dios sin nanguruwandaw?” “Awan, ammemi kepay nadingngag nu sanneno kunnuwa Espirituwi Dios,” kunda. ");
INSERT INTO gdg_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Sinapikkappayi Pablo, “Sanna mat mantuweno inammuwandaw sin nappabawtisarkayu?” “Ino inammuwammi ino bawtisara netulduwi Juan,” kunda. ");
INSERT INTO gdg_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Sinapikkappayi Pablo sikwara, “Ino netulduwi Juan, sinapiꞌna si iboboli naddino tolayireno liwaꞌda, kasera mappabawtisar. Udde sinapiꞌna kappay si kuruwanda naddino metufad sikwana a antuwi Jesus.” ");
INSERT INTO gdg_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Wasin diningngaddenoy, nappabawtisarira kappaya mangipakaammu si i Jesusino Afura. ");
INSERT INTO gdg_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Nepotuni Pabloweno kamaꞌna sikwara, e inangngino Espirituwi Dios sikwara, kasera naddamit si naddadaruma a damita bakkanna damiꞌda e netuldureno nepasapiti Dios sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Ino bilangino lallakiyera, inang si kadwafulu si adwa. ");
INSERT INTO gdg_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Tallu dakkino nanulduwani Pablo sino sinagoga sinay. Naturira nakisosombat sikwara mappeafu sino patturayani Dios takesi kuruwanda nad. ");
INSERT INTO gdg_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Udde ino korwanira, natuꞌnattira a mangurug, e nekakkatawareno tuldu mappeafu ki Jesus sino naraꞌlanganda. Antu gafuna, inanawanirara Pablo andino nanguruwira ki Jesus e inangngira sino giskwelani Tirano. Antuweno nanulduwani Pablo si kadda aw ");
INSERT INTO gdg_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","kiyad si adwarun. Gafu sinoy, amminira a tolay sey probinsiya a Asia, Judyuwera andino bakkannira a Judyu, nadingngadda amminino sapiti Dios mappeafu ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kakkaꞌbawingke ino inangwa i Pablo gafu sino pannakadama a neyaꞌda i Dios. ");
INSERT INTO gdg_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Se massiki panyok onnu gamita inusarna, nu iyanda sino malowanira, mabbattunoyira, e nu iyanda sino naunagganira, manawino inunag sikwara. ");
INSERT INTO gdg_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Wasinoy, nagyangkappayino Judyuwera a nannodoyuwa mappaanaw si inunag. Dinalodora a nusar sino angani Afu Jesus. Ino inangwara, sinapiꞌda sino inunag si, “Ikka a narakkatta espiritu, gafu sino pannakadama i Jesus a itulduwi Pablo, manokan.” ");
INSERT INTO gdg_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Ino nangwa si kunnenoy, ino pituwera a lallakiya abbingi Sceva a tata a pangafuwanna padi. ");
INSERT INTO gdg_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Udde sinabbino narakkatta espiritu si, “Ammuki Jesus, e massiki i Pablo, ammuk kappay. Udde ikkayu, sannakayu pay?” ");
INSERT INTO gdg_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Dinoꞌmanireno lalakiya naunaggan, sinusultuꞌngera e naaffutira ammin. Nabibiyaranira anna naboyanganira a nabbukal sino balay. ");
INSERT INTO gdg_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Amminino tolayira sey Efeso, Judyu anna bakkanna Judyu, diningngaddeno nakwa sino pituwera a makkakarolak, e nakatalawira ammin e dinayorangke ino pannakadama i Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Odduweno manguruwira a nipunnu sino narakkatta aggangwara sino naraꞌlanganino bulundera. ");
INSERT INTO gdg_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ino korwanira a manguruwa gumasalamangka siꞌin, inampaꞌdeno lebururera, e sinikkulanda sino naraꞌlanganda. Ino balorino sinikkulanda, inang si limafulu rifu sino piraꞌda. ");
INSERT INTO gdg_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Gafu sino kunnenoy, inoodduweno tolayira a naddingngag sino sapiti Dios mappeafu ki Jesus, e inodduwennino nangurug. ");
INSERT INTO gdg_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Wasin nabalinin inoy, ngangatanni Pabloweno umangnganna sey Jerusalem a mallakad sey Macedonia anna Acaya. E sinapiꞌna kappaya nu masindu sinay, umangngaggappay sey Roma. ");
INSERT INTO gdg_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Nepauntaneno adwera a kaduffunanna a da Timoteo anni Erasto sey Macedonia, e nabattang sey Efeso a lubbunna Asia. ");
INSERT INTO gdg_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Sinoya tiyempoweno nangiyafuwanino dokalla gulu sey Efeso gafu sino nanguruwanino tolayira ki Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ino nakwa, agyanino lalakiya i Demetrio a nalainga mamimpil si sinan bulawan. Oddu kappayino makilabbuwera sikwana a mangwa si sinan baleneno diosda a i Artemis, e odduweno ganansiyara gafu sinaya tarabafura. ");
INSERT INTO gdg_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Inamamungngeno makilabbuwera sikwana andino korwanira a gumapimpil si sinan bulawan, e sinapiꞌna sikwara si, “Ikkayuwa bafulungku, inammuyuwa ino tarabafutam, antuweno paggabwatanino kinabaꞌnantam. ");
INSERT INTO gdg_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Initayu i Pablo, e diningngaddawino sapitanna sino tolayira. Kunnangkelang si bakkanna diosino akwanna tolay. Odduwennino tolayira sito Efeso a nangurug sino sinapiꞌna, udde bakkampelang sitaw, nu ammena lud sino palulubbunna Asia. ");
INSERT INTO gdg_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Nu purayantam, ammena mabayag e kababannadda yo tarabafutam. Udde bakkampelang inay, massiki ino temploneno diostama i Artemis, kababannaddana kappay. Massiki i Artemis a dayawan ammina tolay, bakkampelang sito Asia, nu ammena lud si palulubbun, maarineno dayona.” ");
INSERT INTO gdg_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Wasin diningngaddeno sinapiti Demetrio, nabbungubungutira e nekulakulawura si, “Madandayawi Artemis a diostam sito Efeso!” ");
INSERT INTO gdg_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Odduweno naddingngag sino sinapiti Demetrio makkiyad si nakungkulira ammina talubbun. Dinoꞌmandara Gayo anni Aristarco a bulunira i Pablo a taga-Macedonia. Binuꞌbuꞌdera, e nalayawira ammina niyang sikwara sino pakkakarampattanda. ");
INSERT INTO gdg_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","I Pablo, anggamma a umang sinaya makitatabbag sino tolayira, udde inallangnganino manguruwira. ");
INSERT INTO gdg_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Massiki ino korwanira a tatturena probinsiya a manggam ki Pablo, nanundunira si umang massapit ki Pablo ta ammena nad mappadda sino pakkakarampattanda. ");
INSERT INTO gdg_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ino nakkakarampattira a tolay, aggekanakanawakawira pelang, e naddadarumeno ikulawura, se ino kaodduwan sikwara, ammera inammu nu sanneno gafuna a anera sinay. ");
INSERT INTO gdg_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Ino Judyuwera, nepataꞌdaddeno tata bulunda a i Alejandro sino naraꞌlanganino tolayira takesi itulduna si bakkannino Judyuwereno naggafuwanino gulu. Wasin nattaꞌdag, sinengyattannera ta suminakkira ta dingngaggandeno sapitanna. ");
INSERT INTO gdg_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Udde wasin naimunuwanda si Judyu i Alejandro, nittatera a nikakkulawu si adwa oratta sapitanda si, “Madandayawi Artemis a diostam sito Efeso!” ");
INSERT INTO gdg_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Wasin ginamwangino mayor, nepasinaꞌngera kappelang, kasena sinapit si, “Bulungkuwa Efeso, awana tolay sito lubagga amme nangammu si ikkanetamino mimut sino templowi Artemis a medandayaw andino batuwa kakunnana a naddaꞌna naggabwat sey langit. ");
INSERT INTO gdg_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Awana tolaya dama a massapit si siri inay. Kunna mantu, suminakketam ta ammena dumaggattino gulu sitaw. ");
INSERT INTO gdg_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Neiyandawino adwera lalaki sitaw, gampade awana liwaꞌda se awana sinakora sino templotam anna awana sinapiꞌda si narakkat mappeafu ki Artemis. ");
INSERT INTO gdg_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Nu wara angganda Demetrio annino bulunnera a idarum, anennino ukumira andino tatturayira sino ofisinara. Antuweno umangnganda nadda pidaruman. ");
INSERT INTO gdg_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Nu wara kappay pakaburungandaw, itarondaw sino awneno pakkakarampattantam takesi pattatarabbantam. ");
INSERT INTO gdg_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Maddararanak, se nu idarundetam sino turetamira sey Roma gafu sino gulu sitaw, sanneno sapitantam, a awana fustu si gafuneno inangwatam.” ");
INSERT INTO gdg_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Wasin nasinduwennino sinapiꞌna, nepaanonanino tolayira. ");
INSERT INTO gdg_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Wasin inibbattinnino akkakungkulino tolayira, nepakkakarampatti Pabloweno manguruwira e sinulduwannera takesi mattuyaggino angngurudda, kasena inanawanira e inang sey probinsiya a Macedonia. ");
INSERT INTO gdg_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Dinorawanneno manguruwira sino lulubbun sinay, e sinulduwannera takesi mattuyaggino angngurudda, kasena inang sey Acaya a mingngangkappay si Grecia. ");
INSERT INTO gdg_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Tallu dakkangnga sinay, kasena dinandamma mattakay si bafora umang sey Siria. Udde wasin gumikkaꞌnad, naammuwanna a nattatarabbanino Judyuwera si papatayanda. Antuweno nallipatanna e nallakara inang sey Macedonia. ");
INSERT INTO gdg_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","Ino bulunira i Pablo, i Sopatro a taga-Berea a abbingi Pirro, da Aristarco anni Segundo a taga-Tesalonica, i Gayo a taga-Derbe, da Tikico anni Trofimo a taga-Asia, anni Timoteo. ");
INSERT INTO gdg_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Nauntera e sinaronandakami sey Troas. ");
INSERT INTO gdg_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Se nagyangkami sey Filipos makkiyad si nasinduwennino fiyestana Tinapaya Awana Lebadurana. Wasin nasinduwen, lima aw kamiya nattakay si bafora inang sey Troas. Dinambalmiyeno bulummiyera sinay, e nagyangkami ammin sinay si talingguwan. ");
INSERT INTO gdg_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Wasin fuwamma Sabadu, nakkakarampakkamiya mangurug takesi kanammiyeno tinapaya panandammi sino natayani Jesus, kasena nanulduwi Pablo kiyad si tangngana gafi, se sinapiꞌna a manaw si kagigiꞌbaꞌna. ");
INSERT INTO gdg_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Odduweno sirwat sino kwartuwa nakkakarampattammi sey kalekay. ");
INSERT INTO gdg_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Nagyanino tata a buwanaka mingngan si Eutico a aggatuttud sino sawang. Wasino aggesapasapiti Pablo, nauyappani Eutico e naturug e nadaꞌnag sino taggadda naggabwat sino mekatalluwattuneno balay. Wasin inanda inita, natayin. ");
INSERT INTO gdg_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Udde inulluwi Pablo, inawakanneno natay, e kunna si, “Ammekayu maddararan, se nabiyag.” ");
INSERT INTO gdg_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Sinallungkami kappay sino balay e nangngangkami. Wasin nasindukamiya nangngan, netuluyi Pablo a makitatabbag sikwami kiyad si marrifarifad, kasekami inanaw. ");
INSERT INTO gdg_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Ino buwanak, neanora sey balera, e maanggammirangke se natolay. ");
INSERT INTO gdg_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Waso kunnenoy, sinapiti Pablo si mauntakamiya korwana mattakay si bafora umang sey Asson, se antu, mallakagganu kiyad sey Asson e kasena makitakay sikwami. ");
INSERT INTO gdg_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Wasin naddadarambalkami sey Asson, nattakekami ammin si bafor, e inangkami sey Mitilene. ");
INSERT INTO gdg_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Waso kadaramaꞌna, nanokami sinay e inangkami sey dammangnga Chio. E so mekadwa aw, nassippalkami sey Samos, e so mekatallu aw, ginamwangkamin sey Mileto. ");
INSERT INTO gdg_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Sinapiti Pablo si ammekami massippal sey Efeso takesi ammekami matalantan sey probinsiya a Asia, se makkangkama umang sey Jerusalem. Nu damana, gumamwangkami nad sinay liyeneno fiyestana Pentecostes. ");
INSERT INTO gdg_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Wasin nagyangkami sey Mileto, nepaayi Pabloweno pangafuwanirana manguruwira sey Efeso. ");
INSERT INTO gdg_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Wasin ginamwangira, sinapiꞌna sikwara si, “Kakkolak, ammuyunnino akkakokwak sin nagyanangku sitaw mangiyafu sin pitta a inangngangku sito probinsiya a Asia. ");
INSERT INTO gdg_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Inangwak amminino netalakki Dios sikwaka akwan, e tagatulutulukappelanga kunnangke aripanna. Massiki nattangitak sino loloneno nakangku gafu se nadyatanak sino inangweno kasiJudyukira a ngangatandaka papatayan, ammek nelammatta akwanino anggammi Dios. ");
INSERT INTO gdg_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Ammuyu kappay si awana neimaggu si sapita makaduffun sikwayu sino panulduwangku sikwayu sin nammamitingantam, massiki sino bafaleyu. ");
INSERT INTO gdg_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Ginakkurugguweno nanuldu sino Judyuwera andino bakkannira a Judyu ta ibobolira naddino liwaꞌda e umaꞌlangira ki Dios anna manguruwira ki Jesu Kristo a Afutam. ");
INSERT INTO gdg_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Sitoya, umangngak sey Jerusalem, se antuweno sinapitino Espirituwi Dios sikwak, udde ammek inammu nu sannaneno makwa sikwak sinay. ");
INSERT INTO gdg_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Aggaammungku pelang si mabaluraꞌnga e madyatanak, se antuweno nepakaammuweno Espirituwi Dios sikwak sino ammina lulubbuna inangngangku. ");
INSERT INTO gdg_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Udde massiki nu matayak, ammek ikalow yo angakku, se anggangkuwa balinannino nepakwa i Afu Jesus sikwaka manuldu sino nalawara damag mappeafu sino allakki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Ikkayuwa sinulduwangku mappeafu sino patturayani Dios, ammuk si ammerakunna maita. ");
INSERT INTO gdg_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Antu gafuna, sapitangku sikwayu sitoya, nu wara sikwayuwa ammena mesalakan, bakkanna liwakku pay yan. ");
INSERT INTO gdg_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Se awana ammek netuldu sikwayu sino ammina anggammi Dios a maammuwandaw. ");
INSERT INTO gdg_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Antu gafuna, imutandonaddino angnguruddaw, mampesino angnguruwino bafulundawira a mangurug, se ikkayuweno piniliyeno Espirituwi Dios a mimut sikwara. Lawarandawira a imutan, se ireno tolayi Dios a sinubbuꞌna sino adeno Abbingnga sin natayanna. ");
INSERT INTO gdg_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Se ammuk si nanu manawakun, aneraneno gumamwanga manuldu si bakabakkan. Meampariyera si sumarona atuwa mamapatay si karnero, se angganda a darallannino angnguruwino tolayira a imutandaw. ");
INSERT INTO gdg_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","E bakkampenalang yan, anennino bulundawira a nangurug, iraneno manuldu si siri, tantaro nu wara gammiranda sikwayu. ");
INSERT INTO gdg_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Kunnantu, kakkolak, mappalangkayu. Ammeyu kalyawana sinutulduwantakayu si unangnga tallurun, massiki aw anna gafi, e natattangitak gafu sino allakku sikwayu. ");
INSERT INTO gdg_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Sitoya, italattakayu ki Dios ta antuweno mimut sikwayu, se sinapiꞌna si allakkandetam. Damana a pattuyaggannino angnguruddaw gafu sino sapiꞌna, e iyaꞌdanana amminino nalawara nekarina sino ammina tolenera. ");
INSERT INTO gdg_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","“Ammek nilyaw si piraꞌdaw onnu barawasiyu, massiki inya sikwayu. ");
INSERT INTO gdg_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","Ammuyu si ino nallingattangkungkepayino naggabwatanino ammina maawaggu andino maawino bulungkuwera. ");
INSERT INTO gdg_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kunnenoyino kanayuna inangwak takesi antuweno tuntulandaw, se maawag si mallappattetam, takesi wara iduffuntam sino mawira si duffun. Dandammantammaddino sinapiti Afu Jesus a kunna si, ‘Maanggammino mangaꞌda amma sino maaꞌdan.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Wasin nasinduwennino sinapiti Pablo, namaliturira ammina nakkararag. ");
INSERT INTO gdg_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Inawakanda i Pablo, e nattatarangitira a mappagikkat sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Malowingke nakanda se sinapiꞌna si ammeran maita. Wasinoy, netuludda sino agyananino bafor. ");
INSERT INTO gdg_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Wasin inanawammiyeno Efesowera sey Mileto, nattakekami si bafor e naddammangkamiya inang sey Coos. Wasin metufara aw, ginamwangkami sey Rodas, kasekami kappay inang sey Patara. ");
INSERT INTO gdg_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Wasin ginamwangkami sey Patara, nagyanino bafora umang sey Fenicia, e antuweno nattakayammi. ");
INSERT INTO gdg_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Waso aggedadammangkami, nedipaꞌmiyeno Chipre sino padawi, e nangawwakkami sey Tiro a tata lubbunna probinsiya a Siria. Ginaꞌdangkami sinay se antuweno pidassanda sino kargeno bafor. ");
INSERT INTO gdg_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Dinaꞌngaminnino manguruwira sinay, e nagyangkami sikwara si talingguwan. Gafu se nepakaammuweno Espirituwi Dios sikwara si madyatanna i Pablo sey Jerusalem, nepipidwara a sinapit sikwana si ammena nad umang sinay. ");
INSERT INTO gdg_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Udde wasin nadatangnginnino anomi, ginikkakkami kappelud. E amminino manguruwira annino taabbalayanira, netuluddakami makkiyad sino dappiꞌna bebay. Namalituggami ammin, kasekami nakkararag. ");
INSERT INTO gdg_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","Nepatakerakami sino bafor, e nuliyeran sey balera. ");
INSERT INTO gdg_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Wasin ginamwangkamin sey Tolemaida a naggabwat sey Tiro, ginaꞌdangkami, e inammi initeno manguruwira sinay. ");
INSERT INTO gdg_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Waso kadaramaꞌna, nanokami, e inangkami kappay sey Cesarea. Wasin ginamwangkami sinay, nassippalkami sey balera Felipe a gumabanyag sino nalawara damag. Antuweno tata sino pituwera a napili siꞌina dumuduffun sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Aneno appatira a bafalatanga abbingnga a mangibabanyag sino sapiti Dios. ");
INSERT INTO gdg_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Wasin mattalingguwaninnino nagyanammi sinay, ginamwangino tata a gumalabbuni Dios a naggabwat sey Judea a i Agaboweno anganna. ");
INSERT INTO gdg_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Inappaneno sintaroni Pablo e ginakanneno kamaꞌna annino takkinangkepay, e nekunna si, “Antuyawino kunnino Espirituwi Dios, a ‘Kunna kappayino aggakaddino Judyuwera sey Jerusalem sino makwan sintaron, kasera iyalawat sino bakkannira a Judyu.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Anningngammi lang sinoy, nappekakallakkami andino korwanira sinay ki Pablo si ammena umang sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Udde sinabbi Pablo si, “Ammekayu mattangit, se pallowandopelang yo nakangku. Massiki nu magakaddak sey Jerusalem, onnu matayak mappeafu ki Afu Jesus, ammek ammayan.” ");
INSERT INTO gdg_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Wasin ammekami makafuwad sikwana, inibbattammimpelang, e sinapiꞌmi si, “Ino panggammani Dios, antuweno makwa nad.” ");
INSERT INTO gdg_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Wasin nadaꞌngennino gikkatammi, naddadangkami e inangkami sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Nebulun sikwamiyeno korwanira a manguruwa taga-Cesarea. Netuluddakami sey balera Mnason a antuneno pagyanammi. I Mnason, taga-Chipre a tata paya nabayinna mangurug. ");
INSERT INTO gdg_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Wasin ginamwangkami sey Jerusalem, maanggammingke ino manguruwira a dinambal sikwami. ");
INSERT INTO gdg_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Waso kadaramaꞌna, inangkami anni Pablo a naddoraw ki Santiago. Nagyangkappay amminino pangafuwanirana manguruwira sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Nepakimustera i Pablo, kasena sinapit amminino inangwa i Dios sino bakkannira a Judyu gafu sino nanulduwanna. ");
INSERT INTO gdg_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Waso diningngaddeno amminino sinapiꞌna, naddayawira ammin ki Dios. Udde sinapiꞌda ki Pablo si, “Kolak, dandammannu nad si rinifurifuweno Judyuwera a mangurug ki Jesus, e nattalaginarira ammina manuntul sino lintiyi Moises. ");
INSERT INTO gdg_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Nadingngadda si manulduka sino Judyuwera a magyan sino lulubbunino bakkannira a Judyu ta talekkurandeno lintiyi Moises. Sinapiꞌnu kanu si ammera nad pakugitino aanaꞌdera anna ammera nad tuntulannino gagangetama Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Maammuwanda a maammuwanino gamwangannu sitaw. Sanna mantuweno akwantam ta maammuwanda si tuntulannu kepayino gagangetam? ");
INSERT INTO gdg_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Kunnayawino anggammiya akwannu. Aneno appatira a lallaki sitawa gababalininnino nesapatara ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Bulunannuwera a umang sino Templo ta mesapakka sino akwanda a mappabaggaw sino baggira, kasem paganino partinda takesi damara a mappausip sino padiyera a pimunuwan si nabalininnino sinapatanda. Nu kunnenoyino akwannu, maammuwan amminino tolayira si ammena gakkuruwino diningngadda mappeafu sikwam, se aggitanda si nattalaginagga a manuntul sino lintiyi Moises. ");
INSERT INTO gdg_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Udde mappeafu sino bakkannira a Judyu a mangurug, antu pelang yawino neturaꞌmi sikwara a tuntulanda nad. Ammera nad kanannino newaꞌlat sino sinandiosira onnu ino ada onnu ino lamana ammena naariyeno adana. E ammera nad makidurug si bakkanna atawara.” ");
INSERT INTO gdg_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Antuweno si kadaramaꞌna, nebuluni Pablo sino appatira a lallaki, e nesapat sikwara sino inangwara a mappabaggaw sino baggira, kasera inang sino Templo. Netulduwi Pablo sino padiyeno kabalinanneno nesapatara, takesi antuneno pamartiyanda anna pappausipanda. ");
INSERT INTO gdg_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Wasin mappitu awin, nagyanino korwanira a Judyu a naggabwat sey Asia a nakaita ki Pablo sino Templo, e sinussuwandeno tolayira ta doꞌmanda i Pablo, ");
INSERT INTO gdg_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","e nekokwara a nassapit si, “Ikkayu bufulummiya gakagaka i Israel, umangkayu taw ta duffunandakami. Se iyawa tolayino manuldu si ammina tolay si palulubbun si narakkattetama Judyu, anna narakkakkappayino lintiyi Moises anyo Templotam. Sitoya, nedaggaꞌna a dinakkutan yo Templotam, se nepatallungngeno bakkanna Judyu.” ");
INSERT INTO gdg_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","(Sinapiꞌdenay, se naitara a nebuluni Pablo sino taga-Efeso a i Trofimo, e aridda si nepatallungnga sino Templo.) ");
INSERT INTO gdg_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Ammena mabayag e nakungkul amminino tolayira sey Jerusalem. Nalayawira a inang sino Templo, e dinoꞌmanda i Pablo. Binuꞌbuꞌda a nelawan sino Templo. E neakuꞌdanino Templo. ");
INSERT INTO gdg_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Papatayandan naddi Pablo, udde aneno nangipakaammu sino komanderna sindaluwera a taga-Roma a maguluweno tolayira. ");
INSERT INTO gdg_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Nalana nayino komander si sindalunera annino kapitanda e nalayawira a inang sino katolayan. Waso initeno tolayireno sindaluwera, nibbattandeno manusultuk ki Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Dinoꞌmanino komanderi Pablo e nepagakanneno kamaꞌna si adwa a kawad, kasena nebebut sino tolayira si, “Inya yawa tolay? Sanneno inangwana?” ");
INSERT INTO gdg_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Naddadarumeno ikulawura, e ganawawira, antuweno amme maalimutaranino komanderino kakuruwanna. Gafu sinoy, sinapiꞌna sino sindalunera si iyanda sino kampora. ");
INSERT INTO gdg_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Wasin aneran sino addan, inaꞌlidda i Pablo se ilalassetino tolayira gafu sino bunguꞌda. ");
INSERT INTO gdg_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Dumadandanira a mikakkulawu si, “Papatayantam!” ");
INSERT INTO gdg_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Wasin itallundan naddi Pablo sino kampora, sinapiti Pablo sino komander si, “Ayaw abbu yo sapitangku sikwam.” Sinabbino komander si, “Inammum ikka a maddamit si Griego? ");
INSERT INTO gdg_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Ariggu si ikkeno taga-Egipto a nakiyubat sino gubiyernu siꞌin, a inang sey kalolowata nifuyut sino appatarifuwera a lallakiya gumapapatay si tolay.” ");
INSERT INTO gdg_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","“Bakkannak,” kunni Pablo, “se Judyuwak e neyanakak sey Tarso a lubbunna probinsiya a Cilicia, e awana ammena nangammu sino lubbungku. Ammena kad dama ta aneno sapitangku sino tolayira?” ");
INSERT INTO gdg_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","“Damana,” kunnino komander. Nattaꞌdaggi Pablo sino addan, e sinengyattanneno tolayira ta suminakkira. Wasin sininakkiran, naddamit sino aꞌlanda si Hebreo a damiꞌna Judyu, e nekunna si, ");
INSERT INTO gdg_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ikkayuwa aꞌama anna kakkolakku, dingngaggandaw yo sapitangku ta itandaw nu wara narakkat si inangwak.” ");
INSERT INTO gdg_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Wasin diningngadda si Hebreoweno damiꞌna, nansasinakkira. E netupakki Pablo a nassapit si, ");
INSERT INTO gdg_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ikkanak, tatappaya Judyu a neyanak sey Tarso a lubbunna Cilicia, udde sito Jerusalemino nadalangku. I Gamalielino nanuldu sikwak, e inillalappattanna a nituldu sikwak sino lintiyino gagginafutamira. Nattalaginarappaya masserbi ki Dios a kakunnayu. ");
INSERT INTO gdg_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Antu gafuna, pinadyatangkuweno manguruwira ki Jesus, kiyad si nepapapatekino korwanira. Massiki bafabbayira onnu lallaki, dinoꞌmangku e nepabalugguwera. ");
INSERT INTO gdg_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Dameno afafuna padi andino pangafuwantamira a taꞌdaggan si gakkurug yo sapitangku, se ireno nangaꞌda sikwak si turak ta iyangku sino kasiJudyutamira sey Damasco, takesi damaka manoꞌma sino manguruwira ki Jesus sinay. Inangngak sinay ta appangkuwera e iyangkuwera sito Jerusalem a aggakawad, takesi makastiguwera.” ");
INSERT INTO gdg_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","Sinubburani Pabloweno sinapiꞌna si, “Wasin agyanak sey dalan si tangnganawa makkatam sey Damasco, kakaꞌmeng kelang nalebaddanak si mangngilikilita baggawa naggabwat sey langit. ");
INSERT INTO gdg_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Naletwarak e diningngagguweno damita nekunna sikwak si, ‘Saulo, Saulo, mayan padyatandak?’ ");
INSERT INTO gdg_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","‘Inyaka, Afu?’ kungku. ‘Ikkanaki Jesus a taga-Nazaret a padyatannu,’ kunna. ");
INSERT INTO gdg_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Ino bulungkuwera, initareno baggawa mangngilikilit, udde ammera naawatanino sinapitino naddamit sikwak. ");
INSERT INTO gdg_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Sinapikku kappay sikwana si, ‘Sanneno anggammuwa akwangku, Afu?’ E nesombaꞌna sikwak si, ‘Mattaꞌdagga ta umangka sey Damasco, e ananeno mituldu sikwam sino ammina dinandammi Dios a akwannu.’ ");
INSERT INTO gdg_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Nalappattak sino nangitangku sino mangngilikilita baggaw, e kinewiddakino bulungkuwera a neyang sey Damasco. ");
INSERT INTO gdg_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Nagyanino tata lalaki sinaya mingngan si Ananias a nattalaginara manuntul si ammina lintiddam, e dayawan amminino kasiJudyutamira sey Damasco. ");
INSERT INTO gdg_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Inang sikwak e nattaꞌdag sino aruruggu, e sinapiꞌna si, ‘Kolaka Saulo, makaitakammanin!’ Assapiꞌlangi Ananias sinoy, nabbaggawino angngitak, e initaki Ananias. ");
INSERT INTO gdg_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","E sinapiꞌna sikwak si, ‘Ino Dios a dinayawino gagginafutamira, piniliraka takesi ammunnuweno anggamma anna itannuweno nadiosana Abbingnga a masserbi sikwana anna dingngaggannu kappayino damiꞌna. ");
INSERT INTO gdg_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","Se ikkaneno mangipakaammu si ammina tolay sino nadingngangngu anna naitam. ");
INSERT INTO gdg_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Ma, annamata taronannu? Gumabwakka ta umangka mappabawtisar, e marangka si duffun ki Jesus takesi mapakomanino liwaꞌnu.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","Wasinoy, sinapikkappayi Pablo si, “Wasin nuliyak sey Jerusalem, inangngak nakkararag sino Templo, e agyanino nepaita i Dios sikwak si kunnangke tenap. ");
INSERT INTO gdg_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","Nappadda i Afu Jesus sikwak, e sinapiꞌna si, ‘Kangkamannu! Manokan sito Jerusalem, se ino tolayira sitaw, ammerana kuruwannino sapitannu mappeafu sikwak.’ ");
INSERT INTO gdg_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Udde sinabbaggu si, ‘Afu, tantaro nu kuruwandaꞌnga, se inammura si ikkanakino sinallung sino sinagogarera, e dinoꞌmangkuweno manguruwira sikwam, e nepabaluggu anna nepasiwaꞌwakkuwera. ");
INSERT INTO gdg_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","E ammura kappay si inanggangkuweno inangwara a namapatay ki Esteban a tistigum, se agyanak sinaya nimut sino barawasiyeno namapatayira sikwana.’ ");
INSERT INTO gdg_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Udde sinombati Jesus sikwak si, ‘Manoka lud, se dundunantaka si aroyu ta angka tulduwanino bakkannira a Judyu.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ino tolayira a nakkakarampat sinay, naddingngaggira ki Pablo makkiyad si sinapiꞌneno mappeafu sino bakkannira a Judyu. Udde wasin diningngadda, nekulawura a nassapit si, “Papatayantam! Ammena mepangngat si mabiyag yana tolay!” ");
INSERT INTO gdg_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Nakakulakulawuwera e newayawayawaddeno barawasirera anna niburayitira si lafuk sey kalekay gafu sino bunguꞌda. ");
INSERT INTO gdg_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Nepetallungino komander sino sindalunera i Pablo sino kampora, e sinapiꞌna si siwaꞌwattanda nad takesi ipunnuneno gafuneno nabbungubungutanino Judyuwera sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Udde wasin nerappaꞌda i Pablo e siwaꞌwattanda nad, nassapiti Pablo sino kapitanna sindaluwa aggataꞌdag sinay si, “Wara kalintiyandawa mabbeꞌbek si tolaya Roma a ammena kepay naimbistigar?” ");
INSERT INTO gdg_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Wasin diningngaggino kapitanino sinapiti Pablo, inang sino komander, e sinapiꞌna si, “Dandammannu naddino akwannu sinaya tolay, se tolaya Roma kanu.” ");
INSERT INTO gdg_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Inangngino komander ki Pablo e nebebuꞌna si, “Sapitannu sikwak nu gakkuruwa toleka a Roma.” “On,” kunni Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","E nekunnino komander si, “Odduweno nagastuk kasek nebilang si tolaya Roma.” “Udde ikkanak, gagangayaka Roma se neyanakaka tolaya Roma,” kunni Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wasinoy, ino sindaluwera a massiwaꞌwaꞌnad ki Pablo, nappaꞌniyera. Massiki ino komander, nakatalopay se nepagakanneno tata tolaya Roma. ");
INSERT INTO gdg_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Waso kunnenoy, anggangkepayino komandera maammuwanino kakuruwanino nidarumanino Judyuwera ki Pablo. Antu gafuna, waso metufara aw, nepakakarampaꞌneno pangafuwanirana padi andino korwanira a afafuna Judyu. Wasin nakkakarampattiran, nepaarineno kawari Pablo e nepeyangnga sino naraꞌlanganda. ");
INSERT INTO gdg_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Sinulangngani Pabloweno pangafuwanira, kasena nekun si, “Kakkolakku, kiyarino nabiyayangku, amminino inangwak, dinandangkuwa nalawad sino aꞌlangi Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Wasinoy, i Ananias a afafuna padi, sinapiꞌna sino tolayira a araꞌni ki Pablo ta tappapandeno wangiꞌna. ");
INSERT INTO gdg_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","E sinapiti Pablo sikwana, “Ikka a sinan ukum, tappapandaka pena i Dios. Se aggatuttugga sitana mangukum sikwak mappeafu sino lintiddam, gampade kinontaramino lintig se sinapiꞌnu si matappapak.” ");
INSERT INTO gdg_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Sinapitino tolayira a araꞌni ki Pablo si, “Iyatatalnuweno afafuna padiyi Dios.” ");
INSERT INTO gdg_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","E nekunni Pablo si, “Kakkolak, ammek maꞌlud inammu si antuweno afafuna padi. Nu inammuꞌngad, ammeꞌngad sinapitino kunnenoy, se aneno neturak sino sapiti Dios a ‘Ammekayu massapit si narakkat mappeafu sino pangafuwanino lubbundaw.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Waso kunnenoy, gafu se inammuwi Pablo si Saduceoweno korwanira a pangafuwan anna Fariseoweno korwan, nekokwana a nassapit si, “Kakkolakku, Fariseowappay, e kunna kappayino gagginafukira. Antu gafuna a ayawak sitawa maimbistigar, gafu se innanamangku si mangngangoliyeno natayira.” ");
INSERT INTO gdg_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Assapiꞌlangi Pablo sinoy, masasarombatinnino Fariseowera andino Saduceowera, se nassasarulyatino nakanda. ");
INSERT INTO gdg_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","(Se ino Saduceowera, ammera kuruwan si mangngangoliyeno natayira, ammera kuruwan si wara anghel, anna ammera kappay kuruwan si wara kararuwana tolay. Udde ino Fariseowera, kuruwanda ammin yaw.) ");
INSERT INTO gdg_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Nekokwara lullangino nakkulawu. Ino korwanira a Fariseo a mammesturuna lintig, nattaꞌdaggira a nipatut sino ana sino nakanda, e sinapiꞌda si, “Awana dingngammi si narakkatta inangwana yan. Se nu wara naddamit sikwana si anghel onnu korwana ammena maita, awana rakkaꞌnenay.” ");
INSERT INTO gdg_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Waso kunnenoy, nedaggaꞌda lullanga massasarombat makkiyad si naddararanino komander tantaro nu pappipiꞌngetanda i Pablo. Antu gafuna, dinundunneno sindaluwera a miyanaw ki Pablo takesi iyanda sino kampora. ");
INSERT INTO gdg_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Sinoya gafi, nappadda i Afu Jesus ki Pablo e sinapiꞌna si, “Ammeka mattalaw, Pablo, se taꞌdaggannaꞌngad sey Roma, a kunna kappayino inangwam sito Jerusalem.” ");
INSERT INTO gdg_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","13","Waso kadaramaꞌna, agyanino nasuruk si appatafuluwera a Judyu a nattatarabba mamapatay ki Pablo. Nesapatara si ammera mangngan anna uminum kiyad si ammera mapapatayi Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","E inangngira sino pangafuwanirana padi andino korwanira a pangafuwanna Judyu, e sinapiꞌda si, “Gakkuruwingke a ammekami mangngan anna uminum kiyad si ammemi mapapatayi Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Kunna mantu, ikkayu andino korwanira a pangafuwan, manundungkayu si umang massapit sino komander ta peyangnga i Pablo sitaw takesi bistigarandaw si nalawad. Lakkappammina sey dalan ta papatayammi liyena gumamwang sitaw.” ");
INSERT INTO gdg_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Udde ino panganakanni Pablo, a abbingino kolaꞌnga a bafay, naammuwanneno nattatarabbanino Judyuwera, e inang sino kampoweno sindaluwera a nattattifug ki Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Inayani Pabloweno tata kapitan, e sinapiꞌna sikwana, “Itulunnu abbu yo buwanak sino komander se ana kanuweno itulduna sikwana.” ");
INSERT INTO gdg_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Netulurino kapitanino buwanak sino komander, e sinapiꞌna sikwana si, “Ino balura i Pablo, inayannak e nepeyangnga sikwak yaw buwanak sikwam, se ana kanuweno sapitanna.” ");
INSERT INTO gdg_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Wasinoy, kinewirino komanderino buwanak, e neyangnga sino bakkang, kasena binebut si, “Sanneno sapitannu sikwak?” ");
INSERT INTO gdg_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","E sinapitino buwanak si, “Agyanino Judyuwera a nattatarabba marang sikwam si peyangngu kanuna i Pablo sino pammamitinganda nu daramat. Ino rasonda, bistigaranda kanu si nalawad. ");
INSERT INTO gdg_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Udde ammemira nad kuruwan, se aneno nasuruk si appatafuluwera a mallakkap sikwana, a nesapatarangke si ammera mangngan anna uminum kiyad si ammera mapapatay. Naddadaniran, taronanda pelang si onannu.” ");
INSERT INTO gdg_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","E sinapitino komander si, “Ammem sapitan si korwan si wara sinapiꞌnu sikwak.” E nepaanoneno buwanak. ");
INSERT INTO gdg_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Wasin inanawinnino buwanak, inayanino komanderino adwera a kapitanna e nekunna si, “Itulduyu sino adwatutira a sindalu andino adwatutira a sissasayyang andino pitufuluwera a sikkakabayu ta maddadanirana a umang mitulud ki Pablo sey Cesarea. Gumikkakkayuna nu alas nuwebe nu gafi. ");
INSERT INTO gdg_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Idadanandopayi Pablo si kabayuwa pattakayanna. Itandopay takesi awana narakkat si makwa sikwana kiyad si iyamwandaw ki Gubernador Felix.” ");
INSERT INTO gdg_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Nanurak kappayino komander ki Gubernador Felix, e neturaꞌnga si, ");
INSERT INTO gdg_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Afu Gubernador Felix, ikkanaki Claudio Lisias a nanurak sikwam. ");
INSERT INTO gdg_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Manantokayu pay sitan? Iyana tolaya nepetuluggu sikwam, dinoꞌmanino Judyuwera e papatayanda nad. Udde wasin naammuwangku si tolaya Roma, inangkami andino sindalukira a nisalak sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Gafu se anggangkuwa maammuwan nu sanneno nidarumanda sikwana, neyangku sino pangafuwanira. ");
INSERT INTO gdg_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Udde wasin binistigarda, naammuwangku si awana liwaꞌna a pamapatayanda sikwana onnu kebaluranna, se mappeafu pelang sino lintidda a Judyuweno nidarumanda sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Wasin naammuwangku si nattatarabbaninnino Judyuwera a papatayan, kinangkamangkuwa nepeyang sikwam. Netulduk sino naddarumira sikwana si ikkeno pidarumanda. Antuwen inoy.” ");
INSERT INTO gdg_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Wasin gafenin, kinuruwino sindaluwereno sinapitino komander, e inappara i Pablo e neyanda sey Antipatrisa. ");
INSERT INTO gdg_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Wasi kadaramaꞌna, nuliyennino nallakarira a sindaluwera sino kampora sey Jerusalem, e ino nakkabayuweranino nitulud ki Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Wasin ginamwangiran sey Cesarea, neyaꞌdareno turak sino gubernador, e nealawaꞌda i Pablo sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Binaseno gubernadorino turak, kasena nabbebut ki Pablo nu sanneno probinsiya a neyanakanna. E sinapiti Pablo si taga-Cilicia. ");
INSERT INTO gdg_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","E kunnino gubernador sikwana, “Kasetakana mantu bistigaran nu gumamwangino nidarumira sikwam.” E sinapiꞌna si magwardiyani Pablo sino balaya nepaangwa i Ari Herodes. ");
INSERT INTO gdg_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Wasin nallaꞌwutino lima aw, inangngira sey Cesarea ino afafuna padiya i Ananias andino korwanira a pangafuwanna Judyu. Agyanino tata a abugaduwa mingngan si Tertulo a nebulun sikwara. Inangngira ammin ki Gubernador Felix a midarum ki Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Wasin nepaayadda i Pablo, sinapiti Tertulo ino pamaliwaꞌda sikwana. Sinapiꞌna si, “Afu Gubernador, gafu so kinalaingnguwa matturay sikwami, nabayinna nassiyanakkami, se odduwa inangwama pallawarammiya talubbun. ");
INSERT INTO gdg_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Maanggangkamingke ammin gafu sino nalawara inangwam, e kanayungkamiya mappasalamat sikwam. ");
INSERT INTO gdg_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Ammemi anggam si matalantangka, udde dingngaggannu abbu si bisangngino sapitammi. ");
INSERT INTO gdg_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","“Iyawa tolay, antu pelangino mangaꞌda si narakkat, se kinungkulneno Judyuwera si palulubbun. Antu kappayino tata a afafuweno sumuntulira sino tulduweno tolaya taga-Nazaret. ");
INSERT INTO gdg_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Dakkutanna naggappayino Templomi sey Jerusalem, udde dinoꞌmammi, se anggammiya tuntulannino lintimmiya mimbistigar sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Udde ginamwangi Komander Lisias e nelasseꞌna i Pablo sikwami. ");
INSERT INTO gdg_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","E sinapiꞌna si umangkami sitaw ta idarummi sikwam. Nu bistigarannu yawa tolay, maammuwannu pena si gakkuruwino sapitammi sikwam.” ");
INSERT INTO gdg_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Ino bulunnera kappaya Judyu, sinaꞌdagganda si gakkurug amminino sinapiꞌna a nappaliwat ki Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Wasin nabaliniran, sinengyattanino gubernadori Pablo ta mepataliya maddamit, e nekunni Pablo si, “Afu Gubernador, ammuk si nabayaggana matturay anna mangukum sikwamiya Judyu. Antu gafuna a maanggammaka manombat sino nidarumanda sikwak sikwam. ");
INSERT INTO gdg_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Naladda a maammuwannu sino tolayira nu gakkuruwino sapitangku se awangkepay kadwafulu si adwa a awa nallaꞌwut kiyad sin inangngangku sey Jerusalem a maddayaw ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","E awaningke a nita sikwaka makisosombat sino Templo, onnu mappagagarunut sino tolayira sino sinagogera onnu massiki sino korwanira a nagyanangku sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Bakkanna gakkuruwino nidarumanda sikwak se awana pamakurudda. ");
INSERT INTO gdg_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Udde gakkuruwino tata a sinapiꞌda, a tuntulangkuweno annuldu mappeafu ki Jesus a kunda si tanganan anna bakkanna gakkurug. Gampade antuweno addayok sino Dios a dinayokappayino gagginafumiyera siꞌin. E kuruwangku kappay amminino lintiyi Moises anna amminino neturakkino gumalabbunira i Dios siꞌin. ");
INSERT INTO gdg_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Innanamangku si pangngangolinna i Dios amminino natayira, massiki ino narakkattira andino nalawarira, a kunna kappayino kuruwanda. ");
INSERT INTO gdg_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","E gafu se antuweno innanamangku, gakkuruwangkungke a mangwa si nalawad, takesi awana palliwatangku ki Dios anda sino tolayira. ");
INSERT INTO gdg_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Wasin pipidya runa ammek inang sey Jerusalem, inangngak sinaya nangaꞌda si piraka duffummi sino bulummiyera a mawag si duffun, anna ana kappayino iyaꞌdak ki Dios. ");
INSERT INTO gdg_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","E antuwennino aꞌakwangku sino Templo sin dinaꞌngarakino Judyuwera a taga-Asia. Nabalingkunnino gagangemiya mamaggaw. Awana oddu si tolay sinay e awana nakkanawakaw. ");
INSERT INTO gdg_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Udde ira a taga-Asia, ira naddino umang sitawa mangidarum sikwak nu gakkuruwa wara ipaliwaꞌda sikwak. ");
INSERT INTO gdg_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Udde nu awan, massiki ino tolayira sitaw, sapitanda nad nu wara inammuwanda si liwakku sin inaꞌlangak sikwara sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","Ino pelang sinapikku sino naraꞌlanganda, nekokwaka nassapit si, ‘Ayawak sitawa maimbistigar, gafu se innanamangku si mangngangolineno natayira.’ ” ");
INSERT INTO gdg_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Wasinoy, gafu se odduweno inammuwi Gubernador Felix mappeafu sino tulduwi Jesus, nepaibbaꞌneno pimbistigaranda ki Pablo, e nekunna si, “Ammeyu abbu, ta gumamwangi Komander Lisias, kasetaka usiyan.” ");
INSERT INTO gdg_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","E sinapiꞌna sino kapitanna sindalu ta pagwardiyara i Pablo, udde wayawayanda si bisang, e ammera iyallangngino umangnganino bulunnera a manuffun sikwana nu wara maawangnga. ");
INSERT INTO gdg_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Wasin nallaꞌwutino pipidya aw, nuliyi Gubernador Felix annino atawana a Judyu a i Drusila. Nepaayangnga i Pablo takesi dingngagganda payino sapitanna mappeafu si angngurug ki Kristo Jesus. ");
INSERT INTO gdg_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Udde wasin nanulduwani Pablo sikwana mappeafu sino nalawara aggangwa, ino paffuwaddan naddino tolayira sino baggira, andino gumamwanganneno awa pangukumani Dios si tolay, nakatalawi Felix e sinapiꞌna si, “Kunden abbu. Ayantakammanna nu tata si aw.” ");
INSERT INTO gdg_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Dayandananni Felix a paayi Pablo ta tatabbanna, udde ino ana sino nakamma, anggamma si pasussukan naddi Pablo si pirak. ");
INSERT INTO gdg_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Waso nallaꞌwutino adwarun, nepataliyi Porcio Festo ki Felix a naggubernador. Udde wasin inanawinni Felix, ammena nepalawani Pablo sey abbaluran, takesi aanggammannino Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Waso kunnenoy, ginamwangi Festo sey Cesarea a maggubernador sinaya probinsiya. Wasin pakaꞌlunan, naggikkata inang sey Jerusalem. ");
INSERT INTO gdg_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","E wasin ginamwang sinay, ino pangafuwanirana papadi andino afafuweno Judyuwera, inangngira sikwana a nidarum ki Pablo. E nappekakallakkira ki Festo ");
INSERT INTO gdg_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","si peyangnga i Pablo sey Jerusalem, se gakkadda a lakkappan sey dalan ta papatayanda. ");
INSERT INTO gdg_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Udde sinabbi Festo si, “Aggabaluri Pablo sey Cesarea, e malanaka muli sinay. ");
INSERT INTO gdg_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Massiki mabbafulungkami andino korwanira a tattureyu ta idarunda sinay nu wara liwaꞌna.” ");
INSERT INTO gdg_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Nagyani Festo sey Jerusalem si walu onnu tafulu aw, kasena nuli sey Cesarea. Wasin kadaramaꞌna, inang sino kwartuwa attatarabbanda si asonto, e nepaayangnga i Pablo sinay. ");
INSERT INTO gdg_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Wasin ginamwanginni Pablo, ilebaddino Judyuwera a naggabwat sey Jerusalem, e nadammattingke ino nepaliwaꞌda sikwana. Udde awana pamakurudda sino ipaliwaꞌda sikwana. ");
INSERT INTO gdg_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Sinaꞌdagganingkepayi Pabloweno baggina, e nekunna si, “Awaningke a nalliwatangku sino lintimmiya Judyu onnu sino Templomi. Awangkappay nalliwatangku sino lintiyino Emperador sey Roma.” ");
INSERT INTO gdg_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Udde gafu se anggammi Festo a aanggammannino Judyuwera, sinapiꞌna ki Pablo si, “Anggammuwa umang sey Jerusalem ta sinayino pangusiyangku sino nidarumanda sikwam?” ");
INSERT INTO gdg_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Udde sinabbi Pablo si, “Ammek anggam, se ayawakun sitaw, e sitawino pangukumannu nad sikwak, se ikkeno piniliyeno Emperador a mangukum. Aggaammunnu kena si awana liwakku sino Judyuwera. ");
INSERT INTO gdg_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Nu wara nalliwatangku si pamapatayanda sikwak, ammek mappekakallak si meliꞌwak. Udde nu awana kakuruwanneno nidarumanda sikwak, awana kalintiyanino massiki inya a tolaya mangiyalawat sikwak sikwara. Arangngangku si umaꞌlangak sino Emperador sey Roma ta antuweno musig sikwak.” ");
INSERT INTO gdg_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Waso kunnenoy, sinatabbi Festoweno tatturayira a nanuffun sikwana, kasena sinapit ki Pablo si, “Inarangnguwa umaꞌlang sino Emperador sey Roma, e peyantakan sikwana.” ");
INSERT INTO gdg_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Ammena nabayag, ino ariyeno Judyu a i Agripa annino kolaꞌnga a bafaya i Bernice, ginamwangira sey Cesarea se angganda a itanino bawuwa gubernador a i Festo. ");
INSERT INTO gdg_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Wasin pipidya awiran sinay, sinapiti Festo ki Ari Agripeno mappeafu ki Pablo. Sinapiꞌna si, “Ayawino tata a balud sitawa inanawani Gubernador Felix. ");
INSERT INTO gdg_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Wasin nagyanak sey Jerusalem, inang sikwakino pangafuwanirana padi andino korwanira a pangafuwanna Judyu a nidarum sikwana. Inaranda si onangkuweno katayanna. ");
INSERT INTO gdg_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Udde sinabbaggu si bakkanna gagangemiya Roma a mangiyalawat sino nedaruma tolay sino korwanira ta makastigu nu ammena kepay nausig. Maawag si umaꞌlang abbu sino nidarumira sikwana takesi damana a taꞌdagganingkepayino baggina. ");
INSERT INTO gdg_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Wasin ginamwangira sitaw, ammek nattalantan, nu ammek lud inang sino attatarabban si kadaramaꞌna, e nepaayagguwi Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Naddamitino nangidarum sikwana. Ariggu si wara nadammat si ipaliwaꞌda sikwana, gampade awan. ");
INSERT INTO gdg_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","Ino pelang nassasarombatanda, mappeafu sino angngurudda a Judyu anna mappeafu sino natay a i Jesus a kunni Pablo si nangngangoli. ");
INSERT INTO gdg_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Gafu se ammek ammuwa mimbistigar si kunnayan, binebukku ki Pablo nu anggamma a umang sey Jerusalem ta antuweno kaimbistigaranna. ");
INSERT INTO gdg_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Udde ammena anggam, se ino anggamma, mebalud sitaw kiyad si ino Emperador sey Romeno musig sikwana. Antu gafuna, nepaindaggu makkiyad si wara wayaka mappetulud sikwana sino Emperador.” ");
INSERT INTO gdg_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Wasinoy, sinapiti Agripa ki Festo si, “Anggangku nadda dingngaggan inaya tolay.” “Nu daramatinna mantu,” kunni Festo. ");
INSERT INTO gdg_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Waso kadaramaꞌna, inanda Agripa anni Bernice sino attatarabbanda, e nangipaitera si kedayawanda. Nebulunino komanderirana sindalu andino bafaꞌnangngira a tolay sinaya lubbun. Wasino sinallungira, inayani Festowi Pablo. ");
INSERT INTO gdg_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Sinapiti Festo si, “Ikka Ari Agripa anna ikkayu ammina ana sitaw, iyawa tolaya aggitandaw, antuweno nedarumino Judyuwera sitaw andino Judyuwera sey Jerusalem, a ikakkulawura ammin si ammena naddinna matolay. ");
INSERT INTO gdg_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Awana naammuwangku si liwaꞌna a mepangngat si ipatena, udde gafu se inarangnga si umaꞌlang sino Emperador sey Roma, nadandangku si petulud sinay. ");
INSERT INTO gdg_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Udde awana ammuk si fustuwa iturakku sino Emperador mappeafu sikwana. Antu gafuna, nepaaꞌlangku sikwayu ammin, kumarallingke sikwam Ari Agripa, takesi nu warana mafuꞌngaddantam sikwana, warana iturakku. ");
INSERT INTO gdg_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Se ammena mepangngat si iyalawakku sino Emperadorino tata balud nu awana kedarumanna.” ");
INSERT INTO gdg_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Wasin kunnenoy, kunni Agripa ki Pablo si, “Damama massapit sino anggammu.” Nesengyatti Pabloweno kamaꞌna sino tolayira, kasena neyafuwa maddamit, e nekunna si, ");
INSERT INTO gdg_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","“Ikka Ari Agripa, nalawad se ayoka sitaw ta dingngaggannu payino itabbaggu sino ammina pidarumanino kasiJudyutamira sikwak. ");
INSERT INTO gdg_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","Se ammuk si ammum amminino gagangetama Judyu annino passasarombatantam. Arangngangku sikwam ta dingngaggandak abbu. ");
INSERT INTO gdg_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","“Ammu amminino kasiJudyutamireno katotolek kiyad sin neyanakangku, sino lubbuna dinokallangku anna sey Jerusalem a nadalangku. ");
INSERT INTO gdg_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","Nu angganda, ammura a sapitan, se ammura si kiyad siꞌin nesapatak sino Fariseowera, a ireno katalanggaddan sino aggangwatama Judyu. ");
INSERT INTO gdg_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","Sitoya, ayawak sitawa mausig gafu se minnanamak si gakkuruwanni Diosino nekarina sino gagginafutamira siꞌina pangngangolinnaneno natayira. ");
INSERT INTO gdg_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","Amminino kasiJudyutamira, maddandayawira ki Dios si aw anna gafi, se innanamanda si mesapatira sino nekariyi Dios siꞌin. Udde Afu Ari, gafu se kuruwangku si neyakkuruwinnino nekariyi Dios, antuweno pidarumanda sikwak. ");
INSERT INTO gdg_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","Ikkayu ammin sitaw, mayan natuꞌnakkayungke a mangurug si pangngangolini Diosino natayira? ");
INSERT INTO gdg_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","“Massiki ikkanak, ino dinandangku siꞌin, nalawad nu gakkuruwangkungke a makkontara sino manguruwira ki Jesus a taga-Nazaret. ");
INSERT INTO gdg_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","Kunnenoyino inangwak sey Jerusalem. Odduweno tolayira i Dios a nepabaluggu, se neaꞌdeno pangafuwanirana padiyeno turek. E sin sinapiꞌda si mapapatayira, inanggammangku kappay. ");
INSERT INTO gdg_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","Namipidyaka inang sino sinagogera ta kastigungkuweno manguruwira ta patutangkuwera a mattalekkud sino angngurudda. Gafu se naoꞌganino bungukku sino manguruwira, inangngak si korwana lulubbuna mappadyat sikwara.” ");
INSERT INTO gdg_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","Sinapikkappayi Pablo si, “Antu gafuneno inangngangku sey Damasco a manoꞌma sino manguruwira ki Jesus sinay, se aneno neyaꞌdeno pangafuwanirana padiya tureka manoꞌma. ");
INSERT INTO gdg_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","E wasin agyangkami kepay sino dalan si tangnganaw, Afu Ari, initakino baggawa mangngilikilita naggabwat sey langita nabaggawingke amma sino sinag. Linebannakami andino bulungkuwera, ");
INSERT INTO gdg_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","e naletwaggami ammin. E agyanino diningngagguwa damita naddamit si damiꞌna Hebreo, a sinapiꞌna si, ‘Saulo, Saulo, mayan padyatannak? Ino baggimungkepayino padyatannuwa mangontara sikwak.’ ");
INSERT INTO gdg_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","E sinapikku si, ‘Inyaka, Afu?’ E sinapiꞌna si, ‘Ikkanaki Jesus a padyatannu. ");
INSERT INTO gdg_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","Gumabwakka, se ino gafuneno nappaddangku sikwam, pinilitaka a aripangkuwa umang mangipakaammu sino tolayira sito nappaitangku sikwam sito aw annino ipaitaꞌnga sikwam naso maddagguna aw. ");
INSERT INTO gdg_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","Dundunantaka a manuldu sino kasiJudyumira annino bakkannira a Judyu, e nu sanneno akwanda sikwam, imutantaka. ");
INSERT INTO gdg_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","Tulduwannuwerana takesi maammuwandeno mappeafu sikwak ta talekkurandeno narakkat e mabaggawanino nakanda. Nu talekkuranda i Satanas a matturay sikwara e aꞌlanganda i Dios e manguruwira sikwak, mapakomanneno liwaꞌdera e mebilangira sino piniliyera i Dios si tolena.’ Antuweno netulduwi Afu Jesus sikwak.” ");
INSERT INTO gdg_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","Wasinoy, sinubburani Pabloweno sinapiꞌna si, “Kunna mantu, Ari Agripa, kinuruggungke ino sinapiti Jesus sin nappaitanna sikwak. ");
INSERT INTO gdg_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","Neyafuka nanuldu sey Damasco, kasena sey Jerusalem anna sino palulubbunna probinsiya a Judea, kasek kappay nanuldu sino bakkannira a Judyu. Ino netulduk sikwara, ibobolira naddino liwaꞌda ta umaꞌlangira ki Dios, e mangwera nad si nalawara pamakurudda si gakkuruwingke a nabboboliyeran. ");
INSERT INTO gdg_vpl VALUE