﻿USE sofia;
DROP TABLE IF EXISTS sofia.gdf_vpl;
CREATE TABLE gdf_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gdf_vpl WRITE;
INSERT INTO gdf_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Ina ndazhazhana kǝ tugwa mbǝrt Yasu Kristu, zǝr Dod, zǝr Brakhim. ");
INSERT INTO gdf_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Brakhim kǝ yiga Ishaku, Ishaku kǝ yiga Yakub, Yakub kǝ yiga Yakhud zǝ zarbabakh sar, ");
INSERT INTO gdf_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Yakhud kǝ yiga Perez zǝ Zera ai yiga Tamar, Perez kǝ yiga Khezron, Khezron kǝ yiga Ram, ");
INSERT INTO gdf_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Ram kǝ yiga Aminadab, Aminadab kǝ yiga Nakhshon, Nakhshon kǝ yiga Salmon, ");
INSERT INTO gdf_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon kǝ yiga Boaz, bab sara Rakhab, Boaz kǝ yiga Obed bab sara Rutl, Obed kǝ yiga Yese, ");
INSERT INTO gdf_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Yese kǝ yiga Dod shik. Dod kǝ yiga Sulemanu ai yiga nus Uri. ");
INSERT INTO gdf_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Sulemanu kǝ yiga Rekhobom, Rekhobom kǝ yiga Abij. Abij kǝ yiga Asa, ");
INSERT INTO gdf_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","As kǝ yiga Jekhoshafat. Jekhoshafat kǝ yiga Joram, Joram kǝ yiga Uzi. ");
INSERT INTO gdf_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uzi kǝ yiga Jotlam, Jotlam kǝ yiga Ahaz. Ahaz kǝ yiga Khezikay, ");
INSERT INTO gdf_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Khezikay kǝ yiga Manas. Manas kǝ yiga Amon, Amon kǝ yiga Yosi. ");
INSERT INTO gdf_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Yosi kǝ yiga Yekoni, zǝ zarbabakh sar ǝn tǝ sarte tsa khutsalud udakh ya Yakhud da man vǝɓ ǝn Khay ya Babil. ");
INSERT INTO gdf_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ən tǝ khal kǝ ɓǝtral ɓa tsud da khaya Babil. Ka yiga Yekoni ad Sheyaltiyal. Sheyaltiyal kǝ yiga Zerobabel, ");
INSERT INTO gdf_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zerobabel kǝ yiga Abikhud. Abikhud kǝ yiga Eliyakim. Eliyakim kǝ yiga Azor, ");
INSERT INTO gdf_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azor kǝ yiga Zadok, Zadok kǝ yiga Akim, Akim kǝ yiga Eliyud ");
INSERT INTO gdf_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Eliyud kǝ yiga Eliyazar, Eliyazar kǝ yiga Matan, Matan kǝ yiga Yakub, ");
INSERT INTO gdf_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakub kǝ yiga Yusuvu zil Maryam, Maryam tsuguna ka yigan ad Yasu ai ɗakhdud dǝ Kristu. ");
INSERT INTO gdf_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Tsiyif ǝnt Brakhim kakh da tǝ Dod, a nala kǝ kǝlgwidz klatǝm ufaɗ. Tsiyif ǝn tǝ Dod, tsa kǝlgwidz klatǝm ufaɗ ǝn sarte a dzǝtrarud ak Izrailakh da man vǝɓ ǝn Babil. Tsiyif ǝn tǝ sarte tsǝn manud vǝɓ ǝn Babil da tǝ sarte yigdud Kristu tsa kǝlgwidz klatǝm ufaɗ. ");
INSERT INTO gdf_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Auna ɗule a yigdud Yasu Kristu. Ən sarta sǝb Maryam bab Yasu kǝ Jisav, kǝda nguɗatra sǝba tsuda, ka dzoghǝr khuɗ tsin tǝ dǝva dǝ ndzǝɗa Sǝɗikw Chuwaɗaɗan. ");
INSERT INTO gdf_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Jambu sar Jisava ud charan, nagh ba dǝ kǝɗara zhiru ǝn tatak udakh bi. Ka ɗayanan ad ghǝr kǝ tǝkaghera tsitar ɓǝghanyan. ");
INSERT INTO gdf_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Madvin ǝn ɗaya ghǝra, dzagwdlam ǝmdlawala zǝrɓǝla Yazhigǝl tsin ǝn suwan. Niya tsin, “Jisav zǝr Dod, a ɗuwa gǝdza kǝ zǝɓ Maryam kǝ nǝga kǝ nusagh, wirva khuɗsarna a sa tǝdǝva dǝ ndzǝɗa Siɗikw Chuwaɗaɗan. ");
INSERT INTO gdf_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Da yigayiga dǝ zǝr dǝɗungw, da barva bǝg kha ɗakha Yasu. Wirva in da kat yakhtar ǝn khaipakh tar.” ");
INSERT INTO gdf_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Daghan ina a dzoghǝr kǝ righada dǝge a kwarga Dadzikan tǝ dǝva dǝ tlayang kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Da dlǝgh khuɗ dughmbǝl, da yiga yiga ad zer. Ka da barva ɗakhud Manuwel.” Dǝge tuku Manuwel na in kwarne “Dagha kǝnda zǝ Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Tsiyif kǝ Yusuvu ǝn khara, ka gatars kǝ lave a kwararkhe zǝrɓǝla Yazhigǝl. Yusuvu tsuguna ka ɓǝf ad Maryam kǝ nǝga kǝ nus sar. ");
INSERT INTO gdf_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","A khǝnarghǝr bi, ba yiga tsin zǝr sar. Ka barva Yusuvu ad ɗakha Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","A yava Yasu ǝn kǝs ya Baitalkhami ǝn ǝntla khay ya Yakhudi ǝn kwarga shik Khiridus. Ən tǝ yanen kǝ sart, ka sosǝg kǝ li tsatsǝg ǝn tǝghǝr kǝ kwadladlakh sǝgo ǝn mbǝrt kǝs, da wurshalim. Ka ndiɗa tsitar ");
INSERT INTO gdf_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","kwarne, “Ən vara fitl na yavan ai da nǝga kǝ shik Yakhudakh ni? Wirva a nǝgha tsǝkǝnda kwadladl sar sǝgo ǝn mbǝrt kǝs, wirva yana a so da ɗabaɗaba kǝnd.” ");
INSERT INTO gdf_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Tsǝna kǝ Khiridus Shik ad yan, ka tsiyif mǝkǝn sar zǝva udakh daghan ǝn Wurshalim. ");
INSERT INTO gdf_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Ka dzakhanǝf ad zik zikan na kǝ zil kǝsakh, zǝ li tsagdu ndzikha ndzikh Mus. Ka ndiɗatǝrwal ad vake da yigdud Kristu. ");
INSERT INTO gdf_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Ka nǝv itar tsin, “Ən kǝs ya Baitalkhami, ǝn ǝntla khay ya Yakhudi. Wirva a vindzga ndǝk yan tlayangen ad dǝge a kwarga Yazhigǝl kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ ‘Ghǝra tsugun Baitalkhami ǝntla khay ya Yakhud, Khǝɗikan bakhǝn li man tlǝkǝs ǝn Yakhud bi; Wirva da sǝgawal ǝn tǝb tsǝkur dadake da man tlǝks, Dadake da zighw udakhar ya Israil.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ka ɗakhga Khiridus ad li tsatsǝgen ɓǝghanyan, ki nǝghda tsatsǝg tsin ad sarte tsa ǝmdlawala kwadladlen. ");
INSERT INTO gdf_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Ka ɓǝlatǝral dǝgal da Baitalkhami, ka ni, “Dam da nǝghamako ndǝghǝr nǝgh ad fitlen ɗussa nikur. Da tlarghǝr kur, ka kwara ke kur ki dǝgal kǝ ghǝrar da ɗabaɗab.” ");
INSERT INTO gdf_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Udzala tsitar ǝn tsǝn lav shika, ka dal itar. Kwadladle tsa nǝgha itar ǝn mbǝrtǝ kǝsena ǝn tǝ vuk tar. Ka gatars gata tsitar tlǝm sa tsin da tǝghǝr kǝ vake dǝ fitlen. ");
INSERT INTO gdf_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Nǝgha tsitar ad kwadladlen ka righǝf itar dǝ khwaɗǝga char. ");
INSERT INTO gdf_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Da tsitar da mǝghen, ka nǝgha tsitar fitlen zǝ Maryam bab sar, kalga itar juguv ǝn tǝ vuksar, ka ɗabanǝf itar. Ka vadana itar mbǝl jilaɗakh tar ka bara itar ad dawan zǝ tǝrshin ɗiz ai manavadal sǝgawal ǝn uf ai ɗakhdud frankinsens, zǝ ai ɗakhud Mir ǝn tlerna uf. ");
INSERT INTO gdf_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ka gwiyagh itar ǝn tǝ tlǝrna ɗul da kǝstar, wirva tsa tǝkhatǝranud ǝn suwan kwarne, a ɗuwa itar gwiya daks da vak Khiridus. ");
INSERT INTO gdf_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ən tǝ khal kǝ daldǝg tsitar, ka tlarghǝr zǝrɓǝla Yazhigǝl kǝ Yusuvu ǝn suwan, avin, “Tsiya, zǝɓa ad fitl na zǝ bab sar khwaya dǝgal da Masar. Giɗam giɗǝn vin kwa kwara kurkhai ka saks, wirva da gatagata Khiridus ad zǝrna kǝ kǝɗakǝɗ.” ");
INSERT INTO gdf_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Ka tsiyǝf Yusuvu ɓǝf ad fitlen zǝ babsar kǝviɗ, ka dal da khay Masar. ");
INSERT INTO gdf_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ka nndzǝgan ǝn vin da tǝ sarte a ǝmtsǝga Khiridus. Ina kǝ digit a dzaughǝr ki zǝɗa righada dǝge a kwarga Dadzikan ǝn tǝ dǝva dǝ ghay tlayangen kwarne, “A ɗakhadǝghǝr ǝn Masar ka zǝrar.” ");
INSERT INTO gdf_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Katlga kǝ Khiridus kwarne raja kharghǝra liye tsa digit ǝn tǝghǝr kǝ kwadladlen, ka nguɗǝrǝv tsin char. Ka ɓǝlanǝf ad udakh kǝ khadzga ɗeghwa zǝr dǝɗungw ǝn Baitalkhami zai ǝn gǝdzar kǝsakhe tǝvǝgh, tsiyif ǝn tǝ vǝg mits da tǝ vunj, kalkala sarte tsa kwararkhai li tsatsǝgen ǝn tǝ ghǝr kǝ zǝren. ");
INSERT INTO gdf_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","A righif lave tsa kwarga Irimi tlayang; ");
INSERT INTO gdf_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ka tsǝna tsena tsud ad kwind ǝn dlǝgh tsits. Kwinda tuwa ziwaziw, Rakhil ǝn tuwa wirva zarsar. A piyarwala kitlandagh rǝv. Wirva a ruga zar sar.” ");
INSERT INTO gdf_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Tǝkhal kǝ ǝmtsa Khiridus, ka tlarghǝr zǝrɓǝla Yazhigǝl kǝ Yusuvu ǝn suwan ǝn Masar ");
INSERT INTO gdf_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ni, “Tsiya ɓǝf ɓa dǝ fitlǝn zǝ bab sar gwiya daks da Izrail, wirva liye gat kǝɗ fitl na a ruwargan.” ");
INSERT INTO gdf_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Ka tsiyif, ɓǝf ad fitlen zǝ babsar ka gwiya da khay ya Izrail. ");
INSERT INTO gdf_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Ai tsǝna tsin kwarne zǝr Khiridus, ai dakhdud Arkilayus kǝ chauga tlǝksa dad sar, ǝn man tlǝks ǝn khay ya Yakhudi, ka gǝdza tsin dǝgal da vinen. Wirva tsa tǝkhatǝranud ǝn suwana, ka khutsval da ǝntla khaya Galili. ");
INSERT INTO gdf_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Ka dal da giɗǝn tlǝrna kǝsen ǝn ɗakhdud dǝ Nazarat. “Ki righada dǝge tsa kwarga tlayang kwarne, Zǝrna da ɗakha dǝ zil Nazarat ud.” ");
INSERT INTO gdf_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ən tǝ yanen kǝ sart, a sawal Yukhan dadak para ud da kwardu lav Yazhigǝl ǝn tǝghal ǝntla khay ya Yakhudi. ");
INSERT INTO gdf_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ni, “Pǝlam pǝla ghǝr, wirva tlǝksa Yazhigǝla a khǝrzgan.” ");
INSERT INTO gdf_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Tsa Yukhan dadake tsǝn kwara Ishay tlayang ad laven tǝghǝr tsin kwarne, “Kwinda ud ǝn tlǝkh ǝn tǝghal kwarne, ‘Ɗikamarna ɗul kǝ Dadzikan, Andz ger nǝv ɗulsar.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Gabage talǝm Yukhan na a manava dǝ guj tlǝgwam. Nguɗan sambal ǝn tǝ khukw tsin. Dǝg zuwa sara tsǝvakwa zǝ mam tǝghal. ");
INSERT INTO gdf_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Tǝkǝna udakh ya Wurshalim zǝ ǝntla Yakhudi daghan, zǝ daghan ǝntla khay zagh Urdun, ka sakhgawal itar da vaksar, ");
INSERT INTO gdf_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ka kwarakh khaipakhtar itar, ka paratǝra para tsin ǝn zagh Urdun. ");
INSERT INTO gdf_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Ai vazga kǝ Yukhan ad Farisakh zǝ Sadukiyakh zikǝn sǝgawal da vaksar kǝ paratǝrapar, ka niya tsitar, “Kur zar ya pushakh. War kǝ khiɗakurf kǝ ngikh kuba rǝvakhuɗ Yazhigǝl nǝn saksi? ");
INSERT INTO gdf_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Manam giɗe da ǝmdla kwarne a palga kur ghǝr ǝn khaipakhur. ");
INSERT INTO gdf_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Dzamam ba ǝn khuɗur kwarne, ‘Dadǝnda Brakhim bi,’ Ən tǝkha kura tǝkha kǝ. Tǝkha Yazhigǝl kǝ vǝrɗarkhai zara kǝ Brakhim sǝgawal ǝn kurakhan. ");
INSERT INTO gdf_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Audzalud ǝn bars khil kǝ mbǝrt uf. Itsera kǝ ufe kwal yig zar charan ka ǝntlarsud kǝɗaghud da kar. ");
INSERT INTO gdf_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“Ni ka ǝn para kura dǝ yu kǝ, kǝ mǝtlada kwarne a palga kur ghǝr, ude ndanga tǝghǝr tsǝka da saks ǝn tǝ khal tsǝk, ude itsa kimbak sar tǝkh ba ka kǝ ɓanǝf bi. In da para kuran dǝ Sǝɗikw Chuwaɗaɗan, zǝ kar tsugun. ");
INSERT INTO gdf_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Khutan ad kwat kava sar, kǝ kav khi sar ǝn tǝ ghwuzay, ka dzanǝf ad khi, ɗidagh ǝn kuvur sar, ka ndǝghanan ad tlitl dǝ kare kwal tǝkha tsud kǝ kǝɗgan.” ");
INSERT INTO gdf_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Ən tǝ khalak yan ka sagha Yasu ǝn Galili, da vak Yukhan kǝ parapara tsud ǝn zagha Urdun. ");
INSERT INTO gdf_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Tsǝn na Yukhan ad gadlara gadl. Ka niya tsin, “Ka tsǝn nagha paraka para tsǝkha ka kha kǝ sagha da vakara?” ");
INSERT INTO gdf_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Ka ngawarkhai Yasu kwarne, “nalnǝgin ndǝk yan, wirva ndǝk yan khwaran kǝ righada dǝge ǝn nagha Yazhigǝl.” Khal kǝ yana ka khayanǝf Yukhan. ");
INSERT INTO gdf_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Ən tǝ khal kǝ Parandal tsud Yasu, madvin ǝn sǝgawal ǝn yu, tǝvin tǝvina ka ngurǝf garazhigǝl, ka nǝghan ad sǝɗikw Yazhigǝl ǝn sǝgadagh ndǝk kakur, sodagh da tǝghǝr tsin. ");
INSERT INTO gdf_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ka tsǝnud lava sǝgadagh ǝn gharazhigǝl kwarne, “Ina zǝrare ǝn waya kǝ, ǝn tsǝn zǝɗa sar ka char.” ");
INSERT INTO gdf_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Ka fiwandal Sǝɗikw Chuwaɗaɗan ad Yasu da tǝghal kǝ kurakura kǝ wurdu. ");
INSERT INTO gdf_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","A zǝɓga Yasu ad ndǝl khǝna kul ufaɗ viɗa zǝ fatsi. Kǝ khala ka ndzikǝnǝf way. ");
INSERT INTO gdf_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Ka sa wurdu niya tsin, “Da zǝr Yazhigǝl kha, kwarara kwara kǝ kurakhan nalnǝg itar kǝ dǝg zu.” ");
INSERT INTO gdf_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Ka ngawarkhe Yasu kwarne, “Vindzan ǝn kaɗkaɗ Yazhigǝl kwarne, ‘Uk ǝn safǝn tǝ dǝg zuwa kitakul bud bi, khekwa dǝ itsera kǝ lave ǝn sǝgawal ǝn ghay kǝ Yazhigǝl.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ka ɓala wurdu da dlǝmdla kǝs Chuwaɗaɗan ǝn Wurshalim, ka ɓoɓa tsin da tǝ ghǝr kǝ beɗem fǝta Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","Niya tsin, “Da zǝr Yazhigǝl kha,” ghǝdzǝvdagh ghǝdzǝva dǝg dagh da khay, wirva vindzan kwarne, “ ‘Da batra bǝg Yazhigǝl ad ndzǝɗa kǝ zarɓǝlakh sar kǝ kat kha kat. Ka da chau kha chawa itar dǝ dǝv tar. Khek kǝɗkhe kǝ kur ǝn tǝ sig.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Ka nǝv Yasu tsin, “Vindzan tsugun kwarne, ‘Kura ba dǝ Dad zikan Yazhigǝla bi.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Ka gwidǝn wurdu ad ɓoɓa dǝgo da tǝ tsǝɓan na kǝ ghay ghuɓ, ka mǝdlaran ad tlǝksakh lard zǝ zika khwara sar daghan. ");
INSERT INTO gdf_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","Ka niya tsin, “Da kǝla ke kha juguv ɗaba ke kh. Daghan dǝgakhana da bakha bǝg kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Ka nǝv Yasu tsin, Tsiya dǝgal ǝn van kha shatan, wirva vindzan kwarne, “ ‘Ɗabaɗaba Dad zikan Yazhigǝlakh, tsuguna in kitakul da manara kha tlǝr.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Khalak yana ka ɗuwars wurdu, ka sǝgdagh kǝ zarɓǝlakh Yazhigǝl da nǝgharu nǝgh. ");
INSERT INTO gdf_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Tsǝna kǝ Yasu kwarne a viyava Yukhan da sal, ka tsiya tsin dǝgal da Nazarat ǝn Galili. ");
INSERT INTO gdf_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Ka ɗuwars ad Nazarat, dal da giɗǝn Kafarnakhum, ai tǝvai ǝn tuk dǝlv ǝn tǝ ghala ǝntla khaya Zǝbulun zǝ Naftali. ");
INSERT INTO gdf_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ki da righada lave kwarga Yazhigǝl ǝn tǝ dǝva dǝ Ishay tlayang kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Əntla khay mbǝrt Zebulun, zǝ dǝg Naftali ǝn Galili. Ən tǝ ɗul dǝlva Madateri, tangw da tǝ ǝntla khay zagha Urdun, Galili vake ǝn giɗda liye kwal Yakhudakh. ");
INSERT INTO gdf_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Liye ǝn giɗǝn gurtl. Nǝgha tsitar kǝs kheɗaɗ char. Liye giɗǝn kǝs sǝɗikw fayam ǝmtsa. A mǝdlawala kheɗaɗa kes da vak tar.” ");
INSERT INTO gdf_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Tsif tǝ yanen kǝ sart, a farsa Yasu ad kwardu lav Yazhigǝl, ǝn kwar kwarne, “Pǝlam pǝla ghǝr, wirva tlǝksa Yazhigǝl a khǝrzǝgan.” ");
INSERT INTO gdf_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Madǝv Yasu ǝn dǝgal ǝn tǝ kalam dǝlva Galili ma, ka nǝghanǝgha tsin zarbabakh mits, Simane ɗakhdud dǝ Bitrus zǝ zer bab sar Ndros. Ən ɗay sika vay kilf itar da dǝlv, wirva li vay kilf itar. ");
INSERT INTO gdf_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Ka nǝv Yasu tsitar, “Gatamakǝs gat, da nakurar nǝg ka kǝ li khutsado ud ndǝkve ǝn vaya kur kilf.” ");
INSERT INTO gdf_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Tǝvin tǝvina ka ɗuwars itar ad sikakh tar, ka gatars itar. ");
INSERT INTO gdf_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Din ǝn zu vuk dǝ dǝga, ka nǝghan ad yakhaya kǝ zarbabakh mits tsugun, ai Yakub zǝr Zabadi zǝ zer bab sar Yukhan. Ən peryu itar zǝ dad tar Zabadi, ǝn ɗika sikakh tar itar. Ka ɗakh tǝrkhai. ");
INSERT INTO gdf_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Tǝvin tǝvina ka ɗuda itar peryu tar zǝ dad tar, ka gatars itar. ");
INSERT INTO gdf_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","A gwayafkhai Yasu ǝn kǝs Galili daghan, ǝn tsagakhdu lav Yazhigǝl ǝn gud dzakhav Yakhudakh. Ka kwardu lav zǝɗǝn tǝghǝr kǝ tlǝksa yazhigǝl. Ən mbakha itsera kǝ khulf kuz, zǝ liye kwal yang kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","A tsa tǝ dǝva dǝ yan kǝ tlǝr ud ad Yasu ǝn khay ya Suri daghan. Ka zaɓardo li kwal yang ud zǝ liye ǝn tuk kuzakh sikh sikh sikh zǝ li khǝɓ dlaɗ, zǝ li sǝɗikw bǝzan, zǝ liye tlavarghǝr wurdu zǝ li ǝmtsa kalam vǝgh, a mbakhatru daghan. ");
INSERT INTO gdf_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","A gatars dzakhava udakh zikǝn sǝgawal ǝn Galili, zǝ ǝntla khaya kǝsakh kǝlɗǝk, zǝ Wurshalim, zǝ ǝntla khaya Yakhudi, zǝva liye ǝn ghǝdzǝva zagha Urdun. ");
INSERT INTO gdf_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Vazga kǝ Yasu a dzafkhai udakh zikǝn, do da tǝ gil, ka nndzǝgan. Ka saks kǝ furakh sar da vak sar, ");
INSERT INTO gdf_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ka farsa tsagatǝra lava tsin kwarne; ");
INSERT INTO gdf_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","A batǝrghǝr Yazhigǝl ad bark kǝ liye ǝn tsa khǝtsala khǝtsa tar ǝn dǝgakhe ǝn nagha Yazhigǝl, Wirva tlǝksa gharazhigǝla da dǝg tar. ");
INSERT INTO gdf_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Nǝg bark kǝ liye bazan rǝvakhuɗ. Wirva da kitla tǝra rǝvud. ");
INSERT INTO gdf_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Nǝg bark kǝ liye gulandagh ghǝrtar, Da wurawura itar ad dǝgakhe manga Yazhigǝl ad lanji sar. ");
INSERT INTO gdf_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Nǝg bark kǝ liye way man dǝgakhe ǝn nagha Yazhigǝl. Wirva da bagha tǝra bagh. ");
INSERT INTO gdf_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Nǝg bark kǝ liye mǝdla kwiɗkwiɗǝrǝv. Wirva da mǝdla tǝra mǝdla Yazhigǝl ad kwiɗkwiɗǝrǝv. ");
INSERT INTO gdf_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Nǝg bark kǝ liye chuwaɗaɗ rǝva tar. Da nǝghanǝgha itar Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Nǝg bark kǝ liye matla giɗa khwiɗ. Da ɗakh tǝr dǝ zar Yazhigǝl ud. ");
INSERT INTO gdf_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Nǝg bark kǝ liye ǝn batǝrud dlaɗ wirvǝn man dǝgakhe ǝn nagha Yazhigǝl itar. Wirva tlǝksa Yazhigǝla dǝg tar. ");
INSERT INTO gdf_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Nǝg bark tsǝkur, madǝv udakh ǝn lakh kur lakh, zǝ bakura dlaɗ, zǝ ngatla filakh ǝn teghǝr tsǝkur sikh sikh sikh, wirva li gataks gata kur. ");
INSERT INTO gdf_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Kwam khwaɗǝg zǝ panakha rǝv char, wirva da gǝmadu gǝma kur dǝg sigur zikǝn ǝn ghǝrazhigǝl, wirva a batra ndǝk yan ud dlaɗ ak tlayangakh Yazhigǝl liye tsa soghǝr chak tǝghǝr tsǝkur. ");
INSERT INTO gdf_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Kuram tlǝgul lard. Da tǝkaghǝra tlǝgul zǝ nashnash sar, da wurondǝghǝr ndarud zǝɗa sari? Aghba dla dǝge ǝn tukuwin bi akwa ɗiduwud, ghǝdlapakh gud. ");
INSERT INTO gdf_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Kuram kheɗaɗ lard. Afke dlǝmdla kǝs ai khavǝn tǝ bǝɗar ǝn ɓǝghafǝkhai bi. ");
INSERT INTO gdf_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Na bud ǝn vǝdzanǝf kara kazaz ka khǝmbarghǝrud gagay bi, akwa bugud ǝn tǝ vak ghitsa sar vake da mǝdlaradin ɗul kǝ li mǝgh kheɗeɗ. ");
INSERT INTO gdf_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ndǝk yan tsugun, namal nǝg kheɗeɗ tsi kǝ udakh, wirva da nǝgha tsitar ad tlǝr khwarane manakur, da farghǝrafǝg itar kǝ Dadure ǝn ghǝrazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Dzamamba kwarne a sodagh da kala ndzikhandzikh Mus zǝ dǝge vindzan ǝn kaɗkaɗ tlayangakh ba ka bi. A so da kala kala ba ka bi, a so kǝ regharegha kǝ. ");
INSERT INTO gdf_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Kaɗi ǝn kwara kura kǝ, akwa mbasu ghǝrazhighǝl zǝ khay, nga itsa khǝɗikana kǝ lav ai da ɓǝlal ǝn dǝge a tsagdu Mus bi, kwa reghanaud itsauɗ. ");
INSERT INTO gdf_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Wirva yan ɗaga ude kǝlanǝm itsa kitakul ǝn khǝɗikan nak ndzikha ndzikha khan, zǝ tsagardu kǝ udakh ad kǝla ndzikha ndzikha khan, da ɗakha dǝ khǝɗikan kǝ udud ǝn tlǝksa Yazhigǝl. Ude gatars, ka tsagardu kǝ udakh tsugun, da ɗakha dǝ zikan kǝ udud ǝn tlǝksa Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Ən kwara kura kwara kǝ, da malga ba kur liye tsagdu nzikha nzikh Mus zǝ Farisakh kǝ kanadi bi, na kur daks da tlǝksa Yazhigǝl tsa ndar bi. ");
INSERT INTO gdf_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Tsǝna tsǝkur a kwarar khai yud kǝ dzidzakh mar kwarne, kǝɗam ba safa itsawar bi, itsera kǝ ude ǝn kǝɗga saf, ka da takara lavud. ");
INSERT INTO gdf_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Ən tǝkha kura tǝkha kǝ, ude nguɗarva rǝv kǝ zǝr bab sar, ka da takara lavud. Tsugun, ude gamp kha niya kǝ zǝr bab sar, da ɓaɓud da tǝvuk li taka lav ya Yakhudakh. Ude ɗakh zǝr bab sar tsugun dǝ dlag, da kǝɗ dagh da kara fay ud. ");
INSERT INTO gdf_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Wirva yan, dǝn bǝdu dǝg tsufa khǝn tǝ vak sadak, da dzamana kha kwarne nǝg dǝge ǝn tǝbur zǝ zǝrbaba gh, ");
INSERT INTO gdf_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","bǝga kha dǝg tsufaghen ndan ǝnt vak sadak. Dǝg dǝgal ndan da ɗikva zǝ zǝr babagh. Khalak yan ka saks kha da bǝdu dǝg tsufaghen. ");
INSERT INTO gdf_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Da kǝlga udan ad juguvagh, kujaɗ ɗikfǝkhai kha zin tǝkur ǝn tǝghǝr kǝ dǝg, kǝda tsukwa tsukur ǝn tǝ vak takalaven. Da na ba ndǝk yan bi, ka da matlakha zǝ dadak takalav, dadak takalava tsuguna ka ɓǝkha da vak del, tsuguna ka nguɗakhai yud ǝn zaw. ");
INSERT INTO gdf_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Jir ǝn kwara kha kǝ, na ba itar da ɓǝlakhs bǝla bi, kwa pǝlgakha kwaɓ na daghan ai gatakhsud din. ");
INSERT INTO gdf_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","A tsǝna tsǝkur a kwaravan kwarne, a ɗuwa man gwaragwar. ");
INSERT INTO gdf_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Ən kwara kura kwara ka kwarne, ude kǝmga dǝg khǝr, audzal ǝn manga gwaragwar zin ǝn rǝvakhuɗ sar. ");
INSERT INTO gdf_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Da di dǝva kafagh ǝn bǝg khan da man khaip, ndǝɗadal ndǝɗa tlǝvarskh. Azǝgha bǝghal ǝn tlǝrna tlepel vǝghagh tǝghǝr kǝɗdagh ɗumba vǝghagh da kar. ");
INSERT INTO gdf_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Da dǝva kafagh ǝn bǝg khan da man khaip, ǝntlars kha tlǝvarskh. Azǝgha bǝghal ǝn tlǝrna tlepel vǝghakh tǝghǝr kǝɗdagh ɗumba vǝghagh da kar. ");
INSERT INTO gdf_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","A gwidǝn ud kwara kwara kwarne, ude tǝkaghǝran zǝ nus sar, barari bara kaɗkaɗ tǝkaghǝra tsin. ");
INSERT INTO gdf_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Dǝge ǝn kwara kura ka in kwarne, da tǝkaghǝra udan zǝ nus sar dǝn tǝghǝr kǝ khaipa man gwaragwar bin bi, a ba da man gwaragwar. Itsawar ǝn ɓu nuse a tǝkaghǝra ze zil sar, gwaragwar ǝn manin. ");
INSERT INTO gdf_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Dakhkana a tsǝna tsǝkur a kwarkhai ud kǝ dzidzakh mar kwarne, kǝla ba dǝ waɗe manga kha bi, kwa righanǝf kha waɗe tsa waɗga kha kǝ Dadzikan. ");
INSERT INTO gdf_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Ai dǝge ǝn kwara kura ka in kwarne waɗam ba ɗikiɗiki bi, itsa dǝ gharazhigǝl, wirva vij giɗa Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Waɗam ba dǝ khay tsugun bi, wirva vak bǝg siga sar kǝ Yazhigǝl, awana tsad Wurshalim wirva in dlǝmdla kǝs zikan kǝ shik. ");
INSERT INTO gdf_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Waɗ ba dǝ ghǝrakh tsugun bi, wirva tǝkh bakha kǝ nandala guj kitakul kǝ maɗakw tsa kǝ lusan bi. ");
INSERT INTO gdf_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Dǝge khwara kǝ kwara tsǝkur in kwarne, ana bi au, da ɓalin sig ǝn mbiyan a so ǝn vake da wurdu yan. ");
INSERT INTO gdf_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Tsǝna tsǝkur a kwarga Yazhigǝl kwarne, da chiɓarnakha di kǝ ud, ka chiɓakhanud diyagh tsǝgun. Da lardarkha tliɗ kǝ ud, ka lakhdalud tliɗa tsǝgun. ");
INSERT INTO gdf_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Ai dǝge ǝn kwara kura ka in kwarne, da mana kurkhai udan ad ghaza pǝlama bi. Da ɗiyakhwal udan ad mekhwpengw ǝn tǝ diwa dǝva kaf, ka gwiyarnǝf khad diwa dǝva dleɓa tsugun. ");
INSERT INTO gdf_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Da kǝlakhghǝr udan ad juguv wirva pǝrɗaghval gabagagh, ka bara kha zǝva khǝɗikana kǝ gabagagh. ");
INSERT INTO gdf_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Da njǝghakhu dadak ndzǝɗan kǝ dǝgal da ǝntla fǝtǝl kitakul, ka dara dǝg kha ǝntla fǝtǝl mits. ");
INSERT INTO gdf_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Da takaɗga udan ad digit ǝn vakagh, barakh. Ude a sagh da takaɗ gǝmau ǝn vakagh tsugun, piyardu bi. ");
INSERT INTO gdf_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Tsǝna tsǝkur a kwarga Yazhigǝl kwarne, waya ad tlǝghǝrwitǝghagh, ɗuda kha dadak dawagh. ");
INSERT INTO gdf_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Dǝge kwara kura ka in kwarne wayam dadak dawur, mana matǝra ɗǝgau kǝ li bakura dlaɗ. ");
INSERT INTO gdf_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Ən tǝ dǝva yan da nǝga kur kǝ zar Dadur ǝn gharazhigǝl, dadake ǝn bǝg fatsi da tǝvǝn tǝghǝr kǝ li kalali zǝ liye kwal kalali, tǝɗadagh ad yu gharazhigǝl tsugun da tǝghǝr kǝ li kanadi zǝ liye kwal kanadi. ");
INSERT INTO gdf_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Da uk liye ǝn way kur way ǝn waya kur, ira kǝ dǝg siga da bakurudi? Itsa liye ǝn dza khadama, ǝn mana ndǝkyan bakh itara?. ");
INSERT INTO gdf_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Da uk zar babakhur ǝn nǝgardi kur, ai, uɗa manga kur mal kǝ yakhayi? Itsa liye kwal tsa Yazhigǝla ǝn mana ndǝk yan bakh itara? ");
INSERT INTO gdf_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","Wirva yan reghanyan nǝv giɗur ndǝkve reghan Dadur ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Tsukwamana ghǝr, bamaru ba tlǝr kanadiyur kǝ di bi. Wirva da manga kur ndǝk yan, da gǝmadu ba kur dǝg sigur ǝn vak Dadur ǝn gharazhigǝl bi. ");
INSERT INTO gdf_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Wirva yan, da da bǝdu dǝg buti kh, ɓaldu bǝn ghay bi, ndǝk ai ǝn mana mbaɗirakh ǝn gud dzakhav zǝn tǝ ɗulakh bi, wirva kǝ dlǝba tǝra dlǝba tsud. Ən tǝkha kura tǝkha kǝ, audzala itar ǝn gǝmadu dǝg siga tar. ");
INSERT INTO gdf_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Da ka da bǝdu dǝg buti kur kǝ dadake kwaldin, tsa ba dǝva dleɓagh ad dǝge ǝn mana dǝva kafagh bi. ");
INSERT INTO gdf_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Bǝdu bǝgagha nalnǝgin ɓǝghanyan. Dadaghe ǝn nǝgha nǝgh ad ɗaga dǝge ɓǝghanyan, da bakha dǝg sig. ");
INSERT INTO gdf_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Da da ɗǝgawa kur, manam ba ndǝk mbaɗirakh bi, li way ɗǝgau ǝn vak ghits ǝn gud dzakhava zǝ tuk ɗul ki nǝghatǝra nǝgha kǝ udakh. Jir ǝn kwara kura kǝ, audzala itar ǝn gǝmadu dǝg siga tar. ");
INSERT INTO gdf_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Ai da da ɗǝgawakh, dǝg daks da gud, ka khǝɗardu kh. Ɗǝgawaru ɗǝga kǝ Dadaghe kwal ǝn nǝgha tsud. Dadaghe ǝn nǝgha dǝge manud ɓǝghanyan, da bakha dǝg sig. ");
INSERT INTO gdf_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Da da ɗǝgawa kur, a ɗuwam gwayars kǝ lava zikǝn ndǝk liye kwal tsa Yazhigǝl, liye da ghǝr tsitar ǝn kurana, da gwayars itar kǝ lava zikǝna, ka da tsǝnatru tsǝnud. ");
INSERT INTO gdf_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Manam ba ndǝk itar bi, wirva tsa kǝ Dadur ad dǝge na kur, kǝda da takaɗa takaɗa tsǝkur. ");
INSERT INTO gdf_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Auna ɗule da ɗǝgauda kur. Dadmare ǝn gharazhigǝl, Farghǝr fǝgud kǝ ɗakhaghe chuwaɗaɗ. ");
INSERT INTO gdf_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Tlǝksagha ausǝgin sǝgdagh. Manud ad dǝge ǝn nakh ǝn lard. Ndǝkve ǝn manud ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Bakǝnda bǝg dǝg zuwa khan, ndǝkve ǝn bakǝnda kha tsika fatsi. ");
INSERT INTO gdf_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Ɓisa kǝndana kha khepa khǝnd. Ndǝkve ɓisara kǝnda kǝ li mana kǝnda ghaz. ");
INSERT INTO gdf_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ɓǝla kǝndu ba di daks da dlǝgd bi. Ai kat kǝnd kat ǝn dǝva kǝ wurdu. ");
INSERT INTO gdf_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Da ka ɓisarna kur kǝ li mana kura ghaz, Dadure ǝn gharazhigǝl tsuguna da ɓisa kura ɓis. ");
INSERT INTO gdf_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Ai da ka ɓisarna ba kur kǝ udakh tsugun bi, Dadure tsuguna, na ba da ɓisa kura khaipa khur bi. ");
INSERT INTO gdf_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Dǝn zǝb ndǝl kur, bazamdu ba vakdi ndǝke mana mbaɗirakh bi. Ni itara ǝn bazdu kǝ nǝghda mǝdlara kǝ udakh itar kwarne ǝn zǝɓ ndǝl itar. Kaɗikaɗi ǝn kwara kura kǝ, audzala itar ǝn gǝmadu dǝg siga tar. ");
INSERT INTO gdf_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Ya dǝn zǝɓ ndǝl kh, pardu kha vakdiyagh, masǝm kha wal ǝn ghǝr, ");
INSERT INTO gdf_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ki khek katlga tsud kwarne, ǝn zǝɓ ndǝl kh, uk Dadaghe kwal nǝgha tsud da tsan. Dadaghe ǝn nǝgha dǝge manud ɓǝghanyan, da bakha dǝg sig. ");
INSERT INTO gdf_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Dzakha mara ba lǝman kǝ ghǝrur ǝn lard bi, vake da bazdu terar zǝ kwalavi, zǝ vake da tǝkha gǝlakh kǝ chiɓanan kǝ daks da gǝl. ");
INSERT INTO gdf_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Dzakha mara kǝ ghǝrura ad lǝman ǝn gharazhigǝl, vake kwal da tǝkha kǝ tǝrara zǝ kwalavi kǝ bazdu, zǝ vake kwal tǝkha kǝ gǝl kǝ chiɓanan kǝ daks da gǝl. ");
INSERT INTO gdf_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Wirva vake dǝ lǝmanagha, ǝn vin mǝkǝnagh. ");
INSERT INTO gdf_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Diya in kara kazaza vǝgh, da ka lapi diyagha, ɗaga vǝgha gha ka da nǝga kǝ kheɗeɗ char. ");
INSERT INTO gdf_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Da ka yanga ba diya bi, daghan vǝgha gha da nǝga kǝ gurtl char. Da nala kheɗaɗa vǝghagh kǝ gurtla, ka da zikakhghǝr zika gurtl. ");
INSERT INTO gdf_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Na ude tǝkha kǝ manarkhai kwatnakh kǝ dadmǝgh mits bi, akwa waygan ad fanga, ɗudan ad fang. Bi khǝmbarvan kǝ yana ka nenanan ad yan. Ən manawa ba gatars kǝ Yazhigǝl zǝ kwaɓ tsǝkha bǝrdagha bi. ");
INSERT INTO gdf_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Wirva yan ǝn kwara kura kwara kǝ, dzamam ba safur, zǝ dǝge da zuwa kur zǝ dǝge da khǝɓa kur bi, zǝ kadlange da tala kur kǝ vǝghur bi. A malga bakh safa ad dǝg zuwa? Tsǝguna a malga bakh vǝgh ad kadlange da tala kura? ");
INSERT INTO gdf_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ən nǝgha bakh kur ɗikakh ǝn pǝdlǝn tǝ gharazhigǝla, na itar ǝn tukha bi, na itar ǝn tsǝg khi bi, naba itar ǝn dza khi da kuvur bi. Sakhkana Dadure ǝn gharazhigǝl ǝn batra dǝg zu. A malga bakh ndangura ad ɗikakh? ");
INSERT INTO gdf_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Warek ǝn kur ǝn tǝ dǝva dǝ ɗangw sar tǝkha kǝ sǝgarghǝr ǝntla sart tetl kǝ safa sari? ");
INSERT INTO gdf_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Ai wuɗek lava tsǝkur ǝn dzamghǝr ǝn tǝghǝr kǝ dǝge da tala kuri? Ən nǝgha bakh kur ɗaka kǝ sasikw zǝ firakh ǝn tǝ tǝghala? Na itar ǝn man tlǝr zǝ takhara kadlang kǝ ghǝr tar bi. ");
INSERT INTO gdf_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Sakhkana ǝn kwara kura kwara kǝ, itsa Saluman shik zǝ daghan ndanga sar, a taɓa ba dǝ chaɗfǝkhai ndǝk itsera tar bi. ");
INSERT INTO gdf_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Da ka tǝkha Yazhigǝl kǝ chaɗanǝf sasikw ǝn tǝ tǝghal ndǝk yan, ai khana nǝga, tǝkhula tlǝvdahgud da kara ka ndǝghanud, tǝkh bakh Yazhigǝl kǝ chaɗa kuruf mal kǝ yana? Kuram li khǝtsa fadǝghǝro fǝg. ");
INSERT INTO gdf_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Wirva yana ndiɗam ba kwarne, uɗa da zuwa kiyami? Uɗa da khǝɓa kiyami? Uɗa da tala kiyami? ");
INSERT INTO gdf_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Afke li kwal tsa Yazhigǝl ǝn gat yakhana kǝ digitakh, ai tsa kǝ Dadure ǝn gharazhigǝl kwarne ǝn nagha kur ad yakhana kǝ digitakh daghan. ");
INSERT INTO gdf_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Ai dǝg chaka gatam gata tlǝksa Yazhigǝl zǝ man dǝgakhai ǝn nagha Yazhigǝl, daghan yakhena kǝ digitakh da bakuran ghǝr bǝgud. ");
INSERT INTO gdf_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Wirva yan ndiɗam ba khul bi, wirva khula ǝn saks dǝ dlaɗakh sar. Dlaɗakhe khana a tlakurar kǝ khanen. ");
INSERT INTO gdf_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Bamarghǝr ba dǝ ghaza kǝ itsawar bi, khai kǝ ba kur ghǝr kǝ Yazhigǝl ad ghaz. ");
INSERT INTO gdf_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Ya khulf taka lave manakur kǝ udakh, da taka kura ndǝk yanud. Darame ǝn kurara da kur kǝ udakh, da kura kura din ud. ");
INSERT INTO gdf_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Uɗa kǝ mangan tsǝkha ǝn vaz sasikw ai ǝn di kǝ zǝr babagh, ai nguse ǝn di tsǝkha nga ɗangwa din biyi? ");
INSERT INTO gdf_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Da kwara ndarkha kǝ zǝr babagh kwarne, Ɓakhdal ɓa ka sasikw ǝn di tsǝkh, Ghǝra ghǝragh ngusan di tsǝkhe? ");
INSERT INTO gdf_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Mbaɗirana digi. Ndǝɗadal ndǝɗa ad nguse ǝn di tsa kha ndan, ki zǝɗa nǝgha nǝgha tsǝkha char, kǝ da ndǝɗado sasikw ai ǝn di kǝ sǝkwtagh. ");
INSERT INTO gdf_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Bamara ba dǝgakhe dǝg Yazhigǝl kǝ ghǝd bi, kaɗamardu ba dǝg kwinda chaɗure dzau gan ǝn tǝf kǝ daguwakh bi. Wirva da tǝrkwǝdu tǝrkwa itar, da guyafkhai itar da vakur da vandz kur vandza itar. ");
INSERT INTO gdf_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","Ɗawam ɗawa, da bakura bǝgud. Gatam gata da gǝmadu gǝma kur. Dughwam dughwa ghay gud da ngura kura ngurud. ");
INSERT INTO gdf_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Wirva ude takaɗgana da bara bǝgud, ude gatgana da gǝmadu gǝm, tsuguna ude dughgwan ad ghay gud da ngurara ngurud. ");
INSERT INTO gdf_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","War ǝn tǝb tsǝkur, kur dadakh, da ka ɗauga zǝr sar ad dǝg zu, ka baran ad kuri? ");
INSERT INTO gdf_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Awana da takaɗga zǝr ad kilf, ka baran ad bubi? ");
INSERT INTO gdf_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Da kure kǝladakha tsa tsǝkur bara dǝgakhe khwarkhwaran kǝ zarur, ngǝɗukw Dadure ǝn gharazhigǝl, afke da bǝdu bǝg ad dǝg khwarkhwaran kǝ udakhe takaɗgan ǝn vak sar. ");
INSERT INTO gdf_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ɗaga dǝge ǝn nagh kur mana kura mana kǝ udakh ka manatǝra mana ghǝrur, wirva yan dǝge ǝn tuku ndzikha ndzikh Mus zǝ tsagdutsaga tlayangakh Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Damaks ǝn tǝ dlikhwan na kǝ rang, wirva rangena bang, ɗul daksa tsuguna bang daks da kar. Liye ǝn daks ǝn tǝf tsuguna zikǝn itar. ");
INSERT INTO gdf_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Wirva rang da tǝ ɗul mbǝladu safa kǝ ngǝɗa dlikhw, ɗulen tsuguna dlikhw. Liye ǝn gatars kǝ ɗulen tsuguna na itar zikǝn bi. ");
INSERT INTO gdf_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Tsukwamana ghǝr dǝ tlayang filfilakh liye sakhasaks da vakura ǝn jakva tuwaghakh, ǝn khuɗ tara ndǝk khǝda tǝghalagh itar liye mbatǝra way. ");
INSERT INTO gdf_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Da katltǝr ǝn tǝ ɗule manda itar tlǝr kur. Ən mbǝlo mbǝlakh zǝr inabi ǝn tǝ ǝmdaga? Awana zǝr ghǝdiv ǝn tǝ dzadzǝfa? ");
INSERT INTO gdf_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ndǝkyan itsera kǝ ufa khwaran ǝn yig zǝr khwaran, ufe bǝzan tsuguna ǝn yig zǝr bǝzan. ");
INSERT INTO gdf_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Ufa khwaran naba da yig zǝr bǝzan bi, ndǝkyan ufa bǝzan tsugun, na ba da yig zǝr khwaran bi. ");
INSERT INTO gdf_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Ɗeghwa ufe kwar nǝg ǝn yig zǝr khwaran, da ǝntlars ǝntlud tlǝvdagh ud da kar. ");
INSERT INTO gdf_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Wirva yan, da tsa diwa vak man tlǝr tar kur ad tlayang filakh. ");
INSERT INTO gdf_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Daghan ba ude ǝn ɗakh ka dǝ Dadzikan, Dadzikan da daks da tlǝksa gharazhigǝl bi. Kwa ude a manga dǝge nagha Dadare ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Ai fitsa Taka lava, zikǝn udakhai da kwara ka kwarne Dadzikan, Dadzikan, tsa kwarga bakh kǝnda lave da dzaughǝr ǝn tǝvuk dǝ ɗakhagha? A lakwdu bakh kǝnda shaɗan ǝn ɗakhagha? A manga bakh kǝnda tlǝrakh dǝg japǝr ǝn ɗakhagha? ");
INSERT INTO gdf_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ka da kwara tǝra kwara ka kwarne, ǝn tsa kura ba ka lingling bi. Tsiyam tsiyan ǝn vakar, kuram li man kǝlad. ");
INSERT INTO gdf_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Wirva yan, ɗeghwa ude a tsǝnga lavaran, mangan tsugun ad tlǝr din, da ndǝk ude kwelemlem ai khǝga fǝtasar ǝn tǝ fǝraɗ. ");
INSERT INTO gdf_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Tǝɗga kǝ yu, ka saudagh rǝkhagw, ka tsiyawo fuɗ sǝgo ka tlǝg mǝghen, a mbǝdga ba tsugun bi, wirva a ndǝravǝn ǝn fǝraɗ. ");
INSERT INTO gdf_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Ɗeghwa ude tsǝna lavaran tsugun kalwala kǝ manaman, da ndǝk dlage ndǝrga fǝtasar ǝn zagh. ");
INSERT INTO gdf_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Tǝɗga kǝ yu, ka saudagh rǝkhagw, ka tsiyawo fuɗ sǝgo ka tlǝg mǝghen, ka mbǝɗgan kwashang kwashang. ");
INSERT INTO gdf_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Audzala kǝ Yasu ǝn kwarakh dǝgakhan, ka ndawatǝref tsagdu lavsar na kǝ dzakhava udakh, ");
INSERT INTO gdf_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","a tsagatǝrdu ba ndǝk li tsagdu ndzikha ndzikh bi, wirva tsagatǝru ndǝk ude nǝg dǝ ndzǝɗa tsagdu lav. ");
INSERT INTO gdf_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Saudagh kǝ Yasu ǝn tǝ bǝɗar, ka gatars udakh zikǝn. ");
INSERT INTO gdf_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Ka sa dadak madagwilf da tǝvuk sar, kǝlgan ad juguv ka ni, “Dadzikan, da khayanǝfkh tǝkhaha kǝ mbaku fidigiɗ.” ");
INSERT INTO gdf_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Ka talal Yasu ad dǝv sar ka gǝman ad uden, ka ni, “A khayanǝf kǝ, mbumbǝg fidigiɗ.” Ən tǝvin tǝvin ka mbu ǝn tuk fich. ");
INSERT INTO gdf_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ka nǝv Yasu tsin, “Tsǝna, kwarara ba kǝ itsawar ad dǝge dzaughǝr bi, dǝg da mǝdlara ghǝragh kǝ zil kǝs, bǝdu kha dǝg zaɓa tlatlǝɓ ndǝk vai kwarga ndzikha ndzikh Mus niya. Manga mana ndǝkyan, ki da mǝdla kwarne a mbukha kǝ dlam.” ");
INSERT INTO gdf_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Da kǝ Yasu da Kafarnakhum, ka sasǝg kǝ mal ya tlujiyakh da waksar kǝ takaɗa kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Dadzikan, zǝr tlǝrar ǝn khǝngan ǝn mǝgh, ǝmtsan tlapǝl vǝgh tsin, ǝn khǝɓ dlaɗ char.” ");
INSERT INTO gdf_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Ka nǝv Yasu tsin, “Da dǝgal ka da mbambǝg.” ");
INSERT INTO gdf_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Ka ngawar khai mal ya tlujiyakh kwarne, “Dadzikan, ǝn tlala ba ka kǝ saks tsǝkha da fǝtara bi. Uk lava da kwarga kha, da mbǝga dad tlǝrar. ");
INSERT INTO gdf_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Wirva ka dǝ ghǝrara ǝn kuskǝ ud kǝ, tsuguna nǝg tlujiyakh ǝn kustsǝk, tǝkhaka kǝ kwarar khai kin, ‘Dǝg dǝgal,’ ka dǝgal, da ka nika kǝ tlǝrna tsugun, ‘Saw,’ ka saks, da ka nika kǝ zǝr tlǝrar, ‘Mana dǝ yan kǝ digit,’ ka mana man.” ");
INSERT INTO gdf_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Tsǝna kǝ Yasu ndǝk yan ka ndawak ni, ka niya kǝ liye gatars gat, “Jir ǝn kwara kura kǝ, ǝn khuɗ kǝ ya Izrail a nǝgha ba ka dadak fadǝghǝro fǝg dǝ ndzǝɗa ndǝk ina bi. ");
INSERT INTO gdf_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Ən kwara kura kwara kǝ, zikǝn li kwal Izrailakh da sǝgo ǝn mbǝrt kǝs zǝ ǝn tǝvak ghǝr, ki da ndzakhgan tsitar zǝ Brakhim zǝ Ishaku zǝ Yakub ǝn tǝ vak khwaɗga ǝn tlǝksa gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Liye tsa itar ǝn khaitǝra giɗǝn tlǝksa Yazhigǝl, itar udakhe da tlǝv tǝr dagh ud da nikan na kǝ gurtl, vake da tuwa itar da kǝrɗ tliɗ.” ");
INSERT INTO gdf_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Ka nǝv Yasu kǝ mal ya tlujiyakh, “Dǝg dǝgal, wirva fadǝghǝro fǝgagh da mana kha manud.” Ən dǝvǝn dǝva ka mbu zǝr man tlǝr saren. ");
INSERT INTO gdf_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Da kǝ Yasu da fǝta Bitrus, ka nǝghan ad bab nus Bitrus magulaɓ ǝn ndzikǝn ǝn khǝngan. ");
INSERT INTO gdf_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Ka gǝman ad dǝv sar, ka mbu ǝn tuk magulaɓ. Ka tsifa tarkhe ad dǝgzu. ");
INSERT INTO gdf_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ɓǝlga kǝ khagwa, Ka ɓardǝghǝr udakh ad liye kǝɗtǝr shatan kǝ Yasu zikǝn, uk lava dǝ ghay kalti a kwarga Yasu, ka dzadal ad sǝɗikw bǝzan ǝn vǝgh tsitar, ka mbakhandu tsugun ad liye kwal yanga daghan. ");
INSERT INTO gdf_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","A mangan ad ina kǝ righada dǝge tsa kwarga Ishay tlayang kwarne, “In dǝ ghǝr sar kǝ ɓǝf ad kuɗ lapi mar. Ka ɓakiyamghǝr ad kuzakh mar.” ");
INSERT INTO gdf_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Vazga kǝ Yasuwa tsarghǝr dzakhava udakh zikǝna, ka kwarar khai kǝ furakh sar kǝ zǝghva dǝgal da tǝ yan kǝ ghǝdzǝva gadzak dǝlva Urdun. ");
INSERT INTO gdf_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Ka saks kǝ dadak tsagdu ndzikha ndzikh Mus da vak sar kǝ kwarara kwara kwarne, “Malǝma, da gatakhs gata ka tsa da makh.” ");
INSERT INTO gdf_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Ka nǝv Yasu tsin, “Uvakha nǝg fikakh tar, ɗikakhe pǝdlǝn gharazhigǝl tsuguna nǝg itar dǝ fǝtakha tar. Ai Zǝr Uda, na ba dǝ vake da bǝg din ghǝr sar bi.” ");
INSERT INTO gdf_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Ka nǝv tlǝrna fur sar tsin, “Dadzikan, ka daks da khǝɗana dadara ndan.” ");
INSERT INTO gdf_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","“Gataks gat, khǝɗa khǝɗa tlamtsakh ad tlamtsakh tar.” Nǝv Yasu tsin. ");
INSERT INTO gdf_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Da kǝ Yasu zǝ furakh sar da peryuwa ka dǝgal tsitar. ");
INSERT INTO gdf_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Ka sugo kǝ zikan kǝ kalangas ǝn tǝghǝr kǝ dǝlv, ka farsa daks kǝ ghǝɗkuta yu ǝn dǝlv da peryu. Yasu tsuguna ǝn khǝn khar. ");
INSERT INTO gdf_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Ka dǝgal tsitar da tsiya tsiya kǝ kwarara kwara kwarne, “Dadzikan, Katkiyam kat, da ruwa kiyam.” ");
INSERT INTO gdf_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ka niya tsitar, “Uɗa lava tsǝkur ǝn gǝdza ndikini? Kuram li khǝtsa fadǝghǝrofǝg.” Ka tsif, tavarghǝr ad di kǝ fuɗǝn zǝ dǝlv, ka ɗiw vake. ");
INSERT INTO gdf_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Ka ndawatrǝf kǝ udakh, avitar, “Khulf ira kǝ ud ini? Zǝva fuɗa zǝ dǝlv ǝn tsǝnaru tsǝni?” ");
INSERT INTO gdf_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Dala kǝ Yasu da tǝ yan kǝ ghǝdzǝva gadzak ǝn tǝ khay kǝs ya Gadarakh, ka sawala ud mits li dǝ sǝɗikw bǝzan ǝn giɗe ngitl, ka gamgitar zin. Na ude dlǝn tǝkha kǝ dal ǝn tǝ yanen kǝ ɗul bi. Wirva nagh bakha jaga tsitar bi. ");
INSERT INTO gdf_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","Tǝvin tǝvina ka khula tsitar kwarne, “Zǝr Yazhigǝl uɗa ɗangwa tsǝkha dǝ kǝndǝndi? A sa da bakǝnda dlaɗ nagh kha dla sart kwal sagha?” ");
INSERT INTO gdf_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ən tǝvuk khǝɗikǝna, nǝg li zighw giɗa dagu. ");
INSERT INTO gdf_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Ka takaɗga sǝɗikw bǝzana khen ad Yasu kwarne, “Da lakundalakh, ka khayakǝndanǝfkh daks da daguwa khan.” ");
INSERT INTO gdf_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Ka niya tsitar, “Iyo, damdǝg.” Ka dǝgala itar, da itar da daguwen. Ka tsiyif giɗa ya daguwen daghan kujaɗkujaɗ, ka ɗaɗara itar dǝga dagh da dǝlv, ruga itar ǝn yu. ");
INSERT INTO gdf_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Ka khwaya kǝ li zighw daguwen, daks da khuɗkǝs ka kwardu lav itar, ǝnt dǝge dzaughǝr dǝ liye dǝ sǝɗikw bǝzan. ");
INSERT INTO gdf_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Ka sawal udakh ǝn khuɗkǝs daghan kǝ gama zǝ Yasu. Nǝgha tsitara, ka takaɗga itar kǝ ɗuwatǝr da kǝs tar tsin. ");
INSERT INTO gdf_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Ka dagh Yasu da peryu, ka darghǝr kǝ dǝlven kǝ daks da kǝs ai ɗakdin. ");
INSERT INTO gdf_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Sa tsitar da khuɗkǝs ka ɓardǝghǝr yakhaya kǝ udakh ad dadak mǝtsa tlapel vǝgh ǝn khǝngan ǝnt khindz. Katlga kǝ Yasu ad fadǝghǝro fǝga tar, ka niya kǝ dadak mǝtsa tlapel vǝghen, “Ndiɗ biya zǝrara, a ɓisakhanud khaipagh.” ");
INSERT INTO gdf_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Tsǝna tsitar yana, ka nǝv chalǝm li tsagdu ndzikha ndzikh Mus ǝn tǝb tar, “Ina kǝ uda ǝn nena Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Tsa kǝ Yasu ad dǝge ǝn ɗaya itar ghǝr ǝn tǝf, ka niya tsitar, “Uɗa lava tsukur ǝn dzam dǝge ghwaɗghwaɗan ǝn rǝvur ndǝk ini? ");
INSERT INTO gdf_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ira ngulman ra, ‘A ɓisakhanud khaipakhagha nagha,’ awana, ‘Tsiya dǝg dǝgal khi’? ");
INSERT INTO gdf_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Ai ǝn na ka tsatsǝg tsukur kwarne, ka Zer Ud nǝg ka dǝ ndzǝɗ ǝn lard na kǝ ɓisa khaipakh.” Ka niya kǝ dadak mǝtsa tlapel vǝgh, “Tsiyǝf tsiy, ɓa khindza daks da mǝgh.” ");
INSERT INTO gdf_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Tǝvin tǝvina, ka tsiyif udanena ka daks tsin da fǝta sar. ");
INSERT INTO gdf_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Vazga kǝ dzakhava udakha ndǝkyana ka gǝdzǝf itar, ka ɗabanǝf itar Yazhigǝle bara khulfina kǝ ndzǝɗa kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Ɗuwars kǝ Yasu ad vaken, madǝvin ǝn zu vuk dǝ dǝg, ka nǝghan ad udanen ai ɗakhud dǝ Matiyu, ǝn ndzǝgan tǝvak chau khadam, ka nǝv Yasu tsin, “gataks gat.” Ka tsiyifa gatars. ");
INSERT INTO gdf_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Ən tǝ khal kǝ yan, madǝv Yasu ǝn zu kaf ǝn fata Matiyu, ka saks li chau khadam zǝ li khaipakh zikǝn saks da vak sar ndzakhga itar kǝ zu kaf dagha zǝ furakh sar. ");
INSERT INTO gdf_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Nǝgha kǝ Farisakh ndǝkyan, ka nǝv itar kǝ furakh sar, “Uɗa lava kǝ malǝmura ǝn zu kaf zǝ li chau khadam zǝ li khaipakhi?” ");
INSERT INTO gdf_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Tsǝna kǝ Yasu dina ka ni, “Na li lapi ǝn gat dadak ngura bi, uk liye kwal yang. ");
INSERT INTO gdf_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Dam da tsag dǝge ǝn tuku lavan, ‘Kwiɗkwirva ǝn nak ǝn vakur, dǝg tsufa bi.’ A sau kǝ ɗakh liye man dǝge ǝn nagha Yazhigǝl ba ka bi, a sau kǝ ɗakh li man khaip kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Fitsa tlǝrna, ka sasǝg kǝ zar ɓǝlakh Yukhan dadak para ud da vak Yasu, ka nǝv itar tsin, “A manga ndar kǝnda zǝ Fariskha ǝn zǝɓ ndǝla, zar ɓǝlagha na ba itar ǝn zǝɓ ndǝl biyi?” ");
INSERT INTO gdf_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ka ngawa tǝrkhai Yasu kwarne, “Da manawa ndar bazdu rǝv kǝ tsaghwakh zil ghaula, dlaitar dagha zǝ zil ghauli? Ən saks sarte da ɓatǝrvalud ad zǝ zil ghaul. Da zǝɓ ǝn tǝ sarta yan itar ndǝl. ");
INSERT INTO gdf_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Na ude da ndzǝgharu wilwa lǝgwit kǝ mughura gabag bi, wirva vak ndzǝghena da takwalva, kukha sar tsuguna da mala mala ad ai tsa chak. ");
INSERT INTO gdf_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Na ude da ɗi wilwa yu inabi da mughura mbǝl vigh bi. Itsa ka ɗidaghud, da chaɓa mbǝl vighen, ka da ɗiya yu inabi, mbǝl vighen tsuguna da baz, azǝgha ɗaidagh ud ad wilwa yu inabi da wilwa mbǝl vigh. Wirva yana nabe da bǝghalud ǝmb bi.” ");
INSERT INTO gdf_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ən tǝghǝr kǝ kwara tǝra yan kǝ lava Yasu ma, ka sasǝg kǝ mal ǝn tǝghǝr kǝ gud dzakhava Yakhudakh, ka kǝlgan ad juguv ǝn tǝvuk sar ka ni, “Amtsǝga dughwar a zulava bi, ausǝg da bo dǝv ǝn tǝf da tsi” ");
INSERT INTO gdf_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Ka tsiyif Yasu zǝ furakh sar, ka gatars itar kǝ udanen. ");
INSERT INTO gdf_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ka nǝg tlǝrna nus ai manga vǝg kǝlatǝm mits ǝn tukw kuza kǝl vizh, ka sagh du ligsar ka gǝman ad ghay gabag sar. ");
INSERT INTO gdf_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","Ni ǝn rǝvakhud sar, “Da gǝma ka itsa gabag sar da mbǝga kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Gwifkhai kǝ Yasu ka nǝghan, ka ni, “Ndiɗ biya dughwara. Fadǝghǝro fǝgagha kǝ mbakhu.” Ən tǝvin tǝvin ka mbu nusen. ");
INSERT INTO gdf_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Sa kǝ Yasu da fǝta mal ǝn tǝghǝr kǝ gud dzakhava Yakhudakh, ka nǝgha nǝgha tsin liye fǝg fakil zǝ dzakhava udakh ǝn kwara kava ghay sikh sikh sikh. ");
INSERT INTO gdf_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Ka ni, “Tsiyam tsiyǝn van. Amtsǝga ba dughuna bi, ǝn khǝn khara sar.” Ka nenanef itar dǝ ghǝɓas. ");
INSERT INTO gdf_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Ai lakwtǝrdal tsud da mel, ka dagh khutanan ad dǝva dughwen, ka tsiyif. ");
INSERT INTO gdf_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","A kwazga laven itsa dǝvar ǝn kǝsen. ");
INSERT INTO gdf_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Ba Yasu ǝn ɗuda vaken ma, ka gatars ngulfakh mits ǝn ɗakha itar dǝ ndzǝɗa kwarne, “Zǝr Doda ziwa kǝndal ziwa.” ");
INSERT INTO gdf_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Da kǝ Yasu da mǝgha ka sagh ngulfakhen da vak sar, ka niya tsitsar, “A fadǝghǝro nagh kur kwarne tǝkhaka kǝ mbakuruwa?” Ka nǝv itar, “Aa, tǝkha kha Dadzikan.” ");
INSERT INTO gdf_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Tǝkhal kǝ yana ka gǝman ad diyakh tar ka ni, “Ən tǝ dǝva dǝ fadǝghǝro fǝgura da mbakura mbǝgud.” ");
INSERT INTO gdf_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ka ngwarǝf diyakh tar. Ka tǝkhatǝrna Yasu char kwarne, “Kwara mara ba kǝ itsawar ad ina kǝ digit bi.” ");
INSERT INTO gdf_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Ai dala tsitar, ka kwazdu itar ad lava itsa dǝvar ǝn kǝsen. ");
INSERT INTO gdf_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Madǝv itar dǝgal, ka ɓardǝghǝrud ad ude kwal tǝkha kǝ kwarga lav, dadake dǝ sǝɗikw bǝzan ǝn vǝgh sar. ");
INSERT INTO gdf_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Lakwadal tsud sǝɗikw bǝzanen, ine tsa kwar tǝkha kǝ kwarga lav ka farsa kwar lav. A ndawatrǝf kǝ dzakhava udakh ka nǝv itar, “Tsa tapa bud nǝgha khulfinak digit ǝn khaya ya Izrail bi.” ");
INSERT INTO gdf_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ai ka nǝv Farisakh, “Afke ǝn zaɓado dǝ ndzǝɗa zikan na kǝ mal ya wurdu ad sǝɗikw bǝzanena.” ");
INSERT INTO gdf_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","A dakhal Yasu da kǝsakh daghan zǝ gǝdzar kǝsakh, ǝn tsagdu tsag ǝn gud dzakhava Yakhudakh, ǝn tlǝkhdu lav zǝɗan ai tǝghǝr kǝ tlǝksa Yazhigǝl, tsuguna ǝn mbakha udakh zikǝn, zǝ itsera kǝ khulf kuzakh zǝ li kuɗ lapi. ");
INSERT INTO gdf_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","“Nǝgha tsin udakh a dzavkhai zikǝn, ka kwiɗ nǝv rǝv tsin, wirva ǝn khǝɓ dlaɗ itar na ude ǝn mǝlatǝru mǝla bi, ngwaɗa tuwaghakh itar kwal nǝg kǝ dadak zighwtǝr zighw.” ");
INSERT INTO gdf_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","“Ka niya kǝ furakh sar, zikǝn tsǝg khi, li man tlǝr tsuguna khǝɗikǝn. ");
INSERT INTO gdf_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Wirva yan, takaɗam takaɗa Dadzikan dadake nǝgharu kǝ tlǝr gukhen, kǝ ɓǝlondagh li man tlǝr kǝ tsara khi.” ");
INSERT INTO gdf_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ka ɗakhga Yasu ad furakh sar kǝlatǝm mits, a batǝran ad ndzǝɗa lakdu itsǝra kǝ siɗikw bǝzan, zǝ mbakha itsera kǝ khulf kuz zǝ liye kwal yan. ");
INSERT INTO gdf_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Auna ɗakhakh dzǝran na kǝ furakh na kǝlatǝm mits. Dǝg chaka, Siman ai ɗakhdud Bitrus zǝ zǝrbab sar Ndros, Yakub zǝr Zabadi zǝ zǝrbab sar Yukhan, ");
INSERT INTO gdf_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibus, Bartamawus, Tom, Matiyu dadak chaw khadam, Yakub zǝr Alf, Tladdiyus, ");
INSERT INTO gdf_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Siman ud ya Kanan, Yakhud Iskariyoti dadake bǝdu Yasu kǝ kǝɗgakǝɗ. ");
INSERT INTO gdf_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","A ɓǝlatǝrǝf Yasu kǝ dzǝrana kǝ zar ɓǝlakh kǝlatǝm mits, ka tǝkhatǝrna ad lava kwarne, “Damba da vak liye kwal Yakhudakh bi, tsuguna damba da tlǝrna kǝs ya Samariyakh bi, ");
INSERT INTO gdf_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","dam da vak udakh ya Izrail liye zaɗgan ndǝk tuwaghakh. ");
INSERT INTO gdf_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Madǝv kur ǝn dǝgal, kwaramatǝra lav Yazhigǝl kwarne, ‘Tlǝksa Ghǝrazhigǝla a khǝrzǝgan.’ ");
INSERT INTO gdf_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbakhama liye kwal yang, tsiyanǝf kur liye amtsǝgan, mbakhanu kur liye ǝn tukw fich, lakwakh du kur sǝɗikw bǝzanakh ǝn vǝgh kǝ udakh. A bakura butiyud, bǝdu ghǝrura buti. ");
INSERT INTO gdf_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Ɓam ba kwaɓ dawan zǝ shabu zǝ jingal ǝn mbǝlur bi. ");
INSERT INTO gdf_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Ɓam ba jilaɗur bi, tsa zǝ gabag mits bi, tsa kimbak, ɓam ba tsa juguljugulur bi, wirva dadak tlǝra kalkal gǝmadu dǝg siga tlǝr sar tsin. ");
INSERT INTO gdf_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“Itsera kǝ kǝs zǝ gǝdzar kǝsakhe a da kur damb, gatam ga ud charan ai da giɗa kur dagh tangw da da tǝ sarte da tsida kur. ");
INSERT INTO gdf_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Da ka da kur da mǝghen, ka nǝghatǝrdi kur kwarne, ‘gabǝr ǝn tǝghǝr tsǝkur.’ ");
INSERT INTO gdf_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Da ka chau kurkhai liye mǝghen, tsukwa gabǝruren ǝn tǝghǝr tsitar, ai da chau kurkhai ba itar bi, ka wura kurva gabǝrur. ");
INSERT INTO gdf_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Ɗaga mǝgha zǝ kǝse kwal chau kurkhai, awa bi kalwal kǝ tsǝn lavur, pangdu kur lagwate ǝn tǝ sigur dǝn sǝgawala kur ǝn kǝsen. ");
INSERT INTO gdf_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Kaɗi ǝn tǝkha kura kǝ, da ziwardal kǝ Sodom zǝ Gomora ud tǝghǝr kǝ kǝsen fitsa takalav.” ");
INSERT INTO gdf_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Ya digiyam, ya ni ɓǝla kura ɓǝla ka ngwaɗa tuwaghakh ǝn tatak ya ghǝda tǝghalakh, wirva yan ɗemekh ni kur ndǝk dǝg vukhakh, tsugun kalali nikur ndǝk kakur. ");
INSERT INTO gdf_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Tsukamana ghǝr kǝ udakh, wirva da lang kur langa itar da vak takalav, tsuguna da dlagha kuru kiɓ itar ǝn gud dzakhavakh tar. ");
INSERT INTO gdf_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Wirvǝn gataks tsǝka kur, da lang kur lang itar da tǝvuk kǝ li man tlǝks ǝn tǝghǝr kǝ tsǝkur zǝ shikakh, wirva ki da kwardu lav zǝɗan tsǝkur ǝn tǝvuk tar zǝn tǝvuk liye kwal Yakhudakh. ");
INSERT INTO gdf_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Da ka da zǝɓ kurdǝghǝr itar da tǝvuk li taka lav, dzamam ba dǝ dǝge da kwara kur bi biya da kwara ndar kur bi. Ən tǝ yanen kǝ sart da bakura bǝg ka dǝ lave da kwara kur. ");
INSERT INTO gdf_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Wirva kuram ba da kwar laven bi, wirva Sǝɗikw Chuwaɗaɗan Dadure ǝn kur, in da kwarado lava sǝgawal ǝn ghayur. ");
INSERT INTO gdf_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Zǝrbab da bǝdu zǝrbab sar kǝ kǝɗa kǝɗa tsud, dad tsuguna da bǝdu ad zǝr sar, zara tsuguna da tsiyara kǝ baba zǝ dad itar, zǝ man dǝgakhai da nala kǝ dlǝva ɗul ǝmtsa tar. ");
INSERT INTO gdf_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Itsawara da nagh kur ba wirva ka bi. Ude bǝga rǝv tangw da tǝ mbasa sar da katakatud. ");
INSERT INTO gdf_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Da ka bakura dlaɗud ǝn mbiyan kǝ kǝs, ka kwaya kur da tlǝrna kǝs, ya kaɗiyǝn ǝn kwara kura kǝ, kǝda ditla ɗaga kǝs ya Izrail tsǝkur, da sosǝg ka Zǝr Ud. ");
INSERT INTO gdf_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Na dadake ǝn tsag digit da mal dadak ai ǝn tsagardu tsaga bi, awana zǝr tlǝre malga dad mǝgh sar bi. ");
INSERT INTO gdf_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Da ka tlakǝnalin kǝ dadak tsag lava kǝ nǝga ndǝk dadak tsagdu lav, zǝr tlǝr tsuguna ndǝk dad mǝghsar. Da ka mal ya wurdu kha nǝv itar kǝ dad mǝghena, da ɗakha dǝ uɗitar ad yakhsari? ");
INSERT INTO gdf_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Wirva yan, gǝdzamtǝr bi, wirva na dǝge khǝmban ai kwal da mǝdlandowal tsud bi, tsuguna na dǝge ɓǝghan kwal da tsatsud bi. ");
INSERT INTO gdf_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Dǝge ǝn kwara kura kǝ ǝn gurtl, kwaram kwar ǝn tǝ fatsi tǝghǝr. Dǝge kwarakh dagh ud da tlim, tlǝkhamdu tlǝkhǝn tǝ mbachar. ");
INSERT INTO gdf_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Gǝdzam ba dǝ liye tǝkha kǝ kǝɗga vǝghur bi, ya tǝkh ba itar kǝ kǝɗga saf bi. Gǝdzam gǝdza Yazhigǝl ai tǝkh kǝ kǝɗga vǝgha zǝ saf tangw da tǝ fay. ");
INSERT INTO gdf_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Mits bakh chughwaghwakh ǝn sukwduwud ǝn tǝ shabu kitakula? Na bai da ɓǝlal itsa kitakul da khay ai kwal da tsa kǝ dadur bi. ");
INSERT INTO gdf_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Afke itsa guj ghǝrura kǝdlana. ");
INSERT INTO gdf_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Wirva yana, gǝdzam bi. Afke a malga kur ad chughwaghwakh zikǝn kǝ ndanga char. ");
INSERT INTO gdf_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Ɗaga ude mǝdla kwarne dǝg sar kǝ ǝn tǝvuk kǝ udakh, ghǝrar tsuguna da mǝdla mǝdla ka kwarne dǝgar ghǝrsar ǝn tǝvuk Dadare ǝn ghǝrazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Ɗaga ude bǝga tsuguwar ǝn tǝvuk kǝ udakh, ghǝrar tsuguna da bǝg tsugu kǝn tǝvuk kǝ Dadare ǝn ghǝrazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","Dzamam ba kwarne gabǝr a ɓadagh ka da lard bi. A so kǝ wirva ɓado gabǝr ba ka bi, ya katsakar. ");
INSERT INTO gdf_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ya so kǝ, Wusha zǝra zǝ dad sar. Dugh zǝ bab sar tsǝgun. Ghawul tsuguna zǝ dzik sar nus. ");
INSERT INTO gdf_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Dadak mǝgha yakh sar da nǝga kǝ tlǝghum sar. ");
INSERT INTO gdf_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Ude ǝn way bab sar zǝ dad sar mal tsǝk, a tlal ba kǝ nǝga kǝ zǝr ɓǝlara bi. Ude ǝn way zǝr sar awana dugh sar mal tsǝka tsugun, a tlal ba kǝ nǝga kǝ zǝr ɓǝlara bi. ");
INSERT INTO gdf_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ude ɓǝf ba dǝ ufa khǝrta sar kǝ gataks gata bi, a tlal ba kǝ nǝga kǝ zǝr ɓǝlara bi. ");
INSERT INTO gdf_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Ude ǝn nagh kat safa sar, da bǝgh. Ude kǝɗdu safa sar wirva kǝ, da gǝmadu gǝm. ");
INSERT INTO gdf_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Ɗaga ude a chau kurkhai, ka chau ka yin, ude chau kai tsuguna Dade ɓǝlakondagh a chau gin. ");
INSERT INTO gdf_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Ɗaga ude chauga tlayang Yazhigǝl da chauga kǝ wirve tlayangin. Dǝg sige da baruda, da kalkal zǝ dǝg tlayangen. Ɗaga ude chauga dadak kalali da chauga kǝ wirve dadak kalali yin, dǝg sige da baruda da kalkal zǝ dǝg dadak kalaliyen. ");
INSERT INTO gdf_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Ɗaga ude ǝnkaru itsa kwat yu kitakul ak khǝɗikan ǝn tatak furar wirve furarin, ya jir ǝn kwara kura kǝ, na ba da bǝghǝn dǝg sig sar bi. ");
INSERT INTO gdf_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Udzala kǝ Yasu ǝn tǝkhatǝra lava kǝ furakh sar kǝlatǝm mits, ka ɗuwars ad yanen kǝ vak, tsuguna ka dǝgal tsin da tsagatǝrdu tsaga zǝ tlǝkhatǝra lav Yazhigǝl kǝ dlǝmdla kǝsakhe khǝrza dǝ yanen kǝ kǝs. ");
INSERT INTO gdf_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Tsǝna kǝ Yukhan dadak para ud ǝn zaw ad dǝgakhe tsǝn mana Kristu, ka ɓǝlandal ad chalǝm Zar ɓǝlakh sar da vak sar. ");
INSERT INTO gdf_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Nǝv itar kǝ Yasu, “Kwara kǝnkhe kwar,” “Kha naghek dadake tsǝn kwara Yukhan dadak para ud da sǝgdagh na, nagha da gwit tlǝrna ud sikha khǝkǝndi?” ");
INSERT INTO gdf_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Nǝv Yasu tsitar, “Damaks da kwarara kwara kǝ Yukhan ad dǝge tsǝna kur zǝ dǝge nǝgha kur. ");
INSERT INTO gdf_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Ngulfakha a ngwarǝf di tsitar, ǝn dǝga ghwurɗikakha, li kuza fǝcha a mbakharu fidgiɗ, ǝn tsǝnatsǝna tǝngakh, a gwidǝn tsaya tǝrǝfud kǝ li tsa amtsǝgan, ka kwaratǝra lav zǝɗan ud kǝ talagakh. ");
INSERT INTO gdf_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Dadak bark liye kwal guyakdu lig wirva dǝge ǝn mana kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Madv zar bǝla Yukhan ǝn daks, ka farsa Yasu kwara tǝra lava kǝ udakh ǝn tǝghǝr kǝ Yukhan kwarne, “Dala tsǝkur da vak Yukhan ǝn tǝghal, da kuram ǝn kurana wuɗa tsǝn nakur nǝgha nǝghi? A dal da vaz tsǝɓ tsǝɓan kǝ mase ǝn kaɗa fuɗ nagh kur? ");
INSERT INTO gdf_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Tsa dal da vaz uɗa kuri? Ude chaɗfkhai ǝn kadlang khwaran naghf kur? Liye chaɗfkhai ndǝkyana ǝn gidǝn tǝ gǝlvakh shikakh itar fǝka. ");
INSERT INTO gdf_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Kwara make kwar, tsa dal da vaz uɗa kuri? Tlayang nagha? Ndǝk yanen, ai tsuguna a nǝgha tsǝkur dadake a malgan ad Tlayang. ");
INSERT INTO gdf_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Tsa Yukhan dadake tsa vindzava lav ǝn tǝghǝr tsin ǝn kaɗkaɗ kwarne, “ ‘Da ɓǝlaɓǝla ka ad zǝr ɓǝlara kǝ dakho ǝn tǝ vuk. Dadake da ɗikakha ɗul.’ ");
INSERT INTO gdf_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Ən tekha kura tǝkha kǝ, na nuse taɓa yig zǝr ai do da tǝ Yukhan dadak para ud dǝ ndanga bi. Ai tsugun, dadake khǝɗikan ǝn tlǝksa gharazhigǝla a malgan ad Yukhan kǝ ndang. ");
INSERT INTO gdf_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Tsif ǝnt sarte tsa kwardu Yukhan dadak para ud ad lav Yazhigǝl tangw da tina kǝ sart. A wushif ghǝr kǝ tlǝksa gharazhigǝl, li tsiyara mǝkǝn kǝ udakha ǝn nagh pǝrd tlǝksa Yazhigǝl itar dǝ ndzǝɗ. ");
INSERT INTO gdf_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Lave a tsagdu nzdikha nzdikh Musa zǝ kaɗkaɗ tlayangakh daghan a kwarga itar lav ǝn tǝghǝr kǝ tlǝksen kǝda sǝgdagh kǝ Yukhan ");
INSERT INTO gdf_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Da khayanǝf kur dǝ lav tara, Yukhan ai tsǝn kwarud lavǝn teghǝra, in Ili na tsǝn kwarud da sǝgdagh. ");
INSERT INTO gdf_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Tsǝna dadak tlim ad lave kwarud. ");
INSERT INTO gdf_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Da kura dǝ war ka udakh zamani? Ghila zar mbisane ǝn giɗǝn te ɓala kasuk ǝn ɗakhva kǝ da man sakw ǝn tatak tar itar zǝ kwar lava kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","“ ‘Fakurkhe kǝnda fyakǝla. Kalwala kur kǝ tsug. Fuka kurkhai kǝnda fuk. Kalwala kur kǝ tu.’ ");
INSERT INTO gdf_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Sodagh kǝ Yukhana, tsa nabǝn zu dǝg zuwakh zǝ khǝɓ itsera kǝ digitakh bi, ‘Ka sǝɗikw wurdu ǝn vǝghtsino nǝv itar.’ ");
INSERT INTO gdf_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Wur sodagh Zer Uda, ǝn zuwa zuwa zǝ khǝɓa khǝɓ, ‘Vaza dǝ udan na. Mbǝlv zǝn ɗayuɗay, zǝ tsaghw li chau khadama zǝ li man khepo nǝv itar.’ Tlǝre ǝn mana udan in da mǝdlan ad kwalemleme a bara Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Udakhe ǝn kǝsakhe tsa manakhga Yasu ad dǝg ndawakakh ǝn kǝs tar, a kalwala itar kǝ pǝlghǝr, ka tavatǝrghǝr ad di. ");
INSERT INTO gdf_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ɗangwa tsǝkur, Korasin. Ɗangwa tsǝkur, Betsaid. Da tsa a manakhgǝn kǝs ya Taya zǝ Sidom ud ad dǝg ndawakhe a manavǝn vakur, tsa pǝlga itar ghǝr gulyan, tsa ɗaiva itar ad Ligwit ngǝz zǝ ɗaiva fǝts ǝn tǝ vǝghakh tar. ");
INSERT INTO gdf_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Ai tǝkha kura tǝkha kǝ, da ziwardala kǝ udakh ya Taya zǝ Sidon ud tǝghǝr tsǝkur fitsa man taka lav. ");
INSERT INTO gdf_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Kha tsugun Kafarnakhum, da ghǝr tsǝkhǝn kurana da ɓǝkha ɓakhud da gharazhigǝla? Əmma tsǝkhara, da kǝɗkh dagh da vak liye ǝn tǝ fayud. Da tsa mangǝn Sadom ud ad dǝg ndawakakhe tsa mangud ǝn vakur, tsa dla itar sakhkan. ");
INSERT INTO gdf_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Ai tǝkha kura tǝkha kǝ, da ziwardala kǝ udakh ya Sadom ud tǝghǝr tsǝkur fitsa man taka lav. ");
INSERT INTO gdf_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ən tǝ yanen kǝ sart a kwarga Yasu kwarne, “Ən kwara kha us ka Dada, Dadzikan dadak gharazhigǝl zǝ khay, wirva a ɓǝgharna kha dǝgakhana kǝ liye kwalemlem zǝ liye ǝn tsa lav, ka mǝdlatǝrankh kǝ zar mbisan liye kwal tsa lav. ");
INSERT INTO gdf_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Khwara Dada, wirva ndǝk yanen kǝ manakhal. ");
INSERT INTO gdf_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“A ba ka Dadar ad digitakh daghan. Na ude tsa Zǝr bi uk Dad, tsuguna na ude tsa Dad bi uk Zǝr, zǝ udakhe a naghga Zǝren tsugun ad mǝdlatǝramǝdl. ");
INSERT INTO gdf_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","“Ausǝgam da vakar, daghanure a suvgan dǝ zǝɓ kadlang ɗimɗiman, da bakura fǝtava kǝ. ");
INSERT INTO gdf_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ɓamǝf ɓa changlagara da tǝ pepur. Tsagam tsagǝn vakar, wirva ka dadak tsukwana ghǝr kǝ man digitakh kǝ, zǝ dadak gulandagh ghǝr kǝ ǝn rǝv, ka da mbǝladu mbǝla kur fǝtava kǝ ghǝrur. ");
INSERT INTO gdf_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Changlagara na ba ɗimɗim bi, kadlangara tsuguna chafchaf.” ");
INSERT INTO gdf_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ən sartena a dala Yasu dǝgal diwa gukh ǝlkam fitsa fǝtava Yakhudakh. Ndzitǝrǝf kǝ wai kǝ furakh sar, ka farsa itar ad sǝɗ khi ǝlkam kǝ zuwazu. ");
INSERT INTO gdf_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Nǝgha kǝ Farisakh ndǝk yana, ka kwararkhe itar kǝ Yasu kwarne, “Vaz, ǝn man dǝge a gadlga ndzikh zar ɓǝlakhagh fitsa fǝtava Yakhudakh.” ");
INSERT INTO gdf_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Ka nev Yasu tsitar, “A tugwa bakh kur ad dǝge manga Dod mbatǝra kǝ wai zǝ li dǝgakh sara? ");
INSERT INTO gdf_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Ka da da Fǝta Yazhigǝl, ka ɓǝf itar zǝ li dǝga sar ad brudiye kwal kalkal ba zuwa zuwa tsitar bi, uk Zilkǝs kitakul da zuwan. ");
INSERT INTO gdf_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Tsa tugwa bakh kur ǝn ndzikha ndzikh Mus kwarne, Zil kǝsakhkhe ǝn Fǝta Yazhigǝla ǝn kǝla ndzikh itar fitsa fǝtav. Tsuguna a nala ba kwarne a manga itar khaip bi. ");
INSERT INTO gdf_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Tǝkha kura tǝkha kǝ, auna ude a malgan ad Fǝta Yazhigǝl kǝ ndangǝn vana khan. ");
INSERT INTO gdf_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Da tsa katlga kur dǝge ǝn kwara kaɗkaɗ, ai kwarga Yazhigǝl kwarne, ‘Giɗa kwiɗkwiɗǝrǝv ǝn na kǝ, dǝg tsufa bǝn na ka bi.’ Tsa na kur ǝn batǝrghǝr ghaza kǝ li kwal dǝ khaip bi. ");
INSERT INTO gdf_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Wirva yan ka Zǝr Ud, ka Dadmǝgh fitsa fǝtava Yakhudakh.” ");
INSERT INTO gdf_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ka ɗuwars Yasu ad yanen kǝ vaka, ka dadǝg tsin da gud dzakhava Yakhudakh. ");
INSERT INTO gdf_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Ən gud dzakhvena, nǝg udanen dadak ǝmtsa dǝv, ka ndiɗarwar itar kǝ Yasu kwarne, “A khayanǝf nagh ndzikh ad mba ud fitsa fǝtava?” Nǝv itar kǝ nǝghda mbǝladu ghaza Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Ai ka nditarwal Yasu kwarne, “Da ka nǝg ude dǝ tuwagh ǝn tatakuran, da ɓǝldaghin da fik fitsa fǝtav, atsuk na dadak tuwaghǝn da ɓado ɓa biya? ");
INSERT INTO gdf_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Afka a malga ud ad tuwagh kǝ ndanga char. Wirva yana a khayanǝf ndzikha ad mǝlaru kǝ ud fitsa fǝtav.” ");
INSERT INTO gdf_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Khalak yana ka niya kǝ dadak ǝmtsa dǝven, “Taladala dǝvagh” Ka taladal, ǝn tǝvin tǝvina ka mbu dǝva sar charang, ka nala ndǝk yan kǝ dǝv. ");
INSERT INTO gdf_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Da mbiyanen, ka dǝgal kǝ Farisakh da ɗi dzanak kǝɗ Yasu kǝ ǝmts. ");
INSERT INTO gdf_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Katlga kǝ Yasu ad rajakhadghǝr (ɗayaghǝr) tara, ka ɗudan ad yanen kǝ vak. Ka gatars gata kǝ udakh zikǝn. Ka mbakhatǝru kǝ li kwal tsa yanga daghan. ");
INSERT INTO gdf_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ka ndǝɗatǝrnǝf ad tlim kwarne, kwarara betar kǝ udakh ad lav ǝn tǝghǝr tsin bi. ");
INSERT INTO gdf_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Dǝge mangin kǝ righanǝf dǝge tsa kwarga Ishay Tlayang. Ai kwarga Ishay kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Auna zǝr tlǝre a zǝɓǝf kǝ. Ən waya waya kǝ, ai zǝɗaku zǝɗa char. Da bara bǝg ka dǝ Sǝɗikwar. Tsǝguna ka da tlǝkhdu lav ǝn tǝghǝr kǝ taka lav jir kǝ khulf udakh daghan. ");
INSERT INTO gdf_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Na ba da man tsugu zǝ bura bi. Da tsǝna bud lav sar dǝ ndzǝɗ ǝn tǝ ɗulakh ǝn khuɗ kǝs bi. ");
INSERT INTO gdf_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Mbaɗize tsa tǝrɗǝfa, naba da kǝlakǝla bi. Karakazaze tsa dǝm da ǝmtsa, naba da kǝɗakǝɗa bi. Da tǝkhavala tǝkh, akwa nǝghin ad taka lav jir a zugan ad fir. ");
INSERT INTO gdf_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Da bo ghǝr ǝn tǝ ɗakha sar udakh liye kwal tsa Yazhigǝl daghan.” ");
INSERT INTO gdf_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ka ɓardǝghǝr yakhaya kǝ udakh ad ude ngulf ai ghwirtl da vak Yasu, wirva sǝɗikw bǝzan ǝn vǝgh tsin. Ka mbanu Yasu. Ka farsan ad kwar lav, tsuguna ka nǝgha nǝgh. ");
INSERT INTO gdf_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Ka ndawatǝrǝf kǝ udakh daghan, Ka nǝv itar, “Ara, ina kuda in khǝ Zǝr Doda?” ");
INSERT INTO gdf_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Ai tsǝna kǝ Farisakh ndǝk yana ka nǝv itar, “Afka dǝ ndzǝɗa tsawar bi. Dǝ ndzǝɗa Baalzabul shik ya wurdu, ǝn zaɓakhadowin ad sǝɗikw bǝzan ǝn vǝgh kǝ udakh.” ");
INSERT INTO gdf_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Fatsiye audzala Yasu ǝn tsa dǝge ǝn ɗaya itar ǝn rǝvakhuɗ tar, ka avin tsitar, “Ɗaga tlǝkse a tǝkaghǝran mits, ǝn tlughuma itar ǝn tatak tar, yanen kǝ tlǝksa da ghitsga ba dangar bi. Ɗeghwa kǝsa zǝ mǝghe a tǝkaghǝra mits tsugun, ǝn tlughuma itar ǝn tatak tar, na ba da ghitsa bi. ");
INSERT INTO gdf_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Da ka ǝn zǝɓadal Shatan, Shatan sǝgawal ǝn udakh, afka ǝn gadla dǝ ghǝrsar. Ai da ghitsa ndar tlǝksa sari? ");
INSERT INTO gdf_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ai da ka dǝ ndzǝɗa Baalzabul ǝn zaɓado ka dǝ sǝɗikw bǝzanakh, ai zar ɓǝlakhura mi? Ən zǝɓtǝrdal dira kǝ ndzǝɗa itari? Ai furakhur da taka kura lav ǝn tǝghǝr kin. ");
INSERT INTO gdf_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Ai daka dǝ ndzǝɗa Sidikw Yazhigǝl ǝn zaɓadal ka ad shatanakh, atsuk a sa tlǝksa Yazhigǝl da tǝghǝr tsǝkur. ");
INSERT INTO gdf_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“A tǝkh bud kǝ da da khutsadala kadlang ǝn mǝgha dadak ndzǝdan bi, khekwa da ndzaɗana ghud ndan, bidǝgud ǝn tǝkha kǝ khutsadala kadlang ǝn fǝta sar. ");
INSERT INTO gdf_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Ude kwal nǝg zǝ kǝ, atsuk ǝn man tluhguma zǝ kǝ. Ude kwal mǝlaku dǝ dzakha dzakha atsuk ǝn kwazakdu kwaz. ");
INSERT INTO gdf_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Wirva yan, ǝn kwara kura kwara kǝ, da ɓisatra ɓisud kǝ udakh ad itsera kǝ khaip zǝ lav nenakh ai manga itar. Ai tsugun, ude kwarga lava dǝ nen ak Sǝɗikw Yazhigǝl, na bud da ɓisara ɓisa bi. ");
INSERT INTO gdf_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ɗaga ude kwarga lav nen ǝn tǝghǝr tsǝka Zer Ud, da ɓisara ɓisud. Ai ɗeghwa ude kwarga lav nen ak Sǝɗikw Yazhigǝl, linglinga na bud da ɓisara ɓisa tsa kǝvena tsa da tǝ kwarge da saks bi.” ");
INSERT INTO gdf_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Da nǝgharu kha kǝ uf khwaranyan zǝr khwaran da yigin. Da ka nǝgharu ba kha kǝ uf bi, zǝr bǝzan da yigin. Wirva ufa khwarana ǝn katlǝn tǝ khulf zar sar ud. ");
INSERT INTO gdf_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Kur zar ya pushakhan. Da tǝkh duɗa kur kǝ kwarga lav khwaran fatsiye nguɗiyakh kuri? Afka ǝn khuɗ kǝ dǝgakhe ǝn rǝvakhuɗ ud inǝn sǝgawal ǝn tukw ghay. ");
INSERT INTO gdf_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ud charana, ǝn zǝɓado ǝn dǝg charane ǝn khuɗ kǝ dǝg charane a bǝgin ǝn rǝvakhuɗ sar. Ud nguɗiya, ǝn zǝɓado ǝn dǝg nguɗi, ǝn khuɗ kǝ dǝg nguɗiye, a bǝgin ǝn rǝvakhuɗ sar. ");
INSERT INTO gdf_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Ən kwara kura kwara kǝ, ɗeghwa kwadlamb ghaye ǝn kwara udakh, da kwara kwara itar dǝge bǝtra da kwar yanen fitsa takalav. ");
INSERT INTO gdf_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Ən tǝ dǝva dǝ lave kwarga kha da mana khud takalav. A bakhghǝr ud ghaza awana dadake kwal dǝ ghaz. ");
INSERT INTO gdf_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ka kwararkhe yakhaya kǝ li tsagdu ndikha ndikh Mus zǝ Farisakh kwarne, “Malǝm, ǝn na kǝnda mǝdla kǝnda mǝdla tsǝkha ad zikan kǝ dǝg ndawak ai da mǝdla dakha ndzǝɗagh.” ");
INSERT INTO gdf_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Ka niya tsitar, “Udakh li kwargǝna, li kwal fadǝghǝro dǝ Yazhigǝl kur, nguɗiyakh tsugun. Nagha kur ad nǝgha dǝg ndawak ǝn vakar, ai na bud da mǝdla kura mǝdla bi, akwa ndawake ǝn tǝghǝr kǝ Yunan tlayang. ");
INSERT INTO gdf_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Ndǝkve a manga Yunan ad khǝna khǝkerɗ viɗ zǝ fatsi ǝn khuɗ kǝ zikana kǝ kilf, da mana ndǝk yan ka Zǝr Ud ad khǝna khǝkerɗ viɗa zǝ fatsi ǝn mbǝrt kǝ khay. ");
INSERT INTO gdf_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Fitsa takalav da kwara tǝra kwara udakh ya Nineba kǝ li kwargǝn kwarne, a manargan ad khaip. Wirva itar udakh ya Nineba a pǝlga itar ghǝr ǝn tǝ dǝva dǝ lav Yazhigǝle a kwaratǝrkhe Yunan. Ai tsuguna auna ude a malgan ad Yunan dǝ ndzǝɗ ǝn van. Dakhkana a pǝlga ba kur ghǝr bi. ");
INSERT INTO gdf_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Fitsa takalav, da tsiya nuse shik ǝn khay ya Sheba kǝ kwar kwarne udakh kwargǝn a manargan ad khaip. Wirva soghǝr ǝn vak bita char, kǝ tsǝn lav kwalemleme ǝn tsagdu Saluman shik. Ai tsuguna nǝg ude a malgan ad Saluman shik dǝ ndzǝɗ ǝn van.” Dakhkana a pǝlga ba kur ghǝr bi. ");
INSERT INTO gdf_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Da sawala sǝdikw bǝzan ǝn vǝgh kǝ ud, ka gwayav ǝn vakakhe kwal nǝg kǝ yu kǝ mbǝladu vak fǝtava tsin. Ai da ka mbǝladu bin bi, ");
INSERT INTO gdf_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ka ni, da gwiya daks da kwazaghare tsa sawalaka. Da gwiyoghǝrina a tlarghǝr ba kǝ itsawar bi tsuguna tleɗan, a ɗikavana mǝgh. ");
INSERT INTO gdf_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Ka da gwiya dǝgal da khutsado tlǝrna sǝɗikw bǝzanakh uɗif, liye malgan kǝ mbǝrsh. Kǝ daks tsitar kǝ giɗǝmb. Khalakyana, ka da malamala giɗa sare kǝ khal, ade tsa chak kǝ bǝz. Da dzaughǝr ndǝk yan kǝ nguɗi udakh li kwargǝn. ");
INSERT INTO gdf_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Madǝvin ǝn kwar ghay zǝ udakha, ka sasǝg kǝ bab sar zǝ zar babakh sar. Ka ghitsǝga itar ǝn mǝl, ǝn nagh kwar lava itar zin. ");
INSERT INTO gdf_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Ka nǝv tlǝrna ud tsin, “Babagha zǝ zarbabakhagh ǝn ghitsǝn mel, ǝn na kwar lava itar zǝ kha.” ");
INSERT INTO gdf_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Ka ndiɗarwal kǝ dadake tsa kwarkhe kwar, “War babara, zǝ zar babakharenra?” ");
INSERT INTO gdf_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Ka mǝdlarnan ad furakh sar dǝ dǝva ni, “Auna babara zǝ zar babakharǝn tǝ van. ");
INSERT INTO gdf_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Wirva ɗeghwa ude ǝn man dǝge ǝn nagha Dadare ǝn gharazhigǝl kǝ manaman tsin, in zǝr babara, zǝ dugh babara, zǝ babar.” ");
INSERT INTO gdf_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Fitsa vayanena, ka sawala Yasu ǝn mǝghen, dala ka nndzǝgan ǝn tǝ ghay dǝlv kǝ tsagardu kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dzakhava udakh zikǝn char tsarghǝr itar dingrik. Ka dagh da per yuwa nndzǝgan. Dzakhava udakh tsuguna ghitsga itar ǝn tǝ ghay dǝlv. ");
INSERT INTO gdf_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ka kwara tǝr khai ad lava dǝ jakva lavakh zikǝn. Ni, “Nǝg dadak gukhen a dala da kwazdu khulf ǝn gukh sar. ");
INSERT INTO gdf_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Madvin ǝn kwazdu khulfa, ka ɓalala yakhay kǝ khuf ǝn tǝ ɗul, ka sa ɗikakha vaɗu itar. ");
INSERT INTO gdf_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Ka ɓalala yakhay kǝ khulfakh ǝn tǝ fǝraɗ vake kwal nǝg khay char. Ka fǝtsawala kujaɗ kujaɗ, wirva khayen ǝn tǝvina naba zikǝn bi. ");
INSERT INTO gdf_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Tǝvga kǝ fatsiya ka ɓayif itar, ka ghulala itar, wirva a dagh ba tlǝl sar char bi. ");
INSERT INTO gdf_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Yakhaya kǝ khulfen tsuguna a ɓalardagh da vake dǝ tak, fǝtsala tsina, ka ɗakalar zǝ tak, ka ɓidzatǝrǝf taken. ");
INSERT INTO gdf_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Yakhaya kǝ khulfakh tsuguna a ɓalal da vake duɓan itar. Ndǝkchiɓ yiga itar zǝr dǝrmǝk dǝrmǝk. Yakhaya kulǝnkwakh kulǝnkwakh. Yakhaya tsuguna kulkhǝkerɗ kulkhǝkǝrɗ.” ");
INSERT INTO gdf_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Ka nǝv Yasu kǝ dǝg mbas, Ɗeghwa ude dǝ tlim tsǝn lava, baru bǝgin tlim. ");
INSERT INTO gdf_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Ka sa furakh Yasu ka nǝv itar tsin, “Uɗa lava tsǝkhǝn kwaratǝra lava tǝ dǝva dǝ jakva lavakhi?” ");
INSERT INTO gdf_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Ka ngawa tǝrkhai kwarne, “A bakura tsǝkurud ndzǝɗa tsa dǝge ɓǝghan ǝn tǝgher kǝ tlǝksa gharazhigǝl. Ai itara a batǝra bud bi. ");
INSERT INTO gdf_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Wirva ɗeghwa ude dǝ digit da banarghǝr bǝgud char, ka da ndaɓai ǝn vak sar zikǝn. Ai ude kwal dǝ digit char, ka da chawarval chawud ngwaɗa khiɗike dinin. ");
INSERT INTO gdf_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Dǝge kǝ mangan ǝn kwara tǝra ka lava dǝ jakvakh in kwarne, “Wirva itsa vazavaza itara ǝn nǝgha ba itar bi. Itsa bǝga itar tlima ǝn tsǝna ba itar bi. Tsuguna ǝn katlanǝf ba itar bi.” ");
INSERT INTO gdf_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Wirva yan lave tsa kwarga Ishay tlayang a righǝf ǝn vak tar. Nǝv Ishay tlayang “Da tsǝnakha tsǝna kur lav, ai da katlga ba kur tsa khǝɗikǝn bi. Uk da ɗema di tsǝkur ǝn tǝf, ai tsuguna da tsa ba kur dǝge ǝmbin bi. ");
INSERT INTO gdf_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Wirva gufǝrva udakhana a ɓengɓengǝf. Ən tsǝna ba tlimakh tar ad lava bi. A khaɗakhardu itar ad diyakh tar. Khek nǝgha nǝgha tsitar dǝ diyakh tar. Khek tsǝna tsǝna tsitar dǝ tlim tar tsǝgun. Wirva nagh ba itar katlgakatlǝn rǝvakhuɗ tar bi. Ka guyoghǝr itar da vakara mbakhatru kǝ. ");
INSERT INTO gdf_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Nǝg bark kǝ diyakhur wirvǝn nǝgha nǝgha kur din. Ndǝk yan tlimakhur tsugun wirvǝn tsǝna tsǝna kur din. ");
INSERT INTO gdf_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Ən tǝkha kura tǝkha kǝ, zikǝn tlayangakh Yazhigǝl, zǝ li kalaliyakh, tsǝn na itar nǝgha dǝge ǝn nǝgha kur. Ai a nǝgha ba itar bi. Zǝ na tsǝna dǝge ǝn tsǝna kur. Ai a tsǝna ba itar bi.” ");
INSERT INTO gdf_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Auna dǝge tuku jakva lav dadak kwazdu khulfen. ");
INSERT INTO gdf_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Da tsǝna kǝ udan ad lavǝn tǝghǝr kǝ tlǝksa gharazhigǝl, ǝn tǝ khalak yana a katlǝga bi, a nala ghila va khulfe a ɓalal ǝn tǝ ɗul. Tsǝnga kǝ udanen ad lav Yazhigǝl, ka sa Shatan, khutsala dǝ khulfe a tukhgud ǝn gufǝrva sar. ");
INSERT INTO gdf_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Khulfakhe balal da tǝ khayen tǝ fǝraɗ, in jakva ude benǝn tsǝna lav Yazhigǝl, ka chauga dǝ khwaɗg. ");
INSERT INTO gdf_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Fatsiye a dagh ba tlǝl sar da khay char bi, baga tsin ad rǝv da tǝ sart khǝɗikǝn. Tsiyif kǝ dlaɗa, zǝ mbakhǝl ǝn tǝghǝr kǝ lav Yazhigǝle tsǝnin, kujaɗ kujaɗ ka mbǝɗgan. ");
INSERT INTO gdf_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Khulfe ɓaldagh da vake dǝ takakh tsugun, itar jakva udakhe tsǝnga lav Yazhigǝl. Ai wirva mbakhǝl nagh dǝg lard zǝ valaval way tluwandal ǝn lard, a gadlarkhe ad ɗaka kǝ khulfen. Khulfen tsuguna a bǝdu bad zǝr bi. ");
INSERT INTO gdf_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Khulfe ɓalal da tǝ vak duɓan tsugun, in jakva ude tsǝnga lav Yazhigǝl katlgan tsugun. A mangan ad tlǝr din, tlǝm gǝmadu ad nuba khulfen. Yakhaya dǝrmǝk dǝrmǝk. Yakhaya kulǝnkwakh kulǝnkwakh. Yakhaya tsuguna kulkhǝkerɗ kulkhǝkǝrɗ. ");
INSERT INTO gdf_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Ka gwidǝn Yasu ad kwara tǝra tlǝrna jakv lav, ni, “ Tlǝksa gharazhigǝla ghila ude tukhga khulf khwaran ǝn gukh sar. ");
INSERT INTO gdf_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ən tǝ sarte ǝn khǝn khar udakh, ka dala dadak tlǝghum sar ka tukhgan ad khulf dlǝgh ǝn gukh lǝkamen. Ka tǝkaval sar. ");
INSERT INTO gdf_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Ɗakala kǝ lǝkamen yigan ad zǝr. Dlǝghen tsuguna, sawal ǝn khuɗ. ");
INSERT INTO gdf_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","“Ka sagh li man tlǝr dadak gukhen da vak sar. Ka nǝv itar tsin, ‘Dadmǝgha, atsuk khulf charan bakh tsa tukhga khǝn gukhaghena? A sawal ndar dlǝgh tsugun ǝn gukheni?’ ");
INSERT INTO gdf_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","“Ka niya tsitar, ‘Dadak tlughumara kǝ mangain.’ Ka nǝv zar man tlǝrsar tsin. ‘Əna nagh kha dǝgal tsǝkǝnda da ndaɗdu ndaɗa dǝ dlǝghena?’ ");
INSERT INTO gdf_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","“Ka niya tsitar, ‘Au, wirva nalabin dǝ kur ǝn ndaɗdu dlǝgha, ndǝɗamado ba zǝva lǝkam tsugun bi. ");
INSERT INTO gdf_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","A ɗuwam, ɗaka itar dagh zǝ lǝkam, da tǝ sarte da tsǝgdud lǝkam. Ən tǝ sarten da kwaratra ka kǝ li da tsǝgatsǝg, farsafǝg itar ndaɗdu dlǝgh chak, dzanǝf itar, ngwaɗana itar, ndaghana itar. Ka dzanǝf itar lǝkam, ɗiyakdagh ud da kuvurar.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Ka gwidǝn Yasu ad kwaratra tlǝrna jakv lav, ni, “Tlǝksa gharazhigǝl ngwaɗa khulf mastad, ai ɓǝf udanen ka tukhgan ǝn gukh sar. ");
INSERT INTO gdf_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Tsakhǝnmina in khǝɗikan ǝn khulfakh daghan. Ai da fǝtsawalina, ɗakalina, ka in da nǝga kǝ zikan ǝn tatak dǝgakhe ǝn ngaɓ. Da nǝga kǝ ufa zikan, ka da man mǝghakh ɗikakh ǝn tǝ gwalakh sar.” ");
INSERT INTO gdf_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Ka gwidǝn batra tlǝrna jakva lava kǝ Yasu kwarne, “Tlǝksa gharazhigǝla ndǝkva yisti, ai dzǝgǝf nus khǝɗikǝn, kǝ khwaɗum ǝn khǝpi lǝkam daram khǝkǝrɗ, tlǝm tsiyif kǝ khǝpiyen.” ");
INSERT INTO gdf_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","A kwara tǝrkhai Yasu ad dǝgakhana daghan kǝ dzakhava udakh dǝ jakva lavakh. Na bǝn kwara tra lava ndǝk yan bi, akwa dǝ jakva lav. ");
INSERT INTO gdf_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Dǝge a manga Yasu a righanǝf ad dǝge tsa kwarga Ishay tlayang. Avin, “Da ngura ghay ka kǝ kwar lava dǝ jakva lavakh. Dǝge tsa ɓǝghanud gul farsafǝg sar kǝ lard, da kwardu kwara kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ən tǝ khal kǝ, ɗuwars dzakhava udakh kǝ Yasu, ka da da mǝgh. Ka saks kǝ furakh sar da vak sar. Nǝv itar tsin, “Kwara kǝnkhe kwara dǝge tuku jakva lav dlǝghe a fǝtsal ǝn gukh Lekam.” ");
INSERT INTO gdf_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ka ngawa tǝrkhai, niya tsitar, “Dadake tukhga khulf khwaran, ka Zǝr Ud. ");
INSERT INTO gdf_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Gukh tsuguna in Lard. Khulf khwarana itar udakhe da daks da tlǝksa Yazhigǝl. Dlǝgh tsuguna itar udakh ya Shatan. ");
INSERT INTO gdf_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Dadak tlughume tukhga dlǝghena in wurdu. Sarta tsǝg khiyena, in fitsa mbasa lard. Li tsǝg khiyena itar zarɓǝlakh Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Ndǝkve dzakhud mas kǝ ndǝgha ndǝgh, da ndǝk yan fitsa mbasa lard. ");
INSERT INTO gdf_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Ka Zǝr Ud da ɓǝlondagh ɓǝla ka zarɓǝlakh Yazhigǝlar, kǝ dzakha dzakha tsitar daghan dǝge tsǝn bakh udakh da man khaip, zǝ daghan li tsǝn man nguɗi nguɗi digitakh. Khutstral itar dǝgal ǝn tlǝksar. ");
INSERT INTO gdf_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","Ka tlǝvtǝrdagh itar da kara tsakai tsakai, vake da tudai tar dǝ kǝrɗ tliɗ, ");
INSERT INTO gdf_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ǝn tǝ yanen kǝ sart, da wuɗa liye kanadi ngwaɗa fatsi ǝn tlǝksa Dad tar. Ɗeghwa ude dǝ tlim tsǝn lava, baru bǝgin tlim. ");
INSERT INTO gdf_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Tlǝksa gharazhigǝla ghila lemane a ɓǝghanud ǝn gukh, ai mbǝladu udan, ka gwidǝn ɓǝghanan. Wirva khwaɗga, ka dala sakwdu ad dǝgakh sare dinin daghan, ka sukwgan ad yanen kǝ gukh. ");
INSERT INTO gdf_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Dakhkana, tlǝksa gharazhigǝla ghila zǝr kasuke ǝn gat kurakhe ndanga char. ");
INSERT INTO gdf_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Mbǝladu tsin khwaran na kǝ chachaɗ fang, ka dala sakwdu ad dǝgakh sare dinin daghan, ka sukwgan ad ndangan ak chachaɗ kuren. ");
INSERT INTO gdf_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Tsǝguna, Tlǝksa gharazhigǝla ghila sika vai kilfe ɓǝlavdagh da dǝlv, ai viyado ad kilfakh sikh sikh. ");
INSERT INTO gdf_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Righif tsin, ka ndǝɗado udakh da tǝ kalam gǝrdz, ndzakhgud, zaɓadalud khwarkhwaran na kǝ kilf, ɗidaghud da tughub, ka ɗiduwud dǝgal ade kwal khwar. ");
INSERT INTO gdf_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Da nǝga ndǝk yan fitsa mbasa lard. Da sǝgdagh zarɓǝlakh Yazhigǝl da takatak, kǝ zaɓadal nguɗi udakh sǝgawal ǝn li kanadi udakh. ");
INSERT INTO gdf_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","Ka da tlǝvtǝrdagh tlǝva itar ad nguɗi udakhen da kara tsakai tsakai, vake da tuwda itar dǝ kǝrɗ tliɗ. ");
INSERT INTO gdf_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Ka ndiɗatǝrwal Yasu, “A katlǝga nagh kur dǝgakhan tsagduwud daghana?” Nǝv itar tsin “Əm” A katlga kǝnd. ");
INSERT INTO gdf_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ka niya tsitar, “Wirva yan ɗeghwa dadak tsagdu ndzikha ndzikh Mus, ai tsagarduwud kǝ nǝga kǝ zǝr ɓǝla tlǝksa gharazhigǝl, ya ghila dadak mǝghe a dzǝgadal wuliwan zǝ mughuran na kǝ lǝman ǝn vake bǝgdin dǝgakh sar.” ");
INSERT INTO gdf_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Udzala kǝ Yasu ǝn kwarakh inakhan na kǝ jakva lavakhen, ka ɗuwars ad yanen kǝ vak. ");
INSERT INTO gdf_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","A do Yasu da kǝs sar. Sa tsin da vaken, ka da da gud dzakhava Yakhudakh, ka farsan ad tsaga tǝrdu tsag kǝ udakh. Ka ndawatǝrǝf kǝ liye a tsǝngan. Avitar ma, “A mbǝladu ǝn vara udan na dina kǝ kwalemlem ra? Tsǝguna a mbǝladu ǝn varin ndzǝɗa man dǝg ndawakakhani?” ");
INSERT INTO gdf_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","“Zǝr dadak tsakh mǝgh na baina biya? Bab sar ba Maryam biya? Yakub, Yusuvu, Siman, zǝ Yakhud saghrakh sar baitar kina biya? ");
INSERT INTO gdf_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Daghan dǝghaw babakh sara ǝn giɗǝn vak mar baitar biya? Ai a mbǝladu dǝvarin ad dǝgakhani?” ");
INSERT INTO gdf_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ka bazala rǝv tsitar, ai nǝv Yasu tsitar, “Itsa dǝvara, nǝg ndanga kǝ tlayang Yazhigǝl. Ai uk ǝn ɗudǝn ǝn kǝs sar zǝ fǝta sarud.” ");
INSERT INTO gdf_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","A manga ba dǝ dǝg ndawakakh ǝn vin char bi, wirva kuɗ fadǝghǝro fǝga tar. ");
INSERT INTO gdf_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ən tǝ yanen kǝ sart, ka tsǝna tsǝna kǝ Khirudus Antifas dadake man tlǝksǝn Galili ad lave ǝn kwara udakh ǝn tǝghǝr kǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ka niya kǝ li manara tlǝr, “Afka ina Yukhan dadak para uda. A tsiyavanǝf ǝn ngitl. Yan kǝ mangan nǝg dǝ ndzǝɗa manakh dǝg ndawakakh.” ");
INSERT INTO gdf_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Wirva tsa kwarga Khirudus ad viga Yukhan kǝ kǝɗa da sal, wirva Khirudi nus zǝr bab ghǝrsar Filibus. ");
INSERT INTO gdf_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Wirva tsǝn tǝkhara tǝkha Yukhan gwil yan kǝ Khirudus kwarne, “Kalkal ba pǝrɗ Khirudi tsin kǝ nǝga kǝ nus sar bi.” ");
INSERT INTO gdf_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Tsa khǝnmina tsǝn nagha Khirudus ad kǝɗga Yukhan, ai ka gǝdzgan ad di udakh, wirva a ɓanǝf itar kwarne Yukhana tlayang. ");
INSERT INTO gdf_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Gwiyoghǝr kǝ khǝna vǝge tsa yigdud Khirudusa, ka dzanda dugh Khirudi ad tsugw ǝn tǝvuk kǝ ghulabakhe sawal da vak khwaɗǝg. Tsugwa sarna kǝ zǝɗaru kǝ Khirudus char. ");
INSERT INTO gdf_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Wirva yan, ka manarkhai ad lanji zǝ waɗa kwarne, da barabǝg ad itsauɗa dǝge takaɗgin. ");
INSERT INTO gdf_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Tǝkǝn bab sara, ka shakhanǝf ad dugh sar ad dǝge da kwarin. Ka ni, “Ba ka bǝgud ad ghǝr Yukhan dadak para ud ǝn mbanmban ǝn tǝvana kǝven.” ");
INSERT INTO gdf_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Turug ghǝr kǝ shik, ai wirva waɗe a mangin da nǝga kǝ dǝg zhiru tsin ǝn tǝvuk kǝ ghulabakh sar. Ka kwargan ad barabǝg ad dǝge ǝn naghin. ");
INSERT INTO gdf_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Ka talal ad ghay da gud sala, ǝntladǝghǝr ǝntlud ghǝr Yukhan. ");
INSERT INTO gdf_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Ka ɓardǝghǝrud ghǝr saks ǝn mbanmban, barud kǝ zǝr dughen, khalakyana ka ɓara kǝ bab sar. ");
INSERT INTO gdf_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Ka saks kǝ furakh Yukhan da zǝb gǝdzumba vǝgha sar, ka khǝɗane itar. Ka dǝgal tsitar kwararkhe itar kǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Tsǝna kǝ Yasu ad dǝge dzaughǝr dǝ Yukhan, ka tsiyawal ǝn tǝ vinen ka da da Peryu, ka dǝgal tsin da giɗa tukuɗa sar ǝn vake kwal nǝg kǝ ud. Ai tsǝna kǝ dzakhava udakh kwarne a ɗuda Yasu ad yanen kǝ vak, ka sǝgawal tsitar ǝn kǝsakh, ka dǝgala tsitar dǝ sig da vake dǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Sawala kǝ Yasu ǝn peryu, ka nǝghan ad dzakhava udakh zikǝn. Ka kwiɗ nǝv rǝv tsin, tsuguna ka mbakha tǝru ak li kwal yang ǝn tatak tar. ");
INSERT INTO gdf_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ɓǝlga kǝ khagw, ka sa furakh sar da vak sar, nǝv itar tsin, “Vakna digi na tsawar bi, tsuguna a ɓǝlga khagw. Ɗuwatǝrs ɗuwa kǝ dzakhava udakhan dǝgal kǝ saku dǝg zuwa tsitar ǝn gǝdzar kǝsakhan.” ");
INSERT INTO gdf_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ka nǝv Yasu tsitar, “Uɗa lava tsitar dǝgal da tlǝrna vaki? Bamatra bǝg ad dǝge da zuwa itar.” ");
INSERT INTO gdf_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Ka ngawarkhe itar kwarne, “Uk ɗumba brudi dliɓa zǝ kilf mits din kǝnd ǝn van.” ");
INSERT INTO gdf_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Ka ni “A nakam.” ");
INSERT INTO gdf_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ka ndzakhamga ndzakhǝn tǝ dzuɓna niya kǝ udakhen. Ka ɓǝf ad brudina dliɓ zǝ kilfna mits, ka lando dǝ ghǝr da gharazhigǝl, ka kwarara us tsin kǝ Yazhigǝl. Ka kwachanan ad brudiyen baran kǝ furakh sar, ka bara furakh sar tsugun kǝ udakhen. ");
INSERT INTO gdf_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","A zuwaru daghan tar, baghala itar. Ka dzakhanǝf furakh sar ad daghan dege tǝmgan. Ka raghanǝf ad tughwbakh kǝlatǝm mits. ");
INSERT INTO gdf_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ghwalvakhe zuwa a ɓa itar dǝb dliɓ. A tugwana bud nughwasa zǝ zar bi. ");
INSERT INTO gdf_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Mbasu tsitar ma, ka kwara tǝrkhe Yasu kǝ furakh sar kǝ daks da peryu, kǝ dǝgal tsitar ǝn tǝvuk da tǝ tlǝrna ghǝdzǝva gadzak. In tsuguna dlaɓǝn ghits ǝn tǝ vin, kǝ da kwarara kwaza kǝ udakh daks ndan, kǝ dǝgal tsin. ");
INSERT INTO gdf_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Tǝkhal kǝ kwazana dzakhava udakh tsin, ka dugo tsin da tǝ ghuɓ kǝ ɗǝgaw tukuɗa tukuɗ. Ɓǝlga kǝ khagwa, ǝn vin tǝkuɗa sar. ");
INSERT INTO gdf_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Ən tǝ yanen kǝ sarta, bita pǝr yu zǝ ghay gǝrdz. Uk kaɗakaɗa kǝ ghǝɗkuta yu ad pǝr yuwen. Wirvǝn tlǝg tlǝga fuɗ ad pǝr yuwen da tǝlg. ");
INSERT INTO gdf_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Kalkal karfi khǝkǝrɗ dǝ ghǝr kǝdl, ka sagh Yasu da vak furakh sar, ǝn dǝgǝn tǝghǝr kǝ yu. ");
INSERT INTO gdf_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Nǝgha kǝ furakh sarna ad dǝga tsin ǝn tǝghǝr kǝ yuwa, ka gadzǝf itar char. “Ude sawal ǝn tǝ fik,” nǝv itar. Ka khula tsitar wirva gǝdz. ");
INSERT INTO gdf_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Tǝvin tǝvina, ka kwaratǝra lava kǝ Yasu kwarne, “Tukhwamfǝkhe tukha, i ka fǝka, gǝdzmbiya.” Niya tsitar. ");
INSERT INTO gdf_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Ka nǝv Bitrus tsin, “Dadzikan, ai da khin, khaya kanǝf khaya dǝgǝn tǝ ghǝr kǝ yu, kǝ saks da vakagh.” ");
INSERT INTO gdf_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","“Ausǝga,” nǝv Yasu tsin. Burkhwit ka tsiyawal Bitrus sǝgawal ǝn peryuwen, ka farsa dǝga tsin ǝn tǝ yu, dǝgal da vak Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Ai vazga tsina a tsiyif fuɗ dǝ ndzǝɗa char, ka gǝdzǝf, ka farsa yu ad ndǝga ndǝg. Ka khula tsin, “Dadzikan katka katka” Niya tsin. ");
INSERT INTO gdf_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Tǝvin tǝvina ka talal Yasu ad dǝv sar, ka viyado sǝgo. Ka niya tsin, “Kha dadak khǝtsa fadǝghǝro fǝg, wuɗa lava kwal khayakǝf tsǝkhi?” ");
INSERT INTO gdf_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Da kǝ Yasu zǝ Bitrus da peryuwa, ka lǝɓukw nǝv fuɗ. ");
INSERT INTO gdf_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ka ɗabanǝf furakh sare tsǝn Peryu ad Yasu. Ka nǝv itar tsin, “Zǝr Yazhigǝl kha kaɗikaɗi.” ");
INSERT INTO gdf_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Ghǝdzǝvarghǝra tsitar ad dǝlva, ka sa itar da ǝntla khay ya Janisarat. ");
INSERT INTO gdf_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ai katlga kǝ li kǝsen kwarne, atsuk Yasu, ka ɓal ghay tsitar kǝ kwarara kwara kǝ itsawar ǝntla khaya kǝsen daghan. Khalak yana ka zaɓardǝghǝr udakh kǝsen ad daghan liye kwal yang. ");
INSERT INTO gdf_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Ka tatlga itar, kǝ khaya tǝrnǝf khaya kǝ liye kwal yang kǝ gǝma itsa ghay gabag sar. Daghan li gǝma ghay gabag sara, a mbakhu itar. ");
INSERT INTO gdf_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Dud ǝn kwarina, ka sasǝg kǝ yakhaya kǝ Farisakh zǝ yakhaya kǝ li tsagdu ndzikha ndzkh Mus ǝn Wurshalim, da vak Yasu. Ka ndiɗarwal itar kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Uɗa lava kǝ zar ɓǝlakhagh ǝn kala ndzikhe a bǝga dzidzakhǝndi? Wirva na itar ǝn par dǝv kǝda zu kaf ndǝkve tsagdu dzidzakhǝnd bi.” ");
INSERT INTO gdf_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ka ngawa tǝrkhai Yasu kwarne, “Uɗa lava tsǝkur ǝn kala ndzikha ndzikh Yazhigǝl, uk ǝn gatars kǝ dǝge tsagdu dzidzakhura kuri? ");
INSERT INTO gdf_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Afka nǝv Yazhigǝla, ‘Farghǝrfǝg kǝ dadagha zǝ babagh.’ Tsuguna ni, ‘Itsawar ǝn lakhga dad sar zǝ bab sar, kǝɗgud kǝmts.’ ");
INSERT INTO gdf_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Ai ǝn tsagdutsaga kur kwarne, ‘Da nǝg dǝge nagha udan ad mǝlaru mǝla kǝ dad sar zǝ bab sar din, “Ai ka avin tsugun, daghan dǝge tsa da mbǝladu kur ǝn vakar, a barkhe ka kǝ Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Wirva yana, atsuk barari ba mǝlaru mǝla kǝ dad bi nikur.’ Wirva yan, a nandal kur lav Yazhigǝl kǝ bat, kǝ nǝghda gatars kǝ ndzikha ndzikhur. ");
INSERT INTO gdf_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Kuram nguɗiyakhan. Kalkal dǝge tsa kwarga Ishay tlayang ǝn tǝghǝr tsukur. Kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","“ ‘Udakhanna digi, uk ǝn fakghǝra dǝ ghay itar. Rǝvakhuɗ tara bita zǝ kǝ. ");
INSERT INTO gdf_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ən ɗaba ka buti itar. Ən tsagdu ndzikha ndzikh udakh itar. Ən dleva lav Yazhigǝl.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Khala kǝ yana, ka ɗakhtǝrkhai Yasu kǝ dzakhava udakh, niya tsitar, “Bambǝg tlim, ka diyarsa kur. ");
INSERT INTO gdf_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Dǝge ǝn da da ghay bǝn naud kǝ kwadlamb ǝn tǝvuk kǝ Yazhigǝl bi. Dǝge ǝn sǝgawal ǝn ghay kǝ dadak sar ǝn nandala kǝ kwadlamb ǝn tǝvuk kǝ Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Ka saks kǝ zar bǝlakh sar da vak sar, nǝv itar tsin, “Tsa tsǝkha kwarne a bazala rǝvakhuɗ kǝ Farisakh tsǝnga tsitar lavana kwarga kha?” ");
INSERT INTO gdf_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ka ngawatǝrkhai Yasu tsitar, “Itsera kǝ ufe Dadar ǝn gharazhigǝl ba kǝ njivgan bi, ka da ndaɗdu ndaɗud kutskuts. ");
INSERT INTO gdf_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Ɗuwamatǝrs ɗu, ngulfakh itar li mǝdlara ɗul kǝ ngulfakh. Daka ngulf ǝn mǝdlara ɗul kǝ ngulfa, afka bǝrdagha tara da mbǝɗa itar dǝgdagh da fika.” ");
INSERT INTO gdf_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Ka nǝv Bitrus tsin, “Kwara kǝnkhai kwara dǝge tuku jakva lavan.” ");
INSERT INTO gdf_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","“Atsuk dakhkana ghǝrur tsuguna a katlga ba kur biya?” Nǝv Yasu tsitar. ");
INSERT INTO gdf_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","“Ən tsa bakh kur kwarne, ɗeghwa dǝge da da ghay kǝ udan, ǝn dǝgdagh da khuɗ sar, kǝ dǝg mbasa ka da sǝgawal ǝn vǝgh sara?. ");
INSERT INTO gdf_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Ai dǝge sǝgawal ǝn ghaya ǝn sǝgawal ǝn rǝvakhuɗ. In dǝgakhe ǝn naud kǝ kwadlamb ǝn tǝvuk Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Afke ǝn sǝgawal ǝn rǝvakhuɗ nguɗi nguɗi ɗaya ghǝra. Ndǝk za kǝɗ safa uda, gwaragwara, ǝrɗa, gǝla, dlaghawa fila zǝ bazardu ɗakha kǝ ud. ");
INSERT INTO gdf_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Ina dǝgakhe ǝn naud kǝ kwadlamb ǝn tǝvuk kǝ Yazhigǝl. Ai zu kaf dǝ dǝv kwal paran ǝn tǝ dǝva dǝ ndzikh ba da naud kǝ kwadlamb ǝn tǝvuk kǝ Yazhigǝl bi.” ");
INSERT INTO gdf_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Ɗuwars kǝ Yasu ad yanen kǝ vak, ka dal da ǝntla khaya kǝsakhe khefa dǝ Taya zǝ Sidom. ");
INSERT INTO gdf_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Dzagwdlam, ka sa nusen dugh ya Kanan ǝn giɗǝn khayen da vak Yasu. Ka tuwa tsin kwarne, “Dadzikan, Zǝr Dod, ziwakdal ziw. Ən bara dlaɗ sǝɗikw bǝzan kǝ dughwar char.” ");
INSERT INTO gdf_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","A kwararkhe ba Yasu ad tsauɗa kǝ nusen bi. Ka saks kǝ furakh Yasu da takaɗa takaɗ ad Yasu. Nǝv itar tsin, “Lakwars lakw, wirvǝn gatakiyams gat, ǝn mbakiyama mbǝg dǝ tu.” ");
INSERT INTO gdf_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Ka ngawa tǝrkhe Yasu, ni, “Uk a ɓǝlokondagh wirva udakh ya Izraile a zaɗgan ud.” ");
INSERT INTO gdf_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Ai ka saks kǝ nusen da tǝvuk sar, kǝlgan ad juguv. “Dadzikana, mǝlaku mǝla.” Niya tsin. ");
INSERT INTO gdf_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Ka nǝv Yasu kǝ nusen, “Ən manawa ba bǝf ud kaf zara, ka barud kǝ ghǝdakh bi.” ");
INSERT INTO gdf_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nǝv nusen tsin, “Lave kwarga kha na kalkal Dadzikan. Ai tsuguna, ghǝdakha ǝn zuwa zuwa itar, ad kwacha kafakhe ɓalal ǝn tǝ vǝlengakhe ǝn zuda li mǝghakh ad kaf.” ");
INSERT INTO gdf_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Ka ngawarkhe Yasu, niya tsin, “Awara nusna, fadǝghǝro fǝgagha nǝg dǝ ndzǝɗ, da manakha manud dǝge nakh.” Ən tǝ yanen kǝ sarta, ka mbu dugh sar ǝn tǝvin tǝvin. ");
INSERT INTO gdf_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ɗuda kǝ Yasu ad yanen kǝ vak, ka dǝgal tsin diwa kalam dǝlva Galili. Khalak yana ka ngalo da tǝ gil nndzǝgan. ");
INSERT INTO gdf_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ka saks kǝ udakh zikǝn da vak sar. Zaɓardǝghǝr itar dǝ ghurɗikakha, zǝ ngulfakha, zǝ li ǝmtsa kalam vǝgha, zǝ tǝngakha, zǝ chalǝm li kwal yanga zikǝn. Ka bakhga itar ǝn tǝvuk sar. Ka mbakha tru. ");
INSERT INTO gdf_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Ka ndawatrǝf kǝ udakh vazga tsitar ad li kwal tǝkha kǝ kwarga lava ǝn kwarghai itar. Li mǝtsa vǝgha ka a mbakharu, ghurɗikakh ǝn dǝga itar, ngulfakh ǝn nǝgha nǝgha itar. Ka farghǝr itar kǝ Yazhigǝl Izrail. ");
INSERT INTO gdf_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Dud ǝn kwarina, ka ɗakhtǝrkhai Yasu kǝ furakh sar saks da vak sar. Ka niya tsitar, “Ən ziwardal ziwa ka kǝ dlama khan, wirva khǝkǝrɗ khana tsitar ǝn vakar, tsuguna na dǝg zuwun vak tar bi. Nagh ba ka daks tsitar dǝ way bi, wirvǝn tǝkha itar kǝ ɗighǝr khar ǝn tǝ ɗul daks da mǝgh.” ");
INSERT INTO gdf_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Nǝv furakh sar tsin, “Ən tǝghal ndǝkina, da mbǝladu ǝn makiyam ad dǝg zuwe da tǝkhud kǝ batran kǝ udakh pakina ra?” ");
INSERT INTO gdf_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Ka ndiɗatǝrwal Yasu kwarne, “Ngǝrwa brudiye din kur ra?” Ka nǝv itar tsin, “Ɗumba uɗif zǝ mbisan na kǝ kilfakh.” ");
INSERT INTO gdf_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ka bǝtra kǝ dzakhava udakh kǝ ndzakhga ndzakh ǝn tǝ khay. ");
INSERT INTO gdf_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ka ɓǝf ad ɗumba brudiyen uɗif zǝ kilfakhen, kwararkhai ad us kǝ Yazhigǝl, ka kwachanǝf, baran kǝ furakh sar. Ka bara furakh sar ad brudiyen zǝ kilfakhen kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Itsawara a zuwa, a baghala itar. Ka dzakhanǝf furakhen ad dǝg zuwe a tǝmgan, tugwǝb uɗif reghan. ");
INSERT INTO gdf_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Udakhe zuwa ruwa, a ɓa itar ghwalvakh dǝb ufaɗ. A kǝdlga bud nughwasa zǝ zara bi. ");
INSERT INTO gdf_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Ən tǝ khal kǝ ɗuwatǝrs ɗuwa kǝ Yasu ad dzakhava udakh, ka da da peryu, ka dǝgal da ǝntla khaya ya Magadan. ");
INSERT INTO gdf_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","A sa Farisakha zǝ Sadukiyakh da vak Yasu kǝ nǝghda kurakura tsitar. Ka ndiɗarwal itar kǝ mana tra zikan na kǝ dǝg ndawake da mǝdla din kwarne a saudagh ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Ka ngawa tǝrkhai ni, “Da dǝm fatsi da ɓǝl, da ka nǝgha tsǝkur khas khas ǝn tǝ gharazhigǝl, ka nikur, ‘Yauwa, na yu da tǝɗa bi.’ ");
INSERT INTO gdf_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Da ka sǝgo gwisǝl zǝ ghabag, da nǝgha tsǝkur khas khas ǝn tǝ gharazhigǝl, lusǝf kes, ka nikur ‘Da tǝɗa yu khan.’ Tǝkha kur kǝ tsan ad dǝgakhe da dzaughǝr ǝn tǝ dǝva dǝ giɗa kǝ fef gharazhigǝl, wur ka tǝkh ba kur kǝ katlga dǝge ǝn tuku jakǝvakh manasar kǝ kwargǝna bi. ");
INSERT INTO gdf_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Udakh kwargǝna li kwal khayanǝf dǝ Yazhigǝl itar, kǝladakh tsugun. Na kur nǝgha dǝg ndawak, ya na bud da mǝdla kura tlǝrna dǝg ndawak bi, akwa dǝg Yunan.” Khalak yana ka ɗuwatǝrs Yasu, dakaval sar. ");
INSERT INTO gdf_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Darghǝra tsitar da tǝ tlǝrna ghǝdzva gadzak dǝlv, ka dzamana furakh sar kwarne a mbitsa tǝrghǝr sǝgawal dǝ brudi. ");
INSERT INTO gdf_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ka nǝv Yasu tsitar, “Ɗem nikur, ya tsukwamana ghǝr dǝ yista Farisakha zǝ Sadukiyakh.” ");
INSERT INTO gdf_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Ka farsa ɗayakavu lav tsitar ǝn tatak tar kwarne, “Wirve a ɓadal ba kiyam ad brudi bi nagh ǝn kwarin adina?” ");
INSERT INTO gdf_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","A katlga Yasu ad dǝge tsǝn kwara itar, wirva yana, ka ndiɗatǝrwal kwarne, “Uɗa lava tsǝkur ǝn ɗayakavu lav ǝn tǝbur kwarne, wirva na kur dǝ brudi biyi? Kuram li khǝtsa fadghǝrofǝg. ");
INSERT INTO gdf_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Dakhkana a katlga ba kur biya? A mbitsa kur ghǝrkh sarte tsa baghandala ka udakh dǝb dliɓ (5,000) dǝ ɗumba brudi dliɓa? Tughwb ngǝrwa a dzanǝf kuram ake tǝmgani? ");
INSERT INTO gdf_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Awana ǝn sarte tsa baghandala ka udakh dǝb ufaɗ (4,000) dǝ ɗumba brudi uɗif. Tughwb ngǝrwa a dzanǝf kuram ake tǝmgani? ");
INSERT INTO gdf_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Uɗa kǝ mangan tsǝkur kwal katlgan kwarne ǝn kwara kura lav ǝn tǝghǝr kǝ brudi ba ka biyi? Ən kwara kura kwarne tsukwamana ghǝr dǝ yista Farisakh zǝ Sadukiyakh kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Ka katlga furakh sar kǝ Yasu kwarne, ǝn kwarǝn tǝghǝr kǝ yiste ǝn ɗiyud ǝn brudi bi. Tsukwamana ghǝr dǝ yisti na tsǝn kwarina, atsuk ǝn kwarǝn tǝghǝr kǝ tsagdutsaga Farisakha zǝ Sadukiyakh. ");
INSERT INTO gdf_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Soghǝr kǝ Yasu da kǝs ya Kesariya Filibiya, ka ndiɗatǝrwal kǝ furakh sar kwarne, “Warek ka Zǝr Ud vek udakh ra?” ");
INSERT INTO gdf_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Ka nǝv itar tsin, “Av yakhaya Yukhan dadak para ud, av yakhaya Ili tlayang, av yakhaya tsuguna Irmi tlayang, awana fang ǝn tatak tlayangakh.” ");
INSERT INTO gdf_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Niya tsitar, “Ai kur ma, warek kavek kuri?” ");
INSERT INTO gdf_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Ka ngawarkhe Siman Bitrus kwarne, “Kha Masikhu, Zǝr Yazhigǝl dadak saf.” ");
INSERT INTO gdf_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Ka nǝv Yasu tsin, “Dadak bark kha Siman zǝr Yukhan, wirva a sakha diwa ud dǝg sig ba ina kǝ jir bi. Dadare ǝn gharazigǝl kǝ kwara khai. ");
INSERT INTO gdf_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Ni ǝn kwarakha kwara kǝ, kha Bitrus, fǝraɗ khǝ, da ɓǝlǝn tǝ kha ka dǝ kur khǝgar, dǝge ǝn tuku kur khǝgena, itar udakhe da fadghǝrofǝg ǝn tǝ kǝ. Ai kwal da tǝkha kǝ ndzǝɗa mǝtsa kǝ manar khai tsauɗ. ");
INSERT INTO gdf_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Da bakha bǝg ka dǝg tusa nga gud tlǝksa gharazhigǝl. Tsugun, ɗeghwa dǝge kwal khayanǝf tsǝkha manaman ǝn lard, nabud da manaman ǝn gharazhigǝl bi. Ɗeghwa dǝge ǝn nakha manaman ǝn lard, da mana ndǝkyan ud ǝn gharazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Ka ndǝɗatǝrnǝf Yasu ad tlim kǝ furakh sar char kwarne, kwarara ba itar kǝ itsawar kwarne ka Masikhu bi. ");
INSERT INTO gdf_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Tsiyif ǝn tǝ yanen kǝ sart, ka farsa Yasu ad kwara tra kwara tsin kǝ furakh sar kwarne, “Barari dǝgal tsin da Wurshalim, kǝ khǝɓ dlaɗakh sikh sikh sikh ǝn dǝv kǝ maludakh zǝ zikzikanakh kǝ zil kǝsakh zǝ li tsagdu nzdikha nzdikh Mus. Ka da kǝɗke kǝɗud, fitsa khǝkǝrɗa da tsiyaka tsiyud.” ");
INSERT INTO gdf_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Ka ndǝɗala Bitrus ad Yasu da te kalam, ka farsan ad tavarghǝr di kwarne, “Tsandu tsǝg Yazhigǝl ad yan, Dadzikan. Da dzoghǝr ba yan dǝ kha tsa khǝɗikǝn bi.” ");
INSERT INTO gdf_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Ka gwiyafkhe Yasu ka niya kǝ Bitrus, “Tsiyakval tsiya kha Shatan. Kur khǝtingǝɗ khǝn tǝvukar, wirva ɗaya ɗaya na, ɗaya ghǝr ud dǝg sig, dǝg Yazhigǝl bi.” ");
INSERT INTO gdf_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Ka nǝv Yasu kǝ zar bǝlakh sar, “Ɗeghwa ude nagh gataks gat, barari ɗuda way ghǝrsar tsin. Tsuguna ka ɓǝfin ad ufa khǝrta sar, kǝ gataks gat. ");
INSERT INTO gdf_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Wirva ɗeghwa ude na kat safa sar, da bǝgh. Ai ɗeghwa ude khayanǝf bǝghǝn safa sar wirva kǝ, da mbǝladu mbǝl. ");
INSERT INTO gdf_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Uɗa dǝg sige da gǝmadu udan, da gǝmaduwin dǝgakhe ǝn lard daghan, tsuguna bǝghalǝn safa sari? Uɗa dǝge tǝkha udan kǝ bǝdu kǝ varda safa sari? ");
INSERT INTO gdf_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Da sǝgadagh ka Zǝr Ud ǝn ndanga Dadar zǝ zarɓǝlakhe ǝn gharazhigǝl. Khalak yana, ka da bara dǝg siga sar ka kǝ itsawar, kalkala dǝge a mangin. ");
INSERT INTO gdf_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Ən tǝkha kura tǝkha kǝ, nǝg udakhe ǝn ghitsǝn van, liye kwal da ǝmts, khekwa nǝgha ka itar ka Zǝr Ud, ǝn sǝgdagh ka ndǝk shik.” ");
INSERT INTO gdf_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Tǝkhal kǝ khǝna unkwakh kǝ kwarga kwara kǝ Bitrus kwarne Yasu in Masikhu, ka zǝɓǝf Yasu ad Bitrus, zǝ Yakub, zǝ Yukhan zǝrbab Yakub. Zǝɓtro da tǝ tsǝɓan na kǝ khuɓ. Uk itar kalti ǝn vin. ");
INSERT INTO gdf_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","A mbǝɗfǝkhe vǝgh Yasu ǝn di tsitar. Ka wuɗa vakdi sar ndǝk fatsi, tsuguna nala kadlangakh sare a talǝmin kǝ maɗakw tǝl. ");
INSERT INTO gdf_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Ən tǝvin tǝvin, ka nǝgha kǝ zar ɓǝlakhana dǝ Mus tlayang zǝ Ili tlayang ǝn kwar lav itar zǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Ka nǝv Bitrus kǝ Yasu, “Dadzikan, khwaren nǝg kǝnda van. Da khayanǝfkh, da manga mana ka tsikw khǝkǝrɗ ǝn van. Fang tsǝkha, fang kǝ Mus tlayanga, fang kǝ Ili tlayang.” ");
INSERT INTO gdf_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Madǝv Bitrus ǝn kwar lava, ka sodagh ghwike ǝn wuɗ tǝrdlǝm da tǝghǝr tsitar. Khalak yana, ka tsǝna tsǝna tsud ad kwind sǝgawal ǝn ghwiken kwarne, “Zǝraren ǝn waya kǝ, ǝn tsǝn zǝɗa sar ka char. Tsǝna maru tsǝn.” ");
INSERT INTO gdf_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Tsǝna kǝ furakh sar ad yanen kǝ kwinda, ka gǝdzatrǝf char, ka khǝmbga itar da khay. ");
INSERT INTO gdf_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ka sa Yasu, tapa tǝrkhai avin, “Tsiyamǝf tsi, gǝdzam bi.” ");
INSERT INTO gdf_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Kapanǝf tsitar ghǝra, aghba itsawar ǝn vin bi tǝma Yasu kitakul. ");
INSERT INTO gdf_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Madǝv itar ǝn sǝgadagh ǝn ghuɓen, ka ndǝɗaternǝf Yasu ad tlim kwarne, “Kwarama tra ba kǝ itsawar ad dǝge nǝgha kur bi, khekwa tsiyanǝfud ka Zǝr Ud ǝn ngitl.” ");
INSERT INTO gdf_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Ka ndiɗarwal furakhan na kǝ Yasu kwarne, “Ai uɗa lava kǝ li tsagdu ndzikha ndzikh Mus ǝn kwarne, barari khekwa Ili tlayang da farsa sǝgadagh ndan, kǝda sǝgadagh kǝ Masikhuwi?” ");
INSERT INTO gdf_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Ka ngawa tǝrkhai, “Kalkal da sǝgdagh kǝ Ili tlayang, kǝda ɗika itsauɗa kǝ nǝga kalkal ndan. ");
INSERT INTO gdf_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Ən tǝkha kura tǝkha kǝ, audzala Ili ǝn sodagh sǝg, a katlga ba itar kwarne in bi. A manarakhe itar dǝge ǝn nagha reva tar. Da khǝɓa ndǝk yan ka Zǝr Ud tsugun ad dlaɗ ǝn dǝva tar.” ");
INSERT INTO gdf_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Khalak yana ka katlga zar ɓǝlakhana kwarne, atsuk ǝn kwara tra lav ǝn tǝghǝr kǝ Yukhan dadak para ud. ");
INSERT INTO gdf_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Sodagh tsitar ǝn tǝ khuɓen da vake dǝ dzakhava udakh, ka sasǝg kǝ udanen da vak Yasu, kǝlgan ad juguv ǝn tǝvuk sar. Ka ni, ");
INSERT INTO gdf_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Dadzikan, manga kwiɗkwiɗǝrva zǝraran. Nǝg fuɗ ǝn vǝgh tsin, tsuguna ǝn bara dlaɗ char. Ngǝrwa siga tsin ǝn ɓala dǝgdagh da kar zǝ yu. ");
INSERT INTO gdf_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","A ɓala ka da vak zar bǝlakhagha, a piyatǝrwal mbambǝg.” ");
INSERT INTO gdf_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Ka ngawarkhai Yasu kwarne, “Kur udakh kwargǝn, li kwal dǝ fadǝghǝrofǝg, kur mbǝrshakhan. Ki da zulu pak uɗa tsǝka zǝ kuri? Ki da bǝga pak uɗa tsǝka rǝv dǝ kuri? Ɓakdǝghǝr ɓa da van, niya kǝ dad zǝren.” ");
INSERT INTO gdf_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ka tavarghǝr Yasu ad di kǝ wurduwen, ka sawalǝn zǝren, tǝvin tǝvina ka mbu. ");
INSERT INTO gdf_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ka saks kǝ furakh Yasu da vak sar ǝn sarte tǝkuɗa sar tsin, ka ndiɗarwal itar, “A piyakǝndǝwala ndar lakwdu wurduweni?” ");
INSERT INTO gdf_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Ka ngawa tǝrkhai Yasu kwarne, “Wirva a khǝtsa fadǝghǝrofǝgur. Ən tǝkha kura tǝkha kǝ, da tsa nǝg fadǝghǝrofǝgur khǝɗikǝn ndǝk khulf mustad, tǝkha kur kǝ kwararkhe kǝ ghuɓna kwarne, ‘Tsiyin dǝgal van, da tǝ tlǝrna vak’, tsuguna ka da tsi. Na dǝge tǝkha kǝ piyakurwala bi.” ");
INSERT INTO gdf_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","“Afka khulf ina kǝ sǝɗikw bǝzana tǝkh ba kǝ sawala bi, khekwa dǝ ɗǝgawa zǝ zǝɓ ndǝl da sǝgawalin.” ");
INSERT INTO gdf_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Dzafkhai kǝ Yasu zǝ furakh sar ǝn ǝntla khaya Galili, ka nǝv Yasu tsitar, “A khǝrzǝgud da bǝkdu bǝg ka Zǝr Ud, da dǝva udakh. ");
INSERT INTO gdf_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Da kǝɗ ka kǝɗa itar. Fitsa khǝkǝrɗa ka da tsiya ka tsiyud.” Ka kǝɗatǝrkhe ad vǝgh kǝ furakhna char. ");
INSERT INTO gdf_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Sa kǝ Yasu zǝ furakh sar da kǝs Kafarnakhum, ka saks kǝ li chau khadama Fǝta Yazhigǝl da vak Bitrus, ka ndiɗarwal itar, “Nabakh dadak tsagdu lavur ǝn pǝl khadama Fǝta Yazhigǝla?” ");
INSERT INTO gdf_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ka ngawar khai Bitrus kwarne, “Ən pǝla pǝlin gǝna.” Da kǝ Bitrus da mǝghen, ka farsa Yasu ad kwarara lav, “Uɗa ɗayaghǝragh ǝn tǝghǝr kǝ ndiɗeni? Ən chawun vakǝng shikakh lard na ad khadama lǝman awana khadama gidadi? Ən vak zar tar nagha, ǝn vak kǝstǝlakh khi?” ");
INSERT INTO gdf_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nǝv Bitrus tsin, “Ən vak kǝstǝlakh.” Ka nǝv Yasu tsin, “Ai da ndǝkyanin, a mǝdlanan kwarne na zar tar ǝn pela pǝla bi.” ");
INSERT INTO gdf_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","“Ai khek bazatǝrdu tsǝki ad rǝva, dǝg dǝgal da tǝ ghay dǝlv, taldagh tala khilga vi kilf da dǝlv. Ka nguranǝf kha ghay kilfe a viga kha chak, da mbǝladu mbǝla kha lotus ai da tlala kǝ pǝl khadamagha zǝ dǝgar. Ɓǝfɓa, pǝla tǝrkhai pǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ən sartenan, ka sa furakh sar da vak Yasu ka ndiɗarwal itar kwarne, “Warek zikan daghan ǝn tlǝksa gharazhigǝli?” ");
INSERT INTO gdf_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Ka ɗakhga Yasu ad zǝr khǝɗikan, ka ghitsanan ǝn tǝb tar. ");
INSERT INTO gdf_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Ka ni, “Ən tǝkha kura tǝkha kǝ, da mbǝɗfǝkhe ba giɗur nala kur ndǝk zar mbisan bi, na kur da daks da tlǝksa gharazhigǝl lingling bi. ");
INSERT INTO gdf_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Itsawar ǝn gulandagh ghǝrsar ndǝk zǝr khǝɗikanǝn, in zikan daghan ǝn tlǝksa gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","“Ɗaga ude chauga zǝr khǝɗikan ndǝk inan wirva kǝ, ka chaukayin.” ");
INSERT INTO gdf_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Ya digi, ɗeghwa ude a ba ad fang ǝn tatak zar mbisan, liye fadǝghǝro dǝ kǝ, da man khaip. Adara nguɗarǝmud vǝr pǝkhǝn kwind sar, ka tlǝvdagh khud da dǝlve chalangw.” ");
INSERT INTO gdf_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","“Ɗangwa kǝ udakhe ǝn lard. Wirva dǝgakhe da bakh udakh da man khaipa, ǝn lard itar. Ya ɗangwa kǝ dadake da saks dǝgakhan ǝn tǝ dǝva din. ");
INSERT INTO gdf_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Da dǝvagha awana sigagh ǝn bǝg khan da man khaip, ǝntlǝdukha, tlǝvars khǝ. Adara daks dǝ dǝv kitakul, awana sig kitakul kha da safa kǝ ngǝɗ, tǝghǝr kǝ tlǝvǝkhǝdagh dǝ dǝvakhagh, awana dǝ sigakhagh bǝrdagh, da kare kwal nǝg ǝn mǝtsa kǝ ngǝɗ. ");
INSERT INTO gdf_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Da wur diyakhagh ǝn bǝg khan da man khaip tsugun, ndǝɗadal kha, tlǝvars khǝ. Adara daks dǝ di kitakul kha da safa kǝ ngǝɗ, tǝghǝr kǝ tlǝvkhǝdagh dǝ di bǝrkǝdagh da kare kwal nǝg ǝn mǝtsa kǝ ngǝɗ.” ");
INSERT INTO gdf_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Tsukwamana ghǝr, khayamanǝf ba nena itsa fang ǝn tǝɓ kǝ zar mbisana khana bi. Wirvǝn tǝkha kura tǝkha kǝ, zarɓǝlakh Yazhigǝl tar ai ǝn gharazhigǝl, tsika fatsi ǝn nǝgha nǝgha itar vakdi Dadare ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Wirva ka Zǝr Ud a saudagh da kat liye a zaɗgan kǝ. ");
INSERT INTO gdf_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“Uɗa ɗaya ghǝruri? Da nǝg ude dǝ tuwaghakh dǝrmǝk (100), da ka zaɗga kitakul ǝn tǝb tar, nabakhin da ɗuwars kul vaslambaɗ ghǝrf vaslambaɗ (99) nǝn kus kǝ ghuɓe zighwda itara? Kǝ dǝgal da gat kitakule zaɗgana? ");
INSERT INTO gdf_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Ən tǝkha kura tǝkha kǝ, da mbǝladu win ad kitakulen, khwaɗge da manin ǝn tǝghǝr kǝ kitakulǝn, da malamala ad dǝg kul vaslambaɗ ghǝrf vaslambaɗe kwal zaɗgan. ");
INSERT INTO gdf_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ndǝkyan tsugun, khayanǝf khaya Dadurǝn gharazhigǝl ba zaɗa kǝ itsa fang ǝn tǝb kǝ zar mbisana khana bi.” ");
INSERT INTO gdf_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Da manakhai sukwtagha ad ghaz, ka dǝgal kha da vak sar, kwarkhekha ghaza sar ǝn tǝbura mits mits. Da tsǝnkhayin, a guyondǝghǝr kha sukwtagh saks. ");
INSERT INTO gdf_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Ai da tsǝnkhe bin bi, ka gwidǝn dǝgala kha da vak sar zǝ ud fang. Wirva a kwarga lav Yazhigǝl kwarne, ‘Itsera kǝ lave a ndazhana ud mitsa zǝ khǝkǝrɗ, a mǝdlanan kwarne lavena jir.’ ");
INSERT INTO gdf_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Da kalwalin kǝ tsǝntǝr tsǝn, ka kwararkhe kha ke li gata daghan. Kǝ dǝg mbas, da kalwalin kǝ tsǝn lav li gaten daghan, ka nandala kha ndǝk liye kwal tsa Yazhigǝl, awana ndǝk dadak chau khadam. ");
INSERT INTO gdf_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Ən tǝkha kura tǝkha kǝ, daghan dǝge kwal khayanǝf tsǝkur manaman ǝn lard, na bud da manaman ǝn gharazhigǝl bi. Daghan dǝge khayanǝf kur manaman ǝn lard, da mana manud ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Ən gwidǝn kwara kura kwara kǝ, da khayanǝf ud mits ǝn tǝbur ǝn lard, ǝn tǝ ghǝr kǝ dǝge a takaɗga itar, da manatra mana Dadare ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Wirva daghan vake dzafkhai ud mitsa zǝ khǝkǝrɗ ǝn ɗakhar, ǝn vak tar kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ka sa Bitrus da vak Yasu, ndiɗarwal kwarne, “Dadzikan, da ka manakhaka ghaza sukwtar, sig ngǝrwa da ɓisakhara ki? Sig uɗif nagha?” ");
INSERT INTO gdf_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","“Ka ngawar khai Yasu kwarne, uk uɗif siga bi, uɗif uɗif sig kul uɗif. ");
INSERT INTO gdf_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“Wirva yan, da tǝkhud kǝ kurana tlǝksa gharazhigǝl dǝ shike ǝn nagh kǝdla lǝmanakh sare ǝn dǝv kǝ vǝɓakh sar. ");
INSERT INTO gdf_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Farsa kǝ shiken ad kǝdla kǝdla, ka ɓardǝghǝr ud ad ude gatarsin dǝ gǝmaw kwaɓ talenti dǝb kǝlɗǝk (10,000), ai kwal da tǝkha kǝ udanen kǝ pelgan mbasu ba dǝ giɗa sar ǝn lard bi.” ");
INSERT INTO gdf_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","“Piyarwala kǝ pǝlapǝl, ka kwarga shik kwarne, sukwamdu sukwa dǝ udanen, zǝ nus sar, zǝ zar sar, zǝ daghan dǝge dinin, kǝ nǝghda pelda gǝmawen din.” ");
INSERT INTO gdf_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“Ka diktliɓ kǝlga vǝɓen ad juguv ǝn tǝvuk kǝ shiken, ǝn takaɗa takaɗa kwarne, ‘Bakai rǝv, da pǝlakha pǝla ka itsauɗ.’ ");
INSERT INTO gdf_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Ka ziwardal shiken kǝ vǝɓen, ka ɓǝlars, ɓisarnan ad gǝmawen. ");
INSERT INTO gdf_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“Sawala kǝ vǝɓen ǝn fǝta shiken, papatl ka gamga itar ze tsaghw man tlǝr sare ǝn gatarsin dǝ gǝmaw kwaɓ dinari dǝrmǝk (100), ka vigan ǝn makular, niya tsin, ‘Pǝlakai pǝla gemaware ǝn gatakhs kǝ.’ ");
INSERT INTO gdf_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","“Ka diktliɓ kǝlga tsaghw man tlǝr sar ad juguv ǝn tǝvuk sar, ǝn takaɗa takaɗa kwarne, ‘Bakai rǝv, da pǝlakha pǝla kǝ.’ ");
INSERT INTO gdf_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","“Kalwala kǝ ɓisara ɓis, ka ɓal dǝgal da gud sal, khekwa pǝlarkheyin ad gǝmaw saren ndan. ");
INSERT INTO gdf_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nǝgha kǝ chalǝm zar man tlǝr ad dǝge dzaughǝr, a zǝɗatru ba lingling bi. Ka dala itara, kwararkhe itar kǝ shik, ad dǝge dzoghǝr daghan. ");
INSERT INTO gdf_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","“Ka ɓǝlandala shik kǝ ɗakha dǝghǝr vǝɓena tsa chak. Sa tsin, ka nǝv shiken tsin, ‘Kha nguɗi vǝɓǝn. A ɓisakhana ka ad daghan gǝmawe ǝn gatakhs kǝ, wirva takaɗke khǝ. ");
INSERT INTO gdf_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Atsuk ǝn tǝkh ba kha kǝ manga kwiɗkwiɗǝreva tsaghw man tlǝragh, ndǝkve manga ka kwiɗkwiɗa revagh biya?’ ");
INSERT INTO gdf_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","A bazala rǝv kǝ shik char, ka batrǝm shik ǝn dǝv kǝ li ǝn tuk gud salen, bara bǝg itar dlaɗ, da tǝ sarte da pǝldin ad gǝmaw kwaɓ na daghan.” ");
INSERT INTO gdf_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“Da mana ndǝk yan Dadare ǝn gharazhigǝl, ak itsawar ǝn kur ai kalwala kǝ ɓisara kǝ zǝrbab sar, ǝn revakhuɗ sar.” ");
INSERT INTO gdf_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Udzala kǝ Yasu ǝn kwar dǝgakhana, ka ɗuwars ad ǝntla khaya ya Galili, ka dal da ǝtla khay ya Yakhudi, ai ǝn tǝ ghǝdzǝva gadzak zagh Urdu. ");
INSERT INTO gdf_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Zikǝn udakhe a gatars, ka mbandu ad liye ǝn tukw kuz ǝn vin. ");
INSERT INTO gdf_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Ka saks kǝ yakhaya kǝ Farisakh da vak sar, kǝ nǝghda gat ghaza sar tsitar. Ka ndiɗarwal itar kwarne, “A khayanǝf nagh ndzikh khǝnd ad tǝkaghǝra kǝ ud ze nus sar, ǝn tǝ itsera kǝ dǝge kwal nagha tsina?” ");
INSERT INTO gdf_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ka ngawa tǝrkhai Yasu kwarne, “Atsuk a tugwa bakh kur ǝn kaɗkaɗ ǝn vake tsǝn kwarin kwarne, dadake tsa vǝrɗtǝrkhe vǝrɗa gul farsafǝga larda, ‘A vǝrɗtǝrkhe kǝ zila zǝ nusa?’ ");
INSERT INTO gdf_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","A kwarga Yazhigǝl tsugun kwarne, ‘Wirva yan digi, da ɗuwar ɗuwa udan ad dad sar zǝ bab sar kǝ khǝmbarvan kǝ nus sar, kǝ nǝga tsitar bǝrdagh kǝ ud kitakul.’ ");
INSERT INTO gdf_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Wirva yana, aghba dlaitar dǝ ud mits bi, a narala kǝ ud kitakul. Wirva yan, dǝge a matlanǝf Yazhigǝl, khayanǝf ba ud ad tǝka tǝka bi.” ");
INSERT INTO gdf_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Ka ndiɗarwal Farisakhen kwarne, “Ai uɗa lava kǝ Mus tlayang a bǝdu ad ndzikha ndzikh kǝ ud kǝ bǝdu kaɗkaɗ tǝkaghǝra zǝ nus sar, kǝ dǝgala tsini?” ");
INSERT INTO gdf_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Ai ka ngawa tǝrkhai Yasu niya tsitar, “A khayakurnǝf Mus tlayang ak tǝkaghǝra zǝ nughwasakhur, wirva ɓengɓeng revakhuɗur kǝ mangan, ai gul ǝn tǝ farsafǝga tsa ndǝk yan bi. ");
INSERT INTO gdf_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Ai ǝn kwara kura kwara kǝ, ɗaga ude tǝkaghǝran zǝ nus sar, da wirva a tlarghǝr ǝn man gwaragwar bud bi, da ɓuwin ad tlǝrna nus tsugun, gwaragwar ǝn manin zǝ nusen.” ");
INSERT INTO gdf_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Ka nǝv furakh sar tsin, “Da ka ndǝk yan giɗǝn tǝb kǝ ud zǝ nus sara, atsuk giɗa kwal nus kaw.” ");
INSERT INTO gdf_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ai ka nǝv Yasu tsitar, “Daghan ud bǝn tǝkha kǝ ɓanǝf lava nǝn kwara kur bi, khekwa liye a khayatǝrnǝf Yazhigǝl kǝ nǝga ndǝk yan. ");
INSERT INTO gdf_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Nǝg dǝgakhe da bǝg chalǝm ghwalvakh kwal da zǝɓ nus. Wirva nǝg liye a yakhtǝr khaiyud ndǝk yan. Nǝg liye udakh kǝ natǝrala ndǝk yan. Yakhaya tsuguna itar kǝ nandala ghǝrtar kwal da nǝg da zǝɓ nus, wirva tlǝr tlǝksa gharazhigǝl. Ɗaga ude khayanǝf dǝ lava na, chawin.” ");
INSERT INTO gdf_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Khalak yana, zaɓardǝghǝr yakhaya kǝ udakh ad zar mbisan kǝ Yasu, kǝ nǝghda batǝrghǝr dǝv tsin, kǝ takaɗ Yazhigǝl wirva itar. Ai ka tav di kǝ furakh sar ǝn tǝ li zaɓado zaren. ");
INSERT INTO gdf_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Ka nǝv Yasu kǝ furakh sar, “Ɗuwamatǝrs zar mbisan saks da vakar, tsuwamatra bi. Wirva tlǝksa gharazhigǝla dǝg udakhe ndǝk zar mbisanakhan.” ");
INSERT INTO gdf_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ka bakhatǝrghǝr ad dǝva, ka takaɗgan ad Yazhigǝl kǝ batǝrghǝr bark, ka dakaval ǝn vin. ");
INSERT INTO gdf_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Dud ǝn manin, ka sa udanen da vak Yasu niya tsin, “Malǝm, uɗa dǝg khwarane barari da mana ka kǝ gǝmadu safa kǝ ngǝɗi?” ");
INSERT INTO gdf_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Nǝv Yasu tsin, “Uɗa lava tsǝkhǝn ndiɗakwala ndiɗ ǝn tǝghǝr kǝ dǝge khwarani? Afke uk Yazhigǝl kitakul khwarana. Ai da ka da nakha gǝmadu safa kǝ ngǝɗ, ka tsufanǝf kha ndzikha ndzikh Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Ka ndiɗarwal kǝ Yasu, “Irǝn ndzikha ndzikhen ra?” Ka ngawarkhe Yasu, “Kǝɗ ba safa ud bi, a ɗuwa gwaragwar, a ɗuwa man gǝl, a ɗuwa dlǝgh fil, ");
INSERT INTO gdf_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","farghǝr fǝg kǝ dadagha zǝ babagh. Tsǝguna waya tlǝghǝr witǝghagh ndǝkve waya kha ghǝragh.” ");
INSERT INTO gdf_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Ka nǝv dakhwal na tsin, “Afka ǝn tsufatsufa ka dǝgakhana daghan. Uɗa kǝ tǝmgan tsǝki?” ");
INSERT INTO gdf_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Ka nǝv Yasu tsin, “Dǝn nakha nǝga tsǝkha kǝ njiva char, dǝg da sakwdu dǝge din kha daghan, tǝkatǝrdukha kǝ talagakh ad kwaɓen. Da mbǝladu mbǝla kha lǝman ǝn gharazhigǝl. Khalak yana, ka saks kha, gatakskh.” ");
INSERT INTO gdf_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Tsǝna kǝ dakhwalen ndǝk yana, ka dǝgal tsin dǝ baza rǝvakhuɗ. Wirva naghbakha tluwandal tsin bi. ");
INSERT INTO gdf_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Ka nǝv Yasu kǝ furakh sar, “Ən tǝkha kura tǝkha kǝ, da ɗǝmɗǝm kǝ dadak tluwandal daks da gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Ən gwidǝn kwara kura kwara kǝ, da tsaftsaf kǝ dlugwam daks ǝn tǝ ɗul lipǝr, tǝghǝr kǝ daks kǝ dadak tluwandal da tlǝksa Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Tsǝna kǝ furakh sar ndǝk yana, ka a ndawatrǝf char. Nǝv itar, “Da ka ndǝk yanina, ai war da mbǝladu kati?” ");
INSERT INTO gdf_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ka vaza kǝ Yasu gyer ta titar, ni, “Ən vak uda, ina kǝ digita ǝn manawa bi. Ai ǝn vak Yazhigǝla, ǝn manawa man.” ");
INSERT INTO gdf_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Ka nǝv Bitrus tsin, “Nǝgha, kǝnda kina a ɗuwars kǝnda tsauɗa kǝ gatakhs gat. Ai takina uɗa da mbǝladu kǝndi?” ");
INSERT INTO gdf_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Ka nǝv Yasu tsitar, “Ən tǝkha kura tǝkha kǝ, sarte da mbǝɗanǝfud ad itsauɗa kǝ wiliw, ka Zǝr Ud da nndzǝgan kǝn tǝ vija tlǝksare ndagan. Kuram liye gataks gat, da nndzǝgan kur ǝn tǝ vijakh man tlǝks kǝlatǝm mits. Da taka tǝra lava kur kǝ mbǝrta ya Izrail na kǝlatǝm mits. ");
INSERT INTO gdf_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Tsuguna itsawar ǝn ɗuda fǝtakha sar, itsa sukwtakh sara, zǝ dǝghaw babagh sar, itsa dad, itsa bab, itsa zila awana nus, itsa zar, awana gukhakh, wirva kǝ. Da mbǝladu mbǝla mal kǝ yan sig dǝrmǝk. Wur tsuguna, da wurawura ad safa kǝ ngǝɗ. ");
INSERT INTO gdf_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Ai tsugun, udakh zikǝn liye ǝn tǝvuk, da nǝga itar kǝ dǝg khal. Liye kǝ khal tsuguna, da nǝga itar kǝ dǝg chak.” ");
INSERT INTO gdf_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Tlǝksa gharazhigǝla ngwaɗa dadak gukhe a dala pǝrta gǝdl, da gat li da manara tlǝr ǝn gukh inabi sar. ");
INSERT INTO gdf_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Udzala tsitar ǝn khayanǝf lav ǝn tǝghǝr kǝ kwaɓ dinari kitakul, ai da pǝlarud kǝ ud ǝn vak. Ka ɓǝlatǝral dǝgal da man tlǝr ǝn gukh sar. ");
INSERT INTO gdf_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","“Manga kǝ karfi vaslambaɗa tǝkǝdl, ka gwidǝn dǝgal tsin. Ka nǝghan ad yakhaya kǝ udakh, ǝn giɗa butbuti ǝn tǝghay kasuk. ");
INSERT INTO gdf_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Ka niya tsitar, ‘Dam dǝgal ghǝrura da man tlǝr ǝn gukh inabiyar. Da pǝla kura pǝla ka dǝge vazga ka khwara kǝ bakura bǝg.’ ");
INSERT INTO gdf_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Khalak yana, ka dǝgal tsitar. “Ka gwidǝn dǝgala tsin kǝ fatsi tǝghǝr, zǝn karfi khǝkǝrɗ kǝ khagw, ka kurgan ad gan zitar ndǝkve tsa mangin chak. ");
INSERT INTO gdf_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Dakhkana, ka gwidǝn sǝgawal tsin ǝn tǝ karfi dliɓ, ka tlarghǝr ad yakhaya kǝ udakh, ǝn ghitsa na dǝge ǝn mana itar bi. Ka ndiɗatǝrwal, ‘Uɗa lava tsǝkur birnif ǝn giɗa ǝn van, kwal nǝg kǝ dǝge ǝn manakuri?’ ");
INSERT INTO gdf_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","“ ‘Wirva na ude bakǝnda tlǝr mana bi,’ nǝv itar tsin. “Ka nǝv dadak gukhen tsitar, ‘Damdǝgal ghǝrur tsugun da gukhar.’ ");
INSERT INTO gdf_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Ɓǝlga kǝ khagwa, ka nǝv dadak gukh kǝ dadak nǝgharu kǝ gukh saren, ‘Ɗakhtǝrkhe ɗakha kǝ li mantlǝren, pǝlatǝrkhekh kwaɓ tar, farsǝf ǝn tǝ li sa kǝ khala, da tǝ li tsa chak.’ ");
INSERT INTO gdf_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","“Ka saks kǝ li tsa dalǝn karfi dliɓ, itsawar tara a gǝmadu ad dinari kitakul. Ai pǝlarud kǝ ud ǝn vak. ");
INSERT INTO gdf_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Liye tsa farsa man tlǝr chak, da itar ǝn kurana, da pǝlatra mal kǝ chalǝmakhud. Ai itsawar tara a gǝmadu ad dinari kitakul. ");
INSERT INTO gdf_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Chauga tsitar, ka farsa ɗungw tsitar ak dadak gukh. ");
INSERT INTO gdf_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","Ən kwar kwarne, ‘Li sawala kǝ khala, uk tlǝr aw kitakul a manga itar. Kǝnde a vakal ǝn man tlǝr, zǝ bǝg rǝv ǝn tǝ dliya fatsi, ka pǝla kǝnda kalkal kha zǝ itar.’ ");
INSERT INTO gdf_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","“Ka nǝv dadak gukhen kǝ ud fang ǝn tatak tar, ‘Ar tsaghwa, a biɗkurkhe ba ka bi. Tsa khayanǝf bakh kur kwarne, da ba kura kwaɓ dinari kitakule ǝn pǝlarud kǝ ud ǝn vaka biya? ");
INSERT INTO gdf_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Chaukafkhai chawa dǝge dǝgagh, dǝg daksagh. Ka kǝ khayanǝf barabǝg kǝ li sa kǝ khal, kalkal de bakha kǝ. ");
INSERT INTO gdf_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nakh ka dǝ ndzǝɗa mankafkhe dǝge naghga ghǝrara dǝ dǝge dǝgara? Ən shilga ndar kha man kǝlakhuɗari?’ ");
INSERT INTO gdf_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","“Wirva yan, udakh zikǝn liye ǝn tǝvuk, da nǝga itar kǝ dǝg khal. Liye kǝ khal tsuguna, da nǝga itar kǝ dǝg chak.” ");
INSERT INTO gdf_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Madǝv Yasu ǝn dǝgo da Wurshalim. Ka ɗakhtǝrkhai ak furakh sar na kǝlatǝm mits da tǝ kalam. Ka niya tsitar, ");
INSERT INTO gdf_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Nǝgha kina ni dǝgal da Wurshalim kiyam. Vake da bǝkduwud ka Zǝr Ud da dǝva zikzikana kǝ zil kǝsakh zǝ malǝmakh li tsagdu ndzikha ndzikh Mus. Ka da ǝntlaka lav mǝts itar. ");
INSERT INTO gdf_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Ən tǝ khalak yana, ka da bǝkdu bǝg itar kǝ liye kwal Yakhudakh. Da nena ka nene tar, ka da wadzaku kiɓ itar, ka da khǝrtǝka khǝrta itar tsugun. Ən tǝ fitsa khǝkǝrɗ tsuguna, da tsiya ka tsiyud.” ");
INSERT INTO gdf_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Khalak yana, ka saks kǝ nus Zabadi dǝ zar sar mits da vak Yasu. Kǝlgan ad juguv ǝn tǝvuk Yasu, ka takaɗ digit tsin ǝn vak sar. ");
INSERT INTO gdf_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","“Uɗǝn nakhara?” Nǝv Yasu. Ka nǝv nusen kǝ Yasu, “Manakai lanji kǝ zararana mits, tsa ndzǝga itar zǝ khǝn tlǝksagh. Fang ǝn tǝ dǝva kafagha, fang ǝn tǝ dǝva dleɓagh.” ");
INSERT INTO gdf_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Ai ka nǝv Yasu kǝ nusen, “Əntsa ba kur dǝge ǝn takaɗa kur bi. Da tǝkha kur kǝ khǝɓu dlaɗe da khǝɓa ka?” “Da tǝkha kǝnd,” Nǝv itar tsin. ");
INSERT INTO gdf_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Ka nǝv Yasu, “Kaɗikaɗiya da khǝɓa khǝɓa kur dlaɗ, ai giɗǝn tǝ dǝva kafara, zǝ giɗǝn tǝ dǝva dleɓara, na ka dǝ ndzǝɗa zǝɓǝf ude da bara ka yan bi. Ina kǝ vakakha, dǝg liye ɗikatǝrna Dadare ǝn gharazhigǝl wirva itar.” ");
INSERT INTO gdf_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Tsǝna kǝ chalǝm furakh khana kǝlɗǝk ndǝk yana, ka bazdu itar ad rǝv dǝ zar babakhana mits. ");
INSERT INTO gdf_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Ka ɗakhtǝrkhe Yasu daghan tar, ni, “Tsa tsǝkur kwarne shikakh udakhe kwal Yakhudakha, ǝn mǝdlara ndzǝɗǝn itar kǝ udakh tar. Zikzikanakh tar tuguna, ǝn mǝdla ndzǝɗ itar ǝn tǝ ghǝr tsitar. ");
INSERT INTO gdf_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Ya kur tsuguna, nala bin ndǝk yan ǝn tǝbur bi. Ən dleva yan, ɗaga ude ǝn nagh nǝga kǝ zikan ǝn tǝbur, barari tsin nǝga kǝ vǝɓur. ");
INSERT INTO gdf_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Tsugun, ɗaga ude na nǝga kǝ mal ǝn kur, barari tsin nǝga kǝ vǝɓur. ");
INSERT INTO gdf_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Udan na tsuguna, da nǝga ndǝk va kǝ, ka Zǝr Ud, a sodagh kǝ ɗaba udakh kǝ, a so kǝ ɗaba ka ɗaba bud bi. Da bǝdu bǝg ka tsugun ad safar, kǝ kat da udakh zikǝn.” ");
INSERT INTO gdf_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Madǝv Yasu zǝ furakh sar ǝn ɗuwars kǝs Jariko, zikǝn dzakhava udakh ǝn gatatǝrs gat. ");
INSERT INTO gdf_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ka nǝg ngulfakh mits ǝn nndzǝgan ǝn tǝ kalam ɗul. Tsǝna tsitar kwarne Yasu ǝn dǝgala, ka tlǝkha tsitar kwarne, “Dadzikan, Zǝr Dod, manga kwiɗkwiɗǝrǝvǝnda.” ");
INSERT INTO gdf_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Ka tavdi kǝ chalǝm ǝn tǝb kǝ dzakhava udakh ǝn tǝghǝr tsitar kwarne, “Tǝriɗ nikur.” Ka gwidǝn tlǝkha tsitar char kwarne, “Dadzikan, Zǝr Dod, manga kwiɗkwiɗǝrǝvǝnda.” ");
INSERT INTO gdf_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Ka ghitsǝga Yasu, ka ɗakhtǝrkhai saks, ka sa itar. Niya tsitar, “Uɗǝn na kur mana kura mana tsǝki?” ");
INSERT INTO gdf_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Ka nǝv itar tsin, “Dadzikan, na kǝnda ngwarǝf diyakhǝnd.” ");
INSERT INTO gdf_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Wirva kwiɗkwiɗǝrva, ka gǝma Yasu ad diyakh tar. Tǝvin tǝvina ka nǝgha nǝgha itar. Ka gatars itar. ");
INSERT INTO gdf_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Sa tsitar khefa dǝ Wurshalim, sara da kǝs ya Betafaji, ǝn Ghuɓa Olive. Ka ɓǝlandal Yasu ad furakh sar mits. ");
INSERT INTO gdf_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Niya tsitar, “Damaks da gǝdzar kǝs nǝn tǝvukur. Ba kurǝn daksa, da nǝgha nǝgha kur bab dlingw zǝ gǝlaɓa sar ngwaɗan. Vǝdamatǝrs vǝd, ka ɓakdǝghǝr kur. ");
INSERT INTO gdf_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Da kwara kurkhe udan ad tlǝrna lav, kwararkhe kur kwarne, ‘Dadzikan ǝn naghtǝran.’ Dlaɓ da wura tǝra wura zula khǝɗikǝn.” ");
INSERT INTO gdf_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ina kǝ dǝge dzoghǝra, a righif dǝge tsa kwarga Ishay tlayang. Ni, ");
INSERT INTO gdf_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Kwaramatǝra kwara kǝ udakh ya Wurshalim,” “Niya shikur ǝn saks da vakur. Nagh bakh kalali tsin bi, ǝn dǝg ǝn tǝ dlingw, Ən dǝgǝn tǝ gǝlaɓa dlingw.” ");
INSERT INTO gdf_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Ka dǝgal kǝ furakh saren, manga itar ndǝkve tsa kwaratǝrkhe Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Ka ɓadǝghǝr itar dlingwen zǝ zer sar. Ka ɓalakho itar gabagakh tar ǝn titar, in tsuguna dowa nndzǝgan ǝn tǝf. ");
INSERT INTO gdf_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Zikǝn udakhe ɓalakhga gabagakh tar ǝn tǝ ɗul. Ka kalakhga yakhaya tsugun ad tlim uf, ka ɓalakhga itar ǝn tǝ ɗul. ");
INSERT INTO gdf_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Udakhe ǝn tǝvuk sar zǝ liye ǝn gatars gatǝn tǝlga, ka tlǝkha tsitar kwarne, “Bark kǝ Zǝr Dod.” “A ndzawa bark kǝ dadake ǝn sǝgdagh ǝn ɗakha Dadzikan.” “Farghǝrfǝgud kǝ Yazhigǝle ǝn khuɗ kǝ gharazhigǝle chakw.” ");
INSERT INTO gdf_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Da kǝ Yasu da Wurshalima, ka tsiyif mǝkǝn kǝ li kǝsen daghan. Ka ndiɗakave tar kwarne, “Warinena kudra?” ");
INSERT INTO gdf_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ka nǝv dzakhava udakhen, “ Ina Yasu tlayange ǝn Nazarat ǝn kǝs Galili.” ");
INSERT INTO gdf_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Da kǝ Yasu da Fǝta Yazhigǝl, lakwtǝrdu kǝ li dzawa zǝ li sakw digit ǝmb. Ka khambanǝf ad vǝlenga li mbaɗu kwaɓ. Ka khambanan ad vak ndzakhgan li sakwdu takalamasar. ");
INSERT INTO gdf_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Ka nǝv Yasu tsitar, “A vindzavan ǝn kaɗkaɗ Yazhigǝl kwarne, ‘Da ɗakh mǝgharud, mǝghe da ɗǝgawud ǝmb.’ Ai a nandala kur kǝ vak ɓǝghava sǝnkarakh.” ");
INSERT INTO gdf_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Ka saks kǝ ngulfakh zǝ ghwirɗikakh da vak sar ǝn Fǝta Yazhigǝl, ka mbakhatru. ");
INSERT INTO gdf_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Zik zikan na kǝ zil kǝsakh, zǝ li tsagdu ndzikha ndzikh Mus, nǝgha tsitar ad dǝg ndawakakhe a mangin. Tsuguna, tsǝna tsitar ad tlǝkh kǝ zar ǝn Fǝta Yazhigǝl kwarne, “Bark kǝ Zǝr Dod.” Ka bazala rǝv tsitar. ");
INSERT INTO gdf_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Ka ndiɗarwal itar kǝ Yasu, “Ən tsǝna tsǝna kha dǝge ǝn kwara zara na kina?” Ka nǝv Yasu tsitar, “Ən tsǝna tsǝna ka gǝn. Atsuk a taɓa bakh kur tugwado tugw ǝn vindzan na kǝ lav Yazhigǝl kwarne, “ ‘A batrǝm ǝn ghai kǝ zara zǝ vunjakh ka de mbaɗkhambaɗ.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ka ɗuwatǝrs ǝn vin. Sawala, ka dal da kǝs ya Betani. A khǝnal ǝn vin. ");
INSERT INTO gdf_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Ngurga kǝ kǝs, madvin ǝn saks da Wurshalim, ka ndzikǝnǝf way. ");
INSERT INTO gdf_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nǝgha tsin ufa ghǝdiven ǝn tǝ kalam ɗul, ka dal da vak ufen, na dǝge mbǝladuwin ǝn tǝf bi, uk tlim sar. Ka niya kǝ ufen, “Aghba kha da yig zǝr kǝ ngǝɗa bi.” Tǝvin tǝvina ka ghulkavala ufen. ");
INSERT INTO gdf_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Nǝgha kǝ furakh sar ndǝk yana, ka ndawatrǝf char. “Uɗa lava kǝ ufa ghǝdivena ghulkavala gujaɗ ndǝk ini?” Nǝv itar. ");
INSERT INTO gdf_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ka ngawa tǝrkhai Yasu, ni, “Ən tǝkha kura tǝkha kǝ, da nǝg kur dǝ fadǝghǝrofǝg, tsuguna a bǝga ba kur tsugu tsa khǝɗikǝn bi, da tǝkha kur kǝ mangan mal kǝ dǝge a manarkhe ka kǝ ufa ghǝdivǝn. Tsugun, da tǝkha kur kǝ kwarkhai kǝ gil zikan kwarne, ‘Tsiyin tǝvan, ɓǝlvǝdagh ɓǝla da dǝlv.’ Ka da dzoghǝr dzǝg ndǝk yan. ");
INSERT INTO gdf_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Da fadǝghǝro kur, ɗaga dǝge takaɗga kur ǝn vak Yazhigǝl ǝn ɗǝgau, da mbǝladu mbǝla kur.” ");
INSERT INTO gdf_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Sa kǝ Yasu da Feta Yazhigǝl, madvin ǝn tsagdutsag, ka sasǝg kǝ zik zikan na kǝ zil kǝsakh, zǝ malakh tar kǝ dlamakh da vak sar. Ka nǝv itar, “Ən mana dira kǝ ndzǝɗa kha dǝgakhani? Tsuguna war kǝ bakhena kǝ ndzǝɗi?” ");
INSERT INTO gdf_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ka ngawa tǝrkhai Yasu kwarne, “Ghǝrara tsugun khine da ndiɗakurwala ndiɗa kǝ. Da ngawake kur ndiɗar, ghǝrar tsuguna, da kwara kura kwara ka ad ndzǝɗakhe ǝn manakh da ka dǝgakhan. ");
INSERT INTO gdf_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","A so dǝvara ndzǝɗe ǝn parada Yukhan dadak para ud ad udi? A so ǝn vak Yazhigǝle, awana a so ǝn vak ud khi?” Ka farsa tsugu tsitar ǝn tatak tar, kwarne, “Da ka ǝn vak Yazhigǝla nikiyam, ka da ndiɗa kiyamwal ndiɗa kwarne, ‘Ai uɗa lava tsukur kwal fadǝghǝro dini?’ ");
INSERT INTO gdf_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","“Ai daka ǝn vakuda nikiyam, ǝn gǝdza kiyam kǝ dǝge da mana kiyama udakh. Wirva a fadǝghǝro udakh daghan kwarne tlayang Yukhan.” ");
INSERT INTO gdf_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ka ngawarkhai itar kǝ Yasu kwarne, “Ən tsa ba kǝnda bi.” Ka nǝv Yasu tsitar, “Ai na ghǝrara da kwara kura khulf ndzǝɗe ǝn manakha ka dǝgakhana bi.” ");
INSERT INTO gdf_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Uɗǝn ɗaya kur ǝn tǝghǝr kǝ ina kǝ lavi?” Ai ǝn kwarin kwarne, nǝg udanen mits zar ghwalvakh tsin. Ka dǝgal tsin da vak malan, niya tsin, “Zǝrara, dǝg dǝgal da mantlǝr ǝn gukh inabi khan.” ");
INSERT INTO gdf_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Ka niya tsin, “ ‘Na kǝn dǝgal bi,’ Ai kǝ khala ka ɗayanan ad ghǝra, ka dǝgal tsin.” ");
INSERT INTO gdf_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","“Dǝgal kǝ daden da vak yan kǝ zǝr sar, kwararkhai ndǝkve tsa kwarar khaiyin kǝ dǝg chak. Ka ngawarkhai zǝr saren kwarne ‘Aya dada, da dǝgal kǝ,’ Ka dal ba tsugun bi.” ");
INSERT INTO gdf_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","“Ən tǝb tar na mitsa, war kǝ manga dǝge na dad tarni?” “Dadake tsa chak na,” Nǝv itar. Ka nǝv Yasu tsitar “Ən tǝkha kura tǝkha kǝ, li chau khadama zǝ garnakakh, itar da dagh da tlǝksa Yazhigǝl tǝghǝr kǝ tsǝkur. ");
INSERT INTO gdf_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Wirva a sodagh Yukhan da mǝdla kura ɗul kanadi, a fadǝghǝro ba kur din bi. Ai li chau khadama zǝ garnakakh, a fadǝghǝro itar din. Tsakhǝnmin nǝgha tsǝkur ndǝk yan, a mbǝɗanǝf ba kur rǝvura ka fadǝghǝro kur din bi. ");
INSERT INTO gdf_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“Bambǝg tlim kǝ tsǝn tlǝrna jakva lava tsugun. Nǝg udanena, a njavgan ad gukh inabi. Tsarghǝran dǝ ghǝrgh, tǝfgan ad fike da pǝrtsin ad yu inabi ǝmb. Ɗikanan ad tsǝɓana kǝ vak, ki dǝgo kǝ dadak uf chau kǝ nǝgharu kǝ gukh. Ka batrǝm ad gukh inabi ǝn dǝv kǝ yakhay, kǝ nǝgharu nǝgha tsitar. Khala kǝ yana, ka dal da tlǝrna khaye bit. ");
INSERT INTO gdf_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Manga kǝ sarta tsǝg zar inabi, ka ɓǝlanǝf ad zar man tlǝr sar, da vak li batrǝmin ad gukh inabi ǝn dǝv tar. Kǝ chawardǝghǝr dleva dǝg sar, ak zar inabiyen. ");
INSERT INTO gdf_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","“Tǝkǝn liye nǝgharu kǝ gukhen, ka vaitǝrkhai itar kǝ zar man tlǝr saren. Mbakǝn itar dǝ kǝɗa kǝ yan. Kǝɗga itar ad yan kǝ mǝts. Laiga itar ad yan dǝ kurakh, ka amtsǝgan. ");
INSERT INTO gdf_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ka gwidǝn dadak gukhen ad ɓǝla tlǝrna zar man tlǝr sar mal ke tsa chak. Ka gwidǝn manarkhai li nǝgharu kǝ gukhen, ndǝkve tsa manarkhai itar kǝ li tsa chak. ");
INSERT INTO gdf_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Kǝ dǝg mbasa, ka ɓǝlanǝf dadak gukhen ad zǝr sar dǝgal da vak tar. Avin, ‘Na tsugu bi, da farghǝrfǝg itar kǝ zǝrar.’ ");
INSERT INTO gdf_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“Nǝgha kǝ li nǝgharu kǝ gukhen ad zǝren, ka nǝv itar ǝn tǝb tar, ‘Auna dadake da wur gukhen ǝn saks. Kǝɗyamga kǝɗ. Dǝgakhe da wurina, nǝgin kǝ dǝg mar.’ ");
INSERT INTO gdf_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ka viga itar, tlǝvars itar da tilg lingwa gukh Inabi, kǝɗga itar. ");
INSERT INTO gdf_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ka nǝv Yasu, da soghǝr dadak gukh na ma, ka uɗa da manarin kǝ li nǝgharu kǝ gukheni?” ");
INSERT INTO gdf_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ka nǝv itar tsin, “Da khǝdztǝr khǝdza kǝ nguɗiyakhen ǝn tǝ ɗule kwal khwara kǝ vaz. Ka da bara kǝ yakhay ad nǝgharu kǝ gukhen. Liye da bakhara dlǝva dǝg sar, ak zar inabi ǝn sarta tsǝga tsǝg.” ");
INSERT INTO gdf_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Nev Yasu Tsitar “Atsuk a taɓa bakh kur tugwado tugw ǝn vindzan na kǝ lav Yazhigǝla? Ai kwarin, “ ‘Kure a ɗuda li khǝga kǝ man tlǝr din. In kǝ nala kǝ kure, a khutanan ad khǝg. Ina kǝ digita tlǝr Yazhigǝl, tsuguna dǝg ndaw ndawan ǝn diyakh mar.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“Wirva yan, ǝn tǝkha kura tǝkha kǝ, da chawa chawud tlǝksa Yazhigǝl ǝn vakur. Da bara kǝ udakhe da man dǝg khwaranakh ai da yara zǝre da dlayaru kǝ tlǝksa Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Ɗaga ude da ɓǝlo da tǝ kuren, da kala khwetl khwetl. Ude da ɓǝlo kurna da tǝf tsugun, da pǝkha pǝkha kurɗik ndǝk khǝpi.” ");
INSERT INTO gdf_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Tsǝna kǝ zik zikan na kǝ zil kǝsakh, zǝ Farisakh ad yan kǝ jakva lavakhe kwargin, ka katlga itar kwarne ǝn kwarǝn tǝghǝr kǝ tsitar ad lavan. ");
INSERT INTO gdf_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","A gatga itar ɗul kǝ viyavi. Ai ǝn gǝdza itar kǝ dlamakh. Wirva a fadǝghǝro udakh daghan kwarne tlayang Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","A gwidǝn Yasu ǝn kwara tǝra lav dǝ jakva, ni, ");
INSERT INTO gdf_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Tlǝksa gharazighǝla ngwaɗa shike, a ɗikarnan ad khwaɗga sǝba kǝ zǝr sar. ");
INSERT INTO gdf_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ka ɓǝla tǝrǝf kǝ zar man tlǝr sar, kǝ dǝgal da kwara tǝra kǝ udakhe tsa ɓalgin. Ka kalwal itar kǝ sausǝg. ");
INSERT INTO gdf_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","“Ka gwidǝn ɓǝlatǝrǝf kǝ tlǝrna zar man tlǝr sar kwarne, ‘Kwarama tǝrkhai kwara kǝ liye tsa ɓalgud kwarne, Niya audzala kǝn takhga dǝg zu, a kharga ka kawakh, zǝ kawakh gude tsa ngalgud wulǝklǝk. Itsauɗa audzandalud. Ausǝgam da vak sǝb.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","“Li tsa ɓalgud da vak khwaɗgen, na ɗangwa tsitar dǝ ɓalen bi. Yana dakaval da gukh, yan tsuguna dakaval da man kasukw sar. ");
INSERT INTO gdf_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Yakhaya tsuguna, ka vaige tar liye tsa ɓǝla tǝrǝfuden, ka mbatǝre tar dǝ dlaɗ char, ka khadztǝr khai itar. ");
INSERT INTO gdf_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Ka kǝɗga rǝvakhuɗ ad shik char. Ka ɓǝlanǝf ad tlujiyakh sar, dǝgal da khǝdz liye tsa khǝdzga zar man tlǝr sar. Ka ndǝghǝrs itar kǝs tar. ");
INSERT INTO gdf_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","“Tǝkhal kǝ yana, ka niya kǝ zar man tlǝr sar, ‘Audzandalud ɗikana dǝg zuwa khwaɗga sǝb. Ai liye tsa ɓalguda, a dlai ga ba itar tsugun kǝ saks bi. ");
INSERT INTO gdf_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Wirva yan, gatamars kǝ ghay baramakh, ɓalamga ɓal itsǝra kǝ ude a gamga kur zin, kǝ saks da vak kwaɗgen.’ ");
INSERT INTO gdf_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Zar man tlǝren tsuguna, ka dǝgala tsitar kǝ baram kǝ baram. Ka dzakhadǝghǝr itar ad daghan udakhe a gamge tar zitar, zǝ liye njivva, zǝ liye kwal njiv. A righǝf vak kwaɗgen dǝ ghulabakh char. ");
INSERT INTO gdf_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Ka sa shik da vaz liye tsa ɓalgin, ka nǝgh nǝgha tsin ad udanen, ai kwal talǝm gabag khwaɗga sǝben. ");
INSERT INTO gdf_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ka niya kǝ udanen, ‘Tsaghw, a sa ndar kha da vana kwal talǝm gabag khwaɗga sǝbi?’ Ka piyarwala dǝg kwar. ");
INSERT INTO gdf_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","“Ka nǝv shik kǝ zar man tlǝr sar, ‘Ndzaɗamarna dǝva zǝ sig, tlǝvamars tlǝva dǝgal da mel, vake dǝ gurtl. Vake da tudin dǝ kǝrɗ tliɗ.’ ");
INSERT INTO gdf_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","“Zikǝn liye ɗakhtǝrkhai ud, ai khǝɗikǝn liye dzaravan.” ");
INSERT INTO gdf_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Dud ǝn kwarina, ka dala Farisakh kǝ ɗaya kavu lav ngara dlǝgd kǝ Yasu, kǝ viyaviya tsitar, ǝn tǝ dǝva dǝ dǝge da kwarin. ");
INSERT INTO gdf_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ka ɓǝlanǝf itar furakh tar, dagha zǝ udakhe khayanǝf dǝ man tlǝksa Khiridus, da vak sar. Ka nǝv itar, “Malǝm, tsa tsǝkǝnda kwarne ud jir khǝ, ǝn tsagdu lav Yazhigǝl kha kalkal. Wirva yakitakw ud ǝn vakagh. Na khǝn gǝdz kwarara lava kǝ ud, itsa ndar zika sar bi. ");
INSERT INTO gdf_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Kwara kǝnda kwar, da khǝn vazana, kalkal nagh pǝlara khadam tsǝkǝnda kǝ Kaisar, zikan kǝ Shik ǝn Roma, kalkal ba khi?” ");
INSERT INTO gdf_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ai Yasu tsuguna, tsa tsin kǝlade ǝn rǝvakhud tar. Ka ndiɗatǝrwal, “Kur nguɗiyakh, uɗa lava tsǝkur ǝn na ngaka dlǝgdi? ");
INSERT INTO gdf_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Mǝdla maka kwaɓen ǝn pǝl da kur khadamen.” Ka ɓardǝghǝr itar ad kwaɓ dinari. ");
INSERT INTO gdf_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ka ndiɗatǝrwal, “Vakdiying zǝ ɗakhǝng ǝn tǝfi?” ");
INSERT INTO gdf_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Ka ngawar khai itar kwarne, “Dǝg Kaisar.” Ka nǝv Yasu tsitar, “Bamara bǝg kǝ Kaisar ad dǝg Kaisar. Bara kur kǝ Yazhigǝl ad dǝg Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Tsǝna tsitar ndǝk yana, ka ndawatǝrǝf char. Ka ɗuwars itar, dakaval itar. ");
INSERT INTO gdf_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Fitsa va yanen, tǝkǝn Sadukiyakh li kwarne na tsiyin ngitl bi, sagh itar da vak Yasu dǝ ndiɗ. ");
INSERT INTO gdf_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","Ka nǝv itar, “Malǝm, a kwarga Mus kwarne, da ǝmtsǝga ude kwal yiga zǝr dǝ nus sar, barari wura wura kǝ zǝr bab sar ad nus saren, ki yakhar khai zara tsin. ");
INSERT INTO gdf_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Neg sukwtakh uɗif ǝn tǝbǝnd. Ɓu kǝ zǝr chak ad nus, ka amtsǝgan kwal zar, ɗuwardan ad nus sar kǝ saghǝr sar ai ǝn gatars gat. ");
INSERT INTO gdf_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","A dzogher ndǝk yan kǝ dǝg mits, a yiga ba dǝ zǝr din bi. Ndǝk yan zǝva kǝ dǝg khǝkǝrɗ, tangw da tǝ dǝg uɗif, a yiga ba itar zara din bi. ");
INSERT INTO gdf_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Kǝ dǝg mbasa, ka ǝmtsǝga nusen. ");
INSERT INTO gdf_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Fitsa tsiyin ngitla, da nǝga kǝ nus warin ǝn tǝb kǝ udakhana uɗifi? Fatsi daghan tara a zǝɓaruwi?” ");
INSERT INTO gdf_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ka ngawa tǝrkhai Yasu, “A zaɗga kur char. Wirvǝn tsa ba kur vindzan na kǝ lav Yazhigǝl bi. Tsuguna, ǝn tsa ba kur ndzǝɗa Yazhigǝl bi. ");
INSERT INTO gdf_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Fitsa tsiyin ngitla, na dǝɗungw da zǝɓ nus bi. Tsuguna na bud da bǝdu dugh kǝ sǝba bi. Da ngwaɗa zarɓǝlakh Yazhigǝl ǝn gharazhigǝl itar. ");
INSERT INTO gdf_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Ən tǝghǝr kǝ fitse da tsida tlamtsakh ǝn ngitla, a tugwa bakh kur dǝge a kwara kur khai Yazhigǝla? A vindzavan kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Ka Yazhigǝl Ibram. Ka Yazhigǝl Ishaku. Ka Yazhigǝl Yakub?’ A mǝdlanan kwarne Yazhigǝl tlamtsakh ba ka bi, Yazhigǝl liye dǝ safa kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Tsǝna kǝ dzakhava udakh ndǝk yan, ka ndawatǝrǝf, wirva tsagdutsaga saren. ");
INSERT INTO gdf_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Tsǝna kǝ Farisakh kwarne a bǝlaterghǝr Yasu ak Sadukiyakh, ka dzafkhai itar ǝn vak kitakul. ");
INSERT INTO gdf_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Fang a tǝb kǝ li wagayal ǝn tsa ndzikha ndzikh Mus, ka kurakura tsin dǝ ndiɗ. ");
INSERT INTO gdf_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Malǝm, ira kǝ ndzikh ǝn ndzikha ndzikh Yazhigǝle a maltǝr khai kǝ yakhaya daghani?” ");
INSERT INTO gdf_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Ka ngawar khai Yasu kwarne, “ ‘Waya dǝ Dadzikan Yazhigǝl gha, dǝ rǝvakhuɗagha daghan, dǝ safagha daghan, zǝ ɗayaghǝragha daghan.’ ");
INSERT INTO gdf_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ina dǝg chak, in tsugun kǝ maltǝr khai kǝ yakhaya daghan. ");
INSERT INTO gdf_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Dǝg mits kǝ ndzikhe a malgan ad yakhaya kǝ ndzikha ndzikhakhen tsuguna, ngwaɗa dǝg chak ghǝrsar. ‘Waya dǝ udakh daghan ndikve ǝn wayakha ghǝragh.’ ");
INSERT INTO gdf_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Daghan dǝge a vindzavan ǝn ndzikha ndzikh Mus, zai in kaɗkaɗakh tlayangakh Yazhigǝl, a ghitso ǝn tǝ ndzikha ndzikhakhana mits itar.” ");
INSERT INTO gdf_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Dzafkhai kǝ Farisakh ǝn tǝ dǝva kitakw, ka ndiɗatǝrwal Yasu, ");
INSERT INTO gdf_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Uɗa ɗayaghǝrur ǝn tǝ dǝva dǝ Kristuwi? Zǝr warek kini? “Zǝr Dod,” nǝv itar. ");
INSERT INTO gdf_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ka ndiɗatǝrwal Yasu, “Uɗa lava kǝ Dod tsugun ǝn tǝ dǝva dǝ Sǝɗikw Yazhigǝl ǝn ɗakhin dǝ Dadzikani? Wirva nǝv Dod, ");
INSERT INTO gdf_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","“ ‘Dadzikan Yazhigǝl. Niya kǝ Dadzikan nar. Ndzǝga ndzǝg ǝn tǝ dǝva kafar. Akwa bars ka ad tlǝghumakhagh. Ən kuskǝ ɗǝgaɗǝgagh.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","“Da ka ǝn ɗakha dǝ ‘Dadzikan,’ Dod ad Kristu, ai da nala ndar, Kristu kǝ zǝr sari?” ");
INSERT INTO gdf_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Na ude ngawar khai bi. Ve tsǝn tǝ yanen kǝ khǝna, na dla ude sigwif kǝ ndiɗarwal ndiɗa bi. ");
INSERT INTO gdf_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ka nǝv Yasu kǝ dzakhava udakh zǝ furakh sar. ");
INSERT INTO gdf_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Liye tsagdu ndzikha ndzikh zǝ Farisakh, ǝn man tlǝr tsagdu ndzikha ndzikhe tsǝn mana Mus itar.” ");
INSERT INTO gdf_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","“Wirva yan, tsǝnamaru tsǝna kǝ ɗaga dǝge kwara kurkhai itar. Ai gatamars ba kǝ dǝge ǝn mana itar bi. Wirva na itar ǝn man dǝge ǝn tsagdu itar bi. ");
INSERT INTO gdf_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Bakhatro itar kadlang ɗimɗiman kǝ udakh, ai kwal tǝkha kǝ ud kǝ kapanǝf. Ai itar dǝ ghǝr tar, nugw ba itar itsa kǝ barva zǝr dǝv kǝ mǝlaru kǝ kapa kapa kǝ udakh bi.” ");
INSERT INTO gdf_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","“Daghan tlǝre ǝn mana itara, ǝn mana kǝ nǝghda nǝgha nǝgha kǝ udakh itar. Ən ngwaɗa zikzikan na kǝ vindzan na kǝ lav Yazhigǝl ai mbǝghga itar, kǝ nguɗǝn tǝ vakdi tar zǝn tǝ dǝva tar. Tluzhe ǝn tukw ghai gabagakh tara, tsǝɓanyan mal kǝ dǝg udakh.” ");
INSERT INTO gdf_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","“Zik gat vij ndzakhgan khwarkhwaran tsitar ǝn vak man khwaɗǝg. Zǝ vak ndzakhgan khwaran ǝn gud dzakhava Yakhudakh. ");
INSERT INTO gdf_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Zǝ gat nǝghatǝrdi nǝgh dǝ fatǝrghǝrfǝg tsud ǝn kasuk. Zǝ ɗakhtǝr ɗakha dǝ ‘Malǝm.’ ");
INSERT INTO gdf_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","“Ya kur dǝgi, ɗakh kur bud dǝ ‘Malǝm’ bi. Wirva Malǝmura kitakul, tsuguna daghan nura sukwtakh kur. ");
INSERT INTO gdf_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Ɗakham ba dǝ itsawar dǝ ‘dad’ ǝn larda nabi. Wirva uk kitakul Dadure ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ɗakh kur bud dǝ mal bi. Wirva kitakul Malur in Kristu. ");
INSERT INTO gdf_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Dadake in zikan daghan ǝn tatakur, barari nǝga tsin kǝ dadak mana kura tlǝr. ");
INSERT INTO gdf_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Ɗaga ude a fǝrghǝr kǝ ghǝrsar, da gulandagh gulud. Ude a gulandagh ghǝrsar tsuguna, da fǝrghǝrfǝg ud. ");
INSERT INTO gdf_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Ɗangwa tsǝkur, li tsagdu ndzikha ndzikh zǝ Farisakh, kur li valdu ghǝrur. Khǝdardu kur ɗul daks da tlǝksa gharazhigǝl kǝ udakh. Kura a da ba kur bi, tsuguna a khayarnǝf ba kur kǝ liye ǝn na daks kǝ daks bi. ");
INSERT INTO gdf_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Ɗangwa tsǝkur, li tsagdu ndzikha ndzikh zǝ Farisakh, kur li valdu ghǝrur. Ən zawakh dǝgakh widgakh kur. Ən tǝ khala kǝ yana, ǝn zulu zula kur ǝn ɗǝgau, wirva ki nǝgakura nǝga tsud. Wirva yan, taka lave da mana kuruda da malamala dǝ dǝg udakh char. ");
INSERT INTO gdf_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","“Ɗangwa tsǝkur, li tsagdu ndzikha ndzikh zǝ Farisakh, kur li valdu ghǝrur. Wirvǝn ɗitsagharghǝr kǝ ɗǝlvakh kur, zǝ khay kǝsakh wirva ki gǝmadu dadak pǝlghǝr kitakul kǝ gatars kǝ Yazhigǝlur. Khala kǝ khayanǝf khaya tsin, ka da nanadala nǝg kur, kǝ dadake tlayga daks tsin da kara fay, mal tsukur sig mits. ");
INSERT INTO gdf_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Ɗangwa tsǝkur, ngulfakh li ndaɗ ngulfakh. Ən kwara kwara kur kwarne, ‘Ɗaga ude a waɗgan dǝ Fǝta Yazhigǝl, barari ba tsin man dǝge waɗgin da manamana bi. Ai tsugun, ɗaga ude a waɗgan dǝ vǝrshakanǝv ai ǝn Fǝta Yazhigǝlen, barari tsin man dǝge a waɗgin da manaman.’ ");
INSERT INTO gdf_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Kur dlagakhan ngulfakh. Irek ndanganra, vǝrkashanǝve, awana Fǝta Yazhigǝle a nandala ad vǝrkashanǝv kǝ chuwaɗaɗ khi? ");
INSERT INTO gdf_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Nikur tsugun, ‘Ɗaga ude a waɗgan dǝ vak sadak, barari ba tsin man dǝge waɗgin da manamana bi. Ai tsugun, da ka waɗgin dǝ dǝg tsuf, barari tsin man dǝge a waɗgin da manaman.’ ");
INSERT INTO gdf_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Kur ngulfakhan. Irek ndanganra, dǝg tsufa nagha, awana vak sadake a nandala ad dǝg tsuf kǝ chuwaɗaɗ khi? ");
INSERT INTO gdf_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Wirva yana, itsaware waɗgan dǝ vak sadak, a waɗgan dǝ vak sadak zǝ dǝge ǝn tǝf daghan. ");
INSERT INTO gdf_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Tsugun, ɗaga ude waɗgan dǝ Fǝta Yazhigǝl, a waɗgan dǝ Fǝta Yazhigǝlen, zǝ Yazhigǝl ai nzǝgan ǝn ǝmb. ");
INSERT INTO gdf_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Ɗaga ude a waɗgan dǝ gharazhigǝl, a waɗgan dǝ vij man tlǝksa Yazhigǝl, a waɗgan tsugun dǝ dadake ǝn nndzǝgan ǝn tǝ vij man tlǝksen. ");
INSERT INTO gdf_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Ɗangwa tsǝkur, li tsagdu ndzikha ndzikh zǝ Farisakh, kur li valdu ghǝrur. Ən bǝdu bǝg kur ad zak chachakuram, zǝ tlim dǝg ɗalakhur. Ai ka ɗuwar kur man zik zikan kǝ dǝgakhe ǝn nagha ndzikha ndzikh Yazhigǝl kǝ manaman. Zik zikan na kǝ dǝge ǝn nagha ndzikha ndzikh ad manaman tsukur in kwarne, man jir ǝn itsauɗ, mǝdla kwiɗkwiɗǝrv, khayanǝf khay ǝn digitakh. Itar dǝge tsa khwara manamana tsǝkur, zǝ kwal ɗuda manakh yakhin bi. ");
INSERT INTO gdf_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Kur ngulfakh li mǝdlara ɗul kǝ ngulfakh. Ən ɗizdu ɗiza kur kusingakh, ai tsuguna, ka ndǝg dlǝgwam kur. ");
INSERT INTO gdf_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Ɗangwa tsǝkur, li tsagdu ndzikha ndzikh zǝ Farisakh, kur li valdu ghǝrur. Li pardu lig kwat hǝb yu, zǝ kwat zu kaf, ai ǝn rǝvakhuɗura, reghan kur dǝ dǝgakhe a khwatsga kur ǝn vak udakh dǝ ndzǝɗ, zǝ nagh ghǝr tsugun. ");
INSERT INTO gdf_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Kur ngulf ya Farisakh. Famarsa paradu khuɗ kwat hǝɓ yu, zǝ kwat zu kaf, ǝn tǝ khal kǝ yana, ka da chuwaɗaɗ zǝva lǝgsar. ");
INSERT INTO gdf_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Ɗangwa tsǝkur, li tsagdu ndzikha ndzikh zǝ Farisakh, kur li valdu ghǝrur. Ngwaɗa ngitlakhe a masar vud ɓǝgan na kǝ wal, ai da khwara kǝ vaza dǝ lǝgan, ai ǝn khuɗ khuɗa, uk tlatlakh zǝ ruta digitakh. ");
INSERT INTO gdf_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ndǝk yan ghǝrur tsugun ǝn tǝ ɓal. Dǝn vaz kur vaza udakh, li kanadi kur ǝn tǝvuk Yazhigǝl. Ai du khuɗan tsuguna, reghan kur dǝ man dǝgakh valdu ghǝrur zǝ kǝladakh. ");
INSERT INTO gdf_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Ka zu vuk kǝ Yasu dǝ kwar kwarne, Ɗangwa tsǝkur, li tsagdu ndzikha ndzikh zǝ Farisakh, kur li valdu ghǝrur. Wirva khakhga kur ngitlakh tlayangakhe tsa dur. Ka ɗikakhga kur ad dǝg chaɗakhe da dzamatǝr dud kǝ li tsa manga kanadiyakh. ");
INSERT INTO gdf_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Afkur tsugun, da tsa tlǝm kǝnda ǝn sarta dzidzakhǝnd, tsa na kǝnda da bǝg dǝv zitar ǝn khǝdz tlayangakh Yazhigǝl bi. ");
INSERT INTO gdf_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ən tǝ dǝva dǝ lavur a mǝdlanan kwarne, zar ya udakhe tsa kaɗakhga tlayangakh Yazhigǝl kur. ");
INSERT INTO gdf_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Dam da mbasana nguɗi nguɗi dǝgakhe tsa farsa ndzidzakhur. ");
INSERT INTO gdf_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“Kur bubakh, kur zar ya kukhukhwakh. Da ngikha ndar kur ǝntla lave da mana kurud kǝ daks da kara fayi? ");
INSERT INTO gdf_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Wirva yana, ǝn ɓala kura ɓala kǝ ad tlayangakh Yazhigǝl, zǝ li kwalemlem, zǝ liye ǝn tsagdu ndzikha ndzikh Mus. Ka da kaɗakaɗa kur yakhaya. Khǝrtga kur yakhay. Dlagha tǝrkhai kur kǝɗa tsugun kǝ yakhay ǝn gud dzakhavur. Ən gatatǝrs gata kur kǝ kǝsa kǝs, ǝn batra dlaɗ. ");
INSERT INTO gdf_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Da ɓǝlondagh ɓǝla ka ad udakhan, wirva viz li kalali, liye khǝdzavan ǝn lardǝn, kǝ wurakurǝm da kwindur. Farsǝn tǝ viz Habil dadak kalali, kakh da tǝ viz Zakari zǝr Bereki. Ai kǝɗga kur ǝn Fǝta Yazhigǝl ǝn tǝvǝgh kǝ vak ndǝgha dǝg tsuf. ");
INSERT INTO gdf_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Ən tǝkha kura tǝkha kǝ, daghan ina kǝ digitakh, da dzoghǝr dzǝg dǝ udakh kwargǝn.” ");
INSERT INTO gdf_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“Udakh ya Wurshalim, udakh ya Wurshalim, kur li khǝdz tlayangakh Yazhigǝl. Liye ǝn lay liye a ɓǝlondaghud da vakur. Ngǝrwa siga tsǝka nagh dzakha kura dzakh, ngwadai dzakha ghwachik ad zar sar ǝn kus kǝ kudlǝbsari? Da mbiyanena kalwal kur. ");
INSERT INTO gdf_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Auna tǝkhina, a ɗuwakurdud fǝtur, nala kǝ kwazagh. ");
INSERT INTO gdf_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Ni ǝn kwara kura kwara kǝ, farsǝn tǝkhina, da aghba kur da nǝghakan bi, akwa sarte da kwara kur kwarne, ‘Bark kǝ dadake ǝn sǝgdagh ǝn khuɗ kǝ ɗakha Dadzikan.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Sawal kǝ Yasu ǝn Fǝta Yazhigǝl madvin ǝn dǝg, ka sa furakh sar da vak sar. Ka ndǝɗga itar ghǝr sar, ka mǝdlara itar Fǝta Yazhigǝle a khǝgud. ");
INSERT INTO gdf_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Ka ndiɗatǝrwal kwarne, “Nǝgha tsǝkur ina kǝ khǝgakha? Ai ǝn tǝkha kura tǝkha kǝ, na itsa kitakul kǝ kure da ɗudud ǝn tǝ tlǝrna bi. Daghana da khatdu khatud.” ");
INSERT INTO gdf_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Madǝv Yasu ǝn nndzǝgan ǝn tǝ khuɓa Olive, ka sa furakh sar da vak sar tukuɗa tar. Ka ndiɗarwal itar. “Kwara kǝnda kwar, da dzoghǝr yawa yakhana daghani? Tsuguna da zǝk ndǝk uɗa, da katlda kǝnda sarta guyo guyagha, zǝ mbasa lardi?” ");
INSERT INTO gdf_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ka ngawa tǝrkhai Yasu kwarne “Ya tsǝkwamana ghǝr, valkurdu ba itsawar bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Wirva zikǝn li da sosǝg ǝn ɗakhar da kwara kwara itsawar tar kwarne, itar Kristu. Da valduvala itar udakh zikǝn. ");
INSERT INTO gdf_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Da tsǝna tsǝna kur lav ǝn tǝghǝr kǝ pǝgakh, zǝ lavakh wuleng wuleng ǝn tǝghǝr kǝ pǝgakh. Ya gǝdzam bi, wirva barari dzoghǝr dzǝg tsin ndǝkyan. Ai mbasa sara a sa ba ndan bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Tlǝrna khaya da darghǝr dǝg kǝ tlǝrna khay. Tlǝrna shik tsugun da darghǝr dǝg kǝ tlǝrna shik dǝ pǝg. Da nǝg way, zǝ mbǝɗa pǝgdǝmakh ǝn tlǝrna vakakh. ");
INSERT INTO gdf_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Daghan ina kǝ digita, farsafǝg sar kǝ dlaɗ, ngwaɗa farsa ɓis tatǝrs yiga kǝ nus. ");
INSERT INTO gdf_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Da vi kur viya itar, bǝkurdu itar kǝ li da bakura mbakhǝl, kǝɗ kurkhai itar. Daghan udakh ǝn larda, da ɗukurd khai ɗuwa itar wirva ɗakhar. ");
INSERT INTO gdf_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Ən tǝ yan kǝ sart, zikǝn li da guyardu lǝg kǝ fadǝghǝrofǝg. Da sakwdu sukwtakh tar itar kǝ tlǝrna udakh. Tsuguna da naghva ba itar bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Da zikǝn tlayanga filfilakh da sakhgawal kǝ valakhdu udakh zikǝn. ");
INSERT INTO gdf_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Wirva sǝgva kǝladakh, wayve ǝn manakava udakha da zang. ");
INSERT INTO gdf_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Ai itsawar ǝn bǝga rǝv da tǝ mbas, da kata katud. ");
INSERT INTO gdf_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Tsuguna da kwardu kwarud ina kǝ lav zǝɗa kǝ tsǝn, ǝn tǝghǝr kǝ tlǝksa gharazhigǝl, itsa dǝvar ǝn lard. Ki da nǝga kǝ shid kǝ itsera kǝ mbǝrtakh ǝn lard daghan. Tǝkhal kǝ yana, ka da saks mbasa sar. ");
INSERT INTO gdf_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Wirva yan, da ka nǝgha tsǝkur dǝg dzadle a kwarga Daniyal tlayang, ǝn ghitsǝn tǝ vakvak Chuwaɗaɗan ǝn Fǝta Yazhigǝl, (dakake ǝn tugwado lavana katlga katlin dǝge tukuwin). ");
INSERT INTO gdf_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Ghalak liye ǝn ǝntla khay ya Yakhudi, khwaya itar dǝgo da ghuɓakh. ");
INSERT INTO gdf_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ya ude nndzǝgan ǝn tugwud tsuguna, ya so ɓin da zǝɓ dǝge ǝn khud mǝgh bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ude ǝn gukh tsuguna, ya guyo bin saks da zǝɓ nura sar bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Ya ɗangwa kǝ nǝghwase dǝ khuɗ, zǝ liye dǝ zǝr ǝn tǝ tukw dǝv, ǝn tǝ yanen kǝ sart. ");
INSERT INTO gdf_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kwam ɗǝgau, dzoghǝr ba khwayana ǝn sarta fagh bi, awana fitsa ngiya bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Yǝn tǝ yanen kǝ sarta, da nǝg dlaɗ char, khulfe kwal taɓa tsuɗ manaman. Gwil farsa vǝrɗ lard, tangw da tina kǝ sart. Aghbud da gwidǝn man khulf sar kǝ yanen bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","“Da tsa khǝtsana bud ad khǝnakhen bi, tsa na ud dǝg sige da tǝma dǝ safa bi. Ai wirva li dzǝran na kǝ udakh Yazhigǝl, da khǝtsa khǝtsa Yazhigǝl ad khǝnakhen. ");
INSERT INTO gdf_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Ən tǝ yanen kǝ sart, da ka nǝv itar tsǝkur, ‘Vaza, auna Kristu ǝn van’ awana, ‘A niya ǝn vin’ ya khayamanǝf bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Wirva Kristu filfilakh zǝ tlayang filfilakh da sakhgawal itar. Da manakh zik zikan na kǝ jakvakh, zǝ zik zikan na kǝ dǝg ndawakakh itar kǝ valdu udakh. Da tsa tǝkhin kǝ manawan, da valdu vala itar zǝva liye a dzǝrtǝkhai Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Tsǝnam tsǝna, a kwara kur khai ka, kǝda saks kǝ sart. ");
INSERT INTO gdf_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“Wirva yan, da ka kwara kur khe itar kwarne, ‘Ani ǝn tǝghal,’ a ɗuwam dǝgal da vinen. Awana, ‘Aunin ǝn khuɗan kǝ gud ɓǝghan,’ ya famadǝghǝro bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ndǝkve ǝn tsuwaɗa wuɗ ad gharazhigǝl, sǝgo ǝn mbǝrt kǝ kǝs da tǝ vakghǝr, da dzoghǝr ndǝk yan sǝgdaghara ka Zǝr Ud. ");
INSERT INTO gdf_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ɗaga vake dǝ ǝmtsa digitakh, ǝn vin ǝn dzakhava gumbakh. ");
INSERT INTO gdf_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ən dǝvǝn dǝv, ǝn tǝ khal kǝ khǝna dlaɗakhen, “ ‘Ka da nǝga fatsi kǝ gurtl. Tǝl tsuguna naba da kheɗaɗ bi. Kwadladlakh tsuguna ka da ɓaloɓalǝn Sǝgadagh ǝn gharazhigǝl. Da gǝdiya gǝdyud ad ndzǝɗakhe Ən fǝf gharazhigǝl.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","“Da mǝdlo ǝn tǝ yanen kǝ sart jakva Zǝr Ud ǝn tǝ fef gharazhigǝl. Ɗaga mbǝrt udakhe ǝn lard tsugun, da tuwa itar wirva ruwa udakh. Da nǝgha nǝgha itar Zǝr Ud ǝn sǝgadagh ǝn ghwik, dǝ ndzǝɗa zǝ ndanga char. ");
INSERT INTO gdf_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Da bǝlondagh ɓǝla ad zarɓǝlakh sar, kǝ fǝg dǝro ɗakh ǝn tuwa char. Da dzakha dzakha itar ad dzǝran na kǝ udakh sar, ǝn tǝ kalam lard daghan. Tsiyif ǝn tǝ yan kǝ kalam lard, da tǝ yan. ");
INSERT INTO gdf_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Tsagam tsaga digit ǝn vak ufa ghǝdiv. Da farsin ɗidu tlim kǝ ɗado wilwa tlim, ǝn tsatsǝg kur kwarne a khǝrzǝga vi. ");
INSERT INTO gdf_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ndǝk yan tsugun, da nǝgha tsǝkur dǝgakhana daghan. Da tsa tsǝg kur kwarne, a khǝrzǝgan, ǝn tǝ ghay gud. ");
INSERT INTO gdf_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Ən tǝkha kura tǝkha kǝ, udakh kwargǝn, da ruga ba itar bi, khekwa dzoghǝr dǝgakhana daghan. ");
INSERT INTO gdf_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Gharazhigǝl zǝ khaya da nige tar. Ai lave ǝn sǝgawal ǝn ghayara na bai kwal da regha bi.” ");
INSERT INTO gdf_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ai na ude tsa khǝna zǝ sarte da dzoghǝr dǝgakhan na bi. Itsa zarɓǝlakhe ǝn gharazhigǝl, itsa Zǝren, uk Dad kitakul ǝn tsan. ");
INSERT INTO gdf_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Ndǝkve tsa manavin ǝn sarta Nuhu, da dzoghǝr ndǝk yan, ǝn tǝ sarte da sǝgdagh ka Zǝr Ud. ");
INSERT INTO gdf_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ən khǝna khen kǝda saks kǝ ǝrkhagw, ǝn zuwazu, zǝ khǝɓakhǝɓ udakh. Ən sǝbado sǝbud nus, ǝn sǝbdu sǝbud dǝghaw dǝgal, da tǝ sarte a dagh Nuhu daks da gakhunda peryu. ");
INSERT INTO gdf_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ən tsa ba itar dǝge da dzoghǝr dzǝg bi, ba sa kǝ ǝrkhagwa ndǝtru daghan. Da nǝga ndǝk yan sǝgdaghara ka Zǝr Ud. ");
INSERT INTO gdf_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Ən tǝ yanen kǝ sart, ud mits da man tlǝr ǝn gukh, da ɓaɓud kitakula, ɗuwars ud kitakul. ");
INSERT INTO gdf_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Nughwasa mits da pǝkha itar ǝn tǝ vǝr, da ɓaɓud kitakula, ɗuwars ud kitakul. ");
INSERT INTO gdf_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“Wirva yana, ɗikamfǝkhe ɗik, da tsa ba kur sarte da sǝgdagh Dadzikan nura bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ya dǝgi, katlamga katla din. Da tsa tsatsǝg dadak mǝgh ad sarte da saks gǝl da fǝta sar kǝviɗ, tsa na ba da khǝn khar bi. Tsuguna, tsa da khayanǝf ba daks kǝ gǝl da fǝta sar bi. ");
INSERT INTO gdf_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Wirva yan, barari tsǝ ghǝrur tsǝgun, kǝ giɗa ɗem. Wirva da sǝgdagh ka Zǝr Ud ǝn tǝ sarte kwal kurga tsǝkur. ");
INSERT INTO gdf_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“War zǝr man tlǝre njiv, zǝ khiɗanyan tsǝgun, ai bǝga dad mǝgh sar, kǝ nǝgharu kǝ yakhaya kǝ zar man tlǝr sar, kǝ batra dǝg zuwa tar tsin ǝn tǝ kalkala sart, kwal mbitsana tsini? ");
INSERT INTO gdf_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Da dadak bark yan kǝ zǝr mǝghe da sa dad mǝgh sar, ka tlarghǝr ǝn man tlǝre tsa barud. ");
INSERT INTO gdf_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Ən tǝkha kura tǝkha kǝ, dad mǝgh na, da barǝmbǝg kǝ zǝr tlǝren ad daghan dǝgakh sar kǝ nǝgharu nǝgha tsin. ");
INSERT INTO gdf_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Da ka dǝg charan ba zǝr tlǝren bi, ka niya kǝ ghǝrsar, ‘Dad mǝghara da zulu zula kǝ saks.’ ");
INSERT INTO gdf_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Ka farsa mbatltǝr mbatla tsin kǝ liye ǝn mane tar tlǝr dagh. Ka zuwazu zǝ khǝɓakhǝɓa tsin zǝ li khaɓ digit. ");
INSERT INTO gdf_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Ka da saks dad mǝgh sar kǝ zǝr tlǝren, ǝn tǝ khǝne kwal kurga tsin, zǝ sarte kwal tsa tsin. ");
INSERT INTO gdf_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ka da ngadla ngadla dad mǝgh sarna dǝ kiɓ. Dǝge da dzoghǝr dǝ liye valdu ghǝr tar da ndǝk yan kǝ ghǝr sar. Ən tǝ vake da tuda udakh dǝ kǝrɗ tliɗ. ");
INSERT INTO gdf_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ən tǝ sarte da sǝgdagh ka Zǝr Ud, tlǝksa gharazhigǝl da kura dǝ dugh mbǝlakh kǝlɗǝkud. Li zǝɓarǝf karakazaz tar kǝ dǝgal da gam zil ghaul. ");
INSERT INTO gdf_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Dliɓ ǝn tǝb tara dlagakh, dliɓ tsuguna li khiɗan. ");
INSERT INTO gdf_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Dlagakhena a ɓarǝf ad karakazaz tar, a ɓǝf ba itar wal bi. ");
INSERT INTO gdf_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Li khiɗanakhena a ɓarǝf ad wal ǝn khatakwakh tar zǝ karakazaz tar. ");
INSERT INTO gdf_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Zil ghaulena a sa ba dura bi, daghan tara a mbatǝra khar, ka kaɗ tǝrkhe khar. ");
INSERT INTO gdf_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ən tǝb viɗ char, ka tsǝna tsǝna tsud ɗakha kwarne, ‘Auna zil ghaul, ausǝgam sǝgawal da gamagam.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","“Ka tsayif dugh mbǝlakhen daghan. Ka ɗikanǝf itar ad karakazazkh tar. ");
INSERT INTO gdf_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Ka nǝv dlagakhana kǝ li khiɗan, ‘Chiɗa makǝndu chiɗa walur, wirva karakazazǝnda da ǝmts.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“Ka nǝv itar, ‘Au, da tlakiyamal ba tsǝkǝnda zǝ kur bi. Damdǝgal da vak li sakwdu wal, kǝ sukwaru sukwa tsǝkur kǝ ghǝrur.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","“Madǝv dlagakhen ǝn tǝ ɗul dǝgal da sukw walen, ka soghǝr zil ghaul. Dugh mbǝlakhe a ɗikfekhaya, ka dara zǝ zil ghaul da vak khwaɗga sǝb. Ka khǝɗarduwud gud. ");
INSERT INTO gdf_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“Kǝ khala ka sasǝg kǝ dlagakhen. ‘Dadzikan, Dadzikan, ngura kǝnda ngura gud,’ nǝv itar. ");
INSERT INTO gdf_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","“Ka ngawa tǝrkhai zil ghaul kwarne, ‘Ən tǝkha kura tǝkha kǝ, ǝn tsakura ba ka bi.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","“Wirva yan, ɗem nikur, wirvǝn tsa ba kur ad khǝna awana sarte da sǝgdagh ka Zǝr Ud bi. ");
INSERT INTO gdf_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Tsugun, da kura tlǝksa gharazhigǝlud dǝ ude da dǝgal da tlǝrna vak. Ka ɗakhgan ad zar tlǝr sar, ka batrǝm ad lǝmanakh sar ǝn dǝv tar, kǝ nǝgharu nǝgha tsitar. ");
INSERT INTO gdf_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ka baran ak itsawar ad kalkal ndzǝɗa sar. Ak yan fanga, baran ad talenti dliɓ. Ak tlǝrna baran ad talenti mits. Ak tlǝrna tsuguna, baran ad talenti kitakul. Ka dǝgala sar tsin. ");
INSERT INTO gdf_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Dadake tsa chauga talenti dliɓǝna, ǝn tǝvin tǝvin, ka dǝgal tsin da mbǝɗa dǝv dǝ kwaɓ sar. Ka mbǝladu ad tlǝrna talenti dliɓ ǝn tǝghǝr. ");
INSERT INTO gdf_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ndǝk yan ak dadake tsa chauga talenti mits. Ka mbǝladu ad tlǝrna talenti mits ǝn tǝghǝr. ");
INSERT INTO gdf_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Ai dadake tsa chauga talenti kitakulǝn, ka dǝgala tsin, tǝfgan ad fika, ɓǝghanan ad kwaɓ dadmǝgh saren. ");
INSERT INTO gdf_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ən tǝkhal kǝ zulu zula tsin, ka sasǝg kǝ dadmǝgh taren, kǝ kwarara dǝge a manga itar dǝ kwaɓakhen. ");
INSERT INTO gdf_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Ka zǝghvoghǝr zǝr tlǝre tsa chauga talenti dliɓna da tǝvǝgh tsin. Ka ni, ‘Dadmǝgh, talenti dliɓ a baka khǝ, auna kwaɓe tsa baka khǝ. A mbǝladu ka ad yu talenti dliɓ ǝn tǝghǝr tsugun.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","“Ka nǝv dadmǝgh sar tsin, ‘Dakhwal khǝ, zǝr tlǝr charan zǝ dadak khuta lanjikh. A manga kha dǝ jir ǝn tǝghǝr kǝ digit khǝɗikǝn. Da bǝg kha bǝga ka kǝ dadak nǝgharu kǝ digitakh zikǝn. Ausǝg da khwaɗga zǝ kǝ.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“Ka zǝghvoghǝr zǝr tlǝre tsa chauga talenti mits da tǝvǝgh tsin. Ka ni, ‘Dadmǝgh, talenti mits a baka khǝ. Auna kwaɓe tsa baka khǝ. A mbǝladu ka ad yu talenti mits ǝn tǝghǝr tsugun.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","“Ka nǝv dadmǝgh sar tsin, ‘Dakhwal khǝ, zǝr tlǝr charan zǝ dadak khuta lanjikh. A manga kha dǝ jir ǝn tǝghǝr kǝ digit khǝɗikǝn. Da bǝg kha bǝga ka kǝ dadak nǝgharu kǝ digitakh zikǝn. Ausǝg da khwaɗga zǝ kǝ.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“Ka zǝghvoghǝr zǝr tlǝre tsa chauga talenti kitakul da tǝvǝgh tsin. Ka ni, ‘Dadmǝgh, tsa tsǝka kwarne bǝza manva zǝ khǝ. Ən tsǝg khikh ǝn vake kwal tukhga tsǝkh, zǝ udz digit ǝn vake kwal kwazdu tsǝkha ad khulf. ");
INSERT INTO gdf_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Wirva yana, a gǝdzǝf kǝ, a dala ka ɓǝghana ka ad kwaɓagh ǝn khay. Auna dǝge dǝgagh.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“Ka ngawar khai dadmǝgh saren kwarne, ‘Kha nguɗi zǝr tlǝr, mandǝlgh tsǝgun. Tsa tsǝkha kwarne ǝn tsǝg khi kǝn vake kwal tukhga tsǝka? Zǝ udz digit ǝn vake kwal kwazdu tsǝka khulfa?. ");
INSERT INTO gdf_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Afke tsa bake kha dǝ kwaɓar ǝn bank, vake ǝn ɗidud kwaɓ. Da tsa soghǝr ka, tsa ka chauga ka dǝ yu ǝn tǝghǝr. ");
INSERT INTO gdf_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Wirva yan, ka gwiyavǝkhe da vak udakhe ǝn vin, ka niya tsitar, chawamarval chaw ad talenti kitakulen, ka bara kur kǝ dadake dǝ talenti kǝlɗǝk. ");
INSERT INTO gdf_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Itsawar ai nǝg dǝ digit, da banarghǝr bǝgud, ka da ngǝrsh digit ǝn vak sar. Ude naba din tsugun bi, ngwaɗa khǝɗike dinin, da pǝrɗarval pǝrɗud. ");
INSERT INTO gdf_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ai ina kǝ nguɗi zǝr tlǝrǝn, tlǝvam dagh tlǝva da nikyen na kǝ gurtl. Vake ǝn tuwud dǝ kǝrɗ tliɗ.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Sarte da sǝgdagh Zǝr Ud ǝn ndanga sar, zǝ zarɓǝlakh Yazighǝle ǝn gharazhigǝl. Ka da nndzǝgan ǝn tǝ vǝja man tlǝksa sar. ");
INSERT INTO gdf_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Daghan mbǝrt udakh ǝn lard da dzakhavǝn tǝvuk sar. Ka da taka taka ad udakh, ngwaɗe ǝn taka dadak zighwa ad tuwaghakh zǝ waghakh. ");
INSERT INTO gdf_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ka da bǝga bǝga ad tuwaghakh ǝn tǝ dǝva kaf sar, ka waghakh tsuguna ǝn tǝ dǝva tleɓ sar.” ");
INSERT INTO gdf_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","“Ka dǝge da kwaratǝra shik ak li ǝn tǝ dǝva kaf sar, ‘Ausǝgam kur li ba kur ghǝr Dadar ad bark, wuramuwur ad tlǝkse a ɗika kur nud gwil sarta vǝrɗ lard. ");
INSERT INTO gdf_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Ən sarte tsǝn ndzika waya, ka ba ka kur dǝg zu. Ndzikǝf kǝ ndǝl, ka ba ka kur yu khǝɓ. Ən sarte tsa ghwulab kǝ, chaw ke kur da fǝtur, ");
INSERT INTO gdf_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Na ka dǝ dǝg nguɗa bi, ba ka kur dǝg nguɗ. Tsǝn yanga ba ka bi, ka nǝghakdi kur. Tsǝn gud sal kǝ, sa kur da nǝghakdi nǝgh.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“Ka da ngawara ngawa li kanadi kwarne, ‘Dadzikan, tsa nǝgha kha yawa kǝnda ǝn ɓis way, ka bakha kǝnda dǝg zuwi? Yawa nǝgha kha kǝnda kǝɗkhe ndǝl, ka bakha kǝnda yu khǝɓi?’ ");
INSERT INTO gdf_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Yawa a nǝgha kha kǝnda ghwulab, ka chaw khe kǝnda da fǝtǝndi? Yawa nǝgha kha kǝnda kwal dǝg nguɗ, tsuguna bakha kǝnd ad dǝg nguɗi? ");
INSERT INTO gdf_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","A nǝgha kha yawa kǝnda kwal yanga, awana ǝn gud sal, ka dal kǝnda da nǝghakh di nǝghi? ");
INSERT INTO gdf_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","“Ka da ngawa tǝra ngawa shik kwarne, ‘Ən tǝkha kura tǝkha kǝ, itsauɗa a manar khai kur kǝ sukwtakharan liye khǝtsala ndanga tar char, a manake tsǝka kur.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ka da niya kǝ li ǝn tǝ dǝva tleɓ sar, ‘Tsiyam tsiyin vakar, kur liye tlap kurkhai Yazhigǝl. Damaks da kare kwal da ǝmtsa kǝ ngǝɗ. Ai ɗikarna ghud kǝ Shaɗan zǝ zarɓǝlakh sar. ");
INSERT INTO gdf_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Sarte tsa ndzika way, a ba ka ba kur dǝg zuwa bi. Ən sarte tsa ndzika ndǝl, a ba ka ba kur yu khǝɓa bi. ");
INSERT INTO gdf_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Ən sarte tsa ghulab kǝ, a chaw kai ba kur da fǝtakhur bi. Na ka dǝ dǝg nguɗa bi, a ba ka ba kur dǝg nguɗa bi. Sarte kwal tsa yanga tsǝk, tsuguna tsǝn ǝn gud sal kǝ, a nǝghakdi ba kur bi.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“Ka da ngawara ngawa itar kwarne, ‘Dadzikan, tsa nǝgha kha yawa kǝndǝn ndzikha waya zǝ ndǝli? Tsa nǝgha kha yawa kǝnda man ghulaba ghulabi? Tsuguna yawa nǝgha kha kǝnda kwal yanga, zǝn sarte tsǝn gud sal khǝ, kwal mǝlakhu tsǝkǝndi?’ ");
INSERT INTO gdf_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“Ka da ngawa tǝra ngawa shik kwarne, ‘Ən tǝkha kura tǝkha kǝ, itsauɗa dǝge kwal manar khai tsǝkur kǝ sukwtakharan liye a khǝtsala ndanga tar char, ka kwal mǝlaku tsǝkur.’ ");
INSERT INTO gdf_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","“Ka da bǝg tǝr bǝgud da dlaɗe kǝ ngǝɗ, li kanadi tsuguna da daks da safa kǝ ngǝɗe tar.” ");
INSERT INTO gdf_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Udzala kǝ Yasu ǝn kwaratǝra lavakhan na daghan, ka niya kǝ furakh sar. ");
INSERT INTO gdf_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Tsa tsǝkur kwarne khwaɗga ɗitsaɗits tǝghga khǝna mits, da bǝdu bǝgud ad Zǝr Ud kǝ khǝrtakhǝrt.” ");
INSERT INTO gdf_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Tǝkǝn zikzikan na kǝ zil kǝsakh zǝ malanakh ǝn tǝghǝr kǝ udakh, dzafkhai itar ǝn fǝta zikan na kǝ zil kǝs, ai ɗakhud dǝ Kayaf. ");
INSERT INTO gdf_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Ka ngakhanǝf itar ɗule da vida itar Yasu bǝghanyan, kǝɗa itar. ");
INSERT INTO gdf_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ka nǝv itar, “Yin tǝ sarta khwaɗga ɗitsaɗitsa bi, ki khai kǝ da tsiya kǝ mǝkǝn kǝ udakh, kǝ tsiya ngǝji.” ");
INSERT INTO gdf_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ən sarte tsǝn Betani Yasu, ǝn fǝta Siman ai tsa ndzikǝn fǝch. ");
INSERT INTO gdf_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Madǝv Yasu ǝn zu kaf, ka sasǝg kǝ nusen da vak sar, dǝ wal bǝtbǝtan, ai dǝ kwaɓ char righan ǝn khatakw. Ka ɗiyaro ǝn tǝ ghǝr. ");
INSERT INTO gdf_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Nǝgha kǝ furakh sar ndǝkyan, a bazatǝrdu ad rǝv. Ka nǝv itar, “A bazdu kǝ uɗud ad ina ni?” ");
INSERT INTO gdf_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","“Azǝgha tsa sukwdu ud ad walǝn tǝ kwaɓ zikǝn, ka batrud ad kwaɓ sar kǝ talagakh.” ");
INSERT INTO gdf_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Tsa kǝ Yasu ad dǝge ǝn kwara itar, ka ndiɗatǝrwal kwarne, “Uɗa lava tsǝkur ǝn njǝgharu kǝ nusni? Ai dǝge a manakai yina dǝg khwaran. ");
INSERT INTO gdf_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Itsera kǝ khǝna dagha kur zǝ talagakh, ai ka, da dagh ba kiyam zǝ kur itsera kǝ khǝna bi. ");
INSERT INTO gdf_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Wal na ɗiyakdaghin, a manga kǝ ɗika ka vǝgh, kǝ khǝɗa ka khǝɗ. ");
INSERT INTO gdf_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Ən tǝkha kura tǝkha kǝ, itsa da kwardu ǝn varud lav zǝɗa kǝ tsǝna nǝn, ǝn lard daghan, dǝgǝn na manga nusna da kwardu kwarud ki da dzama da dzam.” ");
INSERT INTO gdf_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Fang ǝn tǝb kǝ kǝlatǝm mits, ai ɗakha sar Yakhud Iskariyoti, dal da vak zik zikan na kǝ zil kǝsakh ");
INSERT INTO gdf_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ka niya tsitar, “Uɗa da ba ka kur, da sukwakurdu ka dǝ Yasuwi?” Ka kǝdlana itar ad kwaɓ dawan kulkhǝkǝrɗ, ka bara itar. ");
INSERT INTO gdf_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Tsiyif ǝn tǝ yanen kǝ sarta, ka farsa Yakhud ad tsakwaɗ ɗule da batǝrduwin ad Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Fitsa chak kǝ zu brudiye kwar yisti, ka sa furakh Yasu da vak Yasu, ndiɗarwar itar kwarne, “Ən varǝn nakha da ɗikakhana kǝnda vak zu kaf ɗitsaɗitsi?” ");
INSERT INTO gdf_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ka niya tsitar, “Dam dǝgal da vak udanen ǝn dlǝmdla kǝs, kwararkhai kur kwarne, ‘A khǝrzǝga sartar, da zuwun fǝta ka kaf khwaɗga ɗitsaɗitsa zǝ furakhar.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Ka manga furakhen ndǝkve kwara tǝrkhai Yasu, ka ɗikanǝf itar ad kaf ɗitsaɗitsen. ");
INSERT INTO gdf_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Ɓǝlga kǝ khakhugw, ka ndzǝga Yasu zǝ furakh sar kǝlatǝm mits kǝ zu kaf. ");
INSERT INTO gdf_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Madǝv itar ǝn zu kaf, ka nǝv Yasu tsitar, “Ən tǝkha kura tǝkha kǝ, kitakul ǝn kur, da sukwdu sukw.” ");
INSERT INTO gdf_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Ka bazala rǝv tsitar char. Ka farsa itar ad ndiɗarwar ndiɗa dǝ fang fang kwarne, “Ka nagh Dadzikana?” ");
INSERT INTO gdf_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Ka ngawga Yasu kwarne, “Ude ǝn zuwa kǝnda kaf ǝn kwat kitakul zin, in da sukwdu. ");
INSERT INTO gdf_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Da ǝmtsa ndǝkve a kwarga kaɗkaɗ Zǝr Ud. Ai ya ɗangwa kǝ ude da sukwdu Zǝr Ud. Adara tsa kǝ yanen kuda, tsa yiga bud bi.” ");
INSERT INTO gdf_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Ka nǝv Yakhud dadake da sukwdu sukw, “Malǝma, ka nagha?” Ka ngawarkhai Yasu, “An, audzala khǝn kwarga kwar.” ");
INSERT INTO gdf_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Madǝv itar ǝn zu kaf, ka ɓǝf Yasu ad brudi, udzala tsin ǝn kwarara us kǝ Yazhigǝl, ka kwachanan. Batran kǝ furakh sar, niya tsitar, “Vǝgharen, chawam chaw, zuwam zu.” ");
INSERT INTO gdf_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ka ɓǝf ad kwate dǝ yu inabi, udzala tsin kwarara us kǝ Yazhighǝl, ka batran, niya tsitar, “Khǝɓam khǝɓ daghan nura. ");
INSERT INTO gdf_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ina vizhare a righanǝf ad wilwa lanji Yazhigǝl. Ai da ɗiduwud wirva udakh zikǝn. Wirva ki ɓisa da khaipakh. ");
INSERT INTO gdf_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Ən kwara kura kwara kǝ, aghba ka da khǝɓ yu inabi bi, akwa sarte da khǝɓa ka wilwa yu inabi zǝ kur ǝn tlǝksa Dadar.” ");
INSERT INTO gdf_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ka ɓǝlga Yasu zǝ furakh sar ad ndus. Khalak yana, ka sawal itar, ka dal itar da tǝ ghuɓe dǝ ufakh Oliv. ");
INSERT INTO gdf_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ka nǝv Yasu tsitar, “Ən khuɗ viɗ khan, daghanura da khwaya kur dǝgal, da ɗukda ɗuwa kur. Ngwaɗe vindzan kwarne, “ ‘Da kǝɗga kǝɗa kad dadak zighw, Giɗa tuwagha da kwaza itar.’ ");
INSERT INTO gdf_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Ai ǝn tǝ khal kǝ tsiyakǝf tsiya tsud ǝn ngitl, kǝn da dala tǝghǝr tsǝkur da khaya Galili.” ");
INSERT INTO gdf_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Ka ngawar khai Bitrus, “Itsa kwazga itar daghan, ǝn tǝghǝr kǝ dǝge da dzoghǝr dǝ khǝ, na ka da khwaya dǝgala, ɗuwakhs ka lingling bi.” ");
INSERT INTO gdf_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Ka nǝv Yasu kǝ Bitrus, “Ən tǝkha kha tǝkha kǝ, ǝn khuɗ viɗ khan, kǝda wuga kǝ ghwachik, da bǝg tsugu tsakatsǝg kha sig khǝkǝrɗ.” ");
INSERT INTO gdf_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Ka nǝv Bitrus tsin, “Itsa da ǝmtsa kǝ, na ka da bǝg tsugu tsakhatsǝg bi.” A kwarakhga ndǝkyan chalǝm furakh sar daghan. ");
INSERT INTO gdf_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ka dal Yasu dagha zǝ furakh sar da tǝ vaken ai ɗakhdud Getsemani. Ka niya tsitar, “Ndzamga ndzǝg ǝn van, dǝgal da ɗǝgau ǝn tǝ vin.” ");
INSERT INTO gdf_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ka dala zǝ Bitrus zǝ zar ya Zabadi na mits. Ka dzoghǝr bazala rǝv zǝ dzamghǝr tsin. ");
INSERT INTO gdf_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Ka niya tsitar, “Rǝvara righan da baza rǝv, ai da tǝgh kǝ kǝɗkai. Giɗam giɗa ǝn van, ndzamga ndzǝg, ǝn gwitagwita zǝ kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Dal tsin da tǝvuk khǝɗikǝn, ka khǝmbǝgan dǝ khuɗ khuɗ, ka ɗǝgau tsin, ni, “Dadara, da tǝkhin kǝ manawan, ɓakghǝr ɓa ad ina kǝ dlaɗ. Tsakhǝnmina, dǝge ǝn naka ba da manud bi, khekwa dǝge ǝn nakha da manud.” ");
INSERT INTO gdf_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Guyoghǝr tsin da vak furakh sar, ka tlatǝrghǝr ǝn khǝn khar. Ka niya kǝ Bitrus, “Atsuk tǝgh bakh kur khǝkarɗ daghur kǝ manga ɗǝm zǝ ka, kǝ dǝg aw kitakul biya? ");
INSERT INTO gdf_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ɗem nikur zǝ ɗǝgau, ki khek da ɓǝla tsǝkur da dlǝgd. A khayanǝf sǝɗikw, ma vǝgha lǝɓukw.” ");
INSERT INTO gdf_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Ka gwidǝn dǝgal tsin da ɗǝgau kǝ dǝg mits, ni, “Dadara, da ka ǝn manawa ba ɓakghǝra inen kǝ tlaɗ bi, ba ka khǝɓa khǝɓa kǝ. Manud dǝge ǝn nakh.” ");
INSERT INTO gdf_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Gwiyoghǝr tsin saks da vak furakh sar, ka tlatǝrghǝr ǝn khǝn khar, wirva khar ǝn di tsitar char. ");
INSERT INTO gdf_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Ka gwidǝn ɗuwatǝrs Yasu, dala kǝ dǝg khǝkǝrd da ɗǝgau, ǝn gwayars kǝ lav kitakul. ");
INSERT INTO gdf_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ka gwidǝn guyoghǝr da vak furakh sar, ka niya tsitar, “Dlakh kur ǝn khǝn khar zǝ fǝtava? Vazam vaz, a sagh sarte da bǝdu wud Zǝr Ud, da dǝv kǝ li khaipakh. ");
INSERT INTO gdf_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tsiyam tsi, ndziyam dǝgal. Auna khǝrzǝga dadake da sukwdu sukwa saks da van.” ");
INSERT INTO gdf_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Madǝv Yasu dlǝn kwar lav, tǝkǝn Yakhud ai kitakul ǝn tǝɓ kǝ kǝlatǝm mits, a sagh dǝ dzakhava udakh zikǝn. Khwatan katsakarakh zǝ yaghwatakh ǝn dǝvakh tar kǝ udakhen. Zikzikan na kǝ zil kǝsakh, zǝ malanakhe ǝn tǝghǝr kǝ udakh kǝ ɓǝlatǝrǝf. ");
INSERT INTO gdf_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Yakhud dadak sukwdu sukwena, audzala kǝbitstǝr khai kǝbitsa kǝ dzakhava udakhen kwarne, “Dadake da bruwa ka, in udanen, viyam vi.” ");
INSERT INTO gdf_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Ka sagh Yakhud ger da vak Yasu, niya tsin, “Malǝm, ndzǝga ndzǝg gabǝr ǝn tǝghǝr tsǝkha.” Ka ɗuts khǝpangwang sar tsin. ");
INSERT INTO gdf_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Ka nǝv Yasu tsin, “Tsaghwa mana dǝge a ɓǝkhdǝghǝr.” Ka zǝghvoghǝr udakhen, ka viga itar Yasu. Ka khutana itar char. ");
INSERT INTO gdf_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ka fang ǝn tǝb kǝ liye dagh zǝ Yasu, ndǝɗadal ad katsakar sar. Ka tsaɓgan ad vǝɓ zikan na kǝ zil kǝs, ka ǝntlardu ad tlim. ");
INSERT INTO gdf_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Ka nǝv Yasu tsin, “Bǝmbǝg ad katsakaragh da kumbǝgh sar.” Ɗaga liye udzǝva dǝ katsakar, da ǝmtsǝn tukw katsakar itar. ");
INSERT INTO gdf_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","“Da khǝn kurana tǝgh bakh ka kǝ tatlaga Dadar kǝ mǝlaku mǝla? Ən dǝvǝn dǝva ka ɓǝlokandagh ad zar ɓǝlakh sar mal kǝ dǝb ǝnkwakh ǝnkwakh sig kǝlatǝm mits (6,000 x 12) kǝ tlujiyakha? ");
INSERT INTO gdf_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Ai da ka takaɗga ka kǝ mǝlaku mǝl, da righa ndarud vindzan na kǝ lav Yazhigǝle tsa kwargin kwarne, barari tsin dzoghǝr dzǝg ndǝkyani?” ");
INSERT INTO gdf_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ka nǝv Yasu kǝ dzakhava udakhe a sa da viya vi, “A sawala dǝ katsakar zǝ yaghwatakh kur kǝ da vika viya ngwaɗa sǝnkara? Itsera kǝ khǝna kǝn ndzǝgan ǝn tsagdutsag ǝn Fǝta Yazhigǝl, a vikai ba kur bi. ");
INSERT INTO gdf_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Ai daghan dǝgakhana dzoghǝra, a manga kǝ righada dǝge vindzga tlayangakh Yazhigǝl ǝn kaɗkaɗud.” Ka khwayala furakh sar daghan, ɗuwars itar. ");
INSERT INTO gdf_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Liye tsa viga Yasu, ka ɓal itar da fǝta Kayaf, zikan na kǝ zil kǝs. Li tsagdu ndzikha ndzikh zǝ malanakh ǝn tǝghǝr kǝ udakh audzala itar ǝn dzafkhai dzǝg ǝn vin. ");
INSERT INTO gdf_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Bitrus tsuguna an gatatǝrsk kǝ bit, tangw da tǝ gǝlvakh zikan na kǝ zil kǝs. Da tsina, ndzǝgan zǝ li uf udakh kǝ vaz ɗule da mbasda dǝge da dzoghǝr dzǝg. ");
INSERT INTO gdf_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Zik zikan na kǝ zil kǝsakh zǝ daghan li taka lav, ǝn gat udakhe da ǝntlarva lav fila fila itar ǝn tǝghǝr kǝ Yasu, kǝ nǝghda kǝɗa kǝɗa tsitar. ");
INSERT INTO gdf_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Itsa kitakula a mbǝladu ba itar bi, tsakhǝnmina zikǝn udakhe a sarawal kǝ ngatlarva fil. Kǝ dǝg mbasa ka sawala ud mits, ");
INSERT INTO gdf_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","Ka nǝv itar, “Nǝv udanǝn, ‘Tǝkha ka kǝ khǝtana Fǝta Yazhigǝl, ndǝrga kǝn khǝna khǝkǝrɗ.’ ” ");
INSERT INTO gdf_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Ka tsiyif zikan na kǝ zil kǝs, ka niya kǝ Yasu, “Na kha dǝ dǝge tǝkha kha kǝ kwargan ǝn tǝghǝr kǝ lave ǝn kwarud ǝn tǝghǝr tsǝkha?” ");
INSERT INTO gdf_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","A mbǝɗa ba Yasu ad khay bi. Ka nǝv zikan na kǝ zil kǝs tsin tsǝgun, “A takaɗ khe ka, a dzakhǝf ka dǝ Yazhigǝl dadak saf, kwara kǝnda kwar, da kha Kristu, Zǝr Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Ka nǝv Yasu tsin, “An kalkal ndǝkve kwargakh.” Ai ǝn kwara kura kwara kǝ, tsiyif tǝkhǝn, da nǝgha nǝgha kur Zǝr Ud ǝn ndzǝgan ǝn tǝ dǝva kaf Dadak Ndangan daghan, tsuguna ǝn sǝgdagh ǝn ghwik ǝn gharazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Ka kwakhdu zikan na kǝ zil kǝs ad katlang sar, ka ni, “A nenenan ad Yazhigǝl, wirva yan, uɗa dla lava tsǝkiyam ǝn gat tlǝrna shidakhi? Tǝkhina a tsǝna tsǝkur ad nena Yazhigǝle a mangin. ");
INSERT INTO gdf_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Uɗa ɗayaghǝruri?” Ka ngawa tsitar kwarne, “Khwaran sara kǝɗgud.” ");
INSERT INTO gdf_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Ka tafarve tar ad shaghwvai ǝn tǝ vakdi, ka kǝɗǝf itar. Chalǝmakh tsuguna ɗayarwar itar mekhwpeng. ");
INSERT INTO gdf_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","Ən kwar kwarne, “Kwara kǝnda kwar, kha Kristu, dadake barghǝr Yazhigǝl ad dǝv, war kǝ kǝɗkhǝfi?” ");
INSERT INTO gdf_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ən tǝ sarta yayena, ǝn ndzǝgan Bitrus ǝn tǝ gǝlvagh mǝghen, ka sasǝg kǝ dugh kuɗig mǝghen da vak sar, ka ni, “Fang ghǝragha ǝn tǝb kǝ liye zǝ Yasu ud Galili nǝ” ");
INSERT INTO gdf_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Ka bǝgan ad tsugu tsa Yasu ǝn tǝvuk tar daghan. Ka ni, “Ən tsa ba ka dǝge ǝn kwara kha lavǝn tǝghǝr bi.” ");
INSERT INTO gdf_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Ka dala Bitrus da tǝ ghay rang, ka nǝgha nǝgh kǝ tlǝrna dugh kuɗig, ka niya kǝ udakhe ǝn ghitsǝn vin, “Ina kǝ uda, dagh itar zǝ Yasu ud ya Nazarat.” ");
INSERT INTO gdf_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Ka gwidǝn bǝg tsugu tsin, zǝva waɗa tsin kwarne, “Ən tsa ba va ka dǝ udan na bi.” ");
INSERT INTO gdf_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Zula khǝɗikǝn, ka sasǝg kǝ li ǝn ghitsǝn vinen da vak Bitrus. Ka nǝv itar tsin, “Kaɗkaɗiya ghǝragha fang khǝn tǝb tar, wirva ghaye ǝn kwara kha, in kǝ mǝtlakhai.” ");
INSERT INTO gdf_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ka farsa Bitrus ad tlap ghǝrsar, zǝva waɗa tsin kwarne, “Ən tsa ba ka dǝ udan na bi.” Tǝvin tǝvin ka wuga kǝ ghwachik. ");
INSERT INTO gdf_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Ka dzamana Bitrus ad lav ai tsa kwararkhe Yasu kwarne, “Kǝda wuga kǝ ghwachik, da bǝg tsugu tsatsǝgarakh sig khǝkǝrɗ.” Ka dal da mel, ka tuwa tsin char. ");
INSERT INTO gdf_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Pǝrta kǝdl, daghan zikzikan na kǝ zil kǝsakh zǝ malanakhe ǝn tǝghǝr kǝ dlam, ka ɗayakavu itar dzanak kǝ kǝɗ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Ka ngwuɗana itar, bo itar ǝn tǝvuk, ɓala itar da vak Bilatus Gwumn. ");
INSERT INTO gdf_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Vazga kǝ Yakhud dadake sukwdu Yasu kwarne a tǝkavarna lav ǝmtsa kǝ Yasu, ka bazala rǝv tsin dǝ dǝge a mangin. Ka sa da vak zikzikan na kǝ zil kǝsakh zǝ malanakh ǝn tǝghǝr kǝ dlam, guyatǝrnǝf ad kwaɓ dawan kulkhǝkǝrɗǝn. ");
INSERT INTO gdf_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","Ni, “A manga ka khaip, kǝ sukwdu dadake kwal dǝ ghaz.” Ka nǝv itar, “Uɗa ɗangwundi? Ya ɗangwa yan.” ");
INSERT INTO gdf_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ka ɗiyars ad kwaɓ dawanen ǝn Fǝta Yazhigǝl, sawala, dakavala, ka khǝrtgan ad ghǝrsar. ");
INSERT INTO gdf_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Ka khutsanǝf zikzikan na kǝ zil kǝsakhen ad kwaɓen. Ka nǝv itar, “Kalkal ba ɗiga kwaɓ na tsud, ǝn vake ɗidud kwaɓ Fǝta Yazhigǝl bi. Wirva kwaɓ vizhinen.” ");
INSERT INTO gdf_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Ka ɗayakavu itar dzanak, ka sugwa itar vak dadake ndar dǝg ndǝr dǝ kwaɓen. Ki da nǝga tsin kǝ giɗengitl kǝstǝlakh. ");
INSERT INTO gdf_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Wirva yan, sakhkana ǝn ɗakha kǝ yanud ad vaken dǝ Vak Vizh. ");
INSERT INTO gdf_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Wirva yan, a righif lave tsa kwarga Rimi tlayang. Kwarne, “Ka ɓǝf itar kwaɓ dawan kulkhkǝrɗen, gane tsa kurga udakh ya Izrail kǝ pǝlapǝl ǝn tǝghǝr tsin. ");
INSERT INTO gdf_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","Sukgwa itar vak dadak ndar dǝg ndǝr dǝ kwaɓen, ndǝkve tsa kwarakhai Yazhigǝl Dadzikan.” ");
INSERT INTO gdf_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Madǝv Yasu ǝn ghitsǝn tǝvuk kǝ Bilatus Gwumn, ka ndiɗarwar Gwumn kwarne, “Kha nagh shik ya Yakhudakha?” Ka nǝv Yasu tsin, “An, kalkal a kwargakh.” ");
INSERT INTO gdf_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Ai kwarakhga kǝ zikzikan na kǝ zil kǝsakh zǝ malanakh ǝn tǝghǝr kǝ dlam, ad lav ghaze a ǝntlarva itar, a mbǝɗa ba dǝ ghay bi. ");
INSERT INTO gdf_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Ka nǝv Bilatus tsin, “A tsǝna bakha daghan lavakhan na ngatlakhvuda?” ");
INSERT INTO gdf_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A mbǝɗa ba Yasu ad itsauɗa bi. Itsǝn tǝghǝr kǝ kitakul kǝ lavakhe a ǝntlarva itar bi. A ndawanǝf ad Gwumn char. ");
INSERT INTO gdf_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Ən te itsera kǝ sarta khwaɗga fuɗkǝs ɗitsa ɗits, a kuyala Gwumn ǝn ɓalars dadak khaip kitakul sǝgawal ǝn gud sal. Ai naghga dlamakh ad ɓǝlars ɓǝl. ");
INSERT INTO gdf_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ən tǝ yanen kǝ sart, nǝg udanen ai tsaghud, a ɗǝmal ǝn gud sal, ɗakha sara Barabas. ");
INSERT INTO gdf_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Dzafkhai kǝ udakha, ka ndiɗatǝrwar Bilatus kwarne, “War na kur ɓǝlakurnars ɓǝla tsǝki? Yasu Barabase, nagha Yasu ai ǝn ɗakhdud dǝ Kristu khi?” ");
INSERT INTO gdf_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","A ndiɗga Bilatus ad ndiɗa na ndǝkyan, wirva tsatsin kwarne, a bǝdu itar ad Yasu ǝn dǝv sar kǝ wirva shilga. ");
INSERT INTO gdf_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Uk yan fang bi, madǝv Bilatus ǝn ndzǝgan ǝn tǝ vij taka lav, ka ɓǝlanǝf nus sar ad ud dǝ lava kǝ kwararkhai kwara kwarne, “Ɗuwars ɗuwa kwar lav ǝn tǝghǝr kǝ dadake kwal khaipǝn. Wirva a mbaka dlaɗ char, ǝn tǝghǝr kina kǝ ud khan ǝn suwan.” ");
INSERT INTO gdf_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Tǝkǝn zikzikan na kǝ zil kǝsakh zǝ malanakh ǝn tǝghǝr kǝ dlam, shakhanǝf itar udakh kǝ kwar kwarne, ɗuwars ɗuwud Barabas, ka kǝɗguɗ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Ka gwidǝn ndiɗatǝrwal Bilatus kǝ dzakhava udakh. “Warek ǝn tǝb tar ǝn nakur ɓǝlakurnars bǝla tsǝki?” Nǝv itara, “Barabas.” ");
INSERT INTO gdf_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ka ndiɗatǝrwal Bilatus kwarne, “Ai uɗa da mana ka dǝ Yasu ai ɗakhud dǝ Kristuwi?” Nǝv itar daghana, “Khǝrtǝga khǝrtud.” ");
INSERT INTO gdf_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ka ndiɗatǝrwar Bilatus kwarne, “Wirva uɗi? Uɗa dǝg bǝzane a mangini?” Ka sǝga ɗichaw kǝ udakh kwarne, “khǝrtǝga khǝrtud.” ");
INSERT INTO gdf_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Vazga kǝ Bilatus aghba dǝge tǝkhin kǝ mangan bi, tsugun a katlgan kwarne udakha ǝn tsikwva kǝ tsiya gadl. Ka ǝnkǝf ad yu, pargan ad dǝvakhsar ǝn tǝ vuk dzakhava udakh. Ka ni, “Na vizh ina kǝ ud ǝn kwindara bi. Ya ɗangur yan.” ");
INSERT INTO gdf_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Ka ngauga udakhen daghan kwarne, “Nalnǝg vizh sar ǝn kwindǝnda zǝ kwinda zarakhǝnd.” ");
INSERT INTO gdf_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Ka ɓǝlatǝrnars ad Barabas. Ən tǝkhal kǝ ba udakh tsin kǝ wadzaru kiɓ kǝ Yasu, ka bǝdu kǝ khǝrtga khǝrt. ");
INSERT INTO gdf_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ka ɓalɓa kǝ tlujiyakh Gwumna Bilatus ad Yasu da tǝ gǝlvagh Gwumn, daghan tlujiyakhe ǝn dakwalen tsuguna a tsarghǝr itar. ");
INSERT INTO gdf_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Sakhardo itar kadlang, ka talarǝm itar shalaraz, khulf katlang shikakh. ");
INSERT INTO gdf_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Mbusaga itar dzakw man tlǝks dǝ tak, barǝm itar ǝn ghǝr. Ka ba itar da khuta gulv man tlǝks ǝn dǝva kaf sar. Khala kǝ yana ka kalaga itar juguv ǝn tǝ vuk sar, ka tsafatsafa tsitar, ka nǝv itar, “Dǝg safagh da tǝ uragh, Shik ya Yakhudakh.” ");
INSERT INTO gdf_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Tafarava itar shaghwvai da tǝ vǝgh. Ka chawarvar itar yaghwat man tlǝksen, dlaghar khai itar kǝɗa din ǝn ghǝr tsǝgun. ");
INSERT INTO gdf_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Udzal tsitar ǝn tsafatsafa, ka sakhardu itar gabag man tlǝkse tsa talarǝm itar. Ka talarǝm itar katlangakh sar. Ka ɓǝlando itar ǝn tǝvuk, ka ɓala itar kǝ wirva khǝrta khǝrt. ");
INSERT INTO gdf_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Madǝv itar ǝn tǝghǝr kǝ dǝga, ka gamga itar zǝ ud ya Sayirin, ɗakha sara Siman. Ka barghǝr itar dǝ ndzǝɗ ad zǝɓ ufa khǝrte da khǝrtdud Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Sara da vake ǝn ɗakhud dǝ Golgot (dǝge ǝn tukuwina in, vak tlatl ghǝr). ");
INSERT INTO gdf_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ən vin a bara itar yu inabi laɓan dǝ dǝg ɗekhɗekhan. Tapana tsina, ka kalwal kǝ khǝɓakhǝɓ. ");
INSERT INTO gdf_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Ən tǝkhal kǝ khǝrtǝga khǝrta tsitar ǝn tǝ ufa khǝrt, ka man tsats tsitar ki da taka gabagakh sar. ");
INSERT INTO gdf_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Ən tǝkhal kǝ yana, ka ndzakhga itar ǝn tǝ vin kǝ ufauf. ");
INSERT INTO gdf_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Ka tsakhga itar ad ghaza sare ǝn kwara itar, ǝn tǝ vakghǝr sar kwarne, “INA YASU, SHIK YA YAKHUDAKH.” ");
INSERT INTO gdf_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Khǝrtga itar tsugun ad sǝnkarakh mits ǝn tǝvǝgh kǝ Yasu. Fanga ǝn tǝ dǝva kaf tsin, yan tsuguna ǝn tǝ dǝva dleɓ sar. ");
INSERT INTO gdf_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Udakhe ǝn dǝgal, ka tsafatsafa itar ad Yasu, ka kaɗaghǝr itar. ");
INSERT INTO gdf_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","Ka nǝv itar, “Khai ǝn kwarne tǝkhakha kǝ khǝtana Fǝta Yazhigǝl, ka gwiɗǝn ndǝrgakhǝn tǝ khǝna khǝkǝrɗ. Ai kata dǝ ghǝragh. Da Zǝr Yazhigǝl khǝ, sodagh sǝg ǝn tǝ ufa khǝrtan.” ");
INSERT INTO gdf_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ndǝkyan tsugun kǝ zikzikan na kǝ zil kǝsakh, zǝ li tsagdu ndzikha ndzikh Mus, zǝ malanakh ǝn tǝghǝr kǝ dlam, ka tsafatsafa tsitar kwarne, ");
INSERT INTO gdf_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“A katgan ad yakhai, in tsuguna a piyarwal kat ghǝr sar. Shik ya Izrail bakhini? Sodagh sǝgin ǝn tǝ ufa khǝrtana tǝkhin, ka fadǝghǝro kǝnda din. ");
INSERT INTO gdf_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","A bo dǝ ghǝr ǝn tǝ Yazhigǝl. Ai katga kata Yazhigǝlen tǝkhin, dǝn wayawayin. Wirva Zǝr Yazhigǝl ka ni.” ");
INSERT INTO gdf_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ndǝkyan sǝnkarakh ai khǝrt tǝrkhai ud dagh, ghǝrtar tsuguna kwarar khai itar lav bǝzan. ");
INSERT INTO gdf_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ən tǝ fatsi tǝghǝr, ka khǝɗardu ngurtl ad khaya kǝsen daghan, tangw da tǝ karfi khǝkǝrɗa khakhug. ");
INSERT INTO gdf_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ən tǝ kalkala karfi khǝkǝrɗa khahughen, ka tlǝkha tsin char kwarne, “Elo, Elo, lama sabaktani?” Dǝge ǝn tukuwina in, “Yazhigǝla, Yazhigǝla, a ɗukǝdai ndar kha ndikini?” ");
INSERT INTO gdf_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Chalǝm udakhe ǝn ghitsǝn tǝvin, tsǝna tsitar ad inen, ka nǝv itar, “Ina kǝ uda, ǝn ɗakh Ili Tlayang.” ");
INSERT INTO gdf_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ən dǝvǝn dǝva, ka khwayala fang ǝn tǝb tar, ɓadǝghǝr ad zǝr ndǝma ndǝm, luɓanan ǝn yu Inabi kwarekrekan. Siɓau ǝn tǝ yaghwat, ka talaro kǝ Yasu kǝ ɗutsaɗuts. ");
INSERT INTO gdf_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Ka nǝv chalǝmakh, “A ɗuwaman ndan, nǝgha nǝgha kiyam ndan patak da sǝgadagh Ili da katakat.” ");
INSERT INTO gdf_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ka gwidǝn Yasu ǝn tlǝkha char, ka ɗi safa tsin, ɓawala safa sar. ");
INSERT INTO gdf_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Ən tǝ yanen kǝ sart, lǝgwit ghay gud ai ǝn Fǝta Yazhigǝla tiɗǝm mits, tsif ǝn tǝ vak ghǝr kakh da tǝ khay. Khay tsuguna a giɗikǝfkhai, tiɗakhǝm kurakh. ");
INSERT INTO gdf_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Ka chaɓga ngitlakha ngwarǝf itar. Zikǝn udakh ya Yazhigǝle tsa rugana, a tsayatǝrǝfud dǝ saf. ");
INSERT INTO gdf_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Sakhawal itar ǝn ngitlakh tar. Ən khal kǝ tsif tsiya kǝ Yasu ǝn ngitl, ka dal itar da Wurshalim, chuwaɗaɗan kǝ dlǝmda kǝs. A mǝdlawa itar kǝ udakh zikǝn. ");
INSERT INTO gdf_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Nǝgha kǝ zikan kǝ tluji zǝ chalǝm tlujiyakhe ǝn uf Yasu ad mbǝɗa pǝgdǝm zǝ daghan dǝgakhe dzoghǝr, a gadzǝf itar char. Ka nǝv itar. “Zǝr Yazhigǝl ina kaɗi kaɗi.” ");
INSERT INTO gdf_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Nǝg chalǝm nughwaskh zikǝn tsugun ǝn vinen, ǝn vaza vaza kǝ bit. Liye tsa gatars kǝ Yasu gwil sǝgawal ǝn Galili, ǝn nǝgharu nǝgha itar. ");
INSERT INTO gdf_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ən tǝb tara nǝg Maryam ǝn kǝs ya Magdal, zǝ Maryam bab Yakub zǝ Yusuvu, zǝ nus Zabadi. ");
INSERT INTO gdf_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Ɓǝlga kǝ khakhug, ka sa ud ya Armati, dadak tluwadal, ɗakha sara Yusuvu. In tsuguna fura Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Ka da da vak Bilatus shik da takaɗ tluvǝgha Yasu. Ka kwara tǝrkhai Bilatus ad bara tluvǝgha Yasu tsud kǝ Yusuvu. ");
INSERT INTO gdf_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ka ɓǝf Yusuvu ad tluvǝgha Yasu, mbusanǝm ǝn wilwa lapin. ");
INSERT INTO gdf_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Ka khǝnanan Yusuvu ǝn gitl sare tsa khuradalin ǝn khurzǝzǝ. Ka tlǝgaru ad kur zikan, ka tǝkaval. ");
INSERT INTO gdf_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Maryam ǝn kǝs ya Magdal, zǝ tlǝrne ai ɗakhdud dǝ Maryam ǝn ndzǝgan itar ǝn vin, ǝn vaza ger da tǝ ngitlen. ");
INSERT INTO gdf_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Tǝkǝdla sar kǝ fitsa fǝtav, ka dala zikzikan na kǝ zil kǝsakh zǝ Farisakh da vak Bilatus. ");
INSERT INTO gdf_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Nǝv itar, “Dǝg safagh da tǝ uragh, a dzamana kǝnda ad sarte tsa dla dadak valdu udakh na dǝ saf, kwarne, ‘Fitsa khǝkǝrɗa da tsiya ka dǝ saf.’ ");
INSERT INTO gdf_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Wirva yan, babǝg ad udakh kǝ uf ngitlen char tangw da tǝ khǝna khǝkǝrɗ. Ki khek dǝgal kǝ furakh sar da gǝl tluvǝgh sar, kwarar khai itar kǝ udakh tsugun kwarne, ‘A tsiyif ǝn ngitl.’ Ya valdu udakhe kǝ dǝg mbas, da malamala dǝ dǝg chak kǝ bǝz.” ");
INSERT INTO gdf_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ka nǝv Bilatus tsitar, “Khutsamǝf tlujiyakh, dam da ufaufa ad ngitlen, khalavuwa tǝkhur.” ");
INSERT INTO gdf_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Ka dǝgala itar kǝ gadlara gǝma gǝma kǝ itsawar ad ngitlen, ǝn tǝ dǝva dǝ tsakhga jakva ndzǝɗa shik ǝn tǝ kur ghay ngitlen. Tsuguna ka ba itar tlujiyakh kǝ ufauf. ");
INSERT INTO gdf_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ən tǝkhal kǝ fǝtav, tǝkǝtlapǝrt fitsa tugwa chak kǝ kasuk, Maryam ǝn kǝs ya Magdal zǝ tlǝrne ai ɗakhdud dǝ Maryam, dala itar da nǝgha ngitl. ");
INSERT INTO gdf_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Kǝda dǝgal tsitar, a mangud mbǝɗa pǝgdǝm, wirva zǝrɓǝla Dadzikan a sodagh ǝn gharazhigǝl, tlǝgarwar ad kur ǝn tukw ngitlen, ka ndzo ǝn tǝf. ");
INSERT INTO gdf_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Da nǝgha tsǝkha ǝn wuɗa tsuwaɗaɗ, katlangan vǝgha sar tsuguna til ndǝk chachaɗ. ");
INSERT INTO gdf_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Nǝgha kǝ li ufa ngitlen, a gǝdzǝf itar char, ka tǝga vǝgh tsitar. Mbaɗakhga itar da khay ngwaɗa ǝmtsa udakh. ");
INSERT INTO gdf_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Ai ka nǝv zǝrɓǝla Yazhigǝlen kǝ nughwasakhen, “Gǝdzam bi, tsatsǝka Yasu ǝn gata kur, ai tsa khǝrtavan. ");
INSERT INTO gdf_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Aghbǝn vana bi, a tsif ndǝk vai tsa kwargin. Ausǝgam nǝghama nǝgha vakai tsa khǝnganin. ");
INSERT INTO gdf_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Damdǝgal kujaɗ kujaɗ, kwarama tǝrkhai kwar kǝ furakh sar kwarne, ‘A tsiyif ǝn ngitl. Kǝvena ǝn tǝvukur in da dal tsukur da Galili. Da nǝghǝn vin kur.’ Tsǝnam tsǝn, niya audzal kǝn kwarakur khai kwar.” ");
INSERT INTO gdf_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Ka ɗuwars itar ad vak ngitl kujaɗ kujaɗ, dǝ gǝdza zǝ khwaɗga char. Khwayala itar da kwarara kwara kǝ furakh sar. ");
INSERT INTO gdf_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Dzagwdlam ka tlatǝrghǝr Yasu kǝ nughwasakhen, ka niya tsitar, “Gabǝr ǝn tǝghǝr kǝ tsǝkur.” Ka zǝghvoghǝr itar da vak sar, khwtana itar ǝn tǝ sigakh sar, ka ɗabanǝf itar. ");
INSERT INTO gdf_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Ka nǝv Yasu tsitar, “Gǝdzam bi. Dam da kwarara kǝ zar babakhar dǝg itar da Galili, ǝn vin da nǝghaka itar.” ");
INSERT INTO gdf_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Madv nughwasakhen ǝn tǝghǝr dǝga tar, chalǝm kǝ li uf ngitlen dagh itar daks da dlǝmdla kǝs, ka tugwarkhai itar ak zikzikan na kǝ zil kǝsakh ad ɗaga dǝgakhe a dzoghǝr. ");
INSERT INTO gdf_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Dzafkhai zikzikan na kǝ zil kǝsakh zǝ malanakh ǝn tǝghǝr kǝ udakh ɗaya kavu itar lavakh ǝn tǝb tar kwarne, batǝra bǝg itar kwaɓ kǝ tlujiyakhna zikǝn. ");
INSERT INTO gdf_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","Nǝv itar kǝ tlujiyakhen, “Dǝge da kwara kur, ‘Furakh sar kǝ sa kǝviɗ kǝ gǝlalgǝl, madv kǝnd ǝn khar.’ ");
INSERT INTO gdf_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Da dagh lavana da tlim kǝ Gumn, da kwarara lava kǝnd kwarne na ghazur bi, wirva yan na dǝge da gǝma kuran bi.” ");
INSERT INTO gdf_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Ka chauga tlujiyakh ad kwaɓen, manga itar ndǝkve tsa kwara tǝrkhai yud. Ina kǝ lava sakhkana, dla Yahudakh ǝn kwarakha kavu kwar ǝn tǝb tar. ");
INSERT INTO gdf_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Ka dǝgala kǝ furakhan na kǝlatǝm kitakw da Galili, do itar da ghuɓe tsa kwara tǝrkhai Yasu. ");
INSERT INTO gdf_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Nǝgha tsitara, ka ɗabanǝf itar, ai yakhaye ǝn tǝb tar a khayanǝf ba itar kwarne patak in bi. ");
INSERT INTO gdf_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Ka sa Yasu khǝrzha ditar, ka ni, “Ɗaga nɗzǝɗe ǝn gharazhigǝl zen lard, a baka tsǝkud. ");
INSERT INTO gdf_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Wirva yan, dam da nandal udakh ǝn lard daghan kǝ nǝga kǝ furakhar. Paratǝra para kur ǝn ɗakha Dada, zǝ Zǝra, zǝ Sǝɗikw Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ka tsagatǝrdu tsaga kur, kǝ tsǝnaru kǝ ɗaga dǝgakhai a kwarakur khai kǝ. Da dagha ka zǝ kur tsika fatsi, tangw da tǝ mbasa lard.”");
INSERT INTO gdf_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Auna ɗule a farsud kwar lav zǝɗan ǝn tǝghǝr kǝ Yasu Kristu, Zǝr Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","A farsud ndǝkve a vindzgud ǝn kaɗkaɗ Ishay tlayang kwarne, “Da ɓǝla ɓǝla ka dǝ zǝr ɓǝlar, sadaghin ǝn tǝvuk tsǝkh, dadake da ɗika ɗul wirvakh.” ");
INSERT INTO gdf_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","“Udanen ǝn kwar lav dǝ ndzǝɗ ǝn tǝghal kwarne, ‘Ɗikamarna ɗul kǝ Dad Zikan, nandal kur ɗul sar ger.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ka mǝdlawala Yukhan dadak para ud ǝn tǝghal, ǝn kwardu lav kwarne pǝla udakh ad ghǝr, paratǝralud, ɓisatǝrna Yazhigǝl tsugun ad khaipakh tar. ");
INSERT INTO gdf_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Daghan udakhe ǝn ǝntla khaya ya Yakhudi zǝ udakh ya Wurshalim a dalar da vak sar, ǝn kwarakh khaipakh tar itar. In tsuguna ka paratǝral ǝn zagh ya Urdu. ");
INSERT INTO gdf_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","A talǝm Yukhan ad gabage a manava dǝ guj dlǝgwam, nguɗan sambal ǝn tǝ khukw tsin, dǝg zuwa sar tsuguna, tsǝvakwa zǝ yu mame ǝn tǝghal. ");
INSERT INTO gdf_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","A kwara tǝrkhai ad lav Yazhigǝl kwarne, “Nǝg dadake da sǝgadagh ǝn tǝ tǝlg tsǝk, ai malke kǝ ndang. Ai kwal tǝkha tsǝka kǝ ɓukgan kǝ vǝda zaw kimbak sar bi. ");
INSERT INTO gdf_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","A para kurar ka dǝ yu, in tsuguna da para kura dǝ Sǝɗikw Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ən tǝ yanen kǝ sarta ka tsiyif Yasu sǝgadagh ǝn kǝs Nazarat ai ǝn khaya Galili, ka parandal Yukhan ǝn zagh Urdu. ");
INSERT INTO gdf_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Madǝv Yasu ǝn sǝgawal da tǝghay gǝrdz, ka nǝghan ad gharazhigǝl a ngurǝf, ka sodagh Sǝɗikw da tǝghǝr tsin ndǝk takalamasar. ");
INSERT INTO gdf_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Ka tsǝnud kwind ǝn gharazhigǝl kwarne, “Kha Zǝrar, ǝn way kha waya kǝ. Ən tsǝn zǝɗa ka char.” ");
INSERT INTO gdf_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ən tǝvin tǝvina, ka ɓala Sǝɗikw da tǝghal. ");
INSERT INTO gdf_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Ən tǝghalena khǝna kul ufaɗ kǝ Shatan uk ǝn kura kur. Ən giɗa zǝ dǝg tǝghalakh itar ǝn vin. Ka nǝgharu Zar ɓǝlakh Yazhigǝl ǝn vin. ");
INSERT INTO gdf_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Ən tǝkhal kǝ nguɗana Yukhan tsud ǝn gud sal, ka tsiyif Yasu, dal da Galili, ǝn kwardu lav Yazhigǝl ai zǝɗanyan. ");
INSERT INTO gdf_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Ən kwar kwarne “A sagh sart, tlǝksa Yazhigǝla a ghǝrzgan. Pǝlam pǝla ghǝr, tsuguna fadǝghǝro kuram ǝn tǝ lav zǝɗan nǝn.” ");
INSERT INTO gdf_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Madǝv Yasu ǝn dǝgal ǝn tǝ kalam zagh Galili, ka nǝghan ad Siman zǝ saghǝr sar Ndros, ǝn ɗi sik vay kilf itar da dǝlv, wirva li vay kilf itar. ");
INSERT INTO gdf_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Ka nǝv Yasu, “Ausǝgam, gatamaks gat, da nakura kǝ li da ɗakhado udakh ka da vak Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Ən dǝvǝn dǝva, ka ɗuwars itar sika vay kilf tar, ka gatars itar. ");
INSERT INTO gdf_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Daga tsin da tǝvuk khǝɗikǝn, ka nǝghan ad yakhaya kǝ zarbabakh mits tsugun, Yakub zǝ Yukhan zar Zabadi ǝn peryu. Ən ɗika sik vay kilf itar. ");
INSERT INTO gdf_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Ən dǝvǝn dǝva ka ɗakh tǝrkhai, ka ɗuwars itar ad dad tar Zabadi ǝn peryu, zǝ zar tlǝr sar, gatars itar. ");
INSERT INTO gdf_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ka dagh Yasu zǝ furakh sar da Kafarnakhum. Sa kǝ fitsa ngiya ya Yakhudakh, dagh Yasu da gud dzakhava Yakhudakh. Ka farsa tsagatǝrdu tsag. ");
INSERT INTO gdf_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","A ndawatǝrǝf tsagdu tsaga sar kǝ udakh, wirva a tsagatǝru ad lava ndǝk ude dǝ ndzǝɗ, ndǝk liye ǝn tsagdu ndzikha ndzikh bi. ");
INSERT INTO gdf_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","A zulava bi, ka sasǝg kǝ udanen ai nguyanǝf sǝɗikw bǝzan da vak dzakhava Yakhudakh. Ka tlǝkha tsin kwarne, ");
INSERT INTO gdf_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Uɗa ɗangwa tsǝkha dǝ kǝnda, Yasu ud ya Nazarati? A sa da khǝdz kǝnd khǝdza nagh kha? Tsakha tsǝka, kha Chuwaɗaɗan ai ɓǝlandagh Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Ka tavarghǝr Yasu ad di kǝ sǝɗikw bǝzan kwarne, “Tǝriɗ nǝkh, sawal sǝg ǝn vǝgh kǝ udan.” ");
INSERT INTO gdf_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Ka gǝɗikanǝf sǝɗikw bǝzan na dǝ yanen kǝ ud. Ka khula, sawal ǝn vǝgh tsin. ");
INSERT INTO gdf_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Daghan udakhe ǝn vin, a ndawatǝrǝf char. Ən ndiɗakava tsitar kwarne, “Uɗe neni? Wilwa tsagdu tsaga nagha? Udan na ǝn tsagdu tsaga dǝ ndzǝɗ. Zǝ batǝrghǝr bǝg tsin kǝ sǝɗikw bǝzanakh, kǝ tsǝnaru kǝ lav sar. ");
INSERT INTO gdf_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ən dǝvǝn dǝva ka kwazga lavǝn tǝghǝr tsin, ǝn khaya Galili daghan. ");
INSERT INTO gdf_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Uk sawal sǝg tsitar ǝn gud dzakhava Yakhudakha, ka dagh Yasu zǝ Yakub zǝ Yukhan ger da fǝta zai Siman zǝ Ndros. ");
INSERT INTO gdf_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Bab nus Simana, ǝn khǝngan ǝn tuk magwǝlaɓ. Kujaɗ kujaɗa ka kwarar khai itar kǝ Yasu ad lav ǝn tǝghǝr tsin. ");
INSERT INTO gdf_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Ka dagh da vak sar, ka khutanan ǝn tǝ dǝv kǝ mǝlaru kǝ tsiya tsi. Tǝvin tǝvina, ka mbu ǝn tuk magwǝlaɓ, ka tatǝr khai ad dǝgway. ");
INSERT INTO gdf_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Kǝ khagw fitsa yanen, ɓǝldagh kǝ fatsi. Ka zaɓardǝghǝr udakh ad daghan liye kwal yang, zǝ liye ngwiyanǝf sǝɗikw bǝzan. ");
INSERT INTO gdf_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ka dzafkhai udakhe ǝn khuɗ kǝs daghan ǝn tǝghay rang. ");
INSERT INTO gdf_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ka mbakhatǝru Yasu kǝ udakh zikǝn, liye dǝ kuzakh sikh sikh sikh. Ka dzǝtǝrdal kǝ wurduwakh zikǝn. Ai a ɓǝlatǝrna ba dǝ kwal lava kǝ wurduwakhen bi. Wirva tsa tsitar khulfira kǝ ud Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Pǝrta kǝdla, ǝn sarta warkhamen, ka tsiyif Yasu, ɗuwars ad mǝgh, ka dala da vake kwal nǝg kǝ itsawar, ka ɗǝgau. ");
INSERT INTO gdf_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Simana, zǝ liye ǝn dǝga itar dagh, a dalar da gat Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Tlarghǝr tsitara, “Udakh daghana ǝn gatkha gata” Nǝv itar tsin. ");
INSERT INTO gdf_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Ka ngawa tǝrkhai Yasu, “Dziyamal da tlǝrna gǝdzar kǝsakhe khef, ki da kwardu lav Yazhigǝl tsǝkǝn vin. A sodagh kǝ wirva yan kǝ. ");
INSERT INTO gdf_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Ka gwayafkhai ǝn khuɗ kǝ Galili daghan, ǝn kwardu lav Yazhigǝl ǝn gud dzakhava Yakhudakh, zǝ dzatǝrdu wurduwakh ǝn vǝgh kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Ka sasǝg kǝ ude dǝ kuza fǝch da vak Yasu, kǝlgan ad juguv kǝ takaɗa takaɗ, “Da khayanǝf khǝ, tǝkha kha kǝ ghuɓkay tsǝrdlak.” ");
INSERT INTO gdf_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Ka kwiɗ nǝv rǝv kǝ Yasu. Talala dǝ dǝv sara ka gǝman ad udanen. Ka ni, “A khayanǝf kǝ, ghuɓfǝkhay ghuɓa tsǝrdlak” ");
INSERT INTO gdf_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Ən dǝvǝn dǝva ka ghuɓfǝkhay tsǝrdlak ǝn tukw fǝchen. ");
INSERT INTO gdf_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Ka tǝkharna Yasu ad lava char, daksa niya tsin. ");
INSERT INTO gdf_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Kwarara ba ak itsawar ad dǝge dzoghǝr bi. Dǝg dǝgal, mǝdlara mǝdla ghǝragh kǝ zil kǝs. Ka bǝdu kha dǝg tsufe kwarga ndzikha ndzikh Mus, wirva ghuɓe a ghuɓkhayud. Ki tsatsǝg kǝ itsawar kwarne a ghuɓkhayud. ");
INSERT INTO gdf_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Ai udanen tsuguna, uk dǝgal ǝn kwardu kwara tsin ad dǝge a manar khai Yasu. A ɓǝghana ba dǝ itsauɗa bi. Wirva yana, ka aghba Yasu tǝkha kǝ dagh da khuɗ kǝs ǝn di kǝ ud bi. Khalak yana ka giɗkavǝn vakakhe kwal nǝg kǝ ud. Dakhkana ka dla udakh ǝn saghgawala da vak sar itsa dǝvar. ");
INSERT INTO gdf_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Khal kǝ khǝna khǝɗikǝna, ka gwidǝn dagh Yasu da Kafarnakhum. Ka tsǝna udakh kwarne a sagh da mǝgh. ");
INSERT INTO gdf_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","Ka dzafkhai udakh dingǝrik, kwal dla kǝ vake a tǝmgan, itsǝn tǝ ghay rang. Ka kwaratǝra lav Yazhigǝl tsin. ");
INSERT INTO gdf_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Ka ɓardǝghǝr chalǝm udakh ufaɗ, ad dadak mǝtsa tlepel vǝgh. ");
INSERT INTO gdf_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Fatsiye piyatǝrwal daks din da vak Yasu, wirva dzakhava udakh. Ka pǝsdu itar ghǝr gud kalkal dǝ vake din Yasu. Pǝsdu tsitara, ka taldagh itar ad dadak mǝtsa tlepel vǝghen ǝn khǝngan ǝn tǝ khindz, da tǝvuk Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Nǝgha kǝ Yasu ad fadǝghǝrofǝga tar, ka niya kǝ dadak mǝtsa tlepel vǝghen, “Zǝrara, a ɓisakhanud khaipakhagh.” ");
INSERT INTO gdf_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nǝg li tsagdu ndzikha ndzikh Mus ǝn ndzǝgan ǝn tǝvin, ǝn ɗayakava ghǝr itar ǝn revakhuɗ tar. ");
INSERT INTO gdf_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Uɗa lava kǝ udan nǝn kwar yan kǝ lava ndǝkyani? Ən nena Yazhigǝl. Warek tǝkha kǝ ɓisana khaipakh da na Yazhigǝl kitakul biyi?” ");
INSERT INTO gdf_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Tǝvin tǝvina tsa kǝ Yasu ad dǝge ǝn ɗaya itar ǝn rǝvakhuɗ tar. Ka niya tsitar, “Uɗa lava tsukur ǝn ɗayakava ina kǝ dǝgitakh ǝn rǝvakhuɗuri? ");
INSERT INTO gdf_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ira kujaɗan kǝ manara? ‘Kǝ kwar kwarne, a ɓisakhanud khaipakhaghe,’ Awana, ‘Tsiyif tsiya, ɓa dǝ khindzagha kwa dǝga khi?’ ");
INSERT INTO gdf_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Ai ǝn na ka tsatsǝg tsukur kwarne, Zǝr Uda nǝg dǝ ndzǝɗa ɓisara khaipakh kǝ udakh ǝn lardǝn.” Ka niya kǝ dadak mǝtsa tlepel vǝghen, ");
INSERT INTO gdf_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“A kwarakhai kǝ, tsiyif tsi, ɓa dǝ khindzagh dǝg daks da mǝgh.” ");
INSERT INTO gdf_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ka tsiyif, ɓǝf ad khindza sar ka dǝgal, ɗaga udakh tsuguna ǝn vazavaz. Ina kǝ dǝgita a ndawatǝrǝf kǝ udakh daghan, ka mbaɗ Yazhigǝl itar, ǝn kwar kwarne, “A tapa bakǝnda nǝgha dǝgit ndǝk ina bi.” ");
INSERT INTO gdf_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ka gwidǝn Yasu dǝgal da tukw ghay dǝlv. Ən sakha saks udakh zikǝn da vak sar, in tsuguna ǝn tsagatǝrdu tsag. ");
INSERT INTO gdf_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Madǝvin ǝn dǝg, ka nǝgha nǝgha tsin ad Lawi zǝr Half ǝn ndzǝgan ǝn gud chaw khadam. Nǝv Yasu tsin, “Tsiyif tsiya, gataks gat.” Ka tsiyif Lawiya, gatars. ");
INSERT INTO gdf_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Madǝv Yasu zǝ furakh sar ǝn zu kaf ǝn fǝta Lawi. Nǝg chalǝm udakhe ghǝr tar tsuguna li man khaip ndǝk li chaw khadam, ǝn zu kaf itar dagh. Wirvǝn gatars gata khutsa khutsa udakh. ");
INSERT INTO gdf_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Nǝgha kǝ yakhaya kǝ Farisakh li tsagdu ndzikha ndzikh Mus, ad Yasu ǝn zu kaf zǝ li khaipakh, zǝ li chaw khadam liye ghǝrtara li khaip. Ka ndiɗarwal itar kǝ furakh sar kwarne, “Uɗa lava tsin ǝn zu kaf zǝ li chaw khadam zǝ liye ghǝrtara li khaipi?” ");
INSERT INTO gdf_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Tsǝna tsin ad yan, ka nǝv Yasu tsitar, “Liye yanga bǝn gat dadak ngura bi, akwa liye kwal yang. A so da ɗagh li kanadi baka bi, ai li khaipakh.” ");
INSERT INTO gdf_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Furakh Yukhan zǝ dǝg Farisakh ǝn zǝɓ ndǝl itar. Ka sa chalǝm udakha, ka ndiɗarwal itar kǝ Yasu, “A sa ndar furakh Yukhan zǝ dǝg Farisakh ǝn zǝɓ ndǝl itara, ai furakhagha naba itar biyi?” ");
INSERT INTO gdf_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ka nggauga Yasu kwarne, “Da mana ndar tsaghwakh zil ghaul ad ndǝl, dla itar dagha zǝ zil ghauli? Ən manawa bi. Fatsiye dla zil ghaul dagha zitar, na itar da zǝɓ ndǝl bi. ");
INSERT INTO gdf_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Da saks sarte da ɓatǝrvalud zil ghaul ǝn vak tar, ǝn tǝ yanen kǝ sart da zǝɓa itar ndǝl. ");
INSERT INTO gdf_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Na ude ǝn ndzǝgharu wilwa kachakach kǝ mughura gabag bi. Da mangud ndǝkyan, ka da mǝɗukwa wilwan sǝgawal ǝn tǝ mughuran, ka da kukhwa mal kǝ ai tsa chak. ");
INSERT INTO gdf_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Tsuguna na ude ǝn ɗi wilwa yu inabi da mughuran kǝ mbǝl vighakh bi. Da mangud ndǝkyana, ka da chǝɓ chǝɓa yu inabi ad mughur mbǝl vighakhen, yu inabi zǝ mbǝl vighakhena, bǝrdagha tara da bǝghud ǝmb. Ən manawa bi, khekwa wilwa yu inabi ǝn ɗiyud ǝn wilwa mbǝl vighakh.” ");
INSERT INTO gdf_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Fitsa tlǝrn kǝ kasukw nggi, madǝv Yasu zǝ furakh sar ǝn dǝgal diwa gukh lǝkam. Madǝv itar ǝn dǝgal, ka farsa furakh sar ad kwakhu ghǝr lǝkam. ");
INSERT INTO gdf_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Nǝgha kǝ Farisakh ndǝk yan, ka ndiɗarwar itar kwarne, “Uɗa lava tsitar ǝn man dǝge kwal kalkal fitsa nggiyi?” ");
INSERT INTO gdf_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","Ka nggawa tǝrkhai kwarne, “A tugwa bakh kur dǝge a manga Doda? Ndzikǝnǝf kǝ way zǝ liye ǝn dǝga itar dagh, tsuguna ǝn nagha itar digita? ");
INSERT INTO gdf_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","Ən kwarga Abiyat zikan na kǝ zil kǝs. Dagh Dod da fǝta Yazhigǝl, ka zu ad brudiye a bandalud, ai kalkal ba zuwa zuwa kǝ itsawar bi. Uk zil kǝsakh kalti ǝn zuwan. Ka baran kǝ tsaghwakh sar kǝ zuwa zuwa tsitar. ");
INSERT INTO gdf_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Ka niya tsitar, a barkhai kǝ udud ad fitsa nggi, a vǝrɗava ba ud wirva kǝ fitsa nggiya bi. ");
INSERT INTO gdf_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Wirva yan, Zǝr Ud, in Dad Zikan, in Dad Zikan fitsa nggiya tsugun. ");
INSERT INTO gdf_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Fitsa tlǝrn tsuguna, a da Yasu da gud dzakhava Yakhudakh. Ka nǝg udanen dadak mǝtsa dǝv ǝn vinen. ");
INSERT INTO gdf_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ən tǝb kǝ udakhe ǝn vin, nǝg liye ǝn gat ɗule da vide tar Yasu dǝ ghaz. Ka vaza vaza tsitar ɗem, tsaghe da mbambǝgin ad udanen fitsa nggi. ");
INSERT INTO gdf_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Nǝv Yasu kǝ dadak mǝtsa dǝven, “Tsiyif tsi, ausǝg, ghitsga ghits ǝn van.” ");
INSERT INTO gdf_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Ka ndiɗatǝrwal Yasu kwarne, “Ira dǝge khwara kǝ mana mana fitsa nggiyi? Man dǝg khwarane, awana dǝg bǝzan khi? Kat safa fitsa nggiye, awana kǝɗga dǝ kǝɗa khi? ");
INSERT INTO gdf_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ka vazakh tǝrkhai dǝ bazarǝv, wirva ɓengɓeng rǝve din itar. Ka niya kǝ udanǝn, “Taladal dǝvagh.” Ka taladal, tǝvin tǝvina ka mbu dǝv sar ndiɗ. ");
INSERT INTO gdf_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Nǝgha kǝ Farisakh ndǝkyan, ka dǝgal tsitar da ɗembar lava zǝ liye tlǝkhara lǝg kǝ Khiridus, ad ɗule da kǝɗ da itar Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Ka sawal Yasu zǝ furakh sar ǝn tǝb kǝ udakh, dǝgal da tǝ ghay dǝlv, zikǝn udakhe ǝn khaya Galili a gatars. ");
INSERT INTO gdf_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Tsǝna kǝ udakh ad lav ǝn tǝghǝr kǝ dǝgakhe ǝn manin daghan. Zikǝn udakhe ǝn ǝntla khaya ya Yakhudi, Wursalim, zǝ ǝntla khaya ya Edom, zǝ li khǝdzǝva gadzak zagh Urdu, zǝ udakh ya Taya zǝ Sidon, a sawal da vak sar. ");
INSERT INTO gdf_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Wirva zika udakha, ka kwarar khai Yasu kǝ furakh sar, kǝ ɗikarna khǝɗikan na kǝ peryu, ki khek tlǝgars kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Wirva a mbakhatǝru kǝ udakh zikǝn. In kǝ mangan kǝ liye tukw kuzakh ǝn tlagǝva daks da gǝmagǝm. ");
INSERT INTO gdf_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Itsǝn nǝghǝn vara sǝɗikw bǝzan ad Yasu, ka mbaɗa itar ǝn tǝvuk sar, zǝ tuwa tsitar kwarne, “Kha Zǝr Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Ka tǝkhatǝrnan chara, kwarara bai tar kǝ udakh ad lavǝn tǝghǝr tsin bi. ");
INSERT INTO gdf_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","A do Yasu da tǝ kalam ghuɓ, ka ɗakh tǝrkhai kǝ liye ǝn naghin, ka sagh itar da vak sar. ");
INSERT INTO gdf_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","A dzǝrgan ad ud kǝlatǝm mits, ki nǝga kǝ dzǝran na kǝ furakh sar. Kǝ giɗa tsitar dagh, kǝ ɓalatra ɓal dǝgal da kwardu lav Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Mbǝladu itar ndzǝɗa dzado wurduwakh. ");
INSERT INTO gdf_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Yakhana udakh kǝlatǝm mitse a dzǝrgin. Siman (ai barvin ɗakh Bitrus). ");
INSERT INTO gdf_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakub zǝr Zabadi zǝ saghǝr sar Yukhan (ai batǝrvin ɗakh Buwarnajis, in kwarne “Zar ya fit”). ");
INSERT INTO gdf_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Chalǝmakh tsuguna itar, Ndros, Filibus, Bartalamaus, Mat, Tom, Yakub zǝr Half, Taddiyus, Siman ude nagh ba gwiya kǝ khaya sar da tǝlg bi. ");
INSERT INTO gdf_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","Zǝ Yakhuz Iskariyoti, dadake a bǝdu Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ən tǝkhal kǝ yana, ka dagh Yasu da tlǝrna mǝgh. Ka sa dzakhava udakh zikǝn da vak sar. Wirva yan, in zǝ furakh sar, a mbǝlatǝru ba ɗul zu kaf bi. ");
INSERT INTO gdf_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Tsǝna kǝ yakhtar ad in, ka dǝgal tsitar da ɓadoɓ. Da itar ǝn kurana, ba kǝɗǝf ghǝr tsin. ");
INSERT INTO gdf_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Yakhaya kǝ li tsagdu ndzikha ndzikh Mus liye sodagh ǝn Wurshalim, ǝn kwar kwarne, “Ba’alzabul shik ya wurduwakh ǝn man tlǝks din. In tsugun kǝ bara ndzǝɗa lakwdu wurduwakh ǝn vǝgh kǝ udakh.” ");
INSERT INTO gdf_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ka ɗakh tǝrkhai Yasu da vak sar, ka farsa kwaratǝra lava tsin dǝ jakǝva lavakh. “Da lakwa ndar Shatan ad Shatani? ");
INSERT INTO gdf_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Da tǝkaghǝra tlǝks mits. Tǝkhakh yan kǝ tlǝks kǝ ghitsgana? ");
INSERT INTO gdf_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Da tǝkaghǝra udakhe ǝn mǝgh mits. Da tǝkha yan kǝ mǝgh kǝ ghitsgan? ");
INSERT INTO gdf_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Da ka ǝn man tlughuma Shatan dǝ ghǝr sar, a tǝkana ba dǝ ghǝra sar kina biya? Da tǝkha kǝ ghitsgan dǝ ndzǝɗa? A sagh ba mbasa sar kina biya? ");
INSERT INTO gdf_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Nǝg ude tǝkha kǝ dagh da fǝta ude dǝ ndzǝɗa kǝ khuts kadlang sara? Khekwa ndzaɗana bakhin ndan kǝda khuts katlang sar tsin ǝn fǝta sara? ");
INSERT INTO gdf_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Ən tǝkha kura tǝkha kǝ, tǝkhud kǝ ɓisatǝrna daghan khaipakh tar kǝ udakh, zǝ ɗaga tsafa tsafe a manarkhai itar kǝ Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Ai daka tsafanǝfin ad Sǝɗikw Yazhigǝl, na bud da ɓisara ɓisa kǝ ngǝɗa bi.” ");
INSERT INTO gdf_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Dǝge kǝ ba da kwar yana, wirva a kwarga itar kwarne, “Nǝg dǝ sǝɗikw bǝzan ǝn vǝgh sar.” ");
INSERT INTO gdf_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Ka sagh zarbabakh Yasu zǝ bab sar da vak Yasu. Ghitsge tar ǝn mel, ka ɓǝlanǝf itar ad ud daks da ɗakhatra Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Nǝg dzakhava udakh a tsarghǝran, ka kwararkhai itar kwarne, “Babagha zǝ zarbabakhagh ǝn mel itar, ǝn na nǝgha kha nǝgha itar.” ");
INSERT INTO gdf_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Ka ndiɗatǝrwal Yasu kwarne, “War babara zǝ zarbabakhari? ");
INSERT INTO gdf_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ka vazatǝrvala kǝ liye ǝn ndzǝgan, liye tsarghǝran, ka ni, “Auna babara zǝ zarbabakhar. ");
INSERT INTO gdf_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Ɗaga ude ǝn man dǝge ǝn nagha Yazhigǝl, in zǝrbabara, dughwbabara, zǝ babar.” ");
INSERT INTO gdf_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Fitsa tlǝrna, ka dala Yasu da tǝghay dǝlv, ka gwidǝn farsa tsagatǝrdu tsaga tsin kǝ udakh. Dzakhava udakhe a tsarghǝrana zikǝn itar char. Wirva yana, ba da tsin da peryuwa ndzǝgan ǝmb. Dzakhava udakh daghan tsuguna ǝn ghitsǝn tǝghay gǝrdz. ");
INSERT INTO gdf_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","A tsagatǝrdu ad dǝgitakh zikǝn dǝ jakva lavakh. Ka niya tsitar, ");
INSERT INTO gdf_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Bambǝg tlim, tsǝnam tsǝn, dadak wusa a dala da tukhǝn gukh sar. ");
INSERT INTO gdf_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Madǝvin ǝn kwazdu khulfa, yakhaya ɓalal da tǝ ɗul, ka sa ɗikakha vaɗu itar. ");
INSERT INTO gdf_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Yakhaya tsuguna ɓalala da tǝ vake dǝ jajǝrkh, vake kwal dǝ khay char. Ka fǝtsawal itar kujaɗ kujaɗ, wirva vakena na khay chara bi. ");
INSERT INTO gdf_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Tǝvga kǝ fatsiya, ka ɓayandal ad khiyakhen, ka ghulala itar. Wirva tlǝla tara, a dagh ba da khay chara bi. ");
INSERT INTO gdf_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Yakhaya kǝ khulf tsuguna, ɓaldagh itar da tak. Ka ɗakala takena, ɓidzatǝrǝf. Ka yiga ba itar zǝr bi. ");
INSERT INTO gdf_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Yakhaya kǝ khulf tsuguna, ɓalala itar da tǝ dǝlɓ. Fǝtsawala tsitara, ka ɗakala itar, yiga itar zǝr ndǝkchiɓ. Yakhaya yige tar zǝr kulkhǝkǝrɗ kulkhǝkǝrɗ. Yakhaya tsuguna kulunkwakh kulunkwakh. Yakhaya tsuguna dǝrmǝk dǝrmǝk.” ");
INSERT INTO gdf_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","A mbasana Yasu ad kwar lav sar dǝ kwarne, “Ɗaga ude dǝ tlǝm tsǝn lava, tsǝnin.” ");
INSERT INTO gdf_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Madǝv Yasu ǝn ndzǝgan tukuɗa tukuɗa, furakh sar na kǝlatǝm mits, zǝ liye a tsarghǝran, ka ndiɗarwal itar ad dǝge ǝn tuku jakva lavakhen. ");
INSERT INTO gdf_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Ka niya tsitar, “Kura a khayakurnǝfud ad tsa ɓǝghan na kǝ dǝge tǝghǝr kǝ tlǝksa Yazhigǝl. Ak yakhaye kwal nǝg ǝn kura, itsauɗa ǝn kwaratǝrǝn jakva lavud. ");
INSERT INTO gdf_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","Ki zǝɗa, “ ‘Ən vaza vaza itara, ǝn nǝgha ba itar bi, zǝn tsǝna tsǝna itara, ǝn diyarsǝf bai tar bi Ki khek katlga tsitar, pǝlga itar ghǝr, ɓisatǝrna Yazhigǝl ad khaipakh tar.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Tsuguna ka nǝv Yasu tsitar, “Ai da katlga ba kur ad dǝge ǝn tuku inana kǝ jakva lava bi, ai da katla ndar kur ad dǝge ǝn tuku tlǝrna jakva lavakhi? ");
INSERT INTO gdf_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Auna dǝge ǝn tuku jakva lavan. Khulfe a kwazdu dadak tukha, in lav Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Khulfakhe a ɓalal da tǝ ɗul, ǝn mǝdla jakva udakhe a tsǝna lav Yazhigǝl. Ba itar ǝn tsǝna lavana, ǝn dǝvǝn dǝva, ka sagh Shatana khutsala dǝ lave ǝn rǝvakhuɗ tar. ");
INSERT INTO gdf_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Khulfe a ɓalala da tǝ jajǝrkh, ǝn mǝdla jakva udakhe a tsǝna lav Yazhigǝl, ka chauge tar kujaɗ kujaɗ, dǝ khwaɗǝg tsugun. ");
INSERT INTO gdf_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Fatsiya a tsǝga ba itar ad tlǝl bi, uk da zulu da tǝ sart khǝɗikǝn itar. Da ka sagh dlaɗa awana mbakhǝl, kǝ wirva fadǝghǝro dǝ lav Yazhigǝl, ka gwiyal itar da tǝlg kujaɗ kujaɗ. ");
INSERT INTO gdf_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Khulfe a ɓaldagh da tak, ǝn mǝdla jakva udakhe a tsǝna lav Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","Ai wirva puta giɗǝn larda, zǝ valdu ghǝr gat tluwandala, zǝ nagh dǝgakh lard sikh sikh sikh, ka ɓidzanǝf ad laven. Ka na dǝge ǝn tukuwin bi. ");
INSERT INTO gdf_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Khulfe ɓalal ǝn tǝ vak duɓan, ǝn mǝdla jakva udakhe a tsǝna lav Yazhigǝl, chauge tar, mangga itar tlǝr din. Ka yige tar zǝr, kulkhǝkǝrɗ kulkhǝkǝrɗ. Yakhaya, kulunkwakh kulunkwakh. Yakhaya tsuguna, dǝrmǝk dǝrmǝk, ak khulfe a kwazduwud. ");
INSERT INTO gdf_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Ka zuvuk Yasu dǝ kwarne, “Ən vǝdza kara kazaz khud ka barsud ǝn kus kǝ gagaya? Awana ǝn kus kǝ pin khǝngana? Nabakhud ǝn bǝga bǝg ǝn vak bǝgan sara? ");
INSERT INTO gdf_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Dǝge ɓǝghanud, da ɓadala ɓud da tǝ ɓal. Dǝge kwargud bǝghanyan, da ɓado ɓud da tǝ ɓal. ");
INSERT INTO gdf_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ude dǝ tlim tsǝn lava, tsǝnin.” ");
INSERT INTO gdf_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Ka kwara tǝrkhai tsugun kwarne, “Bamaru tlim kǝ dǝge ǝn tsǝna kur. Darame ǝn kuradakha dǝgit kǝ udakh din, din da kura kha dud. Da gwidǝn kurakha dinud mal kǝ yan. ");
INSERT INTO gdf_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Ude dina, da banargher bugud zikǝn. Ude kwal dina, ngwaɗa khǝɗike dinin, da chawarval chawud.” ");
INSERT INTO gdf_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Ka nǝv Yasu tsugun, “Nggwaɗe na tlǝksa gharazhigǝl. Nggwaɗa ude a kwazdu khulf ǝn gukh. ");
INSERT INTO gdf_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Khana zǝ tǝkhul, ǝn fǝtsa khulfena ka ɗak. In tsuguna ǝn tsa ba dǝ ɗule ǝn fǝtsda khulfen zǝ ɗaka bi. ");
INSERT INTO gdf_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Khayen dǝ ghǝr sar ǝn bǝgan ad khulfen da fǝtsa, zǝ ɗaka, sǝkhadal ad ghǝr, ka yigan ad zǝr. ");
INSERT INTO gdf_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Ba dǝgwayen ǝn tǝkhala tǝkh, ka da zǝɓ gidz kǝ da tsǝga tsǝg, wirva a tlala sarta tsǝg khi.” ");
INSERT INTO gdf_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Ka nǝv Yasu tsugun, “Uɗa da kwara kiyami? Da kura dǝ uɗa kiyam ad tlǝksa Yazhigǝli? Awana, ira kǝ jakva lave da kurada kiyam mana sari? ");
INSERT INTO gdf_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Nggwaɗa khulf mastad, ai khǝɗikan ǝn daghan khulfakhe ǝn tukhud ǝn lard. ");
INSERT INTO gdf_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Dǝmbiyanen, da tukhgud, ǝn ɗaka mal kǝ dǝgakhe ǝn wusud ǝn nggaɓ. Ən bakh gwal char, ai da tǝkha ɗikakh kǝ ndzǝgan ǝn kus kǝ sǝɗikw sar. ");
INSERT INTO gdf_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Dǝ khulf ina kǝ jakva lavakh zikǝn, a kwara tǝrkhai Yasu ad lava Yazhigǝl kǝ udakh. Kalkal ɗule da katlda itar. ");
INSERT INTO gdf_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Na dǝge a kwara tǝrkhayin kwal dǝ jakva lava bi. Ən sarte da tukuɗa tukuɗa itar zǝ furakh sar, ǝn kwaratra kwara dǝge ǝn tuku laven. ");
INSERT INTO gdf_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ɓǝlga kǝ khagw fitsa yanen, ka nǝv Yasu kǝ furakh sar, “Dziyamal da tǝ yan kǝ ghǝdzǝva gadzak.” ");
INSERT INTO gdf_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Ɗuwars itar ad dzakhava udakh, ka dagh furakh sar da peryuwe ǝn ndzǝgan Yasu ǝmb. Nǝg tlǝrna peryuwakh tsugun zitar. ");
INSERT INTO gdf_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ka soghǝr zikan kǝ fuɗ char ǝn yuwen, ǝn tlǝga tlǝga ghǝɗkuta yuwa ad peryuwen. Ən daks yu da peryu, tǝmga khǝɗikǝn kǝ righa righ. ");
INSERT INTO gdf_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Ən khǝnkhar Yasu ǝn tǝlg kǝ peryu, ka bo ad ghǝr sar ǝn tǝ dǝg ɓǝl ghǝre kurɓǝt. Ka tsiyanǝf furakh sar, ka ndiɗarwal itar kwarne, “Malǝma, na ɗangwa tsǝkha itsa ndǝkiyamu yuwa, ǝmtsǝga kiyam biya? ");
INSERT INTO gdf_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ka tsiyif ǝn khar, tavarghǝr ad di kǝ fuɗen. Ka niya kǝ ghǝɗkuta yu, “Ghitsga ghits.” Ka ghitsga fuɗen. Ka ɗiw nǝv vaken. ");
INSERT INTO gdf_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Ka niya kǝ furakh sar, “Uɗa lava tsukur a gǝdzǝf ndǝkyani? Sakhkana na kur dǝ fadǝghǝrofǝg biya?” ");
INSERT INTO gdf_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Ka gǝdzǝf itar char. Ka ndiɗakava tsitar kwarne, “Khulf ira kǝ ud ineni? Zǝva, fuɗa zǝ ghǝɗkutayuwa ǝn tsǝnaru tsǝn kǝ lav sari?” ");
INSERT INTO gdf_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","13 A dala Yasu zǝ furakh sar, da tǝ ghǝdzǝva gadzak dǝlva khaya Garasinakh. ");
INSERT INTO gdf_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Uk sawala sǝg kǝ Yasu ǝn peryuwa, ka sawala udanen ai ngwiyanǝf sǝɗikw bǝzan ǝn giɗe nggitl, kǝ gama zin. ");
INSERT INTO gdf_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Yanen kǝ uda ǝn giɗǝn giɗe nggitl, na ude dla tǝkha kǝ nggwaɗanan, tsa dǝ tsǝrvayu bi. ");
INSERT INTO gdf_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Wirva tsǝn nggwaɗa nggwaɗud ǝn tǝ sigakh sar, zǝ dǝvakh sar dǝ tsǝrvayu. Ən nggadla nggadla dǝ tsǝrvayu. Zǝ kǝla dǝg tuse ǝn tǝ kwinda siga sar. Na dadak ndzǝɗe tǝkha kǝ payana bi. ");
INSERT INTO gdf_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Viɗa zǝ fatsi tsin ǝn giɗǝn nggitl, zǝn tǝ ghuɓ. Ən khula, zǝ khara vǝgha sar tsin dǝ kurakh. ");
INSERT INTO gdf_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Nǝgha tsin Yasu kǝ bit, ka tsiyif dǝ khway, kǝlgan ad juguv ǝn tǝvuk sar. ");
INSERT INTO gdf_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ka khula tsin char, ni, ‘Yasu, Zǝr Yazhigǝl Ndanggan, uɗa ɗangwa tsǝkha dǝ ki? A takaɗkhai ka dǝ ɗakha Yazhigǝl, baka ba dǝ dlaɗ bi.’ ");
INSERT INTO gdf_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","A kwargan ndǝkyan, wirva audzala Yasu ǝn kwarar khai kwara kwarne, “Kha sǝɗikw bǝzan, ausǝg sǝgawal ǝn udan.” ");
INSERT INTO gdf_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Ka ndiɗarwal Yasu kwarne, “War ɗakhaghi?” Ka nggawar khai kwarne, “Ɗakhara Ghamag, wirva zikǝn kǝnd.” ... ");
INSERT INTO gdf_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Ka gwidǝn tǝkhaval kǝ takaɗ Yasu tsin char, khek lakwtǝrdu tsin sǝgawal ǝn ǝntla khayen. ");
INSERT INTO gdf_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nǝg giɗa daguwakh ǝn zighw ǝn tǝ kalam ghuɓ. ");
INSERT INTO gdf_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","A takaɗga wurduwakh ad Yasu, kwarne, “Khaya kǝndanǝf khaya, daks da daguwakhin.” ");
INSERT INTO gdf_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ka khayatǝrnǝf, ka sawal sǝɗikw bǝzanakhen, ka dagh itar da daguwakh. Giɗa daguwakhena a ɓa itar dǝb mits. Ka ɗaɗardagh itar dǝgdagh diwa tsǝɓan na kǝ ghay gǝrdz, ka ɓaldagh itar da yuwa, ruga itar. ");
INSERT INTO gdf_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ka khwaya li zighw daguwakhen daks da khuɗ kǝsa, zǝ gǝdzar kǝsakh, kwarar khai itar kǝ udakh ad dǝge dzoghǝr. Ka sawala udakhen, dala itar da vaz dǝge dzoghǝr. ");
INSERT INTO gdf_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Sa tsitar da vak Yasu, ka nǝgha itar ad dadake tsa ghamag sǝɗikw bǝzanakh ǝmb, ǝn ndzǝgan. Dǝ gabag ǝn tǝvǝgha sar, zǝn mǝkǝn sar khwaranyan. Ka gǝdzǝf udakhen. ");
INSERT INTO gdf_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Liye tsa nǝghan dǝ diyakh tar ad dǝge a dzoghǝr, uk kwara khatra kwara tsitar kǝ udakh, ad dǝge a dzoghǝr dǝ dadake tsa ghamag sǝɗikw bǝzanakh ǝn vǝgh sar, zǝ daguwakhen. ");
INSERT INTO gdf_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Ka farsa udakhen ad takaɗ Yasu, kǝ ɗuwatǝrda khay tar tsin. ");
INSERT INTO gdf_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Madǝv Yasu ǝn daks da peryuwen, ka takaɗga ude tsa ghamag sǝɗikw bǝzan ǝn vǝgh sar ad Yasu, kǝ khayarnǝf dǝgal tsin dagh. ");
INSERT INTO gdf_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Ai ka khayarnǝf ba Yasu bi. Ən dleva yan, ka niya tsin, “Dǝg daks da mǝgh, da vak yakhur, kwara tǝrkhai kwara ad zik zikan na kǝ dǝgakhe a mana khai Dad Zikan, zǝ kwiɗkwiɗǝrve mana khayin.” ");
INSERT INTO gdf_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wirva yan, ka tǝkaval sar, ka gwayava tsin ǝn Dikapolis, kǝsakh kǝlɗǝk, ǝn kwarakhdu dǝge a manar khai Yasu. A ndawatǝrǝf, kǝ daghan liye a tsǝnan. ");
INSERT INTO gdf_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Gwiyoghǝr kǝ Yasu saks da tǝ ghǝdzva gadzak dǝlve tsa dinin, ǝn peryu. Ka tsarghǝra dzakhava udakh zikǝn. Madǝvin tlaɓ ǝn tǝ kalam ghǝdzva gadzaka, ");
INSERT INTO gdf_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ka nǝg udanen kitakul ǝn tǝb kǝ zikan ǝn tǝghǝr kǝ gud dzakhava Yakhudakh, ɗakhasara Yayirus ka sa. Nǝgha tsin Yasu, ka sagha kǝlgan ad juguv ǝn tǝvuk sar. ");
INSERT INTO gdf_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","A takaɗgan char, ‘‘Khǝɗikan na kǝ dughwara ǝn yanga bi, da mǝts. Tatl ausǝg da bo dǝvagh ǝn tǝf, kǝ mbandu mbǝg tsǝkh, khek ǝmtsǝga tsin.” ");
INSERT INTO gdf_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Ka dala zǝ Yasu. Ka gatatǝrs dzakhava udakh zikǝn, ka ɓidzanǝf itar. ... ");
INSERT INTO gdf_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Ka nǝg nusen ǝn vin, ai a zulavan ǝn kǝl vizh vǝg kǝlatǝm mits. ");
INSERT INTO gdf_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","A khǝɓu a dlaɗ char ǝn vak gat nggur, ǝn vak li bǝdu nggur. Kǝɗgan ad khalavuwa dǝge dinin. Dǝmbiyanena, a mbu bi. Ən mbǝra dǝ mbǝra kuzen. ");
INSERT INTO gdf_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Ka tsǝna nusen ad lavǝn tǝghǝr kǝ Yasu, ka sasǝg tsin shuwakh ǝn tǝb kǝ udakh diwa lǝg Yasu. Ka gǝman ad gabag Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Wirva a ɗayandagh ǝn rǝvakhuɗ sar kwarne, “Da gǝma ka itsa gabag sara, da mbǝga kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Tǝvin tǝvina ghitsga kǝl vizh sar. A tsǝnan ǝn vǝgh sar kwarne a mbu. ");
INSERT INTO gdf_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Tǝvin tǝvina ka tsǝna Yasu ad sǝgawala kǝ ndzǝɗ ǝn vǝgh sar, a manggan ad tlǝr. Gwiyafkhaya ka ndiɗatǝrwal kǝ dzakhava udakhen kwarne, “War kǝ gǝma gabagari?” ");
INSERT INTO gdf_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Ka nǝv furakh sar, “Ən nǝgha nǝgha kha dzakhava udakh ǝn tlagva kǝ ɓidza kha ɓidza ndikina, ka ndiɗ kwarne war kǝ gǝmakan nikha?” ");
INSERT INTO gdf_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ka ɓalakh di kǝ Yasu, kǝ vaz ude kǝ gǝman. ");
INSERT INTO gdf_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Fatsiye a audzal nus na tsa dǝge a dzoghǝr dina, ka saks tsin da kǝl juguv ǝn tǝvuk Yasu. Ən tǝga vǝgh sar dǝ gǝdz, ka kwar khai ad khalavuwa jir. ");
INSERT INTO gdf_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Ka nǝv Yasu tsin, “Dughwara, fadǝghǝrofǝga kǝ mbakhu. Dǝg daks dǝ lapi, a mbu khǝn tukw kuzagh.” ");
INSERT INTO gdf_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Madǝv Yasu dlǝn kwar lava, ka sagh yakhaya kǝ udakh ǝn fǝta Yayirus, mal ǝn tǝghǝr kǝ gud dzakhava Yakhudakh. Nǝv itar tsin, “A mǝtsga dughwagh, uɗa dla dǝg njǝgharu njǝgha tsǝkha kǝ malǝmi? ");
INSERT INTO gdf_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","A baru ba Yasu ad tlim kǝ lave a kwarga itar bi. Ka niya kǝ Yayirus, “Gǝdz biya, fadǝghǝrofǝg bakh.” ");
INSERT INTO gdf_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","A khayanǝf ba Yasu ad gatars gata kǝ itsawar bi, uk Bitrus, zǝ Yakub zǝ zǝrbab sar Yukhan. ");
INSERT INTO gdf_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Tsugwa tsitar ǝn fǝta mal ǝn tǝghǝr kǝ gud dzakhava Yakhudakh, ka nǝgha nǝgha kǝ Yasu ad yakhaya kǝ udakh ǝn tuwa, yakhaya tsuguna ǝn khul. ");
INSERT INTO gdf_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Dagh da vak tar, ka ndiɗatǝrwal kwarne, “Uɗa lava tsukur ǝn tuwa zǝ khula ndikini? A mǝtsga ba dughw na ndan bi, ǝn khǝnkhar.” ");
INSERT INTO gdf_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Ka ghuɓasa ghuɓasa tsitar dǝ nen. Ka lakwtǝral kǝ udakh daghan dǝgal da mel. Ka daks tsin zǝ dad dughwen, zǝ bab sar zǝ furakh sar na khǝkǝrɗ, da vake din dughwen. ... ");
INSERT INTO gdf_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Khutana tsin dǝva dughwen, ka niya tsin, “Talita kumi.” In kwarne, “Zǝr dughwa, ǝn kwara kha kwara ka, tsiyif tsi.” ");
INSERT INTO gdf_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Tǝvin tǝvin ka tsiyif zǝr dughwen, ka farsa dǝga tsin ǝn tǝb tar. Dughwena, khi kǝlatǝm mits tsin. Ina kǝ digita a nala kǝ dǝg ndawak tsitar. ");
INSERT INTO gdf_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","A ndǝɗatǝrna Yasu ad tlim chara, kwarne, tsǝna ba itsawar ad lavǝna bi. Ka gwidǝn kwara tǝrkhai kwarne, bara bǝg itar dǝg zuwa kǝ dughwen. ");
INSERT INTO gdf_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","A ɗuda Yasu ad yanen kǝ vaka, a gwiya da kǝs sar. Dala furakh sar zin. ");
INSERT INTO gdf_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Sa kǝ fitsa nggi, ka farsan ad tsagdutsag ǝn gud dzakhava Yakhudakh. Ɗaga liye a tsǝnan ad tsagdutsaga sar, a ndawatǝrǝf. Ka ndiɗa tsitar, “A mbǝladu ǝn ma udan na ad dǝgakhani? Khulf ira kǝ kwelemlem a barud ndikini? Vaza dǝ khulf dǝg dawakakhe ǝn manin. ... ");
INSERT INTO gdf_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Dadak tsakh mǝgh na ba ina biya? Maryam bakh Bab sara? Saghǝrakh sar bakh Yakub, zǝ Yukhan, zǝ Yakhuda, zǝ Simana? Saghǝrakh sar bakh dǝghawakhan ǝn giɗǝn vakmara? Ka chauga ba itar bi. ");
INSERT INTO gdf_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ka nǝv Yasu tsitar, “Na tlayangge kwal dǝ ndanga bi, uk ǝn kǝs sar, zǝn tǝb kǝ jib sar, zǝ li fǝta sar.” ");
INSERT INTO gdf_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Wirva yan, a mangga ba dǝ dǝg ndawak ǝn vin bi, uk dǝv a bakhowin ǝn tǝ chalǝm liye kwal yang, a mbakhatru. ");
INSERT INTO gdf_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kuɗ fadǝghǝrofǝg tara, a nala kǝ dǝg ndawak tsin. Ka dakhgal tsin da tsagdu lav Yazhigǝl ǝn gǝdzar kǝsakh sikh sikh sikh. ... ");
INSERT INTO gdf_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Ka ɗakhgan ad furakh sar kǝlatǝm mits, kǝ ɓǝlatra ɓǝla dǝ mits mits. Ka batran ad ndzǝɗ ǝn tǝghǝr kǝ sǝɗikw bǝzanakh. ");
INSERT INTO gdf_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ka tǝkhatǝrnan kwarne, a ɗuwam zǝɓ itsa uɗa kǝ dǝgal uk gulv. A ɗuwam ɓǝ dǝg zuwa, itsa jilaɗ, zǝ kwaɓ ǝn mbǝlur. ");
INSERT INTO gdf_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Talǝm kur kimbak. Talam tala gabag, ɓamba tlǝrna gabag bi. ");
INSERT INTO gdf_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Itsera kǝ mǝgh ǝn dagh kur, ndzamga ndzǝg ǝn vin, da tǝ sarte da ɗuwars kur kǝsen. ");
INSERT INTO gdf_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Ɗaga vake kwal chaukur khai tsud, awana kwal tsǝnakuru tsud. Da da ɗuwars ɗuwa kur ad yanen kǝ vak, ka pangdu kur ad lagwat ǝn tǝ sigur. Ki nǝga tsin kǝ shid ǝn tǝghǝr tsitar, kwarne da takatra lava Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Ka dala itar, ka kwardu lava tsitar kwarne, pǝla udakh ad ghǝr. ");
INSERT INTO gdf_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","A lakwadal itar ad wurduwakh ǝn vǝgh kǝ udakh zikǝn, a masar khai itar wal kǝ liye kwal yanga zikǝn, ka mbakhatru itar. ");
INSERT INTO gdf_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","A tsǝna Khiridus shik ad dǝge a dzoghǝr, wirva a kwazga ɗakha Yasu itsa dǝvar. Nǝv chalǝm kǝ udakha, Yukhan dadak para ud kǝ tsiyif ǝn nggitl. Yan kǝ manggan nǝg dǝ ndzǝɗa manakh dǝg ndawakakh. ");
INSERT INTO gdf_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Av yakhaya, udan na ‘Ili.’ Av chalǝmakh tsuguna ‘Ina tlayang, ndǝk fang ǝn tǝb kǝ tlayangakhe tsa ndur.’ ");
INSERT INTO gdf_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Tsǝna kǝ Khiridus ad yan, ka ni, “Yukhane a ǝntlargǝr ka ghǝr a tsiyanǝfud ǝn nggitl.” ");
INSERT INTO gdf_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Wirva Khiridus dǝ ghǝrsar tsa ba dǝ yakhaya kǝ udakh da vi Yukhan, kǝ nguɗa nguɗa tsud, bǝmud ǝn gud sal. A mangan ad ina kǝ wirva Khirudi nus zǝr dad sar Filibus, ai pǝrɗuwin kǝ nǝga kǝ nus sar. ");
INSERT INTO gdf_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Wirvǝn tsǝn kwarakhara kwara Yukhan kǝ Khiridus, kwarne, “Kalkal ba pǝrɗ nus zǝr dadagh tsǝkha kǝ nǝga kǝ nusagh bi.” ");
INSERT INTO gdf_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","A bazardu lavan ad rǝv kǝ Khirudi tsuguna a mbitsana bi. Wirva yan, ka tsǝn nagha dǝ kǝɗga Yukhan. A gǝmadu ba dǝ ɗul bi. ");
INSERT INTO gdf_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Wirvǝn gǝdza gǝdza Khiridus ad Yukhan, a khayanǝf ba gǝma gǝma kǝ itsauɗa bi. Wirva tsatsin kwarne, Yukhana dadak kanadi zǝ chuwaɗaɗa rǝv. Itsǝra kǝ sarte ǝn tsǝna Khiridus ad kwar lava kǝ Yukhan, ka ndzikǝn ndziya char. Tsakhǝnmina, zǝɗa tsin tsǝn lav sar. ");
INSERT INTO gdf_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Kǝ dǝg mbasa ka gǝmadu Khirudi ad ɗul. Fitsa dzama khǝna yiga sar kǝ Khiridus. Ka ɓalga Khiridus ad zik zikan na kǝ udakh sar, zǝ zik zikan na kǝ tlujiyakh sar, zǝ malanakh kǝs ya Galili. ");
INSERT INTO gdf_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Sagh kǝ dughw Khirudi da vak khwaɗǝg, tsugwa tsin, ǝn tǝvuk kǝ Khiridus zǝ ghulabakh sar, ka zǝɗatǝru tsugwen. Ka nǝv shik kǝ dughwen, “Takaɗa dǝ itsauɗǝn nakhǝn vakar, da bakha bǝg kǝ.” ... ");
INSERT INTO gdf_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","A waɗar khai Khiridus kǝ dughw na kwarne, “Itsauɗǝn takaɗgakha da bakha bǝg kǝ, itsa tǝkanud ǝntla khaye ǝn mana ka tlǝksa sar mits.” ");
INSERT INTO gdf_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Ka dala dughwena, ndiɗarwal kǝ babsar, “Uɗa da ɗawaki?” Ka niya tsin, “Ghǝr Yukhan dadak para ud.” ");
INSERT INTO gdf_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Ka gwiyal kujaɗ kujaɗ da vak shik. Takaɗgan kwarne, “Ən naka baka bǝg tsǝkha ghǝr Yukhan dadak para ud ǝn tǝ play tǝkhin tǝkhin.” ");
INSERT INTO gdf_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Tsǝna kǝ shik ad yan, ka bazala rǝv tsin char. Wirva waɗe a zugin, zǝ zhiruwe da khǝɓin ǝn tǝvuk kǝ ghulabakh sar, nagh ba dǝ kǝla lanji sar bi. ");
INSERT INTO gdf_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Ka ɓǝlanǝf ad fang ǝn tǝb kǝ tlujiyakh sar, dǝgin dǝgal da ɓardǝghǝr ghǝr Yukhan. Ka dala tlujiyena, ǝntlardǝghǝr ad ghǝr Yukhan ǝn gud sal. ");
INSERT INTO gdf_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","Ɓadǝghǝr ad ghǝren ǝn tǝ play. Baran kǝ dughwen, ka ɓara dughwen kǝ bab sar. ");
INSERT INTO gdf_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Tsǝna kǝ furakh Yukhan ad yana, ka sagh itara da zǝb gǝdzumba vǝgha sar, ka ba itar ǝn ɗungwe khurzǝz. ");
INSERT INTO gdf_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Dzǝran na kǝ furakh kǝlatǝm mits ai tsa ɓǝlatǝr ndalin, a sara da vak sar. Kwarar khai itar daghan dǝgakhe manga itar, zǝ dǝgakhe tsagardu itar kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Wirva zikǝn udakh ǝn sǝgawalina ǝn daksin, itsa sarta zu kafa a gǝmadu bai tar bi. Ka niya furakh sar, “Ausǝgam, na dziyamal da tlǝrna vake kwal nǝg kǝ itsawar, fǝtavkhai kiyam.” ");
INSERT INTO gdf_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Ka dagh itar da peryu, dala itar tukuɗa tukuɗa, da vake kwal nǝg kǝ itsawar. ");
INSERT INTO gdf_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ən sarte tsǝn dǝgal itar, zikǝn udakhe a nǝghatǝran, ka katlga itar kwarne itar ǝn dǝgal. Ka khwaya kǝ udakh zikǝn ǝn khuɗ kǝs dǝgal dǝ sig diwa kalam zagh, ka itar kǝ dala chak tǝghǝr kǝ Yasu zǝ furakh sar. ");
INSERT INTO gdf_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Sawala kǝ Yasu ǝn peryuwen, ka nǝghan ad dzakhava udakh char. Kwiɗ nǝv rǝv tsin, wirva nggwaɗa tuwaghakhe kwal nǝg kǝ dadak zighw itar. Ka farsa tsagatra dǝgitakh sikh sikh sikh tsin. ");
INSERT INTO gdf_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Dǝm kǝ fatsi da ɓǝla, ka sagh furakh sar, ka nǝv itar tsin, “Vak na, na itsawar bi, tsuguna a dǝm fatsi da ɓǝl. ");
INSERT INTO gdf_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Ɓǝlatǝrs ɓǝla kǝ udakhan na daks, da khuɗ kǝsakh zǝ gǝdzar kǝsakhe khef ǝn van, kǝ sǝku dǝg zuwa tsitar kǝ ghǝrtar.” ");
INSERT INTO gdf_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ka ngawa tǝrkhai Yasu kwarne, “Bamatra bǝg kur dǝge da zuwa itar.” Ka nǝv itar tsin, “Ina da nagha dǝ kwaɓ tǝl ǝntla vǝg, kǝ dadak man baryam. Dǝg kǝnda dǝgal da kǝɗ kwaɓ pakyan ǝn tǝghǝr kǝ brudi, kǝ batra kǝ zuwa zuwa nikha? ");
INSERT INTO gdf_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ka ndiɗatǝrwal, “Ngǝrwa ɗumba brudi din kuri? Dam da nǝgha nǝgh.” Dala tsitar da nǝgha nǝgha, kwarar khai itar, kwarne, “Brudi dliɓ zǝ kilf mits.” ");
INSERT INTO gdf_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ka bǝtra Yasu kǝ furakh sar, babǝg itar udakh da ndzakhga ndzakha kǝ dakwala kǝ dakwal, ǝn tǝ dzuɓ. ");
INSERT INTO gdf_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Ka ndzakhga itar kǝ dakwala kǝ dakwal. Yakhaya kǝ dakwala, dǝrmǝk, yakhaya tsuguna kuldlǝɓ. ");
INSERT INTO gdf_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ka ɓǝf Yasu ad ɗumba brudiyen dliɓ zǝ kilfen mits. Kapanan ad ghǝra, vazo da gharazhigǝl, kwarar khai ad usus kǝ Yazhigǝl. Ka kalanan ad ɗumba brudiyakhen, baran kǝ furakh sar, kǝ takara kǝ udakh. Takatǝr khai ad kilfakhen mits na kǝ udakh daghan. ");
INSERT INTO gdf_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Itsawara a zu, a bagharal daghan. ");
INSERT INTO gdf_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ka dzakhanǝf furakh sar ad tughub kǝlatǝm mits, kǝ kala brudiya zǝ kilfe tǝmgan. ");
INSERT INTO gdf_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Zika ghwalvakhe zuzuwa dǝb dliɓ. ");
INSERT INTO gdf_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ən dǝvǝn dǝv, ka kwarar khai Yasu kǝ furakh sar, daks da peryu kǝ dǝgal tsitar da tǝ ghǝdzǝva gadzak kalam Betsed. In tsuguna da ɓǝlatǝrs kǝ udakh ndan. ");
INSERT INTO gdf_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ən tǝ khal kǝ ɓǝlatǝrs ɓǝla tsin daksa, ka do da tǝ kalam ghuɓ kǝ ɗǝgau. ");
INSERT INTO gdf_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ɓǝlga kǝ khagwa, tsǝn tǝb kǝ dǝlv peryu, in tsuguna tsa tukuɗa tukuɗ ǝn tǝ bǝɗar. ");
INSERT INTO gdf_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Ka nǝghan ad furakh sar ǝn khǝɓ dlaɗ wiya peryu, wirva zika fude ǝn gwiyatra da tǝlg. Dǝm kǝ kǝs da ngura, ka dala da vak tar, ǝn dǝgǝn tǝghǝr kǝ yu, vadge da dǝgala fǝt. ");
INSERT INTO gdf_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nǝgha tsitar ǝn dǝgǝn tǝghǝr kǝ yuwa, ba ude a sawal ǝn tǝ fik nǝv itar. Ka khula tsitar. ");
INSERT INTO gdf_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Wirva daghan tara a nǝgha tsitar, ka gǝdzǝf itar char. Kujaɗ kujaɗa ka kwaratǝr khai ad lava kwarne, “Khǝna mana khǝna rǝvur, ka fǝka. A ɗuwam gǝdz.” ... ");
INSERT INTO gdf_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ka dagh da peryu ǝn vak tar, ka lǝɓga fuɗen. A ndawatǝrǝf char. ");
INSERT INTO gdf_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Wirva a katlga ba itar ad dǝge ǝn tuku baghandala ud dǝb dliɓ na bi. Wirva dǝkdǝk rǝva tar. ");
INSERT INTO gdf_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Darghǝra tsitar kǝ dǝlva, ka tsugwa itar ǝn kalam khaya ya Janisarat. Ka nguɗana itar ad peryuwen ǝn tǝ ghay gǝrdz. ");
INSERT INTO gdf_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Sawala tsitar ǝn peryu, tǝvin tǝvina, ka katlga udakh ad Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Ka khwaya udakhen daks da khuɗ kǝsakh daghan. Ən zaɓado liye kwal yang itar ǝn tǝ pinakh tar, da ɗaga vake da tsǝne tar din Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Itsa dal dǝvarin, ǝn gǝdzar kǝsakh, zǝ dlǝmdla kǝsakh, awana mǝghakhe ǝn khuɗ tǝghal, ǝn khana liye kwal yanga udakhen ǝn tǝ ɓala ɓal. Ən tatl Yasu itar kǝ khayatǝrnǝf kǝ liye kwal yang, kǝ gǝma itsa ghai gabag sar. Daghan liye a gǝmana a mbakharu. ");
INSERT INTO gdf_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Farisakha zǝ yakhaya kǝ li tsagdu ndzikha ndzikh Mus, ai sarawal ǝn Wurshalim. Dzafkai itar ǝn vak Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ka nǝgha itar ad yakhaya kǝ furakh Yasu, ǝn zu kaf itar kwal parga tsitar ad dǝv ndǝke tsagdu dzidzakh tar. ");
INSERT INTO gdf_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Wirva Farisakha zǝ Yakhudakh daghan, na itar zu kaf kwal parga tsitsar dǝv ndǝke tsagatǝrdu dzidzakh tar bi. Wirvǝn tsufada ndzikha ndzikh dzidzakh tar itar. ");
INSERT INTO gdf_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Da sa itar ǝn kasuk, na itar ǝn zu kaf bi, akwa pardu itar dǝv ndǝke tsagatǝrdu dzidzakh tar. Ən tsufa tsufa itar ad yakhaya kǝ ndzikha ndzikh tar ai wuru itar zikǝn. Ndǝk zai pardu kwat khǝɓ yu, shakakh, zǝ shugudakhe mangud dǝ vǝrshakanvǝ, zǝ vak zu kafakh tar. ");
INSERT INTO gdf_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Wirva yan, ka ndiɗarwal Farisakhen zǝ li tsagdu ndzikha ndzikhen kǝ Yasu, “Uɗa lava kǝ furakhagh kwal nǝg ǝn gatars kǝ ndzikha ndzikh dzidzakhǝnd, kǝ zu kaf tsitar kwal par dǝv ndǝkve tsagdu dzidzakhǝndi?” ");
INSERT INTO gdf_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ka nggawa tǝrkhai Yasu, ‘Kalkal lav tlayang tlayange tsa kwarga Ishay ǝn tǝghǝr kǝ tsukur kur mbaɗirakh. Ndǝke vindzanin kwarne, ‘ “Udakhan na uk ǝn fakghǝr dǝ ghay itar, rǝvakhuɗ tara bita zǝ kǝ. ");
INSERT INTO gdf_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ən ɗabaka buti itar, ǝn tsagdu ndzikha ndzikhe a bǝga ud itar vadge ndzikha ndzikhe a bǝga Yazhigǝl.’ ");
INSERT INTO gdf_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ɗuwars kur gatars kǝ ndzikha ndzikh Yazhigǝl, ǝn gatars kǝ ndzikha ndzikh dzidzakhur kur.” ");
INSERT INTO gdf_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Ka zu vuk tsin dǝ kwar kwarne, “Nǝg kur dǝ khiɗa ɗuda ndzikha ndzikh Yazhigǝl, kǝ wirva tsuf tsagdutsagur. ");
INSERT INTO gdf_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Wirva kwarga Mus kwarne, ‘Fargǝrafǝg kǝ dadagha zǝ babagh, ɗaga ude kwarga lav bǝzan ǝn tǝ dad sar awana bab sar, ka kǝɗgud.’ ");
INSERT INTO gdf_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Ai ǝn kwara kwara kur kwarne, da ka nǝv udan kǝ bab sar awana dad sar, dǝge tsa da mǝlakuru ka din, audzala kǝn barkhai kǝ Yazhigǝl. A manga ba dǝ khaip bi. ");
INSERT INTO gdf_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","Wirva yan, a khayarnǝf ba kur kǝ ud ad mǝlaru kǝ dad sara zǝ bab sar bi. ");
INSERT INTO gdf_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Tǝ dǝva dǝ yan, a nandala kur lav Yazhigǝl kǝ bat, wirva ndzikha ndzikhakh dzidzakhure ǝn tsagardu kur kǝ zarur. Ən manakha mana kur digitakh zikǝn ndǝkva dǝgakhen. ");
INSERT INTO gdf_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Ka gwidǝn Yasu ad ɗakhga dzakhava udakh, ka ni, “Tsǝnam ka tsǝna itsawar, diyarsǝf kur ad inan. ");
INSERT INTO gdf_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Na dǝge ǝn ba udan da ghay sar, ai da nan kǝ kwadlamb ǝn tǝvuk kǝ Yazhigǝl bi. Akwa dǝge ǝn sǝgo ǝn khuɗ sar da nan kǝ kwadlamb, ǝn tǝvuk kǝ Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ɗaga ude dǝ tlim tsǝn lav, tsǝnin ad lavan. ");
INSERT INTO gdf_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Ən tǝkhal kǝ tǝkaghǝra tsin zǝ dzakhava udakh, ka dagh da mǝgh. Ka ndiɗarwal furakh sar ad dǝge ǝn tuku jakva lavan. ");
INSERT INTO gdf_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Ka niya tsitar, “Atsuk a katlga bakh ghǝrura? Ən tsa bakh kur kwarne dǝge ǝn ba udan da ghay sar bǝn na ud kǝ kwadlamb ǝn tǝvuk kǝ Yazhigǝl biya? ");
INSERT INTO gdf_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Wirvǝn nabǝn daks da rǝvakhuɗ bi ǝn dǝgdagh da khuɗ, khalakyan ka sǝgawal ǝn vǝgh. (Lav Yasu ǝn tǝ vana, a mǝdlanan kwarne, itsera kǝ dǝg zuwa chuwaɗaɗ kǝ zuwazu.) ");
INSERT INTO gdf_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Ka zu vuk tsin dǝ kwar lav kwarne, ‘Dǝge sǝgo ǝn khuɗ kǝ uda ǝn nan kǝ kwadlamb ǝn tǝvuk kǝ Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Wirvǝn rǝvakhuɗ ud ǝn sǝgo nguɗi nguɗi ɗayaghǝrakh, ai bǝgan da man dǝgakhe kwal khwar, ndǝk zai garnak, gǝl, zǝ kǝɗ safa ud. ");
INSERT INTO gdf_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","Gwaragwar, khuwa, kǝlada, valdu ud, kuɗ bǝg zhiru, shilga, bazdu ɗakha ud, nagh ghǝr, zǝ dlǝgǝr dlag. ");
INSERT INTO gdf_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Daghan dǝg nguɗi nguɗiyakhan, ǝn sǝgo ǝn khuɗ kǝ ud, tsuguna in ǝn nan kǝ kwadlamb ǝn tǝvuk kǝ Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ka ɗuda Yasu ad vaken, dagh da ǝntla khaya Taya zǝ Sidon. Ka dagh da mǝghen, tsuguna ǝn nagh ba tsatsǝg ak itsawar bi, dǝmbiyanena, a ɓǝghafkhai bi. ");
INSERT INTO gdf_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Uk tsǝna tsǝna kǝ nuse ǝn kǝɗa shatan ad dughw sar ad lavǝn tǝghǝr kǝ Yasu, ka sagha kǝlgan ad juguv ǝn tǝvuk sar. ");
INSERT INTO gdf_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Nusen tsuguna liye kwal Yakhudakh. A yavǝn Finiki ǝntla khaya ya Suri. Ka tatl Yasu tsin kǝ ɓardal wurdu sǝgawal ǝn vǝgh kǝ dughw sar. ");
INSERT INTO gdf_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ka nǝv Yasu tsin, “Ɗuwaks ɗuwa bara bǝg ka dǝg zuwa kǝ zaren (Yakhudakh) ndan, wirva kalkal ba ka ɓatǝrvalud dǝg zuwa zara, ka liyarduwud kǝ ghǝdakh bi.” ");
INSERT INTO gdf_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Ka nǝv nusen, “Ai ndǝk yan Dad Zikan, ai ghǝdakha ǝn vaɗuvaɗa itar ad kwacha kafakhe a ɓalal ǝn tǝ vǝlang zu kaf zar.” ");
INSERT INTO gdf_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Ka nǝv Yasu tsin, “Wirva lavana a kwargakh, gwiya daks da mǝgh, a tǝkaghǝra wurdu zǝ dughwagh.” ");
INSERT INTO gdf_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Ka wura da mǝgh, tlarghǝr kǝ dughw sar ǝn khǝngan ǝn tǝ pin, audzala wurduwen ǝn dala dǝg ǝn vǝgh sar. ");
INSERT INTO gdf_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Ka ɗuwars Yasu ad kǝs ya Taya, ka dal da dǝlva Galili, diwa Sidon zǝ Dikapolis (kǝsakh kǝlɗǝk). ");
INSERT INTO gdf_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Ka ɓardǝghǝr yakhaya kǝ udakh ad tǝnge dlakh kwar ghay tsin, ka tatl Yasu tsitar kǝ barghǝr dǝv tsin, ki mbǝga tsin. ");
INSERT INTO gdf_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Tǝkhal kǝ ɗakhga tsin udanen ǝn tǝb kǝ dzakhava udakh da tǝ kalam. Ka ba Yasu ad wirik dǝv sar da tlim kǝ tǝngen, ka tǝfaw ad shaghwvai ǝn tǝ zǝr dǝv sar, ka gǝman ad rikha udanen din. ");
INSERT INTO gdf_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Ka lando Yasu ad ghǝr da gharazhigǝl, ka gǝlf niya zikzik, ka niya tsin, “Iffata” Dǝge ǝn tukuwina in kwarne “Ngurǝf ngur.” ");
INSERT INTO gdf_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Kwarga tsin ndǝkyan, ka ngurǝf tlim udanen. Ka tasla nǝv rikh sar a vǝdgan, ka farsa kwar lava tsin khwaraniyan. ");
INSERT INTO gdf_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Ka ndǝɗatǝrnǝf Yasu ad tlim kwarne, kwarara ba itar kǝ itsawar ad dǝge a dzoghǝr bi. Itsera kǝ sart ǝn kwargin kwarne kwar ba itar bi, ka zu vuk dǝ kwardu laven itar. ");
INSERT INTO gdf_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Dǝgǝn na mangina a ndawatǝrǝf kǝ udakh char. Ka nǝv itar, “A mangan ad itsauɗa kalkal. A ba dǝ tǝngakh, da tsǝna lav. Liye kwal tǝkha kǝ kwarga lava, ka kwar lava.” ");
INSERT INTO gdf_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ən khǝnakhena, ka gwidǝn dzafkhai udakh zikǝn da vak Yasu. Fatsiye a mbasu dǝg zuwa tar, a ɗakhga Yasu ad furakh sar da vak sar. Ka ni, ");
INSERT INTO gdf_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Ən man kwiɗkwiɗǝrv udakhana kǝ, khǝkǝrɗ khana tsitar zǝ kǝ, kǝvena na dǝge da zuwa itar bi. ");
INSERT INTO gdf_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Da ɗuwatǝrs ka daks da mǝgh dǝ way, da mbaɗa itar ǝn tǝ ɗul, wirva chalǝm tara a sara kǝ bit.” ");
INSERT INTO gdf_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Ka nǝv furakh sar tsin, “Ai da mbǝladu ǝn varud ad dǝg zuwa zikǝn ǝn khuɗ tǝkhal na ndǝkin, ai da bagha tǝra bagha kǝ udakhan na daghani?” ");
INSERT INTO gdf_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ka ndiɗatǝrwal Yasu, “Ngǝrwa brudiye din kuri?” Ka nggawar khai itar kwarne, “Uɗif.” ");
INSERT INTO gdf_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ka kwara tǝrkhai kǝ udakh kǝ ndzakhga ndzakh ǝn tǝ khay. Ɓǝf tsin brudina uɗif, ka kwar sus tsin kǝ Yazhigǝl, kalanan, baran kǝ furakh sar kǝ takatǝra taka kǝ udakhen. Ka manga furakhen ndǝkyan. ");
INSERT INTO gdf_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Nǝg itar dǝ mbisan na kǝ kilfakh khǝɗikǝn tsugun. Ka kwarar khai dǝ sus kǝ Yazhigǝl, kǝ wirva kilfakhen tsugun. Kwara tǝrkhai kǝ furakh sar kǝ takardu taka tsitar kǝ udakh, ad kilfakhen tsugun. ");
INSERT INTO gdf_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Azu udakh baghala itar. Tǝkhal kǝ zuzuwa tsitara, dzakhanǝf furakh sar ad tughub uɗif ake tǝmatǝru kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Tsa ghwalvakh dǝb ufaɗ ǝn vinen. Tǝkhal kǝ ɓǝlatǝrs bǝla tsin daks, ");
INSERT INTO gdf_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","tǝvin tǝvina ka dagh da peryu zǝ furakh sar, da ǝntla khay Dalmanut. ");
INSERT INTO gdf_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ka sagh yakhaya kǝ Farisakh da vak Yasu, farsa itar man tsugu zǝ zin. Ən gat mǝdlatra dǝg ndawak itar. Kǝ mǝdla kwarne, a khayanǝf Yazhigǝl din. ");
INSERT INTO gdf_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ka safa tsin gǝlf dǝ ndzǝɗ, ni. “Uɗa lava kǝ udakh kwargǝn ǝn ndiɗ dǝg ndawaki? Ən tǝkha kura tǝkha kǝ, na dǝg ndawake da mǝdlatrud bi.” ");
INSERT INTO gdf_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Khalak yana, ka ɗuwatǝrs, ka gwiya da peryu. Dal da tǝ tlǝrna ghǝdzǝva gadzak. ");
INSERT INTO gdf_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","A mbitsa tǝrghǝr zǝɓ brudi kǝ furakh Yasu, uk brudi kitakul ǝn peryuwen. ");
INSERT INTO gdf_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Ka nǝv Yasu tsitar, “Tsukwamana ghǝr dǝgi, ɗem nikur kǝ yista Farisakh zǝ dǝg Khirudus.” ");
INSERT INTO gdf_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Ka farsa itar ad kwarakava lav ǝn tatak tar kwarne, “Wirva na brudi ǝn vak mar bi, in kǝ mangan kǝ kwar ina tsin.” ");
INSERT INTO gdf_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Tsa kǝ Yasu ad lave ǝn kwara itar. Ka ndiɗatǝrwal, “Ən kwara kǝ uɗa kur kwarne nakur dǝ brudi biyi? Sakhkana a katlga ba kur biya? Tsuguna, a diyarsǝf ba kur biya? Uɗa lava kǝ rǝvura dlaɓ dǝkdǝki? ");
INSERT INTO gdf_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Nǝg kur dǝ diyakh, uɗa lava tsukur kwal ǝn nǝgha nǝghi? Nǝg kur dǝ tlimakh, uɗa lava tsukur kwal ǝn tsǝna tsǝni? A dzamana bakh kura. ");
INSERT INTO gdf_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Ən sarte tsa kalanaka brudi dliɓ, kǝ udakh dǝb dliɓ, ngǝrwa tughubakh, ake tǝmgan a dzakhanǝf kuri?” Ka nǝv itar, “Kǝlatǝm mits.” ");
INSERT INTO gdf_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“Ən sarte tsa kalanaka brudi uɗif, kǝ udakh dǝb ufaɗ, ngǝrwa tughubakh, ake tǝmgan a dzakhanǝf kuri?” Ka nǝv itar, “Uɗif.” ");
INSERT INTO gdf_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ka niya tsitar, “Dambiyanena, dla kur kwal katlgana?” ");
INSERT INTO gdf_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Sa tsitar da Betsaid, ɓadǝghǝr yakhaya kǝ udakh ad ngulf da vak Yasu. Ka takaɗ Yasu tsitar kǝ gǝma gǝma tsin, kǝ mbambǝg tsin. ");
INSERT INTO gdf_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ka khutanan ad ngulfen ǝn tǝ dǝv, ndaɗal da tǝlg kǝs. Tǝfara tsin shaghwvay da di kǝ udanǝn, baw ad dǝv sar ǝn tǝf. Ka ndiɗarwal, “Ən nǝgha nǝgha kha digita?” ");
INSERT INTO gdf_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Ka lando ngulfen ad ghǝr, ni, “Ən nǝgha nǝgha ka udakh, ai ǝn vastra ngwaɗa ufakhe ǝn gwayava kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Ka gwidǝn bo Yasu ad dǝv sar ǝn tǝ di udanen. Ngwarǝf di sar charang. Ka farsan ad nǝgha vak tsugun. Ka nǝghan ad itsauɗa chaɗaɗ. ");
INSERT INTO gdf_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Ka ɓǝlars Yasu daks da mǝgh, ka kwar khai tsugun, “A ɗuwa daks diwa khuɗ kǝs.” ");
INSERT INTO gdf_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","A ɗuwars Yasu zǝ furakh sar ad kǝs Betsaid, da itar da gǝdzar kǝsakh ǝn khaya ya Kaisari Filibi. Madǝv itar ǝn dǝga, ka ndiɗatǝrwal kǝ furakh sar, “Warek ka vek udakhi?” ");
INSERT INTO gdf_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Ka nǝv itar tsin, “Av yakhaya Yukhan dadak para ud khǝ. Av yakhay Ili khǝ. Av yakhaya tsuguna kha fang ǝn tǝb kǝ tlayanggakhe tsa dur.” ");
INSERT INTO gdf_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Ka niya tsitar, “Ai kur ma? Warek ka vek kuri?” Ka nggawar khai Bitrus kwarne, “Kha Kristu.” ");
INSERT INTO gdf_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Ka ndǝɗatǝrnǝf Yasu ad tlim, kwarara ba itar kǝ itsawar ad lavǝn tǝghǝr tsin bi. ");
INSERT INTO gdf_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Ən tǝkhal kǝ yan, ka farsa Yasu ad tsagatǝrdu tsaga kǝ furakh sar kwarne, “Ka Zǝr Ud, da khǝɓa khǝɓa ka dlaɗ char sikh sikh sikh. Malanakh ǝn tǝghǝr kǝ udakh, zǝ zik zikan na kǝ zil kǝsakh, zǝ li tsagdu ndzikha ndzikh, da ɗukda ɗuwa itar. Da kǝɗ kai kǝɗud, ǝn tǝ fitsa khekǝrɗa da tsiya kǝn nggitl. ");
INSERT INTO gdf_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","A kwara tǝrkhai ad ina kǝ lav ǝn ɓal a ɓǝghana bi, ka ndaɗala Bitrus ad Yasu da tǝ kalam, ka farsa tavarghǝr di tsin. ");
INSERT INTO gdf_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Ai guyafkhai kǝ Yasu, ka vazgan ad chalǝm furakh sar. Ka tavarghǝr ad di kǝ Bitrus, “Tsiya dǝgal ǝn tǝvǝgh tsǝka kha Shatan, rǝvagha a khayanǝf ba dǝ dǝge ǝn nagha Yazhigǝl bi, ǝn khaya dǝge ǝn nagha ud dǝg sig.” ");
INSERT INTO gdf_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Ka ɗakhga Yasu ad dzakhava udakh zǝ furakh sar da vak sar. Ka ni, “Ɗeghwa ude ǝn na nǝga kǝ furara, akwa ɗudin ghǝr sar, ɓǝfin ufa khǝrta sar, ka gataks in. ");
INSERT INTO gdf_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Wirva ɗeghwa ude ǝn na kat safa sar, da bǝghǝmb. Ai ɗeghwa ude ǝn bǝdu safa sar wirva kǝ, zǝ kǝ lav Yazhigǝl, da gǝmadu gǝma dǝ safa kǝ ngǝɗ. ");
INSERT INTO gdf_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Khwara ndǝk uɗa da gǝmadu udan ad digit daghan ǝn lard, ai ka bǝghalǝn safa sari? ");
INSERT INTO gdf_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Uɗǝn da bǝdu udan kǝ dleva safa sari? ");
INSERT INTO gdf_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Itsawar ǝn man zhiruwar, zǝ zhiru kwardu lavar, ǝn nguɗi nguɗi kwargǝn, ka Zǝr Uda, da man zhiru sar kǝn sarte da sǝgadagh kǝn ndanga Dadar, dagha zǝ zar ɓǝla Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Ka zu vuk tsin dǝ kwar kwarne, “Ən tǝkha kura tǝkha kǝ, nǝg yakhayin ghitsǝn van, na itar da mǝtsa bi, akwa nǝgha itar ad tlǝksa Yazhigǝl, ai da mǝdlo dǝ ndzǝɗ.” ");
INSERT INTO gdf_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ən tǝkhal kǝ khǝna ǝnkwakha, ka dal Yasu zǝ Bitrus, zǝ Yakub, zǝ Yukhan, ka ɓǝtǝro dugo da tǝ ghuɓe tsǝɓanyan, vake uk itar tukuɗa tar. Ən tǝ vina ka mbǝɗfkhai vǝgha sar ǝn tǝvuk tar. ");
INSERT INTO gdf_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Gabag sara a nala kǝ maɗakw til ǝn wuɗ char ǝn zǝɓara di kǝ ud. Na dadak ghuɓ kadlang ǝn lard ai da tǝkha kǝ ghuɓgan da tǝ maɗakw sar bi. ");
INSERT INTO gdf_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Dzagwdlam, ka mǝdlawala Ili tlayang zǝ Mus tlayang, ǝn kwar lava itar zǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Ka nǝv Bitrus kǝ Yasu, “Malǝm, khwarenǝn vana kǝnd. Manga mana kǝnd ad tsikw khǝkǝrɗ, fang tsǝkha, fang kǝ Musa tlayang, fang kǝ Ili tlayang.” ");
INSERT INTO gdf_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ən tsa ba dǝ dǝge da kwarin bi, wirva khǝkǝrɗ dagha tara a gǝdzǝf itar char. ");
INSERT INTO gdf_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ka sadagh ghwikwa, khǝmbatǝrghǝr. A tsǝna tsud lavǝn ghwik kwarne, “Zǝraren, ǝn waya waya kǝ. Tsǝnamaru tsǝn.” ");
INSERT INTO gdf_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ɓalakhga tsitar ad diya, a gwidǝn ba itar nǝgha itsawar bi, uk Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Madǝv Yasu zǝ furakh sar ǝn sǝgdagh ǝn ghuɓ, ka ndǝɗatǝrnǝf Yasu ad tlim kwarne, kwarara ba itar kǝ itsawar ad dǝge a nǝgha itar bi. Akwa tsiyakǝfud ka Zǝr Ud ǝn nggitl. ");
INSERT INTO gdf_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Wirva yana, ka ɗu itar ad laven ǝn khuɗ tar. Ən ɗaya kava ɗaya itar ǝn tǝb tar kwarne, “Uɗa dǝge ǝn tuku tsiyin nggitle a kwarga Yasuwi?” ");
INSERT INTO gdf_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Khalak yana, ka ndiɗarwal itar kǝ Yasu kwarne, “Uɗa lava kǝ li tsagdu ndzikha ndzikh ǝn kwarne, khekwa Ili tlayang da sodagh chak kǝ Kristuwi?” ");
INSERT INTO gdf_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ka nggawa tǝrkhai Yasu kwarne, “Barari Ili tlayang da sodagh chak, kǝ ɗika itsauɗ, kalkal ndǝke ǝn naghud. Wirva yan, ai uɗa lava tsin vindzan kwarne, da khǝɓ khǝɓa Zǝr Ud ad dlaɗ char zǝ ɗuda duwa tsudi? ");
INSERT INTO gdf_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Ai ǝn tǝkha kura tǝkha kǝ, audzal Ili tlayang ǝn sodagh sǝg. A manarkhai udakh ad ɗaga dǝge ǝn nagha rǝva tar. Ndǝkve vindzanin ǝn kaɗkaɗ lav Yazhigǝl ǝn tǝghǝr tsin.” ");
INSERT INTO gdf_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Gwiyoghǝr kǝ Yasu zǝ furakhna khǝkǝrɗ da vak furakhe tsa tǝmgan, ka nǝgha itar ad dzakhava udakh a tsatǝrghǝran kǝ furakhen. Li tsagdu ndzikha ndzikh Mus tsuguna, ǝn manakava tsugu zitar. ");
INSERT INTO gdf_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Ba uk nǝgha nǝgha kǝ dzakhava udakh ad Yasu, ka a ndawatǝrǝf char, ka khwaya tsitar da gama gam. ");
INSERT INTO gdf_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Ka ndiɗatǝrwal Yasu kǝ furakh sar kwarne, “Tsugu uɗǝn mana kur zǝ itar ra?” ");
INSERT INTO gdf_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Ka nggawar khai udanen ǝn tǝb kǝ dzakhava udakh kwarne, “Malǝma, a ɓakhdǝghǝr ka zǝrar ai dǝ sǝɗikw bǝzan ǝn vǝgh tsin, ai gadlarkhai ad kwar ghay. ");
INSERT INTO gdf_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Itsǝra kǝ sart ǝn tsukwarghǝrin, ka tlǝvarghǝr da khay. Ka sǝgawala kubǝn ghay tsin, ka kǝrɗ tliɗ tsin, ghulala jigh. A takaɗga ka furakhagh kǝ lakwadal sǝɗikw bǝzan ǝn vǝgh sar, ai a piyatǝrwal.” ");
INSERT INTO gdf_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Ka nǝv Yasu tsitar, “Kur udakh kwargǝn, li khǝtsa fadǝghǝrofǝg. Da zulu pak uɗa kǝn giɗa zǝ kuri? Da zulu pak uɗa kǝn bǝg rǝv dǝ kuri? A nǝgham zǝren da vakar.” ");
INSERT INTO gdf_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Ka ɓardǝghǝr itar zǝren. Nǝgha kǝ sǝɗikwen ad Yasu, kujaɗ kujaɗa, ka tatǝg tsin ad zǝren, ka ɓǝlal zǝren da khay. Ka kuɗmbǝl kuɗmbǝl dǝva tsin ǝn tǝ khay, dǝ kubǝn ghay. ");
INSERT INTO gdf_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Ka ndiɗarwar Yasu kǝ dad zǝren, “Yawa farsin manara mani?” Ka nggawar khai dad zǝren kwarne, “Gwil ǝn zara tsin.” ... ");
INSERT INTO gdf_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Ka zu vuk tsin dǝ kwar lav, ngǝrwa sig tsin ǝn tlavarghǝr tlava da kar zǝ yu kǝ kǝɗga kǝɗ. Da nǝg dǝge da tǝkha kha kǝ mangan, ziwa kǝndalakh, mǝlakǝndu khǝ.” ");
INSERT INTO gdf_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Ka nǝv Yasu tsin. “Uɗa lava tsǝkhǝn kwar kwarne, da da tǝkha khi? Itsauɗa ǝn manawa mana kǝ dadake a fadǝghǝro.” ");
INSERT INTO gdf_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Tǝvin tǝvina ka nǝv dad zǝren, “A fadǝghǝro kǝ. Mǝlaku mǝla kǝ sǝgakarghǝr fadǝghǝro fǝgar.” ");
INSERT INTO gdf_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nǝgha kǝ Yasu ǝn saks dzakhava udakh da vak sar dǝ khway, ka tavarghǝr ad di kǝ sǝɗikw bǝzanen. Ka ni, “Kha sǝɗikw bǝzan, khe ngǝdlarkhai kwar ghay kǝ zǝrǝn. Ən kwara kha kwara kǝ, sawal sǝg ǝmb, aghba khǝn da damb bi.” ");
INSERT INTO gdf_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Ka khula kǝ sǝɗikw bǝzanen, gwidzanǝfa, ka sawal ǝn vǝgh sar. Ka khǝnga zǝren ǝn khay ndǝk mǝtsa ud. Wirva yan, nǝv udakh zikǝn, “Amtsǝgan.” ");
INSERT INTO gdf_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ka khutana Yasu ad dǝv zǝren, tsiyanǝf, ghitsgan ǝn tǝ siga sar. ");
INSERT INTO gdf_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Da kǝ Yasu da mǝgh, ka ndiɗarwal furakh sar ɓǝghaniyan, “Uɗa lav a piyakǝndwal ɓadal sǝɗikw bǝzaneni?” ");
INSERT INTO gdf_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Ka nggawa tǝrkhai Yasu kwarne, “Khulfina kǝ sǝɗikw bǝzan na, uk ɗǝgawa kalti ǝn ɓado.” ");
INSERT INTO gdf_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ka ɗuwars Yasu zǝ furakh sar ad vaken, dala itar, dǝgal diwa khaya Galili. Nagh ba Yasu ad tsatsǝg kǝ itsawar ad vake din itar bi, ");
INSERT INTO gdf_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","wirvǝn tsagatǝrdu tsaga kǝ furakh sar. Ka niya tsitar, “Da bǝkdu bugud, ka Zǝr Ud da dǝv kǝ udakh. Ka da kǝɗka kǝɗa itar kǝ ǝmts, ǝn tǝ fitsa khǝkǝrɗa, da tsiya kǝn nggitl.” ");
INSERT INTO gdf_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Ai a katlga ba itar ad tsagdu tsaga sar na bi. A ndiɗarwal ba itar tsugun bi. Wirvǝn gǝdza gǝdza itar. ");
INSERT INTO gdf_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","A sa Yasu zǝ furakh sar da Kafarnakhum. Da kǝ Yasu da mǝgh, ka ndiɗatǝrwal kǝ furakh sar, “Uɗa tsǝn kwara kava kur ǝn tǝ ɗuli?” ");
INSERT INTO gdf_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Ai ka ndzǝga itar tǝriɗ, wirva tsǝn kwara kava kwara itar ǝn tǝb tar, ǝn tǝghǝr kǝ, warek zikan daghan ǝn tǝb tar. ");
INSERT INTO gdf_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ka ndzǝga Yasu, ɗakhgan ad furakh sar kǝlatǝm mits, niya tsitar, “Ɗeghwa ude ǝn na nǝga kǝ dǝg chak, barari tsin nǝga kǝ dǝg ngiɗangiɗ, nalin kǝ dadak manara tlǝr kǝ itsawar.” ");
INSERT INTO gdf_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Ka ɓadǝghǝr ad zǝr khǝɗikan ghitsanan ǝn tǝb tar, ka ɓǝlarghǝr ad dǝv sar, ka niya tsitar, ");
INSERT INTO gdf_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Itsawar ǝn chauga zǝr khǝɗikan ndǝk inan ǝn ɗakhar, ka chaukayin. Dadake chaukaya, ka kitakul ba chaukayin bi, zǝva dadake a ɓǝlokondagh a chaugin. ");
INSERT INTO gdf_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Ka nǝv Yukhan, “Malǝm, nǝgha tsǝkǝnda udanen ǝn ɓado sǝɗikw bǝzan ǝn vǝgh kǝ udakh ǝn ɗakhagh. Ka gadlar khai kǝnd, wirva na ba zǝ kiyam bi.” ");
INSERT INTO gdf_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Ka nǝv Yasu tsitar, “Gadlamara bi. Wirva na ude ǝn man dǝg ndawak ǝn ɗakhara, tǝvin tǝvin tsuguna ka kwar lav bǝzan ǝn tǝghǝr tsǝka bi. ");
INSERT INTO gdf_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Wirva ude kwal man tlughuma dǝ kiyama dǝg mar. ");
INSERT INTO gdf_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Ən tǝkha kura tǝkha kǝ, ɗaga ude ǝn kakuru yu itsǝn kwat khǝɗikan, wirva a fadǝghǝro kur ǝn tǝ ka, ka Kristu. Naba da bǝghǝn dǝg siga sar tsa khǝɗikǝn bi. ");
INSERT INTO gdf_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Ɗeghwa ude a ba fang ǝn tǝb kǝ zar mbisan nan, liye fadǝghǝro ǝn tǝ kǝ da man khaip, a dara nguɗarǝmud zikan na kǝ vǝr ǝn kwind, kǝɗ daghud da dǝlv. ");
INSERT INTO gdf_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Da dǝva ǝn bǝgkhan da man khaip, ǝntlars ǝntla dǝgal. Adara da dǝ dǝv kitakul kha da vake da mbǝladu kha safa kǝ ngǝɗ, tǝghǝr kǝ daks tsǝkha dǝ dǝv mits da kara tsakaitsakai. ");
INSERT INTO gdf_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Vake, “ ‘Kwaɗe ǝn zutǝr zuwa naba itar ǝmtsa bi. Karen tsuguna da tǝkh bud kǝ kǝɗgan bi.’ ");
INSERT INTO gdf_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Da ka sigagh ǝn bǝgkhan da man khaip, ǝntlars ǝntl. Azǝgha da ghurɗik kha da vake da mbǝladu kha safa kǝ ngǝɗ, tǝghǝr kǝ tlǝvkhǝdaghud dǝ sigakh mits da kara tsakaitsakai. ");
INSERT INTO gdf_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Vake, “ ‘Kwaɗe ǝn zutǝr zuwa naba itar ǝmtsa bi. Karen tsuguna da tǝkh bud kǝ kǝɗgan bi.’ ");
INSERT INTO gdf_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Da ka diyagh ǝn bǝgkhan da man khaip, ndǝɗdu khǝ. Azǝgha da dǝ di kitakul kha da tlǝksa Yazhigǝl, tǝghǝr kǝ tlǝvǝghǝdaghud dǝ diya mits da kara tsakaitsakai. ");
INSERT INTO gdf_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Vake, “ ‘Kwaɗe ǝn zutǝr zuwa naba itar ǝmtsa bi. Karen tsuguna da tǝkh bud kǝ kǝɗgan bi.’ ");
INSERT INTO gdf_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Da chuwaɗa chuwaɗud ad itsawar dǝ kar, ndǝkve ǝn chuwaɗud dǝg tsufa dǝ tlugul. ");
INSERT INTO gdf_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Tlugula khwar, da tǝkaghǝrin dǝ nashnasha sara, da gwiyondǝghǝr ndarud ad nashnasha sari? Nalnǝg giɗura zǝ tlǝrur ndǝk tlugul. Tsuguna, ka giɗa gabǝr kur ǝn tǝbur.” ");
INSERT INTO gdf_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ka ɗuwars Yasu ad yanen kǝ vak, ka dal da ǝntla khaya Yakhudi, zǝ ghǝdzǝva zagha Urdun. Ka gwidǝn sawala dzakhava udakh da vak sar. A tsagatǝrdu ndǝkve a kwiyalin. ");
INSERT INTO gdf_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Ka saks kǝ yakhaya kǝ Farisakh da kura kura dǝ ndiɗ. Ka ndiɗarwal itar, “Kalkal nagh tǝkaghǝra kǝ udan zǝ nus sara?” ");
INSERT INTO gdf_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ka niya tsitar, “Uɗa tǝkha kurna Musi?” ");
INSERT INTO gdf_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Ka nǝv itar tsin, “A khayarnǝf Mus ad vindzara kaɗkaɗ pǝcha sǝba kǝ ud, kǝ lakwars lakwa dǝgal.” ");
INSERT INTO gdf_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ka nǝv Yasu tsitar, “Tsa wirva ɓengɓeng rǝvakhuɗur, tsa vindza kurkhai Mus adina kǝ ndzikh.” ");
INSERT INTO gdf_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","“Ai gwil farsa vǝrɗ lard, ‘A vǝrɗtǝrkhai Yazhigǝl kǝ zila zǝ nus.’ ");
INSERT INTO gdf_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Wirva yan, ka da ɗuwars udan ad dadsar zǝ babsar kǝ khǝmbarva kǝ nus sar. ");
INSERT INTO gdf_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","Ka mits dagha tara da nǝga kǝ vǝgh kitakul. Aghba itar mits bi, anala kǝ vǝgh kitakul itar. ");
INSERT INTO gdf_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Wirva yan, dǝge audzala Yazhigǝl ǝn matlanǝf matla, tǝka ba udan bi.” ");
INSERT INTO gdf_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Gwiyoghǝr tsitar saks da mǝgh, ka ndiɗarwar furakh sar kǝ Yasu ǝn tǝghǝr kǝ tǝkaghǝren. ");
INSERT INTO gdf_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Ka nggawa tǝrkhai Yasu, “Ɗeghwa ude tǝkaghǝra zǝ nus sar, ka zǝɓu ad tlǝrna nus, gwaragwar ǝn manin zin. ");
INSERT INTO gdf_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Ai da ka tǝkaghǝra nus zǝ zil sar, ka zǝɓuwin tlǝrna zil, gwaragwar ǝn manin zin. ");
INSERT INTO gdf_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Tsǝn zaɓakhado zar mbisan udakh da vak Yasu, kǝ bakhatǝrghǝr dǝv tsin, kǝ batǝrghǝr bark. Ai ka tavatǝrghǝr furakh sar ad di kǝ zaren. ");
INSERT INTO gdf_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Vazga kǝ Yasu ad dǝge a mangga furakh sar, ka bazala rǝv tsin. Niya tsitar, “Ɗuwamada ɗuwa zar mbisan saks da vakar, gadlamatra bi. Wirva tlǝksa Yazhigǝla, dǝg khutsak tar. ");
INSERT INTO gdf_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Ən tǝkha kura tǝkha kǝ, itsawar kwal khayanǝf dǝ tlǝksa Yazhigǝl, ndǝkve a khayanǝf zar mbisan, a tǝkh ba kǝ da da tlǝksa Yazhigǝl bi.” ");
INSERT INTO gdf_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Ka tsakwatrǝf dǝ fang fang, ɓalatǝrghǝr ad dǝv, ka batǝrghǝr ad bark. ");
INSERT INTO gdf_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Tsif kǝ Yasu da ɗuwars yanen kǝ vak, ka khwayoghǝr udanen da vak sar, kǝlgan ad juguv ǝn tǝvuk sar. Ka ndiɗarwal kwarne, “Malǝm charan, uɗa da mana ka kǝ gǝmadu safa kǝ ngǝɗi?” ");
INSERT INTO gdf_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Ka nǝv Yasu tsin, “Uɗa lava tsǝkhǝn ɗakhka dǝ charani? Na ud charan bi, uk Yazhigǝl kitakul. ");
INSERT INTO gdf_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Tsa tsǝkha dǝ ndzikha ndzikhen, ai kwarne, ‘Kǝɗ ba safa bi. Man ba gwaragwar bi. A ɗuwa man gǝl. Man ba shida dǝge kwal nǝgha tsǝkha bi. Biɗ ba dǝ ud bi. Farghǝra fǝg kǝ dadagha zǝ babagh.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Ka nǝv daghwalen tsin, “Malǝm, gwil ǝn zara tsǝka ǝn tsufa tsufa ka dǝgakhan na daghan.” ");
INSERT INTO gdf_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Ka vazga Yasu dǝ vaza waiv. Niya tsin, “Digit kitakul kǝ khǝtsakhu. Daks sakwdu sakwa daghan dǝge din khǝ, batra kha kwaɓ sar kǝ talagakh. Ka da gǝmadu gǝma kha tluwandal ǝn gharazhigǝl. Tǝkhal kǝ yana ka gataks khǝ.” ");
INSERT INTO gdf_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Tsǝna kǝ dakhwalen ad lave kwarga Yasu, ka bazala rǝv tsin. Tǝkavala dǝ baza rǝv, wirva nǝg lǝman tsin char. ");
INSERT INTO gdf_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Ka vazakhga Yasu ad furakh sar, ka niya tsitar, “Da bǝza daks kǝ dadak tluwandal da tlǝksa Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","A ndawatǝrǝf kǝ furakh sar, tsǝna tsitar ad lave kwargin. Ai ka nǝv Yasu tsugun, “Zar mbisan nakhar, bǝza daks kǝ ud da tlǝksa Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Da lakhlakh kǝ dlǝgwam daks ǝn tǝ ɗul lipǝr, tǝghǝr kǝ daks kǝ dadak tluwandal da tlǝksa Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Tsǝna kǝ furakh sar ad laven, ka gwidǝn ndawatǝrǝf char. Ka nǝv itar ǝn tǝb tar, “Ai da ka ndǝkyanina, war da gǝmadu safa nǝn vak Yazhigǝli?” ");
INSERT INTO gdf_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Ka vaztǝrkhai Yasu, ka ni, “Ən vak ud dǝg siga ǝn manawa bi, ai ǝn vak Yazhigǝla itsauɗa ǝn manawa man.” ");
INSERT INTO gdf_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Ka nǝv Bitrus tsin, “Ai kǝnda ma, a ɗuwars kǝnda itsauɗa a gatakhs kǝnd.” ");
INSERT INTO gdf_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Ka nggawa tǝrkhai Yasu, “Ən tǝkha kura tǝkha kǝ, na ude a ɗuwars fǝta sara, itsa zarbabakh sara, zǝ dǝghaubabakh sar, zǝ bab sar, itsa dad sar, itsa zar sar, awana gukhakh sar, wirva ka, zǝ lav zǝɗan tsugun, ");
INSERT INTO gdf_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ka piyarwala gǝmadu dǝg siga sar sig dǝrmǝk dǝrmǝk ǝn kwargǝna bi. Da gǝmadu gǝma dǝ mǝghakha, zǝ zarbabakh, zǝ dǝghaubabakh, zǝ babakh, zǝ zar, zǝ gukhakh. Gǝmadu yaken tsuguna khekwa dǝ dlaɗ. Ən kwarge da saks, da gǝmadu gǝma ad safa kǝ ngǝɗ. ");
INSERT INTO gdf_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Wirva zikǝn liye tsa dǝg chaka, da nǝga itar kǝ dǝg khal. Liye dǝg khal tsuguna, itar da nǝga kǝ dǝg chak.” ");
INSERT INTO gdf_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ən tǝghǝr kǝ ɗul dǝgo da Wurshalim Yasu zǝ furakh sar, Yasu ǝn mǝlatra vuk. Lave tsa kwarga Yasu, ǝn ndawatra ndawa kǝ furakh sar, ka liye ǝn gatatǝrs gata tsuguna ǝn gǝdza itar. Ka gwidǝn ndǝɗtǝraga Yasu kǝ furakh sar na kǝlatǝm mits da tǝ kalam, ka kwara tǝrkhai ad dǝge da dzoghǝr din. ");
INSERT INTO gdf_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Ka ni, “Tǝkhina ǝn dǝgo da Wurshalim kiyam, da bǝdu bǝgud Zǝr Ud da dǝv kǝ zik zikan na kǝ zil kǝsakh, zǝ li tsagdu ndzikha ndzikh. Da ǝntlara lav ǝmtsud. Ka da barǝm bǝg itar ǝn dǝv kǝ liye kwal Yakhudakh. ");
INSERT INTO gdf_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Da nenenena itar, zǝ tafarva shaghwvai. Wadzaru itar kiɓa, zǝ kǝɗga kǝɗa tsitar. Ən tǝkhal kǝ khǝna khǝkǝrɗa da tsi. ");
INSERT INTO gdf_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Ka sagh Yakuba zǝ Yukhan zar ya Zabadi da vak Yasu. Ka nǝv itar, “Malǝm, ǝn na kǝnda mana kǝndkhe kha ɗaga dǝge a takaɗga kǝnd.” ");
INSERT INTO gdf_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Ka ndiɗatǝrwal Yasu, “Uɗǝn nagh kur mana kurkhai mana tsǝki?” ");
INSERT INTO gdf_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Ka nggawar khai itar, “Khaya kǝndanǝf khaya ndzǝga ndzǝg tlǝrna udǝnd ǝn tǝ dǝva kafagh, tlǝrna udǝnda tsuguna ǝn tǝ dǝva dleɓagh, ǝn sarte da sǝgdagh khǝn ndangagh.” ");
INSERT INTO gdf_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Ai ka nǝv Yasu tsitar, “Ən tsa bakur dǝge ǝn takaɗa kur bi, da tǝkha kur kǝ khǝɓga dlaɗe da khǝɓa ka? Awana da khayanǝf khaya khǝ kur ad mana kura para tsud dǝ khulf pare da manakuda?” ");
INSERT INTO gdf_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Ka nggauga itar, “Da tǝkha kǝnd,” Ka nǝv Yasu tsitar, “Da tǝkha kur kǝ khǝɓga dlaɗe da khǝɓa kǝ, parakuralud dǝ khulf pare a parakadud. ... ");
INSERT INTO gdf_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Ndzǝgan ǝn tǝ dǝva kafara zǝ dǝva dleɓara, na ka dǝ ndzǝɗa bǝdu bǝg bi. Yan kǝ vakakha dǝg liye audzalud ǝn ɗikatǝrna ɗik. ");
INSERT INTO gdf_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Tsǝna kǝ chalǝm furakh kǝlɗǝk ad yan kǝ lav, ka bazala rǝv tsitar ǝn tǝghǝr kǝ Yakub zǝ Yukhan. ");
INSERT INTO gdf_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Ka ɗakh tǝrkhai Yasu da tǝ dǝva kitakw, ka ni, “Tsa tsukur liye a bǝgud kǝ man tlǝks ǝn tǝghǝr kǝ liye kwal Yakhudakh, ǝn mǝdlatra tlǝks itar kǝ udakh tar. Zik zikanakh tar tsuguna ǝn mǝdlatra ndzǝɗe tar. ");
INSERT INTO gdf_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Da ndǝkyan bǝn tǝbura bi. Ai ɗaga ude ǝn nagh nǝga kǝ zikan ǝn tǝbur, barari tsin nǝga kǝ dadak mana kura tlǝr. ");
INSERT INTO gdf_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Tsugun ɗaga ude ǝn nagh nǝga kǝ mal ǝn tǝghǝr tsukur, barari tsin nǝga kǝ dadak mana tlǝr kǝ itsawarur. ");
INSERT INTO gdf_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Wirva itsa ka Zǝr Uda dǝ ghǝrar, a sodagh ba kǝ wirva ɗaba ka ɗaba tsud bi. Ai a sodagh kǝ ɗaba udakh kǝ, zǝ bǝdu safara tsǝka kǝ kat da udakh daghan. ");
INSERT INTO gdf_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Khalak yana, ka sagh Yasu zǝ furakh sar da Yariko. Madǝv Yasu zǝ furakh sar zǝ dzakhava udakh zikǝn, ǝn ɗuwars khuɗ kǝs, ka nǝg ngulfen ɗakha sara Batamawus (dǝge ǝn tuku Batamawus na, “Zǝr Timawus.”) Ən ndzǝgan ǝn tǝ kalam ɗul ǝn takaɗ. ");
INSERT INTO gdf_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Tsǝna tsin kwarne, Yasu ud Nazarat ǝn dǝgal, ka farsa tlǝkha tsin kwarne, “Yasu Zǝr Dod, ziwakdal ziw.” ");
INSERT INTO gdf_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Zikǝn liye tavarghǝr di kwarne, “Tǝriɗ nikh.” Ai ka gwidǝn tlǝkha tsin char, ǝn kwar kwarne “Zǝr Dod, ziwakdal ziw.” ");
INSERT INTO gdf_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Ghitsga Yasu, ka ni, “Ɗakhamakdǝghǝr ɗakh.” Ka ɗakhga itar ad ngulfen. Ka nǝv itar tsin, khǝnana rǝvagh, “Tsiyiftsi, ǝn ɗakha ɗakh.” ... ");
INSERT INTO gdf_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ka tlǝvars ad lǝgwit sar da tǝ kalam. Ɗǝkut niya ghǝdzǝvǝf, khwayal da vak Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Ka ndiɗarwal Yasu, “Uɗǝn nakha manakha mana tsǝki? Ka nggawar khai ngulfen, “Malǝm, ǝn na ka nǝgha nǝgh.” ");
INSERT INTO gdf_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Ka nǝv Yasu tsin, “Dǝg dǝgal, fadǝghǝrofǝgagh kǝ mbakhu.” Tǝvin tǝvina ka ǝn nǝgha nǝgh. Ka gatars kǝ Yasu dǝgal. ");
INSERT INTO gdf_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Sa kǝ Yasu zǝ furakh sar khef dǝ Wurshalima, da da dlǝmdla kǝs Betfaji zǝ Betani, ǝn tǝ ghuɓa Olive. Ka ɓalanǝf ad furakh sar mits. ");
INSERT INTO gdf_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","Niya tsitar, “Damdǝgal da gǝdzǝr kǝsin ǝn tǝvukur. Ba kur ǝn daksa, da nǝgha nǝgha kur gǝlaɓa dlingw ngguɗan ǝn vin, ai kwal taɓa tsud ngala ngal. Vǝdamadǝghǝr vǝd saks da van. ");
INSERT INTO gdf_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Itsawar ǝn ndiɗakurwal, kwarne, ‘Uɗa lava tsukur ǝn zǝɓ gǝlaɓa dlingwna? Nikur tsina, ‘Dad Zikan ǝn naghan, da guyondǝghǝr guya zula khǝɗikǝn.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Ka dala itar, tlarghǝr itar ad gǝlaɓa dlingwen nguɗan ǝn tǝ ghay rang da tǝ baram. Da itar ǝn vǝdavǝda, ");
INSERT INTO gdf_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ka ndiɗatǝrwal liye ghits ǝn tǝ vin, kwarne, “Uɗa lava tsukur ǝn vǝda dlingw ni?” ");
INSERT INTO gdf_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Ka nggawa tǝrkhai itar ndǝkve tsa kwara tǝrkhai Yasu, ka ɗuwatǝrs udakhen dǝgal dǝ dlingw. ");
INSERT INTO gdf_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ɓadǝghǝr tsitsar gǝlaɓa dligwen da vak Yasu, ka ɓalo itar lǝgwitakh tar da tǝf, ka ndzo Yasu ǝn tǝf. ");
INSERT INTO gdf_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Zikǝn udakhe a ɓalga lǝgwitakh tar ǝn tǝ ɗul, yakhaya tsuguna a ɓalakhga itar tlim ufakhe tsa patsadǝghǝr itar ǝn tǝghal. ");
INSERT INTO gdf_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Liye ǝn tǝvuk sara zǝ liye gatars gatǝn tǝlg, ǝn ɗichau itar kwarne, “Bark kǝ Zǝr Dod” “Bark kǝ dadake ǝn saks ǝn ɗakha Dad Zikan” ");
INSERT INTO gdf_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","“A ndzawa bark kǝ tlǝksa Dad mar Dod ai da saks” “Bark kǝ Yazhigǝl ai ǝn gharazhigǝl” ");
INSERT INTO gdf_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Sa kǝ Yasu da Wurshalima, ka da da Fǝta Yazhigǝl. Ka vazarvala kǝ itsauɗ, fatsiye tsatsin kwarne a sawal ba dura bi, ka dal da Betani zǝ furakh sar kǝlatǝm mits. ");
INSERT INTO gdf_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Tǝkǝtla sar, madv Yasu zǝ furakh sar ǝn ɗuda Betani. Ka ndzikǝnǝf way kǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ka nǝgha Yasu ad ufa ghǝdiv ngudǝv kǝ bit, ka dǝgal tsin da vaza zǝr ǝn tǝf. Da tsǝn da tǝ vǝgh, na dǝge a mbǝladuwin ǝn tǝ bi, uk mas, wirva sarta yig zǝr ba yanen kǝ gǝdiv bi. ");
INSERT INTO gdf_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Ka nǝv Yasu kǝ ufa ghǝdiven, “Na ude da gwidǝn zu zǝr ufagh bi.” A tsǝna kǝ furakh sar ad dǝge kwargin. ");
INSERT INTO gdf_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Da kǝ Yasu zǝ furakh sar da Wurshalim, ka da Yasu da fǝta Yazhighǝl. Ka farsan ad lakw li sakw digita zǝ li dzaw ǝn vin. Ka tlagars ad vǝleng li mɓaɗdu kwaɓ, zǝ vǝleng li sakwdu takalamasar. ");
INSERT INTO gdf_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Ka gadlarkhai ad zǝɓ itsauɗ kǝ udakh dǝgal diwa Fǝta Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ka farsa tsagatǝrdu lava tsin kǝ udakh, ni, “Vindzan ǝn kaɗkaɗ lav Yazhigǝl kwarne, ‘Fǝtara da ɗakha dǝ vak ɗǝgawa kǝ daghan kǝsakhud. Ai tsuguna ka nandal kur kǝ vak ɓǝghava sǝnkarakh.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Tsǝna kǝ zikzikan na kǝ zil kǝsakh zǝ li tsagdu ndzikha ndzikh ad yan, ka gat ɗul kǝɗ Yasu tsitar kǝmts. Wirvǝn gǝdza gǝdza itar, wirva ɗeghwa dzakhava udakh a batra tsagdutsaga sar ad ndawak. ");
INSERT INTO gdf_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ɓǝlga kǝ khagwa, ka sawala Yasu zǝ furakh sar ǝn dlǝmdla kǝsen. ");
INSERT INTO gdf_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Tǝkǝdla pǝrt, madv Yasu zǝ furakh sar ǝn dǝgal. Ka nǝgha nǝgha tsitar ufa ghǝdive tsa tlapga Yasu a ghulal tangw da tǝ tlǝl. ");
INSERT INTO gdf_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ka dzamana Bitrus, niya kǝ Yasu, “Malǝm, vaza dǝ ufa ghǝdive tsa tlapgakh a ghulkaval.” ");
INSERT INTO gdf_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Ka nggawa tǝrkhai Yasu kwarne, “Famadǝghǝrofǝg dǝ Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Ən tǝkha kura tǝkha kǝ. Itsawar ǝn kwarar khai kǝ ghuɓ nǝ, ‘Dǝg dǝgal, tlǝvdagh tlǝva ghǝra da dǝlv.’ Da bǝga bin dǝ tsugu ǝn rǝvakhuɗ sar bi, a fǝdghǝro tsugun ǝn tǝ dǝge kwargin da dzoghǝr ndzǝg, da manara manud. ");
INSERT INTO gdf_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Wirva yan, ǝn kwara kura kwara kǝ, itsauɗa ǝn takaɗga kur ǝn ɗǝgau, famadǝghǝro fǝg nggwaɗa gǝmadu kur. Da nǝga kǝ dǝgur. ");
INSERT INTO gdf_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Da ghitsaga kur kǝ ɗǝgau, da ka nǝg ude a khutana kur ǝn khuɗur, ɓisatǝrna kur. Ki ziɗa ɓisa kura ɓisa kǝ Dadur ai ǝn gharazhigǝl ad khaipakhur. ");
INSERT INTO gdf_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Ai da ka ɓisana ba kur bi. Ndǝkyan kǝ Dadar ai ǝn gharazhigǝl na ba da ɓisa kura khaipakhur bi. ");
INSERT INTO gdf_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ka guyoghǝr Yasu zǝ furakh sar da Wurshalim, madv Yasu ǝn gwayav ǝn Fǝta Yazhigǝl. Ka sa zikzikan na kǝ zil kǝsakh, zǝ li tsagdu ndzikha ndzikh, zǝ malakha ǝn tǝghǝr kǝ dlam da vak sar. ");
INSERT INTO gdf_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Ka nǝv itar tsin, “Ən mana dǝ ira kǝ ndzǝɗakha dǝ dǝgakhani? War kǝ bakha ndzǝɗa man dǝgakhani?” ");
INSERT INTO gdf_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ka nggawa tǝrkhai Yasu kwarne, “Da ndiɗakurwal ndiɗa ka digit kitakul. Da nggawake kur, ka da kwara kura kwara kǝ ad khulf ndzǝɗe manda ka dǝgakhan. ");
INSERT INTO gdf_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Kwarama ke kwar, para ude tsǝn mana Yukhan, a so ǝn gharazhigǝle awan ǝn vak ud khi?” ");
INSERT INTO gdf_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Ka kwara kava kwara tsitar ǝn tar kwarne, “Da ka ǝn ghǝrazhigǝla, nikiyam,’ Da ndiɗakiyamwal ndiɗa kwarne, ‘Uɗa lava tsukur kwal fadǝghǝro dini?’ ");
INSERT INTO gdf_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","‘Da ka ǝn vak uda, nikiyam,’ Ən gǝdza kiyam kǝ udakh, wirva itsawara a khayanǝf kwarne, Yukhana tlayang Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ka nggawar khai itar kǝ Yasu, “Ən tsa bakǝnda bi.” Ka nǝv Yasu tsitar, “Na ghǝrar ǝn kwara kura khulf ndzǝɗe ǝn manakha da ka dǝgakhan na bi.” ");
INSERT INTO gdf_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Khalakyana, ka farsa Yasu ad kwaratra lava dǝ jakva lav, ni, “Nǝg udanen a tukhgan ad inabi ǝn gukh sar. Ka tsarghǝran dǝ ghǝrgh. Tǝfgan ad fik pǝrts yu inabiyen, ndǝrar khai ad vak uf chaw kǝ dadak uf gukhen. Ən tǝkhal kǝ yana, ka bǝdu ad mbucha gukhen kǝ yakhaya kǝ li wus, ka dakaval da tlǝrna vak. ");
INSERT INTO gdf_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Sa kǝ sarta tsǝg inabi, ka ɓǝlandal ad zǝr tlǝr sar da vak li wus gukhen, kǝ chawardǝghǝr tleva sar ǝn gukhen. ");
INSERT INTO gdf_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Ka vige tara, mbakǝn itar dǝ kǝɗ. Ɓǝlars itar dǝgal dǝ dǝv dliɓ. ");
INSERT INTO gdf_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Ka ɓǝlanǝf ad tlǝrna zǝr tlǝr sar da vak tar, kǝɗǝf itar ǝn ghǝr, ka tsafanǝf itar. ");
INSERT INTO gdf_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Ka gwidǝn ɓǝlanǝf ad tlǝrn zǝr tlǝr, ka kǝɗga itar. Ka gwidǝn ɓǝlanǝf ad yakhaya tsugun zikǝn, mbakǝn itar kǝ yakhay dǝ kǝɗ, kǝɗga itar chalǝm kǝmts. ");
INSERT INTO gdf_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","“Tǝma ud fang a tǝmgan kǝ ude da ɓǝlin, in zǝr sar ai ǝn wayin. Ka ɓǝlandal kǝ dǝg mbas, ni, ‘Da farghǝrfǝg itar kǝ zǝrar.’ ");
INSERT INTO gdf_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“Ka kwarakav khai li wus gukhen ǝn tǝb tar, ‘Auna makajen. Ausǝgam, kǝɗyamga kǝɗ, dǝg wura sara da nǝga kǝ dǝgmar.’ ");
INSERT INTO gdf_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ka viga itar ad zǝr saren kǝɗge tar. Ka tlǝval itar da tǝlg ghǝrgh ad tluvǝgha sar. ");
INSERT INTO gdf_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Uɗa da mana dadak gukh kini? Da saks da khadz li tsa wus gukhen, ka da batra kǝ tlǝrna udakh ad gukh inabiyen. ");
INSERT INTO gdf_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Atsuk a tugwa bakh kur vindzan na kǝ lav Yazhigǝl ai ǝn kwar kwarne, “Kure a ɗuda li khǝg, in kǝ nala kǝ kur khǝga khwaran. ");
INSERT INTO gdf_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Dad Zikan kǝ mangga yan, A nala kǝ dǝg ndawak ǝn diyakh mar tsugun.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Ka gat ɗul vi Yasu kǝ zik zikan na kǝ zil kǝsakh, zǝ li tsagdu ndzikha ndzikh, wirva tsa tsitar kwarne ǝn tǝghǝr tsitar a kwarga Yasu ad jakva laven. Ai ǝn gǝdza itar kǝ dzakhava udakh, ka ɗuwars itara, dakaval itar. ");
INSERT INTO gdf_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ən tǝkhal kǝ yana, ka ɓǝlandal itar ad chalǝm Farisakh zǝ udakh ya Khiridus da vak Yasu, ki zǝɗa viya vi ǝn tǝ dǝva dǝ lave da kwarin. ");
INSERT INTO gdf_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ka sa itar da vak Yasu, nǝv itar tsin, “Malǝm, tsa tsǝkǝnda kwarne dadak jirkh. Itsawar wikitakw ǝn vakagh. Na khǝn bǝg ghal ǝn udakh bi. Ən tsagdu lav Yazhigǝle jir kha kǝ udakh. Kalkale, awana kalkal bakh pǝlara khadam tsǝkǝnda kǝ Kaisari? ");
INSERT INTO gdf_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Pǝla nagh kǝnda pǝl bakh kǝndi? Wirva tsa kǝ Yasu kwarne mbaɗirakh itar. Ka ndiɗatǝrwal ni, “Uɗa lava tsukur ǝn na nggaka dlǝgdi? A nakam kwaɓ dawanen nǝgha nǝgha kǝ” ... ");
INSERT INTO gdf_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Ɓardǝrghǝr itar ad kwaɓen, ka ndiɗatǝrwal, “Vakdiya zǝ ɗakhǝng inǝn tǝfi?” Ka nǝv itar, “Dǝg Kaisar.” ");
INSERT INTO gdf_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ka nǝv Yasu tsitar, “Bamara bǝg kǝ Kaisar ad dǝg Kaisar, kǝ Yazhigǝl tsugun ad dǝg Yazhigǝl.” Ka a ndawatǝrǝf. ");
INSERT INTO gdf_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ka tǝkǝn Sadukiyakh, liye ǝn kwar kwarne na tsiyǝn nggitl bi, sara da vak Yasu dǝ ndiɗ. ");
INSERT INTO gdf_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Nǝv itar, “Malǝm, a vindza kǝnd khai Mus kwarne, da mǝtsǝga zǝrbab sar kǝ udan ɗuwars ad nusar kwal zǝr. Barari wura wura kǝ zǝrbab sar ad widǝgen, kǝ yarkhai zar kǝ zǝrbab saren. ");
INSERT INTO gdf_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Ai nǝg zǝrbabakhen uɗif. Ka ɓu dǝg chak ad nus mǝtsgan kwal zar. ");
INSERT INTO gdf_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Ka ɓu dǝg mits ad widǝgen. Ka mǝtsǝga ghǝr sar tsugun, kwal zǝr. Ndǝkyan kǝ dǝg khǝkhǝrɗ tsugun. ");
INSERT INTO gdf_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Ndǝkvayan kǝ uɗif dagha tar, na ai yakhga zara bi. Kǝ dǝg mbasa, ka mǝtsǝga nusen. ");
INSERT INTO gdf_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Kina fitsa tsiyen nggitla da nǝga kǝ nusǝngini, fatsiye uɗifdagh tara a zǝɓaruwi?” ");
INSERT INTO gdf_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ka nggawa tǝrkhai Yasu, ni, “A zaɗga ba kur bi, fatsiye ǝn tsa ba kur ad kaɗkaɗ lav Yazhigǝla awana ndzǝɗa Yazhigǝl bi. ");
INSERT INTO gdf_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Da tsiyifud ǝn nggitla, na lav zǝɓ nus zǝ bǝdu sǝba bi, da nǝga ndǝk zar ɓǝla Yazhigǝl ǝn ghǝrazhigǝl itar. ");
INSERT INTO gdf_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ai ǝn tǝghǝr kǝ tsiyen nggitla, a tugwa bakh kur ǝn kaɗkaɗe vindzga Mus? Ən tǝghǝr kǝ lave kwararkhai Yazhigǝl ǝn tǝghǝr kǝ ndǝgha kar ǝn suya? ‘Ai ka Yazhigǝl Brahim, zǝ Yazhigǝl Ishaku, zǝ Yazhigǝl Yakub kǝ.’ ");
INSERT INTO gdf_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Yazhigǝl tlamtsakh ba ka bi, dǝg liye dǝ safa kǝ. A mangga kur tleɓ” ");
INSERT INTO gdf_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Fang ǝn tǝb kǝ li tsagdu ndzikha ndzikhe ǝn vak tar, ǝn tsǝnatǝrval tsǝna ad bǝg tsuguwe ǝn mane tar, ka katlgan kwarne a nggawa tǝrkhai Yasu khwaraniyan. Ka ndiɗarwal, “Ən tǝb kǝ ndzikha ndzikh daghan, ira khwaran ǝmbi?” ");
INSERT INTO gdf_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Ka nggawar khai Yasu, kwarne, “Ai khwaran na kǝ ndzikha, in ‘Tsǝnam tsǝn, Udakh ya Izrail. Yazhigǝl Dad Zikan mara, Dad Zikan kitakul. ");
INSERT INTO gdf_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Waya dǝ Dad Zikan Yazhigǝlagh dǝ rǝvakhuɗagh daghan. Dǝ vǝgha daghan. Dǝ mǝkǝnagh daghan. Zǝ ndzǝɗagh daghan.’ ");
INSERT INTO gdf_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Dǝg mitsa in kwarne, “Waya dǝ tlǝghǝrwitǝghagh ndǝkva ghǝragh.’ Na ndzikha ndzikhe malgan ad yakhana bi.” ");
INSERT INTO gdf_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Ka nǝv dadak tsagdu ndzikha ndzikh, kǝ Yasu, “Kalkal dǝge a kwargakha,” uk Yazhigǝl kitakul na tlǝr bi uk inen. ");
INSERT INTO gdf_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Waya dǝ Yazhigǝlen dǝ rǝvagha daghan, zǝ mǝkǝnagh daghan, zǝ daghan ndzǝɗagh, zǝ way tlǝghǝrwitǝghagh ndǝkva ghǝragh. In khwaran tǝghǝr kǝ bara digit kǝ Yazhigǝl zǝ dǝg tsuf.” ");
INSERT INTO gdf_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Vazga kǝ Yasu a nggawar khai kwelemlem, ka niya tsin, “Bita bakh dǝ tlǝksa Yazhigǝl bi.” Ən tǝkhal kǝ yana, na ude a gwidǝn ndiɗarwal bi. ");
INSERT INTO gdf_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Madv Yasu ǝn tsagdutsag ǝn Fǝta Yazhigǝl, ka ndiɗa tsin kwarne, “Uɗa lava kǝ li tsagdu ndzikha ndzikh ǝn kwar kwarne Kristuwa Zǝr Dodi? ");
INSERT INTO gdf_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Wirva Dod dǝ ghǝr sar, ǝn tǝ dǝva dǝ Sǝɗikw Yazhigǝla, a kwargan kwarne, “ ‘Nǝv Dad Zikan kǝ Dad Zikanar. “Ndzǝga ndzǝg ǝn tǝ dǝva kafar khekwa ba ka dǝ li dawagh ǝn kus kǝ sigagh.” ’ ");
INSERT INTO gdf_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Dod dǝ ghǝr sara ǝn ɗakha dǝ ‘Dad Zikan.’ Ka da nǝga ndarin kǝ zǝr sari? Zikǝn dzakhava udakh ǝn tsǝn kǝn tsǝna dǝ khwaɗg. ");
INSERT INTO gdf_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Madv Yasu ǝn tsagdutsaga, ka ni, “Tsukwamana ghǝr dǝ li tsagdu ndzikha ndzikh, li way gwayava dǝ zikzikan kǝ gabag. Ən nagha itar naghatǝrdi nagh zǝ fatǝrghǝrfǝg ǝn tǝ ɓala kasuk. ");
INSERT INTO gdf_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Zǝ batra vǝj khwaran ǝn gud dzakhava Yakhudakh, zǝ vak khwaran ǝn vak khwadg. ");
INSERT INTO gdf_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ən biɗ widǝgakh itar diwa zu dǝgakh tar. Ən zulu zula itar ǝn ɗǝgau, kǝ nǝghatra nǝgha tsud. Khulf yan kǝ udakha da manatra taka lavud char, mal kǝ dǝg yakhaya kǝ udakh. ");
INSERT INTO gdf_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Ən tǝkhal kǝ yana, ka ndzǝga Yasu khefa dǝ vake ǝn bǝduwud ad dǝg buti, ǝn vaz ɗule ǝn ɗida dzakhava udakh ad kwaɓ tar da vake ǝn bǝduwud ad dǝg buti. Zikǝn tluwandalakhe bakhdagh ad kwaɓ tar ɗǝmbǝr. ");
INSERT INTO gdf_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Ai ka sa widǝge talag, ka bǝdagh ad kalami vǝrshakanv mits, ai kwal do dat kwaɓ kitakul. ");
INSERT INTO gdf_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Ka Dakhga Yasu ad furakh sar da vak sar, ka ni, ǝn tǝkha kura tǝkha kǝ, kwaɓe a bǝdagh widǝg na da dǝg ɗi dǝg buti na, a malgan ad dǝg itsawar daghan. ");
INSERT INTO gdf_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Wirva daghan tara khǝɗikǝn a bǝdu itar ǝn zika dǝge din itar. Ai widǝg na ǝn talag sar a bǝduwin ad ɗaga dǝge dinin. ");
INSERT INTO gdf_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Madv Yasu ǝn sǝgawal ǝn Fǝta Yazhigǝla, ka nǝv fang ǝn tǝb kǝ furakh sar tsin, “Malǝm, vaza dǝ ɗigan kurakhana zǝ khwara khǝgakhan.” ");
INSERT INTO gdf_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Ka ngawar khai Yasu kwarne, “Nǝgha tsǝkha adina kǝ khǝgakhana? Na bai da ɗuɗud ǝn tǝ vavak sar bi. Itsera tara da ndaza ndazud.” ");
INSERT INTO gdf_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Madv Yasu ǝn giɗǝn tǝ ghuɓa Oliv, ger dǝ Fǝta Yazhigǝl, ka sa Bitrus, zǝ Yakubu, zǝ Yukhan zǝ Ndros da vak Yasu ɓǝghanyan. ");
INSERT INTO gdf_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Ka nǝv itar, kwara kǝnda kwar, da dzoghǝr yawa ina kǝ digitakhi? Tsugun da zǝk ndǝk uɗa dǝge da nǝghud da da dzoghǝr dǝgakhana daghani?” ");
INSERT INTO gdf_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ka ngawa tǝrkhai Yasu kwarne, “Ɗem nikur khayamanǝf ba valkurdu udan bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Da saks udakh zikǝn ǝn ɗakhar ǝn kwarne ka Yasu. Tsuguna, da valdu vala itar udakh zikǝn. ");
INSERT INTO gdf_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Da tsǝna kur lav ǝn tǝghǝr kǝ pǝga zǝ wilenga sar kǝ pǝg, gǝdzam bi. Wirva barari dzoghǝr dzǝg kǝ yakhen kǝ digitakh. Ai mbasa sara a sa ba ndan bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kǝsa da tsiyara tsiya kǝ tlǝrna kǝs. Tlǝksa da kǝl ghum itar ǝn tǝghǝr kǝ tlǝrna tlǝks. Da man mbǝɗa pǝgdǝmud ǝn vakakh sikh sikh sikh. Da nǝg way tsugun. Daghan yakhana kǝ digitakha, ndazhazha sar bi, farsafǝg sar kǝ dlaɗ. ");
INSERT INTO gdf_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Ka tsukwana kur ghǝr. Da ɓǝkur ɓa itar da vak takalav, zǝ kǝɗ kur kǝɗǝn ǝn vak dzakhava Yakhudakh. Da ɓǝkur ɓud da tǝvuk kǝ maludakh zǝ shikakh wirva ɗakhar, ki kwaratra lav zǝɗan tsukur ǝn tǝvuk tar. ");
INSERT INTO gdf_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Ai kǝda saks kǝ mbasa sara, barari kwardu lav zǝɗan na tsud chak kǝ daghan udakh. ");
INSERT INTO gdf_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Itsa yau ǝn vai kur khai itar zǝ ɓǝkur ɓa da vak taka lav, dzamam ba dǝge da kwara kur bi. Kwaram kwara ba kur dǝge a sakura da mǝkǝnur ǝn tǝ sarten. Wirva kur bǝn kwar lava bi, Sǝɗikw Yazhigǝl ǝn kwaran. ");
INSERT INTO gdf_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Ən tǝ yanen kǝ sarta, da bǝdu zǝrbab ad zǝrbab sar kǝ mǝts, dad tsugunsa da bǝdu bǝg ad zǝr sar. Zara tsugun da tsiyara tsiya tar kǝ yakh tar, zǝva kǝɗtǝr kǝɗa tsitar kǝmts. ");
INSERT INTO gdf_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Da nagh kur ba itsawar wirva ka bi. Ai ɗaga ude a bǝgan ad rǝv da tǝ mbasa, da mbǝladu mbǝla dǝ kat. ");
INSERT INTO gdf_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Da nǝgha nǝgha kur dǝg dzadlakhe, ǝn bazdu Fǝta Yazhigǝl, zǝ udakhe ǝn nenanen, ǝn ghitsǝn tǝ vakvake tsa kalkal ba ghitsa tsin bi, (dakake ǝn tugwado lavana katlga katlin dǝge tukuwin). Ka liye ǝn ǝntla khay ya Yakhudi, barari khwaya tsitar dǝgo da ghuɓakh. ");
INSERT INTO gdf_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ude ǝn ndzǝgan ǝn tǝ ghǝr gud tsuguna, ya so ɓin sǝgadagh da zǝɓ itsauɗ dǝgal ǝn khud mǝgh bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ude ǝn gukh tsuguna, ya guyo bin saks da zǝɓ nura sar bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Da nǝg dlaɗ kǝ nǝghwase dǝ khuɗ, zǝ liye dǝ zǝr ǝn tǝ tukw dǝv, ǝn tǝ yanen kǝ sart. ");
INSERT INTO gdf_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kwam ɗǝgau, dzoghǝr ba khwayana ǝn sarta fagh bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Yǝn tǝ yanen kǝ sarta, da nǝg dlaɗ char, khulfe kwal taɓa tsuɗ manaman. Gwil farsa vǝrɗ lard, tangw da tǝ ina kǝ sart. Aghbud da gwidǝn man khulf sar kǝ yanen bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","“Da tsa khǝtsana bud ad khǝnakhen bi, tsa na ud dǝg sige da tǝma dǝ safa bi. Ai wirva li dzǝran na kǝ udakh Yazhigǝl, da khǝtsa khǝtsa Yazhigǝl ad khǝnakhen. ");
INSERT INTO gdf_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Ən tǝ yanen kǝ sarta, da ka nǝv udan tsukur, ‘Vaza, auna Kristu ǝn van’ awana, ‘A niya ǝn vin’ ya khayamanǝf bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Wirva Kristu filfilakh zǝ tlayang filfilakh da sakhgawal itar. Da manakh zik zikan na kǝ jakvakh, zǝ zik zikan na kǝ dǝg ndawakakh itar kǝ valdu udakh. Da tsa tǝkhin kǝ manawan, da valdu vala itar zǝva liye a dzǝrtǝkhai Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Wirva yana, ɗem nikur, a kwara kur khai ka itsauɗǝn sart. ");
INSERT INTO gdf_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Ən tǝ yanen kǝ khǝnakha, ǝn tǝkhal kǝ dzoghǝr dzǝg kǝ dlaɗakhen, “ ‘Ka da nǝga fatsi kǝ gurtl. Tǝl tsuguna naba da kheɗaɗ bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","Kwadladlakh tsuguna ka da ɓaloɓalǝn Sǝgadagh ǝn tǝ fef gharazhigǝl. Da gǝdiya gǝdyud ad ndzǝɗakhe Ən fǝf gharazhigǝl.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","“Da mǝdlo ǝn tǝ yanen kǝ sart jakva Zǝr Ud ǝn tǝ fef gharazhigǝl, ǝn sǝgadagh ǝn ghwik, dǝ ndzǝɗa zǝ ndanga char. ");
INSERT INTO gdf_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Da bǝlondagh ɓǝla dǝ zarɓǝlakh sar, kǝ dzakha dzǝran na kǝ udakh sar, ǝn tǝ kalam lard daghan. Tsiyif ǝn tǝ yan kǝ kalam lard, da tǝ yan kǝ kalamakh. ");
INSERT INTO gdf_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Tsagam tsaga digit dǝ ufa ghǝdiv. Da farsin ɗidu tlim kǝ ɗado wilwa tlim, ǝn tsatsǝg kur kwarne a khǝrzǝga vi. ");
INSERT INTO gdf_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ndǝk yan tsugun, da nǝgha tsukur dǝgakhan ǝn dzoghǝr dzǝg. Tsa tsukur kwarne, a khǝrzǝgan, ǝn tǝ ghay gud. ");
INSERT INTO gdf_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Ən tǝkha kura tǝkha kǝ, udakh kwargǝn, da ruga ba itar bi, khekwa dzoghǝr dǝgakhana daghan. ");
INSERT INTO gdf_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Gharazhigǝl zǝ khaya da nige tar. Ai lave ǝn sǝgawal ǝn ghayara na bai kwal da righa bi.” ");
INSERT INTO gdf_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Na ude ǝn tsa khǝna zǝ sart bi, itsa zarɓǝlakhe ǝn gharazhigǝl, itsa Zǝren, uk Dad kitakul ǝn tsan. ");
INSERT INTO gdf_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ɗem nikur, ɗikfǝkhe kur, wirvǝn tsa bakur sarte da sǝgadaghin bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ndǝk ude da dǝgal da tlǝrna kǝs. Madvin ǝn ɗuwada mǝgha, batrǝm ad tlǝr ǝn dǝv kǝ li man tlǝr sar. Ka kwarar khai ak itsera kǝ zǝr tlǝr ad tlǝre da manin, ka kwarar khai kǝ dadake ǝn uf mǝgh ad giɗa ɗem. ");
INSERT INTO gdf_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Wirva yan, ɗem nikur, wirvǝn tsa bakur sarte da guyo dad mǝgh bi. Itsa kǝ khakhuga awana ǝn tǝb viɗ, itsa tǝkǝdla pǝrt awana kǝ fatsi tǝghǝr. ");
INSERT INTO gdf_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Da soghǝrin dzagwdlam, tlakurghǝr bin ǝn khǝnkhar bi. ");
INSERT INTO gdf_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Dǝge ǝn kwara kura ka, ǝn kwarara kǝ itsawar kǝ. Ɗem nikur. ");
INSERT INTO gdf_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Tǝmga khǝna mits kǝ khwaɗga ɗitsaɗits ai ǝn kwarud dǝ khwaɗga brudiye kwal yist. Ka gat ɗul vi Yasu kǝ zik zikan na kǝ zil kǝsakh, zǝ li tsagdu ndzikha ndzikh ɓǝghanyan, kǝ kǝɗa kǝɗa kǝmts. ");
INSERT INTO gdf_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Ai ka nǝv itar, “Na kiyam da viya viya fitsa khwaɗga bi, wirva da tsiya gadla udakh.” ");
INSERT INTO gdf_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Madv Yasu ǝn kǝs Betani, ǝn zu kaf ǝn fǝta Bitrus ai tsa ndzikǝn fǝch. Ka saks kǝ nusen dǝ wal bǝtbǝtan ǝn khatakw ai dzaw gan ǝn tǝf. Ka nguranǝf ad khatakwa, ka ɗiyarǝm ad wal bǝtbǝtanen ǝn ghǝr kǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Ka bazala rǝv kǝ chalǝm udakhe ǝn vin. Ka nǝv itar kǝ itsawar, “Uɗa lava tsin ǝn bazdu wal bǝtbǝtan ai dzaw gan ǝn tǝf ndǝkini? ");
INSERT INTO gdf_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Azǝgha tsa sukwdu ud, tsa gǝmaduwud kwaɓ mal kǝ kwaɓe ǝn pǝlarud kǝ dadak tlǝr ǝn vǝg, ka batrud ad kwaɓ sar kǝ talagakh.” Ka tavarghǝr itar di kǝ nusen char. ");
INSERT INTO gdf_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ka nǝv Yasu tsitar, a ɗuman ad nusǝn “Uɗa lava tsukur ǝn njǝgharu njǝghi? A manakai ad dǝg khwaran. ");
INSERT INTO gdf_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Tsika fatsiya da kur zǝ talagakh. Tǝkha kur kǝ mǝlatru ǝn tǝ itsera kǝ sarte ǝn na kur. Ai ka, da dagh ba kiyam zǝ kur tsika fatsi bi. ");
INSERT INTO gdf_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","A mangan ad khalavuwa dǝge a mangin. A ɗiyo ad wal bǝtbǝtan an tǝ vǝghar, ki da ɗika kǝ khǝɗa ka da khǝɗ. ");
INSERT INTO gdf_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Ən tǝkha kura tǝkha kǝ, itsa da kwardu ǝn varud lav zǝɗa kǝ tsǝna nǝn, ǝn lard daghan, dǝgǝn na manga nusna da kwardu kwarud ki da dzama da dzam.” ");
INSERT INTO gdf_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ka dala Yakhuda Iskariyoti kitakul ǝn tǝb kǝ furakh Yasu kǝlatǝm mits, da vak zik zikan na kǝ zil kǝsakh, kǝ batǝrdu Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Tsǝna tsitar ad yana ka zǝɗatru char. Ka manarkhai itar lanji da bara kwaɓ. Ka farsa Yakhud ad gat ɗule da batǝrduwin ad Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Fitsa chak kǝ zu brudiye kwal yisti, fitsa khǝr mbaklak khwaɗga ɗitsaɗits. Ka ndiɗarwar furakh sar kǝ Yasu, kwarne, “Ən varǝn nakha da ɗikakhana kǝnda vake da zu dakha kaf ɗitsaɗitsi?” ");
INSERT INTO gdf_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ka ɓǝlanǝf Yasu ad furakh sar mits, niya tsitar, “Dam daks da dlǝmdla kǝs, da gama kur zǝ ude ǝn ɓa shuguda yu. Gatams gat. ");
INSERT INTO gdf_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Da daghin da mǝgh, ka nikur kǝ dadak mǝgh, nǝv malǝm, “Mǝdla kǝnda mǝdla dǝ gude da zudin kaf ɗitsaɗitsa zǝ furakh sar’ ");
INSERT INTO gdf_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Da mǝdlakura mǝdla dǝ zikan kǝ gud lind, ai udzalud ɗikana ɗika kǝ khwaɗg. Ɗikama kiyamana dǝg zuwun vin.” ");
INSERT INTO gdf_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Ka dala furakhen da dlǝmdla kǝsa, tlarghǝr itar kǝ digitakh, ndǝkve tsa kwara tǝrkhai Yasu. Ka ɗikana itar ad dǝg zuwa khwaɗga ɗitsaɗits. ");
INSERT INTO gdf_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Ɓǝlga kǝ khagwa, ka sagh Yasu zǝ furakh sar kǝlatǝm mits da mǝghen. ");
INSERT INTO gdf_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Madv itar ǝn zu kaf, ka nǝv Yasu tsitar, “Ən tǝkha kura tǝkha kǝ, kitakul ǝn kur, ai ǝn zuwa kaf zǝ kǝ, da bǝkdu bǝg.” ");
INSERT INTO gdf_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Ka bazala rǝv tsitar char. Ka nǝv itar tsin dǝ kitakw kitakw, “Ka nagha?” ");
INSERT INTO gdf_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ka nggauga Yasu kwarne, “Kitakul ǝn kur kǝlatǝm mits na, ude ǝn zuwa kǝnda kaf ǝn kwat kitakul. ");
INSERT INTO gdf_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Da ǝmtsa Zǝr Ud ndǝkve a vindzǝgud ǝn tǝghǝr tsin. Ai ya ɗangwa kǝ ude da bǝdu Zǝr Ud. Adara tsa yiga bu dǝ yanen kǝ ud bi.” ");
INSERT INTO gdf_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Madv itar ǝn zu kaf, ka ɓǝf Yasu ad brudi, kwarar khai ad us kǝ Yazhigǝl, ka kwachanan. Batran kǝ furakh sar, niya tsitar, “Chawam chaw, vǝgharen.” ");
INSERT INTO gdf_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ka ɓǝf ad kwate dǝ yu inabi, kwarar khai dǝ us kǝ Yazhighǝl. Ka batran, daghan tara ka khǝɓaru. ");
INSERT INTO gdf_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ka nǝv Yasu tsitar, “Ina vizhar dǝg lanji, ai ɗiduwud kǝ wirva udakh zikǝn.” ");
INSERT INTO gdf_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Ən kwara kura kwara kǝ, aghba ka da khǝɓ yu inabi bi, akwa sarte da khǝɓa ka tlǝrna wilwan sar kǝ yu inabi ǝn tlǝksa Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ɓǝlga kǝ Yasu zǝ furakh sar ad ndusa. Ka sawal itara, dal itar da tǝ ghuɓ Oliv. ");
INSERT INTO gdf_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ka nǝv Yasu tsitar, “Daghanura da khwaya kur dǝgal, da ɗukda ɗuwa kur. Wirva vindzan kwarne, “ ‘Da kǝɗga kǝɗa kad dadak zighw, Giɗa tuwagha da kwaza itar.’ ");
INSERT INTO gdf_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Ai ǝn tǝkhal kǝ tsiyif tsiya tsǝkǝn ngitl, kǝn da dala tǝghǝr tsukur da khaya Galili.” ");
INSERT INTO gdf_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Ka nǝv Bitrus kǝ Yasu, “Itsa kwazga itar daghan, na ka da ɗuwakhs ɗuwa bi.” ");
INSERT INTO gdf_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Ka nǝv Yasu kǝ Bitrus, “Ən tǝkha kha tǝkha kǝ, ǝn khuɗ viɗ khan, kǝda wuga kǝ ghwachik sig mits, da bǝg tsugu tsakatsǝg kha sig khǝkǝrɗ.” ");
INSERT INTO gdf_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Ka gwidǝn Bitrus ad khwarar kwara kwarne, “Itsa da ǝmtsa ki dagh, na ka da bǝg tsugu tsakhatsǝg bi.” A kwarakhga ndǝkyan chalǝm furakh sar daghan. ");
INSERT INTO gdf_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ən tǝkhal kǝ yana, ka dala Yasu dagha zǝ furakh sar da tǝ vaken ai ɗakhdud Gatsamani. Ka niya tsitar, “Ndzamga ndzǝg ǝn van, dǝgal da ɗǝgawa kǝ.” ");
INSERT INTO gdf_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ka ɗaghga Yasu ad Bitrus, zǝ Yakub, zǝ Yukhan dǝgal dagha zin. Ka soghǝr bazala rǝv zǝ dzamghǝr kǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Ka niya tsitar, “Rǝvara righan da baza rǝv, ai da tǝgh kǝ kǝɗkai. Giɗam giɗa ǝn van, ɗem nikur.” ");
INSERT INTO gdf_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Dal tsin da tǝvuk khǝɗikǝn, ka khǝmbǝgan dǝ khuɗ khuɗ, ka ɗǝgawa tsin kwarne, da tǝkhin kǝ manawan, ɓakghǝr ɓud ad ina kǝ sarta dlaɗ. ");
INSERT INTO gdf_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Ka ni “Dada, itsauɗa ǝn manawa man ǝn vakagh. Tsa ɓakghǝra kha dǝ ina kǝ dlaɗ. Tsakhǝnmina, dǝge ǝn na ka ba da manud bi, ai dǝge ǝn nakh.” ");
INSERT INTO gdf_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Guyoghǝr kǝ Yasu da vak furakh sarna khǝkǝrɗ, ka tlatǝrghǝr ǝn khǝn khar. Ka niya kǝ Bitrus, “Siman ǝn khǝn khar kura? Atsuk tǝgh bakh kur kǝ manga ɗǝm, kǝ dǝg aw kitakula? ");
INSERT INTO gdf_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ɗem nikur zǝ man ɗǝgau, ki khek da ɓǝla tsukur da kura. Sǝɗikwa, ǝn nagha dǝ man tlǝr kwaran, ma vǝgha a khǝtsaru ndzǝɗ.” ");
INSERT INTO gdf_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Ka gwidǝn dala da ɗǝgau kǝ dǝg mits, ka gwayars kǝ ɗǝgawe tsa chak.” ");
INSERT INTO gdf_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Gwiyoghǝr tsin saks da vak furakh saren, ka tlatǝrghǝr ǝn khǝn khar, wirva khar ǝn di tsitar char. Wirvǝn tsa ba itar ad dǝge da kwarara itar bi. ");
INSERT INTO gdf_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Ka dala, gwiyoghǝr kǝ dǝg khǝkǝrɗ da vak furakh saren, ka niya tsitar, “Dlakh kur ǝn khǝn khar zǝ fǝtava? A tlal, vazam vaz, a sagh sarte da bǝduwud Zǝr Ud, da dǝv kǝ li khaipakh. ");
INSERT INTO gdf_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tsiyam tsi, ndziyam dǝgal. Auna dadake da bǝkdu bǝg a sagh.” ");
INSERT INTO gdf_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Madv Yasu dlǝn kwar lav, ka sagh Yakhud ai kitakul ǝn tǝɓ kǝ kǝlatǝm mits, dagha zǝ dzakhava udakh zikǝn. Khwatan katsakarakh zǝ yaghwatakh ǝn dǝvakh tar. Zikzikan na kǝ zil kǝsakh, zǝ malanakh ǝn tǝghǝr kǝ udakh kǝ ɓǝlatǝrǝf. ");
INSERT INTO gdf_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Yakhud dadak bǝdu bǝgena, audzala kǝbits tǝrkhai kǝbitsa kǝ dzakhava udakhen kwarne, “Dadake da bruwa ka, in udanen, viyam viyǝn dǝgala, khutana kur char.” ");
INSERT INTO gdf_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Sa tsitara, ka dala Yakhud ger da vak Yasu. Ka ni, “Malǝm, ka bru Yasu tsin. ");
INSERT INTO gdf_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ka viga udakhen ad Yasu. Khutana itar char. ");
INSERT INTO gdf_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Ka ndǝɗadal fang ǝn tǝb kǝ liye ǝn ghitsgan ǝn vin ad katsakar sar. Ka tsaɓgan ad vǝɓ ndangan kǝ zil kǝs, ǝntlardu ad tlim. ");
INSERT INTO gdf_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Ka ndiɗatǝrwal Yasu, kwarne, “Sǝnkarakh khǝka, ǝn sǝgawal kur dǝ katsakarakh zǝ yaghwatakh da vika viya? ");
INSERT INTO gdf_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Tsika fatsi da ka zǝ kur ǝn tsagdutsag ǝn Fǝta Yazhigǝl, a vikai ba kur bi. Ai manava kǝ righda dege a vindzgud ǝn kaɗkaɗ Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Ka khwayala furakh sar daghan, ɗuwars itar. ");
INSERT INTO gdf_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Ka nǝg dakhalen a gatars kǝ Yasu, na gabag ǝn tǝvǝgh tsin bi, uk lǝgwit khǝngan. Tsǝn nagha itar ad viya vi, ");
INSERT INTO gdf_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ka ngǝdlgan ǝn vak tar. Khwayal dǝgal kwal kadlang ǝn tǝ vǝgha sar. ");
INSERT INTO gdf_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ən tǝkhal kǝ viga viya kǝ dzakhava udakhen ad Yasu, ka ɓal itar da vak ndangan kǝ zil kǝs. Ka dzafkhe zik zikan na kǝ zil kǝsakh, zǝ malanakh ǝn tǝghǝr kǝ udakh zǝ li tsagdu ndzikha ndzikh ǝn vak kitakul. ");
INSERT INTO gdf_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","A gatars Bitrus kǝ Yasu tsugun kǝ tsub, tangw da tǝ gǝlvakh ndangan kǝ zil kǝs. Ka ndzǝgan ǝn vin da zǝ li uf udakh, ǝn ɗir kar. ");
INSERT INTO gdf_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Zik zikan na kǝ zil kǝsakh zǝ daghan li taka lav, ǝn gat udakhe da ǝntlarva lav fila fila kǝ Yasu itar, kǝ nǝghda kǝɗga kǝɗa tsitar. Ai ka mbǝladu ba itar bi. ");
INSERT INTO gdf_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Tsakhǝnmina zikǝn udakhe a sarawal kǝ ngatlarva fil. Ai fila tara a dzǝf bǝn tǝ dǝva kitakw bi. ");
INSERT INTO gdf_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Ka tsiyif yakhaya kǝ udakh, ka kwarga itar ina kǝ fil ǝn tǝghǝr kǝ Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“A tsǝna tsǝkǝnda ina kǝ ud ǝn kwar kwarne, ‘Tǝkha ka kǝ khǝtana Fǝta Yazhigǝl nǝ ai ndǝrga udakh. Ka ndǝrga ka tlǝrn ǝn khǝna khǝkǝrɗ. Ai ud ba da ndǝran bi.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Tsakhǝnmina, fila tara dzǝf bǝn tǝ dǝva kitakw bi. ");
INSERT INTO gdf_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ka tsiyif ndangan kǝ zil kǝs ǝn tǝvuk tar. Ka ndiɗarwal kǝ Yasu kwarne, “Na kha dǝ lave tǝkhakha kǝ kwargan ǝn tǝghǝr kǝ lave ǝn kwara itar ǝn tǝghǝr tsǝkha?” ");
INSERT INTO gdf_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","A mbǝɗa ba Yasu ad khay bi. Ka gwidǝn ndiɗarwal ndangan kǝ zil kǝs kǝ Yasu tsugun, “Kha khǝ Kristu, Zǝr Yazhigǝl dadak barka?” ");
INSERT INTO gdf_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Ka nǝv Yasu tsin, “An nǝv Yasu, da nǝgha nǝgha kur Zǝr Ud ǝn ndzǝgan ǝn tǝ dǝva kaf Dadak Ndangan daghan, zǝ sǝgdagh ǝn ghwik ǝn gharazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Ka kwakhdu ndangan kǝ zil kǝs ad katlang sar. Ka ndiɗatǝrwal, “Uɗa dla lava tsǝkiyam ǝn gat tlǝrna shidakhi? ");
INSERT INTO gdf_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","“A tsǝna tsukur ad nena Yazhigǝle a mangin. Uɗa ɗayaghǝruri?” Ka nǝv itar, “Khwaran sara kǝɗgud.” ");
INSERT INTO gdf_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ka tafarva chalǝm udakh ad shaghwvai kǝ Yasu, mbusar khai itar ad vak di, ka kǝɗǝf itar. Ka nǝv itar, “Kwara kǝnda lav tlayang tlayang, war kǝ kǝɗfǝkhe?” Ka ɓala li uf udakha, ka kǝɗǝf itar. ");
INSERT INTO gdf_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ən tǝkhal kǝ yana, madv Bitrus ǝn ndzǝgan ǝn tǝ gǝlvagh mǝghen, ka sagh dugh kuɗig ndangan kǝ zil kǝs da tǝ gǝlvaghen. ");
INSERT INTO gdf_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Nǝgha tsin ad Bitrus ǝn ɗir kar, ka vazarvar char. Ka ni “Ghǝragha da kur zǝ Yasu ud Nazarat nǝ.” ");
INSERT INTO gdf_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Ka bǝg tsugu tsin. Ka ni, “Ən tsa ba ka dǝge ǝn kwara kha lavǝn tǝghǝr bi.” Ka dala da tǝ ghay rang. ");
INSERT INTO gdf_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Ka gwidǝn nǝgha nǝgh kǝ dugh kuɗigen ad Bitrus ǝn vin, ka niya kǝ udakhe ǝn ghitsǝn vin tsugun, “Ina kǝ uda, kitakul ǝn li dagha zǝ in.” ");
INSERT INTO gdf_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Ka gwidǝn bǝg tsugu kǝ Bitrus. Zula khǝɗikǝna, ka nǝv liye ǝn ghitgan ǝn tǝvǝgh kǝ Bitrus, “Kaɗkaɗiya ghǝragha fang khǝn tǝb tar, wirva ud ya Galili khǝ.” ");
INSERT INTO gdf_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ka farsa Bitrus ad tlap ghǝr sar, zǝva waɗatra waɗa tsin kwarne, “Ən tsa ba ka dǝ udan nǝn kwara kur lavǝn tǝghǝr bi.” ");
INSERT INTO gdf_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Tǝvin tǝvin ka wuga ghwachik kǝ dǝg mits. Ka dzamana Bitrus ad lave tsa kwararkhe Yasu, kwarne, “Kǝda wuga kǝ ghwachik kǝ dǝg mitsa, da bǝg tsugu tsatsǝgarakha sig khǝkǝrɗ.” Ka tuwa tsin char. ");
INSERT INTO gdf_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pǝrta kǝdl, zikzikan na kǝ zil kǝsakh zǝ malanakh ǝn tǝghǝr kǝ li tsagdu ndzikha ndzikh, zǝ daghan malanakhe ǝn tǝghǝr kǝ dlam, ka ɗaykavu itar dzanak. Ka nguɗana itar Yasu, ɓala itar da tǝvuk kǝ Bilatus. ");
INSERT INTO gdf_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Ka ndiɗarwal Bilatus kwarne, “Kha nagh shik ya Yakhudakha?” Ka nggawar khai Yasu kwarne, “An ndǝkve kwargakh.” ");
INSERT INTO gdf_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Ka kwarakh lavakhe a ngatlarva udakh kǝ Yasu, a zikzikan na kǝ zil kǝsakh. ");
INSERT INTO gdf_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Ka gwidǝn ndiɗarwal Bilatus kǝ Yasu kwarne, “Na khǝn mbǝɗa ghay ǝn tǝghǝr kǝ dǝgakhe a ngatlakhve tara? ");
INSERT INTO gdf_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Ai tsuguna a gwidǝn ba Yasu mbǝɗa ghay bi, ka ndawanǝf ad Bilatus. ");
INSERT INTO gdf_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Dǝge a kuyala shik ǝn mana man ǝn sarta khwaɗga ɗitsa ɗits. Ən ɓǝlars ud kitakul ǝn gud sal, ai ɗauga udakh kǝ ɓǝlars ɓǝl. ");
INSERT INTO gdf_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ən tǝ yanen kǝ sarta nǝg udanen ɗakha sar Barabas nguɗan ǝn gud sal, dagha zǝ li tsaya gadle, kǝɗga ud ǝn sarte tsa tsiyanǝf itar gadl. ");
INSERT INTO gdf_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Sa kǝ dzakhava udakha, ka farsa itar ad takaɗ Bilatus, kǝ ɓǝlatǝrnars ud kitakul ǝn gud sal ndǝkve tsa kuyalin. ");
INSERT INTO gdf_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ka ndiɗatǝrwal Bilatus kwarne, “Ən na nagh kur ɗuwakurnǝs ka dǝ shik ya Yakhudakha?” ");
INSERT INTO gdf_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Tsa kǝ Bilatus kwarne wirva silg a bardǝghǝr zikzikan na kǝ zil kǝsakh ad Yasu da vak sar. ");
INSERT INTO gdf_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Ai ka shakanǝf zikzikan na kǝ zil kǝsakh ad udakh kǝ kwar kwarne, ɓǝlars ɓǝlin Barabas, ǝn dleva Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ka gwidǝn ndiɗatǝrwal Bilatus kwarne, “Ai uɗa da mana ka dǝ ude ǝn ɗakha kur dǝ shik ya Yakhudakhi? ");
INSERT INTO gdf_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Ka tlǝkha tsitar kwarne, “Khǝrtga khǝrtud.” ");
INSERT INTO gdf_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ka ndiɗatǝrwal Bilatus, “Wirva uɗi? Uɗa ghaze manggini?” Ka gwidǝn tlǝkha tsitar kwarne, “Khǝrtga khǝrtud.” ");
INSERT INTO gdf_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Fatsiye ǝn nagh ba Bilatus ad bazatǝrdu rǝv bi, ka ɓǝlatǝrnars ad Barabas. Ən tǝkhal kǝ ba udakh tsin da dlagharu kiɓ kǝ Yasuwa, ka batran kǝ khǝrtga khǝrta tsitar. ");
INSERT INTO gdf_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Ka ɓala tlujiyakh ad Yasu da tǝ gǝlvakh Gumn ai ǝn ɗakhdud (Firitoriyum.) Ka dzanǝf itar dakwal tlujiyakh daghan. ");
INSERT INTO gdf_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","Ka talarǝm itar gabag shalaraz ndǝkva dǝg shikakh. Faɗarkhai itar ad dzakw tak, ka barǝm itar ǝn ghǝr. ");
INSERT INTO gdf_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Ka farsa itar ad nǝghardi nǝgha kwarne, “Dǝg safagh da tǝ uragh, shik ya Yakhudakh.” ");
INSERT INTO gdf_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ka farsa itar dlaghara yaghwat ǝn ghǝr, tafarve tar shaghwvai. Kalga itar juguv ǝn tǝvuk sar, ǝn manara ɗaba nen itar. ");
INSERT INTO gdf_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Udzala tsitar ǝn manara nena, ka sǝkhardo itar ad gabag shalaraz ai tsa talarǝm itar, ka talarǝm itar ad gabag sar. Ka ɓala itar da mel kǝ khǝrta khǝrt. ");
INSERT INTO gdf_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Madv itar ǝn tǝghǝr kǝ dǝga, ka gamga itar zǝ udanen ǝn dǝgal ɗakha sar Siman, ud ya Sayirin, dad Alekzanda zǝ Rufus ǝn saks ǝn dlǝdla kǝs. Ka barghǝr itar zǝɓ ufa khǝrt Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Ka ɓala itar ad Yasu da tǝ vaken ǝn ɗakhdud dǝ Golgot, (“Dǝge ǝn tukuwin in kwarne, “Vak tlatl ghǝr”). ");
INSERT INTO gdf_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Ka bara itar ad yu inabi laɓan dǝ mur. Ai ka kalwal kǝ khǝɓa khǝɓ. ");
INSERT INTO gdf_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Ka khǝrtge tar. Ka taku itar gabag sar ǝn tatak tar, ka tlǝv tsats tsitar ǝn tǝf kǝ nǝghda dǝge da gǝmadu itsawar. ");
INSERT INTO gdf_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ən tǝ kalkal karfi vaslambaɗ tǝ kǝdl a khǝrtga itar Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Vindzga itar ad lav file a ngatlva itar ǝn tǝ vak ghǝr tsin kwarne, “SHIK YA YAKHUDAKH.” ");
INSERT INTO gdf_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ka khǝrtga itar sǝnkarakh mits zin. Fang ǝn tǝ dǝva kaf sar, fang tsuguna ǝn tǝ dǝva dleɓ sar. ");
INSERT INTO gdf_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ina righa sar kǝ lav tlayang tlayang ai ǝn kwar kwarne, “A tǝgwanǝfud ǝn liye mangga khaz.” ");
INSERT INTO gdf_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Udakhe ǝn dǝgala, tsǝn kwarakh lav nen itar, ǝn ngǝts ghǝr itar, ǝn kwar kwarne, khe da khǝtana Fǝta Yazhigǝl, ka ndǝrga khǝn khǝna khǝkǝrɗ. ");
INSERT INTO gdf_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","Kata dǝ ghǝragh dǝ sǝgadagh ǝn tǝ ufa khǝrt. ");
INSERT INTO gdf_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ndǝkiyan tsugun a nenena zikzikan na kǝ zil kǝsakh zǝ li tsagdu ndzikha ndzikh Mus ad Yasu ǝn kwar kwarne, “A katgan ad yakhay, a tǝkh ba kǝ katga ghǝr sar bi. ");
INSERT INTO gdf_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Da ka Kristuwin kaɗi, sodagh sǝgin ǝn tǝ ufa khǝrta na tǝkhin, ki da nǝgha nǝgha tsǝkǝnda, ka khayanǝf kǝnd.” Sǝnkarakhe khǝrtǝgud zina, ghǝtar tsuguna a kwarar khai itar lav ɗekh ɗekhan. ");
INSERT INTO gdf_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ən tǝ fatsi tǝghǝr, ka khǝɗaru gurtl ad khay daghan, tangw da tǝ karfi khǝkǝrɗ kǝ fatsi khakhug. ");
INSERT INTO gdf_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ən tǝ kalkal karfi khǝkǝrɗena, ka tlǝkha kǝ Yasu dǝ ndzǝɗa char, kwarne, “Eloi, Eloi, lama sabaktani?” (Dǝge ǝn tukuwin in, Yazhigǝlara, Yazhigǝlara, a ɗukde ndar kha ndikini?” ");
INSERT INTO gdf_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Tsǝna kǝ yakhaya kǝ udakh ǝn ghitsǝn tǝvin ad yan. Ka nǝv itar, tsǝnam tsǝn, ǝn ɗakh Ili tlayang.” ");
INSERT INTO gdf_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ka kwayala fang ǝn tǝb tar, ka lubanan ad soso dǝ yu inabi kwarekrekan, siɓo ǝn tǝ uf, ka talaro kǝ Yasu kǝ khǝɓa khǝɓ. Ka ni, ɗuwama da ɗuwa ndan, wazyam vaz, ma sǝgadagh Ili tlayang da zǝɓadagh zǝɓ.” ");
INSERT INTO gdf_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Ka tlǝkh kǝ Yasu dǝ ndzǝɗa char, ka gǝlf niya ɗiga safa sar kǝ dǝg mbas, ka mǝtsgan. ");
INSERT INTO gdf_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Ka kukhum lǝgwit ghay gude Fǝta Yazhigǝl mits, tsiyif tǝ vak ghǝr da tǝ khay. ");
INSERT INTO gdf_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Nǝgha kǝ tlujiye ǝn ghitsǝn tǝ vin ad mǝtsa Yasu, ka ni, “Kaɗiya, udan na Zǝr Yazhigǝl.” ");
INSERT INTO gdf_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Ghitsga yakhaya kǝ nǝghwasa kǝ bit ǝn vazavaz. Ən tǝb kǝ li khitsena nǝg Maryam Magdali, zǝ Maryam bab Yakub ai khǝɗikan, zǝ Yusuvu, zǝ Salomi. ");
INSERT INTO gdf_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Yakhana kǝ nǝghwas ai tsa gatars kǝ Yasu saks ǝn ǝn Galili, ǝn nǝgharu nǝgh. Zikǝn nǝghwas a sara zin ǝn Wurshalim, ǝn vin tsugun. ");
INSERT INTO gdf_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Daghan ina kǝ digita a dzoghǝr ǝn tǝ fitsa ɗika digitakh kǝ udakh. Khǝna kǝda fitsa nggi. Ɓǝlga kǝ khagw ");
INSERT INTO gdf_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","Ka sa udanen ai ɗakha sara Yusuvu ud ya Arimati. Kitakul ǝn li taka lav, ghǝr sara kitakul ǝn tǝb kǝ liye ǝn gwit tlǝksa Yazhigǝl. Ka da da vak Bilatus kwal dǝ gǝdz kǝ takaɗ tlu vǝgh Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Ka ndawanǝf ad Bilatus tsǝna tsin kwarne a mǝtsga Yasu. Ka ɗakhgan ad tlujiyen kǝ ndiɗarwal ndiɗa kwarne, kaɗi nagh a mǝtsga Yasuwa? ");
INSERT INTO gdf_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Ndazhana tsin ǝn tǝ ghay kǝ tlujna, ka baran ad tlu vǝgh Yasuwen kǝ Yusuvu. ");
INSERT INTO gdf_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Ka sukwadǝghǝr Yusuvu ad lǝgwit kǝlpakan, zǝɓadagh ad tlu vǝgha Yasu ka mbusanan ǝn kǝlpakanen, ka bǝm ǝn nggitle a tǝfgud ǝn khurzǝz. Ka tlǝgadagh ad gil, khǝɗaru ad nggitlen. ");
INSERT INTO gdf_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","A nǝgha kǝ Maryam Magdali, zǝ Maryam bab Yusuvu ad vake bava tlu vǝgh Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Ən tǝkhal kǝ khǝna fitsa fǝtav. Ka sukwadǝghǝr Maryam Magdali, zǝ Maryam bab Yakub, zǝ Salomi, ad tǝrshin bǝtbǝtan kǝ masara kǝ vǝgha Yasu. ");
INSERT INTO gdf_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Pǝrta kǝdl fitsa khǝna dǝg chak kǝ fǝtav, dǝ gwisǝl, madv itar dǝgal da vak nggitla. ");
INSERT INTO gdf_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ka ndiɗakava tsitar ǝn tǝbtar kwarne, “Ware kǝ da tliga kiyamdu kur ǝn tuk nggitleni?” ");
INSERT INTO gdf_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ai vazo tsitar dǝgo, ka nǝgha itar kuren, na bakha kǝ zika bi, a audzalud ǝn tlǝgarwal tlǝg. ");
INSERT INTO gdf_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Da tsitar da nggilten. Ka nǝgha nǝgha tsitar dakhwal zeren ǝn ndzǝgan ǝn tǝ kalam dǝva kaf ǝn lǝgwit maɗakw. Ka gǝdzif itar. ");
INSERT INTO gdf_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ka niya tsitar, “Gǝdzam bi. Ən gat Yasu ud Nazarat kur, ai khǝrtavan. A tsiyif aghbǝn vana bi. Nǝghama nǝgha vake tsa khǝnanud. ");
INSERT INTO gdf_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Ai damdǝgal kwaramar tǝrkhai kwara kǝ furakh sar zǝ Bitrus, ‘In da dala tsitar da Galili. Da nǝghan vin itar, ndǝkve tsa kwara tǝrkhayin.’ ” ");
INSERT INTO gdf_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Ka khway tsitar dǝgal ǝn nggitlen, dǝ gǝdzǝf ǝn tǝga vǝgh titar. A kwararkhai bai tar dǝge dzoghǝr kǝ itsawar bi, wirvǝn gǝdze tar. ");
INSERT INTO gdf_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Tsiyif kǝ Yasu ǝn nggitl tǝkǝdla pǝrt fitsa khǝna fǝtav. Ka mǝdlawal chak kǝ Maryam Magdaliye, a zǝɓardalin sǝɗikw bǝzan uɗif ǝn vǝgh. ");
INSERT INTO gdf_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ka dala kwara tǝrkhai kǝ furakh sar, zǝ liye baza rǝva zǝ tu. ");
INSERT INTO gdf_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Tsǝna tsitar kwarne a tsiyif Yasuwa, tsuguna a nǝgha tsin, ka a fadǝghǝro ba itar bi. ");
INSERT INTO gdf_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ən tǝkhal kǝ yana, ka mǝdlawala Yasu kǝ furakh sar mits ǝn tlǝrna jakv, madv itar ǝn dǝgal da dlǝmdla kǝs. ");
INSERT INTO gdf_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Guyaghǝr tsitar, ka kwarar khai itar kǝ chalǝmakh tar. Ai ghǝr tar tsuguna a khayanǝf ba itar bi. ");
INSERT INTO gdf_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ən tǝkhal kǝ yana, ka soghǝr Yasu kǝ furakh sarna kǝlatǝm kitakw, madv itar ǝn zu kaf. Ka tavatǝrghǝr ad di wirva kuɗ fadǝghǝrofǝg tar, zǝ ɓengɓeng ghǝre a kalwal itara kǝ fadǝghǝrofǝg dǝ lave a kwara tǝrkhai liye tsa nǝghan ǝn tǝkhal kǝ tsiya sar. ");
INSERT INTO gdf_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Ka niya tsitar, “Damdǝgal da lard daghan, kwaramdu lav zǝɗan kǝ daghan ud dǝg sig. ");
INSERT INTO gdf_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ɗaga ude fadǝghǝro, parandalud, da gǝmadu gǝma dǝ saf. Ai ɗaga ude kwal fadǝghǝro, da tǝkara lavud. ");
INSERT INTO gdf_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Auna dǝgakhe da mana liye fadǝghǝro dǝ kǝ, ai da mǝdla fadǝghǝrofǝg tar. Da zaɓado zaɓe tar sǝɗikw bǝzan ǝn ɗakhar, da kwar lav itar dǝ ghay tlǝrna kǝs. ");
INSERT INTO gdf_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Da zǝɓa zǝɓe tar bub dǝ dǝvakh tar, ai da ka khǝɓu itar ngura, na dǝge da manatǝrin itsa khǝɗikǝn bi. Da bakhatǝr ghǝr bakha itar dǝv kǝ udakh kwal yanga, tsuguna da mbǝga itar.” ");
INSERT INTO gdf_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ən tǝkhal kǝ kwara tǝrkhai kwara kǝ Dad zikan Yasu ad ɗaga lavakhana kǝ furakh sar. Ka ɓo dǝgo da gharazhigǝl, ndzǝgan ǝn tǝ dǝva kaf Yazhigǝl. ");
INSERT INTO gdf_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ka dala furakh sar da kwardu lav Yazhigǝl itsa dǝvar. Dad zikan tsuguna ka a mǝlatru, a ndazhana kwarne kwardu lav tara jir, tǝ dǝva dǝ dǝg ndawakakhe a mange tar.");
ALTER TABLE gdf_vpl ADD FULLTEXT(verseText);
UNLOCK TABLES;
