﻿USE sofia;
DROP TABLE IF EXISTS sofia.gde_vpl;
CREATE TABLE gde_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gde_vpl WRITE;
INSERT INTO gde_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Wiinə ləmənyinə ŋga dzədzəshi'inə ŋga Yeesu *Aləmasiihu, jijinə ŋga *Dawuda. Ma Dawuda, Ibərahiima nə dzədzəci. ");
INSERT INTO gde_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Ma Ibərahiima, kə pwayi ci tə Isiyaaku. Isiyaaku a poo tə Yakubu. Yakubu a poo tə Yahuda da ndzəkəŋushi'inəkii. ");
INSERT INTO gde_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Ma daba'əkii, Yahuda a poo tə i Parasa da Zara dashi Tamara. Ma Parasa, kə pwayi ci tə Hasəroona. Hasəroona a poo tə Arama. ");
INSERT INTO gde_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Arama a poo tə Aminadaba. Aminadaba a poo tə Nashana. Nashana a poo tə Saləmoona. ");
INSERT INTO gde_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Saləmoona a poo tə Boowazə dashi Rahaba. Ma Boowazə, kə pwayi ci tə Oobyadə dashi Ruuta. Ma Oobyadə, kə pwayi ci tə Jasii. ");
INSERT INTO gde_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jasii a poo tə ŋwaŋwə Dawuda. Dawuda a poo tə Sulayimaanu. Miitə sha nji ka minə ŋga Uurəya nə məci Sulayimaanu. ");
INSERT INTO gde_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Ma Sulayimaanu, kə pwayi ci tə Raba'ama. Raba'ama a poo tə Abiya. Abiya a poo tə Asa. ");
INSERT INTO gde_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Asa a poo tə Jahusafatə. Jahusafatə a poo tə Yaramə. Yaramə a poo tə Uuzhiya. ");
INSERT INTO gde_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Uuzhiya a poo tə Yatamə. Yatamə a poo tə Ahazə. Ahazə a poo tə Hizikiya. ");
INSERT INTO gde_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hizikiya a poo tə Manasa. Manasa a poo tə Amoona. Amoona a poo tə Joosiya. ");
INSERT INTO gde_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Joosiya a poo tə Yakuniya da ndzəkəŋushi'inəkii. Saa'ikii kəəshi ənji tə manjeevə *Isərayiila aa Babila ka mavaanə. ");
INSERT INTO gde_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Ndzaŋənə ka saa'i ŋga mavaanə də Babila wiinə ləmə ŋga dzədzəshi'iitə ɓaanii ənji əsə: Ma Yakuniya, kə pwayi ci tə Salaatiyalə. Salaatiyalə a poo tə Zarababila, ");
INSERT INTO gde_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Zarababila a poo tə Abihuda. Abihuda a poo tə Iliyakimə. Iliyakimə a poo tə Azoora. ");
INSERT INTO gde_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Azoora a poo tə Zadookə. Zadookə a poo tə Akima. Akima a poo tə Ilihuda. ");
INSERT INTO gde_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Ilihuda a poo tə Iliyazara. Iliyazara a poo tə Matanə. Matanə a poo tə Yakubu. ");
INSERT INTO gde_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Yakubu a poo tə Yusufu ŋgurii Mariyaama. Ma kya, ki nə məci Yeesu. Tə ci 'wii ənji *Aləmasiihu. ");
INSERT INTO gde_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Də ha'ə ɗii zamananyinə pu'u aji ənfwaɗə ndzaŋənə ka Ibərahiima ka dzənə ka Dawuda. Ha'ə əsə, tə'i zamananyinə pu'u aji ənfwaɗə ndzaŋənə ka Dawuda ka dzənə ka saa'i ŋga dzənə ka mavaanə aa Babila. Tə'i zamananyinə pu'u aji ənfwaɗə əsə ndzaŋənə ka dzənə ka mavaanə aa Babila ca'ə ka saa'itə pwayi ənji tə Aləmasiihu. ");
INSERT INTO gde_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Wiinə makə sətə pwayi ənji tə Yeesu Aləmasiihu. Ma Mariyaama məci Yeesu, Yusufu ghə'i tə ki. Amma, ma taabu'u kaa kya da məhura, ma ɗii səkii, kə ɗasəkii ki də baawəɗa ŋga Malaaɓa Ma'yanə. ");
INSERT INTO gde_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Ma Yusufu, əndə ətə ca slənə taa mi patə də rəgwakii. Paa ci mwayi ɗavə ayinə ka Mariyaama agi ənji əsə. Acii ha'ə, kə ɗii ci aniya ŋga səɗəpaa maɗanaakii ci saakii, yadə shiinə ŋga ənja. ");
INSERT INTO gde_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Ma ci ma'ə agi hiimanə agyanəkii, wata malaa'ika ŋga Slandanə a shigi ka ci agi səniinə, ca ba ka ci, “Yusufu, jijinə ŋga Dawuda, ga ha ŋgwalə ka ŋgərənə tə Mariyaama, kaa kya ndzaa ka minaaku. Acii də Malaaɓa Ma'yanə nə ki də ɗasəka. ");
INSERT INTO gde_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Ka poonə nə ki uundzə ŋgura. Yeesu nii kwa ɗəkə ka ci ləma. Acii ci na luupaa tə ənjaakii agi 'waslyakəənatii.” ");
INSERT INTO gde_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Ma slənyi ətsə patə, ka mbu'utəginə də sətə waɓi Slandanə da ma *anabi. ");
INSERT INTO gde_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","Ma bii ca, “Kadə nə kadəmə a ɗasəka, kya poo uundzə ŋgura, ənjə a 'wa tə ci Imaniyalə”, makə bana, ‘Ləɓə daamə nə Əntaŋfə’. ");
INSERT INTO gde_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Wata, makə ma'i Yusufu ka ŋunyinə, ca ŋgərə tə Mariyaama, kaa kya ndzaanə ka minaakii, makə sətə bii malaa'ika ŋga Slandanə ka ci ɗanə. ");
INSERT INTO gde_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Amma, mabaamə ci də ki taabu'u pwayi ki uundzə ŋgurəta. Makə pwayi ki, ca ɗəkə ka uuzənəkii ləmə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Ma Yeesu, asəkə vəranə ŋga Bayitilaama anə hanyinə ŋga Yahudiya pwayi ənji tə ci, agi zamana ŋga ŋwaŋwə *Hirudusə. Ma daba'əkii, wata ənjitə shii agyanə tikisanyinə a ma'ya da tsaaŋwə, təya dzə aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","Mbu'unatii, təya ləgwa, əŋki tii, “Miinə uuzəətə pwayi ənji kaa ca ndzaa ka ŋwaŋwə ŋga Yahudiina? Kə nee inə ka tikisaakii, makə lə'yagi ki da tsaaŋwə. Ka paslənə tə ci shiinə.” ");
INSERT INTO gde_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Makə fii ŋwaŋwə Hirudusə waɓəətsa, kə ma'i haŋkalaakii ka shaŋə. Ha'ə nə patənə ŋga ənji əsə asəkə vəranə ŋga Urusaliima. ");
INSERT INTO gde_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Wata ca 'waa'watə patənə ŋga matakəŋwanyinə ŋga limanyinə da *maliminə ŋga bariya, ca ləgwa ka tii, əŋki ci, “Da saŋə ci ənjə a poo tə *Mataɗəkii ŋga Əntaŋfwa?” ");
INSERT INTO gde_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","Təya ba ka ci, “Asəkə vəranə ŋga Bayitilaama, anə hanyinə ŋga Yahudiya nə ənjə a poo tə ci. Acii wiinə sətə nyaahə *anabi: ");
INSERT INTO gde_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","‘'Ya'ə Bayitilaama, anə hanyinə ŋga Yahudiya, rəŋwə nə hə agi vəranyinə ŋga Yahudiya ətə palee də məghərəvənə, acii asəkəku nə matakəŋwanə a shigi. Ci na ndzaa ka magəra ŋga ənji ŋga Əntaŋfə, ənji *Isərayiila.’ ” ");
INSERT INTO gde_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Wata Hirudusə a 'wa tə ənjitə shi da tsaaŋwə, kaa ca ɗa mətərəkinə da tii yadə shiinə ŋga ənja. Ca ləgwatə a matii taa ka ŋgutə saa'i ɗaŋə lə'yagi tikisakii. ");
INSERT INTO gde_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Wata ca sləkee ka tii aa Bayitilaama, ca ba ka tii, “Dəmə ka nəəhətə uuzənəkii. Maɗa kə lapaa unə tə ci, shoomə ka bapaanə ka nyi, nyi maa, kaa nya dzə ka paslənə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","10","Ma daba'ə waɓənatii da ŋwaŋwa, wata təya maɗə, təya palə. Ma təya palə, təya ənə ka neenə ka tikisatə nee tii da tsaaŋwə. Makə ənyi tii ka neenə ka tikisakii, kə ɗii tii maŋushinə ka shaŋə. Tikisakii a dzə də ta ka tii kəŋwanə, ha'ə shi tikisakii ka kəŋaanənə dagyanə hatə ɗii uuzənəkii davə. ");
INSERT INTO gde_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","Təya dzəgərə aasii, təya lapaa tə uuzənəkii tii da məcikii Mariyaama, təya gərə'waanə ka paslənə tə ci. Ma daba'əkii, təya pəərəgi mbuurənyinatii, təya ŋgyaaragi kanyeera da urədya ŋga ɗəzənə da əndə'i tsarə ŋga urədya ətə ci ənjə a 'wa miira, təya vii ka ci. ");
INSERT INTO gde_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Ma daba'əkii, makə kə bii Əntaŋfə ka tii agi səniinə oo'i, ga təya ənə aa ha Hirudusə, wata təya ənə satii aa hatii aa vəra ka əndə'i rəgwa pamə. ");
INSERT INTO gde_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Makə pyalə ənjitə shi da tsaaŋwə satii, wata malaa'ika ŋga Slandanə a shigi ka Yusufu agi səniinə, ca ba ka ci, “Ma Hirudusə, kadə nii kəya alə uuzəətsə kaa ca ɓələgi. Acii ha'ə, maɗətə, ha ŋgərə tə tii da məcikii, una palə aanə hanyinə ŋga Misəra, una ndzaa davə see maɗa bii nyi ka hə dzəginə davə.” ");
INSERT INTO gde_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Makə fii Yusufu ha'ə, wata ca maɗətə, ca ŋgərə tə uuzəətə tii da məcikii davəɗə, ca huyi də tii aanə hanyinə ŋga Misəra. ");
INSERT INTO gde_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Ca ndzaa davə see də makə əntəgi Hirudusə. Ma ɗii ətsə ha'ə, ka mbu'utəginə də sətə bii Slandanə da ma anabi oo'i: “Kə 'wagi nyi uuzənaaki anə hanyinə ŋga Misəra.” ");
INSERT INTO gde_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Makə paaratəgi Hirudusə oo'i, kə ha'uunə ənjitə shi da tsaaŋwə ka ci, kə ɓəzhi səkəkii ka shaŋə. Ca sləkee ka ənjə a ɓəələgi patənə ŋga uuji ŋguyirənə asəkə vəranə ŋga Bayitilaama da sətə gəŋutəgi də ki patə, ndzaŋənə ka kura poonə ka dzənə ka fəzə bəra'i, makə sətə ɓaanya ci, ndzaŋənə ka saa'itə ləguyi ci ama ənjitə shi da tsaaŋwə, waatoo, saa'itə 'watəgi tikisakii lə'yaginə. ");
INSERT INTO gde_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Də ha'ə ndzaa ka tantanyinə nə sətə bii anabi Irimiya. Ma bii ca: ");
INSERT INTO gde_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Kə fii ənji bwaya uura asəkə vəranə ŋga Rama, uura ŋga bwaya tuunə da maɓətəsəka. Rahila ca tuu atsa manjeevənatə. Kə təkuree ənji ka puutəpaanə tə ki, acii kə məətəgi manjeevənatə.” ");
INSERT INTO gde_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Daba'ə makə əntəgi Hirudusə, wata kə shigi malaa'ika ŋga Slandanə ka Yusufu agi səniinə, ci anə hanyinə ŋga Misəra, ");
INSERT INTO gde_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","ca ba ka ci, “Maɗətə, ha ŋgərə uuzəətsə tii da məcikii, kaa ha ənə aanə hanyinə ŋga Isərayiila. Acii, ma ənjitə ali rəgwa ŋga ɓələgi uuzəətsa, kə məətəgi tii.” ");
INSERT INTO gde_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Makə fii Yusufu ha'ə, wata ca maɗətə, ca ŋgərə uuzəətə da məcikii, təya ənə aanə hanyinə ŋga Isərayiila. ");
INSERT INTO gde_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Amma, makə fii Yusufu oo'i, Arəkilayasə ŋgirə dəgələ ŋga dii, waatoo, ŋga Hirudusə, kaa ca ndzaa ka ŋwaŋwə ŋga Yahudiya, kə ŋgwali ci ka ənənə aa dəvə. Əntaŋfə a ənə ka banə ka ci agi səniinə tə sətə ɗanəkii. Wata ca dzə saakii aanə hanyinə ŋga Galili, ");
INSERT INTO gde_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ca dzə ka ndzaanə asəkə vəranə ŋga Nazaratu. Də ha'ə ɗii ka tantanyinə nə sətə bii anabinyinə agyanə Aləmasiihu oo'i: “Ka 'wanə nə ənji tə ci əndə Nazaratu.” ");
INSERT INTO gde_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Ma daba'ə fəzənyinə, kə gi Yoohana əndə ɗa bapətisəma ka waazanə aagi bilinə ŋga Yahudiya. ");
INSERT INTO gde_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Ca ba, “Uneemə ka ɗa 'waslyakəənə, una baanə ka Əntaŋfə, acii kədəhə nə ci ka ɗa ŋwaŋuunaakii.” ");
INSERT INTO gde_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Ma Yoohana, ci nə əndətə shi *anabi Isaaya a waɓi agyanəkii, banə tuu'ina: “Wiitə əndə ca kaala agi bilinə, əŋki ci: ‘Haɗatəgimə də rəgwa ka Slandana, kəŋeemə ka ci ka rəgwa.’ ” ");
INSERT INTO gde_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Ma Yoohana, də shiŋkinə ŋga ŋgyalooba ɗii ənji kəjeerənaakii. Ca əgəgi ŋukii də gyara ŋga kuvə'unə. Ayiwa da moozəŋa nji zəmaakii. ");
INSERT INTO gde_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Kə giigi ənji aaɓiikii daga də Urusaliima da anə patənə ŋga hanyinə ŋga Yahudiya da patənə ŋga hanyinə ətə ama gəərə ŋga Urədunə. ");
INSERT INTO gde_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Təya baabagi 'waslyakəənatii, ca ɗa ka tii bapətisəma asəkə gəərə ŋga Urədunə. ");
INSERT INTO gde_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Makə nee Yoohana ka *Farisanyinə da *Sadukiinə laŋə təya shi aaɓiikii, kaa ca ɗa ka tii bapətisəma, ca ba ka tii, “Unə rəhunyinə, goona səkəpaanə ka banə oo'i, ka mbərəɗənə nuunə acii maɓətəsəkə ŋga Əntaŋfə ətə na shi. ");
INSERT INTO gde_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","Amma, ma ɗanuuna, slənəmə sətə ca ɓaarii oo'i, kə baa unə ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Goona səkəpaanə ka banə oo'i, ka mbərəɗənə nuunə, acii ɗii Ibərahiima ka dzədzəshi'inuunə. Wanyinə ka banə koonə: ma Əntaŋfə, ka mbeenə nə ci ka zhi'weenə ka faariinyiina, təya ndzaa ka jijinyinə ŋga Ibərahiima! ");
INSERT INTO gde_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Ma əsə, tə'i raha acii, ka cisləginə də ənfuginə ka slərəginətii. Taa ŋgutə ənfwə nəndə pooshi ka poonə ŋga'ə, ka cisləginə nə ənja, ənjə a kagərə aagi gunə. ");
INSERT INTO gde_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ma nya, də ma'inə cii kya ɗa koonə bapətisəma ka ɓaariinə oo'i, kə baa unə ka Əntaŋfə. Amma, ma əndətə na uugya ba'ə ka shinə, də Malaaɓa Ma'yanə da gunə nii kəya ɗa koonə bapətisəma. Ɗuunuunaakii palee ka naaki. Mambu'umə nyi bahə nya kərə ɓiɓinaakii. ");
INSERT INTO gde_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Tə'i ɗəvə bə'unaakii ŋga bə'ugi də səkəŋwa. Ka fəɗənə nə ci səkəŋwaakii, ca əjigərə aa əjimə. Amma, ma lyaafa, ka dzatəginə nə ci, ca pukəgərə aagi gunə ətə pooshi ka əntənə.” ");
INSERT INTO gde_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Wata Yeesu a maɗə də Galili, ca dzə aa gəərə Urədunə, kaa Yoohana a ɗa ka ci bapətisəma. ");
INSERT INTO gde_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","Amma Yoohana a ɗa gazhi'waanə ŋga təŋapaanə tə ci, ca ba ka ci: “Ma dəɓee, hə nə ɗa ka nyi bapətisəma. Amma wahənə kə shi aaɓiiki əsə!” ");
INSERT INTO gde_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","Amma Yeesu a ba ka ci, “Luuvə sətsə bii nyi ka hə. Acii də ha'ə ɗatənaaŋwə patənə ŋga sətə ca kaɗeesəkə ka Əntaŋfə.” Wata Yoohana a luuvə. ");
INSERT INTO gde_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Makə uugi ənji ɗa bapətisəma ka Yeesu, pii ca gimagi agi ma'inə. Wata səkəntaŋfə a wunəgi ka ci, ca nee ka Ma'yanə ŋga Əntaŋfə ca jima aanəkii makə kurəkuta. ");
INSERT INTO gde_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Wata ənjə a fa waɓənə dadagyə ca ba, “Waatsə Uuzənaaki, kə uu'i nyi tə ci. Ci ca uuɗagi səkəki.” ");
INSERT INTO gde_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Makə uugi ənji ɗa bapətisəma ka Yeesu, wata Malaaɓa Ma'yanə a ŋgərə tə ci, ca kərəgərə aagi bilinə, kaa Seetanə a təɓətə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Makə baa ci ənfwaɗə pu'unə da uusəra ənfwaɗə pu'unə yadə zəmə amakii, kə ɗii maɗəfənə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Wata Seetanə a dzə aaɓiikii, əŋki ci ka ci, “Makə ɗii ci *Uuzənə ŋga Əntaŋfə nə hə, bawə ka faariitsa təya zə'ugi ka zəma.” ");
INSERT INTO gde_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Amma Yeesu a ba ka ci, “Tə'i manaahəkii tuu'ina, ‘Əntaa də zəmə daanəkii mbəɗənə ənda, amma ka mbəɗənə nə əndə də taa ŋgutə waɓənə ətə ca shigi da ma Əntaŋfə.’ ” ");
INSERT INTO gde_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Ma daba'əkii, Seetanə a ŋgərə tə ci, ca kərə aa Urusaliima, waatoo malaaɓa maɗuunə vəranə, ca kəŋee ka ci ka makiɗakiɗaŋənə ŋga maɗuunə kuvə ŋga Əntaŋfə, ");
INSERT INTO gde_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","əŋki ci ka ci, “Makə ɗii ci, Uuzənə ŋga Əntaŋfə nə hə tanyi, ləɗəgərə aa panə, acii tə'i manaahəkii tuu'ina, ‘Ka banə nə Əntaŋfə ka malaa'ikanyinaakii, kaa təya nəhətə tə hə, təya kətsa'utə tə hə də ciinətii, acii ga ha dəgəgi taa səɗəku anə faara.’ ” ");
INSERT INTO gde_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Yeesu a ba ka ci, “Tə'i manaahəkii əsə tuu'ina, ‘Ga ha təkə tə Əntaŋfə Slandanəku.’ ” ");
INSERT INTO gde_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Wata Seetanə a ənə ka ŋgərənə tə ci, ca kərə aagyanə magərə giŋwə ka shaŋə, ca ɓaarii ka ci hanyinə ŋga duuniya patə da gənatə asəkəkii, ");
INSERT INTO gde_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","ca ba ka ci, “Ma ətsə patə, ka viinə nə nyi ka hə, maɗa kə gərə'waanə hə ka paslənə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Wata Yeesu a ba ka Seetanə, əŋki ci, “Dzəgi gadəvə Seetanə! Tə'i manaahəkii tuu'ina, ‘Ka Əntaŋfə Slandanəku daanəkii gərə'unəku, tə ci daanəkii paslənəku əsə.’ ” ");
INSERT INTO gde_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Makə fii Seetanə ha'ə, wata ca bwasee ka Yeesu. Ma daaba'əkii, malaa'ikanyinə a dzə ka tsakənə tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Kə fii Yeesu oo'i, kə kəsəgərə ənji tə Yoohana aa furəshina. Makə fii ci ha'ə, ca maɗə, ca palə aanə hanyinə ŋga Galili. ");
INSERT INTO gde_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Paa ci kəŋaanə də Nazaratu, amma ca palə aa Kafarənahumə, ca ndzaanə davə. Ma Kafarənahumə, əndə'i vəranə ama uunəvə ŋga Galili, anə hanyinə ŋga Zabuloonə da Nafətalima. ");
INSERT INTO gde_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Ma ɗii ətsə patə, ka mbu'utəginə də sətə waɓi anabi Isaaya ətə bii ci, ");
INSERT INTO gde_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“Ma ənjitə agyanə hanyinə ŋga Zabuloonə da ŋga Nafətalima, a rəgwa uunəva, a taŋəgi Urədunə, hanyinə ŋga məshipətə ənja, waatoo Galili, ");
INSERT INTO gde_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","agi təkunə nə tii. Ka neenə nə tii ka ɓərənə ka shaŋə. Ma ənjitə ndzaanə agi təkunə ŋga wa, ka ɓərəginə nə ɓərənəkii ka tii.” ");
INSERT INTO gde_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Ndzaŋənə ka saa'ikii, 'watəgi Yeesu waazanə, ca dzə də banə: “Uneemə ka ɗa 'waslyakəənə, una baanə ka Əntaŋfə, acii kədəhə nə ci ka ɗa ŋwaŋuunaakii.” ");
INSERT INTO gde_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Ma Yeesu a dzə də wiigi'inə ama uunəvə ŋga Galili, kə lapaa ci ənji bəra'i, təya təəmə. Ndzəkəŋushi'inə nə tii, waatoo, Simoonə ətə ci ənjə a 'wa Piita tii da Andərawəsə ndzəkəŋuci. Ma təya, təəmənə nə slənatii. ");
INSERT INTO gde_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Yeesu a ba ka tii, “Shoomə atsaki, kaa nya dzəgunə koonə makə sətə ci ənjə a ɗa slənə ŋga təəmə ənja.” ");
INSERT INTO gde_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Pii wata təya bwasee ka slaaɗatii, təya palə atsakii. ");
INSERT INTO gde_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Yeesu a dzə aakəŋwa, ca lapaa tə hara ndzəkəŋushi'inə bəra'i əsə, Yakubu da Yoohana, manjeevənə ŋga Zabadiya. Asəkə kumbawalatii nə tii da i dəsənətii Zabadiya, təya haɗa də slaaɗatii. Yeesu a 'wa tə tii. ");
INSERT INTO gde_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","Pii wata təya bwasee ka dəsənətii da kumbawala, təya palə atsakii. ");
INSERT INTO gde_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Kə wiigi'i Yeesu taa dama patə anə hanyinə ŋga Galili, ca dzə də dzəgunənə ka ənji asəkə *kuvə də'wanyinə, ca waaza Ŋunyi Habara agyanə *ŋwaŋuunə ŋga Əntaŋfə, ca mbəɗəpaa də taa ŋgutə tsarə ŋga bwaneanyinə. ");
INSERT INTO gde_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Kə huwugi habaraakii taa dama patə anə hanyinə ŋga Siriya. Wata ənjə a kyaara ka ci patənə ŋga ənjitə da bwaneanyinə kama kama ashitii, waatoo ənji ginaaji, da ənji ma'idə'ida, da maɓiiyi ənja. Ca mbəɗəpaa də tii patə. ");
INSERT INTO gde_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Daɓaala laŋə nyi'u tə ci anə hanyinə ŋga Galili. Kə shi hara ənji daga anə hanyinə ŋga Dikapooli da ŋga Yahudiya, da asəkə vəranə ŋga Urusaliima, ha'ə da ataŋəgi gəərə ŋga Urədunə, təya nə'u tə ci. ");
INSERT INTO gde_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Makə nee Yeesu ka daɓaala laŋə, wata ca ndərəgi aanə ɗaŋgəra, ca ndzaanə dasə. Lyawarənaakii a əntsahə aaɓiikii. ");
INSERT INTO gde_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Ca 'watəgi dzəgunənə ka tii, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Tə'i barəkaanə ashi ənjitə shii oo'i, tyalakinə nə tii akəŋwacii Əntaŋfə. Ma təya, ka tii də ŋwaŋuunə ŋga dagyə. ");
INSERT INTO gde_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Tə'i barəkaanə ashi ənjitə ka maɓətəsəka, acii ka puutəpaanə nə Əntaŋfə tə tii. ");
INSERT INTO gde_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Tə'i barəkaanə ashi ənjitə banee ka nətii akəŋwacii ənja, acii tii na upaa sətə bii Əntaŋfə viinə. ");
INSERT INTO gde_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Tə'i barəkaanə ashi ənjitə ca moo ka shaŋə tə slənə sətə ci Əntaŋfə a moo ənjə a slənə. Acii ma təya, ka viinə nə Əntaŋfə ka tii baawəɗa ŋga ɗa slənəkii makə sətə mwayi tii. ");
INSERT INTO gde_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Tə'i barəkaanə ashi ənjitə ca nəhə təgunuunə ŋga hara ənja. Acii tii maa, ka nəhənə nə Əntaŋfə təgunuunatii. ");
INSERT INTO gde_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Tə'i barəkaanə ashi ənjitə ɗii ədzəmətii malaaɓakii. Acii kadə nə təya nee ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Tə'i barəkaanə ashi ənjitə ca slənə sətə ca kira jamənə aahada ənja. Acii ka 'wanə nə Əntaŋfə tə tii manjeevənaakii. ");
INSERT INTO gde_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Tə'i barəkaanə ashi ənjitə ci ənjə a ciɓə də tii putə ŋga slənə sətə ci Əntaŋfə a moo. Acii ka tii də ŋwaŋuunə ŋga dagyə. ");
INSERT INTO gde_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Tə'i barəkaanə ashuunə, maɗa dzaanii ənji tuunə, ənjə a ciɓə duunə, ənjə a jaarakə kama kama aashuunə putə ŋga nə'unə goonə tə nyi. ");
INSERT INTO gde_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Ɗamə maŋushinə ka shaŋə, acii tə'i maɗuunə shikwa goonə kiɗə dagyə. Ha'ə makə ətsə nji ənjə a ciɓə də anabinyinə ŋga ŋukə.” ");
INSERT INTO gde_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“Ma una, makə zhatanə nuunə ka patənə ŋga ənji shiŋkinə. Amma, maɗa kə ləvəgi zhatanə saakii, pooshi ənji ka mbeenə ka ənətəginə njamə njamə ma'ə. Pooshi nafaakii ma'ə, maɗaamə pukəginə aa panə, ənjə a wiigi anəkii də səɗa. ");
INSERT INTO gde_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","“Ma una, unə nə ɓərənə ka *duuniya. Ma vəraatə ghənyi ənji anə ɗaŋgəra, pooshi ka umbənə shaŋə. ");
INSERT INTO gde_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Pooshi əndə ca təzəvə gunə ka garəkuwa, ca umbətə də kəŋwa. Amma ka madzəgamə ha dzakəpaanəkii, hatə ca ɓərə taa dama patə asəkə ya. ");
INSERT INTO gde_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Ha'ə makə ətsə əsə, wa ɓərənə goonə a ɓərə taa ka wu patə, kaa təya shii nee ka ŋunyi slənə goonə, təya dəla də Dəsənuunə ətə dadagyə. ");
INSERT INTO gde_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“Goona nəhə noonə makə ma shinaaki, ka uulagi bariya ŋga Muusa da dzəgunənə ŋga anabinyinə shi nyi. Aa'a, poosha. Mashimə nyi ka uulaginə. Ma shi nyi, ka mbu'utəginə də dzəgunənatii, kaa ca ndzaa tantanyinə. ");
INSERT INTO gde_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Tantanyinə cii kya ba koonə: taa uushi pirihu gi'u, pooshi ka dzəginə agi bariya ca'ə ka saa'itə nə duuniya a uudə, see maɗa mbu'utəgi Əntaŋfə də aniyaakii patə. ");
INSERT INTO gde_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Acii ha'ə, taa wu bwasee ka nə'u bariya taa ətə palee də uundzuundzuunə maa, ha'ə ca dzəgunə ka ənji kaa təya ɗa makə naakii əsə, moodəba'a ndzaanəkii agi ŋwaŋuunə ŋga dagyə. Amma taa wu patə nə'utə makə sətə bii bariya, ca dzəgunə ka ənji kaa təya nə'utə makə naakii, gawə ndzaanəkii agi ŋwaŋuunə ŋga dagyə. ");
INSERT INTO gde_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Acii wanyinə ca ba koonə: ma slənə goonə ətə ci Əntaŋfə a moo ənjə a slənə, maɗa mapaleemə ka slənə ŋga maliminə da ka ŋga *Farisanyinə, pooshi unə ka upaa dəməgərənə aagi ŋwaŋuunə ŋga dagyə.” ");
INSERT INTO gde_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“Kə fii unə ənjə a ba ka ənji daga ŋukə oo'i: ‘Ga ha ɓələ hiinə. Taa wu ɓəli əndə, ka kərənə nə ənji tə ci aakəŋwacii gəŋwanə.’ ");
INSERT INTO gde_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amma, ma nya, wanyinə ca ba koonə: taa wu patə ɓəzhi səkə aashi əndə nə'unə makə ci, ka kərənə nə ənji tə ci aakəŋwacii gəŋwanə. Taa wu patə dzaanii tə əndə nə'unə makə ci, əŋki ci ka ci: maɗəəkə ənda, ka kərənə nə ənji tə ci aakəŋwacii madiigərə gayinə. Taa wu patə əsə dzaanii tə əndə nə'unə makə ci, əŋki ci ka ci: mazaɓə ənda nə hə! kə ɗii bahə kanə tə ci aagi gunə. ");
INSERT INTO gde_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Acii ha'ə, taa ka ha ŋga ɗa sataka nə hə ka vii satakaaku ka Əntaŋfə, maɗa kə buurətə hə oo'i, kə ɓəzee hə ka səkə ŋga ndzəkəŋu, ");
INSERT INTO gde_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ma ɗanəkwa, bwasee ka satakaaku davə gatə, ha palə, ha dzə ka naranə da ndzəkəŋu zəku'i, taabu'u nii kwa ənə ka vii satakaaku ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Maɗa kə wulii əndə tə hə akəŋwacii gəŋwanə, aluu haɗatəginə da ci pii pii taabu'u mbu'unuunə aakəŋwacii gəŋwanə. Acii maɗa kə mbu'yuunə aakəŋwacii gəŋwanə, ka viinə nə ci tə hə aacii əndə la gəŋwanə, əndə la gəŋwanəkii a vii tə hə aacii soojiinə, təya dzə ka pa'əginə tə hə a furəshina. ");
INSERT INTO gde_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Tantanyinə cii kya ba ka hə: davə ndzaanəku, paa hə ka gimaginə, see maɗa ki'igi hə patənə ŋga kwaɓatə lii ənji ka hə.” ");
INSERT INTO gde_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","“Kə fii unə ənjə a ba ‘Ga ha aləhiinə’. ");
INSERT INTO gde_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","Amma, ma nya, wanyinə ca ba koonə: taa wu ca tsaamə minə ətə əntaa naakii ŋga mwamwa'inə, kə baa ci də ki ətsə asəkə ədzəməkii. ");
INSERT INTO gde_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Acii ha'ə, maɗa ginəku ŋga ciizəmanə ca kavə tə hə ka ɗa 'waslyakəənə, hurə'yagi, ha kagi. Gəɗə əndə'i purəŋanə ŋga shishinəku ətee hə, acii kagərənə tə patənəkii aagi gunə. ");
INSERT INTO gde_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","Maɗa ciizəmaku ca kavə tə hə ka ɗa 'waslyakəənə, lagi, ha kagi. Gəɗə əndə'i purəŋanə ŋga shishinəku ətee hə, acii kagərənə tə patənəkii aagi gunə.” ");
INSERT INTO gde_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“Agi banə nə ənji daga ŋukə, ‘Taa wu lakəgi minaakii, wa ca vii ka ki manaahə ləkaləkatə ŋga kaginə də ki.’ ");
INSERT INTO gde_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","Amma, ma nyi, wanyinə ka banə koonə: taɗa wu lakəgi minaakii, maɗa əntaa agyanə aləhiinə, kə kavə ci tə ki ka aləhiinə ətsa, maɗa kə ŋgirə ki əndə'i ŋgura. Ma ŋgurətə ŋgirə tə ki əsə, kə ali ci hiinə ətsa.” ");
INSERT INTO gde_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","“Kə fii unə əsə ənjə a ba ka ənji daga ŋukə oo'i, ‘Ga ha əɓipaa aləkawalaaku. Amma ɗawə sətə ɗii hə aləkawalə akəŋwacii Slandanəku ŋga ɗanə’. ");
INSERT INTO gde_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","Amma, ma nyi, wanyinə ca ba koonə, goona 'wa ləmə ŋga Slandanə shaŋə, una ɗa aləkawala. Goona jiɗə də dadagyə, acii ci nə dəgələ *ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Taɗa də hanyinə əsə, goona jiɗə, acii ci nə ha ŋga əji səɗəkii. Taɗa də Urusaliima əsə, goona jiɗə, acii vəranə ŋga Əntaŋfə ətsa. Ci nə maɗuunə Ŋwaŋwa. ");
INSERT INTO gde_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Goona jiɗə taa də nuunə əsə, acii pooshi unə ka mbee ka dəvətə taɗa shiŋkinə rəŋwə ŋga ənduuɗa taa əndə dəŋwa. ");
INSERT INTO gde_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ma ɗanuuna, bamə ‘awa’ taa ‘aa'aa'ə’ tanə. Taɗa mi shigi da moonə ma'ə, dacii *Seetanə shigi.” ");
INSERT INTO gde_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“Kə fii unə ənjə a ba ka ənji oo'i, ‘Maɗa kə jikwagi əndə'i əndə ginə ŋga əndə'i ənda, ginəkii jikwaginə ənji naakii əsə. Maɗa kə kuriŋagi əndə'i əndə linyinə ŋga əndə'i ənda, linyinəkii kuriŋaginə ənji naakii əsə’. ");
INSERT INTO gde_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amma, ma nyi, wanyinə ka banə koonə: maɗa kə ɓəzee əndə'i əndə ka səkəku, ga ha ki'i naaku. Maɗa kə tsagi əndə ka hə meeciinə ka hwahwaaməku ŋga ciizəmanə, zhi'wee ka ci ka hwahwaamə ŋga madzəna əsə. ");
INSERT INTO gde_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Maɗa kə kirə əndə tə hə aakəŋwacii gəŋwanə, kaa ca shii ləwutə də kəjeerənaaku, bwasee ka ci, ca ŋgərə baləwaaku əsə. ");
INSERT INTO gde_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Maɗa kə kavə əndə'i əndə tə hə tyasə ka kərə ka ci əndə'i uushi ŋga kiloomeeta rəŋwə, kərəwə ka ci ŋga kiloomeeta bəra'i. ");
INSERT INTO gde_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Maɗa kə kədii əndə uushi aciiku, vii ka ci səkii. Maɗa kə shi əndə aaɓiiku ka ndzəma, ndzəmuu ka ci.” ");
INSERT INTO gde_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","“Kə fii unə ənjə a ba ka ənji oo'i, ‘Uuɗuu tə əndətə aɓiiku, ha kaaree ka ənji daawaanaaku’. ");
INSERT INTO gde_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amma, ma nyi, wanyinə ka banə koonə: uuɗəmə tə ənjitə ca ka koonə daawaanə, una ɗa də'wa ka ənjitə ca ciɓə duunə. ");
INSERT INTO gde_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Maɗa kə ɗii unə ha'ə, ka ndzaanə nuunə ka manjeevənə ŋga Dəsənuunə dadagyə. Acii ma ɗatə ci uusəraakii, kaa ca ɓərə ka bwaya ənji da ŋunyi ənji patə ka ciinə rəŋwə. Ca ndzəmə vənə ka ənjitə ca slənə bwaya sləna da ənjitə ca slənə ŋunyi slənə patə. ");
INSERT INTO gde_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Maɗa wata tə ənjitə ca uuɗə tuunə cuuna uuɗə tanə, pooshi unə ka upaa shikwa dadagyə. Taa ənji luu tsəkə maa, agi ɗanə nə tii ha'ə makə ətsa. ");
INSERT INTO gde_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Maɗa wata ka guviinuunə cuuna waɓə, pooshi unə slənyi uushi palee ka ŋga hara ənji, acii taa ənjitə mashiimə tə Əntaŋfə maa, agi ɗanə nə tii ha'ə makə ətsa. ");
INSERT INTO gde_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","See a ndzaa unə ka ənjitə yadə idəpaa uushi ashitii, makə sətə ɗii Dəsənuunə ətə dadagyə yadə idəpaa uushi ashikii.” ");
INSERT INTO gde_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“Ŋgərəmə haŋkala! Ma una slənə sətə ci Əntaŋfə a moo, goona ɗa kaa ənjə a shii neenə. Maɗa ha'ə cuuna ɗa, pooshi unə ka upaa shikwa acii Dəsənuunə dadagyə. ");
INSERT INTO gde_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Acii ha'ə, ma ha vii uushi ka əndə kədiinə, ga ha ɓaarəgi paŋgəraŋə kaa ənjə a shii neenə. Acii tə'i hara ənji ca ɗa ha'ə makə ətsə asəkə kuvə də'wanyinə da anə rəgwanyinə, kaa ənjə a shii dəlanə də tii. Ma təya, də bəra'i asəkətii ci təya kərə ka Əntaŋfə. Tantanyinə cii kya ba koonə: ma ənjitsa, kə uugi shikwatii, pooshi ma'ə aakəŋwa. ");
INSERT INTO gde_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amma, ma ha vii sataka ka əndə kədiinə, vii ka ci ka rəgwatə taa ŋunyi guvaku, pa ca shii. ");
INSERT INTO gde_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Maa kə ɗii hə ha'ə, ka ndzaanə nə satakaaku ma'umbəkii. Ma Duu ətə ca nee ka ma'umbə uushi əsə, ci na vii ka hə shikwa.” ");
INSERT INTO gde_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“Ma una ɗa də'wa, goona ɗa makə ŋga ənjitə ca kərə ka Əntaŋfə də bəra'i asəkətii. Acii ma təya, parakə kaɗeesəkə ka tii nə maɗətənə ahada ənja, təya ɗa də'wa asəkə *kuvə də'wanyinə da ka mətikətikənə ŋga rəgwa, kaa ənjə a shii neenə ka tii. Tantanyinə cii kya ba koonə, ma ənjitsa, kə uugi shikwatii ha'ə, pooshi ma'ə aakəŋwa. ");
INSERT INTO gde_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amma, ma ha ɗa də'wa, dzəgərə aa kumu, ha pa'aanə makuvə ka naaku na, ha ɗa də'wa ka Duu ətə pooshi ənji ka neenə. Ma ca, agi neenə nə ci ka sətə cii kwa ɗa ma'umbeekii, ci na vii ka hə shikwa. ");
INSERT INTO gde_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","“Ma una ɗa də'wa, goona siiyiitəgi də waɓənə ətə pooshi nafakii, makə sətə ci ənjitə mashiimə tə Əntaŋfə a ɗa. Ma nə tii ka nəhəna, ka fanə nə Əntaŋfə tə tii putə ŋga magərə də'watii. ");
INSERT INTO gde_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","Goona ɗa makə natii. Acii kə shii Dəsənuunə sətə cuuna moo kədiinə, unə ma'ə makədiimə aciikii. ");
INSERT INTO gde_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","Wiinə makə sətə ɗanuunə də'wa: ‘'Ya'ə Dəsəniinə ətə dagyə, ɗawə ka taa wu patə a dəla də ləməku. ");
INSERT INTO gde_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Ɗawə ŋwaŋuunaaku taa da patə. Wa ənjə a ɗa sətə cii kwa moo ganə a duuniya makə sətə ci ənjə a ɗa gatə dagyə. ");
INSERT INTO gde_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ndii keenə zəmə ŋga ka də uusəra ənshinə, ");
INSERT INTO gde_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ha tifyagi keenə 'waslyakəənə geenə, makə sətə ciina tyaafagi ka ənji ɗaaɗa keenə 'waslyakəənə. ");
INSERT INTO gde_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Ga ha kapaa tiinə ka rəgwa pu'unə, amma luupaa tiinə acii *Seetanə. Acii naaku nə ŋwaŋuunə da baawəɗa da ɗuunuunə ka ca'ə ndəŋwə ndəŋwə. *Aamiina.’ ");
INSERT INTO gde_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“Maɗa kə tifyagyuunə ka ənji ɗaaɗa koonə 'waslyakəənə, ma Dəsənuunə ətə dadagyə, ka tifyaginə nə ci koonə noonə 'waslyakəənə əsə. ");
INSERT INTO gde_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amma, maɗa pooshi unə tifyagi ka hara ənji 'waslyakəənatii, yoo, pooshi Dəsənuunə ka tifyagi koonə 'waslyakəənə goonə əsə.” ");
INSERT INTO gde_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“Ma unə agi ɗa suumaya, goona ɓəzee ka ginuunə makə ŋga ənjitə ca kərə ka Əntaŋfə də bəra'i asəkətii. Ka ɗatənə nə tii də natii nə rəgujiɓə, kaa ənjə a shii neenə oo'i, agi ɗa suumaya nə tii. Tantanyinə cii kya ba koonə, ma ənjitsa, kə uugi shikwatii ha'ə, pooshi ma'ə aakəŋwa. ");
INSERT INTO gde_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","Amma, ma ha ɗa suumaya, yiɓəgi ginəku, ha ɓəzəpaa nəku də maara, ha haɗatəgi də shiŋkinaaku ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","Maa kə ɗii hə ha'ə, pooshi hara ənji ka shiinə oo'i, agi ɗa suumaya nə hə, maɗaamə Duu ətə pooshi ənji ka neenə. Ma ca, ci ca nee ka ma'umbee uushi, ka viinə nə ci ka hə shikwa.” ");
INSERT INTO gde_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“Goona dzatə də gəna ka noonə nə ganə a duuniya. Ma a duuniya, ka saaweenə nə məbərə da magənaza, taa mahiirənə əsə, təya hərəma. ");
INSERT INTO gde_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amma tsəkəmə gəna goonə gatə dagyə, hatə pooshi məbərə da magənaza ka saaweenə, pooshi mahiirənə ka hərəmanə əsə. ");
INSERT INTO gde_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Acii ma hatə ɗii gənaaku, davə ndzaanə nəku sliŋə.” ");
INSERT INTO gde_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“Ma ginə, makə garəkuwa nə ci ka shishinə. Maɗa jamə nə ginəku, agi maɓərəha nə hə ətsa. ");
INSERT INTO gde_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","Amma maɗa pooshi ginəku ndaŋə ndaŋə, agi təkunə nə hə ətsa. Acii ha'ə, maɗa ma ɓərəətə ashiku, wata təkunə tanə, iitə saŋə ndzaanəkii də təku təkuuna?” ");
INSERT INTO gde_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“Pooshi mava ca mbee ka slənətənə ka slanjiinə bəra'i. Ka kaareenə nə ci ka əndə'i əndə, ca uuɗə tə əndə'i ənda. Ka gaɗeenə nə ci ka əndə'i əndə, ca ushapaa tə əndə'i ənda. Pooshi rəgwa ŋga paslənə tə Əntaŋfə, unə kə kavə nuunə ka alə gəna. ");
INSERT INTO gde_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","“Aciikii, wanyinə ka banə koonə, goona buurə sətə cuuna kavə aa moonə taa sətə cuuna sa koona gərə də əpinə; taa sətə cuuna umbee də purəkinə əsə, goona buurə. Mapaleemə əpinə ka zəmə də məghərəvənə kwa? Anii mapaleemə shishinə ka kəjeerəna? ");
INSERT INTO gde_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Tsaaməmə əginyinə: pooshi ratii, paa tii ka slənə cifanə, pooshi dəɓwatii əsə. Amma Dəsənuunə ətə dadagyə ca adəvə ka tii. Mapaleemuunə ka əginyinə də məghərəvənə kwa? ");
INSERT INTO gde_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Wu saŋə agyuunə ca mbee ka tsakəvə gərənə ŋga əpinaakii taa gi'u putə ŋga buurə uushi'inaakəya? ");
INSERT INTO gde_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Mi saŋə cuuna buurə haala ŋga kəjeerəna? Tsaaməmə makə sətə ci gudəzənyinə a gərə də bilə: pooshi tii ka slənənə, pooshi tii ka ɗatə kəjeerənə ka shishinətii əsə. ");
INSERT INTO gde_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","Amma, wanyinə ka banə koonə: taa ŋwaŋwə Sulayimaanu da patənə ŋga məghərəvənaakii maa, makamə ci dagwa kəjeerənə makə gudəzənyinə də bilə. ");
INSERT INTO gde_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Kə kavə Əntaŋfə kəjeerənə ka kuzhinyinə ənə ənshinə una nee, ma doorə, ənjə a ətsagi. Sakwa unə ɗii, paa ci agi vii koonə kəjeerənə kwa? Una! Gi'u nə gi'inə goonə tə Əntaŋfə! ");
INSERT INTO gde_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“Acii ha'ə, goona ənvutə noonə nə də buurə sə ŋga adənə, taa sə ŋga sanə, taa kəjeerənə. ");
INSERT INTO gde_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Acii ma uushi'iitsə patə, ənjitə mashiimə tə Əntaŋfə ca ka haŋkalatii davə. Ma Dəsənuunə ətə dadagyə, kə shii ci oo'i, ŋga'ə koonə nə patənə ŋga uushi'iitsa. ");
INSERT INTO gde_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amma, ma ŋga təkəŋwanə, kavəmə nuunə tanə ka ŋwaŋuunə ŋga Əntaŋfə, una ɗa patənə ŋga sətə mwayi ci. Maa kə ɗii unə ha'ə, ma hara uushi'iitsə patə ma'ə, ka tsakəənənə nə ci koonə. ");
INSERT INTO gde_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Acii ha'ə, goona buurə uushi'inə ŋga doorə. Acii ma doorə, tə'i uushi'inə pamə ŋga buurənə. Wa mabuurənə ŋga uusəra rəŋwə a ndzaanə anə naakii uura, goona tsəkə aamakii.” ");
INSERT INTO gde_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“Goona lagi gəŋwanə agyanə hara ənja, acii ga Əntaŋfə a lagi gəŋwanə agyanuunə noonə əsə. ");
INSERT INTO gde_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Acii ma ca, ka laginə nə ci agyanuunə makə sətə lagyuunə agyanə hara ənji noonə. Də kəŋutə gəlatuunə ka ənja, də ci nə ənjə a gəla koonə noonə əsə. ");
INSERT INTO gde_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Ka mi saŋə cii kwa tsaamə uundzə kada agi ndzəkəŋu, ha bwasee ka rintə agiku naakwa? ");
INSERT INTO gde_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Iitə saŋə mbeenəku ka banə ka ndzəkəŋu oo'i: ‘Taku kaa nya ŋgərəgi ka hə kada agiku’, yoo, wahənə da rintə agiku naakwa? ");
INSERT INTO gde_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Hə əndə kərənə ka Əntaŋfə də bəra'i! Ma ɗanəkwa, ŋgərəgi rintətsə agiku zəku'i. Ma daba'əkii, ka neenə nə hə tahu tahu bahə ha ŋgiragi uundzə kada agi ndzəkəŋu. ");
INSERT INTO gde_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“Goona vii sətə malaaɓakii ka ədiinə, acii ga təya ənə ka laakətənə tuunə. Goona kagi gəna goonə akəŋwacii dagəliinə, acii ga təya mama'əgi.” ");
INSERT INTO gde_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“Kədiimə, ka viinə nə ənji koonə sətə kədii unə. Aləmə, ka upaanə nuunə sətə alyuunə. Dzamə makuva, ka wunəginə nə ənji koonə makuva. ");
INSERT INTO gde_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","Acii taa wu patə kədii, ka viinə nə Əntaŋfə ka ci. Taa wu patə ali əsə, ka upaanə nə ci səkii. Ka wunəginə nə ənji ka əndətə dzii makuvə əsə. ");
INSERT INTO gde_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Ŋgutə əndə saŋə ahadoonə ca ŋgərə faara, ca vii ka uuzənaakii maɗa ləguyi ci buroodya? ");
INSERT INTO gde_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Anii ka ŋgərənə nə ci rəhunə, ca vii ka ci, maɗa ləguyi ci hərəfina? Pooshi. ");
INSERT INTO gde_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","Taa unə məŋgərəkikinyinə maa, kə shii unə vii ŋunyi uushi'inə ka manjeevənə goonə. Sakwa Dəsənuunə ətə dagyə ɗii, kə palee ci də vii ŋunyi uushi'inə ka ənjitə kədii aciikii. ");
INSERT INTO gde_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Ma patənə ŋga sətə cuuna moo ənjə a ɗa koonə, ɗamə ka tii ha'ə. Acii ci nə ginə ŋga *bariya da dzəgunənə ŋga anabinyinə.” ");
INSERT INTO gde_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“Ŋgərəmə matya'u rəgwa, acii ma mabwaŋə rəgwa, aagi gunə ca dzə. Ŋgufə nə dzənə davə a rəgwa, laŋə əsə nə ənji dzənə davə a rəgwa. ");
INSERT INTO gde_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amma, ma rəgwa ŋga upaa əpinə, tya'u ka shaŋə, dzawə nə dzənə davə a rəgwa. Ma ənjitə ca nə'u rəgwakii əsə, gi'u nə tii.” ");
INSERT INTO gde_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“Nəhəmə noonə nə acii majirakinə ŋga anabinyinə: ma ci təya shi aaɓii unə, makə sətə ci furətsoofanyinə a geegi ka natii nə makə bagiinə, təya dzəgərə aagitii ka tsəɓənə tə tii. ");
INSERT INTO gde_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ka shiinə nuunə tə tii dagi slənatii. Pooshi ənji ka slirəɓa pawə ŋga papawə a ənfwə dəhə uuɗa. Pooshi ənji ka slirəɓa pawə ŋga uudəvə a ənfwə kaaya əsə. ");
INSERT INTO gde_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Maa ŋunyikii nə ənfwa, ŋunyikii poonəkii. Amma, maɗa bwayakii nə ənfwa, bwayakii poonəkii. ");
INSERT INTO gde_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Pooshi ŋunyi ənfwə ka poonə bwayakii. Ha'ə əsə, pooshi bwaya ənfwə ka poonə ŋunyikii. ");
INSERT INTO gde_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Taa ŋgutə ənfwə nəndə pooshi ka poonə ŋunyikii, ka cisləginə nə ənji hisə, ənjə a kagərə aagi gunə. ");
INSERT INTO gde_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Də ha'ə, ka shiinə nuunə majirakinə ŋga anabinyinə dagi sətə cii təya slənə.” ");
INSERT INTO gde_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“A shii unə, əntaa patənə ŋga ənjitə ca ba ka nyi ‘'Ya'ə Slandana, Slandana’ nə upaa dzənə aagi ŋwaŋuunə ŋga dagyə, amma see ənjitə ca slənə sətə ci Daadə ətə dagyə a moo təya slənə. ");
INSERT INTO gde_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Maɗa kə mbu'ya uusəra ŋga ɗa gəŋwanə, ənji laŋə na ba ka nyi: ‘Slandana, Slandana, kə waazii inə waɓənə ŋga Əntaŋfə də ləməku. Də ləməku əsə lyaakagiinə ginaajinyinə laŋə, ina ɗa sə ŋga hurəshishinə laŋə əsə.’ ");
INSERT INTO gde_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Wata ma nii kya ba ka tii: ‘Paa nyi sha shii tuunə, dzəgimə aɓiiki, məza ənja!’ ” ");
INSERT INTO gde_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“Də ha'ə taa wu patə fii waɓəənaaki, ca nə'utə, kə ndzaa ci makə macicirə ənda ətə ghənyi yaakii anə pasla. ");
INSERT INTO gde_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Kə njimə vəna, huyinə nə təhwanyinə, əgənə nə məɗə də ŋgeerənə anə yikii. Amma pooshi uulii, acii agyanə pasla ghənyi ənji. ");
INSERT INTO gde_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amma taa wu patə nə əndə fii waɓəənaaki, amma, manə'utəmə ci, kə ndzaa ci makə maba ŋga ənda ətə ghənyi yaakii anə mandzənə. ");
INSERT INTO gde_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Kə njimə vəna, huyinə nə təhwanyinə, əgənə nə məɗə də ŋgeerənə anə yikii. Wata ghəɓə, ca uulagi, ma'inə a taasəənə, ca vyavinəgi dza'ə.” ");
INSERT INTO gde_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Makə uudəpaa Yeesu baaba uushi'iitsa, ənji patə, kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə nə makə sətə cii kəya dzəgunə ka tii. ");
INSERT INTO gde_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Acii də shiinaakii saakii jigunyi ci ka tii, əntaa makə sətə ci maliminatii a dzəgunə ka tii. ");
INSERT INTO gde_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Makə jimagərə Yeesu anə ɗaŋgəra, daɓaala a dzə də nə'unə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Wata əndə uyikuzənə a shi, ca gərə'waanə akəŋwaciikii, əŋki ci ka ci, “Slandana, maɗa ka luuvənə nə hə, ka mbeenə nə hə ka mbəɗəpaanə də nyi kaa nya shii ndzaanə malaaɓakii.” ");
INSERT INTO gde_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Wata Yeesu a təɗapaa ciinəkii, ca təɓətə tə ci, ca ba ka ci, “Awa, kə luuvə nyi. Mbəɗuu.” Pii wata kə dzəgi uyikuzənətə ashi əndəta. ");
INSERT INTO gde_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Yeesu a ba ka ci, əŋki ci, “Fatə ŋga'ə, kaa nya ba ka hə: Ga ha bapaa ka əndə sətsə ɗii shaŋə. Amma, ma ɗanəkwa, duu aa ha *limanə, ha ɓaarii ka ci naaku na, ca tsaamətə taa iitə nə hə. Ma daba'əkii, ha ɗa sataka makə sətə bii Muusa, kaa ənji patə a shii oo'i, kə mbə'i hə tanyi.” ");
INSERT INTO gde_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Makə dzəgərə Yeesu aasəkə vəranə ŋga Kafarənahumə, wata gawə ŋga soojiinə ŋga ənji Rooma a əntsahə aaɓiikii, soojatə a kədii tsakənə tə ci, ");
INSERT INTO gde_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","əŋki ci, “Slandana, tə'i lawaraaki gwakə asii. Paa ci ka mbee ka wiinə acii agi ɗanə nə bwanea tə ci laŋə laŋə.” ");
INSERT INTO gde_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","Yeesu a ba ka ci, “Ka dzənə nə nyi ka mbəɗəpaanə də ci.” ");
INSERT INTO gde_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Wata gawə ŋga soojiitə a ba ka Yeesu, əŋki ci, “Slandana, mambu'umə nyi bahə dzənaaku aa haki aasii. Amma, maɗa waɓi hə rəŋwə dyaŋə, ka mbəɗənə nə lawaraaki. ");
INSERT INTO gde_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Ma bii nyi ha'ə, acii nyi maa, tə'i gayinə akəŋwaciiki, tə'i soojiitə cii kya ɗa ka tii gawuunə əsə. Ka mbeenə nə nyi ka banə ka əndə'i əndə: Duu aa hatə! wata ca palə. Nya ba ka əndə'i əndə: Shiwa! ca shi. Nya ba ka mavaaki: Slənuu sətsə ha'ə! ca slənətə ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Makə fii Yeesu waɓəətsa, kə ɗii ka ci ka sə ŋga hurəshishinə. Wata ca ba ka ənjitə ca nə'u tə ci, əŋki ci, “Tantanyinə cii kya ba koonə, taa ahada ənji *Isərayiila maa, paa nyi sha lapaa əndətə gi'i tə nyi makə ŋga əndəna. ");
INSERT INTO gde_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","Wanyinə ka banə koonə, tə'i hara slikərənə laŋə na ma'ya da tsaaŋwə i da waka, təya dzə ka ndzaanə dasə ka hakii tii da i Ibərahiima, Isiyaaku da i Yakubu, təya zəmə əndzanə ka hakii agi ŋwaŋuunə ŋga dagyə. ");
INSERT INTO gde_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","Amma, ma ənjitə dəɓee ka tii nə ŋwaŋuunəkii, ka əjiginə nə ənji tə tii aagi təkunə. Davə tuunətii, təya tsəɓə linyinətii.” ");
INSERT INTO gde_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Wata əŋki Yeesu ka ŋwaŋwə ŋga soojiita, “Duu saaku aasii. Ma sətə vii hə gooŋga, ka ɗanə nə ənji ka hə.” Wata kə mbə'i lawarə ŋga soojatə agi saa'ita. ");
INSERT INTO gde_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Yoo, Yeesu a dzə aa ha Piita aasii. Ma gi ci, gwakə nə sərəhu ŋga Piita minəkii. Kə tsəfəgi shishinətə iza'u. ");
INSERT INTO gde_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Makə nee ci ka ki ha'ə, wata ca təɓətə ciinətə. Wata iza'unə ŋga shishinətə a əpigi. Miitə a maɗətə, kya gwaŋə ka ɗa ka ci zəma. ");
INSERT INTO gde_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Ma ətsə kulagərənə ŋga uusəra, kə kyaara ənji ka Yeesu ənji ginaaji laŋə. Ca lyaakagi ginaajinyinə də waɓənə tanə, ca mbəɗəpaa də hara ənji bwanea patə. ");
INSERT INTO gde_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Ma ɗii ha'ə, kaa sətə bii *anabi Isaaya a ndzaa ka tantanyinə ətə bii ca, “Ci də naakii nə ŋgərəgi ghatə ndzaanə gaamə jamə, ca luupaa taamə acii bwaneanyinə gaamə.” ");
INSERT INTO gde_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Makə nee Yeesu ka laŋənə ŋga daɓaala aɓiikii, wata ca ba ka lyawarənaakii, “Taŋəgyaamə aa taŋəgi uunəva.” ");
INSERT INTO gde_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Wata əndə'i maləmə a əntsahətə aaɓiikii, ca ba ka ci, “Maləma, taa aama gi hə patə ka nə'unə nə nyi tə hə.” ");
INSERT INTO gde_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","Yeesu a ba ka ci, “Ma gwahyanə, tə'i gu'unyinatii. Ha'ə nə əginyinə əsə, tə'i kuvənyinatii. Amma, ma nyi, *Uuzənə ŋga ənda, pooshi haaki bahə ŋga kapaa taŋgalaki davə.” ");
INSERT INTO gde_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Wata əndə'i əndə nə'unə tə ci a ba ka ci, “Slandana, taku kaa nya dzə ka ŋgəɗəgi tə daadə zəku'i.” ");
INSERT INTO gde_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Yeesu a ba ka ci, “Nyi'wawə tə nyi. Wa maməətə ənjə a ŋgəəɗə maməətə ənjatii.” ");
INSERT INTO gde_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Wata Yeesu a ndərəvə aasəkə kumbawala, lyawarənaakii a ndərəvə atsakii. ");
INSERT INTO gde_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Pii wata mandalə məɗə a ndzaŋə kyanə anə uunəva də ŋgeerənə, gi'u mbərə'i kaa kumbawalə a lipəgərə saakii. Amma, ma Yeesu, ka ŋunyinə nə ci saakii. ");
INSERT INTO gde_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Wata lyawarənaakii a əntsahətə aaɓiikii, təya maɗee ka ci, əŋki tii ka ci, “'Ya'ə Slandana, luupaa taamə! Wanaamə ka zanə!” ");
INSERT INTO gde_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Wata ca ba ka tii, “Acii mi ŋgwalyuunə ha'ə kwa? Matəkii nə vii gooŋga goonə!” Wata ca maɗətə, ca la ŋguruunə ka məɗəta da ka ma'iita. Wata shakətə təya ənəgi, təya dədəkə kyakya'ə. ");
INSERT INTO gde_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Tii patə, kə ɗii ka tii ka sə ŋga hurəshishinə. Təya ba ahadatii: “Tsarə ŋga ŋgutə əndə ənə kwa? Taa məɗə da uunəvə maa, agi fanə nə tii tə ci.” ");
INSERT INTO gde_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Yoo, kə mbu'i Yeesu aanə hanyinə ŋga Gadara ataŋəgi uunəva. Wata ənji bəra'i a shigi ahada gu'u ənja, ənji ginaaji nə tii. Pooshi ənji ka wiinə davə a rəgwa, acii sə ŋga ŋgwalənə nə tii ka shaŋə. Təya lapaa tə Yeesu, ");
INSERT INTO gde_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","pii wata təya wagi vurənə, əŋki tii, “'Ya'ə *Uuzənə ŋga Əntaŋfə, mi cii kwa alə ashiinə kwa? Kə shi hə ka ciɓənə diinə zəku'i, taabu'u mbu'yanə saa'i kwa?” ");
INSERT INTO gde_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Ma davə kədəhə gi'u, tə'i gəranə ŋga dagəliinə ca zəmə. ");
INSERT INTO gde_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","Wata ginaajinyiitə a kədii acii Yeesu, təya ba, “Maɗa kə lakəgi hə tiinə, bwasee keenə, ina dzəgərə aashi dagəliita.” ");
INSERT INTO gde_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Əŋki Yeesu ka tii, “Paləmə!” Wata təya shigi ashi ənjita, təya palə, təya dzəgərə aashi dagəliita. Patənə ŋga dagəliinəkii, təya huyi, təya kwaalagərə aagi ma'inə, təya zagi dza'ə. ");
INSERT INTO gde_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Wata magəriinə a huyi aasəkə vəranə, təya dzə ka ba patənə ŋga sətə slənyi da sətə ɗii tə ənji ginaajita. ");
INSERT INTO gde_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Pii wata patənə ŋga vəranəkii, kə shigi tii ka guŋunə da Yeesu. Makə nee tii ka ci, wata təya kədii aciikii kaa ca maɗəgi ka tii anə hanyinatii. ");
INSERT INTO gde_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Wata Yeesu a ndərəvə aasəkə kumbawalə, ca taŋəgi uunəva, ca ənə saakii aa hakii aa vəra. ");
INSERT INTO gde_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Hara ənjə a kira ka ci əndə'i mahurəməsə əndə pərəɓə asəkə ədzaakii. Makə nee Yeesu ka gi'inatii tə ci, wata ca ba ka mahurəməsə əndəta, “Uuzənaaki, tsakuu ɗa gazhi'waanə! Kə upaa hə tifyaginə ŋga 'waslyakəənaaku.” ");
INSERT INTO gde_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Makə fii *maliminə ŋga bariya ha'ə, wata təya ndzaŋə waɓənə agi hiimatii, təya ba, “Ma əndətsa, kə geegi ci ka naakii nə makə Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Asee, kə shii Yeesu sətə ci təya hiima a ədzəmətii patə. Əŋki ci ka tii, “Ka mi də tsarə ŋga bwaya hiimatsə a ədzəmuunə ha'ə kwa? ");
INSERT INTO gde_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Ŋgutə palee də ŋgufənə saŋa? Gəɗə banə ka ci oo'i, kə upaa hə tifyaginə ŋga 'waslyakəənaaku nii, anii gəɗə banə ka ci, maɗuu, wiiwa? ");
INSERT INTO gde_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","Amma takumə kaa nya ɓaarii koonə oo'i, ma nyi Uuzənə ŋga ənda, tə'i nyi da baawəɗa ŋga tifyagi 'waslyakəənə ŋga ənji ganə a duuniya.” Wata Yeesu a ba ka mahurəməsə əndəta, “Maɗətə, ŋgəruu ədzaaku, ha palə saaku aasii.” ");
INSERT INTO gde_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Əndətə a maɗətə, ca palə saakii aasii. ");
INSERT INTO gde_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Makə nee ənji ha'ə, kə ŋgwali tii, wata təya dəla də Əntaŋfə putə ŋga vii tsarə ŋga baawəɗatsə ka ənja. ");
INSERT INTO gde_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Yoo, Yeesu a maɗə, ca palə. Wata ca lapaa tə əndə luu tsəka ətə ɗii ləməkii Mata, ci dasə asəkə kuvə ŋga slənaakii. Əŋki Yeesu ka ci, “Shiwa atsaki.” Wata hatsə Mata a maɗətə, ca nə'u tə ci. ");
INSERT INTO gde_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Wata Yeesu a dzə ka zəmənə aa ha Mata aasii. Ma ca zəmə, kə shi hara ənji luu tsəkə laŋə da hara ma'waslyakə ənji laŋə, təya ndzaa ka hakii tii da i Yeesu da lyawarənaakii ka zəmənə. ");
INSERT INTO gde_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Neenə ŋga *Farisanyinə ha'ə, wata təya ləgwa ama *lyawarənə ŋga Yeesu, əŋki tii, “Mi saŋə ɗii ci maləmə goonə a zəmə da ənji luu tsəka da i hara ma'waslyakə ənji əsa?” ");
INSERT INTO gde_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Asee, kə fii Yeesu təya ba ha'ə. Wata əŋki ci ka tii, “Pooshi mandandaŋə ənji ka alə kuzəka, see ənji bwanea. ");
INSERT INTO gde_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","See a shii unə taa mi ci malaaɓa ləkaləkatə a moo banə zəku'i ətə bii Əntaŋfə tuu'ina, ‘Nəhə təgunuunə ŋga ənji mwayi nyi, əntaa ɗa ka nyi sataka də daba.’ Acii ha'ə, ma shi nyi aasəkə duuniya, ka 'waa'wanə tə ma'waslyakə ənji aaɓiiki, əntaa kaa nya 'wa tə ənjitə ca slənə uushi də rəgwakii.” ");
INSERT INTO gde_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Ma daba'əkii, kə shi *lyawarənə ŋga Yoohana aaɓii Yeesu, təya ləgwa ka ci, əŋki tii, “Ya makə agi ɗanə niinə suumaya, inə da i Farisanyinə, mi saŋə ɗii pooshi lyawarənaaku ka ɗa suumaya?” ");
INSERT INTO gde_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Yeesu a ənigi ka tii də waɓənə agyanə naakii nə, əŋki ci, “Yaci tə'i guviinə ŋga dagwa maɗanə ətə bii ci ka tii da məhuraakəya, maɗa kə gi tii ka luu maɗanəkəya, ka ndzaanə nə tii də maɓəzəsəkə aɓii dagwa maɗanə kwa? Pooshi! Amma kadə nə uusəra mbu'ya ətə nə ənjə a ŋgərəgi dagwa maɗanə aɓitii, saa'ikii nə təya ɗa suumaya. ");
INSERT INTO gde_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“Pooshi əndə ka mbakə iirə kəjeerənə də kurakii, acii ka mushataginə nə iirə kəjeerənə saakii, ca bwasee ka kurakii, ca tsakə ɗanə bwaŋə. ");
INSERT INTO gde_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","“Pooshi əndə əsə ka ciirə kura ma'i inaba aasəkə iirə mbuurə kuvə'unə. Maɗa kə ɗii ha'ə, ka taginə nə mbuurə kuvə'unəkii acii əbunə ŋga ma'i inaba. Wata inaba a əjagi saakii, mbuurə kuvə'unə a saawagi əsə. Amma aasəkə kura mbuurə kuvə'unə ciirənə ənji kura ma'i inaba, təya ndzaa satii mbərə mbərə.” ");
INSERT INTO gde_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Ma Yeesu agi waɓənə ka ənja, wata əndə'i gawə ŋga *Yahudiinə a shi aaɓiikii, ca gərə'waanə akəŋwaciikii, ca ba ka ci, “Kə əntəgi uuzənaaki əndzə'i, amma, shiwa kwadzaaŋwə, kaa ha dzə ka kavə ciinə agyanətə, kya ənə ka upaa əpinə.” ");
INSERT INTO gde_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Makə fii Yeesu ha'ə, wata ca maɗətə, ca nə'u tə ci. Lyawarənaakii a palə atsakii. ");
INSERT INTO gde_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","Ma dava, tə'i əndə'i minə ciɓee bwanea ka ki fəzə pu'u aji bəra'i. Uushi'inə nja ɗa tə ki. Wata kya əntsahətə daba'ə Yeesu, kya təɓətə kəjeerənaakii, ");
INSERT INTO gde_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","kya dzə də hiimanə agi haŋkalatə tuu'inə, “Maɗa kə təɓətə nyi taa wata kəjeerənaakii, ka mbəɗənə nə nyi.” ");
INSERT INTO gde_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Wata Yeesu a zə'ugi, ca nee ka ki, ca ba ka ki, “Uuzənaaki, tsakuu ɗa gazhi'waanə! Kə mbə'i hə putə ŋga gi'inaaku tə nyi.” Shiku ha'ə, wata kə mbə'i miita. ");
INSERT INTO gde_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Makə mbu'i Yeesu aa ha gawəta, ca dəməgərə aa hakii aasii, ca lapaa ənji tuu wa da ənji laŋə, təya ŋgəərə ma. ");
INSERT INTO gde_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Wata ca ba, “Dəməgimə patə aa mayi! Acii əntaa əntənə əŋki uundzə rəməətsa, amma ŋunyinə cifə ki.” Wata təya ŋusəgi tə ci. ");
INSERT INTO gde_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","Amma, pii makə səbagi ənji tə daɓaala aa mayi, wata Yeesu a dəməgərə aaɓii mantə uuzəəta, ca kəsə tə ki ka ciinətə, wata hatsə kya maɗətə. ");
INSERT INTO gde_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Kə huwugi habarakii taa dama patə anə hanyinəkii. ");
INSERT INTO gde_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Yoo, Yeesu a maɗə gatə, ca palə. Wata muurəfinə bəra'i a dzə də nə'unə tə ci, təya maɗee ka uuratii, təya dzə də banə, “Jijinə ŋga *Dawuda, nəhuu təgunuunə geenə!” ");
INSERT INTO gde_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Makə dzəgərə Yeesu aasəkə ya, wata muurəfiitə bəra'i a dzə aaɓiikii, ca ba ka tii, “Kə gi'yuunə tə nyi oo'i, ka mbeenə nə nyi ka mbəɗəpaanə duunə kwa?” Əŋki tii, “Awa, ka mbeenə nə hə, 'ya'ə Slandana.” ");
INSERT INTO gde_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Wata Yeesu a təɓətə ginətii, ca ba, “Makə sətə gi'yuunə tə nyi, wa ca ɗa ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Ginətii a wunəgi. Ca dzaləpaa tə tii oo'i, ga təya bapaa habarakii taa ka wu. ");
INSERT INTO gde_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Amma, makə pyalə tii satii, təya dzə ka ənsləpaa habarakii anə hanyinəkii patə. ");
INSERT INTO gde_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Ma ənjitə a palə satii, wata hara ənjə a kira ka Yeesu əndə'i kadəguləma. Ma ca, paa ci ka mbee ka waɓənə, acii tə'i ginaaji ashikii ");
INSERT INTO gde_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Amma Yeesu a lyakagi ginaajitə anə əndəta, pii wata əndətə a waɓə. Kə ɗii ka sə ŋga hurəshishinə ka ənji patə, təya ba, “Pooshi uushi sha ɗii ha'ə makə ətsa anə hanyinə ŋga *Isərayiila shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Farisanyinə a ba natii, əŋki tii, “Ŋwaŋwə ŋga ginaajinyinə vii ka ci baawəɗa ŋga lyaakagi də ginaajinyinə.” ");
INSERT INTO gde_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Yoo, kə giigi Yeesu aasəkə patənə ŋga madiigərə vəranyinə da uuji vəranyinə, ca dzəgunə asəkə *kuvə də'wanyinə, ca waaza Ŋunyi Habara agyanə *ŋwaŋuunə ŋga Əntaŋfə, ca mbəɗəpaa də taa ŋgutə tsarə ŋga bwaneanyinə. ");
INSERT INTO gde_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Makə nee ci ka daɓaala, kə nyihə ci təgunuunatii, acii wata shitə nə tii ha'ə, makə bagiinə yadə magəra. Pooshi əndə tsakənə tə tii. ");
INSERT INTO gde_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","Wata ca ba ka lyawarənaakii, əŋki ci, “Laŋə nə slənə cifanə, amma gi'u nə ənji slənəkii. ");
INSERT INTO gde_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","Acii ha'ə, ɗamə də'wa ka Slanda ra, kaa ca tsakə sləkeenə ka ənji sləna, təya shi ka slənə cifanə.” ");
INSERT INTO gde_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Ma daba'əkii, wata Yeesu a 'waa'watə lyawarənaakii pu'u aji bəra'i, ca vii ka tii baawəɗa ŋga lyaakagi də ginaajinyinə, təya mbəɗəpaa də taa ŋgutə tsarə ŋga bwanea əsə. ");
INSERT INTO gde_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Wiinə ləmənyinə ŋga masləkee ənji pu'u aji bəra'i: ŋga 'watəginə ci nə Simoonə ətə ci ənjə a 'wa Piita tii da ndzəkəŋuci waatoo Andərawəsə; i Yakubu tii da ndzəkəŋuci waatoo Yoohana, manjeevənə ŋga Zabadiya nə tii; ");
INSERT INTO gde_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Filibusə da Barətalamawusə; Tooma da Mata əndə luu tsəka; Yakubu uuzənə ŋga Haləfa da Tadawusə; ");
INSERT INTO gde_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simoonə əndə moo dimwaanə ŋga hanyinaakii da Yahuda Isəkariyootə. Ma uudəpaa ba'a, ci vii tə Yeesu aacii ənja. ");
INSERT INTO gde_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Ma lyawariitsə pu'u aji bəra'i ŋga Yeesu, kə sləkee ci ka tii də banə oo'i, “Goona dzə aanə hanyinə ŋga harii slikərənə taa aasəkə vəranyinə ŋga *Samariya. ");
INSERT INTO gde_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Amma aa ha ənji *Isərayiila dzənuunə, acii makə maza bagiinə nə tii. ");
INSERT INTO gde_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Dəmə ka waazanə, una ba: ‘Kədəhə nə Əntaŋfə ka ɗa ŋwaŋuunaakii.’ ");
INSERT INTO gde_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Mbəɗəpaamə də ənji bwanea, una maɗee ka maməətə ənja, una mbəɗəpaa də ənji uyikuzəna, una laakəgi ginaajinyinə. Də zaɓə liwuunə, viimə də zaɓə əsə. ");
INSERT INTO gde_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Goona dzə da i kwaɓa a lipoonə. ");
INSERT INTO gde_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","Goona dzə da i mbuurə, una dzə ka jahaŋgala, goona ŋgərəənə əndə'i kəjeerənə, goona ŋgərəənə əndə'i ɓiɓinə, taa zala wiigi'inə, goona ŋgərəvə aacii unə. Acii ma əndə sləna, kə dəɓee ənjə a vii ka ci zəmaakii. ");
INSERT INTO gde_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Maɗa kə lapaa unə vəranə, dzəgərəmə aasəkəkii, una alə əndətə ca moo luunə tuunə, una ndzaanə gakii, see saa'itə nuuna bwasee ka vəranəkii. ");
INSERT INTO gde_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Taɗa ŋgutə yi gimuunə aa dəvə patə, ma banuunə ŋga təkəŋwanə: ‘A ndzaa unə da jamənə.’ ");
INSERT INTO gde_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Maɗa kə liwə slanjii yikii tuunə, wa ndzaanə jamə ətə bii unə a ndzaa davə asii. Amma, maɗa maluumə tii tuunə, yoo, ŋgərəənəmə jamənə goonə. ");
INSERT INTO gde_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Maɗa pooshi ənji liwə tuunə taa fii waɓəətə gi a moonə, shigimə sə goonə davə asii taa asəkə vəranəkii, una gwa'agi bərəbərə ŋga hakii a səɗuunə. Ci na ɓaarii oo'i, maɗamə tii ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Tantanyinə cii kya ba koonə: ma uusəra ŋga ɗa gəŋwanə, kadə nə gəŋwanə ŋga ənji vəranəkii a palee ka ŋga ənji *Sadooma da ŋga ənji *Gwamoora də iza'unə.” ");
INSERT INTO gde_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“Fatəmə, wanyinə ka sləkeenə koonə makə sətə ci bagiinə a dzəgərə aagi furətsoofanyinə. Aciikii, see a ndzaa unə macicirəkii, una ndzaa yadə saaweenə ka uushi'inə makə kurəkutiinə. ");
INSERT INTO gde_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Nəhəmə noonə na, acii tə'i ənji na kəəsə tuunə, təya kərə aakəŋwacii gəŋwanə, təya fəslə tuunə asəkə *kuvə də'wanyinə. ");
INSERT INTO gde_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ka kərənə nə ənji tuunə aakəŋwacii meeminə putə ŋga nə'unə goonə tə nyi. Ka ɗanə nə ətsə ha'ə koona shii mbee ka ba Ŋunyi Habara ka tii da ka ənjitə əntaa Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Maɗa kə kirə tii tuunə aakəŋwacii gəŋwanə, goona ənvutə noonə nə ka buurənə agyanə makə sətə nuuna waɓə taa sətə nuuna dzə ka banə ka tii. Acii maɗa kə mbu'i saa'ikii, ka shiinə nuunə sətə nuuna ba. ");
INSERT INTO gde_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Acii ma sətə nuuna ba, əntaa noonə, amma dacii Ma'yanə ŋga Dəsənuunə na shi. Ci na waɓə da moonə. ");
INSERT INTO gde_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","“Kadə nə ndzəkəŋunə a ŋgərə tə ndzəkəŋuci, ca vii ka ɓələginə. Dəsənə manjeevənə əsə, ka ɗanə nə tii ha'ə. Ha'ə ɗanə nə manjeevənə əsə, ka viinə nə tii tə mapoo tə tii ka ɓələginə. ");
INSERT INTO gde_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Taa wu patə, kadə nii kəya ushapaa tuunə putə ŋga nə'unə goonə tə nyi. Amma taa wu patə sə'watə ciɓənyinəkii ca'ə ka muudinə, ka upaanə nə ci luupaanə. ");
INSERT INTO gde_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Maɗa kə ciɓee ənji koonə asəkə əndə'i vəranə, huyimə sə goonə ka əndə'i. Acii tantanyinə cii kya ba koonə: pooshi unə ka uudəpaa gəŋutəgi də vəranyinə ŋga *Isərayiila patə, taabu'u shinaaki, nyi *Uuzənə ŋga Ənda. ");
INSERT INTO gde_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“Pooshi lawarə ka paleenə ka maləmaakii də məghərəvənə. Ha'ə nə mava əsə, paa ci ka paleenə ka slandanəkii. ");
INSERT INTO gde_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Kə mbu'i ha'ə kaa lawarə a ndzaa mbərə mbərə tii da maləmaakii. Ha'ə nə mava əsə, ca ndzaa mbərə mbərə tii da slandanəkii. Maɗa kə 'wii ənji tə slanda yi də Byaləzabulə, ləmətə palee də bwaya bwayaanə 'wanə ənji də ənji yaakii.” ");
INSERT INTO gde_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“Acii ha'ə, goona ŋgwalə ənja. Taa mi patə nəndə ma'umbeekii, kadə na shigi agyə. Taa mi patə nə sətə pooshi ənji shii, kadə nə ənjə a shii. ");
INSERT INTO gde_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Ma sənə cii kya ba koonə ka təkutəkunə, bagimə ka macamə ha. Ma sətə bavə ənji koonə aa limuunə də matatahinə, baabagimə paŋgəraŋə paŋgəraŋə ka ənja. ");
INSERT INTO gde_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Goona ŋgwalə acii ənja. Acii wata tə ba shishinə mbeenə nə tii ka ɓələginə, amma, paa tii ka mbeenə ka ɓələgi əpinə. Amma ŋgwaləmə tə Əntaŋfə. Ci nə əndə da baawəɗa ŋga zamaginə də ba shishinə patə da əpinə agi gunə. ");
INSERT INTO gde_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Əntaa bəra'i ci ənjə a vii əginyinə ka kwaɓa rəŋwə kwa? Amma patə da ha'ə, pooshi taa rəŋwə agitii ca əntə, yadə luuvənə ŋga Əntaŋfə Dəsənuunə. ");
INSERT INTO gde_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","Taa shiŋkinə ŋga nuunə maa, maɓaanakii patə acii Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","Acii ha'ə, goona ŋgwalə, kə palee unə ka əginyinə patə də məghərəvənə.” ");
INSERT INTO gde_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“Maɗa kə bagi əndə paŋgəraŋə akəŋwacii ənji oo'i, naaki nə ci, nyi maa, ka banə nə nyi paŋgəraŋə akəŋwacii Daadə dadagyə oo'i, naaki nə ci. ");
INSERT INTO gde_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amma, ma əndətə kaaree ka nyi akəŋwacii ənja, nyi maa, ka kaareenə nə nyi ka ci akəŋwacii Daadə dadagyə.” ");
INSERT INTO gde_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“Goona nəhə noonə makə jamənə shi nyi ka kiranə aasəkə duuniya. Aa'a, əntaa jamənə kira nyi, panə kira nyi. ");
INSERT INTO gde_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","Ma shi nyi, ka mbəzeenə ka uuji ŋguyirənə da dəsənətii, uuji makinə da məsənətii, maɗanə da sərəhwatə əsə. ");
INSERT INTO gde_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Ənjitə asəkə yi rəŋwə na ndzaanə ka ənji daawaanə ŋga natii na. ");
INSERT INTO gde_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“Taa wu patə uu'i tə dii taɗa tə məci palee ka nyi, mambu'umə ci bahə ndzaanə ka lawaraaki. Taa wu patə uu'i tə uundzə ŋguraakii taa uncitə minaakii palee ka nyi, mambu'umə ci bahə ndzaanə ka lawaraaki. ");
INSERT INTO gde_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Ma əndətə pooshi ŋgirə ənfwaakii ŋga gwa'avənə tə ci aashikii, ca nə'u də nyi, mambu'umə ci bahə ndzaanə ka lawaraaki. ");
INSERT INTO gde_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Taɗa wu patə ɗii gazhi'waanə ŋga luupaa əpinaakii, zamaginə cii kəya zamagi ətsa. Amma, taɗa wu patə zamagi də əpinaakii putə ŋga nə'unə tə nyi, ka upaanə nə ci bwatyakii.” ");
INSERT INTO gde_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“Taa wu patə liwə tuunə, tə nyi liwə ci ətsa. Taa wu patə liwə tə nyi əsə, tə Əndətə sləkee ka nyi liwə ci ətsa. ");
INSERT INTO gde_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Taa wu patə liwə tə *anabi ŋga Əntaŋfə acii ɗii ci ka anabi ŋga Əntaŋfə, ka upaanə nə əndəkii shikwa makə sətə ci anabi a upaa. Ha'ə əsə, taa wu patə liwə ŋunyi ənda acii ɗii ci ka ŋunyi ənda, ka upaanə nə ci shikwa makə ŋga ŋunyi ənda. ");
INSERT INTO gde_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Tantanyinə cii kya ba koonə: taa wu patə ndii ma'inə taa ka moodəba'a agi ənji nə'unə tə nyi acii ɗii ci ka lawaraaki, ka upaanə nə ci shikwakii.” ");
INSERT INTO gde_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Makə uudəpaa Yeesu baabagi waɓəətsə ka lyawarənaakii pu'u aji bəra'i, wata ca maɗə gatə, ca palə ka dzəgunənə da waazanə asəkə makədəhə vəranyinə. ");
INSERT INTO gde_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Ma Yoohana, əndə ɗa bapətisəma, mapa'əkii nə ci a furəshina. Makə fii ci uushi'iitə ci *Aləmasiihu a ɗaaɗa, wata ca sləkee ka hara lyawarənaakii aaɓiikii. ");
INSERT INTO gde_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Təya dzə aaɓiikii, uu'i tii ka ci, “Ma bii Yoohana kwaa, hə nə əndətə na shi nii, anii a gəreenə əndə'i əndə pama?” ");
INSERT INTO gde_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","Yeesu a ba ka tii, “Ənəmə, una dzə ka banə ka Yoohana sənə cuuna fa da sənə cuuna nee. ");
INSERT INTO gde_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Waatoo, agi wuunənə nə ginə ŋga muurəfinə, agi wiinə nə mahurəməsə ənja, ənji uyikuzənə əsə, agi mbəəɗənə nə tii. Agi wuunənə nə liminə ŋga kadəguləminə, agi maɗeenə nə ənji ka maməətə ənja, agi waazanə nə ənji Ŋunyi Habara ka maaghiinə əsə. ");
INSERT INTO gde_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Tə'i barəkaanə ashi əndətə pooshi na unee ka nə'unə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Ma saa'itə *lyawarənə ŋga Yoohana a palə satii, Yeesu a ndzaŋə waɓənə ka daɓaala agyanə Yoohana, əŋki ci, “Ya saa'itə gyuunə aaɓii Yoohana aagi bilina, mi saŋə mwayi unə neena? Kuzənə ətə ca ba'agi agi məɗə kwa? ");
INSERT INTO gde_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Aa mi saŋə gyuunə ka caamana? Ka caama əndətə ŋgii dagwa kəjeerənə kwa? Ma ənjitə ca ŋga tsarə kəjeerənə ha'ə, agi ənji ŋga ŋwaŋwə nə tii. ");
INSERT INTO gde_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Bamə ka nyi: mi gyuunə ka caamanə kwa? *Anabi gyuunə ka caamanə kwa? Ha'ə tanyi, sətə palee ka anabi gyuunə ka caamanə. ");
INSERT INTO gde_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Acii ci nə əndətə waɓi malaaɓa ləkaləkatə agyanəkii. Ma bii Əntaŋfə: ‘Wanyinə ka sləkeenə ka masləkee əndaaki, kaa ca ta ka hə kəŋwanə, ca haɗatəgi ka hə də rəgwa, taabu'u nii kwa dzə.’ ” ");
INSERT INTO gde_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Yeesu a tsakə banə, əŋki ci, “Tantanyinə cii kya ba koonə: ma Yoohana əndə ɗa bapətisəma, pooshi ənji sha pwayi əndə ganə a duuniya ətə palee ka ci. Amma, ma əndətə palee də uundzuundzuunə agi ŋwaŋuunə ŋga dagyə, kə palee ci ka Yoohana. ");
INSERT INTO gde_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","'Watəginə ka zamana ŋga Yoohana ca'ə mbu'ya ka əndzə'i, ha'ə nə ŋwaŋuunə ŋga dagyə agi paka'ə də purətə haŋkaliinə. Agi ɗa gazhi'waanə ŋga saaweenə nə tii. ");
INSERT INTO gde_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Patənə ŋga anabiinə da bariya ŋga Muusa, kə ɗii tii anabaakwaanə ha'ə mbu'ya zamana ŋga Yoohana. ");
INSERT INTO gde_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","Maɗa ŋga'ə koonə nə luuvənə, ma Yoohana, ci nə *Iliya ətə bii malaaɓa ləkaləkatə agyanəkii oo'i, ka shinə nə ci. ");
INSERT INTO gde_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Ma əndətə da liminə ŋga fanə, wa ca fa. ");
INSERT INTO gde_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“Amma, də mi saŋə mbərə mbərətəginəki də ənji ŋga zamanana? Makə manjeevənə təya ɓuurə asəkə luuma nə tii, təya 'waa'wa hara manjeevənə makə tii, ");
INSERT INTO gde_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","təya ba: ‘Kə əgiinə koonə uuɗaləma; pooshi unə ujə. Kə kii inə koonə wanyanə ŋga wa, amma, matuumuunə.’ ");
INSERT INTO gde_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Ma bii nyi ha'ə, acii makə shi Yoohana, kə ɗii ci suumaya, paa ci nja sa ma'i inaba. Taa wu patə, kə bii ci: ‘Əndə gu'wə nə ci!’ ");
INSERT INTO gde_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Amma makə shi nyi naaki, nyi *Uuzənə ŋga ənda, agi adənə nə nyi zəma, nya sa ma'i inaba. Kə bii ənji ka nyi: ‘Tsaaməmə tə əndətsa! Bwaŋkara nə ci, masa ma'i inabi, guva ŋga ənji luu tsəka da hara ma'waslyakə ənji nə ci!’ Patə da ha'ə, ma hiima ŋga Əntaŋfə, agi neenə nə ənji ka tantanyinəkii dagi slənaakii.” ");
INSERT INTO gde_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Ma vəranyiitə ɗii Yeesu sə ŋga hurəshishinə laŋə asəkətii, pooshi tii unee ka ɗa 'waslyakəənə. Wata Yeesu a ndzaŋə wazənə ka tii. ");
INSERT INTO gde_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","Ca ba, “Kə ɗii anuunə, ənji Koorazinə, kə ɗii anuunə, ənji Batəsayida! Acii maci ma sə ŋga hurəshishiitə ɗaaɗii asəkə vəranyiitsə goonə, də Tiira da də Sidoonə ɗii, kaɗa kə ŋgaaŋgii tii dəgəjinyinə, təya ndzaanə agi əntəɗaka ka ɓaariinə oo'i, kə baa tii ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Amma, wanyinə ka banə koonə: ma uusəra ŋga ɗa gəŋwanə, kadə nə gəŋwanə goonə a palee ka ŋga ənji Tiira da ŋga ənji Sidoonə də iza'unə. ");
INSERT INTO gde_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Ya unə, ənji Kafarənahumə, ma nuunə ka banə saŋa, kadə ndərənə nuunə aadəgyə kwa? Pooshi unə ka ndərənə. Aagi gutə suŋwə kagərə nə ənji tuunə! Acii maci ma sə ŋga hurəshishiitə ɗii ənji koonə, ka ənji *Sadooma ɗii ənji, kaɗa ma'ə vəranəkii ca'ə ənshinə. ");
INSERT INTO gde_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Amma, wanyinə ka banə koonə: ma uusəra ŋga ɗa gəŋwanə, gəɗə təgunuunə ŋga ənji hanyinə ŋga Sadooma nə Əntaŋfə a nee acii noonə.” ");
INSERT INTO gde_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Ma ka ətə saa'i, wata Yeesu a ba, “'Ya'ə Daada, Slandanə ŋga dadagya da ŋga duuniya, kə kuyirii nyi tə hə, acii ma sətə hiwee hə acii ənjitə shii uushi'inə da ənji hiima, kə ɓaarəgi hə ka ənji saakii. ");
INSERT INTO gde_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Ha'ə ɗii, Daadə, acii ha'ə makə ətsə kaɗeesəkə ka hə.” ");
INSERT INTO gde_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Wata əŋki ci ka ənja, “Patənə ŋga uushi'inə, aaciiki ba'avə Daadə. Pooshi əndə shii tə nyi, maɗaamə Daadə. Ha'ə əsə nə Daadə, pooshi əndə shii tə ci, maɗaamə nyi da ənjitə ta'i nyi kaa nya ɓaariigi ka tii tə ci. ");
INSERT INTO gde_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Shoomə aaɓiiki, unə ənə zhaarə acii mazəzəkə kərənə, kaa nya vii koonə əpisəka. ");
INSERT INTO gde_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Luumə dzəgunənaaki, una nə'u dərəpaaki. Acii pu'u nə səkəki. Paa nyi ka ka uushi aa səkəki. Ka upaanə nuunə əpisəka. ");
INSERT INTO gde_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Acii ma dzəgunənaaki ənə cii kya vii koonə, ŋgufə. Ma kərəənə cii kya kaanə koonə əsə, katsatsa'ə.” ");
INSERT INTO gde_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Ma ka ətə saa'i, Yeesu a pitəgi da səkərə, waatoo rə ŋga aləkamaara. Ma uusərakii, uusərə ŋga əpisəka. Ma lyawarənaakii, kə ɗii maɗəfənə tə tii. Wata təya dzə də ɓiiyiinə aləkamaara, təya tsəɓə. ");
INSERT INTO gde_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Makə nee *Farisanyinə ka tii, wata təya ba ka Yeesu, “Tsaamuu! Watiitsə lyawarənaaku ka ɗaaɗa sətə maviimə *bariya rəgwa ŋga ɗanə uusərə ŋga əpisəka.” ");
INSERT INTO gde_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Əŋki Yeesu ka tii, “Pooshi unə jaŋgii sətə ɗii *Dawuda tii da ənjaakii saa'itə maɗəfənə a ɗa tə tii kuna? ");
INSERT INTO gde_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","Kə dəməgərə ci aasəkə *yi ŋga Əntaŋfə, ca ŋgiragi burooditə ɗəkəpaa ənji ka Əntaŋfə, təya adə da ənjaakii, taa ŋgahi ma buroodita, pooshi bariya vii ka tii rəgwa ŋga adənə, maɗaamə ka limanyinə daanətii. ");
INSERT INTO gde_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Anii pooshi unə jaŋgii asəkə bariya ŋga Muusa oo'i, taa ŋgutə uusəra ŋga əpisəka patə, ma limanyinə, ha'ə nə tii agi taŋəgi bariya ŋga uusəra ŋga əpisəka acii agi slənənə nə tii asəkə yi ŋga Əntaŋfwa? Amma, patə da ha'ə, pooshi 'waslyakəənə ashitii. ");
INSERT INTO gde_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Wanyinə ca ba koonə: tə'i uushi ganə palee ka yi ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Kə bii Əntaŋfə asəkə malaaɓa ləkaləkatə oo'i: ‘Nəhə təgunuunə ŋga ənji mwayi nyi, əntaa ɗa ka nyi sataka də daba.’ Maci kə shii unə sətə ci waɓəətsə a moo banə, kaɗa pooshi unə nja ba oo'i, tə'i 'waslyakəənə ashi ənjitə pooshi agi ɗa 'waslyakəənə. ");
INSERT INTO gde_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Acii ma nyi *Uuzənə ŋga ənda, Slanda uusəra ŋga əpisəkə nə nyi.” ");
INSERT INTO gde_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Ma daba'əkii, wata Yeesu a maɗə gatə, ca dzə, ca dəməgərə aasəkə *kuvə də'watii. ");
INSERT INTO gde_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Asee, tə'i əndə davə ətə ɗii ciinəkii mantəkii. Hara ənji davə a ləgwa ka Yeesu, əŋki tii, “Ya əna, maɗa kə mbəɗəpaa ənji də əndə uusəra əpisəka, kə taŋəgi ənji bariya kwa?” Ma bii tii ha'ə, kaa təya shii upaa sə ŋga idəpaanə ashikii. ");
INSERT INTO gde_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Yeesu a ba ka tii, “Yaci tə'i əndə'i əndə da bagaakii agyuuna, maɗa kə kulagərə aa gu'u uusərə ŋga əpisəka, paa ci ka ŋgiraginə kwa? ");
INSERT INTO gde_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Kə palee əndə ka baga ka shaŋə. Acii ha'ə, kə vii *bariya rəgwa ŋga ɗa ŋga'əənə uusərə ŋga əpisəka.” ");
INSERT INTO gde_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Wata əŋki Yeesu ka əndətə ɗii ciinəkii mantəkii, “Təɗapaa ciinəku.” Wata ca təɗapaa, ciinəkii a ənəpaa ndalə makə ŋga əndə'i. ");
INSERT INTO gde_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Makə nee Farisanyinə ha'ə, wata təya palə, təya dzə ka ɗa mətərəkinə ŋga ɓələginə tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Makə fii Yeesu oo'i, agi ɗanə nə ənji mətərəkinə ŋga ɓələginə tə ci, ca palə saakii. Daɓaala a dzə də nə'unə tə ci. Ca mbəɗəpaa də patənə ŋga ənji bwanea, ");
INSERT INTO gde_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ca wazə ka tii, “Goona bagi taa wu nə nyi.” ");
INSERT INTO gde_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Ma bii ci ha'ə, ka mbu'utəginə də sətə waɓi anabi Isaaya ətə bii ca: ");
INSERT INTO gde_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“Wiitsə lawaraaki ətə ta'i nyi, kə uu'i nyi tə ci, ci ca uuɗagi səkəki. Ka sləkeenə nə nyi ka Ma'yanaaki aagyanəkii kaa ca ba aniyaaki ka patənə ŋga ənji agi duuniya. ");
INSERT INTO gde_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Paa ci na ɗaaɗa mabizhinə da ənja, taa wazənə, pa ca waɓə də ŋgeerənə ahada ənja, ");
INSERT INTO gde_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","paa ci ka ɓiiyigi uushi'iitə gwaaŋəgi satii, paa ci ka ɓələgi garəkuwatə kədəhə ka əntəginə. Ka ɗanə nə ci ha'ə, see maɗa jaalii gooŋgaanə ŋga Əntaŋfə agyanə *duuniya. ");
INSERT INTO gde_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Tə ci nə patənə ŋga ənji a gi'i.” ");
INSERT INTO gde_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Ma daba'əkii, wata ənjə a kira ka Yeesu əndə'i muurəfa, kadəguləmə nə ci əsə, acii tə'i ginaaji ashikii. Yeesu a mbəɗəpaa də ci. Ha'ə əndətə a mbee ka waɓənə, ca nee ka ha əsə. ");
INSERT INTO gde_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Daɓaala patə a ləgwa, əŋki tii, “Matuu maɗuunə jijinə ŋga *Dawuda ətsə nii?” Acii kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə nə sətə ɗii Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Makə fii Farisanyinə ətsə ha'ə, təya ba, “Ma ci əndətsə a lyaakagi ginaajinyinə, də baawəɗa ŋga *Byaləzabulə, ŋwaŋwatii.” ");
INSERT INTO gde_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Shiinə ŋga Yeesu tə sətə ci təya hiima, wata əŋki ci ka tii, “Taa ŋgutə ŋwaŋuunə təkəgi bəra'i putə ŋga mabizhinə, ka əntənə nə ŋwaŋuunəkii. Ha'ə, taa ŋgutə vəranə taa ya ətə təkəgi bəra'i, ka ənslənə nə vəranəkii taa yikii. ");
INSERT INTO gde_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Maɗa *Seetanə ca vii baawəɗa ŋga lyaakagi sətə ndzaa ka naakii, kə ndzaa ci ətsə kə təkəgi yikii bəra'i, ka ənslənə nə ŋwaŋuunəkii. ");
INSERT INTO gde_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Yoo, maɗa də baawəɗa ŋga Byaləzabulə cii kya lyaakagi ginaajinyinə, aa wu ɗii vii ka *lyawarənə goonə natii baawəɗa ŋga ɗanə ha'a? Slənatii na ɓaarii oo'i, ma sətə cuuna hiima, pooshi tahu tahu. ");
INSERT INTO gde_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amma, makə ɗii ci, də baawəɗa ŋga Ma'yanə ŋga Əntaŋfə cii kya lyaakagi ginaajinyinə, yoo, ci ɓaarii oo'i, kə njaŋə Əntaŋfə ɗa ŋwaŋuunə ahadoonə. ");
INSERT INTO gde_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","“Pooshi əndə ca dzəgərə aasii aa ha mandalə əndə, ca fə'yagi uushi'inaakii patə, maɗaamə ci kə anəgi mandalə əndəkii zəku'i, taabu'u fə'yaginəkii uushi'inə. ");
INSERT INTO gde_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","“Taɗa wu nə əndə pooshi liwə tə nyi, əndə daawaanaakii nə ci ətsa. Taɗa wu nə əndə pooshi agi tsakənə tə nyi agi tsəəkənə əsə, əndə kuzhiɗəginə nə ci. ");
INSERT INTO gde_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Acii ha'ə, wanyinə ka banə koonə, taɗa ŋgutə 'waslyakəənə da bərapaanə tə Əntaŋfə, ka tifyaginə nə Əntaŋfə ka ənja. Amma, ma bərapaanə tə Malaaɓa Ma'yanə, pooshi Əntaŋfə ka tifyaginə. ");
INSERT INTO gde_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Ha'ə əsə, taɗa wu bii bwaya uushi aashiki, nyi Uuzənə ŋga ənda, ka tifyaginə nə Əntaŋfə tə ci. Amma, taɗa wu patə bii bwaya uushi aashi Malaaɓa Ma'yanə, pooshi Əntaŋfə ka tifyaginə tə ci əndzə'i ka ca'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“Yoo, maɗa ŋunyikii nə ənfwa, ŋunyikii ndzaanə pookii. Maɗa bwayakii nə ənfwa, bwayakii ndzaanə pookii əsə. Acii ka pookii shiinə ənji ənfwa. ");
INSERT INTO gde_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ya unə rəhunyina, iitə mbeenuunə ka ba ŋunyi uushi, wiinə boo bwayakii nuunə kwa? Acii sətə pasə asəkə ədzəmə ŋga əndə cii kəya ba. ");
INSERT INTO gde_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Ma ŋunyi ənda, ŋunyikii ndzaanə slənaakii, acii ŋunyikii nə aginaakii. Ma bwaya əndə əsə, bwayakii ndzaanə slənaakii, acii bwaya aginə nə ci. ");
INSERT INTO gde_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Wanyinə ka banə koonə: ma uusərə ŋga ɗa gəŋwanə, taa wu patə, ka baabaginə nə ci patənə ŋga uushi'iitə pooshi nafakii ətə shi ca waɓə. ");
INSERT INTO gde_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Waɓənə goonə nə ənjə a ŋgərə ka la koonə də gəŋwanə. Waɓənə goonə na ɓaarii tuunə taa pooshi 'waslyakəənə ashuunə, taa ka ma'waslyakə ənji nuunə.” ");
INSERT INTO gde_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Ma daba'əkii, hara maliminə da hara Farisanyinə a ba ka Yeesu: “Maləma, ŋga'ə keenə ha ɗa sə ŋga hurəshishinə keena nee.” ");
INSERT INTO gde_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Amma əŋki ci ka tii: “Ma ənji ŋga zamanana, bwaya ənja, ənjitə pooshi ka nə'utə bariya ŋga Əntaŋfə nə tii. Agi alənə nə tii kaa ənjə a ɗa ka tii sə ŋga hurəshishinə. Amma pooshi sə ŋga hurəshishinə ci ənjə a ɗa ka tii, maɗaamə ətə ɗii Əntaŋfə də *anabi Yunana. ");
INSERT INTO gde_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Makə sətə baa Yunana vəɗə makkə da uusəra makkə asəkə hərəfinə, ha'ə nə Uuzənə ŋga əndə a baanə vəɗə makkə da uusəra makkə maŋgəɗəkii agi hanyinə. ");
INSERT INTO gde_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Ma uusəra ŋga ɗa gəŋwanə, kadə nə ənji Niniva a maɗə, təya vii ma'inə ka ənji ŋga zamanana, acii makə fii tii waazanə ŋga Yunana, kə baa tii ka Əntaŋfə. Yoo, tə'i sətə palee ka Yunana ganə, amma pooshi unə baanə ka ci. ");
INSERT INTO gde_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Ma uusəra ŋga ɗa gəŋwanə, kadə nə miitə ɗii ŋwaŋuunə agyanə hanyinə ŋga Saba a maɗə, kya vii ma'inə ka ənji ŋga zamanana, acii kə ma'ya ki dzaɗə daga anə hanyinatə, kya shi aaɓii ŋwaŋwə Sulayimaanu, kaa kya fa macicirə dzəgunənaakii. Yoo, tə'i sətə palee ka Sulayimaanu ganə, amma pooshi unə agi fa waɓənaakii.” ");
INSERT INTO gde_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“Maɗa kə dzəgi ginaaji ashi ənda, ka dzənə nə ci kura'ə aagi bilinə ka hatə pooshi ma'inə davə ka alə ha ŋga əpisəka. Amma paa ci ka upaanə. ");
INSERT INTO gde_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","Ka banə nə ci ka naakii na: ‘A ənə nyi saaki ka hatə shigi nyi davə.’ Maɗa kə ənyi ci aa dəvə, ca lapaa hakii gbəŋə, maslaabakii, mahaɗakii ŋga'ə əsə. ");
INSERT INTO gde_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","Makə nee ci ha'ə, wata ca palə ka 'waa'wa hara ginaajinyinə məɗəfə ətə palee ka ci də məzaanə. Təya shi, təya dəməgərə aashi əndəta, təya ndzaanə. Wata ndzaanə ŋga əndətə a ɗagi təgugunə palee ka ŋga ŋukə. Ha'ə ɗii na slənə də bwaya ənji ŋga zamanana.” ");
INSERT INTO gde_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Ma Yeesu ma'ə agi waɓənə ka ənja, wata kə mbu'ya məci tii da ndzəkəŋushi'inəkii, təya kəŋaanə agyə, təya ləgwa kaa təya waɓə da Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Wata əndə'i əndə a ba ka ci oo'i, “Watiitsə i muu tii da ndzəkəŋushi'inəku kəŋə kəŋə agyə. Ŋga'ə ka tii nə waɓənə da hə.” ");
INSERT INTO gde_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Əŋki Yeesu ka ci, “Wu saŋə nə yaaya? I wu nə ndzəkəŋushi'inəkya?” ");
INSERT INTO gde_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Wata ca shiku tə lyawarənaakii, əŋki ci, “Watiinə i yaayi da ndzəkəŋushi'inəki. ");
INSERT INTO gde_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Acii taɗa wu patə ca slənətə sətə ci Daadə ətə dadagyə a moo, ci nə ndzəkəŋunəki da cikəŋunəki da yaayi.” ");
INSERT INTO gde_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Agi uusəratə rəŋwə ha'ə, Yeesu a maɗə asii, ca palə, ca ndzaanə ama uunəvə kaa ca dzəgunə ka ənja. ");
INSERT INTO gde_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Laŋə ka shaŋə nə daɓaala aɓiikii, see də makə ndərəvə ci aasəkə kumbawalə, ca ndzaanə asəkəkii, ənjə a kəŋaanə anə ndəra. ");
INSERT INTO gde_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Kə slənyi ci də misaalinyinə ka baaba ka tii uushi'inə laŋə. Əŋki ci, “Tə'i əndə gi aasəkə rə ka giirə slikərənə. ");
INSERT INTO gde_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Ma ca giirə slikərənəkii, tə'i harakii kwaalii ahada rəgwa. Əginyinə a ɗəmətə. ");
INSERT INTO gde_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","Harakii a kwaala ama pasla hatə ɗii hanyinə gi'u anəkii. Slikərənəkii a givagi pii pii, acii wata lyavərəvərə nə hanyinə anə faara. ");
INSERT INTO gde_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","Makə cifə uusəra, wata magiva slikərənəkii a naa'ugi saakii, acii pooshi slərəginəkii tahu tahu bahə sha ma'inə. Magiva slikərənəkii a huurəgi saakii. ");
INSERT INTO gde_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Hara slikərənəkii a kwaala aagi dəha. Makə giva slikərənəkii, dəhəkii a pa'aanə ka ci, pooshi rəgwa ŋga gərənə. ");
INSERT INTO gde_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amma, ma hara slikərənəkii, kə kwaalii tii anə ŋunyi hanyinə, kə vii tii ŋunyi cifanə. Harakii gya'ə gya'ə, harakii kuwa pu'unə kuwa pu'unə, harakii makkə pu'unə makkə pu'unə.” ");
INSERT INTO gde_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Yeesu a uudəpaa, əŋki ci, “Ma əndətə da liminə ŋga fanə, wa ca fa.” ");
INSERT INTO gde_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Wata *lyawarənə ŋga Yeesu a shi aaɓiikii, təya ləgwa ka ci, əŋki tii, “Ka mi saŋə cii kwa ɗa misaali, ha waɓə ka ənja?” ");
INSERT INTO gde_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Yeesu a ba ka tii, əŋki ci, “Ma unə, koonə vii Əntaŋfə rəgwa ŋga shii ma'umbee uushi'inə ŋga ŋwaŋuunaakii, əntaa ka tii. ");
INSERT INTO gde_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Acii, ma əndətə kavə nəkii ka shii uushi'inəkii, ka ci tsakənə nə ənji paaratəginə kaa ca shii ɗanə laŋə aciikii. Amma, ma əndətə ɗii naakii shiinə gi'u, taa gi'ukii maa, ka luuginə nə ənji aciikii. ");
INSERT INTO gde_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Ci nee unə cii kya waɓə ka tii də misaali, acii ka tsaamənə nə tii, amma, paa tii ka neenə, ka kapaanə nə tii liminətii, amma, paa tii ka fanə, paa tii ka paaratəginə əsə. ");
INSERT INTO gde_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Tii ca mbu'utəgi də waɓəətə waɓi Əntaŋfə ka ənji *Isərayiila da ma anabi Isaaya ətə bii ci: ‘Ka fanə nuunə anəkii anəkii, amma, pooshi unə ka paaratəginə shaŋə. Ka tsaamənə nuunə anəkii anəkii, amma, pooshi unə ka neenə shaŋə. ");
INSERT INTO gde_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Acii ma ədzəmə ŋga ənjitsa, mapa'əkii, liminətii əsə, manjiikəkii, təya dzaa'agi ginətii. Maci maɗamə tii ha'ə, kaɗa kə nee tii də ginətii, təya fatə də liminətii, təya paaratəgi də ədzəmətii, təya zhi'wagi aaɓiiki əsə, nya mbəɗəpaa də tii.’ ");
INSERT INTO gde_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Amma, ma unə, tə'i barəkaanə ashuunə, acii agi neenə nə ginuunə, ha'ə agi fanə nə liminuunə əsə. ");
INSERT INTO gde_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Tantanyinə cii kya ba koonə: laŋə nə anabinyinə da ənji ŋga Əntaŋfə mwayi ka shaŋə kaa təya nee ka sənə cuuna nee, amma maneemə tii. Kə mwayi tii fanə tə sənə cuuna fa, amma mafamə tii əsə.” ");
INSERT INTO gde_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“Fatəmə ɗii kaa nya ba koonə sətə ci misaali ŋga əndə giirə slikərənə a moo banə: ");
INSERT INTO gde_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","maɗa kə fii ənji waɓənə agyanə *ŋwaŋuunə ŋga Əntaŋfə, amma mapaaratəgimə tii, ka ndzaanə nə tii makə slikəriitə kwaalii ahada rəgwa, *Seetanə a shi, ca ɗəməgi waɓəətə giirə ənji a ədzəmətii. ");
INSERT INTO gde_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Ma slikəriitə kwaalii ama pasla, tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə, təya luu pii də mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Amma pooshi waɓənəkii əji slərəginə a ədzəmətii bahə sə'watə uushi'inə ŋga uundzə saa'i. Acii ha'ə, maɗa kə lii ŋgəra'wə da ciɓə tə tii putə ŋga waɓənə ŋga Əntaŋfə, pii wata təya bwasee. ");
INSERT INTO gde_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","Ma slikəriitə kwaalii aagi dəhə əsə, tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə, amma putə ŋga buurə uushi'inə ŋga *duuniya da uuɗə gəna, kə saawagi waɓənəkii, pooshi nafakii. ");
INSERT INTO gde_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Ma slikəriitə kwaalii anə ŋunyi hanyinə əsə, tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə, təya paaratəgi ŋga'ə, təya ndzaanə makə slikərəətə ca vii ŋunyi cifanə, harakii gya'ə gya'ə, harakii kuwa pu'unə kuwa pu'unə, harakii əsə makkə pu'unə makkə pu'unə.” ");
INSERT INTO gde_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Yoo, kə ɗii Yeesu ka tii əndə'i misaali əsə də banə, “Ma ŋwaŋuunə ŋga dagyə, kə ndzaa ci mbərə mbərə da sətə ɗii də əndətə gi ka ləga ŋunyi slikərənə asəkə raakii. ");
INSERT INTO gde_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Ma davəɗə, ətsə taa wu patə ka ŋunyinə nə ci, wata əndə daawaanaakii a dzə ka ləgavə kuzənə aagi aləkamaarakii, ca palə saakii. ");
INSERT INTO gde_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Makə givagi aləkamaara, kə girə, kə uugi ŋgərə manjeevənə, wata kuzənə a shigi ha'ə naakii. ");
INSERT INTO gde_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Ənji slənə ŋga slanda rə a dzə ka banə ka ci, əŋki tii: ‘Slandana, əntaa ŋunyi slikərənə ləgii ha? Aa dama ɗii gyavagi kuzənə agikəya?’ ");
INSERT INTO gde_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Wata ca ba ka tii: ‘Əndə daawaanə ɗii ha'ə.’ Ənji slənaakii a ba ka ci: ‘Ŋga'ə ka hə maɗa kə giinə ka mbuuɗəginə kwa?’ ");
INSERT INTO gde_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Amma ca ba ka tii: ‘Aa'aa'ə, bwaseemə, goona dzə ka mbuuɗəginə, acii maɗa kə gyuunə ka mbuɗənə, ka mbuɗəənənə nuunə da i aləkamaara atsakii. ");
INSERT INTO gde_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Wa təya gərə patə. Maɗa kə mbu'ya saa'i ŋga cifanə, kadə nii kya ba ka ənji slənə cifanə, aa təya mbuuɗəgi kuzənə zəku'i, təya pukəgərə aagi gunə, taabu'u slənənətii ka nyi cifanə ŋga raaki, nya pukəgərə aa dəɓwə.’ ” ");
INSERT INTO gde_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Yeesu a ɗa ka tii əndə'i misaali, əŋki ci, “Ma ŋwaŋuunə ŋga dagyə, kə ndzaa ci makə hi'u iza, əndə a ŋgərə, ca ləgapanə gakii asəkə tsanə. ");
INSERT INTO gde_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Slikərənəkii palee patə də ənshiɗəɗənə. Amma, maɗa kə girə, ka ɗaginə ka dandza ka shaŋə. Əginyinə a shi, təya ɗa kuvənyinatii davə.” ");
INSERT INTO gde_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Yeesu a ɗa ka tii əndə'i misaali, əŋki ci, “Ma ŋwaŋuunə ŋga dagyə, kə ndzaa ci makə burəŋanə. Minə a gwazətəgi də kəŋwə əjima makkə ŋga əmpunə. Wata əmpunəkii patə a asləgi divə.” ");
INSERT INTO gde_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Ma uushi'iitsə patə, kə waɓi Yeesu ka daɓaala də misaali, pooshi uushi cii kəya ba ka ənji yadə misaalikii. ");
INSERT INTO gde_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Ma ətsə patə, ka mbu'utəginə də sətə bii anabi oo'i: “Ka waɓənə nə nyi ka tii də misaalinyinə, ka banə nə nyi ka tii sətə nji ma'umbeekii daga ka 'watəginə ŋga duuniya.” ");
INSERT INTO gde_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Ma daba'əkii, kə bwasee Yeesu ka daɓaala, ca dəməgərə aasii. Wata lyawarənaakii a shi aaɓiikii, təya ləgwa ka ci, əŋki tii, “Batə keenə taa mi ci misaali də kuzənə a səkərə a moo banə.” ");
INSERT INTO gde_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Yeesu a ba ka tii, əŋki ci, “Ma əndətə ləgii ŋunyi slikərənə, ci nə *Uuzənə ŋga ənda. ");
INSERT INTO gde_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Ma ra, ci nə duuniya. Ma ŋunyi slikərənə əsə, tii nə ənji ŋga ŋwaŋuunə ŋga Əntaŋfə. Ma kuzəna, tii nə ənji ŋga Seetanə. ");
INSERT INTO gde_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Ma əndə daawaatə gi ka ləgavə kuzənəta, ci nə Seetanə. Ma saa'i ŋga cifanə, ci nə muudinə ŋga duuniya. Ənji slənə cifanə əsə, tii nə malaa'ikanyinə. ");
INSERT INTO gde_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Makə sətə ci ənjə a dzatəgi də kuzhinyinə, ənjə a kaanə gunə, ha'ə na ɗa ka muudinə ŋga duuniya. ");
INSERT INTO gde_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Kadə nə Uuzənə ŋga əndə a sləkee ka malaa'ikanyinaakii, kaa təya dzatəgi də ənjitə ca kavə ənji ka ɗa 'waslyakəənə da ənjitə ca ɗa bwaya uushi'inə, təya fəɗəgi tə tii agi ŋwaŋuunaakii, ");
INSERT INTO gde_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","təya əjigərə tə tii aagi gunə. Davə tuunətii, təya tsəɓə linyinətii. ");
INSERT INTO gde_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Ma ənjitə da gooŋga ashitii əsə, ka ɓərənə nə tii makə uusəra agi ŋwaŋuunə ŋga Dəsənətii. Ma əndətə da liminə ŋga fanə, wa ca fa.” ");
INSERT INTO gde_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","“Ma ŋwaŋuunə ŋga dagyə, kə ndzaa ci mbərə mbərə da maŋgəɗə gəna ətə upaa əndə'i əndə asəkə rə, ci ka ha ŋga uuzanə. Makə upaa ci, ca ənə ka ŋgəɗəginə davə. Ka mooɗasəkə nə ci ka shaŋə. Ca dzə ka ɗərəmagi də uushi'inaakii patə, ca ɗərəgi də rəta.” ");
INSERT INTO gde_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","“Ha'ə əsə, ma ŋwaŋuunə ŋga dagyə, kə ndzaa ci mbərə mbərə da əndətə ca alə ŋunyi lu'ulu'u. ");
INSERT INTO gde_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","Wata makə upaa ci ŋunyikii, ca dzə ka ɗərəmagi də uushi'inaakii patə, ca ɗərəgi də ŋunyi lu'ulu'uta.” ");
INSERT INTO gde_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","“Ha'ə əsə, ma ŋwaŋuunə ŋga dagyə, kə ndzaa ci mbərə mbərə da slaaɗa ətə kagərə ənji aagi uunəva, ca kaasha hərəfinə kama kama laŋə. ");
INSERT INTO gde_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Makə nii slaaɗəkii, ənjə a əlyagi aanə ndəra, ənjə a ndzaanə ka tsəəkəgi ŋunyi hərəfinə aasəkə ɗəva. Bwayakii əsə, ənjə a pukəgi. ");
INSERT INTO gde_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Ha'ə na ɗa əsə uusəra ŋga muudinə ŋga duuniya. Kadə nə malaa'ikanyinə a dzə ka tsəəkəgi bwaya ənji ahada ŋunyi ənja, ");
INSERT INTO gde_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","təya əjigərə tə tii aagi gunə. Davə tuunətii, təya tsəɓə linyinətii.” ");
INSERT INTO gde_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Yoo, Yeesu a ləgwa ka tii, əŋki ci, “Kə fii unə uushi'iitsə patə kwa?” Təya ba ka ci, “Awa, kə fii inə.” ");
INSERT INTO gde_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Wata ca ba ka tii, “Taɗa wu agi maliminə ndzaa ka lawara agi ŋwaŋuunə ŋga dagyə, makə ŋga slanda yi nə ci, ətə ca ŋgiragi kura uushi'inə da iirə uushi'inə asəkə kuvə shigaakii.” ");
INSERT INTO gde_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Makə uudəpaa Yeesu baaba misaalinyiitsa, ca maɗə gatə, ca palə saakii ");
INSERT INTO gde_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","aa hakii aa vəra, hatə girə ci davə, ca dzəgunə ka ənji asəkə *kuvə də'watii. Kə ɗii ka tii ka sə ŋga hurəshishinə, təya ba ahadatii, “Da saŋə upaa əndətsə shiinə ha'a? Da upaa ci baawəɗa ŋga ɗa sə ŋga hurəshishina? ");
INSERT INTO gde_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Əntaa uuzənə ŋga əndə gwaa'a ənfuginə nə ca? Əntaa Mariyaama nə məca? Əntaa i Yakubu da Yusufu da Simoonə da Yahuda nə ndzəkəŋushi'inəkəya? ");
INSERT INTO gde_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Əntaa ganə ahadaamə nə cikəŋushi'inəkii pata? Da saŋə upaa əndətsə sətsə ha'a?” ");
INSERT INTO gde_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Wata təya kaaree ka ci. Yeesu a ba ka tii, “Ma *anabi, taa ka ŋgutə vəranə gi ci patə, ka upaanə nə ci məghərəvənə. Amma ma gakii də vəra da ahada ənji yaakii, paa ci ka upaa məghərəvənə.” ");
INSERT INTO gde_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Maɗamə Yeesu sə ŋga hurəshishinə laŋə davə putə ŋga ghatə vii gooŋgatii. ");
INSERT INTO gde_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Ma ka saa'ita, kə fii *Hirudusə, ŋwaŋwə anə hanyinə ŋga Galili, habara ŋga Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Ca ba ka ənji slənaakii, “Ci nə Yoohana əndə ɗa bapətisəma. Kə ma'i ci agi maməətə ənja. Ci nee unə upaa ci baawəɗa ŋga ɗaaɗa sə ŋga hurəshishinə ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","Ma bii ci ha'ə, acii kə shi ca bii ka ənjə a kəsə tə Yoohana, ənjə a anəgi, ənjə a pa'əgi a furəshina. Ma ɗii ci ha'ə, putə ŋga Hiroodiya, minə ŋga ndzəkəŋuci, waatoo Filibusə. Ma miita, kə ŋgərəma Hirudusə tə ki kaa kya ndzaa ka minaakii. ");
INSERT INTO gde_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","Amma kə bii Yoohana ka ci oo'i, “Madəɓeemə ha ŋgərə tə Hiroodiya ka minaaku shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Kə mwayi Hirudusə ɓələginə tə Yoohana, amma ŋgwaliikii acii daɓaala, acii kə ŋgirə tii tə Yoohana ka anabi. ");
INSERT INTO gde_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Makə zhi'wa kumənə ŋga uusəratə pwayi ənji tə Hirudusə, kə uji uuzənə ŋga Hiroodiya uncitə minəkii akəŋwacii ənja. Ha'ə, kə kaɗeesəkə ka Hirudusə. ");
INSERT INTO gde_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","Ca ɗa ka ki aləkawalə də jiɗə oo'i, taa mi patə bii ki, ka viinə nə ci ka ki. ");
INSERT INTO gde_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Məci a ba ka ki, wa kya kədii nə ŋga Yoohana. Wata uncitə miitə a ba ka Hirudusə, “Ŋga'ə ka nyi ha vii ka nyi nə ŋga Yoohana əndə ɗa bapətisəma əndzə'i asəkə kəŋwa.” ");
INSERT INTO gde_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Makə fii ŋwaŋwə ha'ə, kə zhimə tə ci asəkəkii. Amma putə ŋga jiɗəətə ji'i ci da putə ŋga madiigərə ənjitə 'waa'wa ci, kə bii ci, wa ənjə a vii ka ki sətə mwayi ki. ");
INSERT INTO gde_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","Wata ca sləkee ka ənjə a dzə ka lyagi nə ŋga Yoohana a furəshina. ");
INSERT INTO gde_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Makə lyagi ənji, wata ənjə a kira asəkə kəŋwa, ənjə a vii ka uncitə miitə, kya luu, kya kərə ka məci. ");
INSERT INTO gde_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Wata lyawarənə ŋga Yoohana a shi, təya ŋgərə waakii, təya dzə ka ŋgəɗəginə. Ma daba'əkii, təya dzə ka banə ka Yeesu tə sətə ɗii. ");
INSERT INTO gde_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Makə fii Yeesu habara agyanə Yoohana, ca ndərəvə saakii aasəkə kumbawalə, kaa ca dzə ka ndzaanə daanəkii ka hatə pooshi ənji davə. Amma, makə fii daɓaala ha'ə, təya bwasee ka vəranatii, təya nə'u tə ci də səɗətii. ");
INSERT INTO gde_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Yeesu a jimagərə asəkə kumbawalə aanə ndəra. Makə nee ci ka daɓaala laŋə, kə nyihə ci təgunuunatii. Wata ca mbəɗəpaa də ənji bwaneatii. ");
INSERT INTO gde_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Ma ətsə kaa uusəra a kula, lyawarənaakii a shi aaɓiikii, əŋki tii, “Kə ɗii kədəwanə; wiinə agi bilinə naamə ganə. Acii ha'ə, bawə ka ənji, wa təya dzə aasəkə vəranyinə ka ɗərə zəmə ka natii na.” ");
INSERT INTO gde_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Wata Yeesu a ba ka tii, “Pooshi bwatya ŋga dzənatii. Unə nə vii ka tii zəma.” ");
INSERT INTO gde_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Təya ba ka ci, “Pooshi zəmə acii inə bahə viinə ka tii. Wata buroodi tufə ba'ə hərəfinə bəra'i nəndə acii inə.” ");
INSERT INTO gde_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Wata ca ba ka tii, “Kiramə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Ca ba ka daɓaala, wa təya ndzaanə agyanə kuzəna, ca ŋgərə burooditə tufə da hərəfiitə bəra'i, ca maɗee ka ginəkii aadəgyə, ca kuyirii tə Əntaŋfə, ca ɓaatsəpaa buroodita, ca vii ka lyawarənaakii, təya vii ka daɓaala. ");
INSERT INTO gde_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Ənji patə a zəmə, təya əburə. Ma daba'əkii, lyawarənaakii a tsəəkətə tə ətə mbəɗaanə, ɗəvə pu'u aji bəra'i. ");
INSERT INTO gde_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Ma ənjitə agi zəməta, kə mbu'i tii bahə dəbu'u tufə, tsaŋə nə makinə da manjeevənə. ");
INSERT INTO gde_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Wata Yeesu a ba ka lyawarənaakii, wa təya ndərəvə aasəkə kumbawala, təya takəŋwa ka ci aa taŋəgi uunəva, kaa ca ba ka daɓaala a palə satii. ");
INSERT INTO gde_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Ma ənji agi palənə satii, ma ci naakii, wata ca ndərə aa giŋwə, ci daanəkii, kaa ca ɗa də'wa. Kə uugi vəɗə ɗanə, ci daanəkii nə əndə davə, ");
INSERT INTO gde_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","dzaɗə ahada uunəvə nə kumbawalə əsə. Dzawə ka kumbawaləkii nə dzənə aakəŋwə ma'ə, acii laŋə dərəva nə məɗə agi əgyanə dakəŋwacii, ma'inə a dzə də dəgənə ashi kumbawala. ");
INSERT INTO gde_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Ma ətsə ha wurə wurə kaa ca pukə, wata Yeesu a dzə aaɓii lyawarənaakii də wiinə anə ma'inə. ");
INSERT INTO gde_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Makə nee lyawarənaakii ka ci ka wiinə anə ma'inə, kə ŋgwaləgi tii ka shaŋə, əŋki tii, “Wiitsə ɓərəhinə!” təya kaala vurənə. ");
INSERT INTO gde_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Amma pii Yeesu a waɓə ka tii, əŋki ci, “Baneemə ka mooɗəfuunə. Nyi əna, goona ŋgwalə!” ");
INSERT INTO gde_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Wata Piita a ba ka ci, əŋki ci, “Slandana, maɗa hə ətsə tanyi, bawə ka nyi, kaa nya dzə aaɓiiku anə ma'inə.” ");
INSERT INTO gde_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Yeesu a ba ka ci, “Shiwa!” Wata Piita a jiməgərə asəkə kumbawala, ca wii anə ma'inə, ca dzə aaɓii Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Amma, makə nee ci ka məɗə anə ma'inə, ca ŋgwaləgi. Wata ndzaŋə lipənə nə ci aagi ma'inə, ca ka vurənə, “Slandana, luupaa tə nya!” ");
INSERT INTO gde_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Pii wata Yeesu a vii ciinəkii ka ci, ca kəsətə tə ci ka ciinə, ca ba ka ci, “Kə əki gi'inaaku tə nyi. Ma nə hə ka nəhənə, paa nyi ka kavənə tə hə ka wiinə anə ma'inə kwa?” ");
INSERT INTO gde_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Təya ndərəvə aasəkə kumbawala, wata məɗə a dədəkə. ");
INSERT INTO gde_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Lyawarənaakii a gərə'waanə asəkə kumbawala, təya paslə tə Yeesu, təya ba, “Tantanyinə, *Uuzənə ŋga Əntaŋfə nə hə.” ");
INSERT INTO gde_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Makə taŋəgi tii uunəva, təya mbu'u aanə hanyinə ŋga Ginazarətə. ");
INSERT INTO gde_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Ma ənji davə, kə puləgi tii oo'i, Yeesu ətsə shi. Wata təya sləkee taa dama patə anə hanyinəkii, ənjə a kyaara ka ci ənji bwanea patə. ");
INSERT INTO gde_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Təya kədii aciikii, taa wata kəjeerənaakii, wa ənji bwanea a təɓətə. Patənə ŋga ənjitə təɓətə, kə mbə'i tii. ");
INSERT INTO gde_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Kə shi harii *Farisanyinə da maliminə daga də Urusaliima aaɓii Yeesu, təya ləgwa ka ci, əŋki tii, ");
INSERT INTO gde_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Ka mi saŋə ci lyawarənaaku a taŋəgi alə'aada ŋga dzədzəshi'inaama? Acii ma təya, paa tii agi yiɓəgi ciinətii taabu'u zəmənətii.” ");
INSERT INTO gde_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Yeesu a ba ka tii, əŋki ci, “Ya unə noona, ka mi dee cuuna taŋəgi bariya ŋga Əntaŋfə putə ŋga alə'aada goona? ");
INSERT INTO gde_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Acii kə bii Əntaŋfə oo'i: ‘Ɗuunətə tə i duu da muu. Taa wu waɓi bwaya uushi aashi dii taa məci, wa ənjə a ɓələgi tə ci.’ ");
INSERT INTO gde_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amma, ma unə, agi dzəgunənə nuunə ka ənji oo'i, ma sətə dəɓee əndə a vii ka dii taa məci, maɗa bii ci ka tii: ‘Ma səna, kə vii nyi ka Əntaŋfə’, taɗa paa ci ɗuunətə tə tii ma'ə, pooshi haala. ");
INSERT INTO gde_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Də ha'ə bwasee unə ka waɓənə ŋga Əntaŋfə putə ŋga alə'aada goonə. ");
INSERT INTO gde_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Unə ənjitə ca nə'u tə Əntaŋfə də mooɗəfə bəra'i, asee, tantanyinə nə anabaakwaanə ŋga Isaaya ətə bii ci anuunə oo'i: ");
INSERT INTO gde_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Ma ənjitsa, amatii ci təya haŋətə tə nyi, Amma, ma ədzəmətii, dzaɗə da nyi ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Zaɓə nə paslənatii tə nyi, acii ma alə'aadanyiitə ci təya dzəgunə ka ənja, banə ŋga əndə shiŋkinə, əntaa banaaki.’ ” ");
INSERT INTO gde_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Wata Yeesu a 'waa'watə daɓaala aaɓiikii, ca ba ka tii, “Fatəmə, una paaratəgi: ");
INSERT INTO gde_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Əntaa sətə ca dzəgərə da ma ənda ca ajijinətə tə ci, amma sətə ca shigi da makii ca ajijinətə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Wata lyawarənaakii a shi aaɓiikii, təya ləgwa ka ci, “Kə shii hə oo'i, ma waɓəətsə bii hə, kə kulii aasəkə Farisanyinə nii?” ");
INSERT INTO gde_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ca ba ka tii, əŋki ci, “Taɗa ŋgutə slikərənə giva patə, maɗa əntaa Daadə ətə dadagyə ləgii, ka mbuɗəginə nə ənji. ");
INSERT INTO gde_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Bwaseemə ka tii, goona buurə tə tii, muurəfinə ca kərə tə harakii. Maɗa muurəfə ca kərə tə muurəfə makə ci, tii kyakya'ə ca kwaalagərə aa gu'u.” ");
INSERT INTO gde_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Amma əŋki Piita ka ci, “Bawə keenə taɗa mi ci misaalitsə a moo banə.” ");
INSERT INTO gde_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","Ca ba ka tii, “Ma'ə unə yadə paaratəgi də uushi makə ŋga ənjitsə kwa? ");
INSERT INTO gde_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Asee, ma'ə unə mapaaratəgimə. Taɗa mi patə dzəgərə da ma ənda, ka dzəgərənə kura'ə aasəkə, ca gimagi. ");
INSERT INTO gde_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amma, ma sətə ca shigi da ma ənda, a ədzəmə ca shigi. Ci ca ajijinətə ənda. ");
INSERT INTO gde_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Acii a ədzəmə nə əndə ka buurətə bwaya uushi'inə ca kavə tə ci ka ɓələ ənda, ca aləhiinə, ca ɗa badawaanə, ca hərə, ca jirakə, ca waɓə bwaya uushi'inə aashi ənda. ");
INSERT INTO gde_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Wiitsə tsarə ŋga uushi'iitə ca ajijinətə ənda. Amma, ma adənə yadə yiɓəgi ciinə, pooshi ka ajijinətə ənda.” ");
INSERT INTO gde_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Wata Yeesu a maɗə gatə, ca palə aanə hanyinə ŋga Tiira da ŋga Sidoonə. ");
INSERT INTO gde_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Ma anə hanyinəkii, tə'i əndə'i mitə Kana'ana. Wata kya shi də tuunə, əŋki ki, “'Ya'ə Slandana, jijinə ŋga *Dawuda, nəhuu təgunuunaakya! Tə'i uuzənaaki, uncitə minəkii da i ginaaji ashitə. Lya'ə lya'ə nə ki ka shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Amma, majikəmə Yeesu ka ki taɗa rəŋwə də makii. Wata lyawarənaakii a əntsahə aaɓiikii, təya kədii aciikii, əŋki tii, “Bawə ka ki, wa kya dzə satə, acii agi shinə nə ki də nə'unə taamə də wazənə laŋə.” ");
INSERT INTO gde_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Yeesu a jikəvə, əŋki ci, “Ma sləkee ənji ka nyi, wata ka ənji *Isərayiila tanə, acii makə maza bagiinə nə tii.” ");
INSERT INTO gde_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Amma miitə a shi, kya gərə'waanə atsaa səɗə Yeesu, əŋki ki, “'Ya'ə Slandana, tsakuu tə nyi.” ");
INSERT INTO gde_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Yeesu a ba, “Pooshi ŋga'ə nə ŋgərətə zəmə ŋga manjeevənə, ənjə a kagi ka ədiinə.” ");
INSERT INTO gde_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Əŋki miitə, “Ha'ə tanyi, 'ya'ə Daadə, amma taa ədiinə əsə, agi adənə nə tii murəmurinə ŋga zəmətə ca kwaalagi acii slanjiinətii.” ");
INSERT INTO gde_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Yeesu a ba ka ki, “Mina, laŋə nə gi'inaaku tə nyi. Ma sətə cii kwa uuɗə, ka ɗanə nə ənji ka hə.” Wata kə mbə'i uuzənatə ka saa'ita. ");
INSERT INTO gde_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Ma daba'əkii, wata Yeesu a maɗə davə, ca dzə də palənə ama uunəvə ŋga Galili, ca ndərəgi aanə ɗaŋgəra, ca ndzaa dasə davə. ");
INSERT INTO gde_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ənji ɓəzəkii a dzə aaɓiikii, təya kərə ənji bwaneanyinə kama kama, maɓiiyi ənja, mahurəməsə ənja, muurəfina i kadəguləmina da hara ənji bwaneanyinə laŋə. Təya banee ka tii akəŋwaciikii. Ca mbəɗəpaa də tii. ");
INSERT INTO gde_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Makə nee ənji kadəguləmə a waɓə, maɓiiyi ənji əsə, kə ənyi ilənyinatii ka guuŋunə, mahurəməsə ənji əsə, watiinə ka wiinə, muurəfinə əsə, watiinə ka neenə, kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə. Wata təya ɗuunətə tə Əntaŋfə ŋga ənji *Isərayiila. ");
INSERT INTO gde_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Wata Yeesu a 'waa'watə tə lyawarənaakii aaɓiikii, ca ba ka tii, “Agi nəhənə nə nyi təgunuunə ŋga ənjitsa, acii baanə makkə nə tii aɓiiki ənshinə, pooshi tii da sə ŋga kavənə aa matii. Pa nya moo təya palə də maɗəfənə, acii ga maɗəfənəkii a mbee ka tii a rəgwa.” ");
INSERT INTO gde_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Wata lyawarənaakii a ba ka ci, “Ya əna, da upaanaamə zəmə bahə zəməvənə ka ənjitsə laŋə ha'ə ganə agi bilina?” ");
INSERT INTO gde_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Yeesu a ləgwa a matii, “Buroodi moonə nəndə acii una?” Təya ba ka ci, “Buroodi məɗəfə da uuji hərəfinə.” ");
INSERT INTO gde_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Wata ca ba ka daɓaala, kaa təya ndzaanə patə. ");
INSERT INTO gde_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ca ŋgərə burooditə məɗəfə da hərəfiita, ca kuyirii tə Əntaŋfə, ca ɓaatsəpaa, ca vii ka lyawarənaakii, təya təəkəpaa ka ənja. ");
INSERT INTO gde_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Patənatii, təya zəmə, təya əburə. Lyawarənaakii a tsəəkətə ətə mbəɗaanə, ɗəvə məɗəfə. ");
INSERT INTO gde_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Ma ənjitə agi zəməta, dəbu'u ənfwaɗə, tsaŋə nə makinə da manjeevənə. ");
INSERT INTO gde_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Wata ca ba ka daɓaala, kaa təya palə satii. Ma daba'əkii, ca ndərəvə aasəkə kumbawala, ca palə aanə hanyinə ŋga Magadanə. ");
INSERT INTO gde_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Yoo, kə shi hara *Farisanyinə da *Sadukinyinə aaɓii Yeesu, kaa təya təkə tə ci. Təya ba ka ci, kaa ca ɗa ka tii sə ŋga hurəshishinə ətə ca ɓaarii oo'i, tə'i ci da baawəɗa ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","Əŋki Yeesu ka tii, “Ma uusəra a kula, maɗa dizə nə səkəntaŋfə, agi banə nuunə: ‘Pooshi ha ka tsəfənə doorə.’ ");
INSERT INTO gde_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Ma tsəɗakə əsə, maɗa tsaaməgyuunə aagi əntaŋfə, una nee dizə təku təku nə ha, agi banə nuunə: ‘Ka ndzəmənə nə vənə ənshinə.’ Maɗa tsaaməgyuunə aagi əntaŋfə, ka mbeenə nuunə ka batənə taa iitə nə ha a ndzaanə. Amma, pooshi unə ka mbee ka paaratəgi də ndzaanə ŋga zamanana. ");
INSERT INTO gde_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ma ənji ŋga zamanana, bwaya ənja, ənjitə pooshi ka nə'utə bariya ŋga Əntaŋfə nə tii. Agi alənə nə tii kaa ənjə a ɗa ka tii sə ŋga hurəshishinə. Amma, pooshi sə ŋga hurəshishinə ci ənjə a ɗa ka tii, maɗaamə ətə ɗii Əntaŋfə də anabi Yunana.” Makə waɓi ci ha'ə, wata ca palə saakii. ");
INSERT INTO gde_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Ma təya dzə də taŋənə asəkə kumbawala, wata lyawarənaakii a buurətə oo'i, kə zaanə ka tii nə ŋgərəənə buroodi. ");
INSERT INTO gde_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Yeesu a ba ka tii, “Nəhəmə noonə na acii burəŋanə ŋga Farisanyinə da ŋga Sadukinyinə.” ");
INSERT INTO gde_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Makə fii tii ha'ə, təya gwaŋə ka waɓənə ahadatii, əŋki tii, “Ma bii ci ha'ə, ətə pooshi amə ŋgiraanə buroodi.” ");
INSERT INTO gde_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Asee, kə shii Yeesu sətə ci təya ba. Wata əŋki ci ka tii, “Ya una, kə əki gi'inə goonə tə nyi. Ka mi cuuna waɓə agyanə ghatə buroodya? ");
INSERT INTO gde_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ca'ə əndzə'i, ma'ə unə mapaaratəgimə kuna? Kə zaanə koonə nə burooditə tufə ətə agi ənji dəbu'u tufə kwa? Ɗəvə moonə tsəəkətuunə tə ətə mbəɗaana? ");
INSERT INTO gde_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Aa ya burooditə məɗəfə əsa, ətə agi ənji dəbu'u ənfwaɗa? Ɗəvə moonə tsəəkətuunə tə ətə mbəɗaana? ");
INSERT INTO gde_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Iitə təkuree unə ka paaratəginə oo'i, ma cii kya waɓə koonə əna, əntaa agyanə buroodi. Nəhəmə noonə na acii burəŋanə ŋga Farisanyinə da ŋga Sadukinyinə.” ");
INSERT INTO gde_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Wata təya paaratəgi oo'i, əntaa banə bii ci ka tii oo'i, wa təya nəhə natii nə acii burəŋaatə ci ənjə a ɗa də buroodi. Amma, wa təya nəhə natii nə acii dzəgunənə ŋga Farisanyinə da ŋga Sadukinyinə. ");
INSERT INTO gde_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Yoo, kə gi Yeesu aanə hanyinə ətə kədəhə da vəranə ŋga Kayisariya Filipi. Makə gi ci, kə ləguyi ci ama lyawarənaakii, əŋki ci, “Ya nyi *Uuzənə ŋga ənda, wu saŋə nə nyi ci ənjə a ba?” ");
INSERT INTO gde_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Əŋki tii, “Agi banə nə hara ənji, hə nə Yoohana əndə ɗa bapətisəma. Əŋki hara ənji, hə nə anabi *Iliya. Hara ənji əsə, əŋki tii, hə nə Irimiya taa əndə'i anabi ŋga ŋukə.” ");
INSERT INTO gde_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Yeesu a ba ka tii, “Ya unə noona? Wu nə nyi cuuna ba?” ");
INSERT INTO gde_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Simoonə Piita a jikəvə, əŋki ci, “Hə nə Mataɗəkii, Uuzənə ŋga Əntaŋfə Əndə vii əpinə.” ");
INSERT INTO gde_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","Yeesu a ba ka ci, “Əndə barəkaanə nə hə, Simoonə, uuzənə ŋga Yunana. Acii əntaa əndə shiŋkinə ɓaarəgi ətsə ka hə, amma Daadə ətə dadagyə ɓaarəgi ka hə. ");
INSERT INTO gde_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","Wanyinə ka banə ka hə əsə: hə nə Piita, makə banə pasla. Anə paslanə nii kya mbukya Ikəliisiyaaki. Taa wa, pooshi na palee ka ŋgeerənə ŋga Ikəliisiyakii. ");
INSERT INTO gde_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Ka viinə nə nyi ka hə lakila ŋga makuvə ŋga ŋwaŋuunə ŋga dagyə. Taa mi patə anətə hə ganə a duuniya, ma'anəkii gatə dagyə. Ha'ə əsə, taa mi patə pərəgi hə ganə a duuniya, mapərəkii gatə dagyə.” ");
INSERT INTO gde_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Wata Yeesu a ɗa ka lyawarənaakii bariya də ŋgeerənə tuu'inə, “Goona ba ka taa wu oo'i, nyi nə *Mataɗəkii ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Daga ka saa'ikii 'watəgi Yeesu dzəgunətənə ka lyawarənaakii oo'i, tyasə see a dzə ci aa Urusaliima. Ma dava, ka sanə nə ci ciɓənyinə laŋə acii gayinə da madiigərə limanyinə da maliminə, ənjə a ɓələgi tə ci. Ma ka makkənə ŋga uusəra, ca maɗətə agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Makə fii Piita ha'ə, wata ca kəsəgi tə ci aataŋgala, ca wazə ka ci, əŋki ci, “Wa Əntaŋfə a dzagi ətsa, Slandana, pooshi ətsə ka ɗanə shaŋə!” ");
INSERT INTO gde_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Amma Yeesu a zə'wugi aaɓii Piita, əŋki ci ka ci, “Dzəgi aɓiiki, *Seetanə! Hərəmbəɗə nə hə ka nyi. Acii ma hiimatsaaku, ŋga əndə shiŋkinə, əntaa ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Wata Yeesu a ba ka lyawarənaakii, əŋki ci, “Taa wu patə ca moo nə'unə tə nyi, tyasə see a kaaree ci ka naakii nə, ca ŋgərə ənfwə ŋga gwa'avənə tə ci aashikii, ca nə'u də nyi. ");
INSERT INTO gde_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Taɗa wu patə ca ɗa gazhi'waanə ŋga gərətə əpinaakii, ka əteenə nə ci ka əpinəkii. Amma taɗa wu patə ətee ka əpinaakii putə ŋga nə'unə tə nyi, ka upaanə nə ci bwatyakii. ");
INSERT INTO gde_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Mi saŋə nə bwatya ŋga upaa patənə ŋga uushi'inə asəkə duuniya, amma əndə ətee ka əpinaakəya? Pooshi bwatyakii. Maɗa kə zii əpinə ŋga ənda, pooshi uushi cii kəya vii kaa ca ənə ka upaa də əpinəkii. ");
INSERT INTO gde_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Acii kədəhə nə Uuzənə ŋga əndə ka shinə tii da malaa'ikanyinaakii agi məghərəvənə ŋga Dii, ca vii shikwa taa ka wu makə sətə slənyi ənda. ");
INSERT INTO gde_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Tantanyinə cii kya ba koonə, tə'i hara ənji ganə ahadaamə na nee də ginətii, tii ma'ə maməətəmə, ka shinə ŋga Uuzənə ŋga ənda, kaa ca ndzaa ka ŋwaŋwa.” ");
INSERT INTO gde_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Ma daba'ə baanə kuwa, Yeesu a ŋgərə tə Piita da i Yakubu tii da ndzəkəŋuci, waatoo Yoohana, ca kərə tə tii aanə magərə giŋwa, wata tii ha'ə. ");
INSERT INTO gde_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ma təya nee, wata ca zə'wə akəŋwaciitii, ɓərənə nə kəŋwaciinəkii makə uusəra. Ha'ə nə kəjeerənaakii əsə, ca ɗagi tyaslyaslya makə əmputə kəbənə. ");
INSERT INTO gde_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Wata ma təya nee, watiitsə i Muusa da anabi *Iliya, təya waɓəshi da Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Wata Piita a ba ka Yeesu, “Slandana, ŋga'ə ɗii makə ganə niinə. Maa ŋga'ə ka hə, ka ratənə nə nyi koonə tsakabanyinə makkə ganə. Naaku rəŋwə, ŋga Muusa rəŋwə, ŋga Iliya rəŋwə.” ");
INSERT INTO gde_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Ma ci ma'ə agi waɓənə ha'ə, wata məzhiɗəkwatyaminə ətə ca ɓərə a zaɗəgi dagyanətii. Ma təya fa, əndə a waɓə agi məzhiɗəkwatyaminəkii, ca ba, “Waatsə Uuzənaaki, kə uu'i nyi tə ci. Ci ca uuɗagi səkəki. Famə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Makə fii lyawarənaakii ha'ə, wata ŋgwalənə a ɗa tə tii ka shaŋə, təya kwaalagi aa panə aanə kəŋwaciinətii. ");
INSERT INTO gde_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Wata Yeesu a əntsahə aaɓiitii, ca təɓətə tə tii, ca ba, “Maɗətəmə, goona ŋgwalə.” ");
INSERT INTO gde_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Makə maɗee tii ka ginətii, maneemə tii taa ka wu ma'ə, maɗaamə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ma təya dzə də jimanə satii a giŋwa, kə bii Yeesu ka tii, “Goona ba taa ka wu tə sətsə nee unə. See daba'ə maɗənaaki agi maməətə ənja, nyi *Uuzənə ŋga ənda.” ");
INSERT INTO gde_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Lyawarənaakii a ləgwa ka ci, əŋki tii, “Aa mi ɗii ci maliminə a ba oo'i, Iliya na takəŋwa shinə ka Aləmasiihu?” ");
INSERT INTO gde_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Yeesu a ba ka tii, “Weewee ha'ə makə ətsa, Iliya na shi zəku'i ka haɗatəgi də patənə ŋga uushi'inə. ");
INSERT INTO gde_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","Amma, wanyinə ka banə koonə: kə uugi Iliya shinə. Mashiimə ənji tə ci, təya ciɓə də ci makə sətə kaɗeesəkə ka tii. Ha'ə makə ətsə, kədəhə nə təya ciɓə də Uuzənə ŋga əndə əsə.” ");
INSERT INTO gde_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Wata lyawarənaakii a paaratəgi oo'i, ma Iliyatə cii kəya waɓə agyanəkii, ci nə Yoohana əndə ɗa bapətisəma. ");
INSERT INTO gde_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Ənyanatii aaɓii daɓaala, wata əndə'i əndə a shi, ca gərə'waanə akəŋwacii Yeesu, ");
INSERT INTO gde_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","ca ba, “Slandana, nəhuu təgunuunə ŋga uuzənaaki. Tə'i ma'idə'ida ashikii, agi ɗanə tə ci ka shaŋə. Ka əndə'i ha, ca kulagərə aagi gunə, ka əndə'i ha, aagi ma'inə. ");
INSERT INTO gde_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Kə kira nyi tə ci ka lyawarənaaku, amma kə təkuree tii ka mbəɗəpaanə də ci.” ");
INSERT INTO gde_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Əŋki Yeesu, “'Ya'əmə, unə ənji ŋga zamanana, pooshi unə gi'i tə Əntaŋfə, bwaya ənja. Ca'ə guci nii kya ndzaa doona? Ca'ə guci sə'watənəki tuuna? Kiramə ka nyi uuzənəkii ɗii!” ");
INSERT INTO gde_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Makə kira ənji, Yeesu a wazə ka ginaajikii, wata ginaajikii a shigi ashi uuzəəta. Pii wata kə mbə'i uuzəəta. ");
INSERT INTO gde_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Ma daba'əkii lyawarənaakii a əntsahətə aaɓii Yeesu daanətii, təya ləgwa ka ci, “Mi saŋə ɗii təkuree inə ka lyaakagi tə ginaajitsa?” ");
INSERT INTO gde_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Yeesu a ba ka tii, əŋki ci, “Putə ŋga gi'uunə ŋga gi'inə goonə tə nyi. Tantanyinə cii kya ba koonə, maci kə mbu'i gi'inə goonə tə nyi taa wata makə hi'u iza,  ");
INSERT INTO gde_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","1Amma, ma tsarə ŋga ginaajitsa, see də də'wa da suumaya mbeenə ənji ka lyaakaginə.” kaɗa ka banə nuunə ka giŋuna: ‘Duu aa hatə!’ ka dzənə nə ci əsə. Pooshi uushi ca kaɗee ka ŋgeerənə goonə. ");
INSERT INTO gde_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Guŋənə ŋga lyawarənə ŋga Yeesu patə anə hanyinə ŋga Galili, wata ca ndzaŋə waɓənə ka tii agyanə naakii na, ca ba, “Kədəhə nə ənji ka viinə tə Uuzənə ŋga əndə aacii ənja, ");
INSERT INTO gde_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","təya ɓələgi tə ci, amma ka maɗeenə nə ənji ka ci agi maməətə ənja ka makkənə ŋga uusəra.” Makə fii tii ha'ə, wata səkə ŋga lyawarənaakii a ɓəzəgi kuzhiɗə kuzhiɗə. ");
INSERT INTO gde_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Kə gi Yeesu da lyawarənaakii aa Kafarənahumə, wata ənji luu tsəkə ŋga yi ŋga Əntaŋfə a dzə aaɓii Piita, təya ləgwa, əŋki tii: “Ya saŋə, agi ki'inə nə maləmə goonə tsəkə ŋga yi ŋga Əntaŋfə nii?” ");
INSERT INTO gde_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Əŋki Piita, “Də ŋga'ə nə ci agi ki'inə.” Makə ənyi Piita aasii, Yeesu a waɓə ka ci zəku'i, əŋki ci, “Iitə nee hə naaku daa, Simoonə? Wu dəɓee ki'i tsəkə ka meeminə ŋga *duuniyana? Manjeevənatii nii, anii hara ənja?” ");
INSERT INTO gde_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Əŋki Piita, “Hara ənji dəɓee tsəkənə.” Wata Yeesu a ba, “Makə ha'ə ɗii, madəɓeemə manjeevənatii a tsəkə. ");
INSERT INTO gde_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","Amma, acii gaaŋwa ɓəzee ka səkətii, ma ɗanəku, duu aama uunəva, ha kagərə maŋgəlaŋa aagi ma'inə. Ma hərəfiitə 'watəgi hə kəsənə, ka lapaanə nə hə kwaɓa a makii bahə ki'inə də tsəkaaki da naaku, ha kərə ka tii.” ");
INSERT INTO gde_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Ma ka saa'ikii ha'ə, wata *lyawarənə ŋga Yeesu a shi aaɓiikii, təya ləgwa amakii, əŋki tii, “Wu saŋə palee də ɗuunuunə agi ŋwaŋuunə ŋga dagya?” ");
INSERT INTO gde_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Wata Yeesu a 'watə tə əndə'i uundzə uuzənə, ca kəŋee ka ci ahadatii, ");
INSERT INTO gde_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","ca ba, “Tantanyinə cii kya ba koonə: maɗa mazhi'weemə unə ka noonə nə makə ŋga uuji manjeevənə, pooshi unə ka upaa dəmənə aagi *ŋwaŋuunə ŋga Əntaŋfə shaŋə. ");
INSERT INTO gde_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Taa wu həətəpaa naakii nə, ca ndzaanə makə ŋga uuzəəna, ci palee də ɗuunuunə agi ŋwaŋuunə ŋga dagyə. ");
INSERT INTO gde_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Taa wu liwə uuzənə, maɗa putaaki liwə ci, tə nyi liwə ci ətsa.” ");
INSERT INTO gde_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","“Taa wu patə kavə tə taa rəŋwə agi manjeeviitə vii ka nyi gooŋga kaa ca pu'u, gəɗə anəvə təŋwə aa uurakii ka ci də ŋga'əənə, ca lipəgərə aagi uunəva, acii sətə na upaa tə ci. ");
INSERT INTO gde_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Tə'i ŋgəra'wə ashi ənji *duuniya, acii tə'i sətə ca kavə ənji ka ɗa 'waslyakəənə. Pooshi səndə ca təŋapaa tsarə ŋga uushi'iitsə ka ɗanə. Amma kə ɗii anə əndətə ca kavə əndə ka ɗa 'waslyakəənə. ");
INSERT INTO gde_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","“Maɗa ciinəku taɗa səɗəku ca kavə tə hə ka ɗa 'waslyakəənə, lagi, ha kagi. Gəɗə gi hə ka upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə yadə ciinə taa səɗa, acii ndzaanə da i ciinə bəra'i taɗa səɗə bəra'i, amma ənjə a ka tə hə aagi gunə ŋga ca'ə ndəŋwə ndəŋwə. ");
INSERT INTO gde_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Maɗa ginəku ca kavə tə hə ka ɗa 'waslyakəənə, hurə'yagi, ha kagi. Gəɗə gi hə ka upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə də ginə rəŋwə, acii ndzaanə da i ginə kyakya'ə bəra'i, amma ənjə a ka tə hə aagi gunə.” ");
INSERT INTO gde_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“Nəhəmə noonə na, acii goona bərapaa rəŋwə agi uuji manjeeviitsa. Wanyinə ka banə koonə: ma malaa'ikanyinatii, taa guci patə nə tii ka ndzaanə akəŋwacii Daadə ətə dagyə.  ");
INSERT INTO gde_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Acii ma shi *Uuzənə ŋga ənda, ka luupaa tə maza ənja. ");
INSERT INTO gde_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Iitə nee unə noonə agyanə sənə cii kya moo bana? Yaci tə'i əndə da bagiinaakii gya'ə saŋa, wata rəŋwə agitii a zagya, iitə ɗanəkəya? Əntaa ka bwaseenə nə ci ka ətə əliŋə pu'unə aji əliŋə ka zəmənə, ca palə ka alə tə ətə rəŋwə zagi kwa? ");
INSERT INTO gde_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Maɗa kə nee ci, tantanyinə cii kya ba koonə: ka ɗanə nə ci mooɗasəkə putə ŋga rəŋwə ətə sha zii, palee ka putə ŋga əliŋə pu'unə aji əliŋə ətə mazamə. ");
INSERT INTO gde_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Ha'ə əsə, ma Dəsənuunə ətə dadagyə, əntaa də uuɗənaakii zaginə taa rəŋwə agi uuji manjeeviitsa.” ");
INSERT INTO gde_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“Maɗa kə ɓəzee əndə nə'unə makə hə ka səkəku, ma ɗanəkwa, duu aaɓiikii, ha dzə ka ɓaarii ka ci 'waslyakəənaakii ahadoonə, unə bəra'i. Maɗa kə luuvə ci 'waslyakəənaakii, kə zhi'wavə hə də əndətə aa rəgwa ətsa. ");
INSERT INTO gde_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amma, maɗa maluumə ci 'waslyakəənaakii, 'waanə tə əndə rəŋwə taa ənji bəra'i atsaku, kaa ənji bəra'i taa makkə a mbee ka vii seeda anə patənə ŋga sətə bii ənji. ");
INSERT INTO gde_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Maɗa kə kaaree ci ka fa waɓənatii, bawə ka Ikəliisiya. Maɗa kə kaaree ci ka fanə tə Ikəliisiya əsə, geegimə ka ci makə əndətə pooshi ahadoonə taa *ənji luu tsəka.” ");
INSERT INTO gde_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“Tantanyinə cii kya ba koonə: taa mi patə anətuunə ganə a duuniya, ma'anəkii dagyə ətsa. Ha'ə əsə, taa mi patə pərəgyuunə ganə a duuniya, mapərəkii gatə dagyə ətsa. ");
INSERT INTO gde_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","“Wanyinə ka tsakə banə koonə əsə: maɗa kə anətə ənji bəra'i uura agyuunə kaa təya kədii taa mi patə, ka ɗanə nə Daadə ətə dagyə ka tii tə səkii. ");
INSERT INTO gde_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Acii taa da patə liɓə ənji bəra'i taa makkə agi ləməki, davə nə nyi ahadatii.” ");
INSERT INTO gde_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Ma daba'əkii, wata Piita a shi aaɓii Yeesu, ca ləgwa ka ci, əŋki ci: “Slandana, moonə səɗə saŋə ɗanə əndə ka nyi 'waslyakəənə, nya tifyagi ka ca? Səɗə məɗəfə kwa?” ");
INSERT INTO gde_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Yeesu a ba ka ci, “Pooshi. Əntaa wata səɗə məɗəfə bii nyi koonə. Amma, məɗəfə səɗə ha'ə məɗəfə pu'unə. ");
INSERT INTO gde_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Acii ma ŋwaŋuunə ŋga dagyə, mbərə mbərə nə ci da əndə'i ŋwaŋutə mwayi ɓaanatənə taa iitə nə gəna acii maviinaakii. ");
INSERT INTO gde_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Ma ca 'watəgi ɓaananə ha'ə, wata ənjə a kira ka ci mavatə cii kəya nə'u tə ci milyoonyinə ŋga kwaɓa. ");
INSERT INTO gde_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","Amma, ma mavakii, paa ci da taa mi bahə kaa ca ki'i kwaɓatə ci ŋwaŋwə a nə'u tə ci. Wata ŋwaŋwə a ba ka ənjə a ɗərəmagi də ci da minaakii da manjeevənaakii da uushi'inaakii patə, kaa ənjə a shii ki'i də kwaɓakii. ");
INSERT INTO gde_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Makə fii mavatə ha'ə, wata ca kulagi akəŋwacii ŋwaŋwa, ca dza ciinə, ca ba: ‘Tuutəta'ə, əsuu ədzəma, ka ki'iginə nə nyi ka hə gənaaku patə.’ ");
INSERT INTO gde_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Wata ŋwaŋwə a nəhə təgunuunaakii, ca tifyagi ka ci, ca kapaa tə ci. Mavatə a palə saakii. ");
INSERT INTO gde_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Amma, makə pyalə ci saakii, wata ca lapaa əndə'i mava makə ci ətə cii kəya nə'u tə ci dəmənə ŋga *hwaslə gya'ə tanə. Wata ca tərəɗəgi kəjeerənə a uura mavata, əŋki ci: ‘Ki'iwu ka nyi dəmənaaki!’ ");
INSERT INTO gde_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Wata mavatə a kulagi akəŋwaciikii, ca dza ciinə, əŋki ci: ‘Tuutəta'ə, əsuu ədzəma, ka ki'inə nə nyi ka hə dəmənaaku.’ ");
INSERT INTO gde_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Amma kə naanagi ci, wata ca kərə tə ci aa furəshina, see maɗa ki'igi ci dəməətə atsakii. ");
INSERT INTO gde_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","“Makə nee hara maviinə ka sətə slənyi, kə zhima tə tii asəkətii. Wata təya palə aaɓii ŋwaŋwa, təya bagi ka ci sətə slənyi patə. ");
INSERT INTO gde_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Makə fii ŋwaŋwə ha'ə, wata ca 'wagərə tə mavatə ɗii ha'ə. Ŋwaŋwə a dzaana tə ci, əŋki ci: ‘Ma hə, bwaya mava nə hə. Kə tifyagi nyi ka hə patənə ŋga kwaɓatə nji nya nə'u tə hə putə ŋga kədiinaaku aciiki. ");
INSERT INTO gde_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Pooshi diɓə ha nəhə təgunuunə ŋga guva-slənaaku makə sətə nyihə nyi naaku kwa?’ ");
INSERT INTO gde_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Kə ɓəzhi səkə ŋga ŋwaŋwə ka shaŋə. Wata ca sləkee ka ənjə a pa'əgi tə mavatə a furəshina, ənjə a ciɓə də ci, see maɗa ki'igi ci patənə ŋga gənata.” ");
INSERT INTO gde_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Yeesu a uudəpaa waɓənə, əŋki ci, “Ha'ə əsə nə Daadə ətə dadagyə a ɗa ka taa wu patə agyuunə, maa pooshi ci tifyagi ka ndzəkəŋuci 'waslyakəənaakii də ədzəmə rəŋwə.” ");
INSERT INTO gde_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Makə uugi Yeesu baaba uushi'iitsa, wata ca maɗə anə hanyinə ŋga Galili, ca palə aanə hanyinə ŋga Yahudiya ataŋəgi gəərə ŋga Urədunə. ");
INSERT INTO gde_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Daɓaala laŋə nyi'u tə ci, ca mbəɗəpaa də ənji bwanea. ");
INSERT INTO gde_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Hara *Farisanyinə a dzə aaɓiikii ka təkənə tə ci də ləgwanə amakii, əŋki tii, “Ya əna, kə vii bariya gaamə rəgwa ka əndə a lakəgi minaakii putə ŋga taa ŋgutə uushi kwa?” ");
INSERT INTO gde_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Ca ənəgi ka tii, “Pooshi unə jaŋgii asəkə malaaɓa ləkaləkatə kwa? Ma bii ca: ‘Ma ka 'watəginə, ŋgurə da minə ghənyi Əntaŋfə tə ənja.’ ");
INSERT INTO gde_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Əntaŋfə a ba: ‘Putakii ha'ə, wa ŋgurə a bwasee ka dii da məci, ca ləɓə tii da minaakii, təya ndzaa shishinə rəŋwə.’ ");
INSERT INTO gde_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","Də ha'ə, ndzaanə tii əndə rəŋwə, əntaa ənji bəra'i ma'ə. Aciikii, ma sətə gəŋutəgi Əntaŋfə, ga əndə a təkee.” ");
INSERT INTO gde_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Farisanyinə a ba ka Yeesu, “Aa, acii mi ɗii bii Muusa, wa əndə a vii ka minə ləkaləkatə ŋga lakəginə tə ki, ca lakəgi tə kya?” ");
INSERT INTO gde_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Yeesu a ba ka tii, “Putə ŋga ndalənə ŋga ədzəmuunə kapaa Muusa koonə rəgwa ŋga lakəgi makinə goonə. Amma, ma ŋga ŋukə, saa'i ŋga 'watəginə ŋga duuniya, əntaa ha'ə. ");
INSERT INTO gde_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Wanyinə ka banə koonə: taa wu patə lakəgi minaakii putə ŋga əndə'i uushi pamə tsaŋə da aləhiinə, ca ŋgərə əndə'i, kə ali ci hiinə ətsa.” ");
INSERT INTO gde_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Lyawarənaakii a jikəvə ka ci, “Maɗa ha'ə ahada i ŋgurə tii da minaakii ətsa, əntaa gəɗə ndzaanə yadə ŋgərəshinə dəŋwa'ə kwa?” ");
INSERT INTO gde_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Amma ca ba ka tii, “Ma dzəgunəətsa, əntaa taa wu ca luu, amma see ənjitə vii Əntaŋfə ka tii. ");
INSERT INTO gde_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Acii tə'i rəgwanyinə kama kama ətə pooshi ənji ka ŋgərəshinə: tə'i hara ənji, putə ŋga poonə tə tii ha'ə, paa tii ka ŋgərəshinə. Hara ənji əsə, ənji saawee ka tii. Hara ənji əsə, paa tii ka ŋgərəshinə putə ŋga ŋwaŋuunə ŋga dagyə. Ma əndətə ca mbee ka luu dzəgunəətsa, wa ca luu.” ");
INSERT INTO gde_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Ma daba'əkii, kə kirə ənji manjeevənə ka Yeesu, kaa ca ɗaanə ciinə aanətii, ca ɗa ka tii də'wa. Amma, ma lyawarənaakii, kə laalii tii ŋguruunə ka ənja. ");
INSERT INTO gde_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Amma Yeesu a ba, “Uneemə ka manjeevənə, kaa təya shi aaɓiiki, goona təŋa tə tii, acii ka tsarə ŋga ənji makə tii də ŋwaŋuunə ŋga dagyə.” ");
INSERT INTO gde_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Ca ɗaanə ciinə aanətii. Ma daba'əkii, ca maɗə davə, ca palə saakii. ");
INSERT INTO gde_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Ma ka əndə'i uusəra, kə shi əndə'i əndə aaɓii Yeesu, ca ləgwa, əŋki ci, “Maləma, ŋgutə ŋunyi slənə saŋə slənəki, kaa nya upaa də əpinə ŋga ca'ə ndəŋwə ndəŋwa?” ");
INSERT INTO gde_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","Əŋki Yeesu ka ci, “Ka mi dee cii kwa ləgwa ka nyi agyanə sətə ŋunyikəya? Rəŋwə dyaŋə nə ŋunyi Ənda. Maɗa ŋga'ə ka hə nə upaa əpiitsa, nə'utə *bariya.” ");
INSERT INTO gde_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Əndətə a ləgwa ka ci, “Ŋgutə tsarə ŋga bariya da?” Yeesu a ba ka ci, “Ga ha ɓələ hiinə, ga ha alə hiinə, ga ha hərə hiinə, ga ha vii seeda ŋga jirakənə anə ənda, ");
INSERT INTO gde_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","gaɗee ka i duu da muu, uuɗuu tə əndətə aɓiiku makə sətə cii kwa uuɗə naaku na.” ");
INSERT INTO gde_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Əŋki uundzə dagwatə ka ci, “Ma ətsə patə, kə nə'utə nyi. Ŋgutə mbəɗaanə ka nyi, kaa nya nə'uta?” ");
INSERT INTO gde_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","Yeesu a ba ka ci, “Maɗa kə mwayi hə ndzaanə makətsəɗəkii, duu ka ɗərəmaginə də uushi'inaaku patə, ha təəkəpaa kwaɓakii ka maaghiinə. Maɗa kə ɗii hə ha'ə, ka ndzaanə nə shigaaku dagyə aɓii Əntaŋfə. Ma daba'əkii, ha shi ka nə'u tə nyi.” ");
INSERT INTO gde_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Makə fii uundzə dagwatə ha'ə, ca palə saakii də maɓətəsəka, acii laŋə dərəva nə gəna aciikii. ");
INSERT INTO gde_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Wata əŋki Yeesu ka lyawarənaakii, “Tantanyinə cii kya ba koonə, dzawə dərəva nə dəmənə ŋga əndə gəna aagi ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","A tsakə nyi banə koonə əsə: gəɗə dəməginə ŋga ŋgyalooba ka rəgwa shinə ŋga libəra də ŋgufənə, acii dəmənə ŋga əndə gəna aagi *ŋwaŋuunə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Makə fii lyawarənaakii waɓəətsa, kə dzəgəpaa tə tii ka shaŋə, təya ba, “Maɗa ha'ə əna, aa wu ɗii nə upaa luupaana?” ");
INSERT INTO gde_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Amma Yeesu a tsaamə tə tii, ca ba, “Ma əndə shiŋkinə, pooshi uushi cii kəya mbee ka ɗatənə ci saakii ka upaa də luupaanə. Amma, ma Əntaŋfə, ka ɗatənə nə ci taa mi patə.” ");
INSERT INTO gde_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Piita a jikəvə ka ci, əŋki ci, “Yoo, waniinə kə bwasee inə ka uushi'inə patə əna, ina nə'u tə ha, mi niina upana?” ");
INSERT INTO gde_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Əŋki Yeesu ka tii, “Tantanyinə cii kya ba koonə: maɗa kə ndzaa nyi, nyi Uuzənə ŋga əndə, dasə anə dəgələ ŋga məghərəvənaakii agi kura zamanatə na shi, ma unə ənə pu'u aji bəra'i ənə nyi'u tə nyi, ka ndzaanə nuunə anə dəgələ ŋwaŋuunə pu'u aji bəra'i, una ɗa gəŋwanə ka slikərənyinə pu'u aji bəra'i ŋga *Isərayiila. ");
INSERT INTO gde_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Taa wu patə bwasee ka yaakii, taɗa ndzəkəŋushi'inəkii, taɗa cikəŋushi'inəkii, taɗa dii, taɗa məci, taɗa manjeevənaakii, taɗa raakii putə ŋga nə'unə tə nyi, ka upaanə nə ci gya'ə palee ka ətə bwasee ci aaba'ə, ənjə a vii ka ci əpinə ŋga ca'ə ndəŋwə ndəŋwə əsə. ");
INSERT INTO gde_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amma laŋə nə matakəŋwanyinə na ndzaanə ka moodəba'ənyinə. Laŋə nə moodəba'ənyinə əsə na ndzaanə ka matakəŋwanyinə.” ");
INSERT INTO gde_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“Ma ŋwaŋuunə ŋga dagyə, kə ndzaa ci mbərə mbərə da əndə'i slanda ya ətə gimagi tsəɗakə ka alə ənji sləna, kaa təya dzə ka slənənə ka ci asəkə tsanə ŋga inabaakii. ");
INSERT INTO gde_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Makə upaa ci ənji sləna, kə luuvə ci ki'inə ka tii makə sətə ci ənjə a ki'i ŋga ka uusəra, waatoo *hwaslə rəŋwə. Wata ca kərə tə tii aasəkə tsanə kaa təya slənə. ");
INSERT INTO gde_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Ca ənə ka dzənə aa luuma tibisə əliŋə, ca lapaa tə hara ənji pooshi uushi ci təya ɗa. ");
INSERT INTO gde_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Wata ca ba ka tii əsə: ‘Dəmə ka ɗa ka nyi slənə asəkə tsanə. Ka ki'inə nə nyi koonə makə sətə diɓə.’ ");
INSERT INTO gde_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Wata təya dzə. Makə ənyi ci ka dəməginə uusərə ahadana, ha'ə əsə tibisə makkə, təya ɗa ha'ə da hara ənji slənə makə əta. ");
INSERT INTO gde_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Ma ətsə kədəhə ka tibisə tufə əsə, makə gi ci aa luuma, ca lapaa hara ənji əsə kəŋə kəŋə davə. Ca ba ka tii: ‘Mi cuuna kagi uusəra zaɓə kwa?’ ");
INSERT INTO gde_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Təya ba ka ci: ‘Acii pooshi əndə ŋgirə tiinə ciina kagi uusəra zaɓə.’ Wata ca ba ka tii əsə: ‘Dəmə ka slənənə ka nyi asəkə tsanə ŋga inabi.’ ");
INSERT INTO gde_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“Makə ɗii kədəwanə, wata slanda tsanə ŋga inabitə a ba ka gawə ŋga ənji slənaakii: ‘'Waa'wawə tə ənji slənətsa, ha ki'i ka tii kwaɓatii. Ka ənjitə uugi ba'ə ka dzənə 'watəginəku ki'inə, ha uudəpaa də ənjitə 'watəgi dzənə.’ ");
INSERT INTO gde_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Ma ənjitə gi tibisə tufə, ənjə a vii ka taa wu agitii hwaslə rəŋwə. ");
INSERT INTO gde_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Yoo, makə mbu'i aanə ənjitə 'watəgi dzənə aadəvə aasəkə tsanə, ma nə tii ka nəhənə, ka viinə nə ənji ka tii sətə palee ka ŋga ənjitə uugi ba'a. Asee, tii maa, hwaslə rəŋwə rəŋwə vii ənji ka tii. ");
INSERT INTO gde_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Makə liwə tii kwaɓatii, wata təya ŋgəərə ma agyanə slanda tsaata, ");
INSERT INTO gde_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","əŋki tii: ‘Ma ənjinə uugi hə ba'ə ka ŋgərənə, ŋga tibisə rəŋwə tanə slənyi tii. Amma, ha ki'i keenə uushi rəŋwə nii? Inə ənə kagi uusəra pa'ə ka slənənə, əŋki hə tsəfənə ŋga uusəra!’ ");
INSERT INTO gde_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Amma slanda tsaata ənəpaagi ka əndə'i əndə agitii, əŋki ci: ‘Guvakya, ma'adəmə nyi tə hə. Əntaa agyanə hwaslə rəŋwə narii aŋwə kwa? ");
INSERT INTO gde_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Ŋgəruu sətə narii aŋwə, ha palə saaku aasii. Ha'ə mwayi nyi viinə ka əndənə shi ŋga muudinə makə naaku. ");
INSERT INTO gde_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Anii pooshi nyi da baawəɗa ŋga ɗa sətə mwayi nyi də kwaɓaakya? Anii sərəhə ca ɗa tə hə putə ŋga ŋga'əənaakya?’ ” ");
INSERT INTO gde_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Yeesu a uudəpaa waɓənə, əŋki ci, “Ha'ə əsə, ma moodəba'a, ka ndzaanə nə ci ka ŋga təkəŋwanə. Ma ŋga təkəŋwanə əsə, ka ndzaanə nə ci ka moodəba'a.” ");
INSERT INTO gde_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Ma Yeesu a dzə aa Urusaliima, ca 'wagi tə lyawarənaakii pu'u aji bəra'i tsaŋə aataŋgala, ca ba ka tii, təya dzə də palənə, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Fatəmə ŋga'ə! Wanaamə ka dzənə aa Urusaliima. Ma dava, ka dzənə nə ənji ka viinə tə Uuzənə ŋga əndə aacii madiigərə limanyinə da maliminə, təya lagi ka ci gəŋwanə ŋga ɓələnə, ");
INSERT INTO gde_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","təya vii tə ci aacii ənjitə mashiimə tə Əntaŋfə. Ma təya, ka ŋusənə nə tii tə ci, təya fəslə tə ci, təya gwa'avə tə ci aashi ənfwa. Ma ka makkənə ŋga uusəra, ənjə a maɗee ka ci agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Ma daba'əkii ha'ə, wata məci manjeevənə ŋga Zabadiya a əntsahə tii da manjeevənatə aaɓii Yeesu, kya gərə'waanə akəŋwaciikii ka kədii uushi. ");
INSERT INTO gde_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","Ca ləgwa ka ki, “Mi cii kwa uuɗə kwa?” Kya ba ka ci, “Ɗawə ka nyi rəgwa kaa manjeevənaaki bəra'i a ndzaanə ataŋgalaku agi ŋwaŋuunaaku, əndə'i da ciizəmaku, əndə'i əsə da madzənaku.” ");
INSERT INTO gde_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Yeesu a ba ka tii, “Mashiimuunə sətə cuuna kədii. Kadə nuuna mbee ka sə'watə sa ciɓə makə ətə nii kya sa kwa?” Əŋki tii ka ci, “Awa, ka mbeenə niinə.” ");
INSERT INTO gde_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Yeesu a ba ka tii, “Ka sanə nuunə weewee. Amma, ma ndzaanə ataŋgalaki, əntaa nyi nəndə da baawəɗa ŋga viinə. Ma hatsa, ŋga ənjitə taɗəpaa Daadə tə tii.” ");
INSERT INTO gde_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Fanə ŋga hara lyawarənaakii pu'u tə waɓəətsa, wata səkətii a ɓəzəgi aashi ndzəkəŋushi'iitə bəra'i. ");
INSERT INTO gde_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Wata Yeesu a 'watə tə tii patə aaɓiikii, ca ba ka tii, “Kə shii unə oo'i, ma ənjitə mashiimə tə Əntaŋfə, meeminatii ca ɗa ŋwaŋuunə agyanətii. Ma madiigərə ənjatii əsə, agi kanə nə tii ka tii *bariya də baawəɗa. ");
INSERT INTO gde_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amma ma unə, pooshi ka ɗanə ha'ə ahadoonə. Taa wu patə mwayi ndzaanə ka gawə ahadoonə, see a ndzaa ci ka əndə slənə goonə. ");
INSERT INTO gde_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Ha'ə taa wu patə mwayi ndzaanə ka matakəŋwanə ahadoonə, tyasə see a ndzaa ci ka mava goonə. ");
INSERT INTO gde_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Ha'ə nə nyi Uuzənə ŋga əndə əsə. Ma shi nyi, əntaa ka ənjə a slənə ka nyi, amma, kaa nya slənə ka ənja, nya vəgi əpinaaki ka pərapaanə də ənji laŋə.” ");
INSERT INTO gde_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Ma Yeesu da lyawarənaakii a bwasee ka vəranə ŋga Yarikoo, dzənə nə daɓaala laŋə də nə'unə tə tii. ");
INSERT INTO gde_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Tə'i muurəfinə bəra'i dasə dasə ataŋgala rəgwa. Makə fii tii oo'i, Yeesu ətsə ca pitəgi, wata təya maɗee ka uuratii, əŋki tii, “Slandana, *jijinə ŋga Dawuda, nəhuu təgunuunə geenə!” ");
INSERT INTO gde_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Daɓaala a wazə ka tii, ənjə a ba ka tii, “Ndzaamə kəɗa'ə!” Amma, ma muurəfiita, wata təya tsakə ŋgəree ka uuratii palee ka əta, əŋki tii, “Slandana, jijinə ŋga Dawuda, nəhuu təgunuunə geenə.” ");
INSERT INTO gde_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","Wata Yeesu a kəŋaanə, ca 'wa tə tii, ca ba, “Mi cuuna moo nya ɗa koona?” ");
INSERT INTO gde_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Təya ba ka ci, “Slandana, ŋga'ə keenə, keena nee ka ha.” ");
INSERT INTO gde_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Kə nyihə Yeesu təgunuunatii, ca təɓətə ginətii. Pii wata təya ənə ka neenə ka ha, təya nə'u tə ci dəŋwa'ə. ");
INSERT INTO gde_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Ma ətsə i Yeesu da lyawarənaakii kədəhə ka mbu'unə aasəkə vəranə ŋga Urusaliima, təya mbu'u aa Bayitifaaji ashi giŋwə ŋga Zayitunə, wata ca sləkee ka hara lyawarənaakii bəra'i ");
INSERT INTO gde_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","də banə ka tii, “Dəmə aasəkə vəraatsa. Maɗa kə mbu'yuunə, pii ka lapaanə nuunə vamənda gwalə da uuzənatə. Pəryatəmə, una kira ka nyi. ");
INSERT INTO gde_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","Maɗa kə ləguyi əndə a moonə taa ka mi cuuna pərə, bamə ka ci: ‘Slandanə mwayi.’ Maɗa kə fii ci ha'ə, ka bwaseenə nə ci koonə pii pii.” ");
INSERT INTO gde_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Ma slənyi ətsa, ka mbu'utəginə də sətə bii anabi oo'i: ");
INSERT INTO gde_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“Bamə ka ənji vəranə ŋga *Sihiyoona: ‘Tsaaməmə! Wiitsə ŋwaŋwə goonə ka shinə aa hoonə! Əndə haŋkala nə ci, aba'ə vamənda nə ci, waatoo aba'ə uundzə vamənda.’ ” ");
INSERT INTO gde_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Wata lyawariitə a maɗə, təya palə, təya ɗatə makə sətə bii Yeesu ka tii. ");
INSERT INTO gde_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","Təya kira vaməndatə ba'ə uundzəkii, təya luukutəvə kəjeerənyinatii aa ba'ətii. Wata Yeesu a ndərəvə. ");
INSERT INTO gde_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Ma daɓaala, kə sasafəpaa tii kəjeerənyinatii a rəgwa, hara ənjə a pusha ba ŋga ənfuginə, təya sasafə a rəgwa. ");
INSERT INTO gde_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ma daɓaalatə davə, dakəŋwaciikii da daba'əkii patə, kə ŋgəree tii ka uuratii, təya ba, “Dəlanə də jijinə ŋga *Dawuda! Tə'i barəkaanə ashi əndətə ca shi də ləmə ŋga Slandana! Dəlaamə də Əntaŋfə!” ");
INSERT INTO gde_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Makə mbu'i Yeesu aa Urusaliima, wata vəranəkii a gwazəgi purətə, ənji patə a ləgwa, “Wu saŋə nə əndətsa?” ");
INSERT INTO gde_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Daɓaala a ba, “Ma əndətsa, ci nə anabi Yeesu ətə shi daga də Nazaratu anə hanyinə ŋga Galili.” ");
INSERT INTO gde_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Mbu'unaakii wata ca dəməgərə aasəkə yi ŋga Əntaŋfə, ca shaabagi tə patənə ŋga ənji ɗa fiiriinə davə, ca dzaadzapaa ha ŋga pəra kwaɓa da dəgələnyinə ŋga ənji ɗərə də bilyamasariinə, ");
INSERT INTO gde_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ca ba ka ənjita, “Tə'i manaahəkii asəkə malaaɓa ləkaləkatə oo'i, ma bii Əntaŋfə, ‘Yi ŋga ɗa də'wa 'wanə ənji yaaki.’ Amma, ma una, agi geeginə nuunə ka yikii ka ha ŋga umbənə ŋga mahiirənə.” ");
INSERT INTO gde_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Wata muurəfinə da mahurəməsə ənjə a shi aaɓii Yeesu aasəkə yi ŋga Əntaŋfə, ca mbəɗəpaa də tii. ");
INSERT INTO gde_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Ma madiigərə limanyinə da maliminə, kə zhima tə tii asəkətii, makə nee tii ka sə ŋga hurəshishiitə cii kəya ɗaaɗa, manjeevənə əsə a dzə də ka wanyanə asəkə yi ŋga Əntaŋfə, təya ba, “Dəlanə də jijinə ŋga Dawuda!” ");
INSERT INTO gde_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Wata təya ləgwa ka Yeesu, “Agi fanə nə hə sətsə ci manjeeviitsə a ba see?” Yeesu a ba ka tii, “Awa, agi fanə nə nyi. Pooshi unə sha jaŋgii kunə asəkə malaaɓa ləkaləkata? ətə bii ca, ‘Kə tasəkapaa hə tə manjeevənə da ətə ma'ə ka sa 'wanə, kaa təya dəla də hə.’ ” ");
INSERT INTO gde_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Ma daba'əkii, Yeesu a bwasee ka tii, ca gimagi asəkə vəranəkii, ca palə saakii aa Bayitaniya, ca baanə davə. ");
INSERT INTO gde_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Pukətə hakii tsəɗakə, ma Yeesu a ənya aasəkə vəranə ŋga Urusaliima, kə ɗii maɗəfənə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Wata ca lapaa ənfwə uudəvə ataŋgala rəgwa, ca dzə aatsakii. Amma, malapaamə ci pookii davə, wata ba səgafə. Wata ca naalagi tə ənfuta, əŋki ci, “Pa ha poo ma'ə shaŋə!” Pii wata ənfwə uudəvətə a huurəgi hwa'ə. ");
INSERT INTO gde_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Makə nee lyawarənaakii ha'ə, kə ɗii ka tii ka sə ŋga hurəshishinə. Əŋki tii, “Iitiitə daa huurəgi uudəvətsə pii pii ha'a?” ");
INSERT INTO gde_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Yeesu a ba ka tii, əŋki ci, “Tantanyinə cii kya ba koonə: maɗa kə gi'yuunə tə Əntaŋfə yadə hiimanə oo'i, mbu'u taa pooshi ha'ə ka ɗanə, əntaa wata sənə ɗii nyi ka uudəvətsə ɗanuunə tanə, amma taa ka giŋunə maa, ka mbeenə nuunə ka banə: ‘Mbuɗuu, ha dzə ka kulagərənə aagi uunəva!’ Ka ɗanə ha'ə əsə. ");
INSERT INTO gde_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Maɗa kə gi'yuunə tə Əntaŋfə, taɗa mi patə kədii unə agi də'wa, ka upaanə nuunə səkii.” ");
INSERT INTO gde_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Makə dzəgərə Yeesu aasəkə yi ŋga Əntaŋfə, ca dzəgunə ka ənja, wata madiigərə limanyinə da gayinə a shi aaɓiikii, təya ləgwa ka ci, əŋki tii, “Də ŋgutə baawəɗa saŋə cii kwa ɗaaɗa uushi'iinə ha'a? Wu saŋə vii ka hə baawəɗatsa?” ");
INSERT INTO gde_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Yeesu a ba ka tii, əŋki ci, “Nyi maa, ka ləgwanə nə nyi koonə naaki uushi rəŋwə. Maɗa kə bagyuunə ka nyi, nyi maa, ka banə nə nyi koonə taɗa də ŋgutə baawəɗa cii kya ɗaaɗa uushi'iina. ");
INSERT INTO gde_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Ya əna, wu saŋə sləkee ka Yoohana kaa ca ɗa bapətisəma ka ənja? Əntaŋfə nii, anii ənda?” Wata təya ɗa mabizhinə ahadatii, təya ba, “Mi banaamə əna? Maɗa bii amə oo'i, Əntaŋfə sləkee ka Yoohana, ka banə nə ci, aa mi pooshi unə luuvə waɓənaakii ɗiya? ");
INSERT INTO gde_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amma maɗa kə bii amə oo'i, ənji sləkee ka ci, ŋgwalii amə acii daɓaala, acii ma təya, kə luuvə tii oo'i, anabi nji Yoohana.” ");
INSERT INTO gde_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Wata əŋki tii ka ci, “Mashiimiinə taa wu sləkee ka ci.” Əŋki Yeesu ka tii naakii, “Ha'ə nə nyi əsə, paa nyi ka banə koonə taɗa də ŋgutə baawəɗa cii kya ɗa uushi'iina.” ");
INSERT INTO gde_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“Iitə nee unə noonə agyanə sənə cii kya moo banə koona? Tə'i əndə sha ɗii da i uuji ŋguyirənaakii bəra'i. Ca dzə aaɓii gawəkii, ca ba ka ci: ‘Uuzənaakya, duu ka slənənə asəkə tsanə ŋga inabi ənshinə.’ ");
INSERT INTO gde_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","Uuzəətə a ba ka ci: ‘Paa nyi ka dzənə.’ Amma, ma daba'ə, ca baanə ka dii, ca dzə ka sləna. ");
INSERT INTO gde_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Dii a dzə aaɓii dara əsə, ca ba ka ci makə sətə bii ci ka gawəkii. Uuzəətə a ba ka dii: ‘Ka dzənə nə nyi ɗii, daadə.’ Amma, madzəmə ci. ");
INSERT INTO gde_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Ya agi manjeeviitsa, wu saŋə slənyi sətə mwayi dəsənətəya?” Təya ba, “Gawəkii.” Wata Yeesu a ba ka tii, “Tantanyinə cii kya ba koonə: ənji luu tsəkə da badawiinə ŋga makinə na ta koonə kəŋwanə aagi *ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Acii ma shi Yoohana, kaa ca ɓaarii koonə ŋunyi rəgwa ŋga nə'unə. Amma, maluuvəmuunə waɓənaakii. Amma ənji luu tsəkə da badawiinə ŋga makinə, kə luuvə tii waɓənaakii. Taa makə nee unə ka sətə ɗii ənjitsə maa, makatəmuunə hiima ŋga luu waɓənaakii.” ");
INSERT INTO gde_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Wata Yeesu a tsakə banə ka tii, əŋki ci, “Fatəmə, kaa nya ba koonə əndə'i misaali. Ma sha ɗii, tə'i əndə'i əndə ɗii rə ŋga inaba. Ca tsatə, ca tələgi gu'u ŋga mya'ə də inaba, ca ghənəgi magərə ha ŋga nəhə uushi'inə, ca ŋgərə rəkii, ca vəgi ka mooziinə, kaa təya təkə cifanə ŋga rəkii da i ci. Ma daba'əkii, ca palə oogə. ");
INSERT INTO gde_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Makə mbu'ya saa'i ŋga cifanə ŋga inaba, wata ca sləkee ka ənji slənaakii ka liwa ka ci gyaɗalaakii aciitii. ");
INSERT INTO gde_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Wata mooziitə a kəəsətə tə lyawariita, təya fəsləgi rəŋwə, təya ɓələgi rəŋwə. Əndə'i əsa, təya kaalatə tə ci də faariinə. ");
INSERT INTO gde_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Slanda rətə a ənə ka sləkee ka hara lyawarənə palee ka ŋga təkəŋwanə də ɓəzəənə. Wata mooziitə a ənə ka ɗanə ka tii ha'ə əsə. ");
INSERT INTO gde_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Ma daba'əkii, ca sləkee ka tii ka uuzənaakii, ca ba, ‘Weewee, ka neenə nə tii ka məghərəvənə ŋga uuzənaaki.’ ");
INSERT INTO gde_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amma, makə nee mooziitə ka uuzənaakii, wata təya ba ahadatii, ‘Waanə mazəmə yi kə mbu'ya. Shoomə, kaama ɓələgi tə ci, ama zəmə ya.’ ");
INSERT INTO gde_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Wata təya kəsətə tə ci, təya kagi tə ci aa ba'a tsanə, təya ɓələgi tə ci. ");
INSERT INTO gde_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","“Ya ətsa, maɗa kə gi slanda rətsa, mi ɗanəkii də mooziitsa?” ");
INSERT INTO gde_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Ənjə a ba ka Yeesu, “Weewee ɓəələginə ɓəələginəkii tə bwaya aginyiitsa, ca vii rəkii ka hara ənji slənə pamə ətə na vii ka ci gyaɗalə ŋga inabaakii ka cifanəkii.” ");
INSERT INTO gde_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Yeesu a ba ka tii, “Mashiimuunə a jaŋgii asəkə malaaɓa ləkaləkatə kuna? ətə bii ci: ‘Ma faaratə kaaree ənji ghənə kuva makə pooshi nafaakii, ci ənəpaa ka faaratə palee də məghərəvənə. Ma ətsa, slənə ŋga Slandana. Ma amə əsə, sə ŋga hurəshishinə kaamə.’  ");
INSERT INTO gde_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","44","“Taa wu kulii aanə faaratsa, ka əɓinə nə ci. Maɗa kə kulii faarakii aanə əndə əsa, ka ədəginə tə ci makə əmpunə. Acii ha'ə cii kya ba koonə: ma *ŋwaŋuunə ŋga Əntaŋfə, kadə nə ənjə a ŋgərəgi acii unə, ənjə a vii ka ənjitə ca vii ŋunyi cifanə.” ");
INSERT INTO gde_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Fanə ŋga madiigərə limanyinə da *Farisanyinə tə misaalinyiitsə ɗii Yeesu, wata təya paaratəgi oo'i, agyanətii cii kəya waɓə. ");
INSERT INTO gde_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Wata təya alə rəgwa ŋga kəsənə tə ci. Amma təya ŋgwaləgi acii daɓaala, acii ma daɓaala, kə luuvə tii oo'i, anabi nə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Yeesu a tsakə waɓənə ka tii də misaali, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Ma ŋwaŋuunə ŋga dagyə, kə ndzaa ci mbərə mbərə da ŋwaŋutə ɗii əndzanə ŋga da məhura ŋga uuzənaakii. ");
INSERT INTO gde_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Ca sləkee ka lyawarənaakii ka dzənə ka 'waa'wanə tə ənjitə baabii ci ka tii shinə ka zəmə əndzanəkii. Amma kə naanagi tii ka shinə. ");
INSERT INTO gde_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Ŋwaŋutə a ənə ka sləkeenə ka hara lyawarənə də banə oo'i: ‘Kə uugi əndzanə dzəgənə, kə lii nyi uura ŋga liinə. Taa mi patə, kə uugi tasəkanə. Shoomə əndzə'i ka zəmə əndzanə ŋga da məhura.’ ");
INSERT INTO gde_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","Amma, ma ənjitə baabii ci ka tii əndzanəkii, makamə tii nətii davə. Wata təya palə satii. Harakii, aasəkə rə pyalə tii, harakii, ka ɗa fiiriinatii. ");
INSERT INTO gde_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Hara ənjitə baabii ci ka tii əsə, təya kəəsətə tə lyawarənaakii, təya ciɓə də tii, təya ɓəələgi tə tii. ");
INSERT INTO gde_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Kə ɓəzəgi səkə ŋga ŋwaŋutə ka shaŋə. Wata ca sləkee ka soojiinaakii ka ɓəələginə tə maɓələ ənjita, təya ətsagi vəranatii. ");
INSERT INTO gde_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Wata ca 'waa'watə tə harii lyawarənaakii, ca ba ka tii: ‘Kə uugi əndzanə tasəkanə kamə, amma, ma ənjinə baabii nyi ka tii, mambu'umə tii bahə zəmə əndzanəkii. ");
INSERT INTO gde_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","Acii ha'ə, dəmə ka mətikətikənə ŋga rəgwanyinə, una ba ka taa wu patə lapaa unə oo'i, wa ca shi ka zəmə əndzanə.’ ");
INSERT INTO gde_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","Wata lyawariitə a dzə ka baabanə taa ka wu patə lapaa tii, bwaya əndə da ŋunyi əndə patə. Wata pasə, kə nagi yi əndzanə acii ənja. ");
INSERT INTO gde_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“Makə dzəgərə ŋwaŋwə ka tsaamə tə ənjitə 'wii ci, ma ca nee, wiinə əndə'i əndə agitii yadə kəjeerənə ŋga da məhura ashikii. ");
INSERT INTO gde_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","Ŋwaŋwə a ləgwa ka ci: ‘Guvakya, dama gima hə aa hanə aasii yadə kəjeerənə ŋga rəya ashikwa?’ Mashiimə əndətə sə ŋga jikəvənə ka ŋwaŋwa. ");
INSERT INTO gde_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Wata ŋwaŋwə a ba ka lyawarənaakii: ‘Anətəmə tə ci ciinəkii da səɗəkii patə, una kagərə tə ci aagi təkunə. Davə tuunə ənji, təya dzə də tsəɓə linyinətii.’ ” ");
INSERT INTO gde_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Yeesu a uudəpaa waɓənaakii, əŋki ci, “Laŋə nə ənjitə 'waa'wii ənji, amma gi'u nə mataɗəkii.” ");
INSERT INTO gde_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Wata *Farisanyinə a dzə ka ɗa mətərəkinə agyanə makə sətə nii təya mbee ka kəsənə tə Yeesu agi waɓənaakii. ");
INSERT INTO gde_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Wata təya sləkee ka ci ka hara lyawarənatii da hara ənjitə ŋga kurəgə ŋga *Hirudusə. Təya dzə ka banə ka ci, əŋki tii, “Maləma, kə shii inə oo'i, əndə gooŋga nə hə, agi dzəgunətənə nə hə rəgwa ŋga Əntaŋfə də tantanyinə əsə. Paa hə ka taɗəpaa taa ŋgutə tsarə ŋga ənda, acii paa hə ka tsaamənə ka ɗuunuunə ŋga ənda. ");
INSERT INTO gde_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","Ya əna, iitə nə hiimaakwa? Kə kapaa bariya gaamə kaamə rəgwa ŋga vii tsəkə ka ŋwaŋwə Kayisarə nii? Anii poosha?” ");
INSERT INTO gde_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Asee, kə shii Yeesu bwaya hiimatii. Wata əŋki ci, “Una! Də bəra'i asəkuunə cuuna kərə ka Əntaŋfə! Mi saŋə cuuna moo təkənə tə nya? ");
INSERT INTO gde_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Ɓaariimə ka nyi kwaɓa ŋga tsəkəkii.” Təya ŋgiragi ka ci. ");
INSERT INTO gde_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Wata ca ləgwa ka tii, əŋki ci, “Ya əna, kəŋwaciinə da ləmə ŋga wu ənə anə kwaɓana?” ");
INSERT INTO gde_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Təya ba, “Ma ətsa, kəŋwaciinə ŋga ŋwaŋwə Kayisarə.” Wata Yeesu a ba ka tii, “Yoo, makə ha'ə ɗiya, viimə ka Kayisarə sətə ndzaa ka naakii, una vii ka Əntaŋfə sətə ndzaa ka ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Makə fii tii waɓəətsə ŋga Yeesu, wata kə ɗagi ka tii ka sə ŋga hurəshishinə, təya bwasee ka ci, təya palə satii. ");
INSERT INTO gde_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Agi uusəratə rəŋwə ha'ə, *Sadukiinə a əntsahə aaɓii Yeesu. Ma təya, tii nə kurəgətə ca ba, pooshi maməətə ənji ka maɗənə da i əpinə shaŋə. Təya ləgwa ka ci, ");
INSERT INTO gde_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","əŋki tii, “Maləma, ma bii Muusa, maɗa kə əŋki əndə pooshi manjeevənaakii, see ndzəkəŋuci nə ŋgərə mooryafinə, kaa ca poo ka ndzəkəŋuci ətə əŋki. ");
INSERT INTO gde_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Yoo, tə'i ndzəkəŋushi'inə məɗəfə sha ɗii ganə. Gawatii a ŋgərə minə, ca əntə yadə manjeevənə, ca bwasee ka minə ka ndzəkəŋuci. ");
INSERT INTO gde_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Ha'ə slənyi də madzəgəbəra'inə da makkənə, ca'ə ka məɗəfənə. Pooshi əndə upaa uuzənə ashi miita. ");
INSERT INTO gde_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Daba'atii patə, kya əntəgi dəŋwa'ə. ");
INSERT INTO gde_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Ya ətsa, ya uusərə ŋga maɗənə ŋga maməətə ənja, makə watiitsə patənatii ŋgirə tə kya, minə ŋga wu saŋə ndzaanəta?” ");
INSERT INTO gde_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Yeesu a ba ka tii, əŋki ci, “Kə kulii unə patə, acii pooshi unə paaratəgi də malaaɓa ləkaləkatə, mashiimuunə ŋgeerənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Acii maɗa kə ma'i maməətə ənji, pooshi tii na ŋgərəshi. Amma, makə malaa'ikanyinə dadagyə nə təya ndzaanə. ");
INSERT INTO gde_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Yoo, ma agyanə maɗənə ŋga maməətə ənji əsə, majaŋgamuunə sətə bii Əntaŋfə koonə kuna? ");
INSERT INTO gde_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","Ma bii ca, ‘Nyi nə Əntaŋfə ətə ci Ibərahiima da Isiyaaku da Yakubu a paslə tə ci.’ Ma ca, ənjitə da i əpinə a matii ca paslə tə ci, əntaa ənjitə yadə əpinə amatii.” ");
INSERT INTO gde_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Makə fii daɓaala waɓəətsə ha'ə, kə ɗii ka tii ka sə ŋga hurəshishinə nə dzəgunənaakii. ");
INSERT INTO gde_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Makə fii Farisanyinə oo'i, kə pa'əgi Yeesu ma ŋga Sadukinyinə, wata təya shi ka ciinə rəŋwə. ");
INSERT INTO gde_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Əndə'i əndə agitii, maləmə ŋga bariya nə ci. Ca ləgwa uushi ama Yeesu, kaa ca shii kəsənə tə ci agi waɓənaakii, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Maləma, ŋgutə bariya saŋə palee də ɗuunuunə agi bariyanyina?” ");
INSERT INTO gde_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Yeesu a ba ka ci, “ ‘Uuɗuu tə Əntaŋfə Slandanəku də ədzəmə rəŋwə, də patənə ŋga əpinaaku, də patənə ŋga haŋkalaaku.’ ");
INSERT INTO gde_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ətsə nə maɗuunə bariya, palee patə də ɗuunuunə. ");
INSERT INTO gde_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Bəra'inəkii də ɗuunuunə əsə, makə ətsə nə ci: ‘Uuɗuu tə əndətə aɓiiku makə sətə cii kwa uuɗə naaku na.’ ");
INSERT INTO gde_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Bariyanyiitsə bəra'i nə kilə ŋga patənə ŋga bariyanyinə da dzəgunənə ŋga anabinyinə.” ");
INSERT INTO gde_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Ma Farisanyinə ma'ə ka ha rəŋwa, wata Yeesu a ləgwa ka tii uushi, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Wu saŋə shii unə nə Aləmasiihu? Uuzənə ŋga wu nə ca?” Əŋki tii: “Uuzənə ŋga *Dawuda nə ci.” ");
INSERT INTO gde_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Ca ba ka tii, “Ya əna, maa ha'a, iitə ɗii daa cakə Malaaɓa Ma'yanə tə Dawuda kaa ca 'wa tə ci də Slandanəkəya? Ma bii ca: ");
INSERT INTO gde_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","‘Əŋki Əntaŋfə Slandanə ka Slandanəki, ndzaanə gadəvə da ciizəmaki. Ka kavənə nə nyi tə ənji daawaanaaku aatsaa səɗəku.’ ");
INSERT INTO gde_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Aa makə kə 'wii Dawuda tə ci də Slandanə ətsa, iitiitə ɗii ndzaanə Aləmasiihu ka jijinaakəya?” ");
INSERT INTO gde_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Wata pooshi əndə mbee ka jikəvənə taa də ma rəŋwə. Ndzaŋənə ka uusərakii, pooshi əndə ənyi ka ləgwa waɓənə amakii ma'ə acii ŋgwalənə. ");
INSERT INTO gde_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Ma daba'əkii, wata Yeesu a waɓə ka daɓaala da i ka lyawarənaakii, ");
INSERT INTO gde_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","əŋki ci ka tii, “Ma maliminə da Farisanyinə, tii nə ənji da baawəɗa ŋga dzəgunətə bariya ŋga Muusa ka ənja. ");
INSERT INTO gde_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","Acii ha'ə, ma sətə ci təya ba koonə patə, tyasə see a dzəgunuunə, una nə'utə. Amma goona nə'u slənatii. Acii ka waazanə nə tii, amma paa tii ka slənətəginə. ");
INSERT INTO gde_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Agi ŋgərəvənə nə tii ka ənji mazəzəkə tərənə 'wa'ə. Amma, ma tii ka nətii, taa də mashiku ciinətii, paa tii ka təɓətənə. ");
INSERT INTO gde_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Patənə ŋga sətə ci təya ɗa, kaa ənjə a shii neenə. Tsaaməmə ka kəŋwaciinətii da basatii acii məsəpaliinə. Tsaaməmə ka yipənə ŋga kəjeerənyinatii. Ma ətsə patə, agi tsakənə nə tii ɗanə madiigərəkii ka ɓaariinə oo'i, ənji paslənə tə Əntaŋfə nə tii də tantanyinə. ");
INSERT INTO gde_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Ma agi zəmə əndzanə, hatə ci ənjə a ɗuunətə tə tii moonətii ndzaanə davə. Ka hatə da ginə davə moonətii ndzaanə asəkə kuvə də'wanyinə. ");
INSERT INTO gde_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Nəhəpaanə tə tii ŋga'ə a luuma moonətii əsə, ənjə a 'wa tə tii ‘Maləma’. ");
INSERT INTO gde_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Amma, ma una, goona luuvə ənjə a 'wa tuunə də Maləma. Acii rəŋwə dyaŋə nə Maləmə goonə. Unə patə, ndzəkəŋushi'inə ŋga noonə nə nuunə. ");
INSERT INTO gde_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Goona 'wa taa tə wu ganə a duuniya ‘daadə’, acii rəŋwə dyaŋə nə Dəsənuunə, waatoo ətə dagyə. ");
INSERT INTO gde_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Ga ənjə a 'wa tuunə ‘slandana’ əsə, acii rəŋwə dyaŋə nə Slandanuunə, waatoo, ci nə *Aləmasiihu. ");
INSERT INTO gde_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Ma əndətə palee də gawuunə ahadoonə, tyasə see a ndzaa ci ka əndə slənənə koonə. ");
INSERT INTO gde_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Taa wu patə haŋətə naakii na, ka bərapaanə nə ənji tə ci. Taa wu patə həətəpaa naakii nə əsə, ka haŋətənə nə ənji tə ci.” ");
INSERT INTO gde_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“Tə'i ŋgəra'wə ashuunə, maliminə da Farisanyinə! Acii ma unə, də bəra'i asəkuunə cuuna kərə ka Əntaŋfə. Kə pa'əgyuunə rəgwa ŋga dzənə aagi *ŋwaŋuunə ŋga Əntaŋfə agyanə ənja, unəkii əsə, pooshi unə ka dəmənə. Ma ənjitə ca moo dəmənə, pooshi unə agi kapaa ka tii rəgwa əsə.  ");
INSERT INTO gde_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","“Tə'i ŋgəra'wə ashuunə, maliminə da Farisanyinə! Acii ma unə, də bəra'i asəkuunə cuuna kərə ka Əntaŋfə. Agi luutənə nuunə uushi'inə ŋga mooryafinə, una ɗa ka tii magərə də'wa ka ənjə a shii dəlanə duunə. Acii ha'ə, maɗuunə dzalənə nuuna upaa. ");
INSERT INTO gde_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","Tə'i ŋgəra'wə ashuunə, maliminə da Farisanyinə! Acii agi gəŋutəginə nuunə də hanyinə da uunəvənyinə patə koona upaa də əndətə ca nə'u tuunə. Amma, maɗa kə upaa unə, una ɗeegi ka ci ka əndə ŋga gunə palee ka noonə na. ");
INSERT INTO gde_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“Tə'i ŋgəra'wə ashuunə, unə ənji kərə ənja! Muurəfinə nuunə. Agi dzəgunənə nuunə ka ənji oo'i: ‘Maɗa kə ji'i əndə də *yi ŋga Əntaŋfə, ma ətsa, pooshi taa mi. Amma, maɗa kə ji'i əndə də əndzənə ŋga yi ŋga Əntaŋfə, ka kəsənə nə jiɗəkii tə ci.’ ");
INSERT INTO gde_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Maɗiikə ənja, muurəfinə! Ŋgutə saŋə palee də məghərəvəna? Əndzənə nii, anii yi ŋga Əntaŋfə ətə geegi ka əndzənə malaaɓakəya? ");
INSERT INTO gde_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Agi dzəgunənə nuunə ka ənji oo'i: ‘Maɗa kə ji'i əndə də ha ŋga ɗa sataka, ma ətsa, pooshi taa mi. Amma, maɗa kə ji'i əndə də satakatə kavə ənji aagyanəkii, ka kəsənə nə jiɗəkii tə ci.’ ");
INSERT INTO gde_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Una! Muurəfinə nuunə! Ŋgutə saŋə palee də məghərəvəna? Sataka nii, anii hatə ci ənjə a ɗa sataka ətə ca geegi ka satakakii malaaɓakəya? ");
INSERT INTO gde_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","Acii ha'ə, taa wu patə ji'i də 'wa ləmə ŋga ha ŋga ɗa sataka, kə ji'i ci də taa mi patə davə ətsa. ");
INSERT INTO gde_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Ha'ə nə yi ŋga Əntaŋfə əsə. Taa wu patə ji'i də ci, kə ji'i əndəkii də ci da də Əntaŋfə ətə asəkəkii. ");
INSERT INTO gde_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Taa wu patə ji'i də 'wa ləmə ŋga dadagyə, kə ji'i ci də dəgələ ŋwaŋuunə ŋga Əntaŋfə da də ci ətə dasə asəkəkii. ");
INSERT INTO gde_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“Tə'i ŋgəra'wə ashuunə, unə maliminə da Farisanyinə! Acii ma unə, də bəra'i asəkuunə cuuna kərə ka Əntaŋfə. Agi viinə nuunə zaka ŋga ŋunyi banyinə kama kama, amma una bwasee ka nə'utə tə tantanyitə dzəgunənə ŋga *bariya, waatoo, slənə uushi də rəgwakii, da nəhə təgunuunə ŋga ənja, da gooŋgaanə. Wiitsə səndə dəɓee ɗanuunə, amma ga ca zaanə koonə əsə nə vii zaka. ");
INSERT INTO gde_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Unə ənji kərə ənja, muurəfinə nuunə! Wanuunə ka ɗəməgi kanshaginə agi sə ŋga sanə goonə, acii ga ca gi aasəkuunə. Amma una ndagərə ŋgyalooba. ");
INSERT INTO gde_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“Tə'i ŋgəra'wə ashuunə, unə maliminə da Farisanyinə! Acii ma unə, də bəra'i asəkuunə cuuna kərə ka Əntaŋfə. Agi ɓəəzəginə nuunə ba'ə ŋga kəra da ŋga kwalaka, amma, ma dasəkətii, pasə acii uushi'inə ŋga əmbanə da suunanyinə. ");
INSERT INTO gde_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Muurəfə ŋga Farisa! Ɓəəzəgi səkə ŋga kəra da kwalakə zəku'i. Maɗa kə ɗii hə ha'ə, ka ndzaanə nə ba'əkii camə əsə. ");
INSERT INTO gde_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“Tə'i ŋgəra'wə ashuunə, unə maliminə da Farisanyinə! Acii ma unə, də bəra'i asəkuunə cuuna kərə ka Əntaŋfə. Makə gu'u əndə nuunə. Ma da makii, dagwakii ŋga'ə. Amma, ma da səkəkii, pasə acii ilənyinə da maɓəslə wunyinə. ");
INSERT INTO gde_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ha'ə nuunə makə ətsa. Ma daba'ə unə, ŋga'ə nuunə akəŋwacii ənja. Amma, də bəra'i asəkuunə cuuna kərə ka Əntaŋfə, ma'waslyakə ənjə nuunə.” ");
INSERT INTO gde_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“Tə'i ŋgəra'wə ashuunə, unə maliminə da Farisanyinə! Acii ma unə, də bəra'i asəkuunə cuuna kərə ka Əntaŋfə. Agi ghənətənə nuunə nə ŋga gu'u ŋga anabinyinə ŋga'ə, una haɗatəgi ŋga'ə tə gu'unyinə ŋga ənjitə ndzaa yadə idəpaa uushi ashitii, ");
INSERT INTO gde_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","una ba: ‘Maci ma saa'i ŋga i dəsənaamə, da i amə saa'ikii, kaɗa əntaa da i amə ɓiilə anabinyinə.’ ");
INSERT INTO gde_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Ha'ə vii unə seeda agyanə noonə nə oo'i, manjeevənə ŋga ənjitə ɓəələgi tə anabinyinə nuunə. ");
INSERT INTO gde_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Makə ha'ə mwayi unə ɗəya, dəmə aakəŋwa də ɗaaɗa sətə nji dəsənuunə a ɗaaɗa! ");
INSERT INTO gde_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ya unə rəhunyinə, manjeevənə ŋga rəhunyinə, iitə taa mbeenuunə ka mbərəɗənə acii kanə tuunə aagi guna? ");
INSERT INTO gde_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","“Acii ha'ə, fatəmə: ka sləkeenə nə nyi koonə ka anabinyinə da macicirə ənja da hara maliminə. Ka ɓəələginə nuunə harakii agitii, una gwa'avə harakii aashi ənfwa, una fəslə harakii asəkə *kuvə də'wanyinə goonə, una laakəgi tə tii ka vəra ka vəra. ");
INSERT INTO gde_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Acii ha'ə, agyanuunə nə gəŋwanə ŋga ɓəələ tə ənji gooŋga patə, njaŋanə ka ɓələnə tə əndə gooŋga Habiila, ca'ə ka ɓələnə tə Zakariya uuzənə ŋga Barakiya. Ma ca, ahada maɗuunə kuvə ŋga Əntaŋfə da ha ŋga ɗa sataka ɓələgyuunə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Tantanyinə cii kya ba koonə: ətsə patə, ka kulaanənə nə dzalənəkii ka ənji ŋga zamanana.” ");
INSERT INTO gde_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","“'Ya'ə unə ənji Urusaliima, unə ənji Urusaliima, kə ɓəələgyuunə anabinyinə, kə kaalatuunə də faariinə tə ənjitə sləkee Əntaŋfə koonə! Taa guci patə nə nyi agi alə rəgwa ŋga dzatəginə duunə aaɓiiki, makə sətə ci gyaagya a dzatəgi də manjeevənatə aatsatə. Amma kə naanagyuunə furəshi. ");
INSERT INTO gde_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Aciikii, ka ndzaanə nə yi ŋga Əntaŋfə gbəŋə yadə əndə davə. ");
INSERT INTO gde_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Wanyinə ca ba koonə əsə, pooshi unə na nee ka nyi ma'ə shaŋə, ha'ə mbu'yanə uusəratə nuuna ba oo'i: ‘Tə'i barəkaanə ashi əndətə ca shi də ləmə ŋga Slandana!’ ” ");
INSERT INTO gde_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Ma daba'əkii, wata Yeesu a dəməgi asəkə yi ŋga Əntaŋfə. Ma ca palə, lyawarənaakii a dzə aaɓiikii ka ɓaarii ka ci makə sətə ghənyi ənji maɗuunə yikii. ");
INSERT INTO gde_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Amma Yeesu a ba ka tii, əŋki ci, “Kə nee unə ka uushi'iitsə patə nii? Tantanyinə cii kya ba koonə: taa rəŋwə, pooshi faara na mbəɗaanə ganə anə əndə'i, ka waalaginə nə ənji patə.” ");
INSERT INTO gde_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Kə gi Yeesu ka ndzaanə dasə anə giŋwə ŋga Zayitunə, wata lyawarənaakii a shi aaɓiikii, tii daanətii, təya ləgwa ka ci, əŋki tii, “Bawə keenə guci saŋə nə ətsə ha'ə a ɗa. Mi saŋə na slənə ka ɓaariinə oo'i, saa'i ŋga ənyanaaku da uudənə ŋga duuniya uugi mbu'yana?” ");
INSERT INTO gde_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Əŋki Yeesu ka tii, “Nəhəmə acii ga ənjə a gəpi duunə. ");
INSERT INTO gde_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Acii tə'i ənji laŋə na shi, təya ɗəkəvə ləməki ka natii na, taa wu ca ba, ci nə *Aləmasiihu, təya ŋuusləgi də hara ənji laŋə a rəgwa. ");
INSERT INTO gde_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Kadə nuuna fa habara ŋga paapanə taa dama patə. Amma goona buurə. Acii ma ətsa, weewee ka ɗanə ha'ə, amma əntaa ci nə muudinə ŋga duuniya. ");
INSERT INTO gde_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Kadə nə əndə'i slikərənə a dzə ka panə da əndə'i. Ŋwaŋuunə a pa da əndə'i ŋwaŋuunə. Kadə nə maɗəfənə a kula, gəgədzənə ŋga hanyinə a ɗaaɗa taa dama patə. ");
INSERT INTO gde_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Ma ətsə patə, makə 'watəginə ŋga ɓərakənə ətsa. ");
INSERT INTO gde_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“Ma ka saa'ikii, kadə nə ənjə a kəəsə tuunə, təya kavə tuunə aacii hara ənji kaa təya ciɓə duunə, ənjə a ɓəələgi tuunə. Ənji shiŋkinə patə, kadə nə təya ushapaa tuunə putə ŋga nə'unə goonə tə nyi. ");
INSERT INTO gde_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Laŋə nə ənjitə na təkuree ka sə'watənə ka saa'ikii. Kadə nə təya ŋusləgi, təya taŋəgi magəŋuura ŋga hara ənji, təya kaaree ka hara ənji. ");
INSERT INTO gde_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Laŋə nə majirakinə ŋga anabinyinə na shigi, təya ŋuusləgi də hara ənji laŋə. ");
INSERT INTO gde_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Putə ŋga tsakənə ŋga slənə bwaya bwayaanə, tə'i ənji laŋə ətə nə uuɗənə a əpigi a ədzəmətii. ");
INSERT INTO gde_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","Amma taa wu patə sə'watə ciɓənyinəkii ca'ə ka muudinə, ka upaanə nə ci luupaanə. ");
INSERT INTO gde_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Ma ŋunyi habara agyanə *ŋwaŋuunə ŋga Əntaŋfə əsə, ka waazanə nə ənji asəkə patənə ŋga duuniya, ka seedanə ka patənə ŋga ənji shiŋkinə. Ma daba'əkii, ka mbu'yanə nə muudinə ŋga duuniya ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“Ka neenə nuunə ka ma'ajijinə uushi ətə palee. Ci waɓi *anabi Daniyalə anəkii. Kadə na kəŋaanə anə malaaɓa ha. (Ma əndətə ca jaŋga, wa ca paaratəgi ŋga'ə.) ");
INSERT INTO gde_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Maɗa kə nee unə ha'ə, ma ənjitə ganə anə hanyinə ŋga Yahudiya, wa təya huyi ka umbənə aanə giŋunyinə. ");
INSERT INTO gde_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Ma əndətə dzakə anə kuvaakii, wa ca jimagərə, ca huyi, ga ca dzə dasii ka ŋgərəənə uushi. ");
INSERT INTO gde_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","Ma əndətə də bilə əsə, ga ca ənə aasii ka ŋgira kəjeerənaakii. ");
INSERT INTO gde_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Tə'i ŋgəra'wə agyanə maki ɗasəkiinə da ŋugiginə ka saa'ikii. ");
INSERT INTO gde_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Kədiimə acii Əntaŋfə, acii ga huyinəkii a ɗii agi vyanə taa uusəra əpisəka. ");
INSERT INTO gde_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Acii ma ciɓətə na kula ka saa'ikii, ci na palee patə də bwaya bwayaanə, pooshi tsarəkii sha ɗii shaŋə makə tagii Əntaŋfə duuniya ca'ə ka əndzə'i. Pooshi tsarəkii na ɗa shaŋə ma'ə əsə. ");
INSERT INTO gde_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Maci pooshi ətə galee Əntaŋfə ka saa'ikii, kaɗa pooshi əndə shiŋkinə ca mbəɗə. Amma, acii putə ŋga mataɗə ənjaakii, ka galeenə nə ci ka saa'ikii. ");
INSERT INTO gde_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“Maa kə bii əndə koonə: ‘Waanə Aləmasiihu ganə’ taa ‘Waatə Aləmasiihu gatə’, goona luuvə. ");
INSERT INTO gde_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Acii kadə nə aləmasiihunyinə da anabinyinə ŋga jirakənə a shigi, təya ɗaaɗa sə ŋga hurəshishinə ka shaŋə, kaa təya shii ŋuusləgi də ənja. Maci ka mbeenə nə tii maa, da i mataɗə ənji ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Buurətəmə ŋga'ə! Acii kə bagi nyi koonə daga saa'ikii ma'ə mambu'yamə. ");
INSERT INTO gde_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Acii ha'ə, maɗa kə bii ənji koonə oo'i: ‘Waatə də bilə!’ goona dzə aa dəvə. Taa maɗa bii ənji koonə oo'i: ‘Waanə a kumu’, goona luuvə. ");
INSERT INTO gde_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Acii ma shinə ŋga *Uuzənə ŋga ənda, paŋgəraŋə a babara makə sətə ci vənə a pyapiɗə, ca ɓərəgi səkəntaŋfə taa dama patə, ndzaŋənə da tsaaŋwə ca'ə aa də waka, ha'ə nii kəya shi. ");
INSERT INTO gde_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Ka hatə ɗii mantə uushi patə, davə dzanə kadəguyinə də na.” ");
INSERT INTO gde_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“Ma pii daba'ə ciɓənyiitsa, ka əndəginə nə uusəra, pooshi ləgiɗə ka ɓərənə, tikisanyinə a kwaalya dagyə, ka gaŋgəzənə nə taa mi patə asəkəntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Ka saa'ikii nə ənjə a nee agintaŋfə ka sətə ca ɓaarii oo'i, Uuzənə ŋga əndə ca shi. Ənji *duuniya patə a tuu, təya tsaamə tə Uuzənə ŋga əndə ca jima agyanə kuraɓiinə dadagyə, də baawəɗa da məghərəvənə laŋə, ");
INSERT INTO gde_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ca sləkee ka malaa'ikanyinaakii, təya ədə uutəma ətə ca wazə də ŋgeerənə, təya dzaadzatə də patənə ŋga mataɗə ənjaakii, ndzaŋənə ka əndə'i taŋgala ŋga duuniya ka ca'ə ka əndə'i.” ");
INSERT INTO gde_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“Wa ənfwə uudəvə a ka koonə hiima. Maɗa kə nee unə wiitsə kə 'watəgi ənənə, yoo, kə shii unə ətsə, kədəhə nə mətsətsəfə ka ɗanə. ");
INSERT INTO gde_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ha'ə əsə, maɗa kə nee unə uushi'iitsə patə a ɗaaɗa, ka shiinə nuunə ətsə, kədəhə nə Uuzənə ŋga ənda, matasəkakii kaa ca shi. ");
INSERT INTO gde_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Tantanyinə cii kya ba koonə: ma ənji ŋga zamanana, pooshi tii ka məətəginə patə, uushi'iitsə ma'ə maɗaaɗamə patə. ");
INSERT INTO gde_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Ka uudəginə nə ha a dagyə da ha a panə, amma, ma waɓənaaki, pooshi ka uudənə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“Ma uusəra taa saa'i ŋga ɗanə ŋga uushi'iitsa, pooshi əndə shii. Malaa'ikanyinə ŋga dadagyə maa, pooshi tii shii. Ha'ə nə Uuzənə əsə, paa ci shii, see Dii ci daanəkii. ");
INSERT INTO gde_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Makə sətə sha ɗii tə ənji agi zamana ŋga Nuuhu, ha'ə na ɗa saa'i ŋga ənyanə ŋga Uuzənə ŋga ənda. ");
INSERT INTO gde_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Ma agi zamana ŋga Nuuhu taabu'u shi ma'i tuufaanə, kə nji ənjə a zəmə, ənjə a saasa, kə nji ŋguyirənə da makinə a ŋgəərəshi, ha'ə mbu'ya uusəratə dəməgərə Nuuhu aasəkə kumbawala. ");
INSERT INTO gde_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Pooshi ənji puləgi, ha'ə shi ma'i tuufaanə, ca zamagi də tii patə. Ha'ə na ɗa əsə saa'itə nə Uuzənə ŋga əndə a shi. ");
INSERT INTO gde_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","“Ma ka saa'ikii, ka dzənə nə ənji bəra'i aasəkə rə ka sləna. Ka ŋgərəginə nə ənji əndə'i əndə, ənjə a bwasee ka əndə'i əndə. ");
INSERT INTO gde_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ka dzənə nə makinə bəra'i ka ədənə ka təŋwə rəŋwə. Ka ŋgərəginə nə ənji əndə'i minə, ənjə a bwasee ka əndə'i. ");
INSERT INTO gde_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Acii ha'ə, kantsaamə ginə, makə ɗii ci mashiimuunə taa ŋgutə uusəra nə Slandanuunə a shi. ");
INSERT INTO gde_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Shiimə oo'i, maci ka shiinə nə slanda yi saa'itə ci mahərə a dzə ka ci aasii davəɗə, kaɗa ka ba'əginə nə ci də məgigi, acii ga ca gi ka ci aasii. ");
INSERT INTO gde_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Acii ha'ə, ma unə əsa, see a ndzaa unə matasəkakii ka gəra shinə ŋga Uuzənə ŋga ənda, acii ka shinə nə ci ka uusəratə makamuunə nə ŋga shinaakii.” ");
INSERT INTO gde_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“Ma əndə gooŋga ŋga mava, əndə haŋkala, tə ci kapaanə slandanəkii ka nəhə yaakii, kaa ca vii zəmə ka hara ənji slənə ka saa'itə diɓə. ");
INSERT INTO gde_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Maɗa shi slandanəkii ka lapaanə tə ci agi slənə sətə bii ci ka ci, tə'i barəkaanə ashikii. ");
INSERT INTO gde_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Tantanyinə cii kya ba koonə: ma mavata, ka ba'avənə nə slandanəkii patənə ŋga uushi'inaakii aaciikii. ");
INSERT INTO gde_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amma mbu'u ka banə nə bwaya mava də səkəkii oo'i: ‘Pooshi slandanəki ka shinə kədəhə.’ ");
INSERT INTO gde_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","Wata ca ndzaŋə fəslənə tə hara maviinə makə ci, ca zəmə, ca saasa ənvwə tii da ənji sa ənvwa. ");
INSERT INTO gde_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","Amma ka shinə nə slandanəkii uusəratə makamə ci nə ŋga mbu'yanaakii, saa'itə mashiimə ci əsə. ");
INSERT INTO gde_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Ka dzalənə nə slandanəkii tə ci də ŋgwaaŋgwa'ənə, ca vii ka ci shikwa mbərə mbərə da ŋga ənjitə ca kərə ka Əntaŋfə də bəra'i asəkətii. Davə tuunə ənji, təya tsəɓə linyinətii.” ");
INSERT INTO gde_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“Ma ka saa'ita, ka ndzaanə nə ŋwaŋuunə ŋga dagyə makə sətə sha ɗii tə uuji kadəmiinə pu'u. Ma təya, kə fə'i tii garəkuwanyinatii, təya dzə aa ha dagwa maɗanə ka gəŋunə də ci. ");
INSERT INTO gde_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Tufə agitii, maɗiikəkii nə tii. Tufə əsə, macicirəkii nə tii. ");
INSERT INTO gde_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ma maɗiikəkiinyiita, kə ŋgərəənə tii garəkuwanyinatii yadə əgəənə hara maara. ");
INSERT INTO gde_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Amma, ma macicirəkiinyiita, kə ŋgərəənə tii maarənyinatii. ");
INSERT INTO gde_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Makə səkəpaa dagwa maɗanə na, kə zhikuki tii patə, təya kwaalagi aa ŋunyi. ");
INSERT INTO gde_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“Ma ətsə ahada vəɗa, ənjə a wazha də banə: ‘Waanə dagwa maɗanə! Shigimə ka luuginə tə ci!’ ");
INSERT INTO gde_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Wata uuji kadəmiitə a maɗə patə ka haɗatəgi də garəkuwanyinatii. ");
INSERT INTO gde_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Wata maɗiikə uuji kadəmiitə tufə a ba ka macicirəkiita: ‘Ndiimə keenə maarə gi'u. Wiinə gunə ka məətəginə asəkə garəkuwanyinə geenə.’ ");
INSERT INTO gde_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Amma macicirə uuji kadəmiitə a ba ka tii, əŋki tii: ‘Yaci pooshi na mbu'u kaamə pata? Ma ɗanuunə, dəmə ka iracii noonə aa luuma.’ ");
INSERT INTO gde_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Wata kə pyalə maɗiikə kadəmiitə ka iracii maarəkii. Ma təya palə ha'ə, wata dagwa maɗanə a mbu'ya. Ma uuji kadəmiitə matasəkakii, kə dəməgərə tii atsaa dagwa maɗanə ka zəmə əndzanə ŋga rəya. Ənjə a pa'əgi makuva. ");
INSERT INTO gde_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Ma daba'əkii, harakiitə tufə a jiga, təya dza makuva, təya ba: ‘Slandana, Slandana! Wunəgi keenə makuva!’ ");
INSERT INTO gde_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Amma dagwa maɗanə a ba ka tii, əŋki ci: ‘Tantanyinə cii kya ba koonə: mashiimə nyi tuunə.’ ” ");
INSERT INTO gde_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Wata Yeesu a uudəpaa waɓənaakii, əŋki ci, “Nəhəmə, acii mashiimuunə uusəra taa saa'i.” ");
INSERT INTO gde_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“Ma ŋwaŋuunə ŋga dagyə əsə, ka ndzaanə nə ci makə sətə sha ɗii tə əndə'i əndə da lyawarənaakii makkə. Ma ca maɗə kaa ca palə oogə, ca 'waa'watə lyawariitaakii, ca ba'avə uushi'inaakii aaciitii. ");
INSERT INTO gde_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Ca təəkəpaa ka tii mbərə mbərə da ŋgeerənatii. Waatoo, ca vii ka əndə'i pamə tufə. Əndə'i əsə, ca vii ka ci pamə bəra'i. Əndə'i əsə, ca vii ka ci pamə rəŋwə. Ma daba'əkii, ca maɗə, ca palə oogə. ");
INSERT INTO gde_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Ma əndətə ba'avə ənji ka ci pamə tufə, masəkəpaamə ci na. Pii ca dzə ka ɗa də fiiriinə, ca upaa riiba ŋga pamə tufə aagyanə əta. ");
INSERT INTO gde_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Ha'ə ɗii əndətə ba'avə ənji ka ci pamə bəra'i əsə. Ca upaa riiba ŋga pamə bəra'i aagyanə əta. ");
INSERT INTO gde_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amma, ma əndətə ba'avə ənji ka ci pamə rəŋwə, ca dzə, ca tələgi gu'u, ca umbee ka kwaɓa ŋga slandanəkii davə. ");
INSERT INTO gde_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“Ma daba'ə baanə laŋə, wata slandanətii a ənya aasii. Ca ləgwa amatii taa mi ɗii tii ka ci də gənaakii. ");
INSERT INTO gde_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Wata əndətə ba'avə ənji ka ci pamə tufə a shi aakəŋwacii slandanəkii, ca vii ka ci hara pamə tufə, əŋki ci: ‘Slandanəkya, kə vii hə ka nyi pamə tufə, nya dzə ka ɗa fiiriinə də ci. Wiinə riiba tufə ətə upaa nyi aagyanəkii.’ ");
INSERT INTO gde_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Əŋki slandanəkii ka ci: ‘Ŋga'ə ɗii, kə kuyirii nyi tə hə. Ŋunyi əndə slənə nə hə, əndə gooŋga. Kə ɗii hə gooŋgaanə agi ɗa fiiriinə də magi'u kwaɓa. Acii ha'ə, ka ba'avənə nə nyi malaŋəkii aaciiku. Shiwa aa hanə aaɓiiki ka ɗa mooɗasəkə da nyi.’ ");
INSERT INTO gde_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Ma əndətə ba'avə ənji ka ci pamə bəra'i, kə shi ci, ca ba ka slandanəkii: ‘Slandanəkya, kə vii hə ka nyi pamə bəra'i. Wiinə riiba bəra'i ətə upaa nyi aagyanəkii.’ ");
INSERT INTO gde_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Əŋki slandanəkii ka ci: ‘Ŋga'ə ɗii, kə kuyirii nyi tə hə. Ŋunyi əndə slənə nə hə, əndə gooŋga. Kə ɗii hə gooŋgaanə agi ɗa fiiriinə də magi'u kwaɓa. Acii ha'ə, ka ba'avənə nə nyi malaŋəkii aaciiku. Shiwa aa hanə aaɓiiki ka ɗa mooɗasəkə da nyi.’ ");
INSERT INTO gde_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Ma əndətə ba'avə ənji ka ci pamə rəŋwə, kə shi ci əsə, əŋki ci ka slandanəkii: ‘Slandanəkya, kə shii nyi, ma ha, maŋgwa'ə ŋgwa'ə əndə nə hə. Ma moonəku, see a upaa hə cifanə ka hatə maləgamə hə davə, ha dzatəgi ka hatə mabu'umə hə davə. ");
INSERT INTO gde_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Acii ha'ə, kə ŋgwaləgi nyi, nya dzə ka umbee ka kwaɓaaku a gu'u. Wiinə kwaɓaaku.’ ");
INSERT INTO gde_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Wata slandanəkii a ba ka ci, əŋki ci: ‘Bwaya əndə slənə nə hə, manyaɗa! Kə shii hə oo'i, ka upaanə nə nyi cifanə ka hatə maləgamə nyi davə, nya dzatəgi ka hatə mabu'umə nyi davə. ");
INSERT INTO gde_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Maɗa ha'ə ɗii, paa hə ɗii ŋga'ə. Maci taa ma ɗii hə, ha dzə ka shigaginə ka hatə ci ənjə a zhi'igyə də gəna, kaɗa kə shi nyi ka luunə saaki da i riibakii.’ ");
INSERT INTO gde_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Slandanəkii a ba ka hara ənji slənaakii: ‘Luugimə pamətsə rəŋwə aciikii, una vii ka əndətə da pamə pu'u aciikii. ");
INSERT INTO gde_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Acii, ma əndətə da i uushi aciikii, ka ci tsakənə ənji viinə, kaa ca shii ɗanə laŋə aciikii. Amma, ma əndətə ɗii naakii gi'u, taa gi'ukii maa, ka luuginə nə ənji aciikii. ");
INSERT INTO gde_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Ma mazaɓə əndə slənətsa, ŋgərəmə tə ci, una kagərə tə ci aagi təkunə. Davə tuunə ənji, təya tsəɓə linyinətii.’ ” ");
INSERT INTO gde_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“Maɗa kə shi Uuzənə ŋga əndə da malaa'ikanyinaakii patə agi məghərəvənə ŋga ŋwaŋuunaakii, ka ndzaanə nə ci dasə agyanə dəgələ ŋwaŋuunaakii. ");
INSERT INTO gde_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Ənjə a dzatəgi tə patənə ŋga ənji a duuniya aakəŋwaciikii. Ca təkee ka tii kurəgə bəra'i, makə sətə ci magəra a ŋgwaɗəgi bagiinə agi uuhinə. ");
INSERT INTO gde_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Ca kapaa tə ənji gooŋga da ciizəmakii. Ma ənji 'waslyakəənə əsə, ca kapaa tə tii da madzənakii. ");
INSERT INTO gde_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Wata ŋwaŋwə a ba ka ənjitə da ciizəmakii, ‘Shooma, unə ənə ɗaanə Daadə koonə barəkaanə. Shoomə koona luu barəkaanə ŋga ŋwaŋuunə ətə ɗəkəpaa ci koonə daga 'watəginə ŋga duuniya. ");
INSERT INTO gde_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Acii kə shi maɗəfənə a ɗii tə nyi, kə ndii unə ka nyi zəma. Kə ɗii meegiirənə tə nyi, una ndii ka nyi ma'inə. Kə ɗii nyi mu'umuunə, una luu tə nyi aa hoonə aasii. ");
INSERT INTO gde_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Kə ɗii purəkinə tə nyi, una ndii ka nyi sə ŋga umbee də purəkinə. Kə gwakə nyi ka bwanea, una dzə ka nəhəpaanə tə nyi. A furəshina nji nyi, una dzə ka nəhəpaanə tə nyi.’ ");
INSERT INTO gde_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Wata ənji gooŋga a ləgwa ka ci, ‘Slandana, guci shiina nee ka hə ka maɗəfənə, ina vii ka hə zəma? Guci nee inə ka hə ka meegiirənə, ina vii ka hə ma'ina? ");
INSERT INTO gde_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Guci əsə nee inə ka hə mu'umə, ina luu tə hə aa heenə aasiya, taa hə də purəki, ina vii ka hə sə ŋga umbee də purəkina? ");
INSERT INTO gde_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Guci əsə nee inə ka hə gwakə taa a furəshinə, ina dzə ka nəhəpaanə tə ha?’ ");
INSERT INTO gde_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ŋwaŋwə a ba ka tii, ‘Tantanyinə cii kya ba koonə: taɗa guci patə ɗii unə ha'ə ka rəŋwə agi ənjitə pooshi da məghərəvənə akəŋwacii ənja, amma ndzəkəŋushi'inəki nə tii, ka nyi ɗii unə ətsa.’ ");
INSERT INTO gde_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“Ma daba'əkii, ca ba ka ənjitə da madzənakii əsə: ‘Dzəgimə aɓiiki, manaalya ənja, dəmə aagi gunə ətə ɗatə ənji ka *Seetanə da malaa'ikanyinaakii. ");
INSERT INTO gde_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Acii kə kəshi maɗəfənə tə nyi, amma pooshi unə ndii ka nyi zəma. Kə kəshi meegiirənə tə nyi, amma pooshi unə ndii ka nyi ma'inə. ");
INSERT INTO gde_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Kə ɗii nyi mu'umuunə, amma kə kaaree unə ka luunə tə nyi aa hoonə aasii. Kə ɗii purəkinə tə nyi, amma kə təkuree unə ka ndii ka nyi sə ŋga umbee də purəkinə. Gwakə nji nyi da a furəshina, amma kə təkuree unə ka dzənə ka nəhəpaanə tə nyi.’ ");
INSERT INTO gde_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Amma təya ləgwa ka ci, əŋki tii: ‘Slandana, guci saŋə nee inə ka hə də maɗəfənə taa meegiirənə kə kəshi tə hə, taa hə mu'uma, taa hə də purəkya, taa hə gwaka, taa a furəshina, amma kə təkuree inə ka tsakənə tə ha?’ ");
INSERT INTO gde_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Wata ŋwaŋwə a ənəgi ka tii, əŋki ci: ‘Tantanyinə cii kya ba koonə: ma sətə pooshi unə ɗii ka ənjitə pooshi da məghərəvənə akəŋwacii ənja, ka nyi təkuree unə ka ɗanə ətsa.’ ");
INSERT INTO gde_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Ma ənjita, ka kərənə nə ənji tə tii aagi dzalənə ŋga ca'ə ndəŋwə ndəŋwə. Amma, ma ənji gooŋga, ka kərənə nə ənji tə tii ka əpinə ŋga ha'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Makə uudəpaa Yeesu dzəgunə ka ənji patənə ŋga uushi'iitsa, əŋki ci ka lyawarənaakii: ");
INSERT INTO gde_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Kə shii unə, ma cifədoorə, uusəra ŋga *Pasəka. Ma nyi, Uuzənə ŋga ənda, ka viinə nə ənji tə nyi ka gwa'avə aashi ənfwa.” ");
INSERT INTO gde_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Ma ka saa'ikii, kə dzii madiigərə limanyinə da gayinə də nə asii ga gawə ŋga limanyinə patə, waatoo, asii ga Kayafasə. ");
INSERT INTO gde_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Təya anə uura ŋga kəsətənə tə Yeesu yadə shiinə ŋga ənja, ənjə a ɓələgi tə ci. ");
INSERT INTO gde_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Amma təya ba, “Gaama kəsə tə ci agi kumənə, acii ga ənjə a maɗee ka panə.” ");
INSERT INTO gde_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Ma saa'itə Yeesu də Bayitaniya asii ga Simoonə ətə shi uyi kuzənə a kəshi tə ci, ");
INSERT INTO gde_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ma ca adə zəma, wata əndə'i minə a dzə aaɓiikii da i əbwə urədya aciitə. Ma urədita, ŋga mandalə kwaɓa. Wata kya dzə, kya əjivə aanə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Amma, makə nee lyawarənaakii ha'ə, kə zhimagi tə tii asəkətii, əŋki tii, “Ka mi saawee ki ətsa? ");
INSERT INTO gde_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Maci ɗərəmaginə ɗərəmagi ənji də urəditsa, kaɗa kwaɓa laŋə nji ənjə a upaa anəkii, ənjə a təəkəpaa kwaɓakii ka maaghiinə.” ");
INSERT INTO gde_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Asee, kə shii Yeesu sətə ci təya ba, wata əŋki ci ka tii, “Ka mi cuuna kavə tə miitsə ka buurə uushi'inə kwa? Acii ma sətsə ɗii ki ka nyi, ŋunyikii ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Ma maaghiinə, ka hakii nuunə taa guci patə. Amma, ma nyi, paa nyi na ndzaanə aɓii unə. ");
INSERT INTO gde_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Ma əjivə ki urəditsə aashiki ku'u, kə ɗii ki ha'ə ka tasəkatə shishinəki ka ŋgəɗənə. ");
INSERT INTO gde_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Tantanyinə cii kya ba koonə: taɗa da nə ənjə a waaza Ŋunyi Habaranə asəkə duuniya patə, ma sətsə ɗii ki, ka waɓənə nə ənji anəkii ka buurətənə də ki davə.” ");
INSERT INTO gde_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Ma daba'əkii, rəŋwə agi *lyawarənə ŋga Yeesu pu'u aji bəra'i, ətə ɗii ləməkii Yahuda Isəkariyoota, a maɗə, ca palə aaɓii madiigərə limanyinə, ");
INSERT INTO gde_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","ca ba ka tii, “Maɗa vii nyi koonə tə Yeesu, iitə saŋə viinuunə ka nya?” Wata təya ɓaanagi kwaɓa tibisə makkə pu'unə, təya vii ka ci. ");
INSERT INTO gde_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Daga saa'ikii 'watəgi Yahuda tsaamə ŋunyi saa'i ŋga viinə tə Yeesu ka tii. ");
INSERT INTO gde_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Ma ka təkəŋwanə ŋga uusəra ŋga *kumənə ŋga adə buroodi yadə burəŋanə, kə shi lyawarənə ŋga Yeesu aaɓiikii, əŋki tii, “Da daa moonəku ina dzə ka dzəgə ka hə əndzanə ŋga Pasəka?” ");
INSERT INTO gde_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Əŋki ci ka tii, “Dəmə aasəkə vəranə aa ha zana, una ba ka ci: ‘Ma bii Maləmə tuu, kə uugi saa'yaaki ɗanə kədəhə. Ma nyi da lyawarənaaki, gaku asii niina zəmə əndzanə ŋga Pasəka.’ ” ");
INSERT INTO gde_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Wata lyawarənə ŋga Yeesu a ɗatə makə sətə bii ci ka tii ɗanə, təya dzəgə əndzanə ŋga Pasəka davə. ");
INSERT INTO gde_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Makə ɗii kədəwanə, wata Yeesu da lyawarənaakii pu'u aji bəra'i a ndzaanə ka zəma. ");
INSERT INTO gde_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ma təya dzə də zəmənə, kə bii ci ka tii, “Tantanyinə cii kya ba koonə: kadə nə rəŋwə ahadoonə a vii tə nyi aacii ənja.” ");
INSERT INTO gde_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Makə fii tii ha'ə, kə ɓəzəgi səkətii ka shaŋə. Wata taɗa wu patə ahadatii, ca ləgwa amakii, əŋki tii, “Slandana, nyi kwa?” ");
INSERT INTO gde_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Əŋki ci ka tii, “Əndənə caama adə ka ha rəŋwə na vii tə nyi ka ənja. ");
INSERT INTO gde_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Ma nyi *Uuzənə ŋga ənda, ka əntənə nə nyi tə əntənə, makə sətə nyaahə ənji agyanəki, amma kə ɗii anə əndətə na vii tə nyi ka ənja. Ma əndəta, maci mapoomə ənji tə ci, biɗə ci ka ci.” ");
INSERT INTO gde_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Wata Yahuda ətə vii tə ci a ləgwa, əŋki ci, “Maləma, nyi kwa?” Wata Yeesu a ba ka ci, “Hə bagi ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ma tii agi adə zəma, Yeesu a ŋgərə buroodi, ca kuyirii tə Əntaŋfə, ca ɓaatsəpaa, ca vii ka lyawarənaakii, əŋki ci ka tii, “Ndamə, una zəmə. Ma ətsa, shishinəki.” ");
INSERT INTO gde_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Ca ŋgərə kwalaka da ma'i inaba asəkəkii, ca ənə, ca kuyirii tə Əntaŋfə, ca vii ka tii, ca ba, “Saasaciimə, patənə goonə. ");
INSERT INTO gde_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Ma ətsa, idənaaki. Ci ca mbu'utəgi də aləkawalə ŋga Əntaŋfə. Idənəkii na əjigi ka putə ŋga ənji laŋə ka tifyagi də 'waslyakəənyinə. ");
INSERT INTO gde_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Wanyinə ca ba koonə: ma daba'ə əna, paa nyi ka ənənə ka sa ma'i inaba ma'ə, see uusəratə nii kya sa kurakii doonə agi ŋwaŋuunə ŋga Daadə.” ");
INSERT INTO gde_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Ma daba'əkii, təya ka wanyanə, təya maɗə, təya palə aashi giŋwə ŋga Zayitunə. ");
INSERT INTO gde_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Əŋki ci ka lyawarənaakii, “Unə patə, kadə nuunə a huyi ənshinə davəɗə, una bwasee ka nyi. Ka ɗanə makə sətə waɓi Əntaŋfə asəkə malaaɓa ləkaləkatə oo'i: ‘Ka ɓələginə nə nyi tə magəra, bagiinə a təəkəgi patə əsə.’ ” ");
INSERT INTO gde_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Wata ca tsakə banə, əŋki ci, “Amma, maɗa kə maɗee ənji ka nyi agi maməətə ənja, ka tanə nə nyi koonə kəŋwanə ka dzənə aanə hanyinə ŋga Galili.” ");
INSERT INTO gde_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Piita a jikəvə ka ci, əŋki ci, “Taa kə huyi hara ənji patə aciiku, ma nyi kamə, paa nyi ka bwaseenə ka hə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Əŋki Yeesu ka Piita, “Tantanyinə cii kya ba ka hə: ma taabu'u wanə gyaagya ənshinə davəɗə, ka jikənə nə hə makkə ka hiweenə ka shiinə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Piita a ba ka ci, “Taa əntənə cii kwa əntə, aŋwə da hə nə əntənə. Paa nyi ka hiweenə ka shiinə tə hə.” Ha'ə makə ətsə əsə bii hara lyawarənaakii patə. ");
INSERT INTO gde_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ma daba'əkii ha'ə, wata Yeesu a dzə da lyawarənaakii ka əndə'i ha ətə ci ənjə a 'wa Gyatsimani. Mbu'unatii aadəvə, ca ba ka tii, “Ndzaamə gadəvə, kaa nya əntsahə aakəŋwa ka ɗa də'wa.” ");
INSERT INTO gde_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Ca 'waanə tə Piita da manjeevənə ŋga Zabadiya bəra'i. Ma təya dzə, wata ca ndzaŋə buurə uushi'inə ka shaŋə, səkəkii a ɓəzəgi kuzhiɗə kuzhiɗə. ");
INSERT INTO gde_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Əŋki ci ka tii, “Maɓəzəkii nə səkəki makə a əntəgi nyi. Ənəgimə ganə, una ndzaa də məgigi atsaki.” ");
INSERT INTO gde_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Ca əntsahə aakəŋwa gi'u, ca kulapaa aanə səkəkii, ca ɗa də'wa, “Daadə, maɗa ka moonə nə hə, əntsahee ka nyi ka ciɓətsə akəŋwaciiki. Amma, ɗawə sətə kaɗeesəkə ka hə, ga ha ɗa sətə kaɗeesəkə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Ca ənya aaɓii lyawariitə makkə. Ma shi ci, ka ŋunyinə nə tii patə. Wata əŋki ci ka Piita, “Iitiitə daa təkuree unə ka ndzaanə də məgigi atsaki taa ŋga tibisə rəŋwə dyaŋa? ");
INSERT INTO gde_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Ndzaamə də məgigi, una ɗa də'wa, acii goona bwasee ka rəgwa ŋga Əntaŋfə saa'itə nə *Seetanə a təɓə tuunə. Ma asəkə ədzəmuunə, ŋga'ə koonə nə ɗa gazhi'waanə, amma mazaarəkii nə shishinə.” ");
INSERT INTO gde_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Yeesu a ənə ka əntsahənə ŋga bəra'inə əsə ka ɗa də'wa, əŋki ci: “Daada, maɗa pooshi rəgwa ŋga əntsaheenə ka ciɓənə anəki, yoo, sətə mwayi hə patə, wa ca ɗa.” ");
INSERT INTO gde_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Ca ənya aaɓii lyawariita. Ma ənya ci əsə, ka ŋunyinə nə tii, acii kə uugi ŋunyinə ɗanə laŋə agitii. ");
INSERT INTO gde_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Yeesu a bwasee ka tii, ca əntsahə, ca ənə ŋga makkənə ka ɗa də'wa makə əta. ");
INSERT INTO gde_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Ma daba'əkii, ca ənya aaɓii lyawariita, ca ba ka tii, “Ma'ə unə a ŋunyi kuna, una əpi səka? Yoo, wiinə, kə uugi saa'i ɗanə ka ənjə a vii tə Uuzənə ŋga əndə aacii ma'waslyakə ənja. ");
INSERT INTO gde_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Tsaaməmə! Waatsə əndətə ca vəgi tə nyi. Maɗətəmə kaamə dzə.” ");
INSERT INTO gde_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Yeesu ma'ə ma'uudəpaamə waɓənə ha'ə, wata kə mbu'ya Yahuda, waatoo əndətə agi lyawarənaakii pu'u aji bəra'i. Kə shi ci dzuɓə da ənji daba'əkii, da i ŋgila purəŋanyinə da i zaliinə aciitii. Madiigərə limanyinə da gayinə sləkee ka tii. ");
INSERT INTO gde_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Asee, ma Yahuda, ətə vii tə Yeesu aacii ənja, kə bii ci ka tii makə sətə nii kəya ɗatə ka ɓaarii də ci ka tii oo'i, “Ma əndətə nii kya nəhəpaa ŋga'ə, ci nə əndəkii, kəsəmə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Pii wata ca əntsahətə aaɓii Yeesu, əŋki ci ka ci, “Usa Maləma”, ca nəhəpaa tə ci ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Yeesu a jikə ka ci, əŋki ci, “Guvakya, ɗawə sətə kira tə hə.” Wata təya əntsahə, təya kəsə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Wata rəŋwə agi ənji ŋga Yeesu a əlyagi ŋgila purəŋanaakii, ca patsəgi liminə ŋga mava ŋga gawə ŋga limanyinə. ");
INSERT INTO gde_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Wata Yeesu a ba ka ci, “Ənəgərə də ŋgila purəŋanaaku. Taa wu pii də ŋgila purəŋanə, də ci ɓələnə ənji tə ci naakii. ");
INSERT INTO gde_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Mashiimə hə oo'i, ka mbeenə nə nyi ka kədii tsakənə tə nyi acii Daadə, pii pii ca sləkee ka nyi kurəgənyinə ŋga malaa'ikanyinə palee ka pu'u aji bəra'i kwa? ");
INSERT INTO gde_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amma, maɗa kaa nya kədii tsakənə acii Daadə əna, guci ɗii nə sətə bii malaaɓa ləkaləkatə a ndzaa ka tantanyinə, ətə bii ci, tyasə ka slənənə ha'a?” ");
INSERT INTO gde_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Ma ka saa'ita, kə waɓi Yeesu ka ənjitə shi ka kəsənə tə ci, əŋki ci ka tii, “Mi shuunə ka kəsənə tə nyi ka ŋgila purəŋanə ka ŋgila purəŋanə, ka zala ka zala kwa? Ya saŋə əndə ɗa maabə nə nyi kwa? Uusəra patə nji nya ndzaanə dasə asəkə *yi ŋga Əntaŋfə ka dzəgunənə ka ənja, patə da ha'ə, pooshi unə kəshi tə nyi. ");
INSERT INTO gde_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amma, ma slənyi ətsə patə, kaa malaaɓa ləkaləkatə ŋga anabiinə a ndzaa ka tantanyinə.” Wata lyawarənaakii patə a bwasee ka ci, təya huyipaa satii. ");
INSERT INTO gde_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Ma ənjitə kəshi tə Yeesu, kə kirə tii tə ci aasii aa ha Kayafasə gawə ŋga limanyinə. Davə dzii maliminə da gayinə də na. ");
INSERT INTO gde_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Ma Piita, kə gi ci də nə'unə tə Yeesu ba'ə ba'ə ha'ə mbu'i ci kura'ə aasii aa ha gawə ŋga limanyinə, ca dzə ka ndzaanə dasə da ənji nəhə yi ŋga Əntaŋfə, kaa ca nee ka muudinə ŋga səkii. ");
INSERT INTO gde_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Ma madiigərə limanyinə da patənə ŋga mətərəkinə, kə ali tii waɓənə ŋga jirakənə aashi Yeesu, kaa ənjə a shii ɓələginə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Amma taa ŋgahi ənji laŋə kyaara waɓənyinə ŋga jirakənə aashikii, patə da ha'ə kə təkuree tii ka upaanə taa rəŋwə. Ma ka muudinə, wata ənji bəra'i ahadatii a maɗətə ");
INSERT INTO gde_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","əŋki tii, “Ma bii əndətsa, tə'i ci da baawəɗa ŋga uulagi yi ŋga Əntaŋfə, ca ənə ka ghənətənə agi baanə makkə.” ");
INSERT INTO gde_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","Wata gawə ŋga limanyinə a maɗətə, əŋki ci ka Yeesu, “Pooshi waɓənaaku ŋga jikəvənə aagyanə waɓəətsə waɓi ənjitsə aashiku kwa?” ");
INSERT INTO gde_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Amma, ma Yeesu, majikəmə ci ka ci. Wata gawə ŋga limanyinə a ba ka ci, “Wiinə kə ləɓətə nyi duunə da Əntaŋfə Əndə vii əpinə: bawə keenə gooŋga, hə nə *Aləmasiihu Uuzənə ŋga Əntaŋfə tanyi nii?” ");
INSERT INTO gde_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Yeesu a ba ka ci, “Hə bagi ha'ə. Dagyanəkii ha'ə maa, wanyinə ka banə koonə: ka neenə nuunə ka Uuzənə ŋga əndə dasə da ciizəma Əntaŋfə Əndə baawəɗa, una nee ka ci ca jima agyanə kuraɓiinə dadagyə.” ");
INSERT INTO gde_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Makə fii gawə ŋga limanyinə ha'ə, wata ca tsəərəgi kəjeerənə ashikii, əŋki ci, “Kə geegi ci ka naakii nə kədəhə da Əntaŋfə. Gaama alə hara uushi'inə ma'ə, kə uugi ama fa bwaya sətə waɓi ci. ");
INSERT INTO gde_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Iitə nee unə noona?” Wata əŋki tii, “Weewee, see ɓələginə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Wata təya tiifə giirənə aagikii, təya dəgə tə ci, hara ənjə a tsa ka ci meeciinə a hwahwaaməkii, ");
INSERT INTO gde_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","təya dzə də banə ka ci, “Aləmasiihu, makə ɗii ci anabi nə hə, kuragi keenə taa wu digə tə hə!” ");
INSERT INTO gde_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ma ka saa'ikii, dasə nə Piita ahada ya. Wata əndə'i kadəmə a dzə, kya kəŋaanə dagyanəkii, əŋki ki ka ci, “Hə maa, rəŋwə nə hə agi ənji ŋga Yeesu əndə Galili.” ");
INSERT INTO gde_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amma, ma Piita, kə hiwee ci akəŋwaciitii patə, əŋki ci, “Mashiimə nyi sətsə cii kwa ba.” ");
INSERT INTO gde_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Piita a dzəgi a uura maya, əndə'i kadəmə a nee ka ci, wata əŋki ki ka ənjitə davə, “Ma əndətsa, tii da i Yeesu əndə Nazaratu nji tii.” ");
INSERT INTO gde_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Wata ca ənə ka hiweenə, ha'ə maa də jiɗa, əŋki ci, “Mashiimə nyi tə əndəkii.” ");
INSERT INTO gde_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Makə ta'avə gi'u əsə, wata ənjitə kəŋə kəŋə davə a əntsahə, təya ba ka Piita, “Weewee, agitii nə hə tanyi. Waɓənaaku ɓaarəgi keenə ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Makə fii Piita ha'ə, wata ca gwaŋə ka nyaalya naakii na, ca jiiɗə, əŋki ci, “Tantanyinə, mashiimə nyi tə əndətsa.” Pii wata ga'ə gyaagya a wagi. ");
INSERT INTO gde_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Fanə ŋga Piita ha'ə, wata ca buurətə sətə shi Yeesu a bii ka ci oo'i, ma taabu'u wanə ŋga gyaagya, ka jikənə nə hə makkə ka hiweenə ka shiinə tə nyi. Buurətənaakii ha'ə, wata ca dəməgi, ca dzə də tuunə də kiinə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Ma ətsə tsəɗakə, wata patənə ŋga madiigərə limanyinə da *gayinə ŋga Yahudiinə a ɗa *mətərəkinə ŋga ɓələginə tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Təya anəgi tə ci, təya palə da ci, təya dzə ka viinə tə ci ka Pilaatu ŋgwaməna. ");
INSERT INTO gde_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Makə nee Yahuda əndətə vii tə Yeesu aacii ənji oo'i, ka ɓələginə nə ənji tə Yeesu, wata ca ɗa wakaɗakinə, ca ənəpaagi də kwaɓa tibisətə makkə pu'unə ka madiigərə limanyinə da gayinə, ");
INSERT INTO gde_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","əŋki ci ka tii, “Kə ɗii nyi 'waslyakəənə ŋga vii tə əndətə yadə bwaya uushi ashikii.” Wata əŋki tii ka ci, “Mi dee nə neenə dava? Shoonaakwa.” ");
INSERT INTO gde_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Wata Yahuda a wa'agi kwaɓatə asəkə *yi ŋga Əntaŋfə, ca palə saakii, ca dzə ka əgəvə zə'wa a uurakii, ca əntəgi. ");
INSERT INTO gde_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Wata madiigərə limanyinə a ɗəmətə kwaɓata, əŋki tii, “Ma kwaɓana, madəɓəmə ənjə a əjigərə aasəkə mbuurə shiga ŋga yi ŋga Əntaŋfə, makə ɗii ci kwaɓa ŋga əpinə ŋga ənda.” ");
INSERT INTO gde_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Wata təya ɗa mətərəkinə agyanə kwaɓakii, təya ŋgərə, təya ɗərəgi də babara acii maghənə uuda, kaa ənjə a ŋgəəɗə mu'uminə davə. ");
INSERT INTO gde_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Ci 'wii ənji babarakii “babara ŋga idəna”. Ca'ə ənshinə, ha'ə nə ləmə ŋga babarakii. ");
INSERT INTO gde_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Də ha'ə ɗii waɓənə ŋga anabi Irimiya ka tantanyinə ətə bii ci: “Wata ənjə a ŋgərə kwaɓa tibisə makkə pu'unə, waatoo, kwaɓatə luuvə hara ənji *Isərayiila ɗərəginə də ci, ");
INSERT INTO gde_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","təya ŋgərə kwaɓakii, təya ɗərəgi də babara acii maghənə uuda, makə sətə bii Slandanə ka nyi ɗanə.” ");
INSERT INTO gde_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Makə kirə ənji tə Yeesu aakəŋwacii ŋgwaməna, ŋgwaməna a ləgwa ka ci, əŋki ci, “Hə nə ŋwaŋwə ŋga *Yahudiinə kwa?” Əŋki Yeesu ka ci, “Hə bagi ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Amma, makə rii madiigərə limanyinə da gayinə tsaa səɗəkii, majikəmə ci taa rəŋwə. ");
INSERT INTO gde_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Wata əŋki Pilaatu ka ci, “Paa hə agi fa uushi'iitsə ci təya baaba agyanəku kwa?” ");
INSERT INTO gde_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","Amma majikəmə Yeesu ka ci taa rəŋwə. Wata ca ɗagi ka ŋgwaməna ka sə ŋga hurəshishinə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Taa agi ŋgutə kumənə ŋga *Pasəka patə, kə sənaavə ka ŋgwaməna nə kapaa əndə furəshinə rəŋwə ətə ci ənjə a moo ənjə a kapaa tə ci ka tii. ");
INSERT INTO gde_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Ma ka saa'ikii, tə'i əndə furəshina ətə ɗii ləməkii Yeesu Barabasə. Taa wu patə, kə shii ci tə ci. ");
INSERT INTO gde_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Makə dzii ənji də na, wata əŋki Pilaatu ka tii, “Tə wu cuuna moo nya kapaa koona? Barabasə nii, anii Yeesu ətə ci ənjə a 'wa Aləmasiihu?” ");
INSERT INTO gde_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Acii kə shii ci ndilə ndilə oo'i, ma vii *gayinə ŋga Yahudiinə tə Yeesu ka ci, acii putə ŋga sərəha. ");
INSERT INTO gde_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Wata Pilaatu a ndzaanə dasə asəkə dəgələ ŋga la də gəŋwanaakii, minaakii a sləkee ka ci ka waɓənə də banə oo'i, “Ma əndə gooŋgatsa, ga ha ɗa taa mi də ci, acii kə sənii nyi bwaya səniinə agyanəkii ənshinə davəɗə.” ");
INSERT INTO gde_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Wata madiigərə limanyinə da gayinə a gwaŋə ka tsəkutə ənji kaa təya kədii tə ci, kaa ca kyapaa ka tii tə Barabasə, ənjə a ɓələgi tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","Wata ŋgwaməna a ənə ka ləgwanə ama ənja, əŋki ci, “Tə wu agi ənjinə bəra'i cuuna moo nya kapaa koonə kwa?” Wata əŋki tii, “Kyapaa keenə tə Barabasə!” ");
INSERT INTO gde_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Əŋki Pilaatu ka tii, “Aa mi ɗii cuuna moo nya ɗa də Yeesu ətə ci ənjə a 'wa Aləmasiihu?” Əŋki tii patə, “Wa ənjə a gwa'avə tə ci aashi ənfwa!” ");
INSERT INTO gde_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Amma əŋki Pilaatu, “Mi nə bwaya uushi ɗii ci kwa?” Wata təya tsakə ŋgəree ka uuratii də ŋgeerənə, əŋki tii, “Wa ənjə a gwa'avə tə ci aashi ənfwa.” ");
INSERT INTO gde_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Makə nee Pilaatu oo'i, pooshi uushi mbeenəkii ka ɗanə ma'ə, amma see panə ca moo maɗənə, wata ca ŋgərə ma'inə, ca yiɓəgi ciinəkii akəŋwacii ənji patə, əŋki ci, “Pooshi waɓənaaki agi əntənə ŋga əndətsa, shoonə goonə ma'ə.” ");
INSERT INTO gde_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Wata əŋki ənji patə, “Wa hakya ŋga əntənaakii a ndzaanə ooreenə da manjeevənə geenə.” ");
INSERT INTO gde_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Wata Pilaatu a kapaa ka tii tə Barabasə. Ca kavə kaa ənjə a fəslə tə Yeesu, ca vii tə ci əsə kaa ənjə a dzə ka gwa'avənə tə ci aashi ənfwa. ");
INSERT INTO gde_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Ma daba'əkii, wata soojiinə ŋga Pilaatu a ŋgərə tə Yeesu, təya kərəgərə tə ci aasəkə yi ŋga ŋgwaməna. Soojiinə patə, təya dzaanə ka ci də na, ");
INSERT INTO gde_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","təya səɗəgi tə ci, təya əgəvə ka ci əndə'i madizə gwada, ");
INSERT INTO gde_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","təya ŋgərə dəha, təya fuuɗə makə madiŋəna, təya ŋgavə ka ci aanəkii, təya kavə ka ci zala aa ciizəmakii, təya gərə'waanə ka ha'unə də ci, əŋki tii, “Wa əpinaaku a gərə aakəŋwa, ŋwaŋwə ŋga Yahudiina!” ");
INSERT INTO gde_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Təya tiifə giirənə aagikii, təya luugi zalatə aciikii, təya dəgə də ci anəkii. ");
INSERT INTO gde_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Makə uudəpaa tii ha'unə də ci, təya ŋgərəgi gwadata, təya ŋgavə ka ci naakii kəjeerənə, təya kərə tə ci ka gwa'avənə tə ci aashi ənfwa. ");
INSERT INTO gde_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ma təya palə a rəgwa, wata təya lapaa əndə'i əndə Sirina ətə ɗii ləməkii Simoonə. Soojiinə a ŋgərəvə ka ci ənfwə ŋga gwa'avə tə Yeesu aashikii. ");
INSERT INTO gde_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Təya mbu'u ka əndə'i ha ətə ci ənjə a 'wa Gwaləgoota, makə bana “Kəŋwə na.” ");
INSERT INTO gde_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Təya vii ka Yeesu ma'i inaba gwazə da maŋgərəkiki kuzəka, kaa ca sa. Makə təɓətə ci, wata ca kaaree. ");
INSERT INTO gde_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Təya gwa'avə tə ci aashi ənfwa, təya təəkəpaa kəjeerənaakii ahadatii də kwaaranə. ");
INSERT INTO gde_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Wata təya ndzaa davə ka nəhənə tə ci, ");
INSERT INTO gde_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","təya tsa'avə manaahə uushi dagyanəkii, waatoo, 'waslyakəətə lii ənji ashikii. Ma sətə nyaahə ənji dagyanəkii, “Ma əndəna, ci nə Yeesu, ŋwaŋwə ŋga Yahudiinə.” ");
INSERT INTO gde_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Təya gwa'avə əsə ənji maabə bəra'i aashi hara ənfuginə ataŋgalakii, rəŋwə da ciizəmakii, əndə'i da madzənakii. ");
INSERT INTO gde_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Ma ənji piitinə dadavə əsə, təya ha'u də ci, təya dzə də udzə də nətii, ");
INSERT INTO gde_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","təya ba, “Hə ətsə bii ka uulaginə nə hə yi ŋga Əntaŋfə, ha ənə ka ghənətənə agi baanə makkə, maɗa *Uuzənə ŋga Əntaŋfə nə hə, luupaa naaku na, ha jimagərə ashi ənfutsa!” ");
INSERT INTO gde_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Ha'ə makə ətsə əsə ha'u madiigərə limanyinə da maliminə da gayinə də ci, əŋki tii: ");
INSERT INTO gde_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Kə mbee ci ka luupaa hara ənji, amma kə təkuree ci ka luupaa naakii na. Əntaa kə bii ci, ŋwaŋwə ŋga *Isərayiila nə ca? Wa ca jimagərə gadəvə ashi ənfutsa, kaama vii ka ci gooŋga! ");
INSERT INTO gde_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Kə kii ci nəkii oo'i, ka luupaanə nə Əntaŋfə tə ci. Əŋki ci əsə, Uuzənə ŋga Əntaŋfə nə ci. Taku kaama nee maɗa kə uu'i Əntaŋfə tə ci, ca luupaa tə ci əndzə'i!” ");
INSERT INTO gde_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Ənji maabətə gwa'avə ənji tə tii ataŋgalakii maa, ha'ə dzaanii tii tə ci əsə. ");
INSERT INTO gde_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Ma ətsə uusəra takərə, kə ɗii təkunə anə hanyinəkii patə dəgwamə dəŋə ka tibisə makkə ŋga kədəwanə. ");
INSERT INTO gde_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Ma ətsə bahə tibisə makkə, wata Yeesu a ŋgəree ka uurakii, ca ka vurənə, əŋki ci, “Eeli, Eeli, lyama sabakətani?”, makə bana, “'Ya'ə Əntaŋfwaakya, 'ya'ə Əntaŋfwaakya, ka mi bwasee hə ka nyi kwa?” ");
INSERT INTO gde_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Wata hara ənjitə kəŋə kəŋə davə ca fa tə ci, əŋki tii, “Waatsə əndətsə ka 'wanə tə *Iliya.” ");
INSERT INTO gde_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Əndə'i əndə agitii a huyipaa pii pii, ca dzə ka ŋgərə soosa, ca shimwatə agi mahwarəkinə, ca tsa'avə aama magərə kada, ca vii aadəgyə aama Yeesu kaa ca shiɓə. ");
INSERT INTO gde_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","Amma hara ənjə a ba, “Taku zəku'i kaama nee maɗa ka shinə nə Iliya ka luupaanə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Yeesu a ənə ka ŋgəree ka uurakii, ca ka vurənə, wata əpinə a dzəgi amakii. ");
INSERT INTO gde_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Tə'i gwada wahə ama hatə palee də laaɓanə asəkə yi ŋga Əntaŋfə. Əntəginaakii ha'ə, wata pyaahu! gwadatə a təkəgi bəra'i, kəshanə dagyə kura'ə aa dəgərə. Hanyinə a udzə, taalanə nə faariinə. ");
INSERT INTO gde_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Gu'u ənji a wuunəgi əsə, ənji ŋga Əntaŋfə laŋə ətə sha məətəgi, kə ma'i tii da i əpinə. ");
INSERT INTO gde_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Daba'ə makə ma'i Yeesu agi maməətə ənja, təya shiishigi asəkə gu'unyinatii, təya dəməgərə aasəkə malaaɓa vəranə. Ma dava, kə nee laŋənə ŋga ənji ka tii. ");
INSERT INTO gde_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Makə nee gawə ŋga soojiinə da ənjaakii ətə ca nəhə tə Yeesu ka gaŋgəzənə ŋga hanyinə da sətə slənyi, kə ŋgwaləgi tii ka shaŋə, təya ba: “Tantanyinə, ma əndətsa, Uuzənə ŋga Əntaŋfə nə ci.” ");
INSERT INTO gde_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Tə'i makinə laŋə davə ca tsaama dzaɗə. Ma təya, atsaa Yeesu shi tii daga anə hanyinə ŋga Galili, təya tsakə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ahadatii nə Mariyaama Magədalina, da Mariyaama məci i Yakubu da Yusufu. Ahadatii əsə nə məci manjeevənə ŋga Zabadiya. ");
INSERT INTO gde_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Makə ɗii kədəwanə, kə shi əndə'i əndə gəna ətə ɗii ləməkii Yusufu, əndə Aramatiya. Ci maa, lawarə ŋga Yeesu nə ci. ");
INSERT INTO gde_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Kə gi ci aaɓii Pilaatu, ca kədii rəgwa kaa ca dzə ka ŋgiragərə wə ŋga Yeesu. Wata Pilaatu a ba, wa ənjə a vii ka ci. ");
INSERT INTO gde_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Wata Yusufu a dzə, ca jimagərəgi də wə ŋga Yeesu, ca haɗətə asəkə kura marəma, ");
INSERT INTO gde_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ca dzə ka baneenə asəkə kura gu'u ətə tələpaa ənji ka ci ka naakii na ashi pasla, ca dəlavə maɗuunə faara aama gu'ukii, ca palə saakii. ");
INSERT INTO gde_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Ma Mariyaama Magədalina da əndə'i Mariyaama, davə nə tii dasə dasə akəŋwacii gu'ukii. ");
INSERT INTO gde_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Pukyatə hakii, waatoo, *uusəra ŋga əpisəka, wata madiigərə limanyinə da Farisanyinə a dzə aa ha Pilaatu ka ciinə rəŋwə, ");
INSERT INTO gde_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","təya ba ka ci, “'Ya'ə maɗuunə ənda, kə buurətiinə uushi: ma saa'itə majirakətə ma'ə da i əpinə, kə bii ci oo'i, ma daba'ə baanə makkə, ka ənənə nə ci ka maɗənə agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","Acii ha'ə, bawə ka ənjə a nəhə gu'waakii ŋga'ə, see maɗa dzəgi baatsə makkə, acii ga lyawarənaakii a dzə ka hərətə waakii, təya ba ka ənja, kə ma'i ci agi maməətə ənja. Maa kə ɗii ha'ə, ma jirakəətsa, ka ɗanə laŋə palee ka ŋga ŋukə.” ");
INSERT INTO gde_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Əŋki Pilaatu ka tii, “Fəɗəmə soojiinə, una kərə aa dəvə. Wa təya nəhətə ŋga'ə makə sətə kaɗeesəkə koonə.” ");
INSERT INTO gde_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Wata təya palə, təya dzə ka ɗavə sagida ama gu'ukii, acii ga ənjə a wunəgi, təya kavə ənji nəhə gu'ukii. ");
INSERT INTO gde_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Ma daba'ə *uusərə ŋga əpisəka, ətsə tsəɗakə də uusəra alatə, kə gi Mariyaama Magədalina da əndə'i Mariyaama ka tsaamə nə ŋga gu'u ŋga Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Pii wata hanyinə a gaŋgəzə ka shaŋə, acii kə jima malaa'ika ŋga Slandanə dadagyə. Ca dalagi faaratə ama gu'uta, ca ndzaanə dasə anəkii. ");
INSERT INTO gde_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Ma jiganaakii, ɓərənə nə ci makə pyapiɗənə ŋga vəna. Makə əmputə kəbənə nə kəjeerənaakii də tyaslyaslyaanə əsə. ");
INSERT INTO gde_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Makə nee ənji nəhə gu'ukii ha'ə, udzənə nə shishinətii acii ŋgwalənə, təya kwaalagi aa panə makə maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Wata malaa'ikakii a waɓə ka makiita, əŋki ci, “Goona ŋgwalə. Kə shii nyi, tə Yeesu cuuna alə, ətə gwa'avə ənji aashi ənfwa. ");
INSERT INTO gde_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Paa ci ma'ə ganə, kə ma'i ci agi maməətə ənji makə sətə bii ci. Shoomə, nda neemə ka hatə nji ci pərəɓə davə. ");
INSERT INTO gde_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Ma ɗanuunə, dəmə pii pii, una dzə ka banə ka lyawarənaakii oo'i, kə ma'i ci agi maməətə ənja. Ci na 'watəgi mbu'unə koonə aanə hanyinə ŋga Galili. Davə nuuna nee ka ci. Buurətəmə sətsə bii nyi koonə.” ");
INSERT INTO gde_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Makə fii tii ha'ə, wata təya maɗə pii davə, təya palə də ŋgwalənə ləɓə da mooɗasəkə ka shaŋə, təya huyi ka kərə habarakii ka *lyawarənə ŋga Yeesu. ");
INSERT INTO gde_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","Pii wata Yeesu a lapaa tə tii, əŋki ci, “Usamə!” Wata makiitə a əntsahətə aaɓiikii, təya gərə'waanə, təya kəsətə səɗəkii ka paslə tə ci. ");
INSERT INTO gde_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","Əŋki Yeesu ka tii, “Goona ŋgwalə, dəmə ka banə ka ndzəkəŋushi'inəki kaa təya dzə aanə hanyinə ŋga Galili. Davə nə təya nee ka nyi.” ");
INSERT INTO gde_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Ma makiitə a palə, wata hara ənji agi soojiitə nja nəhə gu'utə a maɗə, təya palə aasəkə vəranə, təya dzə ka banə ka madiigərə limanyinə tə patənə ŋga sətə slənyi. ");
INSERT INTO gde_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Madiigərə limanyinə a dza də nə da gayinə ka ɗa *mətərəkinə, təya ŋgərə kwaɓa laŋə, təya vii ka soojiita, ");
INSERT INTO gde_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","təya ba ka tii, “Ma banuuna: ‘Lyawarənaakii shi davəɗə, təya shi ka hərəma waakii, inə ka ŋunyinə.’ ");
INSERT INTO gde_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Maɗa kə mbu'i habarakii aa limə ŋgwaməna, ka zə'utənə niinə də haŋkalaakii də banə, pooshi sə ŋga idəpaanə ashuunə, ina luupaa tuunə.” ");
INSERT INTO gde_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Wata soojiitə a luu kwaɓata, təya ɗatə makə sətə bii ənji ka tii. Ha'ə huwugi habarakii ahada *Yahudiinə ca'ə ka ənshinə. ");
INSERT INTO gde_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Yoo, lyawarənə ŋga Yeesu pu'u aməntaŋə a palə aanə hanyinə ŋga Galili, aanə giŋutə bii Yeesu ka tii dzənə. ");
INSERT INTO gde_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Makə nee tii ka ci, təya paslə tə ci. Amma, ma hara ənji ahadatii, kə shakii tii tə ci, mbu'u əntaa ci ətsa. ");
INSERT INTO gde_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Yeesu a əntsahə aaɓiitii, əŋki ci ka tii, “Kə vii Əntaŋfə ka nyi patənə ŋga baawəɗa dadagyə da ganə a duuniya. ");
INSERT INTO gde_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","Acii ha'ə, dəmə aaɓii patənə ŋga ənji ŋga *duuniya, una zhi'wee ka tii ka lyawarənaaki, una ɗa ka tii bapətisəma aagi ləmə ŋga Dəna, da ləmə ŋga Uuzəna, da ləmə ŋga Malaaɓa Ma'yanə, ");
INSERT INTO gde_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","una dzəgunə ka tii kaa təya nə'utə patənə ŋga sətə bii nyi koonə. Ma nyi, ka ndzaanə nə nyi doonə taa guci patə, ca'ə ka muudinə ŋga duuniya.”");
INSERT INTO gde_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Wiinə 'watəginə ŋga Ŋunyi Habara agyanə Yeesu *Aləmasiihu, *Uuzənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Kə ɗii makə sətə bii Əntaŋfə ka Uuzənaakii asəkə ləkaləkatə ŋga *anabi Isaaya oo'i: “Wanyinə ka sləkeenə ka masləkee əndaaki kaa ca ta ka hə kəŋwanə, ca haɗatəgi ka hə də rəgwa, taabu'u nii kwa dzə. ");
INSERT INTO gde_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Ka kaalanə nə ci agi bilinə, ca ba, Haɗatəgimə də rəgwa ka Slandana, Kəŋeemə ka ci ka rəgwa.” ");
INSERT INTO gde_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Ha'ə makə ətsə shigi Yoohana əndə ɗa bapətisəma aagi bilinə. Ca waaza ka ənja, ca ba, “Uneemə ka ɗa 'waslyakəənə, una baanə ka Əntaŋfə, ənjə a yiɓə koonə bapətisəma, kaa Əntaŋfə a tifyagi koonə 'waslyakəənə goonə.” ");
INSERT INTO gde_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Wata ənji asəkə vəranə ŋga Urusaliima, da hara hanyinə ŋga Yahudiya patə a shi ka fa waɓənə ama Yoohana. Təya baabagi 'waslyakəənatii, ca ɗa ka tii bapətisəma asəkə gəərə ŋga Urədunə. ");
INSERT INTO gde_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Ma Yoohana, shiŋkinə ŋga ŋgyalooba nji ka kəjeerənaakii. Ca əgəgi ŋukii də gyara ŋga kuvə'unə. Ayiwa da moozəŋa nji zəmaakii. ");
INSERT INTO gde_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Ca ba ka ənja, “Tə'i əndətə na uugya ba'ə ka shinə, ɗuunuunaakii palee ka naaki. Taa zə'u ŋga ɓiɓinaakii, paa nyi mbu'i bahə gwaŋaanənə, nya pərəgi. ");
INSERT INTO gde_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Də ma'inə ɗii nyi koonə bapətisəma. Amma ma ca, də Malaaɓa Ma'yanə nii kəya ɗa koonə bapətisəma.” ");
INSERT INTO gde_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Ma ka saa'ikii, kə ma'i Yeesu də Nazaratu anə hanyinə ŋga Galili, ca palə aaɓii Yoohana. Yoohana a ɗa ka ci bapətisəma asəkə gəərə ŋga Urədunə. ");
INSERT INTO gde_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Ma ca shigi ha'ə agi ma'inə, wata ca nee ka səkəntaŋfə mawunəkii, Ma'yanə ŋga Əntaŋfə a jima aanəkii makə kurəkuta. ");
INSERT INTO gde_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Wata uura ŋga əndə a waɓya dadagyə, əŋki ci, “Hə nə Uuzənaaki. Kə uu'i nyi tə hə. Hə ca uuɗagi səkəki.” ");
INSERT INTO gde_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Ma daba'əkii, pii wata Ma'yanə ŋga Əntaŋfə a kərəgi tə Yeesu aagi bilinə. ");
INSERT INTO gde_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","Baanə ənfwaɗə pu'unə nə ci agi bilinə. Seetanə a təɓə tə ci. Tə'i dabanyinə agi biliita. Amma kə cakə malaa'ikanyinə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Kə kəsəgərə ənji tə Yoohana aa furəshina, wata Yeesu a maɗə, ca palə aanə hanyinə ŋga Galili. Ca dzə də waaza Ŋunyi Habara ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Əŋki ci, “Kə uugi saa'i mbu'unə. Kədəhə nə Əntaŋfə ka ɗa ŋwaŋuunaakii. Uneemə ka ɗa 'waslyakəənə, una baanə ka ci, una vii gooŋga ka Ŋunyi Habara.” ");
INSERT INTO gde_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Ma Yeesu a dzə də wiigi'inə ama uunəvə ŋga Galili, wata ca lapaa ndzəkəŋushi'inə bəra'i, təya təəmə; waatoo i Simoonə da Andərawəsə. ");
INSERT INTO gde_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Yeesu a ba ka tii, “Shoomə atsaki, kaa nya dzəgunə koonə makə sətə ci ənjə a ɗa slənə ŋga təəmə ənja.” ");
INSERT INTO gde_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Pii wata təya bwasee ka slaaɗatii, təya palə atsakii. ");
INSERT INTO gde_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Ma ca əntsahee gi'u, wata ca nee ka manjeevənə ŋga Zabadiya, waatoo i Yakubu da Yoohana, tii asəkə kumbawalatii ka haɗa də slaaɗatii. ");
INSERT INTO gde_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Pii wata ca 'wa tə tii, təya bwasee ka dəsənətii da ənji slənə ka tii asəkə kumbawala, təya palə atsakii. ");
INSERT INTO gde_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Ma daba'əkii, təya palə aasəkə vəranə ŋga Kafarənahumə. Makə mbu'ya *uusəra ŋga əpisəka, wata Yeesu a dzə aasəkə *kuvə də'wa, ca ndzaŋə dzəgunənə ka ənja. ");
INSERT INTO gde_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Makə fii tii dzəgunənaakii, kə ɗii ka tii ka sə ŋga hurəshishinə, acii də shiinaakii saakii cii kəya dzəgunə ka tii, əntaa makə sətə ci *maliminə ŋga bariya a dzəgunə ka tii. ");
INSERT INTO gde_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Pii wata waatsə əndə ginaaji asəkə kuvə də'watii, ");
INSERT INTO gde_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ca ka vurənə, əŋki ci, “Yeesu əndə Nazaratu, mi nə uushi gaamə a pa da hə kwa? Kə shi hə ka zamaginə diinə kwa? Kə shii nyi taa wu nə hə: Malaaɓa əndətə sləkee Əntaŋfə nə hə.” ");
INSERT INTO gde_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Wata Yeesu a la ŋguruunə ka ginaajita, əŋki ci, “Ndzaawə kəɗa'ə! Dzəgi ashi əndətsa!” ");
INSERT INTO gde_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Wata ginaajitə a udzətə tə əndəta, ca kagi vurənə, ca shigi ashikii. ");
INSERT INTO gde_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Kə ɗii ka ənji patə ka sə ŋga hurəshishinə ka shaŋə, təya ba ahadatii, “Mi nə uushi ha'ə makə ətsa? Ma ətsa, kura dzəgunənə. Taa ginaajinyinə maa, agi wazənə nə ci ka tii də baawəɗa, təya fa tə ci.” ");
INSERT INTO gde_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Pii wata habaraakii a huwugi taa dama patə anə hanyinə ŋga Galili. ");
INSERT INTO gde_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Makə shigi i Yeesu asəkə kuvə də'wa, wata təya dzəgərə tii da i Yakubu da Yoohana aasii aa ha i Simoonə da Andərawəsə. ");
INSERT INTO gde_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ma gi ci, gwakə nə sərəhu ŋga Simoonə minəkii, kə tsəfəgi shishinətə iza'u. Wata təya ba ka ci oo'i, gwakə nə ki. ");
INSERT INTO gde_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Makə fii ci ha'ə, ca dzə aaɓitə, ca kəsətə tə ki ka ciinə, ca maɗee ka ki. Wata iza'unə ŋga shishinətə a əpigi. Ka ha'ə, kə ɗii ki ka tii zəma. ");
INSERT INTO gde_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Ma kədəwanə, ətsə kulagərənə ŋga uusəra, wata ənjə a kyaara ka Yeesu ənji bwanea da ənji ginaaji patə. ");
INSERT INTO gde_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Kə jagi ənji vəraatə də nə patə aahatə aa uura mayi. ");
INSERT INTO gde_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Ca mbəɗəpaa də ənjitə kyaara ənji da bwaneanyinə laŋə kama kama ashitii, ca lyaakagi ginaajinyinə laŋə ashitii. Pooshi ci luuvə ginaajinyinə a waɓə, acii kə shii tii taa wu nə ci. ");
INSERT INTO gde_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Ma ətsə tsəɗakə ha ma'ə mapukəmə, wata Yeesu a maɗə, ca palə ka hatə pooshi ənji davə, ca ɗa də'wa. ");
INSERT INTO gde_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Makə ma'i Simoonə da hara ənjita, wata təya palə ka alənə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","Makə lapaa tii tə ci, əŋki tii ka ci, “Agi alənə nə ənji patə tə hə.” ");
INSERT INTO gde_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Əŋki ci ka tii, “Ma ɗanaamə, dzaamə ka hara vəranyinə kədə-kədəhə kaa nya waaza davə əsə. Acii ci nə sətə kira tə nyi.” ");
INSERT INTO gde_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Wata ca wiigi'itə hanyinə ŋga Galili patə, ca dzə də waazanə asəkə kuvə də'wanyinatii, ca lyaakagi ginaajinyinə ashi ənja. ");
INSERT INTO gde_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Yoo, wata əndə'i əndə uyikuzənə a shi aaɓii Yeesu, ca gərə'waanə akəŋwaciikii, ca kədii kaa Yeesu a tsakə tə ci, əŋki ci, “Maɗa ka luuvənə nə hə, ka mbeenə nə hə ka mbəɗəpaanə də nyi, kaa nya shii ndzaanə malaaɓakii.” ");
INSERT INTO gde_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Kə nyihə Yeesu təgunuunə ŋga əndəta, wata ca təɗapaa ciinəkii, ca təɓətə tə ci, ca ba ka ci, “Awa, kə luuvə nyi. Mbəɗuu.” ");
INSERT INTO gde_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Pii wata kə dzəgi uyikuzənətə ashikii, kə mbə'i ci. ");
INSERT INTO gde_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Wata Yeesu a ba ka ci, “Duu saaku.” Amma ca ɗa ka ci bariya də ŋgeerənə ");
INSERT INTO gde_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","də banə, “Fatə ŋga'ə, kaa nya ba ka hə, ga ha bapaa ka əndə sətsə ɗii shaŋə. Amma ma ɗanəkwa, duu aa ha *limanə, ha ɓaarii ka ci naaku na, ca tsaamətə taa iitə nə hə. Ma daaba'əkii, ha ɗa sataka makə sətə bii Muusa, kaa ənji patə a shii oo'i, kə mbə'i hə tanyi.” ");
INSERT INTO gde_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Amma əndətə a dzə saakii də baaba waɓəətsə taa dama patə yadə mbəɗeenə taa gi'u. Putə ŋga ətsə ha'ə, pooshi Yeesu ənyi ka mbee ka dzənə aasəkə əndə'i vəranə ka rəgwa ginə ŋga ənji ma'ə. Amma kə ndzaa ci saakii agi bilinə, ənjə a shi aaɓiikii taa dama patə. ");
INSERT INTO gde_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Ma daba'ə baanə gi'u, kə ənyi Yeesu aasəkə vəranə ŋga Kafarənahumə. Ma fii ənji asii nə ci, ");
INSERT INTO gde_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","wata ənji laŋə a dzə aaɓiikii, pooshi ha ŋga zhi'iginə davə asii kura'ə a uura mayi acii laŋənə ŋga ənja. Ca dzə aakəŋwa də waaza waɓənə ŋga Əntaŋfə ka tii. ");
INSERT INTO gde_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Wata hara ənjə a shi da i mahurəməsə ənda, ənji ənfwaɗə kira tə ci. ");
INSERT INTO gde_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Makə təkuree tii ka mbu'unə aaɓii Yeesu acii laŋənə ŋga ənja, wata təya ndərəgi aanə kuvətə ɗii Yeesu davə, təya tələgi ɗaŋə da ci. Makə tələgi tii, təya kagərə tə mahurəməsə əndətə pərəɓə asəkə ədzə baanə. ");
INSERT INTO gde_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Makə nee Yeesu ka gi'inatii tə ci, wata ca ba ka mahurəməsə əndəta: “Uuzənaaki, kə upaa hə tifyaginə ŋga 'waslyakəənaaku.” ");
INSERT INTO gde_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Ma dava, tə'i hara maliminə dasə dasə ka fanə, wata təya laagwa agi hiimatii, ");
INSERT INTO gde_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","əŋki tii, “Ka mi banəkii ha'ə kwa? Kə geegi ci ka naakii nə makə Əntaŋfə. Wu saŋə ca mbee ka tifyagi 'waslyakəənə ŋga əndə maɗaamə Əntaŋfə rəŋwə dyaŋa?” ");
INSERT INTO gde_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Kə shii Yeesu hiimatii. Wata əŋki ci, “Ka mi də tsarə ŋga hiimatsə ha'ə a nuunə kwa? ");
INSERT INTO gde_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","Ŋgutə palee də ŋgufənə saŋa? Gəɗə banə ka mahurəməsə əndətsə oo'ya, kə upaa hə tifyaginə ŋga 'waslyakəənaaku nii, anii gəɗə banə ka ci, Maɗətə, ŋgəruu ədzə baanaaku, duu saakwa? ");
INSERT INTO gde_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","Amma takumə kaa nya ɓaarii koonə oo'i, ma nyi Uuzənə ŋga ənda, tə'i nyi da baawəɗa ŋga tifyagi 'waslyakəənə ŋga ənji ganə a duuniya.” Wata əŋki ci ka mahurəməsə əndəta, ");
INSERT INTO gde_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“Wanyinə ca ba ka hə, maɗətə, ŋgəruu ədzə baanaaku, ha palə saaku aasii.” ");
INSERT INTO gde_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Ma ənjə a nee patə, wata hatsə əndətə a maɗətə, ca ŋgərə ədzə baanaakii, ca palə saakii aasii. Kə ɗii ka tii patə ka sə ŋga hurəshishinə. Wata təya ɗuunətə tə Əntaŋfə, əŋki tii, “Pooshi inə sha nee ka uushi makə ətsa.” ");
INSERT INTO gde_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Ma daba'əkii, kə shigi Yeesu, ca palə aama uunəvə ŋga Galili. Wata daŋkana a dzə ka dzatə də nə aɓiikii, ca dzəgunə ka tii. ");
INSERT INTO gde_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Makə uugi ci dzəgunənə ka tii, ca maɗə, ca palə də wiigi'inə, wata ca lapaa tə əndə luu tsəka ətə ɗii ləməkii Leewi, uuzənə ŋga Haləfa, ci dasə asəkə kuvə ŋga slənaakii. Əŋki Yeesu ka ci, “Shiwa atsaki.” Wata hatsə Leewi a maɗətə, ca nə'u tə ci. ");
INSERT INTO gde_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Wata Yeesu a dzə ka zəmənə aa ha Leewi aasii. Tə'i *ənji luu tsəkə laŋə da i hara ma'waslyakə ənji laŋə ətə nyi'u tə Yeesu. Təya zəmə ka ha rəŋwə da i Yeesu da lyawarənaakii. ");
INSERT INTO gde_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Makə nee maliminə ŋga kurəgə ŋga *Farisanyinə Yeesu a zəmə da tsarə ŋga ənjitsa, wata təya ləgwa ama lyawarənaakii, əŋki tii, “Mi saŋə ɗii cii kəya zəmə da ənji luu tsəka da i hara ma'waslyakə ənja?” ");
INSERT INTO gde_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Makə fii Yeesu sətə bii tii, əŋki ci ka tii, “Pooshi mandandaŋə ənji ka alə kuzəka, see ənji bwanea. Ma shi nyi aasəkə duuniya, ka 'waa'wanə tə ma'waslyakə ənji aaɓiiki, əntaa kaa nya 'wa tə ənjitə ca slənə uushi də rəgwakii.” ");
INSERT INTO gde_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Ma ka əndə'i uusəra, lyawarənə ŋga Yoohana da i Farisanyinə, təya ɗa suumaya. Hara ənjə a shi aaɓii Yeesu, əŋki tii, “Mi saŋə ɗii ci lyawarənə ŋga Yoohana tii da Farisanyinə a ɗa suumaya, amma ma lyawarənaaku, pooshi tii agi ɗana?” ");
INSERT INTO gde_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Yeesu a ənigi ka tii də waɓənə agyanə naakii nə, əŋki ci, “Yaci tə'i guviinə ŋga dagwa maɗanə ətə bii ci ka tii da məhuraakəya, maɗa kə gi tii ka luu maɗanəkəya, ka ɗanə nə tii suumaya aɓiikii kwa? Pooshi. Maa ka hakii nə tii da i dagwa maɗanə, pooshi tii ka mbeenə ka ɗa suumaya. ");
INSERT INTO gde_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Amma kadə nə uusəra mbu'ya ətə nə ənjə a ŋgərəgi dagwa maɗanə aɓitii, saa'ikii nə təya ɗa suumaya. ");
INSERT INTO gde_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“Pooshi əndə ka mbakə iirə kəjeerənə də kura kəjeerənə. Acii ka tsəəmətənə nə kurakii. Ca tsakə tsagi iirəkii palee ka ətə sha tsii. ");
INSERT INTO gde_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","“Pooshi əndə əsə ka ciirə kura ma'i inaba aasəkə iirə mbuurə kuvə'unə. Maɗa kə ɗii ha'ə, ka taginə nə mbuurə kuvə'unəkii acii əbunə ŋga ma'i inaba. Ənjə a ətee ka ma'i inaba tii da mbuurə kuvə'unə patə. Kura ma'i inaba tii da kura mbuurə nə ndzaanə mbərə mbərə.” ");
INSERT INTO gde_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Ma ka əndə'i uusəra, waatoo uusəra ŋga əpisəka, Yeesu a pitəgi tii da lyawarənaakii da səkərə ŋga aləkamaara. Wata lyawarənaakii a dzə də ɓiiyiinə aləkamaara, təya tsəɓə. ");
INSERT INTO gde_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Makə nee Farisanyinə ha'ə, əŋki tii ka Yeesu, “Ka mi ci lyawarənaaku a ɗa sətə maviimə *bariya rəgwa ŋga ɗanə uusəra ŋga əpisəka?” ");
INSERT INTO gde_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Əŋki Yeesu ka tii, “Mashimə una jaŋgii sətə ɗii *Dawuda kuna? Ma agi wanyiitə nji Abiyata ka gawə ŋga limanyinə, makə nee Dawuda tə'i uushi dəɓee ca upaa, kə ɗii maɗəfənə tə tii da ənjaakii əsə, wata ca dəməgərə aasəkə *yi ŋga Əntaŋfə, ca ŋgiragi burooditə ɗəkəpaa ənji ka Əntaŋfə. Ma ətsa, kə taŋəgi ci bariya acii əntaa taa wu patə ca adə buroodita, see limanyinə tanə. Amma kə agi Dawuda buroodita. Ca vii ka ənjaakii əsə.” ");
INSERT INTO gde_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Yeesu a tsakə banə ka tii, əŋki ci, “Ma kii Əntaŋfə uusəra ŋga əpisəka, kaa əndə a shii nafaginə. Əntaa tə əndə kii ci kaa uusəra ŋga əpisəka a nafagi də ci. ");
INSERT INTO gde_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","Acii ha'a, ma nyi *Uuzənə ŋga ənda, taa uusəra ŋga əpisəkə maa, nyi nə Slandanəkii.” ");
INSERT INTO gde_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Ma ka əndə'i *uusəra ŋga əpisəka, kə ənyi Yeesu aasəkə kuvə də'wa. Tə'i əndə mantə ciinə davə. ");
INSERT INTO gde_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ma davə əsa, tə'i hara ənji ca alə sə ŋga idəpaanə ashi Yeesu, kaa təya kərə tə ci aakəŋwacii gəŋwanə. Wata təya kanətsaa ka ci ginə, kaa təya nee mbu'u ka mbəɗəpaanə nə ci də əndətə uusəra ŋga əpisəka. ");
INSERT INTO gde_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Yeesu a ba ka əndə mantə ciita, “Maɗətə, kəŋaanə.” ");
INSERT INTO gde_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Wata əŋki ci ka tii, “Iitə saŋə vii bariya gaamə kaamə rəgwa ŋga ɗana? Ŋga ɗa ŋga'əənə uusəra ŋga əpisəkə saanii, anii ŋga ɗa bwaya bwayaana? Ŋga mbəɗəpaanə də əndə saanii, anii ŋga ɓələginə tə ca?” Amma kə zavə tii kəɗa'ə, pooshi tii shii sə ŋga jikənə ka ci. ");
INSERT INTO gde_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Kə ɓəzhi səkə ŋga Yeesu, acii təkuree tii ka nəhə təgunuunə, ca tsaamə tə tii, əŋki ci ka əndə mantə ciita, “Təɗapaa ciinəku.” Wata ca təɗapaa ciinəkii, ca ənəgərə makə ŋga ŋukə. ");
INSERT INTO gde_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Makə nee *Farisanyinə ha'ə, wata pii təya palə aaɓii ənji ŋga *Hirudusə, təya dzə ka ɗa mətərəkinə ŋga ɓələginə tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Wata Yeesu a maɗə tii da lyawarənaakii, təya palə aama uunəvə ŋga Galili. Ənji laŋə nyi'u tə tii. Hara ənji, ənji Galili nə tii, hara ənji əsə, kə shi tii daga anə hanyinə ŋga Yahudiya, ");
INSERT INTO gde_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","i asəkə vəranə ŋga Urusaliima, i anə hanyinə ŋga Idumaya, i ataŋəgi gəərə ŋga Urədunə, i asəkə vəranyinə ŋga Tiira da Sidoonə. Ənjitsə patə, aaɓii Yeesu shi tii, acii kə fii tii habara ŋga uushi'iitə cii kəya ɗaaɗa. ");
INSERT INTO gde_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Makə nee Yeesu, wiitsə ənji laŋə ka ɓilatənə tə ci, wata ca ba ka lyawarənaakii kaa təya alya ka ci kumbawala. ");
INSERT INTO gde_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Acii kə fii ənji kə mbəɗəpaa ci də ənji laŋə, ci ɗii əncahə ənji bwanea laŋə aaɓiikii, kaa təya dəba'ətə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Maɗa nee ənji ginaaji ka ci, təya kulagi akəŋwaciikii, təya ka vurənə, əŋki tii, “Hə nə *Uuzənə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Wata Yeesu a wazə ka tii də ŋgeerənə, əŋki ci, “Goona bagi taa wu nə nyi.” ");
INSERT INTO gde_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Ma daba'əkii, Yeesu a maɗə, ca ndərə aanə giŋwa. Ca 'wa tə ənjitə mwayi ci, kaa təya shi aaɓiikii. ");
INSERT INTO gde_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Ca taɗə ənji pu'u aji bəra'i ahadatii, əŋki ci ka tii, “Ma ta'i nyi tuunə, kaama ndzaanə ka hakii, nya sləkee koonə ka ɗa waaza. ");
INSERT INTO gde_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Nya vii koonə baawəɗa ŋga mbəɗəpaanə də ənji ginaajinyinə.” ");
INSERT INTO gde_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Wiinə ləmə ŋga ənjitə ta'i ci: Simoonə ətə ikə ci ka ci əndə'i ləmə Piita; ");
INSERT INTO gde_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Yakubu da Yoohana, manjeevənə ŋga Zabadiya; kə ikə ci ka tii ləmə “Buwanərəgəsə,” waatoo makə bana, “Ənjitə pii pii ɓəzənə səkətii, makə dzanə ŋga vəna”, ");
INSERT INTO gde_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","i Andərawəsə, i Filibusə, i Barətalamawusə, i Mata, i Tooma, i Yakubu uuzənə ŋga Haləfa, i Tadawusə, i Simoonə əndə moo dimwaanə ka hanyinaakii, ");
INSERT INTO gde_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ba'a Yahuda Isəkariyootə. Ma uudəpaa ba'a, ci vii tə Yeesu aacii ənja. ");
INSERT INTO gde_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Ma daaba'əkii, Yeesu a maɗə, ca palə saakii aasii. Wata daŋkana a nə'uunə tə ci, təya dzatə də nə aɓiikii. Taa zəmə maa, pooshi i Yeesu upaa saa'i ŋga zəmənə, acii laŋə nə ənji ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Hara ənjə a dzə də pəɗənə tə ci, əŋki tii, “Ma əndətsa, pooshi ma'ə haŋkalaakii ka hakii.” Makə fii ndzəkəŋushi'inəkii ha'ə, wata təya ɗa aniya ŋga dzənə ka kəshaginə tə ci ahada daŋkana. ");
INSERT INTO gde_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ma malimiitə shi də Urusaliima natii, kə bii tii, “Ma ca, Byaləzabulə ŋgərəgi haŋkalaakii, waatoo ŋwaŋwə ŋga ginaajinyinə, ci ca vii ka ci baawəɗa ŋga lyaakagi ginaajinyinə.” ");
INSERT INTO gde_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Wata Yeesu a 'wa tə tii aaɓiikii, ca waɓə ka tii də misaali, əŋki ci, “Iitiitə mbeenə *Seetanə ka lyaakagi naakii nə saŋa? ");
INSERT INTO gde_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Maɗa kə təkəgi ŋwaŋuunə rəŋwə bəra'i putə ŋga mabizhinə, pooshi ŋwaŋuunəkii ka ta'avənə. ");
INSERT INTO gde_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","Maɗa kə təkəgi yi rəŋwə bəra'i putə ŋga mabizhinə, pooshi yikii ka ta'avənə. ");
INSERT INTO gde_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Ha'ə əsə, maɗa kə təki ŋwaŋuunə ŋga Seetanə bəra'i, pooshi ŋwaŋuunəkii ka ta'avənə ca uudəgi. ");
INSERT INTO gde_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“Pooshi əndə ca dzəgərə aasii aa ha mandalə əndə, ca fə'yagi uushi'inaakii patə, maɗaamə ci kə anəgi mandalə əndəkii zəku'i, taabu'u fə'yaginəkii uushi'inə. ");
INSERT INTO gde_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“Tantanyinə cii kya ba koonə, taa ŋgutə tsarə ŋga 'waslyakəənə patə ɗii ənda, taa bərapaanə bərapaa ci tə Əntaŋfə əsə, ka tifyaginə nə Əntaŋfə ka ci 'waslyakəənaakii. ");
INSERT INTO gde_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","Amma taa wu patə ca bərapaa tə Malaaɓa Ma'yanə, pooshi Əntaŋfə ka tifyagi ka ci 'waslyakəənaakii, ka ndzaanə nə 'waslyakəənaakii anəkii ka ca'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ma waɓi Yeesu ha'ə makə ətsa, acii pə'i ənji tə ci oo'i, “Tə'i ginaaji ashikii.” ");
INSERT INTO gde_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Wata i məci Yeesu da ndzəkəŋushi'inəkii a mbu'u aahatə aasii, təya kəŋaanə a uura mayi, təya sləkee ka 'wanə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Laŋə dərəva nə ənji dasə dasə aɓiikii. Wata əŋki tii ka ci, “Watiitsə i muu tii da ndzəkəŋushi'inəku agyə ka 'wanə tə hə.” ");
INSERT INTO gde_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Makə fii ci ha'ə, wata ca jikə ka tii, əŋki ci, “I wu saŋə nə i yaayi da ndzəkəŋushi'inəkya?” ");
INSERT INTO gde_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Ca tsaamə tə ənjitə aɓiikii, əŋki ci, “Watiinə i yaayi da ndzəkəŋushi'inəki. ");
INSERT INTO gde_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Taɗa wu patə ca slənətə sətə ci Əntaŋfə a moo, ci nə ndzəkəŋunəki, da cikəŋunəki da yaayi.” ");
INSERT INTO gde_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Ma daba'əkii, kə ənyi Yeesu ka dzəgunənə ka ənji ama uunəvə ŋga Galili. Ma saa'ikii, kə dzii ənji də nə laŋə aɓiikii. Wata ca ndərəvə aasəkə kumbawalə, ca ndzaanə. Ma daŋkana natii, təya kəŋaanə anə ndəra. ");
INSERT INTO gde_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Kə slənyi ci də misaalinyinə ka dzəgunə ka tii uushi'inə laŋə. Kə waɓi ci ka tii, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Fatəmə kaa nya ba koonə. Tə'i əndə gi aasəkə rə ka giirə slikərənə. ");
INSERT INTO gde_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","Ma ca giirə slikərənəkii, tə'i harakii kwaalii ahada rəgwa, əginyinə a shi, təya ɗəmətə. ");
INSERT INTO gde_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","Harakii a kwaala ama pasla hatə ɗii hanyinə gi'u anəkii. Slikərənəkii a givagi pii pii acii wata lyavərəvərə nə hanyinə anə faara. ");
INSERT INTO gde_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","Makə cifə uusəra, wata magiva slikərənəkii a naa'ugi saakii acii pooshi slərəginəkii tahu tahu bahə sha ma'inə, ca huurəgi saakii. ");
INSERT INTO gde_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Hara slikərənəkii a kwaala aagi dəha. Makə giva slikərənəkii, dəhəkii a pa'əənə ka ci, pooshi rəgwa ŋga gərənə. Də ha'ə ɗii, paa ci əji hi'wa. ");
INSERT INTO gde_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","Amma, ma hara slikərənəkii, kə kwaalii tii anə ŋunyi hanyinə, kə gyaavagi tii, təya gərə dagwakii, təya vii ŋunyi cifanə. Harakii makkə pu'unə makkə pu'unə, harakii kuwa pu'unə kuwa pu'unə, harakii əsə, gya'ə gya'ə.” ");
INSERT INTO gde_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Yeesu a uudəpaa, əŋki ci, “Ma əndətə da liminə ŋga fanə, wa ca fa.” ");
INSERT INTO gde_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Makə ənəgi Yeesu daanəkii, wata hara ənji tii da lyawarənaakii pu'u aji bəra'i a shi aaɓiikii, təya ləgwa amakii kaa ca paaratəgi ka tii də misaalinyiita. ");
INSERT INTO gde_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Yeesu a ba ka tii, əŋki ci, “Ma una, koonə vii Əntaŋfə rəgwa ŋga shii ma'umbee uushi ŋga ŋwaŋuunaakii. Amma ma hara ənja, see maa ɗii ənji ka tii misaalinyinə, ");
INSERT INTO gde_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","kaa təya tsaamə də ginə, amma paa tii ka neenə; kaa təya kapaa liminətii ka fanə əsə, amma paa tii ka paaratəginə. Acii maci maɗamətii ha'ə, kaɗa kə zhi'wagi tii aaɓii Əntaŋfə, ca tifyagi ka tii 'waslyakəənatii.” ");
INSERT INTO gde_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Wata ca ləgwa amatii, əŋki ci, “Pooshi unə paaratəgi də misaalitsə kuna? Aa iitiitə daa nuuna paaratəgi də hara misaalinyina? ");
INSERT INTO gde_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Ma əndə giirə slikərəətsa, waɓənə ŋga Əntaŋfə cii kəya giirə. ");
INSERT INTO gde_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Ma slikərəətə kwaalii ahada rəgwa, tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə. Makə fii tii, wata *Seetanə a shi pii pii, ca ɗəməgi waɓəətə giirə ənji a ədzəmətii. ");
INSERT INTO gde_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Ma hara ənji əsə, makə slikərəətə kwaalii ama pasla nə tii. Makə fii tii waɓənə ŋga Əntaŋfə, pii pii luuvə tii də mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","Amma pooshi waɓənəkii əji slərəginə a ədzəmətii bahə sə'watə uushi'inə ŋga uundzə saa'i. Acii ha'ə, maɗa kə lii ŋgəra'wə da ciɓə tə tii putə ŋga waɓənə ŋga Əntaŋfə, pii wata təya bwasee. ");
INSERT INTO gde_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","Ma hara ənji əsə, makə slikərəətə kwaalii aagi dəhə nə tii. Tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə, ");
INSERT INTO gde_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amma putə ŋga buurə uushi'inə ŋga *duuniya, da uuɗə gəna, da hara suuna kama kama, kə saawagi waɓənəkii a ədzəmətii, pooshi nafakii. ");
INSERT INTO gde_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Ma hara ənji əsə, makə slikərəətə kwaalii anə ŋunyi hanyinə nə tii. Təya fa waɓənə ŋga Əntaŋfə, təya luuvə, təya ndzaanə makə slikərəətə ca vii ŋunyi cifanə, harakii makkə pu'unə makkə pu'unə, harakii kuwa pu'unə kuwa pu'unə, harakii əsə, gya'ə gya'ə.” ");
INSERT INTO gde_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Əŋki Yeesu ka tii, “Ya saŋa, ka kiranə nə ənji garəkuwa ka dəsləginə də kəŋwə taa ka kagərənə aatsa ədərə kwa? Əntaa ka madzəgamə ha dzakəpaanə ənja? ");
INSERT INTO gde_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Taa mi patə ɗii ma'umbeekii, kadə na shigi aa babara. Taa mi patə mashiimə ənja, kadə na shigi aa babara əsə. ");
INSERT INTO gde_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Ma əndətə da liminə ŋga fanə, wa ca fa.” ");
INSERT INTO gde_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Əŋki ci ka tii əsə, “Kavəmə nuunə ŋga'ə ka paaratəgi də sətə cuuna fa. Acii taa mi patə cuuna kavə nuunə ka paaratəginə, ha'ə nə Əntaŋfə a tsakə paaratəginə koonə, ca palee ka noonə də laŋənə. ");
INSERT INTO gde_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Acii ma əndətə da i uushi aciikii, ka ci tsakənə ənji viinə. Amma ma əndətə ɗii naakii gi'u, taa gi'ukii maa, ka luuginə nə ənji aciikii.” ");
INSERT INTO gde_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Əŋki Yeesu əsə, “Ma *ŋwaŋuunə ŋga Əntaŋfə, kə ndzaa ci makə əndətə ca dzə, ca giirəgi slikərənə asəkə raakii, ");
INSERT INTO gde_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ca ənya aasii, ca baanə, ca maɗətə deerənə, ca ka uusəra ka gəranə, acii paa ci da baawəɗa ŋga dəvətənə taa gərətə slikərənəkii. Ha'ə givaginə slikərənəkii, ca gərəgi. Mashiimə ci taa iitiitə girə ci. ");
INSERT INTO gde_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Hanyinə tii da slikərənə ɗii slənatii, slikərənə a givagi, ca ɗa ba, ca gərə, ca pukə, ca əji hi'wa. ");
INSERT INTO gde_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Maɗa mbu'ya cifanə, ka dzənə nə slandakii ka əburənə, acii kə uugi nanə.” ");
INSERT INTO gde_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Əŋki Yeesu əsə, “Takwa a dzəgunətə nyi koonə ndzaanə ŋga ŋwaŋuunə ŋga Əntaŋfə, nya ɗa koonə misaali agyanəkii. ");
INSERT INTO gde_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Ma ŋwaŋuunə ŋga Əntaŋfə, kə ndzaa ci makə hi'u iza. Hi'ukii palee də ənshiɗəɗənə agi ənfuginə patə asəkə duuniya. ");
INSERT INTO gde_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Maɗa ləgii ənji, ca dəvə, ca gərə, ca ɗagi ka dandza ka shaŋə, ca kaala ciinə madiigərəkii, əginyinə a shi ka baladzanəkii, təya ɗa kuvə davə.” ");
INSERT INTO gde_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Də hara misaalinyinə laŋə makə ətsə jigunyi Yeesu ka ənji waɓənə ŋga Əntaŋfə. Kə jigunyi ci ka tii bahə makə sətə dəɓee təya paaratəgi. ");
INSERT INTO gde_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Waɓənə ŋga Yeesu patə ka tii, see də misaali. Amma makə ənəgi ci daanəkii da lyawarənaakii, kə paaratəgi ci ka tii ŋga'ə tə misaalinyiitə ɗaaɗii ci. ");
INSERT INTO gde_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Ma uusərakii dakədəwanə, əŋki Yeesu ka lyawarənaakii, “Taŋəgyaamə aataŋəgi uunəva.” ");
INSERT INTO gde_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Wata təya bwasee ka daŋkana davə, təya ndərəvə aaɓiikii aasəkə kumbawala, təya palə. Tə'i hara kumbawalənyinə davə əsə. ");
INSERT INTO gde_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Wata mandalə məɗə a ndzaŋə kyanə anə uunəva də ŋgeerənə, ma'inə a ndzaŋə dəgənə ashi kumbawala, ca na aasəkə kumbawala. ");
INSERT INTO gde_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Amma ma Yeesu, pərəɓə nə ci saakii ka ŋunyinə asəkə gazha-gazhanə ŋga kumbawalə, ca ɗəkəvə nəkii agyanə ha ŋga ka na. Wata lyawarənaakii a maɗee ka ci, əŋki tii, “Maləma, taa kə məəkyaamə, pooshi haalaaku kwa?” ");
INSERT INTO gde_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Wata Yeesu a vəɗəhə, ca la ŋguruunə ka məɗa, ca waɓə ka ma'inə, əŋki ci, “Ndzaawə kəɗa'ə.” Pii wata məɗətə a dədəkə, ma'inə a ndzaa kəɗa'ə əsə. ");
INSERT INTO gde_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Əŋki ci ka lyawarənaakii, “Acii mi ŋgwalyuunə ha'ə kwa? Dəŋə əndzə'i kunə pooshi unə vii ka nyi gooŋga?” ");
INSERT INTO gde_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Wata ŋgwalənə a kəsəgi tə tii ka shaŋə, təya waɓə ahadatii, əŋki tii, “Wu saŋə nə əndəna? Taa məɗə da uunəvə maa, agi fanə nə tii tə ci.” ");
INSERT INTO gde_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Wata i Yeesu a mbu'u aanə hanyinə ŋga Gyarəgasinə ataŋəgi uunəva. ");
INSERT INTO gde_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Jimagərənə ŋga Yeesu asəkə kumbawala, wata waatsə əndə ginaaja shigi ahada gu'u ənja, ca shi aaɓiikii. ");
INSERT INTO gde_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Ma əndətsa, ahada gu'u ənji ndzaanəkii. Pooshi əndə mbee ka gwaləpaanə tə ci ma'ə, taa də mahyakahyaka'a. ");
INSERT INTO gde_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Taa guci anyi ənji tə ci ka ciinəkii da i ka səɗəkii də mahyakahyaka'a, ha'ə nə ci ka ŋgəəsləginə, pooshi əndə mbee ka kəsəpaanə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Vəɗə da uusəra, ahada gu'u ənji da i anə giŋunyinə ndzaanəkii ka kaala vurənə da i ka ŋgəəndzə shishinəkii də faariinə. ");
INSERT INTO gde_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Makə nee əndə ginaajitə ka Yeesu ci ma'a dzaɗə, ca huyipaa, ca gərə'upaa akəŋwaciikii. ");
INSERT INTO gde_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","Ca ŋgəree ka uuraakii də ŋgeerənə, əŋki ci, “Yeesu, Uuzənə ŋga Əntaŋfə Əndə məghərəvənə, mi cii kwa alə ashiki kwa? Kə kədii nyi aciiku akəŋwacii Əntaŋfə, unee ka nyi. Ga ha ciɓə də nyi.” ");
INSERT INTO gde_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","Ma bii ci ha'ə ka Yeesu, acii bii Yeesu ka ginaajita, “Shigi ashi əndətsa, ginaajina.” ");
INSERT INTO gde_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Wata Yeesu a ləgwa amakii, “Iitə nə ləməkwa?” Əŋki əndə ginaajita “Ma ləməkya, Ɓəzəkii, acii laŋə niinə.” ");
INSERT INTO gde_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Wata ca dza ciinə ka Yeesu, əŋki ci, “Tuutəta'ə, ga ha səbagi tə ginaajinyiinə ashiki anə hanyiina.” ");
INSERT INTO gde_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Ma dava, tə'i gəranə ŋga dagəliinə ca alə zəmatii ashi ɗaŋgəra. ");
INSERT INTO gde_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","Wata ginaajinyiitə a kədii acii Yeesu, əŋki tii, “Kapaa tiinə keena dzəgərə aashi dagəliitsa.” ");
INSERT INTO gde_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Kə luuvə Yeesu ka tii. Wata ginaajinyiitə a shigi ashi əndəta, təya palə, təya dzəgərə aashi dagəliita. Ma dagəliita, ka ɗanə nə laŋənatii dəbu'u bəra'i. Wata təya hwayagərə, təya kwaalagərə patə aagi ma'inə, təya zagi dza'ə. ");
INSERT INTO gde_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Wata magəriinə a huyi, təya kərə makii aasəkə vəranə da anə hanyinəkii patə. Wata ənjə a shi ka tsaamə sətə ɗii. ");
INSERT INTO gde_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Makə mbu'i tii aaɓii Yeesu, ma təya nee, waatsə əndətə sha nji da i ginaajinyinə anəkii. Dasə nə ci da i kəjeerənə ashikii. Kə ənya haŋkalaakii. Makə nee ənjitə shi ha'a, wata təya ŋgwaləgi. ");
INSERT INTO gde_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Ma ənjitə nee də ginətii ka sətə ɗii Yeesu, wata təya ba ka ənjitə shi daba'ə tə sətə ɗii tə əndə ginaajita, da i sətə ɗii tə dagəliinə. ");
INSERT INTO gde_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Wata təya gwaŋə ka kədiinə acii Yeesu kaa ca dzəgi ka tii anə hanyinatii. ");
INSERT INTO gde_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ma ətsə Yeesu a ndərəvə aasəkə kumbawala, wata əndətə sha nji da i ginaajinyiitə anəkii a kədii aciikii kaa ca dzə atsakii. ");
INSERT INTO gde_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Amma pooshi Yeesu luuvə ka ci. Əŋki ci ka ci, “Ənuu saaku aasii, ha ba ka ənji goonə tə patənə ŋga sətə ɗii Slandanəku ka putaaku, da makə sətə nee ci ka təgunuunaaku.” ");
INSERT INTO gde_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Wata əndətə a palə də baabanə anə hanyinə ŋga Dikapooli tə sətə ɗii Yeesu ka putaakii. Patənə ŋga ənjitə fii əsə, kə ɗii ka tii ka sə ŋga hurəshishinə. ");
INSERT INTO gde_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Makə ənyi Yeesu ka taŋəginə aataŋəgi asəkə kumbawala, kə shi daŋkana aaɓiikii gatə aama uunəva. ");
INSERT INTO gde_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Tə'i əndə'i əndə ətə ɗii ləməkii Jayirusə. Ma ca, gawə nə ci asəkə *kuvə də'wa. Makə nee ci ka Yeesu, wata ca dzə, ca gərə'waanə akəŋwaciikii. ");
INSERT INTO gde_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","Ca dza ka ci ciinə, əŋki ci, “Tə'i uuzənaaki, gwakə nə ki, də ma də ma nə ki. Tuutəta'ə, nda duu ka kavə ciinəku agyanətə, kaa kya mbəɗə.” ");
INSERT INTO gde_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Wata Yeesu a maɗətə tii da Jayirusə ka dzənə aa hakii. Ənjə a dzə laŋə atsatii də dzaadzashinə. ");
INSERT INTO gde_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Tə'i əndə'i minə ciɓee bwanea ka ki. Fəzə pu'u aji bəra'i nə ki ka uushi'inə. ");
INSERT INTO gde_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Kə ciɓə ki laŋə acii ənji kuzhikinə. Kə zagi ki də gənatə patə əsə kaa kya mbəɗə, amma pooshi ki mbə'i. See tsakənə nə ɓərəhənə aakəŋwa aakəŋwa. ");
INSERT INTO gde_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","Makə fii ki habara ŋga Yeesu, wata kya əntsahətə daba'əkii ahada daŋkana, kya təɓətə kəjeerənaakii. ");
INSERT INTO gde_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","Kya dzə də hiimanə tuu'inə, “Maɗa kə təɓətə nyi taa wata kəjeerənaakii, ka mbəɗənə nə nyi.” ");
INSERT INTO gde_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Ureenatə ka kəjeerənaakii, wata uushi'iitə a ifəgi mbya'ə ashitə. Kə fii ki ashitə oo'ya, kə mbə'i ki acii ɓərəhəətə nja ɗa tə ki. ");
INSERT INTO gde_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Pii kə shii Yeesu oo'i, tə'i baawəɗa shigi ashikii, wata ca zə'ugi agi ənja. Əŋki ci, “Wu daa uree ka kəjeerənaakya?” ");
INSERT INTO gde_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Əŋki lyawarənaakii ka ci, “Kə nee hə laŋə dzii ənji də nə anəku. Ka mi cii kwa ləgwa əndətə uree ka ha?” ");
INSERT INTO gde_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Amma wata Yeesu a zə'ugi ka tsaamə əndətə ɗii ha'ə. ");
INSERT INTO gde_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Ma miita, kə shii ki sətə ɗii tə ki. Wata kya shi aaɓii Yeesu də ŋgwalənə. Shishinətə a dzə də udzənə. Kya gərə'waanə akəŋwaciikii. Kya ba ka ci gooŋga ŋga sətə ɗii. ");
INSERT INTO gde_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Əŋki ci ka ki, “Uuzənaakya, kə mbə'i hə putə ŋga gi'inaaku tə nyi. Duu agi jamənə. Ka ndzaanə nə hə jamə.” ");
INSERT INTO gde_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Ma Yeesu ma'ə agi waɓənə, wata hara ənjə a shi asii a ha Jayirusə, əŋki tii ka ci, “Kə uudee uuzəətə ka na. Ka mi cii kwa ənvutə tə maləmə ma'a?” ");
INSERT INTO gde_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Amma pooshi Yeesu kavə nəkii ka sətə bii tii. Wata əŋki ci ka Jayirusə, “Ga ha ŋgwalə, vii gooŋga ka Əntaŋfə kə uugi.” ");
INSERT INTO gde_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Ma təya dzə də palənə, paa ci luuvə kaa hara ənjə a nə'u tə ci maɗaamə i Piita, da Yakubu, da Yoohana ndzəkəŋuci Yakubu. ");
INSERT INTO gde_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Makə mbu'i tii aasii aa ha Jayirusə, ma Yeesu a nee, wiitsə ənji ka kaala vurənə, təya tuu, təya ŋgəərə ma. ");
INSERT INTO gde_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Wata ca dzəgərə aasii, əŋki ci, “Ka mi cuuna wazə ha'ə kwa? Ka mi cuuna tuwa? Ma uuzəətsa, əntaa əntənə əŋki ki, amma ŋunyinə cifə ki.” ");
INSERT INTO gde_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Wata təya ŋusəgi tə ci. Yeesu a səbagi tə tii patə aa uura mayi, ca 'wa tə i dii da məci uuzəətə ba'a ənjitə gi atsakii, təya dəməgərə aaɓii mantə uuzəəta. ");
INSERT INTO gde_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ca kəsətə tə uuzəətə ka ciinə, əŋki ci ka ki də uuratii, “Talita kumi,” makə banə, “Uncitə mina, maɗətə bii nyi ka hə.” ");
INSERT INTO gde_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Wata hatsə kya maɗətə, kya wiigi'i gatə. Ma uuzəətsa, pu'u aji bəra'i nə fəzatə. Makə ɗii sətsə ha'a, wata kə ɗii ka ənji ka sə ŋga hurəshishinə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Yeesu a ɗa ka tii bariya, əŋki ci, “Goona ba habarakii shaŋə ka ənda.” Ca ba ka tii, wa təya vii ka ki zəma. ");
INSERT INTO gde_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Ma daba'əkii, wata Yeesu a maɗə gatə, ca palə aa hakii aa vəra, hatə girə ci davə. Lyawarənaakii a dzə atsakii. ");
INSERT INTO gde_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Makə mbu'ya *uusəra ŋga əpisəka, Yeesu a dzə aasəkə *kuvə də'wa ka dzəgunənə ka ənja. Makə fii ənji dzəgunənaakii, kə ɗii ka ənji laŋə ka sə ŋga hurəshishinə, əŋki tii, “Da saŋə upaa əndətsə shiinə ha'a? Wu dzəgunətə ka ca? Iitiitə mbee ci ka ɗa sə ŋga hurəshishinə ha'ə kwa? ");
INSERT INTO gde_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Əntaa əndə gwaa'a ənfuginə nə ca? Əntaa Mariyaama nə məca? Əntaa i Yakubu da Yoosi da Yahuda da Simoonə nə ndzəkəŋushi'inəkəya? Əntaa ganə ahadaamə nə cikəŋushi'inəkəya?” Wata təya kaaree ka ci. ");
INSERT INTO gde_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Yeesu a ba ka tii, “Ma *anabi, taa ka ŋgutə vəranə gi ci patə, ka upaanə nə ci məghərəvənə. Amma ma gakii də vəra, da ahada duuraakii da ənji yaakii, paa ci ka upaa məghərəvənə.” ");
INSERT INTO gde_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ci ɗii ma dava, pooshi Yeesu upaa rəgwa ŋga ɗa sə ŋga hurəshishinə laŋə. Wata ənji ɓərəhənə gi'u tanə kaalavə ci ciinə aanətii, ca mbəɗəpaa də tii. ");
INSERT INTO gde_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Kə ɗii ka Yeesu ka sə ŋga hurəshishinə ka shaŋə nə ghatə vii gooŋgatii ka ci. Ma daba'əkii, Yeesu a maɗə, ca palə ka vəranyiitə kədəhə kədəhə. Ca dzə də dzəgunənə ka ənja. ");
INSERT INTO gde_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Wata ca 'waa'watə tə lyawarənaakii pu'u aji bəra'i aaɓiikii kaa ca sləkee ka tii bəra'i bəra'i. Ca vii ka tii baawəɗa ŋga lyaakagi də ginaajinyinə. ");
INSERT INTO gde_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Ca ɗa ka tii bariya, əŋki ci, “Goona ŋgərə taa mi ka dzəginə, taa zəma, taa mbuura, taa kwaɓa a lipoonə. Ŋgərəmə zala kə uugi. ");
INSERT INTO gde_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ŋgamə ɓiɓinə, amma goona ŋgərəənə əndə'i kəjeerənə.” ");
INSERT INTO gde_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Əŋki ci əsə, “Maa kə gyuunə aasəkə əndə'i vəranə, ndzaamə ga ənjitə liwu tuunə aahatii aasii, dəŋə ka saa'itə nuunə maɗə gatə. ");
INSERT INTO gde_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Maɗa kə gyuunə ka hatə pooshi ənji liwu tuunə, təya təkuree ka fa waɓənə goonə, gwa'agimə bərəbərə ŋga vəraatsə asəɗuunə, una dzə sə goonə. Ci na ɓaarii ka tii oo'i, maɗamə tii ŋga'ə.” ");
INSERT INTO gde_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Wata lyawarənaakii a maɗə, təya palə, təya dzə də waazanə, əŋki tii: wa ənjə a baanə ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Təya dzə də lyaakagi ginaajinyinə laŋə ashi ənja. Təya naahəvə maarə anə ənji ɓərəhənə laŋə, ənjə a upaa mbəɗənə. ");
INSERT INTO gde_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Kə fii ŋwaŋwə *Hirudusə habara ŋga Yeesu, makə ɗii ci kə uugi ənji fa ləmə ŋga Yeesu taa dama patə. Uu'i hara ənja, “Ma Yeesu, ci nə Yoohana əndə ɗa bapətisəma. Kə ma'i ci agi maməətə ənja. Ci nee unə upaa ci baawəɗa ŋga ɗaaɗa sə ŋga hurəshishinə ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Hara ənjə a ba, “Ci nə anabi *Iliya.” Uu'i hara ənji əsa, “Anabi nə ci makə anabinyiitə nji ŋga ŋukə.” ");
INSERT INTO gde_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Makə fii ŋwaŋwə Hirudusə ha'a, əŋki ci, “Ma əndətsa, ci nə Yoohana əndə ɗa bapətisəma. Kə shi nya lagi nəkii, amma waatsə kə ənyagi.” ");
INSERT INTO gde_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","Ma bii ci ha'ə, acii kə shi ca bii ka ənjə a kəsə tə Yoohana, ənjə a anəgi, ənjə a pa'əgi a furəshina. Ma ɗii ci ha'ə, putə ŋga Hiroodiya, minə ŋga ndzəkəŋuci, waatoo Filibusə. Ma miita, kə ŋgərəma Hirudusə tə ki kaa kya ndzaa ka minaakii. ");
INSERT INTO gde_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","Amma kə bii Yoohana ka ci oo'i, “Madəɓeemə ha ŋgərə minə ŋga ndzəkəŋu ci ma'ə ka əpinə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Acii ha'ə pooshi Hiroodiya ka moo neenə ka Yoohana. Ŋga'ə də ki nə sətə ca ɓələgi tə ci. Amma pooshi rəgwa. ");
INSERT INTO gde_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Acii ma Hirudusə, kə shii ci əndə gooŋga nə Yoohana, malaaɓakii nə ci. Ci ɗii cii kəya ŋgwalə, paa ci ka moo sətə ca təɓətə tə Yoohana. Taa guci patə cii kəya fa waɓənə ama Yoohana, wata ədzəməkii a ləɗə ka shaŋə. Patə da ha'a, ŋga'ə ka ci nə fa waɓənaakii. ");
INSERT INTO gde_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Amma ma ka əndə'i saa'ya, kə upaa Hiroodiya rəgwa ŋga ɓələnə tə Yoohana. Waatoo makə mbu'ya kumənə ŋga uusəratə pwayi ənji tə Hirudusə, ca ɗa əndzanə ŋga kumənəkii. Ca 'wa tə meemiitə atsakii, da gayi soojiinaakii, da madiigərə ənjitə anə hanyinə ŋga Galili patə. ");
INSERT INTO gde_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Makə ndzaa tii, uuzənə ŋga Hiroodiya uncitə minəkii a dəməgərə, kya udzə. Kə ɗii ŋga'ə ka Hirudusə tii da ənjitə davə patə. Wata əŋki Hirudusə ka ki, “Mi cii kwa uuɗə kaa nya vii ka ha? Ka viinə nə nyi ka hə sətə cii kwa uuɗə patə.” ");
INSERT INTO gde_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Ca jiɗə ka ki, əŋki ci, “Ka viinə nə nyi ka hə taa mi bii hə patə, taa reeta ŋga ŋwaŋuunaaki.” ");
INSERT INTO gde_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Wata uncitə miitə a dzə aaɓii məci. Kya ləgwa amatə, əŋki ki, “Mi kədiinəkya?” Məci a ba ka ki, “Nə ŋga Yoohana əndə ɗa bapətisəma kədiinəku.” ");
INSERT INTO gde_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Pii wata kya ənətə aaɓii ŋwaŋwa, kya ba ka ci, “Ŋga'ə ka nyi ha vii ka nyi nə ŋga Yoohana əndə ɗa bapətisəma əndzə'i asəkə kəŋwa.” ");
INSERT INTO gde_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Makə fii Hirudusə ha'ə, kə zhimə tə ci asəkəkii ka shaŋə. Amma makə ɗii ci kə ji'i ci akəŋwacii ənjitə davə patə, paa ci mwayi əɓipaa jiɗəkii. ");
INSERT INTO gde_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","Wata pii ca sləkee ka sooja kaa ca dzə aa furəshina ka lyagi nə ŋga Yoohana, ca kira ka ci. Soojatə a dzə, ca lyagi, ");
INSERT INTO gde_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ca kavə asəkə kəŋwa, ca kira ka uncitə miita. Wata kya luu, kya kərə ka məci. ");
INSERT INTO gde_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Makə fii lyawarənə ŋga Yoohana haalakii, wata təya shi, təya ŋgərə waakii, təya ŋgəɗəgi. ");
INSERT INTO gde_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Ma ənjitə sləkee Yeesu ka tii ka waazanə, kə ənya tii aaɓiikii, təya ba ka ci patənə ŋga sətə ɗii tii da sətə jigunyi tii ka ənja. ");
INSERT INTO gde_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Əŋki ci ka tii, “Dzaamə səgaamə ka ndzaanə amə daanaamə ka hatə pooshi əndə davə, koona əpisəka.” Ma bii ci ka tii ha'ə, acii ma hatə ɗii tii davə, agi shiishinə nə ənji laŋə aaɓiikii, taa rəgwa ŋga adə zəma, paa tii ka upaanə. ");
INSERT INTO gde_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Wata təya palə asəkə kumbawalə ka hatə pooshi əndə davə. ");
INSERT INTO gde_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ma təya palə, ənji laŋə nee ka tii. Kə shii ənji tə tii əsə. Wata ənjə a ma'ya asəkə vəranyinə patə. Təya huyi də səɗa. Ma taabu'u mbu'i Yeesu tii da lyawarənaakii, tii kə mbu'i ŋukə. ");
INSERT INTO gde_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Yeesu a jimagərə asəkə kumbawala. Makə nee ci ka daɓaala laŋə, kə nyihə ci təgunuunatii, acii makə bagiinə yadə magəra ndzaa tii. Wata ca ndzaŋə dzəgunə ka tii uushi'inə laŋə. ");
INSERT INTO gde_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ma ətsə kaa uusəra a kula, lyawarənə ŋga Yeesu a əntsahə aaɓiikii, əŋki tii ka ci, “Kə ɗii kədəwanə, wiinə agi bilinə naamə ganə. ");
INSERT INTO gde_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Bawə ka ənjitsa, wa təya dzə ka ɗərə zəmə ka natii nə ga ənjitsə kədəhə taa asəkə vəranə.” ");
INSERT INTO gde_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Amma əŋki Yeesu ka tii, “Unə nə vii ka tii zəma.” Əŋki tii ka ci: “Maɗamə inə kə gi ka ira buroodi ŋga kwaɓa gya'ə bəra'i, pooshi ka mbu'unə ka tii.” ");
INSERT INTO gde_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Yeesu a ləgwa ka tii, əŋki ci, “Moonə nə buroodi acii una? Dəmə ka tsaamətənə.” Makə tsaamətə tii, təya ba ka ci, “Tə'i buroodi tufə da hərəfinə bəra'i.” ");
INSERT INTO gde_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Wata Yeesu a ba ka tii, wa daɓaala a ndzaanə tsəɓukə tsəɓukə agyanə kuzəna. ");
INSERT INTO gde_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Wata ənjə a ndzaanə tsəɓukə tsəɓukə. Hara ənji gya'ə gya'ə, hara ənji tufə pu'unə tufə pu'unə. ");
INSERT INTO gde_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Yeesu a ŋgərə burooditə tufə da hərəfiitə bəra'i, ca maɗee ka ginəkii aadəgyə, ca kuyirii tə Əntaŋfə. Ca ɓaatsəpaa buroodita, ca vii ka lyawarənaakii kaa təya təəkəpaa ka ənja. Ca təəkəpaa ka tii hərəfiitə bəra'i əsə. ");
INSERT INTO gde_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","Ənji patə a zəmə, təya əburə. ");
INSERT INTO gde_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","Ma daba'əkii, lyawarənaakii a tsəəkətə burooditə da hərəfiitə mbəɗaanə, ɗəvə pu'u aji bəra'i. ");
INSERT INTO gde_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Ma ənjitə agi buroodita, dəbu'u tufə nə ŋguyirənə agitii. ");
INSERT INTO gde_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Pii ma daba'əkii, Yeesu a ba ka lyawarənaakii, wa təya ndərəvə aasəkə kumbawala, təya takəŋwa ka ci aa taŋəgi uunəva aasəkə vəranə ŋga Batəsayida, kaa ca ba ka daɓaala a palə satii. ");
INSERT INTO gde_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Ma ənji agi palənə satii, ca ndərə aa giŋwə ka ɗa də'wa. ");
INSERT INTO gde_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ma ətsə ha pətəpəta, dzaɗə ahada uunəvə nə kumbawalətə ɗii lyawarənaakii asəkəkii əsə. Ma ci naakii, ma'ə ci anə ndəra ci daanəkii. ");
INSERT INTO gde_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Wata ma ca nee, kə uugi gwazə kumbawalə ɗanə dzawə ka lyawarənaakii, acii ka rəgwatə ci təya dzə aa dəvə nə məɗə ka əgyanə də ŋgeerənə. Ma ətsə ha wurə wurə kaa ca pukə, Yeesu a shi aaɓiitii də wiinə anə ma'inə. Makə kaa ca ələgi aɓitii, ");
INSERT INTO gde_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","50","wata kə nee tii ka ci ca wii anə ma'inə. Ma nə tii ka nəhənə, ɓərəhinə ca shi. Makə nee tii ka ci, kə ŋgwali tii ka shaŋə, təya kaala vurənə. Pii pii wata Yeesu a ba ka tii, əŋki ci, “Baneemə ka mooɗəfuunə, nyi əna, goona ŋgwalə.” ");
INSERT INTO gde_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Ca ndərəvə aasəkə kumbawalə aaɓiitii. Wata məɗətə a dədəkə ha'ə. Kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Ma adəvənaakii ka ənji dəbu'u tufə, pooshi tii paaratəgi acii ndalə nə haŋkalatii. ");
INSERT INTO gde_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Makə taŋəgi tii, təya mbu'u aanə hanyinə ŋga Ginazarətə, təya anəpaa kumbawalə davə ama uunəva. ");
INSERT INTO gde_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Jimagərənatii asəkə kumbawalə ha'ə, wata pii ənji vəraatə a paaratəgi oo'i, Yeesu ətsa. ");
INSERT INTO gde_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","Təya gwaŋə ka huyinə ka kyaara maɓərəhə ənjatii taa dama patə anə hanyiita, təya kira tə tii ka ci asəkə ədzə baanatii, taa da patə fii tii nə ci davə. ");
INSERT INTO gde_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Taa dama patə gi ci, taa aasəkə uundzə vəranə, taa aasəkə maɗuunə vəranə, ha'ə nə ənji ka kira ka ci ənji bwanea, təya banee ka tii asəkə luuma, təya kədii aciikii taa wata kəjeerənaakii, wa ənji bwanea a təɓətə. Patənə ŋga ənjitə təɓətə, kə mbə'i tii. ");
INSERT INTO gde_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Ma *Farisanyinə da hara maliminə ŋga *Yahudiinə ətə shi də Urusaliima, kə dzii tii də nə aɓii Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Ma təya nee, watiitsə hara *lyawarənə ŋga Yeesu ka adənə yadə yiɓəgi ciinətii makə sətə bii alə'aada ŋga dzədzəshi'inətii. ");
INSERT INTO gde_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Acii ma Farisanyinə da Yahudiinə patə, agi nə'unə nə tii alə'aada ŋga dzədzəshi'inə, pooshi tii ka adə zəmə yadə yiɓəgi ciinətii. ");
INSERT INTO gde_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","Taa tii kə shi a luuma maa, pooshi tii ka adənə, see maɗa yiɓəgi tii ciinətii zəku'i. Tə'i əsə hara alə'aadanyinə laŋə ətə lii tii, ci təya nə'u, təya cakuɓə sə ŋga sa də uushi'inə, da uudiinə, da əbu ŋga əndzənə, da ha ŋga baanə makə ətə ɓaarii alə'aadatii. ");
INSERT INTO gde_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Makə nee Farisanyinə da maliminə ha'ə, wata təya ləgwa ama Yeesu, əŋki tii, “Acii mi saŋə pooshi lyawarənaaku ka nə'u alə'aada ŋga dzədzəshi'inaama? Wata adənə nə tii zəmə yadə yiɓəgi ciinə nii?” ");
INSERT INTO gde_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Əŋki Yeesu ka tii, “Asee gooŋga waɓi anabi Isaaya agyanuunə, unə ənə ca nə'u tə Əntaŋfə də mooɗəfə bəra'i. Kə nyaahə ci sətə bii Əntaŋfə oo'i: Ma ənjitsa, amatii ci təya haŋətə tə nyi, amma ma ədzəmətii, dzaɗə da nyi ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Zaɓə nə paslənatii tə nyi, acii ma alə'aadanyiitə ci təya dzəgunə ka ənja, banə ŋga əndə shiŋkinə, əntaa banaaki.” ");
INSERT INTO gde_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Yeesu a tsakə banə ka tii, əŋki ci, “Agi uneenə nuunə ka bariya ŋga Əntaŋfə, una nə'u alə'aadanyinə ŋga ənja. ");
INSERT INTO gde_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","“Ha'ə ɗii kə upaa unə dabara ŋga kaareenə ka bariya ŋga Əntaŋfə, koona nə'u alə'aadanyinə goonə. ");
INSERT INTO gde_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Kə bii Muusa: Ɗuunətə tə i duu da muu. Taa wu waɓi bwaya uushi aashi dii taa məci, wa ənjə a ɓələgi tə ci. ");
INSERT INTO gde_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Amma ma unə, agi dzəgunənə nuunə ka ənji oo'i, ma sətə dəɓee əndə a vii ka dii taa məci, maɗa bii ci ka tii, ma səna, ‘Koorəbanə’, makə banə: ŋga Əntaŋfə nə sətsa, ");
INSERT INTO gde_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ma bii əndətə ha'ə, kə luuvuunə kaa ca bwasee ka tsakənə tə dii da məci. ");
INSERT INTO gde_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Də ha'ə bwasee unə ka waɓənə ŋga Əntaŋfə, koona dzəgunə alə'aadanyinə goonə. Tə'i hara uushi'inə laŋə makə ətsə əsə cuuna ɗa.” ");
INSERT INTO gde_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Wata Yeesu a 'waa'watə daɓaala aaɓiikii, ca waɓə ka tii, əŋki ci: “Fatəmə, unə patə, una paaratəgi də sənə cii kya ba koonə. ");
INSERT INTO gde_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Pooshi səndə ca dzəgərə aasəkə əndə da makii bahə ajijinətə tə ci. Amma sətə ca shigi da makii ca ajijinətə tə ci.  ");
INSERT INTO gde_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Ma əndətə da liminə ŋga fanə, wa ca fa.” ");
INSERT INTO gde_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Makə dzəgi Yeesu agi ənja, ca dzəgərə aasii. Lyawarənaakii a ləgwa amakii taɗa mi ci misaalitsə a moo banə. ");
INSERT INTO gde_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Əŋki Yeesu ka tii, “Patə da i unə kunə, pooshi unə paaratəgi oo'i, ma sətə ca dzəgərə da ma ənda, əntaa ci ca ajijinətə tə ca? ");
INSERT INTO gde_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Acii maa kə zhimə əndə uushi, əntaa aa mooɗəfə nə ci ka dzənə, amma aa səkə nə ci ka dəmənə, ca gimagi.” (Waɓənə ŋga Yeesu ha'ə, ca ɓaarii oo'i, taa ŋgutə zəma, ŋga'ə ka adənə.) ");
INSERT INTO gde_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Uu'i Yeesu əsa, “Ma sətə ca shigi a mooɗəfə ənda, ci ca ajijinətə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Acii a mooɗəfə əndə ci bwaya uushi a shigi, ca kavə tə ci ka ɗa bwaya hiima, ca ɗa badawaanə, ca hərə, ca ɓələ ənda, ");
INSERT INTO gde_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ca aləhiinə, ca ɗa bwaya suuna, ca ɗa bwaya bwayaanə, ca gəəpə ənja, ca ɗa ajijinəənə, ca sərəhə, ca pəɗə ənda, ca ɗa usha'ushaanə, ca ɗa ɗəəkənə. ");
INSERT INTO gde_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Ma uushi'iitsə patə, a mooɗəfə əndə ca shigi, ca ajijinətə tə ənda.” ");
INSERT INTO gde_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Ma daba'əkii, wata Yeesu a maɗə, ca dzə aanə hanyinə ŋga Tiira. Ca dzəgərə aasii aaha əndə'i ənda. Pooshi ci ka uuɗənə ənjə a shii oo'ya, gatə nə ci. Amma patə da ha'ə pooshi umbi. ");
INSERT INTO gde_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Tə'i əndə'i minə, kə kəshi ginaaji tə uuzənatə uncitə minəkii. Makə fii ki habara ŋga Yeesu, pii wata kya shi, kya gərə'waanə akəŋwaciikii. ");
INSERT INTO gde_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ma kya, əntaa mitə Yahuda nə ki, amma mitə hanyinə ŋga Siroofinikiya. Wata kya kədii tə Yeesu kaa ca lyakagi ka uuzənatə ginaajita. ");
INSERT INTO gde_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Əŋki Yeesu ka ki, “Taku ka manjeevənə a əburə zəku'i. Pooshi ŋga'ə nə ŋgərətə zəmə ŋga manjeevənə, ənjə a kagi ka ədiinə.” ");
INSERT INTO gde_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Əŋki miita, “Ha'ə tanyi, 'ya'ə Daadə, amma taa ədiinə əsə, agi adənə nə tii murəmurinə ŋga zəmətə ca kwaalagi acii manjeevənə.” ");
INSERT INTO gde_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Yeesu a ba ka ki, “Putə ŋga waɓəətsaaku, duu saaku aasii. Kə dzəgi ginaaji ashi uuzənaaku.” ");
INSERT INTO gde_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Wata miitə a ənə satə aasii. Ma kya dzə aasii, pərəɓə nə uuzənatə. Kə dzəgi ginaajitə ashitə. ");
INSERT INTO gde_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Yeesu maɗə anə hanyinə ŋga Tiira, ca dzə danə hanyinə ŋga Sidoonə, da ŋga Dikapooli, ca mbu'u aama uunəvə ŋga Galili. ");
INSERT INTO gde_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Wata ənjə a kira ka ci kadəguləma, paa ci ka mbee ka nyagi waɓənə ŋga'ə əsə. Təya kədii tə Yeesu kaa ca kavə ciinə aanə kadəguləməta, kaa ca mbəɗə. ");
INSERT INTO gde_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Yeesu a kəshagi tə ci aataŋgala, ca ŋgavə moojiciinəkii aa limə kadəguləməta, ca tifə giirənə aaciikii, ca uree ka gana ŋga əndəta, ");
INSERT INTO gde_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ca tsaamə aa dəgyə, ca ŋgi'i, əŋki ci də uura *Yahudiinə, “Eefata,” makə bana, “Wunəgi.” ");
INSERT INTO gde_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Pii wata liminə ŋga əndətə a wunəgi, ganakii əsə a pityapaa. Ca ndzaŋə nyagi waɓənə ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Yeesu a ɗa bariya ka ənja, ga təya ba ka əndə sətə ɗii. Amma ma ca tsakə ɗa bariya ka tii, ha'ə nə tii ka tsakə baaba waɓənəkii. ");
INSERT INTO gde_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ma ənjitə fii patə, kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə, əŋki tii, “Yawaa, ma sətsə ɗii ci patə, ŋga'ə. Taa tə kadəguləminə, ka kavənə nə ci ka fanə, təya waɓə.” ");
INSERT INTO gde_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Ma daba'ə baanə gi'u, kə ənyi daɓaala ka dza də nə aɓii Yeesu. Pooshi sə ŋga zəmə aciitii əsə. Yeesu a 'waa'watə tə lyawarənaakii aaɓiikii, əŋki ci ka tii, ");
INSERT INTO gde_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Agi nəhənə nə nyi təgunuunə ŋga ənjitsa, acii baanə makkə nə tii ənshinə aɓiiki, pooshi tii da sə ŋga kavənə aa matii. ");
INSERT INTO gde_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Maɗa kə kapaa nyi tə tii, təya dzə satii də maɗəfənə, ka mbeenə nə maɗəfənəkii ka tii a rəgwa, acii dzaɗə shi hara ənji.” ");
INSERT INTO gde_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Əŋki lyawarənaakii, “Iitə saŋə ɗanaamə kaama upaa zəmə ganə agi bilinə bahə zəməvənə ka ənjitsa?” ");
INSERT INTO gde_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Yeesu a ləgwa amatii, “Buroodi moonə nəndə acii una?” Əŋki tii ka ci, “Buroodi məɗəfə.” ");
INSERT INTO gde_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Wata Yeesu a ba ka daɓaala, kaa təya ndzaanə patə, ca ŋgərə burooditə məɗəfə, ca kuyirii tə Əntaŋfə, ca ɓaatsəpaa, ca vii ka lyawarənaakii kaa təya təəkəpaa ka ənja. Wata təya təəkəpaa. ");
INSERT INTO gde_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Tə'i əsə uuji hərəfinə gi'u aciitii. Ca ŋgərə, ca kuyirii tə Əntaŋfə, ca vii ka lyawarənaakii. Təya təəkəpaa ka ənji əsə. ");
INSERT INTO gde_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ənjitə gatə patə a zəmə, təya əburə. Wata lyawarənaakii a tsəəkətə zəmətə mbəɗaanə, ɗəvə məɗəfə. ");
INSERT INTO gde_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Ma ənjitə zhimə, ka ɗanə nə tii dəbu'u ənfwaɗə. Wata Yeesu a kapaa tə tii kaa təya palə satii. ");
INSERT INTO gde_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ma tii da lyawarənaakii əsə, pii wata təya ndərəvə aasəkə kumbawala, təya palə aanə hanyinə ŋga Daləmanuta. ");
INSERT INTO gde_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Ma daba'əkii, kə shi Farisanyinə, təya ndzaŋə ɗa ka Yeesu mabizhinə, təya ba ka ci, kaa ca ɗa ka tii sə ŋga hurəshishinə ətə ca ɓaarii oo'i, tə'i ci da baawəɗa ŋga Əntaŋfə. Ma ləguyi tii ha'ə, kaa təya shii təɓənə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Kə ŋgi'i Yeesu də ŋgeerənə, əŋki ci, “Ka mi saŋə ci ənji ŋga zamanana a alə sə ŋga hurəshishinə kaa ənjə a ɗa ka təya? Tantanyinə cii kya ba koonə, pooshi sə ŋga hurəshishinə ci ənjə a ɗa ka tii.” ");
INSERT INTO gde_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Wata Yeesu a unee ka tii. Ca ənə ka ndərəvənə aasəkə kumbawala, kaa ca taŋəgi aataŋəgi uunəva. ");
INSERT INTO gde_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Asee, kə zaanə ka *lyawarənə ŋga Yeesu nə ŋgərəənə buroodi. Wata rəŋwə dyaŋə nəndə aciitii asəkə kumbawala. ");
INSERT INTO gde_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","Yeesu a dzalə tə tii, əŋki ci, “Nəhəmə noonə na acii burəŋanə ŋga Farisanyinə da ŋga Hirudusə.” ");
INSERT INTO gde_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Makə fii tii ha'ə, təya gwaŋə ka waɓənə ahadatii, əŋki tii, “Ma bii ci ha'a, ətə pooshi amə ŋgiraanə buroodi.” ");
INSERT INTO gde_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Ma Yeesu, kə shii ci sətə ci təya ba. Wata əŋki ci ka tii, “Ya una, ka mi cuuna waɓə agyanə ghatə buroodya? Ca'ə əndzə'i, ma'ə unə mapaaratəgimə kuna? Kə ndaləgi haŋkala goonə kwa? ");
INSERT INTO gde_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Pooshi unə ka neenə də ginuunə kuna? Anii pooshi unə ka fanə də liminuuna? Pooshi unə ka buurətənə kwa? ");
INSERT INTO gde_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Saa'itə ŋgirə nyi buroodi tufə, nya ɓaatsəpaa, nya vii ka ənji dəbu'u tufə, ɗəvə moonə tsəəkətuunə tə ətə mbəɗaana?” Əŋki tii ka ci: “Ɗəvə ta'i ta'i pu'u aji bəra'i tsəəkətiinə.” ");
INSERT INTO gde_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Ca ənə ka ləgwanə ka tii, “Makə ɓaatsəpaa nyi buroodi məɗəfə ka ənji dəbu'u ənfwaɗə, ɗəvə moonə tsəəkətuunə tə ətə mbəɗaana?” Əŋki tii ka ci: “Ɗəvə ta'i ta'i məɗəfə.” ");
INSERT INTO gde_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Əŋki ci ka tii, “Amma ca'ə əndzə'i ma'ə unə mapaaratəgimə nii?” ");
INSERT INTO gde_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Wata təya mbu'u aasəkə vəranə ŋga Batəsayida. Ənjə a kira ka Yeesu muurəfa. Ənjə a kədii tə ci kaa ca kavə ciinə aashi muurəfəta, kaa ca upaa mbəɗənə. ");
INSERT INTO gde_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Wata Yeesu a kəsətə tə muurəfətə ka ciinə, təya dzəgi gatə də vəra. Dzəginatii, wata ca tifəvə giirənə aagi muurəfəta, ca kavə ciinə aanəkii. Əŋki ci ka ci, “Agi neenə nə hə ka uushi'inə nii?” ");
INSERT INTO gde_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Əndətə a tsaamə, əŋki ci, “Agi neenə nə nyi ka ənja. Amma makə ənfuginə cii kya nee, təya wiigi'i.” ");
INSERT INTO gde_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Yeesu a ənə ka kavə ciinəkii aagi əndəta. Əndətə a tsaamə ŋga'ə, wata kə mbə'i ci, ca nee ka ha paŋgəraŋə. ");
INSERT INTO gde_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","See Yeesu a ɗa bariya ka əndətə oo'ya, “Duu aasii. Ga ha ənə aasəkə vəranə.” ");
INSERT INTO gde_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Wata Yeesu tii da lyawarənaakii a maɗə ka dzənə aasəkə vəranyiitə anə hanyinə ŋga Kayisariya Filipi. Ma təya dzə a rəgwa, ca ləgwa ama lyawarənaakii, əŋki ci, “Wu saŋə nə nyi ci ənjə a ba?” ");
INSERT INTO gde_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","Əŋki lyawarənaakii, “Ma nə hara ənji ka bana, hə nə Yoohana əndə ɗa bapətisəma. Əŋki hara ənji, hə nə anabi Iliya. Hara ənjə a ba əsa, əndə'i anabi ŋga ŋukə nə hə.” ");
INSERT INTO gde_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Əŋki Yeesu, “Ya unə noona? Wu nə nyi cuuna ba?” Piita a jikəvə, əŋki ci, “Hə nə Mataɗəkii ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Wata Yeesu a ɗa ka tii bariya oo'i, “Goona ba waɓəətsə agyanəki taa ka wu.” ");
INSERT INTO gde_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Wata Yeesu a ndzaŋə dzəgunənə ka lyawarənaakii, ca waɓə agyanə naakii nə, əŋki ci, “Tyasə ma *Uuzənə ŋga ənda, see a sa ci ciɓənyinə laŋə. Kadə nə gayinə da madiigərə limanyinə da maliminə a kaaree ka ci, ənjə a ɓələgi tə ci. Ma ka makkənə ŋga uusəra, ka maɗənə nə ci agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Furəŋə bagi Yeesu ka tii ətsa. Makə fii Piita ha'a, wata ca kəsəgi tə ci aataŋgala, ca wazə ka ci. ");
INSERT INTO gde_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Amma Yeesu a zə'ugi, ca tsaamə tə lyawarənaakii. Ca wazə ka Piita, əŋki ci, “Dzəgi aɓiiki, *Seetanə! Ma hiimatsaaku, ŋga əndə shiŋkinə, əntaa ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Wata Yeesu a 'wa tə daɓaala da lyawarənaakii aaɓiikii. Əŋki ci ka tii, “Taa wu patə ca moo nə'unə tə nyi, tyasə see a kaaree ci ka naakii nə, ca ŋgərə ənfwə ŋga gwa'avənə tə ci aashikii, ca nə'u də nyi. ");
INSERT INTO gde_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Taɗa wu patə ca ɗa gazhi'waanə ŋga gərətə əpinaakii, ka əteenə nə ci ka əpinəkii. Amma taɗa wu patə ətee ka əpinaakii putə ŋga nə'unə tə nyi da putə ŋga Ŋunyi Habara, ci na luupaa əpinaakii. ");
INSERT INTO gde_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Mi saŋə nə bwatya ŋga upaa patənə ŋga uushi'inə asəkə duuniya, amma əndə ətee ka əpinaakəya? Pooshi bwatyakii. ");
INSERT INTO gde_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Maɗa kə zii əpinə ŋga ənda, pooshi uushi cii kəya vii kaa ca ənə ka upaa də əpinəkii. ");
INSERT INTO gde_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Ma agi ma'waslyakə zamanana ənə ci ənjə a kaaree ka Əntaŋfə, ma əndətə ɗii ayinə tə ci ka waɓənə agyanəki da agyanə waɓənaaki, ma nyi Uuzənə ŋga ənda, kadə nə ayinə a ɗa tə nyi ka waɓənə agyanə əndəta uusəratə nii kya shi agi məghərəvənə ŋga Daadə da ŋga malaaɓa malaa'ikanyinə.” ");
INSERT INTO gde_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Əŋki Yeesu ka tii əsa, “Tantanyinə cii kya ba koonə, tə'i hara ənji ganə ahadaamə na nee də ginətii, tii ma'ə maməətəmə, ka *ŋwaŋuunə ŋga Əntaŋfə da baawəɗaakii.” ");
INSERT INTO gde_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Ma daba'ə baanə kuwa, Yeesu a ŋgərə tə i Piita, da Yakubu da Yoohana, ca kərə tə tii aanə magərə giŋwa, wata tii ha'ə. Ma təya nee, wata ca zə'wə akəŋwaciitii, ");
INSERT INTO gde_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ɓərənə nə kəjeerənaakii tyaslyaslya. Pooshi əndə asəkə duuniya ca mbee ka kuɓəgi kəjeerənə nduuɗa ha'a makə əta. ");
INSERT INTO gde_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Wata ma təya nee, watiitsə i anabi *Iliya da Muusa, təya waɓəshi da Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Wata Piita a ba ka Yeesu, əŋki ci, “Maləma, ŋga'ə ɗii makə ganə niinə. Taku keena ratə koonə tsakabanyinə makkə, naaku rəŋwə, ŋga Muusa rəŋwə, ŋga Iliya rəŋwə.” ");
INSERT INTO gde_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Ma waɓi ci ha'ə, acii kə ŋgwaləgi tii ka shaŋə, paa ci shii sə ŋga banə. ");
INSERT INTO gde_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Wata məzhiɗəkwatyaminə a zaɗəgi dagyanətii. Ma təya fa, əndə a waɓya dagi məzhiɗəkwatyaminəkii, ca ba, “Waatsə Uuzənaaki, kə uu'i nyi tə ci. Ci ca uuɗagi səkəki. Famə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Ma i Piita tsaaməgi, maneemə tii taa ka wu aɓitii ma'ə maɗaamə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ma təya dzə də jimanə satii a giŋwa, Yeesu a ɗa ka tii bariya, əŋki ci, “Goona ba taa ka wu tə sətsə nee unə, see daba'ə maɗənaaki agi maməətə ənja, nyi *Uuzənə ŋga ənda.” ");
INSERT INTO gde_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Kə luuvə tii bariyatə ɗii ci ka tii. Amma ma ahadatii satii, kə laaguyi tii, əŋki tii, “Mi da nə maɗənə agi maməətə ənja?” ");
INSERT INTO gde_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Təya ba ka Yeesu, “Aa mi ɗii ci maliminə a ba oo'i, Iliya na takəŋwa shinə ka Aləmasiihu?” ");
INSERT INTO gde_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Yeesu a ba ka tii, “Weewee ha'ə makə ətsa, Iliya na shi zəku'i ka haɗatəgi də patənə ŋga uushi'inə. Əntaa tə'i manaahəkii asəkə ləkaləkatə ŋga Əntaŋfə oo'i, ka sanə nə Uuzənə ŋga əndə ciɓənyinə kama kama, ənjə a kaaree ka ci kwa? ");
INSERT INTO gde_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Amma wanyinə ka banə koonə, kə uugi Iliya shinə. Kə ɗii ənji ka ci sətə kaɗeesəkə ka tii patə, makə sətə ɗii manaahəkii agyanəkii asəkə ləkaləkatə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Mbu'unatii aaɓii hara *lyawarənə, wata təya lapaa kə ndzaanə daŋkana ka tii də na, maliminə a ɗa ka tii mabizhinə. ");
INSERT INTO gde_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Makə nee ənji patə ka Yeesu, kə ɗii ka tii ka sə ŋga hurəshishinə. Təya hwaya aaɓiikii, təya nəhəpaa tə ci. ");
INSERT INTO gde_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Yeesu a ləgwa ama lyawarənaakii, əŋki ci, “Anə mi nuunə ka ɗa mabizhina?” ");
INSERT INTO gde_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Wata əndə'i əndə ahada daŋkana a jikəvə, əŋki ci, “Maləma, kə kira nyi ka hə uuzənaaki, acii tə'i ginaaji anəkii. Pooshi ci ka mbee ka waɓənə. ");
INSERT INTO gde_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Taa guci patə, maa kə ma'i ginaaji anəkii, ginaajikii a uurəvə tə ci aa panə. Əbwyanə nə cikufinə amakii. Ca tsəɓə linyinə. Shishinəkii patə a huurəgi shindəŋə. Kə kədii nyi acii lyawarənaaku, kaa təya lyaakagi ginaajikii, amma kə təkuree tii.” ");
INSERT INTO gde_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Fanə ŋga Yeesu ha'ə, əŋki ci ka tii, “'Ya'əmə, unə ənji ŋga zamanana, pooshi unə gi'i tə Əntaŋfə. Ca'ə guci saŋə nii kya ndzaa doona? Ca'ə guci sə'watənəki tuuna? Kiramə ka nyi uuzənəkii ɗii.” ");
INSERT INTO gde_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Wata ənjə a kira uuzəətə ka ci. Makə nee ginaajitə ka Yeesu, wata ca dəgəpaa tə uuzəətə də ŋgeerənə. Uuzəətə a kula. Fuuɗənə nə ci a panə. Əbwyanə nə cikufinə amakii. ");
INSERT INTO gde_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Wata Yeesu a ləgwa ama dii uuzəəta, əŋki ci, “Guci saŋə ndzaŋətə ka ca?” Əŋki dii, “Ndzaŋə ka saa'itə ci ma'ə uundzəkii. ");
INSERT INTO gde_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Laŋə jikə ginaajitsə ka uuɗə ɓələginə tə ci də kaalagərənə tə ci aagi gunə da i aagi ma'inə. Nəhuu təgunuunə geenə. Tsakuu tiinə, maɗa ka mbeenə nə hə.” ");
INSERT INTO gde_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Əŋki Yeesu ka ci, “Maɗa ka mbeenə nə nyi, bii ha? Paa ha shii oo'i, ma əndətə gi'i tə Əntaŋfə, taa mi patə ka mbeenə nə ci ka ɗatənə kwa?” ");
INSERT INTO gde_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Pii wata dii uuzəətə a jikəvə də ŋgeerənə, əŋki ci, “Kə gi'i nyi tə Əntaŋfə. Tsakuu tə nyi kaa nya tsakə gi'inə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Makə nee Yeesu, wiitsə ənji ka ja də nə anətii də huyihuyi, ca wazə ka ginaaja, əŋki ci, “Ginaajinə kavə tə uuzəənə ka kadəguləməəna, wanyinə ka wazənə ka hə, shigi ashi uuzəəna. Ga ha ənya aashikii ma'a.” ");
INSERT INTO gde_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Wata ginaajitə a kapaa vurənə də ŋgeerənə, ca dəgə tə uuzəətə də ŋgwaaŋgwa'ənə, ca shigi ashikii. Wata lakə nə uuzəətə makə mantəkii. Ma nə ənji patə ka banə, “Mantəkii nə uuzəətsa.” ");
INSERT INTO gde_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Amma Yeesu a kəsətə tə uuzəətə ka ciinə, ca maɗee ka ci. ");
INSERT INTO gde_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Ma ətə dzəgərə Yeesu aasii, makə nee lyawarənaakii pooshi əndə aɓitii, təya ləgwa amakii, əŋki tii, “Mi saŋə ɗii təkuree inə ka lyaakagi tə ginaajitsa?” ");
INSERT INTO gde_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Yeesu a ba ka tii, “Pooshi taa mi ca lyaakagi tsarə ŋga ginaajitsa, see də də'wa kə uugi.” ");
INSERT INTO gde_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Makə ma'i tii gatə, təya palə danə hanyinə ŋga Galili. Ma Yeesu, paa ci mwayi ənjə a shii taa da nə ci, ");
INSERT INTO gde_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","acii agi dzəgunənə nə ci uushi'inə ka lyawarənaakii. Ca dzə də waɓənə ka tii agyanə naakii na, ca ba, “Ka vəginə nə ənji tə Uuzənə ŋga əndə aacii ənja, təya ɓələgi tə ci. Maa kə ɓələgi ənji tə ci, ma ka makkənə ŋga uusəra, ka maɗənə nə ci agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Amma, ma lyawarənaakii, paa tii paaratəgi də sətə cii kəya ba ka tii. Kə ŋgwaləgi tii əsə ka ləgwanə ka ci agyanəkii. ");
INSERT INTO gde_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Makə mbu'i tii aa Kafarənahumə, təya dzəgərə aasii. Yeesu a ləgwa ama lyawarənaakii, əŋki ci, “Agyanə mi saŋə njuuna ɗa mabizhinə una shi a rəgwa?” ");
INSERT INTO gde_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Amma pooshi tii jikə ka Yeesu, acii ma təya shi a rəgwa, kə ɗii tii mabizhinə ahadatii oo'i, “Wu saŋə palee də ɗuunuunə ahadaama?” ");
INSERT INTO gde_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Wata Yeesu a ndzaanə, ca 'wa tə tii patə pu'u aji bəra'i, əŋki ci ka tii, “Taa wu patə mwayi ndzaanə ka matakəŋwanə, wa ca ndzaa ka moodəba'a, wa ca ndzaa ka əndə slənənə ka ənji patə əsə.” ");
INSERT INTO gde_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Wata ca ŋgərə uuzənə, ca kəŋee ahadatii. Ca gapətə tə uuzəəta, əŋki ci ka lyawarənaakii, ");
INSERT INTO gde_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Taa wu liwə uuzənə, maɗa putaaki liwə ci, tə nyi liwə ci ətsa. Ma əndətə liwu tə nyi, əntaa wata tə nyi liwə ci, amma tə Əndətə sləkee ka nyi liwə ci.” ");
INSERT INTO gde_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Wata Yoohana a jikəvə ka Yeesu, əŋki ci, “Maləma, kə nee inə ka əndə ca lyaakagi ginaajinyinə də ləməku. Amma makə nee inə, paa ci ka maguŋuura deenə, kə təŋapaa inə tə ci.” ");
INSERT INTO gde_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Əŋki Yeesu ka ci, “Goona təŋapaa tə ci. Acii ma əndətə ca ɗa sə ŋga hurəshishinə də ləməki, pooshi ci ka waɓənə bwayakii agyanəki kwakwatə. ");
INSERT INTO gde_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Ma əndətə makaareemə kaamə, naamə nə ci. ");
INSERT INTO gde_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Tantanyinə cii kya ba koonə, ma əndətə ca gyacii koonə ma'inə ka sanə putə ŋga ətə ɗii unə ŋga Aləmasiihu, weewee ka upaanə nə ci shikwaakii.” ");
INSERT INTO gde_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“Taa wu patə kavə tə taa rəŋwə agi manjeeviitə vii ka nyi gooŋga kaa ca pu'u, gəɗə anəvə təŋwə aa uurakii ka ci də ŋga'əənə, ənjə a kagərə tə ci aagi uunəva, acii sətə na upaa tə ci. ");
INSERT INTO gde_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","“Maɗa ciinəku ca kavə tə hə ka ɗa 'waslyakəənə, lagi. Gəɗə gi hə ka upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə yadə ciinə acii dzənə da ciinəku bəra'i aagi gunə ətə pooshi ka əntənə.  ");
INSERT INTO gde_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Acii ma davə, pooshi kantəhuɗənyiitə ca adə tə ənji ka əntənə, pooshi gunə ka əntənə əsə. ");
INSERT INTO gde_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Maɗa səɗəku ca kavə tə hə ka ɗa 'waslyakəənə, lagi. Gəɗə gi hə ka upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə yadə səɗə acii ndzaanə da i səɗəku bəra'i, ənjə a ka tə hə aagi gunə.  ");
INSERT INTO gde_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ma davə, pooshi kantəhuɗənyiitə ca adə tə ənji ka əntənə, pooshi gunə ka əntənə əsə. ");
INSERT INTO gde_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Maɗa ginəku ca kavə tə hə ka ɗa 'waslyakəənə, hurə'yagi. Gəɗə gi hə aagi *ŋwaŋuunə ŋga Əntaŋfə də ginə rəŋwə acii ndzaanə da i ginəku kyakya'ə bəra'i, amma ənjə a ka tə hə aagi gunə. ");
INSERT INTO gde_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ma davə, pooshi kantəhuɗənyiitə ca adə tə ənji ka əntənə, pooshi gunə ka əntənə əsə. ");
INSERT INTO gde_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","“Də gunə nə Əntaŋfə a haɗatə də taa wu patə, makə ətə ci ənjə a haɗatə zəmə də zhatana. ");
INSERT INTO gde_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Ŋunyikii nə zhatana. Amma maɗa kə ləvəgi zhatanə saakii, pooshi ənji ka mbeenə ka ənətəginə njamə njamə ma'ə. Ndzaamə ka ənji makə zhatanə agi dzəguɗa. Ndzaashimə agi jamənə.” ");
INSERT INTO gde_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Ma daba'əkii, Yeesu a maɗə gatə, ca palə aanə hanyinə ŋga Yahudiya, ca taŋəgi gəərə ŋga Urədunə. Ənjə a ənə ka dza də nə aɓiikii. Ca ənə əsə ka dzəgunə ka tii waɓənə ŋga Əntaŋfə makə ətə sənaavə ci. ");
INSERT INTO gde_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Wata hara *Farisanyinə a shi aaɓiikii, təya alə rəgwa ŋga təkənə tə ci də ləgwanə amakii, əŋki tii, “Ya əna, kə vii bariya gaamə rəgwa ka əndə a lakəgi minaakii kwa?” ");
INSERT INTO gde_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Əŋki Yeesu ka tii, “Mi nə bariya ŋga Muusa ka banə koona?” ");
INSERT INTO gde_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Əŋki tii, “Kə kapaa Muusa rəgwa ka ŋgurə a naahə ləkaləkatə ŋga lakəgi minaakii, ca lakəgi tə ki.” ");
INSERT INTO gde_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Əŋki Yeesu, “Ma nyaahə Muusa bariyatsə ha'a, acii ndalənə ŋga ədzəmuunə. ");
INSERT INTO gde_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amma saa'itə tagii Əntaŋfə duuniya, ŋgurə da minə ghənyi ci tə ənja. ");
INSERT INTO gde_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","Ca ba: Putakii ha'ə, wa ŋgurə a bwasee ka dii da məci, ca ləɓə tii da minaakii, ");
INSERT INTO gde_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","təya ndzaa shishinə rəŋwə. Də ha'ə ndzaanə tii əndə rəŋwə, əntaa ənji bəra'i ma'ə. ");
INSERT INTO gde_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aciikii, ma sətə gəŋutəgi Əntaŋfə, ga əndə a təkee.” ");
INSERT INTO gde_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Makə ənəgərə tii aasii, wata *lyawarənə ŋga Yeesu a ləgwa amakii agyanə waɓəətsa. ");
INSERT INTO gde_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Əŋki Yeesu ka tii, “Taa wu patə lakəgi minaakii, ca ŋgərə əndə'i minə, kə ali ci hiinə ətsa, ca ɗa 'waslyakəənə ka təkəŋwatə minaakii. ");
INSERT INTO gde_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","Maɗa minə əsə dzəgi satə atsa ŋgurii, kya dzə ka ŋgərə əndə'i ŋgura, aləhiinə nə ki ka ɗanə.” ");
INSERT INTO gde_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Agi kiranə nə ənji manjeevənə ka Yeesu kaa ca ɗaanə ciinə ŋga barəkaanə aanətii. Amma, ma lyawarənaakii, kə laalii tii ŋguruunə ka ənja. ");
INSERT INTO gde_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Makə nee Yeesu ha'a, wata səkəkii a ɓəzəgi. Əŋki ci ka lyawarənaakii, “Uneemə ka manjeevənə kaa təya shi aaɓiiki, goona təŋa tə tii, acii ka tsarə ŋga ənji makə tii də *ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Tantanyinə cii kya ba koonə, ma əndətə pooshi luuvə ka Əntaŋfə a ndzaanə ka ŋwaŋwaakii makə sətə ci uuzənə a luuvə, pooshi ci ka upaa dəmənə aagi ŋwaŋuunə ŋga Əntaŋfə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Wata Yeesu a fəɗə manjeevənə aashikii, ca ŋgərə ciinəkii, ca ɗaanə ka tii barəkaanə. ");
INSERT INTO gde_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Ma ətsə Yeesu a maɗə kaa ca palə saakii, wata əndə'i əndə a shi də huyihuyi, ca gərə'waanə akəŋwaciikii, əŋki ci ka ci, “Maləma, ma hə kamə, ŋunyi əndə nə hə. Mi dəɓee ɗanəki kaa nya upaa əpinə ŋga ca'ə ndəŋwə ndəŋwa?” ");
INSERT INTO gde_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Əŋki Yeesu ka ci, “Ka mi cii kwa 'wa tə nyi ŋunyi ənda? Pooshi ŋunyi əndə maɗaamə Əntaŋfə ci rəŋwə dyaŋə. ");
INSERT INTO gde_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Kə shii hə bariya ŋga Əntaŋfə, waatoo, Ga ha ɓələ hiinə, ga ha alə hiinə, ga ha hərə hiinə, ga ha vii seeda ŋga jirakənə anə ənda, ga ha gəpətə uushi ŋga ənda, gaɗee ka i duu da muu.” ");
INSERT INTO gde_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Əŋki əndəta, “Ma ətsə patə, kə nə'utə nyi daga nyi ma'ə uuzənə.” ");
INSERT INTO gde_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Wata Yeesu a tsaamə tə ci, kə kaɗeesəkə əndəkii ka ci, əŋki ci ka ci, “Uushi rəŋwə mbəɗaanə ka hə ŋga ɗanə. Ma ɗanəkwa, duu ka ɗərəmaginə də uushi'inaaku, ha təkəpaa kwaɓakii ka maaghiinə. Maɗa kə ɗii hə ha'ə, ka ndzaanə nə shigaaku dagyə aɓii Əntaŋfə. Ma daba'əkii, ha shi ka nə'u tə nyi.” ");
INSERT INTO gde_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Makə fii əndətə ha'ə, wata ca geegi ka ginəkii təku təku, ca palə saakii də maɓətəsəka, acii laŋə dərəva nə gəna aciikii. ");
INSERT INTO gde_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Wata Yeesu a zə'ugi aaɓii lyawarənaakii, əŋki ci ka tii, “Dzawə dərəva nə dəmənə ŋga ənji gəna aagi ŋwaŋuunə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Kə ɗii ka lyawarənaakii ka sə ŋga hurəshishinə nə waɓənaakii. Yeesu a tsakə banə ka tii, əŋki ci “Manjeevənaakya, dzawə nə dzənə aagi ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Gəɗə dəməginə ŋga ŋgyalooba ka rəgwa shinə ŋga libəra də ŋgufənə, acii dəmənə ŋga əndə gəna aagi ŋwaŋuunə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Kə dzəgəpaa tə lyawarənaakii ka shaŋə, təya laagwa ahadatii, əŋki tii, “Maɗa ha'ə əna, aa wu ɗii nə upaa luupaana?” ");
INSERT INTO gde_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Yeesu a tsaamə tə tii, ca ba, “Ma əndə shiŋkinə, pooshi uushi cii kəya mbee ka ɗatənə ci saakii ka upaa də luupaanə. Amma, ma Əntaŋfə, ka ɗatənə nə ci taa mi, acii naakii nə baawəɗa patə.” ");
INSERT INTO gde_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Wata Piita a jikəvə ka ci, əŋki ci, “Yoo, waniinə kə bwasee inə ka uushi'inə patə əna, ina nə'u tə hə.” ");
INSERT INTO gde_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Əŋki Yeesu ka tii, “Tantanyinə cii kya ba koonə, taa wu patə bwasee ka yaakii, taa ndzəkəŋushi'inəkii, taa məci, taa dii, taa manjeevənaakii, taa raakii, maɗa ka putaaki bwasee ci da ka putə ŋga Ŋunyi Habara, ");
INSERT INTO gde_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ka upaanə nə ci yinyinə, i ndzəkəŋushi'inə, i manjeevənə, i mənənyinə, i rənyinə, gya'ə agi saa'ina, palee ka ətə bwasee ci aa ba'ə. Amma, ka ciɓeenə nə ənji ka ci. Ma daba'əkii, ka upaanə nə ci əpinə ŋga ca'ə ndəŋwə ndəŋwə agi zamanatə na shi. ");
INSERT INTO gde_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amma laŋə nə matakəŋwanyinə na ndzaanə ka moodəba'ənyinə. Laŋə nə moodəba'ənyinə əsə na ndzaanə ka matakəŋwanyinə.” ");
INSERT INTO gde_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Ma daba'əkii, Yeesu a maɗə tii da lyawarənaakii, kaa təya dzə aa Urusaliima. Ma təya palə a rəgwa, Yeesu a ta kəŋwanə ka tii. Amma, ma tii, pooshi tii ka mabanee ma'yanə. Ma ənjitə ca shi daba'ə əsa, kə ŋgwali tii. Yeesu a ənə ka 'waginə tə lyawarənaakii pu'u aji bəra'i. Ca ndzaŋə banə ka tii agyanə sətə na ɗa tə ci. ");
INSERT INTO gde_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","Əŋki ci, “Fatəmə ŋga'ə! Wanaamə ka dzənə aa Urusaliima. Ma davə, ka dzənə nə ənji ka viinə tə Uuzənə ŋga əndə aacii madiigərə limanyinə da maliminə, təya lagi ka ci gəŋwanə ŋga ɓələnə, təya vii tə ci aacii ənjitə mashiimə tə Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Ma təya, ka ŋusənə nə tii tə ci, ka tiifənə nə tii giirənə aashikii, təya fəslə, təya ɓələgi tə ci. Ma ka makkənə ŋga uusəra, ka maɗətənə nə ci agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Wata i Yakubu tii da Yoohana, manjeevənə ŋga Zabadiya, a shi aaɓii Yeesu, əŋki tii ka ci, “Maləma, tə'i uushi ciina uuɗə kaa ha ɗa keenə.” ");
INSERT INTO gde_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Əŋki Yeesu, “Mi cuuna uuɗə nya ɗa koona?” ");
INSERT INTO gde_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Əŋki tii, “Vii keenə rəgwa ŋga ndzaanə ataŋgalaku agi ɗuunuunaaku, əndə'i da ciizəmaku, əndə'i əsə da madzənaku.” ");
INSERT INTO gde_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","Amma əŋki Yeesu, “Mashiimuunə sətə cuuna kədii. Kadə nuuna mbee ka sə'watə sa ciɓə makə ətə nii kya sa kwa? Ka mbeenə nuunə ka sə'watə bapətisəma makə ətə nə ənjə a ɗa ka nyi kwa?” ");
INSERT INTO gde_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Əŋki tii ka ci, “Awa, ka mbeenə niinə.” Yeesu a ba ka tii, “Weewee, ma ciɓətə nii kya sa, ka sanə nuunə. Ma bapətisəmatə nə ənjə a ɗa ka nyi əsə, ka ɗanə nə ənji koonə. ");
INSERT INTO gde_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","Amma, ma ndzaanə ataŋgalaki, əntaa nyi nəndə da baawəɗa ŋga viinə. Ma hatsa, ŋga ənjitə taɗəpaa Əntaŋfə tə tii.” ");
INSERT INTO gde_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Fanə ŋga hara lyawarənaakii pu'u tə waɓəətsa, wata səkətii a ɓəzəgi aashi i Yakubu tii da Yoohana. ");
INSERT INTO gde_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Wata Yeesu a 'watə tə tii patə aaɓiikii, əŋki ci, “Kə shii unə oo'i, ma ənjitə ŋgirə ənjitə mashiimə tə Əntaŋfə kaa təya ɗa ŋwaŋuunə agyanətii, tii ca haŋətə natii na. Ma madiigərə ənjatii əsə, agi kanə nə tii ka tii bariya də baawəɗa. ");
INSERT INTO gde_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amma, ma una, pooshi ka ɗanə ha'ə ahadoonə. Taa wu patə mwayi ndzaanə ka gawə ahadoonə, see a ndzaa ci ka əndə slənə goonə. ");
INSERT INTO gde_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Ha'ə taa wu patə mwayi ndzaanə ka matakəŋwanə ahadoonə, tyasə see a ndzaa ci ka mava ka ənji patə. ");
INSERT INTO gde_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Acii ma shi nyi *Uuzənə ŋga ənda, əntaa ka ənjə a slənə ka nyi, amma kaa nya slənə ka ənja, nya vəgi əpinaaki ka pərapaanə də ənji laŋə.” ");
INSERT INTO gde_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Wata i Yeesu da lyawarənaakii a mbu'u aasəkə vəranə ŋga Yarikoo. Makə ma'i tii da hara ənji laŋə, təya palə, wata təya lapaa muurəfə dasə ka kədiinə ataŋgala rəgwa. Ma ləməkii, Barətimawə, uuzənə ŋga Timawə. ");
INSERT INTO gde_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Makə fii ci oo'i, Yeesu əndə Nazaratu ətsə ca pitəgi, wata ca maɗee ka uuraakii ka banə, əŋki ci, “Yeesu, *jijinə ŋga Dawuda, nəhuu təgunuunaaki.” ");
INSERT INTO gde_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Ənji laŋə a wazə ka ci, kaa ca ndzaa kəɗa'ə. Amma wata ca tsakə ŋgəree ka uurakii palee ka əta, əŋki ci, “Jijinə ŋga Dawuda, nəhuu təgunuunaaki.” ");
INSERT INTO gde_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Yeesu a kəŋaanə, əŋki ci, “'Wamə tə ci.” Təya 'wa tə muurəfəta, əŋki tii ka ci, “Ɗawə mooɗasəka, maɗətə, agi 'wanə nə ci tə hə.” ");
INSERT INTO gde_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Wata həryatə muurəfətə a maɗətə, ca kagi gwadaakii, ca shi aaɓii Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Əŋki Yeesu ka ci, “Mi cii kwa moo nya ɗa ka ha?” Əŋki muurəfəta, “Maləma, ŋga'ə ka nyi kaa nya ənə ka neenə ka ha.” ");
INSERT INTO gde_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Əŋki Yeesu, “Duu saaku, kə mbə'i hə putə ŋga gi'inaaku tə nyi.” Pii wata ca ənə ka neenə ka ha, ca dzə atsaa Yeesu a rəgwa. ");
INSERT INTO gde_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Ma ətsə tii kədəhə ka mbu'unə aasəkə vəranə ŋga Urusaliima, kə lapaa tii vəranyinə ŋga Bayitifaaji da Bayitaniya, ashi giŋwə ŋga Zayitunə. Wata Yeesu a sləkee ka hara lyawarənaakii bəra'i ");
INSERT INTO gde_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","də banə ka tii, “Dəmə aasəkə vəraatsə akəŋwacii unə. Maɗa kə mbu'yuunə, pii ka lapaanə nuunə uundzə vamənda gwalə, pooshi ənji sha ŋgirə aa ba'akii. Pəryatəmə, una kira. ");
INSERT INTO gde_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","Maɗa kə ləguyi əndə a moonə taa ka mi cuuna ɗa ha'ə, bamə ka ci: ‘Slandanə mwayi. Ka ənyapaaginə nə ci pii pii’.” ");
INSERT INTO gde_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Wata təya maɗə, təya palə, təya lapaa uundzə vaməndakii magwaləkii a uura mayi, ataŋgala rəgwa. Ma təya pərə, ");
INSERT INTO gde_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ənjitə kəŋaanə davə a ləgwa amatii, əŋki tii, “Ka mi cuuna pərəgi uundzə vaməndatsa?” ");
INSERT INTO gde_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Təya ba makə sətə bii Yeesu ka tii. Wata ənjitə a unee ka tii, təya pərə, ");
INSERT INTO gde_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","təya kira uundzə vaməndatə ka Yeesu, təya luukutəvə kəjeerənyinatii aa ba'a vaməndata. Yeesu a ndərəvə aa ba'akii. ");
INSERT INTO gde_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Makə ŋgirə Yeesu aaba'a vaməndata, ca palə, ənji laŋə a sasafəpaa kəjeerənyinatii a rəgwa. Hara ənjə a pusha ba ŋga ənfuginə də bilə, təya sasafə a rəgwa. ");
INSERT INTO gde_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Ma ənjitə davə, dakəŋwaciikii da daba'əkii patə, kə ŋgəree tii ka uuratii, təya ba, “Dəlanə də Əntaŋfə. Tə'i barəkaanə ashi əndətə shi də ləmə ŋga Slandana. ");
INSERT INTO gde_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Tə'i barəkaanə agi ŋwaŋuunə ŋga dzədzəshi'inaamə *Dawuda ətə nii kəya ɗa. Dəlaamə də Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Mbu'unə ŋga Yeesu aasəkə vəranə ŋga Urusaliima, wata ca dəməgərə aasəkə *yi ŋga Əntaŋfə. Ca tsaamətə uushi'inə patə asəkəkii. Makə ɗii ci kə uugi kədəwanə ɗanə, wata ca maɗə tii da lyawarənaakii pu'u aji bəra'i, təya ənə aa Bayitaniya. ");
INSERT INTO gde_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Pukətə hakii təya ənya də Bayitaniya, wata maɗəfənə a ɗa tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ca nee ka ənfwə uudəvə dzaɗə gi'u, ca palə aatsaa ənfukii ka tsaamətənə mbu'u ka upaanə nə ci pookii. Amma makə mbu'i ci aatsakii, ma ca nee, wata ba səgafə, acii ma saa'ita, əntaa saa'i ŋga poonə ŋga uudəva. ");
INSERT INTO gde_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Wata Yeesu a naalagi tə ənfuta, əŋki ci, “Pooshi hə ka poonə bahə kaa əndə a adə pawaaku ma'ə.” Kə fii lyawarənaakii əsə. ");
INSERT INTO gde_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Mbu'unatii aasəkə vəranə ŋga Urusaliima, Yeesu a dəməgərə aasəkə yi ŋga Əntaŋfə. Wata ca ndzaŋə shaabagi tə ənji ɗa fiiriinə davə, ca dzaadzapaa ha ŋga pəra kwaɓa da dəgələnyinə ŋga ənji ɗərə də bilyamasariinə. ");
INSERT INTO gde_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Pooshi ci luuvə kaa ənjə a kərə uushi dasəkə yi ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Ca dzəgunə ka tii, əŋki ci, “Tə'i manaahəkii asəkə malaaɓa ləkaləkatə oo'i, ma bii Əntaŋfə, ‘Yi ŋga ɗa də'wa ŋga patənə ŋga slikərənə 'wanə ənji yaaki.’ Amma ma una, kə geegyuunə ka yikii ka ha ŋga umbənə ŋga mahiirənə.” ");
INSERT INTO gde_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Makə fii madiigərə limanyinə da i *maliminə ŋga bariya, wata təya alə rəgwa ŋga ɓələnə tə Yeesu. Acii kə ŋgwalee ci ka tii, makə nee tii, kə ɗii ka ənji ka sə ŋga hurəshishinə nə dzəgunənaakii ka tii. ");
INSERT INTO gde_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Ɗanə ŋga kədəwanə, Yeesu tii da lyawarənaakii a dzəgi asəkə vəranə. ");
INSERT INTO gde_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Pukətə hakii deerənə, təya ənya aasəkə vəranə, wata ma təya tsaaməgi, kə huurəgi ənfwə uudəvətə hwa'ə dəŋə ka slərəginəkii. ");
INSERT INTO gde_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Ma Piita, kə buurətə ci sətə ɗii. Wata əŋki ci ka Yeesu, “Maləma, tsaaməgi. Ma ənfwə uudəvətə naalagi hə, kə huurəgi hwa'ə.” ");
INSERT INTO gde_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Yeesu a ba ka tii, “Viimə gooŋga ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Tantanyinə cii kya ba koonə, ma əndətə gi'i tə Əntaŋfə, ka mbeenə nə ci ka banə ka giŋunə oo'i, Mbuɗuu, ha dzə ka kulagərənə aagi uunəva. Maɗa kii ci nəkii də ədzəmə rəŋwə oo'i, ka ɗanə nə Əntaŋfə ka ci sətə kədii ci, ka ɗanə ka ci. ");
INSERT INTO gde_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Aciikii wanyinə ka banə koonə, taa mi patə kədii unə də də'wa, kamə nuunə oo'i kə upaa unə səkii, ka upaanə nuunə əsə. ");
INSERT INTO gde_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Waatoo, taa guci nuunə ka ɗa də'wa, maɗa tə'i əndə kəsəpaa unə a mooɗəfuunə, tifyagimə tə ci, kaa Dəsənuunə ətə dadagyə a tifyagi koonə 'waslyakəənə goonə.  ");
INSERT INTO gde_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amma maɗa pooshi unə tifyagi tə hara ənja, pooshi Dəsənuunə ətə dadagyə ka tifyagi koonə 'waslyakəənə goonə əsə.” ");
INSERT INTO gde_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Mbu'unatii aa Urusaliima, ma Yeesu a dzə də wiigi'inə asəkə *yi ŋga Əntaŋfə, wata madiigərə limanyinə da maliminə da gayinə a shi aaɓiikii. ");
INSERT INTO gde_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Wata təya gwaŋə ka ləgwanə amakii, əŋki tii, “Də ŋgutə baawəɗa saŋə cii kwa ɗaaɗa uushi'iinə ha'a? Wu saŋə vii ka hə baawəɗatsa?” ");
INSERT INTO gde_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Yeesu a ba ka tii, əŋki ci, “Nyi maa, ka ləgwanə nə nyi koonə naaki. Maɗa kə bagyuunə ka nyi, nyi maa, ka banə nə nyi koonə taɗa də ŋgutə baawəɗa cii kya ɗaaɗa uushi'iina. ");
INSERT INTO gde_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Bamə ka nyi, wu saŋə sləkee ka Yoohana kaa ca ɗa bapətisəma ka ənja, Əntaŋfə nii, anii ənda?” ");
INSERT INTO gde_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","See təya ndzaŋə ɗaaɗa mabizhinə ahadatii, əŋki tii, “Mi banaamə əna? Maɗa bii amə oo'i, Əntaŋfə sləkee ka Yoohana, ka banə nə ci, aa mi pooshi unə luuvə waɓənaakii ɗiya? ");
INSERT INTO gde_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Amma pooshi amə ka banə oo'i, əndə sləkee ka ci.” Ma təkuree tii ka banə ha'ə, ŋgwalii tii acii daɓaala, acii ma təya, kə shii tii oo'i, *anabi nji Yoohana tanyi. ");
INSERT INTO gde_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Wata əŋki tii ka ci, “Mashiimiinə taa wu sləkee ka ci.” Əŋki Yeesu ka tii naakii, “Ha'ə nə nyi əsə, paa nyi ka banə koonə taɗa də ŋgutə baawəɗa cii kya ɗa uushi'iina.” ");
INSERT INTO gde_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Wata Yeesu a 'watəgi waɓənə ka tii də misaali, əŋki ci, “Tə'i əndə'i əndə sha ɗii rə ŋga inabi. Ca tsatə, ca tələgi gu'u ŋga mya'ə də inabi, ca ghənəgi magərə ha ŋga nəhə uushi'inə, ca ŋgərə rəkii, ca vəgi ka mooziinə, kaa təya təkə cifanə ŋga rəkii da i ci. Ma daba'əkii, ca palə oogə. ");
INSERT INTO gde_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Makə ɗii cifanə ŋga inaba, wata ca sləkee ka əndə slənaakii ka liwa ka ci gyaɗalaakii aciitii. ");
INSERT INTO gde_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Wata təya kəsə tə ci, təya fəəsləpaa tə ci, təya ənəpaa də ci pooshi taa mi aciikii. ");
INSERT INTO gde_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Slanda rətə a ənə ka sləkee ka əndə'i əndə slənaakii. Təya dəəgəpaa tə ci ka na, ayi ayi dərəva ciɓee tii ka ci. ");
INSERT INTO gde_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Slanda rətə a ənə ka sləkee ka əndə'i əndə əsə. Ma ca, kə ɓələgi tii tə ci. Ha'ə makə ətsə ɗii tii də hara ənji laŋə. Təya fəəsləpaa harakii, təya ɓəələgi harakii. ");
INSERT INTO gde_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Wata mooɗə uuzənaakii rəŋwə dyaŋə mbəɗaanə. Daba'əkii, ca sləkee ka uuzəətə aaɓiitii. Əŋki dii, ‘Weewee ka neenə nə tii ka məghərəvənə ŋga uuzənaaki.’ ");
INSERT INTO gde_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Mbu'unə ŋga uuzəəta aaɓiitii, wata əŋki tii ahadatii, ‘Waanə mazəmə yi kə mbu'ya. Shoomə, kaama ɓələgi tə ci, kaama zəmə ya.’ ");
INSERT INTO gde_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Wata təya kəsətə tə uuzəəta, təya ɓələgi tə ci, təya kagi tə ci aaba'ə tsanə. ");
INSERT INTO gde_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“Ya ətsa, mi nə sətə ɗanə slanda rəta? Ka shinə nə ci, ca ɓəələgi tə mooziita, ca vii rətə ka hara ənja. ");
INSERT INTO gde_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Mashimuunə a jaŋgii sətə nyaahə ənji asəkə malaaɓa ləkaləkatə kuna? Ma bii ci, ‘Ma faaratə kaaree ənji ghənə kuva makə pooshi nafaakii, ci ənəpaa ka faaratə palee də məghərəvənə. ");
INSERT INTO gde_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Ma ətsa, slənə ŋga Slandana. Ma amə əsə, sə ŋga hurəshishinə kaamə.’ ” ");
INSERT INTO gde_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Makə fii gayinə ha'ə, wata təya ɗa gazhi'waanə ŋga kəsətənə tə Yeesu, acii kə shii tii oo'i agyanətii waɓi ci də misaalitsa. Amma kə ŋgwaləgi tii acii daɓaala. Wata təya bwasee ka ci, təya palə satii. ");
INSERT INTO gde_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ma daba'əkii, wata ənjə a sləkee ka hara *Farisanyinə da ənji ŋga *Hirudusə kaa təya shii upaa sə ŋga idəpaanə ashi Yeesu agi waɓənaakii, təya kəsə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Təya shi aaɓiikii, əŋki tii, “Maləma, kə shii inə oo'i əndə gooŋga nə hə. Paa hə ka taɗəpaa taa ŋgutə tsarə ŋga ənda, acii paa hə ka tsaamənə ka ɗuunuunə ŋga ənda. Də gooŋga nə hə ka dzəgunətənə ka ənji rəgwa ŋga Əntaŋfə. Ya saŋa, kə kapaa bariya gaamə kaamə rəgwa ŋga vii tsəkə ka ŋwaŋwə Kayisarə nii, anii poosha? ");
INSERT INTO gde_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","A ki'yaamə nii, anii a bwasee ama?” Amma kə shii Yeesu jarəwiinatii, wata əŋki ci ka tii, “Mi saŋə cuuna moo təkənə tə nya? Kiramə kwaɓa kaa nya tsaamətə.” ");
INSERT INTO gde_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Təya kira ka ci. Wata ca ləgwa ka tii, əŋki ci, “Ya əna, kəŋwaciinə da ləmə ŋga wu ənə anə kwaɓana?” Təya ba ka ci, “Ma ətsa, kəŋwaciinə ŋga ŋwaŋwə Kayisarə.” ");
INSERT INTO gde_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Wata Yeesu a ba ka tii, “Viimə ka Kayisarə sətə ndzaa ka naakii, una vii ka Əntaŋfə sətə ndzaa ka ŋga Əntaŋfə.” Fanatii ha'ə, kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Ma daba'əkii əsə, *Sadukiinə a shi aaɓii Yeesu. Ma təya, tii nə kurəgətə ca ba, pooshi maməətə ənji ka maɗənə da i əpinə shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","Əŋki tii ka Yeesu, “Maləma, kə nyaahə Muusa kaamə bariya, ətə bii ci, maɗa kə əntəgi əndə anə minaakii, pooshi ci pwayi ashi miita, see a ŋgərə ndzəkəŋuci tə miita, kaa ca poo manjeevənə ka ndzəkəŋuci ətə əŋki. ");
INSERT INTO gde_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Yoo, tə'i hara ndzəkəŋushi'inə məɗəfə sha ɗii. Gawatii a ŋgərə minə. Ca əntə, pooshi ci pwayi ashitə. ");
INSERT INTO gde_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Əndətə nyi'u tə ci a ŋgərə mooryafiita, ca əntəgi əsə. Pooshi ci upaa uuzənə ashitə. Makə ətsə əsə ɗii ka makkənə. ");
INSERT INTO gde_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Makə ətsə əsə ɗii ka hara ənjitə mbəɗaanə. Ndzəkəŋushi'iitsə patə məɗəfə məəki, pooshi əndə upaa uuzənə ashi miita. Ma daba'əkii, kya əntəgi əsə. ");
INSERT INTO gde_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Ya ətsa, maa ma'i tii patə uusəra ŋga maɗənə ŋga maməətə ənja, makə watiitsə tii patə məɗəfə ŋgirə tə kya, minə ŋga wu saŋə ndzaanəta?” ");
INSERT INTO gde_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Yeesu a ba ka tii, əŋki ci, “Kə kulii unə patə, acii pooshi unə paaratəgi də malaaɓa ləkaləkatə, mashiimuunə ŋgeerənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Acii maɗa kə ma'i maməətə ənja, pooshi tii na ŋgəərəshi. Amma makə malaa'ikanyinə dadagyə nə təya ndzaanə. ");
INSERT INTO gde_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Ma agyanə maɗənə ŋga maməətə ənji əsə, pooshi unə kunə sha jaŋgatə asəkə ləkaləkatə ŋga Muusa ətə waɓi ci agyanə guutə agi ba? Waatoo saa'itə bii Əntaŋfə ka ci: Nyi nə Əntaŋfə ətə ci Ibərahiima da Isiyaaku da Yakubu a paslə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Ma Əntaŋfə, ənjitə da i əpinə amatii ca paslə tə ci, əntaa ənjitə yadə əpinə amatii. Ma ətsa, kə kulii unə ka shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Wata əndə'i maləmə a shi aaɓiitii. Ma ca fa, təya ɗa mabizhinə. Makə fii ci kə jikə Yeesu ka Sadukiinə ŋga'ə, wata ca ləgwa ka Yeesu, əŋki ci, “Ŋgutə bariya saŋə palee də ɗuunuunə agi bariyanyinə pata?” ");
INSERT INTO gde_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Əŋki Yeesu ka tii, “Ma ətə palee də ɗuunuunə, ətə bii: Fatəmə, ənji *Isərayiila, ma Əntaŋfə Slandanaamə, ci nə Əntaŋfə rəŋwə dyaŋə. ");
INSERT INTO gde_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Uuɗuu tə Əntaŋfə Slandanəku də ədzəmə rəŋwə, də patənə ŋga əpinaaku, də patənə ŋga haŋkalaaku, də patənə ŋga ŋgeerənaaku. ");
INSERT INTO gde_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Wiinə bəra'inə ŋga bariyatə palee əsə: Uuɗuu tə əndətə aɓiiku makə sətə cii kwa uuɗə naaku na. Pooshi bariyatə ca palee ka ətsə bəra'i ma'ə.” ");
INSERT INTO gde_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Əŋki maləmətə ka Yeesu, “Yawa maləma, ma sətsə bii hə, ha'ə tanyi. Waatoo rəŋwə dyaŋə nə Əntaŋfə. Pooshi əndə'i əntaŋfə maɗaamə ci. ");
INSERT INTO gde_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","Ŋga'ə nə uuɗənə tə Əntaŋfə də ədzəmə rəŋwə, da də patənə ŋga haŋkala, da də patənə ŋga ŋgeerənə. Ŋga'ə əsə nə uuɗənə tə əndətə aɓiiku makə sətə cii kwa uuɗə naaku na. Gəɗə kəsətənə təŋə təŋə tə bariyanyiitsə bəra'i acii ɗaaɗa patənə ŋga sataka, taa hənəgi uushi'inə ka Əntaŋfə, taa lagi ka ci uura ŋga daba.” ");
INSERT INTO gde_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Makə fii Yeesu ŋunyikii waɓi ci, wata əŋki ci ka ci, “Pooshi hə dzaɗə da ŋwaŋuunə ŋga Əntaŋfə.” Ma daba'əkii, pooshi əndə ənyi ka ləgwa waɓənə ama Yeesu ma'ə, acii ŋgwalənə. ");
INSERT INTO gde_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Ma saa'itə Yeesu a dzəgunə ka ənji asəkə yi ŋga Əntaŋfə, ca ləgwa amatii, əŋki ci, “Iitə saŋə mbee *maliminə ŋga bariya ka banə oo'i, jijinə ŋga *Dawuda nə Aləmasiihu? ");
INSERT INTO gde_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Acii taa Dawuda də naakii nə maa, kə kavə Ma'yanə ŋga Əntaŋfə tə ci ka banə oo'i, ‘Əŋki Əntaŋfə Slandanə ka Slandanəki, ndzaanə gadəvə da ciizəmaki. Ka kavənə nə nyi tə ənji daawaanaaku aatsaa səɗəku.’ ");
INSERT INTO gde_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Aa makə kə 'wii Dawuda tə Aləmasiihu də Slandanə ətsa, iitiitə ɗii ndzaanə Aləmasiihu ka jijinaakəya?” Də mooɗasəkə fii daɓaala waɓənaakii. ");
INSERT INTO gde_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Ma ca dzə aakəŋwa də dzəgunənə ka tii, wata əŋki ci, “Nəhəmə noonə nə acii *maliminə ŋga bariya. Ma təya, də madiigərə kəbənə moonətii wiigi'inə. Ma moonətii, nəəhəpaanə tə tii ŋga'ə a luuma. ");
INSERT INTO gde_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ka hatə da ginə davə moonətii ndzaanə asəkə *kuvə də'wanyinə da agi əndzanə. ");
INSERT INTO gde_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Təya luuwutə yinyinə ŋga mooryafinyinə, təya gərətəgi də də'wa ka dəla də natii nə akəŋwacii ənja. Ma təya, kadə nə təya upaa bwaya gəŋwanə ətə palee patə.” ");
INSERT INTO gde_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Wata Yeesu a ndzaanə kədəhə da hatə ci ənjə a kagərə kwaɓa asəkə yi ŋga Əntaŋfə. Ca tsaamə ənjə a əji. Ənji gəna laŋə əji kwaɓa laŋə. ");
INSERT INTO gde_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Wata maagha ŋga mooryafinə a shi, kya əjigərə pyanya bəra'i, waatoo kwaɓa rəŋwə. ");
INSERT INTO gde_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Yeesu a 'wa tə lyawarənaakii, əŋki ci ka tii, “Tantanyinə cii kya ba koonə, ma sətə əjigərə maagha ŋga mooryafiitsa, kə palee ka ŋga hara ənjitsə patə. ");
INSERT INTO gde_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Acii ma təya, agi ɓəzə gəna ŋgiragi tii, təya vii. Amma ma kya, agi ghanatə patə ŋgərətə ki sətə cii ta alə də zəmə patə, kya əjigərə.” ");
INSERT INTO gde_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Ma ətsə Yeesu a shigi asəkə yi ŋga Əntaŋfə, wata əndə'i əndə ahada lyawarənaakii a ɓaarə ka ci, əŋki ci, “Maləma, tsaamuu dagwaanə ŋga ghənəəna da i faariinəkii.” ");
INSERT INTO gde_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Yeesu a jikəvə, əŋki ci, “Kə nee hə ka madiigərə ghənəətsə patə nii? Taa rəŋwə pooshi faara na mbəɗaanə ganə anə əndə'i, ka waalaginə nə ənji patə.” ");
INSERT INTO gde_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Ma daba'əkii, wata Yeesu a dzə ka ndzaanə dasə anə giŋwə ŋga Zayitunə, a purəŋa yi ŋga Əntaŋfə. I Piita da Yakubu da Yoohana ba'ə Andərawəsə a shi aaɓiikii tii daanətii, əŋki tii: ");
INSERT INTO gde_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“Bawə keenə guci saŋə nə ətsə ha'ə a ɗa. Mi saŋə na slənə ka ɓaariinə oo'i, kə mbu'ya saa'i ŋga ɗaaɗanə ŋga uushi'iitsə pata?” ");
INSERT INTO gde_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Wata əŋki Yeesu ka tii, “Nəhəmə acii ga ənjə a gəpi duunə. ");
INSERT INTO gde_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Acii tə'i ənji laŋə na shi, təya ɗəkəvə ləməki ka natii na, taa wu ca ba, ci nə *Aləmasiihu, təya ŋusləgi də hara ənji laŋə a rəgwa. ");
INSERT INTO gde_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Kadə nuuna fa habara ŋga paapanə taa dama patə. Amma goona buurə. Acii ma ətsa, weewee ka ɗanə ha'ə, amma əntaa ci nə muudinə ŋga duuniya. ");
INSERT INTO gde_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Kadə nə əndə'i slikərənə a dzə ka panə da əndə'i. Ŋwaŋuunə a pa da əndə'i ŋwaŋuunə. Kadə nə gəgədzənə ŋga hanyinə a ɗaaɗa taa dama patə, maɗəfənə a kula əsə. Ma ətsə patə, makə 'watəginə ŋga ɓərakənə ətsa. ");
INSERT INTO gde_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“Amma, ma una, nəhəmə noonə na. Acii tə'i ənji na kəəsə tuunə, təya kərə aakəŋwacii gəŋwanə, təya fəslə tuunə asəkə *kuvə də'wanyinə, təya kərə tuunə aakəŋwacii ŋgwamənanyinə da meeminə putə ŋga nə'unə goonə tə nyi. Ka ɗanə nə ətsə ha'ə, koona shii mbee ka bagi ka tii Ŋunyi Habara. ");
INSERT INTO gde_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Acii tyasə see a waaza ənji Ŋunyi Habara taa dama patə zəku'i, taabu'u mbu'yanə muudinə ŋga duuniya. ");
INSERT INTO gde_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Maɗa kə kirə tii tuunə aakəŋwacii gəŋwanə, goona ənvutə noonə nə ka buurə sə ŋga banə ka tii. Amma bamə ka tii sətə shivə aa moonə unə akəŋwaciitii. Acii ma waɓəətə nuunə ba, əntaa noonə amma ŋga Malaaɓa Ma'yanə. ");
INSERT INTO gde_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","“Kadə nə ndzəkəŋunə a ŋgərə tə ndzəkəŋuci, ca vii ka ɓələginə. Dəsənə manjeevənə əsə, ka ɗanə nə tii ha'ə. Ha'ə ɗanə nə manjeevənə əsə, ka viinə nə tii tə mapoo tə tii ka ɓələginə. ");
INSERT INTO gde_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Taa wu patə, kadə nii kəya ushapaa tuunə putə ŋga nə'unə goonə tə nyi. Amma taa wu patə sə'watə ciɓənyinəkii ca'ə ka muudinə, ka upaanə nə ci luupaanə.” ");
INSERT INTO gde_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","“Kadə neenə nuunə ka ma'ajijinə uushi ətə palee ca kəŋaanə ka hatə pooshi dəɓee ka ci nə kəŋaanənə davə.” (Ma əndətə ca jaŋga, wa ca paaratəgi ŋga'ə.) “Maɗa kə nee unə ha'ə, ma ənjitə ganə anə hanyinə ŋga Yahudiya, wa təya huyi ka umbənə aanə giŋunyinə. ");
INSERT INTO gde_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Ma əndətə dzakə anə kuvaakii, wa ca jimagərə, ca huyi, ga ca dzə dasii ka ŋgərəənə uushi. ");
INSERT INTO gde_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","Ma əndətə də bilə əsə, ga ca ənə aasii ka ŋgira kəjeerənaakii. ");
INSERT INTO gde_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Tə'i ŋgəra'wə agyanə maki ɗasəkiinə da ŋugiginə ka saa'ikii. ");
INSERT INTO gde_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Kədiimə acii Əntaŋfə, acii ga saa'itsə a ɗii deevyanə. ");
INSERT INTO gde_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Acii ma ka saa'ikii, ka sanə nə ənji ciɓənyinə ətə pooshi sha ɗii, njaŋanə ka saa'itə tagii Əntaŋfə duuniya ca'ə ka əndzə'i. Pooshi uushi na ənə ka ɗanə ha'ə ma'ə makə ci əsə. ");
INSERT INTO gde_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Maci pooshi ətə galee Əntaŋfə ka saa'ikii, kaɗa pooshi əndə shiŋkinə ca mbəɗə. Amma acii putə ŋga mataɗə ənjaakii, ka galeenə nə ci ka saa'ikii. ");
INSERT INTO gde_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","“Maa kə bii əndə koonə, Tsaaməmə, waanə Aləmasiihu ganə, taa, waatəta gatə, goona luuvə. ");
INSERT INTO gde_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Acii kadə nə aləmasiihunyinə da anabinyinə ŋga jirakənə a shigi, kadə nə təya ɗaaɗa sə ŋga hurəshishinə, kaa təya shii ŋuusləgi də ənja. Maci ka mbeenə nə tii maa, da i mataɗə ənji ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Kə bagi nyi koonə patənə ŋga uushi'inə daga saa'ikii ma'ə mambu'yanə. Acii ha'ə, nəhəmə noonə na.” ");
INSERT INTO gde_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“Amma ma daba'ə ciɓənyiitsə ha'ə, ka əndəginə nə uusəra, pooshi ləgiɗa ka ɓərənə, ");
INSERT INTO gde_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","tikisanyinə a kwaalya dagyə, ka gaŋgəzənə nə taa mi patə asəkəntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Ma ətsə ɗiya, ka neenə nə ənji ka Uuzənə ŋga əndə ca jima agi kuraɓiinə. Da baawəɗa ka shaŋə da məghərəvənə nə shinaakii. ");
INSERT INTO gde_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Ma daba'ə ətsa, ca sləkee ka malaa'ikanyinə a dzə ka jatə də mataɗə ənjaakii taa dama patə ndzaŋənə ka əndə'i taŋgala ŋga duuniya ka ca'ə ka əndə'i.” ");
INSERT INTO gde_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“Wa ənfwə uudəvə a ka koonə hiima. Maɗa kə nee unə wiitsə kə 'watəgi ənənə, yoo, kə shii unə ətsə, kədəhə nə mətsətsəfə ka ɗanə. ");
INSERT INTO gde_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ha'ə əsə, maɗa kə nee unə uushi'iitsə a ɗaaɗa, ka shiinə nuunə ətsə, kədəhə nə Uuzənə ŋga ənda, matasəkakii kaa ca shi. ");
INSERT INTO gde_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Tantanyinə cii kya ba koonə, ma ənji ŋga zamanana, pooshi tii ka məətəginə patə, uushi'iitsə ma'ə maɗaaɗamə patə. ");
INSERT INTO gde_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Ka uudəginə nə ha a dagyə da ha a panə, amma ma waɓənaaki, pooshi ka uudənə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“Ma uusəra taa saa'i ŋga ɗanə ŋga uushi'iitsa, pooshi əndə shii. Malaa'ikanyinə ŋga dagyə maa, pooshi tii shii. Ha'ə nə Uuzənə əsə, paa ci shii, see Dii ci daanəkii. ");
INSERT INTO gde_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Acii ha'a, nəhəmə noonə na, kantsaamə ginə makə ɗii ci pooshi unə shii taa guci nə saa'ikii ka ɗanə. ");
INSERT INTO gde_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Ma saa'ikii, ka ɗanə makə ŋga əndətə gi oogə, ca ba'avə yaakii aacii ənji slənaakii, taa wu patə ahadatii da naakii sləna. Ca ba ka magəra maya, wa ca kantsaa ginə ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Acii ha'ə, ma unə əsə, kantsaamə ginə makə ətsa, makə ɗii ci pooshi unə shii saa'itə nə slanda yi a shi, taa dakədəwanə, taa ahada vəɗa, taa dakəɗəha, taa deerənə. Acii ha'a, ndzaamə də məgigi ka gəranə, ");
INSERT INTO gde_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","acii ga ca shi wata haɓəsə, ca lapaa tuunə ka ŋunyinə. ");
INSERT INTO gde_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Ma sətə bii nyi koonə, ci bii nyi əsə ka ənji patə oo'i, kantsaamə ginə, una ndzaanə də məgigi.” ");
INSERT INTO gde_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Ma ətsə mbəɗaanə baanə bəra'i kaa kumənə ŋga *Pasəka da kumənə ŋga adə buroodi yadə burəŋanə a mbu'ya, wata madiigərə limanyinə da *maliminə ŋga bariya a alə rəgwa ŋga kəsənə tə Yeesu yadə shiinə ŋga ənja, kaa təya ɓələgi tə ci. ");
INSERT INTO gde_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Əŋki tii, “Gaama kəsə tə ci agi kumənə, acii ga ənjə a maɗee ka panə.” ");
INSERT INTO gde_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Ma saa'itə Yeesu də Bayitaniya, kə gi ci aaha Simoonə ətə shi uyi kuzənə a kəshi tə ci. Ma ətsə ca adə zəma, wata əndə'i minə a shigərə da i əbwə urədya aciitə. Ma urədita, ŋga mandalə kwaɓa acii də ba ŋga ‘narədi’ dii ənji. Kya wunəgi əbukii, kya əjivə urəditə aanə Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Makə nee hara ənjitə davə ha'ə, wata ca zhimagi tə tii asəkətii, əŋki tii ahadatii, “Ka mi saawee ki ka urəditsə zaɓə ha'ə kwa? ");
INSERT INTO gde_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Maci ɗərəmaginə ɗərəmagi ənji də urəditsa, kaɗa ka upaanə nə ənji kwaɓa palee ka *hwaslə gya'ə makkə, ənjə a təəkəpaa ka maaghiinə.” Wata ənjitə a wazə ka ki. ");
INSERT INTO gde_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Əŋki Yeesu ka tii, “Bwaseemə ka miitsa. Ka mi cuuna kavə tə ki ka buurə uushi'ina? Acii ma sətsə ɗii ki ka nyi, ŋunyikii ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Ma maaghiinə, ka hakii nuunə taa guci patə. Taa guci patə əsə, ka mbeenə nuunə ka ɗa ŋga'aanə ka tii. Amma ma nya, pooshi nyi na ndzaanə aɓii unə. ");
INSERT INTO gde_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Kə ɗii ki sətə mbee ki ka ɗanə. Ma əjivə ki, ka shii taasəkəpaa də shishinəki taabu'u ŋgəɗənə tə nyi. ");
INSERT INTO gde_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Tantanyinə cii kya ba koonə, taɗa da nə ənjə a waaza Ŋunyi Habara asəkə duuniya patə, ma sətsə ɗii ki, ka waɓənə nə ənji anəkii ka buurətənə də ki davə.” ");
INSERT INTO gde_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Ma Yahuda Isəkariyoota, rəŋwə nə ci agi *lyawarənə ŋga Yeesu pu'u aji bəra'i, wata ca maɗə, ca palə aaɓii madiigərə limanyinə, kaa ca vəgi tə Yeesu ka tii. ");
INSERT INTO gde_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Makə fii tii ha'ə, wata kə uuɗii səkətii. Təya ɗa aləkawalə kaa təya vii ka ci kwaɓa. Ci əsa, ca 'watəgi tsaamə ŋunyi saa'i ŋga viinə tə Yeesu ka tii. ");
INSERT INTO gde_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Ma ka təkəŋwanə ŋga uusəra ŋga *kumənə ŋga adə buroodi yadə burəŋanə, waatoo uusəra ŋga laala uura ŋga uuji bagiinə ka buurətə də Pasəka, wata lyawarənə ŋga Yeesu a ləgwa amakii, əŋki tii, “Da daa moonəku ina dzəgə ka hə əndzanə ŋga Pasəka?” ");
INSERT INTO gde_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Wata ca sləkee ka lyawarənaakii bəra'i, əŋki ci ka tii, “Dəmə aasəkə vəranə, ka gəŋunə nuunə da əndə da uuda ma'inə anəkii. Ma ɗanuuna, nə'umə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Ma yitə gimə ci aadəvə, bamə ka slanda yikii oo'i, ma bii Maləmə tuu, miinə kuvətə nii kəya zəmə əndzanə ŋga Pasəka davə da lyawarənaakii kwa? ");
INSERT INTO gde_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","Kadə nii kəya ɓaarii koonə maɗuunə kuvə anə əndə'i, mahaɗakii ŋga'ə, matasəkakii əsə. Davə dzəgənuunə kaamə əndzanə.” ");
INSERT INTO gde_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Wata lyawariitə bəra'i a maɗə, təya palə aasəkə vəranə. Təya lapaa makə sətə bii Yeesu ka tii weewee. Wata təya dzəgə əndzanə ŋga Pasəka davə. ");
INSERT INTO gde_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Makə ɗii kədəwanə, Yeesu a shi tii da lyawarənaakii pu'u aji bəra'i. ");
INSERT INTO gde_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Ma ətsə təya adə zəma, wata əŋki Yeesu ka tii, “Tantanyinə cii kya ba koonə, kadə nə rəŋwə ahadoonə a vii tə nyi aacii ənja, waatoo agyuunə ənə caama adə doonə.” ");
INSERT INTO gde_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Lyawarənaakii a ndzaŋə ɗa maɓətə səka. Taa wu ahadatii a ləgwa amakii: Nyi kwa? Nyi kwa? ");
INSERT INTO gde_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Əŋki Yeesu ka tii, “Agyuunə ənə pu'u aji bəra'i nə əndəkii. Agi adənə naamə asəkə kəŋwə rəŋwə da ci. ");
INSERT INTO gde_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Ma nyi *Uuzənə ŋga ənda, ka əntənə nə nyi tə əntənə makə sətə nyaahə ənji agyanəki. Amma kə ɗii anə əndətə na vii tə nyi ka ənja. Ma əndəta, maci mapoomə ənji tə ci, biɗə ci ka ci.” ");
INSERT INTO gde_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Ma tii agi adə zəma, Yeesu a ŋgərə buroodi, ca kuyirii tə Əntaŋfə. Ca ɓaatsəpaa, ca vii ka lyawarənaakii. Əŋki ci ka tii, “Ndamə. Ma ətsa, shishinəki.” ");
INSERT INTO gde_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Ca ŋgərə kwalaka da ma'i inabi asəkəkii, ca ənə, ca kuyirii tə Əntaŋfə, ca vii ka tii. Tii patə, təya saasacii. ");
INSERT INTO gde_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Yeesu a ba ka tii, “Ma ətsa, idənaaki. Ci ca mbu'utəgi də aləkawalə ŋga Əntaŋfə. Idənəkii na əjigi ka putə ŋga ənji laŋə. ");
INSERT INTO gde_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Tantanyinə cii kya ba koonə, ma daba'ə əna, paa nyi ka ənənə ka sa ma'i inabi ma'a, see uusəratə nii kya sa kurakii agi ŋwaŋuunə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Ma daba'əkii, təya ka wanyanə, təya maɗə, təya palə aashi giŋwə ŋga Zayitunə. ");
INSERT INTO gde_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Əŋki Yeesu ka tii, “Unə patə, kadə nuuna huyi, una bwasee ka nyi. Ka ɗanə makə sətə waɓi Əntaŋfə asəkə malaaɓa ləkaləkatə oo'i: ‘Ka ɓələginə nə nyi tə magəra, bagiinə a təəkəgi patə əsə’.” ");
INSERT INTO gde_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Wata ca tsakə banə, əŋki ci, “Amma maɗa kə maɗee ənji ka nyi agi maməətə ənja, ka tanə nə nyi koonə kəŋwanə ka dzənə aanə hanyinə ŋga Galili.” ");
INSERT INTO gde_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Əŋki Piita ka Yeesu, “Taa kə huyi hara ənji patə aciiku, ma nyi kamə, paa nyi ka bwaseenə ka hə.” ");
INSERT INTO gde_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Wata əŋki Yeesu ka ci, “Tantanyinə cii kya ba ka hə, ma taabu'u wanə gyaagya ŋga bəra'inə ənshinə davəɗə, ka jikənə nə hə makkə ka hiweenə ka shiinə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Amma Piita a ba də ŋgeerənə, əŋki ci, “Taa əntənə cii kwa əntə, aŋwə da hə nə əntənə. Paa nyi ka hiweenə ka shiinə tə hə.” Ha'ə makə ətsə əsə bii hara lyawarənaakii patə. ");
INSERT INTO gde_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ma daba'əkii ha'ə, təya dzə ka əndə'i ha ətə ci ənjə a 'wa Gyatsimani, wata ca ba ka lyawarənaakii, “Ndzaamə gadəvə, kaa nya dzə ka ɗa də'wa.” ");
INSERT INTO gde_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Ca 'waanə tə i Piita i Yakubu ba'a Yoohana. Ma təya dzə, wata ca ndzaŋə buurə uushi'inə ka shaŋə, səkəkii a ɓəzəgi kuzhiɗə kuzhiɗə. ");
INSERT INTO gde_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Əŋki ci ka tii, “Maɓəzəkii nə səkəki makə a əntəgi nyi. Ənəgimə ganə, goona tsəfə ŋunyinə, ndzaamə də məgigi.” ");
INSERT INTO gde_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Ca əntsahə aakəŋwa gi'u, ca kulapaa aanə səkəkii, ca ɗa də'wa oo'i, maɗa ka ɗanə, ga ca dzə aagi saa'i ŋga ciɓa. ");
INSERT INTO gde_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","Əŋki ci, “Daada, taa mi patə ka mbeenə nə hə. Əntsahee ka nyi ka ciɓətsə akəŋwaciiki. Amma ɗawə sətə kaɗeesəkə ka hə, ga ha ɗa sətə kaɗeesəkə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Ca ənya aaɓii lyawariitə makkə. Ma shi ci, ka ŋunyinə nə tii patə. Wata əŋki ci ka Piita, “Simoonə, ka ŋunyinə nə hə kuna? Kə təkuree hə ka ndzaanə də məgigi taa ŋga tibisə rəŋwə dyaŋə nii? ");
INSERT INTO gde_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Ndzaamə də məgigi, una ɗa də'wa, acii goona bwasee ka rəgwa ŋga Əntaŋfə saa'itə nə *Seetanə a təɓə tuunə. Ma asəkə ədzəmuunə, ŋga'ə koonə nə ɗa gazhi'waanə, amma mazaarəkii nə shishinə.” ");
INSERT INTO gde_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Yeesu a ənə ka palənə ka ɗa də'wa əsə, ca ənə ka ɗa də'wa makə ətə ɗii ci təkəŋwa. ");
INSERT INTO gde_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Ca ənya aaɓii lyawariita. Ma ənya ci əsə, ka ŋunyinə nə tii, acii kə uugi ŋunyinə ɗanə laŋə agitii ka shaŋə. Pooshi tii shii sə ŋga banə ka ci. ");
INSERT INTO gde_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Makə ənya ci ŋga makkənə, əŋki ci ka tii, “Ma'ə unə a ŋunyi kuna, una əpi səka? Kə uugi ha'ə ɗii. Ma əndzə'i, kə uugi saa'i mbu'yanə. Kə uugi ənji vəginə tə Uuzənə ŋga əndə aacii ma'waslyakə ənja. ");
INSERT INTO gde_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Tsaaməmə! Waatsə əndətə ca vəgi tə nyi. Maɗətəmə kaama dzə.” ");
INSERT INTO gde_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Ma ətsə Yeesu ma'ə agi waɓənə, pii wata kə mbu'ya Yahuda, waatoo əndətə agi lyawarənaakii pu'u aji bəra'i. Kə shi ci dzuɓə da ənji daba'əkii, tii patə da i ŋgila purəŋanyinə da i zaliinə aciitii. Madiigərə limanyinə da maliminə, ba'ə gayinə sləkee ka tii. ");
INSERT INTO gde_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Asee, ma Yahuda ətə vii tə Yeesu aacii ənja, kə bii ci ka tii makə sətə nii kəya ɗatə ka ɓaarii də ci ka tii oo'i: “Ma əndətə nii kya nəhəpaa ŋga'ə, ci nə əndəkii, kəsəmə tə ci, una palə də gəranə tə ci ŋga'ə.” ");
INSERT INTO gde_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Mbu'unaakii, ca dzə paraŋə aaɓii Yeesu, əŋki ci, “Maləma.” Ca nəhəpaa tə ci ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Wata təya kəsətə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Wata rəŋwə agi ənji ŋga Yeesu ətə kəŋaanə davə a əlyagi ŋgila purəŋanaakii, ca patsəgi liminə ŋga mava ŋga gawə ŋga limanyinə. ");
INSERT INTO gde_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Əŋki Yeesu ka tii, “Mi shuunə ka kəsənə tə nyi ka ŋgila purəŋanə ka ŋgila purəŋanə, ka zala ka zala kwa? Ya saŋə əndə ɗa maabə nə nyi kwa? ");
INSERT INTO gde_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Uusəra patə, ka hakii naamə doonə, nya dzəgunə ka ənji asəkə *yi ŋga Əntaŋfə. Patə da ha'ə pooshi unə kəshi tə nyi. Amma ma ɗii ənə ha'ə əna, kaa sətə nyaahə ənji asəkə malaaɓa ləkaləkatə a ndzaa ka tantanyinə.” ");
INSERT INTO gde_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Wata lyawarənaakii patə a bwasee ka ci, təya huyipaa satii. ");
INSERT INTO gde_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Kəsənatii tə ci, təya palə. Tə'i əndə'i uundzə dagwa davə, ca nə'u tə ci. Wata gwadaakii əgəvə ci aashikii. Təya ɗa gazhi'waanə ŋga kəsənə tə ci, ");
INSERT INTO gde_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","wata ca səɗəpaa ka tii gwadakii, ca huyipaa saakii də purəki. ");
INSERT INTO gde_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ma ənjitə kəshi tə Yeesu, kə kirə tii tə ci aasii aa ha gawə ŋga limanyinə. Davə dzii madiigərə limanyinə da gayinə da maliminə də nə patə. ");
INSERT INTO gde_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ma Piita, ba'ə ba'ə gi ci də nə'unə tə i Yeesu kura'ə aasii aa ha gawə ŋga limanyinə. Ca ndzaanə ahada ənji nəhə yi ŋga Əntaŋfə, ca 'utə gunə. ");
INSERT INTO gde_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Ma madiigərə limanyinə da patənə ŋga *mətərəkinə, kə ali tii seeda anə Yeesu, kaa ənjə a shii ɓələginə tə ci. Amma pooshi tii upaa. ");
INSERT INTO gde_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Laŋə nə ənjitə laalii jirakənə aashikii, amma pooshi seedanatii ndzaanə mbərə mbərə. ");
INSERT INTO gde_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Wata hara ənjə a maɗətə, təya la jirakənə aashikii, ");
INSERT INTO gde_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","əŋki tii, “Kə fii inə ca ba oo'i, ka uulaginə nə ci yi ŋga Əntaŋfə ətə ghənyi ənji. Ma agi baanə makkə, ka ghənətənə nə ci ətə əntaa ghənənə ŋga ənda.” ");
INSERT INTO gde_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Amma patə da ha'a, pooshi seedanatii ndzaa mbərə mbərə. ");
INSERT INTO gde_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Wata gawə ŋga limanyinə a maɗə akəŋwacii ənji patə, ca ləgwa ama Yeesu, əŋki ci, “Pooshi waɓənaaku ŋga jikəvənə aagyanə waɓəətsə waɓi ənjitsə aashiku kwa?” ");
INSERT INTO gde_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Amma, ma Yeesu, majikəmə ci ka ci. Gawə ŋga limanyinə a ənə ka ləgwanə amakii, “Hə nə Aləmasiihu *Uuzənə ŋga Əntaŋfə kwa?” ");
INSERT INTO gde_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Yeesu a ba, “Awa nyi. Ka neenə nuunə əsə ka Uuzənə ŋga əndə dasə da ciizəma Əntaŋfə Əndə baawəɗa, una nee ka ci ca jima agyanə kuraɓiinə dadagyə.” ");
INSERT INTO gde_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Fanə ŋga gawə ŋga limanyinə ha'ə, wata ca tsəərəgi kəjeerənə ashikii, ca ba ka tii, “Gaama alə hara uushi'inə ma'ə. ");
INSERT INTO gde_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Kə fii unə, kə geegi ci ka naakii nə kədəhə da Əntaŋfə. Iitə nee unə noona?” Tii patə a lagi gəŋwanə ka Yeesu, əŋki tii, “Weewee, see a əntə ci.” ");
INSERT INTO gde_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Hara ənji agitii a gwaŋə ka tiifə giirənə aashiikii, təya ləkutəgi ginəkii, təya dəgə tə ci, əŋki tii, “Kuragi keenə taa wu digə tə hə.” Ənji nəhə yi ŋga Əntaŋfə a ŋgərə tə ci, təya dəgə tə ci də meeciinə. ");
INSERT INTO gde_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Ma Piita ma'ə dagərə asəkə yi ŋga gawə ŋga limanyinə, wata rəŋwə agi kadəmiitə ca slənə davə asii a shigi. ");
INSERT INTO gde_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Makə nee ki ka Piita ca 'utə gunə, kya tsaamə tə ci, əŋki ki, “Hə maa, rəŋwə nə hə agi ənji ŋga Yeesu əndə Nazaratu.” ");
INSERT INTO gde_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Amma ma Piita, kə hiwee ci, əŋki ci, “Mashiimə nyi sətsə cii kwa ba, paa nyi paaratəgi əsə.” Wata ca palə saakii aa uura mayi. Wata gyaagya a wa ka saa'ikii. ");
INSERT INTO gde_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Makə nee kadəmətə əsə ka Piita, kya ənə ka banə ka ənjitə davə oo'i, “Əndənə maa, əndə ŋga Yeesu nə ci.” ");
INSERT INTO gde_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Amma kə hiwee Piita əsə. Ta'avənə gi'u, wata ənjitə a ba ka ci: “Weewee, agitii nə hə tanyi, acii əndə Galili nə hə.” ");
INSERT INTO gde_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Wata Piita a gwaŋə ka nyaalya naakii na, ca jiiɗə, əŋki ci: “Mashiimə nyi tə əndətə cuuna ba.” ");
INSERT INTO gde_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Pii wata ga'ə gyaagya a wa ŋga bəra'inə. Fanə ŋga Piita ha'ə, wata ca buurətə sətə shi Yeesu a bii ka ci oo'i, “Ma taabu'u wanə gyaagya ŋga bəra'inə, ka jikənə nə hə makkə ka hiweenə ka shiinə tə nyi.” Buurətənaakii ha'ə, wata ga'ə ca wagi ka tuunə. ");
INSERT INTO gde_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Pukəpaanə ŋga ha, wata madiigərə limanyinə da gayinə da maliminə da patənə ŋga *mətərəkinə a dza də nə ka ɗa mətərəkinə. Təya ŋgərə tə Yeesu, təya anəgi tə ci, təya palə da ci, təya dzə ka viinə tə ci ka Pilaatu. ");
INSERT INTO gde_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Wata Pilaatu a ləgwa ama Yeesu, əŋki ci, “Hə nə ŋwaŋwə ŋga Yahudiinə kwa?” Əŋki Yeesu ka ci, “Hə bagi ha'ə.” ");
INSERT INTO gde_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Madiigərə limanyinə a gwaŋə ka ra tsaa səɗəkii də baaba bwayi waɓənyinə laŋə ashikii. ");
INSERT INTO gde_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","Wata Pilaatu a ənə ka ləgwanə amakii, “Pooshi hə ka jikəvənə kwa? Fawu ɓəzə waɓəətsə ci təya baaba aashiku.” ");
INSERT INTO gde_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Amma ma Yeesu, pooshi ci ənyi ka jikənə ka ci ma'ə. Wata ca ɗagi ka Pilaatu ka sə ŋga hurəshishinə. ");
INSERT INTO gde_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Zhi'wanə ŋga kumənə ŋga *Pasəka patə, agi kapaanə nə Pilaatu əndə furəshinə rəŋwə ətə ci ənjə a moo kaa ənjə a kapaa tə ci ka tii. ");
INSERT INTO gde_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Ma ka saa'ita, tə'i purətə haŋkala ŋga əndə asəkə furəshina tii da hara ənja. Ma ləməkii Barabasə. Waatoo, kə shi təya maɗee ka nə ŋga ənji ka panə asəkə vəranə, təya ɓəələgi ənja. ");
INSERT INTO gde_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Wata daɓaala a shi, təya kədii acii Pilaatu kaa ca ɗa ka tii sətə sənaavə ci ka ɗanə. ");
INSERT INTO gde_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Pilaatu a ləgwa amatii, əŋki ci, “Ka uuɗənə nuunə kaa nya kyapaa koonə tə ŋwaŋwə ŋga Yahudiinə kwa?” ");
INSERT INTO gde_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Patə kə shii Pilaatu oo'i, ma vii madiigərə limanyinə tə Yeesu ka ci, acii putə ŋga sərəha. ");
INSERT INTO gde_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Amma madiigərə limanyinə a tsəkutə ənji ka banə, wa ca kyapaa ka tii tə Barabasə. ");
INSERT INTO gde_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Əŋki Pilaatu ka tii, “Aa mi ɗii cuuna moo nya ɗa də əndənə cuuna 'wa ŋwaŋwə ŋga Yahudiina?” ");
INSERT INTO gde_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Təya jikəvə ka ci də ŋgeerənə, əŋki tii, “Wa ənjə a gwa'avə tə ci aashi ənfwa.” ");
INSERT INTO gde_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Əŋki Pilaatu, “Mi nə bwaya uushi ɗii ci kwa?” Wata təya tsakə ŋgəree ka uuratii də ŋgeerənə, əŋki tii, “Wa ənjə a gwa'avə tə ci aashi ənfwa.” ");
INSERT INTO gde_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Makə ɗii ci ŋga'ə ka Pilaatu nə uuɗagi səkə ŋga ənja, wata ca kapaa ka tii tə Barabasə, ca kavə ənji ka fəslənə tə Yeesu, ca vii tə ci əsə kaa ənjə a dzə ka gwa'avənə tə ci aashi ənfwa. ");
INSERT INTO gde_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Wata soojiinə a ŋgərə tə Yeesu, təya kərəgərə tə ci aasəkə yi ŋga ŋgwaməna, təya 'waanə tə hara soojiinə patə, ");
INSERT INTO gde_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","təya ŋgərə madizə gwada, təya əgəvə ka ci aashikii makə ŋga ŋwaŋwa. Təya ŋgərə dəha, təya fuuɗə makə madiŋəna, təya ŋgavə ka ci aanəkii. ");
INSERT INTO gde_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Təya gwaŋə ka nəhəpaanə tə ci, əŋki tii, “Wa əpinaaku a gərə aakəŋwa, ŋwaŋwə ŋga Yahudiinə!” ");
INSERT INTO gde_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Təya dəgə tə ci anəkii də zala, təya tiifə giirənə aashikii, təya gərə'waanə akəŋwaciikii makə ka haŋətənə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Makə uudəpaa tii ha'unə də ci, təya ŋgərəgi madizə gwadata, təya ŋgavə ka ci naakii kəjeerənə, təya kərə tə ci ka gwa'avənə tə ci aashi ənfwa. ");
INSERT INTO gde_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ma təya palə a rəgwa, wata təya guŋugərə da əndə'i əndə ɗii ləməkii Simoonə, əndə Sirina, dii i Aləkəsandəra da Rufusə, ca ənya də bilə. Guŋugərənatii, wata soojiinə a ŋgərəvə ka ci ənfwə ŋga gwa'avə tə Yeesu aashikii. ");
INSERT INTO gde_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Təya kərə tə Yeesu ka hatə ci ənjə a 'wa Gwaləgoota, makə bana, “Kəŋwə na.” ");
INSERT INTO gde_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Təya vii ka ci ma'i inabi gwazə da maŋgərəkiki kuzəka. Amma ca kaaree. ");
INSERT INTO gde_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Wata təya gwa'avə tə ci aashi ənfwa. Təya təəkəpaa kəjeerənaakii ahadatii də kwaaranə, kaa təya tagi ətə ci əndə a upaa. ");
INSERT INTO gde_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ma saa'itə gwa'avə ənji tə Yeesu aashi ənfwa, tibisə əliŋə deerənə. ");
INSERT INTO gde_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Təya naahəvə tə sətə ɗii ɓəli ənji tə ci, waatoo: ‘Ŋwaŋwə ŋga Yahudiinə’, təya tsa'avə danəkii. ");
INSERT INTO gde_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Təya gwa'avə əsə ənji maabə bəra'i aashi hara ənfuginə ataŋgala Yeesu, rəŋwə da ciizəmakii, rəŋwə da madzənakii.  ");
INSERT INTO gde_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ma ətsa, ma sətə nyaahə ənji asəkə malaaɓa ləkaləkatə oo'i, kə ləɓətəgi ənji də ci da ma'waslyakə ənja, kə ɗii ka tantanyinə. ");
INSERT INTO gde_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Ma ənji piitinə dadavə əsə, təya ha'u də ci, təya dzə də udzə də nətii, təya ba, “Yawaa, hə ətsə bii ka uulaginə nə hə *yi ŋga Əntaŋfə, ha ənə ka ghənətənə agi baanə makkə, ");
INSERT INTO gde_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","jimagərə ashi ənfutsa, ha luupaa naaku na.” ");
INSERT INTO gde_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ha'ə makə ətsə əsə ha'u madiigərə limanyinə da maliminə də ci ahadatii, əŋki tii, “Kə mbee ci ka luupaa hara ənja, amma kə təkuree ci ka luupaa naakii na. ");
INSERT INTO gde_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Əntaa kə bii ci, ci nə Aləmasiihu, ŋwaŋwə ŋga *Isərayiila? Wa ca jimagərə gadəvə ashi ənfutsa, kaama nee, ama vii ka ci gooŋga.” Ənjitə gwa'avə ənji ataŋgalakii maa, kə dzaanii tii tə ci əsə. ");
INSERT INTO gde_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Ma ətsə uusəra ahada na, kə ɗii təkunə anə hanyinəkii patə dəgwamə, dəŋə ka tibisə makkə ŋga kədəwanə. ");
INSERT INTO gde_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Ma ətsə tibisə makkə, wata Yeesu a ŋgəree ka uurakii, ca ka vurənə, əŋki ci, “Eelooyi, Eelooyi, lyama sabakətani?” makə bana, “'Ya'ə Əntaŋfwaakya, 'ya'ə Əntaŋfwaakya, ka mi bwasee hə ka nyi kwa?” ");
INSERT INTO gde_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Wata hara ənjitə kəŋə kəŋə davə ca fa tə ci, əŋki tii, “Waatsə ka 'wanə tə *Iliya.” ");
INSERT INTO gde_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Əndə'i əndə agitii a huyipaa, ca ŋgərə soosa, ca shimwatə agi mahwarəkinə, ca tsa'avə aama magərə kada. Wata ca vii aa dəgyə aama Yeesu kaa ca shiɓə, əŋki ci, “Gəraamə, kaama nee maɗa ka shinə nə Iliya ka jimagərənə də ci ashi ənfutsa.” ");
INSERT INTO gde_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Amma də ŋgeerənə kii Yeesu vurənə, ca əntəgi. ");
INSERT INTO gde_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Tə'i gwada wahə ama hatə palee də laaɓanə asəkə yi ŋga Əntaŋfə. Əntəginaakii ha'ə, wata pyaahu! gwadatə a təkəgi bəra'i, kəshanə dagyə kura'ə aa dəgərə. ");
INSERT INTO gde_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Ma gawə ŋga soojiinə, kəŋə nə ci ka tsaamənə tə Yeesu. Makə nee ci ka əntənaakii, wata əŋki ci, “Tantanyinə, ma əndətsa, uuzənə ŋga Əntaŋfə nə ci.” ");
INSERT INTO gde_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Tə'i hara makinə davə ca tsaama dzaɗə. Ahadatii nə i Mariyaama Magədalina, da Saloomi, ba'a Mariyaama məci i Yakubu uundzəkii tii da Yoosi. ");
INSERT INTO gde_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Tii nja nə'u tə ci, təya tsakə tə ci saa'itə nji ci də Galili. Tə'i hara makinə laŋə ca tsaamə əsə, ətə shi atsakii aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Ɗanə ŋga kədəwanə, makə ɗii ci, ma pukətə hakii, *uusəra ŋga əpisəka, ");
INSERT INTO gde_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","wata Yusufu əndə Aramatiya a shi. Ma ca, gawə nə ci ahada *mətərəkinə. Bislyə nə ci agi gəra saa'itə nə Əntaŋfə a ɗa ŋwaŋuunaakii əsə. Makə shi ci, ca satə uuɗəfa, ca dzə aaɓii Pilaatu, ca kədii rəgwa kaa ca dzə ka ŋgiragərə wə ŋga Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Fanə ŋga Pilaatu ha'ə, kə ɗii ka ci ka sə ŋga hurəshishinə nə fanə oo'i, kə uugi Yeesu əntəginə. Wata ca sləkee ka ənjə a 'wa tə gawə ŋga soojiinə, kaa ca ləgwa amakii maɗa ha'ə tanyi. ");
INSERT INTO gde_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Makə paaratəgi ci ha'ə ama gawə ŋga soojiinə oo'i, kə uugi ci əntəginə, wata ca vii rəgwa ka Yusufu. ");
INSERT INTO gde_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Yusufu a dzə ka ira marəma, ca dzə ka ŋgiragərə wə ŋga Yeesu, ca haɗətə asəkə marəməta, ca dzə ka baneenə ka ci asəkə gu'u ətə tələpaa ənji ashi pasla, ca dəlavə faara aama gu'ukii. ");
INSERT INTO gde_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Ma Mariyaama Magədalina tii da Mariyaama məci Yoosi, kə nee tii ka hatə banee ənji ka Yeesu asəkə gu'ukii. ");
INSERT INTO gde_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Dzəginə ŋga *uusəra ŋga əpisəka, wata i Mariyaama Magədalina da Mariyaama məci Yakubu ba'ə Saloomi a dzə ka iracii maaratə ca zənə ŋunyikii, kaa təya dzə ka ɓəzəpaa də wə ŋga Yeesu. ");
INSERT INTO gde_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Ma ətsə pədeerənə tsəɗakə uusəra alatə, təya maɗə, təya palə aama gu'uta. Təya mbu'u uusəra kə lə'ya. ");
INSERT INTO gde_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","Ma təya dzə a rəgwa, təya dzə də banə ahadatii, “Wu na dalagi kaamə faara ama gu'u kwa?” ");
INSERT INTO gde_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ma faarakii, maɗuunəkii dərəva. Ma təya tsaamə, wata ma təya nee, kə dzəgi faaratə ama gu'wa. ");
INSERT INTO gde_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Dəməgərənatii aasəkə gu'ukii, wata təya lapaa əndə'i uundzə dagwa dasə da ciizəma da i mambwaɗaɗa kəjeerənə ashikii. Neenatii ka ci, kə ɗii ka tii ka sə ŋga hurəshishinə. ");
INSERT INTO gde_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Əŋki ci ka tii, “Ga ca ɗa koonə ka sə ŋga hurəshishinə. Kə shii nyi, tə Yeesu əndə Nazaratu cuuna alə ətə gwa'avə ənji aashi ənfwə. Ma ca, kə ma'i ci agi maməətə ənja. Paa ci ma'ə ganə. Wiitsə hatsə shi ənjə a banee ka ci davə. ");
INSERT INTO gde_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amma ma ɗanuunə, dəmə ka banə ka lyawarənaakii da ka Piita oo'i, waatə ci na 'watəgi mbu'unə koonə aanə hanyinə ŋga Galili. Davə nuunə nee ka ci, makə sətə shi ca bii koonə.” ");
INSERT INTO gde_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Fanatii ha'ə, wata təya gimagi də shiraŋa asəkə gu'ukii. Shishinətii a dzə də udzənə acii ŋgwalənə ka shaŋə. Pooshi tii bii taa ka wu.  ");
INSERT INTO gde_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Ma daba'ə maɗənə ŋga Yeesu agi maməətə ənja, ətsə tsəɗakə uusərə alatə, kə jigagi ci də nəkii ka Mariyaama Magədalina, waatoo miitə shi ca lyaakagi ginaajinyinə məɗəfə ashitə. ");
INSERT INTO gde_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Neenatə ka ci, wata kya dzə ka banə ka ənjitə nja nə'u tə ci. Ma saa'ikii, kə lapaa ki tə tii ka ŋgəərə ma, təya dzə də tuunə. ");
INSERT INTO gde_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Amma makə fii tii oo'i, kə nee ki ka ci da i əpinə amakii, paa tii luuvə shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Ma daba'ə ətsə əsə, tə'i hara lyawarənaakii bəra'i, ca palə ka əndə'i uundzə vəranə. Wata ca jigagi ka tii, amma də əndə'i kəŋwaciinə pamə da ətə sənaavə tii ka neenə ka ci. ");
INSERT INTO gde_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wata təya ənə ka banə ka hara ənjatii, amma pooshi tii luuvə ka tii shaŋə. ");
INSERT INTO gde_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Ma daba'əkii, ca jigagi də nəkii ka lyawarənaakii pu'u aməntaŋə, tii agi zəma. Ca waza ka tii putə ŋga ghatə vii gooŋgatii da ndalənə ŋga mooɗəfətii. Acii pooshi tii luuvə waɓənə ŋga ənjitə 'watəgi neenə ka ci saa'itə ma'i ci. ");
INSERT INTO gde_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Wata ca ba ka tii, əŋki ci, “Dəmə aasəkə *duuniya taa dama patə, una waaza Ŋunyi Habara ka patənə ŋga ənji shiŋkinə. ");
INSERT INTO gde_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ma əndətə na vii gooŋga, ca luu yiɓə bapətisəma, ka upaanə nə ci luupaanə. Amma ma əndətə pooshi vii gooŋga, ka kəsənə nə gəŋwanə tə ci. ");
INSERT INTO gde_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Ma ənjitə na vii gooŋga, ka upaanə nə tii baawəɗa ŋga ɗa sə ŋga hurəshishinə. Waatoo, ka lyaakaginə nə tii ginaajinyinə də ləməki, ka waɓənə nə tii də uuranyinə kama kama. ");
INSERT INTO gde_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ka kəsənə nə tii rəhunə, ka saanənə nə tii ŋguma agi uushi, amma patə da ha'ə pooshi ka ɗanə tə tii. Ka kavənə nə tii ciinətii aashi ənji bwanea, təya upaa mbəɗənə əsə.” ");
INSERT INTO gde_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Ma daba'ə waɓənə ŋga Yeesu Slandana ha'ə ka lyawarənaakii, wata ca ndərəgi aadəgyə, ca dzə ka ndzaanə dasə da ciizəma Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Ma lyawarənaakii əsə, təya paalə taa dama patə ka waazanə. Slandanə a dzə də slənənə da tii, ca ɗa sə ŋga hurəshishinə daciitii, ka ɓaariinə ka ənji oo'i, tantanyinə nə waazanatii.");
INSERT INTO gde_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","Wiinə waɓənə cii kya naahə ka hə ɗii Tawəfilasə maɗuunəkii. Ənji laŋə ɗii gazhi'waanə ŋga naahə uushi'iitə ɗaaɗii ahadeenə. ");
INSERT INTO gde_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Kə nyaahə tii makə sətə fii inə a ma ənjitə nee də ginətii təkəŋwanə, ətə ndzaanə ka ənji waaza waɓənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","Ma nyi əsə, kə caamə nyi də haŋkala agyanə sətə ɗaaɗii daga ŋukə. Acii ha'ə kə nee nyi, maɗa naahətə nyi ka hə sətə ɗaaɗii kada'ə kada'ə, ka ɗanə ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","Ma ɗii nyi ha'a, kaa ha shii oo'i, ma sətə jigunyi ənji ka ha, gooŋga tanyi. ");
INSERT INTO gde_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Ma agi zamanatə ɗii *Hirudusə ŋwaŋuunə agyanə hanyinə ŋga Yahudiya, tə'i əndə'i *limanə ɗii ləməkii Zakariya. Ma ca, agi kurəgə ŋga limanyinə ŋga Abiya ŋga ŋukə nə ci. Ilizabeetə nə ləmə ŋga minaakii. Ma kya, agi slikərənə ŋga *Haruna, maɗuunə limanə, shigi ki. ");
INSERT INTO gde_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","Ma tii da minaakii, ənji gooŋga nə tii akəŋwacii Əntaŋfə kyakya'ə. Agi nə'utənə nə tii sətə bii Slandanə patə də rəgwakii. ");
INSERT INTO gde_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amma pooshi tii upaa uuzənə, acii ma minaakii Ilizabeetə, əntaa mitə poo nə ki. Tii kyakya'ə əsə, kə uugi tii sasaranə. ");
INSERT INTO gde_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Ma ka əndə'i uusəra, makə zhi'wa saa'i ŋga slənə ŋga kurəgətə ɗii Zakariya agikii, kə gi Zakariya ka ɗa slənə asəkə *yi ŋga Əntaŋfə makə sətə izee limanyinə ka ɗanə. ");
INSERT INTO gde_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Ma sətə ci limanyinə a ɗa, ka kuratənə nə tii ahadatii taa wu nə dzənə ka ɗəzə urədya a kumu ga Əntaŋfə. Ma saa'ikii, tə Zakariya kuryagi tii. ");
INSERT INTO gde_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Ma ca ɗəzə urədya a kumu, ma ənjitə agyə patənatii, təya ɗa də'wa. ");
INSERT INTO gde_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Ma ci ma'ə agi ɗəzə urədya, wata kə jigagi malaa'ika ŋga Əntaŋfə ka ci. Ca kəŋaanə da ciizəma hatə ci limanyinə a ɗəzə urədya. ");
INSERT INTO gde_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Makə nee Zakariya ka ci, wata kə kəsəgi ŋgwalənə tə ci, mashiimə ci sə ŋga ɗanə. ");
INSERT INTO gde_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Wata əŋki malaa'ika ka ci, “Zakariya ga ha ŋgwalə, acii kə fii Əntaŋfə də'waaku. Ma minaaku Ilizabeetə, ka poonə nə ki ka hə uundzə ŋgura, kadə nii kwa ɗəkə ka ci ləmə Yoohana. ");
INSERT INTO gde_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Kadə ɗanə nə hə maŋushinə da mooɗasəka putaakii. Kadə na ndzaanə ka sə ŋga maŋushinə ka ənji patə əsə. ");
INSERT INTO gde_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Acii kadə nii kəya ndzaanə ka gawə əndə akəŋwacii Əntaŋfə. Paa ci na sa ma'i inaba, taa əndə'i sə ŋga sanə ətə ca ka əndə agyanə, paa ci na sa. Kadə ndzaanə nə Malaaɓa Ma'yanə da ci daga asəkə məci əsə. ");
INSERT INTO gde_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Kadə ənyatəginə nə ci də ənji ɓəzəkii agi ənji *Isərayiila kaa təya nə'u tə Əntaŋfə Slandana. ");
INSERT INTO gde_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Kadə nii kəya upaa ŋgeerənə ŋga Ma'yaatə slənyi ashi anabi *Iliya. Kadə nii kəya takəŋwanə ka Slandana, ca haɗatəgi də manjeevənə da dəsənətii, ca ənyatəgi aa rəgwa də ənjitə naanagi ka nə'unə tə Əntaŋfə, kaa təya ndzaanə da haŋkala, təya nə'u tə Əntaŋfə. Kadə nii kəya tasəkatə tə ənji kaa təya gəra shinə ŋga Slandana.” ");
INSERT INTO gde_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Wata əŋki Zakariya ka malaa'ikata, “Də mi saŋə shiinəki oo'i, gooŋga nə sətsə bii hə ka nya? Acii ma nya, kə uugi nyi iirənə; minaaki əsa, kə paləgi fəzə ŋga pawatə.” ");
INSERT INTO gde_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","Əŋki malaa'ikatə ka ci, “Nyi nə Jibərila, akəŋwacii Əntaŋfə nə nyi ka ɗa sləna. Ci sləkee ka nyi kaa nya waɓə ka hə, nya ba ka hə ŋunyi habaratsa. ");
INSERT INTO gde_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amma maluuvəmə hə oo'i, gooŋga nə sənə bii nyi ka hə. Amma shiiwə oo'i, maɗa kə mbu'ya uusərakii, kadə na ɗa ha'ə. Aciikii ka ɗaginə nə hə ka masə gana; pa ha mbee ka waɓənə maɗaamə səndə bii nyi ka hə kə ɗii.” ");
INSERT INTO gde_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Ma saa'itə i malaa'ika da Zakariya a waɓə ha'a, gəranə nə ənji tə ci agyə. Ka ha'ə kə ɗii ka tii ka sə ŋga hurəshishinə nə təkurənə ŋga Zakariya a kumu ga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Makə gimagi Zakariya, mambeemə ci ka waɓənə da ənji ma'ə. Davə shii tii oo'i, tə'i uushi ŋga hurəshishinə nee ci a kumu ga Əntaŋfə. Də ciinə waɓi ci ka tii. ");
INSERT INTO gde_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Makə uugi saa'i ŋga slənə ŋga Zakariya asəkə yi ŋga Əntaŋfə, ca palə saakii aasii. ");
INSERT INTO gde_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Ma daba'ə ətsə ha'ə, wata kə ɗasəkii minaakii Ilizabeetə. Kə ɗii ki ləgiɗə tufə asii ka hakii, manjimə ta dzə ka ha, əŋki ki: ");
INSERT INTO gde_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Wiinə səndə ɗii Əntaŋfə ka putaaki: kə nee ci ka təgunuunaaki; kə luupaa ci tə nyi, pooshi ma'ə ayinə agiki.” ");
INSERT INTO gde_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Makə ɗii Ilizabeetə ləgiɗə kuwa də ɗasəka, wata Əntaŋfə a ənə ka sləkeenə ka malaa'ikatə ɗii ləməkii Jibərila aasəkə vəranə ŋga Nazaratu, anə hanyinə ŋga Galili. ");
INSERT INTO gde_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Ma sləkee Əntaŋfə ka ci, aaɓii əndə'i kadəma ətə ɗii ləmətə Mariyaama. Ma kya, maɗanə ŋga əndə'i əndə nə ki ətə ɗii ləməkii Yusufu. Agi slikərənə ŋga ŋwaŋwə *Dawuda shigi ci. ");
INSERT INTO gde_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Shinə ŋga malaa'ika aaɓii Mariyaama, wata əŋki ci ka ki, “Ɗawə maŋushinə. Acii kə ɗii Əntaŋfə ka hə pwapoonə. Kədəhə nə Slandanə da hə.” ");
INSERT INTO gde_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Makə fii Mariyaama waɓənə ŋga malaa'ikatə ha'ə, wata kə kəɗəpaa tə ki. Kya gwaŋə ka buurənə oo'i, uushi mi saŋə bii waɓəətsa? ");
INSERT INTO gde_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Wata əŋki malaa'ikatə ka ki, “Mariyaama, ga ha ŋgwalə. Acii kə ɗii Əntaŋfə ka hə pwapoonə. ");
INSERT INTO gde_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Fatə ŋga'ə: ka ɗasəkanə nə hə, ka poonə nə hə uundzə ŋgura, ha ɗəkə ka ci ləmə Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Ka ndzaanə nə ci ka gawə əndə dərəva. Ka 'wanə nə ənji tə ci *Uuzənə ŋga Əntaŋfə, Əndə məghərəvənə ka shaŋə. Ka viinə nə Əntaŋfə ka ci ŋwaŋuunə makə sətə vii ci ka *Dawuda dzədzəci. ");
INSERT INTO gde_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Aciikii ka ɗanə nə ci ŋwaŋuunə agyanə ənji Isərayiila ka ca'ə ndəŋwə ndəŋwə. Pooshi ŋwaŋuunaakii ka uudənə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Əŋki Mariyaama ka malaa'ika, “Iitə ɗanə səkii ha'ə, acii ma nya, ma'ə nyi kadəma.” ");
INSERT INTO gde_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Əŋki malaa'ika ka ki, “Ka shinə nə Malaaɓa Ma'yanə aagyanəku, ka zaɗətənə nə Əntaŋfə Əndə baawəɗa tə hə, ci Əndə məghərəvənə ka shaŋə. Aciikii ma uuzəətə nii kwa pawa, malaaɓakii nə ci; ka 'wanə nə ənji tə ci: Uuzənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Ma Ilizabeetə duurə goonə, taa ŋgahi kə uugi ki iirənə, kə bii ənji masaawa nə ki əsə, amma kuwanə ŋga ləgiɗatə əna də ɗasəka. Ka poonə nə ki uundzə ŋgura. ");
INSERT INTO gde_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Acii pooshi sətə palee ka ŋgeerənə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Əŋki Mariyaama, “Ma nya, ŋga Əntaŋfə nə nyi da nəki. Wa Əntaŋfə a ɗa ka nyi makə səndə bii hə.” Wata malaa'ikatə a unee ka ki, ca palə saakii. ");
INSERT INTO gde_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Ma daba'əkii, kə ma'i Mariyaama, kya palə pii pii aasəkə əndə'i vəranə agi giŋunyinə, anə hanyinə ŋga Yahudiya. ");
INSERT INTO gde_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Mbu'unatə aa dəvə, kya dəməgərə aasii aa ha Zakariya, kya nəhəpaa tə Ilizabeetə. ");
INSERT INTO gde_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Makə fii Ilizabeetə nəhəpaanə ŋga Mariyaama tə ki, wata guguɗənə nə uuzənə asəkətə. Dəməgərənə nə Malaaɓa Ma'yanə aasəkə ədzəmətə. ");
INSERT INTO gde_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Wata kya ŋgəree ka uuratə, əŋki ki, “Kə ɗii Əntaŋfə ka hə barəkaanə palee ka harii makinə patə. Tə'i barəkaanə ashi uuzəətsə nii kwa poo əsə.” ");
INSERT INTO gde_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Kya tsakə, əŋki ki, “Wu saŋə nə nyi bahə məci Slandanəki a shi aaɓiikya? ");
INSERT INTO gde_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Acii kə nee hə, makə fii nyi nəhəpaanaaku tə nyi, wata guguɗənə nə uuzənə asəkəki, guguɗənə ŋga mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Ma ha, tə'i barəkaanə ashiku, acii ma sətə bii Slandanaamə ka hə ka ɗanə, kə luuvə hə.” ");
INSERT INTO gde_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Wata əŋki Mariyaama: “Wanyinə ca dəla də Slandana, ");
INSERT INTO gde_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Kə ɗii nyi maŋushinə də Əntaŋfə Maluwaaki. ");
INSERT INTO gde_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","Acii kə tsaaməgi ci aagiki, nyi talaka, mavaakii. Weewee daga ənshinə ka banə nə ənji patə ka jiji ka jiji oo'i, əndə barəkaanə nə nyi. ");
INSERT INTO gde_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","Acii kə ɗii Əntaŋfə ka nyi maɗuunə uushi, ci Əndə baawəɗa, Malaaɓa Ənda. ");
INSERT INTO gde_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Agi ɗanə nə ci ŋga'əənə ka jiji ka jiji ka ənjitə ca ŋgwalə tə ci. ");
INSERT INTO gde_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Kə ɗii ci maŋgwaarə sləna, kə taakee ci ka ənjitə ca ɗuunətə natii nə rəŋwə rəŋwə. ");
INSERT INTO gde_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Kə jimagərə ci də meeminə anə dəgələ ŋga ŋwaŋuunatii, ca vigi madzəgamə ha ŋga ndzaanə ka talakiinə. ");
INSERT INTO gde_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Ənji maɗəfəna, kə əburətəgi ci də tii də ŋunyi uushi'inə. Ma ənji gəna, kə laakəənə ci tə tii də maɗəfənə. ");
INSERT INTO gde_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Kə shi ci ka tsakənə tə ənji Isərayiila, ənji slənaakii, acii mazaanəmə ka ci nə sətə shi ca bii ka dzədzəshi'inaamə oo'i, ka ɗanə nə ci ŋga'əənə ka Ibərahiima da i ka jijinaakii ka ca'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Kə ɗii Mariyaama bahə ləgiɗə makkə ga Ilizabeetə. Ma daba'əkii, kya maɗə, kya palə satə aasii. ");
INSERT INTO gde_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Makə mbu'i saa'i ŋga poonə ŋga Ilizabeetə, wata kya poo uundzə ŋgura. ");
INSERT INTO gde_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Fanə ŋga guvayinyinə da duurənyinatə oo'i, kə ɗii Əntaŋfə ka ki ŋga'əənaakii, wata təya ɗa mooɗasəkə ka hakii da ki. ");
INSERT INTO gde_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Makə ɗii uuzənə luuma rəŋwə, ənjə a shi ka *ryaminiyagi tə ci. Kə mwayi tii ɗəkə ka ci ləmə Zakariya, makə ŋga dii. ");
INSERT INTO gde_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","Əŋki məci, “Aa'a, wa ənjə a ɗəkə ka ci ləmə: Yoohana.” ");
INSERT INTO gde_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","Əŋki hara ənji ka ki, “Amma pooshi əndə agi duurənyinə goonə ətə ɗii ləməkii ha'ə.” ");
INSERT INTO gde_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Makə nee ənji ha'ə, wata ənjə a ləgwa ka dii də ciinə kaa təya shii taa iitə cii kəya moo ɗəkə ləmə ka uuzənaakii. ");
INSERT INTO gde_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Wata Zakariya a ləgwa sə ŋga naahənə anəkii, ca naahətə, “Yoohana nə ləməkii.” Neenə ŋga ənji ha'ə, kə kəŋee ka tii patə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Ma Zakariya a uudəpaa naahəginə ha'ə, wata ca ənəgərə ka waɓənə makə ŋga ŋukə. Ca ndzaŋə dəlanə də Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Amma, ma ətsə ha'ə, kə ŋgwalee ka guvayiinaakii patə. Ka ha'ə kə dəlagi haalakii asəkə patənə ŋga vəranyiitə agi giŋunyinə agyanə hanyinə ŋga Yahudiya. ");
INSERT INTO gde_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Ma ənjitə fii sətə ɗaaɗii patə, wata təya ndzaŋə buurənə agyanəkii. Əŋki tii, “Ya uuzəətsa, iitə nii kəya ndzaana?” Ma bii tii ha'ə, acii kə nee tii, ma uuzəətsə kamə, weewee kə ndzaa Əntaŋfə Slandanə da ci. ");
INSERT INTO gde_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Ma Zakariya dii Yoohana, kə dəməgərə Malaaɓa Ma'yanə aasəkə mooɗəfəkii. Wata ca ɗa anabaakwaanə, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“Wa ənjə a ɗuunətə tə Slandana, Əntaŋfə ŋga ənji Isərayiila, acii kə shi ci ka tsakənə tə ənjaakii, kə luupaa ci tə tii. ");
INSERT INTO gde_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","Kə kəŋee ci kaamə ka Maluu əndə baawəɗa agi slikərənə ŋga Dawuda, lawaraakii. ");
INSERT INTO gde_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Ci nə sətə shi Əntaŋfə a bii da ma malaaɓa anabiinaakii daga ŋukə, oo'i: ");
INSERT INTO gde_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Ka luupaanə nə ci taamə acii ənji mbiinə gaamə i acii ənjitə ca usha taamə patə. ");
INSERT INTO gde_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Ha'ə ɗii Əntaŋfə ŋga'əənaakii ka dzədzəshi'inaamə, kə buurətə ci malaaɓa aləkawalətə anyi ci da tii, ");
INSERT INTO gde_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","waatoo jiɗətə ji'i ci ka Ibərahiima dzədzəshi'inaamə oo'i, ");
INSERT INTO gde_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","Kadə nii kəya luupaa taamə acii ənji mbiinə gaamə, kaama mbee ka slənənə ka ci yadə ŋgwalənə, ");
INSERT INTO gde_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ama ndzaanə malaaɓakii, ənji gooŋga akəŋwaciikii, ha'ə muudinə ŋga baanə gaamə patə. ");
INSERT INTO gde_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","Ma hə əsə, uuzənaakya, kadə nə ənjə a 'wa tə hə anabi ŋga Əntaŋfə Əndə məghərəvənə ka shaŋə. Acii kadə nii kwa takəŋwanə ka Slandanə kaa ha haɗatəgi ka ci də rəgwa. ");
INSERT INTO gde_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","Waatoo ka ɓaariinə nə hə ka ənjaakii oo'i, agi luupaanə nə Əntaŋfə tə tii də tifyagi ka tii 'waslyakəənatii. ");
INSERT INTO gde_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Ma Əntaŋfə gaamə, laŋə nə ci ka nəhə təgunuunə gaamə dərəva, agi ɗa kaamə ŋga'əənə nə ci. Ka kavənə nə ci kaa ɓərəətə na luupaa taamə a lə'ya. ");
INSERT INTO gde_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Ma ɓərəətsa, kaa ca ɓərə ka ənjitə agi ŋgəra'wə ca ŋgwalə acii wa; ca kərə taamə ka rəgwa jamənə.” ");
INSERT INTO gde_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Ma Yoohana, gərənə nə ci, dzənə nə haŋkalaakii də tsakənə. Ca ndzaanə ahada bilinə, ha'ə mbu'i uusəra ŋga jigaginaakii ka ənji *Isərayiila. ");
INSERT INTO gde_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","Ma agi zamanatə pwayi ənji tə Yoohana, tə'i maɗuunə ŋwaŋwə ŋga ha də Rooma ətə ɗii ləməkii Agusətusə. Kə bii ci oo'i, a naahətə ənji ləmə ŋga ənji patə agyanə hanyinaakii. ");
INSERT INTO gde_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","Ci nə təkəŋwatə naahənə, ətə ɗii agi ŋwaŋuunə ŋga Kiriniyusə, ŋgwaməna ŋga hanyinə ŋga Siriya. ");
INSERT INTO gde_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Aciikii patənə ŋga ənja, kə ma'i tii, kə pyalə tii aa vəra aa hatii, kaa ənjə a dzə ka naahəvə ləmətii. ");
INSERT INTO gde_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","Wata Yusufu a maɗə də Nazaratu anə hanyinə ŋga Galili, ca palə aa Bayitilaama anə hanyinə ŋga Yahudiya, hatə pwayi ənji tə ŋwaŋwə *Dawuda. Acii, ma ca, agi slikərənə ŋga Dawuda shigi ci. ");
INSERT INTO gde_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","Kə gi tii ka naahə ləmətii da minaakii Mariyaama. Ma saa'ikii, ki də ɗasəka. ");
INSERT INTO gde_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","Ma tii ma'ə də Bayitilaama, wata kə mbu'ya uusəra ŋga poonə ŋga Mariyaama. Ma'upaamə tii ha ŋga ndzaanə a kuvə mu'uminə. Aciikii kə gi tii aasəkə kuvətə nji dabanyinə a ndzaanə davə. Wata Mariyaama a poo uundzə ŋgura, təkəŋwatə pawatə. Kya ləkutətə tə ci də kadəmbula, kya banee ka ci asəkə sətə ci dabanyinə a zəmə asəkəkii. ");
INSERT INTO gde_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Ma davə agyanə hanyinəkii, tə'i magəriinə də bilə ca nəhə dabanyinatii davəɗə. ");
INSERT INTO gde_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Wata ma təya nee, wiitsə malaa'ika ŋga Əntaŋfə Slandanə kə jigagi ka tii, ɗuunuunə ŋga Əntaŋfə a ləkutətə tə tii. Ɓərənə nə ha agyanətii makə doosərə. Wata dzabala a dzagi tə tii. ");
INSERT INTO gde_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","Əŋki malaa'ika ka tii, “Goona ŋgwalə. Acii ma shinaaki, ka ba koonə ŋunyi habara ətə na ɗa maŋushinə ka patənə ŋga ənja. ");
INSERT INTO gde_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Waatoo, ma ənshinə davəɗə, kə pwayi ənji koonə Maluwa, asəkə vəranə ŋga Dawuda; ci nə *Aləmasiihu Slandana. ");
INSERT INTO gde_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Wiinə sətə na ɓaarii koonə tə ci: ka lanə nuunə idənə uuzənə maləkutəkii də kadəmbula, pərəɓə asəkə sətə ci dabanyinə a zəmə asəkəkii.” ");
INSERT INTO gde_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Pii wata wiitsə daɓaala ŋga malaa'ikanyinə, təya ləɓəgərə da malaa'ikata, təya dəla də Əntaŋfə, əŋki tii: ");
INSERT INTO gde_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Ŋga Əntaŋfə nə ɗuunuunə dagyə; ka ənjitə uu'i ci agi duuniya də jamənə.” ");
INSERT INTO gde_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Wata malaa'ikanyiitə a unee ka magəriitə, təya ənə satii aadəgyə, wata əŋki magəriinə ahadatii, “Ma ɗanaama, dzaamə aa Bayitilaama əndzə'i əndzə'i kaama dzə ka neenə də ginaamə ka səndə sləkee Əntaŋfə ka malaa'ikaakii ka banə kaamə.” ");
INSERT INTO gde_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Wata təya maɗə, təya palə aa Bayitilaama pii pii. Mbu'unatii, təya lapaa tə i Mariyaama da Yusufu; wiinə idənə uuzənə əsə pərəɓə asəkə sətə ci dabanyinə a zəmə asəkəkii. ");
INSERT INTO gde_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","Makə nee tii ka idənə uuzənə, təya ndzaŋə baaba sətə bii malaa'ikatə ka tii agyanə uuzəətə. ");
INSERT INTO gde_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Kə ɗii ka ənji patə ka sə ŋga hurəshishinə nə sətə ndzaa magəriitə ka baabanə. ");
INSERT INTO gde_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Amma, ma Mariyaama, kə kəsəpaa ki waɓəətsə patə agi haŋkalatə, kya kaala hiimatə agyanəkii. ");
INSERT INTO gde_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Ma daba'əkii, magəriitə a ənə satii. Təya dzə də ɗuunətənə tə Əntaŋfə, təya dəla də ci. Acii ma sətə fii tii da sətə nee tii də ginətii pata, weewee makə sətə bii malaa'ikatə ka tii lapaa tii. ");
INSERT INTO gde_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Makə ɗii luuma rəŋwə, kə mbu'ya uusəra ŋga *ryaminiyagi uuzənə. Wata ənjə a ryaminiyagi tə ci, ənjə a ɗəkə ka ci ləmə Yeesu, makə sətə shi malaa'ikatə a bii ka məci, ki ma'ə maɗasəkamə. ");
INSERT INTO gde_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Yoo, kə mbu'i uusəra ŋga ɗa sətə bii bariya ŋga Muusa kaa ŋugiginə a ɗa kaa təya ənə ka ndzaanə malaaɓakii. Wata təya ŋgərə uuzənə, təya kərə tə ci aasəkə vəranə ŋga Urusaliima ka kapaanə tə ci akəŋwacii Əntaŋfə Slandanə kaa ca ndzaanə ka naakii. ");
INSERT INTO gde_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Acii tə'i manaahəkii asəkə bariya ŋga Slandanə, oo'i, “Taa ŋgutə təkəŋwatə pawa, maɗa uundzə ŋgura, wa ənjə a kapaa akəŋwacii Əntaŋfə kaa ca ndzaanə ka naakii.” ");
INSERT INTO gde_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","Ma gi tii əsa, i ka vii sə ŋga ɗa də sataka, makə sətə bii bariya ŋga Əntaŋfə, waatoo kurəkutiinə bəra'i taa uuji bilyamasariinə bəra'i. ");
INSERT INTO gde_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Tə'i əndə'i əndə də Urusaliima ɗii ləməkii Simiyoonə. Əndə gooŋga nə ci. Agi ŋgwalənə nə ci tə Əntaŋfə. Ma ca, agi gəra shinə ŋga əndə luupaanə tə ənji *Isərayiila nə ci bislya. Kə ndzaa Malaaɓa Ma'yanə da ci əsə. ");
INSERT INTO gde_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Kə bii Malaaɓa Ma'yanə ka ci, “Paa ha əntə maɗaamə hə kə nee ka Aləmasiihu, waatoo *Mataɗəkii ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Ma ka əndə'i uusəra, kə kirə Malaaɓa Ma'yanə tə Simiyoonə aasəkə yi ŋga Əntaŋfə. Makə kira i dii Yeesu da məci tə uuzənə aa dəvə əsə ka ɗaaɗa ka ci uushi'iitə baabii Əntaŋfə asəkə ləkaləkatə, ");
INSERT INTO gde_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","wata Simiyoonə a nee ka ci, ca ŋgərətə tə ci də bəra'itə cii. Ca kuyirii tə Əntaŋfə, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“'Ya'ə Slandana, ma ənə ɗii əna, ma sətə shi ha bii, kə ɗatə hə tanyi. Aciikii agi jamənə nə nyi. Ka mbeenə nə hə ka kapaa ka nyi rəgwa, kaa nya dzə aa vəra. ");
INSERT INTO gde_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","Acii kə nee nyi də ginəki saaki ka əndənə sləkee hə kaa ca shi ka luupaa ənja. ");
INSERT INTO gde_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","Taa wu patə əsa, ka shiinə nə ci oo'i, agi luupaanə nə hə ənja. ");
INSERT INTO gde_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Ci nə maɓərə hatə na ɓaarii tə hə ka patənə ŋga ənji agi duuniya; ci əsə na ɗuunətə tə ənjaaku Isərayiila.” ");
INSERT INTO gde_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Fanə ŋga i dii da məci tə sətə ndzaa Simiyoonə ka baabanə agyanə uuzənatii, kə ɗii ka tii ka sə ŋga hurəshishinə dərəva. ");
INSERT INTO gde_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Wata Simiyoonə a kəgya ka tii barəkaanə acii Əntaŋfə. Ma daba'əkii, əŋki ci ka Mariyaama məci Yeesu, “Kə nee hə ka uuzəəna, Əntaŋfə ta'i tə ci. Ɓəzəkii nə ənji Isərayiila a puu'u putaakii, ɓəzəkii nə ənjə a mbəɗə əsə. Ka ndzaanə nə ci ka əndətə na ɓaarii oo'i, ma Əntaŋfə, agi ɗa slənə nə ci. Amma ka kaareenə nə ənji ka ci. ");
INSERT INTO gde_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Də ha'ə makə ətsa, ka kuzhi'yaginə nə ci maŋgəɗə uushə a ədzəmə ɓəzə ənja. Ma hə naaku, Mariyaama, kadə zəmənə nə ədzəməku tə hə, makə də ŋgila jiɓə ənji tə hə.” ");
INSERT INTO gde_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Tə'i əndə'i minə ɗii ləmətə Hanatu. Anabi nə ki. Uuzənə ŋga Fanuyilə agi slikərənə ŋga Asarə nə ki. Ma kya, iirə minə nə ki, kə fəzhi ki tighəsə pu'unə aji ənfwaɗə. Fəzə məɗəfə tanə ɗapaa tii da ŋgurii, ca əntəgi. ");
INSERT INTO gde_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Ma kya, kə iirə ki agi mooryafiinə. Mabwaseemə ki ka ndzaanə asəkə yi ŋga Əntaŋfə. Agi gərə'unə nə ki ka Əntaŋfə taa guci patə. Waatoo, kya ɗa də'wa, kya ɗa suumaya əsə. ");
INSERT INTO gde_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Ma saa'itə kira ənji tə Yeesu, kə dzəənə ki ɗaŋə, wata ki maa, kya ndzaŋə kuyiriinə tə Əntaŋfə. Kya waɓə haala ŋga uuzəətə ka patənə ŋga ənjitə ca gəra luupaanə ŋga Əntaŋfə tə Urusaliima. ");
INSERT INTO gde_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Makə uudəpaa i Yusufu da Mariyaama ɗaaɗagi sətə bii bariya ŋga Slandanə patə, təya ənə satii aa hatii aa vəra, waatoo aa Nazaratu anə hanyinə ŋga Galili. ");
INSERT INTO gde_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Gərənə nə uuzənə, ca dzə də upaa ŋgeerənə da hiima. Kə ɗaanə Əntaŋfə ka ci barəkaanə əsə. ");
INSERT INTO gde_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Taa ŋgutə fəzə patə, maɗa zhi'wa kumənə ŋga *Pasəka, agi dzənə nə i dii Yeesu da məci aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Makə ɗii Yeesu fəzə pu'u aji bəra'i, təya 'waanə tə ci aa Urusaliima ka kumənəkii makə sətə izee ənji ka ɗanə. ");
INSERT INTO gde_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Uudənə ŋga kumənəkii, təya maɗə ka palənə satii aasii. Asee, ma Yeesu, kə ənəgi ci saakii də Urusaliima. Amma, mashiimə i dii da məci. ");
INSERT INTO gde_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","Ma nə tii ka nəhənə, ahada hara ənjitə gi tii nə ci. Təya kagi uusəra pa'ə ka wiinə. Makə ɗii ci, maneemə tii ka ci, təya gwaŋə ka aalənə tə ci ahada duura da i ahada ənjitə shii tə tii. ");
INSERT INTO gde_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","Makə maneemə tii ka ci, təya ənəgərə cəkwə aa Urusaliima də aalənə tə ci. ");
INSERT INTO gde_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Təya lapaa tə ci ka makkənə ŋga uusəra asəkə yi ŋga Əntaŋfə, ci dasə aɓii maliminə ŋga *Yahudiinə. Ca fa sətə nji təya baaba, ca laagwa ka tii uushi'inə. ");
INSERT INTO gde_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Ənjitə nja fa waɓənaakii patə, kə ɗii ka tii ka sə ŋga hurəshishinə, acii də haŋkala nji Yeesu a jiikə ka maliminə. ");
INSERT INTO gde_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Makə nee i dii da məci ka ci aɓii maliminə ha'ə, kə ɗii ka tii ka sə ŋga hurəshishinə ŋgaaŋga'ə. Wata əŋki məci ka ci, “Uuzənaakya, ka mi ɗii hə diinə ha'ə kwa? Kə nee hə, kə sakəlagi haŋkala geenə da duu ɗii ka ha ŋga aalənə tə hə.” ");
INSERT INTO gde_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Wata Yeesu a jikəvə ka tii, əŋki ci, “Ka mi njuuna aalə tə nya? Mashiimuunə oo'i, kə dəɓee nya ndzaanə ga Daadə asii kwa?” ");
INSERT INTO gde_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Amma, mashiimə tii ginə ŋga sətə bii ci ka tii. ");
INSERT INTO gde_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Wata ca maɗə, ca palə atsatii aa Nazaratu. Agi baneenə nə ci ka nəkii akəŋwaciitii uusəra patə. Ma məci, kə kəsəpaa ki uushi'iitsə ɗaaɗii patə agi haŋkalatə. ");
INSERT INTO gde_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Gərənə nə Yeesu, tsakənə nə hiimaakii. Kə kaɗeesəkə ci ka Əntaŋfə da i ka ənji əsə. ");
INSERT INTO gde_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Ma agi pu'u aji tufənə ŋga fəzə ŋga ŋwaŋuunə ŋga Tibeeriyasə, maɗuunə ŋwaŋwə ŋga ha də Rooma, Puntiyu *Pilaatu nə ŋgwaməna agyanə hanyinə ŋga Yahudiya; *Hirudusə nə ŋwaŋwə anə hanyinə ŋga Galili. Ma anə hanyinə ŋga Ituriya da anə hanyinə ŋga Tarakunitisə, Filibusə ndzəkəŋuci Hirudusə nə ŋwaŋwa. Ma anə hanyinə ŋga Abilyanə əsə, Lisaniyasə nə ŋwaŋwa. ");
INSERT INTO gde_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","*Anasə da Kayafasə nə gayinə ŋga limanyinə ka saa'ikii. Agi saa'ikii əsə bagərə Əntaŋfə waɓənaakii ka Yoohana, uuzənə ŋga Zakariya, ci agi bilinə. ");
INSERT INTO gde_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","Aciikii kə wiigi'i ci agyanə hanyiitə ama gəərə Urədunə patə, ca dzə də waazanə ka ənja, əŋki ci, “Uneemə ka ɗa 'waslyakəənə, una baanə ka Əntaŋfə, ənjə a yiɓə koonə bapətisəma, kaa Əntaŋfə a tifyagi koonə 'waslyakəənə goonə.” ");
INSERT INTO gde_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Waatoo kə ɗii makə sətə nyaahə anabi Isaaya asəkə malaaɓa ləkaləkatə, ətə bii ci: “Wiitə əndə ca kaala agi bilinə, əŋki ci: Haɗatəgimə də rəgwa ka Slandana, kəŋeemə ka ci ka rəgwa. ");
INSERT INTO gde_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Ŋgəəɗətəmə maguɗaŋə ha; ga giŋwə da təpura a ndzaanə. Kəŋeemə ka madaada rəgwanyinə, ŋgəərəgimə faariinə davə. ");
INSERT INTO gde_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Ka neenə nə ənji patə makə sətə luupaa Əntaŋfə ənja.” ");
INSERT INTO gde_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Makə nee Yoohana ka ənjitə shiishi aaɓiikii kaa ca ɗaaɗa ka tii bapətisəma, wata əŋki ci ka tii, “Unə rəhunyinə, goona səkəpaanə ka banə oo'i, ka mbərəɗənə nuunə acii maɓətəsəkə ŋga Əntaŋfə ətə na shi. ");
INSERT INTO gde_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Amma ma ɗanuuna, slənəmə sətə ca ɓaarii oo'i, kə baa unə ka Əntaŋfə. Goona səkəpaanə ka banə əsə oo'i, ka mbərəɗənə nuunə, acii ɗii Ibərahiima ka dzədzəshi'inuunə. Wanyinə ka banə koonə: ma Əntaŋfə, ka mbeenə nə ci ka zhi'weenə ka faariinyiina, təya ndzaa ka jijinyinə ŋga Ibərahiima! ");
INSERT INTO gde_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Ma əsə, tə'i raha acii, ka cisləginə də ənfuginə ka slərəginətii. Taa ŋgutə ənfwə nəndə pooshi ka poonə ŋga'ə, ka cisləginə nə ənja, ənjə a kagərə aagi gunə.” ");
INSERT INTO gde_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Wata daɓaala a ndzaŋə laagwanə a ma Yoohana, əŋki tii, “Mi ɗaniinə əna?” ");
INSERT INTO gde_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Əŋki ci ka tii, “Ma əndətə ɗii kəjeerənaakii bəra'i, wa ca ŋgərə əndə'i, ca vii ka əndətə pooshi naakii. Ma əndətə da zəmə əsa, wa ca ndii ka əndətə ka maɗəfənə.” ");
INSERT INTO gde_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","*Ənji luu tsəka a shi aaɓiikii əsə, kaa ca ɗaaɗa ka tii bapətisəma. Təya ləgwa ka ci, əŋki tii, “Ya inə əna, mi ɗaniinə daa Maləma?” ");
INSERT INTO gde_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Əŋki Yoohana ka tii, “Goona laagwa tsəka acii ənji palee ka sətə bii bariya.” ");
INSERT INTO gde_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Soojiinə a shi. Təya ləgwa a makii əsə, “Ya inə neena, maci ka dəɓəna, mi ɗaniina?” Əŋki ci ka tii, “Ma ɗanuuna, goona guutsətə uushi'inə acii ənji də ŋgeerənə taa də jaarakənə ashitii. Amma luumə shikwa ŋga slənə goonə tanə.” ");
INSERT INTO gde_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Fanə ŋga ənji ha'ə, wata təya ndzaŋə kaala hiima agyanə Yoohana oo'i, ci nə *Aləmasiihu. ");
INSERT INTO gde_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Wata əŋki Yoohana ka tii patə, “Ma nya, də ma'inə cii kya ɗa koonə bapətisəma. Amma tə'i əndətə palee ka nyi də ɗuunuunə na shi. Mambu'umə nyi bahə pərəgi zə'u ŋga ɓiɓinaakii. Ma ca, kadə nii kəya ɗa koonə bapətisəma də Malaaɓa Ma'yanə da gunə. ");
INSERT INTO gde_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Tə'i ɗəvə bə'unaakii ŋga bə'ugi də səkəŋwa. Ka fəɗənə nə ci səkəŋwaakii, ca əjigərə aa əjimə. Amma, ma lyaafa, ka dzatəginə nə ci, ca pukəgərə aagi gunə ətə pooshi ka əntənə.” ");
INSERT INTO gde_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Dagi baaba ɓəəzə waɓənə kama kama ha'ə waazii Yoohana Ŋunyi Habara ka ənja. ");
INSERT INTO gde_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Ma ŋwaŋwə *Hirudusə, kə ŋgərəma ci tə Hiroodiya minə ŋga ndzəkəŋuci ka ci saakii. Makə wazhi Yoohana ka ci acii ɗanə ha'ə da hara bwaya uushi'iitə ɗaaɗii ci, ");
INSERT INTO gde_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","wata ca tsakə ɗa bwaya bwayaanə, ca kagərə tə Yoohana aa furəshina. ");
INSERT INTO gde_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Makə upaa patənə ŋga ənjitə bapətisəma, kə upaa Yeesu da i ci əsə. Ma ci ka ha ŋga ɗa də'wa, wata wunəginə nə səkəntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Malaaɓa Ma'yanə a jima aanəkii; ənjə a nee ka ci makə kurəkuta. Wata uura ŋga əndə a waɓya dadagyə, əŋki ci, “Hə nə Uuzənaaki. Kə uu'i nyi tə hə. Hə ca uuɗagi səkəki.” ");
INSERT INTO gde_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Ma Yeesu, kə 'watəgi ci də slənaakii ci fəzə bahə makkə pu'unə. Patənə ŋga ənja, ma nji təya nəhə, uuzənə ŋga Yusufu nə ci. Yoo, ma Yusufu, uuzənə ŋga Heeli; ");
INSERT INTO gde_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ma Heeli, uuzənə ŋga Matatə; ma Matatə, uuzənə ŋga Leewi; ma Leewi, uuzənə ŋga Meeləki; ma Meeləki, uuzənə ŋga Yanayə; ma Yanayə, uuzənə ŋga Yusufu; ");
INSERT INTO gde_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ma Yusufu, uuzənə ŋga Matatiya; ma Matatiya, uuzənə ŋga Amwasə; ma Amwasə, uuzənə ŋga Nahumə; ma Nahumə, uuzənə ŋga Heesli; ma Heesli, uuzənə ŋga Nagayə; ");
INSERT INTO gde_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ma Nagayə, uuzənə ŋga Maata; ma Maata, uuzənə ŋga Matatiya; ma Matatiya, uuzənə ŋga Səmeenə; ma Səmeenə, uuzənə ŋga Yoosəkə; ma Yoosəkə, uuzənə ŋga Yooda; ");
INSERT INTO gde_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ma Yooda, uuzənə ŋga Yoowanan; ma Yoowanan, uuzənə ŋga Reesa; ma Reesa, uuzənə ŋga Jərubaabila; ma Jərubaabila, uuzənə ŋga Salaatiyalə; ma Salaatiyalə, uuzənə ŋga Neeri; ");
INSERT INTO gde_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ma Neeri, uuzənə ŋga Meeləki; ma Meeləki, uuzənə ŋga Adi; ma Adi, uuzənə ŋga Koosamə; ma Koosamə, uuzənə ŋga Iləmadamə; ma Iləmadamə, uuzənə ŋga Eeri; ");
INSERT INTO gde_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ma Eeri, uuzənə ŋga Yeesu; ma Yeesu, uuzənə ŋga Iliyazara; ma Iliyazara, uuzənə ŋga Yoorimə; ma Yoorimə, uuzənə ŋga Matata; ma Matata, uuzənə ŋga Leewi; ");
INSERT INTO gde_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ma Leewi, uuzənə ŋga Simoonə; ma Simoonə, uuzənə ŋga Yahuda; ma Yahuda, uuzənə ŋga Yusufu; ma Yusufu, uuzənə ŋga Yoonamə; ma Yoonamə, uuzənə ŋga Iliyakimə; ");
INSERT INTO gde_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ma Iliyakimə, uuzənə ŋga Məliya; ma Məliya, uuzənə ŋga Meena; ma Meena, uuzənə ŋga Matata; ma Matata, uuzənə ŋga Natanə; ma Natanə, uuzənə ŋga *Dawuda; ");
INSERT INTO gde_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ma Dawuda, uuzənə ŋga Jasii; ma Jasii, uuzənə ŋga Oobyadə; ma Oobyadə, uuzənə ŋga Boowazə; ma Boowazə, uuzənə ŋga Saləmoona; ma Saləmoona, uuzənə ŋga Naasunu; ");
INSERT INTO gde_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ma Naasunu, uuzənə ŋga Aminadaba; ma Aminadaba, uuzənə ŋga Adəminə; ma Adəminə, uuzənə ŋga Arəni; ma Arəni, uuzənə ŋga Hisəruunu; ma Hisəruunu, uuzənə ŋga Fareesə; ma Fareesə, uuzənə ŋga Yahuda; ");
INSERT INTO gde_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ma Yahuda, uuzənə ŋga Yakubu; ma Yakubu, uuzənə ŋga Isiyaaku; ma Isiyaaku, uuzənə ŋga Ibərahiima; ma Ibərahiima, uuzənə ŋga Tara; ma Tara, uuzənə ŋga Nakoorə; ");
INSERT INTO gde_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ma Nakoorə, uuzənə ŋga Saruku; ma Saruku, uuzənə ŋga Ragawə; ma Ragawə, uuzənə ŋga Falikə; ma Falikə, uuzənə ŋga Ibeerə; ma Ibeerə, uuzənə ŋga Sala; ");
INSERT INTO gde_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ma Sala, uuzənə ŋga Kayinamə; ma Kayinamə, uuzənə ŋga Arəfasada; ma Arəfasada, uuzənə ŋga Seemə; ma Seemə, uuzənə ŋga Nuuhu; ma Nuuhu, uuzənə ŋga Lamikə; ");
INSERT INTO gde_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ma Lamikə, uuzənə ŋga Matusala; ma Matusala, uuzənə ŋga Anuuhu; ma Anuuhu, uuzənə ŋga Iyaridə; ma Iyaridə, uuzənə ŋga Mahalaleelə; ma Mahalaleelə, uuzənə ŋga Kayinamə; ");
INSERT INTO gde_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","ma Kayinamə, uuzənə ŋga Inoosə; ma Inoosə, uuzənə ŋga Seetu; ma Seetu, uuzənə ŋga Adamu; ma Adamu əsə, uuzənə ŋga Əntaŋfə nə ci. ");
INSERT INTO gde_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Ənyaginə ŋga Yeesu asəkə gəərə ŋga Urədunə, manakii də Malaaɓa Ma'yanə. Wata Ma'yanəkii a kərəgərə tə ci aahada bilinə. ");
INSERT INTO gde_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Baanə ənfwaɗə pu'unə ɗii Seetanə ka təɓənə tə ci agi bilinə. Pooshi Yeesu kavə zəmə aa makii agi baatsə ənfwaɗə pu'unə shaŋə. Makə dzəgi baatsə ha'ə, wata kə mbee maɗəfənə ka ci. ");
INSERT INTO gde_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Wata əŋki Seetanə ka ci, “Makə ɗii ci *Uuzənə ŋga Əntaŋfə nə hə, bawə ka faaratsa, wa ca zə'ugi ka zəma.” ");
INSERT INTO gde_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Wata əŋki Yeesu ka ci, “Tə'i manaahəkii tuu'ina, əntaa də zəmə daanəkii mbəɗənə ənda.” ");
INSERT INTO gde_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Kə kərəgi Seetanə tə Yeesu ka maɗaŋə ha. Ca ɓaarii ka ci hanyinə ŋga duuniya patə makə dəɗə dəha. ");
INSERT INTO gde_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Əŋki ci ka ci əsə, “Ka viinə nə nyi ka hə baawəɗa da wahəkii patə, acii kə vii ənji ka nyi uushi'iitsə patə. Ka mbeenə nə nyi ka viinə ka əndətə mwayi nyi əsə. ");
INSERT INTO gde_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Aciikii ma ha, maɗa ka paslənə nə hə tə nyi, ka viinə nə nyi ka hə uushi'iitsə patə.” ");
INSERT INTO gde_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","Yeesu a ba ka ci, “Tə'i manaahəkii tuu'ina, ka Əntaŋfə Slandanəku daanəkii gərə'unəku, tə ci daanəkii paslənəku əsə.” ");
INSERT INTO gde_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Ma daba'əkii əsə, kə kirə Seetanə tə Yeesu aa Urusaliima. Ca kəŋee ka ci ka makiɗakiɗaŋənə ŋga maɗuunə kuvə ŋga Əntaŋfə, əŋki ci ka ci: “Makə ɗii ci Uuzənə ŋga Əntaŋfə nə hə tanyi, ləɗəgərə aa panə. ");
INSERT INTO gde_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","Acii tə'i manaahəkii tuu'ina, ka banə nə Əntaŋfə ka malaa'ikanyinaakii, kaa təya nəhətə tə hə. ");
INSERT INTO gde_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","Da əsə: Təya kətsa'utə tə hə də ciinətii acii ga ha dəgəgi taa səɗəku anə faara.” ");
INSERT INTO gde_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","Yeesu a ba ka ci, “Ma bii malaaɓa ləkaləkatə, Ga ha təkə tə Əntaŋfə Slandanəku.” ");
INSERT INTO gde_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Makə uugi Seetanə təəɓəginə tə Yeesu də rəgwa kama kama patə, ca maɗə, ca palə saakii see ka əndə'i uusəra. ");
INSERT INTO gde_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Ma daba'əkii, Yeesu a ənya aanə hanyinə ŋga Galili. Manakii nə ci də Malaaɓa Ma'yanə. Kə dəlagi haalaakii anə hanyinə ŋga Galili patə. ");
INSERT INTO gde_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Wata ca dzə ka dzəgunənə ka ənji asəkə *kuvə də'wanyinə ka vəra ka vəra. Ənji patə a dəla də ci. ");
INSERT INTO gde_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Ma ka əndə'i uusəra, kə mbu'i Yeesu aa Nazaratu, vəraatə girə ci davə. Makə mbu'i *uusəra ŋga əpisəka, ca maɗə, ca dzə aasəkə kuvə də'wa makə sətə izee ci ka ɗanə. Ca maɗətə kaa ca jaŋga ləkaləkatə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","Ənjə a vii ka ci ləkaləkatətə nyaahə anabi Isaaya. Makə wunəgi ci, ca lapaa hatə nyaahə ənji oo'i: ");
INSERT INTO gde_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Tə'i Ma'yanə ŋga Slandanə ashiki. 1.2,5,8; 2.4,17,18 Acii kə ta'i ci tə nyi, kaa nya ba Ŋunyi Habara ka matəgunyinə. Kə sləkee ci ka nyi kaa nya waazanə ka ənjitə makəəsəkii, təya upaa kapaanə tə tii; nya ba ka muurəfinə əsə, ka wunənə nə ginətii; ənjitə ca sa ciɓə əsə, ka mbəɗənə nə tii. ");
INSERT INTO gde_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","Kə sləkee Əntaŋfə Slandanə ka nyi əsə ka ba fəzətə nii kəya ɗa pwapoonaakii ka ənja.” ");
INSERT INTO gde_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Makə uudəpaa ci jaŋganə, ca pa'ətə ləkaləkatəkii, ca ənəpaagi ka əndə nəhə kuvə də'wa, ca ndzaanə. Patənə ŋga ənji gatə a kuvə də'wa, aagikii nə ginətii patə. ");
INSERT INTO gde_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Wata Yeesu a ndzaŋə waɓənə ka tii, əŋki ci, “Ma waɓəətsə jaŋgii nyi, ənshinə ɗii ka tanyi makə sətə fii unə jaŋgii nyi.” ");
INSERT INTO gde_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Patənə ŋga ənja, kə dəlii tii də ci. Makə waɓi ci ka tii dagwakii, kə ɗii ka tii ka sə ŋga hurəshishinə, əŋki tii, “Əntaa uuzənə ŋga Yusufu ətsa?” ");
INSERT INTO gde_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Wata əŋki Yeesu ka tii, “Kə shii nyi ŋgufə koonə nə banə ka nyi oo'i: Ma hə ənə ca mbəɗəpaa də ənja, mbəɗəpaa də naaku na. Ma uushi'iitə ɗaaɗii hə də Kafarənahumə fii ina, ɗawə tsarəkii ganə gaku də vəra əsə.” ");
INSERT INTO gde_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Ca tsakə banə ka tii, əŋki ci, “Tantanyinə cii kya ba koonə: pooshi ənji vəranə ŋga *anabi ka gaɗeenə ka ci. ");
INSERT INTO gde_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Buurətəmə sətə shi a ɗii agi zamana ŋga anabi *Iliya: kə ɗii fəzə makkə da ləgiɗə kuwa mandzəməmə vəna, kə ɗii məza maɗəfənə agyanə hanyinə patə. Ma ka uusərakii, ŋgaaŋga'ə nə mooryafinə anə hanyinə ŋga *Isərayiila. ");
INSERT INTO gde_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amma, patə da ha'ə, pooshi Əntaŋfə sləkee ka Iliya taa aa ha wu agitii. Wata aa ha əndə'i mooryafa də Sarapəta anə hanyinə ŋga Sidoonə tanə sləkee Əntaŋfə ka ci. ");
INSERT INTO gde_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Ma agi zamana ŋga anabi Ilisa əsa, ŋgaaŋga'ə nə ənji uyikuzənə agyanə hanyinə ŋga Isərayiila. Amma, patə da ha'ə, pooshi əndətə mbə'i agitii patə. Amma wata Naamanə, əndə Siriya mbə'i.” ");
INSERT INTO gde_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Fanə ŋga ənjitə asəkə kuvə də'wa patə, wata kə ɓəzəgi səkətii. ");
INSERT INTO gde_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","Ghərə təya maɗətə patə, təya əlyagi tə ci, təya kiragi tə ci aanə giŋutə ɗii vəranatii ashikii, kaa təya mbee ka vugəgyagərənə tə ci aa panə ka rəgwa ŋga manjirəŋəkii. ");
INSERT INTO gde_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","Amma, ma Yeesu, kə dzəgi ci saakii ahadatii, kə gi ci ka ha ŋga dzənaakii. ");
INSERT INTO gde_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Ma daba'əkii, Yeesu a mbu'u aa Kafarənahumə, əndə'i vəranə agyanə hanyinə ŋga Galili. Ma dava, kə jigunyi ci ka ənji *uusərə ŋga əpisəka. ");
INSERT INTO gde_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Makə fii tii dzəgunənaakii, kə ɗii ka tii ka sə ŋga hurəshishinə, acii də shiinaakii saakii cii kəya dzəgunə ka tii. ");
INSERT INTO gde_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Ma gatə asəkə *kuvə də'wa, tə'i əndə'i əndə da ginaaji ashikii. Wata ca gwaŋə ka wazənə də ŋgeerənə, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Kwaawu! Yeesu, əndə Nazaratu, mi nə uushi gaamə a pa da hə kwa? Kə shi hə ka zamaginə diinə kwa? Kə shii nyi taa wu nə hə: Malaaɓa Əndətə sləkee Əntaŋfə nə hə.” ");
INSERT INTO gde_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Wata Yeesu a la ŋguruunə ka ginaajita, əŋki ci, “Ndzaawə kəɗa'ə! Dzəgi ashi əndətsa.” Ginaajitə a sləbəgi tə əndətə ɗadalə akəŋwacii ənji patə, ca shigi saakii, maɗamə ci taa mi də əndətə ma'ə. ");
INSERT INTO gde_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Ənjitə nəhee pata, kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə. Təya ba ahadatii, “Mi nə uushi ha'ə makə ətsa? Ma əndəna, agi waɓənə nə ci ka ginaajiinə də ŋgeerənə, da baawəɗa əsə, kaa təya shigi; təya shigi tanyi.” ");
INSERT INTO gde_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Də ha'ə waazagi habaraakii taa dama patə anə hanyinəkii. ");
INSERT INTO gde_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Makə shigi Yeesu asəkə kuvə də'wa, wata ca dzə aa ha Simoonə aasii. Ma gi ci, gwakə nə sərəhu ŋga Simoonə minəkii. Kə tsəfəgi shishinətə iza'u ka shaŋə. Wata ənjə a kədii tə ci kaa ca mbəɗəpaa də ki. ");
INSERT INTO gde_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Yeesu a əntsahətə aaɓitə, ca gwaŋaanə dagyanətə, ca la ŋguruunə ka sətə ca zəmə tə ki. Wata bwaneatə a dzəgi. Miitə a maɗətə, kya gwaŋə ka ɗa ka tii zəma. ");
INSERT INTO gde_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Ma ətsə kulagərənə ŋga uusəra, ənjitə ɗii ənjatii magwaakəkii də bwaneanyinə kama kama patə, wata təya kyaara tə tii ka Yeesu. Yeesu a ɗəkəvə ciinəkii agyanətii də rəŋwə rəŋwə. Ca mbəɗəpaa də tii patə. ");
INSERT INTO gde_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Kə shigi ginaajiinə ashi ənji ŋgaaŋga'ə əsə də wazənə, əŋki tii ka Yeesu, “*Uuzənə ŋga Əntaŋfə nə hə!” Amma Yeesu a la ka tii ŋguruunə, ca təŋagi waɓənə a matii, acii ma təya, kə shii tii oo'i, ci nə Aləmasiihu. ");
INSERT INTO gde_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Pukənə ŋga ha, Yeesu a maɗə, ca palə ka hatə pooshi ənji davə. Daɓaala a ndzaŋə aalənə tə ci. Makə lii tii tə ci, kə mwayi tii səkəpaanə tə ci. Mamoomə tii ca dzəgi aɓitii shaŋə. ");
INSERT INTO gde_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","Amma kə waɓi Yeesu ka tii, əŋki ci, “Ma kamə, ŋga'ə ka nyi nə dzənə ka harii vəranyinə, acii tyasə kə dəɓee nya waaza Ŋunyi Habara agyanə *ŋwaŋuunə ŋga Əntaŋfə davə əsə. Acii ka ətsə ha'ə sləkee Əntaŋfə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Də ha'ə gi ci də waazanə asəkə kuvə də'wanyinə agyanə hanyinə ŋga Yahudiya. ");
INSERT INTO gde_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Ma ka əndə'i uusəra, kə gi Yeesu, ca kəŋaanə ama uunəvə ŋga Ginazarətə. Ənjə a shi laŋə aaɓiikii, dzaadzashinə nə tii, acii kə mwayi tii fa waɓənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Ma nee Yeesu, wiitə kumbawalənyinə bəra'i ama ndzaŋa. Kə jaamagərə slanjiinəkii aa panə, təya caakuɓə slaaɗənyinatii. ");
INSERT INTO gde_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Wata Yeesu a ndərə aasəkə əndə'i kumbawalə ŋga əndə'i əndə ahadatii ɗii ləməkii Simoonə. Ca ba ka ci, “Əntsahəgərə də kumbawalənaaku gi'u ahada ma'inə.” Makə əntsahəgərəgi Simoonə də kumbawalətə, wata Yeesu a ndzaanə, ca ndzaŋə dzəgunə waɓənə ŋga Əntaŋfə ka daɓaala. ");
INSERT INTO gde_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Makə uudəpaa Yeesu waɓənə, ca ba ka Simoonə, “Ma ɗanəkwa, ŋgəruu kumbawalə, kəruu ka hatə ɗii ma'inə kurəŋə. Kaalavəmə slaaɗənyinə goonə da ənjaaku, koona upaa hərəfinə.” ");
INSERT INTO gde_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","Əŋki Simoonə ka ci, “Daadə, kə ba'agiinə həmə ka təəmənə ta'a, amma taa gazha ŋga hərəfinə maneemiinə! Amma, makə ɗii ci hə bii keenə a ɗeenə ha'ə, takwa, kaa nya kaalagərə slaaɗənyinə.” ");
INSERT INTO gde_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Makə kaalagərə tii slaaɗənyinə, kə upaa tii hərəfinə ŋgaaŋga'ə ha'ə makə a tsaatsagi slaaɗənyinatii. ");
INSERT INTO gde_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Təya 'waa'wa tə hara ənjinyiitə asəkə əndə'i kumbawalə də ciinə, kaa təya shi ka tsakənə tə tii. Shinə nə ənjita, təya naanatə kumbawalənyinatii kyakya'ə də hərəfinə. Wata ɗanə nə kumbawalənyinə makə liipənə aagi ma'inə acii zəzəkəənə ŋga hərəfinə. ");
INSERT INTO gde_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Makə nee Simoonə Piita ha'ə, wata ca kulagi atsaa səɗə Yeesu, ca ba ka ci, “Əntsahəgi saaku Slandanəki, acii ma nya, ma'waslyakə əndə nə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Ma bii Simoonə ha'a, acii kə ŋgwalee ka tii da ənjaakii nə ɓəəzəənə ŋga hərəfiitə upaa tii ha'ə. ");
INSERT INTO gde_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Kə ŋgwalee əsə ka i Yakubu da Yoohana, manjeevənə ŋga Zabadiya, waatoo ənjinyiitə ca slənə ka hakii da Simoonə. Əŋki Yeesu ka Simoonə: “Ga ha ŋgwalə. Əntaa təəmə hərəfinə nə slənaaku ma'ə; amma daga ənshinə, təəmə ənji nə slənaaku.” ");
INSERT INTO gde_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Wata i Simoonə da ənjitə ci təya slənə da ci a maanyapaagi də kumbawalənyinə aanə ndəra, təya bwasee ka uushi'iitə patə, təya nə'u tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Ma ətə Yeesu asəkə əndə'i vəranə, wata əndə uyikuzənə a mbu'ya. Neenaakii ka Yeesu, ca gərə'waanə akəŋwaciikii, ca kədii tə ci, əŋki ci: “Tuutəta'ə Slandanəkya, maɗa ka luuvənə nə hə, ka mbeenə nə hə ka mbəɗəpaanə də nyi kaa nya shii ndzaanə malaaɓakii.” ");
INSERT INTO gde_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","Wata Yeesu a təɗapaa ciinəkii, ca təɓətə tə ci, ca ba ka ci, “Awa, kə luuvə nyi. Mbəɗuu.” Pii wata uyikuzənətə a dzəgi ashi əndətə. ");
INSERT INTO gde_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Yeesu a ɗa ka ci bariya, əŋki ci, “Ga ha bapaa ka əndə sətə ɗii shaŋə. Amma, ma ɗanəku, duu aa ha *limanə, ha ɓaarii ka ci naaku na, ca tsaamətə taa iitə nə hə. Ma daba'əkii, ha ɗa sataka makə sətə bii Muusa, kaa ənji patə a shii oo'i, kə mbə'i hə tanyi.” ");
INSERT INTO gde_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Amma, patə da ha'ə, agi dzənə nə ləmə ŋga Yeesu də waazanə aakəŋwə aakəŋwa. Wata dzaadzadənə nə daɓaala ka fa sətə ci Yeesu a ba i kaa ca mbəɗəpaa də ənji bwaneatə agitii. ");
INSERT INTO gde_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","Amma, ma Yeesu, taa guci patə agi dzənə nə ci ka ɗa də'wa ka hatə pooshi əndə davə. ");
INSERT INTO gde_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Ma ka əndə'i uusəra, Yeesu a dzəgunə waɓənə ŋga Əntaŋfə ka ənja. Tə'i *Farisanyinə da i maliminə dasə dasə aɓiikii. Kə shi tii daga asəkə patənə ŋga vəranyinə agyanə hanyinə ŋga Galili da agyanə hanyinə ŋga Yahudiya i də Urusaliima. Ma Yeesu, tə'i baawəɗa ŋga Əntaŋfə ashikii ŋga mbəəɗəpaa də ənji bwanea. ");
INSERT INTO gde_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Tə'i hara ənji kira mahurəməsə əndə pərəɓə asəkə ədza. Kə ali tii rəgwa ŋga dəməgərəginə də ci aasii ka yitə ɗii Yeesu davə, ka baneenə ka ci akəŋwaciikii. ");
INSERT INTO gde_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","Amma kə təkuree tii ka upaa rəgwa acii ɓəzəkii nə ənja. Wata təya ndərəgi aanə kuva, təya tələgi nə ŋga kuvəta, təya ŋgərə mahurəməsə əndətə patə da i ədzaakii, təya jimagərəgi də ci dadavə, ɗaŋə dahadahadanə ŋga daŋkana akəŋwacii Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Makə nee Yeesu kə gi'i ənjinyiitə tə ci, əŋki ci ka əndə bwaneatə: “Əndəna, kə upaa hə tifyaginə ŋga 'waslyakəənaaku.” ");
INSERT INTO gde_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Makə fii maliminə da Farisanyinə ha'ə, wata təya ndzaŋə kaala hiima də banə oo'i, “Wu da nə əndənə ca geegi ka naakii nə makə Əntaŋfwa? Wu saŋə ca mbee ka tifyagi 'waslyakəənə ŋga ənda, maɗaamə Əntaŋfə rəŋwə dyaŋa?” ");
INSERT INTO gde_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Asee, ma Yeesu, kə shii ci sətə a ədzəmətii patə. Əŋki ci ka tii: “Ka mi də tsarə ŋga hiimatsə a nuunə ha'ə kwa? ");
INSERT INTO gde_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Ŋgutə palee də ŋgufənə saŋa? Gəɗə banə ka ci oo'ya, kə upaa hə tifyaginə ŋga 'waslyakəənaaku nii, anii gəɗə banə ka ci, Maɗuu, wiiwa? ");
INSERT INTO gde_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","Amma takumə kaa nya ɓaarii koonə oo'i, ma nyi Uuzənə ŋga ənda, tə'i nyi da baawəɗa ŋga tifyagi 'waslyakəənə ŋga ənji ganə a duuniya.” Wata əŋki ci ka mahurəməsə əndəta, “Wanyinə ca ba ka hə, maɗətə, ŋgəruu ədzaaku, ha palə saaku aasii.” ");
INSERT INTO gde_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Wata hatsə əndətə a maɗətə akəŋwacii ənji patə. Ca ŋgərə ədzaakii, ca palə saakii aasii, ca dzə də dəlanə də Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ma patənə ŋga ənjitə dava, kə dzəgəpaa tə tii ka shaŋə. Wata təya ɗuunətə tə Əntaŋfə. Kə ŋgwali tii ŋgaaŋga'ə, təya ba, “Kə nee amə ka sə ŋga hurəshishinə ənshinə.” ");
INSERT INTO gde_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Ma daba'əkii, kə shigi Yeesu agyə. Wata ca lapaa tə əndə luu tsəka, ətə ɗii ləməkii Leewi. Dasə a kumu nə ci ka ha ŋga ɗa slənaakii. Əŋki Yeesu ka ci, “Shiwa atsaki.” ");
INSERT INTO gde_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Wata Leewi a maɗətə, ca bwasee ka uushi'iitə gatə patə, ca nə'u tə ci. ");
INSERT INTO gde_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Wata Leewi a dzə ka dzəgə əndzanə ka Yeesu gakii asii. Ɓəəzə *ənji luu tsəka da hara ənji saakii əsa, kə liɓə tii da i Yeesu anə zəməta. ");
INSERT INTO gde_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Makə nee Farisanyinə da maliminatii ha'ə, təya ŋguŋgunə. Wata əŋki tii ka lyawarənə ŋga Yeesu, “Mi saŋə ɗii cuuna zəmə, una saasa uushi'inə da ənji luu tsəka, i da ma'waslyakə ənji ka ha rəŋwa?” ");
INSERT INTO gde_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Wata əŋki Yeesu ka tii, “Pooshi mandandaŋə ənji ka alə kuzəka, see ənji bwanea. ");
INSERT INTO gde_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Ma shi nyi aasəkə duuniya, əntaa kaa nya 'wa tə ənjitə ca slənə uushi də rəgwakii, amma ka 'waa'wanə tə ma'waslyakə ənji aaɓiiki, kaa təya unee ka 'waslyakəənatii, təya baanə ka Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Əŋki tii ka Yeesu, “Ma *lyawarənə ŋga Yoohana, kə izee tii ka ɗa suumaya da də'wa. Ha'ə nə lyawarənə ŋga Farisanyinə əsə. Amma, ma lyawarənaaku natii, pooshi tii ka ɗanə ha'ə.” ");
INSERT INTO gde_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Yeesu a ənigi ka tii də waɓənə agyanə naakii nə, əŋki ci, “Yaci tə'i guviinə ŋga dagwa maɗanə ətə bii ci ka tii da məhuraakəya, maɗa kə gi tii ka luu maɗanəkəya, ka kavənə nə ənji tə tii ka ɗa suumaya kwa? Pooshi. ");
INSERT INTO gde_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Amma kadə nə uusəra a mbu'ya ətə nə ənjə a ŋgərəgi dagwa maɗanə aɓitii; saa'ikii nə təya ɗa suumaya.” ");
INSERT INTO gde_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Yeesu a ɗa ka tii əndə'i misaali, əŋki ci, “Pooshi əndə ca tsəərə kura kəjeerənə ka mbakənə də iirəkii. Maɗa kə ɗii ha'ə, ka saawaginə nə kura kəjeeriita. Pooshi kurakii ka ndzaŋənə da iirəkii əsə shaŋə. ");
INSERT INTO gde_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","“Pooshi əndə ca ciirə kura ma'i inabi aasəkə iirə mbuurə kuvə'unə. Maɗa kə ɗii ha'ə, ka taginə nə mbuurə kuvə'unəkii acii əbunə ŋga ma'i inabi. Wata ma'i inabi a əjagi saakii, mbuurə kuvə'unə a saawagi əsə. ");
INSERT INTO gde_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ma dəɓee, aasəkə kura mbuurə kuvə'unə ciirənə ənji kura ma'i inabi. ");
INSERT INTO gde_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Maɗa kə sii əndə ma'i inabi ətə uugi ta'avənə, paa ci ka moo sa kurakii ətə ma'ə ka əbunə. Ma banəkəya, ətə uugi ta'avənə palee də ŋga'əənə ka ətə ma'ə ka əbunə.” ");
INSERT INTO gde_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Ma ka əndə'i uusəra, waatoo uusəra ŋga əpisəka, paləginə nə Yeesu da lyawarənaakii dasəkə ra, waatoo rə ŋga aləkamaara. Ma ca dza, dzənə nə tii də əɓiiyə mana aləkamaara, təya takəɗə, təya tsəɓə. ");
INSERT INTO gde_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Ma dava, tə'i hara *Farisanyinə. Makə nee tii ha'ə, təya ba ka tii: “Ka mi cuuna ɗa sətə maviimə *bariya rəgwa ŋga ɗanə uusəra ŋga əpisəka?” ");
INSERT INTO gde_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Wata əŋki Yeesu ka tii, “Pooshi unə jaŋgii sətə ɗii *Dawuda tii da ənjaakii saa'itə maɗəfənə a ɗa tə tii kuna? ");
INSERT INTO gde_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","Kə dəməgərə ci aasəkə *yi ŋga Əntaŋfə, ca ŋgiragi burooditə ɗəkəpaa ənji ka Əntaŋfə, təya adə da ənjaakii, taa ŋgahi ma buroodita, pooshi bariya vii rəgwa ŋga adənə ka taa wu, maɗaamə ka limanyinə daanətii.” ");
INSERT INTO gde_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Yeesu a tsakə banə ka tii, əŋki ci, “Ma nyi *Uuzənə ŋga ənda, Slanda uusəra ŋga əpisəkə nə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Makə mbu'ya əndə'i uusəra ŋga əpisəka, kə dəməgərə Yeesu aasəkə *kuvə də'wa. Wata ca ndzaŋə dzəgunə waɓənə ŋga Əntaŋfə ka ənja. Ma dava, tə'i əndə ɗii ciizəmanəkii mantəkii. ");
INSERT INTO gde_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Davə nə maliminə da Farisanyinə əsə. Təya alə sə ŋga idəpaanə ashi Yeesu, kaa təya kərə tə ci aakəŋwacii gəŋwanə. Wata təya kanətsaa ka ci ginə, kaa təya nee mbu'u ka mbəɗəpaanə nə ci də əndətə uusəra ŋga əpisəka. ");
INSERT INTO gde_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Asee, kə shii Yeesu sətə agi haŋkalatii patə. Wata əŋki ci ka əndə mantə ciita, “Maɗətə, kəŋaanə.” Maɗənə nə əndəta, ca kəŋaanə. ");
INSERT INTO gde_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Əŋki Yeesu ka maliminə da Farisanyinə, “Wiinə səndə cii kya moo ləgwanə koonə: iitə saŋə vii bariya gaamə kaamə rəgwa ŋga ɗana? Ŋga ɗa ŋga'əənə uusəra ŋga əpisəkə saanii, anii ŋga ɗa bwaya bwayaana? Ŋga mbəɗəpaanə də əndə saanii, anii ŋga zamaginə də ca?” ");
INSERT INTO gde_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Wata Yeesu a tsaaməgi aagitii patə, əŋki ci ka əndə mantə ciita, “Təɗapaa ciinəku.” Ca təɗapaa ciinəkii. Wata kə ənəgərə ciinə ŋga əndətə makə ŋga ŋukə. ");
INSERT INTO gde_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Makə ɗii ha'ə, wata səkətii a ɓəəzəgi ka shaŋə. Təya ndzaŋə waɓənə agyanə makə sətə mbeenətii ka ɗanə də Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Ma ka əndə'i uusəra, kə ma'i Yeesu, kə ŋgirə ci aanə giŋwə ka ɗa də'wa. Ca ba'agi həmə ka ɗa də'wa. ");
INSERT INTO gde_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Makə puki ha, ca 'waa'watə lyawarənaakii aaɓiikii. Ca tagi harakii ahadatii pu'u aji bəra'i. Kə 'wii ci tə tii də masləkee ənja. ");
INSERT INTO gde_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Ma nə təya: Simoonə, ətə ikə ci ka ci əndə'i ləmə Piita, Andərawəsə ndzəkəŋuci Simoonə, Yakubu, Yoohana, Filibusə, Barətalamawusə, ");
INSERT INTO gde_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mata, Tooma, Yakubu uuzənə ŋga Haləfa, Simoonə əndə moo dimwaanə ka hanyinaakii, ");
INSERT INTO gde_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Yahuda uuzənə ŋga Yakubu ba'ə Yahuda Isəkariyootə. Ma uudəpaa ba'a, ci vii tə Yeesu aacii bwaya ənja. ");
INSERT INTO gde_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Ma daba'əkii, Yeesu a jimagərə da lyawarənaakii anə giŋuta, ca kəŋaanə a babara ka hatə ɗii lyawarənaakii ɓəzəkii. Ma davə əsa, tə'i daŋkana. Kə shi tii daga də Urusaliima da i asəkə hara vəranyinə anə hanyinə ŋga Yahudiya patə, da hara vəranyinə ama maɗuunə uunəva, waatoo vəranə ŋga Tiira da ŋga Sidoonə. ");
INSERT INTO gde_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ma shi ənjitsə ha'a, ka fa sətə ci Yeesu a dzəgunə da ka upaa jamənə ŋga shishinətii. Kə mbəɗəpaa Yeesu də tii patə da i ənji ginaaji. ");
INSERT INTO gde_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Makə ɗii ci agi shiginə nə baawəɗa dashikii ka mbəɗəpaaginə də tii patə, patənə ŋga ənja, kə aali tii rəgwa ŋga dəba'ətənə tə ci. ");
INSERT INTO gde_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Wata Yeesu a tsaaməgi aagi lyawarənaakii, əŋki ci: “Tə'i barəkaanə ashuunə tyalakinə, acii ma unə, koonə də ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Tə'i barəkaanə ashuunə, unə ənə ka maɗəfənə ənshinə, acii kadə nuuna əburə gyaɗə. Tə'i barəkaanə ashuunə, unə ənə da kiinə a gyuunə ənshinə, acii kadə nuuna ɗa maŋushinə. ");
INSERT INTO gde_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Tə'i barəkaanə ashuunə maɗa əɓuyi ənji koonə, ənjə a laakə tuunə, ənjə a dzaana tuunə, ənjə a əɓipaa tuunə putə ŋga nə'unə goonə tə Uuzənə ŋga ənda. ");
INSERT INTO gde_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Ɗamə maŋushinə maɗa kə upaa uushi tuunə ha'ə makə ətsa, kamə kyalaliinə ŋga mooɗasəka, acii tə'i maɗuunə shikwa goonə kiɗə dagyə; acii ha'ə makə ətsə nji dzədzəshi'inə ŋga ənjitsə a əɓwa ka anabiinə ŋga ŋukə. ");
INSERT INTO gde_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“Amma, agi ŋgəra'wə nuunə, unə ənji gəna, acii kə agyuunə ŋwaŋuunə goonə kə uugi. ");
INSERT INTO gde_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","Agi ŋgəra'wə nuunə, unə ənə maburəkii gyaɗə ənshinə, acii kadə nə maɗəfənə a kutsa tuunə. Agi ŋgəra'wə nuunə, unə ənə ka maŋushinə ənshinə, acii kadə nuuna ndzaanə makə ənji ŋga wa, ka ndzaanə nuunə da kiinə a gyuunə. ");
INSERT INTO gde_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Agi ŋgəra'wə nuunə, maɗa kə kuyirii ənji patə tuunə, acii ha'ə makə ətsə nji dzədzəshi'inə ŋga ənjitsə a kuyirii tə anabiitə nja jaarakə.” ");
INSERT INTO gde_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“Ma unə ənə ca fa tə nyi, wanyinə ka ba koonə, uuɗəmə tə ənjitə ca ka koonə daawaanə, una ɗa ŋga'əənə ka ənji ushanə tuunə. ");
INSERT INTO gde_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Kədiimə barəkaanə acii Əntaŋfə ka ənjitə ca mburəzə tuunə; una ɗa də'wa ka putə ŋga ənjitə ca ciɓee koonə. ");
INSERT INTO gde_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Maɗa kə tsagi əndə ka hə meeciinə ka hwahwaaməku, zhi'wee ka ci ka əndə'i hwahwaamə əsə. Maɗa kə gutsətə əndə baləwaaku, unee ka ci kaa ca ŋgərə kəjeerənaaku əsə. ");
INSERT INTO gde_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Taa wu kədii uushi aciiku, vii ka ci səkii. Maɗa kə gutsətə əndə uushaaku, ga ha ənə ka ləgwa ka ci səkii ma'ə. ");
INSERT INTO gde_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Danəkii ha'ə əsə, ɗamə ka ənji ndilə ndilə makə sətə mwayi unə ənjə a ɗa koonə. ");
INSERT INTO gde_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","“Maɗa wata tə ənjitə ca uuɗə tuunə uuɗənuunə, paa unə ka upaa ŋunyi shikwa. Taa ma'waslyakə ənji maa, agi ɗanə nə tii ha'ə makə ətsa. ");
INSERT INTO gde_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Maɗa wata ka ənjitə ca ɗa koonə ŋga'əənə ɗanuunə ŋga'əənə, paa unə ka upaa ŋunyi shikwa. Taa ma'waslyakə ənji maa, agi ɗanə nə tii ha'ə makə ətsa. ");
INSERT INTO gde_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Maɗa ma nuunə ka vii dəmənə, wata ka ənjitə shii unə oo'i, kadə ənəvəginə nə tii koonə əsə, paa unə ka upaa ŋunyi shikwa. Taa ma'waslyakə ənji maa, agi ɗanə nə tii dəmənə ka ma'waslyakə ənji makə tii, kaa təya ənəvəgi ka tii makə ətəkii. ");
INSERT INTO gde_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Aciikii bii nyi koonə, uuɗəmə tə ənji daawaanə goonə. Ɗamə ka tii ŋga'əənə. Maɗa kə vii unə dəmənə ka ənja, goona ka nuunə davə ma'ə. Maɗa kə ɗii unə ha'ə, ka upaanə nuunə maɗuunə shikwa. Ka ndzaanə nuunə ka manjeevənə ŋga Əntaŋfə Əndə məghərəvənə ka shaŋə. Acii ma ca, ŋga'ə nə ci ka ənjitə pooshi ka ɗa yawa da ka ma'waslyakə ənja. ");
INSERT INTO gde_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Nəhəmə təgunuunə ŋga ənji makə sətə ci Dəsənuunə a nəhə təgunuunə goonə.” ");
INSERT INTO gde_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","“Goona lagi gəŋwanə agyanə hara ənja. Ma Əntaŋfə əsa, paa ci na lagi gəŋwanə agyanuunə. Goona vii ka ənji ma'inə. Ma Əntaŋfə əsa, paa ci na vii koonə ma'inə. Tifyagimə tə ənjitə ca ɗa koonə bwaya bwayaanə. Ma Əntaŋfə əsa, ka tifyaginə nə ci tuunə. ");
INSERT INTO gde_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ndiimə uushi ka hara ənja. Ka ndiinə nə Əntaŋfə koonə noonə əsə. Də ŋunyi kəŋwə nə Əntaŋfə a gəla koonə aasəkə mbuurənyinə goonə. Ma kəŋukəya, ka natənə nə ci, ca gaŋgəzətə, ca zhizhivətə ŋga'ə, ca haaja aa panə. Acii də kəŋutə gəliigyuunə ka ənji nə Əntaŋfə a gəlagi koonə noonə əsə.” ");
INSERT INTO gde_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Yeesu a ɗa ka tii misaali əsə, əŋki ci, “Pooshi muurəfə ka mbee ka ɓaarii rəgwa ka əndə'i muurəfə makə ci. Maa kə ɗii ha'ə, ka kwaalagərənə nə tii aasəkə gu'wə kyakya'ə. ");
INSERT INTO gde_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Pooshi lawarə ka paleenə ka maləmaakii də məghərəvənə. Amma taa ŋgutə əndə uugi dzəgunə uushi'inə, ka ndzaanə nə ci makə ŋga maləmaakii. ");
INSERT INTO gde_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“Ka mi saŋə cii kwa tsaamə uundzə kada agi ndzəkəŋu, ha bwasee ka rintə agiku naakwa? ");
INSERT INTO gde_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Iitə saŋə mbeenəku ka banə ka ndzəkəŋu oo'i, ‘Taku, kaa nya ŋgərəgi ka hə kada agiku’, yoo, paa hə ka nee ka rintə agiku naakwa? Hə əndə kərənə ka Əntaŋfə də bəra'i! Ma ɗanəkwa, ŋgərəgi rintətsə agiku zəku'i. Ma daba'əkii, ka neenə nə hə tahu tahu bahə ha ŋgiragi uundzə kada agi ndzəkəŋu.” ");
INSERT INTO gde_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","“Pooshi poo ŋga mandikə ndikə ənfwə ka ndzaanə ŋgərəkiki. Pooshi poo ŋga maŋgərəkiki ənfwə ka ndzaanə ndikə ndikə əsə. ");
INSERT INTO gde_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Acii taa ŋgutə ənfwə patə, ka pookii shiinə ənja. Pooshi ənji ka slirəɓa pawə ŋga uudəvə a ənfwə dəhə uuɗa. Pooshi ənji ka slirəɓa pawə ŋga papawə a ənfwə məkaalənə əsə. ");
INSERT INTO gde_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Ma ŋunyi ənda, ŋunyikii ndzaanə slənaakii, acii ŋunyikii nə ədzəməkii. Ma bwaya əndə əsə, bwayakii ndzaanə slənaakii, acii bwayakii nə ədzəməkii. Acii sətə a ədzəmə əndə cii kəya nyagi.” ");
INSERT INTO gde_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“Ka mi saŋə nuunə ka 'wanə tə nyi Slandanə, Slandana, amma paa unə agi ɗa sətə cii kya ba koona? ");
INSERT INTO gde_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Takumə, a ɓaarii nyi koonə ndzaanə ŋga əndətə ca shi aaɓiiki, ca fa waɓənaaki, ca nə'utə əsə. ");
INSERT INTO gde_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Kə ndzaa ci makə əndətə ghənyi yaakii. Kə tələgi ci gu'wə kurəŋə, ca mbukə baŋgwə anə pasla. Kə ŋgyaara gəərə, kə shi ma'inə, kə naanə ka yikii. Amma, makə ɗii ci dəŋə dəŋə nə yita, maguguɗəmə. ");
INSERT INTO gde_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amma, ma əndətə ca fa waɓənaaki, paa ci nə'utə, kə ndzaa ci makə əndətə ghənyi yaakii, wata ca ndzaŋə kanə agyanə hanyinə yadə tələgi gu'wə ka mbukənə. Makə ŋgyaara gəərə, ma'inə a naanə ka yikii. Wata ghəɓə kə uulagi yaakii, kə rarə'igi dza'ə.” ");
INSERT INTO gde_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Makə uudəpaa Yeesu baabagi waɓəətsə patə ka ənja, ca maɗə, ca palə aasəkə vəranə ŋga Kafarənahumə. ");
INSERT INTO gde_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Ma dava, tə'i əndə'i gawə ŋga soojiinə ŋga ha də Rooma. Tə'i mavaakii uu'i ci dərəva. Gwakə də ma də ma nə ci. ");
INSERT INTO gde_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Makə fii gawə ŋga soojiinə slənə ŋga Yeesu, wata ca sləkee ka hara *gayinə ŋga Yahudiinə aaɓiikii ka banə ka ci, a shi ci ka mbəɗəpaanə ka ci də mavataakii. ");
INSERT INTO gde_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Maɗənə nə tii, palənə nə tii aaɓii Yeesu. Makə mbu'i tii, təya puutə tə ci, əŋki tii ka ci, “Tuutəta'ə! Kə mbu'i əndətsə bahə ha tsakə tə ci. ");
INSERT INTO gde_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Acii kə uu'i ci tə slikərənə gaamə ŋgaaŋga'ə. Ci ghənyi keenə *kuvə də'wa əsə.” ");
INSERT INTO gde_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Wata Yeesu a maɗə, ca dzə da tii. Ma ətsə Yeesu kədəhə ka mbu'unə, wata gawə ŋga soojiitə a sləkee ka guviinəkii aaɓiikii kaa təya shi ka banə ka ci oo'i, “Slandana, ga ha zaarəgi naaku na, acii mambu'umə nyi bahə dzənaaku aa haki aasii. ");
INSERT INTO gde_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Ci ɗii paa nyi gi nyi saaki aaɓiiku. Amma bagi waɓənə rəŋwə, kə shii nyi, ka mbəɗənə nə mavaaki. ");
INSERT INTO gde_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Ma bii nyi ha'a, acii nyi maa, tə'i gayinə akəŋwaciiki, tə'i soojiitə cii kya ɗa ka tii gawuunə əsə. Ka mbeenə nə nyi ka banə ka əndə'i əndə: ‘Duu aa hatə!’ wata ca palə. Nya ba ka əndə'i əndə əsə: ‘Shiwa!’ ca shi. Nya ba ka mavaaki: ‘Slənuu sətsə ha'ə!’ ca slənətə ha'ə.” ");
INSERT INTO gde_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Makə fii Yeesu waɓəətsa, kə ɗii ka ci ka sə ŋga hurəshishinə nə haala ŋga gawə ŋga soojiita. Ca zhi'wagi aaɓii daɓaalatə aɓiikii, əŋki ci ka tii, “Wanyinə ca ba koonə: taa ahada ənji *Isərayiila maa, paa nyi sha lapaa əndətə gi'i tə nyi makə ŋga əndətsa.” ");
INSERT INTO gde_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Makə ənya ənjitə sləkee gawə ŋga soojiitə aasii, ma lapaa təya, kə mbə'i mavata. ");
INSERT INTO gde_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Pii ma daba'əkii, Yeesu a maɗə, ca dzə aasəkə vəraatə ɗii ləməkii Nayinə. Kə gi lyawarənaakii da ɓəzə daɓaala atsakii əsə. ");
INSERT INTO gde_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Mbu'unaakii kədəhə da mayi ŋga vəranə, wata təya guŋugərə da ənji təya kərə wə aa gu'wə. Ma əndətə əŋki, ci nə uuzənəkii rəŋwə acii məci. Ma məci əsa, kə əntəgi ŋgurii. Ənji vəraatə laŋə dzatə də nə aɓii miita. ");
INSERT INTO gde_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Makə nee Yeesu Slandanə ka ki, ca nəhə təgunuunatə. Əŋki ci ka ki, “Ga ha tuu.” ");
INSERT INTO gde_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Wata ca əntsahətə, ca təɓətə kararaata. Ənji kərə wutə a kəŋaanə. Əŋki Yeesu ka wuta, “Dagwana, wanyinə ka banə ka hə: maɗətə!” ");
INSERT INTO gde_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Wata bərəkutə wutə a maɗətə, ca ndzaanə dasə, ca ndzaŋə waɓənə. Wata əŋki Yeesu ka məci, “Wiinə uuzənaaku.” ");
INSERT INTO gde_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Makə ɗii ha'ə, wata ŋgwalənə a kəsəgi tə ənjitə patə ka shaŋə. Təya ɗuunətə tə Əntaŋfə, təya ba, “Kə shigi maɗuunə *anabi agyaamə. Kə shi Əntaŋfə ka tsakə tə ənjaakii.” ");
INSERT INTO gde_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Ma waɓəətsə bii ənji agyanə Yeesu, kə dəlagi agyanə hanyinə ŋga Yahudiya patə, dəŋə aagyanə hanyinə ətə ɗii tii naahə riɓə. ");
INSERT INTO gde_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Kə dzəgunəgi lyawarənə ŋga Yoohana ka ci uushi'iitsə ɗaaɗii patə. Wata ca 'wa ənji bəra'i ahadatii, ");
INSERT INTO gde_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ca sləkee ka tii aaɓii Yeesu Slandanə ka ləgwanə ka ci oo'i, “Hə nə əndətə na shi nii, anii a gəreenə əndə'i əndə pama?” ");
INSERT INTO gde_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Makə mbu'i lyawariitə bəra'i aaɓii Yeesu, təya ba ka ci, “Yoohana əndə ɗa bapətisəma sləkee keenə aaɓiiku ka ləgwanə ka hə: Hə nə əndətə na shi nii, anii a gəreenə əndə'i əndə pama?” ");
INSERT INTO gde_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Ma saa'ikii ha'a, kə mbəɗəpaa Yeesu də ənji bwanea ɓəzəkii. Kə luupaa ci ənji acii ginaaji. Kə wunəgi ci ginə ŋga muurəfinə laŋə əsə. ");
INSERT INTO gde_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Wata ca jikəvə ka lyawariitə sləkee Yoohana aaɓiikii, əŋki ci, “Ənəmə, una dzə ka banə ka Yoohana sənə cuuna nee da sənə cuuna fa. Waatoo, agi wuunənə nə ginə ŋga muurəfinə, agi wiinə nə mahurəməsə ənja; ənji uyikuzəna əsə, agi mbəɗənə nə tii. Agi wuunənə nə liminə ŋga kadəguləminə, agi maɗeenə nə ənji ka maməətə ənja, agi waazanə nə ənji Ŋunyi Habara ka maaghiinə əsə. ");
INSERT INTO gde_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Tə'i barəkaanə ashi əndətə pooshi na unee ka nə'unə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Makə pyalə lyawarənə ŋga Yoohana satii, wata Yeesu a ndzaŋə waɓənə ka daɓaala agyanə Yoohana, əŋki ci, “Ya saa'itə gyuunə aaɓii Yoohana aagi bilina, mi saŋə mwayi unə neena? Kuzənə ətə ca ba'agi agi məɗə kwa? ");
INSERT INTO gde_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Aa mi gyuunə ka caamanə da? Ka caama əndətə ŋgii dagwa kəjeerənə kwa? Ma ənji waha ətə ca kaala ŋunyi kəjeerənə ha'a, asii ga meeminə nə tii. ");
INSERT INTO gde_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Bamə ka nyi, mi gyuunə ka caamanə kwa? *Anabi gyuunə ka caamanə kwa? Ha'ə tanyi, sətə palee ka anabi gyuunə ka caamanə. ");
INSERT INTO gde_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Acii ci nə əndətə waɓi malaaɓa ləkaləkatə agyanəkii. Ma bii Əntaŋfə: ‘Wanyinə ka sləkeenə ka masləkee əndaaki, kaa ca ta ka hə kəŋwanə, ca haɗatəgi ka hə də rəgwa taabu'u nii kwa dzə.’ ” ");
INSERT INTO gde_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Yeesu a tsakə banə, əŋki ci, “Wanyinə ca ba koonə: Ma Yoohana, pooshi ənji sha pwayi əndə ganə a duuniya ətə palee ka ci. Amma ma əndətə palee də uundzuundzuunə agi *ŋwaŋuunə ŋga Əntaŋfə, kə palee ci ka Yoohana.” ");
INSERT INTO gde_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Makə fii daɓaala da *ənji luu tsəkə tə waɓəətsə waɓi Yeesu, kə dəlii tii də Əntaŋfə makə ɗii ci kə liwə tii yiɓə bapətisəma acii Yoohana. ");
INSERT INTO gde_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amma ma *Farisanyinə da maliminə, kə kaaree tii ka luu hiima ŋga Əntaŋfə. Ci ɗii pooshi tii liwə yiɓə bapətisəma acii Yoohana. ");
INSERT INTO gde_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Əŋki Yeesu əsə, “Də mi saŋə mbərə mbərətəginəki də ənji ŋga zamanana? Tə wu saŋə pusha təya? ");
INSERT INTO gde_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Kə ndzaa tii makə manjeevənə təya ɓuurə asəkə luuma, təya 'waa'wa hara manjeevənə makə tii, təya ba, ‘Kə əgiinə koonə uuɗaləma, pooshi unə ujə. Kə kii inə koonə wanyanə ŋga wa, amma, matuumuunə.’ ");
INSERT INTO gde_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Ma bii nyi ha'a, acii makə shi Yoohana əndə ɗa bapətisəma, kə ɗii ci suumaya, paa ci sii ma'i inaba. Makə nee unə ha'ə, əŋkyuunə, ‘Əndə gu'wə nə ci’. ");
INSERT INTO gde_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Amma makə shi nyi naaki, nyi *Uuzənə ŋga ənda, agi adənə nə nyi zəma, nya sa ma'i inaba. Yoo, əŋkyuunə əsə, ‘Tsaaməmə tə əndətsa, bwaŋkara nə ci, masa ma'i inabi, guva ŋga ənji luu tsəka da hara ma'waslyakə ənji nə ci!’ ");
INSERT INTO gde_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Patə da ha'ə, ma ənjitə liwə hiima ŋga Əntaŋfə, agi ɓaariinə nə tii tantanyinəkii.” ");
INSERT INTO gde_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Tə'i əndə'i əndə Farisa 'wii tə Yeesu aa hakii aasii ka zəma. Yeesu a dzə aa ha əndəta, ca ndzaanə ka zəma. ");
INSERT INTO gde_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Asee, tə'i ma'waslyakə minə davə də vəra. Makə fii ki oo'i, ga Farisatə asii nə Yeesu ka zəma, kya ŋgərə əbwə urədya, ");
INSERT INTO gde_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","kya kira, kya gwaŋaanə atsa səɗə Yeesu daba'akii, kya tuu. Wata əjanə nə kiinatə aaba'a səɗə Yeesu. Kya ŋgərə, kya taaɗəgi də shiŋkinə ŋga nətə, kya paatə səɗəkii, kya buləvə urədya aa dəvə. ");
INSERT INTO gde_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Ma Farisatə 'wii tə Yeesu aa hakii aasii, makə nee ci ha'ə, əŋki ci də səkəkii, “Maci anabi nə əndətsə tanyi, kaɗa kə shii ci taa wu nə miitsə ca dəba'ə tə ci; taa mi nə ki əsə, ka shiinə nə ci; waatoo, ma'waslyakə əndə nə ki.” ");
INSERT INTO gde_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","Wata Yeesu a ba ka Farisata, “Simoonə, tə'i nyi da sə ŋga banə ka hə.” Əŋki Simoonə ka ci, “Waɓuu ɗii, Maləma.” ");
INSERT INTO gde_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Əŋki Yeesu ka ci, “Tə'i əndə nyi'u tə ənji bəra'i dəmənə. Ca nə'u tə əndənə *hwaslə gya'ə tufə. Ca nə'u tə əndə'i əndənə əsə hwaslə tufə pu'unə. ");
INSERT INTO gde_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Makə pooshi taa wu mbee ka ki'i dəməətə agitii, wata əndətə a bwasee ka tii ka dəməəta. Ya ətsa, ŋgutə agi ənjitsə bəra'i palee də uuɗənə tə ca?” ");
INSERT INTO gde_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Əŋki Simoonə, “Ma nee nyi naaki, əndətə ɗii dəmənə ŋgaaŋga'ə atsakii palee də uuɗənə tə ci.” Əŋki Yeesu ka ci, “Gooŋgaaku.” ");
INSERT INTO gde_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Wata ca zə'ugi aaɓii miita, əŋki ci ka Simoonə, “Kə nee hə ka miitsətsə nii? Kə gimagərə nyi aa haku aasii, amma pooshi hə bii oo'i, wa ənjə a əgəcii ma'inə ka nyi, ənjə a yiɓəgi ka nyi də səɗəki. Amma, ma miitsa, kə yiɓəgi ki ka nyi səɗəki də kiinatə, kya taaɗəgi də shiŋkinə ŋga nətə. ");
INSERT INTO gde_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Ma ha, paa hə nəhəpaa tə nyi ŋga'ə. Amma, ma kya, makə gimagərə nyi aa haku aasii, paa ki bwasee ka paatə səɗəki. ");
INSERT INTO gde_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Ma ha, pooshi hə əji ka nyi maarə aanəki. Amma, ma kya, kə əji ki ka nyi urədya aaba'a səɗəki. ");
INSERT INTO gde_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Aciikii ka banə nə nyi ka hə əsə: ma maɗuunə uuɗəətsə ŋgiragi miitsa, kə ɓaarii oo'i, kə upaa ki tifyaginə ŋga 'waslyakəətə ɗaaɗii ki patə. Amma, ma əndətə tifyagi Əntaŋfə ka ci 'waslyakəənaakii gi'u, gi'u nə uuɗənaakii əsə.” ");
INSERT INTO gde_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Wata əŋki Yeesu ka miita, “Kə upaa hə tifyaginə ŋga 'waslyakəənaaku.” ");
INSERT INTO gde_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Ma ənjitə cii kəya zəmə da tii, kə bii tii də səkətii, “Wu da nə əndənə ca tifyagi 'waslyakəənə əsa?” ");
INSERT INTO gde_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Amma əŋki Yeesu ka miita, “Kə upaa hə luupaanə putə ŋga gi'inaaku tə nyi. Duu agi jamənə.” ");
INSERT INTO gde_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Ma daba'əkii, Yeesu a maɗə, ca dzə ka vəra ka vəra, ca dzə də waaza Ŋunyi Habara agyanə *ŋwaŋuunə ŋga Əntaŋfə. Kə nyi'u lyawarənaakii pu'u aji bəra'i tə ci. ");
INSERT INTO gde_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","Kə nyi'u hara makinə tə ci əsə ətə mbəɗəpaagi ci də tii acii ginaaji da bwanea. Waatoo, Mariyaama Magədalina ətə lyakagi Yeesu ginaajiinə məɗəfə ashitə, ");
INSERT INTO gde_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Yawana, minə ŋga Kuza. Ma ŋgurii, ci nə kadala ŋga yi ŋga ŋwaŋwə *Hirudusə. Suzana da hara makinə ɓəzəkii. Ma tii pata, kə cakə tii tə i Yeesu də gənatii. ");
INSERT INTO gde_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Ma saa'ikii, kə ma'ya ənji asəkə vəranyinə patə, təya shi aaɓii Yeesu. Makə dzii daɓaala də na, wata Yeesu a ndzaŋə waɓənə ka tii də ɗa misaali, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“Tə'i əndə gi aasəkə rə ka giirə slikərənə. Ma ca giirə, hara slikərənə a kwaala ahada rəgwa, ənjə a wiigi'i anəkii. Əginyinə əsa, təya shi, təya ɗəmətə. ");
INSERT INTO gde_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","Hariinəkii əsə a kwaala ama pasla, ca givagi, ca huurəgi, makə pooshi marəɓə hanyinə. ");
INSERT INTO gde_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Harii slikərənə əsə, təya kwaala aagi dəha. Gərənə nə tii kyakya'ə da dəha. Dəhəkii a pa'aanə ka səkəŋwa. ");
INSERT INTO gde_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","Ma harakii, kə kwaalii tii anə ŋunyi hanyinə. Təya dəvə, təya gərə, təya əji hi'wa. Taa ŋgutə patə, kə vii ci ŋunyi cifanə gya'a gya'a.” Makə uudəpaa Yeesu waɓəətsa, wata ca wazəgi də ŋgeerənə, əŋki ci, “Ma əndətə da liminə ŋga fanə, wa ca fa.” ");
INSERT INTO gde_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Ma daba'əkii *lyawarənə ŋga Yeesu a ləgwa ka ci, əŋki tii, “Mi mwayi misaalitsə ɓaariina?” ");
INSERT INTO gde_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Əŋki Yeesu ka tii, “Ma unə kamə, koonə vii Əntaŋfə rəgwa ŋga shii ma'umbee uushi'inə ŋga ŋwaŋuunaakii. Amma, ma hara ənja, see də misaali fanətii; kaa təya tsaamə, amma paa tii ka neenə; kaa təya kapaa liminətii, amma paa tii ka paaratəginə.” ");
INSERT INTO gde_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“Wiinə səndə mwayi misaalitsə ɓaariinə: ma slikərəətsa, kə ndzaa ci makə waɓənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Ma slikərəətə kwaalii ahada rəgwa, tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə. Wata *Seetanə a shi, ca ɗəməgi waɓəətə a ədzəmətii, acii ga təya vii gooŋga ka Əntaŋfə kaa təya upaa luupaanə. ");
INSERT INTO gde_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Ma slikərəətə kwaalii ama pasla əsə, tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə, təya luu də mooɗasəka. Amma pooshi waɓənəkii əji slərəginə a ədzəmətii. Ci ɗii paa tii ka ta'avənə agi nə'unə. Maɗa kə upaa ŋgəra'wə tə tii, təya bwasee. ");
INSERT INTO gde_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Ma slikərəətə kwaalii aagi dəha, tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə. Amma ma agi ndzaanatii, ka kavənə nə tii natii nə ka buurə uushi'inə kama kama, təya suuna gəna, təya alə sətə ca kaɗeesəkə ka tii. Pooshi ŋunyi uushi ci təya mbee ka ɗatənə. ");
INSERT INTO gde_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Ma slikərəətə kwaalii anə ŋunyi hanyinə, tii nə ənjitə ca fa waɓənə ŋga Əntaŋfə, təya kəsəpaa təŋə təŋə də ədzəmə rəŋwə, təya ndzaanə də sə'watənə, təya ɗa ŋunyi uushi ətə ca nafa.” ");
INSERT INTO gde_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“Pooshi əndə ca kavə gunə aasəkə garəkuwa ka umbətənə də ɗəva taa ka kapaanə atsa ədərə əsə. Amma ka kapaanə nə ənji garəkuwa ka madzəgamə ha, ka ənjitə ca dəəmə aa kumu a nee ka ha camə. ");
INSERT INTO gde_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Taa mi patə ɗii ma'umbeekii kadə na shigi aa babara. Ma sətə pooshi ənji shii, kadə nə ənjə a shii, kadə na shigi aa babara əsə. ");
INSERT INTO gde_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“Ɗamə haŋkala agyanə fanə goonə! Acii ma əndətə da kuɗəpəshinə ŋga paaratə də sətə cii kəya fa, ka ci tsakənə ənji paaratəginə. Amma ma əndətə pooshi kavə nəkii davə, taa ətə gi'u agi hiimaakii maa, ka luuginə nə ənji.” ");
INSERT INTO gde_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Ma daba'əkii, kə shi i məci Yeesu da ndzəkəŋushi'inəkii kaa təya nee ka ci. Amma kə təkuree tii ka mbu'unə aaɓiikii, pooshi rəgwa acii daɓaala. ");
INSERT INTO gde_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Wata ənjə a ba ka Yeesu, “Watiitsə i muu tii da ndzəkəŋushi'inəku agyə, kə mwayi tii neenə ka hə.” ");
INSERT INTO gde_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Amma wata əŋki Yeesu ka tii, “Ənjitə ca fa waɓənə ŋga Əntaŋfə, təya slənətə sətə bii ci, tii nə yaayi da ndzəkəŋushi'inəki.” ");
INSERT INTO gde_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Ma ka əndə'i uusəra, kə ndərəvə Yeesu da lyawarənaakii aasəkə kumbawalə. Əŋki ci ka tii, “Taŋəgyaamə aa taŋəgi uunəva.” Təya maɗə, təya palə. ");
INSERT INTO gde_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ma təya dzə də taŋənə də kumbawalə, Yeesu a tsəfə ŋunyinaakii. Wata mandalə məɗə a ndzaŋə kyanə anə uunəva. Ma təya nee, nanə nə ma'inə aasəkə kumbawala kaa təya za. ");
INSERT INTO gde_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","Wata təya əntsahətə aaɓii Yeesu, təya maɗee ka ci, əŋki tii ka ci: “Daada, Daada, wanaamə ka zanə.” Yeesu a vəɗəhə, ca la ŋguruunə ka məɗə da ka ma'iitə ca mbuɗə aadəgyə aadəgyə. Wata shakətə təya ənəgi, təya dədəkə kyakya'ə. ");
INSERT INTO gde_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Əŋki Yeesu ka lyawarənaakii, “Pooshi ma'ə vii gooŋga goonə kuna?” Amma, ma təya, kə ŋgwaləgi tii. Kə ɗii ka tii ka sə ŋga hurəshishinə əsə. Təya laagwashi ahadatii, “Wu saŋə nə əndəna? Taa məɗə da ma'inə maa, agi waɓənə nə ci ka tii, təya fa tə ci.” ");
INSERT INTO gde_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Makə taŋəgi Yeesu da lyawarənaakii aa taŋəgi uunəvə ŋga Galili, waatoo aanə hanyinə ŋga ənji Gyarəgasinə, ");
INSERT INTO gde_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","jimagərənaakii asəkə kumbawala, wata təya guŋəgərə da əndə'i əndə vəranəkii da ginaajiinə ashikii. Kə uugi baanə laŋə makə tikə ci da kəjeerənə əsə. Paa ci ka ndzaanə asii. Amma ahada gu'u ənji nə ndzaanaakii. ");
INSERT INTO gde_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Neenaakii ka Yeesu, wata ca ka vurənə, ca shi, ca kulagi akəŋwaciikii, ca ŋgəree ka uurakii, əŋki ci, “Yeesu Uuzənə ŋga Əntaŋfə Əndə məghərəvənə, mi cii kwa alə ashiki kwa? Tuutəta'ə! Ga ha ciɓə də nyi.” ");
INSERT INTO gde_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Ma bii ci ha'a, acii kə bii Yeesu ka ginaajitə kaa ca dzəgi. Ma ginaajikəya, kə nji kəya kəəsə tə əndəkii ŋgaaŋga'ə. Acii ha'ə, mapa'əkii nji əndətə a ndzaanə da i mahyakahyaka'ə aciikii da asəɗəkii. Amma, patə da ha'ə ca dzə də ɓwaatəginə. Ginaajikii a kagi tə ci aagi bilinə. ");
INSERT INTO gde_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Wata Yeesu a ləgwa ka ci, əŋki ci, “Iitə nə ləməkwa?” Əŋki ci, “Ma ləməkya, Ɓəzəkii.” Ma bii ci ha'a, acii ɓəzəkii nə ginaajinyiitə dzii də nə ashikii. ");
INSERT INTO gde_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Wata ginaajinyiitə a dza ciinə ka Yeesu, acii ga ca bii ka tii dzənə aasəkə makurəŋə gu'u ŋga zanə. ");
INSERT INTO gde_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Ma dava, tə'i gəranə ŋga dagəliinə ca alə zəmatii ashi ɗaŋgəra. Wata ginaajinyiitə a kədii acii Yeesu kaa ca vii ka tii rəgwa ŋga dzəgərənə aashi dagəliita. Wata Yeesu a vii ka tii rəgwakii. ");
INSERT INTO gde_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Təya shigi ashi əndəta, təya dzə, təya dzəgərə aashi dagəliita. Wata dagəliitə a hwayagərə, təya kwaalagərə aagi uunəva, təya zagi davə patə. ");
INSERT INTO gde_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Makə nee magəriinə ŋga dagəliitə ka sətə ɗii, təya huyipaa, təya kərə makii aasəkə vəranə da aanə hanyinəkii patə. ");
INSERT INTO gde_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Makə fii ənjita, wata təya shigi ka tsaamə sətə ɗii. Təya mbu'yagərə aaɓii Yeesu, təya lapaa əndətə dzəgi ginaajinyiitə ashikii dasə a panə aɓiikii. Da i kəjeerənə ashikii nə ci, kə ənya haŋkalaakii. Wata təya ŋgwaləgi. ");
INSERT INTO gde_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Ma ənjitə nee də ginətii makə sətə mbə'i əndə ginaajita, kə jigunyi tii ka ənjitə shi daba'a. ");
INSERT INTO gde_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Wata ənjinyiitə anə hanyinə ŋga Gyarəgasinə patə a ba ka Yeesu, wa ca dzəgi ka tii anə hanyinatii, acii kə ŋgwali tii ka shaŋə. Wata Yeesu a ndərə kumbawalə ka palənə saakii. ");
INSERT INTO gde_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Wata əndətə dzəgi ginaajitə ashikii a kədii acii Yeesu kaa ca dzə atsakii. Amma pooshi Yeesu luuvə ka ci, əŋki ci ka ca, ");
INSERT INTO gde_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Ənuu saaku aasii. Duu dzəgunəgi ka ənji sətə ɗii Əntaŋfə ka putaaku.” Palənə nə əndəta, ca dzə də baaba ka ənji patə asəkə vəranə sətə ɗii Yeesu ka putaakii. ");
INSERT INTO gde_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Ənyanə ŋga Yeesu, kə liwə ənji tə ci ŋgaaŋga'ə, acii agi gəranə tə ci nji tii patə. ");
INSERT INTO gde_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Tə'i əndə'i əndə ətə ɗii ləməkii Jayirusə. Ma ca, gawə nə ci asəkə *kuvə də'wa davə də vəra. Kə shi ci aaɓii Yeesu, ca gərə'waanə atsaa səɗəkii, ca dza ka ci ciinə kaa ca dzə aa hakii aasii. ");
INSERT INTO gde_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Acii tə'i uuzənaakii rəŋwə, uncitə minəkii. Kə ɗii fəzatə taa pu'u aji bəra'i. Pooshi labaɗatə, də ma də ma ha'ə nə ki. Ma Yeesu a dzə aa ha əndəta, kə tsəkuyi ənji ŋgaaŋga'ə anəkii. Pooshi rəgwa ŋga zə'uginaakii acii ənja. ");
INSERT INTO gde_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Tə'i əndə'i minə agi ənjita, ciɓee bwanea ka ki fəzə pu'u aji bəra'i. Uushi'inə nja ɗa tə ki. Kə zamagi ki də gənatə patə ka ənji kuzhikinə, amma pooshi əndə mbee ka mbəɗəpaanə də ki. ");
INSERT INTO gde_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Wata kya əntsahətə aaɓii Yeesu da ba'akii, kya təɓətə kəjeerənaakii. Pii wata kə dzəgi bwaneatə ashitə. ");
INSERT INTO gde_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Əŋki Yeesu, “Wu daa uree ka nya?” Əŋki patənə ŋga ənji ka ci, əntaa tii. Əŋki Piita ka ci, “Daadə, laŋə nə ənji aɓiiku, pooshi ha ŋga zə'uginə.” ");
INSERT INTO gde_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Əŋki Yeesu, “Amma tə'i əndə uree ka nyi, acii kə fii nyi tə'i baawəɗa shigi ashiki.” ");
INSERT INTO gde_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Makə nee miitə kə puki ba'atə, wata kya shi. Shishinətə a dzə də udzənə acii ŋgwalənə. Kya gərə'waanə akəŋwacii Yeesu, kya ndzaŋə dzəgunənə ka ci akəŋwacii ənji patə taa ka mi uree ki ka ci, i makə sətə upaa ki mbəɗənə pii əsə. ");
INSERT INTO gde_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Wata əŋki Yeesu ka ki, “Uuzənaakya, kə mbə'i hə putə ŋga gi'inaaku tə nyi. Duu agi jamənə.” ");
INSERT INTO gde_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Daga Yeesu ma'ə ma'uudəpaamə waɓənə ha'ə, kə mbu'ya əndə yi ŋga Jayirusə. Əŋki əndətə ka Jayirusə, “Kə uudee uuzəətə ka na. Ga ha ənvutə tə maləmə ma'ə.” ");
INSERT INTO gde_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","Amma, makə fii Yeesu ha'ə, wata əŋki ci ka Jayirusə, “Ga ha ŋgwalə. Vii gooŋga ka Əntaŋfə, ka mbəɗənə nə uuzənaaku.” ");
INSERT INTO gde_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","Makə mbu'i Yeesu aa ha Jayirusə, makapaamə ci rəgwa taa ka wu ka dəməgərənə atsakii maɗaamə ka i Piita, da Yoohana, da Yakubu da ka i dii uuzəətə da məci. ");
INSERT INTO gde_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","Ənji patə davə asii, ka tuunə, təya ŋgəərə ma. Wata əŋki Yeesu ka ənji, “Goona tuu. Ma uuzəətsa, əntaa əntənə əŋki ki, amma ŋunyinə cifə ki.” ");
INSERT INTO gde_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","Wata təya ŋusəgi tə ci acii kə shii tii, kə əŋki uuzəətə tanyi. ");
INSERT INTO gde_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Amma wata Yeesu a kəsətə tə uuzəətə ka ciinə, ca ba ka ki də ŋgeerənə, “Əndzəgəna, maɗətə!” ");
INSERT INTO gde_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Wata kə ənyatə əpinə ama uuzəəta. Kya maɗətə pii. Wata əŋki Yeesu, wa ənjə a vii ka ki zəma. ");
INSERT INTO gde_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Ma sətsa, kə ɗii ka sə ŋga hurəshishinə ka i dii da məci uuzəətə ka shaŋə. Amma Yeesu a ba ka tii, ga təya bapaa sətə ɗii taa ka wu. ");
INSERT INTO gde_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Yoo, kə dzatəgi Yeesu də lyawarənaakii pu'u aji bəra'i, ca vii ka tii baawəɗa da rəgwa ŋga lyaakaginə də ginaajiinə patə, təya mbəɗəpaa də ənji bwanea. ");
INSERT INTO gde_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Wata ca sləkee ka tii, kaa təya dzə də waazanə agyanə ŋwaŋuunə ŋga Əntaŋfə, təya mbəɗəpaa də ənja. ");
INSERT INTO gde_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Ma ətsə kaa təya palə, əŋki ci ka tii, “Goona ŋgərə taa mi ka dzəginə, taa zala, taa mbuura, taa zəma, taa kwaɓa əsə. Taa wu agyuunə, ga ca dzə da kəjeerənyinə bəra'i. ");
INSERT INTO gde_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Maa kə gyuunə aasəkə əndə'i vəranə, ndzaamə ga ənjitə liwə tuunə ahatii asii, dəŋə ka saa'itə nuunə maɗə gatə. ");
INSERT INTO gde_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Ma vəraatə maluumə ənji tuunə dava, shigimə sə goonə davə. Gwa'agimə bərəbərə ŋga vəraatsə asəɗuunə, unə dzə sə goonə. Ci na ɓaarii ka tii oo'i, maɗamə tii ŋga'ə.” ");
INSERT INTO gde_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Wata maɗənə nə tii, təya palə, təya dəəmə aasəkə vəranyinə kama kama, təya waaza Ŋunyi Habara, təya mbəɗəpaa də ənji bwanea taa da patə. ");
INSERT INTO gde_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Makə fii Hirudusə, ŋwaŋwə anə hanyinə ŋga Galili, sətə ɗaaɗii patə, wata kə gwazəgi haŋkalaakii. Acii agi banə nə hara ənji, “Kə ma'i Yoohana agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Hara ənjə a ba, “Anabi *Iliya jigagi.” Ma hara ənji əsa, təya ba, “Əndə'i əndə agi anabiinə ŋga ŋukə maɗətə agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Amma kə bii Hirudusə, “Ya makə kə shi nya lagi nə ŋga Yoohana, wu da nə əndətsə cii kya fa, ənjə a mbuɗə maɗa uushi'inaakii ha'a?” Wata Hirudusə a ndzaŋə aalənə tə Yeesu kaa ca nee ka ci. ");
INSERT INTO gde_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Ma ənjitə sləkee Yeesu ka tii ka waazanə, kə ənya tii aaɓiikii, təya ba ka ci sətə ɗaaɗii tii patə. Wata Yeesu a 'wagi tə tii daanətii, təya əntsahəgi dzaɗə da ənja, aadəɓii vəranə ŋga Batəsayida. ");
INSERT INTO gde_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Asee, kə fii daɓaala. Wata təya ndzaŋə nə'unə tə ci aa dəvə. Yeesu a luu tə tii. Ca waɓə ka tii agyanə ŋwaŋuunə ŋga Əntaŋfə. Ma ənjitə ca moo mbəɗəpaanə də tii əsə, kə mbəɗəpaa ci də tii. ");
INSERT INTO gde_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Ma ətsə uusəra kədəhə ka kulanə, wata lyawarənaakii pu'u aji bəra'i a əntsahətə aaɓii Yeesu, təya ba ka ci, “Bawə ka ənjitsə, wa təya palə aasəkə vəranyinə da i aasəkə makədəhə kədəhə giwanyiitsə a makwakwa, kaa təya upaa zəmə da ha ŋga baanə davə. Acii ma gana, agi bilinə naamə.” ");
INSERT INTO gde_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Amma əŋki Yeesu ka tii, “Unə nə vii ka tii zəma.” Əŋki tii ka ca: “Pooshi zəmə acii inə bahə viinə ka tii. Wata buroodi tufə da hərəfinə bəra'i nəndə acii inə. Maɗaamə inə kə gi ka ira zəmə, pooshi ka mbu'unə ka patənatii.” ");
INSERT INTO gde_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Ma bii tii ha'ə, acii ŋguyirənə daanətii maa, ka ɗanə nə tii bahə dəbu'u tufə. Wata əŋki Yeesu ka lyawarənaakii, “Kaalamə kurəgənyinə. Ndzaneemə ka ənja. Taa ka ŋgutə kurəga, wa ənji bahə tufə pu'unə a ndzaanə.” ");
INSERT INTO gde_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Wata təya ndzanee ka ənjitə patə. ");
INSERT INTO gde_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Yeesu a ŋgərə burooditə tufə da hərəfiitə bəra'i, ca maɗee ka ginəkii aadəgyə, ca kuyirii tə Əntaŋfə, ca ɓaatsəpaa, ca vii ka lyawarənaakii kaa təya təəkəpaa ka daɓaala. ");
INSERT INTO gde_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ənji patə a zəmə, təya əburə. Ma daba'əkii, lyawarənaakii a tsəəkətə tə ətə mbəɗaanə, ɗəvə pu'u aji bəra'i. ");
INSERT INTO gde_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Ma ka əndə'i uusəra, Yeesu a ɗa də'wa daanəkii. Aɓiikii nə lyawarənaakii əsə. Yeesu a ləgwa ka tii, əŋki ci, “Wu saŋə nə nyi ci ənjə a ba?” ");
INSERT INTO gde_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","Əŋki tii ka ci, “Ma nə hara ənji ka bana, hə nə Yoohana əndə ɗa bapətisəma. Ma hara ənji əsə, agi banə nə tii, anabi *Iliya nə hə. Hara ənji əsə, agi banə nə tii, əndə'i əndə agi anabiinə ŋga ŋukə maɗətə agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Əŋki Yeesu, “Ya unə noona, wu nə nyi cuuna ba?” Piita a jikəvə, əŋki ci, “Hə nə Mataɗəkii dacii Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Wata Yeesu a ɗa ka tii bariya, əŋki ci, “Goona bapaa sətsə taa ka wu shaŋə.” ");
INSERT INTO gde_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Ma daba'əkii ca waɓə agyanə naakii nə, əŋki ci ka tii, “Tyasə ma *Uuzənə ŋga ənda, see a sa ci ciɓənyinə laŋə. Kadə nə gayinə da madiigərə limanyinə da maliminə a kaaree ka ci, ənjə a ɓələgi tə ci. Ma ka makkənə ŋga uusəra, ka maɗənə nə ci agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Wata əŋki Yeesu ka ənji patə, “Taa wu patə ca moo nə'unə tə nyi, tyasə see a kaaree ci ka naakii nə, ca ŋgərə ənfwə ŋga gwa'avənə tə ci aashikii, ca nə'u də nyi uusəra patə. ");
INSERT INTO gde_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Taɗa wu patə ca ɗa gazhi'waanə ŋga gərətə əpinaakii, ka əteenə nə ci ka əpinəkii. Amma, taa wu patə ətee ka əpinaakii putə ŋga nə'unə tə nyi, ci na luupaa əpinaakii. ");
INSERT INTO gde_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Mi saŋə nə bwatya ŋga upaa patənə ŋga uushi'inə asəkə *duuniya, amma əndə ətee ka əpinaakəya? Pooshi bwatyakii. ");
INSERT INTO gde_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Acii maɗa kə ɗii ayinə tə əndə ka waɓənə agyanəki da agyanə waɓənaaki, ma nyi Uuzənə ŋga ənda, kadə nə ayinə a ɗa tə nyi ka waɓənə agyanə əndəta uusəratə nii kya shi da i məghərəvənə geenə da Daadə da ŋga malaaɓa malaa'ikanyinə. ");
INSERT INTO gde_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Tantanyinə cii kya ba koonə: tə'i hara ənji ahadaamə na nee də ginətii, tii ma'ə maməətəmə, ka ŋwaŋuunə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Makə bii Yeesu waɓəətsə ha'ə, ma daba'a baanə taa tighəsə, kə ŋgirə ci tə i Piita, da Yoohana da Yakubu, təya ndərə aanə giŋwə kaa ca ɗa də'wa. ");
INSERT INTO gde_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Ma ca ɗa də'wa, wata kə zə'ugi kəŋwaciinəkii, kə uuɗagi kəjeerənaakii talə talə, agi ɓərənə əsə. ");
INSERT INTO gde_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Ndza'a gi'u ha'ə, wata watiitsə ənji bəra'i, təya waɓəshi da Yeesu. Waatoo i Muusa da *Iliya. ");
INSERT INTO gde_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Kə jigagi tii da məghərəvənə. Təya waɓə agyanə aniya ŋga mbu'utəgi də slənaakii, waatoo əntənaakii də Urusaliima. ");
INSERT INTO gde_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Asee, kə kwaalagi i Piita da ənjitə aɓiikii ca'ə ca'ə ka ŋunyinə. Makə vəɗəhətə tii, wata təya nee ka məghərəvənə ŋga Yeesu da ənjitə bəra'i aɓiikii. ");
INSERT INTO gde_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Makə nji ənjitə bəra'i a ɗa rəgwa ŋga təkəginə da Yeesu, əŋki Piita ka ci, “Daada, ŋga'ə ɗii makə ganə niinə. Taku keena ratə koonə tsakabanyinə makkə: naaku rəŋwə, ŋga Muusa rəŋwə, ŋga Iliya rəŋwə.” Asee, mashiimə Piita ginə ŋga sətsə bii ci ka Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Ci ma'ə ka banə ha'a, wata kə shi məzhiɗəkwatyaminə, kə zaɗəgi tə tii. Kə ŋgwaləgi lyawarənaakii, makə zaɗəgi məzhiɗəkwatyamiitə tə tii. ");
INSERT INTO gde_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Wata əndə a waɓya dagi məzhiɗəkwatyaminə, əŋki ci, “Waatsə mataɗə Uuzənaaki. Famə tə ci.” ");
INSERT INTO gde_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Uudənə ŋga waɓəətsə ha'ə, wata maneemə lyawarənaakii ka əndə'i əndə ma'ə maɗaamə tə Yeesu daanəkii. Ma ka tsaakəya, pooshi lyawarənaakii bapaa sətə nee tii taa ka wu. ");
INSERT INTO gde_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Pukətə hakii, makə jimagərə Yeesu da lyawarənaakii a giŋwə, ɓəzə ənjə a shi ka guuŋunə da ci a rəgwa. ");
INSERT INTO gde_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Wata əndə a shigi agi daɓaala, ca maɗee ka uuraakii, əŋki ci: “Maləma, tuutəta'ə! Tsaamuu uuzənaaki, ci nə cikii, marəŋwa. ");
INSERT INTO gde_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","Agi kəəsənə nə ginaaji tə ci. Gi'u ta'avənəkii ca ka vurənə, agi ghərəvənə nə ginaajikii tə ci də ŋgwaaŋgwa'ənə, wata əbwyanə nə cikufinə a makii. Ma dzəginə nə ginaajikii kamə, də dzawuunə. ");
INSERT INTO gde_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Kə dzii nyi ciinə ka lyawarənaaku kaa təya lyaakagi ginaajikii, amma kə təkuree tii.” ");
INSERT INTO gde_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Wata Yeesu a ba, “'Ya'əmə, unə ənji ŋga zamanana, pooshi unə gi'i tə Əntaŋfə, bwaya ənja. Ca'ə guci nii kya ndzaa doona? Ca'ə guci sə'watənəki tuuna? Kirawə ka nyi uuzənaakukii ɗii!” ");
INSERT INTO gde_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Ma uuzəətə a shi, wata ginaajitə a sləbəgi tə ci aa panə, ca dəgə tə ci də ŋgwaaŋgwa'ənə. Wata Yeesu a la ŋguruunə ka ginaajita. Ca mbəɗəpaa də uuzəəta, ca ənəpaagi də ci ka dii. ");
INSERT INTO gde_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Ma ənjitə davə patə, kə ɗii ka tii ka sə ŋga hurəshishinə nə ɗuunuunə ŋga Əntaŋfə. Ma patənə ŋga ənjə a tsaamə dagwa dagwaanə ŋga sətə slənyi Yeesu patə, Yeesu a ba ka lyawarənaakii, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Kapaamə liminuunə ŋga'ə koona fa sənə cii kya ba koonə: ka vəginə nə ənji tə Uuzənə ŋga əndə aacii ənja.” ");
INSERT INTO gde_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Amma, ma lyawarənaakii, pooshi tii paaratəgi də waɓəətsa. Kə ndzaanə ka tii ma'umbeekii, acii ga təya fii. Kə ŋgwaləgi tii əsə ka ləgwanə ka ci agyanəkii. ");
INSERT INTO gde_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Kə hwaɗəgi mabizhinə ahada lyawarənə ŋga Yeesu, təya laagwashi ahadatii kaa təya shii taa wu palee də gawuunə ahadatii. ");
INSERT INTO gde_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Amma, ma Yeesu, makə shii ci hiima ŋga nətii ha'ə, wata ca ŋgərə uuzənə, ca kəŋee ka ci aɓiikii, ");
INSERT INTO gde_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","əŋki ci ka tii, “Taa wu liwə uuzənə, maɗa putaaki liwə ci, tə nyi liwə ci ətsa. Ma əndətə liwə tə nyi, tə Əndətə sləkee ka nyi liwə ci ətsa. Acii taa wu palee də daraanə ahadoonə patə, ci nə əndə ətə palee də gawuunə.” ");
INSERT INTO gde_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Wata Yoohana a jikəvə ka Yeesu, əŋki ci, “Daada, kə nee inə ka əndə ca lyaakagi ginaajinyinə də ləməku. Amma makə nee inə, paa ci ka maguŋuura deenə, kə təŋapaa inə tə ci.” ");
INSERT INTO gde_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Wata əŋki Yeesu ka ci, “Goona təŋapaa tə ci. Acii ma əndətə makaareemə koonə, noonə nə ci.” ");
INSERT INTO gde_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Makə uugi uusəra ŋga ndərənə ŋga Yeesu aadəgyə mbishanə, kə ɗatə ci aniya saakii ŋga dzənə aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Wata ca sləkee ka ənji zəku'i. Təya palə, təya dzəgərə aasəkə əndə'i vəranə anə hanyinə ŋga Samariya ka haɗa ka ci də ha ŋga ndzaanə davə. ");
INSERT INTO gde_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amma, maluuvəmə ənji vəranəkii ka ci, acii kə shii tii oo'i, aa Urusaliima cii kəya moo dzənə. ");
INSERT INTO gde_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Makə fii lyawarənaakii ha'ə, wata əŋki i Yakubu da Yoohana ka ci, “Slandana, kə mwayi hə keena ba, wa gunə a jima kaa ca zamagi də tii kwa?” ");
INSERT INTO gde_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Amma wata Yeesu a zə'ugi aadəɓii tii, ca wazə ka tii. ");
INSERT INTO gde_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Ma daba'əkii, təya palə ka əndə'i vəranə. ");
INSERT INTO gde_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ma təya dzə a rəgwa, wata əndə'i əndə a ba ka Yeesu, əŋki ci, “Taa aama gi hə patə, ka nə'unə nə nyi tə hə.” ");
INSERT INTO gde_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Yeesu a ba ka ci, “Ma gwahyanə, tə'i gu'unyinatii. Ha'ə nə əginyinə əsə, tə'i kuvənyinatii. Amma, ma nyi, Uuzənə ŋga ənda, pooshi haaki bahə ŋga kapaa taŋgalaki davə.” ");
INSERT INTO gde_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Əŋki Yeesu ka əndə'i əndə əsə, “Nə'uu tə nyi.” Amma əŋki əndəta, “Slandana, taku kaa nya dzə ka ŋgəɗəgi tə daadə zəku'i.” ");
INSERT INTO gde_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Yeesu a ba ka ci, “Wa maməətə ənjə a ŋgəəɗə maməətə ənjatii. Amma, ma ha, duu ka waazanə ka ənji agyanə ŋwaŋuunə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Əŋki əndə'i əndə ka Yeesu əsə, “Slandana, ka nə'unə nə nyi tə hə, amma kapaa ka nyi rəgwa zəku'i kaa nya dzə ka banə ka ənji geenə, a ta'avə tii.” ");
INSERT INTO gde_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Əŋki Yeesu ka ci naakii, “Taa ŋgutə əndə ca uuza, ca dzə də tsaamənə aaba'əkii, pooshi uushi cii kəya ɓələpaa. Makə ətsə ha'ə nə əndə slənənə ka ŋwaŋuunə ŋga Əntaŋfə əsə, maɗa kə caamə ci aaba'a, pooshi uushi cii kəya ɗapaa.” ");
INSERT INTO gde_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Ma daba'əkii, kə ta'i Yeesu Slandanə hara ənji məɗəfə pu'unə aji bəra'i. Kə sləkee ci ka tii ənji bəra'i bəra'i zəku'i aasəkə vəranyinə patə i ka patənə ŋga hatə cii kəya ba dzənə də naakii na. ");
INSERT INTO gde_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Ma ətsə kaa təya palə, əŋki ci ka tii, “Laŋə nə slənə cifanə, amma gi'u nə ənji slənəkii. Acii ha'ə, ɗamə də'wa ka Slanda ra, kaa ca tsakə sləkeenə ka ənji sləna, təya shi ka slənə cifanə. ");
INSERT INTO gde_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Paləmə! Ma nə nyi ka sləkeenə koonə, makə sətə ci uuji bagiinə a dzəgərə aagi furətsoofanyinə. ");
INSERT INTO gde_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Goona ŋgərəənə kwaɓa, taa mbuura. Goona ŋgərəənə əndə'i ɓiɓinə əsə. Ma una dzə, goona səkəpaanə ka nəəhəshinə a rəgwa. ");
INSERT INTO gde_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Yitə dəməgəruunə aa dəvə patə, bamə zəku'i: ‘Wa Əntaŋfə a kira ndzaanə jamə aa hanə aasii.’ ");
INSERT INTO gde_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Maɗa tə'i əndə bahə upaa ndzaanə jamə gatə asii, ka upaanə nə ci də nəhəpaanə goonə tə ci. Maɗa pooshi, wa jamənə goonə a ənə koonə sə goonə. ");
INSERT INTO gde_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Maɗa kə liwə tii tuunə, ndzaamə gatə asii. Adəmə, samə sətə nə ənjə a vii koonə davə. Acii ma əndə sləna, kə dəɓee ənjə a ki'i ka ci zaarənaakii. Goona dəəmə ka yi ka ya. ");
INSERT INTO gde_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Vəraatə dəməgəruunə aa dəvə patə, maɗa kə liwə ənji tuunə davə, adəmə sətə nə ənjə a vii koonə. ");
INSERT INTO gde_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Mbəəɗəpaamə də ənji bwanea. Bamə ka ənji oo'i: ‘Kədəhə nə Əntaŋfə ka ɗa ŋwaŋuunaakii ahadoonə.’ ");
INSERT INTO gde_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amma, vəraatə dəməgəruunə aa dəvə patə, maɗa maluumə ənji tuunə davə, shigimə davə. Dəmə ka hatə ci ənjə a ndzaanə dzuɓə, una ba ka ənja: ");
INSERT INTO gde_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","‘Taa bərəbərə ŋga vəranə goonə ənə ndərəvə aa səɗiinə, waniinə ca gwa'aanə koonə sə goonə. Amma shiitəmə oo'i, kədəhə nə Əntaŋfə ka ɗa ŋwaŋuunaakii ahadoonə.’ ” ");
INSERT INTO gde_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Yeesu a tsakə banə ka tii, əŋki ci, “Wanyinə ca ba koonə: ma uusəra ŋga ɗa gəŋwana, kadə nə gəŋwanə ŋga ənji vəranəkii a palee ka ŋga ənji *Sadooma də iza'unə.” ");
INSERT INTO gde_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“Kə ɗii anuunə, ənji Koorazinə! Kə ɗii anuunə, ənji Batəsayida! Acii maci ma sə ŋga hurəshishiitə ɗaaɗii asəkə vəranyiitsə goonə, də Tiira da də Sidoonə ɗii, kaɗa kə ŋgaaŋgii tii dəgəjinyinə, təya ndzaanə agi əntəɗaka ka ɓaariinə oo'i, kə baa tii ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Ci ɗii, ma uusəra ŋga ɗa gəŋwana, kadə paleenə nə gəŋwanə goonə ka ŋga ənji Tiira da ŋga ənji Sidoonə də iza'unə. ");
INSERT INTO gde_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Ya unə, ənji Kafarənahumə, ma nuunə ka banə saŋa, kadə ndərənə nuunə aadəgyə kwa? Pooshi unə ka ndərənə. Aagi gutə suŋwə kagərə nə ənji tuunə!” ");
INSERT INTO gde_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Əŋki Yeesu ka lyawarənaakii əsə, “Ma əndətə fii tuuna, tə nyi fii ci. Ma əndətə kaaree koonə əsa, ka nyi kaaree ci. Ma əndətə kaaree ka nya, ka Əntaŋfə ətə sləkee ka nyi kaaree ci.” ");
INSERT INTO gde_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Ma daba'ə palənə ŋga ənjitə məɗəfə pu'unə aji bəra'i ka ha ŋga ɗa waaza, kə ənya tii də mooɗasəkə ka shaŋə, əŋki tii ka Yeesu, “Slandaniina, taa ginaajinyinə maa, maɗa kə waɓiinə ka tii də ləməku, kə fii tii tiinə.” ");
INSERT INTO gde_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Wata əŋki ci ka tii, “Kə nee nyi ka *Seetanə ca kulya dadagyə makə pyapiɗənə ŋga vəna. ");
INSERT INTO gde_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Wiitsa, kə vii nyi koonə baawəɗa ŋga wiigi'inə agyanə rəhunə da məgaŋgaŋa i baawəɗa agyanə dabaranyinə ŋga Seetanə patə. Pooshi uushi bwayakii na upaa tuunə. ");
INSERT INTO gde_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amma goona ɗa mooɗasəkə acii makə fii ginaajinyinə tuunə. Gəɗə kə ɗii unə mooɗasəkə acii makə ɗii ləmuunə manaahəkii dagyə.” ");
INSERT INTO gde_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Ma ka saa'ikii ha'ə, kə uuɗagi səkə ŋga Yeesu aashi Malaaɓa Ma'yanə ka shaŋə. Wata əŋki ci, “'Ya'ə Daada, Slandanə ŋga dadagya da ŋga duuniya, kə kuyirii nyi tə hə, acii ma sətə hiwee hə acii ənjitə shii uushi'inə da ənji hiima, kə ɓaarəgi hə ka ənji saakii. Ha'ə ɗii, Daadə, acii ha'ə makə ətsə kaɗeesəkə ka hə.” ");
INSERT INTO gde_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Wata əŋki ci ka ənja, “Patənə ŋga uushi'inə, aaciiki ba'avə Daadə. Pooshi ənji shii taa wu nə nyi maɗaamə Daadə. Pooshi ənji shii taa wu nə Daadə əsə maɗaamə nyi da ənjitə ta'i nyi kaa nya ɓaariigi ka tii tə ci.” ");
INSERT INTO gde_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Ma daba'əkii, Yeesu a zə'ugi aadəɓii lyawarənaakii, əŋki ci ka tii daanətii, “Tə'i barəkaanə ashuunə acii agi neenə nuunə ka sətə ca ɗaaɗa. ");
INSERT INTO gde_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Acii wanyinə ca ba koonə: laŋə nə anabiinə da meeminə mwayi ka shaŋə kaa təya nee ka sənə cuuna nee, amma maneemə tii. Kə mwayi tii fanə tə sənə cuuna fa, amma mafamə tii əsə.” ");
INSERT INTO gde_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Wata əndə'i maləmə a maɗətə, ca gwaŋə ka laagwa uushi'inə ama Yeesu kaa ca shii kəsənə tə ci agi waɓənaakii, əŋki ci ka ci, “Ya ənə Maləma, mi dəɓee ɗanəki kaa nya upaa əpinə ətə pooshi ka uudəna?” ");
INSERT INTO gde_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Əŋki Yeesu ka ci, “Mi saŋə bii bariya ŋga Əntaŋfwa? Mi cii kəya moo bana?” ");
INSERT INTO gde_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Wata əndətə a ba ka Yeesu, “Uuɗuu tə Əntaŋfə Slandanəku də ədzəmə rəŋwə, də patənə ŋga əpinaaku, də patənə ŋga ŋgeerənaaku, də patənə ŋga haŋkalaaku. Uuɗuu tə əndətə aɓiiku əsə makə sətə cii kwa uuɗə naaku na.” ");
INSERT INTO gde_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Wata əŋki Yeesu ka ci, “Awa! gooŋgaaku. Maa agi ɗanə nə hə ha'ə, ka upaanə nə hə əpinə.” ");
INSERT INTO gde_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Amma, ma maləməta, kə mwayi ci ɓaariinə oo'i, əndə gooŋga nə ci. Wata ca ləgwa ka Yeesu, əŋki ci, “I wu saŋə nə ənjitə aɓiikya?” ");
INSERT INTO gde_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Əŋki Yeesu ka ci, “Fatə, tə'i əndə'i əndə sha ma'i də Urusaliima kaa ca dzə aa Yarikoo. Ma ca dzə, wata kə kulavə ci aasəkə maaba. Təya ŋgwaafəgi kəjeerənyinə ashikii, təya fəsləgi tə ci, dara əpinə mbiɗee tii a makii. Wata təya palə satii. ");
INSERT INTO gde_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Asee, tə'i əndə'i *limanə ca dzənaakii. Makə lapaa ci tə əndətə gujaɓə, wata ca wusləgi aadə taŋgala rəgwa, ca pitəgi saakii. ");
INSERT INTO gde_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ha'ə əsə wata əndə'i əndə agi slikərənə ŋga *Leewi a shinaakii. Makə lapaa ci tə əndətə əsə, wata ca wusləgi aa taŋgala rəgwa, ca pitəgi saakii. ");
INSERT INTO gde_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amma tə'i əndə'i əndə Samariya ca dzə naakii oogə da gatə da rəgwa. Wata ca lapaa tə ci. Makə nee ci ka əndətə gujaɓə, kə nyihə ci təgunuunaakii. ");
INSERT INTO gde_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Ca əntsahətə aaɓiikii. Ca ŋgərə maarə da ma'i inabi, ca həəjivə ka ci ka uyiginə, ca fuuɗətə ka ci uyigiita. Ca ndərəvə də ci aa ba'a vaməndaakii, ca kərəgi tə ci aa kuvə mu'uminə, ca haɗatəgi də ci davə. ");
INSERT INTO gde_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Pukətə hakii, ca ŋgiragi *hwaslə bəra'i, ca vii ka slanda kuvəta, ca ba ka ci: ‘A nəhətə hə ka nyi əndəna. Maɗa kə ziigi hə də uushi palee ka əna, maa kə ənya nyi, ka shinə nə nyi ka ki'inə ka hə saaku.’ ” ");
INSERT INTO gde_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Wata əŋki Yeesu ka maləməta, “Ya ha, ya agi ənjinyiitsə makka, wu nə əndə ŋga əndətə kulii ənji maabətə aagyanəkəya?” ");
INSERT INTO gde_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Wata əŋki maləmətə ka Yeesu, “Əndətə ɗii ka ci ŋga'əənə.” Əŋki Yeesu ka ci, “Yoo, kə fii hə. Duu də ɗanə ha'ə makə ətsa.” ");
INSERT INTO gde_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Ma Yeesu da lyawarənaakii a dzə, wata təya mbu'u aasəkə əndə'i vəranə. Ma dava, tə'i əndə'i minə ətə ɗii ləmətə Marəta. Kə liwə ki tə ci aa hatə aasii. ");
INSERT INTO gde_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Tə'i cikəŋuci əsə ətə ɗii ləmətə Mariyaama. Ma kya, kə gi ki, kya ndzaanə dasə a panə atsaa səɗə Yeesu Slandana, ka fa sətə cii kəya dzəgunə ka ənja. ");
INSERT INTO gde_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Ma Marəta natə əsa, wata kə ŋgərəgi slənə ŋga makinə haŋkalatə də ŋgwaaŋgwa'ənə. Wata kya shi aaɓii Yeesu, əŋki ki ka ci, “Ya ənə Slandana, ŋga'ə ka hə makə bwasee cikəŋunəki ka nyi, nyi daanəki, ka paka'anə da slənə nii? Bawə ka ki, wa kya shi ka tsakənə tə nyi ɗii.” ");
INSERT INTO gde_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Wata əŋki Yeesu Slandanə ka ki, “Hə Marəta, kə ənvutə hə naaku nə də uushi'inə laŋə. ");
INSERT INTO gde_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","Amma uushi rəŋwə saakii nəndə madəɓəkii. Mariyaama tagi ŋunyi uushə ətə pooshi ənji ka mbeenə ka gutsəginə aciitə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Ma ka əndə'i uusəra, Yeesu a ɗa də'wa ka əndə'i ha. Makə uudəpaa ci, wata əndə'i əndə agi lyawarənaakii a ləgwa ka ci, “Slandaniina, dzəgunətə keenə ɗa də'wa makə sətə jigunyi Yoohana ka lyawarənaakii.” ");
INSERT INTO gde_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","Wata əŋki Yeesu ka tii, “Ma una ɗa də'wa, ma banuuna: ‘'Ya'ə Dəsəniina, ɗawə ka taa wu patə a dəla də ləməku. Ɗawə ŋwaŋuunaaku taa da patə. ");
INSERT INTO gde_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Duu də ndii keenə zəmə ŋga adənə uusəra patə. ");
INSERT INTO gde_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Tifyagi keenə 'waslyakəənə geenə, makə sətə ciina tyaafagi ka ənji patə ətə ca ɗaaɗa keenə 'waslyakəənə. Ga ha kapaa tiinə ka rəgwa pu'unə.’ ” ");
INSERT INTO gde_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","Ca tsakə banə ka tii, əŋki ci, “Yaci tə'i əndə'i əndə agyuunə da guvakii. Kə ma'i ci, kə gi ci aa hakii ahada vəɗa, ca ba ka ci: ‘Guvakya, ndii ka nyi zəma. ");
INSERT INTO gde_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","Acii tə'i əndə'i guvaki wuslyagərə aa haki əndzə'i. Oogə nə ci ka dzənə. Pooshi taa mi aciiki ŋga viinə ka ci əsə.’ ");
INSERT INTO gde_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","Yaci kə jika guvakii ətə ka ci da kumu, əŋki ci, ‘Hərəpaa tə nyi kəɗa'ə! Kə uugi nyi pa'əgi makuva, kə uugiinə baanə da manjeevənaaki. Paa nyi ka mbeenə ka maɗətənə kaa nya vii ka hə zəma.’ ");
INSERT INTO gde_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Iitə na ɗa? Wiinə səndə cii kya ba koonə: Ma əndəta, paa ci maɗətə ka vii ka guvakii sətə kədii ci aciikii putə ŋga guvanatii, amma putə ŋga yiirə ŋunyinə agikii ma'i ci ka viinə ka ci sətə dəɓee ka ci patə. ");
INSERT INTO gde_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“Ma nya, wanyinə ca ba koonə əsə: ma ɗanuuna, kədiimə, ka viinə nə ənji koonə sətə kədii unə. Aləmə, ka upaanə nuunə sətə alyuunə. Dzamə makuva, ka wunəginə nə ənji koonə makuva. ");
INSERT INTO gde_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Acii taa wu patə kədii, ka viinə nə Əntaŋfə ka ci. Taa wu patə ali əsə, ka upaanə nə ci səkii. Ka wunəginə nə ənji ka əndətə dzii makuvə əsə. ");
INSERT INTO gde_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Ŋgutə dənə saŋə ahadoonə ca ŋgərə rəhunə, ca vii ka uuzənaakii maɗa ləguyi ci hərəfina? ");
INSERT INTO gde_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Anii ka ŋgərənə nə ci məgaŋgaŋə, ca vii ka ci maɗa ləguyi ci alina? Pooshi. ");
INSERT INTO gde_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Taa unə məŋgərəkikinyinə maa, kə shii unə vii ŋunyi uushi'inə ka manjeevənə goonə; sakwa Dəsənuunə ətə dagyə ɗii, ka sləkeenə nə ci ka Malaaɓa Ma'yanə ka ənjitə ca kədii aciikii əsə!” ");
INSERT INTO gde_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Ma ka əndə'i uusəra, kə lyaakagi Yeesu ginaaja ashi ənda. Ma ginaajikəya, agi kəsəginə nə ci gana a ma əndəkii, pa ca mbee ka waɓənə. Makə dzəgi ginaajita, wata masəganatə a ndzaŋə waɓənə. Ənjitə nji dava, kə ɗii ka tii ka sə ŋga hurəshishinə. ");
INSERT INTO gde_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amma əŋki hara ənja, “Də baawəɗa ŋga *Byaləzabulə, ŋwaŋwə ŋga ginaajinyinə, nə ci ka lyaakagi ginaajinyinə.” ");
INSERT INTO gde_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ma hara ənji əsa, kə mwayi tii fa bwaya waɓənə a ma Yeesu. Təya ba ka ci, a ɗa ci ka tii sə ŋga hurəshishinə kaa təya shii oo'i, də baawəɗa ŋga Əntaŋfə nə ci ka lyaakagi ginaajinyinə. ");
INSERT INTO gde_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","Amma, ma Yeesu, kə shii ci hiimatii. Wata əŋki ci ka tii, “Taa ŋgutə ŋwaŋuunə təkəgi bəra'i putə ŋga mabizhinə, ka əntənə nə ŋwaŋuunəkii. Yikii əsa, ka ɗaginə ka uufinə. ");
INSERT INTO gde_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Wanuunə ka banə oo'i, də baawəɗa ŋga Byaləzabulə nə nyi ka lyaakagi ginaajinyinə. Waatoo, agi panə nə *Seetanə da naakii nə kwa? Aa iitə mbeenə ŋwaŋuunaakii ka kəŋaanənə ɗiya? ");
INSERT INTO gde_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Yoo, maɗa də baawəɗa ŋga Byaləzabulə cii kya lyaakagi ginaajinyinə, aa wu ɗii vii ka *lyawarənə goonə natii baawəɗa ŋga ɗanə ha'a? Slənatii na ɓaarii oo'i, ma sətə cuuna hiima, pooshi tahu tahu. ");
INSERT INTO gde_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amma makə ɗii ci, də baawəɗa ŋga Əntaŋfə cii kya lyaakagi ginaajinyinə, yoo, ci ɓaarii oo'i, kə njaŋə Əntaŋfə ɗa ŋwaŋuunə ahadoonə. ");
INSERT INTO gde_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","“Ma mandalə ənda, maɗa ma'aanəkii nə ci ka nəhə yaakii, pooshi uushi ca uree ka uushi'inaakii. ");
INSERT INTO gde_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amma, maɗa kə shi əndətə palee ka ci də ŋgeerənə ka ənslənə tə ci, ka hwaməpaanə nə ci tə ci, ca gutsətə patənə ŋga uushi'inə ŋga pagiitə cii kəya hwafəgi, ca təkəpaa ka ənjaakii. ");
INSERT INTO gde_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","“Taɗa wu nə əndə pooshi liwə tə nyi, əndə daawaanaaki nə ci ətsa. Taɗa wu nə əndə pooshi agi tsakənə tə nyi agi tsəəkənə əsə, əndə kuzhiɗəginə nə ci.” ");
INSERT INTO gde_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“Maɗa kə dzəgi ginaaji ashi ənda, ka dzənə nə ci kura'ə aagi bilinə ka hatə pooshi ma'inə davə ka alə ha ŋga əpisəka. Maɗa malapaamə ci ha, ka banə nə ci ka naakii na, ‘A ənə nyi saaki ka hatə shigi nyi davə.’ ");
INSERT INTO gde_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Wata ca ənə aa dəvə, ca dəməgərə, ca lapaa hakii maslaabakii, mahaɗakii ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","Makə nee ci ha'ə, wata ca palə ka 'waa'wa hara ginaajinyinə məɗəfə ətə palee ka ci də məzaanə. Təya shi, təya dəməgərə aashi əndəta, təya ndzaanə. Ma ndzaanə ŋga əndəta, ka ɗanə təgugunə palee ka ŋga ŋukə.” ");
INSERT INTO gde_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Baginə ŋga Yeesu ha'ə, wata əndə'i minə gatə agi daɓaala a waɓə da ci, kya ba ka ci, “Tə'i barəkaanə ashi miitə pwayi tə hə, ətə sii hə 'wanə a matə.” ");
INSERT INTO gde_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Wata əŋki Yeesu ka ki, “Amma, ənjitə ca fa waɓənə ŋga Əntaŋfə, təya nə'utə, palee də barəkaanə.” ");
INSERT INTO gde_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Ma ətsə daɓaala a tsakə ɗanə laŋə aɓii Yeesu, wata ca ndzaŋə banə ka tii, əŋki ci, “Ma ənji ŋga zamanana, bwaya ənja. Agi alənə nə tii kaa ənjə a ɗa ka tii sə ŋga hurəshishinə. Amma pooshi sə ŋga hurəshishinə ci ənjə a ɗa ka tii, maɗaamə ətə ɗii Əntaŋfə də anabi Yunana. ");
INSERT INTO gde_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Waatoo, makə sətə ndzaa Yunana ka sə ŋga hurəshishinə ka ənji vəranə ŋga Niniva, ha'ə nə Uuzənə ŋga əndə a ndzaanə ka sə ŋga hurəshishinə ka ənji ŋga zamananə əsə. ");
INSERT INTO gde_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Ma uusəra ŋga ɗa gəŋwana, kadə nə miitə ɗii ŋwaŋuunə agyanə hanyinə ŋga Saba a maɗə, kya vii ma'inə ka ənji ŋga zamanana, acii kə ma'ya ki dzaɗə daga anə hanyinatə, kya shi aaɓii ŋwaŋwə Sulayimaanu, kaa kya fa macicirə dzəgunənaakii. Yoo, tə'i sətə palee ka Sulayimaanu ganə; amma pooshi unə agi fa waɓənaakii. ");
INSERT INTO gde_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Ma uusəra ŋga ɗa gəŋwana, kadə nə ənji Niniva a maɗə, təya vii ma'inə ka ənji ŋga zamanana, acii makə fii tii waazanə ŋga Yunana, kə baa tii ka Əntaŋfə. Yoo, tə'i sətə palee ka Yunana ganə, amma pooshi unə baanə ka ci.” ");
INSERT INTO gde_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","“Pooshi əndə ca təzəvə gunə aasəkə garəkuwa ka kapaanə ka ma'umbee ha taa ca umbətə də kəŋwə əsə. Amma ka madzakə ha dzakəpaanəkii, kaa ənjitə ca dəmə aa kumu a nee ka ha camə. ");
INSERT INTO gde_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","“Ma ginəku, makə garəkuwa nə ci ka shishinə. Maɗa jamə nə ginəku, agi maɓərəha nə hə ətsa. Amma, maɗa pooshi ginəku ndaŋə ndaŋə, agi təkunə nə hə ətsa. ");
INSERT INTO gde_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Aciikii ɗiya, aa ha nəhə acii ga ɓərənaaku a ndzaanə ka təkunə. ");
INSERT INTO gde_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Maɗa ma ɓərəətə ashiku, pooshi təkunə taa gi'u agikii, ka ɓərənə ka shaŋə makə sətə ci garəkuwa a ɓərə.” ");
INSERT INTO gde_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Uudəpaanə ŋga Yeesu waɓənə ha'a, wata əndə'i əndə Farisa a 'wa tə ci aa hakii aasii ka zəma. Fanə ŋga Yeesu ha'a, wata ca palə, təya ndzaŋə adə zəma. ");
INSERT INTO gde_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Neenə ŋga əndə Farisatə ha'ə, kə kəŋee ka ci acii pooshi Yeesu yiɓəgi ciinəkii zəku'i makə sətə bii alə'aada ŋga *Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Wata əŋki Yeesu Slandanə ka ci, “Ma unə ɗiya, unə Farisanyinə, agi ɓəəzəginə nuunə ba'a ŋga kwalaka da ŋga doosa. Amma, ma dasəkə ədzəmuunə, ŋga'ə koonə nə əmbanə, məŋgərəkikinyinə nuunə əsə. ");
INSERT INTO gde_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Pooshi nuunə ta'a! Ya Əntaŋfə ətə ɗapaa rəgwa ba'a, maɗapaamə ci rəgwa səkə əsə kwa? ");
INSERT INTO gde_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","Gəɗə ma ɗanuunə ɗiya, viimə ka maaghiinə sətə asəkə kwalakinə goonə, da asəkə doosənyinə goonə. Ma ətsə ɗiya, taa mi goonə patə ka ndzaanə camə. ");
INSERT INTO gde_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“Amma, tə'i ŋgəra'wə ashuunə, unə Farisanyinə, acii agi viinə nuunə zaka ŋga ŋunyi banyinə kama kama. Amma, paa unə ka slənə uushi də rəgwakii, paa unə ka uuɗənə tə Əntaŋfə əsə. Wiitsə səndə dəɓee ɗanuunə, amma, ga ca zaanə koonə əsə nə vii zaka. ");
INSERT INTO gde_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“Tə'i ŋgəra'wə ashuunə, unə Farisanyinə, acii ma una, ka hatə da ginə davə moonuunə ndzaanə asəkə *kuvə də'wa. Ma moonuunə əsa, a nəhəpaa ənji tuunə ŋga'ə a luuma. ");
INSERT INTO gde_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","Tə'i ŋgəra'wə ashuunə, acii makə gu'u ənji ətə pooshi ənji nee nuunə, ənjə a wiigi anəkii yadə shiinə.” ");
INSERT INTO gde_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Wata əndə'i əndə agi maliminə ŋga bariya a maɗətə, ca ba ka Yeesu, əŋki ci, “Maləma, ma ha waɓə ha'ə ɗiya, agi dzaananə nə hə tiinə da i inə əsə.” ");
INSERT INTO gde_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","Wata əŋki Yeesu, “Tə'i ŋgəra'wə ashuunə əsə, unə maliminə, acii agi ŋgərəvənə nuunə ka ənji mazəzəkə kərənə 'wa'ə. Taa də mashiku ciinuunə pooshi unə ka tsakənə tə tii. ");
INSERT INTO gde_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","“Tə'i ŋgəra'wə ashuunə, acii agi ghənətənə nuunə nə ŋga gu'u ŋga anabinyinə ŋga'ə. Yoo, dzədzəshi'inuunə ɓəələgi tə tii. ");
INSERT INTO gde_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ma ətsə ɗiya, kə ɓaarii oo'i, kə kaɗeesəkə koonə nə slənə ŋga dzədzəshi'inuunə; acii ma təya, kə ɓəələgi tii anabinyinə; ma unə əsa, agi haɗaginə nuunə də nə ŋga gu'watii. ");
INSERT INTO gde_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Putakii ha'ə ɓaarii Əntaŋfə shiinaakii, ətə bii ci oo'i: ‘Kadə nii kya kaala ka tii anabinyinə da masləkee ənja. Kadə nə təya ɓəələgi hara ənji agitii, təya ciɓee ka hara ənji əsə.’ ");
INSERT INTO gde_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Acii ha'ə, patənə ŋga anabinyiitə ɓəələgi ənji njaŋanə ka taganə ŋga duuniya ca'ə ka əndzə'i, anə ənji ŋga zamananə nə gəŋwanəkii. ");
INSERT INTO gde_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Waatoo njaŋanə ka ɓələnə tə Habiila, ca mbu'ya ka ŋga Zakariya. Ma ca, ahada maɗuunə kuvə ŋga Əntaŋfə da ha ŋga ɗa sataka ɓələgi ənji tə ci. Weewee wanyinə ca ba koonə: aanə ənji ŋga zamananə nə gəŋwanə ŋga ɓəələhiitsə a kulaanə. ");
INSERT INTO gde_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","“Tə'i ŋgəra'wə ashuunə, unə maliminə, acii kə pa'əgyuunə rəgwa ŋga shiinə də Əntaŋfə agyanə ənja. Unəkii əsa, mapitəgimuunə davə. Ma ənjitə ca moo pitəginə davə əsa, agi təŋaginə nuunə tə tii.” ");
INSERT INTO gde_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Ma ətsə Yeesu a palə saakii, wata maliminə da Farisanyinə a ənəgi ka ci də mabu ədzəma, acii kə ɓəzəgi səkətii aashikii ka shaŋə. Təya ndzaŋə laagwa ka ci waɓənə laŋə, ");
INSERT INTO gde_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","kaa təya shii kəsənə tə ci agi waɓənaakii. ");
INSERT INTO gde_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Tə'i əndə'i saa'i, kə dzii ənji də nə laŋə dərəva. Ha'ə maa wiinə nə ənjə a ba'a səɗə ŋga ənja. Wata Yeesu a waɓə da lyawarənaakii zəku'i, əŋki ci ka tii, “Nəhəmə noonə na acii goona ɗagi ka ənjitə ca kərə ka Əntaŋfə də bəra'i asəkətii makə ŋga Farisanyinə. Acii kə ndzaa tii makə burəŋanə ətə ca əbutə mahwaɗə əmpunə patə. ");
INSERT INTO gde_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Taa mi patə nəndə ma'umbeekii, kadə na shigi agyə. Taa mi patə nəndə mashiimə ənji əsə, kadə nə ənjə a shii. ");
INSERT INTO gde_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Acii ma sətə cuuna waɓə ka təku təkunə, ka fanə nə ənji ka macama ha. Ma sətə cuuna bavə ka əndə a liminəkii də matatahinə əsə, unə ka mapa'ə makuva, kadə wazəginə nə ənji a babara.” ");
INSERT INTO gde_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","“Wanyinə ca ba koonə, unə guviinəki: goona ŋgwalə acii ənja. Acii wata tə ba shishinə mbeenə nə tii ka ɓələginə, amma, ma daba'əkii, pooshi uushi ci təya mbee ka ɗanə ma'ə palee ka ətsa. ");
INSERT INTO gde_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Wanyinə ca ba koonə əndətə dəɓee una ŋgwalə: ŋgwaləmə tə Əntaŋfə. Acii ma ca, makə ŋgərəgi ci əpinə a ma ənda, ka mbeenə nə ci ka kagərənə tə ci aagi gutə suŋwa. Awa, wanyinə ca ba koonə: tə cikii dəɓee una ŋgwalə. ");
INSERT INTO gde_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“Əntaa tufə ci ənjə a vii əginyinə ka kwaɓa bəra'i kwa? Amma patə da ha'ə, pooshi taa rəŋwə ahadatii ətə ca zaanə ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Taa shiŋkinə ŋga nuunə maa, maɓaanakii patə acii Əntaŋfə. Makə ha'ə ɗiya, goona ŋgwalə: kə palee unə ka əginyinə patə də məghərəvənə.” ");
INSERT INTO gde_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","“Wanyinə ca ba koonə əsə, maɗa kə bagi əndə paŋgəraŋə akəŋwacii ənji oo'i naaki nə ci, nyi maa, *Uuzənə ŋga ənda, ka banə nə nyi paŋgəraŋə akəŋwacii malaa'ikanyinə oo'i naaki nə ci uusəratə nə Əntaŋfə a ɗa gəŋwanə. ");
INSERT INTO gde_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amma, ma əndətə kaaree ka nyi akəŋwacii ənja, nyi maa, Uuzənə ŋga Ənda, ka kaareenə nə nyi ka ci akəŋwacii malaa'ikanyinə uusəratə nə Əntaŋfə a ɗa gəŋwanə. ");
INSERT INTO gde_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","“Taa wu bii bwaya uushi aashiki, nyi Uuzənə ŋga ənda, ka tifyaginə nə Əntaŋfə tə ci. Amma, ma əndətə bərapaa tə Malaaɓa Ma'yanə, pooshi Əntaŋfə ka tifyaginə tə ci. ");
INSERT INTO gde_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","“Maɗa kə kirə ənji tuunə aakəŋwacii gəŋwanə aasəkə kuvə də'wa, taa aakəŋwacii harii gayinə, goona ənvutə noonə nə ka buurə sətə nuuna jikəvə ka tii ka luupaa də noonə na. ");
INSERT INTO gde_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Acii Malaaɓa Ma'yanə na dzəgunətə koonə sətə nuuna ba ka saa'ikii.” ");
INSERT INTO gde_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Wata əndə'i əndə agi daɓaala a jikəvə aagi waɓənə ŋga Yeesu, əŋki ci, “Maləma, bawə ka nyi ka gawaaki, wa ca təkəpaa keenə sə ŋga zəmə də yitə bwasee dəsəniinə keenə.” ");
INSERT INTO gde_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Wata əŋki Yeesu ka ci, “Wu saŋə kapaa tə nyi ka ɗa koonə gəŋwanə, taa ka təkəpaa koonə sə ŋga zəmə də ya?” ");
INSERT INTO gde_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Wata əŋki Yeesu ka patənə ŋga ənja, “Ɗamə haŋkala, goona ndzaanə ka ənji moo gəna. Acii ma gəna, əntaa ci nəndə ka kəsəpaa əpinə a ma ənda, taa iitə nə ɓəəzənə ŋga gənakii.” ");
INSERT INTO gde_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Ca ɗa ka tii əndə'i misaali, əŋki ci, “Tə'i əndə'i əndə gəna da ha ŋga uuzanaakii sha ɗii. Kə upaa ci sə ŋga ma davə ŋgaaŋga'ə. ");
INSERT INTO gde_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Ca ndzaanə, ca hiima, əŋki ci ka naakii na: ‘Iitə saŋə ɗanəkya? Acii pooshi nyi da ha ŋga əji sə ŋga matsa.’ ");
INSERT INTO gde_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Ca jikəvə ka naakii na, əŋki ci: ‘Awa, wiinə səndə ɗanəki: a waalagi nyi dəɓunyinaaki kaa nya ghənə madiigərəkii palee ka i ətsa, nya fəɗəgərə sə ŋga maaki aa dəvə da hara uushi'inaaki. ");
INSERT INTO gde_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","Ma daba'əkii, nya ba: Kay! Tə'i sə ŋga ma aciiki laŋə! Ka mbu'unə ka nyi ka adənə agi fəzənyinə laŋə. Acii ha'ə, ka əpinə nə nyi səkə ŋga əna, ka zəmənə nə nyi, nya sa, nya ɗa maŋushinə.’ ");
INSERT INTO gde_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Amma wata əŋki Əntaŋfə ka ci, ‘Mabana! Ka vəɗənə ca shi nə nyi ka ŋgərəgi əpinə a maku. Wu saŋə na fəɗə uushi'inaaku ətsə dzatəgi ha?’ ” ");
INSERT INTO gde_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Yeesu a uudəpaa də banə, əŋki ci, “Ha'ə nə ndzaanə ŋga əndətə ca dzaadza də uushi'inə wata ka naakii na, amma paa ci əndə uushi'inə akəŋwacii Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Yoo, əŋki Yeesu ka lyawarənaakii, “Aciikii cii kya ba koonə: goona buurə sətə cuuna kavə aa moonə koona gərə də əpinə; taa sətə cuuna umbee də purəkinə goonə əsə, goona buurə. ");
INSERT INTO gde_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Acii əpinə palee ka zəmə də məghərəvənə, shishinə palee ka kəjeerənə də məghərəvənə əsə. ");
INSERT INTO gde_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Tsaaməmə əginyinə: pooshi ratii, paa tii ka slənə cifanə, pooshi kuvə shigatii, pooshi dəɓwatii əsə; amma agi adəvənə nə Əntaŋfə ka tii. Laŋə dərəva palee unə ka əginyinə də məghərəvənə! ");
INSERT INTO gde_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Wu saŋə agyuunə ca mbee ka tsakəvə gərənə ŋga əpinaakii taa gi'u putə ŋga buurə uushi'inaakəya? ");
INSERT INTO gde_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ya makə pooshi unə ka mbeenə ka ɗatə tsarə ŋga uuji uushi'inə makə ətsa, ka mi ɗii cuuna ənvutə noonə nə də buurə hara uushi'ina? ");
INSERT INTO gde_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Tsaaməmə makə sətə ci gudəzənyinə a gərə də bilə: pooshi tii ka slənənə, pooshi tii ka ɗatə kəjeerənə ka shishinətii əsə. Amma wanyinə ca ba koonə: taa ŋwaŋwə Sulayimaanu da patənə ŋga məghərəvənaakii maa, makamə ci dagwa kəjeerənə makə gudəzənyinə də bilə. ");
INSERT INTO gde_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Kə kavə Əntaŋfə kəjeerənə ka kuzhinyinə ənə ənshinə una nee, ma doorə, ənjə a ətsagi. Sakwa unə ɗii, paa ci agi vii koonə kəjeerənə kwa? Una! gi'u nə gi'inə goonə tə Əntaŋfə! ");
INSERT INTO gde_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Goona ənvutə noonə nə də aalə sə ŋga adənə da sə ŋga saasanə shaŋə. ");
INSERT INTO gde_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Acii ma uushi'iitsə pata, ənjitə mashiimə tə Əntaŋfə ca ka haŋkalatii davə. Ma Dəsənuunə, kə shii ci oo'i, ŋga'ə koonə. ");
INSERT INTO gde_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Acii ha'ə, ma ɗanuuna, kavəmə nuunə tanə ka ŋwaŋuunə ŋga Əntaŋfə. Ma hara uushi'iitsə ma'ə, ka tsakəənənə nə ci koonə. ");
INSERT INTO gde_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","Goona ŋgwalə, unə ənə ənjaaki, acii kə kaɗeesəkə ka Əntaŋfə Dəsənuunə nə vii koonə ŋwaŋuunə.” ");
INSERT INTO gde_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","“Ɗərəmagimə də uushi'inə goonə, təkəpaamə kwaɓakii ka maaghiinə. Təsləmə mbuurə ətə pooshi ka iirənə shaŋə ka əji kwaɓa davə. Dzatəgimə də uushi'inə goonə asii dagyə ka hatə pooshi ka zanə shaŋə. Ma dava, pooshi mahərə ka neenə, pooshi məbərə ka adəginə əsə. ");
INSERT INTO gde_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Acii ma hatə ɗii gəna goonə, davə ndzaanə nuunə sliŋə.” ");
INSERT INTO gde_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","“Ma ɗanuunə ɗiya, aanəmə ka ɗa sləna. Wa garəkuwa goonə a ndzaanə da i gunə asəkəkii. ");
INSERT INTO gde_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","Ndzaamə unə makə ənji slənə ətə ca gəra tə slanda yatii, ci kə pyalə ka rəya. Makə ənya ci, dzii ci maya, təya wunəgi ka ci mayi pii. ");
INSERT INTO gde_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Ma ənji slənətsa, tə'i barəkaanə ashitii, acii kə lapaa slanda yatii tə tii də məgigi. Tantanyinə cii kya ba koonə: ka aanənə nə ci, kaa ca ndzaanee ka tii, ca təkə ka tii zəma. ");
INSERT INTO gde_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Maɗa kə ənya ci təkənə ŋga vəɗə taa palee ka ha'ə, maɗa kə lii ci tə tii ka nəhənə, tə'i barəkaanə ashitii! ");
INSERT INTO gde_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Shiimə oo'i, maci ka shiinə nə slanda yi saa'itə ci mahərə a dzə ka ci aasii, paa ci ka kapaa ka ci rəgwa. ");
INSERT INTO gde_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Ma unə əsa, see a ndzaa unə matasəkakii ka gəra shinə ŋga Uuzənə ŋga ənda, acii ka shinə nə ci ka uusəratə makamuunə nə ŋga shinaakii.” ");
INSERT INTO gde_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Wata əŋki Piita, “Slandana, ya bii hə misaalitsə saŋa, wata keenə daaniinə nii, anii da i ka hara ənji pata?” ");
INSERT INTO gde_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","Yeesu a jikə ka ci, əŋki ci, “Ma əndə gooŋga ŋga əndə sləna, əndə haŋkala, tə ci kapaanə slandanəkii ka nəhə yaakii, kaa ca vii zəmə ka hara ənji slənə ka saa'itə diɓə. ");
INSERT INTO gde_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Maɗa shi slandanəkii ka lapaanə tə ci agi slənə sətə bii ci ka ci, tə'i barəkaanə ashikii. ");
INSERT INTO gde_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Tantanyinə cii kya ba koonə, ma əndətsa, ka ba'avənə nə slandanəkii patənə ŋga uushi'inaakii aaciikii. ");
INSERT INTO gde_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","Amma mbu'u ka banə nə əndə slənətə də səkəkii oo'i, ‘Pooshi slandanəki ka shinə kədəhə’. Wata ca ndzaŋə fəslənə tə hara ənji sləna, ŋguyirənə da makinə patə, ca adə ŋgaaŋga'ə, ca saasa, ca gaaɓa. ");
INSERT INTO gde_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","Yoo, ka shinə nə slandanəkii uusəratə makamə ci nə ŋga mbu'yanaakii, saa'itə mashiimə ci əsə. Ka dzalənə nə slandanəkii tə ci də ŋgwaaŋgwa'ənə, ca vii ka ci shikwa mbərə mbərə da ŋga ənjitə pooshi gi'i tə Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","“Ma əndə slənə ətə shii sətə kaɗeesəkə ka slandanəkii, amma matasəkamə ci, maslənəmə ci səkii əsə, ka fəslənə nə ənji tə ci də ŋgwaaŋgwa'ənə. ");
INSERT INTO gde_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","Amma, ma əndə slənə ətə mashiimə sətə kaɗeesəkə ka slandanəkii, ca slənə məza uushi'inə ətə bahə ənjə a dəgə tə ci ka putakii, gi'u fəsləciinə ənji tə ci. Taa ka wu vii Əntaŋfə ŋgaaŋga'ə, ŋgaaŋga'ə ləgwanəkii a makii. Taa ka wu ba'avə ci ŋgaaŋga'ə, palee ka ətə ləgwanəkii əsə.” ");
INSERT INTO gde_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","“Ma shinaaki, ka kaanə gunə aanə duuniya. Ma mwayi nyi, kaɗa kə uugi gunəkii kanə. ");
INSERT INTO gde_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","Tə'i əndə'i bapətisəma cii kya ənə ka upaanə. Ka manvu ma'yanə nə nyi, see maɗa pitəgi saa'ikii. ");
INSERT INTO gde_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Ma nuunə ka banə noonə saŋa, jamənə kira nyi aasəkə duuniya kwa? Pooshi! Əntaa jamənə kira nyi. Amma wanyinə ca ba koonə: ma shi nya, ka taakeenə ka ənja. ");
INSERT INTO gde_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Daga ənshinə, kə ndzaa təəkəshinə ahada ənji asii. Waatoo, maɗa tə'i ənji tufə asii, ma ənjinə makka, paa tii ka ndzaanə ka maguŋuura da ənjinə bəra'i; ənjinə bəra'i əsə, paa tii ka ndzaanə ka maguŋuura da ənjinə makkə. ");
INSERT INTO gde_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Pooshi dənə da uuzənaakii ka ndzaanə ka maguŋuura. Ha'ə nə mənə əsə, paa ki ka ndzaanə ka maguŋuura da uuzənatə. Pooshi sərəhwə ka ndzaanə ka maguŋuura da maɗanatə əsə.” ");
INSERT INTO gde_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Wata əŋki Yeesu ka daɓaala əsə, “Maɗa kə nee unə kuraɓiinə a ma'ya da dagərə, agi banə nuunə oo'i, ka ɗanə nə vəna. Ka ɗanə nə vənəkii əsə. ");
INSERT INTO gde_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Maɗa kə fii unə məɗə a əgya da hwarəma, agi banə nuunə, ka tsəfənə nə ha ənshinə. Ka tsəfənə ha'əkii əsə. ");
INSERT INTO gde_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Una! Də bəra'i asəkuunə cuuna kərə ka Əntaŋfə! Agi mbeenə nuunə ka təkeenə ka səndə ca ɗaaɗa anə hanyinə da i dagyə. Aa! iitə saŋə ɗii təkuree unə ka paaratəginə də ndzaanə ŋga zamanana? ");
INSERT INTO gde_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","“Mi saŋə ɗii pooshi unə ka mbeenə ka təkeenə ka sətə dəɓee una ɗa? ");
INSERT INTO gde_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Ma una dzə ka gəŋwanə, unə da əndə mbiinaaku, aluu rəgwa ŋga haɗatəginə da ci, unə ma'ə ka dzənə a rəgwa; acii ga ca kirə tə hə aasəkə gəŋwanə, mala gəŋwanə a ŋgərə tə hə, ca vii aacii soojiinə. Soojiinə, təya kərə tə hə ka pa'əginə a furəshina. ");
INSERT INTO gde_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Wanyinə ca ba ka hə: davə ndzaanəku, paa hə ka gimaginə, see maɗa ki'igi hə patənə ŋga kwaɓatə lii ənji ka hə.” ");
INSERT INTO gde_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Ma ka saa'ikii ha'ə, tə'i hara ənji jigunyi ka Yeesu sətə upaa tə hara ənji Galili. Waatoo, kə kavə *Pilaatu ka ənjə a ɓəələgi tə tii saa'itə təya ɗa sataka. ");
INSERT INTO gde_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Fanə ŋga Yeesu ha'ə, wata əŋki ci ka tii, “Ma nuunə ka nəhənə noonə, 'waslyakəənə ŋga ənjitsə palee ka ŋga hara ənji Galili bahə ciɓə tii ha'ə kwa? ");
INSERT INTO gde_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Wanyinə ca ba koonə: pooshi, əntaa ha'ə. Amma, maɗa pooshi unə baanə ka Əntaŋfə, ka zaginə nuunə unə patə makə natii. ");
INSERT INTO gde_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Ya ənjitə pu'u aji tighəsə uulaanə maɗuunə kuvə ka tii də Siiloomə, ma nuunə ka nəhənə noonə, 'waslyakəənatii palee ka ŋga hara ənji Urusaliima patə kwa? ");
INSERT INTO gde_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Wanyinə ca ba koonə: pooshi, əntaa ha'ə. Amma, maɗa pooshi unə baanə ka Əntaŋfə, ka zaginə nuunə unə patə makə natii.” ");
INSERT INTO gde_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Wata Yeesu a ɗa ka tii misaali, əŋki ci, “Tə'i uudəvə sha ɗii asəkə tsanə ŋga ənda. Ma ka əndə'i uusəra, kə gi əndətə ka slirəɓa pookii, amma malapaamə ci. ");
INSERT INTO gde_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","Wata əŋki ci ka əndə nəhə tsaata: ‘Kə nee ha, makkənə ŋga fəzə ənə nə nyi ka shinə ka slirəɓə poo ŋga uudəvəna, amma paa nyi ka dzənə də lapaanə. Ma ɗanəkwa, burəgi! Agi saaweenə nə ci ka nyi ka ha zaɓə.’ ");
INSERT INTO gde_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Amma əŋki əndə nəhə tsaatə ka ca: ‘Slandana, əntaa ha'ə. Ma wana, unee zəku'i. Ka ənseenə nə nyi ka hanyinə atsakii, kaa nya ɗavə kuɓa. ");
INSERT INTO gde_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Mbu'u ka poonə inusərə. Maɗa pooshi pwayi, aŋwa burəgi.’ ” ");
INSERT INTO gde_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Ma ka əndə'i uusəra, kə jigunyi Yeesu ka ənji asəkə kuvə də'wa. Waatoo, *uusəra ŋga əpisəka. ");
INSERT INTO gde_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","Ma dava, tə'i minə da ginaaji ashitə. Kə uugi ki ɗa fəzə pu'u aji tighəsə da i ginaajikii. Aciikii paa ki nja mbee ka maɗətənə, kya kəŋaanə da'i. Wata də məgwaŋə njii ta wii. ");
INSERT INTO gde_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Makə nee Yeesu ka ki, wata ca 'wa tə ki. Əŋki ci ka ki, “Yaaya, kə mbə'i hə acii bwaneaaku.” ");
INSERT INTO gde_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Ca ɗəkəvə ciinəkii agyanətə. Wata kya maɗətə pii ha'ə, kya kəŋaanə da'i, kya ndzaŋə dəlanə də Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Neenə ŋga gawə ŋga kuvə də'watə ha'ə, wata səkəkii a ɓəzəgi makə ɗii ci uusəra ŋga əpisəkə mbəɗəpaa Yeesu də miita. Wata gawətə a ba ka ənjitə davə, “Tə'i uusəranyinə kuwa ka ɗa sləna. Aciikii ha'ə, agi uusəranyiitsə dəɓee shinuunə ka ənjə a mbəɗəpaa duunə, əntaa *uusəra ŋga əpisəka.” ");
INSERT INTO gde_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Wata əŋki Yeesu Slandanə ka ci, “Una! Də bəra'i asəkuunə cuuna kərə ka Əntaŋfə! Taa uusəra ŋga əpisəka, agi pərəpaanə nuunə liinə goonə taa vaməndiinə goonə, una kərə tə tii ka sa ma'inə. Əntaa ha'ə kwa? ");
INSERT INTO gde_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Aa! Ya miinə shigi agi slikərənə ŋga Ibərahiima əsa, ənə gwaləgi *Seetanə tə ki fəzə pu'u aji tighəsa, madəɓeemə ənjə a pərəpaa tə ki uusəra ŋga əpisəkə kwa?” ");
INSERT INTO gde_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Makə bii Yeesu ha'ə, wata ayinə a kəsəgi tə ənji mbiinaakii patə. Amma, ma hara ənji pata, kə ɗii ka tii ka mooɗasəkə nə maŋgəmə uushi'iitə ɗaaɗii ci. ");
INSERT INTO gde_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Əŋki Yeesu ka ənja, “Takwa a dzəgunətə nyi koonə ndzaanə ŋga *ŋwaŋuunə ŋga Əntaŋfə, nya ba koonə sətə pushashi tii. ");
INSERT INTO gde_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Ma ŋwaŋuunə ŋga Əntaŋfə, kə pushashi tii da hi'u iza, əndə a ŋgərə, ca ləgapaa asəkə tsanaakii. Makə givə ci, ca gərə, ca ɗagi ka danza. Wata shinə nə əginyinə, təya ɗaaɗa kuvatii davə.” ");
INSERT INTO gde_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Yeesu a tsakə banə, əŋki ci, “Ma ŋwaŋuunə ŋga Əntaŋfə, takwa a dzəgunətə nyi koonə ndzaanaakii. ");
INSERT INTO gde_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Kə ndzaa ci makə burəŋanə, minə a gwazətəgi də kəŋwə əjima makkə ŋga əmpunə. Wata əmpunəkii patə a asləgi divə.” ");
INSERT INTO gde_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Ma Yeesu a dzə də palənə aa Urusaliima, kə gi ci dasəkə vəranyinə da giwanyinə kama kama, ca dzə də dzəgunənə ka ənja. ");
INSERT INTO gde_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Wata əndə'i əndə a ləgwa ka ci, əŋki ci, “Slandana, ya saŋa, ənji gi'u na upaa mbəɗənə nii?” Wata əŋki Yeesu ka ənjitə davə: ");
INSERT INTO gde_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Ɗamə gazhi'waanə ŋga dəməgərənə ka matya'u makuvə. Acii wanyinə ca ba koonə: ɓəzə ənji ca alə rəgwa ŋga dəməgərənə, amma paa tii na mbee ka dəməgərənə aa dəvə. ");
INSERT INTO gde_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","“Maɗa kə maɗətə slanda yi, kə pa'əgi ci makuvə, unə noonə əsə, agyə nuunə, ka ndzaŋənə nuunə dza makuvə agyanəkii, una ba ka ci: ‘Slandaniina, wunəgi keenə makuva.’ Ka jikəvənə nə ci koonə də banə: ‘Ma unə, mashiimə nyi taa ənji mi nuunə.’ ");
INSERT INTO gde_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Ma unə əsa, ka ənənə nuunə ka banə ka ci: ‘Kə zhimaamə, kə sii amə ka ha rəŋwə da hə. Asəkə vəranə geenə əsə jigunyi hə ka ənja.’ ");
INSERT INTO gde_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ma ci əsa, ka banə nə ci koonə, ‘Kə bii nyi koonə, mashiimə nyi taa ənji mi nuunə. Dzəgimə aɓiiki, unə patə ənji ɗaaɗa bwaya uushi'inə!’ ");
INSERT INTO gde_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Kadə nuuna tuu, una tsəɓə linyinə, unə kə nee ka dzədzəshi'inuunə Ibərahiima, Isiyaaku, Yakubu da anabiinə patə agi ŋwaŋuunə ŋga Əntaŋfə. Amma, ma unə, kə səbagi ənji tuunə aagyə. ");
INSERT INTO gde_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Kadə nə ənjə a ma'ya taa dama patə agi duuniya ka shinə ka zəmə əndzanə agi ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ma ka uusərakii, tə'i hara ənji agi moodəba'ənyinə na ndzaanə ka kəŋwanə. Tə'i agi ənjitə ka kəŋwanə əsə na ndzaanə ka moodəba'ənyinə.” ");
INSERT INTO gde_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Ma ka saa'ikii ha'ə əsə, kə əncahatə harii *Farisanyinə aaɓii Yeesu, wata təya ba ka ci, “Dzəgi saaku ganə, duu ka əndə'i ha, acii ŋga'ə ka *Hirudusə nə ɓələginə tə hə.” ");
INSERT INTO gde_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Əŋki Yeesu ka tii, “Dəmə, bamə ka əda mitiɓətiɓənəkii oo'i, agi lyaakagi ginaajiinə nə nyi, agi mbəɗəpaanə nə nyi də maɓərəhə ənji ənshinə da doorə; ma cifədoora, ka uudəpaanə nə nyi slənaaki. ");
INSERT INTO gde_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amma tyasə see a dzə nyi də dzənaaki aakəŋwa ənshinə, doorə da cifədoorə. Acii madəɓeemə *anabi a əntə ka əndə'i ha maɗaamə də Urusaliima.” ");
INSERT INTO gde_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","“'Ya'ə unə ənji Urusaliima, unə ənji Urusaliima, kə ɓəələgyuunə anabiinə, kə kaalatuunə də faariinə tə ənjitə sləkee Əntaŋfə koonə! Taa guci patə nə nyi agi alə rəgwa ŋga dzatəginə duunə aaɓiiki, makə sətə ci gyaagya a dzatəgi də manjeevənatə aatsatə. Amma kə naanagyuunə furəshi. ");
INSERT INTO gde_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Aciikii ka ndzaanə nə *yi ŋga Əntaŋfə gbəŋə yadə əndə davə. Wanyinə ca ba koonə əsə, pooshi unə na nee ka nyi ma'ə shaŋə, ha'ə mbu'yanə uusəratə nuuna ba oo'i: ‘Tə'i barəkaanə ashi əndətə shi də ləmə ŋga Slandana!’ ” ");
INSERT INTO gde_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Tə'i əndə'i uusəra ŋga əpisəka gi Yeesu ka zəma aa ha əndə'i gawa agi kurəgə ŋga *Farisanyinə. Asee, ma ənjitə dava, kə kantsaa tii ginə ka Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Ma dava, tə'i əndə'i əndə gatə akəŋwaciikii ɗii shishinəkii ma'asləkii. ");
INSERT INTO gde_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Wata əŋki Yeesu ka maliminə da Farisanyinə, “Kə kapaa bariya gaamə kaamə rəgwa ŋga mbəɗəpaaginə də əndə uusəra ŋga əpisəkə saanii, anii poosha?” ");
INSERT INTO gde_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Amma kə busəgi tii. Wata Yeesu a ŋgərə tə maɓərəhə əndəta, ca mbəɗəpaa də ci; ca ba ka ci, “Paluu saaku.” ");
INSERT INTO gde_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Wata əŋki Yeesu ka tii əsə, “Yaci tə'i əndə agyuunə, kə kulagərə uuzənaakii taa laakii aasəkə gu'u ma'inə uusəra ŋga əpisəkə saŋa, paa ci ka dzənə ka ŋgiraginə pii kwa?” ");
INSERT INTO gde_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Mambeemə tii ka jikənə ka ci agyanə ətsa. ");
INSERT INTO gde_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Wata ma nee Yeesu, taaɗə ŋunyi ha ŋga ndzaanə nə ənjinə 'waa'wii ənji ka zəma. Aciikii ɗii Yeesu ka tii misaali də banə: ");
INSERT INTO gde_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Maɗa kə bii ənji ka hə rəya, maɗa gi hə, ga ha dzə ka aalətə ŋunyi ha ŋga ndzaanə davə. Acii paa hə shii, mbu'u tə'i əndətə palee ka hə də məghərəvənə ətə bii ənji ka ci rəyəta. ");
INSERT INTO gde_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Əndətə bii koonə rəyə kyakya'ə əsə a ba ka hə: ‘Maɗəgi gaduu, vii ha ŋga ndzaanə ka əndətsa!’ Maɗa kə ɗii ha'ə, ka ɗanə nə ayinə tə hə ŋga dzənə ka ndzaanə ka ha ŋga ndzaanə ŋga moodəba'ənyinə. ");
INSERT INTO gde_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amma, maɗa kə bii ənji ka hə rəya, maɗa kə gi hə, ndzaanə ka ha ŋga ndzaanə ŋga moodəba'ənyinə. Acii maɗa kə shi əndətə bii ka hə rəya, ka banə nə ci ka hə: ‘Guvakya, shiwa, ŋgiravə aahanə.’ Ma ətsə ɗiya, ka ndzaanə nə hə da məghərəvənaaku akəŋwacii ənjitə cuuna zəmə da tii patə. ");
INSERT INTO gde_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Acii taa wu patə haŋətə naakii na, ka bərapaanə nə ənji tə ci. Taa wu patə həətəpaa naakii nə əsə, ka haŋətənə nə ənji tə ci.” ");
INSERT INTO gde_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Wata əŋki Yeesu ka əndətə 'wii tə ci ka zəməta, “Maɗa kə ɗii hə zəmə ka ənja, ga ha 'waa'wa tə guviinəku, taa tə ndzəkəŋushi'inəku, taa tə duurənyinaaku, taa tə ənji gəna ətə ka guvayiinə da hə. Acii maɗa kə ɗii hə ha'ə, ka mbeenə nə tii ka 'wanə tə hə natii əsə, də ha'ə ka ənəvəginə nə tii ka hə də sətə vii hə ka tii. ");
INSERT INTO gde_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Amma, maɗa kə ɗii hə əndzanə ka ənja, tə matəgunyinə da mahurəməsə ənji da midirinə da muurəfinə 'wanəku. ");
INSERT INTO gde_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Maɗa kə ɗii hə ha'ə, ka upaanə nə hə barəkaanə, acii paa tii ka mbeenə ka ənəvəginə ka hə də sətə vii hə ka tii. Əntaŋfə də naakii nə na ənəvəgi ka hə uusərə maɗətənə ŋga ənji gooŋga agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Makə fii əndə'i əndə agi ənjitə ca zəmə da Yeesu waɓəətsa, wata əŋki ci ka ci, “Tə'i barəkaanə ashi əndətə na zəmə əndzanə agi *ŋwaŋuunə ŋga Əntaŋfə ɗii!” ");
INSERT INTO gde_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Wata Yeesu a ɗa ka tii misaali, əŋki ci, “Tə'i əndə'i əndə jigə əndzanə. Kə bii ci ka ɓəzə ənji shinə ka zəmə əndzanəkii. ");
INSERT INTO gde_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Makə uugi zəmə ɗanə, wata ca ka tə lawaraakii ka 'waa'wyanə tə ənjitə bii ci ka tii shinə ka zəmə əndzanəkii. Lawarətə a dzə, əŋki ci: ‘Shoomə, acii ma ənə ɗii ci, kə uugi əndzanə dzəgənə!’ ");
INSERT INTO gde_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Amma, ma tii pata, kə ali tii sə ŋga əsə də ma. Əŋki əndə'i əndə ka lawarəta: ‘Ma nya, ci ənə ha'ə iri nyi ha ŋga uuzanə. Kə dəɓee əsə nya dzə ka caamatənə. Kə kədii nyi aciiku, pooshi nyi ka mbu'unə.’ ");
INSERT INTO gde_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Əŋki əndə'i əsə, ‘Ma nya, kə iri nyi lii uuzanə pu'u. Ka təəɓətənə tə tii nə nyi ka dzənə. Kə kədii nyi aciiku, pooshi nyi ka mbu'unə.’ ");
INSERT INTO gde_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Əŋki əndə'i əsə: ‘Ma nya, ci ənə ha'ə ŋgirə nyi minə. Aciikii paa nyi ka mbeenə ka dzənə.’ ");
INSERT INTO gde_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","“Makə ənya lawarətə aasii, wata ca dzəgunəgi uushi'iitə patə ka slandanəkii. Makə fii slandanəkii ha'ə, wata maɓətə səkə a ŋgərəgi tə ci, əŋki ci ka lawaraakii, ‘Duu pii pii aasəkə vəranə, ha wiigi'itə rəgwanyinə patə ka aalə ənja. Matəgunyinə da mahurəməsə ənji da muurəfinə da midirinə patə, ha ba ka tii, təya shi.’ ");
INSERT INTO gde_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Makə ɗii lawarətə ha'ə, ca ənya, əŋki ci ka slandanəkii: ‘Slandanəkya, kə ɗatə nyi sətə bii hə, amma kə mbəɗaanə ha ŋga ndzaanə.’ ");
INSERT INTO gde_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Wata əŋki slandanəkii ka lawarətə: ‘Duu aa ba'a vəranə, nə'uu rəgwa bilinə, ha pwaakya ənji kaa təya shi aa haki aasii, kaa yaaki a tsəkwa. ");
INSERT INTO gde_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Wanyinə ca ba koonə, ma agi ənjitə 'watəgi nyi ba ka tii shinə ka zəma, taa əndə rəŋwə pooshi na upaa rəgwa ŋga zəmə əndzanə gaki asii.’ ” ");
INSERT INTO gde_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Ma ka əndə'i uusəra, kə gi Yeesu də wiigi'inə. Nə'unə nə daɓaala tə ci. Wata ca zə'ugi aadəɓitii, əŋki ci ka tii, ");
INSERT INTO gde_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Taa wu patə ca shi aaɓiiki, wa ca uuɗə tə nyi palee ka dii, palee ka məci, palee ka minaakii, palee ka manjeevənaakii, palee ka ndzəkəŋushi'inəkii uuji ŋguyirənə da makinəkii patə. Wa ca uuɗə tə nyi əsə palee ka əpinaakii. Maɗa pooshi ha'ə, paa ci ka mbeenə ka ndzaanə ka lawaraaki. ");
INSERT INTO gde_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Taa wu nə əndətə maŋgərəmə ənfwaakii ŋga gwa'avənə tə ci aashikii, ca nə'u də nyi, paa ci ka mbeenə ka ndzaanə ka lawaraaki. ");
INSERT INTO gde_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","“Maɗa tə'i əndə'i əndə agyuunə mwayi ghənə maɗuunə kuva, ka ndzaanə nə ci zəku'i, ca ɗa lisaafə ŋga sətə nii kəya zagi, kaa ca nəhee maɗa kə mbu'i kwaɓaakii bahə uudəpaa də slənətsa. ");
INSERT INTO gde_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Maɗa paa ci ɗii ha'ə, maɗa kə mbukəpaa ci, mbu'u taa paa ci na mbee ka uudəpaa ghənə kuvəkii. Maa kə ɗii ha'ə makə ətsa, taa wu nee ka ci patə, ka ŋusənə nə ci tə ci, ");
INSERT INTO gde_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ca ba: ‘Ya əndəna, kə gwaŋə ci ka ghənə kuva, amma kə təkuree ci ka uudəpaa slənəkii!’ ");
INSERT INTO gde_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","“Ha'ə əsə maɗa tə'i ŋwaŋwə da ənji dəbu'u pu'u, ca dzə ka panə da əndə'i ŋwaŋwa, ka ənəginə nə ci zəku'i, ca kaala hiima, kaa ca fatə ashikii maɗa ka mbeenə nə ci ka hwaməpaanə tə əndə mbiinaakii ətə da ənji dəbu'u pupusərə. ");
INSERT INTO gde_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Maɗa, ma ca kaala hiima, paa ci na mbee, ka sləkeenə nə ci ka ənjaakii aaɓii əndə'i ŋwaŋutə, tii ma'ə dzaɗə dzaɗə. Waatoo, kaa ca alə haɗatəginə ahadatii. ");
INSERT INTO gde_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Ha'ə ɗii əsə, taa wu agyuunə, maɗa paa ci bwasee ka uushi'inaakii patə, paa ci ka mbeenə ka ndzaanə ka lawaraaki.” ");
INSERT INTO gde_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“Kə shii unə oo'i, ŋunyi uushi nə zhatana. Amma, maɗa kə ləvəgi zhatanə saakii, pooshi ənji ka mbeenə ka ənətəginə njamə njamə ma'ə. ");
INSERT INTO gde_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Pooshi zhatanəkii ka nafanə ka dzəgə də ha, pooshi kuɓa davə əsə. Wata vugədəginə vugədəginə ənji. Ma əndətə da liminə ŋga fanə, wa ca fa.” ");
INSERT INTO gde_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Yoo, kə əncahə *ənji luu tsəka da ma'waslyakə ənji patə aaɓii Yeesu ka fa sətə cii kəya ba. ");
INSERT INTO gde_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Asee agi dzənə nə *Farisanyinə da maliminə də ŋguŋgunənə, təya ba, “Əndətsə uura, ka mi saŋə cii kəya luu ma'waslyakə ənji, ca adə ka ha rəŋwə da təya?” ");
INSERT INTO gde_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","Wata Yeesu a ɗa ka tii misaali, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Yaci tə'i əndə agyuunə da bagiinaakii gya'ə, wata rəŋwə agitii a zagi, iitə ɗanəkəya? Ka bwaseenə nə ci ka harakii ətə əliŋə pu'unə aji əliŋə ka zəmənə, ca dzə ka aalə tə ətə rəŋwə see maa nee ci. ");
INSERT INTO gde_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Maɗa kə lapaa ci bagata, ka ɗanə nə ci mooɗasəka, ka ŋgiravənə nə ci aatsa uurakii, ca pyalyagi aasii. ");
INSERT INTO gde_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Maɗa kə mbu'ya ci aasii, ka 'waa'watənə nə ci tə guviinəkii da guvayiinaakii, ka banə nə ci ka tii oo'i: ‘Ɗaamə ka nyi mooɗasəka, acii ma bagaaki ətə shi a zagi, kə nee nyi!’ ");
INSERT INTO gde_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Wanyinə ca ba koonə: ha'ə əsə nə Əntaŋfə da malaa'ikanyinə dadagyə. Maɗa kə baa ma'waslyakə əndə rəŋwə ka Əntaŋfə, ka ɗanə nə tii mooɗasəkə putaakii, palee ka putə ŋga ənji əliŋə pu'unə aji əliŋə ətə ca 'wa natii nə də ənji gooŋga; waatoo, ma nə tii ka bana, pooshi uushi ci təya baa ka Əntaŋfə ka putakii.” ");
INSERT INTO gde_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“Yaci tə'i minə da kwaɓatə *hwaslə pu'wa, kə ŋgirə hwaslə rəŋwə agikii, kə zagi, iitə ɗanəta? Paa ki ka kavə gunə aasəkə garəkuwa, kya taasəgi kuva, kya aalə də samə, kaa kya nəhee kwa? ");
INSERT INTO gde_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Maɗa kə lapaa ki kwaɓakii, ka 'waa'watənə nə ki guviinətə da guvayiinatə, ka banə nə ki ka tii oo'i: ‘Ɗaamə ka nyi mooɗasəka, acii ma kwaɓaaki ətə sha zagi, kə nee nyi!’ ");
INSERT INTO gde_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Wanyinə ca ba koonə: ha'ə makə ətsə əsə nə malaa'ikanyinə ŋga Əntaŋfə. Maɗa kə baa ma'waslyakə əndə rəŋwə ka Əntaŋfə, ka ɗanə nə tii mooɗasəkə ka shaŋə.” ");
INSERT INTO gde_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Əŋki Yeesu əsə, “Tə'i əndə'i əndə sha ɗii da uuji ŋguyirənaakii bəra'i. ");
INSERT INTO gde_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Əŋki daranə ka dii: ‘Daada, vii ka nyi gyaɗalaaki agi sə ŋga zəmə də yaaku.’ Wata dəsənətii a ŋgərə uushi'inaakii, ca təkee bəra'i, ca ŋgərə rəŋwə, ca vii ka darata. ");
INSERT INTO gde_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","“Ma baanə moona, daratə a tsəəkətə uushi'inaakii patə, ca ɗərəmagi, ca paləənəgi da i kwaɓakii ka madzaɗə hanyinə. Ma dava, kə ndzaa ci ka ɗa uura saawanə, kə zagi kwaɓata. ");
INSERT INTO gde_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Ma ətsə uudəpaa ci zamagi də kwaɓatə patə ha'ə, wata kə kulii məza maɗəfənə gatə də vəra. Wata kə ənəpaa ci ka ghəəlinə. ");
INSERT INTO gde_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Ca maɗə, ca dzə, ca gi'i əndə'i əndə davə gatə də vəra ka alə sləna. Əndətə a ba ka ci dzənə aa bilə ka gəra dagəliinə. ");
INSERT INTO gde_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Kə mwayi ci zəmə ŋga dagəliinə kaa ca əburə gyaɗə, amma taa zəməkii pooshi ənji nja vii ka ci. ");
INSERT INTO gde_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","“Wata ca gwaŋə ka buurənə agyanə mandzaa tə ci. Əŋki ci ka naakii na: ‘Yoo, ŋgaaŋga'ə nə zəmə ga daadə asii ta'a! Ənji slənə ŋga daadə patə, agi zəmənə nə tii, ha'ə ca mbəɗaanə aciitii. Amma wanyinə ka əntənə ganə acii maɗəfənə. ");
INSERT INTO gde_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","A ənə nyi saaki aa ha daadə, kaa nya dzə ka banə ka ci, Daada, kə ɗii nyi 'waslyakəənə ka Əntaŋfə da i ka hə patə. ");
INSERT INTO gde_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Mambu'umə nyi bahə ha 'wa tə nyi də uuzənaaku ma'ə. Ma ɗanəkwa, əsuu tə nyi makə sətə cii kwa əsə tə ənji slənaaku.’ ");
INSERT INTO gde_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Makə uudəpaa ci ɗatə hiimatsə ha'ə, wata ca maɗə, ca ŋgərə rəgwa aa ha dii. “Ma ətə ci ma'ə dzaɗə da yi gi'u, kə nee dii ka ci. Dii a nəhə tə ci təgugunə. Ca huyipaa ka guŋyanə da ci a rəgwa. Ca luu tə ci, ca fuuɗəgi tə ci pya'ə pya'ə a ədzəməkii. ");
INSERT INTO gde_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Əŋki uuzəətə ka dii: ‘Daada, kə ɗii nyi 'waslyakəənə ka Əntaŋfə da i ka hə patə. Mambu'umə nyi bahə ha 'wa tə nyi də uuzənaaku ma'ə.’ ");
INSERT INTO gde_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Amma əŋki dii ka lyawarənaakii: ‘Huyipaamə aasii, ŋgiramə kəjeerənə ətə palee də dagwaanə, una kavə ka ci aashikii. Ŋgiramə sə ŋga ciinə, una ŋgavə ka ci. Ŋgiramə ɓiɓinə əsə, una ŋgaaŋgavə ka ci. ");
INSERT INTO gde_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Əshamə masəɓərə la, lagimə uurakii kaa ənjə a dzəgə əndzanə, ama zəmə, ama ɗa mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Acii kə nee nyi, ma uuzənaaki ətsa, makə kə shi ca əŋki, amma waanə ənshinə. Kə shi ca zii, amma wanyinə kə nee ka ci.’ Wata təya gwaŋə ka ɗa mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“Ma saa'ikii, də bilə ama uuzanə nə gawə uuzənə ŋga əndəta. Ma ca shi aasii, makə mbu'ya ci kədəhə da ya, ma ca fa, dzaadzanə nə ənji uushi'inə, udzənə nə ənja. ");
INSERT INTO gde_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","Wata ca 'watə əndə'i lawara, kaa ca ləgwa a makii taa mi ci ənjə a ɗa ha'ə. ");
INSERT INTO gde_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","Əŋki lawarətə ka ci: ‘Ndzəkəŋu ənya, kə ɓilə duu masəɓərə la, acii kə nee ci, jamə ənya uuzənaakii.’ ");
INSERT INTO gde_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","Wata gawə uuzəətə a ɓəzəgi səka. Ca naanagi ka dəmənə aasii. Shiginə nə dii, ca puutə tə ci kaa ca dəməgərə aasii. ");
INSERT INTO gde_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","Amma əŋki gawə uuzəətə ka dii: ‘Tsaamuu, kə fəzhi nyi ŋgaaŋga'ə ka slənənə ka hə, mashimə nya naanii ka ɗa ka hə sətə mwayi hə. Amma, ma ka nya, mashimə ha vii taa uundzə əhwə kaa nya ɗa keenə də əndzanə da guviinəki. ");
INSERT INTO gde_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amma, tsaamuu, makə shi uuzənaaku ətə zamagi də gənaaku ka tii da badawiinə ŋga makinə, la gbavə ɓilə hə ka ci.’ ");
INSERT INTO gde_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Wata əŋki dii ka ci: ‘Uuzənaakya, taa guci patə aɓiiki nə hə. Uushi'inaaki patə əsə, naaku nə ci. ");
INSERT INTO gde_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","Kə dəɓee ama dzəgə əndzanə, ama ɗa mooɗasəka. Acii ma ndzəkəŋu ətsa, kə nee nyi, makə kə shi ca əŋki, amma waanə ənshinə. Kə shi ca zii, amma wanyinə kə nee ka ci.’ ” ");
INSERT INTO gde_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Əŋki Yeesu ka lyawarənaakii əsə, “Tə'i əndə'i əndə gəna sha ɗii da lawaraakii. Kə ba'avə ci uushi'inaakii ka lawarəta. Ma ka əndə'i uusəra, shinə nə ənji ka banə ka ci oo'i: ‘Agi saaweenə nə lawaraaku ka gənaaku.’ ");
INSERT INTO gde_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Wata 'wanə nə slandanəkii tə lawarətə, əŋki ci ka ci: ‘Mi tuu cii kya fa ənjə a ba ashikwa? Ɗatə ka nyi lisaafə ŋga slənaaku ɗii, acii ma ha, paa hə ka ndzaanə ka lawaraaki ma'ə.’ ");
INSERT INTO gde_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Wata lawarətə a kaala hiima: ‘Ya makə waanə slandanəki ka ŋgərəgi slənə aciiki əna, iitə ɗanəkya? Wiina, uuzanə, paa nya mbee. Kədiinə əsə, ka ɗanə nə ayinə tə nyi. ");
INSERT INTO gde_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Yawaa, kə shii nyi səndə nii kya ɗa, kaa ənjə a luu tə nyi aa hatii aasii maɗa kə ŋgərəgi slandanəki slənə aciiki.’ ");
INSERT INTO gde_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","“Wata ca 'waa'watə tə ənjitə ci slandanəkii a nə'u tə tii dəmənə də rəŋwə rəŋwə. Əŋki ci ka əndətə 'watəgi mbu'yanə: ‘Iitə ci slandanəki a nə'u tə hə dəməna?’ ");
INSERT INTO gde_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","Əŋki əndəta: ‘Garəwa ŋga maarə gya'a cii kəya nə'u tə nyi.’ Əŋki lawarətə ka ci: ‘Wiinə ləkaləkatə ŋga dəməətə atsaku. Ndzaanə, naahətə garəwa tufə pu'unə tsakə tsakə.’ ");
INSERT INTO gde_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Ma daba'əkii əsa, əŋki ci ka əndə'i əndəta: ‘Ya hə əsa, iitə cii kəya nə'u tə hə dəməna?’ Əŋki əndəta: ‘Buhə ŋga aləkamaara gya'a tufə cii kəya nə'u tə nyi.’ Əŋki lawarətə ka ci: ‘Wiinə ləkaləkatə ŋga dəməətə atsaku. Naahətə buhə gya'a ənfwaɗə.’ ");
INSERT INTO gde_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“Kə kuyirii slandanəkii tə lawarətə pooshi nja slənə də rəgwakii, makə kə slənyi ci də səkura. Ha'ə nə ənjitə ŋgərəgi slənə uushi'inə ŋga *duuniya tə tii. Ma təya, agi səkurənə nə tii agi ɗa uushi'inatii. Amma ma ənjitə agi ɓərənə, pooshi tii ka kavə hiimatii aakəŋwa də səkurə ha'ə. ");
INSERT INTO gde_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","“Ma nyi əsa, wanyinə ca ba koonə: ŋgərəmə gəna goonə, zamagimə koona upaa də guviinə. Maa kə ɗii ha'ə, maɗa kə uudəgi gəna, ka luunə nə ənji tuunə asii ga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Taa wu ɓaarii gooŋgaanə agi uundzə sləna, ka mbeenə nə ənji ka ba'avə madiigərə slənənyinə aaciikii. Taa wu pooshi ɓaarii gooŋgaanə agi uundzə sləna, taa madiigərə slənənyinə ba'avə ənji aaciikii əsə, paa ci ka mbeenə ka ɗa gooŋgaanə agikii. ");
INSERT INTO gde_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Yaci ha'ə makə ətsə əsə, maɗa maslənəgimuunə də gooŋgaanə də gənanə upaa unə agi *duuniya, iitə mbeenə ənji ka ba'avə koonə tə tantanyitə uushi'inə ɗiya? ");
INSERT INTO gde_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Yaci maslənəgimuunə də gooŋgaanə də sətə əntaa noonə əsə, wu na mbee ka vii koonə noonə səgoonə ɗiya? ");
INSERT INTO gde_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“Pooshi mava ətə ca mbee ka slənətənə ka slanjiinə bəra'i. Ka kaareenə nə ci ka əndə'i əndə, ca uuɗə tə əndə'i ənda. Ka gaɗeenə nə ci ka əndə'i əndə, ca ushapaa tə əndə'i ənda. Pooshi rəgwa ŋga paslənə tə Əntaŋfə, unə kə kavə nuunə ka alə gəna.” ");
INSERT INTO gde_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Fanə ŋga *Farisanyinə ha'ə, makə ɗii ci ŋga'ə ka tii nə gəna, wata təya ŋusəgi tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","Əŋki Yeesu ka tii, “Ma unə ɗəya, kə ndzaa unə ka ənjitə ca ɗeegi ka natii nə makə ənji gooŋga akəŋwacii ənja. Amma kə shii Əntaŋfə sətə a ədzəmuunə. Ajijinə ka Əntaŋfə nə sətə ci ənjə a nee makə maɗuunə uushi. ");
INSERT INTO gde_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","“Ma bariya ŋga Muusa da waɓənə ŋga anabiinə, kə slənyi dəŋə ka saa'itə shigi Yoohana əndə ɗa bapətisəma. Agi zamanaakii 'watəgi ənji waaza Ŋunyi Habara agyanə ŋwaŋuunə ŋga Əntaŋfə. Taa wu patə əsə, kə ciŋə ci də ŋgeerənə kaa ca upaa dəmənə aagi ŋwaŋuunəkii. ");
INSERT INTO gde_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Gəɗə uudənə ŋga duuniya də ŋgufənə acii pirihuginə ŋga uushi gi'u agi bariya. ");
INSERT INTO gde_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“Maɗa kə lakəgi əndə minaakii, ca ŋgərə əndə'i, kə ɗii ci aləhiinə ətsa. Maɗa kə ŋgirə əndə tə miitə lakəgi ŋgurii əsə, aləhiinə nə ci ka ɗanə.” ");
INSERT INTO gde_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“Tə'i əndə'i əndə gəna sha ɗii. Kə kaalii ci makuɗə kuɗə kəjeerənyinə ətə ɗii ɗərəkii ndalə. Taa guci patə agi wahə nji ci. ");
INSERT INTO gde_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Tə'i maagha əsə ɗii ləməkii Lazarusə. A ma kuvə ga əndə gənatə njii kəya ndzaanə. Shishinəkii patə, uyiginə. ");
INSERT INTO gde_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Kə mwayi ci ɗəəmə murəmurinə ŋga ɗafəətə ca kwaala aanə ha ŋga adənə ŋga əndə gənata, kaa ca adə. Ədiinə maa, təya dzə də na'ə uyigiitə ashikii. ");
INSERT INTO gde_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","“Makə əŋki maaghata, wata malaa'ikanyinə a ŋgərətə tə ci, təya kərəgi tə ci aadəgyə aaɓii Ibərahiima, asii ga Əntaŋfə. Əntənə ŋga əndə gənatə naakii, wata ənjə a ŋgəɗəgi tə ci. ");
INSERT INTO gde_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","Aagi gutə suŋwə gi ci, ca sa ciɓə ka shaŋə. Ma maɗeenəkii ka ginəkəya, ma nee ca, waatə Ibərahiima, a purəŋakii nə Lazarusə. ");
INSERT INTO gde_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Wata ca ŋgəree ka uurakii, əŋki ci: ‘Daadə Ibərahiima, nəhuu təgugunaaki. Bawə ka Lazarusə, wa ca cimwacii ma'inə a ma gislə kaa ca shi ka ɗavənə ka nyi a ganaki, kaa nya upaa shiwunə. Acii agi ciɓənə nə nyi ganə agi guuna.’ ");
INSERT INTO gde_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Amma əŋki Ibərahiima ka ci: ‘Uuzənaakya, a buurətə hə oo'i, kə shi ha upaa shiwunə hə ma'ə agi duuniya. Ma Lazarusə əsa, agi ŋgəra'wə nji ci. Amma, ma ənə ɗii ca, ma ganə, ka maka ma'yanə nə ci. Ma hə əsə, agi ciɓənə nə hə. ");
INSERT INTO gde_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Danəkii ha'ə maa, tə'i maɗuunə ŋgurənyinə ahadaamə. Aciikii, taa ənjitə ca moo maɗənə daganə ka dzənə aa hoonə, paa tii ka mbeenə. Pooshi ənji ka mbeenə əsə ka ma'yanə ka hatsə ɗii hə davə ka shinə aadə heenə.’ ");
INSERT INTO gde_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Wata əŋki əndə gənatə ka Ibərahiima: ‘Tuutəta'ə, Daadə, makə ha'ə ɗii əna, sləkee ka Lazarusə aa ha daadə aasii. ");
INSERT INTO gde_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","Tə'i ndzəkəŋushi'inəki tufə. Wa ca dzə ka waɓənə ka tii, acii ga təya shi aa hanə natii əsə, ka ha ŋga ciɓəna.’ ");
INSERT INTO gde_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Əŋki Ibərahiima ka ci: ‘Ma ndzəkəŋushi'inəku, agi fanə nə tii bariya ŋga Muusa da waɓənə ŋga anabiinə. Wa təya nə'utə sətə bii tii.’ ");
INSERT INTO gde_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","Əŋki əndə gənatə əsə: ‘Daadə Ibərahiima, pooshi ɗii; amma, maɗa əndətə sha əŋki gi ka waɓənə ka tii, ka baanə nə tii ka Əntaŋfə.’ ");
INSERT INTO gde_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Amma əŋki Ibərahiima: ‘Maɗa pooshi tii nə'utə bariya ŋga Muusa da waɓənə ŋga anabiinə, taa əndətə maɗətə agi maməətə ənji gi ka waɓənə ka tii, paa tii ka baanə ka Əntaŋfə.’ ” ");
INSERT INTO gde_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Əŋki Yeesu ka lyawarənaakii, “Taa guci patə, tə'i uushi'inə ətə ca dəəməgərə də ənji aagi ɗaaɗa 'waslyakəənə. Amma agi ŋgəra'wə nə əndətə ca kavə əndə ka pu'unə. ");
INSERT INTO gde_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Maɗa kə kavə ci tə əndə rəŋwə agi ənjinə ushapaa *duuniya tə tii ka ɗa 'waslyakəənə, ma sətə na upaa tə ci, gəɗə anəvə təŋwə aa uurakii ka ci də ŋga'əənə, ənjə a kagərə tə ci aagi uunəva, acii sətə na upaa tə ci. ");
INSERT INTO gde_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Nəhəmə noonə na! “Maɗa kə ɗii əndə nə'unə makə hə 'waslyakəənə, waɓuu ka ci. Maɗa kə baa ci, tifyagi ka ci. ");
INSERT INTO gde_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Taa kə kyawəri ci ka ɗanə də hə bwayakii məɗəfə agi uusəra, maɗa ca dzə də shinə ka banə ka hə oo'i: ‘Kə baa nyi ka hə’, ga ha kəsəpaa tə ci a ədzəməku.” ");
INSERT INTO gde_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","Fanə ŋga masləkee ənji ha'ə, əŋki tii ka Slandana, “Tsakuu keenə ŋgeerənə ŋga gi'inə tə hə.” ");
INSERT INTO gde_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Əŋki ci ka tii, “Maci kə mbu'i gi'inə goonə tə nyi taa wata makə hi'u iza, kaɗa ka mbeenə nuunə ka banə ka ɓaratsa: ‘Mbuɗuu, duu ŋguɓəpaa naaku nə agi uunəva’, ca luuvə koonə əsə.” ");
INSERT INTO gde_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","“Yaci tə'i əndə agyuunə gi lawaraakii aa bilə ka uuzanə taa ka gəranə, ya maɗa nee ci ka ci, ca shi də bilə, ka banə nə ci ka ci oo'i: ‘Palyəgi tsakə tsakə, ndzaŋuu adənə’ nii? ");
INSERT INTO gde_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Poosha. Amma ka banə nə ci ka ci: ‘Tasəkapaa ka nyi adənə zəku'i, zə'wee ka kəjeerənaaku, kaa ha ɗa ka nyi slənə saa'itə cii kya adə, nya sa. Ma daba'əkii, ka mbeenə nə hə ka adənə naaku, ha sa.’ ");
INSERT INTO gde_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Kə kuyirii ci tə lawaraakii puta slənətə ci ka ci sətə bii ci ətsə nii? ");
INSERT INTO gde_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Ha'ə nuunə noonə əsə. Maɗa kə ɗatuunə patənə ŋga sətə bii Əntaŋfə koonə, shiimə oo'i, wata *lyawarənə nuunə. Ma sətə ɗii una, sətə dəɓee una ɗa.” ");
INSERT INTO gde_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Ma Yeesu a dzə də palənə aa Urusaliima, anə riɓinə ŋga hanyinə ŋga *Samariya da hanyinə ŋga Galili pitəgi ci. ");
INSERT INTO gde_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","Ma ətsə kaa ca mbu'u aasəkə əndə'i vəranə ha'ə, wata ənji uyikuzənə pu'u a shi ka guŋunə da ci. Təya kəŋaanə dzaɗə gi'u da ci, ");
INSERT INTO gde_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","təya ŋgəree ka uuratii, əŋki tii, “Yeesu, Dəsəniinə, nəhuu təgunuunə geenə!” ");
INSERT INTO gde_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Neenə ŋga Yeesu ka tii, əŋki ci, “Ma ɗanuuna, dəmə ka ɓaarii noonə nə ka limanyinə.” Ma tii ka ha ŋga dzənə, wata ma nee tii, kə mbə'i tii. ");
INSERT INTO gde_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Neenatii kə mbə'i tii, wata əndə rəŋwə agitii a ənyatə aaba'a, ca dzə də dəlanə də Əntaŋfə də ŋgeerənə. ");
INSERT INTO gde_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Ca kulagi atsaa səɗə Yeesu, ca kuyirii tə ci. Asee, ma əndəta, əndə Samariya nə ci. ");
INSERT INTO gde_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Wata Yeesu a ləgwa, əŋki ci, “Əntaa ənjitə pu'u patə mbə'ya? Aa maatiinə hara ənjinə əliŋə ɗiya? ");
INSERT INTO gde_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Iitə ɗii da pooshi əndə shi ka dəlanə də Əntaŋfə maɗaamə mu'umətsa?” ");
INSERT INTO gde_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Wata əŋki Yeesu ka ci, “Maɗətə, duu saaku aasii. Kə mbə'i hə putə ŋga gi'inaaku tə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Kə ləguyi harii *Farisanyinə a ma Yeesu taa guci nə Əntaŋfə a ɗa ŋwaŋuunaakii agyanə ənja. Əŋki Yeesu ka tii, “Ma ɗa ŋwaŋuunə ŋga Əntaŋfə, pooshi ndzaanə makə sətə ci ənjə a nəhee də ginə. ");
INSERT INTO gde_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Pooshi ənji ka mbeenə ka banə oo'i: ‘Tsaamuu, wiinə ganə’, taa: ‘Wiitə gatə ha'ə.’ Acii ma nə ɗii ca, kə uugi ŋwaŋuunə ŋga Əntaŋfə ndzaanə ahadoonə.” ");
INSERT INTO gde_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Wata əŋki ci ka lyawarənaakii, “Kadə nə saa'i a ɗa. Maɗa kə ɗii saa'ikii, kadə nuuna moo neenə ka *Uuzənə ŋga ənda, taa wata uusəra rəŋwə. Amma paa unə ka neenə ka ci. ");
INSERT INTO gde_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Ka banə nə ənji koonə: ‘Ganə nə ci’, taa: ‘Gatə ha'ə nə ci.’ Ma ɗanuuna, goona dzə, goona nə'u tə tii shaŋə. ");
INSERT INTO gde_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Acii makə sətə ci pyapiɗənə ŋga vənə a ɓərəgi səkəntaŋfə taa dama patə, ha'ə nə Uuzənə ŋga əndə a ndzaanə ka uusəraakii paŋgəraŋə a babara. ");
INSERT INTO gde_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amma see a ciɓə ci ka shaŋə dərəva zəku'i, ənji ŋga zamananə a kaaree ka ci əsə. ");
INSERT INTO gde_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","“Makə sətə sha ɗii tə ənji agi zamana ŋga Nuuhu, ha'ə na ɗa uusəratə nə Uuzənə ŋga əndə a shi. ");
INSERT INTO gde_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Ma agi zamana ŋga Nuuhu, kə nji ənjə a zəmə, ənjə a saasa, kə nji ŋguyirənə da makinə a ŋgəərəshi, ha'ə mbu'ya uusəratə dəməgərə Nuuhu aasəkə kumbawala. Wata shinə nə ma'i tuufaanə, ca naanə ka duuniya, ca zamagi də ənjitə patə. ");
INSERT INTO gde_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Kadə na ɗa əsə makə agi zamana ŋga *Luudu. Ma agi zamana ŋga Luudu, kə nji ənjə a zəmə, ənjə a saasa, kə nji ənjə a ɗa fiiriinə, kə nji ənjə a laaga uushi'inə, kə nji ənjə a ghəənə yinyinə. ");
INSERT INTO gde_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amma, ma uusəratə shigi Luudu də *Sadooma, kə bujikaanə gunə dadagyə da baruuda aagyanə ənjitə ənəgi davə də Sadooma. Wata dza'ə kə zagi ənji davə. ");
INSERT INTO gde_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Ha'ə makə ətsə əsə na ɗa uusəratə nə Uuzənə ŋga əndə a jiga. ");
INSERT INTO gde_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","“Ma uusərakəya, ma əndətə anə kuvaakii da uushi'inaakii a kumu, wa ca jimagərə, ca huyi, ga ca dəmə aa kumu ka fəɗəənə uushi'inaakii. Ma əndətə də bilə əsə, wa ca huyi, ga ca ənə aasii. ");
INSERT INTO gde_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Buurətəmə haala ŋga minə ŋga Luudu! ");
INSERT INTO gde_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Taa wu patə ca ɗa gazhi'waanə ŋga luupaa əpinaakii, ka əteenə nə ci ka əpinəkii. Amma taa wu patə ətee ka əpinaakii, ci na luupaa əpinaakii. ");
INSERT INTO gde_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Wanyinə ca ba koonə: ma ka uusərakii davəɗə, ka baanə nə ənji bəra'i ka ədzə rəŋwə, ka ŋgərəginə nə ənji əndə'i əndə, ənjə a bwasee ka əndə'i əndə. ");
INSERT INTO gde_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Ka dzənə nə makinə bəra'i ka ədənə ka təŋwə rəŋwə; ka ŋgərəginə nə ənji əndə'i minə, ənjə a bwasee ka əndə'i.  ");
INSERT INTO gde_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Ka dzənə nə ŋguyirənə bəra'i aasəkə rə ka uuzanə; ka ŋgərəginə nə ənji əndə'i əndə, ənjə a bwasee ka əndə'i əndə.” ");
INSERT INTO gde_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Wata əŋki lyawarənaakii ka Yeesu, “Da da, Slandana, nə ətsə ha'ə a ɗa?” Əŋki Yeesu ka tii, “Ka hatə ɗii mantə uushi patə, davə dzanə kadəguyinə də na.” ");
INSERT INTO gde_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Wata Yeesu a ɗa ka lyawarənaakii misaali ka ɓaariiginə ka tii oo'i, kə dəɓee təya ɗa də'wa taa guci patə, ga təya zaarə shaŋə. ");
INSERT INTO gde_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Əŋki ci, “Tə'i mala gəŋwanə sha ɗii asəkə əndə'i vəranə. Paa ci ka ŋgwalənə tə Əntaŋfə, agi ushapaanə nə ci ənja. ");
INSERT INTO gde_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Tə'i mitə mooryafinə davə gatə də vəra əsə. Agi dzənə nə ki də shinə aa hakii ka banə ka ci: ‘Jikəvə keenə ahadeenə da əndə mbiinaaki.’ ");
INSERT INTO gde_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Amma dzənə nə mala gəŋwaatə də naanaginə, kə ta'avə ci dərəva ka ɗanə ka ki ha'ə. Ma daba'əkii əŋki ci də səkəkii: ‘Taa ŋgahi paa nyi ka ŋgwalənə tə Əntaŋfə shaŋə, agi ushapaanə nə nyi ənji əsə, ");
INSERT INTO gde_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","patə da ha'ə, makə kə uugi nyi zaarənə acii haalatə, ka ɗanə nə nyi ka ki gəŋwaatsa. Maɗa maɗamə nyi ka ki gəŋwaatsa, kadə nə ta ənvutə tə nyi.’ ” ");
INSERT INTO gde_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Slandanə a tsakə banə, əŋki ci, “Famə ɗii sətə bii bwaya mala gəŋwaatsa. ");
INSERT INTO gde_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Ya Əntaŋfwa, paa ci ka tsakənə tə mataɗə ənjaakii kwa? Acii ma təya, agi tuunə nə tii ka ci vəɗə da uusəra kaa ca tsakə tə tii. Kə shii nyi, pii tsakənəkii tə tii. ");
INSERT INTO gde_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Wanyinə ca ba koonə: ka viinə nə ci ma'inə ka ənji mbiinatii. Patə da ha'ə, maɗa kə shi *Uuzənə ŋga ənda, ka lapaanə nə ci ənjitə gi'i tə Əntaŋfə ma'ə nii?” ");
INSERT INTO gde_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Agi nəheenə nə hara ənji ka natii nə makə ənji gooŋga, təya bərapaa tə patənə ŋga ənja. Ka tsaratii ɗii Yeesu misaalina, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“Tə'i ənji bəra'i gi aasəkə *yi ŋga Əntaŋfə ka ɗa də'wa. Farisa nə əndə'i ənda, əndə luu tsəka nə əndə'i ənda. ");
INSERT INTO gde_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Ma Farisata, kə gi ci, ca kəŋaanə, ca ɗa də'wa dasəkə ədzəməkii, əŋki ci: ‘Əntaŋfə, kə kuyirii nyi tə hə, acii ma nya, paa nyi ndzaanə makə ŋga hara ənji, waatoo mahiirənə, məza ənja, ənji ɗa aləhiinə. Kə kuyirii nyi tə hə əsə makə ɗii ci, ma nya, paa nyi ndzaanə makə əndə luu tsəkətsa. ");
INSERT INTO gde_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Agi ɗa suumaya nə nyi bəra'i agi luuma; agi viinə nə nyi zaka ŋga sətə cii kya upaa patə əsə.’ ");
INSERT INTO gde_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Amma ma əndə luu tsəkətə naakii, makə gi ci, daba'ə hara ənji kəŋaanə ci, acii kə ŋgwaləgi ci ka maɗee taa ka ginəkii aadəgyə. Wata ciinəkii pukəvə ci dəkə agyanəkii, əŋki ci, ‘'Ya'ə Əntaŋfə, nəhuu təgugunaaki, nyi ənə ma'waslyakə ənda.’ ");
INSERT INTO gde_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","“Wanyinə ca ba koonə: ma gi əndətə aasiya, Əntaŋfə kə tifyagi tə ci. Amma, ma Farisata, pooshi Əntaŋfə tifyagi tə ci. Acii taa wu patə haŋətə naakii na, ka bərapaanə nə ənji tə ci. Amma taa wu patə həətəpaa naakii na, ka haŋətənə nə ənji tə ci.” ");
INSERT INTO gde_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Yoo, kə kyaara ənji ka Yeesu i idənə manjeevənə kaa ca ɗaanə ciinə ŋga barəkaanə aanətii. Neenə ŋga lyawarənaakii ha'ə, wata təya ndzaŋə laala ŋguruunə ka ənjita. ");
INSERT INTO gde_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Amma Yeesu a 'watə tə ənjita, əŋki ci, “Uneemə ka manjeevənə kaa təya shi aaɓiiki, goona təŋa tə tii, acii ka tsarə ŋga ənji makə tii də *ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Tantanyinə cii kya ba koonə: ma əndətə pooshi luuvə ka Əntaŋfə a ndzaanə ka ŋwaŋwaakii makə sətə ci uuzənə a luuvə, pooshi ci ka upaa dəmənə aagi ŋwaŋuunə ŋga Əntaŋfə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Yoo, kə shi əndə'i gawa aaɓii Yeesu, əŋki ci ka ci, “Maləma, ma hə kamə, ŋunyi əndə nə hə. Mi saŋə ɗanəki kaa nya upaa əpinə ŋga ca'ə ndəŋwə ndəŋwa?” ");
INSERT INTO gde_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Wata əŋki Yeesu ka ci, “Ka mi cii kwa 'wa tə nyi ŋunyi ənda? Pooshi ŋunyi ənda, maɗaamə Əntaŋfə ci rəŋwə dyaŋə. ");
INSERT INTO gde_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Kə shii hə bariya ŋga Əntaŋfə, waatoo: ‘Ga ha alə hiinə, ga ha ɓələ hiinə, ga ha hərə hiinə, ga ha vii seeda ŋga jirakənə anə ənda, gaɗee ka i duu da muu.’ ” ");
INSERT INTO gde_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Əŋki gawə əndəta, “Ma ətsə patə, kə nə'utə nyi daga nyi ma'ə uuzənə.” ");
INSERT INTO gde_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Makə fii Yeesu ha'ə, əŋki ci ka ci, “Awa, kə fii nyi, amma tə'i uushi rəŋwə mbəɗaanə ka hə ŋga ɗanə. Ma ɗanəkwa, uushi'iitə aciiku patə, duu, fəɗuu, ha ɗərəmagi, ha təkəpaa kwaɓakii ka maaghiinə. Maɗa kə ɗii hə ha'ə, ka ndzaanə nə shigaaku dagyə aɓii Əntaŋfə. Ma daba'əkii, ha shi ka nə'u tə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Makə fii əndətə waɓəətsə ha'ə, wata kə dzəgəpaa tə ci ashikii; acii laŋə dərəva nə gəna aciikii. ");
INSERT INTO gde_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Makə nee Yeesu kə dzəgəpaa waɓəətsə tə əndətə ha'ə, wata əŋki ci: “Una! Dzawə dərəva nə dəmənə ŋga ənji gəna aagi ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Gəɗə dəməginə ŋga ŋgyalooba ka rəgwa shinə ŋga libəra də ŋgufənə acii dəmənə ŋga əndə gəna aagi ŋwaŋuunə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Fanə ŋga ənji ha'a, wata əŋki tii, “Maɗa ha'ə əna, wu ɗii nə upaa luupaana?” ");
INSERT INTO gde_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Əŋki ci, “Ma sətə təkuree ənji ka ɗatənə, ka mbeenə nə Əntaŋfə ka ɗatənə.” ");
INSERT INTO gde_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","Əŋki Piita, “Waniinə, kə bwasee inə ka yinyinə geenə keena nə'u tə hə.” ");
INSERT INTO gde_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Wata əŋki Yeesu ka tii, “Tantanyinə cii kya ba koonə: taa wu patə bwasee ka yaakii, taa minaakii, taa ndzəkəŋushi'inəkii, taa duurənyinaakii, taa manjeevənaakii əsə kaa ŋwaŋuunə ŋga Əntaŋfə a shii dzənə aakəŋwa, ");
INSERT INTO gde_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ma ca, ka upaanə nə ci sətə palee ka ətə bwasee ci aaba'ə agi zamanana. Ha'ə əsə agi zamanatə na shi, kadə nii kəya upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Wata Yeesu a 'wagi lyawarənaakii pu'u aji bəra'i tsaŋə aataŋgala. Əŋki ci ka tii, “Fatəmə ŋga'ə! Wanaamə ka dzənə aa Urusaliima. Patənə ŋga uushi'iitə nyaahə anabiinə agyanə *Uuzənə ŋga ənda, davə nə ənjə a mbu'utəgi. ");
INSERT INTO gde_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Waatoo, ka viinə nə ənji tə ci aacii ənjitə mashiimə tə Əntaŋfə. Ma təya, ka ŋusənə nə tii tə ci, təya dzaana tə ci. Ka tiifənə nə tii giirənə aashikii, ");
INSERT INTO gde_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","təya fəslə, təya ɓələgi tə ci. Ma ka makkənə ŋga uusəra, ka maɗətənə nə ci agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Amma, ma lyawarənaakii, pooshi tii paaratəgi də waɓənaakii. Ma'umbeekii nə waɓənəkii ka tii. Mashiimə tii taa agyanə mi nji Yeesu a waɓə. ");
INSERT INTO gde_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Ma ətə Yeesu kədəhə ka mbu'unə aa Yarikoo, tə'i muurəfə dasə ha'ə ataŋgala rəgwa ka kədiinə. ");
INSERT INTO gde_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Makə fii ci ənjə a pitə də waazənə, ca ləgwa ka ənjitə aɓiikii taa mi ci ənjə a waazə ha'ə. ");
INSERT INTO gde_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","Wata əŋki ənji ka ci, “Yeesu, əndə Nazaratu ca pitə.” ");
INSERT INTO gde_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Wata ŋgəreenə nə muurəfətə ka uurakii, əŋki ci, “Yeesu, jijinə ŋga *Dawuda, nəhuu təgunuunaaki!” ");
INSERT INTO gde_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Ənjitə nja takəŋwa a wazə ka ci kaa ca ndzaa kəɗa'ə. Amma wata ca tsakə ŋgəree ka uurakii palee ka əta, əŋki ci, “Jijinə ŋga Dawuda, nəhuu təgunuunaaki!” ");
INSERT INTO gde_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Wata Yeesu a kəŋaanə, ca ba ka ənja, “Əncahatəgimə ka nyi də ci.” Makə əncaha muurəfətə, əŋki Yeesu ka ci: ");
INSERT INTO gde_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Mi cii kwa moo nya ɗa ka ha?” Əŋki ci, “Slandanəkya, ŋga'ə ka nyi kaa nya ənə ka neenə ka ha.” ");
INSERT INTO gde_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Əŋki Yeesu ka ci, “Wa ginəku a wunəgi kaa ha ənə ka neenə! Kə mbə'i hə putə ŋga gi'inaaku tə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Pii wata ca nee ka ha. Nə'unə nə ci tə Yeesu, ca dzə də dəlanə də Əntaŋfə. Makə nee patənə ŋga ənjitə ha'ə, wata təya ndzaŋə dəlanə də Əntaŋfə natii. ");
INSERT INTO gde_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Mbu'unə ŋga Yeesu aasəkə vəranə ŋga Yarikoo, ca dzə dasəkə vəranəkii. ");
INSERT INTO gde_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","Ma davə də vəra, tə'i əndə'i əndə ɗii ləməkii Zakayusə. Gawə nə ci agi *ənji luu tsəka. Əndə gəna əsə. ");
INSERT INTO gde_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Ma saa'ikii, kə ali ci rəgwa ŋga neenə taa wu nə Yeesu. Amma, makə ɗii ci gusə nə ci, kə təkuree ci ka neenə ka ci acii daɓaala. ");
INSERT INTO gde_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Makə ɗii ha'ə, wata ca huyipaa aakəŋwa, ca ndərəgi aa ənfwə ɓara kaa ca nee ka ci, acii dadavə nii kəya pitəgi. ");
INSERT INTO gde_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Makə mbu'i Yeesu ka hatə ɗii Zakayusə davə, wata ca maɗee ka ginəkii aadəgyə, əŋki ci ka ci, “Zakayusə, tsəgwayi, jimagərə. Acii, ma ənshina, gaku asii dəɓee ndzaanəki.” ");
INSERT INTO gde_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Jimagərənə nə Zakayusə pii pii, ca luu tə Yeesu də mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Makə nee ənji ha'ə, wata ŋguŋgunənə nə tii, təya ba, “Aa ha ma'waslyakə əndə gi ci.” ");
INSERT INTO gde_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Maɗətənə nə Zakayusə, əŋki ci ka Yeesu, “Slandana, a təkee nyi ka uushi'inaaki tatsə mbərə mbərə, nya vii reetakii ka maaghiinə. Ma ənjitə gəpi nyi də tii, ka jikəənənə nə nyi ka tii ənfwaɗə agyanə sətə gəpətə nyi aciitii.” ");
INSERT INTO gde_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Əŋki Yeesu, “Ma ənjinə ganə asii, ənshinə upaa tii luupaanə. Acii taa Zakayusə əsə, agi slikərənə ŋga Ibərahiima shigi ci. ");
INSERT INTO gde_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Acii ma shi nya, nyi *Uuzənə ŋga ənda, ka aalənə tə maza ənja, nya luupaa tə tii.” ");
INSERT INTO gde_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Makə nji ənjə a fa waɓənə a ma Yeesu ha'ə, kə gi ci aakəŋwa də ɗa ka tii misaali. Acii kədəhə nə ci da vəranə ŋga Urusaliima, ma nə ənji ka nəhənə, kədəhə nə Əntaŋfə ka ɗa ŋwaŋuunaakii. ");
INSERT INTO gde_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Wata əŋki ci ka tii, “Tə'i maɗuunə ənshara. Kə pyalə ci ka madzaɗə hanyinə ka liwa ŋwaŋuunə, ma daba'əkii ca ənya. ");
INSERT INTO gde_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Ma taabu'u gi ci, ci kə 'watə ənji pu'u agi daguyinaakii. Kə ŋgirə ci pamə pu'u, ca təkəpaa ka tii mbərə mbərə. Əŋki ci ka tii: ‘Zhi'igimə see maɗa ənya nyi.’ ");
INSERT INTO gde_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amma pooshi ənji ŋga nə ŋga hanyinaakii ka uuɗənə tə ci. Kə sləkee tii ka ənji daba'əkii kaa təya dzə ka banə ka ənjitə ca ɗəkə ŋwaŋwə oo'i: ‘Ma əndətsa, paa inə ka moonə ca ɗa keenə ŋwaŋuunə.’ ");
INSERT INTO gde_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“Yoo, makə upaa ci ŋwaŋuunə, wata ca ənya. Ca sləkee ka ənjə a 'waa'watə ka ci daguyinaakii ətə vii ci ka tii kwaɓata. Waatoo, kaa ca nee taa iitə nji əndə a zhi'igi naakii də sətə vii ci ka ci. ");
INSERT INTO gde_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Təkəŋwatə dagwa a shi. Əŋki ci: ‘Slandana, ma pamə ətə rəŋwə vii hə ka nyi, kə tii, kə ɗii ka pamə pu'u.’ ");
INSERT INTO gde_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","Əŋki ci ka ci: ‘Yawa, ŋga'ə, ŋunyi əndə slənə nə hə. Kə slənyi hə də uuji uushi'inə də rəgwakii. Aciikii, ɗawə ŋwaŋuunə agyanə vəranyinə pu'u.’ ");
INSERT INTO gde_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Shinə nə bəra'inə. Əŋki ci: ‘Slandana, ma pamə ətə rəŋwə vii hə ka nyi, kə tii, kə ɗii ka pamə tufə.’ ");
INSERT INTO gde_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","Əŋki ŋwaŋwə ka əndəta: ‘Ma hə əsa, ɗawə ŋwaŋuunə agyanə vəranyinə tufə.’ ");
INSERT INTO gde_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","“Shinə nə əndə'i dagwa. Əŋki ci: ‘Slandana, wiinə pamaaku rəŋwə. Kə anətə nyi asəkə kəjeerənə, kə ŋgagi nyi. ");
INSERT INTO gde_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Acii kə ŋgwali nyi aciiku. Kə shii nyi, ma hə, əndə tamwə nə hə. Kə ndzaa hə makə əndətə ca ŋgərə sətə maɗəkəpaamə ci. Kə ndzaa hə əsə makə əndətə ca slənə cifanə ŋga sətə maləgamə ci.’ ");
INSERT INTO gde_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","Əŋki ŋwaŋwə ka ci: ‘Ma ha, bwaya lawarə nə hə. Waɓəətsə a maku nə gəŋwanaaku. Kə shii hə oo'i, əndə tamwə nə nyi, agi ŋgərənə nə nyi sətə maɗəkəpaamə nyi, agi slənənə nə nyi cifanə ŋga sətə maləgamə nyi. ");
INSERT INTO gde_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Aa ya maɗa ha'a, mi unee hə ka ɗəkəpaa pamaaki ka hatə ci ənjə a zhi'igya? Maci ha'ə ɗii hə, kə nji nya ŋgərə pamaaki da i ma'inəkii agyanəkii, nyi kə ənya.’ ");
INSERT INTO gde_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“Wata əŋki ci ka ənjitə aɓiikii: ‘Luugimə pamətsə rəŋwə aciikii, una vii ka əndətə da pamə pu'u aciikii.’ ");
INSERT INTO gde_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Əŋki tii ka ci: ‘Slandana, əntaa kə uugi ci upaa pamə pu'wa?’ ");
INSERT INTO gde_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Əŋki ci: ‘Wanyinə ca ba koonə: ma əndətə da i uushi aciikii, ka ci tsakənə ənji viinə. Amma, ma əndətə ɗii naakii gi'u, taa gi'ukii maa, ka luuginə nə ənji aciikii. ");
INSERT INTO gde_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Ma məza ənjaaki əsə, waatoo ənjitə mamoomə nya ɗa ka tii ŋwaŋuunə, kaashatəmə tə tii, una kira tə tii aa hanə, una ɓəələgi tə tii ganə akəŋwaciiki.’ ” ");
INSERT INTO gde_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Makə uugi Yeesu waɓəginə ha'ə, wata ca ŋgərə rəgwa, ca takəŋwa ka ənji aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Makə mbu'i Yeesu kədəhə da vəranyinə ŋga Bayitifaaji da Bayitaniya ashi giŋwə ŋga Zayitunə, wata ca sləkee ka hara lyawarənaakii bəra'i ");
INSERT INTO gde_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","də banə ka tii, “Dəmə aasəkə vəraatsə aakəŋwa. Maɗa kə mbu'yuunə aa dəvə, ka lapaanə nuunə uundzə vamənda gwalə. Ma uundzə vaməndakii, pooshi əndə sha ŋgirə aa ba'akii shaŋə. Pəryatəmə, una kira. ");
INSERT INTO gde_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","Maɗa kə ləguyi əndə a moonə taa ka mi cuuna pərə, bamə ka ci: ‘Slandanə mwayi.’ ” ");
INSERT INTO gde_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Wata lyawariitə sləkee Yeesu a maɗə, təya palə, təya lapaa weewee makə sətə bii ci ka tii. ");
INSERT INTO gde_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Ma təya pərə vaməndata, əŋki slanjiinəkii ka tii, “Ka mi cuuna pərə uundzə vaməndatsa?” ");
INSERT INTO gde_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Əŋki tii, “Slandanə mwayi.” ");
INSERT INTO gde_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Wata təya kira uundzə vaməndatə ka Yeesu, təya luukutəvə kəjeerənyinatii a ba'a uundzə vaməndata, təya ndərəvə də Yeesu aa ba'akii. ");
INSERT INTO gde_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Ma ca dzə də palənə, sasafəpaa nə ənji kəjeerənyinə a rəgwa ka gaɗeeginə ka ci. ");
INSERT INTO gde_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Mbu'unə ŋga Yeesu kədəhə da vəranə ŋga Urusaliima, ma ətsə ca jimə ashi giŋwə ŋga Zayitunə, wata daɓaala ənji nə'unə tə ci a ndzaŋə ɗa mooɗasəka, təya ŋgəree ka uuratii ka dəlanə də Əntaŋfə putə ŋga ɓəzə uushi'inə ŋga hurəshishiitə nee tii Yeesu a ɗaaɗa. ");
INSERT INTO gde_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Əŋki tii, “Tə'i barəkaanə ashi ŋwaŋutə shi də ləmə ŋga Slandana! Acii Əntaŋfə nə jamənə dagyə, naakii nə ɗuunuunə əsə, ci Əndə məghərəvənə ka shaŋə.” ");
INSERT INTO gde_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Tə'i hara *Farisanyinə gatə agi daɓaala. Əŋki tii ka Yeesu: “Maləma, bawə ka lyawarənaaku, wa təya ndzaa kəɗa'ə.” ");
INSERT INTO gde_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Əŋki Yeesu, “Wanyinə ca ba koonə: maɗa kə ndzaa tii kəɗa'ə, ka ndzaŋənə nə faariinə natii.” ");
INSERT INTO gde_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Makə əncahatə Yeesu kədəhə da vəranə, nee ci ka vəranəkii, ca gwaŋə ka tuunə agyanə ənji vəranəkii. ");
INSERT INTO gde_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Əŋki ci, “Maci uushə a batə koonə sətə ca kira koonə ndzaanə jamə ənshinə ku! Amma, ma ətsa, kə umbəgi anuunə, paa unə ka mbeenə ka neenə əsə. ");
INSERT INTO gde_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Tə'i uusəra na shi, waatoo saa'itə nə ənji mbiinə goonə a tsagərə tuunə aasəkə, təya kərə'utə tuunə, təya pa'əgi rəgwa agyanuunə taa dama patə. ");
INSERT INTO gde_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Ka zamaginə nə tii duunə, təya waalagi kuvənyinə asəkə vəranə goonə patə. Taa rəŋwə pooshi faara na mbəɗaanə anə əndə'i. Ma nə ətsə a ɗa ha'ə, acii mashiimuunə taa guci shi Əntaŋfə ka tsakənə tuunə.” ");
INSERT INTO gde_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Mbu'unatii aasəkə vəranə, kə dəməgərə Yeesu aasəkə yi ŋga Əntaŋfə. Wata ca ndzaŋə shaabagi tə ənji ɗa fiiriinə davə. ");
INSERT INTO gde_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Əŋki ci ka tii, “Tə'i manaahəkii asəkə malaaɓa ləkaləkatə oo'i, ma bii Əntaŋfə: ‘Ka ndzaanə nə yaaki ka yi ŋga ɗa də'wa.’ Amma, ma una, kə geegyuunə ka yikii ka ha ŋga umbənə ŋga mahiirənə!” ");
INSERT INTO gde_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Ma Yeesu, uusəra patə jigunyi ci ka ənji asəkə yi ŋga Əntaŋfə. Kə ali madiigərə limanyinə da maliminə rəgwa ŋga ɓələginə tə ci. Ha'ə nə matakəŋwanyinə əsə. ");
INSERT INTO gde_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amma kə təkuree tii ka rəgwakii, acii patənə ŋga ənja, kə kavə tii nətii ka fa sətə cii kəya dzəgunə ka tii. ");
INSERT INTO gde_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Ma ka əndə'i uusəra, Yeesu a dzəgunə ka ənji asəkə yi ŋga Əntaŋfə, ca waaza Ŋunyi Habara. Kə shi madiigərə limanyinə da maliminə da gayinə aaɓiikii. ");
INSERT INTO gde_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Əŋki tii ka ci, “Bawə keenə də ŋgutə baawəɗa saŋə cii kwa ɗaaɗa uushi'iinə ha'a? Wu saŋə vii ka hə baawəɗatsa?” ");
INSERT INTO gde_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Əŋki Yeesu ka tii, “Nyi maa, ka ləgwanə nə nyi a moonə naaki, bamə ka nyi ɗii: ");
INSERT INTO gde_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Wu saŋə sləkee ka Yoohana kaa ca ɗa bapətisəma ka ənja, Əntaŋfə nii, anii ənda?” ");
INSERT INTO gde_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Wata təya gwaŋə ka ɗa waɓənə ahadatii, əŋki tii, “Mi banaamə əna? Maɗa bii amə oo'i, Əntaŋfə sləkee ka Yoohana, ka banə nə ci, aa mi pooshi unə luuvə waɓənaakii ɗiya? ");
INSERT INTO gde_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amma maɗa kə bii amə oo'i, ənji sləkee ka ci, ka kaalatənə nə daɓaala taamə, acii ma nə tii ka nəhənə, ma Yoohana, anabi nji ci.” ");
INSERT INTO gde_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Wata əŋki tii, “Mashiimiinə taa wu sləkee ka ci.” ");
INSERT INTO gde_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Əŋki Yeesu ka tii naakii, “Ha'ə nə nyi əsə, paa nyi ka banə koonə taɗa də ŋgutə baawəɗa cii kya ɗa uushi'iina.” ");
INSERT INTO gde_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Wata Yeesu a gwaŋə ka waɓənə ka ənji də ɗa misaalina, əŋki ci, “Tə'i əndə'i əndə sha ɗii rə ŋga inabi. Ca ŋgərə rəkii, ca vəgi ka mooziinə kaa təya təkə cifanə ŋga rəkii da i ci. Ma daba'əkii, ca palə oogə. Kə ta'avə ci davə. ");
INSERT INTO gde_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Makə ɗii cifanə ŋga inaba, wata ca sləkee ka əndə slənaakii ka liwa ka ci gyaɗalaakii aciitii. Wata təya kəsə tə ci, təya fəəsləpaa, təya ənəpaa də ci pooshi taa mi aciikii. ");
INSERT INTO gde_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Slanda rətə a ənə ka sləkee ka əndə'i əndə slənaakii. Ma ci əsa, kə fəəsləgi mooziitə tə ci, ayi ayi dərəva ciɓee tii ka ci, təya ənəpaa də ci pooshi taa mi aciikii. ");
INSERT INTO gde_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Slanda rətə a ənə ka sləkeenə ka əndə'i əndə ka makkənə əsə. Ma ci əsa, kə ɗavə tii ka ci uya, təya lyakaanə tə ci. ");
INSERT INTO gde_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Əŋki slanda rətə ka naakii nə: ‘Iitə saŋə ɗanəki də ənjitsa? Takwa a sləkee nyi ka uuzənaaki ətə uu'i nyi. Mbu'u ka gaɗeenə nə tii ka ci.’ ");
INSERT INTO gde_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amma, makə nee mooziitə ka uuzəətə, wata əŋki tii ahadatii: ‘Waanə mazəmə yi kə mbu'ya. Ɓələgyaamə tə ci kaama zəmə ya.’ ");
INSERT INTO gde_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Wata təya kəsətə tə ci, təya kagi tə ci aa ba'a tsanə, təya ɓələgi tə ci. “Ya ətsa, mi nə sətə ɗanə slanda rətə də təya? ");
INSERT INTO gde_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Ka shinə nə ci, ca ɓəələgi tə tii, ca vəgi rətə ka hara mooziinə.” Makə fii ənji waɓəətsə ha'ə, əŋki tii, “Aa'a, wa Əntaŋfə a dzagya!” ");
INSERT INTO gde_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Wata Yeesu a tsaamətə tə tii, əŋki ci, “Aa maɗa ha'ə əna, ka mi ɗii nyaahə ənji aasəkə malaaɓa ləkaləkata, tuu'inə, ‘Ma faaratə kaaree ənji ghənə kuva makə pooshi nafaakii, ci ənəpaa ka faaratə palee də məghərəvənə.’ ");
INSERT INTO gde_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Taa wu patə kulii aanə faaratsa, ka əɓinə nə ci. Maɗa kə kulii faarakii aanə əndə əsa, ka ədəginə tə ci makə əmpunə.” ");
INSERT INTO gde_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Kə ali maliminə da madiigərə limanyinə rəgwa ŋga kəsənə tə Yeesu ka tsaakii, acii kə shii tii oo'i, agyanətii waɓi ci də misaalitsa. Amma kə ŋgwali tii acii ənja. ");
INSERT INTO gde_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Wata təya ndzaŋə nəhənə tə Yeesu. Təya sləkee ka maɗəkənyinə aaɓiikii ətə ca ɗeegi ka natii nə makə ənji gooŋga. Ma ɗii tii ha'a, kaa təya mbee ka pwaakya waɓənə ətə madzəmə ama Yeesu; waatoo, ka kavənə tə ci aasəkə cii ŋgwaməna. ");
INSERT INTO gde_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Əŋki maɗəkənyiitə ka Yeesu, “Maləma, kə shii inə oo'i, ma sənə cii kwa waɓə da sənə cii kwa dzəgunə patə, kə ndzaanə də rəgwakii; paa hə ka tsaamənə ka ɗuunuunə ŋga ənda. Də gooŋga nə hə ka dzəgunətənə ka ənji rəgwa ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Ya saŋa, kə kapaa bariya gaamə kaamə rəgwa ŋga vii tsəkə ka ŋwaŋwə Kayisarə nii, anii poosha?” ");
INSERT INTO gde_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Asee, kə shii Yeesu jarəwiinatii. Əŋki ci ka tii: ");
INSERT INTO gde_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Kiramə kwaɓa kaa nya tsaamətə.” Makə caamə ci, ca ləgwa ka tii, əŋki ci, “Ya əna, kəŋwaciinə da ləmə ŋga wu ənə anə kwaɓana?” Təya ba, “Ma ətsa, kəŋwaciinə ŋga ŋwaŋwə Kayisarə.” ");
INSERT INTO gde_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Wata Yeesu a ba ka tii, “Makə ha'ə ɗiya, viimə ka Kayisarə sətə ndzaa ka naakii, una vii ka Əntaŋfə sətə ndzaa ka ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Kə təkuree tii ka upaa sə ŋga kəsənə tə ci də ma'inə agi səndə waɓi ci akəŋwacii patənə ŋga ənja. Kə ɗii ka tii ka sə ŋga hurəshishinə nə jikəvənaakii, wata təya ənəgi kəɗa'ə. ");
INSERT INTO gde_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Kə shi hara *Sadukiinə aaɓii Yeesu. Ma təya, tii nə kurəgətə ca ba, pooshi maməətə ənji ka maɗənə da i əpinə shaŋə. ");
INSERT INTO gde_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Əŋki tii ka Yeesu, “Maləma, kə nyaahə Muusa kaamə bariya ətə bii ci, maɗa kə əntəgi əndə anə minaakii, pooshi tii pwayi manjeevənə, see a ŋgərə ndzəkəŋuci tə miita, kaa ca poo manjeevənə ka ndzəkəŋuci ətə əŋki. ");
INSERT INTO gde_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Ma sha ɗii, tə'i ndzəkəŋushi'inə məɗəfə. Kə ŋgirə gawatii minə. Kə əntəgi ci. Pooshi uuzənə. ");
INSERT INTO gde_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Bəra'inə a ŋgərə mooryafiita. Ca əntəgi. Pooshi uuzənə. ");
INSERT INTO gde_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Makə ətsə əsə ɗii ka makkənə. Ha'ə ɗii ka tii patə məɗəfə: kə məətəgi tii. Pooshi əndə upaa uuzənə ashitə. ");
INSERT INTO gde_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ma daba'əkii, kya əntəgi əsə. ");
INSERT INTO gde_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Ya ətsa, maa ma'i tii patə uusəra ŋga maɗənə ŋga maməətə ənja, makə watiitsə tii patə məɗəfə ŋgirə tə kya, minə ŋga wu saŋə ndzaanəta?” ");
INSERT INTO gde_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Əŋki Yeesu ka tii, “Agi duuniya ci ənjə a ŋgərəshi. ");
INSERT INTO gde_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","Amma, ma ənjitə mbu'i bahə upaa rəgwa ŋga maɗənə da i əpinə, da ŋga ndzaanə agi zamanatə na shi, paa tii na ŋgəərəshi. ");
INSERT INTO gde_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Acii paa tii ka məətənə ma'ə. Makə malaa'ikanyinə nə təya ndzaanə. Manjeevənə ŋga Əntaŋfə nə tii; acii kə maɗee ci ka tii da i əpinə. ");
INSERT INTO gde_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Ma agyanə maɗənə ŋga maməətə ənji əsa, taa Muusa maa, ma saa'itə waɓi ci agyanə guutə agi ba, kə ɓaarii ci oo'i, ka maɗənə nə tii. Ma saa'ikii, kə 'wii ci tə Əntaŋfə Slandanə də Əntaŋfə ətə ci Ibərahiima da Isiyaaku da Yakubu a paslə. ");
INSERT INTO gde_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Ma Əntaŋfə, ənjitə da i əpinə amatii ca paslə tə ci, əntaa ənjitə yadə əpinə amatii. Acii ma ndzaa ənji patə da i əpinə amatii, ka ci saakii.” ");
INSERT INTO gde_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Wata əŋki hara maliminə, “Ma ɗii Maləma, ŋga'ə waɓi hə.” ");
INSERT INTO gde_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Ma daba'əkii, pooshi əndə ənyi ka ləgwa waɓənə ama Yeesu ma'ə, acii ŋgwalənə. ");
INSERT INTO gde_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Əŋki Yeesu ka tii, “Iitə saŋə mbee ənji ka banə oo'i, jijinə ŋga *Dawuda nə Aləmasiihu? ");
INSERT INTO gde_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Acii taa Dawuda də naakii nə maa, kə bii ci asəkə ləkaləkatə ŋga Jabuura oo'i: ‘Əŋki Əntaŋfə Slandanə ka Slandanəki, ndzaanə gadəvə da ciizəmaki. ");
INSERT INTO gde_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","Ka kavənə nə nyi ənji daawaanaaku aatsaa səɗəku.’ ");
INSERT INTO gde_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Wiinə ɗii, kə 'wii Dawuda tə Aləmasiihu də Slandana. Aa iitə ɗii ndzaa ci ka jijinaakəya?” ");
INSERT INTO gde_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Əŋki Yeesu ka lyawarənaakii akəŋwacii patənə ŋga ənja, ");
INSERT INTO gde_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Nəhəmə noonə nə acii *maliminə ŋga bariya. Ma təya, də madiigərə kəbənə moonətii wiigi'inə. Ma moonətii, nəəhəpaanə tə tii ŋga'ə a luuma. Ka hatə da ginə davə moonətii ndzaanə asəkə *kuvə də'wanyinə da agi əndzanə. ");
INSERT INTO gde_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Təya luuwutə yinyinə ŋga mooryafinyinə, təya gərətəgi də də'wa ka dəla də natii nə akəŋwacii ənja. Ma təya, kadə nə təya upaa bwaya gəŋwanə ətə palee patə.” ");
INSERT INTO gde_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Maɗeenə nə Yeesu ka ginəkii, ca tsaamə ənji gəna a həəji kwaɓa asəkə *yi ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Wata maagha ŋga mooryafinə a shi natə. Ma Yeesu a nee, kə əjivə ki pyanya bəra'i. ");
INSERT INTO gde_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Wata əŋki ci, “Tantanyinə cii kya ba koonə: ma sətə əjigərə maagha ŋga mooryafiitsa, kə palee ka ŋga hara ənjitsə patə. ");
INSERT INTO gde_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Acii ma təya, agi ɓəzə gəna ŋgiragi tii, təya vii. Amma, ma kya, agi ghanatə patə, kə ŋgərətə ki patənə ŋga sətə cii ta alə də zəmə, kya əjigərə.” ");
INSERT INTO gde_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Kə waɓi lyawarənaakii agyanə dagwaanə ŋga yi ŋga Əntaŋfə, acii kə ɗii ənji yikii də faariitə da məghərəvənə davə da i hara uushi'inə ətə vii ənji ka Əntaŋfə. Əŋki Yeesu: ");
INSERT INTO gde_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Kə nee unə ka uushi'iitsa: kadə nə uusəra a mbu'ya. Maɗa kə mbu'ya uusərakii, taa rəŋwə pooshi faara na mbəɗaanə anə əndə'i, ka waalaginə nə ənji patə.” ");
INSERT INTO gde_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Əŋki ənjitə nji davə, “Maləma, guci saŋə nə ətsə ha'ə a ɗa? Mi saŋə na slənə ka ɓaariinə oo'i, kədəhə nə uushi'iitsə ka ɗaaɗana?” ");
INSERT INTO gde_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Əŋki Yeesu ka tii, “Nəhəmə acii ga ənjə a gəpi duunə. Acii tə'i ənji laŋə na shi, təya ɗəkəvə ləməki ka natii na, taa wu ca ba, ci nə *Aləmasiihu. Ka banə nə tii əsə, kə uugi uusəra mbəshanə. Ma ɗanuunə, goona nə'u tsaa səɗətii. ");
INSERT INTO gde_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Maɗa kə fii unə habara ŋga paapanə da purətə haŋkalaanə, goona ŋgwalə shaŋə. Kə dəɓee ətsə ha'ə a ɗa zəku'i. Amma, əntaa uudənə ŋga duuniya nəndə ka ɗanə pii ha'ə makə ətsa.” ");
INSERT INTO gde_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Yeesu a tsakə banə ka tii, əŋki ci, “Kadə nə əndə'i slikərənə a dzə ka panə da əndə'i. Ŋwaŋuunə a pa da əndə'i ŋwaŋuunə. ");
INSERT INTO gde_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Kadə nə bwaya gəgədzənə ŋga hanyinə a ɗaaɗa. Kadə nə maɗəfənə da muuva a ɗaaɗa taa dama patə. Kadə nə sə ŋga ŋgwalənə a ɗaaɗa da madiigərə sagidanyinə agintaŋfə. ");
INSERT INTO gde_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","“Amma daga uushi'iitsə ha'ə ma'ə maɗamə, tə'i ənji na kəəsə tuunə, təya ciɓee koonə, təya kərə tuunə aakəŋwacii gayinə ŋga *kuvə də'wa ka ɗa koonə gəŋwanə, təya kaalagərə tuunə aa furəshina. Ka kəərənə nə ənji tuunə aakəŋwacii meeminə da ŋgwamənanyinə putə ŋga nə'unə goonə tə nyi. ");
INSERT INTO gde_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ma nə uushi'iitsə patə a ɗaaɗa ha'ə, ka wunəgi koonə də rəgwa ŋga bagi ka tii Ŋunyi Habaraaki. ");
INSERT INTO gde_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Aciikii, ma ɗanuuna, kavəmə aagi hiima goonə, goona ndzaanə ka buurənə agyanə makə sətə nuunə a jikəvə koona mbəɗə. ");
INSERT INTO gde_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Acii nyi na vii koonə jarəwiinə ŋga waɓənə da hiima. Pooshi əndə taa rəŋwə agi ənji mbiinə goonə na mbee ka ɗa koonə mabizhinə taa ka uurənə tuunə agi waɓənə. ");
INSERT INTO gde_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Taa məsənuunə da dəsənuunə da ndzəkəŋushi'inuunə da duurənyinə goonə da guviinuunə maa, ka dyarə'unə nə tii tuunə. Ma hara ənji agyuunə, ka ɓələginə nə ənji tə tii. ");
INSERT INTO gde_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Taa wu patə əsə, kadə nii kəya ushapaa tuunə putə ŋga nə'unə goonə tə nyi. ");
INSERT INTO gde_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Amma taa shiŋkinə goonə rəŋwə, pooshi na za. ");
INSERT INTO gde_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Acii ha'ə kəŋaanəmə ndihə ndihə koona luupaa də noonə na.” ");
INSERT INTO gde_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“Maɗa kə nee unə kə kərə'utə soojiinə tə vəranə ŋga Urusaliima, ma ətsə kamə, kədəhə nə vəranəkii ka ɗaginə ka uufinə. ");
INSERT INTO gde_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Ma ka uusərakəya, wa ənjitə anə hanyinə ŋga Yahudiya a huyi ka umbənə aanə giŋunyinə. Ma ənjitə asəkə vəranə, wa təya əntsahəgi. Ma ənjitə aba'ə vəranə, ga təya ənya aasəkə vəranə. ");
INSERT INTO gde_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Acii ka ndzaanə nə uusərakii ka uusəratə nə Əntaŋfə a ki'itə ka ənja. Ətsə ha'ə na mbu'utəgi də patənə ŋga uushi'iitə asəkə malaaɓa ləkaləkatə. ");
INSERT INTO gde_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Tə'i ŋgəra'wə agyanə maki ɗasəkiinə da ŋugiginə ka saa'ikii. Acii kadə nə bwaya ciɓə a ɗa anə hanyinə, acii tə'i maɓətə səkə ŋga Əntaŋfə agyanə ənja. ");
INSERT INTO gde_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Ka ɓəələginə nə ənji tə hara ənji də ŋgila purəŋanə. Hara ənji, ənjə a kəsə tə tii, ənjə a kərə tə tii ka mavaanə aanə hara hanyinə. Ka udzəginə nə ənjitə mashiimə tə Əntaŋfə tə vəranə ŋga Urusaliima see maɗa dzəgi zamanatii.” ");
INSERT INTO gde_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“Kadə nə sə ŋga hurəshishinə a ɗaaɗa agi uusəra, agi ləgiɗə da agi tikisanyinə. Kadə nə ənjə a ndzaanə ka maji ma'yanə agi duuniya. Paa tii na shii sə ŋga ɗanə acii dzaadzanə ŋga uunəvə da maɗənə ŋga ma'inə aadəgyə aadəgyə. ");
INSERT INTO gde_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Kadə nə ma'yanə ŋga ənjə a ləɗə acii ŋgwalənə putə ŋga sətə na kulaanə ka tii agi duuniya. Acii taa mi patə asəkəntaŋfə ka gaŋgəzənə. ");
INSERT INTO gde_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ma ətsə ɗiya, ka neenə nə ənji ka Uuzənə ŋga əndə ca jima agi kuraɓiinə. Da baawəɗa da məghərəvənə laŋə nə shinaakii. ");
INSERT INTO gde_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Maɗa kə nee unə uushi'iitsə a 'watəgi ɗaaɗanə, kəŋaanəmə ndihə ndihə, kavəmə nuunə davə acii kədəhə nuunə ka upaa luupaanə.” ");
INSERT INTO gde_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Yeesu a ɗa ka tii misaali, əŋki ci, “Katəmə hiima goonə agyanə ənfwə uudəvə da hara ənfuginə patə. ");
INSERT INTO gde_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Maɗa kə nee unə wiitə ka 'watəgi ənənə, kə shii unə ətsə, kədəhə nə mətsətsəfə ka ɗanə. ");
INSERT INTO gde_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ha'ə əsə, maɗa kə nee unə uushi'iitsə a ɗaaɗa, ka shiinə nuunə ətsə oo'i, kədəhə nə Əntaŋfə ka ɗa ŋwaŋuunə. ");
INSERT INTO gde_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Tantanyinə cii kya ba koonə: ma ənji ŋga zamanana, pooshi tii ka məətəginə patə, uushi'iitsə ma'ə maɗaaɗamə patə. ");
INSERT INTO gde_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Ka uudəginə nə ha a dagyə da ha a panə. Amma, ma waɓənaaki, pooshi ka uudənə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“Nəhəmə noonə na! Goona kavə noonə nə ka zəəmə əndzanə da saasa ənvwə dərəva. Goona kavə noonə nə agi buurə uushi'inə ŋga *duuniya, acii ga uusərə ŋga shinə ŋga Uuzənə ŋga əndə a lapaa tuunə pəmə, ");
INSERT INTO gde_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","makə sətə ci zaaŋwanə a umbəənə ka luwa. Acii ma uusərakəya, pəmə nii kəya lapaa tə patənə ŋga ənji agi duuniya. ");
INSERT INTO gde_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Ndzaamə də məgigi, ɗamə də'wa taa hayi patə, koona shii upaa ŋgeerənə ŋga mbərəɗənə acii uushi'iitsə na ɗaaɗa patə, una mbee ka kəŋaanənə akəŋwacii Uuzənə ŋga əndə yadə ŋgwalənə.” ");
INSERT INTO gde_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Uusərə patə nji Yeesu a dzəgunə doosərə ka ənji asəkə yi ŋga Əntaŋfə. Ma kədəwanə, ca dzə ka baanə ashi giŋutə ci ənjə a 'wa giŋwə ŋga Zayitunə. ");
INSERT INTO gde_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Pukənə ŋga ha patə ha'ə nə ənji patə ka waaryanə aasəkə yi ŋga Əntaŋfə ka fa sətə cii kəya baaba. ");
INSERT INTO gde_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Yoo, kə mbisha *kumənə ŋga adə buroodi yadə burəŋanə, waatoo kumənə ətə ci ənjə a 'wa *Pasəka. ");
INSERT INTO gde_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","Makə ɗii ci, ma madiigərə limanyinə da *maliminə ŋga bariya, ŋgwalii tii acii ənja, kə aali tii rəgwanyinə ŋga ɓələginə tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Wata kə ŋgirə *Seetanə aashi Yahuda ətə ci ənjə a 'wa Isəkariyootə. Ma ca, rəŋwə nə ci agi *lyawarənə ŋga Yeesu pu'u aji bəra'i. ");
INSERT INTO gde_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Maɗənə nə ci, ca dzə aaɓii madiigərə limanyinə i da meeminə ŋga soojiitə ca nəhə yi ŋga Əntaŋfə, ca waɓə da tii agyanə makə sətə mbeenəkii ka viinə tə Yeesu ka tii. ");
INSERT INTO gde_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Fanatii ha'ə, kə ɗii tii mooɗasəka, təya ɗa aləkawalə ŋga vii ka ci kwaɓa. ");
INSERT INTO gde_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Wata kə luuvə ci, ca 'watəgi tsaamə ŋunyi saa'i ŋga viinə tə Yeesu ka tii yadə shiinə ŋga ənja. ");
INSERT INTO gde_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Mbu'yanə ŋga kumənə ŋga adə buroodi yadə burəŋanə agikii, waatoo uusəratə nə ənji ka laala uura ŋga uuji bagiinə ka buurətə də Pasəka, ");
INSERT INTO gde_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","wata Yeesu a sləkee ka i Piita da Yoohana, əŋki ci ka tii, “Dəmə ka dzəgə kaamə əndzanə ŋga Pasəka.” ");
INSERT INTO gde_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Əŋki tii ka ci, “Da daa moonəku ina dzəga?” ");
INSERT INTO gde_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Əŋki ci ka tii, “Maɗa kə dəməgəruunə aasəkə vəranə, ka guŋunə nuunə da əndə da uuda ma'inə anəkii. Ma ɗanuuna, nə'umə tə ci aasəkə yitə cii kəya dəmə aadəvə, ");
INSERT INTO gde_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","una ba ka slanda yikii əsə: ‘Ma bii Maləmə tuu: miinə kuvətə nii kəya zəmə əndzanə ŋga Pasəka davə da lyawarənaakii kwa?’ ");
INSERT INTO gde_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","Kadə nii kəya ɓaarii koonə maɗuunə kuvə anə əndə'i, mahaɗakii ŋga'ə. Davə dzəgənuunə kaamə əndzanə.” ");
INSERT INTO gde_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Palənə nə tii, təya lapaa makə sətə bii Yeesu ka tii weewee. Wata təya dzəgə əndzanə ŋga Pasəka davə. ");
INSERT INTO gde_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Makə mbu'i saa'i ŋga zəmə əndzanə, Yeesu da masləkee ənjaakii a ndzaanə ka zəma. ");
INSERT INTO gde_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Əŋki ci ka tii, “Də tantanyinə nə nyi ka moonə zəmə əndzanə ŋga Pasəkanə doonə, taabu'u ciɓənəki. ");
INSERT INTO gde_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Wanyinə ca ba koonə: paa nyi ka zəmə əndzanə ŋga Pasəka ma'ə shaŋə, maɗaamə uusəra ŋga ɗa tantanyitə əndzanə ŋga Pasəka agi *ŋwaŋuunə ŋga Əntaŋfə kə mbu'ya.” ");
INSERT INTO gde_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Wata Yeesu a luu kwalakə da ma'i inabi asəkəkii. Ca kuyirii tə Əntaŋfə. Ma daba'əkii, əŋki ci, “Ndamə kwalakəna, taa wu patə agyuunə, wa ca sa. ");
INSERT INTO gde_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Wanyinə ca ba koonə: ma daba'ə əna, paa nyi ka ənənə ka sa ma'i inabi ma'ə, see saa'itə nə Əntaŋfə a ɗa ŋwaŋuunaakii paŋgəraŋə.” ");
INSERT INTO gde_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Ma daba'əkii, ca ŋgərə buroodi, ca kuyirii tə Əntaŋfə, ca ɓaatsəpaa, ca vii ka masləkee ənjaakii, əŋki ci, “Ma əna, shishinəki cii kya vii ka putə goonə. Dəmə aakəŋwa də ɗanə ha'ə makə əna ka buurətəginə də nyi.” ");
INSERT INTO gde_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ha'ə əsə vii ci ka tii kwalaka da ma'i inabi asəkəkii daba'ə zəma. Əŋki ci, “Ma ətsa, ci nə kura aləkawalətə ci Əntaŋfə a ɗa də idənaaki. Ka putə goonə nə idənəkii a əjigi. ");
INSERT INTO gde_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","“Amma, wiinə əndə viinə tə nyi ka ənji ka zəmənə da nyi. ");
INSERT INTO gde_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Ma nyi *Uuzənə ŋga ənda, ka əntənə nə nyi tə əntənə, makə sətə uugi kəŋənə agyanəki, amma kə ɗii anə əndətə na vii tə nyi ka ənja!” ");
INSERT INTO gde_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Wata gwaŋənə nə lyawarənaakii ka laagwashinə ahadatii taa wu agitii ca mbee ka ɗanə ha'ə. ");
INSERT INTO gde_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Kə ma'i mabizhinə ahada masləkee ənji banə tuu'inə: wu saŋə nə gawə ahadatəya? ");
INSERT INTO gde_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","Fanə ŋga Yeesu ha'ə, wata əŋki ci ka tii, “Ma meeminə ŋga hara slikərənə, agi haŋətənə nə tii natii nə akəŋwacii ənjatii. Ha'ə nə gayinə əsə, agi moonə nə tii ənjə a 'wa tə tii ənji ɗa ŋga'əənə. ");
INSERT INTO gde_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","Amma ma unə, pooshi ka ɗanə ha'ə ahadoonə. Ma əndətə palee də gawuunə ahadoonə, wa ca ndzaanə makə dara. Ha'ə nə matakəŋwanə goonə əsə, wa ca ŋgərə slənə ŋga əndə sləna. ");
INSERT INTO gde_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Ya saŋə, wu palee də gawuuna, əndənə ca zəmə ku, anii əndənə ca slənə ka ca? Əntaa əndənə ca zəmə kwa? Ma nyi ɗiya, ma nə nyi ahadoonə, makə əndə sləna. ");
INSERT INTO gde_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","“Ma una, kə ndzaa unə da nyi taa guci patə agi ciɓənyinaaki. ");
INSERT INTO gde_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","Makə sətə vii Daadə ka nyi gawuunə, ma nyi əsə, wanyinə ka viinə koonə. ");
INSERT INTO gde_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","Ka zəmənə naamə, ka sanə naamə agi ŋwaŋuunaaki, una ndzaanə anə dəgələ ŋga ŋwaŋuunə, una ɗa gəŋwanə ka makuvə ŋga ənji *Isərayiila pu'u aji bəra'i.” ");
INSERT INTO gde_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Əŋki Yeesu, “Simoonə, Simoonə, aa ha nəhə. Kə upaa *Seetanə rəgwa ŋga kəca'ənə tuunə patə makə səkəŋwa. ");
INSERT INTO gde_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","Amma, ma nya, kə ɗii nyi də'wa ka putaaku, acii ga ha bwasee ka gi'inə tə nyi. Maɗa kə ənyatə hə aaɓiiki, tsakuu ŋgeerənə ka ndzəkəŋushi'inəku.” ");
INSERT INTO gde_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Əŋki Piita ka ci, “Slandanəkya, kə tasəkii nyi dzənə taa aa furəshinə da hə, taa kaa ənjə a ɓələgi taaŋwə əsə.” ");
INSERT INTO gde_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Əŋki Yeesu ka ci, “Piita, wanyinə ca ba ka hə: ma taabu'u wanə gyaagya ənshinə, ka jikənə nə hə makkə ka hiweenə ka shiinə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Əŋki Yeesu ka lyawarənaakii əsə, “Ya makə sləkee nyi koonə yadə kwaɓa taa mbuurə taa əndə'i ɓiɓina, tə'i uushi ətee unə kwa?” Əŋki tii ka ci, “Pooshi taa mi ətee inə.” ");
INSERT INTO gde_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Wata əŋki Yeesu ka tii, “Amma, ma ənə ɗii ca, əntaa ha'ə. Maɗa tə'i kwaɓa ŋga ənda, wa ca ŋgərəənə. Ha'ə əsə, maɗa tə'i mbuurə ŋga ənda, wa ca ŋgərəənə. Maɗa pooshi ŋgila purəŋanə ŋga ənda, wa ca ɗərəmagi də kəjeerənaakii kaa ca ɗərəciigi. ");
INSERT INTO gde_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Acii wanyinə ca ba koonə: ma bii malaaɓa ləkaləkatə, ‘Kə ɗii ənji də ci makə sətə ci ənjə a ɗa də məza ənja.’ Ma ətsa, agyanəki na ɗa ha'ə. Waatoo, ma sətə uugi kəŋənə agyanəkya, wiinə ka ɗanə.” ");
INSERT INTO gde_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Wata əŋki lyawarənaakii ka ci, “Slandana, wiinə ŋgila purəŋanə ganə bəra'i.” Əŋki ci ka tii, “Bwaseemə ha'ə.” ");
INSERT INTO gde_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Ma daba'əkii, kə gimagi Yeesu, ca palə aashi giŋwə ŋga Zayitunə makə sətə izee ci ka ɗanə. Kə nyi'u lyawarənaakii tə ci aa dəvə. ");
INSERT INTO gde_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Makə mbu'i tii aa dəvə, əŋki ci ka tii, “Ɗamə də'wa acii goona bwasee ka rəgwa ŋga Əntaŋfə saa'itə nə *Seetanə a təɓə tuunə.” ");
INSERT INTO gde_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Wata ca əntsahə ba'ə gi'u, ca gərə'waanə, ca ndzaŋə ɗa də'wa, ");
INSERT INTO gde_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","əŋki ci: “Daadə, maɗa ka moonə nə hə, əntsahee ka nyi ka ciɓətsə akəŋwaciikii. Amma, ɗawə sətə kaɗeesəkə ka hə, ga ha ɗa sətə kaɗeesəkə ka nyi.”  ");
INSERT INTO gde_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Wata malaa'ika a jima dadagyə, ca shi ka tsakə ka ci ŋgeerənə. ");
INSERT INTO gde_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Kə əjigi ma'yanə ŋga Yeesu, wata ca ənə ka ɗa gazhi'waanə ŋga ɗa də'wa palee ka əta. Lyaavanə nə hacifaakii aa panə makə idəna. ");
INSERT INTO gde_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Makə uudəpaa ci ɗa də'wa, ca maɗə, ca palə aaɓii lyawarənaakii. Ma dzənəkəya, ka ŋunyinə nə tii, acii kə dzəgəpaa ŋgəra'wə tə tii. ");
INSERT INTO gde_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Əŋki ci ka tii, “Iitə ɗii səkii cuuna tsəfə ŋunyina? Maɗətəmə, ɗamə də'wa, acii goona bwasee ka rəgwa ŋga Əntaŋfə saa'itə nə Seetanə a təɓə tuunə.” ");
INSERT INTO gde_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Daga Yeesu ma'ə ma'uudəpaamə waɓənə, wata kə jigagi ənji dzuɓə. Yahuda, ətə agi lyawarənə ŋga Yeesu pu'u aji bəra'i, nəndə ka takəŋwanə ka tii. Ca əntsahətə aaɓii Yeesu ka nəhəpaanə tə ci ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Əŋki Yeesu ka ci, “Yahuda, dagi nəhəpaanə viinəku tə nyi Uuzənə ŋga əndə ka ənji nii?” ");
INSERT INTO gde_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Makə nee ənjitə aɓii Yeesu ka sətə ca moo ɗanə, əŋki tii ka ci: “Slandaniina, a buuriinə tə tii də ŋgila purəŋanə kwa?” ");
INSERT INTO gde_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Wata əndə'i əndə agitii a burəgi liminə ŋga mava ŋga gawə ŋga limanyinə də ŋgila purəŋanə. Ɓutə nə liminə da ciizəma. ");
INSERT INTO gde_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Amma əŋki Yeesu, “Bwaseemə. Goona ɗa ha'ə!” Wata ca ŋgərə liminə ŋga əndətə, ca nyiɓutə. ");
INSERT INTO gde_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Ma daba'əkii, Yeesu a waɓə ka ənjitə shi ka kəsənə tə ci, waatoo ka madiigərə limanyinə da meeminə ŋga soojiitə ca nəhə yi ŋga Əntaŋfə, da ka masariinə; əŋki ci, “Mi shuunə ka kəsənə tə nyi ka ŋgila purəŋanə ka ŋgila purəŋanə, ka zala ka zala kwa? Ya saŋə əndə ɗa maabə nə nyi kwa? ");
INSERT INTO gde_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Uusəra patə njaama ndzaanə ka hakii asəkə *yi ŋga Əntaŋfə, patə da ha'ə pooshi unə kəshi tə nyi. Amma, ma ənə ɗii ca, kə mbu'ya uusəra goonə da baawəɗa ŋga ŋwaŋuutə agi təkunə.” ");
INSERT INTO gde_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Ma daba'əkii, kə kəsətə tii tə Yeesu, təya kərə tə ci aasii aa ha gawə ŋga limanyinə. Piita əsa, ba'ə ba'ə nə ci ka nə'unə tə tii. ");
INSERT INTO gde_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Kə hənəpaa ənji gunə a maɓaraci. Mbu'unatii, təya ndzaanə ka 'utənə. Shinə ŋga Piita əsə, ca ndzaa dasə aɓitii. ");
INSERT INTO gde_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Ma davə asii, tə'i kadəmə ca slənə kwaɓa. Makə nee ki ka Piita ama gunə, kya tsaamətə tə ci, əŋki ki, “Əndənə maa, rəŋwə nə ci agi ənji ŋga Yeesu.” ");
INSERT INTO gde_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Amma, ma Piita, kə hiwee ci, əŋki ci, “Mina, mashiimə nyi tə əndətsa.” ");
INSERT INTO gde_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Ma ta'avə gi'u, kə nee əndə'i əndə ka ci. Əŋki ci, “Hə maa, əndə ŋga Yeesu nə hə!” Əŋki Piita ka əndəta, “Əntaa əndaakii nə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Ma ta'avə gi'u əsa, əndə'i əndə a kəŋaanə agyanə waɓənə ŋga əndəta, ca ba, “Gooŋga tanyi, ma əndətsa, əndə ŋga Yeesu nə ci, acii əndə Galili nə ci.” ");
INSERT INTO gde_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Wata əŋki Piita ka əndətə əsə, “Paa nyi shii sətsə cii kwa ba.” Daga ci ma'ə ma'uudəpaamə banə ha'ə, wata ga'ə kə wii gyaagya. ");
INSERT INTO gde_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Zə'uginə nə Yeesu Slandanə aadəɓii Piita, ca tsaamə tə ci. Wata Piita a buurətə sətə shi Slandanə a bii ka ci oo'i, “Ma taabu'u wanə gyaagya ənshinə, ka jikənə nə hə makkə ka hiweenə ka shiinə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Buurətənaakii ha'ə, ca dzə də tuunə də kiinə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Ma saa'ikii, ənjitə nja nəhə tə Yeesu a ha'u də ci, təya dəgə tə ci, ");
INSERT INTO gde_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","təya vutəgi ginəkii, təya tsa ka ci meeciinə, əŋki tii ka ci: “Makə ɗii ci anabi nə hə, kuragi keenə taa wu digə tə hə!” ");
INSERT INTO gde_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Kə baabii tii hara uushi'inə ŋgaaŋga'ə ŋga dzaananə də ci. ");
INSERT INTO gde_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Pukənə ŋga ha, wata *gayinə ŋga Yahudiinə da madiigərə limanyinə da maliminə a dza də nə ka ɗa mətərəkinə. Əŋki tii, wa ənjə a kira ka tii tə Yeesu aa kuvə gəŋwanə. ");
INSERT INTO gde_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","Mbu'unaakii wata təya ləgwa ka ci, əŋki tii, “Bawə keenə maɗa hə nə *Aləmasiihu.” Əŋki Yeesu ka tii, “Taa kə bii nyi koonə, paa unə ka luuvənə. ");
INSERT INTO gde_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Maɗa kə ləguyi nyi uushi a moonə əsə, paa unə ka jikəvənə. ");
INSERT INTO gde_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","Amma, ma aakəŋwa gi'u, ka ndzaanə nə nyi, nyi Uuzənə ŋga ənda, a ciizəmə Əntaŋfə Əndə baawəɗa.” ");
INSERT INTO gde_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Wata əŋki tii patə, “Hə nə *Uuzənə ŋga Əntaŋfə ənə nii?” Əŋki ci ka tii, “Unəkii maa, ha'ə bii unə.” ");
INSERT INTO gde_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Wata əŋki tii ahadatii, “Tə'i uushi dəɓee ama ləgwa ama əndə ma'ə kwa? Aməkii maa, kə fii amə səndə bii ci də makii.” ");
INSERT INTO gde_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Wata gayiitə patə a maɗətə, təya kərə tə Yeesu aakəŋwacii Pilaatu. ");
INSERT INTO gde_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Mbu'unatii, wata təya gwaŋə ka baaba uushi'inə ashikii. Əŋki tii: “Kə lapaa inə əndənə ka ɗa rəgwa ŋga ŋusləginə də slikərənə geenə, inə *Yahudiinə. Agi banə nə ci, ga ənjə a vii tsəkə ma'ə ka maɗuunə ŋwaŋwə ŋga ha də Rooma. Agi banə nə ci əsə, ci nə Aləmasiihu, waatoo ŋwaŋwa.” ");
INSERT INTO gde_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Əŋki Pilaatu ka Yeesu, “Hə nə ŋwaŋwə ŋga Yahudiinə kwa?” Əŋki Yeesu ka ci, “Hə bagi ha'ə.” ");
INSERT INTO gde_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Əŋki Pilaatu ka madiigərə limanyinə da daɓaala, “Ma nee nyi naakya, pooshi bwaya uushi ashi əndəna.” ");
INSERT INTO gde_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Amma kə cakə ənjitə ɗa macavaɗaanə də baaba uushi'inə ashi Yeesu, “Agi ɗeeginə nə ci ka ənji ka purətə haŋkaliinə də dzəgunənaakii. Anə hanyinə ŋga Galili 'watəgi ci ɗanə ha'ə, ca shi aanə hanyinə ŋga Yahudiya. Waanə kə mbu'ya aa hanə əsə.” ");
INSERT INTO gde_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Makə fii Pilaatu ha'ə, ca ləgwa, “Ya əndətsa, əndə Galili nə ci kwa?” ");
INSERT INTO gde_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Makə fii ci oo'i, əndə Galili nə Yeesu, waatoo hanyinə ŋga ŋwaŋwə Hirudusə, wata ca ba, wa ənjə a kərə tə ci aakəŋwacii ŋwaŋwə Hirudusə. Ma uusərakii, də Urusaliima nə Hirudusə. ");
INSERT INTO gde_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Makə nee ci ka Yeesu, kə ɗii ci mooɗasəkə laŋə. Kə mwayi ci neenə ka ci daga ŋukə, acii kə fii ci habaraakii, kə mwayi ci neenə ka ɗa sə ŋga hurəshishinaakii. ");
INSERT INTO gde_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Wata ca gwaŋə ka laagwa uushi'inə ɓəzəkii a makii. Amma pooshi uushi jikə Yeesu ka ci. ");
INSERT INTO gde_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Davə nə madiigərə limanyinə da maliminə, də bwaya ŋguruunə nə tii ka wulanə tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Kə ha'u i Hirudusə da soojiinaakii də ci, kə bərapaa tii tə ci. Təya kavə ka ci ŋunyi kəbənə aashikii. Ma daba'əkii, Hirudusə a ba ka ənjə a ənəpaagi də Yeesu ka Pilaatu. ");
INSERT INTO gde_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Uusərakii njaŋə i Hirudusə da Pilaatu guvaanə, acii ma ŋga ŋukə tə'i daawaanə ahadatii. ");
INSERT INTO gde_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Wata ŋgwaməna Pilaatu a dzatəgi də madiigərə limanyinə da matakəŋwanyinə da hara Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","Əŋki ci ka tii, “Wiina, kə kiroonə ka nyi əndəna. Kə bii unə: agi gwazeenə nə ci ka ənja. Wiinə ɗii, akəŋwacii unə ndzaa nyi ka ətsətə haalaakii. Amma ma nyi, ma agi wulanə goonə tə ci, pooshi uushi idəpaa nyi ashikii. ");
INSERT INTO gde_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Ha'ə nə Hirudusə əsə. Makə kə nee amə, kə ənyapaagi ci də ci kaamə, ci ɓaarii pooshi uushi idəpaa ci ashikii. Acii ha'ə, ma nee nyi, pooshi bwaya uushi ɗii ci bahə ɓələnə tə ci. ");
INSERT INTO gde_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Ma ɗiya, wa ənjə a fəsləcii tə ci. Ma daba'əkii, ənjə a kapaa tə ci.”  ");
INSERT INTO gde_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","Yoo, taa agi ŋgutə kumənə ŋga *Pasəka patə, kə ndzaa tyasə see a kapaa Pilaatu əndə furəshinə rəŋwə ka ənja. ");
INSERT INTO gde_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","Wata ənji patə a gwaŋə ka waazənə, əŋki tii, “Kyapaa keenə tə Barabasə, ənjə a ɓələgi əndətsa!” ");
INSERT INTO gde_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Ma Barabasə, kə gimə ci furəshinə putə ŋga maɗee ka nə ŋga ənji asəkə vəranə da ɓələ ənda. ");
INSERT INTO gde_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Makə kə mwayi Pilaatu kapaanə tə Yeesu, wata ca ənə ka waɓənə da ənja. ");
INSERT INTO gde_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","Amma, ma təya, kə wazəənə tii, əŋki tii, “Wa ənjə a gwa'avə tə ci aashi ənfwa! Wa ənjə a gwa'avə tə ci aashi ənfwa!” ");
INSERT INTO gde_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Amma əŋki Pilaatu ka tii ka makkənə, “Mi nə bwaya uushi ɗii ci kwa? Pooshi uushi idəpaa nyi ashi əndətsə bahə ɓələnə tə ci. Wa ənjə a fəsləcii tə ci, ənjə a kapaa tə ca.” ");
INSERT INTO gde_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Amma, ma təya, kə wazəənə tii də ŋgeerənə, təya dzə də banə, wa ənjə a gwa'avə tə ci aashi ənfwa. Də ha'ə hwaməpaa tii tə Pilaatu. ");
INSERT INTO gde_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","Wata Pilaatu a lagi ka ci gəŋwanə makə sətə mwayi tii. ");
INSERT INTO gde_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","Ca kapaa ka tii tə əndətə mwayi tii, waatoo tə əndətə gimə furəshinə putə ŋga maɗee ka nə ŋga ənji asəkə vəranə da ɓələ ənda. Ca ŋgərə tə Yeesu, ca vii ka tii kaa təya ɗa də ci də sətə mwayi tii. ");
INSERT INTO gde_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Ma ənjə a kərə tə Yeesu ka ɓələginə, kə lapaa tii əndə'i əndə ɗii ləməkii Simoonə. Ma ca, əndə Sirina nə ci. Kə lapaa tii tə ci, ci ka ha ŋga shinə də bilə. Təya kəsə tə ci, təya ŋgərəvə ka ci ənfwə ŋga gwa'avənə tə Yeesu aashikii, ca nə'u də tii. ");
INSERT INTO gde_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Daɓaala a dzə də nə'unə tə Yeesu. Tə'i makinə əsə nja kaala vurənə, təya tuutuu atsakii. ");
INSERT INTO gde_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Zə'uginə nə Yeesu aadəɓitii, əŋki ci ka tii, “Ma unə, maki Urusaliima, uneemə ka tuunə atsaki. Amma, ma nə uushi ɗanuunə, tuumə agyanə noonə na, da agyanə manjeevənə goonə. ");
INSERT INTO gde_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Acii tə'i uusəra na mbu'ya, ətə nə ənjə a ba, tə'i barəkaanə agyanə masaawiinə ətə mapoomə, ətə masamə 'wanə ka manjeevənə. ");
INSERT INTO gde_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Uusərakii nə ənjə a ndzaŋə banə ka giŋunyinə: ‘Waalyaanəmə keenə!’ Ka banə nə ənji ka daŋgərənyinə əsə: ‘Ŋgəəɗəgimə tiinə!’ ");
INSERT INTO gde_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Ya maɗa kə ɗii ənji də kantə'wa ənfwə ha'a, iitə na uudəənə ka mahuurəkəya?” ");
INSERT INTO gde_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Tə'i hara ənji bəra'i; ma təya, ənji maabə nə tii. Kə kirə ənji tə tii ka dzənə ka ɓəələginə tə tii ka ciinə rəŋwə da Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Mbu'unatii ka hatə ci ənjə a gwa'avə ənji aashi ənfwa, waatoo hatə ci ənjə a 'wa “Kəŋwə na”, wata soojiinə a gwa'avə tə Yeesu aashi ənfwa. Təya gwa'avə tə ənji maabətə bəra'i əsə, rəŋwə da ciizəmə Yeesu, rəŋwə da madzənakii. ");
INSERT INTO gde_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Wata əŋki Yeesu, “Daada, tifyagi tə tii, acii mashiimə tii sətsə ci təya ɗa.” Kə təkəpaa soojiinə kəjeerənaakii ahadatii də kwaaranə. ");
INSERT INTO gde_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Ənji patə, kə kəŋaanə tii ka tsaamə sətə ca ɗaaɗa. Ma gayinə ŋga Yahudiinə, kə ha'u tii də Yeesu, əŋki tii, “Kə mbee ci ka luupaa tə hara ənja. Maɗa ci nə Aləmasiihu əndətə ta'i Əntaŋfə, wa ca luupaa naakii na!” ");
INSERT INTO gde_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Soojiinə maa, kə ha'u tii də ci. Təya əntsahətə aaɓiikii kaa təya vii ka ci mahwarəkinə. ");
INSERT INTO gde_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Əŋki tii, “Maɗa ŋwaŋwə ŋga Yahudiinə nə hə tanyi, luupaa naaku na!” ");
INSERT INTO gde_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Tə'i manaahəkii əsə ashi ənfutə gwa'avə ənji tə Yeesu aashikii oo'i, “Ma əndəna, ci nə ŋwaŋwə ŋga Yahudiinə.” ");
INSERT INTO gde_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Wata əndə'i əndə agi ənjitə gwa'avə ənji tə tii a dzaana tə Yeesu. Əŋki ci, “Əntaa kə bii hə oo'i, hə nə Aləmasiihu? Aa luupaa naaku nə, ha luupaa tiina!” ");
INSERT INTO gde_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Amma, makə fii əndə'i əndətə ha'ə, kə lii ci ka ci ŋguruunə, əŋki ci, “Ya ha, əntaa gəŋwanə rəŋwə lagi ənji kaama? Paa hə ka ŋgwalənə acii Əntaŋfə kwa? ");
INSERT INTO gde_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","Ma kaaŋwə, madəɓəkii nə gəŋwaana, acii ma sətə ɗii aŋwə, anəkii lii ənji kaaŋwə gəŋwanə. Amma, ma əndətsa, pooshi taa mi ɗii ci ətə madzəmə.” ");
INSERT INTO gde_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Wata əŋki ci ka Yeesu, “Yeesu, aa ha buurətə tə nyi uusəratə nii kwa ɗa ŋwaŋuunaaku.” ");
INSERT INTO gde_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Əŋki Yeesu ka ci, “Tantanyinə cii kya ba ka hə: ənshinə ndzaanaaŋwə agi Aləjana.” ");
INSERT INTO gde_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ma ətsə uusəra ahada na, wata kə bwasee uusəra ka ɓərənə. Kə ɗii təkunə anə hanyinəkii patə dəgwamə, ha'ə ɗii tibisə makkə ŋga kədəwanə. Tə'i gwada wahə ama hatə palee də laaɓanə asəkə *yi ŋga Əntaŋfə. Wata pyaahu! gwadatə a təkəgi bəra'i. ");
INSERT INTO gde_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Kanə nə Yeesu vurənə də ŋgeerənə, əŋki ci, “'Ya'ə Daada, aasəkə ciiku nə nyi ka ba'avə ma'yanaaki.” Baginaakii ha'ə, wata ca əntəgi. ");
INSERT INTO gde_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Neenə ŋga ŋwaŋwə ŋga soojiitə nji davə ka sətə ɗaaɗii patə, wata ca dəla də Əntaŋfə, əŋki ci, “Asee gooŋga tanyi, ma əndəna, pooshi sə ŋga idəpaanə ashikii.” ");
INSERT INTO gde_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Patənə ŋga daɓaala ətə shi ka tsaamə sətə ca ɗa, makə nee tii, kə ənyi tii satii də dəəgə ədzəmətii acii təgunuunə. ");
INSERT INTO gde_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Patənə ŋga guviinə ŋga Yeesu da makiitə nyi'wa tə ci daga anə hanyinə ŋga Galili, kə kəŋaanə tii dzaɗə gi'u ka tsaamə sətə ca ɗa. ");
INSERT INTO gde_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","Tə'i əndə'i əndə ɗii ləməkii Yusufu, əndə Arimatiya anə hanyinə ŋga Yahudiita. Ma ca, ŋunyi əndə nə ci, əndə gooŋga əsə. Rəŋwə nə ci agi *mətərəkinə ŋga Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","Amma, madzəmə ka ci nə sətə ɗii hara gayinə, waatoo aniyatii da slənətsatii. Acii ma ci, bislyə nə ci agi gəra saa'itə nə Əntaŋfə a ɗa ŋwaŋuunaakii. ");
INSERT INTO gde_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Wata ca maɗə, ca palə aa ha ŋgwaməna Pilaatu kaa ca kədii rəgwa kaa ca dzə ka ŋgiragərə wə ŋga Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Makə luuvə Pilaatu ka ci, wata ca dzə ka jimagərə də wə ŋga Yeesu ashi ənfwa. Ca haɗətə tə ci də marəma, ca banee ka ci asəkə kura gu'u ətə tələpaa ənji ashi pasla. ");
INSERT INTO gde_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Ma ɗii ətsə patə, uusəra ŋga ndzaŋə *uusərə ŋga əpisəka. ");
INSERT INTO gde_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Ma makiitə nyi'wa tə Yeesu daga anə hanyinə ŋga Galili, kə gi tii atsaa Yusufu. Kə tsaaməgərə tii aasəkə gu'wə, təya nee taa iitə banee ci ka Yeesu. ");
INSERT INTO gde_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ma daba'əkii, təya ənəgərə aasəkə vəranə. Təya da maarə ətə ɗii zənəkii ŋga'ə da urədya ka ɓəzəpaanə də wə ŋga Yeesu. Ma uusəra asavee, kə əpi tii səkə makə sətə bii *bariya. ");
INSERT INTO gde_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Ma tsəɗakə uusəra alatə, kə ma'i makiita, təya ŋgərəənə maarətə dii tii, təya dzə aa ma gu'u. ");
INSERT INTO gde_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ma gi təya, kə dalagi ənji faaratə pya'ə ənji də ma ŋga gu'ukii. ");
INSERT INTO gde_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","Ma təya dəməgərə, wata malapaamə tii wə ŋga Yeesu Slandana. ");
INSERT INTO gde_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Kə pa'əənə ka tii ma, pooshi tii shii sə ŋga banə. Ma təya nee, kə jigagi ŋguyirənə bəra'i da i kəjeerənə ca ɓərə ashitii. ");
INSERT INTO gde_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Wata ŋgwalənə a kəsəgi tə tii, təya gwaŋee ka nətii aa panə aa panə. Əŋki ŋguyiriitə ka tii, “Mi cuuna aalə Əndə vii əpinə agi maməətə ənji kwa? ");
INSERT INTO gde_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","Ma ca, kə ma'i ci, paa ci ma'ə ganə. Buurətəmə sətə bii ci koonə, ci ma'ə anə hanyinə ŋga Galili. ");
INSERT INTO gde_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Kə bii ci koonə, ma ca, *Uuzənə ŋga ənda, tyasə ka viinə nə ənji tə ci ka ma'waslyakə ənja; ənjə a gwa'avə tə ci aashi ənfwa, ca əntə, ca maɗətə agi maməətə ənji ka makkənə ŋga uusəra.” ");
INSERT INTO gde_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Wata pii makiitə a buurətə waɓəətə ŋga Yeesu, ");
INSERT INTO gde_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","təya maɗə gatə a ma gu'u, təya dzə ka dzəgunəgi ətsə patə ka *lyawarənə ŋga Yeesu pu'u aməntaŋə da i ka hara ənjitə nja nə'u tə ci. ");
INSERT INTO gde_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Ma makiitsə ɗii ha'ə, tii nə Mariyaama Magədalina, Yawana, da Mariyaama məci Yakubu da hara makinə. Tii bii sətsə ha'ə ka masləkee ənja. ");
INSERT INTO gde_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Amma, ma masləkee ənja, kə ŋgirə tii waɓənə ŋga makiitsə ka uushi zaɓə, pooshi tii luuvə. ");
INSERT INTO gde_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Patə da ha'ə, ma Piita, kə ma'i ci, ca huyipaa aanə gu'wa. Ca gwaŋaanə ka riŋgəɗənə. Ma ca nee, wata kəjeerənə mbəɗaanə. Kə ɗii ka ci ka sə ŋga hurəshishinə. Ca palə saakii. ");
INSERT INTO gde_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Uusərakii ha'ə, *lyawarənə ŋga Yeesu bəra'i a dzə aasəkə əndə'i vəranə ɗii ləməkii Imawusə. Kiloomeeta pu'u aməntaŋə nəndə ahada vəranəkii da vəranə ŋga Urusaliima. ");
INSERT INTO gde_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","Təya dzə də waɓə haala ŋga sətə ɗaaɗii patə. ");
INSERT INTO gde_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","Asee, ma saa'itə təya waɓə ha'ə, kə lapaa Yeesu də naakii nə tə tii. Nə'ushinə nə tii da ci. ");
INSERT INTO gde_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Agi neenə nə tii ka ci, amma pooshi tii puləgi oo'i, ci. ");
INSERT INTO gde_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Əŋki Yeesu ka tii, “Mi cuuna dzə də waɓənə ahadoonə, una dzə də wiina?” Wata təya kəŋaanə. Kə dzəgəpaa maɓətəsəkə tə tii. ");
INSERT INTO gde_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Tə'i əndə'i əndə agitii ətə ɗii ləməkii Kəliyapasə. Əŋki ci ka Yeesu, “Patənə ŋga ənji də Urusaliima, kə shii tii sətə ɗaaɗii davə kwakwatə. Yoo, wata hə daanəku nə mu'umə ətə mashiimə nii?” ");
INSERT INTO gde_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Əŋki Yeesu ka tii, “Ŋgutə uusha?” Əŋki tii ka ci, “Ya sətə ɗii tə Yeesu əndə Nazaratu. Ma ca, anabi nji ci, əndə baawəɗa ka rəgwa sləna da rəgwa waɓənə akəŋwacii Əntaŋfə da akəŋwacii ənji patə. ");
INSERT INTO gde_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Kə vii madiigərə limanyinə da matakəŋwanyinə geenə tə ci ka ənja, kaa təya ɗa gəŋwanə ŋga ɓələnə tə ci. Təya gwa'avə tə ci aashi ənfwa. ");
INSERT INTO gde_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Ma ina, kə kii inə niinə oo'i, ci nə əndətə nja dzə ka luupaanə tə ənji *Isərayiila. Amma wiinə ɗii, makkənə ŋga uusəra ənshinə makə ɗaaɗii uushi'iitsa. ");
INSERT INTO gde_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Ha'ə maa, tə'i hara makinə ahadeenə kəɗəpaa tiinə. Acii ma ənshinə pədeerənə tsəɗaka, kə wuuri tii aanə gu'u. ");
INSERT INTO gde_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","Ma dzənətii, malapaamə tii wə ŋga Yeesu davə. Wata təya shi ka banə keenə oo'i, kə shigi malaa'ikanyinə ka tii; təya ba ka tii oo'i, da i əpinə nə ci. ");
INSERT INTO gde_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Tə'i hara ənji əsə ahadeenə gi aanə gu'u, təya lapaa ha'ə tanyi makə sətə bii makiita. Amma paa tii nee ka ci.” ");
INSERT INTO gde_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Wata əŋki Yeesu ka tii, “Una, pooshi nuunə! Malyaɓatanyinə nuunə ka rəgwa ŋga luuvə sətə waɓi anabiinə patə. ");
INSERT INTO gde_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Madəɓeemə *Aləmasiihu a ciɓə makə ətsə, kaa Əntaŋfə a vii ka ci ɗuunuunə kwa?” ");
INSERT INTO gde_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Wata ca ndzaŋə dzəgunətə ka tii sətə bii malaaɓa ləkaləkatə agyanə naakii na. Waatoo, ndzaŋənə asəkə ləkaləkatənyinə ŋga Muusa, ca uudəpaa də ŋga anabiinə patə. ");
INSERT INTO gde_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Makə mbu'i tii kədəhə da vəraatə ci lyawariitə bəra'i a dzə aa dəvə, ɗanə nə Yeesu makə pitəginə aakəŋwa. ");
INSERT INTO gde_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","Amma təya kəsəpaa tə ci, əŋki tii, “Baa amə ganə, acii kə uugi kədəwanə ɗanə, wiinə vəɗə ka ɗanə.” Wata Yeesu a dəməgərə atsatii. ");
INSERT INTO gde_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Təya ndzaanə ka zəma. Ca ŋgərə buroodi, ca kuyirii tə Əntaŋfə, ca ɓaatsəpaa, ca vii ka tii. ");
INSERT INTO gde_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","Wata kə dzəgi sətə səməɗəgi ginətii, təya puləgi də ci. Amma kə rarə'igi ci akəŋwaciitii. ");
INSERT INTO gde_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","Əŋki tii ahadatii, “Ya makə njii kəya waɓə kaaŋwə a rəgwa, ca dzəgunətə kaaŋwə agyanə sətə bii malaaɓa ləkaləkatə, əntaa kə njaaŋwa fa shiiwə asəkə ədzəmaaŋwə kwa?” ");
INSERT INTO gde_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","Wata təya maɗətə ka tsaakii ha'ə, təya ənəgərə aa Urusaliima. Mbu'unatii, təya lapaa tə lyawarənə ŋga Yeesu pu'u aməntaŋə da hara ənjitə aɓitii. ");
INSERT INTO gde_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Neenatii ka lyawariitə bəra'i, wata əŋki tii ka tii, “Gooŋga tanyi! Kə ma'i Yeesu Slandanə agi maməətə ənja. Kə shigi ci ka Simoonə.” ");
INSERT INTO gde_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Fanatii ha'ə, wata təya ndzaŋə dzəgunə ka tii sətə ɗaaɗii a rəgwa, i makə sətə puləgi tii də Yeesu, ci ka ha ŋga ɓaatsəpaa buroodi. ");
INSERT INTO gde_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Tii ma'ə ka waɓənə ha'ə, ma nee tii, kəŋə nə Yeesu də naakii nə ahadatii. Əŋki ci ka tii, “Wa jamənə a ndzaanə ahadoonə!” ");
INSERT INTO gde_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Kə ŋgwali tii, kə li'i ma'yanatii. Acii ma nə tii ka nəhənə, ɓərəhinə shigərə aagitii. ");
INSERT INTO gde_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Wata əŋki Yeesu ka tii, “Mi li'i ma'yanə goona? Ka mi də hiimatsə ha'ə a nuuna? ");
INSERT INTO gde_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Tsaamətəmə ciinəki da səɗəki. Də ha'ə shiinuunə oo'i, nyi ənə weewee. Ma ɗanuuna, ndaaɓətəmə tə nyi, tsaamətəmə tə nyi koona shii. Ma ɓərəhinə kamə, pooshi luwə ashikii, pooshi ilə əsə makə səndə cuuna nee ashiki.” ");
INSERT INTO gde_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Ma ca dzə də waɓənə ha'ə, ca ɓaarii ka tii ciinəkii da səɗəkii. ");
INSERT INTO gde_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Kə ɗii lyawarənə mooɗasəkə laŋə. Kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə. Ha'ə maa, ma'ə tii mambeemə ka luuvənə. Əŋki Yeesu ka tii, “Tə'i unə da zəmə kwa?” ");
INSERT INTO gde_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","Wata təya ŋgərə masəərə hərəfinə, təya vii ka ci. ");
INSERT INTO gde_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Ca ŋgərə hərəfiitə, ca adə, ginətii a nee. ");
INSERT INTO gde_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Ma daba'əkii, əŋki Yeesu ka tii, “Wiinə sətə njii kya baaba koonə, nyi ma'ə ahadoonə: kə dəɓee sətə nyaahə ənji agyanəki patə a ɗa, waatoo, sətə asəkə bariya ŋga Muusa, da asəkə ləkaləkatənyinə ŋga anabiinə da asəkə Jabuura əsə.” ");
INSERT INTO gde_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Wata Yeesu a wunəgi nətii kaa təya mbee ka paaratə sətə asəkə ləkaləkatəkii. ");
INSERT INTO gde_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","Əŋki ci ka tii, “Wiinə sətə nyaahə ənji agyanəki: tyasə see a ciɓə Aləmasiihu, ca əntə. Ma ka makkənə ŋga uusəra, ca maɗətə agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Ma daba'əkii, ənjə a waaza ka ənji agyanə baanə ka Əntaŋfə da upaa tifyaginə ŋga 'waslyakəənə. Ma waazaatsa, də Urusaliima ca ndzaŋə, ca mbu'u ka patənə ŋga ənji agi duuniya. ");
INSERT INTO gde_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Unə nə seedawiinə ŋga uushi'iitsa. ");
INSERT INTO gde_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Ma sətə bii Daadə viinə koonə, ka sləkeenə nə nyi koonə. Amma ndzaamə ganə asəkə vəranə zəku'i see maɗa jima baawəɗa koonə dadagyə.” ");
INSERT INTO gde_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Ma daba'əkii, wata ca fəɗə tə lyawarənaakii, təya palə aaba'ə vəranə kədəhə da vəranə ŋga Bayitaniya. Mbu'unatii, wata ca maɗee ka ciinəkii kaa ca ɗaanə ka tii barəkaanə. ");
INSERT INTO gde_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Ma ca dzə də ɗa ka tii barəkaanə, wata kə təkəgi ci da tii ha'ə, ca ndərəgi aadəgyə. ");
INSERT INTO gde_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Ma təya, kə gərə'waanə tii ka ɗuunətənə tə ci. Ma daba'əkii, wata təya maɗə, təya ənəgərə aa Urusaliima də maŋushinə. ");
INSERT INTO gde_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Uusərə patə nji təya dəla də Əntaŋfə asəkə yaakii.");
INSERT INTO gde_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","'Watəginə duuniya ma'ə matagamə, tə'i waɓənə. Ma waɓənəkii, tii da Əntaŋfə nji ka hakii. Əntaŋfə nə ci. ");
INSERT INTO gde_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","Ndzaŋənə ka 'watəginə nə waɓənəkii da Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Daciikii tagii Əntaŋfə patənə ŋga uushi'inə, taa rəŋwə pooshi uushi tagii Əntaŋfə yadə ciinəkii agikii. ");
INSERT INTO gde_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Waɓənəkii ca vii əpinə. Ma əpinəkii, ci ca kira ɓərənə ka ənji shiŋkinə. ");
INSERT INTO gde_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Ma ɓərənəkii əsə, agi təkunə nə ci ka ɓərənə, pooshi təkunə da baawəɗa ŋga ɓələgi ɓərənəkii. ");
INSERT INTO gde_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","Tə'i əndə'i əndə sləkee Əntaŋfə ka ci kaa ca slənə ka ci, ətə ɗii ləməkii Yoohana. ");
INSERT INTO gde_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","Ci shi ka seedaginə ka ənji agyanə ɓərənəkii kaa patənə ŋga ənjə a fa habarakii, təya luuvə. ");
INSERT INTO gde_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Əntaa ci də nəkii nə ɓərənəkii, amma ma shi ci, kaa ca shi ka ɓaarənə ka ənji agyanə ɓərənəkii. ");
INSERT INTO gde_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Ma ɓərənəkii, ci nə tantanyitə ɓərənə. Kə shi ci aa duuniya, kaa ca shii ɓərənə ka patənə ŋga ənji shiŋkinə. ");
INSERT INTO gde_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Asəkə duuniya nji waɓənəkii. Daciikii əsə tagii Əntaŋfə duuniya, amma patə da ha'ə, pooshi *duuniya shii tə ci. ");
INSERT INTO gde_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Aagi ənjaakii shi ci, amma ma təya, pooshi tii liwə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Ma ənjitə liwə tə ci, təya vii gooŋga ka ləməkii, kə vii ci ka tii baawəɗa ŋga ndzaanə ka manjeevənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ma təya, Əntaŋfə ci saakii vii ka tii əpinə, əntaa dagi shishinə ŋga əndə shiŋkinə saakii, taa dagi aniya ŋga əndə shiŋkinə əsə. ");
INSERT INTO gde_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Ma waɓənəkii, kə ndzaa ci ka əndə shiŋkinə, ca ndzaanə ahadaamə. Kə nee inə ka ɗuunuunaakii, waatoo, ətə vii Dii ka Uuzənaakii rəŋwə dyaŋə. Tə'i ci da pwapoonə da gooŋga ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Ma Yoohana, kə waɓi ci agyanəkii, ca ŋgəree ka uurakii, əŋki ci: “Waatsə əndətə njii kya ba: ma əndətə na uugya ba'ə ka shinə, kə palee ci ka nyi, acii daga ka 'watəginə nə ci.” ");
INSERT INTO gde_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Anəkii anəkii nə waɓənəkii ka ɗa kaamə pwapoonə. Agi malaŋə ŋga'əənaakii ənə cii kəya ɗa kaamə. ");
INSERT INTO gde_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Ma vii Əntaŋfə bariya, dacii Muusa. Amma ma pwapoonə da gooŋgaanə, dacii Yeesu *Aləmasiihu. ");
INSERT INTO gde_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Ma Əntaŋfə, pooshi əndə sha nee ka ci shaŋə. Uuzənaakii rəŋwə dyaŋə ci ka nəkii, Əntaŋfə nə ci. Ka hakii nə tii da Dii, ci ɓaarəgi kaamə furəŋənə tə ndzaanə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Ma ka əndə'i uusəra, wata *Yahudiinə də Urusaliima a sləkee ka limanyinə da hara ənji agi slikərənə ŋga *Leewi aaɓii Yoohana kaa təya ləgwa ka ci wu saŋə nə ca. Wiinə seedatə vii ci ka tii, ");
INSERT INTO gde_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","pooshi ci naanagi ka ənəpaagi ka tii də ləgwanatii, kə waɓi ci ka tii paŋgəraŋə paŋgəraŋə, əŋki ci, “Ma nyi, əntaa Aləmasiihu nə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Əŋki tii ka ci, “Aa wu ɗii nə ha? Hə nə *Iliya kwa?” Əŋki ci: “Pooshi.” “Aa, hə nə anabitə bii ənji na shi kwa?” Əŋki ci, “Pooshi.” ");
INSERT INTO gde_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Əŋki tii ka ci, “Aa, bawə keenə taa wu nə ha, acii ŋga'ə keenə nə ənəpaa də waɓənəkii ka ənjitə sləkee keenə. Wu nə hə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Yoohana a ənəpaagi ka tii də waɓənə asəkə ləkaləkatə ŋga anabi Isaaya, əŋki ci, “Nyi nə əndətə kaalii agi bilinə oo'i, Kəŋeemə ka rəgwa ŋga Slandana, haɗatəgimə.” ");
INSERT INTO gde_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","Ma ənjitsa, *Farisanyinə sləkee ka tii. ");
INSERT INTO gde_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","Təya ba ka Yoohana, “Maɗa əntaa Aləmasiihu taa Iliya taa anabi nə hə saŋa, ka mi cii kwa ɗa ka ənji bapətisəma?” ");
INSERT INTO gde_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Əŋki Yoohana ka tii, “Də ma'inə cii kya ɗa bapətisəma, amma ahadoonə kəŋə nə əndətə mashiimuunə. ");
INSERT INTO gde_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Ma ca, ci na uugya ba'ə ka shinə. Taa zə'u ŋga ɓiɓinaakii mambu'umə nyi bahə pərəginə.” ");
INSERT INTO gde_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Ma ətsə patə, də Bayitaniya slənyi, ataŋəgi gəərə ŋga Urədunə, hatə nji Yoohana a yiiɓə bapətisəma ka ənja. ");
INSERT INTO gde_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Ma ka pukyatə hakii, kə nee Yoohana ka Yeesu ca shi aaɓiikii. Makə nee ci ka ci, əŋki ci, “Waatsə Uundzə Baga ŋga Əntaŋfə. Ci nə əndə ŋgərəgi 'waslyakəənə ŋga *duuniya. ");
INSERT INTO gde_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Waatsə əndətsə njii kya waɓə koonə agyanəkii, ətə njii kya ba, ma əndətə na uugya ba'ə ka shinə, kə palee ci ka nyi, acii daga ka 'watəginə nə ci. ");
INSERT INTO gde_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Ma nyi, paa nyi sha shii tə ci, amma ma shinaaki, nya ɗa ka ənji bapətisəma də ma'inə, kaa nya shii ɓaariinə tə ci ka ənji *Isərayiila.” ");
INSERT INTO gde_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Wiinə seedatə vii Yoohana, kə bii ci, “Kə nee nyi ka Malaaɓa Ma'yanə ca jima dadagyə makə kurəkuta, ca kəŋaanə anəkii. ");
INSERT INTO gde_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Ma nyi, paa nyi sha shii tə ci, amma ma Əndətə sləkee ka nyi kaa nya ɗa bapətisəma də ma'inə, ci bii ka nyi oo'i, ma əndətə nii kwa nee Malaaɓa Ma'yanə a jima, ca kəŋaanə anəkii, ci na ɗa bapətisəma də Malaaɓa Ma'yanə. ");
INSERT INTO gde_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Kə nee nyi də ginəki. Wanyinə ka baginə paŋgəraŋə, ci nə *Uuzənə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Pukyatə hakii əsə, kəŋə kəŋə nə Yoohana tii da lyawarənaakii bəra'i. ");
INSERT INTO gde_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Makə nee ci ka Yeesu ca dzə a rəgwa, əŋki ci, “Waatsə Uundzə Baga ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Wata kə fii lyawarənaakii ətə bəra'i ca ba ha'ə, wata təya palə atsaa Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Yeesu a zə'ugi. Ma ca nee wata təya nə'u tə ci, ca ləgwa ka tii, “Mi cuuna ala?” Əŋki tii ka ci, “Rabbi, (makə bana maləma) da saŋə nə ha?” ");
INSERT INTO gde_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Əŋki ci ka tii, “Shoomə ka neenə.” Wata təya palə, təya dzə ka neenə ka hatə ɗii ci davə. Ma saa'ikii, tibisə ənfwaɗə ŋga kədəwanə. Wata təya uudəpaa ka uusərakii da ci. ");
INSERT INTO gde_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Ma ənjitə bəra'i fii waɓənə ŋga Yoohana, təya nə'unətsa tə Yeesu, Andərawəsə nə ləmə ŋga əndə'i əndə agitii, waatoo, ndzəkəŋuci Simoonə Piita. ");
INSERT INTO gde_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Pii wata ca dzə ka alətənə tə ndzəkəŋuci, waatoo, tə Simoonə, ca ba ka ci, “Kə lapaa inə tə Aləmasiihu” (makə bana, Mataɗəkii). ");
INSERT INTO gde_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Wata ca kərə tə Simoonə aaɓii Yeesu. Yeesu a tsaamə tə ci, əŋki ci, “Simoonə nə ləməku, uuzənə ŋga Yoohana. Ma aakəŋwa, Keefasə ndzaanə ləməku.” Ma ləmə Keefasə, uushi rəŋwə da 'wanə Piita, waatoo, pasla. ");
INSERT INTO gde_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","Ma pukyatə hakii, kə ma'i Yeesu kaa ca palə aanə hanyinə ŋga Galili. Wata ca dzə, ca lapaa tə Filibusə, ca ba ka ci, “Nyi'wawə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","Ma Filibusə, əndə Batəsayida nə ci. Waatoo manjeevə vəranə rəŋwə nə tii da i Andərawəsə da Piita. ");
INSERT INTO gde_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Wata Filibusə a lapaa tə Nataniyalə, əŋki ci ka ci, “Ma əndətə nyaahə Muusa agyanəkii asəkə ləkaləkatə ŋga bariya, i anabiinə maa, kə nyaahə tii agyanəkii, kə lapaa inə tə ci, waatoo Yeesu uuzənə ŋga Yusufu əndə Nazaratu.” ");
INSERT INTO gde_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Əŋki Nataniyalə ka ci, “Bahə tə'i uushi ŋunyikii ca shigi asəkə vəranə ŋga Nazaratu nii?” Əŋki Filibusə, “Shiwa nda nee ka ci.” ");
INSERT INTO gde_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Makə nee Yeesu ka Nataniyalə ca shi aaɓiikii, kə waɓi ci agyanəkii, əŋki ci, “Waatsə tantanyitə uuzətə Isərayiila, tə'i gooŋgaanə ashikii.” ");
INSERT INTO gde_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Nataniyalə a ləgwa ka Yeesu, əŋki ci, “Dama saŋə shii hə tə nya?” Əŋki Yeesu ka ci, “Taabu'u 'wii Filibusə tə hə, kə nee nyi ka hə atsa ənfwə uudəva.” ");
INSERT INTO gde_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Əŋki Nataniyalə, “Maləma, hə nə Uuzənə ŋga Əntaŋfə tanyi, ŋwaŋwa ŋga ənji Isərayiila.” ");
INSERT INTO gde_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Əŋki Yeesu, “Kə vii hə gooŋga acii bii nyi kə nee nyi ka hə atsa ənfwə uudəva tanə nii? Ka neenə nə hə ka hara madiigərə uushi'inə palee ka ətsa.” ");
INSERT INTO gde_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Wata ca tsakə banə ka ci, əŋki ci, “Tantanyinə cii kya ba koonə, ka neenə nuunə ka dadagyə mawunəkii; malaa'ikanyinə ŋga Əntaŋfə a ndərə, təya jima aagyanəki, nyi *Uuzənə ŋga ənda.” ");
INSERT INTO gde_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Ma ka makkənə ŋga uusəra, kə ɗii ənji əndzanə ŋga da məhura asəkə vəranə ŋga Kana anə hanyinə ŋga Galili. Kə gi məci Yeesu ka əndzanəkii. ");
INSERT INTO gde_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","Ma Yeesu da lyawarənaakii əsə, kə bii ənji ka tii zəmə əndzanəkii. ");
INSERT INTO gde_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ma ətsə ənji agi zəmə əndzanəkii, kə uudəgi ma'i inaba. Wata məci Yeesu a shi aaɓiikii, kya ba ka ci, “Kə uudəgi ma'i inaba agyanə slanjii əndzanə.” ");
INSERT INTO gde_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Əŋki Yeesu ka ki, “Yaayi, əntaa waɓənaaku ətsa. Ma'ə saa'yaaki mambu'umə.” ");
INSERT INTO gde_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Məci Yeesu a ba ka ənji sləna, “Ɗamə sətə nii kəya ba koonə patə.” ");
INSERT INTO gde_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Ma dava, tə'i gəranyinə kuwa. Taa ŋgutə rəŋwə agitii, agi luunə nə ci uuda ma'inə bahə pu'u. Ma gəriitsa, ka kuɓəginə makə sətə ɗii alə'aada ŋga *Yahudiinə ka paslə də Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Wata əŋki Yeesu ka ənji sləna, “Naanatəmə gəriitsə də ma'inə.” Təya naanatə pyaslya'ə aa matii. ");
INSERT INTO gde_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Wata əŋki ci ka tii, “Əgəciimə ma'iitsə asəkə gəriitsə, una kərə ka kadala.” Wata təya əgə ma'inəkii, təya kərə ka ci. ");
INSERT INTO gde_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","Ca təɓətə. Asee kə zə'ugi ma'inəkii ka ma'i inabi. Amma mashiimə ci taɗa dama shi ma'i inabikii. Ma ənji slənətə əgya ma'inəkii, kə shii tii. Wata kadala a 'wa tə dagwa maɗanə, ");
INSERT INTO gde_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","əŋki ci ka ci, “Taa wu patə, ŋunyi ma'i inaba viinəkii ka ənji zəku'i. Maɗa kə sii ənji, kə əburi ənji, ənjə a kira mahwarəkinə ha'ə. Amma ma hə naaku, maɗamə hə ha'ə. Mahwarəkinə vii hə zəku'i, ha vii ŋunyikii daaba'ə.” ");
INSERT INTO gde_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Ətsə nə 'watəginə ŋga slənə sə ŋga hurəshishiitə ɗii Yeesu. Ma sə ŋga hurəshishiitsa, də Kana anə hanyinə ŋga Galili ɗii ci. Də ha'ə ɓaarii ci ɗuunuunaakii, wata lyawarənaakii a vii ka ci gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Ma daaba'ə ətsa, wata i Yeesu da məci da i ndzəkəŋushi'inəkii da lyawarənaakii a maɗə, təya palə aa Kafarənahumə, təya banee gi'u davə. ");
INSERT INTO gde_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Makə uugi kumənə ŋga *Yahudiinə ətə ci ənjə a 'wa *Pasəka mbəshanə, wata Yeesu a maɗə, ca palə aa Urusaliima, ");
INSERT INTO gde_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ca dzə aasəkə yi ŋga Əntaŋfə. Makə gi ci, kə lapaa ci ənji ɗərə də liinə i bagiinə i bilyamasariinə, da ənji pəra kwaɓa dasə anə ha ŋga ndzaanatii. ");
INSERT INTO gde_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Wata ca ŋgərə zə'wa, ca dzəɓatə ka uu'yanə, ca shaabagi tə tii patə asəkə yi ŋga Əntaŋfə, bagiinə da liinə patə, ca dzaadzapaa ha ŋga pəra kwaɓa, ca waa'agi kwaɓanyinatii, ");
INSERT INTO gde_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ca ba ka ənjitə ca ɗərə də bilyamasariinə, “Fəɗəgimə uushi'iitsə patə! Goona zhi'wee ka yi ŋga Daadə ka luuma!” ");
INSERT INTO gde_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Makə nee lyawarənaakii ha'ə, wata təya buurətə oo'i, ma bii malaaɓa ləkaləkatə, “'Ya'ə Əntaŋfə, hənənə makə gunə a ədzəməki nə uuɗəətə cii kya uuɗə tə yaaku.” ");
INSERT INTO gde_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Ma daba'əkii ha'ə, wata *gayinə ŋga Yahudiinə a shi, təya ləgwa ka ci, əŋki tii, “Ŋgutə sə ŋga hurəshishinə cii kwa ɗa ka ɓaarəginə keenə oo'i, Əntaŋfə vii ka hə baawəɗa ŋga ɗanə ha'a?” ");
INSERT INTO gde_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Əŋki Yeesu ka tii, “Maɗa uulagyuunə yinə ŋga Əntaŋfə, agi baanə makkə nə nyi ka ənənə ka ghənətənə.” ");
INSERT INTO gde_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Əŋki tii ka ci, “Agi baanə makkə ənənuku ka ghənətənə nii? Fəzə ənfwaɗə pu'unə aji kuwa ɗii ənji ka ghənə yinə ŋga Əntaŋfə dee.” ");
INSERT INTO gde_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amma, ma Yeesu, ma yitə cii kəya waɓə agyanəkii, ci nə shishinəkii. ");
INSERT INTO gde_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Makə maɗee Əntaŋfə ka ci agi maməətə ənja, wata lyawarənaakii a buurətə oo'i, kə shi ca bii ha'ə. Davə ŋgirə tii sətə bii malaaɓa ləkaləkatə da sətə bii Yeesu ka gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Ma saa'itə Yeesu də Urusaliima agi kumənə ŋga Pasəka, laŋə nə ənjitə vii ka ci gooŋga, acii kə nee tii ka sə ŋga hurəshishiitə cii kəya ɗaaɗa. ");
INSERT INTO gde_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amma pooshi Yeesu kii nəkii agyanətii, acii kə shii ci tə ənji patə. ");
INSERT INTO gde_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Pooshi nafa ŋga banə ŋga əndə ka ci agyanə ənji, acii ci də naakii nə, kə shii ci patənə ŋga sətə a mooɗəfətii. ");
INSERT INTO gde_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Tə'i əndə'i əndə ɗii ləməkii Nikoodaməsə. Ma ca, əndə'i gawə ŋga Yahudiinə nə ci, agi kurəgə ŋga *Farisanyinə. ");
INSERT INTO gde_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","Ma ka əndə'i vəɗa, kə gi ci aaɓii Yeesu, əŋki ci ka ci, “Maləma, kə shii inə, ma hə, maləmə nə hə. Əntaŋfə sləkee ka hə əsə. Acii pooshi əndə ca ɗatə tsarə sə ŋga hurəshishiitsə cii kwa ɗaaɗa, maɗaamə ləɓə nə əndəkii da Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","Yeesu a jikə ka ci, əŋki ci. “Tantanyinə cii kya ba ka hə: Pooshi əndə ca nee ka *ŋwaŋuunə ŋga Əntaŋfə maɗaamə ənji kə ənyi ka poonə tə ci.” ");
INSERT INTO gde_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Əŋki Nikoodaməsə, “Iitə da ənə nə ənji ka poo iirə ənda? Aasəkə məci ənəgərənəkii, kya ənə ka poonə tə ci nii?” ");
INSERT INTO gde_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Əŋki Yeesu, “Tantanyinə cii kya ba ka hə, maɗaamə əndə kə upaa poonə dagi ma'inə da Malaaɓa Ma'yanə, pooshi ci ka dəmənə aagi ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Ma əndətə pwayi əndə shiŋkinə tə ci, ŋga əndə shiŋkinə nə ci. Ma əndətə ənyi ənji ka poonə tə ci dagi Malaaɓa Ma'yanə əsə, ŋga Malaaɓa Ma'yanə nə ci. ");
INSERT INTO gde_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Ga ca ɗa ka hə ka sə ŋga hurəshishinə makə fii hə bii nyi ka hə, tyasə see maɗa ənyi ənji ka poonə tuunə. ");
INSERT INTO gde_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Ma məɗa, ka əgənə nə ci taa dama patə mwayi ci. Ka fanə nə hə ca həwə, amma paa hə shii taa dama njaŋə ci, taa da cii kəya dzə ka kəŋənə əsə, mashiimə hə. Ha'ə əsə nə taa wu patə ətə pwayi ənji tə ci dagi Malaaɓa Ma'yanə.” ");
INSERT INTO gde_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Əŋki Nikoodaməsə ka ci, “Iitə daa ɗanəkii ha'ə?” ");
INSERT INTO gde_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Yeesu a ba ka ci, “Maɗuunə maləmə nə hə də *Isərayiila. Yoo, mashiimə hə ətsə nii? ");
INSERT INTO gde_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Tantanyinə cii kya ba ka hə: sətə shii inə ciina waɓə koonə agyanəkii. Sətə nee inə, ciina seeda agyanəkii əsə. Amma ma seeda geenə, pooshi unə ka moo luuvənə. ");
INSERT INTO gde_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Makə waɓi nyi koonə agyanə uushi'inə ŋga *duuniya, pooshi unə ŋgirə ka gooŋga, iitə ɗii ŋgərə nuunə ka gooŋga, maɗa kə waɓi nyi koonə agyanə sətə dəɓəshi tii da Əntaŋfwa? ");
INSERT INTO gde_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Acii pooshi əndə sha ŋgirə aadəgyə, maɗaamə əndətə jima dadavə, waatoo, *Uuzənə ŋga ənda. ");
INSERT INTO gde_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","“Makə sətə ŋgirə Muusa tibisə, ca ŋgaɓətə uushi pusha tə rəhunə, ca maɗee aadəgyə agi bilinə, tyasə ha'ə nə ənjə a maɗee ka Uuzənə ŋga əndə aadəgyə, ");
INSERT INTO gde_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","kaa taa wu patə ətə vii ka ci gooŋga a upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Acii kə uu'i Əntaŋfə tə *duuniya ka shaŋə, ca vii Uuzənaakii rəŋwə dyaŋə. Ma ɗii ci ha'ə, kaa patənə ŋga ənjitə vii ka ci gooŋga a upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə, paa tii ka zanə. ");
INSERT INTO gde_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Pooshi Əntaŋfə sləkee ka Uuzənaakii aasəkə duuniya kaa ca la gəŋwanə ka duuniya, amma kaa duuniya a upaa luupaanə daciikii. ");
INSERT INTO gde_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Taa wu patə vii ka ci gooŋga, ka mbəɗənə nə ci acii gəŋwanə. Amma taa wu patə naanagi ka vii ka ci gooŋga, kə uugi gəŋwanə kəsənə tə ci, acii paa ci vii gooŋga ka *Uuzənə ŋga Əntaŋfə rəŋwə dyaŋə. ");
INSERT INTO gde_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Wiinə makə sətə ci gəŋwanə a slənə: kə shi ɓərənə aasəkə duuniya, amma kə kaɗeesəkə təkunə ka ənji palee ka ɓərənə, acii bwayakii nə slənatii. ");
INSERT INTO gde_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Taa wu patə ca ɗa bwaya sləna, kə ɓiipaa səkə ka ci nə ɓərənə, paa ci ka shinə aagi ɓərənə əsə, acii paa ci ka moonə bwaya slənaakii a shigi a babara. ");
INSERT INTO gde_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amma taa wu ca ɗa slənə ŋga gooŋga, ka shinə nə ci aagi ɓərənə, kaa ɓərənə a shii ɓaarəginə oo'i, agi fanə nə ci tə Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Ma daba'əkii, Yeesu tii da lyawarənaakii a maɗə, təya palə aanə hanyinə ŋga Yahudiya, təya ndzaanə davə gi'u, təya ɗa bapətisəma ka ənja. ");
INSERT INTO gde_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Ma Yoohana naakii, də Ayinoonə nə ci ka ɗa bapətisəma ka ənja. Acii ma dava, tə'i ma'inə laŋə. Pooshi dzaɗə da Salimə nə hakii. Agi maɗənə nə ənji, ənjə a la tə ci davə, ca ɗa ka tii bapətisəma. ");
INSERT INTO gde_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Ma saa'ikii, ənji ma'ə mapa'amə tə Yoohana a furəshina. ");
INSERT INTO gde_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Ma ka əndə'i uusəra, kə ma'i mabizhinə ahada hara *lyawarənə ŋga Yoohana da əndə'i əndə Yahuda. Ma mabizhinatii, agyanə ɗa bapətisəma. ");
INSERT INTO gde_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Wata təya maɗə, təya dzə aaɓii Yoohana, əŋki tii ka ci, “Maləma, kə buurətə hə tə əndətə nji aɓiiku a taŋəgi gəərə ŋga Urədunə nii? Waatoo əndətə seedii hə agyanəkəya? Waatsə agi ɗa bapətisəma; taa wu patə agi dzənə aaɓiikii!” ");
INSERT INTO gde_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Əŋki Yoohana, “Pooshi əndə ca upaa taa mi, maɗaamə Əntaŋfə vii ka ci səkii. ");
INSERT INTO gde_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Unə də noonə nə nə ənji seedaaki, makə sətə bii nyi, əntaa *Aləmasiihu nə nyi, amma kə sləkee ənji ka nyi zəku'i, taabu'u shinəkii. ");
INSERT INTO gde_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Ma dagwa maɗanə, naakii nə maɗanə, amma ma guva, kəŋə nə ci aɓii dagwa maɗanə. Maɗa fii ci uura ŋga dagwa maɗanə, ka ɗanə nə ci mooɗasəka laŋə. Də ha'ə mbu'i mooɗasəkaaki ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Tyasə see a tsakə ci ɗa məghərəvənə, naaki a ənya aaba'ə.” ");
INSERT INTO gde_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Ma əndətə jima dadagyə, kə palee ci taa ka mi patə. Ma əndətə ghənyi ənji də hanyinə, ŋga hanyinə nə ci, agyanə uushi'inə ŋga hanyinə waɓənəkii əsə. Amma ma əndətə jima dadagyə, kə palee ci taa ka mi patə. ");
INSERT INTO gde_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Sətə nee ci, da sətə fii ci, cii kəya seeda. Amma pooshi əndə luuvə seedaakii. ");
INSERT INTO gde_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Taa wu luuvə seedaakii, də ətsə ha'ə ɓaarii ci oo'i, əndə gooŋga nə Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Ma əndətə sləkee Əntaŋfə, waɓənə ŋga Əntaŋfə cii kəya waɓə, acii kə vii Əntaŋfə ka ci Ma'yanaakii laŋə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Ma Əntaŋfə Dənə, kə uu'i ci Uuzənaakii, ca ba'avə patənə ŋga uushi'inə aaciikii. ");
INSERT INTO gde_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Taa wu vii gooŋga ka Uuzənəkii, tə'i ci da əpinə ŋga ca'ə ndəŋwə ndəŋwə. Taa wu təkuree ka fanə tə Uuzənəkii, paa ci ka upaa əpinə, amma agi maɓətəsəkə ŋga Əntaŋfə ndzaanəkii. ");
INSERT INTO gde_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Yoo, kə fii *Farisanyinə oo'i, ma ənjitə ca nə'u tə Yeesu, ca ɗa ka tii bapətisəma, kə palee ka ətə ŋga Yoohana. ");
INSERT INTO gde_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Ma Yeesu, ma ci saakii də ciinəkii, paa ci ɗii ka ənji bapətisəma, amma lyawarənaakii ɗaaɗii ka tii. ");
INSERT INTO gde_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Makə mbu'i aalimə Yeesu nə sətə ci ənjə a baaba ha'ə, ca maɗə anə hanyinə ŋga Yahudiya, ca ənə saakii aanə hanyinə ŋga Galili. ");
INSERT INTO gde_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Ma taabu'u mbu'unəkii aanə hanyinə ŋga Galili, see a dzə ci danə hanyinə ŋga Samariya. ");
INSERT INTO gde_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Makə mbu'i ci aanə hanyinə ŋga Samariya, ca dzə aasəkə vəranə ŋga Sikarə. Ma vəranəkii, pooshi dzaɗə da babaratə shi Yakubu a vii ka uuzənaakii Yusufu. ");
INSERT INTO gde_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Tə'i gu'u ma'inə ŋga Yakubu davə. Makə zhaarə Yeesu acii wiinə, ca ndzaanə ama gu'u ma'inəkii. Ma mbu'i ci aa dəvə, uusəra takərə. ");
INSERT INTO gde_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","Wata mitə Samariya a shi ka əgə ma'inə. Əŋki Yeesu ka ki, “Ndii ka nyi ma'inə kaa nya sa.” ");
INSERT INTO gde_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","Ma saa'ikii, kə pyalə lyawarənaakii aasəkə vəranə ka ira zəma. ");
INSERT INTO gde_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Əŋki miitə ka ci, “Əndə Yahuda nə hə, nyi boo mitə Samariya nə nyi. Iitə daa kədiinəku ma'inə aciikya?” Ma bii ki ha'ə, acii ma *Yahudiinə, pooshi tii ka adə zəmə ka ha rəŋwə da ənji Samariya. ");
INSERT INTO gde_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Wata Yeesu a ba ka ki, “Maɗa kə shii hə viinə ŋga Əntaŋfə, ha shii taa wu nə əndənə ca kədii ma'inə aciiku, kaɗa hə kədii ma'iitə ca vii əpinə aciikii, ca vii ka hə.” ");
INSERT INTO gde_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Əŋki miita, “Maləma, pooshi sə ŋga əlya də ma'inə aciiku. Wiinə əsə kurəŋə dərəva nə gu'u ma'iina. Da saŋə shii hə hatə cii kwa upaa ma'iitə ca vii əpina? ");
INSERT INTO gde_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Dzədzəshi'iniinə Yakubu vii keenə gu'u ma'iina. Ci saakii da manjeevənaakii da gəna əpinaakii patə, ganə njii təya sa ma'inə. Kə palee hə ka ci kwa?” ");
INSERT INTO gde_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Yeesu a ba ka ki, “Taa wu sii ma'iitsa, ka ənənə nə meegiirənə ka ɗanə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","Amma taa wu sii ma'iitə nii kya vii ka ci, pooshi meegiirənə ka ɗanə tə ci ma'ə shaŋə. Ma ma'iitə nii kya vii ka ci, ka ndzaanə nə ci ashikii ka ginə ŋga ma'inə, ca vii ka ci əpinə ŋga ca'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Əŋki miita ka ci, “Maləma, vii ka nyi ma'iitsa! acii ga meegiirənə a ɗii tə nyi ma'ə, nya mbəɗə acii shinə ka əgə ma'inə aahanə.” ");
INSERT INTO gde_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Əŋki Yeesu ka ki, “Duu ka 'wanə tə ŋgurəku, una shi da ci.” ");
INSERT INTO gde_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Əŋki ki ka Yeesu, “Pooshi ŋgurəki.” Əŋki Yeesu ka ki, “Tə'i gooŋga ashiku makə bii hə pooshi ŋgurəku. ");
INSERT INTO gde_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Tufə ɗii hə ŋguyirənə. Ma ŋgurətsə ɗii hə atsakii ŋga əna, əntaa ŋgurəku ŋga tantanyinə. Kə bii hə gooŋga.” ");
INSERT INTO gde_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Əŋki miita, “Maləma, asee *anabi nə hə. ");
INSERT INTO gde_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","Ma dzədzəshi'iniinə ənji Samariya, agyanə giŋuutsə njii təya paslə tə Əntaŋfə. Amma ma unə Yahudiinə, ma cuuna ba, tyasə see də Urusaliima paslə nə ənji tə ci.” ");
INSERT INTO gde_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Yeesu a ba ka ki, “Mina, luuvə ka nyi, tə'i saa'i na shi ətə pooshi ənji na ndərə aanə giŋuutsa, taa dzənə aa Urusaliima ka paslənə tə Daadə. ");
INSERT INTO gde_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Ma unə ənji Samariya, pooshi unə shii tə əndətə cuuna paslə tə ci. Amma ma inə Yahudiinə, kə shii inə tə əndətə ciina paslə, acii dacii Yahudiinə ci luupaanə a shi ka ənja. ");
INSERT INTO gde_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amma tə'i saa'i na shi, kə uugi saa'ikii mbu'yanə maa. Ma saa'ikii, ma ənji paslənə tə Daadə də gooŋga, ka paslənə nə tii tə ci də ŋgeerənə ŋga Ma'yanaakii, təya paslə tə ci də gooŋga makə sətə kaɗeesəkə ka ci. Tsarə ŋga ənjitsə ci Daadə a moo təya paslə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Ma Əntaŋfə, Ma'yanə nə ci. See də ŋgeerənə ŋga Ma'yanaakii paslənə ənji tə ci, təya paslə tə ci də gooŋga.” ");
INSERT INTO gde_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Əŋki miitə ka ci, “Kə shii nyi ka shinə nə Mataɗəkii ətə ci ənja a 'wa Aləmasiihu. Maɗa kə shi ci, kadə nii kəya ɓaarii keenə patənə ŋga uushi'inə.” ");
INSERT INTO gde_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Yeesu a ba ka ki, “Wanyinə ca waɓə da hə.” ");
INSERT INTO gde_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Ma ca uudəpaa waɓənə ha'ə, wata lyawarənaakii a ənya. Makə lapaa tii tə ci ka waɓənə da miita, kə ɗii ka tii ka sə ŋga hurəshishinə. Amma pooshi əndə agitii ləguyi ka mitə taɗa mi cii ta uuɗə, taa ləgwanə ka Yeesu, taɗa ka mi cii kəya waɓə da ki. ");
INSERT INTO gde_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Wata miitə a bwasee ka uuda ma'inatə ama gu'u ma'iita, kya palə aasəkə vəranə, kya dzə ka banə ka ənji, əŋki ki, ");
INSERT INTO gde_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Shoomə, nda neemə ka əndə baabagi ka nyi patənə ŋga sətə shi nya ɗaaɗii. Matuu ci nə Aləmasiihu nii?” ");
INSERT INTO gde_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Makə fii ənji ha'ə, wata təya maɗə, təya palə ka lanə tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Ka saa'ikii ha'ə, wata lyawarənaakii a ba ka ci, əŋki tii, “Maləma, wiinə zəmə, zəmuu.” ");
INSERT INTO gde_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amma ca ba ka tii, “Ma nya, tə'i zəmaaki ŋga zəmənə ətə pooshi unə shii tsarəkii.” ");
INSERT INTO gde_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Wata lyawarənaakii a waɓə ahadatii, əŋki tii, “Tə'i əndə kira ka ci zəmə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Əŋki Yeesu ka tii, “Ma zəmaaki, ci nə ɗa sətə ci Əndətə sləkee ka nyi a moo nya ɗa, nya mbu'utəgi də slənaakii. ");
INSERT INTO gde_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Pooshi unə agi banə, mbəɗaanə ləgiɗə ənfwaɗə kaa ənjə a slənə cifanə kwa? Amma wanyinə ka banə koonə, tsaaməmə ŋga'ə asəkə rə, kə uugi cifanə ɗanə. ");
INSERT INTO gde_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Ma əndə slənə cifanə, kə uugi ci nee ka bwatya ŋga slənaakii. Agi kiranə nə ci ənji kaa təya upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə. Acii ha'ə, ma əndətə sha ləgii da əndətə ca slənə cifanə, ka ɗanə nə tii maŋushinə kyakya'ə. ");
INSERT INTO gde_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Gooŋga nə sətə ci ənjə a ba, ‘tsaŋə nə əndə ləganə, tsaŋə nə əndə slənə cifanə.’ ");
INSERT INTO gde_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Ma nya, kə sləkee nyi koonə, koona slənə cifanə asəkə rətə pooshi unə sha slənyi davə; hara ənji slənyi davə. Ma unə, agi upaa nuunə bwatya ŋga slənatii.” ");
INSERT INTO gde_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Ma asəkə vəraata, ənji Samariya laŋə vii gooŋga ka ci putə ŋga waɓənə ŋga miita ətə bii kya, “Kə baabagi ci ka nyi patənə ŋga uushi'iitə shi nya ɗaaɗii.” ");
INSERT INTO gde_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Makə shi tii aaɓii Yeesu, təya kədii tə ci kaa ca banee da tii. Wata təya banee bəra'i. ");
INSERT INTO gde_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Laŋə əsə nə hara ənji vii gooŋga putə ŋga waɓənaakii. ");
INSERT INTO gde_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Əŋki tii ka miita, “Əntaa putə ŋga waɓənaaku ciina vii gooŋga ma'ə. Acii inə də neenə na, kə fii inə amakii, kə shii inə əsə, ci weewee nə Maluu ŋga *duuniya.” ");
INSERT INTO gde_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Ma daba'ə baneenaakii bəra'i davə, ca maɗə, ca palə aanə hanyinə ŋga Galili. ");
INSERT INTO gde_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Acii ci saakii kə bii ci, pooshi ənji ka ɗuunətənə tə *anabi gakii də vəra. ");
INSERT INTO gde_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Makə mbu'i ci aanə hanyinə ŋga Galili, kə liwə ənji Galili tə ci, acii kə shi təya nee ka slənaakii də Urusaliima agi kumənə ŋga Pasəka. Acii tii maa, kə gi tii ka kumənəkii. ");
INSERT INTO gde_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Wata ca ənə aa Kana anə hanyinə ŋga Galili, hatə shi ca zhi'wee ka ma'inə ka ma'i inaba. Ma ka saa'ikii, tə'i əndə'i maɗuunə əndə ŋga ŋgwaməna, ətə ɗii uuzənaakii gwakə də Kafarənahumə. ");
INSERT INTO gde_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Makə fii ci oo'i, kə shi Yeesu daga anə hanyinə ŋga Yahudiya aanə hanyinə ŋga Galili, wata ca dzə aaɓiikii ka kədiinə tə ci kaa ca dzə ka mbəɗəpaa ka ci də uuzənaakii, acii ama wu nə uuzənəkii. ");
INSERT INTO gde_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","Əŋki Yeesu ka ci, “See maɗa nee unə ka sə ŋga hurəshishinə zəku'i, taabu'u vii nuunə gooŋga ɗii əna.” ");
INSERT INTO gde_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Əŋki gawətə ka ci, “Maɗuuna, shiwa taabu'u əntənə uuzənaaki.” ");
INSERT INTO gde_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Yeesu a ba ka ci, əŋki ci, “Duu saaku. Kə mbə'i uuzənaaku.” Kə luuvə əndətə oo'i, gooŋga nə sətə bii Yeesu ka ci, wata ca palə saakii. ");
INSERT INTO gde_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Ma ci ma'ə ka dzənə a rəgwa, wata kə lapaa maviinaakii tə ci, əŋki tii ka ci, “Kə mbə'i uuzənaaku.” ");
INSERT INTO gde_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Ca ləgwa ka tii, taɗa ŋgutə saa'i 'watəgi ci upaa mbəɗənə. Əŋki tii ka ci, ŋga mbəɗə gwaŋaanə ŋga uusəra əpigi tsəfənə ŋga shishinəkii. ");
INSERT INTO gde_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Wata dii uuzəətə a buurətə oo'i, weewee agi saa'ikii bii Yeesu ka ci, “Kə mbə'i uuzənaaku.” Wata tii da yaakii patə, kə vii tii gooŋga ka Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Ətsə nə bəra'inə ŋga slənə sə ŋga hurəshishiitə ɗii Yeesu anə hanyinə ŋga Galili ənyanaakii danə hanyinə ŋga Yahudiya. ");
INSERT INTO gde_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Ma daba'ə ətsa, tə'i kumənə ŋga *Yahudiinə də Urusaliima. Wata Yeesu a maɗə, ca palə aadəvə. ");
INSERT INTO gde_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Ma davə asəkə vərana, tə'i ma'inə kədəhə da uura mayi ŋga vəranə ətə ci ənjə a 'wa uura mayi ŋga bagiinə. Ma ma'iitsa, Beetasəda ci ənjə a 'wa də uura *Ibəraaniya. Tə'i ədzəwanyinə tufə davə. ");
INSERT INTO gde_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Ma atsakii, tə'i maɓərəhə ənji laŋə pərəɓə pərəɓə, muurəfinə da mahurəməsə ənja, da maɓiiyi ənja. Waatoo, ka gəra gwazənə ŋga ma'inəkii nə tii. ");
INSERT INTO gde_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Acii anəkii anəkii nə malaa'ika ŋga Slandanə ka dzəgərənə aagi ma'inəkii ca gwazee. Maɗa kə gwazee ci, ma maɓərəhə əndətə 'watəgi dzəgərənə aagi ma'inəkii, ka mbəɗənə nə ci acii taa ŋgutə tsarə ŋga bwanea ca ɗa tə ci. ");
INSERT INTO gde_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Tə'i əndə'i əndə davə, fəzə makkə pu'unə aji tighəsə nə ci gwakə ka bwanea. ");
INSERT INTO gde_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Wata Yeesu a lapaa tə ci davə pərəɓə, kə shii Yeesu laŋənə ŋga fəzətə ɗii ci makə gwakə ci ka bwanea. Wata ca ləgwa ka ci, “Ŋga'ə ka hə kaa ha mbəɗə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Əŋki əndə bwaneatə ka ci, “Daada, maɗa kə gwazee ənji ka ma'inə, pooshi əndə ŋgərəgərənə tə nyi aagikii. Ma nya ɗa gazhi'waanə ŋga dzəgərənə aagikii, wata əndə'i əndə a takəŋwagərə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Yeesu a ba ka ci, “Maɗətə, ŋgəruu ədzaaku, ha wii.” ");
INSERT INTO gde_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Pii wata əndətə a mbəɗəgi; ca fuuɗətə ədzaakii, ca 'watəgi wiinə. Asee ma uusərakii, *uusəra ŋga əpisəka. ");
INSERT INTO gde_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","Wata əŋki Yahudiinə ka əndətə, “Uusəra ŋga əpisəkə ənshinə, pooshi *bariya kapaa ka hə rəgwa ŋga wiinə da i ədzaaku.” ");
INSERT INTO gde_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Əŋki əndətə ka tii, “Əndətə mbəɗəpaa də nyi bii ka nyi, fuuɗətə ədzaaku, ha wii.” ");
INSERT INTO gde_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Əŋki tii ka ci, “Wu saŋə nə əndətə bii ka hə, fuuɗətə ədzaaku, ha wiya?” ");
INSERT INTO gde_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Amma ma əndətə mbəɗəpaagi Yeesu tə ci, pooshi ci shii tə Yeesu, acii kə itəgi Yeesu saakii, makə ɗii ci laŋə dərəva nə ənji davə. ");
INSERT INTO gde_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Ma daba'ə ha'ə, wata Yeesu a lapaa tə əndətə asəkə yi ŋga Əntaŋfə, əŋki ci ka ci, “Fatə ŋga'ə, wiitsə kə mbə'i hə. Ga ha slənə 'waslyakəənə ma'ə, acii ga sətə palee ka ətsə a ɗii tə hə.” ");
INSERT INTO gde_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Wata əndətə a palə, ca dzə ka banə ka Yahudiinə oo'i, Yeesu mbəɗəpaa də ci. ");
INSERT INTO gde_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Makə fii tii ha'ə, wata təya ndzaŋə ɗa rəgwa ŋga ciɓənə də Yeesu. Acii agi uusəra ŋga əpisəkə mbəɗəpaa ci də əndəta. ");
INSERT INTO gde_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Amma Yeesu a ba ka tii, “Ma Daadə, ca'ə əndzə'i nə ci agi sləna. Nyi maa, agi slənə nə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Ma waɓəətsa, ci uudee ka maɗee ka haŋkala ŋga Yahudiinə, təya alə rəgwa ŋga ɓələginə tə ci. Acii əntaa wata uusəra ŋga əpisəkə taŋəgi ci tanə. Amma kə ɗeegi ci ka naakii nə mbərə mbərə da Əntaŋfə, acii kə bii ci Dii nə Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Wata Yeesu a ba ka tii, əŋki ci, “Tantanyinə cii kya ba koonə, pooshi Uuzənə ŋga Əntaŋfə ka ɗa uushi agi hiimaakii tanə, see sətə nee ci Dii a slənə, ci slənənəkii naakii. ");
INSERT INTO gde_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Acii ma Dənə, kə uu'i ci tə Uuzənaakii, ca ɓaarii ka ci patənə ŋga sətə cii kəya slənə ci saakii. Slənətə palee ka ətsə maa nii kəya ɓaarii ka ci, ka ɗanə koonə ka sə ŋga hurəshishinə əsə. ");
INSERT INTO gde_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Makə sətə ci Dənə a maɗee ka maməətə ənji, ca vii ka tii əpinə, ha'ə viinə Uuzənaakii əpinə ka ənjitə cii kəya moo təya upaa əsə. ");
INSERT INTO gde_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","Pooshi Dii ka la gəŋwanə taa ka wu ci saakii. Amma kə vii ci ka Uuzənaakii baawəɗa ka shaŋə ŋga ɗa gəŋwanə. ");
INSERT INTO gde_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","Ma ɗii ci ha'ə, kaa taa wu patə a ɗuunətə tə Uuzənaakii makə sətə ci təya ɗuunətə tə ci. Taa wu patə təkuree ka ɗuunətə tə Uuzənaakii, pooshi ci ɗuunətə tə Dii ətə sləkee ka ci ətsa. ");
INSERT INTO gde_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","“Tantanyinə cii kya ba koonə, taa wu patə fii waɓənaaki, ca vii gooŋga ka Əndətə sləkee ka nyi, ka upaanə nə ci əpinə ŋga ca'ə ndəŋwə ndəŋwə. Pooshi ənji na la ka ci gəŋwanə, amma kə pitəgi ci dagi wa, ca shi ka upaa əpinə. ");
INSERT INTO gde_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Tantanyinə cii kya ba koonə, tə'i əndə'i saa'i na shi, kə uugi mbu'yanə maa, waatoo saa'itə nə maməətə ənjə a fa waɓənə ŋga Uuzənə ŋga Əntaŋfə. Ma ənjitə fii, təya luuvə, ka upaanə nə tii əpinə. ");
INSERT INTO gde_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Makə sətə ɗii Daadə, ci nə rəgwa ŋga əpinə, ha'ə kavə ci tə Uuzənaakii kaa ca ndzaanə ka rəgwa ŋga əpinə əsə. ");
INSERT INTO gde_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Ca vii ka ci baawəɗa ŋga la gəŋwanə əsə, acii Uuzənə ŋga ənda nə ci. ");
INSERT INTO gde_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","Ga ca ndzaa koonə ka sə ŋga hurəshishinə. Acii agi shinə nə saa'i ətə nə patənə ŋga maməətə ənjə a fa uurakii, ");
INSERT INTO gde_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","təya maɗə asəkə gu'unyinatii. Ma ənjitə slənyi ŋga'ə, ka shiginə nə tii, təya upaa əpinə. Ma ənjitə slənyi bwayakii əsə, ka shiginə nə tii, ənjə a vii ka tii ma'inə.” ");
INSERT INTO gde_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“Ma nyi, pooshi nyi da baawəɗa ŋga ɗa taa mi nyi saaki. Makə sətə bii Əntaŋfə ka nyi, ha'ə cii kya la gəŋwanə. Də gooŋga nə la gəŋwanaaki, acii əntaa sətə kaɗeesəkə ka nyi cii kya ɗa, amma sətə ci Əndətə sləkee ka nyi a moo. ");
INSERT INTO gde_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","“Maci nyi ca waɓə agyanə naaki na, kaɗa pooshi unə ka ŋgərənə ka gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","Tə'i əndə'i əndə ca waɓə ka madəɓa maki. Kə shii nyi əsə, ma waɓəətə cii kəya waɓə agyanəki, tantanyinə. ");
INSERT INTO gde_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Unə də nuunə maa, kə sləkee unə ka ənji aaɓiikii, waatoo aaɓii Yoohana. Kə bagi ci koonə gooŋga agyanəki. ");
INSERT INTO gde_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","“Ma nyi, mandzaamə tyasə see a waɓə əndə shiŋkinə ka madəɓa maki. Ma waɓi nyi agyanə Yoohana, koona shii upaa luupaanə. ");
INSERT INTO gde_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Ma Yoohana, makə garəkuwa nji ci, ca hənə, ca dzə də ɓərənə. Kə kaɗeesəkə koonə nə ɓərənaakii ŋga uundzə saa'i. ");
INSERT INTO gde_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Amma tə'i əndə'i seedaaki ətə palee ka seedanə ŋga Yoohana agyanəki. Sənə cii kya slənə nə seedaaki, waatoo slənənə vii Daadə ka nyi kaa nya mbu'utəgi, ci ca waɓə agyanəki, ca ɓaarii oo'i, Daadə sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Ma Daadə ətə sləkee ka nyi əsə, agi seedanə nə ci agyanəki ci saakii. Amma pooshi unə sha nee ka ci taa fa uurakii shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Pooshi unə agi ɗəkəpaa waɓənaakii a ədzəmuunə, acii pooshi unə vii gooŋga ka əndətə sləkee ci. ");
INSERT INTO gde_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Taa guci patə nuunə agi jaŋga malaaɓa ləkaləkatə, acii kə luuvuunə oo'i, ka upaanə nuunə əpinə ŋga ca'ə ndəŋwə ndəŋwə agikii. Ma malaaɓa ləkaləkatətsa, agyanəki cii kəya waɓə. ");
INSERT INTO gde_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","Patə da ha'ə, wiinə kə naanagyuunə ka shinə aaɓiiki, koona shii upaa əpinəkii. ");
INSERT INTO gde_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","“Ma nyi, əntaa ɗuunətənə ŋga əndə shiŋkinə tə nyi cii kya alə. ");
INSERT INTO gde_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","Kə shii nyi taa ŋgutə tsarə ŋga ənji nuunə, pooshi uuɗənə tə Əntaŋfə a ədzəmuunə. ");
INSERT INTO gde_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Ma nya, də baawəɗa ŋga Daadə shi nyi, amma pooshi unə liwə tə nyi. Amma wiinə əsə, maɗa shi əndə'i əndə də baawəɗaakii saakii, ka luunə nuunə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ma unə, agi dəlaginə nuunə də noonə nə ahadoonə səgoonə. Amma ma dəlaginə ŋga Əntaŋfə duunə, pooshi unə agi ɗa gazhi'waanə ŋga alənə. Makə ha'ə ɗii əna, iitə ɗii mbee nuunə ka vii ka nyi gooŋga? ");
INSERT INTO gde_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","“Goona ŋgərə oo'i, nyi na kərə gəŋwanə goonə aakəŋwacii Daadə. Ma ətsa, Muusa ətə kii unə noonə nə agyanəkii na kərə gəŋwanə goonə. ");
INSERT INTO gde_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Acii maci də tantanyinə vii unə gooŋga ka Muusa, kaɗa kə vii unə ka nyi gooŋga, acii agyanəki nyaahə ci. ");
INSERT INTO gde_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Makə ɗii ci pooshi unə luuvə sətə nyaahə ca, iitə ɗii mbee nuunə ka luuvə sənə cii kya ba?” ");
INSERT INTO gde_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","Ma daba'əkii, Yeesu a maɗə, ca palə aa taŋəgi uunəvə ŋga Galili, waatoo uunəvə ŋga Tibeeriya makə sətə ci ənjə a 'wa uunəvəkii. ");
INSERT INTO gde_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","Daɓaala a dzə də nə'unə tə ci, acii kə nee tii ka sə ŋga hurəshishiitə cii kəya ɗaaɗa, waatoo mbəəɗəpaa də ənji bwanea. ");
INSERT INTO gde_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","Makə mbu'i Yeesu aadəvə, ca ndərəgi aanə ɗaŋgəra, ca ndzaanə dasə davə tii da lyawarənaakii. ");
INSERT INTO gde_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","Ma saa'ikii, kə uugi uusəra ŋga *Pasəka mbəshanə, waatoo kumənə ŋga *Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","Makə caamə Yeesu, ma ca nee, daɓaala a shi aaɓiikii, ca ləgwa ama Filibusə, “Da dzənaamə ka upaa zəmətə ca zəməma ka patənə ŋga ənjitsa?” ");
INSERT INTO gde_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Ma bii ci ətsə ha'ə, kaa ca shii təɓətənə tə Filibusə. Acii ma Yeesu, kə shii ci sətə nii kəya ɗa. ");
INSERT INTO gde_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Əŋki Filibusə ka ci, “Ma sətə ca əhətə tə ənjitsə patə taa gi'u gi'u, ka ɗanə nə kwaɓa ŋga zəməkii palee ka *hwaslə gya'ə bəra'i.” ");
INSERT INTO gde_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Əndə'i əndə agi lyawarənaakii, waatoo Andərawəsə ndzəkəŋuci Simoonə Piita, a jikəvə ka ci, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Tə'i uuzənə ganə, tə'i buroodi tufə ba'ə hərəfinə bəra'i aciikii. Amma kə shii nyi, pooshi ka mbu'unə ka ənjitsə patə.” ");
INSERT INTO gde_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","Yoo ma dava, tə'i kuzhinyinə laŋə. Əŋki Yeesu ka lyawarənaakii: “Bamə ka ənji, wa təya ndzaanə.” Wata ənjitə a ndzaanə patə. Kə mbu'i bahə dəbu'u tufə nə ŋguyirənə ahadatii. ");
INSERT INTO gde_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Wata Yeesu a ŋgərə burooditə, ca kuyirii tə Əntaŋfə, ca ɓaatsəpaa, ənjə a təəkəpaa ka ənjitə dasə dasə gatə. Ha'ə ɗii ci də hərəfinə əsə. Wata təya adə makə sətə mwayi tii. ");
INSERT INTO gde_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Makə agi tii, əburi tii, əŋki ci ka lyawarənaakii, “Tsəkətəmə ətsə mbaaɗaanə patə, acii gaama saawee ka zəma.” ");
INSERT INTO gde_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Wata təya tsəkətə patə, təya naanagi ɗəvə pu'u aji bəra'i də ətə mbəɗaanə ama burooditə tufə ətə agi ənja. ");
INSERT INTO gde_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Makə nee ənjitə davə ka sə ŋga hurəshishiitə ɗii Yeesu, əŋki tii: “Ma əndətsa, ci nə anabitə bii ənji na shi aasəkə duuniya.” ");
INSERT INTO gde_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Amma ma Yeesu, kə shii ci oo'i, ŋga'ə ka tii nə shinə ka kəsənə tə ci, kaa təya shii ɗəkəvənə tə ci tyasə ka ŋwaŋwa. Wata ca maɗə, ca tsakə ndərənə saakii aanə ɗaŋgəra ci daanəkii. ");
INSERT INTO gde_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","Makə ɗii kədəwanə, lyawarənaakii a maɗə, təya əntsahəgərə aama uunəva, ");
INSERT INTO gde_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","təya ndərəvə aasəkə kumbawala, təya taŋə aadə Kafarənahumə. Kə uugi ha ɗanə təku təkə, amma ma'ə Yeesu mashimə aaɓiitii. ");
INSERT INTO gde_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Ma saa'ikii, mandalə məɗə a kya, ca gwazee ka ma'inə purətə. ");
INSERT INTO gde_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Tii kə uugi dzənə bahə kiloomeeta tufə taa kuwa, wata təya nee ka Yeesu ca wii anə ma'inə, ca dzə aaɓiitii, təya ŋgwaləgi ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Əŋki ci ka tii, “Goona ŋgwalə, nyi əna.” ");
INSERT INTO gde_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Makə fii tii ha'ə, kə liwə tii tə ci də mooɗasəkə aasəkə kumbawala. Pii wata kumbawalə a mbu'u aama ndzaŋa ŋga hatə njii təya dzə aadəvə. ");
INSERT INTO gde_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Ma ka pukyatə hakii, ma ənjitə ataŋəgi uunəva, kə paaratəgi tii oo'i, rəŋwə nji kumbawalə davə, kə shii tii, ma saa'itə pyalə lyawarənaakii satii, pooshi Yeesu ŋgirə da i ci aasəkə kumbawaləkii, tii daanətii pyalətii. ");
INSERT INTO gde_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Wata hara kumbawalənyinə a shi aahatə də Tibeeriya, waatoo hatə shi Slandanə a kuyirii tə Əntaŋfə agyanə zəma, kaa ənjə a adə. ");
INSERT INTO gde_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Ma nee daɓaala pooshi Yeesu davə taa lyawarənaakii əsə, pooshi tii davə, təya ndərə kumbawalənyiita, təya palə aa Kafarənahumə ka alənə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Makə lapaa ənji tə Yeesu a taŋəgi uunəva, əŋki tii ka ci, “Maləma, guci daa shi hə aahana?” ");
INSERT INTO gde_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Əŋki Yeesu ka tii, “Tantanyinə cii kya ba koonə, ma cuuna alə tə nyi, acii agyuunə buroodi, una əburə, əntaa paaratəginə paaratəgyuunə də ɗa sə ŋga hurəshishinaaki. ");
INSERT INTO gde_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Goona slənə ka upaa də zəmətə ca saawagi, amma slənəmə ka upaa də zəmətə ca mbu'u ca'ə ka əpinə ŋga ca'ə ndəŋwə ndəŋwə. Ətsə nə zəmətə nə nyi *Uuzənə ŋga ənda a vii koonə, acii ma nya, Əntaŋfə Daadə ɓaarəgi paŋgəraŋə oo'i Uuzənaakii nə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Təya ləgwa ka ci, əŋki tii, “Mi ɗaniinə, keena shii slənə sətə ci Əntaŋfə a moo ina sləna?” ");
INSERT INTO gde_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Yeesu a ba ka tii, “Ma sətə mwayi Əntaŋfə una ɗa, viimə gooŋga ka əndətə sləkee ci.” ");
INSERT INTO gde_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Əŋki tii, “Ŋgutə sə ŋga hurəshishinə ɗanəku, keena nee, ina vii ka hə gooŋga? Tə'i kwa? ");
INSERT INTO gde_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ma dzədzəshi'iniinə, kə agi tii *mana agi bilinə, makə sətə bii malaɓa ləkaləkatə: Dadagyə vya ci ka tii zəmə kaa təya adə.” ");
INSERT INTO gde_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Yeesu a ba ka tii, əŋki ci, “Tantanyinə cii kya ba koonə, əntaa Muusa vya koonə zəmə dadagyə. Daadə vya koonə tə tantanyitə zəmə dadagyə. ");
INSERT INTO gde_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Acii ma zəmətə vii Əntaŋfə ka ənja, ci nə əndətə jima dagyə, ca vii əpinə ka *duuniya.” ");
INSERT INTO gde_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Wata təya kədii aciikii, əŋki tii, “Maɗuuna, vii keenə zəmətsə taa guci patə.” ");
INSERT INTO gde_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Əŋki Yeesu ka tii, “Nyi nə zəmətə ca vii əpinə ka ənja. Ma əndətə shi aaɓiiki, pooshi maɗəfənə ka ɗanə tə ci shaŋə. Ma əndətə vii ka nyi gooŋga, pooshi meegiirənə ka ɗanə tə ci shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Yoo, kə bii nyi koonə, kə nee unə ka nyi, amma pooshi unə vii ka nyi gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Taa wu patə ətə vii Daadə ka nyi, ka shinə nə ci aaɓiiki. Ma əndətə shi əsə, paa nyi ka kaareenə ka ci shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Acii, ma shinaaki dadagyə, əntaa ka slənə sətə mwayi maki, amma ka slənə sətə mwayi ma ŋga Əndətə sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Ma sətə ci Əndətə sləkee ka nyi a moo, wa nya kəsətə təŋə təŋə ka ciinə tə ənjitə vii ci ka nyi, acii ga taa wu agitii a ŋusləgi a rəgwa, ka maɗee nə nyi ka tii da i əpinə uusəra ŋga muudinə. ");
INSERT INTO gde_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ma sətə ci Daadə a moo, patənə ŋga ənjitə nee ka nyi Uuzənaakii, təya vii ka nyi gooŋga, ka upaanə nə tii əpinə ŋga ca'ə ndəŋwə ndəŋwə. Ka maɗeenə nə nyi ka tii da i əpinə uusəra ŋga muudinə.” ");
INSERT INTO gde_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Makə fii *gayinə ŋga Yahudiinə bii ci oo'i, ci nə zəmətə jima dadagyə, wata təya 'watəgi ŋgəərə ma. ");
INSERT INTO gde_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Əŋki tii, “Əntaa Yeesu uuzənə ŋga Yusufu ətsa, anii əntaa ca? Kə shii amə tə dii da məci. Aa iitə ɗii banəkii əndzə'i oo'i, dadagyə jima ca?” ");
INSERT INTO gde_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Əŋki Yeesu ka tii, “Bwaseemə ka ŋgəərə ma ahadoonə. ");
INSERT INTO gde_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Ma nyi, Daadə sləkee ka nyi. Pooshi əndə ca shi aaɓiiki maɗaamə ci kə kavə tə ci kaa ca shi. Ma nyi, ka maɗeenə nə nyi ka ci da i əpinə uusəra ŋga muudinə. ");
INSERT INTO gde_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Kə nyaahə anabinyinə oo'i: ‘Taa wu patə, ka dzəgunətənə nə Əntaŋfə ka ci.’ Ci ɗii cii kya ba koonə, taa wu patə fii sətə jigunyi Daadə ka ci, ca luuvə, ci shi aaɓiiki ətsa. ");
INSERT INTO gde_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Ma sətə cii kya moo banə, pooshi əndə sha nee ka Daadə. See əndətə shi daciikii tanə nee ka ci. ");
INSERT INTO gde_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Tantanyinə cii kya ba koonə, ma əndətə vii gooŋga ka nyi, tə'i ci da əpinə ŋga ca'ə ndəŋwə ndəŋwə. ");
INSERT INTO gde_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Nyi nə zəmətə ca vii əpinə. ");
INSERT INTO gde_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ma dzədzəshi'inuunə ətə agi *mana agi bilinə, kə məətəgi tii. ");
INSERT INTO gde_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amma, ma zəmətə jima dadagyə, tsaŋə nə ci. Taa wu patə agi, paa ci ka əntənə. ");
INSERT INTO gde_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Nyi nə zəmətə ca vii əpinə ətə jima dadagyə. Taɗa wu patə agi zəməna, ka ndzaanə nə ci da i əpinə ka ca'ə ndəŋwə ndəŋwə. Ma zəmətsa, luu ŋga shishinəki ətə nii kya vii kaa *duuniya a upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Ma sətə bii Yeesu, kə zhima tə *gayinə ŋga Yahudiinə asəkətii ka shaŋə, wata təya ndzaŋə maɗee ka mabizhinə ahadatii, əŋki tii, “Iitiitə daa viinə əndətsə kaamə luu ŋga shishinəkii, kaama tsəɓa?” ");
INSERT INTO gde_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Yeesu a ba ka tii, “Tantanyinə cii kya ba koonə, maɗa pooshi unə ciɓə luu ŋga shishinə ŋga *Uuzənə ŋga ənda, una sa idənaakii, pooshi unə ka ndzaanə da i əpinə. ");
INSERT INTO gde_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Taɗa wu ciɓə luu ŋga shishinəki, ca sa idənaaki, tə'i ci da əpinə ŋga ca'ə ndəŋwə ndəŋwə. Ka maɗeenə nə nyi ka ci da i əpinə uusəra ŋga muudinə. ");
INSERT INTO gde_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Acii ma luu ŋga shishinəki, tantanyitə zəma nə ci. Tantanyitə sə ŋga sanə nə idənaaki əsə. ");
INSERT INTO gde_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Taɗa wu ciɓə luu ŋga shishinəki, ca sa idənaaki, ləɓə nə ci da nyi, ha'ə nə nyi əsə, ləɓə nə nyi da ci. ");
INSERT INTO gde_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Acii Daadə sləkee ka nyi. Ma ca, Əndə vii əpinə nə ci. Daciikii ɗii nyi da i əpinə amaki əsə. Ha'ə əsə, ma əndətə ciɓə luu ŋga shishinəki, ka upaanə nə ci əpinə daciiki. ");
INSERT INTO gde_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Ətsə ɗii nə zəmətə jima dadagyə. Əntaa makə zəmətə shi dzədzəshi'inuunə a agi. Acii ma təya, kə məətəgi tii. Ma əndətə agi zəməna, ka ndzaanə nə ci da i əpinə ka ca'ə ndəŋwə ndəŋwə.” ");
INSERT INTO gde_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Ma waɓəətsə bii Yeesu, ci agi dzəgunənə ka ənji asəkə kuvə də'wa də Kafarənahumə bii ci ha'ə. ");
INSERT INTO gde_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Makə fii ənji nə'unə tə Yeesu sətə baabii ci, laŋə agitii bii, “Ma dzəgunəətsa, ndalə ka shaŋə, ndalə ka liminə ŋga ənda.” ");
INSERT INTO gde_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Taa ŋgahi pooshi ənji bagi ka Yeesu aamakii, amma kə shii ci oo'i agi ŋgəərə ma nə tii agyanə ətsa. Wata əŋki ci ka tii, “Iitə daa, kə ɓiipaa koonə səkə nə ətsə kwa? ");
INSERT INTO gde_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Iitə ɗii ba nuunə maɗa nee unə Uuzənə ŋga əndə a ndərə aadəgyə ka hatə shi ca nji dava? ");
INSERT INTO gde_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ma'yanə ŋga Əntaŋfə ca vii əpinə, pooshi nafalə ŋga baawəɗa ŋga əndə shiŋkinə taa gi'u. Dagi waɓəətsə waɓi nyi koonə ci ənjə a upaa əpiinə da Malaaɓa Ma'yanə. ");
INSERT INTO gde_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Amma tə'i hara ənji ahadoonə ətə pooshi vii ka nyi gooŋga.” Ma bii ci ha'ə, acii daga ka 'watəginə shii ci tə ənjitə pooshi na luuvə waɓənaakii. Kə shii ci əndətə na vii tə ci ka kəsənə əsə. ");
INSERT INTO gde_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Ca tsakə banə, əŋki ci, “Putə ŋga ətsə ha'ə bii nyi koonə oo'i, pooshi əndə ca shi aaɓiiki, maɗaamə Daadə kə kavə tə ci, kaa ca shi.” ");
INSERT INTO gde_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Putə ŋga ətsə ha'ə, laŋə agi ənji nə'unə tə Yeesu bwasee ka nə'unə tə ci, təya palə satii. ");
INSERT INTO gde_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Wata ca ləgwa ama lyawarənaakii, əŋki ci, “Ya unə əsa, ŋga'ə koonə nə palənə səgoonə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Simoonə Piita a ba ka ci, “Slandana, aaɓii wu dzəniina? Amaku nə waɓənə ətə ca vii əpinə ŋga ca'ə ndəŋwə ndəŋwə. ");
INSERT INTO gde_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ma inə, kə vii inə ka hə gooŋga, kə shii inə əsə oo'i, hə nə malaaɓa Əndətə shi dacii Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","Əŋki Yeesu ka tii, “Nyi ta'i tuunə unə pu'u aji bəra'i, amma ma əndə rəŋwə ahadoonə, *Seetanə nə ci.” ");
INSERT INTO gde_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Agyanə Yahuda uuzənə ŋga Simoonə Isəkariyootə cii kəya waɓə ha'ə. Acii ma Yahuda, taa ŋgahi rəŋwə nə ci agi lyawarənə pu'u aji bəra'i, patə da ha'ə, ma uudəpaa ba'a, ci vii tə Yeesu ka kəsənə. ");
INSERT INTO gde_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Ma daaba'ə ətsa, kə wiigi'i Yeesu anə hanyinə ŋga Galili, paa ci mwayi wiigi'inə anə hanyinə ŋga Yahudiya, acii ma Yahudiitə davə, kə aali tii rəgwa ŋga ɓələginə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Ma saa'ikii, kə uugi kumənatii mbəshanə, waatoo kumənə ŋga kuvə bəlinə. ");
INSERT INTO gde_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Wata əŋki ndzəkəŋushi'inə ŋga Yeesu ka ci, “Maɗuu, dzuu aanə hanyinə ŋga Yahudiya, kaa ənji nə'unə tə hə ətə davə a nee ka uushi'iitə cii kwa ɗaaɗa. ");
INSERT INTO gde_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Maɗa ŋga'ə ka ənda, kaa ənjə a shii tə ci ŋga'ə, paa ci ka umbee ka sətə cii kəya ɗaaɗa. Makə agi ɗaaɗanə nə hə uushi'iitsa, wa patənə ŋga *duuniya a shii tə hə!” ");
INSERT INTO gde_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Ma bii ndzəkəŋushi'inəkii ka ci ha'ə, acii pooshi tii vii ka ci gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Wata əŋki Yeesu ka tii, “Ma saa'yaaki, ma'ə mambu'yamə. Ma unə, taa ŋgutə saa'i patə matahukii koonə. ");
INSERT INTO gde_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Acii pooshi ənji duuniya ka bərapaanə tuunə. Amma ma nyi, kə ɓiipaa nyi ka tii səka, acii agi dzənə nə nyi də seedanə agyanətii oo'i, bwayakii nə slənatii. ");
INSERT INTO gde_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Ma unə, dzəmə ka kuməətsa. Ma nyi, paa nyi ka dzənə acii ma'ə matahu saa'ikii mashimə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Makə bagi ci ka tii ha'ə, ca banee də Galili zəku'i. ");
INSERT INTO gde_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Makə pyalə ndzəkəŋushi'inə ŋga Yeesu ka kumənəkii, ca maɗə, ca palə naakii ha'ə. Də itə itə gi ci, paa ci gi paŋgəraŋə paŋgəraŋə. ");
INSERT INTO gde_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","*Gayinə ŋga Yahudiinə a nəəhə tə ci ka ha ŋga kumənəkii, təya ləgwa, “Maanə əndətə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Kə ɗaaɗii ənji matatahinə laŋə agyanəkii ahada daɓaala. Hara ənjə a ba, “Maŋga'ə əndə nə ci.” Əŋki hara ənji, “Pooshi, agi ŋusləginə nə ci də hara ənji a rəgwa.” ");
INSERT INTO gde_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Amma pooshi əndə ca ŋgəree ka uurakii ka waɓənə agyanəkii, acii kə ŋgwali tii acii gayinatii. ");
INSERT INTO gde_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ma ətsə ənji agi hadahadanə ŋga kumənəkii, wata Yeesu a maɗə, ca dzəgərə aasəkə *yi ŋga Əntaŋfə, ca dzəgunə ka ənja. ");
INSERT INTO gde_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Kə ɗii ka *gayinə ŋga Yahudiinə ka sə ŋga hurəshishinə nə dzəgunənaakii, əŋki tii, “Iitə daa mbee əndənə ka uushi'inə ha'ə yoo, paa ci gi kurəŋə agi jigunyana?” ");
INSERT INTO gde_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Wata əŋki Yeesu ka tii, “Ma sənə cii kya dzəgunə ka ənja, əntaa dzəgunənaaki saaki, amma dacii Əndətə sləkee ka nyi ca shi. ");
INSERT INTO gde_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Taa wu patə ca moo slənə sətə ci Əntaŋfə a moo, ka taarapaaginə nə ci ahada sənə cii kya dzəgunə ka ənja, ka shiinə nə ci taa dacii Əntaŋfə ca sha, taa ŋga naaki nə cii kya waɓə. ");
INSERT INTO gde_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Ma əndətə ca waɓə ŋga naakii na, alə ɗuunuunə cii kəya alə ka naakii na. Amma ma əndətə ca moo ɗuunuunə ka əndətə sləkee ka ca, ci nə əndə gooŋga, pooshi sə ŋga idəpaanə ashikii. ");
INSERT INTO gde_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","“Ma Muusa, ci vii koonə bariya, amma pooshi unə nə'utə bariyakii. Ci ɗii cuuna alə rəgwa ŋga ɓələginə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Əŋki daŋkana ka ci, “Ma hə ɗiya, tə'i uushi ca ndəərə aanəku! ");
INSERT INTO gde_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Wu saŋə ca alə rəgwa ŋga ɓələginə tə ha?” Yeesu a ba ka tii, “Kə ɗii nyi əndə'i sə ŋga hurəshishinə *uusəra ŋga əpisəka, kə ɗagi koonə patə ka sə ŋga hurəshishinə. ");
INSERT INTO gde_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Kə bii Muusa koonə, *ryaminagi manjeevənə goonə. Taa agi uusəra ŋga əpisəka maa, agi ɗanə nuunə ha'ə. Shiimə əsə, əntaa Muusa 'watəgi ɗanə ha'ə, amma dzədzəshi'inuunə. ");
INSERT INTO gde_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Yoo, maɗa kə ryaminii ənji uuzənə agi uusəra ŋga əpisəka acii ga ənjə a taŋəgi bariya ŋga Muusa, ka mi ɗii cuuna ɓəzə səkə aashiki acii mbəɗəpaa nyi də əndə uusəra ŋga əpisəka? ");
INSERT INTO gde_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Bwaseemə ka lagi gəŋwanə də sətə cuuna nee də ginuunə. Amma lamə gəŋwanə də rəgwakii.” ");
INSERT INTO gde_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Wata əŋki hara ənji Urusaliima, “Əntaa tə əndətsə ci gayinə a moo ɓələginə nii? ");
INSERT INTO gde_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","Tsaaməmə, waatsə ka waɓənə ahada ənji patə, amma pooshi uushi cii təya jikə ka ci. Mbu'u ma nə tii ka nəhənə, ci nə Mataɗəkii ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Amma ma əndətsa, kə shii amə hatə shi ci davə. Ma Mataɗəkii, pooshi əndə na shii taa da nii kəya shi.” ");
INSERT INTO gde_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Ma Yeesu a dzə də dzəgunənə ka ənji asəkə *yi ŋga Əntaŋfə, ca ŋgəree ka uurakii ka ləgwanə, əŋki ci, “Kə shii unə tə nyi kwa? da shi nya? Əntaa də ŋga naaki nə shi nyi, Əndə sləkee ka nyi. Ma ca, əndə gooŋga nə ci, pooshi unə shii tə ci. ");
INSERT INTO gde_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Amma ma nyi, kə shii nyi tə ci, acii daciikii shi nyi. Ci sləkee ka nyi əsə.” ");
INSERT INTO gde_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Wata təya ɗa gazhi'waanə ŋga kəsənə tə ci, amma pooshi əndə kavə ciinə aashikii, acii ma'ə saa'yaakii mambu'yamə. ");
INSERT INTO gde_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Amma laŋə agi daɓaala vii ka ci gooŋga, əŋki tii, “Maɗa kə shi Mataɗəkii, kadə nii kəya ɗaaɗa sə ŋga hurəshishinə palee ka ətsə ŋga əndətsə nii?” ");
INSERT INTO gde_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Kə fii *Farisanyinə daɓaala a ɗaaɗa matatahinə agyanə Yeesu, wata təya maɗə, tii da matakəŋwanyinə ŋga limanyinə, təya sləkee ka soojiinə ka kəsənə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Wata əŋki Yeesu, “Ma'ə nyi ka ta'aveenə doonə gi'u. Ma daba'əkii, ka palənə nə nyi aaɓii Əndətə sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Ka alənə nuunə tə nyi, amma pooshi unə ka neenə ka nyi, pooshi unə na mbu'u ka hatə nii kya ndzaanə.” ");
INSERT INTO gde_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Wata əŋki *gayinə ŋga Yahudiinə ahadatii satii, “Aama daa cii kəya dzə bahə pooshi amə na nee ka ca? Aasəkə vəranyinə ŋga Gərikə hatə ɗii ənji gaamə cii kəya dzə kwa? kaa ca dzə ka dzəgunənə ka ənji Gərika? ");
INSERT INTO gde_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Acii kə bii ci, ka alənə naamə tə ci, pooshi amə na nee ka ci, pooshi amə ka mbu'unə ka hatə nii kəya ndzaanə. Mi cii kəya moo banə saŋa?” ");
INSERT INTO gde_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Ma ka muudinə ŋga uusəra ŋga kuməəta, waatoo maɗuunə uusəra ŋga kumənəkii, kə maɗətə Yeesu ahada daŋkana, ca ŋgəree ka uurakii, əŋki ci, “Taa wu patə ci meegiirənə a ɗa tə ci, wa ca shi aaɓiiki, ca shi ka sa ma'inə. ");
INSERT INTO gde_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Makə sətə bii malaaɓa ləkaləkatə, ma əndətə vii ka nyi gooŋga, ka shiginə nə gəərə ŋga ma'iitə ca vii əpinə a ədzəməkii.” ");
INSERT INTO gde_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Ma waɓi Yeesu ətsa, agyanə Ma'yanə ŋga Əntaŋfə waɓi ci. Ci nə ənji nə'unə a upaa. Ma ka saa'ita, ma'ə tii ma'upaamə zəku'i, acii ma'ə Yeesu ma'upaamə ɗuunuunə dagyə. ");
INSERT INTO gde_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Makə fii hara ənji ahada daŋkana ca ba ha'ə, əŋki tii, “Ma əndətsa, tanyi ci nə *anabi ətə bii ənji na shi.” ");
INSERT INTO gde_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Hara ənji əsə, əŋki tii, “Mataɗəkii nə ci!” Amma ma hara ənji, kə bii tii, “Pooshi Aləmasiihu ka shinə da Galili! ");
INSERT INTO gde_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Ma bii malaaɓa ləkaləkatə, jijinə ŋga ŋwaŋwa *Dawuda na ndzaa ka Mataɗəkii. Də Bayitilaama nə ənjə a poo tə ci əsə, waatoo vəraatə nji Dawuda davə.” ");
INSERT INTO gde_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Acii ha'ə tə'i təəkəshinə ahada daŋkana putaakii. ");
INSERT INTO gde_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Ŋga'ə ka hara ənji kaa təya kəsə tə ci, amma pooshi əndə kavə ciinə aashikii. ");
INSERT INTO gde_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Wata kə ənyi soojiinə satii. Makə mbu'i tii, ləguyi limanyinə da Farisanyinə ka tii, əŋki tii, “Mi pooshi unə kira tə ci kwa?” ");
INSERT INTO gde_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Əŋki soojiinə ka tii, “Pooshi əndə sha waɓə makə ŋga əndətsa!” ");
INSERT INTO gde_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Wata əŋki Farisanyinə ka tii, “Kə ŋusləgi ci duunə noonə əsə kwa? ");
INSERT INTO gde_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Kə shuuna fii rəŋwə agi gayinə taa rəŋwə agi Farisanyinə a vii ka ci gooŋga nii? ");
INSERT INTO gde_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Ma daŋkanata, ma vii tii gooŋga, acii pooshi tii shii bariya ŋga Muusa. Acii ha'ə tə'i naalanə agyanətii.” ");
INSERT INTO gde_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Yoo, ahadatii nə Nikoodaməsə, waatoo əndətə sha gi aaɓii Yeesu. Wata əŋki ci ka tii, ");
INSERT INTO gde_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Maɗa nə'utə sətə bii bariya gaamə, pooshi amə ka lagi gəŋwanə ka əndə, amə ma'ə mafatəmə ŋga'ə tə sətə ɗii ci.” ");
INSERT INTO gde_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Əŋki tii ka ci, “Əndə Galili nə hə əsə kwa? Buurətə ŋga'ə tə sətə bii malaaɓa ləkaləkatə. Davə shiinəku, ma də Galili, pooshi *anabi ka shiginə.”  ");
INSERT INTO gde_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Wata ənjə a təəkəgi satii aasii. ");
INSERT INTO gde_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Yeesu a ndərə saakii aanə giŋwə ŋga Zayitunə. ");
INSERT INTO gde_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Ma pukyatə hakii tsəɗakə, kə ənyi Yeesu aasəkə *yi ŋga Əntaŋfə. Ca dzə ka ndzaanə dasə ka dzəgunənə ka ənja. Patənə ŋga ənjə a dzə aaɓiikii. ");
INSERT INTO gde_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Wata *maliminə ŋga bariya da *Farisanyinə a kira ka ci əndə'i minə ətə kəshi ənji tə ki ka aləhiinə, təya kəŋee ka ki akəŋwaciitii patə. ");
INSERT INTO gde_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Əŋki tii ka Yeesu, “Maləma, ma miina, kə kəshi ənji tə ki, kya aləhiinə. ");
INSERT INTO gde_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Ma agi bariya, kə bii Muusa, ma tsarə ŋga miitsa, see ɓələginə tə ki də kaalanə də faariinə. Ya əna, ya ha, iitə bii hə naaku agyanəkəya?” ");
INSERT INTO gde_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ma bii tii ha'ə, kaa təya shii təɓənə tə ci, təya shii upaa sə ŋga kəsənə də ci. Amma Yeesu a gwaŋaanə, ca naahətə uushi də ciinəkii a panə. ");
INSERT INTO gde_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Təya dzə aakəŋwa də laagwa ka ci uushi'inə, wata ca maɗətə, əŋki ci ka tii, “Ma əndətə pooshi sha slənyi 'waslyakəənə, wa ca 'watəgi kaalanə tə ki.” ");
INSERT INTO gde_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Wata ca ənə ka gwaŋaanənə ka naahənə a panə. ");
INSERT INTO gde_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Makə fii tii ha'ə, təya palə satii patə də rəŋwə rəŋwə. Iirə ənji 'watəgi palənə satii. Kə bwasee tii ka Yeesu ci daanəkii tii da miita. ");
INSERT INTO gde_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Wata ca maɗətə, ca ba ka ki, “Mina, maatiinə da? Pooshi əndə mbəɗaanə bahə vii ka hə ma'inə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Əŋki ki, “Pooshi əndə ɗii Slandana.” Əŋki Yeesu ka ki, “Nyi maa, paa nyi ka vii ka hə ma'inə. Duu saaku, amma ga ha slənə 'waslyakəənə ma'ə.” ");
INSERT INTO gde_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Yeesu a ənə ka waɓənə ka ənji, əŋki ci, “Nyi nə ɓərənə ka duuniya. Ma əndətə ca nə'u tə nyi, paa ci ka wiinə agi təkunə, amma ka upaanə nə ci ɓərənə ətə ca vii əpinə ka ənja.” ");
INSERT INTO gde_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Wata əŋki Farisanyinə ka ci, “Hə saaku ca seeda agyanə naaku na. Pooshi gooŋga agi waɓənaaku.” ");
INSERT INTO gde_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Əŋki Yeesu ka tii, “Taa nyi saaki ca seeda agyanə naaki na, amma gooŋga nə waɓənaaki, acii kə shii nyi hatə shi nyi davə, kə shii nyi hatə nii kya dzə aadəvə əsə. Ma una, pooshi unə shii hatə shi nyi davə, pooshi unə shii hatə nii kya dzə əsə. ");
INSERT INTO gde_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Agi lanə nuunə gəŋwanə makə sətə kaɗeesəkə koonə, amma ma nyi, pooshi əndətə cii kya la ka ci. ");
INSERT INTO gde_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Taa ka lanə nə nyi maa, gooŋga nə la gəŋwanaaki, acii əntaa nyi daanəki ca la gəŋwanə, amma inə da Daadə. Ci sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ma agi bariya goonə, tə'i manaahəkii oo'i, maɗa kə shigi seedawanyinə bəra'i, maɗa uushi rəŋwə nə waɓənatii, ma sətə bii tii, gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Ma nyi, agi seedanə nə nyi agyanə naaki na. Ha'ə nə Daadə ətə sləkee ka nyi əsə, agi seedanə nə ci agyanəki.” ");
INSERT INTO gde_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Əŋki tii ka ci, “Maanə Dəwa?” Əŋki Yeesu ka tii, “Pooshi unə shii tə nyi taa tə Daadə. Maci kə shii unə tə nyi, kaɗa ka shiinə nuunə tə Daadə əsə.” ");
INSERT INTO gde_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Ma waɓəətsə baabii Yeesu, ca dzəgunə ka ənji asəkə yi ŋga Əntaŋfə baabii ci ha'ə. Waatoo a kumu ka hatə ci ənjə a ɗa viinə. Amma pooshi ənji kəshi tə ci, acii ma'ə saa'yaakii mambu'yamə. ");
INSERT INTO gde_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Yeesu a ənə ka waɓənə ka tii, əŋki ci, “Ka palənə nə nyi saaki, ka alənə nuunə tə nyi, amma agi 'waslyakəənə goonə nuuna məətə. Pooshi unə ka dzənə ka hatə nii kya dzə aadəvə.” ");
INSERT INTO gde_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Wata əŋki *gayinə ŋga Yahudiinə, “Kə bii ci, pooshi amə ka dzənə ka hatə nii kəya dzə aadəvə. Ya saŋə banə cii kəya moo banə oo'i, ka ɓələginə nə ci naakii nə nii?” ");
INSERT INTO gde_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Əŋki Yeesu ka tii, “Ma unə, ŋga *duuniyanə nuunə, amma ma nyi, dadagyə shi nyi. Agi duuniyanə shigi unə, amma ma nyi, əntaa agi duuniyanə shigi nyi. ");
INSERT INTO gde_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Ci fii unə bii nyi koonə ka məətənə nuunə agi 'waslyakəənə goonə. Maɗa pooshi unə vii gooŋga oo'i nyi nə əndə daga ŋukə, weewee ka məətənə nuunə agi 'waslyakəənə goonə.” ");
INSERT INTO gde_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Wata əŋki tii ka ci, “Wu daa nə ha?” Yeesu a ba ka tii, “Nyi nə əndətə njii kya ba koonə daga ka 'watəginə. ");
INSERT INTO gde_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Tə'i uushi'inə laŋə ətə idəpaa nyi ashuunə, ətə bahə nya lagi koonə gəŋwanə agyanəkii. Amma, ma Əndətə sləkee ka nyi, əndə gooŋga nə ci. Ma nya, see sətə fii nyi da makii banəki ka *duuniya.” ");
INSERT INTO gde_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Pooshi tii paaratəgi oo'i agyanə Dii nə Yeesu ka waɓənə ka tii. ");
INSERT INTO gde_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Wata əŋki ci ka tii, “Maɗa kə maɗee unə ka *Uuzənə ŋga ənda, ka shiinə nuunə oo'i, nyi nə əndə daga ŋukə. Davə shiinuunə oo'i, pooshi uushi cii kya ɗa də baawəɗaaki, amma see sətə bii Daadə banəki ka ənja. ");
INSERT INTO gde_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Ləɓə niinə da Əndətə sləkee ka nyi əsə, pooshi ci bwasee ka nyi daanəki, acii ma nya, taa guci patə ha'ə nə nyi ka slənə sətə ca kaɗeesəkə ka ci.” ");
INSERT INTO gde_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Makə fii ənji uushi'iitə baabii Yeesu, laŋə nə ənjitə vii ka ci gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Wata əŋki Yeesu ka ənjitə vii ka ci gooŋga, “Maɗa kə nə'utə unə dzəgunənaaki, ka ndzaanə nuunə ka lyawarənaaki ŋga tantanyinə. ");
INSERT INTO gde_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ka shiinə nuunə gooŋga. Gooŋgakii əsə na kavə tuunə ka ndzaanə ka dimuyinə.” ");
INSERT INTO gde_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Əŋki tii ka ci, “Ma inə, jijinyinə ŋga Ibərahiima niinə, pooshi inə sha ɗii mavaanə ka əndə shaŋə. Mi saŋə ɗii cii kwa moo banə oo'i, ka upaanə niinə ndzaanə ka dimuyina?” ");
INSERT INTO gde_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Əŋki Yeesu ka tii, “Tantanyinə cii kya ba koonə, taa wu patə slənyi 'waslyakəənə, mava ŋga 'waslyakəənə nə ci ətsa. ");
INSERT INTO gde_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Ma mava, paa ci ndzaanə ka ŋga ənji yikii ha'ə uudənə əpinaakii. Amma ma uuzənə, kə ndzaa ci ŋga yikii ha'ə uudənə əpinaakii. ");
INSERT INTO gde_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Maɗa kə kavə *Uuzənə ŋga Əntaŋfə tuunə ka ndzaanə ka dimuyinə, ka ndzaanə nuunə ka dimuyinə tanyi. ");
INSERT INTO gde_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Kə shii nyi jijinyinə ŋga Ibərahiima nuunə. Amma wanuunə ka moo ɓələginə tə nyi, acii pooshi unə ka luuvə dzəgunənaaki. ");
INSERT INTO gde_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Ma nyi, agyanə sətə ɓaarii Daadə ka nyi cii kya waɓə. Amma ma unə, sətə bii dəsənuunə koonə cuuna slənə.” ");
INSERT INTO gde_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Əŋki tii ka ci, “Ibərahiima nə dəsəniinə.” Əŋki Yeesu ka tii, “Maci manjeevənə ŋga Ibərahiima nuunə tanyi, kaɗa sətə njii kəya slənə cuuna slənə. ");
INSERT INTO gde_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Ma nyi, gooŋgatə fii nyi acii Əntaŋfə cii kya ba koonə. Amma wanuunə ka moo ɓələginə tə nyi. Pooshi Ibərahiima sha ɗii ha'ə makə ətsa! ");
INSERT INTO gde_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ma unə, sətə ci dəsənuunə a slənə cuuna slənə.” Wata əŋki tii ka ci, “Ma ina, Əntaŋfə ci saakii nə Dəsəniinə rəŋwə dyaŋə. Əntaa mazaguyinə niinə.” ");
INSERT INTO gde_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Əŋki Yeesu ka tii, “Maci Əntaŋfə nə Dəsənuunə tanyi, kaɗa ka uuɗənə nuunə tə nyi, acii daciikii shi nyi, wanyinə ganə əsə. Pooshi nyi shi də baawəɗaaki saaki, amma ci sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Mi pooshi unə agi paaratəginə də sənə cii kya ba koonə kwa? Ma ɗii ha'ə, acii pooshi unə agi sə'watənə una fatə waɓənaaki. ");
INSERT INTO gde_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ma unə, manjeevənə ŋga dəsənuunə nuunə, waatoo *Seetanə. Nə'u sətə ci dəsənuunə a moo kaɗeesəkə koonə əsə. Maɓəələhiinə nə ci daga ka 'watəginə, paa ci sha slənyi gooŋgaanə, acii pooshi gooŋga ashikii. Ndilə ndilə tə sətə ashikii nə patənə ŋga jirakənaakii, acii majirakə nə ci, mapoo tə patənə ŋga jirakənə. ");
INSERT INTO gde_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Amma ma nyi, gooŋga cii kya ba, ci ɗii pooshi unə vii ka nyi gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Wu saŋə agyuunə ca ɓaarii oo'i, kə ɗii nyi 'waslyakəəna? Makə gooŋga waɓi nyi koonə, mi ɗii pooshi unə agi vii ka nyi gooŋga? ");
INSERT INTO gde_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Ma əndə ŋga Əntaŋfə, waɓənə ŋga Əntaŋfə cii kəya luuvə. Ma unə, əntaa ənji ŋga Əntaŋfə nuunə, ci ɗii pooshi unə agi luuvənə əsə.” ");
INSERT INTO gde_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Wata *gayinə ŋga Yahudiinə a jikə ka Yeesu, əŋki tii, “Makə bii inə, ma hə, əndə *Samariya nə hə, əndə ginaaja, əntaa gooŋga bii inə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Əŋki Yeesu ka tii, “Ma nyi, pooshi ginaaji ashiki. Agi ɗuunətənə nə nyi tə Daadə, amma ma unə, pooshi unə agi ɗuunətənə tə nyi. ");
INSERT INTO gde_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Ma nyi, pooshi nyi agi alə ɗuunətənə goonə tə nyi, amma tə'i əndə ca alə ka nyi. Aashiki aashiki cii kəya la gəŋwanə əsə. ");
INSERT INTO gde_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Tantanyinə cii kya ba koonə, ma əndətə nə'utə dzəgunənaaki, paa ci ka əntənə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Əŋki tii ka ci, “Ma ənə ɗii əna, kə shii inə tanyi, tə'i ginaaji ashiku. Kə əntəgi Ibərahiima, kə məətəgi anabiinə əsə, amma wahənə ka banə, taa wu patə nə'utə dzəgunənaaku, paa ci ka əntənə shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Ma dəsəniinə Ibərahiima, kə əntəgi ci. Ma nə hə ka banə, kə palee hə ka Ibərahiima kwa? Kə məətəgi anabiinə əsə. Wu saŋə nə hə naakwa?” ");
INSERT INTO gde_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Əŋki Yeesu ka tii, “Maci ɗuunətənə cii kya ɗuunətə naaki na, kaɗa ka ndzaanə ka uushi zaɓə. Ma əndətə ca ɗuunətə tə nyi, ci nə Daadə, əndətə bii unə ci nə Əntaŋfə goonə. ");
INSERT INTO gde_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Pooshi unə shii tə ci, amma ma nyi, kə shii nyi tə ci. Maci ma bii nyi mashiimə nyi tə ci, kaɗa majirakə nə nyi makə noonə. Amma kə shii nyi tə ci, agi nə'utənə nə nyi waɓənaakii əsə. ");
INSERT INTO gde_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ma dəsənuunə Ibərahiima, kə ɗii ci mooɗasəkə oo'i, ka neenə nə ci ka shinaaki. Kə nee ci boo, kə ɗii ci mooɗasəkə əsə.” ");
INSERT INTO gde_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Wata əŋki tii ka ci, “Wiitsə paa hə mbu'i taa fəzə tufə pu'unə! Iitiitə saŋə mbee hə ka neenə ka Ibərahiima?” ");
INSERT INTO gde_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Yeesu a ba ka tii, “Tantanyinə cii kya ba koonə, tə'i nyi taabu'u pwayi ənji tə Ibərahiima.” ");
INSERT INTO gde_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Makə fii tii ha'ə, wata təya ɗəmə faariinə kaa təya kaala tə ci, amma wata Yeesu a rarə'igi ahada ənja, ca dəməgi saakii asəkə yi ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Ma Yeesu a dzə də wiigi'inə, wata ca lapaa muurəfa. Ma ca, daga poonə tə ci nə ci moorəfəkii. ");
INSERT INTO gde_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Wata lyawarənaakii a ləgwa ka ci, əŋki tii, “Maləma, ya əndətsə pwayi ənji tə ci moorəfəkəya, wu saŋə ɗii 'waslyakəəna? Ci saŋə nii, anii ənjitə pwayi tə ca?” ");
INSERT INTO gde_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Yeesu a ba ka tii, “Ma uurəfənaakii, əntaa putə ŋga 'waslyakəənaakii taa ŋga ənjitə pwayi tə ci. Ma ɗii ci moorəfəkii, kaa ənjə a shii neenə ka ŋgeerənə ŋga Əntaŋfə ca slənə ashikii. ");
INSERT INTO gde_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Ma amə, makə ɗii ci doosərə, tyasə see a ɗaamə slənə ŋga Əndətə sləkee ka nyi. Maɗa kə shi vəɗa, pooshi əndə ca slənə. ");
INSERT INTO gde_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Ma nyi ma'ə a duuniya, ɓərənə ka duuniya nə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Makə bagi Yeesu ha'ə, wata ca gwaŋaanə, ca tifəvə giirənə aa panə, ca hwaɗətə də hanyinə, ca ŋgərə, ca lərəɓəvə aagi muurəfəta, ");
INSERT INTO gde_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","ca ba ka muurəfəta, “Duu aama ma'inə ŋga Siiloomə, ha yiɓəgi ginəku davə.” (Ma Siiloomə, makə bana, ‘Sləkeenə’). Wata əndətə a palə, ca dzə ka yiɓəgi ginəkii, ca ənya saakii, ca dzə də nee ka ha. ");
INSERT INTO gde_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Ma guvayinaakii da patənə ŋga ənjitə sha nee ka ci ca kədii, kə laaguyi tii ahadatii, əŋki tii, “Əntaa əndətsə izee ka ndzaanə ka kədiinə ətsə nii?” ");
INSERT INTO gde_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Əŋki hara ənji, “Ci ətsa.” Amma əŋki hara ənji, “Pooshi, əntaa ci ətsa, pushashinə pushashi tii.” Wata əŋki əndəkii ci saakii, “Nyi əna.” ");
INSERT INTO gde_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Wata təya ləgwa amakii, əŋki tii, “Iitə ɗii daa cii kwa nee ka ha əndzə'ya?” ");
INSERT INTO gde_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Əŋki ci ka tii, “Əndətə ɗii ləməkii Yeesu hwaɗətə hanyinə; ca lərəɓəvə aagiki, əŋki ci ka nyi, wa nya dzə ka yiɓəgi ginəki agi ma'inə ŋga Siiloomə. Wata nya palə, pii makə yiɓəgi nyi, wata nya nee ka ha.” ");
INSERT INTO gde_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Təya ləgwa ka ci, əŋki tii, “Maana?” Ca ba ka tii, “Mashiimə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Wata təya ŋgərə tə əndətə nji moorəfəkii, təya kərə tə ci aaɓii Farisanyinə. ");
INSERT INTO gde_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Ma uusəratə hwaɗətə Yeesu hanyinə, ca wunəgi də ginə ŋga muurəfəta, *uusəra ŋga əpisəka. ");
INSERT INTO gde_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Wata Farisanyinə a ənə ka ləgwanə ka əndətə taa iitə ɗii upaa ci nee ka ha. Ca ba ka tii, “Hanyinə hwaɗətə ci, ca lərəɓəvə aagiki, nya yiɓəgi ginəki, wanyinə ka neenə ka ha əndzə'i əna.” ");
INSERT INTO gde_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Wata əŋki hara Farisanyinə, “Ma əndətsa, əntaa dacii Əntaŋfə shi ci, acii paa ci agi nə'utə bariya ŋga uusəra ŋga əpisəka.” Amma əŋki hara ənji natii, “Iitiitə daa mbeenə ma'waslyakə əndə ka slənə tsarə ŋga hurəshishiitsa?” Kə ɗii təəkənə ŋga ma ahadatii. ");
INSERT INTO gde_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Wata təya ənə ka ləgwanə ka əndətə nji moorəfəkii, əŋki tii, “Makə kə bii hə, kə wunəgi ci ka hə ginəku, wu nə ci banəkwa?” Ca ba ka tii, “Ma ca, *anabi nə ci.” ");
INSERT INTO gde_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Amma pooshi Yahudiinə luuvə oo'i, moorəfəkii shi ca nji, see də makə 'wii tii tə ənjitə pwayi tə ci. ");
INSERT INTO gde_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","Təya ləgwa ka tii, əŋki tii, “Ya əndətsa, uuzənə goonə nii? Ma bii unə, moorəfəkii pwayi unə tə ci. Iitə ɗii cii kəya nee ka ha?” ");
INSERT INTO gde_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Wata təya ba ka tii, “Kə shii inə uuzənə geenə ətsa, moorəfəkii pwayi inə tə ci əsə. ");
INSERT INTO gde_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amma taa iitə ɗii cii kəya nee ka ha ŋga ənəna, pooshi inə shii. Pooshi inə shii əndətə wunəgi ka ci ginəkii əsə. Ləgwamə amakii. Amə matanə nə ca, ka mbeenə nə ci ka batənə koona ci saakii.” ");
INSERT INTO gde_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Ma waɓi tii ha'ə, ŋgwalii tii acii *gayinə ŋga Yahudiinə, acii ma Yahudiinə, kə bii tii oo'i, taa wu patə bii, Mataɗəkii ŋga Əntaŋfə nə Yeesu, ka laakəginə nə ənji tə ci asəkə *kuvə də'wa. ");
INSERT INTO gde_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ci ɗii bii tii, matanə nə ci, ləgwamə amakii. ");
INSERT INTO gde_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Wata Farisanyinə a ənə ka 'wanə ka bəra'inə tə əndətə nji moorəfəkii, təya ba ka ci, əŋki tii, “Waɓuu keenə ahadoonə da Əntaŋfə tə sətə ɗii. Ma inə, kə shii inə, ma əndətsa, ma'waslyakə əndə nə ci.” ");
INSERT INTO gde_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ca ba ka tii, “Taɗa ma'waslyakə əndə nə ci, paa nyi shii. Uushi rəŋwə shii nyi, ma ŋga ŋukə, moorəfəkii nji nyi, amma wanyinə ka neenə ka ha ŋga əna.” ");
INSERT INTO gde_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Wata təya ləgwa ka ci, əŋki tii, “Iitə saŋə ɗii ca? Iitə ɗii ci wunəgi ci ka hə ginəkwa?” ");
INSERT INTO gde_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Əŋki ci ka tii, “Kə bagi nyi koonə kə dzəgi, amma kə təkuree unə ka luuvənə. Ka mi ɗii cuuna ənə ka ləgwana? Mbu'u ŋga'ə koonə noonə nə ndzaanə ka lyawarənaakii kwa?” ");
INSERT INTO gde_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Wata təya wazə agyanəkii, əŋki tii ka ci, “Hə nə *lawarə ŋga əndətsa, amma ma inə, lyawarənə ŋga Muusa niinə. ");
INSERT INTO gde_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ma Muusa, kə shii inə kə waɓi Əntaŋfə ka ci, amma ma əndətsa, taa hatə shi ci davə mashiimiinə!” ");
INSERT INTO gde_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Əŋki əndəta, “Una! kə ɗii sənə ka sə ŋga hurəshishinə! Iitə ɗii daa mashiimuunə hatə shi ci dava? Yoo, waanə kə wunəgi ginəkya? ");
INSERT INTO gde_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Kə shii amə oo'i, ma Əntaŋfə, paa ci ka fanə tə ma'waslyakə ənda, see tə ənjitə ca fa tə ci, təya slənə sətə cii kəya moo. ");
INSERT INTO gde_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Makə tagii Əntaŋfə duuniya dəŋə ka əndzə'i, pooshi əndə sha fii kə wunəgi ənji ginə ŋga muurəfa. ");
INSERT INTO gde_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Maci ma əndətsa, əntaa dacii Əntaŋfə shi ca, kaɗa pooshi uushi cii kəya mbee ka ɗanə.” ");
INSERT INTO gde_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Əŋki tii ka ci, “Agi 'waslyakəənə pwayi ənji tə hə, agikii girə hə əsə, amma wahənə ka moo dzəgunənə keenə nii?” Wata təya laakəgi tə ci asəkə kuvə də'wa. ");
INSERT INTO gde_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Makə fii Yeesu, kə lyaakagi ənji tə əndətə asəkə kuvə də'wa, ca alətə tə əndəta, ca ləgwa ka ci, əŋki ci, “Kə vii hə gooŋga ka Uuzənə ŋga əndə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Əŋki əndəta, “Wu nə ci daa, Daada? Bawə ka nyi, kaa nya shii vii ka ci gooŋga.” ");
INSERT INTO gde_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Yeesu a ba ka ci, “Kə nee hə ka ci. Ci ca waɓə da hə əndzə'i.” ");
INSERT INTO gde_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Əŋki əndətə ka Yeesu, “'Ya'ə Slandana, kə vii nyi ka hə gooŋga.” Wata ca gərə'waanə akəŋwacii Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Əŋki Yeesu, “Ma shi nyi aasəkə duuniyana, ka ɗa gəŋwanə, kaa muurəfinə a mbee ka neenə, ma ənjitə da ginə əsə, təya uurəfəgi.” ");
INSERT INTO gde_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Tə'i hara Farisanyinə aɓiikii fii ca ba ha'ə. Wata əŋki tii ka ci, “Kə ndzaa ci muurəfinə niinə ətsə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Yeesu a ba ka tii, “Maci muurəfinə nuunə, kaɗa pooshi 'waslyakəənə ashuunə. Amma makə agi banə nuunə oo'i, ka neenə nuunə ka ha, tə'i 'waslyakəənə ashuunə.” ");
INSERT INTO gde_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Əŋki Yeesu ka tii, “Tantanyinə cii kya ba koonə, taa wu patə gimə aasəkə kuvə bagiinə, maɗa əntaa da makuvə gimə ci, mahərə nə ci, taa əndə ɗa maabə nə ci ətsa. ");
INSERT INTO gde_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Ma əndətə gimə da makuvə, ci nə magəra ŋga bagiinə. ");
INSERT INTO gde_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Ma ca, ka wunəginə nə əndə nəhə makuvə ka ci makuva, ka fanə nə bagiinaakii uurakii, ca 'wa tə tii ka ləmə ka ləma, ca gimagi də tii agyə. ");
INSERT INTO gde_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Maa kə gimagi ci də tii patə, ka tanə nə ci ka tii kəŋwanə, təya dzə də nə'unə tə ci, acii kə shii tii uurakii. ");
INSERT INTO gde_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ma əndə'i əndə pamə, pooshi tii ka nə'unə. Huyinə huyinətii aciikii, acii pooshi tii shii uura ŋga hara ənja.” ");
INSERT INTO gde_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Kə bii Yeesu ka tii ətsə misaali, amma ma təya, pooshi tii paaratəgi də sətə cii kəya moo banə. ");
INSERT INTO gde_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","Wata Yeesu a ənə ka banə ka tii, əŋki ci, “Tantanyinə cii kya ba koonə, ma nyi, makə makuvə ŋga bagiinə nə nyi. ");
INSERT INTO gde_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Patənə ŋga ənjitə shi taabu'u shinaaki, mahiirənə taa ənji ɗa maabə nə tii, pooshi bagiinə fii tə tii. ");
INSERT INTO gde_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Makə makuvə nə nyi. Taa wu patə shi daɓiiki, ka upaanə nə ci luupaanə. Ka gimagərənə nə ci, ca ənə ka dəməginə makə sətə kaɗeesəkə ka ci, ka upaanə nə ci zəmə əsə. ");
INSERT INTO gde_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Ma shinə ŋga mahəra, kaa ca shii hərənə, ca ɓələgi slanda uushi, ca saawee ka səkii. Ma shi nyi, kaa ənjə a shii upaa əpinə. Waatoo, patənə ŋga əpiitə dəɓee təya upaa ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","“Ma nyi, ŋunyi magəra nə nyi. Ma ŋunyi magəra, matasəkakii nə ci ka əntəginə ka putə ŋga bagiinə. ");
INSERT INTO gde_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Ma magəra zala, əntaa naakii nə bagiinə. Maɗa kə nee ci ka furətsoofa ca shi aagi bagiinə, ka bwaseenə nə ci ka tii, ca huyi saakii. Wata furətsoofa a kəəsə bagiinə, ca taakee ka tii. ");
INSERT INTO gde_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Ma huyipaa magəratə saakii, acii əntaa naakii nə bagiinə. Pa ca ka nəkii ka tii shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","15","Nyi nə ŋunyi magəra. Makə sətə shii Daadə tə nyi, nya shii tə ci, ha'ə əsə shii nyi tə bagiinaaki, təya shii tə nyi. Matasəkakii nə nyi ka əntənə ka putatii. ");
INSERT INTO gde_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Tə'i hara bagiinaaki ətə pooshi asəkə kuva. Ma təya, tyasə see a aalyatə nyi tə tii aasəkə kuva əsə. Ka fatənə nə tii uuraki, təya ndzaa ahada harakii, magəra rəŋwə a gəra tə tii. ");
INSERT INTO gde_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","“Putə ŋga ətsə ha'ə uu'i Daadə tə nyi, acii matasəkakii nə nyi ka vigi əpinaaki, aa nya shii ənənə ka luunə saaki. ");
INSERT INTO gde_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Pooshi əndə ŋgərəgi əpinaaki, nyi saaki mwayi viginə. Tə'i nyi da baawəɗa ŋga viginə, tə'i nyi da baawəɗa ŋga ənənə ka ŋgərətənə əsə. Ətsə nə sətə kavə Daadə tə nyi ka ɗanə!” ");
INSERT INTO gde_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Putə ŋga waɓəətsə əsə, kə shigi təəkəshinə ahada Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Laŋə ahadatii bii, “Əndə ginaaji nə əndətsa, maba nə ci. Ka mi cuuna fa sətsə cii kəya ba koona?” ");
INSERT INTO gde_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Amma kə bii hara ənji, “Ma əndətə da i ginaaji ashikii, paa ci ka waɓənə makə ətsa. Iitiitə saŋə mbeenə ginaaji ka wunəgi ginə ŋga muurəfa?” ");
INSERT INTO gde_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Ma ətsə də məgəviinə, kə mbu'ya kumənə ŋga buurətənə də uusəratə ənyi ənji ka haɗatəginə də *yi ŋga Əntaŋfə də Urusaliima əsə. ");
INSERT INTO gde_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Yeesu a wiigi'i atsaa malaɓa ŋga Sulayimaanu asəkə yi ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Wata ənjə a dzatə də nə aɓiikii, təya ləgwa amakii, əŋki tii, “Ca'ə guci ndzaaniinə ka gəranə a maku, kaa ha ba keenə taa wu nə hə kwa? Bagi keenə paŋgəraŋə, hə nə *Mataɗəkii ŋga Əntaŋfə nii?” ");
INSERT INTO gde_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Yeesu a ba ka tii, “Kə bagi nyi koonə daga ŋukə, amma pooshi unə luuvə. Ma uushi'iinə cii kya slənə də baawəɗa ŋga Daadə, ci ca waɓə ka madəɓa maki. ");
INSERT INTO gde_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amma ma unə, pooshi unə vii ka nyi gooŋga, acii əntaa bagiinaaki nuunə. ");
INSERT INTO gde_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Ma bagiinaaki, agi fanə nə tii uuraki, kə shii nyi tə tii, təya nə'u tə nyi əsə. ");
INSERT INTO gde_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ka viinə nə nyi ka tii əpinə ŋga ca'ə ndəŋwə ndəŋwə, paa tii ka zanə shaŋə, pooshi əndə luutənə tə tii aciiki. ");
INSERT INTO gde_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Ma Daadə ətə vii tə tii ka nyi, kə palee ci ka patənə ŋga uushi'inə. Pooshi əndə luutənə tə tii acii Daadə. ");
INSERT INTO gde_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Ma inə da Daadə, uushi rəŋwə niinə.” ");
INSERT INTO gde_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Makə fii ənji waɓi Yeesu ha'ə, wata təya fəɗə faariinə kaa təya kaala tə ci. ");
INSERT INTO gde_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Əŋki ci ka tii, “Ŋunyi uushi'inə laŋə slənyii akəŋwacii unə. Ma uushi'iitsa, Daadə vii ka nyi baawəɗa ŋga ɗanə. Putə ŋga ŋgutə rəŋwə agi uushi'iitsə ɗii cuuna moo kaalanə tə nya?” ");
INSERT INTO gde_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Əŋki tii ka ci, “Əntaa putə ŋga ŋunyi slənənyinaaku ciina moo kaalanə tə hə, amma putə ŋga bərapaanaaku tə Əntaŋfə. Əndə shiŋkinə nə hə tanə, amma wahənə ka moo geeginə ka naaku nə makə Əntaŋfə!” ");
INSERT INTO gde_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Əŋki Yeesu ka tii, “Tə'i manaahəkii asəkə ləkaləkatə ŋga bariya goonə oo'i, ma bii Əntaŋfə, ma unə, əntaŋfənyinə nuunə. ");
INSERT INTO gde_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Yoo, kə shii amə oo'i, ma sətə bii malaaɓa ləkaləkatə, gooŋga ka ca'ə ndəŋwə ndəŋwə. Makə kə bii Əntaŋfə ka ənjitə luuvə waɓənaakii oo'i əntaŋfənyinə nə təya, ");
INSERT INTO gde_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","iitə ɗii ba nuunə, agi waɓənə nə nyi bwayakii aashi Əntaŋfə, makə bii nyi oo'i *Uuzənə ŋga Əntaŋfə nə nya? Acii ma nyi, Daadə ta'i tə nyi, ca sləkee ka nyi aasəkə duuniya. ");
INSERT INTO gde_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Maɗa pooshi nyi agi slənə uushi'iitə mwayi Daadə nya slənə, goona vii ka nyi gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amma makə agi slənə nə nyi uushi'iitsa, taa ŋgahi pooshi unə vii ka nyi gooŋga, kə dəɓee una vii gooŋga ka slənənyinaaki, koona shii mbee ka paaratəginə oo'i, ashiki nə Daadə, nyi əsə, ashikii nə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Makə fii tii waɓi ci ha'ə, wata təya ənə ka ɗa gazhi'waanə ŋga kəsənə tə ci, amma wata ca itəgi saakii ahada ənja. ");
INSERT INTO gde_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Ca ənə ka taŋəginə aataŋəgi gəərə ŋga Urədunə, hatə nji Yoohana a ɗa bapətisəma ka ənja. Ca ndzaa davə. ");
INSERT INTO gde_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Ənji laŋə gi aaɓiikii. Əŋki tii ahadatii, “Ma Yoohana, pooshi ci ɗii sə ŋga hurəshishinə, amma patənə ŋga sətə baabii ci agyanə əndətsa, gooŋga.” ");
INSERT INTO gde_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ənji laŋə əsə vii ka ci gooŋga gatə. ");
INSERT INTO gde_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Tə'i əndə'i əndə ɗii ləməkii Lazarusə, gwakə ka bwanea nə ci. Ma ca, əndə vəranə ŋga Bayitaniya nə ci. Davə də vəra nə ci tii da cikəŋushi'inəkii, waatoo Mariyaama tii da Marəta. ");
INSERT INTO gde_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Ma Mariyaama, ki sha əjivə urədya ŋga malaŋə kwaɓa aaba'ə səɗə Yeesu, kya taaɗəgi də shiŋkinə ŋga nətə. Ndzəkəŋuci nə əndə gwakə, waatoo, Lazarusə. ");
INSERT INTO gde_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Wata cikəŋushi'iitə bəra'i a sləkee ka waɓənə ka Yeesu də banə oo'i, “Slandana, gwakə nə kaɗashinaaku.” ");
INSERT INTO gde_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Makə fii Yeesu ha'ə, wata əŋki ci, “Ma muudinə ŋga gwakənə ŋga Lazarusə, əntaa əntənə nii kəya əntə. Ma gwakəətsa, ka vii də ɗuunuunə ka Əntaŋfə. Də ha'ə əsə nə *Uuzənə ŋga Əntaŋfə a upaa ɗuunuunə.” ");
INSERT INTO gde_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Kə uu'i Yeesu tə i Marəta tii da cikəŋuci ba'ə Lazarusə. ");
INSERT INTO gde_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Patə da ha'ə, makə fii ci habara ŋga gwakənaakii, kə baa ci bəra'i zəku'i. ");
INSERT INTO gde_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Ma daba'əkii wata əŋki ci ka lyawarənaakii, “Ənaamə aa Yahudiya.” ");
INSERT INTO gde_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Əŋki lyawarənaakii ka ci, “Maləma, ma'ə mata'avəmə makə mwayi ənjitə davə kaalanə tə hə də faariinə. Yoo, wahənə ka moo ənənə aadəvə nii?” ");
INSERT INTO gde_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Əŋki Yeesu ka tii, “Tə'i tibisənyinə pu'u aji bəra'i agi ka uusəra. Taa wu patə ca wii doosərə, paa ci ka kulanə, acii agi ɓərənə nə uusəra ka ci a rəgwa. ");
INSERT INTO gde_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amma maɗa kə wii ci davəɗə, ka kulanə nə ci acii pooshi ɓərənə aciikii.” ");
INSERT INTO gde_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Makə bagi Yeesu ətsa, ca tsakə waɓənə, əŋki ci, “Ma guvaamə Lazarusə, kə kulii ci aa ŋunyi. Amma ka dzənə nə nyi ka maɗeenə ka ci.” ");
INSERT INTO gde_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Əŋki lyawarənaakii ka ci, “Slandana, maɗa ka ŋunyinə nə ci, ka mbəɗənə nə ci.” ");
INSERT INTO gde_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Ma Yeesu, ma mwayi ci banə ka tii, kə əŋki Lazarusə, amma ma nə tii ka nəhənə, ŋunyinə saakii cifə ci. ");
INSERT INTO gde_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Wata Yeesu a bagi ka tii paŋgəraŋə, əŋki ci, “Ma Lazarusə, kə əŋki ci. ");
INSERT INTO gde_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","Amma kə ɗii nyi mooɗasəkə ka putə goonə makə pooshi nyi aɓiikii, koona shii vii gooŋga ka nyi. Dzaamə aahakii.” ");
INSERT INTO gde_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Tooma ətə ci ənjə a 'wa tə ci “Huyirənə” a ba ka hara *lyawarənə makə ci, “Palaamə da i maləma kaama shii əntənə da i ci!” ");
INSERT INTO gde_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Mbu'unə ŋga Yeesu aadəvə, ma gi ci ka lanə, kə uugi Lazarusə baanə ənfwaɗə makə ŋgəɗəgi ənji tə ci. ");
INSERT INTO gde_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Ma vəranə ŋga Bayitaniya, kə mbu'i bahə kiloomeeta makkə ahadatii da Urusaliima. ");
INSERT INTO gde_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","Laŋə əsə nə *Yahudiinə ətə shi ka nəhəpaanə tə i Marəta tii da Mariyaama putə ŋga əntənə ŋga ndzəkəŋushi'inətii. ");
INSERT INTO gde_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Makə fii Marəta oo'i, agi shinə nə Yeesu, kə dəməgi ki agyə ka guŋyanə da ci a rəgwa. Amma ma Mariyaama, kə ənəgi ki asii. ");
INSERT INTO gde_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Gəŋunatə da ci, wata əŋki ki ka ci, “Slandana, maci ganə nji hə ɗii, kaɗa pooshi ndzəkəŋunəki əŋki! ");
INSERT INTO gde_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amma kə shii nyi, taa əndzə'i ka ɗanə nə Əntaŋfə ka hə taa mi patə kədii hə aciikii.” ");
INSERT INTO gde_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Əŋki Yeesu ka ki, “Ka maɗənə nə ndzəkəŋu da i əpinə.” ");
INSERT INTO gde_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","Əŋki ki ka ci, “Kə shii nyi, ka maɗənə nə ci da i əpinə uusəra ŋga muudinə ŋga duuniya.” ");
INSERT INTO gde_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Əŋki Yeesu ka ki, “Nyi nə əndə maɗeenə ka ənjə a gu'u, nyi nə əndə vii ka tii əpinə əsə. Taa wu patə vii ka nyi gooŋga, ka upaanə nə ci əpinə taa kə əŋki ci. ");
INSERT INTO gde_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Taa wu əsə nə əndə da i əpinə, ca vii ka nyi gooŋga, paa ci ka əntənə shaŋə. Kə vii hə gooŋga oo'i, ka ɗanə ha'ə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Əŋki ki ka ci, “Awa Slandana. Kə vii nyi gooŋga oo'i, hə nə Mataɗəkii, Uuzənə ŋga Əntaŋfə ətə bii Əntaŋfə kadə na shi aa duuniya.” ");
INSERT INTO gde_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Makə uugi Marəta baginə ha'ə, wata kya ənəgərə aasii, kya dzə ka 'waginə tə Mariyaama cikəŋuci aa taŋgala, əŋki ki ka ki, “Kə shi Maləma, agi ləgwanə nə ci tə hə.” ");
INSERT INTO gde_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Makə fii Mariyaama ha'ə, wata kya maɗə, kya palə də kwasənə ka dzənə ka lanə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Ma ka saa'ita, ma'ə Yeesu mambu'umə aasəkə vəranəkii, ma'ə ci ka hatə lii Marəta tə ci. ");
INSERT INTO gde_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Ənjitə gi ka nəhəpaanə tə Mariyaama asii, makə nee tii maɗətə ki, kya palə də kwasənə, wata təya nə'u tə ki. Ma nə tii ka nəhənə, taa aanə gu'u nə ki ka palənə ka tuunə davə. ");
INSERT INTO gde_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Wata Mariyaama a mbu'u ka hatə ɗii Yeesu davə. Makə nee ki ka ci, wata kya kulagi atsaa səɗəkii, əŋki ki, “Slandana, maci ganə nji hə, kaɗa pooshi ndzəkəŋunəki əŋki.” ");
INSERT INTO gde_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Makə nee Yeesu ka Mariyaama kya tuu, ca nee makə sətə ci hara ənjitə aɓitə a tuu əsə, kə kulii aasəkəkii ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Ca ləgwa ka tii, əŋki ci, “Da saŋə ŋgəɗəgyuunə tə ca?” Əŋki tii ka ci, “Shiwa nda nee Slandana.” ");
INSERT INTO gde_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Kə kiwə Yeesu əsə. ");
INSERT INTO gde_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Wata əŋki ənji, “Neemə makə sətə uu'i ci tə ci.” ");
INSERT INTO gde_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amma ma hara ənji, kə bii tii, “Kə mbee ci ka wunəgi ginə ŋga muurəfinə. Aa mi ɗii paa ci təŋagi tə Lazarusə ka əntəna?” ");
INSERT INTO gde_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Fanaakii ha'ə, kə ənyi ka kulagərənə aasəkəkii əsə, wata ca palə aanə gu'ukii. Ma gu'ukəya, ɓurəha da i faara amakii. ");
INSERT INTO gde_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Əŋki Yeesu ka tii, “Ŋgərəgimə faaratsə amakii.” Əŋki Marəta cikəŋuci mantə əndətsa, “Slandana, kadə na zənə, acii kə uugi ci baanə ənfwaɗə ənə makə ŋgəɗəgi ənji!” ");
INSERT INTO gde_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","Əŋki Yeesu ka ki, “Paa nyi bii ka hə oo'i, maɗa vii hə gooŋga, ka neenə nə hə ka ɗuunuunə ŋga Əntaŋfə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Wata təya ŋgərəgi faarakii. Yeesu a tsaamə aadəgyə, əŋki ci, “Daada, kə kuyirii nyi tə hə acii agi fanə nə hə tə nyi. ");
INSERT INTO gde_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Ma nyi, kə shii nyi, agi fanə nə hə tə nyi taa guci patə. Amma ma cii kya ba əna, ka putə ŋga ənjinə ganə, kaa təya shii vii gooŋga oo'i, hə sləkee ka nyi.” ");
INSERT INTO gde_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Makə uugi ci baginə ha'ə, wata ca maɗee ka uurakii ka 'wanə, əŋki ci, “Lazarusə gimagi!” ");
INSERT INTO gde_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Wata ca gimagi. Mafuuɗəkii nə ciinəkii da səɗəkii patə da i dara wa agikii. Əŋki Yeesu ka tii, “Pərəgimə tə ci, kaa ca mbee ka wiinə.” ");
INSERT INTO gde_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Ma ənjitə shi ka nəhəpaanə tə Mariyaama, kə nee tii ka sətə ɗii Yeesu, laŋə ahadatii vii ka ci gooŋga əsə. ");
INSERT INTO gde_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amma ma hara ənji, kə ənyi tii aaɓii *Farisanyinə, təya dzə ka ba ka tii sətə ɗii Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Wata Farisanyinə da madiigərə limanyinə a ɗa mətərəkinə, əŋki tii, “Iitə ɗanaama? Tsaaməmə ka sə ŋga hurəshishiitsə ci əndətsə a ɗaaɗa! ");
INSERT INTO gde_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Maɗa kə bwasee amə ka ci ca ɗaaɗa ha'ə, ka viinə nə patənə ŋga ənji ka ci gooŋga. Maɗa kə fii gayinə ŋga ənji Rooma əsə, ka shinə nə tii, təya waalagi yi ŋga Əntaŋfə gaamə, təya saawee ka hanyinə gaamə!” ");
INSERT INTO gde_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Tə'i əndə'i əndə agitii ɗii ləməkii Kayafasə, ci nə gawə ŋga limanyinə agi ətə fəza. Əŋki ci ka tii, “Ya saŋə mabiinə nuunə kwa? ");
INSERT INTO gde_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Pooshi unə paaratəgi oo'i, gəɗə əntənə ŋga əndə rəŋwə putə ŋga ənji patə, acii zamaginə də patənə ŋga hanyinə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Weewee ma sətə cii kəya ba, əntaa ŋga ənfunəkii, amma makə ɗii ci ka gawə ŋga limanyinə agi ətə fəza, anabaakwaanə cii kəya ɗa oo'i, ka əntənə nə Yeesu ka putə ŋga *Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Əntaa wata ŋga Yahudiinə tanə, amma ka putə ŋga ənji ŋga Əntaŋfə taa da patə, kaa təya ndzaanə ka ədzəmə rəŋwə. ");
INSERT INTO gde_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Uusərakii 'watəgi *gayinə ŋga Yahudiinə alə rəgwa ŋga ɓələnə tə Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","Acii ha'ə, ma Yeesu, paa ci ənyi ka wiinə paŋgəraŋə ma'ə anə hanyinə ŋga Yahudiya, amma ca maɗə, ca palə saakii ka əndə'i ha kədəhə da bilinə, waatoo əndə'i vəranə ətə ci ənjə a 'wa Ifərami. Davə ndzaa tii da lyawarənaakii. ");
INSERT INTO gde_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Mbəshanə ŋga kumənə ŋga Pasəka, kə ma'i ənji laŋə anə hanyinatii, təya palə aa Urusaliima ka laaɓagi natii na, taabu'u mbu'yanə kumənəkii. ");
INSERT INTO gde_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","Təya dzə də alənə tə Yeesu. Ma təya dza də nə asəkə yi ŋga Əntaŋfə əsə, kə laaguyi tii ahadatii, əŋki tii, “Iitə nee unə noona? Weewee paa ci ka shinə ka kuməəna, anii ka shinə nə ca?” ");
INSERT INTO gde_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Ma ləguyi tii ha'ə, acii kə baabagi madiigərə limanyinə da Farisanyinə oo'i, taa wu patə shii hatə ɗii Yeesu davə, wa ca shi ka banə, kaa ənjə a shii dzənə ka kəsənə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Ma ətsə mbəɗaanə baanə kuwa kaa ənjə a ɗa kumənə ŋga *Pasəka, kə gi Yeesu aa Bayitaniya, vəranə ŋga Lazarusə əndətə shi ca maɗee ka ci agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Makə mbu'i ci aadəvə, kə jigə ənji ka ci zəmə ŋga kədəwanə. Ma Marəta, kə cakə ki tə tii agi təkə zəməkii. Ma Lazarusə, rəŋwə nə ci agi ənjitə ndzaanə ka ha rəŋwə da Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","Wata Mariyaama a ŋgərə əbwə urədya. Ma urəditsa, ŋga malaŋə kwaɓa acii də ba ŋga “narədi” dii ənji. Kya əjivə aaba'ə səɗə Yeesu, kya taaɗəgi də shiŋkinə ŋga nətə. Wata mədədəranə ŋga urədyakii a nagi yikii də zənənə. ");
INSERT INTO gde_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Tə'i əndə'i lawarə ŋga Yeesu, waatoo Yahuda Isəkariyoota ətə ma uudəpaa ba'a, ci vii tə Yeesu ka kəsənə. Kə bii ci, ");
INSERT INTO gde_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Maci ɗərəmaginə ci ənjə a ɗərəmagi də urəditsa, kaɗa ka ɗanə nə kwaɓakii *hwaslə gya'ə makkə, ənjə a təkəpaa ka maaghiinə.” ");
INSERT INTO gde_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Ma bii ci ətsə ha'ə, əntaa hakilanə cii kəya hakila tə maaghiinə, amma acii ɗii ci ka mahəra, makə ɗii ci, ci ca nəhə mbuurə kwaɓatii, ka tanə nə ci, ca tsakə də naakii na. ");
INSERT INTO gde_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Amma əŋki Yeesu, “Bwasee ka ki. Wa kya kapaa sətə aciitə ka uusəra ŋga ŋgəɗənə tə nyi. ");
INSERT INTO gde_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Ma maaghiinə, taa guci patə nə tii aɓii unə, amma ma nyi, pooshi amə ka ndzaanə doonə taa guci.” ");
INSERT INTO gde_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Makə fii daŋkana oo'i, də Bayitaniya nə Yeesu, wata təya dzə aadəvə. Əntaa wata ka alənə tə Yeesu, amma i ka neenə ka Lazarusə ətə maɗee Yeesu agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","Wata madiigərə limanyinə a ɗa rəgwa ŋga ɓələginə tə Lazarusə əsə. ");
INSERT INTO gde_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","Acii da tsa uurakii shigi kaareenə ŋga hara *Yahudiinə laŋə ka tii, təya vii gooŋga ka Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Pukyatə hakii, ma daŋkanatə shi ka kumənə ŋga Pasəka, kə fii tii oo'i, ka shinə nə Yeesu aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Wata təya fəɗə banyinə ŋga dibənuuja, təya palə aaba'ə vəranə ka guŋyanə də ci. Təya ka vurənə, təya ba, “Dəlanə də Əntaŋfə! Wa Əntaŋfə a ɗa barəkaanə ka əndətə shi agi ləmə ŋga Slandana. Wa Əntaŋfə a ɗa barəkaanə ka ŋwaŋwə ŋga *Isərayiila!” ");
INSERT INTO gde_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Ma Yeesu, kə lapaa ci vamənda, ca ndərəvə aaba'əkii, makə sətə bii malaaɓa ləkaləkatə oo'i, ");
INSERT INTO gde_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“Vəranə ŋga *Sihiyoona ga ha ŋgwalə! Waatsə ŋwaŋwaaku ka shinə aba'ə uundzə vamənda.” ");
INSERT INTO gde_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Ma lyawarənaakii, pooshi tii paaratəgi də ətsə daga ka saa'ikii, amma makə maɗee Əntaŋfə ka ci agi maməətə ənja, ca vii ka ci ɗuunuunə, kə buurətə tii oo'i, kə waɓi malaaɓa ləkaləkatə ətsa agyanəkii, ha'ə əsə ɗii tii ka ci. ");
INSERT INTO gde_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Ma ənjitə nji da i Yeesu saa'itə 'wii ci tə Lazarusə asəkə gu'u, ca maɗee ka ci agi maməətə ənja, kə baabii tii ka ənji sətə slənyi. ");
INSERT INTO gde_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","Ci ɗii gi daŋkana ka gəŋunə də ci, acii kə fii tii oo'i, ci sha ɗii sə ŋga hurəshishiitsa. ");
INSERT INTO gde_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Wata *Farisanyinə a ba ahadatii, əŋki tii, “Kə nee unə ɗii, pooshi amə agi jaalanə shaŋə! Tsaaməmə *duuniya patə ca nə'u tə ci!” ");
INSERT INTO gde_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Ma ahada ənjitə gi ka paslənə tə Əntaŋfə agi kuməəta, tə'i hara ənji Gərikə. ");
INSERT INTO gde_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Wata təya shi aaɓii Filibusə, əndə Batəsayida anə hanyinə ŋga Galili, əŋki tii ka ci, “Maləma, ŋga'ə keenə nə neenə ka Yeesu.” ");
INSERT INTO gde_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Filibusə a maɗə, ca dzə ka banə ka Andərawəsə, təya maɗə, təya dzə ka banə ka Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Əŋki Yeesu ka tii, “Kə uugi saa'i mbu'yanə kaa Uuzənə ŋga əndə a upaa ɗuunətənə. ");
INSERT INTO gde_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Tantanyinə cii kya ba koonə, maɗa ləgagərə ənji slikərənə aagi hanyi, ka ɓəsləginə nə ci. Ma daaba'əkii, ca givagi, ca vii hi'u laŋə. ");
INSERT INTO gde_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Ma əndətə uu'i əpinaakii, ka əteenə nə ci ka əpinaakii. Ma əndətə kaaree ka əpinaakii əsə ganə a duuniya, ka kapaanə nə ci əpinəkii ka ca'ə ndəŋwə ndəŋwə. ");
INSERT INTO gde_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Taa wu patə ca moo paslənə tə nyi, tyasə see a nə'u ci tə nyi. Ma əndətə ca paslə tə nyi, taa da ndzaa nyi patə, ka ndzaanə nə ci davə. Taa wu patə ca paslə tə nyi, ka ɗuunətənə nə Daadə tə ci.” ");
INSERT INTO gde_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“Ma nyi, agi mabuurənə nə nyi, mashiimə nyi sə ŋga banə. Maɗa bii nyi, Daada, kasa'əgi ka nyi saa'itsa, pooshi ka ɗanə, acii ka putakii shi nyi, kaa nya shii sa ciɓa. ");
INSERT INTO gde_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Daada, ɓaarii ɗuunuunə ŋga ləməku ka ənja!” Wata əndə'i uura ŋga əndə a waɓya dadagyə, əŋki ci, “Kə uugi nyi ɓaarii ɗuunuunə ŋga ləməki. Ka ənənə nə nyi ka ɓaariinə əsə.” ");
INSERT INTO gde_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","Ma daŋkanatə davə, kə fii tii uura ŋga ənda, wata əŋki hara ənji ahadatii, “Dzanə ŋga vənə ɗii ha'ə.” Əŋki hara ənji natii, “Malaa'ika waɓi da ci!” ");
INSERT INTO gde_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Amma əŋki Yeesu ka tii, “Əntaa ka putaaki də uura ŋga əndətsə fii unə, amma ka putə goonə, kaa ca shii tsakənə tuunə. ");
INSERT INTO gde_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Kə uugi saa'i mbu'yanə ka ɗa gəŋwanə ka *duuniyana. Ka ləwutənə nə ənji ŋwaŋuunə acii ŋwaŋwə ŋga duuniya. ");
INSERT INTO gde_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Ma nyi, maɗa kə maɗee ənji ka nyi aadəgyə, ka tə'yatənə nə nyi patənə ŋga ənji aaɓiiki.” ");
INSERT INTO gde_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Kə bii ci ha'ə kaa ca ɓaarii tsarə ŋga əntəətə nii kəya əntə. ");
INSERT INTO gde_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Əŋki daŋkana, “Ma bariya geenə, kə bii ci keenə, ma *Aləmasiihu, ka ndzaanə nə ci da i əpinə ka ca'ə ndəŋwə ndəŋwə. Iitə ɗii banəku oo'i, tyasə ka maɗeenə nə ənji ka Uuzənə ŋga əndə aadəgya? Wu saŋə nə *Uuzənə ŋga ənda?” ");
INSERT INTO gde_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Wata əŋki Yeesu ka tii, “Ka ta'aveenə nə ɓərənə ahadoonə gi'u. Dəmə aakəŋwa də wiigi'inə goonə agi ɓərənəkii, acii ga təkunə a lapaa tuunə a rəgwa. Acii ma əndətə ca wii agi təkunə, paa ci ka shii hatə cii kəya dzə aadəvə. ");
INSERT INTO gde_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Makə wiitsə ɓərənəkii ahadoonə, viimə ka ci gooŋga koona shii ndzaanə ka ənji ŋga ɓərənə.” Makə bagi Yeesu waɓəətsa, wata ca maɗə, ca dzə ka umbəginə saakii aciitii. ");
INSERT INTO gde_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Taa ŋgahi ka ginətii ɗaaɗii Yeesu patənə ŋga sə ŋga hurəshishinaakii, amma paa tii vii ka ci gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ma təkuree tii ka vii gooŋga, kaa sətə shi anabi Isaaya bii a ndzaa ka gooŋga, ətə bii cii, “Slandana, wu saŋə vii gooŋga ka waɓəətə bii ina? Tə'i əndə nee ka ŋgeerənaaku kwa?” ");
INSERT INTO gde_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Acii ha'ə kə təkuree tii ka vii gooŋga, acii kə bii Isaaya əsə, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Kə uurəfəgi Əntaŋfə tə tii, acii ga təya nee ka uushi'inə. Ca pa'əgi hiimatii acii ga təya paaratəgi də uushi'inə əsə. Əŋki Əntaŋfə, ma ɗii nyi ha'ə, acii ga təya zhi'wagi aaɓiiki, nya mbəɗəpaa də tii.” ");
INSERT INTO gde_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Ma bii Isaaya ətsa, acii kə nee ci ka ɗuunuunə ŋga Yeesu, ca waɓə agyanəkii əsə. ");
INSERT INTO gde_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Taa ŋgahi ha'ə, laŋə agi *gayinə ŋga Yahudiinə vii gooŋga ka Yeesu, amma putə ŋga ŋgwalənə acii *Farisanyinə, pooshi tii nja waɓəgi paŋgəraŋə agyanə Yeesu, acii ga ənjə a lyaakagi tə tii asəkə kuvə də'wa. ");
INSERT INTO gde_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ma təya, gəɗə dəlanə ŋga ənji shiŋkinə kaɗeesəkə ka tii acii dəlanə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Kə maɗee Yeesu ka uurakii ka banə, əŋki ci, “Taa wu patə vii ka nyi gooŋga, əntaa wata ka nyi vii ci gooŋga, amma da i ka Əndətə sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Taa wu patə nee ka nyi, kə nee ci ka Əndətə sləkee ka nyi ətsa. ");
INSERT INTO gde_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Ma nya, makə ɓərənə shi nyi aa duuniya, acii ga taa wu patə ətə vii ka nyi gooŋga, a ndzaanə agi təkunə. ");
INSERT INTO gde_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Maɗa kə fii əndə waɓənaaki, amma paa ci nə'utə waɓənəkii, paa nyi ka ɗa ka ci gəŋwanə də nəki. Ka luupaa ənji shi nyi aa duuniya, əntaa ka ɗa gəŋwanə ka tii. ");
INSERT INTO gde_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Ma əndətə kaaree ka nyi, ca təkuree ka fa waɓənaaki, tə'i əndətə na ɗa ka ci gəŋwanə. Waɓəənə waɓi nyi na ndzaa ka mala gəŋwanaakii uusəra ŋga muudinə! ");
INSERT INTO gde_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Ma ətsa, gooŋga. Acii əntaa də baawəɗaaki cii kya waɓə, amma Daadə ətə sləkee ka nyi bii ka nyi sətə banəki tyasə. ");
INSERT INTO gde_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Kə shii nyi əsə, ma waɓənaakii, ci ca vii əpinə ŋga ca'ə ndəŋwə ndəŋwə ka ənja. Ma sənə bii nyi əsə, ci nə sətə bii Daadə ka nyi kaa nya ba.” ");
INSERT INTO gde_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Ma ətsə mbəɗaanə baanə rəŋwə ka kumənə ŋga *Pasəka, kə shii Yeesu oo'i, kədəhə nə ci ka bwasee ka duuniya, kaa ca ənə aaɓii Dii. Taa guci patə nə ci agi uuɗənə tə ənjitə a duuniya ətə ndzaa ka naakii, kə uu'i ci tə tii ca'ə ka muudinə. ");
INSERT INTO gde_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Ma ətsə kədəwanə, tii agi zəmənə, kə uugi *Seetanə kavənə aa ədzəmə Yahuda Isəkariyoota uuzənə ŋga Simoonə tə viinə tə ci aacii ənja. ");
INSERT INTO gde_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Kə shii Yeesu oo'i, aaciikii ba'avə Əntaŋfə patənə ŋga uushi'inə, kə shii ci oo'i, dacii Əntaŋfə shi ci, aaɓiikii cii kəya ənə əsə. ");
INSERT INTO gde_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Wata ca maɗətə ka ha ŋga ndzaanə, ca səɗəgi əndə'i kəjeerənə ashikii, ca ŋgərə gyara, ca ənəpaa də ŋukii. ");
INSERT INTO gde_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Ca ŋgərə ma'inə, ca əjivə aasəkə kələra, ca ndzaŋə yiiɓə səɗə ŋga lyawarənaakii, ca dzə də taaɗəginə də gyaratə a ŋukii. ");
INSERT INTO gde_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Ca mbu'ya aaɓii Simoonə Piita. Əŋki Piita ka ci, “Slandana, hə nə yiɓə ka nyi səɗə nii?” ");
INSERT INTO gde_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Əŋki Yeesu ka ci, “Pooshi hə paaratəgi də sənə cii kya ɗa əndzə'i, amma kadə nii kwa paaratəgi aakəŋwa.” ");
INSERT INTO gde_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Əŋki Piita, “Paa hə ka yiɓə səɗəki shaŋə!” Əŋki Yeesu ka ci, “Maɗa paa nyi yiɓə ka hə səɗəku, paa hə ka ndzaanə ka lawaraaki ma'ə.” ");
INSERT INTO gde_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Əŋki Simoonə Piita ka ci, “Slandana, maɗa ha'ə ɗiya, əntaa wata səɗəki tanə yiɓəginəku, amma yiɓəgi patə da i ciinəki da nəki!” ");
INSERT INTO gde_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Əŋki Yeesu, “Taa wu yiɓəgi shishinəkii, malaaɓakii nə ci ətsa, pooshi nafa ŋga ənənə ka yiɓənə, maɗaamə səɗəkii. Ma unə, patənə goonə malaaɓakii nuunə, maɗaamə əndə rəŋwə.” ");
INSERT INTO gde_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Ma bii Yeesu ha'ə, acii kə shii ci tə əndətə na vii tə ci aacii ənja. Ci ɗii bii ci, “Patənə goonə malaaɓakii nuunə, maɗaamə əndə rəŋwə.” ");
INSERT INTO gde_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Ma daaba'ə, makə uugi ci yiiɓəgi səɗətii, ca ənə ka ŋgavə kəjeerənaakii, ca ənə ka ndzaanə dasə ka ha ŋga ndzaanaakii, ca ləgwa amatii, əŋki ci, “Kə paaratəgyuunə də sətə ɗii nyi əndzə'i kwa? ");
INSERT INTO gde_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Agi 'wanə nuunə tə nyi Maləma da Slandana. Ŋga'ə əsə makə 'wii unə tə nyi ha'ə, acii ci nə nyi. ");
INSERT INTO gde_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Ma nyi Slandanuunə da Maləmə goonə əsə, kə yiiɓəgi nyi koonə səɗuunə. Ma unə əsə, yiiɓəshimə səɗə ahadoonə. ");
INSERT INTO gde_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Kə ɓaarii nyi koonə ɗanə ha'ə, koona shii ɗanə makə ətsə ɗii nyi koonə. ");
INSERT INTO gde_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Tantanyinə cii kya ba koonə, pooshi mava ka paleenə ka Slandanəkii. Ha'ə əsə, pooshi masləkee əndə ka paleenə ka əndətə sləkee ka ci. ");
INSERT INTO gde_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Makə kə shii unə gooŋgatsa, maɗa kə gyuunə aakəŋwa də ɗanə ha'ə makə ətsa, tə'i barəkaanə ashuunə. ");
INSERT INTO gde_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“Əntaa agyanuunə patə cii kya waɓə. Kə shii nyi ənjitə ta'i nyi. Ka ɗanə ka gooŋga nə sətə bii malaaɓa ləkaləkatə oo'i, ‘Ma əndənə ciina zəmə ka kəŋwə rəŋwə, kə zə'uunə ci ka nyi.’ ");
INSERT INTO gde_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Ma bii nyi koonə ətsa daga ci ma'ə maslənəmə, koona shii vii gooŋga, oo'i nyi nə əndə daga ŋukə, saa'itə nə səkii a slənə. ");
INSERT INTO gde_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Tantanyinə cii kya ba koonə, taa wu patə liwə taa tə wu ətə sləkee nyi, tə nyi liwə ci ətsa. Taa wu patə liwə tə nyi əsə, tə Əndətə sləkee ka nyi liwə ci ətsa.” ");
INSERT INTO gde_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Makə bagi Yeesu ha'ə, kə gimə ci agi mabuurəna, wata ca bagi paŋgəraŋə, əŋki ci, “Tantanyinə cii kya ba koonə, tə'i əndə ahadoonə ətə na vii tə nyi aacii ənja.” ");
INSERT INTO gde_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Lyawarənaakii a tsaaməshi ahadatii. Kə gwazəgi haŋkalatii ka shaŋə, acii pooshi tii shii taa agyanə wu ahadatii cii kəya waɓə. ");
INSERT INTO gde_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Əndə'i əndə agi lyawarənaakii ətə palee ci də uuɗənə, ataŋgalakii nə ci dasə. ");
INSERT INTO gde_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Wata Simoonə Piita a mərikətə ka ci, əŋki ci, “Ləgwatə amakii taa agyanə wu cii kəya waɓə.” ");
INSERT INTO gde_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Wata ca əntsahətə aaɓii Yeesu, əŋki ci ka ci, “Wu daa Slandana?” ");
INSERT INTO gde_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Əŋki Yeesu, “Ka cimwatənə nə nyi buroodi agi dzəguɗa, nya vii ka ci, ci nə əndəkii.” Wata ca əntəcii buroodi, ca ɗaanə dzəguɗa, ca vii ka Yahuda uuzənə ŋga Simoonə Isəkariyoota. ");
INSERT INTO gde_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Pii makə liwə ci buroodikii, wata Seetanə a dəməgərə aa ədzəməkii. Əŋki Yeesu ka ci, “Duu ka ɗa sətə cii kwa ɗa pii pii!” ");
INSERT INTO gde_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Asee, ma waɓənə ŋga Yeesu, pooshi əndə paaratəgi agitii. ");
INSERT INTO gde_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Makə ɗii ci Yahuda nə əndə kəsə kwaɓa, ma nyihə hara lyawarənə, makə ma bii Yeesu ka ci, wa ca dzə ka ira uushi'iitə diɓə ka ɗa də kumənə, taa vii uushi ka maaghiinə. ");
INSERT INTO gde_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Makə liwə Yahuda buroodita, wata ca maɗə, ca dəməgi dəŋwa'ə. Davəɗə nə ha saa'ikii. ");
INSERT INTO gde_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Ma daaba'ə, makə pyalə Yahuda, əŋki Yeesu, “Ma əndzə'i ɗiya, kə uugi ɗuunuunə ŋga Uuzənə ŋga əndə shiginə aa babara, kə uugi ɗuunuunə ŋga Əntaŋfə shiginə aa babara daciikii əsə. ");
INSERT INTO gde_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Makə kə shigi ɗuunuunə ŋga Əntaŋfə paŋgəraŋə aa babara daciikii, ka ɓaariinə nə Əntaŋfə ɗuunuunə ŋga Uuzənaakii ashikii saakii. Pii pii ɗanəkii ha'ə əsə. ");
INSERT INTO gde_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","Manjeevənaakya, ma aakəŋwa gi'u, pooshi nyi na ndzaanə ahadoonə ma'ə. Takumə kaa nya ba koonə sətə bii nyi ka *gayinə ŋga Yahudiinə: ka alənə nuunə tə nyi, amma pooshi unə ka dzənə ka hatə cii kya dzə aadəvə. ");
INSERT INTO gde_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Acii ha'ə wanyinə ka vii koonə kura bariya, waatoo, uuɗəshimə. Makə sətə uu'i nyi tuunə, tyasə see a uuɗəshuunə. ");
INSERT INTO gde_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Maɗa kə uuɗəshuunə, ka shiinə nə patənə ŋga ənji oo'i, lyawarənaaki nuunə.” ");
INSERT INTO gde_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Wata, Simoonə Piita a ləgwa ka Yeesu, əŋki ci, “Slandana, aama daa cii kwa dza?” Əŋki Yeesu ka ci, “Ma hatə cii kya dzə aadəvə, paa hə ka nə'unə tə nyi əndzə'i. Amma ma aakəŋwa, ka nə'unə nə hə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Əŋki Piita ka ci, “Slandana, acii mi pa nya nə'u tə ha? Matasəkakii nə nyi kaa nya əntə ka putaaku!” ");
INSERT INTO gde_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","Əŋki Yeesu, “Matasəkakii nə hə tanyi kaa ha əntə ka putaaki kwa? Tantanyinə cii kya ba ka hə, ma taabu'u wanə gyaagya, ka jikənə nə hə makkə ka hiweenə ka shiinə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","Əŋki Yeesu ka tii, “Goona buurə taa mi. Viimə gooŋga ka Əntaŋfə, una gi'i tə nyi əsə. ");
INSERT INTO gde_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Ma asii ga Daadə, tə'i kuvənyinə laŋə. Wanyinə ka dzənə ka haɗa koonə də ha əsə. Maci pooshi ha koonə, kaɗa pooshi nyi bii koonə ha'ə. ");
INSERT INTO gde_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Maa kə gi nyi, kə haɗatəgi nyi koonə də ha, ka ənyanə nə nyi, nya shi ka fəɗənə tuunə aaɓiiki, koona shii ndzaanə ka hatə ɗii nyi davə. ");
INSERT INTO gde_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Kə shii unə rəgwa ŋga hatə cii kya dzə aadəvə.” ");
INSERT INTO gde_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Əŋki Tooma ka ci, “Slandana, mashiimiinə hatə cii kwa dzə aadəvə, iitə ɗii shiiniinə rəgwa ŋga dzəginə aadəva?” ");
INSERT INTO gde_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","Əŋki Yeesu ka ci “Nyi nə rəgwa, ashiki nə gooŋgaanə, nyi nə əndə vii əpinə əsə. Pooshi əndə ca dzə aaɓii Daadə maɗaamə daciiki. ");
INSERT INTO gde_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Makə ɗii ci kə shii unə tə nyi, ka shiinə nuunə tə Daadə əsə. Daga əndzə'i ka dzənə aakəŋwa kə shii unə tə ci, kə nee unə ka ci əsə.” ");
INSERT INTO gde_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Əŋki Filibusə ka ci, “Slandana, ma sətə ciina moo, ɓaarii keenə tə Duu.” ");
INSERT INTO gde_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Yeesu a ba ka ci, əŋki ci, “Filibusə, kə ta'avə nyi ka shaŋə ahadoonə, amma ca'ə əndzə'i pooshi hə shii tə nyi nii? Taa wu patə nee ka nyi, kə nee ci ka Daadə ətsa. Iitə ɗii banəku oo'i, a ɓaarii nyi koonə tə Daada? ");
INSERT INTO gde_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Filibusə, paa hə vii gooŋga oo'i, ashi Daadə nə nyi, ha'ə nə Daadə əsə, ashiki nə ci kwa?” Wata əŋki ci ka lyawarənaakii patə, “Ma waɓəənə ca shigi da maki koonə, əntaa ŋga naaki na. Amma Daadə ca ɗa slənaakii ashiki. ");
INSERT INTO gde_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Ma bii nyi, ashi Daadə nə nyi, ha'ə nə ci əsə, ashiki nə ci, viimə gooŋga ka waɓənəkii. Maɗa pooshi unə ka vii gooŋga ka waɓənaaki, viimə gooŋga putə ŋga uushi'iitə cii kya slənə. ");
INSERT INTO gde_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“Tantanyinə cii kya ba koonə, taa wu patə vii ka nyi gooŋga, ka slənənə nə ci slənətə cii kya slənə əsə palee ka ənə cii kya slənə, acii aaɓii Daadə cii kya dzə. ");
INSERT INTO gde_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Taa mi patə kədii unə də ləməki, ka ɗanə nə nyi koonə səkii, kaa Daadə a shii upaa ɗuunətənə dashiki Uuzənaakii. ");
INSERT INTO gde_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Maɗa kədii unə taa mi patə də ləməki, ka ɗanə nə nyi koonə.” ");
INSERT INTO gde_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“Maɗa kə uu'i unə tə nyi, ka nə'utənə nuunə bariyaaki. ");
INSERT INTO gde_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Ma nyi, ka kədiinə nə nyi acii Daadə, kaa ca vii koonə əndə'i əndə tsakənə tuunə. Ka ndzaanə nə ci ahadoonə ca'ə ka muudinə. ");
INSERT INTO gde_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Ma'yanə nə ci. Ci ɓaarəgi paŋgəraŋə tə gooŋgaanə agyanə Əntaŋfə. Ma ci, pooshi *duuniya liwə tə ci, acii pooshi tii nee ka ci, pooshi tii shii tə ci əsə. Amma ma unə, kə shii unə tə ci, acii ka hakii nuunə, ashuunə nii kəya ndzaanə əsə. ");
INSERT INTO gde_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“Maa kə pyalə nyi, paa nyi ka bwaseenə koonə unə daanuunə, ka ənyanə nə nyi aaɓii unə. ");
INSERT INTO gde_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Ma aakəŋwa gi'u, pooshi duuniya na nee ka nyi ma'ə. Amma ma unə, ka neenə nuunə ka nyi. Makə ɗii ci da i əpinə nə nyi, kaa ndzaanə nuunə da i əpinə noonə əsə. ");
INSERT INTO gde_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Maa kə mbu'ya uusərata, ka shiinə nuunə oo'i, ashi Daadə nə nyi, unə əsə ashiki nuunə, makə sətə ɗii nyi ashuunə. ");
INSERT INTO gde_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Taa wu patə liwə bariyanyinaaki, ca nə'utə tə tii, ci nə əndətə uu'i tə nyi. Ma əndətə uu'i tə nyi, ka uuɗənə nə Daadə tə ci. Ma nyi naaki əsə, ka uuɗənə nə nyi tə ci, nya ɓaarəgi ka ci naaki na.” ");
INSERT INTO gde_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Əŋki Yahuda (əntaa ŋga Isəkariyoota), “Slandana, iitiitə daa ɗanəkii ɓaarəginəku naaku nə keenə tanə, amma əntaa ka duuniya?” ");
INSERT INTO gde_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Əŋki Yeesu, “Taa wu patə uu'i tə nyi, ka nə'utənə nə ci dzəgunənaaki. Ka uuɗənə nə Daadə tə ci. Ma nyi inə da Daadə, ka shinə niinə, ina shi ka ndzaanə ashikii. ");
INSERT INTO gde_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Ma əndətə pooshi ka nə'u dzəgunənaaki, paa ci ka uuɗənə tə nyi ətsa. Ma dzəgunəənə fii unə da maki, əntaa ŋga ənfə nəki, amma dacii Daadə ətə sləkee ka nyi shigi dzəgunənəkii. ");
INSERT INTO gde_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“Wanyinə ka ba koonə ənə daga nyi ma'ə ahadoonə. ");
INSERT INTO gde_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Ma əndə tsakənə tuunə, waatoo Malaaɓa Ma'yanə ətə nə Daadə a sləkee koonə də ləməki, ci na dzəgunə koonə patənə ŋga uushi'inə, ca buurətə koonə patənə ŋga uushi'iitə bii nyi koonə. ");
INSERT INTO gde_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“Ndzaanə agi jamənə cii kya bwasee koonə. Əntaa tsarə ŋga jaməətə ci duuniya a vii, amma naaki saaki. Goona buurə taa mi, goona ŋgwalə əsə. ");
INSERT INTO gde_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","Kə fii unə nya ba, ka palənə nə nyi, amma ka ənyanə nə nyi aaɓii unə. Maɗa kə uu'i unə tə nyi, ka ɗanə nuunə mooɗasəkə ŋga dzənaaki aaɓii Daadə, acii kə palee ci ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Kə bii nyi koonə ətsə əndzə'i daga ci ma'ə maslənəmə, koona shii vii gooŋga saa'itə nə səkii a slənə. ");
INSERT INTO gde_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Paa nyi na waɓə laŋə doonə ma'ə, acii agi shinə nə ŋwaŋwə ŋga duuniyana. Əntaa ŋgeerənə paleegi ci ka nyi, ");
INSERT INTO gde_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","amma ma na ɗa ha'ə, kaa duuniya a shii oo'i, kə uu'i nyi tə Daadə. Ci ɗii cii kya slənə patənə ŋga uushi'inə makə sətə bii ci ka nyi. Kwadzaamə kaama bwasee ka hana.” ");
INSERT INTO gde_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“Nyi nə tantanyitə ənfwə inabi, Daadə əsə nə əndə haɗa də ənfukii. ");
INSERT INTO gde_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Agi pwaatəginə nə ci ciinə ŋga ənfwə ətə pooshi ka poonə ŋga'ə. Ma ətə ca poo ŋga'ə, ca haɗatəgi, kaa ca shii ndzaanə camə, ca poo laŋə. ");
INSERT INTO gde_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Ma unə, camə nuunə də dzəgunəətə jigunyii koonə. ");
INSERT INTO gde_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ndzaamə ləɓə da nyi, nya ndzaa ləɓə doonə naaki. Pooshi baladzanə ŋga ənfwə ka poonə ci saakii maɗaamə ci ma'ə ashi diikii. Ha'ə əsə, pooshi unə ka poonə, maɗa pooshi unə ləɓə da nyi. ");
INSERT INTO gde_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“Nyi nə ənfwa, unə nə baladzanə ŋga ənfwa. Ma əndətə ləɓə da nyi, ashikii nə nyi əsə, ci ca poo laŋə, acii maɗa pooshi nyi, pooshi uushi cuuna mbee ka ɗatənə. ");
INSERT INTO gde_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Ma əndətə pooshi ləɓə da nyi, ka kaginə nə ənji tə ci makə baladzanə ŋga ənfwa, ca huurəgi, ənjə a dzatəgi də baladzanəkii, ənjə a kaanə gunə, ca ətsagi. ");
INSERT INTO gde_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Maɗa kə ndzaa unə ləɓə da nyi, kə ndzaa waɓənaaki ləɓə doonə əsə, ka kədiinə nuunə patənə ŋga uushi'inə ətə cuuna moo, ka upaanə nuunə əsə. ");
INSERT INTO gde_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Maɗa kə ndzaa unə makə ənfutə ca poo laŋə, ka kiranə nuunə ɗuunuunə ka Daadə. Ci na ɓaarii oo'i, ənji nə'unə tə nyi nuunə. ");
INSERT INTO gde_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Kə uu'i nyi tuunə makə sətə uu'i Daadə tə nyi. Ndzaamə agi uuɗənaaki. ");
INSERT INTO gde_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Maɗa kə nə'utuunə sətə bii nyi koonə, ka ndzaanə nuunə agi uuɗənaaki, makə sətə nə'utə nyi ndilə ndilə tə sətə bii Daadə ka nyi, nya ndzaanə agi uuɗənaakii əsə. ");
INSERT INTO gde_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“Ma bii nyi koonə ətsa, kaa mooɗasəkaaki a ndzaanə ahadoonə, mooɗasəkə goonə a mbu'u əsə. ");
INSERT INTO gde_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Ma bariyaaki, uuɗəshimə, makə sətə uu'i nyi tuunə. ");
INSERT INTO gde_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Ma maɗuunə uuɗənə ətə ci əndə a uuɗə tə guviinəkii, vigi əpinaakii ka putatii. ");
INSERT INTO gde_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Ma unə, maɗa kə nə'utuunə sətə bii nyi koonə, guviinəki nuunə. ");
INSERT INTO gde_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Paa nyi ka 'wanə tuunə ənji slənaaki ma'ə. Acii ma əndə sləna, paa ci ka shii sətə ci Slandanəkii a ɗa. Guviinəki 'wanəki tuunə, acii kə bii nyi koonə patənə ŋga sətə fii nyi ama Daadə. ");
INSERT INTO gde_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Əntaa unə ta'i tə nyi, amma nyi ta'i tuunə, nyi kavə tuunə koona dzə ka əji pawə laŋə, waatoo pawətə pooshi ka uudənə shaŋə. Maɗa kə ɗii unə ha'ə, ka viinə nə Daadə koonə taa mi kədii unə aciikii də ləməki. ");
INSERT INTO gde_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Ci ɗii cii kya ba koonə, uuɗəshimə.” ");
INSERT INTO gde_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","“Maɗa kə ushapaa duuniya tuunə, buurətəmə oo'i, tə nyi 'watəgi tii ushapaanə. ");
INSERT INTO gde_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Maci ŋga duuniya nuunə, kaɗa ka uuɗənə nə duuniya tuunə. Amma kə ta'i nyi tuunə tsaŋə agi duuniya, əntaa natii nuunə. Ci ɗii ushapaa tii tuunə. ");
INSERT INTO gde_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Buurətəmə sətə bii nyi koonə tuu'inə, pooshi mava ca palee ka Slandanəkii. Ci ɗii, maɗa kə ciɓee tii ka nyi, ka ciɓeenə nə tii koonə noonə əsə. Maɗa kə nə'utə tii dzəgunənaaki, ka nə'utənə nə tii noonə əsə. ");
INSERT INTO gde_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amma ka ɗanə nə tii koonə patənə ŋga uushi'iitsa acii ɗii unə ka naaki, acii pooshi tii shii tə Əndətə sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Maci pooshi nyi shi, nya waɓə ka tii, kaɗa pooshi 'waslyakəənatii kəshi tə tii. Amma makə sətsə ɗii ci ətsa, pooshi rəgwa mbərəɗənətii acii 'waslyakəənatii. ");
INSERT INTO gde_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Taa wu patə ushapaa tə nyi, tə Daadə ushii ci ətsa. ");
INSERT INTO gde_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Maci pooshi nyi ɗaaɗii uushi'inə ahadatii ətə pooshi əndə sha ɗii tsarəkii makə ətsa, kaɗa pooshi 'waslyakəənatii kəshi tə tii. Amma kə nee tii ka uushi'iitsə ɗii nyi, patə da ha'ə kə kaaree tii keenə inə da Daadə. ");
INSERT INTO gde_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Ma ɗii ətsə patə, kaa sətə nyaahə ənji asəkə bariyatii a ndzaa ka tantanyinə ətə bii ci: ‘Əntaa uushi ɗii nyi ka tii kaaree tii ka nyi.’ ");
INSERT INTO gde_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“Kadə nə Matsakə tuunə a shi dacii Daadə, waatoo Malaaɓa Ma'yanə. Ci na ɓaarəgi paŋgəraŋə tə gooŋgaanə ŋga Əntaŋfə. Dacii Daadə nii kya sləkee koonə ka ci, ca waɓə agyanəki əsə. ");
INSERT INTO gde_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Ma unə, ka waɓənə nuunə agyanəki, acii daga saa'itə 'watəgi nyi dzəgunənə ka ənji naamə doonə. ");
INSERT INTO gde_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“Ma bii nyi koonə ətsə patə, acii goona ənyi aaba'ə agi nə'unə tə nyi. ");
INSERT INTO gde_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Kadə nə ənjə a laakəgi tuunə asəkə *kuvə də'wanyinə. Tə'i saa'i na shi əsə, taa wu ca ɓələ tuunə, ka ŋgərənə nə ci makə paslənə nə ci ka paslənə ka Əntaŋfə də ɗanə ha'ə. ");
INSERT INTO gde_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Ma nə ənjə a ɗa koonə ətsə patə, acii pooshi tii shii tə Daadə taa tə nyi. ");
INSERT INTO gde_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Amma ma bii nyi koonə ətsa, koona shii buurətənə oo'i, kə shi nya bii koonə ha'ə saa'itə nə səkii a ɗa.” “Ma ɗii pooshi nyi bii koonə uushi'iitsə daga ŋukə, acii ka hakii naamə. ");
INSERT INTO gde_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Amma makə wanyinə ka palənə aaɓii Əndətə sləkee ka nyi, ci ɗii cii kya bagi koonə əndzə'i. Taa ŋgahi kə bii nyi koonə ka palənə nə nyi, amma pooshi əndə ahadoonə ləguyi ka nyi taa aama cii kya dzə. ");
INSERT INTO gde_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Wata una ɓəzəgi səkə puta bii nyi ha'ə. ");
INSERT INTO gde_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Tantanyinə cii kya ba koonə, gəɗə palənaaki koonə, acii maɗa pooshi nyi pyalə, pooshi Matsakə tuunə na shi koonə. Amma maa kə pyalə nyi, ka sləkeenə nə nyi koonə ka ci. ");
INSERT INTO gde_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Maa kə shi ci əsə, ka ɓaarəginə nə ci ka *duuniya taa mi nə 'waslyakəənə, da taa mi nə slənə sətə dagwakii. Ca ɓaarii əsə oo'i, kadə nə Əntaŋfə a ɗa ka tii gəŋwanə. ");
INSERT INTO gde_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Ka ɓaariinə nə ci ka tii oo'i, kə slənyi tii 'waslyakəənə makə ɗii ci pooshi tii vii ka nyi gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Ka ɓaariinə nə ci ka tii əsə oo'i, dagwakii nə slənaaki, makə ɗii ci aaɓii Daadə cii kya palə, pooshi unə ka neenə ka nyi ma'ə. ");
INSERT INTO gde_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Ka ɓaariinə nə ci ka tii əsə oo'i, kadə nə Əntaŋfə a ɗa ka tii gəŋwanə, acii ma ŋwaŋwa ŋga duuniyana, kə uugi ci upaa naakii. ");
INSERT INTO gde_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“Laŋə nə uushi'inə amaki ŋga banə koonə, amma ma əndzə'i, ka ɗaginə laŋə ka nuunə ka əsətənə. ");
INSERT INTO gde_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Yoo, maa kə shi Ma'yanə ətə na ɓaarəgi gooŋgaanə agyanə Əntaŋfə, ka dzəgunətənə nə ci koonə rəgwa ŋga gooŋgaanə patə. Əntaa də baawəɗaakii saakii nii kəya waɓə, amma sətə fii ci nii kəya ba. Ka banə nə ci koonə uushi'iitə na shi. ");
INSERT INTO gde_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Kadə nii kəya ɗuunətə tə nyi, acii uushi'iitə waɓi nyi nii kəya ŋgərə, ca ba koonə. ");
INSERT INTO gde_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Patənə ŋga sətə marii Daadə, naaki. Ci ɗii fii unə bii nyi, ma Ma'yanəkii, ka ŋgərənə nə ci sətə vii nyi ka ci, ca ba koonə.” ");
INSERT INTO gde_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“Ma aakəŋwa gi'u, pooshi unə na nee ka nyi. Ma ta'avənə gi'u daaba'əkii əsə, ka neenə nuunə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Wata hara lyawarənaakii a ləgwa ahadatii, “Mi cii kəya moo banə kwa? Kə bii ci kaamə, ma aakəŋwa gi'u, pooshi amə na nee ka ci; ma ta'avənə gi'u daaba'əkii əsə, ka ənənə naamə ka neenə ka ci. Ca ba əsə, acii ɗii ci aaɓii Dii cii kəya dzə. ");
INSERT INTO gde_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","Mi saŋə ci ‘aakəŋwa gi'u’ a moo bana? Pooshi amə shii sətə cii kəya waɓə agyanəkii.” ");
INSERT INTO gde_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","Kə shii Yeesu oo'i, ŋga'ə ka tii nə ləgwanə ka ci, wata əŋki ci ka tii, “Ma aakəŋwa gi'u, pooshi unə na nee ka nyi. Ma daaba'əkii gi'u əsə, ka neenə nuunə ka nyi. Ci nə sətə cuuna laagwa ahadoonə agyanəkii kwa? ");
INSERT INTO gde_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Tantanyinə cii kya ba koonə, ma unə, ka tuunə nuunə, una ŋgəərə ma, amma ma *duuniya, ka ɗanə nə tii mooɗasəka. Ka ɓəzənə nə səkuunə, amma ka zə'unə nə maɓətəsəkə goonə ka mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Maa kə uugi saa'i ŋga minə ɗanə kaa kya pawə, ka ɓəzənə nə səkətə acii kə mbu'ya saa'itə ŋga sa bwanea. Amma maa kə pwayi ki uuzənəkii, wata bwaneakii a zaanə ka ki, acii ka mooɗasəkə nə ki ŋga pawə uuzənə aasəkə duuniya. ");
INSERT INTO gde_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Ha'ə ɗii nuunə. Ma əndzə'i, ka maɓətəsəkə nuunə, amma ka ənyanə nə nyi aaɓii unə, ka ɗanə nuunə mooɗasəkə ka shaŋə, waatoo tsarə ŋga mooɗasəkə ətə pooshi əndə gutsəginə acii unə. ");
INSERT INTO gde_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“Maa kə mbu'ya uusərata, pooshi uushi cuuna kədii aciiki. Tantanyinə cii kya ba koonə, Daadə na vii koonə taa mi patə kədii unə aciikii də ləməki. ");
INSERT INTO gde_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Ca'ə mbu'ya ka ənshinə, pooshi unə kədii taa mi də ləməki. Ma ɗanuunə, kədiimə, ka upaanə nuunə, kaa mooɗasəkə goonə a shii ndzaanə sarai yadə uushi agikii.” ");
INSERT INTO gde_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“Kə ɗii nyi koonə waɓənə agi waɓənə ka ba koonə də uushi'iitsa. Amma tə'i saa'i na shi ətə pooshi nyi na ɗa koonə waɓənə agi waɓənə ma'ə. Paŋgəraŋə paŋgəraŋə nii kya waɓə koonə agyanə Daadə. ");
INSERT INTO gde_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Maa kə mbu'ya uusərata, ka kədiinə nuunə aciikii də ləməki. Mabamə nyi koonə əsə, nyi na kədii aciikii ka putə goonə. ");
INSERT INTO gde_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Acii Daadə də naakii nə maa, kə uu'i ci tuunə. Ma uu'i ci tuunə, acii unə maa, kə uu'i unə tə nyi, una vii gooŋga oo'i, daciikii shi nyi. ");
INSERT INTO gde_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Weewee dacii Daadə shi nyi aasəkə duuniya. Ma əndzə'i əsə, aaɓii Daadə cii kya ənə, nya bwasee ka duuniyana.” ");
INSERT INTO gde_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Wata əŋki lyawarənaakii ka ci, “Wahətsə ka waɓənə paŋgəraŋə paŋgəraŋə ha'ə ɗii, yadə waɓənə agi waɓənə agikii. ");
INSERT INTO gde_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Kə shii inə ha'ə ɗii oo'i, kə shii hə patənə ŋga uushi'inə, kə shii hə sətə a ədzəmiinə taabu'u ləguyi inə amaku. Ətsə ha'ə kavə tiinə ka vii gooŋga oo'i, dacii Əntaŋfə shi hə.” ");
INSERT INTO gde_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Əŋki Yeesu ka tii, “Bahə kə vii unə gooŋga nii? ");
INSERT INTO gde_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Acii tə'i saa'i na shi, kə uugi saa'ikii mbu'yanə maa ətə nuuna təəkəgi patə, taa wu patə ca palə saakii, una bwasee ka nyi, nyi daanəki. Amma əntaa nyi daanəki tanyi, acii ma Daadə, aɓiiki nə ci. ");
INSERT INTO gde_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Ma bii nyi koonə ətsa, koona shii ndzaanə agi jamənə agi ləɓəənə liɓuunə da nyi. Ka ciɓeenə nə duuniya koonə. Amma kəsəmə ədzəma, acii kə jaalii nyi agyanə duuniya.” ");
INSERT INTO gde_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Makə uudəpaa Yeesu waɓə uushi'iitsa, wata ca tsaamə aadəgyə, əŋki ci, “Daadə, kə uugi saa'i mbu'yanə. Ɓaarii ɗuunuunaaki ka ənja, kaa nya ɓaarii ka tii naaku əsə. ");
INSERT INTO gde_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Acii kə vii hə ka nyi baawəɗa agyanə patənə ŋga əndə shiŋkinə, kaa nya shii vii əpinə ŋga ca'ə ndəŋwə ndəŋwə ka ənjitə vii hə ka nyi patə. ");
INSERT INTO gde_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Ma əpinə ŋga ca'ə ndəŋwə ndəŋwə, ci nə shiinə tə hə Əntaŋfə rəŋwə dyaŋə Əndə gooŋga da shiinə tə nyi Yeesu Aləmasiihu ətə sləkee hə. ");
INSERT INTO gde_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Ma nya, kə ɓaarii nyi ɗuunuunaaku asəkə duuniya. Kə uudəpaa nyi slənətə vii hə ka nyi kaa nya ɗa. ");
INSERT INTO gde_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","Daada, ma əndzə'i, ɗuunətə tə nyi gatə ka hatə ɗii hə davə, makə sətə ɗuunətə hə tə nyi saa'itə duuniya ma'ə matagamə. ");
INSERT INTO gde_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“Kə bii nyi tə hə ka ənjitə taɗəgi hə tə tii tsaŋə agi duuniya, ha vii ka nyi. Naaku nə tii, ha vii ka nyi tə tii əsə. Kə nə'utə tii waɓənaaku. ");
INSERT INTO gde_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ma əndzə'i, kə shii tii oo'i, patənə ŋga sətə vii hə ka nyi, daciiku ca shi. ");
INSERT INTO gde_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Kə bii nyi ka tii waɓəətə vii hə ka nyi, kə liwə tii əsə, kə shii tii tantanyinə oo'i, daciiku shi nyi, təya vii gooŋga oo'i, hə sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“Wanyinə ka ɗa də'wa ka putatii. Əntaa putə ŋga *duuniya patə cii kya ɗa də'wa, amma ka putə ŋga ənjinə vii hə ka nyi, acii naaku nə tii. ");
INSERT INTO gde_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Patənə ŋga ənjaaki naaku. Patənə ŋga ənjaaku əsə, naaki nə tii. Dashitii əsə ci ənjə a nee ka ɗuunuunaaki. ");
INSERT INTO gde_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Wanyitsə ka dzənə aaɓiiku. Paa nyi ma'ə a duuniya. Amma ma təya, a duuniya nə tii. Malaaɓa Daada! kaka'atə tə tii də baawəɗa ŋga ləməku ətə vii hə ka nyi, kaa təya ndzaanə ka ma rəŋwə. ");
INSERT INTO gde_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Ma saa'itə nyi ahadatii, kə kaka'atə nyi tə tii də baawəɗa ŋga ləməku ətə vii hə ka nyi, agi nəhənə nə nyi tə tii. Taa rəŋwə pooshi əndə sha zii agitii, maɗaamə əndətə rəŋwə, waatoo, əndə ŋga gunə. Ma ɗii ha'ə, kaa sətə bii malaaɓa ləkaləkatə a ndzaa ka tantanyinə. ");
INSERT INTO gde_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","“Ma əndzə'i, wanyinə ka dzənə aaɓiiku. Ma bii nyi uushi'iitsə asəkə duuniya əsə, kaa təya shii ndzaanə də mooɗasəkaaki, ca ndzaanə sarai a ədzəmətii. ");
INSERT INTO gde_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Kə bii nyi ka tii waɓənaaku. Kə ushapaa *duuniya tə tii, acii ɗii tii əntaa ŋga duuniya, makə sətə ɗii nyi əntaa ŋga duuniya əsə. ");
INSERT INTO gde_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Ma cii kya kədii aciiku, əntaa kaa ha fəɗəgi tə tii ganə a duuniya, amma kaa ha kaka'agi tə tii acii ma'waslyakə əndətsa. ");
INSERT INTO gde_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Makə sənə ɗii nyi əntaa ŋga duuniya, ha'ə nə tii əsə, əntaa ŋga duuniya nə tii. ");
INSERT INTO gde_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Zhi'ee ka tii, təya ndzaa camə ka hə saaku, təya shii gooŋgaanə ŋga waɓənaaku. ");
INSERT INTO gde_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Wanyinə ka sləkeenə ka tii aasəkə duuniya, makə sətə sləkee hə ka nyi aasəkə duuniya naaku əsə. ");
INSERT INTO gde_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Wanyinə ka vii naaki nə ka hə ka putatii. Tii maa, kaa təya shii mbee ka vii natii nə ka hə əsə də gooŋgaanə. ");
INSERT INTO gde_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“Əntaa wata ka putatii cii kya ɗa də'wa, amma da i ka putə ŋga ənjitə na vii ka nyi gooŋga putə ŋga fa Ŋunyi Habara amatii. ");
INSERT INTO gde_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","Agi ɗanə nə nyi də'wa kaa təya shii ndzaanə ka ma rəŋwə patə. Daadə! wa təya ləɓə daaŋwə, makə sənə ɗii aŋwə. Wa təya ndzaanə ka ma rəŋwə, kaa duuniya a shii oo'i, hə sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Ma ɗuunuutə vii hə ka nyi, ci vii nyi ka tii, kaa təya shii ndzaanə ka ma rəŋwə makə sənə ɗii aŋwə rəŋwə. ");
INSERT INTO gde_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Waatoo nya ndzaanə ashitii, hə əsə ha ndzaanə ashiki, təya ndzaanə rəŋwə ka shaŋə, kaa duuniya a shii oo'i, hə sləkee ka nyi. Ma hə əsə, kə uu'i hə tə tii makə sənə uu'i hə tə nyi. ");
INSERT INTO gde_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“Daada! ma ənjinə vii hə ka nyi, ŋga'ə ka nyi kaa təya ndzaanə ka hatə nii kya ndzaanə, kaa təya shii neenə ka ɗuunuunaaki ətə vii hə ka nyi. Ma vii hə ka nyi, acii kə uu'i hə tə nyi daga duuniya ma'ə matagamə. ");
INSERT INTO gde_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","Daadə Əndə gooŋga, pooshi duuniya shii tə hə, amma ma nya, kə shii nyi tə hə. Ma ənjinə əsə, kə shii tii oo'i, hə sləkee ka nyi. ");
INSERT INTO gde_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Kə bii nyi tə hə ka tii, ka dzənə nə nyi aakəŋwa də banə ka tii ha'ə əsə, kaa uuɗəətə cii kwa uuɗə tə nyi a ndzaanə ashitii, nyi maa, kaa nya shii ndzaanə ashitii.” ");
INSERT INTO gde_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Makə uudəpaa Yeesu də'watsa, təya maɗə tii da lyawarənaakii, təya taŋəgi təhwanə ŋga Kidəroonə. Ma dava, tə'i səkətsanə. Wata Yeesu tii da lyawarənaakii a dəməgərə aasəkə tsanəkii. ");
INSERT INTO gde_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Ma Yahuda, əndə viinə tə Yeesu ka ənja, kə shii ci hakii, acii kə izee Yeesu tii da lyawarənaakii ka dzənə aadəvə. ");
INSERT INTO gde_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Wata Yahuda a palə aadəvə aasəkə tsanə tii da soojiinə ŋga Rooma da ənji nəhə yi ŋga Əntaŋfə. Ma təya, madiigərə limanyinə da *Farisanyinə sləkee ka tii. Təya fəɗəənə uushi'inə ŋga paginatii da i tikisanyinə aciitii. ");
INSERT INTO gde_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Ma Yeesu, kə shii ci sətə na slənə də ci patə, wata ca əntsahətə aakəŋwa, əŋki ci, “Tə wu daa cuuna ala?” ");
INSERT INTO gde_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Əŋki tii, “Tə Yeesu əndə Nazaratu ciina alə.” Əŋki ci ka tii, “Aa wanyina.” Ma Yahuda əndə viinə tə ci aacii ənja, davə nə ci kəŋə aɓitii. ");
INSERT INTO gde_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Makə bii Yeesu ka tii, “Aa wanyina”, wata təya ənəgi aaba'ə, təya kwaalagi aa panə acii ŋgwalənə. ");
INSERT INTO gde_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Yeesu a ənə ka ləgwanə ka tii, “Tə wu cuuna alə kwa?” Əŋki tii ka ci, “Tə Yeesu əndə Nazaratu.” ");
INSERT INTO gde_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Əŋki Yeesu ka tii, “Kə bii nyi koonə, wanyina. Maɗa tə nyi cuuna alə, wa hara ənjina a palə satii.” ");
INSERT INTO gde_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Ma bii ci ha'ə, kaa sətə waɓi ci a ndzaanə ka tantanyinə, ətə bii ci, “Daada, taa rəŋwə pooshi ətə ətee nyi agi ənjitə vii hə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Ma Piita, da i ŋgila purəŋanaakii nə ci. Wata ca də'yagi, ca patsəgi limə ciizəmanə ŋga mava ŋga gawa ŋga limanyinə. Maləcisə nə ləmə ŋga mavakii. ");
INSERT INTO gde_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Wata əŋki Yeesu ka Piita, “Ənəgərə də ŋgila purəŋanaaku! Ma nə hə ka nəhənə, pooshi nyi ka sagi ciɓəənə vii Daadə ka nyi kwa?” ");
INSERT INTO gde_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Wata soojiinə ŋga Rooma da gawatii da i ənji nəhə yi ŋga Əntaŋfə, təya kəsə tə Yeesu, təya anəgi tə ci. ");
INSERT INTO gde_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Aakəŋwacii Anasə 'watəgi tii kərənə tə ci. Ma Anasə, iirə gawə ŋga limanyinə nə ci. Ci nə sərəhu ŋga Kayafasə, gawə ŋga limanyinə agi ətə fəza. ");
INSERT INTO gde_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Ma Kayafasə, ci sha bii ka *gayinə ŋga Yahudiinə oo'i, gəɗə əntənə ŋga əndə rəŋwə putə ŋga ənji patə. ");
INSERT INTO gde_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Kəsənatii tə Yeesu, wata Piita tii da əndə'i *lawara a nə'u tə ci. Ma lawarətsa, kə shii gawə ŋga limanyinə tə ci ka shaŋə, wata ənjə a bwasee ka ci, ca dəməgərə atsaa Yeesu aasii aahaakii. ");
INSERT INTO gde_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","Ma Piita, a uura mayi ənəgi ci. Wata lawarətə shii gawə ŋga limanyinə tə ci a ənya aaba'ə, ca ba ka əndə'i kadəma ətə ca nəhə uura maya, wa kya gimagərə də Piita aasəkə yi. ");
INSERT INTO gde_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Əŋki kadəmətə ka Piita, “Əntaa rəŋwə nə hə agi *lyawarənə ŋga əndətsə nii?” Əŋki Piita, “Aa'a, pooshi, əntaa nyi.” ");
INSERT INTO gde_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Ma ka saa'ikii, tə'i əra. Acii ha'ə kə hənətə maviinə da ənji nəhə yi ŋga Əntaŋfə gunə kaa təya 'utə. Wata Piita a əntsahə aaɓiitii ka 'utətə shishinəkii. ");
INSERT INTO gde_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Ma Anasə gawə ŋga limanyinə, kə laaguyi ci ka Yeesu uushi'inə agyanə lyawarənaakii da dzəgunənaakii. ");
INSERT INTO gde_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Əŋki Yeesu ka ci, “Paŋgəraŋə njii kya dzəgunə ka ənja. Patənə ŋga dzəgunənaaki əsə, asəkə *kuvə də'wanyinə da asəkə *yi ŋga Əntaŋfə njii kya dzəgunə. Ənjə a dzatə də nə patə ka fanə, paa nyi sha waɓi taa mi ma'umbeekii. ");
INSERT INTO gde_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Ka mi ɗii cii kwa ləgwa amakya? Ləgwatə ama ənjitə nja fa tə nyi. Ma təya, kə shii tii sətə bii nyi.” ");
INSERT INTO gde_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Makə waɓi Yeesu ha'ə, wata əndə'i əndə nəhə yi ŋga Əntaŋfə a tsa ka ci meeciinə, əŋki ci ka ci, “Makə ətsə waɓənəku ka gawə ku?” ");
INSERT INTO gde_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Əŋki Yeesu ka ci, “Maɗa tə'i uushi bii nyi bwayakii, bawə ka taa wu ganə tə səkii. Amma maɗa gooŋga nə sətə bii nyi, ka mi digə hə tə nya?” ");
INSERT INTO gde_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Wata Anasə a sləkee ka kərənə tə ci ma'anəkii aakəŋwacii Kayafasə gawə ŋga limanyinə. ");
INSERT INTO gde_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Ma Piita, ma'ə gatə kəŋə ca 'utə guna, wata əŋki hara ənji ka ci, “Əntaa rəŋwə nə hə agi lyawarənə ŋga əndətsə nii?” Amma kə hiwee ci, əŋki ci, “Pooshi, əntaa nyi.” ");
INSERT INTO gde_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Tə'i əndə'i mava ŋga gawə ŋga limanyinə davə, waatoo duurə ŋga ətə patsəgi Piita liminəkii, kə jikəvə ci, əŋki ci, “Pooshi nyi nee ka hə aɓiikii asəkə tsanə nii?” ");
INSERT INTO gde_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Wata Piita a tsakə hiweenə, əŋki ci, “Pooshi.” Pii wata ga'ə gyaagya a wagi. ");
INSERT INTO gde_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Pukənə ŋga ha tsəɗakə, ənjə a ŋgərə tə Yeesu asii ga Kayafasə, ənjə a kərə tə ci aaha ŋgwaməna. Ma *gayinə ŋga Yahudiinə, pooshi tii gimə da i tii aasii aaha ŋgwaməna, acii ŋga'ə ka tii nə ndzaanə malaaɓakii, kaa təya shii mbee ka adə zəmə ŋga kumənə ŋga *Pasəka. ");
INSERT INTO gde_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Wata ŋgwaməna ətə ɗii ləməkii Pilaatu a dəməgi, ca dzə ka ləgwanə amatii, əŋki ci, “Ŋgutə 'waslyakəənə ɗii əndənə koonə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","Ma nə uushi jikəvə tii, “Maci pooshi ci ɗii 'waslyakəənə, kaɗa pooshi inə kira tə ci aakəŋwaciiku.” ");
INSERT INTO gde_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Əŋki Pilaatu ka tii, “Aa ŋgərəmə tə ci, una dzə ka ɗa ka ci gəŋwanə makə sətə bii bariya goona.” Əŋki tii ka ci, “Ma inə, pooshi ənji vii keenə rəgwa ŋga ɓələgi ənda.” ");
INSERT INTO gde_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ma slənyi ətsə patə, kaa sətə bii Yeesu a ndzaa ka tantanyinə ətə bii ci, ka maɗeenə nə ənji ka ci aadəgyə. ");
INSERT INTO gde_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Pilaatu a ənəgərə aasii, ca 'wa tə Yeesu, əŋki ci ka ci, “Hə nə ŋwaŋwə ŋga *Yahudiinə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Əŋki Yeesu ka ci, “Hə saaku buurətə waɓəətsə nii, anii əndə'i əndə bii ka hə agyanəkya?” ");
INSERT INTO gde_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Əŋki Pilaatu ka ci, “Ma nə hə ka nəhənə, əndə Yahuda nə nyi kwa? Amə ənjaaku tii da madiigərə limanyinə vii tə hə ka nya. Mi slənyi hə saŋa?” ");
INSERT INTO gde_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Əŋki Yeesu ka ci, “Ma ŋwaŋuunaaki, əntaa ŋga duuniyana. Maci ma ɗii ŋga duuniyanə nə ŋwaŋuunaaki, kaɗa ma ənji nə'unə tə nyi, ka panə nə tii putə ŋga viinə tə nyi ka gayinə ŋga Yahudiinə. Pooshi, əntaa ŋga hanə nə ŋwaŋuunaaki.” ");
INSERT INTO gde_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Wata Pilaatu a ləgwa ka ci, “Aa ŋwaŋwə nə hə ənə kwa?” Əŋki Yeesu, “Hə bii oo'i ŋwaŋwə nə nyi. Ma pwayi ənji tə nyi, shi nyi aa duuniya, kaa nya shi ka waɓənə agyanə rəgwa ŋga gooŋgaanə. Taa wu patə ndzaanə ka əndə gooŋga, agi fanə nə ci tə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Əŋki Pilaatu ka ci, “Mi nə rəgwa ŋga gooŋga əsə ɗii?” Wata Pilaatu a ənə aaɓii ənji agyə, əŋki ci ka tii, “Ma nyi, paa nyi nee ka bwaya sətə ɗii əndəna. ");
INSERT INTO gde_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Amma makə sətə ɗii alə'aada goonə, taa guci agi kapaanə nə nyi koonə əndə furəshina agi kumənə ŋga Pasəka. Ŋga'ə koonə nya kapaa koonə tə ŋwaŋwə ŋga Yahudiinə kwa?” ");
INSERT INTO gde_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Wata təya maɗee ka uuratii ka banə, əŋki tii, “Poosha, kapaa keenə tə Barabasə.” Ma Barabasə, əndə maabə nə ci. ");
INSERT INTO gde_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Wata Pilaatu a ba ka ənjə a fəslə tə Yeesu də uu'yanə. ");
INSERT INTO gde_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Soojiinə a ŋgərə dəha, təya fuuɗətə ka Yeesu makə madiŋəna, təya ŋgavə ka ci aanəkii. Təya ŋgərə madizə kəjeerənə, təya ŋgavə ka ci. ");
INSERT INTO gde_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Təya əntsahətə aaɓiikii, əŋki tii ka ci, “Wa əpinaaku a gərə aakəŋwa, ŋwaŋwə ŋga Yahudiinə.” Təya tsəərə ka ci meeciinə. ");
INSERT INTO gde_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Pilaatu a ənə ka gimaginə agyə, əŋki ci ka daɓaala, “Ka ŋgiraginə nə nyi koonə tə ci aahanə kaa nya ɓaarii una nee oo'i, pooshi uushi lii nyi ashikii bwayakii bahə ɓələnə tə ci.” ");
INSERT INTO gde_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Wata Yeesu a gimagi agyə da i madiŋənə ŋga dəha da i madizə kəjeeriitə ashikii. Əŋki Pilaatu ka tii, “Tsaaməmə! Waanə əndəna!” ");
INSERT INTO gde_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Makə nee madiigərə limanyinə da ənji nəhə yi ŋga Əntaŋfə ka ci, wata təya ba də ŋgeerənə, əŋki tii, “Wa ənjə a gwa'avə tə ci aashi ənfwa! Wa ənjə a gwa'avə tə ci aashi ənfwa!” Əŋki Pilaatu ka tii, “Aa ŋgərəmə tə ci, una dzə ka gwa'avəna. Ma nyi nə nyi, pooshi nyi nee ka bwaya uushi ashikii bahə ɓələnə tə ci.” ");
INSERT INTO gde_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Daɓaala a ənə ka banə ka ci, əŋki tii, “Tə'i bariya geenə ətə bii tyasə see a ɓələ ənji tə ci, acii kə bii ci oo'i Uuzənə ŋga Əntaŋfə nə ci.” ");
INSERT INTO gde_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Makə fii Pilaatu ha'ə, kə cakə ŋgwalənə kəsənə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","Wata ca ənəgərə aasəkə yaakii, ca dzə ka ləgwanə ama Yeesu, əŋki ci, “Da saŋə shi ha?” Amma pooshi Yeesu jikə ka ci. ");
INSERT INTO gde_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Wata əŋki Pilaatu ka ci, “Pa ha waɓə aciiki kwa? Paa hə shi oo'i, tə'i nyi da baawəɗa ŋga kapaanə tə hə taa gwa'avənə tə hə aashi ənfwə koo?” ");
INSERT INTO gde_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Əŋki Yeesu ka ci, “Ətə ɗii ci Əntaŋfə vii ka hə, ci ɗii nə hə da baawəɗa anəki tanə. Acii ha'ə, ma əndətə vii tə nyi ka hə, tə'i ci da 'waslyakəənə laŋə ashikii, palee ka naaku.” ");
INSERT INTO gde_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Makə fii Pilaatu ətsə ha'ə, kə ɗii ci gazhi'waanə ŋga kapaanə tə Yeesu. Amma əŋki daɓaala də ŋgeerənə, “Maɗa kə kapaa hə tə ci, kə ndzaa ci ətsə, əntaa guva ŋga maɗuunə ŋwaŋwə ŋga ha də Rooma nə hə. Acii taa wu bii ŋwaŋwə nə ci, əndə daawaanə ŋga maɗuunə ŋwaŋwə nə ci ətsa!” ");
INSERT INTO gde_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Makə fii Pilaatu waɓəətsa, wata ca ŋgiragi tə Yeesu agyə, ca ndzaanə asəkə dəgələ ŋga la gəŋwanə. Ma hakii, mapəra'ə faariinə ətə ci ənjə a 'wa də uura *Ibəraaniya “Gabata.” ");
INSERT INTO gde_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Ma saa'itə ci təya ɗa ha'ə, uusəra takərə, ka pukyatə ha ŋga uusəra ŋga Pasəka. Əŋki Pilaatu ka daɓaala, “Wiitsə ŋwaŋwə goonə!” ");
INSERT INTO gde_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Təya ba də ŋgeerənə, əŋki tii, “Wa ənjə a ɓələgi tə ci, wa ənjə a ɓələgi tə ci. Wa ənjə a gwa'avə tə ci aashi ənfwa.” Pilaatu a ləgwa amatii, əŋki ci, “Ŋga'ə koonə kaa nya gwa'avə ŋwaŋwə goonə aashi ənfwə kwa?” Əŋki madiigərə limanyinə, “Maɗuunə ŋwaŋwə ŋga ha də Rooma tanə nə ŋwaŋwə geenə!” ");
INSERT INTO gde_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Wata Pilaatu a vii tə Yeesu ka tii kaa təya gwa'avə tə ci aashi ənfwa. Wata təya ŋgərə tə ci. ");
INSERT INTO gde_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Təya ŋgərəvə ka ci ənfwə ŋga gwa'avənə tə ci aashikii, təya palə, təya mbu'u ka hatə ci ənjə a 'wa “ha ŋga kəŋwə na.” Ma də uura Ibəraaniya, Gwaləgootə ci ənjə a 'wa hakii. ");
INSERT INTO gde_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Makə mbu'i tii aadəvə, təya gwa'avə tə ci aashi ənfwa, təya gwa'avə da i hara ənji bəra'i əsə, rəŋwə da ciizəmakii, rəŋwə da madzənakii. ");
INSERT INTO gde_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilaatu a naahətə waɓənə, ca vii ka ənjə a tsa'avə dagyanəkii ashi ənfwa. Ma sətə nyaahə ca, “Yeesu əndə Nazaratu ŋwaŋwə ŋga Yahudiinə.” ");
INSERT INTO gde_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Ənji laŋə a jaŋga, acii ma hatə gwa'avə ənji tə ci aashi ənfwa, pooshi dzaɗə da vəranə. Də uuranyinə kama kama makkə nyaahə ci, waatoo uura Ibəraaniya, uura Latinə, da uura Gərikə. ");
INSERT INTO gde_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Wata əŋki madiigərə limanyinə ka Pilaatu, “Ga ha naahə ‘Ŋwaŋwə ŋga Yahudiinə.’ Amma naahuu, ‘Ma əndəna, ma bii ci, ci nə ŋwaŋwə ŋga Yahudiinə.’ ” ");
INSERT INTO gde_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Əŋki Pilaatu ka tii, “Ma sətə nyaahə nyi, ha'ə ndzaanəkii manaahəkii!” ");
INSERT INTO gde_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Makə gwa'avə soojiinə tə Yeesu, kə ŋgirə tii kəjeerənaakii, təya təəkəpaa ahadatii ənfwaɗə. Amma tə'i əndə'i kəjeerənə. Ma kəjeerənəkii, pooshi ha ŋga gəŋuginə ashikii. ");
INSERT INTO gde_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","Wata əŋki soojiinə ahadatii, “Gaama tsapaa əna. Kurataamə, kaama nee ka əndətə ca ŋgərə ahadaamə.” Ma slənyi ətsə patə, kaa sətə bii malaɓa ləkaləkatə a ndzaanə ka tantanyinə, ətə bii ci, “Kə təəkəpaa tii kəjeerənaaki ahadatii, təya kuratə agyanə əndə'i.” Ha'ə ɗii soojiitə əsə. ");
INSERT INTO gde_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Ma atsaa Yeesu ci tsa'a ashi ənfwa, davə nə i məci da cikəŋuci məci da Mariyaama minə ŋga Kəloopa da Mariyaama Magədalina. ");
INSERT INTO gde_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Kə nee Yeesu ka məci tii da əndə nə'unə ətə palee ci də uuɗənə, tii kəŋə kəŋə davə. Əŋki Yeesu ka məci, “Yaayi, uuzənaaku nə ci.” ");
INSERT INTO gde_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Wata əŋki Yeesu ka əndə nə'uuta, “Muu nə ki.” Daga ka saa'ita əndə nə'uutə a ŋgərə tə ki kaa kya ndzaanə gakii asii. ");
INSERT INTO gde_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Makə shii Yeesu oo'i, ma ətsə ndzaa ci ətsa, kə uugi slənaakii patə, pooshi uushi mbəɗaanə, wata əŋki ci, “Meegiiriiki.” Ma bii ci ha'ə, kaa sətə bii malaaɓa ləkaləkatə a ndzaanə ka tantanyinə. ");
INSERT INTO gde_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Tə'i əbwə davə pasə da i mahwarəkinə asəkəkii. Ənjə a ŋgərə soosa, təya shimutə agikii, təya kavə aama magərə muha, təya ka ka ci aamakii. ");
INSERT INTO gde_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Wata Yeesu a shiɓə, əŋki ci, “Kə uugi ha'ə.” Ca gwaŋee ka nəkii, ca əntəgi. ");
INSERT INTO gde_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Wata gayinə ŋga Yahudiinə a dzə ka ləgwanə ama Pilaatu kaa ənjə a dzə ka ɓiiyipaa səɗə ŋga ənjitə gwa'avə ənji, təya ŋgyaaragərə tə tii ashi ənfwa. Ma ləguyi tii ha'ə, acii ma pukətə ha ŋga uusərakii, *uusəra ŋga əpisəka, paa tii ka moonə kaa maməətə ənjitə a ndzaanə ashi ənfwa uusəra ŋga əpisəka. Malaaɓakii dərəva əsə nə uusəra ŋga əpisəkəkii. ");
INSERT INTO gde_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Wata soojiinə a dzə ka ɓiiyigi səɗənyinə ŋga ənjitə ataŋgala Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Amma makə mbu'ya tii aaɓii Yeesu, ma nee tii, kə uugi ci əntənə, wata təya bwasee ka ɓiiyigi səɗəkii. ");
INSERT INTO gde_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","Amma wata əndə'i sooja a dzəɓəgərə uudəmaakii aashi Yeesu, wata pii idənə da ma'inə a əjagi ashikii. ");
INSERT INTO gde_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Ma əndətə nja tsaamə sətsə a slənə ha'ə, ci bii ətsa, koona shii mbee ka luuvənə noonə əsə. Ma sətsə bii ci, gooŋga. Kə shii ci oo'i, gooŋga cii kəya waɓə. ");
INSERT INTO gde_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Ma ɗii ətsə patə, kaa sətə bii malaaɓa ləkaləkatə a ndzaa ka tantanyinə, ətə bii ci, “Taa ilaakii rəŋwə pooshi ka əɓinə.” ");
INSERT INTO gde_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Tə'i əndə'i ha əsə asəkə malaaɓa ləkaləkatə ətə bii, “Ka tsaamənə nə ənji tə əndətə jiɓə ənji.” ");
INSERT INTO gde_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Ma daaba'ə ətsa, kə shi Yusufu əndə vəranə ŋga Arimatiya, ca dzə aaɓii Pilaatu, ca kədii rəgwa kaa ca dzə ka ŋgiragərə wə ŋga Yeesu. Wata Pilaatu a vii ka ci rəgwa. Fanaakii ha'ə, wata ca palə ka ŋgiragərənə. Ma ca, əndə nə'unə tə Yeesu nə ci, amma əntaa paŋgəraŋə. Ŋgwaliikii acii *gayinə ŋga Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Tə'i əndə'i əndə əsə ɗii ləməkii Nikoodaməsə, ətə sha gi aaɓii Yeesu davəɗə. Tii gi tii da Yusufu, ca ŋgərəənə kuzhikinə ŋga ɓəzənə aashi wa, ətə ci ənjə a 'wa ‘miira’ da ‘alulə’ magwazəkii. ");
INSERT INTO gde_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Wata ənjitsə bəra'i a ŋgərə wə ŋga Yeesu, təya haɗətə də marəma da i kuzəkəta, makə sətə ɗii alə'aada ŋga Yahudiinə ŋga ŋgəəɗə ənja. ");
INSERT INTO gde_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Tə'i əndə'i rə kədəhə da hatə ɓəli ənji tə Yeesu. Ma davə, tə'i kura gu'u ənda ətə pooshi ənji sha ŋgə'i əndə davə. ");
INSERT INTO gde_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Makə ɗii ci, ma pukətə hakii *uusəra ŋga əpisəka, kədəhə nə gu'ukii əsə, təya kagərə wə ŋga Yeesu aadəvə. ");
INSERT INTO gde_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Ma tsəɗakə uusəra alatə, ha ma'ə mapukəmə, kə ma'i Mariyaama Magədalina, kya palə aanə gu'u. Ma gi ki, furəŋə nə gu'ukii, kə ŋgərəgi ənji faaratə nji amakii. ");
INSERT INTO gde_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Wata kya palə də huyinə aaɓii i Simoonə Piita da əndə'i əndə nə'unə ətə palee Yeesu də uuɗənə, kya ba ka tii, əŋki ki, “Kə ŋgiragi ənji tə Slandanə a gu'u. Amma mashiimiinə hatə kapaa ənji tə ci.” ");
INSERT INTO gde_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Wata Piita da əndə'i əndə nə'uutə a palə aama gu'ukii. ");
INSERT INTO gde_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","Tii patə bəra'i, təya palə də huyinə, amma kə huyipaa əndə nə'uutə agyanə Piita, ci 'watə mbu'unə aama gu'ukii. ");
INSERT INTO gde_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Ca gwaŋaanə, ca nee ka marəmə davə, amma paa ci gimə aadəvə. ");
INSERT INTO gde_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Simoonə Piita a shi daba'əkii paraŋə da dəməgərənə aasəkə gu'ukii. Ca lapaa marəmə davə dzəŋgwafə, ");
INSERT INTO gde_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","da i dara wa, amma pooshi ka hakii da marəməta, kə ɗaŋgəraŋgi ci paŋgəraŋə saakii. ");
INSERT INTO gde_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Wata əndə nə'uutə ətə 'watəgi mbu'unə a dəməgərə aadəvə aa gu'u naakii, ca nee, ca vii gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","Ma təya, dəŋə ka saa'ikii, paa tii paaratəgi də sətə bii malaaɓa ləkaləkatə, oo'i tyasə ka maɗənə nə ci agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","Wata ənji nə'uutə a ənə satii aasii. ");
INSERT INTO gde_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Amma ma Mariyaama, kə ənəgi ki davə ama gu'u ka tuunə. Ma kya agi tuunə, kya gwaŋaanə, kya tsaamə aadəvə aa gu'u. ");
INSERT INTO gde_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Wata kya nee ka malaa'ikanyinə bəra'i da i kəjeerə uuɗa ashitii. Dasə dasə nə tii ka hatə nji Yeesu pərəɓə, əndə'i rəŋwə ka hatə nji nəkii, əndə'i rəŋwə əsə, ka hatə nji səɗəkii. ");
INSERT INTO gde_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Təya ləgwa amatə, əŋki tii, “Mina, mi saŋə cii kwa təwa?” Əŋki ki ka tii, “Kə ŋgərəma ənji tə Slandanəki, pooshi nyi shii hatə kapaa ənji tə ci!” ");
INSERT INTO gde_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Wata kya zə'ugi, kya nee ka Yeesu kəŋə, amma pooshi ki shii oo'i, Yeesu ətsa. ");
INSERT INTO gde_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Əŋki ci ka ki, “Mina, mi saŋə cii kwa təwa? Wu saŋə nə əndətə cii kwa ala?” Ma nə ki ka nəhənə, əndə slənə asəkə rə ca waɓə da ki, əŋki ki ka ci, “Maɗuuna, maɗa hə ŋgərəgi tə ci, bawə ka nyi hatə kapaa hə tə ci, kaa nya dzə ka ŋgərəginə!” ");
INSERT INTO gde_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Əŋki Yeesu ka ki, “Mariyaama.” Wata kya zə'ugi, kya muu də uura *Ibəraaniya, əŋki ki, “Rabbi!” makə banə, Maləma. ");
INSERT INTO gde_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Əŋki Yeesu ka ki, “Ga ha kəsə tə nyi, acii ma'ə nyi manəmə zəku'i aaɓii Daadə. Amma duu aaɓii ndzəkəŋushi'inəki, ha ba ka tii oo'i, ka ənənə nə nyi aaɓii Daadə, waatoo, Dəsənuunə, Əntaŋfwaaki, waatoo, Əntaŋfə goonə.” ");
INSERT INTO gde_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Wata Mariyaama a dzə ka banə ka ənji nə'unə oo'i, kə nee ki ka Slandana, kya batə ka tii sətə bii ci ka ki. ");
INSERT INTO gde_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Ma uusəra alatəkii ha'ə əsə kədəwanə, kə dzii *lyawarənə də na, təya pa'əənə makuvə aanətii, ŋgwalii tii acii gayinə ŋga Yahudiinə. Wata Yeesu a dəməgərə, ca kəŋaanə ahadatii, əŋki ci ka tii, “Wa jamənə a ndzaanə ahadoonə.” ");
INSERT INTO gde_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Makə bagi ci ka tii ha'ə, wata ca ɓaarii ka tii səkəciinəkii da taŋgalakii. Wata kə ɗii lyawarənə mooɗasəkə ka shaŋə ŋga neenə ka Slandana. ");
INSERT INTO gde_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Yeesu a ənə ka banə ka tii, əŋki ci, “Wa jamənə a ndzaanə ahadoonə. Makə sətə sləkee Daadə ka nyi, ha'ə cii kya sləkee koonə əsə.” ");
INSERT INTO gde_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Makə bagi ci ha'ə, wata ca ədəvə ka tii əpinaakii, əŋki ci ka tii, “Luumə Malaaɓa Ma'yanə. ");
INSERT INTO gde_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Maɗa kə tifyagyuunə ka ənji 'waslyakəənatii, kə tifyagi Əntaŋfə ka tii. Maɗa pooshi unə tifyagi ka tii, pooshi ənji ka tifyaginə ka tii əsə.” ");
INSERT INTO gde_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Ma rəŋwə agi lyawarənə ŋga Yeesu pu'u aji bəra'i, waatoo Tooma ətə ci ənjə a 'wa ‘Huyirənə,’ paa ci davə saa'itə shigərə Yeesu. ");
INSERT INTO gde_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","Wata hara lyawarənə a ba ka ci, əŋki tii, “Kə nee inə ka Slandana.” Amma əŋki Tooma ka tii, “Maɗaamə nyi kə nee ka baavənyinə ŋga kuusa asəkə ciikii, nya təɓətə də ciinəkii patə da i taŋgalakii, pooshi nyi ka luuvənə shaŋə.” ");
INSERT INTO gde_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Ma daaba'ə luuma rəŋwə, kə ənyi lyawarənə ŋga Yeesu ka dza də na, təya pa'əənə makuvə aanətii. Ma saa'ikii, davə nə Tooma. Mapa'əkii nə makuva, amma wata Yeesu a dzə, ca kəŋaanə ahadatii, əŋki ci ka tii, “Wa jamənə a ndzaanə ahadoonə.” ");
INSERT INTO gde_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Əŋki ci ka Tooma, “Kavə ciinəku aahanə, ha tsaamətə ciinəki, ha ŋgərə ciinəku, ha kavə aataŋgalaki. Bwasee ka ghatə vii gooŋgaaku ka nyi, ha vii gooŋga.” ");
INSERT INTO gde_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Tooma a ba ka ci, “Slandanəki da Əntaŋfwaakya!” ");
INSERT INTO gde_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Əŋki Yeesu ka ci, “Kə vii hə gooŋga ha'ə, makə nee hə ka nyi kwa? Tə'i barəkaanə ashi ənjitə vii gooŋga, tii ma'ə maneemə ka nyi.” ");
INSERT INTO gde_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Tə'i hara sə ŋga hurəshishinyinə laŋə ətə ɗaaɗii Yeesu, lyawarənaakii a tsaamə, amma pooshi ənji nyaahə aasəkə ləkaləkatəna. ");
INSERT INTO gde_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amma ma ənə naahəcii ənji, koona shii vii gooŋga oo'i, Yeesu nə Mataɗəkii, ci nə *Uuzənə ŋga Əntaŋfə. Dagi gi'inə goonə tə ci nuuna upaa əpinə. ");
INSERT INTO gde_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Ma daaba'ə ətsa, kə ənyi Yeesu ka jigaginə ka lyawarənaakii. Ma ətsa, ama uunəvə ŋga Tibeeriya. Wiinə makə sətə slənyi. ");
INSERT INTO gde_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ma davə, tə'i Simoonə Piita, ba'ə Tooma ətə ci ənjə a wa ‘Huyirənə’, ba'ə Nataniyalə əndə Kana ŋga hanyinə ŋga Galili, ba'ə manjeevənə ŋga Zabadiya da hara *lyawarənə bəra'i davə nə tii patə. ");
INSERT INTO gde_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Əŋki Simoonə Piita ka hara ənji, “A palə nyi ka təəmənə.” Əŋki tii ka ci, “Amə patə ca palə.” Wata təya maɗə, təya palə aasəkə kumbawala. Amma ha'ə ba'agi tii həmə, pooshi tii kəshi hərəfinə. ");
INSERT INTO gde_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Ma ətsə uusəra a lə'ya, wata Yeesu a kəŋaanə anə ndəra, amma pooshi tii shii oo'i Yeesu ətsa. ");
INSERT INTO gde_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Wata əŋki ci ka tii, “Uuji daguyiina, pooshi unə kəshi uushi kwa?” Əŋki tii ka ci, “Pooshi taa mi.” ");
INSERT INTO gde_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Əŋki ci ka tii, “Kagərəmə slaaɗə goonə aadə ciizəma kumbawala, ka kəsənə nuunə hərəfinə.” Wata təya ka slaaɗatii. Makə kii tii, kə təkuree tii ka əlyaginə agi ma'inə acii kə kəshi tii hərəfinə laŋə. ");
INSERT INTO gde_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Wata lawarətə palee Yeesu də uuɗənə a ba ka Piita, əŋki ci, “Slandanə ətsa!” Makə fii Piita oo'i Slandanə ətsa, wata ca əgətə kəjeerənaakii, acii masəɗəkii nji ci, ca ləɗəgərə aagi ma'inə. ");
INSERT INTO gde_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Ma hara lyawarənə, kə shi tii aama ndzaŋa də kumbawala, təya əlya slaaɗatii pasə da i hərəfinə asəkəkii. Pooshi tii dzaɗə dzaɗə da ndəra, wata təɗanə gya'ə tanə. ");
INSERT INTO gde_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Makə mbu'i tii aanə ndəra, wata təya nee ka iləgunə da i hərəfinə agikii da i buroodi. ");
INSERT INTO gde_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Əŋki Yeesu ka tii, “Kiramə hərəfiitsə kəshuunə.” ");
INSERT INTO gde_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Simoonə Piita a ndərə aasəkə kumbawala, ca kəsətə slaaɗa pasə da i madiigərə hərəfinə asəkəkii, kaa ca tə'yagi aanə ndəra. Ma asəkəkii, tə'i hərəfinə gya'ə da tufə pu'unə aji makkə. Taa ŋgahi laŋə nə hərəfinə asəkə slaaɗəkii, amma pooshi tsii. ");
INSERT INTO gde_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Əŋki Yeesu ka tii, “Shoomə ka zəmənə.” Pooshi əndə ahada lyawarənə satə uuɗəfə ka ləgwanə ama Yeesu “Wu nə ha?” acii kə shii tii oo'i, Slandanə ətsa. ");
INSERT INTO gde_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Wata Yeesu a dzə, ca ŋgərə buroodi, ca vii ka tii, ca ŋgərə hərəfinə, ca vii əsə. ");
INSERT INTO gde_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Ətsə nə makkənə ŋga jigaginə ŋga Yeesu ka lyawarənaakii daaba'ə maɗənaakii agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ma daaba'ə makə zhimə tii, əŋki Yeesu ka Simoonə Piita, “Simoonə uuzənə ŋga Yoohana, kə uu'i hə tə nyi palee ka hara ənjinə kwa?” Əŋki Piita, “Awa Slandana, kə shii hə, kə uu'i nyi tə hə.” Əŋki Yeesu ka ci, “Nəhuu uuji bagiinaaki.” ");
INSERT INTO gde_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Yeesu a ənə ka ləgwanə ka ci ŋga bəra'inə, əŋki ci, “Simoonə uuzənə ŋga Yoohana, kə uu'i hə tə nyi kwa?” Əŋki Piita, “Awa Slandana, kə shii hə, kə uu'i nyi tə hə.” Əŋki Yeesu ka ci, “Gəratə ka nyi bagiinaaki.” ");
INSERT INTO gde_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Yeesu a ləgwa ka ci ŋga makkənə, əŋki ci, “Simoonə uuzənə ŋga Yoohana, kə uu'i hə tə nyi kwa?” Kə ɓəzhi səkə ŋga Piita acii kə ləguyi Yeesu amakii ŋga makkənə oo'i, kə uu'i hə tə nyi kwa? Wata əŋki ci ka ci, “Slandana, kə shii hə uushi patə, kə shii hə kə uu'i nyi tə hə.” Əŋki Yeesu ka ci “Nəhuu bagiinaaki. ");
INSERT INTO gde_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Tantanyinə cii kya ba ka hə, ma saa'itə hə ma'ə uundzə dagwa, kə izee hə ka tasəkanə ka palənə ka hatə cii kwa moo patə. Amma maa kə iirə hə, ka kapaanə nə hə ciinəku, əndə'i əndə a tasəka tə hə, ca kərə tə hə ka hatə pooshi maku ka moonə.” ");
INSERT INTO gde_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Ma agi waɓəətsa, agi ɓaariinə nə Yeesu makə sətə nə Piita a əntə ka ɓaarii də ɗuunuunə ŋga Əntaŋfə. Wata əŋki Yeesu ka ci, “Nə'uu tə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Wata Piita zə'ugi, ca nee ka *lawara ətə palee Yeesu də uuɗənə, ətə sha ləguyi ama Yeesu də banə, ‘Slandana, wu saŋə na vii tə hə ka ənja?’ Waatoo saa'itə ndzaa ci ataŋgalakii, təya zəmə əndzanə ŋga Slandana. ");
INSERT INTO gde_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Makə nee Piita ka ci, kə ləguyi ci ka Yeesu, əŋki ci, “Slandana, ya əndənə naakəya?” ");
INSERT INTO gde_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Əŋki Yeesu ka ci, “Ma ca, maɗa kə mwayi nyi kaa ca ndzaanə da i əpinə amakii ca'ə ka saa'itə nii kya ənya, ka mi cii kwa buura? Ma hə, nə'uu tə nyi.” ");
INSERT INTO gde_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Wata waɓənəkii a təəkəgi ahada ənji nə'unə tə Yeesu oo'i, ma lawarəta, paa ci ka əntənə. Amma pooshi Yeesu bii oo'i, paa ci ka əntənə. Ma bii ca, “Maɗa kə mwayi nyi kaa ca ndzaanə da i əpinə amakii ca'ə ka saa'itə nii kya ənya, ka mi cii kwa buura?” ");
INSERT INTO gde_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Ci nə lawarətə waɓi agyanə uushi'iina, ci nyaahə əsə. Kə shii inə oo'i, ma sətə bii ci, gooŋga. ");
INSERT INTO gde_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Yoo, tə'i hara uushi'inə laŋə ətə ɗaaɗii Yeesu. Maci kə naahəpaa ənji də rəŋwə rəŋwə patə, kə shii nyi, pooshi duuniya ka ŋgərətə laŋənə ŋga ləkaləkatənyinəkii.");
INSERT INTO gde_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","'Ya'ə Tawəfilasə, ma asəkə ləkaləkataaki ŋga təkəŋwanə, kə nyaahə nyi sətə ɗaaɗii Yeesu patə da sətə jigunyi ci, daga saa'itə 'watəgi ci sləna ");
INSERT INTO gde_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ha'ə mbu'ya ka saa'itə ŋgirə Əntaŋfə tə ci aadəgyə. Ma taabu'u ŋgirə Əntaŋfə tə ci aadəgyə, kə ɗii ci waɓənə ka ənjitə shi ca ta'i dagi baawəɗa ŋga Malaaɓa Ma'yanə, kaa təya ndzaa ka masləkee ənjaakii. ");
INSERT INTO gde_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Kə ɓaarii ci ka tii naakii nə da i əpinə amakii ŋga baanə ənfwaɗə pu'unə. Kə ɗaaɗii ci uushi'inə laŋə ətə ca ɓaarii oo'i, da i əpinə nə ci. Ca waɓə ka tii agyanə *ŋwaŋuunə ŋga Əntaŋfə. Ma ətsə patə, kə slənyi daba'ə əntənaakii da maɗənaakii agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Ma ka əndə'i uusəra, ci ahadatii, kə bii ci ka tii, “Goona dzəgi asəkə vəranə ŋga Urusaliima zəku'i, gəramə sətə bii nyi viinə koonə, waatoo, sətə bii Daadə oo'i, ka viinə nə ci koonə. ");
INSERT INTO gde_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Acii də ma'inə ɗii Yoohana bapətisəma ka ənja. Amma, ma aakəŋwa gi'u, bapətisəma də Malaaɓa Ma'yanə nuuna upaa.” ");
INSERT INTO gde_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Makə liɓə Yeesu da masləkee ənja, kə ləguyi tii ka ci, əŋki tii: “Slandana, əndzə'i nə hə ka ənəpaaginə ka ənji *Isərayiila də ŋwaŋuunatii kwa?” ");
INSERT INTO gde_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Əŋki Yeesu ka tii, “Kə kəŋee Daadə ka saa'ikii da zamanakii agi baawəɗaakii. Ma una, pooshi unə ka shiinə taa guci ɗaaɗanə uushi'iitsa. ");
INSERT INTO gde_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amma shiimə oo'i, ka viinə nə Əntaŋfə koonə Malaaɓa Ma'yanə. Də ci nuuna upaa baawəɗa, koona ndzaanə ka ənji waaza waɓənaaki asəkə vəranə ŋga Urusaliima da i hara hanyinə ŋga Yahudiya da i *Samariya, dəŋə ka hatə ənyagi hanyinə.” ");
INSERT INTO gde_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Uudəpaanə ŋga Yeesu tə waɓəətsa, təya tsaamə tə ci, Əntaŋfə a ŋgərətə tə ci aadəgyə, kuraɓiinə a rarə'igi də ci anə ginətii. ");
INSERT INTO gde_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Ma təya tsaamə aadəgyə, ca dzə də ndərənə. Ma nee tii, wata wiitsə ənji bəra'i aɓitii da i mabwaɗaɗa kəjeerənə ashitii. ");
INSERT INTO gde_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","Təya ba ka masləkee ənji, “Unə ənji Galili, mi ɗii unə kəŋə kəŋə ka tsaamənə aadəgyə kwa? Yeesu ətsə ŋgərətə Əntaŋfə tə ci aadəgyə aɓii unə, ha'ə nii kəya ənya makə sətsə nee unə pyalə ci aadəgyə.” ");
INSERT INTO gde_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Ma daba'əkii, wata masləkee ənjə a jimagərə anə giŋwə ŋga Zayitunə, təya ənya aa Urusaliima; ka ɗanə nə dzaɗənəkii bahə kiloomeeta rəŋwə. ");
INSERT INTO gde_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Makə mbu'i tii, təya ndərəgi aanə maɗuunə kuvə anə əndə'i ətə izee tii ka ndzaanə davə. Ma ənjitə dzii də nə dava, tii nə i Piita da Yoohana da Yakubu ba'a Andərawəsə, i Filibusə da Tooma, Barətalamawusə da Mata, əndə'i Yakubu uuzənə ŋga Haləfa, Simoonə əndə moo dimwaanə ŋga hanyinaakii, ba'a Yahuda, uuzənə ŋga Yakubu. ");
INSERT INTO gde_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Mariyaama məci Yeesu i ndzəkəŋushi'inə ŋga Yeesu da i hara makinə patə, davə nə tii, təya ləɓə də nə də mooɗəfə rəŋwə agi kədiinə acii Əntaŋfə taa ŋgutə saa'i. ");
INSERT INTO gde_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ma agi saa'ita, kə dzii ənji nə'unə də na, kə mbu'i laŋənatii bahə gya'ə da pupusərə. Piita a maɗətə ahadatii, ca waɓə ka tii, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“Ndzəkəŋushi'inəkya, kə waɓi Malaaɓa Ma'yanə da ma *Dawuda agyanə Yahuda ətə ɓaarii tə Yeesu ka ənja. Ma waɓənaakii, kə ndzaa tyasə, see a ɗa ki ka gooŋga, waatoo sətsə ɗii tə Yahuda. ");
INSERT INTO gde_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","Acii ma Yahuda, kə ndzaa ci ka əndə gaamə, Yeesu ta'i tə ci kaama slənə ka ha rəŋwə ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","Amma ma ci, kə ɗərəgi ci ra də kwaɓatə upaa ci agi bwaya slənaakii. Ma daba'əkii, ca kulagi aa pa, səkəkii a tsəərəgi, aginaakii a əjagi patə. ");
INSERT INTO gde_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","Ənji Urusaliima patə, kə fii tii haalaakii. Ci ɗii kavə tii ləmə ka rəkii də uuratii Akalədama, makə bana, ‘Rə ŋga idəna’. ");
INSERT INTO gde_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Tə'i manaahəkii asəkə ləkaləkatə ŋga Jabuura: ‘Ka ndzaanə nə yaakii uufinə zaɓə, ga əndə a ndzaanə davə.’ Kə nyaahə ənji əsə: ");
INSERT INTO gde_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","‘See a ŋgərə əndə'i əndə slənaakii.’ Makə ha'ə ɗii əna, ma ənjinə nja dzəədzə deenə oogə da i Yeesu Slandanaamə taa guci patə, ");
INSERT INTO gde_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","'watəginə ka yiɓə bapətisəma ŋga Yoohana ka Yeesu, ha'ə ka saa'itə ŋgirə Əntaŋfə tə ci aadəgyə, ma əndə rəŋwə agi ənjitsa, tyasə, ka ndzaanə nə ci ləɓə deenə, ina baaba maɗənə ŋga Yeesu agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Makə fii ənji ha'ə, təya taɗə ənji bəra'i, waatoo Yusufu ətə ci ənjə a 'wa tə ci Barəsaba taa Yusətusə, tii da Matiyasə. ");
INSERT INTO gde_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","Wata təya kədii, əŋki tii, “'Ya'ə Slandana, kə shii hə sətə a ədzəmə ənji patə, ɓaarii keenə ahada ənjinə bəra'i taa tə wu ta'i hə, ");
INSERT INTO gde_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","kaa ca ŋgərə slənə ŋga əndə sləkeenə ənə kagi Yahuda, makə kə pyalə ci saakii makə sətə dəɓee ka ci.” ");
INSERT INTO gde_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Ma daba'əkii, təya kapaa haalakii akəŋwacii Əntaŋfə kaa ca ɓaarii ka tii taa tə wu ta'i ci. Wata ca ɓaarii ka tii tə Matiyasə. Kə ndzaa Matiyasə ka pu'u aji bəra'inə ŋga masləkee ənja. ");
INSERT INTO gde_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Makə mbu'ya uusərə ŋga kumənə ŋga *Peentakoosa, kə dzatə ənji nə'unə də nə patə ka ha rəŋwə. ");
INSERT INTO gde_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Pii təya fa lyaamanə ŋga uushi dadagyə makə laamənə ŋga mandalə məɗa. Wata laamənəkii a nagi kuvətə dzatə tii də nə davə. ");
INSERT INTO gde_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Wata təya nee ka uushi a jiga makə gana ŋga gunə. Ca taala, ca təəkəgi agyanə taa wu patə davə. ");
INSERT INTO gde_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Malaaɓa Ma'yanə a naanatə ədzəmətii patə, təya ndzaŋə waɓənə də uuranyinə kama kama makə sətə vii Malaaɓa Ma'yanə ka tii waaɓənə. ");
INSERT INTO gde_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Ma gatə də Urusaliima, tə'i *Yahudiinə ətə ca ŋgwalə tə Əntaŋfə shiishi agyanə hanyinə ŋga duuniya patə. ");
INSERT INTO gde_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Makə fii ənji wazənə, kə dzii ənji də nə laŋə. Haŋkalatii a gwazəgi, acii kə fii tii təya waɓə də uura ŋga taa ŋgutə əndə ahadatii. ");
INSERT INTO gde_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Kə ɗii ka tii ka sə ŋga hurəshishinə ka shaŋə, təya ba, “Əntaa ənji Galili nə ənjitsə ca waɓə pata? ");
INSERT INTO gde_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Ya əna, iitə ɗii mbee tii ka waɓənə də uura ŋga taa ŋgutə əndə ahadaama? ");
INSERT INTO gde_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Wiinə kə shaamə agyanə hanyinə ŋga Parətiya, Madiya, Ilamiya, Misaputamiya, Yahudiya, Kapadasiya, Puntu, Asiya, ");
INSERT INTO gde_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Firigiya, Paməfiliya, Misəra, i da purəŋa Libiya ətə ŋga Sirina, i Yahudiinə da ənjitə dəməgərə agi diina ŋga Yahudiinə, kə shi tii daga də Rooma; ");
INSERT INTO gde_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","wiinə kə shi hara ənji gaamə daga də Karita da Arabiya: wanaamə patə ka fanə təya ba agi uuranyinə gaamə tə maŋgwaarə slənətə slənyi Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Makə gwazəgi haŋkalatii patə, təya ləgwa ahadatii tuu'ina, “Mi saŋə cii kəya moo ɓaariinə kaama?” ");
INSERT INTO gde_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Amma, ma hara ənja, təya gwaŋə ka ŋusənə, əŋki tii, “Kə sii ənjinə ənvwa.” ");
INSERT INTO gde_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Wata Piita a maɗətə da masləkee ənjitə pu'u aməntaŋə. Ca maɗee ka uurakii, ca waɓə ka tii, əŋki ci, “Unə ənji Urusaliima da hara Yahudiinə makə nyi, fatəmə ŋga'ə, kaa nya ba koonə: ");
INSERT INTO gde_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ma ənjina, masamə tii ənvwə makə sətsə cuuna hiima, acii ma'ə uusəra magiramə zəku'i. ");
INSERT INTO gde_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Amma, fatəmə kaa nya ba koonə sətə bii anabi Yawalə: ");
INSERT INTO gde_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","‘Ma bii Əntaŋfə, ma agi muudinə ŋga zamana, ka shinə nə Malaaɓa Ma'yanə aagyanə ənji patə, manjeevənə goonə ŋguyirənə da makinə, ka ɗanə nə tii anabaakwaanə; ma daguyinə goonə, ka ɓaariinə nə Əntaŋfə ka tii gooŋgaanaakii, masariinə goonə əsə, ka səniinə nə tii. ");
INSERT INTO gde_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Gooŋga boo, ma maviinaaki ŋguyirənə da makinə, ka kyanə nə nyi Malaaɓa Ma'yanaaki aanətii ka saa'ikii, ka ndzaanə nə tii ka anabiinə. ");
INSERT INTO gde_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","Ka ɗanə nə nyi sə ŋga hurəshishinə daga dagyə da agyanə hanyinə əsə; ka jiganə nə idənə da gunə da makiirənə mandəkii. ");
INSERT INTO gde_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","Ka zhi'iginə nə uusəra ka təkunə. Ka zhi'iginə nə ləgiɗə dizə makə idəna. Ma ətsə patə, ka ɗanə taabu'u nə maɗuunə uusərə ŋga Slandanaamə a mbu'ya. ");
INSERT INTO gde_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Taa wu kədii luupaanə acii Slandana, ka mbəɗənə nə ci.’ ” ");
INSERT INTO gde_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Piita a dzə aakəŋwa də banə, əŋki ci, “Unə ənji Isərayiila, fatəmə waɓənaaki ŋga'ə. Ma Yeesu əndə Nazaratu, kə ɓaarii Əntaŋfə oo'i, ci sləkee ka ci, ci nee unə slənyi Əntaŋfə sə ŋga hurəshishinə də baawəɗa laŋə daciikii ahadoonə. ");
INSERT INTO gde_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Aacii unə kavə Əntaŋfə tə ci makə sətə ɗii ci aniya ŋga ɗanə. Kə kavuunə tə ci aacii bwaya ənji, təya gwa'avə tə ci aashi ənfwə, ca əntəgi. ");
INSERT INTO gde_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amma kə ŋgiragi Əntaŋfə tə ci agi zəmənə ŋga wa, ca maɗee ka ci agi maməətə ənja, acii pooshi wə da baawəɗa agyanəkii bahə ca gigisləpaa tə ci. ");
INSERT INTO gde_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Acii kə waɓi Dawuda agyanəkii, oo'i: ‘Wanyinə ka neenə ka Slandanə akəŋwaciiki taa guci patə, agi tsakənə nə ci tə nyi acii ga nya gugu'i. ");
INSERT INTO gde_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Ci nə ədzəməki ka ɗa mooɗasəka əsə, agi waɓənə nə nyi ŋga mooɗasəka. Taa ŋgahi ka əntənə nə nyi, agi kanə nə nyi na, ");
INSERT INTO gde_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","acii kə shii nyi: 'ya'ə Əntaŋfwaakya, paa hə ka vugədəgi əpinaaki aagi ənjagu'u, paa hə ka bwasee ka shishinə ŋga əndə slənaaku kaa ca ɓəsləgi. ");
INSERT INTO gde_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Kə ɓaarii hə ka nyi rəgwanyinə ŋga upaa də əpinə. Ka ɗanə nə nyi mooɗasəkə laŋə, acii agi ndzaanə nə hə da nyi.’ ” ");
INSERT INTO gde_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Piita a dzə aakəŋwa də banə, əŋki ci, “'Ya'ə ndzəkəŋushi'inəkya, takumə kaa nya bagi koonə furəŋə. Ma dzədzəshi'inaamə Dawuda, kə əŋki ci, kə ŋgəɗəgi ənji tə ci, kədəhə daamə nə nə ŋga gu'waakii ka ha'ə dəŋə ənshinə. ");
INSERT INTO gde_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Amma, ma ci ma'ə da i əpinə, anabi nji ci, kə shii ci kə ji'i Əntaŋfə ka ci oo'i, kadə nə əndə rəŋwə agi jijinaakii a ŋgərə dəgələ ŋwaŋuunaakii. ");
INSERT INTO gde_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","Agyanə maɗənə ŋga *Aləmasiihu agi maməətə ənja waɓi Dawuda ha'ə. Aciikii bii ci, pooshi Əntaŋfə ka bwaseenə ka ci a gu'u. Taa shishinəkii əsə, pooshi ka ɓəslənə. ");
INSERT INTO gde_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Ma Yeesutsa, kə maɗee Əntaŋfə ka ci agi maməətə ənja. Inə ənə ganə patə, seedawanyinə niinə. ");
INSERT INTO gde_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Kə ɗuunətə Əntaŋfə tə ci, ca ndzanee ka ci da ciizəmakii. Əntaŋfə Dii a vii ka ci Malaaɓa Ma'yanə, makə sətə shi ca bii daga ŋukə. Yeesu a pukyagərə keenə əsə, ci ətsə cuuna nee, una fa əsə. ");
INSERT INTO gde_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","Acii əntaa Dawuda ŋgirə aadəgyə, amma ci maa, kə bii ci oo'i, ‘Əŋki Əntaŋfə Slandanə ka Slandanəki, ndzaanə gadəvə da ciizəmaki. ");
INSERT INTO gde_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","Ka kavənə nə nyi tə ənji daawaanaaku aatsaa səɗəku.’ ");
INSERT INTO gde_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Acii ha'ə, wa ənji Isərayiila patə a shii tantanyinə, ma Yeesu ətə gwa'avuunə tə ci aashi ənfwa, tə ci kavə Əntaŋfə ka ndzaanə ka Slandanə da Aləmasiihu.” ");
INSERT INTO gde_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Makə fii ənji ha'ə, kə taɓətə mooɗəfətii, təya ləgwa a ma Piita da a ma hara masləkee ənji, əŋki tii, “Ndzəkəŋushi'ina, iitə ɗaniina?” ");
INSERT INTO gde_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Əŋki Piita ka tii, “Baamə ka Əntaŋfə, bwaseemə ka 'waslyakəənə goonə, taa wu ahadoonə, ca luu yiɓə bapətisəma agi ləmə ŋga Yeesu Aləmasiihu, kaa Əntaŋfə a tifyagi koonə 'waslyakəənə goonə, ca vii koonə Malaaɓa Ma'yanaakii. ");
INSERT INTO gde_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Acii koonə ɗii Əntaŋfə aləkawalə ŋga vii Malaaɓa Ma'yanə da ka manjeevənə goonə da patənə ŋga ənjitə dzaɗə, taa moonə 'wii ci patə aaɓiikii.” ");
INSERT INTO gde_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Kə waɓi Piita ka tii laŋə, ca ka ka tii hiima, əŋki ci, “Təkeemə ka noonə na da bwaya ənji ŋga zamanana koona luupaa də noonə na, acii bwaya ŋgəra'utə nə təya sa.” ");
INSERT INTO gde_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Laŋənatii, kə liwə tii waɓənaakii, ənjə a yiɓə ka tii bapətisəma. Kə mbu'i bahə dəbu'u makkə nə ənjitə vii gooŋga uusərəkii. ");
INSERT INTO gde_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","Kə ɗii tii gazhi'waanə ŋga fa sətə nji masləkee ənjə a dzəgunə ka tii, təya ndzaanə də ədzəmə rəŋwə, təya zəmə ka hakii, təya ɗa də'wa ka Əntaŋfə əsə. ");
INSERT INTO gde_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Kə ɗii Əntaŋfə sə ŋga hurəshishinə ŋgaaŋga'ə dacii masləkee ənja, ka ha'ə kə əsəgi ŋgwalənə tə ənji patə. ");
INSERT INTO gde_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Ənji nə'unə patə, kə ndzaa tii rəŋwə, təya viishi patənə ŋga sətə ətee əndə'i əndə ahadatii, ");
INSERT INTO gde_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","təya ɗərəmagi də uushi'inatii, təya vii kwaɓakii ka taa wu ətə ətee ahadatii. ");
INSERT INTO gde_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Pukyanə ŋga ha patə, agi dzatənə nə tii də nə asəkə *yi ŋga Əntaŋfə də mooɗəfə rəŋwə, təya zəəməshi asəkə yinyinatii də mooɗasəkə da mabanee ma'yanə. ");
INSERT INTO gde_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Təya dəla də Əntaŋfə, təya upaa dəlanə əsə acii ənji patə. Ma Slandana, uusərə patə nə ci ka tsakəvənə aashitii tə ənjitə upaa luupaanə. ");
INSERT INTO gde_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Ma ka əndə'i uusəra, i Piita da Yoohana a dzə aasəkə yi ŋga Əntaŋfə ətsə tibisə makkə ŋga kədəwanə, waatoo saa'i ŋga ɗa də'wa. ");
INSERT INTO gde_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Tə'i əndə'i əndə gatə a uura mayi ŋga Əntaŋfə. Ma uura mayitsa, ‘Dagwakii’ ci ənjə a 'wa. Mahurəməsəkii daga poonə tə ci nə əndəkii. Pukyanə ŋga uusəra patə nə ənjaakii ka kiranə tə ci aa dəvə, təya kapaa tə ci, kaa ca kədii sataka acii ənji dzənə aasəkə yi ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Makə nee ci ka i Piita da Yoohana təya dəmə aasəkə yi ŋga Əntaŋfə, ca kədii sataka aciitii. ");
INSERT INTO gde_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Wata i Piita da Yoohana a tsaamə tə ci, əŋki Piita ka ci, “Tsaamuu tiinə.” ");
INSERT INTO gde_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Ca tsaamə tə tii də ŋga'ə. Ma nə ci ka nəhənə, ka upaanə nə ci uushi aciitii. ");
INSERT INTO gde_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Wata Piita a ba ka ci, “Paa nyi da kwaɓa shaŋə, amma, ma səndə upaa nyi, ka viinə nə nyi ka hə. Də baawəɗa ŋga Yeesu *Aləmasiihu, əndə Nazaratu, maɗətə, wiiwu.” ");
INSERT INTO gde_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Wata Piita a kəsətə ciinəkii da ciizəma, ca maɗee ka ci. Pii kə upaa səɗəkii da idəkii ŋgeerənə. ");
INSERT INTO gde_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Həryatə əndətə a maɗətə, ca kəŋaanə, ca 'watəgi wiinə. Wata ca dəməgərə atsatii. Ca wii, ca dzə də ləəɗənə, ca dzə də dəlanə də Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Patənə ŋga ənjitə nji davə, kə nee tii ka ci, ca wii, ca dəla də Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","Kə shii tii oo'i, mahurəməsə əndətə izee ka kədii sataka a uura mayi ‘Dagwakii’. Acii ha'ə, kə ɗii ka tii ka sə ŋga hurəshishinə nə sətə ɗii tə ci. ");
INSERT INTO gde_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Makə mabwaseemə əndətə ka i Piita da Yoohana, tii atsaa malaɓatə ci ənjə a 'wa malaɓa ŋga Sulayimaanu, ənji patə a kwasə pii pii aaɓiitii, acii kə kəŋee ka tii ka shaŋə nə sətə ɗii. ");
INSERT INTO gde_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Makə nee Piita ka tii, ca ba, “Unə ənji Isərayiila, acii mi saŋə nuunə ka neenə ka hurəshishinə ŋga əndətsa? Acii mi cuuna tsaamə tiina? Ma nuunə ka nəhənə, agi baawəɗa geenə taa camənə geenə cii kəya wii kwa? ");
INSERT INTO gde_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Əntaa ha'ə. Ma Əntaŋfə ŋga i Ibərahiima da Isiyaaku da Yakubu da hara dzədzəshi'inaamə patə, ci vii ɗuunuunə ka Yeesu lawaraakii. Ma una, kə vii unə tə ci aacii gayinə. Makə mwayi Pilaatu kapaanə tə ci, kə kaaree unə. ");
INSERT INTO gde_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Də ha'ə kaaree unə ka Malaaɓa Əndəta, əndə gooŋga, una kədii ka ənjə a kagi koonə tə maɓələ ənja. ");
INSERT INTO gde_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","Də ɗanə ha'ə kavuunə tə Əndə vii əpinə ka ɓələginə. Amma kə maɗee Əntaŋfə ka ci agi maməətə ənja. Ma inə əsə, seedawanyinə niinə ŋga maɗənaakii. ");
INSERT INTO gde_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Ma əndənə cuuna nee, kə shii unə tə ci. Də baawəɗa ŋga Yeesu upaa ci ŋgeerənə, acii kə vii inə gooŋga ka ci. Ha'ə nə ci əsə, putə ŋga vii gooŋga geenə ka Yeesu upaa ci jamənə ŋga shishinəkii akəŋwacii unə patə. ");
INSERT INTO gde_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“Ma ənə ha'ə ɗii ndzəkəŋushi'ina, kə shii nyi oo'i, ma unə da i gayinə goonə, dagi ghatə shiinə goonə ɗii unə ha'ə də Yeesu. ");
INSERT INTO gde_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Amma də ha'ə ɗii ka gooŋga nə sətə bii Əntaŋfə da ma anabiinaakii oo'i, ka ciɓənə nə Mataɗəkəyaakii. ");
INSERT INTO gde_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","“Acii ha'ə baamə ka Əntaŋfə, zhi'wagimə aaɓiikii, kaa ca tifyagi koonə 'waslyakəənə goonə. ");
INSERT INTO gde_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","Maɗa kə ɗii unə ha'ə, ka viinə nə Slandanə koonə shiwunə aasəkə mooɗəfuunə, ka kyanə nə ci koonə də Mataɗəkəyaakii Yeesu. Ci ta'i koonə tə ci. ");
INSERT INTO gde_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Ma Yeesu, kə ɗii tyasə, see a ndzaa ci dagyə zəku'i, taabu'u nə Əntaŋfə a ɗaaɗa uushi'iitə baabii ci da ma malaaɓa anabiinaakii daga ŋukə. ");
INSERT INTO gde_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Muusa maa, kə bii ci oo'i, ‘Ka taɗənə nə Əntaŋfə koonə *anabi makə naaki agi ndzəkəŋushi'inuunə. See a foonə sətə nii kəya ba koonə patə. ");
INSERT INTO gde_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Taa wu patə na kaaree ka fanə tə anabita, paa tii ka ndzaanə agi ənji ŋga Əntaŋfə, ka zamaginə nə ənji də tii.’ ");
INSERT INTO gde_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Ha'ə əsə waɓi hara anabinyinə patə, 'watəginə ka Samuyila da hara anabinyinə ətə shi daba'əkii. Kə waɓi tii agyanə uushi'inə ətə ca ɗaaɗa əndzə'i. ");
INSERT INTO gde_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Ndzəkəŋushi'ina, koonə waɓi Əntaŋfə da ma anabinyiita. Ha'ə əsə koonə da dzədzəshi'inuunə ɗii ci aləkawala, waatoo ətə bii ci ka Ibərahiima, ‘Ka ɗaanənə nə nyi barəkaanaaki aagyanə slikərənyinə ŋga duuniya patə, putə ŋga jijinyinaaku.’ ");
INSERT INTO gde_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Ha'ə kə taɗəgi Əntaŋfə lawaraakii, ca sləkee ka ci aahadoonə zəku'i koona upaa barəkaanə daciikii, una bwasee ka bwaya bwayaanə goonə.” ");
INSERT INTO gde_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","Ma i Piita da Yoohana a waɓə ka ənja, wata limanyinə da ŋwaŋwə ŋga soojiinə ətə ca nəhə yi ŋga Əntaŋfə, da *Sadukiinə a shi aaɓiitii ");
INSERT INTO gde_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","də maɓəzə səka. Ma ɓəzee ka səkətii, acii kə jigunyi i Piita da Yoohana ka ənja, kə bii tii ka ənji oo'i, kə ma'i Yeesu agi maməətə ənja, aciikii ma maməətə ənji patə, kadə nə təya maɗətə da i əpinə. ");
INSERT INTO gde_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Wata təya kəsə tə i Piita, təya pa'əgi tə tii aasəkə kuvə furəshina see pukənə ŋga ha, acii kə uugi uusərə dzənə ka ɗa gəŋwanə. ");
INSERT INTO gde_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Amma, ma agi ənjitə fii waɓənə ŋga masləkee ənja, ɓəzəkii nə ənjitə vii gooŋga. Kə mbu'i laŋənatii bahə dəbu'u tufə. ");
INSERT INTO gde_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Pukənə ŋga ha, wata gayinə da masariinə da maliminə a ləɓə də Urusaliima patə. ");
INSERT INTO gde_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Təya dza də nə da gawə ŋga limanyinə ətə ɗii ləməkii *Anasə tii da i Kayafasə i Yoohana i Aləkəsandəra, da i hara slikərənə patə ŋga maɗuunə *limanə. ");
INSERT INTO gde_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","Təya sləkee ka ənji kaa təya kira tə i Piita da Yoohana, təya kəŋee ka tii akəŋwaciitii, təya ləgwa ka tii, əŋki tii, “Da saŋə upaa unə baawəɗatsa? Wu vii koonə rəgwa ŋga mbəɗəpaanə də mahurəməsə əndətsa?” ");
INSERT INTO gde_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Wata kə cakə Malaaɓa Ma'yanə natənə ədzəmə ŋga Piita. Ca ba ka tii, əŋki ci, “Unə gayinə da masariinə, ");
INSERT INTO gde_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","maɗa putə ŋga ŋga'aanə ɗii inə ka mahurəməsə əndətsə ɗii inə mawulakii akəŋwacii unə ənshinə, una ləgwa keenə taa iitə mbə'i ci, ");
INSERT INTO gde_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","yoo, see a shii unə da i ənji Isərayiila patə oo'i, də ləmə ŋga Yeesu Aləmasiihu əndə Nazaratu nə əndətsə kəŋə akəŋwacii unə ndaŋə ndaŋə. Ma unə, kə gwa'avuunə tə Yeesu aashi ənfwa, amma kə maɗee Əntaŋfə ka ci. ");
INSERT INTO gde_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Kə waɓi malaaɓa ləkaləkatə agyanəkii oo'i, ‘Ci nə faaratə kaaree unə, ənji ghənəna, amma ci ənəpaa ka faaratə palee də məghərəvənə.’ ");
INSERT INTO gde_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Daciikii rəŋwə dyaŋə upaanə ənji mbəɗənə, acii pooshi əndə'i əndə agi duuniya shaŋə ətə vii Əntaŋfə ka ci baawəɗa bahə kaama upaa mbəɗənə daciikii.” ");
INSERT INTO gde_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Kə nee *mətərəkinə ŋga Yahudiinə oo'i, ma i Piita da Yoohana, masooɗəfənyinə nə tii. Ma nee tii əsa, tyalakanyinə nə tii, əntaa majaŋga ənji əsə, kə ɗii ka tii ka sə ŋga hurəshishinə. Wata təya puləgi oo'i, tii da Yeesu nja ndzaanə. ");
INSERT INTO gde_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Amma, makə nee tii ka əndətə mbəɗəpaagi i Piita da Yoohana kəŋə aɓitii ndaŋə ndaŋə, kə ətee tii ka rəgwa ŋga ɗa mabizhinə. ");
INSERT INTO gde_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Aciikii təya səbagi tə i Piita da Yoohana agyə, təya ɗa mətərəkinə. ");
INSERT INTO gde_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","Əŋki tii, “Iitə ɗanaamə də ənjitsa? Acii gooŋga, ma ahada ənji Urusaliima patə, pooshi əndə mashiimə kə ɗii tii sə ŋga hurəshishiinə ka shaŋə. Pooshi amə ka mbee ka ɗa mabizhinə əsə. ");
INSERT INTO gde_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amma, acii ga waɓənəkii a tsakə waazanə ka hara ənja, see a baamə ka tii oo'i, ga təya ənə ka waɓənə ka taa wu də ləmə ŋga Yeesu ma'ə.” ");
INSERT INTO gde_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Wata təya ənə ka 'watənə tə masləkee ənja. Makə dəməgərə tii, təya ba ka tii, əŋki tii, “Goona ənə ka waɓənə taa dzəgunənə ka ənji də ləmə ŋga Yeesu ma'ə daga ənshinə!” ");
INSERT INTO gde_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Amma əŋki Piita da Yoohana ka tii, “Unə də noonə na, lagimə waɓəətsa, maɗa ŋga'ə akəŋwacii Əntaŋfə keena fa noonə, ina bwasee ka fa naakii. ");
INSERT INTO gde_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","Acii ma inə kamə, pooshi inə ka mbee ka ndzaanə zərakə yadə ba ka ənji sətə nee inə da sətə fii inə.” ");
INSERT INTO gde_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","Wata mətərəkinə a tsakə ka tii bariya də banə, ga təya ənə ka ɗanə ha'ə ma'ə. Təya kapaa tə tii, pooshi tii upaa rəgwa ŋga ciɓeenə ka tii, acii talakiinə patə, agi ɗuunətənə nə tii tə Əntaŋfə putə ŋga sətə slənyi tii. ");
INSERT INTO gde_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","Ma əndətə mbəɗəpaagi tii də sə ŋga hurəshishinə, kə palee ci ka fəzə ənfwaɗə pu'unə. ");
INSERT INTO gde_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Makə kapaa ənji tə i Piita da Yoohana, təya ənə satii aahada hara ənji nə'unatii. Təya ba ka tii sətə bii madiigərə limanyinə da masariinə ka tii. ");
INSERT INTO gde_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Makə fii ənji nə'unə ha'ə, təya kədii acii Əntaŋfə də ədzəmə rəŋwə, əŋki tii, “'Ya'ə Slandana, hə tagii ha dadagyə da ha a panə da uunəvə da sətə asəkətii patə. ");
INSERT INTO gde_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Kə waɓi hə da ma dəsəniinə Dawuda lawaraaku. Kə waɓi ci də baawəɗa ŋga Malaaɓa Ma'yanə, ca ba: ‘Acii mi ci hara slikərənə a ɓəzə səka? Acii mi saŋə ci ənjə a hiima uushi'iitə zaɓa? ");
INSERT INTO gde_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Kə aanyi meeminə ŋga *duuniya. Gayinə əsə, kə guŋutə tii də nə kaa təya pa da Əntaŋfə Slandanə da Mataɗəkəyaakii.’ ");
INSERT INTO gde_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Ha'ə makə ətsə ɗii *Hirudusə da Puntiyu *Pilaatu, kə ləɓə tii də nə ka hakii asəkə vəraanə da hara slikərənə da ənji *Isərayiila agyanə malaaɓa lawaraaku Yeesu mataɗəkəyaaku. ");
INSERT INTO gde_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ma sətə ɗii tii patə, kə ɗii tii makə sətə mwayi hə agi baawəɗaaku daga ŋukə. ");
INSERT INTO gde_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Ma əndzə'i, 'ya'ə Slandana, fatə bwaya uushi'iitsə ci təya baaba agyaniinə. Vii ka lyawarənaaku ŋgeerənə ŋga waaza waɓənaaku yadə ŋgwalənə taa gi'u. ");
INSERT INTO gde_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Tsakuu tiinə, ɓaarii baawəɗaaku, ina mbəɗəpaa də ənji bwanea, ina ɗa uushi'inə ŋga hurəshishinə agi ləmə ŋga malaaɓa lawaraaku Yeesu.” ");
INSERT INTO gde_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Makə uudəpaa tii ɗa də'wa, hatə ɗii tii davə patə, gaŋgəzənə. Wata kə cakə Malaaɓa Ma'yanə naanatənə tə tii patə. Təya ndzaŋə waaza waɓənə ŋga Əntaŋfə yadə ŋgwalənə. ");
INSERT INTO gde_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ənjitə vii gooŋga patə, kə ndzaa tii də mooɗəfə rəŋwə, haŋkalatii rəŋwə əsə. Pooshi əndə banə oo'i, ma sətə ɗii ka naakii, kə ndzaa ka naakii daanəkii. Amma, maləɓəkii nə tii patə anə uushi'inatii. ");
INSERT INTO gde_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","Də baawəɗa laŋə baabii masləkee ənji tə maɗənə ŋga Yeesu Slandana agi maməətə ənji makə sətə nee tii. Kə ɗii Əntaŋfə barəkaanə aagyanətii patə ka shaŋə shaŋə. ");
INSERT INTO gde_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Pooshi maagha agitii əsə. Acii patənə ŋga ənjitə da ratii taa yatii, kə ɗərəmagi tii, təya kira kwaɓakii, ");
INSERT INTO gde_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","təya kapaa akəŋwacii masləkee ənja, masləkee ənjə a təkə ka taa ŋgutə əndətə ətee ahada ənji nə'unə. ");
INSERT INTO gde_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ha'ə tə'i əndə'i əndətə ɗii ləməkii Yusufu agi slikərənə ŋga *Leewi. Masləkee ənjə a ɗəkə ka ci ləmə Barənaba, makə bana, ‘Mavii ŋgeerənə ka ənja’. Poonə tə ci, anə hanyinə ŋga Kipərusə. ");
INSERT INTO gde_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Tə'i raakii, ca ɗərəmagi, ca kira kwaɓakii, ca kapaa akəŋwacii masləkee ənja. ");
INSERT INTO gde_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amma tə'i əndə'i əndə ɗii ləməkii Ananiya tii da minaakii Safiira. Ca ɗərəmagi də əndə'i ratii. ");
INSERT INTO gde_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","Də shiinə ŋga minaakii ca umbee ka hara kwaɓakii, ca kərə harakii, ca kapaa akəŋwacii masləkee ənja, ca ɗatə makə patə vii ci. ");
INSERT INTO gde_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Wata əŋki Piita ka ci, “Ya hə Ananiya, mi saŋə kapaa hə rəgwa ka *Seetanə a dəməgərə aa mooɗəfəkwa? Wiinə kə jirakə hə ka Malaaɓa Ma'yanə, ha umbee ka hara kwaɓa ŋga rə goonə. ");
INSERT INTO gde_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Daga hə ma'ə maɗərəmagimə, naaku nə rəkii. Makə ɗərəmagi hə əsə, əntaa naaku nə kwaɓakii kwa? Iitiitə 'watəgi hə kaala hiima ŋga ɗa bwaya slənətsa? Əntaa ka ənji jirakə hə, amma ka Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Makə fii Ananiya waɓəətsa, wata ca kulagi, ca əntəgi. Ədzəmə ŋga ənji fanə patə, kə lagi. ");
INSERT INTO gde_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Wata daguyinə a shi, təya haɗətə tə ci, təya ŋgiragi tə ci agyə, təya ŋgəɗəgi. ");
INSERT INTO gde_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Ma daba'ə bahə tibisə makkə, minaakii a shi, ki mashiimə sətə ɗii tə ŋgurii. ");
INSERT INTO gde_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Əŋki Piita ka ki, “Bawə ka nyi, ha'ə makə ətsə nə kwaɓa ŋga rətə goonə ɗərəmagyuunə kwa?” Kya ba, “Awa, ha'ə ɗərəmagiinə.” ");
INSERT INTO gde_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Wata əŋki Piita ka ki, “Mi saŋə guŋunuunə də ma ka təɓə Ma'yanə ŋga Slandana? Fawə ənyanə ŋga daguyiitə ŋgə'i tə ŋgurəku. Watiitsə kə mbu'ya a makuvə. Ka ŋgərəginə nə tii tə hə agyə naaku əsə.” ");
INSERT INTO gde_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Wata kya kulagi atsaa səɗəkii, gudərəslə kya əntəgi. Daguyiitə a gimagərə, təya lapaa tə ki mantəkii. Wata təya ŋgərəgi tə ki agyə, təya dzə ka ŋgəɗəginə tə ki ataŋgala ŋgurii. ");
INSERT INTO gde_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Wata ədzəmə ŋga ənji nə'unə patə a lagi da ənjitə fii sətə ɗaaɗii patə. ");
INSERT INTO gde_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","Ma masləkee ənja, kə slənyi tii sə ŋga hurəshishinə laŋə ahada ənja. Patənə ŋga ənjitə vii gooŋga əsə, agi dzatənə nə tii də nə də ədzəmə rəŋwə atsaa malaɓatə ci ənjə a 'wa Malaɓa ŋga Sulayimaanu. ");
INSERT INTO gde_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","Ma hara ənjitə pooshi vii gooŋga, kə ŋgwali tii ka guŋutə də nə da tii, amma agi dəlanə nə tii də tii. ");
INSERT INTO gde_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","Ma ənjitə vii gooŋga ka Slandana, ŋguyirənə da makinə, tsakənə da tsakənə nə laŋənatii, təya ləɓə də nə da hara ənji nə'unə. ");
INSERT INTO gde_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Putə ŋga ətsə ha'ə, kə kyaara ənji ənji bwanea aa rəgwa da i ədəratii da ədzatii, təya banee ka tii; acii maa kə mbu'ya Piita, taa iitiitə mbu'u ka paləginə nə məndzaaŋgu'inaakii agyanə hara ənji bwaneatii. ");
INSERT INTO gde_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Kə shiishi hara ənji ɓəzəkii əsə daga ka giwanyiitə guŋutə də Urusaliima patə, təya kira ənji bwaneatii da ənji ginaajinyinə. Patə, kə mbə'i tii əsə. ");
INSERT INTO gde_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ma gawə ŋga limanyinə da patənə ŋga ənjitə ci təya ndzaanə, waatoo kurəgə ŋga *Sadukiinə, kə shirəhə tii ka masləkee ənji ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Təya kəsə tə tii, təya kərə tə tii aa furəshina, təya pa'əgi tə tii. ");
INSERT INTO gde_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","Amma, ma davəɗə, wata malaa'ika ŋga Əntaŋfə a shi, ca wunəgi makuvənyinə ŋga furəshina, ca əjagi tə masləkee ənji, ca ba ka tii: ");
INSERT INTO gde_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Dzəmə aasəkə *yi ŋga Əntaŋfə, una waɓə ka ənji agyanə kura əpinə.” ");
INSERT INTO gde_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Makə fii masləkee ənji ha'ə, təya palə tsəɗakə, təya dəməgərə aasəkə yi ŋga Əntaŋfə, təya dzəgunə ka ənja. Pukənə ŋga ha, gawə ŋga limanyinə a shigi da ənjaakii, ca fə'ya mətərəkinaakii da matakəŋwanyinə ŋga *Isərayiila patə. Təya sləkee ka soojiinə aa furəshina ka fə'yanə tə masləkee ənja. ");
INSERT INTO gde_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Mbu'unə nə soojiinə aa furəshina, malamə tii tə masləkee ənja. Wata təya ənya ka banə ka mətərəkinə, ");
INSERT INTO gde_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","əŋki tii, “Kə lapaa inə makuvənyinə mapa'əkii dəŋə dəŋə, ənji nəhənə əsə, patə nə tii davə. Amma, ma wunəginiinə makuva, pooshi inə lii tə tii davə.” ");
INSERT INTO gde_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Makə fii ŋwaŋwə ŋga soojiinə da madiigərə limanyinə, kə dzəgəpaa tə tii ka shaŋə nə sətə ɗii tə masləkee ənja. Mashiimə tii taa mi na uudə ba'a. ");
INSERT INTO gde_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Wata əndə'i əndə a shi aaɓiitii, ca ba ka tii, əŋki ci, “Ma ənjitə pa'əgyuunə ŋga mbəɗə asəkə furəshina, watiitə asəkə yi ŋga Əntaŋfə ka dzəgunənə ka ənja.” ");
INSERT INTO gde_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Wata ŋwaŋwə ŋga soojiinə da ənjaakii a palə ka 'wanə tə tii, amma əntaa də ŋgeerənə, acii kə ŋgwali soojiinə ga ənjə a kaalatə tə tii də faariinə. ");
INSERT INTO gde_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Makə kira tii tə masləkee ənja, təya kəŋee ka tii akəŋwacii mətərəkinə. Gawə ŋga limanyinə a ba ka tii, ");
INSERT INTO gde_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Kə shiina bii koonə də ŋgeerənə, goona dzəgunə də ləmə ŋga əndətsə ma'ə, amma wiinə kə guŋutəgyuunə də Urusaliima də dzəgunəətsə goonə. Ha'ə maa, ŋga'ə koonə nə ləɓeenə keenə da idənaakii.” ");
INSERT INTO gde_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Wata əŋki Piita da hara masləkee ənji ka tii, “Tyasə ka Əntaŋfə gərə'uniinə palee ka ənda. ");
INSERT INTO gde_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Ma unə, unə ɓələgi tə Yeesu də gwa'avənə tə ci aashi ənfwa. Amma kə maɗee Əntaŋfə ŋga dzədzəshi'inaamə ka ci agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Ka ci vii Əntaŋfə məghərəvənə əsə, ca ndzanee ka ci da ciizəmakii, kaa ca ndzaa ka gawə da maluwa, ca ɓaarii ka ənji Isərayiila rəgwa ŋga baanə ka ci, təya upaa tifyaginə ŋga 'waslyakəənatii. ");
INSERT INTO gde_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Ma inə, seedawanyinə niinə ŋga uushi'iitsa, ha'ə maa nə Malaaɓa Ma'yanə ətə vii Əntaŋfə ka ənjitə ca muu aaya ka ci.” ");
INSERT INTO gde_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Makə fii mətərəkinə ha'ə, səkətii a ɓəzəgi. Ha'ə kə mwayi tii ɓələnə tə tii. ");
INSERT INTO gde_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Amma tə'i əndə'i əndə Farisa ahadatii ətə ɗii ləməkii Gamaliyalə. Ma ca, mashii *bariya nə ci. Gawə nə ci əsə akəŋwacii ənji patə. Ca maɗətə, ca ba ka soojiinə wa təya fəɗəgi tə masləkee ənji agyə zəku'i. ");
INSERT INTO gde_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Makə dəməgi tii, ca waɓə ka mətərəkinə, əŋki ci, “'Ya'ə ndzəkəŋushi'inə, ənji Isərayiila, hiimatəmə ŋga'ə sətə cuuna moo ɗanə də ənjitsa. ");
INSERT INTO gde_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Ma wanyiinə dzəgi aa ba'a, kə shigi Tawəda da ba'akii bahə gya'ə ənfwaɗə ətə ca nə'u tə ci. Kə zhi'wee ci ka naakii nə ka uushi. Amma kə ɓələgi ənji tə ci. Ənji nə'unə tə ci patə əsə, kə yiigəɗəgi tii. Sətə mwayi tii ɗanə patə, kə ndzaanə ka uushi ŋga zaɓə. ");
INSERT INTO gde_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Ma daba'əkii, saa'i ŋga ɓaana ənja, kə shigi Yahuda əndə Galili. Kə 'wii ci ənji ka nə'unə tə ci, amma kə ɓələgi ənji tə ci əsə. Ənjaakii patə əsə, kə yiigəɗəgi tii. ");
INSERT INTO gde_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Acii ha'ə, shigimə agi waɓənə ŋga ənjitsə ca nə'u tə Yeesu, una bwasee ka tii. Acii maɗa əndə ca ba ka tii ɗa tsarə slənətsa, kadə na dzəgi. ");
INSERT INTO gde_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amma, maɗa Əntaŋfə ca ba ka tii ɗa tsarə slənətsa, pooshi unə ka mbee ka uulaginə tə tii. Nəhəmə acii goona ɗii panə da Əntaŋfə.” Wata mətərəkinə a luu waɓənə ŋga Gamaliyalə. ");
INSERT INTO gde_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Təya 'wagərə tə masləkee ənja, təya ba ka soojiinə, wa təya fəslə tə tii, təya ba ka tii, “Goona ənə ka waɓənə ka ənji də ləmə ŋga əndətsə ma'ə!” Ma daba'əkii, wata təya kapaa tə tii. ");
INSERT INTO gde_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Masləkee ənjə a gimagi satii ahada mətərəkinə, təya palə də mooɗasəkə ka shaŋə, acii kə mbu'utə Əntaŋfə də tii kaa təya sa ŋgəra'wə da ciɓa ka putə ŋga ləmə ŋga Yeesu. ");
INSERT INTO gde_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Pukyanə ŋga uusərə patə, taa asəkə *yi ŋga Əntaŋfə, taa asəkə yinyinə, mabwaseemə tii ka dzəgunənə da waazanə ka ənji oo'i, Yeesu nə *Mataɗəkii ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ma ka saa'ita, makə ci laŋənə ŋga ənji nə'unə tə Yeesu a dzə də tsakənə, kə ŋgiirə hara Yahudiinə ənji nə'unə ma, waatoo Yahudiitə ca waɓə uura Gərikə, oo'i, kə bwasee Yahudiinə ənji nə'unə ətə ca waɓə uura Yahuda ka mooryafinə ətə ca waɓə uura Gərikə, pooshi tii agi upaa sətə ci ənjə a təkə taa ŋgutə uusəra. ");
INSERT INTO gde_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Wata masləkee ənji pu'u aji bəra'i a dzatə də ənji nə'unə patə, təya ba ka tii, “Madəɓeemə ina bwasee ka waaza waɓənə ŋga Əntaŋfə, ina dzəgərə aagi təkə zəma. ");
INSERT INTO gde_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","Acii ha'ə, ndzəkəŋushi'inə, tagimə ənji məɗəfə ahadoonə ətə ci ənjə a dəla də tii, ətə da Malaaɓa Ma'yanə a mooɗəfətii da hiima əsə. Tə tii kavənə ənji aanə slənətsa. ");
INSERT INTO gde_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Ma inə neenə, ina ɗa gazhi'waanə ŋga ɗa də'wa da waaza waɓənə ŋga Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ma sətə bii masləkee ənja, kə kaɗeesəkə ka ənji nə'unə patə. Wata təya taɗə tə Sətəfanu, acii ma ca, əndə vii gooŋga nə ci ka shaŋə, manakii də Malaaɓa Ma'yanə əsə. Təya taɗə əsə tə Filibusə da Pərəkwara da Nikanoorə da Timoonə da Parəmina da Nikoolawusə əndə Antakiya, əndətə shi a dəməgərə aagi diina ŋga Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Təya kira tə tii aakəŋwacii masləkee ənji. Masləkee ənjə a ɗaanə ka tii də'wa, təya kavə ciinətii aanətii. ");
INSERT INTO gde_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Yoo, kə gi waɓənə ŋga Əntaŋfə aakəŋwa aakəŋwa. Agi tsakənə nə laŋənə ŋga ənji nə'unə də Urusaliima, ɓəzəkii agi limanyinə əsə vii gooŋga ka Yeesu. ");
INSERT INTO gde_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Ma Sətəfanu, kə ɗii Əntaŋfə ka ci pwapoonə, ca vii ka ci baawəɗa laŋə, kaa ca ɗa sə ŋga hurəshishinə ka shaŋə ahada ənja. ");
INSERT INTO gde_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","Amma tə'i hara Yahudiinə ətə izee ka dza də nə asəkə kuvə də'wa ətə ci ənjə a 'wa “Kuvə ŋga Dimwanyinə”. Kə shi tii daga də Sirina da i Aləkəsandəriya. Tə'i harii Yahudiinə əsə ətə shi daga də Silikiya da Asiya. Kə ɗii tii mabizhinə da Sətəfanu. ");
INSERT INTO gde_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Amma kə təkuree tii ka uurənə tə ci, acii kə waɓi ci də hiimatə vii Malaaɓa Ma'yanə ka ci. ");
INSERT INTO gde_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Wata təya ŋgaaŋgagi ənji də kwaɓa, ənjitə a ba oo'i, “Kə fii inə ca dzaana tə Muusa, ca bərapaa tə Əntaŋfə əsə.” ");
INSERT INTO gde_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Də ha'ə maɗee tii ka ədzəmə ŋga matakəŋwanyinə da maliminə da hara ənji patə. Təya əbuunə aanə Sətəfanu, təya kəsə tə ci, təya kərə aakəŋwacii *mətərəkinə. ");
INSERT INTO gde_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","Wata təya kira ənji vii seedanə ŋga jirakənə, ənjitə a ba, “Ma əndətsa, paa ci ka təkənə da waɓə bwaya uushi'inə aashi malaaɓa *yi ŋga Əntaŋfə da i bariya ŋga Muusa. ");
INSERT INTO gde_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Acii kə fii inə kə bii ci oo'i, ma Yeesu əndə Nazaratuta, ka uulaginə nə ci maɗuunə kuvətsə ŋga Əntaŋfə. Ca zhi'wee ka alə'aadanyiitə vii Muusa kaamə.” ");
INSERT INTO gde_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Tsaamənə nə mətərəkinə tə Sətəfanu. Ma təya nee patə, ma kəŋwaciinəkii, makə ŋga malaa'ika. ");
INSERT INTO gde_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Gawə ŋga limanyinə a ləgwa ka Sətəfanu, əŋki ci, “Gooŋga bii tii nii?” ");
INSERT INTO gde_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Əŋki Sətəfanu, “Ndzəkəŋushi'inəki da dəsənəkya, fatəmə kaa nya ba koonə. Ma Əntaŋfə Əndə məghərəvənə, kə shigi ci ka dzədzəshi'inaamə Ibərahiima daga ci ma'ə anə hanyinə ŋga Misaputamiya, ci ma'ə madzəmə aa Haranə zəku'i. ");
INSERT INTO gde_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","Əntaŋfə a ba ka ci: ‘Maɗəgi anə hanyinaaku, ha bwasee ka duuraaku, ha dzə aagyanə hanyiitə nii kya ɓaarii ka hə.’ ");
INSERT INTO gde_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Wata ca bwasee ka hanyinə ŋga Kalədiya, ca dzə ka ndzaanə də Haranə. Makə əŋki dii, Əntaŋfə a ŋgiratə tə ci, ca kira tə ci aanə hanyiinə ɗii unə anəkii əndzə'i. ");
INSERT INTO gde_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Ma saa'yakii, pooshi Əntaŋfə vii ka Ibərahiima taa ha ŋga kapaa səɗəkii anə hanyinəkii kaa ca ndzaa ka naakii. Amma, taa ŋgahi pooshi uuzənə ŋga Ibərahiima saa'ita, patə da ha'ə kə bii Əntaŋfə ka ci: ka viinə nə ci ka ci hanyinəkii tii da slikərənaakii ŋga ba'akii. ");
INSERT INTO gde_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Əntaŋfə a tsakə banə ka ci: ‘Kadə nə manjeevənaaku a ndzaanə anə məshipətə hanyinə, təya ndzaa ka maviinə, ənjə a ciɓə də tii ŋga fəzə gya'ə ənfwaɗə.’ ");
INSERT INTO gde_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Əŋki ci əsə: ‘Kadə nii kya la gəŋwanə agyanə ənjitə nə manjeevənaaku a slənə ka tii. Daba'ə ha'ə, təya ma'yagi anə hanyinəkii, təya shi ka paslənə tə nyi ganə.’ ");
INSERT INTO gde_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Wata Əntaŋfə a ɗa aləkawalə də *ryaminyanə ahadatii da Ibərahiima. Kə pwayi Ibərahiima tə Isiyaaku. Ca ryaminya tə ci ka tighəsənə ŋga uusəra. Isiyaaku a poo tə Yakubu, ca ryaminya tə ci. Ha'ə ɗii Yakubu əsə ka dzədzəshi'inaamə pu'u aji bəra'i. ");
INSERT INTO gde_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“Amma, ma dzədzəshi'inaamə, kə shirəhə tii ka əndə'i ndzəkəŋushi'inətii, waatoo Yusufu, təya ɗərəmagi də ci aanə hanyinə ŋga Misəra. Amma kə ndzaa Əntaŋfə kədəhə da ci, ");
INSERT INTO gde_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ca ŋgiragi tə ci agi ŋgəra'waakii patə. Kə vii ci ka ci pwapoonə da hiima akəŋwacii *Fəriauna, ŋwaŋwə ŋga Misəra. Fəriauna a kavə tə ci ka gawə agyanə taa mi patə anə hanyinə ŋga Misəra da asii gakii. ");
INSERT INTO gde_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Ma saa'ikii, kə ɗii məza maɗəfənə anə hanyinə ŋga Misəra da Kana'ana patə. Kə ciɓee maɗəfənəkii ka ənji ka shaŋə. Ha'ə kə təkuree dzədzəshi'inaamə ka sə ŋga adənə. ");
INSERT INTO gde_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","Amma, makə fii Yakubu tə'i sə ŋga adənə anə hanyinə ŋga Misəra, ca sləkee ka manjeevənaakii aadəvə, dzənə ŋga təkəŋwanə. ");
INSERT INTO gde_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Makə ənyi tii aa Misəra ŋga bəra'inə, ma saa'ikii, kə ɓaarii Yusufu naakii nə ka ndzəkəŋushi'inəkii. Də ha'ə əsə shii Fəriauna tə ndzəkəŋushi'inə ŋga Yusufu. ");
INSERT INTO gde_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Wata Yusufu a sləkee ka 'wanə tə dii, waatoo Yakubu da i yaakii patə, ənji məɗəfə pu'unə aji tufə nə tii. ");
INSERT INTO gde_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Yakubu a maɗə, ca palə aa Misəra. Davə əntəgi ci da hara dzədzəshi'inaamə. ");
INSERT INTO gde_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Makə məətəgi tii, ənjə a kira tə tii aa Sikamə. Davə ŋgəɗəgi ənji tə tii a gu'əndə ŋga Ibərahiima ətə shi ca ɗərəgi acii manjeevənə ŋga Hamoorə də Sikamə. ");
INSERT INTO gde_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“Makə uugi saa'i ɗanə kədəhə, waatoo saa'itə shi Əntaŋfə a bii ka Ibərahiima oo'i, ka ɗanə nə ci ka ci sətə bii ci, kə cakə ənji gaamə ɗanə laŋə də Misəra. ");
INSERT INTO gde_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Ha'ə kə ŋgirə əndə'i kura ŋwaŋwə aa dəgəla. Ma kura ŋwaŋutsa, paa ci sha fii habara ŋga Yusufu. ");
INSERT INTO gde_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","Kə fyaraanə ci ka dzədzəshi'inaamə, kə ciɓə ci də tii ka shaŋə. Ha'ə kə bii ci ka tii, tyasə a vugədəgi tii manjeevənatii acii ga təya girə əpinə. ");
INSERT INTO gde_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Saa'ikii pwayi ənji tə Muusa. Ma Muusa, kə ndzaa ci ka dagwa uuzənə akəŋwacii Əntaŋfə. Kə girə ənji tə ci ŋga ləgiɗə makkə asii ga dii. ");
INSERT INTO gde_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Makə nee tii, pooshi bahə kapaanə tə ci asii ma'ə, təya ŋgərə tə ci, təya kapaanə a babara. Wata uuzənə ŋga Fəriauna minəkii a ŋgərə tə ci, kya gərətə makə uuzənatə ŋga səkətə. ");
INSERT INTO gde_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Kə dzəgunətə ənji tə ci də shiinə ŋga Misəra patə. Ha'ə kə ndzaa ci ka ŋgurə waɓənə da slənə patə. ");
INSERT INTO gde_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“Makə mbu'i Muusa fəzə ənfwaɗə pu'unə, kə shi a ədzəməkii nə dzənə ka tsaamətənə tə ndzəkəŋushi'inəkii ənji *Isərayiila. ");
INSERT INTO gde_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","Makə gi ci, wata ca lapaa tə əndə'i əndə Misəra ka ciɓənə də əndə Isərayiila, wata ca kəsətə tə əndə Misərata, ca dəgəgi tə ci rəŋənə. Də ha'ə ki'i Muusa ka əndə Isərayiilatə naakii. ");
INSERT INTO gde_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Kə hiimii Muusa ka shiinə nə ənji Isərayiila oo'i, daciikii nə Əntaŋfə a luupaa tə tii. Amma, maneemə tii anəkii taa gi'u. ");
INSERT INTO gde_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Pukətə hakii əsə, ca lapaa tə ənji Isərayiila bəra'i ka panə. Ca alə haɗatənə də tii, ca ba ka tii oo'i: ‘Ya una, ndzəkəŋushi'inə nuunə. Mi saŋə cuuna pa?’ ");
INSERT INTO gde_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Ma əndətə ali haliminə ŋga ndzəkəŋuci, kə dzagi ci tə Muusa ataŋgala, ca ba: ‘Wu saŋə kapaa tə hə ka gawə da mala gəŋwanə ahadeena? ");
INSERT INTO gde_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Ŋga'ə ka hə nə ɓələ tə nyi makə ətə ɓələgi hə tə əndə Misəratə ŋga mbəɗə kwa?’ ");
INSERT INTO gde_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Makə fii Muusa ha'ə, ca huyipaa saakii aanə hanyinə ŋga Madiyanə, ca ndzaa davə. Davə pwayi ci manjeevənə uuji ŋguyirənə bəra'i. ");
INSERT INTO gde_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","“Ma daba'ə fəzə ənfwaɗə pu'unə, kə jigagi malaa'ika ka Muusa agi bilinə, ci ataŋgala giŋwə ŋga Siina. Kə jigagi ci də gana ŋga gunə dagi ba. ");
INSERT INTO gde_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Makə nee Muusa, kə ɗii ka ci ka sə ŋga hurəshishinə, ca əntsahə aaɓii guutə ca ətsa kaa ca tsaamətə ŋga'ə. Wata ma ca fa, uura ŋga Slandanə a waɓə də ci, ");
INSERT INTO gde_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","uu'i ci: ‘Nyi nə Əntaŋfə ətə ci dzədzəshi'inəku a paslə tə ci, waatoo Əntaŋfə ŋga Ibərahiima, da ŋga Isiyaaku, da ŋga Yakubu.’ Makə fii Muusa ha'ə, wata shishinəkii a udzə. Ca ŋgwaləgi dəŋwa'ə ka tsaamənə. ");
INSERT INTO gde_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Wata Əntaŋfə a ba ka ci: ‘Dəəɗəgi ɓiɓinaaku, acii ma hatsə kəŋaanə hə davə, malaaɓa ha. ");
INSERT INTO gde_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Neenə nee nyi ka ciɓənə ŋga ənjaaki də Misəra. Kə fii nyi ŋgi'inatii, kə jimagərə nyi kaa nya luupaa tə tii. Shiwa kaa nya sləkee ka hə aa Misəra.’ ");
INSERT INTO gde_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“Ma Muusa, kə kaaree ənji Isərayiila ka ci, təya ba ka ci: ‘Wu saŋə kavə tə hə ka gawə da mala gəŋwanə ahadeena?’ Amma tə ci sləkee Əntaŋfə kaa ca ndzaa ka gawə da maluwatii əsə dagi tsakənə ŋga malaa'ikatə jigagi ka ci dagi ba. ");
INSERT INTO gde_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Ci əsə fə'yagi tə tii də Misəra, ca ta ka tii kəŋwanə, ca ɗa uushi'inə ŋga hurəshishinə də Misəra, da a gəərə ətə ɗii ləməkii Madizə Gəəra. Kə ɗii ci ha'ə agi bilinə ŋga fəzə ənfwaɗə pu'unə əsə. ");
INSERT INTO gde_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Ci nə Muusatə bii ka ənji Isərayiila oo'i: ‘Ka taginə nə Əntaŋfə koonə anabi makə naaki agi ndzəkəŋushi'inuunə.’ ");
INSERT INTO gde_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Ci nə əndə agi ənjitə dzatə də nə agi bilinə, waatoo dzədzəshi'inaamə ənji Isərayiila. Kə ndzaa ci da malaa'ikatə waɓi ka ci agyanə giŋwə ŋga Siina. Ci əsə liwa waɓənə ŋga əpinə acii Əntaŋfə ka kiranə kaamə. ");
INSERT INTO gde_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“Amma kə naanagi dzədzəshi'inaamə ka fanə tə Muusa. Təya kaaree ka ci. Mooɗəfətii a ənə ka ənənə aa Misəra əsə. ");
INSERT INTO gde_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Əŋki tii ka *Haruna: ‘Ɗawə kaamə uuləmə kaa ca ta kaamə kəŋwanə. Acii ma Muusanə ŋgiragi taamə də Misəra, mashiimaamə sətə ɗii tə ci.’ ");
INSERT INTO gde_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Təya ɗatə uuləmə ka saa'ita, ətə ca pusha tə uundzə la. Təya paslə tə ci də laala uura ŋga uushi'inə, təya ɗa mooɗasəkə ŋga sətə ɗatə tii də ciinətii. ");
INSERT INTO gde_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Amma kə zhi'igi Əntaŋfə ka tii də ba'a, ca bwasee ka tii kaa təya paslə tikisanyinə. Wiinə sətə naahətə anabiinə agyanətii: ‘Unə ənji Isərayiila, ka nyi laalii unə uura ŋga uushi'inə, una dzakəgi ka nyi sataka agi fəzə ənfwaɗə pu'unə agi bilinə kwa? Poosha. ");
INSERT INTO gde_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Kə ŋgiruunə kuvə sləmə goonə *Malookə da uuləmə goonə ətə pusha tikisa, waatoo Ramfa. Ma təya, uuləmənyiitə ɗaaɗii unə koona paslə tə tii. Acii ha'ə, ka paləgərənə nə nyi duunə aa taŋəgi Babila.’ ” ");
INSERT INTO gde_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Sətəfanu a tsakə banə, əŋki ci, “Ma dzədzəshi'inaamə, kə kəsəpaa tii *kuvə kuvə'unə saa'itə tii agi bilinə. Ci ca ɓaarii oo'i, kədəhə nə Əntaŋfə da tii. Kə ɗatə tii kuvə kuvə'unəkii əsə makə sətə bii Əntaŋfə ka Muusa, makə sətə nee ci əsə. ");
INSERT INTO gde_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Ha'ə makə liwə dzədzəshi'inaamə kuvəkii, kə ŋgəəriinə tii ha'ə ka saa'i ŋga Jasəwa. Makə lakəənə Əntaŋfə slanjii hanyinə akəŋwaciitii, hanyinəkii a ndzaa ka natii, kə kəsəpaa tii kuvə kuvə'uuta, ha'ə mbu'ya ka zamana ŋga Dawuda əsə. ");
INSERT INTO gde_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Ma Dawuda, kə upaa ci pwapoonə ŋga Əntaŋfə, ca kədii barəkaanə kaa ca ghənə maɗuunə kuvə ka Əntaŋfə ətə pasli Yakubu tə ci. ");
INSERT INTO gde_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amma Sulayimaanu ghənyi kuvəkii. ");
INSERT INTO gde_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Patə da ha'ə, ma maɗuunə Əntaŋfə, paa ci ka ndzaanə asəkə kuvənyiitə ghənyi ənji ka ci. Makə sətə bii anabi Isaaya oo'i: ");
INSERT INTO gde_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Ma bii Əntaŋfə, ma ha dagyə, ci nə dəgələ ŋwaŋuunaaki; ma hanyinə, ci nə ha ŋga ɗəkə səɗəki. Kuvə mi ghənənuunə ka nya? Ŋgutə ha nə ha ŋga əpisəkaakya? ");
INSERT INTO gde_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Əntaa də ciinəki ɗaaɗii nyi uushi'iitsə patə kwa?’ ” ");
INSERT INTO gde_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Sətəfanu a dzə aakəŋwa də banə ka tii, əŋki ci, “Ma una, mandaləkii nə mooɗəfuunə, pooshi unə ka fa waɓənə taa gi'u. Kə kaaree unə ka fa tə Malaaɓa Ma'yanə taa guci patə. Kə ŋgiruunə dərəpə ŋga dzədzəshi'inuunə. ");
INSERT INTO gde_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Tə'i taa rəŋwə agi anabiinə ətə pooshi dzədzəshi'inuunə ciɓee kwa? Kə ɓələgi tii ənjitə sləkee Əntaŋfə ka tii ka baaba shinə ŋga Əndə Gooŋga. Ma Əndə Gooŋgatsa, kə kaaree unə ka ci əsə, una ɓələgi tə ci. ");
INSERT INTO gde_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Unə liwə *bariya dacii malaa'ika. Amma, manə'utəmuunə bariyaakii əsə.” ");
INSERT INTO gde_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Makə fii *mətərəkinə ŋga Yahudiinə tə waɓəətə ɗaaɗii Sətəfanu ka tii, kə ɓəzəgi səkətii ka shaŋə. Əbwyanə tə tii asəkətii nə maɓətəsəkəkii. ");
INSERT INTO gde_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Amma, ma Sətəfanu, manakii nə ci də Malaaɓa Ma'yanə. Ca tsaamə aadəgyə. Wata ca nee ka məghərəvənə ŋga Əntaŋfə, ca nee ka Yeesu kəŋə da ciizəma Əntaŋfə əsə. ");
INSERT INTO gde_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Ca ba, “Kə nee nyi ka səkəntaŋfə mawunəkii, nya nee ka Uuzənə ŋga əndə kəŋə da ciizəma Əntaŋfə.” ");
INSERT INTO gde_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Makə uugi mbeenə ka tii nə sə'wa maɓətəsəkəkii, wata təya kaala vurənə, təya njiikəgi liminətii, təya dzaanə ka ci də nə patə, ");
INSERT INTO gde_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","təya ələgi tə ci aa ba'a vəranə kaa təya kaala tə ci də faariinə. Seedawanyiinə əsə, təya səəɗəgi kəjeerənatii, təya pukəpaa aɓii əndə'i uundzə dagwa ətə ɗii ləməkii Sawulə. ");
INSERT INTO gde_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ma təya kaala tə Sətəfanu də faariinə, ca dzə də ɗa də'wa, “'Ya'ə Slandanəki Yeesu, luuwə ma'yanaaki.” ");
INSERT INTO gde_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Wata ca gərə'waanə, ca ŋgəree ka uurakii ka waɓənə, əŋki ci: “'Ya'ə Slandana, tifyagi ka tii 'waslyakəətsatii.” Makə uugi ci baginə ha'ə, wata ca əntəgi. ");
INSERT INTO gde_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","Ma Sawulə, kə luuvə ci ɓələnə tə Sətəfanu. Ma uusərakii, kə lii ŋgəra'wə tə ənji nə'unə tə Yeesu də Urusaliima ka shaŋə. Təya yiigəɗəgi patə aanə hanyinə ŋga Yahudiya i *Samariya. See masləkee ənji tanə mbəɗaanə davə. ");
INSERT INTO gde_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","Kə ŋgirə hara ənji nə'unə tə wə ŋga Sətəfanu, təya ŋgəɗəgi, təya tuu waakii ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Ma Sawulə, kə ciɓə ci də ənji nə'unə tə Yeesu ka shaŋə. Ha'ə kə giimə ci ka yi ka yi ka kəəsənə tə tii, ŋguyirənə da makinə patə, ca əjigərə tə tii aa furəshina. ");
INSERT INTO gde_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Ma ənji nə'uutə yiigəɗəgi, kə kirə tii waɓənə ŋga Əntaŋfə taa aama patə gi tii. ");
INSERT INTO gde_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Filibusə əsə, kə pyalə ci aasəkə maɗuunə vəranə ŋga Samariya, ca ba ka ənjitə davə waɓənə agyanə Yeesu *Mataɗəkii ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Makə fii daɓaala tə sətə ci Filibusə a ba ka tii, təya nee ka sə ŋga hurəshishiitə cii kəya ɗaaɗa əsə, təya kavə hiimatii ka sətə cii kəya ba ka tii patə də ədzəmə rəŋwə. ");
INSERT INTO gde_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Acii kə gimagi ginaajinyinə ashi ənji ɓəzəkii də kaala vurənə. Kə mbə'i mahurəməsə ənji da mədərənyinə laŋə əsə. ");
INSERT INTO gde_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Kə ɗii ənji maŋushinə ka shaŋə də Samariya. ");
INSERT INTO gde_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ma asəkə vəraatsə əsə, tə'i əndə'i əndə ətə ɗii ləməkii Simoonə. Kə ɗii ci uushi'inə ŋga hiila laŋə. Ha'ə kə dzəgəpaa tə ənji Samariya patə ka shaŋə. Ha'ə kə zhi'wee ci ka naakii nə ka maɗuunə uushi. ");
INSERT INTO gde_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Aciikii patənə ŋga ənja, gayinə da talakiinə, kə luuvə tii sətə ɗaaɗii ci, təya ba, “Wiitsə baawəɗa ŋga Əntaŋfə ka shaŋə ətə ci ənjə a ba.” ");
INSERT INTO gde_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Təya nə'u tə ci, acii kə ta'avə ci ka ɗa ka tii sə ŋga hiila. ");
INSERT INTO gde_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amma, makə fii tii waazanə ŋga Filibusə agyanə ŋwaŋuunə ŋga Əntaŋfə da ŋunyi waɓənə ŋga Yeesu, ŋguyirənə da makinə patə, kə luuvə tii, təya luu yiɓə bapətisəma. ");
INSERT INTO gde_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ha'ə nə Simoonə əsə, kə luuvə ci, ca luu yiɓə bapətisəma, ca nə'u tə Filibusə. Makə nee ci ka madiigərə sə ŋga hurəshishiitə ci Filibusə a ɗa, kə dzəgəpaa tə ci ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Makə fii masləkee ənji də Urusaliima oo'i, kə liwə ənji Samariya waɓənə ŋga Əntaŋfə, təya sləkee ka i Piita da Yoohana aahadatii. ");
INSERT INTO gde_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","Makə mbu'i tii aa dəvə, kə ɗii tii ka ənji də'wa kaa təya upaa Malaaɓa Ma'yanə. ");
INSERT INTO gde_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Acii kə liwə tii yiɓə bapətisəma agi ləmə ŋga Yeesu Slandana, amma ma'ə tii ma'upaamə Malaaɓa Ma'yanə. ");
INSERT INTO gde_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Ma i Piita da Yoohana a ɗa ka tii də'wa, təya kavə ciinətii aanətii, wata təya upaa Malaaɓa Ma'yanə. ");
INSERT INTO gde_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Makə nee Simoonə kə upaa ənji Malaaɓa Ma'yanə acii putə ŋga kavə ciinə ŋga masləkee ənji aanətii, wata ca ɗa rəgwa ŋga vii kwaɓa ka masləkee ənja. ");
INSERT INTO gde_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","Əŋki ci ka tii, “Ndiimə ka nyi baawəɗatsa, kaa nya shii kavə ciinəki aanə ənda, ca upaa Malaaɓa Ma'yanə əsə.” ");
INSERT INTO gde_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Amma Piita a ba ka ci, “Wa Əntaŋfə a zamagi də hə da kwaɓaaku. Ma nə hə ka nəhəna, ka upaanə nə hə viinə ŋga Əntaŋfə də kwaɓa kwa? ");
INSERT INTO gde_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Əntaa slənaaku ətsa, acii pooshi ədzəməku camə akəŋwacii Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Acii ha'ə, baawə ka Əntaŋfə putə ŋga bwaya uushi'iitə hiimii hə, ha kədii aciikii; mbu'u ka tifyaginə nə ci ka hə sətə hiimii hə asəkə mooɗəfəku. ");
INSERT INTO gde_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Acii kə nee nyi, məŋgərəkikinə nə hə. Kə ŋgərəma 'waslyakəənə tə hə.” ");
INSERT INTO gde_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Wata əŋki Simoonə ka i Piita da Yoohana, “Kədiimə ka nyi acii Slandanə acii ga taa rəŋwə agi uushi'iitsə bii unə a ɗii tə nyi.” ");
INSERT INTO gde_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Makə uugi i Piita da Yoohana seedanatii da waaza waɓənə ŋga Slandana, təya ənə aa Urusaliima də waaza ŋunyi habara ŋga Yeesu asəkə giwanyinə da vəranyinə ŋga Samariya laŋə. ");
INSERT INTO gde_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Ma daba'əkii, wata malaa'ika ŋga Slandanə a ba ka Filibusə: “Maɗətə, duu aadə hwarəma, ka rəgwatə ca ma'ya də Urusaliima ka dzənə aa Gaza, waatoo rəgwa bilinə.” ");
INSERT INTO gde_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","28","Filibusə a maɗə, ca palə. Ma ca dzə də dzənə, wata ca guŋəgərə da əndə'i əndə Iitoopiya ca ənə saakii asəkə moota təhwaakii, ci kə uudəpaa paslənaakii tə Əntaŋfə də Urusaliima. Ca dzə də jaŋga ləkaləkatə ŋga anabi Isaaya. Ma əndətsa, gawə nə ci agi ŋwaŋuunə ŋga Kandaka, waatoo ki nə ŋwaŋwə ŋga Iitoopiya ka ətə saa'i. Əndətə əsə nə əndə kəsə kwaɓatə. ");
INSERT INTO gde_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Wata Malaaɓa Ma'yanə a ba ka Filibusə, “Əntsahuu aatsa moota təhutsa.” ");
INSERT INTO gde_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Wata ca huyipaa aaɓiikii. Ma ca fa, waanə ka jaŋga ləkaləkatə ŋga anabi Isaaya. Filibusə a ləgwa ka ci, əŋki ci, “Agi paaratəginə nə hə də sətsə cii kwa jaŋga nii?” ");
INSERT INTO gde_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Əndətə a ba ka Filibusə, “Iitə mbeenəki ka paaratəgina? See maa upaa nyi əndə tsakənə tə nyi.” Wata ca 'wa tə Filibusə kaa ca ndərə aaɓiikii kaa təya ndzaa ka hakii. ");
INSERT INTO gde_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Wiinə sətə nji əndə Iitoopiyatə a jaŋga asəkə malaaɓa ləkaləkatəkii: “Ma ca, taa makii mawunəmə ci. Kə ndzaa ci makə baga ənjə a kərə ka la uurakii, makə sətə ci uundzə baga a ndzaa kəɗa'ə taa ənjə a laala shiŋkinaakii. ");
INSERT INTO gde_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Kə ɗavə ənji ka ci ayinə, ha'ə kə ənslə'watəgi ənji ka ci də gooŋgaanaakii. Pooshi ənji ka mbee ka ba habara ŋga slikərənaakii, acii kə lagi ənji əpinaakii daga saa'i ŋga əntənaakii ma'ə mambu'umə.” ");
INSERT INTO gde_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Wata əndə Iitoopiyatə a ba ka Filibusə, “Ya əna, agyanə wu saŋə nə *anabi ka waɓəna? Agyanəkii saakii nii, anii anə əndə'i ənda?” ");
INSERT INTO gde_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Wata Filibusə a waaza ka ci Ŋunyi Habara ŋga Yeesu, 'watəginə ka sətə jaŋgii əndətə asəkə ləkaləkatə ŋga anabi Isaaya. ");
INSERT INTO gde_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","Ma təya dzə də dzənə a rəgwa, təya lapaa gəəra. Wata əŋki əndə Iitoopiyatə ka Filibusə, “Wiitsə ma'inə. Tə'i uushi ca təŋapaa tə nyi ka ɗa ka nyi bapətisəma nii?”  ");
INSERT INTO gde_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Filibusə a ba ka ci, “Maɗa kə vii hə gooŋga ka Yeesu *Aləmasiihu də ədzəmə rəŋwə, ka ɗanə nə ənji ka hə.” Əŋki ci, “Kə vii nyi gooŋga oo'i, *Uuzənə ŋga Əntaŋfə nə Yeesu Aləmasiihu.” ");
INSERT INTO gde_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Wata ca ba ka ənjə a kəŋee ka moota təhwaakii. Təya jimagərə, təya dzəgərə aagi ma'inə. Filibusə a yiɓə ka ci bapətisəma. ");
INSERT INTO gde_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Makə gimagi tii agi ma'inə, wata Ma'yanə ŋga Slandanə a vagi tə Filibusə. Pooshi əndə Iitoopiyatə ənyi ka neenə ka ci ma'ə. Amma ca nə'u rəgwaakii də mooɗasəkə laŋə. ");
INSERT INTO gde_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Ma Filibusə əsə, də Azata ənyi ənji ka neenə ka ci. Ca dzə aa Kayisariya. Ma a rəgwa, kə gi ci də waaza Ŋunyi Habara ŋga Yeesu ka vəra ka vəra. ");
INSERT INTO gde_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Ma Sawulə, kə gi ci aakəŋwa də ciɓənə də ənji nə'unə tə Slandana, ha'ə ca ba ka ɓəələginə nə ci tə tii. Kə ma'i ci, ca palə aa ha gawə ŋga limanyinə, ");
INSERT INTO gde_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ca kədii kaa ca naahətə ka ci ləkaləkatə kaa ca kərə ka gayinə ŋga *kuvə də'wanyinə ŋga Damasəkusə, oo'i, maɗa kə lapaa ci ənji nə'u rəgwa ŋga Slandana, ka kaashatənə nə ci tə tii patə, ŋguyirənə da makinə, ca kira aa Urusaliima ma'aanəkii. ");
INSERT INTO gde_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Makə upaa ci ləkaləkatəkii, ca palə. Ma ci ma'ə a rəgwa, kədəhə kaa ca mbu'u aa Damasəkusə, wata ma nee ci, ɓərənə makə pyapiɗənə ŋga vənə a jigagi ka ci dadagyə, ca ɓərəgi hatə ɗii ci davə patə. ");
INSERT INTO gde_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Wata kucafə ca kulagi aa panə. Ma ca fa, uura ŋga əndə a ba ka ci: “Sawulə, Sawulə, mi saŋə cii kwa ciɓə də nyi ha'a?” ");
INSERT INTO gde_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Ca ləgwa, “'Ya'ə Slandana, hə wu saŋa?” Əŋki ci ka ci, “Nyi nə Yeesu ətə cii kwa ciɓə də ci. ");
INSERT INTO gde_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Amma, ma ɗanəkwa, maɗətə, dzəgərə aasəkə vəranə. Davə nə ənjə a ba ka hə sətə nii kwa ɗa.” ");
INSERT INTO gde_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Ma guvii-wiinyinə ŋga Sawulə, kə kəŋee ka tii, ca pa'əənə ka tii ma əsə, acii kə fii tii uura ŋga ənda, amma maneemə tii ka əndəkii. ");
INSERT INTO gde_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Sawulə a maɗətə, ca kəŋaanə, ca wunəpaa ginəkii, amma paa ci ka mbee ka nee ka taa mi. Ənjitə a kəsə tə ci ka ciinəkii, təya kərə tə ci aa Damasəkusə. ");
INSERT INTO gde_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Baanə makkə, paa ci ka mbee ka neenə. Pooshi zəmə a makii, masamə ci taa mi əsə. ");
INSERT INTO gde_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Tə'i əndə nə'unə də Damasəkusə ətə ɗii ləməkii Ananiya. Kə jigagi Slandanə ka ci, əŋki ci, “Ananiya!” Ca muu, “'Ya'ə Slandana, wanyina.” ");
INSERT INTO gde_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","Əŋki Slandanə ka ci, “Maɗətə, duu ka rəgwatə ci ənjə a 'wa ‘Makəŋə rəgwa’, ha ləgwatə asii ga Yahuda tə əndə vəranə ŋga Tarəsi ətə ɗii ləməkii Sawulə. Acii agi ɗa də'wa nə ci. ");
INSERT INTO gde_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","Kə ɓaarii nyi ka ci əndə'i əndə ɗii ləməkii Ananiya ca dəməgərə aaɓiikii, ca banee ka ciinəkii aanəkii kaa ca ənə ka nee ka ha makə ŋga ŋukə.” ");
INSERT INTO gde_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Amma Ananiya a ba, “'Ya'ə Slandana, kə fii nyi a ma ənji laŋə oo'i, ma əndətsa, kə ciɓee ci ka ənji nə'unə tə hə ka shaŋə də Urusaliima. ");
INSERT INTO gde_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Wiinə, ma shi ci aa hanə əsə, də baawəɗa ŋga gayinə ŋga limanyinə kaa ca anə taa tə wu patə ca ɗa də'wa də ləməku ganə.” ");
INSERT INTO gde_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amma əŋki Slandanə ka Ananiya, “Duu, acii mataɗə əndə slənaaki nə ci kaa ca baaba ləməki ka hara slikərənə da meeminə da ənji *Isərayiila patə. ");
INSERT INTO gde_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Nyi na ɓaarii ka ci əsə makə sətə nii kəya ciɓə putə ŋga ləməki.” ");
INSERT INTO gde_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Wata Ananiya a palə, ca dəməgərə aa hatə aasii, ca banee ka ciinəkii aanə Sawulə, ca ba, “Ndzəkəŋunəki Sawulə, Slandanə sləkee ka nyi, waatoo Yeesu ətə jigagi ka hə a rəgwa ha shi aa hanə. Ma sləkee ci ka nyi, kaa ha mbee ka neenə də ginəku makə ŋga ŋukə, ha upaa natənə ŋga Malaaɓa Ma'yanə tə hə əsə.” ");
INSERT INTO gde_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Wata kurya'ə uushi makə maslyafənə ŋga mbuzə a kulyagərə anə ginəkii, ca ənə ka neenə makə ŋga ŋukə, ca maɗətə, ca luu yiɓə bapətisəma. ");
INSERT INTO gde_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Ma daba'əkii, ca adə zəma, ca ənə ka upaa ŋgeerənə. Kə ta'avə Sawulə gi'u də Damasəkusə tii da ənji nə'unə. ");
INSERT INTO gde_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Pii kə pyalə ci aasəkə *kuvə də'wanyinə kama kama, ca waaza ka ənji agyanə Yeesu, ca ba, ma Yeesu, *Uuzənə ŋga Əntaŋfə nə ci. ");
INSERT INTO gde_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Ma ənjitə nja fa tə ci, kə ɗii ka tii ka sə ŋga hurəshishinə, təya ba, “Əntaa əndətsə ciɓə də ənji ɗa də'wa də ləmətsə də Urusaliima? Ma shi ci aa hanə əsə, kaa ca kəəsə tə tii, ca kərə aakəŋwacii gayinə ŋga limanyinə ma'aanəkii.” ");
INSERT INTO gde_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Amma, ma waazanə ŋga Sawulə, kə cakə ɗa ŋgeerənə aakəŋwa aakəŋwa, ca ɓaarii ka *Yahudiinə də Damasəkusə oo'i, ma Yeesu, *Mataɗəkii ŋga Əntaŋfə nə ci. Makə fii tii ha'ə, wata hiimatii a gwazəgi patə. ");
INSERT INTO gde_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Ma daba'ə baanə ɓəzəkii, kə anyi Yahudiinə uura ka ɓələginə tə Sawulə. ");
INSERT INTO gde_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","Amma kə fii Sawulə sətə mwayi tii ɗanə də ci. Vəɗə da uusərə patə nə tii ka nəhə uura mayi ŋga vəranə kaa təya ɓələgi tə ci. ");
INSERT INTO gde_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","Asee, ma ka əndə'i vəɗa, kə ŋgirə *lyawarənə ŋga Sawulə tə ci, təya kavə tə ci aasəkə ɗəva, təya kyagərə tə ci da nə mahwala ŋga vəranə. ");
INSERT INTO gde_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Makə ənyi Sawulə aa Urusaliima, kə ali ci ləɓənə da ənji nə'unə davə. Amma kə ŋgwaləgi tii patə aciikii, acii maluuvəmə tii oo'i, əndə nə'unə nə ci. ");
INSERT INTO gde_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Amma, wata Barənaba a kəsətə tə ci ka ciinə, ca kərə tə ci aaɓii masləkee ənji, ca bagi ka tii makə sətə nee Sawulə ka Slandanə a rəgwa ətə waɓi ka ci, makə sətə waazii ci də ləmə ŋga Yeesu də Damasəkusə yadə ŋgwalənə əsə. ");
INSERT INTO gde_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Wata təya ndzaashi, təya wiigi'i ka hakii da Sawulə də Urusaliima. Ca waaza də ləmə ŋga Slandanə yadə ŋgwalənə. ");
INSERT INTO gde_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Ca dzə də waɓənə də ɗaaɗa mabizhinə da Yahudiinə ətə ca waɓə uura Gərikə əsə. Amma, ma tii natii, rəgwa ŋga ɓələginə tə ci nə tii ka alənə. ");
INSERT INTO gde_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Makə fii ənji nə'unə ha'ə, təya kərəgi tə ci aa Kayisariya, əŋki tii ka ci, wa ca ənə saakii aa Tarəsi. ");
INSERT INTO gde_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Ma Ikəliisiyanyinə anə hanyinə ŋga Yahudiya da Galili i Samariya əsə, kə upaa tii ndzaanə jamə, pooshi ŋgəra'wə ma'ə. Kə cakə tii ɗa ŋgeerənə aakəŋwə aakəŋwa, təya dzə də ŋgwalənə tə Slandanə əsə agi taa mi ci təya ɗa patə. Də ha'ə cakə ənji nə'unə ɗanə laŋə dagi tsakənə ŋga Malaaɓa Ma'yanə tə tii. ");
INSERT INTO gde_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Ma Piita, agi wiigi'inə nə ci ahada ənji nə'unə taa dama patə. Kə gi ci ka tsaamətənə tə ənji nə'unə də Lida əsə. ");
INSERT INTO gde_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Ma davə, kə lapaa ci əndə'i mahurəməsə əndə ətə ɗii ləməkii Ayiniya. Paa ci ka mbee ka maɗətənə. Fəzə tighəsə nə ci pərəɓə asəkə ədzə baanə. ");
INSERT INTO gde_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Əŋki Piita ka ci, “Ayiniya, kə mbəɗəpaa Yeesu *Aləmasiihu də hə. Maɗətə, ha fuuɗətə ha ŋga baanaaku.” Wata həryatə ca maɗətə. ");
INSERT INTO gde_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Ənji Lida da ənjitə anə hanyinə ŋga Saroonə patə, kə nee tii ka Ayiniya, ca wii. Wata təya zhi'wagi ka nə'unə tə Slandana. ");
INSERT INTO gde_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Tə'i əndə'i vəranə ətə ɗii ləməkii Yoopa. Ma dava, tə'i əndə'i minə ɗii ləmətə Tabita. Ma də uura Gərikə əsə, Dookasə, makə bana kanyaɗa. Əndə nə'unə nə ki. Pukyanə ŋga ha patə nə ki ka slənə ŋunyi sləna, kya tsakə tə matəgunyinə əsə. ");
INSERT INTO gde_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Ma saa'ikii, kə gwakə ki ka bwanea, kya əntəgi. Ənjə a yiɓəgi tə ki, təya banee ka ki asəkə kuvə anə əndə'i. ");
INSERT INTO gde_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Makə ma Lida, pooshi dzaɗə da Yoopa, kə fii ənji nə'uutə davə oo'i, də Lida nə Piita. Wata təya sləkee ka ənji bəra'i aaɓiikii, təya kədii tə ci, əŋki tii, “Tsəgwayi pii pii, shiwə aahadeenə.” ");
INSERT INTO gde_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Makə fii Piita ha'ə, wata ca maɗə, ca palə da tii. Mbu'unaakii, ənjə a kərə tə ci aasəkə kuvə anə əndə'i. Mooryafinyinə a guŋutə də ci patə, təya dzə də tuunə, təya ɓaarii ka ci kəbənə i kəjeeriitə nji Dookasə a təslə, ki ma'ə da i əpinə. ");
INSERT INTO gde_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Wata Piita a ba ka tii, wa təya dəməgi patə agyə. Ca gərə'waanə, ca ɗa də'wa, wata ca zhi'igi aaɓii wa, ca ba, “Tabita, maɗətə.” Kya wunəpaa ginətə. Makə nee ki ka Piita, kya maɗətə dasə. ");
INSERT INTO gde_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Piita a və ka ki ciinəkii, kya kəsətə, ca maɗee ka ki. Ma daba'əkii, ca 'wa tə mooryafinyinə da hara ənji nə'unə, ca ɓaarii tə ki ka tii da i əpinə. ");
INSERT INTO gde_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Kə huwugi habara ŋga sətə ɗii Piita asəkə vəranə ŋga Yoopa patə. Ənji laŋə vii gooŋga ka Slandanə əsə. ");
INSERT INTO gde_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Kə baa Piita də Yoopa laŋə asii ga matakəɗə kuvə'unə ətə ɗii ləməkii Simoonə. ");
INSERT INTO gde_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Tə'i əndə'i əndə də Kayisariya ətə ɗii ləməkii Koorəniliya. Matakəŋwanə nə ci agi kurəgə ŋga soojiinə ətə ci ənjə a 'wa Italiyanyinə. ");
INSERT INTO gde_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Ma ci da yaakii patə, ənji ŋgwalənə tə Əntaŋfə nə tii. Agi gərə'unə nə tii ka Əntaŋfə. Ca vii sataka laŋə ka ənji əsə, ca ɗa də'wa taa guci patə. ");
INSERT INTO gde_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Ma ka əndə'i uusəra, ətsə bahə tibisə makkə ŋga kədəwanə, kə shitə malaa'ika ŋga Əntaŋfə aaɓiikii makə səniinə, Koorəniliya a nee ka ci ginə da ginə. Ca ba ka ci, “Koorəniliya!” ");
INSERT INTO gde_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","Wata Koorəniliya a fə'yagi ginəkii ka tsaamənə tə ci də ŋgwalənə, ca muu, “'Ya'ə Slandana, mi kwa?” Əŋki malaa'ika ka ci, “Kə fii Əntaŋfə kədiinaaku. Kə ɗii satakaaku ŋga'ə ka ci əsə, mazaanəmə hə ka ci. ");
INSERT INTO gde_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Ma ɗanəku, sləkee ka ənji aa Yoopa, təya alyatə ka hə tə əndə'i əndə ɗii ləməkii Simoonə ətə ci ənjə a 'wa tə ci Piita. ");
INSERT INTO gde_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Mu'umə nə ci asii ga matakəɗə kuvə'unə ətə ɗii ləməkii Simoonə əsə. Ama uunəvə nə yaakii.” ");
INSERT INTO gde_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Makə pyalə malaa'ikatə saakii, wata Koorəniliya a 'watə lyawarənaakii bəra'i da rəŋwə agi soojiinə ŋga səkə ciinəkii ətə ca gərə'u ka Əntaŋfə əsə. ");
INSERT INTO gde_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Ca ba ka tii sətə bii malaa'ika ka ci patə. Wata ca sləkee ka tii aa Yoopa. ");
INSERT INTO gde_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Ma ka doorəkii, tii kədəhə ka mbu'unə aa Yoopa, kə ndərəgi Piita aagyanə malərəɓə kuvə ka ɗa də'wa ətsə uusərə ahadana. ");
INSERT INTO gde_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Ma ka saa'ikii, kə zhimə maɗəfənə tə ci, kə mwayi ci sə ŋga adənə. Ma ənji ma'ə ka ɗa ka ci zəma, kə ɓaarii Əntaŋfə ka ci sə ŋga hurəshishinə. ");
INSERT INTO gde_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","Ca nee ka səkəntaŋfə mawunəkii. Uushi makə maɗuunə gwada a jima aa panə da taŋgalakii ənfwaɗə masəkii. ");
INSERT INTO gde_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Ma asəkəkii, tə'i taa ŋgutə tsarə ŋga daba da səɗə ənfwaɗə, i ətə ca wii anə mbuurəsəkətii da i ətə ca ləɗə a səkəntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Ma ca fa, uura ŋga əndə a waɓə ka ci, əŋki ci, “Piita, maɗətə, əsuu, ha lagi uurakii, ha tsəɓə.” ");
INSERT INTO gde_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Əŋki Piita, “Aa'a, 'ya'ə Slandana, mashimə nya agi sətə təŋapaa *bariya ka adənə taa ma'ajijinə uushi.” ");
INSERT INTO gde_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Wata ma ca fa, əndəkii a ənə ka waɓənə ka ci ŋga bəra'inə, əŋki ci, “Ma sətə ɗatəgi Əntaŋfə camə, ga ha tsaamə tə ci ajijinə.” ");
INSERT INTO gde_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Makə jikətə ka ci səɗə makkə, ma daba'əkii, pii sətə a ndərəgi aa dəgyə shakətə. ");
INSERT INTO gde_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Ma Piita agi hiima sətə mwayi Əntaŋfə banə ka ci də uushi'iitə nee ci, wata watiitsə ənjitə sləkee Koorəniliya ka tii kəŋə kəŋə a mayi, tii kə uugi ləgwa yi ŋga Simoonə. ");
INSERT INTO gde_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Təya 'wa ənji, təya ləgwa mbu'u davə asii nə Simoonə ətə ci ənjə a 'wa Piita. ");
INSERT INTO gde_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Ma Piita ma'ə agi hiima sətə mwayi Əntaŋfə banə ka ci də uushi'iitsə ɓaarii ci ka ci, wata Malaaɓa Ma'yanə a ba ka ci, “Fatə, wiitsə ənji makkə ca alə tə hə. ");
INSERT INTO gde_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","Maɗətə, jiməgərə, ha dzə da tii. Ga ha buurə taa mi, acii nyi sləkee ka tii.” ");
INSERT INTO gde_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Wata Piita a maɗətə, ca jiməgərə, ca dzə ka waɓənə da tii, ca ba, “Nyi nə əndətə cuuna alə. Iitə nə shinə goona?” ");
INSERT INTO gde_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","Təya ba ka ci, “Koorəniliya matakəŋwanə ŋga soojiinə sləkee keenə. Ma ca, əndə gooŋga nə ci, agi gərə'unə nə ci ka Əntaŋfə taa guci patə. Da ayinaakii nə ci əsə anə hanyinə ŋga Yahudiinə patə. Kə bii malaa'ika ŋga Əntaŋfə ka ci, kaa ca 'wa tə hə aa hakii aasii kaa ca fa sətə cii kwa ba ka ci.” ");
INSERT INTO gde_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Wata Piita a 'wagərə tə tii, təya baanə davə. Pukənə ŋga ha ca maɗə, ca palə da ənjitə makkə. Kə kəree hara ənji nə'unə ŋga Yoopa ka ci əsə. ");
INSERT INTO gde_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Təya mbu'u aa Kayisariya ka bəra'inə ŋga uusəra. Ma Koorəniliya, a gəra tə tii, kə 'waa'watə ci tə ndzəkəŋushi'inəkii da guviinəkii. ");
INSERT INTO gde_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ma ətsə ka Piita a dəməgərə, wata waatsə Koorəniliya. Wata ca gərə'waanə atsaa səɗəkii, ca paslə tə ci. ");
INSERT INTO gde_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Amma Piita a kəsətə ciinəkii, ca maɗee ka ci, əŋki ci ka ci, “Maɗətə kəŋə. Acii nyi maa, əndə nə nyi makə hə.” ");
INSERT INTO gde_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Ma Piita a dzə də waɓənə tii da Koorəniliya, ca dəməgərə aa kumu, ca lapaa ənji laŋə ətə dzii də nə davə, ");
INSERT INTO gde_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ca ba ka tii, “Unə də noonə na, kə shii unə oo'i, kə təŋapaa diina ŋga Yahudiinə tə ndzaanə ka hakii taa dzənə aasii aa ha əndə'i slikərənə pamə. Amma, ma nyi, kə ɓaarii Əntaŋfə ka nyi oo'i, ga ənjə a nee ka ajijinəənə ŋga taa wu patə. ");
INSERT INTO gde_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Acii ha'ə, makə alya ənji tə nyi, kə shi nyi, maɗamə nyi mabizhinə əsə. Yoo, ma ənə ɗiya, ŋga'ə ka nyi nə fa sətə 'wii unə tə nyi ka ci.” ");
INSERT INTO gde_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Əŋki Koorəniliya ka ci, “Kə ɗii baanə ənfwaɗə əna, kənə ha'ə ətə acii aŋwə, saa'itə nya ɗa də'wa ŋga tibisə makkə ŋga kədəwanə gaki asii, kə shigi əndə ka nyi da kəjeerənə ashikii ətə ca pyapiɗə agi ənda. ");
INSERT INTO gde_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","Əŋki ci ka nyi: ‘'Ya'ə Koorəniliya, kə fii Əntaŋfə kədiinaaku, kə ɗii satakaaku ŋga'ə ka ci. Mazaanəmə hə ka ci əsə. ");
INSERT INTO gde_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Acii ha'ə sləkee ka ənji aa Yoopa, təya alyatə ka hə tə Simoonə ətə ci ənjə a 'wa tə ci Piita. Mu'umə nə ci asii ga Simoonə matakəɗə kuvə'unə ətə ɗii yaakii ama uunəva.’ ");
INSERT INTO gde_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Pii nya sləkee ka ənji ka hə. Hə əsə kə ɗii hə ŋga'əənə makə shi hə. Yoo, manə ɗiya, waniinə patə akəŋwacii Əntaŋfə keena fa sətə bii Slandanə ka hə patə, kaa ha ba keenə.” ");
INSERT INTO gde_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Wata Piita a jikəvə, əŋki ci, “Tantanyinə ənə ha'ə shii nyi oo'i, uushi rəŋwə nə ənji akəŋwacii Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Maɗa kə slənyi əndə ŋunyi sləna, ca ŋgwalə acii Əntaŋfə, ka uuɗənə nə Əntaŋfə tə əndəkii, taa ŋgutə slikərənə nə ci patə. ");
INSERT INTO gde_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kə shii unə waɓəətsə sləkee Əntaŋfə ka ənji Isərayiila, waatoo waaza Ŋunyi Habara ŋga jamənə dacii Yeesu Aləmasiihu. Ci nə Slandanə ŋga taa wu patə. ");
INSERT INTO gde_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Kə shii unə habara ŋga sətə ɗii anə hanyinə ŋga Yahudiya patə, 'watəginə daga də Galili daba'a bapətisəma ətə waazii Yoohana. ");
INSERT INTO gde_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","Waatoo, makə sətə vii Əntaŋfə ka Yeesu əndə Nazaratu Malaaɓa Ma'yanə da baawəɗa, makə sətə nji kəya wiigi'i, ca dzə də ɗaaɗa ŋunyi sləna, ca mbəɗəpaa də ənjitə ciɓee *Seetanə ka tii patə, acii kədəhə nə Əntaŋfə da ci. ");
INSERT INTO gde_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","“Ma inə əsə, seedawanyinə ŋga sətə ɗii ci patə də Urusaliima da anə hara hanyinə ŋga Yahudiya. Tə ci əsə ɓələgi ənji də gwa'avənə tə ci aashi ənfwa. ");
INSERT INTO gde_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","Amma Əntaŋfə a maɗee ka ci ka makkənə ŋga uusəra, ca kavə tə ci ka ɓaarii naakii nə da i əpinə. ");
INSERT INTO gde_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","Əntaa ka ənji patə ɓaarii ci naakii na, amma keenə ətə ta'i Əntaŋfə keena ndzaa ka seedawanyinaakii, acii kə zhimiinə ka hakii da i ci daba'a maɗənaakii agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Kə bii ci keenə, keena waaza ka ənji Ŋunyi Habara, ina vii seeda oo'i, ci nə əndətə kavə Əntaŋfə tə ci ka la gəŋwanə anə ənji əpinə da maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Tə ci seedii patənə ŋga anabiinə oo'i, patənə ŋga ənjitə vii ka ci gooŋga, ka upaanə nə tii tifyaginə ŋga 'waslyakəənatii dagi ləməkii.” ");
INSERT INTO gde_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Ma Piita ma'ə agi waɓənə, ənjə a fa, wata Malaaɓa Ma'yanə a shi aasəkə mooɗəfətii patə. ");
INSERT INTO gde_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","Ma ənji nə'unə ŋga Yahudiinə ətə shi tii da i Piita, kə ɗii ka tii ka sə ŋga hurəshishinə nə shinə ŋga Malaaɓa Ma'yanə aasəkə mooɗəfə ŋga ənjitə əntaa Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","Acii kə fii tii təya waɓə məshipətə uuranyinə, təya dəla də Əntaŋfə. Wata əŋki Piita, ");
INSERT INTO gde_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“Makə ɗii ci kə upaa ənjitsə Malaaɓa Ma'yanə makə ətə upaa inə neenə əsə, pooshi əndə ca təŋapaa ɗa ka tii bapətisəma.” ");
INSERT INTO gde_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Wata ca ba ka ənjə a yiɓə ka tii bapətisəma də ləmə ŋga Yeesu *Aləmasiihu. Ma daba'əkii, təya kədii tə ci kaa ca banee gi'u ahadatii. ");
INSERT INTO gde_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Kə fii masləkee ənji da hara ənji nə'unə ətə anə hanyinə ŋga Yahudiya oo'i, ənjitə əntaa Yahudiinə maa, kə liwə tii waɓənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Makə gi Piita aa Urusaliima, kə jalə ənji nə'unə ŋga Yahudiinə tə ci, ");
INSERT INTO gde_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","təya ba, “Ya makə əndə Yahuda nə ha, mi saŋə gi hə ka ɗanə aasii aa ha ənjitə *maryaminiyama? Ha'ə maa, kə fii inə, kə agi hə zəmə da təya?” ");
INSERT INTO gde_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Wata Piita a ndzaŋə ba ka tii sətə ɗii də rəŋwə rəŋwə, əŋki ci, ");
INSERT INTO gde_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Ma nyi asəkə vəranə ŋga Yoopa, nya ɗa də'wa, kə ɓaarii Əntaŋfə ka nyi sə ŋga hurəshishinə. Uushi makə maɗuunə gwada a jima dadagyə da taŋgalakii ənfwaɗə masəkii. Ha'ə ca mbu'ya aaɓiiki. ");
INSERT INTO gde_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Makə tsaamətə nyi ŋga'ə, kə nee nyi ka dabanyinə ətə ca wii anə səɗə ənfwaɗə, i luu bilinə da i ətə ca wii anə mbuurəsəkətii da i ətə ca ləɗə a səkəntaŋfə kama kama patə asəkəkii. ");
INSERT INTO gde_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Wata ma nya fa, əndə'i uura ŋga əndə a waɓə da nyi, ca ba: ‘Piita, maɗətə, əsuu, ha lagi uurakii, ha tsəɓə.’ ");
INSERT INTO gde_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Amma nya ba: ‘Aa'a, 'ya'ə Slandana, acii pooshi ma'ajijinə uushi sha dzəgərə aasəkə maki taa sətə təŋapaa *bariya ka adənə.’ ");
INSERT INTO gde_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ma nya fa, ca ənə ka waɓənə ka nyi ŋga bəra'inə dadagyə, əŋki ci: ‘Ma sətə ɗatəgi Əntaŋfə camə, ga ha nəhə tə ci ma'ajijinəkii.’ ");
INSERT INTO gde_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Ca jikətə ka nyi ŋga makkənə, wata sətə a ənə ka ndərəginə aa dəgyə shakətə. ");
INSERT INTO gde_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Ma'ə nyi mata'avəmə dəŋwa'ə, wata watiitsə ənji makkə kəŋə kəŋə a mayi ka hatə ɗii inə davə. Kə sləkee ənji ka tii aaɓiiki daga də Kayisariya. ");
INSERT INTO gde_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Wata Malaaɓa Ma'yanə a ba ka nyi, wa nya dzə da tii, ga nya buurə taa mi. Inə da ənji nə'uunə kuwa gi əsə. Ha'ə ina dəməgərə aasii aa ha əndəkii. ");
INSERT INTO gde_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Wata ca ba keenə makə sətə nee ci ka malaa'ika kəŋə asii gakii, malaa'ika a ba ka ci: ‘Sləkee ka ənji aa Yoopa, təya alyatə ka hə tə Simoonə ətə ci ənjə a 'wa Piita. ");
INSERT INTO gde_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","Kadə nii kəya ba ka hə waɓəətə nii kwa upaa luupaanə da yaaku patə.’ ");
INSERT INTO gde_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Mbu'unaaki, ma nya 'watəgi də waɓənə ha'ə, wata Malaaɓa Ma'yanə a shi aasəkə mooɗəfətii makə sətə shi aa mooɗəfaamə ŋga təkəŋwanə əsə. ");
INSERT INTO gde_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Wata nya buurətə waɓənə ŋga Slandanə ətə bii ci: ‘Kə yiɓə Yoohana ka ənji bapətisəma də ma'inə, amma, ma unə, ka upaanə nuunə bapətisəma də Malaaɓa Ma'yanə.’ ");
INSERT INTO gde_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Makə kə vii Əntaŋfə ka tii makə sətə vii ci kaamə saa'itə vii amə gooŋga ka Slandanə Yeesu Aləmasiihu, nyi wu saŋə təŋapaanəki aniya ŋga Əntaŋfwa?” ");
INSERT INTO gde_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Makə fii tii ha'ə, kə ətee tii ka sə ŋga banə, təya dəla də Əntaŋfə, təya ba, “Asee, patə da i ka ənjitə əntaa Yahudiinə vii Əntaŋfə rəgwa ŋga baanə ka ci kaa təya upaa əpinə.” ");
INSERT INTO gde_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Ma ənjitə yiigəɗəgi putə ŋga ciɓəətə ciɓə tii daba'a ɓələginə tə Sətəfanu, kə pyalə tii kura'ə aanə hanyinə ŋga Finikiya da i Kipərusə i aasəkə vəranə ŋga Antakiya. Mawaazamə tii taa ka wu maɗaamə ka *Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Amma, tə'i hara ənji Kipərusə da ŋga Sirina, mbu'unatii aa Antakiya, təya waɓə ka hara slikərənə əsə, təya waaza Ŋunyi Habara ŋga Slandanə Yeesu. ");
INSERT INTO gde_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Kə ndzaa Slandanə kədəhə da tii. Ha'ə kə vii ənji laŋə gooŋga ka ci, təya nə'u tə ci. ");
INSERT INTO gde_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Makə mbu'i habarakii aa limə ənji nə'unə ŋga Urusaliima, təya sləkee ka Barənaba aa Antakiya. ");
INSERT INTO gde_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Makə mbu'i ci aa dəvə, kə ɗii ci maŋushinə acii kə nee ci ka ŋga'aanə ŋga Əntaŋfə ətə ɗii ci ka tii. Wata əŋki ci ka tii, “See a ndzaa unə ka ənji gooŋga də ədzəmə rəŋwə akəŋwacii Slandana.” ");
INSERT INTO gde_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Acii ma ca, maŋga'ə əndə nə ci, da Malaaɓa Ma'yanə da vii gooŋga nə ci əsə. Ənji ɓəzəkii ka shaŋə vii gooŋga ka Slandana. ");
INSERT INTO gde_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Wata Barənaba a palə aa Tarəsi ka alyanə tə Sawulə. ");
INSERT INTO gde_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","Makə lapaa ci tə ci, ca kira tə ci aa Antakiya. Təya fəzəgi davə ka dzaadza də nə da ənji nə'unə. Təya dzəgunə ka ənji ɓəzəkii. Də Antakiya əsə 'watəgi ənji 'wanə tə ənji nə'unə ‘Ənji nə'unə tə Aləmasiihu’. ");
INSERT INTO gde_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Agi ətə saa'i ma'i hara anabinyinə də Urusaliima ka shinə aa Antakiya. ");
INSERT INTO gde_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Mbu'unatii aadəvə, wata rəŋwə agitii ətə ɗii ləməkii Agabusə a maɗətə, ca ba də baawəɗa ŋga Malaaɓa Ma'yanə, əŋki ci, kadə nə məza maɗəfənə a kulyaanə ka duuniya patə. Ha'ə makə ətsə əsə kə kulii maɗəfənəkii agi zamana ŋga ŋwaŋuunə ŋga Kalawudiyu. ");
INSERT INTO gde_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Wata ənji nə'unə a anə uura ŋga vii sətə mbee ŋgeerənə ŋga taa wu patə, kaa ənjə a kərə ka ənji nə'uutə də Yahudiya. ");
INSERT INTO gde_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Kə ɗatə tii ha'ə əsə, təya sləkee ka kərənə ka gayinə ŋga Ikəliisiya dacii i Barənaba da Sawulə. ");
INSERT INTO gde_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Ma ka saa'ita, kə 'watəgi ŋwaŋwə *Hirudusə ciɓənə də hara ənji nə'unə. ");
INSERT INTO gde_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Ha'ə kə bii ci ka ənjə a ɓələgi tə Yakubu ndzəkəŋuci Yoohana də ŋgila purəŋanə. ");
INSERT INTO gde_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Makə nee ci kə kaɗeesəkə ka *Yahudiinə nə ɓələginə tə Yakubu, ca ba, wa ənjə a kəsətə tə Piita əsə. Ma gi ka ɗanə, agi kumənə ŋga adə buroodi yadə burəŋanə kəshi ənji tə ci. ");
INSERT INTO gde_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Makə kəshi ənji tə ci, təya kərə tə ci aa furəshina. Hirudusə a kavə tə ci aacii soojiinə ənfwaɗə ənfwaɗə kurəgə ənfwaɗə, kaa təya nəhə tə ci, aadə ənjə a kərə tə ci aakəŋwacii daŋkana daba'a kumənəkii, waatoo kumənə ŋga *Pasəka. ");
INSERT INTO gde_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Ma saa'itə Piita a furəshina, ma ənji nə'unə natii, wata ka ɗa də'wa nə tii ka putaakii də gazhi'waanə. ");
INSERT INTO gde_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Ma ka vəɗə ŋga uusəratə mwayi Hirudusə ŋgiraginə tə Piita ka la ka ci gəŋwanə, Piita a tsəfə ŋunyinə ahada soojiinə bəra'i, ci ma'anəkii də mahyakahyaka'ə bəra'i. Ənji nəhə furəshina əsə, a makuvə nə tii. ");
INSERT INTO gde_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ma davəɗəkii, kə jigagi malaa'ika ŋga Slandana. Ɓərənə a ɓərəgi kuvəkii patə. Wata ca dəgee ka Piita ka taŋgalakii, ca maɗee ka ci, əŋki ci, “Maɗətə pii pii!” Wata mahyakahyaka'ətə a kwalyagərə acii Piita. ");
INSERT INTO gde_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Wata malaa'ikatə a ba ka Piita, “Ŋgaaŋgavə uushi'inaaku, ha ŋgavə ɓiɓinaaku.” Piita a ɗatə ha'ə. Əŋki malaa'ika ka ci, “Əgətə gwadaaku, ha nyi'wa tə nyi.” ");
INSERT INTO gde_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Piita a nə'u tə ci agyə. Mashiimə ci taa, ma sətə ci malaa'ika a ɗa, tantanyinə. Ma nə ci ka nəhənə, taa səniinə sənii ci. ");
INSERT INTO gde_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Makə paaləgi tii tə ənji nəhə kuvə ŋga təkəŋwanə da ŋga bəra'inə, təya mbu'u aa uura mayi ŋga tibisə ətə ŋga dəməginə aasəkə vəranə. Wata uura mayikii a wunəgi ka tii ci saakii. Təya gimagi, təya nə'u əndə'i rəgwa. Wata pii malaa'ikatə a bwasee ka ci. ");
INSERT INTO gde_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Makə ənya nə ŋga Piita aashikii, əŋki ci, “Manə ɗiya, kə shii nyi ndilə ndilə oo'i, kə sləkee Slandanə ka malaa'ikaakii ka luupaanə tə nyi acii Hirudusə da bwaya uushi'iitə ci Yahudiinə a moo ɗanə də nyi.” ");
INSERT INTO gde_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Shiinaakii ha'ə, wata ca palə aasii aa ha Mariyaama məci Yoohana ətə ɗii əndə'i ləməkii Marəkusə. Kə dzii ənji nə'unə də nə laŋə davə, təya ɗa də'wa. ");
INSERT INTO gde_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Mbu'unaakii ca dəgətə uura maya. Tə'i əndə'i kadəmə ətə ɗii ləmətə Rooda. Makə fii ki, wata kya shi ka faginə taa wu. ");
INSERT INTO gde_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Makə paaratəgi ki oo'i, uura ŋga Piita ətsa, mawunəgimə ki uura mayikii acii mooɗasəka. Wata kya ənəgərə aasii də huyi huyi, kya ba: “Waatsə Piita kəŋə a uura mayi!” ");
INSERT INTO gde_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","Təya ba ka ki, “Maba nə hə saŋə kwa?” Amma kya tsakə banə oo'i, ci ətsa. Əŋki tii, “Malaa'ikaakii ətsa.” ");
INSERT INTO gde_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Amma, mabwaseemə Piita ka dəgə uura mayikii. Wata təya wunəgi, təya nee ka ci. Kə kəŋee ka tii. ");
INSERT INTO gde_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Wata Piita a maɗee ka tii ka ciinəkii, kaa təya ndzaa kəɗa'ə, ca dzəgunətə ka tii makə sətə ŋgiragi Slandanə tə ci asəkə furəshina. Makə uudəpaa ci, əŋki ci ka tii, “A una ba ka Yakubu da hara ənji nə'unə.” Daba'ə ha'ə, ca maɗə, ca palə ka əndə'i ha. ");
INSERT INTO gde_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Pukənə ŋga ha, kə ma'i maɗuunə mabizhinə ahada soojiinə putə ŋga sətə slənyi tə Piita. ");
INSERT INTO gde_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Makə ali ənji tə ci ka Hirudusə, maneemə tii ka ci. Hirudusə a ləgwa a ma soojiinə, pooshi. Wata ca ba ka ənjə a ɓəələgi tə soojiita. Ma daba'əkii, ca maɗə anə hanyinə ŋga Yahudiya, ca palə aa Kayisariya, ca ta'avee davə. ");
INSERT INTO gde_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Ma ŋwaŋwə Hirudusə, ka maɓətəsəkə nə ci aashi ənji Tiira da ənji Sidoonə. Aciikii təya jagi də na, təya shi aaɓiikii ka səɗə rəŋwə, təya waɓə da Balasəta, waatoo gawə ŋga yi ŋga ŋwaŋwa. Makə uugi tii anəgi waɓənə da ci, təya alə ndzaanə jamə da Hirudusə, acii də zəmə ŋga nə ŋga hanyinaakii nə tii. ");
INSERT INTO gde_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ma ka uusəratə lii Hirudusə, ca ka kəjeerə ŋwaŋuunaakii, ca ndzaanə asəkə dəgələ ŋwaŋuunaakii, ca waɓə ka tii. ");
INSERT INTO gde_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Ənjə a wazə, təya ba, “Ma ətsa, waɓənə ŋga Əntaŋfə, əntaa ŋga ənda.” ");
INSERT INTO gde_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Pii wata malaa'ika ŋga Slandanə a dəgəgi tə ci, acii kə luuma ci ɗuunuunə ŋga Əntaŋfə. Zoozəniinə a tsəɓə tə ci. Ha'ə əntəgi ci. ");
INSERT INTO gde_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Amma, ma waɓənə ŋga Əntaŋfə, kə gi aakəŋwə aakəŋwa. ");
INSERT INTO gde_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Makə uudəpaa i Barənaba da Sawulə sləkeetə sləkee ənji ka tii aa Urusaliima, təya palə satii, təya ŋgərəənə tə Yoohana ətə ci ənjə a 'wa Marəkusə. ");
INSERT INTO gde_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Ma asəkə Ikəliisiya ŋga Antakiya, tə'i hara *anabiinə da ənji dzəgunənə, waatoo i Barənaba da Simiyoonə ətə ci ənjə a 'wa əndə dəŋwa da i Lukiyusə əndə Sirina da Manahina ətə girəshi tii da ŋwaŋwə *Hirudusə. Ahadatii nə Sawulə əsə. ");
INSERT INTO gde_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ma ka əndə'i uusəra, təya gərə'u ka Slandanə da ɗa suumaya. Əŋki Malaaɓa Ma'yanə ka tii, “Fə'yagimə ka nyi tə i Barənaba tii da Sawulə kaa təya slənə slənətə 'wii nyi tə tii.” ");
INSERT INTO gde_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Daba'ə suumaya da ɗa də'wa, təya kavə ciinətii aanətii, təya kapaa tə tii. ");
INSERT INTO gde_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Makə sləkee Malaaɓa Ma'yanə ka i Barənaba da Sawulə, təya palə aa Səluukiya, təya dzə ka dəmə kumbawalə davə ŋga dzəginə aanə hanyinə ŋga Kipərusə ətə ahada ma'inə. ");
INSERT INTO gde_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Mbu'unatii aanə hanyinəkii aasəkə vəranə ŋga Salamisa, təya ndzaŋə baaba waɓənə ŋga Əntaŋfə asəkə *kuvə də'wanyinə ŋga Yahudiinə. Kə gi Yoohana ka tsakənə tə tii əsə. ");
INSERT INTO gde_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","Makə wiigi'itə tii hanyinə ŋga Kipərusə patə kura'ə aa Pafusa, təya lapaa əndə'i əndə hiila ətə ɗii ləməkii Barə-Yeesu. Majirakə ŋga anabi ŋga Yahudiinə nə ci. ");
INSERT INTO gde_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Guva ŋga ŋgwaməna Sirəgiya Bulusə nə ci əsə. Ma ŋgwaməna, əndə shiinə nə ci. Ca 'wa tə i Barənaba da Sawulə, ca alə fa waɓənə ŋga Əntaŋfə amatii. ");
INSERT INTO gde_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","Amma, ma əndə hiilatsa, ətə ɗii ləməkii Ilimasə də uura Gərikə, kə ɗii ci ka tii mabizhinə, ha'ə kə mwayi ci zhi'wee ka ədzəmə ŋga ŋgwaməna acii ga ca nyi'u gooŋga. ");
INSERT INTO gde_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Amma, ma Sawulə, ətə ci ənjə a 'wa tə ci Bulusə əsə, da i Malaaɓa Ma'yanə nə ci, ca tsaamə tə əndə hiilatsa, ");
INSERT INTO gde_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","əŋki ci, “Ma hə, əndə ŋga *Seetanə nə hə, səsəŋwə ŋga gooŋga. See sətə ɗii bwayakii nəndə a ədzəməku. Pukyanə ŋga uusərə patə, ha'ə nə hə ka zhi'wee ka gooŋga ŋga Əntaŋfə ka jirakənə. ");
INSERT INTO gde_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Acii ha'ə ka dzalənə nə Slandanə tə hə, ha uurəfəgi, pa ha nee ka uusərə ma'ə kwakwatə.” Pii wata təkunə cii kəya nee ma'ə, ca raramə, ənjə a kəsə tə ci ka ciinə, acii paa ci ka nee ka ha ma'ə. ");
INSERT INTO gde_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Makə nee ŋgwaməna ka sətə slənyi, kə vii ci gooŋga ka Slandana, acii kə ɗii ka ci ka sə ŋga hurəshishinə nə dzəgunənə agyanəkii. ");
INSERT INTO gde_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Ma daba'əkii, wata Bulusə da ənji nə'ushinaakii a dəmə kumbawalə də Pafusa, təya palə aa Pirəga anə hanyinə ŋga Paməfiliya. Ma Yoohana, kə bwasee ci ka tii davə, ca ənə aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Amma, ma təya, təya paləgi tə Pirəga, təya palə aa Antakiya ətə anə hanyinə ŋga Pisidiya. Də asavee əsə, təya dəməgərə aasəkə *kuvə də'wa, təya ndzaanə da ənja, ");
INSERT INTO gde_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ənjə a jaŋga bariya ŋga Muusa da ləkaləkatə ŋga anabiinə. Wata gayinə ŋga kuva a sləkee ka banə ka tii oo'i, “Ndzəkəŋushi'ina, usamə da shinə. Mbu'u tə'i waɓənə ətə ca tsakə tə ənji a moonə.” ");
INSERT INTO gde_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Bulusə a maɗətə, ca maɗee ka ciinəkii ka ənja, ca ba, “Unə ənji *Isərayiila da hara ənji gərə'unə ka Əntaŋfə, fatəmə! ");
INSERT INTO gde_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ma Əntaŋfə ənə caama nə'u, amə ənji Isərayiila, ci ta'i tə dzədzəshi'inaamə, ca siitə tə tii saa'i tii anə hanyinə ŋga Misəra. Də maɗuunə baawəɗa əsə ŋgiragi ci tə tii də Misəra. ");
INSERT INTO gde_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Kə sə'wii ci tə tii ha'ə fəzə ənfwaɗə pu'unə agi bilinə əsə. ");
INSERT INTO gde_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","Ca zamagi də slikərənə məɗəfə anə hanyinə ŋga Kana'ana, ca vii ka tii hanyinəkii ŋga zəmə ya. ");
INSERT INTO gde_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","Ma ətsə patə, agi fəzə gya'ə ənfwaɗə da tufə pu'unə. Daba'a ha'ə ca ɗəkəvə ka tii gayinə ahadatii ha'ə mbu'ya ka zamana ŋga anabi Samuyila. ");
INSERT INTO gde_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Agi zamanaakii kədii tii kaa ənjə a ɗəkə ka tii ŋwaŋwa. Wata Əntaŋfə a ɗəkəvə ka tii tə Sawulə uuzənə ŋga Kisə, agi duurə ŋga Beejaminə. Ca ɗa ka tii ŋwaŋuunə ŋga fəzə ənfwaɗə pu'unə. ");
INSERT INTO gde_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Makə ŋgərəgi Əntaŋfə tə Sawulə, ca ɗəkəvə ka tii tə *Dawuda ka ŋwaŋuunə. Wiinə sətə waɓi Əntaŋfə anəkii, əŋki ci: ‘Kə upaa nyi tə Dawuda uuzənə ŋga Jasii, Ci nə əndətə cii kya uuɗə, Ci əsə na slənətə ka nyi sətə cii kya uuɗə patə.’ ");
INSERT INTO gde_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","“Agi slikərənə ŋga əndətsə kira Əntaŋfə ka ənji *Isərayiila Maluwa, waatoo Yeesu makə sətə ɗii ci aləkawalə ŋga ɗanə. ");
INSERT INTO gde_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Daga Yeesu ma'ə mashimə, kə waazii Yoohana ka ənji Isərayiila patə kaa təya zhi'wagi, təya bwasee ka 'waslyakəənatii, təya luu yiɓə bapətisəma. ");
INSERT INTO gde_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Ma Yoohana kədəhə ka uudəpaa slənaakii, kə ləguyi ci ama ənja: ‘Makə wu saŋə cuuna nəhə tə nya? Əntaa nyi nə əndətə cuuna gəra. Ma əndətə cuuna gəra, ma'ə ci ka shinə. Mambu'umə nyi bahə nya dəəɗəgi ka ci ɓiɓinaakii.’ ");
INSERT INTO gde_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“Ndzəkəŋushi'inə, jijinyinə ŋga Ibərahiima da hara ənji gərə'unə ka Əntaŋfə ahadoonə, kaamə sləkee Əntaŋfə Ŋunyi Habara ŋga luupaanə. ");
INSERT INTO gde_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Wiinə, ma ənjitə də Urusaliima da gayinatii, pooshi tii kavə nətii ka shiinə tə Yeesu. Ha'ə əsə mafatəmə tii waɓənə ŋga anabinyinə ətə ci ənjə a jaŋga ka tii taa ŋgutə uusərə ŋga əpisəkə patə. Amma, makə lagi tii ka Yeesu gəŋwanə, kə ɗii ka gooŋga nə waɓənə ŋga anabinyinə. ");
INSERT INTO gde_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Taa ŋgahi ma'upaamə tii tə ci da 'waslyakəənə bahə ɓələnə tə ci, amma kə kədii tii acii *Pilaatu ka ɓələginə tə ci. ");
INSERT INTO gde_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Makə uudəpaa tii ɗanə ka ci makə sətə shi ənjə a nyaahə agyanəkii patə, ənjə a jimagərə də ci ashi ənfwa, təya ŋgəɗəgi tə ci. ");
INSERT INTO gde_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Amma kə maɗee Əntaŋfə ka ci agi maməətə ənja. ");
INSERT INTO gde_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Kə baa ci ɓəzəkii ka ɓaarii naakii nə ka ənjitə shi tii da ci daga də Galili aa Urusaliima. Ma əndzə'i, tii nə seedawanyinaakii ka ənji Isərayiila. ");
INSERT INTO gde_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","“Ma inə əsa, kə kireenə koonə ŋunyi waɓənə ətə ɗii Əntaŋfə aləkawaləkii ka dzədzəshi'inaamə. ");
INSERT INTO gde_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","Kə mbu'utə ci kaamə jijinatii də aləkawaləkii əsə. Kə mbu'utəgi ci də maɗeenə ka Yeesu makə sətə nyaahə ənji asəkə Jabuura ŋga bəra'inə oo'i, ‘Ma hə, uuzənaaki nə hə, daga ənshinə kə ndzaa nyi ka Duu.’ ");
INSERT INTO gde_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Kə waɓi Əntaŋfə agyanə maɗeenə ka ci agi maməətə ənji oo'i, paa ci ka ənənə ka əntənə ma'ə, ca ɓəslə. Wiinə sətə bii ci: ‘Ka viinə nə nyi koonə ndilə ndilə tə malaaɓa barəkaanə makə ətə vii nyi ka Dawuda.’ ");
INSERT INTO gde_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Aciikii tə'i manaahəkii əsə asəkə əndə'i Jabuura oo'i, ‘Paa hə ka bwasee ka shishinə ŋga əndə slənaaku kaa ca ɓəsləgi.’ ” ");
INSERT INTO gde_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Bulusə a dzə aakəŋwa də banə, əŋki ci, “Ma Dawuda, kə slənyi ci agi zamanaakii makə sətə mwayi Əntaŋfə. Ma daba'əkii, ca əntəgi, ənjə a kagərə tə ci agyanə dzədzəshi'inəkii, ca ɓəsləgi. ");
INSERT INTO gde_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amma, ma əndətə maɗee Əntaŋfə ka ci agi maməətə ənja, maɓəsləmə ci. ");
INSERT INTO gde_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","“Acii ha'ə, ndzəkəŋushi'inə, see a shii unə oo'i, dacii Yeesu ciina waaza koonə agyanə tifyaginə ŋga 'waslyakəənə. Acii ma bariya ŋga Muusa, paa ci da ŋgeerənə ŋga luupaanə tuunə acii 'waslyakəənə. ");
INSERT INTO gde_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Amma taa wu patə vii ka Yeesu gooŋga, daciikii upaanəkii luupaanə. ");
INSERT INTO gde_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ma ɗii əna, nəhəmə noonə nə acii ga sətə bii anabinyinə a kulyaanə koonə ətə bii tii: ");
INSERT INTO gde_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘Tsaaməmə, unənə ca ushapaa sətə bii Əntaŋfə, haŋkala goonə a gwazəgi, una zagi. Acii kadə nii kya slənə əndə'i slənə agi zamana goonə ətə pooshi unə na luuvə taa kə bii ənji koonə.’ ” ");
INSERT INTO gde_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Ma i Bulusə da Barənaba a gimagi asəkə kuvə də'wa, ənjə a kədii tə tii kaa təya ənə ka batə ka tii waɓəətsə ka əndə'i uusərə ŋga əpisəkətə ca shi. ");
INSERT INTO gde_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Makə təəkəgi ənji a kuvə də'wa, ənji laŋə nyi'u tə tii, Yahudiinə da ənjitə gimə aagi diinə ŋga Yahudiinə patə. I Bulusə da Barənaba a waɓə ka tii kaa təya ndzaa də ŋgeerənə agi ŋga'əətə ɗii Əntaŋfə ka tii. ");
INSERT INTO gde_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Zhi'wanə ŋga uusərə ŋga əpisəkə ɗii dzawə, wata ənjə a ənslyagi pəɓə asəkə vəranə aasəkə kuvə də'wa ka fa waɓənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Makə nee hara Yahudiinə kə dzii ənji də nə laŋə, kə shirəhə tii ka i Bulusə, təya ɗa ka ci mabizhinə, təya dzə da dzaananə tə ci. ");
INSERT INTO gde_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Amma, ma i Bulusə da Barənaba, kə waɓi tii ka tii yadə ŋgwalənə, təya ba, “Kə ndzaa tyasə, a takəŋwa ənji ba koonə waɓənə ŋga Əntaŋfə taabu'u ka hara slikərənə. Amma, makə kə kaaree unə, una ɓaarii oo'i, madəɓeemə koonə nə upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə, yoo, a zhi'ugiinə səgeenə aaɓii hara slikərənə. ");
INSERT INTO gde_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Acii ha'ə bii Slandanə keenə, əŋki ci, ‘Kə kapaa nyi tə hə kaa ha ndzaa ka ɓərənə ŋga hara slikərənə, ha ndzaa ka rəgwa ŋga mbəɗənə ha'ə mbu'unəkii ka muudinə ŋga duuniya patə əsə.’ ” ");
INSERT INTO gde_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Makə fii ənjitə əntaa Yahudiinə ha'ə, kə ɗii tii mooɗasəka, təya ɗuunətə tə Slandanə putə ŋga waɓənəkii. Ma ənjitə ta'i Əntaŋfə tə tii ka upaa əpinə ŋga ca'ə ndəŋwə ndəŋwə, kə vii tii gooŋga. ");
INSERT INTO gde_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Kə təəkəgi waɓənə ŋga Slandanə taa dama patə anə hanyinəkii əsə. ");
INSERT INTO gde_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Amma Yahudiinə a tsəvutə tə matakəŋwanyinə ŋga vəranə da hara makinə ətə da məghərəvənə; ma makiita, ənji gərə'unə ka Əntaŋfə nə tii əsə. Təya maɗee ka waɓənə agyanə i Bulusə da Barənaba. Təya lakəənə tə tii anə hanyinatii. ");
INSERT INTO gde_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ma təya dzə də palənə satii, təya gwa'agi bərəbərə ŋga ɓiɓinatii agyanətii ka ɓaariinə ka tii oo'i, pooshi tii agi haalatii ma'ə. Wata təya palə aa Ikuniya. ");
INSERT INTO gde_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Ma ənji nə'unə ŋga Antakiya, kə ɗii tii mooɗasəkə ka shaŋə. Kə ndzaa tii da i Malaaɓa Ma'yanə asəkə ədzəmətii əsə. ");
INSERT INTO gde_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Ma də Ikuniya əsə, kə gimə i Bulusə da Barənaba aasəkə kuvə də'wa ŋga Yahudiinə, təya waaza ka ənji də gazhi'waanə. Ha'ə ɓəzəkii nə ənjitə vii gooŋga ka Slandana, Yahudiinə da hara slikərənə patə. ");
INSERT INTO gde_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amma, ma Yahudiitə kaaree ka vii gooŋga ka Slandana, kə maɗee tii ka ədzəmə ŋga hara slikərənə kaa təya bərapaa tə ənji nə'unə. ");
INSERT INTO gde_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Kə ta'avə i Bulusə da Barənaba də Ikuniya ka waazanə ka ənji agyanə Slandanə yadə ŋgwalənə taa gi'u. Təya waaza agyanə pwapoonaakii. Slandanə a vii ka tii baawəɗa ŋga ɗa sə ŋga hurəshishinə kama kama ka ɓaariinə oo'i, ma sətə ci təya ba, gooŋga. ");
INSERT INTO gde_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Amma kə təkəgi ənji kurəgə bəra'i asəkə vəranə. Hara ənji, a ba'a Yahudiinə nə tii. Hara ənji əsə, a ba'a masləkee ənja. ");
INSERT INTO gde_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Kə mwayi hara slikərənə da Yahudiinə da gayinatii ciɓeenə ka masləkee ənji də kaalanə tə tii də faariinə, ");
INSERT INTO gde_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","asee, kə gi aa limətii nə sətə mwayi ənji ɗanə də tii. Wata təya huyi satii aanə hanyinə ŋga Likaniya, waatoo aa Lisətira da Dyarəba da hara vəraatə guŋutə də hanyinəkii. ");
INSERT INTO gde_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","Təya waaza Ŋunyi Habara ŋga Slandanə davə. ");
INSERT INTO gde_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Tə'i əndə'i əndə də Lisətira, pooshi səɗəkii ndalə bahə wiigi'inə. Makə pwayi ənji tə ci, hurəndzəmə nə ci. Mashimə ca wii shaŋə. ");
INSERT INTO gde_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Ma ka əndə'i uusəra, ca fa waazanə ŋga Bulusə. Bulusə a tsaamə tə ci. Ma nee ci, ma əndətsa, kə vii ci gooŋga, kə dəɓee ca upaa mbəɗəpaanə. ");
INSERT INTO gde_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","Bulusə a maɗee ka uurakii, əŋki ci, “Maɗətə kəŋə anə səɗəku.” Wata hatsə əndətə a maɗətə, ca wii. ");
INSERT INTO gde_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Makə nee daŋkana ka sətə ɗii Bulusə, təya maɗee ka uuratii, təya ba də uura ŋga ənji Likaniya, “Kə jimagərə əntaŋfənyinə aaɓii amə makə ənja.” ");
INSERT INTO gde_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Təya ɗəkə ləmə ka Barənaba “*Jawusə”. Ma Bulusə əsə, təya ɗəkə ka ci “*Heerəməsə” puta ɗii ci ka ŋwaŋwə waɓənə. ");
INSERT INTO gde_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Ma dava, tə'i kuvə uuləma ətə ci təya 'wa Jawusə, a uura mayi ŋga vəranə. Wata limanə ŋga uuləməkii a ŋgərə bubuŋənyinə, ca zaɗətə də gudəza, ca kira aa uura mayi ŋga vəranə kaa təya ɗa sataka da ənja ka i Barənaba da Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amma, makə fii i Bulusə ha'ə, təya tsaatsagi kəjeerənə ashitii ka ɓaariinə oo'i, kə ɓəzhi səkətii ka shaŋə. Təya huyi aagi ənja, təya dzə də maɗee ka uuratii, əŋki tii, ");
INSERT INTO gde_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Una! ka mi cuuna ɗa ha'ə kwa? Ma inə kamə, ənji niinə makə noonə. Kə kireenə koonə Ŋunyi Habara koona bwasee ka mazaɓə uushi'iitsa, una nə'u tə Əntaŋfə Əndə vii əpinə. Ci tagii ha dadagyə da ha apanə da uunəva da sətə asəkətii patə. ");
INSERT INTO gde_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Ma ŋga ŋukə, kə bwasee ci ka slikərənyinə patə kaa təya paaslə uushi'inatii. ");
INSERT INTO gde_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","Patə da ha'ə, mabwaseemə ci ka naakii nə yadə seeda, agi ɗanə nə ci koonə ŋga'əənə, ca ndzəmə koonə vəna, ca vii koonə ŋunyi cifanə, ca əburətə tuunə də zəma, ca vii koonə mooɗasəkə əsə.” ");
INSERT INTO gde_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Taa ŋgahi kə waɓi tii ka tii waɓəətsə patə, ŋgahə təŋapaa tii tə tii ka ɗa ka tii sataka. ");
INSERT INTO gde_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Asee, tə'i hara *Yahudiinə shi aa dəvə daga də Antakiya da Ikuniya. Təya shi ka tsəvutənə tə daŋkana. Təya kaala tə Bulusə də faariinə, təya ələgi tə ci aa ba'a vəranə. Ma nə tii ka nəhənə, kə əntəgi ci. ");
INSERT INTO gde_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Amma ənji nə'unə a shi, təya dzatə də nə aaɓiikii, ca maɗətə, ca ənəgərə aasəkə vəranə. Pukənə ŋga ha, təya maɗə tii da Barənaba, təya palə aa Dyarəba. ");
INSERT INTO gde_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Makə waazii tii Ŋunyi Habara asəkə vəranəkii, kə upaa tii ənji nə'unə laŋə. Ma daba'əkii, təya ənə aa Lisətira da Ikuniya da Antakiya ətə anə hanyinə ŋga Pisidiya. ");
INSERT INTO gde_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","Ma asəkə vəranyiitsa, kə vii tii ŋgeerənə ka ənji nə'unə, təya ba ka tii, wa təya kəŋə anə vii gooŋgatii. Təya tsakə banə ka tii oo'i, see dagi ciɓə laŋə upaanaamə dəmənə aagi ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Daba'ə ha'ə, təya taaɗəcii ka tii matakəŋwanyinə asəkə taa ŋgutə Ikəliisiya, təya ɗa də'wa da suumaya, təya kavə tə tii aacii Slandanə ətə vii tii ka ci gooŋga. ");
INSERT INTO gde_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","I Barənaba da Bulusə a pitəgi asəkə hanyinə ŋga Pisidiya, təya mbu'u aanə hanyinə ŋga Paməfiliya, ");
INSERT INTO gde_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","təya waaza waɓənə ŋga Əntaŋfə ka ənji də Pirəga. Ma daba'əkii, təya maɗə, təya palə aa Ataaliya. ");
INSERT INTO gde_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","Təya dəmə kumbawalə davə, təya palə aa Antakiya, waatoo vəraatə shi ənjə a kavə tə tii aacii Əntaŋfə kaa ca ɗa ka tii pwapoonə agi sləna, waatoo ətsə uudəpaa tii. ");
INSERT INTO gde_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","Makə mbu'i tii aa dəvə, təya dzaadzatə də ənji nə'unə, təya ba ka tii habara ŋga sətə ɗii Əntaŋfə daciitii da makə sətə wunəgi ci ka hara slikərənə rəgwa ŋga vii gooŋga. ");
INSERT INTO gde_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","Təya ta'avee tii da ənji nə'unə davə. ");
INSERT INTO gde_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Tə'i hara ənji shi daga də Yahudiya aa Antakiya, təya dzəgunə ka ənji nə'unə, təya ba, “Maɗa *maryaminyamuunə makə ŋga alə'aada ŋga Muusa, pooshi unə ka upaa luupaanə.” ");
INSERT INTO gde_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Kə ɗii i Bulusə da Barənaba mabizhinə da ənjitsa. Waɓənəkii a gwazəgi ka shaŋə. Makə uurəgi haalakii aanətii, ənjə a sləkee ka i Bulusə da Barənaba da hara ənji nə'unə aa Urusaliima, kaa təya dzə aaɓii masləkee ənja da matakəŋwanyinə ŋga Ikəliisiya agyanə waɓəətsa. ");
INSERT INTO gde_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Makə sləkee ənji nə'unə ka tii, təya maɗə, təya paləgi dasəkə hanyinə ŋga Finikiya da ŋga *Samariya, təya dzə də baaba habara ŋga zhi'inə ŋga hara slikərənə ka ənji nə'unə. Fanə ŋga ənji nə'unə ha'ə, agi ɗanə nə tii mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Makə mbu'i tii aa Urusaliima, kə liwə ənji Ikəliisiya da masləkee ənji da matakəŋwanyinə ŋga Ikəliisiya tə tii də mooɗasəka. I Bulusə a baaba ka tii sətə slənyi Əntaŋfə daciitii patə. ");
INSERT INTO gde_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","Amma hara ənji nə'unə kurəgə ŋga Farisanyinə a maɗətə, təya ba, “Ma ənjitsa, tyasə, see a ryaminya tii, ənjə a ba ka tii təya nə'u bariya ŋga Muusa.” ");
INSERT INTO gde_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Wata masləkee ənji da matakəŋwanyinə ŋga Ikəliisiya a dza də nə ka tsaamənə agyanə waɓəətsa. ");
INSERT INTO gde_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Makə ta'avə tii ka ɗaaɗa waɓənə ahadatii, Piita a maɗətə, əŋki ci: “Ndzəkəŋushi'ina, makə sətə shii unə, daga ŋukə ta'i Əntaŋfə tə nyi ahadoonə kaa hara slikərənə a fa Ŋunyi Habara da maki, təya luuvə. ");
INSERT INTO gde_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Kə shii Əntaŋfə ədzəmə ŋga taa wu patə, ca seeda tə tii də vii ka tii Malaaɓa Ma'yanə makə sətə vii ci kaamə əsə. ");
INSERT INTO gde_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Matəkeemə ci ahadaamə da tii. Putə ŋga vii gooŋgatii kuɓəgi ci ədzəmətii makə naamə. ");
INSERT INTO gde_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Makə ha'ə ɗii əna, ka mi saŋə cuuna alə haliminə ŋga Əntaŋfə də kaanə ka ənji nə'unə tə bariya ŋga Muusa? Taa amə da dzədzəshi'inaamə maa, kə təkuree amə ka nə'utə bariyaakii. ");
INSERT INTO gde_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Amma kə vii amə gooŋga oo'i, putə ŋga pwapoonə ŋga Slandanə Yeesu upaa amə luupaanə makə sətə upaa tii natii əsə.” ");
INSERT INTO gde_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Daɓaala a ndzaa kəɗa'ə, təya ənə ka fanə a ma i Barənaba da Bulusə, təya ba ka tii sə ŋga hurəshishiitə ɗii Əntaŋfə ka hara slikərənə daciitii. ");
INSERT INTO gde_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Makə uudəpaa tii waɓənə, Yakubu a maɗətə, ca jikəvə, əŋki ci: “Fatəmə, ndzəkəŋushi'inə. ");
INSERT INTO gde_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Əndzə'i əna bii Simoonə kaamə makə sətə 'watəgi Əntaŋfə nəhənə tə hara slikərənə kaa ca taɗəgi hara ənji agitii, təya ndzaa ka ənjaakii. ");
INSERT INTO gde_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Kə ɗii waɓəətsə mbərə mbərə da ŋga anabiinə makə sətə ɗii manaahəkii oo'i, ");
INSERT INTO gde_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘Əŋki Slandana: Ma aakəŋwa, ka shinə nə nyi ka haɗatəginə də yi ŋga *Dawuda ətə saawagi. Ka ŋgərənə nə nyi sətə sasaawagi, nya ənə ka haaɗatəginə, nya kəŋee, ");
INSERT INTO gde_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","kaa hara ənjə a alə tə nyi Slandanətii, waatoo patənə ŋga hara slikərəətə 'wii nyi kaa təya ndzaa ka naaki. ");
INSERT INTO gde_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Ha'ə bii Slandanə ətə bagi uushi'iitsə daga ŋukə.’ ” ");
INSERT INTO gde_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Yakubu a tsakə banə, əŋki ci, “Ma nee nyi naaki, ma hara slikərənə ənə ca zhi'wa aaɓii Əntaŋfə, gaama irəla tə tii. ");
INSERT INTO gde_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Amma, naahaamə ka tii ləkaləkatə də banə, ga təya adə zəmətə ɗii ənji ka uuləminə taa sləmənyinə, acii ma ətsa, ajijinə. Ga təya aləhiinə, ga təya tsəɓə luutə malamə ənji uurakii, ga təya adə idəna. ");
INSERT INTO gde_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Acii ma bariya ŋga Muusa, daga ŋukə, taa ka ŋgutə vəranə patə, tə'i ənji waaza agyanəkii, ənjə a jaŋga asəkə *kuvə də'wanyinə taa ŋgutə *uusərə ŋga əpisəka.” ");
INSERT INTO gde_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Fanə ŋga masləkee ənji da matakəŋwanyinə ŋga Ikəliisiya ləɓə da ənji Ikəliisiya patə tə waɓəətsa, wata təya anə uura ŋga taɗə ənji ahadatii, kaa təya sləkee ka tii aa Antakiya, tii da i Bulusə da Barənaba. Wata təya taɗə tə Yahuda ətə ci ənjə a 'wa Barəsaba, tii da Silasə. Matakəŋwanyinə nə tii ahada ənji nə'unə əsə. ");
INSERT INTO gde_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","Wata təya sləkee ka tii də ləkaləkatəkii. Wiinə sətə nyaahə tii asəkə ləkaləkatəkii: “Wiinə ləkaləkatə ca dzə ka hara slikərənə ənji nə'unə də Antakiya da Siriya da Silikiya. Ma ləkaləkatəna, dacii inə ndzəkəŋushi'inuunə masləkee ənji da matakəŋwanyinə ŋga Ikəliisiya də Urusaliima. Kə nəhəpaa inə tuunə patə. ");
INSERT INTO gde_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","“Kə fii inə oo'i, kə gi hara ənji ahadeenə, təya dzə ka maɗee ka haŋkala goonə də waɓənə, təya kəɗəpaa tuunə. Ma ətsa, əntaa inə bii ka tii ɗanə ha'ə. ");
INSERT INTO gde_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ma caamiinə, makə kə gi waɓənə geenə ka rəgwa rəŋwə, kə dəɓee ina taɗə ənji ahadeenə, ina sləkee ka tii koonə, təya dzə da i mooɗəkii gaamə Barənaba da Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","Ma təya, kə vigi tii əpinatii ka putə ŋga slənə ŋga Slandanaamə Yeesu Aləmasiihu. ");
INSERT INTO gde_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ci nee unə ka i Yahuda da Silasə ahadoonə, tii na ba koonə də matii sətə nyaahiinə. ");
INSERT INTO gde_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kə kaɗeesəkə ka Malaaɓa Ma'yanə da inə patə oo'i, geena tsakəənə koonə kərənə pamə palee ka uushi'iitə ndzaa tyasə, waatoo, ");
INSERT INTO gde_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","goona adə sətə ɗii ənji ka uuləminə taa sləmənyinə, goona adə idəna, goona tsəɓə luutə malamə ənji uurakii, goona aləhiinə. Maɗa kə təŋapaa unə noonə nə ka ɗaaɗa tsarə uushi'iitsa, ka ndzaanə nuunə jamə. Ta'avəmə jamə.” ");
INSERT INTO gde_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Makə kapaa ənji tə i Bulusə, təya palə aa Antakiya, təya dzatə də ənji nə'unə, təya vii ka tii ləkaləkatəta. ");
INSERT INTO gde_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Makə jaŋgatə tii, kə ɗii tii maŋushinə ka shaŋə acii kə vii waɓəətsə ka tii ŋgeerənə. ");
INSERT INTO gde_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Ma i Yahuda da Silasə, *anabiinə nə tii, kə waɓi tii ŋgaaŋga'ə ka ənji nə'unə, təya tsakə ka tii ŋgeerənə. ");
INSERT INTO gde_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","Makə banee tii davə gi'u, ənji nə'unə a kəree ka tii də jamənə. Yahuda da Silasə a ənə aaɓii ənjitə sləkee ka tii.  ");
INSERT INTO gde_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","Amma, ma nee Silasə, kə dəɓee ca ənəgi davə. ");
INSERT INTO gde_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Ma i Bulusə da Barənaba, kə ənəgi tii də Antakiya, təya dzəgunə ka ənja, təya dzə də waaza waɓənə ŋga Slandana, tii da hara ənji nə'unə laŋə əsə. ");
INSERT INTO gde_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Makə ta'avə tii davə, Bulusə a ba ka Barənaba, “Ənaaŋwə ka caamatə ənji nə'uutə shi aŋwa waazii ka tii waɓənə ŋga Slandanə taa ka ŋgutə vəranə, kaaŋwa tsaamətə taa iitə nə tii agi nə'unə.” ");
INSERT INTO gde_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Ma Barənaba əsə, kə mwayi ci 'waanənə tə Yoohana ətə ci ənjə a 'wa Marəkusə. ");
INSERT INTO gde_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Amma kə caamə Bulusə, madəɓeemə Yoohana a dzə da tii, acii kə shi ca bwasee ka tii də Paməfiliya, ma'uudəpaamə ci slənəkii da tii. ");
INSERT INTO gde_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Wata təya ɗaanə mabizhinə, təya təkəgi. Barənaba a ŋgərə tə Marəkusə, təya dəmə kumbawalə, təya palə aanə hanyinə ŋga Kipərusə. ");
INSERT INTO gde_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Amma, ma Bulusə, kə ŋgirə ci tə Silasə. Makə ɗii ənji ka tii də'wa, təya kavə tə tii aacii Slandana kaa ca ɗa ka tii pwapoonə agi wiigi'inatii, wata təya palə. ");
INSERT INTO gde_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Kə wiigi'itə i Bulusə hanyinə ŋga Siriya da ŋga Silikiya, təya dzə də baabanə ka ənji nə'unə kaa təya tsakə ndzaanə də ŋgeerənə agi vii gooŋgatii. ");
INSERT INTO gde_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","I Bulusə a mbu'u aa Dyarəba da Lisətira. Təya lapaa əndə'i əndə nə'unə davə ətə ɗii ləməkii Timooti, uuzənə ŋga əndə'i mitə Yahuda. Ma miita, əndə nə'unə nə ki əsə. Ma dii, əndə Gərikə nə ci. ");
INSERT INTO gde_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Ma Timooti, agi dəlaginə nə ənji nə'unə ŋga Lisətira da Ikuniya də ci. ");
INSERT INTO gde_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Kə uu'i Bulusə kaa təya wiigi'i tii da Timooti, wata ca ŋgərə tə ci, ca *ryaminyagi tə ci, acii kə shii Yahudiitə davə patə oo'i, ma dii, əndə Gərikə nə ci. ");
INSERT INTO gde_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Ma daba'əkii, təya ndzaŋə wiigi'inə ka vəra ka vəra, təya dzə də baabanə ka ənji nə'unə tə bariyatə kapaa masləkee ənji da matakəŋwanyinə ŋga Ikəliisiya də Urusaliima kaa təya nə'utə. ");
INSERT INTO gde_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Də ha'ə kiŋə ənji nə'unə ndihə ndihə agi vii gooŋgatii. Taa ŋgutə uusərə patə nə laŋənatii ka tsakənə əsə. ");
INSERT INTO gde_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Ma daba'əkii, kə mwayi tii dzənə ka waaza waɓənə ŋga Slandanə aanə hanyinə ŋga Asiya, amma kə təŋapaa Malaaɓa Ma'yanə tə tii. Wata təya paləgi aanə hanyinə ŋga Firigiya da ŋga Galatiya. ");
INSERT INTO gde_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","Makə mbu'i tii aagyanə riɓinə ŋga hanyinə ŋga Misiya, təya alə dəməgərənə aanə hanyinə ŋga Bitiniya. Amma maluuvəmə Ma'yanə ŋga Yeesu ka tii. ");
INSERT INTO gde_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Wata təya pitəgi tə Misiya, təya jimagərə aa Tərawasə. ");
INSERT INTO gde_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Ma uusərakii davəɗə, kə sənii Bulusə davə oo'i, kə nee ci ka əndə Makiduuniya kəŋə, ca kədii tə Bulusə, ca ba, “Tyaŋagi aanə hanyinə ŋga Makiduuniya, kaa ha shi ka tsakənə tiinə.” ");
INSERT INTO gde_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Daba'ə səniinaakii, pii ina tasəka dzənə aanə hanyinə ŋga Makiduuniya. Acii kə shii inə oo'i, Əntaŋfə 'wii tiinə ka waaza ka tii Ŋunyi Habara. ");
INSERT INTO gde_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Wata ina dəmə kumbawalə də Tərawasə, ina kəŋee da i aa Samutərasə. Pukənə ŋga ha ina palə aa Niyapuli. ");
INSERT INTO gde_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Ina maɗə davə, ina palə aa Filipi, vəraatə palee də ɗuunuunə agyanə əndə'i purəŋanə ŋga hanyinə ŋga Makiduuniya, vəranə ŋga ənji Rooma əsə. Ina banee gi'u asəkə vəraatsa. ");
INSERT INTO gde_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ma *uusərə ŋga əpisəka, kə dəməgiinə aa uura mayi ŋga vəranə, ina dzə aama gəəra. Mbu'u ka lapaanə niinə ha ŋga ɗa də'wa ŋga Yahudiinə davə. Wata ina lapaa. Davə ndzaa inə, ina waɓə ka makiitə dzii də nə davə. ");
INSERT INTO gde_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Tə'i əndə'i minə ətə ɗii ləmətə Lidiya ca fa tiinə. Ma kya, mitə Tiyatira nə ki. Ɗərə də madizə kəjeerənyinə ŋga mandalə kwaɓa nə slənatə. Əndə ŋgwalənə tə Əntaŋfə nə ki əsə. Kə wunəgi Slandanə ədzəmətə. Ha'ə kya kavə haŋkalatə ka sətə ci Bulusə a ba. ");
INSERT INTO gde_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Kə liwə ki yiɓə bapətisəma da ənji yatə patə, kya kədii tiinə, əŋki ki, “Makə kə shii unə ndilə ndilə oo'i, kə vii nyi gooŋga ka Slandana, yoo, see a dzuunə ka nee ka yaaki.” Kya tsakə kədiinə tiinə, keena palə. ");
INSERT INTO gde_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Ma ka əndə'i uusəra, ina dzə ka ha ŋga ɗa də'wa, ina lapaa əndə'i uundzə rəmənə, mava. Əndə ginaaji nə ki, agi kuranə nə ki uushi'inə kama kama putə ŋga ginaajiitə ashitə. Agi dzanə nə ki də kwaɓa laŋə ka slanjiinətə əsə də kwaaranə. ");
INSERT INTO gde_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Wata nə'unə tiinə da i Bulusə nə ki, kya dzə də ka vurənə, kya ba, “Ma ənjitsa, ənji ŋga maɗuunə Əntaŋfə nə tii. Rəgwa ŋga luupaanə nə tii ka banə koonə.” ");
INSERT INTO gde_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Ha'ə kə ta'avə ki baanə laŋə ka ɗanə makə ətsa. Ca zhimagi tə Bulusə asəkəkii ka shaŋə. Ca zhi'wagi, ca ba ka ginaajiitə ashitə, “Wanyinə ca ba ka hə də ləmə ŋga Yeesu *Aləmasiihu: bwasee ka ki!” Wata pii ginaajiitə a bwasee ka ki ka saa'ita. ");
INSERT INTO gde_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Makə nee slanjiinətə oo'i, kə njiikəgi rəgwa ŋga upaanatii, təya kəəsətə tə i Bulusə da Silasə, təya kərə tə tii aasəkə luuma aakəŋwacii ənji la gəŋwanə. ");
INSERT INTO gde_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Makə kirə tii tə tii aakəŋwaciitii, kə bii tii, əŋki tii, “Ma ənjina, agi gwazənə nə tii haŋkala ŋga vəraana, wiinə boo, *Yahudiinə nə tii. ");
INSERT INTO gde_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Agi dzəgunənə nə tii alə'aadatə madəɓeemə kaamə, kaama slənəgi, amə ənji Rooma.” ");
INSERT INTO gde_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Daŋkana a guŋuunə ka tii patə, mala gəŋwanyinə a səəɗəgi kəjeerənə ashitii, təya ba ka ənjə a fəəslə tə tii də kurəpa. ");
INSERT INTO gde_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Makə fəsləgi ənji tə tii purə'i purə'i, təya fəɗə tə tii, təya əjigərə tə tii aa furəshina, təya ba ka əndə nəhə furəshina kaa ca pa'əgi tə tii ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Fanə ŋga əndə nəhə furəshina naakii, wata ca ŋgərə tə tii, ca əjigərə ancakuvə ŋga furəshina, ca aanəgi səɗətii ashi madiigərə rintənyinə. ");
INSERT INTO gde_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Ma ahada vəɗa, Bulusə da Silasə a ɗa də'wa, təya ka wanyanə ka Əntaŋfə. Ənji furəshina a dzə də fanə tə tii. ");
INSERT INTO gde_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Mata'avəmə dəŋwa'ə, hanyinə a gəgədzə patə. Ha'ə mwavəɗə ŋga kuvə furəshina a udzəgi. Pii wata makuvənyinə a wunəgi patə. Mahyakahyaka'ə ŋga taa wu agi ənji furəshina əsə, kə piitəgi. ");
INSERT INTO gde_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Makə və'ihə əndə nəhə furəshina, ma ca nee, mawuunəkii nə makuvənyinə patə. Wata ca də'yagi ŋgila purəŋanaakii kaa ca ɓələgi naakii na. Ma nə ci ka nəhənə, kə huyipaa ənji furəshina satii. ");
INSERT INTO gde_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","Amma Bulusə a maɗee ka uurakii, ca ba ka ci, “Ga ha ɓələgi naaku na, ganə niinə patə!” ");
INSERT INTO gde_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","Əndətə a ba ka ənjə a kira ka ci gunə, wata ca huyi aaɓii i Bulusə da Silasə, ca gərə'waanə akəŋwaciitii. Shishinəkii a dzə də udzənə acii ŋgwalənə. ");
INSERT INTO gde_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Ca fə'yagi tə tii agyə, ca ba, “Ya əna, iitə ɗanəki kaa nya upaa luupaana?” ");
INSERT INTO gde_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","I Bulusə da Silasə a ba ka ci, “Vii gooŋga ka Yeesu Slandana: ka upaanə nə hə luupaanə da yaaku patə.” ");
INSERT INTO gde_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Wata təya waɓə ka ci da ənji yaakii patə agyanə Slandana. ");
INSERT INTO gde_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Pii agi vəɗəkii ha'ə ca ŋgərə tə tii, ca cakuɓəgi ka tii uyiginatii. Saa'ikii yiɓə ənji ka ci bapətisəma da yaakii patə əsə. ");
INSERT INTO gde_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Ca kərə tə tii aa hakii aasii, ca ŋgiragi ka tii zəma, ca ɗa mooɗasəkə da yaakii patə putə ŋga vii gooŋgatii. ");
INSERT INTO gde_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Makə puki ha, mala gəŋwanyinə a sləkee ka soojiinə ka banə oo'i: “Wa ənjitə a palə satii.” ");
INSERT INTO gde_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Əndə nəhə furəshina a dzə ka banə ka i Bulusə, əŋki ci, “Kə sləkee mala gəŋwanyinə ka banə koonə, a paluunə səgoonə. Acii ha'ə, gimagimə, una dzə səgoonə agi jamənə.” ");
INSERT INTO gde_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Amma əŋki Bulusə, “Akəŋwacii ənji fəəsli tii tiinə, wiinə malamə ənji keenə gəŋwanə, təya əjigərə tiinə aa furəshina. Wiinə əsə uushi rəŋwə niinə da ənji Rooma. Yoo, təya kapaa tiinə də ma'umbeekii nii? Pooshi ka ɗanə! Wa təya shi də natii na, təya shi ka kapaanə tiinə.” ");
INSERT INTO gde_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Soojiinə a ənəpaa də waɓənəkii ka mala gəŋwanyinə. Makə fii tii oo'i, uushi rəŋwə da ənji Rooma nə i Bulusə da Silasə, kə ŋgwaləgi tii. ");
INSERT INTO gde_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Wata təya shi ka kədii tifyaginə aciitii, təya kapaa tə tii, təya ba ka tii, wa təya bwasee ka vəranəkii. ");
INSERT INTO gde_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","I Bulusə da Silasə a gimagi asəkə furəshina, təya palə aasii aa ha Lidiya, təya lapaa ənji nə'unə davə, təya waɓə ka tii kaa təya ndzaa ndihə ndihə də ŋgeerənə agi nə'unə tə Slandana. Ma daba'əkii, təya palə satii. ");
INSERT INTO gde_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Kə gi tii dasəkə vəranyinə ŋga Amfipuli da Apulooniya, təya mbu'u aa Teesaloonika, hatə ɗii *kuvə də'wa ŋga Yahudiinə davə. ");
INSERT INTO gde_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Bulusə a dzə aa dəvə aa kumu, makə sətə sənaavə ci ka ɗanə taa da patə. Luuma makkə nə ci ka waɓənə da ənja, ca dzə də jaŋganə asəkə malaaɓa ləkaləkatə. ");
INSERT INTO gde_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Ca waɓə ka tii, ca ɓaarii ka tii tantanyinə ŋga sətə bii malaaɓa ləkaləkatə oo'i, ma *Aləmasiihu, see a sa ci ŋgəra'wa, ca əntə, ca maɗətə agi maməətə ənja. Ca ba əsə, “Yeesu ənə cii kya ba koonə, ci nə Aləmasiihu.” ");
INSERT INTO gde_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Hara ənjə a luuvə, təya nə'ushi da i Bulusə da Silasə. Ha'ə əsə laŋə agi ənji Gərikə ətə ca gərə'u ka Əntaŋfə. Matakəŋwanyinə ŋga makinə laŋə ləɓətəgi də nə da tii əsə. ");
INSERT INTO gde_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Amma kə shirəhə Yahudiinə ka tii. Təya dzatə də badawiinə ŋga vəranə, təya jagi də ənji də kaala bwaya vurənə, təya dzə ka əɓigi yi ŋga Yasoonə, təya alə tə i Bulusə da Silasə davə kaa təya ŋgiragi tə tii ka ənja. ");
INSERT INTO gde_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Amma paa tii lapaa tə tii. Wata təya kəsəənə tə Yasoonə da hara ənji nə'unə, təya kərə tə tii aakəŋwacii gayinə ŋga vəranə, təya maɗee ka uuratii, təya ba, “Ənjitə gwazətə nə ŋga ənji taa dama patə, watiinə kə shi aa hanə əsə. ");
INSERT INTO gde_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Yasoonə a luu tə tii gakii asii. Wiinə patənatii kə kaanə tii səɗə ka bariya ŋga maɗuunə ŋwaŋwə ŋga ha də Rooma, təya ba: tə'i əndə'i ŋwaŋwə ətə ɗii ləməkii Yeesu.” ");
INSERT INTO gde_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Makə fii gayinə da ənji ŋga vəranə tə waɓəətsa, haŋkalatii a maɗəgi patə. ");
INSERT INTO gde_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","See də makə ki'i Yasoonə da hara ənji kwaɓa taabu'u kapaa gayinə tə tii. ");
INSERT INTO gde_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Pii ndzəkəŋushi'inə a kəree ka i Bulusə da Silasə aa Biriya davəɗə. Makə mbu'i tii aa dəvə, təya dzə aa *kuvə də'wa ŋga Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Ma Yahudiitə davə kamə, kə palee tii ka ətə də Teesaloonika də hiima, kə banee tii ka haŋkalatii ka fa waɓənə ŋga Slandana. Kə ɗii tii gazhi'waanə ŋga tsaamətənə asəkə malaaɓa ləkaləkatə uusərə patə, kaa təya shii taa gooŋga nə sətə fii tii. ");
INSERT INTO gde_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Acii ha'ə laŋə agitii vii gooŋga. Laŋə əsə agi matakəŋwanyinə ŋga makinə ŋga Gərikə da ŋguyirənə vii gooŋga. ");
INSERT INTO gde_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Amma, makə fii Yahudiinə ŋga Teesaloonika oo'i, agi baabanə nə Bulusə waɓənə ŋga Əntaŋfə də Biriya əsə, təya dzə ka tsəvutənə tə daŋkana davə. ");
INSERT INTO gde_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","Pii wata ndzəkəŋushi'inə a kəree ka Bulusə aama uunəva. Amma Silasə da Timooti a ənəgi davə. ");
INSERT INTO gde_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Ma ənjitə kəree ka Bulusə, kə gi tii da i ci kura'ə aa Ateena. Ma təya ənya satii aasii, Bulusə a sləkee ka tii kaa təya dzə ka banə ka i Silasə da Timooti oo'i, wa təya shi ka lanə tə ci pii pii. ");
INSERT INTO gde_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Ma Bulusə a gəra tə Silasə da Timooti də Ateena, kə zhima tə ci asəkəkii makə nee ci, taa aa dəma patə tsaaməgi ci, see uuləminə neenəkii asəkə vəranəkii. ");
INSERT INTO gde_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Ci ɗii gi ci aakəŋwa də waɓənə ka ənji uusəra patə. Taa dama gi ci patə asəkə vəranəkii, taa a luuma lii ci ənja ca waɓə ka tii, taa asəkə kuvə də'wa ca waɓə ka Yahudiinə da ənji gərə'unə ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Hara ənji dzəgunənə agi kurəgə ŋga *Abikuriyanyinə da Sitookanyinə, kə lii tii tə Bulusə. Hara ənji ahadatii a ba, “Mi saŋə nə əndə waazaanə ka gəgəmənə ha'a? Mi mwayi ci bana?” Hara ənjə a ba, “Mbu'u ma nə ci ka waazanə, agyanə sə ŋga paslənə ŋga məshipətə ənji pamə.” Ma waɓi tii ha'ə, acii ma Bulusə, agyanə Yeesu da agyanə maɗənə agi maməətə ənji cii kəya waɓə. ");
INSERT INTO gde_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Wata təya ŋgərə tə ci, təya kərə tə ci aakəŋwacii mətərəkinə aanə ɗaŋgəra ətə ci ənjə a 'wa Ariyapaga, təya ba, “Ŋga'ə keenə nə fa sətə bii kura waazaatsə ɗii hə, ");
INSERT INTO gde_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","acii kə kira hə keenə sətə mashimə liminiinə a fii. See a ba hə keenə sətə cii kəya ba.” ");
INSERT INTO gde_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Ma bii tii ha'ə, acii ma ənji Ateena da mu'umiitə davə patə, pooshi əndə'i uushi nji təya ɗa, see baaba kura uushi'inə taa fa kura waɓənə. ");
INSERT INTO gde_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Wata Bulusə a maɗətə ahada mətərəkinə ŋga Ariyapaga, əŋki ci, “Unə ənji Ateena, kə nee nyi taa ka ŋgutə rəgwa patə, ənji diina nuunə. ");
INSERT INTO gde_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Acii ma nya dzə də wiinə asəkə vəranə goonə, kə lapaa nyi uushi'iitə cuuna paslə ka tii. Ha'ə nya lapaa ha ŋga ɗa sataka ətə nyaahə ənji ashikii: ka Əntaŋfə ətə mashiimə ənji. Yoo, ma ətə cuuna paslə mashiimuunə ɗiya, tə ci cii kya ba koonə. ");
INSERT INTO gde_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Əntaŋfə ətə tagii duuniya patə da uushi'iitə asəkəkii patə, ci nə Slandanə ŋga ha dadagyə da ha a panə. Paa ci ka ndzaanə asəkə kuvə gəratə ghənyi ənji də ciinə. ");
INSERT INTO gde_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Ha'ə əsə paa ci ka alə tsakənə tə ci, makə ɗii ci pooshi uushi cii kəya moo acii ənda, acii ci vii əpinə ka ənji da taa mi patə. ");
INSERT INTO gde_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Də əndə rəŋwə 'watəgi ci taga slikərənyinə ŋga ənji patə kaa təya ndzaa taa dama patə asəkə duuniya, ca kəŋee ka saa'i da i riɓinə ŋga ndzaanatii əsə. ");
INSERT INTO gde_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Ma ɗii ci ha'ə, kaa təya alə tə Əntaŋfə, təya ɗa gazhi'waanə ŋga raramənə, mbu'u ka lapaanə nə tii tə ci, taa ŋgahi paa ci dzaɗə da taa rəŋwə agyaamə. ");
INSERT INTO gde_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Daciikii caama mbəɗə, ama guguɗə, ama ndzaanə. Kə ɗii makə sətə bii hara ənji kaala wanyanə goonə oo'i: gooŋga, slikərənaakii naamə. ");
INSERT INTO gde_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","Yoo, makə ɗii ci, slikərənə ŋga Əntaŋfə naamə, madəɓeemə ama hiima oo'i, kə pusha Əntaŋfə da matsahu ɓurə tibisa, taa viiza taa faara ətə tsahutə əndə də ciinəkii agi hiimaakii. ");
INSERT INTO gde_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","Ma ŋga ŋukə, pooshi Əntaŋfə nja ka nə ka ghatə shiinə ŋga ənda. Amma ma ŋga əna, agi banə nə ci ka patənə ŋga ənji taa dama patə, wa təya baanə ka ci. ");
INSERT INTO gde_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","Acii kə kəŋee ci ka uusərə ŋga ɗa gəŋwanə ka *duuniya patə. Də gooŋga nii kəya ɗa dacii əndətə ta'i ci. Kə ɓaarii ci tantanyinəkii ka ənji patə də maɗeenə ka ci agi maməətə ənja.” ");
INSERT INTO gde_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","Makə fii ənji waɓənə ŋga Bulusə agyanə maɗənə agi maməətə ənja, hara ənjə a ŋusə tə ci, hara ənji əsə a ba, “Ka ənyanə niinə ka fa waɓəətsə a maku.” ");
INSERT INTO gde_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","Wata Bulusə a maɗəgi saakii ahadatii. ");
INSERT INTO gde_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","Amma hara ənjə a dzə aaɓiikii, təya vii gooŋga ka Slandana. Ahadatii nə Diyanisiya, əndə ŋga Ariyapaga, da i əndə'i minə ətə ɗii ləmətə Damarisə, da hara ənja. ");
INSERT INTO gde_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","Daba'ə ha'ə, Bulusə a maɗə də Ateena, ca palə aa Koorintiya. ");
INSERT INTO gde_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","Makə mbu'i ci, kə guŋəgərə tii da əndə'i əndə Yahuda ətə ɗii ləməkii Akila. Əndə Puntu nə ci. Mata'avəmə ci makə shi ci aa dəvə aa vəra tii da minaakii Pərisəkila. Kə ma'ya tii də Rooma anə hanyinə ŋga Italiya acii kə bii ŋwaŋwə Kalawudiyu oo'i, *Yahudiinə patə, wa təya maɗəgi asəkə vəranəkii. Ci ɗii gi tii aa Koorintiya. Bulusə a dzə ka nəhəpaanə tə tii. ");
INSERT INTO gde_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","Makə lapaa ci oo'i slənatii rəŋwə, waatoo, təslə kuvə kuvə'unə, wata ca ənəgi aɓitii. ");
INSERT INTO gde_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","Ca dzə də baaba waɓənə ŋga Əntaŋfə asəkə *kuvə də'wa taa ŋgutə uusərə ŋga əpisəkə patə, ca dzə də zhi'wanə də Yahudiinə da Gərikanyinə kaa təya nə'u ŋunyi rəgwa. ");
INSERT INTO gde_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","Makə mbu'ya i Silasə da Timooti daga anə hanyinə ŋga Makiduuniya, Bulusə a bwasee ka slənətə njii kəya ɗa, ca dzə aakəŋwa də waazanə, ca ɓaarii furəŋə ka Yahudiinə oo'i, Yeesu nə *Mataɗəkii ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","Makə ɗii tii ka ci mabizhinə, təya dzə də dzaananə tə ci, ca gəgərəgi bərəbərə ŋga kəjeerənaakii ka ɓaariinə ka tii oo'i, kə shigi ci agi haalatii; əŋki ci, “Ma nyi kamə, pooshi kərənə goonə agyanəki ma'ə. Amma agyanuunə səgoonə. Daga ənshinə aa ha hara slikərənə dzənəki.” ");
INSERT INTO gde_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","Də ha'ə bwasee ci ka tii, ca palə saakii aasii aa ha əndə'i əndə ətə ɗii ləməkii Titusə Yasətu. Əndə paslənə tə Əntaŋfə nə ci, ətə ɗii yaakii ataŋgala *kuvə də'wa. ");
INSERT INTO gde_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","Ma gawə ŋga kuvə də'wa ətə ɗii ləməkii Kərisəpusə, kə vii ci gooŋga da yaakii patə ka Slandana. Ha'ə əsə tə'i hara ənji Koorintiya laŋə, makə fii tii waazanə ŋga Bulusə, kə vii tii gooŋga. Ha'ə təya luu yiɓə bapətisəma. ");
INSERT INTO gde_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","Ma ka əndə'i vəɗa, kə waɓi Əntaŋfə ka Bulusə dagi səniinə, əŋki ci ka ci, “Ga ha ŋgwalə, waazawə ka ənja, ga ha ndzaa kəɗa'ə. ");
INSERT INTO gde_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","Acii kədəhə da hə nə nyi. Aciikii ha'ə, pooshi əndə ca uree ka hə. Laŋə nə ənjaaki asəkə vəraana.” ");
INSERT INTO gde_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","Wata Bulusə a ndzaa davə, ha'ə fəzə rəŋwə da ləgiɗə kuwa. Ca dzə də dzəgunə ka ənji waɓənə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","Amma, makə ɗii Galiya ŋgwaməna agyanə hanyinə ŋga Akaya, Yahudiinə a ləɓə də na, təya kəsətə tə Bulusə, təya kərə tə ci aakəŋwacii gəŋwanə, ");
INSERT INTO gde_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","əŋki tii, “Ma əndəna, agi isəkwanə nə ci tə ənji ka paslənə tə Əntaŋfə ka rəgwatə təŋapaa bariya.” ");
INSERT INTO gde_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","Ma ətsə kədəhə kaa Bulusə a wunəpaa makii kaa ca waɓə, wata Galiya a ləwugi rəgwa, ca ba ka tii, “Unə Yahudiinə, maci əndə'i bwaya uushi pamə ɗii ci, kə njii kya fa tuunə. ");
INSERT INTO gde_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","Amma, makə mabizhinə agyanə waɓənə saakii da ləmənyinə da bariya goonə, unə səgoonə nə tsaamətənə. Ma nyi kamə, paa nyi ka la gəŋwanə ŋga tsarə uushi'iitsa.” ");
INSERT INTO gde_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","Wata ca lyakagi tə tii asəkə kuvə gəŋwanə. ");
INSERT INTO gde_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","Wata tii patə, təya kəsətə tə Sasətinasə, gawə ŋga kuvə də'wa, təya fəslə tə ci akəŋwacii gəŋwanə. Amma, taa gi'u, makulamə aasəkə Galiya. ");
INSERT INTO gde_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","Makə cakə Bulusə baneenə laŋə da ənji Koorintiya, ca ba ka tii a maɗə ci ha'ə. Ca dzə, ca isəgi nəkii asəkə vəranə ŋga Kəŋkəraya ka ɓaariinə oo'i, kə mbu'utəgi ci də aləkawalətə shi ca ɗii. Ma daba'əkii, ca dəmə kumbawalə da i Pərisəkila da Akila, təya palə aagyanə hanyinə ŋga Siriya. ");
INSERT INTO gde_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","Təya kəŋaanə də Afisa zəku'i. Ca dzə aasəkə kuvə də'wa, ca waɓə da Yahudiinə davə, ");
INSERT INTO gde_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","təya kədii tə ci kaa ca tsakə ta'aveenə da tii. Amma kə naanagi ci. ");
INSERT INTO gde_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","Makə bii ci ka tii maɗənaakii, ca ba ka tii, “Ka ənyanə nə nyi aaɓii unə, maa kə luuvə Əntaŋfə.” Wata ca bwasee ka i Pərisəkila da Akila də Afisa, ca dəmə kumbawala, ca palə. ");
INSERT INTO gde_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","Makə mbu'i ci aa Kayisariya, ca dzə aa Urusaliima ka nəhəpaanə tə ənji nə'unə, ca uudəgərə aa Antakiya. ");
INSERT INTO gde_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","Makə banee ci gi'u davə, wata ca maɗə, ca wiigi'itə hanyinə ŋga Galatiya da Firigiya, ca dzə də vii ŋgeerənə ka ənji nə'unə patə. ");
INSERT INTO gde_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","Tə'i əndə'i əndə Yahuda ətə ɗii ləməkii Apoolasə. Kə shi ci aa Afisa. Ma ca, əndə Aləkəsandəriya nə ci. Kə mbee ci ka waɓənə. Kə shii ci malaaɓa ləkaləkatə ka shaŋə əsə. ");
INSERT INTO gde_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","Kə dzəgunətə ənji ka ci rəgwa ŋga Slandanə ŋga'ə. Taa ŋgahi see yiɓə bapətisəma ŋga Yoohana shii ci, amma kə ɗii ci gazhi'waanə ŋga dzəgunətənə ka ənji gəŋə gəŋə agyanə Yeesu. ");
INSERT INTO gde_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","Makə mbu'i ci, ca waaza asəkə kuvə də'wa yadə ŋgwalənə. Makə fii i Pərisəkila da Akila tə ci, təya ŋgərə tə ci, təya tsakə dzəgunətə ka ci rəgwa ŋga Slandanə ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","Apoolasə əsə, kə mwayi ci dzənə aagyanə hanyinə ŋga Akaya. Makə mwayi ci ɗanə ha'ə, ənji nə'uutə də Afisa a tsakə tə ci də naahənə ka ənji nə'uutə də Akaya, kaa təya luu tə ci də mooɗasəka. Makə mbu'i ci aa dəvə, kə cakə ci tə ənjitə ɗii Slandanə ka tii pwapoonə ŋga vii gooŋga, ");
INSERT INTO gde_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","acii kə uuri ci tə Yahudiinə akəŋwacii ənji də waɓənə, ca ɓaarii tantanyinəkii dasəkə malaaɓa ləkaləkatə oo'i, Yeesu nə Mataɗəkii ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","Ma saa'itə Apoolasə də Koorintiya, kə gi Bulusə aa Afisa da giŋwə. Makə mbu'i ci, ca lapaa hara ənji nə'unə davə. ");
INSERT INTO gde_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","Əŋki ci ka tii, “Makə vii unə gooŋga, kə upaa unə Malaaɓa Ma'yanə kwa?” Əŋki tii ka ci, “Pooshi. Mashimə ina fii taa tə'i Malaaɓa Ma'yanə.” ");
INSERT INTO gde_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","Bulusə a ləgwa ka tii, əŋki ci, “Aa, tsarə ŋgutə bapətisəma daa yiɓə ənji koona?” Əŋki tii, “Tsarə ətə ŋga Yoohana.” ");
INSERT INTO gde_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","Ca ba ka tii, “Ma yiɓə bapətisəma ŋga Yoohana, ka ənjitə baanə ka Əntaŋfə putə ŋga 'waslyakəənatii. Amma kə bii Yoohana ka ənji *Isərayiila, see a vii tii gooŋga ka əndətə na uugya ba'ə ka shinə, waatoo Yeesu.” ");
INSERT INTO gde_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","Makə fii tii ha'ə, təya luu yiɓə bapətisəma də ləmə ŋga Yeesu Slandana. ");
INSERT INTO gde_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","Bulusə a kavə ciinəkii aanətii, Malaaɓa Ma'yanə a jima aagyanətii, təya waɓə də məshipətə uuranyinə, təya baaba sətə bii Əntaŋfə ka tii. ");
INSERT INTO gde_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","Kə mbu'i tii bahə pu'u aji bəra'i nə ənjikii. ");
INSERT INTO gde_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","Ləgiɗə makkə ɗii Bulusə ka dzənə aasəkə *kuvə də'wa, ca waɓə yadə ŋgwalənə ka ənja, ca zhi'wa də haŋkalatii ka haala ŋga ŋwaŋuunə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","Amma kə təkuree hara ənji ka vii gooŋga acii ndalənə ŋga ədzəma, təya waɓə bwayakii aashi rəgwa ŋga Slandanə akəŋwacii daɓaala. Makə nee ci ha'ə, ca bwasee ka tii, ca fə'yagi tə ənji nə'unə, ca waɓə ka tii taa ŋgutə uusəra patə asəkə kuvə jaŋganə ŋga əndətə ɗii ləməkii Tirana. ");
INSERT INTO gde_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","Fəzə bəra'i nə tii ka ɗanə ha'ə. Ənji hanyinə ŋga Asiya patə, Yahudiinə da hara slikərənə, kə fii tii waɓənə ŋga Slandana. ");
INSERT INTO gde_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","Kə slənyi Əntaŋfə sə ŋga hurəshishinə ka shaŋə dacii Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","Ha'ə ənjə a ŋgərə kəjeerənə da aləbuta ka taɓətə də shishinəkii, ənjə a kərə ka ənji bwanea, təya mbəɗə. Ginaajiinə əsə, təya shigi ashitii. ");
INSERT INTO gde_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","Tə'i hara *Yahudiinə ətə ca wiigi'i ka vəra ka vəra, kə ɗii tii gazhi'waanə ŋga əsətə ləmə ŋga Yeesu kaa təya mbəɗəpaa də ənjitə da i ginaaji ashitii, təya ba ka ginaaji, “Agi banə nə nyi ka hə də ləmə ŋga Yeesu ətə ci Bulusə a waaza, bwasee ka əndətsa!” ");
INSERT INTO gde_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","Tə'i manjeevənə ŋguyirənəkii məɗəfə ŋga maɗuunə *limanə ŋga Yahudiinə ətə ɗii ləməkii Sikəwa; da i tii ca ɗaaɗa ha'ə. ");
INSERT INTO gde_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","Ma ka əndə'i uusəra, ginaaji a ba ka tii, “Kə shii nyi tə Yeesu, kə shii nyi tə Bulusə əsə. I wu saŋə nuunə noona?” ");
INSERT INTO gde_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","Wata əndə ginaajitə a kulaanə ka tii palee ka ŋgeeriitii patə, ca ɗaaɗavə ka tii uyiginə, ca tsaatsagi kəjeerənə ashitii. Təya gimagi asii gakii, təya huyi. ");
INSERT INTO gde_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","Patənə ŋga ənji də Afisa, kə fii tii sətə slənyi, Yahudiinə da hara slikərənə. Ha'ə kə lagi ədzəmətii, ənjə a ɗuunətə ləmə ŋga Slandanə Yeesu. ");
INSERT INTO gde_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","Laŋə agi ənjitə vii gooŋga əsə shi ka baanə ka Əntaŋfə akəŋwacii ənji patə, təya baabagi bwaya uushi'iitə nji təya ɗaaɗa. ");
INSERT INTO gde_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","Ənji laŋə əsə agi ənji ɗaaɗa sə ŋga hiila kira ləkaləkatənyinatii, təya ətsagi akəŋwacii ənji patə, təya ɓaanatə kwaɓakii, waatoo, *hwaslə dəbu'u tufə pu'unə. ");
INSERT INTO gde_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","Ha'ə cakə waɓənə ŋga Slandanə gərənə aakəŋwə aakəŋwa də ŋgeerənə dagi baawəɗaakii. ");
INSERT INTO gde_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","Ma daba'ə ha'ə, wata Bulusə a ɗa aniya ŋga dzənə aanə hanyinə ŋga Makiduuniya da ŋga Akaya, ca mbu'ugərə aa Urusaliima. Ca ba, “Maɗa kə mbu'i nyi, tyasə ka dzənə nə nyi aa Rooma.” ");
INSERT INTO gde_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","Wata ca sləkee ka ənji tsakənə tə ci bəra'i aa Makiduuniya, waatoo Timooti da Irasəta. Ma ci naakii, kə cakə ci baneenə gi'u davə anə hanyinə ŋga Asiya. ");
INSERT INTO gde_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","Ma ka saa'ikii, kə ma'i maɗuunə haala də Afisa putə ŋga rəgwa ŋga Slandana. ");
INSERT INTO gde_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","Ma dava, tə'i əndə'i əndə ətə ɗii ləməkii Dimitəriya. Ma ca, əndə ɓələnə nə ci, agi ɓələnə nə ci pusha tə kuvə uuləmə ətə ɗii ləməkii *Arətimi. Ma slənətsa, agi upaanə nə tii kwaɓa laŋə da ənji slənaakii. ");
INSERT INTO gde_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","Ma ka əndə'i uusəra, wata ca dzatə də ənji slənaakii da hara ənjitə ca slənə tsarə slənəkii, əŋki ci ka tii, “Kə shii unə, agi slənənə gaamə caama upaa kwaɓa laŋə. ");
INSERT INTO gde_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","Kə nee unə, una fa də liminuunə əsə oo'i, kə zə'wee Bulusətə ka nə ŋga ənji laŋə də banə oo'i: ma əntaŋfənə ətə ci ənjə a ghənə də ciinə, əntaa sə ŋga paslənə nə ci. Əntaa wata ganə də Afisa tanə əsə, amma agyanə hanyinə ŋga Asiya patə cii kəya waɓə ha'ə. ");
INSERT INTO gde_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","Maa kə nyi'u ənji ha'ə makə ətsa, ka saaweenə nə ənji ka slənə gaamə. Əntaa wata ətsə tanə əsə, amma ka ndzaanə nə kuvə ŋga maɗuunə Arətimi ka uushi zaɓə. Ki ka nətə maa, ka əteenə nə ki ka məghərəvənatə. Taa ŋgahi agi paslənə nə ənji tə ki anə hanyinə ŋga Asiya da patənə ŋga duuniya, patə da ha'ə ka bwaseenə nə ənji ka ki.” ");
INSERT INTO gde_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","Makə fii tii ha'ə, kə zhima tə tii a səkətii ka shaŋə, təya ka vurənə, təya ba, “Ma Arətimi ŋga ənji Afisa, maɗuunəkii nə ki ka shaŋə.” ");
INSERT INTO gde_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","Wata vəranə a gwazəgi, təya kəsə tə i Gayusə da Arisətarəkusə. Ənji Makiduuniya nə tii, guvii-wiinyinə ŋga Bulusə nə tii əsə. Təya kərə tə tii də kwasənə aasəkə babara ŋga ɓuurənə. ");
INSERT INTO gde_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","Ma Bulusə, kə mwayi ci dzənə aakəŋwacii daŋkana, amma ənji nə'unə a təŋapaa tə ci. ");
INSERT INTO gde_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","Ha'ə əsə, hara madiigərənə ŋga hanyinə ŋga Asiya, waatoo guviinə ŋga Bulusə, a sləkee ka kədiinə aciikii, ga ca dzə aasəkə babara ŋga ɓuurənə. ");
INSERT INTO gde_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","Ma saa'ikii, daŋkana patə, makəɗəkii nə tii ka shaŋə. Taa wu patə, wazəna. Hara ənjə a ba əndə'i uushi pamə, hara ənji əsə, pamə nə natii. Laŋənatii, mashiimə tii sətə dzatə tii də nə ka putakii. ");
INSERT INTO gde_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","Tə'i əndə'i əndə davə, ɗii ləməkii Aləkəsandəra. Hara ənjə a ba ka ci sətə ɗii. Wata Yahudiinə a kavə tə ci aakəŋwacii ənja. Ca maɗee ka ciinəkii kaa ca ba ka daɓaala dalila ŋga haalatsa. ");
INSERT INTO gde_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","Amma, makə fii tii, əndə Yahuda nə ci, təya maɗee ka uuratii patə, ha'ə ŋga tibisə bəra'i, təya ba, “Ma Arətimi ŋga ənji Afisa, maɗuunəkii nə ki ka shaŋə!” ");
INSERT INTO gde_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","Ma ka muudinə, kə dədəkəpaa əndə naahənə ŋga vəranə tə daŋkana, əŋki ci, “Unə ənji Afisa, wu saŋə nə əndə mashiimə oo'i, vəranə ŋga Afisa ca haɗagi də kuvə ŋga Arətimi maɗuunəkii da malaaɓa faaratə kulyagərə dadagya? ");
INSERT INTO gde_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","Makə pooshi rəgwa ŋga ushapaa uushi'iitsa, see a ndzaa unə kəɗa'ə, goona kwasə. ");
INSERT INTO gde_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","Acii kə kiroonə ənjinə aa hanə. Wiinə mahərəmə tii asəkə malaaɓa kuvə ŋga Arətimi, taa waɓə bwaya uushi'inə aashitə. ");
INSERT INTO gde_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","Maɗa ma Dimitəriya da ənji slənəshinaakii, tə'i tii da kərə gəŋwanə ŋga əndə'i ənda, furəŋə nə kuvə gəŋwanə, watiitsə ənji la gəŋwanə əsə. Wa təya kərə gəŋwanatii. ");
INSERT INTO gde_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","Amma, maa əndə'i uushi pamə cuuna alə, ka haɗatəginə nə ənji aakəŋwa agi mətərəkinə. ");
INSERT INTO gde_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","Acii maŋgwaləkii niinə ka luu gəŋwanə ŋga wazəənə ŋga ənshinə, makə pooshi amə ka mbeenə ka dzəgunətə dalila ŋga wazənəkii.” ");
INSERT INTO gde_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","Makə uugi ci baginə ha'ə, ca ba ka daŋkana, wa təya təəkəgi. ");
INSERT INTO gde_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","Makə dədikə haalata, wata Bulusə a dzatə də ənji nə'unə, ca vii ka tii ŋgeerənə də waɓənə. Daba'ə ha'ə, ca ba ka tii, a maɗə ci kaa ca dzə aanə hanyinə ŋga Makiduuniya. ");
INSERT INTO gde_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","Makə mbu'i ci aa dəvə, ca wiigi'itə hanyinəkii, ca dzə də vii ka ənji nə'unə ŋgeerənə də waɓənə laŋə, ca mbu'u aanə hanyinə ŋga Akaya. ");
INSERT INTO gde_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","Ca ndzaa davə ləgiɗə makkə. Amma, ma ətsə kaa ca dəmə kumbawalə kaa ca dzə aanə hanyinə ŋga Siriya, kə fii ci oo'i, kə mwayi *Yahudiinə ɓələnə tə ci. Wata ca ɗa aniya ŋga ənəgərənə saakii da Makiduuniya. ");
INSERT INTO gde_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","I Soopatira, əndə Biriya, uuzənə ŋga Pirusa a kəree ka ci, da Arisətarəkusə da Səkundusa, ənji Teesaloonika, da Gayusə, əndə Dyarəba, da Timooti da ənji Asiya, waatoo Tikikusə da Tərafima. ");
INSERT INTO gde_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","Tii 'watəgi palənə keenə aa Tərawasə, təya gəree keenə davə. ");
INSERT INTO gde_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","Ma inə neenə, daba'a *kumənə ŋga adə buroodi yadə burəŋanə ma'iinə, ina maɗə də Filipi, ina dzə ka dəmə kumbawala, ina lapaa tə tii də Tərawasə anə baanə tufə, ina ɗapaa luuma rəŋwə davə. ");
INSERT INTO gde_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","Ma uusəra asavee kədəwanə, kə dzatiinə də nə ka zəmə əndzanə ŋga Slandana, kə waɓi Bulusə ka ənji nə'unə kura'ə ahada vəɗa, acii kə mwayi ci maɗənə pukyatə hakii. ");
INSERT INTO gde_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","Ma kuvətə dzatiinə də nə davə, kuvə anə əndə'i nə ci. Tə'i garəkuwanyinə laŋə davə a kumu. ");
INSERT INTO gde_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","Tə'i əndə'i uundzə dagwa ca zəkutə. Ma ləməkii, Iwutika. Anə mapacakinə ŋga baŋgwa ndzaa ci naakii. Bulusə a dzə aakəŋwa də magəərə waɓənaakii. Makə mbee ŋunyinə ka dagwata, ca kulagərə aa panə daga agyanə makkənə ŋga kuvətə anə əndə'i. Mantəkii shi ənji ka ŋgərənə tə ci. ");
INSERT INTO gde_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","Amma Bulusə a jiməgərə aa panə, ca gwaŋgaanə tupə anəkii, əŋki ci, “Goona tuu, da i əpinə nə ci.” ");
INSERT INTO gde_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","Makə ənyi Bulusə ka ndərəginə aadəgyə, ca ɓaatsəpaa buroodi, təya adə. Ca ta'avə ka waɓənə da tii, ha'ə puki ha. Wata ca maɗə, ca palə. ");
INSERT INTO gde_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","Təya dzə satii da uundzə dagwatə vyarəŋə. Kə ɗii tii mooɗasəkə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","Ma inə, kə pyaliinə aasəkə kumbawalə, ina palə aa Asoosə, keena dzə ka ŋgərəənənə tə Bulusə davə, acii kə bii ci oo'i, də səɗə dzənəkii aa dəvə. ");
INSERT INTO gde_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","Makə lii ci tiinə də Asoosə, ina ŋgərə tə ci aasəkə kumbawalə, ina dzə aa Mitilyanə. ");
INSERT INTO gde_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","Ina maɗə davə də kumbawalə, ina ələgi pukənə ŋga ha ataŋgala hanyinə ŋga Kiyoosə ətə ahada ma'inə. Ma ka bəra'inə ŋga uusərə əsə, ina mbu'u aa Samusa, ina palə uurə, ina mbu'u ka makkənə ŋga uusərə ha'ə aa Milita. ");
INSERT INTO gde_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","Gəŋə kəŋee Bulusə aa Milita yadə dzənə da Afisa acii ga ca ta'avə anə hanyinə ŋga Asiya. Ma ɗii ci ha'ə, kwasiikii acii ŋga'ə ka ci nə mbu'unə aa Urusaliima taabu'u mbu'yanə kumənə ŋga *Peentakoosa, maa jamə. ");
INSERT INTO gde_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","Daga də Milita sləkee Bulusə aa Afisa ka ənjə a 'waa'watə ka ci matakəŋwanyinə ŋga Ikəliisiya. ");
INSERT INTO gde_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","Makə shi tii aaɓiikii, əŋki ci ka tii, “Unə də noonə na, kə shii unə makə sətə ndzaa nyi ahadoonə, 'watəginə ka saa'yatə shi nyi aagyanə hanyinə ŋga Asiya ha'ə mbu'ya ka ənshinə. ");
INSERT INTO gde_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","Agi slənənə nə nyi ka Slandana. Paa nyi sha ɗuunətə naaki na. Kə slənyii ka ci da kiinə agiki da bwaneatə sii nyi kama kama acii Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","Kə shii unə, agi waazaaki patə, pooshi nyi umbee koonə ka sətə ca tsakə tuunə taa rəŋwə. Amma kə jigunyii koonə akəŋwacii ənji i ka yi ka ya. ");
INSERT INTO gde_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","Kə bii nyi ka Yahudiinə da hara slikərənə patə kaa təya baa ka Əntaŋfə, təya vii gooŋga ka Slandanə Yeesu. ");
INSERT INTO gde_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","“Ma əndzə'i, wanyinə ka dzənə aa Urusaliima. Malaaɓa Ma'yanə ca ba ka nyi dzənə. Mashiimə nyi sətə na ɗa tə nyi davə. ");
INSERT INTO gde_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","Uushi rəŋwə shii nyi ci Malaaɓa Ma'yanə a ba ka nyi taa ka ŋgutə vəranə gi nyi patə; waatoo agi banə nə ci ka nyi oo'i, agi gəranə nə mahyakahyaka'ə da ŋgəra'wə tə nyi. ");
INSERT INTO gde_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","Amma, maŋgərəmə nyi əpinaaki ka uushi. Taɗa kə əŋki nyi, taɗa mantəmə nyi patə, mbərə mbərə ka nyi, tə maa kə uudəpaa nyi slənənə liwə nyi acii Slandanə Yeesu, nya baaba Ŋunyi Habara ŋga pwapoonə ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","“Wiinə kə shii nyi, ma unə ənə wiigi'i nyi ahadoonə, nya waaza koonə agyanə *ŋwaŋuunə ŋga Əntaŋfə, pooshi unə na nee ka nyi ma'ə patənə goonə. ");
INSERT INTO gde_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","Acii ha'ə cii kya ba koonə ənshinə, pooshi kərənə ŋga patənə goonə agyanəki ma'ə. ");
INSERT INTO gde_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","Maneemə nyi ka ŋgwa'əŋgwa'ənə ŋga ba koonə patənə ŋga hiima ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","Nəhəmə noonə nə da gwamətə kavə Malaaɓa Ma'yanə tuunə ka magəriinəkii, una ndzaa ka magəriinə ŋga Ikəliisiya ŋga Slandanə ətə upaa ci də idənaakii. ");
INSERT INTO gde_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","Acii kə shii nyi, ma daba'a palənaaki, kadə nə bwaya furətsoofanyinə a dəməgərə aahadoonə, paa tii na bwasee ka gwaməkii. ");
INSERT INTO gde_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","Taa ahadoonə əsa, kadə na shigi ətə na ɗa gazhi'waanə ŋga zə'wee ka haŋkala ŋga ənji nə'unə kaa təya nə'u tə tii. ");
INSERT INTO gde_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","Acii ha'ə, ndzaamə matasəkakii, una buurətə oo'i, fəzə makkə ɗii nyi da kiinə agiki ka waɓənə ka taa wu ahadoonə vəɗə da uusəra. ");
INSERT INTO gde_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","“Ma ənə ɗiya, kə ba'avə nyi tuunə aacii Slandanə da waɓənə ŋga pwapoonaakii, kaa ca ndzaa kədəhə doonə. Waɓəətsə nəndə da baawəɗa ŋga vii koonə ŋgeerənə, ca vii koonə barəkaatə nə ənjaakii a upaa patə. ");
INSERT INTO gde_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","34","Unə də noonə nə, kə shii unə oo'i, pooshi nyi mwayi kwaɓa ŋga taa wu, taa kəjeerənə ŋga ənda. Ciinəkinə slənyi ka nyi sətə cii kya ki'i də haajaaki da ŋga ənjinə ndzaashiinə. ");
INSERT INTO gde_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","Kə ɓaarii nyi koonə taa ka ŋgutə rəgwa patə oo'i, də tsarə slənətsə ha'ə tsakənuunə tə ənji matə ŋgeerənə, una dzə də buurətə waɓənə ŋga Slandanə Yeesu ətə bii ci: ‘Gəɗə viinə də barəkaanə acii luunə.’ ” ");
INSERT INTO gde_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","Makə uugi Bulusə waɓənə ha'ə, ca gərə'waanə, ca ɗa də'wa da tii patə. ");
INSERT INTO gde_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","Təya jabətashi, təya ba, “Wa Əntaŋfə a kərə tə hə jamə.” Tii patə, təya tuu. ");
INSERT INTO gde_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","Ma sətə palee də ɓəzee ka səkətii, ətə fii tii bii ci, paa tii ka ənənə ka neenə ka ci ma'ə. Wata təya kəree ka ci aasəkə kumbawala. ");
INSERT INTO gde_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","Makə jabətii inə, ina təkəgi, ina dəmə kumbawala, ina kəŋee gəŋə, ina mbu'u aa Koosə. Pukətə hakii, ina maɗə də Koosə, ina mbu'u aa Roodəsa. Ina maɗə də Roodəsa əsə, ina mbu'u aa Patara. ");
INSERT INTO gde_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","Davə lapaa inə kumbawalə ŋga dzəginə aanə hanyinə ŋga Finikiya, ina dəmə, ina palə. ");
INSERT INTO gde_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","Makə mbu'iinə kədəhə da hanyinə ŋga Kipərusə ətə ahada ma'inə, ina bwasee aa madzəna, ina palə aanə hanyinə ŋga Siriya, ina jimagərə də Tiira, acii davə nə kumbawalə ka jimapaa də uushi'inə. ");
INSERT INTO gde_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","Ina alətə hatə ɗii ənji nə'unə davə, ina baanə məɗəfə gatii. Təya ba ka Bulusə də baawəɗa ŋga Malaaɓa Ma'yanə, ga ca dzə aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","Amma, makə mbu'ya saa'i ŋga maɗənə geenə, ina maɗə, ina palə. Təya kəree keenə tii da makinatii da manjeevənatii patə. Makə mbu'iinə aa ba'a vəranə aama uunəva, ina gərə'waanə anə mandzənə, ina ɗa də'wa, ");
INSERT INTO gde_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ina jabətashi. Wata ina dəmə kumbawala. Tii əsə, təya ənə satii aasii. ");
INSERT INTO gde_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","Makə uugiinə wayanə daga də Tiira, ina mbu'u aa Putəlimayisa, ina nəhəpaa ənji nə'unə, ina baa rəŋwə da tii. ");
INSERT INTO gde_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","Pukətə hakii, ina maɗə, ina palə aa Kayisariya. Makə mbu'iinə, ina dəməgərə aasii aa ha Filibusə, əndə waazanə. Rəŋwə nə ci agi ənji məɗəfə ətə shi ənjə a ta'i də Urusaliima. Ina jima gakii asii. ");
INSERT INTO gde_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","Ma əndətsa, tə'i ci da uuji rəminə ənfwaɗə, ətə ma'ə maŋgərəmə ŋguyirənə. Agi ɗanə nə tii anabaakwaanə. ");
INSERT INTO gde_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","Makə banee inə davə gi'u, əndə'i *anabi ətə ɗii ləməkii Agabusə a shi daga də Yahudiya. ");
INSERT INTO gde_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","Ca shi aaɓii inə, ca ŋgərətə gyara ŋga ŋwə ŋga Bulusə, ca aanəgi də səɗəkii da ciinəkii saakii də gyarata, ca ba, “Wiinə sətə ci Malaaɓa Ma'yanə a ba: ‘Ha'ə nə Yahudiinə də Urusaliima a anə tə slanda gyarana, təya vii tə ci acii ənjitə mashiimə tə Əntaŋfə.’ ” ");
INSERT INTO gde_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","Makə fii inə ha'ə da ənjitə davə patə, ina kədii acii Bulusə, ga ca dzə aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","Amma wata Bulusə a jikəvə, əŋki ci, “Mi saŋə cuuna ŋgwalee ka nya, una tuwa? Acii ma nya, matasəkakii nə nyi, əntaa wata ka pa'ənə tə nyi tanə, amma ka əntənə də Urusaliima putə ŋga ləmə ŋga Slandanə Yeesu.” ");
INSERT INTO gde_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","Makə təkuree inə ka təŋapaa tə ci, ina ndzaa kəɗa'ə, ina bwasee ka ci, ina ba, “Wa Slandanə a slənə sətə mwayi ci.” ");
INSERT INTO gde_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","Daba'ə baanə gi'u, ina tasəka, ina maɗə, ina palə aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","Hara ənji nə'unə də Kayisariya a palə deenə, təya kərə tiinə aasii aa ha əndə'i əndə nə'unə ŋga ŋukə, əndə Kipərusə ətə ɗii ləməkii Manasanə. Gakii asii jimeenə. ");
INSERT INTO gde_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","Mbu'unə geenə aa Urusaliima, kə liwə ənji nə'unə tiinə də mooɗasəka. ");
INSERT INTO gde_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","Pukətə hakii, kə giinə da i Bulusə aa ha Yakubu. Davə nə matakəŋwanyinə ŋga Ikəliisiya patə əsə. ");
INSERT INTO gde_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","Bulusə a nəhəpaa tə tii. Daba'əkii ha'ə, ca 'watəgi banə ka tii də rəŋwə rəŋwə tə sətə ɗii Əntaŋfə ahada hara slikərənə putə ŋga slənaakii. ");
INSERT INTO gde_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","Makə fii tii sətə bii Bulusə, təya ɗuunətə tə Əntaŋfə, təya ba ka Bulusə, “Kə nee hə ɗii ndzəkəŋunə, dəbu'unyinə ŋga ənji agi Yahudiinə vii gooŋga ka Yeesu. Tii patə əsə, ənji nə'utə *bariya nə tii. ");
INSERT INTO gde_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","Kə bii ənji ka tii agyanəku oo'i, kə jigunyi hə ka Yahudiitə ahada hara slikərənə, wa təya bwasee ka bariya ŋga Muusa, ga təya *ryaminya manjeevənatii taa nə'u alə'aadanyinatii. ");
INSERT INTO gde_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","Iitə nə ɗanəna? Acii ndilə ndilə ka shiinə nə tii oo'i, kə shi hə. ");
INSERT INTO gde_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","Acii ha'ə, ma ɗanəku, ɗawə sətə ciina ba ka hə. Tə'i inə da ənji ənfwaɗə ətə ɗii aləkawalə akəŋwacii Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","Duu da ənjitsa, ha laaɓagi naaku nə da tii akəŋwacii Əntaŋfə, ha ki'i ka tii haajatii. Ma daba'əkii, təya isəgi nətii. Də ha'ə shiinə ənji patə oo'i, taa ŋgutə uushi bii ənji ka tii agyanəku, pooshi gooŋga agikii. Də ha'ə shiinətii agi nə'utə bariya nə hə. ");
INSERT INTO gde_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","Ma hara slikərəətə vii gooŋga kamə, kə nyaahiinə ka tii ləkaləkatə oo'i, ga təya adə zəmətə ɗii ənji ka uuləma, ga təya adə idəna, ga təya tsəɓə luutə malamə ənji uurakii, ga təya aləhiinə.” ");
INSERT INTO gde_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","Wata Bulusə a ŋgərə tə ənjitə ənfwaɗə. Pukətə hakii, ca laaɓagi naakii nə da tii, ca dzə aasəkə yi ŋga Əntaŋfə kaa ca ba ka *limanə uusərə ŋga uudəpaa laaɓanatii, waatoo uusərə ŋga vii satakatii patə. ");
INSERT INTO gde_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","Makə uugi uusərakii ɗanə kədəhə, waatoo məɗəfənə ŋga uusəra, Yahudiinə ŋga hanyinə ŋga Asiya a nee ka Bulusə asəkə yi ŋga Əntaŋfə. Wata təya tsəvutə tə daŋkana patə, təya kəsətə tə ci. ");
INSERT INTO gde_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","Təya ka vurənə, təya ba, “Ənji Isərayiila, shoomə ka tsakənə tiina! Waanə əndənə ca wiigi'i taa dama patə ka dzəgunənə ka ənji kaa təya bərapaa tə ənji gaamə da bariya ŋga Muusa da yi ŋga Əntaŋfə. Ha'ə maa, waanə kə kira ci hara slikərənə aasəkə yi ŋga Əntaŋfə, ca ajijinətə malaaɓa hana.” ");
INSERT INTO gde_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","Ma bii tii ha'ə, acii kə nee tii ka Tərafima, əndə Afisa tii da Bulusə asəkə vəranə. Ma nə tii ka nəhənə, kə kirə Bulusə tə ci aasəkə yi ŋga Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","Wata vəranəkii a gwazəgi patə, ənjə a dzaanə də nə ka Bulusə, təya kəsətə tə ci, təya əlyagi tə ci asəkə yi ŋga Əntaŋfə. Pii ənjə a pa'əgi makuvənyinə. ");
INSERT INTO gde_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","Təya moo ɓələginə tə ci. Asee, kə mbu'i haalakii aa ha matakəŋwanə ŋga soojiinə ŋga Rooma ətə də Urusaliima oo'i, magwazəkii nə vəranə ŋga Urusaliima patə. ");
INSERT INTO gde_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","Makə fii ci ha'ə, pii ca fəɗə soojiinə da gayinatii, təya huyi aaɓii daŋkana. Makə nee ənji ka matakəŋwanə ŋga soojiinə da soojiinə, təya bwasee ka fəslənə tə Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","Wata matakəŋwanə ŋga soojiinə a shi, ca kəsə tə Bulusə, ca ba ka soojiinə a anəgi tə ci də mahyakahyaka'ə bəra'i, ca ləgwa ka daŋkana, taa wu nə Bulusə da sətə ɓəzee ci. ");
INSERT INTO gde_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","Hara ənji agi daŋkana, təya ba əndə'i uushi pamə. Hara ənji əsə, pamə nə sətə ci təya ba. Makə ma'upaamə matakəŋwanə ŋga soojiinə ŋunyi dalila acii wazənatii, ca ba ka soojiinə a kərə tə Bulusə aasii aa hatii. ");
INSERT INTO gde_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","Makə mbu'i Bulusə ka məgərəfinə ŋga ndərəginə aa hatii aasii, see də makə kirə soojiinə tə ci acii nyaaɗanə ŋga daŋkana. ");
INSERT INTO gde_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","Daŋkana patə a dzə də nə'unə tə tii, təya dzə də banə, “Wa ənjə a ɓələgi tə ci!” ");
INSERT INTO gde_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","Ma kədəhə ka ənjə a dəməgərə də Bulusə aasii aa ha soojiinə, ca ba ka matakəŋwanə ŋga soojiinə, “Ka upaanə nə nyi waɓənə da hə gi'u kwa?” Matakəŋwanə ŋga soojiinə a ba ka ci, “Ka mbeenə nə hə ka uura Gərikə kuna? ");
INSERT INTO gde_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","Asee, əntaa hə kunə nə əndə Misəratə jarəlagi kwakwatə kaa ca maɗee ka haŋkala ŋga ənja? Ha'ə ca kərə maɓələ ənji dəbu'u ənfwaɗə aagi bilina?” ");
INSERT INTO gde_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","Əŋki Bulusə ka ci, “Əndə Yahuda nə nyi, poonə də Tarəsi anə hanyinə ŋga Silikiya, uuzətə mashii vəraatsə nə nyi. Kə kədii nyi aciiku, kapaa ka nyi rəgwa kaa nya waɓə ka ənja.” ");
INSERT INTO gde_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","Makə kapaa ci ka ci rəgwa, Bulusə a kəŋaanə ka dzakənə, ca maɗee ka ciinəkii kaa ənjə a ndzaa kəɗa'ə. Makə ndzaa tii shikə shikə, ca waɓə ka tii də uura *Ibəraaniya, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“Ndzəkəŋushi'inə da dəsənəki, fatəmə kaa nya pərəgi naaki na akəŋwacii unə.” ");
INSERT INTO gde_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","Makə fii tii waɓi ci ka tii də uuratii, waatoo də uura Ibəraaniya, təya tsakə ndzaanə kəɗa'ə. Ca tsakə banə ka tii, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“Ma nyi, əndə Yahuda nə nyi, poonə də Tarəsi anə hanyinə ŋga Silikiya, amma asəkə vəraanə girə nyi. Gamaliyalə dzəgunətə tə nyi ndilə ndilə makə sətə bii bariya ŋga dzədzəshi'inaamə, nya nə'u tə Əntaŋfə də ŋgeerənə, makə ənə cuuna nə'u ənshinə. ");
INSERT INTO gde_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","Kə ciɓee nyi ka ənji nə'u rəgwa ŋga Yeesu, nya ɓəələ tə tii. Nya aanəgi hara ənja, ŋguyirənə da makinə, nya kagərə tə tii aa furəshina. ");
INSERT INTO gde_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","Ka mbeenə nə gawə ŋga limanyinə da *mətərəkinə ŋga gayinə ka seedanə, acii kə liwə nyi ləkaləkatə aciitii kaa nya kərə ka ndzəkəŋushi'inaamə Yahudiinə aa Damasəkusə, waatoo ləkaləkatə ŋga dzənə ka kaashanə də ənji nə'uutə davə. Nya maɗə, nya palə ka kaashanə tə tii kaa nya kira aa Urusaliima ma'aanəkii, ənjə a shi ka ciɓeenə ka tii.” ");
INSERT INTO gde_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“Ma nya dzə də palənə ətsə kədəhə kaa nya mbu'u aa Damasəkusə, uusərə ahadana, wata pii ɓərənə a papi'ya dadagyə, ca guŋutə də nyi dəgəji'u. ");
INSERT INTO gde_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","Wata nya kulagi aa panə, nya fa əndə'i uura, ca ba ka nyi: ‘Sawulə, Sawulə, mi saŋə cii kwa ciɓə də nyi ha'a?’ ");
INSERT INTO gde_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","Nyi əsə, nya muu, əŋki nyi ka ci: ‘'Ya'ə Slandana, hə wu saŋa?’ Əŋki ci ka nyi: ‘Nyi nə Yeesu əndə Nazaratu ətə cii kwa ciɓə də ci.’ ");
INSERT INTO gde_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","Yoo, ma ənjitə aɓiiki, kə nee tii ka ɓərənə, amma mafamə tii uura ŋga əndətə waɓi da nyi. ");
INSERT INTO gde_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","Nya ləgwa: ‘'Ya'ə Slandana, mi saŋə ɗanəkya?’ Slandanə a ba ka nyi: ‘Maɗuu, dzəgərə aasəkə vəranə ŋga Damasəkusə. Davə nə ənjə a ba ka hə sətə mwayi Əntaŋfə kaa ha ɗa patə.’ ");
INSERT INTO gde_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","Makə təkuree nyi ka neenə acii ɓərəəta, ka ciinə kəshi ənjitə giinə da tii tə nyi, dəŋə aa Damasəkusə. ");
INSERT INTO gde_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“Ma dava, tə'i əndə'i əndə ətə ɗii ləməkii Ananiya, əndə gərə'unə ka Əntaŋfə makə sətə bii *bariya. Agi dəlanə nə Yahudiinə ŋga vəranəkii patə də ci. ");
INSERT INTO gde_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","Kə shi ci, ca kəŋaanə aɓiiki, əŋki ci: ‘Ndzəkəŋunə Sawulə, waahanə ka ənənə ka neenə.’ Agi saa'yakii ŋunyi ginəki, nya nee ka ci. ");
INSERT INTO gde_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","Əŋki ci ka nyi: ‘Kə ta'i Əntaŋfə ŋga dzədzəshi'inaamə tə hə kaa ha shii moonaakii, ha nee ka Əndə Gooŋga a rəgwa, ha fa waɓənə damakii, ");
INSERT INTO gde_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","kaa ha ndzaa ka seedawaakii ka ənji patə agyanə sətə nee hə da sətə fii hə.’ ");
INSERT INTO gde_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","Əŋki ci ka nyi: ‘Ya əna, mi cii kwa gəra? Ma ɗanəkwa, maɗətə kaa ənjə a yiɓə ka hə bapətisəma, ha ɗa də'wa ka Slandana kaa ha upaa tifyaginə ŋga 'waslyakəənaaku.’ ” ");
INSERT INTO gde_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","“Ma daba'əkii, kə ənyii aa Urusaliima, nya ɗa də'wa asəkə *yi ŋga Əntaŋfə, kə ɗii ka nyi makə səniinə, ");
INSERT INTO gde_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","nya nee ka Yeesu, ca ba ka nyi: ‘Maɗətə pii pii, ha shigi asəkə vəranə ŋga Urusaliima. Acii paa tii na luuvə seedanaaku tə nyi ka tii.’ ");
INSERT INTO gde_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","Əŋki nyi: ‘Slandana, tii də natii nə maa, kə shii tii oo'i, taa ka ŋgutə *kuvə də'wa kə kəəshi nyi i fəslənə tə ənjitə vii gooŋga ka hə. ");
INSERT INTO gde_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","Ma saa'yatə ɓələgi ənji tə seedawaaku Sətəfanu, nyi davə kəŋə əsə. Kə luuvə nyi, nya nəhə kəjeerənyinə ŋga ənjitə ɓələgi tə ci.’ ");
INSERT INTO gde_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","Amma əŋki Slandanə ka nyi: ‘Maɗuu, duu, kaa nya sləkee ka hə dzaɗə aa ha hara slikərənə.’ ” ");
INSERT INTO gde_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","Ma daŋkana a fa tə Bulusə, ha'ə mbu'ya ka waɓəətsə waɓi ci agyanə hara slikərənə, wata təya kaala vurənə, təya ba, “Wa ənjə a ɓələgi tə ci, wa ənjə a ŋgərəgi tsarə ŋga əndətsə asəkə duuniya. Madəɓeemə ca ndzaanə da i əpinə!” ");
INSERT INTO gde_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","Ma təya dzə də ka vurənə, təya dzə də gəgərə kəjeerənatii, təya mbuɗə bərəbərə aadəgyə. ");
INSERT INTO gde_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","Matakəŋwanə ŋga soojiinə a ba ka soojiinə a kərə tə Bulusə aasii aa hatii, ca ba, “Wa ənjə a fəslə tə ci”, kaa ənjə a shii taa putə ŋga mi ci təya kaala vurənə agyanəkii. ");
INSERT INTO gde_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","Makə anəgi ənji tə Bulusə də zə'wa, ca ba ka soojatə kəŋə davə: “Kə dəɓee ha fəslə əndətə da dimwaanə ŋga Rooma ha'ə yadə la gəŋwanə kwa?” ");
INSERT INTO gde_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","Makə fii soojatə ha'ə, ca dzə ka banə ka matakəŋwanatii oo'i, “Mi cii kwa ɗa ha'a? Acii ma əndətsa, əndə Rooma nə ci.” ");
INSERT INTO gde_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","Wata matakəŋwanə ŋga soojiinə a shi ka ləgwanə ka Bulusə, əŋki ci: “Bawə ka nyi, əndə Rooma nə hə nii?” Əŋki Bulusə, “Awa, əndə Rooma nə nyi.” ");
INSERT INTO gde_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","Matakəŋwanə ŋga soojiitə a ba ka ci, “Də kwaɓa laŋə upaa nyi ndzaanə ka əndə Rooma.” Əŋki Bulusə ka ci, “Ma nyi, də poonə tə nyi upaa nyi naaki.” ");
INSERT INTO gde_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","Wata ənjitə kavə ənji ka fəslənə tə Bulusə a bwasee ka ci pii. Matakəŋwanə ŋga soojiinə a ŋgwaləgi əsə makə paaratəgi ci oo'i, ma Bulusə, əndə Rooma nə ci. Waanə kə anəgi ci tə ci boo. ");
INSERT INTO gde_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","Pukənə ŋga ha əsə, makə mwayi matakəŋwanə ŋga soojiinə shii gooŋga ŋga sətə wulii Yahudiinə tə Bulusə, wata ca pərəpaa tə ci, ca ba ka ənji a 'wa tə madiigərənə ŋga limanyinə da patənə ŋga *mətərəkinə ŋga Yahudiinə, kaa təya dza də na. Ca kira tə Bulusə, ca kəŋee ka ci akəŋwaciitii. ");
INSERT INTO gde_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","Wata Bulusə a maɗee ka ginəkii ka tsaamənə tə mətərəkinə, əŋki ci: “Ndzəkəŋushi'ina, kə gərə'u nyi ka Əntaŋfə də ədzəmə rəŋwə 'watəginə daga ŋukə ha'ə mbu'ya ka ənshinə.” ");
INSERT INTO gde_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","Wata gawə ŋga limanyinə, waatoo Ananiya a ba ka ənjitə kədəhə aɓii Bulusə kaa təya dəgə tə ci də meeciinə a makii. ");
INSERT INTO gde_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","Əŋki Bulusə ka ci, “Əntaŋfə na dəgə tə hə ha'ə naaku əsə, hə bwaya əndəna. Asee, dasə nə hə ka la ka nyi gəŋwanə makə sətə bii *bariya əna, amma wahənə ka taŋəgi bariyakii də banə ka ənjə a dəgə tə nyi.” ");
INSERT INTO gde_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","Wata ənjitə kədəhə aɓiikii a ba ka ci, “Gawə *limanə ŋga Əntaŋfə dzaanii hə see?” ");
INSERT INTO gde_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","Əŋki Bulusə ka tii, “Mashiimə nyi ɗii, ndzəkəŋushi'inə, taa gawə ŋga limanə nə ci. Acii kə bii waɓənə ŋga Əntaŋfə oo'i, ga ha waɓə bwaya uushi agyanə gawə goonə.” ");
INSERT INTO gde_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","Makə ɗii ci kə shii Bulusə oo'i, ma əndə'i kurəga, *Sadukiinə nə tii, əndə'i əsə, *Farisanyinə nə tii, wata ca maɗee ka uurakii akəŋwacii mətərəkinə, əŋki ci, “Ndzəkəŋushi'inəkya, ma nyi, Farisa nə nyi, uuzənə ŋga əndə Farisa əsə. Acii putə ŋga kanətə kii nyi də gooŋga oo'i, ka maɗənə nə maməətə ənji da i əpinə, ci ɗii nyi kəŋə akəŋwacii gəŋwanə.” ");
INSERT INTO gde_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","Uudə baginaakii ha'ə, wata mabizhinə a maɗəgi ahada Farisanyinə da Sadukiinə, ha'ə dzadənəkii a təkəgi bəra'i. ");
INSERT INTO gde_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","Taa sha ɗii, tə'i mabizhinə ahadatii, acii kə bii Sadukiinə, pooshi maɗənə ŋga maməətə ənja, pooshi malaa'ika taa ma'yanə. Əŋki Farisanyinə natii, tə'i uushi'iitsə patə. ");
INSERT INTO gde_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","Wata bwaya mabizhinə a maɗəgi ahadatii. Hara maliminə ŋga kurəgə ŋga Farisanyinə a maɗətə kəŋə, əŋki tii, “Maneemiinə ka bwaya uushi ashi əndətsa. Yaci ma'yanə taa malaa'ika waɓi ka ca?” ");
INSERT INTO gde_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","Makə gwazəgi haalakii, kə ŋgwali matakəŋwanə ŋga soojiinə naakii acii ga təya pwaatəgi tə Bulusə. Ca ba ka soojiinaakii, wa təya dzə ka ŋgiraginə tə ci də ŋgeerənə ahadatii, təya kərə tə ci aasii aa hatii. ");
INSERT INTO gde_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","Vəɗəkii, Slandanə a kəŋaanə aɓii Bulusə, əŋki ci ka ci, “Ga ha ŋgwalə. Makə sətə seedii hə tə nyi ganə də Urusaliima, tyasə ha'ə nii kwa seeda tə nyi də Rooma əsə.” ");
INSERT INTO gde_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","Pukənə ŋga ha, *Yahudiinə a anə uura, təya jiɗə oo'i, paa təya adə zəma, paa təya sa taa mi, see maa kə ɓələgi tii tə Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","Kə pitəgi tii tə ənfwaɗə pu'unə nə ənjitə anyi uuratsa. ");
INSERT INTO gde_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","Wata təya dzə aaɓii madiigərənə ŋga limanyinə da gayiinə, əŋki tii, “Kə ji'iinə bwaya jiɗa, ina anətə uureenə oo'i, pa ina adə zəma da sa taa mi, see maa ɓələgiinə tə Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","Acii ha'ə, ma unə da mətərəkinə, sləkeemə ka ənji ka kədiinə acii matakəŋwanə ŋga soojiinə kaa ənjə a kira tə Bulusə koonə, makə koona tsakə ləgwanə amakii tə sətə ɗii ŋga'ə. Ma inə əsə, matasəkakii niinə keena ɓələgi tə ci taabu'u mbu'yanaakii aaɓii unə.” ");
INSERT INTO gde_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","Asee, kə fii uuzənə ŋga cikəŋuci Bulusə sətə anyi tii, ca dzə, ca dəməgərə aasii aa ha soojiinə, ca bagi ka Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","Bulusə a 'wa tə əndə'i sooja, əŋki ci ka ci, “Kəruu tə uundzə dagwatsə aaɓii matakəŋwanə ŋga soojiinə. Tə'i uushi cii kəya ba ka ci.” ");
INSERT INTO gde_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","Soojatə a ŋgərə tə ci, ca kərə aaɓii matakəŋwanatii, əŋki ci: “Bulusə ətə mapa'əkii 'wii tə nyi, ca ba ka nyi, kaa nya kira tə uundzə dagwanə aaɓiiku. Mbu'u tə'i uushi cii kəya ba ka hə.” ");
INSERT INTO gde_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","Matakəŋwanə ŋga soojiinə a kəsə tə ci ka ciinə, təya dzəgi aataŋgala, ca ləgwa ka ci, “Mi dee cii kwa moo banə ka nya?” ");
INSERT INTO gde_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","Əŋki ci ka ci, “Kə anəgi Yahudiinə uura kaa təya sləkee aaɓiiku kaa ha kərə ka mətərəkinə tə Bulusə doorə, makə kaa təya tsakə ləgwanə tə sətə ɗii ŋga'ə. ");
INSERT INTO gde_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","Amma ga ha luuvə ka tii, acii kə palee tii ka ənfwaɗə pu'unə ətə anyi uura, təya jiɗə oo'i, pa təya zəmə, pa təya sa taa mi əsə, see maa ɓələgi tii tə ci. Matasəkakii nə tii ka gəra kərənaaku tə ci.” ");
INSERT INTO gde_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","Wata matakəŋwanə ŋga soojiinə a ba ka uundzə dagwata, “Ga ha ba taa ka wu oo'i, kə bii hə ka nyi waɓəətsa.” Ca ba ka ci, wa ca palə saakii. ");
INSERT INTO gde_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","Wata matakəŋwanə ŋga soojiinə a 'wa gayi soojiinə bəra'i, əŋki ci ka tii, “Dəmə ka tasəka soojiinə gya'ə bəra'i, da ənji təhinə məɗəfə pu'unə da ənji uudəminə gya'ə bəra'i, kaa təya dzə aa Kayisariya də tibisə əliŋə ənshinə davəɗə.” ");
INSERT INTO gde_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","Ca ba ka tii əsə, wa təya tasəka ka Bulusə naakii sə ŋga dzəginə, təya kərəgi tə ci də ŋga'ə ka Filikusə ŋgwaməna. ");
INSERT INTO gde_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","Ca naahə ləkaləkatə ka ŋgwaməna, əŋki ci: ");
INSERT INTO gde_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“Wiinə ləkaləkatə ca dzə ka Filikusə gawə ŋgwaməna, daciiki Kəlawudiyasə Lisiya. Kə nəhəpaa nyi tə hə. ");
INSERT INTO gde_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","Daba'ə nəhəpaanə, ma əndətsə sləkee nyi ka hə, kə kəsətə Yahudiinə tə ci. Gi'u ha'ə mbəɗaanə kaa təya ɓələgi tə ci. Makə fii nyi, tə'i dimwaanə ŋga Rooma ashikii, wata ina dzə da soojiinaaki ka luupaanə tə ci. ");
INSERT INTO gde_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","Makə mwayi nyi fa 'waslyakəətə slənyi ci, nya kərə tə ci aasəkə mətərəkinatii. ");
INSERT INTO gde_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","Ma lapaa nyi, atsa bariyatii kəshi tii tə ci. Malapaamə nyi taa mi ashikii bahə ɓələnə tə ci, taa bahə kanə tə ci aa furəshina. ");
INSERT INTO gde_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","Amma makə bagi ənji ka nyi oo'i, kə anyi Yahudiinə uura ŋga ɓələginə tə ci, ci nee hə kərəgi nyi tə ci aaɓiiku pii pii, nya ba ka ənjinə wulii tə ci əsə, wa təya dzə ka wulanə tə ci akəŋwaciiku.” ");
INSERT INTO gde_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","Wata soojiitə a ŋgərə tə Bulusə, makə sətə bii ənji ka tii, təya kərəgi tə ci aa Antipatəra davəɗə. ");
INSERT INTO gde_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","Pukətə hakii soojiinə a ənə satii aasii, ənji təhinə a palə tii da Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","Makə mbu'i tii aa Kayisariya, təya vii ləkaləkatətə ka ŋgwaməna, təya vii tə Bulusə ka ci əsə. ");
INSERT INTO gde_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","Makə jaŋgatə ci ləkaləkatəta, ca ləgwa ka Bulusə, taa əndə hanyinə ŋga mi nə ci. Makə fii ci, əndə Silikiya nə ci, ");
INSERT INTO gde_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","əŋki ci, “Maɗa kə shi ənji wulaaku, kadə nii kya fa waɓənaaku patə.” Wata ca ba ka ənjə a pa'əgi tə Bulusə asəkə yi ŋwaŋuutə ghənyi *Hirudusə. ");
INSERT INTO gde_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","Daba'ə baanə tufə, wata gawə ŋga limanyinə, waatoo Ananiya a maɗə da hara gayinə da əndə'i əndə ətə ɗii ləməkii Tarətula. Ma Tarətula, kə shii ci bariya ŋga ənji Rooma ŋga'ə. Təya dzə aa Kayisariya ka wulanə tə Bulusə akəŋwacii ŋgwaməna. ");
INSERT INTO gde_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","Makə 'wagərə ənji tə Bulusə, Tarətula a 'watəgi waɓənə də wulanə tə ci, əŋki ci, “'Ya'ə Filikusə gawa, putə ŋga barəkaanə ŋga ŋwaŋuunaaku ndzaa inə jamə. Kə ɗii inə ka hə yawa putə ŋga gazhi'waanə ɗii hə ka haɗatəgi keenə də hanyinə geenə. ");
INSERT INTO gde_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","Ətsə patə, kə liwiinə də kuyiriinə ka shaŋə. ");
INSERT INTO gde_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","Amma, acii ga nya siipaa də waɓənə akəŋwaciiku, kə kədii inə baawəɗaaku kaa ha fatə magusə haalanə geenə. ");
INSERT INTO gde_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","Ma lapaa inə əndəna, bwayakii nə ci ka shaŋə. Agi maɗeenə nə ci ka panə ahada *Yahudiinə asəkə duuniya patə. Rəŋwə nə ci agi matakəŋwanyinə ŋga kurəgə ŋga ənji Nazaratu əsə. ");
INSERT INTO gde_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","Ha'ə kə mwayi ci ajijinətə *yi ŋga Əntaŋfə. Amma ina kəsətə tə ci. Ma mwayi inə, keena lagi ka ci gəŋwanə makə sətə bii bariya geenə. ");
INSERT INTO gde_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","Amma Lisiya matakəŋwanə ŋga soojiinə a shi ka gutsəginə tə ci acii inə də ŋgeerənə. ");
INSERT INTO gde_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","Ca ba ka ənji wulaakii, wa təya shi aakəŋwaciiku. Maɗa kə ləgwatə hə ka ci, ka shiinə nə hə dalilatə wulii inə tə ci gooŋga.” ");
INSERT INTO gde_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","Makə uugi Tarətula waɓənə, wata Yahudiinə patə a jikəvə, əŋki tii, “Ma sətə bii ci, patə ha'ə tanyi.” ");
INSERT INTO gde_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","Wata ŋgwaməna a vii rəgwa ka Bulusə kaa ca waɓə, Bulusə a jikəvə, əŋki ci, “Makə kə shii nyi oo'i, mala gəŋwanə nə hə ŋga hanyiinə fəzənyinə laŋə, də mabanee ma'yanə nə nyi ka pərəgi naaki nə akəŋwaciiku. ");
INSERT INTO gde_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","Maɗa kə ləgwatə hə ŋga'ə, mapaləmə tə baanə pu'u aji bəra'i, makə gi nyi aa Urusaliima ka paslənə tə Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","Paa tii sha lapaa tə nyi ka ɗa mabizhinə taa da wu, taa maɗee ka haala ŋga dzatə də ənji asəkə yi ŋga Əntaŋfə, taa asəkə *kuvə də'wanyinə taa asəkə vəranə əsə. ");
INSERT INTO gde_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","Pooshi tii ka mbeenə ka ɓaarii ka hə tantanyinəkii də wulaatsə wulii tii tə nyi. ");
INSERT INTO gde_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","Amma wanyinə ka banə ka hə: makə sətə bii rəgwa ətə ci təya 'wa rəgwa ŋga jirakənə, ha'ə nə nyi agi paslənə tə Əntaŋfə ŋga dzədzəshi'iniinə, nya luuvə sətə bii *bariya da sətə nyaahə anabiinə. ");
INSERT INTO gde_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","Agi kanə nə nyi nə də gooŋga, makə sətsə ci təya ka natii oo'i, ka maɗənə nə maməətə ənji da i əpinə, ŋunyi ənji da bwaya ənji patə. ");
INSERT INTO gde_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","Putakii cii kya ciŋə ka ndzaanə də malaaɓa ədzəmə taa guci patə akəŋwacii Əntaŋfə da akəŋwacii ənja. ");
INSERT INTO gde_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","“Yoo, daba'a fəzənyinə laŋə, kə gi nyi aa Urusaliima ka kərə ka ənji hanyinaaki uushi'inə da ka ɗa sataka ka Əntaŋfə. ");
INSERT INTO gde_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","18","Ma nyi agi ɗanə ha'ə, wata təya lapaa tə nyi, ci ətsə ha'ə uudəpaa nyi ɗa sataka ŋga laaɓagi naaki nə asəkə yi ŋga Əntaŋfə. Pooshi ənji aɓiiki, pooshi wazənə əsə. Amma tə'i hara Yahudiinə ətə shi daga agyanə hanyinə ŋga Asiya. ");
INSERT INTO gde_vpl VALUES ("AC24_19","074_24_19","ACT","24","19","19","Maɗa tə'i tii da waɓənə agyanəki, tii dəɓee shinə aakəŋwaciiku ka kira wulaaki. ");
INSERT INTO gde_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","Maɗa pooshi ha'ə əsə, wa ənjinə də natii nə a ba 'waslyakəətə lapaa tii ashiki, saa'itə nyi akəŋwacii *mətərəkinə, ");
INSERT INTO gde_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","maɗaamə waɓəətə rəŋwə ətə ŋgəree nyi ka uuraki ka banə akəŋwaciitii oo'i, ‘putə ŋga maɗənə ŋga maməətə ənji ci ənjə a la ka nyi gəŋwanə akəŋwacii unə ənshinə.’ ” ");
INSERT INTO gde_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","Amma, makə kə shii Filikusə haala ŋga rəgwa ŋga Slandanə ŋga'ə, kə bii ci, “Maɗa kə mbu'ya matakəŋwanə ŋga soojiinə, waatoo Lisiya, ka laginə nə nyi gəŋwanə goonə.” Ma daba'əkii, ca ba ka tii, wa təya təəkəgi, see ka əndə'i uusəra. ");
INSERT INTO gde_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","Ca ba ka sooja, kaa ca pa'əgi tə Bulusə, amma ga ca irəla tə ci; wa ca bwasee kaa guviinəkii a nəhə tə ci. ");
INSERT INTO gde_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","Daba'ə baanə gi'u, Filikusə a shi tii da minaakii Dərusila. Mitə Yahuda nə ki. Ca sləkee ka ŋgiranə tə Bulusə kaa ca fa amakii tə waɓənə ŋga vii gooŋga ka Yeesu Aləmasiihu. ");
INSERT INTO gde_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","Wata Bulusə a waɓə ka tii agyanə ndzaanə ka əndə gooŋga, ca ba ka tii makə sətə ətsətənə əndə naakii na, da makə sətə nə gəŋwanə a ɗa uusəra uudənə ŋga duuniya. Makə fii Filikusə ha'ə, wata ca ŋgwaləgi, əŋki ci, “Ma əndzə'i ɗiya, ənuu saaku. Maɗa upaa nyi saa'i, ka ənənə nə nyi ka 'wanə tə hə.” ");
INSERT INTO gde_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","Acii ma nə ci ka nəhənə, ka viinə nə Bulusə ka ci kwaɓa. Ci ɗii cii kəya 'waa'wa tə ci atsakii atsakii kaa təya waɓə. ");
INSERT INTO gde_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","Amma daba'ə fəzə bəra'i, əndə'i əndə a ŋgərə dəgələ ŋga Filikusə. Ma ləməkii, Purəkiyusə Fisətusə. Ma saa'itə Filikusə a bwasee ka ŋwaŋuunə, makapaamə ci tə Bulusə, acii kə mwayi ci uuɗagi səkə ŋga Yahudiinə. ");
INSERT INTO gde_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","Makə mbu'i Fisətusə aagyanə hanyinaakii, daba'a baanə makkə, ca maɗə daga də Kayisariya, ca palə aa Urusaliima. ");
INSERT INTO gde_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","Wata madiigərə limanyinə da *gayinə ŋga Yahudiinə a dzə ka wulanə tə Bulusə, təya tsəfə tə Fisətusə ");
INSERT INTO gde_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","kaa ca tsakə tə tii kaa ənjə a ənə də Bulusə aa Urusaliima. Acii kə ɗii tii aniya ŋga ɓələginə tə ci daga a rəgwa. ");
INSERT INTO gde_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","Amma Fisətusə a jikəvə ka tii, əŋki ci, “Mapa'əkii nə Bulusə də Kayisariya. Nyi maa, ka ənənə nə nyi aa dəvə kədəhə. ");
INSERT INTO gde_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","Wa ina dzə da gayinə ahadoonə, təya wula tə ci davə, maɗa tə'i sətə ɗii ci.” ");
INSERT INTO gde_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","Mapaleemə ka baanə tighəsə taa baanə pu'u ɗii Fisətusə də Urusaliima, ca ənə aa Kayisariya. Pukənə ŋga ha, ca dzə ka ndzaanə asəkə dəgələ ŋga la gəŋwanə, ca sləkee ka ənjə a kira tə Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","Makə mbu'i Bulusə, Yahudiitə shi daga də Urusaliima a guŋutə də ci. Taa ŋgahi pooshi tii mbee ka ɓaarii tantanyinəkii, amma kə kira tii mandalə wulanyinatii ɓəzəkii aagyanəkii. ");
INSERT INTO gde_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","Wata Bulusə a waɓə kaa ca pərəgi naakii na, əŋki ci, “Makaanəmə nyi səɗə ka bariya ŋga Yahudiinə; ma'ajijinətəmə nyi *yi ŋga Əntaŋfə, taa ɗa 'waslyakəənə ka maɗuunə ŋwaŋwə ŋga ha də Rooma, taa gi'u.” ");
INSERT INTO gde_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","Makə mwayi Fisətusə pa'ətə ba'a ka Yahudiinə, ca ləgwa ka Bulusə, əŋki ci, “Kə luuvə hə, ənjə a ənə də hə aa Urusaliima, ənjə a dzə ka la ka hə gəŋwanə agyanə uushi'iitsə akəŋwaciiki davə kwa?” ");
INSERT INTO gde_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","Amma əŋki Bulusə, “Kəŋə nə nyi asəkə kuvə gəŋwanə ŋga ənji Rooma, hatə dəɓee ənjə a la ka nyi gəŋwanə. Maɗamə nyi ka Yahudiinə 'waslyakəənə. Hə də naaku nə maa, kə shii hə ndilə ndilə. ");
INSERT INTO gde_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","Maɗa ma'waslyakə əndə nə nyi, ha'ə kə slənyii sətə mbu'i bahə ɓələnə tə nyi, paa nyi ka huyinə acii ɓələnə tə nyi. Amma, maɗa pooshi nyi slənyi taa rəŋwə agi uushi'iitsə bii tii aashiki, pooshi əndə da baawəɗa ŋga viinə tə nyi ka tii. Kə mwayi nyi kaa maɗuunə ŋwaŋwə ŋga ha də Rooma a dzə ka lagi ka nyi gəŋwanə.” ");
INSERT INTO gde_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","Fanə ŋga Fisətusə ha'ə, wata ca ɗa mətərəkinə da ənji mətərəkinaakii. Makə uugi tii, ca ba ka Bulusə, “Makə kə mwayi hə kaa maɗuunə ŋwaŋwə ŋga ha də Rooma a dzə ka lagi ka hə gəŋwanə, ka ci kərənə ənji tə hə əsə.” ");
INSERT INTO gde_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","Makə banee gi'u, wata ŋwaŋwə Agaripa da cikəŋuci ətə ɗii ləmətə Barənika a shi aa Kayisariya ka ba ‘usa da shinə’ ka Fisətusə. ");
INSERT INTO gde_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","Kə baa tii laŋə davə, wata Fisətusə a 'wapaa waɓənə ŋga Bulusə ka ŋwaŋwə, əŋki ci, “Tə'i əndə'i əndə bwasee Filikusə a furəshina. ");
INSERT INTO gde_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","Ma nyi də Urusaliima, madiigərə limanyinə da gayinə ŋga Yahudiinə a kira ka nyi wulaakii, təya kədii tə nyi kaa nya lagi ka ci gəŋwanə, nya vii ka ci ma'inə. ");
INSERT INTO gde_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","Amma nya ba ka tii, pooshi agi alə'aada ŋga ənji Rooma nə lagi ka əndə gəŋwanə yadə ndzaanə ŋga ənjitə wulii da əndətə wulii ənji tə ci akəŋwacii gəŋwanə, kaa əndətə wulii ənjə a mbee ka vii hujaakii. ");
INSERT INTO gde_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","Acii ha'ə, makə shi tii aa hanə patə, masəkəpaamə nyi na. Pukənə ŋga ha, nya ndzaanə asəkə dəgəlaaki ŋga la gəŋwanə, nya sləkee ka ənjə a kira ka nyi tə əndəkii. ");
INSERT INTO gde_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","Makə maɗətə ənjitə wulii tə ci ka waɓənə, makiramə tii bwaya wula aagyanəkii, makə sətə hiimii nyi, ");
INSERT INTO gde_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","see mabizhinə agyanə diinatii da agyanə əndə'i əndə ɗii ləməkii Yeesu ətə əntəgi, amma Bulusə a ba, da i əpinə nə ci. ");
INSERT INTO gde_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","Makə təkuree nyi ka tsaamətə haalakii ŋga'ə, wata nya ləgwa ka Bulusə, maɗa kə luuvə ci, ənjə a ənə də ci aa Urusaliima, ənjə a dzə ka lagi ka ci gəŋwanə davə. ");
INSERT INTO gde_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","Amma kə kədii Bulusə aciiki, kaa maɗuunə ŋwaŋwə ŋga ha də Rooma a dzə ka lagi ka ci gəŋwanaakii. Ci ɗii kəsəpaa nyi tə ci taabu'u nii kya sləkee ka kərənə tə ci ka maɗuunə ŋwaŋwa.” ");
INSERT INTO gde_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","Əŋki Agaripa ka Fisətusə, “Ŋga'ə ka nyi nə fatənə tə əndətsə də liminəki.” Əŋki Fisətusə ka ci, “Ka fanə nə hə doorə.” ");
INSERT INTO gde_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","Pukətə hakii, Agaripa da cikəŋuci a shi də məghərəvənə ŋga ŋwaŋuunə, təya dəməgərə aasəkə kuvə gəŋwanə da gayinə ŋga soojiinə da madiigərənə ŋga vəranə patə əsə. Fisətusə a ba ka ənjə a kira tə Bulusə. ");
INSERT INTO gde_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","Makə kira ənji tə ci, wata Fisətusə a ba, “Ŋwaŋwə Agaripa da ənjinə ganə patə, waanə əndəna. Kə kira Yahudiinə ŋga Urusaliima da ənə ŋga vəraanə patə wulaakii, təya ŋgəree ka uuratii ka banə ka nyi, madəɓeemə ənjə a bwasee ka ci da i əpinə. ");
INSERT INTO gde_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","Amma, ma'upaamə nyi 'waslyakəənə ashikii bahə ɓələnə tə ci. Makə ci də naakii nə bii, wa ənjə a kərə tə ci aakəŋwacii maɗuunə ŋwaŋwə ŋga ha də Rooma, kə ɗii nyi aniya ŋga sləkeenə ka ənjə a kərə tə ci ka ci. ");
INSERT INTO gde_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","Amma, mashiimə nyi sətə naahənəki ka slandanəki agyanə haalakii. Aciikii kira nyi tə ci aakəŋwacii unə patə, ma palee maa, aakəŋwaciiku, ŋwaŋwə Agaripa. Maɗa kə fataamə waɓənəkii, mbu'u ka upaanə nə nyi sə ŋga naahənə. ");
INSERT INTO gde_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","Acii maluuvəmə haŋkalaaki sləkee ka əndə furəshina ka gəŋwanə yadə laaɓaginə taa aba'a mi wulii ənji tə ci.” ");
INSERT INTO gde_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","Wata Agaripa a ba ka Bulusə, “Kə kapaa ənji ka hə rəgwa ŋga waɓənə.” Bulusə a 