﻿USE sofia;
DROP TABLE IF EXISTS sofia.gbl_vpl;
CREATE TABLE gbl_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gbl_vpl WRITE;
INSERT INTO gbl_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ઈ ઈસુ ખ્રિસ્તા આગલ્યા ડાયહા નાંવહા યાદી હેય જીં આબ્રાહામા એને દાઉદ રાજા પીડી હેય. ");
INSERT INTO gbl_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","આબ્રાહામા પોહો ઈસાક, ઈસાકા પોહો યાકૂબ, યાકૂબા પોહા યહૂદા એને ચ્યા બાહા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","યહૂદા પોહા પેરેસ એને ઝેરાહ આતા, એને ચ્યાહા આયહો તામાર આતી, એને પેરેસા પોહો હેસ્રોન, એને હેસ્રોના પોહો એરામ આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","એને એરામા પોહો અમીનાદાબ, એને અમીનાદાબા પોહો નાહશોન, એને નહશોના પોહો સલમોન આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","સલમોન એને રાહાબા પોહો બોઆજ આતો, બોઆજ એને રૂથે પોહો ઓબેદ આતો, રૂથ ઓબેદા આયહો આતી, ઓબેદા પોહો યિશૈ આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","એને યિશૈ પોહો દાઉદ રાજા, એને દાઉદા પોહો સુલેમાન આતો, ચ્યે થેએયેથી પોહો જાયો જીં પેલ્લી ઉરીયા થેએ આતી. ");
INSERT INTO gbl_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","સુલેમાના પોહો રહાબામ, એને રહાબામા પોહો અબીયા, એને અબીયા પોહો આસા આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","આસા પોહો યહોશાફાટ આતો, એને યહોશાફાટા પોહો યોરામ, એને યોરામા પોહો ઉજીયા આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ઉજીયા પોહો યોથામ, યોથામા પોહો આહાઝ, એને આહાઝા પોહો હિઝકીયા આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","હિઝકીયા પોહો મનશ્શે, મનશ્શે પોહો આમોન, એને આમોના પોહો યોશિયા આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","એને યોશિયા યખોન્યા એને ચ્યા બાહાહા આબહા આબહો આતો, યા ઈસરાયેલી લોક બાબેલા ગુલામગીરી માય જાં પેલ્લા જન્માલ યેના. ");
INSERT INTO gbl_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ગુલામ બોનીન બાબેલ માય જાયના સોમાયાથી લેઈને ઈસુવા જન્મા લોગુ, યા ઈસુ આગલ્યાડાયા આતા, યખોન્યા પોહો શાલતીયેલ, એને શાલતીયેલા પોહો ઝરુબાબેલ આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ઝરુબાબેલા પોહો અબીહુદ, એને અબીહુદા પોહો એલ્યાકીમ, એને એલ્યાકીમા પોહો અઝોર આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","અઝોરા પોહો સાદોક, એને સાદોકા પોહો અખીમ, એને અખીમા પોહો એલીહુદ આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","એલીહુદા પોહો એલીયાજર, એલીયાજરા પોહો મથ્થાન, એને મથ્થાના પોહો યાકૂબ આતો. ");
INSERT INTO gbl_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","યાકૂબા પોહો યોસેફ, જો મરિયમે માટડો આતો, એને મરિયમે પોહો ઈસુ, જ્યાલ ખ્રિસ્ત આખતેહે. ");
INSERT INTO gbl_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","યા પરમાણે આબ્રાહામાથી રાજા દાઉદ લોગુ ચૌવુદ પેડયો આત્યો, એને દાઉદ રાજાથી બાબેલા ગુલામગીરી માય જાઅના પેલ્લા ચૌવુદ પેડયો, એને બાબેલા ગુલામગીરી માય જાયના સમયાથી ખ્રિસ્ત લોગુ ચૌવુદ પેડયો આત્યો. ");
INSERT INTO gbl_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ઈસુ ખ્રિસ્તા જન્મો ઓઅના પેલ્લા એહેકેન ઓઅયા, કા જોવે ચ્યા આયહે મરિયમે માગણી યોસેફ આરે ઓઅયી, તોવે ચ્યે વોરાડ ઓઅના ચ્યા પેલ્લા જોવે તી કુંવારી આતી, તોવે ચ્યે પવિત્ર આત્મા સામર્થ્યા થી. મોયના રિયા. ");
INSERT INTO gbl_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","યોસેફ જો મરિયમે આરે માગણી ઓઅલી આતી, તો યોક ન્યાયી માઅહું આતો એને ચ્યેલ બોદહા હોમ્મે અપમાન કોઅરા નાંય માગતો આતો, યાહાટી ઠાવકાજ ચ્યાય ચ્યે આરે ઓઅલી માગણી તોડી દેઅના વિચાર કોઅયા (કાહાકા ચ્યે વોરાડા પેલ્લા મોયના રીયલા આતા જીં નિયમા વિરુદ આતા). ");
INSERT INTO gbl_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","જોવે તો યે વાતે વિચારમાય આતો તોવે પ્રભુ દૂત હોપનામાય યેઇન આખા લાગ્યો કા, “ઓ યોસેફ! દાઉદ રાજા કુળા, તું મરિયમેલ તો થેએ બોનાડા મા બીયહે, કાહાકા જીં ચ્યે બુકામાય હેય, તી પવિત્ર આત્મા સામર્થ્યા થી હેતાં. ");
INSERT INTO gbl_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","તી યોકા વાહના પોહાલ જન્મો દી એને તું ચ્યા નાંવ ઈસુ થોવજે, કાહાકા તો ચ્યા લોકહા પાપહા પાયને તારણ કોઅરી!” ");
INSERT INTO gbl_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ઈ બોદા યાહાટી ઓઅયા કા તીં પુરાં ઓએ જીં પોરમેહેરાય યશાયા ભવિષ્યવક્તા દ્વારા ઈસુ જન્મા બારામાય આખલા આતા, યશાયા ભવિષ્યવક્તાય એહેકેન લોખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“એઆ, યોક કુંવારી મોયના ઓઅરી એને યોકા વાહના પોહાલ જન્મો દી ચ્યા નાંવ ઈમ્માનુએલ થોવજા,” જ્યા નાંવા મોતલાબ હેય “પોરમેહેર આપહેઆરે હેય”. ");
INSERT INTO gbl_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","તોવે યોસેફ નિંદે માઅને જાગીન પ્રભુ દૂતા આગના ઇસાબે ચ્યાય મરિયમે આરે વોરાડ કોઅઇ લેદા એને ચ્યેલ ચ્યા ગોઓ લેય યેનો. ");
INSERT INTO gbl_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","જાવ લોગુ ચ્યે પાહાલ જન્મો નાંય દેનો તાંઉલોગુ ચ્યાહા બેનહયા શારીરિક સબંધ નાંય જાયો: એને યુસુફાય ચ્યા પોહા નાંવ ઈસુ થોવ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","જોવે હેરોદ રાજા યહૂદીયાવોય રાજ કોઅતો આતો, તોવે ઈસુવા જન્મો યહૂદા ભાગા બેથલેહેમ ગાવામાય જાયો, તોવે દિહી ઉદતા એહેરે માગી લોક યેઇન યેરૂસાલેમ શેહેરમાય પુછા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“તો પોહો કેસ હેય જ્યા યહૂદીયા રાજા બોનાહાટી જન્મો જાયોહો? કાહાકા આમાહાય દિહી ઉદતા એછે ચ્યા જન્મા તારો દેખ્યો એને આમા ચ્યા ભક્તિ કોઅરા યેનહા.” ");
INSERT INTO gbl_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","યહૂદીયા રાજા જન્મા બારામાય વોનાઈન, હેરોદ રાજા એને યેરૂસાલેમ શેહેરામાઅને બોજ લોક ગાબરાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","તોવે હેરોદ રાજાય, લોકહા મુખ્ય યાજકાલ એને મૂસા નિયમ હિકાડનારા ગુરુહુલ યોકઠા કોઇન પુછ્યાં, “ખ્રિસ્તા જન્મા જાગા બારામાય ભવિષ્યવક્તા કાય આખતાહા?” ");
INSERT INTO gbl_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ચ્યાહાય ચ્યાલ જોવાબ દેનો, ખ્રિસ્તા જન્મો યહૂદીયા વિસ્તારા બેથલેહેમ ગાવામાય ઓઅરી, કાહાકા ભવિષ્યવક્તા મીખાથી બોજ પેલ્લા લોખવામાય યેનલા આતા જીં પોરમેહેરાય આખલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","“ઓ યહૂદા ભાગા બેથલેહેમ ગાવા લોકહાય, તુમા યહૂદીયા આગેવાનાહામાય બોદહામાય વાહના નાંય હેતા; કાહાકા તુમહેમાય યોક માઅહું યી જો અધિપતિ બોની, જો મા ઈસરાયેલ દેશા લોકહાહાટી રાખવાળી કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","હેરોદ રાજાય ચ્યા જન્મો ઓઅલા વાહના પોહા વોરહે જાંઅરા હાટી માગી લોકહાન દોબીન હાદિન ચ્યાહાન પુછ્યાં કા, તારો નોક્કી કોઅહા સમાયામાય દેખાયો, ");
INSERT INTO gbl_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","એને ચ્યાય ઈ આખીન માગી લોકહાન બેથલેહેમ ગાવામાય દોવાડયા, “જાં, ચ્યા વાહના પોહા બારામાય નોક્કી રીતે ખોબાર કાડા, એને જોવે તો મિળી જાય તોવે માપાય યા એને પાછે જીં કાય તુમાહાય દેખ્યા તીં માન આખા કા આંયબી જાયને ચ્યા ભક્તિ કોઉ.” ");
INSERT INTO gbl_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","માગી લોક રાજા વાત વોનાઈન જાતા રિયા, એને વાટે ચાલતા ચ્યાહાય તોજ તારો દેખ્યો જો તારો ચ્યાહાય દિહી ઉદ્યા એછે દેખ્યેલ, તો તારો ચ્યાહા આગલા-આગલા હોરક્યો એને ચ્યા જાગાવોય જાયને ઉબો રોય ગીયો જાં વાહનો પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ચ્યા તારાલ એઇન બોજ ખુશ ઓઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ચ્યાહાય ચ્યા ગોઆમાય જાયન ચ્યા વાહના પોહાલ ચ્યા આયહે મરિયમે આરે દેખ્યાં, એને ઉંબડા પોડીન ચ્યા પોહા પાગે પોડ્યા, એને પોતે ઠેલ્યો ખોલીન ચ્યાલ હોના, એને લોબાન, એને બોળ બેટ દેના. ");
INSERT INTO gbl_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","તોવે હોપનામાય ઈ ચેતાવણી વોનાઈન હેરોદ રાજાપાય પાછા ફિરી નાંય જાયના, ચ્યાહાય રાજાલ નાંય આખ્યાં એને બિજ્યે વાટયેથી ચ્યા ચ્યાહા દેશામાય જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ચ્યા જાતા રિયા ચ્યા પાછે, પ્રભુ યોક દૂતાય હોપનામાય યોસેફાલ દેખાઈન આખ્યાં, “ઉઠ! ચ્યા વાહના પોહાલ એને ચ્યા આયહેલ લેઈને મિસર દેશામાય નાહી જો, એને જાવ લોગુ આંય તુલ નાંય આખું, તાંવ લોગુ તાંજ રોજે, કાહાકા હેરોદ રાજા યા વાહના પોહાલ હોદી રિયહો કા તો ચ્યાલ માઆઇ ટાકે.” ");
INSERT INTO gbl_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","તોવે તો રાતીજ ઉઠીન વાહના પોહાલ એને ચ્યા આયહેલ લેઈને મિસરમાય ચાલ પોડયો. ");
INSERT INTO gbl_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","એને હેરોદ રાજા મોએ તાંવ લોગુ મિસરમાય રિયો યાહાટી કા જીં વચન પ્રભુય ભવિષ્યવક્તા હોશેથી બોજ પેલ્લા આખ્યેલ તીં પુરાં ઓઈ: “માયે મા પાહાલ મિસર માઅને હાદ્યા.” હોશે 11:1 ");
INSERT INTO gbl_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","હેરોદ રાજા ખિજવાય ગીયો જોવે ચ્યાલ લાગ્યા કા માગી લોકહાય ચ્યાઆરે દોગો કોઅયો, ચ્યાય સૈનિકાહાલ દોવાડયા બેથલેહેમ ગાવા એને ચ્યા પાહી-પાહીના ઠીકાણાહામાયને બોદા વાહના પોહાહાલ માઆઇ દેય, જ્યેં બેન વોરહા એને ચ્યા કોઅતા વાહને આતેં, ઈ માગી લોકહાન પેલ્લા તારો દેખાના આધારાવોય આતા. ");
INSERT INTO gbl_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","તોવે જીં વચન યિર્મયા ભવિષ્યવક્તાથી પોરમેહેરાય આખલા આતા તીં પુરાં ઓઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“રામાહામાય તાં યોક બાયે આવાજ વોનાયા યેનો જીં રોડી રિઅલી આતી, રોડના એને મોઠો આવાજ, રાહેલ પોતાના પોહહાહાટી રોડી રિઅલી આતી, એને તી ઠાવકી નાંય રા આતી કાહાકા ચ્યે આમી મોઇ ગીઇલે આતેં.” ");
INSERT INTO gbl_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","યોસેફ, મરિયમ એને ચ્યાહા પોહો ઈસુ આજુ મિસરમાયજ આતેં, તોવે હેરોદ રાજા મોરણા પાછે, પ્રભુવા દૂતાય મિસરમાય યોસેફાલ હોપનામાય દેખાડયાં એને આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ઉઠ, પાહા એને ચ્યા આયહેલ લેઈને ઈસરાયેલ દેશ માય જાતો રો, કાહાકા હેરોદ રાજા એને ચ્યા લોક જ્યા વાહના પાહાલ માઆઇ ટાકાં આતા, ચ્યા મોઅઇ ગીયહા”. ");
INSERT INTO gbl_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","તો ઉઠયો, એને પોહાલ એને ચ્યા આયહેલ આરે લેઈને મિસર દેશ છોડીન એને ઈસરાયેલ દેશ માય યેનો. ");
INSERT INTO gbl_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","બાકી જોવે યોસેફ વોનાઈન અરખિલાઉસ પોતાના આબહાલ હેરોદ રાજા જાગાવોય યહૂદીયા વિસ્તારાવોય રાજ કોઅઇ રિયહો, તાં જાવાથી તો બિઅયો; પાછે હોપનામાય પોરમેહેરથી ચેતાવણી લેઈને ગાલીલ ભાગામાય જાતો રિયો, ");
INSERT INTO gbl_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","એને તો નાસરેત ગાવામાય જાયને રિયો, કાહાકા તીં વચન પુરાં ઓઅઇ, જીં ભવિષ્યવક્તાહાથી ઈસુ બારામાય આખવામાય યેનલા “તો નાજરેત ગાવા આખાયી.” ");
INSERT INTO gbl_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","એને ચ્યા દિહીહયામાય યોહાન બાપતિસ્મા દેનારો યેયન યહૂદીયા વિસ્તારા ઉજાડ જાગામાય જાયને ઈ પ્રચાર કોઅરા લાગ્યો, ");
INSERT INTO gbl_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","“પાપ કોઅના છોડી દા, કાહાકા હોરગા રાજ્ય પાહી યેય ગીયહા.” ");
INSERT INTO gbl_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","તો ઓજ હેય જો યશાયા ભવિષ્યવક્તાયેબી જ્યા બારામાય આખલા આતા “ઉજાડ જાગામાય યોહાન બોંબલીન આખહે કા પ્રભુ યેયના વાટ તિયાર કોઆ, ચ્યો વાટયો હિદ્યો કોઆ જયેહવોયને તો યેનારો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ઓ યોહાન ઉટડા બુરા બોનાડલે ફાડકે પોવે, એને કંબરા આરે ચામડા પોટો બાંદે, એને ચ્યા ખાઅના ટોડે એને રાનીમોદ આતા. ");
INSERT INTO gbl_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","તોવે યહૂદીયા વિસ્તારામાઅને, એને યેરૂસાલેમ શેહેરામાઅને, એને યારદેન નોયે ચોમખી રોનારા લોક નિંગીન ઉજાડ જાગામાય બાપતિસ્મા દેનારા યોહાના સંદેશ વોનાયા ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","જેહેકોય ચ્યાહાય પાપહાલ માની લેદા તોવે યોહાને લોકહાન યારદેન નોયેમાય બાપતિસ્મા દેના. ");
INSERT INTO gbl_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","જોવે યોહાને દેખ્યા પોરૂષી એને સાદૂકી લોક ચ્યાપાય બાપતિસ્મા લાંહાટી યેય રીયહા, તે ચ્યાય આખ્યાં, તુમા જેરીવાળા હાપડા હારખા ખારાબ હેય, તુમહાન કુંયે પોરમેહેરા ન્યાયામાઅને નાહના ચેતાવણી દેની જો યેનારો હેય? ");
INSERT INTO gbl_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","યાહાટી એહેકેન જીવા કા લોકહાન ખોબાર પોડે કા તુમાહાય પાપ કોઅના બંદ કોઅઇ દેનહા. ");
INSERT INTO gbl_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","એને પોતે મોનામાય એહેકોય નાંય વિચાર કોઅના કા આબ્રાહામ આપહે આબહો હેય, બાકી આંય તુમહાન એહેકોય આખતાહાવ કા, પોરમેહેર આબ્રાહામાહાટી યા દોગડાહા પાયને બી પોહેં પૈદા કોઅઇ હોકહે. ");
INSERT INTO gbl_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","જેહેકોય યોક કુરાડાવાળો હારેં ફળે નાંય દેનારા હર યોક મુળથી જાડાહાલ ખાંડીન આગડામાય ટાકી દાંહાટી તિયાર હેય, તેહેકોયનુજ આમી પોરમેહેર ચ્યાહા ન્યાય કોઅરાહાટી તિયાર હેય, જો પાપ કોઅના બંદ નાંય કોએ. ");
INSERT INTO gbl_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","“આંય તે પાઆયાકોય તુમહાન પાપ કોઅના બંદ કોઅરાહાટી બાપતિસ્મા દેતહાવ, બાકી જો મા પાછે યેનારો હેય, તો મા કોઅતો મહાન ગોત્યેવાળો હેય: આંય તે ચ્યા ચાકાર બોનીન ચ્યા ખાઅડા હુતળી છોડાબી લાયક્યે નાંય હેય, એને તો તે તુમહાન પવિત્ર આત્મા એને આગડાકોય બાપતિસ્મા દી. ");
INSERT INTO gbl_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ચ્યા હૂપડાં ચ્યા આથામાય હેય, એને તો ચ્યા ખોળાં હારેકોય ચોખ્ખાં કોઅરી, એને ચ્યા ગોંવ તો કોઠારામાય બેગા કોઅરી, બાકી બુહટા નાંય ઉલાય ઓહડા આગડામાય ટાકીન હોલગાડી દી.” ");
INSERT INTO gbl_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","તોવે ચ્યે સમયે ઈસુ ગાલીલ ભાગામાઅને નિંગ્યો એને યારદેન નોયે મેરાવોય યોહાનાથી બાપતિસ્મા લાંહાટી યેનો. ");
INSERT INTO gbl_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","બાકી યોહાન એહેકેન આખીન ચ્યાલ ઉબો રાખાં લાગ્યો કા, “માન તે તો આથેકોય બાપતિસ્મા લેઅના ગોરાજ હેય, એને તું તે માપાય યેનહો?” ");
INSERT INTO gbl_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ઈસુવે ચ્યાલ ઓ જાવાબ દેનો કા, “એહેકેન ઓઅરા દે, કાહાકા યે રીતે આમા તીં બોદા કોઅઇ રીયહા જીં પોરમેહેરાલ આમહે થી જોજહે” તોવે, યોહાન ઈસુવાલ બાપતિસ્મા દાંહાટી તિયાર ઓઈ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ઈસુ બાપતિસ્મા લેયને તારાતુજ પાઅયામાયને બાઆ નિંગ્યો, ચ્યેજ ગેડીયે ચ્યે આકાશ ઉગડાં દેખ્યા એને પોરમેહેરા આત્મા કબુતરા રોકા ચ્યાવોય ઉતતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","હોરગામાઅને પોરમેહેરાય ઈસુ બારામાય આખ્યાં કા, “ઓ મા પ્રિય પોહો હેય, યાથી આંય ખુશ હેતાંવ.” ");
INSERT INTO gbl_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","તોવે સૈતાનાકોય ઈસુ પરીક્ષા ઓએ યાહાટી પવિત્ર આત્મા ઈસુલ ઉજાડ જાગામાય લેય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","એને તાં ચાળહી દિહી એને ચાળહી રાત ખાઅના નાંય ખાદાં, ચ્યા પાછે ચ્યાલ બુખ લાગી. ");
INSERT INTO gbl_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","તોવે સૈતાનાય ચ્યાપાય યેયન ચ્યાલ આખ્યાં કા, “જો તું પોરમેહેરા પોહો ઓરી, તે આગના દેયને સાબિત કોઅઇ દે કા યા દોગડા બાખ્યો બોની જાય કા તું ચ્યેહેલ ખાય હોકે.” ");
INSERT INTO gbl_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ઈસુય જાવાબ દેનો કા, “પવિત્રશાસ્ત્રમાય લોખલાં હેય, કા માઅહું માત્ર બાખ્યે કોયજ નાંય, બાકી તો પોરમેહેરા આખલા વચનાલ માનીન જીવતો રોય.” ");
INSERT INTO gbl_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","તોવે સૈતાન ચ્યાલ પવિત્ર શેહેર યેરૂસાલેમમાય લેય ગીયો એને દેવાળા ઉચે મેરાવોય ઉબો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","એને ચ્યાલ આખ્યાં, “જો તું પોરમેહેરા પોહો ઓરી, તે તું પોતે નિચે કુદી પોડ એને સાબિત કોઅઇ દે કા તુલ જખમ નાંય ઓઅરી, કાહાકા પવિત્રશાસ્ત્રમાય એહેકેન લોખલાં હેય કા, હોરગા દૂતહાલ તોહાટી આગના કોઅરી, એને તો પાગ દોગડાવોય આફળાય નાંય ચ્યાહાટી ચ્યા આથાવોય જેલી લેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ઈસુવે ચ્યાલ આખ્યાં કા, “પવિત્રશાસ્ત્રમાય એહેકેનબી લોખલાં હેય, લોકહાય ચ્યાહા પ્રભુ પોરમેહેરા પરીક્ષા નાંય કોઅરા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","તોવે સૈતાન ચ્યાલ યોક બોજ મોઠા ઉચા ડોગાવોય લેય ગીયો એને દુનિયામાયને બોદે રાજ્યે એને ચ્યા સુંદરતા ચ્યાલ દેખાડયે. ");
INSERT INTO gbl_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","એને સૈતાનાય ઈસુલ આખ્યાં કા, “જો તું મા પાગે પોડીન ભક્તિ કોઅહે તે આંય ઈ બોદાજ તુલ દેય દિહીં.” ");
INSERT INTO gbl_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","તોવે ઈસુવે સૈતાનાલ આખ્યાં, ઓ સૈતાન દુર ઓઅઇ જો, કાહાકા પવિત્રશાસ્ત્રમાય લોખલાં હેય: તું પ્રભુ તો પોરમેહેર ચ્યા પાગે પોડ એને યોખલા ચ્યાજ ભક્તિ કોઓ. ");
INSERT INTO gbl_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","તોવે સૈતાન ઈસુવાલ છોડીન જાતો રિયો, એને હોરગા દૂત યેયન ચ્યા ચાકરી કોએત. ");
INSERT INTO gbl_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","જોવે તો વોનાયોકા યોહાન બાપતિસ્મા દેનારાલ જેલેમાય કોંડી દેનહો, તોવે તો યહૂદીયા ભાગામાઅને ગાલીલ ભાગામાય જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","એને તો નાજરેત ગાવાલ છોડીન તો કાપરનાહુમ ગાવામાય જો દોરિયા મેરાવોય જબુલુન એને નાફતાલી ભાગામાય જાયને રા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ઈ યાહાટી જાયા કા યશાયા ભવિષ્યવક્તાથી આખલા આતા તીં પુરાં ઓએ. ");
INSERT INTO gbl_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","તુમા લોક જ્યા જબુલુન એને નાફતાલી ભાગામાય રોતહા, એને જ્યા ગાલીલ દોરિયા પાહીના એને યારદેન નોયે દિહી ઉદ્યા મેરાવોય હેય, ઈ ગાલીલ ભાગા ઓહડો ભાગ હેય તાં અમુક ગેર યહૂદી લોક રોતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","જ્યા લોક પોરમેહેરાલ વોળખ્યા વોગાર આંદારામાય બોઠલા આતા, ચ્યાહાય મોઠો ઉજવાડો દેખ્યો, એને મોરણા છાવડયેમાય બોઠલેં આતેં, ચ્યાહાવોય ઉજવાડો ચોમક્યો. ");
INSERT INTO gbl_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ચ્યા સોમાયથી ઈસુય પ્રચાર કોઅના શુરવાત કોઅયા, “પાપ કોઅના છોડી દા કાહાકા હોરગા રાજ્ય પાહી યેય ગીયહા.” ");
INSERT INTO gbl_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","પાછે તો ગાલીલ દોરિયા મેરે રોયન જાં આતો તોવે, ચ્યેય પિત્તર આખતેહે તો સિમોન એને ચ્યા બાહા આંદ્રિયા યા બેની બાહાહાલ દોરિયામાય જાળ ટાકતા દેખ્યા; કાહાકા ચ્યા માછલે દોઅનારા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ઈસુવે ચ્યાહાન આખ્યાં, યા તુમા મા શિષ્ય બોના, આમી લોગુ તુમા માછલે દોઅનારા આતા, બાકી આંય તુમહાન હિકાડીહી કા લોકહાન કેહેકેન મા શિષ્ય બોનાડના હેય. ");
INSERT INTO gbl_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","તોવે તારાતુજ ચ્યાહાય માછલે દોઅના છોડીન ઈસુવા શિષ્ય બોની ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ઈસુ એને ચ્યા બેન શિષ્ય દોરિયા મેરે વાહાયોક આગલા ગીયા, ઈસુવે બિજા બેન બાહાહાલ એટલે ચ્યા તે જબદયા પોહા યાકૂબ એને યોહાનાલ ઉડીમાય બોહીન જાળ હાંદતા દેખ્યા, એને ચ્યાય ચ્યાહાલબી હાદ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","પાછે ચ્યા તારાત ઉડીલ એને ચ્યા આબહો જબદયાલ છોડીન ગીયા એને ચ્યા ઈસુવા શિષ્ય બોન્યા. ");
INSERT INTO gbl_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","પાછે ઈસુ બોદા ગાલીલ ભાગામાય ફિરીન એને યહૂદી લોકહા સોબાયે ઠિકાણામાય હિકાડે એને પોરમેહેરા રાજ્યા હારી ખોબાર આખતો એને માઅહામાયને બોદે જાત્યા બિમારી એને ચ્યાહામાઅને નોબળાય દુઉ કોઅતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","એને બોદા સિરીયા વિસ્તારામાય ચ્યા ખોબાર ફેલાય ગીયી, તોવે જ્યા બિમાર આતા, જ્યાહાલ જુદા-જુદા જાત્યા રોગ એને દુ:ખામાય પીડાલા આતા, એને જ્યાહાલ બુત લાગલા એને મિરગ્યે લોખવાવાળે આતેં, એને ચ્યા બોદહાન ચ્યાહાય ચ્યાપાય લેય યેને એને ચ્યાય ચ્યા બોદા દુખ્યાહાલ હારેં કોઅયે. ");
INSERT INTO gbl_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","પાછે ગાલીલ ભાગા દકોપોલીસ, યેરૂસાલેમ શેહેર, યહૂદીયા વિસ્તારા એને યારદેન નોયે ચ્યે મેરેને લોકહા ટોળા-ટોળા ઈસુ પાહાલારે ચાલતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ઈસુ ચ્યા લોકહા ટોળાલ એઇન ડોગાવોય ચોડી ગીયો, એને જોવે તો હિકાડાંહાટી બોહી ગીયો તોવે ચ્યા શિષ્ય ચ્યા પાહી યેના. ");
INSERT INTO gbl_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","તોવે ઈસુ ઈ આખીન ચ્યાહાન હિકાડાં લાગ્યો કા: ");
INSERT INTO gbl_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ધન્ય હેય જ્યા લોક આત્મિક રીતે ગરીબ હેતા, હોરગા રાજ્ય ચ્યાહા હાટીજ હેય. ");
INSERT INTO gbl_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ધન્ય હેય જ્યેં, શોક કોઅતેહે, કાહાકા પોરમેહેર ચ્યાહાન ઈંમાત દેઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ધન્ય હેતેં ચ્યે, જ્યેં નમ્ર હેતેં, કાહાકા દોરતી ચ્યાહા ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ધન્ય હેય ચ્યે, જ્યાહાન ન્યાયપણા જીવન જીવાહાટી મોઠી ઇચ્છા હેય, કાહાકા પોરમેહેર ચ્યાહાન તૃપ્ત કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ધન્ય હેતેં ચ્યે, જ્યેં દયાળુ હેતેં, કાહાકા પોરમેહેર ચ્યાહાવોય દયા કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ધન્ય હેય ચ્યે, જ્યાહા મોન ચોખ્ખેં હેતેં, કાહાકા ચ્યે પોરમેહેરાલ એઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ધન્ય હેય ચ્યે, જ્યેં યોકબિજાલ મેળાવનારેં હેય, કાહાકા ચ્યે પોરમેહેરા પોહેં આખાયી. ");
INSERT INTO gbl_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ધન્ય હેય ચ્યે, જ્યેં ન્યાયપણા જીવન જીવના લેદે સતાવણી પામતેહેં, કાહાકા હોરગા રાજ્ય ચ્યાહા હેતાં. ");
INSERT INTO gbl_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ધન્ય હેય તુમા, જોવે લોક તુમહાન મા શિષ્ય હેય, યા લેદે અપમાન કોઅરી, એને સતાવણી કોઅરી એને જુઠા બોલી બોલીન તુમહે વિરુદમાય બોદી રીતે ખારાબ વાતો આખરી. ");
INSERT INTO gbl_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","તોવે આનંદિત એને મગન ઓઅજા, કાહાકા તુમહેહાટી હોરગામાય મોઠો ઇનામ હેય, ચ્યાહાટી કા ચ્યાહાય ચ્યા ભવિષ્યવક્તાહાન જ્યા તુમહેથી બોજ પેલ્લા આતા ચ્યાહાન ચ્ચેજ પરમાણે સતાવણી કોઅયી.” ");
INSERT INTO gbl_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","“તુમા યા દુનિયા લોકહાહાટી મીઠાં રોકે હેય, બાકી જોવે મીઠાં હોવાદવોગાર ઓઅઇ જાય, તોવે ચ્યાલ કોઅહી વસ્તુકોય ખારાં કોઅવામાય યેય? પાછે તીં કાંઇજ કામ નાંય લાગે, સિવાય યા કા ચ્યાલ બાઆ ટાકી દેયના એને માઅહા પાગા તોળે છુંદી દેઅના. ");
INSERT INTO gbl_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","તુમા બોદા દુનિયા હાટી ઉજવાડા રોકે હેય, જીં શેહેર ડોગાવોય વસલાં હેય તીં દુબી નાંય હોકે. ");
INSERT INTO gbl_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","એને લોક દિવો લાવીન ચ્યાલ ટોપલ્યે તોળે નાંય થોવે, બાકી ચ્યાલ દીવત્યાવોય થોવતેહે, તોવે ચ્યા કોઇન બોદા માઅહા લોગુ ઉજવાડો પોઅચી હોકહે. ");
INSERT INTO gbl_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ચ્યાજ પરમાણે તુમહે ઉજવાડો માઅહા હોમ્મે ચોમકે કા ચ્યે તુમહે હારેં કામે એઇન તુમહે પોરમેહેર આબહો, જો હોરગામાય હેય, ચ્યા સ્તુતિ કોઅય.” ");
INSERT INTO gbl_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ઈ મા હોમજાહા, કા આંય મૂસા નિયમશાસ્ત્રાલ એને ભવિષ્યવક્તાહા લેખાલ નાશ કોઅરા યેનહો, આંય નાશ કોઅરા નાંય યેનહો, બાકી પુરાં કોઅરા યેનહો. ");
INSERT INTO gbl_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","કાહાકા આંય તુમહાન હાચ્ચાં આખતાહાવ કા, જાંઉ લોગુ આકાશ એને દોરતી જાતા નાંય રોય એને બોદ્યો ભવિષ્યવાણ્યો પુર્યો નાંઈ ઓઅરી, તાંઉલોગુ નિયમશાસ્ત્રા માઅને યોક કાનો કા યોક બિંદુ બી નાંય ઓટી. ");
INSERT INTO gbl_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","યાહાટી કા જીં કાદાં ચ્યા વાહની સે વાહની આગનામાયને યોકબી નાંય પાળે, એને તેહેકોયન ચ્યો લોકહાન હિકાડે, તો હોરગા રાજમાય બોદહા કોઅતો વાહનો ગોણાયી, બાકી જો કાદો ચ્યા પાલન કોઅરી એને ચ્યાલ હિકાડી, તો હોરગા રાજ્યામાય મોઠો ગોણાયી. ");
INSERT INTO gbl_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","કાહાકા આંય તુમહાન આખતાહાવ કા, જોવે તુમા મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોકહા ન્યાયપણા જીવન કોઅતા, તુમહે વોદારી ન્યાયપણા જીવન નાંય ઓઅરી, તે તુમા હોરગા રાજ્યામાય કોવેજ નાંય જાય હોકાહા.” ");
INSERT INTO gbl_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","“તુમા વોનાય ચુકલેં હેય, કા પોરમેહેરાય આમે આગલા ડાયા લોકહાન આખલા આતા કા ‘માઆઇ નાંય ટાકના,’ ‘એને જો કાદો માઆઇ ટાકી ચ્યાલ કોચર્યેમાય દોષ પાત્ર ગોણવામાય યી’. ");
INSERT INTO gbl_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","બાકી આંય તુમહાન આખતાહાવ કા જો ચ્યા બાહાવોય ગુસ્સો કોઅરી, ચ્યાલ પોરમેહેર સજા કોઅરી એને કાદો ચ્યા બાહાલ નોકામ્યા આખરી ચ્યાલ યહૂદીયાહા મોઠી સોબાયેમાય સજા કોઅરી; એને જો કાદો આખે ‘ઓ મૂર્ખ’ ચ્યાલ નરકા આગડા સજા દેવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","યાહાટી કા જોવે તું પોતાના દાન દેવાળામાય વેદ્યેવોય લેય યેનો, એને તાં તુલ યાદ યેય, કા કાદા માઅહા તુમહેકોય નુકસાન ઓઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","તોવે તું તીં દાન દેવાળામાય થોવી દે, એને જાયને પેલ્લા ચ્યા માઅહા આરે હોમજી લાં જો એને તોવે યેઇન તીં બેટ ચોડાવ. ");
INSERT INTO gbl_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","જો તું ફીરાદીવાળા આરે વાટે માંયજ હેય, ચ્યાઆરે જલદી હોમજી લે, એહેકેન નાંય બોના જોજે, કા તુલ તો ફીરાદ્યો ન્યાય કોઅનારાલ હોઅપી દેય, એને ન્યાય કોઅનારો તુલ સીપાડાલ હોઅપી દેય, એને સીપાડા તુલ જેલેમાય કોંડી દેય. ");
INSERT INTO gbl_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","આંય તુમહાન હાચ્ચાં આખતાહાવ કા, જાંઉ લોગુ બોદા પોયહા બોઅઇ નાંય દેય, તાંવ લોગુ તું જેલેમાઅને છુટી નાંય હોકહે.” ");
INSERT INTO gbl_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","તુમા જીં આગના આખલી હેય તી વોનાય ચુકલેં હેય કા, વ્યબિચાર મા કોઅહા. ");
INSERT INTO gbl_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","બાકી આંય તુમહાન આખતાહાવ કા જો કાદ્યે થેઅયેવોય ખારાબ નોજાર ટાકહે તો ચ્યે આરે પોતાના મોનામાય વ્યબિચાર કોઅઇ ચુકયોહો. ");
INSERT INTO gbl_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","જો તો જમણો ડોળો પાપા કારણ બોને, તોવે તું ચ્યાલ કાડીન ટાકી દે, કાહાકા તોહાટી ઈ હારાં હેય કા તો શરીરમાઅને યોક અવયવ નાશ ઓઅઇ જાય એને તો આખા શરીરાલ બોસામકોળીમાય નાંય ટાકલાં જાય. ");
INSERT INTO gbl_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","એને જો તો જમણો આથ પાપા કારણ બોને, તે ચ્યાલ કાપી ટાકીન ટાકી દે, કાહાકા તોહાટી ઈ હારાં હેય કા તો શરીરમાઅને યોક અવયવ નાશ ઓઅઇ જાય એને તો આખા શરીરાલ બોસામકોળીમાય નાંય ટાકલાં જાય. ");
INSERT INTO gbl_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","“ઇબી આખવામાય યેનેલ કા જો કાદો પોતે થેઅયેલ ફારગાતી દાં માગહે ચ્યેલ ફારગાતી દેય. ");
INSERT INTO gbl_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","બાકી આંય તુમહાન ઈ આખતાહાવ કા જો કાદો પોતા થેઅયેલ વ્યબિચાર સિવાય કાદા બિજા કારણથી ફારગાતી દેય, તે તો ચ્યેલ વ્યબિચાર કોઆડેહે, એને જો કાદો ફારગાતી દેનલ્યે આરે વોરાડ કોએ તે તો પોતે વ્યબિચાર કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","પાછે તુમા વોનાઈ ગીઅલે હેય કા પોરમેહેરેય આગલા ડાયા લોકહાન આખલા આતા કા, જુઠી કોસામ નાંય ખાઅના, બાકી પ્રભુહાટી કોસામ પુરી કોઅના. ");
INSERT INTO gbl_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","બાકી આંય તુમહાન ઈ આખતાહાવ કા, કોયદિહી કોસામ નાંય ખાઅના, નાંય હોરગા, કાહાકા તીં પોરમેહેરા સિંહાસન હેય. ");
INSERT INTO gbl_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","નાંય દોરત્યે, કાહાકા તીં ચ્યા પાગ થોવના જાગો હેય, નાંય યેરૂસાલેમ શેહેર કાહાકા તીં મોઠા રાજા શેહેર હેય. ");
INSERT INTO gbl_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","પોતાના ટોલપ્યે બી કોસામ નાંય ખાઅના કાહાકા તું યોક કીહ્યાલ બી ઉજળો નાંય કોઅઇ હોકે, કા નાંય કાળો કોઅઇ હોકતોહો. ");
INSERT INTO gbl_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","બાકી તુમહે વાત હાં તે હાં નાંય તે નાંય રા જોજે; કાહાકા જીં કાય ચ્યાથી વોદારે ઓઅરી તીં જુઠા કામહાથી એટલે સૈતાનથી ઓઅહે. ");
INSERT INTO gbl_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“તુમા વોનાઈ ગીઇલે હેતેં કા નિયમશાસ્ત્ર માય કાય લોખલાં હેય કા ડોળા બદલે ડોળો, એને દાતા બોદલે દાત. ");
INSERT INTO gbl_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","બાકી આંય તુમહાન ઈંજ આખતાહાવ કા, દુષ્ટા બોદલો નાંય લેઅના, બાકી જો કાદો તો જમણા ગાલાવોય થાપડે કોઇન ઠોકે, તે બિજો ગાલ બી ચ્યાએછે ફીરવી દે. ");
INSERT INTO gbl_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","એને જોવે કાદો તોવોય ન્યાયાલયામાય વિરુદ કોઇન તો ડોગલી માગે તોવે, ચ્યાલ કોટ બી દેય દેઅના. ");
INSERT INTO gbl_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","જો કાદો તુલ યોક કિ. મી. લેય જાંહાટી મજબુર બનાડે, તોવે ચ્યાઆરે તું બેન કિ. મી. દુઉ ચાલી જાજે. ");
INSERT INTO gbl_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","જો કાદો તોપાય માગે ચ્યાલ તું દે, એને જો કાદો તોપાય ઉસના માગે ચ્યાલ મુંય મા ફેરાવતો.” ");
INSERT INTO gbl_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","તુમા વોનાય ગીઇલે હેય કા, નિયમશાસ્ત્ર માય કાય લોખલાં હેય, તુમા બીજહા આરે પ્રેમ કોઅજા, એને તુમહે દુશ્માન વોય દુશ્માની કોઅજા. ");
INSERT INTO gbl_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","બાકી આંય તુમહાન આખતાહાવ કા, પોતાના દુશ્માનાહાવોય પ્રેમ કોઅજા એને આપહાલ સતાવણી કોએ ચ્યાહાહાટી પ્રાર્થના કોઅજા, ");
INSERT INTO gbl_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ચ્યાથી તુમા તુમહે હોરગ્યા આબહા પોહા બોનહા કાહાકા પોરમેહેર હારાં એને માઠાં લોકહાવોય દિહી દેહે, એને ન્યાયી એને અન્યાયી લોકહાહાટી પાઆઈ પાડહે. ");
INSERT INTO gbl_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","કાહાકા જોવે તુમા તુમહે પ્રેમ રાખનારાહાવોય પ્રેમ રાખહા, તોવે પોરમેહેર ચ્યા પ્રતિફળ નાંય દેય, કાહાકા કર લેનારા બી એહેકેનુજ કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","એને તુમા તુમહે બાહાહાલુજ સલામ કોઅતાહા, તે કોઅહા મોઠા કામ કોઅતાહા? કાહાકા ગેર યહૂદી બી, જ્યા પોરમેહેરા નિયમા પાલન નાંય કોએ, ચ્યા એહેકેનુજ કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","યાહાટી તુમા કાયામ તીંજ કોઆ જીં હારાં હેય, જેહેકોય તુમહે હોરગામાઅને આબહો જીં હારાં હેય તીંજ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“હાચવીન રા! તુમા લોકહાન દેખાડાહાટી હારેં કામે મા કોઅહા, નાંય તે હોરગામાઅને પોરમેહેરા પાયને કાયબી પ્રતિફળ નાંય મિળી.” ");
INSERT INTO gbl_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“યાહાટી જોવે તુમા દાન દેય, તોવે મોઠો દેખાવો મા કોઅહા, જેહેકોય ડોંગ્યા સોબાયેહે ઠિકાણાહામાય એને ગલ્યેહેમાય કોઅતાહા, જેથી લોક ચ્યાહા વાહાવા કોએ, બાકી તુમહાન આંય હાચ્ચાં આખતાહાવ કા ચ્યા ચ્યાહા પ્રતિફળ પામી ચુક્યાહા. ");
INSERT INTO gbl_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","બાકી તુમા જોવે દાન દાહા તીં એહેકેન દેયના કા કાદાલ ખોબાર નાંય પોડે કા તુયે કાય દેનહા. ");
INSERT INTO gbl_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","યાહાટી કા તો જીં દેનલા દાન દુબલાં રોય, તોવે પોરમેહેર તો આબહો જો ગુપ્તમાય એઅહે તો તુલ પ્રતિફળ દી.” ");
INSERT INTO gbl_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","“જોવે તુમા પ્રાર્થના કોઅહા, તોવે તુમા ડોંગ્યાહા રોકા નાંય કોઅના, કાહાકા લોકહાન દેખાડાહાટી ચ્યા લોક સોબાયેહે ઠિકાણામાય એને સોડકેહે ચોકડયેવોય ઉબા રોયન પ્રાર્થના કોઅના ચ્યાહાન હારાં ગોમહે. આંય તુમહાન હાચ્ચાંજ આખહુ કા ચ્યા લોક તે ચ્યાહા ઇનામ પામી ચુક્યાહા તી લોકહા વાહવા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","બાકી તું જોવે પ્રાર્થના કોએ, તોવે તો ખોલ્યેમાય જો, એને બાઅણા બંદ કોઇન તો આબહો જો ગુપ્તમાય હેય ચ્યાલ પ્રાર્થના કોઓ, તોવે તો આબહો તુલ ગુપ્તમાયને એઅહે, તુલ પ્રતિફળ દેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","પ્રાર્થના કોઅતી સમયે ગેર યહૂદી લોકહા રોકા શબ્દાહાલ પાછી-પાછી નાંય બોલના, કાહાકા ચ્યા હુમાજતાહા કા આમા વદારે બોલહુ તોવે તો વોનાઈ. ");
INSERT INTO gbl_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ચ્યાહાટી તુમા ચ્યાહા રોકા મા બોનહા, કાહાકા તુમહાન કોહડા ગોરાજ હેય ઈ તુમહે પોરમેહેર આબહો, તુમા ચ્યાપાય માગા પેલ્લાજ જાંઆઈ લેહે. ");
INSERT INTO gbl_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","યાહાટી તુમા યા પરમાણે પ્રાર્થના કોઆ: ઓ આમે પોરમેહેર આબા, તું જો હોરગામાય હેય, તો નાંવ પવિત્ર માનલા જાય. ");
INSERT INTO gbl_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","“તો રાજ્ય યેય, તો મોરજી જેહેકોય હોરગામાય પુરી ઓઅહે તેહેકોય દોરત્યેવોય બી ઓઅય. ");
INSERT INTO gbl_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","આમહાન રોજ દિહી ખાઅના દે જીં આમહાન ચ્ચા દિહા હાટી જોજહે. ");
INSERT INTO gbl_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","જેહેકોય જ્યાહાય આમે વિરુદ પાપ કોઅલા આતાં, ચ્યા વિરુદયાહાલ આમાહાય માફ કોઅયા, તેહેકોય તુંબી આમહે પાપહા માફ કોઓ. ");
INSERT INTO gbl_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","આમહાન પરીક્ષામાય મા ટાકહે, બાકી સૈતાના કામહાથી બોચાડ, (કાહાકા રાજ્ય એને પરાક્રમ એને મહિમા ઈ કાયામ તોજ હેય. આમેન.)” ");
INSERT INTO gbl_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“યાહાટી જોવે તુમા માઅહા પાપ માફ કોઅહા, તોવે પોરમેહેર, તુમહે આબહો જો હોરગામાય હેય, તુમાહાલ માફ કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","બાકી જોવે તુમા બિજા લોકહાન માફ નાંય કોઅહા, તો તુમહે હોરગામાઅને આબહો બી તુમહે પાપ માફ નાંય કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","“જોવે તુમા ઉપહા કોએ તે ડોંગ્યાહા રોકા તુમહે ચેહેરા નિરાશ મા રાખહા, કાહાકા ચ્યા લોક આમા ઉપહા હેજે એહેકેન આખાડાહાટી ચ્યાહા ચેહેરા ઉતાડતાહા. આંય તુમહાન હાચ્ચાં આખહુ કા ચ્યાહાન ચ્યા ઇનામ મિળી ગીયહા. ");
INSERT INTO gbl_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","બાકી જોવે તુમા ઉપહા રાખે તોવે તુમહે ટોલપીલ તેલ લાવા એને તુમહે મું દોવજા. ");
INSERT INTO gbl_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","યાહાટી કા લોક તુમહે ઉપહા નાંય જાંએ, બાકી તુમહે આબહો જો ગુપ્તમાય હેય, તુમહાન ઉપહા કોઅનારો જાંએ, તોવે તો આબહો જો ગુપ્તમાય એઅહે, તો તુમહાન પ્રતિફળ દેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","“આપહેહાટી દોરત્યેવોય મિલકાત મા બોઈ થોવહા, કાહાકા જાં કિડે એને કાટ બોગડાવતેહે, એને જાં બાંડ ગુઉ તોડીન ચોરી કોઅઇ લેય જાતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","બાકી આપહેહાટી હોરગામાય મિલકાત યોકઠી કોઆ, જાં ચ્યાલ ઉદાડા નાંય બોગડાવે, એને કાટ નાંય લાગે, એને બાંડ યેયન ચોરી બી નાંય કોએ. ");
INSERT INTO gbl_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","કાહાકા તો મોન કાયામ તાંજ લાગલા રોય જાં મિલકાત હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","“ડોળો શરીરાહાટી દિવા રોકો હેય: જોવે તો ડોળો ચોખ્ખો રોય, તોવે તો બોદા શરીર ઉજવાડામાય ઓરી. ");
INSERT INTO gbl_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","બાકી તો ડોળો ચોખ્ખો નાંય રોય, તે તો બોદા શરીરમાય આંદારાં ઓરી, યાહાટી જોવે તુમા બુલથી ઈ હુમાજતાહા કા તુમહે મોન ઉજવાડામાય હેય બાકી આસલીમાય આંદારામાય હેય, તે તુમહે આંદારને આંદારાં આસલીમાય બોજ કાળાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","કાદાબી માઅહું યોકાજ સમયે બેન દોણહ્યા ચાકરી નાંય કોએ, કાહાકા તો યોકા વિરુદ કોઅરી ને બિજાલ પ્રેમ કોઅરી, નાયતે યોકા આરે હારો ચાલી, એને બિજા આરે નાંય હારો ચાલી, તુમા પોરમેહેરા એને મિલકાત યા બેન્યાહા ચાકરી આરેજ નાંય કોઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","યાહાટી આંય તુમહાન આખહુ કા, શારીરિક જીવના ચિંતા મા કોઅહા કા આમા કાય ખાઉં, એને કાય પિયહું, એને નાંય તે આપહે શરીરા ચિંતા કોઅના, કા આમા કાય પોવહું. કાહાકા જીવન ખાઅનાથી, એને શરીર ફાડકાહા કોઅતા વોદારે કિમત્યા નાંય હેય કા? ");
INSERT INTO gbl_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","આકાશામાઅને ચિડહા એછે નોજાર કોઅયા ચ્યે વોએત નાંય, એને વાડેત નાંય, એને નાયતે કોઠયેમાય થોવેત તેરુંબી તુમહે હોરગામાઅને આબહો ચ્યાહાન ખાવાડેહે, તુમા તે ચ્યાહા કોઅતા બોજ કિમત્યા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","કાય તુમહેમાઅને કાદોબી જીવના બારામાય ચિંતા કોઅવાથી પોતે જીવન લાંબાવી હોકહે? ");
INSERT INTO gbl_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","“એને ફાડકાહાહાટી કાહા ચિંતા કોઅતાહા? જાડયેમાયને ફૂલજાડવાલ તુમા દિયાન કોઆ, ચ્યે કેહેકેન વોદતેહે, ચ્યે કાય મેહનાત નાંય કોએત, એને ચ્યે ફાડકે બી નાંય બોનાડે.” ");
INSERT INTO gbl_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","તેરુંબી આંય તુમહાન આખહુ કા, સુલેમાન રાજાબી ચ્યા ઓલીબોદી મિલકાત આતી તેરુંબી ચ્યાય ચ્યાહા હારકે સુંદર ફાડકે પોવલે નાંય. ");
INSERT INTO gbl_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","જો પોરમેહેર રાનામાઅને ગાહીયા તીં આજે હેય એને કાલે વાડીન આગડામાય ટાકી દી, ઓહડાલ તો હારાં બોનાડેહે તે ઓ વોછો બોરહો થોવનારાહાય, તો હાચ્ચોજ તુમહે દેખભાલ કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","“યાહાટી તુમા ચિંતા કોઇન ઈ મા આખહા, કા આમા કાય ખાહું, એને કાય પિયહું, એને કાય પોવહું? ");
INSERT INTO gbl_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","કાહાકા ગેર યહૂદી લોક યો બોદ્યો વાતો હોદતાહા, બાકી તુમહે હોરગામાઅને આબહો જાંઅહે કા તુમહાન ઈ બોદા જોજહે. ");
INSERT INTO gbl_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","યાહાટી તુમહેહાટી પેલ્લા ઈ મોહત્વા હેય કા, પોરમેહેરા રાજ્યા હોદ કોઅરા જોજે એને ન્યાયપણા જીવન જીવા જોજે, તોવે તુમહાન દોરત્યેવોયને બોદા વાના મિળી જાય. ");
INSERT INTO gbl_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","યાહાટી હાકાળ્યા દિહયા બારામાય ચિંતા મા કોઅહા, કાહાકા હાકાળ્યો દિહી આપેજ ચિંતા લી યી, આજ્યા દિહા હાટી આજ્યા દુઃખ બો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","“તુમા બિજા લોકહાવોય દોષ મા લાવહા, તે તુમાહાવોય બી બિજા લોક દોષ નાંય લાવી. ");
INSERT INTO gbl_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","કાહાકા જ્યે પરમાણે તુમા દોષ લાવતેહે, ચ્યેજ પરમાણે પોરમેહેર તુમાહાવોય બી દોષ લાવી, એને જ્યે રીતે, તુમા બીજહા ન્યાય કોઅતાહા, તેહેકોયજ પોરમેહેર તુમહે બી ન્યાય કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","તું તો બાહા વાહની-વાહની બુલહે ન્યાય કાહા કોઅતોહો, જીં ચ્યા ડોળામાઅને કોચરા રોકા હેય, તુલ તો મોઠયો-મોઠયો બુલ્યો નાંય દેખાય? ");
INSERT INTO gbl_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","જોવે તો પોતાનાજ જીવનમાય મોઠયો-મોઠયો બુલ્યો હેય, તે તુલ વાહની બુલ કોઅનારા કાદાબી માઅહા ન્યાય નાંય કોઅરા જોજે. ");
INSERT INTO gbl_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ઓ ડોંગી, પેલ્લો તો મોઠયો-મોઠયો બુલ્યો હુદરાવી લે, પાછે તું હારેં રીતે તો બાહા બુલ હુદરાવાહાટી ચ્યા મોદાત કોઅય હોકહે. ");
INSERT INTO gbl_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","“ચ્યા લોકહાન પોરમેહેરા વચન મા આખહા જ્યા ચ્યાલ વોનાયા નાંય માગે, જોવે તુમા એહેકેન કોઅહા, તે એહેકેન ઓઅરી જેહેકોય ચોખ્ખી વસ્તુ કુત્રહા આગલા ટાકી દેયના, એને ડુકરાહા આગલા મોતી ટાકના કાહાકા ચ્યે પાગહાતોળે ચ્યાહાન છુંદી ટાકી એને પાછે તુમહેવોય હમલો કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“તુમહાન જીં જોજે તીં પોરમેહેરાપાય માગા એને તો તુમહાન દી; હોદહા તે તુમહાન જોડી, ઠોકહા, તે તુમહેહાટી ઉગાડવામાય યી.” ");
INSERT INTO gbl_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","કાહાકા જો કાદો માગહે, ચ્યાલ મિળહે, એને જો કાદો હોદહે, ચ્યાલ જોડહે, એને જો કાદો ઠોકહે, ચ્યાહાટી ઉગાડી દેવામ યેહે. ");
INSERT INTO gbl_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","“જોવે પોહેં બાખે માગે, તોવે તુમહામાયને કાદો આબહો પોતે પોહાલ દોગડો નાંય દેય. ");
INSERT INTO gbl_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","યેજ રીતે, જોવે તુમહે પોહેં માછલા માગે, તોવે ચ્યાલ જેરીવાળા હાપડાં નાંય દેય. ");
INSERT INTO gbl_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","એને જોવે તુમા ખારાબ હેય, તેરી તુમા તુમહે પોહાહાન તુમા હાર્યો વસ્તુ દાં જાંઅતેહે, તે તુમહે હોરગામાઅને આબહો બી ચ્યાપાઅને જ્યેં માગતેહે ચ્યાહાન હારી વસ્તુ દેઅના જાંઅહે.” ");
INSERT INTO gbl_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","યાહાટી જીં કાય તુમા કોઆડાં માગતેહે કા લોક તુમહેઆરે કોએ, તુમાબી ચ્યાહાઆરે એહેકેનુજ કોઆ, કાહાકા મૂસા નિયમશાસ્ત્ર એને ભવિષ્યવક્તાહા શિક્ષણ બી ઈંજ હેય. ");
INSERT INTO gbl_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","“પોરમેહેરા રાજ્યામાય જાઅના વાટ હાકડા બાઅણા માઅને જાહે, કાહાકા નાશ એછે જાનારા બાઆં પોઅળા હેય, એને ચ્યા વાટ હેલ્લી હેય, એને ચ્યામાઅને માજા જાનારા લોક બોજ હેય. ");
INSERT INTO gbl_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","કાહાકા અનંતજીવનામાય જાયના બાઆં હાકડા એને વાટ કોઠણ હેય, એને જ્યાહાન તી વાટ જોડહે ચ્યા વોછાજ હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","જુઠા ભવિષ્યવક્તાહાથી હાચવીન રોયા, જ્યા ગેટાહા વેહે લેઈને તુમહેપાય યેતાહા, બાકી હકીકત માય ચ્યા ફાડી ખાનારા જોનાવરા હારકા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ચ્યાહા કામહાકોય તુમા ચ્યાહાન વોળખી લાહા, લોક જાડહા માઅને દારાખેં, એને કાટાહા જાડાહા પાયરે અંજીર નાંય તોડે. ");
INSERT INTO gbl_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","એને યેજપરમાણે હારાં જાડ હારાં ફળ દેહે એને નોકામા જાડ ખારાબ ફળ દેહે. ");
INSERT INTO gbl_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","હારાં જાડાલ ખારાબ ફળ નાંય લાગે, એને નોકામા જાડાલ હારાં ફળ નાંય લાગે. ");
INSERT INTO gbl_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","જીં-જીં જાડ હારાં ફળ નાંય દેય, તીં ખાંડીન આગડામાય ટાકી દેવામાય યી, જુઠા ભવિષ્યવક્તાહાલ બી યેજપરમાણે ડોંડ દી. ");
INSERT INTO gbl_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","યેજપરમાણે તુમા ચ્યાહા કામહાકોય વોળખી લાહા. ");
INSERT INTO gbl_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","“જ્યેં માન, ‘ઓ પ્રભુ! ઓ પ્રભુ!’ એહેકેન આખતેહે, ચ્યાહામાઅને બોદાંજ લોક હોરગા રાજ્યમાય નાંય જાય હોકી, બાકી તોજ જાય હોકી જો મા હોરગ્યા આબહા મોરજી પરમાણે જીવન જીવહે. ");
INSERT INTO gbl_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","એને ન્યાય કોઅના દિહી બોજ લોક માન એહેકેન આખરી, ઓ પ્રભુ, ઓ પ્રભુ, કાય આમહાય તો નાવાકોય ભવિષ્યવાણ્યો કોઅલ્યો, એને તો નાવાકોય બુતાહાલ આમાહાય કાડલા, એને તો નાંવે આમહાય બોજ મોઠે ચમત્કારા કામે કોઅલે. ");
INSERT INTO gbl_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","તોવે આંય ચ્યાહાન ચોખ્ખાં-ચોખ્ખાં આખહી, કા માયે તુમહાન કોવેજ નાંય જાંઅયા, ઓ ખારાબ કામ કોઅનારાહાય, મા પાહીને જાતા રોયા.” ");
INSERT INTO gbl_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“યાહાટી કા જો કાદો મા યો વાતો વોનાયને માનહે, તો ચ્યા બુદ્ધિવાળા માઅહા રોકો હેય, જ્યાંય પોતાના ગોઉ ખોલકડાવોય બાંદ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","પાછે પાંઈ પોડયો, નયાડો યેનો એને વેડાં યેના, એને તીં ચ્યા ગોઆલ જાય ઠોકાઈ, તેરુંબી તીં ગોઉ નાંય પોડ્યા, કાહાકા ચ્યા ગોઆ પાયો ખોલકડાવોય બાંદલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","બાકી જો કાદો મા યો વાતો વોનાયેહે એને નાંય પાળે, તો ચ્યા મૂર્ખ માઅહા રોકો હેય જ્યેય ચ્યા ગોઉ રેટાવોય બાંદ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","પાછે પાંઈ પોડયો, નયાડો યેનો, એને વેડાં યેના, એને ચ્યા ગોઆલ જાય ઠોકાઈ, એને તીં ટુટી પોડીન આતા નાંય આતા એહેકોય ઓઅઇ ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","જોવે ઈસુવે હિકાડના બંદ કોઅયા, તોવે એહેકેન જાયા કા ચ્યા હિકાડના બારામાય લોકહાન નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","કાહાકા તો મૂસા નિયમ હિકાડનારા ગુરુહુ રોકો નાંય, બાકી પુરાં ઓદિકારવાળા હારકો હિકાડે. ");
INSERT INTO gbl_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","જોવે ઈસુ ચ્યા ડોગાવોયને ઉત્યો તોવે યોક મોઠી ગીરદી ચ્યા પાહલા ગીયી. ");
INSERT INTO gbl_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","એને એઅયા યોક કોઢી માઅહું ઈસુવાપાય યેયન માંડયે પોડ્યા, એને આખ્યાં કા, “ઓ પ્રભુ, આંય જાંઅતાહાંવ કા તું તો ઇચ્છાકોય તું માન ચોખ્ખો કોઅઇ હોકતોહો.” ");
INSERT INTO gbl_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ઈસુવે આથ લાંબો કોઇન ચ્યા આથ દોઅયો, એને આખ્યાં, મા મોરજી હેય કા તું ચોખ્ખો ઓઅઇ જો “એને તો તારાતુજ કોઢમાયને ચોખ્ખો ઓઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ઈસુવે ચ્યાલ આખ્યાં એએ, તો કાદાલ એહેકેન આખના નાંય, કા માયે તુલ હારો કોઅયો બાકી જો એને યાજકાલ દેખાડ એને તું ચોખ્ખો ઓઅઇ ગીયો, ચ્યા બારામાય મૂસાય આગના કોઇન આખહી તી બેટ આઈન દે, ચ્યા લોકહા સાબિત્યે હાટી.” ");
INSERT INTO gbl_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","જોવે ઈસુ કાપરનાહુમ ગાવામાય યેનો તોવે યોક મુખ્ય જોમાદાર ઈસુપાય યેયન ચ્યાલ રાવ્યાં કોઅહે કા, ");
INSERT INTO gbl_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","ઓ પ્રભુ, મા ચાકાર ગોઅમે લોકવાકોય બિમાર હેય તો ગોઅમે પાથાર્યેવોય પોડલો હેય. ");
INSERT INTO gbl_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ઈસુવે ચ્યાલ આખ્યાં, “આંય યેયન ચ્યાલ હારો કોઅહી.” ");
INSERT INTO gbl_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","મુખ્ય જોમાદારાય જવાબ દેનો, “ઓ પ્રભુ, આંય યા લાયકે નાંય હેય કા તું મા ગોઅમે યેય, બાકી ઓલહાંજ આખી દે તે મા ચાકાર હારો ઓઅઇ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","કાહાકા આંયબી બિજા ઓદિકારા તાબામાઅને માઅહું હેતાંવ, એને મા તાબામાંય સિપાડાહા યોક ટુકડી હેય, જોવે આંય યોકાલ આખતાહાવ જો તોવે તો જાહાય, એને બિજાલ આખતાહાવ યે તોવે તો યેહે, એને જોવે મા ચાકારાલ આખતાહાવ ઈ કોઓ, તોવે તો કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ઈ વોનાઈન ઈસુવાલ નોવાય લાગી, એને જ્યેં ચ્યા પાહલા યી રીઅલે આતેં, આંય તુમહાન “હાચ્ચાંજ આખતાહાવ કા માયે ઈસરાયેલ દેશામાય બી યોક ઓહડા માઅહું નાંય દેખ્યહા, જો યા ગેર યહૂદ્યા હારકા માયેવોય બોરહો કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","એને આંય તુમહાન આખતાહાવ કા પૂર્વ એને પચ્છીમ એસને બોજ ગેર યહૂદી લોક યેઇન આબ્રાહામા એને ઈસાકા એને યાકૂબા આરે હોરગા રાજ્યામાય બોહરી.” ");
INSERT INTO gbl_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","બાકી રાજ્યા પાહાહાન એટલે યહૂદી લોકહાન બાઆ આંદારામાય ટાકલા જાય. તાં રોડના એને દાત કોકડાવના હેય. ");
INSERT INTO gbl_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","તોવે ઈસુવે જોમાદારાલ આખ્યાં, “ગોઓ જો, જેહેકોય તો બોરહો હેય તેહેકોયજ તોહાટી ઓઅરી” એને ચ્યેજ ગેડી ચ્યા ચાકાર હારો જાયો. ");
INSERT INTO gbl_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","જોવે ઈસુ સિમોન પિત્તરા ગોઓ ગીયો તોવે સિમોન પિત્તરા હાહુ બોજ જોરાવલી આતી. ");
INSERT INTO gbl_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ઈસુવે ચ્યે આથ દોઅયો એને ચ્યેમાઅને જોરાં તારાતુજ ઉતી ગીયા, એને ઉઠીન તી ઈસુ એને ચ્યા શિષ્યહા ગાવાર ચાકરી કોઅતી લાગી. ");
INSERT INTO gbl_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","જોવે જુંજડા પોડી ગીયા તોવે માઅહે ઈસુવાપાય બોજ જાત-જાત્યા દુખ્યાહાન એને જ્યાહામાય બુત વોળાગલા આતા ચ્યાહાન લેય યેને એને ઈસુવે ચ્યા બુતહાન ચ્યા વચના કોયન કાડી ટાક્યા, એને બોદા દુખ્યાહાન હારાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","યાહાટી કા જીં વચન યશાયા ભવિષ્યવક્તાથી આખલા આતા તીં પુરાં ઓઅઈ: “ચ્યાય પોતે આમે નોબળાયો પોતા ઉપે લેય લેદ્યો એને આમે રોગ ઉપે લેય લેદા.” ");
INSERT INTO gbl_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","લોકહા બોજ ગીરદી એઇન ઈસુય શિષ્યહાન આખ્યાં આપા દોરિયા ચ્યેમેરે જાતા. ");
INSERT INTO gbl_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","એને જેહેકેન તો જાંહાટી તિયાર જાયો યોક મૂસા નિયમ હિકાડનારો ગુરુ યેઇન ઈસુલ આખ્યાં, “ઓ ગુરુ, તું જાં કેછ જાહે, તાં આંય તોઆરે યીહીં.” ");
INSERT INTO gbl_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ઈસુય ચ્યાલ આખ્યાં “કોલાહા દોર હેતા એને આકાશામાય ઉડતા ચિડહા ગોરા હેતા, બાકી આંય, માઅહા પોહાપાય યોક ગુઉ બી નાંય હેય કા જાં આંય હૂવી હોકુ.” ");
INSERT INTO gbl_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","બિજો યોક શિષ્ય આખહે, “પ્રભુ, માન પેલ્લા મા ગોઓ જાં દે, મા આબહાલ, આંય ડાટી દેયન યીહીં, પાછે આંય યેયન તો શિષ્ય બોનહી.” ");
INSERT INTO gbl_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","બાકી ઈસુવે આખ્યાં, “તું મા શિષ્ય બોનાહાટી મા આરે યે, ચ્યાહાલ ચ્યાહા લોકહા મોઅના વાટ જોવાં દે.” ");
INSERT INTO gbl_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","પાછો ઈસુ ઉડીમાય ચોડયો એને ચ્યા શિષ્યબી ચ્યાઆરે ચોડયા. ");
INSERT INTO gbl_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","એને દોરિયામાય મોઠા વાવાઝોડા યેના, ઓલા બોદા કા ઉડી લાફાહા કોઇન બુડી જાં કોઅહે બાકી ઈસુ હુતલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","તોવે ચ્યાપાય યેઇન ચ્યાલ જાગાડયો એને આખ્યાં, “ઓ પ્રભુ, આમહાન બોચાવ, આપા બુડી જાં કોઅજેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ઈસુવે ચ્યાહાન આખ્યાં, “ઓ વોછો બોરહો કોઅનારાહાય, તુમા કાહા ગાબરાતાહા?” તોવે ચ્ચાય ઉઠીન વારાલ એને લાફાહાન દોમકાડયા, એને બોદા શાંત ઓઅઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","એને ચ્યા નોવાય પામીન આખા લાગ્યા કા, ઈ કોહડા માઅહું હેય કા વારો એને પાઆય બી ચ્યા આગના માનતેહેં. ");
INSERT INTO gbl_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","જોવે ઈસુ એને ચ્યા શિષ્ય દોરિયા ચ્યેમેરે ગીરાસિયા ભાગામાય જાય પોઅચ્યા તોવે બેન માઅહે જ્યાહામાય બુત વોળાગલા આતા ચ્યે માહાણા માઅને નિંગીન ચ્યાલ મીળ્યે ચ્યા ઓલા કોઠણ આતા કા, ચ્યે વાટયેમાઅને કાદો નાંય જાય હોકે. ");
INSERT INTO gbl_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ચ્યાહાય બોંબલીન આખ્યાં ઓ પોરમેહેરા પોહા તો આમહે આરે કાય કામ હેય? કાય તું સોમાયા પેલ્લા આમહાન આબદા દાં યેનહો? ");
INSERT INTO gbl_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ચ્યાહાથી વાહાયોક દુઉ યોક ડુકરાહા ટોળો ચોઅયા કોએ. ");
INSERT INTO gbl_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","તોવે બુતાહાય ઈસુલ એહેકેન રાવ્યાં કોઇન આખ્યાં, “આમહાન ડુકરાહામાય દોવાડ ચ્યાહામાય નિંગી જાહું.” ");
INSERT INTO gbl_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ઈસુવે ચ્યાહાન આગના દેની, તોવે બુત નિંગીન ડુકરાહામાય ઉરાય ગીયા, એને ડુકરાહા બોદો ટોળો કોરાડા ઉપને દોરિયામાય જાયન ટુટી પોડયો, એને બુડી મોઅયો, લગભગ બેન ઓજાર ડુકરાહા ટોળો આતો. ");
INSERT INTO gbl_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","એને ડુકરાહા ગોવાળ નાહી પોડ્યા, એને શેહેરામાય જાયને યે બોદયે વાતહેબારામાય એને જ્યાહામાય બુત આતા ચ્યા બારામાય બોદહાન ખોબાર દેની. ");
INSERT INTO gbl_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","તોવે શેહેરામાઅને બોજ લોક ઈસુવાલ મિળાહાટી બાઆ નિંગી યેના, એને ચ્યાલ એઇન વિનાંતી કોઅયી કા આમહે હોદ માઅને જાતો રો. ");
INSERT INTO gbl_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","પાછો ઈસુ ઉડીમાય બોહીન દોરિયો પાર કોઇન પોતાના ગાવામાય યેનો. ");
INSERT INTO gbl_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","એને કોલહાક લોક યોક લખવાવાળા માઅહાન ખાટલાવોય હુવાડીન ઈસુવાપાય લેય યેના, ઈસુવે જાંઅયા કા ચ્યા માયેવોય બોરહો થોવતાહા, ચ્યે લખવાવાળા માઅહાન આખ્યાં, “ઓ બાહા, ઈંમાત રાખ, તો પાપહાલ આંય માફ કોઅતાહાંવ.” ");
INSERT INTO gbl_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","એને કોલાહાક મૂસા નિયમ હિકાડનારા ગુરુ આતા ચ્યાહાય વિચાર કોઅયો, “એલો તે પોરમેહેરા નિંદા કોઅહે” ");
INSERT INTO gbl_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ઈસુવે ચ્યાહા મોના વિચાર જાંઆઈન આખ્યાં, “તુમા તુમહે મોનામાય કાહા ખારાબ વિચાર કોઅતાહા? ");
INSERT INTO gbl_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","કાય આખના હેલ્લા હેય? તો પાપ માફ ઓઅઇ ગીયા ઈ આખના હેલ્લા હેય, કા ઉઠ ચાલા લાગ, ઈ આખના હેલ્લા હેય? ");
INSERT INTO gbl_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","બાકી તુમહાન ખોબાર પોડા જોજે કા માન એટલે માઅહા પોહાલ દોરત્યેવોય લોકહા પાપ માફ કોઅના ઓદિકાર દેનલો હેય.” ચ્યાહાટી ઈસુ લખવાવાળા માઅહાન આખહે. “તુલ આંય આખતાહાવ, ઉઠ, તો ખાટલા લેઈને ગોઓ જો.” ");
INSERT INTO gbl_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","તો ઉઠીન ચ્યા ગોઓ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","લોક ઈ દેખીન બિઇ ગીયા એને પોરમેહેરા મહિમા કોઅરા લાગ્યા જ્યેં માઅહાન ઓહડો ઓદિકાર દેનહો. ");
INSERT INTO gbl_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","જોવે ઈસુ તાઅને આગલા ગીયો, માથ્થી નાંવા યોક માઅહાન કર લેઅના નાકાવોય બોઠલો દેખ્યો, એને ચ્યાલ આખ્યાં, “મા આરે ચાલ, આંય તુલ મા શિષ્ય બોનાવીહી.” તો કામ છોડીન ઈસુવાઆરે ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","જોવે ઈસુ એને ચ્યા શિષ્ય ગોઅમે રાતી ખાઅના ખાં બોઠલા આતા, તોવે બો બોદા કર લેનારા એને પાપી લોક ઈસુ એને ચ્યા શિષ્યહાઆરે ખાં બોઠા. ");
INSERT INTO gbl_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ઈ એઇન પોરૂષી લોકહાય ઈસુવા શિષ્યહાન આખ્યાં, “તુમહે ગુરુ કર લેનારાહા એને પાપી લોકહાઆરે કાહા ખાહે?” ");
INSERT INTO gbl_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ઈસુ ઈ વાત વોનાયો, એને મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોકહાન આખ્યાં, “જ્યેં હારેં હેતેં ચ્યાહાન ડાકટારા ગોરાજ નાંય રોય, બાકી જ્યેં દુખ્યેં હેતેં ચ્યાહાન ગોરાજ હેય. ");
INSERT INTO gbl_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","યાહાટી તુમા જાયને યા મોતલાબ હિકી લા, માન તુમહે બલિદાન નાંય જોજે, બાકી માન દયા ગોમહે, કાહાકા આંય ન્યાયી લોકહાન નાંય, બાકી પાપ્યાહાન બોચાવાં યેનોહો.” ");
INSERT INTO gbl_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","તોવે યોહાના શિષ્ય ઈસુપાય યેના એને ચ્યાહાય આખ્યાં કા “કાય કારણ હેય કા આમા એને પોરૂષી લોક ઉપહા કોઅતાહા, બાકી તો શિષ્ય ઉપહા નાંય કોએત.” ");
INSERT INTO gbl_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ઈસુવે ચ્યાહાન આખ્યાં, મા શિષ્ય એને આંય, વોવડા એને ચ્યા દોસ્તારા રોકા હેતા, “જાવ લોગુ વોવડો ચ્યાહા હાતે રોય, તાંવ લોગુ ઉપહા કોઅઇ હોકતાહા? બાકી ચ્યાહા પાયને વોવડો લેવાય જાય, ઓહડા દિહી યી તોદિહી ચ્યા ઉપહા કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","માઅહે જુના ફાડકા આરે નોવા ફાડકા ઠિગળા નાંય હિવેત, કાહાકા દોવ્યા પાછે નોવા ફાડકા ચંડળાય જાય એને જુના આજુ ચિઆઈ જાહે, એહેકેન તીં ફાડકા કામ નાંય લાગે. એહેકેન મા શિક્ષા જુની રીતીરીવાજાહા આરે જોડે, તે મા શિક્ષા યા ફાડકા હારકી કાયજ કામ નાંય લાગે. ");
INSERT INTO gbl_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","એને માઅહે નોવો દારાખા રોહો જુના ચાંબડા ઠેલ્યેમાય નાંય બોએત, કાહાકા ઠેલી ફાટી જાય, એને દારાખા રોહો વેરાય જાય બાકી નોવો દારાખા રોહો નોવ્યે ઠેલ્યેમાયજ બોઅતેહેં, એને બેની હારેં હાચવાય રોતેહેં. ");
INSERT INTO gbl_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","તો ચ્યાહાન ઈ વાત આખહે, તોવે યાઈર નાંવા સોબાયે ઠિકાણા આગેવાનાહા માઅને યોક યેનો એને ઈસુવા પાગે પોડયો. એને યાઈર બોજ રાવ્યો કોઅતો લાગ્યો, “મા વાહની પોહી આમી મોઓઈ ગીયહી, બાકી તું યેઇન ચ્યેલ આથ લાવહે, તોવે તીં જીવતી ઓઅઇ જાય” ");
INSERT INTO gbl_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ઈસુ ઉઠયો એને ચ્યા શિષ્યહાઆરે ચાલ પોડયો. ");
INSERT INTO gbl_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","એને યોક બાઈ ચ્યે બારા વોરહાથી લોય પોડના બિમારી આતી, તી ચ્યા પાહલા યેની એને ફાડકા છેડાલ આથ લાવ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","કાહાકા તી પોતે મોનામાય આખતી આતી, કા જોવે એલા ફાડકાલુજ આથ લાવહી તોવે મા બોચાવ ઓઅઇ જાય. ");
INSERT INTO gbl_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ઈસુવે ચ્યે એછે ફિરીન ચ્યેલ આખ્યાં, બોઅહી ઈંમાત રાખ, માયે તો બોચાવ કોઅલો હેય કાહાકા તુયે માયેવોય બોરોહો કોઅલો હેય, આમી તુલ એલી બિમારી નાંય લાગે તોવે તી બાય તારાત હારી ઓઅઇ ગીયી. ");
INSERT INTO gbl_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ઈસુ સોબાયે ઠિકાણા આગેવાના ગોઓ યેનો, તાં થાળી તુર વાજાડનારાહાલ એને લોકહાન કાકાહા કોઅતા દેખ્યા, ");
INSERT INTO gbl_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","તોવે ચ્યે આખ્યાં, “હોરકી જાં, પોહી મોઅયીહી નાંય, બાકી હુતહી” તોવે ચ્યા ઓહરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","બાકી જોવે ચ્યે લોકહા ટોળાલ બાઆ કાડી દેના, એને ચ્યે ગોઅમે જાયન પોહયે આથ દોઅયો એને તી જીવી ઉઠી. ");
INSERT INTO gbl_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","એને યે વાતે ખોબાર ચ્યા બોદા ગાવહામાય ફેલાય ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","તાઅને ઈસુ આગલા ગીયો તોવે બેન આંદળા ચ્યા પાહાલાને બોંબાલતા લાગ્યા કા, “ઓ દાઉદ રાજા કુળા પોહા, આમહાવોય દયા કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","જોવે તો ગોઅમે ગીયો, તોવે ચ્યા બેની આંદળા ચ્યાપાય યેના ઈસુવે ચ્યાહાન પુછ્યાં, “કાય તુમહાન બોરહો હેય, કા આંય હારાં કોઓઇ હોકહુ?” ચ્યાહાય આખ્યાં “આમા બોરહો કોઅજેહે કા તું હારો કોઅઇ હોકતોહો.” ");
INSERT INTO gbl_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","તોવે ઈસુવે ચ્યાહા ડોળાહાલ દોઇન આખ્યાં કા “તુમા બોરહા કોઅતાહા યાહાટી તુમહાન હારાં કોઅતાહાંવ.” ");
INSERT INTO gbl_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","તોવે ચ્યાહા ડોળા હારાં ઓઅઇ ગીયા, એને ઈસુવે ચ્યાહાન આખ્યાં, “હાચવીન રા, ઈ કાદાલ નાંય ખોબાર પોડા જોજે કા માયે કોઅયા.” ");
INSERT INTO gbl_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","બાકી ચ્યાહાય જાયને ચ્યા કામહા બારામાય બોદા ભાગામાય આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","જોવે ચ્યા બેની આંદળા વાટે જાય રીઅલા આતા, તોવે લોક યોક મુકા માઅહાલ, જ્યાલ બુત વોળાગલો આતો ઈસુપાય લેય યેને. ");
INSERT INTO gbl_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","એને જોવે બુતાલ કાડયા પાછે, મૂકો બોલતો લાગ્યો. ચ્ચાથી ગીરદીય નોવાય પામીન આખ્યાં, “ઈસરાયેલ દેશામાય ઓહડા કોવેજ નાંય દેખહયા” ");
INSERT INTO gbl_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","બાકી પોરૂષી લોકહાય આખ્યાં કા, “તો સૈતાન બુતાહા મુખ્ય હેય ચ્યા મોદાત લેઈને બુતાહાન તાંગાડેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","એને ઈસુ ગાલીલ વિસ્તારમાય એને બોજ શેહેરાહામાય એને ગાવહામાય ફિરીન, ચ્યાહા સોબાયે ઠિકાણામાય હિકાડે, એને પોરમેહેરા રાજ્યા હારી ખોબાર આખતો એને માઅહામાયને બોદે જાત્યા બિમારી એને ચ્યાહામાઅને નોબળાય દુઉ કોઅતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","લોકહા ટોળા એઇન, ચ્યાહાવોય ચ્યાલ દયા યેની, ચ્યે ચ્યા ગેટાહા રોકે આતેં જ્યાહા ગોવાળ નાંય હેય, લાચાર એને ટાકાલાહા રોકે આતેં. ");
INSERT INTO gbl_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","તોવે ઈસુય ચ્યા શિષ્યહાન આખ્યાં, “જેહેકોય રાનહા માય બોજ પાક રોહે, તેહેકોય બોજ લોક હેય, જ્યા પોરમેહેરા હારી ખોબારેવોય બોરહો કોઅરાહાટી તિયાર હેય, બાકી પોરમેહેરા રાજ્યા બારામાય આખનારા લોક વોછા હેતા. ");
INSERT INTO gbl_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","યાહાટી તુમા પાક વાળા માલિકાલ વિનાંતી કોઆ કા તો રાનામાય કામ કોઅનારા લોકહાન દોવાડે.” ");
INSERT INTO gbl_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","પાછે ઈસુવે ચ્યા બાર શિષ્યહાન હાદિન, બુતાલ લોકહામાઅને કાડના ઓદિકાર દેનો એને બોદયે જાત્યા રોગ એને દુઃખ હારાં કોઅના ચ્યાહાન ઓદિકાર દેનો. ");
INSERT INTO gbl_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","એને બાર પ્રેષિતાહા નાંવે યેં હેતેં: પેલ્લો, સિમોન જ્યાલ પિત્તર આખવામાય યેહે એને ચ્યા બાહા આંદ્રિયાસ, જબદયા પોહો યાકૂબ, એને ચ્યા બાહા યોહાન. ");
INSERT INTO gbl_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ફિલિપ, એને બારતોલોમી, થોમા, એને જકાતદાર માથ્થી, અલફિયા પોહો યાકૂબ, એને તદે. ");
INSERT INTO gbl_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","સિમોન કનાની, એને યહૂદા ઇસ્કારીયોત જ્યેં ચ્યાલ દોઅવાડી દેનેલ. ");
INSERT INTO gbl_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","યા બાર શિષ્યહાન ઈસુવે એહેકેન આખીન દોવાડયા કા: “ગેર યહૂદી લોકહામાય જાતા મા, એને સમરૂના કોઅહાબી શેહેરામાય ઉરાયાહા મા. ");
INSERT INTO gbl_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","બાકી તુમા ઈસરાયેલ દેશા કુટુંબમાય ટાકાલા ગેટાહા એછે જાજા. ");
INSERT INTO gbl_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","એને જાતા-જાતા તુમા એહેકેન હારી ખોબાર આખજા: કા હોરગા રાજ્ય પાહી યેય ગીઅલાં હેય. ");
INSERT INTO gbl_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","દુખ્યાહાન હારેં કોઅયા, મોઅલાહાન જીવતે કોઅરા, કોડળ્યાહાન હારેં કોઅયા, એને બુતાહાન કાડી ટાકજા, તુમાહાય મોફાત મેળવ્યાહાં તે મોફાત દા. ");
INSERT INTO gbl_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","તુમા તુમહે પાકીટ માય હોના, રુપાં નાયતે તાંબા લાહા મા. ");
INSERT INTO gbl_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","વાટેહાટી ઠેલી મા લાહા, નાંય બેન જોડ ફાડકે લેતા, નાંય બેન જોડ વાઅણે એને બેન લાકડયોબી મા લેતા. કાહાકા કામ કોઅનારાલ ચ્યા ખાઅના મિળાં જોજે.” ");
INSERT INTO gbl_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","“એને જ્યા કોઅહાબી શેહેરામાય નાયતે ગાવહામાય જાહા, તે ચ્યે માન એહેકેન પુછ્યાં કા ઈહીં કું હારો હેય એને જાંઉ લોગુ તાંઅરે નાંય જાહા, તાંઉલોગુ ચ્યાજ ગોઅમે રોજા. ");
INSERT INTO gbl_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ગાઆમાય જાતાંજ ચ્યાહાલ બોરકાત દેજા. ");
INSERT INTO gbl_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","એને તીં ગુઉ બોરકાતે લાયક્યે ઓઅરી તે તુમહે સુખ શાંતી ચ્યાહાવોય જાય, બાકી તીં લાયક્યે નાંય ઓઅરી તે તુમહે સુખ શાંતી તુમહેપાય વોળી યેઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","એને જાં તુમહાન લોક નાંય હાદેત એને તુમહે નાંય હાંબળેત, તાંઅરે નિંગી જાયા, એને ચ્યાહાન નિશાણી દાંહાટી, તુમહે પાગહા આરેને ઉદળાં તાંજ ખેખરી ટાકજા, ચ્યાહાન ઈ ચેતાવણી દાંહાટી કા પોરમેહેરા એહેરે મિળનારી સજા ચ્યા પોતેજ જાબાવદાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","આંય તુમહાન હાચ્ચાં આખતાહાવ, ન્યાયા દિહી ચ્યા શેહેરા દશા સદોમ એને ગમોરા શેહેરા કોઅતા વોદારી સાજા મિળી એને યાહા હાલાત બોજ ખારાબ ઓઅઇ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“એઆ, આંય તુમહાન ગેટાહા હારખો તોઅસાહા વોચમાય દોવાડતાહું, ચ્યાહાટી હાપડાહા હારખા બોજ ઉશારી રોજા એને કબુતરાહા હારખા બોળા બોના. ");
INSERT INTO gbl_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","બાકી તુમા લોકહાપાઅને હાચવીન રા, કાહાકા લોક તુમહાન કોચર્યેમાય લી જાય એને સોબાયે ઠિકાણાહામાય માર દી. ");
INSERT INTO gbl_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","તુમા માંહાટી સરકારા, એને રાજહા આગલા એને ગેર યહૂદી લોકહાવોય સાક્ષી બોનાહાટી ઉબા કોઅલા જાહા. ");
INSERT INTO gbl_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","જોવે તુમહાન ચ્યે કોચર્યેમાય દોઅવાડી દેય, તોવે કેહેકેન બોલના એને કાય આખના ચ્યા ચિંતા મા કોઅહા, કાહાકા જીં કાય તુમહાન આખના હેય તીં ચ્યે સમયે આખાડી.” ");
INSERT INTO gbl_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","કાહાકા આખનારે તુમા નાંય હેય, બાકી તુમહે પવિત્ર આત્મા તુમહેકોય બોલી. ");
INSERT INTO gbl_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ચ્યે સમયે, જ્યા લોક માયેવોય બોરહો નાંય કોએત, “ચ્યા ચ્યાહા બાહાહાલ દોઇન કોંડાડી દી, જ્યા માયેવોય બોરહો કોઅતાહા ચ્યાહાન માઆઇ ટાકી, આબહો પોતે પાહાહા આરે એહેકેન કોઅરી એને પોહેં પોતે આયહે આબહા વિરુદ કોઅરી એને ચ્યાહાન માઆઇ ટાકી.” ");
INSERT INTO gbl_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","કાહાકા તુમા મા શિષ્ય હેય યા લેદે, બોદે માઅહે તુમહેઆરે દુશ્માની કોઅરી; બાકી જ્યા લોક માયેવોય બોરહો કોઅનામાય લાગી રોય, એને દોરત્યેવોય ચ્યા જીવના છેલ્લે હુદી મા પાહલા ચાલતો રોય, ચ્યાલ પાપહા ડોંડ બોગાવનાથી તારણ ઓઅઇ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","જોવે તુમહાન ચ્યે યોકા શેહેરામાય સતાવે, તોવે બિજા શેહેરામાય નાહી પોડજા, આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, તુમા આંય, માઅહા પોહા યેઅના પેલ્લા ઈસરાયેલ દેશા બોદા ગાવાહામાય ગીયા બી નાંય ઓરી. ");
INSERT INTO gbl_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“શિષ્ય ચ્યા ગુરુઆ કોઅતા મોઠો નાંય રોય, એને દોણ્યા કોઅતા મોઠો ચાકાર નાંય રોય. ");
INSERT INTO gbl_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ગુરુઆ હારખા શિષ્ય, એને ચાકાર દોણ્યા હારખો બોનના તીંજ બો હેય; જોવે ચ્યાહાય ગોઆ દોણ્યાલ સૈતાન જો બુતાહા મુખ્ય આખ્યાં, જો ચ્યે દોણ્યા આરે ખારાબ વ્યવહાર કોઅતેહે, તે ચ્યે ચ્યા ચાકારાહા આરેબી ખારાબ વ્યવહાર કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ચ્યાહાટી માઅહાન ગાબરાના નાંય; કાહાકા કોઅહીજ વસ્તુ ઓહડી નાંય હેય કા તી ડાકલી રોય એને યોકતી વસ્તુ ઓહડી નાંય હેય કા તી દુબાડી હોકાય બાકી બોદાજ ખુલ્લાં પોડી જાય.” ");
INSERT INTO gbl_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","આંય જીં તુમહાન આંદારામાય આખતાહાવ, તીં તુમા ઉજવાડામાય આખી દિયા; એને જો આંય કાનામાય દુંદરીન આખતાહાવ, તીં તુમા બોદે જાગે આખા. ");
INSERT INTO gbl_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","જ્યેં શરીરાલ માઆઇ ટાકી હોકતેહેં, બાકી ચ્યે આત્માલ નાશ નાંય કોઅઇ હોકે, ચ્યાહાન મા ગાબરાયાહા, બાકી જો શરીર એને આત્મા બેન્યાહાન બોસામકોળીમાય ટાકી હોકહે ચ્યા પોરમેહેરાલ ગાબરાજા. ");
INSERT INTO gbl_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","હાકરીયેં ચિડેં બોજ હોયતે વેચાતેહે, તેરુંબી તુમહે હોરગ્યા આબહા મોરજી વોગાર ચ્યાહામાઅને યોકબી દોરતીવોય નાંય ટુટી પોડે. ");
INSERT INTO gbl_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","પોરમેહેર તુમહે જીવના બોદી ચિંતા કોઅહે, તો ઇબી જાંઅહે કા તુમહે ટોલપીવોય કોલહા કીહીં હેય. ");
INSERT INTO gbl_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","યાહાટી તુમા મા બીયહા, તુમા બોજ ચિડહા કોઅતાબી કિમત્યા હેતા. ");
INSERT INTO gbl_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","“જીં માઅહું લોકહા હોમ્મે માની લેહે, તો મા શિષ્ય હેય, આંયબી મા હોરગામાઅને આબહાલ આખી દિહીં કા ઓ મા શિષ્ય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","બાકી જીં માઅહું માન માઅહા હોમ્મે નાંય માને, તે ચ્યાલ આંયબી મા હોરગામાઅને આબહાલ આખી દિહીં કા ઓ મા શિષ્ય નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ઈ મા હુમાજતા કા આંય દોરત્યેવોય લોકહાવોચમાય શાંતી દાં યેનોહો, આંય દોરત્યેવોય લોકહાવોચમાય શાંતી નાંય બાકી જગડો કોઆડાં યેનહો. ");
INSERT INTO gbl_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","આંય યાહાટી યેનોહો કા: પોહાલ ચ્યા આબહા આરે, એને પોહયેલ આયહે આરે, એને વોવલ્યેહેન હાઅવેહે આરે, વિરુદ કોઅઇ દાવ.” ");
INSERT INTO gbl_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","“માઅહા વિરુદયે ચ્યા પોતે ગોઅને માઅહેજ રોય.” ");
INSERT INTO gbl_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","જીં માઅહું આબહાલ યા આયહેલ મા કોઅતો બોજ પ્રેમ કોઅહે, તીં માઅહું મા શિષ્ય બોના લાયકે નાંય હેય, એને જીં માઅહું પોહા યા પોહયેલ મા કોઅતો બોજ પ્રેમ કોઅહે, તીં મા શિષ્ય બોના લાયકે નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","જીં માઅહું મા શિષ્ય ઓઅના લીદે દુઃખ નાંય વેઠે એને મોઅરાંહાટી તિયાર નાંય ઓએ, તીં મા શિષ્ય બોના લાયકે નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","જીં માઅહું પોતે જીવ બોચાડેહે, તો ચ્યાલ ગુમાવી દી, એને જો મા લીદે ચ્યા જીવ દેહે, તો ચ્યાલ મેળવી. ");
INSERT INTO gbl_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“જો કાદોબી મા લીદે એહેકેન યોકા પોહાલ દોયા દેખાડેહે, તો હાચ્ચાંજ મા માની લેહે, જો કાદો મા માની લેહે, તો હાચ્ચાંજ પોરમેહેરાબી માની લેહે જ્યાંય માન દોવાડયોહો.” ");
INSERT INTO gbl_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","જીં માઅહું ભવિષ્યવક્તાલ ભવિષ્યવક્તા જાંઆઈન માનહે, ચ્યાલ ભવિષ્યવક્તા હારખો ઇનામ મિળી; જીં હારાં માઅહું હોમજીન હારાં માઅહાન માનહે, ચ્યાલ હારાં માઅહા હારખા ઇનામ મિળી. ");
INSERT INTO gbl_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","જો કાદો યોક ગોલાસ પાઆઈ તુમહાન યાહાટી પાજી કા તુમા મા શિષ્ય આખાતાહા, આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા પોરમેહેર નોક્કીજ ચ્યા માઅહાન ઇનામ દેઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","જોવે ઈસુવાય ચ્યા બારા શિષ્યહાન આગના દેની, તોવે તો ચ્યાહા ગાવહામાય હિકાડાં એને હારી ખોબાર આખાહાટી જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","યોહાન બાપતિસ્મા દેનારાય જેલેમાય રોયન ખ્રિસ્તા કામહા બારામાય વોનાયો એને ચ્યાય ચ્યા શિષ્યહાન ઈ પુછા હાટી દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ચ્યાહાય ઈસુલ પુછ્યાં, “કાય તો તુંજ ખ્રિસ્ત હેય, જ્યાલ દોવાડના વાયદો પોરમેહેરાય કોઅલો આતો, કા આમા યોકતા બિજા વાટ જોવજે?” ");
INSERT INTO gbl_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ઈસુવાય જાવાબ દેનો, “જીં તુમા વોનાતાહા એને એઅતાહા, તીં બોદા જાયને યોહાનાલ આખી દા.” ");
INSERT INTO gbl_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","કા આંદળે દેખતેહે એને લેંગડે ચાલતે ફીરતેહે, કોડળેં હારાં કોઅવામાય યેતહે એને બોઅરે વોનાતેહે, મોઅલે જીવતે ઊઠતેહે એને ગરીબાહાલ હારી ખોબાર આખવામાય યેહે. ");
INSERT INTO gbl_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","એને ધન્ય હેય જીં, માયેવોય શંકા નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","જોવે યોહાના શિષ્ય તાઅને જાતા લાગ્યા, તોવે ઈસુ યોહાના બારામાય લોકહાન આખતો લાગ્યો કા, તુમા ઉજાડ જાગામાય કાય એરાહાટી ગીઇલે? કાય વારાકોય આલનારા બુરળ્યા? ");
INSERT INTO gbl_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","પાછી તુમા કાય એરા ગીઇલે? મોઅગેં ફાડકે પોવલા લોકહાન કા? એઆ મોઅગેં ફાડકે પોવતેહે ચ્યે રાજમેહેલામાય રોતેહેં. ");
INSERT INTO gbl_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","તોવે તુમા કાય એરા ગીઇલે? ભવિષ્યવક્તાહાલ એરા કા? હાં, આંય તુમહાન આખતાહાવ, બાકી ભવિષ્યવક્તાહા કોઅતાબી મોઠો હેય. ");
INSERT INTO gbl_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","યોહાન બાપતિસ્મા દેનારો, તો માઅહું હેય, જ્યા બારામાય પવિત્રશાસ્ત્રામાય પોરમેહેર આખહે: એએ, આંય તો પેલ્લા મા સંદેશ લેય યેનારાલ દોવાડતાહાવ, જો તો પેલ્લા તોહાટી વાટ તિયાર કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","તુમહાન આંય હાચ્ચાં આખતાહાવ, કા જ્યા થેએયેથી જોન્માલ યેનલા હેય, ચ્યાહામાઅને યોહાન બાપતિસ્મા દેનારા કોઅતા કાદો મોઠો નાંય, તેરુંબી હોરગા રાજ્યામાય વાહનો ચ્યા કોઅતો મોઠો હેય. ");
INSERT INTO gbl_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","જોવેને યોહાન બાપતિસ્મા દેનારાય સંદેશ દેયના સુરુ કોઅયા, ચ્યા દિહા પાયને આમી લોગુ હોરગા રાજ્યા હારી ખોબાર આખલી જાહે, એને બોદેજ યામાય ભાગીદાર ઓઅતેહે, યા દુનિયા ખારાબ લોક ચ્યાહાન નાશ કોઅરા કોશિશ કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ભવિષ્યવક્તાહા બોદ્યો ચોપડયો એને મૂસા નિયમશાસ્ત્રામાય યોહાન બાપતિસ્મા દેનારા યેયના લોગુ રાજ્યા બારામાય ભવિષ્યવાણી કોઅલી આતી. ");
INSERT INTO gbl_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","જો તુમા હાચ્ચાં યે વાતેહેવોય બોરહો કોઅતેહે તે વોનાયા, ઓ યોહાનુજ એલીયા હેય, જ્યા યેઅના બારામાય ભવિષ્યવક્તાહાય આખલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","જો વોનાયાંહાટી તિયાર હેય તો વોનાય લેય એને ચ્યા બારામાય હુમજે. ");
INSERT INTO gbl_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","બાકી ઈ પીડી કોહડી હેય? ઈ પીડી ચ્યા પાહહા રોકી હેય જ્યા આટામાય બોહીન હાંગાત્યાહાન હાત કોઇન આખતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","આમાહાય તુમહેહાટી વોરાડા ગીતે લાવ્યે એને તુમા નાચ્યા નાંય, આમાહાય રોડના ગીતે આખ્યે, બાકી તુમા નાંય રોડયા. ");
INSERT INTO gbl_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","કાહાકા જોવે યોહાન બાપતિસ્મા દેનારો યેનો તોવે તો બોજ ઉપહા કોઅતો આતો, એને દારાખા રોહો નાંય પિતો આતો, એને તુમાહાય આખ્યાં, ચ્યામાય બુત હેય. ");
INSERT INTO gbl_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","બાકી જોવે આંય, માઅહા પોહો સાદા ખાઅના ખાતો એને પાઆય એને દારાખા રોહો પિતો આતો, તોવે તુમા આખતા લાગ્યા “એઆ તો ખાદાડ એને સાકાટ માઅહું, કર લેનારાહા એને પાપહયા હાંગાત્યો હેય, તેરુ માઅહા કામહાકોય સાબિત ઓઅહે કા જ્ઞાની કું હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","પાછે જ્યા શેહેરામાય ઈસુય બોજ મોઠે ચમત્કારા કામે કોઅલે તાઅને લોકહાન તો ઠોપકાડતો લાગ્યો, કાહાકા ચ્યાહાય પાપ કોઅના બંદ નાંય કોઅયેલ. ");
INSERT INTO gbl_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“હાય ચ્યા લોક જ્યા ખુરાજીઈન શેહેરામાય રોતહા, હાય ચ્યા લોક જ્યા બેતસાદા ગાવામાય રોતહા, કાહાકા તુમહેમાય જ્યેં કામે કોઅલે તોહડે ચમત્કારા કામે જોવે સુર એને સિદોના શેહેરામાય ઓઅતે તોવે ચ્યા લોક બોજ પેલ્લા ઉપહા કોઇન, ટોલપાવોય બુંબર્યા ખેખરી લેતા, ચ્યા ઈ દેખાડાં હાટી કા પાપ કોઅના બંદ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","બાકી આંય તુમહાન આખતાહાવ, ન્યાયા દિહી, જીં સાજા સુર એને સિદોનાલ દી, તી સાજા બોજ વોછી હેય જીં સાજા તુમહાન દી. ");
INSERT INTO gbl_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","એને કાપરનાહુમ ગાવા લોકહાય, કાય તુમા હોરગા લોગુ ઉચા ઓઅના આશા કોઅઇ રીઅલા હેય? તુમા નિચે અધોલોકમાય પાડી ટાકલા જાહા, કાહાકા તુમહેમાય જ્યેં મોઠે ચમત્કારા કામે કોઅલે તોહડે સદોમ શેહેરમાય કોઅલે રોતે તોવે તો આજેલોગુ રોતો” ");
INSERT INTO gbl_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","બાકી તુમહાન આંય આખતાહાવ કા, ન્યાયા દિહી, જીં સાજા સુર એને સદોમ શેહેરાલ દી, તી સાજા બોજ વોછી હેય જીં સાજા તુમહાન દી. ");
INSERT INTO gbl_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ચ્યે સમયે ઈસુવે આખ્યાં, ઓ આબા, હોરગા એને દોરતી પ્રભુ, તો આભાર માનતાહાવ કાહાકા તુયે યો બોદ્યો વાતો ઓકલ્યેવાળા લોકહાન એને હોમાજદાર લોકહાન નાંય, બાકી જ્યા લોક સાદા સુદા હેય ચ્યાહાન દેખાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","હાં, ઓ આબા, કાહાકા તુલ ઈંજ ગોમ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","મા આબહે માન બોદો ઓદિકાર દેય દેનહો, એને આબા સિવાય કાદો પાહાલ નાંય જાંઆય, તેહેકોયજ પાહા સિવાય કાદો આબહાલ નાંય જાંઆય, એને જ્યા લોકહાન આંય, પોહો નિવાડતાહાવ, ચ્યા લોક આબહાલ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ઓ બોદા મેહનાત કોઅનારાહાય, એને વોજાકોય દાબાલા લોકહાય તુમા મા પાહાય યા તુમહાન આંય દિલાસો દિહી. ");
INSERT INTO gbl_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","તુમા મા શિષ્ય બોના, માયે પાયને હીખી લીયા કાહાકા આંય નમ્ર એને દિન હેતાઉ એને તુમહે જીવાલ દિલાસો મિળી. ");
INSERT INTO gbl_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","જીં આંય આખતાહાવ કા તીં તુમા કોઆ, તીં કોઅના કઠીણ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","યોક આરામા દિહી, ઈસુ એને ચ્યા શિષ્ય રાનામાઅને જાતા આતા, એને ચ્યા શિષ્યહાન બુખ લાગી તોવે શિષ્ય કોઅહે પેંદી ખાં લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","તોવે પોરૂષી લોક ઈ એઇન ઈસુલ આખ્યાં, “એએ, તો શિષ્ય જીં કામ આરામા દિહી કોઅઇ રીઅલા હેય, તીં આમે નિયમા વિરુદ હેય, તુયે ચ્યાહાન એહેકેન નાંય કોઅરાહાટી આખા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ઈસુવે ચ્યાહાન આખ્યાં, “કાય તુમાહાય નાંય વાચ્યાહાં, કા દાઉદ રાજાય, જોવે ચ્યા હાંગાત્યાહાન બુખ લાગી તોવે કાય કોઅયેલ? ");
INSERT INTO gbl_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","તોવે તો કેહેકેન પોરમેહેરા માંડવામાય ગીયો, એને બેટ ચોડાવલ્યો બાખ્યો લેઈને ખાદ્યો, જ્યો યોખલા યાજકથી ખાવાય ચ્યો ચ્યે ખાદ્યો, એને હાંગાત્યાહાન બી દેન્યો? ");
INSERT INTO gbl_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","કાય તુમાહાય નિયમશાસ્ત્રામાય નાંય વાચ્યાહાં, કા યાજક આરામા દિહી દેવાળામાય આરામા દિહયા નિયમાલ તોડી તેબી નિર્દોષ રોઅરી? ");
INSERT INTO gbl_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","બાકી આંય તુમહાન આખહુ કા ઈહીં જો હેય તો દેવાળા કોઅતો મહાન હેય. ");
INSERT INTO gbl_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","તુમા નાંય જાંએ કા પવિત્રશાસ્ત્રમાય યા શબ્દાહા કાય મોતલાબ હેય, જો તુમા જાઅતા તે મા નિર્દોષ શિષ્યહા નિંદા નાંય કોઅતા. મા હાટી બેટ ચોડાવના કોઅતા, મા ઇચ્છા હેય કા તુમા બીજહાવોય દયા કોઆ. ");
INSERT INTO gbl_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","કાહાકા આંય, માઅહા પોહાલ આરામા દિહાવોય બી ઓદિકાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","તાઅને ચાલીન યોક પોરમેહેરા પવિત્ર દિહી ઈસુ સોબાયે ઠિકાણે ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","તાં યોક માઅહું આતા, ચ્યા આથ ઉખાલો આતો, પોરૂષી લોક ઈસુવાવોય દોષ લાવાહાટી પુછ્યાં, “કાય આરામા દિહી હારાં કોઅના ઠીક હેય?” ");
INSERT INTO gbl_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ચ્યાય ચ્યાહાન આખ્યાં, માની લા તુમહેમાઅને કાદા યોક ગેટા હેય, જોવે તીં આરામા દિહી ખાડામાય પોડી જાય તે, તુમા ચ્યાલ નોક્કીજ બોચાવી લાહા. ");
INSERT INTO gbl_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","હારાં, માઅહા કિંમાત ગેટા કોઅતા કોલાં વોદારી હેય, ચ્યાહાટી આરામા દિહી લોકહાન હારાં કોઅના યોગ્ય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","તોવે ઈસુવે આથ ઉખાલા માઅહાન આખ્યાં, “તું તો આથ લાંબો કોઓ” એને ચ્યેય આથ લાંબાવ્યો, એને બિજા આથા હારખો હારો ઓઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","તોવે પોરૂષી લોક બાઆ જાયને ઈસુલ માઅરાં હાટી યોજના બોનાડી કા, ચ્યાલ કેહેકેન આપા માઆઇ ટાકાડજે. ");
INSERT INTO gbl_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ઈ જાઇન ઈસુ તાઅને જાતો રિયો, એને બોજ લોક ચ્યા પાહલા ગીયા એને ચ્યાય બોદહાન હારેં કોઅયે. ");
INSERT INTO gbl_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ઈસુવે ચ્યાહાન કડાક ચેતાવણી દેની એને આખ્યાં લોકહાન ખોબાર નાંય કોઅના કા આંય કું હેય. ");
INSERT INTO gbl_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","કા જીં વચન યશાયા ભવિષ્યવક્તાથી પોરમેહેરાય આખવામાય યેનલા, તીં પુરાં ઓએ: ");
INSERT INTO gbl_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“એઆ, ઓ મા સેવાક હેય, જ્યાલ માયે નિવડયોહો, મા પ્રિય, જ્યાથી મા મોન ખુશ હેય: આંય મા આત્મા ચ્યામાય ટાકહી, એને તો ગેર યહૂદી લોકહાન ન્યાયા ખોબાર કોઅરી ");
INSERT INTO gbl_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","તો નાંય જગડો કોઅરી, એને નાંય તો બોંબલ્યા કોઅરી, એને નાંય તો લોકહાવોચમાય ઘમંડાકોય બોઆયને સંદેશ હિકાડી. ");
INSERT INTO gbl_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","એને તો કાદાબી નુકસાન નાંય કોઅરી, જો યોકા સુંદાલા બુરળ્યા રોકો નોબળો ઓરી, એને દુમાડા વાળો દિવો નાંય ઉલવી, બાકી છેલ્લે તો ન્યાયામાય જીતી જાયના કારણ બોની. ");
INSERT INTO gbl_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","એને ગેર યહૂદી લોક ચ્યાવોય આશા રાખરી.” ");
INSERT INTO gbl_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","તોવે લોક યોક આંદળો-મૂકો જ્યાલ બુત વોળાગલો આતો, ઈસુપાય લેય યેને, એને ઈસુય ચ્યાલ હારાં કોઅયા, એને તો બોલા એને એઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ચ્યાથી બોદે નોવાય થી આખા લાગ્યેં, “ઓ કા દાઉદ રાજા કુળામાઅને હેય?” ");
INSERT INTO gbl_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","બાકી પોરૂષી લોકહાય ઈ વોનાઈન આખ્યાં, “ઈ તો સૈતાન જો બુતાહા મુખ્ય હેય ચ્યા મોદાત લેયા વોગાર બુતહાન નાંય તાંગાડે.” ");
INSERT INTO gbl_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","તો ચ્યાહા વિચાર જાંઆઈ ગીયો એને આખ્યાં કા, જ્યા બી કાદા યોક દેશા લોક ચ્યાહામાયજ ફુટ પોડે તે તીં ઉજડી જાહે, એને કાદા શેહેર કા ગોઅમે ફુટ પોડહે, તીં નાંય ટોકી હોકે. ");
INSERT INTO gbl_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","એને જોવે સૈતાન પોતાનાજ બુતહા આરે લોડે, તે પોતાનાજ વિરુદી ઓઅઇ જાય; પાછે ચ્યા રાજ્ય કેહેકેન ટોકી રોય? ");
INSERT INTO gbl_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","જોવે, આંય સૈતાન જો બુતાહા મુખ્ય હેય ચ્યા મોદાત કોઅઇ બુતહાન કાડહુ, તોવે તુમહે પીડી કા મોદાતકોય કાડતેહે? ચ્યાહાટી તો તુમહે ન્યાય કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","જોવે આંય પોરમેહેરા આત્મા મોદાતકોય બુત કાડહુ, તોવે પોરમેહેરા રાજ્ય તુમહે પાહી યી ચુકલા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","કાદોબી સૈતાના હારકા તાકાતવાળા માઅહા ગુઉ લુટી નાંય હોકે, જાવ લોગુ ચ્યા તાકાતવાળા માઅહાન આરવાહાટી એને બાંદાહાટી તાકાતવાળો નાંય રોય, તોવે તો ચ્યા ગોઅમેને બોદાંજ લુટી લેય હોકહે. ");
INSERT INTO gbl_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","જીં માઅહું મા આરે નાંય હેય, તો મા વિરુદમાય હેય, એને જીં માઅહું મા આરે ગોળો નાંય કોએ તો વેરેહે. ");
INSERT INTO gbl_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ચ્યાહાટી આંય તુમહાન આખહુ કા માઅહા બોદા જાત્યા પાપ એને નિંદા માફી મિળી જાય, બાકી પવિત્ર આત્મા નિંદા માફ નાંય કોઅવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","જીં કાદાં માઅહા પોહા વિરુદમાય વાત આખી, ચ્યા ઓ પાપ માફ કોઅવામાય યી, બાકી જીં પવિત્ર આત્મા વિરુદમાય બોલી, ચ્યા પાપ નાંય તે યા લોકહામાય એને નાંય તે પરલોક માય માફ કોઅવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","“જોવે જાડ હારાં હેય, તોવે ચ્યા ફળબી હારાં હેય, એને જાડ નોકામ્યા હેય, તોવે ફળબી નોકામ્યા હેય; કાહાકા જાડ ચ્યા ફળ કોય વોળખાયેહે. ");
INSERT INTO gbl_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ઓ જેરીવાળા હાપડા રોકહાય, તુમા જુઠા ઓઇન કેહેકેન હારી વાત આખી હોકતાહા? કાહાકા જીં મોનામાય બોઅલાં હેય, તીં મુયામાય યેહે. ");
INSERT INTO gbl_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","યોક હારાં માઅહું મોના હારાં ભંડારા માઅને હાર્યો વાતો કાડહે, એને જુઠા માઅહું જુઠા ભંડારામાયને જુઠયો વાતો કાડહે. ");
INSERT INTO gbl_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","એને આંય તુમહાન આખતાહાવ કા, જ્યો-જ્યો નોકામ્યો વાતો માઅહું આખી, ન્યાયા દિહીહયામાય ચ્યે બોદયે વાતહે ઇસાબ લેવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","કાહાકા તું પોતા આખલી વાતહે કોઅઇ નિર્દોષ, એને પોતા આખલી વાતહે કોઅઇ દોષી ઠોરવામાય યી.” ");
INSERT INTO gbl_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","પાછે મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોક ઈસુવાપાય યેના ચ્યાઆરે ચર્ચા કોઅતા લાગ્યા, એને ચ્યાહાય માગણી કોઅયી કા, “ઓ ગુરુ, આકાશા એહેરે મોઠે ચમત્કાર દેખાડ, ચ્યા ઈસુલ ફોસવા હાટી ઈ માગણી કોઅઇ રીયલા આતા.” ");
INSERT INTO gbl_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ચ્યાય ચ્યાહાન જાવાબ દેનો, “ઈ પીડી ખારાબ એને વ્યબિચારી લોક ચમત્કાર હોદતેહેં, બાકી યોના ભવિષ્યવક્તા આરે જીં જાયા ચ્યાલ છોડીન બિજાં કાય ચિન્હ નાંય દેવાય. ");
INSERT INTO gbl_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","યોનો તીન રાત-દિહી માછલ્યે બુકામાય રિયો, તેહેકોયજ આંય, માઅહા પોહો તીન રાત-દિહી દોરત્યેમાય રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","નીનવે શેહેરા લોક ન્યાયા દિહી યા પીડી લોકહાઆરે ચ્યા દોષી ઠોરવી, કાહાકા ચ્યાહાય યોના આખલ્યા વોનાયને પાપ છોડયા, એને એરા, ઓ તો હેય જો યોના કોઅતો મોઠો હેય, બાકી તુમા પાપ છોડાહાટી મોનાઈ કોઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","દક્ષીણ રાણી ન્યાયા દિહી યે પીડી લોકહાઆરે ઉઠીન ચ્યાહાન દોષી ઠોરવી, કાહાકા તી સુલેમાના જ્ઞાન વોનાયા હાટી બોજ દુરથી યેનેલ, એને એઆ, ઈહીં તો હેય, જો સુલેમાના કોઅતો મોઠો હેય, બાકી તુમા પાપ છોડાહાટી મોનાઈ કોઅતેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","“જોવે બુત માઅહા માઅને નિંગી જાહે, તોવે ઉજાડ જાગામાય આરામ હોદતા ફિરહે, બાકી મીળે નાંય. ");
INSERT INTO gbl_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","તોવે પોતે પોતાલુજ આખહે, આંય જ્યા માઅહા માઅને યેનેલ, તાંજ ફિરી જાહીં, એને ફિરી યેઇન ચ્યાલ ચ્યા માઅહા જીવન ગાઆ રોકા દેખાયેહે જીં ચોખ્ખાં, સોબાડલા, એને રીકામા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","તોવે તીં જાયને ચ્યે કોઅતા વોદારે હાંત બુતાહાલ લી યેહે, એને ચ્યે ચ્યા માઅહામાય ઉરાય જાતહેં, એને તાંજ રોતેહેં, ચ્યા માઅહા પાછલી દશા પેલ્લા કોઅતાબી ખારાબ બોની જાહે, યા પીડી ખારાબ લોકહા બી દશા એહેકેનુજ ખારાબ ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","જોવે ઈસુ ચ્યે ગીરદ્યે આરે વાતો કોઅતોજ આતો તોવે ચ્યા આયહો એને બાહા યેના, એને બાઆ ઉબે રિયે એને ચ્યાઆરે વાતો કોઅરા માગતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","કાદાય ચ્યાલ આખ્યાં, એએ તો આયહો એને બાહા બાઆ ઉબે રીઅલે હેતેં, એને તોઆરે વાતો કોઅરા માગતેહે. ");
INSERT INTO gbl_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ઈ બોદા વોનાઈન આખનારાલ જાવાબ દેનો, “કું હેય મા આયહો? એને કું મા બાહા?” ");
INSERT INTO gbl_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","એને ચ્યા શિષ્યહા એછે ચ્યા આથ લાંબો કોઇન આખ્યાં, “એઆ, યે મા આયહો એને મા બાહા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","કાહાકા જીં કાદાં હોરગ્યા આબહા ઇચ્છા પુરી કોઅહે, તીંજ મા બાહા, એને મા બોઅહી એને મા આયહો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","તોદિહી ઈસુ ગોઅરે નિંગીન દોરિયા મેરે જાયને બોઠો. ");
INSERT INTO gbl_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","તોવે ચ્યાપાય બોજ મોઠી ગીરદી બેગી ઓઈ ગીયી, કા તો ઉડીમાય ચોડી ગીયો, એને બોદે માઅહે મેરાવોય ઉબે રિયે. ");
INSERT INTO gbl_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","એને ઈસુવે ચ્યાહાન દાખલો દેયન બોજ વાતો હિકાડયો: “યોક ખેડુત, બિયારો પોઆ રાનામાય ગીયો ");
INSERT INTO gbl_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","એને પોએ તોવે કોલોહોખાન બિયારો વાટે મેરે પોડયો, એને ચિડેં પોડીન તીં ખાય ગીયે. ");
INSERT INTO gbl_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","એને કોલોહોખાન બિયારો ખડકાવાળી જમીનમાય પોડયો, તાં કાદુ ઓછો આતો, ચ્યાહાટી બિઇ તારાતુજ ઉદી નિંગ્યા, કાહાકા તાં કાદુ ઉંડે લોગુ નાંય આતો. ");
INSERT INTO gbl_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","બાકી બોપરેહે દિહી ચોડયો એને તીડકો લાગ્યો તોવે તારાત તીં કોમાઈ ગીયા, એને મુળે નાંય બોઠે ચ્યાહાટી તીં ઉખાઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","એને કોલોહોખાન બિયારો કાટાહા જેખરાહામાય પોડયો, એને કાટેં વોદી ગીયે એને દાબાઈ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","કોલોહોખાન બિયારો હારી જમીનમાય પોડયો, એને હારાં પાક્યા, કોલાહાક તીહી ગોણા, કોલાહાક હાંઈટ ગોણા, કોલાહાક હોવ ગોણા. ");
INSERT INTO gbl_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","જ્યા વોનાયા હાટી તિયાર હેય ચ્યા વોનાય લેય.” ");
INSERT INTO gbl_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","તોવે શિષ્યહાય ઈસુવા પાહાય યેઇન ચ્યાલ આખ્યાં, “એલહાન તું કાહા દાખલાહામાય નોકીજ હોમજાડતોહો?” ");
INSERT INTO gbl_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ઈસુવે જાવાબ દેનો, “તુમા તે પોરમેહેરા રાજ્યા દોબલી વાતો જાંઅતાહા, બાકી જ્યા માયેવોય બોરહો નાંય કોએત ચ્યા નાંય જાંએ.” ");
INSERT INTO gbl_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","કાહાકા જ્યા પાય હોમાજ હેય, તો વોદારી હોમાજ મેળવી, બાકી જ્યા પાય કાય હોમાજ નાંય મીળે, ચ્યાપાય જીં વોછીબી હોમાજ ઓરી તીં બી ચ્યાપાઅને ખોવાય જાય. ");
INSERT INTO gbl_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","આંય ચ્યાહાન દાખલાહા માંયજ હોમજાડતાહાવ, કાહાકા ચ્યા એએયા કોઅતાહા બાકી જાંએ નાંય, એને વોનાતાહા બાકી હોમજેત નાંય. ");
INSERT INTO gbl_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ચ્યાહા બારામાય યશાયા ભવિષ્યવક્તા આખલી ઈ ભવિષ્યવાણી પુરી ઓઅહોય: તુમા કાનાહાકોય તે વોનાયા, બાકી હોમજાહા નાંય; ડોળાહાકોય એએહા, બાકી તુમહાન હુજ નાંય પોડી. ");
INSERT INTO gbl_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","કાહાકા યા લોકહા મોન કોઠાણ બોની ગીયહા, એને ચ્યે કાનાહાકોય વોછા વોનાતેહે, એને ચ્યાહાય પોતે ડોળા મીચી લેદહા, કા એહેકેન નાંય ઓએ કા ડોળાકોય એઅતા લાગે, કાનાકોય વોનાતા લાગે, મોનાકોય હોમજે, એને મા એછે વોળી યેય કા આંય ચ્યાહાન હારાં કોઅહુ. ");
INSERT INTO gbl_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","બાકી તુમહે ડોળા ધન્ય હેય, કાહાકા ચ્યા એઅતાહા; એને તુમહે કાન ધન્ય કાહાકા ચ્યા વોનાતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","કાહાકા આંય હાચ્ચાં આખતાહાવ, બોજ ભવિષ્યવક્તા એને ન્યાયી લોકહાય તુમા જીં એઅતાહા તીં એરા ઇચ્છા રાખી, બાકી નાંય એએઈ હોક્યા એને તુમા વોનાતાહા તીં વોનાયા બોજ ઇચ્છા આતી, બાકી નાંય વોનાય હોક્યા. ");
INSERT INTO gbl_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“આમી તુમા પોઅનારા દાખલો વોનાયા. ");
INSERT INTO gbl_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","વાટેમાય પોડલો બિયારો ચ્યા હારખા હેતા, જીં માઅહું વચન વોનાયે બાકી તારાતુજ સૈતાન યેઇન ચ્યાહા મોનામાઅને વચન વિહરાવી દેહે. ");
INSERT INTO gbl_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","બિજા લોક ખડકાવાળી જાગા હારકા હેય જાં વોછોજ બિયારો પોડહે, યાહાટી ચ્યે વચન વોનાયને તારાતુજ આનંદથી માની લેતહેં, ");
INSERT INTO gbl_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","બાકી પોરમેહેરા વચન ચ્યાહા મોનામાય ઉંડે નાંય ઉત્યા, ચ્યાહાટી ચ્યે વોછા દિહાપુરતે રોતેહેં, ચ્યા પાછે પોરમેહેરા વચના લેદે જોવે ઓડચણ કા દુઃખ યેહે તોવે ચ્યે તારાતુજ ટાકી પોડતેહે. ");
INSERT INTO gbl_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","બિજા લોક કાટાહા જેખરાહા હારકા હેય, ચ્યાહાય તે વચન વોનાય લેદા, એને જીવના બારામાય ચિંતા, પોયહા લોબ, એને બીજી લાલચ યેઇન પોરમેહેરા વચનાલ દાબી દેના, એને ચ્યે નોકામ્યા જીવન જીવતેહે. ");
INSERT INTO gbl_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","બિજા લોક હારી જમીની હારકા હેય, પોરમેહેરા વચન વોનાઈન હોમજેહે, એને ફળબી દેહે; કાદા હોવ ગોણા દેય, કાદા હાંઈટ ગોણા, એને કાદા તીહી ગોણા દેય.” ");
INSERT INTO gbl_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ઈસુવાય ચ્યાહાન બિજો દાખલો દેનો કા, “હોરગા રાજ્ય ચ્યા બિયારો પોઅનારા ખેડુતા હારકા હેય જ્યાંય ચ્યા પોતાના રાનામાય હારો બિયારો ટાક્યો. ");
INSERT INTO gbl_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","બાકી બોદા લોક હૂવી રીઅલા આતા, તોવે ચ્યા દુશ્માન રાતી યેઇન જાં ગોંવ પોઅલા આતા ચ્યાહામાય ટોળ્યા બિયારો પોઓઈ નાઠો. ");
INSERT INTO gbl_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","તે જોવે બિયારો ઉદ્યો એને નીહીવાય પોડ્યા, તોવે ટોળ્યા દેખાયાં. ");
INSERT INTO gbl_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","તોવે માલિકાપાય જાયને આવત્યાહાય આખ્યાં કા, માલિક, આમહાય તે રાનામાય હારો બિયારો પોઓયેલ, તે આમી ટોળ્યા કેછને યેના? ");
INSERT INTO gbl_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ચ્યે આખ્યાં, ઈ તે યોકતા દુશ્માના કામ ઓરી આવત્યાહાય પુછ્યાં, તોવે આમા કાય કોઅજે? આમા જાયને ઉદલા ટોળ્યાલ ઉપડાવી ટાકજે કા? ");
INSERT INTO gbl_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ચ્યે જાવાબ દેનો, નાંય, એહેકેન નાંય કોઅતા, કાય ઉદલા ટોળ્યા ઉપડાવત્યે વેળે ગોંવ બી ઉપડી ટાકે. ");
INSERT INTO gbl_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ચ્યાહાટી પાકે તાંવ લોગુ બેન્યાહાલ આરેજ વોદા દિયા, એને વાડત્યે વેળાયે વાડનારાહાન આંય આખહી, કા ટોળ્યાલ પેલ્લા બેગા કોઆ એને બાળી ટાકાંહાટી પૂળા બાંદા બાકી ગોંવ મા વોખારમાય બેગા કોઆ.” ");
INSERT INTO gbl_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","આજુ યોક દાખલો આખ્યો, “હોરગા રાજ્ય યોક રાયે દાણા હારકા હેય, રાયે દાણો લેઈને કાદે પોતાના રાનામાય પોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","બોદા બીયારાહામાય વાહાનો બિયારો હેય, બાકી ઉદહે તોવે તીં બોદા જાડવાહામાય મોઠા જાડ બોની જાહાય, એને આકાશામાય ઉડનારે ચિડેં યેઇન ચ્યા ડાળખ્યેહેવોય ગોરો કોઅતેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","આજુ બિજો દાખલો ચ્યાહાન દેનો, “હોરગા રાજ્ય ખમીરા હારકા હેય જ્યાલ યોક થેએયે લેઈને તીન માપ (તીન ચોપે) કુટામાય મોગલી દેના, એને બોદા ખમીર ઓઅઇ ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","એને જોવેબી ઈસુ પોરમેહેરાબારામાય વાત આખે, તોવે દાખલા દેયન આખે. ");
INSERT INTO gbl_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","જ્યેથી ભવિષ્યવક્તાથી આખલા વચન પુરાં ઓએ, ચ્યાહાટી કા, “આંય દાખલા દેયન વાત આખહી, જોવેને આકાશ એને દોરતી ઉસબાડી તોદરીહી દુબાડલી વાત આંય દેખાડીહી.” ");
INSERT INTO gbl_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","જોવે ઈસુ લોકહાન છોડીન ગોઅમે ગીયો, તોવે ચ્યા શિષ્ય ચ્યાપાય યેના એને ચ્યાહાય ચ્યાલ આખ્યાં, “ટોળ્યાવાળો દાખલો આમહાન હોમજાડી દે.” ");
INSERT INTO gbl_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ઈસુવે આખ્યાં, “હારો બિયારો પોઅનારો ખેડુત માઅહા પોહો એટલે આંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","રાન દુનિયા લોક હેય, હારો બિયારો પોરમેહેરા રાજ્યા લોક હેય. ટોળ્યા એટલે ચ્ચા સૈતાના લોક હેય. ");
INSERT INTO gbl_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","એને જ્યા દુશ્માનાય ટોળ્યા પોઅયા તો સૈતાન હેય, વાડણી ઈ દુનિયા છેવાટ હેય, એને વાડનારા હોરગા દૂત હેતા. ");
INSERT INTO gbl_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","જેહેકોય ટોળ્યાલ વાડીન બેગો કોઇન આગડામાય હોલગાડી દેતહેં, તેહેકોય દુનિયા છેલ્લા દિહીહયામાય ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","આંય, માઅહા પોહો મા હોરગા દૂતહાન દોવાડીહી, એને ચ્યા રાજ્યમાઅને બોદા ઠોકારાહા કારણાહાલ એને પાપ કોઅનારાહાન ઓટાડી દી. ");
INSERT INTO gbl_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","એને હોરગા દૂત આગડા બાઠયેમાય ટાકી દેઅરી, તાં રોડના એને દાત કોકડાવના હેય. ");
INSERT INTO gbl_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","બાકી પોરમેહેરા લોક ચ્યાહા આબહા રાજ્યામાય દિહા હારકા ચોમકી, જ્યા વોનાયા હાટી તિયાર હેય ચ્યા વોનાય લેય.” ");
INSERT INTO gbl_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","હોરગા રાજ્યા રાનામાય દોબાડલ્યે મિલકાતે હારકા હેય, જોવે યોકા માઅહાન તીં મિળ્યાં, તે ચ્યા માઅહાય પાછા દોબાડી દેના, એને આનાંદથી જાયને ચ્યા બોદાંજ કાય વેચિન, ચ્યા રાનાલ વેચાતાં લેદા જ્યામાય ચ્યાય મિલકાત દોબાડલી આતી. ");
INSERT INTO gbl_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","આજુ હોરગા રાજ્ય યોક વેપાર્યા હારકા હેય તો જ્યા હારાં હિરા હોદના માય આતો. ");
INSERT INTO gbl_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","જોવે ચ્યાલ બોજ કિમતી હિરો જોડયો તોવે તો ગીયો એને બોદી માલમિલકાત વેચી દેયન, તો હિરો વેચાતો લેદો. ");
INSERT INTO gbl_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","પાછી હોરગા રાજ્ય માછે દોઅના જાળે હારકા હેય, જીં દોરિયામાય ટાકી, એને જાળ્યેમાય બોદી જાત્યે માછલે યેય ગીયે. ");
INSERT INTO gbl_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","એને જોવે જાળ બાઆય જાય તોવે માછે દોઅનારા જાળ મેરે તાણી લેય યેના, એને બોહીન હારેં-હારેં માછલે ટોપલાહામાય બોઅરા લાગ્યા, એને નાંય હારેં માછલે ટાકી દેને. ");
INSERT INTO gbl_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","દુનિયા છેલ્લે એહેંજકોય બોની, હોરગા દૂત યેઇન હારાં માઅહાન પાપી લોકહામાઅને જુદા કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","એને પાપી લોકહાન આગડા બાઠયેમાય ટાકી દી, તાં રોડના એને દાત કોકડાવના હેય. ");
INSERT INTO gbl_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","“કાય તુમા ઈ બોદા હોમજી ગીયા?” ચ્યાહાય આખ્યાં, “હોમાજજેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “દરેક યોક જો મૂસા નિયમ હિકાડનારા ગુરુ જો હોરગા રાજ્યા શિષ્ય બોન્યો, તોવે તો ચ્યા ગોઆ માલિકા હારકો હેય, જ્યા બેની નોવી એને જુની શિક્ષા ચ્યે જાગાવોયને બાઆ કાડહે, જાં તો બીજહાન મોદાત કોઅરાહાટી ચ્યાહાન યોક્ઠી કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","જોવે ઈસુવે બોદા દાખલા પુરાં કોઅયા, તોવે તો કાપરનાહુમ શેહેરામાઅને ચાલ પોડયો. ");
INSERT INTO gbl_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","એને પોતાના ગાવામાય ગીયા, એને ચ્યાહા સોબાયે ઠિકાણે હિકાડતો લાગ્યો, ચ્યા હિકાડના બારામાય ચ્યાહાન બોજ નોવાય લાગી એને ચ્યા આખતા લાગ્યા કા, “એલાલ ઓલા જ્ઞાન એને ઓલા ચમત્કાર કોઅરા ગોતી કેછને મિળી? ");
INSERT INTO gbl_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","કાય એલો હુતાર્યા પોહો હેય કા નાંય? એલા આયહે નાંવ મરિયમ હેય કા નાંય? એને એલા બાહા યાકૂબ એને યોસેસ એને સિમોન એને યહૂદા હેય કા નાંય? ");
INSERT INTO gbl_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","એને એલા બોઅયોહો આમહે આરે હેત્યો કા નાંય? ચ્યાલ ઈ બોદા કેછને મિળ્યાં?” ");
INSERT INTO gbl_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","એને ચ્યા બારામાય ચ્યાહાય ઠોકાર ખાદી, બાકી ઈસુવે ચ્યાહાન આખ્યાં, “ભવિષ્યવક્તાલ બોદે માન દેત, ચ્યા ગાંવ એને પોતાના ગોઆશિવાય કેસુજ માનાવોગાર્યા નાંય રોત.” ");
INSERT INTO gbl_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","એને ચ્યાહા વોછા બોરહા લેદે, ચ્યે તાં વોછે ચમત્કારા કામે કોઅયે. ");
INSERT INTO gbl_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ચ્યે દિહી ચૌથાઈ દેશા હેરોદ રાજા ઈસુ મોઠા કામહા બારામાય વોનાયો, ");
INSERT INTO gbl_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","એને ચ્યે ચ્યા ચાકારાલ આખ્યાં, “ઓ યોહાન બાપતિસ્મા દેનારો હેય, જો મોઅલા માઅને પાછો ઉઠયોહો યાહાટી ચ્યા આથે મોઠે ચિન્હે ઓઅતેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ઓ તો હેરોદ રાજા આતો જ્યાંય ચ્યા બાહા ફિલિપા થેએ હેરોદિયાસ રાણ્યેલ પોતાની થેએ બોનાવી લેદેલ, ચ્યાહાટી હેરોદે યોહાન બાપતિસ્મા દેનારાલ દોઓયેલ એને બાંદિન જેલેમાય કોંડાડી દેનેલ. ");
INSERT INTO gbl_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","કાહાકા યોહાન બાપતિસ્મા દેનારાય હેરોદ રાજાલ આખ્યેલ, તો પોતે બાહા થેએ તો રાખના ઠીક નાંય. ");
INSERT INTO gbl_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","એને ચ્યાલ માઆઇ ટાકાં માગતો આતો, બાકી ચ્યાલ લોકહા બિક આતી, કાહાકા લોક ચ્યાલ ભવિષ્યવક્તા હેય એહેકેન માનેત. ");
INSERT INTO gbl_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","પાછે જોવે હેરોદા જન્મા દિહી યેનો તોવે હેરોદિયાસ રાણ્યે પોહયે બોદા ટોળા આગલા નાચી દેખાડયાં એને ચ્યે હેરોદ રાજાલ ખુશ કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","યાહાટી હેરોદ રાજાય કોસામ ખાયન આખ્યાં કા, “તું જીં કાય માગહે, તીં આંય દિહી.” ");
INSERT INTO gbl_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ચ્યે આયહે ચ્યેલ હિકાડયાં ચ્યાપરમાણે યેઇન ચ્યેય આખ્યાં, “યોહાન બાપતિસ્મા દેનારા ટોલપા વાડીન થાળ્યેમાય ઈહીંજ લેય યેય દે.” ");
INSERT INTO gbl_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","રાજાલ દુઃખ લાગ્યા, બાકી જ્યાહાલ ચ્યે હાદલા ચ્યાહા હામ્મે ચ્યે કોસામ ખાદેલ, ચ્યાહાટી આગના કોઅયી, કા દેય દે. ");
INSERT INTO gbl_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","એને સીપાડાલ દોવાડીન યોહાન બાપતિસ્મા દેનારા ટોલપી વાડીન લાંહાટી રાજાય જેલેમાય દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","એને ચ્યા ટોલપા થાળ્યેમાય થોવિન પોહયેલ દેય દેની, એને તી ટોલપી ચ્યે આયેહેપાય લેય ગીયી. ");
INSERT INTO gbl_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","પાછે યોહાના શિષ્યહાન ખોબાર પોડી, કા યોહાનાલ માઆઇ ટાક્યોહો તોવે ચ્યા યેના, એને ચ્યા કુડી લેઈને ચ્યાહાય તી માહણામાય દાટી દેની, પાછે ઈસુવાપાય જાયને ખોબાર દેની. ");
INSERT INTO gbl_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","જોવે ઈસુવાલ ઈ ખોબાર મિળી તોવે તાઅને તો ઉડીમાય બોહીન, યોક ઉજાડ જાગામાય માઅહા પાયને આલાગ નિંગી ગીયો, બાકી લોકહાન ચ્યા ખોબાર પોડી, એને ચ્યાહા શેહેરામાઅને ચ્યા પાગે ચાલીન ચ્યા પાહલા યેના. ");
INSERT INTO gbl_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","જોવે તો મેરાવોય પોઅચ્યો, તોવે બોજ માઅહા ટોળો એઅયો, એને ચ્યાહાવોય ચ્યાલ દયા યેની એને જ્યેં દુ:ખ્યે આતેં, ચ્યે ચ્યાહા દુખાહાન હારાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","એને જોવે દિહી બુડા લાગલો તોવે ચ્યા શિષ્યહાય ઈસુવાપાય યેઇન આખ્યાં “ઉજાડ જાગો હેય, એને દિહી બુડા વાય રિયહો. લોકહાન જાં દે કા ચોમખી ગાવહામાય એને ફોળ્યે-ફોળહયે માય જાયન ખાઅના વેચાતાં લેય યેય હોકે.” ");
INSERT INTO gbl_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","બાકી ઈસુવે ચ્યાહાન આખ્યાં, “ચ્યાહા જાઅના જરુર નાંય હેય, તુમાંજ ચ્યાહાન ખાઅના દિયા,” ");
INSERT INTO gbl_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","બાકી ચ્યાહાય ચ્યાલ આખ્યાં, “ઈહીં આમહાપાય પાંચુજ બાખ્યો એને બેન માછલે હેતેં.” ");
INSERT INTO gbl_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ઈસુય ચ્યાહાન આખ્યાં, “ચ્યાહાન માયેપાંય લેય યા.” ");
INSERT INTO gbl_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","પાછે ચ્યાય માઅહાન ગાહીયાવોય બોહતેં કોય દેને, એને પાચ બાખે એને બેન માછલે લેદે, એને હોરગા એછે એઇન પોરમેહેરા આભાર માન્યા એને કુટકા કોઇન શિષ્યહાન દેના, એને શિષ્યહાય લોકહાન વાટી દેના. ");
INSERT INTO gbl_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","બોદહાય ખાદાં એને દારાઈ ગીયે, એને ચ્યાહાય ઉગારલા ટુકડાહાન બેગા કોઅયા, તે બારા ટોપલ્યો બોઆય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","એને ખાનારે થેઅયો એને પાહાહાન છોડતા માટડા લગભગ પાચ ઓજાર આતા. ");
INSERT INTO gbl_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","એને તારાતુજ ચ્યે શિષ્યહાન ઉડીમાય બોહાડીન દોરિયા ચ્યેમેરે દોવાડયા, કા ચ્ચા ચ્ચાથી પેલ્લા ચ્ચે મેરે જાતા રોય, જાવ હુદુ કા તો લોકહાન દોવાડી દેય. ");
INSERT INTO gbl_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","એને લોકહાન જાં દેયન તો યોખલોજ યોકા ડોગાવોય પ્રાર્થના કોઅરાહાટી ચોડી ગીયો, એને રુવાળા પોડ્યા તોવે તો તાં યોખલોજ આતો. ");
INSERT INTO gbl_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","ઉડી તે મેરાવોયને દુઉ આતા એને વારો હામ્મે આતો, તે ઉડી લાફાહા કોઇન આફળાતા જાય. ");
INSERT INTO gbl_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","એને ઈસુ રાતી લગભગ ચાર વાગા ઓલહામાય તો દોરીયાવોય ચાલીન ચ્યાહાપાય યેનો. ");
INSERT INTO gbl_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","બાકી જોવે શિષ્યહાય ઈસુલ દોરિયા ઉપે ચાલતા દેખીન, ચ્યા બોંબલી ઉઠયા કાહાકા ચ્યાહાય ચ્યાલ બુત જાંઆયો, એને ચ્યા ગાબરાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","કાહાકા બોદાજ ચ્યાલ દેખીન ગાબરાઈ ગીઅલા આતા, બાકી તારાતુજ ઈસુવે ચ્યાહાન હાત કોઇન આખ્યાં, “ઈંમાત રાખા, આંય ઈસુ હેતાઉ ગાબરાયાહા મા.” ");
INSERT INTO gbl_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","પિત્તરે જાવાબ દેનો કા, “ઓ પ્રભુ, જોવે તુંજ હેય તે, માન તોપાય યાહાટી પાઅયા ઉપને ચાલા આગના કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ચ્યેય આખ્યાં, “યે,” તોવે પિત્તર ઉડીમાઅને ઉત્યો એને પાઅયા ઉપે ચાલતો ઈસુવા એછે જાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","બાકી જોરમાય વારો યેતો દેખીન તો બિઇ ગીયો, એને જોવે તો બુડતો લાગ્યો તોવે બોંબલીન આખ્યાં, “ઓ પ્રભુ, માન બોચાવ.” ");
INSERT INTO gbl_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ઈસુવે તારાત આથ લાંબો કોઅઈન ચ્યાલ દોઅયો એને ચ્યાલ આખ્યાં, “ઓ ઓછા બોરહાવાળા, તુયે કાહા સંદેહ કોઅયો?” ");
INSERT INTO gbl_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","એને જોવે ચ્યા ઉડીમાય ચોડી ગીયા, તોવે વારો બોંદ ઓઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","જ્યા ઉડીમાય આતા, ચ્યાહાય યેયન ભક્તિ કોઇન આખ્યાં, “હાચ્ચોજ, તું પોરમેહેરા પોહો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","જોવે ઈસુ એને ચ્યા શિષ્ય યોક્યે ઉડીમાય ગાલીલા દોરિયામાય આજુ આગલા ગીયા એને ચ્યા ગેનેસારેત ભાગામાય યેય પોઅચ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","તાઅને લોકહાય ચ્યાલ વોળખીન, એને બોદા વિસ્તારામાય ખોબાર દોવાડી, એને બોદા દુ:ખ્યાહાન ચ્યાપાય લેય યેના. ");
INSERT INTO gbl_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","એને ચ્યા રાવ્યો કોઅતા લાગ્યા કા તો ફાડકા છેડાલ આથ લાવાં દે; એને જોલે ચ્યા ફાડકાલ આથ લાવેત ચ્યા બોદહા બોચાવ ઓઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","યોક દિહી કોલહાક મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોક યેરૂસાલેમ શેહેરમાઅને યેનલા આતા, ઈસુપાય બેગો જાયા, યાહાટી પોરૂષી લોક એને મૂસા નિયમ હિકાડનારા ગુરુવાહાય ઈસુલ પુછ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“તો શિષ્ય આમે વડીલાહા પરમ્પરા કાહાનાય માનેત? ચ્યા હારેકોય આથ દોવ્યા વોગાર મેલા આથહા કોય બાખે ખાતહા” ");
INSERT INTO gbl_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ઈસુવે ચ્યાહાન જાવાબ દેનો, તુમા પોરમેહેરા આગના પાળના છોડી દેતહા કા “તુમા તુમહે રીવાજેકોય કામ કોઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","કાહાકા પોરમેહેરાય આખ્યેલ તો આયહે આબહાલ માન દે, જીં માઅહું આયહે આબહાલ ગાળી દેય, ચ્યાલ હાચ્ચાંજ માઆઇ ટાકવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","બાકી તુમા આખતાહા કા જીં માઅહું આપહે આબહાલ એહેકેન આખહે, તુમહાન માયે પાયને જીં કાય મિળી હોકતા આતા, તી પોરમેહેરાલ બેટ ચોડવી હોકહ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","તે તો ચ્યા આબહા આદર નાંય કોએ, એહેકેન તુમહે વડીલાહા રુડી પાળાહાટી તુમા પોરમેહેરા નિયમશાસ્ત્ર પાળના છોડી દેતહા. ");
INSERT INTO gbl_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ઓ ડોંગી લોકહાય યશાયા ભવિષ્યવક્તાય તુમહે બારામાય હાચ્ચાં આખ્યેલ કા. ");
INSERT INTO gbl_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ચ્યા લોક મા બારામાય બોજ હારાં બોલતાહા બાકી ચ્યા માયેવોય હાચ્ચાં પ્રેમ નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","એને ચ્યાહા ભક્તિ માંહાટી નકામી હેય, કાહાકા ચ્યા માઅહાથી બોનાડલા નિયામાહાન પોરમેહેરા નિયમા રુપામાય લોકહાન હિકાડતાહા.” ");
INSERT INTO gbl_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","એને ઈસુવે લોકહાન પાહાય હાદિન ચ્યાહાન આખ્યાં, વોનાયા એને હોમજા. ");
INSERT INTO gbl_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","જીં કાય માઅહા મુયામાય જાય ચ્યા લેદે તીં મેલાં નાંય કોઅઇ હોકે, બાકી ચ્યા મુયામાયને જીં નિંગહે, તીંજ માઅહાન મેલાં કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","તોવે શિષ્યહાય ઈસુવાપાય યેયન ચ્યાલ પુછ્યાં, “કાય તુમહાન ખોબાર હેય કા ઈ વાત વોનાઈન પોરૂષી લોકહાન જુઠા લાગ્યહાં?” ");
INSERT INTO gbl_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","બાકી ચ્યે જાવાબ દેનો જીં જાડ મા હોરગા આબહે નાંય રોપહ્યા ચ્યાલ ઉપડી ટાકી. ");
INSERT INTO gbl_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","પોરૂષી લોકહા પાયને દુઉ રા, એલા આંદળા વાટ દેખાડનારા હેતા, જોવે આંદળા આંદળાલ લેય જાય તોવે બેની ખાડામાય પોડી. ");
INSERT INTO gbl_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ઈ વોનાયને પિત્તરાય ઈસુલ આખ્યાં, “આમહાન ઓ દાખલો હોમજાડી દે.” ");
INSERT INTO gbl_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ઈસુવે શિષ્યહાન આખ્યાં, “કાય એહેકેન તુમહાનબી નાંય હોમજાય? ");
INSERT INTO gbl_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","કાહાકા તીં ચ્યાહા મોનામાય નાંય જાય, બાકી ચ્યા બુકામાય જાહે, એને પાછે તીં ઝાડાવાટે બાઆ નિંગી જાહે.” ");
INSERT INTO gbl_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","માઅહું જીં વિચાર કોઅહે, આખહે એને કોઅહે, તીંજ માઅહાન પોરમેહેરા હામ્મે મેલાં કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","કાહાકા ચ્યા મોનામાઅરે ખારાબ વિચાર, ખૂન, વ્યબિચાર, લુચ્ચાઈ, ચોરી, જુઠી સાક્ષી, નિંદા ઓહડે બોદે પાપે નિંગતેહે. ");
INSERT INTO gbl_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ઓહડે બોદે પાપ માઅહાન મેલાં કોઅતેહે, બાકી આથ દોવ્યા વોગાર ખાઅના ખાયનાં માઅહાન મેલાં નાંય કોએ. ");
INSERT INTO gbl_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","એને ઈસુ તાઅને નિંગીન સુર એને સિદોન નાંવા શેહેરા આજુ-બાજુ વિસ્તારામાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","એને એઆ, ચ્યા દેશા યોક કનાની બાય યેની એને બોંબલીન આખા લાગી, “ઓ પ્રભુ દાઉદ રાજા કુળા પોહા, માયે ઉપે દયા કોઓ, મા પોહયેલ બુત બોજ દુ:ખ દેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","બાકી ઈસુ ઠાવકોજ રિયો એને કાયજ નાંય બોલ્યો, તોવે ચ્યા શિષ્યહાય ચ્યા પાહાય યેયન વિનાંતી કોઇન આખ્યાં, “એલ્યે થેએયેલ દોવાડી દે, આમે પાહલા બોંબાલતી યેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ઈસુવે જાવાબ દેનો, “પોરમેહેરે માન ઈસરાયેલ દેશા ચ્યા લોકહા પાય દોવાડયો જ્યા ટાકાલા ગેટાહા રોકા હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","બાકી તી બાઈ યેની, ચ્યા પાગે પોડીન આખ્યાં ઓ પ્રભુ, માન મોદાત કોઓ. ");
INSERT INTO gbl_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ચ્યાય જાવાબ દેનો કા, “પાહાહા પાયને ખાઅના માગના એને કુતરાહાલ ખાવાડના ઠીક નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ચ્યે બાઈય આખ્યાં, “હાચ્ચી વાત હેય પ્રભુ, બાકી પાહાહા આથામાયને પોડલા ટુકડાહા ચૂરો કુત્રે ખાતહેં. જીં ચ્યા માલિકા ટેબાલા ઉપેથી પોડલાં રોહે.” ");
INSERT INTO gbl_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","તોવે ઈસુવે ચ્યેલ આખ્યાં, “બાઈ તો હાચ્ચો બોરહો હેય, તો માગણી પરમાણે ઓઅઇ જાય.” એને ચ્યે પોહી ચ્યેજ સમયે હારી ઓઅઇ ગીયી. ");
INSERT INTO gbl_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","એને તાઅને નિંગીન ઈસુ ગાલીલ દોરિયા પાય યેનો, એને ડોગાવોય ચોડીન તાં બોહોઈ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","બોજ માઅહે લેંગડાહાન, પાંગળ્યાહાલ, આંદળાહાન, મુકાહાન એને બીજે બોજ દુખ્યાહાન ચ્યાપાય લેય યેના, એને ચ્યા પાગહા પાહી થોવ્યા એને ઈસુવે ચ્યા બોદહાન હારાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","આમીં: જોવે માઅહાય મુકાહાન બોલતા દેખ્યા, પાંગળ્યાહાલ ચાલતા એને આંદળા દેખતા ઓઅયા, તોવે ચ્યાહાન નોવાય લાગી, એને ચ્યા ઈસરાયેલ દેશા પોરમેહેરા સ્તુતિ આખતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ચ્યા દિહહામાય, બોજ લોક ઈસુ પાહી યેના એને ચોમખી યોક મોઠો ટોળો બેગો જાયો, એને ચ્યાહાપાય ખાઅના નાંય આતા, તોવે ઈસુવે ચ્યા શિષ્યહાન હાદિન આખ્યાં. “માન યા લોકહાવોય દયા યેહે, આમી તીન દિહી જાયહાં, ચ્યા માયેપાંય હેતા, એને ચ્યાહાપાય ખાઅના કાયજ નાંય આતા. ઈહીમાઅને કોલાહાક જાંઆ બોજ દુઉરે યેનહા, જોવે આંય ચ્યાહાન બુખા ગોઓ દોવાડી દાંઉ, તોવે વાટેમાય ચ્યા થાકીન તાંજ ટુટી પોડી.” ");
INSERT INTO gbl_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","શિષ્યહાય ઈસુવાલ આખ્યાં કા, “યા ઉજાડ જાગામાય ઓલા બોદા લોકહાન ખાવાડા હાટી કેછને ખાઅના મીળે?” ");
INSERT INTO gbl_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ઈસુવે શિષ્યહાન પુછ્યાં, “તુમહેપાય કોલ્યો બાખ્યો હેત્યો?” ચ્યાહાય આખ્યાં, “આમહાપાય હાંત બાખ્યો હેય એને વોછે વાહને માછલે હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","તોવે ઈસુય બોદા લોકહાન દોરત્યેવોય બોહરા આગના દેની. ");
INSERT INTO gbl_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","પાછે હાંત બાખે એને માછલે લેદે એને પોરમેહેરા આભાર માનીન બાખ્યેહે ટુકડા કોઇન શિષ્યહાન વાટી દાં આખ્યાં, એને ચ્યાહાય લોકહાન વાટી દેના. ");
INSERT INTO gbl_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","લોકહાય ખાદાં એને દારાઈ ગીયે, તોવે શિષ્યહાય હાંત ટોપલ્યો બોઆઈન વોદલા ખાઅના બેગા કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ખાનારે પોહેં એને બાયો નાંય ગોણતા, ચાર ઓજાર માટડા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","એને લોકહાન છોડીન ઈસુ ઉડીમાય બોહી ગીયો એને માગાદા દેશા વિસ્તારામાય યેનો. ");
INSERT INTO gbl_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","એને પોરૂષી લોક એને સાદૂકી લોક ઈસુવા પાહી યેયન ચ્યાલ ફોસવા હાટી આખ્યાં, આમહાન હોરગા એહેરે મોઠે ચમત્કાર દેખાડ. ");
INSERT INTO gbl_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ઈસુવે જાવાબ દેનો, “વોખાતેહે તુમા આખતાહા, ‘વાતાવરણ હારાં ઓઅરી, કાહાકા આકાશ લાલ હેતાં’, ");
INSERT INTO gbl_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","એને હાકાળ્યે સમયે આખતાહા, આજુ તોફાન યી, કાહાકા આકાશ લાલ એને દુકાળા હેય, તુમા આકાશા યે ચિન્હ એઇન ભેદ આખતાહા, બાકી સમાયા ચિન્હહા ભેદ કાહાનાય આખી હોકે? ");
INSERT INTO gbl_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","યે પિડયે ખારાબ એને વ્યબિચારી લોક ચમત્કાર હોદતાહા, બાકી યોના ભવિષ્યવક્તા ચિન્હ છોડીન બિજાં કાય ચિન્હ નાંય દેવાય” પાછે ઈસુ ચ્યાહાપાઅને જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","શિષ્ય નોયે ચ્યેમેરે જાત્યે સમાયે બાખે લેઅના વિહરાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ઈસુવે ચ્યાહાન આખ્યાં, “એઆ પોરૂષી લોકહા એને સાદૂકીયા ખમીરથી બોચાંહાટી હાચવીન રોજા.” ");
INSERT INTO gbl_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ચ્યા ચ્યાહા વોચમાય વિચાર કોઅતા એને આખા લાગ્યા, “તો એહેકેન યાહાટી આખી રીયલો હેય કાહાકા આમેપાય પુરત્યો બાખે નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ઈ બોદા જાંઆઈન, ઈસુવે ચ્યાહાન આખ્યાં, “ઓ વોછા બોરહા વાળહાય, તુમા યોક-બિજા આરે કાહા વિચાર કોઅતાહા કા આપહેવોય બાખે નાંય હેય? ");
INSERT INTO gbl_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","કાય તુમા આજુ લોગુ નાંય હોમજ્યાહા કા? કાય તુમહાન ચ્યા પાચ ઓજારાહા પાચ બાખ્યો નાંય ઇત હેય કા, એને નાંય કા તુમાહાય કોલ્યોહો ટોપલ્યો બોઅલ્યો? ");
INSERT INTO gbl_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","એને ચ્યા ચાર ઓજાર લોકહાહાટી હાંત બાખ્યો મુડયો, એને નાંય કા તુમાહાય કોલ્યોહો ટોપલ્યો બોઅલ્યો? ");
INSERT INTO gbl_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","તુમા કાહાનાય હોમજ્યા કા માયે તુમહાન બાખ્યે બારામાય નાંય આખલા કા, બાકી એહેકેન કા પોરૂષી લોકહા એને સાદૂકી લોકહા પાયને હાચવીન રોજા.” ");
INSERT INTO gbl_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","તોવે ચ્યાહાન હોમાજ પોડ્યા કા, ચ્યે બાખે ખમીરા આરે નાંય, બાકી પોરૂષી લોકહા એને સાદૂકી લોકહા શિક્ષણાથી હાચવીન રા આખલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","ઈસુ કૈસરીયા ફિલીપીયા ભાગામાય યેયન પોતે શિષ્યહાન પુછા લાગ્યો, “માઅહે માન, માઅહા પોહાલ કાય આખતેહે?” ");
INSERT INTO gbl_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","શિષ્યહાય આખ્યાં, કાંયક લોક યોહાન બાપતિસ્મા દેનારો આખતેહે, એને કાંયક એલીયો, એને કોલહાક યિર્મયા ભવિષ્યવક્તા હેય ભવિષ્યવક્તામાંઅને યોક આખતેહે. ");
INSERT INTO gbl_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ઈસુવે શિષ્યહાન આખ્યાં, “બાકી તુમા માન કાય આખતાહા?” ");
INSERT INTO gbl_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","તોવે સિમોન પિત્તરે જાવાબ દેનો, “તું પોરમેહેરા પોહો ખ્રિસ્ત હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ઈસુવે ચ્યાલ જાવાબ દેનો, “ઓ સિમોન, યોના પાહા, તું ધન્ય હેય, કાહાકા કાદે માઅહા લોય થી નાંય, બાકી મા આબહો જો હોરગામાય હેય, ઈ વાત તુલ જાણાવિહી. ");
INSERT INTO gbl_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","એને આંયબી તુલ આખતાહાવ કા તું પિત્તર હેય, (યુનાની ભાષામાય પિત્તર એટલે દોગડા ટુકડો હેય) એને આંય યા દોગાડાવોય મા મંડળી બોનાડીહી, એને અધોલોકા ફાટાક ચ્યાવોય જોર નાંય કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","આંય તુલ હોરગા રાજ્યા ચાવ્યો દિહી: એને જીં કાય તું દોરત્યેવોય બાંદહે, તીં હોરગામાય બાંદહે, એને જીં કાય તું દોરત્યેવોય ખોલહે, તીં હોરગામાય ખોલાઈ.” ");
INSERT INTO gbl_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","તોવે ચ્યાય શિષ્યહાન ચેતાવણી દેની કા, કાદાલ નાંય આખના કા આંય ખ્રિસ્ત હેય. ");
INSERT INTO gbl_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ચ્યે સમયે ઈસુ ચ્યા શિષ્યહાન આખા લાગ્યો, “જરુર હેય કા આંય યેરૂસાલેમ શેહેરમાય જાંઉ, એને આગેવાન, એને મુખ્ય યાજક, એને મૂસા નિયમ હિકાડનારા ગુરુ આથાથી બોજ દુઃખ ઊઠાવીહી, એને માઆઇ ટાકલો જાહીં, એને તીજે દિહી પાછો જીવી ઉઠહી.” ");
INSERT INTO gbl_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","તોવે પિત્તરે ચ્યાલ આલાગ લેય જાયન પીડા એને માઆઇ ટાકના બારામાય વાત કોઅયી યાહાટી ખિજવાયા લાગ્યો. “ઓ પ્રભુ પોરમેહેર એહેકેન કોઇન મા કોઅહે, તોઆરે એહેકેન કોદહી નાંય ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ચ્યાય પાહલા એઇન પિત્તરાલ આખ્યાં, “ઓ સૈતાન, મા હામ્મેથી દુર ઓઅઇ જો, તું મા હાટી ઠોકરે કારણ હેય, કાહાકા તો વિચાર પોરમેહેરા એછને નાંય, બાકી માઅહા એછને હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","એને શિષ્યહાઆરે લોકહાન હાદિન ઈસુવે આખ્યાં “જો કાદાં મા શિષ્ય બોના માગહે, ચ્યાલ પોતાલ નાકાર કોઅરા જોજે એને પોતાનો હુળીખાંબ ઉચકીન મા શિષ્ય બોને. ");
INSERT INTO gbl_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","કાહાકા જીં માઅહું દોરતીવોય પોતે જીવ બોચાવાં માગહે, તો હાચ્ચાં જીવન ગુમાવી દી, બાકી તુમા જ્યા મા લીદે એને પોરમેહેરા હારી ખોબારે લીદે ચ્યા જીવ દેહે, તો હાચ્ચાં જીવન મેળવી. ");
INSERT INTO gbl_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","યોક માઅહાલ કાય લાભ જોવે ચ્યાલ બોજ મિલકાત મીળે બાકી પોરમેહેરાઆરે હાચ્ચાં જીવન ગુમાવી દેય? યોક માઅહું પોરમેહેરાલ કાય દી હોકહે, જીં ચ્યા અનંતજીવન વેચાતાં લેય?” ");
INSERT INTO gbl_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","આંય, માઅહા પોહો, મા હોરગા દૂતહા આરે મા આબહા મહિમામાય યીહીં, એને ચ્યે સમયે આંય બોદહાલુજ ચ્યાહા કામહા ઇસાબે ઇનામ દિહી. ");
INSERT INTO gbl_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","“આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા ઈહીં ઉબલા કોલહાક લોક તોવેબી જીવતા રોય, જાવ હુદુ માઅહા પોહાલ પોરમેહેરા રાજ્યા સામર્થકોય ચ્યાહા વોચ્ચે યેતા દેખી.” ");
INSERT INTO gbl_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","છ દિહા પાછે ઈસુવે પિત્તર, યાકૂબ એને ચ્યા બાહા યોહાનાલ લેયને ચ્યા ઉચા ડોગાવોય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","તાં ચ્યાહા આગલા ઈસુવા રુપ બોદલાય ગીયા. એને ચ્યા મુંય દિહા રોહણ્યે રોકા ચોમકા લાગ્યા એને ચ્યા ફાડકે ઉજવાડા રોકે ઉજળેંફુલ ઓઅઇ ગીયે. ");
INSERT INTO gbl_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","એને ભવિષ્યવક્તા મૂસા એને એલીયા ઈસુવાઆરે વાતો કોઅતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","તોવે પિત્તરાય ઈસુવાલ આખ્યાં, “ઓ પ્રભુ, આપહે ઈહીં રોઅના હારાં હેય એને તું આખતો ઓરીતે ઈહીં આંય તીન માંડવા બોનાડુ, યોક તોહાટી, યોક મૂસા હાટી, એને યોક એલીયા હાટી.” ");
INSERT INTO gbl_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","તો આજુ બોલીજ રીયેલ ઓલાહામાયજ યોક ઉજળા વાદળાં યેના એને ચ્યાહાન ચ્યા સાવલ્યેકોય ડાકી લેદા, એને ચ્યાહાય વાદળામાઅરે પોરમેહેરાલ બોલતા વોનાયા, “ઓ મા પ્રિય પોહો હેય, ચ્યા આખલા માનજા”. ");
INSERT INTO gbl_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","શિષ્ય ઈ વોનાયા તોવે ઉંબડા પોડી ગીયા એને બોજ બિઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ઈસુવે પાહી યેયન ચ્યાહાલ આથલ્યા એને આખ્યાં, “ઉઠા, બીયહા મા.” ");
INSERT INTO gbl_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","તોવે તારાતુજ ચ્યાહાય ચોમખી એઅયા, એને ઈસુ યોખલોજ દેખાયો, બિજો કાદોજ નાંય દેખાયો. ");
INSERT INTO gbl_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","જોવે ઈસુ એને ચ્યા તીન શિષ્ય ડોગાવોયને ઉતતાજ ચ્યાય ચ્યાહાન યોક આગના દેની કા, કાદાલબી ઈ મા આખહા કા તુમાહાય કાય એઅયા જાવ લોગુ આંય, માઅહા પોહો મોઅલા માઅને પાછો જીવતો નાંય ઓઅઇ જાવ. ");
INSERT INTO gbl_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","એને પાછા શિષ્યહાય ઈસુવાલ પુછ્યાં, “મૂસા નિયમ હિકાડનારા ગુરુ એહેકેન કાહા આખતાહા કા, એલીયાલ ખ્રિસ્તા યેયના પેલ્લા યાં જોજે?”. ");
INSERT INTO gbl_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ઈસુવે ચ્યાહાન આખ્યાં કા, ઈ હાચ્ચાં હેય કા પોરમેહેરાય “એલીયાલ દોવાડના વાયદો કોઅલો આતો કા તો બોદા કાય હુદારાવાંહાટી પેલ્લો યેય જાય, ");
INSERT INTO gbl_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","બાકી આંય તુમહાન આખહુ કા એલીયા તે યેય ગીયહો, બાકી લોકહાય ચ્યાલ નાંય વોળખ્યોહો, બાકી જેહેકોય ચ્યાહા મોરજી જાયી તેહેકોય ચ્યાહાઆરે કોઅયા, યેજપરમાણે માઅહા પોહોબી ચ્યાહા આથે દુઃખ વેઠી.” ");
INSERT INTO gbl_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","તોવે શિષ્ય હોમજી ગીયા કા ચ્યે આમહાન યોહાન બાપતિસ્મા દેનારા બારામાય આખ્યાહા. ");
INSERT INTO gbl_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","જોવે ચ્યા માઅહા ટોળા પાય જાય પોઅચ્ચા તોવે યોક માઅહું ચ્યા પાહી યેયન પાગે પોડીન આખા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ઓ પ્રભુ, મા પોહાવોય દયા કોઓ, કાહાકા ચ્યાલ મીર્ગ્યા ચોળી યેહે, તોવે તો બોજ દુઃખ વેઠેહે, બોજદા તો આગડામાય પોડહયો ને બોજદા તો પાઅયામાય પોડયોહો. ");
INSERT INTO gbl_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","આંય ચ્યાલ તો શિષ્યહાપાય લેય ગીયેલ બાકી ચ્યા ચ્યાલ હારાં નાંય કોઅય હોક્યા.” ");
INSERT INTO gbl_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ઈસુવે ચ્યાહાન જાવાબ દેનો કા “ઓ બોરહો નાંય થોવનારા લોકહાય એને લુચ્ચી પીડી, તુમહેઆરે કોલાહા લોગુ રોઉં? કોલાહા લોગુ તુમહાન વેઠું? ચ્યાલ તુમા માયેપાંય લેય યા.” ");
INSERT INTO gbl_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","તોવે ઈસુવે ચ્યાલ દોમકાડયો, એને બુત ચ્યામાઅને નિંગી ગીયો, એને પોહો ચ્યેજ સમયે હારો જાયો. ");
INSERT INTO gbl_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","જોવે ઈસુ યોખલો આતો તોવે શિષ્ય ચ્યાપાય યેના એને ચ્યાહાય આખ્યાં, “બુતાલ આમા કાહાનાય કાડી હોક્યા?” ");
INSERT INTO gbl_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ઈસુવે ચ્યાહાન આખ્યાં, તુમહે બોરહો વોછો હેય, આંય તુમહાન હાચ્ચાંજ આખતાહાવ, તુમહે બોરહો યોક રાયે દાણા ઓલહો રોય, તોવે તુમા યા ડોગાલ આખી હોકતાહા, ઈહીંરે પાછો ઓટીજો, તોવે તો પાછો ઓટી જાઅરી, એને તુમહેહાટી કાયજ અસંભવ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","બાકી ઓ બુત ઉપહા કા પ્રાર્થના કોઅયા વોગાર નાંય નિંગે. ");
INSERT INTO gbl_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","જોવે ચ્યા ગાલીલ ભાગામાય આતા, તોવે ઈસુવે ચ્યાહાન આખ્યાં, “માઅહા પોહો મા દુશ્માનાહા ઓદિકારામાય હોઅપાઈ જાય. ");
INSERT INTO gbl_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","એને ચ્યા ચ્યાલ માઆઇ ટાકી બાકી તો તીજે દિહી મોઅલા માઅને પાછો જીવતો ઉઠી” શિષ્ય તે બોજ નારાજ ઓઅઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","જોવે ચ્યા કાપરનાહુમ ગાવામાય યેય લાગ્યા, તોવે દેવાળા કર લેનારાહાય પિત્તરાપાંય યેઇન પુછ્યાં, “કાય તુમહે ગુરુ દેવાળા કર નાંય દેય?” ");
INSERT INTO gbl_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","પિત્તરે આખ્યાં, “હાં, તો દેહે.” જોવે પિત્તરા ગોઅમે યેનો, તોવે ચ્યા આખના પેલ્લાજ ઈસુય પિત્તરાલ પુછ્યાં, “ઓ સિમોન, તુલ કાય લાગહે? દુનિયા રાજા કોઅહા લોકહા પાયને કર લેતહા? ચ્યાહા પાહાહા પાયને કા બીજહા પાયને?” ");
INSERT INTO gbl_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","પિત્તરાય આખ્યાં, “બીજહા પાયને, તોવે ઈસુવે આખ્યાં, તોવે પોહો વાચાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","બાકી આમા નાંય ઇચ્છા રાખજે કા યા લોક આમે લીદે હેરાન ઓએ, યાહાટી તું દોરિયા એછે જો એને ગોળાય ટાક એને પેલ્લા જીં માછલા ગોળાય માય લાગે ચ્યા મુંય ઉગાડ, એને ચ્યામાય યોક સિક્કો (ચાર દિહાહા મજરી) મિળી તો લેઈને આપહે કર બોઅઇ દેજે.” ");
INSERT INTO gbl_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","તોવે શિષ્યહાય ઈસુવાપાય યેઇન પુછ્યાં કા, “પોરમેહેરા રાજ્યામાય કું મોઠો રોય.” ");
INSERT INTO gbl_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","તોવે ઈસુય યોકા પાહાલ ચ્યાહા પાહી હાદિન વોચમાય ઉબો કોઅયો, ");
INSERT INTO gbl_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","એને ઈસુવે આખ્યાં, આંય તુમહાન હાચ્ચાં આખતાહાવ, જાંઉ લોગુ તુમા બદલાયન એને પાહા રોકા નાંય ઓઈ જાહા, તુમા હોરગા રાજ્યામાય જાય નાંય હોકહા. ");
INSERT INTO gbl_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","જો કાદો પોતાલ પાહાહા હારકો નમ્ર કોઅરી, તોજ હોરગા રાજ્યમાય મોઠો ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","એને જો કાદો મા નાવામાય યોક ઓહડા પાહાલ માનહે, તો માન માની લેહે. ");
INSERT INTO gbl_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","કાદાહાટીબી, પોતે ગોગ્યેમાય ગોઅટયે પુડ બાંદિન દોરિયામાય બુડવી દેયના ખારાબ સાજા હેય, બાકી જોવે કાદોબી યા વાહનાહામાઅને માયેવોય બોરહો રાખતેહેં, ચ્યાહા પાપ કોઅના કારણ બોને તે ચ્યાલ યા કોઅતીબી ખારાબ સાજા મિળી. ");
INSERT INTO gbl_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","પાપ કોઅનારા લેદે દુનિયા હારાપી હેય, પાપ કોઅના ઓઅઇ હોકહે, બાકી જ્યા માઅહા લીદે પાપ કોઅહે ચ્યાલ ખારાબ સાજા મિળી. ");
INSERT INTO gbl_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","પાપ કોઅના બોદે કારણે બોંદ કોઆ ચ્યાલ પુરીરીતે મોનાઈ કોઆ જેહેકોય કા પોતે પાગ કાપી રીઅલા હેય, જો તુમહે પાપ કોઅના કારણ બોનહે, જોવે તુમા હોરગામાય જાતહેં, ભલે તુમહેપાય યોક પાગ હેય તીં હારાં હેય, બાકી તુમહેપાય બેન આથ એને બેન પાગ હેય એને તુમા નરકા કોળ્યેમાય જાહા, તે તી ખારાબ હેય. ");
INSERT INTO gbl_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","પાપ કોઅના બોદે કારણે દુઉ કોઆ ચ્યાલ પુરીરીતે મોનાઈ કોઆ જેહેકોય કા પોતે ડોળો બાઆ કાડી દે, જો તુમહે પાપ કોઅના કારણ બોનહે, જોવે તુમા પોરમેહેરા રાજ્યામાય જાતહેં, ભલે તુમહેપાય યોક ડોળો હેય તી હારાં હેય, બાકી તુમહેપાય બેન ડોળા હેય એને તુમા નરકા કોળી જાહા, તે તી ખારાબ હેય. ");
INSERT INTO gbl_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“હાચવીન રા, કા યા વાહાનાહા માઅને કાદાલ નોકામ્યા મા ગોણતા, કાહાકા તુમહાન આંય હાચ્ચાં આખતાહાવ, હોરગામાય ચ્યા હોરગા દૂત મા આબહા આરે કાયામ રોતહા. ");
INSERT INTO gbl_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","કાહાકા આંય, માઅહા પોહો ટાકાઇ ગીઈલાહાન બોચાવાં યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","તુમહાન કાય લાગહે? યોકતા પાય હોવ ગેટેં રોય, એને ચ્યાહામાઅને યોક ટાકાઇ જાય, તોવે નોવાણુ ગેટેં છોડીન, ડોગાવોય ટાકાલા ગેટાલ નાંય હોદા જાય કા? ");
INSERT INTO gbl_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","“જોવે એહેકેન ઓએ કા તો ચ્યા ગેટાલ મેળવે, તે આંય તુમહાન હાચ્ચાં આખતાહાવ, કા તો નોવાણુ ગેટહા કોય ઓલો ખુશ નાંય ઓઅરી, જોલી ખુશી ચ્યા યોકા ગેટાહાટી ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","યાહાટી તુમહે હોરગ્યા આબહા એહેકેન મોરજી નાંય હેય, કા યા વાહાનાહા માઅને યોકબી નાશ ઓઅઇ જાય.” ");
INSERT INTO gbl_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","જોવે તુમહેઆરે કાદો હાંગાત્યો વિસ્વાસી તો વિરુદ પાપ કોઅહે, તોવે જાયન યોખલામાંય ચ્યા બુલ હોમજાડી દે, જોવે તો તુમહે આખલ્યા પાળે, તો તુયે ચ્યાલ જીતી લેદહો. ");
INSERT INTO gbl_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","બાકી જોવે તો નાંય પાળે, તોવે યોક બેન માઅહાન આરે લેતો જો, યાહાટી કા બોદી વાત બેન તીન સાક્ષીયાહા વાતહે કોઇન સાબિત ઓઅઇ. ");
INSERT INTO gbl_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","જોવે તો ચ્યાહાબી નાંય પાળે, તોવે મંડળ્યેલ આખી દે, બાકી જોવે તો મંડળીબી નાંય પાળે, તોવે તુમા ચ્યાઆરે એહેકેન વેવહાર કોઅજા જેહેકોય ગેર યહૂદી એને કર લેનારા આરે કોઅહા. ");
INSERT INTO gbl_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“આંય તુમહાન હાચ્ચાં આખતાહાવ, જીં કાય તુમા દોરત્યેવોય બેગા કોઅહા, તીંજ હોરગામાય બેગા કોઅહા એને જીં કાય તુમા દોરત્યેવોય ખોલાહા, તી હોરગામાય ખુલી. ");
INSERT INTO gbl_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","આંય પાછો તુમહાન આખતાહાવ, જોવે તુમહેમાઅને બેન માઅહે દોરતીવોય યોકદયે જરુરી વાતેહાટી યોકા મોનાકોય પ્રાર્થના કોઇન માગે, ચ્યાહાન હોરગામાઅને આબહો દી. ");
INSERT INTO gbl_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ઈ યાહાટી કા જાં બેન કા તીન મા શિષ્ય ઓઅના લીદે બેગા ઓઅતાહા તાં આંય ચ્યાહા વોચમાય રોતાહાંવ.” ");
INSERT INTO gbl_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","તોવે પિત્તરાય પાહી યેયન ઈસુલ આખ્યાં, “ઓ પ્રભુ, મા હામ્મે મા હાંગાત્યો વિસ્વાસી પાપ કોઅહે, તોવે ચ્યાલ આંય કોલાદા માફ કોઉ? હાંત દા કા?” ");
INSERT INTO gbl_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ઈસુવે ચ્યાલ આખ્યાં, “આંય તુલ એહેકેન નાંય આખું કા હાંત દા માફ કોઓ બાકી હાતા હિત્તેર ગોણા ચ્યાલ માફ કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","“આંય તુલ ઈ આખતાહાવ યાહાટી હોરગા રાજ્યા ચ્યા રાજા હારકા હેય, જ્યેય આપહે ચાકારાહા ઇસાબ લાં માગહે. ");
INSERT INTO gbl_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","એને જોવે ઇસાબ કોઅતો લાગ્યો તોવે યોકા જાંઆલ લેય યેનલા, ચ્યા દસ ઓજાર તાલાંત એટલે યોક તાલાંત પંદર વોરહા મોજર્યે કોરજામાય આતો. ");
INSERT INTO gbl_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","બાકી જોવે ચ્યાપાય કોરજાં ચુકાડાં કાયજ નાંય આતા, તોવે રાજાય આખ્યાં, કા યાલ, યા થેએયેલ એને યા પાહાહાન, એને યા બોદી માલ-મિલકાત વેચિન કોરજાં વોસુલ કોઅરા કોઅયો.” ");
INSERT INTO gbl_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","“તોવે ચ્યે ચાકારે ચ્યા રાજા પાગે પોડીન આખ્યાં, ઓ રાજા વાહાયોક ધીરજ રાખ, આંય તુલ બોદાંજ ચુકતાં કોઅઇ દિહી.” ");
INSERT INTO gbl_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","તોવે ચ્યા ચાકારાવોય રાજાલ દયા યેની, તોવે ચ્યા બોદાંજ કોરજાં માફ કોઅયા એને ચ્યાલ જાં દેનો. ");
INSERT INTO gbl_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“બાકી જોવે તો ચાકાર બાઆ ગીયો, તોવે ચ્યા હાંગાત્યા ચાકાર માઅને યોક બિજો ચાકાર મિળ્યો તો ચ્યા (૧૦૦ દીનાર) હોવ દિહાહા મોજર્યે પોયહા કોર્જદાર આતો, તોવે ચ્યે ચ્યાલ ગોગ્યેમાય દોઇન આખ્યાં, ‘જીં કાય તોપાય કોરજાં હેય ચ્યાલ તું ચુકાડી દે.’” ");
INSERT INTO gbl_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","તોવે ચ્યા હાંગાત્યો ચાકાર ચ્યા પાગે પોડીન વિનાંતી કોઅરા લાગ્યો, વાહાયોક ધીર દોઓ આંય તુલ બોદા કોરજાં ચુકતાં કોઅઇ દિહી. ");
INSERT INTO gbl_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","બાકી તો નાંય માન્યો, ચ્યે જાયને ચ્યાલ જેલેમાય ટાકી દેનો, કા જાંઉ લોગુ તું કોરજાં ચુકાડી નાંય દેય, તાંઉલોગુ તું ઈહીંજ રો. ");
INSERT INTO gbl_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ચ્યા હાંગાત્યા ચાકારાહાય ઈ દેખ્યાં તોવે ચ્યા બોજ નિરાશ ઓઅઇ ગીયા, એને આપહે રાજાપાય જાયને જીં બોન્યાં તીં બોદાંજ આખી દેખાડયાં. ");
INSERT INTO gbl_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","તોવે ચ્યા રાજાય ચ્યાલ હાદિન આખ્યાં, ઓ લુચ્યા ચાકાર, તુયે જીં માન રાવ્યાં કોઅયેલ, તોવે માયે તો બોદા કોરજાં માફ કોઅઇ દેનેલ. ");
INSERT INTO gbl_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","તે જેહેકોય માયે તોવોય દયા કોઇન તો કોરજાં માફ કોઅયા, તેહેકોયન કાય તુલબી તો હાંગાત્યા ચાકારાવોય દોયા કોઇન ચ્યા કોરજાં માફ કોઆ નાંય જોજે કા? ");
INSERT INTO gbl_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","એને ચ્યા રાજાય બોજ ખિજવાઈન ચ્યાલ ડોંડ દેનારાહા આથામાય હોંપી દેનો, કા તો બોદા કોરજાં જાંઉ લોગુ બોઅઇ નાંય પાડે, તાંઉલોગુ ચ્યાલ ઈહીંજ રાખા. ");
INSERT INTO gbl_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","“યેજપરમાણે તુમહેમાઅને જો કાદો પોતે હાંગાત્યા વિસવાશ્યાલ હાચ્ચે મોને પાપ માફ નાંય કોઅઇ, તે મા આબો જો હોરગામાય હેય, તોબી તુમહેઆરે એહેકેનુજ કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","એને એહેકેન જાયા કા યો બોદ્યો વાતો આખ્યો, તોવે ઈસુ એને ચ્યા શિષ્ય ગાલીલ ભાગ છોડીન, યારદેન નોયે ચ્યેમેરે યહૂદીયા શેહેરામાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","એને લોકહા મોઠી ગીરદી ચ્યા પાહલા યેની એને ઈસુય ચ્યાહામાઅને દુઃખહ્યાન હારાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","તોવે પોરૂષી લોકહાય ચ્યાપાય યેઇન ચ્યા પરીક્ષા લાંહાટી ચ્યાલ પુછ્યાં કા, “ગોમે ચ્યે કારણે થેઅયેલ ફારગાતી દેઅના ઈ પરવાનગી હેય કા?” ");
INSERT INTO gbl_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ઈસુવે જાવાબ દેનો કા, “કાય તુમાહાય નાંય વાચ્યાહાં કા જ્યાંય ચ્યાહાન બોનાડયાહા, ચ્યાય પેલ્લેથી ચ્યાહાન માટડો એને થેએ બોનાડ્યા એને આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ચ્યાહાટી યોક માટડો ચ્યા આયહે આબહાલ છોડીન ચ્યા થેઅયેઆરે રોય. એને ચ્યે બેની જાંએ યોકા શરીરા બોની. ");
INSERT INTO gbl_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","એને ચ્યે બેની જાંએ યોકા શરીરા બોની, યાહાટી કા ચ્યે આમીને બેન માઅહા રોકે નાંય, બાકી ચ્યે યોકાજ માઅહા હારકે હેય. યાહાટી કા જ્યાલ પોરમેહેરાય યોકઠા જોડલા હેય, ચ્યાલ કાદાબી માઅહું આલાગ નાંય કોઆ જોજે”. ");
INSERT INTO gbl_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ચ્યાહાય ઈસુલ આખ્યાં, “મૂસા નિયમશાસ્ત્રામાય કાહા એહેકેન ઠોરવ્યાહાં, કા લેખપાત્રી કોઇન ચ્યેલ છોડી દેયના?” ");
INSERT INTO gbl_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ઈસુય ચ્યાહાન આખ્યાં, “તુમા જિદ્દી આતા, ચ્યાહાટી મૂસાય તુમહાન થેએયેલ છોડી દેયના પોરવાનગી દેની, બાકી પેલ્લા એહેકેન નાંય આતા. ");
INSERT INTO gbl_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","બાકી આંય તુમહાન હાચ્ચાં આખતાહાવ કા જો કાદો પોતા થેઅયેલ વ્યબિચાર સિવાય કોઅઇ બિજા કારણથી ફારગાતી દેય, એને જો યાકોય છોડી દેનલ્યે આરે વોરાડ કોએ, તે તો વ્યબિચાર કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","તોવે ચ્યા શિષ્યહાય ચ્યાલ આખ્યાં, “જોવે માટડા થેએયે આરે ઓહડો સબંધ હેય, તોવે વોરાડ કોઅના હારાં નાંય.” ");
INSERT INTO gbl_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","યેયન ચ્યે ચ્યાહાન આખ્યાં, “ઈ વાત બોદે નાંય માની હોકે, માત્ર ચ્યાજ એહેકેન કોય હોકતાહા જ્યાહાન પોરમેહેરાય ચ્યા રીતે જીવાહાટી તાકાત દેનહી. ");
INSERT INTO gbl_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","કાહાકા કોલાહાક નપુસક ઓહડા હેતા, જ્યા જન્માથીજ એહેકેન હેતા, એને કોલાહાક નપુસક ઓહડા હેતા, જ્યાહાલ માઅહાય નપુસક બોનાડયાહા, એને કોલાહાક ઓહડા નપુસક હેતા, જ્યા પોતેજ હોરગા રાજ્યાહાટી નપુસક બોનહ્યા, જ્યા યાલ હોમજી હોકતાહા ચ્યા હોમજી જાય.” ");
INSERT INTO gbl_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","પાછે માઅહે પોહાહાન ઈસુપાય લેય યેને, યાહાટી કા તો ચ્યાહાવોય આથ થોવે એને ચ્યાહા પ્રાર્થના કોએ, બાકી શિષ્ય માઅહાન દોમકાડે. ");
INSERT INTO gbl_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","બાકી ઈસુવે આખ્યાં, “પોહાહાન માયેપાંય યાં દા, ચ્યાહાન ઓટકાડાહા મા, કાહાકા ચ્યાજ લોક જ્યા યા પોહાહા રોકા બોરહાલાયક હેય, હોરગા રાજ્યામાય રોય.” ");
INSERT INTO gbl_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","એને ઈસુય ચ્યાહાવોય આથ થોવિન બોરકાત દેની, પાછે તાઅને ચાલ પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","એને યોક માઅહું યેના એને ચ્યાલ ચ્યે પુછ્યાં, “ઓ ગુરુ, કાય કામ કોઉ કા પોરમેહેર માન અનંતજીવન દી?” ");
INSERT INTO gbl_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ઈસુવાય ચ્યાલ જાવાબ દેનો કા, “હારાં કા મા બારામાય તું માન કાહા પૂછતોહો? હારો તે યોકુજ હેય, બાકી તું અનંતજીવનામાય જાં માગે, તોવે આગનાયો પાળ.” ");
INSERT INTO gbl_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ચ્યે પુછ્યાં કોઅયોહો આગનાયો? ઈસુવે આખ્યાં, “તું ખૂન કોઅહે મા, વ્યબિચાર કોઅહે મા, ચોરી કોઅહે મા, જુઠી સાક્ષી દેહે મા. ");
INSERT INTO gbl_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","તો આબહા એને આયહેલ માન દે, જેહેકોય પ્રેમ પોતાવોય રાખતોહો તેહેકોય બીજહાવોય રાખ.” ");
INSERT INTO gbl_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","જુવાન્યાય ઈસુવાલ આખ્યાં, “ઈ બોદા આંય વાહનેરે પાળતો યેનોહો, આજુ મા કાય બાકી રિયા?” ");
INSERT INTO gbl_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ઈસુવાય ચ્યાએછે પ્રેમથી એઅયા એને ચ્યાલ આખ્યાં, “આજુ યોક વાત હેય જીં તુલ કોઅના જરુરી હેય, જો, જીં કાય તો હેય તીં બોદા વેચિન ગોર-ગોરીબાહાન દેય દે, જોવે એહેકેન કોઅહે, તોવે તોપાય હોરગામાય મિલકાત રોઅરી એને યેયન મા શિષ્ય બોની જો.” ");
INSERT INTO gbl_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ઈ વાત વોનાઈન જુવાન્યો નિરાશ ઓઇન જાતો રિયો કાહાકા તો બોજ માલદાર આતો. ");
INSERT INTO gbl_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","બાકી ઈસુવે ચ્યા શિષ્યહાન આખ્યાં, “તુમહાન હાચ્ચી વાત આખહુ, માલદાર માઅહાન હોરગા રાજ્યમાય જાયના બોજ કોઠાણ હેય? ");
INSERT INTO gbl_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","આંય તુમહાન આખતાહાવ, કા ઉટડાલ હુવ્યે નાકલામાંઅરે જાઅના કોઠાણ હેય, તેહેકોય માલદાર માઅહાન પોરમેહેરા રાજ્યામાય જાઅના બોજ કોઠાણ હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","જોવે શિષ્ય ઈ વાત વોનાયા, ચ્યા આજુ બોજ નોવાય પામી ગીયા, એને યોકા બિજાલ આખતા લાગ્યા કા, “તે પાછે કાહાટી પોરમેહેરા રાજ્યામાય બોચાવ ઓઈ જાઅના કેહેકેન સંભવ હેય?” ");
INSERT INTO gbl_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ઈસુય ચ્યાહા એછે એઇન આખ્યાં, “ઈ માઅહાન તે નાંય ઓઅઇ હોકે, બાકી પોરમેહેરાકોય ઓઅઇ હોકી, કાહાકા પોરમેહેર બોદાંજ કોઅઇ હોકહે.” ");
INSERT INTO gbl_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","પિત્તર ચ્યાલ આખા લાગ્યો, આમે કાય ઓઅરી? “આમાહાય તે તો શિષ્ય બોનાહાટી બોદાંજ છોડી દેનલા હેય તે આમહાન કાય મિળી?” ");
INSERT INTO gbl_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ઈસુવે શિષ્યહાન આખ્યાં, “ચ્યે સમયે જોવે માઅહા પોહો ચ્યા સુંદરતામાય ચ્યા રાજગાદ્યેવોય બોહોરી, તોવે તુમા જ્યા મા શિષ્ય બોન્યાહા, તુમા હોગા બાર રાજગાદ્યેવોય બોહીન ઈસરાયેલ દેશા બાર જાત્યેહે ઉપે ન્યાય કોઅહા.” ");
INSERT INTO gbl_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ઈસુય શિષ્યહાન આખ્યાં, “તુમહાન આંય હાચ્ચાં આખતાહાવ, મા શિષ્ય બોનાહાટી એને પોરમેહેરા હારી ખોબાર આખાહાટી, જ્યા કાદાંયબી ચ્યા ગુઉ છોડી દેનલા હેય, એને બાહા બોઅહી એને આયહો એને આબહો એને પાહાહાન કા ચ્યા ખેતાર છોડયા ઓરી, તો નોક્કીજ યે પેડ્યેમાય સતાવણી આરે-આરે બોજ વસ્તુ મેળવી, એને યેનારા સમયામાય અનંતજીવન મેળવી.” ");
INSERT INTO gbl_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","બાકી બોજ લોક જ્યેં આમી પેલ્લે હેતેં, ચ્યે પાછલા ઓઅરી, એને જ્યેં આમી પાછલા હેય, ચ્યે પેલ્લે ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“હોરગા રાજ્ય યા દાખલા હારકા હેય, યોક દારાખાહા વાડયે માલિક હાકાળેહે નિંગ્યો, કા પોતાની દારાખાહા વાડયેમાય કામાવાળા માઅહાલ કામે લાવે. ");
INSERT INTO gbl_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ચ્યાય કામાવાળાહાન દિનેરોજ યોક દીનાર ઠોરવી, એને ચ્યાહાન દારાખા વાડયેમાય કામ કોઅરા દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","પાછે નવ વાગે ચ્યાય નિંગીન બિજા લોકહાન રીકામા ઉબા રોતા દેખ્યા, ");
INSERT INTO gbl_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","એને ચ્યાહાન વાડયે માલિકાય આખ્યાં, તુમા હોગા મા દારાખાહા વાડયેમાય જાયને કામ કોઆ, એને જીં કાય ઠીક હેય, તીં તુમહાન દિહી તોવે ચ્યાબી કામ કોઅરા ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","પાછે ચ્યે લગભગ બોપરેહે એને ત્રણ વાગેબી નિંગીન તેહેંજ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","આસરે પાચ વાગા પાછે વાડયે માલિક પાછો તાં ગીયો, એને બીજહાન પાછા ઉબલા દેખ્યા, એને ચ્યાહાન વાડયે માલિકાય આખ્યાં, તુમા કાહા રીકામાજ બોદો દિહી ઉમથાજ ઉબા રીયહા? ચ્યાહાય ચ્યાલ આખ્યાં, કાહાકા આમહાન કાદેંજ કામાવોય નાંય લાવ્યાહા. ");
INSERT INTO gbl_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ચ્યાય ચ્યાહાન આખ્યાં” તુમાબી દારાખાહા વાડયેમાય જાં, એને કામ કોઆ. ");
INSERT INTO gbl_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“વોખાતેહે દારાખાહા વાડયે માલિકાય પોતાના કારબાર્યાલ આખ્યાં, કામાવાળાહાન હાદિન જ્યા બોદહાથી છેલ્લે કામ કોઅરાહાટી યેનલા આતા, ચ્યાહાન પાહલા થી લેઈને પેલ્લા લોગુ ચ્યાહા મજરી દેય દે. ");
INSERT INTO gbl_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","જોવે ચ્યે યેને તોવે યોક પારગોજ દિહી રોય ગીઈલો, તોવે ચ્યાહાન યોક-યોક દીનાર એટલે પુરાં દિહા મજરી મિળી. ");
INSERT INTO gbl_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","જ્યેં પેલ્લે યેને ચ્યાહાન ઈ હોમજાયાકા, આમહાન વોદી મિળી, બાકી ચ્યાહાનબી યોક-યોક દીનાર એટલે પુરાં દિહા મજરી મિળી. ");
INSERT INTO gbl_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","જોવે મિળ્યો, તોવે ચ્યા વાડયે માલિકાલ ટુટરીન આખા લાગ્યા, ");
INSERT INTO gbl_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","‘ચ્યા પેલ્લાંહાય યોકુજ કલાક કામ કોઅયા, એને તુયે ચ્યાહાન આમહે બોરાબર કાંબારાં દેના જ્યાહાય દિહી બોઇન કામ કોઅયા તીડકો સહન કોઅયો?’ ");
INSERT INTO gbl_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","વાડયે માલિકાય ચ્યાહામાઅને યોકાલ જાવાબ દેનો, ‘ઓ હાંગાત્યા, તોઆરે આંય અન્યાય નાંય કોઅઇ રીયોહો, કાય પુરાં દિહા કામ કોઅરાહાટી તુયેજ યોક દીનાર બોલી નાંય કોઅયેલ? ");
INSERT INTO gbl_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","જીં તો કાંબારાં હેય, લેય લે એને જાતો રો, મા મોરજી હેય કા જોલાહાં તુલ દાંઉ તોલાહાંજ પાહાલાર્યાહાન બી દાવ. ");
INSERT INTO gbl_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","કાય ઈ ઠીક નાંય હેય કા મા પોયહા મા ઇચ્છા કોઅઇ ખોરચુ? કાય તું ભોલાં ઓરી ચ્યાલ તું તો ખારાબ નોજારે કોઅઇ એઅતહો? બાકી તુલ અદેખાય નાંય લાગા જોજે કાહાકા આંય બીજહાહાટી ઉદાર હેતાંવ?’ ");
INSERT INTO gbl_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","બાકી બોજ લોક જ્યેં આમી પેલ્લે હેતેં, ચ્યે પાછલા ઓઅરી એને જ્યેં આમી પાછલા હેય, ચ્યે પેલ્લે ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ઈસુ યેરૂસાલેમ શેહેરમાય જાત્યે વોખાત ચ્યા બાર શિષ્યહાન એકાંતમાય લેય ગીયો, એને વાટેમાય ચ્યાહાન આખા લાગ્યો, ");
INSERT INTO gbl_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“એઆ, આપા યેરૂસાલેમ શેહેરમાય જાતહા તાં, એને માન, માઅહા પોહાલ મુખ્ય યાજકાહા એને મૂસા નિયમ હિકાડનારા ગુરુ આથામાય દોઅવાય જાય, ચ્યા માન માઆઇ ટાકરી. ");
INSERT INTO gbl_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","એને ગેર યહૂદી લોકહા આથામાય હોઅપી દેઅરી, ચ્યા લોક માન ગાળી દી, મા ઉપે થૂપી, માન ચાપકાહાકોય માર ઠોકી, એને હુળીખાંબાવોય ચોડવી, એને તીજે દિહી પાછો જીવતો ઓઅઇ જાહીં.” ");
INSERT INTO gbl_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","તોવે જબદયા પાહા આયહયે આરે જાયને ઈસુવાપાય યેયન પાગે પોડયેં, એને ઈસુલ રાવ્યાં કોઅરા લાગી. ");
INSERT INTO gbl_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ઈસુવે ચ્યેલ આખ્યાં, “તું કાય માગતીહી?” ચ્યેય ચ્યાલ આખ્યાં, “ઈ વચન દે કા મા યા બેન પાહા તો રાજ્યામાય યોક જાંઆ જમણે આથે એને યોક ડાબે આથે બોહે.” ");
INSERT INTO gbl_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા ઈ નાંય જાંએ કા તુમા કાય માગતેહે? કાય તુમા બોગવાં હાટી તિયાર હેય, જેહેકોય આંય બોગાવનારો હેય, મોઅરાંહાટી જેહેકોય આંય મોઅહી?” ચ્યાહાય ઈસુલ આખ્યાં, “આમહે કોય ઓઅઇ હોકી.” ");
INSERT INTO gbl_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ઈસુય ચ્યાહાન આખ્યાં, “જેહેકોય આંય બોગવીહીં, તેહેકોયજ તુમા બોગવાહા, તુમા મોઅઇ જાહા, જેહેકોય આંય મોઅઇ જાહીં, બાકી માન નોક્કી કોઅના ઓદિકાર નાંય હેય કા મા જમણે એને ડાબે આથે, કું તો માનાપાના જાગો મેળવી, પોરમેહેરાય ચ્યા જાગાલ તિયાર કોઅલા હેય, જ્યાહાન ચ્યાય નિવડયાહા ચ્યાહાહાટી.” ");
INSERT INTO gbl_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ઈ વોનાઈન દોહો શિષ્ય યાકૂબ એને યોહાનાલ ખિજવાયા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","તોવે ઈસુય ચ્યાહાન પાહી હાદિન આખ્યાં કા, “તુમહાન ખોબાર હેય, કા જ્યા લોક યા દુનિયામાય જ્યા ઓદિકારી ગોણાતાહા, ચ્યે ચ્યાહા ઓદિકારા ઉપયોગ ચ્યાહા તાબામાઅને લોકહાઉપે ઓદિકાર ચાલાડાહાટી કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","બાકી તુમહામાય ઓહડા નાંય ઓરી, બાકી તુમહેમાય જો કાદો મોઠો બોના માગહે, તો તુમહે ચાકાર બોને, ");
INSERT INTO gbl_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","એને જો કાદો તુમહામાય મુખ્ય ઓરા માગે, તો તુમહે દાસ બોને. ");
INSERT INTO gbl_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","જેહેકોય કા આંય, માઅહા પોહો, બીજહા સેવા કોઅરાહાટી યા દુનિયામાય યેનો, યાહાટી નાંય યેનો કા બીજે મા સેવા કોએ, આંય ઘોણા લોકહાન ચ્યાહા પાપાહામાને છોડાવાહાટી પોતાનો જીવ દાં યેનો.” ");
INSERT INTO gbl_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","જોવે ચ્યા યેરીખો શેહેરામાઅને નિંગે તોવે, યોક મોઠો ટોળો ચ્યા પાહલા યાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","એને બેન આંદળા, જ્યેં વાટયે મેરાવોય બોઠલા આતા, તો ચ્યા ઈ વાત વોનાયા કા ઈસુ ઇહિને જાય રિયહો, તોવે ચ્યા એહેકેન બોંબલીન આખા લાગ્યા કા, “ઓ પ્રભુ દાઉદ રાજા કુળા પોહા, આમહાવોય દયા કોઓ,” ");
INSERT INTO gbl_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","લોક ચ્યાહાલ દોમકાડા લાગ્યા એને ઠાવકાજ રા આખ્યાં, બાકી ચ્યા આજુ મોઠેરે બોંબાલતા લાગ્યા કા, “ઓ પ્રભુ, દાઉદ રાજા કુળા, આમહાવોય દયા કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","તોવે ઈસુ ઉબો રોઇન, ચ્યાહાન હાદિન આખ્યાં, તુમા કાય માગતાહા કા આંય તુમહેહાટી કાય કોઉ? ");
INSERT INTO gbl_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ચ્યાહાય ચ્યાલ આખ્યાં, “ઓ પ્રભુ, ઈંજ કા આમા દેખતા ઓઅજે.” ");
INSERT INTO gbl_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ઈસુવે ચ્યાહાવોય દયા કોઇન ચ્યાહા ડોળાહાન આથ લાવ્યાં, એને ચ્યા તારાતુજ દેખતા જાયા, એને ચ્યા પાહલા વાટ દોઇન ચાલા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","જોવે ઈસુ એને ચ્યા શિષ્ય યેરૂસાલેમ શેહેરા પાહી યેય પોઅચ્યા, એને જૈતુન ડોગાવોય બેતફાગે પાહી યેના, તોવે ઈસુવાય ચ્યા બેન શિષ્યહાન એહેકેન આખીન દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“હામ્મેને ગાવામાય જાં, એને તાં જાતાંજ તુમહાન યોક ફુરક્યા વાછડાં હેય ચ્યાવોય આજુ લોગુ કાદોજ નાંય બોઠહો, તીં બાંદલા નોજરે પોડી, ચ્યાલ છોડીન માયેપાંય લેય યા. ");
INSERT INTO gbl_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","જો કાદાં તુમહાન કાય પુછે, તોવે એહેકેન આખજા,? ઈસુ આમે પ્રભુલ યા ઉપયોગ કોઅના ગોરાજ હેય, એને તો ચ્યાલ તારાતુજ લેય દોવાડી.” ");
INSERT INTO gbl_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ઈ યાહાટી જાયા, કા જીં વચન પોરમેહેરાય ભવિષ્યવક્તાહાથી આખલા આતા, તી પુરાં ઓએ. ");
INSERT INTO gbl_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“યેરૂસાલેમ શેહેરા લોકહાન આખા, એઆ, તુમહે રાજા તુમહેપાય યેય રિઅલો હેય, તો નમ્ર હેય, એને વોજો ઉચાકનારા ફુરક્યા વાછડા ઉપે બોહીન યેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","શિષ્યહાય જાયને, જેહેકોય ઈસુવા આખલ્યે પરમાણેજ જાવાબ દેનો, ");
INSERT INTO gbl_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","એને ચ્યા બેન શિષ્ય ફુરક્યા વાછડાલ ઈસુપાય લેય યેના, એને ચ્યાવોય ચ્યાલ બોહાંહાટી ફુરક્યા વાછડા બોઅડા વોય પોતાને ફાડકે પાથ્યેં એને તો વાસડાવોય બોહી ગીયો, એને યેરૂસાલેમ શેહેરા એછે જાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","બોજ લોકહાય ઈસુ હામ્મે વાટેઊપે પોતાના ફાડકે પાથ્યેં, એને લોકહાય ચ્યાલ માનપાન દાંહાટી વાટેવોય જાડાહા પાલાવાળ્યો ડાળખ્યો પાથ્યો, જ્યો ચ્યા લોક રાનહામાઅને વાડીન લિયેનલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","એને કાંયક લોકહા ટોળો ઈસુવા આગલા-આગલા ચાલતો આતો, એને કાંયક પાહલા ચાલતો આતો, ચ્યા બોદા ખુશ્યેકોય બોંબલી રીયલા આતા, “દાઉદ રાજા પોહા હોસાન્ના, ધન્ય હેય તો જો પ્રભુ નાંવા કોય યેહે, હોરગામાય હોસાન્ના.” ");
INSERT INTO gbl_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","જોવે ઈસુ યેરૂસાલેમ શેહેરમાય ગીયો, તોવે બોદા શેહેરામાય દાવ દોડ ઓઅઇ ગિઇ એને પૂછતેં લાગ્યેં, “એલો કું હેય?” ");
INSERT INTO gbl_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","લોકહાય જાવાબ દેનો કા, “એલો ગાલીલ ભાગામાઅને નાજરેત ગાવા ભવિષ્યવક્તા ઈસુ હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ઈસુ એને ચ્યા શિષ્ય યેરૂસાલેમ શેહેરામાય પોઅચ્યા, એને પોરમેહેરા દેવાળા બાઆપુર ગીયા, ઈસુ ચ્યા લોકહાન તાઅને બાઆ કાડના સુરુ કોઅયા, જ્યા બલિદાનાહાટી ઉપયોગ ઓઅનારે જોનાવારે એને બાકી વસ્તુ વેચાતાં લાંહાટી એને વેચાંહાટી કામ કોઅઇ રીયલા આતા, ચ્યાય પોયહા બોદાલનારાહા બાકડાહાન ડેકલી દેના, એને ચ્યાય કબુતર વેચનારાહાપાંય જાયન વેચનારાહા ખુરચ્યેહેલ કોથલાડી દેને. ");
INSERT INTO gbl_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ચ્યાહાન ઈસુવે હિકાડીન એહેકેન આખ્યાં કા, “કાય પવિત્રશાસ્ત્ર ઈ નાંય આખે, કા મા દેવાળાલ બોદયે જાત્યે લોકહાહાટી પ્રાર્થના ગુઉ આખલા જાય? બાકી તુમાહાય તીં બાંડાહા ગુઉ બોનાવી રાખ્યાહાં.” ");
INSERT INTO gbl_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","આંદળા એને લેંગડા દેવાળામાય ચ્યાપાય યેના, એને ચ્યે ચ્યાહાન હારાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","બાકી જોવે મુખ્ય યાજકાહા એને મૂસા નિયમ હિકાડનારા ગુરુ ઈસુ મોઠે કામે, જ્યેં ચ્યાય કોઅલે, એને પોહાહાન દેવાળામાય “દાઉદ રાજા પાહા હોસાન્ના” એહેકેન બોંબલીન આખતા વોનાયા, તોવે ચ્યા ખિજવાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","એને ચ્યાહાય ચ્યાલ પુછ્યાં, “યેં કાય આખતેહે તીં તું વોનાય રિયહો કા?” ઈસુવે જાવાબ દેનો, “હાં, એને કાય તુમાહાય પવિત્રશાસ્ત્રામાય ઈ કોદહી નાંય વાચ્યાહાં: કા પોહાહા એને દુદ પિતા પાહાહા મુયેથી, તુયે મહિમા કોઆડી?” ");
INSERT INTO gbl_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","તોવે ચ્યાહાન છોડીન તો શેહેરા બારે બેથાનીયા ગાવામાય ગીયો, એને રાત તાં રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","હાકાળેહે પાછો શેહેરામાય યેહે, તોવે ચ્યાલ બુખ લાગી. ");
INSERT INTO gbl_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","વાટે મેરાવોય ચ્યે યોક અંજીરા જાડ દેખ્યાં એને ચ્યા પાહી ગીયો, બાકી પાલાંજ દેખાયાં, તોવે ઈસુવે જાડાલ આખ્યાં, “આમી પાછે તુલ કોઅઇ દિહી, ફળ નાંય લાગરી” અંજીરા જાડ તારાતુજ ઉખાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ઈ એઇન શિષ્યહાન બોજ નોવાય લાગી ચ્યાહાય આખ્યાં, “ઈ અંજીરા જાડ કેહેકેન તારાતુજ ઉખાય ગીયા?” ");
INSERT INTO gbl_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","બાકી ઈસુવે ચ્યાહાન જાવાબ દેનો, “આંય તુમહાન હાચ્ચાં આખતાહાવ, જોવે તુમા બોરહો કોઅહા એને મોનામાય શંકા નાંય કોઅહા, તોવે યા અંજીરા જાડાલ ઓલાહાંજ નાંય, બાકી એલા ડોગાલ તુમા આખહા, જો, એને દોરિયામાય જાય પોડ, તોવે ઈ ઓઅઇ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","એને જીં કાય તુમા પ્રાર્થનામાય માગતાહા, ઓહડો બોરહો રાખા કા તી તુમહાન મિળી જાય, તોવે પોરમેહેર ચ્યાહાટી ઈ કોય દી.” ");
INSERT INTO gbl_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ઈસુ એને ચ્યા શિષ્ય પાછા યેરૂસાલેમ યેય ફૂગ્યા, એને જોવે તો દેવાળામાય હિકાડે તોવે મુખ્ય યાજક, મૂસા નિયમ હિકાડનારા ગુરુ એને આગેવાન ચ્યા ચ્યાપાય યેયન પુછા લાગ્યા. “તુલ યેં કામે કોઆહાટી તોપાય કાય ઓદિકાર હેય? કુંયે તુલ ઓહડા ઓદિકારાહાતે દોવાડયોહો?” ");
INSERT INTO gbl_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","તોવે ઈસુય ચ્યાહાન આખ્યાં, “આંયબી તુમહાન યોક સાવાલ પૂછતાહાવ, જોવે ચ્યા તુમા માન જાવાબ દાહા, પાછે આંય કા ઓદિકારાકોય કામ કોઅતાહાંવ તીં તુમહાન આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","જોવે યોહાનાય લોકહાન બાપતિસ્મા દેના, તે કાય ચ્યા ઓદિકાર હોરગામાઅને પોરમેહેરા એહેરે કા માઅહા એહેરે આતો? માન આખા.” તોવે ચ્યા જાતેજ વિચાર કોઆ લાગ્યા કા હોરગામાઅને આખહુ તોવે, તો આમહાન આખરી કા, તોવે તુમાહાય ચ્યાવોય કાહાનાય બોરહો થોવ્યો? ");
INSERT INTO gbl_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","એને જોવે આમા માઅહા એહેરે આખહુ તોવે કાય ઓઅઇ? ચ્યા યા હારકો જાવાબ નાંય દેય કાહાકા ચ્યા લોકહાથી બિઅતા આતા, જ્યા ઈ માનતા આતા કા, યોહાન પોરમેહેરા પાયને યોક હાચ્ચો ભવિષ્યવક્તા આતો. ");
INSERT INTO gbl_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","એને ચ્યાહાય ઈસુવાલ જાવાબ દેનો કા, “આમા નાંય જાંઆજે કા યોહાનાલ લોકહાન બાપતિસ્મા દાંહાટી કુંયે દોવાડલો” તોવે ઈસુય ચ્યાહાન આખ્યાં, તે “આંયબી તુમહાન નાંય જાવાબ દાંઉ કા, ઈ કામ આંય કોઅહા ઓદિકારાકોય કોઅહુ.” ");
INSERT INTO gbl_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“તુમા યા દાખલા કોય કાય હોમાજતાહા? યોક માઅહા બેન પોહા આતા ચ્યે મોઠા પોહાલ જાયને આખ્યાં, ‘મા પોહા આજે દારાખા વાડયેમાય કામ કોઅજે.’ ");
INSERT INTO gbl_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ચ્યે જાવાબ દેનો, ‘આંય નાંય જાવ,’ બાકી પાછે ચ્યાલ ચ્યા જાવાબાવોય પોસ્તાવો યેનો એને વાડયેમાય કામ કોઅરા જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","તોવે ચ્યે બિજા પોહાપાય જાયને તેહેંજ આખ્યાં, ચ્યે જાવાબ દેનો, ‘ઠીક આંય જાહાંવ,’ બાકી તો નાંય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","યા બેની પોહામાઅને આબહા મોરજી પરમાણે કુંયે કોઅયા?” ચ્યાહાય આખ્યાં, “પેલ્લાય” ઈસુવે ચ્યાહાન આખ્યાં, “આંય તુમહાન હાચ્ચી વાત આખતાહાવ, કા જકાતદાર એને વેશા કામ કોઅનારે પોરમેહેરા રાજ્યામાય તુમહે કોઅતા પેલ્લા જાય. ");
INSERT INTO gbl_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","આંય તુમહાન એહેકેન યાહાટી આખહુ કાહાકા યોહાન બાપતિસ્મા દેનારાય જોવે તુમહાન આખ્યાં, કેહેકેન હારાં જીવન જીવા જોજે, તોવે તુમાહાય ચ્યાવોય બોરહો નાંય કોઅયો: બાકી જાકાતદારે એને વેશા કામ કોઅનારે પાપ કોઅના બોંદ કોઅઇ દેના એને ચ્યા બોરહો કોઅયો, ઈ બોદા એઇન બી તુમાહાય પાપ કોઅના બોંદ નાંય કોઅયા એને ચ્યા બોરહો નાંય કોઅયો.” ");
INSERT INTO gbl_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","“પાછો ઈસુ બિજા દાખલા દેયન યહૂદીયાહા આગેવાનાહાઆરે વાત કોઆ સુરુ કોઅયા યોક માઅહાય ચ્યા રાનામાય દારાખા વાડી લાવી, ચ્યાય રાના ચોમખી દોગડાહા યોક બીતડા બોનાવ્યાં, એને યોક રોહયા ખાડો ખોદયો, ચ્યાય બાંડાહા એને જોનાવરહા ઇહિને રાના હાંબાળ કોઅરાહાટી યોક માળો પાડ્યો, પાછે ચ્યાય ચ્યા રાનાલ કોલહાક ખેડુતાહાન બાગે દેય દેના એને બિજા દેશા એછે લાંબી મુસાફીર્યેલ નિંગી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","જોવે દારાખેં પાકી ગીયે, તે ચ્યા ચાકારાહામાઅને યોકાલ બાગ્યા ખેડુતાપાય દોવાડયો, કા ચ્યાલ દારાખાહા વાડયેમાઅને ભાગ લી યેય. ");
INSERT INTO gbl_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","બાકી ખેડુતાહાય ચ્યાલ દોઇન માર દેનો, એને ચ્યાલ કાયજ નાંય દેના એને પાછો દોવાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","પાછો વાડયે માલિકાય બિજા ચાકારાહાન દોવાડયા, જ્યા પેલ્લા કોઅતા વોદારી આતા, બાકી ચ્યા ખેડુતાહાય ચ્યાહાનબી તેહેંજ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","સેવાટ ચ્યે ચ્યા પોહાલ દોવાડયો, કાહાકા ચ્યે એહેકેન જાંઅયા કા, મા પોહા ચ્યા દાક રાખી. ");
INSERT INTO gbl_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","બાકી જોવે ખેડુતાહાય ચ્યા પોહાલ યેતા દેખ્યા, તે ચ્યાહાય યોક બીજહાન આખ્યાં, ‘એલો તે વારસદાર હેય, ચાલા, એલાલ આપા માઆઇ ટાકતા, તોવે વારસો આપહે ઓઅઇ જાઅરી.’ ");
INSERT INTO gbl_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","એને ખેડુતાહાય ચ્યાલ દોઇન, દારાખા વાડયે બાઆ લેય જાયને માઆઇ ટાક્યો. ");
INSERT INTO gbl_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","જોવે તો દારાખા વાડયે માલિક યી તોવે તુમહાન કાય લાગહે કા દારાખાહા વાડયે માલિક કાય કોઅરી?” ");
INSERT INTO gbl_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","તો યેયન ચ્યા ખેડુતાહાન માઆઇ ટાકી, એને દારાખાહા વાડી બીજહાન દેય દી. ");
INSERT INTO gbl_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ઈસુવે ચ્યાહાન આખ્યાં, “પવિત્રશાસ્ત્રામાય લોખલાં હેય તીં તુમાહાય કાદે દિહે નાંય વાચ્યાહાં: ‘જ્યા દોગાડાલ કોડયાહાય નોકામ્યો હોમજ્યેલ, તોજ ખૂણા પાયા મુખ્ય દોગાડ બોની ગીયો, એલા પ્રભુ એસને ઓઅયા, એને આમે નોજાર માય તીં અદભુત હેય?’” ");
INSERT INTO gbl_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","“ચ્યાહાટી આંય તુમહાન આખહુ, કા પોરમેહેરા રાજ્ય તુમહે પાયરે લેય લેવામાય યી, એને ચ્યાહાન દેનલા જાય, જીં પોરમેહેરા આગનાયો માની. ");
INSERT INTO gbl_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","જીં કાદાં માઅહું યા દોગડા ઉપે પોડી, ચ્યા ટુકડા-ટુકડા ઓઅઇ જાય, બાકી જ્યા ઉપે ઓ દોગાડ પોડી, ચ્યાલ બુપટા બોનાડી દી.” ");
INSERT INTO gbl_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","મુખ્ય યાજક એને પોરૂષી લોક દાખલા વોનાઈન હોમજી ગીયા કા ઈસુ આમહે વિરુદમાય આખહે. ");
INSERT INTO gbl_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ચ્યા ઈસુવાલ દોઈ દાં માગેત બાકી ચ્યા લોકહાન બીયેત કાહાકા લોક ઈસુવાલ ભવિષ્યવક્તા માનેત. ");
INSERT INTO gbl_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","આજુ ઈસુ ચ્યાહાન દાખલા દેયન આખા લાગ્યો, ");
INSERT INTO gbl_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“હોરગા રાજ્ય યા દાખલા હારખા હેય, યોક રાજા આતો, ચ્યા પોહા વોરાડ કોઅયા, ");
INSERT INTO gbl_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","એને ચ્યાય ચ્યા ચાકારાહાન વોરાડામાય આમંત્રિત લોકહાન હાદાં દોવાડયા, બાકી ચ્યા નાંય યાં માગેત. ");
INSERT INTO gbl_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","આજુ યોકદા ચ્યે બિજા ચાકારાહાન દોવાડયા, એને ચ્યાહાન આખ્યાં, ‘જ્યાહાન હાદહ્યા ચ્યાહાન આખા કા એએયા, માયે જેવાણ તિયારી કોઅયા, એને મા બોયલ એને પાળલે વાછડેં ખાંહાટી માઅલે હેતેં, એને બોદા તિયારીજ હેય, વોરાડા જેવણામાય યા.’ ");
INSERT INTO gbl_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","બાકી ચ્યાહાય નોજાર અંદાજ કોઅયી બાકી ચ્યા પોત-પોતેહે કામે નિંગી ગીયા, કોલાહાક જાંઆ રાન ગીયા એને કોલાહાક જાંઆ વેપાર કોઅરા ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","એને બીજહાંય ચ્યા ચાકારાહાન દોઓઈન નકાર કોઅયા એને માઆઇ ટાક્યા. ");
INSERT INTO gbl_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","જોવે રાજા ઈ વોનાયો, તોવે રાજા ખિજવાઈ ગીયો, એને ચ્યા સીપાડાહાલ દોવાડીન ચ્યા ખૂન્યાહાન માઆઇ ટાક્યા, એને ચ્યાહા શેહેરેં બાળી ટાક્યેં. ");
INSERT INTO gbl_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","પાછે ચાકારાહાન આખ્યાં, ‘વોરાડા જેવાણ તે તિયારીજ હેય બાકી હાદલા લોક લાયકે નાંય બોન્યા. ");
INSERT INTO gbl_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","યાહાટી આમી તુમા બારે બોદે જાગે જાયા, એને જોલાબી લોક તુમહાન મીળે, ચ્યા બોદહાન વરાડામાય ખાં હાદી લીયા.’ ");
INSERT INTO gbl_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ચાકાર બારે ગીયા, એને બોદહાન ટોળો કોઅયા, હારાં માઠાં જીં મિળ્યાં તીં, એને વોરાડયો માંડવો વોરાડયાહા કોય બાઆઈ ગીયો.” ");
INSERT INTO gbl_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“જોવે રાજા વોરાડયાહાન એરા માજા યેનો, તોવે ચ્યે તાં યોક માઅહાલ દેખ્યો, તો વોરાડા ફાડકે પોવ્યા વોગાર યેનેલ. ");
INSERT INTO gbl_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","તોવે રાજાય ચ્યાલ પુછ્યાં, ‘ઓ મા દોસ્તાર, વોરાડા ડોગલેં પોવ્યા વોગાર તું ઈહીં કાહા યેનો?’ બાકી તી માઅહું ઠાવકાજ રિયા. ");
INSERT INTO gbl_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","તોવે રાજાય ચાકારાહાન આખ્યાં, ‘એલાલ આથ પાગ બાંદિન બાર્યા આંદારામાય ટાકી દિયા, તાં એલા રોડના એને દાત કોકડાવના રોય.’ ");
INSERT INTO gbl_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","કાહાકા બોજ લોક હાદલા હેતા બાકી નિવાડલા વોછાજ હેતા.” ");
INSERT INTO gbl_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","તોવે પોરૂષી લોકહાન જાયને આંદાર-આંદાર વિચાર કોઅયા, કા ચ્યાલ કેહેકેન વાત્યેહેમાય ફસાવજે. ");
INSERT INTO gbl_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ચ્યાહાય પોતાના શિષ્યહાન હેરોદ લોકહા ટોળા આરે ઈસુવાપાય ઈ આખા દોવાડયા, “ઓ ગુરુ, આમા જાંઅજેહે કા, તું સાદા હાચ્ચાં આખતોહો એને તું યા બારામાય ચિંતા નાંય કોએ કા લોક તો બારામાય કાય વિચાર કોઅતાહા, કાહાકા તું બોદહાઆરે હારકો વેવાહાર કોઅતોહો, બાકી પોરમેહેરા વાટ હાચ્ચાયે પરમાણે હિકાડતોહો. તે પાછે આમી આમહાન આખ, કાય કૈસરાલ કર દેઅના આમે નિયમા વિરુદ હેય? ");
INSERT INTO gbl_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","તે પાછે આમી આમહાન આખ, કાય કૈસરાલ કર દેઅના આમે નિયમા વિરુદ હેય?” ");
INSERT INTO gbl_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ઈસુવાય ચ્યાહા ખારાબી એઇન આખ્યાં, “ઓ ડોંગી તુમા માન જુઠા આખવાકોય ફસવા કોશિશ કાહા કોઅય રીઅલા હેય?” ");
INSERT INTO gbl_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","માન યોક દીનાર (૧ દીનાર એટલે યોકા દિહા કાંબારાં ઓઅહે) આંઆઈ દિયા, માન એરા દિયા. ");
INSERT INTO gbl_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","તોવે ચ્યે ચ્યાહાન આખ્યાં, “ઓ ફોટો એને નાંવ કા હેય?” ");
INSERT INTO gbl_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ચ્યાહાય આખ્યાં, “કૈસરા” તોવે ચ્યે ચ્યાહાન આખ્યાં, “જીં કૈસર રાજા હેય, તીં કૈસરાલ દિયા, એને જીં પોરમેહેરા હેય, તીં પોરમેહેરાલ દિયા.” ");
INSERT INTO gbl_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ઈ વોનાઈન, ચ્યાહાન નોવાય લાગી, એને ચ્યાલ છોડીન ચ્યા ચાલ પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ચ્યેજ દિહી સાદૂકી ટોળા કોલહાક લોક ઈસુવાપાય યેના, સાદૂકી ટોળો ઈ માનેત કા મોઅલા માઅને પાછા જીવતા નાંય ઓઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ચ્યાહાય ચ્યાલ પુછ્યાં. “ઓ ગુરુ, મૂસાય આખલા આતા, કા જોવે કાદો પોહાલ પૈદા કોઅયા વોગાર મોઅઇ જાય, તો ચ્યા બાહા ચ્યા થેઅયેઆરે વોરાડ કોઇન ચ્યા બાહાહાટી પોહેં પૈદા કોએ. ");
INSERT INTO gbl_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","આમી આમહે ઈહીં હાંત બાહા આતા, બોદહા મોઠા બાહાય વોરાડ કોય લેદા બાકી વોગાર પોહાહા તો મોઅઇ ગીયો. ચ્યાહાટી ચ્યે થેએયેલ બિજા બાહે રાખી. ");
INSERT INTO gbl_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","યેજપરમાણે બિજા બાહે ચ્યે વિધવાયેલ રાખી લેદી, બાકી તોબી વોગાર પાહાહા મોઓઈ ગીયો, એને તીજ વાત તીજા બાહા આરે જાઈ. એને બોદા હાંતી બાહાહા આરે જાઈ, ");
INSERT INTO gbl_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","છેલ્લે, તી થેએબી મોઓઈ ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","એને આમી આમહાન આખ, આમી યે થેએયે વોરાડ હાંત માટડાઆરે ઓઅયા, તે જોવે મોઅલા માઅને પાછા જીવતા ઓઈ, તોવે તી કા થેએ રોય? કાહાકા તી હાંતહ્યા થેએ આતી.” ");
INSERT INTO gbl_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા જુઠા હેય કાહાકા તુમા નાંય જાંએતકા પવિત્રશાસ્ત્ર કાય આખહે, એને તુમા પોરમેહેરા સામર્થ્યા બારામાય નાંય જાંએત. ");
INSERT INTO gbl_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","કાહાકા જોવે મોઅલા માઅને પાછા જીવી ઉઠી, તોવે તે નાંય માટડા એને નાંય થેઅયો વોરાડ કોઅરી, બાકી હોરગામાય રોનારા પોરમેહેરા દૂતહા રોકે રોય. ");
INSERT INTO gbl_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","એને મોઅલા માઅને પાછા જીવી ઉઠી ચ્યા બારામાય તુમાહાય નાંય વાચ્યાહાં કા તુમહાન પોરમેહેર આખહે. ");
INSERT INTO gbl_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘આંય આબ્રાહામા પોરમેહેર, એને ઈસાકા પોરમેહેર, એને યાકૂબા પોરમેહેર હેતાઉ?’ તો મોઅલાહા પોરમેહેર નાંય, બાકી જીવતાહા પોરમેહેર હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","જોવે ચ્યા ઈ વોનાયા, તોવે ચ્યા, ચ્યા હિકાડનાથી બોજ નોવાય પામ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","જોવે પોરૂષી લોક વોનાયા કા ઈસુવે સાદૂકીયાહાન ઠાવકાજ રાખ્યા, તોવે ચ્યા ટોળો વોળ્યા, ");
INSERT INTO gbl_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","એને ચ્યાહામાઅને યોક મૂસા નિયમ હિકાડનારો ગુરુ, ઈસુવા પારાખ કોઅરાહાટી ચ્યાલ પુછ્યાં કા. ");
INSERT INTO gbl_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“જોલ્યો આગના નિયમશાસ્ત્રામાય દેનહ્યો, ચ્યાહામાઅને બોદયેહેમાય મોહત્વા આગના કોઅહી?” ");
INSERT INTO gbl_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ઈસુય ચ્યાલ આખ્યાં, “પ્રભુ પોરમેહેરાવોય તો પુરાં મોનથી, એને બોદા જીવા કોઇન, એને આખી બુદયે કોઅઈન, એને આખ્યે ગોત્યે કોઇન પ્રેમ રાખજે. ");
INSERT INTO gbl_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ઈજ પેલ્લી એને મુખ્ય આગના હેય. ");
INSERT INTO gbl_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","એને બીજી યા રોકીજ હેય કા, તો પોતાવોય જોલો પ્રેમ રાખતોહો તોલોજ તું તો પોડોશાવોય તો રોકો પ્રેમ રાખ. ");
INSERT INTO gbl_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","યોજ બેની આગના બોદા નિયમશાસ્ત્રા એને ભવિષ્યવક્તાહા આધાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","જોવે પોરૂષી લોક યોખઠા આતા, તોવે ઈસુવે ચ્યાહાન પૂછ્યાં: ");
INSERT INTO gbl_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“ખ્રિસ્તા બારામાય તુમહાન કાય લાગહે? તો કા પોહો હેય?” ચ્યાહાય જાવાબ દેનો, “દાઉદ રાજા.” ");
INSERT INTO gbl_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “તોવે દાઉદ રાજા આત્મામાય રીન ચ્યાલ કેહેકેન પ્રભુ આખી હોકહે?” ");
INSERT INTO gbl_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","પ્રભુ પોરમેહેરાય મા પ્રભુવાલ આખ્યાં, “તું મા જમણે આથે બોહો, જાવ લોગુ આંય તો દુશ્માનાહાન આરવી નાંય દાંઉ તાંઉલોગુ.” ");
INSERT INTO gbl_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","દાઉદ રાજા પોતેજ ચ્યાલ પ્રભુ આખહે, પાછે તો ચ્યા પોહો કેહેકેન ઓઅહે? ");
INSERT INTO gbl_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","કાદો ચ્યાલ યોકબી વાત આખી નાંય હોક્યા, એને તોદહિને ચ્યાહાન સાવાલ પૂછના કાદા ઈંમાત નાંય ચાલી. ");
INSERT INTO gbl_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","પાછે ઈસુવે લોકહા ટોળાહાન એને ચ્યા શિષ્યહાન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોકહાપાંય મૂસા નિયમાહાલ ઉંડેથી હમજાડના ઓદિકાર હેય. ");
INSERT INTO gbl_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ચ્યાહાટી તુમહાન ચ્યા જીં કાય આખે તી બોદા કોઆ એને પાળા, બાકી ચ્યાહા હારકા કામે તુમા મા કોઅહા, કાહાકા ચ્યા હિકાડતાહા બાકી ચ્યા પાળેત નાંય. ");
INSERT INTO gbl_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ચ્યા બોજ બાઆય વોજો બોઇન માઅહા ખોવાહાવોય થોવતાહા, બાકી તી ઉસલાં હાટી યોક આંગળી બી નાંય લાવેત.” ");
INSERT INTO gbl_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ચ્યા બોદા કામ માઅહાલ દેખાડાં હાટી કોઅતાહા જ્યેહેવોય ચ્યા પવિત્રશાસ્ત્રા વચન લોખીન માથાવોય એને આથા આરે બાંદતા આતા, એને પોતાના ફાડકાહા છેડા પોઅળા કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","જેવાણેહેમાય માનાપાના જાગો ચ્યાહાન ગોમહે, એને સોબાયે ઠિકાણે મુખ્ય જાગો જોજે. ");
INSERT INTO gbl_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","આટામાય સલામ લેઅના એને લોક ચ્યાહાન ગુરુ આખતાહા ઈ ચ્યાહાન બોજ ગોમહે. ");
INSERT INTO gbl_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","તુમા ગુરુજી નાંય આખાડના, કાહાકા તુમહે યોકુજ ગુરુ હેય: એને તુમા બોદા બાહા બોઅહી રોકા હેતા. ");
INSERT INTO gbl_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","આપહે શારીરિક આબહાલ છોડીન કાદાલબી દોરત્યેવોય આબહા માન નાંય દેયના કાહાકા પોરમેહેર તુમહે યોકુજ આબહો હેય, જો હોરગામાય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","એને તુમા કાદાલ “માલિક” મા આખહા કાહાકા તુમહે માલિક યોકુજ હેય, એટલે ખ્રિસ્ત. ");
INSERT INTO gbl_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","તુમહેમાય જો મોઠો ઓરા માગહે તો તુમહે ચાકાર રા જોજે. ");
INSERT INTO gbl_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","જીં માઅહું ચ્યા પોતેજ મોઠા બોના માગહે, તો વાહનો બોનાડલો જાય, એને જીં માઅહું પોતેજ વાહના બનેહે, ચ્યાલ મોઠો બોનાડલો જાય. ");
INSERT INTO gbl_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","ઓ ડોંગ્યાહાય મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોકહાય તુમહાવોય હાય, તુમા મુશીબાતમાય હેય, તુમા માઅહા વિરુદ હોરગા રાજ્યા બાઅણે બંદ કોઅઇ દેતહા, તુમા પોતે ચ્યામાય નાંય જાત, એને ચ્યામાય જાનારાહાલ બી નાંય જાં દેત. ");
INSERT INTO gbl_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ઓ ડોંગ્યા મૂસા નિયમ હિકાડનારા ગુરુવાહાય એને પોરૂષીહાય તુમા મુશીબાતમાય હેય, તુમા વિઘવા બાયહે ગોએ લુટી લેતહા, એને બીજહાન દેખાડાહાટી લાંબી વાઆ પ્રાર્થના કોઅતાહા, પોરમેહેર હાચ્ચાંજ ચ્યાહાન કોઠાણ સાજા દી. ");
INSERT INTO gbl_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ઓ ડોંગ્યા મૂસા નિયમ હિકાડનારા ગુરુવાહાય એને પોરૂષી લોકહાય તુમા મુશીબાતમાય હેય, તુમા યોકા જાંઆલ તુમહે શિષ્ય બોનાડાહાટી બોદેજ જાગે જાતાહા, એને જોવે તો તુમહે શિષ્ય ઓઅઇ જાહાય તોવે ડાબાલ નરકા કોળી લાયકે બોનાડતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","ઓ આંદળા આગેવાનાહાય તુમા મુશીબાતમાય હેય, તુમા એહેકેન આખતાહા કા દેવાળા કોસામ ખાય તોવે કાય ફેર નાંય, બાકી દેવાળા હોના કોઇન કોસામ ખાય તો બાંદાય જાય. ");
INSERT INTO gbl_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ઓ મુર્ખાહાય, ઓ આંદળાહાય, કું મોઠો હેય, હોના કા દેવાળ જ્યાકોય હોના પવિત્ર ઓઅહે? ");
INSERT INTO gbl_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","એને આખતાહા વેદ્યે કોસામ ખાય તે તોવે કાય ફેર નાંય, બાકી વેદ્યેવોય ચોડાવલી બેટે કોઇન કોસામ ખાય તોવે બાંદાય જાય. ");
INSERT INTO gbl_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ઓ આંદળાહાય, કું મોઠા હેય, બેટ મોઠી કા વેદી જ્યેકોય બેટ પવિત્ર બોનહે? ");
INSERT INTO gbl_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","યાહાટી જો વેદ્યે કોસામ ખાહે, તો ચ્યે, એને જીં કાય ચ્યાવોય હેય, ચ્યે બેટે બી કોસામ ખાહે. ");
INSERT INTO gbl_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","એને જીં માઅહું દેવાળા કોસામ ખાય તો દેવાળા એને દેવાળામાય વોહતી કોઅનારા પોરમેહેરા કસમ ખાય. ");
INSERT INTO gbl_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","જીં માઅહું હોરગા કોસામ ખાય તી પોરમેહેરા સિંહાસન એને ચ્યાવોય બોહનારા કોસામ ખાહે. ");
INSERT INTO gbl_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","ઓ ડોંગ્યા મૂસા નિયમ હિકાડનારા ગુરુવાહાય, એને પોરૂષી લોકહાય તુમહાવોય હાય, તુમા ફુદીના, એને સોફ, એને જીરા દોસમો ભાગ દેતહા, બાકી તુમાહાય નિયમશાસ્ત્રા ગંભીર વાતો એટલે ન્યાય, એને દયા, એને બોરહાલ છોડી દેનહા, ગોમે તે તુમા યાલ બી કોઅતા રોતા, એને યાલ બી નાંય છોડતા. ");
INSERT INTO gbl_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ઓ આંદળા ગુરુવાહાય, તુમા મોગાહાલ કાડી ટાકતાહા બાકી ઉટડાલ ગીળી જાતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","ઓ ડોંગ્યા મૂસા નિયમ હિકાડનારા ગુરુવાહાય એને પોરૂષી લોકહાય તુમહાવોય હાય, તુમા થાળી ઉપે-ઉપે ચોળતાહા, માજે લોબ એને વ્યબિચાર બોઆલા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","ઓ આંદળા પોરૂષી લોકહાય, પેલ્લા વાટકા એને થાળી માજેરે ચોળા તોવે બાઆરે બી ચોખ્ખાં ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","ઓ ડોંગ્યા મૂસા નિયમ હિકાડનારા ગુરુવાહાય એને પોરૂષી લોકહાય તુમહાવોય હાય, તુમા ચુના લાવલા માહણા હારકા હેતા બાઆરે હારેં ઉજળેં દેખાતેહે, બાકી માજે મોઅલા માઅહા આડકે એને બોદા હોડલા બાઆલા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","તેહેંજ કોઇન તુમા ઉપેરે બોદહાન હારાં ન્યાયી દેખાતાહા, બાકી માજે ડોંગ એને પાપાહા કોઇન બોઆલા હેતા. ");
INSERT INTO gbl_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","ઓ ડોંગ્યા મૂસા નિયમ હિકાડનારા ગુરુવાહાય એને પોરૂષી લોકહાય તુમહાવોય હાય, તુમા ભવિષ્યવક્તાહા માહણે હુદરાવતાહા એને ન્યાયી લોકહા માહણે બોનાવતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","એને એહેકેન આખતાહા, જોવે આમા આમે આગલા ડાયહા સમાયામાય રોતા તે ભવિષ્યવક્તાહાલ માઆઇ ટાકાડનામાય ભાગી નાંય રોતા. ");
INSERT INTO gbl_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","યાકોય તુમા પોતાવોય સાબિતી કોઅતાહા, કા તુમા ભવિષ્યવક્તાહાલ માઆઇ ટાકનારા પાહા તુમાંજ હેતા. ");
INSERT INTO gbl_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","માન માલુમ હેય, કા પોતાના ચ્યા પાપહાલ પુરાં કોઅનારા હેય, જ્યાહાન આપહે આગલા ડાયહાય સુરુ કોઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","ઓ હાપડા હારખા જેરીવાળા લોક એને ચ્યાહા પોહાહાય તુમા નરકા કોળી ડોંડા કોય નાંય બોચહા. ");
INSERT INTO gbl_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","યાહાટી મા આખલ્યા વોનાયા, આંય તુમહાપાય ભવિષ્યવક્તા, બુદ્યેવાળા એને મૂસા નિયમ હિકાડનારા ગુરુહુલ દોવાડુહુ, એને તુમા ચ્યાહામાઅને કોલાહાલ યોક માઆઇ ટાકહા, એને કોલહાક હુળીખાંબાવોય ચોડવાહા, એને કોલહાક તુમહે સોબાયે ઠિકાણે ચોપકાહા માર ઠોકહા, એને કોલહાક યોકા ગાવામાઅને બિજા ગાવામાય તાંગાડતા ફીરહા. ");
INSERT INTO gbl_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ન્યાયી હાબેલાથી લેઈને બીરીક્યા પોહો જખરિયા લોગુ, જ્યાલ તુમાહાય દેવાળા એને બેટ ચોડાવના વેદ્યે વોચમાય માઆઇ ટાક્યો, જોલા ન્યાયી લોકહા ખૂન જાયા, બોદા તુમહેવોય યેય પોડી. ");
INSERT INTO gbl_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","આંય તુમહાન હાચ્ચાં આખતાહાવ, યા બોદહા ખૂન કોઅના સાજા યે પેડયે લોકહાવોય યી પોડી. ");
INSERT INTO gbl_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ઓ યેરૂસાલેમ શેહેરા લોકહાય, ઓ યેરૂસાલેમ શેહેરા લોકહાય, તુમા ભવિષ્યવક્તાહાલ માઆઇ ટાકતાહા, જ્યાહાલ તુમહેપાય દોવાડયેલ, ચ્યાહાન તુમા દોગડાકોય ઠોકતાહા. કોલાદા માયે યોકઠા કોઅરા ઇચ્છા કોઅયી, કા જેહેકોય કુકડી પિચલાહાલ પાખડા તોળે બોચાવ કોઅહે, તેહેકોય આંયબી તો પાહાહાન રાખવાળી કોઉ, બાકી તુમહે ઇચ્છા નાંય આતી. ");
INSERT INTO gbl_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","યાહાટી આમી હોમજી લા કા તુમહે ગોઅ તુમહેહાટી ઉજાડ કોઅવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","કાહાકા આંય તુમહાન આખતાહાવ, કા આમીને લેઈને જાવ લોગુ તુમા નાંય આખહા, બોરકાત વાળો હેય જો, પ્રભુ ઓદિકારાકોય યેહે, તાંવ લોગુ તુમા માન પાછા કોદહી નાંય એઅહા. ");
INSERT INTO gbl_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","જોવે ઈસુ દેવાળામાઅને નિંગીન જાં આતો, તોવે ચ્યા શિષ્ય દેવાળા રચના દેખાડાં હાટી ચ્યાપાય યેના. ");
INSERT INTO gbl_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા ઈ બોદા એએતાહા બાકી, આંય તુમહાન આખહુ, યોકબી દોગાડ પોતે જાગાવોય નાંય છોડી, ચ્યા બોદા નાશ કોઅઇ દી.” ");
INSERT INTO gbl_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","જોવે તો જૈતુના ડોગાવોય બોઠલો આતો, તોવે એકાંતમાય શિષ્યહાય યેયન પુછ્યાં, “આમહાન આખ કા યો વાતો કોવે ઓઅરી? તો યેયના એને દુનિયા છેવાટે કાય નિશાણી રોય?” ");
INSERT INTO gbl_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ઈસુવે ચ્યાહાન આખ્યાં, “હાચવીન રોજા કા તુમહાન કાદો નાંય છેતરે. ");
INSERT INTO gbl_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","બોજ લોક મા નાંવા કોઇન યી, ચ્યે આખી, આંય ખ્રિસ્ત હેતાઉ, એને બોજ લોકહાન ચ્યાહા માનાડાંહાટી છેતરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","બાકી જોવે તુમા લોડાઈ, એને લોડાયેહે વાતો વોનાયાહા, તોવે મા ગાબરાયાહા, કાહાકા ઈ ઓઅનારાંજ હેય, બાકી દુનિયા છેવાટ તારાત નાંય ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","યોક જાતી લોક ગેર યહૂદી લોકહાવોય હમલો કોઅરી એને યોક દેશા લોક બિજા દેશા લોકહા વિરુદ લોડી, બોદેજ દોરતીકંપ ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","એને કાળ પોડી એને ઈ દુઃખ પોહાહા જન્મા પેલ્લા ઓઅનારી પીડાયે હારકા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","તોવે જ્યા લોક તુમહે વિરુદ કોઅતાહા ચ્યા આબદા દાંહાટી તુમહાન દોઅવાડી દી, એને તુમહાન માઆઇ ટાકવામાય યી, કાહાકા તુમા મા શિષ્ય હેય યા લેદે, બોદી જાત્યા લોક તુમહેઆરે દુશ્માની કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","તોવે બોજ લોક માયેવોય બોરહો કોઅના બંદ કોઅઇ દી, એને યોકબિજાલ દોઅવાડી, એને યોકબીજાઆરે આડાઇ કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","એને બોજ જુઠા ભવિષ્યવક્તા નિંગી, એને બોજ લોકહાન દોગો દી. ");
INSERT INTO gbl_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","એને પાપહાલીદે બોજ લોક યોકા બિજાવોય પ્રેમ નાંય કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","બાકી જ્યા લોક માયેવોય બોરહો કોઅનામાય લાગી રોય, એને દોરત્યેવોય ચ્યા જીવના છેલ્લે લોગુ મા પાહલા ચાલતો રોય, ચ્યા પાપહા ડોંડ બોગાવનાથી તારણ ઓઅઇ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","એને પોરમેહેરા રાજ્યા ઈ હારી ખોબાર બોદા દુનિયામાય પોઅચાડવામાય યી, કા બોદી જાત્યે લોકહાન પોરમેહેરાવોય બોરહો કોઆ મોકો મીળે, તોવે દુનિયા છેવાટ ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","યોક દિહી તુમા ખારાબ વાના દેખહા જ્યા વાત દાનિએલ ભવિષ્યવક્તાથી ઓઅયેલ, દેવાળાલ છોડી દેવામાય યી, તો ચ્યા જાગાવોય ઉબો રોય જાં ચ્યાલ ઉબો રોઅના કાયજ ઓદિકાર નાંય હેય. જો કાદો વાચહે તો યાલ હોમજાંહાટી કોશિશ કોએ, જોવે તો સમય યી. ");
INSERT INTO gbl_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","જ્યા લોક યહૂદીયા વિસ્તારામાય હેય ચ્યાહાન બોચાંહાટી ડોગહાવોય નાહી જાં પોડી. ");
INSERT INTO gbl_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","જો ગોઆ ઉપે ચોડયો ઓરી, તો કાયબી લાંહાટી પાછા નિચે ગોઆમાય નાંય ઉરાય; ");
INSERT INTO gbl_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","એને જો રાનામાય ગીયો ઓરી તો, ડોગલાં લાંહાટી પાછો ગોઓ નાંય વોળી યેય. ");
INSERT INTO gbl_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ઈ ચ્યે બાયહેહાટી યોક નોવાય લાગે ઓહડો સમય ઓઅરી જ્યો મોયનાવાળ્યો હેય, એને ચ્યો બાયો જ્યો પોહાહાન દુદ પાજી રિઅલ્યો હેય, ચ્યેહેલ નાહરાં બોજ કોઠાણ પોડી. ");
INSERT INTO gbl_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","યાહાટી પ્રાર્થના કોઅયા કોઆ કા ઈ બોદા હીયાળામાય નાંય બોને, જોવે મુસાફીર કોઅરા કોઠાણ પોડે, પાછે આરામા દિહી એહે તેહે નાહરાં નાંય પોડે. ");
INSERT INTO gbl_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ચ્યા દિહહામાય લોક બોજ ગંભીર રીતે પીડિત ઓઅરી, જેહેકોય લોકહાય કોદહી ઓહડો સામનો નાંય કોઅલો હેય જોવે પોરમેહેર પેલ્લા દુનિયા બોનાવલા આતા, લોક પાછા એહેકેન પીડિત નાંય ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","બાકી પોરમેહેરાય ચ્યા દુ:ખા દિહી ઓછા કોઅઇ દેઅના નિર્ણય લેદલો હેય, નેતે, કાદાબી જીવા બોચાવ નાંય ઓઅતો, બાકી ચ્યા નિવડી લેદલાહા લીદે જ્યાલ ચ્યાય નિવડયાહા, ચ્યા દિહહાલ ઓછા કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","ચ્યે સમયે તુમહાન યોકતા એહેકેન આખે કા, એઆ, ખ્રિસ્ત ઈહીં હેય, કા એઆ તાં હેય, તોવે તુમા બોરહો મા થોવતા. ");
INSERT INTO gbl_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","“કાહાકા જુઠા ખ્રિસ્ત્યા એને જુઠા ભવિષ્યવક્તા યી, એને ઓહડે મોઠે ચમત્કારાહા ખોટેં કામે કોઅનારા બોની, કા ચ્યા લોકહાન દોગો દાંહાટી જ્યાહાલ પોરમેહેરાય નિવડી લેદલા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","એઆ, માયે તુમહાન પેલ્લાજ ઈ બોદા ઓઅરી ચ્યા બારામાય આખી દેનહા. ");
INSERT INTO gbl_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","યાહાટી જોવે ચ્યે તુમહાન એહેકેન આખરી, ‘એઆ, તો ઉજાડ જાગામાય હેય,’ તે બારે નાંય નિંગી જાઅના, યા ‘એઆ, તો ખોલ્યેમાય હેય’, તે ચ્યાહાવોય બોરહો નાંય કોઅના.” ");
INSERT INTO gbl_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","કાહાકા જેહેકોય વીજળી દિહી ઉદ્યા પાયને નિંગીન દિહી બુડતા લોગુ ચમકેહે, તેહેકોયજ માઅહા પોહા બી યેયના ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","જાં મુરદાં હેય તાંજ ગીદ બેગા ઓઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ચ્યા દિહાહામાય, બોજ પીડા સમય બંદ ઓઅરા પાછે” દિહી એને ચાંદ ઉજવાડો દેઅના બંદ કોઅય દી, એને આકાશામાઅને ચાંદાલેં ટુટી પોડી, એને આકાશામાઅને પરાક્રમ આલી જાય. ");
INSERT INTO gbl_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","તોવે માઅહા પાહા ચિન્હે આકાશામાય દેખાડી દી, એને તોવે આખી દોરત્યેવોયને બોદા લોક છાતી ઠોકી, એને માઅહા પોહાલ મોઠા સામર્થ્યમાંય એને મહિમા ને હાતે આકાશા વાદળાઊપે યેતા દેખી. ");
INSERT INTO gbl_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","તો રણસીંગડા મોઠા આવાજા આરે પોતાના દૂતહાન દોવાડી, એને તો આકાશા યા છેડાપાયને તે ચ્યા છેડા લોગુ, ચારી ચોમખીને ચ્યા નિવાડલા લોકહાન બેગા કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“અંજીરા જાડાવોયને ઓ દાખલો હિકાં, જોવે ચ્યા કોવળ્યો ડાળખ્યો ફૂટત્યોહો એને ડાહાગ્યો પીલવાત્યો લાગે, તોવે તુમહાન ખોબાર પોડહે કા ચોમહા સમય પાહાય યેય ગીયહો. ");
INSERT INTO gbl_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","તેહેંજ કોઇન, જોવે ઈ બોદા તુમહાન બોનતાં દેખાય, તોવે તુમહાન ખોબાર પોડી જાં જોજે કા દુનિયા છેલ્લો સમય યેય ગીયહો એને તો દુઉ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","આંય તુમહાન હાચ્ચાં આખતાહાવ, કા ઈ બોદા યે પેડયે લોક તોવેબી જીવતા રોય જોવે ઓહડા બોનાવ બોની. ");
INSERT INTO gbl_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","આકાશ એને દોરતી નાશ ઓઅઇ જાય, સાદામાટે નાંય રોય, બાકી માયે જીં આખ્યાહા તી સાદામાટે હાચ્ચાં રોય.” ");
INSERT INTO gbl_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","યો વાતો કોઅયેહે ગેડયે એને કોઅહે દિહયે ઓઅરી કાદાજ નાંય જાંએ, નાંય હોરગા દૂત જાંએ, નાંય પોરમેહેરા પોહો જાંએ, બાકી આબહોજ ઓ દિહી એને ઈ ગેડી જાંએ. ");
INSERT INTO gbl_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","જેહેકોય નોહા દિહી આતા, તેહેકેન માઅહા પોહા યેયના બી ઓઅઇ. ");
INSERT INTO gbl_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","કાહાકા જેહેકોય રેલ યેઅના પેલ્લા દિહીહયામાય, જોદીહી લોગુ નોહો ઉડીમાય નાંય ચોડયેલ, ચ્યા દિહયા લોગુ લોક ખાં-પિયાં આતા, એને ચ્યા વોરાડે બી કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","એને જાંઉ લોગુ રેલ યેઇન ચ્યાહાન વોવાડી નાંય લી ગીયી, તાંઉલોગુ ચ્યાહાન કાંઇજ ખોબાર નાંય પોડ્યા, તેહેકોયજ માઅહા પોહા બી યેઅના ઓરી. ");
INSERT INTO gbl_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ચ્યા સોમાયામાય બેન માઅહે રાનામાય રોય, યોક લેય લેવામાય યી એને બિજાં છોડી દેવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","બેન થેએયો ગોઅટયે બોહીન દોળી, ચ્યેહેમાઅને યોક લેય લેવામાય યી એને બીજી છોડી દેવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","યાહાટી ઈસુય શિષ્યહાન આખ્યાં કા, તુમા નાંય જાંએ કા પ્રભુ કોવે પાછો યી. ");
INSERT INTO gbl_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","બાકી ઈ જાંઆય લીયા કા જો ગાઆ માલિકાલ એહેકોય માલુમ રોતા કા બાંડ કોઅહે વેળાયે યી, તે તો જાગતો રોતો, એને પોતે ગોઆમાય ચોરી નાંય ઓઅરા દેતો. ");
INSERT INTO gbl_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","યાહાટી તુમાબી તિયાર રા, કાહાકા જ્યેં વેળાયે બારામાય તુમા જાંએબી નાંય, ચ્યે વેળાયે માઅહા પોહો યેય જાય. ");
INSERT INTO gbl_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“આમીં: બોરહાવાળો એને બુદ્ધિમાન ચાકાર કું હેય, જ્યાલ માલિકાય પોતાના નોકાર-ચાકારાવોય કારબારી બોનાડયોહો, કા તો વેળાયે વોય ચ્યાહાન ખાઅના દેય? ");
INSERT INTO gbl_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ધન્ય હેય, તો ચાકાર, જ્યાલ માલિક યેઇન એહેંજ કોઅતો એએ. ");
INSERT INTO gbl_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, તો ચ્યાલ ચ્યા પોતાની બોદી મિલકાત્યે ઓદિકારી બોનાડી દી. ");
INSERT INTO gbl_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","બાકી જોવે મૂર્ખ ચાકાર એહેકેન વિચાર કોઆ લાગે કા, મા માલિકા યેયના આજુ વાઆ હેય. ");
INSERT INTO gbl_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","એને પોતાના ચાકારાહાન માર ઠોકાં લાગે, એને પીનારાહા આરે ખાય-પિયે. ");
INSERT INTO gbl_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","તોવે તો ચ્યા ચાકારા માલિક પાછો યી, જોવે તો ચ્યા વાટ નાંય જોવે, એને ઓહડા સોમાયા જ્યા બારામાય તો જાંઆય બી નાંય. ");
INSERT INTO gbl_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","તોવે તો ચ્યાલ બોજ કોઠાણ સાજા દેયન, એને ચ્યા ભાગ ડોંગ્યા લોકહાઆરે ગોણવામાય યી: જાં રોડના એને દાત કોકડાવના હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“પાછે ઈસુય ચ્યાજ શિષ્યહાન આખ્યાં, જોવે આંય, માઅહા પોહો પાછો યીહીં, તોવે હોરગા રાજ્ય ચ્યે દોહો કુંવારીયેહે પરમાણે ઓઅરી; જ્યો પોતાના દિવા લેઈને વોવડાલ મિળાં નિંગ્યહો. ");
INSERT INTO gbl_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ચ્યેહેમાય પાચ મૂર્ખ એને પાચ હોમાજદાર આત્યો. ");
INSERT INTO gbl_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","મૂર્ખ કુંવારીહેય ચ્યેહે દિવા તે લેદા, બાકી ચ્યેહેય જૈતુના તેલ નાંય લેદા. ");
INSERT INTO gbl_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","બાકી જ્યો હોમાજદાર આત્યો ચ્યેહેય દિવા આરે સીચહયેમાય જૈતુના તેલ બી બોઅઇ લેદા. ");
INSERT INTO gbl_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","જોવે વોવડાલ યાં વાઆ લાગી ગીયી, તોવે ચ્યે બોદહયેન નિંદ યા લાગી, એને ચ્યો હૂવી ગીયો.” ");
INSERT INTO gbl_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“આરદ્યે રાતી બોંબલા લાગ્યે: એઅયા, વોવડો યેય રિયહો, ચ્યાલ મિળાં ચાલા.” ");
INSERT INTO gbl_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","તોવે બોદ્યો કુંવારીયો ઉઠીન ચ્યેહે દિવા હારાં કોઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","એને ચ્યે મૂરખ્યેંહેય હોમાજદારહયેલ આખ્યાં, તુમહે જૈતુના તેલામાંઅને વાયજ આમહાનબી દિયા, કાહાકા આમહે દિવા ઉલાય જાં કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","બાકી હોમાજદારહ્યેય જાવાબ દેનો કા ઈ તેલ આમે એને તુમહેહાટી પુરાં નાંય ઓઅરી, હારાં તે ઈ હેય કા તુમા વેચનારાહાપાંય જાયને પોતાહાટી વેચાતાં લીયા. ");
INSERT INTO gbl_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","જોવે ચ્યો વેચાતાં લાં જાત, તોવે વોવડો યેય પોઅચ્યેલ, એને જ્યો તિયારી આત્યો, ચ્યો ચ્યાઆરે વોરાડા ગોઆમાય જાત્યો રિયો એને બાઅણા લાવી લેદા. ");
INSERT INTO gbl_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","યા પાછે બીજ્યો કુંવારીયોબી યેયન વોવડાલ આખા લાગ્યો, ઓ માલિક, આમહેહાટી બાઆં ઉગાડી દે. ");
INSERT INTO gbl_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ચ્યાય જાવાબ દેનો, કા આંય તુમહાન હાચ્ચાંજ આખતાહાવ, કા આંય તુમહાન નાંય વોળખું. ");
INSERT INTO gbl_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","યાહાટી જાગતા રિયા, કાહાકા તુમહાન નાંય ખોબાર મા પાછા યેયના બારામાય, એને ચ્યા સોમાયા બારામાય. ");
INSERT INTO gbl_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“હોરગા રાજ્ય ચ્યા માઅહા હારકા હેય, જ્યાંય પારદેશ જાતી વેળાયે પોતાના ચાકારાહાન હાદિન ચ્યાહાન ચ્યા મિલકાત્યે માઅને કોલહાક પોયહા હોઅપી દેના. ");
INSERT INTO gbl_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ચ્યે યોકાલ પાચ ઓજાર દેના, બિજાલ બેન, એને તીજાલ યોક, એટલે બોદહાન ચ્યાહા લાયકાત પરમાણે દેના, તોવે તો પારદેશ ચાલ્યો ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","તોવે જ્યાલ પાચ તાલાંત મિળ્યાં એટલે યોક તાલાંત પંદર વોરહા મોજરી ઓઅહે, ચ્યાય તારાતુજ જાયને વેપાર કોઅયો એને પાચ બિજા પાછા કામાવ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ચ્યેજ રીતેકોય જ્યાલ બેન તાલાંત મિળ્યાં, ચ્યાય બી પાછા બેન તાલાંત કામાવ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","બાકી જ્યાલ યોક તાલાંત મિળ્યો, ચ્યાય જાયને દોરતી ખોદી એને ચ્યા માલિકા દેનલા તાલાંત દોબાડી દેના.” ");
INSERT INTO gbl_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“બોજ દિહયા પાછે ચ્યા ચાકારાહા માલિક યેનો એને ચ્યાહાપાઅને ઇસાબ લેતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","જ્યાલ પાચ ઓજાર મિળ્યેલ, તો પાચ ઓજાર પાછા લેય યેયન આખા લાગ્યો, ‘ઓ માલિક, તુયે માન પાચ ઓજાર હોપલા, એએ માયે બિજા પાચ ઓજાર કામાવ્યાહા.’ ");
INSERT INTO gbl_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ચ્યા માલિકાય ચ્યાલ આખ્યાં, ધન્ય હેય મા લાયક્યે એને ઈમાનદાર ચાકાર, તું વોછામાય ઈમાનદાર રિયો, આંય તુલ બોજ વસ્તુહુ ઓદિકારી બોનાડહી, તો માલિકા આનંદામાય ભાગીદાર બોન.” ");
INSERT INTO gbl_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“એને જ્યાલ બેન ઓજાર મિળ્યેલ, ચ્યાય બી યેયન આખ્યાં, ‘ઓ માલિક, તુયે માન બેન ઓજાર હોપલા, એએ, માયે બેન ઓજાર પાછા કામાવ્યાહા.’ ");
INSERT INTO gbl_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ચ્યા માલિકાય ચ્યાલ આખ્યાં, ધન્ય હેય મા લાયક્યે એને ઈમાનદાર ચાકાર, તું વોછામાય ઈમાનદાર રિયો, આંય તુલ બોજ વસ્તુહુ ઓદિકારી બોનાડહી, તો માલિકા આનંદામાય ભાગીદાર બોન.” ");
INSERT INTO gbl_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“તોવે જ્યાલ યોક ઓજાર મિળલા આતા, ચ્યાય યેયન આખ્યાં, ‘ઓ માલિક, આંય તુલ જાંઅતો આતો કા, તું બોજ કોડાક માઅહું હેય: તું ઓહડા માઅહા રોકો હેય જો નાંય બિયારો પોઅય બાકી પાક યોખઠા કોઅના આશા રાખહે.’ ");
INSERT INTO gbl_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","યાહાટી જોવે આંય તો પોયહા ટાકી દાંઉ તે તું માન સાજા દેહે, એને જાયન તો પોયહા દોરત્યેમાય દાટી દેના, એએ જીં તો હેય, તી ઈ હેય. ");
INSERT INTO gbl_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","ચ્યા માલિકાય ચ્યાલ જાવાબ દેનો, ઓ નોકામ્યા એને આળહ્યા ચાકાર, જોવે તું જાંઅતો આતો કા આંય ઓહડા માઅહા રોકો હેય, જો નાંય બિયારો પોઅય બાકી પાક યોખઠા કોઅના આશા રાખહે. ");
INSERT INTO gbl_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","તે તુયે જાંઆ જોજતાં કા, મા પોયહા સાવકારાપાય થોવી દેતો, તોવે આંય યેયન મા પોયહા વિયાજ હાતે લી લેતો. ");
INSERT INTO gbl_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","તોવે ચ્યા માલિકાય બિજા ચાકારાહાન આખ્યાં, ચ્યા વોઅરે પોયહા લીયા એને જ્યાવોય દસ ઓજાર હેય ચ્યાલ દેય દા. ");
INSERT INTO gbl_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","કાહાકા જ્યા પાય હોમાજ હેય, તો વોદારી હોમાજ મેળવી, બાકી જ્યા પાય કાય હોમાજ નાંય મીળે, ચ્યાપાય જીં વોછીબી હોમાજ ઓરી તીં બી ચ્યાપાઅને ખોવાય જાય.” ");
INSERT INTO gbl_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ચ્યા નોકામ્યા ચાકારાલ બારે આંદારામાય ટાકી દા, જાં રોડના એને જાં દાત કોકડાવના ઓરી. ");
INSERT INTO gbl_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“જોવે આંય, માઅહા પોહો પાછો યીહીં, તોવે આંય મા મહિમામાય યીહીં એને બોદા હોરગા દૂતહાન મા આરે લેય યીહીં, તોવે આંય બોદા લોકહા ન્યાય કોઅરાહાટી પોતે મહિમામય રાજ્યાસનાવોય બોહહી. ");
INSERT INTO gbl_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","એને બોદી જાત્યો મા હામ્મે યોક્ઠી કોઅવામાય યી, એને જેહેકોય યોક ગોવાળ ગેટાહાલ એને બોકડાહાલ આલાગ કોઅઇ દેહે, તેહેકોય આંય ચ્યાહાન યોકબિજાથી આલાગ કોઅઇ દિહી. ");
INSERT INTO gbl_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","આંય ગેટાહાલ એટલે જ્યા ન્યાયી લોકહાન ચ્યા જમણી એછે એને બોકડાહાલ એટલે ખારાબ લોકહાન મા ડાબી એછે ઉબે કોઅહી. ");
INSERT INTO gbl_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","તોવે, રાજા ચ્યા જમણી વાળાહાલ આખરી, ‘ઓ મા આબહા બોરકાતવાળા લોક, યા, એને મા એને ચ્યા રાજ્યા ઓદિકારી ઓઅઇ જાય, જીં દુનિયા શુરવાતથી તુમહેહાટી તિયારી કોઅલા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","કાહાકા આંય બુખો આતો, એને તુમાહાય માન ખાઅના દેના, આંય તરસ્યો આતો તોવે તુમાહાય માન પાઆઈ દેના, આંય પારકો આતો, બાકી તુમાહાય માન તુમહે ગોઆમાય જાગો દેનો. ");
INSERT INTO gbl_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","આંય ઉગાડો આતો, એને તુમાહાય માન ડોગલેં પોવાડયે, આંય માંદગી માય આતો, તોવે તુમાહાય મા ચાકરી કોઅયી, આંય જેલેમાય આતો તોવે તુમા માન મિળાં યેના.’” ");
INSERT INTO gbl_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“તોવે ન્યાયી માન જાવાબ દેઅરી, ‘ઓ પ્રભુ, આમાહાય તુલ કોવે બુખો દેખ્યો, એને ખાઅના ખાવાડ્યા? કા તરસ્યો આતો તોવે પાઆઈ પાજ્યાં? ");
INSERT INTO gbl_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","આમાહાય તુલ કોવે પારકો દેખ્યો એને આમે ગોઅમે રાખ્યો કા ઉગાડો દેખ્યો, એને ડોગલેં પોવાડયે? ");
INSERT INTO gbl_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","આમાહાય કોવે તુલ બિમાર કા જેલેમાય દેખ્યો, એને તુલ મિળાં યેના?’ ");
INSERT INTO gbl_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","તોવે રાજા ચ્યાહાન જાવાબ દી, આંય તુમહાન હાચ્ચાં આખતાહાવ કા, તુમાહાય મા યા વાહનામાય વાહના શિષ્ય માઅને યોકા આરેબી કોઅયા, તી માંજ આરે કોઅયા?” ");
INSERT INTO gbl_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“તોવે તો ડાબી બાજુ વાળાહાલ આખરી, ઓ હારાપી લોક, મા હામ્મેથી ચ્યે નરકા કોળ્યેમાય જાતે રા, જો સૈતાન એને ચ્યા દૂતહાહાટી પોરમેહેરાય તિયાર કોઅયીહી. ");
INSERT INTO gbl_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","કાહાકા આંય બુખો આતો, એને તુયે માન ખાઅના નાંય દેના: આંય તરસ્યો આતો, એને તુયે માન પાઆઈ નાંય પાજ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","આંય પારકો આતો, એને તુમાહાય માન તુમહે ગોઅ નાંય રાખ્યો, આંય ઉગાડો આતો એને તુમાહાય માન ડોગલેં નાંય પોવાડયે, આંય બિમાર એને જેલેમાય આતો, એને તુમાહાય મા હાંબાળ નાંય લેદી.” ");
INSERT INTO gbl_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","“તોવે ચ્યા જાવાબ દેઅરી, ‘ઓ પ્રભુ આમાહાય તુલ કોવે બુખો, એને તરસ્યો, કા પારકો, કા ઉગાડો, કા બિમાર, કા જેલેમાય દેખ્યો, એને તો સેવા નાંય કોઅયી?’ ");
INSERT INTO gbl_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","તોવે આંય જાવાબ દિહી, આંય તુમહાન હાચ્ચાં આખહુ કા તુમાહાય યા વાહનામાય વાહના યોકા બી શિષ્યા આરે નાંય કોઅયા, તી મા આરેબી નાંય કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","એને જ્યેં ડાબી બાજુ હેતેં ચ્યે સાદામાટે અનંત નાશમાય જાય, બાકી ન્યાયી લોક અનંતજીવનામાય પ્રવેશ કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","જોવે ઈસુય યો બોદ્યો વાતો આખ્યો પાછે, પોતાના શિષ્યહાન આખતો લાગ્યો, ");
INSERT INTO gbl_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","આમી પાસ્કા સણ એને બેખમીર બાખ્યે સણ બેન દિહયા પાછે સુરુ ઓઅનારો હેય, એને માન, માઅહા પોહાલ હુળીખાંબાવોય ચોડવાહાટી દોઆડી દી. ");
INSERT INTO gbl_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","તોવે મુખ્ય યાજક એને લોકહા આગેવાન કાયફા નાંવા મહાયાજકા ગોઆ બાઆપુર યોખઠા જાયા. ");
INSERT INTO gbl_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","એને ચ્યાહાય મિળીન ઈસુલ અપમાનિત રીતે દોઇન ચ્યાલ માઆઇ ટાકાડના વિચાર કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","બાકી ચ્યા આખે કા, “આપહાન પાસ્કા સણા દિહે એહેકેન નાંય કોઅરા જોજે, કાહાકા લોકહામાય દામાલ ઉસબી જાય.” ");
INSERT INTO gbl_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ચ્યે સમયે ઈસુ બેથાનીયા શેહેરામાય સિમોના ગોઅમે, જ્યાલ ઈસુય કોડા બીમાર્યે માઅને હારો કોઅલો આતો ખાં બોઠેલ. ");
INSERT INTO gbl_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ઓલહામાય યોક બાય સંગેમરમર દોગડા બોનાવલી યોક બાટલી લેય યેની, જ્યેમાય અત્તાર તેલ બોઅલાં આતા, જીં ચોખ્ખાં જાટામાસીથી બોનાડલા અત્તાર તેલથી બોઅલાં આતા, એને બાટલ્યે મુયાઈહને તોડી દેના, એને તી ઈસુલ સન્માન દાંહાટી ઈસુ માથાવોય બોદા અત્તાર તેલ રેડી દેના. ");
INSERT INTO gbl_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","શિષ્યહાય ઈ દેખ્યાં તોવે ખિજવાઈન બોદા આખા લાગ્યા, અત્તાર કાહા બોગાડયા? ");
INSERT INTO gbl_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ઈ બોજ મોઅગાં વેચાતાં એને ચ્યા પોયહા ગોરીબાહાન વાટી દેવાતા. ");
INSERT INTO gbl_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ઈસુવે ઈ જાઇન આખ્યાં, “તુમા બાયેલ કાય કોઅરા ખીજવાતાહા? ચ્યે તે મા હાટી હારાં કામ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","કાહાકા ગોરીબ લોક તુમહેપાય કાયામ રોઅનારાજ હેતા બાકી આંય તુમહેઆરે કાયામ નાંય હેતાઉ. ");
INSERT INTO gbl_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ચ્યે મા શરીરાવોય જીં અત્તાર તેલ રેચવ્યાહા, તી માન દાટાહાટી તિયારી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","આંય તુમહાન હાચ્ચાં આખતાહાવ કા આખા દુનિયામાય જાં કેસ હારી ખોબાર આખવામાય યી, તાં એલ્યેય માંહાટી જીં કોઅયાહાં, તીં ચ્યે યાદગીર્યેહાટી આખવામાય યી.” ");
INSERT INTO gbl_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","તોવે યહૂદા ઇસ્કારીયોત જો બાર શિષ્યહા માઅને યોક શિષ્ય આતો, તો મુખ્ય યાજકાહાપાય ગીયો એને આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","એને ચ્યે આખ્યાં ચ્યાલ આંય તુમહે કોબજે કોઅઇ દિહી, તુમા માન કાય દાહા? ચ્યાહાય ચ્યાલ તીહી ચાંદ્યે સિક્કા તોલીન દેય દેના. ");
INSERT INTO gbl_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","પાછે તો ઈસુવાલ ચ્યાહા આથામાય દોઆડી દેઅના મોકો હોદતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","“બેન દિહયા પાછે, બેખમીર પાસ્કા સણા પેલ્લે દિહે શિષ્યહાય ઈસુવાપાય જાયને આખ્યાં તું આમહાન કેછ દોવાડા માગતોહો કા આમા પાસ્કા ખુશ્યે હાટી ખાઅના તિયાર કોઅજે કા આપા ખાજે?” ");
INSERT INTO gbl_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ચ્યે આખ્યાં શેહેરામાય ફલાણા પાય જાયા એને ચ્યાલ આખી દેજા કા ગુરુ આખહે કા, મા દિહી પાહાય યેય પોઅચ્યોહો, તો ગોઆમાય આંય મા શિષ્યહાઆરે પાસ્કા સણા જેવાણ કોઅહી. ");
INSERT INTO gbl_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ઈસુવે આખ્યાં તેહે શિષ્યહાય કોઅયા એને તાં ચ્યાહાય પાસ્કા સણા જેવાણા તિયારી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","રુવાળી પોડી, તોવે તો બાર શિષ્યહાઆરે ખાઅના ખાં બોઠો. ");
INSERT INTO gbl_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","જોવે ચ્યા ખાત તોવે ચ્યાય આખ્યાં કા આંય તુમહાન હાચ્ચી વાત આખતાહાવ તુમહેમાઅનો યોક જાંઆ માન દોઈ દી. ");
INSERT INTO gbl_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","જોવે ચ્યા ઈ વાત વોનાયા, ચ્યાહાન બોજ દુઃખ લાગ્યા, એને ચ્યા પાછા-પાછા સાવાલ પુછા લાગ્યા કા, “કાય તો આંય હેતાઉ કા?” ");
INSERT INTO gbl_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ચ્યે ચ્યાહાન આખ્યાં જ્યાંય મા થાળ્યેમાય આથ ટાક્યોહો તોજ માન દોઅય દી. ");
INSERT INTO gbl_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","આંય, માઅહા પોહો મોઅઇ જાહીં કાહાકા પવિત્રશાસ્ત્રમાય લોખલાં હેય, બાકી ચ્યા માઅહાન બોજ કોઠાણ શિક્ષા ઓરી જો માન દોઅય દાંહાટી મોદાત કોઅહે ચ્યા માઅહાહાટી, જો કાદાં ચ્યાલ જન્મોજ નાંય દેતા તીં હારાં ઓઅતા. ");
INSERT INTO gbl_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","તોવે ચ્યાલ દોઅય દેનારો યહૂદાય આખ્યાં, “ઓ ગુરુ, તો આંય હેતાઉ કા?” ઈસુય ચ્યાલ આખ્યાં “તુયે પોતેજ આખી દેના.” ");
INSERT INTO gbl_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","જોવે ચ્યા ખાત તોવે, ઈસુવે બાખ્યે ટુકડો લેદો, એને બાખ્યેહાટી પોરમેહેરા આભાર માન્યા એને, મુડીન શિષ્યહાન દેની, એને ચ્યે આખ્યાં, “લા એને ખાં, ઈ મા શરીર હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","પાછે ઈસુવે દારાખા રોહા પિયાલો લેદો, એને પોરમેહેરા આભાર માનીન તીં ચ્યા શિષ્યહાન દેના, એને ચ્યા બોદહાય ચ્યામાઅને પિદાં. ");
INSERT INTO gbl_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","એને ઈસુવે ચ્યાહાન આખ્યાં, “ઓ દારાખા રોહો મા લોય હેય, મા લોય ઘોણા લોકહા પાપહા માફ્યે હાટી વોવાડલાં જાહે, ઓ ચ્યા વાયદા સાબિત કોઅરી જો પોરમેહેર પોતે લોકહાઆરે બોનાવી રિઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, ચ્યા પાછે, આંય ચ્યા દિહયા લોગુ પાછે કોવેજ દારાખા રોહો નાંય પિયું, જાંઉ લોગુ આંય પોરમેહેરા રાજ્યામાય નોવો દારાખા રોહો નાંય પીયહીં”. ");
INSERT INTO gbl_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","તોવે ઈસુ એને ચ્યા શિષ્યહાય પાસ્કા ગીતે આખ્યે એને પોરમેહેરા સ્તુતિ કોઅયી, એને યેરૂસાલેમ શેહેરા બાઆ જાતા રિયા એને જૈતુન ડોગા ઉપે ચાલ પોડ્યા જો પાહાય આતો. ");
INSERT INTO gbl_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","તોવે ઈસુવે ચ્યાહાન આખ્યાં, તુમા બોદા માન છોડીન નાહી જાહા, જેહેકોય લોખલાં હેય કા, આંય મેંડવાળ્યાહાલ ઠોકીહી એને, ગેટેં ટોળામાઅને વેરગાઈ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","બાકી મા મોઅલાહામાઅને જીવી ઉઠના પાછે, આંય તુમહે પેલ્લા ગાલીલ ભાગામાય જાહીં, એને તાં મીળહી. ");
INSERT INTO gbl_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","બાકી પિત્તરે ઈસુવાલ આખ્યાં કા, “જેરુ બોદાજ છોડીન નાહી જાય, બાકી આંય તુલ છોડીન નાંય જાંઉ.” ");
INSERT INTO gbl_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ઈસુવે ચ્યાલ આખ્યાં કા આંય તુલ હાચ્ચી વાત આખહુ કા આજે રાતી કુકાડ વાહાય ચ્યા પેલ્લા તું તીનદા એહેકેન આખહે કા આંય ચ્યાલ નાંય વોળખું. ");
INSERT INTO gbl_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","પિત્તરે આખ્યાં, “એને તોઆરે માન મોરાં બી પોડી, તેરુંબી આંય કોવેજ નાંય આખું કા આંય નાંય વોળખું,” એને યેજપરમાણે બોદા શિષ્યહાય એહેંજ આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ચ્યા પાછે ઈસુ ચ્યાહાઆરે ગેતસેમાને નાંવા જાગાવોય યેનો એને ચ્યે શિષ્યહાન આખ્યાં કા તુમા ઈહીં બોહીજા “આંય જાયન પોરમેહેરાલ પ્રાર્થના કોઅહુ.” ");
INSERT INTO gbl_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","એને ચ્યે પિત્તર જબદી પોહો યાકૂબ એને યોહાન ચ્યાઆરે ગીયા એને આજુ વાયજ દુર લેઈને ગીયો, એને પાછે તો બોજ દુઃખી એને નિરાશ ઓઅઇ રીયલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","તોવે ચ્યે શિષ્યહાન આખ્યાં, “મા જીવ બોજ દુઃખી હેય, ઓહડા લાગહે કા મા જીવ નિંગી જાય: તુમા ઈહીં રિયા એને જાગતા રોજા.” ");
INSERT INTO gbl_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","પાછો ઈસુ વાહાયોક દુઉ ગીયો એને મેંડયે પોડયો એને પોતે ચેહેરો દોરત્યેવોય ટેકાડી દેનો એને પ્રાર્થના કોઅરા લાગ્યો, “ઓ પિતા, નોકીજ બોની હોકેત યા દુઃખા પિયાલો માથી દુઉ ઓઅઇ જાય, તેરુંબી જેહેકોય આંય વિચારતાહાવ તેહેકેન નાંય, બાકી જેહેકોય તું વિચારતો તેહેકોયનુજ ઓએ.” ");
INSERT INTO gbl_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","તો પાછો શિષ્યહાપાય યેનો તોવે ચ્યે ચ્યાહાન હુતલા દેખ્યા એને પિત્તરાલ આખ્યાં, “કાય તુમહાન યોક કલાક બી નાંય જાગતા રોવાયાં? ");
INSERT INTO gbl_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","જાગતા એને પ્રાર્થના કોઅતા રા, કા તુમા પરીક્ષામાય નાંય પોડે, તુમહે આત્મા તે હાચ્ચાં કોઅરા તિયારી હેય, બાકી શરીર નોબળાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","આજુ યોકદા પાછા જાયને ચ્યે ઓહડી પ્રાર્થના કોઅયી કા, ઓ મા આબા જોવે વાટકો પિયા વોગાર માયેપાઅને નાંય ઓટી હોકે, તે તું તો મોરજયેકોય ઓઅરા દે. ");
INSERT INTO gbl_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","પાછા યેઇન ઈસુય ચ્યાહાન હુતલા દેખ્યા, કાહાકા ચ્યાહા ડોળા નિંદે કોઇન બાઆય ગીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ચ્યાહાન છોડીન તો પાછો ગીયો, એને તીજ વાત પાછી આખીન, તીજેદા પ્રાર્થના કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","પાછા શિષ્યહાપાય યેયન ચ્યે ચ્યાહાન આખ્યાં, આજુબી તુમા હુતલાજ રા એને આરામ કોઅતાજ રા, ઓલહાંજ આમી, “એઆ આમી મા સમય યેય ગીઅલો હેય માન, માઅહા પોહાલ પાપી લોકહા આથામાય દેય દી. ");
INSERT INTO gbl_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ઉઠા, ચાલા, એઆ, જો માન દોઅવાડી દાંહાટી મોદાત કોઅઇ રિઅલો હેય, તો આમી યેય રિઅલો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","એને તો આજુ બોલહે ઓલાહામાયજ, યહૂદા ઇસ્કારીયોત જો બાર શિષ્યહા માઅને યોક જાંઆ આતો તાં યેનો, ચ્યા હાતે બોજ લોક આતા, યા લોક મુખ્ય યાજક એને યહૂદી આગેવાનાહાથી દોવાડલા આતા, યહૂદા હાતે આતા ચ્યા લોકહાપાંય તારવાયો એને ડેંગારા લેયને યેના. ");
INSERT INTO gbl_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","યહૂદા ઇસ્કારીયોત, જો ચ્યાલ દોઅવાડી દાંહાટી નિશાણી દેનેલ કા, જ્યાલ આંય પ્રેમ કોય ગુળા દાવ તોજ હેય, ચ્યાલ દોઓઈ લેજા. ");
INSERT INTO gbl_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","યહૂદા ઇસ્કારીયોત યેનો, એને તારાતુજ ઈસુવાપાય જાયને આખ્યાં, “ઓ ગુરુ, સલામ” એને ચ્યે ચ્યાલ બોજ ગુળા દેના. ");
INSERT INTO gbl_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ઈસુવે ચ્યાલ આખ્યાં, “ઓ હાંગાત્યા, જીં કામ કોઅરાહાટી તું ઈહીં યેનો, તી કોઅઇ લે” તોવે ચ્યા લોકહાય ઈસુવાપાય યેયન ચ્યાલ દોઅય લેદો. ");
INSERT INTO gbl_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","એને એએ ઈસુવા હાંગાત્યા માઅને યોક શિષ્યે આથ લાંબો કોઇન તારવાય કાડી એને મહાયાજકા ચાકારા ઉપે ચાલાડી એને ચ્યા કાન કાપી ટાક્યો. ");
INSERT INTO gbl_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","તોવે ઈસુવે ચ્યાલ આખ્યાં, તો તારવાય ચ્યા જાગે પાછી થોવી લે, કાહાકા તારવાય ચાલાડનારા હેય, ચ્યા બોદા તારાવાયે કોઇન મોઅઇ જાય. ");
INSERT INTO gbl_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","કાય તું નાંય હોમજે, તો જોવે આંય મા આબાપાય માગુ તોવે તારાત તો હોરગા દૂતા બાર સૈન્યા કોઅતા વોદારે સૈન્યા ટોળો નાંય દોવાડે કા? ");
INSERT INTO gbl_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","બાકી જોવે પવિત્રશાસ્ત્રા વાતો કેહેકેન પુરાં ઓઅઇ, જ્યામાય લોખલાં હેય કા ઈ બોદા યેજપરમાણે તી પુરાં ઓરા જોજે? ");
INSERT INTO gbl_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ઈસુવે ચ્યાહાન આખ્યાં, “કાય તુમા માન ડાખૂ હોમજીન દોઓરાં હાટી તારવાય એને ડેંગારા લેઈને યેનાહા કા? એને આયતે દિને દેવાળામાય તુમહેઆરે રોઇન હિકાડૂ, તેરુ તુમાહાય માન નાંય દોઅયેલ. ");
INSERT INTO gbl_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","બાકી ઈ યાહાટી ઓઅયા કા, ભવિષ્યવક્તાહા લોખલાં હેય તી પુરાં ઓઅઇ જાય.” એને તોવે બોદા શિષ્ય ચ્યાલ છોડીન નાહી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","બાકી ઈસુવાલ દોઇન ચ્યા ચ્યાલ કાયફા નાંવા મહાયાજકાપાય લેય ગીયા, તાં મૂસા નિયમ હિકાડનારા ગુરુ એને આગેવાન યોખઠા ઓઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","પિત્તર દુઉ લોગુ ચ્યા પાહલા-પાહલા મહાયાજકા ગોઆ બાઆપુર લોગુ ગીયો, એને માજા જાયન કાય ઉસબે તી એરા ચાકારા આરે બોહી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","મુખ્ય યાજક એને બોદયે સોબા યેય ઈસુવાલ માઆઇ ટાકાડાંહાટી ઈસુવા વિરુદમાય સાબિતી હોદેત, ");
INSERT INTO gbl_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","બાકી બોજ જુઠા સાક્ષી યેના તેરુ યોકબી નાંય જોડી, સેલ્લે બેન સાક્ષી યેના. ");
INSERT INTO gbl_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","“ચ્યાહાન આખ્યાં કા એલે એહેકેન આખ્યેલ કા પોરમેહેરા દેવાળાલ તોડી પાડહીં એને તીન દિહીહયામાય આંય તી બાંદી હોકીહી.” ");
INSERT INTO gbl_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","તોવે મહાયાજકે બોદહા વોચમાય ઉબા રોઇન ઈસુવાલ પુછ્યાં, “કાહા તું જાવાબ નાંય દેય? યા લોક તો વિરુદમાય કાય સાક્ષી દેતાહા?” ");
INSERT INTO gbl_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","બાકી ઈસુ ઠાવકોજ રિયો, તોવે મહાયાજકાય ચ્યાલ આખ્યાં “આંય તુલ જીવતા પોરમેહેરા નાંવે કોસામ આખતાહાવ, આમહાન જાવાબ દે તું પોરમેહેરા પોહો ખ્રિસ્ત હેતો કા?” ");
INSERT INTO gbl_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ઈસુવે ચ્યાહાન આખ્યાં, “તુયે હાચ્ચાં આખ્યાં, બાકી આંય આખતાહાવ કા આમી પાછે તુમા માઅહા પોહાલ બોજ સામર્થ હાતે પોરમેહેરા જમણી એછે બોઠલો એઅહા એને આકાશા વાદળામાઅરે યેતો એઅહા.” ");
INSERT INTO gbl_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","તોવે મહાયાજક વોનાયોકા ઈસુય કાય આખ્યાં, તોવે મુખ્ય યાજક ચ્યા પોતેજ ફાડકે ફાડી ટાક્યેં એને બોજ ખિજવાય ગીયો એને આખ્યાં કા, “આમી આપહાન બિજા સાક્ષીદારા જરુર નાંય હેય, તુમા ચ્યાલ પોરમેહેરા નિંદા કોઅતા વોનાયાહા.” ");
INSERT INTO gbl_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","આમી તુમહે કાય આખના હેય? ચ્યા બોદા યે વાતે સહમત આતા કા ઈસુ ગુનેગાર હેય એને મોઅરા લાયકે હેય. ");
INSERT INTO gbl_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","તોવે ચ્ચાહાય ચ્યા મુંયા ઉપે થુપ્યાં, એને ચ્યા મુંય ડાકીન ઠોકાં લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","એને એહેકેન આખીન ચ્યા મશ્કરી કોઅયી, “ઓ ખ્રિસ્ત, જોવે તું યોક ભવિષ્યવક્તો હેય તે આમહાન આખ કા તુલ કુંયે ઠોક્યાં?” એને ચાકારાહાય ચ્યાલ દોઇન થાપડાહાકોંય ઠોક્યાં. ");
INSERT INTO gbl_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","પિત્તર બાઆપુર બોઠલો આતો તોવે યોક દાસી ચ્યા પાહાય યેયન આખ્યાં તુંબી ગાલીલ ભાગા માઅહું ઈસુવાઆરે આતો. ");
INSERT INTO gbl_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","બાકી તો બોદહા દેખતા નાંય માના લાગ્યો એને ચ્યે આખ્યાં તું કાય આખતીહી તી આંય નાંય જાઅઉ. ");
INSERT INTO gbl_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","એને જોવે તો દોરવાજા એછે જાં લાગ્યો તોવે યોક બીજી દાસીય ચ્યાલ દેખ્યો એને તાં ઉબા રિઅલાહામાઅને આખ્યાં “એલો નાજરેત ગાવા ઈસુવાઆરે આતો.” ");
INSERT INTO gbl_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","એને તો પાછો નાંય માનતો લાગ્યો એને કોસામ ખાયન આખ્યાં, “આંય ચ્યા માઅહાન બિલકુલ નાંય વોળખું. ");
INSERT INTO gbl_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","થોડી વાઆમાય તાં ઉબા રીઅલા માઅહાય યેયન પિત્તરાલ આખ્યાં નોક્કી તું હોગો ચ્યા માઅનોજ હેતો, તો બોલી હોગી તુલ દેખાડી દેહે.” ");
INSERT INTO gbl_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","તોવે પિત્તર હારાપ દાં લાગ્યો એને કોસામ ખાયન આખતો લાગ્યો કા, “આંય એલા માઅહાન નાંય વોળખું, જ્યા માઅહા બારામાય તુમા વાત કોઅતાહા.” તોવે ચ્યેજ ગેડયે કુકાડ વાહાયો. ");
INSERT INTO gbl_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","તોવે ચ્યેજ ગેડયે કુકાડ બીજાદા વાહાયો એને પિત્તરાલ ઈસુવા આખલી વાત યાદ યેની, “કુકાડ વાહાયી ચ્યા પેલ્લા તું માન તીનદા નાકાર કોઅઇ દેહે કા તું માન નાંય વોળખે” એને તોવે પિત્તર ચ્યા પોતે દુ:ખાલ તાબામાંય નાંય કોઅઇ હોક્યો એને તો હુંઅકા ટાકીન રોડાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","જોવે ઉજાળાં ઓઅઇ ગીયા, તોવે મુખ્ય યાજકેં એને આગેવાન લોકહાય ઈસુવાલ માઆઇ ટાકના નોક્કી કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","એને ચ્યાહાય ચ્યાલ બાંદ્યો એને ચ્યાલ પારખાંહાટી રાજ્યપાલ પિલાતા મેહેલામાય લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","જોવે ચ્યાલ દોઅય દેવાડનારા યહૂદા ઈસ્કારિયોતાલ માલુમ જાયા કા ઈસુ મોઅરાંહાટી ગુનેગાર હેય, તો ચ્યાલ પોસ્તાવો જાયો એને તીહી ચાંદ્યે સીક્કાહાન મુખ્ય યાજકાપાંય એને આગેવાનાહાપાયને ફેરવી લેય યેનો. ");
INSERT INTO gbl_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","એને એહેકેન આખ્યાં, કા “માયેતે ગુના વોગાર માઅહાન માઆહાટી દોઓવાડીન પાપ કોઅયાહાં” ચ્યાહાય આખ્યાં, આમહાન ચ્યા પારવા નાંય હેય, યા તું જાવાબદાર હેય. ");
INSERT INTO gbl_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","તોવે તો ચ્યા સીક્કાહાન દેવાળા બાઆમાય ટાકી દેયન જાતો રિયો, એને પાછે બાઆ જાયને ચ્યે પોતે ફાસી લાવી લેદી. ");
INSERT INTO gbl_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","મુખ્ય યાજકાંય ચ્યા સિક્કા લેઈને આખ્યાં, “યાહાન, ભંડાર માય થોવના નિયમશાસ્ત્ર આપહાન પોરવાનગી નાંય દેય, કાહાકા યા કાદાલ માઆઇ ટાકના કાંબારાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","તોવે ચ્યાહાય વિચાર કોઇન ચ્યા પોયહા યોક કુંબાડા રાન વેચાતાં લેદા, તીં પારદેશીયાહા માહણા હાટી. ");
INSERT INTO gbl_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","યાહાટી આજુ લોગુ ચ્યા રાનાલ “લોયા રાન” આખતેહે. ");
INSERT INTO gbl_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","તોવે યિર્મયા ભવિષ્યવક્તા આખલા તી વચન પુરાં ઓઅઇ ગીયા: ચ્યે ચ્યા તીહી સીક્કાહાન ચ્યે નોક્કી કોઅયેલ તી કિંમાત લેય લેદી, જ્યાહાય ઈસરાયેલ દેશા પોહાહાય એને આજુ બોજ જાઅહાય કિંમાત નોક્કી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","એને જેહેકોય પ્રભુવે માન આગના કોઅયેલ, ચ્યે પરમાણે ચ્યાહાય ચ્યા કુંબાડા રાનાહાટી ચ્યા પોયહા દેય દેના. ");
INSERT INTO gbl_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","જોવે ઈસુ પિલાત રાજા હામ્મે ઉબો આતો, તોવે ચ્યા રાજાય ચ્યાલ એહેકેન પુછ્યાં, કા “કાય તું યહૂદીયાહા રાજા હેતો કા?” ઈસુવે ચ્યાલ આખ્યાં, “તું પોતેજ ઈ આખી રિયહો.” ");
INSERT INTO gbl_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","જોવે મુખ્ય યાજક એને આગેવાન ચ્યાવોય દોષ લાવી રીઅલા આતા, તોવે ચ્યે કાંઇજ જાવાબ નાંય દેનો. ");
INSERT INTO gbl_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","તોવે પિલાતેં ચ્યાલ આખ્યાં, “એલા તો વિરુદમાય ઈ બોદા આખી રીયહા, તી તું નાંય વોનાયે કા?” ");
INSERT INTO gbl_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","બાકી ચ્યે ચ્યાલ યોકબી વાતે જાવાબ નાંય દેનો, યે વાતે વોય પિલાત રાજાલ મોઠી નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","પિલાત રાજા ઓહડી રીત આતી કા ચ્યા પાસ્કા સણામાય લોક જ્યા કૈદ્યાલ માગતે આતેં, ચ્યાલ ચ્યાહાહાટી છોડી દેતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ચ્યે સમયે બારાબ્બાસ નાંવા યોક માઅહું આતા, તો બિજા કૈદ્યાહા આરે જેલેમાય આતો,. ");
INSERT INTO gbl_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","જોવે લોક ટોળો જાયા, તોવે પિલાતેં ચ્યાહાન આખ્યાં, “તુમા કાય આખતાહા તીં આંય તુમહેહાટી કાલ છોડી દાવ? બારાબ્બાસાલ, કા પાછે ઈસુવાલ જો ખ્રિસ્ત આખાયેહે?” ");
INSERT INTO gbl_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","કાહાકા પિલાત રાજાલ ખોબાર આતી કા મુખ્ય યાજકાહાય ઈસુલ ઓદ્રાયેકોય દોઅવાડી દેનેલ. ");
INSERT INTO gbl_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","જોવે તો ન્યાય કોઆહાટી ખુરચ્યેવોય બોઠો, તોવે ઓલહામાય ચ્યા થેઅયે ચ્યાલ આખા દોવાડયા કા, “તું એલા ન્યાયી વોચમાય કાય મા કોઅતો, કાહાકા માયે આજે હોપનામાય એલા બારામાય બોજ દુઃખ વેઠયાહા.” ");
INSERT INTO gbl_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","મુખ્ય યાજક એને આગેવાન લોકહાન એહેકેન હોમજાડ્યા કા બારાબ્બાસાલ માગી લેઅના, એને ઈસુવાલ માઆઇ ટાકાડના. ");
INSERT INTO gbl_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","પિલાત રાજાય ચ્યાહાન પુછ્યાં કા, “યા બેન્યાહા માઅને તુમા કાલ માગતાહા કા ચ્યાલ આંય તુમહેહાટી છોડી દાંઉ?” તોવે ચ્યાહાય આખ્યાં, “બારાબ્બાસાલ.” ");
INSERT INTO gbl_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","પિલાત રાજાય ચ્યાહાન પુછ્યાં, “તોવે જ્યાલ તુમા ખ્રિસ્ત આખતેહે ચ્યા ઈસુવાલ કાય કોઅઉ?” ચ્યા બોદહાય આખ્યાં, “ચ્યાલ હુળીખાંબે ચોડવી દિયા.” ");
INSERT INTO gbl_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","પિલાત રાજાય આખ્યાં, કા “કોહડા હાટી, એલે કાય ગુનો કોઅયોહો?” બાકી ચ્યા પાછા જોરમાય બોંબાલતા લાગ્યા કા, “એલાલ હુળીખાંબે ચોડવી દિયા.” ");
INSERT INTO gbl_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","પિલાતેં એઅયા કા, ચ્યાથી કાયજ નાંય ઓઈ હોક્યા, ઉલટાં વિરુદ વોદતાંજ જાય, તોવે ચ્યે પાઆય લેઈને લોકહા દેખતે આથ દોવ્યા, એને આખ્યાં, “આંય એલા ન્યાયી માઅહાલ માઆઇ ટાકનાથી નિર્દોષ હેતાઉ, તુમાંજ ચ્યા જિમ્મેદાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","બોદા લોકહાય જાવાબ દેનો, “એલા લોય આમહેવોય એને આમહે પાહાહાવોય ઓઅઇ.” ");
INSERT INTO gbl_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","તોવે પિલાતેં લોકહાન રાજી કોઅરાહાટી, બારાબ્બાસાલ ચ્યાહાહાટી છોડી દેનો, એને ઈસુવાલ ચાપકાહા માર દેવાડીન રોમી સીપાડાહાલ હોઅપી દેનો, કા ચ્યે ચ્યાલ હુળીખાંબાવોય ચોડવી દેય. ");
INSERT INTO gbl_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","તોવે પિલાત રાજા સીપાડા ઈસુવાલ મેહેલા આંદાર બાઅવામાય લેય ગીયા તીં ઠિકાણ પ્રીટોરિયુમ નાંવે કોઇન વોળખાયેહે, એને બોદયે ટુકડયેલ હાદી લેય યેના, લગભગ છ:છો સીપાડા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ચ્યાહાય ચ્યા ફાડકે કાડી લેદે એને યોક લાલ ડોગલાં પોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","એને કાટાહા ટોપી વીંઈન ચ્યા ટોલપીવોય થોવી, એને ચ્યા જમણા આથામાય યોક લાકડી દેની પાછે માંડયે પોડીન, ચ્યા મશ્કરી કોઇન આખતા લાગ્યા કા, “ઓ યહૂદીયાહા રાજા, સલામ.” ");
INSERT INTO gbl_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","એને ચ્યા ઉપે થુપ્યાં, એને લાકડી લેઈને ચ્યાલ ઠોકતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","જોવે ચ્યાહાય ચ્યા મશ્કરી પુરી કોઅયા પાછે, ચ્યા ઉપને ચ્યાહાય ડોગલાં કાડી લેદા એને ચ્યાજ ફાડકે ચ્યાલ પોવાડયે, એને પાછે ચ્યાલ હુળીખાંબા ઉપે ચોડવાહાટી શેહેરા બાઆ લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","જોવે ચ્યા શેહેરા બાઆ જાય રીયલા આતા, તે સિમોન નાંવા યોક માટડો ગાવા ભાગામાઅને યેરૂસાલેમ શેહેરામાય યી રિઅલો આતો. સિમોન કુરેની ગાવામાઅનો આતો, એને તો સિકંદર એને રૂફસા આબહો આતો, સીપાડાહાય ચ્યાલ આખ્યાં કા તો હુળીખાંબલીન ચ્યા જાગા હુદુ લેય જાય જાં ચ્યા ઈસુલ હુળીખાંબાવોય ચોડાવનારા આતા. ");
INSERT INTO gbl_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","જોવે ચ્યા ગુલગથા નાંવ્યા (મોતલાબ-ખોપરીયે જાગો) એહેકેન આખાયેહે તાં યેનો, ");
INSERT INTO gbl_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ચ્યાહાય ચ્યાલ માણા બેખાળલો દારાખા રોહો પિયાં દેનો, બાકી ચ્યેય ચ્યાલ વાહાયોક ચાખ્યાં પાછે નાંય પિદાં. ");
INSERT INTO gbl_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","તોવે ચ્યાહાય ચ્યાલ હુળીખાંબાવોય ચોડવી દેનો, એને ચ્યા ફાડકે ચીઠયો ટાકીન વાટી લેદે. ");
INSERT INTO gbl_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","એને તાં બોહીન ચ્યા રાખવાળી કોઆ લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","સીપાડાહાય ઈસુ ટોલપા વાહાયોક ઉચે યોક દોષા પાટી લાવી દેની, ચ્યામાય એહેકેન લિખલાં આતા, “યહૂદીયાહા રાજા ઈસુ હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","તોવે ચ્યાઆરે બેન બાંડ હુળીખાંબે ચોડવી દેના, યોકાલ ચ્ચા જમણે એછે એને બિજાલ ચ્ચા ડાબે એછે. ");
INSERT INTO gbl_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","એને વાટે જાતે માઅહે ટોલપા આલવી-આલવીન એહેકેન આખીન ચ્યા નિંદા કોએત કા, ");
INSERT INTO gbl_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“એરે, દેવાળાલ પાડી ટાકનારા, એને તીન દિહાહામાય ચ્યાલ પાછા બોનાવનારા, તો પોતાનેજ બોચાવ કોઅઇ લે જોવે તું પોરમેહેરા પોહો ઓરીતે, હુળીખાંબા ઉપને ઉતી પોડ.” ");
INSERT INTO gbl_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","યેજપરમાણે મુખ્ય યાજકબી, મૂસા નિયમ હિકાડનારા ગુરુ એને આગેવાનાહાઆરે મશ્કરી કોઅઈન આખે કા, ");
INSERT INTO gbl_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","એલે બીજહાન બોચાવ્યા, બાકી પોતેજ પોતાલ બોચાવી નાંય હોકે. ઓ માઅહું જો ઈસરાયેલ દેશા ખ્રિસ્ત એને રાજા, ઓઅરા માગતો આતો આમી હુળીખાંબાવોયને ઉતી યે, કા આમા એઇ હોકજે એને તોવોય બોરહો કોઅઇ હોકજે કા ઓજ આમે રાજા હેય. ");
INSERT INTO gbl_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","એલે પોરમેહેરા બોરહો રાખ્યોહો, જોવે પોરમેહેર ચ્ચાલ માગહે, તોવે ચ્યાલ આમી બોચાવી લેય, કાહાકા એલોજ આખે કા, “આંય પોરમેહેરા પોહો હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","યેજપરમાણે ચ્યાઆરે જ્યા બાંડ હુળીખાંબાવોય ચોડાવલા આતા ચ્યાહાય બી ચ્યા નિંદા કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","બોપરેહે પાછે બોદા દેશામાય આંદારાં ઓઅઇ ગીયા, એને તીં તીન વાગ્યા લોગુ રિયા. ");
INSERT INTO gbl_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","તીન વાગે લગભગ, ઈસુવે મોઠેરે બોંબલીન આખ્યાં કા, “એલોઈ, એલોઈ, લમા શબકથની?” એટલે, “ઓ મા પોરમેહેર, ઓ મા પોરમેહેર, તુયે માન કાહા છોડી દેનોહો?” ");
INSERT INTO gbl_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","યા લોકહામાંઅરે કોલહાક લોક જ્યા તાં ઉબા આતા, ચ્યા વોનાયા બાકી ચ્યા જુઠી રીતે હોમજ્યા એને યોકાબીજાલ આખ્યાં, “વોનાયા, તો ભવિષ્યવક્તા એલીયાલ હોરગામાઅને પોતે મોદાત કોઅરાહાટી હાદી રિઅલો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","એને ચ્યા માઅહા માઅને યોક માઅહું દાંહાદી ગીયા, યોક પોંચ લેદો, એને ચ્યાલ ખાટામાય બુડવી દેના, એને વાતડયે લાકડયેઉપે બાંદિન ચ્યાલ ચુહૂરાં દેના. ");
INSERT INTO gbl_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","બાકી બીજહાંય આખ્યાં, કા “રુકાય જો, આપા એઅતા, એલીયો ચ્યાલ બોચાવાં હાટી યેહે કા નાંય.” ");
INSERT INTO gbl_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","તોવે ઈસુ મોઠેરે બોંબલ્યો એને મોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","એને તો મોઠો પોડદો જો દેવાળામાય લોટકાડલો આતો, જો બોદહાલ પોરમેહેરા હજર્યેમાય જાંહાટી રોકતો આતો, ઉપેરે તે નિચે લોગુ બેન ભાગ ઓઅઇન ફાટી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","માહાણેં ઉગડી ગીયે, એને મોઓઈ ગીઅલા પવિત્ર લોકહા બોજ કુડયો પાછયો જીવત્યો ઉઠયો. ");
INSERT INTO gbl_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","ઈસુ મોઅલા માઅને પાછા જીવી ઉઠના પાછે ચ્યા માહાણા માઅને નિંગીન પવિત્ર નગરામાય ગીયા, એને બોજ લોકહાન દેખાયાં. ");
INSERT INTO gbl_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","બાકી જોમાદાર એને ચ્યાઆરે જ્યેં ઈસુવા રાખવાળી કોએત, ચ્યે દોરત્યેવોય એને જીં બોન્યાં તીં એઇન આખતે લાગ્યેં, “હાચ્ચાં હેય કા ઓ માઅહું પોરમેહેરા પોહો આતો.” ");
INSERT INTO gbl_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","બોજ થેએયો, જ્યો ઈસુવા ચાકરી કોઅરાહાટી ગાલીલ ભાગામાઅને ચ્યા પાહલા ચાલત્યો યેનલ્યો, ચ્યો દુઉ રોયન ઈ એઅયા કોએત. ");
INSERT INTO gbl_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","યા ટોળામાય મરિયાબી આતી જીં મગદલા નાંવા શેહેરામાઅને આતી, એને યાકૂબ એને યોસેસા આયહો મરિયમ એને જબદયા પાહાહા આયહો આતી. ");
INSERT INTO gbl_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","દિહી બુડી ગીયો પાછે યોસેફ નાંવ્યો અરીમતિયા શેહેરા યોક માલદાર માઅહું યેના, તો હોગો ઈસુવા શિષ્ય આતો, યેનો. ");
INSERT INTO gbl_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","તો પિલાતાપાંય ગીયો, એને ઈસુવા કુડી માગી એને તી પિલાતેં દેય દેઅના આગના કોઅયી, ");
INSERT INTO gbl_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","એને યોસેફ કુડી લેઈને ચ્યેલ હારાં ફાડકામાય ચોંડાળી લેદા. ");
INSERT INTO gbl_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","એને ખોલકડામાય ખોદલા ચ્યા પોતા નાંવા યોક નોવા માહાણા આતા ચ્યામાય ડાટી દેના, એને માહાણા મુંયાવોય ચ્યે યોક મોઠો દોગાડ કોથલાડીન જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","એને મરિયાબી આતી જીં મગદલા નાંવા શેહેરામાઅને આતી એને તી બીજી મરિયમ તાં કોબારે હુમ્મે બોહી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","બીજે દિહી, તો જો તિયારી દિહયે, મુખ્ય યાજક એને પોરૂષી લોક પિલાત રાજાલ મિળાં ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","ચ્યાહાય આખ્યાં “ઓ માલિક, આમહાન યાદ હેય, કા એલો ઠોગ આજુ જીવતો આતો તોવેજ ચ્યે એહેકેન આખ્યેલ કા આંય મા મોઅના તીન દિહા પાછે, પાછો જીવી ઉઠહી. ");
INSERT INTO gbl_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ચ્યાહાટી તીજા દિહી લોગુ તું માહાણા રાખવાળી કોઅના આગના કોઓ, કાહાકા એહેકેન કા ચ્યા શિષ્ય યેઇન મુરદાં લેઈને નાહી પોડે, એને લોકહાન આખા લાગી કા, ‘તો તે મોઅલા માઅને જીવી ઉઠયોહો,’ નેતે પેલ્લા દોંગા કોઅતો આમી વોદારી દોંગો ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","પિલાત રાજાય ચ્યાહાન એહેકેન આખ્યાં, “તુમહેપાય તે રાખવાળ્યા હેય તે જાયા, તુમહાન ફાવે તેહે રાખવાળી કોઅયા.” ");
INSERT INTO gbl_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","તોવે ચ્યા રાખવાળ્યાહાન આરે લેઈને કોબારેપાય લી ગીયા, એને કોબારેવોય થોવલા દોગાડાવોય નિશાણી લાવી દેની કા દોગડાલ કાદો નાંય ઓટાડે, પાછે ચ્યા સિપાડાહાન રાખવાળી કોઅરા છોડી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","વોખાતેહે જોવે આરામા દિહી પુરો ઓઅઇ ગીયો તોવે આઠવાડ્યા પેલ્લે દિહી ઉજાળાં ઓઅતાંજ, મરિયમ જીં મગદલા નાંવા શેહેરામાઅને આતી, એને બીજી મરિયમ માહણાલ એરા યેન્યો. ");
INSERT INTO gbl_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","તોવે યોક મોઠો દોરતીકંપ ઓઅયો, કાહાકા પ્રભુ યોક દૂત હોરગામાઅને ઉત્યો, એને પાહી યેઇન દોગડાલ હોરકાવી દેનો, એને તો ચ્યાવોય બોઠો. ");
INSERT INTO gbl_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ચ્યા રુપ વીજે હારખા એને ચ્યા ફાડકે બરફા હારકે ઉજળેં આતેં. ");
INSERT INTO gbl_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","એને ચ્યા ધાકા કોઅઇ રાખવાળ્યા કાપી ઉઠયા, એને મોઅલા માઅહા રોકા ઓઅઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","હોરગા દૂતહાય બાઈહેલ આખ્યાં, “બીયહા મા, આંય જાંઅહું કા તુમા ઈસુવાલ જો હુળીખાંબાવોય ચોડાવામાય યેનેલ ચ્યાલ હોદત્યોહો. ");
INSERT INTO gbl_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","તો ઈહીં નાંય હેય, બાકી પોતાના વચના ઇસાબે પાછો જીવી ઉઠયોહો, એને તો જાગો એઆ, જાં પ્રભુલ થોવ્યેલ. ");
INSERT INTO gbl_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","એને જલદી જાયન ચ્યા શિષ્યહાન આખા કા તો મોઅલા માઅને પાછો જીવી ઉઠયોહો, એને તો તુમહે પેલ્લા ગાલીલ ભાગામાય જાહે, તાં તુમા ચ્યાલ એઅહા, એઆ, માયે તુમહાન આખી દેનહા.” ");
INSERT INTO gbl_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ચ્યો બીઈન મોઠા આનંદા હાતે કોબારથી જલદીથી જાયને ચ્યા શિષ્યહાન ખોબાર દાંહાટી દાંહાદી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","તોવે, ઈસુ ચ્યેહેન મિળ્યો એને આખ્યાં, “સુખી રા” એને ચ્યેહેય ચ્યા પાહી જાયને એને ચ્યા પાગ દોઇન ચ્યા પાગે પોડયો. ");
INSERT INTO gbl_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","તોવે ઈસુવે ચ્યેહેન આખ્યાં, “મા બીયહા, મા શિષ્યહાન જાયન આખા કા ગાલીલ ભાગામાય જાય તાં માન દેખી.” ");
INSERT INTO gbl_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ચ્યો શિષ્યહાન ખોબાર કોઅરાહાટી જાઈજ રિઅલ્યો આત્યો, કા જ્યા સીપાડા કોબારે ઈહીં રાખવાળી કોએત ચ્યાહામાઅને વોછાહાય શેહેરમાય યેઇન બોદ્યો વાતો મુખ્ય યાજકાહાલ આખ્યો. ");
INSERT INTO gbl_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","મુખ્ય યાજકાહાય આગેવાનાહાઆરે યોકઠા ઓઇન યુક્તિ કોઅયી એને રાખવાળ્યાહાન બોજ પોયહા દેયને આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“લોકહાન એહેકેન આખજા કા ઈસુ મોઅલા માઅને જીવતો નાંય જાયહો, બાકી રાતી જોવે આમા હૂવી ગીયલા, તોવે ચ્યા શિષ્ય યેયન ચ્યા શરીર ચોરી લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","એને તુમા હૂવી ગીયલા આતા, એહેકેન રાજ્યપાલાલ માલુમ ઓઅઇ જાય, તોવે આમા ચ્યાલ હાંબાળી લાહુ, આમા તુમહાલ વાચાડી લાહુ.” ");
INSERT INTO gbl_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","એને ચ્યાહાય પોયહા લેયને જેહેકોય હિકાડવામાય યેનેલ, તેહેંજ કોઅયેલ, એને ઈ વાત આજેલોગુ યહૂદી લોક એહેકેન માનતાહા કા ઈસુ મોઅલા માઅને જીવતો નાંય જાયલો હેય. ");
INSERT INTO gbl_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ઓગ્યાર શિષ્ય ગાલીલ ભાગામાય ચ્યા ડોગાવોય ગીયા, જાં જાંહાટી ઈસુ ચ્યાહાન આખલા. ");
INSERT INTO gbl_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ચ્યાહાય ચ્યા દર્શન કોઇન ચ્યાલ ભક્તિ કોઅયી, બાકી કાદા કાદાલ શંકા ઓઅયી કા તો હાચ્ચોજ જીવતો ઓઅઇ ગીયહો. ");
INSERT INTO gbl_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ઈસુય ચ્યાહા પાહી યેયન આખ્યાં, “હોરગા એને દોરતી બોદો ઓદિકાર માન દેવામાય યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","યાહાટી તુમા જાં, બોદી જાત્યે લોકહાન શિષ્ય બોનાડા, એને પિતા, એને પુત્ર, એને પવિત્ર આત્મા નાવાકોય ચ્યાહાન બાપતિસ્મા દા, ");
INSERT INTO gbl_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","એને ચ્યાહાન બોદ્યો વાતો જ્યો માયે તુમાહાલ આગના દેનહી, ચ્યો માનના હીકાડા: એને યાદ રાખા, આંય દુનિયા છેલ્લે લોગુ તુમહેઆરે હેય.");
INSERT INTO gbl_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","પોરમેહેરા પોહો ઈસુ ખ્રિસ્તા બારામાય હારી ખોબાર ઇહિને યા પરમાણે ચાલુ ઓઅહે. ");
INSERT INTO gbl_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","જેહેકોય બોજ સોમાયા પેલ્લા માલાખી ભવિષ્યવક્તાય લોખલ્યે ચોપડયેમાય, “પોરમેહેરાય ચ્યા પોહો, ખ્રિસ્તાલ આખ્યાં ‘એએ, આંય તો આગલા મા સંદેશ લેય યેનારાલ દોવાડુહુ, તો તોહાટી વાટ તિયાર કોઅરી.’ ");
INSERT INTO gbl_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","એહેકેનુજ યશાયા ભવિષ્યવક્તાયબી લોખ્યાહાં ‘ઉજાડ જાગામાય યોહાન બોંબલીન આખહે કા પ્રભુ યેયના વાટ તિયાર કોઆ, ચ્યો વાટયો હિદ્યો કોઆ જયેહવોયને તો યેનારો હેય.’” ");
INSERT INTO gbl_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","જ્યા બારામાય ભવિષ્યવક્તાહાયબી લોખલાં હેય, ઓ યોહાન બાપતિસ્મા દેનારો આતો, ને તો ઉજાડ જાગામાય રોતો આતો, ચ્યાય ચ્યાપાય યેનારા લોકહાન ઓ પ્રચાર કોઅતો આતો, “પાપ કોઅના છોડી દા એને બાપતિસ્મા લા, કા પોરમેહેર તુમહે પાપહાલ માફ કોઅઇ દી.” ");
INSERT INTO gbl_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","યહૂદીયા વિસ્તારામાઅને, એને યેરૂસાલેમ શેહેરામાઅને બો બોદા લોક નિંગીન ઉજાડ જાગામાય બાપતિસ્મા દેનારા યોહાના સંદેશ વોનાયા ગીયા. જેહેકોય ચ્યાહાય પાપહાલ માની લેદા તોવે યોહાને લોકહાન યારદેન નોયેમાય બાપતિસ્મા દેના. ");
INSERT INTO gbl_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","યોહાન ઉટડા બુરા બોનાડલે ફાડકે પોવે એને કંબરા આરે ચામડા પોટો બાંદે એને ટોડે એને રાનીમોદ ખાતો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","જોવે યોહાન પ્રચાર કોઅરા લાગ્યો, ચ્યાય લોકહાન આખ્યાં, “મા પાછે જો યેનારો હેય, તો મા કોઅતો મહાન ગોત્યેવાળો હેય, આંય તે ચ્યા ચાકાર બોનીન ચ્યા ખાઅડા હુતળી છોડાબી લાયક્યે નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","માયેતે તુમહાન પાઅયા કોઇન બાપતિસ્મા દેનહા બાકી તો તુમહાન પવિત્ર આત્મા કોઅઇ બાપતિસ્મા દેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ચ્યા દિહીહયામાય ઈસુ ગાલીલ ભાગા નાજરેત ગાવામાઅને યેઇન, યારદેન નોયેમાય યોહાનથી બાપતિસ્મા લેદા. ");
INSERT INTO gbl_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","જોવે તો પાંઅયામાંઅને બાઆ નિંગ્યો, ચ્યેજ ગેડયે ચ્યે આકાશ ઉગડાં દેખ્યા એને પવિત્ર આત્માલ કબુતરા હારખા ચ્યાવોય ઉતતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","હોરગામાઅને પોરમેહેરાય ઈસુલ આખ્યાં કા, “તું મા પ્રિય પોહો હેતો, તોથી આંય ખુશ હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","તોવે તારાત પવિત્ર આત્માય ચ્યાલ ઉજાડ જાગામાય દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ચાળહી દિહીહુદુ તો ઉજાડ જાગામાય આતો, એને સૈતાન ચ્યા પરીક્ષા કોઅહે, તાં જંગલી જોનાવરેબી આતેં, એને હોરગા દૂત ચ્યા ચાકરી કોએત. ");
INSERT INTO gbl_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","બોજ સોમાયા પાછે જોવે હેરોદ રાજાય યોહાનાલ દોઇન જેલેમાય ટાકી દેનો, પાછે ઈસુ ગાલીલ ભાગામાય યેઇન, એને ચ્યે પોરમેહેરા રાજ્યા હારી ખોબાર જાહેર કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ચ્યાય આખ્યાં કા, “પોરમેહેરા રાજ્યા નોક્કી કોઅલો સમય યેય ગીયોહો, એને પોરમેહેરા રાજ્ય પાહી યેય ગીયહા, પાપ કોઅના છોડી દા એને હારી ખોબારેવોય બોરહો કોઆ.” ");
INSERT INTO gbl_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","યોક દિહી ઈસુ ગાલીલ દોરિયા મેરે-મેરે ચાલતો આતો, તોવે ચ્યેય સિમોન એને ચ્યા બાહા આંદ્રિયાસાલ દોરિયામાય જાળ ટાકતા દેખ્યાં, કાહાકા ચ્યા માછડા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “યા તુમા મા શિષ્ય બોના, આમી લોગુ તુમા માછે માઅતા આતા બાકી આમી આંય તુમહાન હિકાડીહી કા લોકહાન કેહેકેન મા શિષ્ય બોનાડના હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","એને તારાતુજ ચ્યાહાય માછે દોઓના છોડીન ઈસુવા શિષ્ય બોની ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ઈસુ એને ચ્યા બેન શિષ્ય દોરિયા મેરે વાહાયોક આગલા ગીયા, ઈસુવે જબદયા પોહા યાકૂબ એને યોહાનાલ દેખ્યાં, ચ્યાબી ઉડીમાય બોહીન જાળ હાંદતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ઈસુવે ચ્યાહાન તારાત આખ્યાં, “યા તુમા મા શિષ્ય બોના” ચ્યાય ચ્યા આબહો જબદયાલ મજુરીયાહાઆરે ઉડીમાય છોડીન ચ્યા ઈસુવા શિષ્ય બોન્યા. ");
INSERT INTO gbl_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","પાછે ઈસુ એને ચ્યા શિષ્ય કાપરનાહુમ ગાવામાય ગીયા, એને જોવે પોરમેહેરા આરામા દિહી યેનો તોવે ઈસુ સોબાયે ઠિકાણે જાયને હિકાડતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ચ્યા હિકાડના બારામાય લોકહાન બોજ નોવાય લાગી, કાહાકા તો મૂસા નિયમ હિકાડનારા ગુરુહુ હારકો નાંય, બાકી પુરાં ઓદિકારવાળા હારકો હિકાડે. ");
INSERT INTO gbl_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","જોવે ઈસુ હિકાડતો આતો ચ્યેજ વેળાયે, ચ્યાહા સોબાયે ઠિકાણે યોક માઅહું આતા, ચ્યાલ બુત લાગલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ચ્યે બોજ જોરથી બોંબલીન આખ્યાં, “ઓ નાજરેત ગાવા ઈસુ, તુલ આમેપાયને કાય જોજે? કાય તું આમહે નાશ કોઅરાહાટી યેનોહો? આંય તુલ વોળખુહુ, તું તે પોરમેહેરા પવિત્ર માઅહું હેતો. ");
INSERT INTO gbl_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","તોવે ઈસુવે ચ્યા બુતાલ દોમકાડયો એને ચ્યાલ આખ્યાં, ઠાવકોજ રો, એને એલામાઅને બાઆ નિંગ.” ");
INSERT INTO gbl_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","તોવે બુત ચ્યાલ પાડી ટાકીન, મોઠે બોંબાલતો નિંગી નાઠો. ");
INSERT INTO gbl_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","યાવોય બોદહાન બોજ નોવાય લાગી, એને ચ્યા યોકબીજાહાન આખતા લાગ્યા, “ઈ કાય વાત હેય? તો પુરાં ઓદિકાર કોઇન હિકાડેહે, એને બુતાલબી દોમકાડેહે, એને ચ્યા ચ્યાલ માનતાહા” ");
INSERT INTO gbl_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","એને લોકહાય ચ્યા બારામાય બિજા લોકહાન આખ્યાં. એહેકેન ઈસુવા બારામાય બોદા ગાલીલ ભાગા આજુબાજુ શેહેરામાય લોકહાન ખોબાર પોડી ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","જોવે ઈસુ એને ચ્યા શિષ્ય ચ્યાહાય સોબાયે ઠિકાણ છોડયા તોવે સિમોન એને ચ્યા બાહા આંદ્રિયાસા ગોઓ ગીયા એને ચ્યાહાઆરે યાકૂબ એને ચ્યા બાહા યોહાનબી ચ્યાહાઆરે ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ચ્યે સમયે સિમોના હાહુ બોજ જોરાવલી આતી, ચ્યા લીદે તી હુતલી આતી જોવે ઈસુ તાં ગીયો તોવે ચ્યાહાય તારાતુજ ઈસુલ ચ્યે બારામાય આખ્યાં કા સિમોના હાહુ જોરાવલી હેય. ");
INSERT INTO gbl_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","તોવે ઈસુવે ચ્યેપાય જાયને, ચ્યે આથ દોઇન ચ્યેલ ઉઠાડયા, ચ્યેમાઅને જોરાં તારાતુજ ઉતી ગીયા, એને તી ઈસુ એને ચ્યા શિષ્યહા ગાવાર ચાકરી કોઅતી લાગી. ");
INSERT INTO gbl_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","દિહી બુડયા પાછે, રુવાળા પોડી ગીયા તોવે માઅહે ઈસુવાપાય બોજ જાત-જાત્યા દુખ્યાહાન એને બુત લાગલાહાન લેઈને યેને. ");
INSERT INTO gbl_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","એને બોજ માઅહે બાઆપુર ટોળો ઓઅલે. ");
INSERT INTO gbl_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","તોવે ઈસુય બોજ જાત-જાત્યા દુખ્યાહાન હારાં કોઅયા એને બોજ બુતાહાન માઅહા માઅને તાંગાડી કાડયા બુતાહાન ચ્યાય બોલા નાંય દેના કાહાકા ચ્યા ઈસુવાલ વોળખેત કા ઓ ખ્રિસ્ત હેય. ");
INSERT INTO gbl_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","હાકાળેહે આજુ આંદારાંજ આતા તોવે ઈસુ ઉઠયો એને યોક એકાંત જાગામાય ગીયો એને પ્રાર્થના કોઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","તોવે સિમોન એને ચ્યા હાંગાત્યાહાય દેખ્યાકા ઈસુ નાંય હેય ચ્યાહાટી ચ્યા ચ્યાલ હોદા ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","જોવે તો મિળ્યો, તોવે ચ્યાલ આખ્યાં, “બોજ લોક તુલ હોદી રીયહા.” ");
INSERT INTO gbl_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “આપા ઓમથે જાતા આહેપાહેના ગાવાહામાય, કાહાકા આંય ચ્યા લોકહાનબી પ્રચાર કોઉ, કાહાકા આંય યાજહાટી યેનોહો.” ");
INSERT INTO gbl_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","એને ઈસુ, બોદા ગાલીલ ભાગામાય સોબાયે ઠિકાણે જાયને પ્રચાર કોઅતો, એને બુતાલ માઅહા માઅને તાંગાડી કાડતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","યોક કોડવાળા માઅહું ઈસુવાપાય યેના એને માંડયે પોડીન ચ્યે ચ્યાલ માગણી કોઅયી, “આંય જાંઅતાહાંવ કા તું તો મોરજયેકોય તું માન ચોખ્ખો કોઅઇ હોકતોહો.” ");
INSERT INTO gbl_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","તોવે ઈસુવાલ દયા યેની એને આથ લાંબો કોઇન ચ્યાલ લાવ્યો એને આખ્યાં, “મા ઇચ્છા હેય તું ચોખ્ખો ઓઅઇ જો, ચોખ્ખો ઓઅઇ જો.” ");
INSERT INTO gbl_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","તારાતુજ ચ્યા કોડ હારાં ઓઅઇ ગીયા એને તો ચોખ્ખો ઓઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","તોવે ઈસુવે ચ્યા માઅહાન કડાક ચેતાવણી દેયન દોવાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","એને ઈસુય ચ્યાલ આખ્યાં, “એએ તો કાદાલ એહેકેન આખના નાંય, કા માયે તુલ હારો કોઅયો બાકી જો એને યાજકાલ દેખાડ કા આમી તું ચોખ્ખો ઓઅઇ ગીયહો તી બેટ આઈન દે, જીં મૂસાય આગના કોઇન આખહી કા, ચ્યા લોકહા સાબિત્યે હાટી રોય.” ");
INSERT INTO gbl_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","બાકી તો જાયન ઈ વાત આખા એને ફેલાવાં લાગ્યો, કા ઈસુવે માન હારો કોઅયો ઓલા હુદુ કા ઈસુ કોઅહાબી ગાવામાય ખુલી રીતે નાંય જાય હોક્યો, બાકી બારેજ એકાંત જાગામાય રિયો, તેરુંબી ચોમખીને માઅહે ચ્યાપાય યેતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","વાયજ દિહાહા પાછે ઈસુ પાછો ફિરીન કાપરનાહુમ ગાવામાય યેનો એને તાઅને લોકહાન ઓહડી ખોબાર જાયી, કા ઈસુ પાછો ફિરીન ગાવામાય યેનલો હેય. ");
INSERT INTO gbl_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","તોવે બોજ લોક ટોળો જાયા એને યા લીદે ઓલે બોદે કા તી ગુઉ લોકહાકોય બોરાય ગીયા, ઓલે લોગુ કા બાઆપુર ને જાગો બી લોકહાકોય બોરાય ગીઅલો આતો. ઈસુ ચ્યા લોકહાન પોરમેહેરા હારી ખોબાર આખતો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","એને ઓલહામાય લોક યોક લખવાવાળા માઅહાન ચાર માઅહાકોય ઉચકીન ઈસુવાપાય લેય યેના. ");
INSERT INTO gbl_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","બાકી ગીરદ્યે લેદે ઈસુવાપાય નાંય લેય જાય હોક્યા, ચ્યાહાટી ગાઆ ઉચે ચોડીન, ચ્યાહાય સિવલાં ગુઉ ખોળી ટાક્યા, એને લખવાવાળા માઅહાન ખાટલાહાતે જ્યાવોય તો હુતલો આતો ચ્યાલ બોગારામાઅને ઈસુ આતો તાં ઉતાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ઈસુવે, જાંઅયા કા ચ્યા માયેવોય બોરહો થોવતાહા, લખવાવાળા માઅહાન આખ્યાં, “ઓ બાહા, તો પાપહાલ આંય માફ કોઅતાહાંવ.” ");
INSERT INTO gbl_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","તોવે ચ્યા ગાઆમાય કોલાહાક મૂસા નિયમ હિકાડનારા ગુરુ બોઠલા આતા, જીં કાય ઈસુવે આખ્યાં ચ્યા બારામાય ચ્યા મોનામાય વિચાર કોઅતા લાગ્યા, ");
INSERT INTO gbl_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ઈ માઅહું એહેકેન કાહા આખહે? એલો તે પોરમેહેરા નિંદા કોઅહે, કાય એલાલ નાંય ખોબાર હેય કા પોરમેહેરુજ પાપ માફ કોઅઇ હોકહે?” ");
INSERT INTO gbl_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","તારાતુજ ઈસુ જાંઆઈ ગીયો, કા ચ્યા કાય વિચાર કોઅઇ રીયહા, તોવે ઈસુવે ચ્યાહાન આખ્યાં, “તુમહે મોનામાય તુમા કાહા એહેકેન વિચાર કોઅતાહા? ");
INSERT INTO gbl_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","કાય આખના હેલ્લા હેય? તો પાપ માફ ઓઅઇ ગીયા ઈ લખવાવાળાલ આખના હેલ્લા હેય, કા ઉઠ તો ખાટલા ઉચકીન ચાલા લાગ, ઈ આખના હેલ્લા? ");
INSERT INTO gbl_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","બાકી તુમહાન ખોબાર પોડા જોજે કા માન એટલે માઅહા પોહાલ દોરત્યેવોય લોકહા પાપ માફ કોઅના ઓદિકાર દેનલો હેય.” ચ્યાહાટી ઈસુ લખવાવાળા માઅહાન આખહે. ");
INSERT INTO gbl_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“તુલ આંય આખતાહાવ, ઉઠ, તો ખાટલા લેઈને ગોઓ જો.” ");
INSERT INTO gbl_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","તો ઉઠયો, એને તારાત ખાટલા ઉચકીન બોદહા દેખતા ચ્યે ગોઅને જાતો રિયો. બોદહાન બોજ નોવાય લાગી, એને ચ્યા પોરમેહેરા મહિમા આખતા લાગ્યા, “ઓહડા તે આપહાય કાદે દિહે દેખ્યાંજ નાંય.” ");
INSERT INTO gbl_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","આજુ યોકદા ઈસુ ગાલીલા દોરિયા મેરે ગીયો, એને બોજ માઅહે ચ્યાપાય યેને, એને ઈસુ ચ્યા લોકહાન પોરમેહેરા વચન હિકાડાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","આજુ વાયજ આગલા જાતા ઈસુવે આલફેયા પોહો લેવી જો જકાતદાર આતો ચ્યાલ કર લેઅના નાકાવોય બોઠલો દેખ્યો એને ચ્યાય લેવીયાલ આખ્યાં, “મા શિષ્ય બોન.” એને તો કામ છોડીન ઈસુવા શિષ્ય બોની ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","એને બોજ સોમાયા પાછે, જોવે ઈસુ એને ચ્યા શિષ્ય લેવીયા ગોઅમે રાતી ખાઅના ખાં બોઠલા આતા, તોવે બોજ કર લેનારા એને પાપી આખાતાહા, ચ્યા શિષ્યહાઆરે ખાં બોઠા, કાહાકા ઓહડે બોજ માઅહે આતેં ચ્યે ચ્યા ઈસુઆરે રોત. ");
INSERT INTO gbl_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","એને મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોકહાન ખોબાર જાયી કા તો જ્યા પાપી આખાતાહા ઓહડા લોકહાઆરે ખાહે, તોવે ચ્યાહાય ઈસુ શિષ્યહાન આખ્યાં, “તો તે કાહા જકાતદારાહા આરે એને પાપી લોકહાઆરે ખાહે?” ");
INSERT INTO gbl_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ઈસુ ઈ વાત વોનાયો, એને મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોકહાન આખ્યાં, “જ્યેં હારેં હેતેં ચ્યાહાન ડાકટારા ગોરાજ નાંય રોય, બાકી જ્યેં દુખ્યેં હેતેં ચ્યાહાન ગોરાજ હેય: બાકી આંય જ્યા પોતે ન્યાયી માનતાહા ચ્યાહાહાટી નાંય, બાકી પાપ્યાહાન બોચાવાં યેનોહો.” ");
INSERT INTO gbl_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","યોહાના શિષ્ય એને પોરૂષી લોક ઉપહા કોએત, એને યોક દિહી વાયજ લોક યેઇન ઈસુવાલ આખે; “યોહાના શિષ્ય એને પોરૂષી લોકહા શિષ્ય ઉપહા કોઅતાહા, બાકી તો શિષ્ય નાંય કા?” ");
INSERT INTO gbl_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","તોવે ઈસુવે જાવાબ દેનો, “મા શિષ્ય એને આંય વોવડા એને ચ્યા દોસ્તારા હારકા હેતા, જાવ લોગુ ચ્યા વોરાડામાય હેતા તાંવ લોગુ કાય વોવડા દોસ્તાર ઉપહા કોઅઇ હોકતાહા? નાંય ચ્યા ઉપહા નાંય કોઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","બાકી ચ્યાહા પાયને વોવડો લેવાય જાય ઓહડા દિહી યી, તોદહી ચ્યા ઉપહા કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","માઅહે જુના ફાડકા આરે નોવા ફાડકા ઠિગળા નાંય હિવેત, કાહાકા દોવ્યા પાછે નોવા ફાડકા ચંડળાય જાય એને જુના આજુ ચીઈ ટાકહે, એહેકેન તી ફાડકા કામ નાંય લાગે. એહેકેન મા શિક્ષા જુની રીતીરીવાજાહા આરે જોડે, તે મા શિક્ષા યા ફાડકા હારકી કાયજ કામ નાંય લાગે. ");
INSERT INTO gbl_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","યેજ રીતે માઅહે નોવો દારાખા રોહો જુના ચાંબડા ઠેલ્યેમાય નાંય બોએત, એહેકોયન દારાખા રોહો થોવે તે તી ઠેલી ફૂલીન ફાટી જાય, એને દારાખા રોહો વેરાય જાય, યાહાટી નોવો દારાખા રોહો નોવ્યે ઠેલ્યેમાયજ બોઅતેહેં.” ");
INSERT INTO gbl_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","પોરમેહેરા આરામા દિહી, ઈસુ એને ચ્યા શિષ્ય રાનામાઅને જાતા આતા, તોવે ઈસુવા શિષ્ય કોઅહે પેંદી ખાત. ");
INSERT INTO gbl_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","તોવે પોરૂષી લોક ઈસુવાલ આખે, “એએ, તો શિષ્ય જીં કામ આરામા દિહી કોઅઇ રીઅલા હેય, તી આમે નિયમા વિરુદ હેય તુયે ચ્યાહાન એહેકેન નાંય કોઅરાહાટી આખા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ઈસુવે ચ્યાહાન આખ્યાં, “કાય, તુમાહાય નાંય વાચ્યાહાં કા દાઉદ રાજા એને ચ્યા હાંગાતિયાહાન બુખ લાગી, એને જરુર પોડી, તોવે કાય કોઅયેલ? ");
INSERT INTO gbl_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","જોવે આબીયાતાર મહાયાજક આતો, તોવે દાઉદ રાજા પોરમેહેરા માંડવામાય જાયન બેટ ચોડાવલ્યો બાખ્યો, જ્યો યોખલા યાજકથી ખાવાય, ચ્યો ચ્યે ખાદ્યો, એને હાંગાતિયાહાન બી દેન્યો.” ");
INSERT INTO gbl_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","એને ઈસુવે ચ્યાહાન આખ્યાં, “પોરમેહેરાય માઅહાન પોરમેહેરા આરામા દિહયા હાટી નાંય બોનાડ્યા, બાકી પોરમેહેરાય માઅહાહાટી પોરમેહેરા આરામા દિહી બોનાડલો હેય. ");
INSERT INTO gbl_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ચ્યાહાટી આંય, માઅહા પોહાલ પોરમેહેરા આરામા દિહાવોય બી ઓદિકાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","પાછો પોરમેહેરા પવિત્ર દિહી ઈસુ સોબાયે ઠિકાણે ગીયો, તાં યોક માઅહું આતા, ચ્યા આથ ઉખાય ગીઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","પોરૂષી લોક ઈસુવાવોય દોષ લાવાહાટી યોક કારણ હોદતા આતા, યાહાટી ચ્યા ચ્યાલ દિયાનથી એઅતા લાગ્યા, કા એએ કા ચ્યાલ ઈસુ પોરમેહેરા આરામા દિહી હારો કોઅહે કા નાંય. ");
INSERT INTO gbl_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","તોવે આથ ઉખાય ગીઅલા માઅહાન ઈસુવે આખ્યાં, “ઉઠ એને બોદા માઅહા વોચમાય ઉબો રો.” ");
INSERT INTO gbl_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","પાછે ઈસુવે ચ્યાહાન પુછ્યાં, “પોરમેહેરા આરામા દિહી હારાં કામ કોઅના તી હાચ્ચાં હેય કા જુઠા કોઅના, કાદા જીવ બોચાવના તી હારાં હેય કા માઆઇ ટાકના?” બાકી ચ્યા ઠાવકાજ રિયા. ");
INSERT INTO gbl_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","તોવે તો ખિજવાલો ચારીચોમખી એઇ રિયો, એને ચ્યાહા મોના કઠાણતા લેદે દુ:ખી જાયો, ઈસુવે આથ ઉખાય ગીઅલા માઅહાન આખ્યાં “તું તો આથ લાંબો કોઓ” ચ્યે આથ લાંબાવ્યો, ચ્યા આથ હારો ઓઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","તોવે પોરૂષી લોક બાઆ જાયને રાજા હેરોદ લોકહા ટોળામાઅને આરે ચ્યાલ કેહેકેન આપા માઆઇ ટાકાડજે ચ્ચો વાત કોઅતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ઈસુ ચ્યા શિષ્યહાઆરે દોરિયા એછે પાછો ગીયો, એને ગાલીલ ભાગ ને યહૂદીયા વિસ્તારામાઅને બોજ માઅહે ચ્યાપાય ટોળો વોળીન જાં લાગ્યેં, ");
INSERT INTO gbl_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","એને યહૂદીયા ભાગા, યેરૂસાલેમ શેહેરા, ઈદુમેયા ભાગાથી, યારદેન નોયે ચ્યે મેરેને, એને સુર એને સિદોન શેહેરા યા બોદા વિસ્તારામાઅને લોક યેના, યા યાહાટી યેના કા જ્યેં નોવાયે કામે ઈસુવે કોઅલે તી વોનાલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","માઅહા બોજ ગીરદ્યે લેદે, ઈસુવે ચ્યા શિષ્યહાન આખ્યાં, “માન બોહરાહાટી યોક વાહની ઉડી લીયા, એટલે માઅહે માન ડેકલી નાંય હોકે.” ");
INSERT INTO gbl_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ચ્યા દિહયા દિહી ઈસુવે બોજ જાંઅહાન હારાં કોઅલા, ચ્યાહાટી ચ્યા બિમાર લોક ચ્યાપાય ગીરદી કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","જોવે બુત લાગલાબી, ચ્યાલ એએ તોવે, ચ્યા, ચ્યા આગલા ચ્યાલ માન દાંહાટી ચ્યા પાગે પોડીન એને બોંબલીન આખે કા “તું પોરમેહેરા પોહો હેતો.” ");
INSERT INTO gbl_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ઈસુવે ચ્યાહાન કડાક ચેતાવણી દેની એને આખ્યાં “લોકહાન ખોબાર નાંય કોઅના કા આંય કું હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","પાછે ઈસુ ડોગાવોય ચોડી ગીયો, એને ચ્યા માઅહાન હાદ્યા, જ્યાહાન ચ્યાય ચ્યા શિષ્ય બોનાહાટી નિવાડલા આતા, એને ચ્યા ગીરદ્યેમાઅને ચ્યા પાહી યેના. ");
INSERT INTO gbl_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","તોવે ચ્યે બાર જાંઆહાન નિવડી કાડયા, એને ચ્યાહાન પ્રેષિત નોક્કી કોઅયા, યાહાટી કા ચ્યા ઈસુઆરે રોય હોકે એને ચ્યાહાન પોરમેહેરા સંદેશ આખા દોવાડયા, ");
INSERT INTO gbl_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","એને ચ્યાહાન બુતાલ કાડના ઓદિકાર દેનો. ");
INSERT INTO gbl_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","એને ચ્યાય નિવાડલા બારા જાણહા નાંવે યે હેય, સિમોન જ્યાલ ઈસુવે પિત્તર નાંવ દેના. ");
INSERT INTO gbl_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","જબદયા પોહા યાકૂબ એને યોહાન, યોહાનાલ ઈસુવે બોઆનેરગીસ આખ્યાં, જ્યા મોતલાબ હેય બોંબાલનારાહા હારકા માઅહું. ");
INSERT INTO gbl_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","આંદ્રિયાસ, ફિલિપ, બારતોલોમી, માથ્થી, થોમા, એને અલફિયા પોહો યાકૂબ, તદે, એને સિમોન કનાની, ");
INSERT INTO gbl_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","એને ચ્યાલ દોગો દેનારો યહૂદા ઇસ્કારીયોત. ");
INSERT INTO gbl_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ઈસુ ગોઓ ગીયો એને પાછી લોકહા બોજ ગીરદી જાયી, કા તો એને ચ્યા શિષ્ય ખાઅનાબી નાંય ખાય હોક્યા. ");
INSERT INTO gbl_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ઈ વોનાઈન ચ્યા કુટુંબવાળે ચ્યાલ લાંહાટી ગોઅરે યેને, કાહાકા લોક આખે કા તો ગાંડવાય ગીયો ઓરી. ");
INSERT INTO gbl_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","એને, જ્યા યેરૂસાલેમ શેહેરામાઅને યેનલા મૂસા નિયમ હિકાડનારા ગુરુબી આખા આતા કા, “ચ્યામાય સૈતાન જો બુતાહા મુખ્ય હેય” એને ઇબી આખે કા, “તો સૈતાન હેય ચ્યા મોદાત લેઈને ચ્યાહાન તાંગાડેહે.” ");
INSERT INTO gbl_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","તોવે ઈસુવે ચ્યાહાન હાદિન દાખલો આખ્યો, “ઓ સૈતાન કેહેકેન ઓઅઇ હોકે જો ચ્યાજ બુતાહાન લોકહામાઅને બાઆ કાડહે? નાંય, તો એહેકેન નાંય કોઅઇ હોકે.” ");
INSERT INTO gbl_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","જોવે યોક દેશા લોક ચ્યાહામાયજ ફુટ પોડે તો ચ્યા વદારી સમય નાંય ટોકી હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","જોવે યોકાજ ગાઆમાઅને લોક ચ્યાહાજ આરે જુલાતા લાગે તોવે તી ગુઉ નાંય ટોકી હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","જોવે સૈતાન પોતાનાજ બુતહા આરે વિરુદી ઓઅરી, તે તો પોતાનાજ નાશ કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“કાદોબી સૈતાના રોકા તાકાતવાળા માઅહા ગુઉ લુટી નાંય હોકે, જાવ લોગુ ચ્યા તાકાતવાળા માઅહાન આરવાહાટી એને બાંદાહાટી તાકાતવાળો નાંય રોય, તોવે તો ચ્યા ગોઆમાઅને બોદાંજ લુટી લેય હોકહે. ");
INSERT INTO gbl_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","આંય તુમહાન હાચ્ચાંજ આખહુ, કા માઅહા બોદા પાપાહાલ એને નિંદાયેલ પોરમેહેર માફ કોઅઇ દેઅરી, ");
INSERT INTO gbl_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","બાકી જો પવિત્ર આત્મા નિંદા કોઅરી, પોરમેહેર ચ્યાલ યાહાટી કોદહીજ માફ નાંય કોઅરી બાકી કાયામ તો પાપહા ગુનેગાર ઠરી.” ");
INSERT INTO gbl_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ઈસુવે ચ્યાહાન ઈ યાહાટી આખ્યાં કાહાકા ચ્યે ઈ આખે કા, એલામાય બુત હેય. ");
INSERT INTO gbl_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","પાછે ઈસુ આયહો એને ચ્યા બાહા યેને, એને બાઆ ઉબે રિયે એને ચ્યાલ ચ્યાહાય હાદાડયો. ");
INSERT INTO gbl_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","એને ઈસુવા ચોમખી બોજ જાંએ બોઠલેં આતેં, તોવે ચ્યાહાય ચ્યાલ આખ્યાં, “એએ, તો આયહો એને બાહા બાઆ ઉબે રીઅલે હેતેં તુલ હાદતેહેં.” ");
INSERT INTO gbl_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","બાકી ચ્યે ચ્યાહાન જાવાબ દેનો, “મા આયહો એને મા બાહા કું હેતેં?” ");
INSERT INTO gbl_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","એને જ્યેં ચોમખી બોઠલેં આતેં, ચ્યાહા એછે એઇન ચ્યાય આખ્યાં, “એઆ, ઈ મા આયહો એને યા મા બાહા હેતા. ");
INSERT INTO gbl_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","કાહાકા જીં માઅહું પોરમેહેરા મોરજી પુરી કોઅહે, તીંજ મા બાહા, એને બોઅહી એને આયહો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ઈસુ પાછો ગાલીલા દોરિયા મેરે હિકાડે, તોવે ચ્યાપાય બોજ મોઠી ગીરદી બેગી ઓઈ ગીયી, યાહાટી તો દોરિયામાય ઉડી આતી ચ્યેમાય ચોડીન બોહી ગીયો, એને માઅહા બોદો ટોળો દોરિયા મેરે ઉબો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ચ્યે ચ્યાહાન દાખલા દેયન બોજ હિકાડયાં ચ્યાહાન હિકાડતા ચ્યે એહેકેન આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“વોનાયા, યોક ખેડુત, બિયારો પોઆ રાનામાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","એને પોએ તોવે કોલોહોખાન બિયારો વાટે મેરે પોડયો, એને ચિડેં પોડીન તીં ખાય ગીયે. ");
INSERT INTO gbl_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","એને કોલોહોખાન બિયારો ખડકાવાળી જમીનમાય પોડ્યા, તાં કાદુ ઓછો આતો, ચ્યાહાટી બિઇ તારાતુજ ઉદી નિંગ્યા, કાહાકા તાં કાદુ ઉંડે લોગુ નાંય આતો. ");
INSERT INTO gbl_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","બાકી બોપરેહે દિહી ચોડયો એને તીડકો લાગ્યો તોવે તારાત તી કોમાઈ ગીયા, એને મુળે નાંય બોઠે ચ્યાહાટી તી ઉખાઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","એને કોલોહોખાન બિયારો કાટાહા જેખરાહામાય પોડયો, એને કાટેં વોદીન ચ્યાથી દાબાઈ ગીયા, એને કાયજ અનાજ નાંય પાક્યા. ");
INSERT INTO gbl_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","એને કોલોહોખાન બિયારો હારી જમીનમાય પોડયો, ઓ બિયારો ઉદીન પાહાય ગીયો એને હારાં અનાજ પાક્યા, કોલાહાક તીહી ગોણા, કોલાહાક હાંઈટ ગોણા, કોલાહાક હોવ ગોણા અનાજ પાક્યા.” ");
INSERT INTO gbl_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","એને ઈસુય આખ્યાં “જો વોનાયાંહાટી તિયાર હેય તીં વોનાય લેય એને ચ્યા બારામાય હુમજે.” ");
INSERT INTO gbl_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","જોવે ઈસુ એને બાર શિષ્યહાઆરે બિજા હાંગાત્યા આતા, ચ્યાહાય ઈસુલ દાખલો હોમજાડા આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ઈસુવે ચ્યાહાન આખ્યાં “તુમા તે પોરમેહેરા રાજ્યા દોબલી હાચ્ચી વાત જાંઅતાહા, બાકી જ્યા માયેવોય બોરહો નાંય કોએત ચ્યાહાન તે બોદા દાખલા દેયન હોમજાડના જરુરી હેય. ");
INSERT INTO gbl_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","જેહેકોય પવિત્રશાસ્ત્ર આખહે કા, ચ્યા એએયા કોઅતાહા બાકી ચ્યાહાન દેખાય નાંય, વોનાયા કોઅતાહા બાકી હોમજે નાંય, એહેકેન નાંય ઓએ ચ્યા વોળી યેત, એને ચ્યાહાન માફી મિળી જાય.” ");
INSERT INTO gbl_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","પાછા ઈસુવે ચ્યાહાન આખ્યાં, “જોવે તુમા ઓ દાખલો નાંય હુમજે, તોવે તુમા બિજા દાખલા બી નાંય હોમજાહા, જીં આંય તુમહાન આખનારો હેય. ");
INSERT INTO gbl_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ખેડુત પોરમેહેરા વચન પોઅહે. ");
INSERT INTO gbl_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","વોછા લોક ચ્યે વાટયે રોકા હેય જીં વાટેમાય બિયારો પોડયો, ચ્યે પોરમેહેરા વચન નોક્કીજ વોનાતેહે, બાકી તારાત સૈતાન યેઇન ચ્યાહા વોનાલા વચન વિહરાવી દેહે. ");
INSERT INTO gbl_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","એને ચ્યાજ પરમાણે, વોછા લોક તી ખડકાવાળી જાગા રોકા હેય જાં વોછોજ બિયારો પોડહે, યાહાટી ચ્યે વચન વોનાયને તારાતુજ આનંદથી માની લેતહેં, ");
INSERT INTO gbl_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","બાકી પોરમેહેરા વચન ચ્યાહા મોનામાય ઉંડે નાંય ઉત્યે, ચ્યાહાટી ચ્યે વોછા દિહાહાપુરતે માનતેહેં, ચ્યા પાછે પોરમેહેરા વચના લીદે જોવે ઓડચાણ કા દુ:ખ યેહે તોવે ચ્યે તારાતુજ ટાકી પોડતેહે. ");
INSERT INTO gbl_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","એને વોછા લોક કાટાહા જેખરાહામાય પોડલા બિયારા હારકા હેય, ચ્યાહાય તે પોરમેહેરા વચન વોનાય લેદા, ");
INSERT INTO gbl_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","એને જીવના બારામાય ચિંતા, પોયહા લોબ, એને બીજી લાલચ યેઇન પોરમેહેરા વચનાલ દાબી દેહે, એને તી નોકામ્યા જીવન જીવતેહે. ");
INSERT INTO gbl_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","એને વોછા લોક હાર્યે જમીન્યે હારકા હેય ચ્યે યે હેતેં પોરમેહેરા વચન વોનાઈન માની લેતહેં, એને ચ્યાહાટી હારાં ફળ દેતહેં, કાદા તીહી ગોણા, કાદા હાંઈટ ગોણા એને કાદા હોવ ગોણા.” ");
INSERT INTO gbl_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ઈસુવે ચ્યાહાન આખ્યાં, “કાદોબી દિવો લાવીન ચ્યાલ ટોપલ્યે કા ચાપાળા તોળે નાંય થોવેત, બાકી ચ્યાલ દીવત્યાવોય થોવતેહે કા ચ્યા ઉજવાડો બોદહાન મિળી હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","કાહાકા કોઅહીજ વસ્તુ ઓહડી નાંય હેય કા તી ડાકલી રોય એને યોકતી વસ્તુ ઓહડી નાંય હેય કા તી દુબાડી હોકાય બાકી બોદાંજ ખુલ્લાં પોડી જાય. ");
INSERT INTO gbl_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","જો વોનાયાંહાટી તિયાર હેય તો વોનાય લેય એને ચ્યા બારામાય હુમજે.” ");
INSERT INTO gbl_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ઈસુવે ચ્યાહાન આખ્યાં, “દિયાન દા કા તુમા કાય વોનાતાહા, તુમા જોલા વોદારી દિયાન દેયન વોનાયાહા તોલા વોદારે પોરમેહેર તુમહાન હોમાજ દી. ");
INSERT INTO gbl_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","કાહાકા જ્યા પાય હોમાજ હેય, તો વોદારી હોમાજ મેળવી, બાકી જ્યા પાય કાય હોમાજ નાંય મીળે, ચ્યાપાય જીં વોછીબી હોમાજ ઓરી તીં બી ચ્યાપાઅને ખોવાય જાય.” ");
INSERT INTO gbl_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","પાછી ઈસુવે આખ્યાં, “પોરમેહેરા રાજ્ય ઓહડા હેય કા જેહેકોય યોકતો ખેડુત રાનામાય બિયારો પોઅહે. ");
INSERT INTO gbl_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","એને તો ખેડુત રાતી-રાતી હુવેહે ને દિહા-દિહા કામ કોઅહે, તાંઉ બિયારો ઉદીન વોદી જાહે, બાકી ચ્યાલ ખોબાર નાંય કા ઈ કેહેકેન વોદ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","તો કાદુજ બીયારાલ ઉદાડેહે એને અનાજ પાકાડેહે, પેલ્લો ડીયો નિંગીન ઉદહે, પાછે ડોડે યેહે, પાછે કોન્ટયેહેમાય દાણા પાકતાહા. ");
INSERT INTO gbl_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","બાકી જોવે દાણા પાકી જાતાહા, તોવે તારાત ખેડુત ઓસ્યેકોય વાડી લેહે, કાહાકા દાણા પાકી ગીઅલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","પાછે ઈસુવે આખ્યાં, “આંય તુમહાન આજુ યોક દાખલો આખતાહાવ, ઈ હુમજાડા હાટી કા પોરમેહેરા રાજ્ય કોહડા હેય. ");
INSERT INTO gbl_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","તીં રાયે દાણા હારકા હેય, રાયે બિયારો ટાક્યો તોવે દોરત્યેમાય બોદા બીયારાહામાય વાહાનો બિયારો હેય. ");
INSERT INTO gbl_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","બાકી ટાક્યા પાછે, ઉદહે એને બોદયે હાકબાજયે કોઅતો મોઠો ઓઅહે એને મોઠયો ડાળખ્યો કાડહે ઓલાકા ઉચે આકાશામાય ઉડનારે ચિડેં ચ્યા છાવાડામાય યેયન ગોરો બોનાડતેહે.” ");
INSERT INTO gbl_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","એને ઈસુવે ચ્યાહાન યે પરમાણે બોજ દાખલા દેય દેયન પોરમેહેરા વચન જોલહા ચ્યા હોમાજતા આતા તોલહાજ તો ચ્યાહાન હોમજાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","એને જોવેબી ઈસુ પોરમેહેરાબારામાય વાત આખે, તોવે દાખલા દેયન આખે, બાકી જોવે તો ચ્યા શિષ્યહાઆરે યોખલો રોય તોવે ચ્યાહાન બોદા દાખલાહા મોતલાબ હોમજાડે. ");
INSERT INTO gbl_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ચ્યે દિહયે જોવે રુવાળા પોડતાજ, તોવે ચ્યે શિષ્યહાન આખ્યાં “આપા ગાલીલા દોરિયા ચ્યેમેરે જાતા.” ");
INSERT INTO gbl_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","એને શિષ્યહાય લોકહા ટોળાલ તાંજ રા દેના, એને ચ્યા ઉડીમાય બોઠા, જ્યેં ઉડીમાય ઈસુ આતો, એને ઈસુલબી ચ્યાહાઆરે લેય ગીયા, એને બીજે ઉડયે બી ચ્યાઆરે આતેં. ");
INSERT INTO gbl_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","જોવે ચ્યા દોરિયા ચ્યેમેરે જાતા આતા, તોવે મોઠો તોફાન યેનો એને પાઅયા લાફા ઉડીવોય આફળાતા લાગ્યા, ઓલાકા ઉડી પાઅયા કોઇન બાઆઈ જાતી આતી. ");
INSERT INTO gbl_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","એને ઈસુ ઉડી પાછલા ભાગામાય યોક હુઉત્યાવોય ટોલપા થોવિન હુતલો આતો, તોવે ચ્યાહાય ચ્યાલ જાગાડીન આખ્યાં, “ગુરુ આપા બોદા બુડી જાનારા હેય એને ચ્યા તુલ કાય ફિકાર નાંય હેય” ");
INSERT INTO gbl_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","તોવે શિષ્યહાય ઈસુલ જાગાડીન આખ્યાં. તોવે ચ્ચાય ઉઠીન વારાલ દોમકાડયા, એને લાફાહાન આખ્યાં “ઠાવકો રો એને શાંત ઓઅઇ જો” તોવે વારો બોંદ પોડયો એને દોરિયામાય મોઠી શાંતી ઓઅઇ ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","એને શિષ્યહાન ઈસુવે આખ્યાં, “તુમા કાહા બિઅતાહા? તુમહાન આજુબી બોરહો નાંય કા?” ");
INSERT INTO gbl_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","એને ચ્યા બોજ બિઇ ગીયા એને યોકબિજાલ આખા લાગ્યા, “ઈ કોહડા માઅહું હેય? તે તોફાન એને દોરિયો એને લાફાબી ચ્યા આગના માનતેહેં?” ");
INSERT INTO gbl_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","પાછે ઈસુ એને ચ્યા શિષ્ય દોરિયા ચ્યેમેરે ગીરાસેનિયા લોકહા ભાગામાય જાય પોઅચ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","જોવે ઈસુ ઉડીમાઅને ઉત્યો, તોવે યોક માઅહાન બુત વોળાગલા આતો તો તારાતુજ માહણાહા માઅને નિંગીન ચ્યાલ મિળ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","તો માહણામાય રોતો આતો, કાદાં માઅહું ચ્યાલ બાંદી નાંય હોકે, ઓલાકા હાકળે કોઅઇ બી નાંય બાંદાય. ");
INSERT INTO gbl_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","કાહાકા ચ્યાલ ગેડી-ગેડી બેડયેહે એને હાંકળેહેકોય બાંદેત બાકી તો હાંકળા તોડી ટાકે એને બેડયે ટુકડા-ટુકડા કોઅઇ દેય એને કાદાં માઅહું ચ્યાલ બાંદી નાંય હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","એને કાયામ રાતદીહી તો માહણામાય ફીએ એને ડોગાહામાય બોંબલ્યા કોએ, એને તો દોગડાહા કોઇન ચ્યા શરીરાલ વાડી લેતો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","જોવે ચ્ચાય દુઉરે ઈસુલ દેખ્યો, તોવે તો દાંહાદી યેનો એને ચ્યા પાગે પોડયો, ");
INSERT INTO gbl_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","એને બોજ જોરખે બોંબલીન આખ્યાં, “ઓ ઈસુ, પરમપ્રધાના પોરમેહેરા પોહા, તુલ માયેપાઅને કાય જોજે? પોરમેહેરા નાંવા કોસામ લેતહાવ કા તું માન આબદા મા દેહે.” ");
INSERT INTO gbl_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","કાહાકા ઈસુવે ચ્યાલ પેલ્લાજ આખ્યેલ, “ઓ બુતડાહાય યામાઅને નિંગી જાં.” ");
INSERT INTO gbl_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","તોવે ઈસુવે ચ્યાલ પુછ્યાં, “તો નાંવ કાય હેય?” ચ્યેય આખ્યાં, “આમે નાંવ સેના હેય, કાહાકા આમા બોજ જાંએ હેજે.” ");
INSERT INTO gbl_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","એને ચ્યાહાય ચ્યાલ બોજ રાવ્યાં કોઅયી કા “આમહાન યા ભાગામાઅને મા દોવાડેહે.” ");
INSERT INTO gbl_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","આમી તાં ડોગાવોય ડુકરાહા યોક મોઠો ટોળો ચોઅયા કોએ. ");
INSERT INTO gbl_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","તોવે બુતડાહાય ઈસુલ ઓહડી રાવ્યાં કોઇન આખ્યાં, “આમહાન ડુકરાહામાય દોવાડ ચ્યાહામાય નિંગી જાહું.” ");
INSERT INTO gbl_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ઈસુવે ચ્યાહાન પરવાનગી દેની, તોવે બુતડે નિંગીન ડુકરાહામાય ઉરાય ગીયે, એને બોદો ટોળો કોરાડા ઉપને દોરિયામાય જાયન ટુટી પોડયો, એને બુડી મોઅયે, લગભગ બેન ઓજાર ડુકરાહા ટોળો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","એને ડુકરાહા ગોવાળ નાહી પોડ્યા એને શેહેરામાય એને ગાવામાય કાય જાયા ચ્યા ખોબાર દેની કા લોક તી એઅરા યેના. ");
INSERT INTO gbl_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","તોવે કાય જાયા તી એરાહાટી માઅહે ઈસુવાપાય યેને, તોવે જીં બુતડે લાગલા માઅહું ઠાવકાજ બોઠલા દેખ્યો, એને ફાડકે પોવલે એને હારો ઓઇન ભાનમાય દેખ્યો, તીં એઇન ચ્યા બિઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","એને એએનારા માઅહાય, બુતડે લાગલા માઅહા આરે કાય જાયેલ તી વાત એને ડુકરાહા બારામાય જાયલી વાત, લોકહાન આખી દેખાડી. ");
INSERT INTO gbl_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","તોવે ચ્યાહાય ઈસુલ વિનાંતી કોઅયી એને આખ્યાં કા તું આમહે હોદ માઅને જાતો રો. ");
INSERT INTO gbl_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","તોવે ઈસુ જાંહાટી ઉડીમાય બોહી ગીયો, એને બુત લાગલા માઅહું ઈસુલ રાવ્યાં કોઇન આખા લાગ્યા “માન તોઆરે રા દે.” ");
INSERT INTO gbl_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","બાકી ઈસુવે ચ્યાલ મોનાઈ કોઅઇ દેની, એને ચ્યાલ આખ્યાં. “ગોઓ જો એને તો જાતલાહાપાય જાયન ઈસુવે તો કોરે કોલાં હારાં કામ કોઅયા એને કોલી દયા કોઅયી તી ચ્યાહાન આખ.” ");
INSERT INTO gbl_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","તોવે તીં માઅહું, એને ઈસુવે ચ્યાહાટી કોલાં હારાં કામ કોઅયા, દોહો શેહેરાહા પાહિલ્યા ભાગામાય જાતો રિયો, જ્યાલ દકોપોલીસ આખવામાય યેહે, એને જાયન જાહેર કોઅયા, એને બોદહાન ચ્યા નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","યોકદા પાછો ઈસુ ઉડીમાય બોહીન ગાલીલા દોરિયા ચ્યેમેરે ગીયો, જોવે ઈસુ દોરિયા મેરાવોય પોઅચીન ઉબલો આતો, તોવે માઅહા મોઠો ટોળો ઈસુવાપાય બેગો જાયો. ");
INSERT INTO gbl_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","તોવે યાઈર નાંવા સોબાયે ઠિકાણા આગેવાનાહા માઅને યોક યેનો એને તો યેઇન ઈસુવા પાગે પોડયો. ");
INSERT INTO gbl_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","એને યાઈર બોજ રાવ્યો કોઅતો લાગ્યો, “મા વાહની પોહી મોરાં તિયારી હેય તું મા ગોઓ યે એને ચ્યેલ આથ લાવી દે, તોવે ચ્યે બોચાવ ઓઅઇ જાય એને તી જીવતી રોય.” ");
INSERT INTO gbl_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","તોવે ઈસુ ચ્યાઆરે ચાલ પોડયો, એને ચ્યા પાહલા બોજ મોઠો ટોળો ચાલતો આતો, એને ચ્યા ચોમખી બોજ ગીરદી કોએત આતેં. ");
INSERT INTO gbl_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","એને યોક બાઈ આતી ચ્યે બારા વોરહાથી લોય પોડના બિમારી આતી. ");
INSERT INTO gbl_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ચ્યે બોજ વૈદયાહા પાયને બોજ દુઃખ ઉઠાવ્યા, એને ચ્યે બોદી માલમિલકાત ખોરચી ટાકી તેરુ ચ્યે બિમારી હારી નાંય જાઈ, બાકી આજુ વદારે માંદી ઓઅતી ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","જોવે તી ઈસુવા કોઅલા કામહા બારામાય વોનાયેલ, યાહાટી તી ટોળામાઅને ઈસુવા પાહલા યેની, એને ઈસુવા ફાડકાલ આથ લાવ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","કાહાકા ચ્યે વિચાર્યા, “જોવે એલા ફાડકાલુજ આંય આથ લાવહી તોવે મા બોચાવ ઓઅઇ જાય.” ");
INSERT INTO gbl_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","એને તારાત ચ્યે લોય પોડતા બોંદ ઓઅઇ ગીયા, એને ચ્યેલ શરીરામાય લાગ્યા કા આમી આંય હારી ઓઅઇ ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ઈસુય પોતે લોકહા એછે ફિરીન પુછ્યાં, “કુંયે મા ફાડકાલ આથ લાવ્યો?” ચ્યાય જાંઅયા કા માયેમાઅને કામ કોઅના સામર્થ નિંગ્યહા. ");
INSERT INTO gbl_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ઈસુવા શિષ્યહાય ચ્યાલ આખ્યાં કા, “તું એઅતોહોકા ચોમખીને માઅહે ગીરદી તુલ બિચડેહે એને પોડાપોડી કોઅતેહે, તેરુ પૂછતોહો કા માન કુંયે આથ લાવ્યો?” ");
INSERT INTO gbl_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","બાકી ઈસુ ઈ કુંયે કોઅયા તી એરા ચોમખી એએહે. ");
INSERT INTO gbl_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","તોવે ચ્યે બાયે જાંઅયા કા તી હારી ઓઅઇ ગિઇ, તોવે તી કાપતી એને બીઅતી યેની, એને ચ્યા પાગે પોડીન, એને બોદી હાચ્ચી-હાચ્ચી વાત આખી દેની. ");
INSERT INTO gbl_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ઈસુવે ચ્યે બાયેલ આખ્યાં, “મા બોઅહી, માયે તો બોચાવ કોઅલા હેય કાહાકા તુયે માયેવોય બોરોહો કોઅલો હેય, આમી તુલ એલી બિમારી નાંય લાગે, શાંત્યે કોઅઇ જો.” ");
INSERT INTO gbl_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","આજુ ઈસુ ચ્યેલ આખીજ રિયહો તોવે સોબાયે ઠિકાણા આગેવાના ગાઆ એછને બિજા લોકહાય યેયન યાઈરાલ આખ્યાં, “ગુરૂવાલ આબદા મા દેહે, કાહાકા તો પોહી મોઅઇ ગિઇ.” ");
INSERT INTO gbl_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","જીં વાત ચ્યા આખતા આતા તી જાણે ઈસુ તી વોનાયોહજ નાંય એને એહેકેન સોબાયે ઠિકાણા આગેવાનાલ આખ્યાં, “બીયહે મા, માયેવોય બોરહો રાખ.” ");
INSERT INTO gbl_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","એને ઈસુય પિત્તર, યાકૂબ એને યાકૂબા બાહા યોહાન, યાહા સિવાય ચ્યા એને યાઈરાહાતે ચ્યાહાઆરે ટોળામાઅને કાદાલ નાંય યા દેના. ");
INSERT INTO gbl_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","એને ચ્યા સોબાયે ઠિકાણા આગેવાના ગોઓ જાય પોઅચ્યા, તોવે ચ્યે ચ્યાહાન હુંઅકા ટાકી-ટાકીન રોડતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","તોવે ઈસુવે ગોઅમે જાયન, ચ્યાહાન આખ્યાં, “તુમહાન હુંઅકા ટાકી-ટાકીન રોડના ગોરાજ નાંય હેય પોહી મોઅઇ નાંય ગીયહી બાકી, હૂવી રિઅલી હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","બાકી લોક ચ્યાલ ઓહાં લાગ્યા, ચ્યાહાટી ચ્યે બોદહાન બાઆ દોવાડી દેના, એને આયહે આબહાલ એને પિત્તર, યાકૂબ એને યાકૂબા બાહા યોહાન યાહાન આરે લેઈને, પોહી જ્યેં ગોઅમે હુતલી આતી તાં ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","પોહયે આથ દોઇન ઈસુવે પોહયેલ આખ્યાં, “તાલીતા કુમ” યા મોતલાબ હેય, “ઓ પોહી, આંય તુલ આખહુ, ઉઠ” ");
INSERT INTO gbl_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","તી પોહી તારાતુજ ઉઠીન ચાલાફિરા લાગી તી બારા વોરહા આતી લોક બોજ નોવાય પામ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","તોવે ઈસુવે ચ્યાહાન ચેતવીન આગના દેની કા ઈ વાત કાદાલ ખોબાર નાંય પોડે, એને પોહયે આયહે આબહાલ આખ્યાં કા, પોહયેલ કાય ખાઅના દા. ");
INSERT INTO gbl_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","તોવે ઈસુ કાપરનાહુમ શેહેરામાઅને નિંગીન ચ્યા વોતની-ગાંવ નાસરેતમાય યેનો, એને ચ્યા શિષ્યબી ચ્યાઆરે ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","પોરમેહેરા આરામા દિહી ઈસુ સોબાયે ઠિકાણે લોકહાન પોરમેહેરા વચન હિકાડે, તોવે બોજ જાંએ ચ્યા વાત વોનાત, એને નોવાય પામીન આખે કા, “યા માઅહાય ઈ બોદા કેછને હિક્યાહા? એલાલ ઈ બોદા જ્ઞાન કેછને મિળ્યાં? એહેકેન મોઠે ચમત્કાર કોઅરા ચ્યાલ ગોતી કેહેકેન મિળી? ");
INSERT INTO gbl_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","કાય ઓ તોજ હુતાર્યો નાંય કા? કાય ઓ મરિયમે પોહો, એને યાકૂબ, એને યોસેસા, એને યહૂદા એને સિમોના બાહા હેય? એને કાય ચ્યા બોઅયોહો ઈહીં નાંય રોય કા?” યાહાટી ચ્યાહાય ચ્યા બારામાય ઠોકાર ખાદી. ");
INSERT INTO gbl_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ઈસુવે ચ્યાહાન આખ્યાં, “ભવિષ્યવક્તા પોતાના વોતાનમાય એને પોતાના હોગહામાય એને પોતાના ગાઆશિવાય કેસુજ માનાવોગાર્યા નાંય રોત.” ");
INSERT INTO gbl_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","એને ઈસુ ચ્યાહા વચ્ચે કોઅહેજ મોઠે ચમત્કાર નાંય કોઅઇ હોક્યો, બોજ વોછા દુખ્યાહાવોય આથ થોવિન હારેં કોઅયે, એને કાયજ ચમત્કાર નાંય કોઅયો, કાહાકા ચ્યા ચ્યાહાય નાકાર કોઅયેલ. ");
INSERT INTO gbl_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","એને ઈસુ ચ્યાહા વોછા બોરહા લીદે નોવાય પામીન, ચ્યા પાછે ચ્યાય ચારીચોમખી ગાવહામાય ફિરીન પોરમેહેરા હારી ખોબાર હિકાડતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","એને ચ્યા પાછે ઈસુ ચ્યા બાર શિષ્યહાન હાદ્યા એને ચ્યાહાન બેન-બેન જાઅહાલ બિજા-બિજા ગાવહામાય દોવાડા લાગ્યો, એને બુતાલ લોકહામાઅને કાડા ચ્યાહાન પુરો ઓદિકાર દેનો. ");
INSERT INTO gbl_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","ઈસુવે ચ્યાહાન આગના દેની, “વાટેહાટી લાકડયે સિવાય કાયજ નાંય લેતા નાંય બાખે, નાંય ઠેલી, નાંય પાકીટામાય પોયહા.” ");
INSERT INTO gbl_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","વાઅણે પોવજા બાકી બેન જોડ ડોગલેં નાંય લેતા. ");
INSERT INTO gbl_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","એને ઈસુવે ચ્યાહાન આખ્યાં, જોવે તુમા કાદા ગોઓ રાંહાટી જાહા, તાંજ રોજા, તાંઅરે તુમા નિંગી જાહા તાંઉલોગુ ચ્યાજ ગોઅમે રોજા. ");
INSERT INTO gbl_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","એને જાં તુમહાન લોક નાંય હાદેત એને તુમહાન નાંય હાંબળેત, તાંઅરે નિંગી જાયા, એને ચ્યાહાન નિશાણી દાંહાટી, તુમહે પાગહા આરેને ઉદળાં તાંજ ખેખરી ટાકજા, ચ્યાહાન ઈ ચેતાવણી દાંહાટી કા પોરમેહેરા એહેરે મિળનારી સાજા ચ્યા પોતેજ જાબાવદાર હેય. ");
INSERT INTO gbl_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","તોવે શિષ્ય ગીયા એને જાયને લોકહાન આખ્યાં, તુમા પાપહાલ માનીન, તુમહે પાપ કોઅના છોડી દા જોજે, એને પોરમેહેરાએછે ફિરી યા જોજે. ");
INSERT INTO gbl_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","એને બોજ બુતડાહાન કાડયા, એને બોજ દુખ્યાહાન જૈતુના તેલ ચોપડીન હારાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","તોવે હેરોદ રાજાબી ઈસુ મોઠા કામહા બારામાય વોનાયો, કાહાકા બોજ લોક ઈસુ બારામાય આખતા આતા, વોછા લોક ઈ આખે કા, “ઓ યોહાન બાપતિસ્મા દેનારો ઓઅરા જોજે જો મોઅલા માઅને પાછો ઉઠયોહો, યાહાટી ચ્યા આથે મોઠે ચિન્હે ઓઅતેહે.” ");
INSERT INTO gbl_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","એને બિજા લોક આખે, “ઓ તે એલીયા ભવિષ્યવક્તો હેય” એને આજુ બિજા આખે કા, “તો યોક ભવિષ્યવક્તો હેય, ચ્યા ભવિષ્યવક્તાહા હારકો જ્યા બોજ સોમાયા પેલ્લા રોતા આતા.” ");
INSERT INTO gbl_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ઈ વોનાઈન હેરોદ રાજાય આખ્યાં, “ઓ યોહાન બાપતિસ્મા દેનારો હેય, માયે પોતે જ્યા ટોલપા વાડાવી ટાક્યેલ, બાકી તો મોઅલા માઅને પાછો જીવતો ઓઇન યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","હેરોદ રાજાય કોલહાક સોમાયા પેલ્લા ચ્યા બાહા ફિલિપા થેએ હેરોદિયાસ રાણ્યેલ રાખી લેદેલ, બાકી યોહાને ચ્યાલ આખ્યાં, “તુલ તો બાહા થેએયેલ રાખના નિયમા ઇસાબે ઠીક નાંય હેય.” તોવે હેરોદિયાસ રાણ્યેલ ખુશ કોઅરાહાટી, રાજા હેરોદાય યોહાનાલ દોઆડીન ચ્યાલ જેલેમાય કોંડાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ચ્યાહાટી હેરોદિયાસ રાણી યોહાના આરે આડાઇ કોએ, એને માઆઇ ટાકાડાં માગે, બાકી માઆઇ નાંય હોક્યા, ");
INSERT INTO gbl_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","કાહાકા હેરોદ રાજા યોહાનાલ ન્યાયી એને પોરમેહેરા પવિત્ર માઅહું જાંઅતો આતો. યાહાટી તો ચ્યાથી બિઇ ગીયો એને ચ્યાલ હેરોદિયાસ રાણ્યે પાયને બોચાવી રાખાંહાટી જેલેમાય હારેરીતે રાખ્યો, એને જોવે ચ્યાઆરે બોલે તોવે ચ્યા હાંબળીન ગાબરાય જાતો આતો બાકી ખુશ્યેથી વોનાતો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","બાકી યોક દિહી, હેરોદ રાજા જન્મા દિહી મનાવ્યો તોવે ચ્યાય ચ્યા અમલદારાહાલ, મોંતર્યાયાહાન, એને ગાલીલ ભાગા, મોઠા આગેવાનાહાન હારાં યોક જેવાણ કોઅરા હાદ્યા, તોવે હેરોદિયાસ રાણ્યેલ યોહાનાલ માઆઇ ટાકાડના મોકો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","તાં હેરોદિયાસ રાણ્યે પોહી આંદાર યેની, એને ચ્યે નાચ નાચી દેખાડી ચ્યેય હેરોદ રાજા એને ચ્યા ગાવારાહાન ખુશ કોઅયા, તોવે રાજાય પોહોયેલ આખ્યાં, માગ, “જીં જોજે તી માયેપાઅને માગ, એને તી તુલ આંય દિહી.” ");
INSERT INTO gbl_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","એને હેરોદ રાજાય, કોસામ ખાયન આખ્યાં, માયેપાઅને તું જીં માગે તી આંય દિહી, “મા રાજ્યા આરદો ભાગ તું માગે તેરુ તો તુલ દિહી.” ");
INSERT INTO gbl_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","પોહયે બારે જાયન ચ્યે આયહેલ પુછ્યાં, “આંય કાય માગુ?” ચ્યે આખ્યાં, યોહાન બાપતિસ્મા દેનારા ટોલપા દાં આખ. ");
INSERT INTO gbl_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ચ્યે તારાત આંદાર રાજાપાય જાયન આખ્યાં, “મા માગણી હેય કા તું માન આમીંજ યોહાન બાપતિસ્મા દેનારા ટોલપા વાડીન થાળ્યેમાય દે.” ");
INSERT INTO gbl_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","રાજાલ જુઠા લાગ્યા, બાકી જ્યાહાલ ચ્યે હાદલા ચ્યાહા હામ્મે ચ્યે કોસામ ખાદેલ, ચ્યાહાટી નાંય આખના ઈંમાત નાંય ચાલી. ");
INSERT INTO gbl_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","એને તારાત યોહાન બાપતિસ્મા દેનારા ટોલપા વાડીન લાંહાટી રાજાય યોક આગના દેયને સીપાડાલ જેલેમાય દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","તો જેલેમાય ગીયો એને ચ્યા ટોલપી વાડીન થાળ્યેમાય થોવિન પોહોયેલ દેની, એને પોહયે આયહેલ દેની. ");
INSERT INTO gbl_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ઈ વોનાયને યોહાના શિષ્યહાન ખોબાર પોડી, કા યોહાનાલ માઆઇ ટાક્યોહો તોવે ચ્યા યેના, એને ચ્યા કુડી લેઈને ચ્યાહાય તી માહણામાય દાટી દેની. ");
INSERT INTO gbl_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","જોવે ચ્યા બાર પ્રેષિત જ્યાહાન ઈસુવે દોવાડલા આતા ચ્યા ફિરી યેના એને યેયન ચોમખી યોકઠા જાયા, એને ચ્યાહાય જીં કાય કોઅયા એને હિકાડયાં તીં બોદા ચ્યાલ આખી દેખાડયાં. ");
INSERT INTO gbl_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","બાકી બોજ જાંએ યાઉ જાવ કોઅતે આતેં એને યાહાન ખાઅનાબી સમય નાંય મિળતો આતો, તોવે ઈસુવે શિષ્યહાન આખ્યાં, ચાલા આપા બોદા, યોક આલાગ એકાંત જાગામાય જાતા, જાં યોખલા રોય હોકજે એને વાહાયોક આરામ કોઅઇ હોકજે. ");
INSERT INTO gbl_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","યાહાટી ચ્યા ઉડીમાય બોહીન યોક એકાંત જાગામાય નિંગી ગીયા જાં ચ્યા યોખલાજ રોય હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","એને લોકહાય ચ્યાહાન નિંગતા દેખીન જાઈ લેદા, કા કેછ જાઈ રીઅલા હેય, યાહાટી ચ્યા ભાગા આજુબાજુ ગાવહામાઅને માઅહે દાંહાદી જાયન, એને ચ્યાહા આગલા તાં યી ફૂગ્યેં. ");
INSERT INTO gbl_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","જોવે ઈસુ ઉડીમાઅને ઉત્યો, એને માઅહા બોજ મોઠો ટોળો દેખીન, ચ્યાહાવોય ચ્યાલ દયા યેની, કાહાકા ચ્યાહાઆરે કાદો નાંય આતો જો હારેકોય ચ્યાહા આગેવાની કોઅઇ હોકે એને ચ્યાહાન હાંબાળ કોઅઇ હોકે, જેહેકોય મેંડવાળ્યાહા વોગાર ગેટેં, એને ઈસુ ચ્યાહાન પોરમેહેરા રાજ્યા બારામાય બોજ વાતો હિકાડાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","એને જોવે દિહી બુડા આતો તોવે ચ્યા શિષ્યહાય ઈસુવાપાય યેઇન આખ્યાં “એકાંત જાગો હેય, એને દિહી બુડા વાય રિયહો. ");
INSERT INTO gbl_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","લોકહાન જાં દે કા ચોમખી ગાવહામાય એને ફોળ્યે-ફોળ્યેહે માય જાયન ખાઅના વેચાતાં લેય યેય હોકે.” ");
INSERT INTO gbl_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","બાકી ઈસુવે શિષ્યહાન આખ્યાં, “તુમા એલહાન ખાઅના દિયા” તોવે ચ્યાહાય ચ્યાલ આખ્યાં, “કાય, આમા જાયન હોવ દિનારાહા (૧ દીનાર યોક ચાંદ્યે સિક્કો એટલે યોકા દિહા કાંબારાં ઓઅહે) બાખે લેઈને ખાવાડજે કા?” ");
INSERT INTO gbl_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ઈસુવે શિષ્યહાન પુછ્યાં, “તુમહેપાય કોલ્યો બાખ્યો હેત્યો એરા જાયા?” ચ્યાહાય ખોબાર કાડીન આખ્યાં, “પાચ બાખે એને બેન માછલ્યો.” ");
INSERT INTO gbl_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","તોવે ઈસુવે શિષ્યહાન આખ્યાં, “ટોળ્યો-ટોળ્યો પાડીન ચ્યાહાન નીળા ગાહીયાવોય બોહતા કોઅઇ દા.” ");
INSERT INTO gbl_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ચ્યા પોચાહા-પોચાહા એને હોવા-હોવા ટોળા પાડીન બોહી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","તોવે ઈસુય પાચ બાખે એને બેન માછલ્યો લેદ્યો, એને હોરગા એછે એઇન પોરમેહેરા આભાર માન્યા, એને બાખે મૂડી-મુડીન લોકહાન દાંહાટી શિષ્યહાન દેન્યો એને બેન માછલ્યો બી બોદહાન વાટી દેન્યો. ");
INSERT INTO gbl_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","બોદહાય ખાદાં એને દારાઈ ગીયે, ");
INSERT INTO gbl_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","એને ચ્યાહાય ઉગારલા ખાઅના યોખઠા કોઅયા, તે બાખે એને માછલ્યેહે કોય બારા ટોપલ્યો બોઅયો. ");
INSERT INTO gbl_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","જ્યાહાય બાખ્યો ખાદ્યો, ચ્યા પાચ ઓજાર બાહા આતા, ચ્યાહાય બાયહે એને પોહાહા ગોણત્રી નાંય કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","તોવે ઈસુવે તારાત ચ્યા શિષ્યહાન આખ્યાં કા ઉડીમાય બોહીન ચ્યેમેરે બેતસાદા નગરા એછે ઉપડી જાયા, તાંઉલોગુ તો પોતે લોકહાન દોવાડી દેય. ");
INSERT INTO gbl_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","એને લોકહાન દોવાડી દેયન પાછે તો પ્રાર્થના કોઅરાહાટી ડોગાવોય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","એને હાંજે રુવાળા ઓઅતા લાગ્યા તોવે ઉડી દોરિયા વોચ્ચે આતી એને મેરાઈહીને ઘોણે દુર આતી, એને ઈસુ યોખલો બુઈયે ઉપે આતો. ");
INSERT INTO gbl_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","એને જોવે ઈસુવે શિષ્યહાન દેખ્યા, કા ચ્યા ઉડી ચાલાડતા-ચાલાડતા બોજ ગાબરાય ગીયહા, કાહાકા વારો હામ્મેજ યેહે તો રાતી આસરે ચાર વાગે ઓહોડેહે ઈસુ દોરિયા ઉપે ચાલીન ચ્યાહાપાય યેનો એને તો ચ્યાહા આગલા નિંગી જાં વિચારતો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","બાકી જોવે ચ્યાહાય ઈસુલ દોરિયા ઉપે ચાલતા દેખીન, ચ્યા બોંબલી ઉઠયા કાહાકા ચ્યાહાય ચ્યાલ બુત જાંઆયો, એને ચ્યા ગાબરાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","કાહાકા બોદાજ ચ્યાલ દેખીન ગાબરાઈ ગીઅલા આતા બાકી તારાતુજ ઈસુવે ચ્યાહાન હાત કોઇન આખ્યાં, “ઈંમાત રાખા, આંય ઈસુ હેતાઉ ગાબરાયાહા મા.” ");
INSERT INTO gbl_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","પાછે ઈસુ ચ્યાહાપાય યેનો એને ઉડીમાય ચોડી ગીયો એને વારો ઠાવકો રિયો, તોવે ચ્યાહાન બોજ નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ચ્યાહાય દેખ્યાકા પાછલે દિહી ઈસુવે બાખ્યેહે આરે કાય કોઅલા આતા, બાકી ચ્યાહાન આજુબી હારી હોમાજ નાંય પોડયેલ, ઈહીં લોગુ કા ઈસુ હાચ્ચો કું આતો, ચ્યાહા મોનામાય આજુબી બોરહો નાંય ઓએ. ");
INSERT INTO gbl_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","જોવે ઈસુ એને ચ્યા શિષ્ય યોકે ઉડીમાય ગાલીલા દોરિયામાય આજુ આગલા ગીયા એને ચ્યા ગેનેસારેત ભાગામાય યેય ફૂગ્યા, એને ચ્યાહાય ઉડી મેરે બાંદી. ");
INSERT INTO gbl_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ચ્યા ઉડીમાઅને ઉત્યા, તોવે લોકહાય ઈસુવાલ તારાતુજ વોળખીન. ");
INSERT INTO gbl_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ચ્યા બોદા શેહેરામાય માહારી દાહુદી ગીયા એને ખાટલાહાવોય દુખ્યાહાન હુવાડીન, જાં વોનાયા કા ઈસુ તાં હેય, તાં લેય યેના: ");
INSERT INTO gbl_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","જાં કેસ ઈસુ ગાવહામાય, કા શેહેરાહામાય ગીયો, તોવે દુખ્યાહાન બાજારામાય થોવિન ચ્યા રાવ્યો કોએત, કા ઈસુ ફાડકા મેરાલ આથ લાવાં દેય. એને જોલે ચ્યાલ આથ લાવેત, ચ્યા બોદહાજ બોચાવ ઓઅઇ જાય. ");
INSERT INTO gbl_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","યોક દિહી કોલહાક મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોક યેરૂસાલેમ શેહેરામાઅને યેનલા આતા, ઈસુપાય ટોળો જાયા, ");
INSERT INTO gbl_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ચ્યાહાય દેખ્યાકા, ઈસુવા આરદા શિષ્ય ઓહડા આથે ખાઅના ખાત કા ચ્યાહા આથ અશુદ્ધ આતા, એટલે ચ્યાહાય ચ્યાહા આથ યહૂદી રીતી ઇસાબે દોવલાં નાંય આતા. ");
INSERT INTO gbl_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","કાહાકા પોરૂષી લોક એને બોદા યહૂદી ખાઅના ખાં પેલ્લા કાયામ વાડવડીલાહા રીતી ઇસાબે આથ દોવતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","આટામાઅને ગોઓ યેઇન પાછે જાવ લોગુ ચ્યા પોતાલ હારેકોય નાંય દોવી લેય, તાંઉલોગુ ખાઅનાબી નાંય ખાત; એને બીજ્યોબી બોજ રીત્યો હેત્યો, જ્યો ચ્યાહાન પાળાહાટી દેનલ્યો હેય, જેહેકોય બાંગારા વાહાણે, કોળ્યાહા-લોટાહા, એને તોપલેં દોવના-ચોળના. ");
INSERT INTO gbl_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","યાહાટી પોરૂષી લોક એને મૂસા નિયમ હિકાડનારા ગુરુવાહાય ઈસુલ પુછ્યાં કા, “તો શિષ્ય આમે વડીલાહા રીવાજ કાહાનાય માનેત? ચ્યા હારેકોય આથ દોવ્યા વોગાર મેલા આથહા કોઅઇ બાખે ખાતહા.” ");
INSERT INTO gbl_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","બાકી ઈસુવે ચ્યાહાન જાવાબ દેનો કા, તુમા ડોંગી લોકહા બારામાય યશાયા ભવિષ્યવક્તાય હાચ્ચાં આખ્યેલ; કા જેહેકોય લોખલાં હેય ચ્યા લોક મા બારામાય બોજ હારાં બોલતાહા, બાકી ચ્યા માયેવોય હાચ્ચાં પ્રેમ નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ચ્યાહા ભક્તિ માંહાટી નકામી હેય, કાહાકા ચ્યા લોકહાન માઅહા બોનાડલા રીવાજ પાળા હિકાડતાહા, જેહેકોય ચ્યા મા હુકુમ હેય. ");
INSERT INTO gbl_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","તુમાહાય પોરમેહેરા આગના પાળના બોંદ કોઅઇ દેનાહાં એને માઅહા રીવાજ પાળતાહા. ");
INSERT INTO gbl_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા પોરમેહેરા આગના પાળના છોડી દેતહા કા તુમા તુમહે રીવાજેકોય કામ કોઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","મૂસાયે આખ્યેલ કા, તો આયહે આબહાલ માન દે; જીં માઅહું આયહે આબહાલ ગાળી દેય, ચ્યાલ નોકીજ માઆઇ ટાકવામાય યી.” ");
INSERT INTO gbl_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","12","બાકી તુમા આખતાહા કા જોવે કાદો ચ્યા આબહાલ એને આયહેલ આખે, “આંય તો મોદાત નાંય કોઅઇ હોકુ, કાહાકા જીં આંય તુલ દેતહાવ તી માયે પોરમેહેરાલ દેયના કોસામ ખાદહી, યાહાટી ઈ બેટ પોરમેહેરાહાટી હેય,” એને પાછી તોવેને, તુમા ચ્યા માઅહાન આયહો કા આબહા મોદાત કોઅના રાજા નાંય દેત (જેહેકોય પોરમેહેરા આગના હિકાડેહે). ");
INSERT INTO gbl_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","એહેકેન કોઇન, તુમા પોરમેહેરા આગના પાળેત નાંય જો તુમહાન દેનલો હેય, કા તુમા વડીલાહા પાયને લેદલા રીવાજ પાળી હોકે, એહેકેન તુમા બોજ ખારાબ કામે કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","એને ઈસુવે લોકહાન પાહાય હાદિન આખ્યાં, “તુમા બોદા મા વોનાયા, એને હોમજાં. ");
INSERT INTO gbl_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","માઅહે જીં બી ચ્યાહા શરીરામાય લેતહેં ચ્યામાય ઓહડા કાયજ નાંય હેય કા તી ચ્યાહાન મેલાં કોઅઇ હોકે, માઅહે ચ્યે વસ્તુ કોઅઇ મેલેં ઓઅતેહે, જીં માઅહા માજેરે નિંગહે. ");
INSERT INTO gbl_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","જો વોનાયાંહાટી તિયાર હેય તો વોનાય લેય, એને ચ્યા બારામાય હુમજે.” ");
INSERT INTO gbl_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","પાછે તો ટોળાલ છોડીન ગોઅમે યેનો, તોવે ચ્યા શિષ્યહાય ચ્યાય જીં કાય દાખલા દેયને આખ્યેલ ચ્યા મોતલાબ પુછ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ઈસુવે શિષ્યહાન આખ્યાં, “કાય એહેકેન તુમહાનબી નાંય હોમજાય કા? તુમા નાંય હોમજેત કા, જીં ખાઅના માઅહું ખાહે તી માઅહાન મેલાં નાંય બોનાવી હોકે? ");
INSERT INTO gbl_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","કાહાકા તી ચ્યાહા મોનામાય નાંય જાય, બાકી ચ્યા બુકામાય જાહે, એને પાછે તો ઝાડાવાટે બાઆ નિંગી જાહે” એહેકેન આખીન, ઈસુવા મોતલાબ આતો કા બોદીજ ખાઅના વસ્તુ ખાંહાટી લાયક્યે હેય. ");
INSERT INTO gbl_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","એને ઈસુવે આખ્યાં, “માઅહું જીં વિચાર કોઅહે, આખહે એને કોઅહે, તીંજ માઅહાન પોરમેહેરા હામ્મે મેલાં કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ચ્યા મોનામાઅને, ખારાબ વિચાર, વ્યબિચાર, ચોરી, ખૂન, પારકી થેએ, ");
INSERT INTO gbl_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","લોબ, લુચ્ચાઈ, છેતારના, જુઠા કામ, નિંદા, અભિમાન, ઓકાલ વગારન્યો વાતો, ");
INSERT INTO gbl_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ઓહડે બોદે પાપ મોનામાઅને બાઆ નિંગતેહે એને માઅહાન મેલાં માઅહું કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ચ્યા પાછે ઈસુ એને ચ્યા શિષ્ય તાંઅરે જાતા રિયા, એને પાછે સુર એને સિદોન નાંવા શેહેરા આજુ-બાજુ વિસ્તારામાય ગીયા, તાં યોક ગોઅમે ગીયા એને ચ્યા ઇચ્છા આતી કા કાદાલ ખોબાર નાંય પોડે કા તો તાં રિઅલો હેય. બાકી લોકહાન તારાત ખોબાર પોડી કા તો તાં હેય. ");
INSERT INTO gbl_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","એને તારાત ચ્યા બારામાય વોનાઈન યોક બાય યેની એને ચ્યા પાગે પોડી ચ્યે પોહોયીલ બુત લાગલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","તી બાય યુનાની આતી, તી સિરીયા ભાગા એને સુરુફિની નાંવા ભાગામાય જોન્માલ યેનલી આતી; એને ચ્યે ઈસુલ વિનાંતી કોઅયી, કા ચ્યે પોહયે માઅને બુતાલ કાડી ટાકે. ");
INSERT INTO gbl_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","તોવે ઈસુવે ચ્યેલ આખ્યાં, “પેલ્લા માન મા કુટુંબ યહૂદીયાહાલ મોદાત કોઅના હેય, પાહાહા પાયને ખાઅના માગના એને કુતરાહાલ ખાવાડના ઠીક નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","તી બાય હુમજી ગિઇ કા ઈસુ ગેર યહૂદીયાહાલ કુત્રે એને યહૂદીયાહાલ પોહેં એહેકેન આખહે. યાહાટી ચ્યેય ઈસુવાલ જાવાબ દેનો, “હાચ્ચાં હેય પ્રભુ, બાકી પાહાહા આથામાયને પોડલા ટુકડાહા ચૂરો કુત્રે ખાતહેં.” ");
INSERT INTO gbl_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","તોવે ઈસુવે ચ્યેલ આખ્યાં, “કાહાકા તુયે બોરહો કોઇન આખ્યાં, યાહાટી ગોઓ જો બુત તો પોહયે માઅને નિંગી ગીયોહો.” ");
INSERT INTO gbl_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","તી ગોઓ ગિઇ, એને પોહી ખાટલાવોય હુતલી દેખી, એને બુત તે નિંગી ગીઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ઈસુ એને ચ્યા શિષ્ય સુર શેહેરા આજુ-બાજુ ભાગ છોડીન સિદોન શેહેરામાઅને નિંગ્યા, દોહો શેહેરાહા આહી-પાહિલ્યા ભાગામાઅને ગીયા, જ્યાલ દકોપોલીસ આખતેહે તેહે રોઇન ચ્યા પાછા ગાલીલ દોરિયા એછે યેના. ");
INSERT INTO gbl_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","એને માઅહે યોક બોઓરા એને બોબડયા માઅહાન ચ્યાપાય લેય યેને, એને માઅહાય ઈસુલ આથ લાવાહાટી રાવ્યાં કોઅયા કા તો હારો ઓઅઇ જાય. ");
INSERT INTO gbl_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","તો ચ્યાલ ટોળામાઅને કાન્યે લેય ગીયો, ચ્યા કાનામાય આંગળી ગાલી, એને ચ્યાય યોક આંગળીયેવોય થુપીન ચ્યા માઅહા જીબ્યેલ લાવ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","એને હોરગા એછે એઇન એને મોઠેથી હાઆ લેદી, ઈસુવે ચ્યાલ આખ્યાં, “એફેતા” મોતલાબ કા “ઉગડી જો.” ");
INSERT INTO gbl_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","એને તારાત તી માઅહું વોનાયા લાગ્યા એને જીબ્યે કોઅઇ તકલીફ વોગાર બોલા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","એને ઈસુવે લોકહાન આખ્યાં, કા “ઈ કાદાલ નાંય આખના કા માયે કાય કોઅલા હેય” બાકી જોલો વોદારે આખે કા નાંય આખના, તોલા વોદારે ચ્યા બીજહાન આખતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","એને ચ્યા બોજ નોવાય પામીન આખા લાગ્યા, “ચ્યે બોદા હારાં કોઅયાહાં, બોઓરાહાલ વોનાતા કોઅયા, એને બોબડયાહાલ બોલતા કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ચ્યા દિહહામાય, બોજ લોક ઈસુ પાહી યેના એને ચોમખી યોક મોઠો ટોળો બેગો જાયો. જોવે ચ્યાહાપાય ખાઅના નાંય આતા, તોવે ઈસુવે ચ્યા શિષ્યહાન હાદિન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“માન યા લોકહાવોય દયા યેહે, આમી તીન દિહી જાયાહા, ચ્યા માયેપાંય હેતા, એને ચ્યાહાપાય ખાઅના કાયજ નાંય આતા. ");
INSERT INTO gbl_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ઈહીમાઅને કોલાહાક જાંઆ બોજ દુઉરે યેનહા, જોવે આંય ચ્યાહાન બુખા ગોઓ દોવાડી દાંઉ, તોવે વાટેમાય ચ્યા થાકીન તાંજ રોય પોડી.” ");
INSERT INTO gbl_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","શિષ્યહાય ઈસુવાલ આખ્યાં કા, “યા ઉજાડ જાગામાય ઓલા બોદા લોકહાન ખાવાડા હાટી કેછને ખાઅના મીળે?” ");
INSERT INTO gbl_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ઈસુવે શિષ્યહાન પુછ્યાં, “તુમહેપાય કોલ્યો બાખ્યો હેત્યો?” ચ્યાહાય આખ્યાં, “આમહાપાય હાંત બાખ્યો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","તોવે ઈસુય બોદા લોકહાન દોરત્યેવોય બોહના આખ્યાં, તોવે ચ્યે બોહી ગીયે, પાછે હાંત બાખે લેદ્યો એને પોરમેહેરા આભાર માનીન બાખ્યે ટુકડા કોઇન શિષ્યહાન વાટી દાં આખ્યાં, એને ચ્યાહાય લોકહાન વાટી દેના. ");
INSERT INTO gbl_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ચ્યાહાપાય વોછે વાહને માછલે બી આતેં, ચ્યાહાવોય પોરમેહેરાલ આભાર માનીન એને લોકહાન વાટાં શિષ્યહાન દેના. ");
INSERT INTO gbl_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","લોકહાય ખાદાં એને દારાઈ ગીયે, તોવે શિષ્યહાય હાંત ટોપલ્યો બોઇન વોદલા ખાઅના બેગા કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","એને માઅહે આસરે ચાર ઓજાર આતેં, ઈસુવે લોકહાન દોવાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","એને તોવે ઈસુ તારાત શિષ્યહાઆરે ઉડીમાય બોહી ગીયો એને દાલમનૂતા વિસ્તારામાય યેનો. ");
INSERT INTO gbl_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","પાછે વોછા પોરૂષી લોક ઈસુવાપાય યેના ચ્યાઆરે ચર્ચા કોઅતા લાગ્યા, એને ચ્યાહાય માગણી કોઅયી કા આમહાન હોરગા એછને મોઠે ચમત્કાર દેખાડ, ચ્યા ઈસુલ ફોસવા હાટી ઈ માગણી કોઅઇ રીયલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","બાકી ઈસુવે મોઠે હાઆ ટાકીન આખ્યાં, “યે પેડયે લોક કાહા મોઠે ચમત્કાર માગતાહા? હાચ્ચાંજ આખહુ યે પેડયેલ મોઠે ચિન્હ કાદે દિહી નાંય દેવાયી.” ");
INSERT INTO gbl_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","એને ઈસુવે પોરૂષી લોકહાન છોડી દેના, તો ચ્યા ચેલાહાઆરે પાછા ઉડીમાય બોહી ગીયા એને ગાલીલ દોરિયા બિજ્યે બાજુ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","તોવે શિષ્ય બાખે લેઅના વિહરાય ગીયા, એને ચ્યાહાપાય યોક બાખે સિવાય ઉડીમાય બીજ્યો બાખ્યો નાંય આત્યો. ");
INSERT INTO gbl_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ઈસુવે શિષ્યહાન ચેતાવણી દેયન આખ્યાં, “એઆ પોરૂષી લોકહા એને હેરોદ રાજા ખમીરથી બોચાંહાટી હાચવીન રોજા.” ");
INSERT INTO gbl_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ચ્યા ચ્યાહા વોચમાય યોકબીજાઆરે વાતો કોઅરા લાગ્યા, “તો એહેકેન યાહાટી આખી રીયલો હેય કાહાકા આમેપાય પુરત્યો બાખે નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ઈસુ જાંઆઈ ગીયો ચ્યા કાય વાતો કોઅતાહા તોવે શિષ્યહાન આખ્યાં કા, “આમેપાય બાખે નાંય હેય ઓહડા તુમા કાહા વિચાર કોઅતાહા? કાય તુમાહાય તુમહે મોનાલ ઓલા કોઠાણ બોનાવી લેદહા કા તુમા આજુબી હોમજી નાંય હોક્યાહા? ");
INSERT INTO gbl_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","કાય તુમહે ડોળા આંદળા હેય તેન તુમહાન નાંય દેખાય? કાય તુમહે કાન બોઅર્યા હેય તેન તુમા નાંય વોનાત? એને તુમહાન યાદ નાંય રિયા? ");
INSERT INTO gbl_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","તોવે તુમહાય ઉગારલા ટુકડાહા કોલ્યો ટોપલ્યો બોઅલ્યો” જોવે માયે પાચ ઓજારાહાહાટી કેવળ પાચ બાખ્યેહેકોય ખાવાડલા આતા? ચ્યાહાય ચ્યાલ જાવાબ દેનો, “બાર ટોપલ્યો.” ");
INSERT INTO gbl_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“એને ચાર ઓજાર લોકહાહાટી માયે હાંત બાખ્યો મુડયો, તોવે કોલ્યો ટોપલ્યો બોઅલ્યો?” ચ્યાહાય ચ્યાલ આખ્યાં “હાંત ટોપલ્યો.” ");
INSERT INTO gbl_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","એને ઈસુવે શિષ્યહાન આખ્યાં, “આજુબી તુમા નાંય હોમજેત કા આંય કું હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","તોવે ઈસુ એને ચ્યા શિષ્ય બેતસાદા ગાવામાય યેય પોઅચ્યા, તાં માઅહે યોક આંદળાલ ચ્યાપાય લેય યેને, એને ચ્યાલ વિનાંતી કોઅયી કા ચ્યાલ આથ લાવીન હારો કોએ. ");
INSERT INTO gbl_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ઈસુ આંદળાલ આથ દોઇન ગાવા બાઆ લેય ગીયો, પાછે, ચ્યા ડોળા વોય થુપ લાવ્યાં એને ઈસુવે ચ્યાવોય આથ થોવ્યો એને પુછ્યાં, કા “તુલ કાય દેખહાય?” ");
INSERT INTO gbl_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ચ્યે નોજાર કોઇન આખ્યાં, “માઅહે દેખાતેહે, બાકી માન જાખાં દેખાયેહે કાહાકા ચ્યા જાડાહા હારકા કાય ફીઅતા એઅતાહાવ.” ");
INSERT INTO gbl_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","તોવે ઈસુય પાછા બિજ્યે વોખાત ચ્યા ડોળાહા ઉપે આથ થોવ્યો, તોવે ચ્યે ડોળા ઉગાડયા એને તો પુરીરીતે કોઅઇ હારો ઓઅઇ ગીયો, એને તો બોદા ચોખ્ખાં એઇ રીયલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","“પાછે ઈસુવે ચ્યાલ આખ્યાં ગોઓ ફિરી જો, બાકી ગાવા વાળહાન કાય આખાહાટી મા જાહે કા ઈહીં કાય જાયલા આતા.” ");
INSERT INTO gbl_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ઈસુ એને ચ્યા શિષ્ય બેથસદા ગાવામાઅને કૈસરીયા ફિલીપીયા શેહેરા આહી-પાહિલ્યા ગાંવાહા જાગે ગીયા, તોવે વાટેમાય ઈસુવે ચ્યા શિષ્યહાન પુછ્યાં કા, “માઅહે માન કાય આખતેહે?” ");
INSERT INTO gbl_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","શિષ્યહાય જાવાબ દેનો, “કોલહાક લોક આખતાહા કા તું યોહાન બાપતિસ્મા દેનારો હેય, બીજહા આખના હેય કા તું એલીયા હેય, એને બિજા-બિજા લોક આખતાહા કા તું ભવિષ્યવક્તાહા માઅને યોકતો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","તોવે ઈસુવે શિષ્યહાન પુછ્યાં કા, “બાકી તુમા તુમહે વચ્ચે કાય વિચાર કોઅતાહા કા આંય કું હેય?” તોવે પિત્તરે જાવાબ દેનો, “પોરમેહેરા ઇહિને દોવાડલો ખ્રિસ્ત હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","તોવે ઈસુવે શિષ્યહાન ચેતાવણી દેયન આખ્યાં કા, “મા બારામાય કાદાલ આખના નાંય.” ");
INSERT INTO gbl_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ઈસુય શિષ્યહાન હિકાડના સુરુ કોઅયા, “માન જીં માઅહા પોહાહાટી ઈ જરુરી હેય, કા બોજ દુ:ખ વેઠાં પોડી, એને આગેવાન માઅહે, મુખ્ય યાજક એને મૂસા નિયમ હિકાડનારા ગુરુ ચ્યાલ નાકારી દી એને માઆઇ ટાકી, એને તીન દિહી પાછે તો મોઅલાહામાઅને પાછો જીવતો ઉઠી.” ");
INSERT INTO gbl_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ઈસુય ઈ વાત ખુલ્લી-ખુલ્લી રીતે આખી દેની, તોવે પિત્તરે ચ્યાલ આલાગ લેય જાયન પીડા એને માઆઇ ટાકના બારામાય વાત કોઅયી યાહાટી ખિજવાયા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","બાકી ઈસુ પાછો વોળીન એને શિષ્યહા એછે એઅયા એને પાછે પિત્તરાલ ખિજવાયો, “ઓ સૈતાન, મા હામ્મેથી દુર ઓઅઇ જો; કાહાકા તો વિચાર પોરમેહેરા એછને નાંય, બાકી માઅહા એછને હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","એને શિષ્યહાઆરે લોકહાન હાદિન ચ્યે આખ્યાં, “જો કાદાં મા શિષ્ય બોના માગહે, ચ્યાલ પોતાલ નાકાર કોઅરા જોજે એને પોતાનો હુળીખાંબ ઉચકીન મા શિષ્ય બોને. ");
INSERT INTO gbl_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","કાહાકા જીં માઅહું દોરત્યેવોય પોતે જીવ બોચાવાં માગહે, તો હાચ્ચાં જીવન ગુમાવી દી, બાકી તુમા જ્યા મા લીદે એને પોરમેહેરા હારી ખોબારે લીદે ચ્યા જીવ દેહે, તો હાચ્ચાં જીવન મેળવી. ");
INSERT INTO gbl_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","યોક માઅહાન કાય લાભ જોવે ચ્યાલ બોજ મિલકાત મીળે બાકી પોરમેહેરાઆરે હાચ્ચાં જીવન ગુમાવી દેય? ");
INSERT INTO gbl_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","યોક માઅહું પોરમેહેરાલ કાય દી હોકહે, જીં ચ્યા અનંતજીવન વેચાતાં લેય?” કાય નાંય. ");
INSERT INTO gbl_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","જોવે તુમહેમાઅને કાદો માન ચ્યા પોરમેહેરા હારકો એને મા વાતહે પાળાહાટી મોનાઈ કોઅહે કાહાકા પોતે બિઅતાહા કા યા સોમાયા પાપી લોક તુમહે નુકસાન કોઅરી, પાછે આંય, માઅહા પોહાલ મોનાઈ કોઅઇ દિહી કા તુમા મા શિષ્ય હેય, જોવે આંય પવિત્ર દૂતહા આરે દોરતીવોય પાછો યીહીં, તોવે બોદા મા મહિમા પ્રતાપ દેખી જો મા આબહા હારકો હેય. ");
INSERT INTO gbl_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","પાછે ઈસુવે શિષ્યહાન એને લોકહાન આખ્યાં, “આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા ઈહીં ઉબલા કોલહાક લોક તોવેબી જીવતા રોય, જોવે ચ્યા પોરમેહેરા રાજ્યા સામર્થ્યા કોઅઇ ચ્યાહા વોચ્ચે યેતા દેખી.” ");
INSERT INTO gbl_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","છ દિહી પાછે ઈસુ પિત્તર, યાકૂબ એને યોહાનાલ આરે લેયને યોકા ઉચા ડોગાવોય ગીયો યે ઠિકાણે ચ્યાજ યોખલા આતા ચ્યાહા હામ્મે ઈસુવા રુપ બોદલાઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","એને ચ્યા ફાડકે બોજ ઉજળેંફુલ ઓઅઇ ગીયે, તોહડે દોરત્યેવોય કાદોબી ઉજળાવી નાંય હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","તોવે ચ્યા તીન શિષ્યહાય બિજા બેન ભવિષ્યવક્તા મૂસાલ એને એલીયાલ દેખ્યાં એને ચ્યા ઈસુવાઆરે વાતો કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","તોવે પિત્તરાય ઈસુવાલ આખ્યાં, “ઓ ગુરુ આમે રોઅના ઈહીં હારાં હેય: આમા તીની જાઅહાલ તીન માંડવા પાડા દે, યોક તોહાટી, યોક મૂસા હાટી, એને યોક એલીયા હાટી.” ");
INSERT INTO gbl_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ચ્યાય એહેકેન યાહાટી આખ્યાં કાહાકા પિત્તર એને બિજા બેન શિષ્ય બિઇ ગીઅલા આતા, એને નાંય જાઅતા આતા કા કાય આખના હેય, ");
INSERT INTO gbl_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","તોવે યોક વાદળાં યેના એને ચ્યાહાન ચ્યા સાવલ્યેકોય ડાકી લેદા, એને ચ્યાહાય વાદળામાઅને પોરમેહેરાલ બોલતા વોનાયા, “ઓ મા પ્રિય પોહો હેય, ચ્યા આખલા માનજા”. ");
INSERT INTO gbl_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","તોવે તારાતુજ ચ્યાહાય ચોમખી એઅયા, એને ઈસુ યોખલોજ દેખાયો, બિજો કાદોજ નાંય દેખાયો. ");
INSERT INTO gbl_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ઈસુ એને ચ્યા તીન શિષ્ય ડોગાવોયને ઉતતાજ ચ્યાય ચ્યાહાન યોક આગના દેની કા, કાદાલબી ઈ મા આખહા કા તુમહાય કાય એઅયા જાવ લોગુ આંય, માઅહા પોહો મોઅલા માઅને પાછો જીવતો નાંય ઓઅઇ જાવ. ");
INSERT INTO gbl_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ડોગાવોય જીં જાયા ચ્યા બારામાય ચ્યાહાય કાદાલુજ નાંય આખ્યાં, બાકી યે વાતે બારામાય વાત કોઅતા આતા કા, “મોઅલામાયને પાછા જીવી ઉઠના યા કાય મોતલાબ ઓરી?” ");
INSERT INTO gbl_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","એને પાછા શિષ્યહાય ઈસુવાલ પુછ્યાં, “મૂસા નિયમ હિકાડનારા ગુરુ એહેકેન કાહા આખતાહા કા, એલીયાલ ખ્રિસ્તા યેયના પેલ્લા યાં જોજે?”. ");
INSERT INTO gbl_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ઈસુવે શિષ્યહાન આખ્યાં કા, ઈ હાચ્ચાંજ હેય કા પોરમેહેરાય “એલીયાલ દોવાડના વાયદો કોઅલો આતો કા તો બોદા કાય હુદરાવાહાટી પેલ્લો યેય જાય, બાકી માન માઅહા પોહા બારામાય એહેકેન કાહા લોખલાં હેય, કા તો બોજ દુઃખ ઉઠાવી, એને નોકામ્યો ગોણવામાય યી? ");
INSERT INTO gbl_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","બાકી આંય તુલ આખતાહાવ કા એલીયા તે યેય ગીયહો, એને આગેવાનાહાય ચ્યાઆરે બોજ ખારાબ વેવહાર કોઅયો લિખલાં હેય, ચ્યાજ પરમાણે ચ્યાલ ચ્યાહાય ચ્યાહા મોન આખે તેહેંજ કોઅયા.” ");
INSERT INTO gbl_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","જોવે ઈસુ ચ્યા તીન શિષ્ય બિજા શિષ્યહાપાય પાછા યેના, તોવે ચ્યાય બોજ જાંઆહાન ચ્યાહા ચોમખી ઉબા રીઅલા એઅયા, એને ચ્યાહાઆરે મૂસા નિયમ હિકાડનારા ગુરુ બોલા-બોલી કોઅતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","જેહેકોય બોદા લોકહાય ઈસુવાલ દેખ્યા બોદહાન બોજ નોવાય લાગી, એને ચ્યાએછે દાંહાદી જાયને ચ્યાલ સલામ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","એને ઈસુવે ચ્યાહાન પુછ્યાં, “તુમા ચ્યાહાઆરે કોઅહી વાતે બારામાય બોલા-બોલી કોઅતાહા?” ");
INSERT INTO gbl_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ટોળામાઅને યોક માઅહાય એહેકેન જવાબ દેનો કા, “ઓ ગુરુજી, આંય મા પાહાલ લેય યેનહો, જ્યામાય યોક બુત લાગલો હેય, જીં ચ્યાલ બોલાહાટી રોકહે. ");
INSERT INTO gbl_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","જોવેબી બુત ચ્યાવોય હમલો કોઅહે તે તો ચ્યાલ તાંજ આફળી દેહે, એને ચ્યા મુયામાઅને ગોંડો કાડહે, એને ચ્યા દાત કોકડાવેહે, એને કઠાણ બોની જાહાય. માયે તો શિષ્યહાન એહેકેન આખ્યાં કા ચ્યામાઅને બુતાલ કાડી ટાકાં, બાકી ચ્યા ચ્યાલ કાડી નાંય હોક્યા.” ");
INSERT INTO gbl_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ઈ વોનાઈન ઈસુવે જાવાબ દેનો, “ઓ બોરહો નાંય થોવનારા લોકહાય, માન તુમહેહાતે કોલહાલોગુ રા જોજે? એને આંય તુમહે કોલહા વેઠું? ચ્યા પોહાલ માયેપાંય લેય યા.” ");
INSERT INTO gbl_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","“ચ્યા પોહાલ ચ્યા ઈસુવાપાય લેય યેના, એને જોવે બુતે ઈસુલ દેખ્યાં, તોવે બુતે ચ્યા પાહાલ આફળી ટાક્યા એને તો દોરત્યેવોય પોડીન કોથાલતો લાગ્યો તોવે ચ્યા મુયામાઅને ગોંડો નિંગા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ઈસુવે પોહા આબહાલ એહેકેન પુછ્યાં, ઈ બોદા ચ્યાલ કોવેપાયને ઓઅઇ રીયલા હેય?” ચ્યાય આખ્યાં, વાહનેરેજ હેય. ");
INSERT INTO gbl_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","કોલાદા બુતાય ચ્યાલ આગડામાય એને પાઅયામાય પાડ્યા બાકી ચ્યાલ માઆઇ ટાકાંહાટી કોશિશ કોઅયી, બાકી જોવે તું કાય કોઅઇ હોકે, તે આમહે ઉપે દયા કોઓ એને આમહાન મોદાત કોઓ. ");
INSERT INTO gbl_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ઈસુવે પાહા આબહાલ આખ્યાં, “તુમહાન સંદેહ નાંય ઓરા જોજે આંય એહેકેન કોઅઇ હોકતાહાવ જો કાદાં માઅહું માયેવોય બોરહો થોવહે તી બોદાંજ કાય કોઅઇ હોકહે”. ");
INSERT INTO gbl_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","તારાતુજ પાહા આબહે મોઠેથી આખ્યાં, “માન બોરહો હેય, માન સંદેહ નાંય કોઅરાહાટી તું માન મોદાત કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","જોવે ઈસુય દેખ્યાકા, આજુબી બોજ ગીરદી ઓઅઇ રિઅલી હેય, તોવે ચ્યા બુતાલ દોમકાડીન આખ્યાં કા, “ઓ બુત, જીં યા પોહાલ બોઅરો બોનાવી રોયહો એને બોલાહાટી રોકી રોયહો, આંય તુલ એહેકેન આગના કોઅતાહાંવ, કા એલામાઅને નિંગી જો, એને પાછો વોળી યેયના નાંય.” ");
INSERT INTO gbl_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","તોવે બુત બોંબલીન, એને ચ્યાલ બોજ મોહળીન ચ્યામાઅને નિંગી ગીયો, તો પોહો આલ્યોબી નાંય એને તો મોઅલા હારકો પોડી રિયો, એને બોજ માઅહે આખા લાગ્યેં, કા તો મોઅઇ ગીયોહો. ");
INSERT INTO gbl_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","બાકી ઈસુય ચ્યા પાહા આથ દોઓઈન ચ્યાલ ઉબા રાંહાટી મોદાત કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","પાછે, જોવે ઈસુ ચ્યા શિષ્યહાઆરે ગોઅમે યોખલો આતો, તોવે શિષ્યહાય ઈસુલ પુછ્યાં કા, “આમા બુતાલ કાહાનાય કાડી હોક્યા?” ");
INSERT INTO gbl_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","પાછે ઈસુવાય ચ્યાહાન જાવાબ દેનો, “એલા બુત પ્રાર્થના એને ઉપહા કોઅયા વોગાર માઅહા માઅને બાઆ નાંય યેય.” ");
INSERT INTO gbl_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","પાછે ઈસુ એને ચ્યા શિષ્યહાય તો જાગો છોડી દેનો, એને ચ્યા ગાલીલ ભાગામાઅને જાં લાગ્યા, એને ચ્યાલ એહેકેન લાગ્યા કા કાદાલુજ ખોબાર નાંય પોડા જોજે કા આમા ઈહીં હેય, ");
INSERT INTO gbl_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","કાહાકા ઈસુ ચ્યા શિષ્યહાઆરે બોજ સમય વિતાવા એને ચ્યાહાન હિકાડાં માગતો આતો. ચ્યેય ચ્યાહાન આખ્યાં, “વેલ્લાજ કાદો માન, માઅહા પોહાલ, મા દુશ્માનાહા ઓદિકારામાય દેય દી, એને ચ્યા લોક માન માઆઇ ટાકી, બાકી તીજે દિહયે આંય પાછો મોઅલા માઅને જીવતો ઓઅઇ જાહીં.” ");
INSERT INTO gbl_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","બાકી ઈ વાત ચ્યાહાન હોમાજ નાંય પોડી, એને ચ્યા ચ્યાલ પૂછાહાટી બિઈતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","પાછે ઈસુ એને ચ્યા શિષ્ય કાપરનાહુમ ગાવામાય ચ્યાહા ગોઓ ગીયા; જોવે ચ્યા ગોઅમે આતા, ઈસુવે ચ્યાહાન પુછ્યાં કા, “વાટે ચાલતા તુમા કોઅયેહે વાતે બારામાય યોક-બિજા આરે બોલેત?” ");
INSERT INTO gbl_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ચ્યા ઠાવકાજ રિયા કાહાકા વાટે યેતા ચ્યા યોકા-બિજા આરે યા બારામાય બોલા-બોલી કોઅતા આતા, કા આપહે માઅને મોઠો કું હેય? ");
INSERT INTO gbl_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","તોવે ઈસુ બોહી ગીયો, એને ચ્યા બારા શિષ્યહાન પાહાય હાદ્યા, એને એહેકેન આખ્યાં કા, “જો કાદો મોઠો બોના માગહે, તો પોતે બોદહાથી વાહનો બોને એને સેવા કોઅનારો ચાકાર બોના જોજે.” ");
INSERT INTO gbl_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","તોવે ઈસુવે યોકા પાહાલ ચ્યાહા વોચમાય ઉબા રાખ્યાં, તો પાહાલ ગોળે મિળ્યો એને શિષ્યહાન આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“જો કાદોબી મા લીદે એહેકેન યોકા પોહાલ દોયા દેખાડેહે, તો હાચ્ચાંજ મા માની લેહે, જો કાદો મા માની લેહે, તો હાચ્ચાંજ પોરમેહેરાબી માની લેહે જ્યાંય માન દોવાડયોહો.” ");
INSERT INTO gbl_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","તોવે યોહાને ઈસુવાલ આખ્યાં, “ઓ ગુરુ, આમાહાય યોકા માઅહાન તો નાંવા ઓદિકારા ઉપયોગ કોઇન બુતડાહાન કાડતા દેખ્યાં, એને આમા ચ્યાલ ઓટકાડા લાગ્યા, કાહાકા તો શિષ્યહા માઅને નાંય આતો.” ");
INSERT INTO gbl_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ઈસુવે આખ્યાં, “ચ્યાલ ઓટકાડાહા મા,” કાહાકા ઓહડો કાદોબી, જો મા નાંવા ઓદિકારાકોય મોઠે ચિન્હે કોઅહે, તો તારાત મા નિંદા નાંય કોઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","કાહાકા જો આંય દુશ્માન નાંય, તો આપહે આર્યો હેય. ");
INSERT INTO gbl_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","આંય તુમહાન હાચ્ચાંજ આખહુ જો કાદો યોક ગોલાસ પાઆઈ તુમહાન યાહાટી પાજી કા તુમા ખ્રિસ્તા શિષ્ય આખાતાહા, આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા પોરમેહેર નોક્કીજ ચ્યા માઅહાન ઇનામ દેઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","“કાદાહાટીબી, પોતે ગોગ્યેમાય ગોઅટયે પુડ બાંદિન દોરિયામાય બુડવી દેયના ખારાબ સાજા હેય, બાકી જોવે કાદોબી યા વાહનાહામાઅને માયેવોય બોરહો રાખતેહેં, ચ્યાહા પાપ કોઅના કારણ બોને તે ચ્યાલ યા કોઅતીબી ખારાબ સાજા મિળી. ");
INSERT INTO gbl_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","પાપ કોઅના બોદે કારણે બંદ કોઆ ચ્યાલ પુરીરીતે મોનાઈ કોઆ જેહેકોય કા પોતે આથ કાપી રીઅલા હેય, જો તુમહે પાપ કોઅના કારણ બોનહે. જોવે તુમા હોરગામાય જાતહેં, ભલે તુમહેપાય યોક આથ હેય તી હારાં હેય, બાકી તુમહેપાય બેન આથ હેય એને તુમા નરકા કોળીમાય જાહા, તે તી ખારાબ હેય. ");
INSERT INTO gbl_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","નરકા કોળીમાય, બોદહા શરીરાલ ખાનારા કીડા કોવેજ નાંય મોએ એને આગ બોળના બોંદ નાંય ઓએ. ");
INSERT INTO gbl_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","પાપ કોઅના બોદે કારણે બોંદ કોઆ ચ્યાલ પુરીરીતે મોનાઈ કોઆ જેહેકોય કા પોતે પાગ કાપી રીઅલા હેય, તો તુમહે પાપ કોઅના કારણ બોનહે, જોવે તુમા હોરગામાય જાતહેં, ભલે તુમહેપાય યોક પાગ હેય તી હારાં હેય, બાકી તુમહેપાય બેન પાગ હેય એને તુમા નરકા કોળીમાય જાહા, તે તી ખારાબ હેય. ");
INSERT INTO gbl_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","નરકા કોળીમાય, બોદહા શરીરાલ ખાનારા કીડા કોવેજ નાંય મોએ એને આગ બોળના બોંદ નાંય ઓએ. ");
INSERT INTO gbl_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","પાપ કોઅના બોદે કારણે દુઉ કોઆ ચ્યાલ પુરીરીતે મોનાઈ કોઆ જેહેકોય કા પોતે ડોળો બાઆ કાડી દે, જો તુમહે પાપ કોઅના કારણ બોનહે, જોવે તુમા પોરમેહેરા રાજ્યામાય જાતહેં, ભલે તુમહેપાય યોક ડોળો હેય તી હારાં હેય, બાકી તુમહેપાય બેન ડોળા હેય એને તુમા નરકા કોળીમાય જાહા, તે તી ખારાબ હેય. ");
INSERT INTO gbl_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","નરકા કોળીમાય, બોદહા શરીરાલ ખાનારા કીડા કોવેજ નાંય મોએ એને આગ બોળના બોંદ નાંય ઓએ. ");
INSERT INTO gbl_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","કાહાકા બોદહાન આગડાકોય ચોખ્ખેં કોઅવામાય યીઈ, જેહેકોય મીઠાકોય યોક બલિદાન ચોખ્ખાં ઓઅહે. ");
INSERT INTO gbl_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","મીઠાં યોક જરુરી વસ્તુ હેય, જોવે મીઠાં ચોવવોગાર ઓઅઇ જાય, તે તી પાછી કોવેજ ખારાં નાંય બોની હોકે, તુમા યોક-બીજાહાતે ઇળીમીળીન એને યોક બીજાહાતે શાંતીમાય રા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ઈસુવે ચ્યા શિષ્યહાઆરે કાપરનાહુમ શેહેર છોડી દેના, એને ચ્યા યહૂદીયા વિસ્તારામાઅને યારદેન નોયે ચ્યેમેરે ગીયા. એને પાછી યોકદા ચ્યાપાય લોકહા મોઠી ગીરદી ઓઅઇ ગિઇ, એને તો ચ્યાપરમાણે ચ્યાહાન પાછો હિકાડતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","તોવે પોરૂષી લોકહાય ચ્યાપાય યેઇન ચ્યા પરીક્ષા લાંહાટી ચ્યાલ પુછ્યાં, “કાય મૂસા નિયમામાય યોકા માટડાલ ચ્યા થેઅયેલ ફારગાતી દેયના ઈ પરવાનગી હેય કા?” ");
INSERT INTO gbl_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ઈસુવે ચ્યાહાન એહેકેન જાવાબ દેનો, “મૂસાય તુમહાન ફારગાત્યે બારામાય કાય આગના દેનહી?” ");
INSERT INTO gbl_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ચ્યાહાય આખ્યાં, “મૂસાય તે યોકા માટડાલ ચ્યા થેઅયેલ ફારગાત્યે લેખપાત્રી લોખીન થેઅયેલ છોડી દેયના પરવાનગી દેનલી હેય”. ");
INSERT INTO gbl_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ઈસુય ચ્યાહાન આખ્યાં, “મૂસાય ઈ આગના તુમહાન નિયમા રુપામાય દેની, કાહાકા તુમા જિદ્દી આતા. ");
INSERT INTO gbl_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","બાકી શુરવાતમાય જોવે પોરમેહેરાય બોદા કાય બોનાવ્યાં, ચ્યાય માટડો એને થેએ આખીન બોનાડયેલ. ");
INSERT INTO gbl_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ચ્યાહાટી યોક માટડો ચ્યા આયહે આબહાલ છોડીન ચ્યા થેઅયેઆરે રોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","એને ચ્યે બેની જાંએ યોકા શરીરા બોની; યાહાટી કા ચ્યે આમીને બેન માઅહા હારકે નાંય, બાકી ચ્યે યોકાજ માઅહા હારકે હેય. ");
INSERT INTO gbl_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","યાહાટી કા જ્યાલ પોરમેહેરાય યોકઠા જોડલા હેય, ચ્યાલ કાદાબી માઅહું આલાગ નાંય કોઆ જોજે”. ");
INSERT INTO gbl_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","પાછે, જોવે ઈસુ ચ્યા શિષ્યહાઆરે ચ્યે ગોઅમે યોખલો આતો, તોવે શિષ્યહાય ચ્યાલ પાછા ચ્યેજ વાતે બારામાય પુછ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ઈસુવે ચ્યાહાન એહેકેન જાવાબ દેનો, “જો કાદો માટડો ચ્યા થેઅયેલ ફારગાતી દેયન બિજ્યે આરે વોરાડ કોએ તો ચ્યા પેલ્લી થેઅયે વિરુદ વ્યબિચાર કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","એને જીં થેએ ચ્યે માટડાલ ફારગાતી દેયન બીજાઆરે વોરાડ કોએ તે તી વ્યબિચાર કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","પાછે માઅહે પાહાહાન ઈસુપાય લેયા લાગ્યેં, યાહાટી કા તો ચ્યાહાવોય આથ થોવિન ચ્યાહાન બોરકાત દેય, બાકી શિષ્ય માઅહાન દોમકાડે. ");
INSERT INTO gbl_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ઈસુય ઈ એઇન ખિજવાયન આખ્યાં, “પાહાહાન માયેપાંય યાં દા, ચ્યાહાન ઓટકાડાહા મા, કાહાકા ચ્યાજ લોક જ્યા યા પાહાહા હારકા બોરહાલાયક હેય પોરમેહેરા રાજ્યામાય ચ્યાજ રોય. ");
INSERT INTO gbl_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, જ્યેં માઅહે પાહાહા હારકા પોરમેહેરાલ નાંય હોઅપે, ચ્યે પોરમેહેરા રાજ્યામાય ચ્યા માઅહે નાંય બોની.” ");
INSERT INTO gbl_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","તોવે ઈસુ પાહાહાન ગોળે મિળ્યો એને ચ્યાહાવોય આથ થોવિન બોરકાત દેની. ");
INSERT INTO gbl_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","એને જેહોકોય ઈસુ એને ચ્યા શિષ્ય તાંઅરે નિંગા તિયાર ઓઅઇ ગીયા, તોવે યોક માઅહું દાંહદીન ઈસુવાપાય યેના, એને ચ્યા આગલા પાગે પોડીન ચ્યાલ પુછ્યાં કા, “ઓ ગુરુ, કાય કામ કોઉ કા પોરમેહેર માન અનંતજીવન દેય?” ");
INSERT INTO gbl_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ઈસુવાય ચ્યાલ જાવાબ દેનો કા, “તો આખના મોતલાબ કાય હેય કા આંય હારો હેય? પોરમેહેરા સિવાય કાદોજ હારો નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","તું પોરમેહેરા આગનાયો તે જાંઅતોહો કા, ખૂન નાંય કોઅના, વ્યબિચાર નાંય કોઅના, ચોરી નાંય કોઅના, જુઠી સાક્ષી નાંય દેયના, કાદાલ દોગો નાંય દેયના, એને આપહે આયહે આબહા માન રાખના.” ");
INSERT INTO gbl_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","બાકી ચ્યે ઈસુલ એહેકેન આખ્યાં કા, “ઓ ગુરુ, યો બોદ્યો આગના આંય હાનેરેજ માનતો યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ઈસુવાય ચ્યાએછે પ્રેમથી એઅયા એને ચ્યે ચ્યાલ આખ્યાં, “આજુ યોક વાત હેય જીં તુલ કોઅના જરુરી હેય, જો, જીં કાય તોપાય હેય તીં બોદા વેચિન ગોર-ગોરીબાહાન દેય દે, જોવે એહેકેન કોઅહે, તે તોપાય હોરગામાય મિલકાત રોઅરી એને યેયન મા શિષ્ય બોની જો.” ");
INSERT INTO gbl_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","જોવે ચ્યાય ઈસુલ ઈ વાત આખતા વોનાયો તોવે તો નિરાશ ઓઅઇ ગીયો, એને તો દુ:ખી ઓઇન જાતો રિયો, કાહાકા તો બોજ માલદાર આતો. ");
INSERT INTO gbl_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ઈસુવાય ચોમખી એઇન શિષ્યહાન આખ્યાં, “માલદાર માઅહાન પોરમેહેરા રાજ્યામાય જાઅના બોજ કોઠાણ હેય!” ");
INSERT INTO gbl_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","શિષ્યહાન ચ્યા વાત વોનાઈન નોવાય લાગી એને ઈસુવાય પાછા ચ્યાહાન આખ્યાં, “ઓ મા બાહાહાય, જ્યા મિલકાતેવોય બોરહો થોવતાહા, ચ્યાહાહાટી પોરમેહેરા રાજ્યામાય જાયના બોજ કોઠાણ હેય. ");
INSERT INTO gbl_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ઉટડાલ હુવ્યે નાકલામાઅને જાયના કોઠાણ હેય, બાકી માલદાર માઅહાન પોરમેહેરા રાજ્યામાય જાયના બોજ કોઠાણ હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","જોવે શિષ્ય ઈ વાત વોનાયા, ચ્યા આજુ બોજ નોવાય પામી ગીયા, એને યોકા બિજાલ આખતા લાગ્યા કા, “તે પાછે કાહાટી પોરમેહેરા રાજ્યામાય જાંહાટી બોચાવ ઓઅઇ જાયના કેહેકેન સંભવ હેય?” ");
INSERT INTO gbl_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ઈસુય ચ્યાહા એછે એઇન આખ્યાં, “ઈ માઅહાન તે નાંય ઓઅઇ હોકે, બાકી પોરમેહેરાથી ઓઅઇ હોકી; કાહાકા પોરમેહેર બોદાંજ કોઅઇ હોકહે. ");
INSERT INTO gbl_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","પિત્તર ચ્યાલ આખા લાગ્યો, આમે કાય ઓઅરી? આમાહાય તે તો શિષ્ય બોનાહાટી બોદાંજ છોડી દેનલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ઈસુય શિષ્યહાન આખ્યાં, “તુમહાન આંય હાચ્ચાંજ આખતાહાવ, મા શિષ્ય બોનાહાટી એને પોરમેહેરા હારી ખોબાર આખાહાટી, જ્યા કાદાંયબી ચ્યા ગુઉ છોડી દેનલા હેય, એને બાહા બોઅહી એને આયહો એને આબહો એને પાહાહાન કા ચ્યા ખેતાર છોડયા ઓરી, તો હાચ્ચોજ યે પેડ્યેમાય સતાવણી આરે-આરે બોજ વસ્તુ મેળવી, એને યેનારા સમયામાય અનંતજીવન મિળી.” ");
INSERT INTO gbl_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","આમી યા કાળામાય, ચ્યાલ હોવ ગોણા નાંય મિળી, ગોએ એને બાહા એને બોઅયોહો એને આયહો એને પોહેં એને ખેતારાહાલ, બાકી દુખાઆરે એને યેનારા સોમાયામાય અનંતજીવન મેળવી. ");
INSERT INTO gbl_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","બાકી બોજ લોક જ્યેં આમી પેલ્લે હેતેં, ચ્યે પાછલા ઓઅરી; એને જ્યેં આમી પાછલા હેતેં, ચ્યે પેલ્લે ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","એને ઈસુ એને ચ્યા શિષ્ય યેરૂસાલેમ શેહેરા એછે જાનાર્યે વાટયેલ જાય, એને ઈસુ ચ્યાહા આગલા-આગલા જાં આતો: એને શિષ્યહાન બોજ નોવાય લાગી એને જ્યેં ચ્યાહા પાછલા-પાછલા ચાલતે આતેં ચ્યે બિઇ ગીએલે આતેં, તોવે તો ચ્યા બારા શિષ્યહાન લેયને ચ્યાહાન ઈ વાત આખા લાગ્યો જીં ચ્યાવોય યેનારી હેય. ");
INSERT INTO gbl_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“એઆ, આપા યેરૂસાલેમ શેહેરામાય જાતહા તાં, એને માન માઅહા પોહાલ મુખ્ય યાજકાહા એને મૂસા નિયમ હિકાડનારા ગુરુહુ આથામાય દોઅવાય જાયના. ચ્યા માન ગેર યહૂદી લોકહા આથામાય હોઅપી દેઅરી એને ચ્યા માન માઆઇ ટાકરી. ");
INSERT INTO gbl_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ચ્યા લોક મા મશ્કરી કોઅરી, મા ઉપે થૂપી, માન ચાપકાહાકોય માર ઠોકી એને માન માઆઇ ટાકી એને તીજે દિહી પાછો જીવતો ઓઅઇ જાહીં.” ");
INSERT INTO gbl_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","તોવે જબદયા પાહા યાકૂબ એને યોહાન ઈસુવાપાય યેયન એહેકેન આખા લાગ્યા, “ઓ ગુરુ, આમહે માગણી હેય કા, આમા જીં કાય માગજે તીં તું આમેહાટી કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા કાય માગતાહા તીં આંય તુમહેહાટી કોઉ?” ");
INSERT INTO gbl_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","તોવે ચ્યાહાય ઈસુવાલ આખ્યાં, “જોવે તું મહિમામય રાજ્ય કોઅના સુરુ કોઅહે, તે આમહાન તોઆરે રાજ્ય કોઅરા પરવાનગી દેજે, આમે માઅને યોક જાંઆ જમણે આથે એને યોક ડાબે આથે બોહોહું.” ");
INSERT INTO gbl_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા ઈ નાંય જાંએ કા તુમા કાય માગતાહા? કાય તુમા બોગવાં હાટી તિયાર હેય, જેહેકોય આંય બોગાવનારો હેય; મોઅરાંહાટી જેહેકોય આંય મોઅહી?” ");
INSERT INTO gbl_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ચ્યાહાય ઈસુલ આખ્યાં, “આમે કોઅઇ ઓઅઇ હોકી” ઈસુય ચ્યાહાન આખ્યાં, “જેહેકોય આંય બોગવીહીં, તેહેકોયજ તુમા બોગવાહા; તુમા મોઅઇ જાહા, જેહેકોય આંય મોઅઇ જાહીં. ");
INSERT INTO gbl_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","બાકી માન નોક્કી કોઅના ઓદિકાર નાંય હેય કા મા જમણે એને ડાબે આથે, કું તો માનાપાના જાગો મેળવી, પોરમેહેરાય ચ્યા જાગાલ તિયાર કોઅલા હેય, જ્યાહાન ચ્યાય નિવડયાહા ચ્યાહાહાટી.” ");
INSERT INTO gbl_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ઈ વોનાઈન દોહો શિષ્ય યાકૂબ એને યોહાના ઉપે ખિજવાયા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","તોવે ઈસુય ચ્યાહાન પાહી હાદિન આખ્યાં કા, “તુમહાન ખોબાર હેય, કા જ્યા લોક યા દુનિયામાય જ્યા ઓદિકારી ગોણાતાહા, ચ્યા ચ્યાહા ઓદિકારા ઉપયોગ ચ્યાહા તાબામાઅને લોકહાઉપે ઓદિકાર ચાલાડાહાટી કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","બાકી તુમહામાય ઓહડા નાંય હેય, બાકી તુમહેમાય જો કાદો મોઠો બોના માગહે, તો તુમહે ચાકાર બોને. ");
INSERT INTO gbl_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","એને જો કાદો તુમહેમાય પ્રધાન ઓરા માગે, તો બોદહા ચાકાર બોને. ");
INSERT INTO gbl_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","આંય એહેકેન યાહાટી આખહુ કા આંય, માઅહા પોહો, બીજહા સેવા કોઅરાહાટી યા દુનિયામાય યેનો, આંય યાહાટી નાંય યેનો કા બીજે મા સેવા કોએ, આંય બોજ લોકહાન ચ્યાહા પાપાહામાઅને છોડાવાહાટી પોતાનો જીવ દાં યેનો.” ");
INSERT INTO gbl_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","યેરૂસાલેમ જાત્યે સમયે, ઈસુ એને શિષ્ય યેરીખો શેહેરામાય યેના, જેહેકોય ચ્યા એને બિજા લોકહા ટોળા શેહેર છોડી રીઅલા આતા, યોક બારતીમાય નાંવા આંદળો માગનારો વાટે મેરે બોહી રિઅલો આતો, તો તીમાયા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","જોવે તો લોકહાકોય વોનાયોકા ઈસુ જો નાજરેત ગાવા હેય, તો યે વાટે જાય રિઅલો હેય, તોવે આંદળો એહેકેન બોંબાલતો લાગ્યો કા, “ઓ ઈસુ, દાઉદ રાજા કુળા, માયેવોય દયા કોઓ! ");
INSERT INTO gbl_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","બોજ જાંઆ ચ્યાલ દોમકાડા લાગ્યા એને ઠાવકાજ રા આખ્યાં, બાકી તો આજુ મોઠેરે બોંબાલતો લાગ્યો કા, ઓ ઈસુ, દાઉદ રાજા કુળા, માયેવોય દયા કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","જોવે ઈસુ ચ્યા વોનાયો તોવે ઈસુ ઉબો રોય ગીયો એને આજુ બાજુને લોકહાન ચ્યાલ લિયાહાટી આખ્યાં, એને લોકહાય ચ્યા આંદળાલ હાદિન આખ્યાં, “ઈંમાત રાખ, ઉઠ, ઈસુ તુલ હાદહે.” ");
INSERT INTO gbl_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","પાછે આંદળા માઅહાય ચ્યા બાર્યે ફાડકે ટાકી દેયને તારાત ઉઠયો, એને ઈસુ પાહી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","એને ઈસુય ચ્યાલ પુછ્યાં, “તું કાય માગતોહો એને તોહાટી આંય કાય કોઉ?” આંદળાય ચ્યાલ આખ્યાં, “ઓ ગુરુ, ઈંજ કા આંય દેખતો ઓઉં.” ");
INSERT INTO gbl_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","એને ઈસુય ચ્યાલ આખ્યાં, “જો, આંય તો બોચાવ કોઅતાહાંવ કાહાકા તું માયેવોય બોરોહો કોઅતોહો, તે આમી તું તો ગોઅ જાય હોકતોહો” એને તો તારાતુજ દેખતો જાયો, પાછે તો ચ્યા પાહલા વાટ દોઇન ચાલા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","જેહેકોય ઈસુ એને ચ્યા શિષ્ય યેરૂસાલેમ શેહેરા પાહી યેના, તોવે ચ્યા બેતફાગે એને બેથાનીયા બાઆને ગાવહામાય પોઅચ્યા, યે ગાંવે જૈતુન ડોગાપાય આતેં, તોવે ઈસુય ચ્યા શિષ્યહા માઅને બેન શિષ્યહાન એહેકેન આખીન ચ્યા આગલા દોવાડયા કા, ");
INSERT INTO gbl_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“હામ્મેના ગાવામાય જાં, એને તાં જાતાંજ તુમહાન યોક ફુરક્યા વાછડાં હેય ચ્યાવોય આજુ લોગુ કાદોજ નાંય બોઠહો, તી બાંદલા નોજરે પોડી, ચ્યાલ છોડીન માયેપાંય લેય યા. ");
INSERT INTO gbl_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","જોવે કાદા તુમહાન પુછે, ઈ કાય કોઅતાહા, તોવે એહેકેન આખજા, ઈસુ આમે પ્રભુલ યા ઉપયોગ કોઅના ગોરાજ હેય, એને તો ચ્યાલ તારાતુજ લેય દોવાડી.” ");
INSERT INTO gbl_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","શિષ્ય ગાવામાય ગીયા એને ફુરક્યા વાછડાલ હેરીમાય યોકા ગાઆ બાઆપૂરૂજ યોકા ખુટાઆરે બાંદલા મિળ્યાં, એને ચ્યા ચ્યાલ છોડા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ચ્યાહામાઅને તાં ઉબે રીઅલે માઅહાય, ચ્યાહાન એહેકેન આખ્યાં કા, “ઈ તુમા કાય કોઅતાહા, એલા ફુરક્યા વાછડાલ કાહા છોડતાહા?” ");
INSERT INTO gbl_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","શિષ્યહાય ઈસુ આખલ્યે પરમાણેજ જાવાબ દેનો, એને યાહાટી ચ્યા માઅહાય ચ્યાહાન ફુરક્યા વાછડાલ લેય જાં દેના. ");
INSERT INTO gbl_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","એને ચ્યા બેન શિષ્ય ફુરક્યા વાછડાલ ઈસુપાય લેય યેના, એને ચ્યાવોય ચ્યાલ બોહાંહાટી ફુરક્યા વાછડા બોઅડા વોય પોતાને ફાડકે પાથ્યેં એને ઈસુ ચ્યાવોય બોહી ગીયો, એને યેરૂસાલેમ શેહેરા એછે જાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","બોજ લોકહાય ઈસુ હામ્મે વાટેઊપે પોતાના ફાડકે પાથ્યેં, એને બિજા લોકહાય ચ્યાલ માનપાન દાંહાટી વાટેવોય પાલાવાળ્યો ડાહગ્યો પાથ્યો, જ્યો ચ્યા લોક રાનહામાઅને વાડીન લિયેનલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","એને કાંયક લોક ઈસુ આગલા-આગલા ચાલે એને કાંયક પાહલા ચાલે, ચ્યા બોદા ખુશ્યેકોય બોંબલી રીયલા આતા, “હોસાન્ના જો પ્રભુ નાવાકોય યેહે, ચ્યાવોય પોરમેહેરા બોરકાત હેય. ");
INSERT INTO gbl_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","આંય વડીલ દાઉદ રાજા હારકો યોક રાજા પોરમેહેરા બોરકાતે કોઅઇ રાજ્ય કોઅરા યી રીયલો હેય, પોરમેહેરા હોસાન્ના કોઆ જો હોરગામાય રોહે.” ");
INSERT INTO gbl_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","જોવે ઈસુ યેરૂસાલેમ શેહેરામાય ગીયો ચ્યા પાછે, તો દેવાળામાય ગીયો, એને ચ્યાય ચોમખી બોદયે વસ્તુહુલ દિયાન દેયન એઅયા એને પાછે ચ્યાય શેહેર છોડી દેના કાહાકા બોપરેહે પેલ્લાજ વાઆ લાગી ગીઅલી આતી, પાછે તો બાર શિષ્યહાઆરે બેથાનીયા ગાવામાય જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","બીજે દિહે બેથાનીયા ગાવામાઅને નિંગ્યા તોવે ઈસુલ બુખ લાગી. ");
INSERT INTO gbl_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ઈસુવે દુઉરે યોક અંજીરા નીળા જાડ દેખ્યાં, એને ચ્યાવોઅને અંજીર મિળી યાહાટી તો ચ્યા પાહી ગીયો, પાહાય જાયન એઅયા તે ચ્યાલ પાલાંજ દેખાયાં, કાહાકા અંજીર લાગના સમય નાંય આતો. ");
INSERT INTO gbl_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","તોવે ઈસુય ચ્યા જાડાલ આખ્યાં, “આમીને તું પાછી કોવેજ ફળ નાંય દેહે” એને ચ્યા શિષ્ય ઈ વોનાયા કોઅઇ. ");
INSERT INTO gbl_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ચ્યા પાછે, ઈસુ એને ચ્યા શિષ્ય યેરૂસાલેમ શેહેરામાય પોઅચ્યા, એને દેવાળા બાઆપુર ગીયા, ઈસુય ચ્યા લોકહાન તાઅને બાઆ કાડના સુરુ કોઅયા, જ્યા બોલીદાનાહાટી ઉપયોગ ઓઅનારે જોનાવારે એને બાકી વસ્તુ વેચાતાં લાંહાટી એને વેચાંહાટી કામ કોઅઇ રીયલા આતા, ચ્યાય પોયહા બોદાલનારાહા બાકડાહાન ડેકલી દેના, એને ચ્યાય કબુતર વેચનારાહાપાંય જાયને વેચનારાહા ખુરચ્યેહેલ કોથલાડી દેને. ");
INSERT INTO gbl_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","એને ઈસુવે લોકહાન આગના કોઅયી કા ચ્યા દેવાળા આજુ-બાજુને વસ્તુ લેય જાઅના બોંદ કોએ. ");
INSERT INTO gbl_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ચ્યાહાન ઈસુવે હિકાડીન એહેકેન આખ્યાં કા, “કાય પવિત્રશાસ્ત્ર ઈ નાંય આખે, કા મા દેવાળાલ ગેર યહૂદી લોકહાહાટી પ્રાર્થના ગુઉ આખલા જાય? બાકી તુમાહાય તીં બાંડાહા ગુઉ બોનાવી રાખ્યહાં.” ");
INSERT INTO gbl_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","જોવે મુખ્ય યાજક એને મૂસા નિયમ હિકાડનારા ગુરુવાહાય, ઈસુવે જીં આખ્યાં એને કોઅયા ચ્યા બારામાય વોનાયા, તોવે ચ્યા ચ્યાલ માઆઇ ટાકના આવાડ હોદતા લાગ્યા. બાકી ચ્યા ચ્યાથી બિઅતા આતા, કાહાકા લોકહા ટોળો ચ્યા હિકાડનાથી પૂર્યે રીત્યેકોય નોવાય પામલા. ");
INSERT INTO gbl_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","જોવે વેળ પોડી ગિઇ, તોવે ઈસુ એને ચ્યા શિષ્ય શેહેર છોડીન બેથાનીયા ગાવા એછે જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","આગલે દિહી હાકાળેહે, જોવે ઈસુ એને ચ્યા શિષ્ય પાછા યેરૂસાલેમ શેહેરા એછે જાં આતા, તોવે ચ્યાહાય તી અંજીરા જાડ પાછી દેખ્યા, તી મુળાહા લોગુ ઉખાઈ ગીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","પિત્તરાલ તી વાત યાદ યેની એને ચ્યે ઈસુલ આખ્યાં, “ઓ ગુરુ એએ, ઈ તી અંજીરા જાડ તુયે હારાપ દેનલા તી જાડ ઉખાય ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ઈસુય ચ્યાલ જાવાબ દેનો, “પોરમેહેરા ઉપે બોરહો રાખા કા જીં તુમાહાય માગલા હેય પોરમેહેર તી કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, જો કાદો એલા ડોગાલ એહેકેન આખે કા, ઉઠ એને દોરિયામાય જાય પોડ, એને મોનામાય શંકા નાંય રાખે તોવે, બાકી બોરહો કોએ કા જીં ચ્યાય માગલા હેય પોરમેહેર ચ્યાલ કોઅરી, તોવે પોરમેહેર ચ્યાહાટી ઈ કોઅઇ દી. ");
INSERT INTO gbl_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ચ્યાહાટી તુમહાન આંય આખતાહાવ કા, જીં કાય તુમા પ્રાર્થનામાય માગતાહા, ઓહડો બોરહો રાખા કા તી તુમહાન મિળી જાય, તોવે પોરમેહેર ચ્યાહાટી ઈ કોઅઇ દી. ");
INSERT INTO gbl_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","એહેકેન જોવે તુમા ઉબા રોઇન પ્રાર્થના કોઅતાહા, તોવે પેલ્લા ચ્યાહાન માફ કોઅરા જ્યાંય તુમહે વિરુદમાય બુલ કોઅયી ઓરી. યાહાટી કા તુમહે પોરમેહેર જો હોરગામાય રોહે તેરુંબી તુમહાન તુમહે પાપ માફ કોઅય. ");
INSERT INTO gbl_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","બાકી જોવે તુમા માફ નાંય કોએત તે તુમહે પોરમેહેર આબહો, જો હોરગામાય હેય તો તુમહે બુલબી માફ નાંય કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ઈસુ એને ચ્યા શિષ્ય પાછા યેરૂસાલેમ શેહેરામાય યેય ફૂગ્યા, એને જોવે તો દેવાળામાય ફિરે તોવે મુખ્ય યાજક, મૂસા નિયમ હિકાડનારા ગુરુ એને આગેવાન ચ્યા ચ્યાપાય યેયન પુછા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","“તુલ યે કામે કોઆહાટી તોપાય કાય ઓદિકાર હેય? કુંયે તુલ ઓહડા ઓદિકારાહાતે દોવાડયોહો?” ");
INSERT INTO gbl_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","તોવે ઈસુય ચ્યાહાન આખ્યાં, “આંયબી તુમહાન યોક સાવાલ પૂછતાહાવ, જોવે ચ્યા તુમા માન જાવાબ દાહા, પાછે આંય કા ઓદિકારાકોય કામ કોઅતાહાંવ તીં તુમહાન આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","જોવે યોહાનાય લોકહાન બાપતિસ્મા દેના, તે કાય ચ્યા ઓદિકાર હોરગામાઅને પોરમેહેરા એછને કા માઅહા એછને? માન આખા.” ");
INSERT INTO gbl_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","તોવે ચ્યા જાતેજ વિચાર કોઆ લાગ્યા કા હોરગામાઅને આખહુ તોવે, તો આમહાન આખરી કા, તોવે તુમાહાય ચ્યાવોય કાહાનાય બોરહો થોવ્યો? ");
INSERT INTO gbl_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","એને જોવે આમા માઅહા એછને તોવે કાય ઓઅઇ? ચ્યા યા હારકો જાવાબ નાંય દેય કાહાકા ચ્યા લોકહાથી બિઅતા આતા, જ્યા ઈ માનતા આતા કા, યોહાન પોરમેહેરા પાયને યોક હાચ્ચો ભવિષ્યવક્તા આતો. ");
INSERT INTO gbl_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","એને ચ્યાહાય ઈસુવાલ જાવાબ દેનો કા, “આમા નાંય જાંઆજે કા યોહાનાલ લોકહાન બાપતિસ્મા દાંહાટી કુંયે દોવાડયેલ” તોવે ઈસુય ચ્યાહાન આખ્યાં, તે “આંયબી તુમહાન નાંય જાવાબ દાંઉ કા, ઈ કામ આંય કોઅહા ઓદિકારાકોય કોઅહુ.” ");
INSERT INTO gbl_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","પાછો, ઈસુ બિજા દાખલા દેયન યહૂદીયાહા આગેવાનાહાઆરે વાત કોઆ સુરુ કોઅયા, “યોક માઅહાય ચ્યા રાનામાય દારાખા વાડી લાવી, ચ્યાય રાના ચોમખી દોગડાહા યોક બીતડા બોનાવ્યાં, એને દારાખા રોહયા યોકઠો કોઅરાહાટી ખાડો ખોદયો, ચ્યાય બાંડાહા એને જોનાવરહા ઇહિને રાના હાંબાળ કોઅરાહાટી યોક માળો પાડ્યો, પાછે ચ્યાય ચ્યા રાનાલ કોલહાક ખેડુતાહાન બાગે દેય દેના એને બિજા દેશા એછે લાંબી મુસાફીર્યેલ નિંગી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","જોવે દારાખેં પાકી ગીયે, તે ચ્યા ચાકારાહામાઅને યોકાલ બાગ્યા ખેડુતાપાય દોવાડયો, કા ચ્યા દારાખાહા વાડયેમાઅને ચ્યા ભાગ લી યેય. ");
INSERT INTO gbl_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","બાકી ખેડુતાહાય ચ્યાલ દોઇન માર દેનો, એને ચ્યાલ કાયજ નાંય દેના એને પાછો દોવાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","પાછો વાડયે માલિકાય યોકબીજા ચાકરાલ ખેડુતાહાપાય દોવાડયો, એને ચ્યાહાય ચ્યા ટોલપા ફોડી ટાક્યા એને ચ્યાઆરે જુઠા કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","પાછો વાડયે માલિકાય બિજા ચાકરાલ દોવાડયો, ચ્યાલ ચ્યાહાય માઆઇ ટાક્યો પાછો ચ્યે બોજ જાંણહાન દોવાડયા, ચ્યાહામાઅને બાકહ્યાન ઠોક્યાં, એને બાકી જાંઆહાન માઆઇ ટાકવામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","આમી, વાડયે માલિકાપાય દોવાડાહાટી કેવળ યોકુજ માઅહું આતા, તો ચ્યા પોતે વાહલો પોહો આતો સેવાટ ચ્યે ચ્યા પાહાલ દોવાડયો કાહાકા, ચ્યે એહેકેન જાંઅયા કા, મા પોહા ચ્યા દાક રાખી. ");
INSERT INTO gbl_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","બાકી જોવે ખેડુતાહાય ચ્યા પાહાલ યેતા દેખ્યા, તે ચ્યાહાય યોક બીજહાન આખ્યાં, ‘એલો તે વારસદાર હેય; ચાલા, એલાલ આપા માઆઇ ટાકતા, તોવે વારસો આપહે ઓઅઇ જાઅરી.’ ");
INSERT INTO gbl_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","એને ખેડુતાહાય ચ્યાલ દોઇન માઆઇ ટાક્યો, એને ચ્યા કુડી દારાખાહા વાડયે બાઆ ટાકી દેની.” ");
INSERT INTO gbl_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","“તુમહાન કાય લાગહે કા દારાખાહા વાડયે દોનારો કાય કોઅરી? તો યેયન ચ્યા ખેડુતાહાન માઆઇ ટાકી, એને દારાખાહા વાડી બીજહાન દેય દી. ");
INSERT INTO gbl_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","કાય તુમાહાય પવિત્રશાસ્ત્રા માઅને લોખલાં નાંય વાચ્યાહાં કા જ્યા ખ્રિસ્તા બરાબરી યોકા મહત્વા દોગડા હાતે કોઅહે? તો આખહે જ્યા દોગડાલ કોડયાહાય ટાકી દેનેલ, ઓ તોજ દોગાડ હેય જો ગોઆ મુખ્ય દોગાડ બોની ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ઈ પોરમેહેરાય એહેકેન કોઅયા, એને ઈ આમહેહાટી બોજ નોવાય હેય ઈસુલ દોઇન કોંડી દા માગતા આતા.” ");
INSERT INTO gbl_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","યહૂદી આગેવાન ચ્યાલ દોઈ દા માગેત, કાહાકા ચ્યા હુમજી ગીઅલા કા, ચ્યાય આમે વિરુદમાય ઓ દાખલો આખ્યોહો ચ્યા ઈસુવાલ દોઅરાં આતા બાકી ચ્યાહાન લોકહા બિક આતી, યાહાટી ચ્યા ચ્યાલ યોખલો છોડીન જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","પાછે ઈસુલ કાય આખવાકોય ફસાવના કોશિશ કોઅરાહાટી જ્યા આધારે ચ્યાલ દોઇન કોંડી દેવાય યાહાટી કોલહાક પોરૂષી લોક એને રાજા હેરોદ લોકહા ટોળાલ ચ્યાહાપાય દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ચ્યાહાય યેયન ઈસુલ આખ્યાં, “ઓ ગુરુ, આમા જાંઅજેહે કા, તું સાદા હાચ્ચાં આખતોહો એને તું યા બારામાય ચિંતા નાંય કોએ કા લોક તો બારામાય કાય વિચાર કોઅતાહા, કાહાકા તું બોદહાઆરે હારકો વેવાહાર કોઅતોહો, બાકી પોરમેહેરા વાટ હાચ્ચાયે પરમાણે હિકાડતોહો તે પાછે આમી આમહાન આખ, કાય કૈસરાલ કર દેઅના આમે નિયમા વિરુદ હેય? ");
INSERT INTO gbl_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","કાય આમાહાય કર દાં જોજે, કા આમાહાય કર નાંય દાં જોજે?” ચ્યાય ચ્યાહા ડોંગ જાઇન આખ્યાં, તુમા માન જુઠા આખવા કોઅઇ ફસવા કોશિશ કાહા કોઅઇ રીઅલા હેય? માન યોક દીનારા સિક્કો (૧ દીનાર એટલે યોકા દિહા કાંબારાં ઓઅહે) આંઆઈ દિયા, માન એરા દિયા. ");
INSERT INTO gbl_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ચ્યા લેય યેના, એને ઈસુય ચ્યાહાન આખ્યાં, “માન આખા યા ચાંદ્યે સિક્કા ઉપે કા ચિત્રા એને કા નાંવ હેય? યાવોય કા છાપ એને કા નાંવ હેય?” ચ્યાહાય આખ્યાં, “કૈસરા હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ઈસુવે ચ્યાહાન આખ્યાં, “જીં કૈસરા હેય, તી કૈસરાલ દેય દિયા, એને જીં પોરમેહેરા હેય તી પોરમેહેરાલ દેય દિયા” એને તોવે ચ્યાહાન બોજ નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","તોવે સાદૂકી ટોળા કોલહાક લોક ઈસુવાપાય યેના, સાદૂકી ટોળો ઈ નાંય માનેત કા મોઅલા માઅને પાછા જીવતા નાંય ઓઅઇ હોકે, ચ્યા ઈસુવા પાહી યેના એને ચ્યાલ પુછ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ઓ ગુરુ, મૂસાય શાસ્ત્રામાય આમહે કોરે યોક નિયમ લોખલો આતો કા, જોવે યોકતા વોરાડ ઓઅલો માટડો મોઅઇ જાય, એને તો વોગાર પાહાહા થેએયેલ છોડી જાહે, તોવે ચ્યા માટડા બાહા વિધવાયે આરે વોરાડ કોઅઇ લા જોજે એને યોક પોહા પૈદા કોઅરા જોજે જો ચ્યા બાહા વારસદાર બોને. ");
INSERT INTO gbl_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","યોકા કુટુંબમાય હાંત બાહા આતા, બોદહા મોઠા બાહાય વોરાડ કોઅઇ લેદા બાકી વોગાર પાહાહા તો મોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","તોવે બિજા બાહે ચ્યે વિધવાયેલ રાખી લેદી, બાકી તો હોગો વોગાર પાહાહા મોઅઇ ગીયો, એને તીજ વાત તીજા બાહા આરે જાઈ. ");
INSERT INTO gbl_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","એને ઈ વાત બોદા હાંતી બાહાહા આરે જાઈ, ચ્યે થેઅયેય ચ્યાહામાઅને કાદાહાટીબી યોક પાહાલ જન્મો નાંય દેનો, છેલ્લે, તી થેએબી મોઅઇ ગિઇ.” ");
INSERT INTO gbl_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","એને આમી આમહાન આખ, “આમી યે થેએયે વોરાડ હાંત માટડાઆરે ઓઅયા, તે જોવે મોઅલા માઅને પાછા જીવતા ઓઅઇ, તોવે તી કા થેએ રોય? કાહાકા તી હાંતહ્યા થેએ આતી.” ");
INSERT INTO gbl_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા બુલમાય પોડયાહા કાહાકા તુમા નાંય જાંએતકા પવિત્રશાસ્ત્ર કાય આખહે, એને તુમા પોરમેહેરા સામર્થ્યા બારામાય નાંય જાંએત. ");
INSERT INTO gbl_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","કાહાકા જોવે મોઅલા માઅને જીવી ઉઠી, તોવે તે નાંય માટડા એને નાંય થેઅયો વોરાડ કોઅરી, બાકી હોરગામાય રોનારા હોરગા દૂતહા હારકે રોય. ");
INSERT INTO gbl_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","એને મોઅલા જીવતા ઉઠી ચ્યા બારામાય તુમાહાય મૂસા ચોપડયેમાય નાંય વાચ્યાહાં કા બોળત્યે જાડયેમાય કાય જાયા, પોરમેહેરાય મૂસાલ આખ્યાં, આંય તો ડાયહા આબ્રાહામા, ઈસાકા, એને યાકૂબા પોરમેહેર આમીબી હેતાઉ,? ");
INSERT INTO gbl_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","યાહાટી તો મોઅલાહા પોરમેહેર નાંય હેય બાકી જીવતાહા પોરમેહેર હેય, તુમા બોજ બુલમાય પોડયાહા.” ");
INSERT INTO gbl_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","મૂસા નિયમ હિકાડનારા ગુરુહુ માઅને યોકેજાઆ યેયન વોનાયો, કા ઈસુ એને સાદૂકી ચ્યાહામાય ચર્ચા કોઅઇ રીઅલા આતા, એને ઈ દેખીન ચ્યાય ચ્યાહાન હાચ્ચો જાવાબ દેનો, ચ્યે ઈસુલ પુછ્યાં, “પોરમેહેરાય જોલ્યો આગના દેનહ્યો, ચ્યાહામાઅને બોદયેહેમાય મહત્વા આગના કોઅહી?” ");
INSERT INTO gbl_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ઈસુવે ચ્યાલ જાવાબ દેનો, “બોદી આગનાહા માઅને મહત્વા ઈંજ હેય કા: ‘ઓ ઈસરાયેલા લોક વોનાયા, પ્રભુ આપહે પોરમેહેર યોકુજ પ્રભુ હેય. ");
INSERT INTO gbl_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","તું આપહે પ્રભુ પોરમેહેરાવોય તો બોદા રુદાયા કોયન, એને જીવા કોઇન, એને બોદા મોના કોઇન, એને આખી ગોત્યે કોઇન પ્રેમ રાખજે’ ");
INSERT INTO gbl_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","એને બીજી બોદહા કોઅતી મહત્વા આગના ઈ હેય, ‘તું પોતાવોય જોહોડો પ્રેમ રાખતોહો, તોહોડોજ પ્રેમ બીજહાવોયબી રાખ’ પોરમેહેરાય યે બેન આગનાયેહે કોઅતી મહત્વા બીજી આગના નાંય દેનહી.” ");
INSERT INTO gbl_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","તોવે મૂસા નિયમ હિકાડનારા ગુરુવાહાય ચ્યાલ આખ્યાં, “ઓ ગુરુ, બોજ હારાં, તુયે હાચ્ચી વાત આખી કા તો પોરમેહેરુજ યોકુજ પોરમેહેર હેય, એને ચ્યા સિવાય બિજો કાદો પોરમેહેર નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","એને ચ્યાલ બોદા રુદાયા કોઇન, એને બોદે મોના કોઅઈન, બોદા જીવા કોઇન, એને બોદયે ગોત્યે કોઇન પ્રેમ રાખના, એને પોતાવોય જેહે પ્રેમ કોઅતાહા તેહેકોય બીજહાવોય પ્રેમ રાખના, એને બોદા જોનાવરહા બલિદાનહા એને બિજા બલિદાનહા જ્યેં આપા પોરમેહેરા વેદ્યેવોય ચોડાવજેહે ચ્યાહા કોઅતા હારાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","જોવે ઈસુવે એઅયા કા ચ્યે હારાં હોમજીન જાવાબ દેનો, ઈસુય ચ્યાલ આખ્યાં, “તું પોરમેહેરા રાજ્યામાય જાઅનાથી દુઉ નાંય હેતો” એને પાછે ચ્યાલ સાવાલ પૂછના કાદા ઈંમાત નાંય ચાલી. ");
INSERT INTO gbl_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","પાછે ઈસુવે દેવાળામાય હિકાડતા એહેકેન આખ્યાં કા, મૂસા નિયમ હિકાડનારા ગુરુ એહેકેન કાહા આખતાહા કા ખ્રિસ્ત દાઉદ રાજા કુળા ઓઅરી? ");
INSERT INTO gbl_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","કાહાકા બોજ પેલ્લા જોવે દાઉદ રાજા પવિત્ર આત્મા અગુવાઈ કોઇન, ચ્યાય આખ્યાં, “પ્રભુ પોરમેહેરાય મા પ્રભુવાલ આખ્યાં તું મા જમણે આથે બોહો, જાવ લોગુ આંય તો દુશ્માનાહાન આરવી નાંય દાંઉ તાંઉલોગુ.” ");
INSERT INTO gbl_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","જોવે દાઉદ રાજા પોતેજ ચ્યાલ પ્રભુ આખહે, પાછે તો ચ્યા કુળા કેહેકેન ઓઅહે? એને લોકહા ટોળો ચ્યા ખુશ્યેકોય વોનાત. ");
INSERT INTO gbl_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ઈસુવે હીકાડતામાય ચ્યાહાન આખ્યાં, મૂસા નિયમ હિકાડનારા ગુરુપાયને હાચવીન રોજા, જ્યા યે વાતેલ પોસાન કોઅતાહા કા સાર્વજનિક ઠિકાણા વોય લોક ચ્યાહાન લાંબા એને મોઅગેં ડોગલેં પોવીન ફીઅતા એએ, એને આટામાય લોક ચ્યાહાન માનેપાને કોઅઇ સલામ કોએ. ");
INSERT INTO gbl_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","એને સોબાયે ઠિકાણાહામાય માનાપાના જાગાવોય-સીટેવોય બોહના પોસાન કોઅતાહા, એને જેવણામાય માનાપાના જાગો-સીટ ચ્યાહાન ગોમહે. ");
INSERT INTO gbl_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ચ્યા વિઘવા બાયહે ગોએ લુટી લેતહા, એને બીજહાન દેખાડાહાટી લાંબી વાઆ પ્રાર્થના કોઅતાહા, પોરમેહેર હાચ્ચોજ ચ્યાહાન કોઠાણ સાજા દી. ");
INSERT INTO gbl_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","તો દેવાળા દાનપેટી હામ્મે બોહીન એએયા કોએ કા ચ્યે માઅહે દેવાળા તીજોર્યેમાય કેહેકેન પોયહા ટાકેત; એને બોજ મિલકાતવાળા લોકહાય બોજ પોયહા ટાક્યા. ");
INSERT INTO gbl_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","એને ચ્યેજ વેળાયે યોક ગોરીબ વિધવા બાયે યેયન બેન દોમડયો, જ્યો બેન સિક્કા હેય, (૨ વાહના તાંબા સિક્કા જ્યાહા બોજ વોછી કિંમાત હેય) ચ્યા ટાક્યા. ");
INSERT INTO gbl_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","તોવે ચ્યે ચ્યા શિષ્યહાન પાહાય હાદિન આખ્યાં કા, “આંય તુમહાન હાચ્ચી વાત આખતાહાવ કા દેવાળા તીજોર્યેમાય ટાકનારાહા માઅને ચ્યે ગોરીબ વિધવા બાયે બિજા બોદહા કોઅતા વોદારે ટાક્યા; ");
INSERT INTO gbl_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","જ્યા મિલકાતવાળા હેય ચ્યાહાય તે ચ્યામાઅને જીં કાય દેનલા હેય જ્યાલ ચ્યાહાન જરુરી નાંય આતા, બાકી ઈ વિધવા ગોરીબ હેય એને યેય જીં બોદા કાય દેના જીં ચ્યેપાય આતા, ચ્યા બોદા પોયહા ટાકી દેના જ્યાહાલ તી પોતે જરૂર્યે હાટી ઉપયોગ કોઅઇ હોકતી.” ");
INSERT INTO gbl_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ઈસુ દેવાળામાઅને નિંગતાંજ, ચ્યા શિષ્યહા માઅને યોકેજાએ ચ્યાલ આખ્યાં, “ઓ ગુરુ, કાય બારી બોંગલેં હેય! ચ્યા કોઅહા મોઠા દોગાડાકોય બોનલે હેય!” ");
INSERT INTO gbl_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ઈસુવે ચ્યાહાલ આખ્યાં, “તુમા યે મોઠે બોંગલેં જ્યેં આમી એઅતાહા, બાકી, આંય તુમહાન આખહુ, દુશ્માન યોકબી દોગાડ પોતે જાગાવોય નાંય છોડી, ચ્યા બોદા નાશ કોઅઇ દી.” ");
INSERT INTO gbl_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","તોવે ઈસુ દેવાળા હામ્મે જૈતુના ડોગાવોય જાતો રિયો, એને ઉતરાત્યેવોય બોહી ગીયો, તે પિત્તર, યાકૂબ, યોહાન, એને આંદ્રિયાસ ચ્યાહાય ચ્યા યોખલાલ આલાગ જાયને પુછ્યાં, ");
INSERT INTO gbl_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“આમહાન આખ કા યો વાતો કોવે ઓઅરી? એને જોવે ઈ બોદા ઓઅઇ જાઈ ચ્યે વેળાયે કાય નિશાણી ઓઅઇ?” ");
INSERT INTO gbl_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ઈસુવે ચ્યાહાન આખ્યાં, “હાચવીન રોજા કા તુમહાન કાદો નાંય છેતરે. ");
INSERT INTO gbl_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","બોજ લોક મા નાંવા કોઇન યી, ચ્યે આખી, આંય ખ્રિસ્ત હેતાઉ, એને બોજ લોકહાન ચ્યાહા માનાડાંહાટી છેતરી. ");
INSERT INTO gbl_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","બાકી જોવે તુમા લોડાઈ, એને લોડાયેહે વાતો વોનાયાહા, તોવે મા ગાબરાયાહા, કાહાકા ઈ ઓઅનારાંજ હેય, બાકી દુનિયા છેવાટ તારાત નાંય ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","યોક જાતી લોક બિજ્યે બોદયે જાત્યે લોકહાવોય હમલો કોઅરી એને યોક દેશા લોક બિજા દેશા લોકહા વિરુદ લોડી, બોદેજ દોરતીકંપ ઓઅરી, એને કાળ પોડી એને ઈ દુઃખ પાહાહા જન્મા પેલ્લા ઓઅનારી પીડાયે હારકા હેય. ");
INSERT INTO gbl_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","“બાકી તુમા પોતેજ હાચવીન રા, કાહાકા લોક તુમહાન કોચર્યેમાય લેય જાય એને સોબાયે ઠિકાણામાય માર દી, કાહાકા તુમા મા શિષ્ય હેય, એને તુમહાન મા લીદે સરકારા, એને રાજહા આગલા ઉબા કોઅરી કા તુમહે ન્યાય કોએ. બાકી ચ્યા પરિણામ, તુમા ચ્યાહાન મા બારામાય હારી ખોબાર આખી હોકાહા. ");
INSERT INTO gbl_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","બાકી એહેકેન હેય કા દુનિયા છેવાટ ઓઅરા પેલ્લા તે બિજ્યે બોદયે જાત્યે લોકહાન હારી ખોબારે વાત આખાય જાં જોજે. ");
INSERT INTO gbl_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","જોવે તુમહાન દોઓઈ લેઅરી એને કોચર્યેમાય લેય જાઅરી, તોવે પેલ્લા કાય આખના ચ્યા ચિંતા તુમા મા કોઅહા, બાકી જીં કાય ચ્યે વેળાયે પોરમેહેર તુમહાન આખાડી, તીંજ આખના, કાહાકા તુમા તોજ શબ્દ બોલહા, જો પવિત્ર આત્મા તુમહાન દી, શબ્દ તુમહેમાઅને નાંય યી. ");
INSERT INTO gbl_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ચ્યે સમયે, જ્યા લોક માયેવોય બોરહો નાંય કોએત, ચ્યા ચ્યાહા બાહાહાલ દોઇન કોંડાડી દી, જ્યા માયેવોય બોરહો કોઅતાહા ચ્યાહાન માઆઇ ટાકી. આબહો પોતે પાહાહા આરે એહેકેન કોઅરી એને પોહેં પોતે આયહે આબહા વિરુદ કોઅરી એને ચ્યાહાન માઆઇ ટાકી.” ");
INSERT INTO gbl_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","કાહાકા તુમા મા શિષ્ય હેય યા લેદે, બોદે માઅહે તુમહેઆરે દુશ્માની કોઅરી, બાકી જ્યા લોક માયેવોય બોરહો કોઅનામાય લાગી રોય, એને દોરત્યેવોય ચ્યા જીવના છેલ્લે હુદી મા પાહલા ચાલતો રોય, ચ્યાલ પાપહા ડોંડ બોગાવનાથી બોચાવ ઓઅઇ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","યોક દિહી તુમા ખારાબ વાના દેખહા જ્યા લેદે દેવાળાલ છોડી દેવામાય યી, તો ચ્યા જાગાવોય ઉબો રોય, જાં ચ્યાલ ઉબો રોઅના કાયજ ઓદિકાર નાંય હેય. જો કાદો વાચહે તો યાલ હોમજાંહાટી કોશિશ કોએ જોવે તો સમય યી, જ્યા લોક યહૂદીયા વિસ્તારામાય હેય ચ્યાહાન બોચાંહાટી ડોગહાવોય નાહી જાં પોડી. ");
INSERT INTO gbl_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","જો ગોઆ ઉપે ચોડયો ઓરી, તો કાયબી લાંહાટી પાછા નિચે ગોઆમાય નાંય ઉરાય, તુમહાન નાહી જાં પોડી. ");
INSERT INTO gbl_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","એને જો રાનામાય ગીયો ઓરી તો, ડોગલાં લાંહાટી પાછો ગોઓ નાંય વોળી યેય. ");
INSERT INTO gbl_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ઈ ચ્યે બાયહેહાટી યોક નોવાય લાગે ઓહડો સમય ઓઅરી જ્યો મોયનાવાળ્યો હેય, એને ચ્યો બાયો જ્યો પાહાહાન દુદ પાજી રિઅલ્યો હેય, ચ્યેહેલ નાહરાં બોજ કોઠાણ પોડી. ");
INSERT INTO gbl_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","19","ચ્યા દિહહામાય લોક બોજ ગંભીર રીતે પીડિત ઓઅરી, લોકહાય કોદહી ઓહડો સામનો નાંય કોઅલો હેય જોવે પોરમેહેરે પેલ્લા દુનિયા બોનાવલા આતા, લોક પાછા એહેકેન પીડિત નાંય ઓઅરી, યાહાટી પ્રાર્થના કોઅતા રા કા ઈ બોદા હીયાળામાય નાંય બોને, જોવે મુસાફીર કોઅરા કોઠાણ પોડે. ");
INSERT INTO gbl_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","પોરમેહેરાય ચ્યા દુ:ખા દિહી ઓછા કોઅઇ દેઅના નિર્ણય લેદલો હેય, નેતે, કાદાબી જીવા બોચાવ નાંય ઓઅતો, બાકી ચ્યા દિહાહા આકડો વોછો કોઅઇ દેઅરી, ચ્યા નિવાડલાહા મોદાતેહાટી. ");
INSERT INTO gbl_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ચ્યે સમયે તુમહાન યોકતા એહેકેન આખે કા, એઆ, ખ્રિસ્ત ઈહીં હેય, કા એઆ તાં હેય, તોવે તુમા બોરહો મા થોવતા, ");
INSERT INTO gbl_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","કાહાકા જુઠા ખ્રિસ્ત્યા એને જુઠા ભવિષ્યવક્તા યી, એને ઓહડે મોઠે ચમત્કારા, એને ખોટેં કામે કોઅનારા બોની, કા ચ્યા લોકહાન દોગો દાંહાટી જ્યાહાલ પોરમેહેરાય નિવડી લેદલા હેય. ");
INSERT INTO gbl_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","બાકી તુમા હાચવીન રોજા, કાહાકા તુમહાન માયે પેલ્લાજ બોદા આખી દેનહા. ");
INSERT INTO gbl_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ચ્યા દિહીહામાય, બોજ પીડા સમય બોંદ ઓઅરા પાછે, દિહી એને ચાંદ ઉજવાડો દેઅના બોંદ કોઅઇ દી. ");
INSERT INTO gbl_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","એને આકાશામાઅને ચાંદાલેં ટુટી પોડી, એને આકાશામાઅને પરાક્રમ આલી જાય. ");
INSERT INTO gbl_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ચ્યે સમયે લોક માન દેખી, માઅહા પોહો દોરતી એછે વાદળામાય યી રીયલો હેય, ચ્યે મા સામર્થ એને મહિમા એઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ચ્યે સમયે તો પોતાના હોરગા દૂતહાન દોવાડીન, બોદયે આકાશથી, એને દોરત્યે ચારી છેડાપાયને, ચારી ચોમખીને મા નિવાડલા લોકહાન બેગા કોઅહી.” ");
INSERT INTO gbl_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“અંજીરા જાડવાથી ઓ દાખલો હિકાં, જોવે ચ્યા કોવળ્યો ડાળખ્યો ફૂટત્યોહો એને ડાહાગ્યો પીલવાત્યો લાગે, તોવે તુમહાન ખોબાર પોડહે કા ચોમહા સમય પાહાય યેય ગીયહો. ");
INSERT INTO gbl_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","તેહેંજ કોઇન, જોવે ઈ બોદા તુમહાન બોનતાં દેખાય, તોવે તુમહાન ખોબાર પોડી જાં જોજે કા દુનિયા છેલ્લો સમય યેય ગીયહો એને તો દુઉ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","આંય તુમહાન હાચ્ચાં આખતાહાવ, કા ઈ બોદા યે પેડયે લોક તોવેબી જીવતા રોય જોવે ઓહડા બોનાવ બોની. ");
INSERT INTO gbl_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","આકાશ એને દોરતી નાશ ઓઅઇ જાય, સાદામાટે નાંય રોય, બાકી માયે જીં આખ્યાહા તી સાદામાટે હાચ્ચાં રોય.” ");
INSERT INTO gbl_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","“યો વાતો કોઅયેહે ગેડયે એને કોઅહે દિહયે ઓઅરી કાદાજ નાંય જાંએ, નાંય હોરગા દૂત જાંએ, નાંય પોરમેહેરા પોહો જાંએ, બાકી આબહો ઓ દિહી એને ઈ ગેડી જાંએ. ");
INSERT INTO gbl_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","એઆ, જાગતા રોજા એને પ્રાર્થના કોઅતા રોજા, કાહાકા તુમહાન નાંય ખોબાર હેય કા તો દિહી કોવે યી. ");
INSERT INTO gbl_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","મા પાછા ફિરીન યેઅના, ચ્યા માઅહા હારકા હેય, જીં માઅહું પારદેશ જાત્યે વેળાયે ચ્યા ગુઉ ચાકારાહા આથે છોડીન જાહાય, એને ચ્યા ચાકારાહાન ચ્યાહા કામ હોઅપી દેહે, એને ચોકીદારાન આખહે કા ચ્યા પાછા યેઅના લોગુ રાખવાળી કોઅજે. ");
INSERT INTO gbl_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","યાહાટી ઈસુય શિષ્યહાન આખ્યાં કા, તુમા નાંય જાંએ કા ગોઆ માલિક કોવે પાછી યી, યાહાટી તુમહાન એઅતા રા પોડી. વોખાતેહે કા, આરદી રાતે, કા કુકડા વાહાતે, કા ઉજાળાહાવોય યી. ");
INSERT INTO gbl_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","એહેકેન નાંય બોને કા તો અચાનક યેઇન તુમહાન હુતલા એએ. ");
INSERT INTO gbl_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","એને જીં આંય તુમહાન આખતાહાવ, તીંજ બોદહાન આખતાહાવ: સાદામાટે જાગતા રા.” ");
INSERT INTO gbl_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","આમી પાસ્કા સણ એને બેખમીર બાખ્યે સણા બેન દિહયા પાછે સુરુ ઓઅનારો આતો. મુખ્ય યાજક એને મૂસા નિયમ હિકાડનારા ગુરુ યે વાતે પાહલા પોડલા કા ઈસુવાલ કેહેકેન દોગો દેયન માઆઇ ટાકજે. ");
INSERT INTO gbl_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","બાકી ચ્યા આખે કા, “આપહાન પાસ્કા સણા દિહે એહેકેન નાંય કોઅરા જોજે, કાહાકા લોકહામાય દામાલ ઉસબી જાય.” ");
INSERT INTO gbl_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ચ્યે સમયે ઈસુ બેથાનીયા શેહેરામાય સિમોના ગાઅમે, જ્યાલ ઈસુય કોડા બીમાર્યે માઅને હારો કોઅલો આતો ખાં બોઠેલ. ઓલહામાય યોક બાય સંગેમરમર દોગડા બોનાવલી યોક બાટલી લેય યેની, જ્યેમાય અત્તાર તેલ બોઅલાં આતા, જીં ચોખ્ખાં જાટામાસીથી બોનાડલા અત્તાર તેલથી બોઅલાં આતા, એને બાટલ્યે મુયાઈહને તોડી દેના, એને તી ઈસુલ સન્માન દાંહાટી ઈસુ ટોલપાવોય બોદા અત્તાર તેલ રેડી દેના. ");
INSERT INTO gbl_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","બાકી વોછા જાંઆ પોતે મોનામાય ઓદ્રાયેકોય આખતા લાગ્યા, “ચ્યે એહેકેન યા મોઅગા અત્તાર તેલ ઓહોડાજ કાહા બગાડ કોઅયા? ");
INSERT INTO gbl_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","કાહાકા યા અત્તાર તેલાલ વેચી દેતા તોવે તોણસો દીનારા (૩૦૦ ચાંદ્યે રોમન સિક્કા એટલે યોકા વોરહા કામાણ્યેથી વદારે પોયહા હેય) કોઅતા વદારે પોયહા યેતા એને ચ્યા ગોરીબાહાન દેવાતા” એને ચ્યા ચ્યેલ ખિજવાયા. ");
INSERT INTO gbl_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ઈસુવે આખ્યાં, “ચ્યેલ ખિજવાના બોંદ કોઆ, એલ્યેલ કાહા આબદા પાડતાહા? એલ્યેય તે અત્તાર તેલ રેચવીન યોક હારાં કામ કોઅયાહાં. ");
INSERT INTO gbl_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ગોરીબ લોક તે તુમહેઆરે કાયામ રોનારા હેતા, એને તુમહાન ફાવે તોવે તુમા ચ્યાહાન હારાં કોઓઇ હોકતાહા, બાકી આંય તુમહેઆરે કાયામ નાંય રોનારો. ");
INSERT INTO gbl_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","જીં કાય તી કોઅઇ હોકી ચ્યેય કોઅયા, ચ્યે થેઅયેય મા મોઅરા પેલ્લા મા ટોલપાવોય અત્તાર તેલ રેડયા, કા મા શરીરાલ કોબારેમાય થોવાંહાટી તિયાર કોઅલા જાય હોકહે. ");
INSERT INTO gbl_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","આંય તુમહાન હાચ્ચાં આખતાહાવ કા આખા દુનિયામાય જાં કેસ હારી ખોબાર આખવામાય યી, તાં એલ્યેય માંહાટી જીં કોઅયાહાં, તીં ચ્યે યાદગીર્યેહાટી આખવામાય યી.” ");
INSERT INTO gbl_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","તોવે યહૂદા ઇસ્કારીયોત જો બાર શિષ્યહા માઅનો યોક જાંઆ આતો, તો મુખ્ય યાજકાહાપાય ગીયો એને આખ્યાં કા, “આંય ઈસુવાલ દોઆડાહાટી તુમહાન મોદાત કોઅહી.” ");
INSERT INTO gbl_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ચ્યા ઈ વાત વોનાઈન ખુશ ઓઅઇ ગીયા, એને ચ્યાલ પોયહા દાંહાટી વાયદો કોઅયો, પાછે તો ઈસુવાલ ચ્યાહા આથામાય દોઆડી દેઅના મોકો હોદતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","બેન દિહયા પાછે, બેખમીર પાસ્કા સણા પેલ્લે દિહે, જોવે ચ્યાહાય સણાહાટી ગેટા બલિદાન કોઆ, એને ઈસુવા શિષ્યહાય ચ્યાલ પુછ્યાં, “તું આમહાન કેછ દોવાડા માગતોહો કાય આમા પાસ્કા ખુશ્યે હાટી ખાઅના તિયાર કોઅજે કા આપા ખાજે?” ");
INSERT INTO gbl_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ચ્યે ચ્યા શિષ્યહા માઅને બેન શિષ્યહાન એહેકેન આખીન દોવાડયા, કા “યેરૂસાલેમ શેહેરામાય જાયા, તાં તુમહાન પાઅયા વેંડલા લેઈને જાતા યોક માઅહું મિળી, ચ્યા પાહલા જાજા. ");
INSERT INTO gbl_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","એને તો જ્યા ગોઆમાય જાય, તાંઅના ગોઆ માલિકાલ આખજા, કા ‘ગુરુય આખ્યાહા કા મા શિષ્યહાઆરે આંય પાસ્કા સણા જેવાણ ખાઅના ખાઉં ચ્યાહાટી માંહાટી ખોલી કેછ હેય?’ ");
INSERT INTO gbl_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","તોવે તો તુમહાન માળાંડયેવોય યોક મોઠી સોજાવીન તિયાર કોઅલી ખોલી દેખાડી દી, તાં આપેહાટી તિયારી કોઅજા.” ");
INSERT INTO gbl_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","બેન શિષ્ય ચાલ પોડ્યા એને શેહેરામાય યેના, એને જેહે ચ્યે ચ્યાહાન આખ્યેલ, તેહેંજ ચ્યાહાન એરા મિળ્યાં, એને તાં ચ્યાહાય પાસ્કા સણા જેવાણા તિયારી કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","જોવે વોખાત જાયી ઈસુ બાર ચેલાહાઆરે ચ્યે ગોઅમે યેનો. ");
INSERT INTO gbl_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","જોવે ચ્યા બોહીન ખાઅના ખાત તોવે, ઈસુવે આખ્યાં, “આંય તુમહાન હાચ્ચાં આખતાહાવ કા તુમહામાઅને યોક જાંઆ મા આરેજ ખાહાય, માન દોઆડી દાંહાટી મા દુશ્માનાહાલ મોદાત કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","જોવે ચ્યા ઈ વાત વોનાયા, ચ્યાહાન બોજ દુઃખ લાગ્યા, એને ચ્યા ઈસુવાલ પાછા-પાછા સાવાલ પુછા લાગ્યા કા, “કાય તો આંય હેતાઉ કા?” ");
INSERT INTO gbl_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ઈસુવે ચ્યાહાન આખ્યાં, “બાર શિષ્યહા માઅને યોક જાંઆ હેય, ચ્યા બાખે માંજ ખાઅનામાય બુડવેહે. ");
INSERT INTO gbl_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","આંય, માઅહા પોહો મોઅઇ જાહીં કાહાકા પવિત્રશાસ્ત્રમાય લોખલાં હેય, બાકી ચ્યા માઅહાન બોજ કોઠાણ શિક્ષા ઓરી જો માન દોઅઇ દાંહાટી મોદાત કોઅહે ચ્યા માઅહાહાટી, જો કાદાં ચ્યાલ જન્મોજ નાંય દેતા તીં હારાં ઓઅતા.” ");
INSERT INTO gbl_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","જોવે ચ્યા ખાત તોવે, ઈસુવે બાખ્યે ટુકડો લેદો, એને બાખ્યેહાટી પોરમેહેરા આભાર માન્યા એને, મુડીન શિષ્યહાન દેની, એને ચ્યે આખ્યાં, “લા એને ખા, ઈ મા શરીર હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","પાછે ઈસુવે દારાખા રોહા પિયાલો લેદો, એને પોરમેહેરા આભાર માનીન તીં ચ્યા શિષ્યહાન દેના, એને ચ્યા બોદહાય ચ્યામાઅને પિદાં. ");
INSERT INTO gbl_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","એને ઈસુવે ચ્યાહાન આખ્યાં, “ઓ દારાખા રોહો મા લોય હેય, મા લોય ઘોણા લોકહા એહેરે બોલીદાના રુપામાય વોવાડલાં જાહે, ઓ ચ્યા વાયદા સાબિત કોઅરી જો પોરમેહેર પોતે લોકહાઆરે બોનાવી રિઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, ચ્યા પાછે, આંય ચ્યા દિહી યા લોગુ પાછે કોવેજ દારાખા રોહો નાંય પિયું, જાંઉ લોગુ આંય પોરમેહેરા રાજ્યામાય નોવો દારાખા રોહો નાંય પીયહીં.” ");
INSERT INTO gbl_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","તોવે ઈસુ એને ચ્યા શિષ્ય પાસ્કા ગીતે આખ્યે એને પોરમેહેરા સ્તુતિ કોઅયી, એને યેરૂસાલેમ શેહેરા બાઆ જાતા રિયા એને જૈતુન ડોગા ઉપે ચાલ પોડયો જો પાહાય આતો. ");
INSERT INTO gbl_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","જોવે ચ્યા ડોગા એછે જાં આતા તોવે ઈસુવે ચ્યાહાન આખ્યાં, તુમા બોદા માન છોડીન નાહી જાહા, જેહેકોય પવિત્રશાસ્ત્રમાય લોખલાં હેય: પોરમેહેર એહેકેન આખહે કા, આંય ચ્યા માઅહાન માઆઇ ટાકહી જો મા લોકહાન મેંડવાળ્યાહા હારકો હાંબાળ કોઅહે, એને ગેટેં વેરગાઈ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","બાકી મા મોઅલાહામાઅને જીવી ઉઠના પાછે, આંય તુમહે પેલ્લા ગાલીલ ભાગામાય જાહીં, એને તાં મીળહી. ");
INSERT INTO gbl_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","પિત્તરે ઈસુવાલ આખ્યાં કા, “જેરુ બોદાજ છોડીન નાહી જાય, બાકી આંય તુલ છોડીન નાંય જાંઉ.” ");
INSERT INTO gbl_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ઈસુવે ચ્યાલ આખ્યાં, “આંય તુલ હાચ્ચાં આખતાહાવ કા આજે રાતી કુકાડ બેનદા વાહાયી ચ્યા પેલ્લાજ, તું માન તીનદા નાકાર કોઅઇ દેહે કા તું માન નાંય વોળખે.” ");
INSERT INTO gbl_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","બાકી ચ્યે આજુ બોજ ઈંમાતે કોઅઈન આખ્યાં કા, “એને તોઆરે માન મોરાં બી પોડી, તેરુંબી આંય કોવેજ નાંય આખું કા આંય નાંય વોળખું,” એને યેજપરમાણે બોદહાય એહેંજ આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","પાછે ઈસુ એને શિષ્ય ગેતસેમાને બાગમાય યેના એને ઈસુવે શિષ્યહાન આખ્યાં કા, “તુમા ઈહીં બોહીજા આંય જાયન પોરમેહેરાલ પ્રાર્થના કોઅહુ.” ");
INSERT INTO gbl_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","એને ચ્યે પિત્તર યાકૂબ એને યોહાનાલ ચ્યાઆરે આજુ વાયજ દુર લેઈને ગીયો, એને પાછે તો બોજ દુઃખી એને નિરાશ ઓઅઇ રીયલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","એને ચ્યે શિષ્યહાન આખ્યાં, “મા જીવ બોજ દુઃખી હેય, ઓહડા લાગહે કા મા જીવ નિંગી જાય: તુમા ઈહીં રિયા એને જાગતા રોજા.” ");
INSERT INTO gbl_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","પાછો ઈસુ વાહાયોક દુઉ ગીયો એને મેંડયે પોડયો એને પોતે ચેહેરો દોરત્યેવોય ટેકાડી દેનો એને પોરમેહેરાલ પ્રાર્થના કોઅયી, જોવે તો યોજનામાય શક્ય ઓરીતે માન યા દુઃખામાઅને બોચાડ જીં માયેવોય યેનારાં હેય, ");
INSERT INTO gbl_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","એને ઈસુવે આખ્યાં, “ઓ આબા, ઓ પિતા, તોથી બોદાંજ બોની હોકહે, માન યા દુઃખા પાયને દુઉ કોઅઇ દે, તેરુ આંય આખું તેહેંજ નાંય, બાકી તું જીં આખે તેહેંજ બોને.” ");
INSERT INTO gbl_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","જોવે ઈસુ પાછે યેનો એને ચ્યાય તીની શિષ્યહાન હુતલા દેખ્યા ને પિત્તરાલ આખ્યાં, “ઓ સિમોન, કાય તું હુવીજ રિયહો? કાય તુમહાન યોક કલાક બી નાંય જાગતા રોવાયાં? ");
INSERT INTO gbl_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","જાગતા એને પ્રાર્થના કોઅતા રા કા, તુમા બોદા પરીક્ષામાય માયેવોય બોરહો કોઅના બોંદ નાંય કોઅઇ દેતા, તુમહે જીવ તે હાચ્ચાં કોઅરા તિયારી હેય, બાકી શરીર નોબળાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","એને તો પાછે યોકદા પ્રાર્થના કોઅરા ગીયો એને જાયન ચ્યે તેહેકોયજ પ્રાર્થના કોઅયી જેહેકોય પેલ્લી કોઅયેલ. ");
INSERT INTO gbl_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","પાછા યેઇન ઈસુય ચ્યાહાન હુતલા દેખ્યા, કાહાકા ચ્યાહા ડોળા નિંદે કોઇન બાઆઈ ગીઅલા આતા, એને જોવે ઈસુય ચ્યાહાન ઉઠાડયા તોવે ઈસુવાલ કાય જાવાબ દેઅના તીં ચ્યાહાન હુજ નાંય પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","પાછો તીજેદા યેઇન ઈસુવે ચ્યાહાન આખ્યાં, આજુબી તુમા હુતલાજ રા એને આરામ કોઅતાજ રા, બાસ આમી બો ઓઅઇ ગીયા, “એઆ આમી મા સમય યેય ગીઅલો હેય માન માઅહા પોહાલ પાપી લોકહા આથામાય દેય દી. ");
INSERT INTO gbl_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ઉઠા, ચાલા, એઆ, જો માન દોઅવાડી દાંહાટી મોદાત કોઅઇ રિઅલો હેય, તો આમી યેય રિઅલો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","એને તો આજુ બોલહે ઓલાહામાયજ, યહૂદા ઇસ્કારીયોત જો બાર શિષ્યહા માઅનો યોક જાંઆ આતો તાં યેનો, ચ્યા હાતે બોજ લોક આતા, યા લોક મુખ્ય યાજક એને મૂસા નિયમ હિકાડનારા ગુરુ ને યહૂદી આગેવાનાહાથી દોવાડલા આતા, યહૂદા હાતે આતા ચ્યા લોકહાપાંય તારવાયો એને ડેંગારા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","યહૂદા ઇસ્કારીયોત, જો ચ્યાલ દોઅવાડી દાંહાટી મોદાત કોઅઇ રિઅલો આતો લોકહા ટોળાલ પેલ્લાજ ઓહડી નિશાણી દેનેલ કા, જ્યાલ આંય પ્રેમ કોય ગુળા દાવ તીંજ માઅહું હેય, ચ્યાલ દોઅઇ લેજા એને હાચવીન લેય જાજા. ");
INSERT INTO gbl_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","યહૂદા ઇસ્કારીયોત યેનો, એને તારાતુજ ઈસુવાપાય જાયને આખ્યાં, “ઓ ગુરુ” એને ચ્યે ચ્યાલ ગુળા દેના. ");
INSERT INTO gbl_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","તોવે ચ્યા લોકહાય ચ્યાવોય આથ ટાકીન ચ્યાલ દોઅઇ લેદો. ");
INSERT INTO gbl_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ઈસુવા પાહાય ઉબા રીઅલા આતા, ચ્યાહામાઅને યોકે જાંએ ચ્યા તારવાય કાડીન મહાયાજકા ચાકારા ઉપે ચાલાડી, એને ચ્યા કાન કાપી ટાક્યો. ");
INSERT INTO gbl_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ઈસુવે ચ્યાહાન આખ્યાં, “કાય તુમા માન ડાખૂ હોમજીન દોઓરાં હાટી તારવાય એને ડેંગારા લેઈને યેનાહા કા? ");
INSERT INTO gbl_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","એને આયતે દિને દેવાળામાય તુમહેઆરે રોઇન હિકાડૂ, તેરુ તુમાહાય માન નાંય દોઅયેલ: બાકી ઈ યાહાટી ઓઅયા કા, પવિત્રશાસ્ત્રમાય લોખલાં હેય તીં પુરાં ઓઅઇ.” ");
INSERT INTO gbl_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","એને તોવે બોદા શિષ્ય ચ્યાલ છોડીન નાહી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","યોક જુવાનિયો ચ્યા ઉગાડા શરીરાઉપે મોઅગા બોનતાં ફાંગીન ચ્યા પાહલા ચાલ પોડયો, એને ચ્યાલ ચ્યા લોકહાય દોઅયો. ");
INSERT INTO gbl_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","બાકી તો બોનતાં ટાકી દેયન, ઉગાડોજ ચ્યાહા પાયને નાહી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","પાછે ચ્યા ઈસુવાલ મહાયાજકા ગોઓ લેય ગીયા, એને બોદહા મુખ્ય યાજક, આગેવાન એને મૂસા નિયમ હિકાડનારા ગુરુ તાં ટોળો વળ્યા. ");
INSERT INTO gbl_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","પિત્તર દુઉ લોગુ ચ્યા પાહલા-પાહલા મહાયાજકા બાઆપુર લોગુ ગીયો, એને રાખવાળ્યાહા આરે આગડા પાય તાપાયા બોઠો. ");
INSERT INTO gbl_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","મુખ્ય યાજક એને બોદયે સોબા યેય ઈસુવાલ માઆઇ ટાકાડાંહાટી ઈસુવા વિરુદમાય સાબિતી હોદેત, બાકી ચ્યાહાન કાયજ સાબિતી મિળી નાંય. ");
INSERT INTO gbl_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","કાહાકા બોજ લોક ઈસુવા વિરુદમાય જુઠી સાક્ષી દેત, બાકી ચ્યાહા સાક્ષી યોકબીજાઆરે ઈળે-મીળે નાંય. ");
INSERT INTO gbl_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","તોવે કોલાહાક લોકહાય ઉબા રોઇન ચ્યા વિરુદમાય ઓહડી જુઠી સાક્ષી દેની કા, ");
INSERT INTO gbl_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“આમાહાય એલાલ એહેકેન આખતો વોનાયાહા કા, આંય માઅહા આથે બાંદલા દેવાળાલ તોડી પાડહીં, એને તીન દિહીહયામાય આંય યોક બીજાં દેવાળ તિયાર કોઅહી, જો આથેકોય નાંય બાંદલો રોઈ.” ");
INSERT INTO gbl_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","બાકી ચ્યાહા સાક્ષી યોકબીજાઆરે ઈળે-મીળે નાંય. ");
INSERT INTO gbl_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","તોવે મહાયાજકે બોદહા વોચમાય ઉબા રોઇન ઈસુવાલ પુછ્યાં, “કાહા તું જાવાબ નાંય દેય? તું કાય આખતોહો કા યા લોકહાય તો વિરુદમાય કાય આખ્યાહા?” ");
INSERT INTO gbl_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","બાકી તો ઠાવકોજ રિયો, એને જાવાબ નાંય દેનો, એને આજુ મહાયાજકે ઈસુવાલ એહેકેન પુછ્યાં કા, “કાય તું ખ્રિસ્ત હેતો, ચ્યા મહિમામય પોરમેહેરા પોહો જ્યા આમા ભક્તિ કોઅતાહા?” ");
INSERT INTO gbl_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ઈસુવે જાવાબ દેનો, “આંય હેતાઉ એને તુમા માન માઅહા પોહાલ બોજ સામર્થ હાતે પોરમેહેરા જમણી એછે બોઠલો એઅહા એને માન આકાશામાઅને વાદળામાઅને યેતો એઅહા.” ");
INSERT INTO gbl_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","જોવે મહાયાજક વોનાયોકા ઈસુય કાય આખ્યાં, તોવે ચ્યાય ચ્યા પોતેજ ફાડકે ફાડી ટાક્યેં કાહાકા તો બોજ ખિજવાલો આતો એને આખ્યાં કા, “આમી આપહાન બિજા સાક્ષીદારા જરુર નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","તુમા ચ્યાલ પોરમેહેરા નિંદા કોઅતા વોનાયાહા. આમી તુમહે કાય આખના હેય?” ચ્યા બોદા યે વાતે સહમત આતા કા ઈસુ ગુનેગાર હેય એને મોઅરા લાયકે હેય. ");
INSERT INTO gbl_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","તોવે કાદે ચ્યા મુંયા ઉપે થુપ્યાં, એને ચ્યા મુંય ડાકીન ઠોકાં લાગ્યા, એને એહેકેન આખીન ચ્યા મશ્કરી કોઅયી, “જોવે તું યોક ભવિષ્યવક્તો હેય તે આમહાન આખ કા તુલ કુંયે ઠોક્યાં” એને ચાકારાહાય ચ્યાલ દોઇન થાપડાહાકોંય ઠોક્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","જોવે પિત્તર બાઅવામાય આગડા ઈહીં તાપતોજ આતો, ઓલહામાય મહાયાજકા ચાકરાણી માઅને યોક તાં યેની, ");
INSERT INTO gbl_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","એને પિત્તરાલ તાપતો દેખીન ચ્યાએછે યોકદીઠ એઇન એહેકેન આખા લાગી, “તું હોગો નાજરેત ગાવામાઅને ઈસુવાઆરે આતો.” ");
INSERT INTO gbl_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","બાકી તો નાંય માન્યો એને ચ્યે આખ્યાં, “તું કાય આખતીહી તીં આંય જાંઉ નાંય એને હોમજુ બી નાંય” પાછો તો દરવાજા બાઆ ગીયો ઓલહામાય કુકાડ વાહાયો. ");
INSERT INTO gbl_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","તી ચાકરાણી પાછી ચ્યાલ એઇન, તાં ઉબા રીયલાહાન આખતી લાગી કા, “ઓ હોગો ઈસુ શિષ્યહા માઅનો યોક શિષ્ય હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","બાકી તો પાછો નાંય માનતો લાગ્યો, એને વોછયેજ વાઆયેમાય પાહાય ઉબા રીઅલા માઅહાય પિત્તરાલ આખ્યાં, “કાહાકા જેહેકોય તું બોલી રિઅલો હેય ચ્યાથી ખોબાર પોડહે કા તું ગાલીલ ભાગા માઅહું હેતો, યાહાટી ઈ નોક્કી હેય કા તુંબી ઈસુવા શિષ્યહા માઅને યોક હેતો.” ");
INSERT INTO gbl_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","તોવે પિત્તર હારાપ દાં લાગ્યો એને કોસામ ખાયન આખતો લાગ્યો કા, “આંય એલા માઅહાન નાંય વોળખું, જ્યા માઅહા બારામાય તુમા વાત કોઅતાહા.” ");
INSERT INTO gbl_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","તોવે ચ્યેજ ગેડયે કુકાડ બીજાદા વાહાયો એને પિત્તરાલ ઈસુવા આખલી વાત યાદ યેની, “કુકાડ બેનદા વાહાયી ચ્યા પેલ્લા તું માન તીનદા નાકાર કોઅઇ દેહે કા તું માન નાંય વોળખે” એને તોવે પિત્તર ચ્યા પોતે દુ:ખાલ તાબામાંય નાંય કોઅઇ હોક્યો એને તો હુંઅકા ટાકીન રોડાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","હાકાળેહે ઉજાળાં ઓઅતાંજ તારાત મુખ્ય યાજક, આગેવાન એને મૂસા નિયમ હિકાડનારા ગુરુ એને બોદે મહાસોબાયે વિચાર કોઇન નોક્કી કોઅયા, ચ્યા પાછે ચ્યાહાય ઈસુવાલ બાંદ્યો, એને ચ્યાલ પારખાંહાટી રાજા પિલાતા મેહેલામાય લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","પિલાતેં ચ્યાલ પુછ્યાં, “કાય તું યહૂદી લોકહા રાજા હેતો કા?” ઈસુવે ચ્યાલ જાવાબ દેનો, “તું હાચ્ચાં આખી રિયહો કા આંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","તોવે મુખ્ય યાજક ચ્યા ઉપે બોજ વાતહે દોષ લાવી રિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","તોવે પિલાતેં પાછા ચ્યાલ પુછ્યાં, “કાહા તું કાંઇજ જાવાબ નાંય દેય, એએ યેં તો ઉપે કોલ્યે બોદયે વાતહે દોષ થોવતેહે?” ");
INSERT INTO gbl_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ઈસુ પાછી ઠાવકોજ રિયો ચ્યાહાટી પિલાતાલ બોજ નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","દોર વોરહી પાસ્કા સણામાય, પિલાત યોકા કૈદ્યાલ છોડી દાંઉ આતો, જ્યાલ લોક માગતા આતા કા તો છોડી દેય. ");
INSERT INTO gbl_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ચ્યે સમયે બારાબ્બાસ નાંવા યોક માઅહું આતા, બિજા કૈદ્યાહા આરે જેલેમાય આતો, જ્યાંય રોમી સરકારા વિરુદમાય ગુનો કોઇન કાંયક લોકહાન માઆઇ ટાક્યેલ. ");
INSERT INTO gbl_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","એને ગીરદી પિલાતાપાંય યેઇન ચ્યાલ યોકા કૈદ્યાલ છોડી દાંહાટી આખા લાગ્યા, જેહેકોય તો સાદા કોઅતો યેનલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","પિલાતેં ચ્યાહાન જાવાબ દેનો, કા “કાય તુમા માગતેહે કા આંય તુમહેહાટી યહૂદીયાહા રાજાલ છોડી દાંઉ?” ");
INSERT INTO gbl_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","કાહાકા પિલાતાલ ખોબાર આતી કા મુખ્ય યાજકાહાય ઈસુલ ઓદ્રાયેકોય દોઓવાડી દેનેલ. ");
INSERT INTO gbl_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","બાકી મુખ્ય યાજકાહાય લોકહાન ઉસરાવ્યા કા પિલાતાલ ઈસુલ છોડી દાં બોદલે બારાબ્બાસાલ છોડી દાંહાટી માંગ કોએ. ");
INSERT INTO gbl_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ઈ વોનાઈન પિલાતેં ચ્યાહાન પાછા પુછ્યાં કા, “તોવે તુમા જ્યાલ યહૂદીયાહા રાજા આખતાહા, ચ્યાલ આંય કાય કોઉ?” ");
INSERT INTO gbl_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","લોકહા ટોળો પાછો બોંબલી ઉઠયો, “ચ્યાલ હુળીખાંબાવોય માઆઇ ટાકાં.” ");
INSERT INTO gbl_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","પિલાતેં ચ્યાહાન પુછ્યાં, “કાહા, એલે કાય ગુનો કોઅયોહો?” બાકી લોકહા ટોળો પાછો જોરમાય બોંબલા લાગ્યા કા, “એલાલ હુળીખાંબાવોય માઆઇ ટાકાં.” ");
INSERT INTO gbl_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","તોવે પિલાતેં લોકહાન રાજી કોઅરાહાટી, બારાબ્બાસાલ ચ્યાહાહાટી છોડી દેનો, એને ઈસુવાલ ચાપકાહા માર દેવાડીન રોમી સીપાડાહાલ હોઅપી દેનો, કા ચ્યે ચ્યાલ હુળીખાંબાવોય ચોડવી દેય. ");
INSERT INTO gbl_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","સીપાડા ચ્યાલ મેહેલા આંદાર બાઅવામાય લેય ગીયા તીં ઠિકાણ પ્રીટોરિયુમ નાંવે કોઇન વોળખાયેહે, એને બોદયે ટુકડયેહેન હાદી લેય યેના, લગભગ છસો સીપાડા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","તોવે ચ્યાહાય ચ્યાલ જાંબળ્યા રોંગા ડોગલાં રાજા રુપામાય મશ્કરી કોઅરાહાટી પોવાડયા, જેહેકોય તો રાજા હેય, એને ચ્યાહાય કાટાળ્યે ડાહાગ્યે મુગુટ બોનાડીન ચ્યા મશ્કરી કોઅરાહાટી ટોલપાવોય પોવાડયા, ");
INSERT INTO gbl_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","એને એહેકેન આખીન ચ્યા ચ્યાલ સલામ કોઆ લાગ્યા કા, “ઓ યહૂદીયાહા રાજા, સલામ.” ");
INSERT INTO gbl_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ચ્યા પાછી ટોલપાવોય વાતડયે લાકડયે કોઅઈન ઠોકેત, એને ચ્યા અપમાન કોઅરાહાટી ચ્યા ઉપે થુપ્યાં, એને ચ્યા ચ્યાલ માન દાંહાટી પાગે પોડતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","જોવે ચ્યાહાય ચ્યા મશ્કરી પુરી કોઅયા પાછે, ચ્યા ઉપને ચ્યાહાય ડોગલાં કાડી લેદા એને ચ્યાજ ફાડકે ચ્યાલ પોવાડયે; એને પાછે ચ્યાલ હુળીખાંબાવોય ચોડવાહાટી શેહેરા બાઆ લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","જોવે ચ્યા શેહેરા બાઆ જાય રીયલા આતા, તે સિમોન નાંવા યોક માઅહું ગાવા ભાગામાઅને યેરૂસાલેમ શેહેરામાય યી રિઅલો આતો. સિમોન કુરેની ગાવામાઅનો આતો, એને તો સિકંદર એને રૂફસા આબહો આતો, સીપાડાહાય ચ્યાલ આખ્યાં કા તો હુળીખાંબ લેઈને ચ્યા જાગા લોગુ લેય જાય જાં ચ્યા ઈસુલ હુળીખાંબાવોય ચોડાવનારા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","સીપાડા ઈસુવાલ ગુલગથા નાંવા જાગાવોય લેય ગીયા, જ્યા મોતલાબ આરામી ભાષામાય “ખોપર્યે જાગો” ઓઅહે. ");
INSERT INTO gbl_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","તોવે સીપાડાહાય ઈસુલ ગન્ધરસ નાંવા દવા બેખાળલો દારાખા રોહો પિયાં દેનો કા ચ્યાલ પીડા નાંય હાચવાયાહાટી મોદાત કોએ, બાકી ચ્યે પીયાંહાટી મોનાઈ કોઅઇ દેના. ");
INSERT INTO gbl_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","પાછે ચ્યાહાય ચ્યાલ હુળીખાંબાવોય ચોડવી દેનો એને ચ્યાહાય ચ્યા ડોગલાહા હાટી ચીઠયો ટાક્યો, એને કાલ કાય મીળે યાહાય વાટી લેદે. ");
INSERT INTO gbl_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ચ્યે સમયે હાકાળેહે નોઉં વાજલે આતેં જોવે ઈસુવાલ હુળીખાંબાવોય ચોડવી દેનેલ. ");
INSERT INTO gbl_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","સીપાડાહાય ઈસુ ટોલપા ઉચે યોક પાટી લાવી દેની, ચ્યામાય એહેકેન લોખલાં આતા, “યહૂદીયાહા રાજા.” ");
INSERT INTO gbl_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ચ્યાહાય ચ્યાઆરે બેન બાંડાહાલ હોગા હુળીખાંબાવોય ચોડવી દેના, યોકાલ જમણે આથે એને યોકાલ ડાબે આથે. ");
INSERT INTO gbl_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","એહેકેન, પવિત્રશાસ્ત્ર હાચ્ચો ઓઅઇ ગીયો જો ખ્રિસ્તા બારામાય આખતો હેય, “તો યોક ગુનેગારા હારકો ગોણલો જાય.” ");
INSERT INTO gbl_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","એને વાટે જાતે માઅહે ટોલપા આલવી-આલવીન એહેકેન આખીન ચ્યા નિંદા કોએત કા, “એરે, દેવાળાલ પાડી ટાકનારા, એને તીન દિહીહયામાય ચ્યાલ પાછા બોનાવનારા. ");
INSERT INTO gbl_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","હુળીખાંબાવોયને ઉતી પોડ એને પોતાનેજ બોચાવ કોઅઇ લે.” ");
INSERT INTO gbl_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","યેજપરમાણે મુખ્ય યાજકબી, મૂસા નિયમ હિકાડનારા ગુરુ આરે મશ્કરી કોઅઈન આખે કા, “એલે બીજહાન બોચાવ્યા, બાકી પોતેજ પોતાલ બોચાવી નાંય હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ઈ માઅહું જો ઈસરાયેલા ખ્રિસ્ત એને રાજા, ઓઅરા માગતો આતો આમી હુળીખાંબાવોયને ઉતી યે, કા આમા દેખી હોકજે એને તોવોય બોરહો કોઅઇ હોકજે કા ઓજ આમે રાજા હેય.” એને ચ્યાઆરે જ્યા બાંડ હુળીખાંબાવોય ચોડાવલા આતા ચ્યાહાય હોગી ચ્યા મશ્કરી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","બોપરેહે પાછે બોદા દેશામાય આંદારાં ઓઅઇ ગીયા, એને તીં તીન વાગ્યા લોગુ રિયા. ");
INSERT INTO gbl_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","તીન વાગે લગભગ, ઈસુવે મોઠેરે બોંબલીન આખ્યાં કા, “એલોઈ, એલોઈ, લમા શબકથની?” એટલે, “ઓ મા પોરમેહેર, ઓ મા પોરમેહેર, તુયે માન કાહા છોડી દેનોહો?” ");
INSERT INTO gbl_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ચ્યા લોકહામાઅને કાંયક લોક જ્યા તાં ઉબા આતા, ચ્યા વોનાયા બાકી જુઠી રીતે હોમજ્યા એને યોકાબીજાલ આખ્યાં, “વોનાયા, તો ભવિષ્યવક્તા એલીયાલ હોરગામાઅને પોતે મોદાત કોઅરાહાટી હાદી રિઅલો હેય.” ");
INSERT INTO gbl_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","એને ચ્યા માઅહા માઅને યોક માઅહું દાંહાદી ગીયા, યોક પોંચ લેદો, એને ચ્યાલ ખાટામાય બુડવી દેના, એને વાતડયે લાકડયેઉપે બાંદિન ચ્યાલ ચુહૂરાં દેની, એને આખ્યાં, “ઉબા રિયા એને કાયજ મા કોઅહા, એલીયા ચ્યાલ હુળીખાંબાવોય ઉતાડાં યેહે કા નાંય.” ");
INSERT INTO gbl_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","તોવે ઈસુવે મોઠેરે બોંબલ્યો એને મોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","એને તો મોઠો પોડદો જો દેવાળામાય લોટકાડલો આતો, જો બોદહાલ પોરમેહેરા હજર્યેમાય જાંહાટી રોકતો આતો, ઉપેરે તે નિચે લોગુ બેન ભાગ ઓઇન ફાટી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","જો સિપાડાહા જોમાદાર ઈસુવા હામ્મે ઉબો રિઅલો આતો, ચ્યા આવાજ વોનાયો એને દેખ્યાકા કેહેકેન મોઅઇ ગીયો, ચ્યાય આખ્યાં, “હાચ્ચાં હેય કા ઈ માઅહું પોરમેહેરા પોહો આતો.” ");
INSERT INTO gbl_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","કોલ્યોહોક બાયો દુઉ રોઇન એઅયા કોએત: યા ટોળામાય મરિયમબી આતી જીં મગદલા નાંવા શેહેરામાઅને આતી, સાલોમી, વાહાનો યાકૂબ એને યોસેસા આયહો મરિયાબી આતી. ");
INSERT INTO gbl_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","યા પેલ્લા, જોવે ઈસુ ગાલીલ ભાગામાય ચારીચોમખી મુસાફરી કોઅયી, તોવે ચ્યો તીન બાયો ચ્યા શિષ્ય હારક્યો પાછાડી ચાલેત એને ચ્યા જીં ગોરાજ આતી તી પુરાં કોઅત્યો આત્યો. એને કોલહ્યોક બીજ્યો બાયોબી ગાલીલ ભાગામાઅને ચ્યાઆરે-આરે આત્યો એને ચ્યાઆરે યેરૂસાલેમ શેહેરામાય યેનલ્યો આત્યો, ચ્યોબી દુઉને એઇ રીયલ્યો આત્યો. ");
INSERT INTO gbl_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","જોવે વેળ પોડી ગીયેલ, કાહાકા તિયાર્યે દિહી આતો, જ્યા મોતલાબ હેય આરામા પેલ્લો દિહી. ");
INSERT INTO gbl_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","યોસેફ નાંવા યોક માટડો આતો, તો અરીમતિયા શેહેરા રોનારો આતો, તો યોક યહૂદી મહાસોબાયે બોજ માનાપાના માઅહું આતો. તો ચ્યા લોકહામાઅને આતો જ્યેં ઈ ઇચ્છા કોઅતે આતેં કા પોરમેહેરા રાજ્ય માહારુજ યેનારાં હેય, તો બિક વોગાર પિલાતાપાંય ગીયો એને ઈસુ શરીર હુળીખાંબાવોયને નિચે ઉતાડાંહાટી એને કોબારેમાય થોવાંહાટી માગ્યાં. ");
INSERT INTO gbl_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","પિલાત બોરહો નાંય કોઅઇ હોક્યો, ઈસુ ઓલે માહારી મોઅઇ ગીયો, એને ચ્યેય જોમાદારાલ હાદ્યો, એને ચ્યાલ પુછ્યાં, “કાય ઈસુ પેલ્લોજ મોઅઇ ચુકલો હેય?” ");
INSERT INTO gbl_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","જોવે ચ્યે જોમાદારા પાયને ખોબાર જાંઅયા પાછે, પિલાતાય આખ્યાં કા યોસેફાલ ઈસુ શરીરાલ કોબારેમાય થોવાંહાટી લેય જાય. ");
INSERT INTO gbl_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","તોવે યોસેફાય યોક મલમલા મોઅગા ફાડકા વેચાતાં લેય લેદા, એને ચ્યાય ઈસુ શરીર હુળીખાંબાવોઅને ઉતાડી લેદા, એને ચ્યાલ (યહૂદી રીતીકોય) ફાડકામાય ચોંડાળી લેદા, એને ખોલકડામાય કાતરાવલી કોબારેમાય થોવી દેના, પાછે ચ્યાય યોક મોઠો દોગડો કોથલાડયો એને ચ્યાલ કોબારે બાઅણા ઉગાડના જાગાવોય ચ્યાલ બોંદ કોઅરાહાટી થોવી દેનો. ");
INSERT INTO gbl_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","મરિયાબી આતી જીં મગદલા નાંવા શેહેરામાઅને આતી, વાહાનો યાકૂબ એને યોસેસા આયહો મરિયમ ઈ એએય રિઅલી કા ચ્યાલ કેછ માહણામાય થોવતેહે. ");
INSERT INTO gbl_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","વોખાતેહે જોવે પોરમેહેરા આરામા દિહી પુરો ઓઅય ગીયો તોવે, મરિયમ જીં મગદલા નાંવા શેહેરામાઅને આતી, વાહાનો યાકૂબ એને યોસેસા આયહો મરિયમ એને સાલોમી યો તીન બાયો ઈસુવા શરીરાલ લાવાં હાટી સુગંદી વસ્તુ વેચાતાં લેય યેન્યો. ");
INSERT INTO gbl_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","રવિવારા દિહી હાકાળેહે દિહી નિંગતાંજ, ચ્યો કોબારેપાય યેય પોઅચ્યો, ");
INSERT INTO gbl_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","એને ચ્યો ચ્યેહેમાય એહેકેન આખત્યો આત્યો કા, “આપહેહાટી કોબારે મુંયા ઉપને મોઠો દોગડો કું ઓટાડી?” ");
INSERT INTO gbl_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","જોવે ચ્યેહેય નોજાર કોઇન કોબારે એછે એએયા, તોવે દેખ્યાકા કોબારે મુયાઈહને મોઠો દોગાડ પેલ્લોજ ઓટાડલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","જોવે ચ્યો બાયો કોબારે પાહી યેન્યો એને માજા ગીયો, તે ચ્યેહેય દેખ્યાકા યોક જુવાન્યાલ ઉજળેં ફાડકે પોવીન જમણી બાજુ બોઠલો દેખ્યો, તોવે ચ્યો બોજ બિઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ચ્યે જુવાન્યે બાયહેલ આખ્યાં કા, “બીયહા મા, તુમા નાજરેત ગાવા ઈસુવાલ, જ્યાલ હુળીખાંબાવોય ચોડવ્યેલ ચ્યાલ હોદત્યોહો તો પાછો જીવતો ઉઠયોહો, ઈહીં નાંય હેય, એએયા, ઈ તીજ જાગા હેય, જ્યેં જાગે ચ્યાલ થોવ્યેલ. ");
INSERT INTO gbl_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","આમી તુમા જાયા, એને પિત્તર એને ઈસુવા બિજા શિષ્યહાન જાયને એહેકેન આખા કા, ઈસુ જીવતો હેય, તો ગાલીલ ભાગામાય જાય રીયલો હેય, એને તુમા બોદહાલ બી તાં જાં પોડી, તુમા ચ્યાલ તાં એઅહા, જેહેકોય ચ્યાય મોઅરા પેલ્લા તુમહાન આખલા આતા.” ");
INSERT INTO gbl_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","એહેકેન વોનાયો પાછે, ચ્યો કોબારેઈહીને બાઆ નિંગ્યો એને દાંહાદી ગીયો, કાહાકા હેરાણા લીદે ચ્યો કાપત્યો આત્યો એને વાટેમાય, ચ્યેહેય કાદાલ કાય આખ્યાં નાંય, કાહાકા ચ્યો બિઇ ગીઅલ્યો. ");
INSERT INTO gbl_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","રવિવારા ઉજાળાં ઓઅતાંજ ઈસુ મોઅલા માઅને જીવી ઉઠયો પાછે, બોદહા પેલ્લા જ્યેં બાયેલ દેખાયો, તી મગદલા ગાવામાય રોનારી મરિયમ આતી, જયેમાઅને ઈસુય હાંત બુતડે કાડલે. ");
INSERT INTO gbl_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","તી ઈસુવા શિષ્યહાપાય ગિઇ એને શિષ્યહાન આખ્યાં કા કાય જાયલા હેય, શિષ્ય ઈસુવાહાટી રોડતા એને કોકાળતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","બાકી જોવે મરિયમે શિષ્યહાન આખ્યાં, “ઈસુ જીવતો હેય, એને માયે આમી ચ્યાલ દેખ્યો” પાછે શિષ્યહાય વિચાર કોઅયો ઈ હાચ્ચાં નાંય ઓઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ચ્યા પાછે ઈસુ બેન શિષ્યહાન દેખાયો જ્યા યેરૂસાલેમ શેહેરામાઅને ગામડે જાત, બાકી ચ્યાહાય ચ્યાલ પેલ્લેદા નાંય વોળખ્યો કાહાકા ચ્યાય પોતે રુપ બોદલી લેદલા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","જોવે ચ્યાહાય ઈસુલ વોળખ્યો, તોવે ચ્યા બેની શિષ્ય પાછી યેરૂસાલેમ વોળી ગીયા, ચ્યાહાય ચ્યાહા બિજા શિષ્યહાન આખ્યાં કા કાય જાયલા આતા, બાકી ચ્યા યાવોય બોરહો નાંય કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","પાછે, ઈસુ અગ્યાર શિષ્યહાન બી દેખાયો, જોવે ચ્યા ખાં બોઠલા આતા. ઈસુ ચ્યાહાન ખિજવાયો કાહાકા ચ્યા લોકહા સાક્ષ્યે વોય બોરહો નાંય થોવના લેદે બોજ જિદ્દી બોની ગીઅલા, જ્યાહાય ચ્યાલ પાછી જીવી ઉઠનામાઅને દેખલો આતો. ");
INSERT INTO gbl_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","એને ઈસુવે ચ્યાહાન આખ્યાં, “તુમા આખા દુનિયામાય જાં, એને બોદી જાત્યે લોકહાન હારી ખોબાર જાહેર કોઆ. ");
INSERT INTO gbl_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","જો કાદો માયેવોય બોરહો થોવે એને બાપતિસ્મા લેય ચ્યાજ તારણ ઓઅઇ, બાકી જો કાદો બોરહો નાંય થોવે, પોરમેહેર ચ્યાહાન પાપહાલીદે ડોંડ દી. ");
INSERT INTO gbl_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","જ્યા લોક માયેવોય બોરહો થોવતાહા ચ્યા યા મોઠે ચિન્હે કોઅરાહાટી સફળ ઓઅરી કા: મા નાંવ લેઈને બુતહાલ તાંગાડી કાડી, નોવી ભાષામાય બોલી, ");
INSERT INTO gbl_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","જોવે ચ્યા જેરીવાળા હાપડાહાંલ દોઅરી, તે હાપડેં ચ્યાહાન નુકસાન નાંય કોઅરી એને જેરબી પીઈ જાય તેરુ ચ્યાહાન કાય નુકસાન નાંય ઓઅરી, ચ્યા દુ:ખ્યાહાવોય આથ થોવિન ચ્યાહાન હારાં કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","પ્રભુ ઈસુ શિષ્યહાઆરે વાત કોઅયા પાછે, એને પોરમેહેરાય ઈસુલ હોરગામાય લેય લેદો, એને પોરમેહેરા જમણા આથા એછે માનાપાનાહાતે બોહી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","તોવે શિષ્યહાય બોદી જગ્યે જાયન લોકહાન હારી ખોબાર આખી, પોરમેહેરાય ચ્યાહાન મોદાત કોઅયી એને મોઠે ચમત્કાર કોઇન દેખાડયાં કા ચ્યા વાત હાચ્ચી હેય. આમેન.");
INSERT INTO gbl_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","માનનીય થેયોફીલુસ, બોજ લોકહાય આપે વોચમાય ઓઅલી ઘટનાહા બારામાય વર્ણન લોખાહાટી કોશિશ કોઅલી હેય. ");
INSERT INTO gbl_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ચ્યાહાય બરાબર તીંજ લોખ્યાં જીં આમહાન ચ્યા લોકહાકોય આખલા ગીઅલાં આતા, જ્યાહાય ઈસુ સેવા સુરુવાતપાઅને પોતે નોજરેકોય એઅયા એને પાછે પોરમેહેરા વચન આખનારા સેવાક બોની ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","યાહાટી ઓ માનનીય થીયોફિલુસ માયે બી યે ઘટનાહા બારામાય દિયાન દેયન અભ્યાસ કોઅયો એને માન ઈ હારાં ગોમ્યા કા આંય તોહાટી યો ઘટના સુરુવાતપાઅને લેયને ક્રમવારી લોખું. ");
INSERT INTO gbl_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","આંય ઈ યાહાટી કોઇ રિઅલો હેય, કા તુલ બોદી વાતહેબારામાય બોદા હાચ્ચાં ખોબાર પોડે, જીં લોકહાકોય તુલ આખલા ગીઅલાં હેય. ");
INSERT INTO gbl_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","જોવે હેરોદ રાજા યહૂદીયા વિસ્તારમાય રાજ્ય કોઇ રિઅલો આતો, ચ્યે સમાયે અબીયા યાજાકા ટોળામાઅને જખરિયા નાંવા યોક યાજક આતો, એને ચ્યા થેઅયે નાંવ એલીસાબેત આતી, તી બી ઈસરાયેલા પેલ્લો યાજક હારૂના કુળામાઅની આતી. ");
INSERT INTO gbl_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ચ્યે બેની જાંએ પોરમેહેરા નોજરેમાય ન્યાયી આતેં, એને પોરમેહેરા બોદી આગના એને નિયમાહાન દોષવોગાર પાળા આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","બાકી ચ્યાહા પોહેં નાંય આતેં, કાહાકા એલીસાબેત વાંયટી આતી, એને ચ્યે બેની ડાયેં ઓઈ ગીઅલે આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","યોક દિહી જોવે જખરિયા યેરૂસાલેમ શેહેરા દેવાળામાય પોરમેહેરા હામ્મે યાજકા રુપામાય સેવા કોઇ રિઅલો આતો, કાહાકા ચ્યા આઠવડયા ચ્યા ટોળા યાજકા સેવા કોઅના પાળી આતી. ");
INSERT INTO gbl_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","તોવે યાજકાહા રીતી ઇસાબે જખરિયા નાંવા ચિઠ્ઠી નિંગી, કા પ્રભુ દેવાળામાય જાયને ધુપ હોલગાડે. ");
INSERT INTO gbl_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","એને ધુપ હોલગાડના સમયે લોકહા બોદો ટોળો બાઆ દેવાળા બાઆમાય પ્રાર્થના કોઅતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ઓલહામાયજ પ્રભુ યોક હોરગા દૂત દુપવેદી જમણી એછે ઉબો રિઅલો જખરિયાલ દેખાયો. ");
INSERT INTO gbl_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","જખરિયા હોરગા દૂતાલ એઇન ગાબરાઈ ગીયો એને તો બોજ બિઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","બાકી હોરગા દૂતાય ચ્યાલ આખ્યાં, “ઓ જખરિયા, ગાબરાયેહે મા કાહાકા પોરમેહેર તો પ્રાર્થના વોનાયોહો, એને તો થેએ એલીસાબેત તુમહેહાટી યોક પોહાલ જન્મો દેઅરી, એને ચ્યા નાંવ તું યોહાન થોવજે. ");
INSERT INTO gbl_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","તુલ આનંદ મિળી એને તું ખુશ ઓઈ જાહે, એને બોજ માઅહે ચ્યા જન્મા લેદે ખુશ ઓઈ જાય. ");
INSERT INTO gbl_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","કાહાકા તો પ્રભુ નોજરેમાય મહાન ગોણાયી, તો નશા વાળો રોહો કા દારવા કોદહી નાંય પીયી, એને ચ્યા જન્મો ઓઅરા પેલ્લાજ તો પવિત્ર આત્માકોય બોઆલા રોય. ");
INSERT INTO gbl_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","તો ઈસરાયેલા બો બોદા લોકહાન ચ્યાહા પ્રભુ પોરમેહેરાએછે વાળી લેય યી. ");
INSERT INTO gbl_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","યોહાન યોક ઓહડો માઅહું રોય, જો ભવિષ્યવક્તા એલીયા આત્મા એને સામર્થ્ય ચ્યા આરે રોય, કા આબહા મોન પાહહા એછે ફેરાવી દી; એને તો પોરમેહેરા આગના નાંય માનનારા લોકહાન પોરમેહેરા જ્ઞાન કબુલ કોઆડી, એને લોકહાન પ્રભુહાટી તિયાર કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","જખરિયાય હોરગા દૂતાલ પુછ્યાં, “માન કેહેકેન યે વાતે ખાત્રી રોય? કાહાકા આંય ડાયો ઓઅઇ ગીયહો, એને મા થેએબી ડાયી ઓઅઇ ગીયહી.” ");
INSERT INTO gbl_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","હોરગા દૂતાય ચ્યાલ જોવાબ દેનો, “આંય ગાબરીયેલ દૂત હેતાંવ, આંય પોરમેહેરા આગલા ઉબો રોનારો હેતાઉ, તુલ ઈ વાત આખા એને ઈ હારી ખોબાર દાંહાટી ચ્યાય માન દોવાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","બાકી એએ, જ્યા દિહા લોગુ યો વાતો પુર્યો નાંય ઓઈ જાય, ચ્યા દિહા લોગુ તું ચુપ રોહે, એને બોલી નાંય હોકહે, કાહાકા તુયે મા વાતેહેવોય બોરહો નાંય કોઅયો જ્યો ચ્યે સમય પુર્યો ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","તાંઉ માઅહે જખરિયા વાટ એએઈ રોઅલે તો ઓલીબોદી વાઆ દેવાળામાય કાહા રિયો ચ્યા ચ્યાહાન નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","જોવે તો બાઆ યેનો, તોવે તો ચ્યાહાઆરે બોલી નાંય હોક્યો સેલ્લે ચ્યે માઅહે હોમજી ગીયે, કા દેવાળામાય ચ્યાલ દર્શાન દેનહા, એને તો ચ્યાહાન ઈશારો કોઇ રિઅલો આતો, બાકી મૂકો નોકીજ રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","જોવે દેવાળામાય યોક યાજકા રુપામાય ચ્યા સેવા કોઅના આઠવડયા પારવાયા, તોવે યેરૂસાલેમ માઅને જખરિયા ચ્યા ગોઓ જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","કોલહાક દિહહા પાછે ચ્યા થેએ એલીસાબેતે મોયના રિયા, એને ચ્યે કાદાલ નાંય આખ્યાં કા ચ્યે મોયના હેય, એને તી પાચ મોયના લોગુ ગોઅજ રોયી. ");
INSERT INTO gbl_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ચ્યે આખ્યાં, “પ્રભુય મા મોયના રા હાટી મોદાત કોઅયીહી, ચ્યાય માયેવોય દયા કોઅયી, એને લોકહામાય મા વાંયટી રોઅના લાજ આતી તી દુઉ કોઅયી.” ");
INSERT INTO gbl_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","જોવે એલીસાબેત છ: મોયના મોયનાવાળી ઓઈ ગીયી, તોવે પોરમેહેરાય ગાબરીયેલ હોરગા દૂતાલ ગાલીલ ભાગા નાજરેત ગાવામાય, ");
INSERT INTO gbl_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","યોક કુંવારીયેપાય દોવાડયો, ચ્યે માગણી દાઉદ રાજા કુળા યોસેફ નાંવા માટડાઆરે ઓઅલી આતી, ચ્યે કુંવારીયે નાંવ મરિયમ આતા. ");
INSERT INTO gbl_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","એને હોરગા દૂતાય ચ્યે પાહાય યેયન આખ્યાં, “ખુશી એને જય ઓએ તો, પોરમેહેરાય તુલ બોજ બોરકાત દેનલો હેય! પ્રભુ તોઆરે હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ચ્યા વાત વોનાઈન તી બોજ ગાબરાઈ ગિઇ, એને વિચાર કોઅરા લાગી કા ઈ કોહડી જાતી સલામ ઓરી? ");
INSERT INTO gbl_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","તોવે હોરગા દૂતાય ચ્યેલ આખ્યાં, “ઓ મરિયમ ગાબરાયેહે મા, કાહાકા પોરમેહેરા બોરકાત તોવોય જાયલી હેય. ");
INSERT INTO gbl_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","એએ, તું મોયનાવાળી રોહે એને તું યોક પોહાલ જન્મો દેહે, ચ્યા નાંવ તું ઈસુ થોવજે. ");
INSERT INTO gbl_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","તો મહાન માઅહું બોની, એને પરમપ્રધાન પોરમેહેરા પોહો આખાયી, પ્રભુ પોરમેહેર ચ્યા આગલ્યો ડાયો દાઉદ રાજા હારકો બોની. ");
INSERT INTO gbl_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","એને તો ઈસરાયેલ લોકહાવોય સાદા રાજ કોઅરી, તો સાદામાટે રાજા રુપામાય રાજ્ય કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","મરિયમે હોરગા દૂતાલ આખ્યાં, “ઈ કેહેકેન ઓઅરી? મા તે કાદા માટડાઆરે વોરાડ બી નાંય જાયહાં.” ");
INSERT INTO gbl_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","હોરગા દૂતાય જાવાબ દેનો કા, “પોરમેહેરા પવિત્ર આત્મા તો ઉપે ઉતી, પરમપ્રધાન પોરમેહેરા સામર્થ્ય તો ઉપે છાવાડો કોઅરી, ચ્યાહાટી તોપાઅને જન્મો લેનારો પોહો પવિત્ર ઓઅરી, તો પોરમેહેરા પોહો આખાયી. ");
INSERT INTO gbl_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","એને વોનાય, તો હોગવાડયાહા માઅની એલીસાબેતેલ બી ચ્યે ડાઆયાપોણામાય મોયના રીઅલા હેતા, એને જ્યેલ વાંયટી આખે, ચ્યે આમી ઓ છઠો મોયનો ચાલહે. ");
INSERT INTO gbl_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","કાહાકા પોરમેહેરાકોય બોદાંજ બોની હોકહે.” ");
INSERT INTO gbl_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","મરિયમે આખ્યાં, “એએ, આંય પ્રભુ દાસી હેત્યાંવ, જેહેકેન તુયે આખ્યાં તેહેકેન મા આરે ઓઅય” પાછે હોરગા દૂત ચ્યે પાયને જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","કોલહાક દિહાહા મરિયમ તિયાર ઓઇન ઉતવાળે કોઅઈન યહૂદીયા વિસ્તારા ડોગાલાવાળા ભાગામાય યોકા ગાવામાય ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","એને જખરિયા ગોઅમે જાયન ચ્યે એલીસાબેતેલ સલામ આખી. ");
INSERT INTO gbl_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","જોવે એલીસાબેતેલ મરિયમે સલામ આખ્યાં, તોવે ચ્યે બુકામાય ચ્યે પોહો ઉસળ્યો એને એલીસાબેત પવિત્ર આત્માકોય બોઆય ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","એને મોઠેરે આખતી લાગી કા, “બોદયે થેએયેહેમાય તું ધન્ય હેય, એને તું જ્યા પોહાલ જન્મો દેહે તો ધન્ય હેય! ");
INSERT INTO gbl_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","આંય તુલ ઈહીં એઇન પોતાલ બોરકાતવાળી હોમજુહું, કા મા પ્રભુ આયહો માન મિળાં યેનહી. ");
INSERT INTO gbl_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","કાહાકા એએ, જોવે માયે તો સલામે આવાજ વોનાયી, તોવે તારાત મા પોહો મા બુકામાય આનંદમાય જાયો. ");
INSERT INTO gbl_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","તું ધન્ય હેય કાહાકા તુયે બોરહો કોઅયો કા પ્રભુવાય જીં તુલ આખ્યાં તી તો પુરાં કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","તોવે મરિયમે આખ્યાં, મા જીવ પોરમેહેરા સ્તુતિ કોઅતો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","એને મા આત્મા પોરમેહેર, મા તારણારામાય આનંદિત જાયા. ");
INSERT INTO gbl_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","કાહાકા ચ્યે માયેવોય, ચ્યા દાસી ગોરીબી વોય નોજાર કોઅયી, યાહાટી એએજા, આમીને બોદ્યો પીડ્યો માન બોરકાતવાળી આખરી. ");
INSERT INTO gbl_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","કાહાકા ચ્યા બળવાન પોરમેહેરાય માંહાટી મોઠે કામે કોઅયેહે; એને ચ્યા નાંવ પવિત્ર હેય. ");
INSERT INTO gbl_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ચ્યા દયા ચ્યા બિખ રાખનારા લોકહાવોય પેડયે પાઠી પેડી બોની રોહે. ");
INSERT INTO gbl_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","તો ચ્યા મહાન સામર્થ્યા ઉપયોગ મોઠે કામે કોઅરાહાટી કોઅલા હેય, એને ચ્યાય અભિમાન્યાહાન તીતર-ભીતર કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ચ્યાય શાસન કોઅનારાહા શાસન કોઅના ઓદિકાર લેય લેદો, એને ગોરીબાહાન ઉચા કોઅલા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ચ્યાય બુખ્યહાન હારી વસ્તુકોય દારાયે તાંવ લોગુ ખાવાડ્યા એને મિલકાતવાળહાન રીતે આથે કાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ચ્યાય પોતાના આગલ્યા ડાયહા પ્રતિ ચ્યા વાયદાલ યાદ કોઅયા એને ચ્યા સેવક, ઈસરાયેલા લોકહા મોદાત કોઅરાહાટી યેનહો. ");
INSERT INTO gbl_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ચ્યાય આબ્રાહામાલ એને ચ્યા પીડીલ સાદામાટે દયા કોઅરાહાટી વાયદાલ પુરાં કોઅયાહાં! ");
INSERT INTO gbl_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","મરિયમ લગભગ એલીસાબેત આરે તીનખાન મોયના રોઇન ગોઓ પાછી વોળી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","તોવે એલીસાબેત પોહાલ જન્મો દેયના સમય યેનો, એને ચ્યેય પોહાલ જન્મો દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","એલીસાબેતે આહીપાહીને એને હોગવાડ્યે ઈ એઇન, કા પ્રભુય ચ્યેવોય મોઠી દયા કોઅયીહી, તોવે ચ્યે બી આનંદિત જાયે. ");
INSERT INTO gbl_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","આઠમે દિહી ચ્યે પોહા સુન્નત કોઅરા યેને, ચ્યે ચ્યા નાંવ ચ્યા આબહા નાવાહારકા જખરિયા થોવા આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","તોવે ચ્યા આયહો એલીસાબેતેય જવાબ દેનો, “નાંય; બાકી યા નાંવ યોહાન થોવલાં જાય.” ");
INSERT INTO gbl_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","એને લોકહાય ચ્ચેલ આખ્યાં, “તુમહે કુટુંબમાય ઓહડા નાંવ કાદા નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","પાછે ચ્યાહાય ચ્યા આબહાલ ઈશારો કોઇન પુછ્યાં કા તું યા નાંવ કાય થોવા માગતોહો? ");
INSERT INTO gbl_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","તોવે ચ્યે યોક લોખના પાટી લેય હાદાડી એને લોખ્યાં, “ચ્યા નાંવ યોહાન હેય” એને બોદા લોક નોવાય પામ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","એને જખરિયા જીબે બંધન ખુલી ગીયા, એને તો પોરમેહેરા સ્તુતિ કોઅતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","આહી પાહી વાળે બોજ લોક બિઇ ગીયે, એને યહૂદીયા વિસ્તારા બોદા ડોગાલાવાળા ભાગામાય બોદયે વાતહે ખોબાર પોડી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","જ્યેં માઅહે વોનાયે ચ્યે વિચાર કોઅરા લાગ્યેં, “ઓ પોહો કોહડો ઓઅરી?” કાહાકા હાચ્ચાંજ ચ્યાઆરે પ્રભુ સામર્થ્ય હેય. ");
INSERT INTO gbl_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ચ્યા આબહો જખરિયા પવિત્ર આત્માકોય બોઆય ગીયો, એને ભવિષ્યવાણી કોઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“પ્રભુ ઈસરાયેલા પોરમેહેરા સ્તુતિ કોઅરા, કાહાકા ચ્યે ચ્યાહા લોકહાન મોદાત કોઅરા એને ચ્યાહાન બોચાવી લેદહા. ");
INSERT INTO gbl_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","એને ચ્યા સેવક, દાઉદ રાજા કુળામાંય આપેહાટી યોક ગોતીવાળો તારણારો દોવાડલો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","71","બોજ પેલ્લા, પોરમેહેરાય ચ્યા ભવિષ્યવક્તાકોય આખલા આતા. તો આપહાન આપહે દુશ્માનાહા એને ચ્યે બોદયે ગોત્યેથી બોચાવી જ્યેં આપહે આરી આડાઇ કોઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","આગલ્યા ડાયહાવોય દયા કોઇન ચ્યા પવિત્ર કરાર પુરો કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","એને તો વાયદા જો ચ્યાય આપહે આગલ્યો ડાયો આબ્રાહામાઆરે કોઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","કા તો આપહાન આપહે દુશ્માનાહા આથામાયને બોચાવીન. ");
INSERT INTO gbl_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","કા ચ્યા હોમ્મે પવિત્રતા એને ન્યાયપણામાય દાક વોગાર રોયન બોદી જીંદગી ચ્યા સેવા કોઇ હોકજે. ");
INSERT INTO gbl_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","એને તું મા પાહા, તું પરમપ્રધાન પોરમેહેરા ભવિષ્યવક્તા આખાયેહે, કાહાકા તું પ્રભુવા વાટ તિયાર કોઅરાહાટી પ્રભુવા આગલા-આગલા ચાલહે. ");
INSERT INTO gbl_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","કા તો ચ્યા લોકહા પાપહા માફ કોઅનાકોય ચ્યાહા તારણા બારામાય જ્ઞાન દી. ");
INSERT INTO gbl_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ઈ આપહે પોરમેહેરા મોઠી દયાકોય ઓઅરી, એને ચ્યાહાટી જેહેકોય દિહી આપહાન ઉજવાડો દાંહાટી ચોમકેહે, તેહેકોય ખ્રિસ્તબી આપહેપાય હોરગામાઅને યી. ");
INSERT INTO gbl_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","આંદારામાય (પાપમાય જીવનારા)એને મોઅના તકમાય બોહનારાહાલ ઉજવાડો દે, ઓ ઉજવાડો આપહાન ચ્યા જીવનામાય સલહા દી, જો આપહાન પોરમેહેરાઆરે શાંતી દેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","એને તો બાળાક યોહાન, મોઠો ઓઅતો ગીયો એને આત્મામાય બળવાન ઓઅતો ગીયો એને તો ઈસરાયેલ લોકહાવોચમાય હિકાડના દિહા લોગુ ઉજાડ જાગામાય રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ચ્યા દિહયા માય કૈસર ઓગુસ્તુસાય આગના દેની કા રોમી સામ્રાજ્યા રોનારા બોદા લોકહા નાવનોંદણી કોઅલી જાય. ");
INSERT INTO gbl_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ઈ પેલ્લી નાવનોંદણી આતી, જોવે ક્વીરીનીયુસ સિરીયા વિસ્તારા રાજા આતો. ");
INSERT INTO gbl_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","બોદે માઅહે પોતપોતાના વોતની ગાવહામાય નાંવ લોખાડા હાટી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","યોસેફ દાઉદા કુળામાઅને એને કુટુંબમાઅને આતો ચ્યાહાટી ગાલીલ ભાગા નાજરેત ગાવામાઅને યહૂદીયા વિસ્તારમાય દાઉદ રાજા શેહેર બેથલેહેમમાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","યોસેફ પવિત્ર આત્માકોય મોયના રિઅલી ચ્યા થેએ મરિયમે આરે નાંવ લોખાડા ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","7","જોવે ચ્યે બેથલેહેમમાય આતેં, તે ચ્યાહાન ચ્યા જાગે રા હાટી જાગો નાંય મિળ્યો જાં મુસાફીર રોતે આતેં, યાહાટી ચ્યે યોકા ડોગરાહા ગોઠામાય રિયે. જોવે મરિયમે પોહાલ જન્મો દેયના સમય યેનો, તોવે ચ્યેય તાં ચ્યાહા પેલ્લા પોહાલ જન્મો દેનો, ચ્યાહાય ચ્યાલ ફાડકામાય ચોંડાળીન ગોવાંયીમાય થોવ્યો, જાં ડોગરાહાલ ચારો ટાકતેહેં. ");
INSERT INTO gbl_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ચ્યા ભાગામાય કોલહાક મેંડવાળ્યા લોક આતા, જ્યા રાતી દાદરામાય ચ્યાહા ગેટેં ટોવેત. ");
INSERT INTO gbl_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","તોવે અચાનક પ્રભુ યોક હોરગા દૂત ચ્યાહાન દેખાયો, એને ચ્યાહા ચોમખી પ્રભુ ઉજવાડો ચોમકા લાગ્યો, એને ચ્યા ઈ એઇન બોજ બિઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","તોવે હોરગા દૂતાય ચ્યાહાન આખ્યાં, “બીયહા મા વોનાયા આંય તુમહાન બોજ આનંદા હારી ખોબાર આખતાહાવ, જીં બોદા લોકહાહાટી ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","કા આજે બેથલેહેમ ગાવામાય મતલબ દાઉદ રાજા ગાવામાય તુમહાન તારણારો જોનમ્યોહો, તોજ ખ્રિસ્ત પ્રભુ હેય. ");
INSERT INTO gbl_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","યે વાતે સાબિતી ઈ હેય કા ઓ તોજ પોહો હેય એહેકેન વોળખાં હાટી તુમહાન ઈ નિશાણી હેય, કા તુમા યોક પાહાલ ફાડકામાય ચોંડાળીન ગોવાંયેમાય હુવાડલાં એઅહા.” ");
INSERT INTO gbl_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","અચાનક ચ્યા હોરગા દૂતા આરે હોરગ્યા દૂતહા ટોળો પોરમેહેરા સ્તુતિ કોઅતા એને ઈ આખતા દેખાયાં, ");
INSERT INTO gbl_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“હોરગામાય પોરમેહેરા મહિમા, એને દોરત્યેવોય ચ્ચા માઅહાવોય પ્રસન્ન હેય ચ્ચા લોકહાન શાંતી આખા.” ");
INSERT INTO gbl_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","જોવે હોરગા દૂત ચ્યાહા દેખાતા હોરગામાય પાછા જાતા રિયા, તોવે મેંડવાળ્યા લોક યોકબિજાલ આખતા લાગ્યા કા, “ચાલા, આપા બેથલેહેમ જાતા, એને ઈ જીં વાત બોની ગીયી, એને ચ્ચાહાન પ્રભુ આપહાન આખીહી, તી એરા જાતા.” ");
INSERT INTO gbl_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ચ્યાહાય તારાત જાયને મરિયમ એને યોસેફાલ એને ગોવાંયીમાય ચ્યા પાહાલ હુવાડલો દેખ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ચ્યાલ એઅયા પાછે, ચ્યાહાય તી વાત, જીં હોરગા દૂતહાય પાહા બારામાય આખ્યેલ તી આખી દેના. ");
INSERT INTO gbl_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ચ્ચે બોદે જ્યાહાય મેંડવાળ્યાહા વાત વોનાયે ચ્ચે નોવાય પામ્યે. ");
INSERT INTO gbl_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","બાકી મરિયમ યો બોદ્યો વાતો પોતે મોનામાય રાખીન ચ્યાહા ઉપે વિચાર કોઅતી રોયી. ");
INSERT INTO gbl_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","પાછે મેંડવાળ્યા લોક પોતે જીં કાય હોરગ્યા દૂતહાય આખલા આતા, તેહેકોયજ બોદા વોનાયને એને એઇન પોરમેહેરા મહિમા એને ગીતે આખતા પાછા વોળી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","બાળાક ઈસુ જન્મા આઠ દિહી પાછે, પોહા સુન્નત કોઅના દિહી યેના તોવે ચ્યા નાંવ ઈસુ થોવ્યો, ઈ નાંવ ચ્યા આયહે બુકામાય યા પેલ્લાજ હોરગા દૂતાય આખ્યેલ. ");
INSERT INTO gbl_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","24","જોવે મૂસા નિયમશાસ્ત્ર પરમાણે મરિયમે એને યોસેફા ચોખ્ખાં ઓઅના દિહી પુરાં ઓઅઇ ગીઅલા આતા, તોવે ચ્ચે યેરૂસાલેમ શેહેરા દેવાળામાય બેન કબુતરા પીલકે બલિદાન ચોડવા ગીયે. ઈ પ્રભુવા નિયમ પાળાહાટી આતા. ચ્ચે ઈસુવા આરી યેરૂસાલેમમાય બી ગીયે કા ચ્ચાલ પ્રભુવા હામ્મે રજુ કોએ કાહાકા પ્રભુવા નિયામ ઇબી આખહે કા, બોદહા પેલ્લો જોન્મુલો પોહો પ્રભુહાટી પવિત્ર ઓઅરાહાટી આલાગ કોઅરા જોજે. ");
INSERT INTO gbl_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ચ્યે સમાયે યેરૂસાલેમ શેહેરામાય સિમોન નાંવા યોક માટડો આતો, તો ન્યાયી એને પોરમેહેરા દાક રાખે, એને ખ્રિસ્ત કોવે યેયન ઈસરાયેલા લોકહાન શાંતી દી તો વાટ એઅતો રિયો, એને ચ્યાઆરે પવિત્ર આત્મા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","એને પવિત્ર આત્માય ચ્યાલ આખ્યાં કા, “પ્રભુ ખ્રિસ્તાલ એઅયા વોગાર તું નાંય મોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ચ્યે દિહી પવિત્ર આત્મા સલહા કોય તો દેવાળામાય યેનો જોવે ઈસુવા આયહો આબહો નિયમશાસ્ત્ર પરમાણે ચ્યા વિદ્યેહેલ પુરાં કોઅરાહાટી ઈસુવાલ દેવાળામાય લેય યેને. ");
INSERT INTO gbl_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","તોવે સિમોનાય ઈસુ બાળાકાલ આથામાય લેઈને પોરમેહેરા આભાર માનતા ચ્યે આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ઓ પ્રભુ, આમી તું તો સેવકાલ તો કોઅલા વાયદાનુસાર શાંતીકોય મોરાં દે. ");
INSERT INTO gbl_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","કાહાકા માયે ચ્યા તારણારાલ એઅઇ લેદલો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","જ્યાલ તુયે બોદા લોકહાન તારણાહાટી દોવાડલો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ચ્યા ગેર યહૂદી લોકહાન પોરમેહેરાબારામાય આખનારો ઉજવાડો ઓઅરી, એને તો નિવાડલા લોક ઈસરાયેલા મહિમા ઓએ.” ");
INSERT INTO gbl_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ઈસુ આયહો એને આબહાલ પોહા બારામાય સિમોનાય જીં આખ્યાં, તી વોનાઈન બોજ નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","તોવે સિમોનાય ચ્યાહાન બોરકાત દેની એને મરિયમેલ આખ્યાં, “એએ, ઈસરાયેલા લોકહામાય બોજ માઅહે નાશ ઓઅઇ જાય, એને બોજ બોચી જાય, ચ્યાહાટી ઓ પોહો ચેતાવણી નિશાણી રોય કા, ચ્યા બોજ લોક વિરુદ કોઅરી, એહેકોયન બોજ લોકહા મોના વિચાર ઉગાડા પોડી જાય. ");
INSERT INTO gbl_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","એને બોજ મોઠા દુઃખ, યોક તારવાય હારકા તો જીવામાય બી આર-પાર વિંદાય જાય.” ");
INSERT INTO gbl_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","એને આશેરા કુળામાઅને હાન્ના નાંવા ફનુએલા પોહી યોક ભવિષ્યવક્તીન આતી, તી બોજ ડાયી આતી, એને વોરાડ ઓઇન હાંત વોરહે લોગુ માટડાઆરે રોઅલી આતી. ");
INSERT INTO gbl_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","એને તી ચોર્યાશી વોરહે લોગુ વિધવા આતી, દેવાળામાય બોજ સમય લોગુ રોઇન રાતદીહી ઉપહા એને પ્રાર્થના કોઈકોઈન પોરમેહેરા ભક્તિ કોઅતી આતી. ");
INSERT INTO gbl_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","એને તી ચ્યેજ સમયે તાં યેયન પોરમેહેરા આભાર માન્યા, ચ્યા બોદહા આરી જ્યેં યેરૂસાલેમ શેહેરા લોકહાન તારણાહાટી ખ્રિસ્તાલ દોવાડાહાટી પોરમેહેરા વાટ એએઈ રીઅલે આતેં, તી ચ્યા પોહા બારામાય વાતો કોઅરા લાગી. ");
INSERT INTO gbl_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","જોવે યોસેફ એને મરિયમ નિયમશાસ્ત્રા પરમાણે જીં કાય કોઅના આતા તી બોદા પુરાં કોઇન પાછે ચ્યા ગાલીલ ભાગામાય ચ્યાહા વોતની ગાંવ નાજરેત પાય વોળી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","એને બાળાક મોઠો ઓઅતો, એને બળવાન ઓઅતો, એને બુદ્ધિકોય બોઆતો ગીયો, એને પોરમેહેરા સદા મોયા ચ્યાવોય આતી. ");
INSERT INTO gbl_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ઈસુવા આયહો આબહો દર વોરહે પાસ્કા સણામાય યેરૂસાલેમ શેહેરામાય જાયા કોએત. ");
INSERT INTO gbl_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","જોવે ઈસુ બાર વોરહા જાયો, તોવે સણા રીતી પરમાણે યેરૂસાલેમ ગીયે. ");
INSERT INTO gbl_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","એને જોવે યોસેફ એને મરિયમ સણ વાળીન ચ્યે પાછે ગોઓ જાં ચાલ પોડયે, તોવે બાળાક ઈસુ યેરૂસાલેમ શેહેરામાય રોઈ ગીયો, એને ચ્યા આયહે આબહાલ ઈ ખોબાર નાંય આતી. ");
INSERT INTO gbl_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ચ્યે ઈ હોમજીન, ઈસુ હાંગાત્યાહામાય ઓરી, ચ્યે યોક દિહા વાટ ચાલી યેને, એને ચ્ચાલ હોગવાડયાહા એને વોળખાત્યાહામાય હોદતે લાગ્યેં. ");
INSERT INTO gbl_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","જોવે ઈસુ નાંય મિળ્યો તોવે ચ્યાલ હોદતે-હોદતે યેરૂસાલેમ શેહેરામાય પાછે વોળી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","એને તીન દિહહયા પાછે તો ચ્યાહાન દેવાળા બાઆપુર મૂસા નિયમ હિકાડનારા ગુરુહુ આરે બોહીન, ચ્યાહા તો વોનાય એને સવાલ પુછતા મિળ્યો, ");
INSERT INTO gbl_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","એને જોલા લોક ઈસુ વોનાતા આતા, ચ્યા બોદા ચ્યા હોમાજ એને જવાબાહા કોય નોવાય પામી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ચ્યાલ એઇન ચ્યા આયહે આબહાલ બોજ નોવાય લાગી ચ્યા આયહે ચ્યાલ પુછ્યાં, “ઓ પાહા, તુયે આમહે આરે એહેકોય કાહા કોઅયા? તો આબહો એને આંય તુલ હોદતે હેરાન ઓઈ ગીયહેં.” ");
INSERT INTO gbl_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ચ્યે ચ્યાહાન આખ્યાં, “તુમા માન કાય કોઅરા હોદેત? તુમહાન માલુમ નાંય આતા, કા આંય મા આબહા ગોઅમેજ ઓરા જોજે?” ");
INSERT INTO gbl_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","બાકી જીં વાત ઈસુવાય ચ્યાહાન આખી ચ્યા મતલબ ચ્યે નાંય હુમજી હોક્યે. ");
INSERT INTO gbl_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ચ્યાહાઆરે ઉતીન તો નાજરેત યેનો એને ચ્યાહા તાબે રિયો ચ્યા આયહે યો બોદ્યો વાતો મોનામાય રાખ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","એને ઈસુ બુદ્દિ માય એને શરીરમાય એને પોરમેહેરા એને માઅહા સદા મોયામાય મોઠો ઓઅતો ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","રોમી કૈસર તીબીરીયુસ રાજ્યા પંદરમાં વોરહામાય, જોવે પંતય પિલાત યહૂદીયા વિસ્તારા રાજા આતો, હેરોદ રાજા ગાલીલ ભાગા રાજા આતો, તોવે ચ્યા બાહા ફિલિપ, ઈતૂરેયા એને ત્રખોનીતિસ વિસ્તારા રાજા આતો, એને લિસાનિયાસ, અબીલેને વિસ્તારા રાજા આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","એને જોવે હન્ના એને કાયફાસ મહાયાજક આતા, ચ્યે સમાયે પોરમેહેરા વચન ઉજાડ જાગામાય જખરિયા પોહો યોહાનાલ મિળ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","એને તો યારદેન નોયે આહેપાહેને બોદા વિસ્તારામાય ફિરીન ઈ પ્રચાર કોઆ લાગ્યો, પાપ કોઅના છોડી દા એને બાપતિસ્મા લા, કા પોરમેહેર તુમહે પાપહા માફ કોઇ દી. ");
INSERT INTO gbl_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","જેહેકોય યશાયા ભવિષ્યવક્તા ચોપડયેમાય લોખલાં હેય: “ઉજાડ જાગામાય કાદો તેરી બોંબલીન એહેકોય આખહે કા, પ્રભુ યેયના વાટ તિયાર કોઆ, ચ્યો વાટયો હિદ્યો કોઆ. ");
INSERT INTO gbl_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","યોકા-યોક ખાડા બોઈ દેવામાય યી, એને યોકા-યોકા ડોગા એને ડોગાલ્યો નિચ્ચો કોઅલ્યો જાય, એને જીં વાકડા હેય તી હિદા, એને જીં ખાડા ટેકરા વાળી વાટ હેય તી હારકી વાટ બોની. ");
INSERT INTO gbl_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","એને બોદે માઅહે પોરમેહેરા પાયને દોવાડલો તારણ કોઅનારાલ એઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","જીં ગીરદી યોહાનાપાય બાપતિસ્મા લાંહાટી યેની, યોહાને ચ્યાહાન આખ્યાં, ઓ હાપડા હારકા જેરીવાળા લોકહાય, તુમહાન કુંયે ચેતાવણી દેની કા યેનારા ન્યાય માય તુમા બોચી જાં? ");
INSERT INTO gbl_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","યાહાટી એહેકેન જીવા કા લોકહાન ખોબાર પોડે તુમાહાય પાપ કોઅના બંદ કોઅઇ દેનહા. એને પોતે મોનામાય એહેકોય નાંય વિચાર કોઅના કા આબ્રાહામ આપહે આબહો હેય; બાકી આંય તુમહાન એહેકોય આખતાહાવ કા, પોરમેહેર આબ્રાહામાહાટી યા દોગડાહા પાયને બી પોહેં પૈદાહા કોઅઇ હોકહે. ");
INSERT INTO gbl_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","જેહેકોય યોક કુરાડાવાળો હારેં ફળે નાંય દેનારા હર યોક મુળથી જાડાહાલ ખાંડીન આગડામાય ટાકી દાંહાટી તિયાર હેય, તેહેકોયનુજ આમી પોરમેહેર ચ્યાહા ન્યાય કોઅરાહાટી તિયાર હેય, જો પાપ કોઅના બંદ નાંય કોએ. ");
INSERT INTO gbl_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","તોવે લોકહાય ચ્યાલ પુછ્યાં કા, “પોરમેહેરા ડોંડ પાયને બોચાંહાટી આમા કાય કોઅજે?” ");
INSERT INTO gbl_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","તોવે ચ્યે ચ્યાહાન જાવાબ દેનો કા, “જ્યા પાય બેન ડોગલેં હેતેં, તો જ્યા પાય કાય નાંય મીળે ચ્યાલ યોક ડોગલાં દેય, એને જ્યાપાંય ખાઅના હેય તોબી એહકોયજ કોએ.” ");
INSERT INTO gbl_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","કર લેનારા બી ચ્યા આથે બાપતિસ્મા લાંહાટી ચ્યાપાય યેના, એને ચ્યાહાય ચ્યાલ પુછ્યાં કા, “ઓ ગુરુ, આમા કાય કોઅજે?” ");
INSERT INTO gbl_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ચ્યે ચ્યાહાન આખ્યાં, “સરકારે જીં નોક્કી કોઅલા હેય ચ્ચા કોઅતા વોદારે કર નાંય લેઅના.” ");
INSERT INTO gbl_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","સીપાડાહાય બી ચ્યાલ પુછ્યાં, “આમા કાય કોઅજે?” ચ્યાહાન ચ્યે આખ્યાં, “કાદાપાઅને બોળ જબરી થી પોયહા નાંય લેયના, એને કાદાલબી જુઠો દોષ નાંય લાવના, એને પોતાના પાગારમાય ખુશ રોઅના.” ");
INSERT INTO gbl_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","લોકહામાય ખ્રિસ્તા વેલ્લા યેયના મોઠી આશા પૈદાહા ઓઅઇ ગિઇ, એને યોહાના બારામાય મોનામાય ચ્યા વિચાર કોઅતા લાગ્યા કા, “કાય ઓજ ખ્રિસ્ત નાંય ઓરી?” ");
INSERT INTO gbl_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","તોવે યોહાને ચ્યા બોદહાન જાવાબ દેનો કા “આંય તે પાઆયાકોય તુમહાન બાપતિસ્મા દેતહાવ, બાકી જો યેનારો હેય, તો મા કોઅતો મહાન હેય, આંય તે ચ્યા ચાકાર બોનીન ચ્યા ખાઅડા હુતળી છોડાબી લાયક્યે નાંય હેય, એને તો તુમહાન પવિત્ર આત્મા એને આગડાકોય બાપતિસ્મા દેઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ચ્યા હૂપડાં, ચ્યા આથામાય હેય, એને તો ચ્યા ખોળાં હારેકોય ચોખ્ખાં કોઅરી, એને ચ્યા ગોંવ તો કોઠારામાય બેગા કોઅરી, બાકી બુહટા નાંય ઉલાય ઓહડા આગડામાય ટાકીન હોલગાડી દી.” ");
INSERT INTO gbl_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","એને તો બોજ જાત્યા હિકાડના હિકાડી-હિકાડીન લોકહાન હારી ખોબાર દેતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","હેરોદ રાજાલ ચ્યા બાહા થેએ હેરોદિયાસ રાણ્યે બારામાય જ્યેલ હેરોદ રાજે પોતાની થેએ બોનાવી લેદેલ એને બોદા જુઠા કામહા બારામાય યોહાન બાપતિસ્મા દેનારાય ચ્યા બુલ ચ્યાલ દેખાડી, ");
INSERT INTO gbl_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ચ્યાહાટી હેરોદે બોદા ગુનાહા થી ઓ ગુનો બી કોઅયો, કા ચ્યે યોહાન બાપતિસ્મા દેનારાલ દોઇન જેલેમાય કોંડાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","જોવે બોદા લોકહાય બાપતિસ્મા લેદા, એને ઈસુ બી બાપતિસ્મા લેયને પ્રાર્થના કોઅતો આતો, તોવે આકાશ ઉગડી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","એને પવિત્ર આત્મા શરીરા રુપ લેઈને કબુતરા હારખા ચ્યાવોય ઉત્યા, એને હોરગામાઅને પોરમેહેરાય ઈસુલ આખ્યાં કા, “તું મા પ્રિય પોહો હેતો, તોથી આંય ખુશ હેતાંવ.” ");
INSERT INTO gbl_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","જોવે ઈસુ હિકાડાં લાગ્યો તોવે તો આસરે તીહી વોરહા આતો, માઅહે ચ્યાલ યોસેફા પોહો આખે, યોસેફ એલી પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","એલી મત્તાતા પોહો આતો, મત્તાત લેવીયા પોહો આતો, લેવી મલકી પોહો આતો, મલકી યન્નાયા પોહો આતો, યન્ના યોસેફા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","યુસુફ મત્તીયા પોહો આતો, મત્તીયા આમોસા પોહો આતો, આમોસ નાહુમા પોહો આતો, નાહુમ અસલ્યા પોહો આતો, અસલ્યા નગ્ગયા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","નગ્ગયા માત પોહો આતો, માત મત્તીયા પોહો આતો, મત્તીયા શિમી પોહો આતો, શિમી યોસેખા પોહો આતો, યોસેખ યોદા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","યોદા યોહાના પોહો આતો, યોહાન રેસા પોહો આતો, રેસા ઝરુબાબેલા પોહો આતો, ઝરુબાબેલ શાલતીયેલા પોહો આતો, શાલતીયેલ નેરી પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","નેરી મલકી પોહો આતો, મલકી અદ્દી પોહો આતો, અદ્દી કોસામા પોહો આતો, કોસામ એલ્માદામા પોહો આતો, એલ્માદામા એરા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","એર યેશુ પોહો આતો, યેશુ એલીએજારા પોહો આતો, એલીએજાર યોરીમા પોહો આતો, યોરીમ મત્તાતા પોહો આતો, મત્તાત લેવીયા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","લેવી સિમોના પોહો આતો, સિમોન યહૂદા પોહો આતો, યહૂદા યોસેફા પોહો આતો, યોસેફ યોનાના પોહો આતો, યોનાન એલ્યાકીમા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","એલ્યાકીમ મલેયા પોહો આતો, મલેયા મિન્ના પોહો આતો, મિન્ના મત્તાતા પોહો આતો, મત્તાત નાતાના પોહો આતો, નાતાન દાઉદ રાજા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","દાઉદ યિશૈ પોહો આતો, યિશૈ ઓબેદા પોહો આતો, ઓબેદ બોઆજા પોહો આતો, બોજ સલમોના પોહો આતો, સલમોન નહશોના પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","નહાશોન અમીનાદાબા પોહો આતો, અમીનાદાબ અરનીયા પોહો આતો, અરનીયા હેસ્રોના પોહો આતો, હેસ્રોન પેરેસા પોહો આતો, પેરેસ યહૂદા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","યહૂદા યાકૂબા પોહો આતો, યાકૂબ ઈસાકા પોહો આતો, ઈસાક આબ્રાહામા પોહો આતો, આબ્રાહામ તેરા પોહો આતો, તેર નાહોરા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","નાહોર સરૂગા પોહો આતો, સરુગ રઉં પોહો આતો, રઉં પેલેગા પોહો આતો, પેલેગ એબેરા પોહો આતો, એબેર તો શેલા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","શેલા કેનાના પોહો આતો, કેનાન અરફક્ષદા પોહો આતો, અરફક્ષદ શેમા પોહો આતો, શેમ નોહા પોહો આતો, નોહો લામેખા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","લામેખ મથુશેલા પોહો આતો, મથુશેલ હનોખા પોહો આતો, હનોખ યારેદા પોહો આતો, યારેદ મહાલાલેલા પોહો આતો, મહાલાલેલ કેનાના પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","કેનાન અનોસા પોહો આતો, અનોસ શેથા પોહો આતો, શેથ આદામા પોહો આતો, આદામ પોરમેહેરા પોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","પાછા ઈસુ પવિત્ર આત્માકોય બોઆયને, યારદેન નોયે પાયને ફિરી યેનો, એને પવિત્ર આત્માકોય ચાળહી દિહી લોગુ ઉજાડ જાગામાય ફિરતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","એને ચાળહી દિહી સૈતાનાય ઈસુ પરીક્ષા કોઅયી, ચ્યા દિહાહામાય ઈસુય કાય નાંય ખાદાં એને જોવે દિહી પુરાં ઓઅયા, તોવે ઈસુલ બુખ લાગી. ");
INSERT INTO gbl_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","એને સૈતાનાય ચ્યાપાય યેયન ચ્યાલ આખ્યાં, “જો તું પોરમેહેરા પોહો ઓરી, તોવે આગના દેયને સાબિત કોઅઇ દે કા યા દોગડા બાખે બોની જાય કા તું ચ્યેહેલ ખાય હોકે.” ");
INSERT INTO gbl_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ઈસુય ચ્ચાલ જાવાબ દેનો કા, “પવિત્રશાસ્ત્રમાય લોખલાં હેય, કા માઅહું કેવળ બાખ્યે કોયજ નાંય જીવે.” ");
INSERT INTO gbl_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","તોવે સૈતાન ચ્યાલ લેય ગીયો એને યોક ગેડીમાય ચ્યાલ દુનિયામાયને બોદે રાજ્યે દેખાડયે. ");
INSERT INTO gbl_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","એને સૈતાનાય ઈસુલ આખ્યાં, “આંય ઓ બોદો ઓદિકાર એને ઈ બોદી સુંદરતા તુલ દિહી, કાહાકા ઈ બોદા માન હોપલા હેય, એને જ્યાલ દાં માગુ ચ્યાલ દેય હોકહુ. ");
INSERT INTO gbl_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","યાહાટી, જો તું મા પાગે પોડીન ભક્તિ કોઅહે તે ઈ બોદાંજ તોજ ઓઅઇ જાય.” ");
INSERT INTO gbl_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ઈસુવે જાવાબ દેનો કા, “પવિત્રશાસ્ત્રમાય લોખલાં હેય: તું પ્રભુ આપહે પોરમેહેરા પાગે પોડ એને કેવળ ચ્યાજ સેવા કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","પાછે સૈતાન ચ્યાલ યેરૂસાલેમ શેહેરામાય લેય જાયને દેવાળા ઉચે મેરાવોય ઉબો કોઅયો, એને ચ્યાલ આખ્યાં, “જો તું પોરમેહેરા પોહો ઓરી, તે તું પોતે નિચે કુદી પોડ. ");
INSERT INTO gbl_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","કાહાકા પવિત્રશાસ્ત્રમાય લોખલાં હેય કા, પોરમેહેર ચ્યા હોરગા દૂતહાલ તોહાટી આગના કોઅરી કા તુલ બોચાવી લેય. ");
INSERT INTO gbl_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","એને તો પાગ દોગડાવોય આફળાય નાંય ચ્યાહાટી ચ્યા આથાવોય જેલી લેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ઈસુવે જાવાબ દેનો કા, “પવિત્રશાસ્ત્રમાય ઇબી લોખલાં હેય લોકહાન આપહે પ્રભુ પોરમેહેરા પરીક્ષા નાંય કોઅરા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","જોવે સૈતાન બોદી પરીક્ષા પુરી કોઅયી, તોવે તો વાયજ સોમયાહાટી ચ્ચાલ છોડીન જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","એને પવિત્ર આત્મા સામર્થ્યાકોય બોઆયને ઈસુ પાછો ગાલીલ ભાગામાય ફિરી યેનો, એને આહીપાહીને બોદાજ શેહેરામાય ઈસુ બારામાય વાત ફેલાઈ ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ઈસુ ચ્યાહા સોબાયે ઠિકાણે હિકાડે એને બોદે માઅહે ચ્યા બારામાય વાહવા કોઅતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","એને ઈસુ નાજરેતમાય પાછો યેનો, જાં ચ્યા પાલન-પોષણ જાયા, એને ચ્યા રીતી પરમાણે તો આરામા દિહી સોબાયે ઠિકાણે જાયને પવિત્રશાસ્ત્ર વાચાહાટી ઉબો જાયો. ");
INSERT INTO gbl_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","તોવે ચ્યાહાય યશાયા ભવિષ્યવક્તા ચોપડી ચ્ચાલ દેની, એને ચ્ચાય ચોપડી ઉગાડીન ચ્ચા જાગો યેનો ચ્ચામાય કાડી એહેકોય ઈ લોખલાં હેય. ");
INSERT INTO gbl_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","પોરમેહેરા આત્મા માયેવોય ઉત્યહો, યાહાટી કા ચ્ચાય ગરીબાહાન હારી ખોબાર આખાહાટી અભિષેક કોઅયોહો. બંધનમાય પોડલાહાન છુટકા દાંહાટી, બોદા આંદળાહાન દેખતા કોઅરાહાટી એને બોદા દાબાય રોઅલાહાન છોડાવાહાટી ચ્ચાય માન દોવાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","એને પ્રભુવા પ્રસન્ન રોઅના વોરહા ખોબાર કોઉ. ");
INSERT INTO gbl_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","તોવે ચ્ચાય ચોપડી બંદ કોઇન સેવકા આથામાય દેય દેની, એને બોહોય ગીયો એને સોબાયે ઠિકાણામાય બોદા ચ્યાએછે એક દીઠ એઅઇ રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","એને તો ચ્યાહાન આખતો લાગ્યો કા જેહેકોય તુમા વોનાયે ઈ પવિત્રશાસ્ત્ર આજેજ પુરાં ઓઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","બોદહાલ બોજ હારાં ગોમ્યા એને ચ્યાય જીં મોયાની વાત આખી ચ્યાવોય ચ્યાહાન નોવાય પામીન આખ્યાં, “કાય ઓ યોસેફા પોહો નાંય હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ચ્યે ચ્યાહાન આખ્યાં, હાચ્ચાં “તુમા માન એહેકોય આખલા, કા ઓ ડાકટાર, તું પોતાલ હારો કોઓ! કાપરનાહુમ ગાવામાય ઓલા બોદા કોઅયા આમા વોનાજે, તી તું ઈહીં આપહે ગાવામાય કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","એને ચ્યે ચ્યાહાન આખ્યાં, “તુમહાન આંય હાચ્ચાં આખતાહાવ કા, ભવિષ્યવક્તાલ પોતા વોતનામાય કાદો નાંય આદર કોએ. ");
INSERT INTO gbl_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","મા વાત વોનાયા, ઈ હાચ્ચાં હેય કા એલીયા ભવિષ્યવક્તા દિહામાય જોવે હાડાતીન વોરહે લોગુ આકાશામાઅને પાઆય નાંય યેનો, એને બોદા ઈસરાયેલ દેશામાય મોઠો દુકાળ પોડયો, તોવે ઈસરાયેલ દેશામાય બોજ વિધવા બાયો આત્યો. ");
INSERT INTO gbl_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","તેરુંબી પોરમેહેરાય એલીયાલ ચ્ચેહે પાઅને કાદ્યે પાય નાંય દોવાડયો, બાકી સિદોન શેહેરા સારફત ગાવા યોક ગેર યહૂદી વિધવા પાય દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","એને એલિશા ભવિષ્યવક્તા દિહહામાય ઈસરાયેલ દેશામાય બોજ કોડળેં આતેં, બાકી ચ્યાહામાઅને નામાન, જો સિરીયા દેશા યોક ગેર યહૂદી માટડાલ છોડીન કાદો નાંય હારો જાયો.” ");
INSERT INTO gbl_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ઈ વોનાઈન જોલા સોબાયે ઠિકાણામાય આતા, બોદા બોજ ખિજવાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","એને ઉઠીન ચ્યાલ શેહેરા બાઆ ડેકાલતા લેય ગીયા, એને જ્યા ડોગાવોય ચ્યાહા શેહેર બાંદલા હેય, ચ્યા ડોગા ઉપે લેય ગીયા, ચ્યાહાટી ચ્યાલ ડેકલી દેયન માઆઇ ટાકાંહાટી. ");
INSERT INTO gbl_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","બાકી ઈસુ ચ્યાહા વોચમાઅને નિંગીન જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","પાછે ઈસુ ગાલીલ ભાગા કાપરનાહુમ ગાવામાય ગીયો, એને આરામા દિહે લોકહાન તો હિકાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ચ્યા હિકાડના બારામાય ચ્યાહાન નોવાય લાગી કાહાકા તો પુરાં ઓદિકારવાળા હારકો હિકાડે. ");
INSERT INTO gbl_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","સોબાયે ઠિકાણે યોક માઅહું આતા, ચ્યાલ બુત લાગલો આતો. ચ્યે બોજ જોરથી બોંબલીન આખ્યાં કા, ");
INSERT INTO gbl_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ઓ નાજરેત ગાવા ઈસુ, તુલ આમેપાયને કાય જોજે? કાય તું આમહે નાશ કોઅરાહાટી યેનોહો? આંય તુલ વોળખુહુ તું તે પોરમેહેરા પવિત્ર માઅહું હેતો.” ");
INSERT INTO gbl_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","તોવે ઈસુવે ચ્યા બુતાલ દોમકાડીન આખ્યાં, ઠાવકોજ રો, એને ચ્યામાઅને બાઆ નિંગી જો, તોવે બુત ચ્યાલ વોચમાય પાડી ટાકીન ચ્યા નુકસાન કોઅયા વોગાર ચ્યામાઅને નિંગી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","યાવોય બોદહાન બોજ નોવાય લાગી, એને ચ્ચા યોકબીજાહાન વાતો કોઅન આખા લાગ્યેં, “ઈ કાય વાત હેય? કા તો પુરાં ઓદિકારા એને સામર્થ્યાકોય બુતાલ દોમકાડેહે, એને ચ્યે નિંગી જાતહેં.” ");
INSERT INTO gbl_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","એને ચ્યા બારામાય આજુબાજુ શેહેરામાય લોકહાન ખોબાર પોડી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ઈસુ સોબાયે ઠિકાણા માઅને નિંગીન સિમોના હાહુ બોજ જોરાવલી આતી તાં ગીયો એને ચ્યેહાટી ચ્યાહાય ચ્યાલ વિનાંતી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ઈસુવે ચ્યે પાહે ઉબો રોયન જોરાલ દોમકાડયા એને ચ્ચે જોરાં તારાતુજ ઉતી ગીયા એને તી તારાત ઉઠીન ઈસુ એને ચ્યા શિષ્યહા ગાવાર ચાકરી કોઅતી લાગી. ");
INSERT INTO gbl_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","દિહી બુડતા સમયે માઅહે બોજ જાત-જાત્યા દુખ્યાહાન ઈસુવાપાય લેય યેને એને યોકા-યોકાલ આથ લાવીન ચ્યે ચ્યાહાન હારાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","એને બોજ માઅહા માઅને બુત નિંગી ગીયા એને બોંબલા લાગ્યા કા તું પોરમેહેરા પોહો હેય, બાકી ઈસુવે ચ્યાહાન દોમકાડયા એને આખા નાંય દેના, કાહાકા ચ્યાહાન ખોબાર આતી કા તો ખ્રિસ્ત હેય. ");
INSERT INTO gbl_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ઉજાળાં ઓઅઇ ગીયા તોવે ઈસુ ગોઅરે નિંગીન યોક એકાંત જાગામાય ગીયો, લોકહા ગીરદી ચ્યાલ હોદતા યેની એને જોવે મિળ્યો તોવે ચ્યા ચ્યાલ આખા લાગ્યા, કા તો ચ્યાહાન છોડીન નાંય જાય. ");
INSERT INTO gbl_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","બાકી ઈસુવે ચ્યાહાન આખ્યાં માન તે બિજા શેહેરાહામાય પોરમેહેરા રાજ્યા હારી ખોબાર આખના જરુરી હેય, કાહાકા આંય યાજહાટી પોરમેહેરાપાઅને દોવાડલો ગીઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","એને ઈસુ યહૂદીયા વિસ્તારા યહૂદી સોબાયે ઠિકાણે હારી ખોબાર આખતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","યોક દિહી ઈસુ ગેનેસારેત દોરિયા મેરાવોય ઉબો રિઅલો આતો, એને માઅહે પોરમેહેરા વચન વોનાયાંહાટી ગીરદી કોએત એને ચ્યાલ બીચડી રીઅલા આતા, તોવે એહેકોય જાયા, ");
INSERT INTO gbl_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ઈસુય દોરિયા મેરે બેન ઉડયે દેખ્યે, એને માછલે દોઅનારા ઉડીવોયને ઉતીન માછલે દોઅના જાળ દોવતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ચ્યેહેમાઅને યોક ઉડી સિમોના આતી, ચ્યામાય તો ચોડી ગીયો, એને ઉડીલ મેરાવોઅને થોડહે લોગુ પાઅયામાય લેય જા ચ્ચાહાન આખ્યાં પાછે ઉડીમાય બોહીન લોકહાન હિકાડતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","જોવે ઈસુ લોકહાઆરે વાત પુરી જાયી તોવે ચ્યે સિમોનાલ આખ્યાં, “ઉડીલ ઉંડા પાઅયામાય લેય જાં દે, એને માછલે દોઅરાંહાટી તો જાળ ટાક.” ");
INSERT INTO gbl_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","સિમોનાય ચ્ચાલ આખ્યાં, “ઓ ગુરુજી, આમહાય આખી રાત મેહનાત કોઅયીહી બાકી કાયજ નાંય દોઅયા; તેબી તું આખતોહો તે આંય જાળ ટાકહી”. ");
INSERT INTO gbl_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","જોવે સિમોન એને ચ્યા હાંગાત્યાહાય માછલે દોઅના જાળ ટાકી, તોવે બોજ માછલે ગેરી લેય યેના, એને ઓલે માછલે દોઅયે કા ચ્યાહા જાળ ફાટી જાંઆ કોએ. ");
INSERT INTO gbl_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ચ્યાહાટી ચ્યાહાય ચ્યાહા હાંગાત્યાહાન જ્યા બિજા ઉડીમાય આતા, ઈશારો કોઅયો, કા યેયન આમે મોદાત કોઆ, એને ચ્યાહાય યેયન, બેની ઉડયે ઓલે લોગુ બોઅઇ લેદે કા ચ્યે બુડી જાં કોએત. ");
INSERT INTO gbl_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ઈ એઇન સિમોન પિત્તર ઈસુવાલ પાગે પોડીન બોલ્યો, “પ્રભુ માયેપાઅને જાતો રો, કાહાકા આંય તે પાપી માઅહું હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","કાહાકા તો એને ચ્યા બોદા હાંગાત્યા દોઅલા માછલાહા ડીગલા એઇન નોવાય પામી ગીઅલા, ");
INSERT INTO gbl_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","એને તેહેકોયજ જબદયા પાહા યાકૂબ એને યોહાનાલ બી, જ્યા સિમોના ભાગીદાર આતા, ચ્યાહાન નોવાય લાગી તોવે ઈસુવે સિમોનાલ આખ્યાં, “ગાબારાતો મા, આમી પાછે તું લોકહાન મા શિષ્ય બોનાડેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","એને ચ્યા ઉડયેહેન મેરે લેય યેના પાછે ચ્યા માછલે દોઅના છોડીન ઈસુવા શિષ્ય બોની ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","જોવે ઈસુ તાંઅના યોક શેહેરામાય આતો, એને યોક કોડવાળા માઅહું યેના એને તો ઈસુવાલ એઇન ડોંગો પોડીન પાગે પોડયો, એને માગણી કોઅયી કા “ઓ પ્રભુ આંય જાંઅતાહાંવ કા તું તો ઇચ્છાકોય તું માન ચોખ્ખો કોઇ હોકતોહો.” ");
INSERT INTO gbl_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ઈસુવે આથ લાંબો કોઅયો, એને ચ્યાલ આથ લાવીન ચ્યે આખ્યાં, “મા ઇચ્છા હેય કા, તું ચોખ્ખો ઓઅઇ જો” એને તારાતુજ તો ચોખ્ખો ઓઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","તોવે ઈસુવે ચ્યાલ ચેતાવણી દેની, “તો કાદાલ એહેકેન આખના નાંય, કા માયે તુલ હારો કોઅયો બાકી જો એને યાજકાલ દેખાડ એને તું ચોખ્ખો ઓઅઇ ગીયો, ચ્યા બારામાય મૂસાય આગના કોઇન આખહી તી બેટ આઈન દે, ચ્યા લોકહા સાબિત્યે હાટી.” ");
INSERT INTO gbl_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","બાકી ઈસુવા બારામાય વાત આજુ બોજ જાગે ખોબાર પોડી ગીયી, એને મોઠી ગીરદી ચ્યાપાઅને વોનાયા હાટી એને પોતાના દુઃખહામાઅને હારાં ઓઅઇ જાંહાટી ચ્યાપાય બેગે જાયે. ");
INSERT INTO gbl_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","બાકી તો ઉજાડ જાગામાય એકાંતમાય જાયન પ્રાર્થના કોઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","એને યોક દિહી ઈસુ હિકાડે તોવે પોરૂષી લોક એને મૂસા નિયમ હિકાડનારા ગુરુ બોઠલા આતા, જ્યા ગાલીલ ભાગા એને યહૂદીયા વિસ્તારા બોદા ગાવહામાઅને એને યેરૂસાલેમ શેહેરામાઅને તાં યેનલે આતેં એને હારાં કોઅરાહાટી પ્રભુવા સામર્થ્ય ઈસુવાઆરે આતાં. ");
INSERT INTO gbl_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","એને એરા, કોલહાક લોક યોક લખવાવાળા માઅહું આતા, ચ્યાલ ખાટલાવોય હુવાડીન લેય યેના, એને ચ્યા ચ્યાલ ઈસુ આતો ચ્યા ગોઅમે ઈસુ હોમ્મે લેય જાંહાટી યુક્તિ કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","બાકી ગીરદી લેદે ચ્યાલ ગોઅમે નાંય લેય જાય હોક્યા, ચ્યાહાટી ચ્યાહાય ગોઆ ઉચે ચોડીન સિવલાં ગુઉ ખોળી ટાક્યા એને બોગારામાયને લખવાવાળાલ ખાટલાહાતે ઈસુવા હામ્મે ઉતાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ઈસુવે, જાંઅયા કા ચ્યા માયેવોય બોરહો થોવતાહા, તોવે ઈસુવે ચ્યાલ આખ્યાં, “ઓ બાહા, તો પાપહાલ આંય માફ કોઅતાહાંવ.” ");
INSERT INTO gbl_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","તોવે પોરૂષી લોક એને મૂસા નિયમ હિકાડનારા ગુરુ વિચાર કોઅતા લાગ્યા, “ઓ કું હેય જો પોરમેહેરા નિંદા કોઅહે, કાય એલાલ નાંય ખોબાર હેય કા પોરમેહેરુજ પાપ માફ કોઅઇ હોકહે?” ");
INSERT INTO gbl_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","બાકી ઈસુવે ચ્યાહા મોના વિચાર જાંઆઈન આખ્યાં, “તુમહે મોનામાય કાહા ખારાબ વિચાર કોઅતાહા? ");
INSERT INTO gbl_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","કાય ઈ આખના હેલ્લા હેય? ‘તો પાપ માફ ઓઈ ગીયા’ કા ઈ આખના હેલ્લા હેય ઉઠ ચાલા લાગ? ");
INSERT INTO gbl_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","બાકી તુમહાન માલુમ ઓઅરા જોજે કા માન એટલે માઅહા પોહાલ દોરત્યેવોય લોકહા પાપ માફ કોઅના બી ઓદિકાર હેય.” ચ્યાહાટી ઈસુય લખવાવાળા માઅહાન આખ્યાં. “તુલ આંય આખતાહાવ, ઉઠ, તો ખાટલા લેઈને ગોઓ જો.” ");
INSERT INTO gbl_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","તારાત તો બોદહા દેખતા ઉબો ઓઈ ગીયો, એને જીં ખાટલાવોય હૂવી રોઅલો આતો તી લેઈને, પોરમેહેરા સ્તુતિ કોઅતો પોતાના ગોઓ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","તોવે બોદહાન બોજ નોવાય લાગી, એને પોરમેહેરા સ્તુતિ આખતા લાગ્યા ચ્યા બોદા બી ગીયા એને આખ્યાં, “આજે આમહાય અજાબ વાતો દેખી.” ");
INSERT INTO gbl_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","એને પાછે ઈસુ તાઅને બાઆ ગીયો, એને લેવી નાંવા કર લેનારાલ જકાત નાકાવોય બોઠલો દેખ્યો, એને ચ્યાલ આખ્યાં, “મા શિષ્ય બોન.” ");
INSERT INTO gbl_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","તોવે તો કર લેઅના છોડીન, ઈસુવા શિષ્ય બોની ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","એને લેવીય ચ્યા ગોઅમે યોક મોઠા જેવાણ થોવ્યા; એને કર લેનારા એને બિજા લોક જ્યા ચ્યાહા હાતે ખાં બોઠલા આતા યોક મોઠી ગીરદી આતી. ");
INSERT INTO gbl_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","તોવે પોરૂષી લોક એને મૂસા નિયમ હિકાડનારા ગુરુ ઈસુ શિષ્યહાન ઈ આખીન ટુટારતા લાગ્યા કા, “તુમા કર લેનારાહા આરે એને પાપી લોકહાઆરે કાહા ખાતહા?” ");
INSERT INTO gbl_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","તોવે ઈસુવે જાવાબ દેનો કા, “જ્યેં હારેં હેતેં ચ્યાહાન ડાકટારા ગોરાજ નાંય રોય, બાકી જ્યેં દુખ્યેં હેતેં ચ્યાહાન ગોરાજ હેય. ");
INSERT INTO gbl_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","આંય પોતે ન્યાયી માનતાહા ચ્યા લોકહાન નાંય, બાકી પાપ્યાહાન બોચાવાં યેનોહો.” ");
INSERT INTO gbl_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","બાકી ચ્યાહાય ચ્યાલ આખ્યાં, “યોહાના શિષ્ય બોજદા ઉપહા એને પ્રાર્થના કોઅતાહા, એને પોરૂષી લોકબી, બાકી તો શિષ્ય ઉપહા નાંય કોએ.” ");
INSERT INTO gbl_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","તોવે ઈસુવે જાવાબ દેનો, “મા શિષ્ય એને આંય વોવડા એને દોસ્તારા હારકા હેતા, જાવ લોગુ વોવડો ચ્યાહા હાતે રોય, તાંવ લોગુ ચ્યા ઉપહા કોઇ હોકતાહા? ");
INSERT INTO gbl_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","બાકી ચ્યાહા પાયને વોવડો લેવાય જાય, ઓહડા દિહી યી તોદિહી ઉપહા કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ઈસુવે ચ્યાહાન આજુ યોક દાખલો આખ્યો કા; “માઅહે નોવા ફાડકા માઅને ઠિગળા કાતરીન જુના ફાડકા આરે નાંય હિવેત એહેકોય તે નોવા ફાડકા ચંડળાય જાય, એને જુના ફાડકામાય નોવા ઠિગળા મેળ નાંય બોહે. ");
INSERT INTO gbl_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","એને માઅહે નોવો દારાખા રોહો જુના ચાંબડા ઠેલ્યેમાય નાંય બોએત એહેકેન કોઇન દારાખા રોહો થોવે તે તી ઠેલી ફાટી જાય, એને દારાખા રોહો વેરાય જાય. ");
INSERT INTO gbl_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","બાકી નોવો દારાખા રોહો નોવ્યે ઠેલ્યેમાયજ બોઅતેહેં. ");
INSERT INTO gbl_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","એને માઅહે જુનો દારાખા રોહો પીયને પાછે નોવો દારાખા રોહો કાદો નાંય માગે, કાહાકા જૂનોજ હારો હેય, એહેકોય આખતેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","યોક આરામા દિહી ઈસુ એને ચ્યા શિષ્ય રાનામાઅને જાતા આતા, તોવે શિષ્ય કોઅહે પેંદીન આથામાય ચોળીન ખાતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","તોવે પોરૂષી લોકહામાઅને કોલહાક આખા લાગ્યા, “તુમા તી કામ કાહા કોઅતાહા જીં આરામા દિહી કોઅના આમે નિયમા વિરુદ હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ઈસુવે ચ્યાહાન જવાબ દેનો, “કાય તુમહાય નાંય વાચ્યાહાં, કા દાઉદ રાજાય, જોવે ચ્યા હાંગાત્યાહાન બુખ લાગી તોવે કાય કોઅયા? ");
INSERT INTO gbl_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","તોવે તો કેહેકેન પોરમેહેરા માંડવામાય ગીયો, એને બેટ ચોડાવલ્યો બાખ્યો લેઈને ખાદ્યો, જ્યો યોખલા યાજકથી ખાવાય ચ્યો ચ્યે ખાદ્યો, એને હાંગાતિયાહાન બી દેન્યો?” ");
INSERT INTO gbl_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","એને ઈસુવે ચ્યાહાન આખ્યાં, “માન, માઅહા પોહાલ આરામા દિહાવોય બી ઓદિકાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","એહેકોય જાયા કા બિજા આરામા દિહી તો, સોબાયે ઠિકાણે જાયને હિકાડાં લાગ્યો; તાં યોક માઅહું આતા, ચ્યા જમણો આથ ઉખાય ગીઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષી લોક ઈસુવાવોય દોષ લાવાહાટી ટુંગી રીઅલા આતા, કા ઈસુ આરામા દિહી હારો કોઅહે કા નાંય. ");
INSERT INTO gbl_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","બાકી ઈસુ ચ્યાહા વિચાર જાંઅતો આતો ચ્યાહાટી આથ ઉખાય ગીઅલા માઅહાલ ઈસુવે આખ્યાં, “ઉઠ એને વોચમાય ઉબો રો” તો ઉઠીન ઉબો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ઈસુવે ચ્યાહાન આખ્યાં કા, “કાય આરામા દિહી હારાં કામ કોઅના હારાં હેય કા ખારાબ કામ કોઅના, કાદા જીવ બોચાવના હારાં હેય કા માઆઇ ટાકના?” ");
INSERT INTO gbl_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","તોવે ઈસુવે ચારીચોમખી ચ્યા બોદહાન ફિરી એઇન આથ ઉખાય ગીઅલા માઅહાલ આખ્યાં “તો આથ લાંબો કોઓ” ચ્યે તેહેકોય કોઅયા તોવે ચ્યા આથ હારો ઓઈ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","બાકી ચ્યા વાયજ દુઉ જાયને યોકબીજાઆરે વાત કોઅતા લાગ્યા કા આમી આપા ઈસુઆરે કાય કોઅતા? ");
INSERT INTO gbl_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ચ્યા દિહાહામાય ઈસુ પ્રાર્થના કોઅરાહાટી યોકા ડોગાવોય ચોડી ગીયો, એને આખી રાત પોરમેહેરાલ પ્રાર્થના કોઅનામાય કાડી. ");
INSERT INTO gbl_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","જોવે દિહી નિંગ્યો, તોવે યેનો એને શિષ્યહાન પાહી હાદ્યા એને ચ્યાહામાઅને બાર જાંઆહાન નિવડયા એને ચ્યાહાન ચ્યે “પ્રેષિત” આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","એને ચ્યા યા હેતા: સિમોન જ્યા નાંવ પિત્તર થોવ્યા ચ્યા બાહા આંદ્રિયાસ, એને યાકૂબ, યોહાન એને ફિલિપ એને બારતોલોમી, ");
INSERT INTO gbl_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","એને માથ્થી એને થોમા એને અલફિયા પોહો યાકૂબ એને સિમોન જ્યાલ જેલોતોસ આખે. ");
INSERT INTO gbl_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","એને યાકૂબા પોહો યહૂદા એને યહૂદા ઇસ્કારીયોત જો ઈસુવાલ દોઈ દેનારો બોન્યો. ");
INSERT INTO gbl_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","તોવે તો ચ્યાઆરે ડોગાવોયને નિચે ઉત્યો, એને યોક હારકા દાદરામાય ઉબો રિયો એને ચ્યાઆરે શિષ્યહા મોઠો ટોળો આતો, એને બોદા યહૂદીયા વિસ્તારા, યેરૂસાલેમ શેહેરા સુર એને સિદોન શેહેરા એને દોરિયા મેરાવોય રોનારા લોકહા મોઠો ટોળો, ");
INSERT INTO gbl_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","જ્યા ચ્યાપાય વોનાયા એને દુઃખામાઅને હારેં ઓઅરાહાટી યેનલા, એને બુત લાગલે માઅહેબી હારેં ઓઅઇ જાતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","બોદાજ લોક ચ્યાલ આથ લાવાં હોદે, કાહાકા ચ્યામાઅને ઓહડા સામર્થ્ય નિંગતા આતા કા બોદહાન હારેં કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","તોવે ચ્યે શિષ્યહા એછે એઇન આખ્યાં, “ધન્ય હેય તુમા, જ્યેં ગોરીબ હેય, કાહાકા પોરમેહેરા રાજ્ય તુમહે હેય. ");
INSERT INTO gbl_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ધન્ય હેય તુમા, જ્યેં બુખે હેય, કાહાકા તુમા દારાયન મોરસાય જાહા. ધન્ય હેય તુમા, જ્યા આમી રોડતાહા, કાહાકા તુમા ઓહાહા. ");
INSERT INTO gbl_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ધન્ય હેય તુમા, માઅહા પોહા લેદે તુમહેઆરે દુશ્માની કોઅરી, એને સોબાયે ઠિકાણા માઅને બાઆ કાડી દેઅરી, એને નિંદા કોઅરી, એને તુમહાન ખારાબ જુઠા હોમજીન નાંવ ખોડી ટાકી.” ");
INSERT INTO gbl_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","“ચ્ચે દિહી તુમા આનંદામાય કુદજા, કાહાકા એઆ, તુમહે કોરે હોરગામાય મોઠો ઇનામ હેય; કાહાકા ચ્યાહા આગલ્યાડાયા બી ભવિષ્યવક્તા આરે એહેંજ કોઅયા કોએત.” ");
INSERT INTO gbl_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","“બાકી જ્યા માલદાર હેતા તુમહેવોય હાય, કાહાકા તુમાહાલ પેલ્લાજ પુરો આરામ મિળી ગીયો.” ");
INSERT INTO gbl_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“હાય તુમહાવોય, જ્યા આમી ભરપુરીકોય ખાતહા, કાહાકા તુમા બુખા રાહા. હાય તુમહાવોય, જ્યા આમી ઓહતાહા, કાહાકા તુમા રોડહા એને કોકળાહા.” ");
INSERT INTO gbl_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","“હાય તુમહાવોય, જોવે બોદે માઅહે તુમહાન હારેં બોલી, કાહાકા તુમહે આગલ્યા ડાયહાય બી જુઠા ભવિષ્યવક્તાહા વાહવા કોઅયી.” ");
INSERT INTO gbl_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“બાકી આંય વોનાનારાહાલ આખહુ, કા તુમા દુશ્માનાહાવોય પ્રેમ કોઆ; જો તુમહેઆરે દુશ્માની કોઅરી, ચ્યાહા હારાં કોઆ. ");
INSERT INTO gbl_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","જો તુમહાન હારાપ દેય, ચ્યાલ બોરકાત દા, જો તુમહે નિંદા કોઅરી, ચ્યાહાહાટી પ્રાર્થના કોઆ. ");
INSERT INTO gbl_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","જો તો યોકા ગાલાવોય થાપડે કોઇન ઠોકે, તે બિજો ગાલ બી ફીરવી દે; જીં માઅહું તો ડોગલેં લેય તોવે તો ફાડકે બાકી મા રાખતો. ");
INSERT INTO gbl_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","જો કાદો તોપાય માગે, ચ્યાલ દે, એને જીં વસ્તુ તો પાયને પેચકી લેય જાય, તી પાછા નાંય માગતો. ");
INSERT INTO gbl_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","એને બિજા લોક તુમહેઆરે જેહેકોય રા જોજે ઓહડી તુમહે ઇચ્છા ઓરીતે, તુમાબી ચ્યાહાઆરે તેહેંજ કોઆ. ");
INSERT INTO gbl_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","કાહાકા જો તું તો પ્રેમ રાખનારાવોય પ્રેમ રાખહે તોવે તુમહાય કાય હારાં કોઅયા? પાપી માઅહું બી પ્રેમ રાખનારાવોય પ્રેમ રાખહે. ");
INSERT INTO gbl_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","એને તુમા જોવે તુમહાન હારાં કોઅનારાહાન તુમા હારાં કોઅતાહા, તોવે કાય હારાં કોઅયા? પાપી માઅહેબી એહકોયજ કોઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","એને જ્યાહા પાયને પાછા મિળના આશા રાખતાહા ચ્યાહાનુજ તુમા ઉછના દેતાહા, તોવે કાય તુમહે હારાં ઓએ? કાહાકા પાપી માઅહેબી પાપ્યાહાન ઉછના દેતહેં ચ્યાહાટી તોલાંજ પાછા લાંહાટી. ");
INSERT INTO gbl_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","બાકી તુમહે દુશ્મનાહા વોય પ્રેમ કોઆ, એને ભલા કોઆ, એને બોદલે એને પાછા મિળના આશા રાખ્યા વોગાર ઉછના દિયા, એને તુમહેહાટી મોઠા ફળ ઓઅરી, એને તુમા પરમપ્રધાન પોરમેહેરા પાહા બોનહા, કાહાકા તો જ્યા લોક ધન્યવાદ નાંય કોએ એને ખારાબ લોકહાવોય બી દયાળુ હેય. ");
INSERT INTO gbl_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","જેહેકોય તુમહે આબો દયા કોઅહે, તેહેકોય તુમાબી દયા કોઆ. ");
INSERT INTO gbl_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","તુમા બીજહાવોય દોષ મા થોવહા, યાહાટી કા તુમાહાવોય બી કાદો દોષ નાંય થોવે. કાદાલ દોષી મા ઠોરવાહા તે પોરમેહેર તુમહાનબી દોષી નાંય ઠોરવી. માફ કોઆ, તે પોરમેહેર તુમહાનબી માફ કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","તુમા દા, તે પોરમેહેર તુમહાનબી બોઓઈન એને ઠેસીન એને દાબીન એને ઉબરાઈન દી; કાહાકા જ્યા પરમાણે, તુમા બીજહા ન્યાય કોઅતાહા, તેહેકોયજ પોરમેહેર બી તુમહે ન્યાય કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","પાછી ઈસુય ચ્યાહાલ યોક દાખલો હોમજાડયો; એલા આંદળા વાટ દેખાડનારા હેતા, જોવે આંદળા આંદળાલ લેય જાય તોવે બેની ખાડામાય પોડી. ");
INSERT INTO gbl_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","શિષ્ય પોતાના ગુરુઆ કોઅતા મોઠા નાંય બોને; બાકી જ્યા બોણના પુરાં ઓઅચ, તો ગુરુવા હારકો રોય. ");
INSERT INTO gbl_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","તું તો બાહા પાપ કાહા એઅતોહો, જોવે તો જીવનમાય યોક મોઠા પાપ હેય જો તો ડોળામાય હુકળા હારકો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","એને તોજ માય મોઠા પાપ હેય તે તુલ બિજા પાપ કોઅનારા માઅહાલ દોષ લાવાં નાંય જોજે. ઓ ડોંગ્યા, પેલ્લા તો મોઠા પાપ હુદરાવી લે, તોવે તું તો બાહા પાપ હુદરાવા મોદાત કોઇ હોકતોહો. ");
INSERT INTO gbl_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","હારાં જાડાલ નોકામ્યે ફળે નાંય લાગેત, નાંય નોકામ્યા જાડાલ હારેં ફળે લાગેત. ");
INSERT INTO gbl_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","કાહાકા જાડ ચ્યા ફળ કોય વોળખાયેહે, કાટાહા જાડાહા પાયને અંજીર નાંય તોડેત, એને જેખરાહામાયને દારાખેં નાંય મીળેત. ");
INSERT INTO gbl_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","હારાં માઅહું મોના હારાં ભંડારા માઅને હાર્યો વાતો કાડહે, એને જુઠા માઅહું જુઠા ભંડારામાયને જુઠયો વાતો કાડહે. કાહાકા જીં મોનામાય બોઅલાં હેય, તીંજ વાત માઅહું બોલહે. ");
INSERT INTO gbl_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","“જોવે તુમા મા આખલ્યા નાંય માનેત, તો માન ‘ઓ પ્રભુ, ઓ પ્રભુ’ કાહા આખ્યાં કોઅતાહા? ");
INSERT INTO gbl_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","જો કાદો માપાય યેહે, એને મા વાત વોનાયને માની લેહે, આંય તુમહાન આખતાહાવ કા તો કા હારકો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","તો યા માઅહા હારકો હેય, જ્યાંય ગુઉ બાંદતી સમયે ઉંડે પાયો ખોદીન ખોલકાડાવોય પાયો બાંદ્યો, એને જોવે નોયાડો યેનો તોવે ચ્યા ગોઆ આરે લાગ્યો, બાકી ચ્યાલ આલવી નાંય હોક્યા, કાહાકા ચ્યા પાયો પાક્કો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","બાકી જો કાદો મા વોનાયને નાંય પાળે, તો ચ્યા માઅહા હારકો હેય, જ્યાંય દોરતીવોય વોગાર પાયા ગુઉ બાંદ્યા. પાછે પાંઈ પોડયો, નોયાડો યેનો, એને ચ્યા ગોઆલ જાઈ ઠોકાઈયે, તોવે તી તારાત ટુટી પોડીન બોદા નાશ ઓઅઇ ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","જોવે ઈસુ લોકહાન ચ્યો બોદ્યો વાતો આખી ચુક્યો, પાછે કાપરનાહુમ ગાવામાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","તોવે યોક જોમાદાર આતો, ચ્યા યોક વાહલો ચાકાર બોજ બિમાર પોડી ગીયેલ તો મોઅના અણ્યેવોય આતો. ");
INSERT INTO gbl_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ચ્યે ઈસુવા બારામાય વોનાયને યહૂદીયા કોલહાક આગેવાન ઈસુવાલ ઈ વિનાંતી કોઅરાહાટી ઈસુવાપાય દોવાડયા, કા તો યેયન મા ચાકરાલ બોચાવ કોએ. ");
INSERT INTO gbl_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ચ્યા ઈસુવાપાય યેના, એને ચ્યાલ બોજ રાવ્યાં કોઇન આખા લાગ્યા, ચ્યાહાટી તો ઓલહાં કામ કોએ, કા તું ચ્ચાહાટી ઈ કામ કોઓ. ");
INSERT INTO gbl_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","કાહાકા તો આપહે જાત્યેવોય પ્રેમ રાખહે, એને ચ્યાયજ આપહેહાટી સોબાયે ઠિકાણાલ બી બોનાડલા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ઈસુ ચ્યાહાઆરે-આરે ગીયો, જોવે ચ્યા ગોઆપાય યેના, તોવે જોમાદારાય ચ્યાલ કોલહાક હાંગાત્યાકોય આખી દોવાડયા, ઓ પ્રભુ, તું આબદા મા કોઅહે, આંય યા લાયકે નાંય હેય, કા તુમા ગોઅમે યેય. ");
INSERT INTO gbl_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","યા લીદે પોતાલ આંય લાયકે બી નાંય હોમજ્યો કા, તો પાહે યા, બાકી શબ્દ આખી દે, તે મા ચાકાર હારો ઓઅઇ જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","કાહાકા આંયબી બિજા ઓદિકારા તાબામાઅને માઅહું હેતાંવ, એને મા તાબામાંય સિપાડાહા યોક ટુકડી હેય, એને જોવે આંય યોકાલ આખતાહાવ, જો, તોવે તો જાહાય, એને બિજાલ આખતાહાવ, યે, તોવે તો યેહે, એને જોવે મા ચાકારાલ આખતાહાવ, ઈ કોઓ, તોવે તો ચ્ચાલ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ઈ વોનાઈન ઈસુવાલ નોવાય લાગી, એને જીં ઈસુ પાહલા ગીરદી યેય રિઅલી આતી ચ્યાહાન આખ્યાં કા, “આંય તુમહાન હાચ્ચાંજ આખતાહાવ, કા માયે ઈસરાયેલ દેશામાય બી યોક ઓહડો માઅહું નાંય મિળ્યો, જો યહૂદ્યા હારકો માયેવોય બોરહો કોઅતો હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","જ્યાહાલ દોવાડલા ચ્યા લોકહાય ગોઓ યેયન દેખ્યાકા તો ચાકાર હારો ઓઈ ગીયહો. ");
INSERT INTO gbl_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","વોછા દિહાહા પાછે ઈસુ નાઈન નાંવા યોક ગાવામાય ગીયો ચ્યા શિષ્ય એને બોજ મોઠો ટોળો ચ્યા પાછલા જાતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","જોવે તો ચ્યા ગાવા ફાટકેપાય યેય પોઅચ્યો, તોવે માઅહે યોક મોઅલા મુરદાલ બાઆ લેય જાતે આતેં, જો પોતાના આયહે યોકનેયોક પોહો આતો એને તી વિધવા બાય આતી, એને ગાવા બોજ લોક ચ્યાહાઆરે આતા. ");
INSERT INTO gbl_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ચ્યેલ દેખીન પ્રભુલ દયા યેની, એને ચ્ચાય આખ્યાં, “રોડહે મા.” ");
INSERT INTO gbl_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","તોવે ઈસુય પાહાય જાયને મુરદાં ખાટલાલ આથ લાવ્યો, એને ખાંદિયા ઉબા રોય ગીયા તોવે ચ્યે આખ્યાં, “ઓ જુવાન, આંય તુલ આખહુ, ઉઠ!” ");
INSERT INTO gbl_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","તારાત તો મોઅલો જુવાન ઉઠીન બોઠો, ને બોલતો લાગ્યો એને ચ્યે ચ્યા આયહેલ દેય દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","તોવે બોદા લોક નોવાય પામી ગીયા, એને પોરમેહેરા સ્તુતિ કોઇન આખતા લાગ્યા, “આપહે વોચમાય યોક મોઠો ભવિષ્યવક્તા ઉબો જાયહો, એને પોરમેહેર ચ્યા લોકહાન દેખભાલ કોઅરા યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","એને ઈસુવા બારામાય ઈ વાત યહૂદીયા વિસ્તારામાય એને ચ્યા આહીપાહીને બોદા દેશામાય ખોબાર પોડી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","બાપતિસ્મા દેનારા યોહાનાલ શિષ્યહાય યે બોદી વાતહે ખોબાર દેની. ");
INSERT INTO gbl_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","તોવે યોહાન બાપતિસ્મા દેનારાય ચ્યા બેન શિષ્યહાન હાદિન ઈસુવાપાય પુછા દોવાડયા કા, “કાય તુંજ ખ્રિસ્ત હેય, જ્યાલ દોવાડના વાયદો પોરમેહેરાય કોઅલો આતો, કા આમા યોકતા બિજા વાટ જોવજે?” ");
INSERT INTO gbl_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ચ્યા શિષ્ય ઈસુવાપાય યેના તોવે ચ્યાહાય આખ્યાં, “આમહાન યોહાન બાપતિસ્મા દેનારાય તુલ પુછા દોવાડયાહા, કા કાય તુંજ ખ્રિસ્ત હેય, જ્યાલ દોવાડના વાયદો પોરમેહેરાય કોઅલો આતો, કા આમા યોકતા બિજા વાટ જોવજે?” ");
INSERT INTO gbl_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ચ્યેજ ગેડીયે ઈસુવે બોજ લોકહાન બિમારીમાઅને એને દુઃખહામાઅને એને બુતા તાબામાઅને છોડાવ્યા એને બોજ આંદળાહાન દેખતા કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ઈસુય ચ્યાહાન આખ્યાં, “જીં કાય તુમહાય દેખ્યાં એને વોનાયાહા, જાયને યોહાનાલ આખજા; કા આંદળે દેખતેહે એને લેંગડે ચાલતેહે ફીરતેહે, કોડળેં ચોખ્ખેં કોઅવામાય યેતહે એને બોઅરે વોનાતેહે, મોઅલે જીવતે કોઅલે જાતહેં, એને ગોરીબાહાલ હારી ખોબાર આખવામાય યેહે. ");
INSERT INTO gbl_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","એને ધન્ય હેય જીં, માયેવોય શંકા નાંય કોએ.” ");
INSERT INTO gbl_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","જોવે યોહાના પાયને દોવાડલા લોક તાઅને જાતા રિયા, તોવે ઈસુ યોહાના બારામાય લોકહાન આખતો લાગ્યો કા, તુમા ઉજાડ જાગામાય કાય એરાહાટી ગીઅલે? કાય વારાકોય આલનારા બુરળ્યા? ");
INSERT INTO gbl_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","તે તુમા કાય એરા ગીઅલે? કાય મોઅગેં ફાડકે પોવલા લોકહાન કા? એઆ, એને સુખમાય જીવનારા, ચ્યા રાજમેહેલામાય રોતહા. ");
INSERT INTO gbl_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","તે તુમા કાય એરા ગીઅલે? કાય ભવિષ્યવક્તાલ કા? હાં, આંય તુમહાન આખહુ, જો ભવિષ્યવક્તા કોઅતો મોઠો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","એને તો હેય, જ્યા બારામાય લોખલાં હેય, “એએ તો પેલ્લા આંય આપહે સંદેશ લેય યેનારા દૂતાન દોવાડતાહાવ, તો, તો પેલ્લા તોહાટી વાટ તિયાર કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","તુમહાન આંય આખતાહાવ, કા જ્યા થેએયેથી જોન્માલ યેનલા હેય, ચ્યાહામાઅને યોહાન બાપતિસ્મા દેનારા કોઅતા કાદો મોઠો નાંય, તેરુંબી પોરમેહેરા રાજ્યામાય જો વાહનામાય વાહનો રોય, તો ચ્યા કોઅતો મોઠો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","જોવે ચ્યાહાય ઈસુ આખલ્યા વોનાયા, તોવે બોદા લોકહાય એને કર લેનારાહાય બી યોહાના પાયને બાપતિસ્મા લેયને પોરમેહેરાલ હાચ્ચો માની લેદો. ");
INSERT INTO gbl_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","બાકી પોરૂષી લોક એને મૂસા નિયમ હિકાડનારા ગુરુહુય યોહાના પાયને બાપતિસ્મા નાંય લેદા, એને પોરમેહેરા ઇચ્છાલ, ગોણત્રી નાંય કોઅઇ. ");
INSERT INTO gbl_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","બાકી ઈ પીડી કોહડી હેય? ");
INSERT INTO gbl_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ઈ પીડી ચ્યા પાહહા હારકી હેય જ્યા આટામાય બોહીન હાંગાતિયાન હાત કોઇન આખતાહા. આમહાય તુમહેહાટી વોરાડા ગીતે આખ્યે એને તુમા નાચ્યા નાંય, આમહાય રોડના ગીતે આખ્યે, બાકી તુમા નાંય રોડયા. ");
INSERT INTO gbl_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","કાહાકા જોવે યોહાન બાપતિસ્મા દેનારો યેનો તોવે તો બોજ ઉપહા કોઅતો આતો, એને દારવા નાંય પિતો આતો, એને તુમહાય આખ્યાં, ચ્યામાય બુતા આત્મા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","બાકી જોવે આંય, માઅહા પોહો ખાતો પિતો યેનો, તો તુમા આખતા લાગ્યા “એઆ, તો ખાદાડ એને પિદાડ માઅહું, કર લેનારાહા એને પાપી લોકહા હાંગાત્યો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","તેરુંબી માઅહા કામહાકોય સાબિત ઓઅહે કા જ્ઞાની કું હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","પાછે કાદા પોરૂષીય ચ્યાલ વિનાંતી કોઅઇ કા મા આરે ખાજે; ઈસુ ચ્યા પોરૂષીયા ગોઓ જાયને ખાં બોઠો. ");
INSERT INTO gbl_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ચ્યા ગાવામાઅને યોક પાપી બાઈ ઈ જાઇન કા ઈસુ યોક પોરૂષીયાહી ખાં બોઠો, ઓલહામાય તી બાય સંગેમરમર દોગડા બોનાવલી યોક બાટલીમાય મોઅગાં અત્તાર લેય યેની. ");
INSERT INTO gbl_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","એને ચ્યા પાગહાપાય, પાછાડી ઉબી રોયન રોડતી ઈસુ પાગહાલ આહાંવાહાં કોય બીજવી કાડયા, એને ચ્યે ટોલપ્યે કિહહા કોઇન નુંહરા લાગી એને ચ્યા પાગહાલ પાછા-પાછા ચૂમીને ઈસુ પાગહાવોય અત્તાર લાવ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ઈ દેખીન, જ્યેં પોરૂષીય ઈસુલ ખાં હાદ્યેલ, તો મોનામાય વિચાર કોઅરા લાગ્યો, “જો ઓ ભવિષ્યવક્તો રોતો તે જાંઆઈ જાતો કા ઈ જીં ચ્યાલ આથ લાવી, રીયહી તી કું એને કોહડી બાય હેય, કાહાકા તી તે પાપી બાય આતી.” ");
INSERT INTO gbl_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ઈસુવે ચ્યા વિચાર હોમજીન જાવાબ દેના, “ઓ સિમોન, માન તુલ કાય આખના હેતા” તો બોલ્યો, “ઓ ગુરુજી, આખ.” ");
INSERT INTO gbl_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ઈસુય ઓ દાખલો દેનો, “યોકા દોણ્યા બેન કર્જદાર આતા યોકા પાય પાચહોવ (૫ હોવ દીનાર એટલે ૫૦૦ દિહાહા કામાણી ઓઅહે) એને બિજા પાય પોચહા દીનાર આતા. ");
INSERT INTO gbl_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","જોવે ચ્યાહાવોય કર્જા ચૂકવા હાટી નાંય રોયા, યાહાટી દોણ્યાય ચ્યાહા બેનહયા કર્જા માફ કોઇ દેના, તોવે ચ્યા બેન જાઅહામાઅને કું ચ્યાવોય વોદારે પ્રેમ રાખરી?” ");
INSERT INTO gbl_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","સિમોનાય જાવાબ દેનો, “મા રીતે, જ્યા વોદારે કર્જા માફ કોઅયા.” તોજ, ઈસુવે ચ્ચાહાન આખ્યાં, “તુયે હાચ્ચો જાવાબ દેનો.” ");
INSERT INTO gbl_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","પાછે ચ્યે બાયે એછે ફિરીન ઈસુય સિમોનાલ આખ્યાં, “યે બાઈલ તુયે દેખી કા? આંય તો ગોઓ યેનો, તેરુ તુયે પોતાના રીતે નુસાર માન પાગ દોવાં પાઆઈ નાંય દેના, બાકી યે બાયે આહાંવાહાં કોઇન મા પાગ બીજવી દેના, એને ચ્યે કિહીહયાકોય નુંહયા. ");
INSERT INTO gbl_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","તુયે માન નાંય ચૂમ્યા બાકી આંય જોવાળ્યો યેનો તોવાળ્યો ચ્યે મા પાગહાલ ચુમના નાંય છોડયા. ");
INSERT INTO gbl_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","તુયે મા ટોલપાલ તેલ બી નાંય લાવ્યાં, બાકી યે બાયે મા પાગહાલ અત્તાર લાવ્યહા. ");
INSERT INTO gbl_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","યાહાટી આંય તુલ આખતાહાવ કા, યે બોજ પાપ કોઅલા આતા, તી માફ જાયા, કાહાકા ચ્યે બોજ પ્રેમ કોઅયા; બાકી જ્યા ઓછા માફ ઓઅયાહા, તીં ઓછીજ દયા રાખી.” ");
INSERT INTO gbl_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","“એને ચ્યેય બાયેલ આખ્યાં, તો પાપ માફ જાયા.” ");
INSERT INTO gbl_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","તોવે જ્યા લોક ચ્યાઆરે ખાં બોઠલા, ચ્યા ચ્યાહા ચ્યાહાજ મોનામાય વિચાર કોઅરા લાગ્યા, “ઓ કું હેય, કા જો પાપહા બી માફી દેહે?” ");
INSERT INTO gbl_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","બાકી ચ્યેય ચ્યે બાયેલ આખ્યાં કા, “પોરમેહેરાય તુલ બોચાવી લેદલી હેય કાહાકા તુયે માયેવોય બોરહો કોઅયો. તું આમી શાંતીકોય જાતી રો.” ");
INSERT INTO gbl_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ચ્યા પાછે તો શેહેરામાય એને ગાવહામાય હિકાડતો એને પોરમેહેરા રાજ્યા બારામાય હારી ખોબાર આખતો ફિરે, એને ચ્યા બારા શિષ્યબી ચ્યાઆરે આતા. ");
INSERT INTO gbl_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","એને કોલ્યોહોક બાયોબી આત્યો જ્યો બુતા આત્મા એને જાત જાત્યા દુ:ખામાઅને હાર્યો જાયલ્યો, ચ્યેહેમાઅને યોક જયેમાઅને હાંત બુત કાડલા તી મરિયમ જીં મગદલા ગાવા આતી. ");
INSERT INTO gbl_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","એને હેરોદ રાજા કારબારી ખુજા થેએયો યોઅન્ના એને સુસન્ના એને આજુ બોજ બાયો, યો બાયો ચ્યેહે મિલકાત માઅને ઈસુ એને ચ્યા શિષ્યહા સેવા કોઅત્યો આત્યો. ");
INSERT INTO gbl_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","જોવે મોઠી ગીરદી બેગી ઓઈ ગીયી, એને શેહેરામાઅને લોક ચ્યાપાય યેતા આતા, તોવે ઈસુય ચ્યાહાન દાખલો દેયને આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“યોક ખેડુત, બિયારો પોઆ રાનામાય ગીયો. એને પોએ તોવે કોલહોખાન બિયારો વાટે મેરે પોડયો, એને આકાશામાઅને ચિડેં પોડીન તી ટોચી ખાય ગીયે. ");
INSERT INTO gbl_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","કોલહોખાન ખડકાવાળી જમીનમાય પોડ્યા, એને ઉદ્યો, બાકી પુરતો કાદુ નાંય મિળ્યો ચ્યાહાટી ઉખાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","થોડહો બિયારો તે કાટાહા જેખરાહામાય પોડયો, બાકી ઉદ્યો પાછે જેખરાહાકોય દાબાય ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","“કોલહોખાન બિયારો હારી જમીનીમાય પોડયો, એને ઉદ્યો પાછે ચ્યા હોવ ગોણા ફળ યેના,” ઈ આખીન ઈસુય મોઠેરે બોંબલીન આખ્યાં, “જો વોનાયાંહાટી તિયાર હેય તો વોનાય લેય.” ");
INSERT INTO gbl_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ઈસુવા શિષ્યહાય ચ્યાલ પુછ્યાં, “યા દાખલા મોતલાબ કાય હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ઈસુવે આખ્યાં, “તુમા તે પોરમેહેરા રાજ્યા દોબલી વાતો જાંઅતાહા, બાકી જ્યા માયેવોય બોરહો નાંય કોએત ચ્યાહાન તે દાખલાજ દેયને હિકાડાં પોડહે, કાહાકા ચ્યા એએયા કોઅતાહા બાકી જાઅએ નાંય, એને વોનાતાહા બાકી હોમજેત નાંય.” ");
INSERT INTO gbl_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","“દાખલા મોતલાબ ઓ હેય, બિયારો પોરમેહેરા વચન હેય. ");
INSERT INTO gbl_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","વાટે મેરાવોયને ચ્યેહેય, જોવે ચ્યા વચન વોનાયા, તોવે ચ્યાહા મોનામાઅને સૈતાન વચન વિહરાવી દેહે, યાહાટી કા એહેકેન નાંય ઓએ પોરમેહેરાવોય બોરહો કોઇન તારણ મિળવે. ");
INSERT INTO gbl_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ખોલકાડાવાળા જમીનીવોઅને ચ્યા લોક હેય, જોવે વચન વોનાતેહે, તોવે આનંદાકોય માની લેતહેં, બાકી પોરમેહેરા વચન ચ્યાહા મોનામાય ઉંડે મુળે નાંય ઉત્યા, ચ્યાહાટી ચ્યે વોછા દિહાપુરતે બોરહો કોઅતેહે, એને પરીક્ષા સમયે ઈસુલ છોડી દેતહેં. ");
INSERT INTO gbl_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","જો કાટાહા જેખરાહામાય પોડયો, ચ્યે યે હેય, જ્યેં વચન વોનાતેહે, બાકી આગાડ્યા જીવનામાય ચિંતા, પોયહા લોબ, એને મોજ્યા કોઅનામાય ફસાય જાતહેં, એને નોકામ્યા જીવન જીવતેહે. ");
INSERT INTO gbl_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","બાકી હારી જમીનીમાય તે યે હેતેં, કા પોરમેહેરા વચન વોનાયને હારાં એને ચોખ્ખાં મોનાકોઈન માની લેતહેં, એને ચ્યે ધીરજથી ફળ દેતહેં.” ");
INSERT INTO gbl_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","“કાદોબી દિવો લાવીન ટોપલી તોળે નાંય થોવેત, નાંય ચ્યાલ ખાટલા તોળે થોવે, બાકી ચ્યાલ ઉચે દિવત્યા વોય થોવતેહે કાહાકા તોવે ચ્યા ઉજવાડો ગાઆમાય યેનારાહાલ મીળે. ");
INSERT INTO gbl_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","કાહાકા કોઅહીજ વસ્તુ ઓહડી નાંય હેય કા તી ડાકલી રોય એને યોકતી વસ્તુ ઓહડી નાંય હેય કા તી દુબાડી હોકાય બાકી બોદાંજ ખુલ્લાં પોડી જાય. ");
INSERT INTO gbl_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","ચ્યાહાટી તુમા હાચવીન રા, કા તુમા કાય વોનાતેહે? કાહાકા જ્યા પાય હોમાજ હેય, તો વોદારી હોમાજ મેળવી, બાકી જ્યા પાય કાય હોમાજ નાંય મીળે, ચ્યાપાય જીં વોછીબી હોમાજ ઓરી તીં બી ચ્યાપાઅને ખોવાય જાય.” ");
INSERT INTO gbl_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ઈસુવા આયહો એને ચ્યા બાહા ચ્યાપાય યેના, બાકી ગીરદી લેદે ચ્યે ઈસુલ નાંય મિળી હોક્યે. ");
INSERT INTO gbl_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","તોવે ઈસુવાલ આખ્યાં, “તો આયહો એને બાહા બાઆ ઉબે રીઅલે હેતેં, ચ્યે તુલ મિળાં માગતેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","તોવે ઈસુય ચ્યાહાન એહેકોય જાવાબ દેનો કા, “જ્યેં પોરમેહેરા વચન વોનાતેહે એને પાળતેહે ચ્યેજ મા આયહો એને બાહા હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","પાછે યોક દિહી ઈસુ, એને ચ્યા શિષ્ય ઉડીમાય ચોડયા, તોવે ઈસુવે શિષ્યહાન આખ્યાં, “ચાલા, આપા દોરિયા ચ્યેમેરે જાતા” પાછે ચ્યાહાય ઉડી છોડી. ");
INSERT INTO gbl_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","જોવે ઉડી જાય રિઅલી આતી, તોવે તો હૂવી ગીયો; તોવે દોરિયામાય તોફાન યેના એને પાઅયા કોઇન ઉડી બોઆયા લાગી ચ્યા આબદામાય પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","તોવે શિષ્યહાય ચ્યાપાય જાયને જાગાડયો, એને આખ્યાં, “પ્રભુ! પ્રભુ! આપા બુડી જાનારા હેય” તોવે ઉઠીન ચ્યા તોફાની વારાલ એને પાઅયા લાફહાલ દોમકાડયા તોવે તી બોદા થોબી ગીયા, એને શાંત ઓઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","તોવે ઈસુવે શિષ્યહાન આખ્યાં, “તુમહે બોરહો કેછ આતો?” બાકી ચ્યા ગાબરાય ગીયા એને નોવાય પામીન યોકબિજાલ આખા લાગ્યા, “ઓ કું હેય, જો તોફાન એને દોરિયા પાઅયાલ બી તો આગના કોઅહે, એને તી ચ્યા માનતેહેં?” ");
INSERT INTO gbl_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","પાછે ઈસુ એને ચ્યા શિષ્ય ગીરાસેનિયા ભાગામાય ગીયા, જીં દોરિયા ચ્યેમેરે ગાલીલ ભાગા હામ્મે હેય. ");
INSERT INTO gbl_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","જોવે ચ્યા દોરિયા ચ્યેમેરે પોઅચ્યા, તોવે ચ્યા શેહેરા ચ્યાલ યોક માઅહું મિળ્યાં, જ્યાલ બુત વોળાગલો આતો, એને બોજ દિહહાથી તો ફાડકે નાંય પોવે એને ગોઓ નાંય રોય, બાકી તો માહણામાય રોયા કોઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ચ્યાય ઈસુલ દેખ્યો તોવે બોંબલ્યો, એને ચ્યા આગલા ઉંબડો પોડીન આખ્યાં, “ઓ પરમપ્રધાન પોરમેહેરા પોહા ઈસુ! માન તું કાહા હેરાન કોઅતોહો? આંય તુલ વિનાંતી કોઅતાહાંવ, કા માન પીડા મા દેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","કાહાકા ઈસુ ચ્યામાઅને ચ્યા બુતાલ નિંગી જાઅના આગના દી રિઅલો આતો, યાહાટી કા બુત ચ્યા માઅહાલ વારે ગેડી તકલીફ દેતો આતો, જોવે લોક ચ્યાલ હાકળે કોઇન એને બેડયો ટાકીન બાંદેત, તેરુંબી તો તોડી ટાકતો આતો, એને બુત ચ્યાલ ઉજાડ જાગામાય તાંગાડતા ફિરતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","તોવે ઈસુવે ચ્યાલ પુછ્યાં, “તો નાંવ કાય હેય?” ચ્યેય આખ્યાં “સેના” કાહાકા બોજ બુત ચ્યામાય વોળાગલા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ચ્યાહાય ચ્યાલ વિનાંતી કોઅયી કા, “આમહાન બોજ ઉંડા ખાડામાય જાઅના આગના મા કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","તોવે તાં ડોગાવોય ડુકરાહા યોક મોઠો ટોળો ચોઅયા કોએ, તોવે બુતે ઈસુલ વિનાંતી કોઅયી, “આમહાન ડુકરાહામાય દોવાડ ચ્યાહામાય નિંગી જાહું.” ");
INSERT INTO gbl_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ઈસુવે ચ્યાહાન પરવાનગી દેની, તોવે બુત નિંગીન ડુકરાહામાય ઉરાય ગીયે, એને બોદો ટોળો કોરાડા ઉપને દોરિયામાય જાયન ટુટી પોડયો, એને બુડી મોઅયો, તો લગભગ બેન ઓજાર ડુકરાહા ટોળો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ચ્યા ટોળા ગોવાળ ઈ દેખીન નાહી પોડ્યા એને શેહેરામાય એને ગાવામાય જાયને ચ્યાહાય ઈ વાત આખી. ");
INSERT INTO gbl_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","એને લોક જીં જાયેલ તી એરાહાટી ગીયા, તોવે ચ્યાહાય જ્યામાઅને બુત નિંગલા ચ્યા માઅહાલ ઈસુવાપાય ફાડકે પોવલે એને હારો ઓઇન ભાનમાય દેખ્યો તોવે ચ્યા બિઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","એને એએનારા માઅહાય આખ્યાં કા જ્યાલ બુત વોળાગલો માઅહું આતા ચ્યા કેહેકેન બોચાવ જાયો. ");
INSERT INTO gbl_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","તોવે ગીરાસેનિયા ભાગા આહીપાહીલ્યા લોકહાય ઈસુવાલ વિનાંતી કોઅયી કા, આમહે પાયરે જાતો રો; કાહાકા ચ્યા બોજ બિઇ ગીઅલા આતા, તોવે ચ્યા ઉડીમાય બોહીન જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","જ્યા માઅહામાયને બુત કાડયો તો, ઈસુલ રાવ્યાં કોઇન આખા લાગ્યા, કા માન તોઆરે રા દે, બાકી ઈસુવે ચ્યાલ દોવાડીન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“તો ગોઓ જો એને તો જાતલાહાન આખી દે, કા તોહાટી પોરમેહેરે કોહડે હારેં કામ કોઅલે હેય” તોવે તી માઅહું, ઈસુવે ચ્યાહાટી કોલાં હારાં કામહા બારામાય ગાલીલ વિસ્તારા દોહો શેહેરામાય જ્યાલ દોકાપલીસ આખતેહે ચ્યાહામાય જાયન પ્રચાર કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","જોવે ઈસુ પાછો ફિરી યેનો, તોવે લોક ચ્યાલ આનંદથી મિળ્યાં, કાહાકા લોક ઈસુવા વાટ જોવેત. ");
INSERT INTO gbl_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","તોવે યાઈર નાંવા યોક માઅહું જો સોબાયે ઠિકાણા આગેવાન આતો, તો યેનો, એને ઈસુવા પાગે પોડીન વિનાંતી કોઅરા લાગ્યો, “મા ગોઓ ચાલ.” ");
INSERT INTO gbl_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","કાહાકા ચ્યા બાર વોરહા યોખલી પોહી આતી, એને તી મોઅઇ જાયના અણ્યેવોય આતી, જોવે ઈસુ જાય રિઅલો આતો, તોવે લોક ચ્યા આગલા ગીરદી કોએત આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","તાં યોક બાઈય જ્યેં બાર વોરહાથી લોય પોડના બિમારી આતી, એને ચ્યેય ચ્યે બોદી મિલકાત વૈદયાહા પાય ખોરચી કાડયેલ, તેરુંબી ચ્યે બિમારી હારી નાંય જાયેલ. ");
INSERT INTO gbl_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ચ્યેય પાસાડીને યેયન ઈસુવા ફાડકાલ આથ લાવ્યો, એને તારાતુજ ચ્યે લોય પોડના થોબી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","યાહાટી ઈસુય આખ્યાં, “માન કુંયે આથ લાવ્યો?” તોવે બોદે નાકારા લાગ્યેં, તોવે પિત્તર એને ચ્યા શિષ્યહાય આખ્યાં, “ઓ પ્રભુ, તુલ તે લોકહા ગીરદી બિચડેહે એને પોડાપોડી કોઅતેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","બાકી ઈસુવે આખ્યાં કા, “માન કુંયે આથ લાવ્યો, કાહાકા માયે જાંઅયા કા માયેમાઅને કામ કોઅના સામર્થ્ય નિંગ્યહા.” ");
INSERT INTO gbl_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","જોવે ચ્યે બાઈ જાંઅયા, કા આંય દોબી નાંય હોકુ, તોવે તી કાપતી-કાપતી યેની એને ઈસુ પાગે પોડીન બોદા લોકહા હામ્મે આખ્યાં, કા માયે કોઅહા કારણા લીદે ફાડકાલ આથ લાવ્યેલ, એને કેહેકેન તારાતુજ હારી ઓઈ ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ઈસુવે ચ્યેલ આખ્યાં “બોઅહી ઈંમાત રાખ; માયે તો બોચાવ કોઅલા હેય, કાહાકા તુયે માયેવોય બોરોહો કોઅલો હેય, આમી તુલ એલી બિમારી નાંય લાગે, તું શાંતીકોય જો.” ");
INSERT INTO gbl_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ઈસુ ચ્યેલ આખીજ રિઅલો આતો, તોવે સોબાયે ઠિકાણા આગેવાના ગોઆ એહેરે બિજા લોકહાય યેયન યાઈરાલ આખ્યાં, “તો પોહી મોઅઇ ગિઇ, ગુરૂવાલ આબદા મા દેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ઈસુય ઈ વોનાઈન ચ્યાલ આખ્યાં, “બીયહે મા; માયેવોય બોરહો રાખ, તોવે તો પોહી બોચી જાઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","એને ઈસુય ગોઅમે પિત્તર, યાકૂબ એને યાકૂબા બાહા યોહાન, એને યાઈર એને ચ્યા થેએ ચ્યાહા સિવાય ચ્યાઆરે બિજા કાદાલ નાંય યા દેના. ");
INSERT INTO gbl_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","તોવે ચ્યે ચ્યાહાન રોડતા એને કાકાહા કોઅતા દેખ્યા. તોવે ઈસુવે ગોઅમે જાયન, ચ્યાહાન આખ્યાં કા, “તુમહાન કાકાહા કોઅના એને રોડના ગોરાજ નાંય હેય, પોહી મોઓઈ નાંઈ ગીયહી બાકી, હૂવી રીયલી હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","બાકી લોક ચ્યા મશ્કરી કોઅરા લાગ્યા, ચ્યાહાટી ચ્યે બોદહાન બાઆ દોવાડી દેના, એને આયહે આબહાલ એને પિત્તર, યાકૂબ એને યાકૂબા બાહા યોહાન યાહાન આરે લેઈને, પોહી હુતલી આતી તાં ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","પોહયી આથ દોઓઈન ઈસુવે પોહોયીલ આખ્યાં, “તાલીતા કુમ” યા મોતલાબ હેય, “ઓ પોહી, આંય તુલ આખહુ, ઉઠ.” ");
INSERT INTO gbl_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","તોવે તી પોહી તારાતુજ ઉઠીન ચાલા-ફિરા લાગી, પાછે ઈસુય ચ્યાહાન આખ્યાં, કા ચ્યેલ કાય ખાંહાટી દા. ");
INSERT INTO gbl_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ચ્યે આયહો આબહો બોજ નોવાય પામ્યે, બાકી ઈસુવે ચ્યાહાન ચેતાવણી દેયન આખ્યાં, કા ઈ વાત કાદાલ નાંય આખના. ");
INSERT INTO gbl_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","પાછે ઈસુવે બાર શિષ્યહાન હાદ્યા એને ચ્યાહાન બોદા બુતાહાલ લોકહામાઅને કાડના પુરો સામર્થ્ય દેનો, એને દુઃખહ્યાન હારેં કોઅરાહાટી ઓદિકાર દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","એને ચ્ચાહાન પોરમેહેરા રાજ્યા હારી ખોબાર દાં એને દુખ્યાહાન હારેં કોઅરા ચ્યાહાન દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ચ્યે ચ્યાહાન આખ્યાં, “વાટેહાટી કાય નાંય લેઅના, લાકડી નાંય, કા ઠેલી નાંય, કા બાખે નાંય, પોયહા નાંય, એને બેન-બેન ઝોબા નાંય રાખના. ");
INSERT INTO gbl_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","એને જ્યા ગોઆમાય જાહા, તાંજ રા; એને તાઅનેજ રાજા લેઈને જાયા.” ");
INSERT INTO gbl_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","એને જાં તુમહાન લોક નાંય હાદેત, તાંઅરે નિંગી જાયા, એને ચ્યાહાન નિશાણી દાંહાટી, તુમહે પાગહા આરેને ઉદળાં તાંજ ખેખરી ટાકજા, ચ્યાહાન ઈ ચેતાવણી દાંહાટી કા પોરમેહેરા એહેરે મિળનારી સાજા ચ્યા પોતેજ જાબાવદાર હેય. ");
INSERT INTO gbl_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ચ્યા નિંગીન ગાંવે-ગાંવે હારી ખોબાર આખતા, એને બોદી જાગે દુ:ખ્યાહાન હારેં કોઅતા ફિરતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","એને ઈ બોદા જીં બોન્યાં તી હેરોદ રાજા વોનાયો, એને વિચારમાય પોડયો, કાહાકા કોલહાખાન જાંએ આખે કા, “યોહાન મોઅલા માઅને પાછો જીવતો ઉઠયહો.” ");
INSERT INTO gbl_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","બોજ લોક આખે કા, “એલીયો ભવિષ્યવોકતો હેય” એને બિજા લોક આખે કા, “પેલ્લા ભવિષ્યવક્તાહા માઅને કાદો પાછો જીવતો ઉઠયહો.” ");
INSERT INTO gbl_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","બાકી હેરોદ રાજાય આખ્યાં, “યોહાન બાપતિસ્મા દેનારા તે માયે ટોલપી વાડી ટાકાડયેલ, જ્યા બારામાય આંય ઓહડી વાત વોનાતાહાવ, તો ઓ કું ઓરી?” એને ચ્યાય ચ્યાલ એઅરા ઇચ્છા કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","જોવે ચ્યા બાર પ્રેષિત, જ્યાહાન ઈસુવે દોવાડલા આતા ચ્યા ફિરી યેના, એને યેયન ચોમખી યોકઠા જાયા, એને ચ્યાહાય જીં કાય કોઅયા એને હિકાડયાં તીં બોદા ઈસુલ આખી દેખાડયાં. પાછે ચ્યાહાન આલાગ કોઇન બેતસાદા નાંવા શેહેરામાય લેય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","બાકી લોકહાન ખોબાર પોડી ગિઇ, એને લોક ઈસુઇહી યેના, તોવે ઈસુય ચ્યાહાઆરે ખુશીને હાતે મિળ્યો, એને ચ્યાહાઆરે પોરમેહેરા રાજ્યા વાત કોઅરા લાગ્યો, એને જ્યેં હારેં ઓઅરા માગતે આતેં, ચ્યાહાન હારાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","એને જોવે દિહી બુડા લાગ્યો, તોવે ચ્યા બાર શિષ્યહાય ઈસુવાપાય યેઇન આખ્યાં, “લોકહાન જાં દે કા ચોમખી ગાવહામાય એને ફોળી-ફોળહી માય જાયન ચ્યાહાહાટી રોઅના એને ખાઅના વ્યવસ્થા કોએ, કાહાકા આપા ઈહીં એકાંત જાગામાય હેજે.” ");
INSERT INTO gbl_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","બાકી ઈસુવે ચ્યાહાન આખ્યાં, “તુમા ચ્યાહાન ખાઅના દા” ચ્યાહાય આખ્યાં, આમહાપાય પાચ બાખે એને બેન માછલાહા સિવાય બિજા કાયજ નાંય હેય; બાકી હાં, જો આમા જાયન બોદા લોકહાહાટી ખાઅના વેચાતાં લેય યેજે, તોવે ઓઈ હોકહે. ");
INSERT INTO gbl_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","તાં લગભગ પાચ ઓજાર માટડા આતા, તોવે ઈસુવાય ચ્યા શિષ્યાહાન આખ્યાં, “પોચહા-પોચહા લોકહા પાંગાત કોઇન ચ્યાહાન બોહાડા.” ");
INSERT INTO gbl_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ચ્ચાહાય એહકોયજ કોઅયા, એને બોદા લોકહાન બોહતેં કોઅયે. ");
INSERT INTO gbl_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ઈસુય પાચ બાખે એને બેન માછલે લેદા, એને હોરગા એછે એઇન બોરકાત માગી, એને બાખે મૂડી-મુડીન લોકહાન વાટી દાંહાટી શિષ્યહાન દેન્યો. ");
INSERT INTO gbl_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","બોદહાય દારાયે તાંઉલોગુ ખાદાં એને ચ્યાહાપાઅને વોદ્યાં તી બેગા કોઅયા, તોવે ચ્યા બાર ટોપલેં બોઆયે. ");
INSERT INTO gbl_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","જોવે તો એકાંતમાય જાયન પ્રાર્થના કોઅહે, તોવે ચ્યાઆરે શિષ્યબી આતા તોવે ઈસુવે ચ્યાહાન પુછ્યાં કા માઅહે માન કાય આખતેહે.? ");
INSERT INTO gbl_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","શિષ્યહાય જાવાબ દેનો, “કોલહાક યોહાન બાપતિસ્મા દેનારો, કોલહાક એલીયા, એને આજુ બિજા એહેકોય માનતાહા કા પેલ્લા ભવિષ્યવક્તાહા માઅને કાદો ભવિષ્યવક્તા પાછો જીવી ઉઠયહો.” ");
INSERT INTO gbl_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","તોવે ઈસુવે શિષ્યહાન પુછ્યાં કા, “બાકી તુમા મા બારામાય કાય વિચાર કોઅતાહા કા આંય કું હેય?” તોવે પિત્તરે જાવાબ દેનો, “પોરમેહેરા ઇહિને દોવાડલો ખ્રિસ્ત હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","તોવે ઈસુવે શિષ્યહાન ચેતાવણી દેયન આખ્યાં કા, “મા બારામાય કાદાલ આખના નાંય કા આંય ખ્રિસ્ત હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","એને ઈસુવે આખ્યાં, “માન માઅહા પોહાહાટી ઈ જરુરી હેય, કા બોજ દુ:ખ વેઠાં પોડી, એને યહૂદી આગેવાન, મુખ્ય યાજક એને મૂસા નિયમ હિકાડનારા ગુરુ માન નાકારી દી એને માઆઇ ટાકી, એને તીન દિહી પાછે તો પાછો જીવતો ઉઠી.” ");
INSERT INTO gbl_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","એને શિષ્યહાઆરે લોકહાન હાદિન ચ્યે આખ્યાં, “જો કાદાં મા શિષ્ય બોના માગહે, ચ્યાલ પોતાલ નાકાર કોઅરા જોજે એને પોતાનો હુળીખાંબ ઉચકીન મા શિષ્ય બોને. ");
INSERT INTO gbl_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","કાહાકા જીં માઅહું દોરતીવોય પોતે જીવ બોચાવાં માગહે, તો હાચ્ચાં જીવન ગુમાવી દી, બાકી જો મા લીદે ચ્યા જીવ દેહે, તો અનંતજીવન મેળવી. ");
INSERT INTO gbl_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","યોક માઅહાલ કાય ફાયદો ઓઅરી, જોવે ચ્યાલ બોજ મિલકાત મીળે બાકી પોરમેહેરાઆરે અનંતજીવન ગુમાવી દેય? ");
INSERT INTO gbl_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","જો તુમહેમાઅને કાદો માન પોરમેહેરા હારકો માના એને મા વાતો પાળાહાટી મોનાઈ કોઅહે, કાહાકા પોતે ગાબરાતાહા કા યા સોમાયા પાપી લોક તુમહે નુકસાન કોઅરી, પાછે આંય, માઅહા પોહો મોનાઈ કોઅય દિહીં કા તુમા મા શિષ્ય હેય, જોવે આંય પવિત્ર હોરગા દૂતહા આરે દોરતીવોય પાછો યીહીં, તોવે બોદા મા મહિમા પ્રતાપ દેખી, જો મા આબહા હારકો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, ઈહીં ઉબલા કોલહાક લોક તોવેબી જીવતા રોય, જોવે ચ્યા પોરમેહેરા રાજ્ય સામર્થ્યાકોય ચ્યાહા વોચ્ચે યેતા દેખી.” ");
INSERT INTO gbl_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","યો બોદ્યો વાતો પુર્યો જાયો, ચ્યા પાછે આઠખાન દિહી જાયા, તોવે ઈસુ પિત્તર, યાકૂબ એને યોહાનાલ લેઈને પ્રાર્થના કોઅરાહાટી ડોગાવોય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","એને પ્રાર્થના કોઅહે તોવે ચ્યા રુપ બોદલાઈ ગીયા એને ચ્યા ફાડકે ઉજળેં ઓઇન ચોમાકતે લાગ્યેં. ");
INSERT INTO gbl_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","એને એએ, બેન ભવિષ્યવક્તા મૂસા એને એલીયા, ઈસુવાઆરે વાતો કોઅતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ઈ મહિમાહાતે દેખાયો, એને ઈસુ મોઅના બારામાય બોલેત જીં યેરૂસાલેમ શેહેરામાય ઓઅનારા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","બાકી પિત્તર એને ચ્યા હાંગાત્યા ચ્ચાઆરે નિંદેમાય આતા, બાકી જોવે ચ્યા પુરાં રીતે કોઅય જાગી ઉઠયા, તોવે ચ્યાહાય ઈસુ મહિમા એને ઈસુઆરે ઉબા રીઅલા બેન માટડાહાલ દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","એને જોવે ચ્યા જાતા લાગ્યા તોવે પિત્તરાય ઈસુવાલ આખ્યાં, “ઓ ગુરુજી, આપા ઈહીં રોજે તીં હારાં હેય, આમા તીન માંડવા બોનાડુહુ, યોક તોહાટી, યોક મૂસા હાટી એને યોક એલીયા હાટી” તો જાંઅતો નાંય આતો, કા કાય આખી રિઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","તો ઈ આખતોજ આતો તાંઉ યોક વાદળાં યેઇન ચ્ચાહાલ ડાકી લેદા, તોવે ચ્યાહાન બિયાં યેના. ");
INSERT INTO gbl_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","એને વાદળાં માઅને આવાજ જાયો કા, “ઓ મા પોહો મા પોસાન કોઅલો હેય, ચ્યા આખલા વોનાયા.” ");
INSERT INTO gbl_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","આવાજ જાયો તોવે એહેકોય જાયા કા ઈસુ યોખલોજ આતો એને ચ્યા ઠાવકાજ રિયા, એને ચ્યાહાય જીં દેખ્યા તીં ચ્યા દિહીહામાય ચ્યાહાય કાદાલ આખ્યાં નાંય. ");
INSERT INTO gbl_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","બીજે દિહી જોવે ચ્યા ડોગા ઉપને ઉત્યા, તોવે યોક મોઠી ગીરદી ચ્યાલ મિળી. ");
INSERT INTO gbl_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","તોવે, ટોળામાઅને યોક માઅહે મોઠેરે બોંબલીન આખ્યાં, “ગુરુજી તુલ આથ જોડું, મા પાહાવોય દયા કોઓ, કાહાકા ઓ યોકુજ પોહો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","એને એએ યોક બુત ચ્યાલ દોઅહે, એને તો અચાનક ચીચાઈ ઉઠહે પાછે ચ્યાલ આફળી પાડહે, એને ચ્યા મુયામાઅને ગોંડો નિંગહે એને ચ્યાલ બોજ આબદા પાડીન છોડહે. ");
INSERT INTO gbl_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","તો શિષ્યહાન માયે બુતાલ કાડના વિનાંતી કોઅયી, બાકી ચ્યા કાડી નાંય હોક્યા.” ");
INSERT INTO gbl_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ઈસુવે ચ્યાહાન જાવાબ દેનો કા “ઓ બોરહો નાંય થોવનારા લોકહાય એને લુચ્ચી પીડી, તુમહેઆરે કોલાહા લોગુ રોઉં? કોલાહા લોગુ તુમહાન વેઠું? ચ્યાલ તુમા માયેપાંય લેય યા.” ");
INSERT INTO gbl_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","તો આજુ યેય તોલાહામાય બુતે ચ્યાલ આફળી પાડ્યો બાકી ઈસુવે બુતાલ દોમકાડયો, એને પાહાલ હારો કોઇન ચ્યા આબહાલ પાછો હોંપી દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","એને બોદા લોકહાન પોરમેહેરા મહાસામર્થ્યા ઉપે બોજ નોવાય લાગી, બાકી જોવે બોજ લોક ચ્ચા બોદા કામહા જીં ઈસુ કોઅતો આતો ચ્યા બારામાય નોવાય પામી રીઅલા આતા, તોવે પોતાના શિષ્યહાન ઈસુવે આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“ઈ વાત તુમા દિયાન દેયન વોનાયા, આંય, માઅહા પોહો, મા દુશ્માનાહા આથામાય દોરાય જાનારો હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","બાકી ઈ વાત ચ્યાહાન હોમાજ નાંય પોડી, એને ચ્યાહાહાટી ઈ વાત ગુપ્ત રોયી, એને તી ચ્યાહાન નાંય હોમજ્યા, તેરુંબી ચ્યાલ ઈ વાત પૂછાહાટી બિઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","પાછે શિષ્યહામાય ઓહડી બોલા-બોલી ચાલી, કા આપહામાય કું મોઠો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","બાકી ઈસુ શિષ્યહા મોના વિચાર જાંઆય ગીયો, એને યોકા પાહાલ લેયને ચ્યા પાહે ઉબો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ચ્ચાય ચ્ચાહાન આખ્યાં, “જો કાદોબી મા લીદે યા પોહાલ માની લેહે, તો હાચ્ચાંજ મા માની લેહે, જો કાદો મા માની લેહે, તો હાચ્ચાંજ પોરમેહેરાબી માની લેહે, જ્યાંય માન દોવાડયોહો. કાહાકા તુમહેમાઅનો જો બોદહા કોઅતો વાહાનો હેય, તોજ મોઠો હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","તોવે યોહાને ઈસુવાલ આખ્યાં, “ઓ ગુરુ, આમહાય યોકા માઅહાલ તો નાંવા ઓદિકાર ઉપયોગ કોઇન બુતાલ કાડતા દેખ્યાં, એને આમા ચ્યાલ ઓટકાડા લાગ્યા, કાહાકા તો આપહે શિષ્યહા માઅને નાંય આતો.” ");
INSERT INTO gbl_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ઈસુવે ચ્યાહાન આખ્યાં, “ચ્યાલ ઓટકાડાહા મા, જો માઅહું તુમહે દુશ્માન નાંય હેય, તો તુમહે હાંગાત્યો હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","જોવે ઈસુ ઉપે લેવાય જાઅના દિહી પુરાં ઓઅતા ગીયા, તોવે ચ્યે યેરૂસાલેમ શેહેરા એછે જાંહાટી નોક્કી કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","એને આગલાને ખોબાર દાંહાટી ચ્યે સંદેશ લેય યેનારા દોવાડીયા, ચ્યા સમરૂની યોકા ગાવામાય ગીયા, કા ઈસુહાટી જાગો તિયારી કોએ. ");
INSERT INTO gbl_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","બાકી ચ્યા લોકહાય ઈસુલ તાં રા નાંય દેના કાહાકા તો યેરૂસાલેમ શેહેરામાય જાય રિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ઈ એઇન ચ્યા શિષ્ય યાકૂબ એને યોહાને ચ્યાલ આખ્યાં, “ગુરુજી તું આખે તોવે આકાશામાઅને આગ પોડીન ચ્યાહાન નાશ કોઅરાહાટી આમા પ્રાર્થના કોઅજે.” ");
INSERT INTO gbl_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","બાકી ઈસુવે ફિરીન ચ્યાહાન ખિજવાયો એને આખ્યાં, “તુમા કોહડા મોનવાળા હેતા તીં તુમહાન ખોબાર નાંય હેય. કાહાકા માઅહા પોહો માઅહા જીવ માઆઇ ટાકાંહાટી નાંય, બાકી બોચાવાં હાટી યેનો.” ");
INSERT INTO gbl_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","એને ચ્યા બિજા દુઉ ગાવામાય નિંગી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","વાટે ચાલતા યોક જાંએ ઈસુલ આખ્યાં, “તું જાં જાહાય, તાં આંય તોઆરે યીહીં.” ");
INSERT INTO gbl_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ઈસુવે ચ્યાલ આખ્યાં “કોલાહા દોર હેતા, એને આકાશામાય ઉડતા ચિડહા ગોરા હેતા; બાકી આંય, માઅહા પોહાપાય યોક ગુઉ બી નાંય હેય કા જાં આંય હૂવી હોકુ.” ");
INSERT INTO gbl_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ઈસુય બિજા યોકાલ આખ્યાં, મા શિષ્ય બોની જો, ચ્યાય આખ્યાં, “પ્રભુ, માન પેલ્લા મા ગોઓ જાં દે, મા આબહાલ આંય ડાટી દેયન યાંવ, પાછે આંય તો.” ");
INSERT INTO gbl_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ચ્યાલ ચ્યે આખ્યાં, “જ્યા લોક આત્મિક રીતે મોઅલા હેય, ચ્યાહાન ચ્યા લોકહા મોઅના વાટ જોવાં દે, બાકી તું જાયને પોરમેહેરા રાજ્યા વાત આખ.” ");
INSERT INTO gbl_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","એને આજુ યોકા બીજાય આખ્યાં, “ઓ પ્રભુ, તો પાહલા આંય ચાલહીં; બાકી પેલ્લા માન ગોઅને બોદહા રજા લાં દે.” ");
INSERT INTO gbl_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","બાકી ઈસુવે આખ્યાં, “જીં કાદો ઓળાલ દોઇન પાછલા એએહે, તો પોરમેહેરા રાજ્યાહાટી લાયકે નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","યે વાતહે પાછે પ્રભુ ઈસુય સીત્તેર શિષ્યહાન નિવડયા, એને જ્યા શેહેરાહામાય એને ગાવહામાય પ્રભુ પોતે જાં આતો, તાં ચ્યાહાન બેબુન-બેબુન કોઇન પોતાના આગાડી દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","તોવે ઈસુવે શિષ્યહાન આખ્યાં, “જેહેકોય રાનહા માય બોજ પાક રોહે, તેહેકોય બોજ લોક હેય, જ્યા પોરમેહેરાવોય બોરહો કોઅરાહાટી તિયાર હેય, બાકી પોરમેહેરા રાજ્ય બારામાય આખનારા લોક વોછા હેતા. ચ્યાહાટી તુમા રાનાવાળા માલિકાલ વિનાંતી કોઆ કા તો રાનામાય કામ કોઅરા લોક દોવાડે.” ");
INSERT INTO gbl_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","જાયા, આંય તુમહાન ગેટહા હારકા વરુહુ વોચમાય દોવાડતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","યાહાટી નાંય પાકીટ માય પોયહા, નાંય ઠેલી, નાંય વાઅણે લેઅના, એને વાટેમાય કાદાલ સલામ નાંય આખના. ");
INSERT INTO gbl_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","જોવે તુમા કાદા ગોઆમાય ગીયા તોવે પેલ્લા એહેકોય આખા, યા ગોઅમે બોરકાત રોય. ");
INSERT INTO gbl_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","એને જોવે ચ્યા ગોઆમાય બોરકાતે લાયક્યે ઓરી, તોવે તુમહે બોરકાત ચ્યા ઉપે રોય એને નાંય તોવે તુમહે બોરકાત તુમહેપાય વોળી યેઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","યોકુજ ગોઆમાય રોજા તુમહાન જીં દેત તીં ખાઅના ને પિઅના, કાહાકા કામ કોઅનારાલ ચ્યાહા કાંબારાં મિળાં જોજે, એને ગોઅહે-ગોઅહે મા જાતા. ");
INSERT INTO gbl_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","જોવે તુમા યોક શેહેરામાય જાહા, એને લોક તુમહે સ્વાગત કોઅઇ, તોવે જીં કાય દેય તીં ખાજા. ");
INSERT INTO gbl_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","તાઅને દુખ્યાહાન હારેં કોઅયા, એને ચ્યાહાન આખા કા પોરમેહેરા રાજ્ય તુમહે પાહે યેય પોઅચ્યાહા. ");
INSERT INTO gbl_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","એને જોવે તુમા યોક શેહેરામાય જાહા એને લોક તુમહે સ્વાગત નાંય કોઅઇ, તોવે શેહેરા આટામાય જાયને આખા. ");
INSERT INTO gbl_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","“આમહે પાગહા આરે લાગલો તુમહે શેહેરા ઉદળાં બી તાં ખેકરી ટાકજેહે, બાકી તુમા જાંઆઈ લીયા, કા પોરમેહેરા રાજ્ય તુમહે પાહે યેય પોઅચ્યાહા.” ");
INSERT INTO gbl_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","તુમહાન આંય આખતાહાવ, ન્યાયા દિહી, જીં સજા સુર એને સદોમ શેહેરાલ દી, તી સજા બોજ વોછી હેય જીં સજા તુમહાન દી. ");
INSERT INTO gbl_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“હાય ચ્યા લોક જ્યા ખુરાજીઈન શેહેરામાય રોતહા, હાય ચ્યા લોક જ્યા બેતસાદા ગાવામાય રોતહા, કાહાકા તુમહેમાય જ્યેં ચમત્કારા કામે કોઅલે, તોહડે કામે જોવે સુર એને સિદોના શેહેરામાય ઓઅતે, તોવે ચ્યા લોક બોજ પેલ્લા ઉપહા કોઇન, ટોલપાવોય બુમંર્યા ખેખરી લેતા, ચ્યા ઈ દેખાડાં હાટી કા પાપ કોઅના બંદ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","બાકી ન્યાયા દિહી, જીં સજા સુર એને સિદોનાલ દી, તી સજા બોજ વોછી હેય જીં સજા તુમહાન દી. ");
INSERT INTO gbl_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","એને કાપરનાહુમ ગાવા લોકહાય, કાય તુમા હોરગા લોગુ ઉચા ઓઅના આશા કોઅઇ રીઅલા હેય? તુમા નિચે અધોલોકમાય પાડી ટાકલા જાહા.” ");
INSERT INTO gbl_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","“ઈસુય પોતાના શિષ્યહાન આખ્યાં, જો તુમહે વોનાયેહે, તો મા વોનાયેહે, જો તુમહાન નાંય ગોણે, તો માન નાંય ગોણે, એને માન નાંય ગોણે, તો માન દોવાડનારા પોરમેહેરાલ બી નાંય ગોણે.” ");
INSERT INTO gbl_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","પાછે હિત્તેર શિષ્ય બોજ ખુશ ઓઇન પાછા વોળી યેયન આખ્યાં, “ઓ પ્રભુ, બુત બી આમે આખલ્યા માન્યા જોવે આમહાય તો નાવાકોય આગના કોઅયી.” ");
INSERT INTO gbl_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","બાકી ચ્યે ચ્યાહાન આખ્યાં, “માયે સૈતાનાલ હોરગામાઅને વીજ પોડહે તેહેકોય પોડતો દેખ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","માયે તુમહાન, હાપડા એને મીછડા ઉપે ચાલા એને દુશ્માના (સૈતાન) બોદા સામર્થ્યા ઉપે તુમહાન માયે ઓદિકાર દેનહો, એને કોઅહીજ વસ્તુકોય તુમહાન નુકસાન નાંય ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","બાકી ચ્યાહાટી ખુશ મા ઓઅતા કા બુતડે તુમહે આગના માનતેહેં, બાકી તુમહે નાંવે હોરગામાય લોખલે હેતેં, ચ્યાહાટી આનંદ કોઆ.” ");
INSERT INTO gbl_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ચ્યેજ સમયે ઈસુ પવિત્ર આત્મામાય આનંદાકોય બાઆય ગીયો, એને આખ્યાં, “ઓ આબા, હોરગા એને દોરતી માલિક, આંય તો આભાર માનતાહાવ કાહાકા તુયે યો બોદ્યો વાતો ઓકલ્યેવાળા લોકહાન એને હોમાજદાર લોકહાન નાંય, બાકી જ્યા લોક સાદા સુદા હેય ચ્યાહાન દેખાડયોહો, હાં, ઓ આબા, કાહાકા તુલ ઈંજ ગોમ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","મા આબહે માન બોદો ઓદિકાર દેય દેનહો, એને આબા સિવાય કાદો પાહાલ નાંય જાંએ, તેહેકેન પાહા સિવાય કાદો આબહાલ નાંય જાંએ, એને જ્યા લોકહાન આંય, પોહો નિવડે, ચ્યા લોક આબહાલ જાઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","એને પાછા ફિરી એઇન યોખલા શિષ્યહાન ચ્યે આખ્યાં, “તુમહે ડોળા ધન્ય હેય, કાહાકા યો વાતો ચ્યા એઅતાહા ");
INSERT INTO gbl_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","કાહાકા આંય તુમહાન હાચ્ચાં આખતાહાવ, બોજ ભવિષ્યવક્તા એને રાજહાય તુમા જીં એઅતાહા તી એરા ઇચ્છા રાખી, બાકી નાંય એએઈ હોક્યા એને તુમા વોનાતાહા તી વોનાયા બોજ ઇચ્છા આતી, બાકી નાંય વોનાય હોક્યા.” ");
INSERT INTO gbl_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","યોક દિહી ઈસુ ચ્યા શિષ્યહાન હિકાડી રિઅલો આતો તોવે યોક મૂસા નિયમ હિકાડનારો ગુરુ, ઈસુવા પારાખ કોઅરાહાટી યેઇન પુછ્યાં, “ઓ ગુરુ, કાય કામ કું કા પોરમેહેર માન અનંતજીવન દેય?” ");
INSERT INTO gbl_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ઈસુવે ચ્યાલ આખ્યાં, “મૂસા નિયમશાસ્ત્રામાય લોખલાં હેય, તું કેહેકેન હોમાજતોહો?” ");
INSERT INTO gbl_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ચ્યાય જોવાબ દેનો, “તું પ્રભુ આપહે પોરમેહેરાલ આપહે બોદા મોના કોઇન, આપહે બોદા બુદયે કોઇન, આપહે બોદા જીવા કોઇન, એને આપહે આખી ગોતીયે કોઇન પ્રેમ રાખના; એને પોતાવોય જેહે પ્રેમ કોઅતાહા તેહેકોય પોડુસીવોય પ્રેમ કોઅના.” ");
INSERT INTO gbl_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ઈસુવે ચ્યાલ આખ્યાં, “તો જોવાબ હાચ્ચો હેય, એહકોયજ કોઓ તોવે તુલ ઈ અનંતજીવન મિળી.” ");
INSERT INTO gbl_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","બાકી તો ચ્યા કામાલ હાચ્ચો ઠોરવાહાટી ઈસુવાલ પુછ્યાં, “તો મા પોડુસી કું હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ઈસુવે યોક કહાની આખી, યોક માટડો યેરૂસાલેમ શેહેરામાઅને યેરીખો શેહેરામાય જાંઆહાટી ચાલ પોડયો, ઓલહામાય તો બાંડાહા આથામાય સાપડાઈ ગીયો, ચ્યા લોકહાય ચ્યા ફાડકે એને બોદી વસ્તુ ચ્યાપાઅને લુટી લેદા, એને ચ્યાલ ઠોક્યો એને મોઅઇ જાય ઓહડો કોઇન છોડી દેનો, તોવે ચ્યાલ રા દેયન જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ઓલહામાય એહેકોય જાયા યોક યહૂદી યાજક ચ્યે વાટેરે જાતો આતો, બાકી તો એઅઇન ચ્યા મોદાત કોઅયા વોગાર જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","એહેંજ કોઇન યોક લેવી કુળા માઅહું બી તાં યેનો, બાકી તો એઅઇન ચ્યા મોદાત કોઅયા વોગાર જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","બાકી યોક સમરૂન ભાગા માઅહું વાટે જાતા એલો આતો ચ્યા માઅહા પાય યેય પોઅચ્યો, એને ચ્યાલ એઇન ચ્યાલ દયા યેની. ");
INSERT INTO gbl_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ચ્યે ચ્યા પાહાય યેયન ચ્યા જોખમા ઉપે તેલ એને દારાખા રોહો રેડીન પાટા બાંદ્યા, એને પોતા ફૂરક્યાવોય બોહાડીન ચ્યાલ યોક મુસાફરી રોનારા જાગે લેય ગીયો એને તાં ચ્યા સેવાચાકરી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","બીજે દિહે ચ્યે ચ્યા જાગા માલિકાલ બેન દીનાર (દીનાર એટલે બેન દિહા કામાણી ઓઅહે) કાડીન દેના, એને આખ્યાં, “તું ચ્યા સેવાચાકરી કોઅજે, એને તુલ જીં કાય વોદારે ખોરચો લાગી, તીં આંય પાછો વોળી યીહીં, તોવે તુલ દેય દિહી.” ");
INSERT INTO gbl_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","આમી તુલ કાય લાગહે, ચ્યા બાંડાહા આથામાય પોડલા માઅહા પોડુસી યા તીન્યાહા માઅને કું બોન્યો? ");
INSERT INTO gbl_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ચ્યે જાવાબ દેનો “ચ્યાવોય જ્યેં દયા કોઅયી તો બાહા” ઈસુવે ચ્યાલ આખ્યાં, “તોવે જો, તું હોગો યેજપરમાણે કોઅજે.” ");
INSERT INTO gbl_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","પાછે ઈસુ એને ચ્યા શિષ્ય મુસાફરી કોઇન યોકા ગાવામાય યેય પોઅચ્યા. એને તાં માર્થા નાંવી યોક થેઅયે ચ્યાલ ગાંવારો યાં આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ચ્યેલ મરિયમ નાંવી બોઅહી આતી, તી પ્રભુવા પાગહાપાય બોહીન ચ્યા વાતો વોનાયા કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","બાકી માર્થા ખાઅના રાંદતા-રાંદતા ગાબરાય ગીયી, એને તી ઈસુવાપાય યેયન આખા લાગી, “ઓ પ્રભુ, મા બોઅયેહે બોદા કામ મા યોખલી ઉપેજ છોડ્યહા? યાહાટી ચ્યેલ આખ કા મા મોદાત કોએ.” ");
INSERT INTO gbl_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","બાકી પ્રભુ ઈસુય જાવાબ દેનો, કા “માર્થા, ઓ માર્થા; તું બોજ વાતહે ફિકાર કોઅતીહી, એને ગાબરાતીહી. ");
INSERT INTO gbl_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","બાકી યોકુજ વસ્તુ જરુર હેય મરિયમે હારો વાટો નિવડી લેદહો, એને તો ચ્યે પાયને નાંય લેવાય.” ");
INSERT INTO gbl_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","પાછે ઈસુ યોકે જાગે પ્રાર્થના કોઇ રિઅલો આતો, જોવે પ્રાર્થના કોઇ પાડી, તોવે ચ્યા શિષ્યહા માઅને યોકે ચ્યાલ આખ્યાં, “પ્રભુ આમહાન પ્રાર્થના કોઅરા હિકાડ, જેહે કોઇન યોહાન બાપતિસ્મા દેનારાય ચ્યા શિષ્યહાન હિકાડયાં.” ");
INSERT INTO gbl_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “જોવે તુમા પ્રાર્થના કોઅહા તોવે એહેકોય આખા: ‘ઓ આબા’ તો આગના માનલી જાય, તો રાજ્ય યેય. ");
INSERT INTO gbl_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","આમહાન બોદા દિહા ખાઅના દે, જીં ચ્યા દિહા હાટી જોજહે. ");
INSERT INTO gbl_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","‘એને આમહાન આમહે પાપહા માફી દે’ કાહાકા આમા આમહે દુશ્માનાહાન માફી દેજહે ‘આમહાન પરીક્ષામાય મા ટાકહે’ બાકી સૈતાનાથી બોચાડ.” ");
INSERT INTO gbl_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","એને ઈસુવે ચ્યાહાન આખ્યાં, તુમહામાય કોઅહો ઓહડો દોસ્તાર ઓરી, તો ચ્યાપાય આરદી રાતે યેઇન આખે, ઓ દોસ્તાર માન તીન બાખે દે. ");
INSERT INTO gbl_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","કાહાકા યોક મુસાફીર દોસ્તાર મા ઈહીં યેનહો, એને ચ્યાલ ખાવાડુ ઓહડા માયેપાંય કાય નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","એને તો ગોઅમેરે જાવાબ દેહે, માન આબદા મા દેહે, આમી બાઅણા બંદ હેય, એને મા પોહેં માપાય હુતલે હેતેં, યાહાટી આંય તુલ ઉઠીન નાંય દી હોકુ. ");
INSERT INTO gbl_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","બાકી આંય તુમહાન હાચ્ચાં આખતાહાવ, જો તો ચ્યા દોસ્તાર ઓઇન બી ચ્યાલ ઉઠીન નાંય દેય, બાકી ચ્યા લાજ છોડીન માગના લેદે ચ્યાલ જોલા જરુરી હેય તોલા ઉઠીન દી. ");
INSERT INTO gbl_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","એને આંય તુમહાન આખતાહાવ, તુમહાન જીં જોજે તી પોરમેહેરાપાય માગા એને તો તુમહાન દી હોદાહા તે તુમહાન જોડી ઠોકાહા, તે તુમહેહાટી ઉગાડવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","કાહાકા જો કાદો માગહે, ચ્યાલ મિળહે; એને જો કાદો હોદહે, ચ્યાલ જોડહે; એને જો કાદો ઠોકહે, ચ્યાહાટી ઉગાડી દેવામાય યેહે. ");
INSERT INTO gbl_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","જો પોહો બાખે માગે તે તુમહામાયને કાદો આબહો પોતે પોહાલ દોગડો નાંય દેય. યેજપરમાણે, જો તુમહે પોહેં માછલા માગે તે ચ્યાલ જેરીવાળા હાપડા નાંય દેય. ");
INSERT INTO gbl_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","કા હાકૂ માગે તોવે ચ્યાલ વીછડા નાંય દેય. ");
INSERT INTO gbl_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","એને જોવે તુમા ખારાબ હેય, તેરુંબી તુમહે પોહાહાન તુમા હાર્યો વસ્તુ દાં માગતેહે, તે તુમહે હોરગામાઅને આબહો ચ્યાપાય જ્યેં માગતેહે ચ્યાહાન પવિત્ર આત્મા દેઅના જાંઅહે. ");
INSERT INTO gbl_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","પાછે ઈસુવે યોક મુકા બુતાલ કાડયો, જોવે બુત નિંગી ગીયો, તોવે મૂકો બોલતો લાગ્યો, એને લોકહાન બોજ નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","બાકી કોલહાયોક લોકહાય આખ્યાં કા, “તો સૈતાન જો બુતાહા મુખ્ય હેય ચ્યા મોદાત લેઈને બુતાહાન તાંગાડેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","એને ચ્યા ઈસુલ ફોસવા હાટી ઈ માગણી કોઇ રીયલા આતા, કા આમહાન હોરગા એહેરે મોઠે ચિન્હ દેખાડ. ");
INSERT INTO gbl_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","બાકી ચ્ચાય ચ્યાહા વિચાર જાંઆઈ ગીયો, એને ઈસુવે ચ્યાહાન આખ્યાં, “જ્યા-જ્યા દેશામાય ફુટ પોડહે, તી રાજ્ય નાંય ટોકે; એને જ્યા ગાઆમાય ફુટ પોડહે, તી ગુઉ નાંય ટોકી હોકે. ");
INSERT INTO gbl_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","એને જોવે સૈતાન જો બુતાહા મુખ્ય પોતાનાજ બુતાહા આરે વિરુદી ઓઅઇ જાય, તે ચ્યા રાજ્ય કેહેકેન ટોકી હોકી? કાહાકા તુમા આખતાહા કા સૈતાના મોદાતે કોય આંય બુત કાડતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","જો, આંય સૈતાન જો બુતાહા મુખ્ય હેય ચ્યા મોદાતે કોઇ બુતહાલ કાડહુ, તોવે તુમહે પીડી કા મોદાતકોય કાડતેહે? ચ્યાહાટી તો તુમહે ન્યાય કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","બાકી જોવે આંય પોરમેહેરા સામર્થ્યા કોઇન બુત કાડહુ, તોવે પોરમેહેરા રાજ્ય તુમહે પાહી યી ચુકલા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","તાકાતવાળા માઅહું આથીયાર લેઈને ગોઆ રાખવાળી કોએ, તોવે ચ્યા મિલકાત બોચી રોય. ");
INSERT INTO gbl_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","બાકી જોવે ચ્યા કોઅતો મોઠી તાકાતવાળા માઅહું લોડીન જીતે, તોવે ચ્યા આથીયાર જ્યાવોય તો બોરહો થોવા આતો, તી બોદા તો લેય લેહે, એને ચ્યા મિલકાત લુટીન વાટી દેહે. ");
INSERT INTO gbl_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","જીં માઅહું મા આરે નાંય હેય, તો મા વિરુદમાય હેય, એને જીં માઅહું મા આરે ગોળો નાંય કોએ તો વેરેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“જોવે બુત માઅહા માઅને નિંગી જાહે, તોવે ઉખાલા જાગામાય આરામ હોદતો ફિરહે, બાકી મીળે નાંય તોવે પોતાલ આખહે, આંય જ્યા માઅહા માઅને યેનેલ તાંજ ફિરી જાહીં. ");
INSERT INTO gbl_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","એને ફિરી યેઇન ચ્યાલ ચ્યા માઅહા જીવન ગોઆ હારકા દેખાયેહે જીં ચોખ્ખાં સોબાડલા બાકી રીકામા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","તોવે તીં જાયને ચ્યે કોઅતા વોદારે હાંત બુતાહાલ લી યેહે, એને ચ્યે ચ્યા માઅહામાય ઉરાય જાતહેં એને તાંજ રોતેહેં, એને ચ્યા માઅહા પાછલી દશા પેલ્લા કોઅતાબી ખારાબ બોની જાહે.” ");
INSERT INTO gbl_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","જોવે ઈસુ યો વાતો આખી રિઅલો આતો, તોવે ગીરદીમાઅને યોક થેઅયે મોઠેરે બોંબલીન આખ્યાં, ધન્ય હેય તી થેએ, જ્યેય તુલ જન્મો દેનહો એને તુલ દુદ પાજહયા. ");
INSERT INTO gbl_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ઈસુવે આખ્યાં, “હાં, બાકી ધન્ય હેય જ્યેં પોરમેહેરા વચન વોનાયને પાળતેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","જોવે લોકહા મોઠી ગીરદી બેગી ઓઅતી જાતી આતી તોવે તો ચ્યાહાન આખતો લાગ્યો, “યે પીડી લોક ખારાબ હેય, ચ્યે ચિન્હ હોદતેહેં, બાકી યોના ભવિષ્યવક્તા ચિન્હ છોડીન બીજી કાય ચિન્હ નાંય દેવાય. ");
INSERT INTO gbl_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","જેહેકેન યોના નીનવે શેહેરા લોકહાહાટી ચિન્હ ઠોર્યો, તેહેકેન યે પેડયે હાટી માઅહા પોહોબી ચિન્હ ઠોરી. ");
INSERT INTO gbl_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","દક્ષીણ રાણી ન્યાયા દિહી યી પીડી લોકહાઆરે ઉઠીન, ચ્યાલ દોષી ઠોરવી, કાહાકા તી સુલેમાના જ્ઞાન વોનાયા હાટી બોજ દુઉને યેનેલ; એને એઆ, ઈહીં તો હેય, જો સુલેમાના કોઅતો મોઠો હેય, બાકી તુમા પાપ છોડાહાટી મોનાઈ કોઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","નીનવે શેહેરા લોક ન્યાયા દિહી યા પીડી લોકહાઆરે ચ્યા દોષી ઠોરવી, કાહાકા ચ્યાહાય યોના આખલ્યા વોનાયને પાપ છોડયા; એને એઆ, ઈહીં તો હેય, જો યોના કોઅતો મોઠો હેય, બાકી તુમા પાપ છોડાહાટી મોનાઈ કોઅતેહે.” ");
INSERT INTO gbl_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","કાદો દિવો લાવીન ચ્યાલ ટોપલ્યે તોળે કા ચોપા કોઇન નાંય ડાકેત બાકી ઉચે દીવત્યાવો થોવતેહે કાહાકા તોવે ચ્યા ઉજવાડો ગોઆમાય યેનારાહાલ મીળે. ");
INSERT INTO gbl_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ડોળો શરીરાહાટી દિવા હારકો હેય: યાહાટી તો ડોળા નોજાર ચોખ્ખી રોય, તોવે તો બોદા શરીર ઉજવાડા ઓરી, બાકી જોવે તો ખારાબ હેય, તે તો બોદા શરીર આંદારાવાળા રોય. ");
INSERT INTO gbl_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","યાહાટી હાચવીન રા, તુમહેમાય જીં ઉજાળાં હેય તી આંદારાં નાંય બોને. ");
INSERT INTO gbl_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","યાહાટી તો બોદા શરીર ઉજાળાં ઓરી, એને ચ્યામાય કોઅહોજ ભાગ આંદારાં નાંય રોય, તોવે બોદેજ એહેકોય ઉજાળાં રોય, જોવે દિવો પોતાના ઉજવાડા કોય તુલ ઉજવાડા દેહે. ");
INSERT INTO gbl_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","જોવે ઈસુ વાતો આખી રિઅલો આતો તોવે યોક પોરૂષીય ચ્યાલ વિનાંતી કોઅયી કા, મા ગોઓ ખાં યે, એને ઈસુ ચ્યા ગોઓ જાયન ખાં બોઠો. ");
INSERT INTO gbl_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","પોરૂષી લોક ઈસુલ એઇન નોવાય લાગી કા ખાં પેલ્લા ચ્યાય આથ-પાગ નાંય દોવ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","બાકી પ્રભુવે ચ્યાહાન આખ્યાં, ઓ પોરૂષીહાય તુમા થાળી એને વાટકે ઉપે ચોળતાહા, બાકી માજે લોબ એને લુચ્ચાઈ બોઅલાજ હેય. ");
INSERT INTO gbl_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ઓ મુર્ખાહાય, જ્યેય ઉપેરે ભાગ બોનાવ્યો, કાય ચ્યેજ માજેરે ભાગ બી નાંય બોનાવ્યો? ");
INSERT INTO gbl_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","બાકી હાં, જીં માજે હેય તી ગોરીબાહાન દે, એને બોદા તુમહેહાટી ચોખ્ખાં રોય. ");
INSERT INTO gbl_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","ઓ પોરૂષીહાય તુમહાવોય હાય, તુમા ફુદીના, એને સોફ, એને જીરા દોસમો ભાગ દેતહા, બાકી ન્યાયાલ એને પોરમેહેરા પ્રેમ ટાળી દેતહા, ઓરા જોજે કા તુમા યાલ બી કોઅતા રોતા એને યાલ બી નાંય છોડતા. ");
INSERT INTO gbl_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","ઓ પોરૂષીહાય તુમહાવોય હાય, તુમહાન સોબાયે ઠિકાણે પેલ્લો જાગો ગોમહે એને આટામાય સલામ કોઆડના. ");
INSERT INTO gbl_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","હાય તુમહેવોય, કાહાકા તુમા ચ્યા ડાકાલ્યે કબારે હારકા હેતા, જ્યાહા ઉપને માઅહે ચાલીન જાતહેં, બાકી ચ્યાહાન ખોબારૂજ નાંય પોડે. ");
INSERT INTO gbl_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","તોવે યોકા મૂસા નિયમ હિકાડનારા ગુરુય જોવાબ દેનો, ઓ ગુરુ, યો વાતો કોઇન તું આમે નિંદા કોઇ રિઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","બાકી ઈસુય ચ્યાલ આખ્યાં, ઓ મૂસા નિયમ હિકાડનારા ગુરુ તુમહાવોય હાય, તુમા ઓહડો બાઆય વોજો જ્યાલ ઉસાલના કોઠાણ હેય, માઅહા ઉપે થોવતાહા બાકી તુમા ચ્યા વોજાલ યોક આંગળી બી નાંય લાવેત. ");
INSERT INTO gbl_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","હાય તુમહાવોય, તુમા ભવિષ્યવક્તાહા કોબાર્યો હુદરાવતાહા, જ્યાહાલ તુમહે આગલ્યા ડાયહાય માઆઇ ટાક્યેલ. ");
INSERT INTO gbl_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","તુમા યે વાતહે સાબિતી હેતા, એને તુમહે આગલ્યા ડાયહા કામહાથી રાજી હેતા, કાહાકા ચ્યાહાય તે ચ્યાહાન માઆઇ ટાક્યા એને તુમા ચ્યાહા કોબાર બોનાડતાહા. ");
INSERT INTO gbl_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","યાહાટી પોરમેહેરે આખ્યાં, આંય ચ્યાહાપાય ભવિષ્યવક્તા એને પ્રેષિત દોવાડીહી, એને ચ્યાહામાઅને કોલહાખાનહાન માઆઇ ટાકી એને કોલહાખાનહાન સતાવણી કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","યાહાટી આકાશ દોરતી બોનાવીહી ચ્યાપાઅને જોલા ભવિષ્યવક્તાહાન માઆઇ ટાકહયા, ચ્યાહા બોદો ઇસાબ, યે પીડી લોકહાપાઅને લેદલો જાય. ");
INSERT INTO gbl_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","હાબેલાલ માઆઇ ટાકના પાઅને લેયને જખરિયા માઆઇ ટાકના લોગુ જો વેદ્યે એને દેવાળા વોચમાય માઆઇ ટાક્યેલ, આંય તુમહાન હાચ્ચાં આખતાહાવ, ચ્યાહા ઇસાબ યે પીડી લોકહાપાઅને લેદલો જાય. ");
INSERT INTO gbl_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ઓ મૂસા નિયમ હિકાડનારા ગુરુ તુમહાવોય હાય! તુમહાય જ્ઞાન તે મેળવી લેદહા, બાકી તુમા પોતે ચ્યામાય નાંય જાત, એને ચ્યામાય જાનારાહાલ બી નાંય જાં દેત. ");
INSERT INTO gbl_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","જોવે ઈસુ તાઅને ચાલ પોડયો તોવે પોરૂષી લોક એને મૂસા નિયમ હિકાડનારા ગુરુ ચ્યા પાહલા પોડ્યા એને ખિજવાડા લાગ્યા, કા ચ્યા ઈસુલ બોજ વાતહે સાવાલ કોઅરા ગીઅલા. ");
INSERT INTO gbl_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","એને ચ્યાહાટી ટુંગી રિયા, કા ચ્યા યોકદી વાતમાય દોઈ પાડે. ");
INSERT INTO gbl_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","જોવે હજારો લોક ટોળો વોળીન ઈસુવાપાય યેને, ઓલે બોદે કા યોકબિજાલ બીચડી દેત, તોવે ઈસુ પેલ્લા ચ્યા શિષ્યહાન આખતો લાગ્યો, “પોરૂષી લોકહા ડોંગ્યા હારકા ખમીરથી હાચવીન રોજા. ");
INSERT INTO gbl_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","કાહાકા કોઅહીજ વસ્તુ ઓહડી નાંય હેય કા તી ડાકલી રોય એને યોકતી વસ્તુ ઓહડી નાંય હેય કા તી દુબાડી હોકાય બાકી બોદાંજ ખુલ્લાં પોડી જાય. ");
INSERT INTO gbl_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","તો આંદારામાય તુમહાય જીં આખ્યાં તી દિહા ઉજવાડામાય વોનાયી, એને તુમહાય બાઆં ડાકીન કાનામાય દુંદરીન આખ્યાં, તી બોદે જાગે બોંબલીન આખરી.” ");
INSERT INTO gbl_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","બાકી આંય તુમહાન જ્યા મા હાંગાત્યા હેતા આખતાહાવ, કા જ્યેં શરીરાલ માઆઇ ટાકી હોકતેહેં બાકી ચ્યે આત્માલ નાશ નાંય કોઇ હોકે, ચ્યાહાન મા બીયહા. ");
INSERT INTO gbl_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","આંય તુમહાન ચેતાવણી દેયન આખતાહાવ કા કાદાલ બીયના નાંય, બાકી જો માઆઇ ટાકી હોકે એને ચ્યા પાછે નરકા કોળીમાય ટાકી હોકહે, ચ્યા પોરમેહેરાલ બીયજા, આંય હાચ્ચાં આખતાહાવ ચ્યા પોરમેહેરાલ બીયજા. ");
INSERT INTO gbl_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","કાય બેન પોયહામાય પાચ હાકરીયેં ચિડેં વેચાતેહે કા નાંય? તેરુંબી ચ્યામાઅને યોકાલબી પોરમેહેર વિહરાય નાંય જાય. ");
INSERT INTO gbl_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","તુમહે ટોલપીવોઅને કીહીં કોલહા હેય તી બી તો જાંઅહે. ચ્યાહાટી તુમા બીયહા મા, તુમા બોજ ચિડહા કોઅતાબી કિમત્યા હેતા. ");
INSERT INTO gbl_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","આંય તુમહાન આખતાહાવ, “જીં માઅહું લોકહા હોમ્મે માની લેહે તો મા શિષ્ય હેય, ચ્યાલ આંય, માઅહા પોહોબી પોરમેહેરા હોરગા દૂતહા હોમ્મે માની લિહીં. ");
INSERT INTO gbl_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","બાકી જીં માઅહું માન માઅહા હોમ્મે નાંય માને, ચ્યાલ આંયબી મા પોરમેહેરા હોરગા દૂતહા હોમ્મે આખી દિહીં કા ઓ મા શિષ્ય નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","જીં કાદાં માઅહા પોહા વિરુદમાય વાત આખી, ચ્યા ઓ પાપ માફ કોઅવામાય યી, બાકી જીં પવિત્ર આત્મા વિરુદમાય નિંદા કોએ, ચ્યા પાપ નાંય માફ કોઅવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","જોવે માઅહે તુમહાન ચ્યા સોબાયે ઠિકાણે એને આગેવાન એને ઓદિકાર્યાપાય દોયન લેય જાય, તોવે કાય જાવાબ દેઅના, કા કાય આખના, ચ્યા ચિંતા નાંય કોઅના. ");
INSERT INTO gbl_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","“કાહાકા કાય આખના, તી ચ્યેજ સમયે પવિત્ર આત્મા તુમહાન હિકાડી, કા કાય આખના હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","પાછે ટોળામાઅને યોક જાંએ ઈસુલ આખ્યાં, “ગુરુજી, મા બાહાલ તું આખી દે, કા આબહા મિલકાત માન વાટી દેય.” ");
INSERT INTO gbl_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","બાકી ઈસુય ચ્યાલ આખ્યાં, “ઓ બાહા, માન કુંયે તુમહે ન્યાય કોઅરા કા મિલકાત વાટાં નિવડયોહો?” ");
INSERT INTO gbl_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","પાછે ઈસુય ચ્યાહાન આખ્યાં, “હાચવીન રા, એને બોદા લોબથી બોચી રોજા, કાહાકા જીવન કિમત્યા હેય તુમહે વોદારી મિલકાતે લેદે નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","પાછે ઈસુવે ચ્યાહાન યોક દાખલો આખ્યો કા, “યોકતા માલદાર માઅહા જમીનમાય બોજ હારાં પાક્યા. ");
INSERT INTO gbl_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","તોવે તો મોનામાય વિચાર કોઅતો લાગ્યો, માન નાંય ખોબાર કા આંય કાય કું? કાહાકા મા બોદો પાક થોવા હાટી મોઠો જાગો નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","તોવે ચ્યાય એહેકોય આખ્યાં, માન ખોબાર હેય કા માન કાય કોઅરા જોજે: આંય પોતાના કોઠીલ તોડીન મોઠી બોનાડીહી, એને તાં પોતાનો બોદો પાક એને માલમિલકાત થોવહી, ");
INSERT INTO gbl_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","તોવે પોતાલ આખીહી કા ઓ મા જીવ, તુયેપાય બોજ વોરહા લોગુ બોજ મિલકાત થોવલી હેય, યાહાટી તું આરામ કોઓ, ખાય-પીન મોજ્યા કોઓ. ");
INSERT INTO gbl_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","બાકી પોરમેહેરે ચ્યાલ આખ્યાં? ‘ઓ મૂર્ખા, આજે રાતી તું મોઅઇ જાહે, તોવે જીં તુયે પોતાનાહાટી યોખઠા કોઅલા હેય ચ્યાલ કું લી?’ ");
INSERT INTO gbl_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","એહકોયજ ચ્યા માઅહા આરે ઓઈ જીં બોદા કાય પોતાહાટી યોખઠા કોઅહે, બાકી પોરમેહેરા સેવા કોઅરાહાટી પોતે મિલકાતે એને શક્તિ ઉપયોગ નાંય કોએ.” ");
INSERT INTO gbl_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","પાછે ઈસુય ચ્યા શિષ્યહાન આખ્યાં, ચ્યાહાટી આમા તુમહાન આખતાહાવ, કા શારીરિક જીવના ચિંતા મા કોઅહા આમા કાય ખાઉં એને કાય પિયહું; પાછા આમા શરીરામાય કાય પોવહું. ");
INSERT INTO gbl_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","કાય જીવન ખાઅનાથી, એને શરીર ફાડકાહા કોઅતા વોદારે કિમત્યા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","નેંડાડાહાલ એઅયા, ચ્યે પોએત નાંય, એને વાડેત નાંય, એને નાયતે કોઠયેમાય થોવેત, તેરુંબી પોરમેહેર ચ્યાહાન ખાવાડેહે, તુમહે કિંમાત ચિડહા કોઅતી વોદારે હેય. ");
INSERT INTO gbl_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","તુમહામાયને ઓહડો કું હેય, જો પોતે જીવના બારામાય ચિંતા કોઅવાથી પોતે જીવન લાંબાવી હોકહે? ");
INSERT INTO gbl_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","યાહાટી જો તુમા બોદહાથી વાહના કામબી નાંય કોઇ હોકે, તો જીવનામાય બિજ્યે વાતહે બારામાય કાહા ચિંતા કોઅતાહા? ");
INSERT INTO gbl_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","“એને ફાડકાહાટી કાહા ચિંતા કોઅતાહા? જાડયેમાયને ફૂલજાડવા તુમા દિયાન કોઆ, ચ્યે કેહેકેન વોદતેહે; ચ્યે કાય મેહનાત નાંય કોએત, એને ચ્યે ફાડકે બી નાંય બોનાડે. તેરુંબી આંય તુમહાન આખહુ કા, સુલેમાન રાજાબી ચ્યા ઓલીબોદી સુંદરતા આતી તેરુંબી ચ્યાય ચ્યાહા હારકે ફાડકે નાંય પોવલે. ");
INSERT INTO gbl_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ચ્યાહાટી પોરમેહેર રાનામાઅને ગાહીયાલ, જીં આજે હેય એને હાકાળ વાડીન આગડામાય ટાકી દી, ઓહડાલ તો ફાડકે પોવાડેહે, તે ઓ વોછો બોરહો થોવનારાહાય, તુમહાન તો યા કોઅતા વોદારે દેખભાલ કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","તે તુમા યા બારામાય ચિંતા મા કોઅહા, કા કાય ખાહું એને કાય પિયહું, એને શંકા મા કોઅહા. ");
INSERT INTO gbl_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","કાહાકા દુનિયામાઅન્યા ગેર યહૂદી લોક યે બોદ્યો વાતો હોદતાહા, બાકી તુમહે હોરગામાઅને આબહો જાંઅહે, કા તુમહાન યે વસ્તુહુ ગોરાજ હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","બાકી હોરગ્યા રાજ્યામાઅને વાના હોદ કોઆ, તોવે તુમહાન દોરત્યેવોયને બોદા વાના મિળી જાય. ");
INSERT INTO gbl_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","“તોવે ઈસુવે આખ્યાં, તુમા ગેટહા યોક હાના ટોળા હારકે હેય, યાહાટી કોઅયેહેબી વાતે તુમા બીયહા મા, કાહાકા પોરમેહેર આબાલ ઈ ગોમ્યા, કા તુમહાન રાજ્ય દી. ");
INSERT INTO gbl_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","તુમહે મિલકાત વેચી દિયા, એને ગોરીબાહાન દાન દિયા; એને મોજરાય નાંય જાય ઓહડી ઠેલી રાખા, બાકી આપહેહાટી હોરગામાય મિલકાત બેગા કોઅયા, તાં ઘોટી નાંય જાય, જ્યા પાહાય બાંડ નાંય યેય, એને ઉદાડા નાંય ખાય. ");
INSERT INTO gbl_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","કાહાકા જાં તો મિલકાત હેય, તો મોન સાદા તાંજ લાગલા રોય.” ");
INSERT INTO gbl_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","તુમા સાદા કામ કોઅરાહાટી તિયારી રા એને મા યેયનાહાટી પુરી રાત દિવા હોલગાડી રાખા. ");
INSERT INTO gbl_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","એને તુમા ચ્યા લોકહા હારકે બોના, જ્યા પોતે માલિકા વાટ એઅઇ રિયહો, કા તો વોરાડયાહા ઇહિને ફિરી યેયન દરવાજો ખોકડાવી તે તારાતુજ ચ્યાહાટી ખોલી દેય. ");
INSERT INTO gbl_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ધન્ય હેય ચ્યા ચાકાર, જ્યાહાન માલિક પાછો યેયનાહાટી વાટ એઅતા દેખે, આંય તુમહાન હાચ્ચાં આખતાહાવ કા ચ્યાહા માલિક યોકા ચાકારા હારકે ફાડકે પોવીન ચ્યાહાન ખાઅના ખાં બોહતાડી, એને ચ્યાહાપાય યેયન ચ્યાહા સેવા કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","જો તો આરદ્યે રાતી, કા ઉજાળાં ઓઅતા યેયન ચ્યાહાન વાટ જોવતા એએ, તોવે ચ્યા ચાકાર ધન્ય હેય. ");
INSERT INTO gbl_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","બાકી ઈ જાંઆઈ લીયા, કા જો ગાઆ માલિકાલ એહેકોય માલુમ રોતા, કા બાંડ કોઅહે વેળાઈયે યી, તે તો જાગતો રોતો; એને પોતે ગોઆમાય ચોરી નાંય ઓઅરા દેતો. ");
INSERT INTO gbl_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","તુમાબી તિયાર રા, કાહાકા જ્યેં વેળાઈયે તુમા જાંએબી નાંય, ચ્યે વેળાયે માઅહા પોહો યેઅઈ જાય. ");
INSERT INTO gbl_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","તોવે પિત્તરે આખ્યાં, “ઓ પ્રભુ, કાય ઓ દાખલો તું આમહાલુજ આખતોહો, કા બોદહાન?” ");
INSERT INTO gbl_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","એને પ્રભુવે આખ્યાં, “ઈમાનદાર એને બુદ્ધિમાન કારબારી કું હેય? જ્યાલ માલિકાય પોતાના નોકાર-ચાકારાવોય કારબારી બોનાડયોહો, કા તો સોમયાવોય ચ્યાહાન ખાઅના વસ્તુ દેય. ");
INSERT INTO gbl_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ધન્ય હેય, તો ચાકાર, જ્યાલ માલિક યેઇન એહેંજ કોઅતો એએય. ");
INSERT INTO gbl_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા; તો ચ્યાલ ચ્યા પોતાની બોદી મિલકાત્યે ઓદિકારી બોનાડી દી. ");
INSERT INTO gbl_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","બાકી જોવે ચાકાર એહેકેન વિચાર કોઆ લાગે કા, મા માલિકા યેયના આજુ વાઆ હેય, એને એહેકોય આખીન બિજા ચાકાર એને ચાકારીહીન ઠોકાં લાગે, એને ખાતો પિતો લાગે, સાકાટ બોની જાય. ");
INSERT INTO gbl_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","તોવે તો ચ્યા કારબારી માલિક પાછો યી, જોવે તો ચ્યા વાટ નાંય જોવે, એને ઓહડા સોમાયા જ્યા બારામાય તો જાંઆય બી નાંય. તોવે તો ચ્યાલ બોજ કોઠાણ સાજા દેયન એને ચ્યા ભાગ ડોંગ્યા લોકહાઆરે ઠોરવી. ");
INSERT INTO gbl_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","બાકી જો ચાકાર ચ્યા દોણ્યા ઇચ્છા જાંઅતો આતો, એને તિયારી નાંય રિયો, એને ચ્યા ઇચ્છા પરમાણે નાંય ચાલ્યો, ચ્યાલ બોજ માર પોડી. ");
INSERT INTO gbl_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","બાકી જો ચાકાર નાંય જાંઆય, એને માર જોડે ઓહડો કામ કોઅહે, ચ્યાલ વોછો માર પોડી, યાહાટી જ્યાલ બોજ દેનલા હેય, ચ્યાપાઅને બોજ માગવામાય યી, એને જ્યાલ બોજ હોપ્યહા, ચ્યાપાઅને બોજ લેવામાય યી.” ");
INSERT INTO gbl_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","આંય દોરત્યેવોય આગ લાવાં યેનોહો, એને આમી હોલગી જાતા તી માન કોલાં હારાં! ");
INSERT INTO gbl_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","માન માહારુજ યોક ભયંકર આબદા બોગાવના હેય, જાવ લોગુ તી આબદા નાંય બોગવું, તાંઉલોગુ મા જીવ કોલો નિરાશ હેય! ");
INSERT INTO gbl_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","“ઈ મા હુમાજતા કા આંય દોરત્યેવોય લોકહાવોચમાય શાંતી દાં યેનહો, આંય દોરત્યેવોય લોકહાવોચમાય શાંતી નાંય બાકી આલાગ કોઆડાં યેનહો. ");
INSERT INTO gbl_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","કાહાકા આમી પાછે યોકા ગોઆમાય પાચ જાંઆ રોતા ઓરી, ચ્યાહામાય ફુટ પોડી, તીન લોક જ્યા માયેવોય બોરહો નાંય કોએ, ચ્યા બેન જાંઅહા વિરુદ કોઅરી જ્યા માયેવોય બોરહો કોઅતાહા, એને એહકોયજ બેન જાંઆ તીનહયા આરે કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","આબહો પોહાઆરે, એને પોહો આબહા આરે વિરુદ કોઅરી, એને આયહો પોહયે આરે, એને પોહી આયહે વિરુદ કોઅરી, હાહુ વોવલ્યેહે આરે એને વોવલીહી હાહુ આરે વિરુદ કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","એને ઈસુવે લોકહાન આખ્યાં, “જોવે દિહી બુડતા એછરે વાદળાં ચોડતા દેખાય, તોવે તુમા તારાત આખતાહા કા, પાઆઈ યી, એને હાચ્ચાંજ પાઆઈ યેહે; ");
INSERT INTO gbl_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","એને બોખરો યેતો દેખીન, તુમા આખતાહા, કા તીડકા લાગી ઉઠી, એને એહેકોય હાચ્ચાંજ બોનહે. ");
INSERT INTO gbl_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ઓ ડોંગ્યાહાય, આકાશ એને દોરત્યે બારામાય પારાખતા તુમહાન આવડેહે, બાકી આમી યા સમાયામાય પોરમેહેર કાય કોઅરા માગહે ચ્યા બારામાય તુમા નાંય હોમજે? ");
INSERT INTO gbl_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","તુમહાય પોતે નોક્કી કોઅરા જોજે કા તુમહેહાટી કાય કોઅના ઠીક હેય? ");
INSERT INTO gbl_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","કાહાકા જોવે તું ફીરાદીવાળા આરે કોચર્યે વાટે જાહે, તાંઉ ચ્યાપાઅને છુટા હાટી કોશિશ કોઓ નાંય તે તો તુલ ન્યાય કોઅનારા પાય દોઇન લેય જાય, ન્યાય કોઅનારો તુલ સીપાડાલ હોઅપી દી, એને સીપાડા તુલ જેલેમાય કોંડી દી. ");
INSERT INTO gbl_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","આંય તુલ હાચ્ચાં આખતાહાવ કા જાંઉ લોગુ બોદા પોયહા બોઅઇ નાંય દેય, તાંવ લોગુ તું જેલેમાઅને છુટી નાંય હોકહે.” ");
INSERT INTO gbl_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ચ્ચે સોમાયામાય કોલાક લોક યેના, એને ઈસુવાલ ચ્ચા ગાલીલ ભાગા માઅહા બારામાય આખતા લાગ્યા, જ્યા લોકહાન પિલાત રાજાય દેવાળામાય બલિદાન ચોડાવના સમયે માઆઇ ટાક્યા. ");
INSERT INTO gbl_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ઈ વોનાયને ઈસુય ચ્યાહાન આખ્યાં, “કાય તુમા હોમાજતેહે કા ઈ ગાલીલ ભાગા માઅહું બિજા ગાલીલ વિસ્તારા માઅહા કોઅતા બોજ પાપી આતા કા ચ્યાહાવોય ઓહડી આબદા પોડી?” ");
INSERT INTO gbl_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","“આંય તુમહાન આખહુ, કા નાંય; જો તુમાબી પાપ નાંય છોડહા તે તુમાબી યેજ રીતેકોય નાશ ઓઅહા. ");
INSERT INTO gbl_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","નાયતે કાય તુમા હોમાજતાહા, જ્યા અડાર જાંઅહા બારામાય જ્યાહાવોય યેરૂસાલેમ શેહેરા પાહીને શિલોહ બુરુજ ટુટી પોડીન, દાબાઈન મોઅઇ ગીયા, કાય ચ્યા યેરૂસાલેમ શેહેરા લોકહા એને યેરૂસાલેમમાય રોનારે બોદહા કોઅતે વોદી પાપી આતેં? ");
INSERT INTO gbl_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","આંય તુમહાન આખહુ કા; તુમા પાપ નાંય છોડહા તે તુમહે નાશ યેજ રીત્યેકોય ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","પાછે ઈસુય દાખલો બી આખ્યો, “કાદા તેરી દારાખાહા વાડીમાય અંજીરા જાડ આતા, દર વોરહે તો ચ્યામાય ફળ હોદા યેય, બાકી નાંય જોડયા. ");
INSERT INTO gbl_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","તોવે ચ્યાય વાડી રાખવાળ્યાલ આખ્યાં, ‘એએ, તીન વોરહા કોય આંય યા અંજીરા જાડાવોય ફળ હોદા યાહુ, બાકી નાંય મીળે, યાલ ખાંડી ટાક કા તીં હાર્યે જમીનીલ બી બોગડાવી રીયહા.’ ");
INSERT INTO gbl_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","વાડી રાખવાળ્યાય માલિકાલ જોવાબ દેના, ઓ માલિક, યાલ યે વોરહી આજુ રા દે, કા યા જાડા ચારી ખૂણહામાય ખોદીન ખોત ટાકું. ");
INSERT INTO gbl_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","જો યેતે વોરહી ફળ દેય તોવે હારાં, નાંય તે ચ્યાલ ખાંડી કાડહુ.” ");
INSERT INTO gbl_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","આરામા દિહે ઈસુ યોક સોબાયે ઠિકાણે હિકાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","તાં યોક બાઈ આતી, એને જ્યેં કૉબરામાયને ડોંગી વોળી ગીઅલી આતી, એને કોઅયેહેજ રીતે તી હિદી ઓઈ નાંય હોકતી આતી. ");
INSERT INTO gbl_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ઈસુય ચ્યેલ એઇન હાદ્યા, એને આખ્યાં, “ઓ બાઈ, તું તો નોબળાયે માઅને હારી ઓઈ ગીયી.” ");
INSERT INTO gbl_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","તોવે ઈસુય ચ્યેવોય આથ થોવ્યો, એને તી તારાત હિદી ઓઈ ગીયી, એને પોરમેહેરા મહિમા કોઅરા લાગી. ");
INSERT INTO gbl_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","યાહાટી કા ઈસુય ચ્યેલ આરામા દિહી હારી કોઅયેલ, સોબાયે ઠિકાણે જો આગેવાન ખિજવાઈન લોકહાન આખા લાગ્યો, “યોકા આઠવાડયામાય છ: દિહી હેતા આમહાન કામ કોઅરાહાટી, ચ્ચાહાટી ચ્યાજ દિહામાય યેયન હારેં ઓરા, બાકી આરામા દિહે નાંય.” ");
INSERT INTO gbl_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ઈ વોનાઈન પ્રભુય જોવાબ દેનો, “ઓ ડોંગ્યાહાય, કાય આરામા દિહે તુમહે ડોબહાલ એને ફૂરક્યાહાલ છોડીન પાંઈ પાજા નાંય લી જાત? ");
INSERT INTO gbl_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","તો કાય ઈ હારાં નાંય હેતા, કા ઈ બાઈ જીં આબ્રાહામા કુળામાઅને હેય, જ્યેલ સૈતાનાય અડાર વોરહા લોગુ બાંદી રાખલી આતી, આરામા દિહી ચ્યેલ બંધનામાઅને છોડવામાય યેહે?” ");
INSERT INTO gbl_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","જોવે ઈસુય યો વાતો આખ્યો, ચ્યા બોદે વિરુદી લાજવાઈ ગીયા, એને લોકહા બોદો ટોળો તીં મહાન કામે તો કોઅતો આતો, ચ્યાહાથી ચ્યે આનંદિત ઓઅયે. ");
INSERT INTO gbl_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","પાછે ચ્યાય આખ્યાં, “પોરમેહેરા રાજ્ય કા હારકા હેય? એને આંય ચ્યા ઉપમા કોહડા કોય દાવ? ");
INSERT INTO gbl_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","તીં રાયે દાણા હારકા હેય, જ્યાલ કાદા માઅહાય લેઈને પોતાના રાનામાય પોઅયા એને તી વોદીન જાડ ઓઈ ગીયા; એને આકાશામાય ઉડનારે ચિડેં યેઇન ચ્યા ડાહાગીવોય ગોરો કોઅયો.” ");
INSERT INTO gbl_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ચ્યાય પાછે આખ્યાં, “આંય પોરમેહેરા રાજ્યા ઉપમા કોહડા કોય દાવ? ");
INSERT INTO gbl_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","તી ખમીરા હારકા હેય, જ્યાલ કાદ્યે થેએયે લેયને તીન માપ કુટામાય મોગલી દેના, એને દિરે-દિરે બોદો કુટ ખમીર ઓઈ ગીયો.” ");
INSERT INTO gbl_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ઈસુ શિષ્યહાઆરે શેહેર-શેહેર એને ગાવહે-ગાવહે જાયન હિકાડતો યેરૂસાલેમ શેહેરા એછે જાય રિઅલો આતો, ");
INSERT INTO gbl_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","એને કાદાય ચ્યાલ પુછ્યાં, “ઓ પ્રભુ, કાય પોરમેહેર વોછા લોકહાન અનંતકાળા શિક્ષાથી બોચાવી?” ઈસુવે ચ્યાલ આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“પોરમેહેરા રાજ્યામાય હાકડા બાઅણા માઅને જાઅના કોઠણ હેય, કાહાકા આંય તુમહાન આખહુ, બોદેજ જાં માગી, બાકી નાંય જાય હોકી. ");
INSERT INTO gbl_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","જોવે પોરમેહેર, જો ગોઆ માલિક હેય, દરવાજો બોંદ કોય દી, એને તુમા બારે ઉબે રોઇન દારવાજો ખોકડાવીન રાવ્યાં કોઇન આખહા, ‘ઓ પ્રભુ, આમેહાટી દારવાજો ખોલી દે,’ એને તો જોવાબ દી, ‘આંય તુમહાન નાંય વોળખું, તુમા કેછને હેય?’ ");
INSERT INTO gbl_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","તોવે તુમા આખહા, ‘આમહાય તો હામ્મે ખાદાં-પિદાં એને તુયે આમે આટામાય હિકાડયાં.’ ");
INSERT INTO gbl_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","બાકી તો આખરી, ‘આંય તુમહાન આખહુ કા, આંય તુમહાન નાંય વોળખું કા તુમા કેછને હેય, ઓ અન્યાય કોઅનારાહા, તુમા બોદે મા ઇહિને દુઉ ઓઈ જાં.’ ");
INSERT INTO gbl_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","તાં રોડના એને દાત કોકડાવના ઓરી; જોવે તુમા આબ્રાહામા એને ઈસાક એને યાકૂબા એને બોદા ભવિષ્યવક્તાલ પોરમેહેરા રાજ્યામાય બોઠલા, એને તુમહાન બાઆ કાડી દેનલા એઅહા. ");
INSERT INTO gbl_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","એને પૂર્વ એને પચ્છીમ, ઉત્તર એને દક્ષીણ એછને લોક યેઇન પોરમેહેરા રાજ્યા જેવાણમાય ભાગીદાર ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ઈ જાઈલા, કોલહેક જ્યેં આમી પાછલા હેય ચ્યે પેલ્લે ઓઅરી, એને કોલહેક જ્યેં પેલ્લે હેતેં, ચ્યે પાછલા ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ચ્યેજ સમાયે કોલહાક પોરૂષી લોકહાય યેયન ઈસુલ આખ્યાં, “ઇહિને નિંગીન જાતો રો, કાહાકા હેરોદ રાજા તુલ માઆઇ ટાકાં માગહે.” ");
INSERT INTO gbl_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ઈસુવે ચ્યાહાન આખ્યાં, “જાયને ચ્યાલ જો કોલાહ હારકો ચાલાક હેય, આખી દે આંય આજે એને કાલે બુતાહાલ કાડીન બિમાર માઅહાલ હારાં કોઅહુ, એને તીજે દિહી આપહે કામ આંય પુરાં કોઅઇ લિહીં. ");
INSERT INTO gbl_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","તેબી માન આજે એને કાલે એને પોરે દિહી ચાલના જરુરી હેતા, કાહાકા યોક ભવિષ્યવક્તા યેરૂસાલેમ શેહેરામાયજ માઅલો જાય”. ");
INSERT INTO gbl_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ઓ યેરૂસાલેમ શેહેરા લોકહાય, ઓ યેરૂસાલેમ શેહેરા લોકહાય, તુમા ભવિષ્યવક્તાહાલ માઆઇ ટાકતાહા, જ્યાહાલ બોજ પેલ્લા તુમહેપાય દોવાડયેલ, ચ્યાહાન દોગડાકોય ઠોકતાહા. કોલાદા માયે ઇચ્છા કોઅયી કા જેહેકોય કુકડી પિચલાહાલ પાખડા તોળે બોચાવ કોઅહે, તેહેકોય આંયબી તો પાહાહાન રાખવાળી કોઉ, બાકી તુમહે ઇચ્છા નાંય આતી. ");
INSERT INTO gbl_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","એઆ, યાહાટી આમી હોમજી લા કા તુમહે ગોઅ તુમહેહાટી ઉજાડ કોઅવામાય યી. એને આંય તુમહાન આખતાહાવ, કા આમીને લેઈને જાવ લોગુ તુમા નાંય આખહા, ધન્ય હેય જો, પ્રભુ ઓદિકારાકોય યેહે, તાંવ લોગુ જાવ તુમા માન પાછા કોદહી નાંય એઅહા. ");
INSERT INTO gbl_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","પાછે ઈસુ આરામા દિહી પોરૂષી લોકહા આગેવાનાહા માઅને યોકા ગોઅમે ખાઅના ખાં ગીયો; એને ચ્યા ચ્યાવોય યોકદીઠ એઇ રીઅલા આતા યાહાટી કા ચ્ચામાય બુલ હોદી હોકે. ");
INSERT INTO gbl_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","તાં ચ્યા હોમ્મે યોક માઅહું આતા, જ્યામાય યોક ઓહડો રોગ આતો, કા ચ્ચા આથ એને પાગ હુજી ગીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","તોવે ઈસુય પોરૂષી લોકહાન એને મૂસા નિયમ હિકાડનારા ગુરુહુલ પુછ્યાં, “કાય આરામા દિહી લોકહાન હારાં કોઅના આમે નિયમામાય પરવાનગી હેય, કા નાંય?” ");
INSERT INTO gbl_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","બાકી ચ્યા ઠાવકાજ રિયા, એને તોવે ચ્યાય ચ્યા માઅહાલ આથલીન હારો કોઅયો, એને જાં દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ઈસુવે ચ્યાહાન આખ્યાં, “તુમહેમાઅને કાદા પોહો કા ડોબાં આરામા દિહી વેઅયે માય પોડી જાય તે ચ્યાલ તારાત નાંય કાડી લાહા?” ");
INSERT INTO gbl_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ચ્યા યે વાતહે કાયજ જોવાબ નાંય દી હોક્યા. ");
INSERT INTO gbl_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","જોવે ઈસુય એઅયા, કા આમંત્રણ કોઅલા લોક કેહેકેન ચ્યા જાગા નિવડી લેતહા જાં માનાપાના લોક બોહતાહા, તોવે પાછે ચ્યાય યોક દાખલો દેયન આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“જોવે તુલ કાદો વોરાડામાય હાદહે, તોવે મુખ્ય જાગામાય મા બોહહે, જાં માનાપાના લોક બોહતાહા, એહેકોય નાંય ઓઈ, કા તોથી બી વોદારે માનાપાના માઅહાલ આમંત્રણ દેના ઓરી. ");
INSERT INTO gbl_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","એને જ્યાંય તુલ એને ચ્યાલ બેનહ્યાલ આમંત્રણ કોઅયા ઓરી, યેયન તુલ આખરી, ‘ચ્યાલ જાગો દે,’ એને તુલ તોવે લાજવાયન બોદહાથી નિચલી જાગામાય બોહરા પોડી. ");
INSERT INTO gbl_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","બાકી જોવે તુલ હાદવામાય યી, તોવે બોદહાથી નિચલા જાગાવોય જાયને બોહો, કા જોવે તો, જ્યાંય તુલ આમંત્રણ દેનહા તો યી, તો તુલ આખી, ઓ હાંગાત્યા, હામ્મે યેયન બોહો, તોવે તોઆરે બોહનારાહા હામ્મે તુલ માન મિળી. ");
INSERT INTO gbl_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","કાહાકા જીં માઅહું પોતેજ મોઠા બોના માગહે, તી વાહનો બોની, એને જીં માઅહું પોતાલ વાહના ગોણહે, ચ્યાલ મોઠો ગોણવામાય યી.” ");
INSERT INTO gbl_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","તોવે ઈસુવે જ્યાંય હાદ્યેલ ચ્યા પોરૂષીલ બી આખ્યાં, “જોવે તું દિહયા કા રાતી ખાઅના ખાવાડે, તોવે તો હાંગાત્યો કા બાહહાલ કા હોગવાડયાહાલ કા ધોનાડ્યા પોડુશ્યાહાન નાંય હાદતો, એહેકોય નાંય ઓઈ કા ત્યેંબી તુલ હાદી, એને તો બોદલો ઓઈ જાય. ");
INSERT INTO gbl_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","બાકી તું ખાઅના ખાવાડે, તોવે તું ગોરીબાહાલ, ઠોટયાહાલ, અપંગાહાલ, લેંગડયાહાલ એને આંદળહાલ હાદા. ");
INSERT INTO gbl_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","તોવે તું ધન્ય ઓઅહે, કાહાકા ચ્યાહા પે તુલ બોદલો દાંહાટી કાયજ નાંય હેય, બાકી તુલ ન્યાયી લોક મોઅલા માઅને પાછા જીવી ઉઠી, તોવે પોરમેહેર તુલ ચ્યા ઇનામ દી.” ");
INSERT INTO gbl_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ચ્યાઆરે ખાઅના ખાનારાહા માઅને યોકાય ઈ વાત વોનાઈન આખ્યાં, “ધન્ય હેય જીં પોરમેહેરા રાજ્યામાય ખાઅના ખાઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ઈસુવે ચ્યાલ આખ્યાં, કાદા માઅહાય મોઠી મેજવાની દેની એને બોજ જાઅહાલ હાદ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","જોવે ખાઅના બોની ગીયા, તોવે ચ્યાય ચ્યા ચાકારાહાન આમંત્રિત લોકહાન હાદાં દોવાડયા, યા, આમી ખાઅના તિયારી હેય. ");
INSERT INTO gbl_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","બાકી બોદે ને બોદે માફી માગા લાગ્યેં, પેલ્લાય ચ્યાલ આખ્યાં, માયે જાગો વેચાતો લેદહો, એને જરુરી હેય કા આંય ચ્યાલ એરા જાંઉ; આંય તુલ વિનાંતી કોઅહુ, માન માફ કોઇ દે. ");
INSERT INTO gbl_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","એને બીજાય આખ્યાં, માય પાચ જોડી ડોબેં વેચાતે લેદહે, એને પારખા જાહું; આંય તુલ વિનાંતી કોઅહુ, માન માફ કોઇ દે. ");
INSERT INTO gbl_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","યોકાય પાછા યેયન આખ્યાં, માયે વોરાડ કોઅયાહાં, યાહાટી આંય નાંય યેય હોકુ. ");
INSERT INTO gbl_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ચ્યા ચાકારાહાય યેયન યો બોદ્યો વાતો ચ્યાહા માલિકાલ આખ્યાં, તોવે માલિકાલ ગુસ્સો યેનો એને ચ્યાય ચાકારાહાન આખ્યાં, શેહેરા આટામાય એને ગોલ્યેહેમ તારાત જાયને ગોરીબ, પાંગળ્યા એને લેંગડયા, એને આંદળા લોકહાન ઈહીં લેય યા. ");
INSERT INTO gbl_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ચાકારાય પાછા આખ્યાં, ઓ માલિક, જેહેકેન તુયે આખલા, તેહેકેન કોઅયા; તેરુંબી જાગો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","માલિકાય ચાકારાલ આખ્યાં, વાટહી વોય એને ગલહીમાય લોકહાન વિનાંતી કોઇન લીયા કા મા ગુઉ બોરાય જાય. ");
INSERT INTO gbl_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","કાહાકા આંય તુમહાન આખહુ, કા જ્યેં પેલ્લા આમંત્રિત કોઅલે આતેં, ચ્યા લોકાહામાઅને કાદોબી મા ખાઅના માથી નાંય ખાય. ");
INSERT INTO gbl_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","જોવે મોઠો ટોળો ઈસુઆરે જાય રિઅલો આતો, ચ્યાય પાહલા ફિરીન ચ્યાહાલ આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","બાકી કાદાં મા પાહી યેય, એને ચ્યા આબહો એને આયહો એને થેઅઈ એને પોહેં એને બાહા એને બોઅયહો એને પોતા જીવાલ બી અપ્રિય નાંય હુમજી, તોવે ચ્યા મા શિષ્ય નાંય ઓઈ હોકે. ");
INSERT INTO gbl_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","જીં માઅહું મા શિષ્ય ઓઅના લીદે દુઃખ નાંય વેઠે એને મોઅરાંહાટી તિયાર નાંય ઓએ, તીં મા શિષ્ય બોના લાયકે નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","જો તુમહેમાઅને કાદો બુરુજ બોનાડા માગહે, તો ચ્ચા પેલ્લા બોહીન યે વાતે ઇસાબ લાવે કા યાલ બોનાડાહાટી કોલહો ખોરચો લાગરી, એને ચ્યાપાય ચ્યાલ પુરાં કોઅરાહાટી પુરતાં પોયહા હેય કા નાંય. ");
INSERT INTO gbl_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","જોવે ચ્ચા એહેકોય નાંય ઓઈ, કા પાયો ટાકીન પાછે ચ્યાલ પુરાં નાંય કોઇ હોકે, તોવે બોદે ચ્યાલ એઅનારે એહેકોય આખીન ઓહરી, ");
INSERT INTO gbl_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","એઆ-એઆ ઈ માઅહું બોનાડા તે લાગ્યેલ બાકી આમી પુરાં નાંય કોઅઇ રીયોહો? ");
INSERT INTO gbl_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","પાછે, જોવે યોક રાજા દોહો ઓજાર સૈનિકાહા આરે બિજા રાજા હાતે લોડાય કોઅરા નિંગહે, જ્યા વીસ ઓજાર સૈનિકા હાતે ચ્યા વિરુદમાય યેનહા, તે બોદહા પેલ્લા તો બોહીન યે વાતે નક્કી કોઅરી કા કાય તો ચ્યા બિજા રાજા હમલો કોઅરાહાટી પુરે રીતેથી તાકાતવાળો હેય કા નાંય. ");
INSERT INTO gbl_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","નાંય તે દુર રોહે તાવુંજ તો પોતાના દૂતહાન દોવાડીન ચ્યાહાઆરે હોમજી લા માગી. ");
INSERT INTO gbl_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","યેજપરમાણે તુમહેમાઅને જીં કાદાં માઅહું પોતાના બોદાંજ છોડી નાંય દેય, તો મા શિષ્ય નાંય બોની હોકે. ");
INSERT INTO gbl_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","“મીઠાં તે જરુરી વસ્તુ હેય, બાકી મીઠાં ચોવવોગાર ઓઈ જાય, તે કોઅહી વસ્તુકોય ખારાં કોઅહા? ");
INSERT INTO gbl_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","તીં નાંય તે દોરત્યે હાટી નાંય તે ખોતા હાટી કામામાંય યેહે: ચ્યાલ તે લોક બાઆ ટાકી દેતહા. જો વોનાયા હાટી તિયાર હેય તો વોનાય લેય.” ");
INSERT INTO gbl_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","બોજ કર લેનારા એને જ્યાહાન લોક પાપી આખતેહે ચ્ચા લોક ચ્ચા પાહી વોનાયા હાટી યાં આતા. ");
INSERT INTO gbl_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","બાકી પોરૂષી લોક એને મૂસા નિયમ હિકાડનારા ગુરુ ટુટરીન આખા લાગ્યા, “ઓ તે પાપહયા આરે મિળહે એને ચ્યાહાઆરે ખાહેબી.” ");
INSERT INTO gbl_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","તોવે ઈસુય ચ્યાહાલ ઓ દાખલો આખ્યો: ");
INSERT INTO gbl_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“તુમહેમાઅને કું હેય, જ્યાવોય હોવ ગેટેં રોય, એને યોક ટાકાઇ જાય, તોવે નોવાણુ ગેટહાલ જાડયેમાય છોડીન, જીં ગેટા ટાકાઇ ગીયહા ચ્યાલ જાંઉ લોગુ નાંય સાપડી તાંવ લોગુ ચ્યાલ હોદતો નાંય રોય? ");
INSERT INTO gbl_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","એને જોવે સાપડી જાહે, તોવે તો બોજ આનંદથી ચ્યાલ ચ્યા ખાંદાવોય ઉસલી લેહે. ");
INSERT INTO gbl_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","એને પોતાના ગોઓ યેયન ચ્યા હાંગાત્યા એને પોડુશ્યાહાન બેગે કોઇન આખહે, ‘મા આરે આનંદ કોઆ, કાહાકા મા ટાકાઇ ગીઅલાં ગેટા મિળી ગીયહા.’ ");
INSERT INTO gbl_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","આંય તુમહાન આખહુ કા ચ્યેજ રીતે યોક પાપ કોઅના બંદ કોઅનારા પાપી લોકહા બારામાય હોરગામાય ઓલોજ આનંદ ઓરી, જોલા કા નોવાણુ ઓહડા ન્યાયી લોકહા બારામાય બી નાંય ઓઈ, જ્યાહાલ પાપ છોડના જરુરી નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ઈસુવે ચ્યાહાન પાછો યોક દાખલો દેનો, જોવે કાદ્યે થેઅયે પાય દસ ચાંદ્યે સિક્કા હેય એને ચ્યાહામાઅને યોક સિક્કો ટાકાય જાય, તોવે તી દિવો બાળીન, એને ગોઅમે બાઈ કાડી એને જાવ લોગુ નાંય મીળે તાંવ લોગુ દિયાન દેયન હોદતી રોય. ");
INSERT INTO gbl_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","એને જોવે સાપડી જાહે, તોવે તી ચ્યે બેનપોણીહિંલ એને પોડોશી બાઇહીલ યોકઠ્યો કોઇન આખહે, ‘મા હાતે આનંદ કોઅરા, કાહાકા ટાકાઇ ગીઅલો સિક્કો જોડી ગીયહો.’ ");
INSERT INTO gbl_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","આંય તુમહાન આખહુ, કા યેજ રીતે યોક પાપ કોઅનારો જોવે પાપ કોઅના બોંદ કોઅરી ચ્યાહાટી પોરમેહેરા હોરગા દૂતહા હામ્મે આનંદ ઓઅહે.” ");
INSERT INTO gbl_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","પાછા ઈસુય યોક દાખલો આખ્યો, “યોકા માટડા બેન પોહા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ચ્યાહામાઅને વાહના પોહાય પોતાના આબહાલ આખ્યાં, ‘ઓ આબા, મા મિલકાત માઅને જો મા હિસ્સો હેય, તો માન આમી દેય દે’ આબહાય પોતા મિલકાત બેની પોહાહાન વાટી દેની. ");
INSERT INTO gbl_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","કોલહાક દિહયા પાછે વાહનો પોહો જીં કાય ચ્યા આતા તી બોદા યોકઠા કોઇન દુર દેશામાય જાતો રિયો, એને તાં ખારાબ કામાહામાંય ચ્યાય ચ્યા બોદી મિલકાત ખોરચી દેની. ");
INSERT INTO gbl_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","જોવે વાહના પોહાય બોદા ખોરચી ટાક્યા, તોવે ચ્યા દેશામાય મોઠો દુકાળ પોડયો, એને ચ્યાપાય ખાંહાટી કાયજ નાંય આતા. ");
INSERT INTO gbl_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ચ્યાહાટી તો ચ્યા દેશા રેહેવાશ્યા માઅરે યોકા માઅહા ગોઅ કામ કોઅરા ગીયો, ચ્યા માઅહાય ચ્યાલ પોતા રાનહાંમાય ડુકરેં ચારાં દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","એને તો ઓલો બુખો આતો કા જ્યો હિંગ્યો ડુકરેં ખાતે આતેં ચ્યો હિંગ્યો ખાંહાટી ઇચ્છા ઓઅયી, કાહાકા ચ્યાલ કાદાં કાય ખાંહાટી નાંય દેતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","જોવે ચ્યાલ પોતાની બુલ હોમજાયી તોવે આખા લાગ્યો, મા આબહા ગોઅમે કોલાં બોદા ચાકારાહાન ખાઅનાથી વોદારે બાખ્યો મિળત્યોહો બાકી આંય ઈહીં બુખો મોઅહુ. ");
INSERT INTO gbl_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","આમી આંય ઉઠીન મા આબહા ઈહીં જાહીં એને આખહી કા, આબા માયે પોરમેહેરા વિરુદ એને તો હામ્મે પાપ કોઅયોહો. ");
INSERT INTO gbl_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","આમી આંય તો પોહો આખાયા લાયકે નાંય રોયહો, માન પોતાના યોક મોજર્યા હારકો રાખી લે.” ");
INSERT INTO gbl_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","“તોવે તો તી દેશ છોડીન ચ્યા આબહા ઈહીં જાંહાટી ચાલ પોડયો, તો આજુ દુરુજ આતો, તાઆવ ચ્યા આબહાલ ચ્યાલ દેખીન દોયા યેની, એને પોહા એછે દાહુદી ગીયો એને ચ્યાલ જાયન ગોળે મિળ્યો, એને ચ્યાલ બોજ ચૂમ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","પોહાય આબહાલ આખ્યાં, ‘આબા, માયે પોરમેહેરા વિરુદ એને તો વિરુદ પાપ કોઅયોહો, એને આંય તો પોહો આખાયાહાટી લાયકે નાંય રોયહો.’ ");
INSERT INTO gbl_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","બાકી ચ્યા આબહાય પોતાના ચાકારાહાન આખ્યાં કા, જલદી હારામાંય હારાં ડોગલાં લેયને ચ્યાલ પોવાડા, એને આથા આંગઠ્યેમાય વિટી પોવાડા, એને પાગહામાય વાઅણે પોવાડા. ");
INSERT INTO gbl_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","એને પાળલાં માતલા વાછડાં લીયા એને માઆઇન રાંદા કા આપા ખાયન આનંદ મોનાવહુ. ");
INSERT INTO gbl_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","કાહાકા ઈ એહેકોય આતા જેહેકેન મા પોહો મોઅઇ ગીઅલો આતો, પાછો જીવતો ઓઅય ગીયહો, ઓ ટાકાય ગીઅલો આતો બાકી આમી મિળી ગીયહો એને ચ્યા આનંદ મોનાવા લાગ્યા.” ");
INSERT INTO gbl_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“જોવે ઈ બોદા ઓઈ રીઅલા આતા ચ્યે સમાયે ચ્યા મોઠો પોહો રાનામાય કામ કોઅતો આતો, જોવે ગોઆ પાહી યેનો, તોવે ચ્યાલ ગીતે આખના એને વાજે વાજાડના એને નાચના આવાજ વોનાયો. ");
INSERT INTO gbl_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","તોવે ચ્યાય યોકા ચાકારાલ હાદિન પુછ્યાં, ‘ઈ કાય ઓઈ રીયહા?’” ");
INSERT INTO gbl_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","“ચ્યાય ચ્યાલ આખ્યાં, ‘તો બાહા પાછો ગોઓ યેનહો, એને તો આબહાય માતલા પાળલાં વાછડાં માઆડ્યાહા, કાહાકા તો બાહા હારેરીતે ગોઅ યેય પોઅચ્યોહો.’ ");
INSERT INTO gbl_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ઈ હાંબળીન ખિજવાય ગીયો, એને ગોઆ માજે નાંય જાય રિઅલો આતો, યાહાટી ચ્યા આબહો બાઆ યેનો, એને ચ્યાલ ગોઅમે યાંહાટી રાવ્યાં કોઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ચ્યાય આબહાલ જોવાબ દેનો, ‘એએ, આંય ઓલા વોરહાથી તો સેવા કોઅહુ એને કોદહીજ તો આગના નાંય ટાળહી, તેરુંબી તુયે માન યોકબી વાહના વાછડા બી નાંય દેના કા આંય તી માંઈને મા હાંગાત્યાહા હાતે ખાયન આનંદ કોઅતો. ");
INSERT INTO gbl_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","બાકી જોવે તો પોહો, જ્યાંય તો મિલકાત દુર જાયને વેશ્યાહાઆરે ખોરચી ટાકી, તો યેનો તે ચ્યાહાટી તુયે પાળલાં વાછડાં માંઈને રાંદાડયા.’ ");
INSERT INTO gbl_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","આબહાય ચ્યાલ આખ્યાં, ‘મા પોહા, તું કાયામ મા આરે હેય, એને જીં કાય મા હેય ઈ બોદા તોજ હેતાં. ");
INSERT INTO gbl_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","બાકી આમી આનંદ કોઅરા એને મગન ઓરા જોજે કાહાકા તો ઓ બાહા જેહેકોય મોઅઇ ગીઅલો આતો એને પાછો જીવતો ઓઅય ગીયહો, જો ટાકાય ગીઅલો આતો, બાકી આમી મિળી ગીયહો.’” ");
INSERT INTO gbl_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","પાછે ઈસુવે પોતાના શિષ્યહાન બી ઓ દાખલો આખ્યો, “યોક મિલકાતવાળા માઅહા યોક કારબારી આતો, લોકહાય માતલા માઅહા હામ્મે કારબારી વોય દોષ લાવ્યો કા ઓ તો બોદી મિલકાત ખોરચી ટાકહે. ");
INSERT INTO gbl_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","તોવે માલિકાય કારબાર્યાલ હાદિન પુછ્યાં, ઈ કાય હેય જીં આંય તો બારામાય વોનાય રિયહો? તુયે મા પોયહા કાય કોઅયા ચ્ચાહા બોદો ઇસાબ દે, કાહાકા તું આગલા કારબારી નાંય રોય હોકે. ");
INSERT INTO gbl_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","તોવે કારબારી વિચાર કોઅરા લાગ્યો, આમી આંય કાય કોઉ? કાહાકા મા માલિક આમી કારબારી કામાવોયને કાડી રિયહો, માન શરીરાકોય તે કામ ગાઠી નાંય પોડે, એને માગી ખાંહાટી માન શરામ યેહે. ");
INSERT INTO gbl_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","આમી આંય હોમજી ગીયો, કા કાય કોઅહી, જોવે આંય કારબારી કામાવોને છુટો ઓઈ જાવ તોવે લોક માન મોદાત કોએ. ");
INSERT INTO gbl_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","તોવે ચ્યાય પોતાના માલિકા કોરજાવાળહાન યોક-યોક કોઇન હાદ્યા એને પેલ્લાનેજ પુછ્યાં, તોવોય મા માલિકા કોલહો કોરજો હેય? ");
INSERT INTO gbl_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ચ્યાય આખ્યાં, હોવ મણ જૈતુન જાડા તેલ તોવે ચ્યાય ચ્યાલ આખ્યાં, ‘પોતાના ઇસાબા ચોપડા લે એને બોહીન તારાત બિજા ખાતામાય બોદલીન પોચહા મણ લોખી દે.’ ");
INSERT INTO gbl_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","પાછે ચ્યાય બિજાલ પુછ્યાં, ‘તોવોય કોલો કોરજો હેય?’ ચ્યાય આખ્યાં, ‘હોવ મણ ગોંવ,’ તોવે ચ્યાય ચ્યાલ આખ્યાં ‘પોતાના ઇસાબા ચોપડા લેઈને એંશી મણ લોખી દે.’” ");
INSERT INTO gbl_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“માલિકાય ચ્યા અન્યાયી કારબાર્યાલ આખ્યાં, તુયે બોજ હુશારી કોઇ કામ કોઅલા હેય, એહકોયજ યા દુનિયા લોક ચ્યાહા સોમાયા લોકહાઆરે વ્યવહારા માય, ઉજવાડા લોકહા કોઅતા બોજ ચતુર હેય. ");
INSERT INTO gbl_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","એને આંય તુમહાન આખહુ કા દુનિયાદારી રીતે કામાવલા મિલકાતેકોય તુમહેહાટી દોસ્તાર બોનાવી લા તે જોવે મિલકાત નાંય રોય, તે ચ્યા તુમહાન હોરગામાય આવકાર કોઅરી જા તુમા સાદામાટે જીવતા રોહા. ");
INSERT INTO gbl_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","જો વાહની-વાહની વાતમાય ઈમાનદાર હેય, તો મોઠી વાતમાય બી ઈમાનદાર હેય, એને વાહની વાતમાય બેઈમાન હેય, તો મોઠી વાતમાય બી બેઈમાન રોય. ");
INSERT INTO gbl_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","યાહાટી જોવે તુમા દોરતીવોય કામાવલા મિલકાત્યે માય ઈમાનદાર નાંય રોયા, તે હોરગામાઅને મિલકાત તુમહાન કું હોઅપી? ");
INSERT INTO gbl_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","એને જોવે તુમા બીજહા મિલકાતીવોય ઈમાનદાર નાંય ઠોરહા, તે જીં તુમહે હેય તી તુમહાન કું દેઅરી? ");
INSERT INTO gbl_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","કાદાબી માઅહું યોકાજ સમયે બેન દોણહ્યા ચાકરી નાંય કોએ, કાહાકા તો યોકા વિરુદ કોઅરી ને બિજાલ પ્રેમ કોઅરી, નાયતે યોકા આરે હારો ચાલીન બિજા આરે નાંય હારો ચાલી, તુમા પોરમેહેરા એને મિલકાત યા બેન્યહા ચાકરી નાંય કોઅય હોકે.” ");
INSERT INTO gbl_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","પોરૂષી લોક જ્યા લોબી આતા, યો વાતો વોનાયને ઈસુ મશ્કરી કોઅરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા તો માઅહા હામ્મે પોતાનાલ હાચ્ચાં દેખાડતાહા, બાકી પોરમેહેર તુમહે મન જાંઅહે, કાહાકા જીં વસ્તુ તુમહે નોજરેમાય મોહત્વા હેય, તીં પોરમેહેરા નોજરેકોય એઅના ખારાબ હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","જાવ લોગુ યોહાન બાપતિસ્મા દેનારો યેનો, તાંવ લોગુ મૂસા નિયમશાસ્ત્ર એને ભવિષ્યવક્તા વચન તુમહે માર્ગદર્શક રિયા; બાકી આમી પોરમેહેરા રાજ્યા હારી ખોબાર આખલી જાહે, એને બોદેજ યામાય ભાગીદાર ઓઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","આકાશ એને દોરતી ટાળાય જાયના નિયમશાસ્રા યોક બિંદુ મિટાય જાયના કોઅતા હેલ્લા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“જો કાદો માટડો ચ્યા થેઅયેલ ફારગાતી દેયન બિજ્યે થેએયે આરે વોરાડ કોએ, તે તો વ્યબિચાર કોઅહે, એને જો કાદો માટડો ફારગાતી દેનલ્યે થેઅયેઆરે વોરાડ કોઅહે, તે તેરુંબી વ્યબિચાર કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","“યોક મિલકાતવાળો માઅહું આતો, તો બોજ મોઅગેં ડોગલેં પોવતો આતો એને રોજ દિને હારાં-હારાં ખાઅના ખાતો આતો એને બોજ હારો રોતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","લાજરસ નાંવા યોક બીખારી માઅહું આતો, ચ્યા શરીર ફોડહાકોય બોઆલા આતા,, ચ્યાલ લોક મિલકાતવાળા માઅહા બાઆપુર થોવી દેતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","તો બોજ બુખો આતો ઓલે લોગુ કા તો ઇચ્છા રાખે, મિલકાતવાળા માઅહા પાયને ખાયન વોદી ગીઅલા ખાઅનાકોય બુકો બોએ. ઈહીં લોગુ કા કુત્રે બી યેયન ચ્યા ફોડહાન ચાટતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","એને યોક દિહી એહેકેન બોન્યા કા બીખારી લાજરસ મોઅઇ ગીયો, એને હોરગા દૂતહાય ચ્યાલ આબ્રાહામાઆરે રાંહાટી લેય ગીયા, એને યોક દિહી મિલકાતવાળા માઅહું બી મોઅઇ ગીયો, એને ચ્યાલ દાટી દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","એને તો અધોલોકમાય પીડામાય પોડયો, તોવે ચ્યાય ઉચે એઅયા, એને દૂરને આબ્રાહામા પાહી લાજરસાલ દેખ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","તોવે ચ્યાય બોંબલીન આખ્યાં, ‘ઓ આબા આબ્રાહામ, મા વોય દયા કોઇન લાજરસાલ દોવાડી દે, યાહાટી કા તો પોતાની આંગઠી પાઅયામાય બુડવીન મા જીબેલ હેળી કોઅય, કાહાકા આંય યા આગડામાય તોડપી રિયહો.’ ");
INSERT INTO gbl_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","બાકી આબ્રાહામાય આખ્યાં, ‘ઓ પોહા, યાદ કોઓ કા તું દોરતીવોય રોઇન પોતાના જીવનાહાટી વાન્યો-બાત્યો વસ્તુહુ લાભ લી ચુકયોહો, એને તેહેકોયજ લાજરસાલ બોદ્યો ખારાબ વસ્તુ મિળ્યો, બાકી તો આમી શાંતી પામી રિયહો, એને તું તોડપી રિયહો. ");
INSERT INTO gbl_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","એને ઈ બોદી વાતહેલ છોડીન આમહે એને તુમહે વોચમાય યોક મોઠો ખાડો ઠોરાવલો ગીયહો, કા કાદો ઇહિને તુમહેપાય યા માગે તો નાંય જાય હોકે એને જો કાદો તુમહે પાયને આમહેપાય યા માગે તો નાંય યી હોકે.’ ");
INSERT INTO gbl_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ચ્યાય આખ્યાં, ‘તે ઓ આબા, આંય તુલ વિનાંતી કોઅહુ કા, તું લાજરસાલ મા આબહા ગોઓ દોવાડ. ");
INSERT INTO gbl_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","કાહાકા મા પાચ બાહા જીવતા હેય; કા તો ચ્યાહાન ઈ ચેતાવણી દેય, એહેકોય નાંય બોના જોજે કા ચ્યાબી યે પીડા જાગામાય યેય પોડે.’ ");
INSERT INTO gbl_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","આબ્રાહામાય ચ્યાલ આખ્યાં, ‘ચ્યાહાન ચેતાવણી દાંહાટી મૂસા નિયમશાસ્ત્ર એને ભવિષ્યવક્તાહા ચોપડી હેય, તો ચ્યાહામાઅને વોનાયને ચ્યા પાલન કોએ.’ ");
INSERT INTO gbl_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ચ્યાય આખ્યાં, ‘નાંય, ઓ આબા આબ્રાહામ, જો કાદો મોઅલા માઅને ચ્યાહા પાહી જાયને ચ્યાહાન ચેતાવણી દેય, તોવે ચ્યા ચ્યાહા પાપ કોઅના બોંદ કોઅઇ દી.’ ");
INSERT INTO gbl_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","આબ્રાહામાય ચ્યાલ આખ્યાં, ‘જોવે તો મૂસા નિયમશાસ્ત્ર એને ભવિષ્યવક્તા ચોપડીમાઅને આગના નાંય માને, તે જો મોઅલા માઅને બી કાદો જીવી ઉઠી તેરુંબી ચ્યા બોરહો નાંય કોઅરી.’” ");
INSERT INTO gbl_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","પાછે ઈસુવે ચ્યા શિષ્યહાન આખ્યાં, “ઈ નોક્કી હેય કા, જ્યો વાતો માઅહાલ પાપા પરીક્ષાયો કોઆડત્યોહો, ચ્યો ઓઅરી, બાકી હાય, ચ્યા માઅહાલ જ્યા લેદે યો વાતો ઓઅત્યોહો. ");
INSERT INTO gbl_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","જો યા વાહના માઅને કાદા યોકાલબી પાપામાંય પાડહે, ચ્યાલ બોજ ખારાબ સાજા મિળી, ચ્યાહાટી ઈ હારાં ઓઅતા કા ગોઅટયે પુડ ચ્યા ગોગ્યેમાય બાંદિન દોરિયામાય બુડવી દેયના કોઅતાબી ઈ ખારાબ સાજા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","હાચવીન રા કા તુમા કાય કોઅતાહા, જોવે કાદોબી બોરહાવાળો બુલ કોઅહે, તોવે ચ્યાલ હોમજાડ, એને જોવે તો પોસ્તાવો કોએ તોવે ચ્યાલ માફ કોઇ દે. ");
INSERT INTO gbl_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","જો દિહ્યામાય હાંત દા તોઆરે બુલ કોએ, એને હાંત દા યેઇન આખે, માન માફ કોઓ મા બુલ જાયહી, તોવે ચ્યાલ માફ કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","તોવે પ્રેષિતાહાય ઈસુવાલ આખ્યાં, “આમહે બોરહો આજુ મજબુત કોઅરા મોદાત કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","તોવે ઈસુવે આખ્યાં, જોવે રાયે દાણા ઓલહો બોરહો તુમહાન રોતો, તોવે યા ઉબા સેતુરા જાડાલ તુમા આખતા કા મૂળાઇહિને ઉપડાયન દોરિયામાય જાય પોડ, એને તીં તુમહે માની જાતા. ");
INSERT INTO gbl_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","જો તુમહે ચાકાર રાનામાય ઓળ જુપીન કા ગેટેં ચાઈન ગોઓ યેય, તે તુમા કાય આખહા, તારાત યે એને ખાઅના ખાં બોહો? ");
INSERT INTO gbl_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","નાંય, બાકી તુમા એહેકોય આખહા કા, “માંહાટી ખાઅના રાંદ, એને આંય જાવ લોગુ ખાય ઉઠું તાંઉ તું ઉબો રોઇન મા ચાકરી કોઆહાટી તિયાર ઓઈ જો પાછે તુંબી ખાય લેજે. ");
INSERT INTO gbl_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","તુમા ચ્યા ચાકારા ચ્યા કોઅલા કામાહાટી આભાર નાંય માનહા જીં તુમહાય ચ્યાલ કોઅરા આખ્યેલ. ");
INSERT INTO gbl_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","તેહેંજ કોઇન, તુમા હોગા જોવે તુમહાન જીં આખલા આતા તીં બોદા તુમહાય પુરાં કોઅયા, તોવે એહેંજ આખજા આમહાય તે માન મીળે ઓહડા કાયજ કોઅયાહાં નાંય, બાકી જીં કામ કોઅના આતા તોલહાંજ કોઅયાહાં.” ");
INSERT INTO gbl_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","જોવે ઈસુ એને ચ્યા શિષ્ય યેરૂસાલેમ શેહેરા એછે જાનારી વાટ્યેવોય સમરૂના એને ગાલીલ ભાગા વોચમાઅને જાય રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","તો યોકા ગાવામાય જાતી વેળાયે ચ્યાલ દોહો કોડળ્યા મિળ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ચ્યાહાય દુઉને મોઠેથી બોંબલીન આખ્યાં, “ઓ ઈસુ, ઓ ગુરુજી, આમહે ઉપે દયા કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ઈસુવે ચ્યાહાન એઇન આખ્યાં, “જાયા, એને તુમહે શરીર યાજકાહાલ દેખાડાં” યાહાટી ચ્યા એઇ હોકે કા તુમા હારાં ઓઅયાહા કા નાંય એને ચ્ચા વાટે ચાલતાંજ હારાં ઓઅઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","આંય હારો ઓઅઇ ગીયહો, એહેકોય એઇન ચ્યાહામાઅનો યોક જાંઆ મોઠેરે પોરમેહેરા ગીતે આખતો ઈસુહી પાછો ફિરી યેનો. ");
INSERT INTO gbl_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","એને ઈસુવાલ પાગે પોડીન, ચ્યા આભાર માન્યો, તો યોક સમરૂની આતો. ");
INSERT INTO gbl_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","તોવે ઈસુવે આખ્યાં, “દોહે દોહો માટડા હારાં જાયા કા નાંય? તે પાછે નોવ જાંઆ કેછ હેતા? ");
INSERT INTO gbl_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","પાછો યેઇન પોરમેહેરા આભાર માને ઓહડો ઓ યોક પારદેશીયા સિવાય કાદા નાંય મીળે કા?” ");
INSERT INTO gbl_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","તોવે ઈસુય ચ્ચાલ આખ્યાં, “ઉઠીન જાતો રો, તો બોરહા લીદે તો બોચાવ ઓઈ ગીયહો.” ");
INSERT INTO gbl_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","જોવે પોરૂષી લોકહાય પુછ્યાં, કા પોરમેહેરા રાજ્ય કોદહી યેઅરી? ઈસુવે જાવાબ દેનો કા, “પોરમેહેરા રાજ્ય ઓહડા નાંય હેય જેહેકોય તુમા એઅઇ હોકતાહા. ");
INSERT INTO gbl_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","એને લોક એહેકોય નાંય આખરી કા? ‘એઅયા, ઈહીં હેય, કા એપેં હેય’ કાહાકા એઆ, પોરમેહેરા રાજ્ય તુમહે વોચ્ચે હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","પાછા શિષ્યહાન ચ્યે આખ્યાં, “ઓહડા દિહી યી જોવે તુમા માઅહા પોહા યોકુજ દિહી એરા માગહા, બાકી તુમહાન એરા નાંય મિળી. ");
INSERT INTO gbl_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","એને માઅહે તુમહાન આખરી કા ‘એએ, ખ્રિસ્ત તાં હેય!’ નાંય તે ઈહીં હેય! તોવે તુમા મા જાતા, એને ચ્યાહા પાહલા મા દાહું દેતા. ");
INSERT INTO gbl_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","કાહાકા જેહે કોઇન જોવે વીજળેહે તોવે આકાશ યોક છેડાને બિજા છેડા લોગુ વીજ ચમકેહે, તેહેકેન માઅહા પોહા દિહી બી ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","બાકી પેલ્લા ઈ જરુરી હેય કા, તો બોજ દુઃખ વેઠી, એને યે પેડયે લોક ચ્યાલ દોઆડી દી. ");
INSERT INTO gbl_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","જેહેકોય નોહા દિહામાય બોન્યાં, તેહેકેન માઅહા પોહા દિહહયામાય બી ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","જ્યા દિહયા લોગુ નોહો ઉડીમાય નાંય ચોડયેલ, ચ્યા દિહી યા લોગુ લોક ખાં-પિયાં આતા, એને ચ્યા વોરાડે બી કોઅતા આતા. એને રેલ યેની એને બોદહાન નાશ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","એને તેહેકોયજ આગલ્યાડાયા લોટા દિહામાય, જો સદોમ શેહેરામાય રોતો આતો, ચ્યા લોક ખાં-પિયાં આતા, વેચું આતા, વેચાતાં લાં આતા, જાડેં લાવતા આતા, ગોએ બાંદા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","બાકી જો દિહી લોટ સદોમ શેહેરામાઅને નિંગી ગીયો તોદહી આકાશા એછરે આગ એને ગંધક પોડયો, એને બોદા નાશ કોઇ દેના, ");
INSERT INTO gbl_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","માઅહા પોહા પાછો યેઅના દિહી બી એહકોયજ ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","તોદિહી જો ગોઆ ઉપે ચોડયો ઓરી, ચ્યા સામાન ગાઅમે ઓઅરી તો કાયબી લાંહાટી પાછા નિચે ગોઆમાય નાંય ઉરાય; તેહેકોયજ જો રાનામાય ઓરી તો પાછો નાંય ફિરી યેય. ");
INSERT INTO gbl_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","લોટા થેએયે આરે કાય જાયેલ જોવે ચ્યેય પાહલા એઅયા! ");
INSERT INTO gbl_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","કાહાકા જીં માઅહું દોરતીવોય પોતે જીવ બોચાવાં માગહે, તો અનંતજીવન ગુમાવી દી, બાકી જો કાદો મા લીદે ચ્યા જીવ દેહે, તો અનંતજીવન મેળવી. ");
INSERT INTO gbl_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","આંય તુમહાન આખતાહાવ કા ચ્યે રાતી બેન માઅહે યોકા ખાટલામાય હુતલે રોય, યોક લી લેવામાય યી, એને બિજાં છોડી દેવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","બેન થેએયો આરેજ બોહીન ગોઅટયે દોળાં બોહી, ચ્યેહેમાઅને યોક લી લેવામાય યી, એને બીજી છોડી દેવામાય યી.” ");
INSERT INTO gbl_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","બેન જાંએ રાનામાય રોય, ચ્યાહામાઅને યોક લેવાઈ જાઈ એને યોક તાં રોઈ જાઈ. ");
INSERT INTO gbl_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ઈ વોનાયને ચ્યાહાય ઈસુલ પુછ્યાં, “ઓ પ્રભુ ઈ કેછ ઓઅરી?” ચ્યે ચ્યાહાન જાવાબ દેનો, “જાં મુરદાં હેય, તાંજ ગીદ બેગા ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ઈસુય ચ્યા શિષ્યહાન આખ્યાં, યા બારામાય કાયામ પ્રાર્થના કોઅરા જોજે, એને ઈંમાત નાંય છોડા જોજે, ઈ વાત ચ્યાહાન હિકાડાંહાટી ઈસુવે ઓહડો દાખલો આખ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","યોક શેહેરામાય યોક ન્યાય કોઅનારો રા આતો, તો પોરમેહેરા દાક નાંય રાખે, એને કાદા માઅહા પારવા બી નાંય રાખતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ચ્યા શેહેરામાય યોક વિધવા બાય રોતી આતી, જીં ચ્યાપાય યેયન આખતી આતી, મા ન્યાય કોઇન માન મા દુશ્માનાહા પાયને બોચાવ. ");
INSERT INTO gbl_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ચ્યાય બોજ દિહી લોગુ તે નાંય માન્યો બાકી પાછે વિચાર કોઅહે આંય પોરમેહેરા દાક બી નાંય રાખું એને કાદા માઅહા પારવા બી નાંય રાખું. ");
INSERT INTO gbl_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","તેરુંબી ઈ વિધવા બાય માન હેરાન કોઅહે, યાહાટી યે બાયે માન ન્યાય કોઅરા પોડી, કાહાકા એહેકોય નાંય બોના જોજે કા ગેડી-ગેડી યેયન સેલ્લે તી માન બોજ હેરાન કોઇ દેય. ");
INSERT INTO gbl_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","પાછે પ્રભુ ઈસુવે આખ્યાં, યા અન્યાયી ન્યાય કોઅનારાય જીં આખ્યાં, ચ્યા બારામાય દિયાન દેયન વિચાર કોઆ. ");
INSERT INTO gbl_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","પોરમેહેરાય ચ્યા નિવાડલા લોકહાહાટી જ્યા દિહીન-રાત ચ્યા હોમ્મે વિનાંતી કોઅયી, પોરમેહેર ચ્યાહા મોદાત કોઅરાહાટી વાઆ નાંય લાવી. ");
INSERT INTO gbl_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","આંય તુમહાન આખહુ, તો તારાત ચ્યાહા ન્યાય કોઅરી, બાકી જોવે આંય, માઅહા પોહો પાછો યીહીં, તોવે માન દોરતીવોય માયેવોય બોરહો કોઅનારા કોલાં લોક મિળી? ");
INSERT INTO gbl_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","એને ઈસુવે ચ્યા લોકહાન જ્યા પોતા બારામાય એહેકોય વિચાર કોઅતા કા, “આમા હારાં હેજે” એને બીજહાન નિચા ગોણુ આતા ચ્યાહાન ઓ દાખલો આખ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","“બેન માટડા દેવાળામાય પ્રાર્થના કોઅરાહાટી ગીયા; યોક પોરૂષી આતો એને યોક જકાતદાર આતો. ");
INSERT INTO gbl_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","પોરૂષી ઉબો રોઇન પોતે મોનામાય ઓહડી પ્રાર્થના કોઅયી કા, ઓ પોરમેહેર, આંય તો આભાર માનહું, કા આંય બિજા માઅહા હારકો લોબી, જુલમી, વ્યબિચારી નાંય હેય, એને યા કર લેનારા હારકો નાંય હેતાઉ. ");
INSERT INTO gbl_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","આઠવાડયામાય બેનદા ઉપહા કોઅતાહાંવ, એને મા બોદી આવાક માઅને દોસમો ભાગ આંય તુલ દેતહાવ. ");
INSERT INTO gbl_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","બાકી જકાતદાર દુઉ ઉબો રિયો, હોરગા એછે નોજાર ઉચી કોઅના બી ચ્યા ઈંમાત નાંય ચાલી, તો દુઃખને હાતે છાતી કુટીન આખા લાગ્યો, ઓ પોરમેહેર, આંય પાપી હેતાંવ, માયેવોય દયા કોઇન માન માફ કોઓ. ");
INSERT INTO gbl_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","આંય તુમહાન આખતાહાવ, તો પેલ્લો નાંય, બાકી જકાતદાર હેય પોરમેહેરા હામ્મે ન્યાયી બોનીન એલા ગોઓ ગીયો; કાહાકા જો માઅહું મોઠા બોના માગે, તો વાહનો બોની એને જીં માઅહું પોતાલ વાયહાના ગોણે, તો મોઠો બોની.” ");
INSERT INTO gbl_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","પાછે માઅહે પાહાહાન ઈસુપાય લેયા લાગ્યેં, યાહાટી કા તો ચ્યાહાવોય આથ થોવિન ચ્યાહાન બોરકાત દેય, બાકી શિષ્ય માઅહાન દોમકાડે. ");
INSERT INTO gbl_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","બાકી ઈસુવે ચ્યાહાન પાહાય હાદિન આખ્યાં, “પાહાહાન માયેપાંય યાં દા, ચ્યાહાન ઓટકાડાહા મા, કાહાકા ચ્યાજ લોક જ્યા યા પાહાહા હારકા બોરહા લાયકે હેય, પોરમેહેરા રાજ્યામાય ચ્યાજ રોય. ");
INSERT INTO gbl_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, જ્યેં માઅહે પાહાહા હારકા પોરમેહેરાલ નાંય હોઅપે, ચ્યે પોરમેહેરા રાજ્યામાય ચ્યા માઅહે નાંય બોની.” ");
INSERT INTO gbl_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","યોક આગેવાનાય ચ્યાલ ઓહડો સાવાલ પૂછ્યો કા, “ઓ ગુરુ, કાય કામ કું કા પોરમેહેર માન અનંતજીવન દેય?” ");
INSERT INTO gbl_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ઈસુવાય ચ્યાલ જોવાબ દેનો કા, “તો આખના મોતલાબ કાય હેય કા આંય હારો હેય? પોરમેહેરા સિવાય કાદોજ ઉત્તમ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","તું પોરમેહેરા આગના જાંઅતોહો, ખૂન નાંય કોઅના, વ્યબિચાર નાંય કોઅના, ચોરી નાંય કોઅના, જુઠી સાક્ષી નાંય દેઅના, કાદાલ દોગો નાંય દેયના, એને આપહે આયહે આબહા માન રાખના.” ");
INSERT INTO gbl_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","બાકી ચ્યે ઈસુલ એહેકોય આખ્યાં કા, “ઓ ગુરુ, યો બોદ્યો આગના આંય હાનેરેજ માનતો યેનહો”. ");
INSERT INTO gbl_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ઈ વોનાયને ઈસુય ચ્યાલ આખ્યાં, “આજુ યોક વાત હેય જીં તુલ કોઅના જરુરી હેય, જો, જીં કાય તો હેય તીં બોદા વેચિન ગોર-ગોરીબાહાન દેય દે, જો એહેકોય કોઅહે, તે તોપાય હોરગામાય મિલકાત રોઅરી એને યેયન મા શિષ્ય બોની જો.” ");
INSERT INTO gbl_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","બાકી તો ઈ વોનાયો તોવે તો નિરાશ ઓઈ ગીયો, કાહાકા તો બોજ માલદાર આતો. ");
INSERT INTO gbl_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ચ્યાલ નિરાશ દેખીન, ઈસુવે આખ્યાં, “માલદાર લોકહાન પોરમેહેરા રાજ્યામાય જાઅના બોજ કોઠાણ હેય. ");
INSERT INTO gbl_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ઉટડાલ હુવ્યે નાકલામાંઅરે જાઅના કોઠાણ હેય, તેહેકોય માલદાર માઅહાલ પોરમેહેરા રાજ્યામાય જાઅના બોજ કોઠાણ હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","જ્યા ઈ વાત વોનાયા, ચ્યાહાય પુછ્યાં, “તે પાછે કાહાટી પોરમેહેરા રાજ્યામાય જાંહાટી તારણ ઓઈ જાઅના કેહેકેન સંભવ હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ઈસુય ચ્યાહા એછે એઇન આખ્યાં, “ઈ માઅહાલ તે નાંય ઓઈ હોકે, બાકી પોરમેહેરાથી ઓઅઇ હોકી; કાહાકા પોરમેહેર બોદાંજ કોઅઇ હોકહે. ");
INSERT INTO gbl_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","પિત્તરે ચ્યાલ આખ્યાં, આમે કાય ઓઅરી? આમહાય તે તો શિષ્ય બોનાહાટી બોદાંજ છોડી દેનલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ઈસુય શિષ્યહાન આખ્યાં, “તુમહાન આંય હાચ્ચાં આખતાહાવ, મા શિષ્ય બોનાહાટી એને પોરમેહેરા રાજ્યાહાટી, જ્યા કાદાંયબી ચ્યા ગુઉ છોડી દેનલા હેય, એને ચ્યા બાહા બોઅહી એને આયહો એને આબહો એને પાહાહાન કા ચ્યા ખેતાર છોડયા ઓરી. ");
INSERT INTO gbl_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","તો નોક્કીજ યે પેડીયેમાય સતાવણી આરે-આરે બોજ વસ્તુ મેળવી, એને યેનારા સોમાયામાય અનંતજીવન મેળવી.” ");
INSERT INTO gbl_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","તોવે ઈસુવે ચ્યા બાર શિષ્યહાન આરે લેઈને આખ્યાં, “આપા યેરૂસાલેમ શેહેરમાય જાજહે, માઅહા પોહા બારામાય ભવિષ્યવક્તાહાય જીં કાય આખ્યેલ, તીં પુરાં ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","કાહાકા ચ્યા પારકા લોકહા આથામાય દોઆડી દેઅરી, ચ્યા લોક ચ્યા મશ્કરી કોઅરી, એને ચ્યા અપમાન કોઅરી, ત્યાઊપે થૂપી. ");
INSERT INTO gbl_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ચ્યાલ ચોપકાહા માર ઠોકી, એને માઆઇ ટાકી એને તીજે દિહી તો મોઅલાહામાઅને પાછો જીવતો ઉઠી.” ");
INSERT INTO gbl_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","બાકી શિષ્યાહાન યે વાતો માઅને કોઅહીજ વાત હોમાજ નાંય પોડી એને ઈ વાત ચ્યાહા પાયને ડાકાય રોયી, એને જીં આખ્યાં તી ચ્યાહાન હોમાજ નાંય પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","જોવે ઈસુ એને ચ્યા શિષ્ય એને લોકહા મોઠો ટોળો યેરીખો શેહેરા પાહી યેના, તોવે યોક આંદળો વાટે મેરે બોહીન બિખ માગ્યાં કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","ચ્યાહાન તાં લાગીન જાતો તો વોનાયો, તોવે ચ્યે પુછ્યાં કા, “ઈ કાય ઓઈ રીઅલા હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","લોકહાય ચ્યાલ આખ્યાં, ઈસુ જો નાજરેત ગાવા હેય, તો યે વાટે જાય રિઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","તોવે ચ્યાય બોંબલીન આખ્યાં, “ઓ ઈસુ, દાઉદ રાજા કુળા પોહા, માયેવોય દયા કોઓ! ");
INSERT INTO gbl_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","જ્યા આગલા ચાલે ચ્યા ચ્યાલ દોમકાડા લાગ્યા એને ઠાવકાજ રો આખ્યાં, બાકી તો આજુ મોઠેરે બોંબાલતો લાગ્યો કા, ઓ ઈસુ, દાઉદ રાજા કુળા, માયેવોય દયા કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","એને ઈસુ ઉબો રિયો એને ચ્યાલ પાહી લીયા આખ્યાં, જોવે તો પાહી યેનો, તોવે ચ્યાલ ચ્યે પુછ્યાં, ");
INSERT INTO gbl_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“તુલ કાય જોજે? તોહાટી આંય કાય કોઅઉ?” ચ્યે આખ્યાં, “પ્રભુ, આંય દેખતો ઓઉં.” ");
INSERT INTO gbl_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","તોવે ઈસુવે ચ્યાલ આખ્યાં, “તું માયેવોય બોરહો કોઅતોહો યાહાટી આંય તો બોચાવ કોઅતાહાંવ.” ");
INSERT INTO gbl_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","એને તારાતુજ તો દેખતો ઓઈ ગીયો, એને પોરમેહેરા સ્તુતિ કોઅતો લાગ્યો, એને વાટ દોઇન ચ્યા પાહલા ચાલા લાગ્યો, એને બોદા લોકહાય દેખીન પોરમેહેરા સ્તુતિ કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ઈસુ એને ચ્યા શિષ્ય એને લોકહા ટોળો યેરીખો શેહેરામાઅને જાય રિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","તાં જાખી નાંવા યોક માટડો આતો, તો કર લેનારાહા મુખ્ય આતો એને માતલો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","તો ઈસુ કોહડો હેય તી એરા માગતો આતો, બાકી ઈસુઆરે લોકહા બોજ મોઠો ટોળો આતો ચ્યા લીદે તો ચ્યાલ નાંય એઇ હોક્યો, કાહાકા તો વાય નિચો માટડો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","તોવે તો ઈસુવાલ એરાહાટી આગલા દાંહાદી ગીયો ને તો યોક ઉંબા જાડાવોય ચોડી ગીયો, કાહાકા ઈસુ ચ્યેજ વાટે જાનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","જોવે ઈસુ ચ્યા જાડા હી પોઅચ્યો, જાં જાખી આતો, તોવે ચ્યાય ઉચે નોજાર કોઇન ચ્યાલ આખ્યાં, “ઓ જાખી, તું માહારી નિચે ઉતી યે; કાહાકા માન આજે તો ગોઓ યેઅના જરુરી હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","જાખી તારાતુજ ઉત્યો તો ઈસુલ ગોઓ લેય ગીયો, એને બોજ આનંદાકોય ચ્યા આદર કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ઈ દેખીન બોદાજ લોક ટુટરાં લાગ્યા, એને ચ્યા આખે કા, “તો તે યોક પાપી માઅહા ગોઓ ગીયહો.” ");
INSERT INTO gbl_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","જોવે ચ્યા ખાં બોઠલા આતા તોવે જાખી ઉબા રોઇન પ્રભુ ઈસુવાલ આખ્યાં, “ઓ પ્રભુ, એએ, મા આરદી મિલકાત ગોરગોરીબાહાલ દેય દાહું, એને માયે કાદા પાયને બી ખોટયેરીતે કર લેદા ઓરીતે ચ્યાલ ચાર ગોણા પાછો દિહી.” ");
INSERT INTO gbl_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","તોવે ઈસુવે ચ્યાલ આખ્યાં, “આજે યા ગોઆ લોકહા તારણ જાયહાં, યાહાટી કા ઓ બી આબ્રાહામા યોક પીડી માઅને હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","“કાહાકા આંય, માઅહા પોહો ટાકાય ગીઅલાહાન હોદાહાટી એને ચ્ચાહા બોચાવ કોઅરા યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","જોવે લોક ઈ વોનાય રીઅલા આતા, તોવે ઈસુય ચ્યા વાત આખના ચાલુ રાખી એને ચ્યાય યોક દાખલો આખ્યો, યાહાટી આમી તો યેરૂસાલેમ શેહેર પાહીજ આતો, એને લોક હુમાજતા આતા કા આમી પોરમેહેરા રાજ્ય સુરુ ઓઅનારા હેય. ");
INSERT INTO gbl_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ઈસુવે આખ્યાં, “યોક માલદાર માઅહું દુર દેશામાય જાતા રોહે યાહાટી કા તીં તાઅને રાજપદ મીળવીન પાછા ફિરી યેય.” ");
INSERT INTO gbl_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ચ્યાય ચ્યા ચાકારાહામાઅને દોહો જાંઆહાન હાદિન દોહો સિક્કા દેના એને આખ્યાં, કા મા પાછા ફિરી યેયના તાંવ તુમા લેન દેન કોઅજા. ");
INSERT INTO gbl_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","“બાકી ચ્યા ગાવામાય રોનારા ચ્યાઆરે વિરુદ કોઅતા આતા, એને ચ્યાપાય ચ્યાહાય નિરોપ્યા દોવાડીન આખી દેના કા, આમહાન ઈ નાંય જોજે કા તો યી એને આમહાવોય રાજ કોએ.” ");
INSERT INTO gbl_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","“જોવે તો રાજપદ મીળવીન પાછો યેનો, તોવે એહેકોય જાયા કા ચ્યે ચ્યા ચાકારાહાન જ્યાહાલ ચ્યાય સિક્કા દેનલા, ચ્યા સિક્કહાથી ચ્યાહાય કાય લેન-દેન કોઅયા એને યાહાય કાય કામાવ્યા ચ્યા ઇસાબ લાંહાટી હાદ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","તોવે પેલ્લે યેયન આખ્યાં, ઓ માલિક, ‘તો દેનલા સિક્કાકોય માયે બિજા દોહો સિક્કા કામાવ્યાહા.’ ");
INSERT INTO gbl_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","તોવે ચ્યે ચ્યાલ આખ્યાં, ધન્ય ઓ બોજ હારો ચાકાર તું બોજ થોડામાય ઈમાનદાર નિંગ્યો ચ્યાહાટી તું દોહો શેહેરાહા ઓદિકાર ચાલાડ. ");
INSERT INTO gbl_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","બીજાય યેયન આખ્યાં, ઓ માલિક, તો દેનલા સિક્કાકોય માયે બિજા પાચ સિક્કા કામાવ્યાહા. ");
INSERT INTO gbl_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","તોવે ચ્યે ચ્યાલબી આખ્યાં કા, તુંબી પાચ શેહેરાહાવોય ઓદિકાર ચાલાડ. ");
INSERT INTO gbl_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","તીજાંય યેયન આખ્યાં, ‘ઓ માલિક, એએ તો ઈ હેય, જ્યાલ માયે ફાડકામાય બાંદી થોવ્યેલ. ");
INSERT INTO gbl_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","કાહાકા આંય તોઅથી બિઅતો આતો, યાહાટી કા તું બોજ કોડાક માઅહું હેય; જીં તુયે નાંય થોવ્યહા તી તું ઇસી લેતહો એને જીં તુયે નાંય પોઅયાહાં, ચ્યાલ વાડતોહો.’ ");
INSERT INTO gbl_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","માલિકાય ચ્યાલ આખ્યાં, ઓ નોકામ્યા ચાકાર, આંય તોજ વાતેકોય તુલ દોષી ઠોરાવતાહાવ, તું માન જાંઅતો આતો કા આંય કોડાક માઅહું હેય, જાં માયે નાંય થોવ્યેલ તાંઅરે આંય લાહુ એને માયે નાંય પોઅયા ચ્યાલ આંય વાડતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","તે તું મા દેનલા રૂપિયા સાવકારાપાય કાહાનાય થોવી દેનેલ, થોવલા રોતા તે આંય યેયન ચ્યાહા પાયને વિયાજ હાતે લેય લેતો. ");
INSERT INTO gbl_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","એને જ્યા લોક પાહાય ઉબલા આતા, ચ્યાહાન ચ્યાય આખ્યાં, તો સિક્કો ચ્યા પાયને લેય લીયા, એને જ્યાપાંય દોહો સિક્કા હેય ચ્યાલ દેય દિયા. ");
INSERT INTO gbl_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ચ્યાહાય આખ્યાં, ‘ઓ માલિક ચ્યાપાય દોહો સિક્કા તે હેતાજ.’ ");
INSERT INTO gbl_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","‘આંય તુમહાન આખતાહાવ કા જ્યા પાય હોમાજ હેય, તો વોદારી હોમાજ મેળવી, બાકી જ્યાપાંય જીં વોછીબી હોમાજ ઓરી તીં બી ચ્યાપાઅને ખોવાય જાય. ");
INSERT INTO gbl_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","બાકી મા જ્યા વિરુદ કોઅનારા જ્યાહાન નાંય ગોમ્યા કા આંય ચ્યાહાવોય રાજ્ય કોઉ, ચ્યાહાન મા આગલા લેય યા એને માઆઇ ટાકાં.’” ");
INSERT INTO gbl_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","યો વાતો પુર્યો કોઇન ઈસુ યેરૂસાલેમ શેહેરા એછે શિષ્યહા આગલા-આગલા ચાલ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","જેહેકોય ઈસુ એને ચ્યા શિષ્ય યેરૂસાલેમ શેહેરા પાહી યેના, તોવે ચ્યા બેતફાગે એને બેથાનીયા શેહેરાહા બાઆને ગાવહામાય પોઅચ્યા, યે ગાંવે જૈતુન ડોગાપાંહી આતેં, તોવે ઈસુય ચ્યા શિષ્યહામાયરે બેન શિષ્યહાન એહેકોય આખીન ચ્યા આગલા દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“હામેના ગાવામાય જાં, એને તાં જાતાંજ તુમહાન યોક ફુરક્યા વાછડા હેય ચ્યાવોય આજુ લોગુ કાદોજ નાંય બોઠહો, તીં બાંદલા નોજરે પોડી, ચ્યાલ છોડીન માયેપાંય લેય યા. ");
INSERT INTO gbl_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","જો કાદાં તુમહાન પુછે, ઈ કાય કોઅતાહા, તોવે એહેકોય આખજા,? ઈસુ આમે પ્રભુલ યા ઉપયોગ કોઅના ગોરાજ હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","શિષ્ય ગાવામાય ગીયા, ચ્યાહાય જાયને જેહેકેન ચ્યાય ચ્યાહાન આખલા આતા, તેહેકેન દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","એને ચ્યા ફુરક્યા વાછડાલ છોડા લાગ્યા. તો ચ્યા માલિકાય ચ્યાહાન પુછ્યાં, “ઈ તુમા કાય કોઅતાહા, એલા ફુરક્યા વાસડાંલ કાહા છોડતાહા?” ");
INSERT INTO gbl_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","શિષ્યહાય ઈસુ આખલ્યે પરમાણેજ જાવાબ દેનો; પ્રભુલ યા જરૂરત હેય. ");
INSERT INTO gbl_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","એને ચ્યા બેન શિષ્ય ફુરક્યા વાછડાલ ઈસુપાય લેય યેના, એને ફુરક્યા વાછડા બોઅડા વોય પોતાને ફાડકે પાથ્યેં એને ઈસુ ચ્યાવોય બોહી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","જોવે તો જાવ આતો, તોવે ચ્યે પોતાના ફાડકે વાટેવોય પાથતે જાતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","જોવે ચ્યા યેરૂસાલેમ શેહેરા પાહાય યેના જીં વાટ જૈતુન ડોગા એછે જાતી આતી, તોવે બોદો શિષ્યહા ટોળો ચ્યા ચમત્કારા કામહા લેદે જ્યેં ચ્યાહાય દેખ્યેલ, ચ્યાહાટી તો ટોળો આનંદાકોય મોઠેથી પોરમેહેરા સ્તુતિ કોઅરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","એને આખા લાગ્યા કા, “ધન્ય હેય જો રાજા, જો પ્રભુ નાંવા કોય યેહે હોરગામાય શાંતી એને આકાશામાય ચ્યા મહિમા ઓએ.” ");
INSERT INTO gbl_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","તોવે ટોળામાઅને થોડહા પોરૂષી લોક ચ્યાલ આખા લાગ્યા, “ઓ ગુરુ, તો શિષ્યહાન ખિજવાય કા ચ્યા ઠાવકા રોય.” ");
INSERT INTO gbl_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ઈસુવે ચ્યાહાન જાવાબ દેનો, “આંય તુમહાન આખહુ, જો યા લોક ઠાવકા રોય જાય તે દોગડા બોમલી ઉઠી.” ");
INSERT INTO gbl_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","જોવે તો યેરૂસાલેમ શેહેરા જાગે યેનો તોવે ચ્યા શેહેરાલ દેખીન ચ્યાહાટી રોડયો ");
INSERT INTO gbl_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","એને આખ્યાં, “કોલાં હારાં ઓઅતા કા તું હાં તુંજ યા દિહામાય શાંતી વાતો જાઅતા બાકી આમી તી બોદા તો નોજરેથી દોબી ગીયહા.” ");
INSERT INTO gbl_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","કાહાકા ચ્યા દિહી તોવોય યી કા તો દુશ્માન મોર્ચા બાંદિન તુલ ગેરી લી, એને ચોમખીને તુલ દાબી. ");
INSERT INTO gbl_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","એને તો વિરુદી તુલ પુરાં નાશ કોઇ દી, એને યોકબી દોગાડ પોતે જાગાવોય નાંય છોડી, ચ્યા બોદા નાશ કોઇ દી; કાહાકા તુયે ચ્યા સોમયાલ નાંય જાંઅયા કા તોવોય જીં દયા કોઅવામાય યેનેલ. ");
INSERT INTO gbl_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","તોવે ઈસુ દેવાળામાય જાયને વેચનારાહાલ બારે કાડા લાગ્યો, ");
INSERT INTO gbl_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ચ્યાહાન ઈસુવે એહેકોય આખ્યાં કા, “કાય પવિત્રશાસ્ત્ર ઈ નાંય આખે, કા મા દેવાળાલ બોદા જાતી લોકહાહાટી પ્રાર્થના ગુઉ આખલા જાય? બાકી તુમહાય તીં બાંડાહા ગુઉ બોનાવી રાખ્યહાં.” ");
INSERT INTO gbl_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","એને ઈસુ દિનેરોજ દેવાળામાય હિકાડતો આતો, મુખ્ય યાજક એને મૂસા નિયમ હિકાડનારા ગુરુ એને યહૂદી આગેવાન ચ્યાલ માઆઇ ટાકાં યુક્તિ કોઅતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","બાકી ચ્યા કાયજ કોઇ હોક્યા નાંય કા ઈ કેહેકેન કોઅજે, કાહાકા બોદા લોક બોજ ધ્યાનથી ચ્યા વોનાતા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ઈસુ એને ચ્યા શિષ્ય પાછા યેરૂસાલેમ યેય પોઅચ્યા, એને જોવે તો દેવાળામાય હિકાડતો આતો એને પોરમેહેરા હારી ખોબાર આખતો આતો, તોવે મુખ્ય યાજક, મૂસા નિયમ હિકાડનારા ગુરુ એને આગેવાન ચ્યા ચ્યાપાય યેના. ");
INSERT INTO gbl_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","એને પુછા લાગ્યા, “તુલ યેં કામે કોઆહાટી તોપાય કાય ઓદિકાર હેય? કુંયે તુલ ઓહડા ઓદિકારાહાતે દોવાડયોહો?” ");
INSERT INTO gbl_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","તોવે ઈસુય ચ્યાહાન સાવાલ પુછીન જવાબ દેનો, “આંયબી તુમહાન યોક સાવાલ પૂછતાહાવ; ચ્યા તુમા માન જાવાબ દા. ");
INSERT INTO gbl_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","જોવે યોહાનાય લોકહાન બાપતિસ્મા દેના, તે કાય ચ્યા ઓદિકાર હોરગામાઅને પોરમેહેરાપાઅને કા માઅહા પાઅને?” ");
INSERT INTO gbl_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","તોવે ચ્યા ચ્યાહામાય વિચાર કોઆ લાગ્યા, કા હોરગામાઅને આખહુ તોવે, તો આમહાન આખરી કા, તોવે તુમહાય ચ્યાવોય કાહાનાય બોરહો થોવ્યો? ");
INSERT INTO gbl_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","એને જોવે આમા માઅહા પાઅને આખહુ તોવે કાય ઓઈ? લોક આપહાન દોગડાકોયન ઠોકી, કાહાકા લોક ઈ માનતા આતા કા, યોહાન બાપતિસ્મા દેનારો પોરમેહેરા પાયને યોક હાચ્ચો ભવિષ્યવક્તા આતો. ");
INSERT INTO gbl_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","એને ચ્યાહાય ઈસુવાલ જાવાબ દેનો કા, “આમા નાંય જાંઆજે કા યોહાન બાપતિસ્મા દેનારાલ લોકહાન બાપતિસ્મા દાંહાટી કુંયે દોવાડલો.” ");
INSERT INTO gbl_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","તોવે ઈસુય ચ્યાહાન આખ્યાં, તે “આંયબી તુમહાન નાંય જાવાબ દાંઉ કા, ઈ કામ આંય કોઅહા ઓદિકારાકોય કોઅહુ.” ");
INSERT INTO gbl_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","પાછો, ઈસુ બિજા દાખલા દેયન યહૂદીયાહા આગેવાનાહાઆરે વાત કોઆ સુરુ કોઅયા, “યોક માઅહાય ચ્યા રાનામાય દારાખા વાડી લાવી, પાછે ચ્યાય ચ્યા રાનાલ કોલહાક ખેડુતાહાન બાગે દેય દેના એને બિજા દેશા એછે બોજ દિહયા હાટી લાંબ પારદેશ નિંગી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","જોવે દારાખેં પાકના સમય યેનો, તે ચ્યા ચાકારાહામાઅને યોકાલ બાગે ખેડુતાપાય દોવાડયો, કા ચ્યાલ દારાખાહા વાડીયેમાઆને દારાખાહા કોલહાક ભાગ દેય. બાકી ખેડુતાહાય ચ્યાલ દોઇન માર દેનો, એને ચ્યાલ કાયજ નાંય દેના એને પાછો દોવાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","પાછો વાડયે માલિકાય યોકબીજા ચાકરાલ ખેડુતાહાપાય દોવાડયો; એને ચ્યાહાય ચ્યાલબી માર ઠોક્યો એને ચ્યાઆરે જુઠા કોઅયા એને ખાલી આથે દોવાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","પાછા ચ્યાય તીજાલ દોવાડયો એને ચ્યાહાય ચ્યાલબી માર ઠોકીન એને ઘાયાલ કોઇન દોવાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","તોવે દારાખાહા વાડી માલિકાય આખ્યાં, ‘આંય કાય કોઉ? આંય મા પાહાલ દોવાડીહી કાહાકા, ચ્યે એહેકોય જાંઅયા કા, મા પોહા ચ્યા દાક રાખી.’ ");
INSERT INTO gbl_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","જોવે ખેડુતાહાય ચ્યા પાહાલ યેતા દેખ્યા, તે ચ્યા ચ્યાહામાય વિચાર કોઅતા લાગ્યા, ‘ઓ તે વારસદાર હેય; ચાલા, એલાલ આપા માઆઇ ટાકતા, તોવે વારસો આપહે ઓઅઇ જાઅરી.’ ");
INSERT INTO gbl_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","એને ખેડુતાહાય ચ્યા પોહાલ દોઇન, વાડયે બાઆ કાડીન માઆઇ ટાક્યો. ચ્યાહાટી દારાખાહા વાડયે માલિક કાય કોઅરી? ");
INSERT INTO gbl_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","તો યેયન ચ્યા ખેડુતાહાન માઆઇ ટાકી એને દારાખાહા વાડી બીજહાન દેય દી” ઈ વોનાઈન ચ્યાહાય આખ્યાં, “પોરમેહેર એહેકોય નાંય કોઅરા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ઈસુવે ચ્યાહા એછે એઇન, “પાછા ઈ કાય લોખલાં હેય: જ્યા દોગડાલ બાંદનારા કોડયાહાય નોકામ્યો ઠોરાવ્યેલ તોજ ખૂણામાઅનો મુખ્ય જાયો?” ");
INSERT INTO gbl_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","“જીં કાદાં માઅહું યા દોગડા ઉપે પોડી, ચ્યા ટુકડા-ટુકડા ઓઅઇ જાય; બાકી જ્યા ઉપે ઓ દોગાડ પોડી, ચ્યાલ તો બુપટા બોનાડી દી.” ");
INSERT INTO gbl_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","ચ્યેજ ગેડીયે મૂસા નિયમ હિકાડનારા ગુરુ એને મુખ્ય યાજક ચ્યાલ દોઈ દાં માગેત, કાહાકા ચ્યા હુમજી ગીઅલા કા ચ્યાય આમેહાટી ઓ દાખલો દેનો, બાકી ચ્યાહાન લોકહા બિક આતી. ");
INSERT INTO gbl_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","એને ચ્યા ઈસુવા બુલ હોદાહાટી ચ્ચા પાછલા પોડ્યા યાહાટી ચ્ચાપાય બેદયા દોવાડયા યાહાટી કા ન્યાયી હારકો રુપ લેયને ઈસુવા કોઅહીબી વાતોમાય ફસવીન ચ્યાલ રાજ્યપાલા આથામાય હોઅપી દેય. ");
INSERT INTO gbl_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ચ્યાહાય ચ્યાલ ઈ પુછ્યાં, “ઓ ગુરુ, આમા જાંઅજેહે કા, તું સાદા ઠીક આખતોહો, એને પોરમેહેરા વાટ હાચ્ચાયે પરમાણે હિકાડતો બી હેય, એને કાદા પક્ષપાત નાંય કોઆ, બાકી પોરમેહેરા વાત હાચ્ચાયેકોય આખતો હેય, તે પાછે આમી આમહાન આખ. ");
INSERT INTO gbl_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","કાય કૈસરાલ કર દેઅના આમે નિયમા વિરુદ હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ચ્યાય ચ્યાહા લુચ્ચાઈ જાઇન ચ્યાહાન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“યોક દીનાર માન દા, ચ્યા ઉપે કા છાપ એને નાંવ હેય?” ચ્યાહાય આખ્યાં, “કૈસરા.” ");
INSERT INTO gbl_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ઈસુય ચ્યાહાન આખ્યાં, “તે જીં કૈસરા હેય, તી કૈસરાલ દા; એને જીં પોરમેહેરા હેય તીં પોરમેહેરાલ દા.” ");
INSERT INTO gbl_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ચ્યા લોકહા આગલા, યે વાતમાય ચ્યાલ દોઈ નાંય હોક્યા બાકી ચ્યે વાતે જાવાબ વોનાયને ચ્યા નોવાય પામીન ઠાવકા રોય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","તોવે સાદૂકી ટોળામાઅને કોલહાક લોક જ્યા ઈ આખતાહા કા મોઅલા માઅને પાછા જીવતા નાંય ઓઈ હોકેત ઈસુવાપાય યેયન પુછ્યાં, ");
INSERT INTO gbl_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ઓ ગુરુ, મૂસાય શાસ્ત્રામાય આમહે કોરે યોક નિયમ લોખલો હેય, જોવે યોકતા વોરાડ ઓઅલો માટડો મોઓઈ જાય, એને તો વોગાર પાહાહા થેઅયેલ છોડી જાહે, તોવે ચ્યા માટડા બાહા વિધવા થેઅયેઆરે વોરાડ કોઇ લા જોજે, એને યોક પોહા પૈદા કોઅરા જોજે, જો ચ્યા બાહા વારસદાર બોને. ");
INSERT INTO gbl_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","હાંત બાહા આતા, બોદહા મોઠા બાહાય વોરાડ કોય લેદા બાકી વોગાર પાહાહા તો મોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","પાછે બીજે, ");
INSERT INTO gbl_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","એને તીજ વાત તીજા બાહા આરે જાઈ. એને બોદા હાંતી બાહાહા આરે જાઈ, ચ્યે થેઅયેય ચ્યાહામાઅને કાદાહાટીબી યોક પાહાહાન જન્મો નાંય દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","છેલ્લે, તી થેએબી મોઓઈ ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","એને આમી આમહાન આખ, આમી યે થેએયે વોરાડ હાંત માટડાઆરે ઓઅયા, તે જોવે મોઅલા માઅને પાછા જીવી ઉઠી, તોવે તી કા થેએ રોય? કાહાકા તી હાંતહ્યા થેએ આતી.” ");
INSERT INTO gbl_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ઈસુવે ચ્યાહાન આખ્યાં, “યા કાળામાય પાહાહામાય વોરાડ ઓઅહે એને વોરાડ કોઇ દેતહેં, ");
INSERT INTO gbl_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","બાકી જીં કાદાં યા લાયકે ઓરી કા ચ્યા યુગા એને મોઅલા માઅને પાછા જીવતા ઓઅના મેળવી, ચ્યે નાંય વોરાડ કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","ચ્યે પાછે મોઅનારે બી નાંય, બાકી હોરગામાય રોનારા હોરગા દૂતહા હારકે રોય. એને મોઅલા માઅને પાછા જીવતા ઓઅવાથી પોરમેહેરા પોહેં બી બોની. ");
INSERT INTO gbl_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","બાકી યે વાતે બારામાય કા મોઅલે જીવતે ઓઅતેહે, મૂસાય બી જાડા કાહાની માય ખુલ્લાં કોઅયા કા તો પ્રભુલ આબ્રાહામા પોરમેહેર, એને ઈસાકા પોરમેહેર, એને યાકૂબા પોરમેહેર આખહે. ");
INSERT INTO gbl_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","પોરમેહેર મોઅલાહા નાંય બાકી જીવતાહા તો પોરમેહેર હેય કાહાકા ચ્યા પાહી બોદેજ જીવતે હેતેં.” ");
INSERT INTO gbl_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","તોવે ઈ વોનાયને મૂસા નિયમ હિકાડનારા ગુરુહુ માઅને કુંયે તેરુ ઈ આખ્યાં, “ઓ ગુરુ, તુયે હારાં આખ્યાં.” ");
INSERT INTO gbl_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","એને પાછે ચ્યાહાન સાવાલ પૂછના કાદા ઈંમાત નાંય ચાલી. ");
INSERT INTO gbl_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","પાછે ઈસુય ચ્યાહાન પુછ્યાં, “ખ્રિસ્તાલ દાઉદ રાજા પોહો કેહેકેન આખતેહે?” ");
INSERT INTO gbl_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","દાઉદ રાજા પોતે ગીતહા ચોપડયેમાય આખતો હેય: ");
INSERT INTO gbl_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","પ્રભુ પોરમેહેરાય મા પ્રભુવાલ આખ્યાં, “તું મા જમણે આથે બોહો, જાવ લોગુ આંય તો દુશ્માનાહાલ આરવી નાંય દાંઉ તાંઉલોગુ.” ");
INSERT INTO gbl_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","દાઉદ રાજા પોતેજ ચ્યાલ પ્રભુ આખહે, પાછે તો ચ્યા પોહો કેહેકેન ઓઅહે? ");
INSERT INTO gbl_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","જોવે બોદા લોક વોનાય રીઅલા આતા, તે ચ્યાય ચ્યા શિષ્યહાન આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“મૂસા નિયમ હિકાડનારા ગુરુપાયને હાચવીન રા, જ્યા યે વાતેલ પોસાન કોઅતાહા કા સાર્વજનિક ઠિકાણા વોય લોક ચ્યાહાન લાંબા એને મોઅગેં ડોગલેં પોવીન ફીઅતા દેખે, એને આટામાય લોક ચ્યાહાન માનેપાને કોય સલામી કોએ. એને સોબાયે ઠિકાણામાય માનાપાના જાગાવોય બોહના પોસંદ કોઅતાહા, એને જેવણામાય માનાપાના જાગો ચ્યાહાન ગોમહે. ");
INSERT INTO gbl_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ચ્યા વિઘવા બાઈહે ગોએ લુટી લેતાહા, એને દેખાડાહાટી લાંબી વાઆ પ્રાર્થના કોઅતાહા, પોરમેહેર નોક્કીજ ચ્યાહાન કોઠાણ સાજા દી.” ");
INSERT INTO gbl_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ઈસુ દેવાળા દાનપેટી હામ્મે બોહીન એએયા કોએ, કા ધનવાન લોક દેવાળા દાનપેટીમાય કેહેકેન પોયહા ટાકતાહા. ");
INSERT INTO gbl_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","એને ચ્યેજ સમયે યોક ગોરીબ વિધવા બાઈ યેયન બેન દોમડયો, જ્યો બેન સિક્કા હેય, બેન વાહના તાંબા સિક્કો ટાકતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","એને આંય, “તુમહાન હાચ્ચી વાત આખતાહાવ કા દેવાળા દાનપેટીમાય પોયહા ટાકનારાહા માઅને ચ્યે ગોરીબ વિધવા બાઈ બિજા બોદહા કોઅતા વોદારે દાન ટાક્યા. ");
INSERT INTO gbl_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","જ્યા મિલકાતવાળા હેય ચ્યાહાય કેવળ ચ્યામાઅને દેનલા હેય, જ્યાલ ચ્યાહાન જરુરી નાંય આતા, બાકી ઈ વિધવા ગોરીબ હેય એને યેય જીં બોદા કાય દેના જીં ચ્યેપાય આતા, ચ્યા બોદા પોયહા ટાકી દેના જ્યાહાલ તી પોતે જરુરી વસ્તુ લાંહાટી ઉપયોગ કોઇ હોકતી.” ");
INSERT INTO gbl_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","કોલહાક લોક દેવાળા બારામાય વાત કોઇ રીઅલા આતા, કા કોલાં હારાં દોગાડાકોય એને બેટે હારી વસ્તુ કોઇન સોબા કોઅલી હેય. ");
INSERT INTO gbl_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","તોવે ઈસુવે આખ્યાં, “ઓહડા દિહી યી, જ્યામાય તુમા ઈ બોદા એઅતાહા, ચ્યાહામાઅને ઈહીં યોકબી દોગાડ પોતે જાગાવોય નાંય છોડી, ચ્યા બોદા નાશ કોઇ દી.” ");
INSERT INTO gbl_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","તોવે ચ્યાહાય ચ્યાલ પુછ્યાં કા “ગુરુજી, ઈ કોદહી બોની? એને ઈ બોદા બોનતાં લાગે ચ્યા કાય ચિન્હ હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ઈસુવે ચ્યાહાન આખ્યાં, “હાચવીન રોજા કા તુમહાન કાદો નાંય છેતરે. બોજ લોક મા નાંવા કોઇન યી, ચ્યે આખી, આંય ખ્રિસ્ત હેતાઉ, યાહાટી, ‘સમય પાહે યેય ગીયહો’ ચ્યાહા પાહલા તુમા મા ચાલી જાતે. ");
INSERT INTO gbl_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","બાકી જોવે તુમા લોડાઈ, એને લોડાયેહે વાતો કોઅતા વોનાયાહા, તોવે મા ગાબરાયાહા; કાહાકા ઈ ઓઅનારાંજ હેય, બાકી દુનિયા છેવાટ તારાત નાંય ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","એને પાછે આખ્યાં, “બિજ્યે જાત્યેવોય જાત એને યોકા દેશા લોક બિજા દેશાઆરે લોડી. ");
INSERT INTO gbl_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","મોઠા-મોઠા દોરતીકંપ ઓઅરી, જાગે-જાગે દુકાળ એને માહામારી યી, એને આકાશામાય ભયંકર વાતો એને મોઠે-મોઠે ચિન્હ ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ઈ બોદા ઓઅતા લાગી ચ્યા પેલ્લા, તુમા મા શિષ્ય હેય યાહાટી ચ્યા તુમહાન દોઇન આબદામાય પાડતા લાગી, ચ્યા સોબાયે ઠિકાણે તુમહે વિરુદ કોઅરી, તુમહાન કોચર્યેમાય ટાકી, એને તુમહાન મા લીદે સરકારા, એને રાજહા આગલા ઉબા કોઅરી કા તુમહે ન્યાય કોએ. બાકી ચ્યા પરિણામ, તુમા ચ્યાહાન મા બારામાય હારી ખોબાર આખી હોકહા. ");
INSERT INTO gbl_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","તોદિહી તુમહાન ખુશ ખોબાર વાત આખના તોક મિળી. ");
INSERT INTO gbl_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","એને ઈ વાત તુમા નોક્કી જાંઆઈ લીયા કા ચ્યાહાન કાય જાવાબ દેઅના ચ્યા ચિંતા નાંય કોઅના. ");
INSERT INTO gbl_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","કાહાકા આંય તુમહાન ઓહડી વાત એને ઓહડી ઓકાલ દિહી કા તુમહે દુશ્માન તુમહાન ચ્યા કાયબી સામનો નાંય કોઅય હોકી. ");
INSERT INTO gbl_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","તુમહે આયોહો આબહો, તુમહે બાહા, હોગવાડ્યે, એને હાંગાત્યા, યેજ તુમહાન દોઆડી દી એને ઓલે લોગુ કા કોલહાખાન લોકહાન માઆઇ બી ટાકાડી. ");
INSERT INTO gbl_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","કાહાકા તુમા મા શિષ્ય હેય યા લેદે, બોદે માઅહે તુમહેઆરે દુશ્માની કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","બાકી તુમહે ટોલપ્યે યોકબી કીહીં નાંય ટાકાય. ");
INSERT INTO gbl_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","જોવે તુમા ધીરજ રાખી રોહા, તોવેજ તુમહે જીવા બોચાવ ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","“જોવે તુમા યેરૂસાલેમ શેહેરાલ ચોમખીને સૈનિકા કોય ગેરલા એઆ, તોવે જાંઆઈ લીયા કા યેરૂસાલેમ શેહેરા ઉજાડ ઓઅઇ જાઅના સમય યી પોઅચ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","જ્યા લોક યહૂદીયા વિસ્તારામાય હેય ચ્યાહાન બોચાંહાટી ડોગહાવોય નાહી જાં પોડી. યેરૂસાલેમ શેહેરામાય હેય ચ્યા બાઆ નિંગી જાય, એને ગાવહામાય હેય ચ્યા પાછા ગાવામાય નાંય જાય. ");
INSERT INTO gbl_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","કાહાકા બોદલો લેઅના દિહી હેતા, તોદિહી જીં પવિત્રશાસ્ત્રમાય લોખલાં હેય, તી બોદા પુરાં ઓઅઇ જાય. ");
INSERT INTO gbl_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","જ્યો બાયો મોયનાવાળ્યો હેય, એને જ્યો બાયો પાહાહાન દુદ પાજી રિઅલ્યો હેય, ચ્યેહેલ નાહરાં બોજ કોઠાણ પોડી, કાહાકા દેશાવોય બોજ દુઃખ પોડી એને લોકહાન બોજ આબદા પોડી. ");
INSERT INTO gbl_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ચ્યાહાન તારવાયે કોઇન માઆઇ ટાકી દેઅરી, એને ચ્ચાહાન ગુલામ બોનાડીન બોદા દેશામાય લેય જાઅરી, એને જાવ લોગુ બિજ્યે જાત્યે સમય પુરો નાંય ઓઅરી, તાંવ લોગુ યેરૂસાલેમ શેહેર ગેર યહૂદીયા લોક યેયન રોય.” ");
INSERT INTO gbl_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","દિહી એને ચાંદ એને ચાંદાલાહામાય ચિન્હ દેખાયી, એને દોરતીવોય, બિજ્યે બોદયે જાત્યેમાય લોકહાન આબદા પોડી, કાહાકા ચ્યા દોરિયો ગોગુંરના લેદે એને લાફહા ઉઠના લેદે ગાબરાય જાય. ");
INSERT INTO gbl_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","એને ગાબરાય ગીઅલા લેદે એને દુનિયામાય ઓઅનારી ઘટના વાટ જોવતા-જોવતા લોકહામાય જીવના તાકાત નાંય રોય, કાહાકા આકાશામાઅને પરાક્રમ આલી જાય. ");
INSERT INTO gbl_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","તોવે લોક માન, માઅહા પોહાલ સામર્થ્ય એને મહિમાહાતે દોરતી એછે વાદળામાય યેતો દેખી. ");
INSERT INTO gbl_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ઈ યો વાતો ઓઅત્યો લાગે, તોવે તુમા હિદા ઓઇન તુમહે ટોલપી ઉચે કોઆ, કાહાકા તુમહે બોચાવ પાહી હેય. ");
INSERT INTO gbl_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","પાછે ઈસુવે ચ્યાહાન ઓ દાખલો આખ્યો, “અંજીરા જાડ એને બીજે બોદા જાડહાન એઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","જોવે ચ્યે પીલવાતે મોંડે તોવે તુમહાન ખોબાર પોડહે કા ચોમહા સમય યેય ગીયહો. ");
INSERT INTO gbl_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","તેહેંજ કોઇન, જોવે ઈ બોદા તુમહાન બોનતાં દેખાય, તોવે તુમહાન ખોબાર પોડી જાં જોજે કા પોરમેહેરા રાજ્ય પાહી યી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","આંય તુમહાન હાચ્ચાં આખતાહાવ, કા ઈ બોદા યે પેડયે લોક તોવેબી જીવતા રોય જોવે ઓહડા બોનાવ બોની. ");
INSERT INTO gbl_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","આકાશ એને દોરતી નાશ ઓઈ જાય, સાદામાટે નાંય રોય, બાકી માયે જીં આખ્યાહા તી સાદામાટે હાચ્ચાં રોય. ");
INSERT INTO gbl_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","યાહાટી હાચવીન રા, એહેકોય નાંય બોને કા તુમહે મોન હોદથી વદારે ખાઅના પિઅના એને સાકટ્યા, એને યા જીવના ચિંતાકોય દાબાય જાહા, એને તો ન્યાયા દિહી તુમહાવોય ફાંદા હારકો અચાનક યેય પોડી. ");
INSERT INTO gbl_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","કાહાકા તોદિહી બોદી દોરત્યેવોય રોનારા બોદહાવોય એહકોયજ યે પોડી. ");
INSERT INTO gbl_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","યાહાટી હાચવીન રોજા, એને ઓઅનારી ઘટનાપાઅને બોચાંહાટી બોજ પ્રાર્થના કોઅતા રોજા, એને આંય માઅહા પોહા હોમ્મે ઉબો રા હાટી પોરમેહેરા પાયરે ગોતી માગા.” ");
INSERT INTO gbl_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ઈસુ દિહાર્યો દેવાળામાય હિકાડતો આતો એને રાતી બાઆ નિંગીન જૈતુન નાંવ્યા ડોગાવોય રા આતો. ");
INSERT INTO gbl_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","એને હાકાળ્યે વેળે કોવાળ્યાં ઉઠીન બોજ લોક ચ્ચા વોનાયા હાટી દેવાળામાય ચ્ચાપાય યેતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","આમી પાસ્કા સણ જો બેખમીર બાખ્યે સણ આખાયેહે બેન દિહયા પાછે સુરુ ઓઅનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","મુખ્ય યાજક એને મૂસા નિયમ હિકાડનારા ગુરુ યે વાતે પાહલા પોડયેલ કા ઈસુવાલ કેહેકેન દોગો દેયન માઆઇ ટાકજે. ");
INSERT INTO gbl_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","એને બાર શિષ્યામાઅનો યોક યહૂદા નાંવા આતો, ચ્યાલ ઇસ્કારીયોતીયો આખે, ચ્યામાય સૈતાન ઉરાઇ ગીયો, ");
INSERT INTO gbl_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","એને તો મુખ્ય યાજકાહા એને દેવાળા રાખવાળ્યાહા આગેવાનહાપાય ગીયો એને આખ્યાં કા, આંય ઈસુવાલ દોઆડાહાટી તુમહાન મોદાત કોઅહી. ");
INSERT INTO gbl_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ચ્યા ઈ વાત વોનાઈન ખુશ ઓઈ ગીયા, એને ચ્યાલ પોયહા દાંહાટી વાયદો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","પાછે યહૂદા ઈસુવાલ ચ્યાહા આથામાય દોઆડી દેઅના મોકો હોદતો લાગ્યો, કા દંગો કોઅયા વોગાર ચ્યાહા આથામાય દોઆડી દેય. ");
INSERT INTO gbl_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","બેન દિહયા પાછે, પાસ્કા સણા પેલ્લે દિહે, જોવે ચ્યાહાય સણાહાટી ગેટા બલિદાન કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","તોવે ઈસુવે પિત્તરાલ એને યોહાનાલ એહેકોય આખીન દોવાડયા કા: “જાયને આપહે ખાઅનાહાટી પાસ્કા સણા તિયારી કોઆ.” ");
INSERT INTO gbl_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","“ચ્યાહાય પુછ્યાં, તું આમહાન કેછ દોવાડા માગતોહો, કા આમા પાસ્કા ખુશ્યે હાટી ખાઅના તિયાર કોઅજે કા આપા ખાજે?” ");
INSERT INTO gbl_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ઈસુવે ચ્યાહાન આખ્યાં, “એઆ, જોવે તુમા શેહેરામાય જાહા, તાં તુમહાન પાઅયા વેંડલા લેઈને જાતા યોક માઅહું મિળી; જ્યા ગોઆમાય તીં જાય તુમા ચ્યા પાછલા જાજા. ");
INSERT INTO gbl_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","એને ગોઆ માલિકાલ આખા, આમહાન પ્રભુવે તુલ આખા દોવાડયાહા, કા મા શિષ્યહાઆરે આંય પાસ્કા બાખે ખાઉં તી ખોલી કેછ હેય?” ");
INSERT INTO gbl_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","તોવે તો તુમહાન માળાંડયેવોય યોક મોઠી સોજાવીન તિયાર કોઅલી ખોલી દેખાડી દી, તાં તિયારી કોઆ. ");
INSERT INTO gbl_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","બેન શિષ્ય ચાલ પોડ્યા એને શેહેરામાય યેના, એને જેહે ઈસુવે ચ્યાહાન આખ્યેલ, તેહેંજ ચ્યાહાન એરા મિળ્યાં; એને તાં ચ્યાહાય પાસ્કા સણા ખાઅના તિયારી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","જોવે તો સમય યેનો, તોવે તો પ્રેષિતહાઆરે ખાં બોહી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","તોવે ઈસુવે શિષ્યહાન આખ્યાં, “માન મોઠી આશા આતી, કા આંય દુઃખ બોગવાં એને મોઅરા પેલ્લા, યા પાસ્કા સણા ખાઅના તુમહેઆરે ખાંવ. ");
INSERT INTO gbl_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","કાહાકા આંય તુમહાન આખતાહાવ, આમી પાછે આંય બિજો પાસ્કા ખાઅના નાંય ખાઉં, જાવ પોરમેહેરા રાજ્યમાય ઈ પુરાં ઓઅઇ જાય.” ");
INSERT INTO gbl_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","એને યોક વાટકીમાય દારાખા રોહો લેઈને, ચ્યેવોય પોરમેહેરા આભાર માનીન, ચ્યે આખ્યાં, “લા, તુમહેમાય ઓ દારાખા રોહો લીયા, ");
INSERT INTO gbl_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","આંય તુમહાન હાચ્ચાંજ આખતાહાવ કા, ચ્યા પાછે, આંય પોરમેહેરા રાજ્ય દિહી યા લોગુ પાછે કોવેજ દારાખા રોહો નાંય પિયું.” ");
INSERT INTO gbl_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","એને ચ્યે બાખે લેદી, એને આભાર માનીન મૂડી, એને શિષ્યહાન એહેકોય આખીન દેની, કા ઈ મા શરીર હેય, જીં તુમહેહાટી દેવાયી, મા યાદ હાટી ઈ કોઆ. ");
INSERT INTO gbl_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","પાછે ઈસુવે દારાખા રોહા પિયાલો લેદો; એને પોરમેહેરા આભાર માનીન તીં ચ્યા શિષ્યહાન દેના; એને ચ્યા બોદહાય ચ્યામાઅને પિદાં; એને ઈસુવે ચ્યાહાન આખ્યાં, “ઓ દારાખા રોહો મા લોય હેય, મા લોય ઘોણા લોકહા એહેરે બોલીદાના રુપામાય વોવાડલાં જાહે, ઓ ચ્યા વાયદા સાબિત કોઅરી જો પોરમેહેર પોતે લોકહાઆરે બોનાવી રિઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","એને એઅયા, માન દોગો દેનારા આથ મા આરે થાળીયેમાય હેય. ");
INSERT INTO gbl_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","આંય, માઅહા પોહો મોઅઇ જાહીં કાહાકા પવિત્રશાસ્ત્રમાય લોખલાં હેય, બાકી ચ્યા માઅહાલ બોજ કોઠાણ શિક્ષા ઓરી જો માન દોઈદાંહાટી મોદાત કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","તોવે ચ્યા યોક બીજહા આરે વાતો કોઅરા લાગ્યા કા “આમહે માઅને કું હેય, જો ઈ કામ કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","એને શિષ્યહામાય બોલા-બોલી જાયી કા, ચ્યાહામાય કું મોઠો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","તોવે ઈસુવે શિષ્યહાન આખ્યાં, જ્યા લોક યા દુનિયામાય જ્યા ઓદિકારી ગોણાતાહા, ચ્યે ચ્યાહા ઓદિકારા ઉપયોગ ચ્યાહા તાબામાઅને લોકહાઉપે ઓદિકાર ચાલાડાહાટી કોઅતાહા, ચ્યા ચ્યાહા ઉપકારી આખાડતાહા. ");
INSERT INTO gbl_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","બાકી તુમહાય ઓહડા નાંય ઓઅના, બાકી તુમહેમાય જો કાદો મોઠા હેય, તો પોતે વાહનો બોને એને જો ઓદિકારી ઓરી તો સેવા કોઅનારો સેવકા હારકો બોના. ");
INSERT INTO gbl_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","કાહાકા કું મોઠો ગોણાય, ખાં બોઠો તો, કા ચ્યા ચાકરી કોઅનારો તો? ખાં બોઠો તો મોઠો, નાંય કા? બાકી આંય તુમહે વોચમાય ચાકરી કોઅનારા હારખો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","બાકી તુમા મા દુઃખામાય સાદા આરે રિયા. ");
INSERT INTO gbl_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","જેહેકોય મા હોરગ્યા આબહે માંહાટી યોક રાજ્ય ઠોરવ્યાહાં, તેહેકોય આંયબી તુમહેહાટી ઠોરાવતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","એને તુમા મા આરે મા રાજ્યમાય ખાહા એને પીયહા, બાકી સિંહાસનાવોય બોહીન ઈસરાયેલા બાર કુળહા ન્યાય કોઅહા. ");
INSERT INTO gbl_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“સિમોન, સિમોન, એએ, સૈતાને પોરમેહેરા પાયને તુમહે લોકહા પરીક્ષા કોઅરાહાટી પરવાનગી માગહી, હારાલ ખારાબા પાયને ઓલાગ કોઅરાહાટી, જેહેકોય ખેડુત ગોંવહાન ભૂસાપાયને ઓલાગ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","બાકી માયે તોહાટી પ્રાર્થના કોઅયી, કા તું માયેવોય બોરહો કોઅના બંદ નાંય કોઆ, એને પાછો પોસ્તાવો કોઇન તોવે તો બાહહાન તું માયેવોય બોરહો કોઅરા મજબુત કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","બાકી ચ્યે ચ્યાલ આખ્યાં, “પ્રભુ, તોઆરે આંય જેલેમાય જાં બી એને મોરાં બી તિયારી હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","બાકી ઈસુવે આખ્યાં, “પિત્તર, તુલ આંય આખતાહાવ આજે રાતી કુકાડ વાહાય ચ્યા પેલ્લા, તીનદા તું એહેકોય આખહે, ચ્યાલ આંય નાંય વોળખું.” ");
INSERT INTO gbl_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ઈસુવે ચ્યાહાન આખ્યાં, “જોવે માયે તુમહાન પોયહા વોગાર, ઠેલી એને ખાઅડાહા વોગાર દોવાડયા, તોદિહી તુમહાન કાય ઓછા પોડ્યા કા?” ચ્યાહાય જાવાબ દેનો, “નાંય,” ");
INSERT INTO gbl_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","તોવે ચ્યે ચ્યાહાન આખ્યાં, “બાકી આમી લોક આપહે વિરુદ હેય, યાહાટી જ્યા પાય પોયહા પાકીટ ઓરી તી તો લેય એને ઠેલી બી એને જ્યા પાય તારવાય નાંય મીળે તો ચ્યા ડોગલેં વેચિન યોક તારવાય વેચાતાં લેય. ");
INSERT INTO gbl_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","કાહાકા આંય તુમહાન આખતાહાવ કા એહેકોય પવિત્રશાસ્ત્રમાય લોખલાં હેય, તો ગુનેગારીયાહામાંય સામીલ ઓઅરી, ઈ વાત મા બારામાય પુરી ઓરા જોજે, એને હાચ્ચાંજ ઈ વાત મા બારામાય પુરી ઓઈ રિઅલી હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ચ્યાહાય ચ્યાલ આખ્યાં, “પ્રભુ, એએ, ઈહીં બેન તારવાયો હેત્યો” ઈસુવે ચ્યાહાન આખ્યાં, “બોજ હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","તોવે તો ઉઠીન ચ્યા પુરામાણે જૈતુન ડોગાવોય ગીયો, એને ચ્યા શિષ્ય ચ્યાઆરે ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","તોવે ચ્યા જાગાવોય જાય પોઅચ્યા પાછે ઈસુવે શિષ્યહાન આખ્યાં, પ્રાર્થના કોઅતા રા કા, તુમા બોદા પરીક્ષામાય નાંય પોડે. ");
INSERT INTO gbl_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","એને ચ્યાહા પાહને વાહાયોક દુર જાયને, તો માંડયે પોડીન પ્રાર્થના કોઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“જો તો યોજનામાય શક્ય ઓરી, તે માન યા દુઃખામાઅને બોચાડ, જીં માયેવોય યેનારાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","તોવે આકાશામાઅને હોરગા યોક દૂત ચ્યાલ દેખાયો એને ઈસુલ સામર્થ્ય દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","એને તો બોજ આબદામાય એને નિરાશ આતો એને દુઃખામાય રોયન બોજ પ્રાર્થના કોઇ રિઅલો આતો, એને ચ્યા ગોદારો લોયા મોઠા-મોઠા ટીપકા હારકો દોરતીવોય ગોળે. ");
INSERT INTO gbl_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","પાછે પ્રાર્થના માઅને ઉઠીન તો શિષ્યહાપાય ગીયો, તોવે ચ્યા નિરાશા લેદે હુતલા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ઈસુવે ચ્યાહાન આખ્યાં, “કાહા તુમા હુતલા હેય? ઉઠા, એને પ્રાર્થના કોઅતા રા કા, તુમા બોદા પરીક્ષામાય નાંય પોડે.” ");
INSERT INTO gbl_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","જોવે ઈસુ ઈ આજુ બોલહેજ ઓલહામાયજ, યહૂદા ઇસ્કારીયોત જો બાર શિષ્યહામાયનો યોક જાંઆ આતો ચ્યાહા આગલા-આગલા યી રિઅલો આતો, તો ઈસુ પાહે યેનો, કા ઈસુવાલ ગુળા દેય. ");
INSERT INTO gbl_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","તોવે ઈસુવે ચ્યાલ આખ્યાં, “યહૂદા, ગુળા દેયન તું માન, માઅહા પોહાલ દોય દેહે કા?” ");
INSERT INTO gbl_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","જોવે ચ્યા હાંગાત્યાહાય ઈ ઓઅતા દેખ્યા ચ્યાહાય પુછ્યાં, “પ્રભુ, તારવાયે કોઇન ઠોકજે કા?” ");
INSERT INTO gbl_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","એને ચ્યાહા માઅના યોક જાંઆય મહાયાજકા ચાકારાલ ઠોક્યો એને ચ્યા જમણો કાન કાપી ટાક્યો. ");
INSERT INTO gbl_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","તોવે ઈસુવે આખ્યો, “આમી બાસ કોઆ” ઈસુવે ચ્યા કાનાલ આથ લાવીન ચ્યાલ હારો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","તોવે ઈસુય મુખ્ય યાજકાહાલ એને દેવાળા રાખવાળ્યા આગેવાનહાન એને વડીલાહાન આખ્યાં, “કાય તુમા માન ડાખૂ હોમજીન દોઓરાં હાટી તારવાય એને ડેંગારા લેઈને યેનાહા કા? ");
INSERT INTO gbl_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","જોવે આંય દિનેરોજ દેવાળામાય તુમહેઆરે રોઇન હિકાડૂ, તેરુંબી તુમહાય માન નાંય દોઓયેલ. બાકી આમીતે તુમહે સમય હેય, એને આંદારાં ઓદિકાર ચાલહે.” ");
INSERT INTO gbl_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ચ્યાહાય ચ્યાલ દોઅયો એને મહાયાજકા ગોઅ લેય ગીયા, બાકી પિત્તર દુઉ રોયન ચ્યા પાહલા-પાહલા ચાલ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","એને જોવે બાઆપુર માઅહે આગડા બાળીન તાપાયા બોઠે, ચ્યાહા વોચમાય પિત્તર બી બોહી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","આગડા પાય ચ્યાલ બોઠલો દેખીન યોક ચાકરાણ્યે ચ્યાલ દારી-દારી એઇન આખ્યાં, “એલો ચ્યાઆરે આતો.” ");
INSERT INTO gbl_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","બાકી તો નાંય માન્યો એને બોલ્યો, “બાય, ચ્યાલ આંય નાંય વોળખું.” ");
INSERT INTO gbl_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","થોડીવાઆ રોયન પાછે યોક બીજે ચ્યાલ એઇન આખ્યાં, “તું ચ્યાહામાઅનો હેતો” બાકી પિત્તરે આખ્યાં, “માટડા આંય નાંય હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","આસરે યોક કોલાક પાછે યોક બીજે ખાત્રી કોઇન આખ્યાં, “હાચ્ચાં એલો ચ્યાઆરે આતો, એલો હોગો ગાલીલ ભાગા માઅહું હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","પિત્તરે આખ્યાં, “ઓ માટડા, તું કાય આખતોહો તી માન હોમાજુજ નાંય પોડે?” તો આજુ બોલહે તોવે ચ્યેજ ગેડીયે કુકાડ વાહાયો. ");
INSERT INTO gbl_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","એને પિત્તરાલ ઈસુવા આખલી વાત યાદ યેની, “કુકાડ વાહાયી ચ્યા પેલ્લા તું માન તીનદા નાકાર કોઇ દેહે કા તું માન નાંય વોળખે” ");
INSERT INTO gbl_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","એને તોવે પિત્તર ચ્યા પોતે દુ:ખાલ તાબામાંય નાંય કોઇ હોક્યો એને તો હુંઅકા ટાકીન રોડાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","જ્યા માઅહાય ઈસુલ દોઅલો આતો, ચ્યે ચ્યા મશ્કરી કોઇન ઠોકાં લાગ્યા, ");
INSERT INTO gbl_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","એને ઈસુ ડોળા દોડપીન ચ્યાલ પુછ્યાં, “ભવિષ્યવાણી કોઇન આખ કા તુલ કુંયે ઠોક્યાં.” ");
INSERT INTO gbl_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","એને આજુ બીજી બોજ નિંદા વાતો ચ્યા વિરુદમાય આખી. ");
INSERT INTO gbl_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","જોવે ઉજાળાં ઓઅઇ ગીયા તોવે લોકહા આગેવાન, એને મુખ્ય યાજક, એને મૂસા નિયમ હિકાડનારા ગુરુ બેગા જાયા, એને ઈસુલ સોબાયે ઠિકાણે લેય યેયન પુછ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“જો તું ખ્રિસ્ત હેય, તોવે આમહાન આખી દે” ઈસુવે ચ્યાહાન આખ્યાં, “જો આંય આખું, તોવે તુમા બોરહો નાંય કોઅહા. ");
INSERT INTO gbl_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","એને જો આંય પુછું તોવે તુમા જાવાબ નાંય દાહા. ");
INSERT INTO gbl_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","બાકી આમી પાછે આંય, માઅહા પોહો સર્વશક્તિમાન પોરમેહેરા જમણા આથે બોઠલો રોય.” ");
INSERT INTO gbl_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","તોવે બોદહાય પુછ્યાં, “તોવે તું પોરમેહેરા પોહો હેતો કા?” ઈસુવે ચ્યાહાન જાવાબ દેનો, “તુમા આખતાહા, કાહાકા આંય હેતાંવ.” ");
INSERT INTO gbl_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","તોવે ચ્યાહાય આખ્યાં, તુમા ચ્યાલ પોરમેહેરા નિંદા કોઅતા વોનાયાહા. “આમી તુમહે કાય આખના હેય ચ્યા બોદહા યે વાતે સહમત આતા કા ઈસુ ગુનેગાર હેય એને મોઅરા લાયકે હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","એને ચ્યાહા આખી સોબા ઉઠીન, ચ્યાલ પિલાતાપાંય લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","એને ચ્ચે ચ્યા હુમે એહેકોયન ફિરાદી કોઅતા લાગ્યા કા, “આમહાય ખાત્રી કોઅયી કા ઈ માઅહું રોમી સરકારા વિરુદમાય લોકહાન ચોડવેહે, કૈસરાલ કર દેયના મોનાય કોઅહે, એને પોતે ખ્રિસ્ત, રાજા આખતા વોનાયાહા.” ");
INSERT INTO gbl_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","પિલાત રાજાય ચ્યાલ પુછ્યાં, “કાય તું યહૂદીયાહા રાજા હેતો કા?” ઈસુય પિલાત રાજાલ જાવાબ દેનો, “તું પોતેજ આખતોહો.” ");
INSERT INTO gbl_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","પિલાત રાજાય મુખ્ય યાજકાલ એને લોકહાન આખ્યાં, “યા માટડામાય કાય ગુનો નાંય દેખાય.” ");
INSERT INTO gbl_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","બાકી ચ્યા ચ્યાહા ફિરાદી આજુ જોરમાય આખતા લાગ્યા, ઈહીં બોદા યહૂદીયા વિસ્તારમાય લોકહાન પોતાના હિકાડનાથી ભડકાવેહે, “એને બોદા ગાલીલ ભાગામાઅને સુરુ કોઇન ઈહીં લોગુ તો યેય ગીયહો.” ");
INSERT INTO gbl_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ઈ વોનાઈન પિલાત રાજાય પુછ્યાં, “કાય ઓ ગાલીલ ભાગા માઅહું હેય કા?” ");
INSERT INTO gbl_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","એને ઈસુ હેરોદ રાજા રાજ્ય કોઅહે ચ્યા ભાગામાઅને હેય, તી જાયને, ચ્યે ચ્યાલ હેરોદા રાજાપાય દોવાડયો, ચ્યે સમાયે હેરોદ રાજા યેરૂસાલેમ શેહેરામાય આતો. ");
INSERT INTO gbl_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ઈસુવાલ એઅયન હેરોદ રાજા ખુશ જાયો, કાહાકા તો ચ્યાલ બોજ સમાયા થી એરા માગે, કાહાકા ચ્યા વાત તો વોનાયેલ એને તો ઈસુપાયને ચમત્કારા કામ કોઅતા એઅના બોજ આશા આતી. ");
INSERT INTO gbl_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ચ્યાહાટી હેરોદ રાજાય ઈસુવાલ બોજ વાતહેબારામાય પુછ્યાં, બાકી ઈસુવે કાય જાવાબ નાંય દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","એને મુખ્ય યાજક એને મૂસા નિયમ હિકાડનારા ગુરુ તાં ઉબા રોયન દોષ થોવતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","બાકી હેરોદ રાજાય ચ્યા સિપાડાહા આરે ઈસુવા અપમાન કોઇન મશ્કરી કોઅયી, એને નિંદા કોઅયી, ચ્યાલ યોક રાજા ફાડકા પોવાડયા એને પાછો પિલાત રાજાપાય દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ચ્યે સમાયે લોગુ હેરોદ રાજા એને પિલાત રાજા યોકા-બિજા દુશ્માન આતા, બાકી તોદિહી ચ્યા દોસ્તાર બોની ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","પિલાત રાજાય મુખ્ય યાજકાહાલ એને આગેવાનાહાન એને લોકહાન હાદિન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","“તુમા યા માઅહાન માયેપાંય લેય યેના, એને આખ્યાં કા ઓ દુમાલ કોઆડાં હાટી લોકહાન ચોડવેહે, બાકી એઆ, માયે તુમહે હોમ્મે ચ્યા બારામાય જાંઅયા, બાકી જ્યેં વાતહેબારામાય તુમા ચ્યાવોય દોષ લાવતેહે, ચ્યે વાતહો બારામાય માન ચ્યામાય કાયજ દોષ નાંય મિળ્યહો. ");
INSERT INTO gbl_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","એને હેરોદ રાજાલ બી ચ્યામાય દોષ નાંય દેખાયો, કાહાકા હેરોદ રાજાય ચ્યાલ માયેપાંય પાછો દોવાડયો, યા માઅહાલ મોતા ડોંડ બોગવાં પોડે ઓહડો ચ્યે કાયબી જુઠા નાંય કોઅયાહાં. ");
INSERT INTO gbl_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ચ્યાહાટી ચ્યાલ ચાપકા માર દેયન આંય છોડી દેતહાવ.” ");
INSERT INTO gbl_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","પિલાત રાજા પાસ્કા સણા સમાયે યહૂદીયાહાહાટી યોકા કૈદ્યાલ છોડી દેતો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","તોવે બોદહાય બોજ બોંબલીન આખ્યાં કા, “ચ્યાલ માઆઇ ટાકાં, એને આમહાન બારાબ્બાસ દેય દે.” ");
INSERT INTO gbl_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","બારાબ્બાસે શેહેરામાય દુમાલ કોઅયેલ એને ખૂન કોઅયેલ, ચ્યાહાટી જેલેમાય ટાકલાં યોક માઅહું આતા. ");
INSERT INTO gbl_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","બાકી પિલાત રાજાય ઈસુવાલ છોડી દાં માગે ચ્યાહાટી આજુ ચ્યાહાન હોમજાડેહે. ");
INSERT INTO gbl_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","બાકી ચ્યાહાય બોંબલ્યા, “હુળીખાંબાવોય ચોડવી દે, ચ્યાલ હુળીખાંબે ચોડવી દે.” ");
INSERT INTO gbl_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","આજુ તીજેદા ચ્યે ચ્યાહાન આખ્યાં, “બાકી એલે કાય જુઠા કોઅયાહાં? મોતા ડોંડ બોઅરા પોડે ઓહડા ચ્યામાય કાય નાંય મીળે ચ્યાહાટી ચ્યાલ ચાપકા માર દેવાડીન ચ્યાલ છોડી દેતહાવ,” ");
INSERT INTO gbl_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","બાકી ચ્યા મોઠેરે બોંબાલતા લાગ્યા એને માગતા લાગ્યા, “ચ્યાલ હુળીખાંબાવોય ચોડવી દાં જોજે” એને ચ્યાહા બોંબાલના નાંય ગાઠ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","પિલાત રાજાય આગના કોઅયી કા ચ્યાહા માગણી માન્ય કોઅરા જોજે. ");
INSERT INTO gbl_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","એને બારાબાસાલ જ્યાંય શેહેરામાય દુમાલ કોઅયેલ એને ખૂન કોઅયેલ ચ્યાહાટી જેલેમાય ટાકલાલ ચ્યાહાય માગ્યાં, તોવે ચ્યાલ પિલાત રાજાય છોડી દેનો, એને ઈસુવાલ ચ્યાહા ઇચ્છા નુસાર ચ્યાહાલ હોઅપી દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","જોવે ચ્યા શેહેરા બાઆ જાય રીયલા આતા, તે સિમોન નાંવા યોક માટડો ગાવા ભાગામાઅને યેરૂસાલેમ શેહેરામાય યી રિઅલો આતો. સિમોન, કુરેની ગાવામાઅનો આતો, એને તો સિકંદર એને રૂફસા આબહો આતો, સીપાડાહાય ચ્યાલ આખ્યાં કા તો હુળીખાંબલીન ચ્યા જાગા હુદી લેય જાય જાં ચ્યા ઈસુલ હુળીખાંબે ચોડાવનારા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ચ્યા પાહલા માઅહા મોઠી ગીરદી જાય એને બોજ બાયો ચ્યાહાટી રોડત્યો આત્યો, એને દુઃખ કોઅત્યો આત્યો. ");
INSERT INTO gbl_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ચ્યેહે એછે વોળીન ઈસુવે આખ્યાં, “ઓ યેરૂસાલેમ શેહેરામાય રોનાર્યો બાયહીય, તુમા મા હાટી મા રોડહા, તુમહે પોતાના એને તુમહે પાહાહા હાટી રોડા. ");
INSERT INTO gbl_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","કાહાકા પીડા બોગવુના દિહી યેય રોયહા, એને લોક આખરી, ધન્ય હેય ચ્યો બાયો, જ્યેહે પોહેં નાંય હેય, જ્યેહેય પોહહાલ જન્મો નાંય દેનહો, જ્યેહેય કોદહી ચ્યાહાન દુદ નાંય પાજ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ચ્યે સમાયે, લોક ડોગાલ આખરી, આમહા ઉપે પોડ એને ડોગાલિયેહેન આખરી, આમહાન દુબાડ. ");
INSERT INTO gbl_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","કાહાકા જોવે નિર્દોષ માઅહા આરે એહેકોય બોને, તે વિચાર કોઆ માઅહું દોષી હેય ચ્યાઆરે કાય ઓઅરી?” ");
INSERT INTO gbl_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ચ્યાઆરે બેન ગુનેગારીયાલ માઆઇ ટાકાંહાટી લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","જોવે “ખોપરી” નાંવા જાગા ઉપે યેના તોવે ચ્યાહાય તાં ચ્યાલ હુળીખાંબાવોય ચોડવી દેનો, એને બેન ગુનેગારીયાલ બી, યોકાલ જમણે આથે એને યોકાલ ડાબે આથે હુળીખાંબાવોય ચોડવ્યા. ");
INSERT INTO gbl_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","તોવે ઈસુવે આખ્યાં, “આબા, ચ્યાહાન માફ કોઓ, કાહાકા ચ્યા કાય કોઅતા ચ્યા જાંએત નાંય” ચ્યા ફાડકે વાટી લા હાટી ચ્યાહાય ચિઠ્ઠી ટાકી. ");
INSERT INTO gbl_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","એને બોદા લોક ઉબા રોયન એઅયા કોએત, બાકી લોકહા આગેવાન મશ્કરી કોઅઈન આખે કા, “ચ્યાય બીજહાન તો હારાં કોઅયા, જો એલો પોરમેહેરા ખ્રિસ્ત હેય એને ચ્યા નિવુડલો હેય, તો પોતાલ બોચાવી લેય.” ");
INSERT INTO gbl_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","સિપાડાબી ચ્યા મશ્કરી કોઅતા ચ્યાપાય યેયન ચ્યાલ ખાટા પાજેત. ");
INSERT INTO gbl_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","એને આખે, “તું યહૂદીયાહા રાજા ઓરી તોવે તું પોતાનો બોચાવ કોઓ?” ");
INSERT INTO gbl_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","સીપાડાહાય ઈસુવા ટોલપી વાયજ ઉચે યોક દોષા પાટી લાવી દેની, ચ્યામાય એહેકોય લિખલાં આતા, “ઓ યહૂદીયાહા રાજા હેય.” ");
INSERT INTO gbl_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","શિક્ષા બોગાવનારહા એને ચ્યાઆરે જ્યા બાંડ હુળીખાંબાવોય ચોડાવલા આતા ચ્યાહાય બી ચ્યા નિંદા કોઇન આખ્યાં, “તું ખ્રિસ્ત હેતો, તોવે પોતાલ એને આમહાન બોચાવ.” ");
INSERT INTO gbl_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","બાકી બીજે પેલ્લાલ ઠોપકાડીન આખ્યો, “તું પોરમેહેરાલ બી નાંય બિઅયા કા, તુલબી હારકી શિક્ષા મિળી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","એને આપા તે ન્યાયા નુસાર સજા બોગવી રીયહા, કાહાકા આપહાય જુઠા કોઅયા તી બોગવાં પોડહે, બાકી યે જુઠા કાય નાંય કોઅયાહાં.” ");
INSERT INTO gbl_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","પાછે ચ્યે આખ્યાં, “ઈસુ, રાજા હારકો રાજ્ય લેયને યેહે, તોદિહી માન યાદ કોઅજે.” ");
INSERT INTO gbl_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ઈસુવે ચ્યાલ આખ્યાં, “તુલ હાચ્ચાં આખતાહાવ આજેજ તું મા આરે હોરગા લોકહામાય રોહે. ");
INSERT INTO gbl_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","એને લગભગ બોપરેહે પાછે બોદા દેશામાય આંદારાં ઓઅઇ ગીયા, એને તીં તીન વાગ્યા લોગુ રિયા. ");
INSERT INTO gbl_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","કાહાકા દિહી ઉજવાડો નાંય દેતો લાગ્યો, એને દેવાળા વોચમાય લોટકાડલો પોડદો આતો, જો બોદહાલ પોરમેહેરા હજર્યેમાય જાંહાટી રોકતો આતો, ઉપેરે તે નિચે લોગુ બેન ભાગ ઓઇન ફાટી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","એને ઈસુ મોઠેરે બોંબલીન આખ્યાં, ઓ આબા, તો આથામાય મા જીવ આંય હોઅપી દેતહાવ” એહેકોય આખીન મોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","જીં બોન્યા તી જોવે સુબેદારાય એઅયા, તોવે ચ્યે પોરમેહેરા સ્તુતિ કોઅયી, એને આખ્યાં, “નોક્કી ઓ માઅહું ન્યાયી આતો.” ");
INSERT INTO gbl_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","એને જ્યેં માઅહે ખીયાલ એરા ટોળો વોળલે, ચ્યે ઈ બોદા ઓઅતા દેખીન બોજ દુઃખ થી છાતી બાહાટતે પાછે ગોઓ વોળી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","એને ઈસુ બોદે વોળખાત્યે, એને જ્યો બાયો ગાલીલ ભાગામાઅને ચ્યાઆરે યેનલ્યો આત્યો, દુઉ ઉબ્યો રોઇન ઈ બોદા એય રિઅલ્યો આત્યો. ");
INSERT INTO gbl_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","યોસેફ નાંવા યોક માટડો આતો, જો અરીમતિયા શેહેરામાઅનો આતો, તો યહૂદી મોઠી સોબાયે યોક બોજ ઈજ્જતદાર માઅહું આતો. ");
INSERT INTO gbl_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","એને ચ્યાહા યોજના એને ચ્યાહા ચ્યા કામહાથી તો રાજી નાંય આતો, એને તો યહૂદીયા ભાગા અરીમતિયા લોકહામાઅનો યોક આતો જો પોરમેહેરા રાજ્ય જલદી યેયના વાટ જોવી રિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","તો બિક વોગાર પિલાત રાજાપાય ગીયો એને ઈસુ શરીરાલ હુળીખાંબાવોયને ઉતાડીન ચ્યાલ કોબારેમાય થોવાંહાટી પરવાનગી માગી. ");
INSERT INTO gbl_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","એને ઈસુ શરીરાલ હુળીખાંબાવોયને ઉતાડીન યોકા હારાં મોઅગા ફાડકામાય ચોંડાળીન એને ખોલકાડામાંય કોચીન તિયારી કોઅલી યોક કોબારેમાય થોવી દેના, ચ્યે કોબારેમાય પેલ્લા કાદાલ નાંય થોવ્યેલ. ");
INSERT INTO gbl_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","તો આરામા દિહા તિયારી કોઅના દિહી આતો, એને શાબાથ દિહી સુરુ ઓઅનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","એને ગાલીલ ભાગામાઅને યેનલ્યો બાયો, આરે જાયને કોબારેલ દેખ્યાં એને ઈ બી કા ઈસુ શરીર કેહેકેન થોવલાં હેય. ");
INSERT INTO gbl_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","એને પાછયો ગોઓ જાયને, ઈસુ શરીરાલ લાવના અત્તાર તિયારી કોઅયા, એને આરામા દિહા લીદે મૂસા નિયમશાસ્ત્ર નુસાર આરામ કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","બાકી રવિવારે બોજ કોવાળ્યાં આજુ આંદારાં આતા તોવે જીં ઈસુ શરીરાઆરે લાવાં સુગંદી વસ્તુ ચ્યેહેય તિયાર કોઅયેલ, તી લેયને કોબારે એછે ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","તોવે દેખ્યાકા કોબારે મુયાહીને મોઠો દોગાડ હોરકાવલો આતો. ");
INSERT INTO gbl_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","એને માજે જાયન એઅયા તાં પ્રભુ ઈસુ મુરદાં નાંય દેખાયાં. ");
INSERT INTO gbl_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","જોવે ચ્યો યે વાતહે વિચારહામાય આત્યો તોવે, બેન માટડા ઉજળેં ચોમાકતે ફાડકે પોવીન ચ્યેહે પાહી યેઇન ઉબા રિયા. ");
INSERT INTO gbl_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","જોવે ચ્યો બિઇ ગીયો એને દોરત્યે એછે નિચે એઇન ડોંગ્યો પોડી રિયો તોવે ચ્યાહાય ચ્યેહેલ આખ્યાં, “તુમા જીવતાલ મોઅલા માય કાહા હોદત્યોહો? ");
INSERT INTO gbl_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","તો ઈહીં નાંય હેય, બાકી મોઅલા માઅને જીવી ઉઠયોહો, યાદ કોઆ કા ચ્યાય ગાલીલ ભાગામાય રોય તોવેજ તુમહાન આખલા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","જરુરી હેય, કા આંય, માઅહા પોહાલ પાપી લોકહા આથામાય દોઆડી દી, એને હુળીખાંબાવોય ચોડવી દી, એને તો મોઅલા માઅને તીજે દિહી પાછો જીવી ઉઠી.” ");
INSERT INTO gbl_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","તોવે ચ્યા વાતો ચ્યેહેલ યાદ યેન્યો. ");
INSERT INTO gbl_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","એને કોબારે પાઅને યેઇન ચ્યેહેય ચ્યા ઓગ્યારાહાલ, એને બિજા બોદહાલ, યો બોદ્યો વાતો વોનાડયો. ");
INSERT INTO gbl_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","જ્યાહાય પ્રેષિતાહાલ યો વાતો આખ્યો તોવે મરિયમ જીં મગદલ શેહેરા આતી એને યોઅન્ના એને યાકૂબા આયહો મરિયમ એને ચ્યાહાઆરે થોડ્યોકખાન બીજ્યો થેએયોબી આત્યો. ");
INSERT INTO gbl_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","બાકી ચ્યાહા વાતો કાહાની જેહેકેન લાગી, એને ચ્યાહાય ચ્યાહાવોય બોરહો નાંય કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","તોવે પિત્તર દાંહદીન કોબારે ઈહીં ગીયો, એને ડોંગો પોડીન ખાલી ડોગલેં પોડલેં દેખ્યે, એને જીં જાયલા આતા, ચ્યાલ એઇન નોવાય પામતો પોતાના ગોઅ નિંગી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ચ્યેજ દિહી ચ્યાહામાઅને બેન શિષ્ય અમ્માઉસ નાંવા યોક ગાવામાય જાં લાગ્યા, જીં યેરૂસાલેમ શેહેરાથી હાંત મીલ (૧૧ કિલીમીટર)દુર આતા. ");
INSERT INTO gbl_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ચ્યા યો બોદયે વાતહેબારામાય જ્યો ઓઅલ્યો આત્યો, યોકબીજાઆરે વાતો કોઅતા જાય રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","એને જોવે યોકબીજાઆરે વાતો કોઅતા એને પુછપરછ કોઅતા જાય રીઅલા આતા, તોવે ઈસુ પોતે પાહી યેઇન ચ્યાહાઆરે જાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","બાકી પોરમેહેરાય ચ્યાહાન ઈસુલ વોળખાં નાંય દેના. ");
INSERT INTO gbl_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ઈસુવે ચ્યાહાન પુછ્યાં, “યો કાય વાતો હેય, જ્યો તુમા ચાલતા-ચાલતા યોક બિજા આરે કોઅતાહા?” ચ્યા ઉબા રોય ગીયા એને ચ્યાહા મુંયાવોય બોજ નિરાશ લાગી રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ઈ વોનાઈન, ચ્યાહામાઅને ક્વિયુપાસ નાંવા યોકા જાંઆય આખ્યાં, “કાય તું યેરૂસાલેમ શેહેરામાય યોકલોજ પારદેશી હેય, જો નાંય જાણેંકા પાછલા દિહીહયામાય કાય-કાય ઓઅયાહા?” ");
INSERT INTO gbl_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ઈસુવે ચ્યાહાન પુછ્યાં, “કોઅયોહો વાતો?” ચ્યાહાય ચ્યાલ આખ્યાં, આમા “નાજરેત ગાવા ઈસુ બારામાય વાત કોઅઇ રીઅલા આતા, તો પોરમેહેરા એને બોદા લોકહા હોમ્મે ચમત્કારી કામ એને સામર્થી સંદેશ હિકાડનારો ભવિષ્યવક્તા આતો. ");
INSERT INTO gbl_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","એને મુખ્ય યાજક એને આમે આગેવાનાહાય ચ્યાલ દોઆડી દેનો એને ચ્યાવોય મોરણા આગના દેની; એને ચ્યાલ હુળીખાંબાવોય ચોડવ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","બાકી આમહાન આશા આતી, કા ઓજ ઈસરાયેલા લોકહા બોચાવ કોઅરી, એને યો બોદયે વાતહે સિવાય, યો બોદ્યો વાતો ઓઇન તીન દિહી ઓઈ ગીયહા. ");
INSERT INTO gbl_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","આમી આમહે માઅને કોલહિક થેઅયેહેયબી નોવાય પામાડી દેનહા, જ્યો આજે આમહે થી પેલ્લા કોબારે ઈહીં ગીઅલ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","એને જોવે ચ્યા મુરદાં નાંય દેખ્યાં, તોવે ઈ આખતી નિંગી કા આમહાય હોરગા દૂતહા દર્શન કોઅયા, જ્યાહાય આખ્યાં કા ઈસુ જીવતો હેય. ");
INSERT INTO gbl_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","તોવે આમે આર્યાહાં માઅને કોલહાક લોક કોબારે પાહી ગીયા, એને જેહેકેન ચ્યે થેઅયેહેય આખ્યાં તેહેકેન નોકીજ દેખ્યાં; બાકી ચ્યાલ નાંય દેખ્યો.” ");
INSERT INTO gbl_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","તોવે ઈસુવે ચ્યા બેન શિષ્યહાન આખ્યાં, “ઓ નિર્બુધીહાય, જીં કાય ભવિષ્યવક્તાહાય પવિત્રશાસ્ત્રમાય લોખલાં હેય, તુમહાન ચ્યે વાતવોય બોરહો કોઅરા બોજ વોગરા લાગહે! ");
INSERT INTO gbl_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ઈ જરુરી આતા કા ખ્રિસ્ત ઈ દુ:ખ વેઠીન પોતા મહિમામાય પ્રવેશ કોય.” ");
INSERT INTO gbl_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","તોવે ઈસુય ચ્યાહાન બોદા પવિત્રશાસ્ત્ર માઅને, મૂસા નિયમશાસ્ત્ર માઅને શુરવાત કોઇન બોદા ભવિષ્યવક્તાકોય ચ્યા બારામાય આખલ્યો વાતો હોમજાડયો. ");
INSERT INTO gbl_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ઓલહામાય ચ્યા, ચ્યા ગાવામાય પોઅચી ગીયા, એને ચ્યાહાય એહેકોય જાંઅયા કા તો આજુ આગલા જાં માગહે. ");
INSERT INTO gbl_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","બાકી ચ્યાહાય ચ્યાલ ઈ આખીન રોક્યો કા, “આમે આરે રો, કાહાકા વોખાતી વેળ ઓઈ રીયહી એને દિહી આમી બુડી ગીયહો” તોવે તો ચ્યાહાઆરે રાંહાટી માજે ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","જોવે ઈસુ ચ્યાહાઆરે ખાઅના ખાં બોઠો, તોવે ચ્યે બાખે લેઈને આભાર માનીન બાખે મુડીન ચ્યાહાન દાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","તોવે પોરમેહેરાય ચ્ચાહા ડોળા ઉગાડી દેના એને ચ્ચાહાય ઈસુલ વોળખી લેદો. ");
INSERT INTO gbl_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ચ્યાહાય યોકબિજાલ આખ્યાં, “જોવે તો આમહે આરે વાટીમાય વાતો કોએ એને પવિત્રશાસ્ત્રા મતલબ આમહાન હોમજાડે, તો આમહે મોનામાય બોજ ખુશી ઓઅયી.” ");
INSERT INTO gbl_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ચ્યા તારાત ઉઠીન યેરૂસાલેમ શેહેરામાય જાતા રિયા એને ચ્યા ઓગ્યાર શિષ્યહાન એને ચ્યાહા આરહ્યાન યોકઠા દેખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","જ્યા યોકઠા ઓઅલા આતા ચ્યાહાય આખ્યાં, “પ્રભુ જો હાચુલ જીવી ઉઠયોહો, એને સિમોન પિત્તરાલ દેખાયહો.” ");
INSERT INTO gbl_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","તોવે ચ્યા બેની જાઅહાય વાટ્યેમાય ચાલતે સમાયે ઈસુઆરે કોઅલ્યો વાતો ચ્યાહાન આખી દેન્યો, એને ઇબી કા ચ્યાહાય બાખે ખાતી સમાયે કેહેકે વોળખ્યો. ");
INSERT INTO gbl_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ચ્યા યો વાતો આખતાજ આતા, તાંઉ ઈસુ પોતે ચ્યાહા વોચ્ચે યેયન ઉબો રોય ગીયો, એને ચ્યાય આખ્યાં, “તુમહાન શાંતી મીળે.” ");
INSERT INTO gbl_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","બાકી ચ્યા ગાબરાય ગીયા એને બિઇ ગીયા, એને હોમજ્યા કા આમા યોકતા આત્માલ એઇ રીયહા. ");
INSERT INTO gbl_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ચ્યાય ચ્યાહાન આખ્યાં, “કાહા ગાબરાતાહા? એને તુમહે મોનામાય કાહા શંકા કોઅતાહા? ");
INSERT INTO gbl_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","મા આથ એને મા પાગહાલ એરા, કા આંય તોજ હેતાઉ, માન આથલીન એરા, કાહાકા આત્મામાય આડકે એને માહાં નાંય રોય જેહેકેન મા માય એઅતાહા.” ");
INSERT INTO gbl_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ઈ આખીન ઈસુય ચ્યાહાન પોતા આથ એને પાગ દેખાડયા. ");
INSERT INTO gbl_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","તોવે આનંદમાય યેયન બોરહો નાંય ઓઅયો કા ઈસુ જીવતો હેય, એને નોવાય પામા આતા, તોવે ચ્યાય ચ્યાહાલ પુછ્યાં, “કાય તુમહેવોય થોડાંક ખાઅના હેય? ");
INSERT INTO gbl_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ચ્યાહાય ચ્યાલ હેકલાં માછલા ટુકડો દેનો. ");
INSERT INTO gbl_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ચ્યાય લેઈને ચ્યાહા હામ્મે ખાદાં. ");
INSERT INTO gbl_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","પાછે ચ્યાય ચ્યાહાન આખ્યાં, યો મા ચ્યો વાતો હેત્યો, જ્યો માયે તુમહેઆરે રા તોવે તુમહાન આખના જરુરી આતા કા જોલ્યો વાતો મૂસા નિયમશાસ્ત્રા એને ભવિષ્યવક્તાહા એને ગીતહા ચોપડયેહેમાય મા બારામાય લોખલાં હેય, બોદ્યો હાચ્યો સાબિત ઓએ.” ");
INSERT INTO gbl_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","તોવે ચ્યાય પવિત્રશાસ્ત્ર હોમજાંહાટી ચ્યાહા મોદાત કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","એને ચ્યાહાન આખ્યાં, “પવિત્રશાસ્ત્રમાય એહેકોય લોખલાં હેય કા ખ્રિસ્ત દુ:ખ બોગવી, એને તીજે દિહી મોઅલા માઅને પાછો જીવી ઉઠી. ");
INSERT INTO gbl_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","એને યેરૂસાલેમ શેહેરાહીને લેયને તે બિજ્યે બોદયે જાત્યે લોકહાન પાપ છોડના એને પાપહા માફી ખોબાર, ચ્યાજ નાંવા માય કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","તુમા યે બોદયે વાતહે સાક્ષીદાર હેય. ");
INSERT INTO gbl_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","એને વોનાયા, આંય તુમહાવોય પવિત્ર આત્મા દોવાડીહી જ્યા વાયદો મા આબહાય કોઅલો હેય, બાકી તુમહાન તાંવ લોગુ યેરૂસાલેમ શેહેરામાય રોઇન વાટ જોવાં પોડી, જાવ લોગુ તુમહાન હોરગામાઅને સામર્થ્ય નાંય દેનલા જાય.” ");
INSERT INTO gbl_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","તોવે તો ચ્યાહાન બેથાનીયા ગાવા પાહી લોગુ શેહેરા બારે લેય ગીયો, એને પોતા આથ ઉચકીન ચ્યાહાન બોરકાત દેની. ");
INSERT INTO gbl_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","એને ચ્યાહાન બોરકાત દેતાજ તો ચ્યાહાપાઅને જાતો રિયો, એને હોરગામાય લેવાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","તોવે ચ્યે ચ્યા પાગે પોડીન મોઠા આનંદથી યેરૂસાલેમ શેહેરામાય પાછે ફિરી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","એને ચ્યા કાયામ દેવાળામાય યેયન પોરમેહેરા સ્તુતિ કોઅયા કોય.");
INSERT INTO gbl_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ઈ દુનિયા બોના પેલ્લા તો આતો, જ્યાલ વચન આખતેહે, એને તો પોરમેહેરાઆરે આતો એને તો પોરમેહેર આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","તો દુનિયા બોના પેલ્લેથીજ પોરમેહેરાઆરે આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","બોદા દુનિયા ચ્યા કોઇન બોનાવ્યાં, એને બોદા દુનિયામાય ચ્યાવોગાર કાયજ બોની નાંય હોક્યા. ");
INSERT INTO gbl_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","તો બોદા જીવના ઝરો હેય, એને તોજ બોદા માઅહાન ઉજવાડો દેહે. ");
INSERT INTO gbl_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","તો ઉજવાડો આંદારામાય ચોમકેહે એને આંદારાં ચ્યાલ ઉલવી નાંય હોક્યા. ");
INSERT INTO gbl_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","પોરમેહેરાય યોહાન નાંવા યોક માઅહાલ દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","યોહાન સાક્ષી દાંહાટી યેનો, કા તો ઉજવાડા બારામાય સાક્ષી દેય, કા બોદે ચ્યા સાક્ષી લીદે ઉજવાડાવોય બોરહો કોએ. ");
INSERT INTO gbl_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","યોહાન પોતે ઉજવાડો નાંય આતો, બાકી ઉજવાડા બારામાય સાક્ષી દાંહાટી યેનલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","તો હાચ્ચો ઉજવાડો હેય, તો બોદા માઅહાન ઉજવાડો દેહે, તો દુનિયામાય યેનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","તો દુનિયામાય આતો, એને દુનિયા ચ્યા કોઇન બોનાવલા આતા, બાકી દુનિયા લોકહાય ચ્યાલ નાંય વોળખ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","તો પોતાના લોકહામાય યેનો, બાકી પોતાના લોકહાય ચ્યા સ્વીકાર નાંય કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","બાકી જોલા લોકહાય ચ્યા સ્વીકાર કોઅયો, એટલે ચ્યાવોય બોરહો કોઅયો ચ્યાહાન ચ્યે પોરમેહેરા પોહેં બોના ઓદિકાર દેનો. ");
INSERT INTO gbl_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ચ્યાહા જન્મો આયહે આબહા ઇચ્છાકોય નાંય, કા યોકા માઅહા પોહા પૈદા કોઅના મોરજયેકોય નાંય, કા માઅહા ઇચ્છાકોય નાંય જાયો, બાકી પોરમેહેરા પાયને જન્મો જાયો. ");
INSERT INTO gbl_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","એને વચન યોક માઅહું બોન્યો, એને મોયા એને હાચ્ચાયેકોય પરિપૂર્ણ ઓઇન આપહેમાય વોહતી કોઅયી, એને આમહાય ચ્યા મહિમા એઅઇ, જીં પોરમેહેર આબા પાઅને યેનલા યોકને-યોક પોહા મહિમા. ");
INSERT INTO gbl_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","યોહાને ચ્યા બારામાય સાક્ષી દેની, એને બોંબલીન આખ્યાં, “ઓ તોજ હેય, જ્યા બારામાય માયે આખલા આતા કા, મા પાછે જો યેનારો હેય, તો મા કોઅતો મહાન હેય, કાહાકા તો મા કોઅતો પેલ્લા આતો.” ");
INSERT INTO gbl_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","કાહાકા ચ્યા સદા મોયા પરિપૂર્ણતા કોય આપા બોદહાન બોરકાત વોય બોરકાત મીળહી. ");
INSERT INTO gbl_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","કાહાકા નિયમશાસ્ત્ર મૂસાકોય દેનલા આતા બાકી પોરમેહેરાય ઈસુ ખ્રિસ્તાકોય સદા મોયા એને હાચ્ચાઇ દેખાડી. ");
INSERT INTO gbl_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","પોરમેહેરાલ કાદે દેખ્યહો નાંય, બાકી પોરમેહેરા યોકનેયોક પોહો ચ્યા પોરમેહેરા પાહાય રોહે, ચ્યેય ચ્યાલ પ્રગટ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","જોવે યહૂદી આગેવાનહાય યેરૂસાલેમ શેહેરામાઅને યાજક એને લેવીયાહાન યોહાનાલ ઈ પુછા દોવાડયા કા, “તું કું હેતો?” તોવે યોહાના સાક્ષી ઈ. ");
INSERT INTO gbl_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","યોહાને સાફ કબુલ કોઅયા, “આંય ખ્રિસ્ત નાંય હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","તોવે ચ્યાહાય યોહાનાલ પુછ્યાં, “તે પાછે તું કું હેતો? કાય તું એલીયા ભવિષ્યવક્તા હેય?” યોહાને જવાબ દેનો કા “આંય નાંય હેય” “તે કાય તું તો ભવિષ્યવકતો હેય, જો યેનારો હેય?” યોહાને જવાબ દેનો, “આંય નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","તોવે ચ્યાહાય યોહાનાલ પુછ્યાં, “પાછે તું કું હેતો? કા આમા આમહાન દોવાડનારાહાન જવાબ દેજે, તું પોતાના બારામાય કાય આખતોહો?” ");
INSERT INTO gbl_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","યોહાને આખ્યાં, “જેહેકોય યશાયા ભવિષ્યવક્તાયેબી લોખ્યહાં, ‘ઉજાડ જાગામાય યોહાન બોંબલીન આખહે કા પ્રભુ યેયના વાટ હિદી કોઆ.’” ");
INSERT INTO gbl_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","કોલહાક લોક પોરૂષી લોકહાપાઅને દોવાડલા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","તોવે ચ્યાહાય યોહાનાલ પુછ્યાં, “જોવે તું ખ્રિસ્ત નાંય હેતો, તું એલીયા નાંય હેતો એને તો ભવિષ્યવક્તા બી નાંય હેય, તે તું લોકહાન બાપતિસ્મા કાહા દેતહો?” ");
INSERT INTO gbl_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","યોહાને ચ્યાહાન જાવાબ દેનો, “આંય તે પાઆયાકોય તુમહાન પાપ કોઅના બંદ કોઅરાહાટી બાપતિસ્મા દેતહાવ, બાકી તુમા જ્યાલ વોળખેત નાંય ઓહડો યોક માઅહું તુમહે વોચમાય ઉબલો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ઓ તોજ હેય, જો મા પાછે યેનારો હેય, આંય તે ચ્યા ચાકાર બોનીન ચ્યા ખાઅડા હુતળી છોડાબી લાયકે નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","યો બોદ્યો વાતો યારદેન નોયે ચ્યેમેરે બેથાનીયા ગાવામાય બોન્યો, તાં યોહાન લોકહાન બાપતિસ્મા દેતો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","બીજે દિહી યોહાને ઈસુવાલ ચ્યાપાય યેતા એઇન આખ્યાં, “એઆ, ઓ પોરમેહેરા ગેટો હેય, જો દુનિયા લોકહા પાપ દુઉ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ઓ તોજ હેય, જ્યા બારામાય માયે આખ્યેલ કા, મા પાછે યોક યેનારો હેય, જો મા કોઅતો મહાન હેય, કાહાકા તો મા કોઅતો પેલ્લો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","એને આંય તે ચ્યાલ નાંય વોળાખતો આતો કા તો ખ્રિસ્ત હેય, બાકી ઈસરાયેલ લોકહાન ઈ આખાહાટી કા તો કું હેય, આંય પાઅયા કોઇન બાપતિસ્મા દેતો યેનો.” ");
INSERT INTO gbl_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","યોહાને ઈ સાક્ષી દેયન આખ્યાં, “માયે પવિત્ર આત્માલ કબુતરા રોકા આકાશામાઅને ચ્યાવોય ઉતતા એઅયા, એને ચ્યાવોય ઠોરી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","આંય ચ્યાલ નાંય વોળાખતો આતો કા તો ખ્રિસ્ત હેય, બાકી જ્યાંય માન પાઅયા કોઇન બાપતિસ્મા દાંહાટી દોવાડયો, ચ્યે માન આખ્યેલ કા, ‘તું પવિત્ર આત્માલ જ્યાવોય ઉતતો એને થોબતો એઅહે, તોજ પવિત્ર આત્માકોય બાપતિસ્મા દેનારો હેય.’ ");
INSERT INTO gbl_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","માયે ઈ પોતે એઅયા એને આંય સાક્ષી દેતહાવ કા, ઓ પોરમેહેરા પોહો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","બીજે દિહી યોહાન ચ્યા બેન શિષ્યહાઆરે ઉબો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ઈસુ તાં જાય રિઅલો આતો, એને ઈસુ એછે એઇન યોહાને આખ્યાં, “એઆ, ઓ પોરમેહેરા ગેટો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","તોવે યોહાનાલ એહેકેન આખતો વોનાઈન ચ્યા બેન શિષ્ય ઈસુવા પાહલા જાં લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","તોવે ઈસુવે ફિરી એઇન ચ્યાહાન પાહલા યેતા દેખ્યા તોવે ચ્યાહાન આખ્યાં, “તુમા કાલ હોદતાહા?” ચ્યાહાય ઈસુલ આખ્યાં, “ઓ ગુરુજી, તું કેછ રોતહો?” ");
INSERT INTO gbl_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ઈસુવે ચ્યાહાન આખ્યાં, “ચાલા, તે એઇ લીયા.” તોવે ચ્યા ઈસુઆરે ગીયા એને તો કેછ રોહોય તીં ચ્યાહાય એઅયા એને તોદહી ઈસુઆરે રિયા, ચ્યે સમયે લગભગ વોખાતેહે ચાર વાગલે આતેં. ");
INSERT INTO gbl_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","યોહાના આખલ્યા વોનાઈન ઈસુ પાહલા જ્યા બેન જાંઆ ગીઅલા આતા, ચ્યાહામાઅને યોક જાંઆ સિમોન પિત્તરા બાહા આંદ્રિયાસ આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","આંદ્રિયાસ પેલ્લા ચ્યા બાહા સિમોનાલ મિળ્યો એને ચ્યાલ આખ્યાં, “આમહાન ખ્રિસ્ત એટલે મસીહા, મિળી ગીયહો.” ");
INSERT INTO gbl_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","આંદ્રિયાસ સિમોનાલ ઈસુવાપાય લેય ગીયો, ઈસુવે ચ્યાએછે એઇન આખ્યાં, “તું યોહાના પોહો સિમોન હેય, આમી પાછે તો નાંવ કેફા મતલબ પિત્તર રોય.” ");
INSERT INTO gbl_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","બીજે દિહી ઈસુવે ગાલીલ ભાગા એછે જાઅના વિચાર કોઅયો, તોવે ફિલિપ ચ્યાલ મિળ્યો, તોવે ઈસુવે ચ્યાલ આખ્યાં, “મા શિષ્ય બોન.” ");
INSERT INTO gbl_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ફિલિપ તે આંદ્રિયાસ એને પિત્તરા ગાવા બેતસાદા ગાવા રોનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ફિલિપાલ નતનએલ મિળ્યો તોવે ચ્યાલ આખ્યાં, “આમહાન તી માઅહું મિળ્યહા, જ્યા બારામાય મૂસા નિયમશાસ્ત્ર માય એને ભવિષ્યવક્તાહાય લોખલાં આતા, તો નાજરેત ગાવામાઅને યોસેફા પોહો ઈસુ હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","નતનએલે ફિલિપાલ પુછ્યાં, “કાય કાદી હારી વસ્તુ બી નાજરેત ગાવામાઅને નિંગી હોકતી હેય કા?” ફિલીપાય નતનએલાલ જવાબ દેનો, “તું યેઇન એઈલે.” ");
INSERT INTO gbl_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ઈસુવે નતનએલાલ ચ્યાપાય યેતો એઇન ચ્યા બારામાય આખ્યાં, “એઆ, ઓ હાચ્ચો ઈસરાયેલી હેય, ચ્યામાય કાયજ જુઠા નાંય મીળે.” ");
INSERT INTO gbl_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","નતનએલાય ઈસુલ પુછ્યાં, “તું માન કેહેકે વોળાખતોહો?” ઈસુવે ચ્યાલ જવાબ દેનો, ચ્ચા પેલ્લા કા ફિલિપે તુલ હાદ્યો, “જોવે તું અંજીરા જાડા તોળે આતો, તોવે તુલ માયે દેખ્યેલ.” ");
INSERT INTO gbl_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","તોવે નતનએલાય ઈસુલ આખ્યાં, “ઓ ગુરુજી, તું પોરમેહેરા પોહો હેય, તું ઈસરાયેલ દેશા મહારાજા હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ઈસુવે ચ્યાલ આખ્યાં, “કાય તું બોરહો યાહાટી કોઅતોહો કા માયે તુલ ઈ આખ્યાં કા માયે તુલ અંજીરા જાડા તોળે દેખ્યો? તું યા કોઅતા મોઠે-મોઠે કામે એઅહે.” ");
INSERT INTO gbl_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","પાછે ઈસુવે ચ્યાલ આખ્યાં, “આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ કા, હોરગા ઉગડી જાતા એને પોરમેહેરા હોરગા દૂતહાન માઅહા પોહાવોય ઉતતા એને ઉચે જાતા એએહા.” ");
INSERT INTO gbl_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ચ્યા પાછે તીજે દિહી ગાલીલ ભાગા કાના ગાવામાય યોક વોરાડ આતા, ઈસુવા આયહો બી તાં આતી. ");
INSERT INTO gbl_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ઈસુ એને ચ્યા શિષ્યબી વોરાડામાય નિમંત્રિત કોઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","જોવે દારાખા રોહો પારવાઈ ગીયો તોવે ઈસુવા આયહે ચ્યાલ આખ્યાં, “ચ્યાહાપાય દારાખા રોહો ઘોટી ગીયહો.” ");
INSERT INTO gbl_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ઈસુવે ચ્ચેલ આખ્યાં, “આયા, તું માન કાહા આખતીહી? ખ્રિસ્તા રુપામાય મા વોળાખ કોઆહાટી આજુ મા સમય નાંય યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","બાકી ઈસુવા આયહે ચાકારાહાન આખ્યાં, “તો જેહે આખે તેહે કોઆ.” ");
INSERT INTO gbl_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","તાં યહૂદીયાહા ધાર્મિક નિયમા પરમાણે આથ દોવના રુડી આતી, એહેકેન કોઅરાહાટી ચ્યાહાય દોગડા છ વેંડલે થોવલે આતેં, યોકા યોકામાય બેબુન, તીતુન મણ (યોક મણ = વિહી લીટર લગભગ) પાઆઈ બોઆય એહેકેન ચ્યે આતેં. ");
INSERT INTO gbl_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ઈસુવે ચાકારાહાન આખ્યાં, “વેંડલાહામાય પાઆય બોઆ” ચ્યાહાય ઉપે લોગુ બોઓઈ દેના. ");
INSERT INTO gbl_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","પાછે ઈસુવે ચાકારાહાન આખ્યાં, “આમી કાડા એને ખાઅના કારબાર્યા પાય લેય જાયા” ચ્યા લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","એને ખાઅના કારબાર્યાય દારાખા રોહો બોની ગીઅલા પાઆય ચાખ્યાં, આજુ ઓ દારાખા રોહો કેછને હેય તીં તો નાંય જાંઅતો આતો, બાકી જ્યા ચાકારાહાય પાઆય કાડયેલ ચ્યા જાઅતા આતા, તોવે કારબાર્યે વોવડાલ હાદિન, ચ્યાલ આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","“કાદાબી માઅહું હારો દારાખા રોહો પેલ્લા પીયાંહાટી દેહે, જોવે બોદા લોક દારાખા રોહો પીન મોરસાય જાતહા, તોવે બોદહાય પિદાં પાછે ઓળકો દારાખા રોહો પિયાં દેહે, બાકી તુયે હારો દારાખા રોહો આમી લોગુ રાખી થોવ્યહો.” ");
INSERT INTO gbl_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ઈસુય ગાલીલ ભાગા કાના ગાવામાય ચ્યા ચમત્કારહા શુરવાત કોઇન ચ્યા મહિમા કોઅયી, એને ચ્યા શિષ્યહાય ચ્યાવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ચ્યા પાછે ઈસુ એને ચ્યા આયહો, ચ્યા બાહા, એને ચ્યા શિષ્ય કાપરનાહુમ ગાવામાય ગીયે એને તાં વોછા દિહી રિયે. ");
INSERT INTO gbl_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","જોવે યહૂદીયાહા પાસ્કા સણા વોછા દિહી રિયા તોવે ઈસુ યેરૂસાલેમ શેહેરામાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","દેવાળામાય ચ્યે ડોબેં, ગેટેં, એને કબુતર વેચનારાહાલ એને પોયહા બોદલી દેનારાહાન બોઠલા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","તોવે ચ્યે આસડેકોઈન યોક ચોપકો બોનાવ્યો, એને બોદા ડોબહાન એને ગેટહાન દેવાળામાઅને બાઆ કાડી દેના એને પોયહા બોદલી દેનારાહા પોયહા ચ્યે વેરી દેના, ચ્યાહા ટેબાલ કોથલાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","એને કબુતર વેચનારાહાલ ચ્યે આખ્યાં, “યાહાન બાઆ લેય જાયા, એને મા આબહા દેવાળાલ આટ બાઆના ગુઉ મા બોનાવાહા.” ");
INSERT INTO gbl_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","તોવે ચ્યા શિષ્યહાન યાદ યેના કા એહેકોય લોખલાં હેય કા? “તો ગોઆ ભક્તિ મા આંદાર આગડા રોકી હોલગેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","તોવે યહૂદીયાહા આગેવાનહાય ચ્યાલ આખ્યાં, “તું આમહાન કોઅહા ચિન્હ દેખાડી હોકતોહો, જ્યેકોય આમા ઈ જાઈ હોકજે કા તુલ એહેકેન કોઅના ઓદિકાર હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ઈસુવે ચ્યાહાન જાવાબ દેનો, “ઈ મંદિર તોડી પાડા, એને આંય તીન દિહામાય પાછો બોનાવી દિહી.” ");
INSERT INTO gbl_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","યહૂદીયાહા આગેવાનહાય ચ્યાલ આખ્યાં, “ઈ દેવાળા બાંદતા છેંતાળી વોરહે લાગ્યેં, એને કાય તું ચ્યાલ તીન દિહાહામાય બોનાવી દેહે?” ");
INSERT INTO gbl_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","બાકી ઈસુ ચ્યા શરીરાલ દેવાળા રુપામાય વાત કોઇ રિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","યાહાટી ઈસુવા મોઅલા માઅને પાછો જીવી ઉઠના પાછે શિષ્યહાન ચ્યા ઈ વાત યાદ યેની. એને ચ્યાહાય પવિત્રશાસ્ત્ર એને ઈસુ આખલા વચનાવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","જોવે ઈસુ યેરૂસાલેમ શેહેરામાય પાસ્કા સણામાય આતો, તોવે બોજ લોકહાય ચ્યા ચમત્કારાહાલ એઇન ચ્યાવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","બાકી ઈસુય બોરહો નાંય કોઅયો કા ચ્યાહાય ઈસુવોય બોરહો કોઅલો હેય, કાહાકા તો બોદા માઅહા મોના વિચાર જાંઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ચ્યાલ કાદા માઅહા ગોરાજ નાંય આતી કા, માઅહા બારામાય ચ્યાલ આખે, કાહાકા તો જાંઅતો આતો કા માઅહા મોનામાય કાય હેય? ");
INSERT INTO gbl_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","નિકોદેમુસ નાંવા યોક માટડો આતો, તો યહૂદીયાહા મોઠી સોબાયે આગેવાન આતો, તો યોક પોરૂષી બી આતો. ");
INSERT INTO gbl_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","તો રાતી ઈસુવાપાય યેનો, એને ચ્યાલ આખ્યાં કા, “ઓ ગુરુજી, આમહાન ખોબાર હેય કા, પોરમેહેરાય તુલ આમહાન હિકાડાંહાટી દોવાડલો હેય, કાહાકા જ્યા ચમત્કાર તું કોઅતોહો, જોવે પોરમેહેર ચ્યાઆરે નાંય રોય તોવે ચ્યા ચમત્કાર કાદાં માઅહું નાંય દેખાડી હોકે.” ");
INSERT INTO gbl_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ઈસુવે ચ્યાલ જાવાબ દેનો, “આંય તુલ હાચ્ચાં-હાચ્ચાં આખતાહાવ, જોવે માઅહું પાછો જન્મો નાંય લેય તે પોરમેહેરા રાજ્ય નાંય એઇ હોકે.” ");
INSERT INTO gbl_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","નિકોદેમુસે ચ્યાલ આખ્યાં, “માઅહું ડાઆયા ઓઈ ગીયા, પાછે કેહે કોઇન જન્મો લેય હોકે? તો પાછો ચ્યા આયહે બુકામાય ઉરાઈન પાછો જન્મો લેય હોકહે કા?” ");
INSERT INTO gbl_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ઈસુવે જવાબ દેનો, “આંય તુલ હાચ્ચાં-હાચ્ચાં આખતાહાવ, જોવે માઅહું પાઅયા કોઇન એને પવિત્ર આત્માકોય જન્મો નાંય લેય તોવે તો પોરમેહેરા રાજ્યામાય નાંય પ્રવેશ કોઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","કાહાકા માઅહા પાઅને જન્મો શારીરિક જન્મો હેય, એને પવિત્ર આત્માપાઅને જન્મો તો નોવો જન્મો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","તું નોવાય નાંય પામા જોજે, માયે તુલ આખ્યાં કા, તુલ નોવો જન્મો લેઅના જરુરી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","જીં માઅહું પવિત્ર આત્માકોય જોન્મુલા હેય તો વારા હારખો હેય, વારો ગોમે તાં જાહાય, ચ્યા આવાજ તું વોનાતોહો, બાકી તો કેછને યેહે એને કેછ જાહાય, તી તુલ ખોબાર નાંય પોડે.” ");
INSERT INTO gbl_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","નિકોદેમુસે ચ્યાલ પુછ્યાં, “ઈ કેહેકેન શક્ય હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ઈસુવે જવાબ દેનો, “તું ઈસરાયેલ લોકહા ગુરુ હેય, તુલ યો વાતો હોમજી જાં જોજે.” ");
INSERT INTO gbl_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","આંય તુલ હાચ્ચાં-હાચ્ચાં આખતાહાવ, આમા જીં જાંઅજેહે તીંજ આખજેહે, એને આમહાય જીં એઅયા ચ્યા સાક્ષી દેજહે, બાકી આમા જીં આખજેહે ચ્યાવોય તુમા બોરહો નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","જોવે તુમહાન માયે દુનિયામાઅને વાત આખી તોવે ચ્યેવોય તુમા બોરહો નાંય કોએત, તો જોવે હોરગા બારામાય વાત આખું, તોવે ચ્યાવોય તુમા કેહેકે બોરહો કોઅહા? ");
INSERT INTO gbl_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","કાદાં માઅહું હોરગામાય નાંય ગીયહા બાકી કેવળ આંય, માઅહા પોહો હોરગામાઅને નિચે ઉતી યેનહો. ");
INSERT INTO gbl_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","એને જેહેકેન મૂસાય જાડયેમાય પિતળા હાપડાલ ઉચે ચોડવ્યો, તેહે કોઅઈન માન, માઅહા પોહાલ બી ઉચે ચોડાવના જરુરી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","યાહાટી કા, જીં માઅહું માયેવોય બોરહો કોઅહે ચ્યાલ અનંતજીવન મિળહે. ");
INSERT INTO gbl_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","“પોરમેહેરે દુનિયા લોકહાવોય ઓહડા મહાન પ્રેમ કોઅયા, યા લીદે ચ્યા યોકને-યોક પોહાલ બલિદાન કોઇ દેનો, યાહાટી કા જીં કાદાં માઅહું ચ્ચાવોય બોરહો કોઅહે, ચ્યા નાશ નાંય ઓઅય, બાકી ચ્યાલ અનંતજીવન મીળે. ");
INSERT INTO gbl_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","કાહાકા પોરમેહેરે ચ્યા પોહાલ દુનિયા લોકહાવોય ડોંડ દાં નાંય દોવાડયો, બાકી ચ્યાકોય દુનિયા લોકહા તારણ કોઅરાહાટી દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","જીં માઅહું પોરમેહેરા પોહાવોય બોરહો કોઅહે, ચ્યાલ ડોંડ નાંય દી, બાકી જીં માઅહું પોરમેહેરા પોહાવોય બોરહો નાંય થોવે, તો ડોંડ બોગવી ચુકલો હેય, કાહાકા ચ્યે પોરમેહેરા યોકને-યોક પોહાવોય બોરહો નાંય કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","એને ડોંડ દેઅના કારણ ઈંજ હેય કા, ઉજવાડો દુનિયામાય યેનો, બાકી લોકહાય ઉજવાડા કોઅતા આંદારાલ પોસાન કોઅયા, કાહાકા ચ્યાહા કામે ખારાબ આતેં. ");
INSERT INTO gbl_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","કાહાકા જીં માઅહું ખારાબ કામ કોઅહે, તી ઉજવાડા વિરુદ કોઅહે, એને ચ્યા ખારાબ કામહા ખોબાર નાંય પોડા જોજે યાહાટી તી ઉજવાડામાય નાંય યેય. ");
INSERT INTO gbl_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","બાકી જીં માઅહું હાચ્ચાયેવોય ચાલહે, તી ઉજવાડા પાય યેહે, કા ચ્યા કામહા ખોબાર પોડે જ્યેં પોરમેહેરા ઇચ્છાકોય કોઅલે હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ચ્યા પાછે ઈસુ એને ચ્યા શિષ્ય યહૂદીયા વિસ્તારામાય યેના, એને તો તાં ચ્યાહાઆરે રોઇન બાપતિસ્મા દાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","તોવે યોહાનબી એનોન ગાવામાય જીં સામરિયા ભાગા સાલેમ ગાવા પાહાય હેય, તાં બાપતિસ્મા દેતો આતો. કાહાકા તાં બોજ પાઆઈ આતા એને લોક ચ્યાપાય યેઇન બાપતિસ્મા લેતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","કાહાકા યોહાન યે સમયે લોગુ જેલેમાય નાંય કોંડલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","તાં યોહાના શિષ્યહા કાદા યહૂદી માઅહા આરે યહૂદીયાહા ધાર્મિક નિયમા પરમાણે આથ દોવના રુડી બારામાય બોલાબોલી જાયી. ");
INSERT INTO gbl_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","તોવે યોહાના શિષ્યહાય યોહાનાપાય જાયને આખ્યાં, “ઓ ગુરુ, જીં માઅહું યારદેન નોયે ચ્યેમેરે ચ્યાહા આરી આતો, જ્યા બારામાય તુયે આખ્યેલ, એએ, તો આમી બાપતિસ્મા દેહે, એને બોદે ચ્યાપાય જાતહેં.” ");
INSERT INTO gbl_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","યોહાને જાવાબ દેનો, “જાવ લોગુ માઅહાલ હોરગામાઅને નાંય દેનલા જાય, તાંવ લોગુ માઅહું કાય નાંય મેળવી હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","તુમહાય પોતે માન આખતા વોનાયાહા, આંય ખ્રિસ્ત નાંય હેતાઉ, બાકી ચ્યા પેલ્લા દોવાડલો હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","વોવડો વોવડી આરે વોરાડ કોઅઇ લેહે, બાકી વોવડા આર્યો જો ચ્યાપાય ઉબો રોઇન ચ્યા આવાજ વોનાઈન આનંદ કોઅહે, તેહેકેન મા લીદે બી આનંદાકોય બોઆય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","તો બોજ મહત્વપૂર્ણ ઓઈ જાં જોજે, એને આંય વોછો મહત્વપૂર્ણ બોનુ. ");
INSERT INTO gbl_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","“જો હોરગામાઅને યેહે, તો બોદહા કોઅતો મહાન હેય, જો દોરત્યેવોયને યેહે તો દોરત્યેવોયને હેય એને દોરતીજ વાતો કોઅહે, એને જો હોરગામાઅને યેહે તો બોદહા ઉચે હેય. ");
INSERT INTO gbl_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","જીં કાય ચ્યાય એઅયા, એને વોનાલો હેય, ચ્યાજ સાક્ષી દેહે, એને બોજ વોછા લોક ચ્યા સાક્ષીવોય બોરહો કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","બાકી જીં માઅહું ચ્યા સાક્ષી માનહે તો સાબિત કોઅહે કા, પોરમેહેર હાચ્ચો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","કાહાકા, જ્યાલ પોરમેહેરે દોવાડયો તો પોરમેહેરા વાત આખહે, કાહાકા પોરમેહેર ચ્યાલ બો બોદા પવિત્ર આત્મા દેહે. ");
INSERT INTO gbl_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","પોરમેહેર આબહો પોહાવોય પ્રેમ કોઅહે, એને બોદ્યોજ વસ્તુ ચ્યા તાબામાંય દેય દેનહા. ");
INSERT INTO gbl_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","જીં માઅહું પોરમેહેરા પોહાવોય બોરહો કોઅહે, અનંતજીવન ચ્યાજ હેય, બાકી જીં પોરમેહેરા પોહાવોય બોરહો નાંય કોએ, ચ્યાલ અનંતજીવન નાંય મીળે, બાકી પોરમેહેરા ડોંડ ચ્યાવોય બોની રોય.” ");
INSERT INTO gbl_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ઈસુ યોહાના કોઅતા વોદારે શિષ્ય બોનાડીન ચ્યાહાન બાપતિસ્મા દેહે. ઈ પોરૂષી લોકહાન ખોબાર ઓઈ ગીયહી, એહેકેન જોવે પ્રભુ ઈસુલ ખોબાર પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ઈસુ પોતે નાંય બાકી ચ્યા શિષ્ય બાપતિસ્મા દેતા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","તોવે તો યહૂદીયા ભાગ છોડીન, પાછે પોતાના શિષ્યહાઆરે પાછો ગાલીલ ભાગા એછે જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","એને ચ્યાલ સમરૂન ભાગામાય રોઇન જાઅના જરુરી આતા. ");
INSERT INTO gbl_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","યાહાટી તો સમરૂન ભાગામાઅને સુખાર ગાવામાય યેનો, જીં ચ્ચા જાગા પાહે હેય જ્યાલ યાકૂબાય ચ્યા પોહો યોસેફાલ દેનલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","એને યાકૂબાય ખોદ્યેલ તી વેએય બી તાંજ આતી, એને ઈસુ વાટે ચાલતા-ચાલતા થાકી ગીયેલ તોવે તો વેઅયે વોય જાયન બોઠો, એને ઈ વાત બોપાર સમયે જાયી. ");
INSERT INTO gbl_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ચ્યે સમયે યોક સમરૂન ભાગામાય રોનારી યોક થેએ પાઆઈ બોઅરા યેની ઈસુવે ચ્યેલ આખ્યાં, “માન પાઆઈ પાજ.” ");
INSERT INTO gbl_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ચ્યે સમાયે ચ્યા શિષ્ય ગાવામાય ખાઅના વેચાતાં લાં ગીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","તોવે ચ્ચે સમરૂની થેઅયે ચ્યાલ આખ્યાં, “તું યોક યહૂદી હેય, એને આંય સમરૂની થેએ હેત્યાંવ, તે તું માપાયને પીયાંહાટી કાહા પાઆઈ માગતોહો?” કાહાકા યહૂદી લોક સમરૂની લોકહાઆરે કોઅહોજ વ્યવહાર નાંય રાખેત. ");
INSERT INTO gbl_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ઈસુવે ચ્યેલ જાવાબ દેનો, “તું નાંય જાંએ કા પોરમેહેર તુલ કાય દાં માગહે, એને તું નાંય જાંએ કા કું તોવોય પાઆય માગહે. જોવે તું જાઅતી, તે તું માવોઅને ચ્યાલ માગતી એને આંય તુલ પાઆય દેતો જીં જીવન દેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ચ્યે થેએયેય ચ્યાલ આખ્યાં, “ઓ માલિક, તોપાય પાઆઈ બોઅના હાટી કાય સાદાન નાંય હેય, એને વેએય બોજ ઉંડી હેય, તે તુયેપાય પાઆઈ કેછને યેના જીં જીવન દેહે? ");
INSERT INTO gbl_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","કાય તું આમહે વડીલ યાકૂબા કોઅતો મોઠો હેય, ચ્યેજ આમહાન ઈ વેએય દેનહી, એને ચ્યે પોતે એને ચ્યા પાહાહાય એને ડોબહાય પિદાં?” ");
INSERT INTO gbl_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ઈસુવે ચ્યેલ જાવાબ દેયન આખ્યાં, “જીં માઅહું યા પાંઅયામાંઅને પિયે, તો પાછો પિહો ઓરી. ");
INSERT INTO gbl_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","બાકી આંય જીં પાઆય દિહી, તાંમાઅને જીં માઅહું પીયી, તો કાદે દિહે પિહો નાંય ઓરી, બાકી જીં પાઆઈ આંય દિહી, તો ચ્યામાય યોક ઝરો બોની જાય, જીં ચ્યાલ અનંતજીવન દેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ઈ વોનાયને ચ્ચે થેઅયે ચ્યાલ આખ્યાં, “ઓ માલિક, માન પીહી નાંય લાગે એને નાંય પાઆઈ બોઅરાહાટી ઓલે દુઉ યા પોડે યાહાટી તી પાઆઈ માન દે.” ");
INSERT INTO gbl_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ઈસુવે ચ્યેલ આખ્યાં, “જો, તો માટડાલ હાદી લેય યે.” ");
INSERT INTO gbl_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","થેએયે જવાબ દેનો, “આંય વોગાર માટડા હેય” ઈસુય ચ્યેલ આખ્યાં, “તુયે હાચ્ચાં આખ્યાં, ‘આંય વોગાર માટડા હેય.’ ");
INSERT INTO gbl_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","કાહાકા તુયે પાચ માટડાહાન રાખ્યા, એને આમી હેય, તોબી તો માટડો નાંય, ઈ તુયે હાચ્ચાં આખ્યાં.” ");
INSERT INTO gbl_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","થેએયેય ઈસુલ આખ્યાં, “ઓ માલિક, આંય જાંઆઈ ગિઇ તું ભવિષ્યવક્તા હેતો. ");
INSERT INTO gbl_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","આમહે આગલ્યા ડાયહાય યાજ ડોગાવોય ભક્તિ કોઅયી, એને તુમા યહૂદી લોક આખતાહા કા, યેરૂસાલેમ શેહેરુજ તો જાગો હેય જાં ભક્તિ કોઅરા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ઈસુય ચ્યેલ આખ્યાં, “ઓ બાઈ, તું મા વાતવોય બોરહો કોઓ કા એહેકેન સમય યેય રોયહો કા તુમા યા ડોગાવોય એને યેરૂસાલેમ શેહેરામાયબી પોરમેહેર આબહા ભક્તિ નાંય કોઇ હોકહા. ");
INSERT INTO gbl_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","તુમા સમરૂની લોક જ્યાલ નાંય વોળખે ચ્યા ભક્તિ કોઅતેહે, એને આમા યહૂદી લોક જ્યાલ જાંઅજેહે, ચ્યા ભક્તિ કોઅતેહે, કાહાકા તારણ યહૂદીયાહા માઅને હેય. ");
INSERT INTO gbl_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","બાકી તો સમય યેય રિયહો, બાકી યીજ ગીયહો, જોવે હાચ્ચાં ભક્ત પોરમેહેર આબા ભક્તિ આત્માથી એને હાચ્ચાયેથી કોઅરી, કાહાકા પિતા ચ્યાહાટી ઓહોડાજ ભક્તિ કોઅનારાહાન હોદહે. ");
INSERT INTO gbl_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","પોરમેહેર આત્મા હેય, યાહાટી જરુરી હેય કા ચ્યા ભક્તિ કોઅનારે આત્મા એને હાચ્ચાયેથી ભક્તિ કોએ.” ");
INSERT INTO gbl_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","થેઅયેય ઈસુલ આખ્યાં, “આંય જાઅત્યાહાવ કા મસીહ જો ખ્રિસ્ત આખાયેહે, યેનારો હેય, જોવે તો યી, તો આમહાન બોદ્યો વાતો આખી દી.” ");
INSERT INTO gbl_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ઈસુવે ચ્યેલ આખ્યાં, “આંય જો તોઆરે બોલી રિયહો તોજ હેતાંવ.” ");
INSERT INTO gbl_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ઓલહામાય ચ્યા શિષ્ય યેય ગીયા, એને ચ્યા નોવાય પામા લાગ્યા કા તો થેએયે આરે બોલહે, બાકી કાદે નાંય પુછ્યાં, કા “તુલ કાય જોજે?” કા “કાયલા તું ચ્યે આરે બોલતો આતો?” ");
INSERT INTO gbl_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","તોવે તી થેએ વેંડલા તાંજ છોડીન ગાવામાય ગિઇ, એને લોકહાન આખા લાગી. ");
INSERT INTO gbl_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“ઈહીં યા, માયે કોઅલા બોદા કાય આખી દેના, ચ્યા માઅહાલ એઆ, કાય ઓજ તો ખ્રિસ્ત નાંય હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","તોવે ચ્યે ગાવામાઅને નિંગીન ઈસુલ એઅરા ચ્યાપાય યેતે લાગ્યેં. ");
INSERT INTO gbl_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ઓલહામાય ઈસુ શિષ્ય ચ્યાલ વિનાંતી કોઅરા લાગ્યા, “ઓ ગુરુજી, વાયજ ખાય લે.” ");
INSERT INTO gbl_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","બાકી ઈસુય ચ્યાહાન આખ્યાં, “માયેપાંય ઓહડા ખાઅના હેય, જ્યાલ તુમા નાંય જાંએત.” ");
INSERT INTO gbl_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","શિષ્ય ચ્યાહામાય આખતા લાગ્યા કા, “કાય કાદો ચ્યાહાટી ખાઅના લેય યેનલો હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ઈસુવે ચ્યાહાન આખ્યાં, “મા ખાઅના પોરમેહેરા મોરજી પાલન કોઅના હેય જ્યેં માન દોવાડયો, એને ચ્યા કામાલ પુરાં કોઅના હેય, જીં માન હોપલા હેય. ");
INSERT INTO gbl_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","આજુ ચાર મોયના બાકી હેય, પાછે વાડણી યી, એહેકોય તુમા આખતાહા નાંય કા? એઆ, આંય તુમહાન આખતાહાવ, તુમહે ડોળા ઉઠાવીન રાનહાન એઆ, કા ચ્યે વાડણીહાટી પાકી ગીઅલે હેય. ");
INSERT INTO gbl_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","એને પેલ્લેથીજ વાડનારે કામ કોઇ રીઅલે હેય એને ચ્યાહા મજરી મેળવી રીઅલે હેય, એને ચ્યે યે હેય, ચ્યે ચ્યા લોકહાન બેગે કોઇ રીઅલે હેય જ્યેં અનંતજીવન મેળવી. ");
INSERT INTO gbl_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","કાહાકા ઈ વાત ઈહીં હાચ્ચી પોડહે કા, ‘યોક વોઅહે એને વાડહે બિજો.’ ");
INSERT INTO gbl_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","જ્યામાય તુમહાય મેહનાત નાંય કોઅયાહાં તી રાન માયે વાડાહાટી તુમહાન દોવાડયા. બીજહાંય મેહનાત કોઅલી હેય બાકી તુમા ચ્યા પાક યોખઠા કોઅહા.” ");
INSERT INTO gbl_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","માયે કોઅલા બોદા ચ્યાય માન આખ્યાં એહેકેન આખનારી થેઅયે વોનાયને ચ્યા ગાવા બોજ સમરૂની લોકહાય ઈસુવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","યાહાટી જોવે ચ્યા સમરૂનીયા ચ્યાપાય યેય પોઅચ્યા, તોવે ચ્યાહાય ચ્યાલ રાવ્યાં કોઅયા કા, “આમહે આરે ઈહીં રોજે” એને તો બેન દિહી તાં રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","એને આજુ બો બોદા માઅહાય ઈસુ સંદેશના લેદે ચ્યાવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","એને ચ્યાહાય થેએયેલ આખ્યાં, “આમી આમા તો આખલ્યા કોય નાંય બોરહો કોઅજે, કાહાકા આમા પોતે વોનાયા એને જાંઆઈ ગીયા કા ઓ હાચ્ચોજ દુનિયા તારણારો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","પાછે તો બેન દિહી રોયન તાઅને આગલા ગાલીલ ભાગામાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","કાહાકા ઈસુવે પોતેજ સાક્ષી દેનેલ કા ભવિષ્યવક્તાલ પોતા વોતનામાય કાદો નાંય આદર કોએ. ");
INSERT INTO gbl_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","જોવે તો ગાલીલ ભાગામાય યેય પોઅચ્યો તોવે ગાલીલ વિસ્તારા માઅહાય ચ્યા સ્વાગત કોઅયા, કાહાકા જોલે કામે ચ્યાય યેરૂસાલેમ શેહેરામાય પાસ્કા સણા દિહામાય કોઅલે તીં બોદા ચ્યાહાય એઅલા આતા, કાહાકા ચ્યાબી સણામાય ગીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ઈસુ પાછો ગાલીલ ભાગા કાના ગાવામાય યેનો, જાં ચ્યે પાઅયાલ દારાખા રોહો બોનાવ્યેલ. કાપરનાહુમ ગાવામાય યોક રાજા આતો ચ્યા ચાકારા પોહો બિમાર આતો. ");
INSERT INTO gbl_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","જોવે તો ઈ વોનાયોકા ઈસુ યહૂદા વિસ્તાર માઅને ગાલીલ ભાગામાય યેય ગીયહો તોવે તો ચ્યાપાય ગીયો એને ચ્યાલ વિનાંતી કોઅયી કા, યેયન મા પાહાલ હારો કોઓ, કાહાકા તો મોરાં તિયારી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ઈસુવે ચ્યાલ આખ્યાં, “જાવ લોગુ તુમા ચમત્કાર એને ચિન્હ નાંય એઅહા તાંવ લોગુ તુમા બોરહો નાંય કોઅહા.” ");
INSERT INTO gbl_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","રાજા ચાકારે ચ્યાલ આખ્યાં, “ઓ પ્રભુ, મા પોહો મોઓઈ જાય, ચ્યા પેલ્લા ચાલ.” ");
INSERT INTO gbl_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ઈસુ ચ્યાલ આખહે, “જો, તો પોહો જીવતો રોય” તો માટડો ઈસુવા વાત માની ગીયો એને જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","તો આજુ વાટેમાય આતો તાંઉ ચ્યા ચાકાર ચ્યાલ મિળ્યાં ચ્યાહાય ચ્યાલ ખોબાર દેની કા, “તો પોહો જીવતો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ચ્યે ચ્યાહાન પુછ્યાં, “કોઅહે સમયે તો હારો ઓઅરા લાગ્યો?” ચ્યાહાય ચ્યાલ આખ્યાં, “કાલે બોપરેહે યોક વાગે જોરાં ઉતી ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","તોવે આબહો જાંઆઈ ગીયો કા ચ્યેજ સમાયે ઈસુવે ચ્યાલ આખલા, “તો પોહો જીવતો રોય” તોવે તો એને ચ્યા ગોઆવાળહાય બોદહાય ઈસુવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ઈસુવા ઈ બિજા ચિન્હ ચમત્કારા કામ આતા, જોવે તો યહૂદા વિસ્તારામાઅને ગાલીલ ભાગામાય પાછો યેનો. ");
INSERT INTO gbl_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ચ્યા પાછે યહૂદીયાહા સણ આતો, એને ઈસુ યેરૂસાલેમ શેહેરામાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","યેરૂસાલેમ શેહેરામાય યોક મેંડા ફાટાકે પાય પાઅયા કુંડ આતો, હિબ્રુ ભાષામાય ચ્યાલ બેથસદા આખે, એને પાચ વોટલ્યેવાળા કુંડા તાં હેય. ");
INSERT INTO gbl_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ચ્યામાય રોગી, આંદળે, લેંગડે એને લુળે યાહા બોજ મોઠો ટોળો પોડી રોતો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ચ્યા પાઆય આલના વાટ જોવતા આતા, કાહાકા કોવે-કોવે પોરમેહેરા હોરગ્યો દૂત કુંડામાય ઉતીન પાઆય આલવી દેતો આતો, પાઆય આલવ્યા પાછે જો કાદો પેલ્લો પાઅયામાય ઉતે ચ્યા કોઅહિબી બિમારી ઓઅરી બાકી તો હારો ઓઈ જાતો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","તાં યોક માઅહું આતા તો આડાત્રી વોરહાપાઅને બિમાર આતા. ");
INSERT INTO gbl_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","જોવે ઈસુવે ચ્યાલ હુતલો એઇન એને બોજ વોરહાથી પોડલાં હેય એહેકેન માલુમ જાયા તોવે ચ્યાય ચ્યાલ આખ્યાં, “તુલ હારાં ઓઅના મોરજી હેય કા?” ");
INSERT INTO gbl_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","બિમાર માઅહાય ઈસુલ જાવાબ દેનો “ઓ માલિક, માયેપાંય કાદા માઅહું નાંય હેય કા જોવે પાઆય આલવી દેહે તોવે માન કુંડામાય ઉતાડે, આંય ઉતાં કોશિશ કોઅતાહાંવ બાકી મા કોઅતો બિજો પેલ્લો ઉતી પોડહે. ");
INSERT INTO gbl_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ઈસુવે ચ્યાલ આખ્યાં, ઉઠ, તો પાથારી ઉઠાવીન ગોઓ જો.” ");
INSERT INTO gbl_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","તારાત તીં માઅહું હારાં ઓઈ ગીયા એને ચ્યા પાથારી લેઈને જાં લાગ્યો તો આરામા દિહી આતો. ");
INSERT INTO gbl_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","જ્યેં દિહી એહેકેન જાયા તો આરામા દિહી આતો, યાહાટી યહૂદી આગેવાન હારાં ઓઈ ગીઅલા માઅહાલ આખા લાગ્યા, “આજે આરામા દિહી હેય, એને મૂસા નિયમાનુસાર ઠીક નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","બાકી ચ્યે ચ્યાહાન જાવાબ દેનો, “જ્યેં માન હારો કોઅયો ચ્યાય માન આખ્યાં, તો પાથારી લેઈને ચાલ.” ");
INSERT INTO gbl_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ચ્યાહાય ચ્યાલ પુછ્યાં, “તો કું હેય, જ્યાંય તુલ આખ્યાં, તો પાથારી લેઈને ચાલ?” ");
INSERT INTO gbl_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","બાકી જો હારો જાયલો માઅહું તો નાંય જાંઆય કા તો કું હેય, કાહાકા બો બોદા લોક આતા ચ્યામાય ઈસુ આડવા ઓઈ ગીયેલ. ");
INSERT INTO gbl_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ચ્યા પાછે તી માઅહું ઈસુલ દેવાળા બાઆપુર મિળ્યો, તોવે ચ્યાલ આખ્યાં, “એએ, તું હારો ઓઈ ગીયો, આમીને પાપ કોઅના નાંય, કોઅહે તે તોવોય પેલ્લા કોઅતા મોઠી આબદા તોવોય પોડી.” ");
INSERT INTO gbl_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ચ્યા માઅહાય જાયને યહૂદી આગેવાનાહાન આખી દેના કા, “ઈસુવે માન હારો કોઅયેલ.” ");
INSERT INTO gbl_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","યાહાટી યહૂદીયાહા આગેવાન ઈસુવાલ સોતાવા લાગ્યા, કાહાકા તો આરામા દિહી ઓહડે કામ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","બાકી ઈસુવે ચ્યાહાન આખ્યાં, “મા આબો પોરમેહેર સાદા કામ કોઅહે, એને માન બી કામ કોઅરા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ઈસુય એહેકોય આખ્યાં ચ્યાહાટી યહૂદી આગેવાન ચ્યાલ માઆઇ ટાકાં કોશિશ કોઅરા લાગ્યા, કાહાકા તો આરામા દિહી નાંય પાળે ઓલહાંજ નાંય, બાકી પોરમેહેરાલ મા આબો આખીન, આંય પોતે પોરમેહેરા રોકો હેતાંવ એહેકેન આખતો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, પોહો પોતે કાય નાંય કોઅય હોકે, તો કેવળ તીંજ કોઇ હોકહે, તો તીંજ કોઅહે, જીં તો આબહાલ કોઅતો એએહે, કાહાકા જીં કાય આબહો કોઅહે, તીંજ પોહોબી કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","કાહાકા આબહો પાહાલ પ્રેમ કોઅહે એને પોતે જીં કોઅહે તીં બોદા પોહાલ દેખાડેહે, એને તો યા કોઅતા આજુ મોઠા કામ પોહાલ દેખાડી, કા ચ્યાહાટી તુમહાન નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","કાહાકા જેહેકેન આબહો મોઅલા લોકહાન જીવતો કોઅહે, તેહેકેન પોહોબી ચ્યા મોરજી પરમાણે મોઅલા લોકહાન જીવતા કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","એને આબહો કાદા ન્યાય નાંય કોએ, બાકી ન્યાય કોઅના બોદા કામ પોહાલ હોઅપી દેનલા હેય. ");
INSERT INTO gbl_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","યાહાટી બોદા લોકહાન જેહેકેન આબહા આદર કોઅતેહે, તેહેકેન પોહા બી આદર કોઅરા જોજે, જો પોહા આદર નાંય કોએ, તો આબહા જ્યાંય પોહાલ દોવાડયોહો, આદર નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, જીં માઅહું મા વચન વોનાયેહે એને માન દોવાડયોહો ચ્યા પોરમેહેરાવોય બોરહો કોઅહે, અનંતજીવન ચ્યાલ મિળી ગીયહા, ચ્યાલ ડોંડ નાંય દી, બાકી અનંતકાળના મોરણા માઅને બોચી ગીયહો એને પેલ્લો અનંતજીવનામાય જાય હોકહયો.” ");
INSERT INTO gbl_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","“આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ કા, ઓહડો સમય યી રોયહો, બાકી યેય ગીયહો, જોલે મોઅલે માઅહે પોરમેહેરા પોહા આવાજ વોનાઈ, એને જ્યેં વોનાઈ ચ્યે જીવતે ઓઈ જાય. ");
INSERT INTO gbl_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","કાહાકા જેહેકેન આબહો પોતાનામાય જીવન રાખહે, તેહેકેન ચ્યાય પોહાલ બી ઓદિકાર દેનહો કા પોતાનામાય જીવન રાખે. ");
INSERT INTO gbl_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","બાકી પોહાલ બોદા લોકહાવોય ન્યાય કોઅના બી ઓદિકાર દેનલો હેય, યાહાટી કા તો માઅહા પોહો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ઈ વોનાયને તુમહાન નોવાય નાંય લાગા જોજે, કાહાકા ઓહડો સમય યી રોયહો, કા જોલે મોઅઇ ગીઅલે હેય, પોહા આવાજ વોનાયને જીવતે ઉઠી. ");
INSERT INTO gbl_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","જ્યાહાય હારાં જીવન જીવ્યા ઓરી, ચ્યે અનંતજીવન મિળવાહાટી મોઅલા માઅને પાછા જીવી ઉઠી, એને જ્યાહાય ખારાબ જીવન જીવ્યા ઓરી ચ્યે શિક્ષા બોગવાહાટી પાછે જીવી ઉઠી.” ");
INSERT INTO gbl_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","“આંય પોતે કાય નાંય કોઇ હોકતાહાવ, આંય લોકહા ન્યાય તેહેકેન કોઅતાહાંવ, જેહેકેન પોરમેહેર આબો માન ચ્યાહા ન્યાય કોઅરા આખહે, એને મા ન્યાય હાચ્ચો હેય, કાહાકા આંય મા મોરજયેકોય નાંય ન્યાય કોઉ, બાકી મા દોવાડનારા મોરજયેકોય કોઅહુ. ");
INSERT INTO gbl_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","જોવે આંય પોતા બારામાય સાક્ષી આખું, તોવે મા સાક્ષી હાચ્ચી નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","બાકી યોક બિજો હેય તો મા સાક્ષી દેહે, એને આંય જાઅતાહુ કા મા બારામાય તો જીં સાક્ષી દેહે, તી હાચ્ચી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","તુમહાય યોહાન બાપતિસ્મા દેનારા પાય તુમહે લોકહાન પુછા દોવાડયા, એને ચ્ચાય હાચ્ચી સાક્ષી દેની. ");
INSERT INTO gbl_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","બાકી માન કાદા માઅહા સાક્ષી ગોરાજ નાંય હેય, તેરુંબી માયે તુમહાન ચ્યા સાક્ષી બારામાય આખલા હેય, જીં યોહાન બાપતિસ્મા દેનારાય આખલી આતી, યાહાટી કા તુમા તારણ મેળવી હોકા. ");
INSERT INTO gbl_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","યોહાન બોળતો એને ચોમાકતા દિવા રોકો આતો, એને તુમહાન કોલહાક વાઆ લોગુ ચ્યા ઉજવાડામાય આનંદ કોઅના હારાં ગોમ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","બાકી માયેપાંય યોહાના સાક્ષી કોઅતી મોઠી સાક્ષી હેય, જીં કામ આબહે માન પુરાં કોઅરાહાટી દેનહા, તીંજ કામ જીં આંય કોઅહુ મા બારામાય સાક્ષી દેહે, કા આબહે માન દોવાડલો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","એને આબહે જ્યાંય માન દોવાડયોહો, ચ્યેજ આબહે મા સાક્ષી દેનહી, તુમા નાંય કોઇ દિહી ચ્યા આવાજ વોનાયા, એને નાંય ચ્યાલ હામ્મે-હામ્મે એઅયોહો. ");
INSERT INTO gbl_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","એને તુમા ચ્યા વચન તુમહે મોનામાય વોહતી નાંય કોઅરા દેત, કાહાકા તુમા માયેવોય બોરહો નાંય કોએત, જ્યાલ ચ્યાય દોવાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","પવિત્રશાસ્ત્રા અભ્યાસ કોઅતાહા, કાહાકા તુમા એહેકેન બોરહો કોઅતાહા કા ચ્યામાય તુમહાન અનંતજીવન મિળી, એને તીંજ પવિત્રશાસ્ત્ર મા બારામાય સાક્ષી દેહે. ");
INSERT INTO gbl_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","તેરુંબી તુમા અનંતજીવન મિળવાહાટી માયેપાંય યા નાંય માગેત. ");
INSERT INTO gbl_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","આંય માઅહા પાયને વાહવા આશા નાંય કોઉ. ");
INSERT INTO gbl_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","બાકી કા આંય તુમહાન જાંઅતાહાંવ તુમા મોનામાય પોરમેહેરાવોય પ્રેમ નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","આંય મા આબહા ઓદિકારાહાતે યેનહો, એને તુમા માન નાંય સ્વીકાર કોએ, બાકી જોવે બિજો કાદો પોતા ઓદિકારાકોય યેય તોવે ચ્યાલ તુમા સ્વીકાર કોઇ લાહા. ");
INSERT INTO gbl_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","તુમા માયેવોય બોરહો નાંય કોઇ હોકે, કાહાકા તુમા યોકબીજા પાયને માન હોદતાહા, એને તુમા યોકુજ પોરમેહેરા પાયને માન મિળવા કોશિશ નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","તુમા એહેકેન મા હોમજાહા કા આંય આબા હોમ્મે તુમહાવોય દોષ થોવહી, મૂસા નિયમશાસ્ત્ર, જ્યાવોય તુમહાય આશા રાખીહી, તુમહાવોય દોષ થોવી. ");
INSERT INTO gbl_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","કાહાકા જો તુમા મૂસાવોય બોરહો કોઅતા તે માયેવોય બી બોરહો કોઅતા, કાહાકા ચ્યે મા બારામાય લોખ્યહાં. ");
INSERT INTO gbl_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","બાકી જો તુમા મૂસા નિયમશાસ્રાવોય બોરહો નાંય કોએ, તે તુમા નોક્કી માયેવોય બોરહો કેહેકે કોઅહા?” ");
INSERT INTO gbl_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","યો વાતો જાયો પાછે ઈસુ ગાલીલ દોરિયા એટલે તીબીરીયાસ દોરિયા ચ્યેમેરે ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","યોક મોઠી ગીરદી ચ્યા પાહલા ચાલી, કાહાકા જ્યા નોવાયે ચમત્કાર તો બિમાર્યાહાવોય કોઅતો આતો, ચ્યે ચ્યાહાન એઅતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","તોવે ઈસુ ડોગાવોય ચોડીન ચ્યા શિષ્યહાઆરે તાં બોઠો. ");
INSERT INTO gbl_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","એને યહૂદીયાહા પાસ્કા સણા વોછા દિહી બાકી આતા. ");
INSERT INTO gbl_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","તોવે ઈસુવે નોજાર કોઅયી કા ચ્યાપાય બોજ માઅહા ટોળો યેતો દેખ્યો, એને ચ્યે ફિલિપાલ પુછ્યાં, “યે બોદે ખાય હોકે ચ્યાહાટી આપા કેછને બાખે વેચાત્યો લેય યાહુ?” ");
INSERT INTO gbl_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ઈસુય ચ્યા પરીક્ષા કોઅરાહાટી એહેકોય આખ્યાં, કાહાકા તો પોતે જાંઅતો આતો કા તો કાય કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ફિલિપે જાવાબ દેનો, “ચ્યાહામાઅને બોદહાલ વોછા-વોછા દેય તેરુંબી બોસો દીનારા (૨૦૦ દીનાર એટલે બેન હોવ દિહાહા કાંબારાં) બાખે ચ્યાહાન નાંય ફુગી.” ");
INSERT INTO gbl_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ચ્યા શિષ્યહા માઅને સિમોન પિત્તરા બાહા આંદ્રિયાસાય ઈસુલ આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ઈહીં યોક પોહો હેય, ચ્યાપાય પાચ જુવાયે બાખે એને બેન માછલે હેય બાકી ઓલા લોકહાન ઈ કેહેકે ફુગી?” ");
INSERT INTO gbl_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","તોવે ઈસુવે આખ્યાં, “માઅહાન બોહતા કોઆ” ચ્યા જાગામાય બોજ ગાહીયા આતા, તોવે માઅહે ગાહીયાવોય બોહી ગીયે, ચ્યાહામાય માટડા આસરે પાચ ઓજાર આતા. ");
INSERT INTO gbl_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","તોવે ઈસુવે ચ્યો પાચ બાખ્યો લેદ્યો, એને આભાર માનીન ગાહીયાવોય બોઠલા લોકહાન વાટી દેન્યો, તેહેકોઈન માછલે જોલા માગેત તોલા ચ્યાહાન વાટી દેના. ");
INSERT INTO gbl_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","જોવે ચ્યે ખાયન દારાઈ ગીયે, પાછે ઈસુવે ચ્યા શિષ્યહાન આખ્યાં, “ઉગારલા કુટકા યોખઠા કોઆ, કા કાય નોકામ્યા નાંય ઓઈ જાય.” ");
INSERT INTO gbl_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","યાહાટી ચ્યાહાય યોખઠા કોઅયા, તોવે પાચ બાખહી માઅને ઉગારલા કુટકાહા બાર ટોપલ્યો બોઆયો. ");
INSERT INTO gbl_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","લોકહાય ઓ ચમત્કાર એઇન આખ્યાં, “દુનિયામાય જો ભવિષ્યવક્તા યેનારો હેય તો નોક્કી ઓજ હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ઈસુ જાંઆઈ ગીયો કા ચ્યાલ રાજા બોનાવાહાટી ચ્યે માઅહે દોઅરાં કોએત, તોવે તો પાછો ડોગાવોય યોખલોજ જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","જોવે રુવાળા પોડી ગીયા, તોવે ચ્યા શિષ્ય દોરિયા મેરે ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","એને ઉડીમાય ચોડીન દોરિયા ચ્યેમેરે કાપરનાહુમ ગાવા એછે જાં લાગ્યા. ચ્યે સમયે આંદારાં પોડી ગીયા, એને ઈસુ આજુ લોગુ ચ્યાહાપાય નાંય યેનલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","એને તોફાના લીદે દોરિયામાય લાફા ઉસળા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","તોવે જોવે ચ્યા તીન ચાર મીલ (૫ કિલોમીટર લગભગ) ગીયા ઓરી, તોવે ચ્યાહાય ઈસુવાલ દોરીયાવોય ચાલતો એને ઉડી એછે યેતો દેખ્યો, એને ચ્યા બિઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","બાકી ઈસુવે ચ્યાહાન આખ્યાં, “આંય ઈસુ હેતાઉ, બીયહા મા.” ");
INSERT INTO gbl_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ચ્યા ચ્યાલ ઉડીમાય લાં કોએત ઓલહામાય ઉડી તારાત મેરે યેય ગિઇ, જાં ચ્યા જાતા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","બીજે દિહે જ્યેં માઅહે દોરિયા ચ્યેમેરે ઉબલે આતેં ચ્યાહાય ઈ એઅયા, ઈહીં યોક ઉડી સિવાય બીજી ઉડી નાંય આતી, એને ઈસુ ચ્યા શિષ્યહાઆરે ઉડીમાય નાંય ચોડયેલ, બાકી સિવાય ચ્યા શિષ્યજ ગીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","તોવે આજુ વાહને ઉડયે તીબીરીયાસા ચ્યા જાગા પાહી યેને, જાં ચ્યાહાય પ્રભુ આભાર માન્યા પાછે બાખે ખાદેલ. ");
INSERT INTO gbl_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","જોવે ગીરદ્યે એઅયા, કા ઈહીં ઈસુ બી નાંય હેય, એને ચ્યા શિષ્યબી નાંય હેય, તોવે ચ્યે માઅહેબી વાહની-વાહની ઉડ્યેહેમાય બોહીન, ઈસુવાલ હોદા કાપરનાહુમ ગાવામાય પોઅચ્યે. ");
INSERT INTO gbl_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","એને દોરિયા ચ્યેમેરે તો મિળ્યો તોવે ચ્યાહાય ચ્યાલ પુછ્યાં, “ઓ ગુરુ, તું ઈહીં કોવે યેનો?” ");
INSERT INTO gbl_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ઈસુવે ચ્યાહાન જવાબ દેનો કા, “આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, તુમહાય ચમત્કાર એએયો ચ્યાહાટી નાંય, બાકી બાખે ખાયન દારાઈ ગીયે ચ્યાહાટી તુમા માન હોદતેહેં. ");
INSERT INTO gbl_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","જીં ખાઅના બોગડી જાહે ચ્યાહાટી મેહનાત મા કોઅહા, બાકી જીં ખાઅના અનંતજીવના લોગુ ટોકનારા હેય ચ્યાહાટી મેહનાત કોઆ. તી તુમહાન માઅહા પોહો દી, કાહાકા પોરમેહેર આબહે ચ્યાલ એહેકેન કોઅના ઓદિકાર દેનલો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ચ્યાહાય ઈસુલ પુછ્યાં, “પોરમેહેરા કામ કોઅરાહાટી આમહાય કાય કોઅરા જોજે?” ");
INSERT INTO gbl_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ઈસુવે ચ્યાહાન જાવાબ દેનો, પોરમેહેરા મોરજી ઈ હેય, કા “પોરમેહેરાય જ્યાલ દોવાડયોહો, ચ્યાવોય તુમહાય બોરહો કોઅરા જોજે.” ");
INSERT INTO gbl_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","તોવે ચ્યાહાય ઈસુલ પુછ્યાં, “તું કાય ચિન્હ દેખાડતોહો કા તી એઇન તોવોય આમા બોરહો કોઅજે? તું કોઅહા કામ દેખાડતોહો? ");
INSERT INTO gbl_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","આપહે આગલ્યા ડાયહાય ઉજાડ જાગામાય બાખે (માન્ના) ખાદી, એહેકેન લોખલાં હેય કા મૂસાય ચ્યાહાન હોરગામાઅને બાખે દેની.” ");
INSERT INTO gbl_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","તોવે ઈસુવે આખ્યાં, “આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, મૂસાય તુમહાન હોરગામાઅને બાખે નાંય દેની, બાકી મા આબહો તુમહાન હાચ્ચી હોરગામાઅને બાખે દેહે. ");
INSERT INTO gbl_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","કાહાકા જીં બાખે હોરગામાઅને યેહે એને દુનિયા લોકહાન જીવન દેહે, તીજ પોરમેહેરા બાખે હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","તોવે ચ્યાહાય આખ્યાં, “ઓ પ્રભુ, ઈ બાખે આમહાન કાયામ દેજે.” ");
INSERT INTO gbl_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ઈસુવે ચ્યાહાન આખ્યાં, “જીં બાખે જીવન દેહે તી આંય હેતાઉ, જો કાદો માયેપાંય યેહે તો કોદહીજ બુખો નાંય ઓઅઇ, એને જો કાદો માયેવોય બોરહો કોઅહે તો કોદહીજ પીહ્યો નાંય ઓઅઇ. ");
INSERT INTO gbl_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","બાકી માયે તુમહાન પેલ્લા આખલા આતા, તુમહાય માન એઅયા પાછે બી બોરહો નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","આબહે માન જ્યા લોક દેનહા, ચ્યા બોદા માયેપાંય યી, એને જીં માઅહું માયેપાંય યી ચ્યાલ આંય નાંય કાડહીં. ");
INSERT INTO gbl_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","કાહાકા આંય મા મોરજી પુરી કોઅરાહાટી નાંય, બાકી જ્યેં માન દોવાડયોહો ચ્યા મોરજી પુરી કોઅરાહાટી હોરગામાઅને યેનહો. ");
INSERT INTO gbl_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","એને માન દોવાડનારા મોરજી ઈ હેય કા, ચ્યે માન બોદા કાય દેનહા, ચ્યામાઅને કાયબી ટાકાય નાંય, બાકી છેલ્લે દિહી આંય જીવતો કોઉ. ");
INSERT INTO gbl_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","કા ઈજ મા આબહા મોરજી હેય, કા જીં માઅહું પોહાલ એએ એને ચ્યાવોય બોરહો કોએ તો અનંતજીવન મિળવે, એને ચ્યાલ આંય છેલ્લે દિહે જીવતો ઉઠાડીહી.” ");
INSERT INTO gbl_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ઈસુવે એહેકેન આખ્યેલ કા, “આંય હોરગામાઅને ઉતી યેનલી બાખે હેતાઉ, ચ્યાહાટી યહૂદીયા ટુટારતા લાગ્યા.” ");
INSERT INTO gbl_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","એને ચ્યાહાય આખ્યાં, “ઓ યોસેફા પોહો ઈસુ હેય કા નાંય, ચ્યા આયહે-આબહાલ આપા વોળાખજેહે? તોવે તો એહેકેન કાહા આખહે કા આંય હોરગામાઅને યેનહો?” ");
INSERT INTO gbl_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ઈસુવે જવાબ દેનો, “તુમા તુમહામાય કુરકુર મા કોઅહા. ");
INSERT INTO gbl_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","કાદો માયેપાંય નાંય યેય હોકે, જાવ લોગુ આબહો, જ્યાંય માન દોવાડયો, ચ્યાલ મા એછે ખેચી નાંય લેય, એને આંય છેલ્લે દિહે પાછો જીવતો કોઅહી. ");
INSERT INTO gbl_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ભવિષ્યવક્તાહા લેખ માય એહેકેન લોખલાં હેય કા, ચ્યે બોદે પોરમેહેરાપાઅને હિકાડલે રોય. જીં કાદાં પોરમેહેર આબહા પાઅને વોનાલા એને હિકલાં હેય, તીંજ માયેપાંય યેહે. ");
INSERT INTO gbl_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","કાદાય પોરમેહેર આબહાલ નાંય દેખહયો, બાકી જો પોરમેહેરાપાઅને યેનહો, ચ્યાય પોરમેહેર આબહાલ દેખ્યહો. ");
INSERT INTO gbl_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ કા જો કાદો બોરહો કોઅહે, ચ્યાલ અનંતજીવન મિળલા હેય. ");
INSERT INTO gbl_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","જીં બાખે જીવન દેહે તી આંય હેતાઉ. ");
INSERT INTO gbl_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","તુમહે આગલ્યા ડાયહાય ઉજાડ જાગામાય માન્ના ખાદાં એને મોઓઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","બાકી હોરગામાઅને યેનલી બાખે ઓહડી હેય કા તી જોવે કાદો ખાય તે તો નાંય મોએ. ");
INSERT INTO gbl_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","જીવના બાખે જીં હોરગામાઅને ઉતી યેનલી હેય તી આંય હેય. યે બાખ્યેમાઅને જોવે કાદો ખાય, તો સદાકાળ જીવી, એને જીં બાખે આંય દિહી તી દુનિયા લોકહા જીવનાહાટી મા શરીર હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","તોવે યહૂદી આગેવાન, ચ્યાહા ચ્યાહામાય બોજ બોલાબોલી કોઅતા લાગ્યા, એને ચ્યાહાય આખ્યાં, “ઈ માઅહું કેહેકેન આમહાન ચ્યા શરીર ખાં દી હોકહે?” ");
INSERT INTO gbl_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ કા, જોવે તુમા માઅહા પોહા શરીર નાંય ખાહા એને ચ્યા લોય નાંય પીયહા તોવે તુમહેમાય જીવન નાંય રોય. ");
INSERT INTO gbl_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","બાકી જીં માઅહું મા શરીર ખાહે, એને મા લોય પીઅરી, ચ્યાલ અનંતજીવન મિળી ગીયહા એને ચ્યાલ આંય છેલ્લે દિહે પાછો જીવતો કોઅહી. ");
INSERT INTO gbl_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","કાહાકા મા શરીર હાચ્ચાં ખાઅના હેય એને મા લોય હાચ્ચાં પિઅના હેય. ");
INSERT INTO gbl_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","જીં માઅહું મા શરીર ખાહાય એને મા લોય પીઅરી તો માંયેમાય રોહોય એને આંય ચ્યામાય રોહુ. ");
INSERT INTO gbl_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","જેહેકેન જીવતા આબહે માન દોવાડયોહો એને આંય આબહા લેદે જીવતો હેતાંવ, તેહેકેન તોબી જો મા શરીર ખાહે તો મા લેદે જીવતો રોય. ");
INSERT INTO gbl_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ઈ બાખે તીજ હેય, જીં હોરગામાઅને યેનલી હેય, જેહેકેન તુમહે આગલ્યા ડાયહાય ખાદી એને ચ્યા મોઅઇ ગીયા, તોહડી બાખે નાંય, ઈ બાખે જીં માઅહું ખાય, તો સાદા જીવતો રોય.” ");
INSERT INTO gbl_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ઈસુ કાપરનાહુમ ગાવામાય ચ્યાહાન યોક સોબાયે ઠિકાણે હિકાડે તોવે ચ્યાહાન એહેકેન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","તોવે ચ્યા શિષ્યહા માઅને બો બોદહાય ઈ વોનાયને આખ્યાં, “ઈ વાત કોઠાણ હેય, ઈ કું માની હોકહે?” ");
INSERT INTO gbl_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ઈસુય મોનામાય ઈ જાંઅયા કા ચ્યા શિષ્ય એહેકેન ટુટરીયા કોઅતાહા એને ચ્યે ચ્યાહાન આખ્યાં, “કાય ઈ તુમહાન માયેવોય બોરહો કોઅરા રોકહે? ");
INSERT INTO gbl_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","એને જોવે તુમા માઅહા પોહાલ જાં તો પેલ્લો આતો તાં ઉચે ચ્યાલ પાછો જાતો એઅહા, તોવે કાય ઓઅરી? ");
INSERT INTO gbl_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","આત્મા જીવન દેહે, શરીરાકોય કાય ફાયદો નાંય. જ્યો વાતો માયે તુમહાન આખ્યો તી આત્મા હેય, એને જીવન બી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","બાકી તુમહેમાઅને કોલાહાક એહેકેન હેય જ્યા ચ્યાવોય બોરહો નાંય કોએત,” કાહાકા ઈસુ ઈ જાંઅતો આતો કા જ્યેં બોરહો નાંય કોએત, ચ્યે કું હેય, એને કું માન દોઅવાડી દી. ");
INSERT INTO gbl_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","એને ચ્યે આખ્યાં, “યાહાટી માયે તુમહાન આખ્યેલ કા જાવ લોગુ કાદા માઅહાલ પોરમેહેરાપાઅને ઈ વરદાન નાંય દી હોકે, તાંવ લોગુ તી માયેપાંય નાંય યી હોકે.” ");
INSERT INTO gbl_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ચ્યા પાછે ઈસુ શિષ્યહા માઅને બોજ શિષ્ય પાછાડી ઓટી ગીયા, એને ચ્યાલ છોડીન જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","તોવે ઈસુવે બાર શિષ્યહાન આખ્યાં, “તુમાબી છોડીન જાતા રા કોઅતા કા?” ");
INSERT INTO gbl_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","સિમોન પિત્તરે ચ્યાલ જાવાબ દેનો, “ઓ પ્રભુ, આમા કા પાય જાજે? અનંતજીવના વાતો તોપાય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","એને આમા બોરહો કોઅજેહે એને જાંઆઈ ગીયા કા પોરમેહેરા પવિત્ર માઅહું તુંજ હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ઈસુવે ચ્યાહાન જાવાબ દેનો, “માયે તુમહાન બાર જાંણહાન નિવડી લેદા નાંય કા? તેરુંબી તુમહામાઅને યોક માઅહું સૈતાના તાબામાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ઈ ચ્યાય તો સિમોના પોહો યહૂદા ઇસ્કારીયોતા બારામાય આખ્યાં, કાહાકા તો બાર શિષ્યહા માઅને યોક આતો, તો ઈસુલ દોઅઇ દેનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ચ્યા પાછે ઈસુ ગાલીલ ભાગામાય ફિરતો રિયો, કાહાકા યહૂદી આગેવાન ચ્યાલ માઆઇ ટાકાં હોદેત, યાહાટી ચ્યાય યહૂદા વિસ્તારમાય ફિરા વિચાર નાંય કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","આમી યહૂદીયાહા માંડવા સણ પાહાય આતો, ");
INSERT INTO gbl_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","યાહાટી ચ્યા બાહાહાય ચ્યાલ આખ્યાં, “ઇહિને યહૂદીયા વિસ્તારમાય જો, કા જીં કામ તું કોઅતોહો, તી તો શિષ્યહાય બી એઅરા જોજે. ");
INSERT INTO gbl_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","જોવે તો એહેકેન ઇચ્છા હેય કા લોક તો બારામાય જાંએ, તો તુલ બોદહા હામ્મે કામહાલ કોઅરા જોજે, જો તું ઈ કામ કોઅતોહો, તો પોતાલ દુનિયામાય પ્રગટ કોઇ દે.” ");
INSERT INTO gbl_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","કાહાકા ચ્યા બાહા બી ચ્યાવોય બોરહો નાંય કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ઈસુવે ચ્યાહાન આખ્યાં, “આજુ મા સમય નાંય યેનહો, બાકી તુમહેહાટી બોદો સમય યોગ્ય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","દુનિયા લોક તુમહેઆરે આડાઇ નાંય કોઇ હોકે, બાકી મા આરે આડાઇ કોઅતેહે, કાહાકા આંય ચ્યાહા વિરુદ સાક્ષી દેતહાવ કા ચ્યાહા કામે ખારાબ હેય. ");
INSERT INTO gbl_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","તુમા સણામાય જાયા, આંય આમી નાંય જાવ, કાહાકા આજુ મા સમય નાંય યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","તો ચ્યાહાઆરે વાતો કોઇન ગાલીલ ભાગામાય રોય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","બાકી ચ્યા બાહા સણામાય ગીયા, તોવે તોબી ખુલ્લી રીતે નાંય, બાકી ગુપ્તમાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","યહૂદી આગેવાન સણા દિહામાય ચ્યાલ હોદેત એને ચ્યા આખે, “એલો કેછ હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","એને લોકહા ટોળામાય ચ્યા બારામાય દૂરે-દૂરે બોજ વાતો કોઅયો, કોલહાક લોક આખતા આતા, “તો હારો માઅહું હેય” એને કોલહાક આખતા આતા, “નાંય, તો લોકહાન છેતરેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","તેરુંબી યહૂદી આગેવાનહા દાકે કાદાં માઅહું ચ્યા બારામાય ખુલ્લી રીતે નાંય બોલે. ");
INSERT INTO gbl_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","એને સણા આરદા દિહી પારવાઈ ગીયા તોવે ઈસુ દેવાળામાય જાયને હિકાડતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","તોવે યહૂદી આગેવાનહાય નોવાય પામીન આખ્યાં, “તો પવિત્રશાસ્ત્ર માઅને કોદહી નાંય હિક્યહો તે કેહેકેન આવડી ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","તોવે ઈસુવે જાવાબ દેનો કા, “મા શિક્ષણ મા નાંય હેય, બાકી પોરમેહેરા હેય, જ્યાંય માન દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","જો કાદાં માઅહું ચ્યા ઇચ્છા પુરી કોઅરા માગહે તોવે ચ્યાલ ખોબાર પોડી કા મા શિક્ષણ પોરમેહેરા પાયને હેય કા પોતા કોઇન આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","જીં માઅહું પોતા કોઇન આખહે, તો પોતા વાહાવા કોઆડેહે, બાકી જીં માઅહું ચ્યાલ દોવાડનારા વાહવા કોઅહે તોજ ઈમાનદાર હેય એને ચ્યામાય કાય લુચ્ચાઈ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","કાય મૂસાએ તુમહાન નિયમશાસ્ત્ર નાંય દેનહો કા? તેરુંબી તુમહામાઅને કાદો નિયમ નાંય પાળે, તો તુમા માન કાહા માઆઇ ટાકાં હોદતાહા?” ");
INSERT INTO gbl_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","લોકહાય ચ્યાલ જાવાબ દેનો, “તુલ બુત વોળાગલો હેય, તુલ કું માઆઇ ટાકાં હોદહે?” ");
INSERT INTO gbl_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ઈસુવે ચ્યાહાન જાવાબ દેનો, “માયે યોક ચમત્કાર કોઅયા, એને તુમહાન બોદહાન ચ્યા નોવાય લાગી. ");
INSERT INTO gbl_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","મૂસાયે તુમહાન સુન્નત કોઅના આગના દેનલી હેય, એને તુમા આરામા દિહી માઅહા સુન્નત કોઅતાહા. તી આગના મૂસા નાંય હેય, બાકી આગલ્યા ડાયહા પાઅને ચાલતી યેનલી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","જોવે મૂસા નિયમશાસ્ત્ર નાંય તોડાં હાટી તુમા આરામા દિહે માઅહા સુન્નત કોઅતાહા, તે માયે આરામા દિહે યોક માઅહાલ હારો કોઅયો, યાહાટી તુમા કાહા ખિજવાઈ ગીયા? ");
INSERT INTO gbl_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","મું એઇન ન્યાય નાંય કોઅતા, બાકી યોગ્ય ન્યાય કોઆ.” ");
INSERT INTO gbl_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","કોલાહાક યેરૂસાલેમ શેહેરાવાળા આખે, “કાય ઓ તો નાંય હેય યહૂદી આગેવાન માઆઇ ટાકાં કોશિશ કોઅતાહા? ");
INSERT INTO gbl_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","બાકી એઆ, તો તે બોદહા હોમ્મે વાતો કોઇ રિઅલો હેય, એને કાદો ચ્યાલ કાય નાંય આખે, એને આગેવાન લોકહાન ખાત્રી જાયી કા ઓજ ખ્રિસ્ત હેય? ");
INSERT INTO gbl_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","યાલ તે આમા વોળાખજેહે, ઓ કેછને હેય, બાકી ખ્રિસ્ત જોવે યી, તો કાદો નાંય જાઅરી કા તો કેછને હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","તોવે ઈસુવે દેવાળામાય હિકાડતા મોઠેરે બોંબલીન આખ્યાં, “તુમા માન વોળાખતાહા એને ઈ બી જાંઅતાહા કા આંય કેછને હેતાઉ. બાકી આંય પોતા કોઓઇ નાંય યેનહો, બાકી જ્યેં માન દોવાડયોહો તો હાચ્ચો હેય ચ્યાલ તુમા નાંય વોળખે. ");
INSERT INTO gbl_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","બાકી આંય ચ્યાલ વોળાખતાહાવ, કાહાકા આંય ચ્યાપાઅને યેનહો એને ચ્યે માન દોવાડયોહો.” ");
INSERT INTO gbl_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","યાહાટી યહૂદી આગેવાન ચ્યાલ દોઅરાં કોએત, બાકી તેરુંબી કાદે ચ્યાલ આથ નાંય લાવ્યો, કાહાકા આજુ લોગુ ચ્યા સમય નાંય યેનેલ. ");
INSERT INTO gbl_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","એને લોકહા ગીરદ્યેમાઅને બોજ જાઅહાય ચ્યાવોય બોરહો કોઅયો, એને આખા લાગ્યા, “ખ્રિસ્ત જોવે યી તોવે યા કોઅતા વોદારી ચમત્કાર કોઇ દેખાડી કા જ્યેં યાય દેખાડયે?” ");
INSERT INTO gbl_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","પોરૂષીયાહાય લોકહાન ચ્યા બારામાય યો વાતો દૂરે-દૂરે કોઅતા વોનાયા, એને મુખ્ય યાજક એને પોરૂષીયાહાય દોઅરાંહાટી દેવાળા રાખવાળ્યા દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","તોવે ઈસુવે આખ્યાં, “આંય થોડીવાઆ લોગુ તુમહેઆરે હેતાઉ, ચ્યા પાછે જ્યાંય માન દોવાડયો ચ્યાપાય ફિરી જાહીં. ");
INSERT INTO gbl_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","તુમા માન હોદાહા બાકી આંય તુમહાન નાંય મીળહી એને આંય જાં રોહુ તાં તુમહાન નાંય યેવાયી.” ");
INSERT INTO gbl_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","તોવે યહૂદી આગેવાન યોક બીજહાન આખા લાગ્યા, “તો કેછ જાય કા પોતે આપહાલ તો નાંય મિળી? કાય તો ગેર યહૂદી લોકહાપાંય જાય જ્યેં યુનાની લોકહામાય રોતેહેં, એને યુનાની લોકહાનબી હિકાડી કા? ");
INSERT INTO gbl_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","તો કાય આખા માગહે કા, ‘તુમા માન હોદહા, બાકી આંય તુમહાન નાંય મીળહી, એને જાં આંય હેય, તાં તુમા નાંય યી હોકે?’” ");
INSERT INTO gbl_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","પાછે સણા છેલ્લે દિહે, મતલબ મુખ્ય દિહી આતો, ઈસુ ઉબો રોયન મોઠેરે બોંબલીન આખ્યાં, “જીં કાદા માઅહું પીહાં હેય તી માયેપાંય યેય, એને પિયે. ");
INSERT INTO gbl_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","જેહેકેન પવિત્રશાસ્ત્રમાય લોખલાં હેય, કા જો માયેવોય બોરહો કોઅહે, ચ્યા હ્રદયા માઅને જીવના પાઅયા નોયો વોવત્યો લાગી.” ");
INSERT INTO gbl_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","જોવે ચ્યાય “જીવના પાઆય” આખ્યાં, તો તી પવિત્ર આત્મા બારામાય આખી રિઅલો આતો, જ્યાલ ચ્યાવોય બોરહો કોઅનારાહાન મિળનારા આતા, કાહાકા પવિત્ર આત્મા આજુ લોગુ નાંય ઉતલાં આતા, કાહાકા પોરમેહેરાય આજુ લોગુ ઈસુવા મહિમા નાંય ખુલ્લી કોઅલી આતી. ");
INSERT INTO gbl_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","બાકી લોકહામાઅને કોલાહાક ઈ વાત વોનાઈન આખતા લાગ્યા, “હાચ્ચો ઓ તો ભવિષ્યવક્તા હેય જ્યા યેયના વાટ જોવજે.” ");
INSERT INTO gbl_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","બીજહાંય આખ્યાં, “તો ખ્રિસ્ત હેય,” બાકી કાદાય આખ્યાં, “કાહા? કાય ખ્રિસ્ત ગાલીલ ભાગામાઅને યી? ");
INSERT INTO gbl_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","પવિત્રશાસ્ત્રમાય લોખલાં હેય કા, ખ્રિસ્ત દાઉદા કુળામાઅને એને બેથલેહેમ ગાવામાઅને યી, જાં દાઉદ રાજા રોતો આતો,” ");
INSERT INTO gbl_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","એહેકોયન ઈસુ લીદે લોકહામાય ફુટ પોડી ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","યાહાટી કોલહાક લોક ચ્યાલ દોઅરાં કોએત, બાકી તેરુંબી કાદે ચ્યાલ આથ નાંય લાવ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","તોવે દેવાળા રાખવાળ્યા મુખ્ય યાજક એને પોરૂષીયાહા પાય યેના, એને યહૂદી આગેવાનહાય આખ્યાં, “તુમા ચ્યાલ કાહા નાંય લેય યેના?” ");
INSERT INTO gbl_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","દેવાળા રાખવાળ્યાહાય જાવાબ દેનો, “કાદા માઅહાય કોવેજ ઓહડયો વાતો નાંય કોઅલ્યો.” ");
INSERT INTO gbl_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","તોવે પોરૂષીયાહાય જાવાબ દેનો, “કાય તુમાબી છેતારાય ગીયહા? ");
INSERT INTO gbl_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","રાજા કા પોરૂષીયાહા માઅને કાદોબી ચ્યાવોય બોરહો કોઅલો હેય? ");
INSERT INTO gbl_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","બાકી ચ્ચે માઅહે જ્યેં મૂસા નિયમશાસ્ત્ર નાંય જાંએત, ચ્યા પોરમેહેરાથી સ્રાપિત હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","નિકોદેમુસે, જો પેલ્લા રાતી ઈસુપાય યેનલો આતો, પોરૂષી લોકહામાઅને તો આતો, ચ્યે ચ્યાહાન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","કાય મા નિયમશાસ્ત્ર કાદા માઅહાલ જાવ લોગુ ચ્યા વોનાયને જાઈ નાંય લેય કા તો કાય કોઅહે, દોષ થોવહે કા? ");
INSERT INTO gbl_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ચ્યાહાય ચ્યાલ જાવાબ દેનો, “કાય તુંબી ગાલીલ ભાગા હેય કા? પવિત્રશાસ્ત્રમાય હોદ એને તુલ હોમજાયી કા ગાલીલ ભાગામાઅને કાદો ભવિષ્યવક્તા નાંય યેનારો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","તોવે બોદે જાંએ જ્યાહા ચ્યાહા ગોઓ જાતે રિયે. ");
INSERT INTO gbl_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","એને ઈસુ ચ્ચા શિષ્યહાઆરે જૈતુન ડોગાવોય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","એને બીજે દિહે હાકાળેહે પાછો દેવાળા બાઆપુર ગીયો, એને બોજ માઅહે ચ્યાપાય યેને તોવે તો બોહી ગીયો એને ચ્યાહાન હિકાડતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","જોવે તો બોલીજ રિઅલો તોવે મૂસા નિયમ હિકાડનારા ગુરુ એને પોરૂષીયાહાય યોક થેએ વ્યબિચાર કોઅતી સાપડાઈ ગીઈલી ચ્યેલ ચ્યાપાય લેય યેના, એને ચ્યેલ ચ્યા હોમ્મે ઉબી રાખીન, ઈસુલ આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ઓ ગુરુ, ઈ થેએ વ્યબિચાર કોઅતીજ સાપડાય ગીયલી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","મૂસા નિયમશાસ્ત્ર માય મૂસાય આમહાન ઓહડી આગના દેનલી હેય કા ઓહડી થેએયેહેન દોગડાટીન માઆઇ ટાકાં જોજે, બાકી તું કાય આખતોહો કા આમહાય કાય કોઅરા જોજે?” ");
INSERT INTO gbl_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ચ્યાહાય ઈસુ પરીક્ષા કોઅરાહાટી ચ્યાલ એહેકોય પુછ્યાં, કા ચ્યાવોય દોષ થોવા કાય વાત મીળે, બાકી ઈસુ ડોંગો પોડીન આંગળીયે કોઅઈન દોરતીવોય લોખતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","જોવે ચ્યા પુછતા રોયા, તોવે ઈસુવે ઉબા રોઇન ચ્યાહાન આખ્યાં, “તુમહેમાય જ્યાંય કોદહી પાપ નાંય કોઅયાહાં તોજ પેલ્લો દોગાડ ઠોકે.” ");
INSERT INTO gbl_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","એને પાછો ડોંગો પોડીન દોરતીવોય લોખતો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","બાકી ચ્યા ઈ વોનાઈન ડાયહા સે લેઈને વાહના પોહહા લોગુ યોકા પાઠી યોક આમા પાપી હેય એહેકેન હોમજીન જાતા રિયા, તોવે ઈસુ યોખલો રોય ગીયો, ચ્યે થેએયે આરે જીં આજુબી તાંજ ઉબલી આતી. ");
INSERT INTO gbl_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","તોવે ઈસુવે ઉબા રોયન ચ્યેલ આખ્યાં, “ઓ બાઈ, ચ્યા કેછ ગીયા? તુલ કાદે ડોંડ નાંય દેનો?” ");
INSERT INTO gbl_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","ચ્યે આખ્યાં, “કાદે નાંય પ્રભુ,” ઈસુવે ચ્યેલ આખ્યાં, “આંયબી તુલ ડોંડ નાંય દાવ, આમી ગોઓ જો, એને આમીને પાપમાય જીવન મા જીવહે.” ");
INSERT INTO gbl_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","તોવે ઈસુવે પાછા લોકહાન આખ્યાં, “આંય દુનિયા ઉજવાડો હેતાઉ, જીં માઅહું મા શિષ્ય બોની તો કાદે દિહી આંદારામાય નાંય ચાલી, બાકી ચ્યાલ તો ઉજવાડો મિળી જો અનંતજીવન દેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","તોવે પોરૂષીયાહાય ચ્યાલ આખ્યાં, “તું પોતા બારામાય પોતેજ સાક્ષી દેતહો, તો સાક્ષી હાચ્ચી નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ઈસુવે ચ્ચાહાન જાવાબ દેયન આખ્યાં, “જો આંય પોતે મા બારામાય સાક્ષી દાહાંવ, તેરુંબી મા સાક્ષી હાચ્ચી હેય, કાહાકા આંય જાંઅતાહાંવ, કા આંય કેછને યેતહાવ એને કેછ જાતહાવ? બાકી તુમહાન ખોબાર નાંય હેય, કા આંય કેછને યેનહો એને કેછ જાતહાવ. ");
INSERT INTO gbl_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","તુમા માઅહા વિચારાકોય ન્યાય કોઅતાહા, આંય કાદા ન્યાય નાંય કોઉ. ");
INSERT INTO gbl_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","એને જોવે આંય ન્યાય કોઉ બી, તે મા ન્યાય હાચ્ચો હેય, કાહાકા આંય યોખલો નાંય હેતાઉ, બાકી આંય પોરમેહેર આબહા આરે હેતાંવ, જ્યેં માન દોવાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","એને મૂસા નિયમશાસ્ત્રામાય બી લોખલાં હેય કા, બેન જાંઅહા સાક્ષી હાચ્ચી ગોણહાય. ");
INSERT INTO gbl_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","યોકતે આંય પોતે મા બારામાય સાક્ષી દેતહાવ, એને બિજો જ્યેં માન દોવાડલો હેય, તો આબો મા બારામાય સાક્ષી દેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ચ્યાહાય ચ્યાલ પુછ્યાં, “તો આબહો કેછ હેય?” ઈસુવે જાવાબ દેનો, “નાંય તુમા માન વોળખે એને નાંય મા આબહાલ, જો તુમા માન વોળખે તોવે મા આબહાલ બી વોળાખતા.” ");
INSERT INTO gbl_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","યો વાતો તો દેવાળા બાઆમાય હિકાડે જાં દાનપેટી આતી તાં આખી, એને ચ્યાલ કાદે દોઅયો નાંય, કાહાકા આજુ લોગુ ચ્યા સમય નાંય યેનેલ. ");
INSERT INTO gbl_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ઈસુવે ચ્યાહાન પાછા આખ્યાં, “આંય જાય રિઅલો હેતાંવ, એને તુમા માન હોદહા એને તુમા તુમહે પાપહા માફ ઓઅયા વોગાર મોઅઇ જાહા, એને આંય જાં જાય રિઅલો હેતાંવ, તાં તુમા નાંય યી હોકહા.” ");
INSERT INTO gbl_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","તોવે યહૂદી આગેવાનહાય આખ્યાં, “કાય તો પોતાલ માઆઇ ટાકી, ચ્યાહાટી તો એહેકેન આખહે, જાં આંય જાય રોયહો, તાં તુમહાન નાંય યેવાય?” ");
INSERT INTO gbl_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ઈસુવે ચ્યાહાન આખ્યાં, “તુમા યા દુનિયામાય પૈદા ઓઅયાહા, બાકી આંય હોરગામાઅને યેનહો, તુમા દુનિયા હેતા, આંય દુનિયા નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","યાહાટી માયે તુમહાન આખ્યાં, કા તુમા તુમહે પાપહા માફ ઓઅયા વોગાર મોઅઇ જાહા, કાહાકા જોવે તુમા માયેવોય બોરહો નાંય કોઅહા કા તો આંયજ હેતાઉ, તોવે તુમા તુમહે પાપહા માફ ઓઅયા વોગાર મોઅઇ જાહા.” ");
INSERT INTO gbl_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","યહૂદી આગેવાનહાય ઈસુલ પુછ્યાં, “તું કું હેતો?” ઈસુવે ચ્યાહાન આખ્યાં, “જોવેને માયે હિકાડના સુરુ કોઅયાહાં, તોવેને આંય તુમહાન આખતો યેનહો કા આંય કું હેતાંવ. ");
INSERT INTO gbl_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","તુમહે બારામાય માન બોજ કાય આખના એને ન્યાય કોઅના હેય બાકી માન જ્યેં દોવાડયો, તો હાચ્ચો હેય, એને જીં આંય ચ્યાથી વોનાયોહો, તીંજ આંય દુનિયા લોકહાન આખતાહાવ.” ");
INSERT INTO gbl_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ચ્યા નાંય હોમજ્યા કા તો પોરમેહેર આબહા બારામાય આખી રિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “જોવે તુમા માન માઅહા પોહાલ હુળીખાંબાવોય ચોડવાહા, તોવે તુમા માયેવોય બોરહો કોઅહા કા આંય તોજ હેતાઉ, એને પોતે આંય કાય નાંય કોઉ, બાકી જેહેકેન પોરમેહેર આબહે માન હિકાડલા હેય, તેહેકેન આંય યો વાતો આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","એને મા દોવાડનારો મા આરે હેય, ચ્યે માન યોખલો નાંય છોડયો, કાહાકા આંય કાયામ તીંજ કામ કોઅતાહાંવ, જ્યાથી તો ખુશ ઓઅહે.” ");
INSERT INTO gbl_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","બોજ લોકહાય જ્યાહાય ઈસુલ યો વાતો કોઅતા વોનાયા, ચ્યાવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","તોવે ઈસુવે ચ્યા યહૂદીયા જ્યાહાય ઈસુવે બોરહો કોઅયો, આખ્યાં, “જોવે તુમા મા વચનામાય બોની રાહા, તોવે હાચ્ચાં તુમા મા શિષ્ય ગોણાયાહા. ");
INSERT INTO gbl_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","એને તુમા હાચ્ચાં જાંઅહા, એને હાચ્ચાં તુમહાન છુટકો કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ચ્યાહાય જાવાબ દેનો, “આમા આબ્રાહામા કુળામાઅને હેજે, એને કાદે દિહી કાદા ચાકાર નાંય બોન્યા, તું કેહેકેન આખતોહો કા તુમહે છુટકો ઓઅઇ જાય?” ");
INSERT INTO gbl_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ઈસુવે ચ્યાહાન જાવાબ દેનો, “આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, જીં માઅહું પાપ કોઅહે તી પાપા તાબામાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","એને ચાકાર કાયામ ગોઆમાય નાંય રોય, પોહો કાયામ રોહે. ");
INSERT INTO gbl_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","યાહાટી જોવે પોરમેહેરા પોહો તુમહે છુટકો કોઅહે, તો હાચ્ચાં તુમહે છુટકો ઓઅઇ જાય. ");
INSERT INTO gbl_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","માન ખોબાર હેય કા તુમા આબ્રાહામા કુળામાઅને હેતા, તેરુંબી તુમા મા હિકાડના નાંય પાળ્યાં, યાહાટી તુમા માન માઆઇ ટાકાં કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","આંય તીંજ તુમહાન આખતાહાવ જીં માયે એઅયા, જોવે આંય પોતાના આબહા આરે આતો. એને તુમા તીંજ કોઅતા રોતહા જીં તુમહાય તુમહે આબહાથી વોનાલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ચ્યાહાય ચ્યાલ જાવાબ દેયન આખ્યાં, “આમહે આગલ્યો ડાયો આબ્રાહામ હેય.” ઈસુવે ચ્યાહાન આખ્યાં, “જોવે તુમા આબ્રાહામા પીડી રોતા, તોવે તુમા જીં આબ્રાહામ કોઅતો આતો તી કામ કોઅતા. ");
INSERT INTO gbl_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","બાકી આમી તુમા માન માઆઇ ટાકાં હોદતા આતા, કાહાકા માયે તુમહાન હાચ્ચાં આખી દેનહા, જીં માયે પોરમેહેરા આબહા પાઅને વોનાયો, એહેકેન તે આબ્રાહામાય નાંય કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","તુમા તુમહે આબહા હારકે કામ કોઅતાહા.” ચ્યાહાય ચ્યાલ આખ્યાં, “આમે વ્યબિચારાથી નાંય જન્મો જાયહો, આમે તે યોકુજ આબહો હેય એને તો પોરમેહેર હેય. ");
INSERT INTO gbl_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ઈસુય ચ્યાહાન આખ્યાં, જો પોરમેહેર તુમહે આબહો રોતો, તોવે તુમા માયેવોય પ્રેમ કોઅતા, કાહાકા આંય પોરમેહેરાપાઅને યેનહો, આંય પોતા કોઇન નાંય યેનહો, બાકી પોરમેહેરાય માન દોવાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","આંય જીં આખતાહાવ તી તુમહાન કાહાનાય હોમાજ પોડે? કાહાકા તુમા મા વચન પાળા નાંય માગેત. ");
INSERT INTO gbl_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","તુમા તુમહે આબહો સૈતાનાપાઅને હેતા, એને તુમા તુમહે આબહા ઉસ પુરી કોઅરા માગતાહા, તો તે પેલ્લેથી ખૂની હેય, એને હાચ્ચાયેવોય મજબુત નાંય રોય કાહાકા ચ્યામાય હાચ્ચાં હેયેજ નાંય. જોવે તો ઠોગીન વાત કોઅહે, તોવે તો પોતા મોના વિચાર કોઇન આખહે, કાહાકા તો ઠોગ હેય, એને ઠોગનારાહા આબહો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","આંય હાચ્ચાં આખતાહાવ, યાહાટી તુમા માયેવોય બોરહો નાંય કોએત. ");
INSERT INTO gbl_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","તુમહેમાઅને કું માન પાપ કોઅના દોષ થોવહે? જોવે આંય તુમહાન હાચ્ચાં આખતાહાવ તોવે તુમા કાહાનાય બોરહો કોએત? ");
INSERT INTO gbl_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","જો કાદો પોરમેહેરાપાઅને હેય, તો પોરમેહેરા વાતો વોનાયેહે, એને તુમા યાહાટી નાંય વોનાયે કાહાકા તુમા પોરમેહેરાપાઅને નાંય હેતા.” ");
INSERT INTO gbl_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","યહૂદી આગેવાનહાય ઈ વોનાયને ચ્યાલ જાવાબ દેનો કા, “આમા હાચ્ચાં આખજે કા તું સમરૂની હેતો એને તોમાય બુત હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ઈસુવે જાવાબ દેનો, “માંયેમાય બુત નાંય હેય, બાકી આંય મા આબહા કદર કોઅતાહાંવ, એને તુમા મા કદર નાંય કોએ. ");
INSERT INTO gbl_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","આંય મા કદર નાંય હોદુ, બાકી યોક હેય જો હોદહે કા મા કદર કોઅલો જાય, એને ઓ તોજ હેય જો ન્યાય બી કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, જો કાદો માઅહું મા વચન પાળી, તોવે તો અનંતકાળ લોગુ નાંય મોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ઈ વોનાયને યહૂદી લોકહાય આખ્યાં, “આમી આમહાન ખાત્રી ઓઈ ગિઇ કા તોમાય બુત હેય, આબ્રાહામ મોઓઈ ગીયો, એને ભવિષ્યવક્તા બી મોઓઈ ગીઅલા હેય, એને તું આખતોહો કા જીં માઅહું મા વચન પાળી તી કોઇ દિહી નાંય મોઅરી. ");
INSERT INTO gbl_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","આમે આબહો આબ્રાહામ તો મોઅઇ ગીયો, કાય તું ચ્યા કોઅતો મોઠો હેય? એને ભવિષ્યવક્તા બી મોઅઇ ગીયા, તોવે તું પોતાલ કાય હોમાજતોહો?” ");
INSERT INTO gbl_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ઈસુવે જાવાબ દેનો, “જો આંય પોતા કોઇન માન હોદુ તોવે મા મહિમા કાયજ નાંય; બાકી મા મહિમા કોઅનારો મા આબહો હેય, એને તુમા આખતાહા, કા તો આમહે પોરમેહેર હેય, ");
INSERT INTO gbl_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","તેરુંબી તુમા ચ્યાલ નાંય જાંએત બાકી ચ્યાલ આંય જાંઅતાહાંવ, એને જો આંય આખું કા ચ્યાલ આંય નાંય જાઅઉ, તોવે આંય તુમહે રોકો ઠોગ બોનહી, આંય ચ્યાલ જાઅતાહુ એને ચ્યા આગના પાળહુ. ");
INSERT INTO gbl_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","તુમહે આગલ્યો ડાયો આબ્રાહામ મા યેઅના દિહી એઅરા મિળી યે આશેકોય બોજ મગન આતો, એને મા યેઅના દિહી એઇન તો ખુશ ઓઈ ગીયો.” ");
INSERT INTO gbl_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","તોવે યહૂદી આગેવાનહાય ચ્યાલ આખ્યાં, “તું આજુ પોચાહા વોરહા નાંય જાયહો, તો કેહેકેન તુયે આબ્રાહામાલ દેખ્યહો?” ");
INSERT INTO gbl_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ઈસુવે ચ્યાહાન આખ્યાં, “આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, આબ્રાહામા જન્મો જાયો ચ્યા પેલ્લા આંય હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","તોવે ચ્યાહાય ઈસુલ ઠોકાંહાટી દોગડા ઈશ્યા, બાકી ઈસુ દેવાળામાઅને ઠાવકોજ જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","યોક દિહી જોવે ઈસુ શિષ્યહાઆરે વાટે જાતો આતો, તોવે યોકા જોન્માથી આંદળા માઅહાલ દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","એને ચ્યા શિષ્યહાય ચ્યાલ પુછ્યાં કા, “ઓ ગુરુ, કુંયે પાપ કોઅયા ઓરી કા ઓ આંદળો જોનમ્યો, યા માઅહાય કા ચ્યા આયહે આબહાય?” ");
INSERT INTO gbl_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ઈસુવે જાવાબ દેનો, “નાંય તે ચ્યાય પાપ કોઅલા આતા, નાંય તે ચ્યા આયહે આબહાય બાકી યાહાટી આંદળો જોનમ્યો કા પોરમેહેરા સામર્થ્યા કામ ચ્યામાય દેખાયાં જોજે. ");
INSERT INTO gbl_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","જ્યેં માન દોવાડયોહો, ચ્યા હોપલા કામ આમહાન જલદી પુરેં કોઅના હેય, કાહાકા રાત યેહે, ચ્યેમાય કાદો કામ નાંય કોઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","જાવ લોગુ આંય દુનિયામાય હેતાઉ, તાંવ લોગુ આંય દુનિયા ઉજવાડો હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ઈ આખીન તો દોરતીવોય થુપ્યો એને થુપે કોઇન કાદુ મોગલ્યો, એને તો કાદુ ચ્યા ડોળાહાવોય ચોપડયો, ");
INSERT INTO gbl_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","એને આખ્યાં, “જો, તો મું શિલોહ કુંડામાય દોવી લે,” તો ગીયો એને દોવ્યા એને દેખતો ઓઇન ફિરી યેનો. ");
INSERT INTO gbl_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","તોવે ચ્ચા પડોસી લોકહાય એને જ્યા પેલ્લા તો માગે તોવે ચ્યાલ એઅતા આતા, ચ્યા યોકા બિજાલ આખા લાગ્યા, “કાય ઓ તો નાંય હેય, જો બોહીન બિખ માગતો આતો?” ");
INSERT INTO gbl_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","તોવે કોલાહાક લોક આખે, “ઓ તોજ હેય,” બિજા આખે “નાંય, બાકી ચ્યા રોકો હેય” બાકી ચ્યે આખ્યાં, “આંય તોજ હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","તોવે ચ્યા ચ્યાલ પુછા લાગ્યા, “તુલ તો નોજાર કેહેકેન મિળી ગીયી?” ");
INSERT INTO gbl_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ચ્યાય જાવાબ દેનો, “ઈસુ નાંવા યોક માઅહે કાદુ મોગલ્યો એને મા ડોળાહાવોય ચોપડયો, એને ચ્યે માન આખ્યાં, શિલોહ કુંડ માય જાયન મું દોવી લે, તોવે આંય ગીયો એને દોવ્યા પાછે એઅતો લાગ્યો.” ");
INSERT INTO gbl_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","ચ્યાહાય ચ્યાલ પુછ્યાં, “તો કેછ હેય?” ચ્યે આખ્યાં, “માન ખોબાર નાંય.” ");
INSERT INTO gbl_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","14","જ્યેં દિહે ઈસુય કાદુ મોગલીન ચ્યા માઅહાલ એઅતો કોઅયો, તો આરામા દિહી આતો. યાહાટી લોક જો પેલ્લા આંદળો આતો ચ્યાલ પોરૂષીયા પાય લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","તોવે પોરૂષીયાહાય બી ચ્યાલ પુછ્યાં, “તુલ તો નોજાર કેહેકેન મિળી ગીયી? ચ્યાય ચ્યાહાન આખ્યાં ચ્યાય ડોળાહાવોય કાદુ લાવ્યો, એને માયે દોવી લેદા, એને આંય આમી એઅતાહાવ.” ");
INSERT INTO gbl_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","તોવે કોલાહાક પોરૂષી આખા લાગ્યા, “ઈ માઅહું પોરમેહેરા એછને નાંય હેય, કાહાકા તો આરામા દિહી નાંય પાળે,” બાકી બીજહાંય આખ્યાં, “પાપી માઅહું ઓહડા ચમત્કાર કેહેકેન કોઇ હોકહે?” એને ચ્યાહામાય ફુટ પોડી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ચ્યાહાય ચ્યા આંદળાલ પાછા આખ્યાં, “જ્યેં તુલ દેખતો કોઅયો, ચ્યા બારામાય તું કાય આખતોહો” તોવે ચ્યે જાવાબ દેનો, “તો ભવિષ્યવક્તા હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","બાકી યહૂદી આગેવાનહાય બોરહો નાંય કોઅયો કા તો આંદળો આતો એને દેખતો ઓઅઇ ગીયો, જાવ લોગુ ચ્યાહાય ચ્ચા આંદળા આયહે આબહાલ હાદિન નાંય પુછ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","કા, “કાય ઓ તુમહે પોહો હેય, જ્યાલ તુમા આખતેહે કા આંદળો જોનમ્યો? તોવે આમી કેહેકેન એઅઇ હોકહે?” ");
INSERT INTO gbl_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ચ્યા આયહે આબહે જાવાબ દેનો કા, “આમા જાંઅજેહે કા ઓ આમહે પોહો હેય, એને આંદળો જોનમ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","બાકી આમી કેહેકેન દેખતો જાયો, તીં આમા નાંય જાંઆજે, એને નાંય ઈ જાંઆજે, કા કુંયે ચ્ચા ડોળા ઉગડાવ્યા, ચ્યાલુજ પુછી લા, તો પોતા બારામાય પોતેજ આખી દેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","યો વાતો ચ્યા આયહે આબહાય યાહાટી આખ્યો, કાહાકા ચ્યાહાન યહૂદી આગેવાનહા દાક આતી, કાહાકા યહૂદી આગેવાનહાય નોક્કી કોઅયેલ કા, જીં માઅહું ઈસુવોય બોરહો કોએ કા તો ખ્રિસ્ત હેય, ચ્યાલ સોબાયે ઠિકાણા માઅને કાડી દેવામાય યેય. ");
INSERT INTO gbl_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ચ્યાહાટી ચ્યા આયહે આબહાય આખ્યાં કા, “તો આખી હોકહે ઓલો મોઠો હેય, ચ્યાલુજ પુછી લા.” ");
INSERT INTO gbl_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","તોવે યહૂદી આગેવાનહાય જો આંદળો આતો ચ્યાલ બીજેદા હાદિન પુછ્યાં, “હાચ્ચાં આખીન પોરમેહેરા સ્તુતિ કોઓ, આમહાન ખોબાર હેય કા તો માઅહું પાપી હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ચ્યે જાવાબ દેનો, “તો પાપી હેય કા નાંય, તીં આંય નાંય જાઅઉ ઓલહાંજ જાંઅહું કા, આંય આંદળો આતો, એને આમી આંય દેખતો જાયહો.” ");
INSERT INTO gbl_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","તોવે ચ્યાહાય ચ્યાલ પાછા પુછ્યાં, “તુલ ચ્યે કાય કોઅયા? તુલ કેહેકેન દેખતો કોઅયો? ");
INSERT INTO gbl_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ચ્યે ચ્ચાહાન જાવાબ દેનો, આંય તુમહાન આખી ચુક્યો, એને તુમા નાંય વોનાયા, આમી બીજેદા કાહા વોનાયા માગતાહા? તુમાબી ચ્યા શિષ્ય બોના કા?” ");
INSERT INTO gbl_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","તોવે ચ્યાહાય ચ્યા નિંદા કોઇન આખ્યાં, “તુંજ ચ્યા શિષ્ય હેય, આમા મૂસા શિષ્ય હેજે. ");
INSERT INTO gbl_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","આમા જાંઅજેહે કા પોરમેહેરે મૂસાઆરે વાતો કોઅયો બાકી ઓ કેછને હેય તીં આમહાન ખોબાર નાંય.” ");
INSERT INTO gbl_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ચ્યે માઅહે ચ્યાહાન આખ્યાં, “એરે ઈ તે, નોવાયે વાત હેય કા એલે માન દેખતો કોઅયો તેરુંબી તુમા નાંય જાંઅતાહા કા તો કેછને હેય. ");
INSERT INTO gbl_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","આમા જાંઅજેહે કા, પોરમેહેર પાપી લોકહા નાંય વોનાયે, બાકી જીં માઅહું પોરમેહેરા ભક્ત હેય એને પોરમેહેરા મોરજયેકોય જીવહે, તો ચ્યા વોનાયેહે. ");
INSERT INTO gbl_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","જોવેને દુનિયા બોની તોયાં આજેલોગુ આપા ઈ નાંય વોનાયા, કા કાદેબી જન્માથી આંદળાલ દેખતો કોઅયો ઓરી. ");
INSERT INTO gbl_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","જોવે તો પોરમેહેરા એછને નાંય રોતો, તોવે તો કાયબી નાંય કોઇ હોકતો.” ");
INSERT INTO gbl_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ચ્યાહાય ચ્યાલ જાવાબ દેનો, “તું તો પેલ્લેથી પાપામાંય જોનમ્યોહો, તું આમહાન કાય હિકાડતોહો?” તોવે ચ્યાહાય ચ્યાલ સોબાયે ઠિકાણા માઅને બાઆ કાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ઈસુ વોનાયો, કા યહૂદી આગેવાનહાય ચ્યાલ બાઆ કાડી દેનહો, એને જોવે તો મિળ્યો, તોવે ચ્યે આખ્યાં, “તું માઅહા પોહાવોય બોરહો કોઅતોહો કા?” ");
INSERT INTO gbl_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ચ્યાય જાવાબ દેનો, “ઓ સાયબ, માન આખ કા ઓ પોરમેહેરા પોહો કું હેય, કા આંય ચ્યાવોય બોરહો કોઇ હોકુ?” ");
INSERT INTO gbl_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ઈસુવે ચ્યાલ આખ્યાં, “આંય પોરમેહેરા પોહો હેય, તું પેલ્લા માન એઇ ચુકયોહો, આંય તોજ હેય જો આમી તોઆરે વાતો કોઇ રિઅલો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","ચ્યે આખ્યાં, “ઓ પ્રભુ, આંય તોવોય બોરહો કોઅતાહાંવ” એને તો ઈસુ પાગે પોડયો. ");
INSERT INTO gbl_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","એને ઈસુવે આખ્યાં, “આંય દુનિયામાય ન્યાય કોઅરાહાટી યેનો, યાહાટી કા જ્યેં એઅઇ નાંય હોકેત ચ્યે એએ, એને જ્યા એઅતાહા ચ્યા આંદળા બોની જાય.” ");
INSERT INTO gbl_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","પોરૂષીયાહા માઅને કોલહાક તાં ચ્ચાઆરે આતા ચ્યા યો વાતો વોનાયને, એને ચ્યાહાય ચ્યાલ આખ્યાં, “કાય તું આખી રિયહો કા આમા બી આંદળા હેજે?” ");
INSERT INTO gbl_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ઈસુવે ચ્યાહાન આખ્યાં, “જોવે તુમા આંદળા રોતા તોવે તુમહે પાપ નાંય ગોણાતાં, બાકી આમી આખતાહા કા આમા એઅજેહે, યાહાટી તુમહે પાપ માફ નાંય કોઅલા જાય.” ");
INSERT INTO gbl_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","“આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, જો કાદો ગોઠામાય બાઆણામાય રોઇન નાંય બાકી બીજે કાને રોઇન ઉરાઇ જાય, તો બાંડ એને લુટારો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","બાકી ગેટાહા ગોવાળ બાઆણામાય રોઇન જાહે. ");
INSERT INTO gbl_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ચ્યાહાહાટી મેંડવાળ્યો બાઅણા ઉગાડેહે, એને ગેટેં ચ્યા આવાજ વોળાખતેહે, એને તો ચ્યા ગેટાહાન નાંવે કોઇન હાત કોઅહે એને ચ્યાહાન બાઆ લેય જાહે. ");
INSERT INTO gbl_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","એને જોવે બોદા ગેટહાન બાઆ કાડહે, તોવે તો ચ્યાહા આગલા ચાલહે એને ગેટેં ચ્યા પાહલા ચાલતેહે કાહાકા ચ્યે ચ્યા આવાજ વોળાખતેહે. ");
INSERT INTO gbl_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ચ્યે ઓજાણ્યા પાહલા નાંય ચાલી, બાકી ચ્યાપાઅને નાહાતેહે, કાહાકા ઓજાણ્યા આવાજ ચ્યે નાંય વોળખેત.” ");
INSERT INTO gbl_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ઈસુવે ચ્યાહાન ઓ દાખલો આખ્યો, બાકી ચ્યા નાંય હોમજ્યા કા ચ્ચા આખના કાય મતલબ આતો. ");
INSERT INTO gbl_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","તોવે ઈસુવે ચ્યાહાન પાછા આખ્યાં, “આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, ગેટહા બાઅણા આંય હેતાઉ. ");
INSERT INTO gbl_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","મા આગલા જોલા યેના ચ્યા બોદા બાંડ એને લુટારૂ હેય, બાકી મા ગેટેં ચ્યાહા નાંય વોનાયે. ");
INSERT INTO gbl_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","બાઅણા આંય હેતાઉ, માયેમાઅને રોઇન માજે યેહે ચ્યા પોરમેહેર તારણ કોઅરી, એને માજે એને બાઆ યે-જાં કોઅરી એને ચ્યાલ ખાંહાટી ચારો મિળી. ");
INSERT INTO gbl_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","બાંડ ખાલી ચોરી કોઅરા, માઆઇ ટાકાં એને નાશ કોઅરા હાટીજ યેહે, આંય યાહાટી યેનહો કા ચ્યા પુરી રીતેકોય જીવતા રોય. ");
INSERT INTO gbl_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","હારો ગોવાળ આંય હેતાઉ. હારો ગોવાળ ચ્યા ગેટહા હાટી જીવ દેહે. ");
INSERT INTO gbl_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","બાડાવોય રાખલો નોકાર જોવે આસાલ્યેલ યેતો એએ, તોવે ગેટહાન છોડીન નાહી પોડહે, કાહાકા ગેટેં ચ્ચા નાંય હેય, એને તો ચ્ચાહા ગોવાળ નાંય હેય, ચ્યાહાટી વરુ ચ્ચાહાવોય હમલો કોઅહે, એને ટોળાલ આલાગ-આલાગ કોઇ દેતહેં. ");
INSERT INTO gbl_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","તો યાહાટી નાહી પોડહે કાહાકા તો નોકાર હેય, એને ચ્યાલ ગેટહા ચિંતા નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","હારો ગોવાળ આંય હેતાઉ, એને આંય મા ગેટહાન જાંઅતાહાંવ, એને મા ગેટેં માન જાંઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","જેહેકેન આબહો માન જાંઅહે એને આંય આબહાલ જાંઅતાહાંવ, એને મા ગેટહા હાટી આંય મા જીવ દેતહાવ. ");
INSERT INTO gbl_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","એને મા આજુ બીજે ગેટેં હેતેં, ચ્યે યા ગોઠામાઅને નાંય હેતેં, મા ચ્યાહાનબી લેય યેયના જરુરી હેય, ચ્યે મા આવાજ વોળખી, તોવે યોકુજ ટોળો એને યોકુજ ગોવાળ રોય. ");
INSERT INTO gbl_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","આબહો માયેવોય યાહાટી પ્રેમ કોઅહે, કાહાકા આંય મા જીવ દેતહાવ, કા ચ્યાલ પાછા લેય લાવ. ");
INSERT INTO gbl_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","મા જીવ માયેપાઅને કાદો પેચકી નાંય લેય, બાકી આંય મા મોરજી કોઇન દેતહાવ, માન ચ્યાલ દેઅના બી ઓદિકાર હેય, એને પાછા લેઅના બી ઓદિકાર હેય, ઈ આગના મા આબહે માન દેનહી.” ");
INSERT INTO gbl_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","યે વાતહે લેદે યહૂદી આગેવાનહામાય પાછી ફુટ પોડી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ચ્યાહામાઅને બોજ જાંએ આખે કા, “ચ્યામાય બુત હેય, એને તો ગાંડવાઈ ગીયહો, ચ્યા નાંય વોનાના?” ");
INSERT INTO gbl_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","બીજહાંય આખ્યાં, “યો વાતો ઓહડા માઅહા નાંય જ્યામાય બુત રોય, યોક બુત કોય દિહે આંદળાલ નોજાર નાંય દી હોકે.” ");
INSERT INTO gbl_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","તોવે યેરૂસાલેમ શેહેરામાય દેવાળા ઉદઘાટનાલ યાદ કોઅના સણ આતો એને હિયાળા મોંસમ આતો. ");
INSERT INTO gbl_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","એને ઈસુ દેવાળામાય સુલેમાના પારસાળી માય ફિરતો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","તોવે યહૂદી આગેવાનહાય ઈસુપાય ટોળો વોળીન પુછ્યાં, “તો બારામાય આમે મોનામાય કોવે લોગુ શંકામાય રોજે? જો તું ખ્રિસ્ત હેતો, તે આમહાન ખુલ્લી રીતે આખી દે.” ");
INSERT INTO gbl_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ઈસુવે ચ્યાહાન જાવાબ દેનો, “માયે તુમહાન આખી દેના, એને તેરુંબી તુમા બોરહો નાંય કોએત, જીં કામ આંય મા પોરમેહેર આબહા ઓદિકારા કોઇ કોઅતાહાંવ તીજ મા સાક્ષી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","બાકી તુમા યાહાટી બોરહો નાંય કોએત, કાહાકા તુમા મા ગેટહામાઅને નાંય હેતા. ");
INSERT INTO gbl_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","જેહેકેન મા ગેટેં આસલી ગોવાળા આવાજ વોળાખતેહે, તેહેકેનુજ મા લોક મા વાતે વોય ધ્યાન દેતહા, આંય ચ્યાહાન વોળાખતાહુ, એને ચ્યા મા શિષ્ય બોની ગીઅલા હેય. ");
INSERT INTO gbl_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","એને આંય ચ્યાહાન અનંતજીવન દેતહાવ એને ચ્ચે કોય દિહે નાશ નાંય ઓઅરી, એને ચ્યાહાન કાદો માયે વોઅને પેચકી નાંય લેય. ");
INSERT INTO gbl_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","મા આબહે, જ્યાંય ચ્યાહાન માન દેનહે, બોદહા કોઅતો તો મોઠો હેય, એને ચ્યાહાલ આબહા વોયને કાદો પેચકી નાંય હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","આંય એને આબહો યોક હેજે.” ");
INSERT INTO gbl_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","તોવે પાછા યોકદા યહૂદી આગેવાનહાય ચ્યાલ ઠોકાંહાટી દોગાડ ઈશ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “માયે તુમહાન મા આબહા ઇહિને બોજ હારેં કામે દેખાડયેહે, ચ્યાહામાઅને કોઅહા કામાહાટી તુમા માન દોગડાટા કોઅતાહા?” ");
INSERT INTO gbl_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","યહૂદી આગેવાનહાય ચ્યાલ જાવાબ દેનો, “હારાં કામાહાટી તુલ નાંય દોગડાટી દેજે બાકી પોરમેહેરા નિંદાયે હાટી કાહાકા તું માઅહું છતા, પોરમેહેર હેતાઉ એહેકેન આખતોહો.” ");
INSERT INTO gbl_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ઈસુવે ચ્યાહાન જાવાબ દેનો, “કાય તુમહે નિયમશાસ્ત્ર માય એહેકેન નાંય લોખલાં હેય, માયે આખ્યાં, ‘તું ઈશ્વર હેય’? ");
INSERT INTO gbl_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","જ્યાહાન પોરમેહેરા વચન મિળ્યાં, જોવે ચ્યાહાન પવિત્રશાસ્ત્ર ઈશ્વર આખે, તો પવિત્રશાસ્ત્રા નિંદા નાંય ઓએ? ");
INSERT INTO gbl_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","જોવે આંય આખહુ, આંય પોરમેહેરા પોહો હેય, તોવે તુમા માન કાહા આખતાહા, કા તું નિંદા કોઅતોહો, આંય તોજ હેય, જ્યાલ આબહે આલાગ કોઅયો એને દુનિયામાય દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","જોવે આંય મા આબહા કામ નાંય કોઉ, તોવે માયેવોય બોરહો મા કોઅહા. ");
INSERT INTO gbl_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","બાકી જોવે આંય કોઅતાહાંવ, તે માયેવોય બોરહો નાંય બી કોઅહા, બાકી ચ્યા કામહાવોય બોરહો રાખા, કા તુમા જાંઆય એને હુમજે કા આબહો માયે માય હેય એને આંય આબહામાય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","તોવે ચ્યા પાછા ચ્યાલ દોઅરાં કોએત, બાકી તો ચ્યાહાપાઅને દુઉ જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","પાછે ઈસુ યારદેન નોયે ચ્યેમેરે જાતો રિયો, જાં પેલ્લા યોહાન બાપતિસ્મા દેતો આતો એને તાં રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","બોજ જાંએ ચ્યાપાય યેયન આખા આતેં, “યોહાને તે કાય ચમત્કારા કામ નાંય દેખાડયા, બાકી યા માઅહા બારામાય યોહાને જીં કાય આખ્યાં તીં બોદા હાચ્ચાં આતા.” ");
INSERT INTO gbl_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","એને તાઅને બો બોદા લોકહાય ચ્યાવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","મરિયમ એને ચ્ચે બોઅહી માર્થાયે ગાંવ બેથાનીયામાય લાજરસ નાંવા યોક માઅહું બિમાર આતો. ");
INSERT INTO gbl_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ઈ તીજ મરિયમ આતી, જ્યેય પાછે પ્રભુ પાગહાવોય મોઅગાં સુગંદી અત્તાર ચોપડીન ચ્યા પાગ પોતે કિહહા કોઇન નુંહયા, ચ્યે બાહા લાજરસ બિમાર આતો. ");
INSERT INTO gbl_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","તોવે ચ્યા બોઅયેહે ઈસુવાઇહી આખી દોવાડયા, “ઓ પ્રભુ, એએ, જ્યાવોય તું પ્રેમ કોઅતોહો તો બિમાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ઈ વોનાઈન ઈસુવે આખ્યાં, “ઈ બિમારી મોઅરાંહાટી નાંય હેય, બાકી પોરમેહેરા મહિમાહાટી હેય, કા ચ્યાકોય પોરમેહેરા પોહા મહિમા ઓએ.” ");
INSERT INTO gbl_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ઈસુ માર્થા એને ચ્યે બોઅહી મરિયમ એને લાજરસાવોય પ્રેમ કોઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","બાકી ઈસુ વોનાયો, કા લાજરસ બિમાર હેય, એને જાં તો આતો, તાંજ બેન દિહી રોય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","બેન દિહહયા પાછે ઈસુય ચ્યા શિષ્યહાન આખ્યાં, “યા, આપા પાછા યહૂદીયા વિસ્તારમાય જાતા.” ");
INSERT INTO gbl_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","શિષ્યહાય ચ્યાલ આખ્યાં, “ઓ ગુરુ, આમીંજ યહૂદી આગેવાન તુલ દોગડાટીન માઆઇ ટાકાં કોએત એને તું તાં પાછો જાં કા?” ");
INSERT INTO gbl_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ઈસુવે જાવાબ દેનો, “કાય દિહા બાર કોલાક નાંય રોય? જોવે કાદો દિહા ચાલે, તો ઠોકાતો નાંય જાય, કાહાકા દિહા ઉજવાડા કોય ચ્યાલ દેખાયેહે. ");
INSERT INTO gbl_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","બાકી જોવે કાદો રાતી ચાલે, તો ઠોકાતો જાય, કાહાકા ચ્યાપાય ઉજવાડો નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ચ્યાય યો વાતો આખ્યો, એને પાછે તો ચ્યાહાન આખા લાગ્યો, “આપહે દોસ્તાર લાજરસ હૂવી ગીયહો, બાકી આંય ચ્યાલ ઉઠાડાંહાટી જાતહાવ.” ");
INSERT INTO gbl_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","તોવે શિષ્યહાય ચ્યાલ આખ્યાં, “ઓ પ્રભુ, તો હૂવી ગીયહો, તોવે પાછો હારો ઓઅઇન બોચાવલો જાય.” ");
INSERT INTO gbl_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ઈસુવે ચ્યા મોતા બારામાય આખલા આતા, બાકી ચ્યા હોમજ્યા તે નિંદેમાય હૂવી જાઅના બારામાય હોમજ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","તોવે ઈસુવે ખુલ્લાં આખ્યાં, “લાજરસ મોઓઈ ગીયહો. ");
INSERT INTO gbl_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","એને આંય તાં નાંય આતો, ચ્યાહાટી તુમહે ફાયદાહાટી ખુશ હેતાઉ કા આંય તાં નાંય આતો, જેથી તુમા બોરહો કોઆ. બાકી આમી યા, આપા ચ્યાપાય જાતા.” ");
INSERT INTO gbl_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","તોવે થોમાય જ્યાલ દિદુમુસ આખે, ચ્યાઆરે શિષ્યહાન આખ્યાં, “ચાલા, આપાબી ચ્યાઆરે મોઅરા જાતા.” ");
INSERT INTO gbl_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","જોવે ઈસુ બેથાનીયામાય યેય પોઅચ્યો તોવે ચ્યાલ માલુમ જાયા કા લાજરસાલ માહણામાય થોવિન ચાર દિહી ઓઈ ગીયહા. ");
INSERT INTO gbl_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","બેથાનીયા ગાવા યેરૂસાલેમ શેહેરા પાહાય લગભગ તીન કિલોમીટર દુઉ આતા. ");
INSERT INTO gbl_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","એને બોજ યહૂદી લોક માર્થા એને મરિયમ પાય ચ્યેહે બાહા લાજરસા બારામાય દિલાસો દાં યેનલે. ");
INSERT INTO gbl_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","માર્થા ઈસુ યેયના ખોબાર વોનાઈન તી ચ્યાલ મિળાં ગીયી, બાકી મરિયમ ગોઅજ રિયી. ");
INSERT INTO gbl_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","તોવે માર્થાયે ઈસુવાલ આખ્યાં, “પ્રભુ તુલ ઈહીં રા જોજતાં, તોવે મા બાહા નાંય મોઅતો. ");
INSERT INTO gbl_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","એને આમીબી આંય જાંઅહુ કા તું પોરમેહેરાપાઅને જીં કાય માગહે તી પોરમેહેર તુલ દેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ઈસુય ચ્યેલ આખ્યાં, “તો બાહા પાછો જીવી ઉઠી.” ");
INSERT INTO gbl_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","માર્થા ચ્યાલ આખ્યાં, “માન ખોબાર હેય, ન્યાય કોઅના દિહે જોવે બોદે મોઅલા માઅને પાછા જીવી ઉઠી તોવે તો પાછો જીવતો ઉઠી.” ");
INSERT INTO gbl_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ઈસુવે ચ્યેલ આખ્યાં, “આંય તો હેતાંવ જો મોઅલા માઅને પાછો જીવતો ઉઠયહો, જો કાદો માયેવોય બોરહો કોઅહે તો મોઅઇબી જાય, તેરુંબી જીવી. ");
INSERT INTO gbl_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","જો માંયેમાય જીવહે એને માયેવોય બોરહો કોઅહે તો કોય દિહે નાંય મોઅરી. કાય તું યે વાતવોય બોરહો કોઅતીહી કા?” ");
INSERT INTO gbl_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ચ્યે આખ્યાં, “હાં, પ્રભુ, આંય બોરહો કોઅત્યાહાંવ કા તું પોરમેહેરા પોહો ખ્રિસ્ત હેતો જો દુનિયામાય યેનારો આતો, તો તુંજ હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ઈ વાત આખીન તી જાતી રોયી એને ચ્યે બોઅહી મરિયમેલ ઠાવકાજ હાદિન આખ્યાં, “ગુરુ ઈહીંજ હેય, એને તુલ હાદહે.” ");
INSERT INTO gbl_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","તી વોનાતાજ તારાત ઉઠી એને ચ્યાલ મિળાં ગીયી. ");
INSERT INTO gbl_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ઈસુ આજુ ગાવા બાઆ આતો, જાં માર્થા મિળ્યેલ તાંજ આતો. ");
INSERT INTO gbl_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","તોવે જ્યા યહૂદી લોક મરિયમે આરે ગોઅમે આતેં, એને ચ્ચેલ દિલાસો દી રીઅલે આતેં, ચ્યાહાય મરિયમેલ તારાત ઉઠીન બાઆ જાતી દેખી, તોવે ચ્યા ચ્યે પાહલા-પાહલા ગીયે કાહાકા ચ્યા એહેકોય હોમજ્યા કા તી માહણામાય રોડાં હાટી જાહાય. ");
INSERT INTO gbl_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","જોવે મરિયમ જાં ઈસુ આતો તાં જાય પોઅચી તોવે ચ્યાલ દેખતાજ તી ચ્યાલ પાગે પોડી એને ચ્યે આખ્યાં, “પ્રભુ તું ઈહીં રોતો તોવે મા બાહા નાંય મોઅતો.” ");
INSERT INTO gbl_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","જોવે ઈસુવે ચ્યેલ એને ચ્યે આરે યેનલા યહૂદી લોકહાનબી રોડતા દેખ્યા તોવે ચ્યે હુંઅકા ટાક્યા, બોજ નિરાશ ઓઈ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ઈસુવે આખ્યાં, “તુમહાય ચ્ચાલ કેછ થોવહ્યો?” ચ્યાહાય આખ્યાં, “પ્રભુ, ચાલીન એય લે.” ");
INSERT INTO gbl_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ઈસુ રોડયો. ");
INSERT INTO gbl_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","તોવે યહૂદી લોકહાય આખ્યાં, “એઆ, તો ચ્યાવોય કેહેકે પ્રેમ કોઅતો આતો.” ");
INSERT INTO gbl_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","બાકી ચ્યાહામાઅને કોલહેક જાંએ આખા, “લાગ્યેં, કા જ્યેં આંદળાલ દેખતો કોઅયેલ તો લાજરસાલ મોઅનાથી બોચાવી હોકતો?” ");
INSERT INTO gbl_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ઈસુ બોજ નિરાશ ઓઇન માહાણા પાય યેનો, તાં યોક ગોડદો આતો એને મોઠો દોગાડ ચ્યા બોગારા આલુડ કોઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ઈસુય આખ્યાં, “દોગાડ ફેડી ટાકાં” મોઅલા માઅહા બોઅહી માર્થા ચ્યાલ આખા લાગી, “પ્રભુ, આમી ગાંદાતા ઓરી, કાહાકા ચ્યાલ મોઈન ચાર દિહી ઓઈ ગીઅલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ઈસુય ચ્યેલ આખ્યાં, “કાય માયે તુલ નાંય આખ્યેલ કા, જોવે તું બોરહો કોઅહે, તોવે તું પોરમેહેરા મહિમા એએહે?” ");
INSERT INTO gbl_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","તોવે ચ્યાહાય દોગાડાલ ફેડી લેદો, પાછે ઈસુવે ઉચે નોજાર કોઇન આખ્યાં, “ઓ આબા આંય તો આભાર માનતાહુ કાહાકા તુયે મા વોનાય લેદા. ");
INSERT INTO gbl_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","એને આંય જાંઅતાહાંવ કા સાદા મા વોનાતોહો, બાકી જીં ગીરદી આજુ-બાજુ ઉબલી હેય, ચ્યાહા લીદે માયે મોઠેરે બોંબલીન આખ્યાં, જ્યાથી ચ્યા બોરહો કોએ, કા તુયે માન દોવાડયોહો.” ");
INSERT INTO gbl_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","એહેકેન આખીન બોંબલ્યો, “ઓ લાજરસ બાઆ નિંગી યે.” ");
INSERT INTO gbl_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","જો મોઓઈ ગીઅલો આતો, તો માઅહું બાઆ નિંગી યેનો, ચ્યા આથ પાગ ફાડકા કોઇન વેટાળલા આતા, એને ચ્યા મુંવોય યોક રુંબાળ વેટાળી દેનલો આતો, તોવે ઈસુવે આખ્યાં, “ચ્યા વોયને ફાડકે છોડી દિયા, એને ચ્યાલ જાં દા.” ");
INSERT INTO gbl_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","જ્યા યહૂદી લોક મરિયમ આરે યેનલા આતા, એને ઈસુવે કાય ચમત્કાર કોઅયા તી દેખ્યાં, તોવે ચ્યાહામાઅને બો બોદા માઅહાય ચ્યાવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","બાકી ચ્યાહામાઅને કોલાહાક જાંઆ પોરૂષીયાહા પાય ગીયા એને ઈસુ ચમત્કારા કામહા ખોબાર દેની. ");
INSERT INTO gbl_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","તોવે મુખ્ય યાજક એને પોરૂષીયાહાય મોઠી સોબા લોકહાન હાદિન પુછ્યાં, “આપા કાય કોઅજેહે? ઈ માઅહું તે બોજ ચમત્કાર કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","જો આપા ચ્યાલ નાંય રોકજે, તોવે બોદે માઅહે ચ્યાલ ખ્રિસ્તા રુપામાય બોરહો કોઅરી એને રોમી ઓદિકારી યેઇન યા દેવાળાલ એને યા લોકહા નાશ કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","તોવે ચ્યાહામાઅને કાયફા નાંવા સોબા સભ્ય આતો તો ચ્યા વોરહા મહાયાજક આતો, ચ્યે ચ્યાહાન આખ્યાં, “તુમા કાયજ નાંય જાંએત. ");
INSERT INTO gbl_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","લોકહાહાટી યોકા માઅહાય મોઅરા જોજે એને બોદા દેશહા નાશ નાંય ઓઅરા જોજે, ઈ તુમહેહાટી ફાયદા હેય, ઈ બી તુમહાન નાંય હોમજાય.” ");
INSERT INTO gbl_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","ચ્યે પોતા કોઇન એહેકોય નાંય આખ્યાં, બાકી ચ્યે વોરહે મહાયાજક રોઇન ચ્યા મુંયેકોઇન પોરમેહેરે વાત કોઅયી, કા ઈસુ ઈસરાયેલ લોકહાહાટી મોઅઇ જાનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ઈસુ ઈસરાયેલ લોકહાહાટી ઓલાહાંજ નાંય, બાકી પોરમેહેરા બિજા લોક જ્યા બોદે દોરતીવોય વિખરાઈ ગીઅલે હેય, ચ્યાહાહાટી બી મોઅરી, કા ચ્યા બેનહ્યાન યોકઠે કોય હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","તોવે ચ્યા દિહાપાઅને યહૂદી આગેવાન ઈસુલ માઆઇ ટાકાં યુક્તિ કોઅરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ચ્યે વાતે લીદે ઈસુ પાછે ખુલ્લી રીતે યહૂદી લોકહામાય નાંય ફિર્યો, બાકી તાઅને નિંગીન ઉજાડ જાગા પાહીને વિસ્તાર, એફરાઈમ ગાવામાય જાતો રિયો એને ચ્યા શિષ્યહાઆરે તાંજ રા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","આમી યહૂદીયાહા પાસ્કા સણ પાહાય આતો એને બો બોદા લોક પાસ્કા સણા પેલ્લા, દેવાળામાય પોતાલ ચોખ્ખાં કોઅરાહાટી ગાવામાઅને યેરૂસાલેમ શેહેરામાય યેનલા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ચ્યે ઈસુવાલ હોદતે લાગ્યેં એને દેવાળામાય ઉબા રોઇન યોકબિજાલ આખતે લાગ્યેં, “તુમહાન કાય લાગે? કાય તો સણામાય નાંય યી?” ");
INSERT INTO gbl_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","એને મુખ્ય યાજક એને પોરૂષીયાહાય આગના કોઅલી આતી, જ્યા કાદાલ ખોબાર હેય કા ઈસુ કેછ હેય તો ચ્યાહાન આખે, કા ઈસુલ દોઅઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","પાછો ઈસુ પાસ્કા સણા આજુ છ દિહા પેલ્લા બેથાનીયા ગાવામાય યેનો, જાં ચ્યાય લાજરસાલ મોઅલા માઅને જીવતો કોઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","તાં ચ્યાહાય ચ્યાહાટી ખાઅના બોનાવલા આતા, એને માર્થા ખાઅના વાટતી આતી, એને લાજરસ ઈસુવાઆરે ખાનારાહા માઅને યોક બોઠલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","તોવે મરિયમ યોક હેર (યોક હેર એટલે આરદો કિલો) બો મોઅગાં સુગંદી અત્તાર લેય યેની એને ઈસુવા પાગહાલ ચોપડી દેના એને તી ટોલપી કીહીંયે કોઇન નુહી ટાક્યા એને બોદા ગુઉ ચ્યા તેલા કોઇન સુગન્દિત ઓઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","બાકી ચ્યા શિષ્યહા માઅને યહૂદા ઇસ્કારીયોત નાંવા યોક શિષ્ય જો ચ્યાલ દોઆડી દેનારો આતો, આખા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ઈ અત્તાર તીન હોવ દીનારાહામાય (યોક દીનાર એટલે યોક દિહા કાંબારાં) વેચિન ચ્યા પોયહા ગોરીબાહાન કાહાનાય દેના?” ");
INSERT INTO gbl_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ચ્યાય ઈ યાહાટી નાંય આખ્યાં, કા ચ્યાલ ગોરીબાહા ચિંતા આતી, બાકી યાહાટી આખ્યાં તો બાંડ આતો એને પોયહા ઠેલી ચ્યાપાય રોય એને ચ્યેમાઅને તો દુબીન કાડી લેતો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","તોવે ઈસુવે આખ્યાં, “તી સોમાયા પેલ્લા માન ડાટના તિયારી હાટી ઈ કોઇ રિઅલી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","કાહાકા ગોરીબ લોક તો તુમહેપાય કાયામુંજ રોતેહેં બાકી આંય તુમહેપાય કાયામ નાંય રોહીં.” ");
INSERT INTO gbl_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","જોવે યહૂદી લોક વોનાયા કા ઈસુ તાં હેય, તોવે લોકહા યોક મોઠી ગીરદી તાં યેની, ચ્યે ઈસુવાલુજ નાંય, બાકી લાજરસાલ એઅરા હાટીબી યેનલે આતેં, જ્યાલ ચ્યે મોઅલા માઅને જીવતો કોઅયેલ. ");
INSERT INTO gbl_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","બાકી મુખ્ય યાજકાહાય લાજરસાલ બી માઆઇ ટાકના કાવત્રા કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","કાહાકા ચ્યા લીદે યહૂદીયાહા માઅને બો બોદે માઅહે યહૂદી આગેવાનહાન છોડીન જાતા રોયા, એને ઈસુવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","બીજે દિહે બો બોદા લોક જ્યા સણામાય યેનલા આતા, ઈ વોનાયને કા, ઈસુ યેરૂસાલેમ શેહેરામાય યી રિયહો. ");
INSERT INTO gbl_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","તોવે ચ્યાહાય ખુજરિયે ફીફર્યેં આથામાય લેઈને ચ્યાલ મિળાહાટી નિંગી યેને, એને મોઠેરે બોંબલા લાગ્યેં, “હોસાન્ના, ધન્ય ઈસરાયેલા રાજા, જો પ્રભુ નાંવા કોય યેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","જેહેકોય ઈસુ યેરૂસાલેમ શેહેરામાય યેનો ચ્ચાલ યોક ફુરક્યા ગોદડા વાછડાં મિળ્યાં, તોવે તો ચ્ચાવોય બોહી ગીયો, જેહેકેન પવિત્રશાસ્ત્રમાય લોખલાં હેય. ");
INSERT INTO gbl_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ઓ યેરૂસાલેમ શેહેરા લોકહાય, બીયહા મા, એઆ, તુમહે રાજા તુમહેપાય ફુરક્યા ગોદડા વાછડા ઉપે બોહીન યેહે. ");
INSERT INTO gbl_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ઈસુ શિષ્ય, ઈ વાત પેલ્લા નાંય હોમજ્યા, બાકી પાછે જોવે ઈસુવાલ મહિમા મિળી, તોવે ચ્યાહાન યાદ યેના કા જીં કાય ઈસુઆરે જાયા તી ઠીક એહેકેનુજ આતા જેહેકેન પવિત્રશાસ્ત્રમાય લોખલાં. ");
INSERT INTO gbl_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","તોવે ગીરદ્યેમાઅને લોક જ્યા ચ્યે સમયે ચ્યાઆરે આતેં, ચ્યે બીજહાન આખા લાગ્યેં કા ચ્યાય લાજરસાલ માહણામાઅને હાત કોઇન, મોઅલાહામાઅને જીવતો ઉઠાડયેલ. ");
INSERT INTO gbl_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ચ્યાહાટી માઅહે ચ્યાલ મિળાહાટી યેનલે આતેં, કાહાકા ચ્યાહાન ખોબાર પોડયેલ, ચ્યે ઓહડો ચમત્કાર દેખાડલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","તોવે પોરૂષીયા યોકબીજાહાન આખા લાગ્યા, વિચાર કોઆ, આપા કાય નાંય કોય હોકજે, બોદી દુનિયા ઈસુવા પાહલા ઓઅય રીઅલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","કોલહાક યુનાની લોક તાં આતા, જ્યા સણા સમયે યેરૂસાલેમ શેહેરામાય ભક્તિ કોઅરા યેનલા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ચ્યાહાય ગાલીલ ભાગા બેતસાદા ગાવામાઅને ફિલિપાપાય જાયન ચ્યાહાય ચ્ચાલ વિનાંતી કોઅયી, “સાયબ, આમહાન ઈસુવાલ મિળના હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ફિલિપે યેયન આંદ્રિયાસાલ આખ્યાં એને તોવે આંદ્રિયાસ એને ફિલિપે ઈસુવાપાય જાયને આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","તોવે ઈસુવે ચ્યાહાન આખ્યાં, તો સમય યેય ગીઅલો હેય, કા માન માઅહા પોહા મહિમા ઓએ. ");
INSERT INTO gbl_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, જાવ લોગુ ગોવાં દાણો જમીનીમાય પોડીન મોઓઈ નાંય જાય, તાંવ લોગુ તો યોખલો રોહે, બાકી મોઓઈ જાહે તોવે બોજ દાણા પાકતાહા, મા આરેબી એહેકેજ બોની. ");
INSERT INTO gbl_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","જો પોતાના જીવાલ બોચાવાં માગહે, તો ગુમાવી દેહે, એને જો યા દુનિયામાય પોતાના જીવાલ ગુમાવી દાં માગહે, તો અનંતજીવનાહાટી ચ્ચાલ બોચાવી રાખી. ");
INSERT INTO gbl_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","જીં માઅહું મા સેવા કોઅહે તો મા શિષ્ય બોને, તોવે જાં આંય હેય, તાં મા સેવક બી ઓરી, જો કાદો મા સેવા કોએ, તો પોરમેહેર આબો ચ્ચા કદર કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","આમી મા મોન દુ:ખી ઓઅઇ ગીયા એને આંય કાય આખું? કા, “ઓ આબા, માન યે પીડા સોમયામાઅને બોચાવ?” એહેકેન નાંય, બાકી આંય યા દુનિયામાય ચ્યા હાટીજ યેનહો કા દુઃખ બોગવું. ");
INSERT INTO gbl_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ઓ મા આબા, દેખાડ કા તું કોલહો મહિમામાય હેય તોવે હોરગામાઅને ઓહડો આવાજ ઓઅયો, “માયે દેખાડી દેના કા આંય કોલહો મહિમામાય હેતાંવ, એને આંય યાલ પાછો દેખાડીહી.” ");
INSERT INTO gbl_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","તોવે જ્યા લોક ઉબા રોયન વોનાય રીઅલા આતા, ચ્યાહાય આખ્યાં ઈ તો વાદળામાય ગાજ્યા, બીજહાંય આખ્યાં, “કાદો હોરગા દૂત ચ્યાઆરે બોલ્યો.” ");
INSERT INTO gbl_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ઈસુવે જાવાબ દેયન આખ્યાં, “ઓ આવાજ મા હાટી નાંય, બાકી તુમહે ફાયદાહાટી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","આમી યા દુનિયા લોકહા ન્યાય કોઅરાહાટી પોરમેહેરા સમય હેય, એને ઈસુકોય યા દુનિયા શાસક સૈતાના શક્તિ નાશ કોઇ દી. ");
INSERT INTO gbl_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","એને જોવે આંય દોરતીવોઅને ઉચે ચોડાવલો જાહીં, તોવે બોદહાન માયેપાંય લેય લિહીં.” ");
INSERT INTO gbl_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","એહેકેન આખીન ચ્યે ઈ વાત પ્રગટ કોઇ દેની, કા તો કેહેકે મોઅનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","તોવે લોકહાય ચ્યાલ આખ્યાં, “નિયમશાસ્ત્ર માય આમા એહેકેન વોનાયાહા, કા ખ્રિસ્ત કાયામુંજ જીવતો રોય, તોવે તું કેહેકેન આખતોહો કા માઅહા પોહાલ ઉચે ચોડાવના જરુરી હેય? ઓ માઅહા પોહો કું હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “થોડીવાઆ તુમહે વોચમાય ઉજવાડો હેય, જાવ લોગુ ઉજવાડો તુમહેઆરે હેય તાંવ લોગુ ચાલ્યાજ કોઆ, એહેકેન નાંય બોને કા આંદારાં ઓઈ જાય, જીં માઅહું આંદારામાય ચાલહે, ચ્યાલ ખોબાર નાંય કા તો કેછ જાય રિયહો. ");
INSERT INTO gbl_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","જાવ લોગુ ઉજવાડો તુમહેઆરે હેય, તાંવ લોગુ ઉજવાડાવોય બોરહો કોઆ કા તુમા ઉજવાડા પોહેં બોના” યો વાતો આખીન ઈસુ તાઅને જાતો રિયો એને ચ્યાહા પાયને ગુપ્તમાય રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","એને ઈસુવે ચ્યાહા દેખતા બોજ ચમત્કાર કોઅયા, તેરુંબી ચ્યાહાય ચ્યાવોય બોરહો નાંય કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ઈ યાહાટી જાયા કા યશાયા ભવિષ્યવક્તાય જીં વચન આખ્યેલ તી હાચ્ચાં ઓઈ જાય, “ઓ પ્રભુ, આમહે સંદેશ વોય કુંયે બોરહો કોઅયો, એને પોરમેહેરા સામર્થ્ય કુંયે હોમજી પાડ્યા?” ");
INSERT INTO gbl_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ચ્યાહાટી ચ્યા બોરહો નાંય કોઇ હોક્યા, કાહાકા યશાયા ભવિષ્યવક્તાય પાછા આખ્યેલ, ");
INSERT INTO gbl_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ચ્યાય ચ્યાહા ડોળા આંદળા કોઇ દેના કા ચ્યા એઇ નાંય હોકે, એને ચ્યાહા દિમાક બંદ કોઇ દેના કા ચ્યા હોમજી નાંય હોકે, ને તો ચ્યા મા એછે ફિરી યેતે એને આંય ચ્યાહાન હારાં કોઇ દેતો.” ");
INSERT INTO gbl_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","યશાયાય યો વાતો યાહાટી આખ્યેલ, કાહાકા ચ્યાય સોમાયા પેલ્લા ઈસુ મહિમા દેખ્યેલ એને ચ્ચાય ચ્ચા બારામાય વાતો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","તેરુંબી આગેવાનહા માઅને બો બોદહાય ચ્યાવોય બોરહો કોઅયો, બાકી પોરૂષીયાહા લીદે ખુલ્લી રીતે નાંય બોરહો કોઅતા આતા, યા દાકે કા ચ્યાહાન સોબાયે ઠિકાણા માઅને બાઆ નાંય કાડી દેય. ");
INSERT INTO gbl_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","કાહાકા માઅહા વાહવા ચ્યાહાન પોરમેહેરા વાહવા કોઅતા વોદારી પ્રિય ગોમહે. ");
INSERT INTO gbl_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ઈસુવે ગીરદીલ મોઠેરે બોંબલીન આખ્યાં, “જીં માઅહું માયેવોય બોરહો કોઅહે, તી માયેવોય નાંય, બાકી માન દોવાડનારાવોય બોરહો કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","એને જીં માઅહું માન એઅહે, તો જ્યેં માન દોવાડયોહો ચ્યાલ એઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","આંય યા દુનિયામાય ઉજવાડો બોનીન યેનહો, કા જો કાદો માયેવોય બોરહો કોએ, તો આંદારામાય નાંય રોય. ");
INSERT INTO gbl_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","એને જીં માઅહું મા વાત વોનાય તેરુંબી નાંય પાળે, તો આંય ચ્યાલ ડોંડ નાંય દાવ, કાહાકા આંય દુનિયા લોકહાન ડોંડ દાં નાંય, બાકી દુનિયા લોકહાન બોચાવાં હાટી યેનહો. ");
INSERT INTO gbl_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","જીં માઅહું મા નાકાર કોઅહે એને મા વાત સ્વીકાર નાંય કોએ, ચ્યાલ ડોંડ દેનારો તો યોક હેય, મતલબ જીં વાત માયે આખલી હેય, તી ન્યાયા દિહે ચ્યાલ ડોંડ દેઅરી. ");
INSERT INTO gbl_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","કાહાકા માયે મા પોતા ઓદિકારા કોઇન વાત નાંય કોઅયી, બાકી પોરમેહેર આબહે જ્યેં માન દોવાડયોહો ચ્યાય માન આગના દેનહી, કા આંય કાય આખું એને કેહેકેન આખું? ");
INSERT INTO gbl_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","એને આંય જાંઅતાહાંવ, કા ચ્યા આગના પાળના અનંતજીવના એછે લેય જાહે, યાહાટી આંય જીં આખહુ જેહેકેન પોરમેહેર આબહે માન આખ્યાહા, તેહેકેન આંય આખતાહાવ.” ");
INSERT INTO gbl_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","પાસ્કા સણા પેલ્લા જોવે ઈસુ જાંઆય ગીયો, કા મા સમય યેય ગીયહો, કા દુનિયા છોડીન પોરમેહેર આબહાહી પાછો ફિરી જાવ, તોવે ચ્યાવોય બોરહો કોઅનારા લોકહાવોય, જ્યેં દુનિયામાય આતેં, જેહેકેન તો પ્રેમ કોઅતો આતો, સેલે લોગુ તેહેકેન પ્રેમ કોઅતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ઈસુ એને ચ્યા શિષ્ય રાતી ખાઅના ખાં બોઠલા આતા, સૈતાને પેલ્લાજ સિમોના પોહો યહૂદા ઇસ્કારીયોતા મોનામાય ઈસુવાલ દોગો દેઅના વિચાર થોવ્યેલ. ");
INSERT INTO gbl_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ઈસુ ઈ જાંઅતો આતો, કા પોરમેહેર આબહે બોદા કાય ચ્યા ઓદિકારામાય હોઅપી દેનહા એને તો પોરમેહેરાપાઅને યેનહો એને પોરમેહેરાપાય પાછો જાય રિઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ઈસુ ખાઅના ખાય તાઅને ઉઠયો, એને ચ્યા બાઆને ડોગલાં કાડયા, એને રુંબાળ લેઈને કોંબરા આરે બાંદ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ચ્યા પાછે ઈસુય વાહાણામાય પાઆય બોઇન શિષ્યહા પાગ દોવાં એને જો રુંબાળ ચ્યા કોંબરા આરે બાંદલો આતો ચ્યાકોય નુંહરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","જોવે તો સિમોના પિત્તરા પાય યેનો, તોવે પિત્તરે ચ્યાલ આખ્યાં, “ઓ પ્રભુ, કાય તું મા પાગ દોવતોહો?” ");
INSERT INTO gbl_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ઈસુવે જાવાબ દેનો કા, “જીં આંય કોઅતાહાંવ તીં તુલ આમી હોમાજ નાંય પોડે, બાકી પાછે હોમાજ પોડી.” ");
INSERT INTO gbl_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","પિત્તરે આખ્યાં, “તું મા પાગ કોવેજ દોવી નાંય હોકહે,” ઈ વોનાયને ઈસુવે આખ્યાં, “જોવે આંય નાંય દોવું તોવે તું મા શિષ્ય નાંય.” ");
INSERT INTO gbl_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","સિમોન પિત્તરે આખ્યાં, તારાત બોલ્યો, “તોવે પ્રભુ, મા પાગ ઓલહાંજ નાંય, બાકી મા આથ એને ટોલપી હોગી.” ");
INSERT INTO gbl_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ઈસુવે ચ્યાલ આખ્યાં, “જો આંગળી ચુકયોહો, ચ્યાલ ખાલી પાગ દોવના ગોરાજ હેય, ચ્યા બોદા શરીર ચોખ્ખાં હેય, તુમા યોકાલ છોડીન બોદા ચોખ્ખાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ઈસુ તે ચ્યાલ દોગો દેનારાલ જાંઅતો આતો, ચ્યાહાટી ચ્યે આખ્યાં, કા “તુમા યોકાલ છોડીન બોદા ચોખ્ખાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","જોવે ઈસુ ચ્યાહા પાગ દોવી ચુક્યો એને ચ્યા બાઆને ડોગલાં પોવીન બોહી ગીયો પાછે તો શિષ્યહાન આખા લાગ્યો, “કાય તુમા હોમજ્યા કા માયે તુમહેઆરે કાય કોઅયા? ");
INSERT INTO gbl_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","તુમા માન ગુરુ, એને પ્રભુ, આખતાહા, તી હાચ્ચાં આખતાહા, કાહાકા આંય તુમહે ગુરુ એને પ્રભુ બી હેતાઉ. ");
INSERT INTO gbl_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","જોવે આંય પ્રભુ એને ગુરુ હેતાંવ તેરુંં તુમહે પાગ દોવ્યા, તોવે તુમહાય બી યોક બીજહા પાગ દોવીન માયે હારકા કોઅરા જોજે. ");
INSERT INTO gbl_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","કાહાકા માયે તુમહાન નમુનો દેખાડયો, તોવે કા જેહેકેન માયે તુમહેઆરે કોઅયા, તુમાબી તેહેકેન કોઅયા કોઅરા. ");
INSERT INTO gbl_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, સેવક ચ્યા માલિકા કોઅતો મોઠો નાંય હેય, એને દોવાડલો ચ્યાલ દોવાડનારા કોઅતો મોઠો નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","આમી તુમા યો વાતો જાંઅતાહા, તો ચ્યાહાન કોઆ કા તુમા ધન્ય ઓઈ જાય. ");
INSERT INTO gbl_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","આંય તુમા બોદહા બારામાય નાંય આખું, કાહાકા માયે જ્યાહાન નિવડી લેદલા હેય, આંય ચ્યાહાન જાંઅતાહાંવ, બાકી એહેકેન યાહાટી ઓઈ રીઅલા હેય કા પવિત્રશાસ્ત્રમાય લોખલાં હેય તી પુરાં ઓરા જોજે, કા જ્યાંય મા આરે ખાઅના ખાદાં, ચ્યાય માન દોગો દેનો. ");
INSERT INTO gbl_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","આમી ઈ બોને ચ્યા પેલ્લા, આંય તુમહાન આખતાહાવ કા ઈ બોની જાય તોદહી તુમા બોરહો કોઅહા કા આંય તોજ હેતાઉ. ");
INSERT INTO gbl_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, જ્યાલ માયે દોવાડયોહો ચ્યાલ જો માની લેહે, તો હાચ્ચાંજ મા માની લેહે, જો કાદો મા માની લેહે, તો હાચ્ચાંજ પોરમેહેરાબી માની લેહે જ્યાંય માન દોવાડયોહો.” ");
INSERT INTO gbl_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","યો વાતો આખ્યો પાછે ઈસુ મોનામાય દુ:ખી ઓઅય ગીયો, એને શિષ્યહાન આખ્યાં, આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, તુમહેમાઅને યોક જાંઆ માન દોઅય દી. ");
INSERT INTO gbl_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","તોવે ચ્યા શિષ્ય એહેકેન શંકા કોઅતા આતા, કા તો કા બારામાય આખહે, યોકા બિજા એછે એઅતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ચ્યા શિષ્યહા માઅને યોક જ્યાવોય ઈસુ પ્રેમ કોઅતો આતો, ઈસુ બાજુ માય બોઠલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","સિમોન પિત્તરે ચ્યાએછે ઈશારો કોઇન પુછ્યાં, “પુછ તે, તો કા બારામાય આખહે?” ");
INSERT INTO gbl_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","તોવે ચ્યાય ઈસુવા એછે વોળીન ચ્યાલ પુછ્યાં, “પ્રભુ, તો કું હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ઈસુવે જવાબ દેનો, “જ્યાલ ઈ આંય બાખ્યે કુટકો થાળીમાય બુડવીન દેતહાવ તોજ હેય.” તોવે ઈસુય કુટકો થાળીમાય બુડવીન સિમોના પોહો યહૂદા ઈસ્કારિયોતાલ દેનો. ");
INSERT INTO gbl_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","જેહેકેન યહૂદાય બાખી કુટકો ખાદો પાછે, ઈસુવે જવાબ દેનો, “જ્યાલ ઈ આંય બાખ્યે કુટકો થાળીમાય બુડવીન દેતહાવ તોજ હેય.” ઈસુય આખ્યાં, “તું જીં કોઅરા જાય રિઅલો હેય, ચ્યાલ તારાત કોઓ, એને સૈતાન ચ્યામાય ઉરાય ગીયો.” ");
INSERT INTO gbl_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","બાકી ખાં બોઠલાહામાઅને કાદે નાંય જાંઅયા, યો વાતો કાહાટી ઈસુય આખ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","યહૂદાપાય પોયહા ઠેલી રોય ચ્યાહાટી કાદે-કાદે એહેકેન હોમજ્યા, કા ઈસુ ચ્યાલ આખહે, કા જીં કાય આપહાન સણાહાટી જોજહે તી વેચાતાં લેય, કા ઈ કા ગોરીબાહાન કાય દેય. ");
INSERT INTO gbl_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","બાખ્યે કુટકો ખાદો પાછે યહૂદા તારાત બાઆ નિંગી ગીયો, તોવે રાત આતી. ");
INSERT INTO gbl_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","જોવે તો બાઆ નિંગી ગીયો તોવે ઈસુવે આખ્યાં, “આમી માઅહા પોહા મહિમા જાયી એને પોરમેહેરા મહિમા ચ્યામાય જાયી. ");
INSERT INTO gbl_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","એને પોરમેહેર બી પોતામાંય ચ્યા પોહા મહિમા કોઅરી, એને તો તારાત કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ઓ પોહહાય, આંય આજુ વાયજ વાઆ તુમહેઆરે હેતાઉ પાછા તુમા માન હોદહા બાકી જેહેકેન યહૂદી લોકહાન માયે આખ્યાં, જાં આંય જાય રિયહો, તાં તુમા નાંય યી હોકે, એને આમીબી તુમહાન તેહેકેનુજ આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","આંય તુમહાન યોક નોવી આગના દેતહાવ, કા તુમા યોક બીજહાવોય પ્રેમ કોઆ જેહેકેન માયે તુમહાવોય પ્રેમ કોઅયા, તેહેકેન તુમા યોક બીજહાન પ્રેમ કોઆ. ");
INSERT INTO gbl_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","જોવે તુમા યોક બિજાવોય પ્રેમ કોઅહા, તોવે બોદે તુમહાન જાંઆય લી કા મા શિષ્ય હેતા.” ");
INSERT INTO gbl_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","સિમોન પિત્તરે ચ્યાલ આખ્યાં, “ઓ પ્રભુ, તું કેછ જાય રિયહો?” ઈસુવે ચ્યાલ જાવાબ દેનો, “જાં આંય જાય રિયહો, તાં તું આમી મા પાહલા નાંય યી હોકા, બાકી ચ્યા પાછે તું મા પાહલા યેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","પિત્તરે ઈસુવાલ આખ્યાં, “ઓ પ્રભુ, આમી આંય તો પાહલા કાહાનાય યી હોકુ? આંય તે તોહાટી મોઅરા બી તિયાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ઈસુવે જાવાબ દેનો, “કાય તું માંહાટી મોઅહે? આંય તુલ હાચ્ચાં-હાચ્ચાં આખતાહાવ, કુકાડ વાહાય ચ્યા પેલ્લા તું તીનદા આખહે આંય નાંય વોળખું.” ");
INSERT INTO gbl_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“તુમા મોનામાય દુઃખી નાંય ઓઅતા, તુમા પોરમેહેરાવોય બોરહો કોઅતાહા માયેવોય બી બોરહો કોઆ. ");
INSERT INTO gbl_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","મા પોરમેહેર આબહા ગોઆમાય રોઅના બોજ જાગો હેય, જોવે નાંય રોતા તોવે તુમહાન આંય આખતો કાહાકા આંય તુમહેહાટી જાગો તિયારી કોઅરા જાય રિયહો. ");
INSERT INTO gbl_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","આંય તાં જાયને જાગો તિયાર કોઇન પાછે આંય પાછો યેયન, તોવે તુમહાન મા આરે રા લેય યીહીં, યાહાટી કા જાં આંય હેતાઉ તાં તુમાબી રોહા. ");
INSERT INTO gbl_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","એને જાં આંય જાય રિયહો તાંઆની વાટ તુમહાન ખોબાર હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","થોમાય ચ્યાલ આખ્યાં, “ઓ પ્રભુ, આમહાન નાંય ખોબાર કા તું કેછ જાય રિયહો, તોવે આમા વાટ કેહેકેન જાંઆય હોકજે?” ");
INSERT INTO gbl_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ઈસુવે ચ્યાલ આખ્યાં, “વાટ એને હાચ્ચાં એને અનંતજીવન આંયજ હેતાંવ, માયે વોગાર કાદો પોરમેહેર આબહાપાય નાંય જાય હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","જોવે તુમા માન જાઅતા, તોવે મા આબહાલ બી જાઅતા, એને આમી ચ્યાલ જાંઅતાહા, એને ચ્યાલ દેખ્યહો બી.” ");
INSERT INTO gbl_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ફિલિપે ચ્યાલ આખ્યાં, “ઓ પ્રભુ, આબહાલ આમહાન દેખાડી દે, ઈ આમહેહાટી બો ઓઅઇ ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ઈસુવે ચ્યાલ આખ્યાં, “ઓ ફિલિપ, આંય ઓલા દિહી તુમહેઆરે હેતાંવ, એને કાય તું માન નાંય જાંઅતોહો? જ્યાંય માન દેખ્યો, ચ્યાય પોરમેહેર આબહાલ દેખ્યહો, તું કાહા આખતોહો કા આબહાલ આમહાન દેખાડ? ");
INSERT INTO gbl_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","આંય આબહામાય હેતાઉ એને માંયેમાય આબહો હેય, કાય તું યે વાતવોય બોરહો નાંય કોઆ? જીં વાત આંય તુમહાન આખતાહાવ, મા પોતા ઓદિકારા કોઇન નાંય આખતાહાવ, બાકી આબહો માંયેમાય રોયન તીંજ કામ કોઅહે જીં તો કોઅરા માગહે. ");
INSERT INTO gbl_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","માયેવોય બોરહો કોઆ, આંય આબહામાય હેતાઉ એને આબહો માંયેમાય હેય, નાંય તો જ્યા માયે ચમત્કાર કોઅલા હેય ચ્યાહા લેદે માયેવોય બોરહો કોઆ.” ");
INSERT INTO gbl_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","“આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, જો કાદો માયેવોય બોરહો કોઅહે, યે કામે જ્યેં આંય કોઅતાહાંવ તોબી કોઅરી, બાકી ચ્યાકોઅતે બી મોઠે કામ કોઅરી, કાહાકા આંય આબહાપાય જાય રિયહો. ");
INSERT INTO gbl_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","એને જીં કાય તુમા મા નાવાકોય માગહા તીંજ આંય કોઅહી કા પોહાકોય આબહા મહિમા ઓએ. ");
INSERT INTO gbl_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","જોવે તુમા માપાયને મા નાંવે કોય કાયબી માગહા, તો તી આંય કોઅહી.” ");
INSERT INTO gbl_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","જોવે તુમા માયેવોય પ્રેમ કોઅતાહા, તોવે મા આગના પાળહા. ");
INSERT INTO gbl_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","એને આંય આબહાલ પ્રાર્થના કોઅહી, એને તો તુમહાન આજુ યોક મોદાત્યો દી, કા તો કાયામ તુમહેઆરે રોય. ");
INSERT INTO gbl_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","તો તી આત્મા હેય, જીં પોરમેહેરાબારામાય હાચ્ચાં પ્રગટ કોઅહે, જ્યાલ દુનિયા લોક સ્વીકાર નાંય કોઅય હોકે, કાહાકા દુનિયા લોક નાંય ચ્ચાલ એઇ હોકે નાંય ચ્ચાલ જાંઅતેહે, બાકી તુમા ચ્યાલ જાંઅતેહે, કાહાકા તી તુમહેઆરે રોહે, એને તો તુમહેમાય રોય. ");
INSERT INTO gbl_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“આંય તુમહાન અનાથ નાંય છોડહી, આંય તુમહેપાય પાછો યેતહાવ. ");
INSERT INTO gbl_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","માહારીજ દુનિયા માન નાંય એઅરી, બાકી તુમા માન એઅહા, કાહાકા આંય પાછો જીવી જાહીં, એને યાહાટી તુમાબી જીવતા રોહા. ");
INSERT INTO gbl_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","જોવે આંય જીવતો પાછો યીહીં, તોવે તુમા જાંઆય લાહા, કા આંય મા આબહામાય હેતાઉ, એને તુમા માંયેમાય હેતા, એને આંય તુમહેમાય હેતાઉ. ");
INSERT INTO gbl_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","જો મા આગના જાંઅહે એને પાળહે તોજ માયેવોય પ્રેમ કોઅહે, એને જો માયેવોય પ્રેમ કોઅહે, ચ્યાવોય મા આબહો પ્રેમ કોઅરી, એને આંય ચ્યાવોય પ્રેમ કોઅહી, એને આંય પોતાલ ચ્યાવોય પ્રગટ કોઅહી.” ");
INSERT INTO gbl_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ચ્યા યહૂદાય જો ઇસ્કારીયોત નાંય આતો, ચ્યાલ આખ્યાં, “ઓ પ્રભુ, કાય જો કા તું પોતાલ આમહાવોય પ્રગટ કોઅરા માગતોહો, એને દુનિયા લોકહાવોય નાંય?” ");
INSERT INTO gbl_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ઈસુવે ચ્યાલ જાવાબ દેનો, “આંય પોતાલ ઓહડા લોકહાન દેખાડતાહાવ, જ્યેં માયેવોય પ્રેમ કોઅતેહે, એને મા આગના પાળતેહે, એને મા આબહો ચ્યાવોય પ્રેમ કોઅરી, એને આપા ચ્યા પાહે યાહાવ, એને ચ્યાઆરે રાહાવ. ");
INSERT INTO gbl_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","જો કાદો માયેવોય પ્રેમ નાંય કોએ, તો મા આગના નાંય પાળે, એને જીં વચન તુમા વોનાતેહે, તી મા નાંય હેય, બાકી જ્યેં માન દોવાડયોહો ચ્યા આબહા હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“યો વાતો માયે તુમહેઆરે રોઇન તુમહાન આખ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","બાકી મોદાત્યો એટલે પવિત્ર આત્મા જ્યાલ આબહે મા ઓદિકાર હાતે દોવાડી, પવિત્ર આત્મા તુમહાન બોદા હિકાડી, એને જીં કાય માયે આખલા હેય, પવિત્ર આત્મા તુમહાન યાદ કોઆડી.” ");
INSERT INTO gbl_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","આંય તુમહાન શાંતી દેતહાવ એટલે તી શાંતી જીં માયેપાંય હેય, ઈ તી શાંતી નાંય જીં દુનિયા દી હોકહે, તોહડી આંય નાંય દાંઉ, તુમા મોનામાય દુ:ખી નાંય ઓઅતા એને બીયહા મા. ");
INSERT INTO gbl_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","તુમા વોનાયા કા માયે તુમહાન કાય આખ્યાં, આંય જાય રિયહો એને પાછો તુમહેપાય યેતહાવ જોવે તુમા માન પ્રેમ કોઅતા, તોવે તુમા યે વાતોકોય ખુશ ઓઅતા, કા આંય આબહાપાય જાતહાવ કાહાકા આબહો મા કોઅતા મોઠો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","એને આમીંજ યો વાતો બોને ચ્યા પેલ્લા તુમહાન માયે આખી દેના, યાહાટી કા જોવે ઈ બોને તોવે તુમા માયેવોય બોરહો કોઆ. ");
INSERT INTO gbl_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","આમી માયેપાંય તુમહેઆરે વાત કોઅરા બોજ સમય નાંય હેય, કાહાકા યા દુનિયા શાસક સૈતાન યેય રોયહો, એને માયેવોય ચ્યા કાય ઓદિકાર નાંય. ");
INSERT INTO gbl_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","આંય તેહેકેજ કોઅતાહાંવ જેહેકેન આબહે માન આગના દેનહી, યાહાટી કા દુનિયા લોકહાન ખોબાર પોડે કા આંય આબહાવોય પ્રેમ કોઅતાહાંવ, ઉઠા, આપા ઇહિને જાતા. ");
INSERT INTO gbl_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“હાચ્ચો દારાખાવેલો આંય હેતાઉ, એને મા આબહો દારાખા વાડીવાળો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","જીં ડાહગી માંયેમાય લાગલી હેય, એને ફળ નાંય લાગે, ચ્યેલ તો ખાંડી ટાકહે, એને જ્યેલ ફળ લાગતેહે, ચ્યેલ તો ડાળી ટાકહે તોવે કા તી આજુ ફળ દેય. ");
INSERT INTO gbl_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","જીં વચન માયે તુમહાન આખ્યાં ચ્યા લીદે, તુમા ચોખ્ખાં ઓઈ ગીયહા. ");
INSERT INTO gbl_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","તુમા માયે માય રોજા, એને આંય તુમહેમાય રોહીં. જેહેકેન ડાહગી વેલામાય નાંય બોની રોય, તો પોતે નાંય ફળ દી હોકે, તેહેકેન તુમાબી હારાં કામ નાંય કોઇ હોકે જોવે તુમા માંયેમાય નાંય બોની રોય. ");
INSERT INTO gbl_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","આંય દારાખાવેલો હેતાઉ, તુમા ડાહગ્યો હેય, જો માયે માય બોની રોહોય, એને આંય ચ્યામાય, તી બોજ હારાં કામ કોઅહા, કાહાકા માયે વોગાર તુમા કાય નાંય કોઇ હોકતાહા. ");
INSERT INTO gbl_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","જો કાદાં માઅહું માંયેમાય નાંય રોય તોવે ડાહગી હારકા કાપી ટાકી દેનલા જાહે તોવે તી ડાહગી ઉખાય જાહે એને લોક ચ્ચાલ બેગા કોઇન આગડામાય ટાકી દેતહેં, એને તી બોળી જાહે. ");
INSERT INTO gbl_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","જોવે તુમા માંયેમાય બોની રાહા, એને મા શિક્ષણ તુમહેમાય રોહોય, તોવે તુમા જીં કાય માગહા તીં તુમહાન મિળી. ");
INSERT INTO gbl_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","મા આબહા મહિમા યાકોયજ ઓઅહે, કા તુમા બોજ ફળ દેય, તોવે તુમા મા શિષ્ય ઠોરહા. ");
INSERT INTO gbl_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","જેહેકેન પોરમેહેર આબહે માયેવોય પ્રેમ કોઅયા, તેહેકેન માયે તુમહાવોય પ્રેમ કોઅયા, મા પ્રેમમાય બોની રોજા. ");
INSERT INTO gbl_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","જોવે તુમા મા આગના પાળહા, તોવે તુમા મા પ્રેમમાય બોની રાહા જેહેકેન આંય પોતાના આબહા આગના પાળતાહાવ એને આંય ચ્યા પ્રેમમાય બોની રોહુ જેહેકોય માયે આબહા આગના પાળહી. ");
INSERT INTO gbl_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","માયે યો વાતો તુમહાન યાહાટી આખ્યો, કા તુમહેમાય બી તોજ આનંદ રોય, એને તુમહે આનંદ ભરપુર ઓઈ જાય.” ");
INSERT INTO gbl_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","મા આગના ઈ હેય કા જેહેકોય માયે તુમહાવોય પ્રેમ કોઅયાહાં, ચ્ચે રીતે તુમાબી યોક બિજાવોય પ્રેમ કોઆ. ");
INSERT INTO gbl_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","યોકા માઅહાહાટી ચ્યા હાંગાત્યાહાન દેખાડાં હાટી કા તો ચ્યાવોય પ્રેમ કોઅહે, બોદહા કોઅતો હારો તરીકો ઓ હેય, કા તો મોઅઇ જાય. ");
INSERT INTO gbl_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","જીં આગના આંય તુમહાન દેતહાવ, જોવે તુમા પાળે, તો તુમા મા દોસ્તાર હેય. ");
INSERT INTO gbl_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","આમીને તુમહાન ચાકાર નાંય આખું, કાહાકા ચાકાર નાંય જાંએ, કા માલિક કાય કોઅહે, બાકી તુમહાન માયે દોસ્તાર આખ્યાં, કાહાકા માયે જ્યો વાતો આબહા પાઅને વોનાયો, ચ્યો બોદ્યો તુમહાન આખી દેન્યો. ");
INSERT INTO gbl_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","તુમહાય માન નાંય નિવડયો, બાકી માયે તુમહાન નિવડયા, એને તુમહાન નેમહ્યા કા તુમા જાયન ફળ લીયા, એને તુમહે ફળ ટોકી રોય, કા તુમા મા શિષ્ય હેય યાહાટી આબહાવોય માગા, એને તો તુમહાન દી. ");
INSERT INTO gbl_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","યે વાતહે આગના આંય તુમહાન યાહાટી દેતહાવ, કા તુમા યોક બીજહાન પ્રેમ કોઆ. ");
INSERT INTO gbl_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","જોવે દુનિયા લોક તુમહેઆરે આડાઇ કોએ, તોવે યાદ કોઆ કા ચ્ચાહાય તુમહેઆરે આડાઇ કોઅરા પેલ્લા ચ્યાહાય મા આરેબી આડાઇ કોઅયીહી. ");
INSERT INTO gbl_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","જોવે તુમા દુનિયા લોકહા રોકે રોતે, તોવે દુનિયા લોક પોતે માઅહાલ પ્રેમ કોઅતા, બાકી તુમા દુનિયા લોક નાંય હેતા, બાકી માયે તુમહાન દુનિયામાઅને નિવડી લેદહા, ચ્યાહાટી દુનિયા લોક તુમહેઆરે આડાઇ કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","જીં માયે તુમહાન આખ્યેલ કા, “માલિકા કોઅતો ચાકાર મોઠો નાંય,” તી વાત યાદ કોઆ ચ્ચાહાય માન સોતાવ્યા, તો ચ્ચા તુમહાનબી સોતાવી,, જોવે ચ્યે મા વાત પાળી, તોવે તુમહે બી વાત પાળી. ");
INSERT INTO gbl_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","બાકી ઈ બોદા ચ્યા લોક તુમા મા શિષ્ય હેય યા લેદે તુમહેઆરે કોઅરી, કાહાકા ચ્યા માન દોવાડનારા પોરમેહેરાલ નાંય વોળખે. ");
INSERT INTO gbl_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","જોવે આંય નાંય યેતો એને ચ્યાહાઆરે વાત નાંય કોઅતો, તોવે ચ્યે પાપી નાંય ગોણાતે, બાકી આમી ચ્યાહાન પાપા બારામાય આખના કાયજ બહાનો નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","જો કાદો મા આરે આડાઇ કોઅહે, તો મા આબહા આરેબી આડાઇ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","જોવે આંય ચ્યાહામાય ચમત્કાર નાંય કોઅતો, જો બિજા કાદે નાંય કોઅયા, તોવે ચ્યે પાપી નાંય ગોણાતે, બાકી આમી ચ્યાહાય માન એને મા આબહાય જીં કાય કોઅયા તી દેખ્યા બી, તેરુંબી ચ્યાહાય આમહે આરે આડાઇ કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ઈ યાહાટી જાયા કા નિયમશાસ્ત્ર માય લોખલાં હેય તી હાચ્ચાં બોને, કા “ચ્યાહાય વોગાર કારણે મા આરે આડાઇ કોઅયી.” ");
INSERT INTO gbl_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","આંય આબાઇહીને તુમહેહાટી યોક મોદાત્યો દોવાડીહી, તો આત્મા હેય, જીં આબહા પાઅને યેહે, એને જીં હાચ્ચાં હેય તી પ્રગટ કોઅહે, જોવે તો યી, તોવે તો તુમહાન મા બારામાય આખરી. ");
INSERT INTO gbl_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","એને તુમા મા બારામાય દુનિયા લોકહાન આખહા, કાહાકા સુરુવાતપાઅને તુમા મા આરે રીયહા. ");
INSERT INTO gbl_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ઈ વાત તુમહાન માયે યાહાટી આખી, કા તુમહે બોરહો ટુટી નાંય જાય. ");
INSERT INTO gbl_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ચ્યા તુમહાન ચ્યાહા સોબાયે ઠિકાણા માઅને કાડી દી, બાકી ઓહડો સમય યી રોયહો, કા જો કાદો તુમહાન માઆઇ ટાકી, તો એહેકોય હોમજી કા આંય પોરમેહેરા સેવા કોઅતાહાંવ. ");
INSERT INTO gbl_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","એને ઈ ચ્યા યાહાટી કોઅરી, કાહાકા ચ્યાહાય આબહાલ નાંય જાંઅયા એને માન બી નાંય જાંઅયા. ");
INSERT INTO gbl_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","બાકી યો વાતો માયે યાહાટી તુમહાન આખી દેન્યો, કા જોવે તો સમય યેય, તોવે તુમહાન યાદ યેય, કા માયે તુમહાન પેલ્લા આખી દેનલા આતા. જોવે તુમા શુરવાતમાય મા શિષ્ય બોન્યા, તોવે તુમહાન યાહાટી નાંય આખ્યાં કાહાકા આંય તુમહેઆરે આતો.” ");
INSERT INTO gbl_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","આમી આંય માન દોવાડયો ચ્યાપાય જાય રિયહો એને તુમહેમાઅને કાદો માન નાંય પુછે, “તું કેછ જાય રિયહો?” ");
INSERT INTO gbl_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","બાકી માયે જો યો વાતો તુમહાન આખ્યો, યાહાટી તુમા મોનામાય બોજ દુ:ખી ઓઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","બાકી તેરુંબી આંય તુમહાન હાચ્ચાં આખતાહાવ, કા મા જાઅના તુમહેહાટી હારાં હેય, કાહાકા જો આંય નાંય જાંઉ, તોવે મોદાત્યો તુમહેપાય નાંય યી, બાકી જોવે આંય જાહીં, તોવે ચ્યાલ તુમહેપાય આંય દોવાડીહી. ");
INSERT INTO gbl_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","એને જોવે તો યી, તોવે તો દુનિયા લોકહા પાપ એને ન્યાયપણા એને ન્યાયા બારામાય સાબિતી દી. ");
INSERT INTO gbl_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","પાપા બારામાય યાહાટી સાબિતી કોઅરી કાહાકા ચ્યે માયેવોય બોરહો નાંય કોએ. ");
INSERT INTO gbl_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ન્યાયપણા બારામાય યાહાટી સાબિતી કોઅરી, કાહાકા આંય આબાપાય પાછો જાય રિયહો એને તુમા પાછે માન નાંય એઅહા. ");
INSERT INTO gbl_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ન્યાયા બારામાય યાહાટી સાબિતી કોઅરી, કાહાકા પોરમેહેરાય પેલ્લાથી યા દુનિયા શાસક એટલે સૈતાનાલ દોષી ઠોરાવલો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“આજુ બોજ વાતો આંય તુમહાન આખા માગહુ, બાકી આમી તુમા ચ્યાહાન નાંય સહન કોઇ હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","બાકી જોવે તો હાચ્ચાં આત્મા યી, તોવે તો તુમહાન પોરમેહેરાબારામાય જીં હાચ્ચાં હેય તી હોમજાડી, કાહાકા તો પોતા ઓદિકારા કોઇન નાંય આખી, બાકી જીં પોરમેહેરાપાઅને વોનાયી, તીંજ આખી, એને આગલા ઓઅનાર્યો વાતો તુમહાન આખી. ");
INSERT INTO gbl_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","તો મા મહિમા કોઅરી, કાહાકા મા પાઅને ચ્યાલ જીં મિળલા હેય, તો તુમહાન તીંજ આખી. ");
INSERT INTO gbl_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","જીં કાય પોરમેહેર આબા હેય, તી બોદા મા હેય, ચ્યાહાટી માયે તુમહાન આખ્યાં, કા તો મા પાઅને જીં મિળલા હેય, તો તુમહાન તીંજ આખી.” ");
INSERT INTO gbl_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“વાયજ વાઆમાય તુમા માન નાંય એઅહા, એને વાયજ વાઆ પાછે તુમા માન એઅહા.” ");
INSERT INTO gbl_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","તોવે ચ્યા કોલહાક શિષ્યહાય ચ્યાહામાયજ આખ્યાં, “ઈ કાય હેય? જીં તો આમહાન આખહે કા, ‘વાયજ વાઆ પાછે તુમા માન નાંય એઅહા, એને વાયજ વાઆ પાછે તુમા માન પાછા એઅહા’ એને ઈ ‘યાહાટી કા આંય આબહાપાય જાય રિયહો?’” ");
INSERT INTO gbl_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","તોવે ચ્યા યોકાબીજાલ પુછા લાગ્યા, “ઈ ‘વાયજ વાઆ’ એહેકેન તો આખહે, કાય મતલબ હેય? આમહાન હોમાજ નાંય પોડે તો કાય આખી રિયહો.” ");
INSERT INTO gbl_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ઈસુવે ઈ જાઇન કા ચ્યા માયેપાઅને યે વાતહે મોતલાબ પુછા કોઅતાહા, એને ચ્યે ચ્યાહાન આખ્યાં, “માયે તુમહાન આખ્યાં કા ‘વાયજ વાઆ પાછે તુમા માન નાંય એઅહા, એને વાયજ વાઆ પાછે માન પાછા એઅહા યા મોતલાબ તુમા યોકબિજાલ પૂછતાહા કા’? ");
INSERT INTO gbl_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, તુમા મા મોઅના પાછે રોડહા એને દુઃખી ઓઅહા, બાકી દુનિયા લોક આનંદ કોઅરી, તુમહાન દુઃખ ઓઅરી, બાકી જોવે તુમા માન પાછા એઅહા, તોવે તુમહે દુઃખ આનંદામાય બોદલાય જાય. ");
INSERT INTO gbl_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","જોવે થેએ પોહાલ જન્મો દેઅના સમય યેહે, તોવે તી બોજ પીડામાય રોહે, કાહાકા ચ્યે દુઃખા સમય યી ગીઅલો હેય, બાકી જોવે તી પોહાલ જન્મો દેય પાડે તો દુનિયામાય યોક માઅહું પૈદા જાયા યા ખુશીકોય તી ચ્યે પીડા વિહીરાય જાહે. ");
INSERT INTO gbl_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","યેજપરમાણે તુમાબી આમી દુઃખામાય હેય, બાકી આંય તુમહાન પાછો મીળહી એને તુમા આનંદિત ઓઈ જાહા એને તુમહે આનંદ કાદો તુમહે વોયને પેચકી નાંય લી. ");
INSERT INTO gbl_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","ચ્યે સમય તુમા માન કાય નાંય પુછહા, આંય તુમહાન હાચ્ચાં-હાચ્ચાં આખતાહાવ, જો તુમા આબહાવોય જીં કાય માગહા, તુમા મા શિષ્ય હેય, યાહાટી તો તુમહાન દી. ");
INSERT INTO gbl_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","આમી લોગુ તુમહાય મા શિષ્ય ઓઅવાથી આબહાવોય કાયજ નાંય માગ્યાં, માગા એને તુમહાન મિળી જાય, કા તુમહે આનંદ વોદતો જાય. ");
INSERT INTO gbl_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","માયે યો વાતો તુમહાન દાખલા કોઇન આખલ્યો હેય, બાકી તો સમય યી રિઅલો હેય, તોવે આંય તુમહાન દાખલા કોઇન નાંય આખું બાકી ખુલ્લી રીતે આબહા બારામાય આખી દિહી. ");
INSERT INTO gbl_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ચ્યે સમયે તુમા મા શિષ્ય હેય યાહાટી માગહા એને આંય તુમહેહાટી આબાલ પ્રાર્થના કોઅયીહી, આંય એહેકેન નાંય આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","કાહાકા આબો પોતે તુમહાવોય પ્રેમ કોઅહે, કાહાકા તુમહાય માયેવોય પ્રેમ કોઅયાહાં, એને તુમા બોરહો કોઅતાહા કા આંય આબાઇહીને યેનહો. ");
INSERT INTO gbl_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","આંય આબાઇહીને દુનિયામાય યેનહો, પાછો દુનિયાલ છોડીન આબાપાય જાય રિયહો.” ");
INSERT INTO gbl_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ચ્યા શિષ્યહાય આખ્યાં, “એએ, આમીતે તું ખુલ્લાં આખતોહો એને દાખલો નાંય આખે. ");
INSERT INTO gbl_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","આમી આમહાન ખોબાર પોડી ગિઇ, કા તું બોદા જાંઅતોહો, એને તુલ કાદા ગોરાજુજ નાંય કા કાદાં તુલ સાવાલ પુછે, યાકોય આમા બોરહો કોઅજેહે કા તું પોરમેહેરા ઇહિને યેનહો.” ");
INSERT INTO gbl_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ઈ વોનાયને ઈસુવે આખ્યાં, “આમી તુમહે બોરહો ઓઅહે. ");
INSERT INTO gbl_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","એઆ, આમી તો સમય યી રિયહો, બાકી યેય ગીયો, ચ્યે સમયે તુમા વેરગાઈ જાહા જ્યાહા-ચ્યાહા વાટે લાગહા, એને માન યોખલો છોડી દાહા, તેરુંબી આંય યોખલો નાંય હેતાઉ, કાહાકા આબહો મા આરે હેય. ");
INSERT INTO gbl_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","માયે તુમહાન યો વાતો યાહાટી આખ્યાં, યાહાટી કા તુમહાન મા લીદે શાંતી મીળે, દુનિયામાય તુમહાન આબદા પોડી, બાકી ઈંમાત રાખા, માયે યા દુનિયા શાસક એટલે સૈતાનાલ આરવી દેનલો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ઈસુવે ઈ આખ્યાં પાછે આકાશા એછે એઇન આખ્યાં, “ઓ આબા, તો સમય યેય ગીયહો, કા તું પોહા મહિમા કોઓ, કા પોહોબી તો મહિમા કોએ. ");
INSERT INTO gbl_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","કાહાકા તુયે ચ્યાલ બોદા માઅહાવોય પુરો ઓદિકાર દેનહો, તોવે તો જ્યાહાલ તુયે ચ્યાલ દેનહા, ચ્યા બોદહાન તો અનંતજીવન દેય. ");
INSERT INTO gbl_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","એને અનંતજીવન ઈ હેય, કા ચ્યા તુલ યોકુજ હાચ્ચો પોરમેહેરાલ, એને ઈસુ ખ્રિસ્તાલ જ્યાલ તુયે દોવાડયોહો, જાંએ. ");
INSERT INTO gbl_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","જીં કામ તુયે માન કોઅરાહાટી દેનેલ, તી માયે પુરાં કોઇન દોરતીવોય તો મહિમા કોઅલી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","એને આમી, ઓ મા આબા, તોઆરે મા મહિમા કોઓ, તીજ મહિમા જીં મા તો હાતે દુનિયા બોનાવના પેલ્લી આતી.” ");
INSERT INTO gbl_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","“માયે તો બારામાય ચ્યા લોકહાન આખ્યાં, જ્યાહાન તુયે દુનિયામાઅને માન દેનહા, કા તું કું હેય, ચ્યે તો આતેં એને તુયે ચ્ચાહાન માન દેને, એને ચ્યાહાય તો આગના પાળી. ");
INSERT INTO gbl_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","આમી ચ્યા જાંઅતાહા, કા તુયે માન જીં કાય દેના, તી બોદા તોપાઅને હેય. ");
INSERT INTO gbl_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","કાહાકા જો સંદેશ તુયે માન દેનો, માયે ચ્ચાહાન પોઅચાડી દેનો એને ચ્યા સંદેશાલ ચ્યાહાય બોરહો કોઅયો, એને હાચ્ચાં જાંઅતાહા કા આંય તોપાઅને યેનહો, એને ચ્યાહાય ઓ બોરહો કોઅયો કા તુયેજ માન દોવાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","ચ્યાહાહાટી આંય પ્રાર્થના કોઅતાહાંવ, દુનિયા લોકહાહાટી પ્રાર્થના નાંય કોઉ, બાકી ચ્યાહાહાટી જ્યાહાન તુયે માન દેનહે, કાહાકા ચ્યે તો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","મા જીં કાય હેય, તી બોદા તો હેય, એને જીં તો હેય, તી મા હેય, એને ચ્યાહાકોય મા મહિમા પ્રગટ જાયલી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","આમી આંય દુનિયામાય નાંય રોઉં, બાકી મા શિષ્ય દુનિયામાય હેય, એને આંય તોપાય યેય રિયહો, ઓ પવિત્ર આબા, તો સામર્થ્યા નાવાકોય ચ્યાહાન હાચવી રાખ, યાહાટી કા ચ્યે આપહે રોકે યોક રોય. ");
INSERT INTO gbl_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","જોવે આંય ચ્ચાહા આરે આતો, તો માયે તો સામર્થ્યા નાવાકોય, જીં નાંવ તુયે માન દેનલા હેય, ચ્યાહાન હાચવી રાખ્યાં, એને માયે ચ્ચાહાન હાચવ્યા એને જ્યા ટાકાય જાયના નક્કી આતા, ચ્ચાલ છોડીન ચ્યામાઅને કાદોજ નાંય ખોવાયો, તોવે પવિત્રશાસ્ત્રામાય જીં લોખલાં આતા તી પુરાં ઓએ. ");
INSERT INTO gbl_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","બાકી આમી આંય તોપાય યેય રિયહો, એને યો વાતો આંય દુનિયામાય રોયન આખતાહાવ, કા ચ્ચા મા આનંદાકોય પુરીરીતે બોઆય જાય. ");
INSERT INTO gbl_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","માયે તો સંદેશ ચ્ચાહા લોગુ પોઅચાડી દેનહો, એને દુનિયા લોકહાય ચ્યાલ આડાઇ કોઅઇ, કાહાકા જેહેકોય આંય દુનિયા નાંય, તેહેકેન ચ્ચે બી દુનિયા નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","આંય ઈ પ્રાર્થના નાંય કોઅઉ, કા તું ચ્યાહાન દુનિયામાઅને લીલે, બાકી ઈ કા તું ચ્ચાહાન ચ્યા દુષ્ટ એટલે સૈતાન પાઅને બોચાવી રાખ. ");
INSERT INTO gbl_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","જેહેકોય આંય દુનિયા નાંય, તેહેકેન ચ્ચે બી દુનિયા નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","તો વચન હાચ્ચાં હેય, યાહાટી તું ચ્યાહાન હાચ્ચાયેકોય પવિત્ર કોઓ. ");
INSERT INTO gbl_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","જેહેકેન તુયે માન દુનિયામાય દોવાડયો, તેહેકેન માયે બી ચ્યાહાન દુનિયામાય દોવાડયાહા. ");
INSERT INTO gbl_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ચ્યાહા ફાયદાહાટી આંય પોતાલ પવિત્ર કોઅતાહાંવ કા ચ્યાબી હાચ્ચાયેકોય પવિત્ર ઓઈ જાય. ");
INSERT INTO gbl_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","આંય કેવળ યા શિષ્યહા હાટી પ્રાર્થના નાંય કોઉ, બાકી ચ્યાહાહાટી બી જ્યેં યા શિષ્યહા સંદેશ વોનાયને માયેવોય બોરહો કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","કા ચ્યે બોદે યોક ઓએ, ઓ આબા, જેહેકેન તું માંયેમાય હેય, એને આંય તોમાય હેતાંવ, તેહેકેન ચ્યે બી આપહામાય રોય, યાહાટી કા દુનિયા લોક બોરહો કોએ, કા તુયેજ માન દોવાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","એને તી મહિમા જીં તુયે માન દેનલી હેય, તી માયે ચ્યાહાન દેનહી, યાહાટી કા ચ્યા તેહેકેન યોક ઓઈ જાય, જેહેકેન આપા હેજે. ");
INSERT INTO gbl_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","આંય ચ્યાહામાય એને તું માંયેમાય, યાહાટી કા ચ્યા પુરેરીતે કોઇન યોક ઓઈ જાય એને દુનિયા લોકહાન ખોબાર પોડે કા તુયે માન દોવાડયો, એને જેહેકેન તુયે માયેવોય પ્રેમ કોઅયા, તેહેકેન ચ્યાહાવોય પ્રેમ કોઅલા હેય. ");
INSERT INTO gbl_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","ઓ આબા, મા ઇચ્છા હેય કા જ્યાહાન તુયે માન દેનહા, જાં આંય રોઉં, તાં ચ્યાબી મા આરે રોય, કા ચ્યા મા તી મહિમા એએ જીં તુયે માન દેનહી, કાહાકા દુનિયા બોનાવા પેલ્લા તુયે માયેવોય પ્રેમ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ઓ ધાર્મિક આબા, દુનિયા લોકહાય તુલ નાંય જાંઆયો, બાકી માયે તુલ જાંઆયો, એને મા શિષ્યહાય બી જાંઆયો કા તુયેજ માન દોવાડયોહો. ");
INSERT INTO gbl_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","એને માયે ચ્યાહાન તો બારામાય આખ્યાં એને આજુ આખતો રોહીં, યાંહાટી કા જીં પ્રેમ તુયે માયેવોય કોઅયા તી પ્રેમ ચ્યાહામાય રોય, એને આંય ચ્યાહામાય રોઉં.” ");
INSERT INTO gbl_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","જોવે ઈસુ પ્રાર્થના કોઇ પાડી, તોવે ચ્યા શિષ્યહાઆરે કેદરોન નાંવા વોઅળા ચ્યેમેરે ગીયો, તાં યોક વાડી આતી, ચ્યે વાડયેમાય ઈસુ એને ચ્યા શિષ્ય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","એને ઈસુલ દોગો દેનારો યહૂદા બી તો જાગો જાંઅતો આતો, કાહાકા ઈસુ એને ચ્યા શિષ્ય તાં જાયા કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","તોવે યહૂદા સિપાડાહા ટોળી એને મુખ્ય યાજક એને પોરૂષીયાહા પાઅને સિપાડાહાન લેયને, દિવા, ચુડા એને આથીયાર લેઈને, તાં યેનો. ");
INSERT INTO gbl_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","તોવે ઈસુ ચ્યે બોદે વાતહેબારામાય જ્યો ચ્યાઆરે ઓઅનાર્યો આત્યો, તી બોદા જાંઆઈન, આગલા યેનો એને ચ્યાહાન પુછ્યાં, “તુમા કાલ હોદી રીઅલા હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ચ્યાહાય ચ્યાલ આખ્યાં, “નાજરેત ગાવામાઅને ઈસુલ” ઈસુવે ચ્યાહાન આખ્યાં, “આંય હેતાઉ.” એને ચ્યાલ દોગો દેનારો યહૂદા ચ્યાહાઆરે ઉબો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","જોવે ઈસુવે આખ્યાં, “આંય હેતાઉ” તોવે ચ્યા બોદા પાહલા હોરક્યા જમીનીવોય પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","તોવે ઈસુવે પાછા ઈ પુછ્યાં, “તુમા કાલ હોદી રીઅલા હેય?” ચ્યાહાય આખ્યાં, “નાજરેત ગાવામાઅને ઈસુલ.” ");
INSERT INTO gbl_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ઈસુવે આખ્યાં, “આંય તે તુમહાન આખી ચુક્યો કા આંય હેતાંવ, જોવે તુમા માન હોદી રીઅલા હેય, તોવે યા લોકહાન જાં દિયા.” ");
INSERT INTO gbl_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","એહેકેન યાહાટી જાયા, કા ઈસુવે જીં પેલ્લા આખલા આતા તી હાચ્ચાં ઓએ, “જ્યાહાન તુયે માન દેના, ચ્યાહામાઅને કાદા યોકાલબી નાંય ટાક્યો.” ");
INSERT INTO gbl_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","તોવે સિમોન પિત્તરે તારવાયે કોઇન મહાયાજકા ચાકારાલ ઠોક્યો એને ચ્યા જમણો કાન કાપી ટાક્યો, ચ્યા ચાકારા નાંવ માલખુસ આતા. ");
INSERT INTO gbl_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","તોવે ઈસુવે પિત્તરાલ આખ્યાં, “તો તારવાય દુઉ કોઓ, જીં દુઃખ બોગવાં પોરમેહેર આબહે માન દોવાડયો કાય આંય તી નાંય બોગવું?” ");
INSERT INTO gbl_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","તોવે સીપાડા એને જોમાદાર એને યહૂદી આગેવાનહા દેવાળા રાખવાળ્યાહાય ઈસુવાલ દોઇન બાંદ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","એને પેલ્લા હન્ના પાય લેય ગીયા, કાહાકા તો ચ્યા વોરહા મહાયાજક આતો, કાયફા મહાયાજકા હાઅરોહો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ઓ તોજ કાયફા આતો, જ્યેય યહૂદી આગેવાનહાન સલહો દેનેલ કા આમહે લોકહાહાટી યોક માટડા મોઅઇ જાયના હારાં હેય. ");
INSERT INTO gbl_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","સિમોન પિત્તર એને યોક બિજો શિષ્યબી, ઈસુવા પાહલા ગીયા, ઓ બિજો શિષ્ય મહાયાજકા વોળખાત્યો આતો, એને તો ઈસુવાઆરે મહાયાજકા ગોઆ બાઆપુર ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","બાકી પિત્તર બાઆ બાઅણા ઈહીં ઉબો રોય ગીયો, તોવે તો બિજો શિષ્ય જો મહાયાજકા વોળખાત્યો આતો, બાઆ જાયને, બાઆઉ ઉપે રાખવાળીલ આખીન, પિત્તરાલ માજે લેય યેનો. ");
INSERT INTO gbl_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","તોવે ચ્યે ચાકરાણ્યે જીં ફાટકા રાખવાળી આતી, પિત્તરાલ આખ્યાં, “કાય તું યા માઅહા શિષ્યહા માઅનો હેતો?” પિત્તરે આખ્યાં, “આંય નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ચાકાર એને રાખવાળ્યા હિયાળા લીદે કોળસે બાળીન ઉબા રોયન તાપાયા કોએત; એને પિત્તર બી ચ્યાહાઆરે ઉબો રોયન તાપાયા કોએ. ");
INSERT INTO gbl_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","તોવે મહાયાજકાય ઈસુવાલ ચ્યા હિકાડના એને ચ્યા શિષ્યહા બારામાય પુછ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ઈસુવે ચ્યાલ જાવાબ દેનો: “માયે બોદહાન જાહેરમાય આખ્યાં, માયે સોબાયે ઠિકાણામાય એને દેવાળામાય જાં બોદા યહૂદી બેગે ઓઅતેહે, માયે કાયામ હિકાડયાં એને ગુપ્તમાય કાય નાંય આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","તું ઓ સાવાલ માન કાહા પૂછતોહો? માન જ્યા વોનાયા ચ્યાહાન પુછ, કા માયે કાય હિકાડયાં, એએ ચ્યે જાંઅતેહે, કા માયે કાય-કાય આખ્યાં.” ");
INSERT INTO gbl_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","જોવે ઈસુય એહેકેન આખ્યાં, તોવે ચ્યા પાહાય ઉબા રીઅલા માઅને યોક રાખવાળ્યાય ઈસુવાલ યોક થાપાડ ઠોકી એને આખ્યાં, “તું મહાયાજકાલ એહેકેન જવાબ દેતહો કા?” ");
INSERT INTO gbl_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ઈસુવે ચ્યાલ આખ્યાં, “માયે કાય જુઠા આખ્યાં ઓરી તોવે તી જુઠા માન દેખાડ, બાકી જો હાચ્ચાં આખ્યાં, તોવે તું માન કાહા ઠોકતોહો?” ");
INSERT INTO gbl_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","પાછે હન્નાયેં ઈસુવાલ બાંદલોજ કાયફા મહાયાજકાપાય દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","તોવે સિમોન પિત્તર આગડા પાય ઉબો રોયન તાપાય રિઅલો આતો, તોવે ચ્યાહાય ચ્યાલ આખ્યાં, “કાય તુંબી ચ્યા શિષ્યહામાયનો હેતો કા?” પિત્તરે નાકાર કોઇ દેના, એને આખ્યાં, “આંય નાંય હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","મહાયાજકા ચાકારા માઅને યોક જો ચ્યા હોગવાડ્યો આતો, જ્યા પિત્તરે કાન તોડી ટાકલો, ચ્યે આખ્યાં, “કાય માયે તુલ ઈસુઆરે વાડીમાય નાંય દેખ્યેલ?” ");
INSERT INTO gbl_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","પિત્તરે પાછા નાકાર કોઅય દેના એને તારાત કુકાડ વાહાયો. ");
INSERT INTO gbl_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","એને ચ્યા ઈસુવાલ કાયફા મહાયાજકા ઇહિને પિલાત રાજા મેહેલામાય લેય ગીયા, એને હાકાળ્યો સમય આતો, બાકી યહૂદી આગેવાન મેહેલા માજે નાંય ગીયા કા બાટાય નાંય જાય બાકી પાસ્કા ખાઅના ખાય હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","તોવે પિલાત રાજા ચ્યાહાપાય બાઆ યેનો એને પુછ્યાં, “તુમા યા માટડાવોય કાય ફિરાદી કોઅતાહા?” ");
INSERT INTO gbl_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ચ્યાહાય આખ્યાં, “જોવે ઓ ગુનેગાર નાંય રોતો તોવે આમા યાલ તોપાય નાંય લી યેતા.” ");
INSERT INTO gbl_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","પિલાત રાજાય આખ્યાં, “તુમાંજ ચ્યાલ લેય જાયને તુમહે નિયમશાસ્ત્રા પરમાણે ચ્યા ન્યાય કોઆ” યહૂદી આગેવાનહાય આખ્યાં, “આમહાન કાદા માઅહાલ માઆઇ ટાકના ઓદિકાર નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ઈ યાહાટી જાયા, કા ઈ વાત પુરી ઓઅય, જીં ઈસુય ઈ દોર્શાવીન આખલી આતી, કા તો કેહેકેન મોઅરી. ");
INSERT INTO gbl_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","પિલાત રાજા મેહેલામાય પાછો ગીયો એને ઈસુવાલ મેહેલામાય હાદિન પૂછ્યાં: “કાય તું યહૂદી લોકહા રાજા હેતો કા? ");
INSERT INTO gbl_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ઈસુવે જવાબ દેનો, કાય તું ઈ વાત પોતાકોય આખતોહો કા બીજહાંય મા બારામાય તુલ આખ્યાં?” ");
INSERT INTO gbl_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","પિલાત રાજાય જાવાબ દેનો, “તું જાંઅતોહો કા આંય યહૂદી નાંય હેતાંવ, તોજ જાતી વાળહાય એને મુખ્ય યાજકાહાય તુલ માન હોઅપી દેનહો, તુયે કાય ગુનો કોઅયોહો?” ");
INSERT INTO gbl_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ઈસુવે જાવાબ દેનો, “મા રાજ્ય યાં દુનિયા નાંય હેય, જોવે મા રાજ્ય યા દુનિયા રોતાં, તોવે મા શિષ્ય લોડતા, કા આંય યહૂદી આગેવાનહાકોય દોઆય નાંય જાતો, બાકી આમી મા રાજ્ય ઇહિને નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","પિલાત રાજાય આખ્યાં, “તોવે તું રાજા હેતો કા?” ઈસુવે જવાબ દેનો, “આંય રાજા હેતાઉ, એહેકેન તું આખતોહો, મા જન્મો લેયના એને દુનિયામાય યેયના કારણ હેય, કા હાચ્ચાયે બારામાય હિકાડી હોકુ, જ્યેં હાચ્ચાં પાળતેહે ચ્યે મા વાત વોનાતેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","પિલાત રાજાય ઈસુલ પુછ્યાં, “હાચ્ચાં કાય હેય?” એહેકેન આખીન તો પાછો બાઆ યહૂદી આગેવાનહાપાય ગીયો, એને ચ્યાહાન આખ્યાં, “મા તે યામાય કાયબી દોષ નાંય મીળે. ");
INSERT INTO gbl_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","આમી તુમહે રીવાજ હેય કા આંય પાસ્કા સણા દિહે આંય તુમહેહાટી યોક માઅહાલ છોડી દાવ તોવે તુમહે ઇચ્છા કાય હેય, કા આંય તુમહેહાટી યહૂદીયા રાજાલ છોડી દાવ?” ");
INSERT INTO gbl_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","તોવે ચ્યાહાય પાછા બોંબલીન આખ્યાં, “યાલ નાંય, બાકી આમહેહાટી બારાબ્બાસાલ છોડી દે” બારાબ્બાસ યોક ડાકુ આતો. ");
INSERT INTO gbl_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","તોવે પિલાત રાજાય સીપાડાહાલ હુકુમ કોઅયો, કા ઈસુવાલ લેય જાય એને ચ્યાલ ચાપકા માર ઠોકે. ");
INSERT INTO gbl_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","એને સીપાડાહાય કાટાહા ટોપી વીંઈન ચ્યા ટોલપ્યે થોવી, એને ચ્યાલ જાંબળ્યા ડોગલાં પોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","એને ચ્યા ઈહીં યેયન આખતા લાગ્યા; “ઓ યહૂદીયાહા રાજા, સલામ” એને ચ્યાલ થાપાડ ઠોક્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","તોવે પિલાત રાજાય પાછો બાઆ નિંગીન લોકહાન આખ્યાં, “એઆ, આંય ચ્યાલ તુમહેપાય પાછો બાઆ લી યેતહાવ, કા તુમા જાઈ લેય કા માન કાયબી દોષ ચ્યામાય નાંય દેખાય.” ");
INSERT INTO gbl_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","તોવે ઈસુલ કાટહા ટોપી એને જાંબળ્યા ફાડકે પોવાડલે બાઆ લી યેના એને પિલાત રાજાય આખ્યાં, “યા માટડાલ એઆ.” ");
INSERT INTO gbl_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","મુખ્ય યાજક એને દેવાળા રાખવાળ્યાહાય ચ્યાલ દેખ્યો, તોવે બોંબલીન આખતા લાગ્યા. “ચ્યાલ હુળીખાંબાવોય ચોડવા, હુળીખાંબાવોય,” પિલાત રાજાય આખ્યાં, તુમાંજ ચ્યાલ લી જાયને હુળીખાંબાવોય ચોડવા, કાહાકા માન ચ્યામાય કાયજ દોષ નાંય દેખાય. ");
INSERT INTO gbl_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","યહૂદી આગેવાનહાય પિલાત રાજાલ જવાબ દેનો, “આમહે બી યોક નિયમ હેય, એને ચ્યા નિયમશાસ્ત્રા નુસાર તો માઆઇ ટાકના લાયકે હેય, કાહાકા ચ્યાય પોતાલ પોરમેહેરા પોહો આખ્યાં.” ");
INSERT INTO gbl_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","જોવે પિલાત રાજા ઈ વાત વોનાયો તો બોજ ગાબરાઈ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","એને પાછો મેહેલામાય ગીયો એને ઈસુવાલ પુછ્યાં “તું કેછને હેતો?” બાકી ઈસુય કાયજ જવાબ નાંય દેનો. ");
INSERT INTO gbl_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","તોવે પિલાત રાજાય આખ્યાં; “માન કાહા નાંય આખા? કાય તુલ નાંય ખોબાર, કા તુલ છોડી દેઅના ઓદિકાર માન હેય, એને હુળીખાંબાવોય ચોડાવના બી ઓદિકાર માન હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ઈસુવે જવાબ દેનો, “જો તુલ પોરમેહેરાપાઅને નાંય દેનલો જાતો, તે તો માયે ઉપે તુલ કાયબી ઓદિકાર નાંય રોતો, યાહાટી જ્યેં માન તો આથામાય દોઅવાડી દેનહો, ચ્યા પાપ વોદારી હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ચ્યાહાટી પિલાત રાજા ચ્યાલ છોડી દાં કોએ, બાકી યહૂદી લોકહાય બોંબલી બોંબલીન આખ્યાં, “જોવે તું ચ્યાલ છોડી દેહે તો તું કૈસર રાજા દોસ્તાર નાંય હેય, કાહાકા જીં માઅહું પોતાલ રાજા આખહે તો કૈસરા રાજા વિરુદ કોઅહે.” ");
INSERT INTO gbl_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ઈ વોનાઈન પિલાત ઈસુવાલ બાઆ લેય યેનો, એને ન્યાય આસન વોય બોહી ગીયો, જો દોગડા ચબુતરા નાંવા જાગાવોય આતો, જો હિબ્રુ ભાષામાય ગાબ્બાથા આખાયેહે. ");
INSERT INTO gbl_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","તોદિહી પાસ્કા સણા આગલો દિહી આતો લગભગ બોપાર જાઅલો આતો પિલાતેં યહૂદી લોકહાન આખ્યાં, “એઆ, ઓ હેય, તુમહે રાજા.” ");
INSERT INTO gbl_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","બાકી ચ્યા બોંબલા લાગ્યા, “ચ્યાલ માઆઇ ટાકાં, માઆઇ ટાકાં, ચ્ચાલ હુળીખાંબાવોય ચોડવા” પિલાત રાજાય આખ્યાં, “કાય આંય તુમહે રાજાલ હુળીખાંબાવોય ચોડવી દાંઉ?” મુખ્ય યાજકાંય જવાબ દેનો, “કૈસર રાજા સિવાય આમે બિજો રાજા કાદો નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","તોવે પિલાત રાજાય ઈસુલ હુળીખાંબાવોય ચોડવી દાંહાટી ચ્યાહાન હોઅપી દેનો. ");
INSERT INTO gbl_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","તોવે સીપાડાહાય ઈસુવાલ તાબામાંય લેદો એને ચ્યાહાય ચ્યાલ હુળીખાંબ પોતે ઉસલાડ્યો એને યેરૂસાલેમ શેહેરા બાઆ “ખોપરીયે જાગો” આખે તાં લેય ગીયા, જ્યાલ હિબ્રુ ભાષામાય ગુલગથા આખતેહે. ");
INSERT INTO gbl_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","તાં ચ્યાહાય ચ્યાલ એને ચ્યાઆરે બિજા બેન માઅહાન હુળીખાંબાવોય ચોડવી દેના, યેકાન્યે યોક એને ચ્યેકાન્યે યોક, એને વોચ્ચે ઈસુલ. ");
INSERT INTO gbl_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","એને પિલાત રાજાય ઈસુ ટોલપી ઉચે હુળીખાંબાવોય યોક દોષા પત્ર લાવી દેની, ચ્યામાય એહેકોય લોખલાં આતા, “નાજરેત ગાવામાઅને ઈસુ યહૂદીયાહા રાજા.” ");
INSERT INTO gbl_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","દોષા પત્ર બોજ યહૂદીયાહાય વાચી કાહાકા તો જાગો જાં ઈસુવાલ હુળીખાંબાવોય ચોડવ્યેલ તો યેરૂસાલેમ શેહેરા પાહીજ આતો, એને પત્ર હિબ્રુમાય એને લતીની એને યુનાની ભાષામાય લોખલાં આતા. ");
INSERT INTO gbl_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","તોવે યહૂદીયાહા મુખ્ય યાજકાહાય પિલાત રાજાલ આખ્યાં, “યહૂદીયાહા રાજા, એહેકોય મા લોખહે બાકી ચ્યાય પોતાલ યહૂદીયાહા રાજા આખ્યાં, એહેકોય લોખજે.” ");
INSERT INTO gbl_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","પિલાત રાજાય આખ્યાં, “માયે જીં લોખ્યાં તી નાંય બોદલાય.” ");
INSERT INTO gbl_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","જોવે સીપાડા ઈસુવાલ હુળીખાંબાવોય ચોડવી ચુક્યા, તો ચ્યા ડોગલેં લેઈને ચાર ભાગ કોઅયા, ચારી સીપાડાહાય યોકયોક ભાગ વાટી લેદો, એને ઝોબો બી લેદો, બાકી ઝોબો હિલાઈ વોગાર ઉચરે નિચે લોગુ વિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","યાહાટી સીપાડાહાય યોકાબીજાલ આખ્યાં, “આપા યાલ ચીઈતા, બાકી કા ઓરી તી ચિઠ્ઠી ટાકીન નોક્કી કોઅતા” એહેકેન યાહાટી જાયા કા પવિત્રશાસ્ત્રમાય લોખલાં હેય તી પુરાં ઓએ, “ચ્યાહાય મા ડોગલેં વાટી લેદે એને મા ઝોબા હાટી ચિઠ્ઠી ટાકી.” ");
INSERT INTO gbl_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","તોવે સીપાડાહાય એહેકેનુજ કોઅયા, બાકી ઈસુવા હુળીખાંબા પાય ચ્યા આયહો એને ચ્યા આયહે બોઅહી મરિયમ જીં કલોપાસા થેઅઈ આતી, એને મરિયમ જીં મગદલેના શેહેરા આતી, ચ્યો ઉબલ્યો આત્યો. ");
INSERT INTO gbl_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ઈસુવે ચ્યા આયહેલ, એને ચ્યા શિષ્યાલ જ્યાલ તો પ્રેમ કોઅતો આતો પાહી ઉબલે દેખીન, ઈસુવે ચ્યા આયહેલ આખ્યાં; “આયા, એએ, ઓજ તો પોહો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","તોવે ચ્યા શિષ્યાલ આખ્યાં “એએ, ઈ તો આયોહો હેય” એને ચ્યેજ સમયથી તો શિષ્ય, મરિયમેલ ચ્યા કુટુંબમાય લેય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ચ્યા પાછે ઈસુય એહેકોય જાંઆઈન કા ચ્યાય ચ્યા બોદા કામ પુરાં કોઇ દેનલા હેય, યાહાટી કા પવિત્રશાસ્ત્રામાય લોખલાં તી હાચ્ચાં સાબિત ઓએ, ઈસુવે આખ્યાં; “માન પીહી લાગહી.” ");
INSERT INTO gbl_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","તાં યોક ખાટાકોય બોઅલાં વાહાણા થોવલાં આતા, યાહાટી કાદે તેરી દાંહાદી જાયને, દારાખા ખાટામાય બુડાવાલા અજોબ જાડા હોટી વોય થોવિન ઈસુવા મુંયાલ લાવ્યાં. ");
INSERT INTO gbl_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","જોવે ઈસુય ખાટા ચાખ્યાં, તોવે આખ્યાં, કા “પુરાં ઓઈ ગીયા” એને ટોલપી નોમાવીન મોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","આમી ઓ તિયારી દિહી આતો, એને આગલો દિહી આરામા દિહી એને પાસ્કા સણા દિહી બી આતો, ઓ યહૂદી લોકહાહાટી યોક ખાસ દિહી આતો, એને ચ્યાહા મોરજી નાંય આતી કા ચ્યે દિહે ચ્યા તીન્યાહા કુડયો હુળીખાંબાવોય રોય, યાહાટી યહૂદીયાહાય પિલાત રાજાલ આખ્યાં, કા ચ્યા પાગ મૂડી દેનલા જાય, યાહાટી કા તો જલદી મોઅઇ જાય, એને કુડયો નિચે ઉતાડી હોકે. ");
INSERT INTO gbl_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","યાહાટી સીપાડાહાય યેયન ઈસુવાઆરે જ્યા હુળીખાંબાવોય ચોડાવલા આતા ચ્યાહા પાગ મૂડી ટાક્યા, પેલ્લા યોકા એને પાછે બિજા બી મુડયા. ");
INSERT INTO gbl_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","બાકી જોવે ચ્યા ઈસુવાપાય યેના, તોવે ચ્યાલ મોઅલો દેખ્યો, યાહાટી ચ્યા પાગ નાંય મુડયા. ");
INSERT INTO gbl_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","બાકી યોક સિપાડાય ચ્યા પાહાળામાય ભાલો ડોચી દેનો, એને તારાત ચ્ચામાઅને લોય એને પાઆય નિંગી યેના. ");
INSERT INTO gbl_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","જ્યા માટડાય ઈ બોદા દેખ્યા, ચ્યાય સાક્ષી દેનહી, કા તુમાબી ઈસુવોય બોરહો કોએ. એને ચ્યા સાક્ષી હાચ્ચી હેય, એને તો જાંઅહે કા તો હાચ્ચાં બોલહે. ");
INSERT INTO gbl_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","યો વાતો યાહાટી જાયા કા પવિત્રશાસ્ત્રમાય લોખલાં હેય તી હાચ્ચાં ઓએ, કા “ચ્યા યોકબી આડકાં મૂડી નાંય ટાકી.” ");
INSERT INTO gbl_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","એને પાછી પવિત્રશાસ્ત્રમાય લોખલાં હેય, કા “જ્યાલ ચ્યાહાય ભાલો ડોચી દેનો, ચ્યાલ ચ્યે એઅરી.” ");
INSERT INTO gbl_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","યે વાતહે પાછે અરીમતિયા ગાવા યોસેફ, જો ઈસુવા શિષ્ય આતો, બાકી યહૂદી આગેવાનહા દાકે યે વાતેલ ગુપ્તમાય રાખતો આતો, ચ્યાય પિલાત રાજાપાય ઈસુવા કુડી લેય જાઅના માગણી કોઅયી, કા આંય ઈસુવા કુડી લેય જાવ, પિલાત રાજાય ચ્યા વિનાંતી વોનાયને કુડી લેય જાં પરવાનગી દેની, એને યુસુફ યેયન ઈસુ કુડી લેય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","નિકોદેમુસ બી, જો પેલ્લા ઈસુવાપાય રાતી ગીઅલો આતો, એલવા બેખાળલો લગભગ તેત્રીસ કિલો ગંધરસ લેય યેનો. ");
INSERT INTO gbl_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","તોવે ચ્યાહાય ઈસુ કુડી લેદી એને યહૂદી લોકહા ડાટના રીવાજ પરમાણે સુગન્દિત દ્રવ્ય ચોપડયા એને ફાડકામાય ચોંડાળ્યા. ");
INSERT INTO gbl_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","આમી ઈસુવાલ જાં હુળીખાંબાવોય ચોડાવલો આતો, તાં પાહીજ યોક વાડી આતી, એને તી વાડીમાય યોક નોવી કોબાર આતી, ચ્યેમાય પેલ્લા કાદાલ નાંય થોવ્યેલ. ");
INSERT INTO gbl_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","યાહાટી ચ્યાહાય ઈસુવા કુડી ચ્યેજ કોબારેમાય થોવી દેના, કાહાકા તી પાહાય આતી, એને તો યહૂદીયાહા આરામા તિયારી દિહી બી આતો. ");
INSERT INTO gbl_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","રવિવારે બોજ કોવાળ્યાં આજુ આંદારાં આતા તોવે મરિયમ જીં મગદલા નાંવા શેહેરામાઅને આતી, કોબારે એછે ગીયી, તોવે દેખ્યાકા કોબારે મુયાઇહીને દોગાડ પેલ્લોજ હોરકાવલો હેય. ");
INSERT INTO gbl_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","તોવે તી સિમોન પિત્તર, એને એલો બિજો શિષ્ય જ્યાલ ઈસુ પ્રેમ કોઅહે ચ્યાહાપાય દાંહાદી ગીયી, એને ચ્યાહાન ચ્યે આખ્યાં, “કોબારેમાઅને પ્રભુ કુડીલ કાડી લેય ગીયે, એને આમા નાંય જાંઆજે કા કેછ થોવ્યોહો.” ");
INSERT INTO gbl_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","તોવે પિત્તર એને બિજો શિષ્ય કોબારે એછે ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","એને બેની શિષ્ય આરે-આરે દાંહા દેત, બાકી પિત્તરા કોઅતો તો બિજો શિષ્ય આગલા નિંગી ગીયો, એને કોબારેપાય પેલ્લો જાય પોઅચ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","એને ડોંગો વોળીન ફાડકે બુઇ પોડલેં દેખ્યે, તે તો બિઇ ગીયો યાહાટી તો માજા નાંય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","સિમોન પિત્તર ચ્યા પાહલા યેનો એને પાદરોજ કોબારેમાય ગીયો એને ચ્યે તાં ફાડકે પોડલેં દેખ્યે. ");
INSERT INTO gbl_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","એને ઈસુવા ટોલપ્યેલ વેટાળલો રુંબાળ બી દેખ્યો, બિજા ફાડકાહા આરે નાંય, બાકી આલાગુજ જાગાવોય ગોડી વાળલો દેખ્યો. ");
INSERT INTO gbl_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","પાછે બિજો શિષ્ય જો કોબારેપાય પેલ્લો જાઈ પોઅચ્યેલ તોબી માજે ગીયો એને ઈ એઇન કા ઈસુ મોઅલાહામાઅને જીવતો ઓઈ ગીયહો બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","પવિત્રશાસ્ત્રમાય ઈસુ બારામાય ઈ લોખલાં આતા કા ઈસુ મોઅલા માઅને પાછો જીવતો ઉઠી, બાકી ચ્યાહાન આજુ લોગુ નાંય હોમજાલા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","તોવે ચ્યા શિષ્ય પાછા ચ્યાહા ગોઓ વોળી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","બાકી મરિયમ રોડતીજ કોબરે પાહી બાઆ ઉબી રોયી એને રોડતી-રોડતી કોબરે એછે ડોંગી પોડીન, ");
INSERT INTO gbl_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","બેન હોરગા દૂતહાન ઉજળેંફુલ ડોગલેં પોવલા યોક ટોલપ્યેએહે એને યોક પાગહાહે બોઠલા દેખ્યા, જાં ઈસુવા કુડી થોવલી આતી. ");
INSERT INTO gbl_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ચ્યાહાય ચ્યેલ આખ્યાં, “બાઈ તું કાહા રોડતીહી?” ચ્ચેય ચ્ચાહાન આખ્યાં, “ચ્ચે મા પ્રભુ કુડી લેય ગીયા એને આંય નાંય જાંઉ કા ચ્ચાલ કેછ થોવ્યહો.” ");
INSERT INTO gbl_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ઈ આખીન તી પાહલા ફિરી યેની એને ઈસુલ ઉબલો દેખ્યો એને નાંય વોળખ્યો કા ઓ ઈસુ હેય. ");
INSERT INTO gbl_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ઈસુવે ચ્ચેલ આખ્યાં, “ઓ બાઈ તું કાહા રોડતીહી? કાલ હોદતીહી?” ચ્ચેય વાડીવાળો હોમજીન ચ્ચાલ આખ્યાં, “ઓ સાયબ, જો તું ચ્યાલ ઇસી લેય ગીયો તોવે ચ્યાલ કેછ થોવ્યા તીં માન આખ, એને ચ્યાલ આંય લેય જાહીં.” ");
INSERT INTO gbl_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ઈસુવે ચ્યેલ આખ્યાં, “મરિયમ!” ચ્યેય પાહલા ફિરીન ચ્યાલ હિબ્રુનીમાય આખ્યાં, “રબ્બુની મતલબ ઓ ગુરુજી.” ");
INSERT INTO gbl_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ઈસુવે આખ્યાં, “તું માન દોઅહે મા? આજુ લોગુ આંય આબાઇહી ઉચે નાંય ગીયહો, બાકી તું મા શિષ્યહાપાય જાયને ખોબાર આખ, કા જો મા આબહો હેય તો તુમહે આબહો હેય, એને જો મા પોરમેહેર હેય તો તુમહે પોરમેહેર હેય, ચ્યાપાય આંય ઉચે જાતહાવ.” ");
INSERT INTO gbl_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","તોવે મરિયમ જીં મગદલેના શેહેરા આતી જાયને શિષ્યહાન આખ્યાં કા, “માયે પ્રભુલ દેખ્યો એને ચ્યે મા આરે વાતો કોઅયો.” ");
INSERT INTO gbl_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ચ્યાજ રવિવારે વોખાતે બોદા શિષ્ય બેગા જાયા, એને ચ્યાહાન યહૂદી આગેવાનહા દાક આતી, યાહાટી ચ્યાહાય બાઅણા બંદ કોઇ લેદલા આતા, તોવે ઈસુ માજે યેનો એને વોચમાય ઉબો રોયન આખ્યાં, “તુમહાન શાંતી મીળે.” ");
INSERT INTO gbl_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ઈ આખીન પાછે તો ચ્યાહાન ચ્યા આથ એને પાહાળા દેખાડયાં, એને શિષ્યહાય પ્રભુલ એઅયો એને બોજ આનંદિત ઓઅયા. ");
INSERT INTO gbl_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","તોવે ઈસુવે પાછા ચ્યાહાન આખ્યાં, “તુમહાન શાંતી મીળે. જેહેકેન આબહે માન દુનિયામાય દોવાડયો તેહેકેન આંય તુમહાન દુનિયામાય દોવાડતાહું.” ");
INSERT INTO gbl_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ઈ આખીન ચ્યાય ચ્યાહાવોય ફુક્યા એને ચ્યાહાન આખ્યાં, “પવિત્ર આત્મા લા. ");
INSERT INTO gbl_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","જ્યા કાદા પાપ તુમા માફ કોઅહા, ચ્યાહા પાપ માફ ઓઈ જાય, જ્યા કાદા પાપ તુમા નાંય માફ કોઅહા, ચ્યાહા પાપ નાંય માફ ઓઅય.” ");
INSERT INTO gbl_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","બાકી બાર શિષ્યહા માઅને યોક એટલે થોમા જ્યાલ દિદુમુસ આખાય, જોવે ઈસુ યેનો, તોવે ચ્યાહાઆરે નાંય આતો. ");
INSERT INTO gbl_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","જોવે બિજા શિષ્ય ચ્યાલ આખા લાગ્યા, “આમહાય પ્રભુવાલ દેખ્યો” તોવે ચ્ચાય ચ્યાહાન આખ્યાં, “ચ્યા આથામાય ખીલા ઠોક્યાં ચ્યા જોખમા વોણ એઉ એને ખીલહા વોણામાય મા આંગળી થોવુ એને ચ્યા પાહાળામાય મા આથ ટાકીન એઇ નાંય લાવ, તાં લોગુ આંય નાંય બોરહો કોઉ કા તો મોઅલા માઅને જીવતો ઉઠયહો.” ");
INSERT INTO gbl_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","યોક આઠવડયા પાછે ચ્યા શિષ્ય પાછા ગોઅમે આતા, એને થોમા ચ્યાહાઆરે આતો, એને બાઅણા બંદ આતા, તોવે ઈસુય યેયન એને વોચમાય ઉબા રોયન આખ્યાં, “તુમહાન શાંતી મીળે.” ");
INSERT INTO gbl_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","તોવે ચ્યાય થોમાલ આખ્યાં, “તો આંગળી ઈહીં લેય યે એને મા આથ એએ, એને તો આથ દોઓ એને મા પાહાળામાય ટાક, એને શંકા કોઅના બંદ કોઓ, બાકી બોરહો કોઓ કા આંય જીવતો હેય.” ");
INSERT INTO gbl_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","થોમાય જાવાબ દેનો, “ઓ મા પ્રભુ, ઓ મા પોરમેહેર.” ");
INSERT INTO gbl_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ઈસુવે ચ્યાલ આખ્યાં, “તુયે તે માન એઅયો તે તું બોરહો કોઅતોહો? ધન્ય હેય ચ્યે માન એઅયા વોગાર બોરહો કોઅતેહે.” ");
INSERT INTO gbl_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ઈસુવે આજુબી બો બોદે ચમત્કારા કામ શિષ્યહા દેખતા કોઅયે, જીં યે ચોપડયેમાય નાંય લોખલે હેય; ");
INSERT INTO gbl_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","બાકી યે યાહાટી લોખલે હેય, કા તુમા બોરહો કોએ, કા ઈસુજ પોરમેહેરા પોહો ખ્રિસ્ત હેય, એને ચ્યાવોય બોરહો કોઇન ચ્યા નાવાકોય અનંતજીવન મિળવા. ");
INSERT INTO gbl_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","યે વાતહે પાછે ઈસુ પોતાલ તીબીરીયાસ દોરિયા મેરે ચ્યા શિષ્યહાન દેખાયો, એને ઈ એહેકેન જાયા. ");
INSERT INTO gbl_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","સિમોન પિત્તર, થોમા જ્યાલ દિદુમુસ આખતેહે, ગાલીલ ભાગા કાના ગાવામાઅને નતનએલ, એને જબદયા બેન પાહા, એને ઈસુ બિજા બેન શિષ્ય, યોખઠા આતા. ");
INSERT INTO gbl_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","તોવે સિમોન પિત્તરે ચ્યાહાન આખ્યાં, “આંય માછલે દોઅરાં જાય રિયહો” ચ્યાહાય ચ્યાલ આખ્યાં, “આમા બી તોઆરે યાહુ” યાહાટી ચ્યા નિંગીન ઉડીમાય ચોડી ગીયા, બાકી ચ્યે રાતી ચ્યાહાય કાય નાંય દોઅયા. ");
INSERT INTO gbl_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","આગલે દિહી હાકાળેહે કોવાળ્યાં ઈસુ દોરિયા મેરે ઉબલો આતો. તેરુંબી શિષ્યહાય ચ્યાલ નાંય વોળખ્યો કા ઓ ઈસુ હેય. ");
INSERT INTO gbl_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “ઓ પાહાહાય, કાય તુમહાપાય કાય ખાઅના હેય?” ચ્યાહાય જાવાબ દેનો, “નાંય.” ");
INSERT INTO gbl_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ઈસુવે ચ્યાહાન આખ્યાં, “ઉડી જમણે એછે જાળ ટાકાં, તે તુમહાન મિળી” તોવે ચ્યાહાય જાળ ટાકી, એને આમી બો બોદા માછલાહા લીદે જાળ તાણી નાંય હોક્યા. ");
INSERT INTO gbl_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","યાહાટી ચ્યા શિષ્યાય જ્યાલ ઈસુ પ્રેમ કોએ, તો સિમોન પિત્તરાલ આખ્યાં, “ઓ તો પ્રભુ હેય” પિત્તરે ઈ વોનાઈન કા પ્રભુ હેય, ડોગલાં પોવી લેદા જ્યેં ચ્યાય માછલે દોઅતા સમયે કાડી થોવલે. એને પાઅયામાય કુદી પોડયો. ");
INSERT INTO gbl_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","બાકી બિજા શિષ્ય ઉડીવોય બોહીન માછલાહાકોય બોઆલી જાળ તાણતા યેના, કાહાકા ચ્યા મેરાવોયને બોજ દુઉ નાંય આતા, લગભગ હોવ મીટર આતા. ");
INSERT INTO gbl_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","જોવે ચ્યા મેરે યેના, તોવે ચ્યાહાય કોળસાહા આગ બોળતી એને આઅરા ઉપે માછલા થોવલાં, એને બાખે દેખ્યી. ");
INSERT INTO gbl_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","તોવે ઈસુવે ચ્યાહાન આખ્યાં, “તુમહાય જ્યેં માછલે આમી દોઅયેહે, ચ્યાહામાઅને વોછે માછલે લેતા યા.” ");
INSERT INTO gbl_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","સિમોન પિત્તરાય ઉડીવોય ચોડીન યોક હોવ ને ત્રેપન મોઠા માસલાહાકોય બોઆલી જાળ મેરાવોય તાણી. એને ઓલે બોદે માછલે આતેં તેરુંબી જાળ નાંય ફાટી. ");
INSERT INTO gbl_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ઈસુવે ચ્યાહાન આખ્યાં, “યા, ખાઅના ખાં” એને શિષ્યહા માઅને કાદાલ ઈંમાત નાંય જાયી કા, ચ્યાલ પુછે, “તું કું હેતો?” કાહાકા ચ્યાહાન ખોબાર આતી કા ઓ ઈસુજ હેય. ");
INSERT INTO gbl_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","તોવે ઈસુવે બાખે લેઈને ચ્યાહાન દેની, એને તેહેકેન માછલે બી દેને. ");
INSERT INTO gbl_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ઈ તીજેદા હેય, ઈસુવે મોઅલા માઅને ઉઠયા પાછે ચ્યા શિષ્યહાન દર્શન દેના. ");
INSERT INTO gbl_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ખાય ઉઠયા પાછે ઈસુવે સિમોન પિત્તરાલ આખ્યાં, “ઓ યોહાના પાહા સિમોન, યા બીજહા કોઅતો તું માન વોદારી પ્રેમ કોઅતોહો કા?” ચ્યે આખ્યાં, “હાં પ્રભુ, તુલ તે ખોબાર હેય, આંય તુલ પ્રેમ કોઅતાહાંવ” ઈસુવે ચ્યાલ આખ્યાં, “મા ગેટહાન ચાઆ.” ");
INSERT INTO gbl_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ઈસુવે આજુ બિજા દા ચ્યાલ આખ્યાં, “ઓ સિમોન યોહાના પોહા, કાય તું માન પ્રેમ કોઅતોહો?” પિત્તરે જવાબ દેનો, “હાં પ્રભુ તુલ ખોબાર હેય કા આંય તોવોય પ્રેમ કોઅતાહાંવ” ઈસુવે ચ્યાલ આખ્યાં, “મા ગેટહા રાખવાળી કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","તીજા દા ઈસુવે આખ્યાં, “ઓ સિમોન યોહાના પાહા, કાય તું માયેવોય પ્રેમ કોઅતોહો?” પિત્તર મોનામાય દુ:ખી જાયો, કાહાકા ઈસુ ચ્યાલ પાછા તીજા દા પુછ્યાં, કા તું માયેવોય પ્રેમ કોઅતોહો? એને ચ્યે ઈસુવાલ આખ્યાં, “ઓ પ્રભુ, તુલ તો બોદી ખોબાર હેય, આંય તુલ પ્રેમ કોઅતાહાંવ તી તુલ ખોબાર હેયેજ” ઈસુવે ચ્યાલ આખ્યાં, “મા ગેટહાન ચાઆ. ");
INSERT INTO gbl_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","આંય તુલ હાચ્ચાં-હાચ્ચાં આખતાહાવ, જોવે તું જુવાન આતો, તોવે તું કોંબાર બાંદિન, જાં મોન ગોમે તાં જાંઉ આતો, બાકી જોવે તું ડાઆયો ઓઈ જાહે તોવે તો આથ આગાડી કોઅહે એને બિજો તો કોંબાર બાંદિન તુલ નાંય ગોમે તાં લેય જાય.” ");
INSERT INTO gbl_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ઈસુય ઈ આખાહાટી આખ્યાં, કા પિત્તર કેહેકેન મોઅરી એને પોરમેહેરાલ મહિમા કોઅરી, એને એહેકોય આખીન ચ્યાલ આખ્યાં, “મા શિષ્ય બોની રો.” ");
INSERT INTO gbl_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","પિત્તર ફિરી વોળીન ચ્યા શિષ્યાલ પાહલા યેતો દેખ્યો, જ્યાલ ઈસુ પ્રેમ કોઅતો આતો, જ્યેં ખાઅના ખાતે સમયે ઈસુવા એછે ડોંગો પોડીન પુછ્યાં, “ઓ પ્રભુ, તુલ દોઆડી દેનારો કું હેય?” ");
INSERT INTO gbl_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ચ્યાલ એઇન પિત્તરે ઈસુવાલ આખ્યાં, “ઓ પ્રભુ, ચ્યા કાય ઓઅરી?” ");
INSERT INTO gbl_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ઈસુવે ચ્યાલ આખ્યાં, “જો મા ઇચ્છાકોય તો આંય પાછો યીહીં તાંવ લોગુ તો જીવતો રોય, તે તુલ કાય? તું મા શિષ્ય બોની રો.” ");
INSERT INTO gbl_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","યાહાટી વિસ્વાસ્યાહામાય ઈ વાત ફેલાઈ ગીયી, કા તો શિષ્ય નાંય મોએ, તેરુંબી ઈસુય ચ્યાલ ઈ નાંય આખ્યાં, કા ઓ નાંય મોઅરી, બાકી ઈ આખ્યાં, “જો મા ઇચ્છાકોય તો આંય પાછો યીહીં તાંવ લોગુ તો જીવતો રોય, તે તુલ કાય?” ");
INSERT INTO gbl_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ઓ તોજ શિષ્ય હેય, જો યે વાતહેબારામાય સાક્ષી દેહે, એને જ્યાંય યે વાતહેબારામાય લોખલાં હેય, એને આમહાન ખોબાર હેય કા ચ્યા સાક્ષી હાચ્ચી હેય. ");
INSERT INTO gbl_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ઈસુવે આજુબી બો બોદે ચમત્કારા કામે કોઅયે, જો તીં બોદા લોખલાં જાતા, તોવે બોદી દુનિયામાય બી ચ્યે ચોપડયેહેન સાંભાળાહાટી ઓલો જાગો નાંય રોતો જ્યેં લોખલે જાતે.");
INSERT INTO gbl_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","માનનીય થીયોફિલુસ, મા પેલ્લી ચોપડીમાય, જીં માયે તોહાટી લોખલી આતી, માયે ચ્યે કોલહ્યેક ચીજહે બારામાય લોખ્યાં જીં ઈસુય કોઅલા આતા એને હિકાડલા આતા જાંવલોગુ તો હોરગામાય લેવાય નાંય ગીઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","બાકી ઈસુલ પોરમેહેરાકોય હોરગામાય લેય લાં પેલ્લા, ચ્યાય પવિત્ર આત્મા સામર્થ્યાકોય ચ્યા પ્રેષિતાહાલ આગના દેની. ");
INSERT INTO gbl_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ઈસુય દુ:ખ ઉઠાવ્યા એને મોરણા પાછે બોજ પાક્કી સાબિતી કોઇન તો જીવતો હેય એહેકોય દેખાડયાં, એને ચાળીસ દિહયા લોગુ તો પ્રેષિતાહાલ દેખાતો રિયો, એને પોરમેહેરા રાજ્યા વાતો આખતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","યોક સમય ઈસુવા શિષ્ય ચ્યાઆરે આતા તોવે ઈસુય ચ્યાહાન આગના દેની, “યેરૂસાલેમ શેહેર છોડીન જાહા મા, બાકી તી દાન મીળે તાંવ લોગુ વાટ જોવાં જીં પોરમેહેર આબહાય તુમહાન દેઅના વાયદો કોઅલો આતો, જ્યા બારામાય તુમા માયેપાઅને વોનાય ચુક્યાહા. ");
INSERT INTO gbl_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","કાહાકા યોહાનાય તે પાઆયાકોય બાપતિસ્મા દેનલા હેય, બાકી કોલહાક દિહયા પાછે પોરમેહેર તુમહેઆરે રાંહાટી પવિત્ર આત્મા દોવાડી.” ");
INSERT INTO gbl_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","પાછે જોવે પ્રેષિત બીજેદા ઈસુલ મિળ્યાં, તોવે ચ્યાહાય ઈસુલ પુછ્યાં, “ઓ પ્રભુ, કાય ઈસરાયેલાલ છુટકા કોઅના એને આપહે રાજ્યા પાછો સ્થાપન કોઅના તો સમય યેય ગીયહો?” ");
INSERT INTO gbl_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ઈસુય ચ્યાહાન આખ્યાં, “તો સમય એને ચ્યો વાતો કોવે ઓઅરી, ચ્યા બારામાય જાઅના પોરમેહેર આબહાલ ઓદિકાર હેય, ઈ તુમહાન જાઅના ગોરાજ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","બાકી જોવે પવિત્ર આત્મા તુમહેવોય યેઅરી તોવે તુમા સામર્થ્ય મેળવહા; એને યેરૂસાલેમ શેહેરામાય એને બોદા યહૂદીયા એને સમરૂન વિસ્તારમાય, એને બોદા દુનિયામાય લોકહાન મા બારામાય સાક્ષી દાહા.” ");
INSERT INTO gbl_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ઈ આખીન ઈસુ ચ્યાહા દેખતા-દેખતાજ પોરમેહેરાય ચ્યાલ હોરગામાય લેય લેદો, એને વાદળાં લીદે ચ્યે ચ્યાલ આગાડી નાંય દેખી હોક્યે. ");
INSERT INTO gbl_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","એને ઈસુ જાતી સમયે જોવે ચ્યા આકાશા એછે એઅઇ રીઅલા આતા, તોવે અચાનક, બેન માટડા ઉજળેં ડોગલેં પોવલા ચ્યાહા પાહી યેયન ઉબા રિયા, ");
INSERT INTO gbl_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","એને ચ્યાહાન એહેકેન આખ્યાં, “ઓ ગાલીલ ભાગામાય રોનારા માઅહાય, તુમા કાહા ઉબા રોયન ઉચે આકાશા એછે એઅઇ રીયહા? ઓજ ઈસુ, જ્યાલ પોરમેહેરાય તુમહે પાહીને હોરગામાય લેય લેદલો હેય, તુમા ચ્યાલ જેહેકેન આકાશામાય જાતા દેખ્યાહા તેહેકેન તો પાછો યેઅરી.” ");
INSERT INTO gbl_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","જોવે બેન માટડા જાતા રિયા તોવે શિષ્ય જૈતુન નાંવા ડોગાવોયને જો યેરૂસાલેમ શેહેરા ઇહને યોક કિલોમીટર દુઉ હેય, યેરૂસાલેમ શેહેરામાય પાછા યેના. ");
INSERT INTO gbl_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","એને જોવે શિષ્ય યેરૂસાલેમ શેહેરામાય પોઅચ્યા તોવે ચ્યા ઉચલી ખોલીમાય ગીયા. તાં પિત્તર, યોહાન, યાકૂબ, આંદ્રિયાસ, ફિલિપ, થોમો, બરથલ્મી, માથ્થી, અલફિયા પોહો યાકૂબ, સિમોન જેલોતોસ, એને યાકૂબા પોહો યહૂદા રા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ચ્યા બોદા એને તાં ચ્યાહાઆરે કોલ્યોહોક બીજ્યોબી થેઅયો આત્યો જ્યેહેય ઈસુલ મોદાત કોઅલી આતી એને ઈસુવા આયહો મરિયમ એને ચ્યે બાહાહા આરે યોકચીત્ત ઓઇન પ્રાર્થનામાય લાગી રોત. ");
INSERT INTO gbl_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","એને ચ્યાજ દિહીહયામાય જોવે લગભગ યોક હોવને વિહી વિસ્વાસી યોખઠા આતા, તોવે પિત્તર ચ્યાહા વોચમાય ઉબો રોયન આખા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ઓ બાહાહાય, પવિત્ર આત્માય બોજ સોમાયા પેલ્લા રાજા દાઉદા કોય યહૂદા બારામાય આખ્યાં, જો ઈસુલ દોઆડનારા લોકહા આગેવાની કોઅનારો બોની ગીયો, ઈ જરુરી આતાં કા યહૂદા બારામાય પવિત્રશાસ્ત્રમાય લોખલાં હેય તી હાચ્ચાં સાબિત ઓએ. ");
INSERT INTO gbl_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","કાહાકા તો આપહે માઅને યોક આતો, એને યે સેવાયેમાય ભાગી જાયલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","19","જેહેકેન તુમા જાંઅતેહે કા, યહૂદી આગેવાનહાય યહૂદાલ પોયહા દેના જોવે ચ્યાય ચાલાકી કોઇન ઈસુલ દોગો દેયના વાયદો કોઅયો, પાછે યહૂદાય ચ્યા પોયહા ચ્યાહાન પાછા ફેરવી દેના. એને જોવે યહૂદાય ગોળ ફાંસ લાવી લેદા, એને ચ્યા શરીર દોરતીવોય ટુટી પોડ્યા, ચ્યા બુકો ફાટી ગીયો એને ચ્યા બોદે આતેં બાઆ નિંગી યેને, યાહાટી યહૂદી આગેવાનહાય ચ્યા પોયહાકોય યોક રાન વેચાતાં લેદા. યેરૂસાલેમ શેહેરામાઅને લોક યે વાતે બારામાય જાંઆય ગીયા, યાહાટી ચ્યા લોક ચ્યા જાગાલ ચ્યાહા ભાષામાય ‘હકલદમા’ એટલે ‘લોયા રાન’ એહેકેન નાંવ પાડ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","કાહાકા રાજા દાઉદા ગીતશાસ્ત્રમાય એહેકેન લોખલાં હેય, ‘ચ્યા ગુઉ ઉજાડ એઅઇ જાઅરી, એને ચ્યામાય કાદાં નાંય રોય’ એને ઈ બી લોખલાં હેય, ‘કાદો બિહરો ચ્યા પદ લી.’ ");
INSERT INTO gbl_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","22","યાહાટી ઈ જરુરી હેય કા યોક ઓહડા માઅહાન નિવાડલા જાય, જો પ્રભુ ઈસુવા કામહા બોદયે સમયે સાક્ષી હેય, એને પ્રભુ ઈસુલ યોહાનાકોય બાપતિસ્મા દેના ચ્યાપાઅને લેયને ઈસુલ પોરમેહેરાકોય હોરગામાય લેય લેઅના લોગુ ઈ માઅહું પ્રભુ ઈસુ મોઅલા માઅને પાછા જીવી ઉઠના બારામાય સાક્ષી બોને.” ");
INSERT INTO gbl_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","તોવે ચ્યાહાય બેન માઅહાલ ઉબા રાખ્યા, યોક યુસુફ જો બર-સબ્બા આખાયેહે, જ્યા ઉપનાંવ યુસ્તસ હેય, બિજો મત્તીયાહ. ");
INSERT INTO gbl_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","એને ઈ પ્રાર્થના કોઅયી, “ઓ પ્રભુ, તું જો બોદહા મોન જાંઅતોહો, આમહાન ઈ પ્રગટ કોઓ કા યા બેનહયા માઅને તુયે કાલ નિવડયોહો. ");
INSERT INTO gbl_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","કા તો ઈ સેવા એને પ્રેષિત પદ લેય, જો જાગો યહૂદા છોડી ગીયો, એને મોઅઇ ગીયો એને ચ્યા જાગાવોય જાતો રિયો જાં ચ્યાલ રા જોજતાં આતા.” ");
INSERT INTO gbl_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","તોવે ચ્યાહાય ચ્યાહા બારામાય ચીઠયો ટાક્યો, એને મત્તીયા નાંવા ચિઠ્ઠી નિંગી, તોવે તો ચ્યા ઓગ્યાર પ્રેષિતાહા આરે ગોણાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","જોવે યહૂદી લોકહા પચાસમા દિહા સણ યેનો, તોવે ચ્યા બોદા યોક જાગે યોકઠા જાયલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","એને અચાનક હોરગામાઅને મોઠા તુફાન રોકો ગોંગારના આવાજ ઓઅયો, એને ચ્યા બોઠલા આતા તી બોદા ગુઉ ચ્યા આવાજા કોય ગાજી ઉઠયા. ");
INSERT INTO gbl_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","તોવે ચ્યાહા હોમ્મે ઓહડી આગ દેખાયી, જ્યેં આકાર જીબ્યે રોકો આતો, જીં આલાગ ઓઇન ચ્યાહામાઅને બોદહાવોય થોબતી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","એને ચ્યા બોદા પવિત્ર આત્માકોય બાઆઈ ગીયા, એને જેહેકેન પવિત્ર આત્માય ચ્યાહાન બોલના તાકાત દેની, ચ્ચે રીતે જુદી-જુદી ભાષામાય બોલા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ચ્ચે સમયે, પોરમેહેરા દાક રાખનારા કોલહાક યહૂદી લોક આતા, જ્યા આકાશા નિચે દુનિયા બોદા દેશામાઅને સણ મોનાવાહાટી યેરૂસાલેમ શેહેરામાય યેનલા આતા એને યેરૂસાલેમ શેહેરામાય રોતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","જોવે ગોંગારના આવાજ ઓઅયો, તોવે ગીરદી ઓઈ ગીયી એને લોક ગાબરાય ગીયા, કાહાકા બોદા આપહે-આપહે ભાષામાય બોલતા વોનાય રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ચ્યા બોદાજ ચોમકાયન એને નોવાય પામીન આખા લાગ્યા, “એઆ, યા જીં બોલી રીઅલા હેય કાય બોદા ગાલીલ ભાગા માઅહે નાંય હેય? ");
INSERT INTO gbl_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","તે ઈ કાય ઓઈ રીયહા જીં આમહે માઅને બોદા જાંઆ આપહે-આપહે બોલી ભાષામાય વાતો કોઅતા વોનાય રીયલા હેય. ");
INSERT INTO gbl_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","આપહે માઅને કોલહાક લોક પારથી વિસ્તારામાઅને હેય એને કોલહાક લોક મેદી વિસ્તારામાઅને એને કોલહાક લોક એલામી વિસ્તારામાઅને એને કોલહાક લોક મેસોપોટેમિયા વિસ્તારામાઅને એને કોલહાક લોક યહૂદીયા વિસ્તારામાઅને એને કોલહાક લોક કાપાદોકિયા વિસ્તારામાઅને એને કોલહાક લોક પુન્તસ વિસ્તારામાઅને એને કોલહાક લોક આસિયા વિસ્તારામાઅને હેય, ");
INSERT INTO gbl_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","એને ફ્રુગીયા એને પંફૂલિયા વિસ્તારામાઅને હેય એને મિસર દેશ એને કુરેન શેહેરા પાહીને લિબિયા દેશા કોલહાક લોક, એને રોમમાઅને યેરૂસાલેમમાય યેનલા યહૂદી મુસાફીર, ");
INSERT INTO gbl_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","એટલે કાય યહૂદી, એને કાય ગેર યહૂદી જ્યાહાય યહૂદી ધર્મ માની લેદલો, ક્રેતે બેટવોય રોનારા લોક એને અરબી દેશાબી લોક હેતા, બાકી આપહે-આપહે ભાષામાય ચ્યાહાપાઅને પોરમેહેરા મોઠા-મોઠા ચમત્કારહા બારામાય બોલતા વોનાય રીઅલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","એને ચ્યા બોદા નોવાય પામ્યા, એને ગાબરાય જાયને યોકબિજાલ આખા લાગ્યા, “ઈ કાય ઓઈ રીઅલા હેય?” ");
INSERT INTO gbl_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","બાકી બીજહાંય ચ્યાહા મશ્કરી કોઇન આખ્યાં, “ચ્યા તે દારવા પીયને સાકી ગીઅલા હેતા.” ");
INSERT INTO gbl_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","તોવે પિત્તર ચ્યા અગ્યાર પ્રેષિતાહા આરે ઉબો રિયો એને મોઠેરે બોંબલીન આખા લાગ્યો, ઓ યહૂદીયા વિસ્તારા બાહાહાય, એને ઓ યેરૂસાલેમ શેહેરમાય રોનારા બોદા લોકહાય, ઈ જાઈલા, એને દિયાન દિન મા વાત વોનાય લા. ");
INSERT INTO gbl_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","જેહેકેન તુમા હોમજી રીયહા, યા લોક સાકલા નાંય હેય, કાહાકા આમીતે હાકાળેહે નોઉં વાગ્યહે. ");
INSERT INTO gbl_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","બાકી જીં આમહે આરે જાયા ઈ ચ્યો વાતો પુરાં ઓઅના હેય, જીં યોયેલ ભવિષ્યવક્તાકોય પવિત્રશાસ્ત્રામાય પોરમેહેરાય આખલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","પોરમેહેર આખહે, કા છેલ્લા દિહાહામાય એહેકેન ઓઅરી, કા આંય મા આત્મા બોદા માઅહાલ દિહી, એને તુમહે પોહા એને તુમહે પોહયો ભવિષ્યવાણી કોઅરી, એને તુમહે જુવાન્યે દર્શન એઅરી, એને તુમહે ડાયા હોપને એઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ચ્ચા દિહાહામાય આંય મા સેવાક એને સેવાક્યે બાયહેનબી મા આત્મા દિહી, એને ચ્યે બી ભવિષ્યવાણી કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","એને આંય ઉચે આકાશ માય પરાક્રમ, એને નિચે દોરત્યેવોય ચિન્હે એટલે લોય, એને આગ એને દુમાડા વાદળાં દેખાડીહી. ");
INSERT INTO gbl_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","પ્રભુ યેયના પેલ્લા દિહી કાળો પોડી એને આંદારાં ઓઈ જાઅરી એને ચાંદ લોય રોકો ઓઈ જાઅરી, તો દિહી બોજ મહાન એને ચોમકનારો દિહી ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","એને ચ્યા સમયા પેલ્લા જો કાદો પ્રભુવા નાંવ લેઅરી, તોજ તારણ મેળવી. ");
INSERT INTO gbl_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ઓ ઈસરાયેલ લોકહાય, યો વાતો વોનાયા, નાજરેત ગાવામાઅને ઈસુ યોક ઓહડો માઅહું આતો, ચ્યા ચમત્કારા કામ એને નોવાયે કામ એને ચિન્હા કોય ચ્યાલ પોરમેહેરાય તુમહે હોમ્મે સાબિત કોઅલો આતો, તુમા પોતે ઈ જાંઅતાહા કા ઈ હાચ્ચાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","પોરમેહેરાકોય ઠરાવલી યોજના એને પેલ્લા જ્ઞાનાનુસાર, તો તુમહે આથામાય હોપાય ગીયો, તુમહાય ચ્યાલ ખારાબ માઅહા મોદાત લેયને ખીલા ઠોકીન હુળીખાંબાવોય ચોડવીન માઆઇ ટાક્યો. ");
INSERT INTO gbl_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","બાકી ચ્યાલ પોરમેહેરે ચ્યા મોરણા બંધન માઅને છોડાવીન ચ્યાલ પાછો જીવતો કોઅયો, કાહાકા ઈસુલ મોરણા તાબામાંય નાંય રાખી હોકતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","કાહાકા દાઉદ રાજા ઈસુ બારામાય એહેકોય આખહે, “આંય મા પોરમેહેરાલ કાયામ મા આગલા દેખતો રિયો, કાહાકા તો મા જમણા આથા એછે હેય, યાહાટી કા આંય ચ્યા લોકહાન નાંય બીઅયુ, જ્યા મા નુકસાન કોઅરા માગતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","યાહાટી આંય આનંદાકોય બાઆય ગીયો, એને આંય આનંદાકોય તો સ્તુતિ કોઅતાહાંવ, એને મા શરીરબી આશામાય બોની રોહે. ");
INSERT INTO gbl_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","કાહાકા તું મા જીવાલ અધોલોકમાય નાંય જાં દેહે એને પવિત્ર માઅહા કુડીલ હોડી નાંય જાં દેહે. ");
INSERT INTO gbl_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","તુયે માન જીવના વાટ દેખાડીહી; તું માન દર્શન થી તો હજર્યેમાય આનંદાકોય બોઅઇ દેહે.” ");
INSERT INTO gbl_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","“ઓ બાહાહાય, આંય ડાયા દાઉદ રાજા બારામાય તુમહાન ઈંમાતકોય આખી હોકતાહાવ કા તો તે મોઅઇ ગીયો એને દાટી બી દેનો એને ચ્યા કોબાર આજ લોગુ આપહે ઈહીં હેય. ");
INSERT INTO gbl_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","તો ભવિષ્યવક્તો આતો, તો જાંઅતો આતો કા પોરમેહેરાય કોસામ ખાયન ચ્યાઆરે વાયદો કોઅયેલ, કા આંય તો પીડી માઅને યોકા માઅહાલ તો રાજગાદ્યેવોય બોહાડિહી. ");
INSERT INTO gbl_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","દાઉદ રાજાય ઈ જાઇન કા ભવિષ્યમાય કાય ઓઅનારા આતા, એને યાહાટી ચ્યે ઈસુ ખ્રિસ્તા મોઅલા માઅને પાછા જીવતા ઓઅના વાત કોઅયી, કાહાકા તું મા જીવાલ અધોલોકમાય નાંય જાં દેહે એને પવિત્ર માઅહા કુડીલ હોડી નાંય જાં દેહે. ");
INSERT INTO gbl_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","યાજ ઈસુવાલ પોરમેહેરે મોઅલા માઅને પાછો જીવતો કોઅયો, જ્યા આમા બોદા સાક્ષી હેજે. ");
INSERT INTO gbl_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","આમી તો હોરગામાય પોરમેહેરા જમણા આથા મોઠા માનાપાના જાગાવોય બોઠલો હેય, એને આબહાય ઈસુલ પવિત્ર આત્મા દેના જેહેકેન ચ્યાય વાયદો કોઅલો આતો, એને ઈસુય પવિત્ર આત્મા આમહાન દેનલા હેય, જેહેકેન કા આજે તુમા એઅતેહે એને વોનાતેહે. ");
INSERT INTO gbl_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","કાહાકા દાઉદ તે હોરગામાય નાંય ચોડયો, બાકી તો પોતે આખહે, ‘પ્રભુ પોરમેહેરાય મા પ્રભુવાલ આખ્યાં, તું મા જમણા આથા એછે બોહો.’ ");
INSERT INTO gbl_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","પ્રભુ પોરમેહેરાય મા પ્રભુવાલ આખ્યાં, ‘તું મા જમણે આથે બોહો, જાવ લોગુ આંય તુમહે દુશ્માનાહાન તુમહે તાબામાંય કોઇ દાવ.’ ");
INSERT INTO gbl_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","યાહાટી, ઈસરાયેલા બોદાજ લોકહાન યે વાતહેબારામાય ખાત્રી ઓઈ જાય કા, પોરમેહેર ચ્યાજ ઈસુવાલ, જ્યાલ તુમહાય હુળીખાંબાવોય ચોડવ્યેલ પ્રભુ એને ખ્રિસ્તબી બેની ઠોરવ્યો.” ");
INSERT INTO gbl_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","જોવે લોક ઈ વોનાયા, તોવે આપા બોજ દોષી હેજે એહેકેન જાંઅયા, તોવે ચ્યા પિત્તરાલ એને બિજા પ્રેષિતાહાલ પુછા લાગ્યા, “ઓ બાહાહાય આમા કાય કોઅજે?” ");
INSERT INTO gbl_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","પિત્તરે ચ્યાહાન આખ્યાં કા, “પાપ કોઅના બંદ કોઆ, એને તુમહેમાઅને બોદા જાંઆ તુમહે પાપહા માફી મેળવાહાટી ઈસુ ખ્રિસ્તા નાંવે બાપતિસ્મા લાં, તોવે તુમહાન પવિત્ર આત્મા દાન મિળી. ");
INSERT INTO gbl_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","કાહાકા ઓ વાયદો તુમહેહાટી, એને તુમહે પોહહાહાટી, એને ચ્યા બોદા દુઉ-દુઉને લોકાહાહાટી બી હેય, જ્યાહાલ પ્રભુ આમહે પોરમેહેર ચ્યા પાહી હાદી.” ");
INSERT INTO gbl_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","પિત્તરે આજુ બોજ વાતો પાછી-પાછી આખીન ચ્યાહાન વિનાંતી કોઅયી કા તુમા પોતે યા આડી પેડયે થી બોચી જાં. ");
INSERT INTO gbl_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","જીં કાય પિત્તરે આખ્યાં, જ્યાહાય ચ્યાવોય બોરહો કોઅયો ચ્યાહાય બાપતિસ્મા લેદા, એને ચ્યેજ દિહી બોરહો કોઅનારા ટોળામાય લગભગ તીન ઓજાર માઅહે જોડાય ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","એને ચ્યે પ્રેષિતાહા પાયને હિકના, ચ્યાહાઆરે મિળીન રોઅના એને ચ્યે પ્રભુભોજમાય ભાગી ઓઅતે આતેં એને પ્રાર્થના કોઅરા દૃડતાથી લાગી રિયે. ");
INSERT INTO gbl_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","એને યેરૂસાલેમમાય બોદા લોક ધાકાય ગીયા, કાહાકા બોજ નોવાયે કામે એને ચમત્કાર પ્રેષિતાહાકોય ઓઅતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","એને બોદાજ બોરહો થોવનારા લોક યોકઠા રોતા આતા, એને જીં કાયબી ચ્યાહાપાય આતા તી બોદાંજ યોખઠા કોઅતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","એને ચ્યે ચ્યાહા મિલકાત એને કાયબી સામાન વેચિન જ્યાહાલ જીં ગોરાજ પોડતી આતી ચ્યાહાન વાટી દેતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","એને ચ્યે દિનેરોજ યોક મોનાકોય દેવાળામાય બેગે ઓએત એને ગોઅહે-ગોઅહે પ્રભુભોજમાય ભાગી ઓએ એને ઉદાર મોનાકોય આનંદાકોય ચ્યે ઈળી-મિળીન ખાઅના ખાતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","એને પોરમેહેરા સ્તુતિ કોઅતે આતેં, એને બોદા લોક ચ્યાહાથી ખુશ આતા; એને જ્યા તારણ મિળવેત, ચ્યાહાન પ્રભુ દિનેરોજ ચ્યાહામાય મેળવી દેતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","યોક દિહી પિત્તર એને યોહાન બોપરેહે તીન વાગે પ્રાર્થના સમયે દેવાળામાય જાય રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ઓલહામાય લોક યોકા જન્મા પાઅને લેંગડા આતા ચ્યા માઅહાલ લેઈને યેત, ચ્યાલ દિનેરોજ દેવાળા બાઅણા પાય જ્યાલ સુંદાર નાંવા બાઅણા આખતેહે, ચ્યાપાય બોહાડી જાત, કા તો દેવાળે જાનારાહા પાયને બિખ માગે. ");
INSERT INTO gbl_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","જોવે ચ્યાય પિત્તર એને યોહાનાલ દેવાળામાય જાતા દેખ્યા, તોવે ચ્યાહાપાઅને બિખ માગી. ");
INSERT INTO gbl_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","પિત્તર એને યોહાને ચ્યાલ દિયાન દેયને એઅયા એને પિત્તરે આખ્યાં, “આમહે એછે એએ.” ");
INSERT INTO gbl_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ચ્યાહાપાઅને કાય મિળી યે આશેકોય તો ચ્યાહા એછે એઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","તોવે પિત્તરે આખ્યાં, “ચાંદી એને હોના તે માયેપાંય હેયેજ નાંય, જીં હેય તી તુલ આંય દેતહાવ, નાજરેત ગાવામાઅને ઈસુ ખ્રિસ્તા નાવાકોય ઉઠ એને ચાલતો લાગ.” ");
INSERT INTO gbl_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","એને પિત્તરે ચ્યા જમણો આથ દોઇન ચ્યાલ ઉઠાડયો, એને તારાત ચ્યા પાગહામાય એને માંડયેહે માય તાકાત યેની. ");
INSERT INTO gbl_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","એને તો કુદીન ઉબો ઓઈ ગીયો, એને ચાલા-ફિરા લાગ્યો, એને ચાલતો, એને કૂદતો, પોરમેહેરા સ્તુતિ કોઅતો તો પિત્તર એને યોહાના આરે દેવાળા બાઆપુર ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","બોદા લોકહાય ચ્યાલ ચાલતો-ફિરતો એને પોરમેહેરા સ્તુતિ કોઅતો દેખ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","એને ચ્યાલ વોળખી લેદો કા ઓ તોજ હેય જો દેવાળા સુંદાર નાંવા બાઅણા પાય બોહીન બિખ માગે, એને ચ્યે યે ઘટના કોય જીં ચ્યાઆરે જાયલી, ચ્યે બોજ નોવાય પામીન ચમકાય ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","જોવે તો માઅહું પિત્તર એને યોહાના આરે આતો, તે બોદા લોક બોજ નોવાય પામીન ચ્યે બોદે સુલેમાના પારસાળા માય દાંહાદી ગીયે, જાં હારો ઓઅય ગીઅલા માઅહું પિત્તર એને યોહાનાલ ફીટ દોઅય રિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ઈ એઇન પિત્તરે લોકહાન આખ્યાં, “ઓ ઈસરાયેલી લોકહાય, તુમહાન યા માઅહાલ એઇન કાહા નોવાય લાગી? એને આમહે એછે એહેકેન કાહા દારી-દારી એઅતાહા? કા જેહેકેન આમહાયજ આમહે શક્તિ કા ભક્તિ તાકાતેવોય યા માઅહાલ ચાલા-ફિરા લાયકે બોનાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","આમહે આગલ્યાડાયા આબ્રાહામા, ઈસાકા એને યાકૂબા પોરમેહેર, આપહે વડીલાહા પોરમેહેરે ચ્યા ચાકાર ઈસુવા મહિમા કોઅયી, બાકી તુમહાય ચ્યાલ માઆઇ ટાકાંહાટી યહૂદી આગેવાનહાન હોઅપી દેનો, એને જોવે પિલાત રાજાય ચ્યાલ ડોંડ દેઅનાથી મોનાઈ કોઇ દેના, તોવે તુમહાય પિલાતા હોમ્મે ઈસુ નાકાર કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","તુમહાય ઈસુલ નાકાર કોઇ દેનો, જો પવિત્ર એને ન્યાયી હેય, બાકી તુમહાય ઈ માગણી કોઅયી કા ચ્યા બોદલે ખૂની માઅહાલ તુમહેહાટી છોડી દેય. ");
INSERT INTO gbl_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","એને તુમહાય લોકહાન જીવન દેનારાલ માઆઇ ટાક્યો બાકી પોરમેહેરે ચ્યાલ મોઅલા માઅને પાછો જીવતો ઉઠાડયો, ચ્યા આમા સાક્ષી હેજે. ");
INSERT INTO gbl_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ખ્રિસ્ત ઈસુ નાવામાય બોરહો કોઅલા લીદે યા માઅહાલ જ્યાલ તુમા જાંઅતેહે, જ્યાલ તુમા યે સમયે એઅઇ રીયહે, ચ્ચાલ તાકાત દેનલી હેય ઈ માઅહું ઈસુ નાવામાય એને ખ્રિસ્ત ઈસુમાય બોરહો કોઅલા લીદે બિલકુલ હારો હુદરી ગીઅલો હેય, જેહેકેન તુમા પોતે એઇ રીઅલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“એને આમી ઓ બાહાહાય, માન ખોબાર હેય કા તુમહાય એને તુમહે આગેવાનાહાય ઈસુલ જાંઅયા વોગાર માઆઇ ટાક્યો કાહાકા તુમહાન નાંય ખોબાર આતી કા તો ખ્રિસ્ત હેય. ");
INSERT INTO gbl_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","બાકી જ્યેં વાતહેબારામાય પોરમેહેરાય બોદા ભવિષ્યવક્તાહાકોય પેલ્લાજ આખલા આતા, કા ખ્રિસ્ત દુઃખ ઉઠાવી એને માઆઇ ટાકલો જાય, એને ચ્યાય તી હાચ્ચાં સાબિત કોઇ દેખાડયાં. ");
INSERT INTO gbl_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","યાહાટી આમી તુમા પાપ કોઅના બંદ કોઆ, એને પોરમેહેરા એછે ફિરા કા તુમહે પાપહા માફી મિળી, તોવે પોરમેહેરાપાઅને આત્મિક સામર્થ્ય મિળી. ");
INSERT INTO gbl_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","એને તો ઈસુલ દોવાડી, જો ખ્રિસ્ત હેય જ્યાલ તુમહેહાટી પેલ્લાથીજ નિવાડલા હેય. ");
INSERT INTO gbl_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ઈસુલ હોરગામાય ચ્ચા સમયે લોગુ રોઅના જરુરી હેય, જોવે પોરમેહેર ચ્યે વસ્તુલ નોવી બોનાવી દી જ્યો ચ્યે બોનાવલ્યો હેય, બોજ સમાયા પેલ્લા પોરમેહેરાય લોકહાન ઈ આખાહાટી પવિત્ર ભવિષ્યવક્તાહાકોય એહેકેન કોઅના વાયદો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","જેહેકેન કા મૂસાય આખ્યાં, ‘તુમહે પ્રભુ પોરમેહેર તુમહે બાહાહા માઅને તુમહેહાટી મા રોકો યોક ભવિષ્યવક્તાલ દોવાડી, જીં કાય તો તુમહાન આખે, ચ્યા તુમા વોનાજા.’ ");
INSERT INTO gbl_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","બાકી જો કાદો માઅહું ચ્યા ભવિષ્યવક્તા નાંય વોનાયે, તી માઅહું પોરમેહેરા લોકહામાય નાંય રોય એને પોરમેહેર ચ્યાલ નાશ કોઅય દેઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","શમુએલ ભવિષ્યવક્તા એને ચ્યા પાછે યેનારાહા આરે બોદા ભવિષ્યવક્તાહાયબી વાત આખ્યેલ યા દિહીહયામાય કાય ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","તુમા બોદા ભવિષ્યવક્તાહા વારીસ હેતા એને ચ્યા કરારા ભાગીદાર હેય, જો પોરમેહેરે તુમહે આગલ્યા ડાયહા આરે કોઅલો, કાહાકા પોરમેહેરાય આબ્રાહામાલ આખ્યાં, ‘તો વંશાકોય દોરતીવોય બોદા જાતી લોક બોરકાત મેળવી.’ ");
INSERT INTO gbl_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","પોરમેહેરાય ચ્યા ચાકારાલ મોઅલા માઅને પાછો જીવતો ઉઠાડીન બોદહા પેલ્લા તુમહેપાય દોવાડયો, કા આપહે માઅને બોદહાલ ચ્યાહા પાપી જીવના માઅને ફેરવી લેયને પોરમેહેરા બોરકાત દેય.” ");
INSERT INTO gbl_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","જોવે પિત્તર એને યોહાન લોકહાન ઈ આખી રીઅલા આતા, તોવે યાજક એને દેવાળા રાખવાળી કોઅનારાહા આગેવાન એને સાદૂકી લોક ચ્યાહા હોમ્મે યેયન ઉબા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","એને બોજ ખિજવાય ગીયા, કાહાકા પિત્તર એને યોહાન ઈસુ બારામાય હિકાડતા આતા કા જ્યા લોક મોઅઇ ગીયહા પોરમેહેર ચ્યાહાન મોઅલા માઅને પાછો જીવતો કોઅરી, જેહેકેન ચ્યાય ઈસુલ મોઅલા માઅને પાછો જીવતો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","એને ચ્યાહાય ચ્યાહાન દોઓઈન બીજે દિહે લોગુ જેલેમાય થોવ્યા, કાહાકા રુવાળા પોડી ગીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","એને જ્યેં પ્રેષિતાહા સંદેશ વોનાયે, ચ્યાહામાઅને બોજ લોકહાય ઈસુવોય બોરહો કોઅયો, એને બોરહો કોઅનારા માટડાહા ગોણત્રી બોદી મિળીન આમી લગભગ પાચ ઓજાર લોગુ ઓઅય ગીયી. ");
INSERT INTO gbl_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","બીજે દિહી ચ્યાહા આગેવાન, વડીલ લોક એને મૂસા નિયમ હિકાડનારા ગુરુ યેરૂસાલેમ શેહેરામાય યોક જાગે યોખઠા જાયા. ");
INSERT INTO gbl_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","જ્યા લોક સોબાયેમાય યોખઠા જાયલા આતા, ચ્યાહામાય હન્ના મહાયાજક આતો એને કાયફા, યોહાન, સિકંદર એને બિજા જોલા મહાયાજકા કુટુંબમાઅને આતા ચ્યાબી સોબાયેમાય સામીલ આતા. ");
INSERT INTO gbl_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","એને પિત્તર એને યોહાનાલ વોચમાય ઉબા કોઇન પુછા લાગ્યા, “યા માઅહાલ હારાં કોઅરાહાટી કુંયે તુમહાન સામર્થ એને ઓદિકાર દેનો?” ");
INSERT INTO gbl_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","તોવે પિત્તર પવિત્ર આત્માકોય બોઆય ગીયો એને ચ્યે આગેવાનહાન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","“ઓ લોકહા આગેવાનાહાય એને વડીલાહાય, આમહાય યોકા નોબળા માઅહા ભલા કોઅલા હેય, એને આજે યા બારામાય આમહે પૂછપારસ ઓઈ રીયહી કા યા કેહેકેન બોચાવ જાયો. ");
INSERT INTO gbl_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","તોવે તુમા બોદા એને બોદા ઈસરાયેલી લોક જાઈલા કા ઈ નાજરેત ગાવામાઅને ઈસુ ખ્રિસ્તા નાવાકોય કોઅલા હેય, ચ્યાજ ઈસુવાલ તુમહાય હુળીખાંબાવોય ચોડવી દેનલો આતો, બાકી પોરમેહેરે ચ્યાલ મોઅલા માઅને પાછો જીવતો કોઅયો, આજે ચ્યાજ નાવાકોય ઈ માઅહું તુમહે હોમ્મે હારાં હુદરીન ઉબલાં હેય. ");
INSERT INTO gbl_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ખ્રિસ્ત ઈસુજ તો દોગાડ હેય, જ્યા બારામાય શાસ્ત્રામાય લોખલાં હેય કા જ્યાલ તુમહે બાંદનારાહાય નોકામ્યો હુમજ્યો, એને તોજ ખૂણાવોયને મેન દોગાડ બોની ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ઈસુ સિવાય કાદા બિજા કોય બોચાવ નાંય હેય, કાહાકા હોરગા નિચે માઅહામાય બિજા કાય નાંવ નાંય દેનલા હેય, જ્યાકોય આપા બોચી જાય હોકજે.” ");
INSERT INTO gbl_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","જોવે ચ્યાહાય પિત્તર એને યોહાન યાહા ઈંમાત દેખ્યી, એને ઈ જાંઅયા કા યા અભણ એને સાદે માઅહે હેય, તોવે નોવાય પામ્યા, પાછે ચ્યાહાન વોળખ્યા, યા ઈસુ આરે રોય રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","બાકી જીં માઅહું હારો જાયલો આતો, તો પિત્તર એને યોહાના આરે ઉબો દેખીન, સોબાયેમાય યોખઠા ઓઅલા લોક ચ્યાહા વિરુદમાય કાયજ આખી નાંય હોક્યા. ");
INSERT INTO gbl_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","બાકી ચ્યાહાન મોઠી સોબાયે બાઆ જાયને ઉબા રા આખ્યાં, એને ચ્યા ચ્યાહામાય વિચાર કોઅતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“આપા યા માઅહા આરે કાય કોઅતા? કાહાકા યેરૂસાલેમ શેહેરામાય રોનારા બોદા લોકહાન ખોબાર હેય, કા યાહાકોય યોક પ્રસિદ ચિન્હ દેખાડલા ગીઅલા હેય, એને આપા યાલ નાકાર નાંય કોઇ હોકજે. ");
INSERT INTO gbl_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","બાકી લોકહામાય ઈ ખોબાર આજુ વોદારે નાંય ફેલાય જાય, ચ્યાહાટી આપા ચ્યાહાન દમકાડતા, કા ચ્યા ઈસુ નાવાકોય પાછી કાદા માઅહા આરે વાત નાંય કોએ.” ");
INSERT INTO gbl_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","તોવે પિત્તર એને યોહાનાલ સબાયે માજે હાદ્યા એને ચેતાવણી દેયને ઈ આખ્યાં, “ઈસુવા નાવાકોય કાયજ નાંય બોલના એને નાંય હિકાડના.” ");
INSERT INTO gbl_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","બાકી પિત્તર એને યોહાનાય ચ્યાહાન આખ્યાં, “તુમાંજ ઠોરવા, કા કાય ઈ પોરમેહેરા આગલા હારાં હેય, કા આમા પોરમેહેરા વાતે કોઅતા તુમહે વાત માનજે? ");
INSERT INTO gbl_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","કાહાકા ઈ તે આમહે કોય નાંય ઓઈ હોકે, કા જીં આમહાય દેખ્યા એને વોનાલા હેય, તી નાંય આખજે.” ");
INSERT INTO gbl_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","તોવે ચ્યાહાય ચ્યાહાન આજુ દોમકાડીન જેલેમાઅને છોડી દેના, કાહાકા લોકહા લીદે ચ્યાહાન ડોંડ દેઅના કાયજ કારણ નાંય મિળ્યાં, યાહાટી કા જીં ઘટના જાયલી આતી ચ્યા લીદે બોદા લોક પોરમેહેરા સ્તુતિ કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","કાહાકા જો માટડો ચમત્કારિક રીતે હારો જાયલો આતો, તો ચાળહી વોરહા કોઅતો વોદારી ઉંબારે આતો. ");
INSERT INTO gbl_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","પિત્તર એને યોહાન જેલેમાઅને સુટીન યેરૂસાલેમમાય ચ્યાહા હાંગાત્યાહા પાય યેના, એને જીં કાય મુખ્ય યાજક એને આગેવાનહાય આખલા આતા, ચ્યાહાન આખી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ઈ વોનાઈન, ચ્યાહાય યોકમન ઓઇન મોઠા આવાજા કોય પોરમેહેરાલ પ્રાર્થના કોઅયી, “ઓ પ્રભુ, તું તોજ હેય જ્યાંય હોરગા એને દોરતી એને જીં કાય ચ્યામાય હેય બોનાવ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","તુયે પવિત્ર આત્માકોય તો ચાકાર આમહે વડીલ દાઉદા મુંયા કોઇન આખ્યાં કા, ગેર યહૂદી લોકહાય કાહા ખળબળ કોઅયી? એને લોકહાય કાહા નોકામ્યે વાતહે વિચાર કોઅયો? ");
INSERT INTO gbl_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","પ્રભુ એને ચ્યા ખ્રિસ્તા વિરુદમાય દોરતી રાજા ઉબા રોય ગીયા, એને ઓદિકારી યોખઠા ઓઅઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","હાં, હેરોદેસ એને પંતિયાસ પિલાત બી યા નગરમાય ગેર યહૂદી એને ઈસરાયેલીયાઆરે મિળીન તો પવિત્ર સેવક ઈસુ વિરુદમાય, જ્યાલ તુયે ખ્રિસ્તા રુપામાય અભિષેક કોઅયેલ, આસલીમાય એકતામાય યોખઠા ઓઅય ગીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ચ્યાહાય તીંજ કોઅયા જીં તો સામર્થ્યાકોય એને તો ઇચ્છાકોય પેલ્લાજ નોક્કી કોઇ લેદલા આતા કા ઓઅરા જોજે. ");
INSERT INTO gbl_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","આમી ઓ પ્રભુ, ચ્યાહા દમકી વોનાય, એને તો સેવકાહાલ ઈ વરદાન દે કા તો વચન મોઠી ઈંમાતે કોય આખે. ");
INSERT INTO gbl_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","એને હારાં કોઅરાહાટી તું ઓદિકાર દે કા ચિન્હ ચમત્કાર એને અદભુત કામ તો પવિત્ર સેવક ઈસુ નાવાકોય કોઅલે જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","જોવે ચ્યે પ્રાર્થના કોઇ ચુક્યે, તોવે તો જાગો જાં ચ્યે બેગે આતેં આલી ગીયો, એને ચ્યે બોદે પવિત્ર આત્માકોય બાઆય ગીયે, એને ચ્યા પોરમેહેરા વચન મોઠી ઈંમાતે કોય આખે. ");
INSERT INTO gbl_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","એને બોરહો કોઅનારાહા મંડળી યોક જીવ એને યોકા મોના આતી, ઓલે લોગુ કા કાદોજ પોતા મિલકાત પોતા નાંય આખતો આતો, બાકી ચ્યાહાય ચ્યાહાપાય જીં કાય આતાં તી બોદા યોખઠા કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","એને પ્રેષિત મોઠા સામર્થ્યાકોય પ્રભુ ઈસુ મોઅલા માઅને પાછો જીવી ઉઠના બારામાય સાક્ષી દેતા રોયા એને ચ્યા બોદહાવોય પોરમેહેરા મોઠી સદા મોયા આતી. ");
INSERT INTO gbl_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","એને ચ્યાહામાય કાદોજ ગરીબ નાંય આતો, કાહાકા જ્યાહાવોય જાગો એને ગોએ આતેં, ચ્યે ચ્યાહાન વેચી-વેચિન, વેચલી વસ્તુ પોયહા લેય યેત, એને પ્રેષિતાહાલ દેત. ");
INSERT INTO gbl_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","એને જેહેકેન જ્યાલ ગોરાજ પોડે, ચ્યાનુસાર પ્રેષિત બોદહાન વાટી દિયા કોઅતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","યોસેફ નાંવા યોક માટડો આતો, તો લેવી કુળામાઅને આતો, એને સાઇપ્રસ બેટવોયને આતો, પ્રેષિતાહાય ચ્યાલ બારનાબાસ આખ્યાં, જ્યા મતલબ હેય, યોક ઓહડો માઅહું જો બીજહાન ઉત્તેજન કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ચ્યા કોલહિક જમીન આતી, ચ્યાય ચ્યેલ વેચી દેની, એને જાગો વેચલા પોયહા લેય યેયન પ્રેષિતાહાલ દેના. ");
INSERT INTO gbl_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","વિસ્વાસ્યાહા માઅને, હનાન્યા નાંવા યોક માટડાય એને ચ્યા થેએ સફીરા ચ્યાહાય કોલહિક મિલકાત વેચી દેની જીં ચ્યાહા આતી. ");
INSERT INTO gbl_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","એને ચ્યા પોયહા માઅને કોલહાક પોયહા હનાન્યાય ચ્યાહાહાટી રાખી થોવ્યા, એને બાકી પોયહા લેય યેયન ચ્યાહાય પ્રેષિતાહાલ દેય દેના એને ઈ વાત ચ્યા થેએબી હારેરીતે જાઅતી આતી. ");
INSERT INTO gbl_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","તોવે પિત્તરે આખ્યાં, “ઓ હનાન્યા, જો સૈતાને તો મોનામાય પવિત્ર આત્મા આરે જુઠા બોલના વિચાર ટાકલો હેય, એને તુયે તો વેચલી મિલકાત માઅને કોલહાક પોયહા તોહાટી રાખી થોવલા હેય. ");
INSERT INTO gbl_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","કાય વેચી દાં પેલ્લા તો મિલકાત તો નાંય આતી? એને જોવે વેચી દેની તે ચ્યા કિંમત કાય તો તાબામાંય નાંય આતી? તે તો મોનામાય ઓ ખારાબ વિચાર કેહેકેન યેનો? તુયે માઅહાલ નાંય, બાકી પોરમેહેરાલ છેતર્યો.” ");
INSERT INTO gbl_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ઈ વોનાતાજ હનાન્યા દોરતીવોય પોડી ગીયો, એને તો મોઓઈ ગીયો, એને બોદા વોનાનારા લોક ગાબરાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","પાછે જુવાન્યા યેયન ચ્યા કુડી ફાડકા કોઇન ચોંડાળીન બાઆ લેય જાયને દાટી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","લગભગ તીન કલાક પાછે ચ્યા થેએ માજે યેની, તી યે ઘટના બારામાય કાયજ નાંય જાઅતી આતી. ");
INSERT INTO gbl_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","તોવે પિત્તરે ચ્યેલ પુછ્યાં, “માન આખ ઓલહામાયજ મિલકાત વેચ્યેલ કા?” ચ્યે આખ્યાં, “હાં, ઓલહાંજ માય.” ");
INSERT INTO gbl_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","પિત્તરે ચ્યેલ આખ્યાં, “ઈ કાય વાત હેય, કા તુમા બેન્યાહાય પ્રભુ આત્મા પરીક્ષા કોઅરાહાટી એકી કોઅયી? એએ, તો દોનારાલ દાટીન યેનારા બાઅણા પાય ઉબલા હેય, એને તુલબી બાઆ લેય જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","તોવે તી તારાત ચ્યા પાગહા આગલા દોરતીવોય પોડી ગીયી એને તી મોઓઈ ગિઇ, એને જુવાન્યા માજે યેના, તોવે ચ્યેલ મોઅલી દેખી, ચ્યેલ બાઆ લેય ગીયા, એને ચ્યે માટડા પાહી દાટી દેની. ");
INSERT INTO gbl_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","એને યેરૂસાલેમ શેહેરા મંડળીમાય એને જ્યાહાય ઈ વાત વોનાયે ચ્યે બોદે બોજ ગાબરાય ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","પ્રેષિતાહાકોય બોજ ચિન્હ એને અદભુત કામે લોકહામાય દેખાડલે જાતે આતેં, એને બોદે બોરહો કોઅનારે યોકમન ઓઇન દેવાળા ઈહીં સુલેમાના પારસાળા માય બેગે ઓઅતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","બાકી જ્યાહાય આમી લોગુ ઈસુવોય બોરહો નાંય કોઅલો આતો, ચ્યાહાલ ઈ ઈંમાત નાંય ઓએ કા, ચ્યાહામાય મિળી જાજે, તેરુંબી લોક ચ્યાહા વાહવા કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","એને પ્રભુવોય બોરહો કોઅનારાહા ગોણત્રી વોદતી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","જીં કાય પ્રેષિત કોઅતા આતા ચ્યા લીદે લોક બિમાર્યાહાન વાટેવોય લેય યેયન પાથારી એને ખાટલાહાવોય હુવાડી દાં આતેં, કા જોવે પિત્તર યેય, તોવે ચ્યા છાવાડીજ ચ્યાહામાઅને કાદાવોય પોડી જાય. ");
INSERT INTO gbl_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","એને યેરૂસાલેમ શેહેરા આહી-પાહીને શેહેરામાઅને બોજ લોક બિમાર્યાહાન એને બુતહાકોય પીડાલાહાન લેય યેયન, પ્રેષિતાહા પાય બેગે ઓઅતે આતેં, એને બોદે હારેં કોઇ દેવામાય યેતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","તોવે મહાયાજક એને ચ્યા બોદા હાંગાત્યા જ્યા સાદૂકી ટોળા આતા, પ્રેષિતાહા આરે ઈર્ષ્યા કોઅરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","એને પ્રેષિતાહાન દોઇન જેલેમાય કોંડાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","બાકી રાતી પ્રભુ યોક હોરગા દૂતાય જેલે બાઅણા ઉગાડીન ચ્યાહાલ બાઆ લેય યેયન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“જાયા, દેવાળામાય ઉબા રોયન, લોકહાન યા નોવા અનંતજીવના બારામાય આખા.” ");
INSERT INTO gbl_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ઈ વોનાયને પ્રેષિત બોડે હાકાળેહેજ દેવાળામાય ગીયા, જેહેકેન ચ્યાહાન હોરગા દૂતહાકોય આખલા ગીઅલા આતા, એને ચ્યાહાય લોકહાન હિકાડના સુરુ કોઅયા. બાકી મહાયાજક એને ચ્યા હાંગાત્યાહાય યેયન મોઠી સોબાયેલ એને ઈસરાયેલ્યાહા બોદા વડીલાહાન યોખઠા કોઅયા, એને જેલેમાય આખી દોવાડયા કા પ્રેષિતાહાન લેય યેય. ");
INSERT INTO gbl_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","બાકી દેવાળા રાખવાળ્યા જેલેમાય પોઅચ્યા તે પ્રેષિત ચ્યાહાન નાંય મિળ્યાં, એને ફિરી યેયન ચ્યાહાય આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“આમહાય તે જેલેલ તે બરાબર બંદ કોઅલા, એને જાગલ્યાહાન બાઆ બાઅણા પાય ઉબલા દેખ્યા, બાકી જોવે ખુલ્યા, તે માજે કાદોજ નાંય મિળ્યો.” ");
INSERT INTO gbl_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","જોવે દેવાળા રાખવાળ્યાહા આગેવાન એને મુખ્ય યાજક ઈ ખોબાર વોનાયા, તે ચ્યાહા બારામાય બોજ ચિંતામાય પોડી ગીયા કા યા પરિણામ કાય ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ચ્યે સમયે કાદાય તેરુ યેઇન ચ્યાહાન આખ્યાં, “એઆ, જ્યાહાન તુમહાય જેલેમાય કોંડાડી દેનલા આતા, ચ્યા દેવાળામાય ઉબા રોયન લોકહાન હિકાડી રીઅલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","જોવે ચ્યા ઈ વોનાયા, તોવે દેવાળા રાખવાળ્યાહા આગેવાન રાખવાળ્યાહા આરે દેવાળામાય ગીયા, એને પ્રેષિતાહાલ મોઠી સોબાયે હોમ્મે લેય યેના, બાકી બળજબરી કોઇન નાંય, કાહાકા ચ્યા લોકહાન બિઅતા આતા, કા લોક ચ્યાહાન દોગડાકોય ઠોકીન ચ્યાહાન માઆઇ ટાકી. ");
INSERT INTO gbl_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","જોવે મોઠી સોબાયેમાય ઉબા કોઅયા, તોવે મહાયાજકાય ચ્યાહાન પુછ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“કાય આમહાય ચેતાવણી દેયન તુમહાન આગના નાંય દેનલી? કા તુમા યા નાંવા બારામાય હિકાડના નાંય, તેરુંબી, તુમહાય બોદા યેરૂસાલેમ શેહેરામાય તુમહે શિક્ષણ બોઓઈ દેનલા હેય એને યા માઅહાલ માઆઇ ટાકના દોષ બળજબરી કોય આમહાવોય કાહા થોવા માગતાહા.” ");
INSERT INTO gbl_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","તોવે પિત્તર એને બિજા પ્રેષિતાહાય જાવાબ દેનો, “માઅહા આગના પાળના કોઅતા પોરમેહેરા આગના પાળના આમે ફરજ હેય. ");
INSERT INTO gbl_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","આમહે આગલ્યા ડાયહા પોરમેહેરે ઈસુલ મોઅલા માઅને પાછો જીવતો કોઅયો, જ્યાલ તુમહાય હુળીખાંબાવોય ચોડવીન માઆઇ ટાકલો. ");
INSERT INTO gbl_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ચ્યાલુજ પોરમેહેરે પ્રભુ એને તારણારો ઠોરવ્યો, ચ્યા જમણા આથાકોય ઉચો કોઅયો, કા ઈસરાયેલા લોક ચ્યાહા ખારાબ વિચાર એને વાટી વોયને પોરમેહેરાએછે ફિરે, એને ચ્યાકોય ચ્યાહા પાપહા માફી મિળવે. ");
INSERT INTO gbl_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","એને આમા યે વાતહે સાક્ષી હેજે, એને પવિત્ર આત્માબી, જો પોરમેહેરાય ચ્યાહાન દેનલા હેય, જ્યેં ચ્યા આગના માનતેહેં.” ");
INSERT INTO gbl_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","જોવે મોઠી સોબાયે લોક ઈ વોનાયા, એને ખિજવાઈ ગીયા, એને પ્રેષિતાહાન માઆઇ ટાકના વિચાર કોઅતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","બાકી ગમાલીયેલ નાંવા યોક પોરૂષી જો મૂસા નિયમ હિકાડનારો એને બોદા લોકહામાય માના-પાનાં આતો, મોઠી સોબાયેમાય ઉબો રોયન પ્રેષિતાહાન થોડીવાઆ લોગુ બાઆ લેય જાં આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","તોવે ચ્યાય મોઠી સોબાયે સભ્ય આતા ચ્યાહાન આખ્યાં, “ઈસરાયેલ બાહાહાય, જીં કાય યા માઅહા આરે કોઅરા માગતાહા, તી વિચાર કોઇન કોઅજા. ");
INSERT INTO gbl_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","કાહાકા યા દિહીહયા પેલ્લા થિયુદાસ નાંવા માઅહું યેના, તો ઈ આખે કા તો યોક મોઠા માઅહું હેય એને લગભગ ચાર હોવ માઅહે ચ્યા શિષ્ય બોની ગીયે, એને ચ્યાલ માઆઇ ટાક્યો, એને ચ્યાલ માનનારે વિખરાય ગીયે એને ચ્યાહા નાશ ઓઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ચ્યા પાછે લોકહા ગોણત્રી દિહહામાય ગાલીલ ભાગા માઅહું યહૂદા યેનો, એને કોલહાક લોકહાન ચ્યા એછે કોઇ લેદા બાકી તેરુંબી મોઅઇ ગીયો, એને ચ્યાલ માનનારા, બોદા વિખરાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","યાહાટી આમી આંય તુમહાન આખતાહાવ, યા માઅહા ઇહિને દુર રા એને ચ્યાહાઆરે કાય કામ નાંય રાખતા, કાહાકા જોવે ઈ યોજના યા કામ માઅહા ઇહિને ઓઅરી તોવે તો નાશ ઓઈ જાય. ");
INSERT INTO gbl_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","બાકી જોવે પોરમેહેરા ઇહિને ઓઅરી તોવે તુમા ચ્યાહાન કોદાચ મિટાડી નાંય હોકહા, એહેકોય નાંય બોને, કા તુમા પોરમેહેરાઆરે બી લોડનારા બોને.” ");
INSERT INTO gbl_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","તોવે ચ્યાહાય ચ્યા વાત માની લેદી, એને પ્રેષિતાહાન હાદિન માર ઠોકાડયો, એને ચ્યાહાન ઈ આગના દેની કા આમીને ઈસુ નાવાકોય કાયજ નાંય આખના એને પાછે ચ્યાહાન છોડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ચ્યા યે વાતે લીદે ખુશ ઓઇન મોઠી સોબાયે હોમ્મેને જાતા રિયા, કા આપા ઈસુ લીદે અપમાનિત ઓઅના લાયકે ઠોર્યા. ");
INSERT INTO gbl_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ચ્યા પાછે પ્રેષિતાહાય દિનેરોજ, દેવાળામાય એને ગોઅહે-ગોઅહે જાયને હિકાડના એને હારી ખોબારે પ્રચાર કોઅના ચાલુ રાખ્યાં કા ઈસુજ ખ્રિસ્ત હેય. ");
INSERT INTO gbl_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ચ્યા દિહીહયામાય જોવે ઈસુવોય બોરહો કોઅનારાહા ગોણત્રી વોદતી લાગી, તોવે યુનાની ભાષા બોલનારા શિષ્યહાય હિબ્રુ બોલનારાહા શિષ્યહા વિરુદ કુરકુર કોઅરા લાગ્યા, “દિનેરોજ ખાઅના-પિઅના માય આમહે વિધવા બાયહે ખોબાર નાંય લેદલી જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","તોવે ચ્યા બારા પ્રેષિતાહાય યેરૂસાલેમ બિજા શિષ્યાહાલ ચ્યાહાપાય હાદિન આખ્યાં, “આમહાન પોરમેહેરા વચન હિકાડના છોડીન ખાઅના-પિઅના સેવાયેમાય રોઅના ઠીક નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","યાહાટી ઓ બાહાહાય, આપહે માઅને હાંત નાવાજલા માટડાહાન જ્યા પવિત્ર આત્માકોય એને બુદ્દિ કોય બોઆલા રોય, ઓહડાહાલ નિવડી લા, કા આમા ચ્યાહાન યા કામ હોઅપી દેજે. ");
INSERT INTO gbl_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","બાકી આમા તે પ્રાર્થના કોઅનામાય એને વચન પ્રચાર કોઅરા એને હિકાડાં સેવાયેમાય લાગી રાહુ.” ");
INSERT INTO gbl_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ઈ વાત બોદી મંડળીલ હારી ગોમી, એને ચ્યાહાય સ્તેફનુસ નાંવા યોક માટડો જો બોરહો કોઅનામાય એને પવિત્ર આત્માકોય બોઆલો આતો, ફિલિપ, પ્રખરુસ, નીકાનોર, તિમોન, પરમીનાસ એને અન્તાકિયા શેહેરા નીકુલાસાલ, જ્યાહાય યહૂદી ધર્મ સ્વીકાર કોઅય લેદલો આતો. ચ્યાહાય યા લોકહાન નિવડયા. ");
INSERT INTO gbl_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","એને યાહાન પ્રેષિતાહા હામ્મે લેય યેના, એને ચ્યાહાય પ્રાર્થના કોઇન ચ્યા કામાલ કોઅરાહાટી ચ્યાહાન નિવડ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","એને પોરમેહેરા વચન ફેલાતા ગીયા, એને યેરૂસાલેમ શેહેરામાય શિષ્યહા ગોણત્રી બોજ વોદતી ગીયી, એને કોલહાક યહૂદી યાજકાહાય બી ઈસુ ખ્રિસ્તાવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","સ્તેફનુસ સદા મોયા એને સામર્થ્યાકોય બઆયન લોકહામાય મોઠે-મોઠે અદભુત કામ એને ચિન્હે દેખાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","બાકી કોલહાક લોકહાય સ્તેફનુસા વિરુદ કોઅયો, ચ્યે ચ્યા સોબાયે ઠિકાણા સભ્ય આતેં, જ્યાહાલ ગુલામી-છુટકો આખતે આતેં, ચ્યા લોક કુરેન એને સિકન્દરિયા શેહેરામાઅને કિલિકિયા એને આસિયા વિસ્તારામાઅને બી આતેં, યા લોક સ્તેફનુસા આરે બોલા-બોલી કોઅરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","બાકી જીં કાય ચ્યાય આખ્યાં ચ્યે ચ્યા કાયજ જોવાબ નાંય દી હોક્યે, કાહાકા પવિત્ર આત્માય ચ્યાલ બોજ બુધિમાની કોય બોલાહાટી મોદાત કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","તોવે ગુલામી-છુટકા લોકહાય કોલહાક માટડાહાન સ્તેફનુસા બારામાય જુઠા બોલાહાટી ઉસરાવ્યા, “આમહાય યાલ મૂસા એને પોરમેહેરા વિરુદમાય નિંદા વાતો કોઅતા વોનાયાહા.” ");
INSERT INTO gbl_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ચ્યાહાય સ્તેફનુસા વિરુદ લોક વડીલ, એને મૂસા નિયમ હિકાડનારા ગુરુહુલ ઉસરાવ્યા એને ચ્યાહાય યેયન સ્તેફનુસાલ દોઅયો એને મોઠી સોબાયે હામ્મે લેય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","એને જુઠા સાક્ષીદાર ઉબા કોઅયા, જ્યાહાય આખ્યાં, “ઈ માઅહું યા પવિત્ર દેવાળા એને મૂસા નિયમાહા વિરુદ નિંદા કોરાહાટી નાંય છોડે. ");
INSERT INTO gbl_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","કાહાકા આમહાય ચ્યાલ એહેકોય આખતો વોનાયા, કા ઓજ નાજરેત ગાવામાઅને ઈસુ દેવાળાલ પાડી ટાકી, એને ચ્યે રીતીહીન બોદલી ટાકી જ્યો મૂસાય આપહાન હોઅપલ્યો હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","તોવે બોદા લોકહાય જ્યા મોઠી સોબાયેમાય બોઠલા આતા, ચ્યાએછે યોકદીઠ એઇન ચ્યા મુંય હોરગા દૂતા રોકા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","તોવે મહાયાજકાય પુછ્યાં, “કાય યો વાતો હાચ્યો હેય?” ");
INSERT INTO gbl_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","સ્તેફનુસે આખ્યાં, ઓ બાહાહાય, એને ડાયહાય વોનાયા, આપહે આગલ્યો ડાયો આબ્રાહામ હારાન શેહેરામાય વોહતી કોઅરા પેલ્લા, જોવે તો મેસોપોટેમિયા વિસ્તારમાય આતો, તો મહિમામય પોરમેહેરે ચ્યાલ દર્શન દેના. ");
INSERT INTO gbl_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","એને ચ્યાલ આખ્યાં, તું તો દેશ એને તો કુટુંબમાઅને નિંગીન ચ્યા દેશામાય જો, જ્યાલ આંય તુલ દેખાડીહી. ");
INSERT INTO gbl_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","તોવે ચ્યાય મેસોપોટેમિયા વિસ્તાર માઅને નિંગીન હારાન શેહેરામાય જાયને વોહતી કોઅયી, એને ચ્યા આબહા મોરણા પાછે પોરમેહેરાય ચ્યાલ તાઅને યા દેશામાય લેય યેયન વોહતી કોઆડયો, જ્યામાય આમી આપા રોતહા, ");
INSERT INTO gbl_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","બાકી પોરમેહેરે ચ્યાલ કાયજ ભાગ નાંય દેનો, ઓલેલુગું કા પાગ થોવે ઓલહો જાગો બી નાંય દેનો, બાકી ઓ વાયદો કોઅયો કા, “આંય ઓ દેશ તુલ એને તો પાછે તો પીડીલ દેય દિહી.” એને ચ્યે સમયે ચ્યા કાદો પોહોબી નાંય આતો. ");
INSERT INTO gbl_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","એને પોરમેહેરે એહેકેનબી આખ્યાં, તો પિડયે લોક પારકા દેશા પરદેશા ઓઅરી, એને ચ્યા લોક ચ્યાહાન ગુલામ બોનાવી લી એને ચાર હોવ વોરહે લોગુ ચ્યાહાઆરે ખારાબ વ્યવહાર કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","પાછી પોરમેહેરે આખ્યાં, જ્યેં જાતી ચ્યે ગુલામ બોની, ચ્યાહાન આંય ડોંડ દિહી, ચ્યા પાછે ચ્યે ચ્યા દેશામાઅને બાઆ યેયન યા જાગાવોય મા ભક્તિ કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","એને પોરમેહેરે આબ્રાહામાઆરે કરાર કોઅયો એને ચ્યાલ આખ્યાં કા, “તો કુટુંબા બોદા માટડાહા કરારા ચિન્હા રુપામાય સુન્નત કોઆડ,” સુન્નતા નિયમ દેયના યોકા વોરહા પાછે, ઈસાકા જન્મો જાયો, એને આઠવે દિહી ચ્યા સુન્નત કોઅયા, ઈસાકે ચ્યા પોહા યાકૂબા સુન્નત કોઅયા એને યાકૂબે ચ્યા બારા પોહહા સુન્નત કોઅયા. જ્યા આમહે આગલ્યાડાયા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","એને યાકૂબા પોહાહાય યોસેફા આરે ઈર્ષ્યા કોઇન ચ્યાલ મિસર દેશામાય જાનારાહાલ ગુલામા રુપામાય વેચી દેનો, બાકી પોરમેહેર ચ્યાઆરે આતો. ");
INSERT INTO gbl_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","એને પોરમેહેરે યોસેફાલ બોદી તકલીફ માઅને બોચાડીન મિસર દેશા રાજા ફારુના આગલા મોયા એને બુદ્દિ દેની, ફારુન રાજાય યોસેફાલ મિસર દેશાવોય એને ચ્યા બોદા મેહેલાવોય પ્રધાન બોનાડયો. ");
INSERT INTO gbl_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","જોવે યોસેફ પ્રધાન આતો, તોવે કા બોદા મિસર દેશામાય એને કનાન દેશામાય ઓલો મોઠો દુકાળ પોડયો, જ્યાકોય બોજ તકલીફ પોડી, એને આપહે આગલ્યા ડાયહાન ખાઅના નાંય મિળતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","બાકી યાકૂબાય ઈ વોનાયને, કા મિસર દેશામાય અનાજ હેય, આપહે આગલ્યાડાયા જાય એને તાઅને અનાજ વેચાતાં લેય, ચ્યા યોસેફાલ મિળ્યાં એને અનાજ વેચાતાં લેદા, બાકી ચ્યાહાય ચ્યાલ નાંય વોળખ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","બીજેદા, જોવે ચ્યા અનાજ લા ગીયા, તોવે યોસેફાય પોતા બાહહાન વોળખાણ દેખાડી એને ફારુન રાજાલ બી યોસેફા જાત ખોબાર પોડી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","તોવે યોસેફે ચ્યા આબહા યાકૂબાલ એને ચ્યા બોદા કુટુંબાલ, જ્યેં પંચોતર માઅહે આતેં, મિસર દેશામાય યાહાટી સંદેશ દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","તોવે યાકૂબ મિસર દેશામાય ગીયો, એને કોલહાક સમાયા પાછે યાકૂબ એને આપહે આગલ્યાડાયા મોઅઇ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ચ્યાહાય યાકૂબ એને ચ્યાહા પોહહા મોઅલા શરીર મિસર દેશામાઅને આપહે દેશ કનાના શેખેમ શેહેરામાય લી યેના, એને ચ્યાહાય યાકૂબા મોઅલા શરીર ચ્યે કોબાર માય દાટ્યા, જ્યાલ આબ્રાહામાય વેચાતાં લેદેલ, એને ચ્યાહાય યાકૂબા પોહાહા મોઅલા શરીર શેખેમ શેહેરા ચ્યે જમીનમાય દાટ્યા, જીં યાકૂબાય હમોરા પોહહા વોઅને વેચાતાં લેદેલ. ");
INSERT INTO gbl_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","બાકી જોવે તો વાયદો પુરો ઓઅના સમય પાહે યેનો, જો પોરમેહેરે આબ્રાહામાઆરે કોઅલો આતો, તોવે મિસરમાય ચ્યા લોક વોદતા લાગ્યા, એને બોજ ઓઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","તોવે મિસર દેશામાય બિજો નોવો રાજા જાયો, તો યોસેફાલ નાંય વોળાખતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ચ્યાય આપહે જાતી આરે ચાલાકી કોઇન આપહે વાડ-વડીલાહાઆરે ઓલે લોગુ ખારાબ વ્યવહાર કોઅયો, કા આયહે-આબહાલ નોવા જોન્મુલા પોહહાન ટાકી દાં પોડ્યા જ્યેથી ચ્યે મોઅઇ જાય. ");
INSERT INTO gbl_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ચ્યે સમયે મૂસા જન્મો જાયો, એને તો પોરમેહેરા નોજારેમાય બોજ હારો આતો; એને તીન મોયના લોગુ ચ્યા આયહે-આબહાય ગુપ્તરુપમાય દેખભાલ કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","બાકી જોવે ચ્યે ચ્યાલ દુબાડી નાંય હોક્યે, તે ચ્યાહાય ચ્યાલ ગોઆ બાઆ થોવી દેનો, તોવે ફારુના પોહયેય ચ્યાલ દત્તાક લેદો, ચ્યે ચ્યા પાલનપોષણ પોતે પોહા રોકા કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","એને મૂસાલ મિસરીયાહા બોદી વિદ્યા હિકાડી, એને તો વાત એને કામ કોઆ સામર્થ્ય શાલી બોની ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","જોવે મૂસા ચાળહી વોરહા જાયો, તોવે ચ્યાય ઈસરાયેલી બાહહાન મિળાં વિચાર કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","તાં ચ્યાય યોક મિસરી માઅહાકોય યોકા ઈસરાયેલી માઅહાવોય અન્યાય ઓઅતા દેખ્યો, ચ્યાલ બોચાડયો, એને મિસરી માઅહાલ માંઈને ચ્યા બોદલો લેદો. ");
INSERT INTO gbl_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","મૂસાય વિચાર કોઅયો, કા ચ્યા જાતવાળે હોમજી કા પોરમેહેર ચ્યા આથાકોય ચ્યાહાલ ગુલામીમાઅને સોડવી, બાકી ચ્યાહાય નાંય હોમજ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","બીજે દિહી જોવે ઈસરાયેલી ચ્યાહામાયજ લોડી રિઅલો આતો, તોવે તો તાં જાય પોઅચ્યો, એને ઈ આખીન ચ્યાહાન હોમજી જાંહાટી હોમજાડ્યા, કા ઓ બાહાહાય, તુમા તે બાહા-બાહા હેય, યોકા બિજાવોય કાહા અન્યાય કોઅતાહા? ");
INSERT INTO gbl_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","બાકી જો ચ્યા પડોશીવોય અન્યાય કોઇ રિઅલો આતો, ચ્યાય ઈ આખીન ધોક્કો દેનો, તુલ કુંયે આમહાવોય પ્રધાન એને ન્યાય કોઅનારો ઠોરવ્યોહો? ");
INSERT INTO gbl_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","કાય જેહેકેન તુયે કાલે મિસરી માઅહાલ માઆઇ ટાક્યો તેહેકેન માન બી માઆઇ ટાકાં માગતોહો કા? ");
INSERT INTO gbl_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ઈ વાત વોનાઈન મૂસા ગાબરાય ગીયો એને તો મિસર દેશ છોડીન નાહી પોડયો, એને મિદ્યાન દેશામાય પારદેશી બોનીન રા લાગ્યો, એને તાં ચ્યા બેન પાહહા જન્મો જાયો. ");
INSERT INTO gbl_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","મિદ્યાન દેશામાય મૂસા ચાળહી વોરહે રિયો તોવે, યોક હોરગા દૂતાય સીનાય ડોગા ઉજાડ જાગામાય ચ્યાલ બોળતા જેખરાહા માજે દર્શન દેના. ");
INSERT INTO gbl_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","જોવે મૂસાય બોળતા જાડાલ દેખ્યા જીં ભસ્મ નાંય ઓઈ રીઅલા આતા, તે મૂસાલ નોવાય લાગી. એને તી એરાહાટી તો પાહાય જાતો લાગ્યો, તોલાહામાય તો પ્રભુ આવાજ વોનાયો. ");
INSERT INTO gbl_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“આંય તો આગલ્યા ડાયાહા પોરમેહેર, આબ્રાહામા પોરમેહેર, ઈસાકા એને યાકૂબા પોરમેહેર હેતાંવ.” તોવે મૂસા ગાબરાયને કાપતો લાગ્યો, ઓલે લોગુ કા ચ્યાલ એઅના ઈંમાત નાંય જાયી. ");
INSERT INTO gbl_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","તોવે પ્રભુય ચ્યાલ આખ્યાં, મા પ્રતિ આદર દેખાડાં હાટી તો પાગહા માઅને વાઅણે કાડી લે, કાહાકા તું જાં ઉબો હેય, તો જાગો પવિત્ર હેય. ");
INSERT INTO gbl_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","માયે હાચ્ચાંજ મા લોકહા ખારાબ દશા જ્યા મિસર દેશામાય હેય, દેખહી, ચ્યાહા હુંઅકા એને ચ્યાહા રોડના માયે વોનાય લેદલા હેય, યાહાટી ચ્યાહાન બોચાવાં હાટી આંય ઉતી યેનહો, આમી યે, આંય તુલ મિસર દેશામાય દોવાડુહુ. ");
INSERT INTO gbl_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","ઓ તોજ મૂસા હેય જ્યાલ ઈસરાયેલ્યાહાય નાકાર કોઇ દેનલો આતો, એને જ્યાહાય આખલા આતા, તુલ કુંયે આમહે પ્રધાન એને ન્યાય કોઅનારો બોનાડયોહો? ઓ તોજ હેય જ્યાલ પોરમેહેરાય ચ્યા હોરગા દૂતાકોય, જો ચ્યાહાટી જાડયેમાય પ્રગટ ઓઅલો આતો, શાસક એને તારણ દેનારો ઓઅરાહાટી દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ઈ માઅહું મિસર દેશ એને લાલ દોરિયામાય એને ઉજાડ જાગામાય ચાળહી વોરહે લોગુ અદભુત કામ એને ચિન્હ દેખાડી-દેખાડી ચ્યાહાન કાડી લેય યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ઓ તોજ મૂસા હેય, જ્યાંય ઈસરાયેલી લોકહાન આખ્યાં, પોરમેહેર તુમહે બાહાહા માઅને તુમહેહાટી મા રોકો યોક ભવિષ્યવક્તા ઉબો કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ઓજ મૂસા યોક ભવિષ્યવક્તા રુપામાય આપહે આગલ્યા ડાયહા આરે આતો જોવે ચ્યે ઉજાડ જાગામાય હોરગા દૂતા આરે યોકહાતે બેગે આતેં, તાં સીનાય ડોગાવોય મૂસાલ જીવન દેનારા વચન મિળ્યાં એને ચ્યાય આપહે લોગુ પોઅચાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","બાકી આપહે આગલ્યા ડાયહાય ચ્યાલ નાંય માન્યા, બાકી ચ્યાલ ઠકરાવીન ચ્યાહા મોનાકોય મિસર દેશામાય પાછા ફિરી જાં માગતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","એને મૂસા બાહા હારૂનાલ આખ્યાં, આમહેહાટી ઓહડી દેવતા બોનાડ, જીં મિસર દેશ માય પાછા ફિરી જાંહાટી આમહે આગલા-આગલા ચાલે, કાહાકા આમા નાંય જાંઆજે કા ચ્યા મૂસા કાય જાયા, જો આમહાન મિસર દેશામાઅને છોડાવીન લેય યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","એને ચ્યે સમયે ચ્યાહાય યોક વાછડા મુર્તિ બોનાવી, એને તી મુર્તિલ બલિદાન ચોડાવ્યા, એને ચ્યાહા આથા કામહાકોય ખુશ ઓઅરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","યાહાટી પોરમેહેરે ચ્યાહાન આકાશામાઅને દિહી, ચાંદ એને ચાંદાલાહાન દેવતાહા રુપામાય ભક્તિ કોઅરાહાટી છોડી દેના. જેહેકેન ભવિષ્યવક્તાહા ચોપડયેમાય પોરમેહેરાય આખ્યાં, “ઓ ઈસરાયેલી લોકહાય, તુમા ઉજાડ જાગામાય ચાળહી વોરહા લોગુ માન જોનાવરહા બલિદાન એને અન્નબલી નાંય ચોડવ્યા બાકી તુમહાય ચ્યાહાન બિજા દેવતાહાન ચોડવ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","તુમહાય ચ્યા માંડવાલ બોનાડયો જ્યામાય મોલોક દેવતા મુર્તિ એને રીફાન દેવતા તારા ચિત્ર આતા, તી મુર્તિહિલ તુમહાય ભક્તિ કોઅરાહાટી બોનાડયો, યાહાટી આંય તુમહાન બાબેલ દેશામાય લેય જાયને થોવહી.” ");
INSERT INTO gbl_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","સાક્ષી માંડવો ઉજાડ જાગામાય આપહે આગલ્યા ડાયહા વોચમાય આતો, જેહેકેન પોરમેહેરે ઠોરવ્યો, જ્યાંય મૂસાલ આખ્યેલ, જો માપ તુયે દેખલો હેય, ચ્યાનુસાર યાલ બોનાડ. ");
INSERT INTO gbl_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","બોજ વોરહા પાછે તો માંડવો આપહે આગલ્યા ડાયહાય ચ્યાલ મીળવીન યહોશુવા આરે ઈહીં લેય યેના, જ્યેં સમયે કા ચ્યાહાય ચ્યા ગેર યહૂદીયાવોય ઓદિકાર મેળાવ્યો, જ્યાહાલ પોરમેહેરાય આપહે આગલ્યા ડાયહા હામ્મેને કાડી દેના, એને તો માંડવો દાઉદ રાજા સોમાયા લોગુ રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","દાઉદ રાજાવોય પોરમેહેરાય સદા મોયા કોઅયી, એને દાઉદ રાજાય યાકૂબા પોરમેહેરાહાટી રોઅના માંડવો બોનાડા વિનાંતી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","બાકી ચ્યા પોહો સુલેમાને ચ્યાહાટી યોક દેવાળા બોનાવ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","બાકી પરમપ્રધાન પોરમેહેર આથહા કોઇન બાંદલા દેવાળામાય નાંય રોય, જેહેકેન યશાયા ભવિષ્યવક્તા ચોપડીમાય લોખલાં હેય. ");
INSERT INTO gbl_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","પોરમેહેર આખહે, હોરગા મા રાજગાદી એને દોરતી મા પાગ થોવના જાગો હેય, મા હાટી તુમા કોહોડે રીતે દેવાળા બોનાડાહા? એને મા આરામ કોઅના કોઅહો જાગો રોય? ");
INSERT INTO gbl_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","કાહાકા માયે પોતે હોરગા એને દોરતી બેની જાગામાય બોદા કાય બોનાડલા હેય. ");
INSERT INTO gbl_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ઓ કોઠણ લોકહાય, તુમા ચ્યા વાત માના એને વોનાયા નાકાર કોઅતાહા, તુમા કાયામ પવિત્ર આત્મા વિરુદ કોઅતાહા, જેહેકેન તુમહે આગલ્યાડાયા કોઅતા આતા, તેહેકેન તુમાબી કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","તુમહે આગલ્યા ડાયહાય બોદા ભવિષ્યવક્તાહા આરે ખારાબ કોઅયા જ્યાહાલ પોરમેહેરાય દોવાડલા આતા, ચ્યાહાય ચ્યા ભવિષ્યવક્તાહાલ માઆઇ ટાક્યા જ્યાહાન ખ્રિસ્ત જો ન્યાયી હેય ચ્યા યેયના ભવિષ્યવાણી કોઅયેલ, એને આમી તુમા ચ્યાલ દોઅનારા એને માઆઇ ટાકનારા બોન્યા. ");
INSERT INTO gbl_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","તુમહાન હોરગા દૂતહાકોય પોરમેહેરા નિયમ મિળ્યાં, તેરુંબી તુમહાય ચ્યા પાલન નાંય કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","યો વાતો વોનાઈન યહૂદી આગેવાન બોજ ખિજવાય ગીયા એને સ્તેફનુસાવોય દાત કોકડાવા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","બાકી ચ્યાય પવિત્ર આત્માકોય બોઆયને હોરગા એછે એઅયા, એને ચ્યે પોરમેહેરા મહિમા એને ઈસુવાલ પોરમેહેરા જમણા આથા એછે સન્માના જાગાવોય ઉબો રિઅલો દેખ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","એને આખ્યાં, “એઆ, આંય હોરગાલ ઉગડી ગીઅલાં, એને માઅહા પોહાલ પોરમેહેરા જમણા આથા એછે સન્માના જાગાવોય ઉબો રિઅલો એઅતાહાવ.” ");
INSERT INTO gbl_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","તોવે ચ્યાહાય મોઠેરે બોંબલીન કાન ડુકી લેદા, એને યોખઠા ઓઇન ચ્યાવોય ટુટી પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","એને ચ્યાલ યેરૂસાલેમ શેહેરા બાઆ લેય જાયને દોગડાટા લાગ્યા, યે સમયે જ્યાહાય સ્તેફનુસાવોય દોષ લાવલો આતો ચ્યાહાય ચ્યાહા ઉપર્યે ડોગલેં શાઉલ નાંવા યોક જુવાન્યાપાય થોવી દેને, કા તો ચ્યાહા રાખવાળી કોએ. ");
INSERT INTO gbl_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","એને ચ્યે સ્તેફનુસાલ દોગડાટતે રિયે, એને તો ઈ આખીન પ્રાર્થના કોઅતો રિયો, “ઓ પ્રભુ ઈસુ, મા આત્માલ સ્વીકાર કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","પાછે માંડયે પોડીન મોઠેરે બોંબલ્યો, “ઓ પ્રભુ, યા પાપાહાટી તું ચ્યાહાન માફ કોઇ દે.” એહેકોય આખીન તો મોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","શાઉલ પુરીરીતે સ્તેફનુસા મોરણા સહમત આતો. ચ્યેજ દિહી યેરૂસાલેમ શેહેરા મંડળીવોય મોઠી સતાવણી શુરવાત જાયી એને પ્રેષિત છોડીન બિજા બોદા ને બોદા યહૂદીયા વિસ્તાર એને સમરૂન ભાગામાય વિખરાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","એને કોલહાક પોરમેહેરા આદર કોઅનારા માટડાહાંય સ્તેફનુસાલ કોબારેમાય દાટ્યો, એને ચ્યાહાટી તે બોજ શોક કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","બાકી શાઉલ મંડળીલ સતાવતો આતો, એને ગોઅહે-ગોઅહે જાયને વિસ્વાસી માટડાહાલ એને થેઅયેહેલ ગોહલી-ગોહલી જેલેમાય કોંડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","બાકી જ્યા વિસ્વાસી વિખરાય ગીઅલા આતા, ચ્યા હારી ખોબાર આખતા ફિર્યા. ");
INSERT INTO gbl_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ફિલિપ નાંવા યોક વિસ્વાસી યેરૂસાલેમ શેહેરામાઅને એને સમરૂન ભાગા યોકા શેહેરામાય જાયને લોકહાન ખ્રિસ્તા હારી ખોબારે પ્રચાર કોઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","જ્યો વાતો ફિલિપે આખ્યો ચ્યો લોકહાય વોનાયને એને જ્યા ચમત્કાર તો દેખાડતો આતો ચ્યા એઇન, યોક જીવ ઓઇન મોન લાવ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","કાહાકા જોવે ફિલીપાય હુકુમ કોઅયો તોવે બોજ જાંઅહા માઅને બુતા આત્મે મોઠેરે બોંબલીન નિંગી ગીયા, એને બોજ લખવા બિમારી એને લેંગડે બી હારેં કોઅલે ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","એને ચ્યા શેહેરા બોજ લોક બોજ ખુશ જાયા. ");
INSERT INTO gbl_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ચ્યા શેહેરામાય સિમોન નાંવા યોક માઅહું આતા, જો જાદુગારી કોઇન સમરૂન માઅને લોકહા બોજ નોવાય કોઅતો આતો એને પોતાલ યોક મોઠો માટડો આખાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","એને બોદા વાહનાહા પાયને તે મોઠહા લોગુ ચ્યા ઈજ્જત કોઇન આખતે આતેં, “ઈ માઅહું ઈશ્વરા તી શક્તિ હેય, જીં મહાશક્તિ આખાયેહે.” ");
INSERT INTO gbl_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ચ્યેય બોજ દિહહાથી ચ્યાહાન ચ્યા જાદુગારી કામહાકોય નોવાય પામાડી દેનલે આતેં, યાહાટી લોક ચ્યાલ બોજ માનેત. ");
INSERT INTO gbl_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","બાકી જોવે લોકહાય પોરમેહેરા રાજ્યા એને ઈસુ ખ્રિસ્તા નાંવા હારી ખોબારેવોય ફિલિપા સંદેશ વોનાયને બોરહો કોઅયો, તોવે બોદે થેઅયો એને માટડાહાંય બાપતિસ્મા લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","તોવે સિમોનાય પોતેબી ફિલિપા સંદેશાવોય બોરહો કોઅયો એને બાપતિસ્મા લેઈને ફિલિપા આરે રા લાગ્યા, તો ચિન્હ એને મોઠે-મોઠે સામર્થ્યા કામે ઓઅતા દેખીન નોવાય પામતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","જોવે પ્રેષિત યેરૂસાલેમ શેહેરમાય ઈ વોનાયા, સમરૂન માઅને લોકહાય પોરમેહેરા વચન માની લેદહા તોવે પિત્તરાલ એને યોહાનાલ ચ્યાહાપાય દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ચ્યાહાય તાં જાયને ચ્યાહાટી પ્રાર્થના કોઅયી કા ચ્યા પવિત્ર આત્મા મેળવી લેય. ");
INSERT INTO gbl_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","કાહાકા પવિત્ર આત્મા આમી લોગુ ચ્યાહામાઅને કાદાવોય નાંય યેનેલ, કાહાકા ચ્યાહાય તે પ્રભુ ઈસુ નાવામાય બાપતિસ્મા લેદલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","તોવે પિત્તર એને યોહાને ચ્યાહાવોય આથ થોવ્યા એને ચ્યાહાલ પવિત્ર આત્મા મિળ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","જોવે સિમોનાય દેખ્યાં કા પ્રેષિતાહા આથ થોવવાથી પવિત્ર આત્મા દેનલા જાહે, તોવે ચ્યાય પોયહા લેય યેયન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ઈ શક્તિ માન બી દા, કા આંય કાદાવોય આથ થોવુ, તો પવિત્ર આત્મા પામે.” ");
INSERT INTO gbl_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","પિત્તરે સિમોનાલ આખ્યાં, “તું એને તો પોયહા નાશ ઓઈ જાય, કાહાકા તુયે પોરમેહેરા દાન પોયહાકોય વેચાતાં લેયના વિચાર કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","યે સેવાયેમાય નાંય તો હિસ્સો હેય, નાંય તો ભાગ હેય, કાહાકા તો મોન પોરમેહેરા આગલા હાચ્ચાં નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","યાહાટી તું પાપ કોઅના બંદ કોઇન પ્રભુલ પ્રાર્થના કોઓ, ઓઈ હોકહે પોરમેહેર તો ખારાબ વિચારાહાલ માફ કોઇ દેય. ");
INSERT INTO gbl_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","તું ખારાબ વિચારાહા પાઅને ફિર, કાહાકા આંય એઅતાહાવ, કા તું પિત્ત હારકો માણો એને પાપા ગુલામીમાય હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","સિમોનાય જોવાબ દેના, “તુમા માયેહાટી પ્રભુ પાય પ્રાર્થના કોઆ કા જીં વાત તુયે આખી, ચ્યેહેમાઅને કોઅહિબી માયેવોય નાંય યી પોડે.” ");
INSERT INTO gbl_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","તોવે પિત્તર એને યોહાનાય સાક્ષી દેયન એને પ્રભુ ઈસુ વચન આખીન યેરૂસાલેમ શેહેરમાય પાછા ફિરતા સમયે ચ્યા સમરૂન ભાગા બોજ ગાવહામાય હારી ખોબારે પ્રચાર કોઅતા ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","પાછે પ્રભુ યોક હોરગા દૂતાય યેયન ફિલિપાલ આખ્યાં, “ઉઠ એને દક્ષીણ એછે ચ્યે વાટેવોય જો, જીં વાટ યેરૂસાલેમ શેહેરાઇહીને ગાજા શેહેરા એછે જાહે” ઈ રેઅટાવાળી વાટ હેય. ");
INSERT INTO gbl_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","તો ઉઠીન ગીયો, એને અચાનક ઈથોપિયા દેશા યોક માઅહું ચ્યાલ મિળ્યો, જો યોક નપુસક આતો, તો યોક મહત્વપૂર્ણ ઓદિકારી આતો જો ઈથોપિયા દેશા રાણી બોદા ખજાના દેખભાલ કોઅતો આતો, એને ભક્તિ કોઅરાહાટી યેરૂસાલેમ શેહેરમાય યેનલો. ");
INSERT INTO gbl_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","તો ચ્યા રથા વોય બોહીન ચ્યા દેશાલ પાછો જાય રિઅલો આતો, એને તો યશાયા ભવિષ્યવક્તા ચોપડી જોર-જોરમાય વાચતો જાય રિઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","તોવે પવિત્ર આત્માય ફિલિપાલ આખ્યાં, “પાહાય જાયને યા રથાહાતે ચાલા લાગ.” ");
INSERT INTO gbl_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ફિલિપ દાંહદીન રથાપાય જાય પોઅચ્યો એને ચ્યાલ યશાયા ભવિષ્યવક્તા ચોપડી વાચતો વોનાયો, એને પુછ્યાં, “તું જીં વાચતહો કાય ચ્યાલ હુમાજતહો બી?” ");
INSERT INTO gbl_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ચ્યેય આખ્યાં, “જાવ લોગુ કાદો માન નાંય હુમજાડે તાંવ આંય કેહેકેન હોમજુ?” એને ચ્યેય ફિલિપાલ વિનાંતી કોઅયી, કા રથવોય ચોડીન ચ્યાપાય બોહે, એને ફિલિપ તાં ચોડીન બોહી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","એને પવિત્રશાસ્ત્ર માઅને જો અધ્યાય તો વાચતો આતો, તો ઓ આતો; “તો ગેટા રોકો વદ કોઅરા ચ્યાલ લેય ગીયા, એને જેહેકેન ગેટા બુરાં કાતારનારાહા હામ્મે ઠાવકા રોહે, તેહેકેન તોબી ઠાવકોજ રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ચ્યા નિંદા કોઅયી એને ચ્યાલ ન્યાય નાંય મિળ્યો, કોદાચ કાદોબી ચ્યા વંશા બારામાય આખી નાંય હોકે, કાહાકા ચ્યા વંશ ઓઅરા પેલ્લા ચ્યાલ માઆઇ ટાક્યો.” ");
INSERT INTO gbl_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","યાહાટી નપુસકાય ફિલિપાલ પુછ્યાં, “આંય તુલ વિનાંતી કોઅતાહાંવ, ઈ આખ કા ભવિષ્યવક્તા ઈ કા બારામાય આખહે, પોતા બારામાય કા બિજા કાદા બારામાય?” ");
INSERT INTO gbl_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","તોવે ફિલિપે બોલના સુરુ કોઅયા, એને યાજ પવિત્રશાસ્ત્રા માઅને સુરુ કોઇન ચ્યાલ ઈસુવા હારી ખોબારે બારામાય આખ્યાં, યાહાટી તો ઓદિકારી હોમજી ગીયો એને ઈસુવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","વાટે ચાલતા-ચાલતા ચ્યા યોકા તોળાવા પાહી પોઅચ્યા, તોવે નપુસકે આખ્યાં કા, “દેખ ઈહીં તોળાવા હેય, આમી માન બાપતિસ્મા લેયના કાય વાંદો હેય” ");
INSERT INTO gbl_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ફિલિપે આખ્યાં, “જોવે તું પુરાં મોનાકોય બોરહો કોઅતોહો તે લેય હોકતોહો” ચ્યાય જોવાબ દેનો, “આંય બોરહો કોઅતાહાંવ કા ઈસુ ખ્રિસ્ત પોરમેહેરા પોહો હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","તોવે ચ્યેય રથ ઉબો કોઆ આગના કોઅયી, ફિલિપ એને નપુસક બેની જાંઆ તોળાવામાય ઉતી પોડ્યા, એને ફિલિપે નપુસકાલ બાપતિસ્મા દેના. ");
INSERT INTO gbl_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","જોવે ચ્યા તોળાવામાઅને બાઆ યેના, તોવે પ્રભુ આત્મા ફિલિપાલ ઉઠાવી લેય ગીયો, એને નપુસકે ચ્યાલ પાછો નાંય દેખ્યો, એને નપુસકાલ પોરમેહેરાય બોચાવી લેદો યાહાટી આનંદ કોઅતો તો ચ્યા દેશામાય પાછો જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","બાકી ફિલિપ અશદોદ શેહેરમાય યેનો, એને તો યોકે જાગેને બીજે જાગે ચ્યા મુસાફરી કોઅતો રિયો એને કૈસરીયા શેહેરામાય પોઅચ્યો તાંવ લોગુ બોદા શેહેરાહામાય હારી ખોબારે પ્રચાર કોઅતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","શાઉલ જો આમી લોગુ પ્રભુ ઈસુવા શિષ્યહાન દોમકાડતો ને માઆઇ ટાકના વિચારા માય આતો, મહાયાજકાપાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","એને ચ્યાપાઅને દમસ્ક શેહેરા સોબાયે ઠિકાણા નાવાવોય મંજુર્યે કાગળાં માગ્યાં, કા જ્યા માટડા કા થેઅયો જ્યા પ્રભુ ઈસુ વાટે ચાલનારેં મીળે ચ્યાહાન બાંદિન યેરૂસાલેમ શેહેરમાય લેય યેય. ");
INSERT INTO gbl_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","બાકી જોવે શાઉલ એને ચ્યા હાંગાત્યા દમસ્ક શેહેરા પાહી પોઅચ્યા, તો અચાનક આકાશામાય ચારીચોમખી ઉજવાડો ચોમક્યો. ");
INSERT INTO gbl_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","તોવે તો દોરતીવોય પોડી ગીયો, એને પ્રભુ પોરમેહેરા આવાજ વોનાયો, “ઓ શાઉલ, ઓ શાઉલ તું માન કાહા સતાવી રોયહો?” ");
INSERT INTO gbl_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","શાઉલે પુછ્યાં, “ઓ પ્રભુ, તું કું હેય?” ચ્યેય આખ્યાં, “આંય ઈસુ હેય, જ્યાલ તું સતાવતોહો. ");
INSERT INTO gbl_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","બાકી આમી ઉઠીન શેહેરામાય જો, કાદો તુલ આખી દી કા તુલ કાય કોઅના હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","જ્યેં માઅહે ચ્યાઆરે આતેં, ચ્યે ઠાઅકે રોય ગીયે; કાહાકા આવાજ તો ચ્યે વનાતે આતેં, બાકી કાદાલ દેખાતા નાંય આતા. ");
INSERT INTO gbl_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","તોવે શાઉલ દોરત્યેવોયને ઉઠયો, એને જોવે ડોળા ઉગાડયા તોવે ચ્યાલ કાંઇજ દેખાયાં નાંય, એને ચ્ચે ચ્ચા આથાલ દોઇન દમસ્ક શેહેરામાય લેય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","એને તો તીન દિહી લોગુ દેખી નાંય હોક્યો, એને નાંય ખાદાં એને નાંય પિદાં. ");
INSERT INTO gbl_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","દમસ્ક શેહેરામાય હનાન્યા નાંવા યોક શિષ્ય આતો, ચ્યાલ પ્રભુ ઈસુય દર્શનામાય આખ્યાં, “ઓ હનાન્યા!” ચ્યાય આખ્યાં, “હાં, પ્રભુ” ");
INSERT INTO gbl_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","તોવે પ્રભુ ઈસુય ચ્યાલ આખ્યાં, “ઉઠીન સીધી નાંવા હેરીમાય જો, એને યહૂદા ગોઅમે શાઉલ નાંવા યોક તારસુસમાય રોનારાલ હોદ; કાહાકા તો પ્રાર્થના કોઇ રિઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","એને ચ્યાય હનાન્યા નાંવા યોક માઅહું માજે યેયન ચ્યાવોય આથ થોવતો દેખાયો; કા પાછો દેખતો ઓઈ જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","હનાન્યાય જોવાબ દેનો, “ઓ પ્રભુ, માયે યા માઅહા બારામાય બોજ જાંઅહા પાયને વનાયહો કા યાય યેરૂસાલેમ શેહેરામાય તો પવિત્ર લોકાહાઆરે મોઠયો-મોઠયો બુલો કોઅયોહો. ");
INSERT INTO gbl_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","એને ઈહીંબી ચ્યાલ મુખ્ય યાજકાહા પાયને ઓદિકાર મિળ્યહો કા જ્યા લોક તોવોય બોરહો કોઅતાહા, ચ્યા બોદહાલ યેરૂસાલેમ શેહેરામાય બાંદી લેય જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","બાકી પ્રભુ ઈસુય ચ્યાલ આખ્યાં, “તું જો; કાહાકા ઓ તે ગેર યહૂદી એને રાજહા, એને ઈસરાયેલહયા હામ્મે મા બારામાય પ્રચાર કોઅરાહાટી માયે ચ્યાલ મા સેવા કોઅરાહાટી નિવાડલો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","એને આંય ચ્યાલ આખહી, કા લોકહાન મા બારામાય આખના લીદે કાય-કાય દુઃખ ઉઠાવાં પોડી.” ");
INSERT INTO gbl_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","તોવે હનાન્યા ચ્યે ગોઅમે ગીયો, જાં શાઉલ આતો, એને ચ્યા ઉપે આથ થોવિન આખ્યાં, “ઓ બાહા શાઉલ, પ્રભુ ઈસુ, જો ચ્યે વાટેમાય, જ્યેવોઅને તું યેનો તુલ દેખાયો, ચ્યેય માન દોવાડલો હેય, કા તું પાછો એઇ હોકે એને પવિત્ર આત્માકોય બાઆય જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","એને તારાતુજ ચ્યા ડોળાહાઉપરે માછલા બિંગડાહા હારકે છાલટેં જેહે પોડયેં એને તો એઅરા લાગ્યો, એને ઉઠીન બાપતિસ્મા લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","પાછા ખાઅના ખાયન તાકાત મેળવી. તો કોલહાક દિહી દમસ્ક શેહેરા શિષ્યહાઆરે રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","એને તો તારાત દમસ્ક શેહેરા સોબાયે ઠિકાણે તો ઈસુવા પ્રચાર કોઅરા લાગ્યો કા ઈસુજ પોરમેહેરા પોહો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","એને બોદા વોનાનારા નોવાય પામીન આખા લાગ્યા, “કાય ઓ તોજ માઅહું નાંય હેય જો યેરૂસાલેમ શેહેરામાય જ્યા ઈસુવોય બોરહો કોએ ચ્યાહાન તો માઆઇ ટાકે, એને ઈહીંબી ચ્યા હાટીજ યેનલો આતો, કા ચ્યાહાન બાંદિન મુખ્ય યાજકાહાપાય લી જાય?” ");
INSERT INTO gbl_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","બાકી શાઉલાય આજુ વોદારે શક્તિશાળી રુપાકોય પ્રચાર કોઅના સુરુ કોઇ દેના, એને યે વાતે સાબિતી દેય-દેયને કા ઈસુ ઓજ ખ્રિસ્ત હેય, દમસ્ક શેહેરામાય રોનારા યહૂદીયાહા બોલના બંદ કોઅતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","જોવે શાઉલ દમસ્ક શેહેરામાય રોયન બોજ દિહી ઓઈ ગીયા, તોવે યહૂદીયાહાય મિળીન ચ્યાલ માઆઇ ટાકના યુક્તિ કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","બાકી ચ્યાહા યુક્તિ શાઉલાલ માલુમ પોડી ગીયી, ચ્યા તે ચ્યાલ માઆઇ ટાકાંહાટી રાત દિહી ફાટાકેહે પાય દોબી રોતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","બાકી યોક રાતી શિષ્યહાય ચ્યાલ ઉચે દિવાલ વોય લેય ગીયે, જીં શેહેરા ચોમખી આતી, તોવે ચ્યાહાય આસડાકોય યોક મોઠા ટોપલા બાંદિન ટોપલા કોય નિચે ઉતાડી દેનો, એહેકેન તો દમસ્ક શેહેરામાઅને બોચીન જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","શાઉલ યેરૂસાલેમ શેહેરામાય જાય પોઅચ્યો તોવે ચ્યેય શિષ્યહાઆરે મિળી જાઅના કોશિશ કોઅયી બાકી બોદા ય્યાલ બિઅતા આતા, કાહાકા ચ્યાહાન બોરહો નાંય ઓઅતો આતો, કા તોબી શિષ્ય બોની ગીયહો. ");
INSERT INTO gbl_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","બાકી બારનાબાસે ચ્યાલ પોતાના આરે પ્રેષિતાહા પાય લેય જાયને ચ્યાહાન આખ્યાં, કા યાય કેહેકેન દમસ્ક શેહેરા એછે જાયના વાટેમાય પ્રભુ ઈસુલ દેખ્યો, એને ઈસુવે ચ્ચાઆરે વાતો કોઅયો, પાછે ઈંમાત રાખીન કેહેકેન દમસ્ક શેહેરામાય ઈસુવા નાંવા પ્રચાર કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","પ્રેષિતાહાય બર્નાબાસાવોય બોરહો કોઅયો, યાહાટી શાઉલ યેરૂસાલેમ શેહેરામાય રોય ગીયો, ચ્યાહાઆરે યેરૂસાલેમ શેહેરામાય બોદે જાગે જાયને બિક વગર ઈસુ બારામાય પ્રચાર કોઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","એને બિક વોગાર પ્રભુ ઈસુ નાંવા પ્રચાર કોઅતો આતો; એને યુનાની ભાષા બોલનારાહાલ યહૂદીયાહા આરે વાતો કોઅતો આતો એને બોલાબોલી કોઅતો આતો; બાકી ચ્યા ચ્યાલ માઆઇ ટાકના યુક્તિ કોઅતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ઈ જાઇન વિસ્વાસી બાહા ચ્યાલ કૈસરીયા શેહેરામાય લેય યેના, એને જાહાજા માય ચ્યાલ તારસુસ દોવાડી દેનો જીં ચ્યા વોતની શેહેર આતા. ");
INSERT INTO gbl_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","યે પરમાણે બોદા યહૂદીયા વિસ્તાર, ગાલીલ ભાગ, એને સમરૂનમાય મંડળીહ્યેલ આરામ મિળ્યો, એને ચ્યેહે ઉન્નતી ઓઅતી ગીયી એને તી મંડળી પ્રભુ ઈસુ બિકમાય એને પવિત્ર આત્મા મોદાતેમાય ચાલતી એને બોજ લોક વિસ્વાસી બોની ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","પાછે એહેકેન જાયા કા પિત્તર બોદા વિસ્તારમાય બોદે જાગે ફિરતો રિયો, એને ચ્યા પવિત્ર લોકહાપાંય બી ગીયો જ્યા લુદ્દા શેહેરામાય રોતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","તાં ચ્યાલ એનિયાસ નાંવા લખવા રોગી માઅહું મિળ્યો, જો આઠ વોરહાથી ખાટલે પોડી રોઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","પિત્તરે ચ્યાલ આખ્યાં, “ઓ એનિયાસ! ઈસુ ખ્રિસ્ત તુલ હારો કોઅહે, ઉઠ, તો પાથારી લેય લે” તોવે તો તારાત ઉઠીન ઉબો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","એને લુદ્દા એને શારોન શેહેરા રોનારા બોજ લોક ચ્યાલ દેખીન પ્રભુ ઈસુવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","યાફા શેહેરામાય તબીથા નાંવા યોક વિસ્વાસી બાય આતી, યુનાની ભાષામાય ચ્યે નાંવ દરકાસ હેય, તબીથા એને દરકાસ યા બેની નાંવહા મતલબ “હરણી હેય”, તી બોજ હારેં-હારેં કામે એને મોદાત કોઅતી આતી. ");
INSERT INTO gbl_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","જોવે પિત્તર લુદ્દા શેહેરામાય આતો, ચ્યા દિહહામાય તી બિમાર પોડીન મોઅઇ ગિઇ, એને ચ્યાહાય ચ્યેલ આંગળાવીન ખોલીમાય થોવી દેનેલ. ");
INSERT INTO gbl_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","લુદ્દા શેહેર યાફા શેહેરા પાહે આતા, શિષ્યહાય ઈ વોનાઈન કા પિત્તર તાં હેય, બેન માઅહે દોવાડીન ચ્યાલ વિનાંતી કોઅયી, “જલદીથી જલદી આમાહાપાય યેય જો.” ");
INSERT INTO gbl_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","તોવે પિત્તર ઉઠીન ચ્યાહાઆરે ગીયો, એને જોવે તાં પોઅચ્યા, તોવે ચ્યે ચ્યાલ ખોલીમાય લેય ગીયા, એને બોદ્યો વિધવા બાયો રોડત્યોજ, ચ્યા પાહી યેયન ઉબ્યો રિયો, એને જો જબ્બો એને ફાડકે દરકાસ ચ્યેહેઆરે રોતી વોખાત બોનાવલે આતેં, ચ્યે દેખાડાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","તોવે પિત્તરે બોદહાલ બાઆ કાડી દેના, એને માંડયે પોડીન પ્રાર્થના કોઅયી, એને કુડયે એછે એઇન આખ્યાં, “ઓ તબીથા, ઉઠ” તોવે ચ્યેય ચ્યે ડોળા ઉગડાવ્યા, એને પિત્તરાલ દેખીન ઉઠી બોઠી. ");
INSERT INTO gbl_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ચ્યાય આથ દેયને ચ્યેલ ઉઠાડયા, એને વિસ્વાસી લોકહાન એને વિધવા બાયહેલ હાદિન ચ્યાહાન જીવતી દેખાડી દેની. ");
INSERT INTO gbl_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ઈ વાત બોદા યાફા શેહેરામાય ફેલાય ગીયી; એને બોજ લોકહાય પ્રભુ ઈસુ બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","એને પિત્તર યાફા શેહેરામાય સિમોન નાંવા ચામડા ધંદો કોઅનારા પાય બોજ દિહી રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","કૈસરીયા શેહેરામાય કરનેલીયુસ નાંવા યોક માઅહું આતો, જો ઈતાલીયા નાંવા સૈનિકા ટુકડી સુબેદાર આતો. ");
INSERT INTO gbl_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","તો એને ચ્યા બોદા ગોર્યા પોરમેહેરા ભક્તિ કોઅતા આતા, એને પોરમેહેરાલ બીઈન ચાલતો આતો, એને ગરીબ યહૂદી લોકહાન બોજ દાન દેતો આતો, એને પોરમેહેરાલ બરાબર પ્રાર્થના કોઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","યોક દિહી તીન વાગ્યા સમયે દર્શનામાય ચોખ્ખેરીતે દેખ્યાં કા પોરમેહેરા યોક હોરગા દૂત ચ્યા પાહાય યેયન આખ્યાં, “ઓ કરનેલીયુસ.” ");
INSERT INTO gbl_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","કરનેલીયુસાય હોરગા દૂતાલ આખ્યાં, “ઓ માલિક, કાય હેય?” ચ્યાય ચ્યાલ આખ્યાં, “તો પ્રાર્થના એને તો દાન યાદગીરીહાટી પોરમેહેરા હામ્મે પોઅચ્યાહા. ");
INSERT INTO gbl_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","એને આમી યાફા શેહેરામાય માઅહે દોવાડીન સિમોનાલ, જ્યાલ પિત્તર આખતાહા, ચ્યાલ હાદી લે. ");
INSERT INTO gbl_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","તો સિમોન, ચામડાહા ધંદો કોઅનારા પાય રોય રિયહો, જ્યા ગુઉ દોરિયા મેરે હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","જોવે તો હોરગા દૂત જ્યાંય ચ્યાઆરે વાતો કોઅયો તો ચાલ્યો ગીયો, તોવે ચ્યેય બેન ચાકાર, એને જ્યા ચ્યા પાહી રિયા કોઅતા આતા ચ્યાહામાઅને યોક પોરમેહેરા ભક્તિ કોઅનારા સીપાડાલ હાદ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","એને ચ્યાહાન બોદ્યોજ વાતો આખીન યાફા શેહેરામાય પિત્તરાલ લા દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","બીજે દિહી જોવે કરનેલીયુસા કોય દોવાડલા તીન માટડા ચાલતા-ચાલતા શેહેરા પાહી બોપરા સમયે પોઅચ્યા. ચ્યે સમયે પિત્તર ગોઆ દાબાવોય પ્રાર્થના કોઅરા ચોડયો. ");
INSERT INTO gbl_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ચ્યાલ બુખ લાગી એને કાય ખાઅના ઇચ્છા આતી, બાકી જોવે ચ્યા ખાઅના તિયારી કોઅતા આતા તોવે તો દર્શન એરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","એને ચ્યેય દેખ્યાં, આકાશ ઉગડી ગીયા; એને યોક મોઠા ચારસા હારકી વસ્તુ ચારી ખૂણહાથી નિચે ઉતાડલી જાય રીયહી. ");
INSERT INTO gbl_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","જ્યામાય દોરત્યેવોઅને બોદયે જાત્યે ચાર પાગાવાળે જોનાવારે એને દોરત્યેવોઅને બુકા થી હોપાલનારે જોનાવારે એને આકાશામાય ઉડનારે ચિડેં આતેં. જ્યાહા બારામાય મૂસા નિયમશાસ્ત્રામાય આખ્યાં કા ચ્યે અશુદ્ધ એને અપવિત્ર હેય, એને યહૂદી લોકહાન ખાંહાટી મોનાઈ હેય. ");
INSERT INTO gbl_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","એને ચ્યાલ યોક ઓહડો આવાજ વોનાયા યેનો, “ઓ પિત્તર ઉઠ, માંઈને ખો.” ");
INSERT INTO gbl_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","બાકી પિત્તરે આખ્યાં, “નાંય પ્રભુ, બિલકુલ નાંય; કાહાકા માયે કોદહીજ અપવિત્ર એને અશુદ્ધ વસ્તુ નાંય ખાદલી હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","પાછા બીજી વોખાતે ચ્યાલ આવાજ વોનાયા યેનો, “જીં કાય પોરમેહેરે શુદ્ધ કોઅયાહાં, ચ્યાલ તું અશુદ્ધ મા આખહે.” ");
INSERT INTO gbl_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","તીન વોખાત એહકોયજ જાયા; તોવે તારાત તી ચારસા આકાશ માય ઉઠાવી લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","જોવે પિત્તર ચ્યા પોતે મોનામાય બેન વિચારાહા માય આતો, કા યા દર્શના કાય મતલબ ઓઈ હોકહે, તોવે ચ્યે માઅહે જ્યાહાન કરનેલીયુસાય દોવાડલે આતેં, સિમોના ગોઆ ખોબાર કાડીન બાઅણા પાય યેય પોઅચ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","એને બોંબલીન પુછ્યાં, “કાય સિમોન જો પિત્તર આખાયેહે, તો ઈહીંજ ગાંવારો હેય કા?” ");
INSERT INTO gbl_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","પિત્તર તે ચ્યા દર્શના બારામાય વિચાર કોઅતો આતો, તોવે પવિત્ર આત્માય ચ્યાલ આખ્યાં, “એએ, તીન માઅહે તો હોદ કોઇ રીઅલે હેય. ");
INSERT INTO gbl_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ઉઠીન નિચે જો, ભલે ચ્યે ગેર યહૂદી હેય ચ્યાહાઆરે શંકા કોઅયા વોગાર જો, કાહાકા માયેંજ ચ્યાહાન દોવાડલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","તોવે પિત્તરાય નિચે ઉતીન ચ્યા માઅહાલ આખ્યાં, “એઆ, જ્યા હોદ તુમા કોઇ રીયહા, તો આંયજ હેતાંવ, તુમહે યેઅના કાય કારણ હેય?” ");
INSERT INTO gbl_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ચ્યાહાય આખ્યાં, “આમહાન હોવ સૈનિકાહા સુબેદાર કરનેલીયુસાય દોવાડયાહા, તો ન્યાયી એને બોરહો થોવનારો એને પોરમેહેરાલ બીઅનારો એને બોદી યહૂદી જાત્યે લોકહામાય હારાં માઅહું હેય, ચ્યેય યોક પવિત્ર હોરગા દૂત થી ઈ હોમજણ મેળવ્યા, કા તુલ પોતાના ગોઓ હાદિન તોપાઅને વચન વોનાયે.” ");
INSERT INTO gbl_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","તોવે ચ્યેય માજા હાદિન ચ્યાહાન રા જાગો દેનો. એને બીજે દિહે, તો ચ્યાહાઆરે ગીયો, એને યાફા શેહેરા વિસ્વાસી બાહાહા માઅને કોલહાક ચ્યાઆરે ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","બીજે દિહી ચ્યા કૈસરીયા શેહેર પોઅચ્યા, એને કરનેલીયુસ ચ્યા હોગવાડયાહાલ એને ચ્યા દોસ્તારાહાન યોકઠા કોઇન ચ્યા વાટ જોવતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","જોવે પિત્તર માજા યેય રિઅલો આતો, તોવે કરનેલીયુસ ચ્યાલ મિળ્યો, તે ચ્યા પાગે પોડીન નમસ્કાર કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","બાકી પિત્તરાય ચ્યાલ ઉઠાડીન આખ્યાં, “ઉબો રોય જો, આંયબી તે માઅહું હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","એને વાતો કોઅતો ચ્યાઆરે માજા ગીયો, એને બોજ લોકહાન યોકઠા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","તોવે પિત્તરે ચ્યાહાન આખ્યાં, “તુમા જાંઅતાહા કા ગેર યહૂદી લોકહાન મિળના એને ચ્યાહા ઈહીં જાયના આમે યહૂદી લોકહાહાટી યહૂદી નિયમા વિરુદ હેય, બાકી પોરમેહેરે માન આખ્યાં કા કાદા માઅહાલ અપવિત્ર એને અશુદ્ધ નાંય આખું. ");
INSERT INTO gbl_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","યાહાટી કા માન જોવે હાદ્યો તોવે કાયજ નાંય આખ્યાં વોગાર આમી આંય યેનો, આમી આંય પૂછતાહાવ કા માન કોઅહા કામાહાટી હાદલો હેય?” ");
INSERT INTO gbl_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","કરનેલીયુસાય પિત્તરાલ આખ્યાં, ચાર દિહી પેલ્લા, યેજ સમયે, આંય ગોઅમે બોપરેહે તીન વાગ્યે પ્રાર્થના કોઇ રિઅલો આતો, કા યોક માટડો ઉજળેં ફાડકે પોવીન, મા હામ્મે યેયન ઉબો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","એને આખ્યાં, “ઓ કરનેલીયુસ, તો પ્રાર્થના વોનાય લેદહી એને તો દાન પોરમેહેરે માન્ય કોઅવામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","યાહાટી યાફા શેહેરમાય માઅહે દોવાડીન સિમોનાલ જ્યાલ પિત્તર આખાયેહે, ચ્યાલ હાદિલે, તો દોરિયા મેરાવોય સિમોન જો, ચામડાહા ધંદો કોઅનારા ગોઅમે રોય રિઅલો હેય, જોવે તો યેઅરી, તોવે તો તુમહાન પોરમેહેરાઇહીને યોક સંદેશ આખી. ");
INSERT INTO gbl_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","તોવે માયે તારાત તોપાય માઅહે દોવાડયે, એને તુયે હારાં કોઅયા કા યેનો, આમી આમા બોદે ઈહીં પોરમેહેરા હામ્મે હેજે, કા જીં કાય પોરમેહેરે તુલ આખ્યાહા ચ્યાલ આખ.” ");
INSERT INTO gbl_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","તોવે પિત્તરે બોલના સુરુ કોઅયા, “આમી માન ખાત્રી જાયી, કા પોરમેહેર કાદાજ પક્ષપાત નાંય કોએ. ");
INSERT INTO gbl_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","બાકી બોદયે જાત્યેમાય જો પોરમેહેરા ભક્તિ કોઅહે એને યોગ્ય કામ કોઅહે, તો ચ્યાલ સ્વીકાર કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","તુમા ચ્યા સંદેશાલ જાંઅતેહે, પોરમેહેરાય આમહાન એટલે ઈસરાયેલી લોકહાન દોવાડયો, ચ્યાય શાંતી બારામાય હારી ખોબાર આખી, જીં લોકહાન ઈસુ ખ્રિસ્ત વોય બોરહો કોઅવાથી મિળી હોકહે, તો બોદહા પોરમેહેર હેય. ");
INSERT INTO gbl_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","તુમા ચ્યો મહાન ઘટના જાંઅતાહા, જીં યોહાન બાપતિસ્મા દેનારા બાપતિસ્મા પ્રચાર પાછે ગાલીલ ભાગાથી શુરવાત ઓઇન બોદા યહૂદીયા વિસ્તારમાય ફેલાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","પોરમેહેરે કેહેકેન નાજરેત ગાવા ઈસુલ પવિત્ર આત્માકોય એને સામર્થ્યાકોય અભિષેક કોઅયો, તો હારેં કામે કોઅતો એને ચ્યા બોદા લોકહાન જ્યા સૈતાનાકોય પીડાલા આતા, ચ્યાહાન હારાં કોઅતો ફિર્યો, કાહાકા પોરમેહેર ચ્યાઆરે આતો. ");
INSERT INTO gbl_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","એને આમા ચ્યા બોદા કામહા સાક્ષી હેજે, જીં ચ્યાય યહૂદી લોકહા બોદા વિસ્તારમાય એને યેરૂસાલેમ શેહેરામાયબી કોઅયે, એને યેરૂસાલેમ શેહેરામાય ચ્યાહાય ચ્યા ઈસુલ હુળીખાંબાવોય ટાંઅગીન માઆઇ ટાક્યો. ");
INSERT INTO gbl_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","બાકી ચ્યાલ પોરમેહેરે તીજે દિહી પાછો મોઅલા માઅને જીવતો કોઅયો, એને આમહાન પોતે દેખાડયાં. ");
INSERT INTO gbl_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","બોદા લોકહાય ચ્યાલ નાંય દેખ્યો, બાકી ચ્યાહાય આમહાન એટલે પ્રેષિતાહાન જ્યાહાન પોરમેહેરાય સુરુવાતપાઅને નિવડી લેદલા આતા, જ્યાહાય ચ્યા મોઅલા માઅને પાછો જીવતો ઓઅના પાછે ચ્યાઆરે ખાદાં એને પિદાં. ");
INSERT INTO gbl_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","એને ચ્યાય આમહાન આગના દેની કા બોદા લોકહામાય પ્રચાર કોઆ એને સાક્ષી દા, કા ઈસુ તોજ હેય જ્યાલ પોરમેહેરાય જીવતાહા એને મોઅઇ ગીઅલા ન્યાયી ઠોરાવલો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","જ્યા બોદાજ ભવિષ્યવક્તા સાક્ષી દેતહા કા જો કાદો ચ્યાવોય બોરહો કોઅહે, ચ્યાલ ઈસુ નાવામાય પાપાહા માફી મિળી જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","પિત્તર યો વાતો આખી રિઅલો આતો કા વચન વોનાનારાહાવોય પવિત્ર આત્મા ઉતી યેના. ");
INSERT INTO gbl_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","એને જ્યા સુન્નત કોઅલા યહૂદી વિસ્વાસી લોક પિત્તરા આરે યેનલા આતા, ચ્યા બોદાજ નોવાય પામ્યા કા ગેર યહૂદી લોકબી પવિત્ર આત્માકોય બાઆય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","કાહાકા ચ્યાહાય ચ્યાહાન જુદી-જુદી ભાષા બોલતા એને પોરમેહેરા સ્તુતિ કોઅતા વોનાયા, તોવે પિત્તરે આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","“આમહે રોકા પોરમેહેરા પાઅને પવિત્ર આત્મા પામ્યાહા તે આમી કાદોબી યાહાન પાઆયાકોય બાપતિસ્મા લાંહાટી રોકી હોકહે કા તો બાપતિસ્મા નાંય લેય, જ્યાહાય આમહે રોકા પવિત્ર આત્મા પોરમેહેરાપાઅને મેળવ્યાહાં?” ");
INSERT INTO gbl_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","એને પિત્તરે ચ્યાહાન આગના દેની કા ચ્યાહાન ઈસુ ખ્રિસ્તા નાવામાય બાપતિસ્મા દેનલા જાય, તોવે ચ્યાહાય ચ્યાલ વિનાંતી કોઅયી કા આજુ કોલહાક દિહી આમહે આરે રોય, યાહાટી ચ્યા કોલહાક દિહી રુકાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","એને પ્રેષિતાહાય એને વિસ્વાસ્યાહાય જ્યેં યહૂદીયા વિસ્તારમાય આતેં વોનાયે, કા ગેર યહૂદી લોકહાયબી પોરમેહેરા વચન માની લેદલા હેય. ");
INSERT INTO gbl_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","જોવે પિત્તર યેરૂસાલેમ શેહેરામાય યેનો, તોવે સુન્નત કોઅલા યહૂદી લોક ચ્ચાઆરે બોલા-બોલી કોઅતા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“તુયે ગેર યહૂદી લોકહા ગોઅ જાયને ચ્યાહાઆરે ખાદાં.” ");
INSERT INTO gbl_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","તોવે પિત્તર કરનેલીયુસા ગોઅમે જીં વાત બોની તી સુરુવાતપાઅને આખી દેખાડી. ");
INSERT INTO gbl_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","આંય યાફા શેહેરામાય પ્રાર્થના કોઇ રિઅલો આતો, તોવે દર્શન દેખ્યાકા યોક મોઠા ચારસા હારકી વસ્તુ ચારી ખૂણહાથી આકાશામાઅને નિચે ઉતાડલી જાય રીયલી આતી. ");
INSERT INTO gbl_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","જોવે માયે ચ્ચાવોય દિયાન કોઅયા, તે દોરતી વોયને ચાર પાગાવાળે જોનાવરે એને જંગલી જોનાવરે, એને હોઅપલીન ચાલનારેં જંતુ એને આકાશામાય ઉડનારે ચિડેં દેખ્યે. ");
INSERT INTO gbl_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","એને ઓ આવાજબી વોનાયો, “ઓ પિત્તર, ઉઠ એને માઆઇન ખો.” ");
INSERT INTO gbl_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","માયે આખ્યાં, નાંય પ્રભુ, નાંય, કાહાકા કોઅહીજ અપવિત્ર એને અશુદ્ધ વસ્તુ માયે નાંય ખાદહી. ");
INSERT INTO gbl_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","ચ્યા જવાબામાય આકાશામાઅને પાછો આવાજ યેનો, “જીં કાય પોરમેહેરે શુદ્ધ કોઅયા, ચ્યાલ તું અશુદ્ધ નાંય આખતો.” ");
INSERT INTO gbl_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","એહેકેન તીનદા બોન્યાં, એને પાછે બોદા કાય પાછા આકાશામાય ખેચી લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","તોવે તારાત તીન માઅહે કૈસરીયા શેહેરામાઅને કરનેલીયુસાય દોવાડલે આતેં, ચ્યે ગોઅમે જાં આંય આતો, યેયન ઉબા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","તોવે પવિત્ર આત્માય માન ચ્યાહાઆરે શંકા કોઅયા વોગાર જાં આખ્યાં, એને યા છ બાહા બી મા આરે કૈસરીયા શેહેરામાય આરે યેના, એને આમા કરનેલીયુસા ગોઓ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","એને ચ્યેય આમહાન આખ્યાં કા, માયે યોક હોરગા દૂતાલ મા ગોઅમે યેઇન ઉબો રોઅલો દેખ્યો, જ્યાંય માન આખ્યાં, યાફા શેહેરામાય માઅહે દોવાડીન સિમોન જ્યાલ પિત્તર આખતેહે, ચ્યાલ હાદી લે. ");
INSERT INTO gbl_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","તો તુલ ઓહડી વાત આખરી, જ્યાકોય તું એને તો બોદા કુટુંબ તારણ પામી. ");
INSERT INTO gbl_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","જોવે માયે બોલના શુરવાત કોઅયી, તે પવિત્ર આત્મા ચ્યાહાવોય ચ્યે રીતે ઉત્યા, જ્યેં રીતે પોચાસમાં દિહા દિહી આમહેવોય ઉતલાં. ");
INSERT INTO gbl_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","તોવે માન પ્રભુ ઈસુ વચન યાદ યેના, જીં ચ્યાય આખ્યેલ, યોહાનાય પાઅયા કોઇન બાપતિસ્મા દેના બાકી તુમા પવિત્ર આત્માકોય બાપતિસ્મા પામહા. ");
INSERT INTO gbl_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","યાહાટી ઈ નોક્કી હેય કા પોરમેહેરે ચ્યાહાનબી તી દાન દેનહા, જીં આપહાન પ્રભુ ઈસુ ખ્રિસ્તાવોય બોરહો કોઅનાકોય મિળ્યાં, તોવે આંય કું હેતાઉ જો પોરમેહેરાલ ઓટકાડુ? ");
INSERT INTO gbl_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ઈ વોનાઈન યહૂદી વિસ્વાસી ઠાવકાજ રિયા, એને પોરમેહેરા સ્તુતિ કોઇન આખ્યાં, “તોવે તો ગેર યહૂદીયાહાલ બી પોરમેહેરે અનંતજીવનાહાટી પાપ કોઅના બંદ કોઅના એને ઈસુ ખ્રિસ્ત વોય બોરહો કોઅરા દાન દેનલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","સ્તેફનુસાલ માઆઇ ટાક્યો પાછે, કોલહાક વિસ્વાસી યેરૂસાલેમ શેહેર છોડી દેના, ચ્યા ફિરતા-ફિરતા ફીનીકે વિસ્તાર એને સાઇપ્રસ બેટ એને સિરીયા વિસ્તારા અન્તાકિયા શેહેરામાય પોઅચ્યા, બાકી ચ્યાહાય યહૂદી લોકહાનુજ ઈસુ બારામાય હારી ખોબારે પ્રચાર કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","બાકી ચ્યાહામાઅને કોલાહાક સાઇપ્રસ એને કુરેની આતેં, જોવે ચ્યે અન્તાકિયા શેહેરામાય પોઅચ્યે, તોવે ચ્યાહાય યુનાની લોકહાનબી પ્રભુ ઈસુ હારી ખોબારે સંદેશ આખ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","એને પ્રભુ સામર્થ્ય ચ્યાહાવોય આતા, એને બોજ ગેર યહૂદી લોક ચ્યાહા સંદેશ માની ગીયે એને પ્રભુ ઈસુવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","જોવે યેરૂસાલેમ શેહેરા મંડળ્યે વિસ્વાસ્યાહાન ઈ ખોબાર પોડી, તોવે ચ્યાહાય બારનાબાસાલ અન્તાકિયા શેહેરામાય દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","તો તાં પોઅચીન, એને પોરમેહેરા સદા મોયા એઇન ખુશ જાયો, એને બોદહાન આખ્યાં કા તનમન લાવીન પ્રભુમાંય બોની રા. ");
INSERT INTO gbl_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","બર્નાબાસ હારો માઅહું આતો, બોરહો કોઅના એને પવિત્ર આત્માકોય બોઆલો આતો, એને બોજ લોક પ્રભુમાંય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","તોવે બારનાબાસ અન્તાકિયા શેહેરામાઅને શાઉલાલ હોદાહાટી તારસુસ શેહેર જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","એને જોવે ચ્યાલ મિળ્યો તોવે ચ્યાલ અન્તાકિયા શેહેર લેય યેનો, એને એહેકેન જાયા કા શાઉલ એને બારનાબાસ યોક વોરહા લોગુ મંડળીઆરે મિળતા એને બોજ લોકહાન ઈસુ ખ્રિસ્તા બારામાય હિકાડતા રિયા, એને શિષ્ય બોદહા પેલ્લા અન્તાકિયા શેહેરામાય ખ્રિસ્તી આખાયા. ");
INSERT INTO gbl_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ચ્યા દિહીહામાય કોલહાક વિસ્વાસી ભવિષ્યવક્તા આતા, ચ્યા યેરૂસાલેમ શેહેરામાઅને અન્તાકિયા શેહેરામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ચ્યાહામાઅને અગાબુસ નાંવા યોક ભવિષ્યવક્તાય ઉબો રોયન પવિત્ર આત્મા અગુવાઈકોય ઈ આખ્યાં, કા બોદા દુનિયામાય મોઠો દુકાળ પોડી, એને તો દુકાળ સમ્રાટ ક્લોદિયુસ સમયે પોડયો. ");
INSERT INTO gbl_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","તોવે અન્તાકિયા વિસ્વાસ્યાહાય એહેકેન નોક્કી કોઅયા બોદા જાંઆ જ્યા-ચ્યાહા કામાણી નુસાર યહૂદીયા વિસ્તારમાય રોનારા વિસ્વાસ્યાહાલ મોદાત કોઅરાહાટી પોયહા દોવાડે. ");
INSERT INTO gbl_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","એને ચ્યાહાય પોયહા યોખઠા કોઅયા, એને બારનાબાસ એને શાઉલા આથામાય દેયન આગેવાનાહાપાય પોયહા લેય દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ચ્યે સમયે હેરોદ રાજાય મંડળ્યે કોલાહાક માઅહાલ સતાવાહાટી દોઇન કોન્ડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ચ્યેય પ્રેષિત યોહાના બાહા યાકૂબાલ તારવાયે કોઇન માઆઇ ટાકાડયો. ");
INSERT INTO gbl_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","જોવે ચ્યાય ઈ દેખ્યાકા યહૂદી લોક યાકોય ખુશ ઓઅતાહા, તોવે પિત્તરાલ બી દોઈ લેદો, ઓ પાસ્કા બાખ્યે સણા સમય આતો. ");
INSERT INTO gbl_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","હેરોદ રાજાય પિત્તરાલ જેલેમાય કોંડી દેનો, એને ચાર-ચાર સીપાડાહાલ ચાર પાહારા માય થોવ્યો, યા વિચારાકોય કા પાસ્કા સણા પાછે લોકહા હામ્મે ચ્યા ન્યાય કોએ. ");
INSERT INTO gbl_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","જેલેમાય પિત્તરા રાખવાળી બોજ દિહહા કોય ઓઈ રિઅલી આતી, બાકી મંડળી ચ્યાહાટી કાયામ પોરમેહેરાલ પ્રાર્થના કોઅતી રોયી. ");
INSERT INTO gbl_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","એને જોવે હેરોદ રાજા ચ્યા ન્યાય કોઅરાહાટી લોકહા હામ્મે લેય યેનારો આતો, ચ્યા યોક રાત પેલ્લા પિત્તર બેન બેડયેહે કોય બાંદલો આતો, બેન સિપાડાહા વોચમાય હૂવી રિઅલો આતો, એને જાગલ્યા બાઆણાઈહી જેલે રાખવાળી કોઇ રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","અચાનક પ્રભુ યોક હોરગા દૂત પિત્તરા ઈહીં ઉબો જાયો, એને ચ્યે ખોલીમાય ઉજવાડો ચોમક્યો, એને ચ્યાય પિત્તરા ખોવા વોય આથ લાવીન ચ્યાલ ઉઠાડયો, એને આખ્યાં, “માહારી ઉઠ, ઉતવાળ કોઓ,” એને ચ્યા આથહા વોયને બેડયો ટુટી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","તોવે હોરગા દૂતાય ચ્યાલ આખ્યાં, “તિયાર ઓઓ, એને વાઅણે પોવી લે” પિત્તરે તેહેકેન કોઅયા, હોરગા દૂતાય પાછા ચ્યાલ આખ્યાં, “ઝોબો પોવી લે, એને મા પાહલા ચાલ.” ");
INSERT INTO gbl_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","પિત્તર ચ્યા પાહલા ચાલા લાગ્યો, બાકી ઈ નાંય જાંઅતો આતો કા જીં કાય હોરગા દૂત કોઇ રિઅલો હેય, તી હાચ્ચાં હેય, બાકી ઈ હોમજ્યો કા આંય હોપનાં એઇ રિયહો. ");
INSERT INTO gbl_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","તોવે ચ્યા પેલ્લા એને બિજા પાહારા ઇહને નિંગીન ચ્યા લોખંડા ફાટકા પાય પોઅચ્યા, જો શેહેરા એછે જાયના વાટે હેય, તી ફાટાક ચ્યાહાહાટી ચ્યામેળેજ ખુલી ગીયા, એને ચ્યા નિંગીન યોક્યેજ વાટેમાય ચાલતા લાગ્યા, ઓલહામાય હોરગા દૂત ચ્યાલ છોડીન જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","તોવે પિત્તર ભાનમાય યેનો એને ચ્યાય આખ્યાં, “આમી માયે જાઈ લેદા કા પ્રભુય ચ્યા હોરગા દૂતાલ દોવાડીન માન હેરોદા કોબજા માઅને સોડાવી લેદલો હેય એને યહૂદી આગેવાનહા બોદી આશા તોડી દેનલી હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ઈ જાઇન કા પોરમેહેરાય પિત્તરાલ બોચાવી લેદહો, તોવે તો મરિયમે ગોઓ ગીયો, મરિયમ યોહાન જો માર્ક આખાયેહે ચ્યા આયહો આતી, તાં બોજ વિસ્વાસી બેગે ઓઇન પ્રાર્થના કોઇ રીઅલે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","જોવે પિત્તરે ફાટાક ખોકડાવ્યાં તોવે રોદા નાંવા યોક દાસી ફાટાક ઉગાડા યેની. ");
INSERT INTO gbl_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","એને પિત્તરા આવાજ વોળખીન, ચ્યેય ખુશીકોય બાઉં નાંય ઉગાડયા, બાકી દાંહદીન માજા ગિઇ, એને બોદહાન આખ્યાં કા પિત્તર બાઆઇહી ઉબો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ચ્યાહાય ચ્યેલ આખ્યાં, “તું ગાંડવાઈ ગીયહી” બાકી ચ્યેય ખાત્રીકોય આખ્યાં કા ઓ પિત્તર હેય, તોવે ચ્યાહાય આખ્યાં, “ચ્યા હોરગા દૂત ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","બાકી પિત્તર બાઆવા ખોકડાવતોજ રિયો, તોવે ચ્યાહાય બાઉં ઉગાડયા એને ચ્યાલ દેખીન બોજ નોવાય પામી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","તોવે ચ્યાય ચ્યાહાન આથા કોઇન ઈશારો કોઇન ઠાવકાજ રા આખ્યાં, એને ચ્યાહાન આખ્યાં કા પ્રભુ કેહેકેન ચ્યાલ જેલેમાઅને છોડવી લેય યેનો, પાછી આખ્યાં, “યાકૂબ એને બિજા બાહહાન ઈ વાત આખી દેજા” તોવે નિંગીન બીજે જાગે જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","હાકાળેહે જેલે રાખવાળી કોઅનારા સીપાડા બોજ ગાબરાઈ ગીયા કા પિત્તર કેછ ગીયો? ");
INSERT INTO gbl_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","જોવે હેરોદ રાજાય પિત્તરાલ હોદી કાડના આગના કોઅયી, બાકી તો નાંય મિળ્યો, તોવે ચ્યેય જાગલ્યાહાન સાવાલ પુછા એને જોવે ચ્યા જાવાબ નાંય દી હોક્યા તોવે ચ્યાહાન માઆઇ ટાકના સજા કોઅયી. ચ્યા પાછે હેરોદ રાજા યહૂદીયા વિસ્તાર છોડીન કૈસરીયા શેહેરામાય જાયને કોલહોક સમયાહાટી તાં રા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","હેરોદ રાજા સોર એને સિદોન શેહેરા લોકહાઉપે બોજ ખિજવાઈ ગીયેલ, ચ્યાહાટી ચ્યાલ મિળાહાટી ચ્યા યેના, એને બલાસ્તુસ જો રાજા યોક કર્મચારી આતો, ચ્યાલ મોનાવીન હોમજાં કોશિશ કોઅયી, કાહાકા રાજા દેશામાઅને ચ્યાહા દેશાહાન અનાજ મિળતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","જ્યેં દિહે હેરોદ રાજાય ચ્યાહાઆરે મિળના નોક્કી કોઅયા, ચ્યે દિહી રાજા ડોગલેં પોવીન રાજગાદ્યેવોય બોહી ગીયો, એને ચ્યાહાન સંદેશ દાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","તોવે લોક બોંબલી ઉઠયા, “ઓ તો માઅહા નાંય હેય ઈશ્વરા શબ્દ હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ચ્યેજ સમયે પ્રભુ યોક હોરગા દૂતાય ચ્યાલ ઠોક્યાં, કાહાકા ચ્યે પોરમેહેરાલ મહિમા નાંય કોઅયી એને ચ્યા શરીરામાય કિડે પોડયેં એને તો મોઓઈ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","બાકી પોરમેહેરા વચન ફેલાતા ગીયા એને વિસ્વાસ્યાહા ગોણત્રી વોદતી ગિઇ. ");
INSERT INTO gbl_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","યહૂદીયા ભાગામાય યહૂદી વિસ્વાસીયા મોદાત કોઅરાહાટી પોયહા દેઅના પાછે, બારનાબાસ એને શાઉલ યેરૂસાલેમ શેહેરામાઅને અન્તાકિયા શેહેરામાય પાછા ફિરી યેના, એને યોહાન જ્યાલ માર્ક બી આખતેહે ચ્યાહાઆરે આતો. ");
INSERT INTO gbl_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","અન્તાકિયા શેહેરા મંડળીમાય કોલહાક ભવિષ્યવક્તા એને શિક્ષક આતા, બારનાબાસ, સિમોન જ્યા બિજા નાંવ નીગર આતા, કુરેન શેહેરા લુકીયુસ, હેરોદ રાજા બાહા મનાહેમ એને શાઉલ. ");
INSERT INTO gbl_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","જોવે ચ્યા ઉપહા કોઇન પ્રભુ ભક્તિ કોઇ રીઅલા આતા, તોવે પવિત્ર આત્માય ચ્યાહાન આખ્યાં, “મા હાટી બારનાબાસ એને શાઉલાલ મા સેવા કોઅરાહાટી આલાગ કોઆ, જ્યાહાટી માયે ચ્યાહાન હાદલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","તોવે ચ્યાહાય ઉપહા એને પ્રાર્થના કોઇન ચ્યાહાય ચ્યાહાવોય આથ થોવિન ચ્યાહાન પોરમેહેરા કામ કોઅરા દોવાડયા. ");
INSERT INTO gbl_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","બારનાબાસ એને શાઉલ પવિત્ર આત્માકોય દોવાડલા અન્તાકિયા શેહેરાઇહીને સીલૂકીયા શેહેર લોગુ ગીયા, એને તાઅને ચ્યા સાઇપ્રસ બેટા સલમીસ શેહેરામાય જાંહાટી જાહાજાકોય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","સલમીસ પોઅચીન પોરમેહેરા વચન યહૂદીયાહા સોબાયે ઠિકાણામાય આખ્યાં, એને યોહાન, જ્યાલ માર્ક આખતેહે તો ચ્યાહા મોદાત કોઅરાહાટી ચ્યાહાઆરે આતો. ");
INSERT INTO gbl_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ચ્યા પાછે ચ્યાહાય બોદા બેટા વોઅને ફિરતા, પાફુસ શેહેરા લોગુ પોઅચ્યા, તાં ચ્યાહાન બાર-યેશુ નાંવા યોક જાદુગાર મિળ્યો, જો યહૂદી એને જુઠો ભવિષ્યવક્તા આતો. ");
INSERT INTO gbl_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","તો ચ્યા બેટા શાસક સિરગીયુસ પાઉલા આરે આતો, તો યોક બુદ્ધિમાન માઅહું આતો, શાસકાય બારનાબાસ એને શાઉલાલ હાદિન પોરમેહેરા વચન વોનાયા માગ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","બાકી બાર-યેશુય, જ્યા ઉપનાંવ એલિમાસ એટલે જાદુગાર આતાં, ચ્યાય શાઉલ એને બારનાબાસા વિરુદ કોઇન, શાસકાલ ઈસુવોય બોરહો કોઅનાકોય હારકા કોશિશ કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","તોવે શાઉલ જ્યા નાંવ પાઉલ બી હેય, પવિત્ર આત્મા કોયન બોઆયને બાર-યેશુ એછે યોકદીઠ એઇન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ઓ બોજ ખારાબ એને બોજ જુઠાકોય બાઆલા સૈતાના પોહા, બોદા હારાં કામહા દુશ્માન, કાય તું પ્રભુ હિદી વાટહયેન વાકડી કોઅના નાંય સોડહે? ");
INSERT INTO gbl_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","આમી એએ, પ્રભુ તુલ ડોંડ દેનારો હેય, એને તું કોલહાક સોમાયા લોગુ આંદળો બોની જાહે એને દિહી નાંય એઅહે,” તોવે એલુમાસાલ તારાત જાખાં એને આંદારાં ઓઈ ગીયા, એને તો ઈહીં-તાં ચાફાલતો લાગ્યો કા ચ્યા આથ દોઇન મોદાત કોએ. ");
INSERT INTO gbl_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","તોવે શાસકાય જીં કાય જાયા, દેખીન એને પ્રભુ શિક્ષણા બારામાય નોવાય પામીન ચ્યાય ઈસુવોય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","પાઉલ એને ચ્યા હાંગાત્યા પાફુસ શેહેરા દોરિયામાઅને મુસાફરી સુરુ કોઅયી, એને પંફૂલિયા વિસ્તારા પિરગા શેહેરામાય પોઅચ્યા, તાં યોહાન માર્ક ચ્યાહાન છોડીન યેરૂસાલેમ શેહેરામાય પાછો ફિરી યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","એને પિરગા શેહેરાઇહીને આગલા જાયને, ગલાતી વિસ્તારા પીસદીયા ભાગા પાહે અન્તાકિયા શેહેરામાય પોઅચ્યા, એને આરામા દિહી સોબાયે ઠિકાણામાય જાયને બોઠા. ");
INSERT INTO gbl_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","મૂસા નિયમશાસ્ત્ર એને ભવિષ્યવક્તાહા ચોપડીમાઅને વાચ્યા પાછે સોબાયે ઠિકાણા આગેવાનહાય ચ્યાહાન આખી દોવાડયા, “ઓ બાહાહાય, જો લોકહાન પ્રોત્સાહાના હાટી તુમા કાય આખા માગતાહા, તે આખા.” ");
INSERT INTO gbl_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","તોવે પાઉલાય ઉબો રોઇન એને લોકહાન ઠાવકાજ રાંહાટી આથા કોઇન ઈશારો કોઇન આખ્યાં, ઓ ઈસરાયેલી લોકહાય, એને પોરમેહેરા બિક રાખનારા ગેર યહૂદી લોકહાય, વોનાયા. ");
INSERT INTO gbl_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","યા ઈસરાયેલા લોકહા પોરમેહેરે આપહે આગલ્યા ડાયહાન નિવડી લેદા, એને જોવે મિસર દેશામાય પારદેશી ઓઇન રા આતા, તોવે ચ્યાહાન વોદાડયા, એને પરાક્રમી સામર્થ્યા કોઇન ચ્યાહાન તાઅને કાડી લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","એને ચાળહી વોરહા લોગુ ચ્યે ઉજાડ જાગામાય ચ્યાહાન સહન કોઅતો રિયો, જોવે ચ્યાહાય ગેડી-ગેડી આગના તોડી. ");
INSERT INTO gbl_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","એને ચ્યાય કનાન દેશા હાંત જાતહયેન નાશ કોયન ચ્યાહા જમીન ચ્યા લોકહા ઓદિકારામાય દેય દેની. યે બોદયે પ્રક્રીયામાય લગભગ ચારસો પોચહા વોરહે લાગ્યેં. ");
INSERT INTO gbl_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ચ્યા પાછે ચ્યાય શમુએલ ભવિષ્યવક્તા લોગુ ન્યાયી ઠોરાવ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","શમુએલ ભવિષ્યવક્તા આજુ આગેવાન આતો, તોવે ચ્યાહાય રાજા માગ્યો, એને પોરમેહેરે બિન્યામીના કુળામાઅને કિશા પોહો શાઉલાલ રાજા બોનાડયો એને ચ્યાય ચાળહી વોરહા લોગુ ઈસરાયેલી લોકહાવોય રાજ્ય કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","પાછે પોરમેહેરે શાઉલાલ રાજા પદા વોઅને ઓટાડીન ચ્યા જાગાવોય દાઉદાલ રાજા બોનાડયો, જ્યા બારામાય પોરમેહેરે ઓહડી સાક્ષી દેની, માન યોક માઅહું, યિશૈ પોહો દાઉદ, મા મોના રોકો મિળી ગીયહો, તો મા બોદી મોરજી પુરી કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ચ્યા કુળામાઅને પોરમેહેરે ચ્યા વાયદા પરમાણે ઈસરાયેલી લોકહા પાહી યોક તારણ કોઅનારો, એટલે ઈસુલ દોવાડયો. ");
INSERT INTO gbl_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ઈસુ યેયના પેલ્લા યોહાને બોદા ઈસરાયેલી લોકહાન પાપ કોઅના બંદ કોઅના એને બાપતિસ્મા લેઅના પ્રચાર કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","એને જોવે યોહાન ચ્યા સેવા પુરી કોઅનાવોય આતો, તોવે ચ્યાય આખ્યાં, તુમા માન કાય હુમાજતાહા? આંય ખ્રિસ્ત નાંય હેય, બાકી એઆ, મા પાછે યોક યેનારો હેય, તો મા કોઅતો મહાન હેય આંય ચ્યા ચાકાર બોનીન બુટા હુતળી છોડાબી લાયકે નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","“ઓ બાહાહાય, તુમા જ્યા આબ્રાહામા પીડી હેતા, એને પોરમેહેરા બિક રાખનારા ગેર યહૂદી લોકહાય, પોરમેહેરાય આપહે પાહી ઈસુ બારામાય ઓ સંદેશ દોવાડલો હેય જો લોકહાન બોચાડેહે. ");
INSERT INTO gbl_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","યેરૂસાલેમ શેહેરામાય રોનારા એને ચ્યાહા આગેવાનાહાય, ખ્રિસ્ત ઈસુલ નાંય વોળખ્યો, એને નાંય ભવિષ્યવક્તા વાતો હોમજ્યા, જ્યો દર આરામા દિહે વાચલી જાહે, યાહાટી ચ્યાલ દોષી ઠોરવીન ભવિષ્યવાણી વાતો પુર્યો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ચ્યાલ માઆઇ ટાકના લાયકે કાયજ દોષ નાંય મિળ્યો, તેરુંબી પિલાત રાજાલ વિનાંતી કોઅયી, કા ચ્યાલ માઆઇ ટાકલો જાય. ");
INSERT INTO gbl_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","એને ચ્યાહાય તી બોદા કોઅયા જીં પવિત્રશાસ્ત્રમાય ચ્યા બારામાય આખલા આતા, ચ્યાહાય ચ્યાલ યોકા હુળીખાંબાવોય ખીલા ઠોકીન માઆઇ ટાક્યો, એને ચ્યાલ હુળીખાંબાવોયને ઉતાડીન કોબારેમાય થોવ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","બાકી પોરમેહેરે ચ્યાલ મોઅલા માઅને પાછો જીવતો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","એને તો ચ્યાહાન જ્યેં ચ્યાઆરે ગાલીલ ભાગામાઅને યેરૂસાલેમ શેહેરામાય યેનલે આતેં. તો બોજ દિહી લોગુ ચ્યા શિષ્યહાન દેખાતો રિયો, લોકહા હામ્મે જ્યાહાય ચ્યાલ દેખ્યહો ચ્યેજ ચ્યા સાક્ષી હેય. ");
INSERT INTO gbl_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","આમા તુમહાન ઈ હારી ખોબાર આખજેહે કા પોરમેહેરે આપહે આગલ્યા ડાયહા આરે જો વાયદો કોઅલો આતો, ");
INSERT INTO gbl_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","યા વાયદાલ પોરમેહેરાય ઈસુલ મોઅલા માઅને પાછો જીવતો કોઇન તી વાયદો આપહે પોહાહા હાટી પુરો કોઅયો. જેહેકેન ગીતશાસ્ત્રમાય લોખલાં હેય, તું મા પ્રિય પોહો હેય, આંય તો આબહો બોની ગીઅલો હેતાંવ. ");
INSERT INTO gbl_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","પોરમેહેરાય ચ્યાલ મોઅલાહામાઅને પાછો જીવતો કોઅયો એને આમી પાછા ચ્યા શરીર હોડી નાંય યે વાતે સાબિત્યે હાટી પોરમેહેરાય આખ્યાં, ‘આંય દાઉદ રાજાવોય કોઅલી પવિત્ર એને કાયામ રોનારી બોરકાત તુમહાવોય કોઅહી.’ ");
INSERT INTO gbl_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","યાહાટી દાઉદ રાજાય ઈ વાત બિજા ગીત શાસ્ત્રામાય આખહે, ‘તું તો પવિત્ર જનહાલ હોડા નાંય દેહે.’ ");
INSERT INTO gbl_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","યાહાટી દાઉદ રાજા તે પોરમેહેરા મોરજી પરમાણે ચ્યા સોમાયામાય સેવા કોઇન મોઅઇ ગીયો, એને ચ્યા આગલ્યા ડાયહા આરે દાટાયો. ");
INSERT INTO gbl_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","બાકી ઈસુલ પોરમેહેરે મોઅલા માઅને પાછો જીવતો કોઅયો, ચ્યા શરીર નાંય હોડયા. ");
INSERT INTO gbl_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ચ્યાહાટી, ઓ બાહાહાય, તુમા જાઈલા કા ઈસુકોય પાપહા માફી ખોબાર તુમહાન દેનલી જાહે. ");
INSERT INTO gbl_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","એને જ્યેં વાતહેકોય તુમા મૂસા નિયમશાસ્ત્રાકોય નિર્દોષ નાંય ઠોરી હોકે, ચ્યા બોદા બારામાય હર કાદો બોરહો કોઅનારો ઈસુકોય નિર્દોષ ઠોરહે. ");
INSERT INTO gbl_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ચ્યાહાટી તુમા હાચવીન રા, એહેકેન નાંય ઓએ, કા જીં ભવિષ્યવક્તાહા ચોપડયેમાય લોખલાં હેય, તી તુમહાવોય યી પોડે. ");
INSERT INTO gbl_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","ઓ નિંદા કોઅનારાહાય, એઆ, એને નોવાય પામા, એને મોઅઇ જાં, કાહાકા આંય તુમહે દિહીહામાય યોક કામ કોઅહી, ઓહડા કામ, કા જોવે કાદો તુમહાન આખે, તો તુમા કોદહી બોરહો નાંય કોઅહા.” ");
INSERT INTO gbl_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","જોવે પાઉલ એને બારનાબાસ સોબાયે ઠિકાણા માઅને બાઆ જાતા આતા, તોવે લોકહાય ચ્યાહાલ વિનાંતી કોઅયી, કા આગલે આરામા દિહે આમહાન યો વાતો પાછા આખે. ");
INSERT INTO gbl_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","એને જોવે સોબાયે ઠિકાણેને છુટ્યા પાછે યહૂદી એને પોરમેહેરા બિક રાખનારા ગેર યહૂદી લોક પોરમેહેરા ભક્તિ કોઅનારા પાઉલ એને બારનાબાસાઆરે ઓઈ ગીયા, એને પાઉલ એને બારનાબાસે ચ્યાહાઆરે વાત કોઇન હોમજાડ્યા, કા પોરમેહેરા સદા મોયામાય બોની રોય. ");
INSERT INTO gbl_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","આગલે આરામા દિહે શેહેરા લગભગ બોદા લોક પોરમેહેરા વચન વોનાયા હાટી બેગા જાયા. ");
INSERT INTO gbl_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","બાકી યહૂદી આગેવાનહાય ગીરદી દેખીન ઈર્ષ્યા કોય બાઆય ગીયા, એને નિંદા કોઇન પાઉલા વાતહે વિરુદમાય બોલા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","તોવે પાઉલ એને બારનાબાસે બિક વોગાર આખ્યાં, “જરુરી આતા, કા પોરમેહેરા વચન પેલ્લા તુમહાન આખલા આતા, બાકી જોવે તુમહાય નાકાર કોઇ દેના, એને પોતાલ અનંતજીવના લાયકે નાંય ઠોરાવે, તો આમી, આમા ગેર યહૂદી લોકહાપાંય જાતહા. ");
INSERT INTO gbl_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","કાહાકા પોરમેહેરે આમહાન ઓહડી આગના દેનલી હેય, માયે તુલ ગેર યહૂદી લોકહાહાટી ઉજવાડા હારકો ઠોરાવલો હેય, તુલ દુનિયા બોદે જાગે લોકહાન તારણ કોઅનારા બારામાય આખના હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ઈ વોનાઈન ગેર યહૂદી લોક બોજ ખુશ ઓઅઇ ગીયા, એને પોરમેહેરા વચના સ્તુતિ કોઅરા લાગ્યા, એને જોલે અનંતજીવનાહાટી નિવાડલે, ચ્યા બોદહાય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","તોવે પ્રભુવા વચન બોદે દેશામાય ફેલાયા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","બાકી યહૂદી આગેવાનહાય એને કુલીન થેએયો એને શેહેરા મુખ્ય માટડાહાન ઉસરાવ્યા, એને પાઉલ એને બારનાબાસા વિરોદ કોઆડીન ચ્યાહાલ ગાવા હિવે બારે કાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","તોવે પાઉલ એને બારનાબાસ ચ્યાહા હામ્મે પાગહા બુપટા ખેખરીન ઈકુનિયુમ શેહેરામાય જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","એને અન્તાકિયા શેહેરામાય શિષ્ય આનંદ એને પવિત્ર આત્માકોય બોઆતા ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ઈકુનિયુમ શેહેરામાય એહેકેન જાયા કા પાઉલ એને બારનાબાસ યહૂદી લોકહા સોબાયે ઠિકાણે આરે-આરે ગીયા, એને એહેકેન વાત કોઅયી, કા યહૂદી એને ગેર યહૂદી લોક બેન્યાહા માઅને બોજ જાઅહાય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","બાકી બોરહો નાંય કોઅનારા યહૂદી લોકહાય ગેર યહૂદી લોકહાન વિસ્વાસી લોકહા વિરુદમાય ઉસરાવ્યા, એને દુશ્માની પૈદા કોઇ દેની. ");
INSERT INTO gbl_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","એને પાઉલ એને બારનાબાસ ચ્યા બોજ દિહયા લોગુ તાં રિયા, એને પ્રભુ બોરહાવોય ઇંમાતથી વાતો કોઅતા રિયા, એને પોરમેહેરાય ચ્યાહાકોય ચિન્હ એને નોવાયે કામે કોઆડીન સાબિત કોઅયા કા યા સદા મોયાબારામાય ચ્યાહા સંદેશ હાચ્ચો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","બાકી શેહેરા લોકહામાય ફુટ પોડી ગીયી, ચ્યાકોય કોલહાક લોક યહૂદીહાઆરે એને કોલહાક પ્રેષિતાહા આરે ઓઅય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","જોવે ગેર યહૂદી એને યહૂદી ચ્યાહા નિંદા એને ચ્યાહાવોય દોગડાટાહાટી આગેવાનહા આરે ચ્યાહાપાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","તોવે ચ્યા ઈ વાત જાંઆય ગીયા, એને લુકાઉનિયા વિસ્તારા લુસ્ત્રા એને દિરબે શેહેરામાય, એને ચ્યા આહે-પાહે ભાગામાય નાહી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","એને તાં હારી ખોબાર આખા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","લુસ્ત્રા શેહેરમાય યોક માઅહું આતા, જો પાગા પાંગળ્યો આતો, તો જન્માથીજ લેંગડયો આતો, એને કોવેજ નાંય ચાલલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","તો પાઉલાલ વાતો કોઅતા વોનાય રિઅલો આતો, એને પાઉલે ચ્યાએછે યોકદીઠ એઅયા કા યાલ હારાં ઓઅના બોરહો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","એને બોંબલીન આખ્યાં, “તો પાગહાવોય હિદો ઉબો ઓઅય જો” તોવે તો કુદીન ચાલા-ફિરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","લોકહાય પાઉલા ઈ કામ એઅઇન લુકાઉનિયા ભાષામાય બોંબલીન આખ્યાં, “દેવતા માઅહા રુપ લેઈને આપહેપાય ઉતી યેનલા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ચ્યાહાય બારનાબાસાલ યુનાની દેવતા જ્યૂસ નાંવ દેના એને પાઉલાલ હિર્મેસ નાંવ દેના, કાહાકા તો મુખ્ય સંદેશ દેનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","શેહેરા બાઆ યોક જ્યૂસ દેવતા મંદિર આતાં, ચ્યા મંદિરા પુંજારો ડોબેં એને ફુલહા આર્યો લેય યેયન શેહેરા મોઠા ફાટકાલોગુ યેય ગીયો, તો ચ્યા લોકહાઆરે મિળીન બલિદાન કોઅરા માગતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","બાકી બારનાબાસ એને પાઉલ પ્રેષિતાહાય જોવે વોનાયા, તોવે ચ્યા બોજ હેરાન ઓઅય ગીયા એને ગીરદ્યેમાય દાહુદી ગીયા, એને બોંબલીન આખા લાગ્યા, ");
INSERT INTO gbl_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ઓ લોકહાય, તુમા કાય કોઇ રીઅલા હેય? આમા બી તે તુમહે હારકે દુ:ખ-સુખ બોગાવનારે માઅહે હેય, એને તુમહાન હારી ખોબાર આખજેહે કા તુમા યે નોકામ્યે વસ્તુહુથી આલાગ ઓઇન જીવતા પોરમેહેરાએછે યા, જ્યાંય આકાશ એને દોરતી એને દોરિયો એને જીં કાય ચ્યામાય હેય બોનાડ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ચ્યાય નિંગી ગીઅલા સમયામાય બોદી જાતહીંન ચ્યાહા-ચ્યાહા મોનાકોય ચાલા દેના. ");
INSERT INTO gbl_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","તેરુંબી ભલા કોઇન આકાશ માઅને પાઆઈ એને ફળ દેનારો ચોમાહા તુમહાન દેયને, એને ખાઅના એને આનાંદા કોય તુમહાન તૃપ્ત કોઇન ચ્યા પોરમેહેરે પોતાના બારામાય સાક્ષી દેની.” ");
INSERT INTO gbl_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ઈ આખીન બી ચ્યાહાય બોજ મોઠી મુશ્કેલથી રોક્યા કા ચ્યાહાહાટી બલિદાન નાંય કોએ. ");
INSERT INTO gbl_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","બાકી કોલહાક યહૂદી લોક અન્તાકિયા એને ઈકુનિયુમ શેહેરામાઅને યેયન લોકહાન ચ્યાહા એછે કોઇ લેદા, એને પાઉલાવોય દોગાડઝોડ કોઅયી, એને મોઅલો હોમજીન ચ્યાલ શેહેરા બાઆ ગોહલીન લેય ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","બાકી જોવે શિષ્ય ચ્યા ચારીચોમખી યેયન ઉબા રિયા, તોવે પાઉલ ઉઠીન શેહેરામાય ગીયો. એને બીજે દિહી બારનાબાસાઆરે દિરબે શેહેરામાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","એને પાઉલ એને બારનાબાસ ચ્યા શેહેરા લોકહાન હારી ખોબાર આખીન, બોજ શિષ્ય બોનાડીન, ફિરી યેતા સમયે ચ્યા લુસ્ત્રા શેહેરામાય ગીયા પાછે ચ્યા ઈકુનિયુમ શેહેરામાય ગીયા, એને પાછે ચ્યા પિસીદિયા વિસ્તારા અન્તાકિયા શેહેરામાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","એને બોદા શેહેરાહામાય શિષ્યહા મન સ્થિર કોઅતા રિયા, એને ઈ હિકાડતા આતા કા બોરાહામાંય બોની રા, એને ઈ આખતા આતા, આપહાન મોઠા દુ:ખ ઉચકીન પોરમેહેરા રાજ્યામાય પ્રવેશ કોઅરા પોડી. ");
INSERT INTO gbl_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","એને પાઉલ એને બારનાબાસે બોદી મંડળ્યેહેમાય વિસ્વાસ્યાહાહાટી વડીલ નિવડયા, એને ઉપહા હાતે પ્રાર્થના કોઇન પ્રભુ ઈસુલ હોઅપ્યા, જ્યાવોય ચ્યાહાય બોરહો કોઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","તોવે પિસીદિયા વિસ્તારામાઅને ઓઇન ચ્યા પંફૂલિયા વિસ્તારામાય પોઅચ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","પિરગા શેહેરામાય વચન આખીન અત્તાલિયા શેહેરામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","એને તાઅને જાહાજાકોય અન્તાકિયા શેહેરામાય પાછા ફિરી યેના, જાઅને ચ્યાહાલ પોરમેહેરા સદા મોયામાય હોઅપીન ચ્યા કામાહાટી દોવાડલા આતા, જ્યાલ ચ્યા આમી પુરાં કોઇન ફિરી યેનલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","અન્તાકિયા શેહેર પોઅચીન ચ્યાહાય મંડળ્યેલ યોક્ઠી કોઅયી એને આખ્યાં, પોરમેહેરાય ચ્યાહાઆરે રોયન કેહેકેન મોઠે-મોઠે કામે કોઅયે, એને કેહેકેન પોરમેહેરાય ગેર યહૂદી લોકહાન ખ્રિસ્ત ઈસુવોય બોરહો કોઅરા લાયકે બોનાડ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","એને પાઉલ એને બારનાબાસ શિષ્યહાઆરે બોજ દિહી લોગુ રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","કોલહાક યહૂદી બોરહો કોઅનારા યહૂદીયા વિસ્તારામાઅને અન્તાકિયા શેહેરામાય યેના એને વિસ્વાસ્યાહાલ હિકાડાં લાગ્યા કા: “જોવે મૂસા રીતીકોય તુમહે સુન્નત નાંય ઓએ તે તુમા બોચી નાંય હોકહા.” ");
INSERT INTO gbl_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","જોવે પાઉલ એને બારનાબાસ ચ્યાહાઆરે બોજ મતભેદ એને કોલહાક બોલા-બોલી ઓઅયા તોવે ઈ નિશ્ચય કોઅયા કા પાઉલ એને બારનાબાસ, અન્તાકિયા કોલહાક લોકહાઆરે યેરૂસાલેમ શેહેરામાય જાય એને યા સવાલાવોય પ્રેષિત એને વડીલાહાઆરે ચર્ચા કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","પાછે મંડળી લોકહાય ચ્યાહાલ વાટેહાટી પોયહા એને ખાઅના દેયને દોવાડી દેના, એને ચ્યા ફીનીકે એને સમરૂન વિસ્તારામાઅને ગીયા, એને તાઅને વિસ્વાસ્યાહા આરે વાત કોઅયી કા, ગેર યહૂદી લોક કેહેકેન હારી ખોબાર વોનાયને ખ્રિસ્તાવોય બોરહો કોઅય રીઅલા હેય, ઈ આખીન ચ્યાહાય બોદા વિસ્વાસી બાહહાલ બોજ આનંદિત કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","જોવે ચ્યા યેરૂસાલેમ શેહેરમાય પોઅચ્યા, તોવે મંડળી લોક એને પ્રેષિત એને વડીલ ચ્યાહાન આનંદકોય મિળ્યાં, એને પાઉલ એને બારનાબાસે આખ્યાં કા પોરમેહેરાય ચ્યાહાઆરે રોઇન કોહડે-કોહડે કામ કોઅલે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","બાકી પોરૂષીયાહા ટોળામાઅને જ્યાહાય બોરહો કોઅલો આતો, ચ્યાહામાઅને કોલહાક જાઅહાય ઉઠીન આખ્યાં, “ગેર યહૂદીયાહાલ સુન્નત કોઅના એને મૂસા નિયમ માનના આગના દાં જોજે.” ");
INSERT INTO gbl_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","તોવે પ્રેષિત એને વડીલ યે વાતહેબારામાય વિચાર કોઅરાહાટી યોકઠા જાયા. ");
INSERT INTO gbl_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","તોવે પિત્તરાય બોજ બોલા-બોલી ઓઅઇ ગીયા પાછે ઉઠીન ચ્યાહાન આખ્યાં, “ઓ બાહાહાય, તુમા જાંઅતાહા, કા બોજ દિહાહા પેલ્લા જાયા, કા પોરમેહેરે તુમહેમાઅને માન નિવડી લેદહો, કા માપાયને ગેર યહૂદી લોક હારી ખોબાર વોનાઈન બોરહો કોએ. ");
INSERT INTO gbl_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","એને મન પારાખનારા પોરમેહેરાય ચ્યાહાનબી આમે હારકા પવિત્ર આત્મા દેયને ચ્યેય દેખાડયાં કા ચ્યાય ગેર યહૂદી લોકહાન પોતાના લોકહા હારકા માની લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","એને બોરહો કોઅવાથી ચ્યાહા મન શુદ્ધ કોઇન આમહા માય એને ચ્યાહામાય કાયબી ભેદ નાંય રાખ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","તે આમી તુમા ઈ આખીન કાહા પોરમેહેરા પરીક્ષા કોઅતાહા, કા મૂસા નિયમ એને આમહે યહૂદી રીતરીવાજાહાન પાળાહાટી યા ગેર યહૂદી વિસ્વાસ્યાહાવોય વોદારે વોજો થોવા, જ્યાલ નાંય આમહે વડીલ ઉઠાવી હોક્યા એને નાંય આમા ઉઠાવી હોકજે. ");
INSERT INTO gbl_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","એહેકોય કોઅના ઠીક નાંય હેય, આમી ઓ નિર્ણય હેય કા જેહેકેન પ્રભુ ઈસુ સદા મોયાકોય આમહાન તારણ મિળ્યાં, ચ્યેજ રીતીકોય ચ્યાહાનબી મિળી.” ");
INSERT INTO gbl_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","તોવે બોદી સબા ઠાવકાજ રોયન બારનાબાસ એને પાઉલા વોનાયા લાગ્યા, કા પોરમેહેરાય ચ્યાહાકોય ગેર યહૂદી લોકહામાય કોહડે-કોહડે મોઠે ચિન્હે, એને ચમત્કારા કામે દેખાડયે. ");
INSERT INTO gbl_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","જોવે ચ્યા બોલી ચુક્યા તોવે યાકૂબ આખા લાગ્યો. “ઓ બાહાહાય, મા વોનાયા. ");
INSERT INTO gbl_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","સિમોન પિત્તરાય હોમજાડ્યા, કા પોરમેહેરાય પેલ્લાને-પેલ્લા કેહેકેન ગેર યહૂદીયાહાવોય કોહડી કૃપા કોઅયી કા ચ્યાહામાઅને કોલહાક લોકહાન પોતાના લોક બોના નિવડયા. ");
INSERT INTO gbl_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","એને યાકોઈન ભવિષ્યવક્તાહા વાતોબી મિળત્યોહો, જેહેકોય લિખલાં હેય, ");
INSERT INTO gbl_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘યા પાછે આંય પાછો યેયન દાઉદા રાજ્યા જીં ચ્યા દુશ્માનાહાય નાશ કોઅઇ દેનેલ ચ્યાલ આંય પાછો બોનાડીહી, એને પોડલો માંડવો પાછે આંય બોનાડીહી, એને ચ્યાલ ઉબો કોઅહી, ");
INSERT INTO gbl_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","યાહાટી કા બાકી બોદાજ લોક, બોદા ગેર યહૂદીયાહા હાતે, જ્યાહાલ માયે પોતાના લોક બોનાહાટી નિવડયાહા, પ્રભુલ હોદે, ");
INSERT INTO gbl_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ઓ તોજ પ્રભુ આખહે જો દુનિયા શુરવાત પાઅને યે વાતહે ખોબાર દેતો યેનહો.’ ");
INSERT INTO gbl_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","યાહાટી મા વિચાર ઓ હેય, કા ગેર યહૂદીયાહા માઅને જ્યા લોક પોરમેહેરાપાય યેતહા, ચ્યાહાન ઈ આખીન દુ:ખ મા દાહા, કા મૂસા નિયમ એને આમહે યહૂદી રીતિરીવાજાહાલ માનના જરુર હેય. ");
INSERT INTO gbl_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","બાકી ચ્યાહાન યોક ચિઠ્ઠી લોખી દોવાડા, ઈ આખાહાટી કા ચ્યા માહાં નાંય ખાય જીં લોકહાય મુર્તિહયેલ ચોડાવ્યાહા, વ્યબિચારાથી દુર રોય, ગોગી દાબીન માઅલા જોનાવરા માહાં નાંય ખાય એને જોનાવરહા લોય નાંય પિયે. ");
INSERT INTO gbl_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","કાહાકા પેલ્લા સમયથી શેહેરાહામાય મૂસા નિયમા પ્રચાર કોઅનારા ચાલી યેનહા, એને તી બોદાજ આરામા દિહાલ સોબાયે ઠિકાણામાય વાચવામાય યેહે.” ");
INSERT INTO gbl_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","તોવે યેરૂસાલેમ શેહેરામાય પ્રેષિત એને વડીલાહાય બોદી મંડળીઆરે આપહે માઅને કોલહાક માટડાહાલ નિવાડના નોક્કી કોઅયા, ચ્યાહાય યહૂદા, જો બારનાબાસ આખવામાય યેહે, એને સિલાસાલ નિવડયા, યા બેની વિસ્વાસ્યાહામાય બોજ માનાપાના આતા. ચ્યાહાન પાઉલ એને બારનાબાસાઆરે અન્તાકિયા શેહેરમાય દોવાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","એને ચ્યાહાય તી ચિઠ્ઠી ચ્યાહાઆરે લેય દોવાડયા જ્યામાય લોખાલા આતા, “અન્તાકિયા શેહેર, એને સિરીયા એને કિલિકિયા વિસ્તારામાય રોનારા ગેર યહૂદી વિસ્વાસ્યાહાલ, પ્રેષિત એને વડીલાહા સલામ. ");
INSERT INTO gbl_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","આમા વોનાયાહા, કા આમહામાને કોલહાક લોક તુમહેપાય યેનલા હેય, એને ચ્યાહાય તુમાહાલ ચ્યાહા વાતહેકોય ગાબરાવી દેના, એને તુમહે મન ઉલટાવી દેનહે બાકી આમહાય ચ્યાહાલ આગના નાંય દેનલી આતી. ");
INSERT INTO gbl_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","યાહાટી આમહાય યોક મોનાકોય હાચ્ચાં હોમજ્યા, એને આમાહાય કોલહાક માટડાહાલ નિવાડના નોક્કી કોઅયા એને ચ્યાહાન બારનાબાસ એને પાઉલા આરે તુમહેપાય દોવાડજે. ");
INSERT INTO gbl_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","યે તે ઓહડે માઅહે હેય, જ્યાહાય પોતાનો જીવ આંય પ્રભુ ઈસુ ખ્રિસ્તા નાંવા કોય મુશ્કીલમાય ટાક્યોહો. ");
INSERT INTO gbl_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","યાહાટી આમા તુમહાન ઈ આખાહાટી યહૂદા એને સિલાસાલ દોવાડી રીઅલા હેય કા આમહાય તુમહે સાવાલા બારામાય કાય નિર્ણય લેદલો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","પવિત્ર આત્માલ, એને આમહાનબી ઠીક માલુમ પોડ્યા કા યે જરુરી વાતહેલ છોડીન, તુમહાવોય આજુ વોજો નાંય ટાકે; ");
INSERT INTO gbl_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","તુમા ચ્યા માહાલ નાંય ખાઅના જીં લોકહાય મૂર્તિહયેન બેટ ચોડાવ્યાહા, વ્યબિચારાથી દુર રોજા, ગોગી દાબીન માઅલા જોનાવરહા માહાં નાંય ખાઅના એને જોનાવરહા લોય નાંય પીયના, જોવે તુમા યો વાતો માની લાહા તે તુમહે ભલા ઓઅરી, તુમા શાંત્યેથી રા.” ");
INSERT INTO gbl_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","પાછે ચ્યા છુટા પોડીન અન્તાકિયા શેહેરામાય પોઅચ્યા, એને સોબાયેલ બેગી કોયન ચ્યા પત્રાન ચ્યાહાન દી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","એને ચ્યે તી પત્ર વાચીન ચ્યા ઉપદેશા વાતહેકોય બોજ આનંદિત જાયે. ");
INSERT INTO gbl_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","એને યહૂદા એને સિલાસ જ્યા પોતેબી ભવિષ્યવક્તા આતા, ચ્યાહાય બોજ વાતહેકોય વિસ્વાસ્યાહાલ ઉપદેશ દેયન સ્થિર કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ચ્યા કોલહાક દિહી તાં રોયા, પાછે વિસ્વાસ્યાહાય ચ્યાહાન શાંત્યેથી વિદાય ઓઅના બોરકાત દેયને યેરૂસાલેમ મંડળ્યેમાય પાછા દોવાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","બાકી સિલાસે અન્તાકિયા શેહેરામાય રોઅના નોક્કી કોઅયા, ચ્યાહાટી યહૂદા યોખલોજ યેરૂસાલેમમાય પાછો જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","એને પાઉલ એને બારનાબાસ અન્તાકિયામાય રોય ગીયા, એને આજુ બિજા બોજ લોકહાઆરે પ્રભુ ઈસુ વચના સંદેશ દેતા એને હારી ખોબાર આખતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","કોલહાક દિહાકોય પાઉલાય બારનાબાસાલ આખ્યાં, “જ્યા-જ્યા શેહેરામાય આમહાય પ્રભુ વચન વોનાડલા આતા, યા, પાછે ચ્યામાય ચાલીન પોતાના વિસ્વાસ્યાહાલ એએ કા ચ્યા કોહડા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","તોવે બારનાબાસે યોહાનાલ જો માર્ક આખવામાય યેહે, આરે લેઅના વિચાર કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","બાકી પાઉલ ચ્યાલ જો પંફૂલિયા વિસ્તારામાય ચ્યાહાથી આલાગ ઓઈ ગીયેલ, એને કામાવોય ચ્યાઆરે નાંય ગીયો, ચ્યાલ આરે લેય જાયના હારાં નાંય હોમજ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","પાછે ઓહડી બોલા-બોલી ઓઅયી કા પાઉલ એને બારનાબાસ ચ્યા બેની યોકબિજાથી આલાગ ઓઈ ગીયા, એને બારનાબાસ, માર્કાલ લેઈને ઉડીવોય બોહીન સાઇપ્રસ બેટા એછે જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","પાઉલાય સિલાસાલ નિવડી લેદો, એને અન્તાકિયા શેહેરા વિસ્વાસ્યાહાલ પોરમેહેરા સદા મોયામાય હોઅપી દેના એને તો અન્તાકિયા શેહેરામાઅને જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","એને મંડળ્યેહે વિસ્વાસ્યાહાલ મજબુત કોઅતા, સિરીયા એને કિલિકિયા વિસ્તારામાઅને રોયન ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","પાછા પાઉલ એને સિલાસ દિરબે એને લુસ્ત્રા શેહેરામાયબી ગીયા, એને ચ્યા તિમોથી નાંવા યોક શિષ્ય આતો, ચ્યા આયહો યહૂદી વિસ્વાસી આતી, બાકી ચ્યા આબહો ગેર યહૂદી યુનાન દેશા રોનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","તે લુસ્ત્રા એને ઈકુનિયામ શેહેરાહા વિસ્વાસીયાહા માય ચ્યા સાક્ષી હારી આતી. ");
INSERT INTO gbl_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","પાઉલા ઇચ્છા આતી કા તો ચ્યાઆરે જાય, એને જ્યા ગેર યહૂદી લોક ચ્યા જાગામાય આતા ચ્યાહા લીદે ચ્યાલ લેયને ચ્યા સુન્નત કોઅયી, કાહાકા ચ્યે બોદે જાંઅતે આતેં, ચ્યાહા આબહો યુનાન દેશા રોનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","પાઉલ એને ચ્યા હાંગાત્યા શેહેર-શેહેર જાતા ચ્યે વિદ્યેહેન જ્યો યેરૂસાલેમ શેહેરમાય પ્રેષિત એને વડીલાહાય ઠોરાવલી આતી, માનાહાટી વિસ્વાસ્યાહાન પોઅચાડવામાય જાતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","યેજપરમાણે મંડળ્યો બોરહામાય મજબુત ઓઅત્યો ગીયો એને સંખ્યામાય રોજદીને વોદત્યો ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","એને પાઉલ, સિલાસ એને તિમોથી ચ્યા ફ્રુગીયા એને ગલાતીયા વિસ્તારામાઅને રોયન ગીયા, કાહાકા પવિત્ર આત્માય ચ્યાહાન આસિયા વિસ્તારામાય વચન પ્રચાર કોઅના મોનાય કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","એને ચ્યાહાય મુસીયા વિસ્તારા પાહી પોઅચીન, બિથુનિયા વિસ્તારામાય જાયના વિચાર્યા, બાકી ઈસુ આત્માય ચ્યાહાન જાં નાંય દેના. ");
INSERT INTO gbl_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","પાછે ચ્યા મુસીયા વિસ્તારામાઅને ઓઇન ત્રોઆસ શેહેરામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","તાં પાઉલે રાતી યોક દર્શન એઅયા કા યોક મોકોદુનિયા વિસ્તારામાય રોનારા યોક માઅહું ઉબા આતા, એને તો ચ્યાલ વિનાંતી કોઇન આખહે કા, “દોરિયા ચ્યે કાની ઉતીન મોકોદુનિયા માય યે, એને આમે મોદાત કોઓ.” ");
INSERT INTO gbl_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ચ્યા ઈ દર્શન દેખીન આમહાય તારાતુજ મોકોદુનિયા વિસ્તારામાય જાઅના વિચાર્યા, ઈ હોમજીન કા પોરમેહેરાય આમહાન ચ્યાહાન હારી ખોબારે સંદેશ દાંહાટી હાદ્યાહા. ");
INSERT INTO gbl_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","યાહાટી ત્રોઆસ શેહેરામાઅને જાહાજા માય બોહીન આમા હિદા સુમાત્રા બેટવોય એને બીજે દિહી નિયાપુલિસ શેહેરામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","તાઅને આમા ફિલિપ્પી શેહેરામાય પોઅચ્યા, જીં મોકોદુનિયા વિસ્તાર માઅને શેહેર, એને રોમ્યાહા વોહતી હેય, એને આમા ચ્યા શેહેરામાય કોલહાક દિહીહુદુ રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","આરામા દિહે આમા શેહેરા ફાટકે બારે નોયે મેરે ઈ હોમજીન ગીયા કા તાં યહૂદીયાહા પ્રાર્થના કોઅના જાગો ઓરી, એને બોહીન ચ્યે થેઅયેહેઆરે જ્યો યકઠયો જાયલ્યો આત્યો, વાતો કોઅરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","એને લુદીયા નાંવા થુવાતીર શેહેરા જાંબળા રોંગા ડોગલેં વેચનારી યોક પોરમેહેરા આરાધના કોઅનારી થેએ વોનાય રીયલી આતી, એને પ્રભુય ચ્યે મોન ખુલ્યા, કા પાઉલા વાતેહેવોય ધ્યાન દેય. ");
INSERT INTO gbl_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","એને જોવે ચ્યેય ચ્યે કુટુંબ હાતે બાપતિસ્મા લેદા, તોવે ચ્યેય વિનાંતી કોઅયી, “જો તું માન પ્રભુવા વિસ્વાસીની હોમાજતોહો, તે ચાલીન મા ગોઆમાય રા,” એને તી આમહાન માનાડી લેય ગીયી. ");
INSERT INTO gbl_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","જોવે આમા પ્રાર્થના કોઅના જાગાવોય જાય રીઅલે આતેં, તોવે આમહાન યોક દાસી મિળી, જ્યેમાય યોક ઓહડો બુત આતો, ચ્યા મોદાતકોય તી ભવિષ્ય પ્રગટ કોઅઇ દેતી આતી, એને તી ભવિષ્ય પ્રગટ કોઅવાથી ચ્યે માલિકાહા હાટી ઘોણા કાય કામાવી લેય યા આતી. ");
INSERT INTO gbl_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","તી પાઉલા એને આમહે પાહલા યેઇન બોંબલા લાગી, “યે માઅહે પરમપ્રધાન પોરમેહેરા દાસ હેય, જ્યા તુમાહાલ તારણા વાટ દેખાડતાહા.” ");
INSERT INTO gbl_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","તી બોજ દિહી લોગુ એહકોયજ કોઅતી રિયી, બાકી પાઉલ હેરાન જાયો, એને ફિરીન ચ્યા બુતાલ આખ્યાં, “આંય તુલ ઈસુ ખ્રિસ્તા નાંવા કોઅઇ આગના દેતહાવ, કા ચ્યેમાઅને નિંગી જો એને તી ચ્યેજ ગેડી નિંગી ગીયા.” ");
INSERT INTO gbl_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","જોવે ચ્યે માલિકાહાય દેખ્યા, કા આમહે કામાણ્યે આશા જાતી રીયહી, તોવે પાઉલાલ એને સિલાસાલ દોઇન ચોકામાય પ્રધાનાહા પાય ખેચી લી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","એને ચ્યાહાન ન્યાય કોઅનારા ઓદિકાર્યાહા પાય લી જાયને આખ્યાં, “યે માઅહે જ્યેં યહૂદી હેય, આમહે શેહેરામાય બોજ ગરબડ કોઅઇ રીયહે. ");
INSERT INTO gbl_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","એને ઓહડયો રીત્યો આખી રીયહે, જ્યાહાલ ગ્રહણ કોઅના કા માનના આમા રોમી નાગરીકાહા હાટી ઠીક નાંય હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","તોવે ટોળા લોક પાઉલ એને સિલાસા વિરુદમાય યોકઠા ઓઇન ચ્યાહાપાય યેના, એને ન્યાય કોઅનારા ઓદિકારી લોકહાય ચ્યાહા ડોગલેં ફાડીન કાડી ટાક્યેં, એને ચ્યાહાન ફટકાથી ઠોકના આગના દેની. ");
INSERT INTO gbl_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","એને બોજ ફટકાથી ઠોકીન ચ્યાહાય ચ્યાહાન જેલેમાય કોંડી દેના એને દ્વારપાલાલ આગના દેની કા ચ્યાહાવોય નોજાર રાખે. ");
INSERT INTO gbl_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ચ્યાય ઓહડી આગના વોનાયને ચ્યાહાન માજેને ખોલ્યેમાય રાખ્યાં એને ચ્યાહા પાગહાલ લાકડા બેડયેહે માય બાંદી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","આરદી રાતી લગભગ પાઉલ એને સિલાસ પ્રાર્થના કોઅતા પોરમેહેરા સ્તુતિ ગીતે આખતા આતા, એને જેલ્યા ચ્યાહા વોનાય રીયલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","કા ઓલહામાય યોકદાજ યોક મોઠો દોરતીકંપ જાયો, ઓલે હુદુ કા જેલે પાયો બી આલી ગીયો, એને તારાત બોદા દરવાજા ખુલી ગીયા, એને બોદહા બંધન ખુલી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","એને દ્વારપાળ જાગી ઉઠયો, એને જેલે દરવાજા ખુલ્લાં દેખીન હોમજ્યો કા જેલ્યા નાહી ગીયા, તોવે ચ્યાય પોતે તારવાય લેઈને પોતાનાલ માઆઇ ટાકના વિચાર્યા. ");
INSERT INTO gbl_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","બાકી પાઉલે ઉચા આવાજા કોય બોંબલીન આખ્યાં, “પોતે પોતાલ કાય નુકસાન નાંય કોઅના, કાહાકા આમા બોદા ઈહીંજ હેજે.” ");
INSERT INTO gbl_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","તોવે તો દિવો માગીન માજે દાંહાદી ગીયો, એને કાપતોજ પાઉલ એને સિલાસા આગલા પોડયો. ");
INSERT INTO gbl_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","એને ચ્યાહાન બારે લેય યેયન આખ્યાં, “ઓ સાયબાહાય, તારણાહાટી આંય કાય કોઉ?” ");
INSERT INTO gbl_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ચ્યાહાય આખ્યાં, “પ્રભુ ઈસુ ખ્રિસ્તાવોય બોરહો કોઓ, તોવે તું એને તો ગોર્યાહા તારણ ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","એને ચ્યાહાય ચ્યાલ એને ચ્યા બોદા ગોઅને લોકહાન પ્રભુ વચન વોનાડયા. ");
INSERT INTO gbl_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","એને રાતી ચ્યેજ ગેડી ચ્યે ચ્યાહાન ગોઓ લેય જાયને ચ્યાહા જ્યા ઘાવ આતા ચ્યા દોવ્યા, એને ચ્યાય પોતાના બોદા ગોર્યાહા હાતે તારાત બાપતિસ્મા લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","એને ચ્યાય ચ્યાહાન પોતાના ગોઆમાય લેય જાયન, ચ્યાહાન ખાઅના ખાવાડ્યા, એને બોદા ગોર્યાહા આરે પોરમેહેરાવોય બોરહો કોઇન બોજ આનંદ કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","બિજો દિહી જાયો તોવે ન્યાય કોઅનારા ઓદિકાર્યાહાય જેલે સીપાડાલ આખી દોવાડયા કા ચ્યા માઅહાલ છોડી દા. ");
INSERT INTO gbl_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","દ્વારપાળે યો વાતો પાઉલાલ આખી દેખાડયો, “ન્યાય કોઅનારા ઓદિકાર્યાહાય તુમહાન છોડી દેયના આગના દોવાડી દેનલી હેય, યાહાટી આમી નિંગીન શાંતિથી જાતા રા.” ");
INSERT INTO gbl_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","બાકી પાઉલે ચ્યાહાન આખ્યાં, “ચ્યાહાય આમહાન જ્યા રોમ દેશા રોનારે માઅહે હેય, દોષી ઠોરાવ્યા વોગાર લોકહા હામ્મે ઠોક્યાં એને જેલેમાય ટાક્યા, આમી કાય આમહાન દોબીન દોવાડી રીયહે? એહેકોય નાંય, બાકી ચ્યા પોતે યેયન આમહાન બારે લેય જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","સીપાડાહાય યો વાતો ન્યાય કોઅનારા ઓદિકાર્યાહાન આખી દેન્યો, એને ચ્યા ઈ વોનાઈન કા પાઉલ એને સિલાસ રોમ દેશા રોનારા હેતા, બિઇ ગીયા, ");
INSERT INTO gbl_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","એને યેયન ચ્યાહાય ચ્યાહાપાય માફી માગી, એને બારે લી જાયના વિનાંતી કોઅયી, કા શેહેરામાઅને જાતા રા. ");
INSERT INTO gbl_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","પાઉલ એને સિલાસ જેલેમાઅને નિંગીન લુદીયા ગોઓ ગીયા, એને વિસ્વાસ્યાહાલ મિળીન ચ્યાહાન ઉત્તેજન દેયને તાઅને જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","પાછે પાઉલ એને સિલાસ અમ્પિપુલીસ શેહેર એને અપ્પુલોનિયા શેહેરમાઅને થેસ્સાલોનિકા શેહેરામાય યેના, જાં યહૂદીયાહા યોક સોબાયે ઠિકાણ આતા. ");
INSERT INTO gbl_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","એને પાઉલ ચ્યા કાયામની આદાતે પરમાણે ચ્યાહાપાય ગીયો, તીન આરામા દિહીહુદુ ચ્યાહાઆરે પવિત્રશાસ્ત્રા માઅને વાતહેકોય બોલા-બોલી કોઅઇ. ");
INSERT INTO gbl_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","એને હોમજાડી રિઅલો આતો એને સાબિત કોઅય રિઅલો આતો કા ખ્રિસ્તા દુ:ખ વેઠના, એને મોઅલા માઅને જીવી ઉઠના, નોક્કીજ આતા, “ઓ ઈસુ જ્યા બારામાય આંય તુમહાન સંદેશ આખતાહાવ, તો ખ્રિસ્ત હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ચ્યાહામાઅને કોલાહાક યહૂદીયાહાય, એને પોરમેહેરા બિક રાખનારા યુનાની લોક, એને બોજ બોદયે પ્રમુખ થેઅયેહેયબી બોરહો કોઅયો એને ચ્યે પાઉલા એને સિલાસા આરે મિળી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","બાકી યહૂદીયાહાય ખિજવાઈન આટામાઅને લોકહાન કોલહાક ખારાબ માઅહાલ ચ્યાહાઆરે લેદા, એને લોકહાન ટોળો કોઇન શેહેરામાય દંગો કોઅરા લાગ્યા, એને ચ્યાહાય પાઉલા એને સિલાસાલ હોદાહાટી યાસોના ગોઆવોય હમલો કોઇન પાઉલા એને સિલાસાલ લોકહા હામ્મે લેય યેયના વિચાર્યા. ");
INSERT INTO gbl_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","એને ચ્યાહાન નાંય મિળ્યાં, ચ્યા ઈ બોંબાલતાજ યાસોન એને કોલહાક વિસ્વાસ્યાહાલ શેહેરા ન્યાય કોઅનારા ઓદિકાર્યાહા હામ્મે ખેચી લેય યેના, “યા લોક જ્યાહાય બોદેજ જાગે પરેશાની ફેલાડી દેનહી, ઈહીંબી યેનહા. ");
INSERT INTO gbl_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","એને યાસોને ચ્યાહાન ચ્યા ગોઓ રોઅના જાગો દેનહો, એને યા બોદા લોક કૈસરા કાયદાહા વિરોદ કોઅતાહા એને આખતેહે કા ઈસુ નાંવા બિજો કાદો રાજા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","જોવે લોકહા ગીરદી એને શેહેરા ન્યાય કોઅનારા ઓદિકારી યો વાતો વોનાયા, તોવે ચ્યા ખિજવાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","એને ચ્યાહાય યાસોન એને બિજા લોકહાન જામીન વોય છોડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","વિસ્વાસ્યાહાય તારાત રાતીન-રાતી પાઉલાલ એને સિલાસાલ બિરીયા શેહેરમાય દોવાડી દેના, એને ચ્યા તાં પોઅચ્યા પાછે યહૂદીયાહા સોબાયે ઠિકાણામાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","યા લોક તે થેસ્સાલોનિક શેહેરા યહૂદીયાહાથી વદારે હારાં આતા, એને ચ્યાહાય હાચ્ચે મોનાકોય વચન વોનાય લેદેલ, એને રોજ દિને પવિત્રશાસ્ત્રામાય હોદતા રિયા કા યો વાતો એહકોયજ હેત્યો કા નાંય. ");
INSERT INTO gbl_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","યાહાટી ચ્યાહામાઅને બોજ જાઅહાય એને યુનાની આબરૂદાર થેઅયેહે માઅને એને માટડાહામાઅનેબી બોજ જાઅહાય બોરહો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","બાકી જોવે થેસ્સાલોનિક શેહેરા યહૂદી લોક જાંઆય ગીયા કા પાઉલ બિરીયા શેહેરામાયબી પોરમેહેરા વચન આખહે, તે તાં બી યેયન લોકહાન ઉસરાવાં એને ભરમાવા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","તોવે વિસ્વાસ્યાહાય પાઉલાલ તારાતુજ દોવાડી દેનો કા દોરિયા મેરે જાતો રોય, બાકી સિલાસ એને તિમોથી બિરીયામાયજ રોય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ચ્યા લોક જ્યા પાઉલાલ લેય જાય રીઅલા આતા ચ્યા હાતે એથેન્સ શેહેરા લોગુ ગીયા, એને પાઉલા યે આગનાયે હાતે ચ્યા બિરીયા ફિરી ગીયા કા સિલાસ એને તિમોથીલ જલદી ચ્યાપાય દોવાડી દેય. ");
INSERT INTO gbl_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","જોવે પાઉલ એથેન્સ શેહેરામાય ચ્યાહા વાટ જોવતો આતો, તોવે શેહેરાલ મુર્તિહીથી બોઆલા દેખીન ચ્યા આત્મામાય બોજ દુઃખી જાયો. ");
INSERT INTO gbl_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","યાહાટી તો સોબાયે ઠિકાણામાય યહૂદીયા એને પોરમેહેરા બિક રાખનારા ગેર યહૂદી લોકહાન એને બાજારામાય જ્યા લોક મિળતા આતા, ચ્યાહા હાતે દિનેરોજ બોલા-બોલી કોઅયા કોઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","તોવે ચ્યા પુંજારા જ્યા ઈપિકુરી એને સ્તોઈકી કોય જાંઅતાહા ચ્ચા હિકાડનારા માસ્તાર ગોણવામાય યેત ચ્યાહામાઅને કોલહાક ચ્યા હાતે બોલા લાગ્યા, એને કોલહાક લોકહાય આખ્યાં, “ઓ બકવાસ્યો કાય આખા માગહે?” બાકી બીજહાંય આખ્યાં, “તો પારકા દેવતાહા પ્રચાર કોઅનારો માલુમ પોડહે,” ચ્યાહાય ઈ યાહાટી આખ્યાં કાહાકા તો ઈસુવા એને ચ્યા મોઅલા માઅને પાછા જીવી ઉઠના બારામાય હારી ખોબાર વોનાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","તોવે ચ્યા ચ્યાલ ચ્યાહાજ આરે અરિયુપગુસ નાંવા સોબાયે ઠિકાણે લેય ગીયા એને પુછ્યાં, “કાય આમા જાંઆય હોકજેહે, કા ઓ નોવો સંદેશ જો તું વોનાડતોહો, કાય હેય? ");
INSERT INTO gbl_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","કાહાકા તું નોવાયે વાતો આમહાન વોનાડતોહો, યાહાટી આમા જાંઅરા માગતાહા કા યા મોતલાબ કાય હેય?” ");
INSERT INTO gbl_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","(યાહાટી કા બોદા એથેન્સમાંય રોનારા એને પારદેશી જ્યેં તાં રોતે આતેં ચ્યાહાન ચ્યાહા બોદો સમય નવી-નવી વાતો આખના એને વોનાયા હાટી વિતાવના પોસંદ હેય.) ");
INSERT INTO gbl_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","તોવે પાઉલે અરિયુપગુસ નાંવા યોક સોબાયે ઠિકાણા વોચમાય ઉબો રોયન આખ્યાં, ઓ એથેન્સના લોકહાય, આંય એઅતાહાવ કા તુમા બોદયે વાતહેમાય દેવતાહાલ વોદારે માનનારે હેતેં. ");
INSERT INTO gbl_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","કાહાકા આંય ફિઅત્યે વેળે તુમહે પૂજા કોઅના વાનાહાલ આંય એઅતો આતો, તોવે માયે યોક ઓહડી વેદિબી દેખી, જ્યેવોય લોખલાં આતા, ઓજાણ્યા દેવાહાટી, યાહાટી જ્યા તુમા જાંઅયા વોગાર આરાધના કોઅતાહા, આંય તુમહાન ચ્યા બારામાય હારી ખોબાર આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","જ્યા પોરમેહેરાય દોરતી એને ચ્યેવોયને બોદયે વસ્તુહુલ બોનાડયાહા, તો હોરગ્યા એને દોરત્યે માલિક ઓઇન આથેકોય બોનાવલા મંદિરામાય નાંય રોય. ");
INSERT INTO gbl_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","નાંય કાદીબી વસ્તુહુ ગોરજેહાટી ચ્યાલ માઅહા મોદાતે ચ્યાલ ગોરાજ નાંય હેય, કાહાકા તો પોતેજ બોદહાલ જીવન એને શ્વાછ એને બોદાંજ કાય દેહે. ");
INSERT INTO gbl_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ચ્યાય યોકુજ માઅહાથી માઅહા બોદી જાત્યો બોદયે દોરત્યેવોય રાંહાટી બોનાડીહી, એને ચ્યા ઠરાવલા સમય એને રોઅના હોદ યાહાટી બાંદહી, ");
INSERT INTO gbl_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","પોરમેહેરે એહેકેન યાહાટી કોઅયા કા લોક ચ્યાલ હોદે, એને બોની હોકે ચ્યા ચ્યાપાય પોઅચી હોકે, એને તેરુંબી તો આમહે માઅને કાદાથી દુર નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","કાહાકા આમા ચ્યામાય જીવતા રોતહા, એને ચાલતાહા-ફિરતાહા, એને ચ્યામાય મજબુત રોજહે. ઠીક તેહેકોયજ જેહેકોય તુમહે કોલાહાક કવી લોકહાયબી આખ્યાહા, “આમા તે ચ્યાજ કુળા બી હેજે.” ");
INSERT INTO gbl_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","કાહાકા આમા પોરમેહેરા પોહેં હેજે યાહાટી આમહાન ઈ કોયદિહી વિચાર નાંય કોઅરા જોજે કા પોરમેહેર, હોના કા ચાંદ્યે કા દોગાડા હારકો હેય, જીં માઅહા આથાકોય એને વિચારાહાકોયન બોનાડયાહા. ");
INSERT INTO gbl_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","આમી લોગુ પોરમેહેરે લોકહા અજ્ઞાનતાના સમાયાવોય દિયાન નાંય દેના, બાકી આમી બોદે જાગે બોદાજ માઅહાલ પાપ કોઅના બંદ કોઅના આગના દેહે. ");
INSERT INTO gbl_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","કાહાકા ચ્યાય યોક દિહી નોક્કી ઠોરવ્યોહો, ચ્યામાય તો આખા દુનિયા ન્યાય કોઅરી, પોરમેહેરે ચ્યાલ મોઅલા માઅને પાછો જીવતો ઉઠાડીન બોદા લોકહાન યે વાતે સાબિતી દેય દેનહી. ");
INSERT INTO gbl_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","મોઅલા માઅને પાછા જીવી ઉઠના વાત હાંબળીન કોલાહાક તે મશ્કરી કોઅરા લાગ્યા, એને બીજહાંય આખ્યાં, “ઈ વાત આમા તોપાઅને પાછા કોવેતેબી વોનાયુહું.” ");
INSERT INTO gbl_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","યાવોય પાઉલ ચ્યાહા વોચમાઅને નિંગી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","બાકી કોલાહાક લોક ચ્યાઆરે મિળી ગીયા, એને ચ્યાહાય બોરહો કોઅયો, જ્યામાય દિયુનુસીયુસ જો અરિયુપગુસા સભ્ય આતો, એને દમરિસ નાંવા યોક થેએ આતી, એને ચ્યાઆરે બીજાબી કોલહાક લોક આતા. ");
INSERT INTO gbl_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","યા પાછે પાઉલ એથેન્સ શેહેર છોડીન કરિંથ શેહેરામાય યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","એને તાં અકુલાસ નાંવા યોક યહૂદી મિળ્યો, જ્યા જન્મો પુન્તુસ વિસ્તારામાય ઓઅયેલ, તો ચ્યા થેએ પ્રિસ્કીલા આરે ઇટલી વિસ્તારામાઅને આમહીજ યેનલો આતો, કાહાકા સમ્રાટ ક્લોદિયુસ બોદા યહૂદીયાહાલ દંગો કોઅવાથી રોમમાઅને કાડી દેનેલ, યા લીદે ચ્યા કરિંથ શેહેરામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","પાઉલ ચ્યાહાન મિળાં ગીયો કાહાકા ચ્યે ચ્યા હારકાજ માંડવા બોનાડનારે આતેં, ચ્યાહાટી તો ચ્યાહાઆરે રોયન કામ કોઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","એને પાઉલ બોદાંજ આરામા દિહાલ સોબાયે ઠિકાણાહામાય બોલા-બોલી કોઇન યહૂદીયાહાલ એને યુનાન્યાહ્યાલબી ઈસુ ખ્રિસ્તાવોય બોરહો કોઅરાહાટી હુમજાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","જોવે સિલાસ એને તિમોથી મોકોદુનિયા વિસ્તારામાઅને યેના, તોવે પાઉલે માંડવા બોનાડના બંદ કોઅઇ દેના એને તો વચન હમજાડના દુંદમાય લાગીન યહૂદીયાહાલ સાક્ષી દેતો આતો કા ઈસુ ઓજ ખ્રિસ્ત હેય. ");
INSERT INTO gbl_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","બાકી જોવે યહૂદી પાઉલા વિરુદ એને નિંદા કોઅરા લાગ્યા, તોવે ચ્યાય પોતાના ફાડકે ઝટકિન ચ્યાહાન આખ્યાં, “યા ડોંડ તુમાંજ બોગવાહા, આંય તે નિર્દોષ હેતાંવ, આમીને આંય ગેર યહૂદી લોકહામાય પોરમેહેરા સંદેશ પ્રચાર કોઅહી.” ");
INSERT INTO gbl_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","એને સોબાયેહે ઠિકાણા માઅને નિંગીન તો તીતુસ યુસ્તસ નાંવા પોરમેહેરા યોક ભક્તિ કોઅનારા ગોઅમે ગેર યહૂદી લોકહાન હિકાડાં યેનો, જ્યા ગુઉ સોબાયે ઠિકાણાલ લાગલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","તોવે સોબાયે ઠિકાણા આગેવાન ક્રિસપુસે ચ્યા પુરાં ગોર્યાહા હાતે પ્રભુવોય બોરહો કોઅયો, એને બોજ કરિંથ માયનાહાય વોનાયને બોરહો થોવ્યો એને બાપતિસ્મા લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","એને પ્રભુય રાતી દર્શન દેયને પાઉલાલ આખ્યાં, “બીયહે મા, બાકી જો આખતો રો એને ઠાવકો મા રોહે. ");
INSERT INTO gbl_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","કાહાકા આંય તોઆરે હેય, એને કાદોબી તોવોય હમલો કોઇન તો નુકસાન નાંય કોઅરી, કાહાકા યા શેઅરામાંય બોજ લોક હેતા જ્યા માયેવોય બોરહો કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","યાહાટી પાઉલ ચ્યાહામાય પોરમેહેરા વચન હિકાડતો ડોડ વોરહા હુદી રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","જોવે ગાલીયો આખાયા વિસ્તારા ઓદિકારી આતો, તોવે યહૂદી લોક એકી કોઇન પાઉલા વિરુદ ઓઅઇ ગીયા, એને ચ્યાલ ન્યાય દેઅના જાગા હામ્મે લેય યેયન આખા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","“ઓ લોકહાન હુમજાડેહે, કા પોરમેહેરા ભક્તિ ઓહડયે રીતે કોઅયા, જીં મૂસા નિયમાહા ઉલટાં હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","જોવે પાઉલ આજુ બોલના તિયારીમાય આતો, તોવે ગાલીયેય યહૂદીયાહાલ આખ્યાં, “ઓ યહૂદીયાહાય, જો ઈ તે કાય અન્યાય કા ખારાબ વાત ઓઅતી તોવે યોગ્ય આતા કા આંય તુમહે વોનાતો. ");
INSERT INTO gbl_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","બાકી જો ઈ બોલાબોલી શબ્દા, એને નાંવહા, એને તુમહે ઇહિને મૂસા નિયમાહા બારામાય હેય, તે તુમાંજ જાંઆ, કાહાકા આંય યે વાતહે ન્યાયી બોના નાંય માગુ.” ");
INSERT INTO gbl_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","એને ગાલીયેય ચ્યાહાન ન્યાય કોઅના જાગા ઇહિને બારે કાડી દેવાડયા. ");
INSERT INTO gbl_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","તોવે બોદા લોકહાય સોબાયેહે ઠિકાણા આગેવાન સોસ્થેનેસાલ દોઇન ન્યાયા જાગા હામ્મે ઠોક્યાં, બાકી ગાલીયાય યે વાતે કાયજ ચિંતા નાંય કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","પાઉલ બોજ દિહાહા હુદી કરિંથ શેહેરામાય રિયો. પાછે વિસ્વાસ્યાહાથી છુટો પોડીન કિંખ્રિયા શેહેરામાય જાતો રિયો, ચ્ચા શેહેરામાય પાઉલે ચ્ચા ટોલપી ટાલી કોઆડી લેદી. કાહાકા ચ્ચાય યોક માનતા લેદલા આતા, પાછે દોરિયામાઅને સિરીયા વિસ્તારા એછે જાતો રિયો, ચ્ચાઆરે પ્રિસ્કીલા એને અકુલાસબી આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","જોવે ચ્યે એફેસુસ શેહેરામાય ગીયે તાં પાઉલાય પ્રિસ્કીલા એને અકુલાસાલ છોડયે, જોવે પાઉલ તાં આતો તોવે તો સોબાયે ઠિકાણામાય જાયને યહૂદીયાહા આરે વાત કોઅરા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","જોવે ચ્યાય મોનાય કોઅય દેના તોવે લોકહાય ચ્યાલ વિનાંતી કોઅઇ, “આમહે આરે આજુ કોલહાક દિહી રો.” તોવે તો નાંય માન્યો. ");
INSERT INTO gbl_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","બાકી ઈ આખીન ચ્ચાહા પાઅને નિંગી ગીયો, “જો પોરમેહેરા મોરજી ઓરીતે આંય તુમહાપાય પાછો યીહીં,” તોવે તો એફેસુસ શેહેરા જાહાજા માય બોહીન જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","એને કૈસરીયા શેહેરામાય ઉતીન (યેરૂસાલેમ શેહેરામાય) ગીયો એને ચ્ચે મંડળીલ મિળીન અન્તાકિયા શેહેરામાય યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","પાછા કોલહાક દિહી અન્તાકિયા શેહેરામાય રોયન તાઅને જાતો રિયો, એને આજુ યોક્યેકાનીને ગલાતીયા ભાગામાય એને ફ્રુગીયા વિસ્તારા બોદા શિષ્યાહાન મજબુત કોઅતો ફિર્યો. ");
INSERT INTO gbl_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ચ્યે સમયે અપુલ્લોસ નાંવા યોક યહૂદી જ્યા જન્મો સિકન્દરિયા શેહેરામાય ઓઅયેલ, જો બોજ જાંઆનારો માઅહું આતો, એને પવિત્રશાસ્ત્રાલ હારેં રીતે જાંઅતો આતો, તો એફેસુસ શેહેરામાય યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ચ્યાય પ્રભુવા વાટે બારામાય શિક્ષણ મેળાવલા આતા, એને મોન લાવીન ઈસુવા બારામાય ઠીક-ઠીક વોનાડતો એને હિકાડતો આતો, બાકી તો ખાલી યોહાના બાપતિસ્મા વાત જાંઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","તો સોબાયે ઠિકાણામાય બિક વોગાર બોલા લાગ્યો, જોવે પ્રિસ્કીલા એને અકુલાસ ચ્યા વાતો વોનાયને ચ્ચાલ ચ્ચાહા ગોઓ લેય યેને એને પોરમેહેરા વાટે બારામાય ચ્યાહાય આજુ વદારી ઉંડેથી હમજાડયા. ");
INSERT INTO gbl_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","એને જોવે અપુલ્લોસાય નોક્કી કોઅયા કા આખાયા વિસ્તારામાય જાય તોવે વિસ્વાસ્યાહાય ચ્ચાલ ઈંમાત દેયન શિષ્યાહાન લોખ્યાં કા ચ્યા ચ્યાલ હારેરીતે મીળે, એને તો તાં પોઅચીન ચ્યા લોકહા બોજ મોદાત કોઅયી, જ્યાહાય ચ્યા સદા મોયા લીદે બોરહો કોઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","અપુલ્લોસાય ચ્ચા તાકાત એને ઇંમાતથી યહૂદીહાન જાહીર રુપામાય બોલતા બંદ કોઅઇ દેના, પવિત્રશાસ્ત્રા માઅને સાબિતી દેય-દેયન કા ઈસુ ઓજ ખ્રિસ્ત હેય. ");
INSERT INTO gbl_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","જોવે અપુલ્લોસ કરિંથ શેહેરામાય આતો, તોવે પાઉલ આંદારન્યા વિસ્તારામાઅને મુસાફીરી કોઇન એફેસુસ શેહેરામાય યેનો, એને તાં કોલહાક શિષ્યહાન મિળ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ચ્યાય આખ્યાં, “કાય તુમહાય બોરહો કોઅયો તોવે પવિત્ર આત્મા મિળ્યાં?” ચ્યાહાય ચ્યાલ આખ્યાં કા, “આમહાય તે પવિત્ર આત્મા બારામાય વાત બી નાંય વોનાયાહા.” ");
INSERT INTO gbl_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","પાઉલે ચ્યાહાન આખ્યાં, “તે પાછે તુમહાય કોઅયેહે રીત્યેકોય બાપતિસ્મા લેદા?” ચ્યાહાય આખ્યાં, “આમહાય તી બાપતિસ્મા લેદા જીં યોહાન દેતો આતો.” ");
INSERT INTO gbl_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","પાઉલે આખ્યાં, “યોહાને ચ્યા લોકહાન બાપતિસ્મા દેના જ્યાહાય પાપ કોઅના બંદ કોઅય દેના એને પોરમેહેરાએછે ફિર્યા, બાકી ચ્યાય ઈસરાયેલ લોકહાન આખ્યાં કા ચ્યા ઈસુવોય બોરહો કોએ જો ચ્યા પાછે યેનારો હેય, જો ખ્રિસ્ત હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ઈ વોનાયને ચ્યાહાય પ્રભુ ઈસુવા નાવામાય બાપતિસ્મા લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","એને જોવે પાઉલે ચ્યાહાવોય આથ થોવ્યા, તોવે ચ્યાહાન પવિત્ર આત્મા મિળ્યાં, એને ચ્યા આલાગ-આલાગ ભાષા બોલા એને ભવિષ્યવાણી કોઅરા લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ચ્યા બોદા બારા માટડા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","એને તોવે પાઉલ સોબાયે ઠિકાણામાય જાયને તીન મોયના લોગુ બિઅયા વોગાર બોલતો રિયો, એને પોરમેહેરા રાજ્યા બારામાય બોલા-બોલી કોઅતો એને હુમજાડતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","બાકી કોલહાક લોકહાય કોઠાણ મોના ઓઇન બોરહો કોઅના નાકાર કોઅઇ દેના, બાકી લોકહા હામ્મે પ્રભુવા વાટે બારામાય ખારાબ આખા લાગ્યા, તોવે ચ્યાય ચ્યાહાલ તાંજ છોડીન શિષ્યાહાન આલાગ કોઅઇ લેદા, એને દિનેરોજ તુરેન્નુસ શાળેમાય હિકાડયાં કોઅતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","બેન વોરહા હુદુ ઈંજ ઓઅતા રોયા, ઓલે હુદુ કા આસિયા વિસ્તારામાય રોનારા કાય યહૂદી, કાય ગેર યહૂદી બોદહાય પ્રભુ વચન વોનાય લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","એને પોરમેહેર પાઉલા દ્વારા સામર્થ્યા ગોત્યેવાળે કામે દેખાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ઓલે લોગુ કા રુંબાળ એને ફાડકો ચ્યાહા આંગાલ લાવીન બીમાર્યાહાવોય ટાકતા આતા, એને ચ્ચે ચ્યાહા બીમાર્યેહેથી હારાં ઓઅઇ જાતે આતેં, એને બુતડે નિંગી જાયા કોઅતે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","બાકી કોલહાક યહૂદી જ્યા બુતડે કાડતા ફિરતા આતા, ચ્યા ઈ કોઅરા લાગ્યા કા જ્યાહામાય બુતડે રોતે આતેં ચ્યાહાન પ્રભુ ઈસુવા નાવાકોય ઈ આખીન કાડા લાગ્યા, “જ્યા ઈસુવા પ્રચાર પાઉલ કોઅહે, આમા તુમહાન બારે યા આગના દેજહે.” ");
INSERT INTO gbl_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","એને સ્કેવા નાંવા યોક યહૂદી મુખ્ય યાજકા હાંત પોહા આતા, ચ્યાબી એહેકોયન કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","યોક દિહી બુતે ચ્યાહાલ આખ્યાં, “ઈસુવાલ આંય જાંઅતાહાંવ, એને પાઉલાલબી વોળખુહુ, બાકી તુમા કું હેતાં?” ");
INSERT INTO gbl_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","એને ચ્યે માઅહે જ્યામાય બુત આતો, ચ્યાહાવોય તૂટી પોડીન, એને ચ્યાહાન કોબજામાય લેયને, ચ્યાહાલ ઓહડો માર દેનો કા ચ્યા નાગા એને ઘાયાલ ઓઇન ચ્યા ગોઆમાઅને દાહુદતા નિંગી નાઠા. ");
INSERT INTO gbl_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","એને ઈ વાત એફેસુસ શેહેરામાય રોનારા યહૂદી એને ગેર યહૂદી બી બોદા જાંઆઈ ગીયા, એને ચ્યા બોદહાવોય બિક બોઆય ગીયી, એને પ્રભુ ઈસુવા નાંવા મહિમા કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","એને ચ્યાહાય બોરહો રાખ્યેલ, ચ્યાહામાઅને બોજ લોકહાય યેઇન પોતપોતાના ખારાબ કામાંહાલ ખુલ્લી રીતે માની લેદા. ");
INSERT INTO gbl_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","એને મેલી વિદ્યા કોઅનારાહા માઅને બોજ જાઅહાય પોતપોતાના ચોપડેં યોકઠે કોઇન બોદહા હામ્મે બાળી ટાક્યેં, એને જોવે ચ્યાહા ઇસાબ કોઅયો તે પચહા ઓજાર ચાંદ્યે સિક્કાહા (૧ ચાંદ્યે સિક્કો એટલે યોક દિહા કાંબારાં) બોરાબર નિંગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","યેજપરમાણે પ્રભુ વચના સામર્થ્યા થી ફેલાતા ગીયા એને મજબુત ઓઅતા ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","જોવે યો વાતો ઓઅઇ ચુક્યો તોવે પાઉલે મોકોદુનિયા એને આખાયા વિસ્તારા વિસ્વાસ્યાહાલ મિળ્યાં પાછે યેરૂસાલેમ શેહેરામાય જાયના નોક્કી કોઅયા, એને આખ્યાં, “તાં જાઅના પાછે માન રોમ શેહેર બી એઅના જરુરી હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","યાહાટી આપહે સેવા કોઅનારા માઅને તિમોથી એને એરાસ્તુસાલ મોકોદુનિયા વિસ્તારામાય ચ્યાહાલ આપહે આગલા દોવાડી દેના એને પોતે તાં કોલહાક દિહી આસિયા વિસ્તારા એફેસ શેહેરામાય રોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ચ્યે સમાયે તાં પ્રભુવા વાટે બારામાય બોજ મોઠી ચળવળ જાયી. ");
INSERT INTO gbl_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","તાં દેમેત્રિયસ નાંવા યોક હોનાર્યા અરતીમાસ નાંવા યુનાની દેવી મંદિરા ચાંદ્યે નમુના બોનાડીન એને ચ્યાહાન વેચિન કારીગીરાહાલ બોજ ફાયદો કોઆડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","દેમેત્રિયસ ચ્યા કારીગીરાહાલ એને ઓહડા કામ કોઅનારા બિજા કારીગીરાહાલબી યોકઠા કોઇન ચ્યાહાન આખ્યાં, “ઓ માઅહાય, તુમા જાંઅતાહા કા યા કામાકોય આમહાન કોલહા પોયહા મિળતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","એને તુમા એઅતાહા એને વોનાતાહા કા યોખલા એફેસુસ શેહેરામાયજ નાંય, બાકી આસિયા વિસ્તારા બોદા ગાવાહામાય ઈ આખી-આખીન યા પાઉલે બોજ લોકહાન હોમજાડલાં એને ભરમાવલાં બી હેય, કા જીં આથા કારાગીરી હેય, ચ્યા દેવ નાંય. ");
INSERT INTO gbl_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","એને આમી ખાલી યે વાતે બિક નાંય કા આમે યા દોંદા બંદ પોડી, ઈ કા મોઠી દેવી અરતીમાસ મંદિર નોકામ્યો ગોણવામાય યી, એને જ્યેં દેવી ભક્તિ બોદા આસિયા વિસ્તારામાય એને આખા દુનિયા ભક્તિ કોઅહે ચ્યા મહત્વ બી જાતો રોય.” ");
INSERT INTO gbl_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","બોદા કારાગીર ઈ વોનાઈન ગુસ્સાથી બોરાય ગીયા, એને બોંબલી-બોંબલી આખા લાગ્યા, “એફેસીયાહા અરતીમાસ દેવી, મહાન હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","એને બોદાજ શેઅરામાંય મોઠો ધાંદલ મચી ગીયો, એને લોકહાય ગયુસ એને અરિસ્તર્ખુસ, મોકોદુનિયા નિવાસી એને જ્યા પાઉલુસા આર્યા મુસાફરી આતા, દોઅઇ લેય યેના, એને યોકહાતે ઓઇન રંગશાળેમાય દાંહાદી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","જોવે પાઉલ બી રંગશાળેમાય આંદાર જાયને લોકહા હાતે વાત કોઅરા માગતો આતો, બાકી શિષ્યહાય ચ્યાલ જાં નાંય દેનો. ");
INSERT INTO gbl_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","આસિયા ઓદિકાર્યાહા માઅને બી ચ્યા કોલહાક દોસ્તારાહાય ચ્યાપાય આખી દોવાડયા એને વિનાંતી કોઅયી, કા ચ્યાલ રંગશાળેમાય આંદાર જાયને પોતાનો જીવ મુશીબાતે માય નાંય ટાકાં જોજે. ");
INSERT INTO gbl_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","રંગશાળેમાય આંદાર, બોદા લોક બોંબલી રીયલા આતા, કાદો યોક વસ્તુ એને કાદા કાય એને બોદાજ કાય ગરબડ આતા, એને બો બોદા લોક તે ઈ જાંઅતાબી નાંય આતા કા ચ્યે કાહા યોકઠે ઓઅયેહે. ");
INSERT INTO gbl_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","તોવે ગીરદ્યેમાઅને કોલહાક યહૂદી લોકહાય સિકાંદરાલ ગીરદ્યે હામ્મે ડેકલી દેના, ગીરદ્યેમાઅને આગલા વોદાડયો, એને સિકંદરાય લોકહાન ઠાવકા રાંહાટી આથા ઈશારો કોઅયો એને હોમજાડના કોશિશ કોઅયી કા કાય ઓઅઇ રીયલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","બાકી જોવે ચ્યાહાન ખોબાર પોડી કા તો યહૂદી હેય, (યહૂદી લોક ખ્રિસ્તા લોકહા હારકા મુર્તિપુજા નાંય કોએત), તે બોદા ને બોદા યોકે આવાજથી કાદો બેન કોલાક લોગુ બોંબાલતા રિયા, “એફેસીયાહા અરતીમાસ દેવી, મહાન હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","તોવે શેહેરા, મોંતર્યાય લોકહાન ઠાવકા રાખીન આખ્યાં, “ઓ એફેસમાય રોનારા લોકહાય, બોદા જાંઅતાહા કા એફેસ શેહેરા લોક મહાન દેવી અરતીમાસ મંદિરા દેખભાલ કોઅઇ રીયાહા, એને તી મુર્તિ આકાશ માઅને પોડલી આતી. ");
INSERT INTO gbl_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","આમી જોવેકા યે વાતહે નાકારબી નાંય ઓઈ હોકે, તે ઠીક હેય, કા તુમા ઠાવકા રા, એને વોગાર હોમજી-વિચારી કાયજ મા કોઅતા. ");
INSERT INTO gbl_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","કાહાકા તુમા યા માઅહાલ લેય યેનાહા, જ્યા નાંય મંદિરાલ લૂટનારા હેય, એને નાંય આમહે દેવી નિંદા કોઅનારા હેય. ");
INSERT INTO gbl_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","યાહાટી દેમેત્રિયસ એને ચ્યા હાંગાત્યા કારીગીરાહાલ કાદાહાતે જગડો ઓરીતે, ચ્યા કોચર્યેમાય જાય હોકતાહા, એને ચ્યાહા ન્યાય કોઅરાહાટી ન્યાય કોઅનારા ઓદિકારીબી હેતા, તાં ચ્યા લોક યોકબીજાવોય ગુનો લાવી હોકતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","બાકી તુમા કાય બીજી વાતે બારામાય પુછા કોઅતાહા, તે નોક્કી પંચ લોકહા સોબાયેમાય નિર્ણય કોઅવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","કાહાકા માન બિક હેય કા રોમ સરકારથી દંગો સુરુ કોઅના દોષ લાવલો જાઅના મુશીબાતે માય હેય, યાહાટી કા યા કાય કારણ નાંય, આમી આમા યે ગીરદ્યે યોકઠા ઓઅના કાયજ જાવાબ નાંય દેય હોકહુ.” ");
INSERT INTO gbl_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","એને ઈ આખીન ચ્ચાય સોબાયેલ દોવાડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","જોવે દામાલ બોંદ ઓઈ ગીયો તે પાઉલે શિષ્યાહાન હાદિન ચ્યાહાન ઈંમાત દેની એને ચ્યાહા ઇહિને રજા લેયને મોકોદુનિયા વિસ્તારા એછે ચાલ પોડયો. ");
INSERT INTO gbl_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ચ્ચા બોદા વિસ્તારામાઅને ઓઇન એને શિષ્યાહાન બોજ ઈંમાત દેયન તો યુનાન વિસ્તારમાય યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","જોવે તીન મોયના રોયન તો તાઅને જાહાજેમાય બોહીન સિરીયા વિસ્તારા એછે જાં આતો, તોવે ચ્યાય ઈ વોનાયને કા કોલહાક યહૂદી આગેવાન ચ્ચાલ જાહાજેમાય માઆઇ ટાકાં યોજના કોય રીયહા એને યાહાટી ચ્ચાય મોકોદુનિયા વિસ્તારામાઅને ઓઇન સિરીયા વિસ્તારામાય જાઅના નોક્કી કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","યે મુસાફિર્યેમાય બીરીયામાય રોનારો પિરહુસા પોહો સોપાત્રુસ એને થેસ્સાલોનિક શેહેરામાઅને અરિસ્તર્ખુસ એને સીકુંદસ એને દિરબે શેહેરા ગાયુસ, એને લુસ્રા શેહેરા તિમોથી એને આસિયા વિસ્તાર તુખિકુસ એને ત્રોફિમુસ, ચ્યા બોદા આમહે આરે મુસાફીર આતા, જ્યા આસિયા વિસ્તારહુદુ આમહેહાતે યેના. ");
INSERT INTO gbl_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","એને યા હાંગાત્યા આમહે થી આગલા જાતા રિયા એને ત્રોઆસ શેહેરામાય પોઅચીન આમહે વાટ જોવતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","બાકી આમા બેની ખમીરા બાખ્યે સણ પાછે ફિલિપ્પી શેહેરાથી જાહાજેમાય બોહીન પાચ દિહાહામાય ત્રોઆસમાય ચ્યાહાપાય પોઅચ્યા, એને હાંત દિહીહુદુ તાં રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","આઠવાડ્યા પેલ્લે દિહી જોવે આમા પ્રભુ ભોજહાટી બેગા જાયલા, તોવે પાઉલ ચ્યાહાઆરે વાતો કોઅરા લાગ્યો જો બીજે દિહી જાતો રોનારો આતો, ચ્યાહા હાતે વાતો કોઅયો, એને આરદી રાતહુદુ સંદેશ દેતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","જ્યેં માળાંડયેવોય આમા બેગા જાઅલા આતા, ચ્યામાય બોજ દિવા હોલગી રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","એને યુતુખુસ નાંવા યોક જુવાન બાર્યેવોય બોઠલો આતો, એને જોવે પાઉલ મોડેહુદુ સંદેશ દેતો રિયો તે તો નિંદેલીદે ડોલવાથી તીજા માળા ઉપને ટુટી પોડયો, એને મોઅઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","બાકી પાઉલ નિચે ગીયો એને ચ્યાપાય જાયને ચ્યાલ આથામાય લેયને, એને ગોળે લાગીન આખ્યાં, “ગાબરાયાહા મા, કાહાકા તો આજુબી જીવતો હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","એને પાઉલ પાછો ઉચે ગીયો એને ચ્યાહાય પાછો પ્રભુભોજ લેદો, એને પ્રભુભોજ લેદા પાછે ચ્ચા દિહી નિંગ્યા લોગુ વાતો કોઅતા રિયા, ચ્ચા પાછે પાઉલ તાઅને જાતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","એને ચ્ચા, ચ્ચા જુવાનાલ જીવતો લેય ગીયા, એને બોજ આનંદિત ઓઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","પાઉલે અસ્સુસ શેહેરાહાટી દોરતી વોયને મુસાફરી કોઅના નોક્કી કોઅયા, બાકી આમા બાકી લોક જાહાજેમાય બોહીન આગલા જાતા રિયા, એને આમા તાઅને ચ્ચાલ આમહે આરે જાહાજેમાય લેયના નોક્કી કોઅય રીઅલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","જોવે તો અસ્સુસ શેહેરમાય આમહાન મિળ્યો તે આમા ચ્ચાલ આમહે આરે જાહાજેમાય બોહાડીન મિતુલેને શેહેરામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","તાઅને આમહાય લંગાર છોડયા એને બીજે દિહી ખિયસ બેટા હામ્મે પોઅચ્યા. આમા આગલે દિહી દોરિયો પાર કોઇન તાઅને સામુસ બેટા એને ચ્ચા બીજે દિહી મિલેતુસ બેટાવોય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","પાઉલુસાય એફેસુસ શેહેરામાય નાંય ઉતના નક્કી કોઅયા કાહાકા તાં આસિયા વિસ્તારમાય એને બોજ સમય નાંય રાંહાટી માગે, જોવે ઓઅય હોકે, તે તાં પાસ્કા સણા દિહી યેરૂસાલેમ શેહેરામાય રોય. ");
INSERT INTO gbl_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","એને જોવે આમા મિલેતુસ શેહેરામાય ઉત્યા, તોવે પાઉલે એફેસુસ શેહેરા મંડળ્યે વડીલાહાન નિરોપ દોવાડીન ચ્યાપાય હાદ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","જોવે ચ્યા ચ્યાપાય યેના, તોવે ચ્યે ચ્યાહાન આખ્યાં. “તુમા જાંઅતાહા, કા પેલ્લે દિહેથી જોવે આંય આસિયા વિસ્તારામાય પોઅચ્યો આજે હુદુ, આંય તુમહેઆરે કેહેકેન રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","એટલે બોજ નમ્રતા થી, એને આહવેં પાડી-પાડી ને, એને ચ્યે પરીક્ષાયેહેમાય જીં યહૂદીયાહા ખારાબ યોજના જીં માયેવોય યેય પોડ્યા, આંય પ્રભુવા સેવા કોઅતોજ રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","એને જ્યો-જ્યો વાતો તુમહે ફાયદા આત્યો, ચ્યેહેન આખા એને લોકહા હામ્મે એને ગોઅહે-ગોઅહે હિકાડાંહાટી કોવેજ નાંય બિઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","બાકી યહૂદી એને ગેર યહૂદીયાહામાય ચેતાવણી દેતો રિયો, કા પાપ કોઅના બોંદ કોઇન પોરમેહેરાએછે ફિરે એને આમહે પ્રભુ ઈસુવોય બોરહો કોએ. ");
INSERT INTO gbl_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","એને આમી આંય, પવિત્ર આત્મા આગનામાય યેરૂસાલેમ શેહેરમાય જાતહાવ, એને નાંય જાંઉ, કા તાં મા આરે કાય-કાય ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","કેવળ ઈંજ કા પવિત્ર આત્મા બોદા શેહેરમાય સાક્ષી દેય-દેયને માન આખહે કા બંધન એને સંકટ માંહાટી તિયાર હેય. ");
INSERT INTO gbl_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","બાકી આંય પોતાના જીવાલ કાયજ નાંય હોમજુ કા ચ્ચાલ પ્રિય જાઅઉ, બાકી ઈ કા આંય પોતાના દાંહુદના એને તી સેવા પુરી કોઉ, જી માન પોરમેહેરા સદા મોયા હારી ખોબારેવોય સાક્ષી દાંહાટી પ્રભુ ઈસુથી મીળહી. ");
INSERT INTO gbl_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","એને આમી આંય જાંઅતાહાંવ કા તુમા બોદા જ્યાહામાય પોરમેહેરા રાજ્યા હારી ખોબાર આખતો ફિર્યો, તુમા માન પાછો નાંય એઅહા. ");
INSERT INTO gbl_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","યાહાટી તુમહાન આંય આજ્યા દિહી સાક્ષી દેયને આખતાહાવ, કા જોવે તુમહામાઅને કાદોબી ઈસુવોય બોરહો થોવ્યા વોગાર મોઅઇ જાહે તે ઈ મા જાવાબદારી નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","કાહાકા માયે તુમહાન તી બોદાંજ આખ્યાહા જીં પોરમેહેરા ઇચ્છા હેય કા તુમા જાંએ, માયે કાયજ નાંય દોબાડયાહા. ");
INSERT INTO gbl_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","યાહાટી આપહે એને પુરાં ટોળા દેખ-ભાલ કોઆ, જ્યામાય પવિત્ર આત્માય તુમાહાલ અધ્યક્ષ ઠરાવલો હેય કા તુમા પોરમેહેરા મંડળીલ રાખવાળી કોઆ, જ્યેલ ચ્યાય ચ્ચા લોયાકોય વેચાતી લેદલી હેય. ");
INSERT INTO gbl_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","આંય જાંઅતાહાંવ કા મા જાયના પાછે તુમહે વોચમાય જુઠા હિકાડનારા યેઅરી એને વિસ્વાસ્યાહાન બોજ નુકસાન પોઅચાડી, ચ્ચે ચ્ચા ફાડી ખાનારા આસાલાહા રોકા ઓઅરી, જ્યેં ગેટાહાન માઆઇ ટાકતેહેં. ");
INSERT INTO gbl_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ઈહીં હુદુ કા તુમહેજ વોચમાઅને પોતાના વિસ્વાસ્યાહા ટોળામાઅને, ઓહડા લોક યેઅરી જ્યા શિષ્યહાન પોતાના પાહાલ લિયાહાટી જુઠા શિક્ષણ દાં લાગી. ");
INSERT INTO gbl_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","યાહાટી તુમા જાગતા રા, એને યાદ રાખા કા માયે તીન વોરહે હુદુ રાત દિહી આહવેં પાડી-પાડીન, યોકા-યોકાલ ચેતાવણી દેતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","આમી આંય તુમહાન પોરમેહેરા એને ચ્યા સદા મોયા વચનાલ હોઅપી દેતહાવ, જીં તુમહાન બોરાહામાંય મજબુત કોય હોકહે, એને પોરમેહેર તુમહાન તાબો દેઅરી જ્યાહાન દેયના વાયદો ચ્ચાય ચ્ચા બોદા લોકહાન કોઅલો હેય, જો ચ્ચા કોયન પવિત્ર કોઅલે ગીઅલે હેય. ");
INSERT INTO gbl_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","માયે કાદા હોના ચાંદી, કા ડોગલાં લાલચ નાંય કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","તુમા પોતે જાંઅતાહા કા યા આથહાય મા એને મા હાંગાત્યાહા બોદ્યો જરુરતો પુરાં કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","માયે તુમહાન બોદાંજ કોઅય દેખાડયાં, કા યે રીતે મેહનાત કોઅના નોબળાહાન સાંબાળના, એને પ્રભુ ઈસુ વચનાહાલ યાદ રાખના જરુરી હેય, કા ચ્ચેય પોતેજ આખલા હેય, ‘લેયના કોઅતા દેયના ધન્ય હેય’.” ");
INSERT INTO gbl_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ઈ આખીન તો માંડયે પોડયો એને બોદહાઆરે પ્રાર્થના કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","તોવે ચ્ચા બોદા બોજ રોડતા લાગ્યા એને પાઉલાલ ગોળે લાવીન ચ્યાલ ગુળા દાં લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ચ્યે ચ્ચાલ પાછે કોઇ દિહી નાંય દેખી, યાકોય લોક બોજ વોદારી દુઃખી આતા, પાછે ચ્યાહાય ચ્ચાલ હારિરીતે જાહાજ લોગુ પોઅચાડી દેનો. ");
INSERT INTO gbl_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","જોવે આમા ચ્યાહાથી રજા લેઈને દોરિયા વાટે મુસાફરી કોઅરા લાગ્યા, તોદિહી વાટેથી કોસ બેટમાય યેના, એને બીજે દિહી રુદુસ બેટમાય, એને તાઅને આમા પતરા બેટમાય પોઅચી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","એને યોક જાહાજ ફીનીકે વિસ્તારમાય જાતા મિળ્યાં, એને આમાહાય ચ્ચે જાહાજેમાય બોહીન મુસાફરી ચાલુ કોઅઇ. ");
INSERT INTO gbl_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","આમહાન ડાબે એછે સાઇપ્રસ બેટ દેખાયાં, આમા ચ્ચાલ છોડીન સિરીયા વિસ્તારા એછે આગલા જાતા ગીયા એને સુર શેહેરામાય જાય પોઅચ્યા, કાહાકા તાં જાહાજામાઅને સામાન ઉતાડના આતા. ");
INSERT INTO gbl_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","એને શિષ્યહાન હોદી કાડીન આમા તાં હાંત દિહીહુદુ રિયા, ચ્ચા પવિત્ર આત્મા અગુવાઈકોય પાઉલાલ યેરૂસાલેમ શેહેરમાય નાંય જાઅના વિનાંતી કોઅતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","હાંત દિહી પાછે જોવે તાઅને આમહે જાયના સમય યેનો, તે આમા તાઅને નિંગીન ચાલ પોડ્યા એને ચ્યા બોદા લોકહાય થેઅયો એને પોહહા હાતે આમહાન શેહેરા બાઆ હુદુ પોઅચાડયા, એને આમહાય દોરિયા મેરાવોય માંડયે પોડીન પ્રાર્થના કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","તોવે યોક-બિજા આરે રજા લેયને, આમા તે જાહાજેમાય ચોડયા, એને ચ્ચે પોત-પોતા ગોઓ ફિરી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","સોર શેહેરામાઅને સુરુ કોઅલી મુસાફરી પુરી કોઇન આમા પતુલિમયિસ શેહેરામાય પોઅચ્યા એને વિસ્વાસ્યાહાન મિળીન ચ્ચાહા આરે યોક દિહી રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","એને બીજે દિહી આમા તાઅને ચાલીન કૈસરીયા શેહેરામાય યેના, એને પાછે આમા ફિલિપ સુવાર્તિક ચ્ચા હાંત માઅહા માઅને યોક આતો ચ્યા ગોઆમાય જાયને તાં રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ચ્યા ચાર કુવાર્યો પોહયો આત્યો, ચ્યો ભવિષ્યવાણી કોઅત્યો આત્યો. ");
INSERT INTO gbl_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","જોવે આમા તાં બોજ દિહી રોય ચુક્યા, તાં અગાબુસ નાંવા યોક ભવિષ્યવક્તા યહૂદીયા વિસ્તારામાઅને યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ચ્યાય આમહેપાય યેયન પાઉલા કોંબરા આરે બાંદના પોટો લેદો, એને ચ્યે પોતા આથ પાગ બાંદિન આખ્યાં, “પવિત્ર આત્મા એહેકોય આખહે, કા જ્યા માઅહા ઓ કોંબરાલ બાંદના પોટો હેય, ચ્યાલ યેરૂસાલેમ શેહેરમાય યહૂદી લોક એહેકોઇન બાંદી, એને ગેર યહૂદીયાહા આથામાય હોઅપી દી.” ");
INSERT INTO gbl_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","જોવે આમા યો વાતો વોનાયા, તોવે આમા એને તાઅને લોકહાય પાઉલાલ વિનાંતી કોઅયી, કા યેરૂસાલેમ શેહેરમાય મા જાતો. ");
INSERT INTO gbl_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","બાકી પાઉલે ચ્યાહાલ જાવાબ દેના, “તુમા કાય કોઅતાહા, જ્યા રોડી-રોડીન મા દિલાલ તોડતાહા? આંય તે પ્રભુ ઈસુ નાવાહાટી યેરૂસાલેમ શેહેરમાય ખાલી બાંદલો જાંઅનાહાટીજ નાંય બાકી મોઅરાહાટીબી તિયારી હેતાઉ.” ");
INSERT INTO gbl_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","જોવે ચ્યાય નાંય માન્યા તોવે આમા ઈ આખીન ઠાવકાજ ઓઅઇ ગીયા, “પ્રભુવા ઇચ્છા પુરી ઓએ.” ");
INSERT INTO gbl_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","કોલહાક દિહહા પાછે આમહાય તિયારી કોઅયી એને યેરૂસાલેમ શેહેરમાય ચાલ પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","કૈસરીયા શેહેરામાઅનેબી કોલહાક શિષ્ય આમહેહાતે યેના, એને આમહાન રાંહાટી મનાસન નાંવા સાઇપ્રસમાય રોનારા ગોઓ લેય જાવામાય યેના, તો બોદહા પેલ્લા શિષ્યહા માઅને યોક આતો. ");
INSERT INTO gbl_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","જોવે આમા યેરૂસાલેમ શેહેરામાય પોઅચ્યા, તોવે વિસ્વાસ્યાહાય બોજ આનંદાકોય આમહે સ્વાગત કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","બીજે દિહે પાઉલ આમહાન લેયને યાકૂબાપાય ગીયો, જાં બોદા વડીલ બેગા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","તોવે પાઉલે ચ્યાહાન સલામ કોઇન, જ્યેં-જ્યેં કામે પોરમેહેરાય ચ્યા સેવાયેથી ગેર યહૂદીયાહામાય કોઅલે આતેં, યોક-યોક કોઇન બોદા આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ચ્યાહાય ઈ વોનાઈન પોરમેહેરા મહિમા કોઅઇ, પાછે ચ્યાલ આખ્યાં, “ઓ બાહા તું જાંઅતોહો, કા યહૂદીયાહા માઅને ઓજારો લોકહાય બોરહો કોઅયોહો, એને ચ્યા બોદા મૂસા નિયમાહાલ પાળના બોજ બોરહો કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","એને ચ્યા યહૂદી વિસ્વાસ્યા તો બારામાય વોનાયાહા, કા તું ગેર યહૂદીયાહામાય રોનારા યહૂદી લોકહાન ઈ હિકાડેહે કા મૂસા નિયમાહાલ છોડી દા, એને ઇબી આખતાહા, કા નાયતે આપહે પાહાહા સુન્નત કોઆડાં એને નાયતે યહૂદીયાહા રીતિરીવાજેહેવોય ચાલા. ");
INSERT INTO gbl_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","તે આમી આખા, આમા કાય કોઅજે? લોક નોક્કીજ વોનાયી કા તું ઈહીં યેનહો. ");
INSERT INTO gbl_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","યાહાટી જીં આમા તુલ આખજેહે, તી કોઓ. આમહે ઈહીં ચાર માઅહે હેય, ચ્યાહાય તી માનતા પુરાં કોઅના હેય જીં ચ્યાહાય પોરમેહેરા હામ્મે માન્યાહા.” ");
INSERT INTO gbl_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ચ્યાહાન લેઈને ચ્યાહા હાતે પોતેજ પોતાલ શુદ કોઅના વિદી પુરી કોઓ, એને ચ્યાહાહાટી ખોરચી દે, કા ચ્યા ટોલપા ટાલ્યાં કોઆડે તોવે બોદે જાઈ લેઅરી, કા જ્યો વાતો ચ્યા તો બારામાય વોનાયાહા, ચ્યામાય કાય હાચ્ચાં નાંય હેય બાકી તું પોતેબી મૂસા નિયમાહાલ માનીન ચ્યાહા પરમાણે ચાલતોહો. ");
INSERT INTO gbl_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","બાકી ચ્યા ગેર યહૂદીયાહા બારામાય જ્યાહાય બોરહો કોઅયોહો, આમહાય ઓ નિર્ણય કોઇન લોખીન દોવાડયાહા કા ચ્યે મુરત્યેહે હામ્મે બેટ ચોડાવલા માહાં થી, એને લોયાથી એને ગોગી દાબીન માઅલા માહાં થી, એને વ્યબિચારથી દુર રોજા. ");
INSERT INTO gbl_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","બીજે દિહી પાઉલે ચ્યા માઅહા હાતે જાયને પોતાલ શુદ્ધ કોઅયો એને પાછે ચ્યા હાતે દેવાળામાય ગીયા કા તો તાં ઈ જાહીર કોએ કા ચ્યાહા શુદ્દીના દિહી કોવે પુરાં ઓઅરી, એને ચ્યાહામાઅને બોદહાહાટી બેટો ચોડાવલ્યો જાઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","જોવે ચ્યા હાંત દિહી પુરાં ઓઅરા આતા, તે આસિયા વિસ્તારા યહૂદીયાહાય પાઉલાલ દેવાળામાય એઇન બોદા લોકહાન ભરમાવ્યા, એને પાઉલાલ દોઅઇ લેદો એને ઈ આખીન બોંબલા લાગ્યા, ");
INSERT INTO gbl_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","“ઓ ઈસરાયેલ્યાહાય, મોદાત કોઅયા, ઈ તીંજ માઅહું હેય, જીં માઅહા, એને મૂસા નિયમાહા, એને યા જાગા વિરુદમાય બોદે જાગે બોદા લોકહાન હિકાડેહે, ઈહિહુદુ કા ગેર યહૂદીયાહાલ બી દેવાળામાય લેય યેયન ચ્યાય યા પવિત્રસ્તાનાલ અપવિત્ર કોઅયાહાં.” ");
INSERT INTO gbl_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ચ્યાહાય એહેકેન આખ્યાં કાહાકા ચ્યાહાય તે યા પેલ્લા એફેસમાય રોનારા ગેર યહૂદી ત્રોફિમુસાલ પાઉલાહાતે શેહેરામાય દેખ્યેલ, એને હોમાજતા આતા કા પાઉલ ચ્યાલ દેવાળામાય લેય યેનહો. ");
INSERT INTO gbl_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","તોવે બોદા શેહેરામાય ગરબડ ફેલાય ગીયી, એને લોક દાંહદીન યોકઠા ઓઅયા, એને પાઉલાલ દોઇન દેવાળા બાઆ ગોહલી લેય યેના, એને તારાત બાઅણા બંદ કોઅય દેવામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","જોવે ચ્યા ચ્યાલ માઆઇ ટાકાં કોએત, તોવે સૈન્યા ટોળા સુબેદારાલ ખોબાર પોઅચી કા યેરૂસાલેમ શેહેરામાય બોજ બોદા લોકહામાય ગરબડ ઓઅઇ રોયહો. ");
INSERT INTO gbl_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","તોવે તો તારાત સીપાડાહાલ એને જોમાદારાહાન લેઈને ચ્યાહાપાય દાંહાદી યેનો, એને લોકહા ગીરદ્યે તોવે સૈન્યા ટોળા જોમાદારાલ એને સિપાડાહાન દેખીન ચ્યા પાઉલાલ ઠોકના રા દેના. ");
INSERT INTO gbl_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","તોવે સૈન્યા ટોળા જોમાદારાય પાઉલાપાય યેયન ચ્યાલ દોઅઇ લેદો, એને બેન હાકાળેહે કોઇન બાંદા આગના દેયને પુછા લાગ્યો, “ઈ કું હેય, એને ચ્યે કાય કોઅયાહાં?” ");
INSERT INTO gbl_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","બાકી ગીરદ્યેમાઅને કાદો કાય એને કાદો કાય બોંબાલતા રોયા એને જોવે દુમાલે લેદે તો હાચ્ચાં નાંય જાંઆઈ હોક્યો, તોવે ચ્યાલ કિલ્લામાય લેય જાઅના આગના દેની. ");
INSERT INTO gbl_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","જોવે તો નીહાણ્યેંવોય પોઅચ્યો, તોવે એહેકેન જાયા કા ગીરદી વોદારે ઓઅના લીદે સિપાડાહાન ચ્યાલ ઉસલી લેય જાં પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","કાહાકા લોકહા ગીરદી ઈ બોંબાલતે ચ્યા પાહલા પોડયેં, “ચ્યાલ માઆઇ ટાકાં.” ");
INSERT INTO gbl_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","જોવે ચ્યે પાઉલાલ કિલ્લામાય લેય જાનારે આતેં, તે ચ્યાય સૈન્યા ટોળા જોમાદારાલ આખ્યાં, “કાય આંય તુલ કાય આખી હોકુ?” ચ્યે આખ્યાં, “કાય તું યુનાની ભાષા જાંઅતોહો? ");
INSERT INTO gbl_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","કાય તું ચ્યાજ મિસર દેશા નાંય, જો યા દિહહા પેલ્લા સરકારા વિરુદ બળવો કોઇન ચાર ઓજાર આથ્યાર બંદ લોકહાન ઉજાડ જાગામાય લેય ગીયો?” ");
INSERT INTO gbl_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","પાઉલે આખ્યાં, “નાંય, આંય તે કિલિકિયા વિસ્તારા યોક મહત્વપૂર્ણ તારસુસ શેહેરા નાગરીક યોક યહૂદી માઅહું હેતાઉ, આંય તુલ વિનાંતી કોઅતાહાંવ, કા માન લોકહાન વાતો આખા દે.” ");
INSERT INTO gbl_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","જોવે ચ્યાય આગના દેની, તોવે પાઉલે નીહાણ્યેંવોય ઉબો રોઇન લોકહાન ઠાવકા રાંહાટી આથા ઈશારો કોઅયો, જોવે ચ્ચા ઠાવકા રોય ગીયા, તોવે તો હિબ્રુ ભાષામાય બોલા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ઓ બાહાહાય એને આગેવાનહાય, મા જોવાબ વોનાયા, જીં આંય આમી તુમહે હામ્મે આખતાહાવ.” ");
INSERT INTO gbl_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ચ્યા ઈ વોનાયને કા તો ચ્યાહાન હિબ્રુ ભાષામાય બોલહે, ચ્યા ઠાવકા રિયા, તોવે પાઉલે આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","આંય તે યહૂદી હેતાંવ, મા જન્મો કિલિકિયા વિસ્તારા તારસુસ શેહેરામાય જાયો, બાકી યા શેહેરામાય ગમાલીયેલા પાગહાપાય બોહીન શિક્ષણ મેળવ્યા, એને આગલ્યા ડાયાહા નિયમબી હારેરીતે હિકાડલા ગીયા, એને આંયબી પોરમેહેરાહાટી ઓહડો ઉત્સાહી આતો, જેહેકેન તુમા બોદા આજે હેતા. ");
INSERT INTO gbl_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","માયે પ્રભુવા વાટે ચાલનારાહાલ માટડા એને થેએયેહેલ બેનહ્યાલ બાંદિન, એને જેલેમાય ટાકીન, ઓલા સોતાવ્યા, કા ચ્યાહાન માઆઇ બી ટાકાડયા. ");
INSERT INTO gbl_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ખુદ મહાયાજક એને આગેવાનહાય બોદી સબા સાક્ષી હેય, કા ચ્યાહામાઅને આંય દમસ્ક શેહેરા યહૂદીયાહાહાટી પત્ર લેયને દમસ્ક શેહેરા એછે જાય રીયલો આતો, કા જ્યા તાં પ્રભુવા માર્ગામાય ચાલનારા રોય ચ્યાહાલ ડોંડ દાંહાટી બાંદિન યેરૂસાલેમ શેહેરામાય લેય યાઉ. ");
INSERT INTO gbl_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","જોવે આંય મુસાફરી કોઇન દમસ્ક શેહેરા પાહાય પોઅચ્યો, તોવે એહેકેન જાયા કા બોપરેહે લગભગ યોકાયોક મોઠો ઉજવાડો આકાશામાઅને મા ચારી-ચોમખી ચોમક્યા. ");
INSERT INTO gbl_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","એને આંય દોરત્યેવોય પોડી ગીયો, એને ઓ આવાજ વોનાયો, “ઓ શાઉલ, ઓ શાઉલ, તું માન કાહા સતાવતોહો?” ");
INSERT INTO gbl_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","માયે જાવાબ દેનો, ઓ પ્રભુ, તું કું હેતો? ચ્યે માન આખ્યાં, આંય ઈસુ નાજરેત ગાવા હેતાંવ, જ્યાલ તું સતાવતોહો. ");
INSERT INTO gbl_vpl VALUES ("AC22_9","074_22_9","ACT","22","9","9","એને મા હાંગાત્યાહાય ઉજવાડા દેખ્યા, એને જો મા આરે બોલતો આતો ચ્યાહાય ચ્યા આવાજબી વોનાયા, બાકી ચ્યા હોમજી નાંય હોક્યા કા તો માન કાય આખી રિયહો. ");
INSERT INTO gbl_vpl VALUES ("AC22_10","074_22_10","ACT","22","10","10","તોવે માયે આખ્યાં, ઓ પ્રભુ, આંય કાય કોઉ? પ્રભુવે માન આખ્યાં, ઉઠીન દમસ્ક શેહેરમાય જો, એને જીં કાય કોઅના ઠરાવલા ગીઅલા હેય તાં તુલ બોદા આખી દેવામાય યી. ");
INSERT INTO gbl_vpl VALUES ("AC22_11","074_22_11","ACT","22","11","11","જોવે ચ્યા ઉજવાડા જિંગાના લીદે માન કાય નોજરે નાંય પોડ્યા, તે માયે મા હાંગાત્યાહા આથ દોઈ લેયને દમસ્ક શેહેરામાય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC22_12","074_22_12","ACT","22","12","12","“તોવે હનાન્યા નાંવા મૂસા નિયમા પરમાણે ચાલનારો યોક પોરમેહેરા ભક્ત આતો, જો તાં રોનારા બોદા યહૂદીયાહામાય માનાપાના માઅહું આતો, માપાય યેનો, ");
INSERT INTO gbl_vpl VALUES ("AC22_13","074_22_13","ACT","22","13","13","એને માપાય ઉબો રોઇન માન આખ્યાં, ‘ઓ બાહા શાઉલ, પાછો એઅતો લાગ.’ ચ્યેજ ગેડી મા ડોળા ઉગડી ગીયા એને માયે ચ્યાલ એઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC22_14","074_22_14","ACT","22","14","14","તોવે ચ્યે આખ્યાં, આંય આગલ્યા ડાયાહા પોરમેહેરે તુલ યાહાટી ઠરાવ્યોહો કા તું ચ્યા ઇચ્છાલ જાંએ, એને ચ્યા ન્યાયી એટલે મસીહાલ એએ, એને ચ્યા આવાજ વોનાયે. ");
INSERT INTO gbl_vpl VALUES ("AC22_15","074_22_15","ACT","22","15","15","કાહાકા તું ચ્યા એસને બોદા માઅહા હામ્મે ચ્યે વાતહે સાક્ષીદાર ઓઅહે, જીં તુયે એઅયા એને વોનાયો. ");
INSERT INTO gbl_vpl VALUES ("AC22_16","074_22_16","ACT","22","16","16","આમી કાહા મોડા કોઅતોહો? ઉઠ, બાપતિસ્મા લે, એને ચ્યા નાંવ લે પોતાના પાપહાથી માફી મિળવાહાટી. ");
INSERT INTO gbl_vpl VALUES ("AC22_17","074_22_17","ACT","22","17","17","જોવે આંય પાછી યેરૂસાલેમ શેહેરામાય યેયન દેવાળામાય પ્રાર્થના કોઅઇ રીયલો આતો, તે માયે દર્શન એઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC22_18","074_22_18","ACT","22","18","18","તોવે ચ્યે માન દર્શન દેયન આખ્યાં, ‘ઉતવાળ કોઇન યેરૂસાલેમ શેહેરમાઅને માહારી નિંગી જો, કાહાકા ચ્યા લોક જ્યા ઈહીં હેતા મા બારામાય તો સાક્ષી નાંય માની.’ ");
INSERT INTO gbl_vpl VALUES ("AC22_19","074_22_19","ACT","22","19","19","માયે આખ્યાં, ‘ઓ પ્રભુ તી તે તું જાંઅતોહો, કા આંય તોવોય બોરહો કોઅનારાહાન જેલેમાય ટાકતો એને જાગા-જાગાવોય સોબાયે ઠિકાણાહામાય ઠોકાડતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC22_20","074_22_20","ACT","22","20","20","એને જોવે તો સાક્ષીદાર સ્તેફનુસા લોય વોવાડલાં જાય રીયલા આતા, તોવેબી આંય તાં ઉબો આતો, એને યે વાતમાય ભાગીદાર આતો, એને ચ્યા ખૂન કોઅનારાહા ડોગલાહા રાખવાળી કોઅઇ રીયલો આતો.’ ");
INSERT INTO gbl_vpl VALUES ("AC22_21","074_22_21","ACT","22","21","21","એને પ્રભુય માન આખ્યાં, ‘ચાલ્યો જો, કાહાકા આંય તુલ ગેર યહૂદીયાહા પાય દુઉ-દુઉ દોવાડીહી’.” ");
INSERT INTO gbl_vpl VALUES ("AC22_22","074_22_22","ACT","22","22","22","ચ્યા લોક યે વાતે હુદુ ચ્યા વોનાતેં રિયે, તોવે મોઠે આવાજથી બોંબલ્યા, “ઓહડા માઅહાલ માઆઇ ટાકાં, ચ્યા જીવતા રોઅના યોગ્ય નાંય.” ");
INSERT INTO gbl_vpl VALUES ("AC22_23","074_22_23","ACT","22","23","23","જોવે ચ્યા બોંબાલતા એને ઉપલ્યો ઝોબો ટાકતા એને પોતાનો ગુસ્સો દેખાડાહાટી આકાશામાય ઉદળાં ઉડાવતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC22_24","074_22_24","ACT","22","24","24","તે સૈન્યા ટોળા જોમાદારાય આખ્યાં, “યાલ કિલ્લામાય લેય જાયા, એને ચોપકાહાકેન ઠોકીન પારખા, કા આંય જાંઉ કા લોક કોઅહા કારણથી ચ્યા વિરુદમાય એહેકેન બોંબલી રીયહે.” ");
INSERT INTO gbl_vpl VALUES ("AC22_25","074_22_25","ACT","22","25","25","જોવે ચ્યાહાય ચ્યાલ ચાંબડા પોટાથી બાંદ્યો તોવે પાઉલે ચ્યા જોમાદારાલ જો ચ્યાપાય ઉબો રોઅલો આતો આખ્યાં, “કાય ઈ યોગ્ય હેય, કા તુમા યોક રોમી માઅહાલ, એને તી બી વોગાર દોષી ઠોરવ્યાથી, ચાપકા ઠોકાં?” ");
INSERT INTO gbl_vpl VALUES ("AC22_26","074_22_26","ACT","22","26","26","જોમાદારાય ઈ વોનાયને સૈન્ય-દલા સરદારાપાય પાહાય જાયને આખ્યાં, “તું ઈ કાય કોઅતોહો? ઓ તે રોમી માઅહું હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC22_27","074_22_27","ACT","22","27","27","તોવે સૈન્ય-દલા સરદારાય ચ્યાપાય યેયન આખ્યાં, “માન આખ, કાય તું રોમી હેતો?” પાઉલે આખ્યાં, “હાં.” ");
INSERT INTO gbl_vpl VALUES ("AC22_28","074_22_28","ACT","22","28","28","ઈ વોનાયને સૈન્ય-દલા સરદારે આખ્યાં, “માયે રોમી ઓઅના પદ બોજ પોયહા દેયને મેળવ્યાહાં,” પાઉલે આખ્યાં, “આંય તે જન્માથીજ રોમી હેતાંવ.” ");
INSERT INTO gbl_vpl VALUES ("AC22_29","074_22_29","ACT","22","29","29","તોવે જ્યા લોક ચ્યાલ પારાખનારે આતેં, ચ્યે તારાત ચ્યાપાઅને ઓટી ગીયે, એને સૈન્ય-દલા સરદારબી ઈ જાઇન કા ઓ રોમી હેય, એને ચ્યે ચ્યાલ બાંદ્યોહો, બિઇ ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC22_30","074_22_30","ACT","22","30","30","બીજે દિહી તો હાચ્ચાં-હાચ્ચાં જાઅના ઇચ્છાથી કા યહૂદી ચ્યાવોય કાહા દોષ લાવતેહે, યાહાટી ચ્યા બંધન ખોલી દેના, એને મુખ્ય યાજકાહાલ એને બોદી મોઠી સોબાયેલ યોકઠા ઓઅના આગના દેની, એને પાઉલાલ લેય યેયન ચ્યાહા હામ્મે ઉબો કોઅઇ દેનો. ");
INSERT INTO gbl_vpl VALUES ("AC23_1","074_23_1","ACT","23","1","1","પાઉલે મોઠયે સોબાયે એછે યોક્યે નોજારેકોય એઅયા, એને આખ્યાં, “ઓ બાહહાંય, માયે આજેલોગુ પોરમેહેરાહાટી બીલકુર હાચ્ચાયેથી જીવન વિતાવ્યાહા.” ");
INSERT INTO gbl_vpl VALUES ("AC23_2","074_23_2","ACT","23","2","2","હનાન્યા મહાયાજકાય, ચ્યાહાલ જ્યેં ચ્યાપાય ઉબલે આતેં, ચ્યા મુંયાવોય થાપડાકેન ઠોકના આગના દેની. ");
INSERT INTO gbl_vpl VALUES ("AC23_3","074_23_3","ACT","23","3","3","તોવે પાઉલે ચ્યાલ આખ્યાં, “ઓ ઘમંડયા, પોરમેહેર તુલ ઠોકી, તું મૂસા નિયમા પરમાણે મા ન્યાય કોઅરા બોઠહો, એને પાછી કાય નિયમા વિરુદ માન માઅના આગના દેતહો?” ");
INSERT INTO gbl_vpl VALUES ("AC23_4","074_23_4","ACT","23","4","4","જ્યા પાહાય ઉબા આતા, ચ્યાહાય આખ્યાં, “કાય, તું પોરમેહેરા મહાયાજકા અપમાન કોઅતોહો?” ");
INSERT INTO gbl_vpl VALUES ("AC23_5","074_23_5","ACT","23","5","5","પાઉલે આખ્યાં, “ઓ બાહાહાય, માફ કોઅજા આંય નાંય જાંઅતો આતો, કા ઓ મહાયાજક હેય, કાહાકા પવિત્રશાસ્ત્રામાય લોખલાં હેય, પોતાના લોકહા આગેવાનાલ ખારાબ મા આખતો.” ");
INSERT INTO gbl_vpl VALUES ("AC23_6","074_23_6","ACT","23","6","6","તોવે પાઉલ ઈ જાઇન, કા કોલહાક સાદૂકી લોક એને કોલહાક પોરૂષી લોક હેય, મોઠયે સોબાયેમાય બોંબલીન આખ્યાં, “ઓ બાહાહાય, પોરૂષી એને પોરૂષીયાહા પોહો હેતાંવ, આંય કોશિશ કોઅય રિઅલો હેય કાહાકા માન આશા હેય કા પોરમેહેર મોઅલા માઅને પાછા લોકહાન જીવતા કોઅરી યા લીદે માયેવોય સજા ચાલહે.” ");
INSERT INTO gbl_vpl VALUES ("AC23_7","074_23_7","ACT","23","7","7","જોવે ચ્યેય ઈ વાત આખી તે પોરૂષીયાહા એને સાદૂકીયાહામાય જગડો ઓઅરા લાગ્યો, એને સોબાયેમાય ફુટ પોડી ગીયી. ");
INSERT INTO gbl_vpl VALUES ("AC23_8","074_23_8","ACT","23","8","8","કાહાકા સાદૂકીયાહા એહેકોય બોરહો હેય, કા માઅહું મોઅલા માઅને પાછા નાંય જીવતા ઓએ, એને નાંય તે હોરગા દૂત એને નાંય આત્મા હેય, બાકી પોરૂષીયા યા બોદહાન માનતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC23_9","074_23_9","ACT","23","9","9","તોવે મોઠી ગરબડ ઉબી જાયી એને મૂસા નિયમ હિકાડનારા ગુરુ, જ્યા પોરૂષી આતા, ઉબા ઓઅય ગીયા એને ઈ આખીન વોદારે બોલા-બોલી કોઅરા લાગ્યા, “આમા યા માઅહામાય કાયજ ખારાબી નાંય એઅજે, એને ઓઅઇ હોકહે કા યોક આત્મા કા યોક હોરગા દૂતાય ચ્યા હાતે વાત કોઅયીહી.” ");
INSERT INTO gbl_vpl VALUES ("AC23_10","074_23_10","ACT","23","10","10","જોવે બોજ જગડો જાયો, તે સૈન્યા-દલા સરદારાય યે બિકથી કા ચ્યા પાઉલા ટુકડા-ટુકડા નાંય કોઅઇ ટાકે, સૈન્યા-દલાલ આગના દેની કા ઉતી પોડીન સોબાયે સભાસદહા વોચ્ચેથી પાઉલાલ બળજબરીથી કાડા, એને કિલ્લામાય લેય યા. ");
INSERT INTO gbl_vpl VALUES ("AC23_11","074_23_11","ACT","23","11","11","ચ્યે રાતી પ્રભુ ઈસુય પાઉલાલ જાગે યેયન ઉબા રોયન આખ્યાં, “ઓ પાઉલ, ઈંમાત રાખ, કાહાકા જેહેકેન તુયે યેરૂસાલેમ શેહેરમાય મા સાક્ષી દેની, તેહેકોયનુજ તુલ રોમમાય બી સાક્ષી દાં પોડી.” ");
INSERT INTO gbl_vpl VALUES ("AC23_12","074_23_12","ACT","23","12","12","જોવે દિહી નિંગ્યો, તે યહૂદીયાહાય એકી કોઅયી, એને માનતા લેદા કા જાવ લોગુ આમા પાઉલાલ માઆઇ નાંય ટાકજે, તાંઉલોગુ ખાઅના નાંય એને પિઈના નાંય. ");
INSERT INTO gbl_vpl VALUES ("AC23_13","074_23_13","ACT","23","13","13","જ્યાહાય ઈ માનતા લેદેલ, ચ્યા ચાળહી જાઆહાથી વોદારે આતેં. ");
INSERT INTO gbl_vpl VALUES ("AC23_14","074_23_14","ACT","23","14","14","ચ્યાહાય મુખ્ય યાજકાહા એને આગેવાનાહાપાય યેયન આખ્યાં, “આમહાય માનતા લેદા કા જાવ હુદુ આમા પાઉલાલ માઆઇ નાંય ટાકજે, તાંઉ હુદુ કાયજ ખાજે પિજે નાંય. ");
INSERT INTO gbl_vpl VALUES ("AC23_15","074_23_15","ACT","23","15","15","યાહાટી આમી મોઠી સોબાયે હાતે સૈનિકાહા ટુકડી સુબેદારાલ હુમજાડા કા, પાઉલાલ તુમહેપાય લેય યા, જાણે કા તુમા ચ્ચા બારામાય હારેરીતે જાંઅરા વિચારતાહા, એને આમા ચ્ચા પોઅચના પેલ્લાજ ચ્ચાલ માઆઇ ટાકાંહાટી તિયાર રોહુ.” ");
INSERT INTO gbl_vpl VALUES ("AC23_16","074_23_16","ACT","23","16","16","બાકી પાઉલા બોઅયેહે પોહો વોનાયોકા ચ્ચા ચ્ચાલ માઆઇ ટાકાં કોઅતાહા, તે કિલ્લામાય જાયને પાઉલાલ ખોબાર દેની. ");
INSERT INTO gbl_vpl VALUES ("AC23_17","074_23_17","ACT","23","17","17","પાઉલે યોક જોમાદારાલ હાદિન આખ્યાં, “યા જુવાન્યાલ સૈનિકાહા ટુકડી સુબેદારાપાય લેય જાયા, ઓ ચ્ચાલ કાય આખા માગહે.” ");
INSERT INTO gbl_vpl VALUES ("AC23_18","074_23_18","ACT","23","18","18","યાહાટી સુબેદારાય પાઉલા બોઅયેહે પોહાલ સૈનિકાહા ટુકડી સુબેદારાપાય લેય ગીયા એને આખ્યાં, “કૈદી પાઉલે માન હાદિન વિનાંતી કોઅઇ, કા ઓ જુવાન સૈનિકાહા ટુકડી સુબેદારાલ કાય આખા વિચાર કોઅહે, યાલ ચ્યાપાય લેય જાં.” ");
INSERT INTO gbl_vpl VALUES ("AC23_19","074_23_19","ACT","23","19","19","સૈનિકાહા ટુકડયે સુબેદારાય ચ્યા આથ દોઇન, એને ચ્ચાલ આલાગ લેય જાયને પુછ્યાં, “તું માન કાય આખા માગતોહો?” ");
INSERT INTO gbl_vpl VALUES ("AC23_20","074_23_20","ACT","23","20","20","ચ્યે આખ્યાં, “યહૂદીયાહાય એકી કોઅયીહી, કા તુલ વિનાંતી કોએ કા હાકાળ પાઉલાલ મોઠયે સોબાયેમાય લેય યેય, જાણે કા તું આજુ હારેરીતે ચ્ચા બારામાય જાંઅરા માગતોહો. ");
INSERT INTO gbl_vpl VALUES ("AC23_21","074_23_21","ACT","23","21","21","બાકી મેરબાની કોઇન ચ્ચાહા યે વિનાંત્યે એછે દિયાન નાંય દેઅના, કાહાકા ચ્યાહામાઅને ચાળહિથી વોદારે માઅહે પાઉલાલ માઆઇ ટાકાંહાટી ટુંગી રીઅલા હેતા, જ્યાહાય ઈ નોક્કી કોઅઇ લેદાહા કા જાવ લોગુ ચ્ચા પાઉલાલ માઆઇ નાંય ટાકે, તાંવ હુદુ ખાઅના પિઈના નાંય, એને આમી ચ્યા તિયારીજ હેતા એને તું હાં આખાહાટી વાટ જોવી રોયહા.” ");
INSERT INTO gbl_vpl VALUES ("AC23_22","074_23_22","ACT","23","22","22","તોવે સૈનિકાહા ટુકડયે સુબેદારાય જુવાન્યાહાલ ઓ આદેશ દેયને દોવાડયો, “કાદાલ નાંય આખના કા તુયે માન યો વાતો આખ્યોહો.” ");
INSERT INTO gbl_vpl VALUES ("AC23_23","074_23_23","ACT","23","23","23","સૈનિકાહા ટુકડી સુબેદારાય બેન જોમાદારાહાન હાદિન આખ્યાં, “બેન હોવ સીપાડા, હિત્તેર ગોડહા સવાર, એને બેન હોવ બોરછા વાળાહાન કૈસરીયા શેહેરામાય જાંહાટી તિયારી કોઅઇ રાખ, તુમા રાતી નવ વાગે નિંગજા.” ");
INSERT INTO gbl_vpl VALUES ("AC23_24","074_23_24","ACT","23","24","24","એને પાઉલુસા મુસાફર્યેહાટી ગોડા તિયારી રાખા કા ચ્ચાલ ફેલિક્સ રાજ્યપાલાપાય હારેં રીતે પોઅચાડી દેય. ");
INSERT INTO gbl_vpl VALUES ("AC23_25","074_23_25","ACT","23","25","25","સૈનિકાહા ટુકડયે સુબેદારાય યે પરમાણે રાજ્યપાલાલ યોક પત્ર લોખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC23_26","074_23_26","ACT","23","26","26","“મહાપ્રતાપી ફેલિક્સ રાજ્યપાલાલ ક્લોદિયુસ લુસીયાસ પાઅને સલામ. ");
INSERT INTO gbl_vpl VALUES ("AC23_27","074_23_27","ACT","23","27","27","યા માઅહાલ યહૂદીયાહાય દોઇન માઆઇ ટાકાં વિચાર્યા, બાકી માયે જાંઅયા કા તો રોમી હેય, તો સૈનિકાહા ટુકડી લેય યેયન સોડાવી લેય યેનો. ");
INSERT INTO gbl_vpl VALUES ("AC23_28","074_23_28","ACT","23","28","28","એને આંય જાંઅરા માગતો આતો, કા ચ્ચે ચ્ચાવોય કોઅહા કારણે દોષ લાવતાહા, યાહાટી ચ્ચાલ ચ્ચાહા મોઠયે સોબાયેમાય લેય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC23_29","074_23_29","ACT","23","29","29","તોવે માયે જાંઆય લેદા, કા ચ્ચા પોતાના યહૂદી નિયમાહા વાદ-વિવાદાહા બારામાય ચ્ચાવોય દોષ થોવતાહા, બાકી માઆઇ ટાકલાં જાઅના કા જેલેમાય ટાકના હારકા ચ્ચામાય કાય દોષ નાંય. ");
INSERT INTO gbl_vpl VALUES ("AC23_30","074_23_30","ACT","23","30","30","એને જોવે માન આખલા ગીયા, કા ચ્ચા યા માઅહાલ માઆઇ ટાકાંહાટી ટુંગી રીયલા હેય તે માયે તારાત ચ્ચાલ તોપાય દોવાડી દેનો, એને દોષ લાવનારા યહૂદીયાહાલ બી આગના દેની, કા તો હામ્મે ચ્ચાવોય દોષ લાવે.” ");
INSERT INTO gbl_vpl VALUES ("AC23_31","074_23_31","ACT","23","31","31","ચ્યેજ રાતી સિપાડાહાન દેનલો ગીઅલો હુકુમાલ પુરો કોઅયો: ચ્ચા પાઉલાલ યેરૂસાલેમ શેહેરામાઅને લેય ગીયા એને ચ્ચાલ અન્તિપત્રિસ શેહેરામાય લેય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC23_32","074_23_32","ACT","23","32","32","બીજે દિહી ચ્ચા ગોડહા સવારાહાન પાઉલાહાતે કૈસરીયા શેહેરામાય જાંહાટી છોડીન સીપાડા યેરૂસાલેમ કિલ્લામાય ફિરી યેના. ");
INSERT INTO gbl_vpl VALUES ("AC23_33","074_23_33","ACT","23","33","33","ચ્યાહાય કૈસરીયા શેહેરામાય પોઅચીન રાજ્યપાલાલ પત્ર દેના, એને પાઉલાલબી ચ્ચા હામ્મે ઉબો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC23_34","074_23_34","ACT","23","34","34","રાજ્યપાલાય વાચીન પુછ્યાં, “ઓ કોઅહા વિસ્તારા હેય?” ");
INSERT INTO gbl_vpl VALUES ("AC23_35","074_23_35","ACT","23","35","35","એને જોવે જાંઆઈ લેદા કા કિલિકિયા વિસ્તારા હેય, તે ચ્ચાલ આખ્યાં, “જોવે તોવોય દોષ લાવનારા બી યેઅરી, તે આંય તો ન્યાય કોઅહી,” એને ચ્ચાય પાઉલાલ હેરોદ રાજા કિલ્લા પેહરામાય રાખાંહાટી આગના દેની. ");
INSERT INTO gbl_vpl VALUES ("AC24_1","074_24_1","ACT","24","1","1","પાચ દિહી પાછે હનાન્યા મહાયાજક એને કોલહાક આગેવાન એને તિરતુલ્લુસ નાંવ્યો કાદો વકીલાલ આરે લેઈને કૈસરીયા શેહેરમાય યેય પોઅચ્યા, ચ્યાહાય રાજ્યપાલા હામ્મે પાઉલાવોય દોષ લાવ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC24_2","074_24_2","ACT","24","2","2","જોવે પાઉલાલ હાદવામાય યેનો તોવે તિરતુલ્લુસ ચ્યાવોય દોષ થોવિન આખા લાગ્યો, “ઓ મહાપ્રતાપી ફેલિક્સ, તોથી આમહાન જો મોઠો આનંદ ઓઅહે, એને તો હોમાજદારીથી યે જાતેહાટી કોલહેક ખારાબ કામે હુદારતે જાતહેં. ");
INSERT INTO gbl_vpl VALUES ("AC24_3","074_24_3","ACT","24","3","3","ફેલિક્સાલ આમા બોદે જાગે એને બોદ્યેજ રીત્યેસે ધન્યવાદ હાતે માનજેહે. ");
INSERT INTO gbl_vpl VALUES ("AC24_4","074_24_4","ACT","24","4","4","બાકી યાહાટી કા આંય તો વોદારે સમય નાંય લા માગુ, આંય તુલ વિનાંતી કોઅતાહાંવ, કા મેરબાની કોઇન આમહે બેન યોક વાતો વોનાય લે. ");
INSERT INTO gbl_vpl VALUES ("AC24_5","074_24_5","ACT","24","5","5","કાહાકા આમહાય યા માઅહાલ પિડાકારક એને દુનિયા બોદા યહૂદીયાહામાય દામાલ કોઆડનારો, એને ઓ યોક સમાજા આગેવાન બી હેય જ્યાલ નાજરેતનો આખલો જાહાય. ");
INSERT INTO gbl_vpl VALUES ("AC24_6","074_24_6","ACT","24","6","6","ચ્યાય દેવાળાલ અશુદ્ધ કોઅરા વિચાર્યા, એને તોવે આમહાય ચ્યાલ કૈદી બોનાવી લેદો, આમહાય ચ્યાલ આમહે મૂસા નિયમાહા પરમાણે ડોંડ દેનલો જાતો. ");
INSERT INTO gbl_vpl VALUES ("AC24_7","074_24_7","ACT","24","7","7","બાકી સૈનિકા ટુકડયે સુબેદાર લુસીયાસે યેયન ચ્યાલ બળજબરીથી આમહે આથામાયને કાડી લેદા, ");
INSERT INTO gbl_vpl VALUES ("AC24_8","074_24_8","ACT","24","8","8","એને યાવોય દોષ લાવનારાહાલ તો હામ્મે યેઅના આગના દેની યે બોદયે વાતહે જ્યા બારામાય આમા ચ્યાવોય દોષ લાવતાહા, તું પોતેજ ચ્યાલ પારખીન જાઈ લેહે.” ");
INSERT INTO gbl_vpl VALUES ("AC24_9","074_24_9","ACT","24","9","9","યહૂદીયાહાયબી ચ્યા ટેકો દેયને આખ્યાં, યો વાતો યે પરમાણેન્યો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC24_10","074_24_10","ACT","24","10","10","જોવે રાજ્યપાલે પાઉલાલ બોલાહાટી ઈશારો કોઅયો તે ચ્યાય જાવાબ દેનો: “માયે ઈ જાઇન કા તું બોજ વોરહાથી યા દેશા લોકહા ન્યાય કોઅતોહો, એને યાહાટી આંય આનાંદથી મા જાવાબ દેતહાવ. ");
INSERT INTO gbl_vpl VALUES ("AC24_11","074_24_11","ACT","24","11","11","તું પોતે જાઈ હોકતોહો, કા માન યેરૂસાલેમ શેહેરામાય આરાધના કોઅરાહાટી દેવાળામાય જાયને બાસ બારા દિહી ઓઅયાહા. ");
INSERT INTO gbl_vpl VALUES ("AC24_12","074_24_12","ACT","24","12","12","માયેવોય આરાપ લાવનારા લોકહાય માન નાંય દેવાળામાય, નાંય સોબાયે ઠિકાણાહામાય, નાંય શેહેરમાય કાદા આરે બોલા-બોલી કોઅતા કા લોકહામાય દામાલ કોઆડતો નાંય દેખ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC24_13","074_24_13","ACT","24","13","13","એને નાંય તે ચ્યે વાતહે, જ્યેહે બારામાય ચ્યા આમી માયેવોય દોષ થોવતાહા, તો હામ્મે ચ્યા હાચ્ચાં સાબિત કોઅઇ હોકતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC24_14","074_24_14","ACT","24","14","14","એને આંય તો હામ્મે કબુલ કોઅતાહાંવ, કા યા યહૂદી આગેવાનાહાન લાગહે કા આંય ખ્રિસ્તા વાટે અનુસરણ કોઅતાહાંવ જ્યાલ ચ્યા જુઠી વાટ આખતાહા, આંય આમહે આગલ્યા ડાયહા પોરમેહેરા ભક્તિ કોઅતાહાંવ, એને જ્યો વાતો મૂસા નિયમશાસ્ત્ર એને ભવિષ્યવક્તાહા ચોપડયેહેમાય લોખલાં હેય, ચ્યા બોદહાપે બોરહો કોઅતાહાંવ. ");
INSERT INTO gbl_vpl VALUES ("AC24_15","074_24_15","ACT","24","15","15","એને પોરમેહેરાથી આશા રાખહુ, કા જેહેકેન પોતે યા લોકબી રાખતાહા, કા ન્યાયી એને અન્યાય બેન્યાહાલ પોરમેહેર મોઅલા માઅને પાછો જીવતા ઉઠાડી. ");
INSERT INTO gbl_vpl VALUES ("AC24_16","074_24_16","ACT","24","16","16","યાથી આંયબી કોશીત કોઅતાહાંવ, કા પોરમેહેરા એને માઅહા એછે મા મન કાયામ નિર્દોષ રોય. ");
INSERT INTO gbl_vpl VALUES ("AC24_17","074_24_17","ACT","24","17","17","બોજ વોરહા પાછે આંય મા ગરીબ લોકહાહાટી બેટ એને પોરમેહેરાલ બલિદાન ચોડવાહાટી યેરૂસાલેમ શેહેરામાય આંય યેનલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC24_18","074_24_18","ACT","24","18","19","ચ્ચે સમાયે ચ્યાહાય દેવાળામાય માન ચોખ્ખાં કોઅના રીત પુરી કોઅતા દેખ્યા, તાં નાંય કાય ગીરદી આતી એને નાંય કોહોડા પ્રકારા આવાજ આતો, બાકી આસિયા વિસ્તારામાઅને યેનલા કોલહાક યહૂદી લોક તાં આતા, જો મા વિરુદમાય ચ્યાહાન કાય આખના હેય તે ચ્યાહાય તો હામ્મે યેયન માયેવોય આરાપ લાવાં જોજે. ");
INSERT INTO gbl_vpl VALUES ("AC24_20","074_24_20","ACT","24","20","20","કા ઈ તું પોતેજ આખે, કા જોવે આંય મોઠયે સોબાયે હામ્મે ઉબો આતો, તે ચ્યાહાન માંયેમાય કોઅહો ગુનો માલુમ પોડયો? ");
INSERT INTO gbl_vpl VALUES ("AC24_21","074_24_21","ACT","24","21","21","યોકુજ દોષ મા વિરુદ લાવી હોકતાહા, તો ઓ હેય જોવે આંય ચ્ચાહા હામ્મે બોંબલી-બોંબલીન આખતો આતો, આજે મા તોથી ન્યાય કોઅવામાય યેય રોયહો કાહાકા આંય બોરહો કોઅતાહાંવ કા પોરમેહેર ચ્ચા લોકહાન જ્યા મોઅઇ ગીઅલા હેય બીજાદા જીવતા કોઅરી.” ");
INSERT INTO gbl_vpl VALUES ("AC24_22","074_24_22","ACT","24","22","22","ફેલિક્સાય, જ્યેં યે વાટે વાતો ઠીક-ઠીક રીતે જાંઅતો આતો, ચ્ચાહાન ઈ આખીન ટાળી દેના, “જોવે સૈનિકાહા ટુકડયે સુબેદાર લુસીયાસ યેઅરી, તોવે તુમહે વાતે નિર્ણય કોઅહી.” ");
INSERT INTO gbl_vpl VALUES ("AC24_23","074_24_23","ACT","24","23","23","એને જોમાદારાલ આગના દેની, કા પાઉલાલ પેહેરા માય થોવલો જાય, એને ચ્ચા હાંગાત્યાહા માઅને કાદાલબી ચ્ચા ગોરાજેહે ખ્યાલ પુરી કોઅરા દેઅના. ");
INSERT INTO gbl_vpl VALUES ("AC24_24","074_24_24","ACT","24","24","24","કોલહાક દિહયાહા પાછે ફેલિક્સ રાજ્યપાલ ચ્ચા થેએ દ્રુસિલાલ, જીં યહૂદીની આતી, આરે લેયને યેનો એને પાઉલાલ હાદાડીન ચ્ચા બોરાહા બારામાય જો ઈસુ ખ્રિસ્તાવોય હેય, ચ્ચાથી વોનાયા. ");
INSERT INTO gbl_vpl VALUES ("AC24_25","074_24_25","ACT","24","25","25","જોવે પાઉલે જીં પોરમેહેરા હામ્મે હાચ્ચાં હેય, તી કોઅરા એને પોતાની લોબ લાલચવોય તાબામાંય રાખના એને પોરમેહેરાથી યેનારા ન્યાયા બારામાય આખા શુરવાત કોઅયા, ફેલિક્સાય બિઅતો-બિઅતો જોવાબ દેનો, “યે સમયે તું જો, જોવે માયેપાંય સમય રોય, આંય પોતે તુલ હાદી લિહીં.” ");
INSERT INTO gbl_vpl VALUES ("AC24_26","074_24_26","ACT","24","26","26","આમી, ફેલિક્સ ચ્ચે વાતહેબારામાય બિઅતો આતો, જ્યો પાઉલે આખલ્યો આત્યો, તેરુંબી તો ચ્ચાલ હાદતો આતો એને ચ્ચા હાતે વાતો કોઅતો આતો, કાહાકા તો વિચારતો આતો કા તો જેલેમાઅને બારે નિંગાહાટી ચ્યાલ કાય પોયહા દી ઈ આશા આતી. ");
INSERT INTO gbl_vpl VALUES ("AC24_27","074_24_27","ACT","24","27","27","બાકી બેન વોરહે નિંગી ગીયે, તે ફેલિક્સા જાગાવોય પુરકિયુસ ફેસ્તુસ રાજ્યપાલ બોની ગીયો, એને ફેલિક્સ યહૂદીયાહાન ખુશ કોઅના ઇચ્છાથી પાઉલાલ જેલેમાયજ થોવી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC25_1","074_25_1","ACT","25","1","1","તીન દિહયાહા પાછે ફેસ્તુસ રાજ્યપાલા રુપામાય યહૂદી વિસ્તારમાય યેનો, પાછો તો કૈસરીયા શેહેરા એસને યેરૂસાલેમ શેહેરામાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC25_2","074_25_2","ACT","25","2","2","તોવે મુખ્ય યાજકાહાય એને યહૂદી આગેવાન લોકહાય ચ્ચા હામ્મે પાઉલાવોય દોષ થોવ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC25_3","074_25_3","ACT","25","3","3","એને ચ્ચાહાય ફેસ્તુસાલ વિનાંતી કોઇન ઈ વિચાર્યા કા તો પાઉલાલ યેરૂસાલેમ શેહેરામાય હાદાંહાટી કૃપા કોએ, કાહાકા ચ્ચા ચ્ચાલ વાટે માંયજ માઆઇ ટાકાંહાટી ટુંગી રીયલા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC25_4","074_25_4","ACT","25","4","4","ફેસ્તુસાય જાવાબ દેનો, “પાઉલ કૈસરીયા શેહેરા જેલેમાય હેય, એને આંય પોતે માહારી તાં જાહીં.” ");
INSERT INTO gbl_vpl VALUES ("AC25_5","074_25_5","ACT","25","5","5","પાછે આખ્યાં, “તુમહેવોય જ્યા આગેવાન હેતા ચ્યા હાતે ચાલે, એને જો યા માઅહાય કાય જુઠા કામ કોઅયાહાં, તે ચ્ચાવોય દોષ લાવે.” ");
INSERT INTO gbl_vpl VALUES ("AC25_6","074_25_6","ACT","25","6","6","ફેસ્તુસ યેરૂસાલેમ શેહેરામાય આઠ દસ દિહી રોયન તો કૈસરીયા શેહેરમાય ગીયો: એને બીજે દિહી ન્યાયા જાગાવોય બોહીન પાઉલાલ લેય યેઅના આગના દેની. ");
INSERT INTO gbl_vpl VALUES ("AC25_7","074_25_7","ACT","25","7","7","જોવે તો યેનો, તે જ્યા યહૂદી આગેવાન યેરૂસાલેમ શેહેરમાઅને યેનલા આતા, ચ્યાહાય આહી-પાહી ઉબા રોયન ચ્ચાવોય બોજ ગંભીર દોષ દેનો, જ્યા સાબિતી ચ્ચા નાંય દેય હોક્યા. ");
INSERT INTO gbl_vpl VALUES ("AC25_8","074_25_8","ACT","25","8","8","તોવે ફેસ્તુસા બોચાવામાય પાઉલે આખ્યાં, “માયે નાંય તે યહૂદીયાહા નિયમાહા વિરુદ નાંય દેવાળા એને નાંય કૈસરા વિરુદ, કાય ગુનો કોઅયહો.” ");
INSERT INTO gbl_vpl VALUES ("AC25_9","074_25_9","ACT","25","9","9","તોવે ફેસ્તુસાય યહૂદી આગેવાનાહાન ખુશ કોઅના ઇચ્છાથી પાઉલાલ પુછ્યાં, “કાય તું વિચારતોહો કા યેરૂસાલેમ શેહેરામાય જાતા, એને તાં મા હામ્મે તો ઓ ન્યાય નોક્કી કોઅલો જાય?” ");
INSERT INTO gbl_vpl VALUES ("AC25_10","074_25_10","ACT","25","10","10","પાઉલે આખ્યાં, “આંય કૈસરીયા શેહેરા ન્યાયા જાગા હામ્મે ઉબો હેતાંવ, મા ન્યાયા ઓજ નિર્ણય ઓરા જોજે, જેહેકેન તું હારેરીતે જાંઅતોહો, યહૂદીયાહા માયે કાય ગુનો નાંય કોઅયોહો. ");
INSERT INTO gbl_vpl VALUES ("AC25_11","074_25_11","ACT","25","11","11","જો ગુનેગાર હેતાંવ એને માઆઇ ટાકલાં જાય ઓહડા કાય કામ કોઅયાહાં, તે મોઅનાથી નાંય બિયું, બાકી જ્યેં વાતહે યા માયેવોય દોષ લાવતાહા, જો ચ્ચે માઅને કાદી વાત હાચ્ચી નાંય ઠોરે, તો કાદાલ ઓદિકાર નાંય કા ચ્ચા માન યહૂદી લોકહા આથામાય હોઅપે, મા વિનાંતી હેય કા મા ન્યાય પોતે કૈસરાથી કોઅલો જાં જોજે.” ");
INSERT INTO gbl_vpl VALUES ("AC25_12","074_25_12","ACT","25","12","12","તોવે ફેસ્તુસાય મંત્ર્યાહા સોબાયે હાતે વિચાર કોઇન જાવાબ દેનો, “તુયે કૈસરાથી ન્યાય ઓરા જોજે યાહાટી વિનાંતી કોઅયીહી તે તું કૈસરાપાય જાહાય.” ");
INSERT INTO gbl_vpl VALUES ("AC25_13","074_25_13","ACT","25","13","13","કોલહાક દિહી પાછે અગ્રીપ્પા રાજા એને ચ્ચા વાહની બોઅહી બિરનીકેય કૈસરીયા શેહેરામાય યેયન ફેસ્તુસાલ બેટ કોઅઇ. ");
INSERT INTO gbl_vpl VALUES ("AC25_14","074_25_14","ACT","25","14","14","ચ્યાહા બોજ દિહી તાં રોયા પાછે ફેસ્તુસે પાઉલા બારામાય રાજાલ આખ્યાં, “યોક માઅહું હેય, જ્યાલ ફેલિક્સ જેલેમાય છોડી ગીયહો. ");
INSERT INTO gbl_vpl VALUES ("AC25_15","074_25_15","ACT","25","15","15","જોવે આંય યેરૂસાલેમ શેહેરામાય આતો, તે મુખ્ય યાજક એને યહૂદીયાહા આગેવાનાહાય ચ્યાવોય દોષ લાવ્યો એને વિચાર્યા, કા ચ્યાવોય ડોંડ કોઅના આગના દેનલી જાય. ");
INSERT INTO gbl_vpl VALUES ("AC25_16","074_25_16","ACT","25","16","16","બાકી માયે ચ્યાહાન જોવાબ દેનો, કાદા માઅહાલ ડૉડ દાં પેલ્લા, ચ્યાવોય દોષ દેનારાહા હામ્મે ઉબો રોયન ચ્યાવોય લાવલા દોષા જાવાબ દેઅના મોકો મીળે. ");
INSERT INTO gbl_vpl VALUES ("AC25_17","074_25_17","ACT","25","17","17","યાહાટી જોવે યહૂદી આગેવાન મા હાતે ઈહીં કૈસરીયા શેહેરમાય યેના, તે માયે કાય વાઆ નાંય લાવી, બાકી બીજેજ દિહી ન્યાયા જાગાવોય બોહીન, માયે હુકુમ દેનો કા પાઉલાલ આદાલતેમાય લેય યેય. ");
INSERT INTO gbl_vpl VALUES ("AC25_18","074_25_18","ACT","25","18","18","જોવે ચ્યા ફીરાદીવાળા ઉબા જાયા, તે ચ્યાહાય ઓહડયે ખારાબ વાતહે દોષ નાંય લાવ્યો, જેહેકેન આંય હોમાજતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC25_19","074_25_19","ACT","25","19","19","બાકી ચ્યાહા વોચ્ચે આપહે ધર્માલ લેયને એને ઈસુ નાંવા યોક માઅહા બારામાય કાંયક બોલા-બોલી આતી, તો મોઅઇ ચુક્યહો: બાકી પાઉલ દાવો કોઅહે કા તો જીવતો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC25_20","074_25_20","ACT","25","20","20","કાહાકા માન નાંય ખોબાર આતા કા યે વાતહે હોદ-પારાખ કેહેકેન કોઉ, યાહાટી માયે પાઉલાલ પુછ્યાં, ‘કાય તું યેરૂસાલેમ શેહેરમાય જાહાય, કા તાં યે વાતહે ન્યાય કોઅલો જાય?’ ");
INSERT INTO gbl_vpl VALUES ("AC25_21","074_25_21","ACT","25","21","21","બાકી જોવે પાઉલે વિનાંતી કોઅયી કા, ‘મા ન્યાયા ફેસલો કૈસરા ઈહીં ઓએ,’ તે માયે આગના દેની, કા જાવ હુદુ ચ્ચાલ કૈસરાપાય નાંય દોવાડું, ચ્ચા રાખવાળી કોઅલી જાય.” ");
INSERT INTO gbl_vpl VALUES ("AC25_22","074_25_22","ACT","25","22","22","તોવે અગ્રીપ્પાય ફેસ્તુસાલ આખ્યાં, “આંયબી ચ્યા માઅહા વોનાયા માગતહાવ. ચ્ચે આખ્યાં, તું હાકાળ વોનાય લેહે.” ");
INSERT INTO gbl_vpl VALUES ("AC25_23","074_25_23","ACT","25","23","23","આમી બીજે દિહી, જોવે અગ્રીપ્પા એને બિરનીકે બોજ મોઠી દુમધામથી યેયન સૈન્યાહા ટુકડયે જોમાદાર એને શેહેરા મુખ્ય લોકહા હાતે દરબારા માય પોઅચ્યે, તોવે ફેસ્તુસાય આગના દેની, કા ચ્ચા પાઉલાલ લેય યેના. ");
INSERT INTO gbl_vpl VALUES ("AC25_24","074_25_24","ACT","25","24","24","ફેસ્તુસે આખ્યાં, “ઓ રાજા અગ્રીપ્પા, એને યે બોદે માઅહે જ્યેં ઈહીં આમહેહાતે હેતેં, તુમા યા માઅહાન એઆ, જ્યા બારામાય બોદા યહૂદીહાય યેરૂસાલેમ શેહેરામાય એને ઈહીંબી બોંબલી-બોંબલીન માન વિનાંતી કોઅઇ, કા યા જીવતા રોઅના યોગ્ય નાંય. ");
INSERT INTO gbl_vpl VALUES ("AC25_25","074_25_25","ACT","25","25","25","બાકી માયે જાઈ લેદા કા ચ્ચે ઓહડા કાય નાંય કોઅયાહાં કા માઆઇ ટાકલો જાય, એને જોવેકા ચ્ચે પોતેજ કૈસરાલ વિનાંતી કોઅયી, તે માયે ચ્ચાલ રોમ શેહેરામાય દોવાડાહાટી નોક્કી કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC25_26","074_25_26","ACT","25","26","26","બાકી માન ચ્ચા બારામાય કાય આરાપ નાંય મિળ્યો કા સમ્રાટાલ લિખું, યાહાટી આંય ચ્ચાલ તુમહે હામ્મે એને વિશેષ કોઇન ઓ રાજા અગ્રીપ્પા તો હામ્મે લેય યેનોહો, કા પારખ્યા પાછે માન કાય લોખના મીળે. ");
INSERT INTO gbl_vpl VALUES ("AC25_27","074_25_27","ACT","25","27","27","કાહાકા કૈદ્યાલ દોવાડના એને જ્યા દોષ ચ્ચાવોય લાવલા ગીઅલા, ચ્ચાહાન નાંય આખના, માન હારાં નાંય લાગ્યા.” ");
INSERT INTO gbl_vpl VALUES ("AC26_1","074_26_1","ACT","26","1","1","અગ્રીપ્પાય પાઉલાલ આખ્યાં, “તુલ પોતાના બારામાય બોલના પરવાનગી હેય,” તોવે પાઉલે લોકહાન ઠાવકા રાંહાટી આથા ઈશારો કોઇન જોવાબ દાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC26_2","074_26_2","ACT","26","2","2","ઓ રાજા અગ્રીપ્પા, જોલ્યે વાતહે યહૂદી આગેવાન માયેવોય દોષ લાવતાહા, આજે તો હામ્મે ચ્ચા જાવાબ દેઅના આંય પોતાલ ધન્ય હોમાજતાહાવ, ");
INSERT INTO gbl_vpl VALUES ("AC26_3","074_26_3","ACT","26","3","3","વિશેષ કોઇન યાહાટી કા તું યહૂદીયાહા બોદા રીતી રીવાજ એને ચર્ચાયો જાંઅતોહો યાહાટી આંય વિનાંતી કોઅતાહાંવ દિયાન દેયને મા વોનાય લે. ");
INSERT INTO gbl_vpl VALUES ("AC26_4","074_26_4","ACT","26","4","4","જોવે આંય જુવાન્યોજ આતો તોવે આંય આપહે લોકહા વોચ્ચે એને યેરૂસાલેમ શેહેરમાય કેહેકેન રોતો આતો ઈ બોદા યહૂદી જાંઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC26_5","074_26_5","ACT","26","5","5","યાહાટી કા ચ્ચા માન જુવાન્યેથીજ જાંઅતેહે, ચ્ચા ઓઅય હોકે તે, યે વાતે સાક્ષીબી દેય હોકતાહા, કા આંય યોક પોરૂષી હારકો રિયો, જીં કા આમે ધર્મા બોદહાથી મોજબુત ટોળો હેય. ");
INSERT INTO gbl_vpl VALUES ("AC26_6","074_26_6","ACT","26","6","6","એને આજે આંય ચ્ચે કોસામે આશાયે લીદે જીં પોરમેહેરાય આમહે આગલ્યા ડાયહા આરે કોઅલી આતી, ઈહીં દોષા રૂપા માય આંય ઉબો હેતાંવ. ");
INSERT INTO gbl_vpl VALUES ("AC26_7","074_26_7","ACT","26","7","7","ચ્ચે કોસામે પુરાં ઓઅના આશા રાખીન, આમહે બારા કુળ પોતાના બોદા મનથી રાત-દિહી પોરમેહેરા ભક્તિ કોઅતા યેનહા, ઓ રાજા, યેજ આશાયે લીદે યહૂદી માયેવોય દોષ લાવતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC26_8","074_26_8","ACT","26","8","8","તોવે પાઉલે વોનાનારા બોદા યહૂદીહાન આખ્યાં, તે લોક બોરહો કોઅતાહા કા પોરમેહેર મોઅલા લોકહાન પાછો જીવતો કોઅઇ હોકહે, તે પાછે તુમા યે વાતવોય બોરહો કોઅનાથી નાકાર કાહા કોઅતાહા કા ચ્ચાય ઈસુલ મોઅલા માઅને જીવતો કોઅયો? ");
INSERT INTO gbl_vpl VALUES ("AC26_9","074_26_9","ACT","26","9","9","આંયબી હોમજ્યેલ કા નાજરેત ગાવામાય રોનારો ઈસુ નાંવા વિરુદમાય મા બોજ કાઅઈ કોઅરા જોજે. ");
INSERT INTO gbl_vpl VALUES ("AC26_10","074_26_10","ACT","26","10","10","એને માયે યેરૂસાલેમ શેહેરામાય એહકોયજ કોઅયા, એને મુખ્ય યાજકાહા પાઅને ઓદિકાર મેળવીન બોજ પવિત્ર લોકહાન જેલેમાય ટાક્યા, એને જોવે ચ્યાહાન માઆઇ ટાકાલા જાતા આતા, તેરુંબી ચ્ચાહા વિરુદમાય પોતાની પરવાનગી દેતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC26_11","074_26_11","ACT","26","11","11","કોલહિક વોખાત માયે ચ્યાહાન સોબાયે ઠિકાણાહામાય શિક્ષા દેવાડી એને ઈસુવા નિંદા કોઆડતો આતો, ઈહીં હુદુ કા ઓલો ગુસ્સા કા બિજા શેહેરાહામાય બી જાયને સતાવતો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC26_12","074_26_12","ACT","26","12","12","યે ધુંદ્યેમાય આંય મુખ્ય યાજકાહાથી ઓદિકાર એને આગના પત્ર લેયને દમસ્ક શેહેરામાય જાય રીયલો આતો. ");
INSERT INTO gbl_vpl VALUES ("AC26_13","074_26_13","ACT","26","13","13","તે ઓ રાજા, વાટયે માય બોપરી વેળે માયે આકાશામાઅને દિહયા ઉજવાડા કોઅતાબી વદારે યોક ઉજવાડો, પોતે એને પોતાના હાતે ચાલાનારાહા ચારીચોમખી ચોમકાતા દેખ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC26_14","074_26_14","ACT","26","14","14","એને જોવે આમા બોદા દોરત્યેવોય પોડી ગીયા, તે માયે હિબ્રુની ભાષામાય, માન આખતા ઓ આવાજ વોનાયો, ઓ શાઉલ, ઓ શાઉલ, તું માન કાહા સતાવતોહો? મા વિરુદ લોડના મૂર્ખતા હેય. ");
INSERT INTO gbl_vpl VALUES ("AC26_15","074_26_15","ACT","26","15","15","માયે આખ્યાં, ઓ પ્રભુ, તું કું હેય? પ્રભુય આખ્યાં, આંય ઈસુ હેય, જ્યાલ તું સતાવતોહો. ");
INSERT INTO gbl_vpl VALUES ("AC26_16","074_26_16","ACT","26","16","16","બાકી તું ઉઠ, પોતાના પાગવાહાવોય ઉબો ઓઓ, કાહાકા માયે તુલ યાહાટી દર્શન દેનહા કા તુલ આંય સેવક બોનાડુ એને જીં દર્શન તું એઅય ચુકયોહો, એને જીં દર્શન પાછે એઅહે ચ્ચા સાક્ષીદાર બી બોનાડુ. ");
INSERT INTO gbl_vpl VALUES ("AC26_17","074_26_17","ACT","26","17","17","એને આંય તુલ તો લોકહાથી એને ગેર યહૂદીયાહાથી બોચાવતો રોહીં, આંય તુલ ચ્યાહાપાય યાહાટી દોવાડતાહાવ કા તું ચ્ચાહા ડોળા ઉગડાવે, ");
INSERT INTO gbl_vpl VALUES ("AC26_18","074_26_18","ACT","26","18","18","કા ચ્ચા અંધકાર માઅને ઉજવાડા એછે, એને સૈતાના ઓદિકારા ઇહિને પોરમેહેરાએછે ફિરે, એને પોતાના પાપહા પોરમેહેરા પાયને માફી મિળવે, એને ચ્ચા લોકહા હાતે યોક જાગો મિળવે જ્યા યાહાટી પવિત્ર કોઅલા ગીયહો કાહાકા માયેવોય બોરહો કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("AC26_19","074_26_19","ACT","26","19","19","“યાહાટી ઓ રાજા અગ્રીપ્પા, માયે ચ્યા હોરગા દર્શના પાલન કોઅયા, ");
INSERT INTO gbl_vpl VALUES ("AC26_20","074_26_20","ACT","26","20","20","બાકી પેલ્લા દમસ્ક શેહેરા, પાછા યેરૂસાલેમ શેહેરા રોનારાહાલ, તોવે યહૂદી વિસ્તારા બોદા ઇલાકામાય એને ગેર યહૂદીયાહાલ માયે સંદેશ દેનો કા પાપ કોઅના છોડી દા એને પોરમેહેરાએછે ફિરીન એહેકેન જીવા કા લોકહાન ખોબાર પોડે તુમાહાય પાપ કોઅના બંદ કોઅઇ દેનહા. ");
INSERT INTO gbl_vpl VALUES ("AC26_21","074_26_21","ACT","26","21","21","યે વાતહે લીદે યહૂદી માન દેવાળામાય દોઇન માઆઇ ટાકના કોશિશ કોઅતા આતા. ");
INSERT INTO gbl_vpl VALUES ("AC26_22","074_26_22","ACT","26","22","22","બાકી પોરમેહેરા મોદાતકોય આંય આજે હુદુ જીવતો હેય એને હાના-મોઠા બોદહા હામ્મે સાક્ષી દેતહાવ, આંય ચ્ચે વાતહેલ છોડીન કાય નાંય આખું, જીં ભવિષ્યવક્તાહાય એને મૂસાય બી આખ્યાં કા ઓઅનારી હેય, ");
INSERT INTO gbl_vpl VALUES ("AC26_23","074_26_23","ACT","26","23","23","કા ખ્રિસ્તાલ દુ:ખ વેઠાં પોડી, એને તોજ બોદહાથી પેલ્લો મોઅલાહામાઅને જીવી ઉઠીન, યહૂદીયા એને ગેર યહૂદીયાહાન તારણા ઉજવાડા ઘોષણા કોઅરાહાટી કા ચ્ચા બોચી હોકતાહા, જીં કા ઉજવાડા હારકા હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC26_24","074_26_24","ACT","26","24","24","જોવે પાઉલ યે રીતેથી જાવાબ દેય રિઅલો આતો, “તે ફેસ્તુસાય મોઠે આવાજથી આખ્યાં, ઓ પાઉલ, તું ગાંડો હેય, બોજ શિક્ષાણે તુલ ગાંડવાડી દેનહો.” ");
INSERT INTO gbl_vpl VALUES ("AC26_25","074_26_25","ACT","26","25","25","બાકી પાઉલે આખ્યાં, “ઓ મહાસમ્રાટ ફેસ્તુસ, આંય ગાંડો નાંય, બાકી હાચ્ચાયે એને બુદયે વાતો આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("AC26_26","074_26_26","ACT","26","26","26","રાજાબી જ્યા હામ્મે આંય બિઅયા વોગાર બોલી રિયહો, યો વાતો જાંઅતોહો, એને માન બોરહો હેય, યે વાતેહેમાઅને કાદી ચ્ચાથી દોબલી નાંય, કાહાકા તી ઘટના દોબીન નાંય ઓઅઇ. ");
INSERT INTO gbl_vpl VALUES ("AC26_27","074_26_27","ACT","26","27","27","ઓ રાજા અગ્રીપ્પા, કાય તું ભવિષ્યવક્તાહા બોરહો કોઅતોહો? હાં, આંય જાંઅતાહાંવ, કા તું બોરહો કોઅતોહો.” ");
INSERT INTO gbl_vpl VALUES ("AC26_28","074_26_28","ACT","26","28","28","આમી અગ્રીપ્પાય પાઉલાલ આખ્યાં, કાય તું વોછાજ હોમજાવાથી માન ખ્રિસ્તી બોનાડા માગતોહો? ");
INSERT INTO gbl_vpl VALUES ("AC26_29","074_26_29","ACT","26","29","29","પાઉલે આખ્યાં, “પોરમેહેરાલ મા પ્રાર્થના ઈ હેય કા કાય વોસામાય, કાય વોદારી માય, ખાલી તુંજ નાંય, બાકી જોલા લોક આજે મા વોનાતાહા, મા ઇચ્છા હેય કા તુમા બોદા મા હારકે ખ્રિસ્ત્યા બોનહા બાકી યોક કૈદ્યા રુપામાય નાંય.” ");
INSERT INTO gbl_vpl VALUES ("AC26_30","074_26_30","ACT","26","30","30","તોવે રાજા એને રાજ્યપાલ એને બિરનીકે એને ચ્યાહા હાતે બોહનારા ઉઠીન ઉબા રિયા એને જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC26_31","074_26_31","ACT","26","31","31","જોવે ચ્યા બારે જાય રીઅલા આતા, ચ્યા યોકબિજાલ આખા લાગ્યા, “યા માઅહાય મોરણા સજા કા જેલેમાય ટાકના લાયક્યે કાય ગુનો નાંય કોઅયોહો.” ");
INSERT INTO gbl_vpl VALUES ("AC26_32","074_26_32","ACT","26","32","32","અગ્રીપ્પાય ફેસ્તુસાલ આખ્યાં, “જો ઈ માઅહું કૈસરાલ વિનાંતી નાંય કોઅતો, તે છુટી હોકતો આતો.” ");
INSERT INTO gbl_vpl VALUES ("AC27_1","074_27_1","ACT","27","1","1","જોવે ફેસ્તુસ રાજ્યપાલથી ઈ નોક્કી ઓઅયા કા આમા જાહાજથી ઇટલી વિસ્તારામાય જાતા, તે રોમી ઓદિકાર્યાહાય પાઉલ એને કોલાહાક બિજા કૈદયાહાલબી યુલિયુસ નાંવા શતપતી આથામાય હોઅપી દેના, યુલિયુસ સમ્રાટ આૈગુસ્તુસ સૈનિકાહા ટુકડી જોમાદાર આતો. ");
INSERT INTO gbl_vpl VALUES ("AC27_2","074_27_2","ACT","27","2","2","અદ્રમુત્તિયુમ શેહેરા યોક જાહાજાવોય જીં આસિયા વિસ્તારા મેરાવોર્યા જાગામાય જાં તિયાર આતા, બોહીન આમાહાય આમે મુસાફરી સુરુ કોઅઇ દેની, એને અરિસ્તર્ખુસ નાંવા જો મોકોદુનિયા વિસ્તારા થેસ્સાલોનિક શેહેરા રોનારો આતો આમે હાતે આતો. ");
INSERT INTO gbl_vpl VALUES ("AC27_3","074_27_3","ACT","27","3","3","બીજે દિહી આમા સિદોન શેહેરામાય પોઅચી ગીયા એને, યુલિયુસાય પાઉલાવોય દોયા કોઅઈન ચ્ચાલ દોસ્તારાહાઈહી જાં દેના કા ચ્ચાહા જરુરી વસ્તુ લી યેય. ");
INSERT INTO gbl_vpl VALUES ("AC27_4","074_27_4","ACT","27","4","4","તાંઅરે આમહાય બીજેદા મુસાફરી સુરુ કોઅયી એને હામ્મેને વારો યા લાગ્યો, યા લીદે આમહાન સાઇપ્રસ બેટા ઇહિને આગલા જાં પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_5","074_27_5","ACT","27","5","5","એને કિલિકિયા વિસ્તાર એને પંફૂલિયા વિસ્તારા મેરાવોયને દોરિયામાઅને લૂસિયા વિસ્તારા મૂરા શેહેરામાય પોઅચ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_6","074_27_6","ACT","27","6","6","તાં સરદારાલ સિકન્દરિયા શેહેરા યોક જાહાજ ઇટલી વિસ્તારમાય જાતા મિળ્યાં, એને ચ્ચાય આમહાન ચ્ચા જાહાજ વોય ચોડવી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC27_7","074_27_7","ACT","27","7","7","જોવે આમા બોજ દિહયા હુદુ દિરે-દિરે ચાલીન બોજ કઠાણતા થી કનિદુસ શેહેરા હામ્મે પોઅચ્યા, તે યાહાટી કા હામ્મેથી વારો આમહાન આગલા નાંય જાં દેતો આતો, આમા સલમોના હામ્મેથી ક્રેતે બેટ બાજુ માઅને ચાલ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_8","074_27_8","ACT","27","8","8","એને ચ્ચા મેરા-મેરાવોય કોઠાણ થી ચાલીન સુંદર બંદર નાંવા યોક જાગાવોય પોઅચ્યા, તાઅને લસયા શેહેર પાહી આતા. ");
INSERT INTO gbl_vpl VALUES ("AC27_9","074_27_9","ACT","27","9","9","જોવે બોજ દિહી વિતી ગીયા, એને દોરિયામાઅને મુસાફરી માય આબદા યાહાટી ઓઅતી આતી કાહાકા ઉપાસા દિહયે સણ પુરો ઓઅઇ ગીઅલો આતો. એને ઓજ તો મોસામ હેય, જોવે દોરિયો બોજ ખતરનાક ઓઅય જાહે યાહાટી પાઉલે ચ્ચા બોદહાન ઈ આખીન હોમજાડ્યા, ");
INSERT INTO gbl_vpl VALUES ("AC27_10","074_27_10","ACT","27","10","10","“ઓ બાહાહાય, માન એહેકોય જાણાયેહે કા યે મુસાફરી માય આબદા એને બોજ નુકસાન, નાંય ખાલી માલ એને જાહાજા બાકી આપહે જીવાલ બી ઓઅનારા હેય, યાહાટી મા ઈ સલાહા હેય કા આપા ખતરા મોસમા પાછે હુદુ ઈહીં વાટ જોવજે.” ");
INSERT INTO gbl_vpl VALUES ("AC27_11","074_27_11","ACT","27","11","11","બાકી સુબેદારાય કેપ્તાન એને જાહાજા માલિકા વાતહેલ પાઉલા વાતહે કોઅતા વોદારે માન્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_12","074_27_12","ACT","27","12","12","સુંદર બંદર નાંવા યોક બંદરગાહ હિયાળો દિહી કાડનાહાટી સુરક્ષિત નાંય આતા, યાહાટી બોજ જાંઅહા વિચાર જાયો કા તાઅને આગલા નિંગી જાય જો કોઅહિબી રીતે ઓઅઇ હોકે તે ફીનિક્સ બંદરગામાય પોઅચીન હિયાળા દિહી કાડજે, ઓ તે ક્રેતે બેટા મેરાવોય યોક બંદરગો હેય, જ્યા દોરવાજો દક્ષીણ-પચ્છીમ એને ઉત્તર-પચ્છીમ એછે હેય. ");
INSERT INTO gbl_vpl VALUES ("AC27_13","074_27_13","ACT","27","13","13","જોવે દક્ષિણા વાય-વાય વારો ચાલા લાગ્યો, તોવે ચ્યાહાય વિચાર્યા કા ચ્ચા યોજનાયે પરમાણે ફીનિક્સ પોઅચી જાહું, યાહાટી ચ્યાહાય લંગાર ઇસી લેદો એને ક્રેતે બેટા મેરા દોરિયામાઅને ઓઇન આગલા વોદ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_14","074_27_14","ACT","27","14","14","બાકી વાયજ વાઅયે બેટા એહેરે યોક મોઠો તુફાન ઉઠયો, જીં યૂરકુલીન આખાયેહે. ");
INSERT INTO gbl_vpl VALUES ("AC27_15","074_27_15","ACT","27","15","15","જોવે તુફાન જાહાજેલ લાગ્યો, તોવે જાહાજ વારા હામ્મે ઠોરી નાંય હોક્યા, યાહાટી આમાહાય જાહાજેલ વારા હામ્મે છોડી દેના, એને યે રીતે વોવતા જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC27_16","074_27_16","ACT","27","16","16","કૌદા નાંવા યોક વાહના બેટા આલુડ પોઅચીન જાહાજા પાછાડી બાંદલા ઉડ્યા સુરક્ષિત કોઅનામાય સક્ષમ રિયા, બાકી એહેકેન કોઅના બોજ મુસ્કિલ આતાં. ");
INSERT INTO gbl_vpl VALUES ("AC27_17","074_27_17","ACT","27","17","17","પાછે જાહાજ ચાલાડનારા જીવનરક્ષક જાહાજેલ ઉચકીન ચ્ચેલ સુરક્ષિત કોઅયા બોજ યુક્તિ કોયન જાહાજેલ નિચેથી લેયને ઉચે હુદી આસડાકોય ખેચીન બાંદી દેના એને સુરતિસ ખાડયે રેઅટાવોય ફસાય જાઅના બિકથી ચ્ચાહાય લંગાર ઉતાડીન જાહાજેલ વોવતા વારા હાતે-હાતે વોવીજાહાટી છોડી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC27_18","074_27_18","ACT","27","18","18","જોવે આમાહાય તુફાનાથી બોજ વારા કોઇન બોજ આલાં લાગ્યા એને ધોક્કા ખાદાં, તોવે બીજે દિહી ચ્યા જાહાજા માલ ટાકાં લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_19","074_27_19","ACT","27","19","19","એને તીજે દિહી ચ્યાહાય ચ્યાહા આથા કોઇન જાહાજા માલ સામાન ટાકી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC27_20","074_27_20","ACT","27","20","20","જોવે બોજ દિહયા હુદુ નાંય દિહી નાંય ચાંદાલેં દેખાય, એને મોઠો તુફાની વારો ચાલતો આતો, તોવે છેલ્લે આમે બોચના આશા જાતી રોયી. ");
INSERT INTO gbl_vpl VALUES ("AC27_21","074_27_21","ACT","27","21","21","જોવે ચ્યા બોજ દિહયા હુદુ બુખા રોય ચુક્યા, તે પાઉલે ચ્યાહા વોચ્ચે ઉબો રોયન આખ્યાં, “ઓ લોકહાય, જો ક્રેતે ઇહિને જાઅના મા સલાહા તુમા માની લેતા તે તુમા યા વિનાશ એને નુકસાન થી બોચી જાતા. ");
INSERT INTO gbl_vpl VALUES ("AC27_22","074_27_22","ACT","27","22","22","બાકી આંય તુમહાન આમી હોમજાડુહું કા ઈંમાત રાખા, કાહાકા તુમહેમાઅને કાદાજ જીવા નુકસાન નાંય ઓઅરી બાકી જાહાજા નોકીજ નુકસાન ઓઅરી, ");
INSERT INTO gbl_vpl VALUES ("AC27_23","074_27_23","ACT","27","23","23","કાહાકા પોરમેહેર જ્યા આંય હેય, એને જ્યા ભક્તિ કોઅહુ, ચ્યા હોરગા દૂતાય ગીયી રાતી માપાય યેયન આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC27_24","074_27_24","ACT","27","24","24","‘ઓ પાઉલ, બીયહે મા તુલ કૈસરા હામ્મે ઉબા રોઅના જરુરી હેય, એને પોરમેહેરાય બોદહાન જ્યા તોઆરે મુસાફરી કોઅતાહા, ચ્યા બોદહાન વરદાન દેનહા.’ ");
INSERT INTO gbl_vpl VALUES ("AC27_25","074_27_25","ACT","27","25","25","યાહાટી, ઓ માઅહાય, ઈંમાત રાખા, કાહાકા આંય પોરમેહેરાવોય બોરહો કોઅહુ, કા જેહેકેન માન આખવામાય યેનહા, તેહેકેનુજ ઓઅરી. ");
INSERT INTO gbl_vpl VALUES ("AC27_26","074_27_26","ACT","27","26","26","બાકી આમહાન યોકદા બેટવોય જાયને રા પોડી.” ");
INSERT INTO gbl_vpl VALUES ("AC27_27","074_27_27","ACT","27","27","27","જોવે ચૌવુદવી રાત ઓઅઇ, એને આમા આંદ્રિયા દોરિયામાય બટકી રીઅલા આતા, તોવે આરદ્યે રાતી પાહી જાહાજ ચાલાડનારાહાય જાંઅયા કા આમા યોકદા મેરા પાહી પોઅચી રીયહા. ");
INSERT INTO gbl_vpl VALUES ("AC27_28","074_27_28","ACT","27","28","28","ચ્યાહાય પાઆઈ માપા દોરી ટાકી તોવે ચ્યાહાન સત્રીસ મીટર ઉંડા પાઆઈ માલુમ પોડ્યા, એને વાહાય આગલા જાયને પાછા પાઆઈ માપા દોરી ટાકી તોવે સત્યાવીસ મીટર માલુમ પોડ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_29","074_27_29","ACT","27","29","29","તોવે દોગડા વાળી જાગામાય ઠોકાય જાય ચ્યા બિકથી ચ્યાહાય જાહાજા પાહલા ચાર લંગાર ટાક્યા, એને દિહી નિંગા વાટ જોવી રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC27_30","074_27_30","ACT","27","30","30","બાકી જાહાજ ચાલાડનારા જાહાજ વોઅને નાહા કોઅતા આતા, એને ચ્યાહાય જાહાજા હામ્મેથી લંગાર ટાકના બહાના કોઇન વાહની ઉડી દોરિયામાય ઉતાડી દેની; ");
INSERT INTO gbl_vpl VALUES ("AC27_31","074_27_31","ACT","27","31","31","તોવે પાઉલે સુબેદારાલ એને સૈનિકાહાલ આખ્યાં, જો યા જાહાજાવોય નાંય રોય, તે તુમાબી નાંય બોચી હોકહા. ");
INSERT INTO gbl_vpl VALUES ("AC27_32","074_27_32","ACT","27","32","32","તોવે સૈનિકાહાય દોરડે કાતરી ટાક્યેં એને વાહના ઉડ્યાંલ પાડી ટાક્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_33","074_27_33","ACT","27","33","33","જોવે ઉજાળાં ઓઅનારા આતા, તોવે પાઉલે ઈ આખીન, બોદહાન ખાઅના ખાંહાટી રાવ્યો કોઅયા, “આજે ચૌવુદમો દિહી ઓઅયો કા તુમા ચિંતા કોઅતા-કોઅતા બુખા રિયા, એને કાંઇજ ખાઅના નાંય ખાદાં. ");
INSERT INTO gbl_vpl VALUES ("AC27_34","074_27_34","ACT","27","34","34","યાહાટી આંય તુમહાન આખહુ કા કાય ખાય લા, જ્યાથી તુમહે બોચાવ ઓએ; કાહાકા તુમહેમાઅને કાદાબી નાશ નાંય ઓઈ.” ");
INSERT INTO gbl_vpl VALUES ("AC27_35","074_27_35","ACT","27","35","35","એને ઈ આખીન ચ્યાય બાખે લેઈને બોદહા હામ્મે પોરમેહેરા આભાર માનીન એને બાખે તોડીન ખાં લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC27_36","074_27_36","ACT","27","36","36","તોવે ચ્યા બોદા ઈંમાત કોઇન ખાઅના ખાં લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_37","074_27_37","ACT","27","37","37","આમા બોદા મિળીન જાહાજેમાય બોસો છોતેર જાંઆ આતા. ");
INSERT INTO gbl_vpl VALUES ("AC27_38","074_27_38","ACT","27","38","38","જોવે ચ્યા ખાઅના ખાયન દારાયા, તોવે ગોંવ દોરિયામાય ટાકી દેયને જાહાજ ઓળકાં કોઆ લાગ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_39","074_27_39","ACT","27","39","39","જોવે દિહી નિંગ્યો, તોવે ચ્યાહાય ચ્યા દેશાલ નાંય વોળખ્યો, બાકી યોક નોયાડો દેખ્યો, જ્યા મેરો ચોરાસ આતો, એને વિચાર કોઅયો એહેકોય ઓઈ હોકે તે ચ્યાવોય જાહાજ ઉબો રાખાયી. ");
INSERT INTO gbl_vpl VALUES ("AC27_40","074_27_40","ACT","27","40","40","તોવે ચ્યાહાય લંગારાહાલ ખોલીન દોરિયામાય છોડી દેના એને ચ્યેજ વેળે સુકાનના બી બોદાંજ દોરડા ખોલી દેના એને વારા હામ્મે આગલાર્યો ભાગ ચોડવીન મેરાવોય લેય ચાલ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC27_41","074_27_41","ACT","27","41","41","બાકી બેન દોરિયા યોકઠા ઓઅના તાં રેઅટા જાગે જાહાજા આગલો ભાગ ખુઅપાય ગીયો, ચ્યાહા જાહાજ ઉબા કોઅયા ચ્ચા આગલા નાંય વોદ્યા, બાકી જાહાજા પાહાલાને ભાગ લાફાહા કોઇન ટુંટા લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("AC27_42","074_27_42","ACT","27","42","42","તોવે સૈનિકાહાન વિચાર યેનો કા કૈદયાહાલ માઆઇ ટાકના, એહેકોય નાંય ઓએ કા કાદો જેપીન નિંગી જાય. ");
INSERT INTO gbl_vpl VALUES ("AC27_43","074_27_43","ACT","27","43","43","બાકી શતપતી પાઉલાલ બોચાડના ઇચ્છાથી ચ્યા વિચારથી રોક્યો, એને ઈ આખ્યાં કા, “જો જેપી હોકહે, પેલ્લા કુદીન મેરે નિંગી જાય. ");
INSERT INTO gbl_vpl VALUES ("AC27_44","074_27_44","ACT","27","44","44","જ્યા જેપી નાંય હોકે, ચ્યાહાય પાટ્યાહાવોય, એને બિજા જાહાજા કાય બીજી વસ્તુ આસરો લેઈને નિંગી જાય.” યે રીતેથી બોદાજ હારેરીતે મેરે પોઅચી ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC28_1","074_28_1","ACT","28","1","1","જોવે આમા બોદા મેરે હારેરીતે પોઅચી ગીયા, તોવે ખોબાર પોડ્યા કા ઓ બેટ માલ્ટા આખવામાય યેહે. ");
INSERT INTO gbl_vpl VALUES ("AC28_2","074_28_2","ACT","28","2","2","એને તાં રોનારા લોકહાય આમેવોય બોજ મોઠી દયા દેખાડી; કાહાકા હિયાળો આતો એને વરહાદ ઓઅરા લાગ્યો યાહાટી ચ્યાહાય આગ હોલગાડી એને આમે બોદહા સ્વાગત કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("AC28_3","074_28_3","ACT","28","3","3","જોવે પાઉલ લાકડે યોકઠે કોઇન બાઆ લી યેયન આગ્યેવોય થોવ્યો, તોવે યોક જેરીવાળા હાપડાં હેકથી નિંગ્યા એને ચ્યા આથા આરે વેટળાય ગીયા. ");
INSERT INTO gbl_vpl VALUES ("AC28_4","074_28_4","ACT","28","4","4","જોવે તાં રોનારા લોકહાય હાપડાલ ચ્યા આથા આરે વેટળાલા દેખ્યા, તોવે આપસમાય આખ્યાં, “હાચુલ ઈ માઅહું ખૂની હેય, કા જો દોરિયાકોય બોચી ગીયો, તેરુ ન્યાયે જીવતા રા નાંય દેના.” ");
INSERT INTO gbl_vpl VALUES ("AC28_5","074_28_5","ACT","28","5","5","તોવે ચ્યાય હાપડાલ આગડામાય ઝટકિ દેના, એને ચ્યાલ કાય નાંય જાયા. ");
INSERT INTO gbl_vpl VALUES ("AC28_6","074_28_6","ACT","28","6","6","ચ્યા લોક વાટ જોવાં આતા કા તો હુજી જાય, યા યોકાયોક પોડીન મોઅઇ જાય, બાકી જોવે ચ્યા બોજ વાઆ લોગુ એઅતા રિયા એને એઅયા કા ચ્યા કાયજ નાંય બગડયા, તોવે આજુ વિચાર કોઇન આખ્યાં, “ઓ તે કાદો દેવ હેય.” ");
INSERT INTO gbl_vpl VALUES ("AC28_7","074_28_7","ACT","28","7","7","ચ્યા જાગા આજુ-બાજુ પુબલીયુસ નાંવા ચ્યા બેટા ઓદિકારી આતો ચ્યા જાગો આતો, ચ્યાય આમહાન ચ્યા ગોઓ લી જાયન તીન દિહી પ્રેમથી દોસ્તારા હારકી ગાવાર ચાકરી કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC28_8","074_28_8","ACT","28","8","8","પુબલીયુસા આબહો બોજ જોરાકોય એને આઁવ લોય કોય રોગી એને મરડા થી પીડાતો આતો. આમી પાઉલે ચ્યા ગોઓ ખોલ્યેમાય જાયન પ્રાર્થના કોઅયી, એને ચ્યાવોય આથ થોવિન ચ્યાલ હારો કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC28_9","074_28_9","ACT","28","9","9","જોવે ઓહડા ઓઅયા, તે ચ્યા બેટવોય રોનારે બીજે બિમાર માઅહે પાઉલાપાય યેને એને હારેં કોઅવામાય યેને. ");
INSERT INTO gbl_vpl VALUES ("AC28_10","074_28_10","ACT","28","10","10","ચ્યાહાય આમહે બોજ આદર કોઅયો, જોવે આમા જાતા લાગ્યા તોવે જીં કાય આમેહાટી જરુરી આતા, તી જાહાજા માય થોવી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC28_11","074_28_11","ACT","28","11","11","તીન મોયના પાછે આમા આલેકસાંદ્રીયા યોક જાહાજ માય બોહીન નિંગ્યા, તી જાહાજ હિયાળા લીદે યા બેટવોય ઉબા રીઅલા આતા, ચ્યા જાહાજા આગલ્યા ભાગા વોય જુડવા દેવહા યોક ચિન્હ આતાં. યુનાની ભાષામાય જુડવા દેવહાન દિયુસકુરી આખલા જાય. ");
INSERT INTO gbl_vpl VALUES ("AC28_12","074_28_12","ACT","28","12","12","પાછે સુરકુસાસ શેહેરામાય જાયને આમા તીન દિહીહુદુ રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC28_13","074_28_13","ACT","28","13","13","તાઅને આગલા આમા ફિરીન રેગિયુમ શેહેરામાય પોઅચ્યા; એને યોક દિહી પાછે દક્ષીણ માય હાવા ચાલ્યો, તોવે આમા બીજે દિહી પુત્યેલી શેહેરામાય પોઅચ્યા. ");
INSERT INTO gbl_vpl VALUES ("AC28_14","074_28_14","ACT","28","14","14","તાં આમહાન કોલાહાક વિસ્વાસી બાહા મિળ્યાં, એને ચ્યાહા આખવાથી આમહાન યોક આઠવાડ્યા ચ્યાહાઆરે રા આખ્યાં, એને પાછે આમા રોમ શેહેરામાય જાયના શુરવાત કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("AC28_15","074_28_15","ACT","28","15","15","રોમ શેહેરામાઅને કોલહાક વિસ્વાસ્યા વોનાયા આમા તાં યેય રીયહા એને ચ્યા આમહાન મિળાં એને આમહાન રોમ લેય જાંહાટી અપ્પિયુસ ગાવા બાજાર એને તીન-સરાઈ નાંવા જાગાહુદુ યેના. ચ્યાહાન દેખીન પાઉલે પોરમેહેરા ધન્યવાદ કોઅયા એને બોજ ઉસરાય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("AC28_16","074_28_16","ACT","28","16","16","જોવે આમા રોમ શેહેરામાય પોઅચ્યા, તોવે પાઉલાલ યોક સીપાડા આરે જો ચ્યા રાખવાળી કોઅરા આતો, યોખલા રોઅના આગના મિળી. ");
INSERT INTO gbl_vpl VALUES ("AC28_17","074_28_17","ACT","28","17","17","તીન દિહયાહા પાછે ચ્યાય યહૂદી આગેવાનાહાન હાદ્યા, એને જોવે ચ્યા યોકઠા જાયા તોવે ચ્યાહાન આખ્યાં, “ઓ મા બાહાહાય, માયે પોતાના લોકહા વડીલાહા વ્યવહારા વિરુદમાય કાયજ નાંય કોઅયાહાં, તેરુંબી કૈદી બોનાડીન યેરૂસાલેમ શેહેરમાઅને રોમી ઓદિકાર્યાહા આથામાય હોઅપી દેના. ");
INSERT INTO gbl_vpl VALUES ("AC28_18","074_28_18","ACT","28","18","18","ચ્યાહાય માન પારખીન છોડી દેઅના વિચાર્યા, કાહાકા માંયેમાય મોઅના હારકા કાય દોષ નાંય આતો. ");
INSERT INTO gbl_vpl VALUES ("AC28_19","074_28_19","ACT","28","19","19","બાકી જોવે યહૂદી આગેવાન ચ્યા વિરુદમાય બોલા લાગ્યા, તે માન કૈસરા પાઅને માંગ કોઅરા પોડી કા ઈહીં રોમમાય મા ન્યાય કોએ ઈ નાંય કા માન પોતાના લોકહાવોય કાય દોષ લાવના આતો. ");
INSERT INTO gbl_vpl VALUES ("AC28_20","074_28_20","ACT","28","20","20","યાહાટી માયે તુમહાલ હાદ્યાહા, કા તુમહાન મિળું એને વાતચીત કોઉ; કાહાકા ઈસરાયેલા લોકહા આશાહાટી જો ખ્રિસ્ત હેય, જ્યા લીદે આંય યે હાકળેથી બાંદાલો હેતાંવ.” ");
INSERT INTO gbl_vpl VALUES ("AC28_21","074_28_21","ACT","28","21","21","ચ્યાહાય ચ્યાલ આખ્યાં, “નાંય આમહાય તો બારામાય યહૂદીયા વિસ્તારામાઅને ચિઠ્ઠયો મિળવ્યો, એને નાંય બાહાહા માઅને યોકતાંય યેયન તો બારામાય કાય આખ્યાં, એને નાંય ખારાબ આખ્યાં. ");
INSERT INTO gbl_vpl VALUES ("AC28_22","074_28_22","ACT","28","22","22","બાકી તો વિચાર કાય હેય? તી આમા તોથી વોનાયા માગતાહા, કાહાકા આમા જાંઅતાહા કા બોદા જાગામાય યા બારામાય વિરુદમાય વાતો કોઅતેહે.” ");
INSERT INTO gbl_vpl VALUES ("AC28_23","074_28_23","ACT","28","23","23","તોવે પાઉલાહાટી ચ્યાહાય યોક દિહી ઠોરવ્યો, એને બોજ બોદા લોક ચ્યા તાં યોકઠા ઓઅયા, એને તો પોરમેહેરા રાજ્યા સાક્ષી દેતા, એને મૂસા નિયમશાસ્ત્ર એને ભવિષ્યવક્તાહા ચોપડયેહે માઅને ઈસુ બારામાય હોમજાડી-હોમજાડીન હાકાળેહેથી વોખાતાહાલોગુ વર્ણન કોઅતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("AC28_24","074_28_24","ACT","28","24","24","તોવે કોલહાક લોકહાય પાઉલા વાતેહેવોય બોરહો કોઅયો, બાકી કોલહાક લોકહાય બોરહો નાંય કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("AC28_25","074_28_25","ACT","28","25","25","પાછી આપસમાય યોક બિજા આરે સહમત નાંય ઓઅય હોક્યે, ચ્યે તાંઅરે જાં લાગ્યેં, તે પાઉલા યે યોક્યે વાતે આખનાથી જાતા રિયા : “પવિત્ર આત્માય યશાયા ભવિષ્યવક્તા દ્વારા તુમહે ડાઅયાહાન ઠીક આખ્યાં, ");
INSERT INTO gbl_vpl VALUES ("AC28_26","074_28_26","ACT","28","26","26","જાયને ચ્યા લોકહાન આખ, કા વોનાયા કોઅતાહા બાકી હોમજે નાંય, એને એએયા કોઅતાહા બાકી ચ્યાહાન દેખાય નાંય. ");
INSERT INTO gbl_vpl VALUES ("AC28_27","074_28_27","ACT","28","27","27","કાહાકા યા લોકહા મન જડ, એને ચ્યાહા કાન બોઅર્યા ઓઅઇ ગીયહા, એને ચ્યાહાય પોતાના ડોળા બોંદ કોઅયાહાં, ઓહડા નાંય ઓએ કા ચ્યે કોદહી ડોળાહાકોય એએ, એને કાનાહાકોય વોનાય, એને મન કોય હોમજે એને જીવના ખારાબ તરીકાહા થી મા એછે ફિરે, એને આંય ચ્યાહાન હારો કોઉ.” ");
INSERT INTO gbl_vpl VALUES ("AC28_28","074_28_28","ACT","28","28","28","યાહાટી તુમા જાંઆ, કા પોરમેહેરા ઈ તારણા કાહાની ગેર યહૂદીયાહા પાય દોવાડલી ગીયહી, એને ચ્યે માની લી. ");
INSERT INTO gbl_vpl VALUES ("AC28_29","074_28_29","ACT","28","29","29","જોવે ચ્યાય ઈ આખ્યાં તે યહૂદી યોક બિજા આરે બોજ બોલાબોલી કોઅરા લાગ્યા એને તાઅને જાતા રિયા. ");
INSERT INTO gbl_vpl VALUES ("AC28_30","074_28_30","ACT","28","30","30","પાઉલ પુરેં બેન વોરહે પોતાના ભાડાથી લેદલા ગોઆમાય રિયો, ");
INSERT INTO gbl_vpl VALUES ("AC28_31","074_28_31","ACT","28","31","31","એને જ્યા ચ્યાપાય યેતા આતા, ચ્યા બોદહાન મિળતો રિયો એને બિક વોગાર એને રુકાવાટ વોગર પોરમેહેરા રાજ્યા પ્રચાર કોઅતો એને પ્રભુ ઈસુ ખ્રિસ્તા વાતો હિકાડતો રિયો.");
INSERT INTO gbl_vpl VALUES ("RM1_1","075_1_1","ROM","1","1","1","આંય પાઉલ ઈસુ ખ્રિસ્તા સેવક હેતાંવ, એને માન પ્રેષિત ઓરાહાટી પોરમેહેરાય પોસંદ કોઅલો હેય, એને પોરમેહેરાય ચ્યા હારી ખોબાર આખાહાટી માન નિવાડલો હેય. ");
INSERT INTO gbl_vpl VALUES ("RM1_2","075_1_2","ROM","1","2","2","પોરમેહેરાય ચ્યા હારી ખોબારે વાયદો બોજ સમયા પેલ્લા ભવિષ્યવક્તાહાકોય પવિત્રશાસ્ત્રમાય કોઅલો આતો. ");
INSERT INTO gbl_vpl VALUES ("RM1_3","075_1_3","ROM","1","3","3","ઈ હારી ખોબાર પોરમેહેરા પોહો ઈસુ ખ્રિસ્તા બારામાય હેય, ઓ ઈસુ ખ્રિસ્ત શારીરિકરીતે થી દાઉદ રાજા કુળામાંય જોન્માલ યેનો. ");
INSERT INTO gbl_vpl VALUES ("RM1_4","075_1_4","ROM","1","4","4","બાકી પવિત્ર આત્મા સામર્થ્યાકોય તો મોઅલા માઅને પાછા જીવી ઉઠવાને લીદે પોરમેહેરા પોહો સાબિત જાયો. ");
INSERT INTO gbl_vpl VALUES ("RM1_5","075_1_5","ROM","1","5","5","ચ્યા ઈસુ ખ્રિસ્તાય માન પોરમેહેરા પ્રેષિત ઓઅના ઓદિકાર દેનો, જેથી બોદી જાતી લોક ચ્યાવોય બોરહો કોઅય એને ચ્યા આગના માને. ");
INSERT INTO gbl_vpl VALUES ("RM1_6","075_1_6","ROM","1","6","6","તુમા, જ્યા રોમ શેહેરામાય રોતહા, ઈસુ ખ્રિસ્તા લોક ઓઅરાહાટી હાદલા ગીયહા. ");
INSERT INTO gbl_vpl VALUES ("RM1_7","075_1_7","ROM","1","7","7","ઈ પત્ર રોમ શેહેરામાય રોનારા બોદા વિસ્વાસી લોકહાહાટી લોખતાહાવ, જ્યાહાવોય પોરમેહેર પ્રેમ કોઅહે, એને પોરમેહેરા પવિત્ર લોક બોનાહાટી પોસંદ કોઅલા હેય, આમહે પોરમેહેર આબહો એને પ્રભુ ઈસુ ખ્રિસ્તાપાઅને તુમહાન સદા મોયા એને શાંતી મિળતી રોય. ");
INSERT INTO gbl_vpl VALUES ("RM1_8","075_1_8","ROM","1","8","8","પેલ્લા આંય તુમા બોદહાહાટી ઈસુ ખ્રિસ્તાકોય આપહે પોરમેહેરા ધન્યવાદ કોઅતાહાંવ, કાહાકા ઈસુ ખ્રિસ્તાવોય તુમહે બોરહો કોઅના બારામાય બોજ લોક વાત કોઅય રીઅલા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM1_9","075_1_9","ROM","1","9","9","પોરમેહેર જ્યા સેવા આંય પુરાં મોનાકોય ચ્યા પોહો ઈસુ ખ્રિસ્તા બારામાય હારી ખોબારે પ્રચાર કોઅતાહાંવ, તોજ મા સાક્ષી હેય કા આંય જોવે પ્રાર્થના કોઅતાહાંવ તોવે સાદા તુમહાન યાદ કોઅતાહાંવ. ");
INSERT INTO gbl_vpl VALUES ("RM1_10","075_1_10","ROM","1","10","10","એને આંય સાદા ઈ વિનાંતી કોઅહુ, કા પોરમેહેરા ઇચ્છાકોય છેલ્લે કોઅહિબી રીતીકોય તુમહેપાય યેયન તુમહાન મિળાં હારો મોકો મીળે. ");
INSERT INTO gbl_vpl VALUES ("RM1_11","075_1_11","ROM","1","11","11","કાહાકા માન તુમહાન મિળાહાટી બોજ ઇચ્છા ઓઅય રીયહી, જેથી આંય તુમહાન બોરહામાય મજબુત કોઅરાહાટી તુમહાન આત્મિક વરદાન દાવ. ");
INSERT INTO gbl_vpl VALUES ("RM1_12","075_1_12","ROM","1","12","12","મા આખના મતલબ ઓ હેય કા જોવે આંય તુમહેપાય યાંવ, તોવે તુમહાન બોરહામાય મજબુત કોઅરાહાટી મોદાત કોઅહી, એને તુમા માન મોદાત કોઅહા. ");
INSERT INTO gbl_vpl VALUES ("RM1_13","075_1_13","ROM","1","13","13","ઓ વિસ્વાસી બાહાહાય, મા ઇચ્છા હેય કા તુમા ઈ જાંઆય લા કા માયે ગેડી-ગેડી તુમહેપાય યાંહાટી કોશિશ કોઅયી, કા જેહેકેન માયે ગેર યહૂદી લોકહામાય ઈસુવોય બોરહો કોઅનારા લોક બોનાડ્યા તેહેકેન તુમહામાયબી બોનાડુ, બાકી આમી લોગુ કાયન-કાય રુકાવાટ ઓઅતી રોયી. ");
INSERT INTO gbl_vpl VALUES ("RM1_14","075_1_14","ROM","1","14","14","આંય બોદા ગાવહાં એને શેહેરામાઅને બોદી જાતી અભણ અથવા બણલા લોકહાન હારી ખોબાર આખાહાટી કર્જદાર હેતાંવ. ");
INSERT INTO gbl_vpl VALUES ("RM1_15","075_1_15","ROM","1","15","15","યાહાટી આંય તુમહાનબી જ્યા રોમ શેહેરામાય રોતહા, હારી ખોબાર આખાહાટી તિયાર હેતાંવ. ");
INSERT INTO gbl_vpl VALUES ("RM1_16","075_1_16","ROM","1","16","16","કાહાકા આંય ઈસુ ખ્રિસ્તા હારી ખોબાર આખાહાટી નાંય શરમાયુ, કાહાકા પોરમેહેર ચ્યા સામર્થ્યકોય ચ્યા બોદહા તારણ કોઅહે જ્યા હારી ખોબારેવોય બોરહો કોઅતેહે, શુરવાતમાય હારી ખોબારેવોય બોરહો કોઅનારા યહૂદી લોકહા પોરમેહેરે તારણ કોઅયા, એને આમી બોદી જાતી લોકહા તારણ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("RM1_17","075_1_17","ROM","1","17","17","કાહાકા જ્યેં પેલ્લેથી છેલ્લે લોગુ હારી ખોબારેવોય બોરહો કોઅતેહે, ચ્યાહાન પોરમેહેર ચ્યાઆરે ન્યાયી ઠોરવેહે, જેહેકોય પવિત્રશાસ્ત્રમાય લોખલાં હેય, “જીં માઅહું બોરહાકોય પોરમેહેરાઆરે ન્યાયી ઠોરલાં હેય તી જીવતા રોય.” ");
INSERT INTO gbl_vpl VALUES ("RM1_18","075_1_18","ROM","1","18","18","હોરગામાઅને પોરમેહેરા ગુસ્સો તે ચ્યા લોકહાવોય પ્રગટ ઓઅહે, જ્યા બોદા ભક્તિવોગાર એને અન્યાયાકોય બોઆલા હેય, જ્યા ખારાબ કામ કોઅતાહા એને હાચ્ચાં જાઅનાપાઅને લોકહાન રોકતાહા. ");
INSERT INTO gbl_vpl VALUES ("RM1_19","075_1_19","ROM","1","19","19","કાહાકા ઈ બોદા લોકહાન ખોબાર હેય કા પોરમેહેર કોહડો હેય, કાહાકા પોરમેહેરાય પોતે ચ્યાહાન પ્રગટ કોઅલા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM1_20","075_1_20","ROM","1","20","20","પોરમેહેરા નાંય દેખાનારા ગુણ, એટલે ચ્યા સનાતન સામર્થ એને પોરમેહેરા સ્વભાવ, ઈ દુનિયા બોનાવ્યાં ચ્યા સમયાથી ચ્યા કામહામાય દેખાયેહે, યાહાટી લોક કાયજ બહાનો નાંય કાડી હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM1_21","075_1_21","ROM","1","21","21","યાહાટી કા પોરમેહેરાલ જાંઇનબી ચ્યાહાય ચ્યાલ પોરમેહેરા હારકા સન્માન નાંય દેનો, એને ધન્યવાદ નાંય કોઅયા, બાકી નોકામ્યા વિચાર કોઅરા લાગ્યેં, ઓલે લોગુ કા ચ્યાહા નોકામ્યા વિચાર બોદા જુઠા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM1_22","075_1_22","ROM","1","22","22","ચ્યા પોતાનાલ બુદ્ધિમાન હોમજેત બાકી મૂર્ખ બોની ગીયા. ");
INSERT INTO gbl_vpl VALUES ("RM1_23","075_1_23","ROM","1","23","23","એને કોદહીબી નાંય મોઅનારા પોરમેહેરા મહિમાલ મોઅઇ જાનારા માઅહા, એને ચિડહા, એને જોનાવરહા એને હોઅપલીન ચાલનારા જીવહા મુર્તિ બોનાવીન ચ્યાહા ભક્તિ કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("RM1_24","075_1_24","ROM","1","24","24","યા લીદે પોરમેહેરે ચ્યાહા મોના ઇચ્છા નુસાર ખારાબ વાસનાહાહાટી છોડી દેના, કા ચ્યા આપસમાય ખારાબ કામહામાય પોતાના શરીરા અનાદર કોએ. ");
INSERT INTO gbl_vpl VALUES ("RM1_25","075_1_25","ROM","1","25","25","કાહાકા ચ્યાહાય પોરમેહેરાબારામાય હાચ્ચાયેવોય બોરહો કોઅરા મોનાઈ કોઅયી, એને જુઠાવોય બોરહો કોઅયો, એને દુનિયા ભક્તિ એને સેવા કોઅયી, નાંય કા પોરમેહેરા જો ઈ દુનિયા બોનાવનારો હેય, ચ્યા મહિમા સાદા ઓઅતી રોય. આમેન. ");
INSERT INTO gbl_vpl VALUES ("RM1_26","075_1_26","ROM","1","26","26","યાહાટી પોરમેહેરે ચ્યાહાન ખારાબ વાસનાહામાય છોડી દેના, યા લીદે ચ્યાહા થેઅયેહેય માટડાઆરે શારીરિક સબંધ બોનાવના છોડીન થેઅયેહેઆરે શારીરિક સબંધ રાખત્યો લાગ્યો. ");
INSERT INTO gbl_vpl VALUES ("RM1_27","075_1_27","ROM","1","27","27","તેહેકોયજ માટડાહાયબી થેઅયેહેઆરે સ્વાભાવિક શારીરિક સબંધ કોઅના છોડીન માટડા માટડાહા આરેબી શારીરિક સબંધ કોઅરા લાગ્યા, ચ્યા લીદે ચ્યા પોતાના ભુલને લીદે ચ્યાહા શરીરામાય ડૉડ બોગવી રીયહા. ");
INSERT INTO gbl_vpl VALUES ("RM1_28","075_1_28","ROM","1","28","28","કાહાકા ચ્યાહાય પોરમેહેરા બોદા જ્ઞાનાલ નોકામ્યા હોમજ્યા, તે પોરમેહેરાયબી ચ્યાહાન ખારાબ કામે કોઅરાહાટી ચ્યાહાન ચ્યાહા નોકામ્યા મોના ઇચ્છા પરમાણે છોડી દેના, કા ચ્યા ખારાબ કામે કોએ. ");
INSERT INTO gbl_vpl VALUES ("RM1_29","075_1_29","ROM","1","29","29","યાહાટી ચ્ચા બોદા પ્રકારા અધર્મ ખારાબ કામે, એને લોબ, એને દુશ્માની વિચારાહાકોય બોરાય ગીયા, એને ડાહ, એને ખૂન, એને જગડા, એને છલ, એને ઓદરાયેથી ભરપુર ઓઈ ગીયા, એને ચુગલ્યો કોઅનારે, ");
INSERT INTO gbl_vpl VALUES ("RM1_30","075_1_30","ROM","1","30","30","યોક બીજહા વાતો કોઅનારે, નિંદા કોઅનારે, પોરમેહેરાલ નાકાર કોઅનારે, યોક-બિજા બુલ કાડનારે, અભિમાન્યા હસી-મશ્કરી, ખારાબ-ખારાબ વાતો બોલનારા, આયહે આબહા આગના નાંય માનનારે, ");
INSERT INTO gbl_vpl VALUES ("RM1_31","075_1_31","ROM","1","31","31","બુદયે વોગાર્યા બેયમાની કોઅનારે, પ્રેમ એને દયા વોગાર્યા ઓઈ ગીયા. ");
INSERT INTO gbl_vpl VALUES ("RM1_32","075_1_32","ROM","1","32","32","ચ્યે તે પોરમેહેરા ઈ વિદી જાંઅતેહે કા ઓહડે-ઓહડે કામે કોઅનારે મોરણ ડૉડાહાટી યોગ્ય હેય, તેરુંબી નાંય કેવળ ચ્યા ઓહડે કામે કોઅતેહે, બાકી કોઅનારહાથી પ્રસન્નબી ઓઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("RM2_1","075_2_1","ROM","2","1","1","યાહાટી, ઓ દોષ દેનારા, તું બીજહાવોય દોષ દેતહો, તું કાયજ બાહાનો નાંય કાડી હોકે, કાહાકા જ્યેં વાતમાય તું બીજહાવોય દોષ લાવતોહો, ચ્યેજ વાતમાય પોતાલબી દોષી ઠોરાવતોહો, કાહાકા કા તું દોષ લાવતોહો, તે પોતે તીંજ કામ કોઅતોહો. ");
INSERT INTO gbl_vpl VALUES ("RM2_2","075_2_2","ROM","2","2","2","એને આમા જાંઅજેહે કા પોરમેહેર ચ્યા ન્યાયામાય, ઓહડા બોદા માઅહાન ડૉડ દેઅરી જ્યેં ઓહડે કામે કોઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("RM2_3","075_2_3","ROM","2","3","3","એને તું જો ઓહડે-ઓહડે કામે કોઅનારાવોય દોષ લાવતોહો, એને પોતે ચ્યેજ કામે કોઅતોહો, કાય હુમાજતહો કા તું પોરમેહેરા ડૉડથી બોચી જાહે? ");
INSERT INTO gbl_vpl VALUES ("RM2_4","075_2_4","ROM","2","4","4","કાય તું પોરમેહેરા સદા મોયા, એને ચ્યા સહનશીલતા, એને ધીરજેલ નોકામ્યા જાંઅતોહો? કાય તું નાંય હોમજે કા પોરમેહેરા ભલાઈ તુલ પાપ કોઅના બંદ કોઅના હિકાડેહે? ");
INSERT INTO gbl_vpl VALUES ("RM2_5","075_2_5","ROM","2","5","5","બાકી તો પોતા કોઠાણ મોના એને પાપ કોઅના બંદ નાંય કોઅના લેદે, ચ્યે દિહી પોરમેહેર ચ્યા ગુસ્સો દેખાડી, ચ્યામાય પોરમેહેરા ન્યાયામાય આજુ વોદારી ડૉડ દેઅરી. ");
INSERT INTO gbl_vpl VALUES ("RM2_6","075_2_6","ROM","2","6","6","પોરમેહેર બોદહાન ચ્યાહા કામહા ઇસાબે પ્રતિફળ દેઅરી. ");
INSERT INTO gbl_vpl VALUES ("RM2_7","075_2_7","ROM","2","7","7","એને જ્યેં હારાં કામહામાય મજબુત બોની રોય એને મહિમા, એને આદર એને અમરતા હોદતેહેં, ચ્યાહાન પોરમેહેર અનંતજીવન દી. ");
INSERT INTO gbl_vpl VALUES ("RM2_8","075_2_8","ROM","2","8","8","બાકી જ્યેં સ્વાર્થી હેય એને હાચ્ચાયેલ નાંય માને, બાકી ખારાબ કામ કોઅતેહે, ચ્યાહાવોય પોરમેહેરા ગુસ્સો એને કોપ પોડી. ");
INSERT INTO gbl_vpl VALUES ("RM2_9","075_2_9","ROM","2","9","9","એને જ્યેં ખારાબ કામ કોઅતેહે ચ્યા બોદા લોકહાવોય આબદા એને સંકટ યેઅરી. પોરમેહેર પેલ્લા યહૂદી લોકહા ન્યાય કોઅરી પાછે ગેર યહૂદી લોકહા ન્યાય કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("RM2_10","075_2_10","ROM","2","10","10","બાકી જીં હારાં કામ કોઅહે, ચ્યા બોદહાલ મહિમા એને આદર એને શાંતી મિળી, પેલ્લા યહૂદી લોકહાન પાછે ગેર યહૂદી લોકહાન. ");
INSERT INTO gbl_vpl VALUES ("RM2_11","075_2_11","ROM","2","11","11","કાહાકા પોરમેહેર બોદહા હારકો ન્યાય કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("RM2_12","075_2_12","ROM","2","12","12","જ્યા ગેર યહૂદ્યાહાય મૂસા નિયમ મેળવ્યા વોગર પાપ કોઅયાહાં, તે ચ્યા મૂસા નિયમા વોગર પોરમેહેરાપાઅને ડૉડ પામી, એને જ્યા યહૂદ્યાહાય મૂસા નિયમ મીળવીન પાપ કોઅયાહાં, ચ્યાલ મૂસા નિયમાનુસાર પોરમેહેરાપાઅને ડૉડ મિળી. ");
INSERT INTO gbl_vpl VALUES ("RM2_13","075_2_13","ROM","2","13","13","કાહાકા પોરમેહેરા નોજરેમાય મૂસા નિયમ વોનાનારા ન્યાયી નાંય, બાકી મૂસા નિયમ પાળનારે ન્યાયી ઠોરી. ");
INSERT INTO gbl_vpl VALUES ("RM2_14","075_2_14","ROM","2","14","14","પાછે જ્યેં ગેર યહૂદી, જ્યાહાન મૂસા નિયમ નાંય દેના, તેરુંબી ચ્યે સ્વભાવિક રીતેથી મૂસા નિયમાહા માઅને કોલહાક નિયમ પાળતેહે, યાહાટી ચ્યાહાપાય નિયમ નાંય ઓઅલા લીદે બી ચ્યે પોતે પોતાહાટી નિયમ હેય. ");
INSERT INTO gbl_vpl VALUES ("RM2_15","075_2_15","ROM","2","15","15","કાહાકા ચ્યે ચ્યાહા વ્યવહારાકોય સાબિત કોઅતેહે કા મૂસા નિયમ ચ્યાહા મોનામાય બોઆલા હેય, એને ચ્યાહા હૃદયબી ચ્યાહા બારામાય સાક્ષી દેહે, ચ્યાહા વિચાર કોયદિહી ચ્યાહાન દોષી ઠોરવેહે, તે કોયદિહી ચ્યાહાન નિર્દોષ ઠોરવેહે. ");
INSERT INTO gbl_vpl VALUES ("RM2_16","075_2_16","ROM","2","16","16","જ્યેં દિહી પોરમેહેર ન્યાય કોઅરી તો દિહી આંય જીં હારી ખોબારે પ્રચાર કોઅહુ ચ્યાનુસાર ઈસુ ખ્રિસ્તાકોય માઅહા ગુપ્ત વિચારાહા ન્યાય કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("RM2_17","075_2_17","ROM","2","17","17","જો તું પોતાલ યહૂદી આખાડતોહો, એને મૂસા નિયમ વોય બોરહો કોઅતોહો, એને અભિમાન કોઅતોહો કા તું પોરમેહેરા ખાસ માઅહું હેય. ");
INSERT INTO gbl_vpl VALUES ("RM2_18","075_2_18","ROM","2","18","18","એને તું પોરમેહેરા ઇચ્છા જાંઅતોહો એને તું હારાં કામ કોઅના જાંઅતોહો, કાહાકા તુમહાન મૂસા નિયમમાય ઈ હિકાડયાહા. ");
INSERT INTO gbl_vpl VALUES ("RM2_19","075_2_19","ROM","2","19","19","એને તુલ ખાત્રી હેય, કા તું આંદળાહાન પોરમેહેરા વાટ દેખાડનારો, એને જ્યા લોક આંદારામાય હેય ચ્યા લોકહાહાટી તું ઉજવાડા હારકો હેય. ");
INSERT INTO gbl_vpl VALUES ("RM2_20","075_2_20","ROM","2","20","20","એને અજ્ઞાની લોકહાન હિકાડનારો, એને બોળા-બોક્ષા લોકહા ગુરુ આખાડતોહો, કાહાકા તુલ પુરી ખાત્રી હેય કા પોરમેહેરા નિયમ તુમહાન પુરાં જ્ઞાન એને હાચ્ચાં હોમજાડેહે. ");
INSERT INTO gbl_vpl VALUES ("RM2_21","075_2_21","ROM","2","21","21","બાકી કાય તું બીજહાન હિકાડતોહો, પોતાલ નાંય હિકાડે કા? તું બીજહાન ચોરી નાંય કોઅના હિકાડતોહો, એને તું પોતેજ ચોરી કોઅતોહો. ");
INSERT INTO gbl_vpl VALUES ("RM2_22","075_2_22","ROM","2","22","22","“તું વ્યબિચાર નાંય કોઅના હિકાડતોહો” તે તું પોતેજ કાહા વ્યબિચાર કોઅતોહો? તું મુર્તિહી નાકાર કોઅતોહો, તે પોતેજ કાહા દેવાળાહાલ લુટતોહો? ");
INSERT INTO gbl_vpl VALUES ("RM2_23","075_2_23","ROM","2","23","23","તું મૂસા નિયમ જાઅના લીદે ઘમંડ તે કોઅતોહો, બાકી ચ્યા નિયમાલ, નાંય પાળના લીદે કાય તું પોરમેહેરા અપમાન નાંય કોએ? ");
INSERT INTO gbl_vpl VALUES ("RM2_24","075_2_24","ROM","2","24","24","“કાહાકા તુમા યહૂદી લોકહા લીદે ગેર યહૂદી લોક પોરમેહેરા નાંવા નિંદા કોઅતાહા,” જેહેકેન પવિત્રશાસ્ત્રમાય લોખલાં બી હેય. ");
INSERT INTO gbl_vpl VALUES ("RM2_25","075_2_25","ROM","2","25","25","આંય તુમહાન આખા માગહુ કા સુન્નત કોઅના ફાયદો હેય, બાકી જોવે તું મૂસા નિયમાહા પાલન કોએ તોવે, બાકી જોવે તું મૂસા નિયમાહા પાલન નાંય કોએ તે તો સુન્નત કોઅલા કાયજ ફાયદો નાંય. ");
INSERT INTO gbl_vpl VALUES ("RM2_26","075_2_26","ROM","2","26","26","યેજપરમાણે, જો કાદો માટડો સુન્નત કોઅયા વોગર મૂસા નિયમાહા પાલન કોએ તે તો નોકીજ પોરમેહેરા માઅહું આખાયી. ");
INSERT INTO gbl_vpl VALUES ("RM2_27","075_2_27","ROM","2","27","27","એને જીં માઅહું શારીરિક રુપ થી વોગાર સુન્નત રિયા, જોવે તો મૂસા નિયમ પાલન કોએ, તોવે તી સુન્નત કોઅલા હેય, એને તોવોય મૂસા નિયમ હેય, તેરુંબી તું મૂસા નિયમ નાંય પાળે તે કાય તી માઅહું તુલ દોષી નાંય ઠોરવી? ");
INSERT INTO gbl_vpl VALUES ("RM2_28","075_2_28","ROM","2","28","28","કાહાકા તો સુન્નત ઓઅના લીદે તું હાચ્ચો યહૂદી નાંય બોને, એને સુન્નત આસલીમાય તી નાંય જીં બાઆન્યા રુપામાય એને શરીરામાય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM2_29","075_2_29","ROM","2","29","29","બાકી યહૂદી તોજ હેય, જો ચ્યા મોનામાય યહૂદી હેય, એને સુન્નત તી હેય, જીં પવિત્ર આત્માકોય એને હૃદયાકોય કોઅલા જાહે, બાકી તી નાંય હેય, જીં મૂસા નિયમાહા નુસાર કોઅલા જાહે, ઓહડા લોકહા વાહવા લોકહાકોય નાંય ઓએ, બાકી પોરમેહેર ચ્યાહા વાહવા કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("RM3_1","075_3_1","ROM","3","1","1","તે પાછે યહૂદી ઓઅનાકોય આપહાન બીજહા કોઅતા કાય લાભ મિળ્યો, કા સુન્નત કોઅલા કાય ફાયદો? ");
INSERT INTO gbl_vpl VALUES ("RM3_2","075_3_2","ROM","3","2","2","યોક યહૂદી ઓઅના બોજ ફાયદો હેય, બોદહાથી મહત્વા ઈ હેય કા પોરમેહેરા વચન બોદહા પેલ્લા યહૂદી લોકહાન દેના. ");
INSERT INTO gbl_vpl VALUES ("RM3_3","075_3_3","ROM","3","3","3","એને કોલહાક યહૂદી લોક પોરમેહેરા પ્રતિ બોરહો કોઅનારા નાંય આતા, તે કાય ઓઅયા, તે કાય ચ્યા મતલબ ઈ હેય કા પોરમેહેર ચ્ચાઆરે કોઅલા ગીઅલા પોતાના વાયદા પુરાં કોઅનામાય અવિસ્વાસીયોગ્ય ઓઅરી? ");
INSERT INTO gbl_vpl VALUES ("RM3_4","075_3_4","ROM","3","4","4","નાંય, કોવેજ નાંય, ભલે બોદા લોક જુઠા નિંગ્યા, બાકી પોરમેહેર સાદા હાચ્ચો બોલહે, જેહેકેન પવિત્રશાસ્ત્રમાય પોરમેહેરા બારામાય લોખલાં હેય, તી વચન તુલ ન્યાયી ઠોરવેહે, એને જોવે તો ન્યાય ઓઅહે તોવે તું વિજય ઓઅતોહો. ");
INSERT INTO gbl_vpl VALUES ("RM3_5","075_3_5","ROM","3","5","5","બાકી આપહે ખારાબ કામ પોરમેહેરા ન્યાયીપણ પ્રગટ કોઅહે તે આપા કાય આખજે? કાય એહેકેન આખજે કા પોરમેહેર ગુસ્સો ઓઇન આપહાન ડૉડ દેહે, એને આપહે અન્યાય કોઅહે? ઈ આંય માઅહા વિચારાકોય આખતાહાવ. ");
INSERT INTO gbl_vpl VALUES ("RM3_6","075_3_6","ROM","3","6","6","નાંય કોવેજ નાંય, જો પોરમેહેર યહૂદી લોકહા ન્યાય કોઅરાહાટી હાચ્ચો નાંય હેય તો દુનિયા લોકહા ન્યાય નાંય કોઅય હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM3_7","075_3_7","ROM","3","7","7","એને જો મા જુઠા બોલના લીદે પોરમેહેરા હાચ્ચાં ચ્યા મહિમાહાટી વોદારે કોયન ઓઅહે, તે પાછે કાહા આંય પાપ્યા હારકો આંય સજાહાટી ઠોરહું? ");
INSERT INTO gbl_vpl VALUES ("RM3_8","075_3_8","ROM","3","8","8","ખારાબ કામ કોઅનાથી જો યોકદા હારાં ઓઅતા ઓઅરી તે એહેકેન કોઅરા જોજે એહેકેન શિક્ષણ આમા દેજહે, એહેકેન આખીન કોલહાક લોક આમહે નિંદા કોઅતાહા, ઓહડા લોક ડૉડ બોગાવના લાયકે હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_9","075_3_9","ROM","3","9","9","તે, કાય આપા યહૂદી, ગેર યહૂદી લોકહા કોઅતા હારાં હેજે? નાંય કોવેજ નાંય, કાહાકા આમા યહૂદી એને ગેર યહૂદી બેન્યાહાવોય ઓ દોષ લાવી ચુક્યાહા કા ચ્યા બોદાન બોદા પાપા શક્તિ તાબામાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_10","075_3_10","ROM","3","10","10","જેહેકેન પવિત્રશાસ્ત્રમાય લોખલાં હેય: “પોરમેહેરા નોજારેમાય કાદોજ ન્યાયી નાંય હેય, યોકબી નાંય. ");
INSERT INTO gbl_vpl VALUES ("RM3_11","075_3_11","ROM","3","11","11","ઓહડા યોકબી માઅહું નાંય હેય જીં આસલીમાય હોમજેહે કા કાય હાચ્ચાં હેય, કાદોજ પોરમેહેરાલ જાંઅરા નાંય માગે. ");
INSERT INTO gbl_vpl VALUES ("RM3_12","075_3_12","ROM","3","12","12","બોદે પોરમેહેરા પાઅને દુઉ ઓઅય ગીયહેં, પોરમેહેરાહાટી ચ્યે નોકામ્યે બોની ગીયહેં, કાદા હારેં કામે કોઅનારા નાંય હેય, યોકબી નાંય. ");
INSERT INTO gbl_vpl VALUES ("RM3_13","075_3_13","ROM","3","13","13","ચ્યાહા મું ખારાબ વાસ યેનારી ઉગાડી કોબાર હારકા હેય, કાહાકા જ્યો વાતો ચ્યે બોલતેહેં ચ્યો ગન્દ્યો હેય, ચ્યે ચ્યાહા વાતહેકોય લોકહાન દોગો દેતહેં, એને ચ્યે સદા જુઠે બોલતેહેં. ");
INSERT INTO gbl_vpl VALUES ("RM3_14","075_3_14","ROM","3","14","14","ચ્યાહા બોલના ખારાબ હારાપાથી એને કડવાશથી બોઆલા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_15","075_3_15","ROM","3","15","15","ચ્યે નુકસાન કોઅરા એને માઆઇ ટાકાંહાટી ઉતવાળ્યે હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_16","075_3_16","ROM","3","16","16","ચ્યે જાં જાતહેં તાં નુકસાન કોઅતેહે એને પીડા લેય યેતહે. ");
INSERT INTO gbl_vpl VALUES ("RM3_17","075_3_17","ROM","3","17","17","ચ્યે શાંતીકોય રોઅના નાંય જાંએત. ");
INSERT INTO gbl_vpl VALUES ("RM3_18","075_3_18","ROM","3","18","18","ચ્યાહામાય પોરમેહેરા બિક હેયેજ નાંય.” ");
INSERT INTO gbl_vpl VALUES ("RM3_19","075_3_19","ROM","3","19","19","આમા જાંઅતાહા, કા મૂસા નિયમ જીં કાય આખહે તી ચ્યાહાનુજ આખહે જ્યેં મૂસા નિયમા આધીનમાય હેય, જેથી કાદાજ માઅહું બાહાનો નાંય કોઅય હોકે, એને દુનિયા બોદા લોક પોરમેહેરા હામ્મે દોષી ઠોરે. ");
INSERT INTO gbl_vpl VALUES ("RM3_20","075_3_20","ROM","3","20","20","કાહાકા મૂસા નિયમ પાલન કોઅવાથી કાદાબી માઅહું ન્યાયી નાંય બોને, મૂસા નિયમાહાકોય આપા જાંઅજેહે કા આપા પાપી હેજે. ");
INSERT INTO gbl_vpl VALUES ("RM3_21","075_3_21","ROM","3","21","21","બાકી આમી મૂસા નિયમા બોદા નિયમ પાળ્યા વોગાર પોરમેહેર આપહાન ન્યાયી બોનાડેહે, બોજ પેલ્લાથી મૂસા નિયમશાસ્ત્ર માય એને ભવિષ્યવક્તાહા ચોપડયેમાય ઈ લોખલાં હેય, પોરમેહેરાય આપહાન કેહેકેન ન્યાયી બોનાડલે હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_22","075_3_22","ROM","3","22","22","એટલે, આપા પોરમેહેરાકોય ન્યાયી બોનજેહે જોવે આપા ઈસુ ખ્રિસ્તાવોય બોરહો કોઅજેહે, કાહાકા બોદે માઅહે યોક હારકે હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_23","075_3_23","ROM","3","23","23","યાહાટી કા બોદહાય પાપ કોઅયાહાં એને પોરમેહેરા મહિમા પાઅને દુઉ હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_24","075_3_24","ROM","3","24","24","બાકી પોરમેહેરે ચ્યા સદા મોયાથી આપહાન ઈસુ ખ્રિસ્તાકોય આપહે પાપહા ડૉડથી છુટકા કોઅયા, આપહાય કાયજ નાંય કોઅયા વોગાર પોરમેહેર આપહાન ન્યાયી બોનાડેહે. ");
INSERT INTO gbl_vpl VALUES ("RM3_25","075_3_25","ROM","3","25","25","પોરમેહેરા ઇચ્છા આતી કા ઈસુ ખ્રિસ્ત ચ્યા લોય વોવાડીન પાપહા પ્રાયચીત કોએ, જ્યા ફળ બોરહાકોય મિળહે, પોરમેહેરાય એહેકેન ચ્યા ન્યાયપણા સાબુત દેના, કાહાકા પોરમેહેરાય ચ્યા સહનશીલતા નુસાર પાછલા કાળામાય કોઅલા પાપહાન માફ કોઅય દેના, ચ્યાહા બારામાય પોરમેહેર ચ્યા ન્યાયપણા પ્રગટ કોઅય હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM3_26","075_3_26","ROM","3","26","26","બાકી પોરમેહેરાય ચ્ચેજ સમયે ચ્યા ન્યાયપણા પ્રગટ કોઅરા માગી, જેથી ઈ સાબિત ઓઅય જાય કા પોરમેહેર પોતે ન્યાયી હેય એને ચ્યા બોદહાન ન્યાયી ઠોરવેહે, જ્યેં ઈસુ ખ્રિસ્તાવોય બોરહો કોઅતેહે. ");
INSERT INTO gbl_vpl VALUES ("RM3_27","075_3_27","ROM","3","27","27","તે, ઓહડા કાય હેય કા ચ્યા બારામાય આપા અભિમાન કોઅય હોકજે? અભિમાન કોઅના તે બહાનોજ નાંય હેય, કોઅહા નિયમા લીદે? કાય કામહા નિયમથી? નાંય, બાકી ઈ ઈસુ ખ્રિસ્તામાય બોરહો કોઅના આધારાવોય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_28","075_3_28","ROM","3","28","28","યાહાટી આમા જાંઅજેહે કા આપા ઈસુ ખ્રિસ્તાવોય બોરહો કોઅલા લીદે પોરમેહેર આપહાન ન્યાયી બોનાડેહે, મૂસા નિયમ પાળલાકોય ન્યાયી નાંય બોનાડે. ");
INSERT INTO gbl_vpl VALUES ("RM3_29","075_3_29","ROM","3","29","29","પોરમેહેર કેવળ યહૂદી લોકહાજ પોરમેહેર નાંય હેય, બાકી ગેર યહૂદી લોકહા બી પોરમેહેર હેય. ");
INSERT INTO gbl_vpl VALUES ("RM3_30","075_3_30","ROM","3","30","30","કાહાકા યોકુજ પોરમેહેર હેય, જો સુન્નત કોઅલાહાન બોરહાકોય એને સુન્નત નાંય કોઅલે હેતેં ચ્યાહાનબી બોરહાકોય ન્યાયી ઠોરવેહે. ");
INSERT INTO gbl_vpl VALUES ("RM3_31","075_3_31","ROM","3","31","31","તે કાય આપા મૂસા નિયમાલ બોરહાકોય નોકામ્યા ઠોરાવજેહે? નાંય કોવેજ નાંય! બાકી આપા મૂસા નિયમાલ ચ્યા બરાબર મહત્વ દેય રીઅલે હેય. ");
INSERT INTO gbl_vpl VALUES ("RM4_1","075_4_1","ROM","4","1","1","તે યહૂદી ઓઅના લીદે આપા આપહે આગલ્યાડાયા આબ્રાહામા બારામાય કાય આખજે? કાય ચ્યાલ શારીરિકરીતે કાય મિળ્યાં? ");
INSERT INTO gbl_vpl VALUES ("RM4_2","075_4_2","ROM","4","2","2","જો આબ્રાહામ ચ્યા હારાં કામહાકોય ન્યાયી ઠરતો તે તો અભિમાન કોઅય હોકતો, બાકી પોરમેહેરા હામ્મે અભિમાન નાંય કોઅય હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM4_3","075_4_3","ROM","4","3","3","કાહાકા પવિત્રશાસ્ત્રમાય આબ્રાહામા બારામાય લોખલાં હેય કા, “આબ્રાહામાલ પોરમેહેરાય જીં આખ્યાં ચ્યાવોય ચ્ચે બોરહો કોઅયો એને ચ્યાહાટી પોરમેહેરાય ચ્યાલ ન્યાયી ઠોરવ્યો.” ");
INSERT INTO gbl_vpl VALUES ("RM4_4","075_4_4","ROM","4","4","4","જીં કામ કોઅહે, ચ્યાલ મોજરી દેઅના દાન નાંય ગોણાય, બાકી ચ્યા મોજરી લેઅના હક હેય. ");
INSERT INTO gbl_vpl VALUES ("RM4_5","075_4_5","ROM","4","5","5","બાકી જો ન્યાયી ઠોરાહાટી કામ નાંય કોએ બાકી પાપી માઅહાન ન્યાયી ઠોરાવનારાવોય બોરહો કોઅહે, ચ્યા બોરહો ચ્યાલ ન્યાયી બોનાડેહે. ");
INSERT INTO gbl_vpl VALUES ("RM4_6","075_4_6","ROM","4","6","6","યેજ રીતે દાઉદ રાજા ઓહડા માઅહાલ ધન્ય આખહે, જ્યાલ હારેં કામે કોઅયા વોગાર પોરમેહેર ન્યાયી ઠોરવેહે. ");
INSERT INTO gbl_vpl VALUES ("RM4_7","075_4_7","ROM","4","7","7","“ધન્ય હેય ચ્યે જ્યાહા પાપ માફ ઓઅયાહા, એને જ્યાહા પાપહાલ ડાકી દેનહા. ");
INSERT INTO gbl_vpl VALUES ("RM4_8","075_4_8","ROM","4","8","8","ધન્ય હેય તી માઅહું, જ્યા પાપહા પોરમેહેર ઇસાબ નાંય લેય.” ");
INSERT INTO gbl_vpl VALUES ("RM4_9","075_4_9","ROM","4","9","9","તે ઈ ધન્ય વચન, કાય સુન્નત કોઅલા યહૂદી લોકહા હાટીજ હેય? કા સુન્નત નાંય કોઅલા ગેર યહૂદી લોકહાહાટીબી હેય? પવિત્રશાસ્ત્રમાય આબ્રાહામા બારામાય લોખલાં હેય તીંજ આમા આખજેહે કા, “આબ્રાહામાલ પોરમેહેરાય જીં આખ્યાં ચ્યાવોય બોરહો કોઅયો એને યાહાટી પોરમેહેરાય ચ્યાલ ન્યાયી ઠોરવ્યો.” ");
INSERT INTO gbl_vpl VALUES ("RM4_10","075_4_10","ROM","4","10","10","તે પોરમેહેરાય આબ્રાહામાલ કોવે ન્યાયી ઠોરાવલો ગીયો? પોરમેહેરાય આબ્રાહામાલ ચ્યા સુન્નત કોઅના પેલ્લાજ ન્યાયી ઠોરવ્યો, એહેકેન નાંય જાયા કા આબ્રાહામા સુન્નત કોઅયા પાછે ન્યાયી ઠોર્યો. ");
INSERT INTO gbl_vpl VALUES ("RM4_11","075_4_11","ROM","4","11","11","આબ્રાહામા સુન્નત કોઅના પેલ્લા ચ્યાય પોરમેહેરાય જીં આખ્યાં ચ્યાવોય બોરહો કોઅયો એને યાહાટી પોરમેહેરાય ચ્યાલ ન્યાયી ઠોરવ્યો, ચ્યાવોય સિક્કો તરીકે સુન્નતા નિશાણી લાવી, એહેકેન યાહાટી કા તો બોદહા આબહો બોને, જ્યેં સુન્નત કોઅયા વોગર પોરમેહેરાવોય બોરહો કોઅતેહે, જેથી ચ્યાહાબી પોરમેહેરાવોય બોરહો કોઅના ચ્યાહાન ન્યાયી ઠોરવે. ");
INSERT INTO gbl_vpl VALUES ("RM4_12","075_4_12","ROM","4","12","12","એને આબ્રાહામ ચ્યા સુન્નત કોઅલા યહૂદી લોકહા બી આબહો ઠોરે, જ્યેં ફક્ત સુન્નત કોઅલા હેય ઓલહાંજ નાંય, બાકી આમહે આગલ્યો ડાયો આબ્રાહામા હારકા બોરહો કોઇન જીવન જીવનારા બી હેય, જેહેકેન આબ્રાહામાય સુન્નત કોઅના પેલ્લા પોરમેહેરાવોય બોરહો કોઅયેલ. ");
INSERT INTO gbl_vpl VALUES ("RM4_13","075_4_13","ROM","4","13","13","પોરમેહેરાય આબ્રાહામ એને ચ્યા કુળા લોકહાઆરે વાયદો કોઅયો કા ચ્યા દોરતી વારીસ બોની, ઈ યાહાટી નાંય જાયા કા આબ્રાહામાય મૂસા નિયમ પાળ્યા બાકી યાહાટી કા સુન્નત કોઅના પેલ્લા આબ્રહામાય પોરમેહેરા નિયમાહાવોય બોરહો કોઅયો એને પોરમેહેરાય ચ્યાલ ન્યાયી ઠોરવ્યો. ");
INSERT INTO gbl_vpl VALUES ("RM4_14","075_4_14","ROM","4","14","14","કાહાકા જો દુનિયાવોય ઓદિકાર કોઅના પોરમેહેરા વાયદો ચ્યા લોકહાહાટી હેય, જ્યા મૂસા નિયમ પાળતાહા, તે પાછે પોરમેહેરાવોય બોરહો કોઅના નોકામ્યા એને પોરમેહેરા વાયદો તૂટી ગીયો. ");
INSERT INTO gbl_vpl VALUES ("RM4_15","075_4_15","ROM","4","15","15","જીં મૂસા નિયમ પુરીરીતે નાંય પાળે ચ્યાલ પોરમેહેર ડૉડ દેઅરી, બાકી જાં મૂસા નિયમ હેયેજ નાંય તાં મૂસા નિયમ તોડના વાતુજ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM4_16","075_4_16","ROM","4","16","16","યાહાટી લોક બોરહાકોય પોરમેહેરા વાયદો મેળવી હોક્યા. ઓહડા યાહાટી ઓઅહે કા વાયદો સદા મોયાથી મીળે, તોવે આબ્રાહામા બોદા પોહહાન તો વાયદો મિળી હોકહે, ઈ ફક્ત ચ્ચાહાહાટી નાંય હેય જ્યેં મૂસા નિયમાહાન પાળતેહે, બાકી બોદા લોકહાહાટી હેય જ્યા આબ્રાહામા હારકા બોરહાકોય જીવતાહા, જો આપે બોદહા આગલ્યો ડાયો હેય. ");
INSERT INTO gbl_vpl VALUES ("RM4_17","075_4_17","ROM","4","17","17","જેહેકેન પવિત્રશાસ્ત્રમાય લોખલાં હેય, “માયે તુલ બોજ જાત્યેહે આબહો ઠોરવ્યોહો” પોરમેહેરા નોજરેમાય આબ્રાહામ આપહે આબહો હેય, ચ્ચાય ચ્ચા પોરમેહેરાવોય બોરહો કોઅયો, જો પોરમેહેર મોઅલા માઅને પાછો જીવતો કોઅહે, એને જ્યો વાતો અસ્તિત્વામાય હેયેજ નાંય, ચ્ચેહે નાંવ એહેકોયન લેતહેં કા ચ્ચે અસ્તિત્વામાય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM4_18","075_4_18","ROM","4","18","18","ચ્યાય નિરાશા માયબી આશા રાખીન બોરહો કોઅયો, એને બોજ જાત્યેહે આબહો બોની ગીયો, જેહેકેન પવિત્રશાસ્ત્રમાય આબ્રાહામા બારામાય લોખલાં હેય, કા “આબ્રાહામ બોજ જાત્યેહે આબહો ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("RM4_19","075_4_19","ROM","4","19","19","આબ્રાહામ ઈ જાંઇનબી કા તો પોહેં પૈદા કોઅરાહાટી બોજ ડાયો ઓઅય ગીયહો કાહાકા ચ્યા ઉંબાર લગભગ હોવ વોરહે ઓઅય ગીયેલ, એને સારાબી વાંયટી આતી, તેરુંબી આબ્રાહામ બોરહો કોઅતો રિયો. ");
INSERT INTO gbl_vpl VALUES ("RM4_20","075_4_20","ROM","4","20","20","આબ્રાહામાય પોરમેહેરા વાયદાહાવોય શંકા નાંય કોઅયી બાકી ચ્યાવોય મજબુત બોરહો કોઇન પોરમેહેરા મહિમા કોઅયી. ");
INSERT INTO gbl_vpl VALUES ("RM4_21","075_4_21","ROM","4","21","21","એને નોક્કી જાંઅયા કા જીં વાતે પોરમેહેરાય વાયદો કોઅલો હેય, તી પુરી કોઅરાહાટી પોરમેહેર બોરહાવાળો હેય. ");
INSERT INTO gbl_vpl VALUES ("RM4_22","075_4_22","ROM","4","22","22","આબ્રાહામાલ પોરમેહેરાય જીં આખ્યાં ચ્યાવોય ચ્ચે બોરહો કોઅયો એને ચ્યાહાટી “પોરમેહેરાય ચ્યાલ ન્યાયી ઠોરવ્યો.” ");
INSERT INTO gbl_vpl VALUES ("RM4_23","075_4_23","ROM","4","23","23","જેહેકેન પવિત્રશાસ્ત્રમાય લોખલાં હેય, આબ્રાહામાલ પોરમેહેરાય જીં આખ્યાં ચ્યાવોય ચ્ચે બોરહો કોઅયો એને યાહાટી પોરમેહેરાય ચ્યાલ ન્યાયી ઠોરવ્યો, એહેકોય ફક્ત આબ્રાહામાહાટીજ નાંય લોખલાં ગીયા, ");
INSERT INTO gbl_vpl VALUES ("RM4_24","075_4_24","ROM","4","24","24","બાકી જો આપાબી પોરમેહેરાવોય બોરહો કોઅજેહે, કા ચ્યાય આપહે પ્રભુ ઈસુ ખ્રિસ્તાલ મોઅલામાયને પાછો જીવતો કોઅયો, તે આપાબી બોરહો કોઅલા લીદે ન્યાયી ઠોરહું. ");
INSERT INTO gbl_vpl VALUES ("RM4_25","075_4_25","ROM","4","25","25","ઈસુ આપહે પાપહાહાટી મોઅઇ ગીયો, એને આપહાન ન્યાયી ઠોરવાહાટી પોરમેહેરાય ચ્યાલ મોઅલા માઅને પાછો જીવતો બી કોઅયો. ");
INSERT INTO gbl_vpl VALUES ("RM5_1","075_5_1","ROM","5","1","1","યાહાટી આપા બોરહો કોઅનાકોય ન્યાયી ઠોર્યે, તે આપહે પ્રભુ ઈસુ ખ્રિસ્તાકોય પોરમેહેરાઆરે શાંતીમાય રા. ");
INSERT INTO gbl_vpl VALUES ("RM5_2","075_5_2","ROM","5","2","2","આપહે બોરહો કોઅના લીદે ખ્રિસ્તાય આપહાન પોરમેહેરા સદા મોયામાય પોઅચાડયાહા, જાં આમી આપા હેજે, એને આપા યે વાતેહાટી આનંદ કોઅજેહે કા આપહાન પોરમેહેરા મહિમામાય ભાગી ઓઅના આશા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM5_3","075_5_3","ROM","5","3","3","ફક્ત ઓલહાંજ નાંય, બાકી આપા આપહે મુશીબાત માયબી આનંદ કોઆ, કાહાકા આમા જાંઅજેહે કા જોવે આપા દુઃખ ઉઠાવજેહે તોવે હારેં રીતે ધીરજ રાખના હિકજેહે, ");
INSERT INTO gbl_vpl VALUES ("RM5_4","075_5_4","ROM","5","4","4","કાહાકા આપા ધીરજ રાખજેહે તો પોરમેહેર આપહાન સ્વીકાર કોઅહે, એને પોરમેહેર આપહાન સ્વીકાર કોઅહે, યાહાટી આપહાન આશા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM5_5","075_5_5","ROM","5","5","5","એને આશા થી શરામ નાંય ઓઅય, કાહાકા પોરમેહેરાય આપહાન પવિત્ર આત્મા દેનલા હેય ચ્યાકોય પોરમેહેરા પ્રેમ આપહે મોનામાય બાઆલા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM5_6","075_5_6","ROM","5","6","6","કાહાકા આપા જોવે નોબળે આતેં, તોવે ખ્રિસ્ત પાપી લોકહાહાટી યોગ્ય સમયે મોઅયો. ");
INSERT INTO gbl_vpl VALUES ("RM5_7","075_5_7","ROM","5","7","7","કાદા ન્યાયી માઅહાહાટી ભાગ્યેજ મોઅઇ હોકહે, બાકી એહેકોય બી ઓઈ હોકહે કા કાદા હારાં માઅહાહાટી કાદા મોરાં ઈંમાત કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("RM5_8","075_5_8","ROM","5","8","8","બાકી પોરમેહેર ચ્યા પ્રેમ એને ભલાઈ યે રીતેથી પ્રગટ કોઅહે કા જોવે આપા પાપી આતેં તોવે ખ્રિસ્ત આપેહાટી મોઅયો. ");
INSERT INTO gbl_vpl VALUES ("RM5_9","075_5_9","ROM","5","9","9","તોવે આમી આપા ઈસુ ખ્રિસ્તા લોય વોવાડલાં કોય ન્યાયી ઠોર્યે યાહાટી આપહાન ખાત્રી હેય કા આપા ઈસુ ખ્રિસ્તાકોય પોરમેહેરા ડૉડાપાઅને બોચાવલે જાહું. ");
INSERT INTO gbl_vpl VALUES ("RM5_10","075_5_10","ROM","5","10","10","કાહાકા જોવે આપા પોરમેહેરા દુશ્માન આતેં, તોવે પોરમેહેરા પોહો ઈસુ ખ્રિસ્તા મોરણાકોય આપહે પોરમેહેરાઆરે મેળમિલાપ જાયો, યાહાટી આપહાન ખાત્રી હેય કા જોવે આપહે ચ્યાઆરે મેળમિલાપ ઓઅય ગીયો, તે તો આપહાન નોક્કીજ બોચાવી. ");
INSERT INTO gbl_vpl VALUES ("RM5_11","075_5_11","ROM","5","11","11","ફક્ત ઓલહાંજ નાંય, બાકી આપહે પ્રભુ ઈસુ ખ્રિસ્તાકોય પોરમેહેરાઆરે આપહે મેળમિલાપ ઓઅય ગીઅલો હેય, યાહાટી આપા પોરમેહેરામાય આનંદિત હેજે. ");
INSERT INTO gbl_vpl VALUES ("RM5_12","075_5_12","ROM","5","12","12","જેહેકેન યોક માઅહાકોય પાપ દુનિયામાય યેના, એટલે આદામાકોય, તો પેલ્લો માટડો આતો જ્યાલ પોરમેહેરાય બોનાવ્યો, કાહાકા આદામાય પાપ કોઅયા, યાહાટી તો મોઅઇ ગીયો, કાહાકા બોદે માઅહે આદામા પોહેં હેય, યાહાટી જોવે આદામાય પાપ કોઅયા તે બોદહાય પાપ કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("RM5_13","075_5_13","ROM","5","13","13","મૂસા નિયમ દેઅના પેલ્લા બી લોકહાય પાપ કોઅયા, બાકી યાલ પાપા રુપામાય નાંય ગોણાય કાહાકા તાંવ લોગુ નિયમ પાળાહાટી મૂસા નિયમ નાંય દેનલા આતા. ");
INSERT INTO gbl_vpl VALUES ("RM5_14","075_5_14","ROM","5","14","14","તેરુંબી આદામ થી લેઈને મૂસા લોગુ બોદા લોકહાય પાપ કોઅયા એને બોદે મોઅઇ ગીયે, જ્યાહાય આદામા હારકા કોઅહોજ નિયમ નાંય પાળવાથી પાપ નાંય કોઅયા, આદામ ચ્યા માઅહા પ્રતિરૂપ આતો, જો યેનારો આતો. ");
INSERT INTO gbl_vpl VALUES ("RM5_15","075_5_15","ROM","5","15","15","બાકી આદામા પાપ ચ્યા વરદાના હારકા નાંય હેય, જીં પોરમેહેર આપહાન ચ્યા સદા મોયાકોય દેહે, કાહાકા યોક માઅહા પાપ કોઅના લીદે બોજ લોક મોઅઇ ગીયે, બાકી પોરમેહેરા સદા મોયા એને ન્યાયપણા વરદાન ચ્યા કોઅતાબી વોદારી હેય, જીં ચ્યાય બોજ લોકહાહાટી ચ્યા યોક ઈસુ ખ્રિસ્તાકોય દેનલા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM5_16","075_5_16","ROM","5","16","16","પોરમેહેરાય જીં વરદાન આપહાન દેનલા હેય તી આદામા પાપા હારકા નાંય હેય, કાહાકા યોક યોખલા પાપ ડૉડ લેય યેના, બાકી આપહાય બોજ પાપ કોઅયા, તેરુંબી પોરમેહેરાય આપહાન ઓહડા વરદાન દેના જ્યાંય આપહાન ચ્યા નોજરેમાય ન્યાયી બોનાડ્યા. ");
INSERT INTO gbl_vpl VALUES ("RM5_17","075_5_17","ROM","5","17","17","કાહાકા જોવે યોક માઅહા પાપહાલીદે બોદા લોક મોઅઇ ગીયા, બાકી ચ્યા પરિણામ કોલહાક વોદારી લોકહાય પોરમેહેરા સદા મોયા એને ન્યાયપણા વરદાન વોદારી મિળી, ચ્યે ઈસુ ખ્રિસ્તાકોય અનંતજીવન મિળવી, એને ચ્ચાઆરે રાજ્ય કોઅરી. ");
INSERT INTO gbl_vpl VALUES ("RM5_18","075_5_18","ROM","5","18","18","યાહાટી જેહેકેન યોક માઅહા પાપહાલીદે બોદા માઅહાન ડૉડ બોગાવના આગના મિળી, તેહેકેન યોક માઅહા ન્યાયી કામા લીદે બોદહાન પાપહા માફી એને અનંતજીવન મિળલા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM5_19","075_5_19","ROM","5","19","19","જેહેકેન યોક માઅહા આગના નાંય માનવાથી બોદા લોક પાપી ઠોર્યા, તેહેકોયજ એક માઅહા આગના માનનાકોય બોદા લોક ન્યાયી ઠોર્યા. ");
INSERT INTO gbl_vpl VALUES ("RM5_20","075_5_20","ROM","5","20","20","પોરમેહેરાય મૂસા નિયમ યાહાટી દેના કા લોકહાન ખોબાર પોડે એને આજુ વોદારી પાપ નાંય કોએ, બાકી જોવે લોકહાય બોજ પાપ કોઅયા, તાં પોરમેહેરાય જીં સદા મોયા દેખાડી તી ચ્યા કોઅતા બોજ ઓઅય ગીયી. ");
INSERT INTO gbl_vpl VALUES ("RM5_21","075_5_21","ROM","5","21","21","કા જેહેકેન બોદા લોકહાય પાપ કોઅયા એને બોદે મોઅઇ ગીયે, તેહેકેન આપહે પ્રભુ ઈસુ ખ્રિસ્તાકોય પોરમેહેરા સદા મોયા ચ્યાહાન ન્યાયી બોનાડેહે, એને ચ્યાહાન અનંતજીવન દેહે. ");
INSERT INTO gbl_vpl VALUES ("RM6_1","075_6_1","ROM","6","1","1","પોરમેહેર ચ્યા સદા મોયાકોય આપહે પાપહાલ માફ કોઅહે, બાકી આપહાય એહેકેન નાંય વિચાર કોઅરા જોજે કા ચાલા આપા પાપ કોઅતેજ રોજે. ");
INSERT INTO gbl_vpl VALUES ("RM6_2","075_6_2","ROM","6","2","2","નાંય, કોવેજ નાંય, આપા જોવે પાપાહાટી મોઅઇ ગીયે તે આપહાન પાપ કોઅરા નાંય જોજે. ");
INSERT INTO gbl_vpl VALUES ("RM6_3","075_6_3","ROM","6","3","3","આમા જાંઅજેહે કા, આપા બોદા જોલા લોકહાય ઈસુ ખ્રિસ્તામાય બાપતિસ્મા લેદા તે આપા ચ્યાઆરે મોઅઇ ગીયે. ");
INSERT INTO gbl_vpl VALUES ("RM6_4","075_6_4","ROM","6","4","4","એને જોવે આપહાય બાપતિસ્મા લેદા તોવે આપા ખ્રિસ્તાઆરે મોઅઇ ગીયે એને દાટી દેનલે ગીયે, જેથી જેહેકેન ખ્રિસ્ત પોરમેહેર આબહા મહિમાકોય મોઅલામાયને પાછો જીવતો જાયો, તેહેકેન આપાબી નોવા જીવન જીવહું. ");
INSERT INTO gbl_vpl VALUES ("RM6_5","075_6_5","ROM","6","5","5","કાહાકા જો આપા બાપતિસ્મા લેદલા કોય ખ્રિસ્તા મોરણામાય યોક ઓઅય ગીયે, તે નોક્કીજ મોઅલા માઅને પાછા જીવી ઉઠીન ખ્રિસ્તાઆરે યોક ઓઅય જાહું. ");
INSERT INTO gbl_vpl VALUES ("RM6_6","075_6_6","ROM","6","6","6","કાહાકા આપા જાંઅજેહે કા આપહે જુનો પાપી સ્વભાવ ઈસુ ખ્રિસ્તાઆરે હુળીખાંબાવોય ચોડવી દેનલો ગીયો, જેથી આપહે શરીરામાય પાપા સ્વભાવ નાશ ઓઅય જાય, એને આપા પાછે પાપા ગુલામ નાંય રોજે. ");
INSERT INTO gbl_vpl VALUES ("RM6_7","075_6_7","ROM","6","7","7","જો આપા ખ્રિસ્તાઆરે મોઅઇ ગીયે તે પાછે આપા પાપા ગુલામીમાઅને છુટી ગીયે. ");
INSERT INTO gbl_vpl VALUES ("RM6_8","075_6_8","ROM","6","8","8","યાહાટી જો આમા ખ્રિસ્તાઆરે મોઅઇ ગીયે, તોવે આમે બોરહો ઓ હેય કા ચ્યાઆરે જીવહું બી. ");
INSERT INTO gbl_vpl VALUES ("RM6_9","075_6_9","ROM","6","9","9","કાહાકા આપા ઈ જાંઅતેહે ખ્રિસ્ત મોઅલા માઅને પાછો જીવતો ઉઠયો એને આમી પાછે કોવેજ નાંય મોઅરી, કાહાકા આમી ચ્યાવોય મોરણા ઓદિકાર નાંય રિયો. ");
INSERT INTO gbl_vpl VALUES ("RM6_10","075_6_10","ROM","6","10","10","કાહાકા ખ્રિસ્ત જો મોઅઇ ગીયો તો પાપાહાટી યોકુજદા મોઅઇ ગીયો, બાકી આમી તો જીવતો હેય તે પોરમેહેરા સેવાહાટી જીવતો હેય. ");
INSERT INTO gbl_vpl VALUES ("RM6_11","075_6_11","ROM","6","11","11","એહકોયજ તુમાબી પોતાના પાપાહાટી મોઅઇ ગીયે એહેકેન હોમજાં, બાકી આમી પોરમેહેરા સેવા કોઅરાહાટી ખ્રિસ્ત ઈસુમાય જીવતે હેય. ");
INSERT INTO gbl_vpl VALUES ("RM6_12","075_6_12","ROM","6","12","12","યાહાટી પાપ કોઅરાહાટી તુમહે શરીરાલ પાપા ગુલામ નાંય બોના દા, એને પાપા ઇચ્છા નુસાર કામ નાંય કોઅના. ");
INSERT INTO gbl_vpl VALUES ("RM6_13","075_6_13","ROM","6","13","13","તુમા તુમહે પોતાના શરીરા અવયવાલ ખારાબ કામ કોઅરાહાટી પાપાલ નાંય હોપતે, બાકી પોતાલ મોઅલા માઅને જીવી ઉઠના હોમજીન તુમહે જીવનાલ પોરમેહેરાલ હોઅપી દા, એને તુમહે શરીરા અવયવાલ હારેં કામ કોઅરાહાટી તુમહે જીવનાલ પુરીરીતે પોરમેહેરાલ હોઅપી દા. ");
INSERT INTO gbl_vpl VALUES ("RM6_14","075_6_14","ROM","6","14","14","તોવે તુમહાવોય પાપા ઓદિકાર નાંય ઓરી, કાહાકા તુમા મૂસા નિયમા આધીન નાંય બાકી પોરમેહેરા સદા મોયા આધીન જીવતાહા. ");
INSERT INTO gbl_vpl VALUES ("RM6_15","075_6_15","ROM","6","15","15","આપા મૂસા નિયમાહા આધીન નાંય હેય, બાકી પોરમેહેરા સદા મોયા આધીન હેય, યાહાટી આપહાન પાપ કોવેજ નાંય કોઅરા જોજે. ");
INSERT INTO gbl_vpl VALUES ("RM6_16","075_6_16","ROM","6","16","16","તુમા જાંઅતેહે કા જોવે તુમા કાદા ગુલામ બોની જાતહેં તોવે તી માઅહું તુમહે દોણી બોની જાહે, ઓઅય હોકે તુમા પાપા ગુલામ ઓઅય હોકતેહેં જીં મોરણા એછે લેય જાહે, યા તુમા પોરમેહેરા આગના પાળી હોકતેહેં જીં ન્યાયી જીવના એછે લેય જાહે. ");
INSERT INTO gbl_vpl VALUES ("RM6_17","075_6_17","ROM","6","17","17","તુમા પેલ્લા પાપા ગુલામ આતેં, બાકી આમી તુમા ચ્યા શિક્ષણા પાલન કોઅતેહે, જીં તુમહાન હિકાડયાં, યાહાટી આંય પોરમેહેરા ધન્યવાદ કોઅતાહાંવ. ");
INSERT INTO gbl_vpl VALUES ("RM6_18","075_6_18","ROM","6","18","18","પોરમેહેરાય તુમહાન પાપા ગુલામીમાઅને છોડાવીન ચ્યા ચાકાર બોનાડ્યા, જેથી તુમા જીં હારાં કામ હેય તી કોઆ. ");
INSERT INTO gbl_vpl VALUES ("RM6_19","075_6_19","ROM","6","19","19","આંય તુમહે હોમાજના નોબળાયે લીદે માઅહા વિચારાકોય આખહુ, જેહેકોય તુમહાય પોતાના શરીરા અવયવાલ અશુદ્ધતા એને ખારાબ કામ કોઅરાહાટી હોપલા આતા, તેહેકોયજ આમી પોતાના શરીરા અવયવાલ ન્યાયી જીવન જીવાહાટી હોઅપી દા. ");
INSERT INTO gbl_vpl VALUES ("RM6_20","075_6_20","ROM","6","20","20","જોવે તુમા પાપા ગુલામ આતેં, તોવે તુમહામાય ન્યાયી કામ કોઅના કાયજ ઇચ્છા નાંય આતી. ");
INSERT INTO gbl_vpl VALUES ("RM6_21","075_6_21","ROM","6","21","21","બાકી તુમા ખારાબ કામ કોઅતે આતેં, એને આમી તુમહાન ચ્યા કામહા લીદે શરામ યેહે, કાહાકા ચ્યા કામહા બોદલો મોરણ હેય. ");
INSERT INTO gbl_vpl VALUES ("RM6_22","075_6_22","ROM","6","22","22","બાકી આમી તુમા પાપા ગુલામીમાઅને છુટીન પોરમેહેરા ચાકાર બોનીન ચ્યા કામહાલ કોઅતેહે જ્યેં પવિત્રતા એછે લેય જાતહેં, જ્યા પ્રતિફળ અનંતજીવન હેય. ");
INSERT INTO gbl_vpl VALUES ("RM6_23","075_6_23","ROM","6","23","23","કાહાકા પાપ કોઅના બોદલો મોરણ હેય, બાકી પોરમેહેરા વરદાન આમહે પ્રભુ ઈસુ ખ્રિસ્તામાય અનંતજીવન હેય. ");
INSERT INTO gbl_vpl VALUES ("RM7_1","075_7_1","ROM","7","1","1","ઓ વિસ્વાસી બાહાહાય, આંય નિયમ જાંઅનારાહાલ આખહુ, કા જાવ લોગુ માઅહું જીવતા રોહે, તાંઉલોગુ ચ્યાવોય નિયમ પાળના રોહે. ");
INSERT INTO gbl_vpl VALUES ("RM7_2","075_7_2","ROM","7","2","2","વોરાડ ઓઅય ગીઅલી થેએ નિયમા ઇસાબે પોતાના માટડો જીવતો હેય તાંવ લોગુ તી ચ્યાઆરે બાંદાલી હેય, બાકી જોવે પોતાનો માટડો મોઅઇ જાય તે તી નિયમા ઇસાબે માટડા પાઅને છુટી ઓઅય જાહે. ");
INSERT INTO gbl_vpl VALUES ("RM7_3","075_7_3","ROM","7","3","3","બાકી જોવે ચ્યે માટડો જીવતો હેય, તાવુંજ તી બિજા માટડાઆરે વોરાડ કોએ તે તી વ્યબિચાર કોઅહે એહેકેન આખાય, બાકી જોવે તી પોતાનો માટડો મોઅઇ જાય તોવે તી નિયમા ઇસાબે છુટી ઓઅય જાહે, પાછે તી બિજા માટડાઆરે વોરાડ કોઅય તે તી વ્યબિચાર કોઅહે એહેકેન નાંય આખાય. ");
INSERT INTO gbl_vpl VALUES ("RM7_4","075_7_4","ROM","7","4","4","તે ઓ મા વિસ્વાસી બાહાહાય, જોવે તુમાબી ખ્રિસ્તાઆરે મોઅઇ ગીયા, તે તુમા નિયમાહા ઓદિકારા હાટી મોઅઇ ગીયા, આમી તુમા ખ્રિસ્તા હેય જો મોઅલા માઅને પાછો જીવતો ઓઅય ગીયહો, જેથી તુમા આમી પોરમેહેરા સેવાહાટી જીવન જીવી હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM7_5","075_7_5","ROM","7","5","5","જોવે આપા આપહે પાપી સ્વભાવા ગુલામમાય આતેં, તોવે મૂસા નિયમા વોળાખ જાયી એને પાપ કોઅના ઇચ્છા આપહે મોરણ લેય યાહાટી આપહે શરીરામાય કામ કોઅતી આતી. ");
INSERT INTO gbl_vpl VALUES ("RM7_6","075_7_6","ROM","7","6","6","બાકી આપા આમી મૂસા નિયમાહા ગુલામમાય નાંય હેય કાહાકા આમા ચ્યાહા પાલન કોઅરાહાટી મોઅઇ ચુકલેં હેય, જ્યામાય આપા ગુલામ આતેં, આમી આપા પોરમેહેરા સેવા જુની રીતેકોય લોખલાં નિયમાહાન માનનાકોય નાંય કોઅજે, બાકી પવિત્ર આત્મામાય રોયનાકોય નોવી રીતેકોય સેવા કોઅજેહે. ");
INSERT INTO gbl_vpl VALUES ("RM7_7","075_7_7","ROM","7","7","7","તે કાય યા મતલબ ઓ હેય કા મૂસા નિયમ પાપ હેય? નાંય કોવેજ નાંય, બાકી મૂસા નિયમાહાકોય આપા પાપ કાય હેય તી જાંઆય હોકજેહે, આપહાય જાંઅયાહા કા લોબ કોઅના પાપ હેય, કાહાકા મૂસા નિયમમાય લોખલાં હેય કા, “લોબ નાંય કોઅના”, તો આપહાન નાંય માલુમ ઓઅતા કા લોબ કોઅના પાપ હેય. ");
INSERT INTO gbl_vpl VALUES ("RM7_8","075_7_8","ROM","7","8","8","બાકી પાપાય ઈ આગના ઉપયોગ કોઇન બોદા પ્રકારા લોબ માંયેમાય પૈદા કોઅયો, કાહાકા નિયમ નાંય હેય તે પાપ મોઅલા માઅહા હારકા હેય જ્યામાય કાયજ કોઅના તાકાત નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM7_9","075_7_9","ROM","7","9","9","પેલ્લા આંય મૂસા નિયમ જાંઅયા વોગર રોતો આતો, બાકી જોવે માયે મૂસા નિયમ જાંઅયા, તોવે મા મોનામાય પાપ કોઅના ઇચ્છા વોદી ગીયી, એને આંય પોરમેહેરાપાઅને દુઉ ઓઅય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("RM7_10","075_7_10","ROM","7","10","10","એને ચ્યા નિયમ જ્યા પોરમેહેરાય મા જીવનાહાટી બોનાવ્યાં, ચ્યાહાકોયજ આંય પોરમેહેરાપાઅને દુઉ ઓઅય ગીયો. ");
INSERT INTO gbl_vpl VALUES ("RM7_11","075_7_11","ROM","7","11","11","કાહાકા પાપાય યે આગના ઉપયોગ કોઇન માન દોગો દેનો, એને ચ્યાજકોય માન પોરમેહેરાપાઅને દુઉ કોઅય દેનો. ");
INSERT INTO gbl_vpl VALUES ("RM7_12","075_7_12","ROM","7","12","12","તે યા મતલબ ઓ હેય કા મૂસા નિયમ પવિત્ર હેય, એને આગના પવિત્ર, ન્યાયી, એને હારી હેય. ");
INSERT INTO gbl_vpl VALUES ("RM7_13","075_7_13","ROM","7","13","13","તોવે કાય જ્યા મૂસા નિયમ હારાં હેય, ચ્યા માન પોરમેહેરાપાઅને દુઉ કોઅહે? નાંય કોવેજ નાંય, ઈ પાપ આતા જ્યાંય એહેકેન કોઅયા, પાપાય ચ્યાજ મૂસા નિયમાહા ઉપયોગ કોઅન માન પોરમેહેરાપાઅને દુઉ કોઅય દેનો, એને એહેકેન પાપા આસલી રુપ પ્રગટ ઓઅય ગીયો, એને પાપ આગનાકોય વોદારી પાપી સાબિત જાયા. ");
INSERT INTO gbl_vpl VALUES ("RM7_14","075_7_14","ROM","7","14","14","આપા જાંઅજેહે કા, મૂસા નિયમ આત્મિક હેય, બાકી આંય માઅહું હેય, એને આંય પાપા ગુલામ હેય. ");
INSERT INTO gbl_vpl VALUES ("RM7_15","075_7_15","ROM","7","15","15","એને આંય જીં કોઅહુ ચ્યાલ નાંય જાંઉ, કાહાકા આંય જીં કોઅરા દારહું તી નાંય કોઉ, બાકી જ્યા માન ઘૃણા ઓઅહે, તીંજ આંય કોઅહુ. ");
INSERT INTO gbl_vpl VALUES ("RM7_16","075_7_16","ROM","7","16","16","એને જો આંય ખારાબ કામ કોઅહુ, તે આંય માની લાહુ કા મૂસા નિયમ હારાં હેય. ");
INSERT INTO gbl_vpl VALUES ("RM7_17","075_7_17","ROM","7","17","17","તોવે ઓહડી દશામાય પાપ કોઅનારો માઅહું આંય નાંય હેતો, બાકી જો માંયેમાય બાઆલો પાપ હેય તો ખારાબ કામ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("RM7_18","075_7_18","ROM","7","18","18","કાહાકા આંય જાંઅહું, કા માંયેમાય એટલે કા મા શરીરા સ્વભાવામાય હારી વસ્તુ વાસ નાંય કોએ, ઇચ્છા તે મા માય હેય, બાકી હારેં કામે માયેકોય ઓઈ નાંય હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM7_19","075_7_19","ROM","7","19","19","કાહાકા જીં હારાં કામ કોઅરાહાટી આંય ઇચ્છા કોઅહુ, તી તે નાંય કોઅય હોકુ, બાકી આંય જીં ખારાબ કામ નાંય કોઅરા માગુ, તીંજ કોઅયા કોઅહુ. ");
INSERT INTO gbl_vpl VALUES ("RM7_20","075_7_20","ROM","7","20","20","જો આંય તીંજ કોઅહુ જીં ખારાબ કામ હેય, તોવે તીં ખારાબ કામ કોઅનારો આંય નાંય રિયો, બાકી પાપ જો માંયેમાય બાઆલો હેય. ");
INSERT INTO gbl_vpl VALUES ("RM7_21","075_7_21","ROM","7","21","21","યે રીતીકોય, મા અનુભવ ઓ હેય કા જોવે આંય હારાં કામ કોઅરા માગહુ, તોવે માયેકોય ખારાબ કામ ઓઅય જાહે. ");
INSERT INTO gbl_vpl VALUES ("RM7_22","075_7_22","ROM","7","22","22","આંય મા મોનથી તે પોરમેહેરા નિયમાહાકોય તે બોજ ખુશ ઓઅહું. ");
INSERT INTO gbl_vpl VALUES ("RM7_23","075_7_23","ROM","7","23","23","બાકી માન પોતાના શરીરા અવયવાહામાય બિજા પ્રકારનો નિયમ દેખાયેહે, જીં મા મોનામાય હાચ્ચાં માની લેદલા નિયમાહા વિરુદ લડાય કોઅહે, એને માન પાપા ગુલામ બોનાડેહે, જો મા શરીરામાય કામ કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("RM7_24","075_7_24","ROM","7","24","24","આંય કોહડો દુઃખી માઅહું હેતાંવ, માન પોરમેહેરાપાઅને દુઉ કોઅનારા યા શરીરાપાઅને કું છોડાવી? ");
INSERT INTO gbl_vpl VALUES ("RM7_25","075_7_25","ROM","7","25","25","આંય પોરમેહેરા ધન્યવાદ કોઅતાહાંવ, જ્યાંય પ્રભુ ઈસુ ખ્રિસ્તાકોય માન બોચાવ્યો, મોનાકોય આંય પોરમેહેરા નિયમાહા સેવા કોઅતાહાંવ, બાકી શરીરાકોય પાપા સેવા કોઅતાહાંવ. ");
INSERT INTO gbl_vpl VALUES ("RM8_1","075_8_1","ROM","8","1","1","યા લીદે, આમી જ્યા લોક ઈસુ ખ્રિસ્તામાય હેય, ચ્યાહાલ ડૉડ દેઅના આગના નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_2","075_8_2","ROM","8","2","2","કાહાકા પવિત્ર આત્મા જીં આપહાન ઈસુ ખ્રિસ્ત પાઅને મિળહે, તુમહાન અનંતજીવન દેઅરી, એને તુમહાન પાપા એને મોરણા માઅને છોડવેહે. ");
INSERT INTO gbl_vpl VALUES ("RM8_3","075_8_3","ROM","8","3","3","કાહાકા માઅહા પાપી સ્વભાવા લીદે જીં કામ મૂસા નિયમ નાંય કોઅય હોક્યા, ચ્યાલ પોરમેહેરાય પુરાં કોઅયા, એટલે પોરમેહેરાય પોતાના પોહો ઈસુ ખ્રિસ્તાલ માઅહા હારકા પાપી શરીરા સમાનતામાય આપહે પાપહા બલિદાન ઓઅરાહાટી દોવાડયો, એહેકેન પોરમેહેરાય ખ્રિસ્ત ઈસુ શરીરાકોય પાપા શક્તિલ તોડી દેના. ");
INSERT INTO gbl_vpl VALUES ("RM8_4","075_8_4","ROM","8","4","4","યાહાટી ન્યાયી વિદી આપહે પાપી સ્વભાવાનુસાર નાંય બાકી પવિત્ર આત્મા ઇસાબે ચાલતેહે, મૂસા નિયમ પુરાં કોઅલા જાય. ");
INSERT INTO gbl_vpl VALUES ("RM8_5","075_8_5","ROM","8","5","5","જ્યા લોક પાપી સ્વભાવાનુસાર જીવન ચ્યા પાપી વાતહેબારામાય વિચાર કોઅતાહા, બાકી જ્યા પવિત્ર આત્માનુસાર જીવન જીવતાહા, ચ્યા પવિત્ર આત્માલ ખુશ કોઅના બારામાય વિચાર કોઅતાહા. ");
INSERT INTO gbl_vpl VALUES ("RM8_6","075_8_6","ROM","8","6","6","પાપી સ્વભાવાનુસાર જીવન જીવના પરિણામ મોરણ હેય, બાકી પવિત્ર આત્માકોય જીવન જીવના લીદે અનંતજીવન એને શાંતી મિળહે. ");
INSERT INTO gbl_vpl VALUES ("RM8_7","075_8_7","ROM","8","7","7","કાહાકા પાપી સ્વભાવાનુસાર વિચાર કોઅના તે પોરમેહેરા વિરુદ કોઅના હેય, કાહાકા પાપી સ્વભાવા વિચાર પોરમેહેરા નિયમાહા આધીન નાંય હેય, એને પોરમેહેરા નિયમાહા પાલન બી કોઅય નાંય હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM8_8","075_8_8","ROM","8","8","8","એને જ્યેં પાપી સ્વભાવાનુસાર જીવન જીવતેહે, ચ્યે પોરમેહેરાલ ખુશ નાંય કોઅય હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM8_9","075_8_9","ROM","8","9","9","બાકી જો પોરમેહેરા પવિત્ર આત્મા તુમહેમાય વાસ કોઅહે, તે તુમા પાપી સ્વભાવાનુસાર નાંય જીવે, બાકી પવિત્ર આત્માનુસાર જીવન જીવતેહે. જો કાદામાય પવિત્ર આત્મા નાંય હેય, તોવે તીં માઅહું ખ્રિસ્તા નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_10","075_8_10","ROM","8","10","10","જો ખ્રિસ્ત તુમહેમાય વાસ કોઅહે, તોવે શરીર પાપહાલીદે મોઅલા હેય, બાકી પવિત્ર આત્મા હારાં કામહા લીદે તુમહે આત્મા જીવતા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_11","075_8_11","ROM","8","11","11","એને જો પોરમેહેરા આત્મા જ્યાંય ઈસુલ મોઅલા માઅરે જીવાડયો, તુમહેમાય વાસ કોઅહે, જ્યાંય ખ્રિસ્તાલ મોઅલા માઅને જિવાડયોહો, તો તુમહે નાશમાન શરીરાલ બી પોતા આત્માકોય જો તુમહેમાય વાસ કોઅહે જીવાડી. ");
INSERT INTO gbl_vpl VALUES ("RM8_12","075_8_12","ROM","8","12","12","યાહાટી ઓ વિસ્વાસી બાહાહાય, આપહાન આગના પાલન કોઅરા જોજે, બાકી આપહે પાપી સ્વભાવ આપહાન એહેકેન નાંય કોઅરા દેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_13","075_8_13","ROM","8","13","13","કાહાકા જો તુમા પાપી સ્વભાવાનુસાર જીવન જીવહા તે પોરમેહેરાપાઅને દુઉ ઓઅય જાહા, એને જો તુમા પવિત્ર આત્મા સામર્થ્યાકોય પાપી સ્વભાવા ઇચ્છાકોય જીવન જીવના બંદ કોઅય દાહા, તે તુમા જીવતે રાહા. ");
INSERT INTO gbl_vpl VALUES ("RM8_14","075_8_14","ROM","8","14","14","યાહાટી કા જોલહેં બી માઅહે પોરમેહેરા આત્માકોય જીવન જીવતેહે, ચ્યેજ પોરમેહેરા પોહેં હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_15","075_8_15","ROM","8","15","15","પોરમેહેરાય જીં પવિત્ર આત્મા દેનહા તી તુમહાન ગુલામ નાંય બોનાવે, કા નાંય ગાબરાવે, બાકી યાકોય પવિત્ર આત્મા આપહાન પોરમેહેરા પોહેં બોનાડેહે, જ્યાકોય આપા “ઓ આબા, ઓ પિતા” આખી હોકજેહે. ");
INSERT INTO gbl_vpl VALUES ("RM8_16","075_8_16","ROM","8","16","16","પવિત્ર આત્મા પોતેજ આપહે આત્મા આરે સાક્ષી દેહે, કા આપા પોરમેહેરા પોહેં હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_17","075_8_17","ROM","8","17","17","એને જો પોરમેહેરા પોહેં હેય, તે વારીસ બી હેય, બાકી પોરમેહેરા વારીસ એને ખ્રિસ્તાઆરે વારીસ હેય, એને જો આપા ખ્રિસ્તાઆરે દુ:ખ ઉઠાવજેહે, તોવે ચ્યાઆરે મહિમા બી ભાગી બોનહું. ");
INSERT INTO gbl_vpl VALUES ("RM8_18","075_8_18","ROM","8","18","18","માન હારેકોય ખાત્રી હેય, કા જીં દુ:ખ આમી આપા બોગવી રીયહા તી દુઃખ તી મહિમા જીં પોરમેહેર આપહાન દેનારો હેય, ચ્યે મહિમા તુલના કોય આમન્યા દુઃખ કાયજ નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_19","075_8_19","ROM","8","19","19","કાહાકા ચ્યા બોનાડલી બોદી દુનિયા મોઠી આશેકોય પોરમેહેરા પોહહા રુપામાય પ્રગટ ઓઅના વાટ જોવી રિઅલી હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_20","075_8_20","ROM","8","20","20","કાહાકા ચ્યા બોનાડલી બોદી દુનિયા પોતાના ઇચ્છાથી નાંય, બાકી આધીન કોઅનારા પોરમેહેરાકોય નોકામ્યા આધીન ઈ આશા થી કોઅલી ગીયી, ");
INSERT INTO gbl_vpl VALUES ("RM8_21","075_8_21","ROM","8","21","21","કા ચ્યા બોનાડલી બોદી દુનિયા ચ્યા દિહયા વાટ જોવી રિઅલી હેય જોવે તી નાશા છુટકારો મેળવીન પોરમેહેરા પોહહા આરે મહિમા સ્વતંત્રતામાય સામીલ ઓઅય જાય. ");
INSERT INTO gbl_vpl VALUES ("RM8_22","075_8_22","ROM","8","22","22","આપા જાંઅજેહે કા જોવેને આદામાય પાપ કોઅયા, તોવેને લેયને આમી લોગુ પોરમેહેરાકોય બોનાડલી બોદી દુનિયા યોક મોયનાવાળી થેઅયે પોહાલ જન્મો દેઅના પીડા હારકી પીડા બોગવી રીયહી. ");
INSERT INTO gbl_vpl VALUES ("RM8_23","075_8_23","ROM","8","23","23","એને ફક્ત ચ્યા બોનાડલી બોદી દુનિયાજ નાંય, બાકી આપાબી, જ્યાહાય પવિત્ર આત્મા પોરમેહેરા પેલ્લી વસ્તુ હારકા મિળ્યાં, આપાબી ચ્યા સોમાયા વાટ જોવી રીયહે કા જોવે આપહાન પોરમેહેરા પોહેં બોનાહાટી પોરમેહેર ઉઠાવી લી એને આપહે શરીરાલ બોદા ખારાબ કામહા પાઅને બોચાવી. ");
INSERT INTO gbl_vpl VALUES ("RM8_24","075_8_24","ROM","8","24","24","આમી જોવે પોરમેહેરાય આપહાન તારણ કોઅલા હેય, તે આપહેપાય ઈ આશા હેય, બાકી જોવે તુમા આજુ કાય મિળવા ઇચ્છા કોઅય રીઅલે હેય જીં તુમહેપાય પેલ્લાથી હેય, તે તી આશા નાંય આખાય, એને કાદાબી માઅહું ચ્યે વસ્તુલ મિળવા ઇચ્છા નાંય કોઅય જીં વસ્તુ ચ્યાવોય પેલ્લાથીજ હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_25","075_8_25","ROM","8","25","25","બાકી આપા ચ્યે વસ્તુ આશા કોઅજેહે જીં આમી લોગુ આપહાપાય નાંય હેય, યાહાટી આપા ધીરજ રાખીન તાંવ લોગુ વાટ જોવજેહે જાવ લોગુ ચ્યાલ મેળવી નાંય લેજે. ");
INSERT INTO gbl_vpl VALUES ("RM8_26","075_8_26","ROM","8","26","26","યેજ રીતેથી પવિત્ર આત્માબી આપહે મોદાત કોઅહે, જોવે આપહે પોરમેહેરાવોય બોરહો કમજોર હેય, કાહાકા આપા નાંય જાંઆજે કા પ્રાર્થના કોઅયેહે રીતેથી કોઅરા જોજે, બાકી પવિત્ર આત્મા આપહેહાટી પોતે એહેકેન લાગણી થી વિનાંતી કોઅહે, જીં આપા શબ્દાહા કોય આખી નાંય હોકજે. ");
INSERT INTO gbl_vpl VALUES ("RM8_27","075_8_27","ROM","8","27","27","પોરમેહેર આપહે મોન જાંઅહે કા પવિત્ર આત્મા કાય આખી રીઅલા હેય, કાહાકા પવિત્ર આત્મા પોરમેહેરા ઇચ્છા નુસાર પવિત્ર લોકહાહાટી વિનાંતી કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("RM8_28","075_8_28","ROM","8","28","28","આપા જાંઅજેહે કા જ્યા લોક પોરમેહેરાવોય પ્રેમ કોઅતાહા, ચ્ચાહાહાટી બોદ્યો વાતો મિળીન હારાંજ ઓઅહે, એટલે ચ્ચાહાહાટી જી પોરમેહેરા ઇચ્છા નુસાર પોસંદ કોઅલા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_29","075_8_29","ROM","8","29","29","કાહાકા જ્યાહાલ ચ્યાય પેલ્લેથી નિવડ કોઅયાહાં, ચ્યાહાન પોરમેહેરા પોહા ઈસુ ખ્રિસ્તા હારકા ઓઅરાહાટી પેલ્લેથી નોક્કી કોઅય દેના, કા ઈસુ ખ્રિસ્ત ઓજ પોરમેહેરા પોહહામાય બોદહા કોઅતો મોઠો બાહા ઓઅય. ");
INSERT INTO gbl_vpl VALUES ("RM8_30","075_8_30","ROM","8","30","30","પાછે જ્યાહાલ ચ્યાય પેલ્લેથી નોક્કી કોઅયા, ચ્યાહાન નિવડયાબી, એને જ્યાહાન નિવડયા, ચ્યાહાન ન્યાયી બોનાડ્યા, એને જ્યાહાન ન્યાયી બોનાડ્યા, ચ્યાહાન ચ્યા મહિમાયેમાયબી ભાગીદાર બોનાડ્યા. ");
INSERT INTO gbl_vpl VALUES ("RM8_31","075_8_31","ROM","8","31","31","યે બોદી વાતહેબારામાય આપા કાય આખજે? જો પોરમેહેર આપહેઆરે હેય તે આપહાન કાદાં આરવી નાંય હોકે. ");
INSERT INTO gbl_vpl VALUES ("RM8_32","075_8_32","ROM","8","32","32","પોરમેહેરાય પોતા યોકનેયોક પોહાલ ચ્યાહાટી નાંય રાખ્યો, બાકી ચ્યાય આપહે બોદહાહાટી ચ્યા દુશ્માનાહાલ હોઅપી દેનો, તે તો આપહાન તી બોદા દી જીં ચ્યાય આપહાન વરદાન દાંહાટી વાયદો કોઅલો હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_33","075_8_33","ROM","8","33","33","કાદાબી આપહાન પોરમેહેરા હામ્મે દોષ નાંય લાવી હોકે, કાહાકા પોરમેહેરાય આપહાન ન્યાયી બોનાડલે હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_34","075_8_34","ROM","8","34","34","કાદાજ આપહાન દોષી નાંય ઠોરવી હોકે, કાહાકા ઓ ખ્રિસ્ત ઈસુ હેય જો આપહેહાટી મોઅઇ ગીયો, એને મોઅલા માઅને પાછો જીવતો જાયો, એને આપહેહાટી પોરમેહેરાલ વિનાંતી બી કોઅહે. ");
INSERT INTO gbl_vpl VALUES ("RM8_35","075_8_35","ROM","8","35","35","કાદાબી આપહાન ખ્રિસ્તા પ્રેમા થી આલાગ નાંય કોઅય હોકે, નાંય વિપત્તી, નાંય ચ્યા બોનાડલી બોદી દુનિયા સંકટ, નાંય સતાવણી, નાંય દુકાળ, નાંય ગરીબી, નાંય જોખમ, કા નાંય તલવાર. ");
INSERT INTO gbl_vpl VALUES ("RM8_36","075_8_36","ROM","8","36","36","જેહેકેન પવિત્રશાસ્ત્રમાય લોખલાં હેય, પોરમેહેરાહાટી લોક આમહાન રોજ માઆય ટાકના દમકી દેતહા, એને આમા વાડાહાટી તિયાર કોઅલા ગેટા હારકા ગોણાય જાતહા. ");
INSERT INTO gbl_vpl VALUES ("RM8_37","075_8_37","ROM","8","37","37","બાકી યે બોદી ખારાબ વાતહેમાય પોરમેહેરાકોય જ્યાંય આમહાવોય પ્રેમ કોઅલા હેય, જીત નોક્કી આમહેજ હેય. ");
INSERT INTO gbl_vpl VALUES ("RM8_38","075_8_38","ROM","8","38","38","કાહાકા આંય નોક્કી જાંઅહું, કા નાંય મોરણ, નાંય જીવન, નાંય હોરગા દૂત, નાંય નોરકા દૂત, નાંય વર્તમાન, નાંય ભવિષ્ય, નાંય સામર્થ્ય, ");
INSERT INTO gbl_vpl VALUES ("RM8_39","075_8_39","ROM","8","39","39","નાંય ઉચાઇ, નાંય ઉંડાણ એને નાંય પોરમેહેરાકોય બોનાવલી કાદી બીજી વસ્તુ આપહાન પોરમેહેરા પ્રેમથી આલાગ કોઅય હોકે, જીં આપહાન પ્રભુ ઈસુ ખ્રિસ્તાકોય મિળલા હેય. ");
INSERT INTO gbl_vpl VALUES ("RM9_1","075_9_1","ROM","9","1","1","આંય ખ્રિસ્તમાય હાચ્ચાં આખહુ, એને મા હૃદયબી પવિત્ર આત્મામાય સાક્ષી દેહે, કા આંય જુઠા નાંય બોલું. ");
INSERT INTO gbl_vpl VALUES ("RM9_2","075_9_2","ROM","9","2","2","આંય બોજ નિરાશ હેતાંવ, એને મા યહૂદી જાત્યે લોકહાહાટી બોદો સમય દુઃખી રોતહાવ. ");
INSERT INTO gbl_vpl VALUES ("RM9_3","075_9_3","ROM","9","3","3","કાહાકા મા એહેકેન ઇચ્છા આતી, કા આંય મા યહૂદી બાહહાહાટી જ્યા મા પોતાના કુટુંબ વાળહા ભલાયે માયેવોય હારાપ લેય લાવ, કા આંય ખ્રિસ્તાપાઅને આલાગ ઓઅય જાવ. ");
INSERT INTO gbl_vpl VALUES ("RM9_4","075_9_4","ROM","9","4","4","ચ્યે મા હારકે ઈસરાયેલી લોક હેય, ચ્યાહાન પોરમેહેરાય ગોદ લેદલા પોહહા હારકા નિવડી લેદા, ચ્યાહાન પોરમેહેરાઆરે રોઅના મહિમા મિળી, પોરમેહેરાય ચ્યાહાઆરે કરાર કોઅયા, ચ્યાહાન મૂસા નિયમશાસ્ત્ર દેનો, ચ્યાહાન પોરમેહેરા ભક્તિ કોઅના લાયકે બોનાડ્યા, એને ચ્યાહાઆરે વાયદા કોઅયા. ");
INSERT INTO gbl_vpl VALUES ("RM9_5","075_9_5","ROM","9","5","5","પ્રસિદ્ધ આગલા ડાયાબી એટલે આબ્રાહામ, ઈસાક એને યાકૂબ ચ્યાજ આગલા ડાયા હેય, શરીરા ઇસાબે ઈસુ ખ્રિસ્તાબી ચ્ચાહાજ પેડ્યેમાય જન્મો જાયો, પોરમેહેર બોદહાવોય રાજ્ય કોઅહે, ચ્યા સાદા સ્તુતિ ઓઅતી રોય. આમેન. ");
INSERT INTO gbl_vpl VALUES ("RM9_6","075_9_6","ROM","9","6","6","બાકી એહેકેન નાંય હોમાજના કા પોરમેહેરા વચન પુરાં નાંય ઓઅયા, કાહાકા બોદા ઈસરાયેલી લોક હાચ્ચાં પોરમેહેરા લોક નાંય હેય. ");
INSERT INTO gbl_vpl VALUES ("RM9_7","075_9_7","ROM","9","7","7","એને આબ્રાહામા કુળામાંય જન્મો લેયનાકોય બોદે ચ્યા હાચ્ચેજ પોહેં નાંય બોની જાય, કાહાકા પોરમેહેરાય આબ્રાહામાલ આખ્યાં, “જ્યાહા ઈસાકા કુળામાંય જન્મો જાયહો, ચ્યેજ તો કુળામાઅને માનલે જાય.” ");
INSERT INTO gbl_vpl VALUES ("RM9_8","075_9_8","ROM","9","8","8","જ્યાહા કુદરાતી નુસાર જન્મો ઓઅહે ચ્યે પોરમેહેરા પોહેં નાંય, બાકી જ્યા પોરમેહેરા વાયદાનુસાર જન્મો જાયો ચ્યે હાચ્ચેજ પોહેં આખાયી. ");
INSERT INTO gbl_vpl VALUES ("RM9_9","075_9_9","ROM","9","9","9","કાહાકા વાયદા વચન ઈ હેય, “આંય આગલે વોરહી યે સમયે પાછો યીહીં એને તોવે સારાબી યોક પોહો પૈદા ઓઅરી.” ");
INSERT INTO gbl_vpl VALUES ("RM9_10","075_9_10","ROM","9","10","10","કેવળ ઓલહાંજ નાંય, બાકી આપહે આગલ્યાડાયા ઈસાકાકોય રીપકા બુકામાયબી જુડવા પોહેં પૈદા જા