﻿USE sofia;
DROP TABLE IF EXISTS sofia.gaze_vpl;
CREATE TABLE gaze_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gaze_vpl WRITE;
INSERT INTO gaze_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","ጀልቀበት ዋቅን ሰሚወኒፊ ለፈ ኡሜ። ");
INSERT INTO gaze_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","ለፍት ከን ብፈ ህንቀብኔፊ ዱዋ ቱርቴ፤ ዱከንስ ቱጁበረ ቱሬ፤ ሀፉር ዋቃስ ብሻንረ ሶሶቾአ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","ዋቅንስ፣ “እፍን ሃተኡ” ጄዼ፤ እፍንስ ንተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","ዋቅንስ አከ እፍን ሱን ጋሪ ተኤ አርጌ፤ እፋፊ ዱከነስ ገርገር ባሴ። ");
INSERT INTO gaze_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","ዋቅንስ እፈ ሰናን “ጉያ” ጄዼ፤ ዱከነ ሰናንሞ “ሀልከን” ጄዼ ሞጋሴ። ገልገለስ ተኤ፤ ገነመስ ተኤ፤ ጉያ ቶኮፋ። ");
INSERT INTO gaze_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","ዋቅንስ፣ “ብሻኒፊ ብሻን ገርገር ባሱፍ በንቲን ብሻኖተ ግዱ ሃጅራቱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","ከናፉ ዋቅን በንቲ ቶልቼ ብሻን በንቲ ጀላቲፊ ከን በንቲን ኦሊ ገርገር ባሴ። አከሱመስ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","ዋቅንስ በንቲ ሰነ “ሰሚ” ጄዼ ሞጋሴ። ገልገለስ ተኤ፤ ገነመስ ተኤ፤ ጉያ ለመፋ። ");
INSERT INTO gaze_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","ዋቅንስ፣ “ብሻን ሰሚዻ ገድ ጅሩ እዶ ቶኮት ወልት ሃቀበሙ፤ ለፍት ጎጋንስ ሃሙልአቱ” ጄዼ። አከሱመስ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","ዋቅን ለፈ ጎጋ ሰናን “ለፈ” ጄዼ፤ ብሻንቸ ወልት ቀበሜንሞ “ገላነ” ጄዼ ሞጋሴ። ዋቅንስ ወን ኩን አከ ጋሪ ተኤ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","አመስ ዋቅን፣ “ለፍት ብቅልቱወን ሃባስቱ፤ ብቅልቱወን አኩመ ጎሰ ጎሰሳኒት ሰኚ ባሰን፣ ሙኬን እጀ ኬነኒ እጅሳኒሞ ሰኚ ኦፍ ኬሳ ቀቡ አዱመ አዳን አኩመ ጎሰ ጎሰሳኒት ለፈረት ሃአርገመን” ጄዼ። አከሱመስ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","ለፍትስ ብቅልቱ አኩመ ጎሰሳት ሰኚ ባሱ፣ ሙከ እጀ ኬኑ፣ ከን እጅሳስ ሰኚ ኦፍ ኬሳ ቀቡ አዱመ አዳን አኩመ ጎሰሳት ባስቴ። ዋቅንስ ወን ኩን አከ ጋሪ ተኤ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","ገልገለስ ተኤ፤ ገነመስ ተኤ፤ ጉያ ሰደፋ። ");
INSERT INTO gaze_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","ዋቅንስ አከነ ጄዼ፤ “ጉያፊ ሀልከን ገርገር ባሱፍ በንቲ ሰሚረት እፈወን ሃተአን፤ እሳንስ መለቶወን ወቅቲሌን፣ ጉዮትኒፊ ወጎትን እቲን ቤከመን ሃተአን፤ ");
INSERT INTO gaze_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","እሳንስ እፈወን በንቲ ሰሚራ ከን ለፋፍ እፈ ኬነን ሃተአን።” አከሱመስ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","ዋቅን እፈ ጉርጉዳ ለመ ኡሜ፤ ኩንስ አከ እፍን ጉዳን ጉያ፣ እን ጥናንሞ ሀልከን ሞኡፍ። አከሱመ ኡርጂወንሌ ኡሜ። ");
INSERT INTO gaze_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","ዋቅንስ አከ እሳን ለፋፍ እፈ ኬነኒፍ በንቲ ሰሚረ እሳን ካኤ፤ ");
INSERT INTO gaze_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","ኩንስ አከ እሳን ጉያፊ ሀልከን ሞአኒፊ አከ እፈ ሰነ ዱከነራ ገርገር ባሰኒፍ። ዋቅንስ ወን ኩን አከ ጋሪ ተኤ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","ገልገለስ ተኤ፤ ገነመስ ተኤ፤ ጉያ አፉረፋ። ");
INSERT INTO gaze_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","ዋቅንስ፣ “ብሻን ኡመመወን ሉቡ ቀቤዪ ሙኙቀኒን ሃጉተሙ፤ ስምብሮትንስ ለፋ ኦልት፣ በንቲ ሰሚ ኬሰ ሃበርሰን” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","ከናፉ ዋቅን ኡመመወን ገላና ጉርጉዳ፣ ሉቡ ቀቤዪ ሙኙቀን ከኔን ገላነ ኬሰ ጅራተን ሁንዳፊ ስምብሮተ ቆቾ ቀበን ሁንደ አኩመ ጎሰሳኒት ኡሜ። ዋቅንስ ወን ኩን አከ ጋሪ ተኤ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","ዋቅንስ፣ “ሆራ፤ ባይአዻ፤ ብሻን ገላኖታስ ጉታ፤ ስምብሮትንስ ለፈረት ሃባይአተን” ጄዼ እሳን ኤብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","ገልገለስ ተኤ፤ ገነመስ ተኤ፤ ጉያ ሸነፋ። ");
INSERT INTO gaze_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","ዋቅንስ፣ “ለፍት አኩመ ጎሰ ጎሰሳኒት ኡመመወን ሉቡ ቀቤዪ ጄቹንስ ሆሪ፣ ኡመመወን ለፈረ ሙሙኙቀን፣ ብኔንሶተ አኩመ ጎሰ ጎሰሳኒት ሃኬንቱ” ጄዼ። አከሱመስ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","ዋቅን ብኔንሶተ አኩመ ጎሰ ጎሰሳኒት፣ ሆሪ አኩመ ጎሰ ጎሰሳኒት፣ ኡመመወን ለፈረ ሙሙኙቀንስ አኩመ ጎሰ ጎሰሳኒት ኡሜ። ዋቅን ወን ኩን አከ ጋሪ ተኤ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","ዋቅንስ፣ “ኮታ አከ ብፈኬኛት፣ አከ ፈኬኘኬኛትስ ነመ ኡምና፤ እሳንስ ቁርጡሚ ገላናረት፣ ስምብሮ ሰሚረት፣ ሆሪረት፣ ለፈ ሁንዱማፊ ኡመመወን ለፈረ ሙኙቀን ሁንዱማረት ኣንጎ ሃቀባተን” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","ከናፉ ዋቅን አከ ብፈሳት ነመ ኡሜ፤ አከ ብፈ ዋቃት እሰ ኡሜ፤ እንስ ዺራፊ ዱበርቲ ታስሴ እሳን ኡሜ። ");
INSERT INTO gaze_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","ዋቅንስ እሳን ኤብሴ፣ “ሆራ፣ ባይአዻስ፤ ለፈ ጉታቲ ሀርከኬሰን ጀለትስ ቡልፈዻ። ቁርጡሚ ገላናረት፣ ስምብሮተ ሰሚረት፣ ኡመመ ለፈረ ሙኙቁ ሁንደረት ኣንጎ ቀባዻ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","ኤርገሲ ዋቅን አከነ ጄዼ፤ “ኩኖ አን አከ እሳን ኛተ እስኒ ተአኒፍ ብቅልቱ ለፈ ሁንደረት ሰኚ ኬኑ ሁንዳፊ ሙከ እጅሳ ሰኚ ኦፍ ኬሳ ቀቡ ጎሰ ሁንደ እስኒ ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","አንስ ብኔንሰ ለፋ ሁንዳፍ፣ ስምብሮተ ሰሚ ሁንዳፍ፣ ኡመመ ለፈረ ሙኙቁ ሁንዳፍ ጄቹንስ ዋን ሀፉረ ጅሬኛ ኦፍ ኬሳ ቀቡ ሁንዳፍ አከ ኛተሳኒ ተኡፍ ብቅልቱ ለልሳ ሁንደ ነንኬነ።” አከሱመስ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","ዋቅንስ ዋን ሆጄቴ ሁንደ እላሌ፤ ወን ሱንስ ዹጉማን ጋሪ ቱሬ። ገልገለስ ተኤ፤ ገነመስ ተኤ፤ ጉያ ጀአፋ። ");
INSERT INTO gaze_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","ኡመምን ሰሚቲፊ ለፋ፣ ከን ዋን እሳን ኬሰ ጅሩ ሁንዳስ ሃለ ከናን ጡሙረሜ። ");
INSERT INTO gaze_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","ዋቅን ሆጂ ሆጄቻ ቱሬ ሁንደ ጉያ ቶርበፋት ፍጤ፤ ከናፉ እን ጉያ ቶርበፋት ሆጂሳ ሁንዱማራ ቦቆቴ። ");
INSERT INTO gaze_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","ዋቅን ሰበቢ ጋፈ ሰነ ሆጂ ዋ ኡሙ ከን ሆጄቻ ቱሬ ሁንደራ ቦቆቴፍ ጉያ ቶርበፋ ኤብሴ ቁልቁሌሴ። ");
INSERT INTO gaze_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","ሴናን ሰሚወኒቲፊ ለፋ ከን ዬሮ እሳን ኡመመኒ፣ ዬሮ ዋቀዮ ዋቅን ለፋፊ ሰሚወን ኡሜ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","ሰበቢ ዋቀዮ ዋቅን ቦካ ህንሮብስኒፍ፣ ነምን ለፈ ቆቱስ ዋን ህንጅራትኒፍ መርግ ቶኮዩ ለፈረት ህንሙልአትኔ፤ ብቅልቱንስ ለፈ ቆቲሳረት ህንብቅሌ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","ገሩ ብሻን ለፈ ኬሳ ቡርቄ ለፈ ሁንደ ኦባሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","ዋቀዮ ዋቅን ብዮ ለፋራ ነመ ቶልቼ፤ ሀፉረ ጅሬኛስ ፉኛንሳት ባፈቴ፤ ነምንስ ኡመመ ጅራታ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","ዋቀዮ ዋቅንስ ኤዴን ኬሰት ገመ በአ ቢፍቱት እዶ ብቅልቱ ቆጴሴ፤ ነመ ቶልቼ ሰነስ አች ኬሰ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","ዋቀዮ ዋቅን ሙኬን ጎሰ ሁንዳ ለፈ ኬሳ ብቅልቼ፤ እን ሙኬን እጀ ነማት ቶለኒፊ ኛታፍስ ጋሪ ተአን ብቅልቼ። እዶ ብቅልቱ ሰነ ኬሰስ ሙከ ጅሬኛቲፊ ሙከ ዋን ጋሪፊ ዋን ሀማ ነመ ቤክስሱቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","ለግን እዶ ብቅልቱ ሰነ ኦባሱ ቶኮስ ኤዴን ኬሳ ቡርቀ ቱሬ፤ ለግን ሱን ኤዴኒ ከኤ ገርገር በኤ ለገ አፉር ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","መቃን ለገ ቶኮፋ ጲሾን፤ እንስ ጉቱማ ብየ ሀዊላ፣ እዶ ወርቄን ጅሩት ናነኤ ያአ። ");
INSERT INTO gaze_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","ወርቄን ብየ ሰና ጋሪዸ፤ ሀጴን ኡርጋኡፊ ሰርዶንክሲን አችት አርገሙ። ");
INSERT INTO gaze_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","መቃን እሰ ለመፋ ጊሆን፤ እንስ ጉቱማ ለፈ እቶጵያት ናነኤ ያአ። ");
INSERT INTO gaze_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","መቃን ለገ ሰደፋ ጤግሮስ፤ እንስ ከራ በአ ቢፍቱቲን አሶር ጭነ ያአ። ለግን አፉረፋንሞ ኤፍራጢስ ጄዸመ። ");
INSERT INTO gaze_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","ዋቀዮ ዋቅን አከ እን እሰ ምሶምሱፊ አከ እን እሰ ኤጉፍ ጄዼ ነመ ፉዼ እዶ ብቅልቱ ኤዴን ኬሰ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","ዋቀዮ ዋቅንስ አከነ ጄዼ ነመ አጀጄ፤ “ሙከ እዶ ብቅልቱ ከነ ኬሰ ጅሩ ሁንደራ ኛቹ ንደንዴሰ፤ ");
INSERT INTO gaze_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","ገሩ ሙከ ዋን ጋሪፊ ዋን ሀማ ነመ ቤክስሱ ሰነራ ህንኛትን፤ ጋፈ እሰራ ኛቴ ዹጉማን ንዱታቲ።” ");
INSERT INTO gaze_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","ዋቀዮ ዋቅን፣ “ነምን ኮጳሳ ተኡን ጋሪ ምት፤ ገርጋርቱ እሰት ቶልቱ ነንቶልቻፍ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","ዋቀዮ ዋቅንስ ብኔንሳፊ ስምብሮተ ሰሚ ሁንዱማ ለፈራ ቶልቼ። መቃ እን እሳኒፍ ባሱ እላሉፍ ጄዼስ ገረ ነምቻት እሳን ፍዴ፤ ወን ነምች ሱን ቶኮ ቶኮ ኡመመወን ሉቡ ቀቤዪ እቲን ዋሜ ከምዩ መቃ ተኤፍ። ");
INSERT INTO gaze_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","ነምች ሱንስ ሆሪ ቄኤ ሁንዳፍ፣ ስምብሮተ ሰሚ ሁንዳፍ፣ ብኔንሰ ሁንዳፍ መቃ ባሴ። አዳሚፍ ገሩ ገርጋርቱን እሰት ቶልቱ ህንአርገምኔ። ");
INSERT INTO gaze_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","ከናፍስ ዋቀዮ ዋቅን አከ ነምች ህርባን ኦፍ ወላሉ ጎዼ፤ ኡቱመ እን ረፋ ጅሩ ለፌ ጭናቸሳ ኬሳ ቶኮ ፉዼ እዶ ሰነ ፎኒን ዱቼ። ");
INSERT INTO gaze_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","ዋቀዮ ዋቅን ለፌ ጭናቻ ከን ነምቸ ኬሳ ፉዼ ሰነራ ዱበርቲ ቶልቼ ገረ ነምቻት ጌሴ። ");
INSERT INTO gaze_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","ነምችስ አከነ ጄዼ፤ “ኤጋ ለፌን ኩን ለፌ ለፌኮቲት፤ ፎን ኩንስ ፎን ፎንኮቲት፤ እሼን ዋን ዺረራ አርገምቴፍ ‘ዱበርቲ’ ጄዸምት።” ");
INSERT INTO gaze_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","ከናፉ ነምን አባፊ ሃዸሳ ንዺሰ፤ ኒቲሳት ንመጠነ፤ እሳንስ ፎን ቶኮ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","ነምቺፊ ኒቲንሳ ቁላሳኒ ቱረን፤ ገሩ ወል ህንቃነአን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","ብኔንሰ ዋቀዮ ዋቅን ኡሜ ሁንደ ኬሳ ቦፍት ሀጤ ቱሬ። ዱበርትቲዻንስ፣ “ዹጉመ ዋቅን፣ ‘ሙከ እዶ ብቅልቱ ኬሰ ጅሩ ከም እራዩ ህንኛትና’ እስኒን ጄዼራ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","ዱበርትቲንስ ዴብፍቴ ቦፈ ሰናን አከነ ጄቴ፤ “እጀ ሙኬን እዶ ብቅልቱ ኬሰ ጅረኒ ኛቹ ንደንዴኘ፤ ");
INSERT INTO gaze_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ገሩ ዋቅን፣ ‘ሙከ ወለካ እዶ ብቅልቱ ሰና ኬሰ ጅሩራ እጀ ህንኛትና፤ እትስ ህንቡእና፤ ዮ ከና አቺ ንዱቱ’ ጄዼረ።” ");
INSERT INTO gaze_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","ቦፍችስ ዴብሴ ዱበርትቲዻን አከነ ጄዼ፤ “እስን ዹጉማን ህንዱተን። ");
INSERT INTO gaze_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","ዋቅን አከ ዮሙ እስን እጀ ሙክቻ ኛተን እጅኬሰን በነሙ፣ አከ እስን ዋን ጋሪፊ ዋን ሀማ ቤኩዻን አከ ዋቃ ታተን ንቤካቲ።” ");
INSERT INTO gaze_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","ዱበርትቲንስ ዮሙ አከ እጅ ሙክቻ ኛታፍ ጋሪ፣ ከን እጀ ነማት ቶሉ፣ ኦጉማ አርገቹፍስ አከ ነመ ጎጆማስሱ አርግቴት ፉዸቴ ኛቴ። ዽርስሼስ እሼ ወጅን ቱሬ፤ እሳፍስ ንላቴ፤ እንስ ንኛቴ። ");
INSERT INTO gaze_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","እጅ ለቸንሳኒስ ንበነሜ፤ ቁላ ሀፉሳኒስ ቤከን፤ ከናፍስ ባለ ሀርቡ ሆዸኒ መርጦ ቶልፈተን። ");
INSERT INTO gaze_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","አኩመ አዱን ቀበኖፍቴንስ ነምቺፊ ኒቲንሳ ኡቱ ዋቀዮ ዋቅን እዶ ብቅልቱ ሰነ ኬሰ ዴሙ ሰገሌሳ ዸገአን፤ እሳንስ ሙኬን እዶ ብቅልቱ ኬሰ ዋቀዮ ዋቀ ዱራ ዾከተን። ");
INSERT INTO gaze_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","ዋቀዮ ዋቅን ገሩ ነምቸ ዋሜ፣ “አት ኤሰ ጅርተ?” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","ነምችስ ዴብሴ፣ “አን ኡቱ አት እዶ ብቅልቱ ኬሰ ዴምቱ ነንዸገኤ፤ ዋን ቁላኮ ቱሬፍስ ነንሶዳዼ፤ ነንዾከዼስ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","እንስ፣ “ኤኙቱ አከ አት ቁላ ታቴ ስት ህሜ? ሙከ አን እጀሳ ህንኛትን ጄዼ ስ አጀጄ ሰነራ ኛቴ ሞ?” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","ነምችስ፣ “ዱበርትቲ አት አከ እሼን ነ ወጅን ጅራቱፍ ና ኬንቴ ሰነቱ እጀ ሙክቻራ ና ኬኔ፤ አንስ ነንኛዼ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","ዋቀዮ ዋቅንስ ዱበርትቲዻን፣ “ወን አት ሆጄቴ ኩን ማል?” ጄዼ። ዱበርትቲንሞ፣ “ቦፍት ነ ጎዎምስናነን ኛዼ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","ከናፉ ዋቀዮ ዋቅን ቦፍቻን አከነ ጄዼ፤ “አት ሰበቢ ዋን ከነ ጎቴፍ፣ “ሆሪ ሁንዱማ ኬሳ፣ ብኔንሰ ሁንዱማ ኬሳስ ከን አባረምቴ ንታተ! በረ ጅሬኘኬቲ ጉቱ ገራኬቲን ለፈረ ሎተ፤ ብዮሌ ንኛተ። ");
INSERT INTO gaze_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","ስኢፊ ዱበርትቲ፣ ሰኚኬቲፊ ሰኚሼ ግዱት ዲኑማ ነንኡመ፤ እን መታኬ ንቱመ፤ አትስ ኮሜሳ ንእድተ።” ");
INSERT INTO gaze_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","ዱበርትቲዻንስ አከነ ጄዼ፤ “ዮሙ አት ሙጫ ዴሱት አን ዽጵነኬ አከ መሌ ነንባይእሰ፤ ጭኒንሱዻንስ እጆሌ ንዴሰ። ፌዺንኬ ገሩመ ዽርሰኬቲ ተአ፤ እንስ ስረት ኦል ኣንቱማ ቀባተ።” ");
INSERT INTO gaze_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","አዳሚንሞ አከነ ጄዼ፤ “ዋን አት ዱቢ ኒቲኬቲ ዸጌሴ ሙከ አን እጀሳራ፣ ‘ህንኛትን’ ጄዼራ ኛቴፍ፣ “ለፍት ሰበቢኬቲፍ ከን አባረምቴ ታት፤ አትስ በረ ጅሬኘኬቲ ጉቱ ደዸቢዻን እሼራ ኛተ። ");
INSERT INTO gaze_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","እሼን ቆራቲፊ ሶኮሩ ስት ብቅልችት፤ አትስ ብቅልቱ ለፋ ንኛተ። ");
INSERT INTO gaze_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","አት ዋን ለፈራ አርገምቴፍ፣ ሀመ ለፈት ዴብቱት ደፍቀ ፉለኬቲቲን ቡዴነ ኛተ፤ ዋን ብዮ ታቴፍስ፣ ገረ ብዮት ዴብተ።” ");
INSERT INTO gaze_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","አዳምስ ሰበቢ እሼን ሃዸ ጅራቶ ሁንዳ ታቴፍ ኒቲሳ “ሄዋን” ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","ዋቀዮ ዋቅን አዳሚፊ ሄዋኒፍ ጎጋራ ኡፈተ ሆጄቴ እሳንት ኡፍሴ። ");
INSERT INTO gaze_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","ዋቀዮ ዋቅንስ፣ “ኩኖ ነምን ዋን ጋሪፊ ዋን ሀማ ቤኩዻን ኑ ኬሳ አከ እሰ ቶኮ ተኤረ። አመስ ሀርከሳ ሂጠቴ፣ እጀ ሙከ ጅሬኛ ጭረቴ ኛቹን፣ በረ በራንስ ጅራቹን እሳፍ ኤየመሙ ህንቀቡ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","ከናፉ ዋቀዮ ዋቅን ለፈ ብቅልቱ ኤዴን ኬሳ ነምቸ ባሴ አከ እን ለፉመ እራ አርገሜ ሰነ ምሶምሱ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","ኤርገ ነመ አቺ ባሴ ቦዴ ከራ ሙከ ጅሬኛት ጌሱ ኤግስሱፍ ጄዼ ኪሩቤሎታፊ ጎራዴ ቦበኡ ከን አሲፊ አች ገገረገሉ ቶኮ እዶ ብቅልቱ ኤዴኒቲን ገመ በአ ቢፍቱ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","አዳም ኒቲሳ ሄዋን ብረ ገኤ፤ እሼንስ ኡልፎፍቴ ቃይንን ዴሴ። እሼንስ፣ “አን ገርጋርሰ ዋቀዮቲን እልመ ቶኮ አርገዼረ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","እት ኣንስቴስ ኦቦሌሰሳ አቤልን ዴሴ። አቤል ትክሴ ሆሎታ ቱሬ፤ ቃይንሞ ለፈ ቆተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","ዬሮ ሙራሰ ኬሰት ቃይን ዋን ለፍት ባፍቴፍ ኬሳ ዋቀዮፍ ኣርሳ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","አቤልሞ ሀንገፎተ ሆሎተሳ ኬሳ ጮመ ጮመሳ ዽኤሴ። ዋቀዮ ፋረ ቶላዻን ገረ አቤሊፊ ገረ ኣርሳ እን ዽኤሴ ሰና እላሌ። ");
INSERT INTO gaze_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","ገረ ቃይኒፊ ገረ ኣርሳሳ ገሩ ህንእላሌ። ከናፉ ቃይን አከ መሌ ኣሬ ፉልሳ ጉራቸኤ። ");
INSERT INTO gaze_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","ዋቀዮስ ቃይኒን አከነ ጄዼ፤ “አት ማሊፍ ኣርቴ? ፉልኬስ ማሊፍ ጉራቸኤ? ");
INSERT INTO gaze_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","ኡቱ ዋን ቀጄላ ሆጄቴ ስላ አት ፉዸተመ አርገተ ምቲ? ገሩ ዮ ዋን ቀጄላ ሆጄቹ ባቴ ጩቡን በልበለኬ ዱረት ርጴ ስ ኤገተ፤ ስ ቀበቹ በርባደስ፤ አት ገሩ እሰ ሞአቹ ቀብደ።” ");
INSERT INTO gaze_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","ቃይንስ ኤርገሲ ኦቦሌሰሳ አቤሊን፣ “ኮቱ ሜ ድሬት ባና” ጄዼ። ኡቱመ ድሬረ ጅረኑስ ቃይን ኦቦሌሰሳ አቤልት ከኤ እሰ አጄሴ። ");
INSERT INTO gaze_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","ዋቀዮስ፣ “ኦቦሌስኬ አቤል ኤሰ ጅረ?” ጄዼ ቃይን ጋፈቴ። ቃይንሞ፣ “አን ህንቤኩ፤ አን ኤግዱ ኦቦሌሰኮቲቲ?” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","ዋቀዮ አከነ ጄዼ፤ “አት ማል ጎቴ? ዺግን ኦቦሌሰኬቲ ለፋ ነት እያ ጅረ። ");
INSERT INTO gaze_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","አት አመ አባረማዸ፤ ለፈ ዺገ ኦቦሌሰኬቲ ስ ሀርካ ፉዸቹፍ አፋን በነቴራስ ንአርአምተ። ");
INSERT INTO gaze_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","ዬሮ አት ለፈ ቆተቱት ለፍት ዴብቴ ምዻን ሲፍ ህንኬንቱ። አት ለፈረት ጆርቱ ቦቆና ህንቀብኔ ታተ።” ");
INSERT INTO gaze_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","ቃይንሞ ዋቀዮን አከነ ጄዼ፤ “አደበሙንኮ ዋን አን ባቹ ደንደኡን ኦል። ");
INSERT INTO gaze_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","ኩኖ አት ሀርአ ብያ ነ አርኣ ጅርተ፤ አንስ ፉለኬ ዱራ ነንዾከዸ፤ ለፈረት ጆርቱ ቦቆና ህንቀብኔ ነንተአ፤ ነምን ነ አርገቱ ከምዩስ ነ አጄሰ።” ");
INSERT INTO gaze_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","ዋቀዮ ገሩ፣ “አከነ ምት፤ ነምን ቃይንን አጄሱ ከምዩ ደቻ ቶርበ ሃሎ ባፈመ” ጄዼን። ዋቀዮስ አከ ነምን እሰ አርገቱ ቶኮዩ እሰ ህንአጄፍኔፍ ቃይንት መለቶ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","ኤርገሲስ ቃይን ፉለ ዋቀዮ ዱራ በኤ ኤዴንራ ከራ በአ ቢፍቱቲን ብየ ኖድ ኬሰ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","ቃይን ኒቲሳ ቤኬ፤ እሼንስ ኡልፎፍቴ ሄኖክን ዴሴ። ቃይንስ መጋላ ቶኮ ሁንዴሴ፤ መጋላ ሰነስ ሄኖክ ጄዼ መቃ እልመሳቲን ዋሜ። ");
INSERT INTO gaze_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","ሄኖክ ኢራድን ዸልቼ፤ ኢራድ ሜኤልን ዸልቼ፤ ሜሁያኤል መቱሳኤልን ዸልቼ፤ መቱሳኤልሞ ላሜህን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","ላሜህ ዱበርቶተ መቃንሳኒ ኣዳፊ ጢላ ጄዸሙ ለማን ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","ኣዳን ያባልን ዴሴ፤ ያባልስ አባ ወረ ዱንካነ ኬሰ ጅራተኒ ሆሪ ሆርሲሰኒ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","መቃን ኦቦሌሰሳ ዩባል ቱሬ፤ እንሞ አባ ወረ ክራረ ሩኩተኒቲፊ ኡሉሌ አፉፈኒት። ");
INSERT INTO gaze_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","ጢላንሞ እልመ ቱባል ቃይን ጄዸሙ ከን ናሲፊ ስቢለ ቱሜ ሜሻወን ገራ ገራ ሆጄቱ ዴሴ፤ ኦቦሌቲን ቱባል ቃይንስ ነአማ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","ላሜህ ኒቶተሳቲን አከነ ጄዼ፤ “ኣዳፊ ጢላን ነ ዸገኣ፤ ያ ኒቶተ ላሜሂ ዱቢኮ ዸጌፈዻ። ነመ ቶኮ ዋን እን ነ መዴሴፍ፣ ደርገጌሰ ቶኮ ዋን እን ነ ሚዼፍ አን እሰ አጄሴረ። ");
INSERT INTO gaze_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","ዮ ቃይኒፍ ደቻ ቶርበ ሃሎን ባፈሜ ላሜሂፍሞ ደቻ ቶርባተሚ ቶርበ ንባፈመ።” ");
INSERT INTO gaze_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","አዳም አመስ ኒቲሳ ቤኬ፤ እሼንስ እልመ ዴሴ፤ መቃሳስ፣ “ኤርገ ቃይን አቤልን አጄሴ አስ ዋቅን እዶ አቤል ዳእመ ብራ ና ኬኔረ” ጄቴ “ሴት” ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","ሴቲፍስ እልም ንዸለቴ፤ እንስ ኤኖሽ ጄዼ እሰ ሞጋሴ። በረ ሰነ ነሞትን መቃ ዋቀዮ ዋመቹ ጀልቀበን። ");
INSERT INTO gaze_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","ኩን ገልሜ ሰኚ አዳም። ዋቅን ዬሮ ነመ ኡሜት አከ ፈኬኘ ዋቃት እሰ ቶልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","እንስ ዺራፊ ዱበርቲ ታስሴ እሳን ኡሜ፤ እሳን ኤብሴስ። ዬሮ ኡመመንስ “ነመ” ጄዼ እሳን ዋሜ። ");
INSERT INTO gaze_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","አዳም ወጋ 130 ጅራቴ፤ እንስ አከ ፈካቲሳት፣ አከ ብፈ እሳትስ እልመ ዸልቼ ሴት ጄዼ መቃ ባሴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","አዳም ኤርገ ሴት ዸለቴ ቦዴ ወጋ 800 ጅራቴ፤ እንስ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","ወሉመት አዳም ወጋ 930 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","ሴት ወጋ 105 ጅራቴ ኤኖሽን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","ኤርገ ኤኖሽን ዸልቼ ቦዴስ ሴት ወጋ 807 ጅራቴ፤ እንስ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","ወሉመት ሴት ወጋ 912 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","ኤኖሽ ወጋ 90 ጅራቴ ቄናንን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","ኤርገ ቄናንን ዸልቼ ቦዴስ ኤኖሽ ወጋ 815 ጅራቴ፤ እንስ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","ወሉመት ኤኖሽ ወጋ 905 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","ቄናን ወጋ 70 ጅራቴ መሀለሌሊን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","ኤርገ መሀለሌሊን ዸልቼ ቦዴ ቄናን ወጋ 840 ጅራቴ፤ እንስ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","ወሉመት ቄናን ወጋ 910 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","መሀለሌል ወጋ 65 ጅራቴ ያሬድን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","ኤርገ ያሬድን ዸልቼ ቦዴ መሀለሌል ወጋ 830 ጅራቴ፤ እንስ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","ወሉመት መሀለሌል ወጋ 895 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","ያሬድ ወጋ 162 ጅራቴ ሄኖክን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","ኤርገ ሄኖክን ዸልቼ ቦዴ ያሬድ ወጋ 800 ጅራቴ፤ እንስ እልማኒፊ እንተለን ብራ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","ወሉመት ያሬድ ወጋ 962 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","ሄኖክ ወጋ 65 ጅራቴ መቱሴላ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","ሄኖክ ኤርገ መቱሴላ ዸልቼ ቦዴ ወጋ 300 ዋቀ ወጅን ዴዴብኤ፤ እንስ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","ወሉመት ሄኖክ ወጋ 365 ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","ሄኖክ ዋቀ ወጅን ዴዴብኤ፤ ዋን ዋቅን እሰ ፉዸቴፍ እን ዴብኤ ህንአርገምኔ። ");
INSERT INTO gaze_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","መቱሴላን ወጋ 187 ጅራቴ ላሜህን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","ኤርገ ላሜህን ዸልቼ ቦዴ መቱሴላን ወጋ 782 ጅራቴ፤ እንስ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","ወሉመት መቱሴላን ወጋ 969 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","ላሜህ ወጋ 182 ጅራቴ እልመ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","እንስ፣ “ሆጂ ኑ ለፈ ዋቀዮ አባሬ ከነረት ሆጄትኑፊ ደዸቢ ሀርከኬኛ ከነ ኬሰት ኑ ጀጀቤሰ” ጄቹዻን መቃሳ ኖህ ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","ላሜህ ኤርገ ኖህን ዸልቼ ቦዴ ወጋ 595 ጅራቴ፤ እንስ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","ወሉመት ላሜህ 777 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","ኖህ ኤርገ ወጋ 500 ጅራቴ ቦዴ ሴም፣ ሃሚፊ ያፌትን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","ዬሮ ነሞትን ብየ ለፋረት ባይአቹ ጀልቀበኒ እንተለን ዸለተኒፍት፣ ");
INSERT INTO gaze_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","እልማን ዋቃ አከ እንተለን ነሞታ በበሬዶ ተአን አርገን፤ እሳን ኬሳስ አቡመ ፍለተን ፉዸን። ");
INSERT INTO gaze_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","ዮሙስ ዋቀዮ፣ “ነምን ዋን ፎን ተኤፍ ሀፉርኮ በረ በራን እሰ ኬሰ ህንጅራቱ፤ በር ጅሬኘሳስ ወጋ ዽበ ቶኮፊ ድግደመ ተአ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","በረ ሰናፊ ኤርገሲስ ኔፊሊሞትን ለፈረ ቱረን፤ እልማን ዋቃስ ዮሙ ገረ እንተለን ነማ ዸቀንት እጆሌ ዸልቸን። እሳንስ ጎቶተ ዱሪ ወረ ቤከሞ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","ዋቀዮስ አከ ጀልእን ነማ ለፈረት ባይአቴ፣ ወን ነምን ዬሮ ሁንደ ገራሳት ያዱ ሁንድኑስ ጀልኣ ቆፈ ተኤ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","ዋቀዮስ ዋን ለፈረት ነመ ኡሜፍ ንጋቤ፤ ገራንሳስ ንገዴ። ");
INSERT INTO gaze_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","ከናፉ ዋቀዮ፣ “አን ሰኚ ነማ ከን ኦፊኮቲን ኡሜ ለፈራ ነንበሌሰ። ነማፊ ሆሪ፣ ኡመመ ለፈረ ሙኙቁ፣ ስምብሮተ ሰሚ ነንበሌሰ፤ አን እሳን ኡሙኮት ጋቤራቲ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","ኖህ ገሩ ፉለ ዋቀዮ ዱረት ሱራ አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","ሴናን ኖሂፊ ማቲሳ ከናዸ። ኖህ ነሞተ በረሳ ቱረን ግዱት ነመ ቀጄላ፣ ነመ ህርእነ ህንቀብኔ ከን ዋቀ ወጅን ዴዴብኡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","ኖህ እልማን ሰዲ ዸልቼ፤ እሳንስ፦ ሴም፣ ሃሚፊ ያፌት። ");
INSERT INTO gaze_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","ለፍት ፉለ ዋቃ ዱረት ፋለምቴ ጄቁምሳን ጉተምቴ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","ሰበቢ ነሞትን ለፈራ ሁንድኑ ከራሳኒ ፋለኒፍ፣ ዋቅን አከ ለፍት ፋለምቴ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","ከናፉ ዋቅን ኖሂን አከነ ጄዼ፤ “ዋን ለፍት ሰበቢሳኒቲን ጄቁምሳን ጉተምቴፍ፣ አን ነመ ሁንደ ነንበሌሰ፤ ኩኖ አን ዹጉማን ለፋፊ እሳን ነንበርበዴሰ። ");
INSERT INTO gaze_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","አት ሙከ ጎፈርራ ዶኒ ቶልፈዹ፤ ኬሰ እሳትስ ኩታ ገራ ገራ ቆጴስ፤ ኬሳፊ ዱበሳስ ሀጴዻን ዱች። ");
INSERT INTO gaze_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","ሃል አት እቲን ዶንቸ ቶልችቱ ከናዸ፤ ዼርነሳ ዹንዹመ ዽባ ሰዲ፣ በልእነሳ ዹንዹመ ሸንተመ፣ ኦል ዼርነሳ ዹንዹመ ሶዶመ ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","ዶንቻፍ በንቲ ዹንዹመ ቶኮ ኦል ከኡ ሆጄዹ፤ ጭናቸሳረትስ በልበለ ባስ፤ ከነስ አባ ደርቢ ሰዲ ጄቹንስ ከን ገዲ፣ ከን ግዱቲፊ ከን ጉባ ጎዺ ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","ኩኖ፣ አን ኡመመወን ሉቡ ቀቤዪ ሁንደ ሰሚ ጀላ በሌሱፍ ብሻን በዲሳ ለፈት ነንፍደ፤ ወን ለፈረ ጅራቱ ሁንድኑስ ንበደ። ");
INSERT INTO gaze_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","ስ ወጅን ገሩ ከኩ ነንገለ፤ አትስ ዶኒ ሴንተ፤ አቲፊ እልማንኬ፣ ኒቲንኬቲፊ ኒቶትን እልማንኬቲስ ንሴንቱ። ");
INSERT INTO gaze_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","ኡመመወን ሉቡ ቀቤዪ ሁንዱማ ኬሳ አከ እሳን ስ ወጅን ጅራተኒፍ ለመ ለመ፣ ኮርማፊ ዸላ ዶንቸት ገልች። ");
INSERT INTO gaze_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","ስምብሮተ ኬሳ አኩመ ጎሰ ጎሰሳኒት፣ ሆሪ ኬሳ አኩመ ጎሰ ጎሰሳኒት፣ ኡመመወን ለፈረ ሙኙቀን ኬሳስ አኩመ ጎሰ ጎሰሳኒት፣ ለመ ለመ ተአኒ ጅራቹፍ ገረኬ ዹፉ። ");
INSERT INTO gaze_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","ዋን ኛተሙ ሁንደ ኬሳ ዋ ፉዺ ኦፍ ብረት ወልት ቀብ! ኩንስ ኛተኬቲፊ ኛተሳኒ ንተአ።” ");
INSERT INTO gaze_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","ኖህ አኩመ ዋቅን እሰ አጀጄት ዋን ሁንደ ሆጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","ዋቀዮስ ኖሂን አከነ ጄዼ፤ “አን አከ አት ዸሎተ ከነ ኬሳ ነ ዱረት ቀጄላ ታቴ አርጌራቲ ማቲኬ ሁንዱማ ወጅን ዶንቸ ሴን። ");
INSERT INTO gaze_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","ብኔንሰ ቁልቁሉ ጎሰ ሁንደ ኬሳ ኮርማፊ ዸላ ጭምዲ ቶርበ፣ ብኔንሰ ቁልቁሉ ህንተእን ጎሰ ሁንደ ኬሳ ጭምዲ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","ጎሰ ስምብሮታ ሁንደ ኬሳሌ አከ ሰኚን ለፈ ሁንደረት ሀፌ ጅራቱፍ ኮርማፊ ዸላ ጭምዲ ቶርበ ፉዸዹ ሴን። ");
INSERT INTO gaze_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","አን ጉያ ቶርበ ቦዴ ሀልከን አፉርተማፊ ጉያ አፉርተመ ቦካ ነንሮብሰ፤ ኡመመ ጅራታ አን መታንኮ ኡሜ ሁንደ ለፈራ ነንሀጣአ።” ");
INSERT INTO gaze_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","ኖህስ ዋን ዋቀዮ እሰ አጀጄ ሁንደ ንሆጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","ዬሮ ብሻን በዲሳ ዹፌት ኖህ ነመ ወጋ ዽበ ጀአ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","ኖሂፊ እልማንሳ፣ ኒቲሳቲፊ ኒቶትን እልማንሳ ብሻን በዲሳ ጀላ በኡፍ ዶኒ ሴነን። ");
INSERT INTO gaze_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","ብኔንሶትን ቁልቁሉፊ ከን ቁልቁሉ ህንተእን፣ ስምብሮትኒፊ ኡመመወን ለፈረ ሙኙቀን ሁንድ፣ ጭምዲ ጭምዲዻን፣ ");
INSERT INTO gaze_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","ኮርማፊ ዸላን ገረ ኖህ ዹፈኒ አኩመ ዋቅን ኖሂን አጀጄት ዶንቸ ሴነን። ");
INSERT INTO gaze_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","ጉያ ቶርበ ቦዴ ብሻን በዲሳ ሎለኤ ለፈ ጉቴ። ");
INSERT INTO gaze_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","በረ ጅሬኘ ኖህ ወጋ ዽበ ጀአፋ ኬሰ፣ ጅአ ለመፋት፣ ጅአ ሰነ ኬሳስ ጉያ ኩዸ ቶርበፋት ቡርቃወን ቱጁበ ጉርጉዳ ሁንድ ንዾአን፤ ፎዳወን ብሻን ሰሚስ ንበነመን። ");
INSERT INTO gaze_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","ቦካንስ ጉያ አፉርተማፊ ሀልከን አፉርተመ ለፈት ሮቤ። ");
INSERT INTO gaze_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","ጉዩመ ሰነ ኖሂፊ እልማንሳ፣ ሴም፣ ሃሚፊ ያፌት፣ ኒቲሳቲፊ ኒቶተ እልማንሳ ሰደኒ ወጅን ዶንቸ ሴነን። ");
INSERT INTO gaze_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","እሳንስ ብኔንሶተ ሁንደ፣ አኩመ ጎሰሳኒት፣ ሆሪ ሁንደ አኩመ ጎሰሳኒት፣ ኡመመወን ለፈረ ሙኙቀን ሁንዳፊ ስምብሮተ ሁንደ አኩመ ጎሰሳኒት፣ ዋን ቆቾ ቀቡ ሁንደስ ኦፍ ፋነ ፉዸተኒ ሴነን። ");
INSERT INTO gaze_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","ኡመመወን ሀፉረ ጅሬኛ ኦፍ ኬሳ ቀበን ሁንድኑስ ጭምዲ ጭምዲዻን ገረ ኖህ ዹፈኒ ዶንቸ ሴነን። ");
INSERT INTO gaze_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","ብኔንሶትን አኩመ ዋቅን ኖህን አጀጄት ዶኒት ገለን ኮርማፊ ዸላ ኡመመወን ሉቡ ቀቤዪ ሁንዳ ቱረን፤ ኤርገሲሞ ዋቀዮ አላን እት ጩፌ። ");
INSERT INTO gaze_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","ብሻን በዲሳስ እቱመ ፉፌ ጉያ አፉርተማፍ ለፈረ ቱሬ፤ ብሻን ሱንስ ደበላ ዴሜ ዶኒ ሰነ ለፈራ ኦል ካሴ። ");
INSERT INTO gaze_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","ብሻንችስ ኦል ከኤ ለፈረት አከ መሌ ባይአቴ፤ ዶኒን ሱንስ ብሻንቸረ ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","ብሻንችስ አከ መሌ ኦል ከኣ ዴሜ ቱሉወን ሰሚ ጀለ ጅረን ሁንደ ሀጉጌ። ");
INSERT INTO gaze_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","ብሻንች ዹንዹመ ኩዸ ሸን ጫላ ኦል ከኡዻን ቱሉወን ዾክሴ። ");
INSERT INTO gaze_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","ኡመመወን ሉቡ ቀቤዪን ለፈረ ጅራተን ሁንድ ጄቹንስ፣ ስምብሮትን፣ ሆሪን፣ ብኔንሶትን፣ ኡመመወን ለፈረ ሙኙቀን ሁንዲፊ ነሞትን ሁንድ ንበርበዳአን። ");
INSERT INTO gaze_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","ወን ለፈ ጎጋረ ጅራቱ ከን ፉኛንሳቲን ሀፉረ ጅሬኛ ባፈቱ ሁንድኑ ንዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","ኡመመወን ሉቡ ቀቤዪን ለፈረ ጅራተን ሁንድኑ ንሀጣአመን፤ ነምኒፊ ሆሪን፣ ኡመመወን ለፈረ ሙኙቀኒፊ ስምብሮትን ሰሚ፣ ለፈራ ንሀጣአመን። ኖሂፊ ወረ እሰ ወጅን ዶኒ ኬሰ ቱረን ቆፈቱ ሀፌ። ");
INSERT INTO gaze_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","ብሻን ሱንስ ቡልቲ ዽበ ቶኮፊ ሸንተመ ለፈረ ሎለኤ። ");
INSERT INTO gaze_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","ዋቅን ገሩ ኖህን፣ ብኔንሶታፊ ሆሪ እሰ ወጅን ዶኒ ኬሰ ቱረን ሁንደ ያደቴ። እንስ ቡቤ ለፈት ኤርጌ፤ ብሻንችስ ገድ ገሌ። ");
INSERT INTO gaze_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","ቡርቃወን ቱጁበወኒቲፊ ፎዳወን ሰሚወኒ ንጩፈመን፤ ቦካን ሰሚ ኬሳ ገድ ሮቡስ ንጫሜ። ");
INSERT INTO gaze_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","ብሻን ሱንስ ሱቱመ ሱተ ለፈራ ህርአቻ ዴሜ ዹመ ቡልቲ ዽበ ቶኮፊ ሸንተማት ገድ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","ዶኒን ሱንስ ጉያ ኩዸ ቶርበፋ ጅአ ቶርበፋት ቱሉ አራራት ጉባ ቁበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","ብሻንች ሀመ ጅአ ኩርነፋት ገዱመ ገላ ዴሜ። ጉያ ጀልቀበ ጅአ ኩርነፋትስ መታወን ቱሉወኒ ሙልአተን። ");
INSERT INTO gaze_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","ጉያ አፉርተመ ቦዴ ኖህ ፎዳ ዶኒት ባሴ ቱሬ ሰነ በኔ፤ ");
INSERT INTO gaze_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","እንስ አራጌሰ ቶኮ ገድ ዺሴ፤ አራጌስ ሱንስ ሀመ ብሻንች ለፈራ ጎጉት አሲፊ አች ዴዴብኣ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","ኤርገሲሞ አከ ብሻንች ለፈራ ህርአቴ ሁበቹፍ ጉጌ ቶኮ ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","ገሩ ሰበቢ ብሻን ለፈ ሁንደረ ጉቴ ጅሩፍ ጉጌን ሱን እዶ ቁበቱ ዸብዴ ገረ ኖህ ዶኒት ዴብቴ። እንስ ሀርከሳ ገድ ሂጠቴ ጉጌ ሰነ ገረ ዶኒት እዶ ኦፊ ጅሩት ኦል ገልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","አመስ ጉያ ቶርበ ቱሬ ጉጌ ሰነ ዶኒ ኬሳ ገድ ባሴ ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","ጉጌን ሱንስ ገልገለ ዮሙ ገረሳት ዴብቴት ኩኖ፣ ባለ ኤጄርሳ ከን አመ ኩተሜ አፋንት ቀበቴ ቱርቴ። ከናንስ ኖህ አከ ብሻንች ገድ ህርአቴ ቤኬ። ");
INSERT INTO gaze_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","አመስ ጉያ ብራ ቶርበ ቱሬ ጉጌ ሰነ ዴብሴ ኤርጌ፤ ጉጌን ሱን ገሩ ለመተ ገረሳት ህንዴብኔ። ");
INSERT INTO gaze_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","ኡሙሪ ኖሂ ወጋ ዽበ ጀኣፊ ቶኮፋት፣ ጉያ ቶኮፋ ጅአ ጀልቀባት፣ ብሻንች ለፈራ ጎጌ። ኖህስ ቀዳደ ዶኒ ሰናራ ፉዼ እላሌ ኩኖ አከ ለፍት ጎግዴ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","ጉያ ድግደሚ ቶርበፋ ጅአ ለመፋት ለፍት ጉቱማን ጉቱት ጎግዴ። ");
INSERT INTO gaze_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","ዋቅንስ ኖሂን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“አቲፊ ኒቲንኬ፣ እልማንኬቲፊ ኒቶትን እልማንኬቲ ኮታ ዶኒ ኬሳ በኣ። ");
INSERT INTO gaze_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","አከ እሳን ለፈረት ባይአተኒፍ፣ አከ እሳን ሆረኒ ለፈረት ባይአተኒፍ፣ ጎሰ ኡመመወን ሉቡ ቀቤዪ ስ ወጅን ጅረን ሁንደ ጄቹንስ ስምብሮተ፣ ብኔንሶታፊ ኡመመወን ለፈረ ሙኙቀን ሁንደ ገድ ባስ።” ");
INSERT INTO gaze_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","ከናፉ ኖህ እልማንሳቲፊ ኒቲሳ፣ ኒቶተ እልማንሳ ወጅን ገድ በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","ብኔንሶትን ሁንዲፊ ኡመመወን ለፈረ ሙኙቀን ሁንድኑ፣ ስምብሮትን ሁንድ ጄቹንስ ወን ለፈረ ጅራቱ ሁንድ ጎሱመ ጎሳን ዶኒ ሰነ ኬሳ ገድ በአን። ");
INSERT INTO gaze_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","ኖህስ ዋቀዮፍ እዶ ኣርሳ እጃሬ፤ ሆሪፊ ስምብሮተ ቁልቁሉ ሁንደ ኬሳ ፉዼ እዶ ኣርሳ ሰነረት ኣርሳ ጉበሙ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","ዋቀዮስ ፎሊ ቶላ ሰነ ኡርጌፈቴ ገራሳ ኬሰት አከነ ጄዼ፤ “ዮ ወን ነምን እጆሉማሳቲ ጀልቀቤ ገራሳት ያዱ ሀምነ ተኤሌ አን ሰበቢ ነማቲፍ ጄዼ ለመተ ለፈ ህንአባሩ። አን አከን ከናን ዱረ ጎዼ ሰነ ዴብኤ ኡመመወን ጅራቶ ሁንደ ህንበሌሱ። ");
INSERT INTO gaze_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“ሀመ ለፍት ጅርቱት፣ ምዻን ፈጫሱፊ ወልት ቀቡን፣ ዻሞቺፊ ሆእ፣ ቦኒፊ ገን፣ ሀልከኒፊ ጉያን ጎንኩማ ህንሀፈን።” ");
INSERT INTO gaze_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","ዋቅን አከነ ጄዼ ኖሂፊ እልማንሳ ኤብሴ፤ “ሆራ፣ ባይአዻ፣ ለፈስ ጉታ። ");
INSERT INTO gaze_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","ሶዳችሱፊ ናስሱንኬሰን ብኔንሶተ ለፋ ሁንዱማፊ ስምብሮተ ሰሚ ሁንዱማ፣ ኡመመወን ለፈረ ሙኙቀን ሁንዱማፊ ቁርጡሚወን ገላና ሁንዱማረ ሃቡኡ፤ እሳን ሀርከኬሰንት ኬነመኒሩ። ");
INSERT INTO gaze_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","ወን ጅራቱፊ ወን ሙኙቁ ሁንድ ኛተ እስኒፍ ንተአ። አን አኩመን ብቅለ ለልሳ እስኒ ኬኔ ሰነ አመስ ዋን ሁንደ እስኒፍ ነንኬነ። ");
INSERT INTO gaze_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“እስን ገሩ ፎን ሉቡሳ ወጅን ጄቹንስ ዺገሳ ወጅን ህንኛትና። ");
INSERT INTO gaze_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","አን ዹጉማን ዺገኬሰን ከን ሉቡንኬሰን ኬሰ ጅርቱ ነንበርባደ። ብኔንሰ ሁንደራ ነንበርባደ። ኦቦሌሰ ነመ ሁንዳራስ ሉቡ ነማ ነንበርባደ። ");
INSERT INTO gaze_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“ነመ ዺገ ነማ ዸንገላሱ፣ ዺግንሳ ሀርከ ነማቲን ዸንገላፈመ፤ ዋቅን ብፈ ዋቃቲን ነመ ኡሜቲ። ");
INSERT INTO gaze_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","እስንስ ሆራ፣ ባይአዻ፤ ለፈ ጉታ፣ እረትስ ባይአዻ።” ");
INSERT INTO gaze_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","ኤርገሲ ዋቅን ኖሂፊ እልማንሳ ወረ እሳ ወጅን ቱረኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“ኩኖ አን እስኒፊ ሰኚኬሰን ወረ እስን ቦዴ ወጅን ከኩኮ ነንሁንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","አከሱመስ ኡመመወን ሉቡ ቀቤዪ እስን ወጅን ቱረን ሁንደ ጄቹንስ ስምብሮተ፣ ሆሪፊ ብኔንሶተ ለፋ ሁንደ፣ ዋን እስን ወጅን ዶኒ ኬሳ በኤ ሁንደ፣ ኡመመወን ለፈረ ጅራተን ሁንደ ወጅንስ ከኩኮ ነንሁንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","አከ ስአች ወን ሉቡ ቀቡ ሁንድ ዴብኤ ብሻን በዲሳቲን ህንበድኔፍ፣ ስአች ብሻን በዲሳ ለፈ በሌሱፍ ጎንኩማ አከ ህንዹፍኔፍ አን እስን ወጅን ከኩኮ ነንሁንዴሰ።” ");
INSERT INTO gaze_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","ዋቅን አከነ ጄዼ፤ “መለቶን ከኩ ከን አን ኦፊኮቲፊ እስን ግዱት፣ ኡመመወን ሉቡ ቀቤዪ እስን ብረ ጅረን ሁንደ ግዱት፣ ዸሎተ ዹፉፍ ጅሩ ሁንዳፍ ገሉ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","አን ሰበተኮ ዱሜሰ ኬሰ ዻቤረ፤ እንስ ከኩ አናፊ ለፈ ግዱ ጅሩፍ መለቶ ተአ። ");
INSERT INTO gaze_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","ዬሮ አን ለፈረት ዱሜሰ ፍዴ ሰበትንኮ ዱሜሰ ኬሳን ሙልአቱት፣ ");
INSERT INTO gaze_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","አን ከኩኮ ከን ኦፊኮቲፊ እስን ግዱ፣ ኡመመወን ሉቡ ቀቤዪ ጎሰ ሁንዳ ግዱስ ጅሩ ሰነ ነንያደዸ። ብሻኖትንስ ዴብአኒ ሉቡ ሁንደ በሌሱፍ ጎንኩማ ብሻን በዲሳ ህንተአን። ");
INSERT INTO gaze_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","ዬሮ ሰበትንኮ ዱሜሰ ኬሳን ሙልአቱት፣ አን እሰ እላሌ ከኩ በረ በራ ከን ዋቃፊ ኡመመወን ሉቡ ቀቤዪ ጎሰ ሁንዳ ከኔን ለፈረ ጅራተን ግዱ ጅሩ ሰነ ነንያደዸ።” ");
INSERT INTO gaze_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","ከናፉ ዋቅን ኖሂን፣ “ኩን መለቶ ከኩ አን ኦፊኮቲፊ ሉቡ ለፈረ ጅራቱ ሁንደ ግዱ ዻቤ ሰናት” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","እልማን ኖህ ወር ዶኒ ኬሳ በአን ሴም፣ ሃሚፊ ያፌት ቱረን። ሃም አባ ከነኣኒት። ");
INSERT INTO gaze_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","እልማን ኖህ ጀረ ከነ ሰደን ቱረን፤ ሰኚን ነማ ከን ለፈ ሁንደረ ብትኔፈሜስ እሳኑመራ አርገሜ። ");
INSERT INTO gaze_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","ኖህ ቆናን ቡላ ተኤ ወይኒ ዻቡት ነመ ጀልቀባ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","እንስ ዳዺ ወይኒ ሰና ዹጌ መቻኤ፤ ቁላሳስ ዱንካነሳ ኬሰ ጪሴ። ");
INSERT INTO gaze_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","ሃም አባን ከነኣን ቁላ አባሳ አርጌ ኦቦሎተሳ ለማን አለ ቱረንት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","ሴሚፊ ያፌት ገሩ ወያ ፉዸኒ ገቲቲሳኒ ለማንረ ቡፈተኒ ዱግደ ዱባን ዴመኒ ቁላ አባሳኒት ኡፍሰን። ዋን ፉልሳኒ አች ገረገሌ ቱሬፍ እሳን ቁላ አባሳኒ ህንአርግኔ። ");
INSERT INTO gaze_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","ኖህስ ዬሮ መቺንሳ እራ ገሌት ዋን እልምሳ እን ጥናን እሰት ሆጄቴ ቤኬ ");
INSERT INTO gaze_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","አከነ ጄዼ፤ “ከነኣን አባረማ ሃተኡ! እን ኦቦሎተሳቲፍ ገርበ ገርቦታ ሃተኡ።” ");
INSERT INTO gaze_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","አከነስ ጄዼ፤ “ዋቀዮ ዋቅን ሴም ሃኤብፈሙ! ከነኣንሞ ገርብቸ ሴም ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","ዋቅን ብየ ያፌት ሃበልእሱ፤ ያፌት ዱንካኖተ ሴም ኬሰ ሃጅራቱ፤ ከነኣንሞ ገርብቸሳ ሃተኡ።” ");
INSERT INTO gaze_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","ብሻን በዲሳ ቦዴ ኖህ ወጋ 350 ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","ወሉመት ኖህ ወጋ 950 ጅራቴ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","ሴናን እልማን ኖህ ጄቹንስ ከን ሴም፣ ከን ሃሚፊ ከን ያፌት ከነ፤ እሳንስ ብሻን በዲሳ ቦዴ እልማን ዸልቸን። ");
INSERT INTO gaze_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","እልማን ያፌት፦ ጎሜር፣ ማጎግ፣ ሜዴ፣ ያዋን፣ ቱባል፣ ሜሼኪፊ ቲራስ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","እልማን ጎሜር፦ አሽኬነስ፣ ሪፋቲፊ ቶገርማ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","እልማን ያዋን፦ ኤሊሻ፣ ተርሺሽ፣ ክቲሚፊ ሮዳኖተ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","ኡመትን ቀርቀረ ገላናስ ቶኮን ቶኮንሳኒ አኩመ አፋንሳኒቲፊ አኩመ ሰበሳኒት ገረ ብዮተሳኒት ብብትናአን። ");
INSERT INTO gaze_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","እልማን ሃም፦ ኩሽ፣ ምስረይም፣ ፉጢፊ ከነኣን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","እልማን ኩሽ፦ ሳባ፣ ሀዊላ፣ ሰብታ፣ ረእማፊ ሰብቴካ ቱረን። እልማን ረእማ፦ ሼባፊ ዴዳን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","ኩሽ አባ ናምሩድ፤ ናምሩድስ ለፈረት ሎልቱ ጀባ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","እንስ ፉለ ዋቀዮ ዱረት አደምሳ ጀባ ቱሬ፤ ከናፉ፣ “ፉለ ዋቀዮ ዱረት አደምሳ ጀባ አከ ናምሩድ” ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","ጀልቀብን ሞቱማሳ ሽኔኣር ኬሰት ባብሎን፣ ኤሬክ፣ አካዲፊ ካልኔ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","እንስ ብየ ሰና በኤ አሶር ዸቄ፤ አችትስ ነነዌ፣ ሬሆቦቲፊ ካለህ እጃሬ፤ ");
INSERT INTO gaze_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","አከሱመስ ሬሴን እሼ ነነዌፊ ካለህ ግዱት አርገምቱ ንእጃሬ፤ ሬሴን ኩንስ መጋላ ጉዶዸ። ");
INSERT INTO gaze_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","ምስረይምሞ አባ ሉዲሞታ፣ አናሚሞታ፣ ሌሃቢሞታ፣ ነፍተሂሞታ፣ ");
INSERT INTO gaze_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","ፈትሩሲሞታ፣ ከሴሉሂሞታ፣ ጄቹንስ ወረ ፍልስጤሞትን እራ ዸለተኒፊ ከፍቶሪሞታት። ");
INSERT INTO gaze_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","ከነኣን አባ ሲዶን እልመሳ ሀንገፍትቻ፣ አከሱመስ ከን ሄቶታ፣ ");
INSERT INTO gaze_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","ዬቡሶታ፣ አሞሮታ፣ ግርጋሾታ፣ ");
INSERT INTO gaze_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","ሂዎታ፣ አርካዎታ፣ ሲኖታ፣ ");
INSERT INTO gaze_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","አርዋዴዎታ፣ ዜማሮታቲፊ ሀማቶታ ቱሬ። ኤርገሲ ጎሶትን ከነኣን ንብብትናአን፤ ");
INSERT INTO gaze_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","ዳሪን ከነኣንስ ሲዶኒ ከኤ ከራ ጌራራቲን ሀመ ጋዛት በልአቴ፤ ከራ ሶዶም፣ ጎሞራ፣ አድማቲፊ ዜቦኢሚቲንስ ሀመ ሌሻት በልአቴ። ");
INSERT INTO gaze_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","እልማን ሃም አኩመ ጎሳፊ አፋንሳኒት፣ አኩመ ብያፊ ሰበሳኒት ከኔኒዸ። ");
INSERT INTO gaze_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","ሴሚፍስ እልማን ንዸለተን፤ ኦቦሌስ ሴም ሀንገፍት ያፌት ቱሬ፤ ሴምስ አባ እልማን ኤቤር ሁንዳ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","እልማን ሴም ኤላም፣ አሹር፣ አርፋክሸድ፣ ሉዲፊ አራም ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","እልማን አራም ኡዝ፣ ሁል፣ ጌቴሪፊ ሜሼክ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","አርፋክሸድ ሼላ ዸልቼ፤ ሼላንሞ ኤቤርን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","ኤቤሪፍስ እልማን ለመቱ ዸለቴ፤ ሰበቢ በረሳ ኬሰ ለፍት ገርገር ቆደምቴፍ መቃን እሰ ቶኮ ፌሌግ ጄዸሜ ሞጋፈሜ፤ መቃን ኦቦሌሰሳሞ ዮቅጣን ጄዸሜ ሞጋፈሜ። ");
INSERT INTO gaze_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","ዮቅጣንሞ አልሞዳድ፣ ሼሌፍ፣ ሀዘርማዌት፣ ያራ፣ ");
INSERT INTO gaze_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","ሀዶራም፣ ኡዛል፣ ድቅላ፣ ");
INSERT INTO gaze_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","ኦባል፣ አቢማኤል፣ ሼባ፣ ");
INSERT INTO gaze_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","ኦፊር፣ ሀዊላፊ ዮባብን ዸልቼ። ወር ኩኔን ሁንድኑ እልማን ዮቅጣኒት። ");
INSERT INTO gaze_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","ለፍት ጅሬኘሳኒ ሜሻ ከኤ ከራ ሴፋሪቲን ሀመ ጋረን በአ ቢፍቱት በልአተ። ");
INSERT INTO gaze_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","እልማን ሴም አኩመ ጎሳፊ አፋንሳኒት፣ አኩመ ብያፊ ሰበሳኒት ከኔኒዸ። ");
INSERT INTO gaze_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","ወር ኩን ጎሶተ እልማን ኖህ ከኔን አኩመ ዸሎተሳኒት ሰበሳኒ ኬሰ ጅረኒዸ፤ ብሻን በዲሳቲን ቦዴ ሰቦትን ወሩመ ከነራ ለፈረ ፈፈጨአን። ");
INSERT INTO gaze_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","በረ ሰነ አዱኛን ጉቱን አፋን ቶኮፊ ሃሳ ቶኮ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","ነሞትን አኩመ ገረ በአ ቢፍቱት ጎዳነኒን፣ ሽኔኣር ኬሰት ለፈ ድሪራ አርገተኒ አች ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","እሳንስ፣ “ኮታ ሜ ጡቢ ሆጄትኔ እብዳን ጉብና” ወሊን ጄዸን። እሳንስ ቆደ ዸጋ፣ ጡቢት ፈየደመን፤ ሀጴዻፍሞ ሌሌት ፈየደመን። ");
INSERT INTO gaze_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","ኤርገሲ፣ “ኮታ ሜ አከ ኦፊኬኛ መቃ አርገትኑፊ አከ አዱኛ ጉቱረ ህንብብትኖፍኔፍ መጋላ ገሞንሳ ሰሚ ቀቀቡ ቶኮ እጃረትና” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","ዋቀዮ ገሩ መጋላፊ ገሞ እሳን እጃራ ቱረን ሰነ እላሉፍ ገድ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","ዋቀዮስ አከነ ጄዼ፤ “ኤርገ እሳን አከ ሰበ ቶኮ ከን አፋኑመ ቶኮ ዱበቱት ዋን ከነ ሆጄቹ ጀልቀበኒ፣ ዮስ አመ ወን እሳን ሆጄቹፍ ከሮርፈተን ከን እሳኒፍ ህንደንደአምኔ ቶኮዩ ህንጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","ኮታ ሜ ገድ ቡኔ፣ አከ እሳን ወል ህንሁበኔፍ አፋንሳኒ ወሊን ዾፍና!” ");
INSERT INTO gaze_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","ከናፉ ዋቀዮ አቺ እሳን ባሴ ለፈ ሁንደረ እሳን ብትኔሴ፤ እሳንስ መጋላ እጃሩ ዺሰን። ");
INSERT INTO gaze_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","ዋን ዋቀዮ አችት አፋን አዱኛ ሁንደ ወሊን መኬፍ እዶን ሱን ባብሎን ጄዸሜ፤ ዋቀዮ እዶ ሰና እሳን ባሴ ለፈ ሁንደረ እሳን ብትኔሴ። ");
INSERT INTO gaze_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","ሴናን ማቲ ሴም ከነ። ብሻን በዲሳ ቦዴ ወጋ ለመት ሴም ዬሮ ኡሙሪንሳ ወጋ 100 ጉቴት አርፋክሸድን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","ሴም ኤርገ አርፋክሸድን ዸልቼ ቦዴ ወጋ 500 ጅራቴ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","አርፋክሸድ ወጋ 35 ጅራቴ ሼላ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","አርፋክሸድ ኤርገ ሼላ ዸልቼ ቦዴ ወጋ 403 ጅራቴ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","ሼላን ወጋ 30 ጅራቴ ኤቤርን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","ሼላን ኤርገ ኤቤርን ዸልቼ ቦዴ ወጋ 403 ጅራቴ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","ኤቤር ወጋ 34 ጅራቴ ፌሌግን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","ኤቤር ኤርገ ፌሌግን ዸልቼ ቦዴ ወጋ 430 ጅራቴ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","ፌሌግ ወጋ 30 ጅራቴ ሬኡ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","ፌሌግ ኤርገ ሬኡ ዸልቼ ቦዴ ወጋ 209 ጅራቴ እልማኒፊ እንተለን ብራስ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","ሬኡን ወጋ 32 ጅራቴ ሴሩግን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","ሬኡን ኤርገ ሴሩግን ዸልቼ ቦዴ ወጋ 207 ጅራቴ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","ሴሩግ ወጋ 30 ጅራቴ ናሆርን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","ሴሩግ ኤርገ ናሆርን ዸልቼ ቦዴ ወጋ 200 ጅራቴ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","ናሆር ወጋ 29 ጅራቴ ታራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","ናሆር ኤርገ ታራ ዸልቼ ቦዴ ወጋ 119 ጅራቴ እልማኒፊ እንተለን ብራ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","ታራን ወጋ 70 ጅራቴ አብራም፣ ናሆሪፊ ሃራንን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","ሴናን ማቲ ታራ ከነ። ታራን አብራም፣ ናሆሪፊ ሃራንን ዸልቼ። ሃራንሞ ሎጥን ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","ሃራን ኡቱመ አባንሳ ታራን ጅሩ ኡር ብየ ከልዶታ ኬሰት ለፉመ እት ዸለቴት ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","አብራሚፊ ናሆር ኒቲ ፉዸን። መቃን ኒቲ አብራም ሳራ፣ መቃን ኒቲ ናሆርሞ ሚልካ ቱሬ። ሚልካን እንተለ ሃራን። ሃራን ኩንሞ አባ ሚካቲፊ ይስካ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","ሳራን ዸብዱ ቱርቴ፤ እጆሌስ ህንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","ታራን እልመሳ አብራምን፣ እልመ እልመሳ ጄቹንስ ሎጥ እልመ ሃራኒፊ ኒቲ እልመሳ ጄቹንስ ሳራ ኒቲ አብራም ፉዸቴ ከነኣን ዸቁፍ፣ ኡር ብየ ከልዶታቲ ወሊ ወጅን በአን፤ ገሩ ዬሮ ካራን ገአንት አቹመ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","ታራን ወጋ 205 ጅራቴ ካራንት ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","ዋቀዮ አብራሚን አከነ ጄዼ፤ “ብየኬ፣ ሰበኬቲፊ መነ አባኬቲ ዺሲቲ ገረ ብየ አን ስ አርግሲሱ ዸቅ። ");
INSERT INTO gaze_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“አን ሰበ ጉዳ ስን ታስሰ፤ ስን ኤብሰስ፤ መቃኬሌ ጉዳ ነንታስሰ፤ አትስ ኤበ ታታ። ");
INSERT INTO gaze_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","አን ወረ ስ ኤብሰን ነንኤብሰ፤ ወረ ስ አባረን ነንአባረ፤ ሰብን ለፈራ ሁንድኑ ከራኬቲን ኤብፈመ።” ");
INSERT INTO gaze_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","ከናፉ አብራም አኩመ ዋቀዮ እሰት ህሜት ከኤ ዴሜ፤ ሎጥስ እሰ ወጅን ዴሜ። አብራም ዬሮ ካራኒ በኤት ነመ ወጋ ቶርባተሚ ሸኒ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","እንስ ኒቲሳ ሳራ፣ እልመ ኦቦሌሰሳ ሎጥ፣ ቀቤኘ ወልት ኩፈተን ሁንዱማፊ ነሞተ ካራንት አርገተን ሁንዱማ ቀበቴ ከነኣን ዸቁፍ ከኤ፤ እሳንስ አች ገአን። ");
INSERT INTO gaze_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","አብራምስ ሀመ ቅልጡ ሞሬ ከን ሼኬም ኬሰት አርገሙት ብየቲ ኬሰ ዴሜ። ዬሮ ሰነ ወር ከነኣን ብየ ሰነ ኬሰ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","ዋቀዮ አብራምት ሙልአቴ፣ “አን ብየ ከነ ሰኚኬቲፍ ነንኬነ” ጄዼን። ከናፉ እን አችት ዋቀዮ እሰት ሙልአቴ ሰናፍ እዶ ኣርሳ እጃሬ። ");
INSERT INTO gaze_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","አቺ ከኤ ገረ ጋረን ቤትኤልራ ገረ በአ ቢፍቱት አርገመኒ ዴሜ ቤትኤልን ገረ ልጠ ቢፍቱት፣ ኣይንሞ ገረ በአ ቢፍቱት ሀምብሴ ዱንካነሳ ዻበቴ። አችት ዋቀዮፍ እዶ ኣርሳ እጃሬ መቃ ዋቀዮ ዋመቴ። ");
INSERT INTO gaze_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","አብራም ኤርገሲ ከኤ ገረ ኔጌብት ከራሳ እት ፉፌ። ");
INSERT INTO gaze_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","በረ ሰነ ቤል ብየ ሰነት ቡኤ ቱሬ፤ ቤል ሱን ዋን ሀማቴፍ አብራም አች ጅራቹፍ ጄዼ ግብጥት ገድ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","እንስ ዬሮ ግብጥ ሴኑ ገኤት ኒቲሳ ሶራን አከነ ጄዼ፤ “አን አከ አት ዱበርቲ በሬዱ ታቴ ነንቤከ። ");
INSERT INTO gaze_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","ወር ግብጥ ዮሙ ስ አርገን፣ ‘ኩን ኒቲሳት’ ጄዸኒ ነ አጄሱ፤ ስእሞ ንሀምብሱ። ");
INSERT INTO gaze_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","አከ እሳን ሲፍ ጄዸኒ ሃለ ቶላን ነ እላለኒፊ አከ ሉቡንኮስ ሰበቢኬቲን ዱአ ኦልቱፍ ማሎ፣ ‘አን ኦቦሌቲሳት’ ጄዽ።” ");
INSERT INTO gaze_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","ዬሮ አብራም ግብጥ ሴኔትስ ወር ግብጥ አከ ሶራን ዱበርቲ ባይኤ በሬዱ ታቴ አርገን። ");
INSERT INTO gaze_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","ቆንዳልቶትን ፈረኦንስ ዮሙ እሼ አርገንት እሼ ጀጀኒ ፈረኦንት ህመን፤ እሼንስ መሰራ ሞቱማ ፈረኦንት ጌፈምቴ። ");
INSERT INTO gaze_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","ፈረኦን ሰበቢሼቲፍ ጄዼ አብራምን ሃለ ቶላዻን እላሌ፤ አብራምስ ሆሎታፊ ሎን፣ ሀሮተ ኮሮሚፊ ዸልቱ፣ ተጃጅልቶተ ዺራ ዱበርቲ፣ ጋለስ አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","ዋቀዮ ገሩ ሰበቢ ኒቲ አብራም፣ ሰበቢ ሳራቲፍ ጄዼ ፈረኦኒፊ ወረ መነሳ ጅራተን ዹኩበ ሀማን ዸኤ። ");
INSERT INTO gaze_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","ከናፉ ፈረኦን አብራምን ኦፍት ዋሜ አከነ ጄዼን፤ “አት ማል ነት ሆጄቴ? አከ እሼን ኒቲኬ ታቴ ማሊፍ ነት ህንህምን? ");
INSERT INTO gaze_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","አት ማሊፍ፣ ‘እሼን ኦቦሌቲኮት’ ጄቴ፣ አከ አን ኒቱማፍ እሼ ፉዸዹ ነ ጎቴ? አመስ ኒቲንኬ ኩኖት፤ እሼ ፉዸዹ ዴም!” ");
INSERT INTO gaze_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","ፈረኦንስ ዋኤ አብራምረት ነሞተሳ አጀጄ፤ እሳንስ አብራሚፊ ኒቲሳ፣ ዋን እን ቀቡ ሁንደ ወጅን ጌጌሰን። ");
INSERT INTO gaze_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","አብራም ኒቲሳቲፊ ዋን ቀቡ ሁንደ ወጅን ግብጢ ከኤ ኔጌብት ኦል በኤ፤ ሎጥስ እሰ ወጅን ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","አብራምስ ሆሪን፣ ሜቲፊ ወርቄዻን አከ መሌ ሶሮሜ። ");
INSERT INTO gaze_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","እንስ ኔጌቢ ከኤ ሀመ ቤትኤል፣ እዶ ቤትኤሊፊ ኣይ ግዱ፣ ለፈ ዱንካንሳ ጀልቀበት ቱሬ ሰነ ገኡት እዶ ቶኮ ገረ እዶ ብራት ዴምሰሳ እት ፉፌ፤ ");
INSERT INTO gaze_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","እዶን ሱንስ ለፈ እን ዬሮ ጀልቀባቲፍ እዶ ኣርሳ እት እጃሬዸ። አብራምስ አችት መቃ ዋቀዮ ዋመቴ። ");
INSERT INTO gaze_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","ሎጥ ነምች አብራም ወጅን ዴማ ቱሬ ሱን አከሱመ ቡሻዬ፣ ሳወኒፊ ዱንካኖተ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","ዬሮ እሳን ወሊ ወጅን ጅራተንት ለፍት እሳንት ዽጰቴ፤ ሰበቢ ቀቤኝሳኒ አከ መሌ ጉደቴፍስ እሳን ወል ብረ ጅራቹ ህንደንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","ከናፉ ትክሶተ አብራሚፊ ትክሶተ ሎጥ ግዱት ሎል ኡመሜ። ዬሮ ሰነት ከነኣኖትኒፊ ፌርዞንስ ብየ ሰነ ኬሰ ጅራቻ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","አብራምስ ሎጢን አከነ ጄዼ፤ “ኑ ዋን ኦቦሎተ ታኔፍ፣ ስኢፊ አነ ግዱ ዮካን ትክሶተኬቲፊ ትክሶተኮ ግዱ ሎል ህንጅራትን። ");
INSERT INTO gaze_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","ለፍት ሁንድ ፉለኬ ዱረ ጅርት ምቲ? ኮቱ ገርገር ጎዳና። ዮ አት ገረ ብታት ዴምቴ፣ አን ገረ ምርጋት ነንዴመ፤ ዮ አት ገረ ምርጋት ዴምቴሞ አን ገረ ብታት ነንዴመ።” ");
INSERT INTO gaze_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","ሎጥስ ኦል ጄዼ እላሌ አከ ሁሩፍን ዮርዳኖስ ሁንድ አኩመ እዶ ብቅልቱ ዋቀዮ አኩመ ብየ ግብጥ ከን ከራ ዞኣርረ ጅሩ ሰና ብሻን ባይኤ ቀቡ አርጌ። ኩንስ ኡቱ ዋቀዮ ሶዶሚፊ ጎሞራ ህንበሌስኒን ዱረ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","ከናፉ ሎጥ ሁሩፈ ዮርዳኖስ ጉቱማት ኦፊሳቲ ፍለቴ ገረ በአ ቢፍቱት ጎዳኔ። ጀር ለማንስ አከስት ገርገር በአን። ");
INSERT INTO gaze_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","አብራም ብየ ከነኣን ኬሰ ጅራቴ፤ ሎጥሞ መጋላወን ድሬረ ጅረን ግዱ ጅራቴ ዱንካነሳ ሶዶም ብረ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","ወር ሶዶም ጀልኦተ ፉለ ዋቀዮ ዱረት አከ መሌ ጩቡ ሆጄተን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","ኤርገ ሎጥ እሰ ብራ ጎዳኔ ቦዴ ዋቀዮ አብራሚን አከነ ጄዼ፤ “እዶ አመ ጅርቱ ከና እጀኬ ኦል ፉዸዹቲ ገረ ካባፊ ክባ፣ ገረ በአ ቢፍቱቲፊ ልጠ ቢፍቱ እላል። ");
INSERT INTO gaze_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","አንስ ብየ አት አርግቱ ከነ ሁንደ በረ በራን ስኢፊ ሰኚኬቲፍ ነንኬነ። ");
INSERT INTO gaze_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","አን ሰኚኬ አኩመ ብዮ ለፋ ነንባይእሰ፤ ዮ ነምን ብዮ ለፋ ለካኡ ደንደኤ፣ ሰኚንኬ አከሱመ ለካአሙ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","ከኢቲ ዼርናፊ በልእነ ለፈ ከና ኬሰ ዴዴም፤ አን እሰ ሲፍን ኬናቲ።” ");
INSERT INTO gaze_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","ከናፉ አብራም ዱንካነሳ ቡቅፈቴ ቅልጡወን መምሬ ከኔን ኬብሮንት አርገመን ብረ ጅራቹ ዸቄ፤ አችትስ እዶ ኣርሳ ዋቀዮፍ ቶልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","በረ ሰነ ኬሰ አምራፌል ሞቲን ሽኔኣር፣ አርዮክ ሞቲን ኤላሳር፣ ኬዶርላኦሜር ሞቲን ኤላሚፊ ትድኣል ሞቲን ሰቦታ ከአኒ፣ ");
INSERT INTO gaze_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","ቤራ ሞትቸ ሶዶም፣ ብርሻ ሞትቸ ጎሞራ፣ ሽናብ ሞትቸ አድማ፣ ሼሜቤር ሞትቸ ዜቦኢሚፊ ሞትቸ ቤላ እሼ ዞኣር ጄዸምቱ ሰና ሎሉ ዸቀን። ");
INSERT INTO gaze_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","ሞቶትን ሸነን ኩኔን ሁንድ ሱሉለ ሲዲም እሰ ገላነ ሶግዳ ጄዸሙ ኬሰት ወል ገአኒ ሁምነ ቶኩማ ኡመተን። ");
INSERT INTO gaze_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","እሳንስ ወጋ ኩዸ ሸን ኬዶርላኦሜር ጀለት ቡለን፤ ወጋ ኩዸ ሰደፋት ገሩ ንፍንጭለን። ");
INSERT INTO gaze_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","ወጋ ኩዸ አፉረፋት ኬዶርላኦሜሪፊ ሞቶትን እሰ ወጅን ቱረን በአኒ ወረ ሬፋዪም አሽቴሮት ቃርናይሚት፣ ወረ ዙዚም ሃምት፣ ወረ ኤሚም ሻዊ ክርያታይሚት፣ ");
INSERT INTO gaze_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","ወረ ሆርሞ ለፈ ጋረ ሴኢሪቲ ጀልቀበኒ ሀመ ኤል ጳራን ከን ገሞጂት ዽኦ ጅሩ ሰናት ሞአተን። ");
INSERT INTO gaze_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","ኤርገሲ ኦፍረ ዴብአኒ ኤን ምሽጳት ጄቹንስ ቃዴሽ ዸቀኒ ብየ ወረ አማሌቅ ሁንዳፊ ወረ አሞር ከኔን ሀዜዞን ታማር ኬሰ ጅራተን ሁምናን ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","ሞትች ሶዶም፣ ሞትች ጎሞራ፣ ሞትች አድማ፣ ሞትች ዜቦኢሚፊ ሞትች ቤላ ጄቹንስ ዞኣር በአኒ ሱሉለ ሲዲም ኬሰት ሎሉፍ ህሪረን። ");
INSERT INTO gaze_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","እሳንስ ኬዶርላኦሜር ሞቲ ኤላም፣ ትድኣል ሞቲ ሰቦታ፣ አምራፌል ሞቲ ሽኔኣሪቲፊ አርዮክ ሞቲ ኤላሳር ሎለን፤ ሞቶትን አፍረን ኩኔን ሞቶተ ሸነኒን ሞርመን። ");
INSERT INTO gaze_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","ሱሉል ሲዲም ቦለ ሌሌቲን ጉተሜ ቱሬ፤ ሞቶትን ሶዶሚፊ ሞቶትን ጎሞራስ በቀተኒ ነሞትን ቶኮ ቶኮ ቦለ ሰነ ኬሰ ቡአን፤ ወር ሀፈንሞ ገረ ጋረኒት በቀተን። ");
INSERT INTO gaze_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","ሞቶትን አፍረን ሱን ምኣፊ ኛተ ወረ ሶዶሚፊ ጎሞራ ሁንደ ሳመኒ ሶከን። ");
INSERT INTO gaze_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","ዋን ሎጥ እልም ኦቦሌሰ አብራም ሶዶም ኬሰ ጅራቻ ቱሬፍ ሞቶትን ሱን እሰሌ ቀቤኙመሳ ወጅን ቦጅአኒ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","ነምች በቀቴ በኤ ቶኮ ዹፌ ኦዱ ከነ አብራም እብርቸት ህሜ። አብራምስ ቅልጡወን መምሬ ከን ነምቸ አሞሪ ሰነ ብረ ጅራቻ ቱሬ፤ መምሬን ኩን ኦቦሌሰ ኤሽኮሊፊ ኣኔር ቱሬ፤ እሳን አብራም ወጅን ከኩ ገለኒ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","አብራም አከ ፍርሳ ቦጅአሜ ዸጌኛን ነሞተ መነሳት ዸለተኒ ሌንጅፈመን 318 ወልት ዋመቴ ህዸቺሴ ሀመ ዳኒት ፋነ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","አብራምስ እሳን ሎሉፍ ጄዼ ሀልከኒን ነሞተሳ ገርገር ቆዴ፤ ሀመ ሆባ እሼ ካበ ደማስቆት አርገምቱ ሰናትስ ፋነ ቡኤ እሳን ዸኤ። ");
INSERT INTO gaze_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","እንስ ምአ ሁንደ ዴብፈቴ፤ ፍረ ኦፊሳ ሎጢፊ ቀቤኘሳ፣ ዱበርቶታፊ ነሞተ ካንስ ዴብፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","አብራም ኬዶርላኦሜሪፊ ሞቶተ እሰ ወጅን ቱረን ሞአቴ ዴብናን ሞቲን ሶዶም ሱሉለ ሻዊ ከን ሱሉለ ሞቲ ጄዸሙ ኬሰት እሰ ስመቹ በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","መልኪሴዴቅ ሞቲን ሳሌምስ ቡዴናፊ ዳዺ ወይኒ ፍዴፍ፤ እንስ ሉበ ዋቀዮ ዋቀ ዋን ሁንዳ ኦሊ ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","እንስ አከነ ጄዼ አብራምን ኤብሴ፤ “አብራም፣ ዋቀዮ ዋቀ ዋን ሁንዳ ኦሊ፣ እሰ ሰሚፊ ለፈ ኡሜ ሰናን ሃኤብፈሙ። ");
INSERT INTO gaze_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","ዋቀዮ ዋቅን ዋን ሁንዳ ኦሊ፣ እን ዲኖተኬ ደበርሴ ሀርከኬት ኬኔ ሱን ሃኤብፈሙ።” ኤርገሲ አብራም ዋን ሁንደራ ኩዸን ኬሳ ቶኮ እሳፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","ሞቲን ሶዶምስ አብራሚን፣ “ነሞተ ና ኬኒቲ ቀቤኘሞ ኦፊኬቲ ፉዸዹ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","አብራም ገሩ ሞቲ ሶዶሚቲን አከነ ጄዼ፤ “አን ሀርከኮ ገረ ዋቀዮ፣ ዋቀ ዋን ሁንዳ ኦሊ፣ ኡማ ሰሚቲፊ ለፋት ኦል ፉዸዼ ከከዼን ጅረ፤ ");
INSERT INTO gaze_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","አከ አት፣ ‘አነቱ አብራምን ሶሮምሴ’ ህንጄኔፍ አን ዋን ከንኬ ተኤ ኬሳ ቶኮዩ፣ ፎኣ ዮካን ቴጰ እቲን ኮጴ ህዸተንዩ ህንፉዸዹ። ");
INSERT INTO gaze_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","ዋን ነሞትንኮ ኛተኒፊ ቆደ ነሞተ አነ ወጅን ዴመኒ ጄቹንስ ቆደ ኣኔር፣ ከን ኤሽኮሊቲፊ ከን መምሬ መሌ አን ኦፊኮ ሆማ ህንፉዸዹ፤ እሳን ቆደሳኒ ሃፉዸተን።” ");
INSERT INTO gaze_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","ከነ ቦዴ ዱቢን ዋቀዮ ሙልአታን ገረ አብራም ዹፌ አከነ ጄዼ፤ “ያ አብራም ህንሶዳትን፤ አን ጋቸነኬቲፊ ገቲኬ ጉድቸ።” ");
INSERT INTO gaze_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","አብራም ገሩ፣ “ያ ዋቀዮ ጎፍታ፣ ዋን አን እጆሌ ህንቀብኔፍ ነምን ቀቤኘኮ ዻሉፍ ጅሩ ኤሊኤዜር ነምቸ ደማስቆ ከነ፤ ኤጋ አት ማል ና ኬንተ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","አብራም፣ “ኩኖ አት እጆሌ ቶኮሌ ና ህንኬንኔ፤ ሆጄታን መነኮ ጅራቱ ቶኮ ኩኖ ነ ዻሉፍ ጅረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","ኩኖ ዱቢን ዋቀዮ ገረሳ ዹፌ፣ “እልመ ጉዴደኬቲቱ ዻልቱኬ ተአ መሌ ነምች ኩን ዻልቱኬ ህንተኡ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","እንስ አብራምን ገድ ባሴ፣ “ሰሚወን ኦል እላሊቲ ዮ ኡርጂወን ለካኡ ደንዴሴ ለካእ” ጄዼ። እት ፉፌስ፣ “ሰኚንኬስ አከኑመ ባይአተ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","አብራም ዋቀዮት አመኔ፤ እንስ ቀጄሉማት ለካኤፍ። ");
INSERT INTO gaze_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","እንስ፣ “አን ዋቀዮ እሰ አከ አት እሼ ዻልቱፍ ብየ ከነ ሲፍ ኬኑፍ ጄዼ ኡር ብየ ከልዶታ ኬሳ ስ ባሴዸ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","አብራም ገሩ፣ “ያ ዋቀዮ ጎፍታ፣ አን ብየ ከነ ዻሉኮ አከምትን ቤከ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","ከናፉ ዋቀዮ፣ “ጎሮምሰ ቶኮ፣ ሬኤ ቶኮፊ ኮርቤሰ ሆላ ቶኮ ከኔን ቶኮን ቶኮንሳኒ ወጋ ሰዲ ሰዲ ጉተን፣ አከሱመስ ጉጌ ቶኮፊ ጉጌ ሶኬ ቶኮ ና ፍድ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","አብራምስ ወረ ከነ ሁንደ ገረሳት ፍዴ፣ ቅጤ ለማንት ኩኩቴ፤ ወረ ቅጤ ለማንት ኩኩተመንስ ገማ ገመነ ካኤ፤ ስምብሮተ ገሩ ቅጤ ለማንት ህንኩኩትኔ። ");
INSERT INTO gaze_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","ኤርገሲ አላቲን ፎን ሰነት ገድ ቡቴ፤ አብራም ገሩ እራ አርኤ። ");
INSERT INTO gaze_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","ኡቱመ አዱን ዽኣ ጅርቱ ህርብን ጉዳን አብራምን ቀቤ፤ ኩኖ ዱከን ጉዳኒፊ ሶዳችሳን እሰረ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","ዋቀዮስ አከነ እሳን ጄዼ፤ “አከ ሰኚንኬ ብየ ከንሳ ህንተእን ኬሰት አለጋ ተኤ ወጋ ዽበ አፉርስ አችት ገርቦምፈሜ ጩንቁርፈሙ ዹጉማን ቤክ። ");
INSERT INTO gaze_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","አን ገሩ ሰበ እሳን አኩመ ገርቦታት ተጃጅለን ሰነ ነንአደበ፤ ኤርገሲሞ እሳን ቀቤኘ ጉዳ ፉዸተኒ አቺ በኡ። ");
INSERT INTO gaze_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","አት ገሩ ነጋን ገረ አቦቲኬቲ ዸቅጠ፤ በረ ዼራስ ጅራቴ አዋለምተ። ");
INSERT INTO gaze_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","ሰኚንኬ ዸሎተ አፉረፋት አስ ዴብአ፤ ጩቡን አሞሮታ አመዩ ህንጉትኔቲ።” ");
INSERT INTO gaze_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","ዮሙ አዱን ልጤ ዱከናኤትስ ኩኖ በርበዳን እብዳ ኣሩ ጉጨ ቶኮ ወጅን ሙልአቴ ፎን ኩኩተሜ ሰነ ግዱ ደርቤ። ");
INSERT INTO gaze_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","ጋፈ ሰነስ ዋቀዮ አከነ ጄዼ አብራም ወጅን ከኩ ገሌ፤ “አን ብየ ለገ ግብጢ ጀልቀቤ ሀመ ለገ ኤፍራጢስ ጉድቻት ጅሩ ከነ ሰኚኬቲፍ ነንኬነ፤ ");
INSERT INTO gaze_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","ኩንስ ብየ ቄኖታ፣ ቄኔዞታ፣ ቀድሞኖታስ፣ ");
INSERT INTO gaze_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","ከን ሄቶታ፣ ፌርዞታ፣ ሬፋይሞታ፣ ");
INSERT INTO gaze_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","አሞሮታ፣ ከነኣኖታ ግርጋሾታቲፊ ከን ዬቡሶታ ጄቹዸ።” ");
INSERT INTO gaze_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","ሶራን ኒቲን አብራም እጆሌ እሳፍ ህንዴኜ ቱርቴ። ገሩ እሼን ገርብቲ አጋር ጄዸምቱ ቶኮ ቀብድ ቱርቴ፤ አጋርስ ነመ ብየ ግብጥ ቱርቴ፤ ");
INSERT INTO gaze_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","ሶራንስ አብራሚን፣ “ኩኖ ዋቀዮ እጆሌ ነ ዾወቴረ። ዸቂቲ ገርብቲኮ ወጅን ጪስ፤ ተሪ አን ከራሼቲን እጆሌ ነንአርገዸን ተኣቲ” ጄቴ። አብራምስ ዋን ሶራን ጄቴ ፉዸቴ። ");
INSERT INTO gaze_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","ኤርገ አብራም ወጋ ኩዸን ከነኣን ኬሰ ጅራቴ ቦዴ ኒቲንሳ ሶራን ገርብቲሼ አጋር ከን ነመ ብየ ግብጥ ቱርቴ ሰነ ፉቴ አከ እሼን ኒቲሳ ታቱፍ ዽርሰሼቲፍ ኬንቴ። ");
INSERT INTO gaze_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","አብራምስ አጋር ወጅን ጪሴ፤ እሼንስ ንኡልፎፍቴ። ዮሙ አከ ኡልፎፍቴ ኦፍረት ቤክቴት ጊፍቲሼ ቱፈቹ ጀልቀብዴ። ");
INSERT INTO gaze_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","ሳራንሞ አብራሚን፣ “ሚዻ ነ ሙደቴ ከነት ስቱ ጋፈተመ። ገርብቲኮ አነቱ ቦባኬ ጀለ ሲፍ ገልቼ፤ አመ ገሩ እሼን አከ ኡልፎፍቴ ኦፍረት ቤክናን ነ ቱፈቴ። ኤጋ ዋቀዮ ሲፊ አነ ግዱት ሙርቲ ሃኬኑ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","አብራምስ፣ “ገርብቲንኬ ሀርኩመኬ ጅርት፤ ዋኑመ ፌቴ እሼ ጎዽ” ጄዼን። ሶራንስ አከ መሌ እሼ ጩንቁርስቴ፤ ከናፉ አጋር ፉለሼ ዱራ ሶክቴ። ");
INSERT INTO gaze_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","ኤርገማን ዋቀዮ ገሞጂ ኬሰት፣ ቡርቃ ብሻኒ ቶኮ ብረት አጋርን አርጌ፤ ቡርቃን ብሻኒ ሱንስ ከራ ሹርት ጌሱረ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","ኤርገማን ሱንስ፣ “ያ አጋር፣ ገርብቲ ሳራ፣ አት ኤሳ ዹፍቴ? ኤሰ ዸቁት ጅርተ?” ጄዼ። እሼንስ፣ “ጊፍቲኮ ሳራ በቀቹትን ጅረ” ጄቴን። ");
INSERT INTO gaze_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","ከነረት ኤርገማን ዋቀዮ ሱን፣ “ገረ ጊፍቲኬቲት ዴብእ፤ ገድ ኦፍ ቀቢቲ እሼፍ ቡል” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","ኤርገማን ዋቀዮ ሱንስ እት ደበሌ፣ “አን ሰኚኬ አከ መሌ ነንባይእሰ፤ ሰበቢ ባይእነሳቲፍስ ነምን ቶኮዩ ለካኡ ህንደንደኡ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","ኤርገማን ዋቀዮ ሱን አመሌ አከነ እሼን ጄዼ፤ “ኩኖ አት ኡልፎፍቴርተ፤ እልመስ ንዴሰ። መቃሳስ እሽማኤል ጄዺ ሞጋስ፤ ዋቀዮ ዽጰቹኬ ዸገኤራቲ። ");
INSERT INTO gaze_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","እን ነመ አከ ሀሬ ዲዳ ተአ፤ ሀርክሳ ነመ ሁንደረት ከአ፤ ሀርክ ነመ ሁንዳስ እሰረት ከአ፤ ኦቦሎተሳ ሁንዳንስ ጅበማ ጅራተ።” ");
INSERT INTO gaze_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","እሼንስ መቃ ዋቀዮ እሼት ዱበቴ ሰና፣ “ኤልሮኢ” ጄቴ ዋምቴ። እሼን፣ “አን ዹጉማን እሰ ነ አርጉ ሰነ አርጌረ” ጄቴርቲቲ። ");
INSERT INTO gaze_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","ሰበቢን ቦል ብሻኒ ሱን፣ “ቤኤር ለሃይሮኢ” ጄዸሜፍስ ከኑመ። እንስ ሀመ ሀርኣትሌ ቃዴሺፊ ቤሬድ ግዱ ጅረ። ");
INSERT INTO gaze_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","አጋርስ አብራሚፍ እልመ ዴሴ፤ አብራምስ እልመ እሼን ዴሴ ሰነ እሽማኤል ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","ዬሮ አጋር እሽማኤልን እሳፍ ዴሴት አብራም ነመ ወጋ ሰዴተሚ ጀኣ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","ዬሮ አብራም ነመ ወጋ ሰገልተሚ ሰገሊ ቱሬት ዋቀዮ እሰት ሙልአቴ አከነ ጄዼን፤ “አን ዋቀ ዋን ሁንዱማ ደንደኡዸ፤ አት ፉለኮ ዱረ አመነሙማን ዴዴብእ፤ ህርእነስ ህንቀባትን። ");
INSERT INTO gaze_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","አን ከኩኮ አናፊ ስ ግዱ ነንዻበ፤ ጉዳስ ስን ባይእሰ።” ");
INSERT INTO gaze_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","አብራምስ አደሳቲን ለፈት ጎምብፈሜ፤ ዋቅንስ አከነ እሳን ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“ኩኖ፣ ከኩን አን ስ ወጅን ገሉ ከነ፦ አት አባ ሰበ ባይኤ ታተ። ");
INSERT INTO gaze_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","አት ስአች አብራም ጄዸምቴ ህንዋመምቱ፤ ዋን አን አባ ሰቦተ ባይኤ ስ ታስሴፍ መቃንኬ አብረሃም ተአ። ");
INSERT INTO gaze_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","አን አከ አት ጉዳ ባይአቱ ነንጎዸ፤ አከ ሰብን ሄዱን ስ ኬሳ አርገሙ ነንጎዸ፤ ሞቶትንስ ስ ኬሳ ንአርገሙ። ");
INSERT INTO gaze_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","አን ዋቀኬቲፊ ዋቀ ሰኚኬ ከን ስ ዱባን ዹፉ ተኡፍ ጄዼ ከኩኮ አነ፣ ሲፊ ሰኚኬ ከን ስ ዱባ፣ ዸሎተ ዹፉፍ ጅሩ ግዱት ከኩ በረ በራ ጎዼ ነንዻበ። ");
INSERT INTO gaze_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","ብየ ከነኣን ጉቱ ለፈ አት አመ ኦርመ ታቴ ጅራቱ ከነ አን ዻለ በረ በራ ጎዼ ስኢፊ ሰኚወንኬ ወረ ስ ቦዴቲፍ ነንኬነ፤ አንስ ዋቀሳኒ ነንተአ።” ");
INSERT INTO gaze_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","ዋቅን አብረሃሚን አከነ ጄዼ፤ “አትሞ ከኩኮ ኤጉ ቀብደ፤ አት፣ ሰኚንኬ ወር ስ ዱባስ ዸሎተሳኒ ኬሰት ከኩኮ ኤጉ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","ከኩንኮ ከን እስን አናፊ ስእ ግዱት፣ ሰኚኬ ከን ስእ ዱባን ዹፉ ግዱትስ ኤጉ ቀብደን ከናዸ፤ እንስ እስን ኬሳ ዺር ሁንድኑ ዸግነ ሃቀበቱ። ");
INSERT INTO gaze_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","ቆለኬሰን ዸግነ ቀበዻ፤ ኩንስ ከኩ አናፊ እስን ግዱ ጅሩፍ መለቶ ተአ። ");
INSERT INTO gaze_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","እስን ኬሳ ዺር ጉያ ሰዴት ጉቴ ዸግነ ሃቀበቱ፤ ዸሎተኬሰን ሁንደ ኬሰት ዺር መነኬት ዸለቴ ዮካን ከን ነመ ብየ ኦርማራ ማለቀኬቲን ብተሜ ሁንድ ከን ሰኚኬ ህንተእን ዸግነ ሃቀበቱ። ");
INSERT INTO gaze_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","መነኬት ዸለተንስ ዮካን ማለቀኬቲን ብተመንስ እሳን ዸግነ ሃቀበተን። ከኩንኮ ከን ፎንኬሰንረት ጎዸሜ ኩን ከኩ በረ በራ ተአ። ");
INSERT INTO gaze_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","ዺር ዸግነ ህንቀበትን፣ ከን ቆለ ፎንሳ ዸግነ ህንቀበትን ከምዩ ሰበ ኦፊሳ ኬሳ በሌፈመ፤ እን ከኩኮ ጨብሴራቲ።” ");
INSERT INTO gaze_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","ዋቅን አመስ አብረሃሚን አከነ ጄዼ፤ “አት ስአች ኒቲኬ ሶራዻን፣ ሶራ ህንጄቱ፤ መቃንሼ ሳራ ተአ። ");
INSERT INTO gaze_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","አን እሼ ነንኤብሰ፤ እሼራስ እልመ ሲፍ ነንኬነ። አከ እሼን ሃዸ ሰቦታ ታቱፍስ እሼ ነንኤብሰ፤ ሞቶትን ሰቦታስ እሼ ኬሳ አርገሙ።” ");
INSERT INTO gaze_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","አብረሃምስ አዳን ጎምብፈሜ፤ ኮልፌስ፣ “ነመ ወጋ ዽባቲፍ እልም ንዸለታ? ሳራንስ ወጋ ሰገልተመት ሙጫ ዴሲ?” ጄዼ ያዴ። ");
INSERT INTO gaze_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","አብረሃምስ ዋቃን፣ “ማሎ ኡቱ እሽማኤል ፉለኬ ዱረ ና ጅራቴ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","ዋቅንስ አከነ ጄዼ፤ “ቶሌ፤ ገሩ ኒቲንኬ ሳራን እልመ ሲፍ ዴስ፤ መቃሳስ ይስሃቅ ጄዺ ሞጋስ። አንስ ከኩኮ ሰኚሳ ከን እሰ ዱባን ዹፉፍ ከኩ በረ በራ ጎዼ እሰ ወጅን ነንዻበ። ");
INSERT INTO gaze_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","ዋኤ እሽማኤልሞ አን ስ ዸገኤረ፤ ኩኖ አን፣ እሰ ነንኤብሰ፤ አከ እን ባይአቱ ነንጎዸ፤ ጉዳ እሰ ነንባይእሰ። እን አባ ቡልችቶተ ኩዸ ለማ ተአ፤ አንስ ሰበ ጉዳ እሰ ነንጎዸ። ");
INSERT INTO gaze_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","ከኩኮ ገሩ ይስሃቅ እሰ ሳራን ወጋ ዹፉ ኬሰ ዬሮ ከነት ሲፍ ዴሱ ወጅን ነንዻበ።” ");
INSERT INTO gaze_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","ዋቅን ኤርገ አብረሃም ወጅን ሃሰኤ ፍጠቴ ቦዴ እሰ ብራ ኦል በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","አብረሃምስ ጉዩመ ሰነ እልማንሳ እሽማኤሊፊ ወረ መነሳት ዸለተን ዮካን ወረ ማለቀሳቲን ብተመን ሁንደ፣ ዺረ መነሳ ሁንዱማስ ፉዼ አኩመ ዋቅን እሰት ህሜት ዸግነ ቀቤ። ");
INSERT INTO gaze_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","አብረሃም ዬሮ ዸግነ ቀበቴት ነመ ወጋ ሰገልተሚ ሰገሊ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","እልምሳ እሽማኤልሞ ዬሮ ዸግነ ቀበቴት ነመ ወጋ ኩዸ ሰዲ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","አብረሃሚፊ እልምሳ እሽማኤል ጉዩመ ሰነ ዸግነ ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","ዺር መነ አብረሃም ሁንድኑ፣ ወር መነሳት ዸለተን ዮካን ወር ኦርመራ ማለቃን ብተመንስ እሰ ወጅን ዸግነ ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","ኡቱመ አብረሃም ጉያ ሳፋዻን ቅልጡ መምሬ ብረ በልበለ ዱንካነሳ ዱረ ታኤ ጅሩ ዋቀዮ እሰት ሙልአቴ። ");
INSERT INTO gaze_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","አብረሃምስ ኦል እላሌ ነሞተ እሰ ብረ ዸዻበተን ሰዲ አርጌ። እንስ አኩመ እሳን አርጌን በልበለ ዱንካነሳ ዱራ ከኤ እሳን ስመቹዻፍ እት ፊጌ፤ ሀመ ለፈ ገኡትስ ገድ ጄዼ ሀርከ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","እንስ አከነ ጄዼን፤ “ጎፍታኮ፣ ዮ አን ስ ዱረት ፉዸተመ አርገዼ፣ ገርብቸኬ ብረ ህንደርብን። ");
INSERT INTO gaze_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","ብሻን ጥኖ እስኒፍ ሃፍደን፤ ሚለ ዽቀዻቲ ሙከ ከነ ጀለ ቦቆዻ። ");
INSERT INTO gaze_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","ኤርገ እስን ገረ ገርብቸኬሰኒ ዹፍተኒ፣ አን አከ እስን ደዸቢ ባተኒ ከራኬሰን እት ፉፍተኒፍ ዋን እስን ኛተን እስኒፍን ኬነ።” እሳንስ፣ “አኩመ ጄቴ ሰነ ጎዽ” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","ከናፉ አብረሃም ደፌ ሳራት ዱንካነ ሴኔ፣ “ደፊ ዳኩ ቡላኣ ሰፈርቱ ሰዲ ሱኩሚቲ መጥኖ ቶልች” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","እንስ ገረ ሳወኒት ፊጌ ጀቢ ገበቴ እት ቶሌ ቶኮ ፍለቴ ሆጄታ ቶኮት ኬኔ፤ ሆጄታን ሱንስ ቆጴሱፍ አሪፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","አብረሃምስ እትቱፊ ኣነን፣ ፎን ጀቢ ቆጴፈሜ ሰነስ ጌሴ እሳኒ ዽኤሴ፤ ዬሮ እሳን ኛቻ ቱረንትስ አብረሃም ሙከ ቶኮ ጀለ እሳን ብረ ዻበቻ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","እሳንስ፣ “ኒቲንኬ ሳራን ኤሰ ጅርት?” ጄዸኒ እሰ ጋፈተን። እንስ፣ “ኩኖ ዱንካነ ኬሰ ጅርት” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","እሳን ኬሳ ቶኮ፣ “አን ዹጉማን በረ ዹፉ ኬሰ ዬሮ አከናት ዴብኤ ገረኬ ነንዹፈ፤ ኒቲንኬ ሳራንስ እልመ ንዴስ” ጄዼ። ዬሮ ሰነ ሳራን በልበለ ዱንካና ከን እሰ ዱባን ጅሩ ኬሳን ዸጌፈቻ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","አብረሃሚፊ ሳራን ኡሙሪንሳኒ ዼረቴ ዱሎመኒ ቱረን፤ ሳራንስ ኡሙሪ እት ሙጫ ደኡ ደንዴሱ ደበርቴ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","ከናፉ ሳራን፣ “አን ኤርገን ጃሬ ቡቱቴ፣ ጎፍታንኮስ ኤርገ ዱሎሜ ቦዴ፣ ገመቹ ከነ ቀባቹ ነንደንደኣ?” ጄቴ ኦፍ ኬሰት ኮልፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","ከነረት ዋቀዮ አብረሃሚን አከነ ጄዼ፤ “ሳራን ማሊፍ፣ ‘አን ኤርገን ዱሎሜ ቦዴ አመ ዹጉማን ሙጫ ነንደኣ?’ ጄቴ ኮልፍቴ? ");
INSERT INTO gaze_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","ወን ዋቀዮፍ ህንደንደአምኔ ቶኮዩ ጅራ? አን በረ ዹፉ ኬሰ ዬሮ ሙርቴፈሜት ዴብኤ ገረኬ ነንዹፈ፤ ሳራንስ እልመ ንዴስ።” ");
INSERT INTO gaze_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","ሳራንስ ዋን ሶዳቴፍ ሶብዴ፣ “አን ህንኮልፍኔ” ጄቴ። እን ገሩ፣ “ለኪ ኮልፍቴርታ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","ነሞትን ሱን ዮሙ ዴሙፍ ከአንት ገረ ሶዶም ገድ እላለን፤ አብረሃምስ እሳን ጌጌሱፍ ጄዼ እሳን ወጅን በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","ኤርገሲ ዋቀዮ አከነ ጄዼ፤ “አን ዋነን ጎቹፍ ጅሩ አብረሃምን ነንዾክሳ? ");
INSERT INTO gaze_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","አብረሃም ዹጉማን ሰበ ጉዳፊ ጀባ ተአ፤ ሰብን ለፈራ ሁንድኑ ከራሳቲን ኤብፈመ። ");
INSERT INTO gaze_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","አከ እን እጆሌሳቲፊ ሰኚሳ ወረ እሰ ዱባን ዹፈን፣ አከ እሳን ዋን ቀጄላፊ ስሪ ተኤ ሆጄቹዻን ከራ ዋቀዮ ኤገን አጀጁፍ አን እሰ ፍለዼራቲ፤ ኩንስ አከ ዋቀዮ ዋን አብረሃሚፍ ከከቴ ሰነ እሳፍ ጉቱፍ።” ");
INSERT INTO gaze_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","ዋቀዮስ አከነ ጄዼ፤ “እይ ሶዶሚፊ ጎሞራረት እየሜ ጉዳዸ፤ ጩቡንሳኒስ ዋን አከ መሌ ሀማ ተኤፍ ");
INSERT INTO gaze_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","አን ገድ ቡኤ አከ ወን እሳን ሆጄተን አኩመ እየ ነ ቀቀቤ ሰና ሀማ ተኤ ነንእላለ። ዮ አከስ ተኡ ባቴሞ ነቱ ቤከ።” ");
INSERT INTO gaze_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","ነሞትን ሱንስ ገረ ገለኒ ሶዶምት ቀጄለን፤ አብረሃም ገሩ ዋቀዮ ዱረ ዻበቴ ሀፌ። ");
INSERT INTO gaze_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","አብረሃምስ እሰት ዽኣቴ አከነ ጄዼ፤ “አት ነመ ቀጄላ ነመ ጀልኣ ወጅን ንበሌስታ? ");
INSERT INTO gaze_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","ዮ ነሞትን ቀጄሎን ሸንተምን መጋለቲ ኬሰ ጅራተንሆ? አት ዹጉማን እሼ ንበሌስታ? ሰበቢ ቀጄሎተ ሸንተመን እሼ ኬሰ ጅራተን ሰናቲፍ ጄቴ እሼ ህንኦልችቱ? ");
INSERT INTO gaze_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","ቀጄላፊ ሀማ ወል ቅጤ እላሉዻን ነመ ቀጄላ ነመ ሀማ ወጅን በሌሱን ስራ ሃፈጋቱ። ኩን ስራ ሃፈጋቱ! አባን ሙርቲ ለፈ ሁንዳ ዋን ቀጄላ ህንሆጄቱ?” ");
INSERT INTO gaze_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","ዋቀዮስ፣ “አን ዮ መጋላ ሶዶም ኬሰት ቀጄልቶተ ሸንተመ አርገዼ፣ እሳኒፍ ጄዼ እዶ ሰነ ጉቱ ነንኦልቸ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","አብረሃም አመስ አከነ ጄዼ፤ “ኩኖ አን ኡቱመን አዋራፊ ዳራ ተኤ ጅሩ ጎፍታት ዱበቹፍ እጀ ጀባዼረ፤ ");
INSERT INTO gaze_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","ዮ ባይእን ቀጄልቶታ ሸንተመራ ሸን ህርአቴሆ? አት ሰበቢ ነሞተ ሸነን ሰናቲፍ ጄቴ መጋላ ሰነ ጉቱ ንበሌስታ?” እንስ፣ “አን ዮ ነመ አፉርተሚ ሸን አችት አርገዼ እሼ ህንበሌሱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","አብረሃም አመሌ፣ “ዮ ቀጄልቶትን አፉርተምን ቆፍት አችት አርገመንሆ?” ጄዼ እሰት ዱበቴ። ጎፍታንስ፣ “አን ወረ አፉርተመ ሰናፍ ጄዼ ነንዺሰ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","አብረሃምስ፣ “ሜ ነንዱበዻቲ ጎፍታን፣ ህንኣርን። ዮ ነሞትን ሶዶምን ቆፍት አችት አርገመንሆ?” ጄዼ። ጎፍታንስ፣ “አን ዮን ነመ ሶዶመ አችት አርገዼ እሼ ህንበሌሱ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","አብረሃምስ፣ “ኩኖ አመ ኤርገ አን ጎፍታት ዱበቹፍ እጀ ጀባዼ፣ ዮ ነሞትን ድግደምን ቆፍት አችት አርገመንሆ?” ጄዼ። ጎፍታንስ፣ “አን ሰበቢ ነሞተ ድግደመ ሰናቲፍ ጄዼ እሼ ህንበሌሱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","አብረሃምስ፣ “ያ ጎፍታ አመሌ ዬሮ ቶኮ ዋ ስን ጋፈዻቲ ማሎ ህንኣርን፤ ዮ ነምን ኩዸን ቆፍት አችት አርገሜሆ?” ጄዼ። ጎፍታንሞ፣ “አን ሰበቢ ነሞተ ኩርነን ሰናቲፍ ጄዼ እሼ ህንበሌሱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","ዋቀዮስ ኤርገ አብረሃም ወጅን ዱበቴ ፍጤ ቦዴ አቺ ዴሜ። አብረሃምሞ እዶ ኦፊሳት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","ኤርገሞትን ዋቀዮ ሱን ለማን ገልገለ ሰነ ሶዶም ገአን፤ ሎጥስ ከረ ሶዶሚ ዱረ ታኣ ቱሬ። እንስ ዬሮ ጀረ አርጌት፣ እሳን ስመቹፍ ከኤ እሳንት ዴሜ፤ ገድ ጄዼስ አደሳቲን ለፈት ጎምብፈሜ። ");
INSERT INTO gaze_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","እንስ፣ “ያ ጎፍቶተኮ፣ ማሎ መነ ገርብቸኬሰኒት ጎራቲ ሚለ ዽቀዻ ቡላ፤ በሪ በራቃን ካተኒ ከራኬሰን እት ፉፉ ደንዴሱ” ጄዼ። እሳንሞ፣ “ህንተኡ፤ ኑ ወልተጂ ከራረ ቡላ” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","እን ገሩ አከ መሌ እሳን ድርቅሲሴ፤ ከናፉ ጎረኒ መነሳ ሴነን፤ እንስ መጥኖ ቶልቼ ኛተ ቆጴሴፍ፤ እሳንስ ንኛተን። ");
INSERT INTO gaze_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","ኡቱ እሳን ህንረፍን ነሞትን ኩታሌ መጋላ ሶዶም ሁንደ ኬሳ ዹፈን ሁንድ ደርገጎትኒፊ ጃርሶሊን መነ ሰነ መርሰን። ");
INSERT INTO gaze_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","እሳንስ ሎጥን ዋመኒ፣ “ነሞትን ገልገለ ከነ ገረኬ ዹፈን ኤሰ ጅሩ? አከ ኑ እሳን ወጅን ጪፍኑፍ ገድ ኑ ያስ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","ሎጥስ ጀረ ሰነት ገድ በኤ በልበለ ኦፍ ዱባን ጩፌ፤ ");
INSERT INTO gaze_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","አከነስ ጄዼ፤ “ያ ኦቦሎተኮ፣ ዋን ሀማ ከነ ህንሆጄትና! ");
INSERT INTO gaze_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","ኩኖ አን እንተለን ለመ ከኔን ተኩማ ዺረ ወጅን ህንጪስን ቀበ። ለማኑ ገድ እስኒ ነንባሰ፤ እስንስ ዋን ፌተን እሳን ጎቹ ደንዴሱ። ነሞተ ከኔን ገሩ ዋን እሳን በንቲ መነኮ ጀለ ጅረኒፍ ሆማ እሳን ህንጎዽና።” ");
INSERT INTO gaze_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","እሳንስ፣ “በድ አሲ!” ጄዸኒን። እቱመ ፉፈኒስ፣ “ነምች ኩን ነመ ኦርማ ከን ኑ ኬሰ ጅራቹ ዹፌዸ፤ አመሞ አባ ሙርቲ ኑት ተኡ ፌዸ! ኑ ዋን ሀማ ጀረረት ሆጄትኑ ጫላ ስረት ሆጄትነ” ጄዸኒን። እሳንስ ሎጥን ሁምናን ዺበኒ በልበለ ሰነ ጨብሱ ገአን። ");
INSERT INTO gaze_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","ነሞትን ሱንስ ሂጠተኒ ሎጥን ሀርክሰኒ መነት ኦል ዴብሰን፤ በልበልቸስ ንጩፈን። ");
INSERT INTO gaze_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","ኤርገሲሞ ነሞተ በልበለ መና ዱረ ቱረን ሰነ አከ እሳን በልበልቸ ህንአርግኔፍ ጥናፊ ጉዳሳኒ ዸእቻን እጀ ጃምሰን። ");
INSERT INTO gaze_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","ነሞትን ለማን ሱን ሎጢን አከነ ጄዸን፤ “አት ነመ ብራ ቶኮሌ ጄቹንስ ሶዶተ፣ እልማን ዮካን እንተለን ዮካን ነመ ከንኬ ተኤ ቶኮሌ መጋላ ከነ ኬሳ ቀብዳ? አስ ኬሰ እሳን ባፈዹ፤ ");
INSERT INTO gaze_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","ኑ እዶ ከነ በሌሱፍ ዴምናቲ። ሰበቢ እይ ሰበሼረት እየሜ ፉለ ዋቀዮ ዱረት ጉዳ ተኤፍ፣ ዋቅን አከ ኑ እሼ በሌስኑፍ ኑ ኤርጌረ።” ");
INSERT INTO gaze_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","ከናፉ ሎጥ ገድ በኤ ሶዶተሳ ወረ እንተለንሳ ፉዹፍ ጅረኒን፣ “ሰበቢ ዋቀዮ መጋላ ከነ በሌሱፍ ከኤፍ፣ ደፋቲ አሲ በኣ!” ጄዼ። ሶዶንሳ ገሩ ዋን እን ቆሱ ሴአን። ");
INSERT INTO gaze_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","ዬሮ ቦሩን ዲመቴት ኤርገሞትን ዋቀዮ ሱን ሎጥን ጀርጀርሰኒ፣ “ኒቲኬቲፊ እንተለንኬ ለማን አስ ጅረን ፉዸዹቲ ደፊ በእ! ዮ ከና አቺ ዬሮ መጋለቲን አደበምቱት አትስ ንበዳ” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","እን ገሩ ዱበት ሀርክፈቴ፤ ዋን ዋቀዮ እሳኒፍ ገራ ላፌፍ ነሞትን ሱን ሀርከሳቲፊ ሀርከ ኒቲሳ፣ እንተለንሳ ለማንስ ሀርከ ቀበኒ መጋለቲ ኬሳ እሳን ባሰን። ");
INSERT INTO gaze_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","አኩመ ገድ እሳን ባሰኒንስ ኤርገሞተ ሰነ ኬሳ እን ቶኮ፣ “ሉቡኬ ኦልፈቹፍ በቀዹ! ኦፍ ዱበ ህንምልአትን! ድሬረ እዶ ቶኮሌ ህንዻበትን! ቱሉወንት ኦል በቀዹ፤ ዮ ከና አቺ ንበዳ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","ሎጥ ገሩ አከነ እሳኒን ጄዼ፤ “ያ ጎፍቶተኮ፣ ማሎ አከስ ምት! ");
INSERT INTO gaze_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ኩኖ ገርብችኬ ፉለኬ ዱረት ፉዸተመ አርገቴረ፤ አት ሉቡኮ ኦልችቴ ገረ ላፍነ ጉዳ ነ አርግሲፍቴርተ። አን ገሩ ገረ ቱሉት ኦል በቀቹ ህንደንደኡ፤ በላን ኩን ነ አርገተ፤ አንስ ነንዱአ። ");
INSERT INTO gaze_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","ኩኖ፣ መጋላን እት በቀቹን ደንደአሙ ቶኮ አስ ዽኦ ጅርት፤ እሼን ጥኖዸ። አን ገረሼት ነንበቀዸ፤ እሼን ባይኤ ጥኖዸ ምቲ? አከስት ሉቡንኮ ንበራረምት።” ");
INSERT INTO gaze_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","ኤርገማን ሱንስ አከነ ጄዼን፤ “ኩኖ፣ አን ከዻ ከነ ሲፍ ነንዸገአ፤ መጋላ አት ዋኤሼ ዱበቱ ከነ አን ህንበሌሱ። ");
INSERT INTO gaze_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","ገሩ ሰበቢ አን ሀመ አት አች ጌሱት ሆማ ጎቹ ህንደንዴኜፍ ደፊ አችት በቀዹ!” ወን መጋላን ሱን ዞኣር ጄዸምቴፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","ዬሮ ሎጥ ዞኣር ገኤት አዱን ባቴ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","ዋቀዮ ሰሚወን ኬሳ ዋቀዮ ብራ፣ ድኚ ቦበኡ ሶዶሚፊ ጎሞራረት ሮብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","እንስ አከሲን መጋላወን ከኔኒፊ ድሬወን ሰነ ጉቱ፣ ወረ መጋላወን ሰነ ኬሰ ጅራተን ሁንዳፊ ብቅልቱ ብየ ሰና በሌሴ። ");
INSERT INTO gaze_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","ኒቲን ሎጥ ገሩ ኦፍ ዱበ እላልቴ ኡቱባ ሶግዳ ታቴ ሀፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","አብረሃምስ ጉያ እት ኣኑ ገነመ ኦቦሮን ከኤ እዶ ዱራን ፉለ ዋቀዮ ዱረ ዻበቻ ቱሬ ሰነት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","እንስ ገረ መጋላወን ሶዶሚፊ ጎሞራ፣ ገረ ለፈ ድሬ ሰና ሁንዳስ እላሌ ኣረ አከ ኣረ ቦለ እብዳ ኬሳ በኡ ቶኮሳ ብየ ሰነ ኬሳ ኦል ከኡ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","ዋቅን ዬሮ መጋላወን ድሬ ሰና በሌሴት አብረሃምን ያደቴ፤ ከናፉ ዮሙ መጋላወን ሎጥ ኬሰ ጅራቻ ቱሬ በሌሴት ሎጥን በላ ሰነ ኬሳ ባሴ። ");
INSERT INTO gaze_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","ሎጥ ዋን ዞኣር ኬሰ ጅራቹ ሶዳቴፍ እንተለንሳ ለማን ወጅን ዞኣሪ በኤ ጋረንረ ቁበቴ። እንስ እንተለንሳ ለማን ወጅን ሆልቀ ቶኮ ኬሰ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","ጋፍ ቶኮ እንተልሳ እሼን ሀንገፍት እሼ ቁጥሱዻን አከነ ጄቴ፤ “አባንኬኘ ዱሎሜረ፤ አከ በርቴ ለፈ ሁንደረ ጅሩት ዺር ኑ ወጅን ጪሱ ቶኮዩ ናኖ ከነ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","ኮቱ ሜ አባኬኘ ዳዺ ወይኒ ኦባስኔ እሰ ወጅን ጪፍና፤ አከሲን ሰኚን አባኬኛ ለፈረት አከ ሀፉ ጎነ።” ");
INSERT INTO gaze_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","እሳንስ ሀልከን ሰነ አባሳኒ ዳዺ ወይኒ ኦባሰን፤ እንተል እሼን ሀንገፍት ኦል ሴንቴ እሰ ወጅን ጪፍቴ። እን ዬሮ እሼን ጪስቴ ዮካን ዬሮ እሼን ካቴ ህንቤክኔ። ");
INSERT INTO gaze_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","ጉያ እት ኣኑት እንተል ሀንገፍት እሼ ቁጥሱዻን አከነ ጄቴ፤ “ኩኖ አን ኤደ አባኮ ወጅን ጪሴረ። ኮቱ ኤደነስ ዳዺ ወይኒ እሰ ኦባስና፤ አትስ ኦል ሴኒ እሰ ወጅን ጪስ፤ አከስት ሰኚን አባኬኛ አከ ሀፉ ጎነ።” ");
INSERT INTO gaze_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","እሳን ሀልከን ሰነስ አባሳኒ ዳዺ ወይኒ ኦባሰን፤ እንተል ቁጥሱን ዸቅጤ እሰ ወጅን ጪስቴ። እን አመስ ዬሮ እሼን ጪስቴ ዮካን ዬሮ እሼን ካቴ ህንቤክኔ። ");
INSERT INTO gaze_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","አከሲን እንተለን ሎጥ ለማኑ አባሳኒቲፍ ኡልፋአን። ");
INSERT INTO gaze_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","እንተል እሼን ሀንገፍት እልመ ዴሴ መቃሳ ሞኣብ ጄቴ ሞጋፍቴ። እን አባ ሞኣቦተ ሀርኣት። ");
INSERT INTO gaze_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","እንተል እሼን ቁጥሱንስ እልመ ዴሴ መቃሳ ቤን-አሚ ጄቴ ሞጋፍቴ፤ እንሞ አባ አሞኖተ ሀርኣት። ");
INSERT INTO gaze_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","አብረሃም አቺ ከኤ ኔጌብት ጎዳኔ ቃዴሺፊ ሹር ግዱ ጅራቴ። እንስ ዬሮዻፍ ጌራራ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","አችትስ አብረሃም፣ “እሼን ኦቦሌቲኮት” ጄዼ ዋኤ ኒቲሳ፣ ዋኤ ሳራ ዱበቴ። አቢሜሌክ ሞቲን ጌራራስ ነመ እት ኤርጌ ሳራ ፉዸቴ። ");
INSERT INTO gaze_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","ዋቅንሞ ሀልከን አብጁዻን አቢሜሌክት ዹፌ፣ “ኩኖ ሰበቢ ዱበርቲ ሰነ ፉዸቴፍ አት ነመ ዱኤዸ፤ እሼን ዽርሰ ቀብዲቲ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","አቢሜሌክ ገሩ እሼት ህንዽኣትኔ ቱሬ፤ ከናፉ እን አከነ ጄዼ፤ “ያ ጎፍታ አት ሰበ ቀጄላ በሌስታ? ");
INSERT INTO gaze_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","እን መታንሳ፣ ‘እሼን ኦቦሌቲኮት’ ናን ህንጄኔ? እሼንስ አከሱመ፣ ‘እን ኦቦሌሰኮት’ ህንጄኔ? አንስ ሰሙ ቁልቁሉፊ ሀርከ ቁልቁሉዻን ዋን ከነ ሆጄዼ።” ");
INSERT INTO gaze_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","ዋቅን አብጁ ሰነ ኬሰ አከነ እሳን ጄዼ፤ “ኤዬ! አን አከ አት ሰሙ ቁልቁሉዻን ዋን ከነ ሆጄቴ ቤከ፤ ከናፉ አን አከ አት ጩቡ ነት ህንሆጄትኔፍ ስ ዾዌን ጅረ። ሰበቢን አን አከ አት እሼ ብረ ጌሱ ስ ህንዺስኒፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","ኤጋ አመ ኒቲ ነምቻ ዴብሲፍ፤ እን ዋን ራጂ ተኤፍ፣ ዋቀ ሲፍ ከዸተ፤ አትስ ንጅራተ። ገሩ ዮ እሼ ዴብሱ ባቴ፣ አት አከ ዱቱ፣ ወር ከንኬ ተአን ሁንድስ አከ ዱአን ዹጉማን ቤክ።” ");
INSERT INTO gaze_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","አቢሜሌክ ጉያ እት ኣኑ ገነመ ኦቦሮን ከኤ ቆንዳልቶተሳ ሁንደ ወልት ዋሜ ዋን ተኤ ሁንደ እሳንት ህሜ፤ እሳንስ አከ መሌ ሶዳተን። ");
INSERT INTO gaze_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","አቢሜሌክስ አብረሃምን ኦፍት ዋሜ አከነ ጄዼን፤ “አት ማሊፍ አከነ ኑ ጎቴ? አን ማል ስ ጎናን አት ጩቡ ጉዳ አከና አናፊ ሞቱማኮት ፍዴ? አት ዋን ነምን ህንሆጄትኔ አነት ሆጄቴ።” ");
INSERT INTO gaze_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","አቢሜሌክስ “አት ማሊፍ ዋን ከነ ሆጄቴ?” ጄዼ አብረሃምን ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","አብረሃምሞ አከነ ጄዼ ዴብሴ፤ “አን፣ ‘ብየ ከነ ኬሰ ዹጉማን ዋቀ ሶዳቹን ህንጅሩ፤ እሳን ሰበቢ ኒቲኮቲፍ ጄዸኒ ነ አጄሱ’ ጄዼን ያዴ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","ተኡስ እሼን ዹጉማን ኦቦሌቲኮት፤ ዮ ሃዸኮራ ዸለቹ ባቴዩ እሼን እንተሉመ አባኮት፤ እሼንስ ኒቲኮ ታቴ። ");
INSERT INTO gaze_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","አንስ ዬሮ ዋቅን መነ አባኮቲ ነ ባሴ ሰነ እሼዻን፣ ‘ሃል አት እቲን ጃለለ ናፍ ቀብዱ ሙልእፍቱ ከናዸ፤ ለፈ ኑ ዸቅኑ ሁንዱማት፣ “እን ኦቦሌሰኮት” ጄዺቲ ዋኤኮ ዱበዹን’ ጄዼ።” ");
INSERT INTO gaze_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","አቢሜሌክ ኤርገሲ ሆላፊ ሎን፣ ገርቦተ ዺራፊ ነዼኒ ፍዴ አብረሃሚፍ ኬኔ፤ ኒቲሳ ሳራስ ንዴብሴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","አቢሜሌክስ፣ “ኩኖ ብይኮ ፉለኬ ዱረ ጅረ፤ እዱመ ፌቴ ጅራዹ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","ሳራዻንስ፣ “ኩኖ አን ሜቲ ሰቅሊ ኩመ ቶኮ ኦቦሌሰኬቲፍን ኬነ። ኩንስ አከ ዹጋ ቀባቹንኬ ፉለ ወረ ስ ወጅን ጅረኒ ዱረት ቤከሙፍ፤ አት ጉቱማን ጉቱት ዹጋ አርገቴርተ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","አብረሃምስ ዋቀ ከዸቴ፤ ዋቅንሞ አቢሜሌክ፣ ኒቲሳቲፊ ገርቦተሳ ዱበርቶተ ፈይሴ፤ እሳንስ እጆሌ ጎዸተን። ");
INSERT INTO gaze_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","ዋቀዮ ሰበቢ ኒቲ አብረሃም ሰበቢ ሳራቲፍ ጄዼ ገደሜሰ ዱበርቶተ መነ አቢሜሌክ ጅራተኒ ሁንደ ጩፌ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","ዋቀዮ አኩመ ዱበቴ ሰነ ሳራ ያደቴ፤ ዋቀዮ ዋን ዋዳ ገሌፍ ሰነ ንራወቴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","ሳራን ኡልፎፍቴ በረ ዱሉመሳ ኬሰ ዬሩመ ዋቅን ዋዳ እሳፍ ሴኔ ሰነት አብረሃሚፍ እልመ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","አብረሃምስ እልመ ሳራን እሳፍ ዴሴ ሰነ ይስሃቅ ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","አብረሃም አኩመ ዋቅን እሰ አጀጄ ሰነት ይስሃቅ ዸለቴ ጉያ ሰዴትት ዸግነ እሰ ቀቤ። ");
INSERT INTO gaze_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","ዬሮ እልምሳ ይስሃቅ ዸለቴፍት አብረሃም ነመ ወጋ ዽባ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","ሳራንስ፣ “ዋቅን ኮልፈ ና ኬኔረ፤ ነምን ዋን ከነ ዸገኡ ሁንድስ ነ ወጅን ኮልፈ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","እቱመ ፉፍቴስ፣ “ስላ ኤኙቱ አብረሃሚን፣ ‘ሳራን ዳእመ ሆስስት’ ጄዸ ቱሬ? ገሩ አን በረ ዱሉመሳ ኬሰ እልመ ነንደኤፍ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","ሙጭች ጉደቴ ሀርመ ጉፈሜ፤ አብረሃም ጋፈ ይስሃቅ ሀርመ ጉፈሜ ሰነ ጭዸ ጉዳ ቆጴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","ሳራን ገሩ ዬሮ እልም አጋር ግብጥቲን አብረሃሚፍ ዴሴ ሱን ይስሃቅት ቆሱ አርግቴ፤ ");
INSERT INTO gaze_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","እሼንስ አብረሃሚን፣ “ገርብቲ ከናፊ እልመሼ አርእ፤ እልም ገርብቲ ከና ኩን እልመኮ ይስሃቅ ወጅን ህንዻሉቲ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","ወን ኩንስ ሰበቢ እልመሳቲፍ አብረሃምን አከ መሌ ረክሴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","ዋቅን ገሩ አከነ ጄዼን፤ “ዋኤ ገርብቲኬቲቲፊ ዋኤ ሙጭቻ ህንያደእን። ሰበቢ ሰኚንኬ ይስሃቂን ሲፍ ዋመሙፍ ዋን ሳራን ሲን ጄቱ ሁንደ ዸገእ። ");
INSERT INTO gaze_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","እን ሰኚኬ ዋን ተኤፍ አን እልመ ገርብቲ ሰና ሰበ ነንታስሰ።” ");
INSERT INTO gaze_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","አብረሃምስ ጉያ እት ኣኑ ገነመ ኦቦሮን ከኤ ኛተ ሙራሳፊ ብሻን ቀልቀለ ቶኮ ፉዼ አጋሪፍ ኬኔ። ዋን ከነስ ገቲቲሼረ ካኤፊ ሙጫ ወጅን አርኤ፤ እሼንስ አቺ ባቴ ገሞጂ ቤርሼባ ኬሰ ጆርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","ዮሙ ብሻን ቀልቀለ ኬሳ ዹሜት፣ እሼን ሙጫሼ ደገለ ቶኮ ጀለ ኬሴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","እሼንስ፣ “ሙጫ ከነ እሳ ዱኡ አን ህንእላሉ” ጄቴ ገራሼት ዋን ያዴፍ ገረ ደርበ ጥያ ቶኮ ጥኖ አች ሂቅጤ ናኖሳ ቴሴ፤ አች ቴሴስ ሰገሌሼ ኦል ፉዸቴ ቦሴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","ዋቅን ቦእቸ ሙጭቻ ንዸገኤ፤ ኤርገማን ዋቀዮ ሰሚ ኬሳ አጋርን ዋሜ አከነ ጄዼን፤ “ያ አጋር አት ማል ታቴ? ህንሶዳትን፤ ዋቅን ቦእቸ ሙጭቻ እዶ እን ጪሴ ጅሩ ዸገኤራቲ። ");
INSERT INTO gaze_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","ሰበቢ አን ሰበ ጉዳ እሰ ጎዹፍ ከኢቲ ሀርከኬቲን ሙጭቸ ኦል ፉዽ፤ ጀቤሲቲ እሰ ቀብ።” ");
INSERT INTO gaze_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","ዋቅን እጀሼ በኔፊ ጄናን ቦለ ብሻኒ ቶኮ አርግቴ። ከናፉ ዸቅጤ ቀልቀለ ሰነ ብሻኒን ጉቴ፣ ዋን እን ዹጉ ሙጭቻፍ ኬንቴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","ዋቅንስ ሙጭቸ ወጅን ቱሬ፤ ሙጭችስ ንጉደቴ። እንስ ገሞጂ ኬሰ ጅራቴ፤ ጥየ ደርበቹዻንስ ቤከማ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","እንስ ገሞጂ ጳራን ኬሰ ጅራቴ፤ ሃትሳስ ብየ ግብጢቲ ኒቲ አርገቴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","ዬሮ ሰነ አቢሜሌኪፊ ፊኮል አጀጃን ሎልቶተሳ አብረሃሚን አከነ ጄዸን፤ “ዋን አት ሆጄቱ ሁንደ ኬሰት ዋቅን ስ ወጅን ጅረ። ");
INSERT INTO gaze_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","አት አከ አነ ዮካን እጆሌኮ ዮካን ሰኚኮ ህንጎዎምስኔ አመ አስ ፉለ ዋቃ ዱረት ና ከከዹ። አኩመ አን ገራ ሲፍ ላፌ ሰነ አትስ አናፊ ብየ አመ ኦርመ ታቴ ኬሰ ጅራቱ ከናፍ ገራ ላፍ።” ");
INSERT INTO gaze_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","አብረሃምስ፣ “አን ነንከከዸ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","ኤርገሲ አብረሃም ዋኤ ቦለ ብሻኒ ገርቦን አቢሜሌክ እሰራ ፉዸተን ቶኮ አቢሜሌክት ህመቴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","አቢሜሌክሞ፣ “አን ነመ ዋን ከነ ሆጄቴ ህንቤኩ። አትስ ነት ህንህምኔ፤ አን ዋኤሳ ሀርኡመን ዸገኤ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","ከናፉ አብረሃም ሆላፊ ሎን ፍዴ አቢሜሌኪፍ ኬኔ፤ ጀር ለማንስ ወሊ ገልቴ ኡመተን። ");
INSERT INTO gaze_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","አብረሃም ጎሮሚ ሆላ ቶርበ ቡሻዬ ኬሳ ኮጳት ባሴ፤ ");
INSERT INTO gaze_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","አቢሜሌክስ፣ “ሂካን ጎሮሚ ሆላ ቶርበን አት ኮጳሳኒ ባፍቴ ከኔኒ ማል?” ጄዼ አብረሃምን ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","አብረሃምስ፣ “አከ አን ቦለ ብሻኒ ከነ ቆተዼ አከ ረጋ ተኡፍ፣ ጎሮሚ ሆላ ቶርበን ከኔን ነ ሀርካ ፉዸዹ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","ሰበቢ ጀር ለማን ሱን አችት ወሊ ከከተኒፍ እዶን ሱን ቤርሼባ ጄዸሜ ዋመሜ። ");
INSERT INTO gaze_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","ኤርገ ወሊ ገልቴን ሱን ቤርሼባት ተኤ ቦዴ አቢሜሌኪፊ ፊኮል አጀጃን ሎልቶተሳ ገረ ብየ ፍልስጤሞታት ዴብአን። ");
INSERT INTO gaze_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","አብረሃምስ ቤርሼባ ኬሰ ሙከ ተምሪ ዻቤ፤ እንስ አችት መቃ ዋቀዮ ዋቀ በረ በራ ዋመቴ። ");
INSERT INTO gaze_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","አብረሃም ብየ ፍልስጤሞታ ኬሰ በረ ዼራ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","ዬሮ ሙራሰ ቦዴ ዋቅን አብረሃምን ቆሬ። እንስ፣ “አብረሃም!” ጄዼ እሰ ዋሜ። አብረሃምስ፣ “ኩኖ አሰን ጅረ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","ዋቅንስ አከነ ጄዼን፤ “እልመኬ ይስሃቅ፣ እልመኬ ቶክቸ እሰ ጃለቱ ሰነ ፉዺቲ ብየ ሞርያ ዸቅ። ቱሉ አን ስት ህሙረት ቀልመ ጉበሙ ጎዺቲ እሰ ዽኤስ።” ");
INSERT INTO gaze_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","አብረሃምስ ጉያ እት ኣኑ ገነመ በራቃን ከኤ ሀሬሳ ፌአቴ። እንስ ሆጄቶተሳ ኬሳ ነመ ለማፊ እልመሳ ይስሃቅን ፉዸቴ ቆራን ቀልመ ጉበሙፍ ገኡ ጨብሰቴ ገረ እዶ ዋቅን እሰት ህሜ ሰናት ቀጄሌ። ");
INSERT INTO gaze_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","ጉያ ሰደፋትስ አብረሃም ኦል እላሌ እዶ ሰነ ፈጎት አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","እንስ ሆጄቶተሳቲን፣ “እስን ሀሬ ወጅን አሱመ ቱራ። አኒፊ ሙጭች ዱበ ሰነ ዸቅና፤ አችትስ ዋቄፈትኔ ገረኬሰንት ዴብና” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","አብረሃምስ ቆራን ኣርሳ ጉበሙፍ ተኡ ፉዼ እልመሳ ይስሃቅን ባችሴ፤ ኦፊሳቲሞ እብዳፊ ብላ ሀርከት ቀበቴ። እሳን ለማን ኡቱ ወሉማን ዴማ ጅረኑ፣ ");
INSERT INTO gaze_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","ይስሃቅ፣ “ያ አባኮ” ጄዼ አባሳ አብረሃምት ዱበቴ። አብረሃምስ፣ “አሰን ጅረ እልመኮ” ጄዼ ዴብሴ። ይስሃቅስ ዴብሴ፣ “እብዲፊ ቆራን ኩኖት፤ ሆላን ቀልመ ጉበሙፍ ተኡሞ ኤሰ ጅረ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","አብረሃምስ ዴብሴ፣ “ያ እልመኮ፣ ዋቅን መታንሳ ሆላ ቀልመ ጉበሙፍ ተኡ ንኬነ” ጄዼ። እሳን ለማንስ ወሉማን ከራሳኒ እት ፉፈን። ");
INSERT INTO gaze_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","ዬሮ እዶ ዋቅን እሰት ህሜ ሰነ ገአንት፣ አብረሃም እዶ ኣርሳ አችት እጃሬ እዶ ኣርሳ ሰነረ ቆራን ነቄ፤ እልመሳ ይስሃቅን ህዼስ እዶ ኣርሳ ሰነረ ቆራን ጉባ ጪብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","ኤርገሲ እን እልመሳ ቀሉፍ ጄዼ ሀርከሳ ሂጠቴ ብላ ፉዸቴ። ");
INSERT INTO gaze_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","ኤርገማን ዋቀዮ ገሩ፣ “አብረሃም! አብረሃም!” ጄዼ ሰሚ ኬሳ እሰ ዋሜ። አብረሃምስ፣ “ኩኖ አሰን ጅረ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","እንስ፣ “አት ሀርከኬቲን ጉርብቸ ህንቱቅን፤ ዋን ቶኮሌ እሰ ህንጎዽን። ዋን አት እልመኬ፣ እልሙመ ቶክቸ አናፍ ጄቴ ህንመረርፈትኒፍ፣ አን አከ አት ዋቀ ሶዳቱ አመ ቤኬረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","አብረሃምስ ኦል እላሌ ኩኖ ኮርቤሰ ሆላ ከን ጋንፍሳ ደገለ ኬሰት ቀበሜ ጅሩ ቶኮ አርጌ፤ እንስ ዸቄ ሆላ ሰነ ፉዼ ቆደ እልመሳ ቀልመ ጉበሙ ጎዼ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","ከናፉ አብረሃም እዶ ሰነ “ዋቀዮ ንኬነ” ጄዼ ሞጋሴ፤ ሀመ ሀርኣትሌ፣ “ቱሉ ዋቀዮረት፣ ንኬነመ” ጄዸመ። ");
INSERT INTO gaze_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","ኤርገማን ዋቀዮ ሱንስ ሰሚ ኬሳ ለመተ አብረሃምን ዋሜ ");
INSERT INTO gaze_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","አከነ ጄዼን፤ “ዋቀዮ አከነ ጄዸ፤ ሰበቢ አት ዋን ከነ ጎቴፊ እልመኬ፣ እልሙመኬ ቶክቸሌ ነ ህንዾወትኒፍ አን መቃኮቲን ነንከከዸ፤ ");
INSERT INTO gaze_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","አን ዹጉማን ኤበ፣ ስን ኤብሰ፤ ሰኚኬስ አኩመ ኡርጂ ሰሚቲፊ አኩመ ጭረቸ ቀርቀረ ገላና ነንባይእሰ። ሰኚወንኬስ መጋላወን ዲነሳኒ ንዹንፈቱ። ");
INSERT INTO gaze_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","ዋን አት ና አጀጀምቴፍ ሰብን ለፈራ ሁንድኑ ከራ ሰኚኬቲን ኤብፈመ።” ");
INSERT INTO gaze_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","ኤርገሲ አብረሃም ተጃጅልቶተሳት ዴብኤ፤ እሳንስ ወሉማን ቤርሼባት ቀጄለን፤ አብረሃምስ ቤርሼባ ኬሰ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","ዬሮ ሙራሰ ቦዴ አከነ ጄዸሜ አብረሃምት ህመሜ፤ “ኩኖ፣ ሚልካን ኦቦሌሰኬ ናሆሪፍ እልማን ዴሴርት፤ ");
INSERT INTO gaze_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","እልማን እሼን ዴሴስ እን ሀንገፍን ኡዝ፣ ኦቦሌስሳ ቡዝ፣ አባን አራምሞ ቀሙኤል፣ ");
INSERT INTO gaze_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","ኬሴድ፣ ሀዞ፣ ፊልዳስ፣ ዪድላፊፊ ቤቱኤል ጄዸሙ።” ");
INSERT INTO gaze_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","ቤቱኤል ርብቃ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","ናሆር ሳጀቶ ሬኡማ ጄዸምቱ ቶኮ ቀበ ቱሬ፤ እሼን እልማን ጤባ፣ ገሀም፣ ተሃሺፊ መአካ ጄዸመን ዴሴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","ሳራን ወጋ ዽበ ቶኮፊ ድግደሚ ቶርበ ጅራቴ፤ በር ጅሬኘ ሳራስ ከኑመ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","እሼንስ ክርያት አርባቅ ጄቹንስ ኬብሮን ብየ ከነኣን ኬሳ ሰነት ዱቴ፤ አብረሃምስ ሳራዻፍ ገዱፊ ቦኡዻፍ ጄዼ ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","አብረሃም ሬፈ ኒቲሳ ብራ ከኤ ሄቶታን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“አን ግዱኬሰንት ኦርማፊ ኬሱማዸ። አከ አን ዱኣኮ እት አዋለዹፍ ለፈ አዋላፍ ተኡ ነት ጉርጉራ።” ");
INSERT INTO gaze_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","ሄቶትንስ አከነ ጄዸኒ አብረሃሚፍ ዴቢ ኬነን፤ ");
INSERT INTO gaze_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“ጎፍታ፣ ኑ ዸገእ። አት ኑ ግዱት ሹሚ ጀባዸ። ዱኣኬ እዶ አዋለኬኛ ኬሳ ከን አከ መሌ ፍለተማ ተኤት አዋለዹ። ኑ ኬሳ ነምን እዶ አዋለሳት ዱኣኬ አዋለቹ ስ ዾወቱ ቶኮዩ ህንጅሩ።” ");
INSERT INTO gaze_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","አብረሃምስ ኦል ከኤ ፉለ ነሞተ ብየ ሰና ፉለ ሄቶታ ዱረት ገድ ጄዼ ሀርከ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","አከነስ እሳኒን ጄዼ፤ “አን ዱኣኮ አከን አዋለዹ ፌዺ ዮ ቀባተን ነ ዸገኣቲ ኤፍሮን እልመ ዞሀር ሰነ ና ከዸዻ። ");
INSERT INTO gaze_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","እንስ ሆልቀ መክፌላ ጄዸሙ ከን ቀርቀረ ለፈ ቆቲሳሳት አርገሙ ሰነ ነት ንጉርጉረ። እን እዶ አዋላ ሰነ ገቲ ጉቱዻን ፉለኬሰን ዱረት አከ ነት ጉርጉሩፍ ና ጋፈዻ።” ");
INSERT INTO gaze_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","ኤፍሮን ሄትች ሰበሳ ግዱ ታኣ ቱሬ፤ እንስ ኡቱመ ሄቶትን ገረ ከረ መጋላሳ ዹፈን ሱን ሁንድ ዸገአኑ አከነ ጄዼ አብረሃሚፍ ዴቢ ኬኔ፤ ");
INSERT INTO gaze_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“ጎፍታኮ፣ አከነ ምት፤ ሜ ነ ዸጌፈዹ፤ አን ለፈ ቆቲሳ ከነ ሲፍ ነንኬነ፤ ሆልቀ አች ጅሩስ ሲፍ ነንኬነ፤ አን ፉለ ሰበኮ ዱረት ሆልቀ ከነ ሲፍን ኬነ፤ ዱኣኬ እት አዋለዹ።” ");
INSERT INTO gaze_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","አብረሃም አመሌ ፉለ ሰበ ብየ ሰና ዱረት ገድ ጄዼ ሀርከ ፉዼ፣ ");
INSERT INTO gaze_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","ኡቱመ እሳን ዸገአኑ ኤፍሮኒን፣ “ዮ ፌዺኬ ተኤ፣ ነ ዸገእ። አን ገቲ ለፈ ቆቲሳ ከና ነንከፈለ። አከ አን ዱኣኮ አችት አዋለዹፍ ገቲ ከነ ነ ሀርካ ፉዸዹ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","ኤፍሮንስ አከነ ጄዼ አብረሃሚፍ ዴቢ ኬኔ፤ ");
INSERT INTO gaze_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“ጎፍታኮ፣ ሜ ነ ዸገእ፤ ገቲን ለፈ ከና ሜቲ ሰቅሊ ዽበ አፉር ተአ፤ ገሩ ኩን አናፊ ስ ግዱት ማል? ዱኣኬ እት አዋለዹ።” ");
INSERT INTO gaze_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","አብረሃምስ ዋን ኤፍሮን ዱበቴ ሰነ ፉዸቴ ገቲ እን ኡቱመ ሄቶትን ዸገአኑ ህመቴ ሰነ መዳሌፍ፤ ገቲን ሱንስ አከ መዳሊ ደልደልቶተ ዬሮ ሰናት ሜቲ ሰቅሊ ዽበ አፉር ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","አከስት ለፍት ቆቲሳ ኤፍሮን ከን ፉለ መምሬ ዱረ፣ መክፌላ ኬሰ ጅሩ ሱን ጄቹንስ ለፍት ቆቲሳቲፊ ሆልቅ እሰ ኬሰ ጅሩ፣ ሙክን ዳንጋ ለፈ ቆቲሳ ሰነ ኬሰ ጅሩ ሁንድ፣ ");
INSERT INTO gaze_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","ፉለ ሄቶተ ገረ ከረ መጋላ ዹፈን ሁንዳ ዱረት አከ ዻላት አብረሃምት ደበርፈሜ። ");
INSERT INTO gaze_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","ኤርገሲ አብረሃም ብየ ከነኣን ኬሰ፣ ሆልቀ መክፌላ ከን መምሬ ብረ ጄቹንስ ኬብሮን ብረ ጅሩ ሰነት ኒቲሳ ሳራ አዋለቴ። ");
INSERT INTO gaze_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","አከስት ለፈ ቆቲሳ ሱኒፊ ሆልቅ አች ኬሳ አከ ለፈ አዋላ ተኡፍ ሄቶተራ አከ ዻላት አብረሃምት ደበርፈሜ። ");
INSERT INTO gaze_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","ዬሮ ሰነ አብረሃም ዱሎሜ፣ ኡሙሪንሳ አከ መሌ ዼረቴ ቱሬ፤ ዋቀዮስ ዋን ሁንዱማን እሰ ኤብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","እንስ ተጃጅላ መነሳ ሀንገፈ ከን ዋን እን ቀቡ ሁንደረት እት ጋፈተማ ተኤን አከነ ጄዼ፤ “ሜ ሀርከኬ ጉዴደኮ ጀለ ካእ። ");
INSERT INTO gaze_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","አን አከ አት እንተለን ወረ ከነኣን ከኔን አን ግዱሳኒ ጅራዹ ኬሳ እልመኮቲፍ ኒቲ ህንፍድኔፍ ዋቀዮ ዋቀ ሰሚቲፊ ዋቀ ለፋቲን ከከቱ ነንበርባደ፤ ");
INSERT INTO gaze_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","ገሩ ገረ ብየኮቲፊ ገረ ፍሮተኮ ዸቂቲ እልመኮ ይስሃቂፍ ኒቲ በርባድ።” ");
INSERT INTO gaze_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","ተጃጅላን ሱንሞ፣ “ዮ ዱበርቲን ሱን ነ ወጅን ገረ ብየ ከና ዹፉፍ ፌዺ ቀባቹ ባቴሆ? አን እልመኬ ገረ ብየ አት ኬሳ ዹፍቴ ሰናት ዴብሴ ጌሱን ቀባ?” ጄዼ እሰ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","አብረሃምስ አከነ እሳን ጄዼ፤ “አት አከ እልመኮ ዴብፍቴ ብየ ሰነት ህንጌስኔ ኦፍ ኤገዹ። ");
INSERT INTO gaze_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","ዋቀዮ ዋቅን ሰሚ እን መነ አባኮቲፊ ብየ አን እት ዸለዼ ኬሳ ነ ፍዴ፣ ‘አን ብየ ከነ ሰኚኬቲፍ ነንኬነ’ ጄቹዻን ነት ዱበቴ ከከቴ ዋዳ ና ሴኔ ሱን አከ አት አቺ እልመኮቲፍ ኒቲ ፍዱፍ ኤርገማሳ ፉለኬ ዱረ ንኤርገ። ");
INSERT INTO gaze_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","ዮ ዱበርቲን ሱን ስ ወጅን ዹፉፍ ፌዺ ቀባቹ ባቴሞ አት ከኩኮ ከነራ ብልሰ ታተ። እልመኮ ገሩ ጎንኩማ አች ህንዴብስን።” ");
INSERT INTO gaze_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","ከናፉ ተጃጅላን ሱን ሀርከሳ ጉዴደ ጎፍታሳ አብረሃም ጀለ ካኤ ዋኤ ዋን ከና ከከቴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","ተጃጅላን ሱንስ ጋለ ጎፍታሳ ኬሳ ኩዸን ፉዸቴ ጎፍታሳ ብራሞ ኬናወን ፍለተሞ ጎሰ ሁንዳ ፌአቴ ቀጄሌ፤ እንስ መጋላ ናሆር እሼ ካበ ዽአ ጳዳን አራም ኬሰት አርገምቱ ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","እንስ አከ ጋለወን ሱን መጋለቲን አለት ቦለ ብሻኒ ጭነ ጅጅልቤንፈተን ጎዼ፤ ዬሮን ሱን ገረ ገልገላ ዬሮ እት ዱበርቶትን ብሻን ወራበቹ በአን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","እንስ አከነ ጄዼ ከዸቴ፤ “ያ ዋቀዮ ዋቀ ጎፍታኮ አብረሃም፣ ሀርአ ነ ምልኬሲቲ ጎፍታኮ አብረሃሚፍ ገራ ላፍ። ");
INSERT INTO gaze_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","ኩኖ፣ አን ቡርቃ ከነ ብረ ዻበዼን ጅረ፤ እንተለን ወረ መጋላ ከናስ ብሻን ወራበቹፍ አስ በኣ ጅሩ። ");
INSERT INTO gaze_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","እንተል አን፣ ‘ማሎ አከ አን ብሻን ዹጉፍ ኦኮቴኬ ገድ ቀብ’ ጄዼኒ እሼንስ፣ ‘ዹግ፤ አን ጋለወንኬስ ሲፍን ኦባሳ’ ናን ጄቱ እሼ አት ገርብቸኬ ይስሃቂፍ ፍለቴ ሃታቱ። አንስ ከናን አከ አት ጎፍታኮቲፍ ገራ ላፍቴ ቤከ።” ");
INSERT INTO gaze_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","ኡቱ እን ከዸቴ ህንፍጠን ርብቃን ኦኮቴሼ ገቲቲት ባዸቴ ዹፍቴ። እሼንስ እንተለ እልመ ሚልካ ከን ቤቱኤል ጄዸሙ ሰና ቱርቴ፤ ሚልካንሞ ኒቲ ኦቦሌሰ አብረሃም ከን ናሆር ጄዸሙ ሰናት። ");
INSERT INTO gaze_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","እንተል ሱንስ አከ መሌ በሬዱፊ ዱርበ ቱርቴ፤ ዺር ቶኮዩ እሼ ወጅን ህንጪፍኔ። እሼንስ ገረ ቡርቃት ገድ ቡቴ ኦኮቴሼት ብሻን ጉተቴ ኦል ዴብቴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","ተጃጅላን ሱንስ እሼ ስመቹፍ እት ፊጌ፣ “ማሎ ኦኮቴኬ ኬሳ ብሻን ጥኖሼ ና ኬን” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","እሼንስ፣ “ያ ጎፍታኮ፣ ዹግ” ጄቴኒ ደፍቴ ኦኮቴሼ ሀርከት ገድ ቡፈቴ ብሻን ዹጋቲ ኬንቴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","እሼንስ ኤርገ ብሻን እሰ ኦባፍቴ ቦዴ፣ “አን ጋለወንኬቲፍስ ሀመ እሳን ዹገኒ ዼቡ በአንት ነንወራበ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","ደፍቴስ ኦኮቴሼ ኬሳ ብድሩት ገረገልችቴ አመስ ብሻን ወራቡዻፍ ገረ ቦለ ብሻኒት ፊግዴ፤ ጋለወንሳ ሁንዳፍስ ብሻን ወራብዴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","ነምች ሱንስ አከ ዋቀዮ ከራ እሳፍ ምልኬሴ ዮካን አከ እሳፍ ህንምልኬስን በሩፍ ጄዼ ጨልእሴ ጥዬፈቴ እሼ እላላ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","ኤርገ ጋለወን ብሻን ዹገኒ ቦዴ ነምች አመርቲ ፉኛኒ ከን ወርቄ ከን ወለካ ሰቅሊ ኡልፋቱፊ ብተዎ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቱ ለመ ገድ ባሴ፣ ");
INSERT INTO gaze_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“አት እንተለ ኤኙት? ዮ መነ አባኬቲ እዶን ቡለን ጅራቴ ማሎ ሜ ነት ህም” ጄዼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","እሼንስ፣ “አን እንተለ ቤቱኤል፤ ቤቱኤልሞ እልመ ሚልካን ናሆሪፍ ዴሴዸ” እሳን ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","እት ደበልቴስ፣ “ጭዲፊ ኦካ ባይኤ ቀብነ፤ ኩታን እስን ቡልተንስ ጅረ” ጄቴን። ");
INSERT INTO gaze_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","ነምችስ ገድ ጄዼ ዋቀዮፍ ሰገዴ፤ ");
INSERT INTO gaze_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","አከነስ ጄዼ፤ “ዋቀዮ ዋቅን ጎፍታኮ አብረሃም ከን አርጁማሳቲፊ አመነሙማሳ ጎፍታኮ ህንዾወትን ሱን ሃኤብፈሙ። ዋቀዮ አነስ ገረ መነ ኦቦሎተ ጎፍታኮት ከራረ ነ ቀጄልቼረ።” ");
INSERT INTO gaze_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","እንተለቲንስ ፊግዴ ዸቅጤ ወረ መነ ሃዸሼ ጅረንት ዋኤ ዋን ከና ህምቴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","ርብቃን ኦቦሌሰ ላባ ጄዸሙ ቶኮ ቀብድ ቱርቴ፤ ላባንስ ፊጌ ነምቸ ቡርቃ ብሻኒ ብረ ጅሩ ሰነ ብረ ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","እንስ ዮሙ ኦቦሌቲሳረት አመርቲ ፉኛኒ ወርቄቲፊ ብተዎ አርጌት፣ ዮሙ ኡቱ ርብቃን ዋን ነምች ሱን እሼዻን ጄዼ ዱበቱ ዸገኤት፣ ገረ ነምቻት ገድ በኤ፤ ነምችስ ቡርቃ ብሻኒ ጭነ ጋለወን ብረ ዻበቴ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","ነምቸ ሰናንስ፣ “ያ ነምቸ ዋቀዮ ኤብሴ፣ ኮቱ፤ አት ማሊፍ አለ ዻበተ? አን መንቸ ቆጴሴረ፤ ጋለወኒፍስ እዶ ቆጴሴረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","ከናፉ ነምች ሱን ገረ መና ዸቄ፤ ላባንስ ጋለወንራ ፌኢሰ ቡሴ ጭዲፊ ኦካ ኬኔፍ፤ አከ ሚለሳኒ ዽቀተኒፍሞ ነምቻፊ ወረ እሰ ወጅን ቱረኒፍ ብሻን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","ኤርገሲስ ኛትን ዽኣቴፍ፤ ነምች ሱን ገሩ፣ “አን ሀመን ዽመኮ ህመዹት ህንኛዹ” ጄዼ። ላባንስ፣ “ህመዹካ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","እንስ አከነ ጄዼ፤ “አን ተጃጅላ አብረሃሚት። ");
INSERT INTO gaze_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","ዋቀዮ፣ ጎፍታኮ ጉዳ ኤብሴረ፤ እንስ ሶሮሜረ። ሆሎታፊ ሎወን፣ ሜቲፊ ወርቄ፣ ገርቦተ ዺራቲፊ ዱበርቲ፣ ጋለወኒፊ ሀሮተ እሳፍ ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","ኒቲን ጎፍታኮቲ ሳራን በረ ዱሉመሼ ኬሰ እልመ እሳፍ ዴሴ፤ እንስ ዋን ቀቡ ሁንደ እልመሳቲፍ ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","ጎፍታንኮ አከነ ጄዼ ነ ከከቺሴ፤ ‘አት እንተለን ከነኣን ከኔን አን ብየሳኒ ኬሰ ጅራዹ ኬሳ እልመኮፍ ኒቲ ህንፍድን፤ ");
INSERT INTO gaze_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ገሩ ገረ መነ አባኮቲፊ ገረ ጎሰኮ ዸቂቲ እልመኮቲፍ ኒቲ ፍድ።’ ");
INSERT INTO gaze_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“አንስ፣ ‘ዮ ዱበርቲን ሱን ነ ወጅን ዹፉፍ ፌዺ ቀባቹ ባቴሆ?’ ጄዼ ጎፍታኮ ነንጋፈዼ። ");
INSERT INTO gaze_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“እንስ አከነ ናን ጄዼ፤ ‘ዋቀዮ እን አን ፉለሳ ዱረ ጅራዹ ኤርገማሳ ስ ወጅን ኤርጌ ከራኬ ሲፍ ምልኬሰ፤ አትስ ጎሰኮፊ መነ አባኮ ኬሳ እልመኮቲፍ ኒቲ ንፍደ። ");
INSERT INTO gaze_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","አት ዮሙ ገረ ጎሰኮ ዸቅጡ ከኩኮራ ብልሰ ታተ፤ ዮ እሳን እንተለ ሰነ ስት ኬኑ ድደንዩ አት ከኩኮራ ብልሰ ታተ።’ ");
INSERT INTO gaze_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“አን ሀርአ ዮሙን ገረ ቡርቃ ከና ዹፌት አከነን ጄዼ፤ ‘ያ ዋቀዮ፣ ዋቀ ጎፍታኮ አብረሃም ዮ ፌዺኬ ተኤ ከራ አን ዴሙ ና ምልኬስ። ");
INSERT INTO gaze_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","ኩኖ፣ አን ቡርቃ ከነ ብረ ዻበዼረ፤ ዮ ዱርብ ቶኮ ብሻን ወራበቹ ዹፍቴ አንሞ፣ “ማሎ ኦኮቴኬ ኬሳ ብሻን ጥኖሼ ነ ኦባስ” ጄዼኒ፣ ");
INSERT INTO gaze_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","እሼንስ፣ “ዹግ፤ አን ጋለወንኬቲፍስ ነንወራበ” ናን ጄቴ፣ እሼን ከን ዋቀዮ እልመ ጎፍታኮቲፍ ፍሌ ሃታቱ።’ ");
INSERT INTO gaze_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“ኡቱ አን ገራኮ ኬሰት ከዸዼ ህንፍጠን ርብቃን ኦኮቴሼ ገቲቲት ባዸቴ ገድ ዹፍቴ። እሼንስ ገረ ቡርቃ ሰናት ገድ ቡቴ ብሻን ወራበቴ፤ አንስ፣ ‘ማሎ ብሻን ነ ኦባስ’ ነንጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“እሼንስ ደፍቴ ኦኮቴሼ ገቲቲራ ገድ ቡፈቴ፣ ‘ዹግ፤ አን ጋለወንኬስ ነንኦባሳ’ ጄቴ። አንስ ነንዹጌ፤ እሼንሞ ጋለወን ኦባፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“አንስ፣ ‘አት እንተለ ኤኙት?’ ጄዼን እሼ ጋፈዼ። “እሼሞ፣ ‘አን እንተለ ቤቱኤል፤ ቤቱኤልሞ እልመ ሚልካን ናሆሪፍ ዴሴዸ’ ጄቴ። “አንስ ፉኛንሼት አመርቲ፣ ሀርከሼትሞ ብተዎ ነንካኤ። ");
INSERT INTO gaze_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","አንስ ገድ ጄዼ ዋቀዮፍ ነንሰገዴ፤ ዋቀዮ ዋቀ ጎፍታኮ አብረሃም እሰ አከ አን እንተለ ፍረሳ እልመሳቲፍ ጌሱ ከራ ቀጄላረ ነ ቡሴ ሰነ ነንኤብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","ኤጋ እስን ዮ ጎፍታኮት ገራ ላፉማፊ አመነሙማ አርግሲፍተን ነት ህማ፤ ዮ ተኡ ባቴሞ አከ አን ገረ ብታት ዮካን ገረ ምርጋት ጎሩ ነት ህማ።” ");
INSERT INTO gaze_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","ላባፊ ቤቱኤልስ አከነ ጄዸኒ ዴብሰን፤ “ወን ኩን ዋቀዮ ብራ ዹፌ፤ ኑ ዋን ሀማ ዮካን ዋን ቶላ ስት ዱበቹ ህንደንዴኙ። ");
INSERT INTO gaze_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","ኩኖ፣ ርብቃን ፉለኬ ዱረ ጅርት፤ እሼ ፉዸዹ ዴም፤ እሼንስ አኩመ ዋቀዮ ዱበቴት ኒቲ እልመ ጎፍታኬቲ ሃታቱ።” ");
INSERT INTO gaze_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","ተጃጅላን አብረሃምስ ዮሙ ዋን እሳን ጄዸን ዸገኤት ለፈት ጎምብፈሜ ዋቀዮፍ ሰገዴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","ከነ ቦዴስ ተጃጅላን ሱን ፋየ ሜቲፊ ወርቄ፣ ኡፈተ አደ አዳስ ባሴ ርብቃዻፍ ኬኔ፤ ኦቦሌሰሼቲፊ ሃዸሼቲፍስ ኬና ገቲ ጉዳ ባሱ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","እኒፊ ነሞትን እሰ ወጅን ቱረንስ ኛተኒ ዹገኒ አቹመ ቡለን። ዮሙ እሳን ጉያ እት ኣኑ ገነማን ከአንት ተጃጅላን ሱን፣ “አከ አን ገረ ጎፍታኮት ዴብኡፍ ነ ጌጌሳ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","ኦቦሌስሼቲፊ ሃትሼ ገሩ፣ “እንተለቲን ጉዩመ ኩዸንሌ ኑ ብረ ሃቱርቱ፤ ኤርገሲስ እሼን ዴሙ ደንዴስ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","እን ገሩ፣ “ኤርገ ዋቀዮ ከራኮ ና ምልኬሴ እስን ነ ህንቱርስና፤ አከ አን ገረ ጎፍታኮት ዴብኡፍ ነ ጌጌሳ” እሳኒን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","እሳንስ፣ “ሜ እንተለቲ ዋምኔ ዋን እሼን ጄቱ ጋፈትነ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","ከነረት እሳን ርብቃ ዋመኒ፣ “ነምቸ ከነ ወጅን ዴሙ ፌታ?” ጄዸኒ እሼ ጋፈተን። እሼንስ፣ “አን ነንዴመ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","ከናፉ እሳን ኦቦሌቲሳኒ ርብቃፊ ጉድፍቱሼ፣ ተጃጅላ አብረሃሚፊ ነሞተሳ ወጅን ጌጌሰን። ");
INSERT INTO gaze_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","እሳንስ አከነ ጄዸኒ ርብቃ ኤብሰን፤ “ያ ኦቦሌቲኬኘ፣ ኩማ ኩማተመ ተእ፤ ሰኚንኬ ከረ ዲኖተሳ ሃዻሉ።” ");
INSERT INTO gaze_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","ርብቃፊ ተጃጅልቱወንሼ ቆጳአኒ ጋለወንሳኒ ያበተኒ ነምቸ ፋነ ቡአን፤ ነምችስ ርብቃ ፉዸቴ ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","ዬሮ ሰነ ይስሃቅ ቦለ ብሻኒ ቤኤር ለሃይሮኢቲ ዹፌ ኔጌብ ኬሰ ጅራቻ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","እንስ ጋፍ ቶኮ ገረ ገልገላ ኡቱ በኬት በኤ ዋ ያዳ ጅሩ ኦል እላሌ ኩኖ ጋለወን ዹፋ ጅረን አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","ርብቃንስ ኦል እላልቴ ይስሃቅን አርግቴ፤ ጋለራስ ቡቴ ");
INSERT INTO gaze_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","ተጃጅላ ሰናን፣ “ነምች ኑ ስመቹፍ በኬ ኬሰ አስ ዴማ ጅሩ ሱን ኤኙ?” ጄቴ ጋፈቴ። ተጃጅላን ሱንስ፣ “እን ጎፍታኮት” ጄዼ ዴብሴፍ። ከናፉ ሀጉጊሼ ፉዸቴ ኦፍት ሀጉግዴ። ");
INSERT INTO gaze_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","ተጃጅላን ሱንስ ዋን ሆጄቴ ሁንደ ይስሃቅት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","ይስሃቅስ ዱንካነ ሃዸሳ ሳራት ኦል እሼ ገልፈቴ፤ ርብቃ ፉዼስ። አከሲን እሼን ኒቲሳ ታቴ፤ እንስ እሼ ጃለቴ፤ ይስሃቅስ ዱአ ሃዸሳራ ንጀጀባቴ። ");
INSERT INTO gaze_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","አብረሃምስ ኒቲ ብራ ከን መቃንሼ ቄጡራ ጄዸሙ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","እሼንስ ዝምራን፣ ዮቅሻን፣ ሜዳን፣ ምድያን፣ ይሽባቂፊ ሹዋ እሳፍ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","ዮቅሻን ሼባፊ ዴዳን ዸልቼ፤ እልማን ዴዳንሞ አሹርም፣ ሌቱሽሞታፊ ሌኡሞተ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","እልማን ምድያን ኤፋ፣ ኤፌር፣ ሄኖክ፣ አቢዳፊ ኤልዳኣ ቱረን። ወር ኩኔን ሁንድ ሰኚወን ቄጡራት። ");
INSERT INTO gaze_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","አብረሃም ዋን ቀቡ ሁንዱማ ይስሃቂፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","እልማን ሳጀቶወንሳቲፍ ገሩ ኡቱመ ሉቡን ጅሩ ኬና ኬኔፊ እልመሳ ይስሃቅ ብራ ገረ ብየ በአ ቢፍቱት እሳን ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","አብረሃም ወጋ ዽበ ቶኮፊ ቶርባተሚ ሸን ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","እንስ ኡሙሪ ዼራፊ ጅሬኘ ጋሪ ጅራቴ ዱሎሜ ሀፉረ ዹማ ባፈቴ ዱኤ፤ ሰበ እሳትስ ደበለሜ። ");
INSERT INTO gaze_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","እልማንሳ ይስሃቂፊ እሽማኤል ለፈ ቆቲሳ ኤፍሮን እልመ ዞሀር ነምቸ ጎሰ ሄት ሰና ኬሰት ሆልቀ መክፌላ ከን መምሬ ብረት አርገሙት እሰ አዋለን። ");
INSERT INTO gaze_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","ለፍት ቆቲሳ ሱንስ ከን አብረሃም ሄቶተራ ብተቴዸ፤ አብረሃምስ አችት ኒቲሳ ሳራ ብረት አዋለሜ። ");
INSERT INTO gaze_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","ኤርገ አብረሃም ዱኤ ቦዴ ዋቅን እልመሳ ይስሃቅን ኤብሴ፤ ይስሃቅስ ቤኤር ለሃይሮኢ ብረ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","ሴናን ማቲ እሽማኤል እልመ አብረሃም ከን አጋር ገርብቲን ሳራ እንተል ብየ ግብጥ ሱን አብረሃሚፍ ዴሴ ሰና ከነ። ");
INSERT INTO gaze_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","መቃን እልማን እሽማኤል ከን አኩመ ዸሎተሳኒት ተርቲባን በሬፈሜ ከነ፦ ነባዮት እልመ እሽማኤል ሀንገፍትቸ፣ ቄዳር፣ አድብኤል፣ ምብሳም፣ ");
INSERT INTO gaze_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","ምሽማ፣ ዱማ፣ ማሳ፣ ");
INSERT INTO gaze_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","ሀዳድ፣ ቴማ፣ ዬጡር፣ ናፊሺፊ ቄድማ። ");
INSERT INTO gaze_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","ጀር ኩኔን እልማን እሽማኤል፤ መቃወን ኩኔንስ አኩመ ገንዶታፊ እዶ ቁበተሳኒት መቃወን ቡልችቶተ ጎሶተ ኩዸ ለማኒት። ");
INSERT INTO gaze_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","እሽማኤል ወጋ ዽበ ቶኮፊ ሶዶሚ ቶርበ ጅራቴ፤ እንስ ሀፉረ ዹማ ባፈቴ ዱኤ፤ ሰበ እሳትስ ደበለሜ። ");
INSERT INTO gaze_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","ሰኚንሳሞ ዳንጋ ግብጥ ብረ፣ ከራ አሶርት ጌሱረ፣ ለፈ ሀዊላ ጀልቀቤ ሀመ ሹሪት ጅሩረ ጅራተን። እሳንስ ኦቦሎተሳኒ ሁንደት ዲነ ተአኒ ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","ሴናን ማቲ ይስሃቅ እልመ አብረሃም ከነ። አብረሃም ይስሃቅን ዸልቼ፤ ");
INSERT INTO gaze_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","ይስሃቅ ዬሮ ርብቃ ፉዼት ነመ ወጋ አፉርተማ ቱሬ፤ ርብቃን ኩንስ እንተለ ቤቱኤል ነምቸ አራም ከን ካበ ዽአ ጳዳን አራሚቲፊ ኦቦሌቲ ላባ ነምቸ አራም ሰናት። ");
INSERT INTO gaze_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","ይስሃቅ ሰበቢ ኒቲንሳ ዸብዱ ቱርቴፍ ዋቀዮን እሼፍ ከዸቴ። ዋቀዮስ ከዸትናሳቲፍ ዴቢ ኬኔ ኒቲንሳ ርብቃን ኡልፎፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","ዳእመንስ ገራሼ ኬሰት ወል ዺባ ቱረን፤ እሼንስ፣ “ወን ኩን ማሊፍ ነት ዹፌ?” ጄቴ፤ ከናፉ ዋቀዮ ጋፈቹ ዸቅጤ። ");
INSERT INTO gaze_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","ዋቀዮሞ አከነ ጄዼን፤ “ሰቦተ ለመቱ ገደሜሰኬ ኬሰ ጅረ፤ ኡመትን ለማን አት ዴሱስ ገርገር በኡ፤ ሰብን ቶኮ ሰበ ካንረ ንጀባተ፤ እን ሀንገፍን እሰ ቁጥሱ ተጃጅለ።” ");
INSERT INTO gaze_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","ዬሮ ደኡምስሼ ገኤት እልማን ለኩቱ ገደሜሰሼ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","ሙጫን ጀልቀበት ዸለቴ ዲማዸ፤ ዸግንሳ ጉቱን ኡፈተ ርፌንሰ ቀቡ ፈካተ ቱሬ፤ ከናፉ ኤሳዉ ጄዸኒ እሰ ሞጋሰን። ");
INSERT INTO gaze_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","ከነ ቦዴ ኦቦሌስሳ ኮሜ ኤሳዉ ሀርካን ቀበቴ ገድ በኤ፤ መቃንሳስ ያቆብ ጄዸሜ። ዬሮ ርብቃን እሳን ዴሴት፣ ይስሃቅ ነመ ወጋ ጃተማ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","እጆሌን ኩንስ ንጉደተን፤ ኤሳዉ አደምሳ ቤከማፊ ነመ በኬ ኦሉ ተኤ፤ ያቆብ ገሩ ነመ ጨልእሳ ዱንካነ ኬሰ ኦሉ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","ይስሃቅ ዋን ፎን ብኔንሰ ቦሶና ምኤፈቴፍ ኤሳዉን ጃለቴ፤ ርብቃን ገሩ ያቆብን ጃለቴ። ");
INSERT INTO gaze_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","ጋፍ ቶኮ ኡቱ ያቆብ እቶ ቆጴሳ ጅሩ ኤሳዉ አከ መሌ ቤለኤ በኬዻ ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","እንስ ያቆቢን፣ “አን አከ መሌ ቤለኤራቲ፣ ሜ እቶ ዲማ ሰነራ ጥኖ ና ኬን!” ጄዼ። ሰበቢን እን ኤዶም ጄዸሜፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","ያቆብሞ ዴብሴ፣ “ዱረ ምርገ ሀንገፉማኬቲ ነት ጉርጉር ካ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","ኤሳዉስ፣ “ኩኖ፣ አን ዱኡ ገኤረ፤ ዮስ ምርግ ሀንገፉማ ማል ነ ፈየደሬ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","ያቆብ ገሩ፣ “ዱራን ዱርሲ ና ከከዹ” ጄዼን፤ አከሲን እን ከከቴ ምርገ ሀንገፉማሳ ያቆብት ጉርጉረቴ። ");
INSERT INTO gaze_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","ኤርገሲስ ያቆብ ቡዴናፊ እቶ ምስራ ኤሳዉፍ ኬኔ፤ እንስ ኛቴ ዹጌ ከኤ አቺ ዴሜ። ኤሳዉስ አከሲን ምርገ ሀንገፉማሳ ቱፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","ቤለ እሰ በረ አብረሃም ብይቸት ቡኤ ሰነ መሌ ቤል ብራ ቶኮ አመስ ብየ ሰነት ቡኤ፤ ይስሃቅስ ገረ ጌራራ ገረ አቢሜሌክ ሞትቸ ፍልስጤም ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","ዋቀዮስ ይስሃቅት ሙልአቴ አከነ ጄዼ፤ “ብየ አን አከ አት ኬሰ ጅራቱፍ ስት ህሙ ኬሰ ጅራዹ መሌ ግብጥት ገድ ህንቡእን። ");
INSERT INTO gaze_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","ብዩመ ከነ ጅራዹ፤ አን ስ ወጅን ነንተአ፤ ስን ኤብሰስ፤ ብየ ከነ ሁንደ ሲፊ ሰኚኬቲፍ ነንኬናቲ። አን ከኩን አባኬ አብረሃሚፍ ከከዼ ሰነ ነንጉተ። ");
INSERT INTO gaze_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","አን አኩመ ኡርጂወን ሰሚ ሰኚኬ ነንባይእሰ፤ ብየ ከነ ሁንደስ እሳኒፍ ነንኬነ፤ ሰቦትን ለፈረ ጅረን ሁንድኑስ ከራ ሰኚኬቲቲን ኤብፈሙ። ");
INSERT INTO gaze_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","ኩንስ ዋን አብረሃም ዱቢኮ ዸገኤ ፌዺኮ፣ አጀጀኮ፣ ለብሲኮቲፊ ሴረኮ ኤጌፍ።” ");
INSERT INTO gaze_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","ይስሃቅስ ጌራራ ኬሰ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","እንስ ዮሙ ነሞትን ብየ ሰና ዋኤ ኒቲሳ እሰ ጋፈተንት ዋን ርብቃን በሬዱ ታቴፍ፣ “ነሞትን ናኖ ከና ሰበቢሼቲፍ ነ አጄሱ ተአ” ጄዼ ያዱዻን፣ “እሼን ኒቲኮት” ጄቹ ሶዳቴ፣ “እሼን ኦቦሌቲኮት” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","ኤርገ ይስሃቅ ዬሮ ዼራ አች ጅራቴ ቦዴ፣ አቢሜሌክ ሞትች ፍልስጤሚ ፎዳ ኬሳን ገድ እላሌ፤ ኡቱ ይስሃቅ ኒቲሳ ርብቃ ሆቅሱ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","አቢሜሌክስ ይስሃቅን ኦፍት ዋሜ፣ “እሼን ዹጉማን ኒቲኬት! ዮስ አት ማሊፍ፣ ‘እሼን ኦቦሌቲኮት’ ጄቴሬ?” ጄዼን። ይስሃቅስ፣ “ዋን አን ሰበቢሼቲፍ ሉቡኮ ነንዸበ ተአ ጄዼ ያዴፍ” ጄዼ ዴብሴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","አቢሜሌክሞ፣ “ወን አት ኑት ሆጄቴ ኩን ማል? ኡቱ ነሞተ ከኔን ኬሳ ቶኮ ኒቲኬ ወጅን ጪሴ ጅራቴ ስላ አት የከ ኑት ፍዴ ቱርቴ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","ከነረት አቢሜሌክ፣ “ነምን ነምቸ ከነ ዮካን ኒቲሳ ቱቁ ከምዩ ዹጉማን አጄፈሙ ቀበ” ጄዼ ነመ ሁንዳፍ አጀጀ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","ይስሃቅስ ብየ ሰነት ምዻን ፈጫፈቴ ዋን ዋቀዮ እሰ ኤብሴፍ በሩመ ሰነ ኬሰ ደቻ ዽበ ገልፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","እንስ ንሆሬ፤ ሀመ አከ መሌ ሶሮሙትስ ቀቤኝሳ እቱመ ፉፌ ባይአቴ። ");
INSERT INTO gaze_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","እንስ ቡሻዬ፣ ሎወኒፊ ሆጄቶተ ሄዱ ቀበ ቱሬ፤ ፍልስጤሞትንስ እሰት ህናፈን። ");
INSERT INTO gaze_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","ከናፉ ፍልስጤሞትን ቦለ ብሻኒ ሆጄቶትን አባሳ በረ አብረሃም ኬሰ ቆተን ሁንደት ብዮ ነቀኒ ዱቸን። ");
INSERT INTO gaze_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","አቢሜሌክስ ይስሃቂን፣ “አት ባይኤ ኑ ጫላ ጀባቴርታቲ ኑራ ዴም” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","ይስሃቅ አቺ ከኤ ሱሉለ ጌራራ ኬሰ ቁበቴ አች ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","ይስሃቅስ ቦለወን ብሻኒ በረ አባሳ በረ አብረሃም ኬሰ ቆተመን ከኔን ፍልስጤሞትን ኤርገ አብረሃም ዱኤ ቦዴ ዱቸን ሰነ ዴብሴ በኔ፤ እንስ መቁመ አባንሳ ኬኔፊ ቱሬ ሰናን እሳን ዋሜ። ");
INSERT INTO gaze_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","ተጃጅልቶትን ይስሃቅ ሱሉለ ሰነ ኬሰት ለፈ ቆተኒ ቦለ ብሻን ቡርቁ አርገተን። ");
INSERT INTO gaze_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","ትክሶትን ጌራራ፣ “ብሻን ኩን ከንኬኘ!” ጄዸኒ ትክሶተ ይስሃቅ ወጅን ወል ሎለን። ከናፉ እን ሰበቢ ወል ፈልመኒፍ ቦለ ብሻኒ ሰነ፣ “ኤሴቅ” ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","ኤርገሲስ ቦለ ብሻኒ ብራ ቆተን፤ እሳን ገሩ ቦለ ብሻኒ ሰነረትስ ወል ሎለን፤ ከነረት ይስሃቅ ቦለ ብሻኒ ሰነ “ስጥና” ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","እንስ አቺ ከኤ እዶ ብራ ዸቄ ቦለ ብሻኒ ብራ አችት ቆቴ፤ ነምን ቶኮዩ እሰረት ወል ህንሎሌ። እንስ፣ “ዋቀዮ አመ እዶ በልኣ ኑ ኬኔረ፤ ኑ ብየቲ ኬሰት ንባይአትነ” ጄቹዻን ሬሆቦት ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","እንስ አቺ ከኤ ገረ ቤርሼባት ኦል በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","ዋቀዮስ ሀልከኑመ ሰነ እሰት ሙልአቴ አከነ ጄዼን፤ “አን ዋቀ አባኬ አብረሃም፤ አን ዋን ስ ወጅን ጅሩፍ ህንሶዳትን። ገርብቸኮ አብረሃሚፍ ጄዼስ አን ስን ኤብሰ፤ ሰኚኬስ ነንባይእሰ።” ");
INSERT INTO gaze_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","ይስሃቅ አችት እዶ ኣርሳ እጃሬ መቃ ዋቀዮ ዋመቴ። ዱንካነሳስ አች ዻበቴ፤ ተጃጅልቶትንሳስ እዶ ሰነት ቦለ ብሻኒ ቆተተን። ");
INSERT INTO gaze_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","ኤርገሲስ አቢሜሌክ ጎርሳሳ አሁዛቲፊ አጀጃ ሎልቶተሳ ፊኮል ወጅን ጌራራዻ ከኤ ገረ ይስሃቅ ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","ይስሃቅሞ፣ “እስን ኤርገ ነ ጅብተኒ ኦፍ ብራ ነ አሪተኒ ማሊፍ ገረኮ ዹፍተን?” እሳኒን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","እሳንስ አከነ ጄዸኒ ዴብሰን፤ “ኑ አከ ዋቀዮ ስ ወጅን ጅሩ እፋን እፈት አርግኔረ፤ ከናፉ ኑ፣ ‘ከኩን ወሊ ገልቴ ግዱኬኘ ጄቹንስ ኑፊ ስ ግዱ ጅራቹ ቀበ’ ጄኔ፤ ሜ ኮቱ ስ ወጅን ወሊ ገልቴ ጎዸትና። ");
INSERT INTO gaze_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","ኩንስ አኩመ ኑ ኡቱ ዋን ጋሪ መሌ ዋን ሀማ ስራን ህንገእን ነጋን ኦፍራ ስጌጌስኔ ሰነ አከ አትስ ኑ ህንሚኔፍ። አት አመሌ ነመ ዋቀዮ ኤብሴዸ።” ");
INSERT INTO gaze_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","ይስሃቅስ ኛተ እሳኒፍ ቆጴሴ፤ እሳንስ ንኛተን፤ ንዹገንስ። ");
INSERT INTO gaze_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","ነሞትን ሱን ጉያ እት ኣኑ ገነመ በራቀ ከአኒ ወሊ ከከተን። ይስሃቅስ እሳን ጌጌሴ፤ ጀርስ ነጉማን እሰ ብራ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","ጉዩመ ሰነ ሆጄቶትን ይስሃቅ ዹፈኒ ዋኤ ቦለ ብሻኒ ቆተን ሰናሳት ህመን። እሳንስ፣ “ኑ ብሻን አርገኔረ!” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","እንስ ቦለ ብሻኒ ሰነ፣ “ሽቤኣ” ጄዼ ሞጋሴ። ሀመ ሀርኣት መቃን መጋላ ሰና ቤርሼባ ጄዸመ። ");
INSERT INTO gaze_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","ኤሳዉ ዬሮ ኡሙሪንሳ ወጋ አፉርተመ ጉቴት ዮዲት እንተለ ብኤር ነምቸ ጎሰ ሄት አከሱመስ ባስመት እንተለ ኤሎን ነምቸ ጎሰ ሄት ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","እሳንስ ይስሃቂፊ ርብቃ ገድሲሰን። ");
INSERT INTO gaze_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","ይስሃቅ ዱሎሜ ዬሮ እጅሳ አርጉ ደዸቤት እልመሳ ሀንገፈ ኤሳዉን ኦፍት ዋሜ፣ “ያ እልመኮ” ጄዼን። እንስ፣ “ኩኖ አሰን ጅረ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","ይስሃቅ አከነ ጄዼ፤ “ኩኖ፣ አን ዱሎሜረ፤ ጉያ ዱአኮ ህንቤኩ። ");
INSERT INTO gaze_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","ከናፉ ማሎ ምአ አደሞኬቲ ጄቹንስ ኮሮጆ ጥየኬቲፊ እዳኬ ቀበዹቲ ገረ ድሬት በኢቲ ብኔንሰ ና አደምስ። ");
INSERT INTO gaze_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","አከ አን ኡቱን ህንዱእኒን ዱረ ስ ኤብሱፍ፣ ኛተ ምኣዋ ጎሰ አን ጃለዹ ና ቆጴሲቲ አከ አን ኛዹፍ ና ዽኤስ።” ");
INSERT INTO gaze_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","ዮሙ ይስሃቅ እልመሳ ኤሳዉት ዱበቴት ርብቃን ንዸጌፈት ቱርቴ። ዬሮ ኤሳዉ ብኔንሰ አደምሴ ፍዱፍ ገረ ድሬት ገድ በኤት፣ ");
INSERT INTO gaze_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","ርብቃን እልመሼ ያቆቢን አከነ ጄቴ፤ “ኩኖ፣ አን ኡቱ አባንኬ ኦቦሌሰኬ ኤሳዉት ዱበቱ ዸገኤረ፤ ");
INSERT INTO gaze_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","እንስ፣ ‘አከ አን ኡቱን ህንዱእን ፉለ ዋቀዮ ዱረት ስ ኤብሱፍ ብኔንሰ አደምሲ ፍዲቲ አከ አን ኛዹፍ ኛተ ምኣዉ ና ቆጴስ’ ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","ኤጋ ያ እልመኮ፣ አኩመ አን ስ አጀጁት ዱቢኮ ዸገእ። ");
INSERT INTO gaze_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","አን አከን አባኬቲፍ አኩመ እን ጃለቱት ኛተ ምኣዋ ቆጴሱፍ ገረ ቡሻዬ ዸቂቲ እልሞሌ ሬኤ ፍለተሞ ለመ ና ፍድ። ");
INSERT INTO gaze_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","አከ እን ኛቴ ኡቱ ህንዱእን ስ ኤብሱፍ አባኬቲፍ ኛተ ዽኤስ።” ");
INSERT INTO gaze_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","ያቆብስ ሃዸሳ ርብቃዻን አከነ ጄዼ፤ “ኩኖ፣ ኦቦሌስኮ ኤሳዉ ደበሳኣዸ፤ አን ገሩ ርፌንሰ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","ዮ አባንኮ ነ ቀቀበቴ ዋን አን እሰ ጎዎምሴ ሴኤ፣ አን ቆደ ኤባ አባርሰ ኦፍት ነንፍደ።” ");
INSERT INTO gaze_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","ሃትሳሞ፣ “ያ እልመኮ፣ አባርስ ሱን ናፍ ሃተኡ፤ አት ዋኑመ አን ሲን ጄዼ ጎዽ፤ ዸቂቲ ሬኦተ ሰነ ና ፍድ” ጄቴን። ");
INSERT INTO gaze_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","እንስ ዸቄ እልሞሌ ሬኦታ ሰነ ቀቤ ሃዸሳቲፍ ፍዴ፤ እሼንሞ አኩመ አባንሳ ጃለቱት ኛተ ምኣዉ ቆጴስቴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","ኤርገሲስ ርብቃን ኡፈተ ኤሳው እልመሼ ሀንገፍትቻ ከን እሼ ብረ ቱሬ ኬሳ ከን ሁንደረ በሬዱ ፉቴ ያቆብ እልመሼ እሰ ቁጥሱ ሰነት ኡፍፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","ሀርከሳቲፊ ሞርመሳ እዶ ርፌንሰ ህንቀብኔት ጎጋ ሬኦታ ኡፍፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","ኤርገሲስ ኛተ ምኣዋፊ ቡዴነ ቆጴስቴ ቱርቴ ሰነ እልመሼ ያቆብት ኬንቴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","እንስ ገረ አባሳ ዸቄ፣ “ያ አባኮ” ጄዼ። እንስ፣ “ያ እልመኮ፣ ኩኖ አሰን ጅረ፤ አት ኤኙ?” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","ያቆብስ አባሳቲን አከነ ጄዼ፤ “አን ኤሳዉ እልመኬ እሰ ሀንገፍትቸ፤ አኩመ አት ነት ህምቴ ሰነ ጎዼረ፤ አከ ነ ኤብፍቱፍ ሜ ኦል ጄዺቲ ዋን አን አደምሴ ፍዴ ኛዹ።” ");
INSERT INTO gaze_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","ይስሃቅ እልመሳቲን፣ “ያ እልመኮ፣ አከምት አከነ ደፍቴ አርገቴ?” ጄዼ። ያቆብሞ፣ “ዋቀዮ ዋቀ ኬቱ ነ ምልኮምሴ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","ይስሃቅስ ያቆቢን፣ “አከ አን ስ ቀቀበዼ እልመኮ ኤሳው ተኡፊ ተኡ ባቹኬ ቤኩፍ ሜ አስ ዽኣዹ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","ያቆብስ አባሳ ይስሃቅት ዽኣቴ፤ አባንሳስ እሰ ቀቀበቴ፣ “ሰገሌን ኩን ሰገሌ ያቆብ፤ ሀርክ ኩን ገሩ ሀርከ ኤሳዉ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","ዋን ሀርክሳ አኩመ ሀርከ ኤሳዉ ርፌንሰ ቀቡፍ ይስሃቅ ገርገር ባሴ እሰ ቤኩ ህንደንዴኜ፤ ከናፉ እሰ ኤብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","እንስ፣ “አት ዹጉማን እልመኮ ኤሳዉ?” ጄዼ ጋፈቴ። እንሞ፣ “ኤዬ አን እሱመ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","ይስሃቅስ፣ “ያ እልመኮ፣ አከ አን ኛዼ ስ ኤብሱፍ ሜ ዋን አደምስቴ ፍዴ ሰነ ና ኬን” ጄዼ። ያቆብ ንዽኤሴፍ፤ እንስ ንኛቴ፤ ዳዺ ወይኒስ ንፍዴፍ፤ እንስ ንዹጌ። ");
INSERT INTO gaze_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","አባንሳ ይስሃቅስ፣ “ያ እልመኮ አስ ኮቱ ነ ዹንገዹ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","እንስ እት ዽኣቴ እሰ ዹንገቴ። ይስሃቅስ ፎሊ ወያሳ ሱፌ እሰ ኤብሴ፤ አከነስ ጄዼ፤ “እላ፣ ፎሊን እልመኮ፣ አኩመ ፎሊ ለፈ ቆቲሳ ዋቀዮ ኤብሴት። ");
INSERT INTO gaze_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","ዋቅን ፍጤንሰ ሰሚ፣ ለፈ ገበታ፣ ምዻኒፊ ወይኒ አከ መሌ ባይአቱ ሲፍ ሃኬኑ። ");
INSERT INTO gaze_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","ሰቦትን ስ ሃተጃጅለን፤ ኡመትንስ ሲፍ ሃሰገደን። ኦቦሎተኬረት ጎፍታ ተእ፤ እልማን ሃዸኬቲስ ሲፍ ሃሰገደን። ወር ስ አባረን ሃአባረመን፤ ወር ስ ኤብሰንሞ ሃኤብፈመን።” ");
INSERT INTO gaze_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","አኩመ ይስሃቅ ያቆብን ኤብሴ ፍጤ ያቆብሞ ፉለ አባሳ ፉለ ይስሃቅ ዱራ ገድ በኤን፣ ኦቦሌስሳ ኤሳዉ አደሞዻ ዹፌ ኦል ገሌ። ");
INSERT INTO gaze_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","እንስ ኛተ ምኣዋ ቆጴሴ አባሳቲፍ ፍዴ፤ አባሳቲንስ፣ “ያ አባኮ፣ አት አከ ነ ኤብፍቱፍ ኦል ጄዺቲ ዋን አን እልምኬ አደምሴ ፍዴ ኛዹ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","አባንሳ ይስሃቅስ፣ “አት ኤኙ?” ጄዼ እሰ ጋፈቴ። እንስ፣ “አን እልመኬ ኤሳዉ ሀንገፍትቸ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","ዮሙስ ይስሃቅ አከ መሌ ሆለቻ፣ “ዮስ ነምን ዋ አደምሴ ና ፍዴ ኤኙሬ? አን ኡቱ አት ህንዹፍን ሁንዱመሳ ኛዼን እሰ ኤብሴ፤ እን ዹጉማን ንኤብፈመ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","ኤሳዉ ዮሙ ዋን አባንሳ ዱበቴ ዸገኤት፣ አባሳቲን፣ “ያ አባኮ፣ አነስ ኤብስ!” ጄዼ ሰገሌ ኦል ፉዸቴ ህቅፈቴ ቦኤ። ");
INSERT INTO gaze_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","ይስሃቅ ገሩ፣ “ኦቦሌስኬ ሀጡማዻን ዹፌ ኤበኬ ፉዸቴረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","ኤሳዉስ፣ “መቃንሳዩ ዹጉማን ያቆብ ጄዸመ ምቲ? እን ከነ ወጅን ዬሮ ለመ ነ ጎዎምሱሳት፤ ጀልቀበት ሀንገፉማኮ ነራ ፉዸቴ፤ አመሞ ኤበኮ ፉዸቴረ” ጄዼ። ኤርገሲስ እን፣ “አት ኤበ ቶኮሌ ና ህንሀምብፍኔሬ?” ጄዼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","ይስሃቅሞ አከነ ጄዼ ኤሳዉፍ ዴብሴ፤ “ኩኖ አን አከ እን ስረት ጎፍታ ተኡፊ አከ ፍሮንሳ ሁንድ ተጃጅልቶተሳ ተአን ጎዼረ፤ አከ እን ምዻኒፊ ዳዺ ወይኒ ቀባቱፍስ እሰ ኤብሴረ። ኤጋ ያ እልመኮ አን ማል ሲፍ ጎቹን ደንደአ?” ");
INSERT INTO gaze_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","ኤሳዉስ አባሳቲን፣ “ያ አባኮ፣ አት ኤቡመ ቶኮ ቆፈ ቀብዳ? ያ አባኮ፣ አነስ ኤብስ!” ጄዼ። ኤሳዉስ ሰገሌ ኦል ፉዸቴ ቦኤ። ");
INSERT INTO gaze_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","አባንሳ ይስሃቅስ አከነ ጄዼ ዴብሴፍ፤ “እዶን ጅሬኘኬቲ ለፈ ገበታራ ንፈጋተ፤ ፍጤንሰ ሰሚ ጉባራስ ንፈጋተ። ");
INSERT INTO gaze_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","አት ጎራዴዻን ጅራተ፤ ኦቦሌሰኬስ ንተጃጅልተ። ዬሮ እሳን ሞርምቱት ገሩ ዋንጆሳ ጨብስቴ ሞርመኬራ ቡፍተ።” ");
INSERT INTO gaze_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","ኤሳዉ ሰበቢ አባንሳ ያቆብን ኤብሴፍ ያቆብት ሃሎ ቀበቴ። እንስ ገራሳት፣ “ዬሮን እት አባኮቲፍ ቦአን ዽኣቴረ፤ አንስ ዬሮ ሰነ ኦቦሌሰኮ ያቆብን ነንአጄሰ” ጄዼ ያዴ። ");
INSERT INTO gaze_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","ዮሙ ወን ኤሳዉ እልምሼ ሀንገፍትች ጄዼ እሼት ህመሜት ርብቃን ያቆብ እልመሼ ቁጥሱ ዋምስፍቴ አከነ ጄቴን፤ “ኩኖ፣ ኦቦሌስኬ ኤሳዉ ስ አጄሴ ገራሳ ቀበኔፈቹ በርባደ። ");
INSERT INTO gaze_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","ከናፉ ያ እልመኮ ነ ዸገእ፤ ከኢቲ ገረ ኦቦሌሰኮ ላባ ከን ካራን ኬሰ ጅራቱ ሰናት በቀዹ። ");
INSERT INTO gaze_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","ሀመ ኣሪን ኦቦሌሰኬቲ ቀበናኡት ዬሮ ገባባፍ እሰ ብረ ቱር። ");
INSERT INTO gaze_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","ዮሙ ኣሪን ኦቦሌሰኬቲ ቀበናኤ እንስ ዋን አት እሰ ጎቴ ሰነ እራንፈቱት አን ዻምሰ ስት ኤርጌ አቺ ስን ፍችሲሰ። አን ማሊፈን ጉያ ቶኮት እስን ለቹ ዸበ?” ");
INSERT INTO gaze_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","ርብቃንስ ይስሃቂን አከነ ጄቴ፤ “አን ሰበቢ ዱበርቶተ ሄቶታ ከኔኒፍ ጅራቹ ጅቤረ። ዮ ያቆብ ዱበርቶተ ብየ ከና ጄቹንስ ዱበርቶተ ሄቶታ ከኔን ኬሳ ኒቲ ፉዼ፣ ጅሬኝኮ ማል አናፍ ጎዸሬ!” ");
INSERT INTO gaze_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","ይስሃቅስ ያቆብን ዋሜ ኤብሴ አከነ ጄዼ እሰ አጀጄ፦ “እንተለን ወረ ከነኣን ኬሳ ህንፉዽን። ");
INSERT INTO gaze_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","አሙመ ከኢቲ ገረ ካበ ዽአ ጳዳን አራም መነ አባ ሃዸኬቲ መነ ቤቱኤል ዸቅ። አቺስ እንተለን ኦቦሌሰ ሃዸኬቲ እንተለን ላባ ኬሳ ቶኮ ፉዽ። ");
INSERT INTO gaze_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","ዋቅን ዋን ሁንደ ደንደኡ ሱን ስ ሃኤብሱ፤ ሰኚ ሲፍ ሃኬኑ፤ አከ አት ሰበ በልኣ ታቱፍስ ስ ሃባይእሱ። ");
INSERT INTO gaze_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","አት ብየ አመ አለጉማዻን ኬሰ ጅራቱ፣ ብየ ዋቅን ዻለ ጎዼ አብረሃሚፍ ኬኔ ሰነ አከ ዻልቱፍ እን ኤበ አብረሃሚፍ ኬኔ ሲፊ ሰኚኬቲፍ ሃኬኑ።” ");
INSERT INTO gaze_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","ይስሃቅስ አከስት ያቆብን ኤርጌ፤ ያቆብስ ገረ ካበ ዽአ ጳዳን አራም ገረ ላባ እልመ ቤቱኤል ነምቸ አራም ሰና ዸቄ፤ ላባን ኩንሞ ኦቦሌሰ ርብቃ፣ ሃዸ ያቆቢፊ ኤሳዉ። ");
INSERT INTO gaze_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","ኤሳዉ አከ ይስሃቅ ያቆብን ኤብሴ አከ እን አቺ ኒቲ ፉዹፍ ገረ ካበ ዽአ ጳዳን አራምት እሰ ኤርጌፊ አከ እሰ ኤብሴትስ “እንተለን ወረ ከነኣን ህንፉዽን” ጄዼ እሰ አጀጄ ዮሙ ቤኬት፤ ");
INSERT INTO gaze_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","ያቆብ አባፊ ሃዸሳቲፍ አጀጀሜ ገረ ካበ ዽአ ጳዳን አራም ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","ኤሳዉስ እንተለን ወረ ከነኣን ፉለ አባሳ ይስሃቅ ዱረት ሀመም ጅበሞ አከ ተአን ሁበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","ከናፉ ኤሳው ገረ እሽማኤል እልመ አብረሃም ዸቄ ማሀላት እንተለ እሽማኤል ኦቦሌቲ ነባዮት ኒቶተ ዱር ቀቡረት ደበሌ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","ያቆብ ቤርሼባ በኤ ካራን ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","እንስ እዶ ቶኮ ገኤ አዱን ዺናን አች ቡሌ፤ ዸጎተ አች ቱረን ኬሳስ ቶኮ ፉዸቴ መታ ጀለ ካአቴ ረፉፍ ጪሴ። ");
INSERT INTO gaze_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","እንስ አችት አብጁ አብጆቴ፤ ኩኖ ያበኖ ለፈ ዻበቴ ፊጤንሳሞ ሰሚ ገኡ ቶኮ አርጌ፤ ኩኖ ኤርገሞትን ዋቀዮ ያበኖ ሰነረ ኦል በኣፊ ገድ ቡኣ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","ኩኖ ዋቀዮ ያበኖ ሰነ ገረራ ዻበቴ አከነ ጄዼ፤ “አን ዋቀዮ ዋቀ አባኬ አብረሃሚፊ ዋቀ ይስሃቅ፤ አን ለፈ አትረ ጪፍቱ ከነ ሲፊ ሰኚኬቲፍ ነንኬነ። ");
INSERT INTO gaze_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","ሰኚንኬ አኩመ ብዮ ለፋ ንባይአተ፤ አትስ ገረ ዽኣት፣ ገረ በኣት፣ ገረ ካባቲፊ ክባት ንበበልአተ። ኡመትን ለፈራ ሁንድኑ ከራኬቲፊ ከራ ሰኚኬቲቲን ንኤብፈመ። ");
INSERT INTO gaze_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","ኩኖ አን ስ ወጅነን ጅረ፤ ለፈ አት ዸቅጡ ሁንደትስ ስን ኤገ፤ ገረ ብየ ከናትስ ዴብሴ ስን ፍደ። አን ሀመን ዋነን ዋዳ ሲፍ ገሌ ሰነ ሲፍ ጉቱት ስ ህንዺሱ።” ");
INSERT INTO gaze_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","ያቆብስ ዮሙ ህርባ ከኤት፣ “ዹጉማን ዋቀዮ እዶ ከነ ጅረ፤ አን ዋን ከነ ህንሁበትኔ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","እንስ ሶዳቴ፣ “እዶን ኩን አከም ነመ ሶዳችሰ! ኩን መነ ዋቃት መሌ ዋን ብራ ምት፤ ኩን ከረ ሰሚት” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","ያቆብስ ጉያ እት ኣኑ ገነመ ኦቦሮ ከኤ ዸጋ መታ ጀለ ካአቴ ቱሬ ሰነ ፉዼ አከ ኡቱባት ኦል ዻቤ፤ ፊጤሳረትስ ዘይቲ ዸንገላሴ። ");
INSERT INTO gaze_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","እንስ መቃ እዶ ሰና ቤትኤል ጄዼ ሞጋሴ፤ ዱራን ገሩ መጋላን ሱን ሉዝ ጄዸመ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","ኤርገሲስ ያቆብ አከነ ጄዼ ወሬጌ፤ “ዮ ዋቅን ነ ወጅን ተኤ፣ ዮ እን ከራ አን ዴሙ ከነረት ነ ኤጌ፣ ዮ ዋን አን ኛዹፊ ዋን አን ኡፈዹ ና ኬኔ፣ ");
INSERT INTO gaze_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","ዮ አን ነጋን መነ አባኮት ዴብኤ፣ ዋቀዮ ዋቀኮ ንተአ፤ ");
INSERT INTO gaze_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","ዸጋን አን ኡቱባ ጎዼ ኦል ዻቤ ኩንስ መነ ዋቃ ተአ፤ ዋን አት ና ኬንቱ ኬሳስ ኩዸን ኬሳ ቶኮ ሲፍን ኬነ።” ");
INSERT INTO gaze_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","ያቆብስ ከራሳ እት ፉፌ ገረ ወረ ብየ በኣ ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","እንስ እላሌ ኩኖ ቦለ ብሻኒ ቶኮ ድሬረት አርጌ፤ ኩኖ ከር ሆሎታ ሰዲ ሰበቢ አቺ ብሻን ዹገኒፍ ቦለ ብሻኒ ሰነ ብረ ጭጪሳ ቱረን። ዸጋን አፋን ቦለ ብሻኒ ሰናረ ቱሬ ጉዳ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","ዬሮ ከር ሆሎታ ሁንድ አችት ወልት ቀበመንት ትክሶትን አፋን ቦለ ብሻኒራ ዸጋ ገንገልቸኒ ሆሎተ ብሻን ኦባሱ ቱረን። ኤርገሲሞ ዸጋ ሰነ እዶሳት ዴብሰኒ አፋን ቦለ ብሻኒረ ካኡ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","ያቆብስ ትክሶተ ሰናን፣ “ያ ኦቦሎተኮ፣ እስን ወረ ኤሳት?” ጄዼ ጋፈቴ። እሳንስ፣ “ኑ ወረ ካራኒት” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","እንስ፣ “ላባ እልመ ናሆር ቤክቱ?” ጄዼን። ጀርስ፣ “ኤዬ፣ ቤክነ” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","ያቆብሞ፣ “እን ፈዩማ?” ጄዼ እሳን ጋፈቴ። እሳንስ፣ “ኤዬ፣ ፈዩመ፤ ኩኖ እንተልሳ ራሄልዩ ሆሎተ ፍዴ ዹፋ ጅርት” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","እንስ፣ “ኩኖ፣ አመ ለፍት ጉያዸ፤ ዬሮ እት ሆሎትን ወልት ቀበመን ምት። ሆሎተ ብሻን ኦባሳቲ ዸቃ ዼችሳ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","እሳንስ፣ “ኑ ሀመ ከር ሆሎታ ሁንድኑ ወልት ቀበመኒ ዸጋን ሱን አፋን ቦለ ብሻኒራ ገንገልፈሙት ህንደንዴኙ፤ ኤርገሲ ሆሎተ ብሻን ኦባፍነ” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","ኡቱመ እን ጀረ ወጅን ሃሰኣ ጅሩ፣ ራሄል ዋን ትክሴ ቱርቴፍ ሆሎተ አባሼ ኦፍቴ ዹፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","ያቆብ ዮሙ ራሄል፣ እንተለ ኦቦሌሰ ሃዸሳ እንተለ ላባቲፊ ሆሎተ ላባ አርጌት ዸቄ ዸጋ አፋን ቦለ ብሻኒራ ገንገልቼ ሆሎተ ኤሱመሳ ብሻን ኦባሴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","ያቆብስ ራሄሊን ዹንገቴ፤ ሰገሌ ኦል ፉዸቴስ ቦኤ። ");
INSERT INTO gaze_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","እን ፍረ አባሼ አከ ተኤፊ እልመ ርብቃ አከ ተኤ ራሄልት ህሜ፤ እሼንስ ፊጋ ዸቅጤ አባሼት ህምቴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","ላባን አኩመ ዋኤ እልመ ኦቦሌቲሳ ዋኤ ያቆብ ዸገኤን እሰ ስመቹፍ አሪፈቴ በኤ። እንስ ኤርገ ሀመቴ ዹንገቴ ቦዴ መነሳት ፉዸቴ ገሌ፤ ያቆብስ ዋን ከነ ሁንደ ላባት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","ላባንሞ፣ “አት ዹጉማን ፎንኮቲፊ ዺገኮት” ጄዼን። ያቆብ ኤርገ ጅአ ቶኮ ጉቱ ላባ ወጅን ቱሬ ቦዴ፣ ");
INSERT INTO gaze_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","ላባን አከነ እሳን ጄዼ፤ “አት ሰበቢ ፍረኮ ታቴፍ ቶለ ና ሆጄቹ ቀብዳ? ምንዳንኬ አከ ሀመም ተኡ ቀቡ ነት ህም።” ");
INSERT INTO gaze_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","ላባን እንተለን ለመ ቀበ ቱሬ፤ መቃንሼ ሀንገፋ ልያ ቱሬ፤ መቃንሼ ቁጥሱሞ ራሄል ጄዸመ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","እጅ ልያ ደዸባ ቱሬ፤ ራሄል ገሩ በሬዱፊ ስምቦ ቀቤቲ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","ያቆብ ራሄልን ጃለቴ፣ “አን ዋኤ እንተለኬ እሼ ቁጥሱ፣ ራሄሊፍ ጄዼ ወጋ ቶርበ ስን ተጃጅለ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","ላባንሞ፣ “ነመ ብራፍ እሼ ኬኑረ ሲፍ ኬኑ ና ወየ፤ አሱመ ነ ብረ ቱር” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","ከናፉ ያቆብ ራሄልን አርገቹፍ ጄዼ ወጋ ቶርበ ተጃጅሌ። እን ዋን እሼ ጃለቴፍ ወጎትን ኩኔን ጉዮተ ሙራሰ እሰት ፈካተን። ");
INSERT INTO gaze_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","ያቆብስ ላባዻን፣ “ዋን ዬሮንኮ ጡሙረሜፍ አከ አን እሼ ብረ ገኡፍ ኒቲኮ ና ኬን” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","ከናፉ ላባን ነሞተ እዶ ሰነ ጅረን ሁንደ ወልት ቀቤ ጭዸ ቆጴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","ገሩ ዬሮ ለፍት ገልገላኤት እንተለሳ ልያ ፍዴ ያቆቢፍ ኬኔ፤ ያቆብስ እሼ ብረ ገኤ። ");
INSERT INTO gaze_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","ላባንስ አከ እሼን ሆጄቱሼ ታቱፍ ገርብቲሳ ዝልፋ፣ እንተለሳ ልያዻፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","ዮሙ ለፍት በርኤት ኩኖ ልያ ተኡንሼ ቤከሜ! ያቆብስ ላባዻን፣ “ወን አት ነ ጎቴ ኩን ማል? አን ራሄሊፍ ጄዼ ስ ህንተጃጅሌ? ዮስ አት ማሊፍ ነ ጎዎምስቴሬ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","ላባንስ አከነ ጄዼ ዴብሴ፤ “ብየኬኘ ኬሰት እንተለ ሀንገፈ ዱረ እንተለ ቁጥሱ ሄሩምሲሱን ዱዻኬኘ ምት። ");
INSERT INTO gaze_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","ቶርበን ምስሩማ እንተለ ከና ራወዹ፤ ኤርገሲ ዮ አት ወጋ ብራ ቶርበ ናፍ ሆጄቴ ቁጥሱሼስ ሲፍ ኬንነ።” ");
INSERT INTO gaze_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","ያቆብስ አከሱመ ጎዼ። ቶርበን ሰነስ ልያ ወጅን ደበርሴ፤ ኤርገሲስ ላባን እንተለሳ ራሄልን እሰት ሄሩምሲሴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","ላባን አከ እሼን ሆጄቱሼ ታቱፍ ጦምቦሬሳ ብልሃ፣ እንተለሳ ራሄሊፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","ያቆብስ ራሄል ብረ ገኤ፤ እንስ ልያ ጫላት ራሄልን ጃለቴ። ወጎተ ብራ ቶርበስ ላባፍ ሆጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","ዋቀዮ ዮሙ አከ ልያን ህንጃለተምን አርጌት ገደሜሰሼ በኔፍ፤ ራሄል ገሩ ዸብዱ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","ልያን ኡልፎፍቴ እልመ ዴሴ። እሼንስ ዋን፣ “ዋቀዮ ዽጵነኮ አርጌራቲ ዹጉማን ስአች ዽርስኮ ነ ጃለተ” ጄቴፍ መቃሳ ሩቤን ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","እሼን አመስ ዮሙ ኡልፎፍቴ እልመ ዴሴት፣ “ዋቀዮ ሰበቢ አከ አን ህንጃለተምን ዸገኤፍ እልመ ከነስ ና ኬኔ” ጄቴ መቃሳ ስምኦን ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","አመስ ኡልፎፍቴ እልመ ዴሴ፤ እሼንስ፣ “ሰበቢ አን እልማን ሰዲ እሳፍ ደኤፍ አመ ዽርስኮ ነት መጠነ” ጄቴ፤ ከናፉ ሙጫን ሱን ሌዊ ጄዸሜ ሞጋፈሜ። ");
INSERT INTO gaze_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","አመስ እሼን ኡልፎፍቴ እልመ ዴሴ፤ እሼንስ፣ “አመ ዋቀዮ ነንገለቴፈዸ” ጄቴ። ከናፉ መቃሳ ይሁዳ ጄቴ ሞጋፍቴ። ኤርገሲስ ደኡ ንዺፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","ራሄል ዮሙ አከ ያቆቢፍ እጆሌ ቶኮዩ ህንደእን አርግቴት ኦቦሌቲሼት ህናፍቴ። ያቆቢንስ፣ “እጆሌ ና ኬን፣ ዮ ከና አቺ ነንዱአ!” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","ያቆብስ እሼት ኣሬ፣ “አነቱ እዶ ዋቀ እሰ እጆሌ ስ ዾወቴ ሰና ጅረ ሞ?” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","እሼንስ፣ “ጦምቦሬንኮ ብልሃን ኩኖት፤ አከ እሼን ቆደኮ እጆሌ ናፍ ዴሴ አንስ ከራሼቲን እጆሌ አርገዹፍ ዸቂ እሼ ብረ ገእ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","እሼንስ ጦምቦሬሼ ብልሃ አከ ኒቲሳ ታቱፍ ኬንቴፍ። ያቆብስ እሼ ብረ ገኤ፤ ");
INSERT INTO gaze_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","እሼንስ ኡልፎፍቴ እልመ እሳፍ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","ከነረት ራሄል፣ “ዋቅን ና ሙርቴሴረ፤ ከዸትናኮስ ዸገኤ እልመ ና ኬኔረ” ጄቴ። ከናፉ መቃሳ ዳን ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","ጦምቦሬን ራሄል ብልሃን አመስ ኡልፎፍቴ ያቆቢፍ እልመ ለመፋ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","ራሄልስ፣ “አን ኦቦሌቲኮ ወልኣንሶ ጉዳ ቀቤ ሞአዼረ” ጄቴ። መቃሳ ንፍታሌም ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","ልያን አከ እጆሌ ደኡ ዺፍቴ ሁበቴ፤ ጦምቦሬሼ ዝልፋ ፉቴ አከ ኒቲሳ ታቱፍ ያቆቢፍ ኬንቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","ጦምቦሬን ልያ ዝልፋንስ ያቆቢፍ እልመ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","ልያንሞ፣ “ማል ምልኪን አከና!” ጄቴ መቃሳ ጋድ ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","ጦምቦሬን ልያ ዝልፋን ያቆቢፍ እልመ ለመፋ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","ኤርገሲስ ልያን፣ “አን አከመን ገመዴ! ዱበርቶትንስ፣ ‘ኤብፈምቱ’ ናን ጄዹ” ጄቴ። ከናፉ መቃሳ ኣሼር ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","ዬሮ ሃማ ቀመዲት ሩቤን ገረ በኬት በኤ እጀ ሁዻ አርገቴ ሃዸሳ ልያዻፍ ፍዴ። ራሄልስ ልያዻን፣ “ማሎ እጀ ሁዻ እልመኬቲራ ዋ ና ኬን” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","ልያንሞ፣ “ዽርሰኮ ነራ ፉዸቹንኬ ስት ጥናቴ? ሁዻ እልመኮስ ንፉዸታ?” ጄቴን። ራሄልስ፣ “ቆደ ሁዻ እልመኬቲ እን ኤደነ ስ ወጅን ሃቡሉ” ጄቴን። ");
INSERT INTO gaze_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","ጋፈ ሰነ ገልገለ ዬሮ ያቆብ ለፈ ቆቲሳቲ ገሌት ልያን እሰ ስመቹፍ ገድ ባቴ፣ “ዋን አን ሁዻ እልመኮቲን ስ ክሬፈዼፍ አት ሀርአ ነ ወጅን ቡሉ ቀብደ” ጄቴን። ያቆብስ ሀልከን ሰነ እሼ ወጅን ቡሌ። ");
INSERT INTO gaze_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","ዋቅንስ ልያ ዸገኤ፤ እሼንስ ኡልፎፍቴ ያቆቢፍ እልመ ሸነፋ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","ልያንስ፣ “ዋን አን ጦምቦሬኮ ዽርሰኮቲፍ ኬኔፍ ዋቅን ገቲኮ ና ባሴረ” ጄቴ። ከናፉ ይሳኮር ጄቴ እሰ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","ልያን አመስ ኡልፎፍቴ ያቆቢፍ እልመ ጀአፋ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","ልያንስ፣ “ዋቅን ኬና ጋሪ ናፍ ኬኔረ፤ ሰበቢ አን እልማን ጀአ እሳፍ ደኤፍ ዽርስኮ ስአች ኡልፍነ ና ኬነ” ጄቴ። ከናፉ መቃሳ ዜቡሎን ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","ኤርገሲስ እንተለ ቶኮ ዴሴ ዲና ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","ዋቅንስ ራሄልን ያደቴ፤ ከዸትናሼስ ዸገኤ ገደሜሰሼ በኔፍ። ");
INSERT INTO gaze_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","እሼንስ ኡልፎፍቴ እልመ ዴሴ፣ “ዋቅን ቃኒኮ ነራ ፉዼረ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","እሼንስ መቃሳ ዮሴፍ ጄቴ ሞጋፍቴ፣ “ዋቀዮ እልመ ብራ ናፍ ሃደበሉ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","ኤርገ ራሄል ዮሴፍን ዴሴ ቦዴ ያቆብ ላባዻን አከነ ጄዼ፤ “አከ አን ብየ ዸሎታኮት ዴብኡፍ፣ ገድ ነ ዺስ። ");
INSERT INTO gaze_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","አን ነንዴማቲ ኒቶተኮፊ እጆሌኮ ወረ አን እሳኒፍ ጄዼ ሲፍ ተጃጅሌ ና ኬን። አከ አን ሆጂ ባይኤ ሲፍ ሆጄዼ አትዩ ቤክተ።” ");
INSERT INTO gaze_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","ላባን ገሩ አከነ ጄዼን፤ “ማሎ ዮ አን ፉለኬ ዱረት ፉዸተመ አርገዼ ጅራዼ አሱመ ቱር፤ አን አከ ዋቀዮ ሰበቢኬቲን ነ ኤብሴ ሙልአታን ቤኬራቲ።” ");
INSERT INTO gaze_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","እት ፉፌስ፣ “ሜ ምንዳ አን ሲፍ ከፈሉ ቀቡ ነት ህም፤ አን ሲፍን ከፈላቲ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","ያቆብስ አከነ ጄዼን፤ “አከ አን ሀመም ሲፍ ሆጄዼ፣ ሆሪንኬስ ሀመም አከ ሀርከኮት ባይአቴ አቱ ንቤክተ። ");
INSERT INTO gaze_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","ወን ጥናን አት ኡቱ አን ህንዹፍን ዱረ ቀብዱ ሱን አመ አከ መሌ ሲፍ ባይአቴረ፤ ለፈ አን ቱሬ ከምትዩ ዋቀዮ ስ ኤብሴረ። ገሩ ዬሮን አን እት ማቲኮቲፍ ያዱ ዮምሬ?” ");
INSERT INTO gaze_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","እንስ፣ “ወን አን ሲፍ ኬኑ ማልሬ?” ጄዼ ጋፈቴ። ያቆብሞ አከነ ጄዼ ዴብሴ፤ “ሆማ ናፍ ህንኬንን፤ ገሩ ዮ አት ዋን ከነ ናፍ ጎቴ አን እቱመ ፉፌ ቡሻዬኬ ነንትክሰ፤ ነንኤገስ፤ ");
INSERT INTO gaze_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","አን ሀርአ ቡሻዬኬ ሁንደ ኬሰ በኤ ሆሎተ ጮጮሬፊ ቡቡሬ ሁንደ፣ ሆላ መጋላፊ ሬኦተ ጮጮሬ ዮካን ቡቡሬ ሁንደ አዳን ነንባሰ፤ እሳን ኩኔን ምንዳኮ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","ዬሮ አት ምንዳ ና ኬንቴ ሰነ ቶአቹ ዹፍቱት፣ አመነሙማንኮ ዹጋ ና በአ። ሆሎታፊ ሬኦተኮ ኬሰት ሬኤን ጮጮሬ ዮካን ቡቡሬ ህንተእን ከምዩ፣ ሆላ ኬሳሞ ከን ጉራቸ ህንተእን ከምዩ ዮ አርገሜ አከ ዋን ሀተሜት ሃእላለሙ።” ");
INSERT INTO gaze_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","ላባንስ፣ “ቶሌ፣ አኩመ አት ጄቴ ሃተኡ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","ጉዩመ ሰነ ላባን ኮርቤዪ ሬኤ ሀሉ ቀጣሙሮ ቀበኒፊ ቡቡሬ ሁንደ፣ ጎሮሚ ሬኤ ጮጮሬፊ ቡቡሬ ከኔን አዳዲ ቀበን ሁንደ፣ አከሱመስ ሆሎተ ጉጉራቸ ሁንደ ፉዼ እልማንሳት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","እንስ ኦፊሳቲፊ ያቆብ ግዱት ለፈ አዴምሰ ጉያ ሰዲ ሀምብሴ፤ ያቆብሞ ቡሻዬ ላባ ከኔን ሀፈን ትክሱ እት ፉፌ። ");
INSERT INTO gaze_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","ያቆብስ ደሜ አለልቱ፣ ከን ሎዚቲፊ ሀዼሰ ጂዻሳ ደርቤ ደርቤ ናኔሴ ቆለሳራ ቁንጭሱዻን ዸግነ ሙክቻ እሰ ኬሳ አዲ ሰነ ሙልእሴ። ");
INSERT INTO gaze_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","ያቆብስ ዬሮ ቡሻዬን ሱን ብሻን ዹጉፍ ዹፈንት ደሜ ቆልራ ቁንጭፈሜ ሰነ ፉለሳኒ ዱረ ብድሩ ብሻን እት ኦባሰን ኬሰ ካኤ። ቡሻዬን ዬሮ ሱን ብሻን ዹጉ ዹፈንት ጎጆመአኒ ");
INSERT INTO gaze_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ኡሌ ሰነ ዱረት ወል ሆቦብሱ ቱረን፤ እሳንስ እልሞሌ ሀሉ ቀጣሙሮ ቀበን፣ ጮጮሬፊ ቡቡሬ ዸለን። ");
INSERT INTO gaze_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","ያቆብስ እልሞሌ ቡሻዬ ኮጳት ባሴ፤ ቡሻዬ ላባ ከኔን ሀፈን ገሩ ወረ ሀሉ ቀጣሙሮ ቀበኒፊ ጉራቸ ዱረ ዻቤ። አከስት ሆሎተሳ አዳን ባሴ መሌ ቡሻዬ ላባት ህንመክኔ። ");
INSERT INTO gaze_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","ዬሮ ዸልቱወን ጀጀቦን ጎጆመአን ከምዩ፣ ያቆብ አከ እሳን ኡሌ ሰነ ብረት ወል ሆቦብሰኒፍ ጄዼ ኡሌ ሰነ ፉለሳኒ ዱረ ብድሩ ኬሰ ካኣ ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","ዸልቱወን ደዸቦ ዱረ ገሩ ኡሌ ሰነ ህንኬኜ። ከናፉ ወር ደዸቦን ከን ላባ፣ ወር ጀጀቦንሞ ከን ያቆብ ተአን። ");
INSERT INTO gaze_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","ነምች ኩን ሃለ ከናን አከ መሌ ሶሮሜ፤ እንስ ቡሻዬ ባይኤ፣ ገርቦተ ዱበርቶታቲፊ ዺሮታ፣ ጋለወኒፊ ሀሮተ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","ያቆብስ አከ እልማን ላባ፣ “ያቆብ ዋን አባንኬኘ ቀቡ ሁንደ ፉዸቴረ፤ ቀቤኘ ከነ ሁንደስ ዋኑመ ከን አባኬኛ ቱሬራ አርገቴ” ጄዸን ዸገኤ። ");
INSERT INTO gaze_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","ያቆብስ ፉለ ላባ እላሌ፤ ኩኖ ፉልሳ አከ ዱራት እሰት ህንቶሌ። ");
INSERT INTO gaze_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","ዋቀዮስ ያቆቢን፣ “ብየ አባኬቲፊ ፍረኬት ዴብእ፤ አንስ ስ ወጅን ነንተአ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","ከናፉ ያቆብ አከ እሳን በኬት ለፈ ቡሻዬንሳ ጅረንት ገድ በአኒፍ ገረ ራሄሊፊ ልያት ኤርጋ ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","እንስ አከነ እሳኒን ጄዼ፤ “አን አከ አባንኬሰን አከ ከናን ዱራ ሰነ ፉለ ነት ህንቶሌ ሁበዼረ፤ ገሩ ዋቅን አባኮቲ ነ ወጅን ጅረ። ");
INSERT INTO gaze_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","አከ አን ሁምነኮ ጉቱዻን አባኬሰኒፍ ሆጄዼ እስኑ ቤክቱ፤ ");
INSERT INTO gaze_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","ተኡስ አባንኬሰን ምንዳኮ ዬሮ ኩዸን ጌደሩዻን ነ ጎዎምሴ። ዋቅን ገሩ አከ እን ነ ሚዹ ህንኤየምኔፍ። ");
INSERT INTO gaze_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","ዬሮ እን፣ ‘ቡሻዬን ጮጮሬን ምንዳኬ ተኡ’ ጄዼት፣ ቡሻዬን ሁንድ እልማን ጮጮሬ ዸለን፤ ዬሮ እን፣ ‘ወር ሀሉ ቀጣሙሮ ቀበን ምንዳኬ ተኡ’ ጄዼትሞ ቡሻዬን ሁንድ እልማን ቀጣሙሮ ቀበን ዸለን። ");
INSERT INTO gaze_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","ዋቅን ከራ ከናን ሆሪ አባኬሰኒ ፉዼ ና ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“አንስ ጋፍ ቶኮ ወቅቲ ጋነ ቡሻዬት አብጁ ኬሰ ኦል እላሌ ኩኖ ኮርቤዪን ሬኦተት ሆቦብሰን አከ ሀሉ ቀጣሙሮ ቀበን፣ ጮጮሬፊ ቡቡሬ ተአን ነንአርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","ኤርገማን ዋቀዮስ አብጁ ኬሰ፣ ‘ያቆብ’ ናን ጄዼ። አን፣ ‘ኩኖ አሰን ጅረ’ ጄዼን ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","እንሞ አከነ ናን ጄዼ፤ ‘አከ ኮርቤዪን ሬኦታ ከኔን ቡሻዬት ሆቦብሰን ሁንድኑ ሀሉ ቀጣሙሮ ቀበን፣ ጮጮሬፊ ቡቡሬ ተአን ኦል ጄዺ እላል። አን ዋን ላባን ስት ሆጄቴ ሁንደ አርጌራቲ። ");
INSERT INTO gaze_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","አን ዋቀ ቤትኤል ለፈ አት እት ኡቱባ ድብዴ ወሬገ ናፍ ወሬግዴ ሰናት። አመ ከኢቲ ብየ ከነ ኬሳ በኢቲ ገረ ብየ ፍረኬቲት ዴብእ።’ ” ");
INSERT INTO gaze_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","ከነረት ራሄሊፊ ልያን አከነ ጄዸኒ ዴብሰን፤ “ቆድን ዮካን ዻል መነ አባኬኛት ኑ ሀፌ ጅራ? ");
INSERT INTO gaze_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","እን አኩመ ኦርማት ኑ እላለ ምቲ? እን ኑ ጉርጉረቴራቲ ማለቀ ሰበቢኬኛፍ ኬነሜ ኛቴ ፍጤረ። ");
INSERT INTO gaze_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","ቀቤኝ ዋቅን አባ ኬኘራ ፉዼ ሁንድ ከንኬኛፊ ከን እጆሌኬኛት። ኤጋ ዋን ዋቅን ስት ህሜ ሁንደ ጎዽ።” ");
INSERT INTO gaze_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","ያቆብስ እጆሌሳቲፊ ኒቶተሳ ጋለወንረ ካአቴ፤ ");
INSERT INTO gaze_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","ሆሪፊ ቀቤኘ ካበ ዽአ ጳዳን አራሚት ሆረቴ ሁንደ ኦፍ ዱረ ኦፌ ገረ ብየ ከነኣን አባሳ ይስሃቅ ብረ ዸቁፍ ከኤ። ");
INSERT INTO gaze_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","ላባን ሆሎተሳራ ርፌንሰ ሙርሙሩ ዸቄ፤ ራሄልሞ ዋቆተ አባሼ ሀቴ። ");
INSERT INTO gaze_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","ያቆብስ አከ እሰ ዺሴ በቀቹ ያዴ እሰ ዾክሱዻን ላባን ነምቸ አራም ሰነ ጎዎምሴ። ");
INSERT INTO gaze_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","እንስ ዋን ቀቡ ሁንደ ፉዸቴ በቀቴ፤ ለገ ኤፍራጢስ ጬኤ ብየ ጋረ ግልኣድት ቀጄሌ። ");
INSERT INTO gaze_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","አከ ያቆብ በቀቴ ጉያ ሰደፋት ላባት ህመሜ። ");
INSERT INTO gaze_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","ላባንስ ፍሮተሳ ፉዸቴ ጉያ ቶርበ ያቆብ ዱካ ቡኤ ብየ ጋረ ግልኣድት እሰ ቀቀቤ። ");
INSERT INTO gaze_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","ዋቅንስ ሀልከን አብጁዻን ገረ ላባን ነምቸ ብየ አራም ሰና ዹፌ፣ “አት ዋን ጋሪስ ተኡ ሀማ ቶኮዩ ያቆብት አከ ህንዱበትኔ ኦፍ ኤገዹ” እሳን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","ያቆብ ዬሮ ላባን እሰ ቀቀቤት፣ ብየ ጋራ ግልኣድ ኬሰ ዱንካነሳ ዻበቴ ቱሬ፤ ላባፊ ፍሮትንሳስ አች ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","ላባንስ ያቆቢን አከነ ጄዼ፤ “አት ነ ጎዎምስቴ እንተለንኮ አከ ቦጅአምቶተ ወራናት ፉዸቴ ዴሙንኬ ማል ጎቹኬት? ");
INSERT INTO gaze_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","አት ማሊፍ ዾክሳን በቀቴ? ማሊፍስ ነ ጎዎምስቴ? አከ አን ገመቹፊ ፋርፈናዻን፣ ድቤፊ በገናዻን ስ ጌጌሱፍ ማሊፍ ነት ህሙ ድዴ? ");
INSERT INTO gaze_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","አት አከ አን እጆሌ እጆሌኮቲቲፊ እንተለንኮ ዹንገዼ ነጋት ጄዹ ናፍ ህንኤየምኔ። አት ሆጂ ጎዉማ ሆጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","አን እስን ሚዹፍ ሁምነ ቀበ፤ ገሩ ኤደ ዋቅን አባኬሰኒ፣ ‘አት ዋን ጋሪስ ተኡ ሀማ ቶኮሌ ያቆብት አከ ህንዱበትኔ ኦፍ ኤገዹ’ ናን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","አት ሰበቢ መነ አባኬቲት ዴብኡ አከ መሌ ሀውቴፍ ዴምቴርተ፤ ገሩ ማሊፍ ዋቆተኮ ሀቴ?” ");
INSERT INTO gaze_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","ያቆብስ አከነ ጄዼ ላባፍ ዴቢ ኬኔ፤ “አት እንተለንኬ ሁምናን ነራ ፉዸተ ጄዼ ዋነን ሶዳዼፍ ነንዴሜ። ");
INSERT INTO gaze_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","ነምን አት ዋቆተኬ እሰ ብረት አርገቱ ጅራቹ ህንቀቡ። አከ ወን ከንኬ ተኤ ነ ብረ ጅሩፊ አከ ህንጅሬ አቱ ፉለ ፍሮተኬኛ ዱረት ሰከተእ፤ ዮ ጅራቴሞ ፉዸዹ።” ያቆብ ራሄል ዋቆተ ሰነ ሀቱሼ ያቆብ ህንቤኩ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","ላባንስ ዱንካነ ያቆብ፣ ዱንካነ ልያቲፊ ዱንካነ ጦምቦሬወን ለማኒ ሴኔ ሆማ ዸቤ። ኤርገ ዱንካነ ልያቲ በኤ ቦዴስ ዱንካነ ራሄል ሴኔ። ");
INSERT INTO gaze_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","ራሄልሞ ዋቆተ መነ ኬሳ ሀቴ ሰነ ኮራ ጋለወንሼ ጀለ ኬሴ እረ ታኣ ቱርቴ። ላባንስ ዋን ዱንካንቸ ኬሰ ጅሩ ሁንደ ኬሰ በርባዴ፤ ገሩ ሆማ ህንአርገኔ። ");
INSERT INTO gaze_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","ራሄልስ አባሼቲን፣ “ያ ጎፍታኮ፣ ሰበቢ አን ከኤ ፉለኬ ዱረ ዻበቹ ደዸቤፍ ህንኣርን፤ አን ጡሪን ኦፍራ ቀባ” ጄቴ። እንስ ንሰከተኤ መሌ ዋቆተ ሰነ ህንአርገኔ። ");
INSERT INTO gaze_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","ያቆብስ ላባት ኣሬ እሰት ዼከሜ። እንስ አከነ ጄዼ ጋፈቴ፤ “የክኮ ማል? ወን አት አከነ ነ አደምስቱፍ አን ጩቡ ማሊ ሆጄዼት? ");
INSERT INTO gaze_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","አት ምአኮ ሁንደ ሰከታቴርተ፤ ኤጋ ምአ መነኬቲ ኬሳ ማል አርገቴ? ዮ ጅራቴ ፍሮተኬቲፊ ፍሮተኮ ዱረት ዽኤሲቲ እሳን ኑ ለማን ግዱት ሙርቲ ሃኬነን። ");
INSERT INTO gaze_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“አን ወጎተ ድግደመን ከነ ስ ወጅን ጅራዼረ። ሆሎትኒፊ ሬኦትንኬ ቶኮዩ ህንገተትኔ፤ አን ቡሻዬኬ ኬሳስ ኮርቤዪ ህንኛትኔ። ");
INSERT INTO gaze_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","አን ሆሪ ብኔንስ ጨብሴ ገረኬት ህንፍድኔ፤ ሆሪ በዴስ አነቱ ከፈላ ቱሬ። ዋን ጉያስ ተኡ ሀልከን ሀተሜ ሁንዳፍ አት ነ ከፈልቺፈተ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","ሃል አን ኬሰ ጅራዼ ከነ ቱሬ፤ ጉያ ሆአ፣ ሀልከንሞ ዻሞቸቱ ነ ወጠለ ቱሬ፤ ህርብንስ እጀኮራ በዴ። ");
INSERT INTO gaze_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","አከሲን አን ወጎተ ድግደመን ከነ መነኬ ቱሬ። አን ወጋ ኩዸ አፉር እንተለንኬ ለማኒፍ ጄዼ፣ ወጋ ጀአሞ ቡሻዬኬቲፍ ጄዼ ሲፍ ሆጄዼረ፤ አትሞ ዬሮ ኩዸን ምንዳኮ ጌደርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","ዋቅን አባኮ፣ ዋቅን አብረሃም፣ ሶዳን ይስሃቅ ኡቱ ነ ወጅን ጅራቹ ባቴ አት ስላ ሀርከ ዱዋ ነ ባስተ ቱርቴ። ዋቅን ገሩ ረክነኮፊ ደዸቢኮ አርጌ ኤደ ስት ዼከሜ።” ");
INSERT INTO gaze_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","ላባን አከነ ጄዼ ያቆቢፍ ዴብሴ፤ “ዱበርቶትን ኩኔን እንተለንኮት፤ እጆሌን ኩኔንስ እጆሉመኮት፤ ቡሻዬን ኩኔንስ ቡሻዬኮት። ወን አት አርግቱ ሁንድ ከኑመኮት። ዮስ አን ዋኤ እንተለንኮ ከኔኒቲፊ ዋኤ እጆሌ እሳን ደአኒ ሀርአ ማል ጎቹን ደንደአ? ");
INSERT INTO gaze_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","ኮቱ ሜ አኒፊ አት አመ ወሊ ከከትና፤ ከኩን ኩንስ አናፊ ስ ግዱት ረጋ ሃተኡ።” ");
INSERT INTO gaze_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","ያቆብስ ዸጋ ቶኮ ፉዼ አከ ኡቱባት ዻቤ። ");
INSERT INTO gaze_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","እንስ ፍሮተሳቲን፣ “ዸጋ ወልት ቀባ” ጄዼ። እሳንስ ዸጋ ወልት ቀበኒ ቱለን፤ ጀርስ ቱላ ሰነ ብረት ኛተ ኛተን። ");
INSERT INTO gaze_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","ላባን ቱላ ሰናን “ይጋርሰሃዱታ” ጄዼ ሞጋሴ፤ ያቆብሞ “ግልኣድ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","ላባንስ፣ “ቱላን ኩን አናፊ ስ ግዱት ረጋዸ” ጄዼ። ጋለኣድ ጄዸሙንሳ ከኑማፍ። ");
INSERT INTO gaze_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","አከሱመስ ሚስጳ ጄዸሜ፤ ላባን አከነ ጄዼ ቱሬቲ፤ “ዬሮ ኑ ገርገር ባኑት ዋቀዮ ሲፊ አነ ግዱት ኤግዱ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","ዮ አት እንተለንኮ ረክፍቴ ዮካን ዮ አት እንተለንኮረት ኒቶተ ብራ ፉቴ፣ ዮ ነምን ቶኮዩ ኑ ብረ ህንጅሬ ኩኖ ዋቅን አናፊ ስእ ግዱት ረጋዸ።” ");
INSERT INTO gaze_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","ላባን አመስ ያቆቢን አከነ ጄዼ፤ “ቱላ ከናፊ ኡቱባ አን ሲፊ አነ ግዱ ዻቤ ከነ እላል። ");
INSERT INTO gaze_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","አከ አን ስ ሚዹፍ ጄዼ ቱላ ከነ ደርቤ ገረኬት ህንጬኔ፣ አከ አትስ ነ ሚዹፍ ጄቴ ቱላ ከናፊ ኡቱባ ከነ ደበርቴ ገረኮት ህንጬኔ ቱላን ኩን ረጋዸ፤ ኡቱባን ኩንስ ረጋዸ። ");
INSERT INTO gaze_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","ዋቅን አብረሃም፣ ዋቅን ናሆር፣ ዋቅን አቦቲሳኒ ኑ ግዱት ሙርቲ ሃኬኑ።” ያቆብስ አከስት መቃ ሶዳ አባሳ ይስሃቂን ከከቴ። ");
INSERT INTO gaze_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","እንስ ብየ ጋራ ሰነት ኣርሳ ዽኤሴ ፍሮተሳ ኛተት ዋሜ። እሳንስ ኤርገ ኛተኒ ቦዴ አቹመ ቡለን። ");
INSERT INTO gaze_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","ላባንስ ጉያ እት ኣኑ ገነመ በሪዻን ከኤ እጆሌ እጆሌሳቲፊ እንተለንሳ ዹንገቴ እሳን ኤብሴ። ኤርገሲስ አቺ ከኤ ገረ እዶሳት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","ያቆብስ ከራሳ እት ፉፌ፤ ኤርገሞትን ዋቀዮስ እሰት ዹፈን። ");
INSERT INTO gaze_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","እንስ ዮሙ እሳን አርጌት፣ “ኩን ቡፈተ ዋቃት” ጄዼ፤ እዶ ሰነስ መሀነዪም ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","ያቆብስ ገረ ኦቦሌሰሳ ኤሳዉ ከን ብየ ኤዶም ለፈ ሴኢር ጄዸሙ ኬሰ ጅራቱት ኤርገሞተ ኦፍ ዱረ ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","እንስ አከነ ጄዼ እሳን አጀጄ፦ “እስን ጎፍታኮ ኤሳዉን አከነ ጄዻ፦ ‘ገርብችኬ ያቆብ አከነ ጄዸ፤ አን ላባ ብረ ጅራዼ ሀመ አማትስ እሱመ ብረን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","አን ሎኒፊ ሀሮተ፣ ሆሎታፊ ሬኦተ፣ ሆጄቶተ ዺራቲፊ ዱበርቶተስ ቀበ። አመስ አን ፉለኬ ዱረት ሱራ አከን አርገዹፍ ኤርጋ ከነ ጎፍታኮት ነንኤርገ።’ ” ");
INSERT INTO gaze_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","ኤርገሞትን ሱንስ ገረ ያቆብት ዴብአኒ፣ “ኑ ኦቦሌሰኬ ኤሳዉ ብረ ዸቅኔረ፤ እንስ ስ ስመቹፍ ዹፋ ጅረ፤ ነሞትን ዽበ አፉር እሰ ወጅን ጅሩ” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","ያቆብስ አከ መሌ ሶዳቴ ዽጰቴ፤ ነሞተ እሰ ወጅን ቱረንስ ገሬ ለመት ቆዴ፤ ቡሻዬ፣ ሎወኒፊ ጋለወንሌ አከሱመ ገሬ ለመት ቆዴ። ");
INSERT INTO gaze_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","እንስ፣ “ዮ ኤሳዉ ዹፌ ገሬ ቶኮ ዸኤ፣ ገሬን ካን ጀላ በአ” ጄዼ ያዴ። ");
INSERT INTO gaze_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","ያቆብ አከነ ጄዼ ከዸቴ፤ “ያ ዋቀ አባኮ አብረሃም፣ ዋቀ አባኮ ይስሃቅ፣ ያ ዋቀዮ፣ እሰ ‘አት ገረ ብየኬቲፊ ገረ ፍሮተኬቲት ዴብእ፣ አን ዋን ጋሪ ሲፍን ጎዻ’ ናን ጄቴ ሱን፣ ");
INSERT INTO gaze_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","አን ጋሩማፊ አመነሙማ አት አነ ገርብቸኬ አርግሲፍቴ ከነ ሁንዳፍ ህንመሉ። አን ዬሮ ዮርዳኖስ ከነ ጬኤት ኡሌኮ ቆፈ ቀበን ቱሬ፤ አመ ገሩ ገሬ ለመ ተኤን ጅረ። ");
INSERT INTO gaze_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","አን አከ አት ሀርከ ኦቦሌሰኮ ኤሳዉ ጀላ ነ ባስቱ ስን ከዸዸ። አን፣ ‘እን ዹፌ ነ አጄሰ፤ ሃዾተስ እጆሌሳኒ ወጅን ንአጄሰ’ ጄዼ ሶዳዼራቲ። ");
INSERT INTO gaze_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","አት ገሩ፣ ‘አን ዹጉማን ዋን ጋሪ ሲፍን ጎዸ፤ ሰኚኬስ አከ ጭረቸ ገላና ከን ለካአሙ ህንደንዴኜ ሰና ነንጎዸ’ ጄቴርተ።” ");
INSERT INTO gaze_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","እን ሀልከን ሰነ አቹመ ቡሌ፤ ዋን ኦፍ ብራ ቀቡ ኬሳስ ኬና ኦቦሌሰሳ ኤሳዉፍ ኬኑ ፍለቴ፤ ");
INSERT INTO gaze_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","እሳንስ ሬኦተ ዸልቱ ዽበ ለመ፣ ኮርቤዪ ሬኤ ድግደመ፣ ሆሎተ ዸልቱ ዽበ ለመ፣ ኮርቤዪ ሆላ ድግደመ፣ ");
INSERT INTO gaze_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","ጋለወን ዸላ ሶዶመ እልማንሳኒ ወጅን፣ ሳወን አፉርተመ፣ ጅቦተ ሎኒ ኩዸን፣ ሀሮተ ዸልቱ ድግደመ፣ ወደለ ሀሮታ ኩዸን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","እንስ ከረ ከራን አዳን ባሴ ተጃጅልቶተሳት ኬኔ፣ “ነ ዱረ ደርባ ዴማ፤ ከረወን ሆሪ ግዱትስ ለፈ ሀምብሳ” ጄዼ ተጃጅልቶተሳ አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","ነምቸ ፉለ ዱራን ጅሩ ሰናንስ አከነ ጄዼ፦ “ዮ ኤሳው ኦቦሌስኮ ስት ዹፌ፣ ‘አት ከን ኤኙት? ኤሰ ዸቅጠ? ሆሪን ፉለኬ ዱረ ጅሩ ኩን ከን ኤኙት?’ ጄዼ ስ ጋፈቴ፣ ");
INSERT INTO gaze_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","አት፣ ‘ከን ገርብቸኬ ያቆብ። እሳንስ ኬና ጎፍታኮ ኤሳዉፍ ኤርገመኒዸ፤ ኩኖ፣ ያቆብስ ኑ ዱባን ዹፋ ጅረ’ ጄቹ ቀብደ።” ");
INSERT INTO gaze_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","ነምቸ ለመፋ፣ ሰደፋፊ ወረ ከረወን ሰነ ፋነ ዴመን ሁንደስ አከነ ጄዼ አጀጄ፤ “እስንስ ዮ ኤሳዉን አርግተን ዋኑመ ከነ እሰት ህማ። ");
INSERT INTO gaze_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","አከሱመስ፣ ‘ኩኖ ገርብችኬ ያቆብ ኑ ዱባን ዹፋ ጅረ’ ጄዻ።” እን፣ “አን ኬና ኦፍ ዱረ ኤርጌፍ ከናን እሰ ነንአራርፈዸ፤ ኤርገሲሞ አን ዮሙን እሰ አርጉት ተሪ እን ነ ስመተ ተአ” ጄዼ ያዴ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","ኬናን ያቆቢስ እሰ ዱረ ደርቤ፤ ያቆብ ገሩ ሀልከን ሰነ ቁበተ ሰነ ኬሰ ቡሌ። ");
INSERT INTO gaze_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","ሀልከኑመ ሰነ ያቆብ ከኤ ኒቶተሳ ለማን፣ ጦምቦሬወንሳ ለማኒፊ እልማንሳ ኩዸ ቶኮ ፉዸቴ መልካ ያቦቅ ጬኤ። ");
INSERT INTO gaze_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","እንስ ኤርገ ለገ እሳን ጬስሴ ቦዴ ቀቤኘሳ ሁንደ ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","ያቆብሞ ኮጳሳ ሀፌ፤ ነምች ቶኮስ ሀመ ለፍት በሪቱት ወልኣንሶ እሰ ቀቤ። ");
INSERT INTO gaze_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","ነምችስ ዮሙ አከ ያቆብን ሞአቹ ህንደንዴኜ አርጌት፣ ቡሳ ሉቄቱ ያቆብ ቱቄ፤ ዬሮ እን ነምቸ ወጅን ወልኣንሶ ቀቤትስ ሉቄቱን ያቆብ ንአዶዴ። ");
INSERT INTO gaze_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","ነምችስ፣ “ዋን በርኡ ገኤፍ ገድ ነ ዺስ” ጄዼ። ያቆብ ገሩ፣ “ዮ አት ነ ኤብፍቴ መሌ አን ገድ ስ ህንዺሱ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","ነምችስ፣ “መቃንኬ ኤኙ” ጄዼ እሰ ጋፈቴ። እንሞ፣ “ያቆብ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","ነምችስ፣ “አት ሰበቢ ዋቃፊ ነሞተ ወጅን ወልኣንሶ ቀብዴ ሞአቴፍ ስአች እስራኤል ጄዸምተ መሌ ያቆብ ህንጄዸምቱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","ያቆብስ፣ “ማሎ መቃኬ ነት ህም” ጄዼን። እን ገሩ፣ “አት ማሊፍ መቃኮ ጋፈተ?” ጄዼን። ኤርገሲስ እን አቹመት እሰ ኤብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","ያቆብስ፣ “አን እፋን እፈት ዋቀ አርጌራቲ፤ ሉቡንኮ ገሩ ኦልፈምቴርት” ጄዼ እዶ ሰነ ጴኒኤል ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","አኩመ እን ጴኑኤልን ደርቤን አዱን እሰት ባቴ፤ እንስ ሰበቢ ሉቄቱሳቲፍ ኦኮላ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","ከናፉ እስራኤሎትን ሀመ ሀርኣት ርቡ ተፋ ህንኛተን፤ እን ቡሳ ሉቄቱ ያቆብ ከን ተፋን ወል ቀበቱ ቱቄ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","ያቆብስ ኦል ጄዼ እላሌ ኩኖ ኤሳዉ ነሞተ ዽበ አፉር ወጅን ኡቱ ዹፋ ጅሩ አርጌ፤ እንስ ልያት፣ ራሄሊፊ ጦምቦሬወን ለማንት እጆሌ ገርገር ህሬ። ");
INSERT INTO gaze_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","ጦምቦሬወኒፊ እጆሌሳኒ ዱረ ኣንሴ፤ ልያፊ እጆሌሼ እት ኣንሴ፣ ራሄሊፊ ዮሴፍንሞ ዱግደ ዱበ ቡሴ። ");
INSERT INTO gaze_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","ኦፊሳቲሞ እሳን ዱረ ደርቤ ሀመ ኦቦሌሰሳ ብረ ገኡት ዬሮ ቶርበ ለፈት ገድ ጄዼ ሀርከ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","ኤሳዉ ገሩ ያቆብን ስመቹፍ እት ፊጌ እሰ ሀመቴ፤ ሞርመ እሳትስ መርሜ እሰ ዹንገቴ። እሳን ለቸኑ ወልት ቦአን። ");
INSERT INTO gaze_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","ኤሳዉስ ኦል ጄዼ እላሌ ዱበርቶታፊ እጆሌ አርጌ፣ “ወር ስ ወጅን ጅረን ኩኔን ኤኙ?” ጄዼ ጋፈቴ። ያቆብስ ዴብሴ፣ “እሳን እጆሌ ዋቅን አርጁማዻን አነ ገርብቸኬቲፍ ኬኔዸ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","ጦምቦሬወኒፊ እጆሌንሳኒ ዽኣተኒ ገድ ጄዸኒ ሀርከ ፉዸን። ");
INSERT INTO gaze_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","እት ኣንሰኒስ ልያፊ እጆሌንሼ ዹፈኒ ገድ ጄዸኒ ሀርከ ፉዸን። ዹመረትሞ ዮሴፊፊ ራሄል ዹፈኒ ገድ ጄዸን ሀርከ ፉዸን። ");
INSERT INTO gaze_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","ኤሳዉ፣ “ቡሻዬፊ ሎን አን አርጉ ኩን ሁንድ ማል?” ጄዼ ጋፈቴ። ያቆብስ፣ “አን ፉለኬ ፉለ ጎፍታኮ ዱረት ፉዸተመ አርገቹፍ ጄዼት” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","ኤሳዉሞ፣ “ያ ኦቦሌሰኮ አን ዋን ነ ገኡ ቀበ። አት ዋን ቀብዱ ኦፉመኬቲ ሀምብፈዹ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","ያቆብስ አከነ ጄዼ፤ “ማሎ አከስ ምት! ዮ አን ፉለኬ ዱረት ፉዸተመ አርገዼ ጅራዼ፣ ኬና ከነ ነ ሀርካ ፉዸዹ። ኤጋ አመ አት ፉለ ቶላዻን ነ ስመቴርተ፤ ፉለኬ አርጉን አናፍ አኩመ ፉለ ዋቃ አርጉቲ። ");
INSERT INTO gaze_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","ሰበቢ ዋቅን ነት አርጆሜ አንስ ዋን ነ በርባችሱ ሁንደ ቀቡፍ ማሎ ኬና አን ሲፍ ፍዴ ከነ ፉዸዹ።” ኤሳዉስ ዋን ያቆብ ጭምሴ እሰ ከዸቴፍ ኬና ሰነ ንፉዸቴ። ");
INSERT INTO gaze_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","ኤሳዉስ፣ “ኮቱ ከራኬኘ እት ፉፍኔ ሃዴምኑ፤ አን ስ ዱረ ነንቡኣ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","ያቆብ ገሩ አከነ እሳን ጄዼ፤ “አከ እጆሌን ደዸቦ ተአኒፊ አከ አንስ ሆሎታፊ ሳወን ሆስሰኒፍ ኩኑንሰ ጎቹ ቀቡ አት ጎፍታንኮ ንቤክተ። ሆሪን ኩኔን ዮ ጉዩመ ቶኮን ጀርጀርሱዻን ኦፈመን ሁንድሳኒ ንዹሙ። ");
INSERT INTO gaze_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","ጎፍታንኮ ገርብቸሳ ዱረ ደርቤ ሃዴሙ፤ አንሞ ሀመን ሴኢርት ጎፍታኮ ቀቀቡት አኩመ ሁምነ ቡሻዬ ፉለኮ ዱረ ጅሩቲፊ አኩመ ሁምነ እጆሌት ሱተ ጄዼ ነንዴመ።” ");
INSERT INTO gaze_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","ኤሳዉስ፣ “ዮስ ነሞተኮ ኬሳ ሙራሰ ስ ብረት ነንዺሰ” ጄዼ። ያቆብሞ፣ “ኩን ማሊፍ በርባችሳ? ፉለ ጎፍታኮ ዱረት ፉዸተመ አርገቹን ቆፍት ነ ገአ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","ኤሳዉስ ጉዩመ ሰነ ከራሳረ ሴኢርት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","ያቆብ ገሩ ሱኮት ዸቄ አችት ኦፊሳቲፍ መነ እጃረቴ፤ ሆሪሳቲፍሞ ዳሲ እጃሬ። ከናፉ እዶን ሱን ሱኮት ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","ያቆብ ኤርገ ካበ ዽአ ጳዳን አራሚቲ ዴብኤ ቦዴ ነጋን መጋላ ሼኬም እሼ ብየ ከነኣን ኬሳ ሰነ ገኤ ፉለ መጋለቲ ዱረ ቁበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","እንስ ለፈ ዱንካነሳ እረ ዻበቴ ሰነ እልማን ሀሞርራ ሜቲ ዽባን ብተቴ፤ ሀሞርሞ አባ ሼኬም። ");
INSERT INTO gaze_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","ያቆብስ አችት እዶ ኣርሳ እጃሬ ኤል ኤሎሄ እስራኤል ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","ዲናን እንተል ልያን ያቆቢፍ ዴሴ ሱን ዱበርቶተ ብየቲ እላሉዻፍ ገድ ባቴ። ");
INSERT INTO gaze_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","ሼኬም እልም ሀሞር ነምቸ ጎሰ ሂዊ ከን ቡልቻ ብየ ሰና ቱሬ እሼ አርጌ፤ እንስ ቀቤ ሁምናን እሼ ጉዴዴ። ");
INSERT INTO gaze_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","ቀልቢንሳስ ዲና እንተለ ያቆቢን ፉዸተሜ፤ እንስ እሼ ጃለቴ አፋን ቶላ እት ዱበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","ሼኬምስ አባሳ ሀሞሪን፣ “እንተለ ከነ ነ ፉስስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","ያቆብ ዮሙ እንተልሳ ዲናን አከ ጉዴደምቴ ዸገኤት፣ እልማንሳ ድሬረ ሆሪ ትክሱ ቱረን፤ ከናፉ ያቆብ ሀመ እሳን ገለንት ንጨልእሴ። ");
INSERT INTO gaze_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","ሀሞር አባን ሼኬምስ ያቆብ ወጅን ዱበቹ ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","እልማን ያቆብስ አኩመ ዋን ኡመሜ ሰነ ዸገአኒን ድሬዻ ዹፈን። እሳንስ ሰበቢ ሼኬም እንተለ ያቆብ ወጅን ጪሱዻን እስራኤል ኬሰት ዋን ጅብሲሳ ሆጄቴፍ ንገደን፤ አከ መሌስ ኣረን። ");
INSERT INTO gaze_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","ሀሞር ገሩ አከነ እሳኒን ጄዼ፤ “ቀልቢን እልመኮ ሼኬም እንተለኬሰንረ ቡኤረ። ማሎ እሰት እሼ ሄሩምሲሳ። ");
INSERT INTO gaze_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","ፉዻፊ ሄሩማን ወልት ፍሮምና፤ እንተለንኬሰን ኑ ኬና፤ እንተለንኬኘስ ፉዻ። ");
INSERT INTO gaze_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","ኑ ወጅን ጅራዻ፤ ብየቲን ፉለኬሰን ዱረ ጅርት፤ ኬሰ ጅራዻቲ እት ደልደላ፤ ቀቤኘስ እት ሆረዻ።” ");
INSERT INTO gaze_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","ሼኬምስ አባ ዲናቲፊ ኦቦሎተሼቲን አከነ ጄዼ፤ “አን ፉለኬሰን ዱረት ፉዸተመ አርገትናን ዋኑመ እስን ናን ጄተን እስኒፍ ነንኬነ። ");
INSERT INTO gaze_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","እስንስ ገበረ ምስርቲቲፊ ኬና አን ፍዱ ቀቡ ሀመ ፌተን ነት ሙራ፤ አንስ ዋን እስን ናን ጄተን ነንባሰ። እንተለቲ ቆፈ ነት ሄሩምሲሳ።” ");
INSERT INTO gaze_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","እልማን ያቆብሞ ዋን ሼኬም ኦቦሌቲሳኒ ዲና ጉዴዴፍ ዬሮ ሼኬሚፊ አባሳ ሀሞሪፍ ዴቢ ኬነንት ሀጡማዻን ዱበተን። ");
INSERT INTO gaze_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","እሳንስ አከነ እሳኒን ጄዸን፤ “ኑ ዋን አከና ጎቹ ህንደንዴኙ፤ ኑ ነመ ዸግነ ህንቀበትኒፍ እንተለኬኘ ኬኑ ህንደንዴኙ። ኩን ኑፍ ሰልጵነ። ");
INSERT INTO gaze_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","ኑ ዋን ቶኮ ቆፋን ቶሌ እስኒን ጄነ፤ ኩንስ ዮ እስን ዺረኬሰን ሁንደ ዸግነ ቀብደኒ አኩመኬኘ ታተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","ኤርገሲ ኑ እንተለንኬኘ እስኒ ኬንነ፤ እንተለንኬሰንሞ ንፉነ። ግዱኬሰን ንጅራትነ፤ እስን ወጅንስ ሰበ ቶኮ ንታነ። ");
INSERT INTO gaze_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","ገሩ ዮ እስን ዸግነ ቀበቹ ድደን ኑ ኦቦሌቲኬኘ ፉዸትኔ ዴምነ።” ");
INSERT INTO gaze_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","ዱቢንሳኒ ሀሞሪፊ ሼኬም እልመ ሀሞር ንገመቺሴ። ");
INSERT INTO gaze_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","ሼኬም ነሞተ መነ አባሳ ጅራተን ሁንደ ጫላ ከበጀማ ቱሬ፤ እን ሰበቢ እንተለ ያቆብት ገመዴፍ ዋን ከነ ለፈረ ህንሀርክፍኔ፤ ");
INSERT INTO gaze_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","ሀሞሪፊ እልምሳ ሼኬም ገረ ከረ መጋላሳኒ ዹፈኒ ነሞተ መጋላሳኒቲን አከነ ጄዸን፤ ");
INSERT INTO gaze_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“ጀር ኩን ኑፍ ወረ ነጋት፤ ከናፉ ብየቲ ኬሰ ጅራተኒ እት ሃደልደለተን። ብየቲን እሳኒፍ ለፈ በልኣ ቀብድ፤ ኑ እንተለንሳኒ ሃፉኑ፤ እሳንስ እንተለንኬኘ ሃፉዸን። ");
INSERT INTO gaze_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","ገሩ ነሞትን ኩኔን አከ ሰበ ቶኮት ኑ ወጅን ጅራቹፍ ቶሌ ከን ጄዸን ዮ ዺሮንኬኘ አኩመሳኒ ዸግነ ቀበተን ቆፈ። ");
INSERT INTO gaze_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","ሎንሳኒ፣ ቀቤኝሳኒቲፊ ሆሪንሳኒ ካን ሁንድኑ ከኑመኬኘ ህንተአኒ? ከናፉ ኮታ ቶሌ እሳኒን ጄና፤ እሳንስ ኑ ወጅን ንጅራቱ።” ");
INSERT INTO gaze_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","ነሞትን ከረ መጋላ ሰናቲን ገድ በአን ሁንድኑ ሀሞሪፊ እልመሳ ሼኬሚን ወሊ ገለን፤ ዺሮትን ከረ መጋላ ሰናቲን ገድ በአን ሁንድኑስ ዸግነ ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","ጉያ ሰዲ ቦዴ ኡቱመ እሳን ዹኩብሰቻ ጅረኑ፣ እልማን ያቆቢ ኬሳ ነምን ለመ ስምኦኒፊ ሌዊን፣ ኦቦሎትን ዲና፣ ጎራዴሳኒ ፉዸተኒ መጋላ ሆማ ቁበ ህንቀብኔ ሰነ ዸአኒ ዺረ ሁንደ አጄሰን። ");
INSERT INTO gaze_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","እሳንስ ጎራዴዻን ሀሞሪፊ እልመሳ ሼኬምን አጄሰኒ ዲናሞ መነ ሼኬሚቲ ፉዸተኒ ቀጄለን። ");
INSERT INTO gaze_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","እልማን ያቆብስ ሬፈወንረ ደርበኒ መጋላ ኦቦሌቲንሳኒ እት ጉዴደምቴ ሰነ ሳመን። ");
INSERT INTO gaze_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","እሳንስ ቡሻዬሳኒ፣ ሎንሳኒ፣ ሀሮተሳኒቲፊ ዋን እሳን መጋላ ኬሳፊ አላ ቀበን ሁንደ ፉዸተን። ");
INSERT INTO gaze_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","ቀቤኘሳኒ ሁንደ፣ ዱበርቶታፊ እጆሌሳኒ ሁንደ ፉዸተኒ ዴመን፤ ዋን መነ ኬሰ ጅሩ ሁንደስ ንቦጅአን። ");
INSERT INTO gaze_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","ያቆብስ ስምኦኒፊ ሌዊዻን አከነ ጄዼ፤ “እስን አከ አን ከነኣኖታፊ ፌርዞተ ብየ ከነ ጅራተንት ጥሬፈተሙ ጎቹዻን ረኮ ነት ፍደን። ኑ ባይእናን ጥኖዸ፤ ዮ እሳን ሁምነ ወልት ደበለተኒ ነ ሎለን አኒፊ ወር መነኮ ሁንድኑ ንዹምነ።” ");
INSERT INTO gaze_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","እሳን ገሩ፣ “ዮስ እን አኩመ ሰጋገልቱ ቶኮት ኦቦሌቲኬኘት ሃተጰቱሬ?” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","ዋቅን ያቆቢን፣ “ከኢቲ ቤትኤልት ኦል በኢ አች ጅራዹ፤ አችትስ ዋቀ ዬሮ አት ኦቦሌሰኬ ኤሳዉን በቀቴት ስት ሙልአቴ ሰናፍ እዶ ኣርሳ ቶልች” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","ያቆብ ወረ መነሳ ጅረኒፊ ወረ እሰ ወጅን ቱረን ሁንዳን አከነ ጄዼ፤ “ዋቆተ ኦርማ ከኔን እስን ኦፍ ብራ ቀብደንራ ፈጋዻ፤ ኦፍ ቁልቁሌሳ፤ ኡፈተኬሰንስ ጌደረዻ። ");
INSERT INTO gaze_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","ኮታ ካኔ ቤትኤልት ኦል ባና፤ አንስ አችት ዋቀ ጋፈ ረክነኮቲ ዴቢ ና ኬኔ እሰ እዶ አን ዸቄ ሁንዱመት ነ ወጅን ቱሬ ሰናፍ እዶ ኣርሳ ነንቶልቸ።” ");
INSERT INTO gaze_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","እሳንስ ዋቆተ ኦርማ ከኔን እሳን ኦፍ ብራ ቀበን ሁንዳፊ ሎቲ ጉረሳኒ ያቆብት ኬነን፤ ያቆብስ ፉዼ ቅልጡ ሼኬሚ ጀለት አዋሌ። ");
INSERT INTO gaze_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","እሳንስ ከአኒ ቀጄለን፤ አከ ነምን ቶኮዩ እሳን ዱካ ህንቡኔፍ ናስሱን ዋቃ መጋላወን ናኖሳኒ ጅረንረ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","ያቆቢፊ ነሞትን እሰ ወጅን ቱረን ሁንድ ገረ ሉዝ ከን ቤትኤል ጄዸምቱ እሼ ብየ ከነኣን ኬሰት አርገምቱ ሰና ዹፈን። ");
INSERT INTO gaze_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","እንስ አችት እዶ ኣርሳ ቶልቼ ሰበቢ ዬሮ እን ኦቦሌሰሳ ጀላ በቀቻ ቱሬት ዋቅን አችት እሰት ኦፍ ሙልእሴፍ እዶ ሰነ ኤል ቤትኤል ጄዼ ዋሜ። ");
INSERT INTO gaze_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","ዴቦራን ጉድፍቱን ርብቃ ዱቴ ቤትኤሊ ገድት ቅልጡ ጀለት አዋለምቴ። መቃንሳስ አሎንባኩት ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","ኤርገ ያቆብ ካበ ዽአ ጳዳን አራሚቲ ዴብኤ ቦዴ ዋቅን አመስ እሰት ሙልአቴ እሰ ኤብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","ዋቅን፣ “መቃንኬ ያቆብ፤ ስአች ገሩ አት ያቆብ ህንጄዸምቱ፤ መቃንኬ እስራኤል ጄዸመ” ጄዼን። መቃንሳስ እስራኤል ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","ዋቅን አከነ እሳን ጄዼ፤ “አን ዋቀ ዋን ሁንደ ደንደኡዸ፤ ሆር፤ ባይአዹስ። ሰብኒፊ ወልዳን ሰቦታ ስራ አርገሙ፤ ሞቶትንስ ሙዺኬ ኬሳ በኡ። ");
INSERT INTO gaze_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","አን ብየ አብረሃሚፊ ይስሃቂፍ ኬኔ ሲፍስ ነንኬነ፤ አን ብየ ከነ ሰኚኬ ወረ ስ ቦዴቲፍስ ነንኬነ።” ");
INSERT INTO gaze_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","ዋቅንስ እዶ እት እሰ ወጅን ሃሰኣ ቱሬ ሰነት እሰ ዺሴ ኦል በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","ያቆብ እዶ እት ዋቅን እሰ ወጅን ዱበቴ ሰነ ኡቱባ ዸጋ ቶኮ ዻቤ ኬና ዹጋቲረት ዸንገላሴ፤ ዘይቲስ እረት ዸንገላሴ። ");
INSERT INTO gaze_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","ያቆብስ እዶ እት ዋቅን እሰ ወጅን ዱበቴ ሰነ ቤትኤል ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","እሳንስ ቤትኤሊ ከአኒ አዴምሰሳኒ እት ፉፈን። አኩመ እሳን ኤፍራታት ዽኣተኒንስ ራሄል ጭኒንሱን ቀበምቴ አከ መሌ ሙደምቴ። ");
INSERT INTO gaze_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","ኡቱ እሼን ደኡፍ ጭኒንሱ ጀባ ኬሰ ጅርቱስ ዴስፍቱን፣ “አት ዋን እልመ ብራ ዴሱፍ ህንሶዳትን” ጄቴን። ");
INSERT INTO gaze_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","ራሄል ገሩ ዋን ዱኡ ጌሴፍ ኡቱመ ሉቡንሼ በኣ ጅርቱ ቤን-ኦኒ ጄቴ እልመሼ ሞጋፍቴ። አባንሳ ገሩ ቤንያም ጄዼ እሰ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","አከሲን ራሄል ዱቴ ከራ ኤፍራታት ጌሱረት አዋለምቴ፤ ኤፍራታን ኩንሞ ቤትልሄም። ");
INSERT INTO gaze_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","ያቆብስ አዋለሼረ ሶዱ ዻቤ፤ ሶዱን ሱንስ ሀመ ሀርኣቱ አዋለ ራሄል አርግሲሰ። ");
INSERT INTO gaze_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","እስራኤል አመስ አቺ ከኤ ምግዳል ኤዴሪን ገመት ዱንካነሳ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","ኡቱ እስራኤል ብየ ሰነ ጅራቱ ሩቤን ኦል ሴኔ ሳጀቶ አባሳ ብልሃ ወጅን ጪሴ፤ እስራኤልስ ዋን ከነ ዸገኤ። ");
INSERT INTO gaze_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","እልማን ልያ፦ ሩቤን ጄቹንስ እልመ ያቆብ እሰ ሀንገፈ፣ ስምኦን፣ ሌዊ፣ ይሁዳ፣ ይሳኮሪፊ ዜቡሎን። ");
INSERT INTO gaze_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","እልማን ራሄል፦ ዮሴፊፊ ቤንያም። ");
INSERT INTO gaze_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","እልማን ብልሃ ጄቹንስ ጦምቦሬ ራሄል፦ ዳኒፊ ንፍታሌም። ");
INSERT INTO gaze_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","እልማን ዝልፋ ጄቹንስ ጦምቦሬ ልያ፦ ጋዲፊ ኣሼር። ");
INSERT INTO gaze_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","ያቆብስ ገረ አባሳ፣ ገረ ይስሃቅ፣ ገረ መጋላ መምሬ እሼ ክርያት አርባቅ ከን ኬብሮን ጄዸምቱ፣ እዶ አብረሃሚፊ ይስሃቅ አለጎተ ተአኒ ጅራቻ ቱረን ሰና ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","ይስሃቅ ወጋ ዽበ ቶኮፊ ሰዴተመ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","እንስ ኡሙሪ ቁፌ፣ ዱሎሜ ሀፉረሳ ከን ዹማ ባፈቴ ዱኤ፤ ገረ ሰበ እሳትስ ደበለሜ። እልማንሳ ኤሳዉፊ ያቆብስ እሰ አዋለን። ");
INSERT INTO gaze_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","ሴናን ማቲ ኤሳዉ ከን ኤዶም ጄዸሙ ሰና ከነ። ");
INSERT INTO gaze_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","ኤሳው ኒቶተሳ ዱበርቶታ ከነኣን ኬሳ ፉዼ፤ እሳንስ ኣዳ እንተለ ኤሎን ነምቸ ጎሰ ሄቲፊ ኦሆሊባማ እንተለ ኣና እልመ ዝቤኦን ነምቸ ጎሰ ሂዊ፣ ");
INSERT INTO gaze_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","አከሱመስ ባስመት እንተለ እሽማኤል ኦቦሌቲ ነባዮት። ");
INSERT INTO gaze_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","ኣዳን ኤሊፋዝን ኤሳዉፍ ዴሴ፤ ባስመትሞ ሬኡኤልን ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","ኦሆሊባማንስ ዬኡሽ፣ የእላሚፊ ቆራህ ዴሴ። እሳን ኩኔን እልማን ኤሳዉ ከኔን ከነኣንት እሳፍ ዸለተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","ኤሳዉ ኒቶተሳ፣ እልማንሳ፣ እንተለንሳቲፊ ወረ መነሳ ጅራተን ሁንደ፣ አከሱመስ ከረ ሎንሳ፣ ሆሪሳ ካን ሁንዳፊ ቀቤኘ ብየ ከነኣንት ሆረቴ ሁንደ ፉዸቴ ኦቦሌሰሳ ያቆብ ብራ ከኤ ብየ ብራ ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","ዋን ቀቤኝሳኒ አከ መሌ ባይአቴፍ እሳን ወሊ ወጅን ጅራቹ ደዸበን፤ ለፍት እሳን ጅራቻ ቱረንስ ሰበቢ ባይእነ ሆሪሳኒቲፍ እሳን ገኡ ህንደንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","ኤሳዉ ብየ ጋረ ሴኢር ኬሰ ጅራቴ፤ ኤሳዉ ጄቹን ኤዶሚዸ። ");
INSERT INTO gaze_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","ሴናን ማቲ ኤሳዉ አባ ኤዶሞታ ከን ወረ ብየ ጋረ ሴኢር ኬሰ ጅራተኒ ከነ። ");
INSERT INTO gaze_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","መቃን እልማን ኤሳዉ፦ ኤሊፋዝ፣ እልመ ኣዳ ኒቲ ኤሳዉቲፊ ሬኡኤል እልመ ባስመት ኒቲ ኤሳዉት። ");
INSERT INTO gaze_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","እልማን ኤሊፋዝ፦ ቴማን፣ ኦማር፣ ዜፎ፣ ጋታሚፊ ቄነዝ። ");
INSERT INTO gaze_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","ኤሊፋዝ እልም ኤሳዉስ ሳጀቶ ቲምና ጄዸምቱ ቀበ ቱሬ፤ እሼንስ አማሌቅን ኤሊፋዚፍ ዴሴ። እሳን ኩኔን እልማን እልማን ኣዳ ኒቲ ኤሳዉ። ");
INSERT INTO gaze_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","እልማን ሬኡኤል፦ ነሃት፣ ዜራ፣ ሸማፊ ሚዛህ። እሳን ኩኔን እልማን እልማን ባስመት ኒቲ ኤሳዉ። ");
INSERT INTO gaze_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","ኦሆሊባማን ኒቲን ኤሳዉ እንተል ኣና እልመ ዝቤኦን ኤሳዉፍ፦ ዬኡሽ፣ የእላሚፊ ቆራህ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","እሳን ኩኔን ሰኚወን ኤሳዉ ኬሳ ሀንገፎተ ቱረን፦ እልማን ኤሊፋዝ እልመ ኤሳዉ እሰ ሀንገፋ፦ ቴማን ሀንገፍትቸ፣ ኦማር ሀንገፍትቸ፣ ዜፎ ሀንገፍትቸ፣ ቄነዝ ሀንገፍትቸ፣ ");
INSERT INTO gaze_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","ቆራህ ሀንገፍትቸ፣ ጋታም ሀንገፍትቻፊ አማሌቅ ሀንገፍትቸ። እሳን ኩኔን ሀንገፎተ ብየ ኤዶም ኬሰት ኤሊፋዝራ ዸለተኒዸ፤ እሳንስ እልማን ኣዳት። ");
INSERT INTO gaze_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","እልማን ሬኡኤል እልመ ኤሳዉ፦ ነሃት ሀንገፍትቸ፣ ዜራ ሀንገፍትቸ፣ ሸማ ሀንገፍትቻፊ ሚዛህ ሀንገፍትቸ። እሳን ኩኔን ሀንገፎተ ብየ ኤዶምት ራቁኤልራ ዸለተኒዸ፤ እሳንስ እልማን ባስመት ኒቲ ኤሳዉ። ");
INSERT INTO gaze_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","እልማን ኦሆሊባማ ኒቲ ኤሳዉ፦ ዬኡሽ ሀንገፍትቸ፣ የእላማ ሀንገፍትቻፊ ቆራህ ሀንገፍትቸ። እሳን ኩኔን ሀንገፎተ አህሊባማ ኒቲ ኤሳዉ እንተለ ኣናራ ዸለተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","እሳን ኩኔን እልማን ኤሳዉ ኤዶም ጄዸሙ ሰና ቱረን፤ እሳን ኩኔንስ ሀንገፎተሳኒ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","እሳን ኩኔን እልማን ሴኢር ነምቸ ጎሰ ሆሪ ከኔን ብየ ሰነ ኬሰ ጅራቻ ቱረኒዸ፤ እሳንስ፦ ሎጣን፣ ሶባል፣ ዝቤኦን፣ ኣና፣ ");
INSERT INTO gaze_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","ዲሾን፣ ኤዜሪፊ ዲሻን። እልማን ሴኢር ከኔን ብየ ኤዶም ኬሳ ኩኔን ሀንገፎተ ሆሮታ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","እልማን ሎጣን፦ ሆሪፊ ሆማም። ቲምና ኦቦሌቲ ሎጣን። ");
INSERT INTO gaze_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","እልማን ሶባል፦ አልዋን፣ ማነሃት፣ ኤባል፣ ሼፎፊ ኦናም። ");
INSERT INTO gaze_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","እልማን ዝቤኦን፦ አያፊ ኣና። ኣናን ኩንስ ነምቸ ኡቱ ሀሮተ አባሳ ዝቤኦን ትክሱ ገሞጂ ኬሰት ቡርቃ ብሻን ደንፋ አርገቴዸ። ");
INSERT INTO gaze_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","እጆሌ ኣና፦ ዲሾኒፊ ኦሆሊባማ እንተለ ኣና። ");
INSERT INTO gaze_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","እልማን ዲሾን፦ ሄምዳን፣ ኤሽባን፣ ይትራኒፊ ኬራን። ");
INSERT INTO gaze_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","እልማን ኤዜር፦ ብልሃን፣ ዛዋኒፊ አቃን። ");
INSERT INTO gaze_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","እልማን ዲሻን፦ ኡዚፊ አራን። ");
INSERT INTO gaze_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","እሳን ኩኔን ሀንገፎተ ሆሮታት፦ ሎጣን፣ ሶባል፣ ዝቤኦን፣ ኣና፣ ");
INSERT INTO gaze_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","ዲሾን፣ ኤዜሪፊ ዲሻን። ");
INSERT INTO gaze_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","ሞቶትን ኡቱ ሞቲን እስራኤል ቶኮዩ ህንሞእን ዱረ ኤዶም ኬሰት ሞአን ከኔን ቱረን፦ ");
INSERT INTO gaze_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","ቤላ እልም ቤኦር ሞቲ ኤዶም ተኤ። መጋላንሳ ዲንሃባ ጄዸሜ ሞጋፈሜ። ");
INSERT INTO gaze_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","ቤላ ዱናን ዮባብ እልም ዜራ ነምች ቦዝራ እዶሳ ቡኤ ሞቲ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","ዮባብ ዱናን ሁሻም ነምች ብየ ቴማን እዶሳ ቡኤ ሞቲ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","ሁሻም ዱናን ሀዳድ እልም ቤደድ እን ብየ ሞኣብት ምድያንን ሞአቴ ሱን እዶሳ ቡኤ ሞቲ ተኤ። መቃን መጋላሳ ኣዊት ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","ሀዳድ ዱናን ሰምላን ነምች መስሬቃ እዶሳ ቡኤ ሞቲ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","ሰምላን ዱናን ሻዉል ነምች ብየ ሬሆቦት እሼ ለገ ብረ ጅርቱ ሰና እዶሳ ቡኤ ሞቲ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","ሻዉል ዱናን በኣል-ሃናን እልም አክቦር እዶሳ ቡኤ ሞቲ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","በኣል-ሃናን እልም አክቦር ዱናንሞ ሀዳድ እዶሳ ቡኤ ሞቲ ተኤ። መጋላንሳስ ፋኡ ጄዸሜ። መቃን ኒቲሳሞ መሄጠብኤል ጄዸመ ቱሬ። እሼንስ እንተለ መጥሬድ እንተለ ሜ-ዛሃብ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","ሀንገፎትን ኤሳዉራ ዸለተን አኩመ ጎሰ ጎሰሳኒቲፊ አኩመ ናኖ ጅሬኘሳኒት መቃ መቃን ከኔኒዸ፦ ቲምና፣ ኣልዋ፣ ዬቴት፣ ");
INSERT INTO gaze_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","ኦሆሊባማ፣ ኤላ፣ ጲኖን፣ ");
INSERT INTO gaze_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","ቄነዝ፣ ቴማን፣ ምብዛር፣ ");
INSERT INTO gaze_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","መግዲኤሊፊ ኢራም። ");
INSERT INTO gaze_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","ያቆብ ብየ አባንሳ ቱሬ፣ ከነኣን ኬሰ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","ሴናን ማቲ ያቆብ ከነ። ዮሴፍ ዬሮ ደርገጌሰ ወጋ ኩዸ ቶርበ ቱሬት ኦቦሎተሳ፣ እልማን ኒቶተ አባሳ ጄቹንስ እልማን ብልሃቲፊ ዝልፋ ወጅን ቡሻዬ ትክሰ ቱሬ፤ እንስ ዋኤ ኦቦሎተሳ ኦዱ ሀማ አባሳቲፍ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","እስራኤል ዋን በረ ዱሉማ ኬሰ እሰ ዸልቼፍ እልማንሳ ሁንደ ጫላ ዮሴፍን ጃለተ ቱሬ፤ እንስ ቆሎ ፋዬፈሜ ሆጄቴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","ኦቦሎትንሳስ ዮሙ አከ አባንሳኒ እሳን ሁንደ ጫላ እሰ ጃለቴ ሁበተንት ዮሴፍን ጅበን፤ አፋን ነጋስ እት ዱበቹ ህንደንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","ዮሴፍ አብጁ አብጆቴ ኦቦሎተሳት ህሜ፤ እሳንስ እቱመ ጫልችሰኒ እሰ ጅበን። ");
INSERT INTO gaze_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","እንስ አከነ እሳኒን ጄዼ፤ “ሜ አብጁ አን አርጌ ከነ ዸገኣ፦ ");
INSERT INTO gaze_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","ኑ ለፈ ቆቲሳ ኬሰት ብሲ ምዻኒ ህዻ ቱሬ፤ ኩኖ፣ ብሲንኮ ኦል ጄዼ ዻበቴ፤ ብሲወንኬሰንሞ ብሲኮት ናነአኒ ገድ ጄዸኒ ሰገደኒፍ።” ");
INSERT INTO gaze_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","ኦቦሎትንሳስ፣ “አት ኑረት ሞቲ ተኡ በርባዳ? ዹጉማን ስቱ ኑ ቡልቻ?” ጄዸኒን። እሳንስ ሰበቢ አብጁሳቲፊ ሰበቢ ዋን እን ዱበቴቲፍ እቱመ ጫልችሰኒ እሰ ጅበን። ");
INSERT INTO gaze_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","ኤርገሲስ አብጁ ብራ አብጆቴ ኦቦሎተሳት ህሜ። አከነስ ጄዼን፤ “ኩኖ፣ አን አብጁ ብራ አብጆዼረ፤ አዱፊ ጅእ፣ ኡርጂወን ኩዸ ቶኮስ ገድ ጄዸኒ ና ሰገዱ።” ");
INSERT INTO gaze_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","ዮሙ እን ዋን ከነ አባሳቲፊ ኦቦሎተሳት ህሜት አባንሳ፣ “አብጁን አት አብጆቴ ኩን ማል? አን፣ ሃትኬቲፊ ኦቦሎትንኬ ዹጉማን ዹፍኔ ፉለኬ ዱረት ገድ ጄኔ ሲፍ ሰገድና?” ጄዼ እሰት ዼከሜ። ");
INSERT INTO gaze_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","ኦቦሎትንሳ እሰት ህናፈን፤ አባንሳ ገሩ ዋን ከነ ገራት ቀበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","ጋፍ ቶኮ ኦቦሎትንሳ ቡሻዬ አባሳኒ ሼኬም ብረ ዼችሱ ዸቀን፤ ");
INSERT INTO gaze_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","እስራኤልስ ዮሴፊን፣ “አኩመ አት ቤክቱ ኦቦሎትንኬ ሼኬም ብረ ቡሻዬ ዼችሳ ጅሩ። ሜ ኮቱ አን ገረሳኒት ስን ኤርጋ” ጄዼ። ዮሴፍስ፣ “ኩኖ አሰን ጅረ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","እስራኤልሞ፣ “ሜ ዸቂቲ አከ ኦቦሎትንኬ፣ ቡሻዬንስ ነጋ ተአኒፊ አከ ህንተእን እላሊቲ ዴብኢ ነት ህም” ጄዼን። እንስ አከሲን ሱሉለ ኬብሮኒቲ ሼኬምት እሰ ኤርጌ። ዮሴፍስ ሼኬም ገኤ፤ ");
INSERT INTO gaze_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","ነምች ቶኮ እሰ አርጌ፤ ኩኖ እን ድሬረ ጆራ ቱሬ፤ ነምች ሱንስ፣ “አት ማል በርባደ?” ጄዼ እሰ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","ዮሴፍስ ዴብሴ፣ “አን ኦቦሎተኮን በርባደ። አት እዶ እሳን ቡሻዬሳኒ ዼችሰን ሜ ነት ህም” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","ነምችስ ዴብሴ፣ “እሳን አሲ ዴመኒሩ፤ አን ‘ገረ ዶታን ሃዸቅኑ’ ጄቹሳኒ ዸገኤረ” ጄዼ። ዮሴፍስ ኦቦሎተሳ ዱካ ቡኤ ዶታይን ብረት እሳን አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","እሳን ገሩ ፈጎት እሰ አርገኒ እሰ አጄሱፍ ኡቱ እን እሳን ብረ ህንገእን መርአተን። ");
INSERT INTO gaze_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","እሳንስ አከነ ወሊን ጄዸን፤ “ኩኖ አባን አብጁ ሱን ዹፋ ጅረ! ");
INSERT INTO gaze_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","ኮታ አጄፍኔ ቦለወን አስ ጅረን ኬሳ ቶኮት እሰ ገትኔ ብኔንሰ ሀማቱ እሰ ኛቴ ጄነ። ኤርገሲሞ አብጁንሳ ማል አከ ተኡ እላለ።” ");
INSERT INTO gaze_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","ሩቤን ዋን ከነ ዸጌኛን እሳን ሀርካ እሰ ባሴ። እንስ አከነ ጄዼ፤ “ለኪ እሰ ህንአጄፍኑ፤ ");
INSERT INTO gaze_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","ዺገ ህንዸንገላስና። ገሞጂ ኬሰት ቦለ ከነ ኬሰ እሰ ቡሳ መሌ ሀርከኬሰኒን እሰ ህንቱቅና።” ሩቤን እሳን ሀርካ እሰ ባሴ ገረ አባሳት እሰ ዴብሱፍ አከነ ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","ዬሮ ዮሴፍ ኦቦሎተሳ ብረ ገኤት እሳን ቆሎ እን ኡፈቴ፣ ቆሎ ሚዸጋ ሰነ እሰራ ባሰኒ፣ ");
INSERT INTO gaze_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","እሰ ፉዸኒ ቦለት ገድ ደርበተን። ቦል ሱንስ ዱዋ ቱሬ፤ ብሻንስ ህንቀቡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","ኦቦሎትንሳ ቡዴነ ኛቹፍ ተታአን፤ ኦል ጄዸኒስ ኩኖ፣ ደልደልቶተ ወረ እሽማኤል ከኔን ግልኣዲ ዹፋ ጅረን አርገን። እሳንስ ኡርጎፍቱ፣ ሀጴ ድበታቲፊ ቁምቢ ጋለወንሳኒት ፌአተኒ ግብጥት ጌሳ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","ይሁዳንስ ኦቦሎተሳቲን አከነ ጄዼ፤ “ኦቦሌሰኬኘ አጄፍኔ ዺገሳ ዾክሱን ቡኣ ማሊ ኑ ቀበ? ");
INSERT INTO gaze_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","ኮታ እሽማኤሎተት እሰ ጉርጉረ መሌ ሀርከኬኛን እሰ ህንቱቅኑ፤ እን ኦቦሌሰኬኛፊ ፎንኬኘ።” ኦቦሎትንሳስ ያደ ከነ ፉዸተን። ");
INSERT INTO gaze_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","ዮሙ ደልደልቶትን ምድያን አቺን ደርቡፍ ዹፈንትስ ኦቦሎትን ዮሴፍ ቦለ ኬሳ ሀርክሰኒ ኦል እሰ ባሰኒ ሜቲ ሰቅሊ ድግደማት እሽማኤሎተት እሰ ጉርጉረተን፤ ጀርስ ግብጥት እሰ ጌሰን። ");
INSERT INTO gaze_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","ሩቤን ገረ ቦለ ሰናት ዴብኤ፤ ዮሴፍ ቦለ ሰነ ኬሰ ህንቱሬ፤ እንስ ኡፈተ ኦፊሳ ተርሳሴ። ");
INSERT INTO gaze_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","እንስ ገረ ኦቦሎተሳ ዸቄ፣ “ጉርብች አች ህንጅሩ! ኤጋ አን ኤሰን ዸቀ?” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","እሳንስ ቆሎ ዮሴፍ ፉዸኒ ሬኤ ቶኮ ቀለኒ ቆሎ ሰነ ዺገ ኬሰ ጩጰን። ");
INSERT INTO gaze_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","ቆሎ ሚዸጋ ሰነስ አባሳኒት ጌሰኒ፣ “ኑ ቆሎ ከነ አርገኔረ፤ ሜ ቆሎ እልመኬቲ ተኡፊ ተኡ ባቹሳ እላል” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","እንስ ቆሎ ሰነ ቤኬ፣ “ኩን ቆሎ እልመኮቲት! ብኔንሰ ሀማቱ እሰ ኛቴ። ዹጉማን ዮሴፍ ጭጭረሜረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","ከነረት ያቆብ ኡፈተ ኦፊሳ ተርሳሴ፤ ወያ ገዳ ሙዺት ህዸቴ ጉያ ባይኤ እልመሳቲፍ ገዴ። ");
INSERT INTO gaze_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","እልማንሳቲፊ እንተለንሳ ሁንድኑ እሰ ጀጀቤሱፍ ከአን፤ እን ገሩ ጀጀባቹ ድዴ፣ “ለኪ አን ገዳ ገረ እልመኮ ሲኦልት ገድ ቡአ” ጄዼ። አከሲን አባንሳ ንቦኤፍ። ");
INSERT INTO gaze_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","ግዱ ሰነ ወር ምድያን ሱን ግብጥ ኬሰት ጶጢፋራ ነምቸ ቆንዳልቶተ ፈረኦን ኬሳ ቶኮ ቱሬ ከን አጀጃ ዋርድያ ተኤ ቶኮት ዮሴፍን ጉርጉረተን። ");
INSERT INTO gaze_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","ዬሮ ከነት ይሁዳን ኦቦሎተሳ ብራ ዴሜ ነምቸ አዱላም ከን ሂራም ጄዸሙ ቶኮ ብረ ጅራቹፍ ገድ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","አችትስ ይሁዳን እንተለ ነምቸ ከነኣን ከን ሹዋን ጄዸሙ ቶኮ አርጌ፤ እንስሼ ፉዼ እሼ ብረ ገኤ፤ ");
INSERT INTO gaze_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","እሼንስ ኡልፎፍቴ እልመ ዴሴ፤ መቃንሳስ ኤር ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","አመስ ኡልፎፍቴ እልመ ዴሴ፤ መቃሳስ ኦናን ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","አመስ እቱመ ደበልቴ ኡልፎፍቴ እልመ ብራ ዴሴ መቃሳ ሼላ ጄቴ ሞጋፍቴ። እሼንስ ክዚብት እሰ ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","ይሁዳንስ ኤር እልመሳ ሀንገፍትቸ ኒቲ ፉስሴ፤ መቃንሼ ታማር ጄዸመ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","ገሩ ኤር እልም ይሁዳ ሀንገፍትች ሱን ፉለ ዋቀዮ ዱረት ሀማ ቱሬ፤ ከናፉ ዋቀዮ እሰ አጄሴ። ");
INSERT INTO gaze_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","ይሁዳንስ ኦናኒን፣ “ኦቦሌሰኬቲፍ ሰኚ ዻቡፍ ጄዺቲ ኒቲ ኦቦሌሰኬቲ ብረ ገኢቲ ድርቀመ ዋርሱማኬቲ እሼፍ ጉት” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","ኦናን ገሩ አከ እጆሌን ዸለቱ ሱን ከንሳ ህንታኔ ቤኬ፤ ከናፉ አከ ኦቦሌሰሳቲፍ ሰኚ ህንዻብኔፍ ጄዼ ዬሮ ኒቲ ኦቦሌሰሳ ብረ ገኡ ሁንደ አፌታ ለፈት ዸንገላሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","ወን እን ሆጄቴ ሱን ፉለ ዋቀዮ ዱረት ሀማ ቱሬ፤ ከናፉ ዋቀዮ እሰስ ንአጄሴ። ");
INSERT INTO gaze_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","ኤርገሲ ይሁዳን ኒቲ እልመሳ ታማሪን፣ “ሀመ እልምኮ ሼላ ጉደቱት ሃዸ ህዬሳ ተኢቲ መነ አባኬቲ ጅራዹ” ጄዼ። እን፣ “ሙጫን ኩንስ አኩመ ኦቦሎተሳ ዱኣ ላተ” ጄዼ ያዴ ቱሬቲ። ከናፉ ታማር መነ አባሼ ጅራቹ ዸቅጤ። ");
INSERT INTO gaze_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","በረ ዼራ ቦዴስ እንተል ሹዋ ኒቲን ይሁዳ ዱቴ። ይሁዳንስ ገደሳራ በየነናን ገረ ቲምናህት ለፈ ወረ ሆሎተሳራ ርፌንሰ ሙርሙረኒት ኦል በኤ፤ ምቹንሳ ሂራም ነምች አዱላም እሰ ወጅን ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","ታማርስ፣ “ኩኖ አባን ዽርሰኬቲ ሆሎተሳራ ርፌንሰ ሙርሙሩፍ ጄዼ ቲምናህት ኦል በኣ ጅረ” ጄዸኒ ዬሮ እት ህመንት፣ ");
INSERT INTO gaze_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","ወያ ሃዸ ህዬሳ ኦፍራ ባፍቴ ኦፍ ዾክሱፍ ሀጉጊ ሀጉገቴ፤ ኤርገሲስ በልበለ ኤናይምት ኦል ገልቹ ከን ዳንዲ ቲምናህት ጌሱረ ጅሩ ዱረ ቴሴ። ሼላ ጉደቱዩ እሼን አከ ኒቱማዻን እሳፍ ህንኬነምን ቤክቴ ቱርቴቲ። ");
INSERT INTO gaze_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","ይሁዳን ዮሙ እሼ አርጌት ሰበቢ እሼን ፉለሼ ሀጉገቴ ቱርቴፍ ሰጋገልቱሼ ሴኤ። ");
INSERT INTO gaze_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","እንስ ኡቱ አከ እሼን ኒቲ እልመሳ ታቴ ህንቤክን ከራ ጭነ እዶ እሼን ጅርቱ እሼ ብረ ዸቄ፣ “ሜ ኮቱ ስ ወጅን ነንጪሳ” ጄዼን። እሼንስ፣ “አት ነ ወጅን ጪሱፍ ማል ና ኬንተ?” ጄቴ እሰ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","እንሞ፣ “አን ቡሻዬኮ ኬሳ እልሞ ሬኤ ቶኮ ሲፍን ኤርገ” ጄዼን። እሼንስ፣ “ሀመ እልሞ ሰነ ና ኤርግቱት ዋን ብራ ቀብሲሰ ና ኬንታ?” ጄቴን። ");
INSERT INTO gaze_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","እንስ፣ “አን ቀብሲሰ ማልን ሲፍ ኬነ?” ጄዼን። እሼንስ ዴብፍቴ፣ “ቻፓኬ ህዻሳ ወጅን፣ ኡሌ ቀበቴ ዴምቱስ ና ኬን” ጄቴን። እንስ ወንቶተ ከኔን ኬኔፊ እሼ ወጅን ጪሴ፤ እሼንስ ንኡልፎፍቴ። ");
INSERT INTO gaze_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","ኤርገ አቺ ዴምቴ ቦዴ ሀጉጊሼ ኦፍራ ባፍቴ ወያ ዽርስሼራ ዱናን ኡፈቴ ቱርቴ ሰነ ዴብፍቴ ኡፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","ይሁዳን ዋን ቀብሲሰ ኬኔ ዱበርቲ ሰነራ ዴብፈቹፍ ጄዼ ከራ ምቹሳ ነምቸ አዱላም ሰናቲን እልሞ ሬኤ ኤርጌፍ፤ ነምች ገሩ እሼ ህንአርግኔ። ");
INSERT INTO gaze_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","ነምችስ፣ “ሰጋገልቱን ኤናይም ብረ፣ ዳንዲረ ታኣ ቱርቴ ሱን ኤሰ ጅርት?” ጄዼ ወረ አች ጅራተን ጋፈቴ። ጀርሞ ዴብሰኒ፣ “ሰጋገልቱን ቶኮዩ አስ ህንቱሬ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","እንስ ገረ ይሁዳት ዴብኤ፣ “አን ዱበርትቲ አርጉ ህንደንዴኜ። አከሱመስ ወር እዶ ሰነ ጅራተን፣ ‘ሰጋገልቱን ቶኮዩ አስ ህንቱሬ’ ጄዸን” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","ይሁዳንስ፣ “እሼን ዋን ቀበቴ ሰነ ሃሀምብፈቱ፤ ዮ ከና አቺ ኑ ዋን ኮልፋ ታና። ኩኖ አን እልሞ ሬኤ ከነ እሼፍ ኤርጌረ፤ አት ገሩ እሼ ዸብዴ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","ገረ ጅአ ሰዲ ቦዴ፣ “ታማር ኒቲን እልመኬቲ ሰጋገልቱ ታቴርት፤ ከናንስ እሼን አመ ኡልፎፍቴርት” ጄዸኒ ይሁዳት ህመን። ይሁዳንሞ፣ “ገድ ባሳቲ እብዳን ጉባ እሼ አጄሳ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","እሼንስ ኡቱመ ገድ ባፈማ ጅርቱ፣ “አን አባ ምአ ከናራ ኡልፋኤረ” ጄቴ አባ ዽርሰሼት ኤርጋ ኤርግቴ። አከሱመስ፣ “ቻፓፊ ክሪንሳ፣ ኡሌን ኩንስ ከን ኤኙ አከ ተኤ ሜ እላሊ አዳን ባፈዹ” ጄቴን። ");
INSERT INTO gaze_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","ይሁዳንስ ምአ ከነ ቤኬ፣ “ሰበቢ አን እልመኮ ሼላት እሼ ህንሄሩምሲስኒፍ፣ እሼን ነ ጫላ ቀጄልቱዸ” ጄዼ። እንስ ዴብኤ እሼ ብረ ህንጌኜ። ");
INSERT INTO gaze_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","ዮሙ ዬሮን ደኡምሰሼ ገኤት፣ ኩኖ፣ እልማን ለኩቱ ገደሜሰሼ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","ኡቱ እሼን ደኡምሰረ ጅርቱ እን ቶኮ ሀርከሳ ገድ ባፈቴ፤ ዴስፍቱንስ ቀብዴ፣ “እሳ ከነቱ ዱረ ለፈ ገኤ” ጄቴ ክሪ ዲማ ሀርከሳት ሂቴ። ");
INSERT INTO gaze_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","አኩመ እን ሀርከሳ ኦል ዴብፈቴን ኩኖ ኦቦሌስሳ ዸለቴ፤ ዴስፍቱንስ፣ “አት አከሚን ኦፉመኬቲን ጨብስቴ ባቴ?” ጄቴ። መቃንሳስ ፋሬስ ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","ኦቦሌስሳ ከን ክሪ ዲማ ሀርከራ ቀቡ ሱንስ ንዸለቴ፤ እንስ ዛራ ጄዸሜ ሞጋፈሜ። ");
INSERT INTO gaze_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","ዬሮ ከነት ዮሴፍ ግብጥት ጌፈሜ ቱሬ። ጶጢፋራን ነምች ግብጥ ቆንዳል ፈረኦን ከን አጀጃ ዋርድያ ቱሬ ሱን እሽማኤሎተ አች እሰ ጌሰንራ እሰ ብተቴ። ");
INSERT INTO gaze_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","ዮሴፍስ ዋን ዋቀዮ እሰ ወጅን ቱሬፍ ነመ ምልካኣ ተኤ፤ እንስ መነ ጎፍታሳ ነምቸ ብየ ግብጥ ሰና ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","ጎፍታንሳስ አከ ዋቀዮ እሰ ወጅን ጅሩፊ አከ ዋቀዮ ዋን እን ሆጄቱ ሁንደ ኬሰት እሰ ምልኮምሴ አርጌ፤ ");
INSERT INTO gaze_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","ዮሴፍስ ፉለ ጎፍታሳ ዱረት ፉዸተመ አርገቴ ሆጄታሳ አመነማ ተኤ። ጶጢፋራንስ መነሳረት እሰ ሙዴ፤ ዋን ቀቡ ሁንዱመስ አከ እን ኤጉፍ እማና እት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","ጋፈ እን መነሳቲፊ ዋን እን ቀቡ ሁንደረት እሰ ሙዴ ጀልቀቤ ዋቀዮ ሰበቢ ዮሴፊፍ ጄዼ መነ ነምቸ ግብጥ ሰና ኤብሴ። ኤብ ዋቀዮስ ዋን ጶጢፋራን መናፊ አላ ቀቡ ሁንደረ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","ከናፉ ጶጢፋራን ዋን ቀቡ ሁንደ ሀርከ ዮሴፍ ጀለ ገልቼ፤ እንስ ዋን ኛቱ ቆፈ መሌ ቀቤኘሳ ቶኮሌ ህንቤኩ ቱሬ። ዮሴፍ ዻበ ቶሌሳፊ ሚዸጋ ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","ኒቲን ጎፍታሳስ ዋን ከነ ቦዴ እጀሼ ዮሴፍራ ቡፈቴ፣ “ኮቱ ነ ብረ ገእ!” ጄቴን። ");
INSERT INTO gaze_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","እን ገሩ ድዴ አከነ እሼን ጄዼ፤ “ኩኖ፣ ጎፍታንኮ ዋን መነ ኬሰ ጅሩ ቶኮሌ ህንቤኩ፤ እን ዋን ቀቡ ሁንደ ነት ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","መነ ከነ ኬሰት ነምን ነ ጫሉ ቶኮዩ ህንጅሩ። ሰበቢ አት ኒቲሳ ታቴፍ ስእ መሌ ወን ጎፍታንኮ ነት ህንኬንን ቶኮዩ ህንጅሩ። ዮስ አን አከምተን ዋን ሀማ አከሲ ራወቹዻን ዋቀት ጩቡ ሆጄዸሬ?” ");
INSERT INTO gaze_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","እሼን ጉዩመ ጉያን ዮሴፍት ዱበቱዩ፣ እን እሼ ብረ ገኡ ዮካን እሼ ብረት አርገሙሌ ንድዴ። ");
INSERT INTO gaze_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","ጋፍ ቶኮ ዮሴፍ ሆጂሳ ሆጄቹፍ መነ ሴኔ፤ ተጃጅልቶተ ወረ መነ ሰና ኬሳስ ነምን ቶኮዩ አች ህንቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","እሼንስ ወያሳ ቀበቴ፣ “ኮቱቲ ነ ብረ ገእ!” ጄቴን። እን ገሩ ወያሳ እሼት ገድ ለክሴ ፊጌ መና በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","እሼንስ ዮሙ አከ እን ወያሳ እሼት ገድ ለክሴ ፊጌ መና በኤ አርግቴት፣ ");
INSERT INTO gaze_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","ሆጄቶተ መነሼ ዋምቴ አከነ ጄቴን፤ “ኩኖ፣ እን እብርቸ ከነ አከ ኑት ተጰቱፍ ፍዴ! እን ነ ብረ ገኡፍ ነት ኦል ሴናን አን ሰገሌ ጉዳን እዬ። ");
INSERT INTO gaze_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","እንስ ገርጋርሰ በርባቻፍዩኮ ዸጌኛን ወያሳ ነ ብረት ዺሴ ፊጌ መና በኤ።” ");
INSERT INTO gaze_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","እሼን ሀመ ጎፍታንሳ ገሉት ወያሳ ኦፍ ብረ ኬሴ። ");
INSERT INTO gaze_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","አከነ ጄቴስ ኦዱ ከነ እሰት ህምቴ፦ “ገርብች እብርች አት ኑ ፍዴ ሱን ነት ተጰቹፍ ነት ኦል ሴኔ። ");
INSERT INTO gaze_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","ገሩ አኩመ አን ገርጋርሰ በርባቻፍ እዬን እን ወያሳ ነ ብረት ዺሴ ፊጌ መና በኤ።” ");
INSERT INTO gaze_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","ጎፍታንሳ ዮሙ ኦዱ ኒቲንሳ፣ “ወን ገርብችኬ ነ ጎዼ ከነ” ጄቴ እት ህምቴ ሰነ ዸገኤት ኣሬ ጉበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","ጎፍታንሳስ ዮሴፍን ፉዼ መነ ህዻ እዶ ህዸምቶትን ሞትቻ እት ኤገመን ኬሰ ቡሴ። ተኡስ ዬሮ ዮሴፍ መነ ህዻ ኬሰ ቱሬት፣ ");
INSERT INTO gaze_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","ዋቀዮ እሰ ወጅን ቱሬ፤ ፉለ አጀጃ መነ ህዻ ሰና ዱረትስ ጋሩማሳ እት አርግሲሴ፤ አከ ፉዸተመስ አርገቱ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","አጀጃን መነ ህዻ ሱንስ ነሞተ መነ ህዻ ጅረን ሁንደረት ዮሴፍን ሙዴ፤ ዋን አችት ሆጄተሙ ሁንደረትስ እት ጋፈተማ እሰ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","ሰበቢ ዋቀዮ እሰ ወጅን ቱሬፊ ዋን እን ሆጄቱ ከምዩ እሳ ምልኬሴፍ አጀጃን መነ ህዻ ሱን ዋን እት ጋፈተመ ዮሴፍ ጀለ ጅሩ ሁንዳፍ ያዶ ቶኮሌ ህንቀቡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","ከነ ቦዴ ነምች ሞቲ ግብጢቲፍ ዹጋቲ ዽኤሱፊ ነምች ቡዴነ ቶልቹ ጎፍታሳኒ ሞቲ ግብጥ ሰነ ገድሲሰን። ");
INSERT INTO gaze_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","ፈረኦንስ ቆንዳልቶተሳ ለማንት ጄቹንስ እት ጋፈተማ ዹጋቲቲፊ እት ጋፈተማ ቶልቻ ቡዴናት ኣሬ፤ ");
INSERT INTO gaze_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","እንስ መነ አጀጃ ዋርድያ ኬሰ መነ ህዻ እዶ ዮሴፍ እት ህዸሜ ቱሬ ኬሰ እሳን ቡሴ። ");
INSERT INTO gaze_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","አጀጃን ዋርድያ ዮሴፍት እሳን ኬኔ፤ ዮሴፍስ እሳን ተጃጅላ ቱሬ። ጀርስ ጉያ ባይኤ መነ ህዻ ቱረን፤ ");
INSERT INTO gaze_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","እሳን ለቸኑ ጄቹንስ ነምች ሞቲ ግብጢቲፍ ዹጋቲ ዽኤሱፊ ነምች ቡዴነ ቶልቹ ቶኮን ቶኮንሳኒ ሀልከኑመ ቶኮ ኬሰት አብጁ አብጆተን፤ ቶኮን ቶኮን አብጁ ሰናስ ሂካ መታሳ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","ዮሴፍ ጉያ እት ኣኑ ገነመ እሳን ብረ ዸቄ፤ ኩኖ ኡቱ ገደኒ ጅረኑስ እሳን አርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","እንስ፣ “ፉልኬሰን ሀርአ ማሊፍ አከነ ዱከናአ?” ጄዼ ቆንዳልቶተ ፈረኦን ወረ እሰ ወጅን መነ ጎፍታሳ ኬሰ መነ ህዻ ቱረን ሰነ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","እሳንስ፣ “ኑ ለቹ አብጁ አብጆትኔ ነመ ኑ ሂኩ ዸብኔ” ጄዸኒን። ከነረት ዮሴፍ፣ “ሂካን ከን ዋቃት ምቲ? ሜ አብጁኬሰን ነት ህማ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","እት ጋፈተማን ዹጋቲ ሱን አከነ ጄዼ አብጁሳ ዮሴፍት ህመቴ፤ “አብጁኮ ኬሰት ኩኖ ሙከ ወይኒ ቶኮቱ ፉለኮ ዱረ ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","ሙክት ወይኒ ሱንስ ደሜ ሰዲ ቀበ ቱሬ። እንስ አኩመ ለቴን ደራሬ፤ ሁርቡን እጀሳስ ንብልቻቴ። ");
INSERT INTO gaze_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","ጦፎን ፈረኦን ነ ሀርከ ቱሬ፤ አንስ እጀ ወይኒ ፉዼ ጦፎ ፈረኦንት ጩንፌ ጦፎ ሰነ ሀርከ ፈረኦንት ኬኔ።” ");
INSERT INTO gaze_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","ዮሴፍስ አከነ ጄዼን፤ “ሂካንሳ ከነ፤ ደሜወን ሰደን ሱን ጉያ ሰዲ። ");
INSERT INTO gaze_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","ጉያ ሰዲ ኬሰት ፈረኦን መታኬ ኦል ቀበ፤ ታይታ ኬትስ ስ ዴብሰ፤ አኩመ ዬሮ ዹጋቲ ዽኤሳፊ ቱርቴ ሰነ አትስ ጦፎ ፈረኦን ሀርከሳት ንኬንተ። ");
INSERT INTO gaze_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","ገሩ ዬሮ ስት ቶሉት ነ ያደዹ፤ ዋን ጋሪስ ና ጎዽ። ዋኤኮ ፈረኦንት ህሚቲ መነ ህዻ ከና ነ ባስ። ");
INSERT INTO gaze_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","አነ ብየ እብሮታቲ ሀተኒ ነ ፍደኒቲ፤ ብየ ከነ ኬሰትስ አን ዋን ቦለ ከነ ኬሰ ነ ቡስሱ ቶኮሌ ህንሆጄትኔ።” ");
INSERT INTO gaze_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","እት ጋፈተማን ቡዴና ሱንስ ዮሙ አከ ዮሴፍ አብጁ ሰናፍ ሂካ ጋሪ ኬኔ አርጌት ዮሴፊን አከነ ጄዼ፤ “አንስ አብጁ ቶኮን አብጆዼ፤ ኩኖ ጉንዶወን ቡዴና ሰዲ መታኮረ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","ጉንዶ ኦል ኣኑረ ቡዴነ ጎሰ ገራ ገራ ከን ፈረኦኒፍ ቆጴፈሜቱ ቱሬ፤ ገሩ ስምብሮትን መቱመኮረት ጉንዶ ሰነ ኬሳ ኛቻ ቱረን።” ");
INSERT INTO gaze_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","ዮሴፍሞ አከነ ጄዼ፤ “ሂካንሳ ከነ፤ ጉንዶወን ሰደን ሱን ጉያ ሰዲ። ");
INSERT INTO gaze_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","ጉያ ሰዲ ኬሰት ፈረኦን መታኬ ኦል ቀበ፤ ሙከት ስ ረራሰ። ስምብሮትንስ ፎንኬ ንኛቱ።” ");
INSERT INTO gaze_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","ጉያን ሰደፋን ጉያ እት ፈረኦን ዸለቴ ቱሬ፤ ፈረኦንስ ቆንዳልቶተሳቲፍ ጭዸ ቆጴሴ። እንስ እት ጋፈተማ ዹጋቲቲፊ እት ጋፈተማ ቡዴና ሰነ ፉለ ቆንዳልቶተሳ ዱረት ዽኤሴ፦ ");
INSERT INTO gaze_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","እት ጋፈተማ ዹጋቲ ሰነ ሆጂሳት ዴብሴ፤ ነምች ጦፎ ሰነ አመስ ሀርከ ፈረኦንት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","እት ጋፈተማ ቡዴና ሰነ ገሩ አኩመ ዮሴፍ አብጁሳኒ ሂኬፍት ረራሴ። ");
INSERT INTO gaze_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","ተኡስ እት ጋፈተማን ዹጋቲ ሱን ዮሴፍን ንእራንፈቴ መሌ እሰ ህንያደትኔ። ");
INSERT INTO gaze_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","ኤርገ ወጋን ለመ ጉቱን ደርቤ ቦዴ ፈረኦን አብጁ ቶኮ አብጆቴ። ኩኖ እን ቀርቀረ ለገ አበያ ዻበቻ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","ኩኖ፣ ሳወን በበሬዶፊ ገገበቶትን ቶርበ ለገ አበያ ኬሳ ኦል በአን፤ እሳንስ ሸምበቆ ኬሰ ዼዳ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","አመስ ኩኖ፣ ሳወን ፎፎክሶፊ ሁሁቀቶትን ከኔን ብራ ቶርበ ለገ አበያ ኬሳ ኦል በአኒ ሳወን ኤዴደ ለጋ ቱረን ሰነ ብረ ዸዻበተን። ");
INSERT INTO gaze_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","ሳወን ፎፎክሶፊ ሁሁቀቶትን ሱንስ ሳወን በበሬዶፊ ገገበቶ ቶርበን ሰነ ኛተን። ፈረኦንስ ህርባ ደመቄ። ");
INSERT INTO gaze_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","አመስ ዴብኤ ረፌ አብጁ ለመፋ አብጆቴ፤ ኩኖ መታን ምዻኒ ቶርበ ምሴ ቶሌ ሶማ ቶኮረት ጉደቻ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","ኤርገሲሞ ኩኖ መታን ምዻን ቀቀንጨሮ ሆቦምቦሌቲ በኣ ቢፍቱቲን ጉበተኒ ቶርበ ብራ ብብቅለን። ");
INSERT INTO gaze_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","መታን ምዻን ቀቀንጨሮ ሰናስ መታ ምሴ ቶሌ ቶርበን ሰነ ልልቅምሴ፤ ፈረኦንስ ህርባ ደመቄ፤ ኩኖ ወን ሱንስ አብጁ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","ገነመ ሰነ ያድንሳ ንጄቀሜ፤ እን ነመ ኤርጌ ቶልፈቶታፊ ቤክቶተ ግብጥ ሁንደ ዋምስፈቴ። ፈረኦንስ አብጁሳ እሳንት ህሜ፤ ገሩ ነምን አብጁ ሰነ እሳፍ ሂኩ ደንደኡ ቶኮሌ ህንአርገምኔ። ");
INSERT INTO gaze_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","ኤርገሲ እት ጋፈተማን ዹጋቲ ሱን ፈረኦኒን አከነ ጄዼ፤ “አን ሀርአ በሌሳኮ ያደዼረ። ");
INSERT INTO gaze_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","ዬሮ ቶኮ ፈረኦን ተጃጅልቶተሳት ኣሬ አናፊ እት ጋፈተማ ቡዴና ሰነ መነ አጀጃ ዋርድያ ኬሰት ህዼ። ");
INSERT INTO gaze_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","ቶኮን ቶኮንኬኘ ሀልከኑመ ቶኮን አብጁ አብጆትኔ፤ ቶኮን ቶኮን አብጁ ሰናስ ሂካ መታሳ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","እብርች ደርገጌስ ቶኮ ኑ ወጅን አች ቱሬ፤ እንስ ተጃጅላ አጀጃ ኤጉምሳ ቱሬ። ኑ አብጁኬኘ እት ህመናን እን ቶኮ ቶኮኬኛፍ አኩመ አብጁኬኛት ሂካሳ ኑት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","አኩመ እን ኑ ሂኬ ሰነ ተኤ፤ አን እዶኮት ነንዴብኤ፤ ነምች ካንስ ንፈንፈሜ።” ");
INSERT INTO gaze_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","ፈረኦንስ ነመ ኤርጌ ዮሴፍን ዋምስሴ፤ ቦለ ህዻ ኬሳ ባሰኒስ ደፈኒ እሰ ፍደን። እንስ ሃደቴ ኡፈተሳስ ጌደረቴ ፉለ ፈረኦን ዱረት ዽኣቴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","ፈረኦንስ ዮሴፊን፣ “አን አብጁ አብጆዼን ቱሬ፤ ገሩ ነምን ቶኮዩ ና ሂኩ ህንደንዴኜ። አን አከ አት ዬሮ አብጁ ዸጌሱ ሂኩ ደንዴሱ ዸገኤረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","ዮሴፍሞ፣ “አን ሂኩ ህንደንደኡ፤ ዋቅን ገሩ ፈረኦኒፍ ዴቢ ነጋ ንኬነ” ጄዼ ፈረኦኒፍ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","ፈረኦንስ ዮሴፊን አከነ ጄዼ፤ “አን አብጁኮቲን ቀርቀረ ለገ አበያረ ዻበቻን ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","ኩኖ ሳወን ገገበቶፊ በበሬዶን ቶርበ ለግቸ ኬሳ ኦል በአኒ ሸምበቆ ኬሰ ዼዳ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","እሳን ዱባንሞ ሳወን ሁሁቀቶ፣ ባይኤ ፎፎክሶፊ ቀቀሎን ብራ ቶርበ ኦል በአን፤ አን ተኩማ ሳወን ፎፎክሶ አከና ጉቱማ ብየ ግብጥ ኬሰት ህንአርግኔ። ");
INSERT INTO gaze_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","ሳወን ሁሁቀቶፊ ፎፎክሶን ሱን ሳወን ገገበቶ ዱራን ኦል በአን ቶርበን ሰነ ኛተን። ");
INSERT INTO gaze_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","ገሩ ኤርገ እሳን ኛተኒ ቦዴ ነምን ቶኮሌ አከ እሳን ሳወን ሰነ ኛተን ቤኩ ህንደንዴኜ፤ እሳን አኩመ ኡቱ ህንኛትኒን ዱረ ቱረን ሰነ ፎፎክሶ ቱረኒቲ። አንስ ህርባ ነንደመቄ። ");
INSERT INTO gaze_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“አከሱመስ አን አብጁኮቲን መታ ምዻኒ ቶርበ ከን ምሴፊ ገጋሪ ሶማ ቶኮረት ጉደቻ ጅሩ ነንአርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","እሳን ዱባንስ ኩኖ መታን ምዻኒ ጮጮለጋን፣ ቀቀላን ከን ሆቦምቦሌቲ በአ ቢፍቱቲን ጉበቴ ቶርበ ኦል በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","መታወን ምዻኒ ቀቀልኣን ሱን መታ ምዻኒ ገጋሪ ቶርበን ሰነ ልቅምሰን፤ አንስ ዋን ከነ ቶልችቶተት ነንህሜ፤ ገሩ ነምን ቶኮዩ ና እብሱ ህንደንዴኜ።” ");
INSERT INTO gaze_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","ዮሴፍሞ ፈረኦኒን አከነ ጄዼ፤ “አብጁን ፈረኦን ለማኑ ቶኩመ። ዋቅን ዋን ሆጄቹፍ ጅሩ ፈረኦንት ሙልእሴረ። ");
INSERT INTO gaze_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","ሳወን በበሬዶን ቶርበ ወጋ ቶርበ፤ መታወን ምዻኒ ገጋሪ ቶርበስ ወጋ ቶርበ፤ አብጁን ሱን ቶኩመ። ");
INSERT INTO gaze_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","ሳወን ቀቀሎፊ ፎፎክሶን ቶርበን ዱባን ኦል በአንስ ወጋ ቶርበ፤ መታወን ምዻኒ ቀቀንጨሮን ሆቦምቦሌቲ በአ ቢፍቱቲን ጉበተን ቶርበንሞ ወጎተ ቤላ ቶርበ። ");
INSERT INTO gaze_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“ወን ኩን አኩመ አን ፈረኦንት ህሜዸ። ዋቅን ዋን ሆጄቹፍ ጅሩ ፈረኦንት አርግሲሴረ። ");
INSERT INTO gaze_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","በር ቁፋ ጉዳንሳ ቶርበ ብየ ግብጥ ጉቱት ንዹፈ፤ ");
INSERT INTO gaze_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","እሳን ቦዴዻን ገሩ ወጎትን ቤላ ቶርበ ንዹፉ። ቁፍን ብየ ግብጥ ሁንድ ንእራንፈተመ፤ ቤል ሱንስ ብየ በሌሰ። ");
INSERT INTO gaze_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","ዋን ቤል ዱባን ዹፉ ሱን ባይኤ ሀማ ተኡፍ ቁፍን ብየቲ ህንያደተሙ። ");
INSERT INTO gaze_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","አብጁን ኩን ብፈ ለማን ፈረኦንት ኬነሙንሳ ዋን ዱብች ዋቃን ሙርቴፈሜፍዸ፤ ዋቅንስ ዋን ከነ ደፌ ንራወተ። ");
INSERT INTO gaze_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“ከናፉ ፈረኦን ነመ ሁበታፊ ቤካ ቶኮ ፍለቴ ብየ ግብጥረት ሃሙዱ። ");
INSERT INTO gaze_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","ፈረኦን አከ እሳን ወጎተ ቁፋ ቶርበን ኬሰ ምዻን ብየ ግብጢቲ ገልፈሙ ሀርከ ሸን ኬሳ ሀርከ ቶኮ ወልት ቀበኒፍ ቆንዳልቶተ ብየረት ሃሙዱ። ");
INSERT INTO gaze_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","እሳንስ ወጎተ ጋሪ ዹፉፍ ጅረን ከነ ኬሰ ምዻን ሁንደ ወልት ሃቀበን፤ አከ ኛታፍ ተኡፍስ ምዻን ከነ ታይታ ፈረኦን ጀለት መጋላወን ኬሰት ሃኩሰን፤ ሃኤገንስ። ");
INSERT INTO gaze_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","ምዻን ኩንስ አከ ብየቲን ቤላን ህንበድኔፍ ወጎተ ቤላ ቶርበን ግብጥት ዹፉፍ ጅሩ ኬሰ አከ ፈየዱፍ ብየቲዻፍ ኦል ሃካአሙ።” ");
INSERT INTO gaze_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","ዱብችስ ፈረኦኒፊ ቆንዳልቶተሳ ሁንደ ብረት ጋሪ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","ፈረኦንስ፣ “ነመ አከ ነምቸ ከና ከን ሀፉር ዋቃ ኬሰ ጅሩ አርገቹ ደንዴኛሬ?” ጄዼ እሳን ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","ፈረኦንስ ዮሴፊን አከነ ጄዼ፤ “ኤርገ ዋቅን ዋን ከነ ሁንደ ስት ሙልእሴ፣ ነምን አከኬ ሁበታፊ ቤካ ተኤ ቶኮዩ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","አት መሰራኮረት እት ጋፈተማ ታተ፤ ሰብንኮ ሁንድኑስ አጀጀኬ ጀለት ቡለ። አን ኡልፍነ ቴሶ ቆፋን ስ ጫለ።” ");
INSERT INTO gaze_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","ፈረኦንስ ዮሴፊን፣ “እላ፣ አን ብየ ግብጥ ሁንደረት ስ ሙዴረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","ኤርገሲ ፈረኦን ቁቤላ ቻፓሳ ቁበሳራ ባሴ ቁበ ዮሴፍት ካኤ። ኡፈተ ቁንጬ ተልባ ሀጲራ ሆጄተሜ እሰት ኡፍሴ፤ አመርቲ ወርቄ ሞርመሳት ካኤ። ");
INSERT INTO gaze_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","እንስ ጋሪሳ እሰ ለመፋረ እሰ ቴስሴ፤ ነሞትንስ፣ “ሰገዳ!” ጄቻ ፉለሳ ዱረ ዴመኒ እያ ቱረን፤ አከናን ፈረኦን ብየ ግብጥ ሁንደረት እሰ ሙዴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","ኤርገሲስ ፈረኦን ዮሴፊን፣ “አን ፈረኦኒዸ፤ ገሩ አጀጀኬ መሌ ነምን ጉቱማ ግብጥ ሀርከሳ ዮካን ሚለሳ ሶቾሱ ቶኮዩ ህንጅሩ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","ፈረኦንስ ዮሴፊፍ መቃ ዛፌናት-ጰኔኣ ጄዸሙ ባሴ፤ እንተለ ጶጢፌራ ሉብቸ መጋላ ኦን ከን ኣሴነት ጄዸምቱሌ እት ሄሩምሲሴ። ዮሴፍስ ብየ ግብጥ ሁንደ ኬሰ ናነኤ። ");
INSERT INTO gaze_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","ዮሴፍ ዬሮ ተጃጅለ ፈረኦን ሞትቸ ግብጥ ጀልቀቤት ነመ ወጋ ሶዶማ ቱሬ፤ እንስ ፉለ ፈረኦን ዱራ በኤ ዴሜ ብየ ግብጥ ሁንደ ኬሰ ነናነኤ። ");
INSERT INTO gaze_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","ወጎተ ቁፋ ቶርበን ሰነ ኬሰ ለፍት ምዻን አከ መሌ ባይአቱ ኬንቴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","ዮሴፍስ ምዻን ወጎተ ቶርበን ሰነ ኬሰ ግብጢ ገልፈሜ ሁንደ ወልት ቀቤ መጋላወን ኬሰት ኩሴ። ምዻን ለፈ ቆቲሳ ናኖ መጋላስ ቶኮ ቶኮ መጋላ ሰና ኬሰት ኩሴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","ዮሴፍስ ምዻን ባይእንሳ ጉዳ አከ ጭረቸ ገላና ተኤ ኩሴ። ዋን ምዻን ሱን ሰፈረሙ ህንደንደአምኒፍ እን ሰፈሩ ዺሴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","ዮሴፍ ኡቱ ወጎትን ቤላ ሱን ህንዹፍን ዱረ ኣሴነት እንተለ ጶጢፌራ ሉብቸ መጋላ ኦንራ እልማን ለመ ዸልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","ዮሴፍስ፣ “ዋቅን ረክነኮ ሁንዳፊ መነ አባኮ ሁንደ ነ እራንፈቺሴረ” ጄዼ መቃ እልመሳ ሀንገፍትቻ ምናሴ ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","“ዋቅን ብየ አን እት ረከዼ ኬሰት ነ ባይእሴረ” ጄዼ እልመሳ እሰ ለመፋሞ ኤፍሬም ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","ግብጥ ኬሰት ወጎትን ቁፋ ቶርበን ሱን ደርቤ፣ ");
INSERT INTO gaze_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","አኩመ ዮሴፍ ዱበቴ ሰነ ወጎትን ቤላ ቶርበ ጀልቀቤ። ብዮተ ብራ ሁንደ ኬሰ ቤለቱ ቱሬ፤ ብየ ግብጥ ጉቱ ኬሰ ገሩ ምዻንቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","ዬሮ ግብጥ ጉቱን ቤለኡ ጀልቀቤት ነሞትን ምዻን በርባደኒ ፈረኦንት እየተን፤ ፈረኦንሞ ወረ ግብጥ ሁንዱማን፣ “ዮሴፍ ብረ ዸቃቲ ዋን እን እስንት ህሙ ጎዻ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","ቤል ጉቱማ ብየቲ ኬሰ በበልአትናን ዮሴፍ መንኩሳሌ ሁንዱማ በኔ ነሞተ ግብጥት ምዻን ጉርጉሬ፤ ቤል ግብጥ ሁንደ ኬሰት ሀማቴ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","ዋን ጉቱ አዱኛረት ቤል ሀማቴፍ ብዮትን ሁንድኑ ዮሴፍራ ምዻን ብተቹፍ ገረ ግብጥ ዹፋ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","ያቆብ ዮሙ አከ ግብጥ ኬሰ ምዻን ጅሩ ዸገኤት፣ እልማንሳቲን፣ “እስን ማሊፍ ወል እላልቱ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","እት ፉፌስ፣ “ኩኖ አን አከ ግብጥ ኬሰ ምዻን ጅሩ ዸገኤረ። አከ ኑ ዱአ ጀላ ባኔ ጅራኑፍ ገድ ቡኣቲ አቺ ምዻን ኑ ብታ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","ኦቦሎተ ዮሴፍ ኬሳ ኩዸን ግብጥ ኬሳ ምዻን ብቱፍ ገድ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","ያቆብ ገሩ በላቱ እሰረ ገአ ጄዼ ዋን ሶዳቴፍ ኦቦሌሰ ዮሴፍ ቤንያምን እሳን ወጅን ህንኤርግኔ። ");
INSERT INTO gaze_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","ቤል ብየ ከነኣን ኬሰ ዋን ቱሬፍ እልማን እስራኤልስ ወረ ምዻን ብተቹ ዸቀን ወጅን ዴመን። ");
INSERT INTO gaze_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","ዮሴፍስ ቡልቻ ብየቲ ከን ኡመተ ብየቲ ሁንደት ምዻን ጉርጉሩ ቱሬ። ኦቦሎትን ዮሴፍስ ዮሙ አች ገአንት ፉለሳኒቲን ለፈት ጎምብፈመኒ ሰገደኒፍ። ");
INSERT INTO gaze_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","ዮሴፍ አኩመ ኦቦሎተሳ አርጌን እሳን ቤኬ፤ ገሩ አኩመ ነመ እሳን ህንቤክኔት አፋን ሀማ እሳንት ዱበቴ፣ “እስን ኤሳ ዹፍተን?” ጄዼ እሳን ጋፈቴ። ጀርስ፣ “ምዻን ብተቹፍ ጄኔ ከነኣኒ ዹፍኔ” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","ዮ ዮሴፍ ኦቦሎተሳ ቤኬዩ ጀር እሰ ህንቤክኔ። ");
INSERT INTO gaze_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","እንስ አብጁ ዋኤሳኒ አብጆቴ ሰነ ያደቴ፣ “እስን በሳስቶተ ደዸቢ ብየቲ በሳሱፍ ዹፍተኒዸ!” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","እሳንሞ አከነ ጄዸኒ ዴብሰን፤ “ያ ጎፍታ አከስ ምት፤ ኑ ገርቦንኬ ምዻን ብተቹ ዹፍኔ። ");
INSERT INTO gaze_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","ኑ ሁንድ እልማን አባ ቶኮት፤ ኑ ገርቦንኬ ነሞተ አመነሞዸ መሌ በሳስቶተ ምት።” ");
INSERT INTO gaze_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","እንስ፣ “አከስ ምት፤ እስን ደዸቢ ብየቲ በሳሱ ዹፍተን” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","እሳን ገሩ አከነ ጄዸኒ ዴብሰን፤ “ኑ ገርቦንኬ ኦቦሎተ ኩዸ ለመ፣ እልማኑመ አባ ቶኮ ከን ብየ ከነኣን ጅራቱት። ኩኖ ቁጥሱን ሁንደኬኛ አመ አባኬኘ ብረ ጅረ፤ እን ቶኮ ገሩ ህንጅሩ።” ");
INSERT INTO gaze_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","ዮሴፍ ገሩ አከነ ጄዼን፤ “አኩመ አን እስኒን ጄዼ ሰነ እስን በሳስቶተ! ");
INSERT INTO gaze_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","አክ እስን እቲን ቆረምተን ከነ፤ አን መቃ ፈረኦኒን ነንከከዸ፤ ዮ ኦቦሌስኬሰን ቁጥሱን ሱን አስ ዹፌ መሌ እስን አሲ ህንሶቾተን። ");
INSERT INTO gaze_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","አከ እን ዸቄ ኦቦሌሰኬሰን ፍዱፍ ኦፍ ኬሳ ነመ ቶኮ ኤርጋ፤ እስን ወር ሀፍተንሞ መነ ህዻት ገልፈምቱ፤ አከሲንስ ዱቢንኬሰን ቆረተሜ አከ ዹጋ ተኤፊ አከ ዹጋ ህንተእን ንእላለመ፤ ዮ ከና አቺ፣ አን መቃ ፈረኦኒን ነንከከዸ፤ እስን ዹጉማን በሳስቶተ!” ");
INSERT INTO gaze_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","እንስ ሁንደሳኒ ጉያ ሰዲ መነ ህዻ ኬሰ ቱርሴ። ");
INSERT INTO gaze_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","ጉያ ሰደፋት ዮሴፍ አከነ እሳኒን ጄዼ፤ “እስን ዋን ከነ ጎዻ፤ ንጅራቱ፤ አን ዋቀ ነንሶዳዻቲ። ");
INSERT INTO gaze_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","እስን ዮ ነሞተ አመነሞ ታተን ኦቦሎተኬሰን ኬሳ ቶኮ አስ መነ ህዻ ሃቱሩ፤ ወር ካን ገሩ ዴማ፤ ማቲኬሰን ከኔን ቤለአኒፍ ምዻን ጌሳ። ");
INSERT INTO gaze_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","ገሩ ኦቦሌሰኬሰን ቁጥሱ ና ፍዳ፤ አከሲን ዱቢንኬሰን ንምርከኔፈመ፤ እስንስ ህንዱተን።” እሳንስ አከሱመ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","እሳንስ አከነ ወሊን ጄዸን፤ “ኑ ዹጉማን ሰበቢ ኦቦሌሰኬኛቲፍ አደበማ ጅረ። ዬሮ እን ኑ ከዸቴት ሉቡንሳ ሀመም አከ ዽጰቻ ቱርቴ አርግኔረ፤ ኑ ገሩ እሰ ዸገኡ ድድኔ፤ ዽጵን ኩን ከናፍ ኑት ዹፌ።” ");
INSERT INTO gaze_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","ሩቤንሞ፣ “አን፣ ‘ጉርባ ከነ ህንሚዽና’ ጄዼ እስንት ህንህምኔ? እስን ገሩ ነ ዸገኡ ድደን! ኩኖ ኑ ዺገሳት ንጋፈተምነ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","ሰበቢ ዮሴፍ ከራ ነመ አፋን ሂኩቲን እሳንት ዱበቻ ቱሬፍ እሳን አከ እን ዋን እሳን ዱበተን ሁበቱ ህንቤክኔ። ");
INSERT INTO gaze_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","ዮሴፍ አች እሳንራ ገረገሌ ቦኡ ጀልቀቤ፤ ኤርገሲሞ እሳንት ገረገሌ እሳንት ዱበቴ። ስምኦንንስ እሳን ኬሳ ባስሴ ፉሉመሳኒ ዱረት ሂስሴ። ");
INSERT INTO gaze_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","ዮሴፍ አከ ቀልቀሎሳኒት ምዻን ጉተኒፍ፣ አከ ሜቲ ቶኮ ቶኮሳኒ ዴብሰኒ ቀልቀሎሳኒ ኬሰ እሳኒፍ ካአኒፊ አከ ከራሳኒቲፍ ገላ እሳኒፍ ኬነን አጀጄ። ኤርገ ወን ኩን እሳኒፍ ጎዸሜ ቦዴ ");
INSERT INTO gaze_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","ጀር ምዻንሳኒ ሀሮተሳኒት ፌአተኒ ቀጄለን። ");
INSERT INTO gaze_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","እሳን ኬሳ እን ቶኮ እዶ ቡለንት ሀሬሳቲፍ ኛተ ኬኑፍ ጄዼ ቀልቀሎሳ በኔ፤ ኩኖ አፋን ቀልቀሎ ኬሰትስ ሜቲሳ አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","እንስ ኦቦሎተሳቲን፣ “ሜቲንኮ ና ዴብኤረ፤ ኩኖ ቀልቀሎኮ ኬሰ ጅረ” ጄዼ። ከነረት እሳን ነአኒ ወልት ገረ ገለኒ ሆለቻ፣ “ወን ዋቅን ኑት ሆጄቴ ኩን ማል?” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","እሳንስ ገረ ብየ ከነኣን አባሳኒ ያቆብ ብረ ዹፈኒ ዋን እሳንረ ገኤ ሁንደ እሰት ህመን፤ አከነስ ጄዸን፤ ");
INSERT INTO gaze_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“ነምች ጎፍታ ብየ ሰና ተኤ አፋን ሀማ ኑት ዱበቴ አከ ዋን ኑ ብየቲ በሳሱ ዸቅኔት ኑ ለካኤ። ");
INSERT INTO gaze_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","ኑ ገሩ አከነ ጄኔን፤ ‘ኑ ነሞተ አመነሞዸ መሌ በሳስቶተ ምት። ");
INSERT INTO gaze_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","ኑ ኦቦሎተ ኩዸ ለመ እልማኑመ አባ ቶኮት፤ እን ቶኮ ህንጅሩ፤ ቁጥሱን ሁንደኬኛሞ አባኬኘ ብረ ብየ ከነኣን ጅረ።’ ");
INSERT INTO gaze_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“ነምች ጎፍታ ብየ ሰና ተኤሞ አከነ ኑን ጄዼ፤ ‘አክ አን አከ እስን ነሞተ አመነሞ ታተኒፊ ህንተእን እቲን ቤኩ ከነ፤ ኦቦሎተኬሰን ኬሳ እሰ ቶኮ አስ ነ ብረት ዺሳቲ ማቲኬሰን ከን ቤለአኒፍ ምዻን ጌሳ። ");
INSERT INTO gaze_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","ገሩ አከ አን አከ እስን ነሞተ አመነሞ መሌ በሳስቶተ ህንተእን ቤኩፍ ኦቦሌሰኬሰን እሰ ቁጥሱ ሰነ ና ፍዳ። ኤርገሲ አን ኦቦሌሰኬሰን ዴብሴ እስኒ ኬነ፤ እስንስ ብየ ከነ ኬሰት ደልደለቹ ንደንዴሱ።’ ” ");
INSERT INTO gaze_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","ዮሙ እሳን ቀልቀሎሳኒ ኬሳ ምዻን ገረገልቸንት፣ ኩኖ ሜቲን ቶኮ ቶኮሳኒ ህዻ ህዻን ቀልቀሎሳኒ ኬሰ ቱሬ። እሳኒፊ አባንሳኒ ዬሮ ሜቲ ህዸሜ ሰነ አርገንት ንርፈተን። ");
INSERT INTO gaze_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","አባንሳኒ ያቆብስ፣ “እስን እጆሌኮ ነ ዸብሲፍተን። ዮሴፍ ህንጅሩ፤ ስምኦንስ ህንጅሩ። አመሞ ቤንያምን ፉዸቹ በርባዱ። ወን ሁንድ ነት ሀማቴረ!” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","ሩቤንሞ አባሳቲን፣ “ዮ አን ዴብሴ እሰ ሲፍ ፍዱ ባዼ እልማንኮ ለማን አጄሱ ንደንዴሰ፤ እሰ እማና ነት ኬን፤ አን ዴብሴ እሰ ነንፍደ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","ያቆብ ገሩ አከነ ጄዼ፤ “እልምኮ እስን ወጅን አች ገድ ህንቡኡ፤ ኦቦሌስሳ ዱኤረ፤ እሰ ቆፈቱ ሀፌ። ዮ ከራኬሰንረት በላን እሰረ ገኤ፣ እስን አከ አሪንኮ ገዳን አዋለ ሴኑ ጎቱ።” ");
INSERT INTO gaze_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","አመሌ ቤል ብየቲት ባይኤ ሀማቴ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","ኤርገ እሳን ምዻን ብየ ግብጢቲ ፍደን ሰነ ኛተኒ ፍጠኒ ቦዴ አባንሳኒ፣ “አመስ ዸቃቲ ምዻን ጥኖ ደበላ ኑ ብታ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","ይሁዳንሞ አከነ እሳን ጄዼ፤ “ነምች ሱን፣ ‘ዮ ኦቦሌስኬሰን እስን ወጅን ዹፌ መሌ እስን ለመተ እጀኮ ህንአርግተን’ ጄዼ ኦፍ ኤገኖ ጭማ ኑ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","ዮ አት ኦቦሌሰኬኘ ኑ ወጅን ኤርግቴ ኑ ዸቅኔ ምዻን ሲፍ ብትነ። ");
INSERT INTO gaze_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","ሰበቢ ነምች ሱን፣ ‘ዮ ኦቦሌስኬሰን እስን ወጅን ዹፌ መሌ እስን ለመተ እጀኮ ህንአርግተን’ ኑን ጄዼፍ፣ ዮ አት እሰ ኤርግቴ መሌ ኑ ገድ ህንቡኑ።” ");
INSERT INTO gaze_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","እስራኤልሞ፣ “እስን ማሊፍ አከ ኦቦሌሰ ብራ ቀብደን ነምቸት ህሙዻን ረክነ ነት ፍደን?” ጄዼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","እሳንስ አከነ ጄዸኒ ዴብሰን፤ “ነምች ዋኤ መታኬኛቲፊ ዋኤ ማቲኬኛ ጀቤሴ ኑ ጋፈቴ። እንስ፣ ‘አባንኬሰን አመዩ ጅራ? ኦቦሌሰ ብራ ቀብዱ?’ ጄዼ ኑ ጋፈቴ፤ ኑ ጋፊዹመሳ ዴብፍኔፍ። ዮስ አከ እን፣ ‘ኦቦሌሰኬሰን አስ ፍዳ’ ኑን ጄዹ አከሚን ቤኩ ደንዴኘሬ?” ");
INSERT INTO gaze_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","ይሁዳንስ አባሳ እስራኤሊን አከነ ጄዼ፤ “አከ ኑ፣ አቲፊ እጆሌንኬኘ ዱአ ጀላ ባኔ ጅራኑፍ ጉርብቸ ነ ወጅን ኤርግ፤ ኑ ካኔ ዴምናቲ። ");
INSERT INTO gaze_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","አን ወቢ እሳፍን ተአ፤ ዋኤሳስ አኑመ መታኮ ጋፈቹ ንደንዴሰ። ዮ አን ዴብሴ እሰ ሲፍ ፍዴ ፉለኬ ዱረ ዻቡ ባዼ፣ አን በረ ጅሬኘኮ ጉቱ ፉለኬ ዱረት በሌሳ ከነት ነንጋፈተመ። ");
INSERT INTO gaze_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","ኡቱ ቱሩ ባትኔ ስላ ዮነ ዬሮ ለመ ዸቅኔ ዴብኔረ ቱሬ።” ");
INSERT INTO gaze_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","ከነረት አባንሳኒ እስራኤል አከነ እሳኒን ጄዼ፤ “ኤርገ አከስ ተኤ ዋን ከነ ጎዻ፤ ኦምሸ ብየ ከና ፍለተማ ኬሳ ኬና ቶኮ ቶኮ ጄቹንስ ሀጴ ድበተን ጥኖሼ፣ ደመ ጥናሳ፣ ኡርጎፍቱፊ ቁምቢ ጥኖሼ፣ ኦቾሎኒፊ ለዉዚ ጥኖሼ ጌሳቲ ነምቻፍ ኬና። ");
INSERT INTO gaze_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","እስን ዋን ሜቲ አፋን ቀልቀሎኬሰኒ ኬሰ ካአሜ እስኒ ዴብኤ ሰነ ዴብሱ ቀብደኒፍ ሜቲ ሰነ ሀርከ ለመ ፉዸዻቲ ዴማ፤ ሜቲን ሱን ዶጎጎራን ዹፌ ተኣቲ። ");
INSERT INTO gaze_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","ኦቦሌሰኬሰንስ ፉዸዻቲ ደፋ ገረ ነምቻት ዴብኣ። ");
INSERT INTO gaze_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","አከ እን ኦቦሌሰኬሰን ካኒፊ ቤንያምሌ እስን ወጅን ዴብሴ ኤርጉፍ ዋቅን ዋን ሁንደ ደንደኡ አከ ነምች ገራ እስኒ ላፉ ሃጎዹ። አን ዮ እጆሌ ዸቤሌ እጆሌ ነንዸበ።” ");
INSERT INTO gaze_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","ነሞትን ሱንስ ኬናወን ሰነ፣ ሜቲ ሰነ ሀርከ ለማፊ ቤንያምንስ ፉዸተኒ አሪቲዻን ግብጥት ገድ ቡአኒ ፉለ ዮሴፍ ዱረ ዸዻበተን። ");
INSERT INTO gaze_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","ዮሴፍስ ዮሙ ቤንያምን እሳን ብረት አርጌት ሀንገፈ ሆጄቶተ መነሳቲን፣ “ነሞተ ከነ መነኮት ጌስ፤ ሆሪ ቶኮ ቀሊ ኛተ ቆጴስ፤ እሳን ሰኣቲ ጀአት ነ ወጅን ኛቱቲ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","ነምች ሱንስ አኩመ ዮሴፍ እሰ አጀጄ ጎዼ፤ ጀረ ሰነስ መነ ዮሴፍት ጌሴ። ");
INSERT INTO gaze_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","ነሞትን ሱን ዬሮ መነ ዮሴፍት ጌፈመንት ሶዳተኒ አከነ ጄዸን፤ “ኑ ሰበቢ ሜቲ ዬሮ ጀልቀባ ዴብኤ አፋን ቀልቀሎኬኛ ኬሰት አርገሜ ሰናቲፍ አስ ፍደምኔ፤ እን ኑ ሩኩቴ፣ ኑ ሞአቴ፣ አከ ገርቦታት ኑ ቀበቴ ሀሮተኬኘ ፉዸቹ በርባደ።” ");
INSERT INTO gaze_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","ከናፉ ጀር ገረ ሀንገፈ ሆጄቶተ ዮሴፍት ኦል በአኒ በልበለ መና ዱረት እት ዱበተን። ");
INSERT INTO gaze_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","አከነስ ጄዸን፤ “ያ ጎፍታ፣ ኑ ዬሮ ጀልቀባ ምዻን ብተቹፍ አስ ገድ ቡኔ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","ኑስ ዬሮ እዶ ቡሉ ጌኜ ቀልቀሎኬኘ በኔት ቶኮን ቶኮንኬኘ አፋን ቀልቀሎኬኛ ኬሰት ሜቲኬኘ አኩመ ጅሩት አርገትኔ። ከናፉ ሜቲ ሰነ ዴብፍኔ ፍድኔ ዹፍኔረ። ");
INSERT INTO gaze_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","ሜቲ ብራስ እቲን ምዻን ብተቹፍ ፍድኔ ዹፍኔረ። ኤኙ አከ ሜቲኬኘ ቀልቀሎኬኘ ኬሰ ኑ ካኤስ ህንቤክኑ።” ");
INSERT INTO gaze_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","እንስ ዴብሴ፣ “ሆማ ምት፤ ህንሶዳትና። ዋቅንኬሰን፣ ዋቅን አባኬሰኒ ቀልቀሎኬሰንት በዻዹማ እስኒ ነቄረ፤ ሜቲንኬሰን ነ ገኤ ጅረ” ጄዼን። ኤርገሲስ ስምኦንን ገረ እሳኒት ገድ ባሴ። ");
INSERT INTO gaze_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","ሀንገፍን ሆጄቶታ ሱንስ ጀረ ሰነ መነ ዮሴፍት ጌሴ አከ እሳን ሚለሳኒ ዽቀተኒፍ ብሻን ኬኔፍ፤ ሀሮተሳኒቲፍሞ ኦካ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","እሳንስ አችት አከ ኛተን ዋን ዸገአኒፍ ዹፋቲ ዮሴፍ ከን ሰኣቲ ጀኣቲፍ ኬናሳኒ ቆጴፈተን። ");
INSERT INTO gaze_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","ዬሮ ዮሴፍ መነት ገሌት እሳን ኬና መነት ኦል ገልቸኒ ቱረን ሰነ ኬነኒፍ፤ ፉለሳ ዱረትስ ለፈት ጎምብፈመኒ ሀርከ ፉዸን። ");
INSERT INTO gaze_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","እንስ ነጋ እሳን ጋፈቴ፣ “አባንኬሰን ጃርስ እስን ዋኤሳ ነት ህምተን ሱን አከም? እን አመዩ ጅራ?” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","ጀርስ፣ “ተጃጅላንኬ አባንኬኘ አመዩ ንጅረ፤ ነጉመስ” ጄዸኒ ዴብሰን። ኡልፍነ እሳፍ ኬኑፍስ ገድ ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","እንስ ኦል እላሌ ኦቦሌሰሳ፣ እልመ ሃዸሳ ቤንያምን አርጌ፣ “እን ኩን ኦቦሌሰኬሰን ቁጥሱ እስን ዋኤሳ ነት ህምተን ሰና?” ጄዼ ጋፈቴ። እት ፉፌስ፣ “እልመኮ፣ ዋቅን ስ ሃኤብሱ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","ዮሴፍ ዮሙ ኦቦሌሰሳ አርጌት ገራን ራፈሜ ደፌ ገድ በኤ፤ ቦኡ በርባዴስ ኩታ መነሳ ሴኔ አችት ቦኤ። ");
INSERT INTO gaze_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","ኤርገሲስ ፉለሳ ዽቀቴ ገድ በኤ፤ ኦፍ ጀጀቤሴስ፣ “ኛን ሃዽኣቱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","ጀርስ ሰበቢ ወር ግብጥ እብሮተ ወጅን ህንኛትኔፍ ዮሴፊፍ ኮጳት፣ ኦቦሎተሳቲፍ ኮጳት፣ ወረ ግብጥ ከኔን እሰ ወጅን ኛተኒፍስ ኮጳት ዽኤሰን፤ እብሮተ ወጅን ኛቹን ወረ ግብጥ ብረት ጅብሲሳ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","ነሞትን ሱንስ አኩመ ኡሙሪሳኒት ሀንገፋ ጀልቀበኒ ሀመ ቁጥሱት ፉለሳ ዱረ ተታአኒ ድንቅፈተኒ ወል እላለን። ");
INSERT INTO gaze_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","ማዲ ዮሴፍ እራስ ኛትን ቆደሜፍ፤ ቆድን ቤንያም ገሩ ቆደ ቶኮ ቶኮሳኒቲፍ ኬነሜ ደቻ ሸን ተአ ቱሬ። ጀርስ አከሲን ዮሴፍ ወጅን ዹገኒ እት ሆኤ። ");
INSERT INTO gaze_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","ዮሴፍስ አከነ ጄዼ ሀንገፈ ሆጄቶተ መነሳ አጀጄ፤ “ቀልቀሎ ጀረ ከና ሀመ ባቹ ደንደኡት ምዻን እት ጉት፤ ሜቲ ቶኮ ቶኮሳኒስ አፋን ቀልቀሎሳኒ ኬሰ ካእ። ");
INSERT INTO gaze_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","ጦፎኮ እሰ ሜቲራ ሆጄተሜሞ ሜቲ እን እቲን ምዻን ብተቹ ዹፌ ወጅን አፋን ቀልቀሎ እሰ ቁጥሱ ሰና ኬሰ ካእ።” ነምችስ አኩመ ዮሴፍ እሰ አጀጄ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","ነሞትን ሱን አኩመ ለፍት በሪቴን ሀሮተሳኒ ወጅን ጌጌፈመን። ");
INSERT INTO gaze_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","ኡቱመ እሳን መጋላ ሰነራ ህንፈጋትን ዮሴፍ ሀንገፈ ሆጄቶተሳቲን አከነ ጄዼ፤ “ደፊ ጀረ ከነ ዱካ ቡእ፤ ዮሙ ቀቀብዱትሞ አከነ ጄዺን፤ ‘እስን ማሊፍ ዋን ጋሪ ዋን ሀማዻን ዴብፍቱ? ");
INSERT INTO gaze_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","ጦፎን ኩን ጦፎ ጎፍታንኮ እቲን ዹጉፊ እቲን ዋ ህሙ ምቲ? እስን ዋን ከነ ጎቹዻን ዋን ሀማ ሆጄተን።’ ” ");
INSERT INTO gaze_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","እንስ ዮሙ እሳን ቀቀቤት ዋኑመ ከነ እሳንት ዱበቴ። ");
INSERT INTO gaze_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","ጀርስ አከነ እሳን ጄዸን፤ “ጎፍታንኮ ማሊፍ ዱቢ አከና ዱበተ? ዋን አከና ሆጄቹን ተጃጅልቶተኬራ ሃፈጋቱ! ");
INSERT INTO gaze_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","ኩኖ ኑ ሜቲ አፋን ቀልቀሎኬኛ ኬሰት አርገትኔዩ ብየ ከነኣኒቲ ዴብፍኔ ሲፍ ፍድኔ። ዮስ ኑ ማሊፍ መነ ጎፍታኬቲቲ ሜቲ ዮካን ወርቄ ሀትነሬ? ");
INSERT INTO gaze_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","ተጃጅልቶተኬ ኬሳ ነምን ወን ኩን ብረት አርገሜ ከምዩ ሃዱኡ፤ ኑ ወር ሀፍኔሞ ገርቦተ ጎፍታኮ ንታነ።” ");
INSERT INTO gaze_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","እንሞ ጀራን፣ “አመ አኩመ እስን ጄተን ሃተኡ፤ አባን ወንት ኩን ብረት አርገሜ ገርብቸ ናፍ ተአ፤ እስን ወር ካንሞ ገድ ዺፈምቱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","ቶኮን ቶኮንሳኒ ደፈኒ ቀልቀሎሳኒ ለፈ ኬየተኒ ሂከን። ");
INSERT INTO gaze_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","ሀንገፍን ሆጄቶታ ሱንስ ሀንገፋ ጀልቀቤ ሀመ ቁጥሱት ሰከተኤ። ጦፎን ሱንስ ቀልቀሎ ቤንያም ኬሰት አርገሜ። ");
INSERT INTO gaze_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","ከነረት እሳን ኡፈተሳኒ ተርሳሰን። ሁንድሳኒ ሀሮተሳኒ ፌአተኒ መጋለቲት ዴብአን። ");
INSERT INTO gaze_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","ዮሴፍ ዬሮ ይሁዳፊ ኦቦሎትንሳ ኦል ሴነንት አመዩ መነ ኬሰ ቱሬ፤ እሳንስ ፉለሳ ዱረት ኩኩፈን። ");
INSERT INTO gaze_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","ዮሴፍስ፣ “ወንት እስን ሆጄተን ኩን ማል? አከ ነምን አከኮቲ ሆደ ህሙዻን ዋ አርጉ ደንደኡ እስን ህንቤክተኒ?” እሳኒን ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","ይሁዳንሞ አከነ ጄዼ ዴብሴ፤ “ኑ ጎፍታኮቲን ማል ጄቹ ደንዴኘ? ኑ ማል ዱበቹ ደንዴኘ? ኑ ቁልቁሉ ተኡኬኘ አከሚን ምርከኔሱ ደንዴኘ? ዋቅን በሌሳ ገርቦተኬቲ እፈት ባሴረ። ኩኖ ኑ ገርቦተ ጎፍታኮት፤ ኑ ሁንድኬኘ፣ ነምን ጦፎን ሱን ብረት አርገሜስ ገርቦተኬት።” ");
INSERT INTO gaze_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","ዮሴፍ ገሩ፣ “ዋን አከና ሆጄቹን ነራ ሃፈጋቱ! ነመ ጦፎን ብረት አርገሜ ቆፈቱ ገርብቸኮ ተአ። ወር ሀፍተን ገሩ ነጋዻን ገረ አባኬሰኒት ዴብኣ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","ይሁዳንሞ ዮሴፍት ዽኣቴ አከነ ጄዼ፦ “ማሎ ጎፍታኮ፣ አከ ገርብችኬ ዋን ቶኮ ጎፍታኮት ዱበቱ ኤየሚፍ። አት አኩመ ፈረኦን ታቱስ ገርብቸኬት ህንኣርን። ");
INSERT INTO gaze_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","ጎፍታንኮ፣ ‘እስን አባ ዮካን ኦቦሌሰ ቀብዱ?’ ጄዼ ገርቦተሳ ጋፈቴ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","ኑስ፣ ‘አባ ዱሎማ ቶኮ ቀብነ፤ እልም ቁጥሱን በረ ዱሉመሳ ኬሰ እሳፍ ዸለቴ ቶኮስ ጅረ። ኦቦሌስሳስ ዱኤረ፤ እጆሌ ሃትሳ ዴሴ ኬሳ እሰ ቆፈቱ ሀፌ፤ አባንሳ እሰ ጃለተ’ ጄኔ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“አትስ ገርቦተኬቲን፣ ‘አከ አን እጀኮቲን እሰ አርጉፍ ና ፍዳ’ ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","ኑስ ጎፍታኮቲን፣ ‘ሙጭች አባሳ ዺሴ ዴሙ ህንደንደኡ፤ ዮ እን እሰ ዺሴ ብራ ዴሜ አባንሳ ንዱአ’ ጄኔ። ");
INSERT INTO gaze_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","አትሞ ገርቦተኬቲን፣ ‘ዮ ኦቦሌስኬሰን እን ቁጥሱን እስን ወጅን ዹፉ ባቴ፣ እስን ለመተ ፉለኮ ህንአርግተን’ ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","ኑስ ዬሮ ገረ ገርብቸኬ አባኮት ዴብኔት ዋን ጎፍታንኮ ጄዼ እሰት ህምኔ። ");
INSERT INTO gaze_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“አባንኬኘ፣ ‘አመስ ዸቃቲ ምዻን ጥኖ ደበላ ኑ ብታ’ ኑን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","ኑ ገሩ፣ ‘ኑ ዸቁ ህንደንዴኙ፤ ዮ ኦቦሌስኬኘ እን ቁጥሱን ኑ ወጅን ጅራቴ ቆፈ ዸቅነ። ዮ ኦቦሌስኬኘ እን ቁጥሱን ኑ ወጅን ዸቁ ባቴ ኑ ፉለ ነምቻ አርጉ ህንደንዴኙ’ ጄኔ። ");
INSERT INTO gaze_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“አባንኮ ገርብች ኬሞ አከነ ኑን ጄዼ፤ ‘አከ ኒቲንኮ እልማን ለመ ናዴሴ እስን ንቤክቱ። ");
INSERT INTO gaze_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","እሳን ኬሳስ እን ቶኮ ነ ብራ በኤ፤ አንስ፣ “እን ዹጉማን ጭጭረሜረ” ነንጄዼ። አን ኤርገሲ እሰ ህንአርግኔ። ");
INSERT INTO gaze_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","ዮ እስን እሰ ከነስ ነ ዱራ ፉተኒ በላን እሰረ ገኤ፣ እስን አከ አሪንኮ ገዳን አዋለ ሴኑ ጎቱ።’ ");
INSERT INTO gaze_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“ከናፉ አመ ዬሮ አን ገረ ገርብቸኬ አባኮት ዴብኡት፣ ዮ ሙጭች ኑ ወጅን ጅራቹ ባቴ አባንኮ ከን ጅሬኝሳ ጅሬኘ ሙጭቻቲን ወልት ህዸሜ ሱን፣ ");
INSERT INTO gaze_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","አከ ሙጭች ኑ ወጅን ህንጅሬ አርጌ ዱአ። ኑ ገርቦንኬስ አከ አሪን አባኬኘ ገርብቸኬቲ ገዳን አዋለ ሴኑ ጎነ። ");
INSERT INTO gaze_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","አን ገርብችኬ አከ ሙጫን ኩን ነጋዻን ዴብኡ አባኮ ዱረት ወቢ ተኤ፣ ‘ያ አባኮ፣ ዮ አን ዴብሴ እሰ ሲፍ ፍዱ ባዼ፣ አን በረ ጅሬኘኮ ጉቱ ፉለ አባኮ ዱረት በሌሳ ከነት ነንጋፈተመ!’ ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“ኤጋ አመ አን ገርብችኬ እዶ ሙጭቻ ገርብቸ ጎፍታኮ ተኤ አስት ነንሀፈ፤ ሙጭችሞ ኦቦሎተሳ ወጅን ሃዴብኡ። ");
INSERT INTO gaze_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","ዮ ሙጭች ነ ወጅን ህንጅራትን አን አከምን ገረ አባኮቲ ዴብኡ ደንደአ? ዋዉ፤ አከ አን ገደ አባኮት ዹፉ አርጉ ነ ህንጎዽን።” ");
INSERT INTO gaze_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","ከነረት ዮሴፍ ነሞተ ሁንደ ዱረት ኦፍ ቀቡ ደዸቤ፣ “ነሞተ ሁንደ ፉለኮ ዱራ ገድ ያሳ!” ጄዼ እዬ። ከናፍ ዮሙ ዮሴፍ ኦቦሎተሳት ኦፍ ቤክስሴት ነምን ቶኮዩ እሰ ብረ ህንቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","ሰበቢ እን ጉድሴ ቦኤፍ ወር ግብጥ ንዸገአን፤ ወረ መሰራ ፈረኦን ብረትስ ንዸገአሜ። ");
INSERT INTO gaze_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","ዮሴፍስ ኦቦሎተሳቲን፣ “አን ዮሴፍ፤ አባንኮ አመዩ ጅራ?” ጄዼ ጋፈቴ። ኦቦሎትንሳ ገሩ ሰበቢ ፉለሳ ዱረት ነአኒ ቱረኒፍ ዴቢ እሳፍ ኬኑ ህንደንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","ዮሴፍስ ኦቦሎተሳቲን፣ “ሜ አስ ነት ዽኣዻ” ጄዼ። እሳን እሰት ዽኣናን እን አከነ ጄዼ፤ “አን ዮሴፍ ኦቦሌሰኬሰን እሰ እስን ግብጥት ጉርጉርተን ሰናዸ! ");
INSERT INTO gaze_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","አመስ ሰበቢ አስት ነ ጉርጉርተኒፍ ህንጋብና፤ ኦፍትስ ህንኣርና። ዋቅን ሉቡ በራሩፍ ጄዼ እስን ዱረ ነ ኤርጌራቲ። ");
INSERT INTO gaze_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","ወጎተ ለማን ከነ ቤለቱ ብየቲ ኬሰ ቱሬ፤ ወጎተ ሸነን ዹፈን ኬሰስ ለፈ ቆተቹፊ ምዻን ገልፈቹን ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","ዋቅን ለፈረት ሰኚ እስኒፍ ሀምብሱፊ ፉሪ ጉዳዻን ሉቡኬሰን ኦልቹፍ ጄዼ እስን ዱረ ነ ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“ዋቀቱ አስ ነ ኤርጌ መሌ እስን ምት። እን ፈረኦኒፍ አባ ነ ጎዼ፤ ወረ መነሳ ጅረን ሁንደረት ጎፍታ፣ ብየ ግብጥ ሁንደረትሞ ቡልቻ ነ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","አመስ ደፋ ገረ አባኮት ዴብኣቲ አከነ እሳን ጄዻ፤ ‘እልምኬ ዮሴፍ አከነ ጄዸ፦ ዋቅን ግብጥ ሁንደረት ጎፍታ ነ ጎዼረ። ገረኮት ገድ ቡእ፤ ህንቱርንስ። ");
INSERT INTO gaze_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","አት ብየ ጎሼን ኬሰ ንጅራተ፤ አት፣ እጆሌንኬቲፊ እጆሌን እጆሌኬቲ፣ ቡሻዬንኬ፣ ሎንኬቲፊ ወን አት ቀብዱ ሁንድ ነት ዽኣተኒ ጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","ሰበቢ አመዩ ወጋን ቤላ ሸን ዹፋ ጅሩፍ አን አችት ስን ሶረ፤ ዮ ከና አቺ አቲፊ ወር መነኬ ጅራተን፣ ወን አት ቀብዱ ሁንድኑስ ንረከቱ።’ ");
INSERT INTO gaze_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“አከ ነምን እስንት ዱበቻ ጅሩ ኩን አኑመ ተኤ ኩኖ፣ እጅኬሰን፣ እጅ ኦቦሌሰኮ ቤንያምስ ንአርገ። ");
INSERT INTO gaze_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","ኡልፍነ ግብጥ ኬሰት ና ኬነሜ ሁንዳፊ ዋን አርግተን ሁንደ አባኮት ህማ። አባኮስ ደፋቲ አስ ፍዳ።” ");
INSERT INTO gaze_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","ኤርገሲስ ሞርመ ኦቦሌሰሳ ቤንያምት መርሜ ቦኤ፤ ቤንያምስ ቦኣ እሰ ሀመቴ። ");
INSERT INTO gaze_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","ዮሴፍስ ኦቦሎተሳ ሁንደ ዹንገቴ እት ቦኤ። ኤርገሲ ኦቦሎትንሳ እሰ ወጅን ሃሰአን። ");
INSERT INTO gaze_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","ዮሙ አከ ኦቦሎትን ዮሴፍ ዹፈን መሰራ ፈረኦንት ዸገአሜት፣ ፈረኦኒፊ ቆንዳልቶትንሳ ንገመደን። ");
INSERT INTO gaze_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","ፈረኦንስ ዮሴፊን አከነ ጄዼ፤ “ኦቦሎተኬቲን አከነ ጄዽ፤ ‘ዋን ከነ ጎዻ፦ ሆሪኬሰን ፌአዻ ብየ ከነኣኒት ዴብኣቲ ");
INSERT INTO gaze_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","አባንኬሰኒፊ ማቲወንኬሰን ነት ፍዳ። አን ለፈ ብየ ግብጥ ኬሳ ለፈ ሁንደ ጫሉ እስኒፍ ነንኬነ። እስን ጮመ ብየቲ ንኛቱ።’ ");
INSERT INTO gaze_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“አከሱመስ አከነ ጄዺ እሳንት ህም፤ ‘ዋን ከነ ጎዻ፦ እጆሌኬሰኒፍስ፣ ኒቶተኬሰኒፍስ ብየ ግብጢቲ ጋሪወን ፉዸዻ፤ አባኬሰንስ ፍዳቲ ኮታ። ");
INSERT INTO gaze_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","ዋኤ ቀቤኘኬሰኒ ህንያደእና፤ ወን ብየ ግብጥ ጉቱ ኬሳ ዋን ሁንደ ጫሉ ከንኬሰን ተኣቲ።’ ” ");
INSERT INTO gaze_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","እልማን እስራኤልስ አከሱመ ጎዸን። ዮሴፍስ አኩመ ፈረኦን እሰ አጀጄት ጋሪወን ኬኔፊ ከራሳኒቲፍሌ ገላ ገላሴፍ። ");
INSERT INTO gaze_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","ቶኮ ቶኮሳኒቲፍ ወያ ኬኔ፤ ቤንያሚፍ ገሩ ሜቲ ሰቅሊ ዽበ ሰዲቲፊ ወያ እራ ጀላ ሸን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","አባሳቲፍሞ ሀሮተ፣ ወን ብየ ግብጥ ገጋሪን እት ፌአሜ ኩዸን፣ አከሱመስ ሀሮተ ዸልቱ ምዻን፣ ቡዴናፊ ገላን ብራ ከራሳቲፍ እት ፌአሜ ኩዸን ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","እንስ አከስት ኦቦሎተሳ ኤርጌ፤ እንስ ዬሮ እሳን ቀጄለንት፣ “ከራት ወል ህንሎልና!” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","እሳንስ ግብጥ ኬሳ ኦል በአኒ ገረ ብየ ከነኣን አባሳኒ ያቆብ ብረ ዸቀን። ");
INSERT INTO gaze_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","እሳንስ፣ “ዮሴፍ አመዩ ጅረ! ብየ ግብጥ ጉቱዩ እሱመቱ ቡልቸ” ጄዸኒን። ያቆብሞ ናሱዻን ኦፍ ወላሌ፤ ጀረ አመኑስ ህንደንዴኘ። ");
INSERT INTO gaze_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","ገሩ ዬሮ ጀር ዋን ዮሴፍ እሳኒን ጄዼ ሁንደ እሰት ህመኒ እንስ ጋሪወን ዮሴፍ እሰ ፍችሲሱፍ ኤርጌፍ ሰነ አርጌት ሉቡን አባሳኒ ያቆብ ንበየነቴ። ");
INSERT INTO gaze_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","እስራኤልስ፣ “ነ ገአ! እልምኮ ዮሴፍ አመዩ ጅረ። አንስ ኡቱን ህንዱእን ዸቄ እሰ ነንአርገ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","እስራኤል ዋን ቀቡ ሁንደ ፉዸቴ ከኤ፤ ዬሮ ቤርሼባ ገኤትስ ዋቀ አባሳ ዋቀ ይስሃቂፍስ ኣርሳ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","ዋቅንስ ሀልከን ሙልአታን፣ “ያቆብ! ያቆብ!” ጄዼ እስራኤልት ዱበቴ። እንስ፣ “ኩኖ አን አስ ጅረ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","ዋቅንስ አከነ ጄዼ፤ “አን ዋቀዮ፣ ዋቀ አባኬቲት። ግብጥት ገድ ቡኡ ህንሶዳትን፤ አን አችት ሰበ ጉዳ ስን ታስሳቲ። ");
INSERT INTO gaze_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","አን ስ ወጅን ግብጥት ገድ ቡኤ ዴብሴ ስን ፍደ። ሀርኩመ ዮሴፍቱ እጀኬ ወልት ሲፍ ቀበ።” ");
INSERT INTO gaze_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","ያቆብስ ቤርሼባዻ ከኤ ቀጄሌ፤ እልማን እስራኤልስ አባሳኒ ያቆብ፣ እጆሌሳኒቲፊ ኒቶተሳኒ ጋሪወን ያቆብን ባቹፍ ፈረኦን ኤርጌ ሰነረ ቴስሰን። ");
INSERT INTO gaze_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","ያቆቢፊ ሰኚንሳ ሁንድስ ሆሪሳኒቲፊ ቀቤኘ ከነኣንት ሆረተን ኦፍ ፋነ ፉዸተኒ ግብጥት ጎዳነን። ");
INSERT INTO gaze_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","እንስ ሰኚሳ ሁንደ ጄቹንስ እልማንሳ፣ እልማን እልማንሳ፣ እንተለንሳቲፊ እንተለን እልማንሳ ፉዸቴ ግብጥት ጎዳኔ። ");
INSERT INTO gaze_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","መቃወን እልማን እስራኤል ወረ ግብጥት ጎዳነን ሰና ጄቹንስ ያቆቢፊ ሰኚወንሳ ከኔኒዸ፦ ሩቤን ጄቹንስ እልመ ያቆብ ሀንገፍትቸ። ");
INSERT INTO gaze_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","እልማን ሩቤን፦ ሄኖክ፣ ፈሉሶ፣ ሄዝሮኒፊ ከርሚ። ");
INSERT INTO gaze_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","እልማን ስምኦን፦ ዬሙኤል፣ ያሚን፣ ኦሀድ፣ ያኪን፣ ዞሀሪፊ ሻዉል እልመ ዱበርቲ ከነኣን ሰና። ");
INSERT INTO gaze_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","እልማን ሌዊ፦ ጌርሾን፣ ቆሃቲፊ ሜራሪ። ");
INSERT INTO gaze_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","እልማን ይሁዳ፦ ኤር፣ ኦናን፣ ሼላ፣ ፋሬሲፊ ዛራ። ኤሪፊ ኦናን ገሩ ብየ ከነኣንት ዱአን። እልማን ፋሬስ፦ ሄዝሮኒፊ ሀሙል። ");
INSERT INTO gaze_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","እልማን ይሳኮር፦ ቶላ፣ ፉዋ፣ ዮቢፊ ሽምሮን። ");
INSERT INTO gaze_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","እልማን ዜቡሎን፦ ሴሬድ፣ ኤሎኒፊ የህልኤል። ");
INSERT INTO gaze_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","እሳን ኩኔን እንተለሳ ዲና ደበለቴ እልማን ልያን ካበ ዽአ ጳዳን አራምት ያቆቢፍ ዴሴዸ። እልማኒፊ እንተለንሳ ኩኔን ወሉማ ገለት ሶዶሚ ሰዲ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","እልማን ጋድ፦ ዚፍዮን፣ ሀጊ፣ ሹኒ፣ ኤስቦን፣ ኤሪ፣ አሮዲፊ አርኤል። ");
INSERT INTO gaze_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","እልማን ኣሼር፦ ይምና፣ ይሽዋ፣ ይሽዊፊ ቤሪያ። ኦቦሌቲንሳኒስ ሴራዸ። እልማን ቤሪያ፦ ሄቤሪፊ መልኪኤል። ");
INSERT INTO gaze_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","እሳን ኩኔን እጆሌ ዚፋን ያቆቢፍ ዴሴዸ። ዚፋን እሼ ላባን እንተለሳ ልያዻፍ ኬኔ ሰናዸ። እሳን ወሉማ ገለት ኩዸ ጀአ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","እልማን ራሄል ኒቲ ያቆብ፦ ዮሴፊፊ ቤንያም። ");
INSERT INTO gaze_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","ምናሴፊ ኤፍሬም፣ ኣሴነት እንተለ ጶጢፌራ ሉብቸ መጋላ ኦን ሰናራ ግብጥ ኬሰት ዮሴፊፍ ዸለተን። ");
INSERT INTO gaze_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","እልማን ቤንያም፦ ቤላ፣ ቤኬር፣ አሽቤል፣ ጌራ፣ ነአማን፣ ኤሂ፣ ሮሽ፣ ሙፊም፣ ሁፊሚፊ አርድ። ");
INSERT INTO gaze_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","እሳን ኩኔን እልማን ራሄል ያቆቢፍ ዴሴዸ፤ እሳንስ ወሉማ ገለት ነመ ኩዸ አፉር ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","እልም ዳን፦ ሁሺሚዸ። ");
INSERT INTO gaze_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","እልማን ንፍታሌም፦ የህዜል፣ ጉኒ፣ ዬጤሪፊ ሺሌም። ");
INSERT INTO gaze_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","እሳን ኩኔን እልማን ብልሃን ያቆቢፍ ዴሴዸ፤ ብልሃን እሼ ላባን እንተለሳ ራሄሊፍ ኬኔ ሰናዸ፤ እሳን ወሉማ ገለት ነመ ቶርበ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","ነሞትን ያቆብ ወጅን ግብጥት ጎዳነን ኡቱ ኒቶተ እልማንሳ ህንደበለን ሰኚንሳ ወሉማ ገለት ጃተሚ ጀአ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","እልማን ግብጥት ዮሴፊፍ ዸለተን ለማን ደበለቴ ምሴንሶትን ማቲ ያቆብ ወር ግብጥት ጎዳነን ወሉማ ገለት ቶርባተመ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","ያቆብስ አከ እን ዸቄ ከራ ጎሼንት ነመ ጌሱ ጋፈቱፍ ይሁዳ ኦፍ ዱረ ገረ ዮሴፍት ኤርጌ። ዮሙ እሳን ጎሼን ገአንት፣ ");
INSERT INTO gaze_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","ዮሴፍ ጋሪሳ ቆጴፈቴ አባሳ እስራኤል ስመቹፍ ጎሼንት ቀጄሌ። እንስ አኩመ ፉለሳ ዱረት ሙልአቴን ሞርመሳት መርሜ ዬሮ ዼራ ቦኤ። ");
INSERT INTO gaze_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","እስራኤልስ ዮሴፊን፣ “አን ሰበቢ አከ አት አመዩ ሉቡን ጅርቱ ኦፊኮቲን አርጌፍ ስአች ዱኡሌ ህንጋቡ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","ዮሴፍስ ኦቦሎተሳቲፊ ወረ መነ አባሳ ጅራተኒን አከነ ጄዼ፤ “አን ኦል በኤ ፈረኦንት ነንዱበዸ፤ አከነስ ነንጄዻን፤ ‘ኦቦሎትንኮፊ ወር መነ አባኮ ጅራተን ከኔን ብየ ከነኣን ጅራቻ ቱረን ነት ዹፈኒሩ። ");
INSERT INTO gaze_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","ነሞትን ኩኔን ትክሶተ፤ እሳን ሎን ትክፈቱቲ። እሳን ቡሻዬሳኒ፣ ሎኒፊ ዋን ቀበን ሁንደ ፉዸተኒ ዹፈን።’ ");
INSERT INTO gaze_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","ዮ ፈረኦን ኦፍት እስን ዋሜ፣ ‘ሆጂንኬሰን ማል?’ ጄዼ እስን ጋፈቴ፣ ");
INSERT INTO gaze_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‘ኑ ገርቦንኬ አኩመ አቦቲኬኛ እጆሉማኬኛ ጀልቀብኔ ሀመ አማት ሆሪ ትክፈቻ ቱሬ’ ጄዻ ዴብሳ። ዮስ እን ሰበቢ ትክሶትን ሁንድኑ ወረ ግብጥ ብረት ጅበመኒፍ አከ እስን ብየ ጎሼን ኬሰ ጅራተን እስኒ ኤየማ።” ");
INSERT INTO gaze_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","ዮሴፍስ ገረ ፈረኦን ዸቄ፣ “አባንኮቲፊ ኦቦሎትንኮ ቡሻዬሳኒ፣ ሎንሳኒቲፊ ዋን ቀበን ሁንደ ፉዸተኒ ብየ ከነኣን ዹፈኒ ኩኖ ብየ ጎሼን ጅሩ” ጄዼ እት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","እንስ ኦቦሎተሳ ኬሳ ነመ ሸን ፍለቴ ፈረኦንት ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","ፈረኦንስ፣ “ሆጂንኬሰን ማል?” ጄዼ ኦቦሎተ ዮሴፍ ጋፈቴ። እሳንስ፣ “ኑ ገርቦንኬ አኩመ አቦቲኬኛ ትክሶተ” ጄዸኒ ዴብሰኒፍ። ");
INSERT INTO gaze_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","አከነስ ጄዸኒን፤ “ሰበቢ ቤል ብየ ከነኣንት ጭሜ ቡሻዬን ገርቦተኬቲ ዋን ዼደን ዸበኒፍ ኑ ዬሮ ገባባ አስ ጅራቹ ዹፍኔ። አከ ኑ ገርቦንኬ ብየ ጎሼን ኬሰ ጅራኑፍ ማሎ ኑ ኤየም።” ");
INSERT INTO gaze_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","ፈረኦንስ ዮሴፊን አከነ ጄዼ፤ “አባንኬቲፊ ኦቦሎትንኬ ሲፍ ዹፈኒሩ፤ ");
INSERT INTO gaze_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","ለፍት ግብጥ ፉሉመኬ ዱረ ጅረ፤ አባኬቲፊ ኦቦሎተኬ እዶ ለፈ ሁንዱማ ጫሉረ ቁበቺስ። እሳን ብየ ጎሼን ኬሰ ሃጅራተን። አት ዮ ነሞተ እሳን ኬሳ ደንዴቲ ቀበን ቤክቴ ሎንኮረት እት ጋፈተምቶተ እሳን ጎዽ።” ");
INSERT INTO gaze_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","ኤርገሲ ዮሴፍ አባሳ ያቆብን ፍዴ ፉለ ፈረኦን ዱረት ዽኤሴ። ኤርገ ያቆብ ፈረኦንን ኤብሴ ቦዴ፣ ");
INSERT INTO gaze_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","ፈረኦን፣ “ኡምሪንኬ ሀመም?” ጄዼ እሰ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","ያቆብስ ፈረኦኒን አከነ ጄዼ፤ “በር አን ኬሱሙማን ጅራዼ ወጋ ዽባ ቶኮፊ ሶዶመ። በሮትንኮስ ሙራሰ፤ ሀማዸስ፤ እንስ በረ አቦቲንኮ ኬሱሙማን ጅራተን ሰናን ወል ቅጤ ምት።” ");
INSERT INTO gaze_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","ከነ ቦዴ፣ ያቆብ ፈረኦንን ኤብሴ ፉለሳ ዱራ ገድ በኤ። ");
INSERT INTO gaze_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","ዮሴፍስ አኩመ ፈረኦን እሰ አጀጄት አባሳቲፊ ኦቦሎተሳ ግብጥ ኬሰ ቁበቺሴ፤ ለፈ ለፈ ሁንደ ጫሉ፣ ኣና ራምሴ ሀንዹራ ጎዼ እሳኒ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","አከሱመስ ዮሴፍ አባሳቲፍ፣ ኦቦሎተሳቲፊ ወረ መነ አባሳ ጅረን ሁንዳፍ አኩመ ባይእነ እጆሌሳኒት ምዻን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","ዋን ቤል አከ መሌ ጭሜፍ ብየቲ ጉቱ ኬሰ ወን ኛተሙ ህንጅሩ ቱሬ፤ ሰበቢ ቤለ ሰናቲንስ ግብጢፊ ከነኣን አከ መሌ ሚዸመን። ");
INSERT INTO gaze_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","ዮሴፍስ ከፈልቲ ምዻን ነሞትን ብተቻ ቱረን ሰና ማለቀ ብየ ግብጢፊ ከነኣን ኬሰት አርገሙ ሁንደ ወልት ቀቤ መሰራ ፈረኦንት ገልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","ማለቅን ወረ ግብጢፊ ወረ ከነኣን ዹምናን ወር ግብጥ ሁንድ ገረ ዮሴፍ ዹፈኒ፣ “ምዻን ኑ ኬን። ኑ ማሊፍ ፉለኬ ዱረት ዱነ? ማለቅንኬኘ ዹሜረ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","ዮሴፍሞ፣ “ኤርገ ማለቅንኬሰን ዹሜ ሆሪኬሰን ፍዳ፤ ቆደ ሆሪኬሰኒ አን ምዻን እስኒፍ ነንኬነ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","እሳንስ ሆሪሳኒ ዮሴፍት ፍደን፤ ዮሴፍስ ቆደ ፈርዴንሳኒ፣ ቆደ ቡሻዬሳኒ፣ ቆደ ሎወንሳኒቲፊ ቆደ ሀሮተሳኒ ምዻን ኬኔፍ። እንስ በረ ሰነ ጌደራ ሆሪሳኒ ሁንዳ ምዻን እሳን ሶሬ። ");
INSERT INTO gaze_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","ወጋን ሱን ዹምናን ጀር ወጋ እት ኣኑት ገረሳ ዹፈኒ አከነ ጄዸን፤ “ኤርገ ማለቅንኬኘ ዹሜ ሆሪንኬኘ ከንኬ ተኤ አስ፣ ያ ጎፍታኬኘ አከ ዸግነኬኛፊ ለፈኬኘ መሌ ወን ቶኮዩ ኑፍ ህንሀፍን ኑ ጎፍታኬኘ ጀላ ህንዾክስኑ። ");
INSERT INTO gaze_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","ኑ ማሊፍ ፉለኬ ዱረት ዱነ? ኑፊ ለፍትኬኘስ ማሊፍ በድነ? ኑፊ ለፈኬኘ ፉዸዹቲ ቆደሳ ምዻን ኑፍ ኬን። ኑ ለፈኬኘ ወጅን ፈረኦኒፍ ንገርቦምነ። አከ ኑ ዱአ ጀላ ባኔ ጅራኑፍ፣ አከ ለፍትስ ዱዋ ህንሀፍኔፍ ሰኚ ኑፍ ኬን።” ");
INSERT INTO gaze_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","ዮሴፍስ ለፈ ብየ ግብጥ ሁንዱማ ፈረኦኒፍ ብቴ። ወር ግብጥ ሁንድ ዋን ቤል እሳንት ጭሜፍ ለፈሳኒ ጉርጉረን፤ ለፍትስ ከን ፈረኦን ተኤ፤ ");
INSERT INTO gaze_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","ዮሴፍስ ዳንጋ ብየ ግብጥ ቶኮራ ሀመ ዳንጋ ካኒት ሰበ ገርቡማ ጀለ ገልቼ። ");
INSERT INTO gaze_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","ለፍት እን ህንብትን ለፈ ሉቦታ ቆፈ ቱሬ፤ ኩንስ ሰበቢ እሳን ፈረኦንራ ቆደ አርገተኒፊ ሰበቢ ቆደ ፈረኦን እሳኒፍ ኬኑ ሰናን ጅራተኒፍ። ከናፉ እሳን ለፈሳኒ ህንጉርጉሬ። ");
INSERT INTO gaze_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","ዮሴፍስ ሰበ ሰናን አከነ ጄዼ፤ “ኩኖ አን ሀርአ እስኒፊ ለፈኬሰን ፈረኦኒፍ ብቴረ። ኩኖ ለፈት ሰኚ ፈጫፈዻ። ");
INSERT INTO gaze_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","ዮሙ ምዻን ገልፈሙት ሀርከ ሸን ኬሳ ሀርከ ቶኮ ፈረኦኒፍ ንኬንቱ። ሀርከ አፍረን ሀፌሞ ሰኚ ፈጫፈተን፣ ኛተ ኦፊኬሰኒ፣ ኛተ ወረ መነኬሰን ጅራተኒቲፊ ኛተ እጆሌኬሰኒ ጎዸቱ።” ");
INSERT INTO gaze_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","ጀርስ፣ “አት ዱአ ኑ ኦልችቴርተ፤ ኑ ፉለ ጎፍታኬኛ ዱረት ፉዸተመ ሃአርገትኑ መሌ ፈረኦኒፍ ገርቦተ ንታነ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","ዮሴፍስ አከሲን አከ ሀርከ ሸን ኬሳ ሀርክ ቶኮ ከን ፈረኦን ተኡፍ ግብጥ ኬሰት ሴረ ለፋ ዻቤ፤ ሴር ሱን ሀመ ሀርኣትሌ እቲን ሆጄተማ ጅረ። ለፈ ሉቦታ ቆፈቱ ኡቱ ከን ፈረኦን ህንተእን ሀፌ። ");
INSERT INTO gaze_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","እስራኤሎንስ ግብጥ ኬሰ ኩታ ብየ ጎሼን ኬሰ ቁበተን። አችትስ ቀቤኘ አርገተን፤ ሆረኒስ ጉዳ ባይአተን። ");
INSERT INTO gaze_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","ያቆብ ወጋ ኩዸ ቶርበ ብየ ግብጥ ኬሰ ጅራቴ፤ በር ጅሬኘሳስ ወጋ ዽበ ቶኮ አፉርተሚ ቶርበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","እስራኤልስ ዬሮን ዱአሳ ዽኣናን እልመሳ ዮሴፍን ኦፍት ዋሜ አከነ ጄዼን፤ “ዮ አን ፉለኬ ዱረት ፉዸተመ አርገዼ፣ ሜ ሀርከኬ ጉዴደኮ ጀለ ካኢቲ አከ ጋሩማ ነ አርግሲፍቱፊ አከ ናፍ አመነምቱ ዋዳ ናፍ ሴን። ግብጥት ነ ህንአዋልን፤ ");
INSERT INTO gaze_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","ዬሮ አን አቦቲኮ ወጅን ቦቆዹት ብየ ግብጢ ነ ባሲ እዶ እሳን እት አዋለመንት ነ አዋል።” እንስ፣ “አኩመ አት ጄቴ ነንጎዸ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","እስራኤልስ፣ “ና ከከዹ” ጄዼን። ዮሴፍስ ንከከቴፍ። እስራኤልሞ መታ ኡሌሳት እርከቴ ሰገዴ። ");
INSERT INTO gaze_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","ዬሮ ሙራሰ ቦዴ፣ “ኩኖ፣ አባንኬ ዹኩብሰቴረ” ጄዸኒ ዮሴፍት ህመን። እንስ እልማንሳ ለማን ምናሴፊ ኤፍሬምን ፉዸቴ ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","ያቆብ ዬሮ፣ “እልምኬ ዮሴፍ ገረኬ ዹፌረ” ጄዸኒ እት ህመንት፣ እስራኤል ኦፍ ጀጀቤሴ ከኤ ስሬረ ታኤ። ");
INSERT INTO gaze_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","ያቆብስ ዮሴፊን አከነ ጄዼ፤ “ዋቅን ዋን ሁንደ ደንደኡ ብየ ከነኣን ኬሰት ሉዝት ነት ሙልአቴ አችት ነ ኤብሴ፤ ");
INSERT INTO gaze_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","አከነስ ናን ጄዼ፤ ‘አን አከ አት ሆርቱፊ አከ አት ባይአቱ ነንጎዸ። ቱተ ሰባ ስን ጎዸ፤ አን ብየ ከነ ዻለ በረ በራ ጎዼ ሰኚወንኬ ወረ ስ ቦዴቲፍ ነንኬነ።’ ");
INSERT INTO gaze_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“ኤጋ አመ እልማንኬ ለማን ወር ኡቱ አን አስ ገረኬ ህንዹፍን ዱረ ግብጥት ሲፍ ዸለተን ሱን አኩመ እልማንኮት እላለሙ፤ አኩመ ሩቤኒፊ ስምኦን ከንኮ ተአን ሰነ ኤፍሬሚፊ ምናሴንስ ከኑመኮ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","እጆሌን እሳን ቦዴን ሲፍ ዸለተን ከንኬ ተኡ። ዻለ ቆደቹ ኬሰትሞ መቃ ኦቦሎተሳኒ ጀለት ለካአሙ። ");
INSERT INTO gaze_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","ዬሮ አን ካበ ዽአ ጳዳኒቲ ዴብኣ ቱሬት ኡቱመ ኤፍራታ ገኡፍ ጥኑመ ኑ ሀፌ ጅሩ ራሄል ብየ ከነኣን ኬሰት ነ ጀላ ዱናን አቹመት ከራ ኤፍራታ ዸቁ ብረት አዋለዼ።” ኤፍራታን ኩንስ ቤትልሄሚዸ። ");
INSERT INTO gaze_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","እስራኤል ዬሮ እልማን ዮሴፍ አርጌት፣ “እሳን ኩኔን ኤኙ?” ጄዼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","ዮሴፍሞ አባሳቲን፣ “እሳን ኩኔን እልማን ብየ ከነት ዋቅን ናፍ ኬኔዸ” ጄዼ። ከነረት እስራኤል፣ “አከ አን እሳን ኤብሱፍ ነት ፍድ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","ዬሮ ከነት እስራኤል ዱሎሜ እጅሳ ደዸቤ ቱሬ፤ እንስ ዋ ሁበቹ ህንደንደኡ ቱሬ። ከናፉ ዮሴፍ እልማንሳ እስራኤልት ዽኤሴ፤ እስራኤልስ እሳን ዹንገቴ፤ እሳን ሀመቴስ። ");
INSERT INTO gaze_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","እስራኤልስ ዮሴፊን፣ “አን ፉሉመ ኬዩ ነንአርገ ጄዼ ህንያድኔ፤ ዋቅን ገሩ አከ አን እጆሌ ኬዩ አርጉ ና ኤየሜ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","ዮሴፍስ ጅልበ እስራኤልራ አች እሳን ቡቴ ፉለሳቲን ለፈት ገድ ጎምብፈሜ። ");
INSERT INTO gaze_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","እንስ ኤርገሲ ለማንሳኒዩ ፉዼ ኤፍሬምን ከራ ምርገሳቲን ገረ ሀርከ እስራኤል እሰ ብታት፣ ምናሴሞ ብታሳቲን ገረ ሀርከ እስራኤል እሰ ምርጋት ፍዴ እሰት ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","እስራኤል ገሩ ኡቱመ ኤፍሬም ቁጥሱ ተኤ ጅሩ ሀርከሳ ምርጋ መታ ኤፍሬምራ ካኤ፤ ምናሴንሞ ኡቱመ ሀንገፈ ተኤ ጅሩ እስራኤል ሀርከሳ ወል ቀጣሙርሴ ሀርከሳ ብታ መታ ምናሴረ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","እንስ አከነ ጄዼ ዮሴፍን ኤብሴ፤ “ዋቅን እን አቦቲንኮ አብረሃሚፊ ይስሃቅ ፉለሳ ዱረ ጅራተን፣ ዋቅን እን በረ ጅሬኘኮ ጉቱ ሀመ ሀርኣት ትክሴኮ ቱሬ ሱን፣ ");
INSERT INTO gaze_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","ኤርገማን ዋቀዮ ከን በላ ሁንደ ጀላ ነ ባሴ ሱን እልማን ከኔን ሃኤብሱ። እሳን መቃኮቲን፣ መቃ አቦቲኮ አብረሃሚፊ ይስሃቂን ሃዋመመን፤ እሳን ለፈረት ጉዳ ሃባይአተን።” ");
INSERT INTO gaze_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","ዮሴፍ ዮሙ አከ አባንሳ ሀርከሳ ምርጋ መታ ኤፍሬምራ ካኤ አርጌት ንገዴ፤ ከናፉ እን ሀርከ አባሳ መታ ኤፍሬምራ ፉዼ መታ ምናሴረ ካኡፍ ጄዼ ካሴ። ");
INSERT INTO gaze_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","ዮሴፍ አባሳቲን፣ “ያ አባኮ፣ አከስ ምት፤ እን ኩን ሀንገፈ፤ ሀርከኬ ምርጋ መታሳረ ካእ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","አባንሳ ገሩ ድዴ አከነ ጄዼን፤ “አን ነንቤከ፤ ያ እልመኮ ነንቤከ። እንስ ሰበ ተአ፤ ሰበ ጉዳሳ ተአ። ተኡስ ኦቦሌስሳ እን ቁጥሱን እሰ ጫላ ጉዳ ተአ፤ ሰኚንሳስ ቱተ ሰበ ባይኤ ንተአ።” ");
INSERT INTO gaze_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","እንስ ጋፈ ሰነ አከነ ጄዼ እሳን ኤብሴ፤ “እስራኤል መቃኬቲን ኤበ ከነ ኬነ፤ ‘ዋቅን አከ ኤፍሬሚፊ አከ ምናሴ እስን ሃታስሱ።’ ” ዮሴፍስ አከሲን ምናሴ ዱረ ኤፍሬምን ደበርሴ። ");
INSERT INTO gaze_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","ኤርገሲ እስራኤል ዮሴፊን አከነ ጄዼ፤ “ኩኖ አን ዱኡ ገኤረ፤ ዋቅን ገሩ እስን ወጅን ተኤ ብየ አባኬሰኒት እስን ዴብሰ። ");
INSERT INTO gaze_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","አን ቆደ ኦቦሎተኬቲ ጫልችሴ ቆደ ቶኮ ሲፍን ኬነ፤ ኩንስ ለፈ ኦል ከኣ አን አሞሮተራ ጎራዴኮፊ እዳኮቲን ፉዸዼ ሰናዸ።” ");
INSERT INTO gaze_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","ያቆብ እልማንሳ ኦፍት ዋሜ አከነ ጄዼ፦ “አከ አን ዋን በረ ዹማ ኬሰ እስንት ዹፉ እስንት ህሙፍ ሜ ወልት ቀበማ። ");
INSERT INTO gaze_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“ያ እልማን ያቆብ ሜ ወልት ቀበማ ዸጌፈዻ፤ አባኬሰን እስራኤልን ዸጌፈዻ። ");
INSERT INTO gaze_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“ያ ሩቤን፣ አት እልመኮ ሀንገፈ፤ ሁምነኮ፣ መለቶ ጀልቀባ ከን ጀብነኮቲት፤ አት ኡልፍናን ንጫልተ፤ ሁምናንሌ ንጫልተ። ");
INSERT INTO gaze_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","አት አከ ብሻኒ አሲፊ አች ራፈምተ፤ ኦል ኣንቱማስ ህንቀባቱ፤ አት ስሬ አባኬቲት ኦል ባቴ፣ አፈተኮት ኦል ባቴ ጡሬስቴርታቲ። ");
INSERT INTO gaze_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“ስምኦኒፊ ሌዊን ኦቦሎተ፤ ጎራዴንሳኒ ምአ ፍንጭላት። ");
INSERT INTO gaze_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","ሉቡንኮ መሪሳኒት ህንሴንን፤ ኡልፍንኮስ ያኢሳኒት ህንደበለምን፤ እሳን ዼከምሰሳኒቲን ነመ አጄሰኒሩቲ፤ ፌዺ ኦፊሳኒቲንስ ቆትዮ ናፈቺሰኒሩ። ");
INSERT INTO gaze_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","ኣሪንሳኒ እን ሀማን፣ ዼከምስሳኒ እን ገረ ጀቤስ አባረማ ሃተኡ! አን ያቆብ ኬሰ እሳን ነንብትኔሰ፤ እስራኤል ኬሰስ እሳን ነንፈጫሰ። ");
INSERT INTO gaze_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“ያ ይሁዳ ኦቦሎትንኬ ስ ሌልሱ፤ ሀርክኬ ሞርመ ዲነኬቲ ቀበ፤ እልማን አባኬቲ ሲፍ ሰገዱ። ");
INSERT INTO gaze_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","ያ ይሁዳ አት ሳፌለ ሌንጫት፤ ያ እልመኮ አት አደሞዻ ዴብተ። እን አከ ሌንጫ፣ አከ ሌንጨ ዸላስ፣ ርጴ ጪሰ፤ ኤኙቱ እጀ ጀባቴ እሰ ካሰሬ? ");
INSERT INTO gaze_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","ሀመ ቡልቻን ዹፉት ቦኩን ሀርከ ይሁዳቲ፣ ኡሌን ቡልቺንሳ ሚለሳ ግዱዻ ህንዸበሙ፤ ሰቦትንስ እሳፍ ንአጀጀሙ። ");
INSERT INTO gaze_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","እን ሀሬሳ ሙከ ወይኒት፣ እልሞ ሀሬሳሞ ደሜ ፍለተማት ህዸተ፤ ወያሳ ዳዺ ወይኒቲን፣ ወንደቦሳሞ ዺገ ጉማ ወይኒቲን ሚጨተ። ");
INSERT INTO gaze_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","እጅሳ ዳዺ ወይኒረ ዲመተ፤ እልካንሳሞ ኣነንረ አዳተ። ");
INSERT INTO gaze_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“ዜቡሎን ቀርቀረ ገላና ጅራተ፤ ቡፈተ ዶኒወኒስ ተአ፤ ዳንጋንሳስ ሀመ ሲዶናት በልአተ። ");
INSERT INTO gaze_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“ይሳኮር ሀሬ ጀባ ፌኢሰ ለመ ግዱ ጪሱዸ። ");
INSERT INTO gaze_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","እንስ ዬሮ አከ እዶን ቦቆናሳ ሀመም ጋሪ ተኤፊ አከ ለፍትሳ ቶላ ተኤ አርጉት በኣ ባቹፍ ገቲቲሳ ገድ ቀበተ፤ ሆጂ ሁምና ሆጄቹፍ ኦፍ ኬነ። ");
INSERT INTO gaze_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“ዳን ጎሶተ እስራኤል ኬሳ አከ እሰ ቶኮት፣ ሰበሳቲፍ ሙርቲ ቀጄላ ንኬነ። ");
INSERT INTO gaze_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","ዳን ቦፈ ቀርቀረ ከራት፤ አከ ቡቲ ዳንዲራ፣ ከን አከ ነምች ፈርደ ያበቱ ገረ ዱባት ኩፉፍ ኮቴ ፈርዳ እዱ ንተአ። ");
INSERT INTO gaze_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“ያ ዋቀዮ፣ አን ፈይሱኬ ነንኤገዸ። ");
INSERT INTO gaze_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“ጋድ ዌረርቶታን ንዸአመ፤ እን ገሩ ፋነ ቡኤ እሳን ዸአ። ");
INSERT INTO gaze_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“ኣሼር ቡዴንሳ ፉርዳዸ፤ እን ሞቲዻፍ ኛተ ቶላ ንኬነ። ");
INSERT INTO gaze_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“ንፍታሌም ቦሮፈ ሂከምቴዸ፤ ዱቢ ጋሪስ ንዱበተ። ");
INSERT INTO gaze_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“ዮሴፍ ሙከ ወይኒ እጀ ቀቤሰ፣ ሙከ ወይኒ እጀ ቀቤሰ ቡርቃ ብሻኒት ዽኦ ጅሩዸ፤ ደሜንሳ ደላረ ያአ። ");
INSERT INTO gaze_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","ወር እዳ ቀበተን ወራነ እሰት በነን፤ እሰት ፉታሰን፤ እሰ ጅበንስ። ");
INSERT INTO gaze_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","ገሩ እዳንሳ ጀባቴ ሀፌ፤ እሬን ሀርከሳ፣ ሀርከ ዋቀ ጀባ ያቆቢን ጀቤፈሜ። አቺስ ትክሴ ሰናን፣ ከታ እስራኤሊን፣ ");
INSERT INTO gaze_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","ዋቀ አባኬቲ እሰ ስ ገርጋሩን፣ ዋቀ ዋን ሁንደ ደንደኡ እሰ ኤበ ሰሚ ጉባቲን፣ ኤበ ገድ ፈጎ እሰ ጀላቲን፣ ኤበ ሀርማቲፊ ገደሜሳቲን ስኤብሱ ሰናን ንኤብፈምተ። ");
INSERT INTO gaze_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","ኤብ አባኬቲ፣ ኤበ ቱሉወን ዱሪ፣ አርጁማ ጋረን ዱሪ ጫለ። ኩን ሁንድ መታ ዮሴፊት፣ ጉቤ መታ እሰ ኦቦሎተሳ ኬሳ ሆገና ተኤት ሃቀበቱ። ");
INSERT INTO gaze_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“ቤንያም ዬዪ ባይኤ ቤለኤዸ፤ ገነመ ዋን አደምሴ እት ገገቤ ኛተ፤ ገልገለሞ ቦጁ ህረ።” ");
INSERT INTO gaze_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","ወር ኩኔን ሁንድ ጎሶተ እስራኤል ኩዸ ለማን፤ ኩንስ ዋን አባንሳኒ ዬሮ ኤበ ቶኮ ቶኮ እሳኒፍ ተኡን እሳን ኤብሴት እሳንት ዱበቴዸ። ");
INSERT INTO gaze_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","ኤርገሲስ ያቆብ አከነ ጄዼ እሳን አጀጄ፤ “አን ገረ ሰበኮቲት ወልት ቀበሙ ገኤረ፤ ሆልቀ ለፈ ቆቲሳ ኤፍሮን ነምቸ ጎሰ ሄት ሰናት አቦቲኮ ብረት ነ አዋላ። ");
INSERT INTO gaze_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","ሆልቅ ኩንስ ሆልቀ ብየ ከነኣን ኬሰት መምሬ ብረት ለፈ ቆቲሳ መክፌላ ኬሰት አርገሙ ከን አብረሃም እዶ አዋላ ጎዸቹፍ ኤፍሮን ነምቸ ጎሰ ሄት ሰነራ ለፈ ቆቲሳ ወጅን ብተቴዸ። ");
INSERT INTO gaze_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","አብረሃሚፊ ኒቲንሳ ሳራን አችት አዋለመን፤ ይስሃቂፊ ኒቲንሳ ርብቃን አችት አዋለመን፤ አንስ አቹመተን ልያ አዋሌ። ");
INSERT INTO gaze_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","ለፍት ቆቲሳቲፊ ሆልቅ እሰ ኬሰ ጅሩ ሄቶተራ ብተመን።” ");
INSERT INTO gaze_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","ያቆብ አኩመ እልማንሳ አጀጁ ራወቴን ሚለሳ ስሬረት ኦል ዴብፈቴ ሀፉረ ዹማ ባፈቴ፤ ገረ ሰበ እሳትስ ወልት ቀበሜ። ");
INSERT INTO gaze_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","ዮሴፍስ አባሳረት ኩፌ ቦኤፍ፤ እሰ ዹንገቴስ። ");
INSERT INTO gaze_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","ኤርገሲሞ ዮሴፍ ተጃጅልቶተሳ ከኔን ኦጌሶተ ፈያ ተአን አከ እሳን ሬፈ አባሳ ቆርቻን ሱኩመን አጀጄ፤ ጀርስ ሬፈ እስራኤል ቆርቻን ሱኩመን፤ ");
INSERT INTO gaze_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","ዋን ከነ ጎቹን ቡልቲ አፉርተመ ጉቱ እሳንት ፉዸቴ፤ ዬሮን ቆርቸ ሬፈ ድቡፍ በርባችሱ ከነ ቱሬቲ። ወር ግብጢስ ቡልቲ ቶርባተመ እሳፍ ቦአን። ");
INSERT INTO gaze_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","ጉዮትን ገዳ ደርብናን ዮሴፍ ወረ መነ ፈረኦን ጅራተኒን አከነ ጄዼ፤ “ዮ አን ፉለኬሰን ዱረት ፉዸተመ አርገዼረ ተኤ፣ አከነ ጄዻቲ ፈረኦንት ና ህማ፦ ");
INSERT INTO gaze_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘አባንኮ አከነ ጄዼ ነ ከከቺሴረ፤ “ኩኖ አን ዱኡ ገኤረ፤ አዋለ አን ብየ ከነኣን ኬሰት ኦፊኮቲፍ ቆተዼት ነ አዋላ።” ከናፉ ማሎ አን አመ ዸቄ አባኮ ነንአዋለዸ፤ ኤርገሲሞ ነንዴብአ።’ ” ");
INSERT INTO gaze_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","ፈረኦንስ፣ “ዸቂቲ አኩመ እን ስ ከከቺሴ ሰነት አባኬ አዋለዹ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","ዮሴፍስ አባሳ አዋለቹ ዸቄ። ቆንዳልቶትን ፈረኦን ሁንድኑ ሀንገፎትን መነሳቲፊ ሀንገፎትን ግብጥ ሁንድ እሰ ወጅን ዴመን። ");
INSERT INTO gaze_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","አከሱመስ ወር መነ ዮሴፍ ጅራተን፣ ኦቦሎተሳቲፊ ወር መነ አባሳ ጅራተን ሁንድ እሰ ወጅን ዴመን። እጆሌሳኒ፣ ቡሻዬሳኒቲፊ ሎንሳኒ ቆፈቱ፣ ጎሼንት ሀፌ። ");
INSERT INTO gaze_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","ጋሪወኒፊ ወር ፈርደ ያበተንስ እሰ ወጅን ዴመን። ቱትን ሱንስ አከ መሌ ጉዳ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","እሳንስ ዮሙ ዮርዳኖስ ገመ ኦብዲ አጣድ ብረ ገአንት ሰገሌሳኒ ኦል ፉዸተኒ ገዶደኒ ቦአን። ዮሴፍስ አችት አባሳቲፍ ጉያ ቶርበ ቦኤ። ");
INSERT INTO gaze_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","ነሞትን ከነኣን ወር አች ጅራቻ ቱረን ቦእቸ ኦብዲ አጣድ ብረት ቦአሜ ሰነ አርገኒ፣ “ቦእች ኩን ወረ ግብጢቲፍ ቦእቸ ጉዳዸ” ጄዸን። ከናፉ እዶን ሱን አቤል ምስራይም ጄዸሜ ሞጋፈሜ። እዶን ሱንስ ዮርዳኖስ ገመት አርገመ። ");
INSERT INTO gaze_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","እልማን ያቆብ አኩመ እን እሳን አጀጄ ሰነ ጎዸን፤ ");
INSERT INTO gaze_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","እሳንስ ብየ ከነኣንት እሰ ጌሰኒ ሆልቀ መምሬ ብረት ለፈ ቆቲሳ መክፌላ ኬሰት አርገሙ ከን አብረሃም እዶ አዋላ ጎዸቹዻፍ ኤፍሮን ነምቸ ጎሰ ሄት ሰነረ ለፈ ቆቲሳ ወጅን ብተቴ ሰነት አዋለን። ");
INSERT INTO gaze_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","ዮሴፍ ኤርገ አባሳ አዋለቴ ቦዴ ኦቦሎተሳቲፊ ወረ እሰ ወጅን አባሳ አዋሉ ዸቀን ሁንደ ወጅን ግብጥት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","ኦቦሎትን ዮሴፍ ኤርገ አባንሳኒ ዱኤ ቦዴ፣ “ዮ ዮሴፍ ሀማ ኑ እሰት ሆጄትኔ ሁንዳፍ ሃሎ ቀበቴ ሃሎ ኑት በኤሆ?” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","እሳንስ አከነ ጄዸኒ ዮሴፍት ዻመተን፤ “አባንኬ ኡቱ ህንዱእን ዱረ አከነ ጄዼ አጀጄ፤ ");
INSERT INTO gaze_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘እስን አከነ ጄዻ ዮሴፍት ህማ፤ አን አከ አት ጩቡፊ በሌሳ ኦቦሎትንኬ ስ ሚዹፍ ጄዸኒ ስት ሆጄተን ሰነሳኒ ዺፍቱ ስን ከዸዸ።’ ማሎ ጩቡ ተጃጅልቶተ ዋቀ አባኬቲ ዺስ።” ዮሴፍስ ዮሙ ኤርጋሳኒ ዸገኤት ንቦኤ። ");
INSERT INTO gaze_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","ኦቦሎትንሳስ ዹፈኒ ፉለሳ ዱረት ለፈ ዸአኒ፣ “ኩኖ ኑ ገርቦተኬት” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","ዮሴፍ ገሩ አከነ እሳኒን ጄዼ፤ “ህንሶዳትና። አነቱ እዶ ዋቃ ቡኣ? ");
INSERT INTO gaze_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","እስን ሀማ ነት ያደን፤ ዋቅን ገሩ አኩመ አመ ተኤ ጅሩ ከነ ሉቡ ነመ ባይኤ በራሩፍ ጄዼ ዋን ጋሪፍ ያዴ። ");
INSERT INTO gaze_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","ኤጋ ህንሶዳትና። አን እስኒፊ እጆሌኬሰን ነንሶራቲ።” እንስ ዋን ገራ እሳን ጪብሱ እሳንት ዱበቴ እሳን ጀጀቤሴ። ");
INSERT INTO gaze_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","ዮሴፍ ማቲ አባሳ ወጅን ግብጥ ኬሰ ቱሬ። እንስ ወጋ ዽበ ቶኮፊ ኩዸን ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","ዸሎተ ሰደፋ እጆሌ ኤፍሬም አርጌ። አከሱመስ እልማን ማኪር እልመ ምናሴ ጅልበ ዮሴፍረት ዸለተን። ");
INSERT INTO gaze_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","ዮሴፍስ ኦቦሎተሳቲን አከነ ጄዼ፤ “አን ዱኡ ገኤረ። ዋቅን ገሩ ዹጉማን ዹፌ እስን ገርጋረ፤ ብየ ከና እስን ባሴስ ገረ ብየ አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ ከኩን ዋዳ ገሌ ሰናት እስን ጌሰ።” ");
INSERT INTO gaze_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","ዮሴፍስ እጆሌ እስራኤል ከከቺሴ አከነ ጄዼን፤ “ዋቅን ዹጉማን ዹፌ እስን ገርጋረ፤ እስንስ ለፌኮ ብየ ከና ኦል ባሱ ቀብዱ።” ");
INSERT INTO gaze_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","ዮሴፍስ ወጋ ዽበ ቶኮፊ ኩዸንት ዱኤ። ጀርስ ቆርቻን ሱኩመኒ ግብጥት ሰንዱቀ ሬፋ ኬሰ እሰ ካአን። ");
INSERT INTO gaze_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","መቃን እልማን እስራኤል ከኔን ማቲሳኒ ቀበተኒ ያቆብ ወጅን ግብጥ ዸቀኒ ከናዸ፦ ");
INSERT INTO gaze_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","ሩቤን፣ ስምኦን፣ ሌዊፊ ይሁዳ፤ ");
INSERT INTO gaze_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","ይሳኮር፣ ዜቡሎኒፊ ቤንያም፤ ");
INSERT INTO gaze_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","ዳኒፊ ንፍታሌም፤ ጋዲፊ ኣሼር። ");
INSERT INTO gaze_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","ነሞትን ሰኚ ያቆብራ ዸለተን ወሉማ ገለት ቶርባተመ ቱረን፤ ዮሴፍ ዱሩማኑ ግብጥ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","ዮሴፊፊ ኦቦሎተሳ ሁንድ፣ ዸሎትን ሱን ሁንድኑስ፣ ንዱአን። ");
INSERT INTO gaze_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","እስራኤሎትን ገሩ ሆረኒ አከ መሌ ባይአተን፤ ባይአተኒስ አከ መሌ ጀባተን፤ ብየቲ ኬሰስ ንጉተን። ");
INSERT INTO gaze_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","ኤርገሲ ሞቲን ዋኤ ዮሴፍ ህንቤክን ሃራን ቶኮ ቡልቻ ግብጥ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","እንስ ሰበሳቲን አከነ ጄዼ፤ “ኩኖ፣ እስራኤሎትን ኑ ጫላ ባይአተኒሩ፤ ኑ ጫላስ ጀባተኒሩ። ");
INSERT INTO gaze_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","ኮታ አከ እሳን ከነ ጫላ ህንባይአኔፍ፣ ዮ ወራን ከኤስ ዲኖተኬኘ ገርጋረኒ አከ ኑ ህንወራኔፊ አከ ብየቲ ኬሳ በቀተኒ ህንባኔፍ ሀጡማዻን እሳን ቀብነ።” ");
INSERT INTO gaze_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","ከናፉ እት ጋፈተምቶተ እሳን ጩንቁርሰኒ ሆጂ ሁምና ሆጄቺሰን እሳንት ሙደን፤ እስራኤሎንስ ፊቶሚፊ ራምሴ መጋላወን ዋ እት ኩሰን ጎዸኒ ፈረኦኒፍ እጃረን። ");
INSERT INTO gaze_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","እሳን ገሩ ሀመ ጩንቁርሳን እሳንት ጀባቻ ዴሜ ሰነ ባይአተኒ ለፈ ጉተን፤ ከነረት ወር ግብጥ ሰበ እስራኤል ሶዳተን። ");
INSERT INTO gaze_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","ወር ግብጥስ እስራኤሎተት ገረ ጀብናን እሳን ሆጄቺፈተን። ");
INSERT INTO gaze_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","እሳንስ ሱጴፊ ጡቢ ሆጄቺሱዻን፣ ለፈ ቆቲሳ ኬሰስ ሆጂ ገራ ገራ ሁንደ ሆጄቺሱዻን ሆጂ እት ጭምሰኒ ጅሬኘ እሳንት ሀዼሰን፤ ወር ግብጥ ሆጂ ጀባ ጀረ ሆጄቺሰን ሁንደ ኬሰት ገራ እሳኒፍ ህንላፈን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","ሞቲን ግብጥ ዴስስቶተ እብሮታ ከኔን ሲፓራፊ ፉሃ ጄዸመኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“እስን ዮሙ ዱበርቶተ እብሮታ ደኡምሰረት ገርጋርተኒፊ በርጩመ ደኡምሳረት እሳን አርግተን፣ ዮ ዺረ ተኤ አጄሳ፤ ዮ ዱርበ ታቴሞ ሃጅራቱ ዺሳ።” ");
INSERT INTO gaze_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","ዴስስቶትን ሱን ገሩ ዋን ዋቀ ሶዳተኒፍ፣ ዋን ሞቲን ግብጥ እሳንት ህሜ ሰነ ህንጎኔ፤ እጆሌ ዺራስ አከ እሳን ጅራተኒፍ ዺሰን። ");
INSERT INTO gaze_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","ሞቲን ግብጥስ ዴስስቶተ ሰነ ኦፍት ዋሜ፣ “እስን ማሊፍ ዋን ከነ ጎተን? ማሊፍስ እጆሌ ዺራ አከ እሳን ጅራተኒፍ ዺፍተን?” ጄዼ እሳን ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","ዴስስቶትን ሱንስ፣ “ዱበርቶትን እብሮታ አከ ዱበርቶተ ወረ ግብጥ ምት፤ እሳን ዋን ጀጀቦ ተአኒፍ ኡቱ ዴስስቶትን እሳን ብረ ህንገእን ደአኒ ነመ ኤጉ” ጄዸኒ ፈረኦኒፍ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","ዋቅንስ ዴስስቶተ ሰናፍ ዋን ጋሪ ጎዼ፤ እስራኤሎንስ ባይአተኒ አከ መሌ ጀባተን። ");
INSERT INTO gaze_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","ሰበቢ እሳን ዋቀ ሶዳተኒፍ ዋቅን ዴስስቶተ ሰናፍ ማቲ ኦፊሳኒ ኬኔፍ። ");
INSERT INTO gaze_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","ከነረት ፈረኦን፣ “እልመ ዸለቱ ሁንደ ለገ አበያ ኬሰ ቡሳ፤ ዱርብ ሁንድ ገሩ ሃጅራቱ ዺሳ” ጄዼ ሰበሳ ሁንደ አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","ሰኚ ሌዊ ኬሳ ነምች ቶኮ እንተለ ሌዊ ቶኮ ፉዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","እሼንስ ኡልፎፍቴ እልመ ዴሴ። ዮሙ አከ እን በሬዳ ተኤ አርግቴት ጅአ ሰዲ እሰ ዾክስቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","ከነ ጫላ እሰ ዾክሱ አከ ህንደንዴኜ ዬሮ ቤክቴት ገሩ ጉቦ ዸላዱራ ሆጄተሜ ቶኮ ፉቴ ሀጴፊ ሌሌ እት ዾብዴ፤ ሙጫ ሰነ ጉቦ ኬሰ ጪብስቴ ቀርቀረ ለገ አበያ ሸምበቆ ኬሰ ኬሴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","ኦቦሌቲንሳሞ ዋን ሙጭቸረ ገኡ እላሉፍ ጄቴ ፈጎ ዻበቻ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","ዬሮ ሰነ እንተል ፈረኦን ዸግነ ዽቀቹፍ ገረ ለገ አበያት ገድ ቡቴ፤ ዱበርቶትን እሼ ተጃጅለንስ ቀርቀረ ለገ ሰናረ አሲፊ አች ዴዴማ ቱረን። እሼንስ ጉቦ ሰነ ሸምበቆ ኬሰት አርግቴ አከ ዸቅጤ ፍዱፍ ገርብቲሼ ኤርግቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","እሼንስ ጉቦ በንቴ ሙጫ ሰነ አርግቴ፤ ኩኖ ሙጭችስ ቦኣ ቱሬ። እሼንስ ገራ ላፍቴፊ፣ “ኩን ዳእመን እብሮታ ኬሳ ቶኮዸ” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","ኦቦሌቲን ሙጭቻስ እንተለ ፈረኦኒን፣ “አከ እሼን ሆስፍቴ ሲፍ ጉድፍቱፍ ዸቄ ዱበርቶተ እብሮታ ኬሳ ጉድፍቱ ቶኮ ሲፍ ዋሙ?” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","እሼንስ፣ “ኤዬ፣ ዸቅ” ጄቴን። እንተል ሱንስ ዸቅጤ ሃዸ ሙጫ ሰና ዋምቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","እንተል ፈረኦንስ ዱበርትቲዻን፣ “ሙጫ ከነ ፉዺ ና ሆስስ፤ አን ምንዳኬ ሲፍን ኬና” ጄቴ። ዱበርቲን ሱንስ ዳእመ ሰነ ፉቴ ሆስፍቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","ሙጫን ሱን ጉደትናን እሼን እንተለ ፈረኦንት ፍዴ። እንስ እልመሼ ተኤ። እሼንስ፣ “አን ብሻን ኬሳ እሰ ነንባሴ” ጄቹዻን መቃሳ ሙሴ ጄቴ ሞጋፍቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","ሙሴን ኤርገ ጉደቴ ቦዴ ጋፈ ቶኮ ለፈ ሰብንሳ ቱሬ ዸቄ ኡቱ እሳን ሆጂ ደዸብሲሳ ሆጄተኑ አርጌ፤ ኡቱ ነምን ግብጥ ቶኮስ እብሮተ ሰበሳ ኬሳ ነመ ቶኮ ሩኩቱ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","እንስ አሲፊ አች እላሌ አከ ነምን ቶኮዩ ህንጅሬ ምርከኔፈቴ፤ ነምቸ ግብጥ ሰነ አጄሴ ጭረቸ ኬሰ ዾክሴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","ጉያ እት ኣኑትሞ ገድ በኤ ኡቱ እብሮትን ለመ ወል ሎለኑ አርጌ። እብርቸ በሌሳ ቀቡንስ፣ “አት ማሊፍ እብርቸ አከኬቲ ሩኩተ?” ጄዼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","ነምች ሱንስ፣ “ኤኙቱ ኑረት ቡልቻፊ አባ ሙርቲ ስ ጎዼ? አኩመ ነምቸ ግብጥ አጄፍቴ ሰነ አነሌ አጄሱ በርባዳ?” ጄዼን። ከነረት ሙሴን፣ “ዹጉማን ወን አን ሆጄዼ ሱን ቤከሜረ ጄቹዸ” ጄዼ ሶዳቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","ፈረኦን ዮሙ ዋን ከነ ዸገኤት ሙሴ አጄሱ ያሌ፤ ሙሴን ገሩ ፈረኦን ጀላ ገረ ምድያንት በቀቴ፤ ዮሙ አች ገኤትስ ቦለ ቶኮ ብረ ታኤ። ");
INSERT INTO gaze_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","ሉብን ምድያን ቶኮ እንተለን ቶርበ ቀበ ቱሬ፤ እሳንስ ዹፈኒ ቡሻዬ አባሳኒ ኦባሱፍ ብሻን ቡዱቅሰኒ ብድሩት ጉታ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","ትክሶትንስ ዹፈኒ እሳን አርአን፤ ሙሴን ገሩ ከኤ እሳን ገርጋሬ ቡሻዬሳኒ ኦባሴፍ። ");
INSERT INTO gaze_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","ዬሮ ዱበር ሱን ገረ አባሳኒ ሬኡኤልት ዴብአንት፣ እን፣ “እስን ሀርአ አከሚን ደፍተኒ ዴብተን?” ጄዼ እሳን ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","እሳንስ፣ “ነምቸ ግብጥ ቶኮቱ ትክሶተ ጀላ ኑ ባሴ፤ እን ብሻንዩ ኑ ቡዱቅሴ ቡሻዬ ኑፍ ኦባሴ” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","እንሞ እንተለንሳቲን፣ “እን ኤሰ ጅረ? እስን ማሊፍ እሰ ዺፍተኒ ዹፍተን? አከ እን ዋ ኛቱፍስ ዸቃቲ ዋማ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","ሙሴንስ ነምቸ ብረ ጅራቹ ጃለቴ፤ ነምችስ እንተለሳ ዝጶራ ሙሴት ሄሩምሲሴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","ሲፓራን እልመ ዴሴ፤ ሙሴንስ፣ “አን አለጋ ተኤ ብየ ኦርማ ጅራዼረ” ጄቹዻን መቃሳ ጌርሾም ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","በረ ዼራ ሰነ ኬሰ ሞቲን ግብጥ ንዱኤ። ነሞትን እስራኤልስ ሰበቢ ገርቡማ ኬሰ ቱረኒፍ ንኣደን፤ ንእየንስ፤ እይ እሳን ሰበቢ ገርቡማ ጀለ ቱረኒፍ ገርጋርሰ አርገቹፍ እየንስ ዋቀ ብረ ገኤ። ");
INSERT INTO gaze_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","ዋቅንስ ኣዱሳኒ ዸገኤ ከኩሳ ከን አብረሃም፣ ይስሃቂፊ ያቆብ ወጅን ገሌ ሰነ ያደቴ። ");
INSERT INTO gaze_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","ዋቅንስ ሰበ እስራኤል እላሌ፤ ዋቅን አከ እሳን እት ጅረን ቤኬ። ");
INSERT INTO gaze_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","ሙሴን ቡሻዬ አባ ኒቲሳ ዬትሮ ሉብቸ ምድያን ሰና ትክሳ ቱሬ፤ እንስ ጋፍ ቶኮ ሀመ ዽአ ለፈ ገሞጂት ቡሻዬ ሰነ ኦፌ ገረ ቱሉ ዋቃ ገረ ኮሬብ ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","አችትስ ኤርገማን ዋቀዮ ደገለ ቦበኡ ኬሳ አረበ እብዳ ኬሳን እሰት ሙልአቴ። ሙሴንስ ደገል ሱን ቦበኡሌ አከ ህንጉበትን አርጌ። ");
INSERT INTO gaze_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","ሙሴንስ፣ “ደገል ኩን ማሊፍ ህንጉበቱ ላተ? አን እት ጎሬ ዋን ድንቅሲሳ ከነ እላሉ ቀበ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","ዋቀዮስ ዮሙ አከ ሙሴን እላሉፍ አች ጎሬ አርጌት፣ ዋቅን ደገለ ሰነ ኬሳ፣ “ሙሴ! ሙሴ!” ጄዼ እሰ ዋሜ። ሙሴንስ፣ “ኩኖ አን አሰን ጅረ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","ዋቅንሞ፣ “አስ ህንዽኣትን፤ ሰበቢ እዶን አት ዻበቱ ኩን ቁልቁሉ ተኤፍ ኮጴኬ ባፈዹ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","እት ፉፌስ፣ “አን ዋቀ አባኬቲ፣ ዋቀ አብረሃም፣ ዋቀ ይስሃቂፊ ዋቀ ያቆብ” ጄዼ። ከነረት ሙሴን ዋቀ እላሉ ዋን ሶዳቴፍ ፉለሳ ዾክፈቴ። ");
INSERT INTO gaze_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","ዋቀዮ አከነ ጄዼ፤ “አን ዹጉማን ዽጵነ ሰበኮ ወረ ግብጥ ኬሰ ጅራተንረ ገኡ አርጌረ። እየ እሳን ወረ ሁምናን እሳን ሆጄቺሰን ጀላ በኡፍ እየንስ ዸገኤረ፤ አን ረክነሳኒስ ነንቤከ። ");
INSERT INTO gaze_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","ከናፉ አን ሀርከ ወረ ግብጢቲ እሳን ባሴ ገረ ብየ ጋሪፊ በልኣት፣ ብየ ኣነኒፊ ደም ኬሳ ቡርቁት ጄቹንስ ገረ ብየ ከነኣኖታት፣ ሄቶታት፣ አሞሮታት፣ ፌርዞታት፣ ሂዎታቲፊ ዬቡሶታት ኦል እሳን ባሱፍ ጄዼ ገድ ቡኤረ። ");
INSERT INTO gaze_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","አመ ኩኖ እይ እስራኤሎታ ነ ብረ ገኤረ። አን ሃለ እት ወር ግብጥ እሳን ጩንቁርሰንስ አርጌረ። ");
INSERT INTO gaze_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","ከናፉ አት አመ ዸቅ። አን አከ አት ሰበኮ እስራኤሎተ ግብጥ ኬሳ ባፍቱፍ ፈረኦንት ስን ኤርገ።” ");
INSERT INTO gaze_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","ሙሴን ገሩ ዋቃን፣ “ፈረኦን ብረ ዸቄ ግብጢ እስራኤሎተ ባሱፍ አን ኤኙ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","ዋቅንስ አከነ ጄዼ፤ “አን ስ ወጅን ነንተአ። አት ሰበ ሰነ ግብጢ ዮሙ ባፍቱት እስን ቱሉ ከነረት ዋቀ ዋቄፈቱ። ስ ኤርጉኮቲፍስ ኩን መለቶ ሲፍ ተአ።” ");
INSERT INTO gaze_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","ሙሴንሞ ዋቃን፣ “ኩኖ አን ገረ እስራኤሎታ ዸቄ፣ ‘ዋቅን አባኬሰኒ ነ ኤርጌረ’ ዮሙን ጄዹት ዮ እሳን፣ ‘መቃንሳ ኤኙ?’ ጄዸኒ ነ ጋፈተን፣ አን ማል ጄዼን እሳንት ህመ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","ዋቅንስ ሙሴዻን፣ “አን አኑመ ፤ አት ሰበ እስራኤሊን፣ ‘እን አን አኑመ ጄዹ ሱን ገረኬሰንት ነ ኤርጌረ’ ጄዽ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","ዋቅን አመስ ሙሴዻን አከነ ጄዼ፤ “እስራኤሎታን አከነ ጄዽ፤ ‘ዋቀዮ ዋቅን አቦቲኬሰኒ፣ ዋቅን አብረሃም፣ ዋቅን ይስሃቅ፣ ዋቅን ያቆብ እስንት ነ ኤርጌረ።’ “መቃን ኩን በረ በራን መቃኮት፤ መቃ አን ዸሎታ ሀመ ዸሎታት እቲን ያደተሙዸ። ");
INSERT INTO gaze_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“ዸቂ ማንጉዶተ እስራኤል ወልት ቀቢቲ አከነ ጄዺን፤ ‘ዋቀዮ ዋቅን አቦቲኬሰኒ፣ ዋቅን አብረሃም፣ ከን ይስሃቂፊ ከን ያቆብ ነት ሙልአቴ አከነ ጄዼ፦ “አን እስን እላሌረ፤ ዋን ግብጥት እስንረ ገኤስ አርጌረ። ");
INSERT INTO gaze_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","ከናፉ አን ረክነ ግብጥ ኬሳ እስን ባሴ ብየ ኣነኒፊ ደም ኬሳ ቡርቁ ጄቹንስ ብየ ከነኣኖታ፣ ሄቶታ፣ አሞሮታ፣ ፌርዞታ፣ ሂዎታቲፊ ብየ ዬቡሶታት እስን ጌሱፍ ሙርቴሴረ።” ’ ");
INSERT INTO gaze_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“ማንጉዶትን እስራኤል ስ ዸገኡ። አቲፊ ማንጉዶትን እስራኤል ሞቲ ግብጥ ብረ ዸቅጠኒ፣ ‘ዋቀዮ ዋቅን እብሮታ ኑት ሙልአቴረ፤ ኤጋ አመ አከ ኑ ዋቀዮ ዋቀኬኛፍ ኣርሳ ዽኤስኑፍ ገረ ገሞጂት ከራ ጉያ ሰዲ ኑ ኤየም’ ጄቱን። ");
INSERT INTO gaze_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","ገሩ አከ ሞቲን ግብጥ ዮ እሬን ጀባን እሰ ድርቅሲሴ መሌ ዴሙፍ እስኒ ህንኤየምኔ አኑ ቤከ። ");
INSERT INTO gaze_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","አን ድንቂ እሳን ግዱት ሆጄዹ ሁንዳን እሬኮ ሂጠዼ ነሞተ ግብጥ ነንዸአ። ኤርገሲ እን አከ ዴምተን እስኒፍ ኤየመ። ");
INSERT INTO gaze_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“አንስ አከ ሰብን ኩን ፉለ ወረ ግብጥ ዱረት ሱራ አርገቱ ነንጎዸ፤ እስንስ ዮሙ ግብጢ ባተንት ሀርከ ዱዋ ህንባተን። ");
INSERT INTO gaze_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","ቶኮን ቶኮን ዱበርቲ ምአ ሜቲ፣ ምአ ወርቄቲፊ ኡፈተ ጋፈቴ ኦላሼቲፊ ዱበርቲ መነሼ ጅራቱራ ሃፉዸቱ፤ ከናንስ እልማኒፊ እንተለንኬሰንት ኡፍፍቱ። አከሲንስ ቀቤኘ ወረ ግብጥ ቦጅተኒ ባቱ።” ");
INSERT INTO gaze_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","ሙሴን፣ “ዮ እሳን፣ ‘ዋቀዮ ስት ህንሙልአትኔ’ ጄዸኒ ነ አመኑ ዮካን ነ ዸገኡ ድደንሆ?” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","ከነረት ዋቀዮ፣ “ወንት ሀርከኬ ኬሰ ጅሩ ሱን ማል?” ጄዼን። ሙሴንሞ፣ “ኡሌዸ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","ዋቀዮስ፣ “ለፈ ቡስ” ጄዼን። ሙሴን ለፈ ቡፍናን ኡሌን ሱን ቦፈ ተኤ፤ እንስ እራ በቀቴ። ");
INSERT INTO gaze_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","ዋቀዮ ገሩ ሙሴዻን፣ “ሀርከኬ ሂጠዹቲ ኤጌሳ ቀብ” ጄዼ። ሙሴንስ ሂጠቴ ቦፈ ሰነ ቀቤ፤ ቦፍት ሱንስ ሀርከሳ ኬሰት ዴብኤ ኡሌ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","ዋቀዮስ፣ “ኩን አከ እሳን ዋቀዮ ዋቅን አቦቲሳኒ፣ ዋቅን አብረሃም፣ ዋቅን ይስሃቅ፣ ዋቅን ያቆብ ስት ሙልአቴ አከ አመነኒፍ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","ዋቀዮስ ሙሴዻን፣ “ሀርከኬ ቦባኬ ኬሰ ካአዹ” ጄዼ። ሙሴንስ ሀርከሳ ቦባሳ ኬሰ ካአቴ፤ ዮሙ እን ባፈቴትስ፣ ኩኖ ሀርክሳ ለምጢ አከ ጨቢ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","እንስ ሙሴዻን፣ “ሀርከኬ ዴብሲ ቦባኬ ኬሰ ካአዹ” ጄዼ፤ ሙሴንስ ዴብሴ ሀርከሳ ቦባሳ ኬሰ ካአቴ፤ ዮሙ እን ባፈቴትስ፣ ኩኖ ሀርክሳ ዴብኤ አኩመ ዸግነሳ እሰ ካኒ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","ዋቀዮስ አከነ ጄዼ፤ “እሳን ዮ ስ አመኑ ባተኒ መለቶ እሰ ጀልቀባ ፉዸቹ ድደን መለቶ ለመፋ ንአመኑ ተአ። ");
INSERT INTO gaze_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","ዮ እሳን መለቶ ከነ ለማን አመኑ ባተኒ ስ ዸገኡ ድደን ብሻን ለገ አበያ ቡዱቅሲቲ ለፈ ጎጋረት ዸንገላስ። ብሻን አት ለግቸራ ቡዱቅስቴ ሱንስ ለፈ ጎጋረት ዺገ ተአ።” ");
INSERT INTO gaze_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","ሙሴንስ ዋቀዮን፣ “ያ ጎፍታ፣ አን ዱርስ ተኡ ዮካን ኤርገ አት ገርብቸኬት ዱበቹ ጀልቀብዴ አስ ነመ አረበ ቀጄሉ ምት። አን ነመ አፋንሳ ህዸሜ አረብንሳስ እት ኡልፋቱዸ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","ዋቀዮስ አከነ እሳን ጄዼ፤ “ከን አፋን ነማ ኡሜ ኤኙ? ከን አከ ነምን አረብ-ድዳ ተኡ ዮካን ዱዱ ጎዹ ኤኙ? ከን አገርቱ እጃ ነማፍ ኬኑ ዮካን ጃምሱ ኤኙ? አኑመ ዋቀዮ ምቲ? ");
INSERT INTO gaze_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","አመ ዸቅ፤ አን አፋንኬ ወጅን ነንተአ፤ ዋን አት ጄቱስ ስን በርሲሰ።” ");
INSERT INTO gaze_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","ሙሴን ገሩ፣ “ያ ጎፍታ፣ ማሎ ነመ ብራ ኤርግ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","ዼከምስ ዋቀዮስ ሙሴረት ቦበኤ፤ እንስ አከነ ጄዼ፤ “ኦቦሌስኬ አሮን ሌዊች ጅረ ምቲ? አን አከ እን አከ ጋሪት ዱበቱ ነንቤከ። ኩኖ፣ እን ገረኬ ዹፉት ጅረ። እን ዮሙ ስ አርጉት ንገመደ። ");
INSERT INTO gaze_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","አት እሰት ዱበቴ አፋንሳ ኬሰ ዱቢ ንኬሰ፤ አንስ አፋንኬቲፊ አፋንሳ ወጅን ነንተአ፤ ዋን እስን ሆጄተንስ እስን ነንበርሲሰ። ");
INSERT INTO gaze_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","እን ኡመተት ሲፍ ዱበተ፤ እን አፋን ሲፍ ተአ፤ አትሞ እሳፍ አከ ዋቃ ንታተ። ");
INSERT INTO gaze_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","አት ኡሌ እቲን መለቶ አርግሲፍቱ ከነ ሀርከት ቀበዹ።” ");
INSERT INTO gaze_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","ሙሴን ገረ አባ ኒቲሳ ገረ ዬትሮት ዴብኤ፣ “አከ አን ገረ ሰበኮ ወረ ግብጥ ጅራተንት ዴብኤ ሀመ አማት ሉቡን ጅራቹሳኒ አርጉፍ ማሎ ና ኤየም” ጄዼን። ዮቶርስ፣ “ነጋን ዸቅ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","ዋቀዮ ምድያንት ሙሴዻን፣ “ነሞትን ስ አጄሱ በርባደን ሁንድ ዱአኒሩቲ ግብጥት ዴብእ” ጄዼ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","ከናፉ ሙሴን ኒቲሳቲፊ እልማንሳ ፉዸቴ ሀሬረ ካኤ ግብጥት ዴብኤ። እንስ ኡሌ ዋቃ ሀርከት ቀበቴ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አት ዬሮ ግብጥት ዴብቱት ድንቂወን አን አከ አት ሆጄቱፍ ሁምነ ሲፍ ኬኔ ሰነ ሁንደ ፉለ ፈረኦን ዱረት ሆጄዹ። አን ገሩ አከ እን ሰበ ሰነ ገድ ህንለክፍኔ መተ ጀቤሰ እሰ ነንጎዸ። ");
INSERT INTO gaze_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","አት ፈረኦኒን አከነ ጄዽ፤ ‘ዋቀዮ አከነ ጄዸ፦ እስራኤል እልመኮ ሀንገፈ፤ ");
INSERT INTO gaze_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","አንስ፣ “አከ እልምኮ ነ ተጃጅሉፍ ገድ ለክስ” ጄዼ ስት ህሜረ። አት ገሩ እሰ ገድ ለክሱ ድዴ፤ ከናፉ፣ ኩኖ አን እልመኬ ሀንገፈ ነንአጄሰ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","ዋቀዮ ከራረት እዶ ቡልቲት ሙሴት ዹፌ እሰ አጄሱ በርባዴ። ");
INSERT INTO gaze_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","ዝጶራ ገሩ ዸጋ ቀረ ቀቡ ፉዸቴ ቆለ ዸግነ እልመሼ ኩቴ እቲን ሚለ ሙሴ ቱቅጤ። እሼንስ፣ “አት ዹጉማን አናፍ ምስርቸ ዺጋት” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","ዋቀዮስ እሰ ዺሴ። ዬሮ ሰነ እሼን ዋኤ ዸግነ ቀባቲፍ፣ “ምስርቸ ዺጋት” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","ዋቀዮስ አሮኒን፣ “አት ሙሴ ስመቹፍ ገረ ገሞጂ ዸቅ!” ጄዼ። እንስ ዸቄ ቱሉ ዋቃረት ሙሴ አርገቴ እሰ ዹንገቴ። ");
INSERT INTO gaze_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","ዬሮ ሰነ ሙሴን ዱቢ ዋቀዮ አከ እን ዱበቱፍ እሰ ኤርጌ ሁንዳፊ መለቶወን አከ እን ሆጄቱፍ እሰ አጀጄ ሁንደ አሮንት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","ሙሴፊ አሮን ማንጉዶተ እስራኤል ሁንደ ወልት ቀበን፤ ");
INSERT INTO gaze_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","አሮንስ ዋን ዋቀዮ ሙሴት ህሜ ሁንደ ጀረት ህሜ። መለቶወንስ ፉለ ነሞታ ዱረት ሆጄቴ፤ ");
INSERT INTO gaze_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","እሳንስ ንአመነን። ጀርስ ዮሙ አከ ዋቀዮ ሰበ እስራኤል እላሌፊ አከ እን ረክነሳኒስ አርጌ ዸገአንት ገድ ጄዸኒ ሰገደን። ");
INSERT INTO gaze_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","ኤርገሲ ሙሴፊ አሮን ፈረኦን ብረ ዸቀኒ፣ “ዋቀዮ ዋቅን እስራኤል አከነ ጄዸ፤ ‘አከ እን ገሞጂት አያነ ና አያኔሱፍ ሰበኮ ገድ ዺስ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","ፈረኦንሞ፣ “አከ አን እሳፍ አጀጀሜ እስራኤልን ገድ ዺሱፍ ዋቀዮ ኩን ኤኙ? አን ዋቀዮ ሰነ ህንቤኩ፤ እስራኤልንስ ገድ ህንዺሱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","እሳንስ አከነ ጄዸን፤ “ዋቅን እብሮታ ኑት ዹፌረ። አከ ኑ ዋቀዮ ዋቀኬኛፍ ኣርሳ ዽኤስኑፍ ገረ ገሞጂት ከራ ጉያ ሰዲ ኑ ኤየም፤ አከስ ተኡ ባናን እን ዸእቻን ዮካን ጎራዴዻን ኑ ዸአ።” ");
INSERT INTO gaze_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","ሞቲን ግብጥ ገሩ፣ “ያ ሙሴፊ አሮን፣ እስን ማሊፍ ሰበ ከነ ሆጂ ዾውቱ? ሆጂኬሰንት ዴብኣ!” እሳኒን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","ፈረኦንስ እቱመ ፉፌ፣ “ኩኖ ሰብን ብየቲ አመ ባይአቴረ፤ እስንሞ ሆጂ እሳን ዾዋ ጅርቱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","ጉዩመ ሰነ ፈረኦን አከነ ጄዼ እት ጋፈተምቶተ ሆጂቲፊ ቆንዳልቶተ ሰባ አጀጄ፤ ");
INSERT INTO gaze_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“ስአች ጡቢ ሆጄቹዻፍ ሰበ ከናፍ ጭዲ ህንኬንና፤ እሳን ኦፉመሳኒቲ ዸቀኒ ጭዲ ሃበርባደተን። ");
INSERT INTO gaze_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","ገሩ አከ እሳን ለኮብሰ ጡቢ ከን ዱራን ሆጄቻ ቱረን ሰነ ሆጄተን ጎዻ፤ ሀመ እሳንት ረመደሜ ህንህርእስና። እሳን ዽባኦዸ፤ ከናፉ፣ ‘ኑ ዸቅኔ ዋቀኬኛፍ ኣርሳ ዽኤስነ’ ጄዸኒ እያ ጅሩ። ");
INSERT INTO gaze_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","አከ እሳን ሆጂዻን ቀበመኒ ዱቢ ሶባቲፍ ጥዬፈኖ ህንኬንኔፍ ሆጂ እሳንት ጭምሳ።” ");
INSERT INTO gaze_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","እት ጋፈተምቶትን ሆጂቲፊ ቆንዳልቶትን ሰባ ገድ ያአኒ ሰበ ሰናን አከነ ጄዸን፤ “ፈረኦን አከነ ጄዸ፦ ‘አን ስአች ጭዲ እስኒ ህንኬኑ። ");
INSERT INTO gaze_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","ለፈ እት አርገቹ ደንዴሰን ዸቃቲ ኦፊኬሰኒ ጭዲ በርባደዻ፤ ሆጂንኬሰን ገሩ ጎንኩማ ህንህርአቱ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","ሰብን ሱን ቆደ ጭዲ፣ ሃፈ ወልት ቀበቹፍ ጄዼ ብየ ግብጢ ጉቱ ኬሰ ፈፈጨኤ። ");
INSERT INTO gaze_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","እት ጋፈተምቶትን ሱንስ፣ “እስን ሆጂኬሰን ከን ጉያ ጉያ አኩመ ዬሮ ጭዲን ቱሬ ሰናት ሆጄዻ ራወዻ” ጄዸኒ እሳን ጀርጀርሳ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","እስራኤሎትን ቆንዳልቶተ ሆጂ ተአን ከኔን እት ጋፈተምቶተ ገርቦተ ፈረኦኒን ሙደመንስ ሬበመኒ፣ “እስን ከሌሳፊ ሀርአ ማሊፍ ቆደ ጡቢ ከን አከ ሆጄተኒፍ እስኒ ረመደሜ ሰነ አኩመ ዱሪት ህንጉተትኔ?” ጄዸመኒ ጋፈተማ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","እስራኤሎትን ቶአቶተ ሆጂ ተአንስ ዸቀኒ አከነ ጄዸኒ ፈረኦንት እየተን፤ “አት ማሊፍ ተጃጅልቶተኬ አከስ ጎተ? ");
INSERT INTO gaze_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","ጭዲን ተጃጅልቶተኬቲፍ ህንኬነሙ፤ ተኡስ፣ ‘ጡቢ ሆጄዻ!’ ኑን ጄዸን። ኩኖ ተጃጅልቶትንኬ ሬበማ ጅሩ፤ በሌሳን ገሩ ከኑመ ሰበኬቲት።” ");
INSERT INTO gaze_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","ፈረኦንስ አከነ ጄዼ፤ “እስን ዽባኦዸ፤ እስን ዽባኦዸ! ከናፉ እስን፣ ‘ኑ ዸቅኔ ዋቀዮፍ ኣርሳ ዽኤስነ’ ጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","አመ ዸቃቲ ሆጄዻ፤ ጭዲን እስኒፍ ህንኬነሙ፤ ገሩ ጡቢ እስንት ረመደሜ ሆጄተኒ ጉቱ ቀብዱ።” ");
INSERT INTO gaze_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","እስራኤሎትን ቶአቶተ ሆጂ ተአን ዮሙ፣ “እስን ለኮብሰ ጡቢ ከን ጉያ ጉያት አከ ሆጄተኒፍ እስንራ ኤገሙ ሰነ ህርእሱ ህንቀብደን” ጄዸሜ እሳንት ህመሜት አከ ረክነ ኬሰ ሴነን ሁበተን። ");
INSERT INTO gaze_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","ዬሮ ፈረኦን ብራ ገድ በአንት ኡቱ ሙሴፊ አሮን እሳን ኤገኑ አርገተን፤ ");
INSERT INTO gaze_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","እሳንስ፣ “ዋን እስን አከ ፈረኦኒፊ ቆንዳልቶትንሳ ኑ ጥሬፈተን ጎተኒ አከ እሳን ኑ አጄሰኒፍ ጎራዴ ሀርከሳኒ ኬሰኬሰኒፍ ዋቀዮ እስንት ሃእላሉ፤ እስንት ሃሙሩስ!” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","ሙሴን ገረ ዋቀዮት ዴብኤ አከነ ጄዼ፤ “ያ ጎፍታ፣ አት ማሊፍ ሰበ ከነት ረክነ ፍዴ? አት ከናፍ ነ ኤርግቴ? ");
INSERT INTO gaze_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","ጋፈ አን መቃኬቲን ዱበቹፍ ፈረኦን ብረ ዸቄ ጀልቀቤ እን ሰበኬት ረክኑመ ፍዳ ጅረ፤ አት ገሩ ጎንኩማ ሰበኬ ህንፉሬ።” ");
INSERT INTO gaze_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","ዋቀዮስ ሙሴዻን፣ “አመ ዋን አን ፈረኦንረት ሆጄዹ አት ንአርግተ፦ ሰበቢ እሬኮ ጀባ ሰናቲፍ ሞትች ገድ እሳን ዺሰ፤ ሰበቢ እሬኮ ጀባ ሰናቲፍስ ሞትች ብየሳ ኬሳ እሳን አርአ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","ዋቅን አመስ ሙሴዻን አከነ ጄዼ፤ “አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","አን አከ ዋቀ ዋን ሁንደ ደንደኡተን አብረሃምት፣ ይስሃቅቲፊ ያቆብት ሙልአዼ፤ ገሩ መቃኮ ዋቀዮን እሳንት ኦፍ ህንቤክስፍኔ። ");
INSERT INTO gaze_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","አከሱመስ አን ብየ ከነኣን ለፈ እሳን አከ አለጋት ኬሰ ጅራተን ሰነ እሳኒ ኬኑፍ ጄዼ እሳን ወጅን ከኩ ገሌረ። ");
INSERT INTO gaze_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","ከነረትስ፣ አን ኣዱ ሰበ እስራኤል ከኔን ወረ ግብጢን ገርቦምፈመን ሰና ዸገኤ ከኩኮ ያደዼረ። ");
INSERT INTO gaze_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“ከናፉ ሰበ እስራኤሊን አከነ ጄዽ፦ ‘አን ዋቀዮ፤ ዋንጆ ወረ ግብጥ ጀላ እስን ነንባሰ፤ አን ገርቡማሳኒ ጀላ እስን ነንባሰ፤ እሬ ድሪራፊ ሙርቲ ጀባዻንስ እስን ነንፉረ። ");
INSERT INTO gaze_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","አን አከ ሰበ ኦፊኮት እስን ፉዸዸ፤ ዋቀኬሰን ነንተአ። ዬሮ ሰነ እስን አከ አን ዋቀዮ ዋቀኬሰን ከን ዋንጆ ወረ ግብጥ ጀላ እስን ባሴ ተኤ ንቤክቱ። ");
INSERT INTO gaze_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","አን ብየ እሰን አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ ኬኑፍ ሀርከኮ ኦል ቀበዼ ከከዼ ሰነት እስን ነንገልቸ። ዻለ ጎዼስ እስኒፍ ኬነ። አን ዋቀዮ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","ሙሴንስ ዋን ከነ ሰበ እስራኤልት ህሜ፤ እሳን ገሩ ዋን አብዲ ኩተተኒፊ ገርቡማ ሀማ ኬሰ ቱረኒፍ እሰ ህንዸጌኜ። ");
INSERT INTO gaze_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“ዸቂቲ አከ እን ብየሳ ኬሳ እስራኤሎተ ገድ ለክሱፍ ፈረኦን ሞትቸ ግብጥት ህም።” ");
INSERT INTO gaze_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","ሙሴን ገሩ ዋቀዮን፣ “ኩኖ እስራኤሎትን ነ ህንዸጌኜ፤ ዮስ ፈረኦን አከምት ነ ዸገአሬ? አፋንኮ ቀጄልቼ ህንዱበተቱቲ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","ዋቀዮ ገሩ ዋኤ እስራኤሎታቲፊ ዋኤ ፈረኦን ሞትቸ ግብጥ ሙሴፊ አሮንት ዱበቴ አከ እሳን ሰበ እስራኤል ግብጢ ባሰን እሳን አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","ሀንገፎትን በልበለወንሳኒ ከኔኒዸ፦ እልማን ሩቤን እልመ እስራኤል ሀንገፍትቻ፦ ሄኖክ፣ ፈሉስ፣ ሄዝሮኒፊ ከርሚ። ");
INSERT INTO gaze_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","እልማን ስምኦን፦ ዬሙኤል፣ ያሚን፣ ኦሀድ፣ ያኪን፣ ዞሀር፣ ሻዉል እልመ ዱበርትቲ ከነኣን። ");
INSERT INTO gaze_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","መቃን እልማን ሌዊስ አኩመ ዸሎተሳኒት ከናዸ፦ ጌርሾን፣ ቆሃቲፊ ሜራሪ። ");
INSERT INTO gaze_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","እልማን ጌርሾን አኩመ ማቲሳኒት፦ ሎቤኒፊ ሽሜኢ። ");
INSERT INTO gaze_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","እልማን ቆሃት፦ አምራም፣ ይዝሃር፣ ኬብሮኒፊ ኡዚኤል። ቆሃት ወጋ 133 ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","እልማን ሜራሪ፦ መህሊፊ ሙሲ። ");
INSERT INTO gaze_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","አምራም ኦቦሌቲ አባሳ ዮኬቤድን ፉዼ፤ እሼንስ አሮኒፊ ሙሴ ዴሴፍ። ");
INSERT INTO gaze_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","እልማን ይዝሃር፦ ቆራህ፣ ናፌጊፊ ዝክሪ። ");
INSERT INTO gaze_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","እልማን ኡዚኤል፦ ሚሻኤል፣ ኤልዛፋኒፊ ስትሪ። ");
INSERT INTO gaze_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","አሮን እንተለ አሚናዳብ ኦቦሌቲ ነህሾን ኤሊሼባ ፉዼ፤ እሼንስ ናዳብ፣ አቢሁ፣ ኤሌኣዛሪፊ ኢታማርን ዴሴፍ። ");
INSERT INTO gaze_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","እልማን ቆራህ፦ አሲር፣ ኤልቃናፊ አቢኣሳፍ። ");
INSERT INTO gaze_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","ኤሌኣዛር እልም አሮን እንተለን ፉትኤል ኬሳ ቶኮ ፉዼ፤ እሼንስ ፊኔሃስን ዴሴፍ። ");
INSERT INTO gaze_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","አሮኒፊ ሙሴን ወር ዋቀዮ፣ “እስን አኩመ ኩታ ኩታሳኒት ግብጥ ኬሳ እስራኤሎተ ባሳ” ጄዼን ሱን እሳኑመ ከነ። ");
INSERT INTO gaze_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","እሳንስ ወረ ዋኤ ግብጥ ኬሳ እስራኤሎተ ባሱ ፈረኦን ሞትቸ ግብጥት ዱበተን ሰናዸ። ሙሴፊ አሮን እሳኑመ ከነ። ");
INSERT INTO gaze_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","ዋቀዮ ዬሮ ግብጥ ኬሰት ሙሴት ዱበቴ ሰነ ");
INSERT INTO gaze_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","አከነ ጄዼን፤ “አን ዋቀዮዸ። ዋን አን ስት ህሙ ሁንደ ፈረኦን ሞትቸ ግብጥት ህም።” ");
INSERT INTO gaze_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","ሙሴን ገሩ ዋቀዮን፣ “ኩኖ፣ አን ዋን አፋንኮ ቀጄልቼ ዱበቹ ህንደንዴኜፍ ፈረኦን አከሚን ነ ዸገአ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “እላ፣ አን ፈረኦኒፍ ዋቀ ስ ጎዼረ፤ ኦቦሌስኬ አሮንሞ ራጂ ሲፍ ተአ። ");
INSERT INTO gaze_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","አት ዋን አን ስ አጀጁ ሁንደ ንዱበተ፤ ኦቦሌስኬ አሮንሞ አከ እን እስራኤሎተ ብየሳ ኬሳ ገድ ዺሱ ፈረኦንት ንህመ። ");
INSERT INTO gaze_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","አን ገሩ ፈረኦንን መተ ጀቤሰ ነንጎዸ፤ ዮ አን ብየ ግብጥ ኬሰት መለቶወኒፊ ድንቂወንኮ ባይእሴዩ፣ ");
INSERT INTO gaze_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","እን እስን ህንዸጌፈቱ። አን ሀርከኮ ግብጥረት ኦል ነንካሰ፤ ሙርቲ ጀባዻንስ ራያኮ፣ ሰበ እስራኤል ብየ ግብጥ ኬሳ ነንባሰ። ");
INSERT INTO gaze_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","ወር ግብጥ ዮሙ አን ሀርከኮ ግብጥረት ኦል ካፈዼ ሰበ እስራኤል አች ኬሳ ባሱት አከ አን ዋቀዮ ተኤ ንቤኩ።” ");
INSERT INTO gaze_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","ሙሴፊ አሮንስ አኩመ ዋቀዮ እሳን አጀጄ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","ዬሮ ፈረኦንት ዱበተንት ሙሴን ነመ ወጋ ሰዴተመ ቱሬ፤ አሮንሞ ነመ ወጋ ሰዴተሚ ሰዲ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","ዋቀዮስ ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“ዮሙ ፈረኦን፣ ‘ድንቂ ሆጄዻ’ እስኒን ጄዹት፣ አትሞ አሮኒን፣ ‘ኡሌኬ ፉዺቲ ፉለ ፈረኦን ዱረት ለፈ ቡስ’ ጄተ፤ ኡሌን ሱንስ ቦፈ ተአ።” ");
INSERT INTO gaze_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","ሙሴፊ አሮን ፈረኦን ብረ ዸቀኒ አኩመ ዋቀዮ እሳን አጀጄ ሰነ ጎዸን። አሮን ፉለ ፈረኦኒፊ ቆንዳልቶተሳ ዱረት ኡሌሳ ለፈ ቡሴ፤ ኡሌን ሱንስ ቦፈ ታቴ። ");
INSERT INTO gaze_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","ፈረኦንስ ቤክቶታፊ ፈልፈልቶተ ኦፍት ዋሜ፤ ቶልፈቶትን ግብጥ ኦጉማሳኒ ዾከታ ሰናን አከሱመ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","ቶኮን ቶኮንሳኒ ኡሌሳኒ ለፈ ቡሰን፤ ኡሌንሳኒስ ቦፈ ተኤ። ኡሌን አሮን ገሩ ኡሌሳኒ ልቅምስቴ። ");
INSERT INTO gaze_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","ተኡስ ፈረኦን አኩመ ዋቀዮ ዱበቴ ሰነ መተ ጀቤሰ ተኤ እሳን ዸጌፈቹ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","ከነረት ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ፈረኦን መተ ጀቤሰ ተኤረ፤ ሰበ ሰነስ ገድ ዺሱ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","ገነማን ገረ ፈረኦን ዸቅ፤ ኩኖ እን ብሻንት ገድ በአ። ኡሌ ቦፈት ጌደረምቴ ሰነ ሀርከት ቀበዹቲ ቀርቀረ ለገ አበያት እሰ ኤግ። ");
INSERT INTO gaze_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","አከነስ ጄዺን፤ ‘ዋቀዮ ዋቅን እብሮታ አከነ ጄዼ ስት ነ ኤርጌረ፦ አከ ሰብንኮ ዸቄ ገሞጂ ኬሰት ናፍ ሰገዱፍ ገድ ለክስ። አት ገሩ ሀመ አማት አጀጀሙ ድዴርተ። ");
INSERT INTO gaze_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","ዋቀዮ አከነ ጄዸ፦ አከ አን ዋቀዮ ተኤ አት ከናን ቤክተ፦ ኩኖ አን ኡሌ ሀርከኮ ኬሰ ጅሩ ከናን ብሻን አበያ ነንዸአ፤ ብሻን ሱንስ ዺገት ጌደረመ። ");
INSERT INTO gaze_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","ቁርጡሚወን ለገ አበያ ኬሳ ንዱኡ፤ ለግን ሱንስ ንአጃአ፤ ወር ግብጥስ ብሻን ለገ ሰና ዹጉ ህንደንደአን።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","ዋቀዮሞ ሙሴዻን አከነ ጄዼ፤ “አሮኒን አከነ ጄዽ፤ ‘ኡሌኬ ቀበዹቲ ብሻኖተ ግብጥረት፣ ለጌንሳኒረት፣ ዶሎሎሳኒረት፣ ሀሮሳኒቲፊ ኩሳ ብሻኒ ሁንደረት ሀርከኬ ድሪርስ።’ እሳንስ ዺገት ጌደረሙ። ግብጥ ጉቱን ዺጋን ጉተመ፤ ቆዳን ሙካቲፊ ኦኮቴን ዸጋ ዺጋን ጉተመን።” ");
INSERT INTO gaze_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","ሙሴፊ አሮን አኩመ ዋቀዮ እሳን አጀጄ ሰነ ጎዸን። አሮን ኡሌሳ ኦል ፉዼ ፉለ ፈረኦኒቲፊ ቆንዳልቶተሳ ዱረት ብሻን አበያ ዸኤ፤ ብሻን ሱን ሁንድስ ዺገት ጌደረሜ። ");
INSERT INTO gaze_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","ቁርጡሚወን አበያ ዱናን ለግች አጃኤ፤ ወር ግብጥስ ብሻንሳ ዹጉ ህንደንዴኜ። ግብጥ ጉቱንስ ዺጋን ጉተሜ። ");
INSERT INTO gaze_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","ገሩ ቶልፈቶትን ግብጥ ቶልቸሳኒቲን አከሱመ ሆጄተን፤ ፈረኦንስ መተ ጀቤሰ ተኤ። እንስ አኩመ ዋቀዮ ጄዼ ሰነ ሙሴፊ አሮን ዸገኡ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","ፈረኦንስ ዴብኤ መሰራሳ ሴኔ፤ እንስ ዋን ከነ ያደትሌ ህንቀበትኔ። ");
INSERT INTO gaze_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","ወር ግብጥ ሁንድ ዋን ብሻን ለገ ሰና ዹጉ ህንደንደእኒፍ ብሻን ዹጋቲ ባፈቹፍ ጄዸኒ ቀርቀረ አበያ ቆተተን። ");
INSERT INTO gaze_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","ኤርገ ዋቀዮ አበያን ዸኤ ጉያን ቶርበ ደርቤ። ");
INSERT INTO gaze_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ፈረኦን ብረ ዸቂ አከነ ጄዺን፤ ‘ዋቀዮ አከነ ጄዸ፦ አከ ሰብንኮ ነ ተጃጅሉፍ ገድ ዺስ። ");
INSERT INTO gaze_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","ዮ አት ገድ እሰ ዺሱ ድዴሞ ኩኖ አን ብየኬ ጉቱት ዸእቸ ፈቴ ነንኤርገ። ");
INSERT INTO gaze_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","ለግን አበያ ፈቴዻን ጉቱመ፤ እሳንስ ኦል በአኒ መነኬት፣ ድንቀ ኬት፣ ስሬ ኬት፣ መነ ሆጄቶተኬቲት፣ ሰበኬት፣ እዶ እብዳ ኬት፣ ቆዳ ቡኮኬቲትስ ነምኡ። ");
INSERT INTO gaze_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","ፈቴወን ኩኔን ስኢፊ ሰበኬ፣ ቆንዳልቶተኬ ሁንደስ ንያበቱ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አሮኒን አከነ ጄዽ፤ ‘ኡሌኬ ቀበዹቲ ሀርከኬ ቡርቃወንረት፣ ለጌኒፊ ኩሳ ብሻኒረት ኦል ካፈዹቲ አከ ፈቴወን ብየ ግብጥት ዹፈን ጎዽ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","አሮን ሀርከሳ ብሻኖተ ግብጥት ኦል ካፈቴ፤ ፈቴወንስ ኦል በአኒ ብየ ሰነ ጉተን። ");
INSERT INTO gaze_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","ቶልፈቶትንስ ፈልፈለሳኒቲን አከሱመ ጎዸን፤ ብየ ግብጥትስ ፈቴወን ፍደን። ");
INSERT INTO gaze_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","ፈረኦንስ ሙሴፊ አሮንን ኦፍት ዋሜ፣ “አከ እን አናፊ ሰበኮራ ፈቴወን ፈጌሱፍ ዋቀዮ ከዸዻ፤ አንስ አከ ሰብንኬሰን ዸቄ ዋቀዮፍ ኣርሳ ዽኤሱፍ ገድን ዺሰ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","ሙሴንስ ፈረኦኒን፣ “አከ ፈቴወን ስኢፊ መኔንኬራ በደኒ ለገ አበያ ቆፈ ኬሰት ሀፈኒፍ ዬሮ አን እት ሲፍ፣ ቆንዳልቶተኬቲፊ ሰበኬቲፍሌ ዋቀ ከዸዹ አት ነ ቤክስስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","ፈረኦንሞ፣ “ቦር” ጄዼን። ሙሴንስ አከነ ጄዼ ዴብሴ፤ “ዋቀዮ ዋቀኬኛ ፈካቱ ከን ቶኮዩ አከ ህንጅሬ አከ ቤክቱፍ አኩመ አት ጄቱ ተአ። ");
INSERT INTO gaze_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","ፈቴወን ሱን ስኢፊ መኔንኬራ፣ ቆንዳልቶተኬቲፊ ሰበኬራ ንበዱ፤ ለገ አበያ ቆፈ ኬሰትስ ንሀፉ።” ");
INSERT INTO gaze_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","ሙሴፊ አሮን ኤርገ ፈረኦን ብራ ገድ በአኒ ቦዴ ሙሴን ዋኤ ፈቴወን ዋቅን ፈረኦንት ኤርጌ ሰና ዋቀዮት እዬ። ");
INSERT INTO gaze_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","ዋቀዮስ አኩመ ሙሴን ከዸቴ ጎዼ። ፈቴወን ሱንስ መነ ኬሰት፣ ኦብዲረት፣ ድሬረትስ ዹመን። ");
INSERT INTO gaze_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","ፈቴወን ሱንስ ወልት ቀበመኒ ቱለመን፤ ብየቲንስ ንአጆፍቴ። ");
INSERT INTO gaze_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","ፈረኦን ገሩ ዮሙ አከ ዸእች ሱን ቀበናኤ አርጌት አኩመ ዋቀዮ ዱበቴ ቱሬ ሰነ መተ ጀቤሰ ተኤ ሙሴፊ አሮንን ዸገኡ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","ኤርገሲስ ዋቀዮ ሙሴዻን፣ “አሮኒን፣ ‘ኡሌኬ ኦል ካሲቲ አዋረ ለፋ ዸእ’ ጄዽ፤ አዋር ሱንስ ብየ ግብጥ ጉቱ ኬሰት እንጅራን ተአ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","እሳንስ አከሱመ ጎዸን። ዮሙ አሮን ሀርከሳ እሰ ኡሌ ቀበቴ ኦል ካፈቴ አዋረ ለፋ ዸኤት እንጅራን ነማፊ ሆሪት ዱዴ። አዋር ጉቱ ብየ ግብጥ ኬሰ ጅሩ ሁንድ እንጅራን ተኤ። ");
INSERT INTO gaze_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","ቶልፈቶትን ገሩ ፈልፈለሳኒቲን እንጅራን ገድ ያሱ ያለኒ ደዸበን። እንጅራንስ ነማፊ ሆሪረ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","ቶልፈቶትንስ ፈረኦኒን፣ “ኩን ቁበ ዋቃት” ጄዸን። ፈረኦን ገሩ አኩመ ዋቀዮ ዱበቴ ሰነ መተ ጀቤሰ ተኤ ዸገኡ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ገነመ በሪ ከኢቲ ፉለ ፈረኦን ዱረት ዽኣዹ፤ ኩኖ እን ገረ ብሻንት ገድ በአ፤ አከነስ ጄዺን፤ ‘ዋቀዮ አከነ ጄዸ፦ አከ እን ነ ተጃጅሉፍ ሰበኮ ገድ ዺስ። ");
INSERT INTO gaze_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","ዮ አት ሰበኮ ገድ ዺሱ ድዴሞ ኩኖ፣ አን ቱተ ትሲሳ ስት፣ ቆንዳልቶተኬት፣ ሰበኬት፣ መኔንኬት ነንኤርገ። መኔን ወረ ግብጥ፣ ለፍት እሳን ጅራተንስ ትሲሳን ጉተሙ። ");
INSERT INTO gaze_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘አን ገሩ ጉያ ሰነ እዶ ሰብንኮ ጅራቱ ጎሼንን ሃለ አዳቲን ነንእላለ፤ አከ አት አከ አን ዋቀዮ ብየ ከነ ኬሰ ጅሩ ቤክቱፍ ትሲስን ቶኮዩ አች ህንጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","አን ሰበኮቲፊ ሰበኬ ግዱት ገራ ገሩማ ነንኡመ። መለቶን ኩንስ ቦር ተአ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","ዋቀዮስ አከሱመ ጎዼ። ትሲስን ባይኤን መነ ፈረኦኒፊ መኔን ቆንዳልቶተሳት ዱዴ፤ ብይ ግብጥ ጉቱንስ ትሲሳን በሌፈሜ። ");
INSERT INTO gaze_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","ፈረኦንስ ሙሴፊ አሮንን ኦፍት ዋሜ፣ “ዸቃቲ ብዩመ ከነ ኬሰት ዋቀኬሰኒፍ ኣርሳ ዽኤሳ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","ሙሴንሞ ዴብሴ አከነ ጄዼ፤ “አከስ ጎቹን ቀጄላ ህንተኡ፤ ኣርሳን ኑ ዋቀዮ ዋቀኬኛፍ ዽኤስኑ ወረ ግብጥ ብረት ጅበማዸ። ኩኖ፣ ዮ ኑ ኣርሳ ፉለሳኒ ዱረት ጅበሙ ዽኤስኔ እሳን ዸጋዻን ኑ ህንቱመኒሬ? ");
INSERT INTO gaze_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","አኩመ እን ኑ አጀጄት ኑ ዋቀዮ ዋቀኬኛፍ ኣርሳ ዽኤሱፍ ገረ ገሞጂ ከራ ጉያ ሰዲ ዴሙ ቀብነ።” ");
INSERT INTO gaze_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","ፈረኦንስ፣ “አን አከ እስን ገሞጂ ኬሰት ዋቀዮ ዋቀኬሰኒፍ ኣርሳ ዽኤስተኒፍ ገድን እስን ዺሰ፤ ገሩ ባይኤ ፈጋተን ህንዴምና። እስንስ ዋቀ ና ከዸዻ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","ሙሴንስ አከነ ጄዼ ዴብሴ፤ “ኩኖ፣ አን አኩመን ስ ብራ ዴሜን አከ ቦር ትሲስን ፈረኦንራ፣ ቆንዳልቶተሳቲፊ ሰበሳራ ከኡ ዋቀዮ ነንከዸዸ። ያ ፈረኦን አት ገሩ፣ አከ ሰብን ኩን ዋቀዮፍ ኣርሳ ዽኤሱፍ ገድ ዺሱ ድዴ አመስ ኑ ህንጎዎምስን።” ");
INSERT INTO gaze_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","ሙሴንስ ኤርገሲ ፈረኦን ብራ በኤ ዋቀዮ ከዸቴ፤ ");
INSERT INTO gaze_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","ዋቀዮስ አኩመ ሙሴን እሰ ከዸቴ ሰነ ጎዼ፤ ትሲስን ሱንስ ፈረኦንን፣ ቆንዳልቶተሳቲፊ ሰበሳ ገድ ዺሴ ዴሜ፤ ትሲስን ቶኮዩ ህንሀፍኔ። ");
INSERT INTO gaze_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","ፈረኦን ገሩ አመስ መተ ጀቤሰ ተኤ፤ ሰበ ሰነስ ገድ ዺሱ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ፈረኦን ብረ ዸቂቲ አከነ ጄዺን፤ ‘ዋቀዮ ዋቅን እብሮታ አከነ ጄዸ፤ “አከ ሰብንኮ ነ ተጃጅሉፍ ገድ ዺስ።” ");
INSERT INTO gaze_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","ዮ አት ገድ ዺሱ ድዴ እሳን ደንቅቴ፣ ");
INSERT INTO gaze_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ኩኖ ሀርክ ዋቀዮ ሆሪኬ ከኔን ድሬረ ኦለን ፈርዴን፣ ሀሮታፊ ጋለወን ኬት፣ ሎን፣ ሆሎታፊ ሬኦተኬት ዸእቸ ሀማ ንፍደ። ");
INSERT INTO gaze_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","ዋቀዮ ገሩ አከ ሆሪን ሰበ እስራኤል ቶኮዩ ህንዱኔፍ ሆሪ እስራኤሊፊ ሆሪ ወረ ግብጥ ግዱት ገራ ገሩማ ንኡመ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","ዋቀዮ ዬሮ ሙርቴሴ፣ “ዋቀዮ ቦር ዋን ከነ ብየቲ ኬሰት ንሆጄተ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","ዋቀዮስ ጉያ እት ኣኑት ዋን ከነ ሆጄቴ፦ ሆሪን ወረ ግብጥ ሁንድ ንዹሜ፤ ሆሪ ወረ እስራኤል ኬሳ ገሩ ቶኮዩ ህንዱኔ። ");
INSERT INTO gaze_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","ፈረኦንስ ነሞተ ቆረተን ኤርጌ፣ ኩኖ አከ ሆሪ ሰበ እስራኤል ኬሳ ቶኮሌ ህንዱእን ቤኬ። ተኡስ ፈረኦን መተ ጀቤሰ ተኤ ሰበ ሰነ ገድ ዺሱ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","ዋቀዮሞ ሙሴፊ አሮኒን አከነ ጄዼ፤ “ዳራ ሀርከ ጉቱ እዶ እብዳቲ ሀማራ፤ ሙሴንስ ዳራ ሰነ ፉለ ፈረኦን ዱረት ሰሚት ኦል ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","እንስ ብየ ግብጥ ጉቱ ኬሰት አዋረ ተአ፤ ዹላን መላ ያሱ ነማፊ ሆሪ ጉቱ ብየቲ ኬሰ ጅረንት ያአ።” ");
INSERT INTO gaze_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","እሳን ቦለ እብዳራ ዳራ ሀማረተኒ ፉለ ፈረኦን ዱረ ዻበተን። ሙሴንስ ዳራ ሰነ ሰሚት ኦል ፈጫሴ፤ ዹላን መላ ያሱስ ነማፊ ሆሪት ያኤ። ");
INSERT INTO gaze_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","ቶልፈቶትንስ ሰበቢ ዹላቲፍ ሙሴ ዱረ ዻበቹ ህንደንዴኜ፤ ዹላን ቶልፈቶታፊ ወረ ግብጥ ሁንደት ያኤ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","ገሩ ዋቀዮ አኩመ ሙሴት ህሜ ሰነ ዋቀዮ ፈረኦንን መተ ጀቤሰ ጎዼ፤ እንስ ሙሴፊ አሮንን ዸገኡ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ገነመ በሪ ከኢቲ ፉለ ፈረኦን ዱረ ዻበዹ፤ አከነስ ጄዺን፤ ‘ዋቀዮ ዋቅን እብሮታ አከነ ጄዸ፤ አከ ሰብንኮ ነ ተጃጅሉፍ ገድ ዺስ፤ ");
INSERT INTO gaze_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","ዮ ከና አቺ አን አመ ዸእቸኮ ሁንደ ስት፣ ቆንዳልቶተኬቲፊ ሰበኬት ነንኤርገ፤ ኩንስ አከ አት አከ ዋቅን አከኮ ለፈ ሁንደረ ህንጅሬ ቤክቱፍ። ");
INSERT INTO gaze_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","ስላ አመ አን ሀርከኮ ኦል ፉዸዼ ስኢፊ ሰበኬ ዹኩበ ሀማን ዸኡ ነንደንደአ ቱሬ፤ አትስ ለፈራ በደ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","አን ገሩ ሁምነኮ ስረት አርግሲሱፊ አከ መቃንኮ ለፈ ሁንደረት ለብሰሙፍ ጄዼን ካዮ ከናፍ ስ ጅራችሴ። ");
INSERT INTO gaze_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","አት አመዩ ሰበኮረት ኦል ኦል ኦፍ ቀብደ፤ ጀረስ ገድ ህንዺፍቱ። ");
INSERT INTO gaze_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","ኩኖ አን ቦር ዬሮ አከናት ጨቢ ሀማ ኤርገ ግብጥ ሁንዴፈምቴ ጀልቀቤ ሀመ አማት ተኩማ ግብጥት ህንቡእን ቶኮ ነንቡሰ። ");
INSERT INTO gaze_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","ኤጋ አመ ነመ ኤርጊቲ ሆሪኬቲፊ ዋን አላ ቀብዱ ሁንደ መነት ገልችሲስ፤ ጨቢን ሱንስ ነማፊ ሆሪ መነት ህንገልን ከኔን አለት ሀፈን ሁንደት ንቡአ፤ እሳንስ ንዹሙ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","ቆንዳልቶተ ፈረኦን ኬሳ ወር ዱቢ ዋቀዮ ሶዳተን ገርቦተሳኒቲፊ ሆሪሳኒ መነት ገልፈቹፍ አሪፈተኒ ሶከን። ");
INSERT INTO gaze_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","ወር ዱቢ ዋቀዮቲፍ ጥዬፈኖ ህንኬንንሞ ገርቦተሳኒቲፊ ሆሪሳኒ አለት ዺሰን። ");
INSERT INTO gaze_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","ዋቀዮ ሙሴዻን፣ “አከ ጨቢን ብየ ግብጥ ሁንደት ነመት፣ ሆሪፊ ብቅልቱ ለፈ ቆቲሳ ግብጥ ሁንደረት ቡኡፍ ሀርከኬ ገረ ሰሚት ድሪርስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","ዮሙ ሙሴን ኡሌሳ ገረ ሰሚት ድሪርሴትስ ዋቀዮ ከከዌፊ ጨቢ ኤርጌ፤ እብድስ ገረ ለፋት ገድ ቡኤ። ዋቀዮስ ብየ ግብጥት ጨቢ ሮብሴ፤ ");
INSERT INTO gaze_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","ጨቢን ንቡኤ፤ እብድስ ጨቢ ወጅን ወል መኬ። ጨቢን ሀማን አከና ኤርገ ግብጥ ሰበ ታቴ ቤከምቴ አስ ተኩማ ጉቱ ብየቲት ህንቡኔ። ");
INSERT INTO gaze_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","ጨቢን ሱንስ ብየ ግብጥ ኬሰት ዋን አለ ጅሩ ሁንደ ነመስ ሆሪስ ንዸኤ፤ ብቅልቱ ለፈ ቆቲሳ ሁንደስ ንበሌሴ፤ ሙከ ሁንደስ ንበርበዴሴ። ");
INSERT INTO gaze_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","ለፍት ጨቢን እት ህንቡእን ብየ ጎሼን እዶ እስራኤሎትን ጅራተን ቆፈ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","ፈረኦንስ ሙሴፊ አሮንን ኦፍት ዋሜ አከነ ጄዼን፤ “አን አመ ጩቡ ሆጄዼረ፤ ዋቀዮ ቀጄላዸ፤ አኒፊ ሰብንኮ ገሩ በሌሳ ሆጄትኔረ። ");
INSERT INTO gaze_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","ሰበቢ በከካፊ ጨቢን ኑት ባይአቴፍ እስን ዋቀዮን ኑፍ ከዸዻ። አንስ ገድ እስን ነንዺሰ፤ እስን ሀመነ ጫላ አስ ቱሩ ህንቀብደን።” ");
INSERT INTO gaze_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","ሙሴንስ አከነ ጄዼ ዴብሴ፤ “አን ዮሙ መጋላ ከነ ኬሳ በኡት ሀርከኮ በልእሴ ዋቀዮ ነንከዸዸ። በከካን ንዾወመ፤ ጨቢንስ ስአች ህንጅራቱ፤ ከናንስ አት አከ ለፍት ከን ዋቀዮ ታቴ ንቤክተ። ");
INSERT INTO gaze_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","አን ገሩ አከ አቲፊ ቆንዳልቶትንኬ አመዩ ዋቀዮ ዋቀ ህንሶዳትኔ ነንቤከ።” ");
INSERT INTO gaze_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","ዋን ተልባን ደራሬ፣ ገርቡንሞ ብልቻቴ ቱሬፍ ተልባፊ ገርቡን ንበደን። ");
INSERT INTO gaze_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","ቀመዲፊ ሆንቦሪን ገሩ ዋን ቱረኒ ብልቻተኒፍ ህንበድኔ። ");
INSERT INTO gaze_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","ሙሴንስ ፈረኦን ብራ ዴሜ መጋላ ኬሳ ገድ በኤ፤ እንስ ሀርከሳ ገረ ዋቀዮት በልእሴ፤ በከካፊ ጨቢን ንዾወመን። ቦካንስ ዴብኤ ብየቲት ህንሮብኔ። ");
INSERT INTO gaze_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","ፈረኦንስ ዮሙ አከ ቦካን፣ ጨቢፊ በከካን ዾወመን አርጌት አመስ ጩቡ ሆጄቴ፤ እኒፊ ቆንዳልቶትንሳ መተ ጀቤዪ ተአን። ");
INSERT INTO gaze_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","አኩመ ዋቀዮ ከራ ሙሴቲን ዱበቴ ሰነ፣ ፈረኦን መተ ጀቤሰ ተኤ፤ ሰበ እስራኤልስ ገድ ዺሱ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ “ፈረኦንት ኦል ሴን፤ አን አከ መለቶወንኮ ከኔን እሳን ግዱት ሆጄዹፍ ጄዼ ፈረኦኒፊ ቆንዳልቶተሳ መተ ጀቤዪ ጎዼረ፤ ");
INSERT INTO gaze_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","ኩንስ አከ አት ዋን አን ወረ ግብጥ ጎዼ፣ መለቶ አን እሳን ግዱት አርግሲሴስ እጆሌኬቲፊ እጆሌ እጆሌኬቲት ህምቴ አከ አን ዋቀዮ ተኤ አከ ቤክተኒፍ ተኤ።” ");
INSERT INTO gaze_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","ሙሴፊ አሮንስ ፈረኦን ብረ ዸቀኒ አከነ ጄዸኒን፤ “ዋቀዮ ዋቅን እብሮታ አከነ ጄዸ፦ ‘አት ሀመ ዮሚት ፉለኮ ዱረት ገድ ኦፍ ቀቡ ድደ? አከ እሳን ነ ተጃጅለኒፍ ሰበኮ ገድ ዺስ። ");
INSERT INTO gaze_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","ዮ አት ገድ እሳን ዺሱ ድዴ፣ ኩኖ አን ቦር ብየኬት ሀዋንሰ ነንፍደ። ");
INSERT INTO gaze_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","ሀዋንስን ኩንስ ሀመ ነምን ቶኮዩ አርጉ ደዸቡት ለፈ ሀጉገ። እንስ ዋኑመ ጨቢራ እስኒ ሀፌሌ ንፍጠ፤ ሙኬን አለት እስኒ ጉደቻ ጅረንስ ኛቴ ፍጠ። ");
INSERT INTO gaze_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","እን መነኬ፣ መነ ቆንዳልቶተኬቲ ሁንዳፊ መነ ወረ ግብጥ ሁንዱማ ጉተ፤ ኩንስ ዋን አቦቲንኬቲፊ አቦቲን አቦቲኬቲ ጋፈ ብየ ከነ ቁበተኒ ጀልቀበኒ ሀመ ሀርኣት ህንአርግኒዸ።’ ” ከነ ቦዴ ሙሴን ገረገሌ ፈረኦን ብራ በኤ። ");
INSERT INTO gaze_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","ቆንዳልቶትን ፈረኦንስ፣ “ነምች ኩን ሀመ ዮሚት ክዮ ኑት ተአ? ነሞትን ኩን አከ ዋቀዮ ዋቀሳኒ ተጃጅለኒፍ ገድ ዺስ። አከ ግብጥ በዴ አት አመሌ ህንሁበትኔ?” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","ሙሴፊ አሮንን ዴብሰኒ ፈረኦንት ጌሰን፤ ፈረኦንስ፣ “ዸቃቲ ዋቀዮ ዋቀኬሰን ዋቄፈዻ! ገሩ ኤኙቱ ዴመ?” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","ሙሴንስ፣ “ኑ ሰበቢ አያነ ዋቀዮ አያኔፈትኑፍ ደርገጎተኬኛፊ ማንጉዶተኬኘ፣ እልማኒፊ እንተለንኬኘ፣ ቡሻዬፊ ሎንኬኘ ቀበትኔ ዴምነ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","ፈረኦንስ አከነ ጄዼ፤ “ዮ አን ዱበርቶተኬሰኒፊ እጆሌኬሰን እስን ወጅን ገድ ዺሴ፣ ሜ ዋቀዮ እስን ወጅን ሃተኡ! ኩኖ ዋን ሀማቱ እስን ዱረ ጅረ። ");
INSERT INTO gaze_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","ኩን ህንተኡ! አከ ወር ዺራ ቆፍት ዸቀኒ ዋቀዮ ዋቄፈተን ጎዻ፤ እስን ከኑመ በርባደኒቲ።” እሳንስ ፉለ ፈረኦን ዱራ ገድ ባፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","ዋቀዮስ ሙሴዻን፣ “አከ ሀዋንስን ብየ ግብጥት ቡኤ ብቅልቱ ለፈ ቆቲሳ ሁንደ፣ ዋን ጨቢራ ሀፌ ሁንደስ ኛቱፍ ሀርከኬ ግብጥረት ድሪርስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","ሙሴንስ ኡሌሳ ግብጥረት ድሪርስናን ዋቀዮ ጉያ ሰነ ጉቱፊ ሀልከን ሰነ ጉቱ አከ ቡቤን በአ ቢፍቱ ብየቲ ኬሰት ቡብሱ ጎዼ፤ ገነመ እት ኣኑስ ቡቤን ሱን ሀዋንሰ ፍዴ ዹፌ፤ ");
INSERT INTO gaze_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","ሀዋንስን ሱንስ ግብጥ ጉቱ ዌረሬ፤ ብየ ሁንደ ኬሰስ ባይእናን ቁበቴ። ዸእች ሀዋንሳ ከን አከሲ ዱራን ተኩማ ቡኤ ህንቤኩ፤ ኤርገሲስ ተኩማ ዴብኤ ህንቡኔ። ");
INSERT INTO gaze_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","ሀዋንስን ሱንስ ሀመ ለፍት ጉራቸኡት ለፈ ሁንደ ሀጉጌ፤ እንስ ዋን ጨቢራ ሀፌ ሁንደ፣ ዋን አለት ብቅሌ ሁንደ፣ እጀ ሙካሌ ንኛቴ። ብየ ግብጥ ሁንደ ኬሰት ወን ለልሳን ቶኮዩ ሙከረት ዮካን ብቅልቱረት ህንሀፍኔ። ");
INSERT INTO gaze_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","ፈረኦንስ ደፌ ሙሴፊ አሮንን ዋሜ አከነ ጄዼን፤ “አን ዋቀዮ ዋቀኬሰኒፊ እስንት ጩቡ ሆጄዼረ። ");
INSERT INTO gaze_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","ኤጋ ሜ ጩቡኮ ና ዺሳ፤ አከ እን ዸእቸ ነመ አጄሱ ከነ ነራ ፉዹፍስ ዋቀዮ ዋቀኬሰን ና ከዸዻ።” ");
INSERT INTO gaze_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","ሙሴንስ ፈረኦን ብራ ገድ በኤ ዋቀዮ ከዸቴ። ");
INSERT INTO gaze_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","ዋቀዮስ ቡቤ ሰነ ገረ ቡቤ ልጠ ቢፍቱ ጀባት ጌደሬ፤ ቡቤን ሱንስ ሀዋንሰ ሰነ ፉዼ ገላነ ዲማት ነቄ። ግብጥ ኬሰት ሀዋንስን ቶኮዩ ህንሀፍኔ። ");
INSERT INTO gaze_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","ዋቀዮ ገሩ ፈረኦንን መተ ጀቤሰ ጎዼ፤ ፈረኦንስ እስራኤሎተ ገድ ህንዺፍኔ። ");
INSERT INTO gaze_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","ዋቀዮሞ ሙሴዻን፣ “አከ ዱከን ግብጥረ ቡኡፍ ሀርከኬ ገረ ሰሚት ድሪርስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","ሙሴን ሀርከሳ ገረ ሰሚት ድሪርሴ፤ ዱከን ልምጢንሳ ጉያ ሰዲ ግብጥ ጉቱ ሀጉጌ። ");
INSERT INTO gaze_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","ጉያ ሰደን ሰነ ነምን ወል ህንአርጉ ቱሬ፤ ለፈ ጅሩስ ህንሶቾኡ ቱሬ። እስራኤሎትን ሁንድ ገሩ እዶ ጅራተንት እፈ ቀቡ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","ፈረኦንስ ሙሴ ኦፍት ዋሜ፣ “ዸቃቲ ዋቀዮ ዋቄፈዻ። ዱበርቶትኒፊ እጆሌንኬሰንስ እስን ወጅን ሃዴመን፤ ቡሻዬፊ ሎንኬሰን ቆፈ ዺሳ ዴማ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","ሙሴን ገሩ አከነ ጄዼ፤ “አት አከ ኑ ዋቀዮ ዋቀኬኛፍ ኣርሳፊ ቀልመ ጉበሙ ዽኤስኑፍ ኑ ኤየሙ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","ሆሪንኬኘስ ኑ ወጅን ዸቁ ቀበ፤ ኮቴን ቶኮዩ ህንሀፉ። ዋቀዮ ዋቀኬኘ ዋቄፈቹፍ እሳን ኬሳ ቶኮ ቶኮት ፈየደምነ፤ ሀመ አች ጌኙት ዋቀዮ ዋቄፈቹፍ ማልት አከ ፈየደምኑ ህንቤክኑ።” ");
INSERT INTO gaze_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","ዋቀዮ ገሩ ፈረኦንን መተ ጀቤሰ ጎዼ፤ እንስ ገድ እሳን ዺሱ ድዴ። ");
INSERT INTO gaze_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","ፈረኦንስ ሙሴዻን፣ “ፉለኮ ዱራ በድ! ለመተ ፉለኮ አከ ህንአርግኔ ቤከዹ፤ አት ጋፈ ፉለኮ አርግቴ ንዱተ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","ሙሴንስ ዴብሴ፣ “አኩመ አት ጄቴ፣ አን ለመተ ፉለኬት ህንሙልአዹ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አን አመሌ ዸእቸ ቶኮ ፈረኦኒፊ ግብጥት ነንፍደ። ኤርገሲ እን አሲ እስን ባሰ፤ ዬሮ አሲ እስን ባሱትሞ እን ጉቱማን ጉቱት እስን አርአ። ");
INSERT INTO gaze_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","አከ ቶኮን ቶኮን ዺራቲፊ ቶኮን ቶኮን ዱበርቲ ኦላሳኒራ ምአ ሜቲቲፊ ምአ ወርቄ ኤርግፈተን ሰበ ከነት ህም።” ");
INSERT INTO gaze_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","ዋቀዮ አከ ሰብን እስራኤል ፉለ ወረ ግብጥ ዱረት ሱራ አርገተን ጎዼ፤ ከነ መሌስ ሙሴን ብየ ግብጥ ኬሰት፣ ፉለ ቆንዳልቶተ ፈረኦኒቲፊ ፉለ ሰበ ግብጥ ዱረት አከ መሌ ኡልፍነ ቀቤሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","ሙሴን አከነ ጄዼ፤ “ዋቀዮ አከነ ጄዸ፤ ‘አን ገረ ሀልከን ወለካት ግብጥ ሁንደ ኬሰ ነንደርበ። ");
INSERT INTO gaze_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","እልመ ፈረኦን ነምቸ ቴሶረ ታኡ ሰና ሀንገፋ ጀልቀቤ ሀመ እልመ ጦምቦሬሼ ምዻን ዳክቱ ሰና ሀንገፋት እልም ሀንገፍን ብየ ግብጥ ኬሳ ሁንድ ንዱአ፤ አከሱመስ ሀንገፍን ሆሪ ሁንድ ንዱአ። ");
INSERT INTO gaze_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","ብየ ግብጥ ጉቱ ኬሰትስ ወዋቹ ጉዳን ተኩማ ዸገአሜ ህንቤክን ዮካን ዴብኤስ ህንዸገአምኔ ቶኮ ንዹፈ። ");
INSERT INTO gaze_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","ገሩ ሰበ እስራኤል ኬሳ ነመ ቶኮትዩ ዮካን ሆሪ ቶኮትዩ ሰሬን ቶኮዩ ህንዱቱ።’ እስንስ ዋን ከናን አከ ዋቀዮ ግብጢፊ እስራኤል ግዱት ገራ ገሩማ ፍዱ ንቤክቱ። ");
INSERT INTO gaze_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","ቆንዳልቶትንኬ ኩኔን ሁንድኑ ገረኮ ዹፈኒ ና ሰገደን፤ ‘አትስ፣ ነሞትን ስ ዱካ ቡአን ሁንድኑስ ዴማ!’ ጄዹ፤ አንስ ኤርገሲ ነንዴመ።” ሙሴንስ አከ መሌ ኣሬ ፈረኦን ብራ በኤ። ");
INSERT INTO gaze_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","ዋቀዮ ሙሴዻን፣ “አከ ድንቂንኮ ብየ ግብጥት ባይአቱፍ ፈረኦን እስን ዸገኡ ድደ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","ሙሴፊ አሮንስ ድንቂወን ከኔን ሁንደ ፉለ ፈረኦን ዱረት ሆጄተን፤ ዋቀዮ ገሩ ፈረኦንን መተ ጀቤሰ ጎዼ፤ እንስ አከ እስራኤሎን ብየሳ ኬሳ ህንባኔ ዾዌ። ");
INSERT INTO gaze_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","ዋቀዮስ ብየ ግብጥ ኬሰት ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“ጅእ ኩን ጅአ ጀልቀባ እስኒ ሃተኡ፤ እንስ ወጋ ኬሳ ጅአ ጀልቀባ እስኒ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","ጅአ ከነ ኬሰ ቡልቲ ኩርነፋት ቶኮን ቶኮን ነማ ጦባላ ሆላ ቶኮ አኩመ መኔን አቦቲሳኒት ቶኮ ቶኮ መናቲፊ ጦባላ ሆላ ቶኮ አከ ፉዸቱ ጉቱማ ሀዋሰ እስራኤልት ህማ። ");
INSERT INTO gaze_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","ዮ ወር መነ ቶኮ ጅራተን ሙራሰ ተአኒ ሆላ ቶኮ ጉቱማት ፍጡ ባተን፣ እሳን አኩመ ባይእነ ነሞተ አች ጅራተኒት ኦላ እሳንት ኣኑ ወጅን ሃቆደተን። እስንስ አኩመ ዋን ቶኮን ቶኮን ነማ ኛቹ ደንደኡት ጦባላ ሆላ ሀመም አከ በርባችሱ ሙርቴሱ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","ጦባላንኬሰን እልሞ ሆላ ወጋ ቶኮ ከን ሙዳ ህንቀብኔ ተኡ ቀበ፤ ጦባላ ሰነስ ሆሎተ ኬሳ ዮካን ሬኦተ ኬሳ ፉዸቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","ጦባላ ሰነስ ሀመ ቡልቲ ኩዸ አፉረፋ ጅአ ከናት ኤጋ፤ ያኢን ወልዳ እስራኤል ጉቱንስ ገልገለ ሰነ ጦባላ ሰነ ሃቀለቱ። ");
INSERT INTO gaze_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","ኤርገሲሞ ዺገ ሰነራ ጥኖ ፉዸኒ ምችችለ በልበላ ለማኒፊ ቡሳ በልበላ እሰ ኦል ኣኑ ከን መነ እት ጦባላ ሰነ ኛተኒ ሃድበን። ");
INSERT INTO gaze_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","እሳንስ ሀልከኑመ ሰነ ፎን ሰነ እብዳን ዋደተኒ ብቅልቱ ሀዾፍቱፊ መጥኖን ሃኛተን። ");
INSERT INTO gaze_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","እብዳን ዋደዻቲ ኛዻ መሌ ፎን ዼዺ ዮካን ከን ብሻኒን አፌለሜ ህንኛትና፤ መታሳ፣ ሉካፊ ምአ ገራ ወጅን ዋደዻቲ ኛዻ። ");
INSERT INTO gaze_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","ሀመ ለፍት በሪቱት ሆማ ህንሀምብስና፤ ዋን ሀመ ገነማት እራ ሀፉ ገሩ ጉባ። ");
INSERT INTO gaze_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","ሃል እስን እት ኛተንስ ኩኖት፤ ሙዺኬሰን ህዸዻ፤ ኮጴኬሰን ሚለት ካአዻ፤ ኡሌኬሰንሌ ሀርከት ቀበዻቲ ጀርጀርሱን ኛዻ፤ እን ፋሲካ ዋቀዮት። ");
INSERT INTO gaze_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“አንስ ሀልከኑመ ሰነ ግብጥ ኬሰ ነንደርበ፤ ሀንገፈ ግብጥስ ነማፊ ሆሪ ነንዸአ፤ ዋቆተ ግብጥ ሁንደትስ ነንሙረ፤ አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","ዺግን ሱንስ መኔን እስን ኬሰ ጅራተንረት መለቶ እስኒ ተአ፤ አን ዮሙን ዺገ ሰነ አርጉት እስንረ ነንደርበ። ዬሮ አን ብየ ግብጥ ዸኡትስ ዸእች በዲሳ ቶኮዩ እስን ህንቱቁ። ");
INSERT INTO gaze_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“ጉያን ኩን ጉያ ያደኖ እስኒፍ ሃተኡ፤ አከ አያናት ዋቀዮፍ ንአያኔፈቱ፤ ዸሎተኬሰን ሁንደ ኬሰትስ ስርነ በረ በራ ጎዸተኒ ንኤግዱ። ");
INSERT INTO gaze_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","እስን ቡልቲ ቶርበ መጥኖ ኛቹ ቀብዱ፤ ጉያ ጀልቀባት መነኬሰኒ ራጭቲ ባሳ ገታ፤ ነምን ከምዩ ጉያ ጀልቀባቲ ካሴ ሀመ ጉያ ቶርበፋት ዮ ቡዴነ ቡካኤ ኛቴ ሰበ እስራኤል ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","ጉያ ጀልቀባት ወል ገኢ ቁልቁሉ ቀባዻ፤ ወል ገኢ ቁልቁሉ ብራሞ ጉያ ቶርበፋት ቀባዻ። ዋን ነምን ሁንድ ኛቱ ቆጴሱ መሌ ጉዮተ ከኔን ሆጂ ቶኮዩ ህንሆጄትና፤ ወን እስን ሆጄቹ ደንዴሰን ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“ሰበቢ ጉያን አን እት ራያኬሰን ግብጥ ኬሳ ባሴ ጉዩመ ከነ ተኤፍ አያነ መጥኖ ከነ አያኔፈዻ፤ ጉያ ከነስ ስርነ በረ በራ ጎዸዻቲ ዸሎተኬሰን ሁንደ ኬሰት አያኔፈዻ። ");
INSERT INTO gaze_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","እስን ጅአ ጀልቀባ ኬሰ ገልገለ ቡልቲ ኩዸ አፉረፋዻ ሀመ ገልገለ ጉያ ድግደሚ ቶኮፋት መጥኖ ኛቱ። ");
INSERT INTO gaze_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","ቡልቲ ቶርባፍ ራጭቲን ቶኮሌ መነኬሰንት ህንአርገምን፤ አለጋስ ተኡ ዸለታን ብያ፣ ነምን ዋን ራጭቲ ቀቡ ኛቱ ከምዩ ወልዳ እስራኤል ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","ዋን ራጭቲ ቀቡ ቶኮሌ ህንኛትና፤ ለፈ ጅራተን ሁንደት መጥኖ ኛዻ።” ");
INSERT INTO gaze_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","ሙሴን ማንጉዶተ እስራኤል ሁንደ ኦፍት ዋሜ አከነ ጄዼን፤ “ዸቃቲ ማቲኬሰኒፍ ጦባላ ፍለዻቲ ፋሲካ ቀላ። ");
INSERT INTO gaze_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","ሂሶጲ ቀባ ቶኮ ፉዻ፤ ዺገ ወጪቲ ኬሰ ጅሩ ሰነ ኬሰ ጩጳቲ ምችችለ በልበላ ለማኒፊ ቡሳ በልበላ እሰ ኦል ኣኑ ድባ። እስን ኬሳ ነምን ቶኮዩ ሀመ ለፍት በሪቱት በልበለ መነ ኦፊሳቲ ገድ ህንበእን። ");
INSERT INTO gaze_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","ዋቀዮ ዬሮ ወረ ግብጥ ዸኡፍ ብየቲ ኬሰ ደርቡት ምችችለ በልበላ ለማንረቲፊ ቡሳ በልበላ እሰ ኦል ኣኑረት ዺገ ሰነ አርጌ በልበለ ሰነ ብረ ደርበ፤ አከ እን ዋ በሌሱ ሱን መነኬሰን ሴኔ እስን አጄሱስ ህንኤየሙፍ። ");
INSERT INTO gaze_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“እስንስ ቀጄልፈመ ከነ አከ ሴረ በረ በራ ከን እስኒፊ ሰኚኬሰኒፍ ኬነሜት ከበጃ። ");
INSERT INTO gaze_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","እስንስ ዬሮ ብየ ዋቀዮ አኩመ ዋዳ ገሌ ሰነት እስኒ ኬኑ ሴንተንት ስርነ ከነ ኤጋ። ");
INSERT INTO gaze_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","ዮሙ እጆሌንኬሰን፣ ‘ስርን ኩን እስኒፍ ሂካ ማሊ ቀበ?’ ጄዸኒ እስን ጋፈተንት፣ ");
INSERT INTO gaze_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","አከነ ጄዻ እሳንት ህማ፤ ‘ኩን ቀልመ ፋሲካ ዋቀዮት፤ እን ዬሮ ወረ ግብጥ ዸኤት መኔን እስራኤሎተ ግብጥ ኬሰ ቱረን ሰናረ ደርቤ መኔንኬኘ ኑፍ ኦልቼራቲ።’ ” ከነረት ነሞትን ገድ ጄዸኒ ዋቄፈተን። ");
INSERT INTO gaze_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","እስራኤሎንስ አኩመ ዋቀዮ ሙሴፊ አሮንን አጀጄ ሰነ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","ሀልከን ወለካት ዋቀዮ እልመ ፈረኦን ነምቸ ቴሶረ ታኡ ሀንገፋ ጀልቀቤ ሀመ እልመ ነምቸ ቦለ መነ ህዻ ኬሰ ጅሩ ሀንገፋት ሀንገፎተ ግብጥ ሁንደ ዸኤ፤ ሀንገፎተ ሆሪስ አከሱመ ዸኤ። ");
INSERT INTO gaze_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","ፈረኦኒፊ ቆንዳልቶትንሳ ሁንድ፣ ወር ግብጥ ሁንድስ ሀልከኒን ከአን፤ ሰበቢ መን ነምን ኬሳ ህንዱእን ቶኮዩ ህንቱርኒፍ ቦእቸ ጉዳቱ ግብጥ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","ፈረኦንስ ሀልከን ሰናን ሙሴፊ አሮንን ኦፍት ዋሜ አከነ ጄዼ፤ “ከኣ! እስኒፊ እስራኤሎን ሰበኮ ኬሳ በኣ! አኩመ ጋፈተን ሰነ ዸቃቲ ዋቀዮን ዋቄፈዻ። ");
INSERT INTO gaze_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","አኩመ ጄተን ሰነ ቡሻዬፊ ሎንኬሰን ፉዸዻቲ ዴማ፤ አነስ ኤብሳ።” ");
INSERT INTO gaze_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","ወር ግብጥስ አከ ሰብን ሱን ደፌ ብየ ሰና በኡ ጀርጀርሰን፤ እሳንስ፣ “ዮ ከና አቺ ኑ ሁንድ ንዹምና” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","ከናፉ ሰብን ሱን ቡኮሳኒ ኡቱ ህንቡካእን ፉዸተኒ፣ ቆዳ ቡኮሳኒስ ወያሳኒቲን መረኒ ገቲቲት ባዸተን። ");
INSERT INTO gaze_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","እስራኤሎንስ አኩመ ሙሴን እሳንት ህሜ ሰነ ጎዸን፤ እሳንስ ምአ ሜቲቲፊ ወርቄ፣ ወያስ ወረ ግብጥ ጋፈተን። ");
INSERT INTO gaze_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","ሰበቢ ዋቀዮ ፉለ ወረ ግብጥ ዱረት እስራኤሎታፍ ሱራ ኬኔፍ፣ ወር ግብጥ ዋን እሳን ጋፈተን ሁንደ ኬነኒፍ፤ እሳንስ አከሲን ቀቤኘ ወረ ግብጥ ቦጅአኒ በአን። ");
INSERT INTO gaze_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","እስራኤሎንስ ራምሴዻ ከአኒ ሱኮትት ቀጄለን። እሳንስ ነዼኒፊ እጆሌ መሌ ነሞተ ለፎ ገረ ኩመ ዽበ ጀአ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","ኡመትን ወልት መከሜ ሄዱን፣ አከሱመስ ሆሪን ጄቹንስ ቡሻዬፊ ሎን ባይኤን እሳን ወጅን በአን። ");
INSERT INTO gaze_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","እሳንስ ቡኮ ግብጥ ፉዸተኒ ዹፈን ሰነራ መጥኖ ቶልፈተን። ሰበቢ እሳን ጀርጀርሱዻን ግብጥ ኬሳ ባፈመኒ ዬሮ እት ኛተ ቆጴፈተንሌ ዸበኒፍ ቡኮን ሱን ራጭቲ ህንቀቡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","በር እስራኤሎን ግብጥ ኬሰ ጅራተን ወጋ 430 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","ዹመ ወጋ 430 ሰናት ጉዩመ ሰነ ራያን ዋቀዮ ሁንድ ብየ ግብጢቲ በኤ። ");
INSERT INTO gaze_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","ዋቀዮ ግብጥ ኬሳ እሳን ባሱዻፍ ደመቄ ሀልከን ሰነ ዋን እሳን ኤጌፍ፣ ሀልከን ኩን እስራኤሎተ ሁንዱማፍ ሀልከን እት ዋቀዮፍ ኡልፍነ ኬኑዻፍ ደመቀኒ ኤገኒዸ። ");
INSERT INTO gaze_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","ዋቀዮስ ሙሴፊ አሮኒን አከነ ጄዼ፤ “ሴር ፋሲካ ከናዸ፦ “ኦርም ቶኮዩ እሰራ ህንኛትን። ");
INSERT INTO gaze_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","ገርብች ብተሜ ከምዩ ኤርገ ዸግነ ቀብደኒ ቦዴ ሃኛቱ፤ ");
INSERT INTO gaze_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","ኬሱማን ዮካን ነምን ሆጄታን ቀጨረሜ ገሩ ህንኛትን። ");
INSERT INTO gaze_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“ሆላን ሱን መኑመ ቶኮ ኬሰት ሃኛተሙ፤ ፎንሳ ቶኮዩ መና ገድ ህንባስና። ለፌሳ ኬሳስ ቶኮዩ ህንጨብስና። ");
INSERT INTO gaze_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","ወልዳን እስራኤል ሁንድስ አያነ ከነ ሃአያኔፈቱ። ");
INSERT INTO gaze_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“ኦርም እስን ወጅን ጅራቱ ዮ ፋሲካ ዋቀዮ አያኔሱ በርባዴ እን ዺሮተ መነሳ ጅራተን ሁንደ ዸግነ ሃቀቡ፤ ኤርገሲስ አኩመ ዸለታ ብያት አያንቸ ሃአያኔሱ። ዺር ዸግነ ህንቀበትን ቶኮዩ ገሩ ሆላ ሰነ ህንኛትን። ");
INSERT INTO gaze_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","ዸለታ ብያቲፍስ ተኡ ኦርመ እስን ግዱ ጅራቱፍ ሴር ቶኩመ።” ");
INSERT INTO gaze_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","እስራኤሎን ሁንድስ አኩመ ዋቀዮ ሙሴፊ አሮንን አጀጄ ሰነ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","ዋቀዮስ ጋፉመ ሰነ ኩታ ኩታሳኒቲን እስራኤሎተ ብየ ግብጥ ኬሳ ባሴ። ");
INSERT INTO gaze_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“ዺረ ሀንገፈ ሁንደ አዳን ና ባስ፤ እስራኤሎተ ኬሳ ነመስ ተኡ ሆሪን ሀንገፍን ገደሜሰ በኑ ከምዩ ከንኮት።” ");
INSERT INTO gaze_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","ዮሙስ ሙሴን ኡመታን አከነ ጄዼ፤ “ሰበቢ ዋቀዮ እሬ ጀባዻን አቺ እስን ባሴፍ ጉያ እት መነ ገርቡማቲ ግብጥ ኬሳ ባተን ከነ ያደዻ። ዋን ራጭቲ ቀቡ ቶኮሌ ህንኛትና። ");
INSERT INTO gaze_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","እስን ጅአ አቢቢ ኬሰ ጉያ ሀርኣ ባተን። ");
INSERT INTO gaze_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","ዬሮ ዋቀዮ ገረ ብየ ከነኣኖታ፣ ሄቶታ፣ አሞሮታ፣ ብየ ሂዎታፊ ዬቡሶታት ጄቹንስ ብየ ኣነኒፊ ደመ ባሱ ከን እን አከ ሲፍ ኬኑ አቦቲኬቲፍ ከከቴ ሰነት ስ ገልቹት አት ጅአ ከነ ኬሰ አያነ ከነ አያኔፈተ፤ ");
INSERT INTO gaze_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","አት ቡልቲ ቶርበ መጥኖ ኛተ፤ ጉያ ቶርበፋትሞ አያነ ዋቀዮ ተአ። ");
INSERT INTO gaze_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","ጉያ ቶርበን ሰነ መጥኖ ኛዹ፤ ወን ራጭቲ ቀቡ ቶኮዩ ስ ብረት ህንአርገምን፤ ዳንጋኬ ሁንደ ኬሰትስ ራጭቲን ህንአርገምን። ");
INSERT INTO gaze_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","ጋፈስ፣ ‘አን ዋን ዋቀዮ ዬሮ አን ግብጥ ኬሳ በኤት ና ጎዼ ሰናፍ ጄዼ ዋን ከነ ጎዸ’ ጄዺቲ እልመኬት ህም። ");
INSERT INTO gaze_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","ስርን ኩንስ አከ ሴር ዋቀዮ አረበኬረ ጅራቱፍ ሀርከኬ እረት አከ መለቶ፣ አደኬረትሞ አከ ያደኖ ሲፍ ተአ። ዋቀዮ ሀርከሳ ጀባ ሰናን ግብጢ ስ ባሴቲ። ");
INSERT INTO gaze_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","አትስ ስርነ ከነ ወጉመ ወጋን ዬሮሳት ኤጉ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“ዮሙ ዋቀዮ አኩመ ስኢፊ አቦቲኬቲፍ ከኩዻን ዋዳ ገሌ ሰነት ብየ ከነኣኖታት ስ ገልቼ ብየቲ ሲፍ ኬኑት፣ ");
INSERT INTO gaze_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","አት ሀንገፈ ገደሜሰ በኑ ሁንደ ዋቀዮፍ ኬንተ። ኮርም ሆሪኬቲ ሀንገፍን ሁንድኑስ ከን ዋቀዮት። ");
INSERT INTO gaze_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","ሀሬ ሀንገፈ ከምዩ እልሞ ሆላቲን ፉር፤ ዮ ፉሩ ባቴ ገሩ ሞርመሳ ጨብስ። እልማንኬ ኬሳስ ሀንገፈ ከምዩ ፉር። ");
INSERT INTO gaze_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“በረ ዹፉፍ ጅሩ ኬሰ ዮ እልምኬ፣ ‘ኩን ማል ጄቹዸ?’ ጄዼ ስ ጋፈቴ አት አከነ ጄዺን፤ ‘ዋቀዮ ሀርከ ጀባዻን ግብጢ፣ መነ ገርቡማ ኬሳ ኑ ባሴ። ");
INSERT INTO gaze_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","ዮሙ ፈረኦን መታ ጀባቴ ገድ ኑ ዺሱ ድዴት፣ ዋቀዮ ሀንገፈ ግብጥ ሁንደ ነማፊ ሆሪ አጄሴ። ሰበቢን አን ኮርመ ሀንገፈ ገደሜሰ በኑ ሁንደ ዋቀዮፍ ኣርሳ ዽኤሱፊ ሰበቢን አን እልማንኮ ኬሳ ሀንገፈ ሁንደ ፉሩፍ ከኑመ።’ ");
INSERT INTO gaze_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","ዋቀዮ እሬ ጀባዻን ግብጢ ኑ ባሱሳቲፍ ወን ኩን ሀርከኬረት መለቶ፣ አደኬረትስ መለቶ ተአ።” ");
INSERT INTO gaze_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","ዬሮ ፈረኦን ሰበ ሰነ ገድ ዺሴት ከርች ገባባ ተኡዩ ዋቅን ከራ ብየ ፍልስጤምረ እሳን ህንቀጄልችኔ፤ ሰበቢንሳስ ዋቅን፣ “እሳን ዮ ወራን እሳን ሙደቴ ያደ ጌደረተኒ ግብጥት ዴብኡ ደንደአን” ጄዼት። ");
INSERT INTO gaze_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","ከናፉ ዋቅን ከራ ናኖ ገሞጂቲን ገረ ገላነ ዲማት ሰበ ሰነ ቀጄልቼ። እስራኤሎንስ ወራናፍ ቆጳአኒ ብየ ግብጢቲ በአን። ");
INSERT INTO gaze_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","ሰበቢ ዮሴፍ፣ “ዋቅን ዹጉማን እስን ገርጋረ፤ እስንስ ጋፈስ ለፌኮ አሲ ፉዻ በኣ” ጄዼ እስራኤሎን ከከቺሴ ቱሬፍ ሙሴን ለፌ ዮሴፍ ፉዼ በኤ። ");
INSERT INTO gaze_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","እሳንስ ሱኮቲ ከአኒ ኤታም ኬሰ ቀርቀረ ገሞጂ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","ዋቀዮ አከ እሳን ሀልከኒ ጉያ ዴሙ ደንደአኒፍ ጉያ ኡቱባ ዱሜሳቲን እሳን ዱረ ዴሜ ከራ እሳን አርግሲሴ፤ ሀልከንሞ እሳኒፍ እብሱፍ ጄዼ ኡቱባ እብዳቲን እሳን ዱረ ዴማ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","ኡቱባን ዱሜሳ ጉያ ጉያ፣ ኡቱባን እብዳሞ ሀልከን ሀልከን ኡመተ ዱራ ህንዸበምኔ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","ኤርገሲ ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“አከ እሳን ኦፍረ ገረ ገለኒ ጲ ሀሂሮት ብረ፣ ምግዶሊፊ ገላነ ግዱ ቁበተን እስራኤሎተት ህም። እሳን ፉሌ በኣል ዜፎን፣ ገላነ ጭነ ቁበቹ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","ፈረኦንስ፣ ‘እስራኤሎን ቡርጃጀአኒ ብየ ኬሰ ጆራ ጅሩ፤ ገሞጂን እሳን መርሴረ’ ጄዼ ያዴ። ");
INSERT INTO gaze_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","አንስ ገራ ፈረኦን ነንጀቤሰ፤ እን ፋነ ዸኤ እሳን ዱካ ቡአ። አንስ ከራ ፈረኦኒቲፊ ከራ ሎልቶተሳ ሁንዳቲን ኦፊኮቲፍ ኡልፍነ ነንአርገዸ፤ ወር ግብጥ አከ አን ዋቀዮ ተኤ ንቤኩ።” እስራኤሎንስ አከሱመ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","ሞቲን ግብጥ አከ ሰብን ሱን በቀቴ በኤ ዮሙ እት ህመሜት ፈረኦኒፊ ቆንዳልቶትንሳ ያደ ዋኤ ሰበ ሰና ቀበን ጌደረተኒ፣ “አከ ሰብን እስራኤል ኑ ተጃጅሉ ዺሴ ዴሙፍ ገድ ዺሱንኬኘ ማል ጎቹኬኘ?” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","እንስ ጋሪሳ ቆጴፈቴ፣ ሎልቶተሳስ ፉዸቴ ከኤ። ");
INSERT INTO gaze_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","ጋሪወን ፍለተሞ ዽበ ጀአ፣ ጋሪወን ግብጥ ብራ ሁንደ ከኔን አጀጁወን እሳን ሁንደረ ጅረን ፉዸቴ ከኤ። ");
INSERT INTO gaze_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","ዋቀዮስ ፈረኦን ሞትቸ ግብጥ መተ ጀቤሰ ጎዼ፤ ፈረኦንስ እስራኤሎተ ወረ ሶዳ መሌ በኣ ቱረን ሰነ ዱካ ቡኤ አርኤ። ");
INSERT INTO gaze_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","ወር ግብጥስ ፈርዴኒፊ ጋሪወን ፈረኦን ሁንድ፣ አቦቲን ፈርዳቲፊ ሎልቶትን ለፎን እስራኤሎተ ዱካ ቡአኒ እሳኒ ጲ ሀሂሮት ብረ ፉሌ በኣል ዜፎን ቀርቀረ ገላና ቁበተኒ ጅረን ቀቀበን። ");
INSERT INTO gaze_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","ዬሮ ፈረኦን እት ዽኣቴትስ እስራኤሎን ኦል እላለኒ ኩኖ ወር ግብጥ ዱግደ ዱባን እሳን ፋነ ዹፈን አርገን። እሳንስ ሶዳተኒ ዋቀዮት እየተን። ");
INSERT INTO gaze_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","እሳንስ ሙሴዻን አከነ ጄዸን፤ “አት ዋን እዶን አዋላ ግብጥ ህንጅሬፍ አከ ኑ ገሞጂ ኬሰት ዹምኑፍ አስ ኑ ፍዴ? አት ግብጥ ኑ ባሱንኬ ማል ኑ ጎቹኬት? ");
INSERT INTO gaze_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","ኑ ግብጥ ኬሰት፣ ‘አከ ወረ ግብጥ ተጃጅሉፍ ኑ ዺስ’ ሲን ህንጄኔ? ገሞጂ ኬሰት ዹሙረ ወረ ግብጥ ተጃጅሉ ኑ ወየ ቱሬ!” ");
INSERT INTO gaze_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","ሙሴን አከነ ጄዼ ሰበ ሰናፍ ዴብሴ፤ “ህንሶዳትና፤ ጀባዻ ዻበዻ! ፈይሱ ዋቀዮ ከን እን ሀርአ እስኒ ጎዹ እላላ! ወረ ግብጥ ከን ሀርአ አርግተን ከነ ለመተ ዴብተኒ ህንአርግተን። ");
INSERT INTO gaze_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","ዋቀዮ እስኒፍ ሎለ፤ እስን ገብ ጄዻ።” ");
INSERT INTO gaze_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ “አት ማሊፍ ነት እይተ? አከ እሳን አዴምሰሳኒ እት ፉፈኒፍ እስራኤሎተት ህም። ");
INSERT INTO gaze_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","ኡሌኬ ኦል ፉዺቲ ሀርከኬ ገላነረ ድሪርፈዹ፤ አከ እስራኤሎን ለፈ ጎጋረ ገላነ ግዱ ደርበኒፍ ብሻን ገርገር ቆድ። ");
INSERT INTO gaze_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","አንሞ አከ እሳን ዱግደሳኒ ዱባን ሴነኒፍ ገራ ወረ ግብጥ ነንጀቤሰ። አንስ ፈረኦኒፊ ሎልቶተሳ ሁንደረት፣ ጋሪወንሳቲፊ አቦቲ ፈርዳሳረት ኡልፍነ ነንአርገዸ። ");
INSERT INTO gaze_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","ዬሮ አን ፈረኦንረት፣ ጋሪወንሳቲፊ አቦቲ ፈርዳሳረት ኡልፍነ አርገዹት ወር ግብጥ አከ አን ዋቀዮ ተኤ ንቤኩ።” ");
INSERT INTO gaze_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","ዮሙስ ኤርገማን ዋቀዮ ከን ሰበ እስራኤል ዱረ ዴማ ቱሬ ሱን ከኤ ገረ ዱግደሳኒ ዱባት ደርቤ። ኡቱባን ዱሜሳ ሱንስ ፉለሳኒ ዱራ ከኤ እሳን ዱበ ዻበቴ፤ ");
INSERT INTO gaze_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","ኡቱባን ሱንስ ሎልቶተ ግብጢፊ ሎልቶተ እስራኤል ግዱ ሴኔ። ዱሜስ ሱን ሀልከን ሰነ ገመ ቶኮት ዱከነ፣ ገመ ካንትሞ እፈ ፍዴ፤ ከናፉ ሀልከን ሰነ ጉቱ ገሬ ለማን ኬሳ ቶኮሌ ገሬ ካንት ህንዽኣትኔ። ");
INSERT INTO gaze_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","ሙሴንስ ሀርከሳ ገላነረ ድሪርፈቴ፤ ዋቀዮስ ሀልከን ሰነ ጉቱ ቡቤ በአ ቢፍቱ ጀባዻን ገላንቸ ገረ ዱባት ዴብሴ ገላንቸ ለፈ ጎጋ ጎዼ። ብሻን ሱንስ ገርገር ቆደሜ፤ ");
INSERT INTO gaze_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","እስራኤሎንስ ገላንቸ ግዱ ለፈ ጎጋረ ደርበን፤ ብሻንችስ ከራ ምርጋሳኒቲፊ ከራ ብታሳኒ ኬኘን ተኤፍ። ");
INSERT INTO gaze_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","ወር ግብጥ እሳን ዱካ ቡአኒ ፈርዴን ፈረኦን፣ ጋሪወንሳቲፊ አቦቲን ፈርዳሳ ገላነ ሴነን። ");
INSERT INTO gaze_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","ዮሙ ለፍት በርኤት ዋቀዮ ኡቱባ እብዳቲፊ ዱሜሳ ኬሳ ሎልቶተ ግብጥ ሰነ ገድ እላሌ ገረ እት ጎረን እሳን ወላልችሴ። ");
INSERT INTO gaze_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","አከ እሳን ረክናን ኦፈኒፍስ ጎማ ጋሪወንሳኒ እራ ባሴ። ወር ግብጥስ፣ “ዋን ዋቀዮ ገመ እስራኤሎታ ዻበቴ ወረ ግብጥ ሎላ ጅሩፍ ኮታ እሳን ዱራ በቀትና” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","ዋቀዮስ ሙሴዻን፣ “አከ ብሻኖትን ወረ ግብጥረ፣ ጋሪወኒፊ አቦቲ ፈርዳሳኒረ ገረገለኒፍ ሀርከኬ ገላነረት ድሪርስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","ሙሴንስ ሀርከሳ ገላንቸረት ድሪርሴ፤ ዬሮ ለፍት በርኤትስ ገላን ሱን እዶሳት ዴብኤ። ወር ግብጥስ ብሻን ሰነ ጀላ በቀተን፤ ዋቀዮስ ሀጣኤ ገላነት እሳን ነቄ። ");
INSERT INTO gaze_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","ብሻን ሱን እዶሳት ዴብኤ ጋሪወኒፊ አቦቲ ፈርዳ ጄቹንስ ሎልቶተ ፈረኦን ከኔን እስራኤሎተ ዱካ ቡአኒ ገላነ ሴነን ሰነ ሁንደ ልቅምሴ። እሳን ኬሳስ ነምን ቶኮዩ ህንሀፍኔ። ");
INSERT INTO gaze_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","እስራኤሎን ገሩ ብሻንች ከራ ምርገሳኒቲፊ ከራ ብታሳኒቲን ኬኘን ተኤፊ ገላንቸ ኬሰ ለፈ ጎጋረ ደርበን። ");
INSERT INTO gaze_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","ጋፈስ ዋቀዮ ሀርከ ወረ ግብጥ ጀላ እስራኤሎተ ባሴ፤ ወር እስራኤልስ ሬፈ ወረ ግብጥ ቀርቀረ ገላናት አርገን። ");
INSERT INTO gaze_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","እስራኤሎንስ ዮሙ ሁምነ ጉዳ ከን ዋቀዮ ወረ ግብጥረት ሙልእሴ ሰነ አርገንት፣ ዋቀዮን ሶዳተን፤ እሳንስ ዋቀዮፊ ተጃጅላሳ ሙሴ አመነን። ");
INSERT INTO gaze_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","ዮሙስ ሙሴፊ እስራኤሎን ፋርፈትና ከነ ዋቀዮፍ ፋርፈተን፦ “አን ዋቀዮፍ ነንፋርፈዸ፤ እን ኦል ኦል ጄዼራቲ። እን ፈርዳፊ ነምቸ ፈርደ ያበቴ ገላነት ገድ ደርበቴረ። ");
INSERT INTO gaze_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“ዋቀዮ ጀብነኮቲፊ ፋርፈትናኮት፤ እን ፈይነኮ ተኤረ። እን ዋቀኮት፤ አንስ እሰ ነንጀጀዸ፤ እን ዋቀ አባኮቲት፤ አንስ እሰ ኦል ኦል ነንቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","ዋቀዮ ጎተ ወራናት፤ መቃንሳ ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","እን ጋሪወን ፈረኦኒፊ ሎልቶተሳ ገላነት ገድ ደርበቴረ። ቆንዳልቶተ ፈረኦን ኬሳ ፍለተምቶትን፣ ገላነ ዲማ ኬሰ ዽዽመኒሩ። ");
INSERT INTO gaze_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","ቱጁብን እሳንረ ገረ ገሌ፤ እሳንስ አኩመ ዸጋ ቱጁበት ገድ ዽዽመን። ");
INSERT INTO gaze_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","ያ ዋቀዮ፣ ሀርክኬ ምርጋ ሁምናን ኡልፍነ ቀቤሰ። ያ ዋቀዮ፣ ሀርክኬ ምርጋ ዲነ ንሁሬሰ። ");
INSERT INTO gaze_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“አት ጉድነ ኡልፍነኬቲቲን ወረ ሲን ሞርመን ገድ ደርበቴ። ኣሪኬ ቦበኣ ንኤርግቴ፤ እንስ አኩመ ሀበቂት ጉቤ እሳን ፍጤ። ");
INSERT INTO gaze_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","ሀፉረ ፉኛንኬቲቲን ብሻኖትን ቱለመን። ብሻን ያኡ አኩመ ኬኘኒት ኦል ዻበቴ፤ ቱጁቦንስ ወለካ ገላናት እትተን። ");
INSERT INTO gaze_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","ዲን፣ ‘አን ፋነ ቡኤ እሳን ቀቀበ። ቦጁ ነንቆደዸ፤ አን እሳንረት ፌዺኮ ነንጉተዸ። ጎራዴኮ ነንሉቅፈዸ፤ ሀርክኮ እሳን በርበዴሰ’ ጄዼ ነንዻደቴ። ");
INSERT INTO gaze_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","አት ገሩ ቡቤኬ እት ቡብፍቴ፤ ገላንሞ እሳንረ ገረ ገሌ። እሳንስ አኩመ ስቢላ ብሻኖተ ጀጀቦዻን ልቅምፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","ያ ዋቀዮ፣ ዋቆተ ኬሳ ኤኙቱ ስ ፈካተ? ቁልቁልናን ስምቦ ቀቤስ፣ ኡልፍናን ሶዳችሳን፣ ሆጂ ድንቂ ሆጄቹትስ ከን አከኬቲ ኤኙ? ");
INSERT INTO gaze_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“አት ሀርከኬ ምርጋ ድሪርፈናን፣ ለፍት እሳን ልቅምስቴ። ");
INSERT INTO gaze_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","አት ሰበ ፉርቴ ሰነ፣ ጃለለኬ ህንጌደረምኔን ጌጌስተ። ጀብነኬቲንስ ገረ እዶ ጅሬኘኬቲ ቁልቁሉት እሳን ቀጄልችተ። ");
INSERT INTO gaze_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","ሰቦትን ዸገአኒ ሆለቱ፤ ሙደምሱንስ ሰበ ፍልስጤም ቀበቴ። ");
INSERT INTO gaze_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","ሀንገፎትን ኤዶም ንርፈቱ፤ ቡልችቶተ ሞኣብስ ናሱቱ ቀበተ፤ ወር ከነኣንስ ብሻኑመ ተኡ፤ ");
INSERT INTO gaze_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","ሶዳፊ አብዲ ኩተቹን እሳንረ ቡአ። ያ ዋቀዮ፣ ሀመ ሰብንኬ ደርቡት፣ ሀመ ሰብን አት ብተቴ ሱን ደርቡት ጀብነ ሀርከኬቲቲን እሳን አኩመ ዸጋ ጨልእሱ። ");
INSERT INTO gaze_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","ያ ዋቀዮ፣ አት ገረ ቱሉ ዻለኬቲት፣ ገረ ለፈ እዶ ጅሬኘኬቲ ጎዸቹፍ ቶልፈቴት፣ ያ ጎፍታ አት ገረ እዶ ቁልቁሉ ሀርክኬ ሁንዴሴት ኦል ገልችቴ እሳን ዻብደ። ");
INSERT INTO gaze_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“ዋቀዮ፣ በረ በራ ሀመ በረ በራት ሞአ።” ");
INSERT INTO gaze_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","ዮሙ ፈርዴን፣ ጋሪወኒፊ አቦቲን ፈርዳ ከን ፈረኦን ገላነ ሴነንት ዋቀዮ ብሻኖተ እሳንረ ገረገልቼ፤ እስራኤሎን ገሩ ለፈ ጎጋረ ዴመኒ ገላነ ኬሰ ደርበን። ");
INSERT INTO gaze_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","ሚርያም ኦቦሌቲን አሮን ራጅቲን ሱን ድቤ ሀርከት ቀበቴ ካቴ፤ ዱበርቶትን ሁንድኑስ ድቤሳኒ ፉዸተኒ ስርባ እሼ ፋነ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","ሚርያምስ አከነ ጄቴ እሳኒፍ ፋርፈቴ፦ “ዋቀዮ ፋርፈዻ፤ እን ኡልፍናን ሞአቴራቲ። እን ፈርዳፊ ነምቸ ፈርደ ያበቴ ገላነት ገድ ደርበቴረ።” ");
INSERT INTO gaze_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","ሙሴንስ ሰበ እስራኤል ገላነ ዲማ ብራ ፉዼ ቀጄልቼ፤ እሳንስ ገሞጂ ሹር ሴነን። እስራኤሎንስ ኡቱ ብሻን ህንአርገን ጉያ ሰዲ ገሞጂ ኬሰ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","እሳንስ ዮሙ ማራ ገአንት ብሻንሳ ዹጉ ህንደንዴኜ፤ ብሻን ሱን ሀዻኣ ቱሬቲ። ወን እዶን ሱን ማራ ጄዸሜፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","ጀር ሱንስ፣ “ኑ ማል ሃዹግኑ?” ጄዸኒ ሙሴት ጉንጉመን። ");
INSERT INTO gaze_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","ዮሙስ ሙሴን ዋቀዮት እይናን፣ ዋቀዮ ሙከ ቶኮ እሰ አርግሲሴ። እንስ ሙከ ሰነ ብሻንት ገድ ደርበቴ፤ ብሻን ሱንስ ንምኣዌ። ዋቀዮስ እዶ ሰነት ስርናፊ ሴረ እሳኒፍ ባሴ፤ አችትስ እሳን ቆሬ። ");
INSERT INTO gaze_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","እንስ አከነ ጄዼ፤ “አት ዮ ሰገሌ ዋቀዮ ዋቀኬቲ ገራ ቶኮን ዸጌሴ፣ ዮ ዋን ፉለሳ ዱረት ቀጄላ ተኤ ሆጄቴ፣ ዮ አጀጀሳ ቀልቤፈቴፊ ዮ ሴረሳ ሁንደ ኤግዴ፣ አን ዹኩበ ወረ ግብጥት ፍዴ ሰነ ኬሳ ቶኮዩ ስት ህንፍዱ፤ አን ዋቀዮ ስ ፈይሱዻቲ።” ");
INSERT INTO gaze_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","እሳንስ ገረ ኤልም እዶ ቡርቃን ኩዸ ለማፊ ሙኬን ሜጢ ቶርባተምን ቱረን ዹፈኒ አች ብሻን ብረ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","ወልዳን እስራኤል ሁንድ ብየ ግብጢቲ በአኒ ጅአ ለመፋት፣ ጅአ ሰነ ኬሳስ ጉያ ኩዸ ሸነፋት ኤሊሚ ከአኒ ገረ ገሞጂ ሲን እሰ ኤልሚፊ ሲና ግዱ ጅሩ ሰና ዸቀን። ");
INSERT INTO gaze_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","ገሞጂ ኬሰትስ ሀዋስን ሱን ጉቱን ሙሴፊ አሮንት ጉንጉመን። ");
INSERT INTO gaze_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","እስራኤሎንስ አከነ እሳኒን ጄዸን፤ “ኑ ብየ ግብጥት ዬሮ ኦኮቴ ፎኒ ብረ ቴኜ ሀመ ቁፍኑት ቡዴነ ኛቻ ቱሬ ሰነ ሀርከ ዋቀዮት ኡቱ ዱኔረ ተኤ! እስን ገሩ አከ ወልዳን ኩን ጉቱን ቤለኤ ዹሙ ጎቹፍ አቺ ኑ ባፍተኒ ገሞጂ ከነት ኑ ፍደኒርቱ።” ");
INSERT INTO gaze_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","ዋቀዮሞ ሙሴዻን አከነ ጄዼ፤ “ኩኖ፣ አን ሰሚራ ቡዴነ ገድ እስኒ ነንሮብሰ። ሰብን ሱንስ ጉዩመ ጉያን ገድ በኤ ዋን ጉያ ቶኮፍ እሰ ገኡ ወልት ሃቀበቱ። አንስ ከራ ከናን እሳን ቆሬ ሴረኮ ኤጉፊ ኤጉ ባቹሳኒ ነንእላለ። ");
INSERT INTO gaze_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","እሳንስ ጉያ ጀአፋት ዋን ወልት ቀበተን ሰነ ሃቆጴፈተን፤ ወን ኩንስ ዋን እሳን ጉያ ብራ ወልት ቀበተንት ሀርከ ለመ ሃተኡ።” ");
INSERT INTO gaze_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","ሙሴፊ አሮን እስራኤሎተ ሁንዳን አከነ ጄዸን፤ “ከን ብየ ግብጢቲ እስን ባሴ ዋቀዮ አከ ተኤ ገልገለ ከነ ንቤክቱ። ");
INSERT INTO gaze_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","ገነመሞ ኡልፍነ ዋቀዮ አርግቱ፤ እን አከ እስን እሰት ጉንጉምተን ዸገኤራቲ። ኑ ኤኙ ታናን እስን ኑት ጉንጉምቱ?” ");
INSERT INTO gaze_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","ሙሴንስ አከነ ጄዼ፤ “ዬሮ እን አከ እስን ኛተኒፍ ገልገለ ፎን፣ ገነመሞ ቡዴነ እስን በርባደን ሁንደ እስኒ ኬኑት እስን አከ እን ዋቀዮ ተኤ ንቤክቱ፤ እን ጉንጉሚ እስን እሰት ጉንጉምተን ዸገኤራቲ። ኑ ኤኙዸ? እስን ዋቀዮት ጉንጉማ ጅርቱ መሌ ኑት ህንጉንጉምኔ።” ");
INSERT INTO gaze_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","ዮሙስ ሙሴን፣ “ወልዳ እስራኤል ሁንዳን፣ ‘ሰበቢ እን አከ እስን ጉንጉምተን ዸገኤፍ እስን ፉለ ዋቀዮ ዱረት ዽኣዻ’ ጄዽ” ጄዼ አሮንት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","ዬሮ አሮን ጉቱማ ወልዳ ሰበ እስራኤልት ዱበቻ ቱሬት እሳን ገረ ገሞጂ እላላ ቱረን፤ ኩኖ፣ ኡልፍን ዋቀዮ ዱሜሰ ኬሳን ሙልአቴ። ");
INSERT INTO gaze_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“አን ጉንጉሚ ሰበ እስራኤል ዸገኤረ። አትሞ፣ ‘እስን ዬሮ ለፍት ድምምሶፍቱት ፎን ኛቱ፤ ገነመሞ ቡዴነ ኛተኒ ቁፍቱ። እስንስ ዬሮ ሰነ አከ አን ዋቀዮ ዋቀኬሰን ተኤ ንቤክቱ’ ጄዺ እሳንት ህም።” ");
INSERT INTO gaze_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","ገልገሉመ ሰነ ድምብርቄን ዹፍቴ እዶ ቁበትና ሰነ ጉቴ፤ ጉያ እት ኣኑ ገነመሞ ፍጤንስ ናኖ ቁበትና ሰና ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","ዮሙ ፍጤንስ ቡኤትስ፣ ኩኖ ወንቶትን ሀጲን አከ ቆራ ለፈራ አዳተን ድሬ ገሞጂረ ቡቡአን። ");
INSERT INTO gaze_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","እስራኤሎንስ ዮሙ ዋን ከነ አርገንት፣ “ወን ኩን ማል?” ወሊን ጄዸን። እሳን ወን ሱን ማል አከ ተኤ ህንቤክኔ ቱሬቲ። ሙሴንስ አከነ እሳኒን ጄዼ፤ “ወን ኩን ቡዴነ አከ እስን ኛተኒፍ ዋቀዮ እስኒፍ ኬኔዸ። ");
INSERT INTO gaze_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","ዋቀዮ አከነ ጄዼ አጀጄረ፦ ‘ቶኮን ቶኮን ነማ ሀመ በርባዱ ወልት ሃቀበቱ። አኩመ ባይእነ ነመ ዱንካነኬሰን ኬሳት ቶኮ ቶኮ ነማቲፍ ጎሞሪ ቶኮ ፉዸዻ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","እስራኤሎን አኩመ እሳንት ህመሜ ጎዸን፤ ገር ቶኮ ባይኤ፣ ወር ካንሞ ጥኖ ወልት ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","ዮሙ እሳን ጎሞሪዻን ሰፈረንት እሰ ባይኤ ወልት ቀበቴራ ህንሀፍኔ፤ እሰ ጥኖ ወልት ቀበቴትስ ህንህርአትኔ። ቶኮን ቶኮን ነማ ሀሙመ በርባዱ ወልት ቀበቴ። ");
INSERT INTO gaze_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","ሙሴንስ፣ “ነምን ቶኮዩ ዋን ወልት ቀበቴ ኬሳ ቶኮሌ ገነማፍ ህንቡልፈትን” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","ተኡስ እሳን ኬሳ ነሞትን ቶኮ ቶኮ ሙሴ ህንዸጌኜ፤ ዋን ወልት ቀበተን ኬሳስ ገርቶኮ ገነማፍ ቡልፈተን፤ እንስ ራመኤ አጃኤ። ከናፉ ሙሴን እሳንት ኣሬ። ");
INSERT INTO gaze_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","ቶኮን ቶኮን ነማ ገነመ ገነመ ሀሙመ በርባዱ ወልት ቀበቴ፤ እንስ ዮሙ አዱን ሆእቴት በቄ በዴ። ");
INSERT INTO gaze_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","ጉያ ጀአፋት ጀር ሀርከ ለመ ጄቹንስ መተ መታት ጎሞሪ ለመ ወልት ቀበተን፤ ሆገንቶትን ወልድቻ ሁንድስ ዸቀኒ ሙሴት ህመን። ");
INSERT INTO gaze_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","እንስ አከነ ጄዼን፤ “ዋቀዮ አከነ ጄዼ አጀጄ፦ ‘ቦር ጉያ ሰንበተ ቦቆና ተአ፤ እንስ ሰንበተ ዋቀዮፍ ቁልቁላኤዸ። ዋን ቶልፈቹ በርባደን ቶልፈዻ፤ ዋን አፌለቹ በርባደንስ አፌለዻ። ዋንራ ሀፉ ሁንደሞ ሀመ ገነማት ቱርፈዻ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","ጀርስ አኩመ ሙሴን እሳን አጀጄት ሀመ ገነማት ቱርፈተን፤ ኛትን ሱንስ ህንአጆፍኔ ዮካን ህንራሞፍኔ። ");
INSERT INTO gaze_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","ሙሴንስ አከነ ጄዼ፤ “ዋን ጉያን ሀርኣ ሰንበተ ዋቀዮ ተኤፍ ኛተ ከነ ሀርአ ኛዻ፤ እስን ሀርአ ድሬረት እሰ ህንአርገተን። ");
INSERT INTO gaze_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","እስንስ ኛተ ሰነ ጉያ ጀአ ወልት ቀበዻ፤ ጉያ ቶርበፋት ጄቹንስ ጉያ ሰንበታቲን ገሩ ቶኮዩ ህንአርገሙ።” ");
INSERT INTO gaze_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","ጀረ ሰነ ኬሳ ነሞትን ቶኮ ቶኮሞ ጉያ ቶርበፋት ወልት ቀበቹፍ ገድ በአን፤ ገሩ ሆማ ህንአርገኔ። ");
INSERT INTO gaze_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","ከነረት ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “እስን ሀመ ዮሚት አጀጀኮፊ ቀጄልፈመኮ ኤጉ ድዱ? ");
INSERT INTO gaze_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","ዋቀዮ ሰንበተ አከ እስኒ ኬኔ ሁበዻ። ሰበቢን እን ጉያ ጀአፋት ቡዴነ ጉያ ለማፍ ተኡ እስኒ ኬኑፍስ ከኑመ። ነምን ሁንድኑ ጉያ ቶርበፋት እዱመ ጅሩ ሃቱሩ። ነምን ቶኮዩ ገድ ህንበእን።” ");
INSERT INTO gaze_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","ሰብን ሱንስ ጉያ ቶርበፋት ንቦቆቴ። ");
INSERT INTO gaze_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","ሰብን እስራኤል ቡዴነ ሰነ “መና” ጄዼ ሞጋሴ። መናን ኩንስ ሰኚ ድንብላላ ፈካተ፤ አዲዸስ፤ ምኣንሳስ አከ ብጥሌ ደማን ቶልፈሜት። ");
INSERT INTO gaze_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","ሙሴን አከነ ጄዼ፤ “ዋቀዮ አከነ ጄዼ አጀጄ፦ ‘አከ እን ዸሎተ ዹፉፍ ቱርፈሙፍ መና ጎሞሪ ቶኮ ፉዻ፤ ኩንስ አከ እሳን ቡዴነ አን ዬሮ ብየ ግብጥ ኬሳ እስን ባሴት አከ እስን ገሞጂ ኬሰት ኛተኒፍ እስኒ ኬኔ ሰነ አርገኒፍ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","ሙሴን አሮኒን፣ “ኦኮቴ ቶኮ ፉዺቲ መና ጎሞሪ ቶኮ እት ነቅ፤ አከ መናን ኩን ዸሎተ ዹፉፍ ቱርፈሙፍ ፉለ ዋቀዮ ዱረ ካእ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","አሮንስ አኩመ ዋቀዮ ሙሴ አጀጄ ሰነት አከ መናን ሱን ቱርፈሙፍ ፉለ ዹጋ በኡ ዱረ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","ሰብን እስራኤል ሀመ ብየ ኬሰ ቁበተሙ ሰነ ገአንት ወጋ አፉርተመ መና ኛተን፤ እሳንስ ሀመ ዳሪ ብየ ከነኣን ገአንት መና ኛተን። ");
INSERT INTO gaze_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","ጎሞሪን ቶኮ ሀርከ ኩርነፋ ኢፊ ቶኮት። ");
INSERT INTO gaze_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","ወልዳን እጆሌ እስራኤል ሁንድ አኩመ ዋቀዮ አጀጄት ገሞጂ ሲኒቲ ከአኒ እዶ ቶኮራ ገረ እዶ ብራት ደርባ ዸቀኒ ሬፊዲም ቁበተን። ገሩ ሰብን ሱን ብሻን ዹጋቲ ህንአርገኔ። ");
INSERT INTO gaze_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","ከናፉ እሳን፣ “ብሻን ዹግኑ ኑ ኬን” ጄዸኒ ሙሴ ሎለን። ሙሴንሞ ዴብሴ፣ “እስን ማሊፍ ነ ሎልቱ? ዋቀዮስ ማሊፍ ቆርቱ?” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","ጀርስ ብሻን ዼቦተኒ ሙሴት ጉንጉመን፤ አከነስ ጄዸን፤ “አት ማሊፍ አከ ኑ፣ እጆሌንኬኛፊ ሆሪንኬኘ ዼቡን ዹምኑፍ ብየ ግብጢቲ ኑ ባፍቴ?” ");
INSERT INTO gaze_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","ከነረት ሙሴን ገረ ዋቀዮት እዬ፣ “አን ሰበ ከነ ማልን ጎዸ? እሳን ዸጋን ነ ቱሙፍ ጥኑመቱ ሀፌ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","ዋቀዮሞ አከነ ጄዼ ሙሴፍ ዴቢ ኬኔ፤ “ሰበ ከነ ዱረ ደርቢ ዴም። ማንጉዶተ እስራኤል ኬሳ ቶኮ ቶኮ ኦፍ ፋነ ፉዸዹቲ ኡሌ እቲን ለገ አበያ ዾፍቴ ሰነ ሀርከት ቀበዹ ዴም። ");
INSERT INTO gaze_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","ኩኖ አን ከታ ኮሬብ ሰነ ብረ ፉለኬ ዱረ አች ነንዻበዸ፤ አከ ነሞትን ብሻን ዹገኒፍ አት ከታ ሰነ ዸእ፤ ብሻንስ እሰ ኬሳ ንበአ።” ከናፉ ሙሴን ፉለ ማንጉዶተ እስራኤል ዱረት አከሱመ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","ሰበቢ እስራኤሎን ሎለ ካሰኒፊ ሰበቢ እሳን፣ “ዋቀዮ ኑ ወጅን ጅረ ሞ ህንጅሩ?” ጄቹዻን ዋቀዮን ቆረኒፍ ሙሴን እዶ ሰነ ማሳሂፊ መሪባ ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","አማሌቆትን ዹፈኒ ሬፊዲምት እስራኤሎተ ሎለን። ");
INSERT INTO gaze_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","ሙሴንስ እያሱዻን፣ “ነሞተኬኘ ኬሳ ሙራሰ ፍለዹቲ ዸቂ አማሌቆተ ሎል። አን ቦር ኡሌ ዋቃ ሀርከኮት ቀበዼ ፊጤ ጋረረ ነንዻበዸ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","ዬሮ ሙሴን፣ አሮኒፊ ሁር ፊጤ ጋረት ኦል በአንት፣ እያሱን አኩመ ሙሴን አጀጄት አማሌቆተ ሎለ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","ዬሮ ሙሴን ሀርከሳ ኦል ቀበቱት እስራኤሎን ንሞአቱ ቱረን፤ ዬሮ እን ሀርከሳ ገድ ቡፈቱሞ አማሌቆትን ንሞአቱ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","እሳንስ ዬሮ ሀርክ ሙሴ ደዸባ ዴሜት ዸጋ ቶኮ ፉዸኒ እሰ ጀለ ካአን፤ እንስ እረ ታኤ። አሮኒፊ ሁር እን ቶኮ ገረናን እን ካንሞ ገረሲን ጎረኒ አከ ሀርክሳ ሀመ አዱን ዺቱት ገድ ህንዴብኔፍ ኦል ቀበኒፍ። ");
INSERT INTO gaze_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","አከሲን እያሱን ሎልቶተ አማሌቆታ ጎራዴዻን ሞአቴ። ");
INSERT INTO gaze_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","ኤርገሲ ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አከ ወን ኩን ያደተሙፍ ክታበት በሬስ፤ እያሱን ዋን ከነ ዸገኡሳ ምርከኔስ፤ አን ጉቱማን ጉቱት ያደኖ አማሌቆታ ሰሚ ጀላ ነንበሌሳቲ።” ");
INSERT INTO gaze_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","ሙሴንስ እዶ ኣርሳ እጃሬ፣ “ዋቀዮ ፋጂኮት” ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","እንስ፣ “ሀርክ ገረ ቴሶ ዋቀዮት ኦል ካፈሜረ። ዋቀዮስ ዸሎተ ቶኮ ገረ ዸሎተ ካኒት አማሌቆተ ንሎለ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","ዬትሮ ሉብች ምድያኒቲፊ አባን ኒቲ ሙሴ ሱን ዋን ዋቅን ሙሴፊ ሰበሳ እስራኤሊፍ ጎዼ ሁንደ፣ አከሱመስ አከ ዋቀዮ እት እስራኤልን ግብጢ ባሴ ዸገኤ። ");
INSERT INTO gaze_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","ኤርገ ሙሴን ኒቲሳ ዝጶራ ኤርጌ ቦዴ ዬትሮ አባን ኒቲ ሙሴ፣ እሼፊ ");
INSERT INTO gaze_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","እልማንሼ ለማን ስመቴ። መቃን እልመሳ ቶኮ ጌርሾም ጄዸሜ፤ ሙሴን፣ “አን ብየ ኦርማ ኬሰት አለጋ ተኤረ” ጄዼራቲ። ");
INSERT INTO gaze_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","ካንሞ፣ “ዋቅን አባኮቲ ገርጋራኮት፤ እን ጎራዴ ፈረኦን ጀላ ነ ባሴረ” ጄቹዻን ኤሊኤዜር ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","ዬትሮን አባን ኒቲ ሙሴስ ኒቲ ሙሴቲፊ እልማን ሙሴ ወጅን ገሞጂ ኬሰት ገረ ቱሉ ዋቃ እዶ ሙሴን ቁበቴ ጅሩት እሰ ብረ ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","ዬትሮንስ፣ “አን አባን ኒቲኬቲ ዬትሮን ኒቲኬቲፊ እልማንሼ ለማን ወጅን ገረኬ ዹፋን ጅረ” ጄዼ ዻምሰ እት ኤርጌ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","ሙሴንስ አባ ኒቲሳ ስመቹፍ ገድ በኤ፤ ገድ ጄዼስ ሀርከ ፉዼ እሰ ዹንገቴ። እሳንስ ነጋ ወል ጋፈተኒ ዱንካነ ሴነን። ");
INSERT INTO gaze_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","ሙሴን ዋን ዋቀዮ ሰበቢ ሰበ እስራኤሊፍ ጄዼ ፈረኦኒፊ ወረ ግብጥረት ሆጄቴ፣ ረክነ ከራረት እሳን ሙደቴ ሁንዳፊ አከ እት ዋቀዮ እሳን ኦልቼ አባ ኒቲሳት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","ዬትሮንስ ዋን ጋሪ ዋቀዮ ሀርከ ወረ ግብጥ ኬሳ እሳን ባሱዻን ሰበ እስራኤሊፍ ጎዼ ሁንዳፍ ንገመዴ። ");
INSERT INTO gaze_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","እንስ አከነ ጄዼ፤ “ዋቀዮ ሀርከ ወረ ግብጢፊ ሀርከ ፈረኦን ኬሳ እስን ባሴፊ እን ሰበ ሰነ ሀርከ ወረ ግብጢቲ ባሴ ሱን ሃኤብፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","አን አመ አከ ዋቀዮ ዋቆተ ካን ሁንደ ጫላ ጉዳ ተኤ ነንቤከ፤ እን ወረ ኦፍ ቱሉማዻን እስራኤልን ረክሰንረት ዋን ከነ ራወቴራቲ።” ");
INSERT INTO gaze_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","ዮሙስ ዬትሮን አባን ኒቲ ሙሴ ሱን ኣርሳ ጉበሙፊ ኣርሳ ብራ ዋቃፍ ፍዴ፤ አሮንስ ፉለ ዋቃ ዱረት ሙሴፊ አባ ኒቲ ሙሴ ወጅን ቡዴነ ኛቹፍ ማንጉዶተ እስራኤል ሁንደ ወጅን ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","ጉያ እት ኣኑት ሙሴን ሰባፍ ሙርቲ ኬኑፍ ታኤ፤ ሰብን ሱንስ ገነማ ሀመ ገልገላት ናኖሳ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","አባን ኒቲሳስ ዮሙ ዋን ሙሴን ሰባፍ ሆጄቱ ሁንደ አርጌት፣ “ወን አት ሰባፍ ሆጄቱ ኩን ማል? አት ማሊፍ ኮጳኬ ቴሴ ሰብን ኩንሞ ገነማ ሀመ ገልገላት ናኖኬ ዸዻበተ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","ሙሴንሞ አከነ ጄዼ ዴብሴፍ፤ “ሰብን ኩን ፌዺ ዋቃ በርባቸ ገረኮ ዹፋቲ። ");
INSERT INTO gaze_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","እሳን ዮሙ ፈልሚ ቀባተንት ዽመሳኒ ነት ዽኤፈቱ፤ አንስ አቦቲ ዽማ ግዱት ሙርቲ ነንኬነ፤ ስርናፊ ሴረ ዋቃስ እሳንት ነንህመ።” ");
INSERT INTO gaze_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","አባን ኒቲ ሙሴ አከነ ጄዼ ዴብሴ፤ “ወን አት ጎቱ ኩን ጋሪ ምት። ");
INSERT INTO gaze_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","አቲፊ ሰብን ስ ብረ ዹፉ ኩን አከሱማን ኦፍ ደዸብሲፍቱ። ሆጂን ኩንስ አከ መሌ ስት ኡልፋተ፤ አት ኮጳኬ ሆጄቹ ህንደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","አን ጎርሰ ሲፍን ኬናቲ አመ ነ ዸገእ፤ ዋቅን ስ ወጅን ሃተኡ። አት ፉለ ዋቃ ዱረት እዶ ቡኣ ሰባ ታቴ ዽመሳኒ ዋቀት ፍዱ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","ስርናፊ ሴረ እሳን በርሲስ፤ አከ እሳን እት ጅራቹ ቀበኒፊ ዋን እሳን ሆጄቹ ቀበን እሳንት አርግሲስ። ");
INSERT INTO gaze_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","ከነ መሌስ አት ሰበ ሁንደ ኬሳ ነሞተ ደንዴቲ ቀበን ጄቹንስ፣ ነሞተ ዋቀ ሶዳተን፣ ነሞተ አመነሞ ከኔን መተኣ ጅበን ፍለዹቲ አጀጁወን ኩማ፣ አጀጁወን ዽባ፣ አጀጁወን ሸንተማቲፊ አጀጁወን ኩዸኒ ጎዺ ሙደዹ። ");
INSERT INTO gaze_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","እሳን ዬሮ ሁንደ ሰባፍ ሙርቲ ሃኬነን፤ ዱቢ ጭማ ሁንደ ገሩ ስት ሃፍደን፤ ዱቢ ላዮሞ ኦፉማን ሃሙርቴሰን። ኩን በኣኬ ሲፍ ሰልጵሰ፤ እሳን ስ ወጅን በኣ ንባቱቲ። ");
INSERT INTO gaze_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","ዮ አት ዋን ከነ ጎቴ፣ ዮ ዋቅንስ ዋኑመ ከነ ስ አጀጄ አት ጀባቴ ዻበቹ ደንዴሰ፤ ሰብን ኩን ሁንድስ ነጋዻን መነ ኦፊሳት ገለ።” ");
INSERT INTO gaze_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","ሙሴንስ አባ ኒቲሳ ዸገኤ ዋን እን ጄዼ ሁንደ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","እንስ እስራኤል ሁንደ ኬሳ ነሞተ ደንዴቲ ቀበን ፍለቴ ሆገንቶተ ሰባ፣ አጀጁወን ኩማ፣ አጀጁወን ዽባ፣ አጀጁወን ሸንተማቲፊ አጀጁወን ኩዸኒ እሳን ጎዸቴ። ");
INSERT INTO gaze_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","እሳንስ አቦቲ ሙርቲ ተአኒ ዬሮ ሁንደ ሰበ ሰነ ተጃጅለን፤ ዱቢ ጀባ ሙሴት ፍደን፤ ዱቢ ላዮ ተኤ ሁንደሞ ኦፉማን ሙርቴሰን። ");
INSERT INTO gaze_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","ኤርገሲስ ሙሴን አባ ኒቲሳ ጌጌሴ፤ ዬትሮንስ ዴብኤ ብየሳት ገሌ። ");
INSERT INTO gaze_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","እስራኤሎን ኤርገ ግብጢ በአኒ አስ ጅአ ሰደፋ ኬሰ ጉዩመ እት ግብጢ በአን ሰነ ገሞጂ ሲና ገአን። ");
INSERT INTO gaze_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","እሳንስ ኤርገ ሬፊዲሚ ከአኒ ቦዴ ገሞጂ ሲና ሴነን፤ ሰብን እስራኤልስ ገሞጂ ሰነ ኬሰ ፉሌ ቱሉ ሰና ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","ሙሴንስ ገረ ዋቃት ኦል በኤ፤ ዋቀዮስ ቱሉራ እሰ ዋሜ አከነ ጄዼን፤ “አት መነ ያቆቢን አከነ ጄተ፤ ሰበ እስራኤልትስ ዋን ከነ ህም፦ ");
INSERT INTO gaze_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘ዋን አን ወረ ግብጥ ጎዼፊ አከ አን እት ቆቾ ርሳረት እስን ባዼ ገረኮት እስን ፍዴ እስን መታንኬሰንዩ አርግተኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","አመስ እስን ዮ ናፍ አጀጀምተን፣ ዮ ከኩኮ ኤግደን እስን ሰቦተ ሁንደ ኬሳ ቀቤኘ አዳ ናፍ ታቱ። ዮ ለፍት ሁንድኑ ከንኮ ተኤሌ፣ ");
INSERT INTO gaze_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","እስን ሞቱማ ሉቦታቲፊ ሰበ ቁልቁሉ ናፍ ታቱ።’ ዱቢን አት ሰበ እስራኤልት ህሙ ቀብዱስ ከኑመ።” ");
INSERT INTO gaze_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","ሙሴን ዴብኤ ማንጉዶተ ሰባ ወልት ዋሜ፣ ዱቢ አከ እን ዱበቱፍ ዋቀዮ እሰ አጀጄ ሰነ ሁንደ ፉለሳኒ ዱረት ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","ጀር ሁንድኑስ አፋን ቶኮን፣ “ኑ ዋን ዋቀዮ ጄዼ ሁንዱማ ንጎነ” ጄዸኒ ዴብሰን፤ ሙሴንሞ ዋን ጀር ጄዸን ዴብሴ ዋቀዮት ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አከ ሰብን ኩን አና ስ ወጅን ዱበቱ ዸገኤ ዬሮ ሁንደ ስ አመነቱፍ ኩኖ አን ዱሜሰ የቡ ኬሳን ገረኬ ነንዹፈ።” ኤርገሲስ ሙሴን ዋን ሰብን ሱን ጄዼ ዋቀዮት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ “ገረ ሰባ ዸቂቲ ሀርኣፊ ቦር እሳን ቁልቁሌስ። አከ እሳን ወያሳኒ ሚጨተኒ ");
INSERT INTO gaze_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","ጉያ ሰደፋፍ ቆጳአን ጎዽ፤ ጋፈ ሰነ ኡቱመ ሰብን ሁንድ እላሉ ዋቀዮ ቱሉ ሲናረት ገድ ንቡኣቲ። ");
INSERT INTO gaze_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","ናኖ ቱልቻት ሰበ ሰናፍ ዳንጋ ቶልቺቲ አከነ ጄዺን፤ ‘እስን አከ ቱሉ ሰነት ኦል ህንባኔ ዮካን አከ ቀርቀረሳሌ ህንቱቅኔ ኦፍ ኤገዻ። ነምን ቱሉ ሰነ ቱቁ ከምዩ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","እን ዸጋዻን ሃቱመሙ ዮካን ጥያን ሃወራነሙ፤ ሀርክ ቶኮዩ እሰ ህንቱቅን፤ ሆሪስ ተኡ ነምን አከ ጅራቱ ህንኤየመሙፍ።’ እሳን ዬሮ መለከትን ኡቱ ገርገር ህንጭትን አፉፈሙ ቆፈ ቱሉት ኦል በኡ ደንደኡ።” ");
INSERT INTO gaze_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","ሙሴን ቱሉራ ገረ ሰባት ገድ ቡኤ ሰበ ሰነ ቁልቁሌሴ፤ እሳንስ ኡፈተሳኒ ሚጨተን። ");
INSERT INTO gaze_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","እንስ ሰበ ሰናን፣ “ጉያ ሰደፋፍ ኦፍ ቆጴሳ፤ ዱበርቲ ብረስ ህንገእና” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","ገነመ ጉያ ሰደፋ ሰነ ቱሉ ሰነረ በከካ፣ በለቄሳፊ ዱሜሰ የቡ፣ አከሱመስ ሰገሌ መለከታ ጉዳቱ ዸገአሜ። ወር እዶ ቁበታ ሰነ ኬሰ ጅራተን ሁንድስ ንሆለተን። ");
INSERT INTO gaze_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","ሙሴንስ ሰበ ሰነ እዶ ቁበናቲ ባሴ ገረ ዋቃት ፍዴ፤ ጀርስ ሚለ ቱሉ ሰና ጀለ ዸዻበተን። ");
INSERT INTO gaze_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","ቱሉን ሲና ሁንድስ ሰበቢ ዋቀዮ እብዳን እረት ገድ ቡኤፍ ኣራን ሀጉገሜ። ኣር ሱንስ አኩመ ኣረ ቦለ እብዳቲ በኡት ኦል በኤ፤ ቱሉን ሱንስ ጉቱማን ጉቱት አከ መሌ ራፈሜ፤ ");
INSERT INTO gaze_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","ሰገሌን መለከታ እቱመ ጉደቻ ዴሜ። ሙሴንስ ንዱበቴ፤ ሰገሌን ዋቃስ ዴቢ ኬኔፍ። ");
INSERT INTO gaze_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","ዋቀዮ ፊጤ ቱሉ ሲናረት ገድ ቡኤ ሙሴ ገረ ፊጤ ቱሉ ሰናት ኦል ዋሜ። ሙሴንስ ኦል በኤ፤ ");
INSERT INTO gaze_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","ዋቀዮሞ አከነ እሳን ጄዼ፤ “አከ እሳን ዋቀዮ እላሉፍ ጄዸኒ ዳሪ ህንደበሬፊ አከ እሳን ኬሳስ ነምን ባይኤን ህንዱኔፍ ገድ ቡኢቲ እሳን አኬከቺስ። ");
INSERT INTO gaze_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","አከ ዋቀዮ እሳን ህንበሌስኔፍ ሉቦትን ዋቀዮት ዽኣተንዩ ኦፍ ሃቁልቁሌሰን።” ");
INSERT INTO gaze_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","ሙሴንሞ ዋቀዮን፣ “ሰበቢ አት መታንኬ፣ ‘ናኖ ቱልቻት ዳንጋ ዻቢቲ እሰ ቁልቁሌሲቲ አዳን ባስ’ ጄቴ አኬከቺሰ ኑ ኬንቴፍ ሰብን ኩን ቱሉ ሲናት ኦል በኡ ህንደንደኡ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","ዋቀዮስ፣ “ገድ ቡኢቲ አሮንን ፍዲ ኮቱ። ገሩ ሉቦትኒፊ ኡመትን ገረ ዋቀዮት ኦል ዹፉፍ ጄዸኒ ዳንጋ ህንደርብን፤ ዮ ከና አቺ እን እሳን በሌሰ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","ሙሴንስ ገድ ቡኤ ዋን ከነ ኡመተት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","ዋቅን አከነ ጄዼ ዱቢ ከነ ሁንደ ዱበቴ፦ ");
INSERT INTO gaze_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“አን ዋቀዮ ዋቀኬ ከን ግብጢ፣ ብየ ገርቡማቲ ስ ባሴዸ። ");
INSERT INTO gaze_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“አት አነ መሌ ዋቆተ ብራ ቶኮሌ ህንቀባትን። ");
INSERT INTO gaze_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","አት ብፈ ዋን ኦል ሰሚ ጉባ ዮካን ገድ ለፈረ ዮካን ብሻን ለፈ ጀላ ኬሰ ጅሩ ከሚቲንዩ ዋቀ ቶልፈማ ኦፊኬቲፍ ህንቶልፈትን። ");
INSERT INTO gaze_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","እሳኒፍ ህንሰገድን ዮካን እሳን ህንዋቄፈትን፤ አን ዋቀዮ ዋቅንኬ ዋቀ ህናፉ ከን ሰበቢ ጩቡ አቦቲቲፍ ጄዼ እጆሌ ወረ ነ ጅበኒ ሀመ ዸሎተ ሰዲፊ አፉሪት አደቤ ");
INSERT INTO gaze_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","ወረ ነ ጃለተኒ አጀጀወንኮ ኤገንሞ ሀመ ዸሎተ ኩማት ጃለቱዸ። ");
INSERT INTO gaze_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","መቃ ዋቀዮ ዋቀኬቲ አከሱማን ህንዸእን፤ ዋቀዮ ወረ አኩመ አርገን መቃሳ ዸአን ኡቱ ህንአደብን ህንዺሱቲ። ");
INSERT INTO gaze_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","ጉያ ሰንበታ ቁልቁሌሱዻን ያደዹ። ");
INSERT INTO gaze_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","ጉዮተ ጀአ ሆጄዹ፤ ሆጂኬ ሁንደስ ሆጄተዹ፤ ");
INSERT INTO gaze_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","ጉያን ቶርበፋን ገሩ ሰንበተ ዋቀዮ ዋቀኬቲት። ጋፈስ ሆጂ ቶኮሌ ህንሆጄትን፤ አት ዮካን እልምኬ ዮካን እንተልኬ ዮካን ሆጄታንኬ ዮካን ጦምቦሬንኬ ዮካን ሆሪንኬ ዮካን አለጋን መጋላኬ ኬሰ ጅራቱ ቶኮዩ ሆማ ህንሆጄትን። ");
INSERT INTO gaze_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","ዋቀዮ ጉያ ጀአ ኬሰት ሰሚፊ ለፈ፣ ገላናፊ ዋን እሳን ኬሰ ጅሩ ሁንደ ኡሜ ጉያ ቶርበፋት ቦቆቴቲ። ከናፉ ዋቀዮ ሰንበተ ኤብሴ ቁልቁሌሴ። ");
INSERT INTO gaze_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","አከ ብየ ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ኬሰ በረ ዼራ ጅራቱፍ አባኬቲፊ ሃዸኬቲፍ ኡልፍነ ኬን። ");
INSERT INTO gaze_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","ህንአጄስን። ");
INSERT INTO gaze_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","ህንኤጅን። ");
INSERT INTO gaze_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","ህንሀትን። ");
INSERT INTO gaze_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","ኦላኬት ሶባን ዹጋ ህንበእን። ");
INSERT INTO gaze_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","መነ ነማ ህንሀውን። ኒቲ ነማ ዮካን ሆጄታሳ ዮካን ጦምቦሬሳ ዮካን ቆትዮሳ ዮካን ሀሬሳ ዮካን ዋን ነማ ከምዩ ህንሀውን።” ");
INSERT INTO gaze_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","ጀር ሁንድኑስ ዮሙ በከካፊ በለቄሰ፣ ሰገሌ መለከታቲፊ ቱሉ ኣሩ ሁበተንት ሶዳዻን ሆለተን። እሳን ፈጎ ዻበተኒ ");
INSERT INTO gaze_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","ሙሴዻን፣ “አት መታንኬ ኑት ዱበዹ፤ ኑ ንዸጌፈትና። ገሩ ዋቅን ኑት ህንዱበትን። ዮ ከና አቺ ኑ ንዹምና” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","ሙሴንሞ ሰበ ሰናን፣ “ህንሶዳትና። አከ ዋቀ ሶዳቹን እስን ወጅን ጅራቴ ጩቡ ሆጄቹራ እስን ኤጉፍ ጄዼ ዋቅን እስን ቆሩፍ ዹፌረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","ዬሮ ሙሴን ዱከነ ልምጢ እዶ ዋቅን ቱሬት ዽኣቴት፣ ነሞትን ፈጎ ዻበተን። ");
INSERT INTO gaze_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","ኤርገሲ ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ሰበ እስራኤልት ዋን ከነ ህም፦ ‘አከ አን ሰሚራ እስንት ዱበዼ እስን መታንኬሰን አርግተኒርቱ፤ ");
INSERT INTO gaze_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","አነ ብረት ዋቆተ ከምዩ ህንቶልፈትና። ዋቆተ ሜቲ ዮካን ዋቆተ ወርቄ ህንቶልፈትና። ");
INSERT INTO gaze_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘ብዮ ለፋራ እዶ ኣርሳ ና ቶልቺቲ እሰረት ቀልመ ጉበሙ፣ ኣርሳ ነጋ፣ ሆሎተኬ፣ ሬኦተኬቲፊ ሎንኬ ኣርሳ ዽኤስ። አን እዶ አከ መቃንኮ እት ያደተሙ ጎዹ ሁንደት ገረኬ ዹፌ ስን ኤብሰ። ");
INSERT INTO gaze_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","ዮ ዸጋራ እዶ ኣርሳ ና እጃርቴሞ ዸጋ ሶፈሜራ ህንእጃርን፤ ዮ ሜሻዻን እሰ ቱቅጤ ንጡሬስታቲ። ");
INSERT INTO gaze_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","አከ ቁላንኬ እሰረት ህንሙልአኔፍ ጉለንታዻን እዶ ኣርሳኮት ኦል ህንበእን።’ ");
INSERT INTO gaze_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“ሴረወን አት እሳን ዱረ ኬሱ ከኔኒዸ፦ ");
INSERT INTO gaze_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“አት ዮ እብሮተ ኬሳ ገርብቸ ብተቴ እን ወጋ ጀአ ሲፍ ሃሆጄቱ። ወጋ ቶርበፋት ገሩ እን ከፈልቲ መሌ ብልሰ ሃበኡ። ");
INSERT INTO gaze_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","እን ዮ ኮጳሳ ዹፌ ጅራቴ ኮጳሳ ብልሶሜ ሃዴሙ፤ ዬሮ ዹፉት እን ዮ ኒቲ ቀባቴ እሼንስ እሰ ወጅን ሃዴምቱ። ");
INSERT INTO gaze_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","ዮ ጎፍታንሳ ኒቲ እሰ ፉስሴ እሼንስ እልማን ዮካን እንተለን ዴሴፊ ጅራቴ፣ እሼፊ እጆሌንሼ ከን ጎፍታሼ ተኡ፤ ነምች ቆፍት ብልሰ ተኤ ሃዴሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“ገሩ ገርብች ሱን፣ ‘አን ጎፍታኮፊ ኒቲኮ፣ እጆሌኮስ ነንጃለዸ፤ አን ብልሰ በኤ ዴሙ ህንበርባዱ’ ዮ ጄዼ፣ ");
INSERT INTO gaze_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","ጎፍታንሳ ፉለ አቦቲ ሙርቲ ዱረት እሰ ሃዽኤሱ፤ ገረ በልበላት ዮካን ገረ ምችችለ በልበላት ጌሴስ ሙታዻን ጉረሳ ሃኡሩ። ኤርገሲ እን በረ ጅሬኘሳ ጉቱ እሰ ተጃጅለ። ");
INSERT INTO gaze_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“ነምን ዮ እንተለሳ አከ ገርብቲት ጉርጉረቴ፣ እሼን አከ ገርብች ቶኮ እት ብልሰ በኡት ብልሰ ህንበእን። ");
INSERT INTO gaze_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","ዮ እሼን ጎፍትቸ ኦፊሳቲፍ እሼ ፍለቴ ሰነት ቶሉ ባቴ እን አከ እሼን ፉረምቱ ሃጎዹ። እን ዋን እሼፍ አመነሙ ዸቤፍ ደበርሴ ኦርመት እሼ ጉርጉሩፍ ምርገ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","ዮ እልመሳቲፍ እሼ ፍለቴሞ ምርገ እንተለ ኦፊሳቲፍ ኬኑ እሼፍስ ሃኬኑ። ");
INSERT INTO gaze_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","ዮ ኒቲ ብራ ፉዼሞ ኒቲሳ ከን ጀልቀባ ሰነ ኛተ፣ ኡፈታፊ ምርገ ኒቲፍ መሉ እት ህንህርእስን። ");
INSERT INTO gaze_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","ዮ እን ወንቶተ ሰደን ከኔን እሼፍ ጎቹ ድዴ ገሩ እሼን ከፈልቲ ማለቃ ቶኮ መሌ ብልሰ በኡ ቀብድ። ");
INSERT INTO gaze_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“ነምን ነመ ሩኩቴ አጄሱ እንስ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","እን ርጴ ኡቱ ህንኤገትን ዋቀቱ ሀርከሳ ቡሴ ዮ ተኤ ገሩ እዶ አን ረመዱት ሃበቀቱ። ");
INSERT INTO gaze_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","ገሩ ዮ ነምን ቶኮ እቱመ ያዴ ደባን ነመ አጄሴ እዶ ኣርሳኮ ብራ ፉዻቲ አጄሳ። ");
INSERT INTO gaze_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“ነምን አባሳ ዮካን ሃዸሳ ሩኩቱ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“ነምን ነመ ሀቴ ዮ ጉርጉረቴ ዮካን ነምች ሀተሜ ሱን ሀርከሳት ዮ አርገሜ ሀትች ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“ነምን አባሳ ዮካን ሃዸሳ አረብሱ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“ዮ ነሞትን ወል ሎለኒ እን ቶኮ እሰ ካን ዸጋዻን ዮካን አቦቴዻን ሩኩቴ ነምች ሩኩተሜ ሱን ዱኡ ባቴ ገሩ ስሬረት ሀፌ፣ ");
INSERT INTO gaze_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ኤርገሲሞ ዮ እን ከኤ ኡሌሳ ዸዻበቻ አሲፊ አች አለ ኬሰ ዴዴሜ ነምች እሰ ዸኤ ሱን እት ህንጋፈተሙ፤ ሰበቢ ዬሮ ነምቸ ሚዸሜ ሰና ጀላ በሌሴፍ ገሩ ገቲ ሃባሱ፤ ሀመ እን ጉቱማን ጉቱት ፈዩትስ እሰ ሃወልኣኑ። ");
INSERT INTO gaze_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“ዮ ነምን ቶኮ ኡሌዻን ገርብቸሳ ዮካን ገርብቲሳ ዸኤ ገርብች ሱንስ ሀርከሳት ዱኤ ነምች ሃአደበሙ፤ ");
INSERT INTO gaze_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","ገሩ ሰበቢ ገርብች ሱን ቀቤኘሳ ተኤፍ ዮ ገርብች ሱን ቡልቲ ቶኮ ዮካን ቡልቲ ለመ ቦዴ ከኤ፣ ነምች ህንአደበሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“ዮ ነሞትን ወል ሎላ ጅረን ዱበርቲ ኡልፎፍቴ ቶኮት ቡአኒ ኡልፊ ገራዻ በኤ ገሩ ሚዸምን ሀማን እሼ ህንቀቀብን፣ ነምች እሼ ሚዼ ሱን ዋን ዽርስ ዱበርትቲ እሰ ጋፈቴፊ ዋን አቦቲን ሙርቲ ሙርቴሰን ባሱ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","ዮ ሚዸምን ሀማን ጅራቴ ገሩ፣ ቆደ ሉቡ፣ ሉቡ፤ ");
INSERT INTO gaze_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","ቆደ እጃ፣ እጀ፤ ቆደ እልካኒ፣ እልካን፤ ቆደ ሀርካ፣ ሀርከ፤ ቆደ ሚላ፣ ሚለ፤ ");
INSERT INTO gaze_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","ቆደ ጉቡ፣ ጉቡ፤ ቆደ መዳ፣ መዳ፤ ቆደ ቡሩቅሱ፣ ቡሩቅሱ ባፍተ። ");
INSERT INTO gaze_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“ነምን ቶኮ ዮ እጀ ገርብቸሳ ዮካን እጀ ገርብቲሳ ሩኩቴ ጃምሴ፣ እን ቆደ እጀ ሰና ገርበ ሰነ ብልሰ ሃባሱ። ");
INSERT INTO gaze_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","እን ዮ እልካን ገርብቸሳ ዮካን እልካን ገርብቲሳ ሩኩቴ ጨብሴ፣ ቆደ እልካን ሰና ገርበ ሰነ ብልሰ ሃባሱ። ");
INSERT INTO gaze_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“ቆትዮን ቶኮ ዮ ዺረ ዮካን ዱበርቲ ወራኔ አጄሴ ቆትዮን ሱን ዸጋዻን ቱመሜ ሃአጄፈሙ፤ ፎንሳስ ህንኛተምን። ገሩ አባን ቆትዮ ሰና እት ህንጋፈተሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","ዮ ቆትዮን ሱን ዱሩማኑ አመለ ነመ ወራኑ ቀባቹንሳ ቤከሜ አባንሳስ አከ እሰ ኤገቱ ጎርፈሜ ገሩ ዋን እን እሰ ኤገቹ ድዴፍ ቆትዮን ሱን ዺረ ዮካን ዱበርቲ አጄሴ፣ ቆትዮን ሱን ዸጋዻን ሩኩተሜ ሃአጄፈሙ፤ አባን ቆትዮ ሰናስ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","ተኡስ እን ዮ ጉማ ጋፈተሜ ዋን ጋፈተሜ ሁንደ ከፈሌ ሉቡሳ ሃኦልፈቱ። ");
INSERT INTO gaze_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","ዮ ቆትዮን ሱን እልመ ዮካን እንተለ ቶኮ ወራኔሌ ሴሩመ ከነቱ ሆጄተ። ");
INSERT INTO gaze_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","ዮ ቆትዮን ሱን ገርብቸ ዮካን ገርብቲ ወራኔ አባን ቆትዮ ሰና ጎፍታ ገርበ ሰናቲፍ ሜቲ ሰቅሊ ሶዶመ ሃከፈሉ፤ ቆትዮን ሱንስ ዸጋን ሩኩተሜ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“ነምን ቶኮ ዮ ቦለ አፋን በና ዺሴ ዮካን ዮ ቦለ ቆቴ ኡቱ ህንዱችን ዺሴ ሰንጋን ዮካን ሀሬን ቦለ ሰነ ኬሰ ቡኤ፣ ");
INSERT INTO gaze_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","አባን ቦለ ሰና አባ ሆሪ ሰናቲፍ ማለቀ ሃባሱ፤ ሆሪን ዱኤ ሱንሞ ከንሳ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“ዮ ቆትዮን ነመ ቶኮ ቆትዮ ነመ ብራ ሚዼ ዱኣን ገኤ ጀር ቆትዮ ፈያ ሰነ ሃጉርጉረን፤ ገቲ ቆትዮ ሰናቲፊ ቆትዮ ዱኤ ሰነ ቅጤት ሃቆደተን። ");
INSERT INTO gaze_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","ዮ ቆትዮን ሱን ዱሩማኑ አመለ ሆሪ ወራኑ ቀባቹንሳ ቤከሜ ገሩ ዋን አባንሳ እሰ ኤገቹ ድዴፍ አባን ቆትዮ ሰና ቆደ ቆትዮ፣ ቆትዮ ሃባሱ፤ ቆትዮን ዱኤ ሱንሞ ከንሳ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“ነምን ቶኮ ዮ ሰንጋ ዮካን ሆላ ሀቴ ቀለቴ ዮካን ጉርጉረቴ፣ ቆደ ቆትዮ ቶኮ ሰንጋ ሸን፣ ቆደ ሆላ ቶኮሞ ሆላ አፉር ሃባሱ። ");
INSERT INTO gaze_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“ሀቱን ቶኮ ኡቱ ጨብሴ ሴኑ ዮ ቀበሜ ቱመሜ ከኑማን ዱኤ፣ ነምች እሰ አጄሴ ሱን ዺገሳት የካን ህንጋፈተሙ፤ ");
INSERT INTO gaze_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","ገሩ ዮ ወን ኩን ኤርገ አዱን ባቴ ተኤ፣ ነምች ዺገ ሰነት የካን ንጋፈተመ። “ሀቱን ዋን ሀቴ ሃዴብሱ፤ ሆማ ህንቀቡ ዮ ተኤ ገሩ ሀትነሳቲፍ ገቲ ባሱዻፍ ሃጉርጉረሙ። ");
INSERT INTO gaze_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","ሆሪን ሀተሜ ሱን ሰንጋ ዮካን ሀሬ ዮካን ሆላ ታናን ዮ ኡቱ ሉቡን ጅሩ ሀርከሳት አርገሜ ሀቱን ሱን ደቻ ባሱ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“ነምን ቶኮ ዮ ኡቱ ለፈ ቆቲሳ ዮካን ዻባ ወይኒ ኬሰ ሆሪ ትክፈቱ ሆሪሳ ገድ ለክሴ ሆሪን ሱን ዸቄ ከሎ ነመ ብራ ዼዴ፣ እን ለፈ ቆቲሳ ኦፊሳራ ዮካን ዻባ ወይኒ ኦፊሳራ ከን ዋን ሁንደ ጫሉ እዶ ሃቡሱፍ። ");
INSERT INTO gaze_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“ዮ እብድ ከኤ ደገለ ሴኔ አከሲን ምዻን ቱለሜ ዮካን ምዻን ዻበቱ ዮካን ለፈ ቆቲሳ ጉቤ፣ ነምች እብደ ቀብሲሴ ሱን ገቲ ባሱ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“ነምን ቶኮ ዮ ማለቀ ዮካን ምአ እማና ነመት ኬነቴ፣ ወን ሱን መነ ነምቻቲ ሀተሜ ሀቱን ሱን ቀበሜ፣ ሀትች ደቻ ከፈሉ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","ዮ ሀቱን ሱን ህንአርገምን ገሩ አባን መነ ሰና አከ ምአ ነመ ካኒ ቱቄፊ አከ ህንቱቅን ምርከኔሱፍ ፉለ አቦቲ ሙርቲ ዱረት ሃዽኤፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","ነምን ቶኮ ዮ ቆትዮ፣ ሀሬ፣ ሆላ፣ ኡፈተ ዮካን ምአ በዴ ቶኮ ምልቅሴ ነምን ቶኮ ዹፌ፣ ‘ኩን ከንኮት’ ጄዼ፣ ፈልሚንሳኒ ፉለ አቦቲ ሙርቲ ዱረት ሃዽኤፈሙ። ነምች አቦቲን ሙርቲ እት ሙረን ሱንስ ኦላሳቲፍ ሀርከ ለመ ሃባሱ። ");
INSERT INTO gaze_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“ዮ ነምን ቶኮ ኦላሳቲፍ ሀሬ፣ ቆትዮ፣ ሆላ ዮካን ሆሪ ብራ እማና ኬነቴ ሆሪን ሱን ኡቱ ነምን ህንአርግን ዱኤ ዮካን ሚዸሜ ዮካን ሀተሜ፣ ");
INSERT INTO gaze_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","ነምች ሱን አከ ቀቤኘ ኦላሳ ህንቱቅን ምርከኔሱፍ ፉለ ዋቀዮ ዱረት ሃከከቱ፤ አባን ቀቤኛ ሱንስ ከኩ ከነ ፉዸቹ ቀበ፤ ገቲስ ህንጋፈቱ። ");
INSERT INTO gaze_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","ዮ ሆሪን ሱን እሰ ጀላ ሀተሜ ጅራቴ ገሩ ነምች አባ ሆሪ ሰናቲፍ ባሱ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","ዮ ሆሪ ሰነ ብኔንሰቱ ኛቴ ተኤሞ አከ ረጋ ተኡፍ ዋን ብኔንሰራ ሀፌ ሃዽኤሱ መሌ ሆሪ ኛተሜ ሰናፍ ገቲ ህንባስን። ");
INSERT INTO gaze_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“ነምን ቶኮ ዮ ኦላሳራ ሆሪ ኤርግፈቴ ሆሪን ሱን እዶ አባን ሆሪ ህንጅሬት ሚዸሜ ዮካን ዱኤ፣ ነምች ኤርግፈቴ ሱን ገቲ ሃባሱ። ");
INSERT INTO gaze_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","ዮ አባን ሆሪ ሰና አች ጅራቴ ገሩ ነምች ኤርግፈቴ ሱን ገቲ ባሱ ህንቀቡ። ዮ ሆሪን ሱን ክሬፈሜ ጅራቴሞ ማለቅን ባፈሜ ሱን ክራ ሆሪ ዱኤ ሰና ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“ነምን ቶኮ ዮ ዱርበ ህንካዽመተምን ጎዎምሴ እሼ ወጅን ጪሴ፣ እን ገበረ ምስርቲፍ መሉ ባሴፊ እሼ ሃፉዹ። ");
INSERT INTO gaze_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","ዮ አባንሼ እንተለቲ ነምቻፍ ኬኑ ድዴሞ ነምች ሱን ገበረ ዱርባፍ መሉ ባሱ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“አት አከ ዱበርቲን ፈልፈልቱን ሉቡን ጅራቱ ህንኤየምን። ");
INSERT INTO gaze_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“ነምን ሆሪ ወጅን ጪሱ ከምዩ አጄፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“ነምን ዋቀዮ ቶክቻፍ መሌ ዋቀ ብራቲፍ ኣርሳ ዽኤሱ ገላፈተሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“እስንስ ዋን ብየ ግብጢ ኬሰት አለጎተ ቱርተኒፍ አለጋት ደበ ህንሆጄትና፤ ህንጩንቁርስናስ። ");
INSERT INTO gaze_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“ሃዸ ህዬሳቲፊ እጆሌ አባንራ ዱኤ ህንሀጩጭና። ");
INSERT INTO gaze_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","ዮ እስን እሳን ሚተኒ እሳንሞ ነት ቦአን አን ዹጉማን ቦእቸሳኒ ነንዸገአ። ");
INSERT INTO gaze_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","ኣሪንኮ ንቦበአ፤ አንስ ጎራዴዻነን እስን ፍጠ፤ ኒቶትንኬሰን ሃዾተ ህዬሳ ተኡ፤ እጆሌንኬሰንስ ከኔን አባ ህንቀብኔ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“አት ዮ ሰበኮ ኬሳ ህዬሰ ስ ብረ ጅራቱ ቶኮፍ ማለቀ ልቄስቴ፣ አከ ነመ ሂቂ አርገቹፍ ኬኑ ህንተእን፤ ዸለስ ህንጋፈትን። ");
INSERT INTO gaze_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","አት ዮ ወያ ነመ ብራ ቀብዲ ቀበቴ፣ ኡቱ አዱን ህንዽእን ዴብሲፍ፤ ");
INSERT INTO gaze_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","ወን እን ዸግነሳት ኡፈቱ ወዩመ ሰናቲ። ወን እን ኡፈቴ ረፉ ብራ ማል? አን ዋነን ገረ ላፌሰ ተኤፍ፣ ዮ እን ነት ኦል እየቴ ነንዸገአ። ");
INSERT INTO gaze_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“ዋቀ ህንአረብስን፤ ቡልቻ ሰበኬቲስ ህንአባርን። ");
INSERT INTO gaze_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“መታ ምዻንኬቲቲፊ ዸንገለኣ ወይኒኬቲራ ኣርሳ ዽኤሱ ህንቱርስን። “እልማንኬ ኬሳስ ሀንገፈ ና ኬኑ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","ሎንኬቲፊ ሆሎተኬ አከኑመ ጎዽ። እሳንስ ቡልቲ ቶርበ ሃዸሳኒ ብረ ሃቱረን፤ ጉያ ሰዴተፋት ገሩ ና ኬን። ");
INSERT INTO gaze_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“እስን ሰበኮ ቁልቁሉ ንታቱ። ከናፉ ፎን ሆሪ ብኔንስ አለት ጨብሴ ከምዩ ህንኛትና፤ ፎን አከና ሰሬ ዱረ ቡሳ። ");
INSERT INTO gaze_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“ኦዱ ሶባ ህንኦዴስን፤ ዹገ በኡ ጀልኣ ኬኑዻን ነመ በሌሳ ሆጄቴ ህንገርጋርን። ");
INSERT INTO gaze_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“ዋን ሀማ ሆጄቹፍ ጄቴ ነመ ባይኤ ፋነ ህንቡእን። ፉለ ሴራ ዱረት ዮሙ ዹጋ ባቱ፣ ገረ ነመ ባይኤ ጎርቴ ሙርቲ ህንጀልእስን፤ ");
INSERT INTO gaze_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","ሙርቲረት ህዬሳፍ ህንሎግን። ");
INSERT INTO gaze_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“ዮ ሰንጋ ዮካን ሀሬ ዲነኬቲ ከን በዱት ጅሩ አርግቴ ዴብሲ ጌሲፍ። ");
INSERT INTO gaze_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","ዮ ሀሬ ነመ ስ ጅቡ ቶኮ ኡቱ እሼን በኣ ባቴ ኩፍቴ ጅርቱ አርግቴ አችት ህንዺስን፤ እሰ ገርጋሪ ኦል ካስ። ");
INSERT INTO gaze_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“ሙርቲረት ህዬሰ ሰበኬቲ ጀላ ሙርቲ ህንደብስን። ");
INSERT INTO gaze_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","ህመተ ሶባ ኬሰት ህንህርማትን፤ ዋን አን ነመ በሌሳ ሆጄቴ ህንቁልቁሌስኔፍ ነመ የከ ህንቀብኔ ዮካን ነመ ቀጄላ ህንአጄስን። ");
INSERT INTO gaze_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“አት መተኣ ህንፉዸትን፤ መተኣን ኦጌዪ ንጃምሳቲ፤ ዱቢ ቀጄልቶታስ ጀልእሰ። ");
INSERT INTO gaze_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“አለጋ ህንጩንቁርስን፤ እስን ዋን ብየ ግብጢት አለጋ ቱርተኒፍ አለጋ ተኡን ማል አከ ተኤ እስን መታንኬሰን ንቤክቱቲ። ");
INSERT INTO gaze_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“ወጋ ጀአ ለፈ ቆቲሳኬ ፈጫፈዹ፤ ምዻንስ ገልፈዹ፤ ");
INSERT INTO gaze_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","ወጋ ቶርበፋት ገሩ ለፈ ሰነ ቦቆቺስ መሌ ህንቆትን። አከሲን ህዬዪን ሰበኬቲ ለፍቸራ ኛተ አርገቱ፤ ዋን እሳንራ ሀፌሞ ብኔንስ ሃኛቱ። ሙከ ወይኒኬቲቲፊ ሙከ ኤጄርሰኬቲስ አከሱመ ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“ጉያ ጀአ ሆጂኬ ሆጄተዹ፤ አከ ሰንጋንኬቲፊ ሀሬንኬ ቦቆተኒፍ፣ አከ ገርብች መነኬት ዸለቴፊ አለጋን ኣረ ገልፈተኒፍ ጉያ ቶርበፋት ህንሆጄትን። ");
INSERT INTO gaze_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“ዋን አን እስንት ህሜ ሁንደ ኤጋ፤ መቃ ዋቆተ ብራ ህንዋመትና፤ አፋንኬሰኒዩ ህንበእን። ");
INSERT INTO gaze_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“አት ወጋት ዬሮ ሰዲ አያነ ና አያኔፈዹ። ");
INSERT INTO gaze_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“አያነ መጥኖ አያኔፈዹ፤ አኩመ አን ስ አጀጄ ሰነ ቡልቲ ቶርበ መጥኖ ኛዹ። ዋን ከነስ ጅአ አቢቢ ኬሰ ዬሮ ሙርታኤት ጎዽ፤ አት ጅአ ሰነ ኬሰ ግብጢ ባቴቲ። “ነምን ቶኮዩ ሀርከ ዱዋ ፉለኮ ዱረት ህንዽኣትን። ");
INSERT INTO gaze_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“መታ ምዻንኬቲ ከን ለፈ ቆቲሳኬት ፈጫፈቴን አያነ ገልቻ ምዻኒ አያኔፈዹ። “ዹመ ወጋት ዬሮ ምዻንኬ ለፈ ቆቲሳራ ወልት ቀበቱት አያነ ገልቻ ምዻኒ አያኔፈዹ። ");
INSERT INTO gaze_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“ዺር ሁንድ ወጋት ዬሮ ሰዲ ፉለ ዋቀዮ ጎፍታ ዱረት ሃዽኣቱ። ");
INSERT INTO gaze_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“ዺገ ኣርሳ ዋን ራጭቲ ቀቡ ወጅን ና ህንዽኤስን። “ጮምን ኣርሳ አያነኮስ ሀመ በሪት ህንቱርን። ");
INSERT INTO gaze_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“መታ ምዻን ለፈኬቲ ኬሳ ፍለተማሳ ገረ መነ ዋቀዮ ዋቀኬቲ ፍድ። “እልሞ ሬኤ ኣነን ሃዸሼቲን ህንአፌልን። ");
INSERT INTO gaze_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“አከ እን ከራረት ስ ኤጌ እዶ አን ቆጴሴት ስ ገልቹፍ ኩኖ አን ፉለኬ ዱረ ኤርገማኮ ቶኮ ነንኤርገ። ");
INSERT INTO gaze_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","ጥዬፈዹቲ ዋን እን ጄዹ ዸጌፈዹ። እሰት ህንፍንጭልን፤ እን ዋን መቃኮ ኦፍራ ቀቡፍ ፍንጭለኬ ሲፍ ህንዺሱቲ። ");
INSERT INTO gaze_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","ዮ አት ዋን እን ጄዹ አከ ጋሪ ዸጌፈቴ ዋን አን ዱበዹ ሁንደ ጎቴ፣ አን ዲኖተኬት ዲነ ነንተአ፤ ወረ ሲን ሞርመኒንስ ነንሞርመ። ");
INSERT INTO gaze_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","ኤርገማንኮስ ፉለኬ ዱረ ዴሜ ብየ አሞሮታት፣ ሄቶታት፣ ፌርዞታት፣ ከነኣኖታት፣ ሂዎታቲፊ ዬቡሶታት ስ ገልቸ፤ አንስ ጀረ ነንበሌሰ። ");
INSERT INTO gaze_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","ዋቆተሳኒቲፍ ህንሰገድን፤ ህንዋቄፈትንስ፤ ሆጂሳኒ ፋነስ ህንቡእን። አት እሳን በሌስቴ ሶዱ ዋቄፈትናሳኒሌ ጨጨብሱ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","ዋቀዮ ዋቀኬ ዋቄፈዹ፤ እንስ ምዻንኬቲፊ ብሻንኬ ንኤብሰ። ዹኩበስ እስን ግዱዻ ነንበሌሰ፤ ");
INSERT INTO gaze_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","ብየኬ ኬሰት ዱበርቲን ኡልፍ እራ በኡ ዮካን ዸብዱን ቶኮዩ ህንአርገምቱ። ጅሬኘ ጉቱስ ሲፍ ነንኬነ። ");
INSERT INTO gaze_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“አን ሶዳችሱኮ ስ ዱረ ኤርጌ ሰበ አት እት ዹፍቱ ሁንደ ነንቡርጃጄሰ። አከ ዲኖትንኬ ሁንድኑ ዱግደ ስት ገለኒ በቀተንስ ነንጎዸ። ");
INSERT INTO gaze_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","አከ እን ሂዎተ፣ ከነኣኖታፊ ሄቶተ ከራኬራ አርኡፍ አን ስ ዱራን ሶንሰ ነንኤርገ። ");
INSERT INTO gaze_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","አከ ለፍት ኦኔ ብኔንስ ወል ሆሬ ስት ህንባይአኔፍ አን ወጋ ቶኮ ኬሰት ሰበ ከነ ስ ዱራ አርኤ ህንባሱ። ");
INSERT INTO gaze_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","ሀመ አት ባይአቴ ብየቲ ዻልቱት አን ጥኖ ጥኖን ፉለኬ ዱራ እሳን ነንባሰ። ");
INSERT INTO gaze_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“አንስ ዳሪኬ ገላነ ዲማዻ ጀልቀቤ ሀመ ገላነ ፍልስጤሚት፣ ለፈ አሎቲ ጀልቀቤ ሀመ ለገ ኤፍራጢሲት ሲፍን ዻበ። ነሞተ ብየ ሰነ ጅራተንስ ደበርሴ ሀርከኬት ነንኬነ፤ አትሞ ኦፍ ዱራ አሪቴ እሳን ባፍተ። ");
INSERT INTO gaze_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","አት እሳን ወጅን ዮካን ዋቆተሳኒ ወጅን ከኩ ቶኮሌ ህንገልን። ");
INSERT INTO gaze_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","አከ እሳን ብየኬ ኬሰ ጅራተን ህንኤየመኒፍ፤ ዮ አከስ ተኤ እሳን አከ አት ጩቡ ነት ሆጄቱ ስ ጎዹ፤ አት ዋቆተሳኒ ዋቄፈትናን ኩን ዹጉማን ክዮ ስት ተኣቲ።” ");
INSERT INTO gaze_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አቲፊ አሮን፣ ናዳቢፊ አቢሁ፣ ማንጉዶተ እስራኤል ኬሳስ ነሞትን ቶርባተምን ገረ ዋቀዮት ኦል በኣ፤ አላለት ሰገዳ፤ ");
INSERT INTO gaze_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","ገሩ ሙሴን ቆፍት ዋቀዮት ሃዽኣቱ፤ ወር ካንሞ ህንዽኣትን። ሰብን እሰ ወጅን ኦል ህንበእን።” ");
INSERT INTO gaze_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","ሙሴንስ ዸቄ ዱቢፊ ሴረ ዋቀዮ ሁንደ ሰበ ሰነት ህሜ፤ ሰብን ሱንስ፣ “ኑ ዋን ዋቀዮ ጄዼ ሁንደ ንጎነ” ጄዼ አፋን ቶኮን ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","ኤርገሲ ሙሴን ዋን ዋቀዮ ዱበቴ ሁንደ በሬሴ። ጉያ እት ኣኑ ገነማንስ ከኤ ሚለ ቱሉ ጀለት እዶ ኣርሳ እጃሬ፤ ኡቱባ ዸጋ ኩዸ ለመ ከኔን ጎሶተ እስራኤል ኩዸ ለማን እዶ ቡአንስ ዻቤ። ");
INSERT INTO gaze_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","እንስ ደርገጎተ እስራኤል ኤርጌ፤ እሳንስ ኣርሳ ጉበሙፊ ጅቦተ ኣርሳ ነጋ ጎዸኒ ዋቀዮፍ ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","ሙሴንስ ወለካ ዺገ ሰና ወጪቲት ነቄ፤ ወለካ ሀፌሞ እዶ ኣርሳረት ፈፈጫሴ። ");
INSERT INTO gaze_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","እንስ ክታበ ከኩ ፉዼ ሰበ ሰናፍ ዱብሴ። እሳንስ፣ “ኑ ዋን ዋቀዮ ጄዼ ሁንደ ንጎነ፤ ንአጀጀምነስ” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","ዮሙስ ሙሴን ዺገ ሰነ ፉዼ ሰበት ፈፈጫሴ፣ “ኩኖ ኩን ዺገ ከኩ ከን ዋቀዮ አኩመ ዱቢ ከነ ሁንዳት እስኒ ዻቤዸ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","ሙሴፊ አሮን፣ ናዳቢፊ አቢሁ፣ ማንጉዶትን እስራኤል ቶርባተምንስ ኦል በአኒ ");
INSERT INTO gaze_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","ዋቀ እስራኤል አርገን። ሚለሳ ጀለትስ ዋን አከ አፋ ዸጋ ሰንፔር ከን አኩመ ሰሚት ቁልቁላኤ ቶኮቱ አፈሜ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","ዋቅን ገሩ ቆንዳልቶተ ሰበ እስራኤል ከኔንት ሀርከሳ ኦል እት ህንካፍኔ፤ እሳን ዋቀ አርገን፤ ንኛተን፤ ንዹገንስ። ");
INSERT INTO gaze_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","ዋቀዮስ ሙሴዻን፣ “ገረኮት ቱሉት ኦል በእ፤ አስስ ቱር፤ አንስ ገበቴወን ዸጋ ከኔን አን አከ ቀጄልፈመሳኒ ተኡፍ ሴራፊ አጀጀወን እት በሬሴ ሲፍ ነንኬነ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","ኤርገሲ ሙሴን ገርጋራሳ እያሱ ወጅን ከኤ ዴሜ፤ ሙሴንስ ቱሉ ዋቃት ኦል በኤ። ");
INSERT INTO gaze_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","እንስ ማንጉዶተ ሰናን አከነ ጄዼ፤ “ሀመ ኑ ገረኬሰንት ዴብኑት አስት ኑ ኤጋ። ኩኖ አሮኒፊ ሁር እስን ብረ ጅረን፤ ነምን ፈልሚ ቀቡ እሳን ብረ ዸቁ ደንደአ።” ");
INSERT INTO gaze_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","ዬሮ ሙሴን ቱሉት ኦል በኤት ዱሜስ ቱሉ ሰነ ሀጉጌ፤ ");
INSERT INTO gaze_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ኡልፍን ዋቀዮስ ቱሉ ሲናረ ቡኤ። ዱሜስ ሱንስ ጉያ ጀአ ቱሉ ሰነ ሀጉጌ፤ ጉያ ቶርበፋትሞ ዋቀዮ ዱሜስቸ ኬሳ ሙሴ ዋሜ። ");
INSERT INTO gaze_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","ኡልፍን ዋቀዮስ እብደ ዋ ጉቡ ፈካቴ ፊጤ ቱሉራ ሰበ እስራኤልት ሙልአቻ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","ሙሴን ቱሉት ኦል በኤ ዱሜሰ ኬሰ ሴኔ። እንስ ጉያ አፉርተማፊ ሀልከን አፉርተመ ቱሉ ሰነረ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“አከ እሳን ኬና ና ፍደኒፍ ሰበ እስራኤልት ህም። ነመ ገራሳ ጉቱዻን ኬኑ ፌዹ ሁንደ ሀርካ ኬና ና ፉዻ። ");
INSERT INTO gaze_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“ኬናን እሳን ሀርካ ፉተንስ፦ “ወርቄ፣ ሜቲፊ ናሲ፤ ");
INSERT INTO gaze_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ወያ ሀጲ ቁንጬ ተልባራ ሆጄተሜ፤ ርፌንሰ ሬኤ፤ ");
INSERT INTO gaze_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","ጎጋ ኮርቤሰ ሆላ ከን ሀሉ ዲማ ጩጰሜ፣ ጎጋ ዱገሜ፣ ሙከ ላፍቶ፣ ");
INSERT INTO gaze_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","እብሳዻፍ፣ ዘይቲ ኤጄርሳ፣ ኡርጎፍቱወንሞ ዘይቲ ድበተሙፊ እጣነ ኡርጋኡፍ፤ ");
INSERT INTO gaze_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","ዸጋወን ሰርዶንክሲ፣ ዶቀ ገት ጀቤሰ፣ ድረታፊ ቆሜረት ካአተሙዸ። ");
INSERT INTO gaze_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“ኤርገሲ አከ እሳን እዶ ቁልቁሉ ና ቆጴሰን ጎዽ፤ አንስ ግዱሳኒ ነንጅራዸ። ");
INSERT INTO gaze_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","ዱንካነ ቁልቁሉ ከናፊ ምአሳ ሁንደ አኩመ ብፈ አን ስት አርግሲሱት ሆጄዻ። ");
INSERT INTO gaze_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“እሳን ሙከ ላፍቶራ ታቦተ ሃቶልቸን፤ ታቦትን ሱንስ ዹንዹመ ለማፊ ወለካ ዼረተ፤ ዹንዹመ ቶኮፊ ወለካ በልአተ፤ ዹንዹመ ቶኮፊ ወለካ ኦል ዼረተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","ኬሳፊ ዱበሳት ወርቄ ቁልቁሉ ኡፍስ፤ ናኖ እሳትስ መርሳ ፋየ ወርቄ ናኔሲ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","ታቦተ ሰናፍስ ቁቤላ ወርቄ አፉር ቶልቺቲ ሚለሳ አፍረንት ጄቹንስ ለመ ገመ ቶኮን፣ ለመሞ ገመ ካኒን እት ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","ሙከ ላፍቶራ ደንቀራወን ቶልቺቲ ወርቄ እት ኡፍስ። ");
INSERT INTO gaze_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","ታቦትቸ እቲን ባቹዻፍ ደንቀራወን ሰነ ቁቤላወን ኬሰ ሎስ። ");
INSERT INTO gaze_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","ደንቀራወን ኩኔን ቁቤላወን ታቦትቻ ኬሰ ሃቱረን፤ ኬሳ ባፈሙስ ህንቀበን። ");
INSERT INTO gaze_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","አትስ ዹገ በኡምሰ አን ስት ኬኑ ታቦትቸ ኬሰ ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“ወርቄ ቁልቁሉራ ቴሶ አራራ ቶልች፤ ዼርንሳስ ዹንዹመ ለማፊ ወለካ፣ በልእንሳሞ ዹንዹመ ቶኮፊ ወለካ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","ሞጋ ለማን ቴሶ አራራረት ወርቄ ቱመሜራ ኪሩቤሊ ለመ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","ኪሩቢ ቶኮ ሞጋ ቶኮረት፣ ኪሩቢ ለመፋሞ ሞጋ ካንረት ቶልች፤ ኪሩቤሊ ሰነስ ቴሶ አራራ ወጅን ኩታ ወርቄ ቶክቸራ ሞጋ ለማንረት ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","ኪሩቤሊን ሱን ቆቾሳኒ ኦል በልእፈተኒ ቴሶ አራራ እቲን ሃጋድሴሰን፤ ኪሩቤሊን ኩኔን ፉለሳኒ ወልት ገረገልፈተኒ ቴሶ አራራ ሃእላለን። ");
INSERT INTO gaze_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","ቴሶ አራራ ሰነ ታቦትቸረ ካእ፤ ዹገ በኡ አን ስት ኬኑሞ ታቦትቸ ኬሰ ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","አን አችት ስ አርገ፤ ቴሶ አራራራ፣ ኪሩቤሊ ለማን ታቦተ ከኩ ሴራረ ጅረን ግዱዻ ዋኤ አጀጀወን አን ሰበ እስራኤሊቲፍ ስት ኬኑ ሁንዳ ስትን ህመ። ");
INSERT INTO gaze_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“ሙከ ላፍቶራ ምንጃለ ዹንዹመ ለመ ደልገ ዼረቱ፣ ከን ዹንዹመ ቶኮ በልአቴ ኦል ዼርንሳሞ ዹንዹመ ቶኮፊ ወለካ ተኤ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","ወርቄ ቁልቁሉ እት ኡፍሲቲ ናኖሳት መርሳ ወርቄ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","ናኖሳረትስ ህዺ ሀመ በልእነ ሀርካ ገኡፊ ፋየ ወርቄ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","ምንጃለ ከናፍስ ቁቤላ ወርቄ አፉር ሆጄዹቲ ጎሌወን አፍረንት እዶ ሚል አፍረን ጅረንት ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","ቁቤላወን ኩኔንስ አከ ደንቀራ እቲን ምንጃለ ባተን ቀበተኒፍ ጥዮ ሰነት ዽኣቹ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","ሙከ ላፍቶራ ሎሰወን ቶልች፤ ወርቄ እት ኡፍሲቲ ምንጃለ ሰነ እቲን ባዹ። ");
INSERT INTO gaze_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","ዽባዩ ዽኤሱፍስ ጫቢወንሳ፣ ወጪቲወንሳ፣ ኦኮቴወንሳቲፊ ወጪቲወንሳ ወርቄ ቁልቁሉራ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","ቡዴነ እላልቻስ ዬሮ ሁንደ ፉለኮ ዱረ ምንጃለ ከነረ ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“ባቱ እብሳስ ወርቄ ቁልቁሉራ ቶልች፤ ባቱን እብሳ ኩንስ ቱመሜ ሃቶልፈሙ፤ ሶማሳ፣ ደሜሳ፣ ወጪቲሳ፣ ሁዻሳቲፊ ደራራሳ ወርቄዹመ ሰነራ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","ብታ ምርገ ባቱ እብሳ ሰነ ኬሳስ ደሜወን ጀአ ጄቹንስ ሰዲ ገመ ቶኮን፣ ሰዲሞ ገመ ካኒን ሃባፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","ጦፎወን ለዉዚ ፈካተን ከኔን ቶኮን ቶኮንሳኒ ሁዻፊ ደራራ ቀበን ሰዲ ደሜ ቶኮረት፣ ወጪቲወን ለዉዚ ፈካተን ከኔን ቶኮን ቶኮንሳኒ ሁዻፊ ደራራ ቀበን ሰዲሞ ደሜ ካንረት ቶልች፤ ደሜወን ጀኣን ባቱ እብሳራ በበአን ሁንደረትስ አከሱመ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","ጦፎወን ሁዻፊ ደራራ ቀበን ከኔን ብፈ ለዉዚቲን ሆጄተመን አፉር ባቱ እብሳ ሰነረ ሃጅራተን። ");
INSERT INTO gaze_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","ሁዻን ቶኮ ጭምዲ ጀልቀባ ከን ደሜወን ባቱ እብሳራ በበአን ጀለ፣ ሁዻን ለመፋን ጭምዲ ለመፋ ጀለ፣ ሁዻን ሰደፋንሞ ጭምዲ ሰደፋ ጀለ ቱሬ። ወሉማ ገለት ደሜወን ጀአቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","ሁዻወኒፊ ደሜወን ሁንድኑ ባቱ እብሳ ሰነ ወጅን ወርቄዹመ ቁልቁሉ ቱመሜ ቶኮራ ሃቶልፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“አትስ እብሳወን ቶርበ ቶልቺፍ፤ አከ ለፈ ፉለሳኒ ዱረ ጅሩ እብሰኒፍስ ባቱ እብሳረ እሳን ዸዻብ። ");
INSERT INTO gaze_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","ወን እቲን ዳራሳ ዸዸአኒፊ ጫቢን ዳራ ሰነ ባቱ ወርቄ ቁልቁሉራ ሃሆጄተመን። ");
INSERT INTO gaze_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","ባቱን እብሳቲፊ ምእሳ ሁንድ ወርቄ ቁልቁሉ ታላንቲ ቶኮቲን ሃሆጄተመን። ");
INSERT INTO gaze_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","አትስ አኩመ ፈኬኘ ቱሉረት ስት አርግሲፈሜ ሰናት ሆጄቹኬ ምርከኔፈዹ። ");
INSERT INTO gaze_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“ጎልጋወን ኩዸን ከኔን ቁንጬ ተልባ ጋሪ ፎአሜፊ ከን ክሪ ብፈ ጩቁሊሳ፣ ዺልጌፊ ብልዲማራ ሆጄተመኒን ዱንካነ ቁልቁሉ ሆጄዹ፤ ጎልጋወን ሰነረትስ ኦጌስ ሀርከ ቀጄሉ ቶኮ ኪሩቤሊ ሃሆጄቱ። ");
INSERT INTO gaze_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","ጎልጋወን ሁንድኑ ወል ቅጤ ሃተአን፤ ዼርን ቶኮ ቶኮ ጎልጋወኒ ዹንዹመ ድግደሚ ሰዴት፣ በልእንሳሞ ዹንዹመ አፉር ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","ጎልጋወን ሸን ወልት ቀብሲስ፤ ጎልጋወን ሀፈን ሸነን ካንሌ አከሱመ ወልት ቀብሲስ። ");
INSERT INTO gaze_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","ጎልጋወን ወልት ቀብሲፈመን ከኔን ጀልቀባ ኬሳ ሀንዳረ እሰ ሞጋረት ሁጩ ብፈ ጩቁሊሳራ ጉሮወን ቶልች፤ ጎልጋወን ወልት ቀብሲፈመን ለመፋረትስ አከሱመ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","ጉሮወን ሸንተመ ጎልጋ ቶኮረት ቶልች፤ ጉሮወን ሸንተመሞ ጎልጋወን ወልት ቀብሲፈመን ለመፋ ኬሳ ሞጋ እሰ ቶኮት ቶልች። ጉሮወን ሱንስ ገማ ገመነት ሃቶልፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","አከ ዱንካን ቁልቁሉን ሱን ቶኮ ተኡፍስ ሆኮወን ወርቄ ሸንተመ ቶልቺቲ ጎልጋወን ሰነ እቲን ወልት ቀብሲስ። ");
INSERT INTO gaze_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“ሀጉጊ ጉባ ዱንካነ ቁልቁሉረ ጅሩ ሀጉጉፍስ ጎልጋወን ርፌንሰ ሬኦታ ኩዸ ቶኮ ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","ጎልጋወን ኩዸ ቶኮን ሱን ሁንድ ወል ቅጤ ሃተአን፤ ዼርንሳኒ ዹንዹመ ሶዶመ፣ በልእንሳኒሞ ዹንዹመ አፉር ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","ጎልጋወን ሸን እዶ ቶኮት ወልት ቀብሲስ፤ ጎልጋወን ጀአን ካንሞ እዶ ቶኮት ወልት ቀብሲስ፤ ጎልጋ ጀአፋ ሰነስ ፉለ ዱንካንቻ ዱራን እዶ ለመት ኦል ደቻስ። ");
INSERT INTO gaze_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","ጎልጋወን ገመ ቶኮን ወልት ቀብሲፈመን ኬሳ ሀንዳረ እሰ ሞጋረት ጉሮወን ሸንተመ ቶልች፤ ጎልጋወን ገመ ካንረት ወልት ቀብሲፈመን ኬሳስ ሀንዳረ እሰ ሞጋረት ጉሮወን ሸንተመ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","ኤርገሲስ ቀብዱወን ናሲ ሸንተመ ቶልች፤ ቀብዱወን ሰነስ አከ እን ቶኮ ተኡፍ እቲን ወልት ቀብሲሱፍ ጉሮወን ኬሰ ገልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","ወን ጎልጋወን ዱንካንቻራ ሀፌ፣ ወለካን ጎልጋ ሀፌ ሰና ዱግደ ዱንካነ ቁልቁሉ እራን ገድ ሃረረኡ። ");
INSERT INTO gaze_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","አከ ዱንካነ ቁልቁሉ ሰነ ሀጉጉፍስ ዼርነ ጎልጋወን ዱንካንቸራ ሀፌ ኬሳ ዹንዹምን ቶኮ ገመ ቶኮን፣ ዹንዹምን ቶኮሞ ገመ ካኒን ብታፊ ምርጋን ዱንካነ ቁልቁሉ እራን ገድ ሃረረኡ። ");
INSERT INTO gaze_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","ዱንካነ ሰናፍስ እረ ቡሳ ከልዼ ኮርቤሰ ሆላ ከን ሀሉ ዲማ ጩጰሜ፣ እሰ እራንሞ እረ ቡሳ ጎጋ ዱገሜ ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“ዱንካነ ቁልቁሉ ሰናፍስ ሙከ ላፍቶራ ቱጌወን ቀቀጄሎ ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","ዼርን ቶኮ ቶኮ ቱጌወን ሰናስ ዹንዹመ ኩዸን፣ በልእንሳሞ ዹንዹመ ቶኮፊ ወለካ ሃተኡ፤ ");
INSERT INTO gaze_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","ቶኮን ቶኮን ቱጌወን ሰናስ አከ ወል ኬሰ ገሉ ደንደኡፍ ሙቸ ለመ ለመ ሃቀባቱ፤ ቱጌወን ዱንካነ ቁልቁሉ ሰና ሁንደ አከስት ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","ገመ ክበ ዱንካነ ቁልቁሉ ሰናቲፍስ ቱጌወን ድግደመ ሆጄዹ፤ ");
INSERT INTO gaze_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","ቱጌወን ድግደመን ሰነ ጀለት ሚለ ሜቲ አፉርተመ ጄቹንስ ቱጌ ቶኮ ጀለት ሚለ ለመ ጉረሳ ለማኒፍ፣ ቱጌ ካን ጀለትስ ሚለ ለመ ጉረሳ ለማኒፍ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","ገመ ዱንካነ ቁልቁሉ ሰና ካኒፍስ ከራ ካባቲን ቱጌወን ድግደመ ቶልች፤ ");
INSERT INTO gaze_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","ሚለ ሜቲስ አፉርተመ ጄቹንስ ቱጌ ቶኮ ጀለት ሚለ ለመ፣ ቱጌ ካን ጀለትስ ሚለ ለመ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","ከራ ልጠ ቢፍቱቲን፣ ዱግደ ዱበ ዱንካነ ቁልቁሉ ሰናቲፍ ቱጌ ጀአ ቶልች፤ ");
INSERT INTO gaze_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","ከራ ዱግደ ዱባስ ጎሌ ዱንካነ ቁልቁሉ ሰናቲፍ ኡቱባ ለመ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","ቱጌወን ጎሌ ኩኔን ጀላ ሀመ ጉባት ወልት ፈይፈመኒ በንቲረት ቁቤላ ቶኮን ወልት ሃቀብሲፈመን፤ ቱጌወን ጎሌ ለማኒስ አከሱመ ተኡ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","ከናፉ ቱጌወን ሰዴት ከኔን ሚለ ሜቲ ኩዸ ጀአ ቀበንቱ ጅረ፤ ቶኮን ቶኮን ቱጌ ሰናስ ሚለ ለመ ለመ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“አከሱመስ ሙከ ላፍቶራ ደገሌወን ቶልች፤ ቱጌወን ዱንካነ ቁልቁሉ ሰነረ ገመ ቶኮን ጅረኒፍ ደገሌወን ሸን፣ ");
INSERT INTO gaze_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","ቱጌወን ገመ ካኒን ጅረኒፍ ደገሌወን ሸን፣ ሸን ቱጌወን ዱግደ ዱባን ከራ ልጠ ቢፍቱቲን ጅረኒፍሞ ደገሌወን ሸን ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","ደገሌ ወለካ ጅሩ ሰነ አከ እን ግዱ ቱጌወኒቲን ሞጋ ቶኮ ሀመ ሞጋ ካኒት ፉለኡ ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","ቱጌወን ሰነረስ ወርቄ እት ኡፍስ። አከ ደገሌወን ባተኒፍ ቁቤላወን ወርቄ እት ቶልች፤ ደገሌወን ሰነስ አከሱመ ወርቄ እት ኡፍስ። ");
INSERT INTO gaze_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“ዱንካነ ቁልቁሉ ከነ አኩመ ከሮረ ቱሉረት ስት አርግሲፈሜ ሰናት ዻብ። ");
INSERT INTO gaze_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ሀጲራ ጎልጋ ቱልች፤ ጎልጋ ከነረትስ ኦጌስ ሀርከ ቀጄሉ ቶኮ ፈኪ ኪሩቤሊ ሃቶልቹ። ");
INSERT INTO gaze_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","ጎልጋ ከነ ሆኮ ወርቄቲን ኡቱባወን ሙከ ላፍቶ ከኔን ወርቄን እት ኡፍፈሜ ሚለ ሜቲ አፉርረ ዸዻበተን አፉርት ረራስ። ");
INSERT INTO gaze_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","ጎልጋ ሰነ ሆኮወንት ረራሲቲ ታቦተ ከኩ ሴራሞ ዱግደሳ ዱባን ካእ። ጎልጋን ሱንስ እዶ ቁልቁሉ፣ እዶ እዶ ሁንደ ጫላ ቁልቁሉ ተኤ ሰነራ አዳን ባሰ። ");
INSERT INTO gaze_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","ቴሶ አራራስ እዶ እዶ ሁንደ ጫላ ቁልቁሉ ተኤ ሰነ ኬሰ ታቦተ ከኩ ሴራረ ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","ምንጃለ ሰነስ ጎልጋዻን አለ፣ ገመ ካበ ዱንካነ ቁልቁሉቲን ዻብ፤ ባቱ እብሳሞ ፉሌ ምንጃለ ሰና ገመ ክበ ዱንካንቸቲን ዻብ። ");
INSERT INTO gaze_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“በልበለ ዱንካንቻቲፍሞ ጎልጋ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜ ሀርካን እረት ሆዸሜ ቶኮ ፋዬሲ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","ጎልጋ ከናፍስ ሆኮ ወርቄቲፊ ኡቱባ ሙከ ላፍቶ ከን ወርቄን እት ኡፍፈሜ ሸን ቶልች። ናሲ ቱሚቲ ሚለ ሸን ቶልቺፍ። ");
INSERT INTO gaze_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“ሙከ ላፍቶራ እዶ ኣርሳ ዹንዹመ ሰዲ ኦል ዼረቱ እጃር፤ እዶን ኣርሳ ኩንስ ዼርነ ዹንዹመ ሸኒፊ በልእነ ዹንዹመ ሸኒ ቀባቴ ገመ አፍረኒኑ ወል ቅጤ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","ቶኮ ቶኮ ጎሌወን አፍረኒት ጋንፈ ቶልች፤ ጋንፋፊ እዶን ኣርሳ ሱን ሙኩመ ቶኮራ ሃተኡ፤ እዶ ኣርሳ ሰነረትስ ናሲ ኡፍስ። ");
INSERT INTO gaze_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","ምአሳ ሁንደ ጄቹንስ ዋን እቲን ዳራ ሀረን፣ ዋን እቲን ዳራ ሀማረን፣ ወጪቲ፣ ሆኮ ፎኒቲፊ ባቱ እብዳ ናሲራ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","ናሲ ወል ኬሰ ጠጠሜን ግንግልቻ ሆጄዹቲ ቶኮ ቶኮ ሮገወን ግንግልቻ ሰና አፍረኒፍ ቁቤላወን ናሲ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","ግንግልቻ ሰነስ አከ እን ሀመ ወለካ እዶ ኣርሳት ኦል ከኡፍ ቀርቀረ እዶ ኣርሳ ጀላን ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","እዶ ኣርሳ ሰናፍስ ደንቀራወን ሙከ ላፍቶ ቶልቺቲ ናሲ እት ኡፍስ። ");
INSERT INTO gaze_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","ደንቀራወን ሱንስ አከ ዬሮ እዶን ኣርሳ ባተሙት ገመ ለማኒን ኦለኒፍ ቁቤላወን ኬሰ ሃሎፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","አኩመ ቱሉረት ስት አርግሲፈሜ ሰነት እዶ ኣርሳ ከን ኬስሳ ዱዋ ተኤ ሳንቃራ ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“ዱንካነ ቁልቁሉ ሰናፍ ኦብዲ ሆጄዹ። ኦብድችስ ገመ ክባቲን ዹንዹመ ዽበ ቶኮ ሃዼረቱ፤ እንስ ጎልጋ ቁንጬ ተልባ ጋሪ ፎአሜራ ሆጄተሜ ");
INSERT INTO gaze_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","ኡቱባወን ድግደማፊ ሚለ ናሲ ድግደመ ቀበን ሃቀባቱ፤ ሆኮወኒፊ ሶማወን ኡቱባወን ከኔንስ ሜቲራ ሃሆጄተመን። ");
INSERT INTO gaze_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","ገመ ካባቲንስ አከሱመ ዹንዹመ ዽበ ቶኮ ዼረቴ ጎልጋወን ኡቱባወን ድግደማፊ ሚለ ናሲ ድግደመ ቀበን ሃቀባቱ፤ ሆኮወኒፊ ሶማወን ኡቱባወን ከናስ ሜቲራ ሃቶልፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“ኦብዲን ኩን ገመ ልጣቲን ዹንዹመ ሸንተመ በልአቴ ጎልጋወን፣ ኡቱባ ኩዸኒፊ ሚለ ኩዸን ቀበን ሃቀባቱ። ");
INSERT INTO gaze_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","ኦብዲን ኩን ፊጤ በኣቲን ከራ በአ ቢፍቱቲን አከሱመ ዹንዹመ ሸንተመ ሃበልአቱ። ");
INSERT INTO gaze_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","ጎልጋወን ዹንዹመ ኩዸ ሸን ዼዼረተኒ ኡቱባ ሰዲፊ ሚለ ሰዲ ቀበንስ ከራ በልበለ ቶኮረ ሃጅራተን። ");
INSERT INTO gaze_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","ጎልጋወን ዹንዹመ ኩዸ ሸን ዼዼረተኒ ኡቱባ ሰዲፊ ሚለ ሰዲ ቀበንስ ገመ ካኒን ሃጅራተን። ");
INSERT INTO gaze_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“በልበለ ኦብዲ ሰናቲፍስ ጎልጋ ዹንዹመ ድግደመ ዼረቴ ኡቱባ አፉሪፊ ሚለ አፉር ቀቡ ከን ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ዸአሜረት ፋዬፈሜ ሆጄተሜ ቶኮ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","ኡቱቦን ናኖ ኦብዲ ሰና ሁንድኑ ሶማወኒፊ ሆኮወን ሜቲቲፊ ሚለወን ናሲ ሃቀባተን። ");
INSERT INTO gaze_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","ኦብዲን ሱን ዼርነ ዹንዹመ ዽበ ቶኮፊ በልእነ ዹንዹመ ሸንተማ ሃቀባቱ፤ ጎልጋ ቁንጬ ተልባ ጋሪ ፎአሜ ዹንዹመ ሸን ኦል ዼረቱፊ ሚለወን ናሲራ ሆጄተሜ ሃቀባቱ። ");
INSERT INTO gaze_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","ምእ ተጃጅለ ዱንካነ ቁልቁሉ ሰናቲፍ ፈየዱ ብራ ሁንድ፣ ተጃጅለ ከምዩ ታናን፣ ቆፎ ዱንካንቻቲፊ ቆፎ ኦብዲ ሰና ሁንደ ደበለቴ ናሲራ ሃሆጄተሙ። ");
INSERT INTO gaze_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“አከ እብሳን እቱመ ፉፌ ቦበኡፍ አከ እሳን ዘይቲ ኤጄርሰ ጩንፈሜ ተሊለሳ እብሳዻፍ ሲፍ ፍደን ሰበ እስራኤል አጀጅ። ");
INSERT INTO gaze_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","አሮኒፊ እልማንሳ ዱንካነ ወል ገኢ ኬሰት ጎልጋ ፉለ ታቦተ ከኩ ሴራ ዱረ ጅሩን አለት አከ እብሳን ሱን ገልገላ ሀመ ገነማት ፉለ ዋቀዮ ዱረት ቦበኡ ሃጎዸን። ወን ኩንስ ሰበ እስራኤል ኬሰት ዸሎተ ዹፉፍ ሴረ በረ በራ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“አከ እሳን ሉቦተ ተአኒ ነ ተጃጅለኒፍ ኦቦሌሰኬ አሮን፣ እሰ ወጅንስ እልማንሳ ናዳብ፣ አቢሁ፣ ኤሌኣዛሪፊ ኢታማርን ሰበ እስራኤል ኬሳ ኦፍት ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","አከ እን ኡልፍናፊ ሚዸግነ አርገቱፍስ ኦቦሌሰኬ አሮኒፍ ኡፈተ ቁልቁሉ ሆዽ። ");
INSERT INTO gaze_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","አከ እን ሉበ ተኤ ነ ተጃጅሉፍ ነሞተ ቤኩምሰ ቀበን ከኔን አን ኦጉማ አከና ኬኔፍ ሁንደ አከ እሳን አከ እን አዳን ባፈሙፍ ጄዸኒ አሮኒፍ ኡፈተ ሆዸን እት ህም። ");
INSERT INTO gaze_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","ኡፈትን እሳን ሆጄተንስ፦ ኪሲ ቆማ፣ ድረተ፣ ወንደቦ፣ ክታ ሚዸግፈሜ ዸወሜ፣ መረተ መታቲፊ ሰበታዸ። ጀርስ አከ እሳን ሉቦተ ተአኒ ነ ተጃጅለኒፍ ኦቦሌሰኬ አሮኒፊ እልማንሳቲፍ ኡፈተ ቁልቁሉ ከነ ሃሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","ኦጌዪን ሱንስ ወርቄፊ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜት ሃፈየደመን። ");
INSERT INTO gaze_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“ኦጌሰ ሀርከ ቶሉ ቶኮ ወርቄ፣ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌፊ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ድረተ ሆጄቺስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","ድረን ኩንስ አከ ወልት ጉዱንፈሙ ደንደኡፍ ፉኞ ገቲቲ ለመ ከኔን ፊጤሳ ለማንት ረራፈመን ሃቀባቱ። ");
INSERT INTO gaze_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","ሰበንሳ ከን ኦጉማዻን ዸአሜስ አኩመሳ ድረተ ወጅን ቶኮ ተኤ ወርቄዻን፣ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ሃሆጄተሙ። ");
INSERT INTO gaze_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“ዸጋወን ሰርዶንክሲ ለመ ፉዺቲ መቃ እልማን እስራኤል እሳንረት ሶፊ በሬስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","አኩመ ቶረ ዸሎተሳኒት፣ መቃ ጀአ ዸጋ ቶኮረት፣ መቃ ጀኣን ሀፌስ ዸጋ ካንረት ሶፊ በሬስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","አኩመ ኦጌስ ፋያ ቶኮ ቻፓ ሶፌ ሆጄቱ ሰነ አትስ ዸጋ ለማን ሰነረት መቃ እልማን እስራኤል ሶፊ በሬስ፤ ኤርገሲስ ፋየ ወርቄ እት ናኔሲቲ ");
INSERT INTO gaze_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","አከ እን እልማን እስራኤሊፍ ዸጋ ያደኖ ተኡፍ ፉኞ ገቲቲ ድረተ ሰነት ቀብሲስ። አሮንስ መቃ ሰነ ያደኖ ጎዼ ፉለ ዋቀዮ ዱረት ገቲቲሳ ለማንት ሃባቱ። ");
INSERT INTO gaze_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","አትሞ ፋየ ወርቄ እት ናኔሲቲ ");
INSERT INTO gaze_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","ፎንጫ ወርቄ ቁልቁሉ ከን አከ ፉኞት ፎአሜ ለመ ቶልች፤ ፎንጫ ፎአሜ ሰነሌ ፋየ ሰነት ቀብሲስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“ኦጌሰ ሀርከ ቶሉ ቶኮ ኪሲ ቆማ ከን ሙርቲ ሆጄቺስ፤ እሰስ አኩመ ድረተ ሰናት ወርቄዻን፣ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","ኪሲን ቆማ ኩን ገመ አፍረኒኑ ወል ቅጤፊ ደቻ ተኤ ዼርነ ታኩ ቶኮፊ በልእነ ታኩ ቶኮ ሃቀባቱ። ");
INSERT INTO gaze_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","ዸጋወን ገት ጀቤዪስ ቶረ አፉሪንረት መጠንስ። ቶረ ጀልቀባረት ሰርድዮን፣ ቶጳዝዮኒፊ ቢረሌ፤ ");
INSERT INTO gaze_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","ቶረ ለመፋረት በሉር፣ ሰንፔሪፊ አልማዝ፤ ");
INSERT INTO gaze_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","ቶረ ሰደፋረት ያክንት፣ ኬልቄዶኒፊ ያክንት፣ ");
INSERT INTO gaze_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","ቶረ አፉረፋረት ቢረሌ፣ ሰርዶንክሲፊ ያስጲድ መጠንስ። ዸጋወን ከኔንትስ መርሳ ፋየ ወርቄ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","ዸጋወን ኩዸ ለመ ከኔን ቶኮ ቶኮሳኒረት መቃ ጎሶተ ኩዸ ለመ ኬሳ መቃን ቶኮ አኩመ ቻፓት ሶፈሜ ሃጅራተን፤ ቶኮን ቶኮን ዸጋወን ሰናስ መቃ እልማን እስራኤል ቶኮ ቶኮፍ ዻበተ። ");
INSERT INTO gaze_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“ኪሲ ቆማቲፍስ ፎንጫ ወርቄ ቁልቁሉ አከ ፉኞት ፎአሜ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","ኪሲ ቆማ ሰናፍስ ቁቤላ ወርቄ ለመ ቶልቺቲ ቁቤላ ወርቄ ለማን ሮገ ኪሲ ቆማ ለማንት ቀብሲስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","ፎንጫ ወርቄ ሰነ ለማንስ ቁቤላወን ሮገወን ኪሲ ቆማ ሰነት ጉዱንፍ። ");
INSERT INTO gaze_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","መታ ለማን ፎንጫ ለማን ሰና ካንሞ መርሳወን ፋያ ለማንት ጉዱንፊቲ ከራ ፉለ ዱራቲን ፎንጫ ድረታ ከን ገቲቲት ቀብሲስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","ቁቤላወን ወርቄ ለመ ቶልቺቲ ሮገወን ኪሲ ቆማ ብራ ከኔን ከራ ሞጋ ኬሳቲን ድረተት ኣነኒ ጅረን ለማንት ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","አመስ ቁቤላወን ወርቄ ለመ ብራ ቶልቺቲ ሰበተ ድረታቲን ኦልት ሆዻት ዽኤሲ ፉኞ ገቲቲ ለማን ፉለ ድረተ ዱራን ጅሩ ሰነ ጀላን እት ህዽ። ");
INSERT INTO gaze_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","አከ ኪሲን ቆማ ድረተራ ህንሶሶቾኔፍ ቁቤላወን ኪሲ ቆማ ሱን ሰበተ ሙዺቲን ወልት ቀብሲፈመኒ ፉኞ ብፈ ጩቁሊሳቲን ቁቤላወን ድረተት ሃቀብሲፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“አሮን ዬሮ እዶ ቁልቁሉ ኦል ሴኑ ሁንደ አከ ፉለ ዋቀዮ ዱረት ያደኖ በረ በራ ተኡፍ ለጴሳረት ኪሲ ቆማ ከን ሙርቲቲን መቃ እልማን እስራኤል ንባተ። ");
INSERT INTO gaze_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","አከ እሳን ዬሮ አሮን ፉለ ዋቀዮ ዱረ ዹፉ ሁንደ ለጴሳረ ጅራተኒፍ ኡሪሚፊ ቱሚሚ አከሱመ ኪሲ ቆማ ኬሰ ካእ። አከሲንስ አሮን ዬሮ ሁንደ ምአ እቲን እስራኤሎታፍ ሙርቲ ኬኑ ፉለ ዋቀዮ ዱረት ለጴሳረት ባተ። ");
INSERT INTO gaze_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“ሁጩ ብፍትሳ ጉቱማን ጉቱት ጩቁሊሰ ተኤራ ወንደቦ ድረታ ቶልች፤ ");
INSERT INTO gaze_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","ወለካ ጉባ እሳትስ አፋን እቲን መታ ሴንስፈተን ቶልች። አከ እን ህንተርሳኔፍስ ቀርቀረ አፋንሳረ ወን ፋዬፈሜ ቆጴፈሜ ሃጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","ናኖ ጥዮ ወንደቦ ሰናትሞ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌፊ ብልዲማዻን ሮማኒ ሆጄዹቲ ግዱሳትሞ ብልብለ ወርቄ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","ብልብል ወርቄቲፊ ሮማኒን ሱን ወል ጀለ ደደርበኒ ናኖ ጥዮ ወንደቦ ሰናት ሃሆጄተመን። ");
INSERT INTO gaze_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","አሮን ዬሮ ተጃጅሉ ወንደቦ ከነ ሃኡፈቱ፤ አከ እን ህንዱኔፍ ዮሙ እን ፉለ ዋቀዮ ዱረ እዶ ቁልቁሉ ሴኑፊ ዮሙ እን አቺ ገድ በኡት ሰገሌን ብልብለ ሰና ንዸገአመ። ");
INSERT INTO gaze_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“ወርቄ ቁልቁሉራ ፋየ ቶልቺ፣ ከን ዋቀዮፍ ቁልቁሌፈሜ፣ ጄዺቲ አኩመ ዋን ቻፓረት ሶፈሙት ሶፊ በሬስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","ፋየ ሰነ መረተ መታቲን ወል ቀብሲሱፍ ፉኞ ብፈ ጩቁሊሳ እት ህዽ፤ እንስ መረተ መታ ፉለ ዱራን ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","ፋይ ኩንስ አደ አሮንረ ታአ፤ አሮንስ የከ ኬናወን ቁልቁሉ እልማን እስራኤል ዽኤሰን ኬሰት አርገሙ ሁንደ ንባተ። ኩንስ አከ እሳን ፉለ ዋቀዮ ዱረት ፉዸተመ አርገተኒፍ አደ አሮንረ ጅራተ። ");
INSERT INTO gaze_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜ ዾፍስሲቲ ቆሜ ሆጄዹ፤ መረተ መታሌ ቁንጬ ተልባ ጋሪራ ቶልች። ሰበንስ ኦጌሰ ሀርከ ቀጄሉን ሃቶልፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","አከ እልማን አሮንስ ኡልፍናፊ ሚዸግነ አርገተኒፍ ቆሜ፣ ሰበታፊ መረተ መታ ቶልቺፍ። ");
INSERT INTO gaze_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","ኤርገ ኡፈተ ከነ ኦቦሌሰኬ አሮንቲፊ እልማንሳት ኡፍፍቴ ቦዴ ድቢ እሳን ሙድ። አከ እሳን ሉቦተ ተአኒ ነ ተጃጅለኒፍስ እሳን ቁልቁሌስ። ");
INSERT INTO gaze_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“ቁምጣ ወያ ጀላ ከን ሙዺዻ ጀልቀቤ ሀመ ጉዴዳት ቁላ ነማ ዾክሱ ቁንጬ ተልባራ ሆጄዹፍ። ");
INSERT INTO gaze_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","አሮኒፊ እልማንሳ አከ በሌሳ ሆጄተኒ ህንዱኔፍ ዬሮ ዱንካነ ወል ገኢ ሴነን ዮካን እዶ ቁልቁሉ ሰነት ተጃጅለ ኬኑፍ እዶ ኣርሳት ዽኣተን ኡፈተ ከነ ኡፈቹ ቀቡ። “ኩንስ አሮኒፊ ሰኚ እሳቲፍ ስርነ በረ በራ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“አከ እሳን ሉቦተ ተአኒ ነ ተጃጅለኒፍ ወን አት እሳን ቁልቁሌሱፍ ጎቱ ከናዸ፤ ድብቸ ቶኮፊ ኮርቤዪ ሆላ ከኔን ሙዳ ህንቀብኔ ለመ ፉዽ። ");
INSERT INTO gaze_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","ዳኩ ቀመዲ ፍለተማራ መጥኖ፣ መጥኖ ዘይቲዻን ሱኩመሜፊ ብጥሌ ዘይቲን እረ ድበሜ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","እሳን ከነስ ጉንዶ ኬሰ ካኢቲ ድብቻፊ ኮርቤዪ ሆላ ወጅን ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","ኤርገሲሞ አሮኒፊ እልማንሳ ገረ በልበለ ዱንካነ ወል ገኢት ፍዲቲ ብሻኒን እሳን ዽቅ። ");
INSERT INTO gaze_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","ኡፈተስ ፉዺቲ ቆሜ፣ ወንደቦ ድረታ፣ ድረታፊ ኪሲ ቆማ አሮንት ኡፍስ። ድረተ ሰነስ ሰበተ ኦጉማዻን ዸአሜን ህዽ። ");
INSERT INTO gaze_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","መታሳት መረተ መር፤ መረተ ሰነትሞ ጎንፎ ቁልቁሉ ቀብሲስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","ዘይቲ እቲን ድብዱ ፉዺቲ መታሳረት ዸንገላሱዻን እሰ ድብ። ");
INSERT INTO gaze_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","እልማንሳ ፍዲ ቆሜ እሳንት ኡፍስ፤ ");
INSERT INTO gaze_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","መታሳኒት መረተ መር። ኤርገሲሞ አሮኒፊ እልማንሳት ሰበተ ህዽ። ሉቡማንስ ሴረ በረ በራቲን ከንሳኒት። “አትስ አከሲን አሮኒፊ እልማንሳ ሙድ። ");
INSERT INTO gaze_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“ድብቸ ሰነ ገረ ፉለ ዱንካነ ወል ገኢት ፍድ፤ አሮኒፊ እልማንሳሞ ሀርከሳኒ መታሳረ ሃካአን። ");
INSERT INTO gaze_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","አትስ ፉለ ዋቀዮ ዱረት፣ በልበለ ዱንካነ ወል ገኢረት እሰ ቀል። ");
INSERT INTO gaze_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","ዺገ ድብቸ ሰናራ ጥኖ ፉዺቲ ቁበኬቲን ጋንፈ እዶ ኣርሳ ድብ፤ ከን ሀፌሞ ሚለ እዶ ኣርሳረት ዸንገላስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","ሞረ ምአ ገራት ሀጉገሜ ሁንደ፣ ሀጉጊ ትሩቲፊ ሞረ ከሌ ለማንት ሀጉገሜ ፉዺቲ እዶ ኣርሳረት ጉብ። ");
INSERT INTO gaze_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","ፎን ድብቸ ሰና፣ ጎጋሳቲፊ ጩማሳ ገሩ ቁበተ ኬሳ ገድ ባሲ ጉብ። እን ኣርሳ ጩቡት። ");
INSERT INTO gaze_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“ኮርቤዪ ሆላ ሰነ ኬሳ ቶኮ ፍድ፤ አሮኒፊ እልማንሳስ ሀርከሳኒ መታሳረ ሃካአን። ");
INSERT INTO gaze_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","ኮርቤሰ ሆላ ሰነ ቀሊ ዺገሳ ፉዺቲ ገመ ሁንዳን እዶ ኣርሳት ፈጫስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","ኮርቤሰ ሆላ ሰነ ገርገር ኩኩቲ ምአ ገራቲፊ ሉከሳ ሚጪቲ መታፊ ኩታወን ካን ወጅን ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","ኮርቤሰ ሆላ ሰነ ጉቱማን ጉቱት እዶ ኣርሳረት ጉብ። ኩንስ ቀልመ ዋቀዮፍ ጉበሙ፣ ኣርሳ ኡርጋኣ እብዳን ዋቀዮፍ ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“ኮርቤሰ ሆላ ካንሌ ፍድ፤ አሮኒፊ እልማንሳ ሀርከሳኒ መታሳረ ሃካአን። ");
INSERT INTO gaze_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","ኮርቤሰ ሆላ ሰነ ቀል፤ ዺገሳራስ ፉዺቲ ፊጤ ጉረ አሮን ምርጋቲፊ ፊጤ ጉረ እልማንሳ ምርጋ ድብ፤ ቁበ አቡዱ ሀርከ ምርጋሳኒቲፊ ቁበ አቡዱ ሚለ ምርጋሳኒሌ ድብ። ዺገ ሀፌሞ ገመ ሁንዳን እዶ ኣርሳት ፈጫስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","ዺገ እዶ ኣርሳረ ጅሩራ፣ ዘይቲ እቲን ድበንራስ ፉዺቲ አሮኒፊ ኡፈተሳት፣ እልማንሳቲፊ ኡፈተሳኒት ፈጫስ። አከሲን እኒፊ እልማንሳ፣ ኡፈትንሳኒስ ንቁልቁላኡ። ");
INSERT INTO gaze_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“ኮርቤሰ ሆላ ከነራስ ጮመ፣ ዱቦ፣ ሞረ ምአ ገራ ሀጉጉ፣ ሀጉጊ ትሩ፣ ከሌ ለማኒፊ ሞረ እሳንት ጅሩ፣ አከሱመስ ተፈ ምርጋ ፉዺ። ኮርቤስ ሆላ ኩንስ ሆላ እቲን ሉቡማ ኬነኒዸ። ");
INSERT INTO gaze_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","ጉንዶ መጥኖ ባቱ ከን ፉለ ዋቀዮ ዱረ ጅሩ ሰነራ መጥኖ ቶኮ፣ መጥኖ ዘይቲዻን ቶልፈሜ ቶኮፊ ብጥሌ ቶኮ ፉዽ። ");
INSERT INTO gaze_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","ወንቶተ ከኔን ሁንደ ሀርከ አሮኒፊ ሀርከ እልማንሳ ኬሰ ካኢቲ ኣርሳ ሶቾፈሙ ጎዺ ፉለ ዋቀዮ ዱረት ሶቾስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","ኤርገሲሞ ሀርከሳኒቲ ፉዺ አከ ኡርጋ ዋቀዮት ቶሉ ተኡፍ ኣርሳ ጉበሙ ወጅን እዶ ኣርሳረት ጉብ፤ ኩንስ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","ኤርገ ሀንደራፈ ሆላ አሮን እቲን ሉበ ተኤ ሰነ ፉቴ ቦዴ ኣርሳ ሶቾፈሙ ጎዺቲ ፉለ ዋቀዮ ዱረት ሶቾስ፤ ኩንስ ቆደኬት። ");
INSERT INTO gaze_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“ሀንደራፈ ኣርሳ ሶቾፈሙ፣ ሉከ ኮርቤሰ ሆላ እሰ ከን አሮኒፊ እልማንሳ እሰ ዬሮ እሳን ሉበ ተአን ኣርሳ ተኤ ዽኣቴ ሰነ ቁልቁሌስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","ኩንስ ቆደ በረ በራ ከን ሰብን እስራኤል ዬሮ ሁንደ አሮኒፊ እልማንሳቲፍ ኬኑዸ። እንስ ጉማቸ ሰብን እስራኤል ኣርሳ ነጋራ ዋቀዮፍ ኬኑዸ። ");
INSERT INTO gaze_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“አከ እሳን እቲን ድበመኒ ሉበ ተአኒፍ ኡፈትን አሮን ቁልቁሉን ከን እልማንሳ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","እልም እዶሳ ቡኤ ሉበ ተኡዻን እዶ ቁልቁሉ ኬሰ ተጃጅሉፍ ገረ ዱንካነ ወል ገኢ ዹፉ ቡልቲ ቶርበ ኡፈተ ከነ ሃኡፈቱ። ");
INSERT INTO gaze_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“ኮርቤሰ ሆላ እሰ እቲን ሉበ ተአን ሰነ ፉዺቲ ፎንሳ እዶ ቁልቁሉት አፌል። ");
INSERT INTO gaze_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","አሮኒፊ እልማንሳ ፎን ሆላ ሰናቲፊ ቡዴነ ጉንዶራ ሰነ በልበለ ዱንካነ ወል ገኢ ዱረት ሃኛተን። ");
INSERT INTO gaze_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","እሳንስ ኣርሳ እሳን እቲን ሉበ ተአኒፊ ቁልቁሌፈሙሳኒቲፍ እቲን አራር ቡኤ ሃኛተን። ሰበቢ ኣርሳን ሱን ቁልቁሉ ተኤፍ ገሩ ነምን ካን ህንኛትን። ");
INSERT INTO gaze_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","ዮ ፎን ኮርቤሰ ሆላ እቲን ሉበ ተአን ከምዩ ዮካን ቡዴን ከምዩ ሀፌ ቡሌ እብዳን ጉብ፤ ሰበቢ ቁልቁሉ ተኤፍ ኛተሙ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“ዋን አን ስአጀጄ ሁንደ አሮኒፊ እልማንሳቲፍ ጎዽ። ቡልቲ ቶርበ ጉቱ ሴረ ሉቡማ እሳኒፍ ራወዹ። ");
INSERT INTO gaze_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","አከ አራር ቡኡፍስ ጉዩመ ጉያን ድብቸ ቀሊ ኣርሳ ጩቡ ዽኤስ። እዶ ኣርሳ ሰናፍ ኣርሳ አራራ ዽኤሱዻን ቁልቁሌስ፤ አዳን ባሱዻፍስ እሰ ድብ። ");
INSERT INTO gaze_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","እዶ ኣርሳ ሰናፍስ ቡልቲ ቶርበ አራረ ቡሲቲ እሰ ቁልቁሌስ። ዮስ እዶን ኣርሳ ሱን ዋን ሁንደ ጫላ ቁልቁሉ ተአ፤ ወን እሰ ቱቁ ሁንድኑስ ንቁልቁሌፈመ። ");
INSERT INTO gaze_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“ወን አት ዬሮ ሁንደ እዶ ኣርሳረት ጉያ ጉያን ዽኤስቱ ከናዸ፦ ጦባላወን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤ ለመ፤ ");
INSERT INTO gaze_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","ቶኮ ገነመ፣ ካንሞ ገልገለ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","ጦባላ ጀልቀባ ሰነ ወጅንስ ዳኩ በኤሰሳ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ቶኮ ዘይቲ ኤጄርሳ ከን ጩንፈሜ ኢኒ ቶኮ ሀርከ አፉር ኬሳ ሀርከ ቶኮን ሱኩመሜ ዽኤስ፤ አከሱመስ ዳዺ ወይኒ ኢኒ ሀርከ አፉር ኬሳ ሀርከ ቶኮ ዽባዩ ጎዺ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","ጦባላ ሆላ ካንሞ ኬና ምዻኒቲፊ ከን ዽባዩ ወጅን አኩመ እሰ ገነማ ሰናት ገልገለ ዽኤስ፤ ኩንስ ኣርሳ ኡርጋኣ እብዳን ዋቀዮፍ ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“ቀልም ጉበሙ ኩን ዸሎተ ዹፉ ኬሰትስ ዬሮ ሁንደ በልበለ ዱንካነ ወል ገኢረት ፉለ ዋቀዮ ዱረት ሃዽኤፈሙ። አንስ ገረኬሰን ዹፌ አችት እስንት ነንዱበዸ፤ ");
INSERT INTO gaze_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","ሰበ እስራኤል ወጅንስ አቹመት ወል አርግነ፤ እዶን ሱንስ ኡልፍነኮቲን ንቁልቁሌፈመ። ");
INSERT INTO gaze_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“አን ዱንካነ ወል ገኢፊ እዶ ኣርሳ ሰነ ነንቁልቁሌሰ፤ አሮኒፊ እልማንሳስ አከ እሳን ሉቦተ ተአኒ ነ ተጃጅለኒፍ ነንቁልቁሌሰ። ");
INSERT INTO gaze_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","አንስ ሰበ እስራኤል ኬሰ ነንጅራዸ፤ ዋቀሳኒስ ነንተአ። ");
INSERT INTO gaze_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","እሳንስ አከ አን ዋቀዮ ዋቀሳኒ ከን ግዱሳኒ ጅራቹፍ ጄዼ ብየ ግብጢቲ ኬሳ እሳን ባሴ ተኤ ንቤኩ፤ አን ዋቀዮ ዋቀሳኒት። ");
INSERT INTO gaze_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“እዶ ኣርሳ ከን እጣን እረት ኣርፈሙ ሙከ ላፍቶራ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","እዶን ኣርሳ ኩንስ ደልገ ዼርነ ዹንዹመ ቶኮ፣ በልእነ ዹንዹመ ቶኮቲፊ ኦል ዼርነ ዹንዹመ ለማ ቀባቴ ገመ አፍረኒኑ ወል ቅጤ ሃተኡ፤ ጋንፈወንሳስ እዶ ኣርሳ ሰናን ወልት ዋኑመ ቶኮራ ሃቶልፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","ጉባሳረ፣ ጭናቸሳ ሁንዱማፊ ጋንፈወንሳት ወርቄ ቁልቁሉ ኡፍሲቲ ናኖሳት መርሳ ወርቄ ናኔሲ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","እዶ ኣርሳ ሰናፍስ መርሳወን ወርቄሳቲ ገድት ቁቤላወን ወርቄ ለመ ቶልች፤ ቁቤላወን ከነስ አከ እሳን ደንቀራወን እቲን እዶ ኣርሳ ባተን ቀበተኒፍ ገማ ገመናን ጭናቸ ለማንት ቶልች። ");
INSERT INTO gaze_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","ደንቀራወን ሙከ ላፍቶ ቶልቺቲ ወርቄ እት ኡፍስ። ");
INSERT INTO gaze_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","እዶ ኣርሳ ሰነስ ፉለ ጎልጋ ታቦተ ከኩ ሴራ ብረ ጅሩ ሰና ዱረ፣ ፉለ ቴሶ አራራ ከን ከኩ ሴራቲን ኦል ጅሩ ዱረ እዶ አን እት ስ አርጉ ሰነ ዻብ። ");
INSERT INTO gaze_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“አሮን ዮሙ ገነመ ገነመ እብሳ ቆቆጴሱት እዶ ኣርሳረት እጣነ ኡርጋኣ ሃኣርሱ። ");
INSERT INTO gaze_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","አከ እጣን ሱን ዸሎተ ዹፉ ኬሰትሌ ዬሮ ሁንደ ፉለ ዋቀዮ ዱረት ኣሩፍ አሮን ዮሙ ገልገለ ገልገለ እብሳ ቀብሲሱት እጣነ ሃኣርሱ። ");
INSERT INTO gaze_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","እዶ ኣርሳ ከነረት እጣነ ጎሰ ብራ ዮካን ቀልመ ጉበሙ ዮካን ኬና ምዻኒ ህንዽኤስን፤ ዽባዩስ እረት ህንዽባፈትን። ");
INSERT INTO gaze_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","አሮንስ ወጋት ዬሮ ቶኮ ጋንፈወን እዶ ኣርሳረት ኣርሳ አራረ ቡሱ ሃዽኤሱ፤ ኣርሳን ወጋት ዽኤፈሙ ኩን ዺገ ኣርሳ ጩቡ ከን አራር እቲን አርገሙ ወጅን ዸሎተ ዹፉ ኬሰት ሃዽኤፈሙ። ኣርሳን ኩንስ ዋቀዮፍ ዋን ሁንዱማ ጫላ ቁልቁሉዸ።” ");
INSERT INTO gaze_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","ኤርገሲስ ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“ዮሙ አት ባይእነ ሰበ እስራኤል ለኮፍቱት ቶኮን ቶኮን ነማ ዬሮ ለካአሙት ፉሪ ሉቡሳ ዋቀዮፍ ሃኬኑ። ዮስ ዬሮ አት እሳን ለኮፍቱት ዸእች ቶኮዩ እሳን ህንአርገቱ። ");
INSERT INTO gaze_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","ነምን ወረ ለካአመንት ደበለሙ ከምዩ አኩመ ሰቅሊ እዶ ቁልቁሉ ከን ጌራ ድግደማ ኡልፋቱ ሰናት ወለካ ሰቅሊ ሃኬኑ። ወለካን ሰቅሊ ኩንስ ኬና ዋቀዮፍ ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","ወረ ለካአመን ኬሳ ከኔን ኡሙሪንሳኒ ወጋ ድግደመ ዮካንሳ ኦል ተኤ ሁንድኑ ዋቀዮፍ ኬና ሃዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","ዮሙ እስን ሉቡኬሰን ፉሩፍ ጄተኒ ዋቀዮፍ ኬና ዽኤስተንት ሶሬዪን ወለካ ሰቅሊቲ ኦል ህንኬንን፤ ህዬዪንስ ወለካ ሰቅሊቲ ገድ ህንኬንን። ");
INSERT INTO gaze_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","ማለቀ ፉሪ ሰነስ እስራኤሎተ ሀርካ ፉዺቲ ተጃጅለ ዱንካነ ወል ገኢ ሰናረ ኦልች፤ ኩንስ ሉቡኬሰኒፍ ፉሪ ተኡፍ ፉለ ዋቀዮ ዱረት ያደኖ ሰበ እስራኤል ተአ።” ");
INSERT INTO gaze_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","ኤርገሲስ ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“ገበቴ ናሲ ከን ሚለ ናሲ ቀቡ ዽቀናዻፍ ቶልች። እሰስ ዱንካነ ወል ገኢቲፊ እዶ ኣርሳ ግዱ ካኢቲ ብሻን እት ነቅ። ");
INSERT INTO gaze_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","አሮኒፊ እልማንሳ ብሻን ሰናን ሀርከሳኒቲፊ ሚለሳኒ ሃዽቀተን። ");
INSERT INTO gaze_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","እሳንስ አከ ህንዱኔፍ ዬሮ ዱንካነ ወል ገኢ ሴነን ብሻኒን ዽቀቱ፤ አከሱመስ ዮሙ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ጉቡዻፍ ተጃጅሉፍ እዶ ኣርሳት ዽኣተንት፣ ");
INSERT INTO gaze_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","አከ ህንዱኔፍ ሀርከሳኒቲፊ ሚለሳኒ ሃዽቀተን። ኩንስ ዸሎተ ዹፉ ኬሰት አሮኒፊ ሰኚሳቲፍ ሴረ ዻበታ ተአ።” ");
INSERT INTO gaze_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","ኤርገሲስ ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“ኡርጎፍቱወን ኡርጎፍቱ ሁንደ ጫለን ጄቹንስ ቁምቢ ቁልቁሉ ሰቅሊ 500፣ ቀረፋ ኡርጋኣ ወለካሳ ጄቹንስ ሰቅሊ 250፣ መርገ ጭታ ኡርጋኣ ሰቅሊ 250፣ ");
INSERT INTO gaze_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","ቡርጉዲ ሰቅሊ 500 ፉዸዹ፤ ሁንድሳዩ አኩመ ሰቅሊ እዶ ቁልቁሉት ሃተኡ፤ አከሱመስ ዘይቲ ኤጄርሳ ኢኒ ቶኮ ፉዸዹ። ");
INSERT INTO gaze_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","ኡርጎፍቱወን ከኔኒንስ ዘይቲ እቲን ድበን ቁልቁሉሳ ጄቹንስ መካ ኡርጋኣ አኩመ ኦጌሰ ኡርጎፍቱ ቆጴሱ ቶኮት ቶልች። ኩንስ ዘይቲ እቲን ድበን ቁልቁሉሳ ተአ። ");
INSERT INTO gaze_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","ዘይቲ ከናንስ ዱንካነ ወል ገኢ፣ ታቦተ ከኩ ሴራ፣ ");
INSERT INTO gaze_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","ምንጃላፊ ምአሳ ሁንደ፣ ባቱ እብሳፊ ምአሳ፣ እዶ ኣርሳ እጣና፣ ");
INSERT INTO gaze_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","እዶ ኣርሳ ቀልመ ጉበሙቲፊ ምአሳ ሁንደ፣ ገበቴ እት ዽቀተኒፊ ሚለሳ ድብ። ");
INSERT INTO gaze_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","አከ እሳን ዋን ሁንደ ጫላ ቁልቁሉ ተአኒፍ እሳን ቁልቁሌስ፤ ወን እሳን ቱቁ ከምዩስ ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“አከ እሳን ሉቦተ ተአኒ ነ ተጃጅለኒፍ አሮኒፊ እልማንሳ ድብ ቁልቁሌስ። ");
INSERT INTO gaze_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","እስራኤሎታን አከነ ጄዽ፤ ‘ኩን ዘይቲን ቁልቁሉ እቲን ዸሎተ ዹፉፍ ጅሩ ድበን ናፍ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","ዘይቲ ከነ ዸግነ ነመ ብራረት ህንዸንገላስን ዮካን ዘይቲ ከምዩ ከራ ከናን ህንቆጴስን። ዘይቲን ኩን ቁልቁሉዸ፤ እንስ እስኒፍ ቁልቁሉ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","ነምን ሽቶ ሽቶ ሰነ ፈካቱ ሆጄቱ ከን ነመ ብራትስ ድቡ ሰበሳ ኬሳ ሃበሌፈሙ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ “ኡርጎፍቱ ጄቹንስ ሀምጴ ኡርጋኡ፣ ኤሌላን ኡርጋኡ፣ ኣነን ሙከ ኡርጋኡ፣ እጣነ መካ ህንቀብኔ ከን ሁንድሳዩ ባይእነ ወል ቅጤ ቀቡ ፉዸዹቲ፣ ");
INSERT INTO gaze_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","አኩመ ነምን ኡርጎፍቱ ቆጴሱ ቶኮ ሆጄቱት እጣነ መከማ ኡርጋኡ ቶልች። እጣነ ከነትስ ሶግደ ነቂቲ ቁልቁሌስ፤ አከ ቁልቁሉ ተኡስ ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","እሰ ኬሳስ ገርቶኮ ዳኪ ቡሌሲቲ ዱንካነ ወል ገኢ ኬሰ ፉለ ታቦተ ከኩ ሴራ ዱረ እዶ አን እት ስ አርጉ ሰነ ካእ። እንስ ከን ዋን ሁንደ ጫላ ቁልቁላኡ እስኒፍ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","ሃለ ከናን እጣነ ኦፊኬሰኒፍ ህንቆጴፈትና፤ አከ እን ዋቀዮፍ ቁልቁሉ ተኤስ ሁበዹ። ");
INSERT INTO gaze_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","ነምን ኡርጋሳት ገመዱፍ ጄዼ ዋን እሰ ፈካቱ ቶኮሌ ሆጄቱ ሰበ ኦፊ ኬሳ ሃበሌፈሙ።” ");
INSERT INTO gaze_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“እላ፣ አን ጎሰ ይሁዳ ኬሳ ቤዘልኤል እልመ ኡር፣ እልመ ሁር ፍለዼረ፤ ");
INSERT INTO gaze_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","አን ሀፉረ ዋቃቲን፣ ኦጉማዻን፣ ደንዴቲፊ ቤኩምሰ ሆጂ ሀርካ ጎሰ ሁንዱማን እሰ ጉቴረ፤ ");
INSERT INTO gaze_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","ኩንስ አከ እን ወርቄዻን፣ ሜቲፊ ናሲዻን ሆጂ ኦጉማ ሆጄቱፍ፤ ");
INSERT INTO gaze_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","አከ እን ዸጋወን ሙሬ ቆጴሱፍ፣ አከ ሙከ ሶፉፊ አከ ሆጂ ኦጉማ ሀርካ ከን ጎሰ ሁንዳ ኬሰት ህርማቱፍ። ");
INSERT INTO gaze_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","አከሱመስ አን ኩኖ አከ እን እሰ ገርጋሩፍ ኦሆሊያብ እልመ አሂሳማክ ከን ጎሰ ዳን ሰነ ሙዴረ። ");
INSERT INTO gaze_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“እሳንስ ዱንካነ ወል ገኢ፣ ታቦተ ከኩ ሴራቲፊ ቴሶ አራራ ከን ታቦተ ሰነረ ጅሩ፣ ምአ ዱንካነ ሰና ሁንደ ጄቹንስ ");
INSERT INTO gaze_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","ምንጃላፊ ምአሳ፣ ባቱ እብሳ ከን ወርቄ ቁልቁሉራ ቶልፈሜፊ ምአሳ ሁንደ፣ እዶ ኣርሳ እጣና፣ ");
INSERT INTO gaze_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","እዶ ኣርሳ ቀልመ ጉበሙቲፊ ምአሳ ሁንደ፣ ገበቴ እት ዽቀተኒፊ ሚለሳ፣ ");
INSERT INTO gaze_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","ወያወን ሚዸግፈመኒ ዸአመን፣ ወያወን አሮን ሉብቻፍ ቁልቁሌፈመኒፊ ወያወን እልማንሳ ዬሮ ሉቡማዻን ተጃጅለን ኡፈተን፣ ");
INSERT INTO gaze_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","እዶ ቁልቁሉ ሰናፍሞ ዘይቲ ድበታቲፊ እጣነ ኡርጋኡ ሃቆጴሰን። ");
INSERT INTO gaze_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“ሰበ እስራኤሊን አከነ ጄዽ፤ ‘እስን ሰንበቶተኮ ኤጋ። አን ዋቀዮ እሰ እስን ቁልቁሌሱ አከን ተኤ አከ ቤክተኒፍ ኩን ዸሎተ ዹፉ ኬሰት አናፊ እስን ግዱት መለቶ ተአ። ");
INSERT INTO gaze_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘ዋን ሰንበትን እስኒፍ ቁልቁሉ ተኤፍ እሰ ኤጋ። ነምን ሰንበተ ጡሬሱ ሃአጄፈሙ፤ ነምን ጉያ ሰነ ሆጂ ሆጄቱ ከምዩ ሰበሳ ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","ጉያ ጀአ ሆጂን ሃሆጄተሙ፤ ጉያን ቶርበፋን ገሩ ሰንበተ ቦቆናት፤ ጉያን ኩን ዋቀዮፍ ቁልቁሉዸ። ነምን ጉያ ሰንበታ ሆጂ ሆጄቱ ከምዩ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","እስራኤሎን ሰንበተ ከነ ከኩ በረ በራ ጎዸተኒ ዸሎተ ዹፉ ኬሰ ሃኤገን። ");
INSERT INTO gaze_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","ኩንስ አናፊ እስራኤሎተ ግዱት መለቶ በረ በራ ተአ፤ ዋቀዮ ጉያ ጀአ ኬሰት ሰሚፊ ለፈ ኡሜ ጉያ ቶርበፋት ቦቆቴ ኣረ ገልፈቴራቲ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","ዋቀዮ አኩመ ጋረ ሲናረት ሙሴት ዱበቴ ራወቴን ገበቴ ዹጋ ለማን ጄቹንስ ገበቴወን ዹገ በኡምሳ ከኔን ቁብን ዋቃረት በሬሴ ሰነ እሰት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","ሰብን ሱንስ ዮሙ አከ ሙሴን ቱሉረ ቱሬ አርጌት አሮንን መርሴ፣ “ሙሴ ነምቸ ብየ ግብጢቲ ባሴ ኑ ፍዴ ሰነ ዋን እን ተኤ ህንቤክኑቲ ከኢ ዋቆተ ኑ ዱረ ዴመን ኑ ቶልች” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","አሮንሞ፣ “ወርቄ ጉራ ከን ኒቶትንኬሰን፣ እልማንኬሰኒፊ እንተለንኬሰን ኬየተንራ ባሳቲ ነት ፍዳ” ጄዼ ዴብሴፍ። ");
INSERT INTO gaze_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","ነሞትን ሁንድኑ ወርቄ ጉረሳኒ ኦፍራ ባሰኒ አሮንት ፍደን። ");
INSERT INTO gaze_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","እንስ ወርቄ ሰነ እሳን ሀርካ ፉዼ ምአ እቲን ሆጄተኒን በቅሴ ዋቀ ቶልፈማ ብፈ ጀቢቲን ሆጄተሜ ቶኮ ቶልቼ፤ እሳንስ፣ “ያ እስራኤል እሳን ኩኔን ዋቆተኬ ወረ ብየ ግብጢቲ ስ ባሰኒዸ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","አሮንስ ዮሙ ዋን ከነ አርጌት ፉለ ጀቢ ሰና ዱረት እዶ ኣርሳ እጃሬ፣ “ቦር ዋቀዮፍ አያን ንአያኔፈመ” ጄዼ ለብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","እሳንስ ጉያ እት ኣኑ ገነመ በሪን ከአኒ፣ ኣርሳ ጉበሙ ዽኤሰኒ ኣርሳ ነጋስ ፍደን። ከነረት ኛቹፊ ዹጉፍ ተታአን፤ ስርቡፍስ ከአን። ");
INSERT INTO gaze_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ሰብንኬ ከን አት ብየ ግብጢቲ ባፍቴ ፍዴ ሱን ጡራኤራቲ ገድ ቡእ። ");
INSERT INTO gaze_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","እሳን ደፈኒ ከራ አን እሳን አጀጄራ ጀልአተኒሩ፤ ዋቀ ቶልፈማ ብፈ ጀቢቲን በቅፈሜ ቆጴፈሜሌ ኦፊሳኒቲፍ ቶልፈተኒ ኣርሳ ዽኤሰኒፊ፣ ‘ያ እስራኤል እሳን ኩኔን ዋቆተኬ ወረ ብየ ግብጢቲ ስ ባሰኒዸ’ ጄዸኒ እሰ ዋቄፈተኒሩ። ");
INSERT INTO gaze_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ‘ኩኖ፣ አን አከ ሰብን ኩን መተ ጀቤሰ ተኤ አርጌረ። ");
INSERT INTO gaze_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","ከናፉ አከ ኣሪንኮ እሳንት ቦበኡፊ አከ አን እሳን በሌሱፍ ነ ዺስ። ዮሙስ አን ሰበ ጉዳ ስ ታስሰ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","ሙሴን ገሩ ፉለ ገርጋርሰ ዋቀዮ ዋቀሳ በርባደቴ፤ አከነስ ጄዼ፤ “ያ ዋቀዮ፣ ዼከምስኬ ማሊፍ ሰበኬ ወረ አት ሁምነ ጉዳፊ እሬ ጀባዻን ብየ ግብጢቲ ባፍቴ ሰነት ቦበአ? ");
INSERT INTO gaze_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","ወር ግብጢ ማሊፍ፣ ‘እን ዱሩመዩ ያደ ሀማዻን ቱሉወንረት እሳን ፍጡፊ ለፈራ እሳን በሌሱፍ ግብጢ እሳን ባሴ?’ ጄዹ። ኣሪኬ ቦበኣ ሰነራ ዴብእ፤ ኦብስስ፤ ሰበ ኬትስ በዲሰ ህንፍድን። ");
INSERT INTO gaze_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","ገርቦተኬ አብረሃም፣ ይስሃቂፊ እስራኤልን ወረ፣ ‘አን ሰኚኬ አከ ኡርጂወን ሰሚራ ነንባይእሰ፤ ለፈ አን ዋዳ እሳኒፍ ሴኔ ከነ ሁንደስ ሰኚኬሰኒፍ ነንኬነ፤ እሳንስ በረ በራን ለፈ ሰነ ንዻሉ’ ጄቴ መቃኬቲን ከከቴፍ ሰነ ያደዹ።” ");
INSERT INTO gaze_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","ከነረት ዋቀዮ ያደ ጌደረቴ በዲሰ ሰበሳት ፍዱፍ ቱሬ ሰነ ዺሴ። ");
INSERT INTO gaze_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","ሙሴንስ ገበቴወን ከኩ ለማን ሰነ ሀርከት ቀበቴ ዴብኤ ቱሉራ ገድ ቡኤ። ገበቴ ሰነረትስ ከራ ለቹ፣ ዱራ ዱባን በሬፈሜ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","ገበቴወን ሰነስ ዋቀቱ ሆጄቴ፤ ከተቢን ሱንስ ከተቢ ዋቃ ከን ገበቴወን ሰነረት ሶፈሜ በሬፈሜዸ። ");
INSERT INTO gaze_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","እያሱንስ ዮሙ ወጨ ነሞታ ዸገኤት ሙሴዻን፣ “እዶ ቡፈታ ኬሰ ሰገሌ ወራናቱ ጅረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","ሙሴንሞ አከነ ጄዼ ዴብሴ፦ “ሰገሌን አን ዸገኡ ኩን ሰገሌ ስርባት መሌ ሰገሌ ሞኡ፣ ዮካን ሰገሌ ሞአተሙ ምት።” ");
INSERT INTO gaze_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","ሙሴንስ አኩመ እዶ ቁበታት ዽኣቴ ጀቢፊ ሹብሰ ሰነ አርጌን ኣሬ ጉበቴ፤ ገበቴወን ሰነ ሀርከሳራ ደርበቴ ቱሉ ሰነ ጀለት ጨጨብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","እንስ ጀቢ ጀር ቶልቸን ሰነ ፉዼ እብዳን ጉቤ፤ ዳኬ ቡሌሴስ ብሻንት ፍርፍርሴ እስራኤሎተ ኦባሴ። ");
INSERT INTO gaze_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","ሙሴንስ አሮኒን፣ “ሰብን ኩን ማል ስ ጎናን አት ጩቡ ጉዳ አከሲ ኬሰ እሳን ቡፍቴ?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","አሮንሞ ዴብሴ አከነ ጄዼ፤ “ያ ጎፍታኮ፣ ኣርቴ ህንጉበትን፤ አከ ሰብን ኩን ገረ ሀምናት ጀልአቱ አቱ ቤክተ። ");
INSERT INTO gaze_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","እሳን፣ ‘ሙሴ ነምቸ ግብጢ ባሴ ኑ ፍዴ ሰነ ዋን እን ተኤ ህንቤክኑቲ ዋቆተ ኑ ዱረ ዴመን ኑ ቶልች’ ናን ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","አንስ፣ ‘ነምን ወርቄ ቀቡ ኦፍራ ሃባሱ’ ጄዼን፤ እሳንስ ወርቄ ሰነ ነት ኬነን፤ አንስ እብደ ኬሰ ነንቡሴ፤ እንሞ ጀቢ ተኤ በኤ!” ");
INSERT INTO gaze_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","ሙሴን አከ ሰብን ሱን ገድ ዺሲት ጅራቴ፣ አሮንስ አከ እሳን ቶአናዻን አለ ተአን አከ ጎዼፊ አከ እሳን ዲኖተሳኒ ብረትስ ዋን ኮልፋ ተአን አርጌ። ");
INSERT INTO gaze_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","ከናፉ ሙሴን ከረ ቁበታ ዱረ ዻበቴ፣ “ሜ ወር ገረ ዋቀዮ ጎርተን ሁንድ ገረኮ ኮታ” ጄዼ። ሌዎትን ሁንድስ እሰ ብረት ወልት ቀበመን። ");
INSERT INTO gaze_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","ኤርገሲ እን አከነ እሳኒን ጄዼ፤ “ዋቀዮ ዋቅን እስራኤል አከነ ጄዸ፤ ‘ቶኮን ቶኮን ነማ ሙዺሳት ጎራዴ ሃህዸቱ፤ ቶኮን ቶኮን ነማስ ቁበተ ሰነ ኬሰ ከረ ቶኮራ ገረ ከረ ካኒት አሲፊ አች ዴሜ ኦቦሎተሳ፣ ምቾተሳቲፊ ኦላሳ ሃአጄሱ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","ሌዎትንስ አኩመ ሙሴን እሳን አጀጄ ጎዸን፤ ጉያ ሰነ ሰበ ሰነ ኬሳ ነመ ገረ ኩመ ሰዲቱ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","ሙሴንስ፣ “እስን ዋን እልማንኬሰኒፊ ኦቦሎተኬሰንት ካተኒፍ ሀርአ ዋቀዮፍ አዳን ባፈምተኒርቱ፤ እንስ ጉያ ሀርኣ እስን ኤብሴረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","ሙሴን ጉያ እት ኣኑት ሰበ ሰናን፣ “እስን ጩቡ ጉዳ ሆጄተኒርቱ። ገሩ አን አመ ገረ ዋቀዮት ኦል ነንበአ፤ ተሪ አን ጩቡኬሰኒፍ አራረ ነንቡሰ ተአ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","ሙሴንስ ዴብኤ ገረ ዋቀዮ ዸቄ አከነ ጄዼ፤ “ወዮ! ሰብን ኩን ጩቡ አከም ጉዳ ሆጄቴ! እሳን ኦፊሳኒቲፍ ዋቆተ ወርቄ ቶልፈተኒሩ። ");
INSERT INTO gaze_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","ተኡስ ማሎ አመ ጩቡሳኒ ዺሲፍ፤ ዮ ከና አች ክታበ በሬስቴ ሰነ ኬሳ መቃኮ ሀቅ።” ");
INSERT INTO gaze_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","ዋቀዮሞ ሙሴዻን አከነ ጄዼ፤ “አን ነመ ጩቡ ነት ሆጄቴ ክታበኮራ ነንሀቀ። ");
INSERT INTO gaze_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","አመ ከኢቲ ገረ ለፈ አን ስት ህሜ ሰናት ሰበ ከነ ቀጄልች፤ ኩኖ ኤርገማንኮስ ፉለኬ ዱረ ንዴመ። ገሩ ጋፈ ዬሮን አን እሳን አደቡ ገኡት አን ጩቡሳኒቲፍ እሳን ነንአደበ።” ");
INSERT INTO gaze_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","ሰበቢ በሌሳ እሳን ጀቢ አሮን ቶልቼ ሰናን ሆጄተኒቲፍ ዋቀዮ በላዻን ሰበ ሰነ ዸኤ። ");
INSERT INTO gaze_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አቲፊ ሰብን አት ብየ ግብጢቲ ባፍቴ ፍዴ ኩን አሲ በኣቲ ገረ ብየ አን አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ፣ ‘አን ሰኚኬቲፍ ነንኬነ’ ጄዼ ከከዼ ሰና ዸቃ። ");
INSERT INTO gaze_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","አን ኤርገማኮ ፉለኬ ዱራን ኤርጌ ከነኣኖተ፣ አሞሮተ፣ ሄቶተ፣ ፌርዞተ፣ ሂዎታፊ ዬቡሶተ አርኤ ነንባሰ። ");
INSERT INTO gaze_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","ገረ ብየ ኣነኒፊ ደም ኬሳ ቡርቁ ዸቅ። ገሩ ዋን አት ሰበ መተ ጀቤሰ ታቴፍ አን አከ ከራት ስ ህንበሌስኔፍ ስ ወጅን ህንዴሙ።” ");
INSERT INTO gaze_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","ጀር ዮሙ ኦዱ ሀማ ከነ ዸገአንት ገዱ ጀልቀበን፤ እሳን ኬሳስ ነምን ቶኮዩ ፋየ ቶኮሌ ህንካአትኔ። ");
INSERT INTO gaze_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","ዋቀዮ ሙሴዻን አከነ ጄዼራቲ፤ “ሰበ እስራኤሊን አከነ ጄዽ፤ ‘እስን ሰበ መተ ጀቤዪዸ። አን ኡቱ ዬሩመ ሙራሰሌ እስን ወጅን ዴሜ ስላ እስን በሌሰ ቱሬ፤ እስን አመ ፋየወንኬሰን ኦፍራ ባሳ፤ አንስ ዋነን እስን ጎዹ ነንሙርቴሳ።’ ” ");
INSERT INTO gaze_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","ከናፉ እስራኤሎን ጋረ ኮሬብ ብረት ፋየወንሳኒ ኦፍራ ባሰን። ");
INSERT INTO gaze_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","ሙሴን ዱንካነ ቶኮ ፉዼ እዶ ቁበታ ሰነ ኬሳ ባሴ አች ፈጌሴ ዻበ ቱሬ፤ ዱንካነ ሰነስ፣ “ዱንካነ ወል ገኢ” ጄዼ ሞጋሴ። ነምን ዋቀዮን በርባደቱ ሁንድኑ እዶ ቁበታ ሰነ ኬሳ በኤ ገረ ዱንካነ ወል ገኢ ሰና ዸቀ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","ዬሮ ሙሴን በኤ ገረ ዱንካነ ሰና ዸቁ ሁንደ ሰብን ሁንድኑ ከኤ በልበለ ዱንካነ ኦፊሳ ዱረ ዻበቴ ሀመ እን ዱንካንቸ ሴኑት እላለ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","ዬሮ ሙሴን ዱንካነ ሰነ ሴኑት ኡቱባን ዱሜሳ ገድ ቡኤ በልበለ ዱንካንቻ ዱረ ዻበተ ቱሬ፤ ዋቀዮስ ሙሴ ወጅን ዱበተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","ሰብን ዬሮ ኡቱባ ዱሜሳ ከን በልበለ ዱንካና ዱረ ዻበቱ አርጉት ሁንድሳ ኦል ከኤ ቶኮን ቶኮን ነማ ዱንካነ ኦፊሳ ዱረት ሰገደ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","ዋቀዮስ አኩመ ነመ ምቹሳ ወጅን ሃሰኡ ቶኮት እፉማን እፈት ሙሴት ዱበቻ ቱሬ። ኤርገሲስ ሙሴን እዶ ቁበታት ዴብአ ቱሬ፤ ገርጋራንሳ፣ እያሱን እልም ኑን ደርገጌስ ሱን ገሩ ዱንካነ ሰነ ብራ ህንዴሙ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","ሙሴን ዋቀዮን አከነ ጄዼ፤ “እላ፣ አት፣ ‘ሰበ ከነ ዱረ ቡኢ ባስ’ ናን ጄቴርተ፤ ገሩ አነ ወጅን ኤኙን አከ ኤርግቱ ነ ህንቤክስፍኔ። አት፣ ‘አን መቃዻን ስ ቤከ፤ አት ነ ብረት ፉዸተመ አርገቴርተ’ ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","አመስ አን ፉለኬ ዱረት ሱራ አርገዼ ዮን ጅራዼ፣ አከ አን ስ ቤኩፊ አከ አን ፉለኬ ዱረት ሱራ አርገዹፍ ከራኬ ነ በርሲስ፤ አከ ሰብን ኩን ሰበኬ ተኤስ ያደዹ።” ");
INSERT INTO gaze_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","ዋቀዮስ ዴብሴ፣ “አን ስ ወጅን ነንዴመ፤ ቦቆናስ ሲፍን ኬነ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","ሙሴንሞ አከነ ጄዼን፤ “ዮ አት ኑ ወጅን ዴሙ ባቴ፣ አሲ ኑ ህንባስን። ");
INSERT INTO gaze_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","አት ኑ ወጅን ዴሙ ባናን ነምን አከሚን አከ አት አናፊ ሰበኬት ገመዱ ቤከ? ወን አናፊ ሰበኬ ሰቦተ ለፈራ ካን ሁንደራ አዳን ባሱ ብራ ማልሬ?” ");
INSERT INTO gaze_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","ዋቀዮሞ ሙሴዻን፣ “አን ዋን አት አመ ከዸቴ ከነ ነንጎዸ፤ አት ፉለኮ ዱረት አያነ አርገቴርታቲ፤ አንስ መቃዻን ስ ቤከ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","ሙሴንስ፣ “ማሎ ኡልፍነኬ ነ አርግሲስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","ዋቀዮሞ አከነ ጄዼ፤ “አን ጋሩማኮ ሁንዱማ ፉለኬ ዱረ ነንደበርሰ፤ መቃ ዋቀዮ ፉለኬ ዱረት ነንለብሰ። አን ከነን ማሩ ነንማረ፤ ከነን ገራ ላፉፊስ ገራ ነንላፈ። ");
INSERT INTO gaze_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","ገሩ ዋን ነምን ፉለኮ አርጌ ጅራቹ ህንደንዴኜፍ አት ፉለኮ አርጉ ህንደንዴሱ።” ");
INSERT INTO gaze_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","ኤርገሲስ ዋቀዮ አከነ ጄዼ፤ “ኩኖ አስ ነ ብረ እዶን አት ከታረ ዻበቹ ደንዴሱ ጅረ። ");
INSERT INTO gaze_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","አን ዬሮ ኡልፍንኮ ደርቡት ጅሩ ሆልቀ ከታ ኬሰ ስ ካኤ ሀመ አን ደርቡት ሀርከኮቲን ስ ደኤሰ። ");
INSERT INTO gaze_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","ኤርገሲስ አን ሀርከኮ ነንፉዸዸ፤ አትስ ዱግደኮ ንአርግተ፤ ፉልኮ ገሩ አርገሙ ህንቀቡ።” ");
INSERT INTO gaze_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ገበቴወን ዸጋ ለመ አኩመ ከኔን ዱራ ሰናት ሶፍ፤ አንስ ዱቢ ገበቴወን አት ጨጨብስቴ ሰነረ ቱረን እሳንረት ነንበሬሰ። ");
INSERT INTO gaze_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","አትስ ገነማን ቆጳዪቲ ቱሉ ሲናት ኦል በእ። አችት፣ ፊጤ ቱሉ ሰናረት ፉለኮ ዱረት ኦፍ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","ነምን ቶኮዩ ስ ወጅን ህንዹፍን ዮካን ቱሉ ሰነረት ኤሱመቱ ህንሙልአትን። ቡሻዬፊ ሎንዩ ፉለ ቱሉ ሰና ዱረት ህንቦበእን።” ");
INSERT INTO gaze_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","ሙሴንስ ገበቴወን ዸጋ ለመ አኩመ ከኔን ጀልቀባት ሶፌ፤ እንስ ገበቴወን ለማንስ ሀርከት ቀበቴ አኩመ ዋቀዮ እሰ አጀጄት ገነመ በሪን ቱሉ ሲናት ኦል በኤ። ");
INSERT INTO gaze_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","ዋቀዮ ዱሜሳን ገድ ቡኤ እሰ ወጅን አች ዻበቴ፤ መቃ ዋቀዮስ ንለብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","ዋቀዮ ፉለ ሙሴ ዱረ ደርቤ አከነ ጄዼ ለብሴ፤ “ዋቀዮ፣ ዋቀዮ ዋቀ ገረ ላፌሳፊ አርጃ፣ ከን ደፌ ህንኣሬ፣ ከን ጃለሊፊ አመነሙማንሳ ጉዳ፣ ");
INSERT INTO gaze_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","ከን አራረሳ ዸሎተ ኩማተማፍ ቱርሱ፣ ከን ሀምነ፣ ፍንጭላፊ ጩቡ ነማፍ ዺሱዸ። ተኡሌ እን ነመ የከ ሆጄቱ አደቡ መሌ ህንዺሱ፤ እን ሀመ ዸሎተ ሰደፋፊ አፉረፋት ሰበቢ ጩቡ አቦቲሳኒቲፍ ጄዼ እጆሌሳኒቲፊ እጆሌ እጆሌሳኒ ንአደበ።” ");
INSERT INTO gaze_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","ሙሴን ዮሙሱመ ለፈት ገድ ጄዼ ሰገዴ። ");
INSERT INTO gaze_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","እንስ፣ “ያ ጎፍታ፣ ዮ አን ፉለኬ ዱረት አያነ አርገዼ ጅራዼ፣ ጎፍታን ኑ ወጅን ሃዴሙ። ዮ ሰብን ኩን ሰበ መተ ጀቤሰ ተኤሌ ሀምነኬኛፊ ጩቡኬኘ ኑ ዺስ፤ ዻለኬስ ኑ ጎዸዹ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","ከነረት ዋቀዮ አከነ ጄዼ፤ “ኩኖ አን ስ ወጅን ከኩ ነንገለ። አን ፉለ ሰበኬ ሁንዳ ዱረት ድንቂወን ከናን ዱረ ሰበ ከምዩ ኬሰት፣ አዱኛ ሁንደ ኬሰት ተኩማ ህንሆጄተምን ነንሆጄዸ። ሰብን አት ኬሰ ጅራቱስ አከ ሆጂን አን ዋቀዮ ሲፍ ሆጄዹ ሀመም ሶዳችሳ ተኤ ንአርገ። ");
INSERT INTO gaze_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","ዋን አን ሀርአ ስ አጀጁፍ አጀጀም። አንስ አሞሮተ፣ ከነኣኖተ፣ ሄቶተ፣ ፌርዞተ፣ ሂዎታፊ ዬቡሶተ ፉለኬ ዱራ አርኤ ነንባሰ። ");
INSERT INTO gaze_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","አከ ወረ ብየ አት እት ገሉፍ ዴምቱ ሰነ ኬሰ ጅራተን ወጅን ከኩ ህንገሌፍ ኦፍ ኤገዹ፤ ዮ ከና አቺ እሳን ክዮ ስት ተኡ። ");
INSERT INTO gaze_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","እዶወን ኣርሳሳኒ ዲጋ፤ ሲዳወን ዋቄፈትናሳኒ ጨጨብሳ፤ ኡቱባወን ኣሼራሳኒስ ጅጅግሳ። ");
INSERT INTO gaze_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","ሰበቢ ዋቀዮ መቃንሳ ህናፋ ጄዸሙ ሱን ዋቀ ህናፉ ተኤፍ አት ዋቀ ብራ ህንዋቄፈትን። ");
INSERT INTO gaze_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“አት አከ ወረ ብየ ሰነ ኬሰ ጅራተን ወጅን ከኩ ህንገሌፍ ኦፍ ኤገዹ። ሰበቢንሳ እሳን ዮሙ ዋቆተሳኒ ወጅን ሰጋገለኒፊ ዮሙ ዋቆተሳኒቲፍ ኣርሳ ዽኤሰንት ስ ዋሙ፤ አትስ ኣርሳሳኒ ንኛተ። ");
INSERT INTO gaze_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","ዬሮ አት እልማንኬ እንተለንሳኒ ፉስፍቴ፣ እንተለንሳኒ ሱን ዋቆተሳኒ ወጅን ሰጋገለንት እሳን አከ እልማንኬስ አኩመሳኒ ሰጋገለን ጎዹ። ");
INSERT INTO gaze_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“ዋቆተ ቶልፈሞ በቅፈመኒ ሆጄተመን ህንቶልፈትን። ");
INSERT INTO gaze_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“አያነ መጥኖ አያኔፈዹ። አት ሰበቢ ጅአ አቢቢ ኬሰ ግብጢ ባቴፍ አኩመ አን ስ አጀጄ ሰነት ጅአ አቢቢ ኬሰ ዬሮ ሙርቴፈሜት ቡልቲ ቶርበ መጥኖ ኛዹ። ");
INSERT INTO gaze_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“ከን ጀልቀበት ገደሜሰ ሳቄ በኡ ሁንድ ከንኮት፤ ኮርም ሆሪኬቲ ሀንገፍን ጄቹንስ ኮርም ሎኒቲፊ ኮርም ሆሎታ ሀንገፍንኮት። ");
INSERT INTO gaze_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","ሀሬ ሀንገፈ ጦባላ ሆላቲን ፉር፤ ዮ ፉሩ ባቴሞ ሞርመሳ ጨብስ። እልማንኬ ሀንገፈ ሁንደስ ፉር። “ነምን ቶኮዩ ሀርከ ዱዋ ፉለኮ ዱረት ህንዽኣትን። ");
INSERT INTO gaze_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“ጉያ ጀአ ሆጂ ሆጄዹ፤ ጉያ ቶርበፋት ገሩ ቦቆዹ። ዬሮ ቆናቲፊ ዬሮ ምዻን ገልፈሙት ቦቆዹ። ");
INSERT INTO gaze_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“መታ ቀመዲ ጀልቀባረት አያነ ቶርበኖታ አያኔፈዹ፤ ዹመ ወጋረትሞ አያነ ገልቻ ምዻኒ አያኔፈዹ። ");
INSERT INTO gaze_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","ዺርኬ ሁንድ ወጋት ዬሮ ሰዲ ፉለ ዋቀዮ ጎፍታ፣ ፉለ ዋቀ እስራኤል ዱረት ሃዽኣተን። ");
INSERT INTO gaze_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","አን ነሞተ ኦርማ ስ ዱራ አርኤ ነንባሰ፤ ዳንጋኬ ነንበልእሰ፤ ዮ አት ወጋት ዬሮ ሰዲ ዋቀዮ ዋቀኬ ዱረት ዽኣቹ ዸቅጡስ ነምን ቶኮዩ ብየኬ ፉዸቹ ህንሀዉ። ");
INSERT INTO gaze_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“ዺገ ኣርሳ ዋን ራጭቲ ቀቡ ወጅን ና ህንዽኤስን፤ ቀልም አያነ ፋሲካራ ሀፉስ ሀመ በሪት ህንቱርን። ");
INSERT INTO gaze_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“መታ ምዻን ለፈኬቲ ኬሳ ፍለተማሳ ገረ መነ ዋቀዮ ዋቀኬቲ ፍድ። “እልሞ ሬኤ ኣነን ሃዸሼቲን ህንአፌልን።” ");
INSERT INTO gaze_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","ዋቀዮስ ሙሴዻን፣ “ዱቢ ከነ በሬስ፤ አን አኩመ ዱቢ ከናት ስኢፊ ሰበ እስራኤል ወጅን ከኩ ገሌራቲ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","ሙሴንስ ኡቱ ቡዴነ ህንኛትን ዮካን ኡቱ ብሻን ህንዹግን ጉያ አፉርተማፊ ሀልከን አፉርተመ ዋቀዮ ብረ አች ቱሬ። እንስ ዱቢ ከኩ ሰነ ጄቹንስ አጀጀወን ኩርነን ገበቴወን ሰነረት በሬሴ። ");
INSERT INTO gaze_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","ሙሴን ገበቴወን ዹገ በኡምሳ ለማን ሰነ ሀርከት ቀበቴ ቱሉ ሲናራ ገድ ቡኤ፤ እንስ ሰበቢ ዋቀዮ ወጅን ዱበቻ ቱሬፍ አከ ፉልሳ ጨለቅሱ ህንቤክኔ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","ዮሙ አሮኒፊ ሰብን እስራኤል ሁንድ ሙሴ አርገንት ኩኖ፣ ፉልሳ ጨለቅሳ ቱሬ፤ እሳንስ እሰት ዽኣቹ ሶዳተን። ");
INSERT INTO gaze_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","ሙሴን ገሩ እሳን ዋሜ፤ አሮኒፊ ቡልችቶትን ሀዋስቻ ሁንድኑስ ገረሳት ዴብአን፤ እንስ እሳንት ዱበቴ። ");
INSERT INTO gaze_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","ሰብን እስራኤል ሁንድ እሰት ዽኣቴ፤ እንስ ዋን ዋቀዮ ጋረ ሲናረት እሰት ዱበቴ ሁንደ እሳን አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","ሙሴን ዮሙ እሳንት ዱበቴ ፍጠቴት ፉለሳ ሀጉገቴ። ");
INSERT INTO gaze_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","ዮሙ ዋቀዮ ወጅን ዱበቹዻፍ ፉለሳ ዱረት ኦል ሴኑ ገሩ ሀመ አቺ በኡት ሀጉጊ ሰነ ኦፍራ ፉዸ ቱሬ። ዮሙ እን አቺ በኤ ዋን አጀጀሜ ሰነ ሰበ እስራኤልት ህሙት፣ ");
INSERT INTO gaze_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","እሳን አከ ፉልሳ ጨለቅሱ አርገን። ኤርገሲ ሙሴን ሀመ ዋቀዮ ወጅን ዱበቹፍ ኦል ገሉት ፉለሳ ዴብሴ ሀጉገተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","ሙሴን ወልዳ እስራኤል ጉቱ ወልት ቀቤ አከነ ጄዼን፤ “ወን ዋቀዮ አከ እስን ሆጄተን እስን አጀጄ ከነ፦ ");
INSERT INTO gaze_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","ጉያ ጀአ ሆጂን ሃሆጄተሙ፤ ጉያን ቶርበፋን ገሩ እስኒፍ ጉያ ቁልቁሉዸ፤ ዋቀዮፍሞ ሰንበተ ቦቆና ተአ። ነምን ጉያ ከነ ሆጂ ሆጄቱ ከምዩ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","ጉያ ሰንበታቲን ለፈ ጅራተን ከምትዩ እብደ ህንቀብሲስና።” ");
INSERT INTO gaze_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","ሙሴንስ ወልዳ እስራኤል ጉቱዻን አከነ ጄዼ፤ “ወን ዋቀዮ አጀጄ ከነ፦ ");
INSERT INTO gaze_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","ዋን ቀብደንራ ዋቀዮፍ ኬና ዽኤሳ። ነምን ፌዺ ቀቡ ሁንድኑ፦ “ኬና ወርቄ፣ ሜቲፊ ናሲ ዋቀዮፍ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ጋሪ፣ ርፌንሰ ሬኤ፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","ጎጋ ኮርቤሰ ሆላ ከን ሀሉ ዲማ ጩጰሜፊ ጎጋ ዱገሜ፣ ሙከ ላፍቶ፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","እብሳዻፍ ዘይቲ ኤጄርሳ፣ ዘይቲ እቲን ድበኒፊ እጣነ ኡርጋኡፍሞ ኡርጎፍቱወን፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","ዸጋወን ሰርዶንክሲ፣ ዶቀ ገት ጀቤሰ፣ ድረታፊ ቆሜረት ካአተሙ ከን ብራ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“እስን ኬሳ ነሞትን ኦጌዪን ሁንድ ዹፈኒ ዋን ዋቀዮ አጀጄ ሁንደ ሃሆጄተን፦ ");
INSERT INTO gaze_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“ኩንስ ዱንካነ ቁልቁሉ ዱንካነሳቲፊ እረ ቡሳሳ ወጅን፣ ሆኮወንሳ፣ ቱጌሳ፣ ደገሌሳ፣ ኡቱባሳ፣ ሚለሳ፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","ታቦተ ደንቀራሳ ወጅን፣ ቴሶ አራራቲፊ ጎልጋ እሰ ዾክሱስ፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","ምንጃለ ደንቀራሳቲፊ ምአሳ ሁንደ ወጅን፣ ቡዴነ እላልቻ፤ ");
INSERT INTO gaze_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","ባቱ እብሳ ከን እፋፍ ተኡ ምአሳ ወጅን፣ እፈ ሰናፍስ እብሳፊ ዘይቲ፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","እዶ ኣርሳ እጣና ደንቀራሳ ወጅን፣ ዘይቲ እቲን ድበኒፊ እጣነ ኡርጋኡ፣ ከረ እቲን ዱንካነ ቁልቁሉ ሴነኒፍስ ጎልጋ በልበላ፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","እዶ ኣርሳ ከን ቀልመ ጉበሙ ግንግልቻሳ ከን ናሲራ ሆጄተሜ ወጅን፣ ደንቀራወንሳቲፊ ምአሳ ሁንደ፣ ጫቢ ናሲ ሚለሳ ወጅን፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","ጎልጋወን ኦብዲ ኡቱባወኒፊ ሚለወንሳኒ ወጅን፣ ጎልጋ ከረ ኦብዲ ሰና፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","ዱንካነ ቁልቁሉፊ ቆፎወን ኦብዲ ዱንካነ ቁልቁሉቲፊ ፉኞወንሳኒ፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","ወያወን ፎአመኒ ዸአመን ከኔን እሳን ዬሮ እዶ ቁልቁሉ ኬሰ ተጃጅለን ኡፈተመን ጄቹንስ ወያወን አሮን ሉብቻፍ ቁልቁሌፈመኒፊ ወያወን እልማንሳ ዬሮ ሉቡማዻን ተጃጅለንት ኡፈተን ሃሆጄተን።” ");
INSERT INTO gaze_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","ኤርገሲስ ሀዋስን እስራኤል ጉቱን ሙሴ ብራ በአኒ ዴመን፤ ");
INSERT INTO gaze_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","ነምን ፌዺ ቀቡፊ ነምን ያድንሳ እሰ ከካሴ ሁንድ ዹፌ ሆጂ ዱንካነ ወል ገኢ ሰናቲፍ፣ ተጃጅለሳ ሁንዳፊ ሆጂ ወያወን ቁልቁሉ ሰናቲፍ ኬና ዋቀዮፍ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","ዺሪፊ ዱበርቲን ፌዺ ቀበን ሁንድ ምአ ወርቄራ ሆጄተሜ ከኔን ጎሰ ጎሳ ፍደን፤ ብተዎ፣ ሎቲ፣ ቁቤላፊ ፋየ ፍደን። ሁንድሳኒዩ ወርቄሳኒ ኣርሳ ሶቾፈሙ ጎዸኒ ዋቀዮፍ ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","ነምን ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ ዮካን ብልዲማ ዮካን ቁንጬ ተልባ በኤሰ ዮካን ርፌንሰ ሬኤ፣ ከልዼ ኮርቤሰ ሆላ ከን ሀሉ ዲማ ጩጰሜፊ ጎጋ ዱገሜ ቀቡ ሁንድ ንፍዴ። ");
INSERT INTO gaze_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","ወር ኬና ሜቲ ዮካን ናሲ ዽኤሰን ኬና ዋቀዮፍ ዽኤፈሙ ጎዸኒ ፍደን። ነምን ሙከ ላፍቶ ከን ቆደ ሆጂ ሰና ከሚፍዩ ተኡ ቀቡ ሁንደስ ንፍዴ። ");
INSERT INTO gaze_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","ዱበርቶትን ኦጌዪን ሁንድስ ሀርካን ፎአኒ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ በኤሰ ፎአን ሰነ ፍደን። ");
INSERT INTO gaze_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","ዱበርቶትን ፌዺፊ ኦጉማ ቀበን ሁንድኑስ ርፌንሰ ሬኤ ፎአን። ");
INSERT INTO gaze_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","ቡልችቶትን ዸጋወን ሰርዶንክሲፊ ዸጋወን ገት ጀቤዪ ብራ ድረታፊ ኪሲ ቆማት አከ ካአተሙፍ ፍደን። ");
INSERT INTO gaze_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","አከሱመስ ኡርጎፍቱፊ ዘይቲ እብሳዻፍ፣ ዘይቲ እቲን ድበኒፊ እጣነ ኡርጋኡስ ፍደን። ");
INSERT INTO gaze_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","ዺሮትኒፊ ዱበርቶትን እስራኤል ወር ፌዺ ቀበን ሁንድ ሆጂ አከ እሳን ሆጄተኒፍ ዋቀዮ ከራ ሙሴቲን እሳን አጀጄ ሰነ ሁንዳፍ ፌዺሳኒቲን ዋቀዮፍ ኬና ፍደን። ");
INSERT INTO gaze_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","ዮሙስ ሙሴን ሰበ እስራኤሊን አከነ ጄዼ፤ “እላ ዋቀዮ ጎሰ ይሁዳ ኬሳ ቤዘልኤል እልመ ኡር እልመ ሁር ፍለቴረ፤ ");
INSERT INTO gaze_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ሀፉረ ዋቃቲን፣ ኦጉማዻን፣ ደንዴቲፊ ቤኩምሰ ሆጂ ሀርካ ጎሰ ሁንዱማን እሰ ጉቴረ። ");
INSERT INTO gaze_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","ኩንስ አከ እን ወርቄዻን፣ ሜቲፊ ናሲዻን ሆጂ ኦጉማ ሆጄቱፍ፣ ");
INSERT INTO gaze_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","አከ ዸጋወን ሙሬ ቆጴሱፍ፣ አከ ሙከ ሶፉፊ አከ ሆጂ ኦጉማ ሀርካ ከን ጎሰ ሁንዳ ኬሰት ህርማቱፍ። ");
INSERT INTO gaze_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","ዋቅንስ ቤዘልኤሊፊ ኦሆሊያብ እልመ አሂሳማክ ከን ጎሰ ዳን ሰናፍ ደንዴቲ እሳን እቲን ወረ ካን በርሲሰን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","አከ እሳን ኦጌዪ ሆጂ ሀርካ፣ ብፈ ባስቶታፊ ወረ ክሪ ብፈ ጩቁሊሳቲን፣ ዺልጌን፣ ብልዲማፊ ቁንጬ ተልባ በኤሳን ሚዸግሰኒፊ ወያ ዾፍቶተ ሁንድሳኒ ኦጌዪ ሆጂ ሀርካቲፊ ብፈ ባስቶተ ተአኒፍ ኦጉማ ሆጂ ጎሰ ሁንዳ ሆጄቹቲን እሳን ጉቴ። ");
INSERT INTO gaze_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","ቤዘልኤል፣ ኦሆሊያቢፊ ነምን ዋቀዮ ኦጉማፊ ደንዴቲ እሳን እቲን ሆጂ እጃርሰ እዶ ቁልቁሉ ሰና ሁንደ ቤከን ኬኔፍ ሁንድ አኩመ ዋቀዮ አጀጄት ሆጂ ከነ ሃሆጄተን።” ");
INSERT INTO gaze_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","ሙሴን ቤዘልኤል፣ ኦሆሊያቢፊ ኦጌሰ ዋቀዮ ደንዴቲ ኬኔፍ ከን ዹፌ ሆጂ ሰነ ሆጄቹፍ ፌዺ ቀቡ ሁንደ ዋሜ። ");
INSERT INTO gaze_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","እሳንስ ኬናወን እስራኤሎን እጃርሰ እዶ ቁልቁሉ ሰናቲፍ ጄዸኒ ፍደን ሁንደ ሙሴ ሀርካ ፉዸን። ነሞትን እስራኤልስ ፌዺሳኒቲን ገነመ ገነመ ኬናሳኒ ፍዱ እት ፉፈን። ");
INSERT INTO gaze_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","ኦጌዪን ሆጂ ሀርካ ከኔን እዶ ቁልቁሉ ሰነ ሆጄተን ሁንድ ሆጂሳኒ ዺሰኒ ዹፈኒ ");
INSERT INTO gaze_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","ሙሴዻን፣ “ሰብን ኩን ዋን ሆጂ ዋቀዮ አከ ሆጄተሙፍ አጀጄ ሰናፍ በርባችሱ ጫላ ፍዳ ጅረ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","ሙሴንስ አጀጀ ኬኔ፤ እሳንስ፣ “ዺር ዮካን ዱበርቲን ቶኮዩ ዋን ብራ ቶኮሌ ኬና ጎዼ እዶ ቁልቁሉ ሰናፍ ህንዽኤስን” ጄዸኒ እዶ ቁበታ ሰነ ኬሰት ለብሰን። ከናፉ ነሞትን እት ፉፈኒ ዋ ፍዱ ዾወመን። ");
INSERT INTO gaze_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","ወንት እሳን ዱራኑ ቀበን ሆጂ ሁንደ ሆጄቹፍ ገኣ እራ ሀፋ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","ሆጄቶተ ሰነ ኬሳስ ኦጌዪን ሁንድ ጎልጋወን ኩዸን ከኔን ቁንጬ ተልባ ጋሪ ፎአሜፊ ከን ክሪ ብፈ ጩቁሊሳ፣ ዺልጌፊ ብልዲማራ ሆጄተመኒን ዱንካነ ቁልቁሉ ሃሆጄተን፤ ጎልጋወን ሰነረትስ ኦጌዪን ሀርከ ቀጄለን ኪሩቤሊ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","ጎልጋወን ሱን ሁንድኑ ወል ቅጤ ተአኒ ቶኮን ቶኮንሳኒ ዼርነ ዹንዹመ ድግደሚ ሰዴቲቲፊ በልእነ ዹንዹመ አፉር ቀቡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","እሳንስ ጎልጋወን ሸን ወልት ቀብሲሰን፤ ሸነን ካንሌ አከሱመ ወልት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","እሳንስ ጎልጋወን ወልት ቀብሲፈመን ከኔን ጀልቀባ ኬሳ ሀንዳረ እሰ ሞጋረት ሁጩ ብፈ ጩቁሊሳራ ጉሮወን ቶልቸን፤ ጎልጋወን ወልት ቀብሲፈመን ለመፋረትስ አከሱመ ቶልፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","እሳንስ ጎልጋ ቶኮረት ጉሮወን ሸንተመ ቶልቸን፤ ጉሮወን ሸንተመሞ ጎልጋወን ወልት ቀብሲፈመን ለመፋ ኬሳ እሰ ሞጋረት ቶልቸን፤ ጉሮወን ሱንስ ገማ ገመናን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","አከ ዱንካን ቁልቁሉን ሱን ቶኮ ተኡፍስ ሆኮወን ወርቄ ሸንተመ ቶልቸኒ ጎልጋወን ሰነ እቲን ወልት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","እሳንስ ሀጉጊ ጉባ ዱንካነ ቁልቁሉ ሰናረ ጅሩ ሀጉጉፍ ጎልጋወን ርፌንሰ ሬኤ ኩዸ ቶኮ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","ጎልጋወን ኩዸ ቶኮን ሱን ሁንድ ወል ቅጤ ቱረን፤ ዼርንሳኒ ዹንዹመ ሶዶመ፣ በልእንሳኒሞ ዹንዹመ አፉር ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","እሳንስ ጎልጋወን ሸን እዶ ቶኮት ወልት ቀብሲሰን፤ ጎልጋወን ካን ጀኣንሞ እዶ ቶኮት ወልት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","ኤርገሲስ ጎልጋወን ገመ ቶኮን ወልት ቀብሲፈመን ኬሳ ሀንዳረ እሰ ሞጋረት ጉሮወን ሸንተመ ቶልቸን፤ ጎልጋወን ገመ ካንረት ወልት ቀብሲፈመን ኬሳስ ሀንዳረ እሰ ሞጋረት ጉሮወን ሸንተመ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","አከ ዱንካን ሱን ቶኮ ተኡፍ እቲን ወልት ቀብሲሱፍ ቀብዱወን ናሲ ሸንተመ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","ዱንካነ ሰናፍስ እረ ቡሳ ከልዼ ኮርቤሰ ሆላ ከን ሀሉ ዲማ ጩጰሜ፣ እሰ እራንሞ እረ ቡሳ ጎጋ ዱገሜ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","ዱንካነ ቁልቁሉ ሰናፍስ ሙከ ላፍቶራ ቱጌወን ቀቀጄሎ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","ዼርን ቶኮ ቶኮ ቱጌወን ሰናስ ዹንዹመ ኩዸን፣ በልእንሳሞ ዹንዹመ ቶኮፊ ወለካ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","ቶኮን ቶኮን ቱጌወን ሰናስ አከ ወል ኬሰ ገሉ ደንደኡፍ ሙቸ ለመ ለመ ቀበ ቱሬ። ቱጌወን ዱንካነ ቁልቁሉ ሰና ሁንደ አከስት ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","ገመ ክበ ዱንካነ ቁልቁሉ ሰናቲፍስ ቱጌወን ድግደመ ሆጄተን፤ ");
INSERT INTO gaze_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","ቱጌወን ድግደመን ሰነ ጀለት ሚለ ሜቲ አፉርተመ ጄቹንስ ቱጌ ቶኮ ጀለት ሚለ ለመ ጉረሳ ለማኒፍ፣ ቱጌ ካን ጀለትስ ሚለ ለመ ጉረሳ ለማኒፍ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","ገመ ዱንካነ ቁልቁሉ ሰና ካኒፍስ ከራ ካባቲን ቱጌወን ድግደመ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","እሳኒፍስ ሚለ ሜቲስ አፉርተመ ጄቹንስ ቱጌ ቶኮ ጀለት ሚለ ለመ፣ ቱጌ ካን ጀለትስ ሚለ ለመ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","ከራ ልጠ ቢፍቱቲን፣ ዱግደ ዱበ ዱንካነ ቁልቁሉ ሰናቲፍ ቱጌ ጀአ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","ከራ ዱግደ ዱባስ ጎሌ ዱንካነ ቁልቁሉ ሰናቲፍ ኡቱባ ለመ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","ቱጌወን ጎሌ ኩኔን ጀላ ሀመ ጉባት ወልት ፈይፈመኒ በንቲረት ቁቤላ ቶኮን ወልት ቀብሲፈመን፤ ቱጌወን ጎሌ ለማኒስ አከኑመ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","ከናፉ ቱጌወን ሰዴት ከኔን ሚለ ሜቲ ኩዸ ጀአ ቀበንቱ ቱሬ፤ ቶኮን ቶኮን ቱጌ ሰናስ ሚለ ለመ ለመ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","አከሱመስ ሙከ ላፍቶራ ደገሌወን ቶልቸን፤ ቱጌወን ዱንካነ ቁልቁሉ ሰነረ ገመ ቶኮን ጅረኒፍ ደገሌወን ሸን፣ ");
INSERT INTO gaze_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","ቱጌወን ገመ ካኒን ጅረኒፍ ሸን፣ ቱጌወን ዱግደ ዱባን ከራ ልጠ ቢፍቱቲን ጅረኒፍሞ ደገሌወን ሸን ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","ደገሌ ወለካ ጅሩ ሰነ አከ እን ግዱ ቱጌወኒቲን ሞጋ ቶኮ ሀመ ሞጋ ካኒት ፉለኡ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","ቱጌወን ሰነትስ ወርቄ ድበኒ አከ ደገሌወን ባተኒፍ ቁቤላወን ወርቄ እት ቶልቸን። ደገሌወን ሰናትስ አከሱመ ወርቄ ኡፍሰን። ");
INSERT INTO gaze_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","እሳንስ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ሀጲራ ጎልጋ ቶልቸን፤ ጎልጋ ከነረትስ ኦጌስ ሀርከ ቀጄሉ ቶኮ ፈኪ ኪሩቤሊ ቶልቼ። ");
INSERT INTO gaze_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","ጎልጋ ሰናፍስ ኡቱባወን ሙከ ላፍቶ አፉር ቶልቸኒ ወርቄ እት ኡፍሰን፤ ኡቱባ ሰናፍስ ሆኮወን ወርቄ ሆጄተኒ ሚለ ሜቲ አፉር እት ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","እሳንስ በልበለ ዱንካንቻቲፍ ጎልጋ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜ ሀርካን እረት ሆዸሜ ቶኮ ፋዬሰኒ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","እሳንስ ኡቱቦተ ሆኮ ቀበን ሸን ሆጄተኒ፣ ፊጤፊ ሶማወን ኡቱቦታት ወርቄ ኡፍሰን፤ ሚለሳኒ ሸነንስ ናሲራ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","ቤዘልኤል ሙከ ላፍቶራ ታቦተ ቶልቼ፤ ታቦትን ሱንስ ዹንዹመ ለማፊ ወለካ ዼረተ፤ ዹንዹመ ቶኮፊ ወለካ በልአተ፤ ዹንዹመ ቶኮፊ ወለካ ኦል ዼረተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","እንስ ኬሳፊ ዱበሳት ወርቄ ቁልቁሉ ኡፍሴ፤ ናኖ እሳትስ መርሳ ፋየ ወርቄ ናኔሴ ቶልቼ። ");
INSERT INTO gaze_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","ቁቤላ ወርቄ አፉር ቶልቼፊ ሚለሳ አፍረንት ቀብሲሴ፤ ቁቤላ ለመ ገመ ቶኮን፣ ቁቤላ ካንሞ ገመ ካኒን እት ካኤ። ");
INSERT INTO gaze_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","ኤርገሲስ ሙከ ላፍቶራ ደንቀራወን ቶልቼ ወርቄ እት ኡፍሴ። ");
INSERT INTO gaze_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","እንስ ታቦተ ሰነ እቲን ባቹዻፍ ደንቀራወን ሰነ ቁቤላወን ኬሰ ሎሴ። ");
INSERT INTO gaze_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","እንስ ወርቄ ቁልቁሉራ ቴሶ አራራ ቶልቼ፤ ቴሶን ሱንስ ዼርነ ዹንዹመ ለማፊ ወለካፊ በልእነ ዹንዹመ ቶኮፊ ወለካ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","ሞጋ ለማን ቴሶ አራራረት ወርቄ ቱመሜራ ኪሩቤሊ ለመ ቶልቼ። ");
INSERT INTO gaze_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","እንስ ኪሩቢ ቶኮ ሞጋ ቶኮረት፣ ኪሩቢ ለመፋ ሞጋ ካንረት ቶልቼ፤ ኪሩቤሊ ለማን ሰነ ሞጋ ቴሶ አራራ ለማንረት ቴሶ አራራ ወጅን ሙኩመ ቶኮራ ቶልቼ። ");
INSERT INTO gaze_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","ኪሩቤሊን ሱን ቆቾሳኒ ኦል በልእፈተኒ ቴሶ አራራ ሰነት ጋድሴሱ ቱረን። ኪሩቤሊን ኩኔን ፉለሳኒ ወልት ገረገልፈተኒ ገረ ቴሶ አራራ እላሉ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","እሳንስ ሙከ ላፍቶራ ምንጃለ ደልገ ዼርንሳ ዹንዹመ ለመ፣ በልእንሳ ዹንዹመ ቶኮ፣ ኦል ዼርንሳ ዹንዹመ ቶኮፊ ወለካ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","እሳንስ ወርቄ ቁልቁሉ እት ኡፍሰኒ ናኖሳት መርሳ ወርቄ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","ናኖሳረትስ ህዺ ሀመ በልእነ ሀርካ ገኡፊ ፋየ ወርቄ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","እሳንስ ቁቤላ ወርቄ አፉር ምንጃለ ሰናፍ ሆጄተኒ እዶ ሚል አፍረን ቱሬት ጎሌወን አፍረንት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","ቁቤላወን ሱንስ አከ ደንቀራ ምንጃል ሱን እቲን ባተሙ ቀበኒፍ ጥዮ ሰነት ዽኤፈመኒ ካአመን። ");
INSERT INTO gaze_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","ደንቀራወን ምንጃል እቲን ባተሙ ሱን ሙከ ላፍቶራ ሆጄተመኒ ወርቄን እት ኡፍፈሜ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","ምኦተ ምንጃለ ሰነረ ካአመን ጄቹንስ ጫቢወንሳ፣ ወጪቲወንሳ፣ ወጪቲወንሳቲፊ ኦኮቴወንሳ ከኔን እቲን ዽባዩ ዽባፈተን ወርቄ ቁልቁሉራ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","ባቱ እብሳ፣ ሶማሳቲፊ ደሜሳ ወጅን ወርቄ ቁልቁሉራ ቱመኒ ቶልቸን፤ ወጪቲሳ፣ ሁዻሳቲፊ ደራራሳሌ ወርቄዹመ ቶኮራ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","ብታ ምርገ ባቱ እብሳ ሰነ ኬሳስ ደሜወን ጀአ ጄቹንስ ሰዲ ገመ ቶኮን ሰዲሞ ገመ ካኒን ባፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","ጦፎወን ለዉዚ ፈካተን ከኔን ቶኮን ቶኮንሳኒ ሁዻፊ ደራራ ቀበን ሰዲ ደሜ ቶኮረት፣ ወጪቲወን ለዉዚ ፈካተን ከኔን ቶኮን ቶኮንሳኒ ሁዻፊ ደራራ ቀበን ሰዲሞ ደሜ ካንረት ቶልቸን። ደሜወን ጀኣን ባቱ እብሳራ በበአን ሁንደረትስ አከሱመ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","ጦፎወን ሁዻፊ ደራራ ቀበን ከኔን ብፈ ለዉዚቲን ቶልፈመን አፉር ባቱ እብሳ ሰነረ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","ሁዻን ቶኮ ጭምዲ ጀልቀባ ከን ደሜወን ባቱ እብሳራ በበአን ጀለ፣ ሁዻን ለመፋን ጭምዲ ለመፋ ጀለ፣ ሁዻን ሰደፋንሞ ጭምዲ ሰደፋ ጀለ ቱሬ፤ ወሉማ ገለት ደሜወን ጀአቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","ሁዻወኒፊ ደሜወን ሁንድኑ ባቱ እብሳ ሰነ ወጅን ወርቄዹመ ቁልቁሉ ቱመሜ ቶኮራ ቶልፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","እብሳ ቶርበን ሰነ፣ ዋን እቲን ዳራሳ ዸዸአኒፊ ባቱ ዳራ ሰነ ባቱሌ ወርቄ ቁልቁሉራ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","ባቱ እብሳቲፊ ምአሳ ሁንደ ወርቄ ቁልቁሉ ታላንቲ ቶኮራ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","እሳንስ ሙከ ላፍቶራ እዶ ኣርሳ እጣና ቶልቸን፤ እዶን ኣርሳ ኩንስ ደልገ ዼርነ ዹንዹመ ቶኮ፣ በልእነ ዹንዹመ ቶኮፊ ኦል ዼርነ ዹንዹመ ለማ ቀባቴ ገመ አፍረኒኑ ወል ቅጤ ቱሬ። ጋንፈወንሳስ እዶ ኣርሳ ሰናን ወሉመት ሆጄተመን። ");
INSERT INTO gaze_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","እሳንስ ጉባሳረ፣ ጭናቸሳ ሁንዱማፊ ጋንፈወንሳት ወርቄ ቁልቁሉ ኡፍሰኒ ናኖሳት መርሳ ወርቄ ናኔሰኒ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","እዶ ኣርሳ ሰናፍስ መርሳወን ወርቄሳቲ ገድት ቁቤላወን ወርቄ ለመ ቶልቸን፤ ቁቤላወን ከነስ አከ እሳን ደንቀራወን እቲን እዶ ኣርሳ ባተን ቀበተኒፍ ገማ ገመናን ጭናቸ ለማንት ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","እሳንስ ደንቀራወን ሙከ ላፍቶ ቶልቸኒ ወርቄ እት ኡፍሰን። ");
INSERT INTO gaze_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","አከሱመስ አኩመ ኦጌሰ ኡርጎፍቱ ቆጴሱ ቶኮት ዘይቲ እቲን ድበን ቁልቁሉፊ እጣነ ኡርጋኣ መካ ህንቀብኔ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","እሳንስ ሙከ ላፍቶራ እዶ ኣርሳ ቀልመ ጉበሙ ከን ዹንዹመ ሰዲ ኦል ዼረቱ እጃረን፤ እዶን ኣርሳ ኩንስ ዼርነ ዹንዹመ ሸኒፊ በልእነ ዹንዹመ ሸኒ ቀባቴ ገመ አፍረኒኑ ወል ቅጤ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","ቶኮ ቶኮ ጎሌወን አፍረኒት ጋንፈ ቶልቸን፤ ጋንፋፊ እዶ ኣርሳ ሰነ ሙኩመ ቶኮራ ቶልቸን፤ እዶ ኣርሳ ሰነረትስ ናሲ ኡፍሰን። ");
INSERT INTO gaze_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","እሳንስ ምአሳ ሁንደ ጄቹንስ ዋን እቲን ዳራ ሀረን፣ ዋን እቲን ዳራ ሀማረን፣ ወጪቲ፣ ሆኮ ፎኒቲፊ ባቱ እብዳ ናሲራ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","እዶ ኣርሳ ሰናፍስ ናሲ ወል ኬሰ ጠጠሜን ግንግልቻ ሆጄተኒ አከ እን ሀመ ወለካ እዶ ኣርሳት ኦል በኤ መርሳሳ ጀላን ጅራቱ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","አከ እሳን ደንቀራወን ቀበተኒፍስ ጎሌወን ግንግልቻ ናሲ ሰና አፍረኒፍ ቁቤላወን ናሲ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","ደንቀራወን ሙከ ላፍቶስ ቶልቸኒ ናሲ እት ኡፍሰን። ");
INSERT INTO gaze_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","እዶ ኣርሳ ሰነ እቲን ባቹፍስ ደንቀራወን ሰነ ቁቤላወን ገማ ገመናን እዶ ኣርሳረ ጅረን ኬሰ ገልቸን። እዶ ኣርሳ ሰነስ ኬሰሳ ዱዋ ጎዸኒ ሳንቃራ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","እሳንስ ገበቴ እት ዽቀተን ከን ናሲ ሚለሳ ከን ናሲራ ሆጄተሜ ወጅን ኦፍ እላሌወን ዱበርቶተ በልበለ ዱንካነ ወል ገኢ ዱረ ተጃጅለኒራ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","ከነት ኣንሰኒ ኦብዲ ቶልቸን። ኦብድችስ ገመ ክባቲን ዹንዹመ ዽበ ቶኮ ዼረቴ ጎልጋ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜራ ሆጄተሜስ ቀበ ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","ኡቱባወን ድግደማፊ ሚለ ናሲ ድግደመ ቀበ ቱሬ፤ ኡቱባወን ኩኔንስ ሆኮወኒፊ ሶማወን ሜቲራ ሆጄተመን ቀቡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","ገመ ካባቲንስ አከሱመ ዹንዹመ ዽበ ቶኮ ዼረቴ ኡቱባወን ድግደማፊ ሚለ ናሲ ድግደመ ቀበ ቱሬ፤ ኡቱባወን ሱንስ ሆኮወኒፊ ሶማወን ሜቲራ ቶልፈመን ቀቡ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","ገመ ልጣቲን ዹንዹመ ሸንተመ በልአቴ ጎልጋወን ኡቱባ ኩዸኒፊ ሚለ ኩዸን ቀበ ቱሬ፤ ሆኮወኒፊ ሶማወን ኡቱቦተ ሰናስ ሜቲራ ሆጄተመን። ");
INSERT INTO gaze_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","ፊጤ በኣቲን፣ ከራ በአ ቢፍቱቲን ዹንዹመ ሸንተመ በልአተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","ጎልጋወን ዹንዹመ ኩዸ ሸን ዼዼረተኒ ኡቱባ ሰዲፊ ሚለ ሰዲ ቀበንስ ከራ በልበለ ቶኮረ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","ጎልጋወን ዹንዹመ ኩዸ ሸን ዼዼረተኒ ኡቱባ ሰዲፊ ሚለ ሰዲ ቀበንስ በልበለ ኦብዲ ሰነረ ገመ ካኒን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","ጎልጋወን ናኖ ኦብዲ ሰና ሁንድ ቁንጬ ተልባ ከን ቀልዽፈሜ ፎአሜራ ቶልፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","ሚለወን ኡቱቦተ ሰና ናሲራ ቶልፈመን። ሆኮወኒፊ ሶማወን ኡቱቦታሞ ሜቲራ ቶልፈመኒ ፊጤ ኡቱቦተ ሰናት ሜቲ ኡፍሰን። ኡቱቦን ኦብዲ ሰና ሁንድኑስ ሶማወን ሜቲ ቀቡ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","ጎልጋን በልበለ ኦብዲ ሰና ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ዸአሜረት ፋዬፈሜ ሆጄተሜ ቶልፈሜ። እንስ ዹንዹመ ድግደመ ደልገ ዼረቴ አኩመ ኦብድቻ ዹንዹመ ሸን ኦል ዼረተ ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","ኡቱባ አፉሪፊ ሚለ ናሲ አፉርስ ቀበ ቱሬ። ሆኮወኒፊ ሶማወንሳኒ ሜቲራ ቶልፈመኒ ፊጤሳኒት ሜቲን ኡፍፈሜ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","ቆፎን ዱንካነ ቁልቁሉቲፊ ቆፎን ናኖ ኦብዲ ሰና ሁንድ ናሲራ ቶልፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","ባይእን ምአ ዱንካን ቁልቁሉን ጄቹንስ ዱንካን ዹገ በኡምሳ እቲን ሆጄተሜ ከን ሌዎትን አጀጀ ሙሴቲን ቀጄልፈመ ኢታማር እልመ አሮን ሉብቻቲን ገልሜሰን ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","ቤዘልኤል እልም ኡር ጄቹንስ እልም እልመ ሁር ነምች ጎሰ ይሁዳ ሱን ዋን ዋቀዮ ሙሴ አጀጄ ሁንደ ሆጄቴ። ");
INSERT INTO gaze_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","ኦሆሊያብ እልም አሂሳማክ ነምች ጎሰ ዳን ሱንስ እሰ ወጅን ቱሬ፤ እንስ ኦጌሰ ሆጂ ሀርካ፣ ኦጌሰ ብፈ ባሱፊ ከን ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ዋ ፋዬሱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","ባይእን ወርቄ ኣርሳ ሶቾፈሙ ከን ሆጂ እዶ ቁልቁሉ ሰና ሁንደረ ኦሌ ወሉማ ገለት አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ታላንቲ 29ፊ ሰቅሊ 730 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","ሜቲን ነሞተ ወልዳ ኬሳ ለካአመንራ አርገሜስ አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ታላንቲ 100ፊ ሰቅሊ 1,775 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","ነሞትን ወረ ዱራን ለካአመኒ ጅረንት ደበለመን ከኔን ኡሙሪንሳኒ ወጋ ድግደመ ዮካን ሀመና ኦል ተኤ 603,550 ቱረን። እሳን ኩኔንስ አከ መዳሊ እዶ ቁልቁሉት መቱመ መታን ቤካ ቶኮ ቶኮ ጄቹን ወለካ ሰቅሊ ቶኮ ቶኮ ባሰን። ");
INSERT INTO gaze_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","ሜቲ ታላንቲ 100 ሰናን ሚለወን እዶ ቁልቁሉቲፊ ሚለወን ጎልጋቱ ሆጄተሜ፤ ታላንቲ 100ፊ ሚለ 100 ሆጄተሜ፤ ሚለ ቶኮፍ ታላንቲ ቶኮቱ በርባችሴ ጄቹዸ። ");
INSERT INTO gaze_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","እሳንስ ሰቅሊ 1,775 ሰነ ሆኮ ኡቱባወኒ ቶልቹፍ፣ ፊጤ ኡቱባወኒት ኡፍሱፊ ሶማወንሳኒ ቶልቹፍ እት ፈየደመን። ");
INSERT INTO gaze_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","ናሲን ኣርሳ ሶቾፈሙስ ታላንቲ 70ፊ ሰቅሊ 2,400 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","እሰስ ሚለ በልበለ ዱንካነ ወል ገኢ፣ እዶ ኣርሳ ከን ናሲራ ሆጄተሜ፣ ግንግልቻሳ ከን ናሲራ ሆጄተሜፊ ምአሳ ሁንደ ቶልቹፍ እት ፈየደመን፤ ");
INSERT INTO gaze_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","አከሱመስ ሚል ናኖ ኦብዲ፣ ሚል በልበለ ኦብዲ፣ ቆፎወን ዱንካነ ቁልቁሉ ሁንዲፊ ቆፎወን ናኖ ኦብዲ ሁንድ ናሲራ ሆጄተመን። ");
INSERT INTO gaze_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","እሳንስ ኡፈተ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌፊ ብልዲማን ዸአሜ ከን እዶ ቁልቁሉ ኬሰ ተጃጅሉፍ ፈየዱ ሆጄተን። አኩመ ዋቀዮ ሙሴ አጀጄትስ ኡፈተ ቁልቁሉ አሮኒፍ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","እሳንስ ወርቄፊ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ድረተ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","እሳንስ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ቀልኣሳ ቶልቹፍ ጄዸኒ ወርቄ ሰነ ኦጉማ ሀርካቲን ቱመኒ አከ ባላት ሀጵሰኒ ፎኣ ፎኣት ገርገር ኩኩተን። ");
INSERT INTO gaze_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","እሳንስ አከ እን ወልት ጉዱንፈሙ ደንደኡፍ ፉኞ ገቲቲ ከን ጎሌሳ ለማንት ህዸሜ ቱሬ ድረተ ሰናፍ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","ሰበንሳ ከን ኦጉማዻን ዸአሜስ አኩመሳ ድረተ ወጅን ቶኮ ተኤ ወርቄዻን፣ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን አኩመ ዋቀዮ ሙሴ አጀጄት ሆጄተሜ። ");
INSERT INTO gaze_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","እሳንስ ዸጋወን ሰርዶንክሲ ቆጴሰኒ መርሳ ፋየ ወርቄ ናኖሳት ቶልቸን፤ መቃ እልማን እስራኤልስ አከ ቻፓት እሳንረት ሶፈን። ");
INSERT INTO gaze_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","ኤርገሲስ አከ እልማን እስራኤሊፍ ዸጋ ያደኖ ተኡፍ አኩመ ዋቀዮ ሙሴ አጀጄት ዸጋወን ሰነ ፉኞ ገቲቲ ድረተ ሰነት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","እሳንስ አኩመ ድረተ ሰናት ወርቄዻን፣ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ኦጉማዻን ኪሲ ቆማ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","ኪሲን ቆማ ኩን ገመ አፍረኒኑ ወል ቅጤ ቱሬ፤ እንስ ወልት ደቻ ተኤ ዼርነ ታኩ ቶኮፊ በልእነ ታኩ ቶኮ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","ዸጋወን ገት ጀቤዪስ ቶረ አፉሪንረት መጠንሰን። ቶረ ጀልቀባረት ሰርድዮን፣ ቶጳዝዮኒፊ ቢረሌ፣ ");
INSERT INTO gaze_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","ቶረ ለመፋረት በሉር፣ ሰንፔሪፊ አልማዝ፣ ");
INSERT INTO gaze_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","ቶረ ሰደፋረት ያክንት፣ ኬልቄዶኒፊ ያክንት፣ ");
INSERT INTO gaze_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","ቶረ አፉረፋረት ቢረሌ፣ ሰርዶንክሲፊ ያስጲድ መጠንሰን። ዸጋወን ከኔንትስ መርሳ ፋየ ወርቄ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","ዸጋወን ኩዸ ለመ ከኔን ቶኮ ቶኮሳኒረት መቃ ጎሶተ ኩዸ ለመ ኬሳ መቃን ቶኮ አኩመ ቻፓት ሶፈሜ ቱረን፤ ቶኮን ቶኮን ዸጋወን ሰናስ መቃ እልማን እስራኤል ቶኮ ቶኮፍ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","ኪሲ ቆማቲፍስ ፎንጫ ወርቄ ቁልቁሉ አከ ፉኞት ፎአኒ ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","እሳንስ መርሳ ፋየ ወርቄ ለማፊ ቁቤላ ወርቄ ለመ ቶልቸኒ ቁቤላወን ሰነ ሮገወን ኪሲ ቆማ ኬሳ ለመት ጉዱንፈን። ");
INSERT INTO gaze_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","ፎንጫ ወርቄ ሰነ ለማንስ ቁቤላወን ሮገወን ኪሲ ቆማ ሰነት ጉዱንፈን። ");
INSERT INTO gaze_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","መታ ለማን ፎንጫ ለማን ሰና ካንሞ መርሳወን ፋያ ለማንት ጉዱንፈኒ ከራ ፉለ ዱራቲን ፎንጫ ድረታ ከን ገቲቲት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","ቁቤላወን ወርቄ ለመ ቶልቸኒ ሮገወን ኪሲ ቆማ ብራ ከኔን ከራ ሞጋ ኬሳቲን ድረተት ኣነኒ ጅረን ለማንት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","ኤርገሲስ ቁቤላወን ወርቄ ለመ ብራ ቶልቸኒ ሰበተ ሙዺቲ ኦልት ገርጀሌ ፉኞ ገቲቲ ለማን፣ ፉለ ድረታ ዱራን ጅሩ ሰናት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","እሳንስ አከ ኪሲን ቆማ ድረተራ ህንሶሶቾኔፍ ቁቤላወን ኪሲ ቆማ ሰነ ሰበተ ሙዺቲን ወልት ቀብሲሰኒ አኩመ ዋቀዮ ሙሴ አጀጄት ፉኞ ብፈ ጩቁሊሳቲን ቁቤላወን ድረተት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","እሳንስ ሁጩ ጉቱማን ጉቱት ብፍትሳ ጩቁሊሰ ተኤራ ወንደቦ ድረታ ቶልቸን፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","ወለካ ጉባ ወንደቦ ሰናትስ አፋን እቲን መታ ሴንስፈተን ቶልቸን፤ አከ እን ህንተርሳኔፍስ ቀርቀረ አፋንሳረ ዋ ናኔሰኒ ሆዸን። ");
INSERT INTO gaze_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","እሳንስ ጥዮ ወንደቦ ሰናት ክሪ ብፈ ጩቁሊሳ፣ ዺልጌ፣ ብልዲማፊ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ሮማኒ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","ወርቄ ቁልቁሉራስ ብልብለ ሆጄተኒ ሮማኖተ ግዱዻን ናኖ ጥዮ ወንደቦት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","ብልብሊፊ ሮማኒን ሱን አኩመ ዋቀዮ ሙሴ አጀጄት ቶኮ ቶኮን ወል ኬሰ መከመኒ ናኖ ጥዮ ወንደቦ ተጃጅላፍ ኡፈተሙ ሰናት ቀብሲፈመን። ");
INSERT INTO gaze_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","አሮኒፊ እልማንሳቲፍሞ ክታ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜን ዾፍስሰኒ ሆጄተን፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","አከሱመስ ቁንጬ ተልባ ቀልኣሳቲን መረተ መታ፣ ቁንጬ ተልባቲን ጎንፎ፣ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜንሞ ኡፈተ ወያ ጀላ ሆጄተኒፍ። ");
INSERT INTO gaze_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","ሰበንስ ቁንጬ ተልባ ከን ቀልእፈሜ ፎአሜፊ ክሪ ብፈ ጩቁሊሳ፣ ዺልጌፊ ብልዲማን ፋዬፈሜ አኩመ ዋቀዮ ሙሴ አጀጄት ሆጄተሜ። ");
INSERT INTO gaze_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","እሳንስ ወርቄ ቁልቁሉራ ፋየ ጎንፎ ቁልቁሉ ቶልቸኒ አኩመ ዋን ቻፓረት ቅርጠሙት፦ ከን ዋቀዮፍ ቁልቁሌፈሜ፣ ጄዸኒረት በሬሰን። ");
INSERT INTO gaze_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","ኤርገሲስ ፋየ ሰነ መረተ መታቲን ወል ቀብሲሱፍ ጄዸኒ አኩመ ዋቀዮ ሙሴ አጀጄት ፉኞ ብፈ ጩቁሊሳ እት ህዸን። ");
INSERT INTO gaze_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","አከሲን ሆጂን ዱንካነ ቁልቁሉ ከን ዱንካነ ወል ገኢ ሁንድ ጡሙረሜ። እስራኤሎንስ አኩመ ዋቀዮ ሙሴ አጀጄት ዋን ሁንደ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","እሳንስ ዱንካነ ቁልቁሉ ሰነ ሙሴት ፍደን፦ ዱንካናፊ ምአሳ ሁንደ፣ ሆኮወንሳ፣ ቱጌወንሳ፣ ደገሌወንሳ፣ ኡቱቦተሳቲፊ ሚለወንሳ፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","እረ ቡሰ ከልኤ ኮርቤሰ ሆላ ከን ሀሉ ዲማ ጩጰሜ፣ እረ ቡሰ ጎጋ ዱገሜቲፊ ጎልጋ ደኤሱ፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","ታቦተ ከኩ ሴራ፣ ደንቀራሳቲፊ ቴሶ አራራ ወጅን፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","ምንጃለ ምአሳ ሁንዳፊ ቡዴነ እላልቻ ወጅን፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","ባቱ እብሳ ከን ወርቄ ቁልቁሉራ ሆጄተሜ፣ እብሳወን ተሬ ገለኒፊ ምአሳ ሁንደ ወጅን፣ ዘይቲ እብሳ፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","እዶ ኣርሳ ከን ወርቄራ ሆጄተሜ፣ ዘይቲ እቲን ድበን፣ እጣነ ኡርጋኡ፣ ጎልጋ በልበለ ዱንካና፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","እዶ ኣርሳ ከን ናሲራ ሆጄተሜ፣ ግንግልቻሳ ከን ናሲራ ሆጄተሜ ወጅን፣ ደንቀራወንሳቲፊ ምአሳ ሁንደ፣ ጫቢ ሚለሳ ወጅን፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","ጎልጋወን ኦብዲ ኡቱባወኒፊ ሚለወንሳኒ ወጅን፣ ጎልጋ ከረ ኦብዲ ሰና፣ ፉኞወኒፊ ቆፎወን ኦብዲ፣ ምአ ዱንካነ ቁልቁሉ ከን ዱንካነ ወል ገኢ ሁንደ፤ ");
INSERT INTO gaze_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","ወያወን ፎአመኒ ዸአመን ከኔን ዬሮ እዶ ቁልቁሉ ኬሰ ተጃጅለን ኡፈተመን፣ ጄቹንስ ወያወን አሮን ሉብቻፍ ቁልቁሌፈመኒፊ ወያወን እልማንሳ ዬሮ ሉቡማዻን ተጃጅለንት ኡፈተን ፌአ። ");
INSERT INTO gaze_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","እስራኤሎንስ አኩመ ዋቀዮ ሙሴ አጀጄት ሆጂ ሁንደ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","ሙሴንስ ሆጂ ሰነ ቶአቴ አኩመ ዋቀዮ አጀጄት ሆጄቹሳኒ አርጌ። ሙሴንስ እሳን ኤብሴ። ");
INSERT INTO gaze_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“ጉያ ጀልቀበ ጅአ ጀልቀባት ዱንካነ ቁልቁሉ ጄቹንስ ዱንካነ ወል ገኢ ዻብ። ");
INSERT INTO gaze_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","ታቦተ ከኩ ሴራ እሰ ኬሰ ካኢቲ ታቦትቸ ጎልጋዻን ደኤስ። ");
INSERT INTO gaze_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","ምንጃለ ኦል ገልቺቲ ምአሳ ቶቶልች። ኤርገሲስ ባቱ እብሳ ኦል ገልቺቲ እብሳሳረ ዻብ። ");
INSERT INTO gaze_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","እዶ ኣርሳ እጣና ከን ወርቄራ ሆጄተሜ ፉለ ታቦተ ከኩ ሴራ ዱረ ዻቢቲ በልበለ ዱንካነ ቁልቁሉትሞ ጎልጋ ፈንስ። ");
INSERT INTO gaze_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“እዶ ኣርሳ ቀልመ ጉበሙ ሰነስ ፉለ በልበለ ዱንካነ ቁልቁሉ ጄቹንስ ዱንካነ ወል ገኢ ዱረ ዻብ፤ ");
INSERT INTO gaze_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","ገበቴ እት ዽቀተንስ ዱንካነ ወል ገኢቲፊ እዶ ኣርሳ ግዱ ዻቢቲ ብሻን እት ነቅ። ");
INSERT INTO gaze_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","ናኖ እሳትስ ኦብዲ ሆጄዹቲ በልበለሳት ጎልጋ ካእ። ");
INSERT INTO gaze_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“ዘይቲ እቲን ድበን ፉዺቲ ዱንካነ ቁልቁሉፊ ዋን እሰ ኬሰ ጅሩ ሁንደ ድብ፤ ዱንካንቻፊ ምአሳ ሁንደ ቁልቁሌስ፤ እንስ ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","ኤርገሲስ እዶ ኣርሳ ቀልመ ጉበሙቲፊ ምአሳ ሁንደ ድብ፤ እዶ ኣርሳ ሰነ ቁልቁሌስ፤ እንስ ዋን ሁንደ ጫላ ቁልቁላኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","ገበቴ እት ዽቀተኒፊ ሚለሳ ድቢቲ እሳን ቁልቁሌስ። ");
INSERT INTO gaze_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“አሮኒፊ እልማንሳ ገረ በልበለ ዱንካነ ወል ገኢት ፍዲቲ ብሻኒን እሳን ዽቅ። ");
INSERT INTO gaze_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","ኤርገሲ አሮንት ወያ ቁልቁሉ ኡፍስ፤ አከ እን ሉቡማዻን ነ ተጃጅሉፍስ ድቢቲ እሰ ቁልቁሌስ። ");
INSERT INTO gaze_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","እልማንሳስ ፍዲቲ ክታ እት ኡፍስ። ");
INSERT INTO gaze_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","አከ እሳን ሉቡማዻን ነ ተጃጅለኒፍስ አኩመ አባሳኒ ድብዴ ሰነት እሳን ድብ፤ ድበሙንሳኒ ኩንስ ዸሎተ ዹፉ ሁንደ ኬሰት ሉቡማ እት ፉፉ ተአ።” ");
INSERT INTO gaze_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","ሙሴንስ አኩመ ዋቀዮ እሰ አጀጄት ዋን ሁንደ ሆጄቴ። ");
INSERT INTO gaze_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","ከናፉ ዱንካን ቁልቁሉን ሱን ወጋ ለመፋ ኬሰ ጉያ ጀልቀባ ከን ጅአ ጀልቀባት ዻበሜ። ");
INSERT INTO gaze_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","ሙሴን ዬሮ ዱንካነ ቁልቁሉ ሰነ ዻቤት ሚለወን ዱንካንቻ እት ካኤ፤ ቱጌወንሳ ዸዻቤ፤ ደገሌወንሳ ሎሴ፤ ኡቱቦተሳ ዸዻቤ። ");
INSERT INTO gaze_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","እንስ አኩመ ዋቀዮ እሰ አጀጄት ዱንካነ ቁልቁሉ እራን ዱንካነ ድሪርሴ ዱንካነ ሰነትሞ እረ ቡሰ ኡፍሴ። ");
INSERT INTO gaze_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","ዹገ በኡምሰ ሰነ ፉዼ ታቦተ ኬሰ ካኤ፤ ደንቀራወንስ ታቦተት ህዼ፤ ቴሶ አራራሞ ታቦተ ጉባ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","ሙሴን አኩመ ዋቀዮ እሰ አጀጄት ታቦተ ሰነ ዱንካነ ቁልቁሉት ኦል ገልቼ ጎልጋ ደኤሱ ፈንሴፍ፤ ታቦተ ከኩ ሴራ ሰነስ ደኤሴ። ");
INSERT INTO gaze_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","ሙሴንስ ምንጃለ ሰነ ገመ ካበ ዱንካነ ቁልቁሉቲን ዱንካነ ወል ገኢ ኬሰ ጎልጋ ሰናን አለ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","አኩመ ዋቀዮ እሰ አጀጄትስ ፉለ ዋቀዮ ዱረት ቡዴነ አችረ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","ባቱ እብሳሞ ገመ ክባ ዱንካነ ቁልቁሉቲን ዱንካነ ወል ገኢ ኬሰ ፉሌ ምንጃላቲን ካኤ። ");
INSERT INTO gaze_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","አኩመ ዋቀዮ እሰ አጀጄትስ እብሳወን ሰነ ፉለ ዋቀዮ ዱረ ዸዻቤ። ");
INSERT INTO gaze_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","ሙሴንስ እዶ ኣርሳ ከን ወርቄራ ሆጄተሜ ሰነ ፉለ ጎልጋ ዱራን ዱንካነ ወል ገኢ ኬሰ ዻቤ። ");
INSERT INTO gaze_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","አኩመ ዋቀዮ እሰ አጀጄትስ እጣነ ኡርጋኣ እሰረት ኣርሴ። ");
INSERT INTO gaze_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","በልበለ ዱንካነ ቁልቁሉረትስ ጎልጋ ፈንሴ። ");
INSERT INTO gaze_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","እን አኩመ ዋቀዮ እሰ አጀጄት እዶ ኣርሳ ቀልመ ጉበሙ ሰነ በልበለ ዱንካነ ቁልቁሉ ከን ዱንካነ ወል ገኢ ብረ ዻቤ ቀልመ ጉበሙፊ ኬና ምዻኒ እሰረት ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","ገበቴ ሰነስ ዱንካነ ወል ገኢቲፊ እዶ ኣርሳ ግዱ ካኤ ብሻን ዽቀታ እት ነቄ፤ ");
INSERT INTO gaze_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","ሙሴን፣ አሮኒፊ እልማን አሮኒስ ሀርከሳኒቲፊ ሚለሳኒ ዽቀቹፍ እት ፈየደሙ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","እሳንስ አኩመ ዋቀዮ ሙሴ አጀጄት ዬሮ ዱንካነ ወል ገኢ ሴነን ዮካን ዬሮ እዶ ኣርሳት ዽኣተን ሁንደ ንዽቀቱ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","ሙሴንስ ናኖ ዱንካነ ቁልቁሉቲፊ እዶ ኣርሳት ኦብዲ ሆጄቴ በልበለ ወልተጅቻረ ጎልጋ ዻቤ፤ አከሲን ሙሴን ሆጂ ሰነ ሆጄቴ ፍጤ። ");
INSERT INTO gaze_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","ኤርገሲስ ዱሜስ ዱንካነ ወል ገኢ ሀጉጌ፤ ኡልፍን ዋቀዮስ ዱንካነ ቁልቁሉ ሰነ ጉቴ። ");
INSERT INTO gaze_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","ሙሴንስ ሰበቢ ዱሜስ ሱን ዱንካነ ወል ገኢረ ቡኤፊ ሰበቢ ኡልፍን ዋቀዮ ዱንካነ ቁልቁሉ ጉቴፍ ዱንካነ ወል ገኢ ሴኑ ህንደንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","እስራኤሎን ከራሳኒ ሁንደ ኬሰት ዮሙ ዱሜስ ዱንካነ ቁልቁሉራ ከኡ ሁንደ ከአኒ ዴምሰሳኒ እት ፉፉ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","ዮ ዱሜስ እራ ከኡ ባቴ ገሩ ሀመ ጋፈ ዱሜስ ሱንራ ከኡት ህንዴመን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","ከናፉ ከራሳኒ ሁንደ ኬሰት ፉለ ሰበ እስራኤል ሁንዳ ዱረት ጉያ ጉያ ዱሜስ ዋቀዮ ዱንካነ ቁልቁሉረ ቱሬ፤ ሀልከን ሀልከንሞ እብድ ዱሜሰ ሰነ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","ዋቀዮ ሙሴ ዋሜ ዱንካነ ወል ገኢ ኬሳ አከነ ጄዼ እት ዱበቴ፤ ");
INSERT INTO gaze_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“እስራኤሎተት ዱበዹ፤ አከነስ ጄዺን፦ ‘እስን ኬሳ ነምን ከምዩ ዮሙ ሆሪ ኬሳ ዋቀዮፍ ኬና ዽኤሱት ከረ ሎኒ ዮካን ቡሻዬ ኬሳ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘ዮ ኬናን ሱን ቀልመ ጉበሙ ከን ከረ ሎኒ ተኤ፣ ነምች ሱን ኮርመ ህርእነ ህንቀብኔ ሃዽኤሱ። አከ ኣርሳን ሱን ፉለ ዋቀዮ ዱረት ፉዸተመ አርገቱፍስ በልበለ ዱንካነ ወል ገኢ ዱረት ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","ነምችስ መታ ሆሪ ኣርሳ ጉበሙፍ ዽኤፈሙ ሰናረ ሀርከሳ ሃካኡ፤ ኩንስ አራረ እሳፍ ቡሱፍ ቆደሳ ፉዸተመ አርገተ። ");
INSERT INTO gaze_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","እንስ ፉለ ዋቀዮ ዱረት ኮርመ ሃቀሉ፤ እልማን አሮን ሉቦትን ዺገ ሰነ ፉዸኒ እዶ ኣርሳ ከን በልበለ ዱንካነ ወል ገኢ ዱረ ጅሩት ገመ ሁንዳን ሃፈጫሰን። ");
INSERT INTO gaze_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","እንስ ኣርሳ ጉበሙ ሰነራ ጎጋ ባሴ ኩታ ኩታት ሙርሙረ። ");
INSERT INTO gaze_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","እልማን አሮን ሉብቻሞ እዶ ኣርሳረት እብደ ቀብሲሰኒ ቆራን እረ ሃነቀን። ");
INSERT INTO gaze_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","ኤርገሲስ እልማን አሮን ሉቦትን ኩታ ሙርሙረሜ፣ መታፊ ጮመሳስ ቆራን እዶ ኣርሳረት ቦበኡረ ተሬ ሃነቀን። ");
INSERT INTO gaze_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","እንስ ምአ ገራቲፊ ሚለ ቀልመ ሰና ብሻኒን ሃዽቁ፤ ሉብችስ ሁንደሳ እዶ ኣርሳረት ሃጉቡ። ኩንስ ኣርሳ ጉበሙ ከን እብዳን ዽኣቱፊ ከን ኡርጋንሳ ዋቀዮት ቶሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘ዮ ኣርሳን ሱን ቀልመ ጉበሙ ከን ቡሻዬ ጄቹንስ ሆላ ዮካን ሬኤ ተኤ ነምች ዽኤሱ ሱን ኮርመ ህርእነ ህንቀብኔ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","እንስ ገመ ካበ እዶ ኣርሳቲን ፉለ ዋቀዮ ዱረት ሃቀሉ፤ እልማን አሮን ሉቦትንሞ ገመ ሁንዳን ዺገሳ እዶ ኣርሳት ሃፈጫሰን። ");
INSERT INTO gaze_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","ነምች ሱንስ ኩታ ኩታት ሃሙርሙሩ፤ ሉብችሞ መታፊ ጮመሳ ቆራን እዶ ኣርሳረት ቦበኣ ጅሩረ ተሬ ሃነቁ። ");
INSERT INTO gaze_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","እንስ ምአ ገራቲፊ ሚለ ቀልመ ሰና ብሻኒን ሃዽቁ፤ ሉብችሞ ሁንደሳ ፍዴ እዶ ኣርሳረት ሃጉቡ። ኩንስ ኣርሳ ጉበሙ ከን እብዳን ዽኣቱፊ ከን ኡርጋንሳ ዋቀዮት ቶሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘ዮ ኣርሳን ዋቀዮፍ ዽኣቱ ሱን ቀልመ ጉበሙ ከን ስምብሮታ ተኤ ነምች ሱን ጉጌ ዮካን ጉጌ ሶኬ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","ሉብች ሱን ገረ እዶ ኣርሳት ሃፍዱ፤ መታሳስ ምጪሬራ ሃኩቱ፤ ኤርገሲሞ እዶ ኣርሳረት ሃጉቡ፤ ዺግንሳሞ እዶ ኣርሳ ጭነት ሃጮጮቡ። ");
INSERT INTO gaze_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","ምአ ገራሳ ባሌሳ ወጅን ባሴ ከራ በአ ቢፍቱቲን እዶ ኣርሳ ጭነት ለፈ ዳራን ጅሩት ሃገቱ። ");
INSERT INTO gaze_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","ከራ ቆቾ እሳቲን ሃበቀቅሱ፤ ገሩ ጉቱማን ጉቱት ገርገር ህንባስን፤ ኤርገሲ ሉብች እዶ ኣርሳረት ቆራን ቦበኣ ጅሩረት ሃጉቡ። ኩንስ ኣርሳ ጉበሙ ከን እብዳን ዽኣቱፊ ከን ኡርጋንሳ ዋቀዮት ቶሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘ነምን ቶኮ ዮሙ ኬና ምዻኒ ዋቀዮፍ ዽኤሱት፣ ኬናንሳ ዳኩ ቡላኣ ሃተኡ። እንስ ዘይቲ እት ሃነቁ፤ እጣነስ እት ደበሌ፣ ");
INSERT INTO gaze_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","እልማን አሮን ሉቦተ ሰነት ሃፍዱ። ሉብችስ ዳኩ ቡላኣ ዘይቲን እት ነቀሜ ሰነራ ኮኜ ቶኮ እጣነ ሁንደ ወጅን ሃፉዹ፤ ከነስ ኩታ ያደኖ ኣርሳ ጉበሙ ከን እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ ጎዼ እዶ ኣርሳረት ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","ኬናን ምዻኒ ሀፌሞ ከን አሮኒፊ እልማንሳት፤ ኩንስ ኩታ ኣርሳወን ሁንደ ጫላ ቁልቁሉ ከን እብዳን ዋቀዮፍ ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘ዬሮ አት ኬና ምዻኒ በርበዳ እብዳረት ቶልፈሜ ዽኤስቱት፣ ኬናን ሱን ዳኩ ቡላኣ ጄቹንስ መጥኖ ዘይቲን እት መከሜ ዮካን ብጥሌ ራጭቲ መሌ ቶልፈሜ ዘይቲን እረ ድበሜ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","ኬናንኬ ኬና ምዻኒ ከን ኤሌረት ቆጴፈሜ ታናን ኬናን ሱን ዳኩ ቡላኣ ህንቡካእን ከን ዘይቲን እት መከሜራ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","እሰ ጨጨብሲቲ ጉባሳት ዘይቲ ነቅ፤ እን ኬና ምዻኒት። ");
INSERT INTO gaze_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","ኬናን ምዻንኬቲ ዮ ኤሌረት ቆጴፈሜ፣ ኬናን ሱን ዳኩ ቡላኣፊ ዘይቲራ ሃቆጴፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","ኬና ምዻኒ ከን ወንቶተ ከኔንራ ቆጴፈሜ ዋቀዮፍ ፍድ፤ ከነስ ሉበ እዶ ኣርሳት ጌሱት ኬን። ");
INSERT INTO gaze_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","እንስ ኬና ምዻኒ ሰነራ ኩታ ያደኖ ፉዼ ኬና እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ ጎዼ እዶ ኣርሳረት ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","ኬናን ምዻኒ ሀፌሞ ከን አሮኒፊ እልማንሳት፤ ኩንስ ኩታ ኣርሳወን ሁንደ ጫላ ቁልቁሉ ከን እብዳን ዋቀዮፍ ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘ኬናን ምዻኒ ከን እስን ዋቀዮፍ ዽኤስተን ሁንድኑ ኡቱ ራጭቲን እት ህንመከምን ቆጴፈሙ ቀበ፤ እስን ኬና እብዳን ዋቀዮፍ ዽኤፈሙ ቶኮ ኬሰት ራጭቲ ዮካን ደመ ቶኮሌ ጉቡ ህንቀብደኒቲ። ");
INSERT INTO gaze_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","ኬና ከነስ አከ መታ ምዻኒት ዋቀዮፍ ዽኤሱ ደንዴሱ፤ ገሩ አከ ኬና ኡርጋኣ ቶኮት እዶ ኣርሳረት ዽኣቹ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","ኬና ምዻንኬቲ ሁንደ ሶግዳን ምኤስ፤ ሶግደ ከኩ ዋቀኬቲ ኬና ምዻንኬቲ ኬሳ ህንሀምብስን፤ ኬናኬ ሁንደት ሶግደ ደበል። ");
INSERT INTO gaze_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘አት ዮ መታ ምዻኒ ኬሳ ኬና ምዻኒ ዋቀዮፍ ፍዴ፣ መታ ምዻን አሼቴ እብዳን ዋደሜ ሱኩመሜ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","ዘይቲ እት ነቂቲ እጣነስ እት ደበል፤ ኩን ኬና ምዻኒት። ");
INSERT INTO gaze_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","ሉብን ሱንስ ኩታ ያደኖ ምዻን ሱኩመሜ ሰናቲፊ ዘይቲ ሰነ እጣነ ሁንደ ወጅን ኬና እብዳን ዋቀዮፍ ዽኤፈሙ ጎዼ ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘ኬናን ነመ ቶኮ ዮ ኣርሳ ነጋ ተኤ፣ ነምች ሱንስ ከረ ሎኒ ኬሳ ሆሪ ቶኮ፣ ኮርመ ዮካን ዸላ ዮ ዽኤሴ፣ እን ሆሪ ህርእነ ህንቀብኔ ፉለ ዋቀዮ ዱረት ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","ነምች ሱን መታ ኬናሳረ ሀርከሳ ሃካኡ፤ በልበለ ዱንካነ ወል ገኢ ዱረትስ ሃቀሉ። ኤርገሲሞ እልማን አሮን ሉቦትን ሱን ዺገ ሆሪ ሰነ እዶ ኣርሳ ሰነት ገመ ሁንዳን ሃፈጫሰን። ");
INSERT INTO gaze_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","እንስ ኣርሳ ነጋራ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ሃፍዱ፤ ኩንስ ሞረ ምአ ገራ ሀጉጉፊ ከን እት መጠኑ ሁንደ፣ ");
INSERT INTO gaze_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","ከሌ ለማኒፊ ሞረ እሳንረ ጅሩ ከን ሙዺት ዽኣቱ፣ ሀጉጊ ትሩ ከን ነምች ከሌዻን ወልት ቀቤ ባሱ ፈአ። ");
INSERT INTO gaze_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","ኤርገሲስ እልማን አሮን ዋን ከነ ኣርሳ እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ ጎዸኒ እዶ ኣርሳረት ኣርሳ ጉበሙ ከን ቆራን ቦበኡረ ጅሩረት ሃጉበን። ");
INSERT INTO gaze_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘እን ዮ ቡሻዬ ኬሳ ሆሪ ቶኮ አከ ኣርሳ ነጋት ዋቀዮፍ ዽኤሴ፣ ኮርመ ዮካን ዸላ ህርእነ ህንቀብኔ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","እን ዮ ጦባላ ሆላ ዽኤሴ፣ ፉለ ዋቀዮ ዱረት ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","ነምች ሱንስ መታ ኬናሳረ ሀርከሳ ካኤ በልበለ ዱንካነ ወል ገኢ ዱረት ሃቀሉ። ኤርገሲሞ እልማን አሮን ዺገ ሆሪ ሰና እዶ ኣርሳረት ገመ ሁንዳን ሃፈጫሰን። ");
INSERT INTO gaze_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","እንስ ኣርሳ ነጋ ሰነራ ቀልመ እብዳን ዋቀዮፍ ዽኤፈሙ ሃፍዱ፤ ኩንስ ጮመሳ፣ ዱቦሳ ከን ለፌ ዱግዳት ዽኤፈሜ ኩተሜ ሁንደ፣ ሞረ ምአ ገራ ሀጉጉፊ ከን እት መጠኑ ሁንደ፣ ");
INSERT INTO gaze_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","ከሌ ለማኒፊ ሞረ እሳንረ ጅሩ ከን ሙዺት ዽኣቱ፣ ሀጉጊ ትሩ ከን ነምች ከሌዻን ወልት ቀቤ ባሱ ፈእ። ");
INSERT INTO gaze_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","ሉብን ሱንስ ዋን ከነ ኛተ ጎዼ እዶ ኣርሳረት ሃጉቡ፤ ኛትን ኩንስ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘ዮ ኬናንሳ ሬኤ ተኤ፣ እን ፉለ ዋቀዮ ዱረት ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","ነምች ሱን መታ ሬኤ ሰናረ ሀርከሳ ካኤ ፉለ ዱንካነ ወል ገኢ ዱረት ሃቀሉ። ኤርገሲሞ እልማን አሮን ዺገ ሆሪ ሰና እዶ ኣርሳረት ገመ ሁንዳን ሃፈጫሰን። ");
INSERT INTO gaze_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","እንስ ዋን ዽኤሱ ኬሳ ኬና ከነ ኬና እብዳን ዋቀዮፍ ዽኤፈሙ ጎዼ ሃዽኤሱ፤ ኩንስ ሞረ ምአ ገራ ሀጉጉፊ ከን እት መጠኑ ሁንደ፣ ");
INSERT INTO gaze_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","ከሌ ለማኒፊ ሞረ እሳንረ ጅሩ ከን ሙዺት ዽኣቱ፣ ሀጉጊ ትሩ ከን ነምች ከሌዻን ወልት ቀቤ ባሱ ፈእ። ");
INSERT INTO gaze_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","ሉብን ሱንስ ዋን ከነ ኛተ ጎዼ እዶ ኣርሳረት ሃጉቡ፤ ኩንስ ኣርሳ ኡርጋኣ እብዳን ዽኤፈሙዸ። ጮምን ሁንድኑ ከን ዋቀዮት። ");
INSERT INTO gaze_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘እስን ጮመ ቶኮሌ ዮካን ዺገ ቶኮሌ ህንሶረትና፤ ወን ኩን ለፈ እስን ጅራተን ሁንደት ዸሎተ ዹፉፍ ጅሩ ኬሰት ሴረ ህንጌደረምኔዸ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","ዋቀዮ አከነ ጄዼ ሙሴት ዱበቴ፤ ");
INSERT INTO gaze_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“እስራኤሎታን አከነ ጄዽ፤ ‘ዮ ነምን ኡቱ ህንቤክን ዋን ዋቀዮ ዾዌ ጨብሱዻን ጩቡ ሆጄቴ። ");
INSERT INTO gaze_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘ሉብች ድበሜ ዮ ጩቡ ሆጄቴ አከሲን ሰበት ጩቡ ፍዴ፣ እን ጩቡ ሆጄቴ ሰናፍ ድብቸ ህርእነ ህንቀብኔ ቶኮ ኣርሳ ጩቡ ጎዼ ዋቀዮፍ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","እንስ ድብቸ ሰነ በልበለ ዱንካነ ወል ገኢረት ፉለ ዋቀዮ ዱረት ሃዽኤሱ። መታ ድብቸ ሰናረስ ሀርከሳ ካኤ ፉለ ዋቀዮ ዱረት ሃቀሉ። ");
INSERT INTO gaze_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","ሉብን ድበሜ ሱን ዺገ ድብቸ ሰናራ ፉዼ ዱንካነ ወል ገኢት ቀበቴ ሃሴኑ። ");
INSERT INTO gaze_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","ሉብን ሱንስ ቁበሳ ዺገ ኬሰ ጩጴ ዺገ ሰነራ ጎልጋ እዶ ቁልቁሉ ዱረት ዬሮ ቶርበ ፉለ ዋቀዮ ዱረት ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","ኤርገሲስ ሉብን ሱን ዺገ ሰነራ ጋንፈወን እዶ ኣርሳ እጣነ ኡርጋኡ ከን ዱንካነ ወል ገኢ ኬሰ ፉለ ዋቀዮ ዱረ ጅሩ ሰነረት ሃነቁ። ዺገ ድብቸ ሰና ከን ሀፌ ሁንደሞ በልበለ ዱንካነ ወል ገኢረት ሚለ እዶ ኣርሳ ጉበሙ ጀለት ሃዸንገላሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","እንስ ድብቸ ኣርሳ ጩቡቲፍ ዽኤፈሜ ሰነራ ጮመ ሁንደ ሃባሱ፤ ኩንስ ሞረ ምአ ገራ ሀጉጉፊ ከን እት መጠኑ ሁንደ፣ ");
INSERT INTO gaze_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","ከሌ ለማኒፊ ሞረ እሳንረ ጅሩ ከን ሙዺት ዽኣቱ፣ ሀጉጊ ትሩ ከን እን ከሌዻን ወልት ቀቤ ባሱ ፈእ፤ ");
INSERT INTO gaze_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","ዋን ከነስ አኩመ ሎን ኣርሳ ነጋቲፍ ዽኤፈሙራ ሞር ባፈሙ ሰነት ሃባሱ። ሉብንስ እዶ ኣርሳ ከን ኣርሳ ጉበሙረት ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","ገሩ ጎጋ ድብቸ ሰናቲፊ ፎንሳ ሁንደ፣ መታፊ ሚለሳ፣ ምአ ገራቲፊ ጩማሳ፣ ");
INSERT INTO gaze_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","ጄቹንስ ዋን ድብቸ ሰና ከን ሀፌ ሁንደ ቁበተ ኬሳ ገድ ባሴ ገረ እዶ ሴራን ቁልቁሉ ተኤ ከን ዳራን እት ገተሙት ሃጌሱ፤ ዳራ ቱለሜረትስ እብደ ቆራኒቲን ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘ዮ ወልዳን እስራኤል ሁንድ ኡቱ ህንቤክን ጩበሜ ዋን አጀጀ ዋቀዮ ኬሰት ዾወሜ ሆጄቴ ወልዳን ሱን ዋኤ ዋን ሰና ቤኩ ባቱሌ የከ ቀቤሰ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","ዮሙ ጩቡን እሳን ሆጄተን ቤከሙት ወልዳን ሱን ድብቸ ቶኮ ኣርሳ ጩቡ ጎዼ ዱንካነ ወል ገኢ ዱረት ፍዴ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","ማንጉዶትን ወልዳ ፉለ ዋቀዮ ዱረት መታ ድብቸ ሰናረ ሀርከሳኒ ሃካአን፤ ድብች ሱንስ ፉለ ዋቀዮ ዱረት ሃቀለሙ። ");
INSERT INTO gaze_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","ሉብን ድበሜ ሱን ዺገ ድብቸ ሰናራ ፉዼ ገረ ዱንካነ ወል ገኢት ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","እንስ ቁበሳ ዺገ ኬሰ ጩጴ ጎልጋ ዱረት ዬሮ ቶርበ ፉለ ዋቀዮ ዱረት ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","ሉብን ሱንስ ዺገ ሰነራ ጋንፈወን እዶ ኣርሳ ከን ዱንካነ ወል ገኢ ኬሰ ፉለ ዋቀዮ ዱረ ጅሩ ሰነረት ሃነቁ። ዺገ ድብቸ ሰና ከን ሀፌ ሁንደሞ በልበለ ዱንካነ ወል ገኢረት ሚለ እዶ ኣርሳ ጉበሙ ጀለት ሃዸንገላሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","እን ጮመ ሁንደራ ባሴ እዶ ኣርሳረት ሃጉቡ፤ ");
INSERT INTO gaze_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","ድብቸ ከነስ አኩመ ድብቸ ኣርሳ ጩቡቲፍ ዽኤፈሜ ሰነ ጎዼ ሃጎዹ፤ ሉብንስ ሃሉመ ከናን አራረ እሳኒፍ ቡሰ፤ እሳንስ ዺፈመ አርገቱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","እንስ ኤርገሲ ድብቸ ሰነ ቁበተ ኬሳ ገድ ባሴ አኩመ ድብቸ ጀልቀባ ጉቤ ሰነ ሃጉቡ፤ ኩንስ ኣርሳ ጩቡ ወልዳት። ");
INSERT INTO gaze_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘ቡልቻን ቶኮ ዮ ኡቱ ህንቤክን ጩቡ ሆጄቴ ዋን አጀጀ ዋቀዮ ዋቀሳ ኬሰት ዾወሜ ሆጄቴ እን የከ ቀቤሰ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","እን ዮሙ ጩቡ ሆጄቴ ሰነ ቤኬት ኮርመ ሬኤ ከን ህርእነ ህንቀብኔ ቶኮ ኣርሳ ኦፊሳቲፍ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","መታ ሬኤ ሰናረ ሀርከሳ ካኤ እዶ ኣርሳን ጉበሙ እት ቀለሙት ፉለ ዋቀዮ ዱረት ሃቀሉ፤ ኩንስ ኣርሳ ጩቡት። ");
INSERT INTO gaze_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","ሉብን ሱንስ ኤርገሲ ዺገ ኣርሳ ጩቡቲፍ ዽኤፈሜራ ቁበሳቲን ፉዼ ጋንፈ እዶ ኣርሳ ከን ኣርሳን ጉበሙረት ዽኤፈሙት ሃነቁ፤ ዺገ ሀፌሞ ሚለ እዶ ኣርሳ ጀለት ሃዸንገላሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","እንስ አኩመ ጮመ ኣርሳ ነጋቲፍ ዽኤፈሜ ጉቤ ሰነ ሞረ ሁንደ እዶ ኣርሳረት ሃጉቡ፤ ሉብች ሃለ ከናን ነምቻፍ አራረ ጩቡ ቡሰ፤ እንስ ዺፈመ አርገተ። ");
INSERT INTO gaze_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘ሰበ ኬሳ ነምን ቶኮ ዮ ኡቱ ህንቤክን ዋን አጀጀ ዋቀዮ ኬሰት ዾወሜ ኬሳ ቶኮሌ ጨብሱዻን ጩቡ ሆጄቴ እን የከ ቀቤሰ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","እን ዮሙ አከ ጩቡ ሆጄቴ ቤኬት ጩቡ ሆጄቴ ሰናፍ ሬኤ ዸልቱ ህርእነ ህንቀብኔ ቶኮ ኣርሳ ኦፊ እሳቲፍ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","መታ ሬኤ ኣርሳ ጩቡቲፍ ዽኤፈምቴ ሰናረስ ሀርከሳ ካኤ እዶ ኣርሳ ጉበሙት ሃቀሉ። ");
INSERT INTO gaze_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","ሉብን ሱንስ ኤርገሲ ዺገ ሰነራ ቁበሳቲን ፉዼ ጋንፈ እዶ ኣርሳ ከን ኣርሳን ጉበሙረት ዽኤፈሙት ሃነቁ፤ ዺገ ሀፌ ሁንደሞ ሚለ እዶ ኣርሳ ጀለት ሃዸንገላሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","አኩመ ሞር እት ኣርሳ ነጋራ ባፈሙት እን ሞረ ሁንደ ሃባሱ፤ ሉብንሞ ኣርሳ ኡርጋንሳ ዋቀዮት ቶሉ ጎዼ እዶ ኣርሳረት ሃጉቡ። አከሲንስ ሉብን አራረ ቡሳፍ፤ እንስ ዺፈመ አርገተ። ");
INSERT INTO gaze_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘እን ዮ ሆላ ቶኮ ኣርሳ ጩቡ ኦፊሳቲፍ ፍዴ፣ ዸልቱ ህርእነ ህንቀብኔ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","መታ ሆላ ሰናረስ ሀርከሳ ካኤ እዶ ኣርሳን ጉበሙ እት ቀለሙት ኣርሳ ጩቡቲፍ ሃቀሉ። ");
INSERT INTO gaze_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","ሉብን ሱንስ ኤርገሲ ዺገ ኣርሳ ጩቡቲፍ ዽኤፈሜራ ቁበሳቲን ፉዼ ጋንፈ እዶ ኣርሳ ከን ኣርሳ ጉበሙት ሃነቁ፤ ዺገ ሀፌ ሁንደሞ ሚለ እዶ ኣርሳ ጀለት ሃዸንገላሱ። ");
INSERT INTO gaze_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","አኩመ ሞር እት ሆላ ኣርሳ ነጋቲፍ ዽኤፈሙራ ባፈሙት እን ሞረ ሁንደ ሃባሱ፤ ሉብንሞ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ጉባት እዶ ኣርሳረት ሃጉቡ። ሉብንስ አከሲን ጩቡ ነምች ሆጄቴፍ አራረ ቡሳፍ፤ እንስ ዺፈመ አርገተ። ");
INSERT INTO gaze_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘ነምን ቶኮ ዮ ዋን ነመ ከከቺሱ ዸገኤ ዋኤ ዋን አርጌ ዮካን ቤኩ ሰና ዹጋ በኡ ድዱዻን ጩቡ ሆጄቴ እን እት ጋፈተመ። ");
INSERT INTO gaze_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘ዮካን ነምን ቶኮ ዮ ዋን አከ ሴራት ጡራኣ ተኤ ጄቹንስ ረቀ ብኔንሰ ጡራኣ ዮካን ሆሪ ጡራኣ ዮካን ኡመመወን ጡራኦ ከኔን ለፈረ ሙኙቀኒ ኡቱ ህንቤክን ቱቄ እን ጡራኤረ፤ የከ ቀቤሰስ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","ዮካን እን ዮ ጡራኡማ ነማ ጄቹንስ ዋን እሰ ጡሬሱ ከምዩ ኡቱ ህንቤክን ቱቄ፣ ዮሙ ዋን ሰነ ቤኬት የከ ቀቤሰ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","ዮካን ነምን ዮ ኡቱ እት ህንያድን ዋን ጋሪ ዮካን ሀማ ጎቹፍ ከከቴ፣ ዋኤ ዋን ኡቱ እት ህንያድን ከከቴ ሰና ቤኩ ባቱሌ ማሉማፉ ዮሙ ዋን ሰነ ቤኬት እን የከ ቀቤሰ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","እን ዮ ከራ ከኔን ኬሳ ቶኮንዩ የከ ቀቤሰ ተኤ ከራ ከሚን አከ ሆጄቴ ሃህመቱ፤ ");
INSERT INTO gaze_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","አደበ ጩቡ ሆጄቴ ሰናቲፍስ አከ ኣርሳ ጩቡ እሳፍ ታቱፍ ቡሻዬ ኬሳ ሆላ ዮካን ሬኤ ዸልቱ ዋቀዮፍ ሃፍዱ፤ ሉብንስ ጩቡ ነምቻቲፍ ኣርሳ አራራ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘ነምች ሱን ጩቡ ሆጄቴፍ ሆላ ዽኤሱት ሀርከ ቀሌሰ ዮ ተኤ አደቢ ጩቡሳቲፍ ጉጌ ለመ ዮካን ጉጌ ሶሶኬ ለመ፣ ቶኮ ኣርሳ ጩቡቲፍ ቶኮሞ ኣርሳ ጉበሙፍ ዋቀዮፍ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","ሉበትስ እሳን ሃፍዱ፤ ሉብንሞ ከን ኣርሳ ጩቡቲፍ ታቱ ዱራን ዱርሴ ሃዽኤሱ። እንስ መታሼ ምጪሬ ሞርመሼ ሃጨብሱ፤ ገሩ እራ ህንኩትን። ");
INSERT INTO gaze_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","ዺገ ኣርሳ ጩቡ ሰነራ ፉዼ ጭናቸ እዶ ኣርሳት ሃፈጫሱ፤ ዺግን ሀፌሞ ሚለ እዶ ኣርሳ ጀለት ሃዸንገላፈሙ፤ ኩን ኣርሳ ጩቡት። ");
INSERT INTO gaze_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","ኤርገሲስ ሉብች አኩመ አጀጀሜት ከን ለመፋ ሰነ ኣርሳ ጉበሙ ጎዼ ጩቡ ነምች ሆጄቴፍ ኣርሳ አራራ ሃዽኤሱ፤ እንስ ዺፈመ አርገተ። ");
INSERT INTO gaze_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘ነምች ሱን ዮ ጉጌ ለመ ዮካን ጉጌ ሶሶኬ ለመ ዽኤሱት ሀርከ ቀሌሰ ተኤ እን ጩቡ ሆጄቴ ሰናፍ ዳኩ ቡላኣ ኢፊ ቶኮ ኬሳ ሀርከ ኩርነፋ ኣርሳ ጩቡቲፍ ሃዽኤሱ። ሰበቢ ወን ኩን ኣርሳ ጩቡ ተኤፍ ነምች ዘይቲ ዮካን እጣነ እት ህንደበልን። ");
INSERT INTO gaze_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","እንስ ሉበት ሃፍዱ፤ ሉብችሞ ኮኜ ቶኮራ ፉዼ አከ ኩታ ያደኖ ቶኮት ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሜ ጉባት እዶ ኣርሳረት ሃጉቡ፤ ኩን ኣርሳ ጩቡት። ");
INSERT INTO gaze_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","ሉብችስ ሃለ ከናን ጩቡ ነምች ሆጄቴፍ አራረ ቡሰ፤ እንስ ዺፈመ አርገተ። ኣርሳን ሀፌሞ አኩመ ኣርሳ ምዻኒት ከን ሉብቻ ተአ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“ነምን ዮ ሴረ ጨብሴ ኡቱ ህንቤክን ዋን ዋቀዮፍ ቁልቁሌፈሜ ከምዩት ጩቡ ሆጄቴ እን አደቢ ጩቡሳቲፍ ቡሻዬ ኬሳ ኮርቤሰ ሆላ ከን ህርእነ ህንቀብኔ ከን ገቲንሳ አከ ሰቅሊ እዶ ቁልቁሉት ሜቲዻን ትልማመሜ ቶኮ ኣርሳ የካ ጎዼ ዋቀዮፍ ሃፍዱ፤ ኩን ኣርሳ የካት። ");
INSERT INTO gaze_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","ነምች ሱንስ ዋን ወንቶተ ቁልቁሉራ ህርእሴ ሰነ እዶ ሃቡሱ፤ ገቲ ዋን ሰናሌ ሀርከ ሸን ኬሳ ሀርከ ቶኮ እት ደበሌ ሁንደሳ ሉበት ሃኬኑ፤ ሉብን ሱንስ ኮርቤሰ ሆላ ኣርሳ የካቲፍ ዽኤፈሜ ሰናን አራረ ቡሳፍ፤ እንስ ዺፈመ አርገተ። ");
INSERT INTO gaze_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“ነምን ዮ ጩቡ ሆጄቴ ዋን አጀጀወን ዋቀዮ ኬሰት ዾወሜ ሆጄቴ፣ እን ዮ ቤኩ ባቴሌ የከ ቀቤሰ ተኤረ፤ እት ጋፈተመስ። ");
INSERT INTO gaze_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","እንስ አከ ትልማመኬቲት ቡሻዬ ኬሳ ኮርቤሰ ሆላ ህርእነ ህንቀብኔ ቶኮ ኣርሳ የካ ጎዼ ሉበት ሃፍዱ። ሉብችስ ሃሉመ ከናን የከ ነምች ኡቱ ህንቤክን ሆጄቴፍ አራረ ቡሰ፤ እንስ ዺፈመ አርገተ። ");
INSERT INTO gaze_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","ኩን ኣርሳ የካት፤ ነምች ሱን ዋቀዮት የከ ሆጄቴረ።” ");
INSERT INTO gaze_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“ነምን ዮ ዋኤ ዋን እማና እሰት ኬነሜ ዮካን ዋን እሰ ብረ ካአሜ ዮካን ዋን ሀተሜ ቶኮ ኦላሳ ጎዎምሱዻን ዮካን ሳሙዻን ጩቡ ሆጄቴ ዋቀዮፍ አመነሙ ባቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","ዮካን ዮ ቀቤኘ በዴ አርጌ ዋኤሳ ሶበ ዱበቴ ዮካን ዮ ሶባን ከከቴ ዮካን ዮ ጩቡ አከሲ ከን ነሞትን ሆጄተን ከምዩ ሆጄቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","ዮ አከሲን ጩቡ ሆጄቴ የከ ቀቤሰ ተኤ እን ዋን ሀቴ ዮካን ዋን ሁምናን ሳሜ ዮካን ዋን እማና እሰት ኬነሜ ዮካን ዋን በዴ ከን ለፋ አርጌ ሰነ ");
INSERT INTO gaze_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","ዮካን ዋን ሶባን እት ከከቴ ሁንደ ሃዴብሱ። እን ዋን ሰነ ጉቱማት እዶ ሃቡሱ፤ ገቲ ዋን ሰናስ ሀርከ ሸን ኬሳ ሀርከ ቶኮ እት ደበሌ ሁንደሳ ጉዩመ ኣርሳ የከ ኦፊሳ ዽኤፈቱት አባ ቀቤኘ ሰናቲፍ ሃኬኑ። ");
INSERT INTO gaze_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","ኤርገሲስ እን ቡሻዬ ኬሳ ኮርቤሰ ሆላ ህርእነ ህንቀብኔ ከን ገቲንሳ ገቲ አደቢ የከ ቶኮት ትልማመሙ ኣርሳ የከ ኦፊሳ ከን ዋቀዮፍ ዽኤፈሙ ጎዼ ሉበት ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","ሉብች ሃሉመ ከናን ፉለ ዋቀዮ ዱረት አራረ እሳፍ ቡሰ፤ እንስ ወንቶተ ከኔን ኬሳ ዋን ሆጄቴ ከን የከ ቀቤሰ እሰ ጎዼ ከሚፍዩ ዺፈመ አርገተ።” ");
INSERT INTO gaze_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“አሮኒፊ እልማሳቲፍ አጀጀ ከነ ኬን፦ ‘ሴር ኣርሳ ጉበሙ ከናዸ፤ ኣርሳን ጉበሙ ሀመ ለፍት በሪቱት ሀልከን ጉቱ እብደ እዶ ኣርሳረ ጅሩ ጉባ ሃቱሩ፤ እብድስ እቱመ ፉፌ እዶ ኣርሳረት ሃቦበኡ። ");
INSERT INTO gaze_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","ሉብን ሱንስ ኡፈተሳ ከን ቁንጬ ተልባራ ሆጄተሜፊ ኡፈተ ወያ ጀላን ዸግነሳት ኣኑ ከን ቁንጬ ተልባራ ሆጄተሜ ሃኡፈቱ፤ ኤርገሲስ ዳራ ኣርሳ ጉበሙ ከን እብድ እዶ ኣርሳረት ጉቤ ፍጤ ሰነ ሀሬ እዶ ኣርሳ ጭነ ሃካኡ። ");
INSERT INTO gaze_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","ኤርገሲስ ኡፈተ ሰነ ኦፍራ ባሴ ከን ብራ ሃኡፈቱ፤ ዳራ ሰነስ ባቴ ቁበተ ኬሳ ገድ ባሴ ለፈ አከ ሴራት ቁልቁሉ ተኤት ሃጌሱ። ");
INSERT INTO gaze_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","እብድ እዶ ኣርሳረ ጅሩ ዬሮ ሁንደ ቦበኡ ቀበ፤ ዮምዩስ ህንዻምን። ሉብች ገነመ ገነመ እብደ ሰነት ቆራን ሃነቁ፤ ኣርሳ ጉበሙ እብደረት ሃቆጴሱ፤ ከነረትስ ጮመ ኣርሳ ነጋ ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","እዶ ኣርሳረት እብድ ዬሮ ሁንደ ሃቦበኡ፤ ጎንኩማስ ህንዻምን። ");
INSERT INTO gaze_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘ሴር ኬና ምዻኒ ከናዸ፦ እልማን አሮን ዋን ከነ ፉሌ እዶ ኣርሳት ፉለ ዋቀዮ ዱረት ሃዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","ሉብንስ ዳኩ ቡላኣ ኮኜ ቶኮፊ ዘይቲ፣ እጣነ ኬና ምዻኒረ ጅሩ ሁንደ ወጅን ፉዼ ኡርጋ ዋቀዮት ቶሉ ጎዼ አከ ኩታ ያደኖት እዶ ኣርሳረት ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","አሮኒፊ እልማንሳሞ ዋንራ ሀፌ ሃኛተን፤ ኩን መጥኖ እዶ ቁልቁሉት ኛተሙ ቀቡዸ፤ እሳንስ ኦብዲ ዱንካነ ወል ገኢ ኬሰት ሃኛተን። ");
INSERT INTO gaze_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","ወን ኩን ራጭቲዻን ቶልፈሙ ህንቀቡ፤ አን ኬና እብዳን ና ዽኤፈሙ ኬሳ አከ ቆደ እሳኒት ዋን ከነ እሳኒፍ ኬኔረ። ኩንስ አኩመ ኣርሳ ጩቡቲፊ ኣርሳ የካት ዋን ሁንደ ጫላ ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","ሰኚን አሮን ከን ዺረ ተኤ ከምዩ ዋን ከነ ኛቹ ደንደአ። ኩንስ ቆደ ኬና እብዳን ዋቀዮፍ ዽኤፈሙ ኬሳ ዸሎተኬሰን ከን ዹፉት በረ በራን አሮኒፍ ኬነሜዸ፤ ነምን እሰ ቱቁ ሁንድኑስ ንቁልቁላአ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“ኬናን አሮኒፊ እልማንሳ ጉያ እን ድበሙት ዋቀዮፍ ዽኤሱ ቀበን ከናዸ፦ ዳኩ ቡላኣ ኢፊ ኩዸን ኬሳ ቶኮ ጄቹንስ ወለካሳ ገነመ፣ ወለካሞ ገልገለ ዬሮ ሁንደ ኬና ምዻኒ ጎዸኒ ሃዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","ኩንስ ዘይቲዻን ኤሌረት ሃቶልፈሙ፤ አከ ጋሪት ወልት መኪቲ ኬና ምዻን ሰና ጨጨብሲ ኡርጋ ዋቀዮት ቶሉ ጎዺ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","እልምሳ ከን ሉበ ተኤ ድበሜ እዶሳ ቡኡ ዋን ከነ ሃቆጴሱ፤ ኬናን ኩን ሰበቢ ቆደ ዋቀዮ ከን በረ በራ ተኤፍ ጉቱማት ሃጉበሙ። ");
INSERT INTO gaze_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","ኬናን ምዻኒ ከን ሉብች ዽኤሱ ሁንድ ጉቱማት ሃጉበሙ፤ ኣርሳን ሱን ኛተሙ ህንቀቡቲ።” ");
INSERT INTO gaze_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“አሮኒፊ እልማንሳቲን አከነ ጄዽ፦ ‘ሴር ኣርሳን ጩቡ እቲን ዽኤፈሙ ከናዸ፦ ኣርሳን ጩቡ እዶ ኣርሳን ጉበሙ እት ቀለሙት ፉለ ዋቀዮ ዱረት ሃቀለሙ፤ ኣርሳን ኩን ዋን ሁንደ ጫላ ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","ሉብን እሰ ዽኤሱ ኣርሳ ከነ ሃኛቱ፤ ኩንስ ኦብዲ ዱንካነ ወል ገኢ ኬሰት እዶ ቁልቁሉት ኛተሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","ነምን ፎን ሰነ ቱቁ ከምዩ ንቁልቁላአ፤ ዮ ዺግንሳ ቶኮዩ ኡፈተት ፈጨኤ ኡፈተ ሰነ እዶ ቁልቁሉት ሚጩ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","ኦኮቴን ሱጴ ከን ፎን ሱን እት አፌለሜ ሃጨብሰሙ፤ ዮ ኦኮቴ ናሲት አፌለሜ ገሩ ሀቀሜ ብሻኒን ሃዽቀሙ። ");
INSERT INTO gaze_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","ዺር ጎሰ ሉቦታ ተኤ ከምዩ ፎን ከነ ኛቹ ንደንደአ፤ ኩን ዋን ሁንደ ጫላ ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","ገሩ ኣርሳን ጩቡ ከን አራረ ቡሱዻፍ ዺግንሳ ገረ ዱንካነ ወል ገኢ እዶ ቁልቁሉት ፍደሙ ከምዩ ኛተሙ ህንቀቡ፤ እን ጉበሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘ሴር ኣርሳ የካ ከን ዋን ሁንደ ጫላ ቁልቁሉ ተኤ ሰና ከነ፦ ");
INSERT INTO gaze_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","ኣርሳን የካ እዶ ኣርሳን ጉበሙ እት ቀለሙት ሃቀለሙ፤ ዺግንሳሞ ገመ ሁንዳን እዶ ኣርሳት ፈጫፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","ሞርሳ ሁንድኑስ ኣርሳ ተኤ ዽኤፈሙ ቀበ፤ ኩንስ ዱቦፊ ሞረ ምአ ገራ ሀጉጉ፣ ");
INSERT INTO gaze_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","ከሌ ለማኒፊ ሞረ እሳንረ ጅሩ ከን ሙዺት ዽኣቱ፣ ሀጉጊን ትሩ ከን ከሌወን ወጅን በኡ ወል ፋነ ሃዽኣቱ። ");
INSERT INTO gaze_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","ሉብችስ ኣርሳ እብዳን ዋቀዮፍ ዽኣቱ ጎዼ እዶ ኣርሳረት ሃጉቡ፤ ኩን ኣርሳ የካት። ");
INSERT INTO gaze_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","ዺር ጎሰ ሉቦታ ተኤ ከምዩ ፎን ከነ ኛቹ ደንደአ፤ ኩን ገሩ እዶ ቁልቁሉት ኛተሙ ቀበ፤ ኣርሳን ኩን ዋን ሁንደ ጫላ ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘ሴር ኣርሳን ጩቡቲፊ ኣርሳን የካ እቲን ዽኤፈሙ ቶኩመ፤ ኣርሳወን ኩኔንስ ከን ሉበ እቲን አራረ ቡሱ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","ሉብን ነማፍ ጄዼ ኣርሳ ጉበሙ ዽኤሱ ቶኮ ጎጋ ኣርሳ ጉበሙ ሰና ኦፊሳቲፍ ሃፉዸቱ። ");
INSERT INTO gaze_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","ኬናን ምዻኒ ከን በርበዳ እብዳረት ዮካን ኤሌረት ዮካን ቤዴረት ብልቻቴ ከምዩ ሉበ እሰ ዽኤሱፍ ሃኬነሙ፤ ");
INSERT INTO gaze_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","ኬናን ምዻኒ ከምዩ ጄቹንስ ከን ዘይቲን እት መከሜ ዮካን ጎጎጋን እልማን አሮን ሁንዳፍ ወል ቅጤ ሃኬነሙ። ");
INSERT INTO gaze_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘ሴር ኣርሳ ነጋ ከን ነምን ቶኮ እቲን ዋቀዮፍ ዽኤሱ ቀቡ ከነ። ");
INSERT INTO gaze_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘እን ዮ ገለተ ገልቹፍ ኣርሳ ዽኤፈቴ፣ ኣርሳ ገለታ ከነ ወጅን መጥኖ ዘይቲን እት መከሜ፣ ብጥሌ ራጭቲ መሌ ቶልፈሜ ዘይቲን እረ ድበሜፊ መጥኖ ዳኩ ቡላኣ ከን አከ ጋሪ ሱኩመሜ ዘይቲን እት መከሜ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","ኣርሳ ነጋ ከን ገለታፍ ዽኤፈቱ ወጅንስ ኬና መጥኖ ራጭቲ ቀቡ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","ኣርሳ ሁንደ ኬሳ ቶኮ ቶኮ ፉዼ አከ ኬና ዋቀዮፍ ዽኤፈሙ ቶኮት ሃፍዱ፤ ኩንስ ሉበ ዺገ ኣርሳ ነጋ ፈጫሱ ሰናፍ ሃኬነሙ። ");
INSERT INTO gaze_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","ፎን ኣርሳ ነጋ ከን ገለታፍ ዽኤፈሙ ጋፉመ ዽኣቴ ሰነ ኛተሜ ዹሙ ቀበ፤ ወን ቶኮዩ እሰራ ሀፌ ቡሉ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘ዮ ኣርሳንሳ ወሬገ ጉተቹፍ ዮካን ኣርሳ ፌዺዻን ዽኣቱ ተኤ፣ ኣርሳን ሱን ጉዩመ እን ዽኤሴ ኛተሙ ቀበ፤ ከን ሀፌ ገሩ ጉያ እት ኣኑ ኛተሙ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","ፎን ኣርሳ ሰነራ ሀመ ጉያ ሰደፋት ሀፌ ጉበሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","ፎን ኣርሳ ነጋ ሰነራ ዮ ወን ቶኮዩ ጉያ ሰደፋት ኛተሜ ኣርሳን ሱን ህንፉዸተሙ። ኩን ሰበቢ ጡራኣ ተኤፍ ነመ ዽኤሴ ሰናፍ ፉዸተመ ህንቀባቱ። ነምን ፎን ሰነራ ኛቱ እት ጋፈተመ። ");
INSERT INTO gaze_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘ፎን ዋን አከ ሴራት ጡራኣ ተኤ ከምዩ ቱቄ ህንኛተምን፤ ፎን ሱን ጉበሙ ቀበ። ፎን ካን ገሩ ነምን አከ ሴራት ቁልቁሉ ተኤ ከምዩ ኛቹ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","ገሩ ነምን ጡራኣን ዮ ፎን ኣርሳ ነጋ ከን ዋቀዮፍ ዽኤፈሜ ኛቴ፣ እን ሰበ ኦፊ ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","ነምን ዮ ዋን ጡራኣ ጄቹንስ ጡራኡማ ነማ ዮካን ሆሪ ጡራኣ ዮካን ዋን ጡራኣ ከምዩ፣ ዋን ጅብሲሳ ቱቄ ኤርገሲሞ ፎን ኣርሳ ነጋ ከን ዋቀዮፍ ዽኣቴ ኬሳ ኛቴ ነምን ሱን ሰበ ኦፊ ኬሳ ሃበሌፈሙ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“እስራኤሎታን አከነ ጄዽ፤ ‘ሞረ ሎኒ ዮካን ከን ሆላ ዮካን ከን ሬኤ ከሚዩ ህንኛትና። ");
INSERT INTO gaze_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","ጮምን ሆሪ ዱኤ አርገሜ ዮካን ብኔንስ አጄሴ ዋን ብራፍ ሃኦሉ፤ እስን ገሩ እሰ ኛቹ ህንቀብደን። ");
INSERT INTO gaze_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","ነምን ሆሪ እብዳን ዋቀዮፍ ዽኤፈሜራ ጮመሳ ኛቴ ከምዩ ሰበ ኦፊሳ ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","እስን ለፈ ጅራተን ሁንደት ዺገ ስምብሮ ዮካን ሆሪ ጎሰ ከሚዩ ህንኛትና። ");
INSERT INTO gaze_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","ነምን ከምዩ ዮ ዺገ ኛቴ ሰበ ኦፊሳ ኬሳ ሃበሌፈሙ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“እስራኤሎታን አከነ ጄዽ፤ ‘ነምን ኣርሳ ነጋ ዋቀዮፍ ዽኤሱ ከኑመራ ፉዼ ኣርሳ ኦፊሳ ዋቀዮፍ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙስ ሀርኩመሳቲን ሃፍዱ፤ ጮመ ሰነ ሀንደራፈ ወጅን ሃፍዱ፤ ሀንደራፈስ ኣርሳ ሶቾፈሜ ጎዼ ፉለ ዋቀዮ ዱረት ሃሶቾሱ። ");
INSERT INTO gaze_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","ሉብች ጮመ ሰነ እዶ ኣርሳረት ሃጉቡ። ሀንደራፍንሳ ገሩ አሮኒፊ እልማንሳቲፍ ሃኬነሙ። ");
INSERT INTO gaze_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","ተፈ ምርጋ ከን ኣርሳ ነጋኬሰኒ ኬና ጎዻቲ ሉባፍ ኬና። ");
INSERT INTO gaze_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","እልም አሮን ከን ዺጋፊ ጮመ ኣርሳ ነጋ ዽኤሱ ሱን ተፈ ምርጋ ቆደ ኦፊሳ ጎዼ ሃፉዸቱ። ");
INSERT INTO gaze_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","አን ኣርሳ ነጋ ከን እስራኤሎታራ ሀንደራፈ ሶቾፈሜፊ ተፈ ዽኣቴ ሰነ ፉዸዼረ፤ ከነስ አከ ቆደ እሳን በረ በራን እስራኤሎተራ አርገተኒት አሮን ሉብቻፊ እልማንሳቲ ኬኔረ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","ጋፈ እሳን ሉቡማዻን ዋቀዮን ተጃጅሉፍ ዽኣተንት ኣርሳ እብዳን ዋቀዮፍ ዽኣቴራ ቆድን አሮኒፊ እልማንሳቲፍ ረመደሜ ከነ። ");
INSERT INTO gaze_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","ጉያ እሳን ድበመንት፣ አከ እስራኤሎን ቆደሳኒ ጎዸኒ በረ በራን ዸሎተ ዹፉት ዋን ከነ እሳኒ ኬነን ዋቀዮ አጀጄረ። ");
INSERT INTO gaze_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","ኤጋ ሴር ዽኤሱ ኣርሳ ጉበሙ፣ ኬና ምዻኒ፣ ኣርሳ ጩቡ፣ ኣርሳ የካ፣ ሴር ድበሙ ሉቡማቲፊ ኣርሳ ነጋ ከናዸ፤ ");
INSERT INTO gaze_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","ኩንስ አጀጀ ዋቀዮ ጋፈ አከ እስራኤሎን ገሞጂ ሲናት ኬናሳኒ ዋቀዮፍ ዽኤሰን ጋረ ሲናረት ሙሴዻፍ ኬኔዸ። ");
INSERT INTO gaze_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“አሮኒፊ እልማንሳ፣ ኡፈተሳኒ፣ ዘይቲ እቲን ድበን፣ ድብቸ ኣርሳ ጩቡቲፍ ዽኤፈሙ፣ ኮርቤዪ ሆላ ለማፊ ጉንዶ መጥኖ ባቱ ፍድ፤ ");
INSERT INTO gaze_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","ወልዳ ሁንደስ በልበለ ዱንካነ ወል ገኢ ዱረት ወልት ቀብ።” ");
INSERT INTO gaze_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","ሙሴንስ አኩመ ዋቀዮ እሰ አጀጄ ሰነ ጎዼ፤ ወልዳን ሁንድስ በልበለ ዱንካነ ወል ገኢ ዱረት ወልት ቀበሜ። ");
INSERT INTO gaze_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","ሙሴንስ ወልዳ ሰናን፣ “ወን ዋቀዮ አከ ሆጄተሙ አጀጄ ከነ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","ኤርገሲስ ሙሴን አሮኒፊ እልማንሳ ገረ ፉለ ዱራት ፍዴ ብሻኒን እሳን ዽቄ። ");
INSERT INTO gaze_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","እንስ አሮንት ክታ ኡፍሴ ሰበታን ህዼፍ፤ ወንደቦስ እት ኡፍሴ እሰረት ድረተ ደበሌፍ፤ ድረተ ሰነስ ሰበተ ኦጉማዻን ሆጄተሜን ህዼፍ። ");
INSERT INTO gaze_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","ኪሲ ቆማ እት ካኤ ኪሲ ሰነ ኬሰሞ ኡሪሚፊ ቱሚሚ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","ሙሴንስ አኩመ ዋቀዮ እሰ አጀጄት መታ አሮንት መረተ መሬ፤ መረተ ሰነረትስ ከራ ፉለ ዱራቲን ፋየ ወርቄ ከን ጎንፎ ቁልቁሉ ቶልቼ። ");
INSERT INTO gaze_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","ኤርገሲ ሙሴን ዘይቲ እቲን ድበን ፉዼ ዱንካነ ቁልቁሉፊ ዋን አች ኬሰ ጅሩ ሁንደ ድቤ ቁልቁሌሴ። ");
INSERT INTO gaze_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","ዘይቲ ሰነራስ ፉዼ እዶ ኣርሳረት ዬሮ ቶርበ ፈጫሴ፤ አከ እሳን ቁልቁሌሱፍስ እዶ ኣርሳቲፊ ምአሳ ሁንደ አከሱመስ ገበቴ እት ዽቀተን ሚለሳ ወጅን ዘይቲ ድቤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","ዘይቲ እቲን ድበንራስ ፉዼ መታ አሮንረት ዸንገላሴ፤ እሰ ቁልቁሌሱፍስ እሰ ድቤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","ሙሴንስ አኩመ ዋቀዮ እሰ አጀጄት እልማን አሮን ገረ ፉለ ዱራት ባሴ ክታ እት ኡፍሴ፤ ሰበተ ህዼፊ ጎንፎ መታሳኒት ካኤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","ኤርገሲሞ ኣርሳ ጩቡቲፍ ድብቸ ዽኤሴ፤ አሮኒፊ እልማንሳስ መታ ድብቸ ሰናረ ሀርከሳኒ ካአን። ");
INSERT INTO gaze_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","ሙሴንስ ድብቸ ሰነ ቀሌ ዺገ ፉዼ እዶ ኣርሳ ቁልቁሌሱፍ ቁበሳቲን ጋንፈ እዶ ኣርሳ ሁንደ ድቤ፤ ዺገ ሀፌሞ ሚለ እዶ ኣርሳ ጀለት ገድ ነቄ። አራረ እሳፍ ቡሱፍስ እዶ ኣርሳ ሰነ ቁልቁሌሴ። ");
INSERT INTO gaze_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","አከሱመስ ሞረ ናኖ ምአ ገራ ጅሩ፣ ሀጉጊ ትሩ፣ ከሌ ለማኒፊ ሞረሳኒ ፉዼ እዶ ኣርሳረት ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","ድብቸ ሰነ፣ ጎጋሳ፣ ፎንሳቲፊ ጩማሳ ገሩ አኩመ ዋቀዮ እሰ አጀጄት ቁበተ ኬሳ ገድ ባሴ ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","ኤርገሲሞ ኣርሳ ጉበሙፍ ኮርቤሰ ሆላ ዽኤሴ፤ አሮኒፊ እልማንሳስ መታ ሆላ ሰናረ ሀርከሳኒ ካአን። ");
INSERT INTO gaze_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","ሙሴንሞ ኮርቤሰ ሆላ ሰነ ቀሌ ዺገሳ እዶ ኣርሳት ገመ ሁንዳን ፈጫሴ። ");
INSERT INTO gaze_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","ኮርቤሰ ሆላ ሰነ ገርገር ኩኩቴ መታ፣ ቡኣፊ ጮመሳ ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","እንስ ምአ ገራቲፊ ሉከ ብሻኒን ዽቄ ኮርቤሰ ሆላ ሰነ ጉቱ እዶ ኣርሳረት ጉቤ። ኩንስ ኣርሳ ጉበሙ፣ ፎሊ ነመት ቶሉ፣ ኣርሳ ኛታ አኩመ ዋቀዮ ሙሴ አጀጄት ዋቀዮፍ ዽኤፈሜዸ። ");
INSERT INTO gaze_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","እንስ ኤርገሲ ኮርቤሰ ሆላ ካን ጄቹንስ ሆላ እቲን ሙደን ሰነ ዽኤሴ፤ አሮኒፊ እልማንሳሞ መታ ሆላ ሰናረ ሀርከሳኒ ካአን። ");
INSERT INTO gaze_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","ሙሴንስ ሆላ ሰነ ቀሌ ዺገሳራ ፉዼ ፊጤ ጉረ አሮን ምርጋ፣ ቁበ አቡዱ ሀርከሳ ምርጋቲፊ ቁበ አቡዱ ሚለሳ ምርጋ ድቤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","እልማን አሮንስ ገረ ፉለ ዱራት ባሴ ዺገ ፉዼ ፊጤ ጉረሳኒ ምርጋ፣ ቁበ አቡዱ ሀርከሳኒ ምርጋቲፊ ቁበ አቡዱ ሚለሳኒ ምርጋ እቲን ቱቄ። ኤርገሲስ ዺገ ሰነ እዶ ኣርሳት ገመ ሁንዳን ፈጫሴ። ");
INSERT INTO gaze_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","እንስ ጮመ፣ ዱቦ፣ ሞረ ናኖ ምአ ገራ ጅሩ፣ ሀጉጊ ትሩ፣ ከሌ ለማኒፊ ሞረሳኒ፣ ተፈ ምርጋ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","ኤርገሲስ ጉንዶ መጥኖ ባቱ ከን ፉለ ዋቀዮ ዱረ ቱሬ ሰነራ መጥኖ ቶኮ፣ መጥኖ ዘይቲዻን ቶልፈሜ ቶኮፊ ብጥሌ ቶኮ ፉዼ፤ ዋን ከነስ ጮመ ሰናፊ ተፈ ምርጋረ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","እንስ ወንቶተ ከኔን ሁንደ ሀርከ አሮኒፊ ሀርከ እልማንሳ ኬሰ ካኤ ኣርሳ ሶቾፈሙ ጎዼ ፉለ ዋቀዮ ዱረት ሶቾሴ። ");
INSERT INTO gaze_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","ሙሴንስ ወንቶተ ከኔን ሀርከሳኒቲ ፉዼ ኣርሳ እቲን ሉበ ተአን ከን እብዳን ዋቀዮፍ ዽኤፈሙ፣ ፎሊ ነመት ቶሉ፣ ኣርሳ ኛታ ጎዼ እዶ ኣርሳረት ኣርሳ ጉበሙ ጉባት ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","ሙሴንስ ሀንደራፈ ፉዼ ኣርሳ ሶቾፈሙ ጎዼ ፉለ ዋቀዮ ዱረት ሶቾሴ፤ ኩንስ አኩመ ዋቀዮ እሰ አጀጄት ቆደ ሙሴን ኮርቤሰ ሆላ እቲን ሉበ ተአንራ አርገቱዸ። ");
INSERT INTO gaze_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","ኤርገሲስ ሙሴን ዘይቲ እቲን ድበኒፊ ዺገ እዶ ኣርሳረ ጅሩራ ፉዼ አሮኒፊ ኡፈተሳት፣ እልማን እሳቲፊ ኡፈተሳኒት ፈጫሴ፤ አከሲንስ አሮኒፊ ኡፈተሳ፣ እልማንሳቲፊ ኡፈተሳኒ ቁልቁሌሴ። ");
INSERT INTO gaze_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","ሙሴንስ አሮኒፊ እልማንሳቲን አከነ ጄዼ፤ “ፎን ሰነ በልበለ ዱንካነ ወል ገኢ ዱረት አፌላ፤ አኩመ አን ‘አሮኒፊ እልማንሳ ሃኛተን’ ጄዼ አጀጄት ፎን ሰነ ቡዴነ ጉንዶ ኣርሳን እቲን ሉቦተ ተአን ኬሰ ካአሙ ሰነ ኬሰ ጅሩ ወጅን አቹመት ኛዻ። ");
INSERT INTO gaze_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","ፎኒፊ ቡዴነ ሀፉሞ እብዳን ጉባ። ");
INSERT INTO gaze_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","ሰበቢ ሉበ ተኡንኬሰን ቡልቲ ቶርበ ፉዸቱፍ ሀመ ዬሮን ሉበ ተኡኬሰኒ ራወቱት ቡልቲ ቶርበ በልበለ ዱንካነ ወል ገኢ ዱራ ህንዴምና። ");
INSERT INTO gaze_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","ዋን ሀርአ ሆጄተሜ ከነ ዋቀዮቱ አራረ እስኒ ቡሱፍ አከ ሆጄተሙ አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","እስን አከ ህንዱኔፍ ቡልቲ ቶርበ ሀልከኒፊ ጉያ በልበለ ዱንካነ ወል ገኢ ዱረ ቱራቲ ዋን ዋቀዮ እስንራ በርባዱ ሆጄዻ፤ ወን አን አጀጀሜ ከናቲ።” ");
INSERT INTO gaze_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","አሮኒፊ እልማንሳ ዋን ዋቀዮ ከራ ሙሴቲን አጀጄ ሁንደ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","ሙሴን ቡልቲ ሰዴተፋት አሮን፣ እልማን አሮኒፊ ማንጉዶተ እስራኤል ዋሜ፤ ");
INSERT INTO gaze_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","አሮኒንስ አከነ ጄዼ፤ “ኣርሳ ጩቡቲፍ ድብቸ ቶኮ፣ ኣርሳ ጉበሙፍሞ ኮርቤሰ ሆላ ቶኮ ከኔን ህርእነ ህንቀብኔ ፉዺ ፉለ ዋቀዮ ዱረት ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","ኤርገሲስ እስራኤሎታን አከነ ጄዽ፦ ‘ኣርሳ ጩቡቲፍ ኮርቤሰ ሬኤ ቶኮ፣ ኣርሳ ጉበሙፍሞ ድብቸ ቶኮፊ ኮርቤሰ ሆላ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ህርእነ ህንቀብኔ፣ ");
INSERT INTO gaze_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","ኣርሳ ነጋቲፍሞ ሰንጋ ቶኮፊ ኮርቤሰ ሆላ ቶኮ፣ ኬና ምዻኒ ከን ዘይቲዻን ሱኩመሜ ወጅን ፉለ ዋቀዮ ዱረት ኣርሳ ጎቹፍ ዽኤስ። ሀርአ ዋቀዮ እስንት ሙልአታቲ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","እሳንስ ዋን ሙሴን እሳን አጀጄ ሰነ ፉለ ዱንካነ ወል ገኢ ዱረት ፍደን፤ ወልዳን ሁንድኑስ ዹፌ ፉለ ዋቀዮ ዱረ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","ሙሴንስ፣ “አከ ኡልፍን ዋቀዮ እስንት ሙልአቱፍ ወን ዋቀዮ አከ እስን ጎተን እስን አጀጄ ከነ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","ኤርገሲ ሙሴን አሮኒን አከነ ጄዼ፤ “ገረ እዶ ኣርሳ ኮቱቲ ኣርሳ ጩቡኬቲቲፊ ኣርሳኬ ከን ጉበሙ ዽኤፈዹቲ ኦፊኬቲፊ ሰባፍ አራረ ቡስ፤ አኩመ ዋቀዮ አጀጄትስ ኣርሳ ሰባ ዽኤሲቲ አራረ እሳኒፍ ቡስ።” ");
INSERT INTO gaze_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","አሮን ገረ እዶ ኣርሳ ዹፌ ድብቸ ኣርሳ ከን ሰበቢ ጩቡሳቲፍ ዽኣቴ ሰነ ቀሌ። ");
INSERT INTO gaze_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","እልማንሳስ ዺገ እሰት ፍደን፤ እንሞ ዺገ ሰነ ኬሰ ቁበሳ ጩጴ ጋንፈወን እዶ ኣርሳ ድቤ፤ ዺገ ሀፌሞ ሚሎ እዶ ኣርሳ ጀለት ዸንገላሴ። ");
INSERT INTO gaze_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","እንስ አኩመ ዋቀዮ ሙሴ አጀጄት ኣርሳ ጩቡ ሰነራ ሞረ፣ ከሌወኒፊ ሀጉጊ ትሩ እዶ ኣርሳረት ጉቤ፤ ");
INSERT INTO gaze_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","ፎኒፊ ጎጋሳሞ ቁበተ ኬሳ ባሴ ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","እን ኤርገሲ ኣርሳ ጉበሙ ቀሌ። እልማንሳስ ዺገ ፍደኒ እት ኬነን፤ እንስ እዶ ኣርሳረት ገመ ሁንዳን ፈጫሴ። ");
INSERT INTO gaze_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","እሳንስ ኣርሳ ጉበሙ ቡኣ ቡኣዻን፣ መታ ወጅን እሰት ኬነን፤ እንስ እዶ ኣርሳረት ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","ምአ ገራቲፊ ሉከ ቀልመ ሰናስ ዽቄ እዶ ኣርሳረት፣ ኣርሳ ጉበሙ ጉባት ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","እት ኣንሴስ አሮን ኣርሳ ሰባ ዽኤሴ፤ ሬኤ ኣርሳ ጩቡ ሰባቲፍ ዽኤፈሙ ሰነ ፉዼ ቀሌ፤ አኩመ ዱራን ሆጄቴትስ ኣርሳ ጩቡ ጎዼ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","እንስ ኣርሳ ጉበሙ ፍዴ አኩመ አጀጀሜት ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","ኬና ምዻኒስ ፍዴ ኮኜ ቶኮራ ፉዼ ኣርሳ ገነመ ገነመ ጉበሙረት ደበሌ እዶ ኣርሳረት ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","አሮንስ ሰንጋፊ ኮርቤሰ ሆላ ሰነ ኣርሳ ነጋ ከን ሰባፍ ጄዸሜ ዽኤፈሙ ጎዼ ቀሌ። እልማንሳሞ ዺገ ፍደኒ እሰት ኬነን፤ እንስ ዺገ ሰነ እዶ ኣርሳረት ገመ ሁንዳን ፈጫሴ። ");
INSERT INTO gaze_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","ጮመ ሰንጋቲፊ ኮርቤሰ ሆላ ሰና ጄቹንስ ዱቦ፣ ሞረ ምአ ገራ ሀጉጉ፣ ከሌወኒፊ ሀጉጊ ትሩ፣ ");
INSERT INTO gaze_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","ሀንደራፎተረ ካአን፤ አሮንስ ጮመ ሰነ እዶ ኣርሳረት ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","አሮንስ አኩመ ሙሴን እሰ አጀጄት ሀንደራፎታፊ ተፈ ምርጋ ኣርሳ ሶቾፈሙ ጎዼ ፉለ ዋቀዮ ዱረት ሶቾሴ። ");
INSERT INTO gaze_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","አሮን ሀርከሳ ሰበት በልእሴ እሳን ኤብሴ። ኤርገ ኣርሳ ጩቡ፣ ኣርሳ ጉበሙፊ ኣርሳ ነጋ ዽኤሴ ቦዴስ ገድ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","ሙሴፊ አሮንስ ዱንካነ ወል ገኢ ሴነን፤ ዮሙ አቺ በአንትስ ሰበ ኤብሰን፤ ኡልፍን ዋቀዮስ ሰበ ሁንደት ሙልአቴ። ");
INSERT INTO gaze_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","እብድስ ዋቀዮ ብራ በኤ ኣርሳ ጉበሙፊ ጮመ እዶ ኣርሳረ ቱሬ ሰነ ፍጤ፤ ሰብን ሁንድስ ዋን ከነ አርጌ እልልቼ፤ አደ እሳቲንስ ጎምብፈሜ ሰገዴ። ");
INSERT INTO gaze_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","እልማን አሮን ጄቹንስ ናዳቢፊ አቢሁ ግርግራሳኒ ፉዸተኒ እብደ እት ነቀኒ እጣነረት ፍርፍርሰን፤ እሳንስ እብደ ህንኤየመምኔ ከን እን ህንአጀጅን ፉለ ዋቀዮ ዱረት ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","ከናፉ እብድ ዋቀዮ ብራ በኤ ጉቤ እሳን ፍጤ፤ እሳንስ ፉለ ዋቀዮ ዱረት ዹመን። ");
INSERT INTO gaze_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","ሙሴንስ አሮኒን አከነ ጄዼ፤ “ወን ዋቀዮ ዱበቴ ከናዸ፦ “ ‘አን ወረ ነት ዽኣተን ግዱት፣ ቁልቁልነኮ ነንአርግሲሰ፤ ሰበ ሁንደ ዱረትስ አን ነንኡልፋዸ።’ ” አሮንሞ ንጨልእሴ። ");
INSERT INTO gaze_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","ሙሴንስ ሚሻኤሊፊ ኤልዛፋን እልማን ኡዚኤል ኦቦሌሰ አባ አሮን ሰና ኦፍት ዋሜ፣ “ኮታቲ ዱርቢወንኬሰን ፉለ እዶ ቁልቁሉ ዱራ ፉዻቲ ቁበተ ኬሳ ገድ ባሳ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","ጀርስ ዹፈኒ አኩመ ሙሴን አጀጄት አኩመ እሳን ክታሳኒ ኡፈተኒ ጅረንት ፉዸኒ ቁበተ ኬሳ ገድ እሳን ባሰን። ");
INSERT INTO gaze_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","ኤርገሲ ሙሴን አሮኒፊ እልማን አሮን፣ ኤሌኣዛሪፊ ኢታማሪን አከነ ጄዼ፤ “መታኬሰን ፍለቹ ህንዺስና፤ ወያኬሰንስ ህንተርሳስና፤ ዮ ከና አቺ እስን ንዱቱ፤ ዋቀዮስ ሰበ ጉቱት ዼከመ። ገሩ ፍሮንኬሰን መን እስራኤል ሁንድ ወረ ዋቀዮ እብዳን በሌሴ ሰናፍ ቦኡ ደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","ሰበቢ ዘይቲን ዋቀዮ ከን እቲን ድበን እስንረ ጅሩፍ እስን በልበለ ዱንካነ ወል ገኢ ዱራ ህንዴምና፤ ዮ ከና አቺ ንዱቱ።” እሳንስ አኩመ ሙሴን እሳን አጀጄ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","ዋቀዮስ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“አቲፊ እልማንኬ ዮሙ ዱንካነ ወል ገኢ ኦል ሴንተንት ዳዺ ወይኒ ዮካን ዹጋቲ ነመ መቼሱ ህንዹግና። ዮ ከና አቺ ንዱቱ። ወን ኩን ዸሎተ ዹፉፍ ሴረ በረ በራ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","እስን ዋን ቁልቁሉፊ ዋን ቁልቁሉ ህንተእን፣ ዋን ጡራኣፊ ዋን ጡራኣ ህንተእን አዳን ባፍተኒ ቤኩ ቀብዱ፤ ");
INSERT INTO gaze_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","ሴረ ዋቀዮ ከራ ሙሴቲን እሳኒ ኬኔ ሁንደስ ሰበ እስራኤል በርሲሱ ቀብዱ።” ");
INSERT INTO gaze_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","ሙሴንስ አሮኒፊ እልማን አሮን ወረ ሀፈን ጄቹንስ ኤሌኣዛሪፊ ኢታማሪን አከነ ጄዼ፤ “ኬና ምዻኒ ከን ኣርሳወን እብዳን ዋቀዮፍ ዽኤፈመን ሰነራ ሀፌ ፉዻቲ ኡቱ እን ህንቡካእን ቶልቻቲ እዶ ኣርሳ ብረት ኛዻ፤ ኣርሳን ኩን ዋን ሁንደ ጫላ ቁልቁሉዻቲ። ");
INSERT INTO gaze_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","ወን ኩን ኣርሳወን እብዳን ዋቀዮፍ ዽኤፈመን ኬሳ ሰበቢ ቆደኬቲፊ ቆደ እልማንኬቲ ተኤፍ ለፈ ቁልቁሉት ኛዻ፤ አን አከነ አጀጀሜራቲ። ");
INSERT INTO gaze_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","ገሩ አት፣ እልማንኬቲፊ እንተለንኬ ሀንደራፈ ሶቾፈሜፊ ተፈ ዽኤፈሜ ሰነ ኛቹ ደንዴሱ። ዋን ከነስ እዶ ሴራን ቁልቁሉ ተኤት ኛዻ። ወን ኩን ቆደኬቲፊ ቆደ እልማንኬቲ ተኤ ኣርሳ ነጋ ከን ሰበ እስራኤልራ እስኒፍ ኬነሜዻቲ። ");
INSERT INTO gaze_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","ተፍን ዽኤፈሜፊ ሀንደራፍን ሶቾፈሜ ሱን አከ ኣርሳ ሶቾፈሙ ቶኮት አከ ፉለ ዋቀዮ ዱረት ሶቾፈሙፍ ጮመ ኣርሳ እብዳን ዽኤፈሜ ወጅን ፍደሙ ቀበ፤ ኩንስ አኩመ ዋቀዮ አጀጄት ቆደኬቲፊ ቆደ እልማንኬቲ ከን በረ በራት።” ");
INSERT INTO gaze_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","ሙሴንስ ሬኤ ኣርሳ ጩቡ ሰነ ጀቤሴ በርባዴ፤ ኩኖ ሬኤን ሱን ጉበሜ ቱሬ፤ እንስ እልማን አሮን ወረ ሀፈንት ጄቹንስ ኤሌኣዛሪፊ ኢታማርት ኣሬ አከነ ጄዼ እሳን ጋፈቴ፤ ");
INSERT INTO gaze_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“እስን ማሊፍ ኣርሳ ጩቡ ሰነ እዶ ቁልቁሉት ህንኛትን? ኣርሳን ሱን ዋን ሁንደ ጫላ ቁልቁሉዸ፤ እንስ አከ እስን ፉለ ዋቀዮ ዱረት አራረ እሳኒፍ ቡሱዻን የከ ሰባ በሌስተኒፍ እስኒፍ ኬነሜ። ");
INSERT INTO gaze_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","ኩኖ፣ ዺግንሳ እዶ ቁልቁሉት ኦል ህንገልፈምኔ፤ እስን አኩመ አን አጀጄት ሬኤ ሰነ ናኖ እዶ ቁልቁሉት ኛቹ ቀብዱ ቱሬ።” ");
INSERT INTO gaze_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","አሮንስ ሙሴዻን አከነ ጄዼ፤ “ኩኖ፣ እሳን ሀርአ ኣርሳሳኒ ከን ጩቡቲፊ ኣርሳሳኒ ከን ጉበሙ ፉለ ዋቀዮ ዱረት ዽኤሰኒሩ፤ ገሩ ወን አከሲ ኩን ነ ቀቀቤረ። ኡቱ አን ኣርሳ ጩቡ ሰነ ሀርአ ኛዼ ጅራዼ ስላ ወን ሱን ፉለ ዋቀዮ ዱረት ንፉዸተመ ቱሬ?” ");
INSERT INTO gaze_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","ሙሴንስ ዮሙ ዋን ከነ ዸገኤት ንገመዴ። ");
INSERT INTO gaze_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","ዋቀዮስ ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“እስራኤሎታን አከነ ጄዻ፦ ‘ብኔንሶተ ለፈረ ጅራተን ሁንደ ኬሳ ከኔን እስን ኛቹ ደንዴሰን እሳን ከናዸ፦ ");
INSERT INTO gaze_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ብኔንሰ ኮቴንሳ ጉቱማን ጉቱት በቀቃ ተኤ ከን አለለ ጉሩ ከምዩ ኛቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘ከኔን አለለ ቆፈ ጉረን ዮካን ኮቴንሳኒ ቆፍት በቀቃ ተኤ ገሩ ኛቹ ህንቀብደን። ጋል ዮ አለለ ጉሬዩ ኮቴ በቀቃ ህንቀቡ፤ እን እስኒፍ ቁልቁሉ ምት። ");
INSERT INTO gaze_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","ኦሶሌን ዮ አለለ ጉርቴዩ ኮቴ በቀቃ ህንቀብዱ፤ እሼን እስኒፍ ቁልቁሉ ምት። ");
INSERT INTO gaze_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","እሌቲን ዮ አለለ ጉርቴዩ ኮቴ በቀቃ ህንቀብዱ፤ እሼን እስኒፍ ቁልቁሉ ምት። ");
INSERT INTO gaze_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","ቦዬን ዮ ኮቴ በቀቃ ቀባቴዩ አለለ ህንጉሩ፤ እን እስኒፍ ቁልቁሉ ምት። ");
INSERT INTO gaze_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","እስን ፎንሳኒ ኛቹ ዮካን ረቀሳኒ ቱቁ ህንቀብደን፤ እሳን እስኒፍ ቁልቁሉ ምት። ");
INSERT INTO gaze_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘ኡመመወን ብሻን ገላኖታፊ ብሻን ለጌኒ ኬሰ ጅራተን ሁንደ ኬሳ ከኔን ቆቾፊ ቆለ ቀበን ከምዩ ኛቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","ገሩ ኡመመወን ገላኖታፊ ለጌን ኬሰ ጅራተን ከኔን ቆቾፊ ቆለ ህንቀብኔ ሁንድ፣ ኡመመወን ብሻን ኬሰ ሙኙቀን ሁንድ ዮካን ከኔን ብሻን ኬሰ ጅራተን ሁንድ እስኒፍ ጡራኦ ሃተአን። ");
INSERT INTO gaze_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","እሳን እስን ዱረት ጡራኦ ዋን ተአኒፍ ፎንሳኒ ህንኛትና፤ ረቅንሳኒስ ጡራኣ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","ወን ብሻን ኬሰ ጅራቱ ከን ቆቾፊ ቆለ ህንቀብኔ ከምዩ እስኒፍ ጡራኣ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘እሳን ኩኔን ስምብሮተ እስን ጅቡ ቀብደኒዸ፤ ህንኛተመን፤ እሳን ጡራኦዸ፦ ርሳ፣ ሩምቸ፣ ሩምቸ ጉራቸ፣ ");
INSERT INTO gaze_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","ጩሉሌ፣ ጩሉሌ ጉራቸ ጎሰ ገራ ገራ፣ ");
INSERT INTO gaze_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","አራጌሰ ጎሰ ገራ ገራ፣ ");
INSERT INTO gaze_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","ጉቺ፣ ኡሩንጉ፣ አላቲ ብሻኒ፣ ጮሮፌ ጎሰ ገራ ገራ፣ ");
INSERT INTO gaze_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","ኡሩንጉ ጥና፣ ዳክዬ፣ ኡሩንጉ ጉዳ፣ ");
INSERT INTO gaze_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","ኡሩንጉ አዲ፣ ኡሩንጉ ገሞጂ፣ አላቲ ረቃ፣ ");
INSERT INTO gaze_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","ሁሞ፣ ሁሞ ጎሰ ከሚዩ፣ ሃዸ ጋዬ፣ ስምብረ ሀልከኒ። ");
INSERT INTO gaze_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘እልቢሶን በርሰን ከኔን ሚለ አፍረኒኑ ዴመን ሁንድ እስኒፍ ጡራኦ ሃተአን። ");
INSERT INTO gaze_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","ተኡስ እልቢሶን በርሰን ከኔን ሚለ አፍረኒኑ ዴመን ኬሳ ቶኮ ቶኮ ኛቹ ንደንዴሱ፤ እሳንስ ወረ እቲን ለፈረ ኡታሉፍ ሚለ ደደቸኡ ቀበኒዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","እሳን ኬሳስ ሀዋንሰ ጎሰ ገራ ገራ፣ ሀዋንሰ መገሪሰ ገራ ገራ፣ ፈርደ ዋቃ ገራ ገራፊ ኮሮጵሰ ገራ ገራ ኛቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","ገሩ እልቢሶተ በርሰን ከኔን ሚለ አፉር ቀበን ብራ ሁንድ እስኒፍ ጡራኦ ሃተአን። ");
INSERT INTO gaze_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘እስን ወንቶተ ከኔኒን ኦፍ ጡሬስቱ፤ ነምን ረቀሳኒ ቱቁ ከምዩ ሀመ ገልገላት ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","ነምን ሬፈሳኒ ቶኮሌ ለፋ ፉዹ ከምዩ ኡፈተሳ ሚጨቹ ቀበ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘ብኔንስ ኮቴ በቀቃ ቀቡ ከን ኮቴንሳ ጉቱማን ጉቱት ገርገር ህንቆደምን ዮካን አለለ ህንጉሬ ከምዩ እስኒፍ ጡራኣዸ፤ ነምን ረቀሳኒ ቱቁ ከምዩስ ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","ብኔንሶተ ሚለ አፉሪን ዴመን ሁንደ ኬሳ ከኔን ፋናን ኤጄተን እስኒፍ ጡራኦዸ፤ ነምን ረቀሳኒ ቱቁ ከምዩስ ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","ነምን ረቀሳኒ ለፋ ፉዹ ከምዩ ኡፈተሳ ሚጨቹ ቀበ፤ እን ሀመ ገልገላት ጡራኣ ተአ። እሳንስ እስኒፍ ጡራኦዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘ኡመመወን ለፈረ ሙኙቀን ኬሳ እሳን ኩኔን እስኒፍ ጡራኦዸ፤ እሳንስ፦ ቱቃ፣ ሀንቱተ፣ ሎጩ ጉርጉዳ ጎሰ ጎሳ፣ ");
INSERT INTO gaze_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","ሎጩ ጭረቻ፣ ናቸ፣ ቀርጮ፣ ቀርጨቦፊ ጋረራዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","ኡመመወን ለፈረ ሙኙቀን ኬሳ እሳን ኩኔን እስኒፍ ጡራኦዸ፤ ነምን ረቀሳኒ ቱቁስ ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","ኡመመወን ሰነ ኬሳ ቶኮ ዮ ዱኤ ምአ ወዪረ ቡኤ፣ ምእ ሱን ፋይዳንሳ ዋን ፌዼዩ ተኡ፣ እን ሙከራ፣ ሁጩራ፣ ጎጋራ ዮካን ኬሻራ ሆጄተሙሌ ምእ ሱን ጡራኣ ተአ፤ ምአ ሰነ ብሻን ኬሰ ቡሳ። እንስ ሀመ ገልገላት ጡራኣ ተኤ ኤርገሲሞ ቁልቁሉ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","እሳን ኬሳ ቶኮ ኦኮቴ ኬሰ ዮ ቡኤ፣ ወን ኦኮቴ ሰነ ኬሰ ጅሩ ሁንድ ጡራኣ ተአ፤ እስንስ ኦኮቴ ሰነ ጨብሱ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","ኛትን ኛተሙ ደንደኡ ከን ገሩ ብሻን ኦኮቴ አከሲ ኬሳ እት ነቀሜ ከምዩ ጡራኣዸ፤ ዹጋቲን ኦኮቴ ሰነ ኬሳ ዹገሙ ደንደኡ ከምዩስ ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","ወን ረቀ ኡመመወን ከና ኬሳ ቶኮዩረ ቡኡ ከምዩ ጡራኣ ተአ፤ ኤሌን ዮካን ኦኮቴን ዋ እት ብልቼሰን ጨብሰሙ ቀበ። እሳን ጡራኦዸ፤ እስንስ አከ ምአ ጡራኣት እሳን እላላ። ");
INSERT INTO gaze_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","ቡርቃን ዮካን ቦል ብሻን እት ኩፈሙሞ ቁልቁሉ ተኤ ቱረ፤ ገሩ ነምን ረቀ ከነ ኬሳ ቶኮሌ ቱቁ ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","ረቅን ቶኮ ሰኚ ፈጫፈሙፍ ጅሩረ ዮ ቡኤ ሰኚን ሱን ቁልቁሉ ተኤ ሀፈ። ");
INSERT INTO gaze_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","ገሩ ሰኚ ሰነረት ብሻን ነቀሜ ረቅን ወዪ ዮ እረ ቡኤ ሰኚን ሱን እስኒፍ ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘ሆሪን አከ እስን ኛተኒፍ እስኒፍ ኤየመሜ ቶኮ ዮ ዱኤ፣ ነምን ረቀሳ ቱቄ ከምዩ ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","ነምን ረቀ ሰነራ ዋ ኛቱ ወያሳ ሚጨቹ ቀበ፤ እን ሀመ ገልገላት ጡራኣን ተአ። ነምን ረቀ ሰነ ለፋ ፉዼ ወያሳ ሚጨቹ ቀበ፤ እንስ ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘ኡመምን ለፈረ ሙኙቁ ከምዩ ጡራኣዸ፤ ኛተሙስ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","ኡመመ ለፈረ ሎኡ ከን ገራዻን ለፈረ ሎኡ ዮካን ሚለ አፉሪን ዮካን ሚለ ሄዱን ዴሙ ከምዩ ህንኛትና፤ እን ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","ኡመመወን ከኔን ኬሳ ቶኮንዩ ኦፍ ህንጡሬስና። እስን አከ ጡራኦ ህንታኔፍ እሳኒን ኦፍ ህንጡሬስና። ");
INSERT INTO gaze_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","አን ዋቀዮ ዋቀኬሰኒዸ፤ ዋን አን ቁልቁሉ ተኤፍ እስንስ ኦፍ ቁልቁሌሳቲ ቁልቁሎተ ተኣ። ኡመመ ለፈረ ሙኙቁ ከሚንዩ ኦፍ ህንጡሬስና። ");
INSERT INTO gaze_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","አን ዋቀዮ ከን ዋቀኬሰን ተኡፍ ጄዼ ብየ ግብጢቲ እስን ባሴዸ፤ ከናፉ አን ቁልቁሉዻቲ እስንስ ቁልቁሉ ተኣ። ");
INSERT INTO gaze_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘ሴር ዋኤ ሆሪ፣ ስምብሮ፣ ሉቡ ቀቤዪ ብሻን ኬሰ ሙኙቀን ሁንዳፊ ኡመመ ለፈረ ሙኙቁ ሁንዳ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","እስን ዋን ጡራኣፊ ዋን ቁልቁሉ፣ ኡመመ ኛተሙፊ ከን ህንኛተምኔ አዳን ባፍተኒ ቤኩ ቀብዱ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“እስራኤሎታን አከነ ጄዽ፦ ‘ዱበርቲን ኡልፎፍቴ እልመ ዴሴ ጅርቱ አከ ሴራት አኩመ ዬሮ ጡሪ ኦፍራ ቀብዱ ሰናት ቡልቲ ቶርባፍ ጡሮፍቱ ታት። ");
INSERT INTO gaze_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","እልም ሱንስ ጉያ ሰዴተፋት ዸግነ ሃቀበቱ። ");
INSERT INTO gaze_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","ኤርገሲስ ዱበርቲን ሱን ዺገሼራ ቁልቁሌፈሙፍ ቡልቲ ሶዶሚ ሰዲ ኤገቹ ቀብድ። እሼ ሀመ ዬሮን ቁልቁሌፈሙሼ ራወተሙት ዋን ቁልቁሉ ህንቱቅን ዮካን ገረ እዶ ቁልቁሉ ህንዸቅን። ");
INSERT INTO gaze_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","እሼን ዮ ዱርበ ዴሴ ጅራቴ አኩመ ዬሮ ጡሪ ኦፍራ ቀብዱ ሰናት ቶርበን ለማፍ ጡሮፍቱ ታት፤ ኤርገሲሞ ዺገሼራ ቁልቁሌፈሙፍ ቡልቲ ጃተሚ ጀአ ኤገቹ ቀብድ። ");
INSERT INTO gaze_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘እሼን ጋፈ ዬሮን ቁልቁሌፈሙሼ ከን ሰበቢ እልማ ዮካን እንተላ ራወተሙት፣ ጦባላ ሆላ ከን ወጋ ቶኮ ኣርሳ ጉበሙፍ፣ ጉጌ ሶኬ ቶኮ ዮካን ጉጌ ቶኮ ኣርሳ ጩቡቲፍ በልበለ ዱንካነ ወል ገኢ ዱረት ገረ ሉባ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","እንስ እሼዻፍ አራረ ቡሱፍ ጄዼ ዋን ከነ ፉለ ዋቀዮ ዱረት ኣርሳ ዽኤሰ፤ እሼንስ ኤርገሲ አከ ሴራት ዸንገለኣ ዺገሼራ ቁልቁሎፍት። “ ‘ሴር ዱበርቲ እልመ ዮካን ዱርበ ዴሱ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","እሼን ዮ ጦባላ ሆላ ፍዱ ህንደንዴኜ፣ ጉጌ ለመ ዮካን ጉጌ ሶሶኬ ለመ፣ ቶኮ ኣርሳ ጉበሙፍ ካንሞ ኣርሳ ጩቡቲፍ ሃፍዱ። ሃለ ከናን ሉብች እሼዻፍ አራረ ቡሰ፤ እሼንስ ንቁልቁሎፍት።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","ዋቀዮስ ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“ነምን ዮ ጎጋ ዸግነሳራ ኢቶ ዮካን ፍኒሰ ዮካን ባሮሌ ቀባቴ ወን ሱን ጎጋ ዸግነሳረት ገረ ለምጢት ጌደረሜ፣ ነምች ሱን ገረ አሮን ሉብቻት ዮካን እልማንሳ ሉቦተ ኬሳ ገረ እሰ ቶኮት ሃጌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","ሉብን ሱን መዳ ጎጋ ዸግነ ነምቻረ ጅሩ ሃቆሩ፤ ዮ ርፌንስ መዳ ሰነረ ጅሩ አዳቴ መዳን ሱን ጎጋ ኬሰ ደርቤ ፎንት ገድ ሴኔ፣ ዹኩብን ሱን ዹኩበ ለምጢት። ሉብችስ ኤርገ እሰ ቆሬ ቦዴ አከ እን አከ ሴራት ጡራኣ ተኤ ሃለብሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","ዮ ባሮሌን ጎጋ ነምቻረ ጅሩ አዳቴ ገሩ ጎጋ ኬሰ ደርቤ ፎንት ገድ ህንሴንን፣ ዮ ርፌንስ መዳ ሰነረ ጅሩስ ህንአዳትን፣ ሉብች ነምቸ መዳኤ ሰነ ቡልቲ ቶርበ ኮጳት ባሴ ሃቱርሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","ቡልቲ ቶርበፋትሞ ሉብች እሰ ሃቆሩ፤ ሉብን ዮ አከ መዳን ሱን ህንጌደረምኒፊ አከ እን ጎጋ ነምቻረ ህንፈፈጨእን አርጌ አመስ ቡልቲ ቶርበ ኮጳት ባሴ እሰ ሃቱርሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","አመሌ ሉብች ቡልቲ ቶርበፋት ነምቸ ሃቆሩ፤ ኩኖ፣ ዮ መዳን ሱን ቆሬ ጎጋረ ህንፈፈጨእን፣ ሉብች አከ ነምች ቁልቁሉ ተኤ ሃለብሱ፤ ወን ሱን ጭቶዸ። ነምች ወያሳ ሃሚጨቱ፤ እን ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","ገሩ እን ኤርገ ቁልቁሉ ተኡንሳ አከ ለብሰሙፍ ሉበት ኦፍ አርግሲሴ ቦዴ ዮ ጭቶን ሱን ጎጋሳረ ፈፈጨኤ እን አመሌ ሉበት ኦፍ አርግሲሱ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","ሉብችስ እሰ ሃቆሩ፤ ዮ ጭቶን ሱን ጎጋረ ፈፈጨኤ ጅራቴ ሉብች አከ እን ጡራኣ ተኤ ሃለብሱ፤ ወን ኩን ለምጢዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“ነምን ዮ ለምጢ ቀባቴ እን ሉበት ፍደሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","ሉብች እሰ ሃቆሩ፤ ኩኖ ዮ ኢት አዲን ከን ርፌንሰ አዴሴ ጎጋረ ጅራቴፊ ፎን ኢተ ሰና ዲመቴ ሙልአቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","ወን ሱን ዹኩበ ጎጋ ከን ህንፈይኔዸ፤ ሉብችስ አከ ነምች ጡራኣ ተኤ ሃለብሱ። ዋን እን ዱራኑ ጡራኣ ተኤፍ ሉብች ኮጳት ባሴ እሰ ቱርሱን በርባችሳ ምት። ");
INSERT INTO gaze_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“ዹኩብን ሱን ሀመ ሉብን አርጉ ደንደኡት ጎጋሳረ ዮ ፈፈጨኤ ጎጋ ነምቸ መዳኤ ሰና መታዻ ሀመ ሚላት ሀጉጌ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","ሉብች እሰ ሃቆሩ፤ ኩኖ ዮ ዹኩብን ሱን ጉቱማን ጉቱት ዸግነ ነምቻ ወል ገኤ እን አከ ነምች ቁልቁሉ ተኤ ሃለብሱ። ዋን ዸግንሳ ጉቱን አዳቴፍ ነምች ሱን ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","እን ገሩ ዬሮ ኢተ ፎንሳ ኬሳን ዲመቴ ሙልአቱ ቀባቱ ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","ሉብች ዬሮ ፎን ዲመቴ ሙልአቱ አርጉት አከ ነምች ሱን ጡራኣ ተኤ ሃለብሱ፤ ፎን ዲመቴ ጡራኣዸ፤ ነምችስ ለምጢ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","ዮካን ዮ ፎን ዲማን ጌደረሜ አዳቴ ነምች ሉበት ኦፍ አርግሲሱ ሃዸቁ። ");
INSERT INTO gaze_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","ሉብንስ እሰ ሃቆሩ፤ ዮ መዳን ሱን አዳቴ ሉብች አከ ነምች መዳኤ ሱን ቁልቁሉ ተኤ ሃለብሱ፤ ነምችስ ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“ነምን ጎጋሳራ ዹላ ዮ ቀባቴ ዹላን ሱን ፈዬ ጅራቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","ዮ እዶ ዹላን ቱሬ ሰነት ኢት አዲን ዮካን ባሮሌን ዲማን አዲን ሙልአቴ እን ሉበት ኦፍ ሃአርግሲሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","ሉብንስ እሰ ሃቆሩ፤ ኩኖ ዮ ወን ሱን ዋን ጎጋ ኬሰ ደርቤ ፎን ሴኔ ፈካቴ ርፌንስ እሰ ኬሳስ አዳቴ ሉብች አከ እን ጡራኣ ተኤ ሃለብሱ። ወን ኩን ዹኩበ ለምጢ እዶ ዹላን ቱሬት በኤዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","ገሩ ዮሙ ሉብን ባሮሌ ሰነ ቆሩት፣ ኩኖ ዮ ርፌንስ አዲንረ ህንጅራትኒፊ ዮ ባሮሌን ሱን ኡቱ ጎጋ ደርቤ ፎን ህንሴንን ቆሬ ጅራቴ ሉብን ኮጳት ባሴ ቡልቲ ቶርበ እሰ ሃቱርሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","ዮ ባሮሌን ሱን ጎጋረ ፈፈጨኤ፣ ሉብች አከ ነምን ሱን ጡራኣ ተኤ ሃለብሱ፤ ኩን ዹኩበ ነመት ደርቡዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","ገሩ ባሮሌን ሱን ዮ ህንጌደረምኒፊ ዮ ህንፈፈጨእን፣ እን ጎዳንሰ ዹላ ሰናት፤ ሉብንስ አከ ነምች ቁልቁሉ ተኤ ሃለብሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“ዮ ነምን ጎጋሳራ ጉባ ቀባቴ ፎን ዲማ እዶ ጉበማ ሰናረት ባሮሌን ዲማን አዲን ዮካን አዲን ሙልአቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","ሉብን ባሮሌ ሰነ ሃቆሩ፤ ኩኖ ዮ ርፌንስ አችረ ጅሩ አዳቴ ባሮሌን ሱንስ ጎጋ ኬሰ ደርቤ ፎን ሴኔ ወን ኩን ለምጢ እዶ ጉበቴ ሰነረት በኡዸ። ሉብች አከ ነምን ሱን ጡራኣ ተኤ ሃለብሱ፤ ዹኩብን ኩን ዹኩበ ለምጢት። ");
INSERT INTO gaze_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","ገሩ ዮ ሉብን እዶ ጉበቴ ሰነ ቆሬ ርፌንስ አዲን ባሮሌ ሰነረ ህንጅራትኒፊ ዮ ባሮሌን ሱን ኡቱ ጎጋ ኬሰ ደርቤ ፎን ህንሴንን ቆሬ ጅራቴ ሉብች ነምቸ ሰነ ኮጳት ባሴ ቡልቲ ቶርበ ሃቱርሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","ጉያ ቶርበፋት ሉብች እሰ ሃቆሩ፤ ዮ ባሮሌን ሱን ጎጋረ ፈፈጨኤ ጅራቴ ሉብን ሱን አከ ነምች ጡራኣ ተኤ ሃለብሱ፤ ዹኩብን ኩን ዹኩበ ለምጢት። ");
INSERT INTO gaze_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","ተኡስ ዮ ባሮሌን ሱን ህንጌደረምኒፊ ኡቱ ጎጋረ ህንፈፈጨእን በዴ ወን ኩን ኢቶ ጉባ ሰነ ኬሰ በኤዸ። ሉብች አከ ነምች ቁልቁሉ ተኤ ሃለብሱ፤ ወን ኩን ጎዳንሰ ጉባ ሰናት። ");
INSERT INTO gaze_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“ዮ ዺር ዮካን ዱበርቲን መታራ ዮካን አሬደራ መዳ ቀባተን፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","ሉብን መዳ ሰነ ሃቆሩ፤ ኩኖ ዮ መዳን ሱን ጎጋ ኬሰ ደርቤ ፎን ሴኔ ርፌንስ አችረ ጅሩ ኬሎ ፈካቴ ቀቀልአቴ፣ ሉብች አከ ነምች ሱን ጡራኣ ተኤ ሃለብሱ፤ ኩን ሆቅጦ መታ ዮካን አሬዳ ከን ነመት ደርቡዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","ገሩ ዬሮ ሉብን መዳ አከና ቆሩት ኩኖ ዮ መዳን ሱን ዋን ጎጋ ደርቤ ፎን ሴኔ ህንፈካትኒፊ ዮ ርፌንስ ጉራች ቶኮዩ መዳ ሰነረ ህንጅራትን ሉብን ሱን ነምቸ ሆቅጦን ቀቤ ሰነ ኮጳት ባሴ ቡልቲ ቶርበ ሃቱርሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","ጉያ ቶርበፋት ሉብን መዳ ሰነ ሃቆሩ፤ ኩኖ ዮ ሆቅጦን ሱን ህንፈፈጨእን፣ ዮ ርፌንስ ኬሎን አችረ ህንጅራትኒፊ ሆቅጦን ሱን ዋን ጎጋ ኬሰ ደርቤ ፎን ሴኔ ህንፈካትን፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","ነምች ሱን እዶ መዳኤ ሰነ ቆፈ ዺሴ መታሳ ሃሃደቱ፤ ሉብን ሱንስ አመስ ነምቸ ሰነ ኮጳት ባሴ ቡልቲ ቶርበ ሃቱርሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","ጉያ ቶርበፋትስ ሉብን ሱን ሆቅጦ ሰነ ሃቆሩ፤ ኩኖ ዮ ሆቅጦን ሱን ጎጋረ ህንፈፈጨእኒፊ ዋን ጎጋ ኬሰ ደርቤ ፎን ሴኔ ህንፈካትን ሉብች አከ ነምች ሱን ቁልቁሉ ተኤ ሃለብሱ፤ ነምች ወያሳ ሃሚጨቱ፤ እንስ ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","ገሩ ኤርገ አከ ነምች ቁልቁሉ ተኤ ለብሰሜ ቦዴ ዮ ሆቅጦን ሱን ጎጋረ ፈፈጨኤ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","ሉብን እሰ ሃቆሩ፤ ኩኖ ዮ ሆቅጦን ሱን ጎጋረ ፈፈጨኤ ጅራቴ ሉብች ርፌንሰ ኬሎ ሰከተኡ ህንቀቡ፤ ነምች ሱን ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","ገሩ አከ ሁበትና ሉብቻት ሆቅጦን ሱን ጌደረሙ ባቴ ርፌንስ ጉራች እረት ብቅላን ሆቅጦን ሱን ፈዬረ፤ ነምችስ ቁልቁሉዸ፤ ሉብንስ አከ እን ቁልቁሉ ተኤ ሃለብሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“ዮሙ ዺር ዮካን ዱበርቲን ጎጋ ዸግነሳራ ባሮሌ ቀባተንት፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","ሉብን እሳን ሃቆሩ፤ ኩኖ ዮ ባሮሌን ሱን አዲ ዳለቸ ተኤ ኩን ጭቶ ጎጋረት በኤ ከን ነመ ህንሚኔዸ፤ ነምችስ ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“ነምን ዮ ርፌንስ መታሳ ዹሜ ሞላኤ እን ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","ዮ ርፌንስ መታሳ ፉለ ዱራን እራ ዹሜ ሞላኤስ እን ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","ገሩ እን ዮ ሞሉ መታሳራ ዮካን ሞሉ አደሳራ መዳ አዲ ዲመቱ ቀባቴ ወን ኩን ለምጢ ሞሉ መታሳ ዮካን ሞሉ አደሳ ኬሳ በኡዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","ሉብን እሰ ሃቆሩ፤ ኩኖ ዮ መዳን ኢተኤ ከን መታሳራ ዮካን አደሳራ ሱን አኩመ ለምጢ ጎጋረት በኤ አዲ ዲመቱ ተኤ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","ነምች ዹኩብሰታፊ ጡራኣዸ። ሰበቢ መዳ መታ ነምቻረ ጅሩ ሰናቲፍስ አከ ነምች ጡራኣ ተኤ ሉብን ሱን ሃለብሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“ነምን ለምጢ አከሲ ቀቡ ኡፈተ ተተርሰኣ ሃኡፈቱ፤ ርፌንሰ መታሳት ዋ ህንመረትን፤ አፋንሳስ ሀጉገቴ፣ ‘አን ጡራኣዸ! አን ጡራኣዸ!’ ጄዼ ሃእዩ። ");
INSERT INTO gaze_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","እን ሀመ ዹኩብን ሱን እረ ጅሩት ጡራኣዸ፤ ኮጳሳ ሃጅራቱ፤ ቁበተ ኬሳስ በኤ አለ ሃጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“ዮ ኡፈትን ሱፊራ ዮካን ቁንጬ ተልባራ ሆጄተሜ ከምዩ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","ኡፈትን ቁንጬ ተልባራ ዮካን ሱፊራ ዸአሜ ዮካን ወል ኬሰ ሎፈሜ ሆጄተሜ ከምዩ፣ ጎጋን ዮካን ወን ጎጋራ ሆጄተሜ ከምዩ ለምጢ ቀባቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","ዮ ዹኩብን ኡፈተረ ዮካን ጎጋረ ዮካን ኡፈተ ዸአሜረ ዮካን ወል ኬሰ ሎፈሜ ሆጄተሜረ ዮካን ምአ ጎጋረ ጅሩ ሱን መገሪሰ ተኤ ዮካን ዲመቴ ወን ኩን ዋን ለምጢ ተኤፍ ሉበት ሃአርግሲፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","ሉብንስ ለምጢ ሰነ ቆሬ ምአ ዹኩባን ፋለሜ ሰነ ኮጳት ባሴ ቡልቲ ቶርበ ሃቱርሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","ጉያ ቶርበፋት ሉብች ለምጢ ሰነ ሃቆሩ፤ ዮ ለምጢን ሱን ኡፈተረ ዮካን ወያ ዸአሜረ ዮካን ኡፈተ ወል ኬሰ ሎፈሜ ሆጄተሜረ ዮካን ጎጋ ዋን ከሚፍዩ ፈየዱረ ፈፈጨኤ ወን ኩን ለምጢ ሀማዸ፤ ምእ ሱንስ ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","ሰበቢ ለምጢን ሱን ሀማ ተኤፍ ሉብች ኡፈተ ዮካን ወያ ሱፊራ ዮካን ቁንጬ ተልባራ ሆጄተሜ ዮካን ወል ኬሰ ሎፈሜ ሆጄተሜ ዮካን ምአ ጎጋራ ሆጄተሜ ከን ዹኩበ ሰናን ፋለሜ ከምዩ ሃጉቡ፤ ምእ ሱንስ ጉበሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“ገሩ ዬሮ ሉብን ለምጢ ሰነ ቆሩት ኩኖ ዮ ለምጢን ሱን ኡፈተረ ዮካን ወያ ዸአሜረ ዮካን ወል ኬሰ ሎፈሜ ሆጄተሜረ ዮካን ምአ ጎጋራ ሆጄተሜረ ፈፈጨኡ ባቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","ሉብች አከ ምእ ለምጢዻን ፋለሜ ሱን ሚጨሙ ሃአጀጁ። ኤርገሲሞ ምአ ሰነ ኮጳት ባሴ አመስ ቡልቲ ቶርበ ሃቱርሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","ኤርገ ምእ ለምጢዻን ፋለሜ ሱን ሚጨሜ ቦዴ ሉብች ምአ ሰነ ሃቆሩ፤ ለምጢን ሱን ዮ ፈፈጨኡ ባቴሌ ብፍትሳ ጌደረሙ ባናን ኡፈትን ሱን ጡራኣዸ። ዮ ለምጢን ሱን ገመ ቶኮን ዮካን ገመ ካኒን ምአ ሰነ ፋሌ ጅራቴ፣ ምእ ሱን እብዳን ሃጉበሙ። ");
INSERT INTO gaze_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","ኤርገ ምእ ሱን ሚጨሜ ቦዴ ዬሮ ሉብን ቆሩት ዮ ለምጢን ሱን በዴ ጅራቴ ሉብች እዶ ለምጢዻን ፋለሜ ሰነ ኡፈተ ዮካን ጎጋ ዮካን ወያ ዸአሜ ዮካን ወል ኬሰ ሎፈሜ ሆጄተሜራ ሃተርሳሱ። ");
INSERT INTO gaze_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","ገሩ ዮ ለምጢን ሱን ዴብኤ ኡፈተረት ዮካን ወያ ዸአሜረት ዮካን ወል ኬሰ ሎፈሜ ሆጄተሜረት ዮካን ምአ ጎጋራ ሆጄተሜ ከምዩረት አርገሜ፣ ለምጢን ሱን ፈፈጨኣ ጅረ፤ ወን ለምጢ ቀቡ እብዳን ሃጉበሙ። ");
INSERT INTO gaze_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","ኡፈትን ዮካን ወያን ዸአሜ ዮካን ወል ኬሰ ሎፈሜ ሆጄተሜ ዮካን ምእ ጎጋራ ሆጄተሜ ከን ሚጨሜ ለምጢንራ በዴ ከምዩ አመስ ሃሚጨሙ፤ እንስ ንቁልቁላአ።” ");
INSERT INTO gaze_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","ወን ኩን ሴረ አከ ኡፈትን ሱፊራ ዮካን ቁንጬ ተልባራ ሆጄተሜ፣ ወያን ዸአሜ ዮካን ወል ኬሰ ሎፈሜ ሆጄተሜ ዮካን ምእ ጎጋራ ሆጄተሜ ለምጢዻን ፋለሜ ከምዩ ጡራኣ ተኤፊ አከ ህንተእን ለብሱፍ ኬነሜዸ። ");
INSERT INTO gaze_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“ኩን ሴረ ነመ ለምጢ ቀቡ ቶኮፍ ጉያ እን እት ቁልቁሌፈሙፍ ኬነሜዸ፤ ነምች ሉበት ሃፍደሙ። ");
INSERT INTO gaze_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","ሉብን ሱን እዶ ቁበታ ኬሳ ገድ በኤ ነምቸ ሃቆሩ። ኩኖ፣ ዮ ነምች ለምጢ ቀቡ ሱን ፈዬ ጅራቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","ሉብች አከ ሰበቢ ነምቸ ቁልቁሌፈሙ ሰናቲፍ ስምብሮትን ሉቡ ቀበን ቁልቁሉን ለማፊ ሙክን ብርብርሳ፣ ክሪን ብልዲማፊ ሂሶጲን ፍደመን ሃአጀጁ። ");
INSERT INTO gaze_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","ሉብን ሱንስ ኤርገሲ አከ ስምብሮተ ሰነ ኬሳ እሼን ቶኮ ብሻን ያኡ ከን ኦኮቴ ኬሰ ጅሩረት ቀለምቱ ሃአጀጁ። ");
INSERT INTO gaze_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","እንስ ስምብሮ ሉቡ ቀብዱ ሰነ ፉዼ ሙከ ብርብርሳ፣ ክሪ ብልዲማፊ ሂሶጲ ወጅን ዺገ ስምብሮ ብሻን ያኡረት ቀለምቴ ሰና ኬሰ ሃጩጱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","ሉብች ነምቸ ለምጢራ ቁልቁሌፈሙ ሰነት ዬሮ ቶርበ ፈፈጫሴ አከ እን ቁልቁሉ ተኤ ሃለብሱ፤ ኤርገሲ ስምብሮ ሉቡ ቀብዱ ሰነ ድሬት ገድ ሃዺሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“ነምች ቁልቁሌፈሙ ሱን ኡፈተሳ ሚጨቹ፣ ርፌንሰሳ ሁንደ ሃደቹፊ ዸግነሳ ብሻኒን ዽቀቹ ቀበ፤ አከሲን እን አከ ሴራት ቁልቁሉ ተአ። ኤርገሲ እዶ ቁበታት ኦል ገሉ ደንደአ፤ ገሩ ቡልቲ ቶርበ ዱንካነሳቲን አለ ቱሩ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","ጉያ ቶርበፋትስ ርፌንሰሳ ሁንደ ሃደቹ ቀበ፤ መታሳ፣ አሬደሳ፣ ኛረሳቲፊ ርፌንሰሳ ብራ ሃሃደቱ። ኡፈተሳስ ሚጨቴ ዸግነሳ ብሻኒን ዽቀቹ ቀበ፤ እንስ ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“ጉያ ሰዴተፋትስ ነምች ሱን ኮርቤዪ ሆላ ከኔን ህርእነ ህንቀብኔ ለማፊ ሆላ ዸላ ወጋ ቶኮ ከን ህርእነ ህንቀብኔ ቶኮ፣ ዳኩ ቡላኣ ኢፊ ቶኮ ከን ዘይቲዻን ሱኩመሜራ ሀርከ ኩዸን ኬሳ ሀርከ ሰዲ ከን ኬና ምዻኒቲፍ ተኡፊ ዘይቲ ሎጊ ቶኮ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","ሉብን አከ ነምች ቁልቁሉ ተኤ ለብሱ ሱን ነምቸ ቁልቁሌፈሙ ሰናፊ ኬናወንሳ በልበለ ዱንካነ ወል ገኢረት ፉለ ዋቀዮ ዱረት ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“ኤርገሲስ ሉብች ኮርቤዪ ሆላ ሰነ ኬሳ ቶኮ ፉዼ ኣርሳ የካ ጎዼ ሎጊ ዘይቲ ቶኮ ወጅን ሃዽኤሱ፤ እንስ ኣርሳ ሶቾፈሙ ጎዼ ፉለ ዋቀዮ ዱረት ሃሶቾሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","ጦባላ ሆላ ሰነስ እዶ ኣርሳን ጩቡቲፊ ኣርሳን ጉበሙ እት ቀለመንት ሃቀሉ። አኩመ ኣርሳ ጩቡ ሰነ ኣርሳን የካስ ከን ሉባት፤ ኣርሳን ኩን ዋን ሁንደ ጫላ ቁልቁሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","ሉብችስ ዺገ ኣርሳ የካ ሰነራ ፉዼ ፊጤ ጉረ ምርጋ ነምቸ ቁልቁሌፈሙ ሰና፣ ቁበ አቡዱ ሀርከሳ ምርጋቲፊ ቁበ አቡዱ ሚለሳ ምርጋ ሃድቡ። ");
INSERT INTO gaze_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","ሉብን ሱን ዘይቲ ሎጊ ሰነራ ፉዼ በሩ ሀርከሳ ብታት ሃነቁ፤ ");
INSERT INTO gaze_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","ቁበ ሀርከሳ ምርጋስ ዘይቲ በሩ ሀርከሳረ ጅሩ ኬሰ ጩጴ ቁበሳቲን ዬሮ ቶርበ ፉለ ዋቀዮ ዱረት ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","ሉብን ሱን ዘይቲ በሩሳረት ሀፌራ ፉዼ ፊጤ ጉረ ምርጋ ነምቸ ቁልቁሌፈሙ ቀቡ ሰና፣ ቁበ አቡዱ ሀርከሳ ምርጋቲፊ ቁበ አቡዱ ሚለሳ ምርጋ፣ ዺገ ኣርሳ የካ ሰነረት ደበሌ ሃድቡ። ");
INSERT INTO gaze_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","ሉብች ዘይቲ በሩ ሀርከሳረት ሀፌሞ መታ ነምቸ ቁልቁሌፈሙ ሰናት ነቄ ፉለ ዋቀዮ ዱረት አራረ ሃቡሱፍ። ");
INSERT INTO gaze_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“ኤርገሲስ ሉብች ኣርሳ ጩቡ ዽኤሴ ነምቸ ጡራኡማ ኦፊራ ቁልቁሌፈሙ ሰናፍ አራረ ሃቡሱ። ሰነ ቦዴ ሉብን ሱን ኣርሳ ጉበሙ ሃቀሉ፤ ");
INSERT INTO gaze_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","ከነስ ኬና ምዻኒ ወጅን እዶ ኣርሳረት ዽኤሴ አራረ እሳፍ ሃቡሱ፤ ነምችስ ቁልቁሉ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“ተኡስ ነምች ሱን ዮ ህዬሰ ተኤ ዋን ከነ ዽኤሱ ህንደንዴኜ፣ አከ ሶቾፈሜ አራር እሳፍ ቡፈሙፍ እን ጦባላ ሆላ ቶኮ ኣርሳ የካ ጎዼ ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜ ከን ኬና ምዻኒቲፍ ተኡ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ዘይቲ ሎጊ ቶኮ ወጅን ሃፍዱ፤ ");
INSERT INTO gaze_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","አከሱመስ ዋን ፍዱ ደንደኡ ጄቹንስ ጉጌ ለመ ዮካን ጉጌ ሶሶኬ ለመ፣ ቶኮ ኣርሳ ጩቡቲፍ ካንሞ ኣርሳ ጉበሙፍ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“ጉያ ሰዴተፋት እን ቁልቁላኡማሳቲፍ በልበለ ዱንካነ ወል ገኢረት ፉለ ዋቀዮ ዱረት ዋን ከነ ሉበት ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","ሉብን ሱንስ ጦባላ ሆላ ኣርሳ የካ ሰነ ዘይቲ ሎጊ ቶኮ ወጅን ፉዼ ኣርሳ ሶቾፈሙ ጎዼ ፉለ ዋቀዮ ዱረት ሃሶቾሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","ጦባላ ሆላ ሰነስ ኣርሳ የካቲፍ ቀሌ ዺገሳራ ፉዼ ፊጤ ጉረ ምርጋ ነምቸ ቁልቁሌፈሙ ሰና፣ ቁበ አቡዱ ሀርከሳ ምርጋቲፊ ቁበ አቡዱ ሚለሳ ምርጋ ሃድቡ። ");
INSERT INTO gaze_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","ሉብችስ ዘይቲ ሰነራ ፉዼ በሩ ሀርከሳ ብታረት ሃነቁ፤ ");
INSERT INTO gaze_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","ቁበ ሀርከሳ ምርጋቲንስ ዘይቲ በሩሳረ ጅሩ ሰነራ ዬሮ ቶርበ ፉለ ዋቀዮ ዱረት ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","ዘይቲ በሩሳረ ጅሩራ ፉዼ እዱመ ዺገ ኣርሳ የካ እቲን ቱቄ ሰነ ጄቹንስ ፊጤ ጉረ ነምቸ ቁልቁሌፈሙ ሰና ምርጋ፣ ቁበ አቡዱ ሀርከሳ ምርጋቲፊ ቁበ አቡዱ ሚለሳ ምርጋ ሃድቡ። ");
INSERT INTO gaze_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","ሉብችስ ፉለ ዋቀዮ ዱረት አራረ እሳፍ ቡሱፍ ዘይቲ በሩሳረት ሀፌ ሰነ መታ ነምቸ ቁልቁሌፈሙ ሰናረት ሃነቁ። ");
INSERT INTO gaze_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","ሉብን ሱንስ ጉጌወን ዮካን ጉጌ ሶሶኬ ነምች ዽኤሱ ደንደኡ ሃዽኤሱ፤ ");
INSERT INTO gaze_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","እሳን ከኔን ኬሳስ ቶኮ ኣርሳ ጩቡቲፍ፣ ካንሞ ኣርሳ ጉበሙፍ፣ ኬና ምዻኒ ወጅን ሃዽኤሱ። ሃለ ከናንስ ሉብች ነምቸ ቁልቁሌፈሙ ሰናፍ ፉለ ዋቀዮ ዱረት አራረ ንቡሰ።” ");
INSERT INTO gaze_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","ኩን ሴረ ነመ ለምጢ ቀባቴ ዋን እቲን ቁልቁሌፈሙ ባሱ ህንደንዴኜፍ ኬነሜዸ። ");
INSERT INTO gaze_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","ዋቀዮስ ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“ዮሙ እስን ብየ ከነኣን ከን አን አከ ዻላት እስኒፍ ኬኑ ሰነ ሴንተኒ አንስ መነ ብየ ሰና ኬሳ ቶኮት ዹኩበ ለምጢ ፈጫሱት፣ ");
INSERT INTO gaze_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","አባን መነ ሰና ዴሜ፣ ‘አን መነኮ ኬሰት ዋን ለምጢ ፈካቱ ቶኮ አርጌረ’ ጄዼ ሉበት ሃህሙ። ");
INSERT INTO gaze_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","ሉብችስ አከ ወን መነ ሰነ ኬሰ ጅሩ ቶኮዩ ጡራኣዸ ጄዸሜ ህንለብሰምኔፍ ኡቱ ለምጢ ሰነ ቆሩፍ ኦል ህንሴንን ዱረ አከ መነ ሰነ ኬሳ ምእ ገድ ባፈሙ ሃአጀጁ። ኤርገሲ ሉብች ኦል ሴኔ መንቸ ሃቆሩ። ");
INSERT INTO gaze_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","እንስ ለምጢ ኬኘን መናረ ጅሩ ሃቆሩ፤ ዮ ወን ሱን ዾቀ መገሪሰ ዮካን ዲመቱ ቀባቴ ኬኘን መና ኬሰ ገድ ሴኔ፣ ");
INSERT INTO gaze_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","ሉብች መነ ሰነ ኬሳ በልበላን ገድ በኤ ቡልቲ ቶርባፍ መነ ሰነ ሃጩፉ። ");
INSERT INTO gaze_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","ጉያ ቶርበፋት ሉብች መነ ሰነ ቆሩፍ ሃዴብኡ። ኩኖ ዮ ለምጢን ሱን ኬኘን መናረት በበልአቴ ጅራቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","ሉብች አከ ዸጋወን ፋለመን አች ኬሳ ባፈመኒ ለፈ ጡራኣ መጋላን አለ ጅሩት ገተመን ሃአጀጁ። ");
INSERT INTO gaze_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","አከ ኬኘን መነ ሰና ከራ ኬሳቲን ጉቱማት ሶቀሜ ወን እራ ሆቀሜ ሱንስ ለፈ ጡራኣ መጋላን አለ ጅሩት ገድ ገተሙ ሃጎዹ። ");
INSERT INTO gaze_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","እዶ ዸጋወን ሱን ሆቀመኒ በአን ሰነስ ዸጋወን ሃራ ፍደኒ እዶ ሃቡሰን፤ ዾቄ ሃራዻንስ መንቸ ሃመረገን። ");
INSERT INTO gaze_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“ዮ ለምጢን ሱን ኤርገ ዸጋወን በአኒ መንች ሆቀሜ መረገሜ ቦዴ ዴብኤ መነ ኬሰት ሙልአቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","ሉብች ዸቄ ሃቆሩ፤ ለምጢን ሱን ኩኖ ዮ መነ ኬሰ በበልአቴ ጅራቴ፣ ኩን ለምጢ ሀማዸ፤ መንችስ ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","መን ሱን ሃዲገሙ፤ ዸጋንሳ፣ ሙክንሳ አከሱመስ መረጊንሳ ሁንድኑ ለፈ ጡራኣ መጋላን አለ ጅሩት ሃገተሙ። ");
INSERT INTO gaze_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“ነምን ዮ ኡቱ መንች ጩፈሜ ጅሩ ኦል ሴኔ፣ ነምን ሱን ሀመ ገልገላት ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","ነምን መነ ሰነ ሴኔ ረፌ ዮካን ኬሰት ዋ ኛቴ ኡፈተሳ ሃሚጨቱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“ገሩ ዮ ሉብን ለምጢ ሰነ ቆሩዻፍ ዹፌ ኤርገ መንች መረገሜ ቦዴ ለምጢን ሱን በበልአቹ ባቴ ዋን ለምጢን ሱን በዴፍ ሉብን ሱን አከ መን ሱን ቁልቁላኤ ሃለብሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","እንስ መንቸ ቁልቁሌሱፍ ስምብሮ ለመ፣ ሙከ ብርብርሳ፣ ክሪ ብልዲማፊ ሂሶጲ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","እንስ ስምብሮ ሰነ ኬሳ ቶኮ ብሻን ያኡ ከን ኦኮቴ ኬሰ ጅሩረት ሃቀሉ። ");
INSERT INTO gaze_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","ኤርገሲስ ብርብርሳ፣ ሂሶጲ፣ ክሪ ብልዲማፊ ስምብሮ ሉቡ ቀብዱ ሰነ ፉዼ ዺገ ስምብሮ ቀለምቴፊ ብሻን ያኡ ኬሰ ጩጴ ዬሮ ቶርበ መነ ሰነት ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","እንስ ዺገ ስምብሮቲን፣ ብሻን ያኡን፣ ስምብሮ ጅርቱን፣ ብርብርሳን፣ ሂሶጲፊ ክሪ ብልዲማዻን መንቸ ሃቁልቁሌሱ። ");
INSERT INTO gaze_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","ስምብሮ ጅርቱሞ መጋላን አለት ባሴ ድሬት ገድ ሃዺሱ። ሃለ ከናንስ መንቻፍ አራረ ቡሰ፤ መንችስ ንቁልቁላአ።” ");
INSERT INTO gaze_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","ኩን ሴረ ዹኩበ ለምጢቲፊ ሆቅጦዻፍ፣ ");
INSERT INTO gaze_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","ለምጢ ወያረት ዮካን መነ ኬሰት ሙልአቱፍ፣ ");
INSERT INTO gaze_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ኢቶዻፍ፣ ፍኒሳፍ ዮካን ባሮሌዻፍ፣ ");
INSERT INTO gaze_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","አከ ወን ቶኮ ቁልቁሉ ዮካን ጡራኣ ተኤ አዳን ባሱፍ ኬነሜዸ። ኩን ሴረ ለምጢዻፍ ኬነሜዸ። ");
INSERT INTO gaze_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","ዋቀዮ ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“አከነ ጄዻቲ እስራኤሎተት ህማ፤ ‘ነምን ከምዩ ዸንገለኣ ሳለሳ ኬሳ በኡ ዮ ቀባቴ፣ እን ሰበቢ ዸንገለኣ ሰናቲፉ ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","ዸንገለኣን ሱን እቱመ ፉፌ ሳለሳ ኬሳ በኡስ ዻበቱስ ነምቸ እኑመ ጡሬሰ። አክ እት ዸንገለኣን ሳለሳ ኬሳ በኡ ሱን እሰ ጡሬሱስ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘ስሬን ነምን ዸንገለኣን ሳለሳ ኬሳ በኡ እረ ጪሱ ሁንድኑ ጡራኣ ተአ፤ ወን እንረ ታኡ ሁንድኑስ ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","ነምን ስሬ ነምቸ ሰና ቱቁ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","ነምን ዋን ነምች ዸንገለኣን ሳለሳ ኬሳ በኡ ሱን እረ ታኤ እረ ታኡ ከምዩ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳስ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘ነምን ነመ ዸንገለኣን ሳለሳ ኬሳ በኡ ሰነ ቱቁ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳስ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘ዮ ነምን ዸንገለኣን ሳለሳ ኬሳ በኡ ሱን ነመ ቁልቁላኣ ከምትዩ ቱፌ፣ ነምች እት ቱፈሜ ሱን ኡፈተሳ ሃሚጨቱ፤ ዸግነሳ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘ኮራን ነምን ዸንገለኣን ሳለሳ ኬሳ በኡ ሱን እረ ታኡ ሁንድኑ ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","ነምን ዋን እሰ ጀለ ቱሬ ቱቁ ከምዩ ሀመ ገልገላት ጡራኣ ተአ። ነምን እሳን ከኔን ለፋ ፉዹ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘ነምን ነምች ዸንገለኣን ሳለሳ ኬሳ በኡ ሱን ኡቱ ሀርከሳ ብሻኒን ህንዽቀትን ቱቁ ከምዩ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘ኦኮቴን ሱጴ ከን ነምን ዸንገለኣን ሳለሳ ኬሳ በኡ ሱን ቱቁ ሃጨጨብሰሙ፤ ምእ ሙከራ ሆጄተሜ ከምዩ ብሻኒን ሃዽቀሙ። ");
INSERT INTO gaze_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘ነምን ዮሙ ዸንገለኣን ሳለሳ ኬሳ በኡራ ቁልቁሌፈሙት አከ ሴራት ቁልቁሌፈሙሳቲፍ ቡልቲ ቶርበ ሃለካአቱ፤ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳስ ብሻን ያኡን ሃዽቀቱ፤ እንስ ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","እንስ ጉያ ሰዴተፋት ጉጌ ለመ ዮካን ጉጌ ሶሶኬ ለመ ቀበቴ ፉለ ዋቀዮ ዱረ ዹፌ በልበለ ዱንካነ ወል ገኢረት ሉበት ሃኬኑ። ");
INSERT INTO gaze_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","ሉብችስ እሰ ቶኮ ኣርሳ ጩቡቲፍ ካንሞ ኣርሳ ጉበሙፍ ሃዽኤሱ። ሃለ ከናንስ ሉብን ሱን ሰበቢ ዸንገለኣ ነመ ሰናቲፍ ፉለ ዋቀዮ ዱረት አራረ ቡሰ። ");
INSERT INTO gaze_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘ነምን ቶኮ ዮሙ አፌታ ዸንገላሱት ዸግነሳ ጉቱ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","ኡፈትን ዮካን እትሌን አፌታን ቱቁ ከምዩ ብሻኒን ሃሚጨሙ፤ ምእ ሱን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","ነምን ዮ ኒቲ ቶኮ ወጅን ጪሴ አፌታ ዸንገላሴ፣ ለማንሳኒዩ ብሻኒን ዸግነሳኒ ሃዽቀተን፤ እሳን ሀመ ገልገላት ጡራኦ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘ዱበርቲን ዮ ዸንገለኣ ዺጋ ከን ዬሮሳ ኤገቴ ዸግነሼ ኬሳ በኡ ቀባቴ፣ እሼን ጡራኡማ ጡሪ ጅኣሼቲን ቡልቲ ቶርበ ቱርት፤ ነምን እሼ ቱቁ ከምዩ ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘ወን እሼን ዬሮ ጡሪሼት እረ ጪፍቱ ጡራኣ ተአ፤ ወን እሼን እረ ቴሱ ከምዩስ ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","ነምን ስሬሼ ቱቁ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳስ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","ነምን ዋን እሼን እረ ቴሱ ቱቁ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳስ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","ነምን ዮ ስሬስ ተኡ ዋን እሼን እረ ታኣ ቱርቴ ከምዩ ቱቄ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘ነምን ዮ እሼ ወጅን ጪሴ ጡራኡማንሼ እሰ ቱቄ፣ እን ቡልቲ ቶርበ ጡራኣ ተአ፤ ስሬን እን እረ ጪሱ ከምዩስ ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘ዱበርቲን ቶኮ ዮ ዬሮ ጡሪ ጅኣሼ መሌ ጉያ ባይኤዻፍ ዸንገለአ ዺጋ ቀባቴ ዮካን ዮ ዸንገለአ ዺጋ ከን ዬሮ ጡሪሼ ቦዴስ እቱመ ፉፉ ቀባቴ እሼን አኩመ ዬሮ ጡሪሼ ሰነት ሀመ ዸንገለኣን ሱን ጅሩት ጡሮፍቱ ታት። ");
INSERT INTO gaze_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","ስሬን እሼን ዬሮ ዸንገለኣንሼ እቱመ ፉፌ ያኡት እረ ጪፍቱ አኩመ ስሬሼ ከን ዬሮ ጡሪ ጅኣሼ ሰናት ጡራኣ ተአ፤ ወን እሼን እረ ቴሱ ከምዩ አኩመ ዬሮ ጡሪሼት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","ነምን እሳን ቱቁ ከምዩ ንጡራአ፤ እን ኡፈተሳ ሃሚጨቱ፤ ዸግነሳስ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘እሼን ኤርገ ዸንገለኣሼራ ቁልቁሎፍቴ ቦዴ ጉያ ቶርበ ሃለካአቱ፤ ኤርገሲሞ አከ ሴራት ንቁልቁሎፍት። ");
INSERT INTO gaze_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","እሼንስ ጉያ ሰዴተፋት ጉጌ ለመ ዮካን ጉጌ ሶሶኬ ለመ ፉቴ፣ በልበለ ዱንካነ ወል ገኢረት ሉበት ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","ሉብችስ እሰ ቶኮ ኣርሳ ጩቡቲፍ፣ ካንሞ ኣርሳ ጉበሙፍ ሃዽኤሱ። ሃለ ከናንስ ሰበቢ ጡራኡማ ዸንገለኣሼቲፍ ፉለ ዋቀዮ ዱረት አራረ ቡሰ። ");
INSERT INTO gaze_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘እስን አከ እስራኤሎን እዶ ቡልቲኮ ከን ግዱሳኒ ጅሩ ሰነ ጡሬሱዻን ጡራኡማሳኒቲን ህንዱኔፍ ዋን እሳን ጡሬሱራ አዳን እሳን ባሱ ቀብዱ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","ወን ኩን ሴረ ነመ ዸንገለኣን ሳለሳ ኬሳ በኡፍ፣ ነመ አፌታን ሳለሳ ኬሳ በኡ ጡሬሱፍ፣ ");
INSERT INTO gaze_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","ዱበርቲ ጡሪ ጅኣ ቀብዱፍ፣ ዺረ ዮካን ዱበርቲ ዸንገለኣን ሳለ ኬሳ በኡፊ ነመ ዱበርቲ አከ ሴራት ቁልቁሉ ህንተእን ቶኮ ወጅን ጪሱ ከሚፍዩ ኬነሜዸ። ");
INSERT INTO gaze_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","ዋቀዮስ ዱአ እልማን አሮን ከኔን ዬሮ ፉለ ዋቀዮ ዱረት ዽኣተንት ዱአን ሰነ ለማኒ ቦዴ ሙሴት ዱበቴ። ");
INSERT INTO gaze_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ሰበቢ አን ቴሶ አራራ ገረራት ዱሜሳን ሙልአዹፍ አከ ኦቦሌስኬ አሮን ዬሩመ ፌዼት ገረ እዶ እዶ ሁንደ ጫላ ቁልቁሉ ከን ጎልጋ ኬሰ ፉለ ቴሶ አራራ ዱረ ታቦተረ ጅሩ ሰና ኦል ህንሴኔ እት ህም፤ ዮ ከና አቺ እን ንዱአ። ");
INSERT INTO gaze_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“አክ አሮን እት እዶ እዶ ሁንደ ጫላ ቁልቁሉ ሰነ ሴኑ ከናዸ፦ ኣርሳ ጩቡቲፍ ድብቸ ቶኮ፣ ኣርሳ ጉበሙፍሞ ኮርቤሰ ሆላ ቶኮ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","እንስ ክታ ቁንጬ ተልባራ ሆጄተሜ ቁልቁሉሳቲፊ ኡፈተ ዸግነሳት ኣኑ ከን ቁንጬ ተልባራ ሆጄተሜ ሃካአቱ። ሰበተ ቁንጬ ተልባራ ሆጄተሜ ህዸቴ መረተ መታ ከን ቁንጬ ተልባራ ሆጄተሜስ ሃመረቱ፤ ኩኔን ኡፈተ ቁልቁሉዸ። ከናፉ እን ኡቱ ኡፈተ ሰነ ህንኡፈትን ዸግነሳ ብሻኒን ሃዽቀቱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","ወልዳ ሰበ እስራኤል እራስ ኣርሳ ጩቡቲፍ ኮሮሚ ሬኤ ለመ፣ ኣርሳ ጉበሙፍሞ ኮርቤሰ ሆላ ቶኮ ሃፉዹ። ");
INSERT INTO gaze_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“አሮን ኣርሳ ጩቡ ኦፊሳቲፍ ድብቸ ሰነ ዽኤሴ ኦፊሳቲፊ ወረ መነሳ ጅረኒፍ አራረ ሃቡሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","ኤርገሲስ ሬኦተ ለማን ሰነ ፉዼ በልበለ ዱንካነ ወል ገኢረት ፉለ ዋቀዮ ዱረት ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","አሮንስ ሬኦተ ሰነ ለማንት እጣ ሃቡሱ፤ እጣ ቶኮ ዋቀዮፍ፣ ካንሞ ሬኤ ገድ ለክፈሙፍ ሃቡሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","አሮንስ ሬኤ እጣን ዋቀዮእረ ቡኤ ሰነ ፍዴ ኣርሳ ጩቡ ጎዼ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","ገሩ ሬኤን አከ ሬኤ ገድ ለክፈሙ ተኡፍ እጣዻን ፍለተሜ ሱን አከ ሬኤ ገድ ለክፈሙ ቶኮት ገሞጂት ገድ አርአሙዻን አከ አራረ ቡሱፍ ኡቱ ሉቡዻን ጅሩ ፉለ ዋቀዮ ዱረት ሃዽኤፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“አሮንስ ኣርሳ ጩቡ ኦፊሳቲፍ ድብቸ ሰነ ዽኤሴ ኦፊሳቲፊ ወረ መነሳ ጅረኒፍ አራረ ሃቡሱ፤ ድብቸ ሰነስ ጩቡ ኦፊሳቲፍ ሃቀሉ። ");
INSERT INTO gaze_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","እንስ ግርግራ በርበዳ እብዳ እዶ ኣርሳ ከን ፉለ ዋቀዮ ዱረ ጅሩራ እት ጉተሜ ቶኮ ፉዼ እጣነ ኡርጋኣ ዳከሜ ቡላኤስ ኮኜ ለመ ፉዼ ጎልጋ ሰነ ኬሰ ሃሴኑ። ");
INSERT INTO gaze_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","እንስ አከ ህንዱኔፍ፣ አከ ኣር እጣነ ሰና ቴሶ አራራ ከን ዹገ በኡምሳ ጉባ ጅሩ ሰነ ሀጉጉፍ እጣነ ሰነ እብደ ፉለ ዋቀዮ ዱረ ጅሩት ሃነቁ። ");
INSERT INTO gaze_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","ዺገ ድብቸ ሰናራ ፉዼ ከራ ፉልዱራቲን ቴሶ አራራት ቁበሳቲን ሃፈጫሱ፤ ኤርገሲሞ ዺገሳ ፉዼ ፉለ ቴሶ አራራ ዱረት ዬሮ ቶርበ ቁበሳቲን ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“ሬኤ ሰነስ ኣርሳ ጩቡ ሰባ ጎዼ ሃቀሉ፤ ዺገሳስ ፉዼ ጎልጋ ኬሰ ሴኑዻን አኩመ ዺገ ድብቸ ሰና ጎዼ ሰነ ሃጎዹ፤ ዺገ ሰነስ ቴሶ አራራ እረቲፊ ፉለ ቴሶ አራራ ዱረት ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","ጩቡንሳኒ ዋኑመ ፌዼ ተኡሌ እን ሰበቢ ጡራኡማፊ ፍንጭለ ሰበ እስራኤሊፍ እዶ እዶ ሁንደ ጫላ ቁልቁሉ ሰነ ሃለ ከናን አራረ ሃቡሱ፤ ዱንካነ ወል ገኢ ከን ጡራኡማሳኒ ኬሰ እሳን ግዱ ጅሩፍስ አከሱመ ሃጎዹ። ");
INSERT INTO gaze_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","ዬሮ አሮን እዶ እዶ ሁንደ ጫላ ቁልቁሉ ሰነ ኬሰት አራረ ቡሱፍ ኦል ሴኔ ጀልቀቤ ሀመ እን ኦፊሳቲፍ፣ ወረ መነሳ ጅረኒፊ ወልዳ እስራኤል ሁንዳፍ አራረ ቡሴ ገድ በኡት ነምን ቶኮዩ ዱንካነ ወል ገኢ ኬሰት ህንአርገምን። ");
INSERT INTO gaze_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“ኤርገሲስ እዶ ኣርሳ ከን ፉለ ዋቀዮ ዱረ ጅሩ ሰነት ገድ በኤ እዶ ኣርሳ ሰናፍ አራረ ሃቡሱ። እንስ ዺገ ድብቸ ሰናራ ፉዼ፣ ዺገ ሬኤ ሰናራስ ፉዼ ጋንፈ እዶ ኣርሳ ሰና ሁንደረት ሃነቁ። ");
INSERT INTO gaze_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","እንስ እዶ ኣርሳ ሰነ ጡራኡማ ሰበ እስራኤልራ ቁልቁሌሴ አዳን ባሱፍ ዺገ ሰነራ ቁበሳቲን ዬሮ ቶርበ እዶ ኣርሳረት ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“አሮን ኤርገ እዶ እዶ ሁንደ ጫላ ቁልቁሉ ሰነ፣ ዱንካነ ወል ገኢቲፊ እዶ ኣርሳቲፍ አራረ ቡሴ ራወቴ ቦዴ ሬኤ ሉቡዻን ጅሩ ሰነ ገረ ፉልዱራት ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","እንስ ሀርከሳ ለማኑ መታ ሬኤ ሉቡዻን ጅሩ ሰናረ ካኤ አችረት ሀምናፊ ፍንጭለ ሰበ እስራኤል ጄቹንስ ጩቡሳኒ ሁንደ ህመ። የከ ሁንደስ መታ ሬኤ ሰናረ ካኤ ሬኤ ሰነ ነመ ሆጂ ከናፍ ፍለተሜ ቶኮት ኬኔ ገረ ገሞጂት ሃአርኡ። ");
INSERT INTO gaze_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","ሬኤን ሱንስ ጩቡሳኒ ሁንደ ኦፍ እረት ባቴ ገረ ለፈ ነምን ህንዸቅኔት ጌሰ፤ ነምችስ ገሞጂ ኬሰት እሰ ገድ ዺሰ። ");
INSERT INTO gaze_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“ኤርገሲስ አሮን ዱንካነ ወል ገኢ ሴኔ ኡፈተ ቁንጬ ተልባራ ሆጄተሜ ከን ኡቱ እዶ እዶ ሁንደ ጫላ ቁልቁሉ ሰነ ህንሴንን ኡፈቴ ሰነ ባፈቴ አቹመት ሃዺሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","እንስ ለፈ ቁልቁሉ ቶኮት ዸግነሳ ብሻኒን ዽቀቴ ኡፈተ እሰ ሃኡፈቱ፤ ኤርገሲሞ ገድ በኤ ኦፊሳቲፊ ሰበ ሰናፍ አራረ ቡሱፍ፣ ኦፊሳቲፍ ኣርሳ ጉበሙ፣ ሰበ ሰናፍስ ኣርሳ ጉበሙ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","ጮመ ኣርሳ ጩቡሌ እዶ ኣርሳረት ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“ነምች ሬኤ ሰነ አከ ሬኤ ገድ ለክፈሙ ቶኮት ገድ ዺሱ ሱን ወያሳ ሚጨቴ ዸግነሳ ብሻኒን ሃዽቀቱ፤ ኤርገሲ ገረ ቁበታት ኦል ገሉ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","ድብቺፊ ሬኤን ኣርሳ ጩቡቲፍ ዽኤፈመን ከኔን ዺግንሳኒ አራረ ቡሱፍ እዶ እዶ ሁንደ ጫላ ቁልቁሉት ፍደሜ ሱን ቁበተ ኬሳ ሃባፈመን፤ ጎጋንሳኒ፣ ፎኒፊ ምእ ገራሳኒ ሃጉበሙ። ");
INSERT INTO gaze_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","ነምች ወንቶተ ከኔን ጉቡስ ኡፈተሳ ሚጨቴ ዸግነሳ ብሻኒን ሃዽቀቱ፤ ኤርገሲ ገረ ቁበታት ኦል ገሉ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“ሴር በረ በራን እስኒፍ ኬነሜ ከናዸ፦ ዸለታ ብያስ ተኡ አለጋን እስን ግዱ ጅራቱ ጉያ ኩርነፋ ጅአ ቶርበፋት ገድ ኦፍ ሃቀቡ፤ ሆጂ ቶኮዩስ ህንሆጄትን። ");
INSERT INTO gaze_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","ሰበቢንሳ እስን ቁልቁሌሱፍ ጉያን ኩን ጉያ እት አራር ቡኡዸ፤ ኤርገሲስ እስን ፉለ ዋቀዮ ዱረት ጩቡኬሰን ሁንደራ ንቁልቁሎፍቱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","ኩን ዋን ሰንበተ ቦቆና ተኤፍ እስን ገድ ኦፍ ዴብሱ ቀብዱ፤ እንስ ሴረ በረ በራት። ");
INSERT INTO gaze_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","ሉብን እዶ አባሳ ቡኤ ሉበ ኦል ኣና ተኡፍ ድበሜ ሙደሙ አራረ ቡሱ ቀበ፤ እንስ ወያ ቁልቁሉ ከን ቁንጬ ተልባራ ሆጄተሜ ኡፈቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","እዶ እዶ ሁንደ ጫላ ቁልቁሉፍ፣ ዱንካነ ወል ገኢቲፍ፣ እዶ ኣርሳቲፍ፣ ሉቦታፊ ምሴንሶተ ወልዳ ሁንዳፍስ አራረ ሃቡሱ። ");
INSERT INTO gaze_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“ሴር በረ በራን እስኒፍ ኬነሜ ከናዸ፦ ኩንስ አከ ጩቡ እስራኤሎታ ሁንዳፍ ወጋት ዬሮ ቶኮ አራር ቡፈሙፍ።” ወን ሱንስ አኩመ ዋቀዮ ሙሴ አጀጄት ሆጄተሜ። ");
INSERT INTO gaze_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“አሮኒፊ እልማንሳት፣ ሰበ እስራኤል ሁንደትስ አከነ ጄዺ ህም፤ ‘ወን ዋቀዮ አጀጄ ኩኖ ከነ፦ ");
INSERT INTO gaze_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","ሰበ እስራኤል ኬሳ ነምን ከምዩ ዮ ቁበተ ኬሰት ዮካን ቁበታን አለት ሰንጋ ዮካን ሆላ ዮካን ሬኤ ቀሌ ");
INSERT INTO gaze_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","ዱንካነ ቁልቁሉ ዋቀዮ ዱረት ኣርሳ ጎዼ ዋቀዮፍ ዽኤሱፍ በልበለ ዱንካነ ወል ገኢት ፍዱ ባቴ ነምች ሱን ዺገ ዸንገላሴ ሰነት ንጋፈተመ፤ እን ዺገ ዸንገላሴራቲ ሰበሳ ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","ኩንስ አከ እስራኤሎን ኣርሳወን አመ አለት ዽኤሳ ጅረን ከነ ዋቀዮፍ ፍደኒፍ። እሳንስ ኣርሳወን ከኔን ኣርሳ ነጋ ጎዸኒ ዋቀዮፍ ዽኤሱፍ በልበለ ዱንካነ ወል ገኢረት ሉበት ሃፍደን። ");
INSERT INTO gaze_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","ሉብችስ ዺገ ሰነ እዶ ኣርሳ ዋቀዮ ከን በልበለ ዱንካነ ወል ገኢረ ጅሩ ሰነት ሃፈጫሱ፤ ጮመሳስ ኡርጋ ዋቀዮት ቶሉ ጎዼ ሃጉቡ። ");
INSERT INTO gaze_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","እሳንስ ስአች ዋቆተ ቶልፈሞ ብፈ ሬኤ ከኔን ዱካ ቡአኒ ሰጋገላ ቱረን ሰናፍ ኣርሳሳኒ ቶኮሌ ዽኤሱ ህንቀበን፤ ኩንስ እሳኒፍ ዸሎተ ዹፉፍ ሴረ በረ በራ ተአ።’ ");
INSERT INTO gaze_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“አከነስ እሳኒን ጄዽ፤ ‘ሰበ እስራኤል ኬሳ ነምን ከምዩ ዮካን አለጋን እሳን ግዱ ጅራቱ ከምዩ ዮ ኣርሳ ጉበሙ ዮካን ቀልመ ዽኤሴ ");
INSERT INTO gaze_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","በልበለ ዱንካነ ወል ገኢ ዱረት ዋቀዮፍ ኣርሳ ዽኤሱፍ ፍዱ ባቴ ነምች ሱን ሰበሳ ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘ሰበ እስራኤል ኬሳ ነምን ከምዩ ዮካን አለጋን ግዱሳኒ ጅራቱ ከምዩ ዺገ ዮ ኛቴ፣ አን ነመ ዺገ ኛቴ ሰነ ፉለ እን ሀማዸ፤ ሰበሳ ኬሳስ እሰ ነንበሌሰ። ");
INSERT INTO gaze_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","ሰበቢ ጅሬኝ ዋን ሉቡ ቀቡ ቶኮ ዺገ ኬሰ ጅሩፍ አን እቲን አራረ ሉቡኬሰኒፍ ቡሱዻፍ ዺገ ሰነ እዶ ኣርሳረት እስኒ ኬኔረ፤ ወን ጅሬኘ ነማቲፍ አራረ ቡሱስ ዺገ። ");
INSERT INTO gaze_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","ከናፉ አን እስራኤሎታን፣ “እስን ኬሳ ነምን ቶኮዩ ዺገ ህንኛትን ዮካን አለጋን ግዱኬሰን ጅራቱ ዺገ ህንኛትን” ነንጄዸ። ");
INSERT INTO gaze_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘ሰበ እስራኤል ኬሳ ነምን ከምዩ ዮካን አለጋን ግዱኬሰን ጅራቱ ከን ብኔንሰ ዮካን ስምብረ ኛተሙ አደምሱ ከምዩ ዺገ ዋን ሰና ዸንገላሴ ብዮ እት ሃዴብሱ፤ ");
INSERT INTO gaze_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","ጅሬኝ ዋን ሉቡ ቀቡ ቶኮ ዺገሳት። ሰበቢን አን እስራኤሎታን፣ “ዋን ጅሬኝ ዋን ሉቡ ቀቡ ሁንዳ ዺገሳ ተኤፍ እስን ዺገ ዋን ሉቡ ቀቡ ቶኮሌ ህንኛትና፤ ነምን ዺገ ኛቱ ከምዩ ሰበ ኬሳ ሃበሌፈሙ” ጄዼፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘ነምን ከምዩ ዸለታ ብያስ ተኡ አለጋን ዋን ዱኤ አርገሜ ዮካን ብኔንስ ጭጭሬ ኛቱ ኡፈተሳ ሃሚጨቱ፤ ዸግነሳስ ብሻኒን ሃዽቀቱ፤ እን ሀመ ገልገላት አከ ሴራት ጡራኣዸ፤ ኤርገሲ ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","ዮ ኡፈተሳ ሚጨቹፊ ዸግነሳ ዽቀቹ ባቴ ገሩ እን ጩቡ ሰነት ንጋፈተመ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“አከነ ጄዺ እስራኤሎተት ህም፤ ‘አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","እስን ዋን እሳን ብየ ግብጥ፣ ብየ እስን ኬሰ ጅራቻ ቱርተን ሰነ ኬሰት ሆጄተን ህንሆጄትና፤ ዋን ብየ ከነኣን፣ ብየ አን እት እስን ገልቹፍ ጅሩ ኬሰት ሆጄተሙስ ህንሆጄትና። ሴረሳኒ ዱካ ህንቡእና። ");
INSERT INTO gaze_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","እስን ሴረኮቲፍ አጀጀማ፤ አጀጀኮስ ስሪት ኤጋ፤ አን ዋቀዮ ዋቀኬሰኒዸ። ");
INSERT INTO gaze_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","አጀጀኮፊ ሴረኮ ኤጋ፤ ነምን እሳኒፍ አጀጀሙ እሳኒን ጅራታቲ፤ አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘ነምን ከምዩ ፍረ ዺጋ ከምዩ ወጅን ወል ብረ ገኡፍ እት ህንዽኣትን፤ አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘ሃዸኬ ወጅን ወል ብረ ገኡዻን አባኬ ህንሰልጵስን፤ እሼን ሃዸኬት፤ እሼ ወጅን ወል ብረ ህንገእን። ");
INSERT INTO gaze_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘ኒቲ አባኬቲ ወጅን ወል ብረ ህንገእን፤ ወን ኩን አባኬ ሰልጵሰ። ");
INSERT INTO gaze_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘እሼን መኑመ ኬትስ ተኡ ዮካን አለት ዸለቱሌ ኦቦሌቲኬ፣ እንተለ አባኬቲ ዮካን ሃዸኬቲ ወጅን ወል ብረ ህንገእን። ");
INSERT INTO gaze_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘እንተለ እልመኬቲ ዮካን እንተለ እንተለኬቲ ወጅን ወል ብረ ህንገእን፤ ወን ኩን ስ ሰልጵሰ። ");
INSERT INTO gaze_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘እንተለ ኒቲ አባኬቲ ከን አባኬቲፍ ዸለቴ ወጅን ወል ብረ ህንገእን፤ እሼን ኦቦሌቲኬት። ");
INSERT INTO gaze_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘ኦቦሌቲ አባኬቲ ወጅን ወል ብረ ህንገእን፤ እሼን አባኬቲፍ ፍረ ዺጋት። ");
INSERT INTO gaze_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘ኦቦሌቲ ሃዸኬቲ ወጅን ወል ብረ ህንገእን፤ እሼን ሃዸኬቲፍ ፍረ ዺጋት። ");
INSERT INTO gaze_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘ወል ብረ ገኡፍ ጄቴ ኒቲ ኦቦሌሰ አባኬቲት ዽኣቴ እሰ ህንሰልጵስን፤ እሼን ኒቲ ኦቦሌሰ አባኬቲት። ");
INSERT INTO gaze_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘ኒቲ እልመኬቲ ወጅን ወል ብረ ህንገእን። እሼን ኒቲ እልመኬቲት፤ እሼ ወጅን ወል ብረ ህንገእን። ");
INSERT INTO gaze_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘ኒቲ ኦቦሌሰኬቲ ወጅን ወል ብረ ህንገእን፤ ወን ሱን ኦቦሌሰኬ ሰልጵሰ። ");
INSERT INTO gaze_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘ዱበርቲ ቶኮፊ እንተለሼ ወጅን ወል ብረ ህንገእን። እንተለ እልመ ዱበርቲ ሰና ዮካን እንተለ እንተለሼ ወጅን ወል ብረ ህንገእን፤ እሳን እሼዻፍ ፍረ ዺጋት፤ ወን ኩን ጀልእነ። ");
INSERT INTO gaze_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘ኡቱ ኒቲንኬ ሉቡዻን ጅርቱ ኦቦሌቲሼ መሳኑሼ ጎቴ ህንፉዽን፤ እሼ ወጅንስ ወል ብረ ህንገእን። ");
INSERT INTO gaze_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘ዬሮ ዱበርቲን ቶኮ ጡራኡማ ጡሪ ጅኣ ኦፍራ ቀብዱት፣ ብረ ገኡዻፍ ጄቴ እሼት ህንዽኣትን። ");
INSERT INTO gaze_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘ኒቲ ነማ ወጅን ወል ብረ ጌሴ እሼዻን ኦፍ ህንጡሬስን። ");
INSERT INTO gaze_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘እጆሌኬ ኬሳ ቶኮሌ አከ ሞሌኪፍ ኣርሳ ተአኒፍ ህንኬንን፤ አት መቃ ዋቀኬቲ ህንጡሬስን። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘አከ ነምን ዱበርቲ ወጅን ጪሱ አት ዺረ ወጅን ህንጪስን፤ ወን ኩን ሆጂ ጅብሲሳዸ። ");
INSERT INTO gaze_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘ሆሪ ከምዩ ወጅን ወል ብረ ጌሴ ኦፍ ህንጡሬስን፤ ዱበርቲን ሆሪ ወጅን ወል ብረ ገኡፍ ኦፊሼ እት ህንኬንን፤ ኩን ዋን ከራራ ጎሬዸ። ");
INSERT INTO gaze_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘ሰበቢ ነሞትን አን አርኤ እስን ዱራ ባሱፍ ጅሩ ኩኔን ሃለ ከናን ጡራአኒፍ እስን ከራ ከኔን ኬሳ ከሚንዩ ኦፍ ህንጡሬስና። ");
INSERT INTO gaze_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","ለፍትዩ ጡሮፍቴርት፤ ከናፉ አን ሰበቢ ጩቡሼቲፈን እሼ አደቤ፤ ለፍትስ ጅራቶተሼ ንቱፍት። ");
INSERT INTO gaze_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","እስን ገሩ አጀጀኮፊ ሴረኮ ኤጋ። ዸለታን ብያቲፊ አለጎን እስን ግዱ ጅራተንስ ዋን ጅብሲሳ ከነ ኬሳ ከምዩ ህንሆጄትን። ");
INSERT INTO gaze_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","ነሞትን እስኒን ዱረ ብየ ሰነ ኬሰ ጅራተንስ ዋን ከነ ሁንደ ሆጄተኒ አከሲን ብየቲን ጡሮፍቴ። ");
INSERT INTO gaze_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","እስንስ ለፈ ከነ ዮ ጡሬስተን፣ ለፍት አኩመ ሰቦተ እስን ዱረ ቱረን ቱፍቴ ሰነ እስኒንሌ ንቱፍት። ");
INSERT INTO gaze_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘ነምን ወንቶተ ጅብሲሶ ከኔን ኬሳ ቶኮሌ ሆጄቱ ከምዩ ሰበሳ ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","አጀጀኮ ኤጋ፤ በርቴወን ጅብሲሶ እስን ዱረ ሆጄተማ ቱረን ሰነ ኬሳ ቶኮሌ ዱካ ቡተኒ እቲን ኦፍ ህንጡሬስና፤ አን ዋቀዮ ዋቀኬሰን።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“አከነ ጄዺ ወልዳ ሰበ እስራኤል ሁንደት ህም፤ ‘አን ዋቀዮ ዋቅንኬሰን ቁልቁሉዻቲ እስንስ ቁልቁሎተ ተኣ። ");
INSERT INTO gaze_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘ቶኮን ቶኮንኬሰን ሃዸኬሰኒፊ አባኬሰኒፍ ኡልፍነ ኬና፤ ሰንበቶተኮስ ኤጋ። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘ገረ ዋቆተ ቶልፈሞት ህንዴብእና ዮካን ስቢለ በቅፈሜራ ኦፊኬሰኒፍ ዋቆተ ህንቶልፈትና። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘ዮሙ ኣርሳ ነጋ ዋቀዮፍ ዽኤስተንት አከ ኣርሳንኬሰን ፉዸተመ እስኒፍ አርገቱ ጎዻቲ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","ኣርሳን እስን ዽኤስተንስ ጉዩመ ሰነ ዮካን ጉያ እት ኣኑ ሃኛተሙ፤ ገሩ ወን ሀፌ ሀመ ጉያ ሰደፋት ቱሬ ሃጉበሙ። ");
INSERT INTO gaze_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","ዋን ከነ ኬሳ ቶኮዩ ዮ ጉያ ሰደፋት ኛተሜ ጡራኣዸ፤ ፉዸተመስ ህንአርገቱ። ");
INSERT INTO gaze_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","ነምን ዋን ሰነ ኛቱ ሰበቢ ዋን ዋቀዮን ቁልቁሌፈሜ ጡሬሴፍ እት ጋፈተመ፤ ነምች ሱን ሰበሳ ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘ዮሙ ኦምሸ ለፈኬሰኒ ወልት ቀበተንት ሀመ ዳሪት ህንሃምና፤ ቀርሚሳሌ ህንፉናነትና። ");
INSERT INTO gaze_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","ቀርሚ እዶ ዻባ ወይኒኬቲ ህንፉናንን ዮካን እጀ ወይኒኬቲ ከን ሀርጨኤ ህንፉናንን። ህዬዪፊ አለጎታፍ ዺሳ። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘ህንሀትና። “ ‘ህንሶብና። “ ‘ወልስ ህንጎዎምስና። ");
INSERT INTO gaze_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘ሶባን መቃኮቲን ህንከከትና፤ አከሲንስ መቃ ዋቀኬሰኒ ህንጡሬስና። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘ኦላኬ ጎዎምስቴ ዋ እራ ህንፉዸትን ዮካን ህንሳምን። “ ‘ምንዳ ነመ ቀጠረሜ ቶኮ ሀመ በርኡት ኦፍ ብረ ህንቡልችን። ");
INSERT INTO gaze_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘ነመ ጉረ ዱዳ ህንአባርን ዮካን ነመ ጃማ ዱረ ጉፉ ህንካእን፤ ገሩ ዋቀኬ ሶዳዹ። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘ሙርቲ ህንጀልእስና፤ ነመ ወል ጫልችሱዻን ገረ ህዬሳ ህንጎርና፤ ነመ ጉዳፍስ ህንሎግና፤ ኦላኬቲፍ ገሩ ሙርቲ ቀጄላ ኬን። ");
INSERT INTO gaze_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘ሰበኬ ግዱት ሀሚ ህንፈጫስን። “ ‘ዋን ጅሬኘ ኦላኬቲ በላረ ቡሱ ህንሆጄትን። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘ገራኬት ኦቦሌሰኬ ህንጅብን፤ አከ ጩቡሳ ኬሰት ቆደ ህንቀባኔፍ ኦላኬ እፋን እፈት እት ዼከም። ");
INSERT INTO gaze_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘ሰበኬ ኬሳ ነመ ቶኮትዩ ሃሎ ህንበእን ዮካን ሃሎ እት ህንቀበን፤ ኦላኬ ገሩ አኩመ ኦፊኬቲት ጃለዹ። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘ስርነኮ ኤጋ። “ ‘ሆሪ ጎሰ ጎሳ ወልት ህንድቃሎምስና። “ ‘ምዻን ጎሰ ለመ ለፈ ቆቲሳኬሰንት ህንፈጫስና። “ ‘ወያ ዋን ለመራ ሆጄተሜ ህንኡፈትና። ");
INSERT INTO gaze_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘ነምን ገርብቲ ነመ ብራፍ ካዽመምቴ ከን ህንፉረምን ዮካን ብልሱማንሼ ህንኬነምኒፍ ወጅን ዮ ወል ብረ ገኤ እሳን አደበሙ ቀቡ፤ ተኡስ ዋን ዱበርቲን ሱን ህንብልሶምኒፍ እሳን ህንአጄፈምን። ");
INSERT INTO gaze_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","ነምች ሱን ገሩ ኮርቤሰ ሆላ ቶኮ ኣርሳ የካቲፍ ገረ በልበለ ዱንካነ ወል ገኢት ዋቀዮፍ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","ሉብችስ ኮርቤሰ ሆላ ኣርሳ የካ ሰናን ጩቡ ነምች ሆጄቴ ሰናፍ ፉለ ዋቀዮ ዱረት አራረ ሃቡሱ፤ ጩቡን ነምቻስ ንዺፈማፍ። ");
INSERT INTO gaze_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘እስን ዮሙ ብየቲት ገልተኒ ሙከ እጀ ኬኑ ከን ጎሰ ሁንዳ ዻብደንት፣ አከ ዋን እጅሳ ዾወሜት ፉዸዻ። እስን አከ ዋን እጅ ሱን ሀመ ወጋ ሰዲት ዾወሜት እላላ፤ እጅ ሱን ህንኛተምን። ");
INSERT INTO gaze_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","ወጋ አፉረፋትሞ እጅሳ ሁንድኑ ንቁልቁላአ፤ ዋቀዮፍስ ኣርሳ ገለታ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","ወጋ ሸነፋት ገሩ እጀሳ ኛቹ ደንዴሱ። ሃለ ከናን ኦምሽንኬሰን ንጉደተ። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘ኡቱ ዺግን ኬሰ ጅሩ ፎን ከምዩ ህንኛትና። “ ‘ቶልቸ ዮካን ፈልፈለ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘ርፌንሰ መታኬሰኒ ናኔስተኒ ህንሃደትና ዮካን ቀርቀረ አሬደኬሰኒስ ህንሙርሙረትና። ");
INSERT INTO gaze_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘ነመ ዱኤፍ ጄተኒ ዸግነኬሰን ህንመመዴስና ዮካን መለቶ ቱማ ቶኮሌ ኦፍ እረት ህንቶልፈትና። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘አከ ለፍት ሀለሉማት ዴብቴ ሀምናን ህንጉተምኔፍ እንተለኬ አከ እሼን ኤጅቱ ጎቹዻን እሼ ህንሰልጵስን። ");
INSERT INTO gaze_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘ሰንበቶተኮ ኤጋ፤ እዶ ቁልቁሉኮስ ከበጃ። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘እስን አከ ህንጡሮፍኔፍ እላልቶተ ብረ ህንዴምና ዮካን ወረ ኤኬራ ዱብሰን ህንበርባድና። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘ወረ ዱሎመኒፍ ከእ፤ ጃርሳፍ ኡልፍነ ኬን፤ ዋቀኬ ሶዳዹ። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘ዮ አለጋን ብየኬሰን ኬሰ እስን ወጅን ጅራቴ እሰ ህንጩንቁርስና። ");
INSERT INTO gaze_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","አለጋን እስን ግዱ ጅራቱ ሱን አከ ዸለታ ብየኬሰኒት ሃእላለሙ። አከ ኦፊኬሰኒት እሰ ጃለዻ፤ እስንስ ብየ ግብጥት አለጎተ ቱርተኒቲ። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘እስን ዮሙ ዼርነ፣ ኡልፍናፊ ባይእነ ወዪ ሰፈርተንት መዳሊ ጎዎምሳት ህንፈየደምና። ");
INSERT INTO gaze_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","ሰፈርቱፊ መዳሊ ዹጋት፣ ኢፊፊ ኢኒ ዹጋት ፈየደማ። አን ዋቀዮ ዋቀኬሰን ከን ብየ ግብጢ ባሴ እስን ፍዴዸ። ");
INSERT INTO gaze_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘አጀጃፊ ሴረኮ ሁንደ ኤጋቲ ዱካ ቡኣ። አን ዋቀዮ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“እስራኤሎታን አከነ ጄዽ፤ ‘ነምን እስራኤል ዮካን አለጋን እስራኤል ኬሰ ጅራቱ ከን እልማንሳ ኬሳ ሞሌኪፍ ኬኑ ከምዩ ሃአጄፈሙ፤ ሰብን ብየ ሰና ዸጋዻን እሰ ሃቱሙ። ");
INSERT INTO gaze_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","ሰበቢ ነምች ሱን እልማንሳ ሞሌኪፍ ኬኑዻን እዶ ቁልቁሉኮ ጡሬሴ መቃኮ ቁልቁሉ ሰነ ሰልጵሴፍ፣ አን ፉለ እት ሀማዼ ሰበሳ ኬሳ እሰ ነንበሌሰ። ");
INSERT INTO gaze_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","ሰብን ብየ ሰና ዬሮ ነምች ሱን እልማንሳ ኬሳ ቶኮ ሞሌኪፍ ኬኑት ዮ ፉለራ ዴብፈቴ እሰ አጄሱ ዺሴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","አን ነምቸ ሰናፊ ማቲሳት ፉለ ሀማዼ እሳፊ ወረ እሰ ፋነ ቡአኒ ሰጋገሉዻን ሞሌክት ኦፍ ኬነን ሁንደ ሰበሳኒ ኬሳ ነንበሌሰ። ");
INSERT INTO gaze_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘ነመ እሳን ዱካ ቡኡዻን ሰጋገሉፍ ጄዼ ገረ እላልቶታቲፊ ወረ ኤኬራ ዱብሰኒት ዴብኡት አን ፉለ እተን ሀማዸ፤ ሰበሳ ኬሳ እሰ ነንበሌሰ። ");
INSERT INTO gaze_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘ኦፍ ቁልቁሌሳ፤ ቁልቁሎተስ ተኣ፤ አን ዋቀዮ ዋቀኬሰኒቲ። ");
INSERT INTO gaze_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","ስርነኮ ኤጋ፤ ዱካ ቡኣስ። አን ዋቀዮ እሰ እስን ቁልቁሌሱዸ። ");
INSERT INTO gaze_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘ነምን አባሳ ዮካን ሃዸሳ አባሬ ከምዩ ሃአጄፈሙ። እን አባሳ ዮካን ሃዸሳ አባሬራቲ ዺግንሳ መቱመሳት ዴብአ። ");
INSERT INTO gaze_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘ዮ ነምን ኒቲ ነመ ብራ ወጅን ጄቹንስ ኒቲ ኦላሳ ወጅን ሰጋገሌ ነምች ሰጋገሌፊ ኒቲን ሰጋገልቴ ሱን ሃአጄፈመን። ");
INSERT INTO gaze_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘ነምን ዮ ኒቲ አባሳ ወጅን ጪሴ እን አባሳ ሰልጵሴረ። ነምችስ፣ ዱበርቲን ሱንስ ሃአጄፈመን፤ ዺግንሳኒ መቱመሳኒት ዴብአ። ");
INSERT INTO gaze_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘ዮ ነምን ኒቲ እልመሳ ወጅን ጪሴ ለማንሳኒዩ ሃአጄፈመን። እሳን ሀራሙዸ፤ ዺግንሳኒ መቱመሳኒት ዴብአ። ");
INSERT INTO gaze_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘ዮ ነምን አኩመ ዱበርቲ ወጅን ጪሱት ዺረ ወጅን ጪሴ ለማንሳኒዩ ዋን ጅብሲሳ ሆጄተኒሩ። እሳን ሃአጄፈመን፤ ዺግንሳኒ መቱመሳኒት ዴብአ። ");
INSERT INTO gaze_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘ነምን ቶኮ ዮ እንተላፊ ሃዸሼ ፉዼ፣ ወን ኩን ጡራኡማዸ። አከ እስን ግዱት ጡራኡማን አከሲ ህንአርገምኔፍ ነምቺፊ ዱበርቶትን ለማን እብዳን ሃጉበመን። ");
INSERT INTO gaze_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘ነምን ቶኮ ዮ ሆሪ ወጅን ወል ብረ ገኤ ሃአጄፈሙ፤ ሆሪ ሰነሌ አጄሳ። ");
INSERT INTO gaze_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘ዮ ዱበርቲን ሆሪ ከምትዩ ዽኣቴ ሆሪ ሰነ ወጅን ወል ብረ ጌሴ፣ ዱበርቲን ሱኒፊ ሆሪን ሱን ሃአጄፈመን፤ ዺግንሳኒ መቱመሳኒት ዴብአ። ");
INSERT INTO gaze_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘ነምን ቶኮ ዮ ኦቦሌቲሳ ጄቹንስ እንተለ አባሳ ዮካን እንተለ ሃዸሳ ፉዼ ወል ብረ ገአን ወን ኩን ሰልጵነ። እሳን ኡቱመ ሰብንሳኒ አርጉ ሰበሳኒ ኬሳ ሃበሌፈመን፤ ነምች ኩን ኦቦሌቲሳ ሰልጵሴረ፤ እት ጋፈተመስ። ");
INSERT INTO gaze_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘ነምን ቶኮ ዮ ዬሮ ዱበርቲን ቶኮ ጡሪ ጅኣ ኦፍራ ቀብዱት እሼ ብረ ገኤ፣ እን መደ ዸንገለኣሼ እፈት ባሴረ፤ እሼንስ መደ ዸንገለአሼ ሙልእፍቴርት። ለማንሳኒዩ ሰበሳኒ ኬሳ ሃበሌፈመን። ");
INSERT INTO gaze_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘ኦቦሌቲ ሃዸኬቲ ዮካን አባኬቲ ወጅን ወል ብረ ህንገእን፤ ወን ሱን ፍረ ዺጋ ሰልጵሳቲ፤ እስን ለማኑስ እት ጋፈተምቱ። ");
INSERT INTO gaze_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘ነምን ቶኮ ዮ ኒቲ ኤሱመሳ ወጅን ወል ብረ ገኤ እን ኤሱመሳ ሰልጵሴረ። እሳን እት ጋፈተሙ፤ ኡቱ እጆሌ ህንአርገትንስ ዱኡ። ");
INSERT INTO gaze_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘ነምን ቶኮ ዮ ኒቲ ኦቦሌሰሳ ፉዼ፣ ወን ኩን ሆጂ ጡራኡማት፤ እንስ ኦቦሌሰሳ ሰልጵሴረ። እሳን እጆሌ መሌ ሀፉ። ");
INSERT INTO gaze_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘አከ ለፍት አን አከ እስን ኬሰ ጅራተኒፍ እት እስን ፍዱ ሱን እስን ህንቱፍኔፍ አጀጃፊ ሴረኮ ሁንደ ኤጋ፤ ዱካ ቡኣስ። ");
INSERT INTO gaze_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","እስን በርቴ ሰቦተ አን ፉለኬሰን ዱራ አርኤ ባሱፍ ጅሩ ከኔኒ ዱካ ህንቡእና፤ ሰበቢ እሳን ወንቶተ ከኔን ሁንደ ሆጄተኒፍ አን እሳን ጅቤረ። ");
INSERT INTO gaze_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","አን ገሩ፣ “እስን ለፈሳኒ ንዻልቱ፤ አንስ ለፈ ኣነኒፊ ደመ ባሱ ዻለ ጎዼ እስኒፍን ኬነ” ጄዼረ። አን ዋቀዮ ዋቀኬሰን ከን ሰቦተ ካንራ አዳን እስን ባሴዸ። ");
INSERT INTO gaze_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘ከናፉ እስን ብኔንሰ ቁልቁላኣፊ ጡራኣ፣ ስምብሮ ጡራኣፊ ቁልቁላኣ አዳን ባሳ። ብኔንሰ ዮካን ስምብሮ ዮካን ዋን ለፈረ ሙኙቁ ከኔን አን እስኒፍ ጡራኦተ ጄዼ አዳን ባሴ ከሚንዩ ኦፍ ህንጡሬስና። ");
INSERT INTO gaze_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","ሰበቢ አን ዋቀዮ ቁልቁሉ ተኤፊ አከ እስን ከንኮ ታተኒፍስ ሰቦተ ካንራ አዳን እስን ባሴፍ፣ እስን ቁልቁሎተ ናፍ ተኣ። ");
INSERT INTO gaze_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘ዺር ዮካን ዱበርቲን እላለን ዮካን ኤኬራ ዱብሰን ሃአጄፈመን። እሳን ዸጋዻን ሃቱመመን፤ ዺግንሳኒ መቱመሳኒት ዴብአ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አከነ ጄዺቲ እልማን አሮን ሉቦተ ሰነት ዱበዹ፦ ‘ሉብን ቶኮ ነመ ፍረሳ ኬሳ ዱኤፍ ጄዼ ኦፍ ህንጡሬስን፤ ");
INSERT INTO gaze_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","ገሩ ፍሮተ ዺጋቲፍ ጄቹንስ ሃዸሳ፣ አባሳ፣ እልመሳ፣ እንተለሳ፣ ኦቦሌሰሳ፣ ");
INSERT INTO gaze_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","ዮካን ኦቦሌቲሳ ከን ሰበቢ ህንሄሩምኒፍ እሰ ወጅን ጅራቱፍ ጄዼ ኦፍ ጡሬሱ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","ገሩ ነሞተ ከራ ፉዻፊ ሄሩማቲን ፍሮተሳ ተአኒፍ ጄዼ ኦፍ ህንጡሬስን፤ አከሲንስ ጡራኣ ህንተእን። ");
INSERT INTO gaze_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘ሉቦትን መታሳኒ ዮካን ቀርቀረ አሬደሳኒ ህንሃደትን ዮካን ዸግነሳኒ ህንመዴስን። ");
INSERT INTO gaze_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","እሳን ዋቀሳኒቲፍ ቁልቁሎተ ሃተአን፤ መቃ ዋቀሳኒስ ህንጡሬስን። እሳን ዋን ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ፣ ኛተ ዋቀሳኒ ሰነ ዽኤሰኒፍ ቁልቁሎተ ተኡ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘ሉቦትን ሰበቢ ዋቀሳኒቲፍ ቁልቁሎተ ተአኒፍ እሳን ዱበርቶተ ሰጋገሉማዻን ጡራአን ዮካን ከኔን ዽርሶተሳኒ ሂከን ፉዹ ህንቀበን። ");
INSERT INTO gaze_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","አት እሰ ቁልቁሌስ፤ እን ኛተ ዋቀኬቲ ዽኤሳቲ። እን ሲፍ ሃቁልቁላኡ፤ አን ዋቀዮ እን እስን ቁልቁሌሱ ቁልቁሉዻቲ። ");
INSERT INTO gaze_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘እንተል ሉበ ቶኮ ዮ ሰጋገሉማዻን ኦፍ ጡሬስቴ እሼን አባሼ ሰልጵፍት፤ እሼን እብዳን ሃጉበምቱ። ");
INSERT INTO gaze_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘ሉብን ኦቦሎተሳ ኬሳ ሉበ ኦል ኣና ተኤ ዘይቲን እቲን ድበን መታሳረት ነቀሜ ከን አከ ኡፈተ ሉቡማ ኡፈቱፍ ሙደሜ ቶኮ መታሳ ፍለቹ ህንዺስን ዮካን ኡፈተ ኦፊ ህንተርሳስን። ");
INSERT INTO gaze_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","እን እዶ ሬፍ ጅሩ ህንሴንን። አባሳቲፍ ዮካን ሃዸሳቲፍዩ ጄዼ ኦፍ ህንጡሬስን፤ ");
INSERT INTO gaze_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","ዮካን ሰበቢ ዘይቲን እቲን ድበን ከን ዋቀሳ እሰረ ጅሩፍ እን እዶ ቁልቁሉ ሰነ ኬሳ ህንበእን ዮካን እዶ ቁልቁሉ ዋቀሳ ህንጡሬስን። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘ዱበርቲን እን ፉዹ ዱርበ ተኡ ቀብድ። ");
INSERT INTO gaze_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","እን ሃዸ ህዬሳ፣ ኒቲ ዽርስ ሂኬ ዮካን ኒቲ ሰጋገሉማዻን ጡሮፍቴ ህንፉዽን፤ ገሩ ጎሰሳ ኬሳ ዱርበ ሃፉዹ፤ ");
INSERT INTO gaze_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","ኩንስ አከ እን ጎሰሳ ኬሰት ሰኚሳ ህንጡሬስኔፍ። አን ዋቀዮ እሰ ቁልቁሌሱዸ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“አሮኒን አከነ ጄዽ፦ ‘ዸሎተ እት ኣኑ ኬሰት ሰኚኬ ኬሳ ነምን ህርእነ ቀቡ ከምዩ ኛተ ዋቀሳ ዽኤሱፍ ህንዽኣትን። ");
INSERT INTO gaze_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","ነምን ህርእነ ከምዩ ቀቡ ቶኮዩ ጄቹንስ ነምን ጃማን ዮካን ናፍን፣ ነምን ብፋፊ ዸግነ ህንቶሌ፣ ");
INSERT INTO gaze_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","ነምን ሚለ ዮካን ሀርከ ጨባ ቀቡ፣ ");
INSERT INTO gaze_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","ዮካን ነምን ዱግደ ጎጶ ዮካን ኦሉን ዮካን ነምን ዽቤ እጃ ቀቡ ዮካን ነምን መዳ መለኡ ቀቡ፣ ዮካን ነምን ጭቶ ቀቡፊ ነምን ኮላፈሜ ህንዽኣትን። ");
INSERT INTO gaze_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","ሰኚ አሮን ሉብቻ ኬሳ ነምን ህርእነ ቀቡ ከምዩ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ዽኤሱፍ ህንዽኣትን። እን ዋን ህርእነ ቀቡፍ ኛተ ዋቀሳ ዽኤሱፍ ህንዽኣትን። ");
INSERT INTO gaze_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","እንስ ኛተ ዋቀሳ ከን ኛተ ሁንደ ጫላ ቁልቁሉ ተኤፊ ኛተ ቁልቁሉ ኛቹ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","ገሩ እን ሰበቢ ህርእነ ቀቡፍ አከ እዶ ቁልቁሉኮ ህንጡሬስኔፍ ጎልጋ ኬሰ ህንሴንን ዮካን እዶ ኣርሳት ህንዽኣትን። አን ዋቀዮ እሰ እሳን ቁልቁሌሱዸ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","ሙሴን አሮንት፣ እልማን አሮንቲፊ እስራኤሎተ ሁንደት ዋን ከነ ህሜ። ");
INSERT INTO gaze_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“አከ እሳን መቃኮ ቁልቁልቸ ህንጡሬስኔፍ፣ አከ እሳን ኣርሳ ቁልቁሉ እስራኤሎን አዳን ባሰኒ ና ፍደን ሰነ አከ ጋሪት ኤገኒፍ አሮኒፊ እልማንሳት ህም። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“አከነስ እሳኒን ጄዽ፦ ‘ዸሎተ ዹፉ ኬሰ ዮ ሰኚኬ ኬሳ ነምን ቶኮሌ ኡቱ አከ ሴራት ህንቁልቁላእን ኣርሳ እስራኤሎን ዋቀዮፍ አዳን ባሰንት ዽኣቴ ነምን ሱን ፉለኮ ዱራ ሃበሌፈሙ። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘ሰኚ አሮን ኬሳ ነምን ቶኮ ዮ ለምጢ ዮካን ዸንገለኣ ሳለሳ ኬሳ በኡ ቀባቴ እን ሀመ ቁልቁላኡት ኣርሳ ቁልቁሉ ሰነ ህንኛትን። አከሱመስ ዮ ዋን ሬፋን ጡራኤ ዮካን ነመ አፌታ ሳለሳ ኬሳ ደንገለኡ ቱቄ፣ ");
INSERT INTO gaze_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","ዮካን ዮ ዋን ለፈረ ሎኡ ከን እሰ ጡሬሱ ዮካን ነመ እሰ ጡሬሱ ከምዩ ቱቄ፣ ጡራኡማ ከምዩ ታናን፣ ");
INSERT INTO gaze_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","ነምን ዋን አከሲ ከምዩ ቱቁ ሀመ ገልገላት ጡራኣ ተአ። እን ዮ ዸግነሳ ብሻኒን ዽቀቴ መሌ ኣርሳ ቁልቁሉ ሰነ ኬሳ ቶኮሌ ህንኛትን። ");
INSERT INTO gaze_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","እን ዬሮ አዱን ልጡት ንቁልቁላአ፤ ኤርገሲሞ ሰበቢ ወን ሱን ኛተሳ ተኤፍ ኣርሳ ቁልቁሉ ሰነ ኛቹ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","እን ዋን ዱኤ አርገሜ ዮካን ዋን ብኔንስ ጭጭሬ ኛቹዻን ኦፍ ህንጡሬስን። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘ሉቦትን አከ አጀጀኮ ቱፈቹዻን ጩቡ ሆጄተኒ ህንዱኔፍ አጀጀኮ ሃኤገን። አን ዋቀዮ እሳን ቁልቁሌሱዸ። ");
INSERT INTO gaze_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘ነምን ማቲ ሉባ ህንተእን ዮካን ኬሱማን ሉባ ዮካን ነምን ሉብቻፍ ቀጠረሜ ሆጄቱ ቶኮሌ ኣርሳ ቁልቁሉ ሰነ ኛቹ ህንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","ገሩ ዮ ሉብን ማለቃን ገርብቸ ብተቴ፣ ዮካን ዮ ገርብች መነሳት ዸለቴ፣ ገርብች ሱን ኛተ ሉብቻ ኛቹ ደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","እንተል ሉባ ዮ ነመ ሉበ ህንተእንት ሄሩምቴ፣ እሼን ኣርሳ ቁልቁሉ ሰነራ ኛቹ ህንደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","ተኡስ እንተል ሉባ ዮ ሃዸ ህዬሳ ታቴ ዮካን ዽርሳን ወል ሂክቴ ኡቱ እጆሌ ህንቀባትን አኩመ ዬሮ እጆሉማሼት መነ አባሼ ጅራቹፍ ዴብቴ፣ እሼን ኛተ አባሼራ ኛቹ ንደንዴስ። ኦርም ገሩ ኛቹ ህንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘ነምን ዮ ኡቱ ህንቤክን ኣርሳ ቁልቁሉ ቶኮ ኛቴ፣ እን ዋን ሰነ እዶ ቡሴ ገቲ ዋን ሰና ሀርከ ሸን ኬሳ ሀርከ ቶኮ እት ደበሌ ሉብቻፍ ሃኬኑ። ");
INSERT INTO gaze_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","ሉቦትንስ ኣርሳ ቁልቁሉ እስራኤሎን ዋቀዮፍ ዽኤሰን ህንጡሬስን ");
INSERT INTO gaze_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","ዮካን አከ ሰብን ሱን ኣርሳ ቁልቁሉ ሰነ ኛቱ ኤየሙፊዻን የከ ገቲ ባስሱ እሳንት ህንፍድን። አን ዋቀዮ እሳን ቁልቁሌሱዸ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“አሮንት፣ እልማን እሳቲፊ እስራኤሎተ ሁንደት አከነ ጄዺ ህም፤ ‘ዬሮ ሰበ እስራኤል ኬሳ ነምን ቶኮ ዮካን አለጋን እስራኤል ኬሰ ጅራቱ ከምዩ ኣርሳ ጉበሙ ጎዼ ወሬገሳ ዮካን ኣርሳ ፌዺዻን ዽኣቱ ዋቀዮፍ ዽኤሱት፣ ");
INSERT INTO gaze_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","እስን አከ ወን ሱን ፉዸተመ እስኒፍ አርገቱፍ ሎን፣ ሆሎተ ዮካን ሬኦተ ኬሳ ኮርመ ህርእነ ህንቀብኔ ቶኮ ዽኤሱ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","ሰበቢ እን እስኒ ህንፉዸተምኔፍ ዋን ህርእነ ቀቡ ከምዩ ህንዽኤስና ");
INSERT INTO gaze_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","ዬሮ ነምን ሎን ዮካን ቡሻዬ ኬሳ ወሬገ ጉተቹፍ ኣርሳ ፌዺዻን ዽኤፈሙ ጎዼ ኣርሳ ነጋ ዋቀዮፍ ዽኤሱት አከ ወን ሱን ፉዸተመ አርገቱፍ ወን ሱን ዋን ፈያሌሰ ዮካን ዋን ህርእነ ህንቀብኔ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","ሆሪ ጃማ ዮካን ጨባ ዮካን ዶሉ ዮካን ኮርሞሙ ዮካን ከን ዸንገለኣን ዸግነሳ ኬሳ በኡ ዮካን ከን መዳ መለኡ ቀቡ ዋቀዮፍ ህንዽኤስና። ከኔን አከሲ ኬሳ ቶኮዩ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ጎተኒ እዶ ኣርሳረ ህንካእና። ");
INSERT INTO gaze_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","ተኡስ ሰንጋ ዮካን ሆላ ገር መሌ ዼራ ዮካን ገር መሌ ገባባ ተኤ ኣርሳ ፌዺዻን ዽኣቱ ጎተኒ ዽኤሱ ንደንዴሱ፤ ገሩ ወን ኩን ወሬገኬሰን ጉቱፍ ፉዸተመ ህንአርገቱ። ");
INSERT INTO gaze_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","ሆሪ ኮላፈሜ ዮካን ከን ቱመሜ፣ ከን ኮላንሳ በቀቅፈሜ ዮካን እራ ሙረሜ ቶኮ ዋቀዮፍ ህንዽኤስና፤ እስን ዋን አከሲ ብየኬሰን ኬሰት ህንጎዽና፤ ");
INSERT INTO gaze_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","ሆሪ አከሲ ነመ ኦርማ ሀርካ ፉተኒ ኛተ ዋቀኬሰኒ ጎተኒ ህንዽኤስና። ሆሪን ሱን ዋን ኮላፈሜ ህርእነ ቀቡፍ እስኒፍ ህንፉዸተሙ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“ድብች ዮካን ሆላን ዮካን ሬኤን ዮሙ ዸለቱት ሀመ ቡልቲ ቶርባት ሃዸሳ ወጅን ሃቱሩ። ጉያ ሰዴተፋዻ ጀልቀቤሞ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ተኤ ፉዸተመ ንአርገተ። ");
INSERT INTO gaze_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","ጉዩመ ቶኮት፣ ሰአ ዮካን ሆላ እልሞሳ ወጅን ህንቀልና። ");
INSERT INTO gaze_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“ጋፈ ኣርሳ ገለታ ዋቀዮፍ ዽኤስተንት አከ እስኒፍ ፉዸተሙፍ ሃለ ከናን ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","ኣርሳን ኩንስ ጋፉመ ሰነ ኛተሙ ቀበ፤ ዋን ቶኮሌ ህንቡልችና። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“አጀጀወንኮ ኤጋ፤ ዱካ ቡኣስ። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","መቃኮ ቁልቁልቸ ህንጡሬስና። አከ አን ቁልቁሉ ተኤ እስራኤሎን ሃቤክስሰን። አን ዋቀዮ ከን እስን ቁልቁሌሱ ");
INSERT INTO gaze_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","ከነን ዋቀኬሰን ተኡዻፍ ብየ ግብጢ እስን ባሴዸ። አን ዋቀዮ።” ");
INSERT INTO gaze_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“አከነ ጄዺቲ እስራኤሎተት ዱበዹ፤ ‘ኩኔን አያኖተኮ ሙርታኦ፣ አያኖተ ዋቀዮ ከኔን እስን ጉዮተ ወል ገኢ ቁልቁሉ ጄተኒ ለብስተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘ጉዮትን እስን ሆጂ እት ሆጄተን ጀአቱ ጅረ፤ ጉያን ቶርበፋን ገሩ ሰንበተ ቦቆና፣ ጉያ ወል ገኢ ቁልቁሉት። እስን ሆጂ ቶኮሌ ህንሆጄትና፤ እዶ እስን ጅራተን ከምትዩ ኩን ሰንበተ ዋቀዮት። ");
INSERT INTO gaze_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘እሳን ኩኔን አያኖተ ዋቀዮ ሙርቴፈሞ፣ ወልዳወን ቁልቁሉ እስን ዬሮሳኒት ለብስተኒዸ፤ ");
INSERT INTO gaze_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","ፋሲካን ዋቀዮ ገልገለ ቡልቲ ኩዸ አፉረፋ ጅአ ጀልቀባት ጀልቀበመ። ");
INSERT INTO gaze_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","ጉያ ኩዸ ሸነፋ ጅአ ጀልቀባት አያነ ዋቀዮ ከን መጥኖቱ ጀልቀበመ፤ እስንስ ጉያ ቶርበ ቡዴነ ራጭቲ ህንቀብኔ ኛዻ። ");
INSERT INTO gaze_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","ጉያ ጀልቀባት ወል ገኢ ቁልቁሉ ቀባዻ፤ ሆጂ እድሌስ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","ቡልቲ ቶርበ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ዽኤሳ። ቡልቲ ቶርበፋት ወል ገኢ ቁልቁሉ ቀባዻ፤ ሆጂ እድሌስ ህንሆጄትና።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“አከነ ጄዺ እስራኤሎተት ዱበዹ፤ ‘ዮሙ ብየ አን እስኒፍ ኬኑት ገልተኒ ኦምሸ ወልት ቀብደንት ብሲ መታ ምዻን ወልት ቀብደን ሰና ሉበት ፍዳ። ");
INSERT INTO gaze_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","እንስ አከ ብሲን ሱን ፉዸተመ እስኒፍ አርገቱፍ ፉለ ዋቀዮ ዱረት ሃሶቾሱ፤ ሉብችስ ጉያ ሰንበተ ቦዴ ጅሩት ሃሶቾሱ። ");
INSERT INTO gaze_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","ጉያ ብሲ ሰነ ሶቾፍተንት፣ ጦባላ ሆላ ወጋ ቶኮ ከን ህርእነ ህንቀብኔ ኣርሳ ጉበሙ ጎዻቲ ዋቀዮፍ ዽኤሳ፤ ");
INSERT INTO gaze_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","ከነ ወጅንስ ኣርሳ ምዻኒ ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ለመ ኣርሳ ኡርጋኣ እብዳን ዋቀዮፍ ዽኤፈሙፊ ዽባዩ ዳዺ ወይኒ ኢኒ ቶኮራ ሀርከ አፉር ኬሳ ሀርከ ቶኮ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","እስን ሀመ ጋፈ ኬና ከነ ዋቀዮፍ ዽኤስተንት ቡዴነ ዮካን አካዪ ዮካን አሼቲ ህንኛትና። ኩንስ እዶ እስን ጅራተን ሁንደት ዸሎተ ዹፉፍ ሴረ በረ በራ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘ጉያ ሰንበተ ቦዴ ጅሩ፣ ጋፈ ብሲ ኣርሳ ሶቾፈሙ ፍደኒ ጀልቀባቲ ቶርበኖተ ቶርበ ጉቱ ለካኣ። ");
INSERT INTO gaze_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","ሀመ ጉያ ሰንበተ ቶርበፋ ቦዴ ጅሩት ጉያ ሸንተመ ለካኣ፤ ኤርገሲሞ ኣርሳ ምዻን ሃራ ዋቀዮፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","እዶ ጅራተን ሁንደት ቡዴነ ለመ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ለማ ከን ራጭቲን እት መከሜ ቶልፈሜ ኬና ሀንገፈ ከን ሶቾፈሙ ጎዻቲ ዋቀዮፍ ፍዳ። ");
INSERT INTO gaze_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","ቡዴነ ከነ ወጅንስ ጦባላወን ሆላ ቶርበ ከኔን ህርእነ ህንቀብኔፊ ከኔን ወጋ ቶኮ ቶኮ፣ ድብቸ ቶኮፊ ኮርቤዪ ሆላ ለመ ዽኤሳ። እሳንስ ኣርሳ ምዻንሳኒቲፊ ኣርሳ ዽባዩሳኒ ወጅን ዋቀዮፍ ኣርሳ ጉበሙ ተኡ፤ ኩንስ ኣርሳ እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉዸ። ");
INSERT INTO gaze_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","ኤርገሲስ ኣርሳ ጩቡቲፍ ኮርመ ሬኤ ቶኮ አከሱመስ ጦባላ ሆላ ለመ ከኔን ወጋ ቶኮ ቶኮ ኣርሳ ነጋቲፍ ቀላ። ");
INSERT INTO gaze_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","ሉብንሞ ጦባላ ሆላ ሰነ ለማን ኣርሳ ሶቾፈሙ ጎዼ ቡዴነ ጀልቀባ ወጅን ፉለ ዋቀዮ ዱረት ሃሶቾሱ። እሳን ኩኔንስ ከን ዋቀዮፍ ቁልቁሌፈመኒዸ፤ ቆደ ሉቦታትስ። ");
INSERT INTO gaze_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","እስን ጋፉመ ሰነ ወል ገኢ ቁልቁሉ ለብሳ፤ ሆጂ እድሌስ ህንሆጄትና። ኩንስ እዶ እስን ጅራተን ሁንደት ዸሎተ ዹፉፍ ሴረ በረ በራ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘ዮሙ ኦምሸ ለፈኬሰኒ ወልት ቀብደንት ሀመ ቀርቀራት ህንሃምና ዮካን ቀርሚሳ ህንፉናንና፤ ዋን ከነ ህዬዪፊ አለጎታፍ ሀምብሳ። አን ዋቀዮ ዋቀኬሰን።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“እስራኤሎታን አከነ ጄዽ፤ ‘እስን ጉያ ጀልቀበ ጅአ ቶርበፋት ሰንበተ ቦቆና ቀባዻ፤ ያኢ ቁልቁሉ ሰገሌ መለከታቲን አያኔፈሙስ ቀባዻ። ");
INSERT INTO gaze_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ዽኤሳ መሌ ሆጂ እድሌ ህንሆጄትና።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“ጉያን ኩርነፋን ጅአ ቶርበፋ ጉያ አራር ቡኡዸ። ወል ገኢ ቁልቁሉ ቀባዻ፤ ገድ ኦፍ ዴብሳ፤ ዋቀዮፍስ ኣርሳ እብዳን ዽኤፈሙ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","ሰበቢ ጉያን ሱን ጉያ አራር ቡኡ፣ ዬሮ እት ፉለ ዋቀዮ ዋቀኬሰኒ ዱረት አራር እስኒፍ ቡኡ ተኤፍ ሆጂ ቶኮሌ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","ነምን ጋፉመ ሰነ ገድ ኦፍ ህንዴብፍኔ ከምዩ ሰበሳ ኬሳ ባፈሜ ንበሌፈመ። ");
INSERT INTO gaze_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","ነመ ጋፈ ሰነ ሆጂ ቶኮሌ ሆጄቱ ከምዩስ አን ሰበሳ ግዱዻ ነንበሌሰ። ");
INSERT INTO gaze_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","እስን ሆጂ ቶኮዩ ህንሆጄትና። ኩንስ ለፈ እስን ጅራተን ሁንደት ዸሎተ ዹፉፍ ሴረ በረ በራ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","ኩን እስኒፍ ሰንበተ ቦቆናት፤ እስንስ ገድ ኦፍ ዴብሱ ቀብዱ። ገልገለ ቡልቲ ሰግለፋ ጅአ ሰናቲ ጀልቀባቲ ሀመ ገልገለ እት ኣኑት ሰንበተኬሰን አያኔፈዻ።” ");
INSERT INTO gaze_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“እስራኤሎታን አከነ ጄዽ፤ ‘ቡልቲ ኩዸ ሸነፋ ጅአ ቶርበፋት አያነ ዱንካነ ቁልቁሉ ዋቀዮቱ ጀልቀበመ፤ ኩንስ ቡልቲ ቶርበ ቱረ። ");
INSERT INTO gaze_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","ጉያን ጀልቀባ ወል ገኢ ቁልቁሉዸ፤ ሆጂ እድሌስ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","ጉያ ቶርበ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ዽኤሳ፤ ጉያ ሰዴተፋትሞ ወል ገኢ ቁልቁሉ ጎዸዻቲ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ዽኤሳ፤ ኩን ጉያ ወል ገኢን ቁልቁሉን እት ጡሙረሙዸ፤ ሆጂ እድሌስ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘ኩኔን አያኖተ ዋቀዮ ሙርታኦ እስን ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ፣ ኣርሳ ጉበሙ፣ ኣርሳ ምዻኒ፣ ቀልማፊ ዽባዩ ጉያ ከሚፍዩ በርባችሱ ዽኤሱፍ ወል ገኢወን ቁልቁሉ እት ለብስተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","ኣርሳወን ኩኔን ኬናወን እስን ሰንበተ ዋቀዮቲፍ ዽኤስተኒፊ ኬናወንኬሰን፣ ኬናወን ወሬገኬሰኒፊ ኬናወን እስን ፌዺዻን ኬንተን ሁንደረት ደበልተኒ ዋቀዮፍ ፍደኒዸ። ");
INSERT INTO gaze_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘ኤርገ ኦምሸ ለፈኬሰኒ ወልት ቀብደኒ ቦዴ ቡልቲ ኩዸ ሸነፋ ጅአ ቶርበፋቲ ጀልቀባቲ ቡልቲ ቶርበ ዋቀዮፍ አያነ አያኔፈዻ፤ ጉያን ጀልቀባ ሰንበተ ቦቆናት፤ ጉያን ሰዴተፋንስ አከሱመ ሰንበተ ቦቆናት። ");
INSERT INTO gaze_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","ጉያ ጀልቀባ እጀ ሙከ ጋሪ፣ ደሜ ሜጢ፣ ደሜ ሙከ ባለ ቀቡቲፊ አለልቱ ቀበዻቲ ጉያ ቶርበ ፉለ ዋቀዮ ዋቀኬሰኒ ዱረት ገመዳ። ");
INSERT INTO gaze_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","ወጉመ ወጋን አያነ ዋቀዮ ጉያ ቶርበ አያኔፈዻ። ኩንስ ዸሎተ ዹፉፍ ሴረ በረ በራ ሃተኡ፤ ጅአ ቶርበፋትስ እሰ አያኔፈዻ። ");
INSERT INTO gaze_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","ቡልቲ ቶርበ ዳሲ ኬሰ ቱራ፤ ዸለታን እስራኤል ሁንድኑ ዳሲ ኬሰ ሃቱሩ፤ ");
INSERT INTO gaze_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","እጆሌንኬሰንስ አከሲን አከ አን ዬሮ ብየ ግብጢቲ እስራኤሎተ ባሴት ዳሲ ኬሰ እሳን ቱርሴ ንቤኩ። አን ዋቀዮ ዋቀኬሰን።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","ሙሴንስ አያኖተ ዋቀዮ ሙርታኦ እስራኤሎተት ለብሴ። ");
INSERT INTO gaze_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“አከ እብሳን እቱመ ፉፌ ቦበኡፍ አከ እሳን ዘይቲ ኤጄርሳ ከን ጩንፈሜ ተሊለ ተኤ ሲፍ ፍደኒፍ እጆሌ እስራኤል አጀጅ። ");
INSERT INTO gaze_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","አሮንስ እብሳወን ሰነ ጎልጋ ታቦተ ከኩ ሴራ ከን ዱንካነ ወል ገኢ ኬሰ ጅሩ ሰናን አለት ፉለ ዋቀዮ ዱረት ገልገላ ሀመ ገነማት እቱመ ፉፌ ሃቆጴሱ። ኩንስ ዸሎተኬሰኒፍ ሴረ በረ በራ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","እብሳወን ባቱ እብሳ ከን ወርቄ ቁልቁሉራ ሆጄተመንረ ፉለ ዋቀዮ ዱረ ጅረን ሱን እቱመ ፉፈኒ ቆጴፈሙ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“ዳኩ ቡላኣ ፉዺቲ ቡዴነ ኩዸ ለመ ቶልች፤ ቶኮን ቶኮን ቡዴነ ሰናስ ዳኩ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ለመ ለማን ሃቶልፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","ቡዴነ ከነስ ቶረ ቶኮ ኬሰ ጀአ ጀአ ጎዺቲ ምንጃለ ወርቄ ቁልቁሉራ ሆጄተሜ ፉለ ዋቀዮ ዱረ ጅሩረ ቶረ ለማን ካእ። ");
INSERT INTO gaze_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","አከ እን ቆደ ቡዴነ ሰና ኩታ ያደኖቲፊ ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሙ ተኡፍ ቶኮ ቶኮ ቶረ ሰናረ እጣነ ቁልቁሉ ካእ። ");
INSERT INTO gaze_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","ቡዴን ኩንስ አከ ከኩ በረ በራ ተኤ ሰበ እስራኤል እዶ ቡኡፍ ዬሮ ሁንደ ሰንበቱመ ሰንበታን ፉለ ዋቀዮ ዱረ ሃካአሙ። ");
INSERT INTO gaze_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","ቡዴን ኩን ቆደ አሮኒቲፊ እልማንሳት፤ እሳንስ ሰበቢ ቡዴን ኩን ቆደሳኒ ከን በረ በራ ከን ኣርሳ እብዳን ዋቀዮፍ ዽኤፈሜ ኬሳ ኩታ ዋን ሁንደ ጫላ ቁልቁላኤ ተኤፍ እዶ ቁልቁሉት እሰ ሃኛተን።” ");
INSERT INTO gaze_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","ነምች ሃትሳ ጎሰ እስራኤሊፊ አባንሳሞ ነመ ብየ ግብጢ ተኤ ቶኮ እስራኤሎተ ግዱ በኤ፤ ሎልስ ቁበተ ኬሰት እሳፊ እስራኤልቸ ቶኮ ግዱት ከኤ። ");
INSERT INTO gaze_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","እልም ዱበርቲ እስራኤል ሱንስ መቃ ዋቃ አረብሴ፤ ንአባሬስ፤ ከናፉ ሙሴት እሰ ፍደን። መቃን ሃዸ ነምቸ ሰናስ ሼሎሚት ጄዸመ፤ እሼንሞ እንተለ ነምቸ ጎሰ ዳኒ ከን ድብራይ ጄዸሙት። ");
INSERT INTO gaze_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","እሳንስ ሀመ ፌዺን ዋቀዮ እሳኒ እፉት ኤጉምሰ ጀለ እሰ ቱርሰን። ");
INSERT INTO gaze_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","ዋቀዮስ ሙሴዻን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“ነምቸ ዋቀ አረብሴ ሰነ ቁበተ ኬሳ ገድ ባስ። ወር እሰ ዸገአን ሁንድኑ ሀርከሳኒ መታሳረ ሃካአን፤ ወልዳን ሁንድሞ ዸጋዻን እሰ ሃቱሙ። ");
INSERT INTO gaze_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","እስራኤሎታን አከነ ጄዽ፤ ‘ነምን ከምዩ ዮ ዋቀሳ አባሬ እን ጩቡ ሆጄቴፍ እት ጋፈተመ፤ ");
INSERT INTO gaze_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","ነምን መቃ ዋቀዮ አረብሱ ሃአጄፈሙ። ወልዳን ሁንድ ዸጋዻን እሰ ሃቱሙ። አለጋስ ተኡ ዸለታን ብያ ዮ መቃ ዋቃ አረብሴ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘ነምን ነመ አጄሴ ከምዩ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","ነምን ሆሪ ነማ አጄሴ ሆሪ ሰነ እዶ ሃቡሱ። ");
INSERT INTO gaze_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","ነምን ቶኮ ዮ ኦላሳ ሚዼ፣ ወን እን ነመ ሰነ ጎዼ እሰ እረትስ ሃጎዸሙ፤ ");
INSERT INTO gaze_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","ኩንስ ቆደ ጨባ ጨባ፣ ቆደ እጃ እጀ፣ ቆደ እልካኒ እልካን ጄቹዸ። እንስ አኩመ ነመ ሚዼ ሰነ እሰ እረትስ ሃጎዸሙ። ");
INSERT INTO gaze_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","ነምን ሆሪ አጄሴ ሆሪ ሰነ እዶ ሃቡሱ፤ ነምን ነመ አጄሴ ገሩ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","አለጋስ ተኡ ዸለታ ብያቲፍ ሴረ ቶክቸ ቀባዻ። አን ዋቀዮ ዋቀኬሰን።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","ሙሴን ዋን ከነ እስራኤሎተት ህሜ፤ እሳንስ ነምቸ ዋቀ አረብሴ ሰነ ቁበተ ኬሳ ገድ ባሰኒ ዸጋዻን ቱመን፤ እስራኤሎን አኩመ ዋቀዮ ሙሴ አጀጄ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","ዋቀዮ ጋረ ሲናረት ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“አከነ ጄዺ እስራኤሎተት ህም፦ ‘ዮሙ ብየ አን እስኒ ኬኑት ገልተን፣ ብየቲን መታንሼ ሰንበተ ዋቀዮ ሃከበጁ። ");
INSERT INTO gaze_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","ወጋ ጀአ ለፈ ቆቲሳኬ ፈጫፈዹ፤ ወጋ ጀአሞ ወይኒኬራ ቆር፤ እጀሳስ ወልት ቀበዹ። ");
INSERT INTO gaze_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","ወጋ ቶርበፋት ገሩ ለፍት ሰንበተ ቦቆና ሃቀባቱ፤ ኩንስ ሰንበተ ዋቀዮፍ ከበጀሙዸ። ለፈ ቆቲሳኬ ህንፈጫፈትን ዮካን ወይኒኬራ ህንቆርን። ");
INSERT INTO gaze_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","ዋን ኦፊን ብቅሌ ህንሃመትን ዮካን ወይኒ ህንቆረምንራ እጀ ወልት ህንቀበን። ለፍት ቦቆና ወጋ ቶኮ ሃአርገቱ። ");
INSERT INTO gaze_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","ወን ለፍት ወጋ ሰንበታት ኬንቱ ኛተኬ ሃተኡ ጄቹንስ ስእ መታኬቲፍ፣ ገርቦተኬ ዺራፊ ዱበርቲዻፍ፣ ወረ ቀጠረመኒ ሆጄተኒፊ አለጎተ ዬሮዻፍ ስ ወጅን ጅራተኒፍ ኛተ ሃተኡ፤ ");
INSERT INTO gaze_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","አከሱመስ ሆሪኬቲፊ ብኔንሰ ደገላ ከኔን ብየኬ ኬሰ ጅራተኒፍ ኛተ ሃተኡ። ወን ለፍት ባፍቱ ከምዩ ሃኛተሙ። ");
INSERT INTO gaze_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘ወጎተ ሰንበታ ቶርበ ጄቹንስ ወጎተ ቶርበ ዬሮ ቶርበ ለካእ፤ ወጎትን ሰንበታ ቶርበን ወጎተ አፉርተሚ ሰገል ተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","ጉያ ኩርነፋ ጅአ ቶርበፋትሞ ጉቱማ ብየኬሰኒ ኬሰት መለከተ ዸጌስስ፤ ጉያ አራር ቡኡትስ ጉቱማ ብያ ኬሰት መለከተ ዸጌስሳ። ");
INSERT INTO gaze_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","ወጋ ሸንተመፋ ቁልቁሌሳቲ ጉቱማ ብየቲ ኬሰት ጅራቶተ ሁንዳፍ ብልሱማ ለብሳ። ኩንስ እዮቤልዩ እስኒ ተአ፤ ቶኮን ቶኮን ነማ ዴብኤ ገረ ቀቤኘ እሳቲፊ ገረ ማቲሳት ሃገሉ። ");
INSERT INTO gaze_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","ወጋን ሸንተመፋን እዮቤልዩ እስኒፍ ሃተኡ፤ ህንፈጫፈትና፤ ዋን ኦፊን ብቅሌ ህንሃመትና፤ ወይኒ ህንቆረምንራስ እጀሳ ወልት ህንቀበትና። ");
INSERT INTO gaze_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","ኩን ሰበቢ እዮቤልዩ ተኤፍ ቁልቁሉ እስኒፍ ሃተኡ፤ ዋን ለፈ ቆቲሳራ ገልፈሙ ኛዻ። ");
INSERT INTO gaze_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘ወጋ እዮቤልዩ ከነ ኬሰ ቶኮን ቶኮን ነማ ገረ ቀቤኘሳት ሃዴብኡ። ");
INSERT INTO gaze_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘ዮ ነመ ሰበኬ ተኤት ለፈ ጉርጉርቴ ዮካን ዋን ቶኮ እሰራ ብቴ፣ ወል ህንጎዎምስና። ");
INSERT INTO gaze_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","አት ወጎተ ወጋ እዮቤልዩ ቦዴ ጅረንረት ሁንዶፍቴ ነመ ሰበኬቲራ ብተዹ። እንስ ባይእነ ወጎተ ገልቻ ምዻኒ ለካኤ ስት ሃጉርጉሩ። ");
INSERT INTO gaze_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","ዮ ወጋን ባይኤ ተኤ ገቲሳ ደበሊፍ፤ ዮ ወጋንሳ ገባባ ተኤሞ ገቲሳ ህርእስ፤ ሰበቢንሳ ወን እን ስት ጉርጉሩ ባይእነ ምዻኒት። ");
INSERT INTO gaze_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","ወል ህንጩንቁርስና፤ ገሩ ዋቀ ሶዳዻ። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘አጀጀኮ ዱካ ቡኣ፤ ሴረኮሌ ኤጋ፤ እስንስ ብየቲ ኬሰ ነጋን ንጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","ለፍት እጀ ንኬንት፤ እስንስ ሀመ ቁፍተንት ኛቱ፤ ነጋዻንስ ንጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","እስንስ፣ “ኑ ዮ ፈጫፈቹ ዮካን ምዻንኬኘ ወልት ቀበቹ ባትኔ ወጋ ቶርበፋት ማል ኛትነ?” ጄተኒ ጋፈቱ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","አከ ለፍት ምዻን ወጋ ሰዲፍ ገኡ እስኒ ኬንቱፍ አን ወጋ ጀአፋት ኤበኮ እስኒፍ ነንኤርገ። ");
INSERT INTO gaze_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","ዬሮ ወጋ ሰዴተፋት ፈጫፈተንትስ ዋኑመ ዱራን ገልፈተንራ ኛቱ፤ ሀመ ምዻን ወጋ ሰግለፋ ወልት ቀበተንት ምዻኑመ ከነ ኛቱ። ");
INSERT INTO gaze_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘ለፍት ሰበቢ ከኑመኮ ታቴፍ በረ በራን ህንጉርጉረምን፤ እስን አናፍ አለጋፊ ኬሱሞተ። ");
INSERT INTO gaze_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","ብየ አከ ዻላት ቀበተን ጉቱ ኬሰት ዋን እቲን ለፈ ፉርተን ባሳ። ");
INSERT INTO gaze_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘ኦቦሌስኬ ቶኮ ህዮሜ ለፈሳ ዮ ጉርጉሬ፣ ነምን ፍረሳ ከን ዽኦ ተኤ ዹፌ ዋን ፍርሳ ጉርጉሬ ሰነ ሃፉሩፍ። ");
INSERT INTO gaze_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","ገሩ ዮ ነምች ሱን ፍረ ለፈሳ ፉሩፍ ዸቤ እን መታንሳ ዋን እቲን ለፈሳ ፉረቱ አርገቴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","ወጎተ ዬሮ እን ለፈሳ ጉርጉሬ ሰና አስ ጅረን ለካኤ ነምቸ እት ጉርጉሬ ሰናፍ ማለቀሳ ሃዴብሱ፤ እንስ ገረ ለፈ ኦፊት ሃዴብኡ። ");
INSERT INTO gaze_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","ገሩ ዮ ዋን ነምቸ ሰናፍ ዴብሱ ዸቤ፣ ወን እን ጉርጉሬ ሱን ሀመ ወጋ እዮቤልዩት ሀርኩመ ነምቸ ብቴ ሰና ሃቱሩ። ወጋ እዮቤልዩ ኬሰ ንዴብኣፍ፤ እንስ ገረ ቀቤኘሳት ንዴብአ። ");
INSERT INTO gaze_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘ነምን ዮ መጋላ ደላ ቀብዱ ኬሰት መነ ጅሬኛ ጉርጉረቴ፣ ጋፈ ጉርጉረቴ ጀልቀቤ ወጋ ቶኮ ኬሰት ፉረቹ ደንደአ። ምርግ ፉረቹሳስ ሀመ ወጋ ቶኮት ቱረ። ");
INSERT INTO gaze_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","ዮ ኡቱ ወጋን ቶኮ ህንጉትን ፉረሙ ባቴ መን መጋላ ደላ ቀብዱ ኬሰት አርገሙ ሱን ቀቤኘ ነምቸ ብቴቲፊ ከን ሰኚሳ ተኤ ሀፈ። ወጋ እዮቤልዩትስ ህንዴብኡ። ");
INSERT INTO gaze_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","መኔን ገንዶተ ደላን እት ህንእጃረምን ኬሰ ጅረን ገሩ ዋን አከ ለፈ ባድያት ሄደመኒፍ ፉረሙ ደንደኡ። በረ እዮቤልዩትስ ንዴብፈሙ። ");
INSERT INTO gaze_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘ሌዎትን ገሩ መኔንሳኒ ከኔን መጋላወንሳኒ ኬሰት አርገመን ፉረቹፍ ዬሮ ከምዩ ምርገ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","ቀቤኝ ሌዎታ ፉረሙ ንደንደአ፤ መኔን መጋላ እሳን ቀበተን ኬሰት ጉርጉረመን በረ እዮቤልዩት ንዴብፈሙ፤ መኔን መጋላ ሌዎታ ኬሰት አርገመን እስራኤሎተ ግዱት ቀቤኘ ሌዎታቲ። ");
INSERT INTO gaze_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","ለፍት ዼዳ ከን ናኖ መጋላሳኒት አርገሙ ገሩ ሰበቢ ቀቤኘሳኒ ከን በረ በራ ተኤፍ ህንጉርጉረምን። ");
INSERT INTO gaze_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘ዮ ኦቦሌስኬ ቶኮ ህዮሜ እስን ግዱት ኦፍ ገርጋሩ ደዸቤ፣ አከ እን እስን ግዱ ጅራቹ ደንደኡፍ አኩመ አለጋ ዮካን ኬሱማ ቶኮ ገርጋርቱት እሰ ገርጋር። ");
INSERT INTO gaze_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","አከ ነምን ሱን ስ ወጅን ጅራቹ ደንደኡፍ ዋቀኬ ሶዳዹ መሌ ዸለ ቶኮዩ እሰራ ህንፉዸን። ");
INSERT INTO gaze_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","ማለቀኬ ዸላን ህንልቄስኒፍ ዮካን ኛተኬ ቡኣ እት ሄሬገቴ ህንኬንኒፍ። ");
INSERT INTO gaze_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","አን ዋቀዮ ዋቀኬሰን ከን ብየ ከነኣን እስኒፍ ኬኑፊ ዋቀኬሰን ተኡፍ ብየ ግብጢ እስን ባሴዸ። ");
INSERT INTO gaze_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘ዮ ኦቦሌስኬ ቶኮ ህዮሜ ስት ኦፍ ጉርጉሬ አከ ገርብቻት እሰ ህንሆጄቺፈትን። ");
INSERT INTO gaze_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","እን አከ ሆጄታ ቀጠረማ ዮካን ነመ ዬሮዻፍ እስን ወጅን ጅራቱ ሃተኡ፤ እን ሀመ ወጋ እዮቤልዩት ሲፍ ሃሆጄቱ። ");
INSERT INTO gaze_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","ኤርገሲ እን እጆሌሳ ወጅን ገድ ሃለክፈሙ፤ እን ገረ ማቲሳቲፊ ቀቤኘ አቦቲሳት ሃዴብኡ። ");
INSERT INTO gaze_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","እስራኤሎን ሰበቢ ገርቦተኮ ወረ አን ብየ ግብጢቲ ባሴ ፍዴ ተአኒፍ አከ ገርቦታት ህንጉርጉረምን። ");
INSERT INTO gaze_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","ዋቀኬ ሶዳዹ መሌ ገረ ጀብናን እሳን ህንቡልችን። ");
INSERT INTO gaze_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘ገርቦንኬ ዺሮትኒፊ ዱበርቶትን ሰቦተ ናኖኬ ጅራተን ግዱዻ ሃዹፈን፤ እስን እሳን ኬሳ ገርቦተ ብተቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","አከሱመስ ኬሱሞተ እስን ግዱ ጅራተኒፊ ማቲሳኒ ወረ ብየኬሰንት ዸለተን ኬሳ ገርቦተ ብተቹ ደንዴሱ፤ እሳንስ ቀቤኘኬሰን ሃተአን። ");
INSERT INTO gaze_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","አከ ቀቤኘ ዻለሙት እጆሌኬሰንት ደበርሱ ደንዴሱ፤ በረ ጅሬኘሳኒ ጉቱስ እሳን ገርቦምፈቹ ደንዴሱ፤ እስራኤሎተ ኦቦሎተኬሰን ተአን ገሩ ገረ ጀብናን ህንቡልችና። ");
INSERT INTO gaze_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘ዮ አለጋን ዮካን ኬሱማን ስ ወጅን ጅራቱ ቶኮ ሶሮሜ ኦቦሌስ ኬሞ ህዮሜ አለጋ ስ ወጅን ጅራቱት ዮካን ማቲ አለጋ ሰናት ኦፍ ጉርጉሬ፣ ");
INSERT INTO gaze_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","እን ኤርገ ኦፍ ጉርጉሬ ቦዴ ፉረሙፍ ምርገ ቀበ። ፍሮተሳ ኬሳስ ነምን ቶኮ እሰ ፉሩ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","ኦቦሌስ አባሳ ዮካን እልም ኦቦሌሰ አባሳ ዮካን ኣንቴሳ ኬሳ ፍር ዺጋ እሰ ፉሩ ደንደአ። ዮካን እንዩ ዮ ሶሮሜ ኦፍ ፉሩ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","እኒፊ ነምች እሰ ብቴ ሱን ወጋ እን እት ኦፍ ጉርጉሬ ጀልቀቤ ሀመ ወጋ እዮቤልዩት ሃለካአን። ገቲን ፉሪሳስ ባይእነ ወጎተ ሰናረት ሁንዳአ፤ ዬሮን እን ነምቸ እሰ ብተቴ ሰነ ብረ ቱሬሞ አከ ነመ ቀጨረሜ ሆጄቴ ቶኮት ሄሬገመ። ");
INSERT INTO gaze_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","ዮ አከ ሄሬገሳኒት ወጎትን ባይኤን ሀፈን እን ገቲ እቲን ብተሜ ሰነ ኬሳ ሀርከ ባይኤ ነምቸ ሰናፍ ዴብሱ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","ዮ ወጎትን ሀመ ወጋ እዮቤልዩት ሀፈን ሙራሰ ተአን እን ወጎተ ሀፈን ሰነ ሄሬገቴ ገቲ ፉረመሳ ሃከፈሉ። ");
INSERT INTO gaze_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","እን አኩመ ነመ ወጋ ወጋት ቀጠረሙ ቶኮት እሰ ወጅን ሃጅራቱ፤ ፉለኬ ዱረትስ እን ገረ ጀብናን እሰ ህንቡልችን። ");
INSERT INTO gaze_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘ዮ እን ከራ ከኔኒን ፉረሙ ባቴስ እኒፊ እጆሌንሳ ወጋ እዮቤልዩት ፉረሙ ቀቡ፤ ");
INSERT INTO gaze_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","እስራኤሎን ገርቦተኮቲ። እሳን ገርቦተኮ ከኔን አን ብየ ግብጢ ባሴ ፍዴዸ። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘ዋቆተ ቶልፈሞ ህንቶልፈትና፤ ፈኪ ዮካን ዸጋ ዋቄፈትና ህንዻበትና፤ ፉለሳኒ ዱረት ሰገዱፍ ጄተኒስ ብየኬሰን ኬሰት ዸጋ ሶፈሜ ህንዻብና። አን ዋቀዮ ዋቀኬሰን። ");
INSERT INTO gaze_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘ሰንበቶተኮ ኤጋ፤ እዶ ቁልቁሉኮስ ከበጃ። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘ዮ እስን ስርነኮ ዱካ ቡተኒ አጀጀወንኮስ ኤግደኒ ሆጂረ ኦልችተን፣ ");
INSERT INTO gaze_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","አን ዬሮሳት ቦካ እስኒፈን ኬነ፤ ለፍት ምዻንሼ፣ ሙኬን ድሬስ እጀሳኒ ንኬኑ። ");
INSERT INTO gaze_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","ምዻን ዸአቹንኬሰን ሀመ ዬሮ እጀ ወይኒ ጭረተኒት እት ፉፈ፤ እጀ ወይኒ ጭረቹንኬሰን ሀመ ዬሮ ፈጫሳት እቱመ ፉፈ፤ እስንስ ኛተኬሰን ሀመ ቁፍተንት ኛተኒ ለፈኬሰንረ ነጋዻን ጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘አን ብየቲ ኬሰ ነጋ ነንቡሰ፤ እስን ንረፍቱ፤ ወን ቶኮዩ እስን ህንሶዳችሱ። ብየቲ ኬሳ ብኔንሶተ ሀሞ ነንባሰ፤ ጎራዴንስ ብየኬሰን ኬሰ ህንደርቡ። ");
INSERT INTO gaze_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","እስን ዲኖተኬሰን ንአሪቱ፤ እሳንሞ ጎራዴዻን ፉለኬሰን ዱረት ዹሙ። ");
INSERT INTO gaze_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","እስን ነመ ሸን ታተኒ ነመ ዽበ ቶኮ አሪቱ፤ ዽበ ቶኮ ታተኒሞ ኩመ ኩዸን አሪቱ፤ ዲኖትንኬሰን ጎራዴዻን ፉለኬሰን ዱረት ዹሙ። ");
INSERT INTO gaze_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘አን ፉለ ቶላዻን ገረኬሰን እላሌ አከ እስን ሆርተኒ ባይአተን ነንጎዸ፤ ከኩ እስን ወጅን ቀቡስ ነንጀቤሰ። ");
INSERT INTO gaze_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","እስን ምዻን በረ ደርቤ ኛቻ ኡቱ እን ጎምብሳ ኬሳ ህንዹምን፣ ምዻን ሃራዻፍ እዶ ቆጴሱፍ ጄተኒ ምዻን በረ ደርቤ ሰነ ገድ ባፍቱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","እዶ ጅሬኘኮቲ እስን ግዱ ነንጎዸዸ፤ ሉቡንኮስ እስን ህንበልፍቱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","አን እስን ግዱ ጅራዼ ዋቀኬሰን ነንተአ፤ እስንስ ሰበኮ ንታቱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","አን ዋቀዮ ዋቀኬሰን ከን አከ እስን ለመተ ገርቦተ ወረ ግብጥ ህንታኔፍ ብየ ግብጢ ባሴ እስን ፍዴዸ፤ አን ህዻ ዋንጆኬሰኒ ኩቴ አከ እስን መታ ኦል ቀበተኒ ዴምተን ጎዼረ። ");
INSERT INTO gaze_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘ገሩ ዮ ነ ዸገኡ ድደኒ አጀጀወን ከኔን ሁንደ ኤጉ ባተን፣ ");
INSERT INTO gaze_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","ዮ ስርነኮ ቱፈተኒ ሴረኮ በልፍተን፣ ዮ አጀጀወን ከኔን ሁንደ ኤጉ ባተኒ ከኩኮ ጨብስተን፣ ");
INSERT INTO gaze_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","አን ወንቶተ ከኔን እስንትን ፍደ፦ እሳንስ ናሱ፣ ዹኩበ ነመ ሁቅሱ፣ ዹኩበ ዸግነ ነመ ጉቡ ከን አገርቱ ነማ በሌሴ ጅሬኘ ነማ ጎግሱ እስንት ነንፍደ። እስን አከሱማን ምዻን ፈጫፈቱ፤ ዲኖተኬሰንቱ ኛታቲ። ");
INSERT INTO gaze_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","አከ እስን ዲኖተኬሰኒን ሞአምተኒፍ አን ፉለ እስንተን ሀማዸ፤ ወር እስን ጅበን እስን ቡልቹ፤ እስን ኡቱ ኤኙዩ እስን ህንአርእን ንበቀቱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘ዮ እስን ወንቶተ ከኔን ሁንደ ቦዴ ና አጀጀሙ ድደን አን ጩቡኬሰኒፍ ደቻ ቶርበ እስን አደበ። ");
INSERT INTO gaze_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","ኦፍ ቱሉማ ሁምነኬሰኒ ነንጨብሰ፤ ሰሚኬሰን አከ ስቢላ፣ ለፈኬሰንሞ አከ ናሲ ነንጎዸ። ");
INSERT INTO gaze_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","ሁምንኬሰን አከሱማን በደ፤ ለፍትኬሰን ምዻንሳ፣ ሙኬንስ እጀሳኒ ህንኬነኒቲ። ");
INSERT INTO gaze_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘ዮ እስን ናን ሞርምተኒ ነ ዸገኡ ድደን፣ አን አኩመ ጩቡኬሰኒት ዸእቸ ደቻ ቶርበ እስንት ነንፍደ። ");
INSERT INTO gaze_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","አንስ ብኔንሶተ ቦሶና እስንተን ኤርገ፤ እሳንስ እጆሌኬሰን እስን ጀላ ንቡተቱ፤ ሆሪኬሰን ንበርበዴሱ፤ ባይእንኬሰን ንጥናተ፤ ዳንዲወንኬሰንስ ዱዋ ሀፉ። ");
INSERT INTO gaze_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘ዮ እስን ዋን ከኔኒን ዴብኡ ድደኒ ናን ሞርሙኬሰን እት ፉፍተን ገሩ፣ ");
INSERT INTO gaze_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","አን መታንኮ እስኒነን ሞርመ፤ ሰበቢ ጩቡኬሰኒቲፍስ ደቻ ቶርበ እስን ነንሚዸ። ");
INSERT INTO gaze_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","ከኩ ጨብሱኬሰኒፍስ ጎራዴ እስንት ፍዴ ሃሎ እስን ነንባፈዸ። ዮሙ እስን ገረ መጋላወንኬሰኒት በቀተንት አን ግዱኬሰንት ዸእቸ ነንኤርገ፤ እስንስ ደበርፈምተኒ ሀርከ ዲኖታት ኬነምቱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","ዮሙ አን መደ ቡዴነኬሰኒ ጎግሱት፣ ዱበርቶትን ኩዸን ኤሌ ቶኮት ቡዴነ ቶልቹ፣ እሳንስ ቡዴነ ሰነ መዳለኒ እስኒ ኬኑ፤ እስን ንኛቱ፤ ገሩ ህንቁፍተን። ");
INSERT INTO gaze_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘ዮ እስን ዋን ከናንስ ነ ዸገኡ ድደኒ ገሩ ናን ሞርሙት ፉፍተን፣ ");
INSERT INTO gaze_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","አንስ ኣሬ እስኒን ነንሞርመ፤ አን መታንኮ ሰበቢ ጩቡኬሰኒቲፍ ደቻ ቶርበ እስኒነን አደበ። ");
INSERT INTO gaze_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","እስን ፎን እልማንኬሰኒቲፊ ፎን እንተለንኬሰኒ ንኛቱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","እዶወን ሰገዳኬሰን በርበዴሴ እዶወን ኣርሳ እጣናኬሰን ነንጨጨብሰ፤ ሬፈኬሰንስ ዋቆተኬሰን ወረ ሉቡ ህንቀብኔ ሰነረ ነንቱለ፤ እስንስ ነንበልፈ። ");
INSERT INTO gaze_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","መጋላወንኬሰን ነንዲገ፤ እዶወን ቁልቁሉኬሰን ነንኦንሰ፤ ኡርጋኬሰን ገመቺሳስ ህንኡርጌፈዹ። ");
INSERT INTO gaze_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","አን አከ ዲኖትንኬሰን ከኔን አች ጅራተን ርፈተኒፍ ብየቲ ነንኦንሰ፤ ");
INSERT INTO gaze_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","አን ሰቦተ ግዱ እስን ነንብትኔሰ፤ ጎራዴኮ ሉቅፈዼስ እስን ነንአርአ። ብይኬሰን ንኦነ፤ መጋላወንኬሰንሞ ንዲገሙ። ");
INSERT INTO gaze_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","ብየቲንስ ዬሮ ኦንቴ እስን ብየ ዲኖተኬሰኒ ኬሰ ጅራተንት ሰንበተሼት ንገመድ፤ ለፍትስ ቦቆቴ ሰንበተሼት ገመድ። ");
INSERT INTO gaze_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","ብየቲን ዬሮ ኦንቴ ከነ ሁንደ ቦቆና ሰንበቶታ ከን ዬሮ እስን እሼረ ጅራተንት ህንአርገትን ንአርገት። ");
INSERT INTO gaze_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘ወረ እስን ኬሳ ሀፈን፣ አን ኡቱመ እሳን ብየ ዲኖተሳኒ ጅረኑ ገራ እሳኒት ናሱ ነንቡሰ። ሰገሌን ባለ ቅሌንስ ራሱ እሳን አርአ፤ ኡቱመ ነምን እሳን አርኡ ቶኮሌ ህንጅራትን እሳን አኩመ ዋን ጎራዴ ጀላ በቀተኒት ፊጉ፤ ንኩኩፉስ። ");
INSERT INTO gaze_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","ነምን እሳን አርኡ ጅራቹ ባቱሌ እሳን አኩመ ዋን ጎራዴ ጀላ በቀተኒት ወል ጉፈቺሱ። እስን ፉለ ዲኖተኬሰኒ ዱረ ዻበቹ ህንደንዴሰን። ");
INSERT INTO gaze_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","እስን ሰቦተ ኦርማ ግዱት ዹምቱ፤ ለፍት ዲኖተኬሰኒስ እስን ልቅምስት። ");
INSERT INTO gaze_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","ወር እስን ኬሳ ሀፈንሞ ሰበቢ ጩቡሳኒቲፍ ለፈ ዲኖተሳኒ ኬሰት በዱ፤ ሰበቢ ጩቡ አቦቲሳኒቲንስ ንበዱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘ገሩ ዮ እሳን ጩቡሳኒቲፊ ጩቡ አቦቲሳኒ ጄቹንስ ገንቱማፊ ደበ እሳን ነት ሆጄተን ");
INSERT INTO gaze_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","ከን አከ አን እሳኒን ሞርሙፊ አከ አን ብየ ዲኖተሳኒት እሳን ኤርጉ ህመተን፣ ዮ ገራንሳኒ ከን ዸግነ ህንቀበትን ሱን ገድ ኦፍ ዴብሴ እሳን ገቲ ጩቡሳኒቲፍ መሉ ባሰን፣ ");
INSERT INTO gaze_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","አን ከኩኮ ከነን ያቆብ ወጅን ገሌ፣ ከኩኮ ከነን ይስሃቅ ወጅን ገሌ፣ ከኩኮ ከነን አብረሃም ወጅን ገሌ ሰነ ነንያደዸ፤ ብየቲስ ነንያደዸ። ");
INSERT INTO gaze_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","ለፍት እሳን መሌ ሀፍት፤ ዬሮ እሳን መሌ ሀፍቱትስ ሰንበቶተሼት ንገመድ። እሳን ሰበቢ ሴረኮ ቱፈተኒ አጀጀኮስ በልፈኒፍ ገቲ ጩቡሳኒ ንባሱ። ");
INSERT INTO gaze_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","ተኡስ ኡቱ እሳን ብየ ዲኖተሳኒ ኬሰ ጅረኑ አን ከኩኮ ከነን እሳን ወጅን ገሌ ሰነ ጨብሴ ጉቱማን ጉቱት እሳን በሌሱፍ ጄዼ እሳን ህንቱፈዹ ዮካን እሳን ህንበልፉ። አን ዋቀዮ ዋቀሳኒት። ");
INSERT INTO gaze_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","ገሩ አን እሳኒፍ ጄዼ ከኩ አን አቦቲሳኒ ወረ አን ዋቀሳኒ ተኡፍ ኡቱ ሰቦትን አርገኑ ብየ ግብጢቲ ባሴ ፍዴ ሰነ ወጅን ገሌ ነንያደዸ። አን ዋቀዮ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","ኩኔን ለብሲወን፣ ሴረወኒፊ ቀጄልቸ ዋቀዮ ጋረ ሲናረት ሀርከ ሙሴቲን ኦፊሳቲፊ እስራኤሎተ ግዱት ባሴዸ። ");
INSERT INTO gaze_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“አከነ ጄዺ እስራኤሎተት ህም፦ ‘ነምን ዮ ገቲ ወል መዳሉ ኬኑዻን ዋቀዮፍ ነመ ኬኑፍ ወሬገ አዳ ጎዼ፣ ");
INSERT INTO gaze_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","ዺረ ኡሙሪንሳ ወጋ ድግደማ ሀመ ጃተማ ተኤፍ፣ አከ ሰፈርቱ ሰቅሊ እዶ ቁልቁሉት ሄሬግንሳ ሜቲ ሰቅሊ ሸንተመ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","ዮ ዱበርቲ ታቴሞ ሄሬግንሼ ሜቲ ሰቅሊ ሶዶመ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","ዮ ነመ ኡሙሪንሳ ወጋ ሸኒፊ ድግደመ ግዱ ተኤ፣ ሄሬግን ዺራ ሜቲ ሰቅሊ ድግደመት፣ ከን ዱበርቲሞ ሜቲ ሰቅሊ ኩዸንት ሃሄሬገሙ። ");
INSERT INTO gaze_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","ነመ ኡሙሪንሳ ጅአ ቶኮ ሀመ ወጋ ሸኒ ተኤሞ ሄሬግንሳ፣ ዺራፍ ሜቲ ሰቅሊ ሸን፣ ዱርባፍሞ ሜቲ ሰቅሊ ሰዲ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","ነምን ኡሙሪንሳ ወጋ ጃተመ ዮካን ሰና ኦል ተኤ ዺር ሜቲ ሰቅሊ ኩዸ ሸንት፣ ዱበርቲንሞ ሜቲ ሰቅሊ ኩዸንት ሃሄሬገሙ። ");
INSERT INTO gaze_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","ነምን ወሬገ ወሬጉ ህዮሜ ገቲ ሙርታኤ ሰነ ዮ ባሱ ደዸቤ፣ ሙሴን ነመ ሰነ ሉበት ሃፍዱ፤ ሉብንሞ አኩመ ደንዴቲ ነምቸ ወሬገ ወሬጌ ሰናት ገቲሳ ሃሄሬጉፍ። ");
INSERT INTO gaze_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘ወን ነምች ሱን ወሬጌ ሆሪ ፉለ ዋቀዮ ዱረት ኣርሳ ፉዸተመ ቀቡ ዮ ተኤ ሆሪን ዋቀዮፍ ኬነሜ ከን አከሲ ሁንድ ንቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","ነምችስ ሆሪ ሰነ ጌደሩ ዮካን ሆሪ ጋሪ ሆሪ ጅበማን ዮካን ሆሪ ጅበማ ሆሪ ጋሪ እዶ ህንቡስን፤ ዮ እን ሆሪ ቶኮ ሆሪ ብራ እዶ ቡሴ ሆሪን ለማኑ ቁልቁሉ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","ዮ ሆሪን እን ወሬጌ ሱን አከ ሴራት ጡራኣ ጄቹንስ ከን ዋቀዮፍ ኣርሳ ተኤ ዽኣቹ ህንደንዴኜ ተኤ ነምች ሱን ሆሪ ሰነ ገረ ሉበት ሃፍዱ፤ ");
INSERT INTO gaze_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","ሉብችስ አከ ሆሪን ሱን ጋሪ ዮካን ጅበማ ተኤ ሃመዳሉ። ገቲን ሉብን መዳሌ አከሱመ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","ነምች ሱን ዮ ሆሪ ሰነ ፉረቹ በርባዴ ገቲ ሄሬገሜ ሰነት ሀርከ ሸን ኬሳ ሀርከ ቶኮ እት ደበሉ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘ዮ ነምን ቶኮ መነ ኦፊ ዋቀዮፍ ቁልቁሌሴ፣ አከ መን ሱን ጋሪ ዮካን ገዼ ተኤ ሉብች ገቲሳ ሃሄሬጉ። ገቲን ሉብን መዳሌ አከሱመ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","ነምች መነሳ ዋቃፍ ቁልቁሌሴ ሱን ዮ መነ ኦፊ ፉረቹ በርባዴ፣ ገቲ ሄሬገሜ ሰነት ሀርከ ሸን ኬሳ ሀርከ ቶኮ እት ደበሉ ቀበ፤ መን ሱንስ ዴብኤ ከንሳ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘ዮ ነምን ለፈ ዻላን አርገቴራ ዋቀዮፍ ቁልቁሌሴ ገቲን ለፈ ሰና አኩመ ባይእነ ሰኚ ለፈ ሰናፍ በርባችሱት ጄቹንስ ገርቡን ሰፈርቱን ሆሜሪ ቶኮ ሜቲ ሰቅሊ ሸንተመት ሄሬገመ። ");
INSERT INTO gaze_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","ዮ እን ለፈ ቆቲሳሳ ወጋ እዮቤልዩ ኬሰ ቁልቁሌሴ ገቲን ዱራን ሄደሜ ሱን ህንጌደረሙ። ");
INSERT INTO gaze_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","ገሩ ዮ እን ወጋ እዮቤልዩ ቦዴ ለፈ ቆቲሳሳ ቁልቁሌሴ ሉብች አኩመ ባይእነ ወጎተ ሀመ ወጋ እዮቤልዩ እት ኣኑት ጅረኒት ሄሬገ፤ ገቲን ሸለገሜ ገድ ቡአ። ");
INSERT INTO gaze_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","ዮ ነምች ለፈ ቆቲሳሳ ዋቃፍ አዳን ባሱ ሱን ለፈ ቆቲሳሳ ፉረቹ በርባዴ፣ እን ገቲ ሄደሜት ሀርከ ሸን ኬሳ ሀርከ ቶኮ ሃደበሉ፤ ለፍት ቆቲሳ ሱንስ ዴብኤ ከንሳ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","ተኡስ ዮ እን ለፈ ቆቲሳ ሰነ ፉረቹ ባቴ፣ ዮካን ደበርሴ ነመ ብራት ጉርጉሬ፣ ለፍት ቆቲሳ ሱን ዴብኤ ፉረሙ ህንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","ለፍት ቆቲሳ ሱን ዮሙ ወጋ እዮቤልዩ ኬሰ ገድ ዺፈሙት አኩመ ለፈ ቆቲሳ ዋቀዮፍ ኬነሜት አዳን ባፈመ፤ ኩንስ ቀቤኘ ሉቦታ ተአ። ");
INSERT INTO gaze_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘ዮ ነምን ቶኮ ለፈ ቆቲሳ ዻላን ህንአርገን ከን ኦፊሳቲ ብተቴ ዋቀዮፍ ቁልቁሌሴ፣ ");
INSERT INTO gaze_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","ሉብን ገቲ ለፈ ቆቲሳ ሰና ሀመ ወጋ እዮቤልዩት ሄሬገ፤ ነምችስ ገቲ ሄሬገሜ ሰነ ጋፉመ ሰነ ከን ዋቀዮፍ ቁልቁሌፈሜ ጎዼ ሃባሱ። ");
INSERT INTO gaze_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","ወጋ እዮቤልዩትስ ለፍት ቆቲሳ ሱን ነምቹመራ ብተሜ ከን አባ ለፈ ቆቲሳ ሰና ቱሬፍ ንዴብአ። ");
INSERT INTO gaze_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","ገቲን ሁንድኑ አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ጄቹንስ ጌራን ድግደምን ሰቅሊ ቶኮት ሄሬገመ። ");
INSERT INTO gaze_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘ተኡስ ነምን ቶኮዩ ሆሪ ሀንገፈ ቁልቁሌሱ ህንደንደኡ፤ ሀንገፍት ዱራኑ ዋቀዮፍ ቁልቁሌፈሜራቲ፤ ሰንጋስ ተኡ ሆላን ሀንገፍን ከን ዋቀዮት። ");
INSERT INTO gaze_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","ዮ ሆሪን ሱን ጡራኣ ተኤ እን ገቲ ሄሬገሜረት ሀርከ ሸን ኬሳ ሀርከ ቶኮ ደበሌ ዴብሴ ብተቹ ደንደአ። ዮ እን ፉረቹ ባቴሞ ሆሪን ሱን ገቲ እሳፍ ሄሬገሜት ጉርጉረመ። ");
INSERT INTO gaze_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘ገሩ ወን ነምን ቀቡ ከን እን ዋቀዮፍ ቁልቁሌሱ ቶኮሌ ጄቹንስ ነመስ ተኡ ሆሪን ዮካን ለፍት ዻላን አርገሜ ህንጉርጉረሙ ዮካን ህንፉረሙ። ወን አከሲን ቁልቁሌፈሜ ሁንድኑ አከ መሌ ዋቀዮፍ ቁልቁሉዻቲ። ");
INSERT INTO gaze_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘ነምን አከ አጄፈሙፍ ሙርቴፈሜ ቶኮሌ ህንፉረሙ፤ እን አጄፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘ወን ለፍት ባፍቱ ከምዩ ሰኚስ ተኡ እጀ ሙካ ሀርከ ኩዸን ኬሳ ሀርክ ቶኮ ከን ዋቀዮት፤ ኩን ዋን ዋቀዮፍ ቁልቁሌፈሜዸ። ");
INSERT INTO gaze_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","ነምን ዮ ኬናሳ ከን ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ተኤ ሰነ ፉረቹ በርባዴ እን ገቲ ኬና ሰናፍ ሄሬገሜረት ሀርከ ሸን ኬሳ ሀርከ ቶኮ ደበሌ ሃባሱ። ");
INSERT INTO gaze_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","ኬናን ከረ ሎኒፊ ቡሻዬ ጉቱ ኬሳ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ተኤ ጄቹንስ ሆሪን ኡሌ ትክሴ ጀለ በኤ ደርቡ ሁንደ ኬሳ ሀርከ ኩዸን ኬሳ ሀርክ ቶኮ ዋቀዮፍ ቁልቁላአ። ");
INSERT INTO gaze_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","እን ሆሪ ጅበማ ኬሳ ሆሪ ጋሪ ህንፍለትን ዮካን እዶ ህንቡስን፤ ዮ እን እዶ ቡሴ ሆሪን ለማኑ ቁልቁሉ ተኡ፤ ፉረሙስ ህንደንደኡ።’ ” ");
INSERT INTO gaze_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","ኩኔን አጀጀወን ዋቀዮ ጋረ ሲናረት ከራ ሙሴቲን እስራኤሎታፍ ኬኔዸ። ");
INSERT INTO gaze_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","ኤርገ ሰብን እስራኤል ብየ ግብጢቲ በኤ ቦዴ ወጋ ለመፋ ኬሳ፣ ጉያ ጀልቀበ ጅአ ለመፋት ዋቀዮ ዱንካነ ወል ገኢ ኬሰት፣ ገሞጂ ሲና ኬሰት ሙሴት ዱበቴ። እንስ አከነ ጄዼን፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“ወልዳ ሰበ እስራኤል ሁንደ ለካኣቲ በልበለ በልበላኒፊ ማቲ ማቲዻን መቃ ዺሮታ ቶኮ ቶኮን በሬሳ። ");
INSERT INTO gaze_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","ነሞተ እስራኤል ኬሳ ዺሮተ ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንደ አቲፊ አሮን ኩታ ኩታ እሳኒቲን ለካኣ። ");
INSERT INTO gaze_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","ቶኮ ቶኮ ጎሳ ኬሳ ነምን ሀንገፈ ማቲ ኦፊሳ ተኤ እስን ገርጋሩ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“መቃን ነሞተ እስን ገርጋሩ ቀበኒ ከኔኒዸ፦ “ጎሰ ሩቤን ኬሳ ኤሊዙር እልመ ሼዴኡር፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","ጎሰ ስምኦን ኬሳ ሽሉሚኤል እልመ ዙሪሸዳይ፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","ጎሰ ይሁዳ ኬሳ ነህሾን እልመ አሚናዳብ፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","ጎሰ ይሳኮር ኬሳ ናትናኤል እልመ ዙዋር፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","ጎሰ ዜቡሎን ኬሳ ኤሊያብ እልመ ሄሎን፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","እልማን ዮሴፍ ኬሳ፦ ጎሰ ኤፍሬም ኬሳ ኤሊሻማ እልመ አሚሁድ፤ ጎሰ ምናሴ ኬሳ ገማልኤል እልመ ጴዳሱር፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","ጎሰ ቤንያም ኬሳ አቢዳን እልመ ጋዴዮን፣ ");
INSERT INTO gaze_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","ጎሰ ዳን ኬሳ አሂኤዜር እልመ አሚሸዳይ፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","ጎሰ ኣሼር ኬሳ ፈግኤል እልመ ኦክራን፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","ጎሰ ጋድ ኬሳ ኤልያሳፍ እልመ ዴኡኤል፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","ጎሰ ንፍታሌም ኬሳ አሂራ እልመ ኤናን።” ");
INSERT INTO gaze_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","ነሞትን ኩኔን ወረ ዱረ ቡኦተ ጎሶተ አቦቲሳኒ ተአኒ ወልዳ ሰነ ኬሳ ፍለተመኒዸ። እሳንስ ሀንገፎተ በልበለወን እስራኤል ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","ሙሴፊ አሮን ነሞተ መቃንሳኒ ኤረሜ ከኔን ፉዸተኒ፣ ");
INSERT INTO gaze_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ጉያ ጀልቀበ ጅአ ለመፋት ወልዳ ሁንደ ወልት ዋመን። ነሞትን ሱንስ አኩመ በልበላፊ ማቲሳኒት ህደ ዸሎተሳኒ ህመተን፤ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ መቃንሳኒ ቶኮ ቶኮን ገልሜፈሜ፤ ");
INSERT INTO gaze_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","እንስ አኩመ ዋቀዮ ሙሴ አጀጄት ገሞጂ ሲና ኬሰት ሰበ ሰነ ለካኤ። ");
INSERT INTO gaze_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","ሰኚ ሩቤን እልመ እስራኤል ሀንገፍትቻ ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት ቶኮ ቶኮን መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","ባይእን ጎሰ ሩቤን ነመ 46,500 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","ሰኚ ስምኦን ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት ቶኮ ቶኮን መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","ባይእን ጎሰ ስምኦን ነመ 59,300 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","ሰኚ ጋድ ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","ባይእን ጎሰ ጋድ ነመ 45,650 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","ሰኚ ይሁዳ ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","ባይእን ጎሰ ይሁዳ ነመ 74,600 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","ሰኚ ይሳኮር ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","ባይእን ጎሰ ይሳኮር ነመ 54,400 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","ሰኚ ዜቡሎን ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜወን በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","ባይእን ጎሰ ዜቡሎን ነመ 57,400 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","እልማን ዮሴፍ ኬሳ፦ ሰኚ ኤፍሬም ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","ባይእን ጎሰ ኤፍሬም ነመ 40,500 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","ሰኚ ምናሴ ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","ባይእን ጎሰ ምናሴ ነመ 32,200 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","ሰኚ ቤንያም ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","ባይእን ጎሰ ቤንያም ነመ 35,400 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","ሰኚ ዳን ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","ባይእን ጎሰ ዳን ነመ 62,700 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","ሰኚ ኣሼር ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲሳኒት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","ባይእን ጎሰ ኣሼር ነመ 41,500 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","ሰኚ ንፍታሌም ኬሳ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ሎለ ዸቁ ደንደአን ሁንድኑ አኩመ ገልሜ በልበላፊ ማቲ እሳንት መቃ መቃዻን በሬፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","ባይእን ጎሰ ንፍታሌም ነመ 53,400 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","ዺሮትን ኩኔን ወረ ሙሴፊ አሮን ሀንገፎተ እስራኤል ኩዸ ለማኒን ለካአመን ቱረን፤ ሀንገፎትን ኩኔንስ ቶኮን ቶኮንሳኒ እዶ ቡኦተ ማቲሳኒ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","እስራኤሎን ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን እስራኤል ኬሰት ሎላፍ በኡ ደንደአን ሁንድኑ አኩመ ማቲሳኒት ለካአመን። ");
INSERT INTO gaze_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","ወሉማ ገለት ባይእን ነማ 603,550 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","ሌዎትን ገሩ አከ ጎሰ አቦቲሳኒት ወረ ካን ወጅን ህንለካአምኔ። ");
INSERT INTO gaze_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","ዋቀዮ ሙሴዻን አከነ ጄዼ ቱሬ፦ ");
INSERT INTO gaze_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“አት ጎሰ ሌዊ ህንለካእን ዮካን ለኮብሰ ሰበ እስራኤሎተ ካኒት ህንደበልን። ");
INSERT INTO gaze_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","ቆደ ከና አከ ሌዎትን እት ጋፈተምቶተ ዱንካነ ዹገ በኡምሳ፣ ምአሳ ሁንዳፊ ዋን እን ቀቡ ሁንዳ ተአኒፍ እሳን ሙድ። እሳንስ ዱንካነ ቁልቁሉፊ ምአሳ ሁንደ ሃባተን፤ ዱንካንቸ ሃተጃጅለን፤ ናኖሳስ ሃቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","ዬሮ ዱንካን ቁልቁሉን ዴሙ ቀቡት ሌዎትን ዱንካነ ሰነ ሃቡቅሰን፤ ዬሮ ዱንካንች ዻበሙስ ሌዎትን ሃዻበን። ነምን ዱንካንቸት ዽኣቱ ብራ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","እስራኤሎንስ ቶኮን ቶኮን ነማ ቁበተሳ ኬሳፊ ፋጂሳ ጀለት ኩታ ኩታዻን ዱንካነሳኒ ሃዻበተን። ");
INSERT INTO gaze_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","ተኡስ ሌዎትን አከ ዼከምስ ዋቀዮ ወልዳ እስራኤልት ገድ ህንቡኔፍ ዱንካኖተሳኒ ናኖ ዱንካነ ዹገ በኡምሳ ሃዸዻበተን። ሌዎትን ኤጉምሰ ዱንካነ ዹገ በኡምሳት እት ጋፈተምቶተ ተኡ ቀቡ።” ");
INSERT INTO gaze_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","እስራኤሎን አኩመ ዋቀዮ ሙሴ አጀጄ ሰነት ዋን ከነ ሁንደ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","ዋቀዮ ሙሴፊ አሮኒን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“እስራኤሎንስ ቶኮን ቶኮን ነማ ፋጂ ኦፊሳኒ ጀለት ፋጂ ማቲሳ ወጅን ዱንካነራ ጥኑመ ፈጋቴ ናኖ ዱንካነ ወል ገኢ ሃቁበቱ።” ");
INSERT INTO gaze_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","ገመ በኣቲን፣ ከራ በአ ቢፍቱቲን፦ ኩታወን ቁበተ ይሁዳ ፋጂሳኒ ጀለ ሃቁበተን። ሆገናን እጆሌ ይሁዳ ነህሾን እልመ አሚናዳቢት። ");
INSERT INTO gaze_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","ለኮብስ ኩታሳስ ነሞተ 74,600። ");
INSERT INTO gaze_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","ጎስት ይሳኮር እሳንት ኣኔ ሃቁበቱ። ሆገናን እጆሌ ይሳኮር ናትናኤል እልመ ዙዋር ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","ለኮብስ ኩታሳስ ነሞተ 54,400። ");
INSERT INTO gaze_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","ጎስት ዜቡሎን ከነት ሃኣኑ። ሆገናን እጆሌ ዜቡሎን ኤሊያብ እልመ ሄሎኒት። ");
INSERT INTO gaze_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","ለኮብስ ኩታሳስ ነሞተ 57,400። ");
INSERT INTO gaze_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","ነሞትን ቁበተ ይሁዳት ለካአመን ሁንድስ አኩመ ኩታ ኩታሳኒት 186,400 ቱረን። እሳንስ ዱራን ዱርሰኒ ቀጄሉ። ");
INSERT INTO gaze_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","ገመ ክባቲን፦ ኩታወን ቁበተ ሩቤን ፋጂሳኒ ጀላን ሃቁበተን። ሆገናን እጆሌ ሩቤን ኤሊዙር እልመ ሼዴኡሪት። ");
INSERT INTO gaze_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","ለኮብስ ኩታሳስ ነሞተ 46,500። ");
INSERT INTO gaze_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","ጎስት ስምኦን እሳንት ኣኔ ሃቁበቱ። ሆገናን ጎሰ ስምኦን ሽሉሚኤል እልመ ዙሪሸዳዪት። ");
INSERT INTO gaze_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","ለኮብስ ኩታሳስ ነሞተ 59,300። ");
INSERT INTO gaze_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","ጎስት ጋድ እሳንት ሃኣኑ። ሆገናን ጎሰ ጋድ ኤልያሳፍ እልመ ዴኡኤሊት። ");
INSERT INTO gaze_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","ለኮብስ ኩታሳስ ነሞተ 45,650። ");
INSERT INTO gaze_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","ነሞትን ቁበተ ሩቤንት ለካአመን ሁንድስ አኩመ ኩታ ኩታሳኒት 151,450 ቱረን። እሳን ኩኔንስ ወረ ዱራት ኣነኒ ዴሙ። ");
INSERT INTO gaze_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","ኤርገሲስ ዱንካን ወል ገኢቲፊ ቁበን ሌዎታ ቁበተወን ግዱ ሃዴመን። እሳንስ አኩመ ቶረ ቁበተሳኒት ቶኮን ቶኮንሳኒ እዶሳኒ ኤገተኒ ፋጂሳኒ ጀለ ሃዴመን። ");
INSERT INTO gaze_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","ገመ ዽኣቲን ገሬን ቁበተ ኤፍሬም ፋጂሳኒ ጀላን ሃቁበተን። ሆገናን እልማን ኤፍሬም ኤሊሻማ እልመ አሚሁዲት። ");
INSERT INTO gaze_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","ለኮብስ ኩታሳስ ነሞተ 40,500፦ ");
INSERT INTO gaze_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","ጎስት ምናሴ እሳንት ሃኣኑ። ሆገናን እጆሌ ምናሴ ገማልኤል እልመ ጴዳሱሪት። ");
INSERT INTO gaze_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","ለኮብስ ኩታሳስ ነሞተ 32,200። ");
INSERT INTO gaze_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","ጎስት ቤንያም እት ሃኣኑ። ሆገናን እልማን ቤንያም አቢዳን እልመ ጋዴዮኒት። ");
INSERT INTO gaze_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","ለኮብስ ኩታሳስ ነሞተ 35,400፦ ");
INSERT INTO gaze_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","ነሞትን ቁበተ ኤፍሬምት ለካአመን ሁንድስ ኩታ ኩታሳኒት 108,100 ቱረን። እሳን ኩኔንሞ ኩታ ሰደፋ ተአኒ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","ገመ ካባቲን ኩታወን ቁበተ ዳን ፋጂሳኒ ጀላን ሃቁበተን። ሆገናን ጎሰ ዳን አሂኤዜር እልመ አሚሸዳዪት። ");
INSERT INTO gaze_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","ለኮብስ ኩታሳስ ነሞተ 62,700። ");
INSERT INTO gaze_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","ጎስት ኣሼር እሳንት ኣኔ ሃቁበቱ። ሆገናን እጆሌ አሴር ፈግኤል እልመ ኦክራኒት። ");
INSERT INTO gaze_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","ለኮብስ ኩታሳስ ነሞተ 41,500፦ ");
INSERT INTO gaze_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","ጎስት ንፍታሌም እት ሃኣኑ። ሆገናን እጆሌ ንፍታሌም አሂራ እልመ ኤናኒት። ");
INSERT INTO gaze_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","ለኮብስ ኩታሳስ ነሞተ 53,400፦ ");
INSERT INTO gaze_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","ነሞትን ቁበተ ዳኒት ለካአመን ሁንድስ 157,600 ቱረን። እሳንስ ዹመረት ፋጂሳኒ ጀላን ሃዴመን። ");
INSERT INTO gaze_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","ነሞትን ኩኔን ሰበ እስራኤል ወረ አኩመ ማቲሳኒት ለካአመኒዸ። ለኮብስ ወረ ቁበተ ኬሳ ከኔን ኩታ ኩታሳኒቲን ለካአመን ሁንዳ 603,550። ");
INSERT INTO gaze_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","ሌዎትን ገሩ አኩመ ዋቀዮ ሙሴ አጀጄ ሰነት እስራኤሎተ ካን ወጅን ህንለካአምኔ። ");
INSERT INTO gaze_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","አከሲን እስራኤሎን ዋን ዋቀዮ ሙሴ አጀጄ ሁንደ ሆጄተን፤ እሳንስ ሃሉመ ከናን ፋጂሳኒ ጀለ ሃቁበተን፤ ሃሉመ ከናንስ ቶኮን ቶኮንሳኒ በልበላፊ ማቲሳኒ ወጅን በአኒ ሃዴመን። ");
INSERT INTO gaze_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","ዬሮ ዋቀዮ ቱሉ ሲናረት ሙሴት ዱበቴት ሴናን ሰኚ አሮኒፊ ሙሴ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","መቃን እልማን አሮን፦ ናዳብ ሀንገፍትቸ፣ አቢሁ፣ ኤሌኣዛሪፊ ኢታማር። ");
INSERT INTO gaze_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","ኩኔን መቃወን እልማን አሮን ጄቹንስ ሉቦተ ሙደመን ከኔን አከ ሉቦተ ተአኒ ተጃጅለኒፍ ድበመን ሰናት። ");
INSERT INTO gaze_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","ናዳቢፊ አቢሁ ገሩ ዬሮ ገሞጂ ሲና ኬሰት እብደ ህንኤየመምን ፉለ ዋቀዮ ዱረት ዽኤሰንት ፉሉመሳ ዱረት ዱአን። እሳን እልማን ቶኮሌ ህንቀበን ቱሬ። ከናፉ ኤሌኣዛሪፊ ኢታማር በረ አባንሳኒ አሮን ሉቡን ጅራቴት ሉቦተ ተአኒ ተጃጅለን። ");
INSERT INTO gaze_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“ጎሰ ሌዊ ፍዲቲ አከ እሳን አሮን ሉብቸ ገርጋረኒፍ እሰ ዱረ ዻብ። ");
INSERT INTO gaze_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","እሳንስ ሆጂ ዱንካነ ቁልቁሉ ሆጄቹዻን ዋን እሰራ በርባደሙፊ ዋን ወልዳ ሁንደራ በርባደሙ ፉለ ዱንካነ ወል ገኢ ዱረት ሃራወተን። ");
INSERT INTO gaze_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","እሳን ሆጂ ዱንካነ ቁልቁሉ ሆጄተኒ ድርቀመ እስራኤሎታ ጉቱዻን ምአ ዱንካነ ወል ገኢ ሁንደ ሃኤገን። ");
INSERT INTO gaze_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","ሌዎተ ሰነ አሮኒፊ እልማንሳት ኬን፤ እሳን ወረ ሰበ እስራኤል ኬሳ ጉቱማን ጉቱት እሰት ኬነመኒዸ። ");
INSERT INTO gaze_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","አት አከ እሳን ሉቦተ ተአኒ ተጃጅለኒፍ አሮኒፊ እልማንሳ ሙድ፤ ነምን ብራ ከን እዶ ቁልቁሉ ሰነት ዽኣቱ ገሩ አጄፈሙ ቀበ።” ");
INSERT INTO gaze_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“ኩኖ አን እስራኤሎተ ኬሳ ቆደ ዺረ ሀንገፈ ዱበርቶተ እስራኤል ሁንዳ ሌዎተ ፉዸዼረ። ሌዎትን ከንኮት፤ ");
INSERT INTO gaze_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","ሀንገፍት ሁንድኑ ከንኮቲ። አን ዬሮ ብየ ግብጥ ኬሰት ሀንገፈ ሁንደ አጄሴት ሀንገፈ እስራኤል ሁንደ ጄቹንስ ነመስ ተኡ ሆሪ ኦፊኮቲፍ አዳን ባፈዼረ። እሳን ከንኮ ተአን። አን ዋቀዮ።” ");
INSERT INTO gaze_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","ዋቀዮ ገሞጂ ሲና ኬሰት ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“ሌዎተ ማቲሳኒቲፊ በልበለሳኒቲን ለካእ። ዺረ ጅአ ቶኮ ዮካን ሀመሲ ኦሊ ሁንደ ለካእ።” ");
INSERT INTO gaze_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","ሙሴን አኩመ ዱቢን ዋቀዮ እሰ አጀጄት እሳን ለካኤ። ");
INSERT INTO gaze_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","ኩኔን መቃወን እልማን ሌዊት፦ ጌርሾን፣ ቆሃቲፊ ሜራሪ። ");
INSERT INTO gaze_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","ኩኔን መቃወን እልማን ጌርሾኒት፦ ሎቤኒፊ ሽሜኢ። ");
INSERT INTO gaze_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","በልበለወን ቆሃቶታ፦ አምራም፣ ይዝሃር፣ ኬብሮኒፊ ኡዚኤል። ");
INSERT INTO gaze_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","በልበለወን ሜራሮታ፦ መህሊፊ ሙሲ። ");
INSERT INTO gaze_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","በልበለወን ሊብኒፊ ሽሜኢ ከን ጌርሾን ቱረን፤ እሳንስ በልበለወን ጌርሾኖታት። ");
INSERT INTO gaze_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","ባይእን ዺሮተ ኡሙሪንሳኒ ጅአ ቶኮፊ ሀመሲ ኦሊ ከኔን ለካአመን ሁንዳ 7,500 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","በልበለወን ጌርሾኖታ ከራ ልጠ ቢፍቱቲን ዱንካነ ቁልቁሉ ዱግደ ዱባን ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","ሆገናን በልበለወን ጌርሾኖታስ ኤልያሳፍ እልመ ላኤል ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","እት ጋፈተምን ጌርሾኖትን ዱንካነ ወል ገኢ ኬሰት ቀበንስ ዱንካነ ቁልቁሉ፣ ዱንካናፊ እረ ቡሳሳ፣ ጎልጋ በልበለ ዱንካነ ወል ገኢረ ጅሩ፣ ");
INSERT INTO gaze_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","ጎልጋወን ኦብዲ፣ ጎልጋ በልበለ ደላ ከን ዱንካነ ቁልቁሉፊ እዶ ኣርሳት ናነኤ ጅሩ፣ ፉኞፊ ተጃጅለ አከና ኬኑ ሁንደ ኤጉ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","በልበለወን አምራሞታ፣ ይዝሃሮታ፣ ኬብሮኖታፊ ኡዚኤሎታ በልበለወን ቆሃቲት፤ እሳንስ በልበለወን ቆሃቶታ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","ባይእን ዺሮተ ጅአ ቶኮፊ ሀመሲ ኦሊ ሁንዳ 8,600 ቱሬ። ቆሃቶትን እዶ ቁልቁሉ ሰነ ኤጉት እት ጋፈተምቶተ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","በልበለወን ቆሃቶታ ከራ ክበ ዱንካነ ቁልቁሉቲን ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","ሆገናን ማቲወን በልበለወን ቆሃቶታስ ኤሊሳፋን እልመ ኡዚኤል ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","እሳንስ ታቦተ፣ ምንጃለ፣ ባቱ እብሳ፣ እዶወን ኣርሳ፣ ምአ እዶ ቁልቁሉ እቲን ተጃጅለን፣ ጎልጋፊ ወንቶተ ተጃጅለ አከና ኬነን ሁንደ ኤጉት እት ጋፈተምቶተ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","ሆገናን ሌዎታ ሀንገፍት ኤሌኣዛር እልመ አሮን ሉብቻ ቱሬ። እንስ ወረ እት ጋፈተምቶተ ኤጉምሰ እዶ ቁልቁሉ ቱረን ሰነረት ድበሜ። ");
INSERT INTO gaze_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","በልበለወን መሄሎታፊ ሙሶታ ከን ሜራሪ ቱረን፤ እሳንስ በልበለወን ሜራሮታት። ");
INSERT INTO gaze_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","ባይእን ዺሮተ ኡሙሪንሳኒ ጅአ ቶኮፊ ሀመሲ ኦሊ ከኔን ለካአመን ሁንዳ 6,200 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","ሆገናን ማቲወን በልበለወን ሜራሮታስ ዙሪኤል እልመ አቢሃይሊት፤ እሳንስ ከራ ካበ ዱንካነ ቁልቁሉማቲን ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","ሜራሮንስ ቱጌወን ዱንካነ ቁልቁሉ፣ ደገሌወንሳ፣ ኡቱባወንሳ፣ ሚለወንሳ፣ ምአሳ ሁንዳፊ ወንቶተ ተጃጅለ አከና ኬነን ሁንደ፣ ");
INSERT INTO gaze_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","አከሱመስ ኡቱባወን ኦብዲ ሰነት ናነአኒ ጅረን፣ ሚለወንሳኒ፣ ቆፎ ዱንካናፊ ፉኞወንሳ ኤጉፍ ሙደመን። ");
INSERT INTO gaze_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","ሙሴን፣ አሮኒፊ እልማን አሮን ዱንካነ ቁልቁሉራ ከራ በኣ፣ ቅጠ በአ ቢፍቱቲን ፉለ ዱንካነ ወል ገኢ ዱረ ቁበተን። እሳንስ እዶ እስራኤሎታ ቡአኒ እዶ ቁልቁሉ ኤጉት እት ጋፈተምቶተ ቱረን። ነምን ብራ ከን እዶ ቁልቁሉ ሰነት ዽኣቱ ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","ሌዎትን ለካአመን ሁንድ ከኔን ሙሴፊ አሮን አጀጀ ዋቀዮቲን አኩመ በልበለ በልበለሳኒት ለካአን፣ ዺሮትን ጅአ ቶኮፊ ሀመሲ ኦሊ ሁንድ 22,000 ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ዺሮተ እስራኤል ሀንገፎተ ከኔን ጅአ ቶኮቲፊ ሀመሲ ኦሊ ሁንደ ለካኢ መቃሳኒ በሬስ። ");
INSERT INTO gaze_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","ቆደ እጆሌ እስራኤል ከኔን ሀንገፈ ተአን ሁንዳ ሌዎተ ና ፉዸዹ፤ ቆደ እልማን ሀንገፈ ሆሪ እስራኤሎታ ሁንዳስ ሆሪ ሌዎታ ና ፉዸዹ። አን ዋቀዮ።” ");
INSERT INTO gaze_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","ሙሴን አኩመ ዋቀዮ እሰ አጀጄት ሀንገፎተ እስራኤል ሁንደ ለካኤ። ");
INSERT INTO gaze_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","ዺሮትን ሀንገፎትን ጅአ ቶኮፊ ሀመሲ ኦሊ ከኔን መቃ መቃን በሬፈመን ሁንዲ 22,273 ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“ቆደ እጆሌ እስራኤል ከኔን ሀንገፈ ተአን ሁንዳ ሌዎተ ፉዸዹ፤ ቆደ ሆሪ እስራኤሎታስ ሆሪ ሌዎታ ፉዸዹ። ሌዎትን ከንኮት። አን ዋቀዮ። ");
INSERT INTO gaze_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","እስራኤሎተ ሀንገፎተ 273 ከኔን ባይእነ ሌዎታ ጫለን ፉሩፍ፣ ");
INSERT INTO gaze_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","ቶኮ ቶኮሳኒቲፍ አኩመ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ሸን ሸን ፉዽ፤ ሰቅሊን ቶኮ ጌራ ድግደመ። ");
INSERT INTO gaze_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","ማለቀ እስራኤሎተ ደበለመን ፉሩፍ ፉዸሜ ሰነስ አሮኒፊ እልማንሳት ኬን።” ");
INSERT INTO gaze_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","ሙሴን ማለቀ ሰነ እስራኤሎተ ለኮብሳን ወረ ሌዎታን ፉረመኒን ኦል ተአን ሰነራ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","እንስ አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሜቲ ሰቅሊ 1,365 ኡልፋቱ እስራኤሎተ ሀንገፈራ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","ሙሴንስ አኩመ ዱቢ ዋቀዮት፣ አኩመ ዋቅን ሙሴ አጀጄት ማለቀ ፉሪ ሰነ አሮኒፊ እልማንሳት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","ዋቀዮ ሙሴፊ አሮኒን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“ሌዎተ ኬሳ ጎሰ ቆሃቶታ በልበለ በልበላፊ ማቲ ማቲሳኒቲን ለካእ። ");
INSERT INTO gaze_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","ዺሮተ ኡሙሪንሳኒ ወጋ ሶዶማ ሀመ ሸንተማ ከኔን ሆጂ ዱንካነ ወል ገኢ ሆጄቹፍ ዹፈን ሁንደ ለካእ። ");
INSERT INTO gaze_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“ሆጂን ቆሃቶትን ወንቶተ ዋን ሁንደ ጫላ ቁልቁሉ ተአኒን ወል ቀበቴ ዱንካነ ወል ገኢ ኬሰት ሆጄተን ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","ዮሙ ቁበን ዴሙፍ ከኡት አሮኒፊ እልማንሳ ኦል ገለኒ ጎልጋ ደኤሱ ሰነ ገድ ሃቡሰን፤ ጎልጋ ሰናንስ ታቦተ ከኩ ሴራት ሃሀጉገን። ");
INSERT INTO gaze_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","ዋን ከነትስ ጎጋ ዱገሜ ኡፍሰኒ ሁጩ ብፍትሳ ጉቱማን ጉቱት ጩቁሊሰ ተኤ እራን ሃአፈን። ደንቀራወንስ እዶ እዶሳኒ ኬሰ ሃገልቸን። ");
INSERT INTO gaze_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“እሳንስ ሁጩ ብፈ ጩቁሊሳ ቶኮ ምንጃለ ቡዴነ እላልቻት ኡፍሰኒ ገበቴ፣ ጫቢፊ ወጪቲ አከሱመስ ኦኮቴ እቲን ዽባዩ ዽኤሰን እሰረ ሃካአን፤ ቡዴን ዬሮ ሁንደ አቺ ህንዸበምኔ ሱንስ እሰረ ሃካአሙ። ");
INSERT INTO gaze_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","ሁጩ ብልዲማ እሳንረ ሃድሪርሰን፤ ጎጋ ዱገሜ እት ሃኡውሰን፤ ደንቀራወንሳስ እዶሳኒ ኬሰ ሃገልቸን። ");
INSERT INTO gaze_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“ሁጩ ብፍትሳ ጩቁሊሳ ፉዸኒ ባቱ እብሳ ከን እብሱፍ ቶልቸሜ እብሳሳ ወጅን፣ ዋን እቲን ፎኣ እብሳ ኩተኒፊ ባቱ ዳራ፣ ሜሻወን ዘይቲ ከኔን ሆጂ ከናፍ ኦለን ሁንደስ እቲን ሃሀጉገን። ");
INSERT INTO gaze_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","ኤርገሲስ ዋን ከናፊ ምአሳ ሁንደ ጎጋ ዱገሜን መረኒ ወሳሳ እቲን ዋ ባተንረ ሃካአን። ");
INSERT INTO gaze_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“ሁጩ ብፍቲሳ ጩቁሊሰ ተኤስ እዶ ኣርሳ ከን ወርቄራ ሆጄተሜት ኡፍሰኒ ጎጋ ዱገሜ እት ሃሀጉገን፤ ደንቀራወንሳስ እዶሳኒ ኬሰ ሃገልቸን። ");
INSERT INTO gaze_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“ሜሻወን እቲን እዶ ቁልቁሉ ኬሰ ተጃጅለን ሁንደስ ፉዸኒ ሁጩ ብፈ ጩቁሊሳቲን መረኒ ጎጋ ዱገሜን ሀጉገኒ ወሳሳ እቲን ዋ ባተንረ ሃካአን። ");
INSERT INTO gaze_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“እሳንስ እዶ ኣርሳራ ዳራ ሀረኒ ሁጩ ዲማ ዺልጌ እት ሃኡፍሰን። ");
INSERT INTO gaze_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","ኤርገሲስ ምአ እዶ ኣርሳ እቲን ተጃጅለን ሁንደ፣ ባቱ እብዳ፣ ቀብዱወን ፎኒ፣ ሜሻ እቲን ዳራ ሀማረኒፊ ወጪቲ እሰረ ሃካአን። ጎጋ ዱገሜ እሰ እራን ሃአፈን፤ ደንቀራወንሳስ እዶሳኒ ኬሰ ሃገልቸን። ");
INSERT INTO gaze_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“ኤርገ አሮኒፊ እልማንሳ ሜሻወን ቁልቁሉ ሰናፊ ምአ ቁልቁሉ ሁንደ ሀጉገኒ ፍጠኒ ቦዴ ዬሮ ቁበን ሱን ጎዳኑፍ ከኡት ቆሃቶትን ምአ ከነ ባቹዻፍ ሃዹፈን። እሳን ገሩ ምአ ቁልቁሉ ሰነ ህንቱቅን፤ ዮ ቱቀን ንዱኡቲ። ቆሃቶትን ዋን ዱንካነ ወል ገኢ ኬሰ ጅሩ ሁንደ ሃባተን። ");
INSERT INTO gaze_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“ኤሌኣዛር እልም አሮን ሉብቻ እት ጋፈተማ ዘይቲ እብሳ፣ እጣነ ኡርጋኣ፣ ኬና ምዻኒ ከን ዬሮ ባይኤ ዽኤፈሙፊ ዘይቲ እቲን ድበኒ ሃተኡ። እን ዱንካነ ቁልቁሉ ሁንዳፊ ዋን እሰ ኬሰ ጅሩ ሁንደት፣ ምኣፊ ሜሻወንሳ ቁልቁሉትስ እት ጋፈተማ ሃተኡ።” ");
INSERT INTO gaze_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","ዋቀዮ ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“በልበለወን ጎሰ ቆሃቲ ሌዎተ ኬሳ ህንበሌስና። ");
INSERT INTO gaze_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","አከ እሳን ዮሙ ወንቶተ ዋን ሁንደ ጫላ ቁልቁሉ ተአንት ዽኣተንት፣ አከ ሉቡን ጅራተን መሌ ህንዱኔፍ ዋን ከነ እሳኒፍ ጎዻ፦ አሮኒፊ እልማንሳ እዶ ቁልቁሉ ሴነኒ ዋን ቶኮን ቶኮን ነማ ሆጄቱፊ ባቱ ሃቆቆደን። ");
INSERT INTO gaze_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","ቆሃቶትን ገሩ አከ ህንዱኔፍ ዬሮ ጥናፍሌ ወንቶተ ቁልቁሉ እላሉዻፍ ኦል ሴኑ ህንቀበን።” ");
INSERT INTO gaze_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","ዋቀዮ ሙሴን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“ጌርሾኖተስ ማቲ ማቲሳኒፊ በልበለ በልበለሳኒቲን ለካእ። ");
INSERT INTO gaze_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","ዺሮተ ኡሙሪንሳኒ ወጋ ሶዶማ ሀመ ሸንተማ ከኔን ሆጂ ዱንካነ ወል ገኢ ሆጄቹ ዹፈን ሁንደ ለካእ። ");
INSERT INTO gaze_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“ተጃጅል በልበለወን ጌርሾኖታ ሆጂ ሆጄቹፊ በኣ ባቹዻን ተጃጅለን ከናዸ፦ ");
INSERT INTO gaze_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","እሳን ጎልጋ ዱንካነ ቁልቁሉ፣ ዱንካነ ወል ገኢ፣ ኡፈተሳፊ እረ ቡሳሳ ከን ጎጋ ዱገሜራ ሆጄተሜ፣ ጎልጋ በልበለ ዱንካነ ወል ገኢ፣ ");
INSERT INTO gaze_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","ጎልጋወን ደላ ዱንካነ ቁልቁሉፊ እዶ ኣርሳት ናነኤ ጅሩ ሰና፣ ጎልጋ በልበለሳ፣ ፉኞፊ ምአ ተጃጅለ ከናፍ ፈየዱ ሁንደ ባቱ። ጌርሹኖትን ዋን ወንቶተ ከናን ሆጄተሙ ቀቡ ሁንደ ሃሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","ተጃጅል ጌርሾኖታ ሁንድ በኣ ባቹስ ተኡ ሆጂን ብራ አጀጀ አሮኒፊ እልማንሳ ኬነኒን ሃአዴምስፈሙ። ዋን እሳን ባቹ ቀበን ሁንደስ አኩመ እት ጋፈተመሳኒት ቆቆዳፊ። ");
INSERT INTO gaze_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","ተጃጅል በልበለወን ጌርሾኖታ ዱንካነ ወል ገኢት ኬነን ከናዸ። ሆጂንሳኒስ ኢታማር እልመ አሮን ሉብቻቲን ሃቀጄልፈሙ። ");
INSERT INTO gaze_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“ሜራሮተ በልበለ በልበላፊ ማቲ ማቲሳኒቲን ለካእ። ");
INSERT INTO gaze_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","ዺሮተ ኡሙሪንሳኒ ወጋ ሶዶማ ሀመ ሸንተማ ከኔን ሆጂ ዱንካነ ወል ገኢ ሆጄቹፍ ዹፈን ሁንደ ለካእ። ");
INSERT INTO gaze_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","ወን እሳን ዬሮ ሆጂ ዱንካነ ወል ገኢ ሆጄተንት ጎዸን ከናዸ፦ ኩንስ ቱጌወን ዱንካነ ቁልቁሉ፣ ደገሌወንሳ፣ ኡቱቦታፊ ሚለወንሳኒ፣ ");
INSERT INTO gaze_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","ኡቱቦተ ኦብዲት ናነአኒ ጅረን ሚለወንሳኒ ወጅን፣ ቆፎወን ዱንካና፣ ፉኞወን፣ ምአሳኒ ሁንዳፊ ወንቶተ ሆጂ ከናፍ ፈየደን ሁንደ ባቹዸ። እስንስ ዋን ቶኮን ቶኮን ነማ ባቱ አዳን ባሳቲ ረመዳፊ። ");
INSERT INTO gaze_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","ተጃጅል በልበለወን ሜራሮታ ቀጄልፈመ ኢታማር እልመ አሮን ሉብቻ ጀለ ዱንካነ ወል ገኢ ኬሰት ኬነን ከናዸ።” ");
INSERT INTO gaze_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","ሙሴን፣ አሮኒፊ ሆገንቶትን ወልዳስ ቆሃቶተ በልበለ በልበላፊ ማቲ ማቲሳኒቲን ለካአን። ");
INSERT INTO gaze_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","ዺሮትን ኡሙሪንሳኒ ወጋ ሶዶማ ሀመ ሸንተማ ከኔን ሆጂ ዱንካነ ወል ገኢ ኬሳ ሰነ ኬሰ ሆጄቹፍ ዹፈን ሁንድ ");
INSERT INTO gaze_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","በልበለ በልበላን ለካአመኒ 2,750 ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","ኩን ለኮብሰ በልበለወን ቆሃቶተ ወረ ዱንካነ ወል ገኢ ኬሰ ሆጄቻ ቱረኒት። ሙሴፊ አሮን አኩመ አጀጀ ዋቀዮ ከን ከራ ሙሴቲን ኬነሜቲን እሳን ለካአን። ");
INSERT INTO gaze_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","ጌርሾኖትን በልበለ በልበላፊ ማቲ ማቲሳኒቲን ለካአመን። ");
INSERT INTO gaze_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","ዺሮትን ኡሙሪንሳኒ ወጋ ሶዶማ ሀመ ሸንተማ ከኔን ሆጂ ዱንካነ ወል ገኢ ኬሰ ሆጄቹፍ ዹፈን ሁንድ ");
INSERT INTO gaze_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","በልበለ በልበላፊ ማቲ ማቲሳኒቲን ለካአመኒ 2,630 ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","በልበለወን ጌርሾኖታ፣ ወር ሆጂ ዱንካነ ወል ገኢ ኬሰ ሆጄተን ከኔን ሙሴፊ አሮን አኩመ አጀጀ ዋቀዮት ለካአን ሁንድ ከኔኒዸ። ");
INSERT INTO gaze_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","ሜራሮንስ በልበለ በልበላፊ ማቲ ማቲሳኒቲን ለካአመን። ");
INSERT INTO gaze_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","ዺሮትን ኡሙሪንሳኒ ወጋ ሶዶማ ሀመ ሸንተማ ከኔን ሆጂ ዱንካነ ወል ገኢ ኬሰ ተጃጅሉ ዹፈን ሁንድ ");
INSERT INTO gaze_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","በልበለ በልበለሳኒቲን ለካአመኒ 3,200 ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","ወር በልበለወን ሜራሮታ ኬሳ ለካአመን ከኔን ሙሴፊ አሮን አኩመ አጀጀ ዋቀዮ ከን ከራ ሙሴቲን ኬነሜ ሰናት ለካአን ከኔኒዸ። ");
INSERT INTO gaze_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","ሙሴን፣ አሮኒፊ ሆገንቶትን እስራኤል ሌዎተ ሁንደ በልበለ በልበላፊ ማቲ ማቲሳኒቲን ለካአን። ");
INSERT INTO gaze_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","ዺሮትን ኡሙሪንሳኒ ወጋ ሶዶማ ሀመ ሸንተማ ከኔን ሆጂ ተጃጅላ ሆጄቹፊ ዱንካነ ወል ገኢ ባቹ ዹፈኒ ");
INSERT INTO gaze_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","ለካአመን ሁንድ 8,580 ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","እሳንስ አኩመ አጀጀ ዋቀዮ ከን ከራ ሙሴቲን ኬነሜቲን ቶኮን ቶኮንሳኒ ዋን ሆጄቹ ቀበንት ረመደመን፤ ወን እሳን ባቹ ቀበንስ እሳንት ህመሜ። አከሲን እሳን አኩመ ዋቀዮ ሙሴ አጀጄት ለካአመን። ");
INSERT INTO gaze_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“ነመ ዹኩበ ጎጋ ከን ነመት ደርቡ ቀቡ ዮካን ነመ ዸንገለኣ ዸግና ቀቡ ዮካን ነመ ሰበቢ ዋን ዱኤ ቶኮቲን ጡራኣ ተኤ ከምዩ አከ ቁበተ ኬሳ ባሰኒፍ ሰበ እስራኤል አጀጅ። ");
INSERT INTO gaze_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","ዺረስ ዱበርቲስ ገድ ባሳ፤ አከ እሳን ቁበተሳኒ እዶ አን ግዱሳኒ ጅራዹ ሰነ ህንጡሬስኔፍ ቁበተ ኬሳ እሳን ባሳ።” ");
INSERT INTO gaze_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","እስራኤሎንስ አከኑመ ጎዸኒ ቁበተ ኬሳ እሳን ባሰን። እሳንስ አኩመ ዋቀዮ ሙሴት ህሜ ሰነ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“ወረ እስራኤሊን አከነ ጄዽ፦ ‘ዮ ዺር ዮካን ዱበርቲን ቶኮ ከራ ከሚንዩ ነመ ካንት በሌሰ ሆጄቹዻን ዋቀዮ ዱረት አመነሙማ ዸቤ፣ ነምን ሱን የከማዸ፤ ");
INSERT INTO gaze_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","ጩቡ ሆጄቴስ ህመቹ ቀበ። የከሳቲፍስ ጉቱማን ጉቱት ሃኪሱ። ኪሲ ሰነረትስ ሀርከ ሸን ኬሳ ሀርከ ቶኮ ደበሌ ነምቸ ሚዸሜ ሰናፍ ሃኬኑ። ");
INSERT INTO gaze_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","ነምን የክ እሰረት ሆጄተሜ ሱን ዮ ፍረ ኣንቴ ከን ኪሲ ሰነ እሳፍ ፉዹ ቀባቹ ባቴ ገሩ ኪሲን ሱን ከን ዋቀዮት፤ ኮርቤሰ ሆላ እቲን አራር እሳፍ ቡፈሙ ወጅን ሉባፍ ሃኬነሙ። ");
INSERT INTO gaze_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","ቡሲወን ቁልቁሉን እስራኤሎን ሉበት ፍደን ሁንድ ከንሳት። ");
INSERT INTO gaze_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","ወንቶትን ቁልቁሉን ከኑመ አቦቲሳኒት፤ ወን እሳን ሉብቻፍ ኬነን ገሩ ከኑመ ሉብቻት።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","ኤርገሲ ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“አከነ ጄዺቲ ሰበ እስራኤልት ዱበዹ፦ ‘ዮ ኒቲን ነመ ከሚዩ ከራራ በዱዻን እሳፍ አመነሙ ባቴ ");
INSERT INTO gaze_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","ዺረ ብራ ወጅን ጪፍቴ፣ ዮ ዽርስሼስ ዋን ከነ ቤኩ ባቴ፣ ዮ ጡራኡማንሼ አኩመ ዾከቴት ሀፌ፣ ዮ ነምንሼረት ዹጋ በኡ ህንአርገምን፣ እሼን ዮ ዋን ከነረት ህንቀበምን፣ ");
INSERT INTO gaze_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","ዮ ዽርሰሼ ሀፉር ህናፋ ቀበቴ እን ኒቲሳ ሸኬ፣ ዮ እሼን ጡሮፍቱ ታቴ ዮካን ዮ እን ህናፌ እሼ ሸኬ እሼን ጡሮፍቱ ህንተእን፣ ");
INSERT INTO gaze_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","እን ኒቲሳ ሉበት ሃጌሱ። አከሱመስ እን ኬና ዳኩ ገርቡ ኢፊ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ቆደሼ ሃጌሱ። ኬናን ምዻኒ ከን ሰበቢ ህናፋቲፍ ዽኤፈሙ ኩን ዋን ኬና ያደኖ ከን የከ ያደቺሱ ተኤፍ፣ እን ዘይቲፊ እጣነ እት ነቁ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘ሉብችስ እሼ ፍዴ ፉለ ዋቀዮ ዱረ እሼ ሃዻቡ። ");
INSERT INTO gaze_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","ኤርገሲ እን ብሻን ቁልቁሉ ኦኮቴ ሱጴት ሃነቁ፤ ለፈ ዱንካነ ቁልቁሉራ ብዮ ፉዼ ብሻን ሰነ ኬሰ ሃቡሱ። ");
INSERT INTO gaze_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","ሉብችስ ኤርገ ዱበርቲ ሰነ ፉለ ዋቀዮ ዱረ ዻቤ ቦዴ ርፌንሰ መታሼ ሂኬ ኬና ያደኖ ጄቹንስ ኬና ምዻኒ ከን ህናፋፍ ዽኤፈሙ ሰነ ሀርከሼ ኬሰ ካአ፤ ብሻን ሀዻኣ አባርሰ ፍዱ ሰነስ ሀርከ ኦፊት ቀበተ። ");
INSERT INTO gaze_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","ሉብችስ ዱበርቲ ሰነ ንከከቺሰ፤ አከነስ ጄዻን፤ “ዮ ኡቱ አት ዽርሰ ቀብዱ ነምን ብራ ስ ወጅን ህንጪስኒፊ ዮ አት ከራራ በዴ ህንጡራእን ብሻን ሀዻኣን አባርሰ ፍዱ ኩን ስ ህንሚዽን። ");
INSERT INTO gaze_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","ገሩ አት ዮ ከራራ በዴ ኡቱ ዽርሰ ቀብዱ ነመ ዽርሰኬ ህንተእን ወጅን ጪፍቴ ኦፍ ጡሬስቴ አርገምቴ፤” ");
INSERT INTO gaze_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","ከነረት ሉብች ከካ አባርሳ እሼ ከከቺሰ፤ አከነስ ጄዻን፤ “ዋቀዮ ጉዴደኬ ቶርቶርሴ ገራኬሌ ቦኮክሴ ሰበኬ ግዱት ከካፊ አባርሳፍ ስ ሃጎዹ። ");
INSERT INTO gaze_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","አከ ገራንኬ ቦኮኩፊ አከ ጉዴድንኬ ቶርቶሩፍ ብሻን አባርሰ ፍዱ ኩን ዸግነኬ ሃሴኑ።” “ ‘ዱበርቲን ሱንስ፣ “አሜን፣ አሜን” ሃጄቱ። ");
INSERT INTO gaze_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘ሉብችስ አባርሰወን ሰነ ክታበ መረማረት ሃበሬሱ፤ ኤርገሲስ ብሻን ሀዻኣ ሰነትራ ሃዽቁ። ");
INSERT INTO gaze_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","እንስ አከ ዱበርቲን ሱን ብሻን ሀዻኣ አባርሰ ፍዱ ሰነ ዹግዱ ሃጎዹ፤ ብሻን አባርሳፊ ዽጵነ ሀማ ፍዱ ሱንስ እሼ ሴነ። ");
INSERT INTO gaze_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","ሉብችስ ኬና ምዻኒ ከን ህናፋ ሰነ እሼ ሀርካ ፉዼ ፉለ ዋቀዮ ዱረት ሶቾሴ ገረ እዶ ኣርሳ ፍደ። ");
INSERT INTO gaze_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","ሉብን ሱንስ ኬና ምዻኒ ሰነራ ኮኜ ቶኮ ኬና ያደኖቲፍ ፉዼ እዶ ኣርሳረት ሃጉቡ፤ ኤርገሲስ አከ ዱበርቲን ሱን ብሻን ሰነ ዹግዱ ሃጎዹ። ");
INSERT INTO gaze_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","ዮ እሼን ኦፍ ጡሬስቴ ዽርሰሼቲፍ አመነሙ ባቴ፣ ዮሙ እሼን ብሻን አባርሰ ፍዱ ሰነ ዹግዱት ብሻን ሱን እሼ ሴኔ ዽጵነ ሀማ እሼት ፍደ፤ ገራንሼ ንቦኮከ፤ ጉዴድንሼ ንቶርቶረ፤ እሼንስ ሰበሼ ብረት አባረምቱ ታት። ");
INSERT INTO gaze_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","ገሩ ዮ ዱበርቲን ሱን ኦፍ ጡሬሱ ባቴፊ ዮ ቁልቁሉ ታቴ እሼን የከራ ብልሰ ታት፤ ደኡስ ንደንዴስ። ");
INSERT INTO gaze_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘ዮ ዱበርቲን ኡቱመ ዽርሰ ቀብዱ ከራራ ጎርቴ ኦፍ ጡሬስቴ ");
INSERT INTO gaze_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","ዮካን ዮ ዺር ሰበቢ ኒቲ ኦፊ ሸኩፍ ሀፉር ህናፋ እሰ ቀበቴ፣ ሴር ህናፋፍ ኬነሜ ከናዸ። ሉብች ዱበርቲ ሰነ ፉለ ዋቀዮ ዱረ ዻቤ ሴረ ከነ ሁንደሼረት ሃራወቱ። ");
INSERT INTO gaze_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","ዽርስ ሱን በሌሳራ ብልሰ ተአ፤ ዱበርቲን ሱን ገሩ ገቲ ጩቡሼ አርገት።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“አከነ ጄዺ ሰበ እስራኤልት ዱበዹ፦ ‘ዺር ዮካን ዱበርቲን ቶኮ ዮ ዋቀዮፍ አዳን ኦፍ ባሱፍ ወሬገ አዳ ዮካን ወሬገ ናዝሩማ ወሬገን፣ ");
INSERT INTO gaze_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","ዳዺ ወይኒፊ ዹጋቲ ነመ መቼሱራ ኦፍ ሃኤገተን፤ ነምን ሱን ዸንገጋኣ ዳዺ ወይኒራ ሆጄተሜ ዮካን ዸንገጋኣ ዹጋቲ ነመ መቼሱ ብራ ህንዹግን። እን ጩንፋ ጉማ ወይኒ ዹጉ ዮካን እጀ ወይኒ አሼቲ ዮካን ጎጎጋሳ ኛቹ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","እንስ በረ ናዝሩማሳ ሁንደ ኬሰ ዋን ጉማ ወይኒራ አርገሙ ከምዩ ሰኚሳስ ተኡ ቆለሳ ኛቹ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘በረ ወሬገ አዳን ባፈሙሳ ሁንደ ኬሰ ቀረባን ቶኮዩ መታሳ ህንቱቅን። ሀመ ዬሮን እን እት ዋቀዮፍ አዳን ባፈሜ ሱን ጡሙረሙት እን ቁልቁሉ ሃተኡ፤ አከ ርፌንስ መታሳ ጉደቱፍስ ገድ ሃዺሱ። ");
INSERT INTO gaze_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘ናዝርች በረ ዋቀዮፍ አዳን ኦፍ ባሴ ሁንደ ኬሰ ሬፈት ዽኣቹ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","ሰበቢ መለቶን እን እቲን ዋቀዮፍ አዳን ባፈሜ መታሳረ ጅሩፍ ዮ አባንሳ ዮካን ሃትሳ፣ ኦቦሌስሳ ዮካን ኦቦሌቲንሳ ዱአንሌ እሳኒፍ ጄዼ አከ ሴራት ኦፍ ህንጡሬስን። ");
INSERT INTO gaze_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","እን በረ እት አዳን ባፈሜ ሰነ ሁንደ ኬሰ ከን ዋቀዮፍ ቁልቁሌፈሜዸ። ");
INSERT INTO gaze_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘ዮ ነምን ቶኮ እዶ ናዝርች ጅሩት አከ ተሳ ዱኤ አከሲን ርፌንሰ እን አዳን ባሴ ሰነ ጡሬሴ፣ እን ጉያ እት ቁልቁሌፈሙት ጄቹንስ ጉያ ቶርበፋት መታሳ ሃሃደቱ። ");
INSERT INTO gaze_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","ኤርገሲስ እን ጉያ ሰዴተፋት ጉጌ ለመ ዮካን ጉጌ ሶሶኬ ለመ በልበለ ዱንካነ ወል ገኢረት ሉበት ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","ሰበቢ እን እዶ ሬፍ ጅሩት አርገሙዻን ጩቡ ሆጄቴፍ ሉብች እሰ ቶኮ ኣርሳ ጩቡ፣ እሰ ካንሞ ኣርሳ ጉበሙ ጎዼ አራረ ቡሱፍ ሃዽኤሱፍ። ጉዩመ ሰነስ ርፌንሰ መታሳ አዳን ሃባሱ። ");
INSERT INTO gaze_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","እን ዬሮ እት አዳን ባፈሜ ኬሰ አመስ ዋቀዮፍ አዳን ኦፍ ሃባሱ፤ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤስ ኣርሳ የካ ጎዼ ሃፍዱ። ገሩ ሰበቢ እን ዬሮ አዳን በኢሰሳ ኬሰ ጡሬፈሜፍ ጉዮትን ደርበን ህንለካአመን። ");
INSERT INTO gaze_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘ኤጋ ዬሮ አዳን በኡምስሳ ጡሙረሙት ሴር ናዝርቻ ከናዸ፦ እን ገረ ከረ ዱንካነ ወል ገኢት ሃፍደሙ። ");
INSERT INTO gaze_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","አችት ኣርሳሳ ዋቀዮፍ ሃዽኤሱ፤ ኩንስ ጦባላ ኮርቤሰ ሆላ ህርእነ ህንቀብኔ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ኣርሳ ጉበሙፍ፣ ጦባላ ሆላ ዸልቱ ህርእነ ህንቀብኔ ከን ኡሙሪንሼ ወጋ ቶኮ ተኤ ኣርሳ ጩቡቲፍ፣ ኮርቤሰ ሆላ ህርእነ ህንቀብኔ ኣርሳ ነጋቲፍ፣ ");
INSERT INTO gaze_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","ከነ ወጅንስ መጥኖ ጉንዶ ቶኮ፣ መጥኖ ዳኩ ቡላኣራ ቶልፈሜ ከን ዘይቲዻን ሱኩመሜ፣ ብጥሌ ዘይቲን እረ ድበሜ አከሱመስ ኬና ምዻኒፊ ዽባዩሳኒ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘ሉብችስ ፉለ ዋቀዮ ዱረት እሳን ፍዴ ኣርሳ ጩቡቲፊ ኣርሳ ጉበሙ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","እንስ ኮርቤሰ ሆላ ሰነ መጥኖ ጉንዶረ ጅሩ ሰነ ወጅን ኣርሳ ነጋ ጎዼ ዋቀዮፍ ሃዽኤሱ፤ አከሱመስ ሉብች ኬና ምዻኒቲፊ ዽባዩሳ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘ኤርገሲ ናዝርች በልበለ ዱንካነ ወል ገኢ ዱረት ርፌንሰ አዳን ባሴ ሰነ ሃሃደቱ። ርፌንሰ ሰነስ ፉዼ እብደ ኣርሳ ነጋ ጀላን ጅሩ ሰነ ኬሰ ሃቡሱ። ");
INSERT INTO gaze_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘ኤርገ ናዝርች ርፌንሰ እቲን አዳን ባፈሜ ሰነ ሃደቴ ቦዴ ሉብን ሱን ፎን ገቲቲ ኮርቤሰ ሆላ ከን አፌለሜፊ መጥኖፊ ብጥሌ ህንቡካእን ጉንዶ ሰነራ ፉዼ ሀርከ ነምቻረ ሃካኡ። ");
INSERT INTO gaze_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","ኤርገሲስ ሉብች ኣርሳ ሶቾፈሙ ጎዼ ፉለ ዋቀዮ ዱረት እሳን ሃሶቾሱ፤ እሳንስ ሀንደራፈ ሶቾፈሜፊ ተፈ ዽኤፈሜ ሰነ ወጅን ሉብቻፍ ከን ቁልቁሌፈመኒዸ። ኤርገሲ ናዝርች ዳዺ ወይኒ ዹጉ ንደንደአ። ");
INSERT INTO gaze_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘ሴር ናዝርቸ ዋን ኬኑ ደንደኡ ካን ደበለቴ አኩመ አዳን በኡምሰሳት ኬናሳ ዋቀዮፍ ወሬጉ ቶኮ ከናዸ። እንስ አኩመ ሴረ ናዝርቻት ዋን ወሬጌ ሰነ ራወቹ ቀበ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“አሮኒፊ እልማንሳት አከነ ጄዺ ህም፤ ‘አክ እስን እት እስራኤሎተ ኤብፍተን ከናዸ። አከነ ጄዻኒ፦ ");
INSERT INTO gaze_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “ዋቀዮ ስ ሃኤብሱ፤ ስ ሃኤጉስ፤ ");
INSERT INTO gaze_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","ዋቀዮ ፉለሳ ሲፍ ሃእብሱ፤ ገራ ሲፍ ሃላፉ። ");
INSERT INTO gaze_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","ዋቀዮ ፉለሳ ገረኬት ሃዴብሱ፤ ነጋስ ሲፍ ሃኬኑ።” ’ ");
INSERT INTO gaze_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“አከስት እሳን መቃኮ ሰበ እስራኤልራ ካኡ፤ አንስ እሳን ነንኤብሰ።” ");
INSERT INTO gaze_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","ሙሴን ኤርገ ዱንካነ ቁልቁሉ ሰነ ዻቤ ፍጠቴ ቦዴ፣ ዱንካንቻፊ ምአሳ ሁንደ ድቤ፤ ንቁልቁሌሴስ። አከሱመስ እዶ ኣርሳቲፊ ምአሳ ሁንደ ድቤ ቁልቁሌሴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","ኤርገሲ ሆገንቶትን እስራኤል፣ ሀንገፎትን ማቲወኒ ከኔን ሆገንቶተ ጎሶታ ተአኒ ወረ ለካአመን ሰነ ቀጄልቸንስ ኬና ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","እሳንስ ጋሪወን ሀጉገመን ጀኣፊ ሰንጎተ ኩዸ ለመ ጄቹንስ ቶኮ ቶኮ ሆገንቶታራ ሰንጋ ቶኮ፣ ለመ ለመ ተአኒሞ ጋሪ ቶኮ ኬና ኦፊ ጎዸኒ ፉለ ዋቀዮ ዱረት ፍደን። ኬናወን ከኔንስ ዱንካነ ቁልቁሉ ሰነ ዱረት ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“አከ እሳን ሆጂ ዱንካነ ወል ገኢ ሆጄቹ ኬሰት ፈየደኒፍ ኬናወን ከኔን እሳን ሀርካ ፉዽ። ዋን ከነ አኩመ ሆጂን ቶኮ ቶኮ ነማ በርባዱት ሌዎተት ኬን።” ");
INSERT INTO gaze_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","ሙሴንስ ጋሪወኒፊ ሰንጎተ ሰነ ፉዼ ሌዎተት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","እንስ አኩመ ሆጂሳኒቲፍ መሉት ጋሪወን ለማፊ ሰንጎተ አፉር እልማን ጌርሾንት ኬኔ፤ ");
INSERT INTO gaze_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","ጋሪወን አፉሪፊ ሰንጎተ ሰዴት አኩመ ሆጂሳኒቲፍ መሉት እልማን ሜራርት ኬኔ። እሳን ሁንድኑ ቀጄልፈመ ኢታማር እልመ አሮን ሉብቻ ጀለ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","እልማን ቆሃት ገሩ ሰበቢ ምአ ቁልቁሉ ገቲቲት ባቹን ሆጂሳኒ ተኤፍ ሙሴን ሆማ እሳኒት ህንኬንኔ። ");
INSERT INTO gaze_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","ዬሮ እዶን ኣርሳ ድበሜት ሆገንቶትን ኬናወንሳኒ ኤበ እዶ ኣርሳቲፍ ፍደኒ እዶ ኣርሳ ዱረት ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","ዋቀዮ ሙሴዻን፣ “ዱረ ቡኣን ቶኮ ጉዩመ ቶኮ ኬናሳ ስርነ ኤበ እዶ ኣርሳ ሰናቲፍ ሃዽኤሱ” ጄዼ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","ነምን ጉያ ጀልቀባት ኬና ኦፊ ፍዴ ነህሾን እልመ አሚናዳብ ከን ጎሰ ይሁዳ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮፊ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ከን ቶኮን ቶኮንሳኒ አከ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","ጭልፋ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮፊ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","ጉያ ለመፋትስ ናትናኤል እልመ ዙዋር ዱረ ቡኣ ይሳኮርቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","ኬናን እን ፍዴስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","ጫቢ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮፊ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","ጉያ ሰደፋት ኤሊያብ እልመ ሄሎን ሀንገፈ እጆሌ ዜቡሎንቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮሮሚ ሬኤ ሸኒፊ ጦባላ ኮርቤዪ ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","ጉያ አፉረፋት ኤሊዙር እልመ ሼዴኡር ዱረ ቡኣ እጆሌ ሩቤንቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከን ቶኮ ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ጦባላ ኮርቤዪ ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","ጉያ ሸነፋት ሽሉሚኤል እልመ ዙሪሸዳይ ሆገና እጆሌ ስምኦንቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ፣ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","ጉያ ጀአፋት ኤልያሳፍ እልመ ዴኡኤል ዱረ ቡኣ እጆሌ ጋድቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከነ አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮሮሚ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","ጉያ ቶርበፋት ኤሊሻማ እልመ አሚሁድ ዱረ ቡኣ እጆሌ ኤፍሬምቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","ጉያ ሰዴተፋት ገማልኤል እልመ ጴዳሱር ሆገና እጆሌ ምናሴቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮሮሚ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","ጉያ ሰግለፋት አቢዳን እልመ ጋዴዮን ዱረ ቡኣ እጆሌ ቤንያምቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","ጉያ ኩዸነፋት አሂኤዜር እልመ አሚሸዳይ ዱረ ቡኣ እጆሌ ዳንቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ኮርቤዪ ሆላ ጥጥና ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","ጉያ ኩዸ ቶኮፋት ፈግኤል እልመ ኦክራን ሆገና እጆሌ ኣሼርቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","ጉያ ኩዸ ለመፋት አሂራ እልመ ኤናን ሆገና እጆሌ ንፍታሌምቱ ኬናሳ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","ኬናንሳስ ገበቴ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቶኮ፣ ወጪቲ ሜቲ ከን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ቶርባተመ ኡልፋቱ ቶኮ ከኔን ቶኮን ቶኮንሳኒ አኩመ ኬና ምዻኒት ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜን ጉተመን፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","ጡዌ ወርቄ ከን ሰቅሊ ኩዸን ኡልፋቴ እጣናን ጉተሜ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","ኣርሳ ጉበሙፍስ ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላ ሆላ ከን ኡሙሪንሳ ወጋ ቶኮ ተኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ቶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","ኣርሳ ነጋቲፍ ቀሉፍስ ሰንጎተ ለመ፣ ኮርቤዪ ሆላ ሸን፣ ኮርቤዪ ሬኤ ሸኒፊ ጦባላወን ሆላ ሸን ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","ኬናን ሆገንቶትን እስራኤል ጋፈ እዶን ኣርሳ ድበሜ ሰነ ስርነ ኤባቲፍ ዽኤሰን ከነ ቱሬ፤ እሳንስ ገበቴ ሜቲ ኩዸ ለመ፣ ወጪቲ ሜቲ ኩዸ ለማፊ ጡዌ ወርቄ ኩዸ ለመ፦ ");
INSERT INTO gaze_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","ቶኮን ቶኮንሳኒ ሜቲ ሰቅሊ ዽበ ቶኮፊ ሶዶመ ኡልፋቱ ቱሬ፤ ቶኮን ቶኮን ወጪቲ ሜቲ ሰቅሊ ቶርባተመ ኡልፋተ ቱሬ። ምእ ሜቲ ኩን አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ወሉማ ገለት ሰቅሊ ኩመ ለማፊ ዽባ አፉር ኡልፋተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","ጡዌወን ወርቄ ኩዸ ለማን ከኔን እጣናን ጉተመንስ ቶኮን ቶኮንሳኒ አከ መዳሊ ሰቅሊ እዶ ቁልቁሉት ሰቅሊ ኩዸን ኡልፋቱ ቱረን። ጡዌወን ወርቄ ወሉማ ገለት ሰቅሊ ዽበ ቶኮፊ ድግደመ ኡልፋቱ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","ባይእን ሆሪ ኣርሳ ጉበሙፍ ዽኤፈመኒ ወሉማ ገለት ጅቦተ ሎኒ ኩዸ ለመ፣ ኮርቤዪ ሆላ ኩዸ ለመ፣ ጦባላወን ሆላ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ተኤ ኩዸ ለመ ቱሬ፤ ኬናን ምዻኒስ እሳን ወጅን ዽኤፈሜረ። ኮርቤዪን ሬኤ ኩዸ ለመ ኣርሳ ጩቡቲፍ ዽኤፈመኒ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","ባይእን ሆሪ ኣርሳ ነጋቲፍ ዽኤፈመኒ ወሉማ ገለት ሰንጎተ ድግደሚ አፉር፣ ኮርቤዪ ሆላ ጃተመ፣ ኮርቤዪ ሬኤ ጃተማፊ ጦባላወን ሆላ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","ሙሴን ዮሙ ዋቀዮ ወጅን ዱበቹፍ ዱንካነ ወል ገኢ ኦል ሴኔት ቴሶ አራራ ከን ታቦተ ከኩ ሴራረ ጅሩን ኦልት ኪሩቤሊ ለማን ግዱዻ ሰገሌ እሰት ዱበቱ ዸገኤ። ዋቀዮ እሰ ወጅን ዱበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“አሮንት አከነ ጄዺ ዱበዹ፤ ‘ዬሮ አት እብሳወን ቶርበን ቀብሲፍቱት እሳን እዶ ባቱ እብሳ ፉለ ዱረ ጅሩ ሃእብሰን።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","አሮንስ አከሱመ ጎዼ፤ እንስ አኩመ ዋቀዮ ሙሴ አጀጄት አከ እሳን ፉለ ባቱ እብሳ ዱራን እፈ ኬነኒፍ እብሳወን ሰነ ቀብሲሴ። ");
INSERT INTO gaze_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","አክ እት ባቱን እብሳ ቶልፈሜ አከነ፦ ሚለሳራ ጀልቀቤ ሀመ ደራራሳት ወርቄ ቱመሜራ ሆጄተሜ። ባቱን እብሳ ሱን አኩመ ፈኬኘ ዋቀዮ ሙሴት አርግሲሴ ሰናት ሆጄተሜ። ");
INSERT INTO gaze_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","ዋቀዮ ሙሴዻን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“ሰበ እስራኤል ኬሳ ሌዎተ ፉዺ ቁልቁሌስ። ");
INSERT INTO gaze_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","እሳን ቁልቁሌሱፍስ ዋን ከነ ጎዽ፦ ብሻን ቁልቁላኡማ እሳንት ፈጫስ፤ አከ እሳን ዸግነሳኒ ጉቱ ሃደተኒ አከሲን ኡፈተ ኦፊ ሚጨተኒ ኦፍ ቁልቁሌሰን ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","እሳንስ ድብቸ ሎኒ ቶኮ ኬና ምዻኒ ከን ዳኩ ቡላኣ ዘይቲዻን ሱኩመሜ ወጅን ሃፉዸን፤ አትስ ድብቸ ሎኒ ለመፋ ኣርሳ ጩቡቲፍ ፉዽ። ");
INSERT INTO gaze_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","ሌዎተ ፉለ ዱንካነ ወል ገኢ ዱረት ዽኤሲቲ ወልዳ እስራኤሎታ ጉቱ ወልት ቀብ። ");
INSERT INTO gaze_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","ሌዎተስ ፉለ ዋቀዮ ዱረት ዽኤስ፤ ሰብን እስራኤል ሀርከሳኒ ሌዎተረ ሃካአን። ");
INSERT INTO gaze_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","አሮንስ አከ ሌዎትን ዋቀዮ ተጃጅሉ ደንደአኒፍ ሰበ እስራኤል ኬሳ ኣርሳ ሶቾፈሙ ጎዼ ፉለ ዋቀዮ ዱረት እሳን ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“ኤርገ ሌዎትን ሀርከሳኒ መታ ጅቦተ ሰናረ ካአኒ ቦዴ አት ሌዎታፍ አራራ ቡሱዻፍ ድብቸ ቶኮ ኣርሳ ጩቡ፣ ካንሞ ኣርሳ ጉበሙ ጎዺቲ ዋቀዮፍ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","አከ ሌዎትን ፉለ አሮኒፊ ፉለ እልማንሳ ዱረ ዻበተን ጎዽ፤ ኤርገሲስ ኣርሳ ሶቾፈሙ ጎዺቲ ዋቀዮት እሳን ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","ሃለ ከናን እስራኤሎተ ካን ኬሳ ሌዎተ አዳን ባስ፤ ሌዎትንስ ከንኮ ሃተአን። ");
INSERT INTO gaze_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“ኤርገ አት ሌዎተ ቁልቁሌስቴ ኣርሳ ሶቾፈሙ ጎቴ እሳን ዽኤስቴ ቦዴስ እሳን ሆጂ ዱንካነ ወል ገኢ ሆጄቹፍ ሃዹፈን። ");
INSERT INTO gaze_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","እሳን እስራኤሎተ ኬሳ ጉቱማን ጉቱት ናፍ ኬነሙ ቀቡ። አን ቆደ ሀንገፈ ሰበ እስራኤል ከን ገደሜሰ ሳቁ ሁንዳ ሌዎተ ኦፊኮቲፍ ፉዸዼረ። ");
INSERT INTO gaze_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","እስራኤል ኬሳ ዺር ሀንገፍን ሁንድ ነመስ ተኡ ሆሪን ከንኮት። አን ዬሮን ብየ ግብጥ ኬሰት ሀንገፈ ሁንደ አጄሴ ሰነ ኦፊኮቲፈን አዳን እሳን ባፈዼ። ");
INSERT INTO gaze_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","አን ቆደ እልማን እስራኤል ሀንገፎተ ሁንዳ ሌዎተ ፉዸዼረ። ");
INSERT INTO gaze_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","ዮሙ እስራኤሎን እዶ ቁልቁሉት ዽኣተንት አከ ዸእች እሳን ህንአርገኔፍ፣ አከ እሳን እስራኤሎታፍ አራረ ቡሰኒፊ አከ እሳን ተጃጅለ እስራኤሎታ ዱንካነ ወል ገኢ ኬሰት ራወተኒፍ አን ሌዎተ ሰበ እስራኤል ሁንደ ኬሳ አሮኒፊ እልማንሳቲፍ ኬና ጎዼ ኬኔረ።” ");
INSERT INTO gaze_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","ሙሴን፣ አሮኒፊ ወልዳን እስራኤል ጉቱን አኩመ ዋቀዮ ሙሴ አጀጄ ሰነ ሌዎተስ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","ሌዎትንስ ኦፍ ቁልቁሌሰኒ ወያ ኦፊ ሚጨተን። አሮንስ አኩመ ኣርሳ ሶቾፈሙት ፉለ ዋቀዮ ዱረት እሳን ዽኤሴ፤ እሳን ቁልቁሌሱፍስ አራረ እሳኒፍ ቡሴ። ");
INSERT INTO gaze_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","ኤርገሲ ሌዎትን ቀጄልቸ አሮኒፊ እልማንሳቲን ሆጂ ዱንካነ ወል ገኢ ሆጄቹዻፍ ዹፈን። እሳንስ አኩመ ዋቀዮ ሙሴ አጀጄ ሰነ ሌዎተስ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“ኩን ሴረ ሌዎታፍ ኬነሜዸ፦ ዺሮትን ኡሙሪንሳኒ ወጋ ድግደሚ ሸኒፊ ሀመሲ ኦሊ ሆጂ ዱንካነ ወል ገኢ ኬሰት ህርማቹፍ ሃዹፈን፤ ");
INSERT INTO gaze_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","ኡሙሪ ወጋ ሸንተማት ገሩ ተጃጅለሳኒ ሃዻበን፤ ዴብአኒስ ህንተጃጅልን። ");
INSERT INTO gaze_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","ሆጂ ዱንካነ ወል ገኢረት ኦቦሎተ ኦፊ ገርጋሩ ንደንደኡ፤ ኦፊሳኒቲ ገሩ ሆጂ ሰነ ህንሆጄትን። ኤጋ ኩን ሃለ እት አት እት ጋፈተመ ሌዎታ ረመዱዸ።” ");
INSERT INTO gaze_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","ዋቀዮ ኤርገ እሳን ግብጢ በአኒ ቦዴ ጅአ ጀልቀባ ከን ወጋ ለመፋት ገሞጂ ሲና ኬሰት አከነ ጄዼ ሙሴት ዱበቴ፤ ");
INSERT INTO gaze_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“እስራኤሎን ዬሮ ሙርታኤት ፋሲካ ሃአያኔፈተን። ");
INSERT INTO gaze_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","እስን አኩመ ሴራፊ ደምቢ አያነ ከና ሁንዳት ዬሮ ሙርታኤት ጅአ ሰነ ኬሰ፣ ድምምሰ ገልገለ ጉያ ኩዸ አፉረፋት አያኔፈዻ።” ");
INSERT INTO gaze_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","ሙሴን አከ እሳን ፋሲካ አያኔፈተን እስራኤሎተት ህሜ፤ ");
INSERT INTO gaze_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","እሳንስ ጅአ ጀልቀባ ኬሰ ድምምሰ ገልገለ ጉያ ኩዸ አፉረፋት ገሞጂ ሲና ኬሰት አያኔፈተን። ሰብን እስራኤል አኩመ ዋቀዮ ሙሴ አጀጄት ዋን ሁንደ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","እሳን ኬሳ ነሞትን ቶኮ ቶኮ ሰበቢ ሬፈ ቱቀኒ ጡራአኒፍ ጉያ ሰነ ፋሲካ አያኔፈቹ ህንደንዴኜ። እሳን ጉዩመ ሰነ ገረ ሙሴፊ አሮኒ ዹፈኒ፣ ");
INSERT INTO gaze_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","ሙሴዻን አከነ ጄዸን፤ “ኑ ሰበቢ ሬፈ ነማ ቱቅኔፍ ጡሮፍኔረ፤ ገሩ ማሊፍ ዬሮ ሙርታኤ ሰነት እስራኤሎተ ካን ወጅን ኣርሳ ዋቀዮ ዽኤሱ ዾወምኔ?” ");
INSERT INTO gaze_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","ሙሴንስ፣ “ሀመ አን ዋን ዋቀዮ ዋኤኬሰን አጀጁ ዸገኡት ቱራ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“እስራኤሎታን አከነ ጄዽ፦ ‘እስን ኬሳ ዮካን እልማንኬሰን ኬሳ ነምን ቶኮ ዮ ሬፈ ቱቄ ጡራኤ ዮካን ከራ ፈጎ ዴሜ፣ እን አመዩ ፋሲካ ዋቀዮ አያኔፈቹ ንደንደአ። ");
INSERT INTO gaze_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","እሳንስ ጅአ ለመፋ ኬሰ ጉያ ኩዸ አፉረፋ ድምምሰ ገልገለ ፋሲካ ሃአያኔፈተን። ፋሲካ ሰነስ መጥኖፊ ባለ ሀዻኣ ወጅን ሃኛተን። ");
INSERT INTO gaze_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","እሳንስ ወንቶተ ከኔን ኬሳ ቶኮዩ ሀመ ገነማት ሀምብሱ ዮካን ለፌሳ ኬሳ ቶኮዩ ጨብሱ ህንቀበን። እሳን ዮሙ ፋሲካ አያኔፈተንት ደምቢወን ሁንደ ዱካ ቡኡ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","ገሩ ነምን ቁልቁሉ ተኤ ከራ ህንዴምን ዮ ፋሲካ አያኔፈቹ ባቴ እን ሰበቢ ዬሮ ሙርታኤት ኣርሳ ዋቀዮ ህንዽኤስኒፍ ሰበሳ ኬሳ ሃበሌፈሙ። ነምች ሱን ገቲ ጩቡሳ ንአርገተ። ");
INSERT INTO gaze_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘አለጋን እስን ግዱ ጅራቱ ከን ፋሲካ ዋቀዮ አያኔፈቹ ፌዹ ቶኮ አኩመ ሴራፊ ደምቢ ፋሲካት ሃአያኔፈቱ። እስንስ አለጋፊ ዸለታ ብያቲፍ ሴሩመ ቶክቸ ቀባዻ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","ጋፈ ዱንካን ቁልቁሉን ዻበሜ ሰነ ዱሜስ ዱንካነ ሰነ ጄቹንስ ዱንካነ ዹገ በኡምሳ ሀጉጌ። ዱሜስ ዱንካነ ቁልቁሉዻን ኦሊ ሱንስ ገልገላ ሀመ ገነማት እብደ ፈካተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","ወን ኩንስ ዬሮ ሁንደ አከኑመ ቱሬ፤ ጉያ ዱሜስ እሰ ሀጉገ ቱሬ፤ ሀልከንሞ ዱሜስ ሱን እብደ ፈካተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","ዬሮ ዱሜስ ሱን ዱንካነራ ከኡ እስራኤሎን ከአኒ ዴሙ ቱረን፤ ለፈ ዱሜስ ቡኡሞ እስራኤሎን ንቁበቱ። ");
INSERT INTO gaze_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","እስራኤሎን አጀጀ ዋቀዮቲን ከአኒ ዴሙ፤ አጀጁመሳቲንስ ቁበቱ። ዬሮ ዱሜስ ዱንካነ ቁልቁሉን ኦል ጅሩ እሳንስ ቁበተ ኬሰ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","ዮ ዱሜስ ሱን ጉያ ሄዱ ዱንካነ ጉባ ቱሬስ እስራኤሎን ሴረ ዋቀዮቲፍ ዋን አጀጀመኒፍ እዶ ሰና ከአኒ ህንዴመን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","ዬሮ ቶኮ ቶኮ ዱሜስ ሱን ጉያ ጥናዻፍ ዱንካነ ቁልቁሉ ጉባ ኦሌ ቡለ ቱሬ፤ እሳንስ አጀጀ ዋቀዮቲን ቁበቱ፤ አጀጁመሳቲንስ ከአኒ ዴሙ። ");
INSERT INTO gaze_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","ዬሮ ቶኮ ቶኮ ዱሜስ ሱን ገልገላ ሀመ ገነማት ጅራተ ቱሬ፤ ዮሙ ዱሜስ ገነማን ከኡ እሳንስ ከአኒ ዴሙ። ጉያስ ተኡ ሀልከን፣ ዬሮ ዱሜስ ከኡ እሳንስ ከአኒ ዴሙ። ");
INSERT INTO gaze_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","ዬሮ ዱሜስ ሱን ጉያ ለመስ ተኡ ጅአ ቶኮ ዮካን ወጋ ቶኮ ዱንካነ ቁልቁሉረ ቱሩት እስራኤሎን ቁበቱመ ኬሰ ቱሩ መሌ ከአኒ ህንዴመን ቱሬ፤ ዬሮ ዱሜስች ከኡት ገሩ ከአኒ ዴሙ። ");
INSERT INTO gaze_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","እሳን አጀጀ ዋቀዮቲን ቁበቱ፤ አጀጁመ ዋቀዮቲንስ ከአኒ ዴሙ። አኩመ አጀጀ ዋቀዮ ከራ ሙሴቲን ኬኔ ሰናትስ ሴረ እሳቲፍ አጀጀሙ። ");
INSERT INTO gaze_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“ሜቲ ቱመሜራ መለከተ ለመ ቶልፈዹቲ ሀዋሰ ወልት ዋሙፊ አከ ቁበን ከኤ ዴሙ ጎቹፍ እት ፈየደም። ");
INSERT INTO gaze_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","ዬሮ መለከትን ለማን አፉፈመንት ሀዋስን ሁንድ በልበለ ዱንካነ ወል ገኢት ፉለኬ ዱረት ወልት ሃቀበሙ። ");
INSERT INTO gaze_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","ዮ መለከትን ቶኮ ቆፍት አፉፈሜ ገሩ ሆገንቶትን ጄቹንስ አቦቲን ጎሶተ እስራኤል ፉለኬ ዱረት ወልት ሃቀበመን። ");
INSERT INTO gaze_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","ዬሮ መለከትን አፉፈሙት ጎሶትን ገመ በአ ቢፍቱቲን ቁበተን ከአኒ ሃዴመን። ");
INSERT INTO gaze_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","ዬሮ መለከትን ስአ ለመፋ አፉፈሙትሞ ጎሶትን ገመ ክባቲን ቁበተን ከአኒ ሃዴመን። መለከትን አፉፈሙ ሱን መለቶ እሳን እቲን ቁበተ ኬሳ በአኒዸ። ");
INSERT INTO gaze_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","ሀዋሰ ወልት ቀቡዻፍ መለከተ አፉፍ፤ ገሩ መለቶ ወል ፈካቱን ህንአፉፍን። ");
INSERT INTO gaze_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“እልማን አሮን ሉቦትን መለከተወን ሰነ ሃአፉፈን። ኩንስ እስኒፊ ዸሎተ ዹፉፍ ሴረ በረ በራ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","እስን ዮሙ ብየኬሰን ኬሰት ዲነ እስን ጩንቁርሱ ቶኮት ዱሉፍ ባተንት መለከተወን ሰነ አፉፋ። ዮስ ዋቀዮ ዋቅንኬሰን እስን ያደቴ ዲነኬሰን ጀላ እስን ባሰ። ");
INSERT INTO gaze_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","አከሱመስ ጉያ ገመቹኬሰኒ ጄቹንስ ጋፈ አያነ ቤከማፊ አያነ ባቲ ሃራት ኣርሳኬሰን ከን ጉበሙፊ ኣርሳኬሰን ከን ነጋረት መለከተወን አፉፋ፤ ወን ኩንስ ፉለ ዋቀኬሰኒ ዱረት ያደኖ እስኒፍ ተአ። አን ዋቀዮ ዋቀኬሰን።” ");
INSERT INTO gaze_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","ጅአ ለመፋ ወጋ ለመፋ ኬሰ ጉያ ድግደመፋት ዱሜስ ሱን ዱንካነ ዹገ በኡምሳራ ከኤ። ");
INSERT INTO gaze_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","እስራኤሎንስ ገሞጂ ሲናቲ ከአኒ ሀመ ዱሜስ ሱን ገሞጂ ጳራኒ ኬሰ ቁበቱት እዶ ቶኮራ ገረ እዶ ብራት ዴመን። ");
INSERT INTO gaze_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","እሳን ዬሮ ጀልቀባ ከነት አጀጀ ዋቀዮ ከራ ሙሴቲን ኬኔን ከአኒ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","ኩታን ቁበተ እጆሌ ይሁዳ ፋጂሳኒ ጀላን ጀልቀበት ዴመን። ነህሾን እልም አሚናዳብ አጀጃሳኒ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","ናትናኤል እልም ዙዋር አጀጃ ኩታ ጎሰ ይሳኮር ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ኤሊያብ እልም ሄሎን አጀጃ ኩታ ጎሰ ዜቡሎን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","ዱንካን ቁልቁሉን ሱንስ አቺ ቡቅፈሜ፤ አከሲን ጌርሾኖትኒፊ ሜራሮን ወር ዱንካነ ባተን ከአኒ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","ኩታን ቁበተ ሩቤንስ ፋጂሳኒ ጀላን እት ኣነኒ ዴመን። ኤሊዙር እልም ሼዴኡር አጀጃሳኒ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","ሽሉሚኤል እልም ዙሪሸዳይ አጀጃ ኩታ ጎሰ ስምኦን ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","ኤልያሳፍ እልም ዴኡኤል አጀጃ ኩታ ጎሰ ጋድ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","ኤርገሲ ቆሃቶትን ምአ ቁልቁሉ ባተኒ ከአኒ ዴመን። ዱንካን ቁልቁሉን ሱንሞ ኡቱ እሳን አች ህንገእን ዻበሜ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","ኩታን ቁበተ ኤፍሬምስ ፋጂሳኒ ጀላን እት ኣነኒ ዴመን። ኤሊሻማን እልም አሚሁድ አጀጃሳኒ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","ገማልኤል እልም ጴዳሱር አጀጃ ኩታ ጎሰ ምናሴ ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","አቢዳን እልም ጋዴዮን አጀጃ ኩታ ጎሰ ቤንያም ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","ዹመረት ኩታን ቁበተ ዳን ኤግዱ ከራ ዱባ ከን ኩታወን ሁንዳ ተአኒ ፋጂሳኒ ጀላን ከአኒ ዴመን። አሂኤዜር እልም አሚሸዳይ አጀጃሳኒ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","ፈግኤል እልም ኦክራን አጀጃ ኩታ ጎሰ ኣሼር ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","አሂራን እልም ኤናን አጀጃ ኩታ ጎሰ ንፍታሌም ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","ኤጋ ኩታወን ሰበ እስራኤል ዮሙ ከአኒ ዴመንት ተርቲበ ከናን ሶቾአን። ");
INSERT INTO gaze_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","ኤርገሲ ሙሴን ሆባብ እልመ ሬኡኤል፣ ነምቸ ምድያን አባ ኒቲ ሙሴ ሰናን አከነ ጄዼ፤ “ኑ ብየ ዋቀዮ፣ ‘አን እስኒ ኬነ’ ኑን ጄዼ ሰነ ዸቁፍ ዴማ ጅረ። ኑ ዋን ጋሪ ሲፍ ጎናቲ ኮቱ ኑ ወጅን ዴም፤ ዋቀዮ ዋን ጋሪ እስራኤሎታፍ ከከቴራቲ።” ");
INSERT INTO gaze_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","እንሞ፣ “ለክ አን ህንዴሙ፤ አን ብዩመኮት ገረ ሰበኮት ነንዴብአ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","ሙሴን ገሩ አከነ ጄዼን፤ “ማሎ ኑ ዺስቴ ህንዴምን። አት ገሞጂ ኬሰት እዶ ኑ ቁበትኑ ንቤክተ፤ እጀስ ኑ ተኡ ደንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","ዮ አት ኑ ወጅን ዴምቴ ኑ ዋን ጋሪ ዋቀዮ ኑ ኬኑ ስ ወጅን ቆደትነ።” ");
INSERT INTO gaze_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","እሳን ቱሉ ዋቀዮራ ከአኒ ጉያ ሰዲ ዴመን። ታቦትን ከኩ ዋቀዮስ እዶ እሳን ቦቆተን እሳኒፍ በርባዱፍ ጄዼ ጉያ ሰደኑ እሳን ዱረ ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","ዱሜስ ዋቀዮ ሱን ዬሮ እሳን ቁበተ ኬሳ በአን ጉያ ጉያ እሳንረ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","ዬሮ ታቦትን ሱን ከኤ ዴሙ ሙሴን አከነ ጄዸ ቱሬ፤ “ያ ዋቀዮ፣ ከእ! ዲኖትንኬ ሃብትኔፈመን፤ ወር ስ ጅበንስ ፉለኬ ዱራ ሃበቀተን።” ");
INSERT INTO gaze_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","ዬሮ እን ቦቆቹፍ ዹፉ አከነ ጄዸ ቱሬ፤ “ያ ዋቀዮ፣ ገረ ኩማተመ እስራኤል ሄዱት ዴብእ።” ");
INSERT INTO gaze_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","ሰብን ሱን ኡቱመ ዋቀዮ እሰ ዸገኡ ዋኤ ረክነሳ ጉንጉሜ፤ እንስ ዮሙ ዋን ከነ ዸገኤት ንኣሬ። ከነረት እብድ ዋቀዮ እሳን ግዱት ቦበኤ ቀርቀረ ቁበተሳኒ ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","ሰብን ሙሴት እዬ፤ ሙሴንሞ ዋቀዮን ከዸቴ እብድ ሱን ዻሜ። ");
INSERT INTO gaze_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","ሰበቢ እብድ ዋቀዮ ብራ ገድ ቡኤ ግዱሳኒት ቦበኤፍ፣ እዶን ሱን “ተቤራ” ጄዸሜ ዋመሜ። ");
INSERT INTO gaze_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","ሰብን ወል መካን እሳን ወጅን ቱሬስ ኛተ ብራ ዸረኤ፤ እስራኤሎን አመስ አከነ ጄዸኒ ቦኡ ጀልቀበን፤ “ኑ ኡቱ ፎን ኛትኑ አርገትኔ! ");
INSERT INTO gaze_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","ኑ ብየ ግብጥ ኬሰት ቁርጡሚ ቶሉመ ኛትኔ፤ አከሱመስ ደባቁለ፣ ሀባቢ፣ ጎደሬ፣ ቁሉቢ ዲማፊ ቁሉቢ አዲ ኛትኔ ሰነ ንያደትነ። ");
INSERT INTO gaze_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","አመ ገሩ ፌዺን ኛታ ኑራ በዴረ፤ መና ከነ መሌስ ዋን ቶኮሌ ህንአርግኑ!” ");
INSERT INTO gaze_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","መናን ሱን አከ ሰኚ ድንብላላ ተኤ ብፍትሳ ሀጴ ፈካተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","ነሞትንስ መና ሰነ ነናነአኒ ወልት ቀበኒ ዸጋ ዳኩት ዳከቻ ዮካን ሞዬት ቱመቻ ቱረን። እሳንስ መና ሰነ ኦኮቴት አፌሉ ዮካን መጥኖሳ ቶልፈቱ ቱረን። እንስ አከ ዋን ዘይቲ ኤጄርሳቲን ቆጴፈሜት ምኣወ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","ገልገለ ዮሙ ፍጤንስ ቁበተረ ቡኤት መናን ሱንስ ገድ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","ሙሴን ኡቱ ነሞትን ማቲ ሁንዳ በልበለ ዱንካነ ኦፊሳ ዱረት ቦአኑ ዸገኤ። ዋቀዮስ አከ መሌ ኣሬ፤ ሙሴንሞ ንዽጰቴ። ");
INSERT INTO gaze_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","እንስ አከነ ጄዼ ዋቀዮን ጋፈቴ፤ “አት ማሊፍ ዽጵነ ከነ ገርብቸኬት ፍዴ? አት ከን በኣ ሰበ ከና ሁንደ ነረ ኬሴ አን ማል በሌሴ ስ ገድሲሴት? ");
INSERT INTO gaze_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","ሰበ ከነ ሁንደ አነቱ ኡልፋኤ? አነቱ እሳን ደኤ? አት ማሊፍ አከ አን አኩመ ጉድፍቱን ዳእመ ባቱት ገረ ብየ አት አቦቲሳኒቲፍ ከኩዻን ዋዳ ገልቴት እሬኮት ባዼ እሳን ጌሱዻፍ ነ አጀጀ? ");
INSERT INTO gaze_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","አን ሰበ ከነ ሁንዳፍ ፎን ኤሳን አርገዸ? እሳን፣ ‘ፎን ኛትኑ ኑ ኬን!’ ጄዸኒ ነት ቦኡ። ");
INSERT INTO gaze_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","አን ኮጳኮ ሰበ ከነ ሁንደ ባቹ ህንደንደኡ፤ በኣን ኩን አከ መሌ ነት ኡልፋተ። ");
INSERT INTO gaze_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","አት ዮ አከነ ነ ጎተ ተኤ፣ ዮ አን ፉለኬ ዱረት ፉዸተመ አርገዼ ጅራዼ፣ ማሎ አሙመ ነ አጄስ፤ አከ አን ግድራ ነት ዹፉ አርጉስ ነ ህንጎዽን።” ");
INSERT INTO gaze_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ “ማንጉዶተ እስራኤል ኬሳ ነመ ቶርባተመ ከኔን ሆገንቶታፊ ቆንዳልቶተ ሰባ ተኡሳኒ ቤክቱ ና ፍድ። አከ እሳን ገረ ዱንካነ ወል ገኢ ዹፈኒ ስ ወጅን አች ዸዻበተን ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","አን ገድ ቡኤ አችት ስ ወጅን ነንዱበዸ፤ ሀፉረ ስረ ጅሩራስ ፉዼ እሳንረ ነንካአ፤ እሳንስ አከ አት ኮጳኬ በኣ ሰነ ህንባኔፍ በኣ ሰበ ሰና ስ ወጅን ባቱ። ");
INSERT INTO gaze_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“ሰበ ከናን አከነ ጄዽ፦ ‘እስን ቦር ፎን ኛቱቲ ኦፍ ቁልቁሌሳ ቆጳኣ። ዋቀዮ ዬሮ እስን፣ “ኑ ኡቱ ፎኑመ ኛትኑ አርገትኔ! ዬሮ ኑ ብየ ግብጥ ኬሰ ጅሩ ኑ ወየ ቱሬ!” ጄተኒ ቦሰን ዸገኤራቲ። ዋቀዮ አመ ፎን እስኒ ኬነ፤ እስንስ ንኛቱ። ");
INSERT INTO gaze_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","እስን ሀመ ጉያ ቶኮ፣ ዮካን ለማ፣ ዮካን ሸኒ፣ ኩዸኒ፣ ዮካን ድግደማ ቆፈ ህንኛተን፤ ");
INSERT INTO gaze_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","ገሩ ጅአ ቶኮ ጉቱ ሀመ ፉኛኒን እስን በኡት፣ ሀመ ኑፍተንትስ ኛቱ፤ እስን ዋቀዮ ግዱኬሰን ጅሩ ሰነ ድደኒ፣ “ኑ ማሊፍ ብየ ግብጥ ኬሳ ባኔ?” ጄተኒ ፉለሳ ዱረት ቦሰኒ ቱርተኒቲ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","ሙሴን ገሩ አከነ ጄዼ፤ “ኩኖ አን ነሞተ ለፎ ኩመ ዽበ ጀአ ግዱን ጅረ፤ አትሞ፣ ‘አን ፎን እሳን ጅአ ጉቱ ኛተን ኬናፍ!’ ጄተ። ");
INSERT INTO gaze_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","ኡቱመ ቡሻዬፊ ከር ሎኒ እሳኒፍ ቀለመኒዩ ገኣ ላተ? ኡቱመ ቁርጡሚን ገላነ ኬሳ ሁንድሳኒ ቀበሜዩ ገኣ ላተ?” ");
INSERT INTO gaze_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ሀርክ ዋቀዮ ገባባዻ? አት አከ ወን አን ሲን ጄዹ ሲፍ ጉተሙፊ አከ ሲፍ ህንጉተምኔ አመ ንአርግተ።” ");
INSERT INTO gaze_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","ሙሴን ዸቄ ዋን ዋቀዮ ጄዼ ሰነ ሰበት ህሜ። እንስ ሰበ ሰነ ኬሳ ማንጉዶተ ቶርባተመ ወልት ቀቤ አከ እሳን ናኖ ዱንካና ዸዻበተን ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","ኤርገሲስ ዋቀዮ ዱሜሳን ገድ ቡኤ እሰት ዱበቴ፤ ሀፉረ እሰረ ጅሩስ ፉዼ ማንጉዶተ ቶርባተመን ሰነረ ቡሴ። እሳንስ ዬሮ ሀፉር ሱን እሳንረ ቦቆቴት ራጂ ዱበተን፤ ኤርገሲሞ ዴብአኒ ራጂ ሰነ ህንዱበትኔ። ");
INSERT INTO gaze_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","ተኡሌ ነሞትን ለመ ከኔን መቃንሳኒ ኤልዳዲፊ ሜዳድ ጄዸመን ቁበተ ኬሰት ሀፈኒ ቱረን። እሳንስ ማንጉዶተ ሰነ ኬሰት ገልሜፈመኒ ቱረን መሌ ገድ በአኒ ገረ ዱንካና ህንዸቅኔ ቱሬ። ሀፉርሞ እሳንረሌ ቡኤ፤ እሳንስ ቁበተ ኬሰት ራጂ ዱበተን። ");
INSERT INTO gaze_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","ደርገጌስ ቶኮ ፊጌ ዸቄ፣ “ኤልዳዲፊ ሜዳድ ራጂ ዱበቹት ጅሩ” ጄዼ ሙሴት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","እያሱን እልም ኑን ከን እጆሉማ ኦፊቲ ጀልቀቤ ገርጋርቱ ሙሴ ቱሬ ሱን ከኤ፣ “ያ ሙሴ፣ ያ ጎፍታኮ፣ እሳን ዾው!” ጄዼ ዱበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","ሙሴን ገሩ አከነ ጄዼ ዴብሴ፤ “አት አናፍ ህናፍታ? አን ኡቱ ሰብን ዋቀዮ ሁንድኑ ራጆተ ተአኒ ዋቀዮስ ሀፉረሳ እሳንረ ካኤ ነንሀወ!” ");
INSERT INTO gaze_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","ኤርገሲስ ሙሴፊ ማንጉዶትን እስራኤል ገረ ቁበታት ዴብአን። ");
INSERT INTO gaze_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","ቡቤን ቶኮስ ዋቀዮ ብራ በኤ ገላነ ኬሳ ድምብርቄ ገረ ቁበታት ኦፌ። ቡቤን ሱንስ ድምብርቄ ሰነ ናኖ ቁበተ ሰናት ገመ ሁንዳን ሀመ ዴምሰ ጉያ ቶኮ ፈጋቱ ሀርጫሴ ሀመ ዹንዹመ ለማ ኦል ቱሌ። ");
INSERT INTO gaze_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","ጉያ ሰነ ጉቱፊ ሀልከን ሰነ ጉቱ፣ ጉያ እት ኣኑ ጉቱስ ሰብን ሱን ገድ በኤ ድምብርቄ ሰነ ወልት ቀበቴ፤ እሳን ኬሳስ ነምን ሆሜሪ ኩዸኒ ገድ ወልት ቀበቴ ህንቱሬ። ኤርገሲ ድምብርቄ ሰነ ናኖ ቁበተ ሰና አፈተን። ");
INSERT INTO gaze_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","ገሩ ኡቱመ ፎን ሱን አመሌ ግዱ እልካንሳኒ ጅሩ፣ ኡቱ ህንአለንፈትን ዋቀዮ እሳንት ኣሬ ዸእቸ ሀማዻን እሳን ዸኤ። ");
INSERT INTO gaze_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","ሰበቢ እሳን ነሞተ ኛተ ብራ ዸረአን አችት አዋለኒፍ መቃን እዶ ሰና፣ “ቂብሮት ሃታአባ” ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","ሰብን ሱንስ ቂብሮት ሃታአባዻ ከኤ ገረ ሀጤሮት ዸቄ አች ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","ሚርያሚፊ አሮን ሰበቢ ሙሴን ዱበርቲ እቶጵያ ፉዼፍ እሳን ሞርሙዻን ዱበቹ ጀልቀበን፤ እን ዱበርቲ እቶጵያ ፉዼ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","እሳንስ፣ “ዋቀዮ ከራ ሙሴ ቆፋን ዱበቴ? እን ከራኬኛንስ ዱበቴ ቱሬ ምቲ?” ጄዸን። ዋቀዮስ ዱቢ ከነ ዸገኤ። ");
INSERT INTO gaze_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","ሙሴን ነሞተ ለፈረ ጅራተን ሁንደ ጫላ ነመ አከ መሌ ገድ ኦፍ ቀቡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","ዋቀዮስ ዮሙሱመ ሙሴን፣ አሮኒፊ ሚርያሚን፣ “እስን ሰደኑ ገረ ዱንካነ ወል ገኢት ገድ በኣ” ጄዼ። እሳን ሰደኑስ ገድ በአን። ");
INSERT INTO gaze_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","ኤርገሲ ዋቀዮ ኡቱባ ዱሜሳ ኬሳን ገድ ቡኤ በልበለ ዱንካናረ ዻበቴ አሮኒፊ ሚርያምን ዋሜ። ጀር ለቹ እሰት ዽኣናን፣ ");
INSERT INTO gaze_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","እን አከነ ጄዼን፤ “ዱቢኮ ዸገኣ፦ “ዮ ራጂን ዋቀዮ ግዱኬሰን ጅራቴ፣ አን ሙልአተ ኬሰ እሰት ኦፍ ነንሙልእሰ፤ አብጁዻንስ እሰት ነንዱበዸ። ");
INSERT INTO gaze_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","ገሩ ገርብችኮ ሙሴን አከነ ምት፤ እን መነኮ ሁንደ ኬሰት አመነማዸ። ");
INSERT INTO gaze_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","አን ኡቱ ዾክሳዻን ህንተእን፣ እፋን እፈት እሰት ነንዱበዸ፤ እን ብፈ ዋቀዮ ንአርገ። ዮስ እስን ማሊፍ ገርብቸኮ ሙሴዻን ሞርሙዻን ዱበቹ ህንሶዳትኔሬ?” ");
INSERT INTO gaze_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","ኣሪን ዋቀዮስ እሳንረት ቦበኤ፤ እንስ እሳን ዺሴ ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","ዮሙ ዱሜስ ሱን ዱንካነ ጉባዻ ኦል ከኤት ኩኖ፣ ሚርያም ለምጦፍቴ አኩመ ጨቢ አዳቴ ቱርቴ። አሮንስ ገረሼት ገረገሌ አከ እሼን ለምጢ ቀብዱ አርጌ፤ ");
INSERT INTO gaze_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","እንስ ሙሴዻን አከነ ጄዼ፤ “ማሎ ያ ጎፍታኮ፣ ጩቡ ኑ ጎዉማዻን ሆጄትኔ ሰነ ኑት ህንለካእን። ");
INSERT INTO gaze_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","አከ ገተተ ፎንሳ ገሪን ኛተሜ ገደሜሰ ሃዸሳ ኬሳ በኡ ቶኮ እሼ ህንጎዽን።” ");
INSERT INTO gaze_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","ሙሴን ዋቀዮት ቦኤ፣ “ያ ዋቀዮ፣ ማሎ እሼ ፈይስ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","ዋቀዮ አከነ ጄዼ ሙሴዻፍ ዴቢ ኬኔ፤ “ኡቱ አባንሼ ፉለሼት ቱፌ ስላ እሼን ቡልቲ ቶርበ ሰልጵነ ኬሰ ቱርት ምቲሬ? እሼን ቡልቲ ቶርበ ቁበታን አለ ሃቱርቱ፤ ኤርገሲ ዴብቴ ዹፉ ደንዴስ።” ");
INSERT INTO gaze_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","ሚርያም ቡልቲ ቶርበ ቁበታን አለ ቱርቴ፤ ሰብን ሱንስ ሀመ እሼን ዴብቱት ዴምሰ እት ህንፉፍኔ። ");
INSERT INTO gaze_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","ኤርገሲ ሰብን ሱን ሀጤሮቲ ከኤ ገሞጂ ጳራን ኬሰ ቁበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“አከ እሳን ዸቀኒ ብየ ከነኣን እሼ አን እስራኤሎታፍ ኬኑፍ ጅሩ ሰነ በሳሰኒፍ ነሞተ ኤርግ። ቶኮ ቶኮ አቦቲ ጎሳ ኬሳ ሆገና ቶኮ ኤርግ።” ");
INSERT INTO gaze_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","ሙሴን አጀጀ ዋቀዮቲን ገሞጂ ጳራን ኬሳ እሳን ኤርጌ። ሁንድሳኒ ሆገንቶተ እስራኤሎታ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","መቃንሳኒ ከኔኒዸ፦ ጎሰ ሩቤን ኬሳ ሸሙኣ እልመ ዘኩር፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","ጎሰ ስምኦን ኬሳ ሻፋጥ እልመ ሆሪ፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","ጎሰ ይሁዳ ኬሳ ካሌብ እልመ ዬፉኔ፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","ጎሰ ይሳኮር ኬሳ ይግኣል እልመ ዮሴፍ፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","ጎሰ ኤፍሬም ኬሳ ሆሼኣ እልመ ኑን፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","ጎሰ ቤንያም ኬሳ ጳልቲ እልመ ራጱ፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","ጎሰ ዜቡሎን ኬሳ ገዲኤል እልመ ሶዲ፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","ጎሰ ምናሴ ጄቹንስ ጎሰ ዮሴፍ ኬሳ ገዲ እልመ ሱስ፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","ጎሰ ዳን ኬሳ አሚኤል እልመ ጌማል፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","ጎሰ ኣሼር ኬሳ ሴጡር እልመ ሚካኤል፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","ጎሰ ንፍታሌም ኬሳ ናህቢ እልመ ዎፍሲ፤ ");
INSERT INTO gaze_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","ጎሰ ጋድ ኬሳ ጌኡኤል እልመ ማኪት። ");
INSERT INTO gaze_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","ኤጋ መቃወን ኩኔን መቃወን ነሞተ አከ እሳን ብየ ሰነ በሳሰኒፍ ጄዼ ሙሴን ኤርጌዸ። ሙሴንስ ሆሼኣ እልመ ኑን ሰነ፣ “እያሱ” ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","ሙሴን ዮሙ አከ እሳን ብየ ከነኣኒ በሳሰኒፍ እሳን ኤርጌት አከነ ጄዼን፤ “ከራ ኔጌብ ደርባቲ ገረ ብየ ጋራት ኦል በኣ። ");
INSERT INTO gaze_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","ብይ ሱን ማል አከ ፈካቱ፣ ነሞትን አች ጅራተንስ ጀጀቦ ዮካን ደዸቦ፣ ሙራሰ ዮካን ሄዱ ተኡሳኒ እላላ። ");
INSERT INTO gaze_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","እሳን ብየ አከሚ ኬሰ ጅራቱ? ጋሪ ዮካን ገዼ? መጋላወን አከሚ ኬሰ ጅራቱ? ደላ ዸጋ ህንቀበንሞ ደኦ ጀባ ቀቡ? ");
INSERT INTO gaze_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","ለፍትሳ ገበታዸሞ ገበታ ምት? ሙከ ቀበሞ ህንቀቡ። ጀባዻቲ እጀ ብየቲ ኬሳ ሙራሰ ፍዳ።” ወቅቲን ሱን ዬሮ እጅ ወይኒ ከን ጀልቀባ እት ብልቻቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","እሳን ኦል በአኒ ገሞጂ ሲንራ ጀልቀበኒ ሀመ ሬሆብት ገረ ሌቦ ሀማትት ብየቲ በሳሰን። ");
INSERT INTO gaze_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","እሳንስ ከራ ኔጌብ ኦል በአኒ ገረ ኬብሮን ለፈ አሂመን፣ ሼሻዪፊ ተልማይ እልማን አናቅ ሱን ጅራተኒት ዹፈን። ኬብሮን ኩንስ ኡቱ ዞኣን እሼን ብየ ግብጥ ሱን ህንእጃረምን ወጋ ቶርባን ዱረ እጃረምቴ። ");
INSERT INTO gaze_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","እሳንስ ዮሙ ሱሉለ ኤሽኮል ገአንት ሁርቡ እጀ ወይኒ ቶኮ ኩተን። ወይኒ ሰነስ ሮማኒፊ ሀርቡ ወጅን ነመ ለመ ተአኒ ደንቀራዻን ባተን። ");
INSERT INTO gaze_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","እዶን ሱን ሰበቢ ሁርቡ እጀ ወይኒ ከን ወር እስራኤል ኩተን ሰናቲፍ ሱሉለ ኤሽኮል ጄዸሜ። ");
INSERT INTO gaze_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","ጀርስ ዹመ ቡልቲ አፉርተማት ብየ ሰነ በሳሰኒ ዴብአን። ");
INSERT INTO gaze_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","እሳንስ ገረ ቃዴሽ እሼ ገሞጂ ጳራን ኬሳ ገረ ሙሴፊ አሮን፣ ገረ ወልዳ እስራኤል ጉቱ ዴብአኒ ዹፈን። አችትስ ገባሰ እሳኒፍ ዽኤሰን፤ እጀ ብየቲስ እሳን አርግሲሰን። ");
INSERT INTO gaze_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","እሳንስ አከነ ጄዸኒ ሙሴት ህመን፦ “ኑ ገረ ብየ አት እት ኑ ኤርግቴ ሰና ዸቅኔረ፤ ብየቲን ኣነኒፊ ደመ ባፍት! እጅሼስ ኩኖ ከነ። ");
INSERT INTO gaze_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","ገሩ ነሞትን አች ጅራተን ጀጀቦዸ፤ መጋላወንሼ ደላ ጀባ ቀቡ፤ ጉርጉዳ ዸስ። ኑ ሰኚ አናቅዩ አችት አርግኔረ። ");
INSERT INTO gaze_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","አማሌቆትን ኔጌብ ኬሰ ጅራቱ፤ ሄቶትን፣ ዬቡሶትኒፊ አሞሮትን ብየ ጋራ ኬሰ ጅራቱ፤ ከነኣኖትንሞ ገላነ ብራፊ ቀርቀረ ዮርዳኖስ ጅራቱ።” ");
INSERT INTO gaze_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","ካሌብስ ፉለ ሙሴ ዱረት ሰበ ጨልእሲሴ፣ “ኑ ደፍኔ ኦል ባኔ ብየቲ ሃዻሉ፤ ሞአቹ ንደንዴኛቲ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","ነሞትን እሰ ወጅን ኦል በአኒ ቱረን ገሩ፣ “ኑ ወረ ሰነ ዸኡ ህንደንዴኙ፤ እሳን ኑረ ጀጀቦዸ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","እሳንስ ዋኤ ብየ በሳሰን ሰና ሰበ እስራኤል ግዱት ኦዱ ገዼ ተምሳሰን። አከነስ ጄዸን፤ “ብይ ኑ በሳስኔ ሱን ብየ ወረ እሼ ኬሰ ጅራቱዩ ኛቱዸ። ነሞትን ኑ አችት አርግኔ ሁንድኑ ዼዼሮዸ። ");
INSERT INTO gaze_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","አችት ኔፊሊሞተ አርግኔ፤ እልማን አናቅ ኔፊሊሞተራ ዹፈን። ኑ ኦፉመኬኘትዩ ኮሮጵሰ ፈካትኔ፤ ፉለሳኒ ዱረትስ አከሱመ ታኔ።” ");
INSERT INTO gaze_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","ሀልከን ሰነ ነሞትን ወልዳ ሰና ሁንድኑ ሰገሌሳኒ ኦል ፉዸተኒ ቦአን። ");
INSERT INTO gaze_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","እስራኤሎን ሁንድኑ ሙሴፊ አሮንት ጉንጉመን፤ ወልዳን ጉቱንስ አከነ እሳኒን ጄዼ፤ “ኑ ኡቱ ብዩመ ግብጥት ዹምኔ ጅራትኔ! ዮካን ኡቱ ገሞጂ ከነ ኬሰት ዹምኔ ጅራትኔ! ");
INSERT INTO gaze_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","ዋቀዮ ማሊፍ አከ ኑ ጎራዴዻን ዹምኑፍ ጄዼ ብየ ከነት ኑ ፍደ? ኒቶትንኬኛፊ እጆሌንኬኘ ንቦጅአሙ። ብየ ግብጥት ዴብኡን ኑ ህንወዩ?” ");
INSERT INTO gaze_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","እሳንስ፣ “አመ ሆገና ፍለትኔ ብየ ግብጥት ሃዴብኑ” ወሊን ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","ከነረት ሙሴፊ አሮን ፉለ ጉቱማ ያኢ እስራኤል ከኔን አችት ወልት ቀበመኒ ዱረት አዳን ለፈት ጎምብፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","ጀሬን ብየቲ ኬሰ ዴመኒ በሳሰን ኬሳ እያሱን እልም ኑኒቲፊ ካሌብ እልም ዬፉኔ ኡፈተ ኦፊ ተርሳሰኒ፣ ");
INSERT INTO gaze_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","ጉቱማ ያኢ እስራኤሎታቲን አከነ ጄዸን፤ “ብይ ኑ ኬሰ ዴምኔ በሳስኔ ሱን አከ መሌ ጋሪዸ። ");
INSERT INTO gaze_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","ዋቀዮ ዮ ኑት ገመዴ ብየ ሰነት ኑ ገልቼ ብየቲ ኣነኒፊ ደመ ባፍቱ ሰነ ኑ ኬነ። ");
INSERT INTO gaze_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","እስን ገሩ ዋቀዮት ህንፍንጭልና። ዋን ኑ እሳን ልልቅምስኑፍ ነሞተ ብየ ሰና ህንሶዳትና። ጋድስን እሳንራ ከኤረ፤ ዋቀዮ ኑ ወጅን ጅረ። እሳን ህንሶዳትና።” ");
INSERT INTO gaze_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","ወልዳን ጉቱን ገሩ ዸጋን እሳን ቱሙዻፍ መርአቴ። ኡልፍን ዋቀዮስ ፉለ ዱንካነ ወል ገኢ ዱረት እስራኤሎተ ሁንደት ሙልአቴ። ");
INSERT INTO gaze_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ “ሰብን ኩን ሀመ ዮሚት አከነ ነ ቱፈተ? ኡቱመ አን መለቶወን ከኔን ሁንደ ግዱሳኒት ሆጄዹ እሳን ሀመ ዮሚት ነ አመኑ ድዱ? ");
INSERT INTO gaze_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","አን ጎልፋዻን ዸኤ እሳን ነንበሌሰ፤ ስእ ገሩ ሰበ እሳን ጫላ ጉዳፊ ጀባ ስን ጎዸ።” ");
INSERT INTO gaze_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","ሙሴን ዋቀዮን አከነ ጄዼ፤ “ወር ግብጥ ዋኤ ዋን ከና ንዸገኡ! አት ሁምነኬቲን ሰበ ከነ ግዱሳኒቲ ባፍቴ ፍዴርታቲ። ");
INSERT INTO gaze_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","እሳንስ ዋኤ ዋን ከና ሰበ ብየ ሰነ ኬሰ ጅራቱት ንኦዴሱ። ያ ዋቀዮ፣ እሳን አከ አት ሰበ ከነ ግዱ ጅርቱ ዸገአኒሩ፤ ያ ዋቀዮ እሳን አከ አት ፉሉመ እሳኒት ሙልአቱ፣ አከ ዱሜስኬ እሳኒን ኦል ጅሩፊ አከ አት ጉያ ኡቱባ ዱሜሳቲን፣ ሀልከንሞ ኡቱባ እብዳቲን እሳን ዱረ ዴምቱ ዸገአኒ ጅሩ። ");
INSERT INTO gaze_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","ዮ አት ሰበ ከነ ዬሩመ ቶኮት በርበዴስቴ፣ ሰቦትን ኦዱ ዋኤኬቲ ዸገአን፣ ");
INSERT INTO gaze_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘ዋቀዮ ብየ ከኩዻን ዋዳ እሳኒፍ ገሌ ሰነት ሰበ ከነ ገልቹ ህንደንዴኜ፤ እን ከኑማፍ ገሞጂ ኬሰት እሳን ጎጎረኤ’ ጄዹ። ");
INSERT INTO gaze_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“ኤጋ አኩመ አት አከነ ጄቴ ዱበቴ ሰነት ጀብን ጎፍታ ሃአርግሲፈሙ፦ ");
INSERT INTO gaze_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘ዋቀዮ ደፌ ህንኣሩ፤ ጃለልሳሞ ጉዳዸ፤ እን ጩቡፊ ፍንጭለ ነማፍ ዺሰ። ተኡሌ እን ነመ የከ ሆጄቱ አደቡ መሌ ህንዺሱ፤ እን ሀመ ዸሎተ ሰደፋፊ አፉረፋት ሰበቢ ጩቡ አቦቲሳኒቲፍ ጄዼ እጆሌ ንአደበ።’ ");
INSERT INTO gaze_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","አኩመ ዬሮ እሳን ብየ ግብጢ በአኒ ጀልቀብዴ ሀመ አማት ዺፈመ እሳኒፍ ጎቴ ሰነ አኩመ ጃለለኬ ጉዳ ሰናት ጩቡ ሰበ ከና ዺሲፍ።” ");
INSERT INTO gaze_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","ዋቀዮ አከነ ጄዼ ዴብሴፍ፤ “አን አኩመ አት ከዸቴ ሰነ እሳኒፍ ዺሴረ። ");
INSERT INTO gaze_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","ተኡሌ አኩመ አን ዹጉማን ጅራታ ተኤፊ አኩመ ኡልፍን ዋቀዮ ዹጉማን ለፈ ሁንደ ጉቴ ሰነ፣ ");
INSERT INTO gaze_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","ነሞተ ኡልፍነኮ አርገኒ፣ መለቶወን አን ብየ ግብጢቲፊ ገሞጂ ኬሰት ሆጄዼ አርገኒ ገሩ ና አጀጀሙ ድደኒ ዬሮ ኩዸን ነ ቆረን ሰነ ኬሳ ነምን ቶኮዩ፣ ");
INSERT INTO gaze_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","ቶኮንሳኒ ብየ አን ከኩዻን አቦቲሳኒቲፍ ዋዳ ገሌ ሰነ ህንአርገን። ነምን ነ ቱፈቴ ቶኮ ብየ ሰነ ህንአርጉ። ");
INSERT INTO gaze_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","ገርብቸኮ ካሌብ ገሩ ሰበቢ እን ሀፉረ አዳ ቀቡፊ ሰበቢ ገራ ጉቱዻን ነ ዱካ ቡኣ ጅሩፍ፣ አን ብየ እን ዸቄ ሰነት እሰ ገልቸ፤ ሰኚንሳስ ብየ ሰነ ንዻለ። ");
INSERT INTO gaze_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","ሰበቢ አማሌቆትኒፊ ከነኣኖትን ሱሉሎተ ኬሰ ጅራተኒፍ፣ እስን ቦር ዴብኣቲ ከራ ገላነ ዲማቲን ገሞጂት ቀጄላ።” ");
INSERT INTO gaze_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","ዋቀዮ ሙሴፊ አሮኒን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“ወልዳን ሀማን ኩን ሀመ ዮሚት ነት ጉንጉመ? አን ጉንጉሚ እስራኤሎተ ጉንጉምቶተ ሰና ዸገኤረ። ");
INSERT INTO gaze_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","አከነ ጄዺ እሳንት ህም፤ ‘ዋቀዮ አከነ ጄዸ፤ አን ጅራታዻቲ፣ አኩመ እስን ጉረኮት ዱበተን ሰነ አንስ እስንት ጎዸ፦ ");
INSERT INTO gaze_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","ሬፍኬሰን ጄቹንስ ሬፍ ወረ ኡሙሪንሳኒ ወጋ ድግደማፊ ድግደማ ኦሊ ከኔን ለኮብሰ ኡመታ ኬሰት ለካአመኒ ነት ጉንጉመን ሁንዳ ገሞጂ ከነ ኬሰት ሀርጨኤ ሀፈ። ");
INSERT INTO gaze_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","ካሌብ እልመ ዬፉኔቲፊ እያሱ እልመ ኑን መሌ ቶኮንኬሰንዩ ብየ አን ኬሰ እስን ቁበቺሱፍ ከከዼ ሰነት ህንገልተን። ");
INSERT INTO gaze_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","አን ገሩ እጆሌኬሰን ወረ እስን ንቦጅአሙ ጄተን ሰነ እት ነንገልቸ፤ እሳንስ ብየ እስን ቱፈተን ሰነ ንቤኩ። ");
INSERT INTO gaze_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","እስን ገሩ፣ ሬፍኬሰን ገሞጁመ ከነ ኬሰት ሀርጨአ። ");
INSERT INTO gaze_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","እጆሌንኬሰን ወጋ አፉርተመ ገሞጂ ከነ ኬሰ ንጆሩ፤ ሀመ እስን ሁንድ ገሞጂ ኬሰት ዹምተንት እሳን ሰበቢ አመነሙማ ዸቡኬሰኒቲፍ አችት ረከቱ። ");
INSERT INTO gaze_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","እስን አኩመ ቡልቲ አፉርተመ ብየ ሰነ በሳስተን፣ አከሱመ ቡልቲን ቶኮ አከ ወጋ ቶኮት ለካአሜ ወጋ አፉርተመ ጩቡኬሰኒፍ ዽጰቱ፤ ዬሮ ሰነ እስን አከ አን እስኒን ሞርሙ ንቤክቱ።’ ");
INSERT INTO gaze_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","አን ዋቀዮ ዋን ከነ ዱበዼን ጅረ፤ አን ዹጉማን ዋን ከነ ወልዳ ሀማ ናን ሞርሙፍ ወልት ጉርማኤ ከነ ጉቱት ነንፍደ። እሳን ገሞጂ ከነ ኬሰት ዹሙ፤ አሱመትስ ንዱኡ።” ");
INSERT INTO gaze_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","ነሞትን ሙሴን አከ እሳን ብየቲ በሳሰኒፍ ኤርጌ ዮሙ አቺ ዴብአንት ዋኤ ብየ ሰና ገባሰ ሀማ ወልዳት ገባሰኒ አከ ወልዳን ሙሴት ጉንጉሙ ጎዸን ጄቹንስ ");
INSERT INTO gaze_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","ነሞትን ዋኤ ብየቲ ገባሰ ሀማ ገባሱት ጋፈተመን ሱን ዸእቻን ፉለ ዋቀዮ ዱረት ዹመን። ");
INSERT INTO gaze_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","ነሞተ ብየቲ በሳሱ ዸቀን ኬሳ እያሱ እልመ ኑንቲፊ ካሌብ እልመ ዬፉኔ ቆፈቱ ዱአ ኦሌ። ");
INSERT INTO gaze_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","ሙሴን ዋን ከነ ሁንደ እስራኤሎተት ህምናን እሳን አከ መሌ ቦአን። ");
INSERT INTO gaze_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","እሳንስ ጉያ እት ኣኑ ገነማን ፊጤ ብየ ጋራት ኦል በአኒ፣ “ኑ ጩቡ ሆጄትኔረ፤ ኑ አመ ገረ ለፈ ዋቀዮ ዋዳ ኑ ገሌ ሰና ዸቅነ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","ሙሴን ገሩ አከነ ጄዼ፤ “እስን ማሊፍ አጀጀ ዋቀዮ ጨብስቱ? ወን ኩን እስኒፍ ህንምልካኡ! ");
INSERT INTO gaze_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","አከ ዲኖተኬሰኒን ህንሞአተምኔፍ ኦል ህንበእና፤ ዋቀዮ እስን ወጅን ህንጅሩቲ፤ ");
INSERT INTO gaze_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","አማሌቆትኒፊ ከነኣኖትን አችት እስንት ዹፉቲ። ሰበቢ እስን ዋቀዮራ ገረገልተኒፍ እን እስን ወጅን ህንጅራቱ፤ ጎራዴዻን በርበዴፈምቱ።” ");
INSERT INTO gaze_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","እሳን ገሩ ኡቱ ሙሴፊ ታቦትን ከኩ ዋቀዮ ቁበተ ኬሳ ገድ ህንበእን ያዱመሳኒቲን ከአኒ ፊጤ ብየ ጋራት ኦል በአን። ");
INSERT INTO gaze_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","ዮሙስ አማሌቆትኒፊ ከነኣኖትን ጋረ ሰነረ ጅራተን ገድ ቡአኒ እሳን ዸአኒ ሀመ ሆርማት እሳን አርአን። ");
INSERT INTO gaze_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“ሰበ እስራኤልት አከነ ጄዺ ዱበዹ፦ ‘ዮሙ ብየ አን አከ እስን ኬሰ ጅራተኒፍ እስኒፍ ኬኑ ሰነ ሴንተኒ ");
INSERT INTO gaze_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","ኣርሳ እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ፣ ሎን ኬሳ ዮካን ቡሻዬ ኬሳ ፉተኒ ኣርሳ ጉበሙ ዮካን ቀልመ ወሬገ አዳቲፍ ዮካን ኣርሳ ፌዺኬሰኒ ዮካን ኣርሳ አያነ ወጋ ዋቀዮፍ ዽኤስቱ፣ ");
INSERT INTO gaze_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","ነምን ኣርሳ ዽኤሱ ሱን ዳኩ ቡላኣ ኢፊ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ከን ዘይቲ ኢኒ ሀርከ አፉር ኬሰ ሀርከ ቶኮቲን ሱኩመሜ ኬና ምዻኒ ጎዼ ዋቀዮፍ ሃዽኤሱ። ");
INSERT INTO gaze_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","ቶኮ ቶኮ ጦባላ ሆላ ከን ኣርሳ ጉበሙፍ ዮካን ቀልማፍ ዽኤፈሙ ወጅንስ ዳዺ ወይኒ ኢኒ ሀርከ አፉር ኬሳ ሀርከ ቶኮ ዽባዩዻፍ ቆጴስ። ");
INSERT INTO gaze_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘ኮርቤሰ ሆላ ቶኮ ወጅንስ ዳኩ ቡላኣ ኢፊ ሀርከ ኩዸን ኬሳ ሀርከ ለመ ከን ዘይቲ ኢኒ ሀርከ ሰዲ ኬሳ ሀርከ ቶኮን ሱኩመሜን ኬና ምዻኒ ቆጴስ። ");
INSERT INTO gaze_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","ዳዺ ወይኒ ኢኒ ሀርከ ሰዲ ኬሳ ሀርከ ቶኮ ዽባዩ ኡርጋንሳ ዋቀዮት ቶሉ ጎዺ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘አት ዮሙ ድብቸ ሎኒ ቶኮ ኣርሳ ጉበሙ ዮካን ቀልመ ወሬገ አዳቲፍ ዮካን ኣርሳ ነጋቲፍ ዋቀዮፍ ቆጴስቱት፣ ");
INSERT INTO gaze_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","ድብቸ ሰነ ወጅን ኬና ምዻኒ ፍድ፤ ኬናን ሱንስ ዳኩ ቡላኣ ኢፊ ሀርከ ኩዸን ኬሳ ሀርከ ሰዲ ከን ዘይቲ ወለካ ኢኒቲን ሱኩመሜ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","አከሱመስ ዳዺ ወይኒ ኢኒ ወለካ ዽባዩ ጎዺ ፍድ። ወን ኩንስ ኣርሳ እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","ቶኮን ቶኮን ድብቸ ሎኒ ዮካን ኮርቤሰ ሆላ፣ ቶኮን ቶኮን ጦባላ ሆላ ዮካን ኮርቤሰ ሬኤ ጥና ሃሉመ ከናን ሃቆጴፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","አኩመ ባይእነ ዋን ቆጴስተን ሰናት አኩመ ለኮብሰሳኒት፣ ቶኮ ቶኮሳኒቲፍ አከኑመ ጎዻ። ");
INSERT INTO gaze_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘ነምን ዸለታ ብየ ሰና ተኤ ሁንድኑ ዬሮ ኣርሳ እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ ፍዱት ወንቶተ ከኔን ሃሉመ ከናን ሃሆጄቱ። ");
INSERT INTO gaze_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","ዸሎተ ዹፉ ኬሰትስ አለጋን ዮካን ነምን ግዱኬሰን ጅራቱ ዬሮ ኣርሳ እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ ዽኤሱት አኩመ እስን ጎተን ከነ ሃጎዹ። ");
INSERT INTO gaze_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","ያኢን ሱን እስኒፊ አለጋ እስን ግዱ ጅራቱፍሌ ሴሩመ ቶኮ ሃቀባቱ፤ ኩንስ ዸሎተ ዹፉፍ ሴረ በረ በራት። አቲፊ አለጋን ሱን ፉለ ዋቀዮ ዱረት ወል ቅጤዸ። ");
INSERT INTO gaze_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","እስኒፍስ አለጋ እስን ግዱ ጅራቱፍስ ሴሪፊ ደምቢን ቶኩመ ሃተኡ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“አከነ ጄዺ እስራኤሎተት ዱበዹ፦ ‘እስን ዬሮ ብየ አን እት እስን ገልቹ ሰነ ሴንተኒ ");
INSERT INTO gaze_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","ምዻንሼ ኛተንት፣ ኛተ ሰነራ ዋቀዮፍ ኬና ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","ቡኮኬሰን ከን ጀልቀባራ መጥኖ ቶኮ ኬና ዽኤሳ፤ እሰስ አከ ኣርሳ ኦብዲራ ፉዸሜት ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","ዸሎተ ዹፉ ሁንዱማ ኬሰት ቡኮኬሰን ከን ጀልቀባራ ዋቀዮፍ ኬና ኬኑ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘ዮ እስን ኡቱ ህንቤክን አጀጀወን ዋቀዮ ሙሴት ኬኔ ከኔን ኬሳ ቶኮሌ ");
INSERT INTO gaze_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ጄቹንስ ዮ እስን አጀጀ ዋቀዮ ከን ጋፈ ዋቀዮ አጀጀ ከነ ኬኔ ጀልቀቤ ዸሎተ ዹፉ ኬሰሌ እቱመ ፉፉዻን ከራ ሙሴቲን እስን አጀጄ ከምዩ ጨብስተን፣ ");
INSERT INTO gaze_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","ዮ ወንት ኩን ዶጎጎራን ኡቱ ወልዳን ህንቤክን ሆጄተሜ ጅራቴ ወልዳን ሱን ሁንድ ድብቸ ሎኒ ኣርሳ ጉበሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ፣ ኬና ምዻኒቲፊ ዽባዩ አጀጀሜ ወጅን፣ ኣርሳ ጩቡቲፍሞ ኮርቤሰ ሬኤ ሃዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","ሉብንስ ወልዳ ሰበ እስራኤል ሁንዳፍ አራረ ሃቡሱ፤ እሳንስ ዋን ኡቱ ህንቤክን ጩቡ ሆጄተኒፍ፣ በሌሳሳኒቲፍስ ዋን ኣርሳ እብዳን ዽኤፈሙፊ ኣርሳ ጩቡ ዋቀዮፍ ፍደኒፍ ዺፈመ ንአርገቱ። ");
INSERT INTO gaze_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","ሰበቢ ሰብን ሁንድ በሌሳ ዶጎጎራን ሆጄተሜ ሰነ ኬሰት ህርማቴፍስ ወልዳን ሰበ እስራኤል ሁንዲፊ አለጋወን እሳን ግዱ ጅራተን ዺፈመ ንአርገቱ። ");
INSERT INTO gaze_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘ገሩ ዮ ነምን ቶኮ ቆፍት ኡቱ ህንቤክን ጩቡ ሆጄቴ እን ጎሮምቲ ሬኤ ከን ኡሙሪንሼ ወጋ ቶኮ ኣርሳ ጩቡቲፍ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","ሉብን ሱንስ ነምቸ ኡቱ እት ህንያድን ጩቡ ሆጄቴ ሰናፍ ፉለ ዋቀዮ ዱረት አራረ ሃቡሱ፤ ኤርገ አራር እሳፍ ቡኤ ቦዴሞ ነምች ሱን ዺፈመ ንአርገተ። ");
INSERT INTO gaze_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","ዸለታ እስራኤሊፍስ ተኡ ዮካን አለጋ እስን ግዱ ጅራቱፍ፣ ነመ ኡቱ እት ህንያድን ጩቡ ሆጄቴ ሁንዳፍ ሴር ቶኩመ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘ገሩ ዸለታ ብያስ ተኡ ዮካን አለጋን፣ ነምን ቤካ ጩቡ ሆጄቱ ዋቀዮን አረብሱሳት፤ ነምች ሱን ሰበሳ ኬሳ ሃበሌፈሙ። ");
INSERT INTO gaze_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","ነምች ሱን ሰበቢ ዱቢ ዋቀዮ ቱፈቴፊ ሰበቢ አጀጀሳ ጨብሴፍ እን ሃበሌፈሙ፤ በሌሳ እሳትስ እሰቱ ጋፈተመ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","ዬሮ ሰብን እስራኤል ገሞጂ ኬሰ ቱሬት፣ ነምን ቶኮ ኡቱ ጉያ ሰንበታቲን ቆራን ወልት ቀበቱ አርገሜ። ");
INSERT INTO gaze_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","ወር ኡቱ እን ቆራን ወልት ቀበቱ አርገንስ ሙሴት፣ አሮኒቲፊ ወልዳ ጉቱት እሰ ጌሰን፤ ");
INSERT INTO gaze_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","ሰበቢ ወን እሰ ጎዸን ህንቤከምኒፍ ህዸኒ እሰ ቱርሰን። ");
INSERT INTO gaze_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","ዋቀዮ ሙሴዻን፣ “ነምች ዱኡ ቀበ። ወልዳን ሱን ጉቱን ቁበታን አለት ዸጋዻን እሰ ሃቱሙ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","ወልዳን ሱን አኩመ ዋቀዮ ሙሴ አጀጄት ነምቸ ሰነ ቁበተ ኬሳ ገድ ባሴ ዸጋዻን ቱሜ አጄሴ። ");
INSERT INTO gaze_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“አከነ ጄዺ እስራኤሎተት ዱበዹ፦ ‘ዸሎተ ዹፉ ሁንደ ኬሰ ቀርቀረ ወያኬሰኒረት ሀንዳረ ቶልፈዻ፤ ቶኮን ቶኮን ሀንዳረ ሰናስ ፎኣ ብፈ ጩቁሊሳ ሃቀባቱ። ");
INSERT INTO gaze_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","እስን ሀንዳረ ከነ እላልተኒ አጀጀ ዋቀዮ ሁንደ ያደቱ፤ ኩንስ አከ አጀጀ ከነ ኤግደኒ ሀዊ ገራኬሰኒቲፊ ሀዊ እጀኬሰኒ ዱካ ቡኡዻን ህንሰጋገሌፍ። ");
INSERT INTO gaze_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","ዮስ እስን አጀጀኮ ሁንደ ያደተኒ ንኤግዱ፤ ዋቀኬሰኒፍስ ቁልቁሎተ ንታቱ። ");
INSERT INTO gaze_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","አን ዋቀዮ ዋቀኬሰን ከን ዋቀ እስኒ ተኡፍ ጄዼ ብየ ግብጢ እስን ባሴዸ። አን ዋቀዮ ዋቀኬሰን።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","ቆራህ እልም ይዝሃር፣ እልም ቆሃት፣ እልም ሌዊ፣ ጎሰ ሩቤን ኬሳሞ እልማን ኤሊያብ፣ ዳታኒፊ አቢራም አከሱመስ ኦን እልም ጴሌት ከአኒ ");
INSERT INTO gaze_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","ሙሴዻን ሞርመን። እሳን ወጅንስ ነሞተ እስራኤል ጄቹንስ ሆገንቶተ ወልዳ ቤቤከሞ ከኔን ምሴንሰ ያኢ ተአኒ ሙደመኒ ቱረን 250 ገአንቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","እሳንስ ሙሴፊ አሮኒን ሞርሙፍ ጄዸኒ ቶኩማዻን ወልት ቀበመኒ ዹፈኒ አከነ እሳኒን ጄዸን፤ “እስን ዱቢ ባይእፍተኒርቱ! ወልዳን ኩን ጉቱማት ቶኮን ቶኮንሳኒዩ ቁልቁሉዸ፤ ዋቀዮስ እሳን ወጅን ጅረ። ዮስ እስን ማሊፍ ወልዳ ዋቀዮረት ኦፍ ቱልቱሬ?” ");
INSERT INTO gaze_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","ሙሴን ዱቢ ከነ ዸጌኛን አዳን ለፈት ጎምብፈሜ። ");
INSERT INTO gaze_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","ኤርገሲስ ቆራሂፊ ወረ እሰ ዱካ ቡአን ሁንዳን አከነ ጄዼ፦ “ቦር ገነመ ዋቀዮ ነመ ከንሳ ተኤፊ ነመ ቁልቁሉ ተኤ ንአርግሲሰ፤ አከ ነምን ሱን ገረሳት ዽኣቱሌ ንጎዸ። እን ነመ ፍለቴ ሰነ አከ እን እት ዽኣቱ ጎዸ። ");
INSERT INTO gaze_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","ቆራህ፣ አቲፊ ወር ስ ዱካ ቡአን ሁንድ ዋን ከነ ጎዻ፦ ግርግራወን ፉዸዻቲ ");
INSERT INTO gaze_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","ቦር ፉለ ዋቀዮ ዱረት እብዳፊ እጣነ እት ነቃ። ነምን ዋቀዮ ፍለቱ እን ነመ ቁልቁሉ ተአ። እስን ሌዎትን ዱቢ ባይእፍተኒርቱ!” ");
INSERT INTO gaze_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","ሙሴንስ ቆራሂዻን አከነ ጄዼ፤ “እስን ሌዎትን ሜ ዸገኣ! ");
INSERT INTO gaze_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","ዋቅን እስራኤል ወልዳ እስራኤል ካን ኬሳ እስን ፍለቴ አከ እስን ሆጂ ዱንካነ ቁልቁሉ ዋቀዮ ሆጄተኒፊ አከ እስን ፉለ ወልዳ ዱረ ዻበተኒ እሳን ተጃጅልተኒፍ ጄዼ ኦፍት እስን ዽኤሱንሳ እስን ህንገኡ? ");
INSERT INTO gaze_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","እን ስኢፊ ሌዎተ ስ ወጅን ጅረን ሁንደ ኦፍት ዽኤሴረ፤ እስን ገሩ ሉቡማሌ ፉዸቹ በርባደን። ");
INSERT INTO gaze_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","ከናፉ አቲፊ ሚልቶትንኬ ሁንድኑ ወልት ቀበምተኒ ዋቀዮን ሞርምተን። አሮን እስን እት ጉንጉምተን ኩን ኤኙዸ?” ");
INSERT INTO gaze_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","ሙሴንስ ኤርገሲ እልማን ኤሊያብ ዳታኒፊ አቢራም ዋምስሴ። እሳን ገሩ አከነ ጄዸን፤ “ኑ ህንዹፍኑ! ");
INSERT INTO gaze_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","አት ገሞጂ ኬሰት ኑ ፍጡፍ ጄቴ ብየ ኣነኒፊ ደመ ባሱ ኬሳ ኑ ባሱንኬ ስ ህንገኡ? አመሞ ጎፍታ ኑት ተኡ ፌታ? ");
INSERT INTO gaze_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","ከነ መሌዩ አት ብየ ኣነኒፊ ደመ ባሱት ኑ ህንገልችኔ ዮካን ዻለ ለፈ ቆቲሳቲፊ እዶ ዻባ ወይኒ ኑ ህንኬንኔ። አት እጀ ነሞተ ከና ንባፍታ? ለኪ፣ ኑ ህንዹፍኑ!” ");
INSERT INTO gaze_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","ሙሴን አከ መሌ ኣሬ ዋቀዮን፣ “ኣርሳሳኒ ህንፉዸትን። አን ሀሬ ቶኮሌ እሳንራ ህንፉዸትኔ ዮካን እሳን ኬሳ ነመ ቶኮሌ ህንሚኔ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","ሙሴን ቆራሂዻን አከነ ጄዼ፤ “አቲፊ ሚልቶትንኬ ሁንድኑ አከሱመስ አት፣ እሳኒፊ አሮን ቦር ፉለ ዋቀዮ ዱረት አርገማ። ");
INSERT INTO gaze_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","ቶኮን ቶኮን ነማ ግርግራሳ ፉዸቴ፣ እጣነ እት ነቀቴ ፉለ ዋቀዮ ዱረት ሃዽኤሱ፤ ግርግራወን ኩኔንስ ወሉማ ገለት 250 ተኡ። አከሱመስ አቲፊ አሮን ግርግራኬሰን ዽኤሱ ቀብዱ።” ");
INSERT INTO gaze_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","ቶኮን ቶኮን ነማ ግርግራሳ ፉዸቴ፣ እብዳፊ እጣነ እት ነቀቴ ሙሴፊ አሮን ወጅን በልበለ ዱንካነ ወል ገኢ ዱረ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","ዬሮ ቆራህ እሳኒን ሞርሙፍ ጄዼ ዱካ ቡቶተሳ ሁንደ በልበለ ዱንካነ ወል ገኢ ዱረት ወልት ቀቤት፣ ኡልፍን ዋቀዮ ወልዳ ጉቱት ሙልአቴ። ");
INSERT INTO gaze_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","ዋቀዮ ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“አከ አን ዬሩመ ቶኮን እሳን ፍጡፍ ወልዳ ከነራ ገርገር በኣ።” ");
INSERT INTO gaze_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","ሙሴፊ አሮን ገሩ አዳን ለፈት ጎምብፈመኒ አከነ ጄዸኒ እየን፤ “ያ ዋቀዮ ዋቀ ሀፉሮተ ሰኚ ነመ ሁንዳ፣ አት ዮ ነምን ቶኮ የኬ ወልዳ ጉቱት ዼከምታ?” ");
INSERT INTO gaze_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“ወልዳ ከናን፣ ‘ዱንካኖተ ቆራህ፣ ከን ዳታኒቲፊ አቢራምራ ፈጋዻ’ ጄዽ።” ");
INSERT INTO gaze_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","ሙሴንስ ከኤ ገረ ዳታኒፊ አቢራም ዸቄ፤ ማንጉዶትን እስራኤልስ እሰ ዱካ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","እንስ ወልዳ ሰናን፣ “ዱንካነ ነሞተ ሀሞ ከኔኒራ ፈጋዻ! እስን አከ ሰበቢ ጩቡሳኒ ሁንዳን ህንበርበዴፈምኔፍ ዋን ከንሳኒ ተኤ ከምዩ ህንቱቅና” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","እሳን ዱንካኖተ ቆራህ፣ ከን ዳታኒፊ ከን አቢራሚስራ ፈጋተን። ዳታኒፊ አቢራሚስ ገድ በአኒ ኒቶተ፣ እጆሌፊ ዳእመንሳኒ ወጅን በልበለ ዱንካኖተሳኒ ዱረ ዸዻበቻ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","ኤርገሲ ሙሴን አከነ ጄዼ፤ “አን ወንቶተ ከኔን ሁንደ አከን ሆጄዹፍ ዋቀዮ አከ ነ ኤርጌ፣ ኩንስ ያደኮ አከ ህንተእን እስን ከናን ንቤክቱ፦ ");
INSERT INTO gaze_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","ዮ ነሞትን ኩኔን ዱኡመ ኡመማን ዹፉ ዱአኒፊ ወን ነመ ሁንደት ዹፉ እሳንት ዹፌ ዋቀዮ ነ ህንኤርግኔ። ");
INSERT INTO gaze_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","ገሩ ዮ ዋቀዮ ዋን ጉቱማን ጉቱት ሃራ ተኤ ቶኮ እሳንት ፍዴ ለፍት አፋን በንቴ ዋን እሳን ቀበን ሁንደ ወጅን እሳን ልቅምስቴ፣ ዮ እሳንስ ኡቱመ ሉቡን ጅረኑ ቦለ ቡአን፣ እስን አከ ነሞትን ኩኔን ዋቀዮን ቱፈተን ንቤክተን።” ");
INSERT INTO gaze_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","አኩመ እን ዋን ከነ ሁንደ ዱበቴ ፍጠቴን ለፍት እሳን ጀላ በቀቅጤ፤ ");
INSERT INTO gaze_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","ለፍት ሱንስ አፋን በንቴ ወረ መነሳኒ፣ ነሞተ ቆራህ ሁንዳፊ ቀቤኘሳኒ ሁንደ ወጅን እሳን ልቅምስቴ። ");
INSERT INTO gaze_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","እሳንስ ዋን ቀበን ሁንደ ወጅን ጅራት ቦለ ቡአን፤ ለፍትስ እሳንረት አፋን ወልት ዴብፈቴ፤ እሳንስ አከሲን ወልዳ ኬሳ በሌፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","እሳን እይናን እስራኤሎን ናኖሳኒ ቱረን ሁንድኑ፣ “ለፍት ኩን ኑንስ ንልቅምስት!” ጄዸኒ እያ በቀተን። ");
INSERT INTO gaze_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","እብድ ዋቀዮ ብራ ገድ ቡኤ ነሞተ 250 ከኔን ኣርሳ እጣና ዽኤሳ ቱረን ሰነ ፍጤ። ");
INSERT INTO gaze_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“አከ እን ግርግራወን ሰነ ለፈ ጀር እት ጉበመኒ ፉዼ ጭሌሳኒ ከን ቦበኡ አች ፈጌሴ ኬሳ ብትኔሱፍ ኤሌኣዛር እልመ አሮን ሉብቻት ህም፤ ግርግራወን ሱን ቁልቁሉዻቲ። ");
INSERT INTO gaze_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","ግርግራወን ኩኔንስ ግርግራወን ነሞተ ሉቡሳኒት ሙሩዻን ጩቡ ሆጄተኒት። ግርግራወን ሰነስ እዶ ኣርሳት ኡፍሱዻፍ ቱሚ ሀጵስ፤ እሳን ፉለ ዋቀዮ ዱረት ዽኤፈመኒ ቁልቁሉ ተአኒሩቲ። እሳንስ እስራኤሎታፍ መለቶ ሃተአን።” ");
INSERT INTO gaze_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","ኤሌኣዛር ሉብች ግርግራወን ናሲ ከኔን ነሞትን ጉበመን ሱን ዽኤሰን ሰነ እዶ ኣርሳት ኡፍሱዻፍ ጄዼ ወልት ቀቤ ቱሜ። ");
INSERT INTO gaze_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","ከነስ አኩመ ዋቀዮ ከራ ሙሴቲን እሰ አጀጄት ሆጄቴ። ኩንስ አከ ሰኚ አሮን መሌ ነምን ቶኮዩ እጣነ ኣርሱፍ ፉለ ዋቀዮ ዱረት ህንዽኣትኔ፣ ዮ ከና አቺ አከ እን አኩመ ቆራሂቲፊ ሚልቶተሳ ሰና ተኡ እስራኤሎተ ያደተኒፍ። ");
INSERT INTO gaze_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","ጉያ እት ኣኑት ወልዳን እስራኤል ሁንድ፣ “እስን ሰበ ዋቀዮ ፍጠን” ጄዸኒ ሙሴፊ አሮንት ጉንጉመን። ");
INSERT INTO gaze_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","ገሩ ዬሮ ወልዳን ሱን ሙሴፊ አሮኒን ሞርሙዻፍ ወልት ቀበሜ ገረ ዱንካነ ወል ገኢ እላሌት፣ ኩኖ ዱሜስ ዱንካነ ሰነ ሀጉጌ፤ ኡልፍን ዋቀዮስ ንሙልአቴ። ");
INSERT INTO gaze_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","ሙሴፊ አሮን ገረ ፉልዱረ ዱንካነ ወል ገኢ ዸቀን፤ ");
INSERT INTO gaze_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“አከ አን ዮሙሱመ እሳን በሌሱፍ፣ ወልዳ ከነ ብራ ፈጋዹ።” እሳንስ አዳን ለፈት ጎምብፈመን። ");
INSERT INTO gaze_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","ኤርገሲ ሙሴን አሮኒን አከነ ጄዼ፤ “ግርግራኬ ፉዸዹቲ እዶ ኣርሳራ እጣነ እብደ ወጅን እት ነቀዹቲ አራረ እሳኒፍ ቡሱዻፍ ገረ ወልዳት ፊግ። ዼከምስ ዋቀዮ ብራ ዹፌረ፤ ዸእች ጀልቀቤረ።” ");
INSERT INTO gaze_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","አሮን አኩመ ሙሴን ጄዼ ሰነ ፊጌ ግዱ ወልዳ ሴኔ። ዬሮ ከነት ዸእች ግዱ ወልዳት ጀልቀቤ ቱሬ። አሮን ገሩ እጣነ ዽኤሴ አራረ እሳኒፍ ቡሴ። ");
INSERT INTO gaze_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","እንስ ወረ ጅሩፊ ወረ ዱኤ ግዱ እጃጄ፤ ዸእች ሱንስ ንዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","ገሩ ነሞተ ሰበቢ ቆራሂቲፍ ዹመን መሌ ነሞተ 14,700 ገአንቱ ዸእቸ ሰናን ዹሜ። ");
INSERT INTO gaze_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","አሮን ሰበቢ ዸእች ሱን ዻበቴፍ ገረ በልበለ ዱንካነ ወል ገኢ ገረ ሙሴት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“እስራኤሎተት ዱበዹቲ ሆገንቶተ ጎሰ አቦቲሳኒ ሀርካ ኡሌ ቶኮ ቶኮ፣ ወሉማ ገለት ኡሌወን ኩዸ ለመ ፉዽ። መቃ ቶኮ ቶኮ ነማስ ኡሌሳረት በሬስ። ");
INSERT INTO gaze_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","ሰበቢ ቶኮ ቶኮ ሆገና ጎሰ አቦቲቲፍ ኡሌን ቶኮ ጅራቹ ቀቡፍ መቃ አሮን ኡሌ ሌዊረት በሬስ። ");
INSERT INTO gaze_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","ኡሌወን ከኔንስ ዱንካነ ወል ገኢ ኬሰ ፉለ ታቦተ ከኩ ሴራ ዱረ እዶ አን እት እስኒን ወል አርጉ ሰነ ካእ። ");
INSERT INTO gaze_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","ኡሌን ነመ አን ፍለዹ ንለተ፤ አንስ ጉንጉሚ እስራኤሎን ዬሮ ሁንደ እስንት ጉንጉመን ኦፍራ ነንኩተ።” ");
INSERT INTO gaze_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","ሙሴን እስራኤሎተት ዱበቴ፤ ሆገንቶትንሳኒስ ኡሌወን ኩዸ ለመ ጄቹንስ ሆገንቶተ ቶኮ ቶኮ ጎሰ አቦቲሳኒቲፍ ኡሌ ቶኮ ቶኮ እሰት ኬነን፤ ኡሌን አሮንስ ኡሌወን ሰነ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","ሙሴንስ ኡሌወን ሰነ ዱንካነ ዹገ በኡምሳ ኬሰ ፉለ ዋቀዮ ዱረ ካኤ። ");
INSERT INTO gaze_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","ጉያ እት ኣኑት ሙሴን ዱንካነ ዹገ በኡምሳ ሴኔ ኡሌን አሮን ከን ጎሰ ሌዊ እዶ ቡኡ ሱን እሳ ለቱ ቆፈ ኡቱ ህንተእን ሁዼ ደራሬ ለዉዚ ነቀቴ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","ሙሴን ኡሌ ሰነ ሁንደ ፉለ ዋቀዮ ዱራ አለት ገድ ባሴ እስራኤሎተ ሁንደት ፍዴ። እሳንስ እላለኒ ቶኮን ቶኮን ነማ ኡሌ ኦፊሳ ፉዸቴ። ");
INSERT INTO gaze_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ኡሌ አሮን ፉዺቲ አከ እን ፍንጭልቶታፍ መለቶ ተኡፍ ፉለ ታቦተ ከኩ ሴራ ዱረ ዴብሲ ካእ። ኩን አከ እሳን ህንዹምኔፍ ነት ጉንጉሙሳኒ ሰነ ዻበቺሰ።” ");
INSERT INTO gaze_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","ሙሴንስ አኩመ ዋቀዮ እሰ አጀጄ ሰነ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","እስራኤሎን ሙሴዻን አከነ ጄዸን፤ “ኑ ንዱነ! ኑ በድኔረ፤ ኑ ሁንድኑ በድኔረ! ");
INSERT INTO gaze_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","ነምን ዱንካነ ቁልቁሉ ዋቀዮት ዽኣቱ ከምዩ ንዱአ። ኑ አመ ዱኡፍ ጅራ?” ");
INSERT INTO gaze_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","ዋቀዮ አሮኒን አከነ ጄዼ፤ “አት፣ እልማንኬቲፊ ማቲን አባኬቲ ስ ወጅን የከ እዶ ቁልቁሉት ሆጄተሜት ንጋፈተምቱ። የከ ሉቡማት ሆጄተሜ ስኢፊ እልማንኬ ቆፈቱ እት ጋፈተመ። ");
INSERT INTO gaze_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","አከ እሳን ዬሮ አቲፊ እልማንኬ ፉለ ዱንካነ ዹገ በኡምሳ ዱረት ተጃጅልተንት ስት ደበለመኒ ስ ገርጋረኒፍ ኦቦሎተኬ ወረ ጎሰ ሌዊ፣ ወረ ጎሰ አባኬቲ ሰነ ፍድ። ");
INSERT INTO gaze_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","እሳንስ አጀጀኬ ዸገኡዻን ሆጂወን ዱንካነ ኬሳ ሁንደ ሃሆጄተን፤ ገሩ ምአ እዶ ቁልቁሉት ዮካን እዶ ኣርሳት ዽኣቹ ህንቀበን። ዮ አከስ ተኤ እሳንስ፣ አትስ ንዱቱ። ");
INSERT INTO gaze_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","እሳንስ ዱንካነ ወል ገኢ ኤጉዻፍ እስንት ደበለሙ ቀቡ፤ ሆጂ ዱንካነ ሰና ሁንደስ ሃሆጄተን። ነምን ብራ እዶ እስን ጅርተንት ዽኣቹ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“እስን አከ ዼከምስ አመስ እስራኤሎተረ ህንቡኔፍ ኤጉምሰ እዶ ቁልቁሉቲፊ ኤጉምሰ እዶ ኣርሳት ንጋፈተምቱ። ");
INSERT INTO gaze_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","አን መታንኮ ኦቦሎተኬሰን ሌዎተ ኬናወን እስኒ ኬነመን ጎዼ ሰበ እስራኤል ኬሳ ፍለዼረ፤ እሳንስ አከ ሆጂ ዱንካነ ወል ገኢ ኬሳ ሆጄተኒፍ ዋቀዮፍ ኬነመኒ ጅሩ። ");
INSERT INTO gaze_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","ገሩ ሆጂ እዶ ኣርሳቲፊ ሆጂ ጎልጋ ኬሳ ሁንደ ስኢፊ እልማንኬ ቆፈቱ ሆጄተ። አን ሆጂ ሉቡማ ኬና ጎዼ እስኒፍ ነንኬነ። ነምን ብራ ከን እዶ ቁልቁሉት ዽኣቱ ሃአጄፈሙ።” ");
INSERT INTO gaze_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","ዋቀዮ አሮኒን አከነ ጄዼ፤ “አን መታንኮ እት ጋፈተማ ኣርሳወን ና ዽኤፈመኒ ስ ጎዼረ፤ አን ኣርሳወን ቁልቁሉ እስራኤሎን ናፍ ዽኤሰን ሁንደ አከ እሳን በረ በራን ቆዳፊ ገኤኬሰን ተአኒፍ ስኢፊ እልማንኬቲፍ ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","ኩንስ ኣርሳወን ዋን ሁንደ ጫላ ቁልቁሉ ተአን ከኔን እብድ ህንቱቅን ኬሳ ቆደኬ ተአ። ኬናወን እሳን ኣርሳወን ዋን ሁንደ ጫላ ቁልቁሉ ተአን ጎዸኒ ና ፍደን ጄቹንስ ኣርሳወን ምዻኒ ዮካን ኣርሳወን ጩቡ ዮካን ኣርሳወን የካ ሁንደ ኬሳ ቆድን ሱን ከንኬቲፊ ከን እልማንኬቲት። ");
INSERT INTO gaze_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","እሰስ እዶ እዶ ሁንደ ጫላ ቁልቁሉ ተኤት ኛዹ፤ ዺር ሁንድ ሃኛቱ፤ እንስ ቁልቁሉ ሲፍ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“ወን ኩንስ ከኑመኬት፤ ኣርሳን ሶቾፈሙ ከን ኬና ሰበ እስራኤል ሁንደራ አዳን ባፈሜ ከኑመኬት። አንስ ዋን ከነ ስኢፊ እልማንኬቲፊ እንተለንኬ ከኔን ስ ወጅን ጅራተኒፍ ቆደ በረ በራ ጎዼ ኬኔረ። መነኬ ኬሳ ነምን አከ ሴራት ቁልቁሉ ተኤ ከምዩ ዋን ከነ ኛቹ ንደንደአ። ");
INSERT INTO gaze_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“ዘይቲ ኤጄርሳ ፍለተማ ሁንደ፣ ዳዺ ወይኒ ፍለተማ ሁንዳፊ ዋን ገልፈተን ኬሳ መታ ምዻኒ ከን እሳን ዋቀዮፍ ዽኤሰን ሲፍ ነንኬነ። ");
INSERT INTO gaze_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","መታን ምዻኒ ከን እሳን ዋን ብየቲራ አርገተን ሁንደ ኬሳ ዋቀዮፍ ፍደን ከንኬ ሃተኡ፤ መነኬ ኬሳ ነምን አከ ሴራት ቁልቁሉ ተኤ ከምዩ ዋን ከነ ኛቹ ንደንደአ። ");
INSERT INTO gaze_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“እስራኤል ኬሰት ወን ቁልቁሌፈሜ ዋቀዮፍ ኬነሜ ሁንድኑ ከንኬት። ");
INSERT INTO gaze_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","ወን ገደሜሰ ሳቁ ከምዩ ነመስ ተኡ ሆሪን ዋቀዮፍ ዽኤፈሙ ሁንድ ከንኬት። አት ገሩ እልመ ሀንገፈ፣ ሆሪ ቁልቁሉ ህንተእን ኬሳሞ ኮርመ ሀንገፈ ፉሩ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","ዬሮ ኡሙሪንሳኒ ጅአ ቶኮ ተኡት አከ ሰቅሊ እዶ ቁልቁሉ ከን ጌራ ድግደመ ኡልፋቱ ሰናት ገቲ ፉሪ ሙርታኤ ሜቲ ሰቅሊ ሸኒን እሳን ፉር። ");
INSERT INTO gaze_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“ገሩ ሰንጋ ሀንገፈ፣ ሆላ ሀንገፋፊ ሬኤ ሀንገፈ ህንፉርን፤ እሳን ቁልቁሉዸ። ዺገሳኒ እዶ ኣርሳረት ፈጫስ፤ ጮመሳኒሞ ኣርሳ እብዳን ዽኤፈሙ ከን ኡርጋንሳ ዋቀዮት ቶሉ ጎዺቲ ጉብ። ");
INSERT INTO gaze_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","አኩመ ሀንደራፍን ኣርሳ ሶቾፈሙቲፊ ተፍን ምርጋ ከንኬ ተኤ ሰነ ፎንሳኒስ ከንኬ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","አን ዋን ኣርሳ ቁልቁሉ እስራኤሎን ዋቀዮፍ ዽኤሰንራ አዳን ባፈሜ ሁንደ ሲፍ፣ እልማንኬቲፊ እንተለንኬቲፍ ቆደ በረ በራ ጎዼ ነንኬነ። እንስ ፉለ ዋቀዮ ዱረት ስኢፊ ሰኚኬቲፍ ከኩ ሶግዳ ከን በረ በራት።” ");
INSERT INTO gaze_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","ዋቀዮ አሮኒን አከነ ጄዼ፤ “አት ብየሳኒ ኬሰት ዻለ ቶኮሌ ዮካን ቆደ ቶኮሌ እሳን ግዱዻ ህንቀባቱ፤ አን ሰበ እስራኤል ኬሰት ቆደኬቲፊ ዻለኬት። ");
INSERT INTO gaze_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“ኩኖ አን ኬና እስራኤል ኬሰ ጅሩ ኩዸን ኬሳ ቶኮ ሁንደ ዋን እሳን ተጃጅለ ዱንካነ ወል ገኢ ተጃጅለኒፍ ዻለ ጎዼ ሌዎታፍ ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","ስአች እስራኤሎን አከ ጩቡ ህንባትኔፊ አከ ህንዱኔፍ ዱንካነ ወል ገኢት ህንዽኣትን። ");
INSERT INTO gaze_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","ከን ሆጂ ዱንካነ ወል ገኢ ሆጄቱፊ ከን እት ጋፈተመ የከ አችት ሆጄተሙ ፉዸቱ ሌዎቱመ። ኩንስ ዸሎተ ዹፉፍ ሴረ በረ በራት። እሳን ሰበ እስራኤል ኬሰት ዻለ ቶኮሌ ህንአርገተን። ");
INSERT INTO gaze_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","ቆደ ከና አን ዋን እስራኤሎን ኩዸን ኬሳ ቶኮ ኣርሳ ጎዸኒ ዋቀዮፍ ዽኤሰን ሰነ ዻለሳኒ ጎዼ ሌዎታፍ ኬኔረ። ሰበቢን አን፣ ‘እሳን ሰበ እስራኤል ኬሰት ዻለ ቶኮሌ ህንቀባተን’ ጄዼ ዋኤሳኒ ዱበዼፍስ ከኑመ።” ");
INSERT INTO gaze_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“አከነ ጄዺ ሌዎተት ዱበዹ፦ ‘ዮሙ ኬና ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ከን አን ዻለኬሰን ጎዼ እስኒፍ ኬኔ ሰነ እስራኤሎተራ ፉዸተንት እስን ኬና ሰነ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ኣርሳ ዋቀዮ ጎዻ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","ኣርሳንኬሰንስ አኩመ ምዻን ኦብዲራ ዮካን አኩመ ጩንፋ እዶ እጀ ወይኒ እት ጩንፈኒ ኬሳ በኤት እስኒፍ ሄሬገመ። ");
INSERT INTO gaze_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","እስንስ ሃሉመ ከናን ኬና ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ከን እስራኤሎተራ አርገተን ሁንደ ኬሳ ዋቀዮፍ ኣርሳ ንዽኤስቱ፤ ኬናወን ከኔን ኬሳስ ዋን ቆደ ዋቀዮ ተኤ አሮን ሉብቻፍ ኬና። ");
INSERT INTO gaze_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","ዋን እስኒ ኬነሜ ሁንደ ኬሳ ኩታ ዋን ሁንደ ጫላ ጋሪፊ ቁልቁሉ ተኤ ቆደ ዋቀዮ ጎዻቲ ዽኤሳ።’ ");
INSERT INTO gaze_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“ሌዎታን አከነ ጄዽ፦ ‘ዮሙ እስን ኩታ ዋን ሁንደ ጫላ ጋሪ ተኤ ዽኤስተንት ኩታን ሱን አከ ምዻን ኦብዲራ ዮካን አከ ጩንፋ እዶ እጀ ወይኒ እት ጩንፈን ኬሳ በኤት እስኒ ሄሬገመ። ");
INSERT INTO gaze_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","ሰበቢ ወን ኩን ምንዳ ሆጂ ዱንካነ ወል ገኢ ከን እስን ሆጄተኒ ተኤፍ እስኒፊ ነሞትን መነኬሰን ጅራተን ዋን ሀፌ ሰነ እዶ በርባደን ከምትዩ ኛቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","ቆደሳ ከን ዋን ሁንደ ጫሉ ሰነ ዽኤሱዻን እስን ዋን ከነ ኬሰት የከ ህንቀባተን፤ ዮስ እስን ኣርሳ እስራኤሎታ ቁልቁሉ ሰነ ህንጡሬስተን፤ ህንዱተንስ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","ዋቀዮ ሙሴፊ አሮኒን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“ሴር ዋቀዮ አጀጄ ከነ፦ አከ እስራኤሎን ጎሮምሰ ዲምቱ ህርእነ ዮካን ሀንቅነ ህንቀብኔ ከን ተኩማ ዋንጆን ሞርመሼ ህንቱቅን ቶኮ ሲፍ ፍደን እት ህም። ");
INSERT INTO gaze_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","ጎሮምሰ ሰነስ ኤሌኣዛር ሉብቸት ኬና፤ ራድ ሱንስ ቁበተ ኬሳ ገድ ባፈምቴ ፉለሳ ዱረት ሃቀለምቱ። ");
INSERT INTO gaze_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","ኤሌኣዛር ሉብች ቁበሳቲን ዺገ ጎሮምሰ ሰናራ ጥኖ ፉዼ ዱንካነ ወል ገኢ ዱረት ዬሮ ቶርበ ሃፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","ኡቱመ እን እላሉ ጎጋን፣ ፎን፣ ዺግኒፊ ጩማን ጎሮምሰ ሰና ሃጉበሙ። ");
INSERT INTO gaze_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","ሉብን ሱን ቆራን ብርብርሳ፣ ሂሶጲፊ ክሪ ብልዲማ ጎሮምሰ ጉበምቱ ሰነት ሃደርበቱ። ");
INSERT INTO gaze_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","ሉብን ሱን ኤርገሲ ወያ ኦፊሳ ሚጨቴ ዸግነ ኦፊሳሌ ብሻኒን ዽቀቹ ቀበ። እንስ ቁበተት ገሉ ደንደአ፤ ገሩ ሀመ ገልገላት አከ ሴራት ጡራኣ ተኤ ቱረ። ");
INSERT INTO gaze_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","ነምች ጎሮምሰ ሰነ ጉቡስ ወያሳ ሚጨቴ ዸግነሳ ብሻኒን ሃዽቀቱ፤ እንስ ሀመ ገልገላት ጡራኤ ቱረ። ");
INSERT INTO gaze_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“ነምን ቁልቁሉን ቶኮ ዳራ ጎሮምሰ ሰና ወልት ሀሬ ቁበተ ኬሳ ባሴ እዶ ሴራን ቁልቁሉ ተኤ ቶኮ ሃካኡ። ዳራ ከነስ ወልዳን እስራኤል ብሻን እቲን ቁልቁሌሰን ወጅን እት ፈየደሙዻፍ ኦል ካአተ፤ እንስ ጩቡራ ቁልቁሌፈሙፍ ፈየደ። ");
INSERT INTO gaze_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","ነምን ዳራ ጎሮምሰ ሰና ወልት ሀሩ ሱንስ ወያ ኦፊሳ ሚጨቹ ቀበ፤ እንስ አከሱመ ሀመ ገልገላት ጡራኣ ተአ። ኩንስ እስራኤሎታፊ አለጎተ ግዱሳኒ ጅራተኒፍ ሴረ በረ በራ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“ነምን ሬፈ ነመ ከሚዩ ቱቁ ቡልቲ ቶርበ ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","እን ጉያ ሰደፋፊ ጉያ ቶርበፋት ብሻኒን ኦፍ ቁልቁሌሱ ቀበ፤ ኤርገሲ ቁልቁሉ ተአ። ገሩ ዮ ጉያ ሰደፋፊ ቶርበፋት ኦፍ ቁልቁሌሱ ባቴ እን ህንቁልቁላኡ። ");
INSERT INTO gaze_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","ነምን ሬፈ ነመ ከሚዩ ቱቄ ኦፍ ህንቁልቁሌስን ሁንድ ዱንካነ ዋቀዮ ቁልቁልቸ ሰነ ጡሬሰ። ነምን ሱን ሰበ እስራኤል ኬሳ ንበሌፈመ። ሰበቢ ብሻን እቲን ቁልቁሌሰን እሰት ህንፈጫፈምኒፍ እን ጡራኣዸ፤ ጡራኡማንሳስ እሱመረት ሀፈ። ");
INSERT INTO gaze_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“ዬሮ ነምን ቶኮ ዱንካነ ኬሰት ዱኡት ሴር ከነ፦ ነምን ዱንካነ ሰነ ሴኑ ሁንዲፊ ነምን ዱንካነ ኬሰ ጅሩ ሁንድ ቡልቲ ቶርባፍ ጡራኣ ተአ፤ ");
INSERT INTO gaze_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","ቆዳን አፋን በና ከን ቀዳድን ጀቤፈሜ እት ህንቀዳደምን ሁንድ ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“ነምን አለት ነመ ጎራዴዻን አጄፈሜ ዮካን ነመ ኦፉማን ዱኤ ቱቁ ከምዩ ዮካን ነምን ለፌ ነማ ዮካን አዋለ ቱቁ ከምዩ ቡልቲ ቶርባፍ ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“ነመ ጡራኣፍ ኣርሳ እቲን ቁልቁሌሱፍ ጉበሜ ሰነራ ዳራ ጥናሳ ፉዺ ኦኮቴ ቶኮት ነቂቲ ብሻን ያኡ እት ዸንገላስ። ");
INSERT INTO gaze_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","ኤርገሲስ ነምን አከ ሴራት ቁልቁሉ ተኤ ሂሶጲ ጥናሳ ፉዼ ብሻን ሰነ ኬሰ ጩጴ ዱንካናፊ ምአሳ ሁንደት፣ ነሞተ አች ቱረንትስ ሃፈፈጫሱ። አከሱመስ ነመ ለፌ ነማ ዮካን አዋለ ዮካን ነመ አጄፈሜ ዮካን ነመ ኦፉማን ዱኤ ቱቄት ሃፈፈጫሱ። ");
INSERT INTO gaze_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","ነምች ቁልቁሉን ሱን ጉያ ሰደፋፊ ቶርበፋት ነምቸ ጡራኣ ሰነት ሃፈፈጫሱ፤ ጉያ ቶርበፋትሞ እሰ ቁልቁሌሱ ቀበ። ነምች ቁልቁሌፈሙ ሱን ወያ ኦፊሳ ሚጨቹ፣ ዸግነ ኦፊሳስ ብሻኒን ዽቀቹ ቀበ፤ እንስ ገልገለ ሰነ ቁልቁሉ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","ገሩ ነምን ጡራኣን ዮ ኦፍ ቁልቁሌሱ ባቴ፣ እን ሰበቢ እዶ ቁልቁሉ ዋቀዮ ጡሬሴፍ ወልዳ ኬሳ ንበሌፈመ። ብሻን እቲን ቁልቁሌሰን ሱን እሰት ህንፈጫፈምኔቲ እን ጡራኣዸ። ");
INSERT INTO gaze_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","ኩን እሳኒፍ ሴረ በረ በራት። “ነምች ብሻን እቲን ቁልቁሌሰን ፈፈጫሱ ሱን ወያ ኦፊሳ ሃሚጨቱ፤ ነምን ብሻን እቲን ቁልቁሌሰን ቱቁ ሀመ ገልገላት ጡራኣ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","ወን ነምን ጡራኣን ቶኮ ቱቁ ከምዩ ጡራኣ ተአ፤ ነምን ዋን ሰነ ቱቁ ሀመ ገልገላት ጡራኣ ተአ።” ");
INSERT INTO gaze_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","ጅአ ጀልቀባት ወልዳን እስራኤሎታ ጉቱን ገሞጂ ሲን ገኤ፤ እሳንስ ቃዴሽ ኬሰ ቱረን። ሚርያምስ አችት ዱቴ አዋለምቴ። ");
INSERT INTO gaze_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","ወልዳን ሱን ብሻን ህንቀቡ ቱሬ፤ ከናፉ ወልዳን ሱን ሙሴፊ አሮኒን ሞርሙፍ ወልት ቀበሜ። ");
INSERT INTO gaze_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","እሳንስ አከነ ጄዸኒ ሙሴፊ አሮኒን ሎለን፤ “ማሎ ኡቱ ኑስ ጋፉመ ኦቦሎትንኬኘ ፉለ ዋቀዮ ዱረት ዱአን ሰነ ዱኔ ጅራትኔ! ");
INSERT INTO gaze_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","እስን ማሊፍ ወልዳ ዋቀዮ ገሞጂ ከነት ፍደን? አከ ኑፊ ሆሪንኬኘ አስት ዹምኑፊ? ");
INSERT INTO gaze_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","ማሊፍ ብየ ግብጢቲ እዶ ሀማ ከነት ገድ ኑ ባፍተን? እዶን ኩን ምዻን ዮካን ሀርቡ ዮካን እጀ ወይኒ ዮካን ሮማኒ ህንቀቡ። ብሻን ዹጋቲስ ህንጅሩ!” ");
INSERT INTO gaze_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","ሙሴፊ አሮን ወልዳ ብራ ገረ በልበለ ዱንካነ ወል ገኢ ዴመኒ አዳን ለፈት ጎምብፈመን፤ ኡልፍን ዋቀዮስ እሳንት ሙልአቴ። ");
INSERT INTO gaze_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“ኡሌ ሰነ ፉዺቲ፣ አቲፊ ኦቦሌስኬ አሮንስ ወልዳ ወልት ቀባ። ፉሉመሳኒ ዱረትስ ከታ ሰነት ዱበዻ፤ ከታን ሱንስ ብሻን ባሰ። አትስ ከታ ሰነ ኬሳ ወልዳዻፍ ብሻን ባፍተ፤ አከሲን እሳኒፊ ሆሪንሳኒ ብሻን ዹጉ ደንደኡ።” ");
INSERT INTO gaze_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","ከናፉ ሙሴን አኩመ እን እሰ አጀጄ ሰነት ኡሌ ፉለ ዋቀዮ ዱረ ጅሩ ሰነ ፉዼ። ");
INSERT INTO gaze_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","ሙሴፊ አሮን ከታ ሰነ ዱረት ወልዳ ወልት ቀበን፤ ሙሴንስ ወልዳ ሰናን፣ “ፍንጭልቶተነነ፣ ሜ ዸገኣ፤ ኑ ከታ ከነ ኬሳ ብሻን እስኒ ባሱ ቀብና?” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","ሙሴን ሀርከ ኦል ፉዸቴ ኡሌሳ ሰናን ዬሮ ለመ ከታ ሰነ ዸኤ። ብሻን አች ኬሳ ሎላናን ወልዳፊ ሆሪንሳኒ ዹገን። ");
INSERT INTO gaze_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","ዋቀዮ ገሩ ሙሴፊ አሮኒን አከነ ጄዼ፤ “ሰበቢ እስን ፉለ እስራኤሎታ ዱረት አከ ቁልቁሉማኮቲት ነ ከበጀኒ ነት አመኑ ድደኒፍ፣ እስን ብየ አን እሳኒ ኬኔ ሰነት ወልዳ ከነ ህንገልችተን።” ");
INSERT INTO gaze_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","ኩን ብሻን መሪባ፣ ለፈ እስራኤሎን እት ዋቀዮን ወል ዸበኒፊ ለፈ እን እት አከ ቁልቁሉ ተኤ ግዱሳኒት ኦፍ አርግሲሴት። ");
INSERT INTO gaze_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","ሙሴን አከነ ጄዼ ቃዴሽራ ሞቲ ኤዶሚት ኤርገሞተ ኤርጌ፦ “ኦቦሌስኬ እስራኤል አከነ ጄዸ፦ አት ዋኤ ረክነ ኑት ዹፌ ሁንዳ ንቤክተ። ");
INSERT INTO gaze_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","አቦቲንኬኘ ግብጥት ገድ ቡአን፤ ኑስ ወጋ ሄዱ አች ጅራትኔ። ወር ግብጥስ ኑፊ አቦቲኬኘ ጩንቁርሰን፤ ");
INSERT INTO gaze_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","ገሩ ኑ ዋቀዮት እየትናን፣ እን ኑ ዸገኤ ኤርገማሳ ኤርጌ ብየ ግብጢ ኑ ባሴ። “ኑ አመ አስ ቃዴሽት ጄቹንስ መጋላ ዳሪ ብየኬቲረ ጅሩ ቶኮ ኬሰ ጅረ። ");
INSERT INTO gaze_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","ማሎ ሜ አከ ብየኬ ኬሰ ባኔ ደበሩ ኑ ኤየም። ኑ ለፈ ቆቲሳ ዮካን እዶ ዻባ ወይኒ ቶኮ ኬሰዩ ህንያኑ ዮካን ብሻን ቦለ ብሻኒ ቶኮዩ ስ ዱራ ህንዹግኑ። ኑ ከራ ሞትቻረ ጎዳነ መሌ ሀመ ዳሪኬ ኬሳ ባኑት ብታ ምርገት ህንጎሩ።” ");
INSERT INTO gaze_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","ኤዶምሞ አከነ ጄዼ ዴቢ ኬኔ፦ “እስን አሲን ደርቡ ህንደንዴሰን፤ ዮ ደርቡ ያልተንሞ ኑ እስንት ካኔ ጎራዴዻን እስን ዾፍነ።” ");
INSERT INTO gaze_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","እስራኤሎንስ አከነ ጄዸኒ ዴቢ ኬነን፦ “ኑ ከሩመ ጉድቸረ ያነ፤ ዮ ኑ ዮካን ሆሪንኬኘ ብሻንኬሰን ከምዩ ዹጌ፣ ኑ ገቲ እስኒፍ ከፈለ። ኑ ሚለ ቆፋን ያኔ ደርቡ ፌነ፤ ከነ መሌ ዋን ብራ ህንፌኑ።” ");
INSERT INTO gaze_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","እሳን አመሌ አከነ ጄዸኒ ዴብሰን፦ “እስን አሲን ህንደበርተን።” ኤዶምስ ሎልቶተ ባይኤፊ ጀጀቦ ፉዸቴ እሳንት ገድ በኤ። ");
INSERT INTO gaze_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","ሰበቢ ኤዶም ብየ ኦፊሳ ኬሳን ደርቡ እሳን ዾዌፍ እስራኤሎን እሳንራ ዴብአን። ");
INSERT INTO gaze_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","ሰብን እስራኤል ሁንድኑ ቃዴሺ ከኤ ቱሉ ሆር ገኤ። ");
INSERT INTO gaze_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","ዋቀዮስ ቱሉ ሆር ጭነት ዳንጋ ኤዶም ብረት ሙሴፊ አሮኒን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“አሮን ገረ አቦቲሳት ወልት ቀበመ። ሰበቢ እስን ለቹ ብሻን መሪባ ብረት አጀጀኮት ፍንጭልተኒፍ፣ እን ብየ አን እስራኤሎታፍ ኬኑት ህንገሉ። ");
INSERT INTO gaze_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","አሮኒፊ እልመሳ ኤሌኣዛር ፉዺቲ ቱሉ ሆርት ኦል ባስ። ");
INSERT INTO gaze_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","አሮንራ ኡፈተሳ ባሲቲ እልመሳ ኤሌኣዛርት ኡፍስ፤ አሮን ገረ አቦቲሳት ወልት ቀበማቲ። እን አችት ዱአ።” ");
INSERT INTO gaze_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","ሙሴን አኩመ ዋቀዮ እሰ አጀጄ ሰነ ጎዼ፦ እሳንስ ኡቱመ ወልዳን እስራኤል ጉቱን እላሉ ቱሉ ሆርት ኦል በአን። ");
INSERT INTO gaze_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","ሙሴንስ ኡፈተ አሮንራ ባሴ እልመሳ ኤሌኣዛርት ኡፍሴ። አሮንስ አቹመ ቱሉ ሰነ ጉባት ዱኤ። ሙሴፊ ኤሌኣዛርስ ቱሉ ሰነራ ገድ ቡአን፤ ");
INSERT INTO gaze_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","ዮሙ ወልዳን እስራኤል ሁንድ አከ አሮን ዱኤ ዸገኤት መን እስራኤል ጉቱን ቡልቲ ሶዶመ ቦኤፍ። ");
INSERT INTO gaze_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","ሞቲን ኣራድ ነምች ከነኣን ከን ኔጌብ ኬሰ ጅራቱ ሱን አከ እስራኤል ከራ አታሪምረ ዹፋ ጅሩ ዸጌኛን እስራኤሎተ ሎሌ እሳን ኬሳ ነመ ቶኮ ቶኮ ቦጅኤ። ");
INSERT INTO gaze_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","እስራኤሎንስ፣ “ዮ አት ሰበ ከነ ደበርስቴ ሀርከኬኘት ኬንቴ፣ ኑ ጉቱማን ጉቱት መጋላሳኒ በርበዴስነ” ጄዸኒ ዋቀዮፍ ወሬገን። ");
INSERT INTO gaze_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","ዋቀዮስ እየ እስራኤል ዸገኤ ወረ ከነኣን ደበርሴ ሀርከሳኒት ኬኔ። እስራኤሎትንስ እሳኒፊ መጋላወንሳኒሌ ጉቱማን ጉቱት በርበዴሰን፤ ከናፉ እዶን ሱን ሆርማ ጄዸሜ ዋመሜ። ");
INSERT INTO gaze_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","እሳንስ ኤዶም ዱባን ደርበኒ ዴሙፍ ጄዸኒ ጋረ ሆሪ ከአኒ ከራ ገላነ ዲማት ጌሱረ ቀጄለን። ሰብን ሱን ገሩ ከሩመት ኦብሰ ፍጠቴ፤ ");
INSERT INTO gaze_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","እሳንስ ዋቃፊ ሙሴዻን ሞርመኒ አከነ ጄቹዻን ዱበተን፤ “እስን ማሊፍ አከ ገሞጂ ኬሰት ዹምኑፍ ብየ ግብጢ ኑ ባፍተን? ቡዴን ህንጅሩ! ብሻን ህንጅሩ! ኑስ ኛተ በልፈማ ከነ ጅብኔረ!” ");
INSERT INTO gaze_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","ዋቀዮስ ቦፈወን ሀዻ ቀበን ግዱሳኒት ኤርጌ፤ ቦፈወን ሱንስ እሳን እደኒ እስራኤሎን ባይኤን ዹመን። ");
INSERT INTO gaze_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","ሰብን ሱንስ ገረ ሙሴ ዹፌ አከነ ጄዼ፤ “ኑ ዬሮ ዋቀዮፊ ስት አፋን ደበሬ ሰነ ጩቡ ሆጄትኔ። አከ ዋቀዮ ቦፈወን ከኔን ኑራ ፈጌሱፍ ኑፍ ከዸዹ።” ሙሴን ሰበ ሰናፍ ከዸቴ። ");
INSERT INTO gaze_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ቦፈ ቶኮ ቶልቺቲ ኡቱባት ፈንስ፤ ነምን ቦፍን እዴ ከምዩ ቦፈ አት ቶልችቴ ሰነ እላሌ ጅራቹ ደንደአ።” ");
INSERT INTO gaze_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","ሙሴን ቦፈ ናሲ ቶኮ ቶልቼ ኡቱባት ፈንሴ። ኤርገሲስ ነምን ቦፍት እዴ ከምዩ ዬሮ ቦፈ ናሲ ሰነ እላሉ ንጅራተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","እስራኤሎን ፉለ ዱረት ቀጄለኒ ኦቦት ኬሰ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","ኤርገሲስ ኦቦቲ ከአኒ እዬ አባሪም ለፈ ከራ በአ ቢፍቱቲን ፉሌ ሞኣብት ገሞጂ ኬሰት አርገሙ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","አቺስ ከአኒ ሱሉለ ዜሬድ ኬሰ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","አቺ ከአኒስ ዳሪ አርኖን ለፈ ገሞጂ ኬሳ ከን ቡልቺንሰ አሞሮታ ኬሰ ሴንቱ ሰነረ ቁበተን። አርኖን ለፈ ዳሪ ሞኣብራ ከን ሞኣቢፊ አሞር ግዱ ጅርቱዸ። ");
INSERT INTO gaze_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","ሰበቢን ክታብን ወራነ ዋቀዮ አከነ ጄዹፍ ከነ፦ “ዋሄብ ሱፋ ኬሳፊ ለጌን፣ አርኖኒፊ ");
INSERT INTO gaze_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","እራን-ገዴ ሱሉላ ከን ገረ ኣርት ጌሱፊ ዳሪ ሞኣብ እረት አርገሙ።” ");
INSERT INTO gaze_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","አቺ ከአኒ ገረ ብኤር ቦለ ብሻኒ ከን ዋቀዮ ሙሴዻን፣ “ሰበ ወልት ቀብ፤ አን ብሻን ኬናፊ” ጄዼ ሰና ከራሳኒ እት ፉፈን። ");
INSERT INTO gaze_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","እስራኤልስ ፋርፈትና ከነ ፋርፈቴ፦ “ያ ቦለ ብሻኒነነ፣ ቡርቅ! እስንስ ዋኤሳ ፋርፈዻ፤ ");
INSERT INTO gaze_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","ቦለ ብሻኒ እልማን ሞቲ ቆተን፣ ከን ከበጀሞን ሰባ፣ ቀጄልቸ ወረ ሴረ ኬኑቲን ኡሌሳኒቲን ቆተን ፋርፈዻ።” እሳን ኤርገሲ ገሞጂ ሰነ ኬሳ በአኒ መታና ዸቀን፤ ");
INSERT INTO gaze_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","መታናዻ ከአኒ ነሃልኤል ዸቀን፤ ነሃልኤሊ ከአኒ ባሞት ዸቀን፤ ");
INSERT INTO gaze_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","ባሞቲሞ ከአኒ ሱሉለ ሞኣብ፣ እዶ እት ፊጤን ጵስጋ ገሞጂት ገረገልቱ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","እስራኤልስ ስሆን ሞትቸ አሞሮታቲን አከነ ጄቹፍ ኤርገሞተ ኤርገቴ፦ ");
INSERT INTO gaze_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“አከ ኑ ብየኬ ኬሳን ደርብኑ ኑፍ ኤየም። ኑ ለፈ ቆቲሳ ዮካን እዶ ዻባ ወይኒ ቶኮትዩ ህንጎሩ ዮካን ብሻን ቦለ ብሻኒ ቶኮሌ ህንዹግኑ። ኑ ሀመ ብየኬ ኬሳ ባኑት ከራ ሞትቻረ ያነ።” ");
INSERT INTO gaze_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","ስሆን ገሩ አከ እስራኤል ብየሳ ኬሰ በኤ ደርቡ ህንኤየምኔ። እንስ ሎልቶተ ኦፊ ጉቱ ወልት ቀበቴ እስራኤልን ሎሉፍ ገሞጂት ገድ በኤ። ዮሙ ያሀዝ ገኤትስ እስራኤሊን ወል ሎሌ። ");
INSERT INTO gaze_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","እስራኤል ገሩ ጎራዴዻን እሰ አጄሴ አርኖኒ ጀልቀቤ ሀመ ያቦቅ ገኡት ብየሳ ቀበቴ፤ ገሩ ሰበቢ ደላን ዳንጋ አሞሮታ ጀባ ቱሬፍ እን ሀመ ዳንጋ አሞኖታ ቆፈት ዴሙ ደንደኤ። ");
INSERT INTO gaze_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","እስራኤልስ መጋላወን አሞሮታ ሁንደ፣ ሄሽቦኒፊ ቁበተወን ናኖሼ ጅረን ሁንደ ቀበቴ ኬሰ ቁበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","ሄሽቦን ኩን መጋላ ስሆን ሞቲ አሞሮታ እሰ ሞትቸ ሞኣብ ከን ዱራ ሎሌ ብየሳ ሁንደ ሀመ አርኖንትራ ፉዸቴ ሰና ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","ሰበቢን ዌልስቶትን አከነ ጄዸኒፍ ከነ፦ “ገረ ሄሽቦን ኮታ፤ እሼን ዴብቴ ሃእጃረምቱ፤ መጋላን ስሆንስ ሃሃሮምፈምቱ። ");
INSERT INTO gaze_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“ሄሽቦን ኬሳ እብድ፣ መጋላ ስሆን ኬሳ አረብን እብዳ በኤ። እብድ ሱን ኣር መጋላ ሞኣብ፣ ጅራቶተ ጋረ አርኖኒስ ጉቤ በርበዴሴ። ");
INSERT INTO gaze_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","ያ ሞኣብ፣ ሲፍ ወዮ! ያ ወረ ኬሞሽ፣ እስን በርበዶፍተኒርቱ! እን እልማንሳ አከ በቀቶታት፣ እንተለንሳሞ አከ ቦጅአምቶታት፣ ስሆን ሞቲ አሞሮታት ደበርሴ ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“ኑ ገሩ እሳን ገረገልችኔረ፤ ሄሽቦን ሀመ ዲቦንት በርበዶፍቴርት። ኑስ ሀመ ኖፋ እሼ ገረ ሜዴባት ድሪርቱ ሰናት እሳን በርበዴስኔረ።” ");
INSERT INTO gaze_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","አከሲን እስራኤል ብየ አሞር ኬሰ ቁበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","ሙሴን የእዜርት በሳስቶተ ኤርጌ፤ እሳንስ ቁበተወን ናኖሼ ቀበተኒ አሞሮተ አች ኬሰ ጅራቻ ቱረን አርአኒ ባሰን። ");
INSERT INTO gaze_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","እሳንስ ኤርገሲ ዴብአኒ ከራ ባሻን ቀበተኒ ኦል በአን፤ ኦግ ሞትች ባሻኒቲፊ ሎልቶትንሳ ጉቱን ኤድሬዪት እሳኒን ወል ሎሉፍ እት ገድ በአን። ");
INSERT INTO gaze_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ሰበቢ አን ጉቱ ሎልቶተሳቲፊ ብየሳሌ ደበርሴ ሀርከኬት ኬኔፍ እሰ ህንሶዳትን። ዋኑመ ስሆን ሞቲን አሞሮታ ከን ሄሽቦን ቡልቻ ቱሬ ሰነ ጎቴ እሰሌ ጎዽ።” ");
INSERT INTO gaze_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","እሳን እሰ፣ እልማንሳቲፊ ሎልቶተሳ ሁንደ ኡቱ ነመ ቶኮሌ ህንሀምብስኒፍ ዸአኒ ብየሳሌራ ፉዸተን። ");
INSERT INTO gaze_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","እስራኤሎን ገረ ድሬ ሞኣብት ቀጄለኒ ዬርኮን ገመ ቀርቀረ ዮርዳኖስ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","ባላቅ እልም ዝጶር ዋን እስራኤል አሞሮተት ሆጄቴ ሁንደ አርጌ፤ ");
INSERT INTO gaze_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","ሞኣብስ ዋን ሰብን ሱን አከ መሌ ባይኤ ተኤፍ ንሶዳቴ። ሞኣብስ ሰበቢ እስራኤሎታቲፍ ራፈሜ። ");
INSERT INTO gaze_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","ወር ሞኣብስ ማንጉዶተ ምድያኒን፣ “ነሞትን ባይኤን ኩኔን አኩመ ቆትዮን መርገ በኬ ዼዴ ፍጡ ሰነ ዋን ናኖኬኘ ጅሩ ዼዴ ፍጠ” ጄዸን። ከነረት ባላቅ እልም ዝጶር ከን ዬሮ ሰነ ሞቲ ሞኣብ ቱሬ ሱን፣ ");
INSERT INTO gaze_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","አከ እሳን በለኣም እልመ ቤኦር ከን ብዩመ እት ዸለቴ ኬሰ ለገ ኤፍራጢስ ብረ ጴቶር ኬሰ ጅራቻ ቱሬ ሰነ ዋመኒፍ ኤርገሞተ ኤርጌ። ባላቅስ አከነ ጄዼ፦ “ኩኖ፣ ሰብን ቶኮ ብየ ግብጢ በኤ ዹፌረ፤ ኩኖ እሳን ለፈ ጉተኒ ነት ኣነኒ ቁበተኒሩ። ");
INSERT INTO gaze_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","ሰበቢ እሳን ነ ጫላ ሁምነ ቀበኒፍ አመ ኮቱቲ እሳን አባር። ዮስ አን እሳን ሞአዼ ብየ ኬሳ አርኤ እሳን ባሱ ነንደንደአ ተአ። አን አከ ወር አት ኤብፍቱ ኤብፈመን፣ ወር አት አባርቱስ አባረመን ነንቤካቲ።” ");
INSERT INTO gaze_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","ማንጉዶትን ሞኣቢፊ ምድያን ሱን ከአኒ ከፈልቲ ሞርቱ ሰና ፉዸተኒ ዴመን። እሳንስ ዮሙ በለኣም ብረ ገአንት ዋን ባላቅ ጄዼን ሰነ እት ህመን። ");
INSERT INTO gaze_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","በለኣምስ፣ “ሀልከን ከነ አሱመ ቡላ፤ አንስ ዴቢ ዋቀዮ ናፍ ኬኑ እስንት ነንህመ” ጄዼን። ቆንዳልቶትን ሞኣብ ሱን እሱመ ብረ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","ዋቅን ገረ በለኣም ዹፌ፣ “ነሞትን ስ ወጅን ጅረን ኩኔን ኤኙ?” ጄዼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","በለኣምስ አከነ ጄዼ ዋቃፍ ዴቢ ኬኔ፤ “ባላቅ እልም ዝጶር፣ ሞትች ሞኣብ አከነ ጄዼ ኤርጋ ከነ ነት ኤርጌ፦ ");
INSERT INTO gaze_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘ኩኖ፣ ሰብን ብየ ግብጢ በኤ ዹፌ ቶኮ ለፈ ጉቴረ፤ አት አመ ኮቱቲ እሳን ናፍ አባር። ዮስ አን እሳን ሎሌ አርኤ ብያ ባሱ ነንደንደአ ተኣቲ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","ዋቀዮ ገሩ በለኣሚን፣ “እሳን ወጅን ህንዴምን። ሰበቢ እሳን ኤብፈሞ ተአኒፍ አት ሰበ ሰነ ህንአባርን” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","በለኣም ገነመ እት ኣኑ ከኤ ቆንዳልቶተ ባላቂን፣ “ሰበቢ ዋቀዮ እስን ወጅን ዴሙ ነ ዾዌፍ፣ እስን አመ ከኣ ብየኬሰንት ዴብኣ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","ቆንዳልቶትን ሞኣብ ገረ ባላቅት ዴብአኒ፣ “በለኣም ኑ ወጅን ዹፉ ድዴ” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","ባላቅስ ቆንዳልቶተ ወረ ዱራ ሰነ ጫላ ባይኤፊ ጫላ ቤቤከሞ ከን ብራ ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","እሳንስ ዹፈኒ በለኣሚን አከነ ጄዸን፦ “ወን ባላቅ እልም ዝጶር ጄዹ ኩኖ ከነ፦ ‘ማሎ ወን ቶኮዩ ገረኮ ዹፉ ስ ህንዾውን፤ ");
INSERT INTO gaze_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","አን ኡልፍነ ጉዳ ሲፍ ነንኬናቲ፤ ዋን አት ጄቱ ሁንደስ ነንጉተ። ኮቱ ሰበ ከነ ና አባር።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","በለኣም ገሩ አከነ ጄዼ ዴብሴፍ፤ “ኡቱ ባላቅ መሰራሳ ከን ሜቲፊ ወርቄን ጉተሜ ሰነ ናፍ ኬኔሌ፣ አን አጀጀ ዋቀዮ ዋቀኮቲን አለት ዋን ጥና ዮካን ጉዳ ቶኮሌ ሆጄቹ ህንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","አከ አን ዋን ዋቀዮ ነት ህሙ ከን ብራ ቤኩ ደንደኡፍ እስንስ አኩመ ወረ ካኒ አስ ቡላ።” ");
INSERT INTO gaze_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","ሀልከን ሰነ ዋቀዮ ገረ በለኣም ዹፌ፣ “ሰበቢ ነሞትን ኩኔን ዋሙ ዹፈኒፍ፣ እሳን ወጅን ዴም፤ ገሩ ዋኑመ አን ስት ህሙ ቆፈ ሆጄዹ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","በለኣም ገነማን ከኤ ሀሬሳረ ኮራ ካአቴ ቆንዳልቶተ ሞኣብ ሰነ ወጅን ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","ዋቅን ገሩ እን ዴምናን እት ኣሬ፤ ኤርገማን ዋቀዮ ቶኮስ እሳን ሞርሙፍ ጄዼ ከራረ ዻበቴ። በለኣምስ ሀሬሳ ያበቴ ዴማ ቱሬ፤ ተጃጅልቶትንሳ ለማን እሰ ወጅን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","ሀሬን ሱንሞ ኤርገማ ዋቀዮ ከን ጎራዴ ሉቅፈቴ ሀርከት ቀበቴ ከራረ ዻበቱ አርግናን ኦፍረ ገረ ገልቴ ከራራ ጎርቴ ለፈ ቆቲሳ ሴንቴ። በለኣምስ ከራት እሼ ዴብሱዻፍ ሀሬ ሰነ ሩኩቴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","ኤርገማን ዋቀዮ ሱን ገሩ ዳንዲ ዽጶ፣ እዶ ዻባ ወይኒ ለመ ከኔን ገመ ለማን ደላ ቀበን ግዱ ባቱረ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","ሀሬን ሱን ኤርገማ ዋቀዮ አርግናን፣ ደላት መጠንቴ ሚለ በለኣም ደላት ቡፍቴ። እን አመስ ሀሬ ሰነ ሩኩቴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","ኤርገማን ዋቀዮስ ፉለ ዱረት ሂቄ ዳንዲ ዽጳ እዶ እቲን ምርገት ዮካን ብታት ጎረን ህንቀብኔ ቶኮረ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","ሀሬን ሱን ኤርገማ ዋቀዮ አርግናን በለኣም ጀላ ገድ ጪፍቴ፤ እንስ ኣሬ ኡሌ ኦፊቲን ሀሬ ሰነ ሩኩቴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","ከነረት ዋቀዮ አፋን ሀሬ ሰና በኔ ሀሬን ሱን በለኣሚን፣ “አን ማል ስ የክናን አት አከስ ዬሮ ሰዲ ነ ሩኩቴ?” ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","በለኣምስ ሀሬ ሰናን፣ “አት ነ ጎዎምስቴ፤ አን ኡቱ ጎራዴ ኦፍ ሀርካ ቀባዼ ስላ አሙመን ስ አጄሰ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","ሀሬን ሱን አመሌ በለኣሚን አከነ ጄቴ፤ “አን ሀሬኬ ከን አት ሀመ ሀርኣት ጉያ ሁንደ ያበቱ ምቲ? አን ተኩማ ዋን አከሲ ስት ሆጄዼ ቤካ?” እንስ፣ “ለኪ” ጄዼ ዴብሴፍ። ");
INSERT INTO gaze_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","ዮሙስ ዋቀዮ እጀ በለኣም በኔ፤ በለኣምስ ኤርገማ ዋቀዮ ከን ጎራዴ ሉቅፈቴ ከራረ ዻበቱ አርጌ። ከነረት እን አዳን ለፈት ጎምብፈሜ ሰገዴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","ኤርገማን ዋቀዮ ሱን አከነ ጄዼ እሰ ጋፈቴ፤ “አት ማሊፍ ዬሮ ሰደን ከነ ሀሬኬ ሩኩቴ? ኩኖ አን ዋን ከራንኬ ፉለኮ ዱረት ጀልኣ ተኤፍ ሲን ሞርሙዻፈን ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","ሀሬን ኩን ነ አርግቴ ዬሮ ከነ ሰደኑ ነራ ጎርቴ። ኡቱ እሼን ነራ ጎሩ ባቴ ስላ አን ዮነ ስ አጄሴ እሼሞ ሀምብሰ ቱሬ።” ");
INSERT INTO gaze_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","በለኣምስ ኤርገማ ዋቀዮቲን፣ “አን ጩቡ ሆጄዼረ። አን አከ አት ናን ሞርሙፍ ጄቴ ከራረ ዻበቴ ህንሁበትኔ። አመስ ዮ ስት ህንቶልን አን ነንዴብአ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","ኤርገማን ዋቀዮ ሱንስ በለኣሚን፣ “ነሞተ ከነ ወጅን ዴም፤ ገሩ ዋኑመ አን ስት ህሙ ቆፈ ዱበዹ” ጄዼ። አከሲን በለኣም ቆንዳልቶተ ባላቅ ሰነ ወጅን ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","ባላቅስ አከ በለኣም ዹፋ ጅሩ ዸጌኛን፣ መጋላ ሞኣብ ከን ዳሪ አርኖንረት አርገምቱት እሰ ስመቹዻፍ ከኤ ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","ባላቅስ በለኣሚን አከነ ጄዼ፤ “አን ዻምሰ አሪፈቺሳ ስት ህንኤርግኔ? አት ማሊፍ ነ ብረ ህንዹፍኔ? አን ዹጉማን ኡልፍነ ሲፍ ኬኑ ህንደንደኡ?” ");
INSERT INTO gaze_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","በለኣምስ፣ “ኩኖ አን ስ ብረ ዹፌረ። ገሩ አን ዋኑመን አርጌ ዱበቹ ነንደንደኣ? አን ዋኑመ ዋቅን አፋንኮ ኬሰ ካኡ ቆፈን ዱበቹ ቀበ” ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","በለኣምስ ከኤ ባላቅ ወጅን ቂርያት ሀጦት ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","ባላቅ ሎኒፊ ሆላ ኣርሳ ዽኤሴ ገረ ቶኮ በለኣሚፊ ቆንዳልቶተ እሰ ወጅን ቱረኒፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","ገነመ እት ኣኑስ ባላቅ፣ በለኣምን ባሞት በኣልት ኦል ባሴ፤ እንስ አች ዻበቴ ሰበ እስራኤል ወረ ዳንጋ ገማረ ጅረን አርጌ። ");
INSERT INTO gaze_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","በለኣምስ ባላቂን፣ “እዶ ኣርሳ ቶርበ አስት ናፍ እጃር፤ አመሌ ኮሮሚ ሎኒ ቶርባፊ ኮርቤዪ ሆላ ቶርበ ና ቆጴስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","ባላቅስ አኩመ በለኣም ጄዼ ሰነ ጎዼ፤ እሳን ለማን ቶኮ ቶኮ እዶ ኣርሳረት ኮርመ ሎኒቲፊ ኮርቤሰ ሆላ ቶኮ ቶኮ ኣርሳ ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","ኤርገሲ በለኣም ባላቂን አከነ ጄዼ፤ “አን ጥኖ አች ስራ ነንስቀ፤ አትሞ አሱመ ኣርሳኬ ብረ ቱር። ተሪ ዋቀዮ አና ወጅን ወል አርጉፍ ንዹፈ ተአ። ዋን እን ነት ሙልእሱ ከምዩ አን ስትን ህመ።” እንስ ገረ ጋረ ቶኮ ዸቄ። ");
INSERT INTO gaze_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","ዋቀዮ እሳን ወል አርግናን በለኣም፣ “አን እዶ ኣርሳ ቶርበ ቆጴሴ ቶኮ ቶኮሳረት ኮርመ ሎኒ ቶኮፊ ኮርቤሰ ሆላ ቶኮ ቆጴሴረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","ዋቀዮ ኤርጋ ቶኮ አፋን በለኣም ኬሰ ካኤ፣ “ባላቅት ዴብኢቲ ኤርጋ ከነ እት ህም” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","በለኣም ባላቅት ዴብኤ እሳ ቆንዳልቶተ ሞኣብ ወጅን ኣርሳሳ ብረ ዻበቱ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","በለኣም ኤርጋሳ አከነ ጄዼ ዱበቴ፦ “ባላቅ አራምራ፣ ሞትች ሞኣብ ጋረን በኣራ ነ ፍዴ። እንስ፣ ‘ኮቱቲ ያቆብን ና አባር፤ ኮቱቲ እስራኤልን ና በላሌፈዹ’ ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","አን አከምተን ወረ ዋቅን ህንአባርን አባሩ ደንደአ? አን አከምተን ወረ ዋቀዮ ህንበላሌፈትን በላሌፈቹ ደንደአ? ");
INSERT INTO gaze_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","ፊጤ ጋረኒራ አን እሰ ነንአርገ፤ ቱሉወንራስ እሰ ነንእላለ። ሰበ ኮጳሳ ጅራቱ፣ ከን ሰበ ካን ኬሰት ኦፍ ህንለኮፍኔ ነንአርገ። ");
INSERT INTO gaze_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","ኤኙቱ አዋረ ያቆብ ለካኡ ደንደአ? ኤኙቱ እስራኤል ኬሳ ኩርማነሳሌ ለካአ? አን ዱአ ነመ ቀጄላ ሃዱኡ፤ ዹምንኮስ አኩመ ዹመሳ ሃተኡ!” ");
INSERT INTO gaze_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","ባላቅስ በለኣሚን፣ “ወን አት ነ ጎቴ ኩን ማል? አን አከ አት ዲነኮ ና አባርቱፍን ስ ፍዴ፤ አት ኩኖ እሳን ኤብፍቴ መሌ ዋን ቶኮዩ እሳን ህንጎኔ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","እንስ፣ “አን ዋን ዋቀዮ አፋንኮ ኬሰ ካኡ ህንዱበዹ?” ጄዼ ዴቢ ኬኔፍ። ");
INSERT INTO gaze_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","ባላቅ፣ “ሜ ገረ ለፈ እት እሳን አርጉ ደንዴሱ ብራ ነ ወጅን ኮቱ፤ አት ገረ ቶኮ ቆፈ መሌ ሁንዱመሳኒ አርጉ ህንደንዴሱ። አቺስ እሳን ና አባር” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","እን ገረ ድሬ ጦፊም ከን ፊጤ ጵስጋረት አርገሙት እሰ ጌሴ፤ አችትስ እዶ ኣርሳ ቶርበ እጃሬ ቶኮ ቶኮ እዶ ኣርሳ ሰናረት ኮርመ ሎኒ ቶኮፊ ኮርቤሰ ሆላ ቶኮ ኣርሳ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","በለኣምስ ባላቂን፣ “አት ሀመ አን አች ስቄ ዋቀ ወጅን ወል አርጉት አሱመ ኣርሳኬ ብረ ቱር” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","ዋቀዮ በለኣም ወጅን ወል አርጌ ኤርጋ ቶኮ አፋንሳ ኬሰ ካኤ፣ “ባላቅት ዴብኢቲ ኤርጋ ከነ እት ህም” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","በለኣም ባላቅ ብረ ዸቄ እሳ ቆንዳልቶተ ሞኣብ ወጅን ኣርሳሳ ብረ ዻበቱ አርጌ። ባላቅስ፣ “ዋቀዮ ማል ጄዼ?” ጄዼ በለኣሚን ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","በለኣም አከነ ጄዼ ኤርጋሳ ዱበቴ፦ “ያ ባላቅ፣ ከኢቲ ዸጌፈዹ፤ ያ እልመ ዝጶር ነ ዸገእ። ");
INSERT INTO gaze_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","ዋቅን ነመ ምት፤ እን ህንሶቡ፤ ዮካን ጋቡዻፍ እን እልመ ነማ ምት። እን ዋ ዱበቴ ኤርገሲ ህንሆጄቱ? እን ዋ አብደቺሴ ኤርገሲ ህንራወቱ? ");
INSERT INTO gaze_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","ኩኖ አን ኤብሱዻፍ አጀጀ አርገዼረ፤ እን ኤብሴረ፤ አንስ ጌደሩ ህንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“እን ያቆብ ኬሰት ደበ ህንአርግኔ፤ ረክነ ቶኮሌ እስራኤል ኬሰት ህንአርግኔ። ዋቀዮ ዋቅንሳኒ እሳን ወጅን ጅረ፤ እልሌን ሞቲ እሳን ወጅን ጅረ። ");
INSERT INTO gaze_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","ዋቀዮ ብየ ግብጢቲ እሳን ባሴ፤ እን ጀብነ አከ ጀብነ ገፈርሳ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","ያቆብረት ፈልፈል ቶኮዩ ህንሆጄቱ፤ እስራኤልረትስ ቶልች ቶኮዩ ህንሆጄቱ። አመ ያቆቢፊ እስራኤሊን፣ ‘ዋን ዋቅን ሆጄቴ እላላ!’ ጄዸመ። ");
INSERT INTO gaze_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","ኩኖ ሰብን ሱን አከ ሌንጨ ዸላት ከአ፤ አኩመ ሌንጫትስ ኦል ጄዸ፤ እን ሀመ ዋን አደምሰቴ ኛቴ ፍጡት፣ ሀመ ዺገ ዋን አጄፈቴ ሰና ዹጉትስ ህንጪሱ።” ");
INSERT INTO gaze_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","ባላቅ በለኣሚን፣ “አት ጎንኩማ እሳን ህንአባርን ዮካን እሳን ህንኤብስን” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","በለኣምስ፣ “አን አከ ዋን ዋቀዮ ጄዹ ከምዩ ሆጄዹ ስት ህንህምኔ?” ጄዼ ባላቂፍ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","ኤርገሲ ባላቅ በለኣሚን፣ “ሜ ኮቱ አመሌ አን እዶ ብራ ስን ጌሳ። ተሪ አቺ ጀረ ናፍ አባሩንኬ ዋቀ ገመቺሰ ተኣቲ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","ባላቅስ በለኣምን ፊጤ ቱሉ ጴኦር ከን እረ ዻበተኒ ገሞጂ ሰነ ገድ እላለንት ኦል ባሴ። ");
INSERT INTO gaze_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","በለኣምስ ባላቂን፣ “እዶ ኣርሳ ቶርበ አስት ናፍ እጃር፤ አመስ ኮሮሚ ሎኒ ቶርባፊ ኮርቤዪ ሆላ ቶርበ ናፍ ቆጴስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","ባላቅስ አኩመ በለኣም ጄዼን ሰነ ጎዼ፤ ቶኮ ቶኮ እዶ ኣርሳረትስ ኮርመ ሎኒ ቶኮፊ ኮርቤሰ ሆላ ቶኮ ኣርሳ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","በለኣም ዬሮ አከ እስራኤልን ኤብሱን ዋቀዮን ገመቺሴ አርጌት አከ ዬሮ ካኒ ፈልፈለ በርባቸ ህንዸቅኔ፤ ገሩ ፉለሳ ገረ ገሞጂት ዴብፈቴ። ");
INSERT INTO gaze_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","ዮሙ በለኣም ኦል ምልአቴ አከ እስራኤል ጎሰ ጎሳን ቁበቴ አርጌት ሀፉር ዋቃ እሰረ ቡኤ፤ ");
INSERT INTO gaze_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","እንስ አከነ ጄዼ ኤርጋሳ ዱበቴ፦ “ኤርጋ በለኣም እልመ ቤኦር፣ ኤርጋ ነመ እጅሳ ስሪት አርጉ፣ ");
INSERT INTO gaze_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ኤርጋ ነመ ዱቢ ዋቃ ዸገኡ እሰ ዋቀ ዋን ሁንደ ደንደኡራ ሙልአተ አርጉ ከን ኩፌ እጅሳ በነሙ ሰና፦ ");
INSERT INTO gaze_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“ያ ያቆብ፣ ዱንካኖትንኬ፣ ያ እስራኤል፣ እዶን አት ጅራቱ አከም ሚዸገ! ");
INSERT INTO gaze_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“እሳን አኩመ ሱሉለ ድሪራ፣ አኩመ እዶ ብቅልቱ ከን አፋን ለጋ፣ አኩመ አርጌሰ ዋቀዮ ዻቤ፣ አኩመ ብርብርሳ ቀርቀረ ብሻኒት። ");
INSERT INTO gaze_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","ኦኮሌሳ ኬሳ ብሻንቱ ሎለአ፤ ሰኚንሳ ብሻን ባይኤ አርገተ። “ሞቲንሳ አጋግ ጫለ፤ ሞቱማንሳ ንከበጀመ። ");
INSERT INTO gaze_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“ዋቀዮ ግብጢ እሰ ባሴ፤ እን ጀብነ አከ ጀብነ ገፈርሳ ቀበ። እን ሰበ ዲኖተሳ ተኤ ኛተ፤ ለፌሳኒ ንጨጨብሰ፤ ጥየ ኦፊሳቲን እሳን ወራነ። ");
INSERT INTO gaze_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","እን አኩመ ሌንጫ ጪሴረ፤ አኩመ ሌንጨ ዸላስ ጪሴረ፤ ኤኙቱ እሰ ደመቅሰ? “ወር ስ ኤብሰን ሃኤብፈመን፤ ወር ስ አባረንስ ሃአባረመን!” ");
INSERT INTO gaze_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","ባላቅ በለኣምት ኣሬ። እንስ ሀርከ ኦፊሳ ወልት ሩሩኩቴ በለኣሚን አከነ ጄዼ፤ “አን አከ አት ዲነኮ አባርቱፈን ስ ዋመዼ፤ አት ኩኖ ዬሮ ሰደን ከነ እሳን ኤብፍቴ። ");
INSERT INTO gaze_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","አመ ደፊ አሲ ዴሚ መነኬት ገል! አን ኡልፍነ ጉዳ ሲፍ ነንኬነ ጄዼን ቱሬ፤ አመ ገሩ ዋቀዮ አከ አት ኡልፍነ ህንአርገትኔ ስ ጎዼረ።” ");
INSERT INTO gaze_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","በለኣምስ ባላቂን አከነ ጄዼ፤ “አን ኤርገሞተ አት ነት ኤርግቴ ሰነት አከነ ጄዼን ህሜ ምቲ? ");
INSERT INTO gaze_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘ኡቱ ባላቅ መሰራ ሜቲፊ ወርቄን ጉተሜ ሰነ ናፍ ኬኔዩ፣ አን ዋኑመ ዋቀዮ ጄዼ ቆፈን ዱበዸ መሌ አጀጀ ዋቀዮቲን አለት ዋን ያደኮ ጋሪ ዮካን ሀማ ቶኮዩ ሆጄቹ ህንደንደኡ።’ ");
INSERT INTO gaze_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","ኩኖ አን አመ ሰበኮት ነንዴብአ፤ ገሩ ሜ ኮቱ አን ዋን ሰብን ኩን በረ ዹፉ ኬሰ ሰበኬቲፍ ጎዹ ስን ቤክስሳ።” ");
INSERT INTO gaze_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","እን አከነ ጄዼ ኤርጋሳ ዱበቴ፦ ኤርጋ በለኣም እልመ ቤኦር፣ ኤርጋ ነመ እጅሳ ስሪት አርጉ፣ ");
INSERT INTO gaze_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ኤርጋ ነመ ዱቢ ዋቃ ዸገኡ ከን ቤኩምሰ ዋቀ ዋን ሁንዳ ኦሊ ቀቡ ከን ዋቀ ዋን ሁንደ ደንደኡራ ሙልአተ አርጉ ከን ኩፌ ድሪሩ፣ እጅሳስ ከን በነሙ ሰና፦ ");
INSERT INTO gaze_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“አን እሰ ነንአርገ፤ ገሩ አመ ምት፤ አን እሰ ነንእላለ፤ ገሩ ዽኦት ምት። ያቆብ ኬሳ ኡርጂን ቶኮ ንበአ፤ እስራኤል ኬሳ ቦኩን ቶኮ ኦል ከአ። እን አደ ወረ ሞኣብ፣ ቡቄ መታ እልማን ሴት ሁንዳስ ንጨጨብሰ። ");
INSERT INTO gaze_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","ኤዶም ንሞአተመ፤ ሴኢር፣ ዲንሳ ንሞአተመ፤ እስራኤል ገሩ ጀባቻ ዴመ። ");
INSERT INTO gaze_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","ያቆብ ኬሳ ቡልቻን ቶኮ ንከአ፤ ወረ መጋላ ሰነ ኬሰት ሉቡዻን ሀፈንስ ንበርበዴሰ።” ");
INSERT INTO gaze_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","ኤርገሲስ በለኣም አማሌቅን አርጌ አከነ ጄዼ ኤርጋ ኦፊ እሰ ዱበቴ፦ “አማሌቅ ሰቦተ ኬሳ ከን ጀልቀባ ቱሬ፤ ዹምንሳ ገሩ በርበዳኡዸ።” ");
INSERT INTO gaze_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","ኤርገሲ ቄኖተ አርጌ አከነ ጄዼ ኤርጋ ኦፊሳ እት ዱበቴ፦ “እዶን አት ጅራቱ ጀባዸ፤ መንኬስ ከታ ኬሰት እጃረሜ፤ ");
INSERT INTO gaze_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","ተኡስ እስን ወር ቄኖታ፣ ጋፈ አሶር እስን ቦጅኡ ንበዱ።” ");
INSERT INTO gaze_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","እንስ አከነ ጄዼ ኤርጋሳ እት ዱበቴ፦ “ወዮ! ዬሮ ዋቀዮ ዋን ከነ ሆጄቱ ኤኙቱ ጅራቹ ደንደአ? ");
INSERT INTO gaze_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","ዶኒወን ቀርቀረ ክቲምራ ንዹፉ፤ እሳንስ አሶሪፊ ኤቤርን ንቀበቱ፤ ገሩ እሳንስ ንበርበዴፈሙ።” ");
INSERT INTO gaze_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","ኤርገሲ በለኣም ከኤ መነ ኦፊሳት ዴብኤ፤ ባላቅሞ ከራ ኦፊሳ ቀጄሌ። ");
INSERT INTO gaze_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","እስራኤሎን ዬሮ ሽጢም ኬሰ ቱረንት ዺሮንሳኒ ዱበርቶተ ሞኣብ ወጅን ሰጋገሉ ጀልቀበን። ");
INSERT INTO gaze_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","ዱበርቶትን ኩኔንስ ገረ ቀልመ ዋቆተሳኒት ሰበ ሰነ አፌራን፣ ሰብን ሱን ቀልመ ሰነ ኛቴ ዋቆተ ሰናፍ ሰገዴ። ");
INSERT INTO gaze_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","እስራኤል በኣል ጴኦር ዱካ ቡኤ። ዼከምስ ዋቀዮስ እሳንት ቦበኤ። ");
INSERT INTO gaze_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “አከ ዼከምስ ዋቀዮ ጀባን ሱን ሰበ እስራኤልራ ዴብኡፍ፣ ሀንገፎተ ሰበ ሰና ሁንደ ፉዺቲ ጉያ አዲዻን ፉለ ዋቀዮ ዱረት እሳን ፈንስ።” ");
INSERT INTO gaze_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","ሙሴን አቦቲ ሙርቲ እስራኤሊን፣ “ቶኮን ቶኮንኬሰን ነሞተኬሰን ከኔን በኣል ጴኦር ዱካ ቡአን ፍጣ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","ኩኖ ነምች እስራኤል ቶኮ ኡቱመ እሳን በልበለ ዱንካነ ወል ገኢ ዱረት ቦኣ ጅረኑ ፉለ ሙሴቲፊ ፉለ ወልዳ እስራኤል ጉቱ ዱረት ዱበርቲ ምድያን ቶኮ ገረ ማቲ ኦፊሳት ፍደቴ። ");
INSERT INTO gaze_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","ፊኔሃስ እልም ኤሌኣዛር እልመ አሮን ሉብቻ ዋን ከነ አርግናን ወልዳ ሰነ ኬሳ በኤ ኤቦ ሀርከት ቀበቴ ");
INSERT INTO gaze_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","ነምቸ እስራኤል ሰነ ዱካ ቡኤ ዱንካነ ሴኔ፤ ነምቸ እስራኤሊፊ ዱበርትቲስ ወልት ወራኔ ዸግነሼት ፉላሴ። አከሲን ዸእች እስራኤልት ዹፌ ሱን ንዾወሜ። ");
INSERT INTO gaze_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","ገሩ ባይእን ነሞተ ዸእቸ ሰናን ዹመኒ 24,000 ገኤ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“ፊኔሃስ እልም ኤሌኣዛር እልመ አሮን ሉብቸ ሰና ዼከምሰኮ እስራኤሎተራ ዴብሴረ፤ እን አከ አን ህናፋኮቲን እሳን ህንበሌስኔፍ፣ አኩመ አን ኡልፍነኮቲፍ እሳን ግዱት ህናፉ ሰነ እንስ ህናፌራቲ። ");
INSERT INTO gaze_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","ከናፉ ኩኖ አከ አን ከኩኮ ከን ነጋ እሰ ወጅን ጎዸዹ እት ናፍ ህም። ");
INSERT INTO gaze_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","ሰበቢ እን ኡልፍነ ዋቀሳቲፍ ህናፌ እስራኤሎታፍ አራረ ቡሴፍ፣ እኒፊ ሰኚንሳ ከኩ ሉቡማ ከን በረ በራ ቀባቱ።” ");
INSERT INTO gaze_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","መቃን ነምቸ እስራኤል ከን ዱበርቲ ምድያን ወጅን አጄፈሜ ሰና ዝምሪ እልመ ሳሉት፤ እንስ ሆገና ማቲ ስምኦን። ");
INSERT INTO gaze_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","መቃን ዱበርቲ ምድያን ከን አጄፈምቴ ሰና ኮዝቢ እንተለ ዙር ሀንገፈ ማቲ ምድያን ቶኮት። ");
INSERT INTO gaze_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“ምድያኖተ አከ ዲናት እላሊቲ አጄስ፤ ");
INSERT INTO gaze_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","ኩንስ ዋን እሳን ሰበቢ ጴኦሪቲፊ ኦቦሌቲሳኒ ኮዝቢ እንተለ ሆገና ወረ ምድያን፣ ዱበርቲ ጉያ ሰበቢ ጴኦሪቲን ዸእች ዹፌ ሰነ አጄፈምቴ ሰናረት እስን ጎዎምሰን ሰነ አከ ዲናት እስን እላለኒፍ።” ");
INSERT INTO gaze_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","ዸእቸ ሰነ ቦዴ ዋቀዮ ሙሴፊ ኤሌኣዛር እልመ አሮን ሉብቻቲን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“ወልዳ ሰበ እስራኤል ወረ ኡሙሪንሳኒ ወጋ ድግደማፊ ሀመሲ ኦል ተኤ ከኔን ሎልቶተ እስራኤል ኬሰ ተጃጅሉ ደንደአን ሁንደ ማቲ ማቲዻን ለካኣ።” ");
INSERT INTO gaze_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","ሙሴፊ ኤሌኣዛር ሉብች ድሬወን ሞኣብረት፣ ዮርዳኖስ ብረት፣ ዬርኮ ገመት አከነ ጄዸኒ እሳን ወጅን ዱበተን፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“አኩመ ዋቀዮ ሙሴ አጀጄት ነሞተ ኡሙሪንሳኒ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ለካኣ።” ");
INSERT INTO gaze_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","እልማን ሩቤን እልመ እስራኤል ሀንገፍትቻ፦ ከራ ሄኖኪቲን፣ በልበለ ሀኖኮታ፤ ከራ ፈሉቲን፣ በልበለ ፈሉዎታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","ከራ ሄዝሮኒቲን፣ በልበለ አስሮኖታ፤ ከራ ከርሚቲን፣ በልበለ ከርሞታ። ");
INSERT INTO gaze_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","ጀር ኩኔን በልበለወን ሩቤን፤ ባይእንሳኒስ 43,730 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","እልም ፈሉስ ኤሊያብ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","እልማን ኤሊያብስ ኔሙኤል፣ ዳታኒፊ አቤሮን። ዳታኒፊ አቢራም ኩኔን ቆንዳልቶተ ወልዳ ከኔን ሙሴፊ አሮንት ፍንጭለኒዸ፤ እሳን ዬሮ ቆራሂፊ ዱካ ቡቶትንሳ ዋቀዮት ፍንጭለን ሰነስ አች ኬሰ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","ለፍትስ አፋን በነቴ ቆራሂፊ እሳንሌ ልቅምስቴ፤ ወር ገሬ ቆራህሞ ዬሮ እብዲ ነሞተ 250 ፍጤ ሰነ ዹመን። እሳንስ መለቶ ነሞትን እቲን ኦፍ ኤገተን ተአን። ");
INSERT INTO gaze_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","እልማን ቆራህ ገሩ ህንዱኔ። ");
INSERT INTO gaze_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","እልማን ስምኦን አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ኔሙኤል፣ በልበለ ኔሙኤሎታ፤ ከራ ያሚን፣ በልበለ ያሚኖታ፤ ከራ ያኪን፣ በልበለ ያኪኖታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","ከራ ዜራን፣ በልበለ ዜሮታ፤ ከራ ሻዉል፣ በልበለ ሻዉሎታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","ጀር ኩኔን በልበለወን ስምኦኒት፤ እሳንስ ነሞተ 22,200 ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","እልማን ጋድ አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ዜፎን፣ በልበለ ዜፎኖታ፤ ከራ ሀጊ፣ በልበለ ሀጎታ፤ ከራ ሹኒ፣ በልበለ ሹኖታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","ከራ ኦዝኒ፣ በልበለ ኦዝኖታ፤ ከራ ኤሪ፣ በልበለ ኤሮታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","ከራ አሮድ፣ በልበለ አሮዶታ፤ ከራ አርኤል፣ በልበለ አርኤሎታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","ጀር ኩኔን በልበለወን ጋዲት፤ ባይእንሳኒስ 40,500 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","ኤሪፊ ኦናን እልማን ይሁዳት፤ እሳን ገሩ ከነኣን ኬሰት ዱአን። ");
INSERT INTO gaze_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","እልማን ይሁዳ አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ሼላ፣ በልበለ ሼላኖታ፤ ከራ ፋሬስ፣ በልበለ ፋሬሶታ፤ ከራ ዛራ፣ በልበለ ዛሮታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","እልማን ፋሬስስ ከኔኒዸ፦ ከራ ሄዝሮን፣ በልበለ ሄዝሮኖታ፤ ከራ ሀሙል፣ በልበለ ሀሙሎታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","ጀር ኩኔን በልበለወን ይሁዳት፤ ባይእንሳኒስ 76,500 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","እልማን ይሳኮር አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ቶላ፣ በልበለ ቶሎታ፤ ከራ ፉዋ፣ በልበለ ፉዎታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","ከራ ያሹብ፣ በልበለ ያሹቦታ፤ ከራ ሽምሮን፣ በልበለ ሽምሮኖታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","ጀር ኩኔን በልበለወን ይሳኮር፤ ባይእንሳኒስ 64,300 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","እልማን ዜቡሎን አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ሴሬድ፣ በልበለ ሴሬዶታ፤ ከራ ኤሎን፣ በልበለ ኤሎኖታ፤ ከራ የህልኤል፣ በልበለ የህልኤሎታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","ጀር ኩኔን በልበለወን ዜቡሎን፤ ባይእንሳኒስ 60,500 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","እልማን ዮሴፍ አኩመ በልበለ በልበለሳኒት፦ ምናሴፊ ኤፍሬም። ");
INSERT INTO gaze_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","እልማን ምናሴ፦ ከራ ማኪር፣ በልበለ ማኪሮታ፤ ማኪር ኩን አባ ግልኣድ፤ ከራ ግልኣድ፣ በልበለ ግልኣዶታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","እልማን ግልኣድ እሳን ከኔኒዸ፦ ከራ ኢኤዜር፣ በልበለ ኢኤዜሮታ፤ ከራ ሄሌቅ፣ በልበለ ሄሌቆታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","ከራ አስርኤል፣ በልበለ አስሪኤሎታ፣ ከራ ሼኬም፣ በልበለ ሼኬሞታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","ከራ ሼሚዳ፣ በልበለ ሼሚዳ፤ ከራ ሄፌር፣ በልበለ ሄፌሮታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","ዜሎፌሃድ እልም ሄፌር እልማን ህንቀቡ ቱሬ፤ እን እንተለን ቆፈ ቀበ ቱሬ፤ መቃንሳኒስ መህላ፣ ኖሂ፣ ሆግላ፣ ሚልካፊ ቲርዛዸ። ");
INSERT INTO gaze_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","ጀር ኩኔን በልበለወን ምናሴት፤ ባይእንሳኒስ 52,700 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","እልማን ኤፍሬም አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ሹቴላ፣ በልበለ ሹቴሎታ፤ ከራ ቤኬር፣ በልበለ ቤኬሮታ፤ ከራ ታሀን፣ በልበለ ታሀኖታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","እልማን ሹቴላ እሳን ከኔኒዸ፦ ከራ ኤራን፣ በልበለ ኤራኖታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","ጀር ኩኔን በልበለወን ኤፍሬም፤ ባይእንሳኒስ 32,500 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","እልማን ቤንያም አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ቤላ፣ በልበለ ቤላኦታ፤ ከራ አሽቤል፣ በልበለ አስቤሎታ፤ ከራ አሂራም፣ በልበለ አሂራሞታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","ከራ ሼፉፋም፣ በልበለ ሼፉፋሞታ፤ ከራ ሁፋም፣ በልበለ ሁፋሞታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","እልማን ቤላ፣ ከራ አርዲፊ ነአማን፦ ከራ አርዲ፣ በልበለ አርዶታ፤ ከራ ነአማን፣ በልበለ ነአማኖታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","ጀር ኩኔን በልበለወን ቤንያም፤ ባይእንሳኒስ 45,600 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","እልማን ዳን አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ሹሃም፣ በልበለ ሹሃሞታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","እሳን ሁንድኑ በልበለወን ሹሃሞታት፤ ባይእንሳኒስ 64,400 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","እልማን ኣሼር አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ ይምና፣ በልበለ ዩምኖታ፤ ከራ ይሽዊ፣ በልበለ ይሽዊዮታ፤ ከራ ቤሪያ፣ በልበለ ቤሪዮታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","ከራ እልማን ቤሪያሞ፦ ከራ ሄቤር፣ በልበለ ሄቤሮታ፤ ከራ መልኪኤል፣ በልበለ መልኪኤሎታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","ኣሼር እንተለ ሴራ ጄዸምቱ ቶኮ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","ጀር ኩኔን በልበለወን ኣሼር፤ ባይእንሳኒስ 53,400 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","እልማን ንፍታሌም አኩመ በልበለ በልበለሳኒት ከኔኒዸ፦ ከራ የህዜል፣ በልበለ የህዜሎታ፣ ከራ ጉኒ፣ በልበለ ጉኖታ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","ከራ ዬጤር፣ በልበለ ዬጥሮታ፤ ከራ ሺሌም፣ በልበለ ሺሌሞታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","ጀር ኩኔን በልበለወን ንፍታሌም፤ ባይእንሳኒስ 45,400 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","ወሉማ ገለት ባይእን ዺረ እስራኤል 601,730 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“ብይ ሱን አኩመ ባይእነ መቃ ነማት ዻለ ተኤ እሳን ከኔኒፍ ሃቆደሙ። ");
INSERT INTO gaze_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","በልበለ ጉዳዻፍ ዻለ ጉዳ፣ በልበለ ጥናዻፍሞ ዻለ ጥና ኬን፤ ቶኮን ቶኮን በልበላ አኩመ ባይእነ ነሞተ ገልሜፈመኒት ዻለሳ ሃአርገቱ። ");
INSERT INTO gaze_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","ገሩ ብይ ሱን እጣዻን ሃቆቆደምቱ። እሳንስ አኩመ መቃወን ጎሶተ አቦቲሳኒት ንዻሉ። ");
INSERT INTO gaze_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","ቶኮን ቶኮን ዻለ ሰና ገሬ ጉዳፊ ገሬ ጥና ግዱት እጣዻን ሃቆደሙ።” ");
INSERT INTO gaze_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","ሌዎትን በልበለ በልበላን ለካአመን ከኔኒዸ፦ ከራ ጌርሾን፣ በልበለ ጌርሾኖታ፤ ከራ ቆሃት፣ በልበለ ቆሃቶታ፤ ከራ ሜራሪ፣ በልበለ ሜራሮታት። ");
INSERT INTO gaze_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","ጀር ኩኔንስ በልበለወን ሌዎታት፦ በልበለ ሊብኖታ፣ በልበለ ኬብሮኖታ፣ በልበለ መሄሎታ፣ በልበለ ሙሶታ፣ በልበለ ቆራሆታ። ቆሃት አባ አምራም፤ ");
INSERT INTO gaze_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","መቃን ኒቲ አምራም ዮኬቤድ። እሼን እንተለ ሌዊ ከን ብየ ግብጥት ሌዊፍ ዸለቴዸ። አምራሚፍስ አሮን፣ ሙሴፊ ኦቦሌቲሳኒ ሚርያም ዴሴ። ");
INSERT INTO gaze_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","አሮን አባ ናዳብ፣ አቢሁ፣ ኤሌኣዛሪፊ ኢታማር። ");
INSERT INTO gaze_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","ናዳቢፊ አቢሁ ገሩ ዬሮ እብደ ህንኤየመምን ፉለ ዋቀዮ ዱረት ዽኤሰን ሰነ ዱአን። ");
INSERT INTO gaze_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","ዺሮትን ኡሙሪንሳኒ ጅአ ቶኮፊ ሀመሲ ኦል ተኤ ከኔን ለካአመን ሁንድ 23,000 ቱረን። እሳንስ ሰበቢ ግዱሳኒት ዻለ ህንአርገትኒፍ እስራኤሎተ ካን ወጅን ህንለካአምኔ። ");
INSERT INTO gaze_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","እሳን ኩኔን ወረ ዬሮ ሙሴፊ ኤሌኣዛር ሉብች ድሬወን ሞኣብረት፣ ዮርዳኖስ ብረት፣ ዬርኮ ገመት እስራኤሎተ ለካአን ሰነ ለካአመኒዸ። ");
INSERT INTO gaze_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","ነሞተ ከራ ሙሴቲፊ አሮን ሉብቻን ገሞጂ ሲና ኬሰት ለካአመን ኬሳ ነምን ቶኮዩ እሳን ግዱ ህንቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","ሰበቢ ዋቀዮ ዋኤሳኒ፣ “እሳን ገሞጂ ኬሰት ንዹሙ” ጄዼ ዱበቴ ቱሬፍ፣ ካሌብ እልመ ዬፉኔፊ እያሱ እልመ ኑን መሌ እሳን ኬሳ ነምን ቶኮዩ ህንሀፍኔ። ");
INSERT INTO gaze_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","በልበለ ምናሴ እልመ ዮሴፍ ኬሳስ እንተለን ዜሎፌሃድ እልመ ሄፌር፣ እልመ ግልኣድ፣ እልመ ማኪሪፊ እልመ ምናሴቱ ዽኣቴ። መቃን እንተለን ሰናስ መህላ፣ ኖሂ፣ ሆግላ፣ ሚልካፊ ቲርዛዸ። ");
INSERT INTO gaze_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","እሳንስ በልበለ ዱንካነ ወል ገኢ ዱረ፣ ፉለ ሙሴፊ ኤሌኣዛር ሉብቻ ዱረ፣ ፉለ ሆገንቶታቲፊ ወልዳ ሁንዳ ዱረ ዻበተኒ አከነ ጄዸን፤ ");
INSERT INTO gaze_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“አባንኬኘ ገሞጂ ኬሰት ዱኤ። እን ሆገንቶተ ቆራህ ከኔን ዋቀዮት ፍንጭለን ሰነ ኬሰ ህንቱሬ። ገሩ እን ጩቡዹመ ኦፊሳቲን ዱኤ። እልማንስ ህንቀቡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","ማሊፍ መቃን አባኬኛ ሰበቢ እን እልመ ህንቀብኔፍ በልበለሳ ኬሳ በደ? ፍሮተ አባኬኛ ግዱት ዻለ ኑ ኬን።” ");
INSERT INTO gaze_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","ሙሴን ዱቢሳኒ ሰነ ፉለ ዋቀዮ ዱረት ዽኤሴ፤ ");
INSERT INTO gaze_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","ዋቀዮስ አከነ ጄዼን፤ ");
INSERT INTO gaze_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“ወን እንተለን ዜሎፌሃድ ጄዸን ኩን ስሪዸ። አትስ ፍሮተ አባሳኒ ግዱት ዻለ ኬኒፍ፤ ዻለ አባሳኒስ እሳኒፍ ደበርስ። ");
INSERT INTO gaze_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“እስራኤሎታን አከነ ጄዽ፤ ‘ዮ ነምን ኡቱ እልመ ህንዸልችን ዱኤ፣ ዻለሳ እንተለሳቲፍ ደበርሳ። ");
INSERT INTO gaze_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","ዮ እን እንተለስ ቀባቹ ባቴ ዻለሳ ኦቦሎተሳቲፍ ኬና። ");
INSERT INTO gaze_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","ዮ እን ኦቦሎተ ቀባቹ ባቴ ዻለሳ ኦቦሎተ አባሳቲፍ ኬና። ");
INSERT INTO gaze_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","ዮ አባንሳ ኦቦሎተ ቀባቹ ባቴሞ ዻለሳ በልበለሳ ኬሳ ፍረ ኣንቴፍ ኬና፤ ፍር ሱን ሃዻሉ። ኩንስ አኩመ ዋቀዮ ሙሴ አጀጄ ሰነት ሰበ እስራኤሊፍ ስርነ ሴረ ቀቤሰ ሃተኡ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “ቱሉ አባሪም ከነት ኦል በኢቲ ብየ አን ሰበ እስራኤሊፍ ኬኔ እላል። ");
INSERT INTO gaze_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","ኤርገ ብየ ሰነ አርግቴ ቦዴ አትስ አኩመ ኦቦሌሰኬ አሮን ገረ ሰበኬቲት ወልት ቀበምተ፤ ");
INSERT INTO gaze_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","ዬሮ ወልዳን ገሞጂ ሲን ኬሰት ነት ፍንጭሌት እስን ለቸኑስ አጀጀኮት ፍንጭልተኒ ቱርተኒቲ። እስን ብሻኖተ ሰነ ብረት ፉለሳኒ ዱረት ቁልቁልነኮ ህንሙልእፍኔ።” ብሻኖትን ኩኔንስ ብሻኖተ መሪባ ቃዴሽ ከን ገሞጂ ሲን ኬሰ ጅረኒዸ። ");
INSERT INTO gaze_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","ሙሴንስ ዋቀዮን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“ዋቀዮ ዋቅን ሀፉሮተ ነመ ሁንዳ ወልዳ ከነረት ነመ ቶኮ ሃሙዱ፤ ");
INSERT INTO gaze_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","ነምች ኩንስ አከ ሰብን ዋቀዮ አኩመ ሆሎተ ትክሴ ህንቀብኔ ህንታኔፍ ከን እሳን ዱረ ገድ በኡፊ ኦል ገሉ፣ ከን ገድ እሳን ባሱፊ ኦል እሳን ገልቹዸ።” ");
INSERT INTO gaze_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ “እያሱ እልመ ኑን፣ ነምቸ ሀፉር ኬሰ ጅሩ ሰነ ፉዺ ሀርከኬ እሰረ ካእ። ");
INSERT INTO gaze_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","አከ እን ፉለ ኤሌኣዛር ሉብቻቲፊ ፉለ ወልዳ እስራኤል ሁንዳ ዱረ ዻበቱ ጎዽ፤ ፉሉመሳኒ ዱረትስ እሰ ሙድ። ");
INSERT INTO gaze_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","አከ ሰብን እስራኤል ሁንድ እሳፍ አጀጀሙፍ ኣንጎኬራ ኬኒፍ። ");
INSERT INTO gaze_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","እንስ ፉለ ኤሌኣዛር ሉብቻ ከን ፉለ ዋቀዮ ዱረት ኡሪሚዻን ጋፈቴ ሙርቲ እሳፍ ኬኑ ዱረ ዻበቹ ቀበ። እኒፊ ወልዳን እስራኤሎታ ሁንድ አጀጀሳቲን በኡ፤ አጀጁመሳቲንስ ገሉ።” ");
INSERT INTO gaze_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","ሙሴን አኩመ ዋቀዮ እሰ አጀጄ ሰነ ጎዼ። እንስ እያሱ ጌሴ አከ እን ፉለ ኤሌኣዛር ሉብቻቲፊ ፉለ ወልዳ እስራኤል ሁንዳ ዱረ ዻበቱ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","ኤርገሲስ አኩመ ዋቀዮ ከራ ሙሴቲን አጀጄ ሰነ ሀርከ ኦፊሳ እሰረ ካኤ እሰ ሙዴ። ");
INSERT INTO gaze_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“አጀጀ ከነ እስራኤሎታፍ ኬን፤ አከነስ ጄዺን፦ ‘ኣርሳ ኛታ ከን እብዳን አናፍ ዽኤፈሙ ከን ፎሊንሳ ነት ቶሉ ሰነ ዬሮ ሙርታኤት ና ዽኤሱኬሰን ምርከኔፈዻ።’ ");
INSERT INTO gaze_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","አከነ እሳኒን ጄዽ፤ ‘ኣርሳን እስን እብዳን ዋቀዮፍ ዽኤስተን እሰ ከነ፦ ጦባላወን ሆላ ለመ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮቲፊ ከኔን ህርእነ ህንቀብኔ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ጉዩመ ጉያን ዽኤፈሙ ጎዻ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","ጦባላ ሆላ ቶኮ ገነመ፣ ካንሞ ገልገለ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","ከነ ወጅንስ ኬና ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ቶኮ ዘይቲ ኤጄርሳ ከን ጩንፈሜ ኢኒ ቶኮ ሀርከ አፉር ኬሳ ሀርከ ቶኮን ሱኩመሜ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","ኩንስ ኣርሳ ዬሮ ሁንደ ጉበሙ ከን ፎሊንሳ ቶሉፊ ከን እብዳን ዋቀዮፍ ዽኤፈሙ ከን ቱሉ ሲናረት አጀጀሜዸ። ");
INSERT INTO gaze_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","ዽባዩን ቶኮ ቶኮ ጦባላ ሆላ ወጅን ዽኤፈሙስ ዹጋቲ ጭማ ኢኒ ቶኮራ ሀርከ አፉር ኬሳ ሀርከ ቶኮ ሃተኡ፤ ዽባዩ ሰነስ እዶ ቁልቁሉ ኬሰት ዋቀዮፍ ዸንገላስ። ");
INSERT INTO gaze_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","ጦባላ ሆላ ካንሞ አኩመ ኬና ምዻኒቲፊ ከን ዽባዩ ወጅን ገነመ ዽኤስቴ ሰና ገልገለስ ዽኤስ። ኩንስ ኣርሳ እብዳን ዽኤፈሙ ከን ፎሊንሳ ዋቀዮት ቶሉዸ። ");
INSERT INTO gaze_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘ጉያ ሰንበታ ጦባላወን ሆላ ለመ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ተኤፊ ህርእነ ህንቀብኔ ኣርሳ ዽባዩቲፊ ኬና ምዻኒ አከሱመስ ኬና ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ለመ ዘይቲዻን ሱኩመሜ ወጅን ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","ኩንስ ኣርሳ ጉበሙ ከን ኣርሳ ዬሮ ሁንደ ጉበሙፊ ዽባዩሳት ደበለሜ ሰንበተ ሰንበታን ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘ጀልቀበ ጅኦተኬሰኒ ሁንደት ጅቦተ ሎኒ ለመ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላወን ሆላ ቶርበ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ተኤፊ ከኔን ህርእነ ህንቀብኔ ኣርሳ ጉበሙ ጎዻቲ ዋቀዮፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","ቶኮ ቶኮ ጅቦተ ሎኒ ወጅን ኬና ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ሰዲ ዘይቲዻን ሱኩመሜ፣ ኮርቤሰ ሆላ ሰነ ወጅንስ ኬና ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ለመ ዘይቲዻን ሱኩመሜ ዽኤፈሙ ቀበ፤ ");
INSERT INTO gaze_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","ቶኮ ቶኮ ጦባላ ሆላ ወጅንስ ኬናን ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ቶኮ ዘይቲዻን ሱኩመሜ ዽኤፈሙ ቀበ። ኩንስ ኣርሳ ጉበሙ ከን እብዳን ዋቀዮፍ ዽኤፈሙፊ ፎሊንሳ ቶሉዸ። ");
INSERT INTO gaze_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","ቶኮ ቶኮ ድብቸ ሎኒ ወጅን ዽባዩ ዳዺ ወይኒ ኢኒ ቶኮራ ወለካሳ፣ ቶኮ ቶኮ ጦባላ ሆላ ወጅን ኢኒ ቶኮራ ሀርከ ሰዲ ኬሳ ሀርከ ቶኮ፣ ኮርቤሰ ሆላ ሰነ ወጅንስ ኢኒ ቶኮራ ሀርከ አፉር ኬሳ ሀርክ ቶኮ ሃዽኤፈሙ። ኩንስ ኣርሳ ጉበሙ ከን ወጋ ኬሰት ባቲ ሃራት ዽኤፈሙዸ። ");
INSERT INTO gaze_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","አከሱመስ ኣርሳ ጩቡቲፍ ኮርቤሰ ሬኤ ቶኮ ዋቀዮፍ ዽኤሳ፤ እንስ ኣርሳ ዬሮ ሁንደ ጉበሙፊ ዽባዩሳት ደበለሜ ዽኤፈመ። ");
INSERT INTO gaze_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘ቡልቲ ኩዸ አፉረፋ ጅአ ጀልቀባት ፋሲካን ዋቀዮ አያኔፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","ቡልቲ ኩዸ ሸነፋ ጅአ ከናት አያነቱ ጅረ፤ እስንስ ጉያ ቶርበ መጥኖ ኛቱ። ");
INSERT INTO gaze_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","ጉያ ጀልቀባት ወል ገኢ ቁልቁሉ ቀባዻ፤ ሆጂ እድሌስ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","ጅቦተ ሎኒ ለመ፣ ኮርቤሰ ሆላ ቶኮ፣ ጦባላወን ሆላ ቶርበ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ኣርሳ ጉበሙ ጎዻቲ እብዳን ዋቀዮፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","ቶኮ ቶኮ ድብቸ ሎኒ ወጅንስ ኬና ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ሰዲ ዘይቲዻን ሱኩመሜ፣ ኮርቤሰ ሆላ ወጅን ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ለመ፣ ");
INSERT INTO gaze_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","ጦባላወን ሆላ ቶርበን ወጅን ቶኮ ቶኮ ጦባላ ሆላቲፍ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","አከሱመስ አከ አራር እስኒ ቡኡፍ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","ከነስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ገነመ ገነመ ዽኤፈሙት ደበላቲ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","ሃሉመ ከናን ኛተ ኣርሳ እብዳን ዽኤፈሙ ከን ፎሊንሳ ዋቀዮት ቶሉ ሰነ ቡልቲ ቶርባፍ ጉዩመ ጉያን ዽኤሳ፤ እንስ ኣርሳ ጉበሙፊ ዽባዩሳ ከን ዬሮ ሁንደ ዽኤፈሙት ደበለሜ ሃዽኤፈሙ። ");
INSERT INTO gaze_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","ቡልቲ ቶርበፋት ወል ገኢ ቁልቁሉ ቀባዻ፤ ሆጂ እድሌስ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘አያነ ቶርበኖታ ኬሰ ጉያ አያነ መታ ምዻኒት ዬሮ ኬና ምዻን ሃራ ዋቀዮፍ ዽኤስተን ሰነ ወል ገኢ ቁልቁሉ ጎዸዻ፤ ሆጂ እድሌስ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","ጅቦተ ሎኒ ለመ፣ ኮርቤሰ ሆላ ቶኮፊ ጦባላወን ሆላ ቶርበ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤ ኣርሳ ጉበሙ ከን ፎሊንሳ ዋቀዮት ቶሉ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","ቶኮ ቶኮ ድብቸ ሎኒ ወጅንስ ኬናን ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ሰዲ ዘይቲዻን ሱኩመሜ ሃዽኤፈሙ። ኮርቤሰ ሆላ ወጅን ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ለመ፣ ");
INSERT INTO gaze_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","ጦባላወን ሆላ ቶርበን ሰነ ወጅንስ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ቶኮ ሃዽኤፈሙ። ");
INSERT INTO gaze_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","አከሱመስ አከ አራር እስኒ ቡኡፍ ኮርቤሰ ሬኤ ቶኮ እት ደበላ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","ኣርሳወን ከኔን ዽባዩሳኒ ወጅን፣ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙፊ ኬና ምዻንሳት ደበላቲ ዽኤሳ፤ ሆሪን ሱንስ ከን ህርእነ ህንቀብኔ ተኡሳኒ ምርከኔፈዻ። ");
INSERT INTO gaze_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘ጉያ ጀልቀበ ጅአ ቶርበፋት ወል ገኢ ቁልቁሉ ጎዸዻ፤ ጋፈስ ሆጂ እድሌ ህንሆጄትና። ጉያን ኩን ጉያ እስን እት መለከተ አፉፍተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮፊ ጦባላወን ሆላ ቶርበ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ኣርሳ ጉበሙ ከን ፎሊንሳ ዋቀዮት ቶሉ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","ድብቸ ሰነ ወጅንስ ኬና ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ሰዲ ዘይቲዻን ሱኩመሜ ዽኤሳ። ኮርቤሰ ሆላ ወጅንስ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ለመ፣ ");
INSERT INTO gaze_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","ጦባላወን ሆላ ቶርበን ሰነ ወጅንስ ኢፊ ቶኮ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","አከሱመስ አከ አራር እስኒ ቡፈሙፍ ኮርቤሰ ሬኤ ቶኮ እት ደበላቲ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","ኣርሳወን ኩኔን አኩመ አመለሳኒት ኣርሳወን ጉበመን ከኔን ጅአ ጅአቲፊ ጉያ ጉያት ዽኤፈመኒፊ ኬናወን ምዻኒቲፊ ዽባዩሳኒት ደበለመኒ ዽኤፈመኒዸ። እሳንስ ኣርሳወን እብዳን ዋቀዮፍ ዽኤፈመን ከኔን ፎሊንሳኒ ቶሉዸ። ");
INSERT INTO gaze_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘ቡልቲ ኩርነፋ ጅአ ቶርበፋ ከናት ወል ገኢ ቁልቁሉ ጎዸዻ፤ እስንስ ገድ ኦፍ ዴብሳ፤ ሆጂ ቶኮሌስ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮፊ ጦባላወን ሆላ ቶርበ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ኣርሳ ጉበሙ ከን ፎሊንሳ ዋቀዮት ቶሉ ጎዻ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","ድብቸ ሰነ ወጅንስ ኬና ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ሰዲ ዘይቲዻን ሱኩመሜ ዽኤሳ፤ ኮርቤሰ ሆላ ወጅንስ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ለመ፣ ");
INSERT INTO gaze_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","ጦባላወን ሆላ ቶርበን ሰነ ወጅንስ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሰ ሀርከ ቶኮ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","አከሱመስ ኣርሳ ጩቡ ከን አራራ ቡሱፍ ዽኤፈሙፊ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ፣ ኬና ምዻንሳቲፊ ዽባዩሳት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘ቡልቲ ኩዸ ሸነፋ ጅአ ቶርበፋት ወል ገኢ ቁልቁሉ ጎዸዻ፤ ሆጂ እድሌ ህንሆጄትና። ዋቀዮፍስ ቡልቲ ቶርበ አያነ አያኔፈዻ። ");
INSERT INTO gaze_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","ጅቦተ ሎኒ ኩዸ ሰዲ፣ ኮርቤዪ ሆላ ለማፊ ጦባላወን ሆላ ኩዸ አፉር ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ኣርሳ ጉበሙ ከን ፎሊንሳ ዋቀዮት ቶሉፊ ከን እብዳን ዽኤፈሙ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","ቶኮ ቶኮ ጅቦተ ኩዸ ሰደኒ ወጅንስ ኬና ምዻኒ ከን ዳኩ ቡላኣ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርክ ሰዲ ዘይቲዻን ሱኩመሜ ዽኤሳ፤ ቶኮ ቶኮ ኮርቤዪ ሆላ ለማን ሰና ወጅንስ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ለመ፣ ");
INSERT INTO gaze_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","ቶኮ ቶኮ ጦባላወን ሆላ ኩዸ አፍረን ሰና ወጅንስ ኢፊ ቶኮራ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","አከሱመስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ ኬና ምዻን እሳቲፊ ዽባዩሳት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘ቡልቲ ለመፋት ጅቦተ ሎኒ ኩዸ ለመ፣ ኮርቤዪ ሆላ ለማፊ ጦባላወን ሆላ ኩዸ አፉር ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","አከ ለኮብሰ ሙርታኤቲፊ አኩመ አመለሳኒት ጅቦተ ሎኒ፣ ኮርቤዪ ሆላቲፊ ጦባላወን ሆላ ሰነ ወጅን ኬና ምዻንሳኒቲፊ ዽባዩሳኒ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","አከሱመስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ፣ ኬና ምዻንሳቲፊ ዽባዩሳኒት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘ቡልቲ ሰደፋት ጅቦተ ሎኒ ኩዸ ቶኮ፣ ኮርቤዪ ሆላ ለማፊ ጦባላወን ሆላ ኩዸ አፉር ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","አከ ለኮብሰ ሙርታኤቲፊ አኩመ አመለሳኒት ጅቦተ ሎኒ፣ ኮርቤዪ ሆላ ሰናፊ ጦባላወን ሆላ ሰነ ወጅንስ ኬና ምዻንሳኒቲፊ ዽባዩሳኒ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","አከሱመስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ፣ ኬና ምዻንሳቲፊ ዽባዩሳት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘ቡልቲ አፉረፋት ጅቦተ ሎኒ ኩዸን፣ ኮርቤዪ ሆላ ለማፊ ጦባላወን ሆላ ኩዸ አፉር ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","አከ ለኮብሰ ሙርታኤቲፊ አኩመ አመለሳኒት ጅቦተ ሎኒ፣ ኮርቤዪ ሆላ ሰናፊ ጦባላወን ሆላ ሰነ ወጅን ኬና ምዻንሳኒቲፊ ዽባዩሳኒ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","አከሱመስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ፣ ኬና ምዻን እሳቲፊ ዽባዩሳት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘ቡልቲ ሸነፋት ጅቦተ ሎኒ ሰገል፣ ኮርቤዪ ሆላ ለማፊ ጦባላወን ሆላ ኩዸ አፉር ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","አከ ለኮብሰ ሙርታኤቲፊ አኩመ አመለሳኒት ጅቦተ ሎኒ፣ ኮርቤዪ ሆላ ሰናፊ ጦባላወን ሆላ ሰነ ወጅን ኬና ምዻንሳኒቲፊ ዽባዩሳኒ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","አከሱመስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ፣ ኬና ምዻንሳቲፊ ዽባዩሳት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘ቡልቲ ጀአፋት ጅቦተ ሎኒ ሰዴት፣ ኮርቤዪ ሆላ ለማፊ ጦባላወን ሆላ ኩዸ አፉር ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","አከ ለኮብሰ ሙርታኤቲፊ አኩመ አመለሳኒት ጅቦተ ሎኒ፣ ኮርቤዪ ሆላ ሰናፊ ጦባላወን ሆላ ሰነ ወጅን ኬና ምዻንሳኒቲፊ ዽባዩሳኒ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","አከሱመስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ፣ ኬና ምዻንሳቲፊ ዽባዩሳት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘ቡልቲ ቶርበፋት ጅቦተ ሎኒ ቶርበ፣ ኮርቤዪ ሆላ ለማፊ ጦባላወን ሆላ ኩዸ አፉር ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","አከ ለኮብሰ ሙርታኤቲፊ አኩመ አመለሳኒት ጅቦተ ሎኒ፣ ኮርቤዪ ሆላ ሰናፊ ጦባላወን ሆላ ሰነ ወጅን ኬና ምዻኒቲፊ ዽባዩሳኒ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","አከሱመስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ፣ ኬና ምዻንሳቲፊ ዽባዩሳት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘ቡልቲ ሰዴተፋት ወል ገኢ ቁልቁሉ ጎዸዻ፤ ሆጂ እድሌ ህንሆጄትና። ");
INSERT INTO gaze_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","ድብቸ ሎኒ ቶኮ፣ ኮርቤሰ ሆላ ቶኮፊ ጦባላወን ሆላ ቶርበ ከኔን ኡሙሪንሳኒ ወጋ ቶኮ ቶኮ ተኤፊ ከኔን ሁንድሳኒ ህርእነ ህንቀብኔ ኣርሳ ጉበሙ ከን እብዳን ዽኤፈሙፊ ከን ፎሊንሳ ዋቀዮት ቶሉ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","አከ ለኮብሰ ሙርታኤቲፊ አኩመ አመለሳኒት ድብቸ ሎኒ፣ ኮርቤሰ ሆላ ሰናፊ ጦባላወን ሆላ ሰነ ወጅን ኬና ምዻንሳኒቲፊ ዽባዩሳኒ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","አከሱመስ ኣርሳ ጉበሙ ከን ዬሮ ሁንደ ዽኤፈሙ፣ ኬና ምዻንሳቲፊ ዽባዩሳት ደበላቲ ኮርቤሰ ሬኤ ቶኮ ኣርሳ ጩቡቲፍ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘ኣርሳኬሰን ከን ጉበሙ፣ ኬና ምዻንኬሰኒ፣ ዽባዩኬሰኒፊ ኣርሳኬሰን ከን ነጋ፣ ከን ወሬገኬሰኒቲፊ ኣርሳ ፌዺኬሰኒን ዽኤስተንት ደበላቲ አያነኬሰን ቤከማ ሰነረት ዋቀዮፍ ዽኤሳ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","ሙሴንስ ዋን ዋቀዮ እሰ አጀጄ ሁንደ እስራኤሎተት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","ሙሴን አቦቲ ጎሶተ እስራኤሊን አከነ ጄዼ፦ “ወን ዋቀዮ አጀጄ ከናዸ፦ ");
INSERT INTO gaze_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","ነምን ቶኮ ዮ ዋቀዮፍ ዋ ወሬጌ ዮካን አከ ዋን ቶኮ ሆጄቱ ኦፉማሳቲን ዮ ከከቴ፣ እን ከኩ ኦፊ ሰነ ህንጨብስን፤ ቆደ ከና ዋን ዱበቴ ሁንደ ጉቱ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“ዮ እንተል ቶኮ ኡቱመ መነ አባሼ ጅርቱ ዋቀዮፍ ወሬገ ወሬግዴ ዮካን ዋን ቶኮ ጎቹዻፍ ድርቀመ ኬሰ ሴንቴ፣ ");
INSERT INTO gaze_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","ዮ አባንሼስ ዋኤ ወሬገሼ ዮካን ድርቀመ ኬሰ ሴኑሼ ዸገኤ ሆማ እሼን ጄቹ ባቴ ወሬግንሼቲፊ ድርቀምን እሼን ሴንቴ ሱን ሁንድ ህንጌደረሙ። ");
INSERT INTO gaze_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","ዮ አባንሼ ዋን ከነ ዸገኤ እሼ ዾዌ ገሩ ወሬገሼ ዮካን ከኩ እሼን እቲን ድርቀመ ሴንቴ ኬሳ ቶኮዩ ህንጉተሙ፤ ሰበቢ አባንሼ እሼ ዾዌፍ ዋቀዮ እሼ ንብልሶምሰ። ");
INSERT INTO gaze_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“ዮ እሼን ኤርገ ወሬገ ሴንቴ ቦዴ ዮካን ኤርገ ዱቢ ኡቱ እት ህንያድን ዱበቴን ድርቀመ ሴንቴ ቦዴ ሄሩምቴ፣ ");
INSERT INTO gaze_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","ዽርስሼስ ዮ ዋን ከነ ዸገኤ ሆማ እሼን ጄቹ ባቴ ወሬግንሼ ዮካን ድርቀምን እሼን ሴንቴ ሱን ህንጌደረሙ። ");
INSERT INTO gaze_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","ገሩ ዽርስሼ ዮ ዬሮ ዋን ከነ ዸገኡት እሼ ዾዌ፣ ወሬገሼ ከን ድርቀመ ኬሰ እሼ ገልቹ ዮካን ዋዳ እሼን ኡቱ እት ህንያድን ድርቀመ ኬሰ ኦፍ ገልችቴ ሰነ እሼ ጀላ ዲገ፤ ዋቀዮስ እሼ ብልሶምሰ። ");
INSERT INTO gaze_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“ወሬግን ሃዸ ህዬሳ ዮካን ዱበርቲ ዽርሰ ጀላ ባቴ፣ ድርቀምን እሼን ሴንቴ ከምዩ እሼ ቀበተ። ");
INSERT INTO gaze_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“ዮ ዱበርቲን ዽርሰሼ ወጅን ጅራቱ ቶኮ ወሬገ ቶኮ ወሬግዴ ዮካን ዋን ቶኮ ጎቹዻፍ ከኩዻን ድርቀመ ኬሰ ኦፍ ገልችቴ፣ ");
INSERT INTO gaze_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","ዽርስሼስ ዮ ዋን ከነ ዸገኤ ሆማ እሼዻን ጄቹ ባቴ ዮካን ዮ እሼ ዾዉ ባቴ ወሬግንሼ ዮካን ዋዳን እሼን እቲን ድርቀመ ኬሰ ኦፍ ገልችቴ ሱን ሁንድ ህንጌደረሙ። ");
INSERT INTO gaze_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","ገሩ ዮ ዽርስሼ ዬሮ ዋን ከነ ዸገኡት እሼ ጀላ ዲጌ፣ ወሬገሼ ዮካን ዋዳ አፋንሼቲ በኤ ኬሳ ቶኮዩ ሆጂረ ህንኦሉ፤ ሰበቢ ዽርስሼ እሼ ጀላ ዲጌፍ፣ ዋቀዮ እሼ ብልሶምሰ። ");
INSERT INTO gaze_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","ዽርስሼ ወሬገ እሼን ወሬግዱ ዮካን ዋዳ እሼን ገድ ኦፍ ቀቡፍ ከኩዻን ሴንቱ ከምዩ ፉዸቹ ዮካን ዲጉ ንደንደአ። ");
INSERT INTO gaze_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","ገሩ ዮ ዽርስሼ ጉዩመ ጉያን ሆማ እሼን ጄቹ ባቴ፣ እን ወሬገ እሼ ዮካን ድርቀመ እሼረ ጅሩ ሁንደ ፉዸቴረ ጄቹዸ። እን ሰበቢ ጋፈ ዋኤ ዋን ከና ዸገኤ ሰነ ሆማ እሼዻን ህንጄዽኒፍ ዋን ሰነ ፉዸቴረ። ");
INSERT INTO gaze_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","ተኡስ እን ዮ ኤርገ ዋኤ ዋን ከና ዸገኤ ቦዴ ዋዳ ሰነ ዲጌ የከሼት ንጋፈተመ።” ");
INSERT INTO gaze_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","እሳን ኩኔን ሴረወን ዽርሳፊ ኒቲ ግዱ አከሱመስ አባፊ እንተለሳ ከን ዬሮ እጆሉማሼት መነሳ ጅርቱ ግዱ ጅራቹ ቀቡ ከን ዋቀዮ ሙሴ አጀጄዸ። ");
INSERT INTO gaze_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“ሰበ እስራኤሊፍ ጄዺቲ ወረ ምድያንረት ሃሎ በእ። ኤርገሲ አት ገረ ሰበኬቲት ወልት ቀበምተ።” ");
INSERT INTO gaze_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","ከነረት ሙሴን ሰበ ሰናን አከነ ጄዼ፤ “አከ እሳን ወረ ምድያንት ዱለኒ ሃሎ ዋቀዮ እሳንረት በአኒፍ ነሞተኬሰን ኬሳ ሙራሰ ህዸቺሳ። ");
INSERT INTO gaze_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","ቶኮ ቶኮ ጎሰ እስራኤል ኬሳ ነመ ኩመ ቶኮ ቶኮ ዱለት ኤርጋ።” ");
INSERT INTO gaze_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","አከስት ቶኮ ቶኮ ጎሰ እስራኤል ኬሳ ነሞትን ኩምን ቶኮ ቶኮ ወልት ቡፈመኒ ነምን ኩምን ኩዸ ለመ ሎላፍ ህዸቴ። ");
INSERT INTO gaze_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","ሙሴንስ ቶኮ ቶኮ ጎሳ ኬሳ ነመ ኩመ ቶኮ ቶኮ ፊኔሃስ እልመ ኤሌኣዛር ሉብቻ እሰ ምአ እዶ ቁልቁሉቲፊ መለከተ አፉፈሙ ሀርከት ቀበቴ ሰነ ወጅን ገረ ወራናት ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","እሳንስ አኩመ ዋቀዮ ሙሴ አጀጄ ሰነት ወረ ምድያን ሎለኒ ዺረ ሁንደ አጄሰን። ");
INSERT INTO gaze_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","ሞቶትን ምድያን ሸነን ጄቹንስ ኤዊ፣ ሬቄም፣ ዙር፣ ሁሪፊ ሬባንስ ወረ አጄፈመን ኬሰ ቱረን። አከሱመስ በለኣም እልመ ቤኦር ጎራዴዻን አጄሰን። ");
INSERT INTO gaze_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","እስራኤሎን ዱበርቶታፊ እጆሌ ወረ ምድያን ቦጅአን፤ ሎን፣ ቡሻዬፊ ቀቤኘሳኒ ሁንደስ ንሳመን። ");
INSERT INTO gaze_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","መጋላወን ምድያኖትን ኬሰ ጅራተን ሁንዳፊ ቁበተወንሳኒ ሁንደ እብዳን ጉበን። ");
INSERT INTO gaze_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","እሳንስ ዋን ቦጅአኒፊ ዋን ሳመን ሁንደ ነማፊ ሆሪሌ ፉዸኒ ");
INSERT INTO gaze_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","ወረ ቦጅአን፣ ዋን ቀበተኒፊ ዋን ሳመን ገረ እዶ ቁበተሳኒ ከን ፉለ ዬርኮ ዱረ፣ ዮርዳኖስ ጭነ፣ ድሬወን ሞኣብ ኬሰ ጅሩት ገረ ሙሴት፣ ገረ ኤሌኣዛር ሉብቻቲፊ ገረ ወልዳ እስራኤልት ፍደን። ");
INSERT INTO gaze_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","ሙሴን፣ ኤሌኣዛር ሉብቺፊ ሆገንቶትን ወልዳ ሁንድ ቁበታን አለት እሳን ስመቹፍ ገድ በአን። ");
INSERT INTO gaze_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","ሙሴንስ አጀጁወን ሎልቶታ ጄቹንስ አጀጁወን ኩማቲፊ አጀጁወን ዽባ ከኔን ሎላ ገለንት ኣሬ። ");
INSERT INTO gaze_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","እንስ አከነ ጄዼ እሳን ጋፈቴ፤ “እስን ማሊፍ ዱበርቶተ ሁንደ ሀምብፍተን? ");
INSERT INTO gaze_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","ኩኖ ወር ዋን ጴኦርት ተኤ ሰነ ኬሰት ጎርሰ በለኣም ፉዸቹዻን አከ ዸእች ሰበ ዋቀዮረ ቡኡፍ እስራኤሎተ ዋቀዮራ ዴብሰን እሳን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","አመስ እልማን ዺራ ሁንደ ፍጣ፤ አከሱመስ ዱበርቲ ዺረ ወጅን ጪፍቴ ሁንደ አጄሳ። ");
INSERT INTO gaze_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","ገሩ ዱበረ ተኩማ ዺረ ወጅን ህንጪስን ኦፊኬሰኒፍ ሀምብፈዻ። ");
INSERT INTO gaze_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“እስን ኬሳ ነምን ነመ አጄሴ ከምዩ ዮካን ነምን ነመ አጄፈሜ ቱቄ ከምዩ ቡልቲ ቶርበ ቁበታን አለ ሃቱሩ። ቡልቲ ሰደፋፊ ቡልቲ ቶርበፋትስ ኦፊኬሰኒፊ ቦጁኬሰን ቁልቁሌሳ። ");
INSERT INTO gaze_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","ኡፈተ ሁንደ አከሱመስ ዋን ጎጋራ፣ ርፌንሰ ሬኤራ ዮካን ሙከራ ሆጄተሜ ሁንደ ቁልቁሌሳ።” ");
INSERT INTO gaze_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","ኤርገሲስ ኤሌኣዛር ሉብች ሎልቶተ ዱለ ዸቀኒ ቱረን ሰናን አከነ ጄዼ፤ “ቀጄልፈምን ሴራ ከን ዋቀዮ ሙሴፍ ኬኔ ከናዸ፦ ");
INSERT INTO gaze_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","ወርቄ፣ ሜቲ፣ ናሲ፣ ስቢለ፣ ቆርቆሮ፣ ድላሊፊ ");
INSERT INTO gaze_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","ወን እብደራ ሀፉ ደንደኡ ከምዩ እብደ ኬሰ ደበርፈሜ ቁልቁላኡ ቀበ። ገሩ ወን ሱን ብሻን ቁልቁላኡማቲንስ ቁልቁሌፈሙ ቀበ። ወን እብደረ ሀፉ ህንደንዴኜ ከምዩ ብሻን ሰናን ቁልቁሌፈመ። ");
INSERT INTO gaze_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","ጉያ ቶርበፋት ኡፈተኬሰን ሚጨዻ፤ እስንስ ንቁልቁሌፈምቱ። ኤርገሲ ቁበተት ገሉ ደንዴሱ።” ");
INSERT INTO gaze_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“አት፣ ኤሌኣዛር ሉብቺፊ አቦቲን ማቲ ወልዳ ሰና ነሞታፊ ሆሪ ቦጅአመን ለካኣ። ");
INSERT INTO gaze_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","ቦጁ ሰነስ ሎልቶተ ዱለ ዸቀኒ ቱረኒፊ ወልዳ ሁንደ ግዱት እዶ ለመት ቆድ። ");
INSERT INTO gaze_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","ሎልቶተ ዱለንራ ነመስ ተኡ ሎን፣ ሀሮተ፣ ሆሎተ ዮካን ሬኦተ ዽበ ሸን ኬሳ ቶኮ ዋቀዮፍ ግብረ ፉዽ። ");
INSERT INTO gaze_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","ግብረ ሰነስ ወለካ ቆደሳኒራ ፉዺ ቆደ ዋቀዮ ጎዺቲ ኤሌኣዛር ሉብቸት ኬን። ");
INSERT INTO gaze_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","ወለካ ቆደ ሰበ እስራኤል እራሞ ነመስ ተኡ ሎን፣ ሀሮተ፣ ሆሎተ፣ ሬኦተ ዮካን ሆሪ ብራ ሸንተመ ኬሳ ቶኮ ፉዺቲ ሌዎተ ወረ እት ጋፈተምቶተ ዱንካነ ዋቀዮ ተአንት ኬን።” ");
INSERT INTO gaze_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","ሙሴፊ ኤሌኣዛር ሉብች አኩመ ዋቀዮ ሙሴ አጀጄ ሰነ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","ወንት ቦጁ ሎልቶትን ፉዸተንራ ሀፌ ሆሎተ 675,000፣ ");
INSERT INTO gaze_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","ሎን 72,000፣ ");
INSERT INTO gaze_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","ሀሮተ 61,000፣ ");
INSERT INTO gaze_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","ዱበርቶትን ተኩማ ዺረ ወጅን ህንጪስን 32,000 ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","ቆድን ወለካ ከን ወረ ዱለኒፍ ቆደሜ፦ ሆሎተ 337,500 ");
INSERT INTO gaze_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","ኬሳ ግብር ዋቀዮ 675 ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","ሎን 36,000 ኬሳ ግብር ዋቀዮ 72 ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","ሀሮተ 30,500 ኬሳ ግብር ዋቀዮ 61 ቱሬ፤ ");
INSERT INTO gaze_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","ነመ 16,000 ኬሳ ግብር ዋቀዮ 32 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","ሙሴን አኩመ ዋቀዮ እሰ አጀጄ ሰነት ግብረ ሰነ ቆደ ዋቀዮ ጎዼ ኤሌኣዛር ሉብቸት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","ቆደ ወለካ ከን ሙሴን ወረ ዱለንራ እስራኤሎታፍ ቆዴ፦ ");
INSERT INTO gaze_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","ወለካን ቦጁ ከን ወልዳ ሰና ሆሎተ 337,500፣ ");
INSERT INTO gaze_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","ሎን 36,000፣ ");
INSERT INTO gaze_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","ሀሮተ 30,500፣ ");
INSERT INTO gaze_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","ነመ 16,000 ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","ሙሴን አኩመ ዋቀዮ እሰ አጀጄ ሰነት ወለካ ሰበ እስራኤልራ ነማፊ ሆሪ ሸንተመ ኬሳ ቶኮ ፉዼ ሌዎተ ወረ እት ጋፈተምቶተ ዱንካነ ዋቀዮ ተአንት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("NU31_48","005_31_48","NUM","31","48","48","ኤርገሲስ አጀጁወን ሎልቶተ ኩማተመረት ኣንጎ ቀበን ጄቹንስ አጀጁወን ኩማቲፊ አጀጁወን ዽባ ገረ ሙሴ ዸቀኒ ");
INSERT INTO gaze_vpl VALUES ("NU31_49","005_31_49","NUM","31","49","49","አከነ ጄዸኒን፤ “ኑ ገርቦንኬ ሎልቶተ አጀጀኬኘ ጀለ ጅረን ለኮፍኔረ፤ ነምን ቶኮዩ ህንህርአትኔ። ");
INSERT INTO gaze_vpl VALUES ("NU31_50","005_31_50","NUM","31","50","50","ከናፉ ኑ ዋን ቶኮን ቶኮንኬኘ አርገትኔ ጄቹንስ ምአ ወርቄ፣ አርቦረ፣ ብተዎ፣ ቁቤላ ቻፓ፣ ሎቲፊ አመርቲ ሞርማ አከ ፉለ ዋቀዮ ዱረት ኣርሳ አራረ ኑ ቡሱፍ ኬና ዋቀዮፍ ዽኤፈሙ ጎኔ ፍድኔረ።” ");
INSERT INTO gaze_vpl VALUES ("NU31_51","005_31_51","NUM","31","51","51","ሙሴፊ ኤሌኣዛር ሉብችስ ወርቄፊ ፋየወን ሀርካን ቶልፈመን ሁንደ እሳን ሀርካ ፉዸን። ");
INSERT INTO gaze_vpl VALUES ("NU31_52","005_31_52","NUM","31","52","52","ወርቄን አጀጁወን ኩማቲፊ አጀጁወን ዽባ ኬነን ከኔን ሙሴፊ ኤሌኣዛር አከ ኬናት ዋቀዮፍ ዽኤሰን ሁንድ ሰቅሊ 16,750 ኡልፋቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU31_53","005_31_53","NUM","31","53","53","ቶኮን ቶኮን ሎልቶታ ኦፊሳኒቲፍ ቦጁ ፉዸተኒ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("NU31_54","005_31_54","NUM","31","54","54","ሙሴፊ ኤሌኣዛር ሉብችስ ወርቄ ሰነ አጀጁወን ኩማቲፊ አጀጁወን ዽባ ሀርካ ፉዸኒ አከ እስራኤሎን ፉለ ዋቀዮ ዱረት እቲን ያደተመኒፍ ዱንካነ ወል ገኢት ኦል ገልቸን። ");
INSERT INTO gaze_vpl VALUES ("NU32_1","005_32_1","NUM","32","1","1","እልማን ሩቤኒፊ እልማን ጋድ ወር ሎኒፊ ቡሻዬ ሄዱ ቀበን አከ ብይ የእዜሪፊ ብይ ግልኣድ ሆሪሳኒቲፍ ቶሉ አርገን። ");
INSERT INTO gaze_vpl VALUES ("NU32_2","005_32_2","NUM","32","2","2","እሳን ገረ ሙሴ፣ ገረ ኤሌኣዛር ሉብቻቲፊ ገረ ሆገንቶተ ወልዳ ዹፈኒ አከነ ጄዸን፤ ");
INSERT INTO gaze_vpl VALUES ("NU32_3","005_32_3","NUM","32","3","3","“አጣሮት፣ ዲቦን፣ የእዜር፣ ኒምራ፣ ሄሽቦን፣ ኤሌኣሌ፣ ሴባማ፣ ኔቦፊ ቤኦን፣ ");
INSERT INTO gaze_vpl VALUES ("NU32_4","005_32_4","NUM","32","4","4","ብይ ዋቀዮ ፉለ ወልዳ እስራኤል ዱረት ሩኩቴ ሱን ሆሪፍ ቶላዸ፤ ኑ ተጃጅልቶትንኬስ ሆሪ ቀብነ። ");
INSERT INTO gaze_vpl VALUES ("NU32_5","005_32_5","NUM","32","5","5","ዮ ኑ ፉለኬ ዱረት ፉዸተመ አርገትኔ ጅራትኔ ብይ ኩን ኑ ተጃጅልቶተኬቲፍ ሀንዹራ ተኤ ሃኬነሙ። አከ ኑ ዮርዳኖስ ገመ ጬኑስ ህንጎዽን።” ");
INSERT INTO gaze_vpl VALUES ("NU32_6","005_32_6","NUM","32","6","6","ሙሴንስ እልማን ጋዲፊ እልማን ሩቤኒን አከነ ጄዼ፤ “ኦቦሎትንኬሰን ዱለ ዸቀኒ እስንሞ አስ ቴሱ? ");
INSERT INTO gaze_vpl VALUES ("NU32_7","005_32_7","NUM","32","7","7","እስን ማሊፍ አከ እስራኤሎን ብየ ዋቀዮ እሳኒ ኬኔ ሰነት ጬአኒ ህንገሌፍ አብዲ እሳን ኩተቺፍቱ? ");
INSERT INTO gaze_vpl VALUES ("NU32_8","005_32_8","NUM","32","8","8","ኩን ዋኑመ አቦቲንኬሰን ጋፈ አን አከ እሳን ብየቲ እላለኒፍ ጄዼ ቃዴሽ በርኔራ እሳን ኤርጌ ሰነ ሆጄተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("NU32_9","005_32_9","NUM","32","9","9","እሳንስ ኤርገ ገረ ሱሉለ ኤሽኮል ዸቀኒ ብየ ሰነ አርገኒ ቦዴ አከ እስራኤሎን ብየ ዋቀዮ እሳኒፍ ኬኔት ህንገሌፍ አብዲ እሳን ኩተቺሰን። ");
INSERT INTO gaze_vpl VALUES ("NU32_10","005_32_10","NUM","32","10","10","ዼከምስ ዋቀዮስ ጉዩመ ሰነ ቦበኤ፤ እንስ አከነ ጄዼ ከከቴ፤ ");
INSERT INTO gaze_vpl VALUES ("NU32_11","005_32_11","NUM","32","11","11","‘ዋን እሳን ገራ ጉቱዻን ነ ፋነ ዴሙ ድደኒፍ፣ ነሞተ ወጋ ድግደማቲፊ ሀመሲ ኦሊ ከኔን ብየ ግብጢቲ በአኒ ዹፈን ኬሳ ነምን ቶኮዩ ብየ አን አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ ዋዳ ገሌ ሰነ ህንአርጉ። ");
INSERT INTO gaze_vpl VALUES ("NU32_12","005_32_12","NUM","32","12","12","ካሌብ እልመ ዬፉኔ ከን ጎሰ ቄኔዚፊ እያሱ እልመ ኑን መሌ ነምን ቶኮዩ ህንአርጉ፤ እሳን ለማን ገራ ጉቱዻን ዋቀዮ ዱካ ቡአኒሩቲ።’ ");
INSERT INTO gaze_vpl VALUES ("NU32_13","005_32_13","NUM","32","13","13","ዼከምስ ዋቀዮ እስራኤልረት ቦበኤ፤ እንስ ሀመ ዸሎትን ፉለሳ ዱረት ዋን ሀማ ሆጄቴ ሱን ሁንድ ዹሙት አከ እሳን ወጋ አፉርተመ ገሞጂ ኬሰ ጆረን ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("NU32_14","005_32_14","NUM","32","14","14","“ያ ሰኚ ጩበሞታነነ፣ እስን ኩኖ ዼከምሰ ዋቀዮ ከን እስራኤልረት ቦበኤ ሰነ እቱመ ጫልችሱፍ እዶ አቦቲኬሰኒ ቡተኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("NU32_15","005_32_15","NUM","32","15","15","ዮ እስን እሰ ዱካ ቡኡራ ገረገልተን እን አመስ ገሞጂ ከነ ኬሰት ሰበ ከነ ሁንደ ንዺሰ፤ እስንስ ኡመተ ከነ ንበሌስቱ።” ");
INSERT INTO gaze_vpl VALUES ("NU32_16","005_32_16","NUM","32","16","16","እሳን ገረሳ ዹፈኒ አከነ ጄዸኒን፤ “ኑ አስት ሆሪኬኛፍ ደላ፣ ዱበርቶታፊ እጆሌኬኛፍሞ መጋላወን እጃረ። ");
INSERT INTO gaze_vpl VALUES ("NU32_17","005_32_17","NUM","32","17","17","ኑ ገሩ ሀመ ለፈ እሳኒቲን እሳን ጌኙት ህዸትኔ እስራኤል ዱረ ዴሙፍ ቆጳኦዸ። ዬሮ ከነት አከ ጅራቶትን ብየቲ እሳን ህንቱቅኔፍ ዱበርቶትኒፊ እጆሌንኬኘ መጋላወን ደላ ጀባ ቀበን ኬሰ ሃጅራተን። ");
INSERT INTO gaze_vpl VALUES ("NU32_18","005_32_18","NUM","32","18","18","ሀመ ቶኮን ቶኮን እስራኤሎታ ዻለ ኦፊሳኒ አርገተንት ኑ መነኬኘት ህንዴብኑ። ");
INSERT INTO gaze_vpl VALUES ("NU32_19","005_32_19","NUM","32","19","19","ሰበቢ ዻልኬኘ ለገ ዮርዳኖስራ ገረ በኣት ኑፍ ኬነሜፍ ኑ ዮርዳኖስራ ገመ ካኒን እሳን ወጅን ዋን ዻሉ ህንቀብኑ።” ");
INSERT INTO gaze_vpl VALUES ("NU32_20","005_32_20","NUM","32","20","20","ሙሴንስ አከነ እሳኒን ጄዼ፤ “ዮ እስን ዋን ከነ ጎተን፣ ዮ እስን ፉለ ዋቀዮ ዱረት ህዸተኒ ዱላፍ ካተን፣ ");
INSERT INTO gaze_vpl VALUES ("NU32_21","005_32_21","NUM","32","21","21","ዮ እስን ሁንድኑ ሀመ እን ዲኖተ ኦፊሳ ፉለ ኦፊሳ ዱራ አርኤ ባሱት ህዸተኒ ፉለ ዋቀዮ ዱረ ዮርዳኖስን ጬተን፣ ");
INSERT INTO gaze_vpl VALUES ("NU32_22","005_32_22","NUM","32","22","22","ዬሮ ብየቲን ፉለ ዋቀዮ ዱረት ሞአተምቱት እስን እት ጋፈተመ ዋቀዮፊ ሰበ እስራኤሊፍ ቀብደንራ ንብልሶምቱ። ብይ ሱንስ ፉለ ዋቀዮ ዱረት ዻለኬሰን ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU32_23","005_32_23","NUM","32","23","23","“ገሩ እስን ዮ ዋን ከነ ጎቹ ባተን፣ ኩኖ ዋቀዮት ጩቡ ሆጄቹኬሰን፤ አከ ጩቡንኬሰን እስን አርገቱሌ ቤከዻ። ");
INSERT INTO gaze_vpl VALUES ("NU32_24","005_32_24","NUM","32","24","24","ዱበርቶታፊ እጆሌኬሰኒፍ መጋላወን፣ ቡሻዬኬሰኒፍሞ ደላ እጃራ፤ እስን ገሩ ዋን ዋዳ ገልተን ሰነ ጉታ።” ");
INSERT INTO gaze_vpl VALUES ("NU32_25","005_32_25","NUM","32","25","25","እልማን ጋዲፊ እልማን ሩቤን ሙሴዻን አከነ ጄዸን፤ “ኑ ገርቦንኬ አኩመ ጎፍታንኬኘ ኑ አጀጁ ጎነ። ");
INSERT INTO gaze_vpl VALUES ("NU32_26","005_32_26","NUM","32","26","26","እጆሌንኬኛፊ ኒቶትንኬኘ፣ ቡሻዬንኬኛፊ ሎንኬኘ፣ አሱመ መጋላወን ግልኣድት ሃሀፈን። ");
INSERT INTO gaze_vpl VALUES ("NU32_27","005_32_27","NUM","32","27","27","ኑ ገርቦንኬ ገሩ ቶኮን ቶኮንኬኘ አኩመ ጎፍታንኬኘ ጄዼ ሰነ ዱላፍ ቆጶፍኔ ፉለ ዋቀዮ ዱረት ዱሉፍ ንጬነ።” ");
INSERT INTO gaze_vpl VALUES ("NU32_28","005_32_28","NUM","32","28","28","ኤርገሲስ ሙሴን ዋኤሳኒ ኤሌኣዛር ሉብቻፍ፣ እያሱ እልመ ኑንቲፊ አቦቲ ማቲ ጎሶተ እስራኤሊፍ አጀጀ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("NU32_29","005_32_29","NUM","32","29","29","እንስ አከነ እሳኒን ጄዼ፤ “ዮ እልማን ጋዲፊ እልማን ሩቤን፣ ነምን ወራናፍ ህዸቴ ሁንድ ፉለ ዋቀዮ ዱረት እስን ወጅን ዮርዳኖስ ጬኤ፣ ዮሙ ብየቲን እስን ሀርከ ገልቱት ብየ ግልኣድ ሰነ ኬናፊ። ");
INSERT INTO gaze_vpl VALUES ("NU32_30","005_32_30","NUM","32","30","30","ገሩ እሳን ዮ ዱላፍ ህዸተኒ እስን ወጅን ጬኡ ባተን፣ ከነኣን ኬሰት እስን ወጅን ለፈ ሃአርገተን።” ");
INSERT INTO gaze_vpl VALUES ("NU32_31","005_32_31","NUM","32","31","31","እልማን ጋዲፊ እልማን ሩቤንስ አከነ ጄዸኒ ዴቢ ኬነን፤ “ኑ ገርቦንኬ ዋን ዋቀዮ ጄዼ ንጎነ። ");
INSERT INTO gaze_vpl VALUES ("NU32_32","005_32_32","NUM","32","32","32","ኑ ምአ ሎላ ህዸትኔ ፉለ ዋቀዮ ዱረ ጬኔ ከነኣን ሴነ፤ ገሩ ቀቤኝ ኑ ዻሉ ዮርዳኖሲን ገመት ኑፍ ሃሀፉ።” ");
INSERT INTO gaze_vpl VALUES ("NU32_33","005_32_33","NUM","32","33","33","ሙሴንስ ሞቱማ ስሆን ሞቲ አሞሮታፊ ሞቱማ ኦግ ሞቲ ባሻን ጄቹንስ ብየ ሰነ ጉቱ መጋላወንሳኒቲፊ ቡልቺንሰ ናኖሳኒ ጅሩ ሰነ እልማን ጋዲቲፍ፣ እልማን ሩቤኒቲፊ ወለካ ጎሰ ምናሴ እልመ ዮሴፊፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("NU32_34","005_32_34","NUM","32","34","34","እልማን ጋድስ መጋላወን ዲቦን፣ አጣሮት፣ አሮኤር፣ ");
INSERT INTO gaze_vpl VALUES ("NU32_35","005_32_35","NUM","32","35","35","አትሮት ሾፋን፣ የእዜር፣ ዮግብሃ፣ ");
INSERT INTO gaze_vpl VALUES ("NU32_36","005_32_36","NUM","32","36","36","ቤት ኒምራፊ ቤት ሃራን መጋላወን ጀጀቦ ጎዸኒ እጃረን። ቡሻዬሳኒቲፍስ ደላ እጃረተን። ");
INSERT INTO gaze_vpl VALUES ("NU32_37","005_32_37","NUM","32","37","37","እልማን ሩቤንስ መጋላወን ሄሽቦን፣ ኤሌኣሌኒፊ ክርያታይም፣ ");
INSERT INTO gaze_vpl VALUES ("NU32_38","005_32_38","NUM","32","38","38","አከሱመስ ኔቦፊ በኣል ሜኦን ጄቹንስ መጋላወን መቃንሳኒ ጌደረሜፊ ስብማ ዴብሰኒ እጃረን። እሳንስ መጋላወን ዴብሰኒ እጃረን ሰናፍ መቃ ባሰን። ");
INSERT INTO gaze_vpl VALUES ("NU32_39","005_32_39","NUM","32","39","39","እጆሌን ማኪር እልመ ምናሴስ ገረ ግልኣድ ዸቀኒ ብየቲ ቀበተኒ አሞሮተ አች ቱረን አርአኒ ባሰን። ");
INSERT INTO gaze_vpl VALUES ("NU32_40","005_32_40","NUM","32","40","40","ሙሴንስ ግልኣድን እጆሌ ማኪር ሰኚ ምናሴቲፍ ኬኔ፤ እሳንስ አች ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU32_41","005_32_41","NUM","32","41","41","ያኢር እልም ምናሴስ ዸቄ ገንዶተሳኒ ፉዸቴ ገንዶተ ያኢሮታ ጄዼ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("NU32_42","005_32_42","NUM","32","42","42","ኖባንሞ ቄናቲፊ ገንዶተ ናኖሳ ጅረን ቀበቴ ኖባ ጄዼ መቃ ኦፊ እሳቲን ዋሜ። ");
INSERT INTO gaze_vpl VALUES ("NU33_1","005_33_1","NUM","33","1","1","ሰደርካሌን አዴምሰ ሰበ እስራኤል ከን ዬሮ እሳን ኩታ ኩታዻን ቀጄልፈመ ሙሴቲፊ አሮን ጀለት ብየ ግብጢ በአኒ ከነ። ");
INSERT INTO gaze_vpl VALUES ("NU33_2","005_33_2","NUM","33","2","2","ሙሴን አጀጀ ዋቀዮቲን ሰደርካሌ አዴምሰሳኒ ገልሜሴ። አዴምስሳኒስ ሰደርካ ሰደርካዻን ኩኖት፦ ");
INSERT INTO gaze_vpl VALUES ("NU33_3","005_33_3","NUM","33","3","3","እስራኤሎን ጅአ ጀልቀባ ኬሰ ጉያ ኩዸ ሸነፋት ጉያ ፋሲካት ኣኑ ራምሴዻ ከአኒ ቀጄለን። እሳንስ ኡቱመ ወር ግብጢ ሁንድ እሳን አርገኑ እሬ ጀባዻን ዴመን፤ ");
INSERT INTO gaze_vpl VALUES ("NU33_4","005_33_4","NUM","33","4","4","ዬሮ ከነ ወር ግብጥ እልማን ሀንገፈሳኒ ከኔን ዋቀዮ እሳን ግዱዻ ፍጤ ሁንደ አዋለቻ ቱረን፤ ዋቆተ ወረ ግብጥት ዋቀዮ ሙሬ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("NU33_5","005_33_5","NUM","33","5","5","እስራኤሎንስ ራምሴዻ ከአኒ ሱኮት ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_6","005_33_6","NUM","33","6","6","ሱኮቲ ከአኒ ኤታም እሼ ቀርቀረ ገሞጂት አርገምቱ ኬሰ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_7","005_33_7","NUM","33","7","7","ኤታሚ ከአኒ ገረ ጲ ሀሂሮት ከን ገመ በአ በኣል ዜፎኒት አርገምቱት ገረ ገለኒ ምግዶል ብረ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_8","005_33_8","NUM","33","8","8","ፊሀሂሮቲ ከአኒ ገላነ ኬሰ ደርበኒ ገሞጂ ሴነን፤ እሳንስ ገሞጂ ኤታሚ ኬሰ ቡልቲ ሰዲ ዴመኒ ማራ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_9","005_33_9","NUM","33","9","9","ማራዻ ከአኒ ኤልም ለፈ ቡርቃ ኩዸ ለማፊ ሙከ ሜጢ ቶርባተመ ቀቡ ሰነ ዸቀኒ አች ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_10","005_33_10","NUM","33","10","10","ኤልሚ ከአኒ ገላነ ዲማ ጭነ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_11","005_33_11","NUM","33","11","11","ገላነ ዲማዻ ከአኒ ገሞጂ ሲን ኬሰ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_12","005_33_12","NUM","33","12","12","ገሞጂ ሲኒቲ ከአኒ ዶፍቃ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_13","005_33_13","NUM","33","13","13","ዶፍቃዻ ከአኒ ኣሉሽ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_14","005_33_14","NUM","33","14","14","ኣሉሺ ከአኒ ሬፊዲም ለፈ ብሻን ነምን ዹጉ ህንጅሬ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_15","005_33_15","NUM","33","15","15","ሬፊዲሚ ከአኒ ገሞጂ ሲና ኬሰ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_16","005_33_16","NUM","33","16","16","ገሞጂ ሲናቲ ከአኒ ቂብሮት ሀታባ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_17","005_33_17","NUM","33","17","17","ቂብሮት ሀታባዻ ከአኒ ሀጤሮት ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_18","005_33_18","NUM","33","18","18","ሀጤሮቲ ከአኒ ሪትማ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_19","005_33_19","NUM","33","19","19","ሪትማዻ ከአኒ ርሞን ጴሬዝ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_20","005_33_20","NUM","33","20","20","ርሞን ጴሬዚ ከአኒ ልብና ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_21","005_33_21","NUM","33","21","21","ልብናዻ ከአኒ ሪሳ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_22","005_33_22","NUM","33","22","22","ሪሳዻ ከአኒ ቄሄላታ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_23","005_33_23","NUM","33","23","23","ቄሄላታዻ ከአኒ ጋረ ሻፌር ብረ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_24","005_33_24","NUM","33","24","24","ጋረ ሻፌር ብራ ከአኒ ሀራዳ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_25","005_33_25","NUM","33","25","25","ሀራዳ ከአኒ መቅሄሎት ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_26","005_33_26","NUM","33","26","26","መቅሄሎቲ ከአኒ ተሃት ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_27","005_33_27","NUM","33","27","27","ተሃቲ ከአኒ ታራ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_28","005_33_28","NUM","33","28","28","ታራዻ ከአኒ ሚትቃ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_29","005_33_29","NUM","33","29","29","ሚትቃዻ ከአኒ ሀሽሞና ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_30","005_33_30","NUM","33","30","30","ሀሽሞናዻ ከአኒ ሞሴሮት ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_31","005_33_31","NUM","33","31","31","ሞሴሮቲ ከአኒ ቤኔ ያአካን ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_32","005_33_32","NUM","33","32","32","ቤኔ ያአካኒ ከአኒ ሆር ሀግድጋድ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_33","005_33_33","NUM","33","33","33","ሆር ሀግድጋዲ ከአኒ ዮጥባታ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_34","005_33_34","NUM","33","34","34","ዮጥባታዻ ከአኒ አብሮና ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_35","005_33_35","NUM","33","35","35","አብሮናዻ ከአኒ ኤዝዮን ጌቤር ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_36","005_33_36","NUM","33","36","36","ኤዝዮን ጌቤሪ ከአኒ ገሞጂ ሲን ኬሰ ቃዴሽ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_37","005_33_37","NUM","33","37","37","ቃዴሺ ከአኒ ዳሪ ብየ ኤዶምራ ቱሉ ሆር ብረ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_38","005_33_38","NUM","33","38","38","አሮን ሉብችስ አጀጀ ዋቀዮቲን ቱሉ ሆሪት ኦል በኤ፤ እንስ ኤርገ እስራኤሎን ብየ ግብጢቲ በአኒ ቦዴ ወጋ አፉርተመፋት ጉያ ጀልቀበ ጅአ ሸነፋት አችት ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("NU33_39","005_33_39","NUM","33","39","39","አሮን ዮሙ ቱሉ ሆርረት ዱኤ ሰነ ኡሙሪንሳ ወጋ ዽበ ቶኮፊ ድግደሚ ሰዲ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("NU33_40","005_33_40","NUM","33","40","40","ሞቲን ኣራድ ነምች ከነኣን ከን ኔጌብ ኬሰ ጅራቻ ቱሬ ሱን አከ ሰብን እስራኤል ዹፋ ጅሩ ዸገኤ። ");
INSERT INTO gaze_vpl VALUES ("NU33_41","005_33_41","NUM","33","41","41","እሳንስ ቱሉ ሆሪቲ ከአኒ ዘልሞና ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_42","005_33_42","NUM","33","42","42","ዘልሞናዻ ከአኒ ጱኖን ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_43","005_33_43","NUM","33","43","43","ጱኖኒዻ ከአኒ ኦቦት ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_44","005_33_44","NUM","33","44","44","ኦቦቲ ከአኒ ዳሪ ሞኣብረ እዬ አባሪም ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_45","005_33_45","NUM","33","45","45","እዪሚ ከአኒ ዲቦንጋድ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_46","005_33_46","NUM","33","46","46","ዲቦንጋዲ ከአኒ አልሞን ዲብላተይም ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_47","005_33_47","NUM","33","47","47","አልሞን ዲብላተይሚ ከአኒ ኔቦ ቱሉወን አባሪም ብረ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_48","005_33_48","NUM","33","48","48","ቱሉወን አባሪሚቲ ከአኒ ድሬወን ሞኣብራ፣ ዮርዳኖስ ብረ፣ ዬርኮ ገመ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_49","005_33_49","NUM","33","49","49","እሳንስ ድሬወን ሞኣብ ከን ዮርዳኖስ ጭነ ቤት የሺሞቲ ጀልቀቤ ሀመ አቤል ሽጢሚት ጅሩ ሰነረ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("NU33_50","005_33_50","NUM","33","50","50","ዋቀዮስ ድሬወን ሞኣብረት፣ ዮርዳኖስ ብረት፣ ዬርኮ ገመት ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU33_51","005_33_51","NUM","33","51","51","“አከነ ጄዺ ሰበ እስራኤልት ዱበዹ፤ ‘እስን ዮሙ ዮርዳኖስ ጬተኒ ከነኣንት ገልተንት፣ ");
INSERT INTO gaze_vpl VALUES ("NU33_52","005_33_52","NUM","33","52","52","ጅራቶተ ብየ ሰና ኦፍ ዱራ አርኣ ባሳ። ፈኪወንሳኒ ከኔን ሶፈመኒ ሆጄተመኒፊ ዋቆተሳኒ ከኔን በቅፈመኒ ቶልፈመን ሁንደ በርበዴሳ፤ ጋረን ሰገዳሳኒ ሁንደስ ዲጋ። ");
INSERT INTO gaze_vpl VALUES ("NU33_53","005_33_53","NUM","33","53","53","ሰበቢ አን ብየቲ ሀንዹራ ጎዼ እስኒ ኬኔፍ፣ ብየቲ ዹንፈዻ ኬሰ ጅራዻ። ");
INSERT INTO gaze_vpl VALUES ("NU33_54","005_33_54","NUM","33","54","54","ብየ ሰነስ ማቲወንኬሰኒፍ ዻለ ጎዻቲ እጣዻን ገርገር ቆዳ፤ ማቲ ባይኤዻፍ ዻለ ጉዳ፣ ማቲ ሙራሳፍሞ ዻለ ጥና ኬና። እዶን እጣዻንሳኒ በኤ ከንሳኒ ተአ። እስንስ አኩመ ጎሶተ አቦቲኬሰኒት ዻላ። ");
INSERT INTO gaze_vpl VALUES ("NU33_55","005_33_55","NUM","33","55","55","“ ‘ገሩ ዮ እስን ወረ ብየ ሰነ ጅራተን አቺ ባሱ ባተን፣ ወር እስን አከ እሳን አች ጅራተኒፍ ዺፍተን ሱን አከ ሁበ እጀ ኬሳቲፊ አከ ቆራቲ ጭናቸ ኬሳ እስንት ተኡ። ብየ እስን ኬሰ ጅራተን ኬሰትስ እስን ረክሱ። ");
INSERT INTO gaze_vpl VALUES ("NU33_56","005_33_56","NUM","33","56","56","አንስ ዋነን እሳን ጎቹ ያዴ ሰነ እስንት ነንፍደ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU34_1","005_34_1","NUM","34","1","1","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_2","005_34_2","NUM","34","2","2","“አከነ ጄዺ እስራኤሎተ አጀጅ፦ ‘ዬሮ እስን ከነኣን ሴንተንት ብይ አከ ዻላት እስኒ ኬነምቱ ሱን ዳንጋወን ከኔን ቀባት፦ ");
INSERT INTO gaze_vpl VALUES ("NU34_3","005_34_3","NUM","34","3","3","“ ‘ዳንጋንኬሰን ከን ገመ ክባ ገሞጂ ሲን ከን ቀርቀረ ኤዶምረ ጅርቱራ ጀልቀበ፤ ከራ በኣቲን ዳንጋንኬሰን ከን ክባ ዹመ ገላነ ሶግዳራ ጀልቀበ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_4","005_34_4","NUM","34","4","4","ዳንጋንኬሰን ክበራ ገረ ተበ አቅረቢምት ዴብኤ፣ ገረ ሲንት ጬኤ ሀመ ክበ ቃዴሽ በርኔት ዴመ። ኤርገሲስ ገረ ሀዘር አዳርት እቱመ ፉፌ ገረ አዝሞንት ደርበ። ");
INSERT INTO gaze_vpl VALUES ("NU34_5","005_34_5","NUM","34","5","5","ዳንጋን ሱንስ አዝሞንራ ገረ ለገ ግብጥት ዴብኤ ገላነ ገኤ ዹመ። ");
INSERT INTO gaze_vpl VALUES ("NU34_6","005_34_6","NUM","34","6","6","ዳንጋንኬሰን ከን ገመ ዽኣሞ ቀርቀረ ገላነ ጉድቻት። ኩንስ ገመ ዽኣቲን ዳንጋኬሰን ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU34_7","005_34_7","NUM","34","7","7","ዳሪኬሰን ከን ካባቲፍ ገላነ ጉዳዻ ሀመ ቱሉ ሁርት፣ ");
INSERT INTO gaze_vpl VALUES ("NU34_8","005_34_8","NUM","34","8","8","ቱሉ ሁሪቲ ሀመ ሌቦ ሀማቲት መለቶ ቶልቻ። ዳሪን ሱንስ ሀመ ዜዳድት ዴሜ ");
INSERT INTO gaze_vpl VALUES ("NU34_9","005_34_9","NUM","34","9","9","ሀመ ዚፍሮንት እት ፉፌ ሀዘር ኤናንረት ዹመ። ኩንስ ዳሪኬሰን ከን ካባ ተአ። ");
INSERT INTO gaze_vpl VALUES ("NU34_10","005_34_10","NUM","34","10","10","ዳሪኬሰን ከን በኣቲፍስ ሀዘር ኤናኒ ጀልቀባቲ ሀመ ሼፋማት መለቶ ቶልቻ። ");
INSERT INTO gaze_vpl VALUES ("NU34_11","005_34_11","NUM","34","11","11","ዳሪን ሱንስ ሼፋማ ጀልቀቤ ከራ በአ ኣይኒቲን ሀመ ሪብላት ገድ ቡአ፤ እት ፉፌስ ሀመ ኤዴደ ገመ በኣ ገላነ ክኔሬትት አርገሙት ዴመ። ");
INSERT INTO gaze_vpl VALUES ("NU34_12","005_34_12","NUM","34","12","12","ዳሪን ኩንስ ዮርዳኖስት ገድ ቡኤ ገላነ ሶግዳ ገኤ ዻበተ። ");
INSERT INTO gaze_vpl VALUES ("NU34_13","005_34_13","NUM","34","13","13","ሙሴን አከነ ጄዼ እስራኤሎተ አጀጄ፦ “ብየ ከነ ዻለ ጎዸዻቲ እጣዻን ቆደዻ፤ ዋቀዮ አከ ብይ ኩን ጎሰ ሰገሊፊ ወለካዻፍ ኬነሙ አጀጄረ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_14","005_34_14","NUM","34","14","14","ማቲወን ጎሰ ሩቤን፣ ከን ጎሰ ጋዲፊ ወለካን ጎሰ ምናሴ ዻለ ኦፊ ፉዸተኒሩቲ። ");
INSERT INTO gaze_vpl VALUES ("NU34_15","005_34_15","NUM","34","15","15","ጎሶትን ለማኒፊ ወለካን ጎሰ ቶኮ ዮርዳኖስ ገማ፣ ፉሌ ዬርኮቲ ገረ በአ ቢፍቱት ከራ በኣቲን ዻለሳኒ አርገተኒሩ።” ");
INSERT INTO gaze_vpl VALUES ("NU34_16","005_34_16","NUM","34","16","16","ዋቀዮ ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_17","005_34_17","NUM","34","17","17","“መቃን ነሞተ አከ ዻላት ለፈ ከነ እስኒ ቆደኒስ ኤሌኣዛር ሉብቻፊ እያሱ እልመ ኑኒት። ");
INSERT INTO gaze_vpl VALUES ("NU34_18","005_34_18","NUM","34","18","18","እስንስ አከ እሳን ለፈ ዻላ ቆደኒፍ ቶኮ ቶኮ ጎሳ ኬሳ ሆገና ቶኮ ፍለዻ። ");
INSERT INTO gaze_vpl VALUES ("NU34_19","005_34_19","NUM","34","19","19","“መቃንሳኒስ ከኔኒዸ፦ “ጎሰ ይሁዳ ኬሳ፣ ካሌብ እልመ ዬፉኔ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_20","005_34_20","NUM","34","20","20","ጎሰ ስምኦን ኬሳ፣ ሼሙኤል እልመ አሚሁድ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_21","005_34_21","NUM","34","21","21","ጎሰ ቤንያም ኬሳ፣ ኤሊዳድ እልመ ክስሎን፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_22","005_34_22","NUM","34","22","22","ጎሰ ዳን ኬሳ ሆገናን፣ ቡኪ እልመ ዮግሊ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_23","005_34_23","NUM","34","23","23","ጎሰ ምናሴ እልመ ዮሴፍ ኬሳ ሆገናን፣ ሀኒኤል እልመ ኤፎድ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_24","005_34_24","NUM","34","24","24","ጎሰ ኤፍሬም እልመ ዮሴፍ ኬሳ ሆገናን፣ ቀሙኤል እልመ ሺፍጣን፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_25","005_34_25","NUM","34","25","25","ጎሰ ዜቡሎን ኬሳ ሆገናን፣ ኤሊሳፋን እልመ ጳርናክ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_26","005_34_26","NUM","34","26","26","ጎሰ ይሳኮር ኬሳ ሆገናን፣ ጳልቲኤል እልመ አዛን፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_27","005_34_27","NUM","34","27","27","ጎሰ ኣሼር ኬሳ ሆገናን፣ አሂሁድ እልመ ሼሎሚ፤ ");
INSERT INTO gaze_vpl VALUES ("NU34_28","005_34_28","NUM","34","28","28","ጎሰ ንፍታሌም ኬሳ ሆገናን፣ ጴዳኤል እልመ አሚሁድ።” ");
INSERT INTO gaze_vpl VALUES ("NU34_29","005_34_29","NUM","34","29","29","ነሞትን ኩኔን ወረ ዋቀዮ አከ እሳን ብየ ከነኣን ኬሰት እስራኤሎታፍ ዻለ ህረኒፍ እሳን አጀጄዸ። ");
INSERT INTO gaze_vpl VALUES ("NU35_1","005_35_1","NUM","35","1","1","ዋቀዮስ ድሬወን ሞኣብረት፣ ዮርዳኖስ ብረት፣ ዬርኮ ገመት ሙሴዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("NU35_2","005_35_2","NUM","35","2","2","“እስራኤሎን ዻለ ኦፊሳኒቲ አርገቹፍ ጅረን ኬሳ መጋላወን ሌዎትን ኬሰ ጅራተን አከሳኒ ኬነን እስራኤሎተ አጀጅ። ለፈ ሆሪ እት ቦባፈተንስ ናኖ መጋላወኒት ሃኬነኒፍ። ");
INSERT INTO gaze_vpl VALUES ("NU35_3","005_35_3","NUM","35","3","3","እሳንስ መጋላወን ኬሰ ጅራተኒፊ ለፈ እት ሎንሳኒቲፊ ሆሪሳኒ ካን ሁንደ ቦባፈተን ንቀባቱ። ");
INSERT INTO gaze_vpl VALUES ("NU35_4","005_35_4","NUM","35","4","4","“ለፍት ሆሪን እት ቦበኡ ከን እስን ናኖ መጋላወኒት ሌዎታፍ ኬንተን ሱን ደላ መጋላራ ጀልቀቤ ገመ ሁንዳን ዹንዹመ ኩመ ቶኮ አች በልአተ። ");
INSERT INTO gaze_vpl VALUES ("NU35_5","005_35_5","NUM","35","5","5","መጋላ ሰነ ግዱት ሀምብሱዻን ከራ አላቲን ገመ በኣቲን ዹንዹመ ኩመ ለመ፣ ገመ ክባቲን ዹንዹመ ኩመ ለመ፣ ገመ ዽኣቲን ዹንዹመ ኩመ ለመ፣ ገመ ካባቲንሞ ዹንዹመ ኩመ ለመ ሰፈራ። እዶወን ኩኔን መጋላወን ሰናፍ እዶወን እት ሆሪ ቦባፈተን ተኡ። ");
INSERT INTO gaze_vpl VALUES ("NU35_6","005_35_6","NUM","35","6","6","“መጋላወን ጀአን እስን ሌዎታፍ ኬንተን መጋላወን እት በቀተን ከኔን ነምን ነመ አጄሴ እት በቀቱ ተኡ። መጋላወን አፉርተሚ ለመስ ከነት ደበላቲ እሳኒ ኬና። ");
INSERT INTO gaze_vpl VALUES ("NU35_7","005_35_7","NUM","35","7","7","ወሉማ ገለት መጋላወን አፉርተሚ ሰዴት ከኔን ለፈ ትከ ኦፊሳኒ ቀበን ሌዎታፍ ኬና። ");
INSERT INTO gaze_vpl VALUES ("NU35_8","005_35_8","NUM","35","8","8","መጋላወን እስን ለፈ እስራኤሎን ዻለንራ ሌዎታፍ ኬንተን፣ አኩመ ቆደ ዻለ ቶኮ ቶኮ ጎሳት ሃተኡ፤ ጎሰ ዻለ ባይኤ ቀቡራ መጋላወን ባይኤ፣ ጎሰ ዻለ ሙራሰ ቀቡራሞ መጋላወን ጥኖ ፉዻ።” ");
INSERT INTO gaze_vpl VALUES ("NU35_9","005_35_9","NUM","35","9","9","ዋቀዮስ ሙሴዻን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("NU35_10","005_35_10","NUM","35","10","10","“እስራኤሎተት ዱበዹ፤ አከነስ ጄዺን፦ ‘እስን ዮሙ ዮርዳኖስን ጬተኒ ከነኣንት ገልተንት፣ ");
INSERT INTO gaze_vpl VALUES ("NU35_11","005_35_11","NUM","35","11","11","አከ እስን መጋላወን እት በቀተን ከኔን ነምን ተሰ ነመ አጄሴ እት በቀቱ እስኒ ተአኒፍ መጋላወን ፍለዻ። ");
INSERT INTO gaze_vpl VALUES ("NU35_12","005_35_12","NUM","35","12","12","መጋላወን ኩኔንስ አከ ነምን ነመ አጄሱዻን ህመተሜ ኡቱ ሙርቲ አርገቹፍ ወልዳ ዱረት ህንዽኣትን ህንዱኔፍ እዶ እን እት ነመ ሃሎ እሰ በኡ ጀላ በቀቱ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("NU35_13","005_35_13","NUM","35","13","13","መጋላወን እስን ኬንተን ጀአን ኩኔንስ መጋላወን እት በቀተን እስኒ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("NU35_14","005_35_14","NUM","35","14","14","ዮርዳኖስ ገመናን መጋላወን ሰዲ፣ ከነኣን ኬሳሞ መጋላወን ሰዲ፣ መጋላወን እት በቀተን ጎዻ ኬና። ");
INSERT INTO gaze_vpl VALUES ("NU35_15","005_35_15","NUM","35","15","15","መጋላወን ጀአን ኩኔን አከ ነምን ተሰ ነመ አጄሴ ከምዩ እት በቀቱፍ እስራኤሎታፍ፣ አለጎታፊ ሰበ እሳን ግዱ ጅራቱፍ እዶ እት በቀተን ተኡ። ");
INSERT INTO gaze_vpl VALUES ("NU35_16","005_35_16","NUM","35","16","16","“ ‘ነምን ቶኮ ዮ ሜሻ ስቢላቲን ነመ ዸኤ ነምች ሱን ዱኤ፣ እን አጄሴ ሱን ነመ ጉማት፤ ነምች አጄሴ ሱን አጄፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("NU35_17","005_35_17","NUM","35","17","17","ዮካን ነምን ቶኮ ዮ ዸጋ ነመ አጄሱ ደንደኡ ሀርከት ቀበቴ ነመ ዸኤ አጄሴ፣ እን ነመ ጉማት፤ ነምች ነመ አጄሴ ሱን አጄፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("NU35_18","005_35_18","NUM","35","18","18","ዮካን ነምን ቶኮ ዮ ሜሻ ሙካ ከን ነመ አጄሱ ደንደኡ ሀርከት ቀበቴ ነመ ዸኤ ነምች ሱን ዱኤ፣ እን አጄሴ ሱን ነመ ጉማት፤ ነምች ነመ አጄሴ ሱን አጄፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("NU35_19","005_35_19","NUM","35","19","19","ነምች ሃሎ ዺጋ በኡ ሱን ነምቸ ነመ አጄሴ ሰነ ሃአጄሱ፤ እን ዮሙ አርገቱት እሰ ሃአጄሱ። ");
INSERT INTO gaze_vpl VALUES ("NU35_20","005_35_20","NUM","35","20","20","ነምን ቶኮ ዮ ጅባን ነመ ደርበቴ ለፋን ዸኤ ዮካን ቤካ ዋ እት ደርበቹዻን እሰ አጄሴ፣ ");
INSERT INTO gaze_vpl VALUES ("NU35_21","005_35_21","NUM","35","21","21","ዮካን ዮ ዲኑማዻን ከኤ ሀርካን እሰ ዸኤ ነምች ሱን ዱኤ፣ እን ነመ አጄሴ ሱን አጄፈሙ ቀበ፤ እን ነመ ጉማት። ነምች ሃሎ ዺጋ በኡ ሱን ነምቸ ነመ አጄሴ ሰነ ዬሮ አርገቱት እሰ ሃአጄሱ። ");
INSERT INTO gaze_vpl VALUES ("NU35_22","005_35_22","NUM","35","22","22","“ ‘ገሩ እን ዮ ኡቱ ዲኑማ ህንቀባትን ተሰ ነመ ደርበቴ ለፋን ዸኤ ዮካን ኡቱ ህንቤክን ዋን ቶኮ እሰት ደርበቴ ");
INSERT INTO gaze_vpl VALUES ("NU35_23","005_35_23","NUM","35","23","23","ዮካን ኡቱ እሰ ህንአርግን ዸጋ እሰ አጄሱ ደንደኡ እት ገድ ዺሴ ነምች ሱን ዱኤ፣ እን ዋን ዲነሳ ህንተእኒፊ እሰ ሚዹፍ ህንያድኒፍ ");
INSERT INTO gaze_vpl VALUES ("NU35_24","005_35_24","NUM","35","24","24","ወልዳን ሱን አኩመ ሴረ ከኔኒት ነምቸ ነመ አጄሴ ሰናፊ እሰ ሃሎ ዺጋ በኡ ሰነ ግዱት ሙርቲ ሃኬኑ። ");
INSERT INTO gaze_vpl VALUES ("NU35_25","005_35_25","NUM","35","25","25","ወልዳን ሱን ነምቸ ነመ አጄሱዻን ህመተሜ ሰነ ሀርከ ነምቸ ሃሎ ዺጋ በኡ ሰና ጀላ ባሴ መጋላ እን እት በቀቴ ቱሬ ሰነት ዴብሴ እሰ ሃኤርጉ። እንስ ሀመ ሉብን ኦል ኣናን ዘይቲ ቁልቁሉዻን ድበሜ ሱን ዱኡት አቹመ ሃቱሩ። ");
INSERT INTO gaze_vpl VALUES ("NU35_26","005_35_26","NUM","35","26","26","“ ‘ተኡስ ዮ ነምች ነመ አጄሴ ሱን ዳሪ መጋላ እት በቀቴ ሰና ኬሳ በኤ ");
INSERT INTO gaze_vpl VALUES ("NU35_27","005_35_27","NUM","35","27","27","ነምች ሃሎ ዺጋ በኡ ሱን መጋላ ሰናን አለት እሰ አርገቴ፣ ነምች ሃሎ ዺጋ በኡ ሱን ነምቸ ህመተሜ ሰነ አጄሱ ደንደአ፤ የከ አጄቻ ሰናትስ ህንጋፈተሙ። ");
INSERT INTO gaze_vpl VALUES ("NU35_28","005_35_28","NUM","35","28","28","ነምች ነመ አጄሴ ሱን ሀመ ሉብን ኦል ኣናን ሱን ዱኡት መጋላ እት በቀቴ ኬሰ ቱሩ ቀበ፤ እን ኤርገ ሉብች ኦል ኣናን ዱኤ ቦዴ ገረ ቀቤኘሳት ዴብኡ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("NU35_29","005_35_29","NUM","35","29","29","“ ‘እሳን ኩኔንስ ዸሎተ ዹፉ ኬሰት ለፈ እስን ጅራተን ከምትዩ ሴራፊ ቀጄልፈመ እስኒፍ ሃተአን። ");
INSERT INTO gaze_vpl VALUES ("NU35_30","005_35_30","NUM","35","30","30","“ ‘ነምን ከምዩ ዮ ነመ አጄሴ ነምች ሱን ረጋ ዹጋ ባቶትን ኬነኒን አጄፈመ። ተኡስ ነምን ከምዩ ዹገ በኡምሰ ነመ ቶኮ ቆፋን ህንአጄፈምን። ");
INSERT INTO gaze_vpl VALUES ("NU35_31","005_35_31","NUM","35","31","31","“ ‘ነምቸ ነመ አጄሴ ዱት እሳፍ መሉ ቶኮራ ጉማ ሉቡ ህንፉዸትና። እን አጄፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("NU35_32","005_35_32","NUM","35","32","32","“ ‘አከ እን ኡቱ ሉብች ኦል ኣናን ህንዱእን ዱረ ብየ ኦፊሳት ዴብኤ አች ጅራቱ ኤየሙፍ ጄተኒ ነመ ገረ መጋላ እት በቀተኒት በቀቴ ከሚፍዩ ጉማ ህንፉዸትና። ");
INSERT INTO gaze_vpl VALUES ("NU35_33","005_35_33","NUM","35","33","33","“ ‘ሰበቢ ዸንገላፈሙን ዺጋ ብየ ጡሬሱፍ፣ እስን ብየ ኬሰ ጅራተን ሰነ ህንጡሬስና፤ ዺጉመ ነምቸ ዺገ ዸንገላሴ ሰናቲን መሌስ ብየ ዺግን እት ዸንገላፈሜ ሰናፍ አራር ህንቡፈሙ። ");
INSERT INTO gaze_vpl VALUES ("NU35_34","005_35_34","NUM","35","34","34","ብየ እስን ኬሰ ጅርተን እዶ አን ጅራዹ ሰነ ህንጡሬስና። አን ዋቀዮ እስራኤሎተ ግዱ ነንጅራዻቲ።’ ” ");
INSERT INTO gaze_vpl VALUES ("NU36_1","005_36_1","NUM","36","1","1","አቦቲን ማቲ እልማን ግልኣድ እልመ ማኪር፣ እልመ ምናሴ ከኔን ማቲወን እልማን ዮሴፍ ኬሳ ዹፈን ሱን ፉለ ሙሴቲፊ ፉለ ሆገንቶተ አቦቲ ማቲወን ሰበ እስራኤል ዱረት ዽኣተኒ ዱበተን፤ ");
INSERT INTO gaze_vpl VALUES ("NU36_2","005_36_2","NUM","36","2","2","አከነስ ጄዸን፤ “አከ አት ብየቲ ዻለ ጎቴ እጣዻን ሰበ እስራኤሊፍ ኬንቱፍ ዋቀዮ ጎፍታኮ አጀጄረ፤ አከሱመስ አከ አት ዻለ ኦቦሌስኬኘ ዜሎፌሃድ እንተለንሳቲፍ ኬንቱ እን ስ አጀጄረ። ");
INSERT INTO gaze_vpl VALUES ("NU36_3","005_36_3","NUM","36","3","3","ገሩ ዮ እሳን እልማን ጎሶተ ሰበ እስራኤል ካንት ሄሩመን ዻልሳኒ ዻለ አቦቲኬኛ ኬሳ ፉዸሜ ዻለ ጎሰ እሳን እት ሄሩመኒት ደበለመ። ዮስ ዻለ እጣዻን ኑ ቆደሜራ ገሪንሳ ንፉዸመ። ");
INSERT INTO gaze_vpl VALUES ("NU36_4","005_36_4","NUM","36","4","4","ዮሙ ወጋን እዮቤልዩ ከን ሰበ እስራኤል ዹፉት ዻልሳኒ ሱን ዻለ ጎሰ እሳን እት ሄሩመኒት ደበለመ፤ ዻልሳኒስ ዻለ ጎሰ አቦቲኬኛራ ፉዸተመ።” ");
INSERT INTO gaze_vpl VALUES ("NU36_5","005_36_5","NUM","36","5","5","ከነረት ሙሴን አኩመ ዋቀዮ ዱበቴ ሰነ አከነ ጄዼ ሰበ እስራኤል አጀጄ፦ “ወን ጎስት እልማን ዮሴፍ ጄዹ ስሪዸ። ");
INSERT INTO gaze_vpl VALUES ("NU36_6","005_36_6","NUM","36","6","6","ወን ዋቀዮ ዋኤ እንተለን ዜሎፌሃድ አጀጄ ከናዸ፦ እሳን ጎሰ አባሳኒ ቆፈ ኬሳ ሃተኡ መሌ ነመ ጃለተንት ሃሄሩመን። ");
INSERT INTO gaze_vpl VALUES ("NU36_7","005_36_7","NUM","36","7","7","ሰበቢ ቶኮን ቶኮን እልማን እስራኤል ዻለ ጎሰ አባሳራ አርገቱ ጀቤሴ ቀበቱፍ፣ ዻል እልማን እስራኤል ጎሰ ቶኮራ ጎሰ ካንት ህንደርብን። ");
INSERT INTO gaze_vpl VALUES ("NU36_8","005_36_8","NUM","36","8","8","አከ ቶኮን ቶኮን እልማን እስራኤል ዻለ አቦቲሳ አርገቱፍ፣ ጎሰ እልማን እስራኤል ኬሳ እንተል ዻለ አርገቱ ከምዩ ጎሰ አባሼ ኬሳ ነመ ቶኮት ሄሩሙ ቀብድ። ");
INSERT INTO gaze_vpl VALUES ("NU36_9","005_36_9","NUM","36","9","9","ሰበቢ ቶኮን ቶኮን ጎሰ እልማን እስራኤል ዻለ ኦፊሳ ጀቤሴ ቀበቱፍ፣ ዻል ቶኮዩ ጎሰ ቶኮራ ጎሰ ካንት ህንደርብን።” ");
INSERT INTO gaze_vpl VALUES ("NU36_10","005_36_10","NUM","36","10","10","እንተለን ዜሎፌሃድ አኩመ ዋቀዮ ሙሴ አጀጄ ሰነ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("NU36_11","005_36_11","NUM","36","11","11","እንተለን ዜሎፌሃድ መህላን፣ ቲርዛን፣ ሆግላን፣ ሚልካፊ ኖህ እልማን ኦቦሎተ አባሳኒት ሄሩመን። ");
INSERT INTO gaze_vpl VALUES ("NU36_12","005_36_12","NUM","36","12","12","እሳንስ ማቲወን እልማን ምናሴ እልመ ዮሴፍ ኬሰት ዋን ሄሩመኒፍ ዻልሳኒ ጎሰ ማቲ አባሳኒ ሀርከት ሀፌ። ");
INSERT INTO gaze_vpl VALUES ("NU36_13","005_36_13","NUM","36","13","13","አጀጀወኒፊ ሙርቲወን ዋቀዮ ድሬወን ሞኣብረት፣ ዮርዳኖስ ብረት፣ ዬርኮ ገመት ከራ ሙሴቲን እልማን እስራኤሊፍ ኬኔ ከኔኒዸ። ");
INSERT INTO gaze_vpl VALUES ("DT1_1","006_1_1","DEU","1","1","1","ዱቢን ኩን ዱቢ ሙሴን ዬሮ እሳን ገሞጂ ገመ በአ ዮርዳኖስት፣ አረባ ፉሌ ሱፍት አርገሙ ሰነ ኬሰ፣ ጳራኒፊ ቶፌል፣ ላባን፣ ሀጤሮቲፊ ዲዛሃብ ግዱ ቱረንት እስራኤሎተ ሁንደት ዱበቴዸ። ");
INSERT INTO gaze_vpl VALUES ("DT1_2","006_1_2","DEU","1","2","2","ኮሬቢ ከራ ቱሉ ሴኢሪን ቃዴሽ በርኔ ገኡፍ ጉዮተ ኩዸ ቶኮ ፉዸተ። ");
INSERT INTO gaze_vpl VALUES ("DT1_3","006_1_3","DEU","1","3","3","ሙሴንስ ወጋ አፉርተመፋ ኬሰ ጉያ ቶኮፋ ጅአ ኩዸ ቶኮፋት ዋን ዋቀዮ ዋኤሳኒ እሰ አጀጄ ሁንደ እስራኤሎተት ህሜ። ");
INSERT INTO gaze_vpl VALUES ("DT1_4","006_1_4","DEU","1","4","4","ኩንስ ኤርገ እን ስሆን ሞቲ አሞሮታ ከን ሄሽቦን ቡልቻ ቱሬ ሞአቴ ኦግ ሞቲ ባሻን ከን አሽታሮት ቡልቻ ቱሬሌ ኤድሬዪት ሞአቴ ቦዴዸ። ");
INSERT INTO gaze_vpl VALUES ("DT1_5","006_1_5","DEU","1","5","5","በአ ዮርዳኖስት ብየ ሞኣብ ኬሰት ሙሴን አከነ ጄዼ ሴረ ከነ እብሱ ጀልቀቤ፦ ");
INSERT INTO gaze_vpl VALUES ("DT1_6","006_1_6","DEU","1","6","6","ዋቀዮ ዋቅንኬኘ ኮሬብት አከነ ኑን ጄዼ፤ “እስን ቱሉ ከነ ብረ ዬሮ ዼራ ቱርተኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("DT1_7","006_1_7","DEU","1","7","7","ቁበተ ቡቅሳ ከኣቲ ገረ ብየ ጋራ አሞሮታት ዴምሰኬሰን እት ፉፋ፤ ኤርገሲስ ሰቦተ ናኖ አረባት አርገመን ሁንደ ኬሰ፣ ብየ ቱሉወኒ ኬሰ፣ ብዮተ ገመ ዽኣቲን ጭነ ቱሉወኒት አርገመን ኬሰ፣ ኔጌቢፊ ቀርቀረ ገላና፣ ብየ ከነኣኖታቲፊ ልባኖን ኬሰ ሀመ ለገ ኤፍራጢስ ጉድቻት አርገመን ኬሰ ዴማ። ");
INSERT INTO gaze_vpl VALUES ("DT1_8","006_1_8","DEU","1","8","8","ኩኖ፣ አን ብየ ከነ እስኒፍ ኬኔረ። ብየ ዋቀዮ አቦቲኬሰኒፍ ጄቹንስ አብረሃሚፍ፣ ይስሃቂፍ፣ ያቆቢፊ ሰኚሳኒ ወረ እሳኒን ዱባቲፍ ኬኑፍ ከከቴ ሰነት ገላቲ ዻላ።” ");
INSERT INTO gaze_vpl VALUES ("DT1_9","006_1_9","DEU","1","9","9","አን ዬሮ ሰነት አከነን እስኒን ጄዼ፤ “አን ኮጳኮ እስን ባቹ ህንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("DT1_10","006_1_10","DEU","1","10","10","ዋቀዮ ዋቅንኬሰን እስን ባይእሴረ፤ ኩኖ፣ እስን ሀርአ አኩመ ኡርጂወን ሰሚ ባይአተኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("DT1_11","006_1_11","DEU","1","11","11","ዋቀዮ ዋቅን አቦቲኬሰኒ ዬሮ ኩመ እስን ሃባይእሱ፤ አኩመ አብዲ ኬኔ ሰነትስ እስን ሃኤብሱ! ");
INSERT INTO gaze_vpl VALUES ("DT1_12","006_1_12","DEU","1","12","12","አን ገሩ አከምት ኮጳኮ ረክነኬሰን፣ በኣኬሰኒፊ ወል ሞርሚኬሰን ባቹ ደንደኣ? ");
INSERT INTO gaze_vpl VALUES ("DT1_13","006_1_13","DEU","1","13","13","ቶኮ ቶኮ ጎሶተኬሰኒ ኬሳ ነሞተ ኦጌዪ፣ ሁበቶታፊ ከበጀሞ ፍለዻ፤ አንስ እስንረት ቡልችቶተ እሳን ነንታስሰ።” ");
INSERT INTO gaze_vpl VALUES ("DT1_14","006_1_14","DEU","1","14","14","እስንስ፣ “ወን አት ዽኤስቴ ጋሪዸ” ጄተኒ ናፍ ዴብፍተን። ");
INSERT INTO gaze_vpl VALUES ("DT1_15","006_1_15","DEU","1","15","15","አን ሀንገፎተ ጎሶተኬሰኒ ጄቹንስ ነሞተ ኦጌዪፊ ከበጀሞ ፉዸዼ አከ እሳን አጀጁወን ኩማ፣ አጀጁወን ዽባ፣ አጀጁወን ሸንተማቲፊ አጀጁወን ኩዸኒ ተአኒ እስንረት ኣንጎ ቀባተን ነንሙዴ። ");
INSERT INTO gaze_vpl VALUES ("DT1_16","006_1_16","DEU","1","16","16","አንስ ዬሮ ሰነት አከነ ጄዼ አቦቲ ሙርቲኬሰን ነንአጀጄ፤ “ሞርሚ ኦቦሎተኬሰን ግዱት ከኡ ዸገኣ፤ ዮ ወል ሞርሚን ከኡ ሱን እስራኤሎተ ኦቦሎተ ግዱት ዮካን ነመ እስራኤል ቶኮፊ አለጋ ቶኮ ግዱት ተኤ ሙርቲ ቀጄላ ኬና። ");
INSERT INTO gaze_vpl VALUES ("DT1_17","006_1_17","DEU","1","17","17","ሙርቲ ኬኑ ኬሰት ነመ ወል ህንጫልችስና፤ ጉዳስ ጥናስ ወል ቅጤ ዸገኣ። ሰበቢ ሙርቲን ከን ዋቃ ተኤፍ ኤኙንዩ ህንሶዳትና። ዋን ሁምነኬሰኒ ኦል ተኤ ነት ፍዳ፤ አንስ ነንእላላ።” ");
INSERT INTO gaze_vpl VALUES ("DT1_18","006_1_18","DEU","1","18","18","አን ዬሮ ሰነት ዋን እስን ጎቹ ቀብደን ሁንደ እስን አጀጄረ። ");
INSERT INTO gaze_vpl VALUES ("DT1_19","006_1_19","DEU","1","19","19","ኑስ ኤርገሲ አኩመ ዋቀዮ ዋቅንኬኘ ኑ አጀጄት ኮሬቢ ካኔ ገሞጂ ጉዳፊ ሶዳችሳ እስን አርግተን ሰነ ኬሰ ደበሬ ገረ ብየ ጋራ አሞሮታ ዸቅኔ፤ አከሲንስ ቃዴሽ በርኔ ጌኜ። ");
INSERT INTO gaze_vpl VALUES ("DT1_20","006_1_20","DEU","1","20","20","አንስ አከነ እስኒን ጄዼ፤ “እስን ብየ ጋራ አሞሮታ ከን ዋቀዮ ዋቅንኬኘ ኑ ኬኑ ጌሰኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("DT1_21","006_1_21","DEU","1","21","21","ኩኖ፣ ዋቀዮ ዋቅንኬሰን ብየቲ እስኒፍ ኬኔረ። ዸቃቲ አኩመ ዋቀዮ ዋቅን አቦቲኬሰኒ እስንት ህሜ ሰነት እሼ ዻላ፤ ህንሶዳትና፤ አብዲስ ህንኩተትና።” ");
INSERT INTO gaze_vpl VALUES ("DT1_22","006_1_22","DEU","1","22","22","ኤርገሲስ ሁንድኬሰን ነ ብረ ዹፍተኒ፣ “አከ እሳን ብየቲ ኑ በሳሰኒፍ ዱራን ዱርስኔ ነሞተ ኤርገትነ፤ እሳንስ ዋኤ ከራ አች ኑ ጌሱቲፊ መጋላወን ኑ እት ዹፍኑ ኦዱ ኑ ፍዱ” ጄተን። ");
INSERT INTO gaze_vpl VALUES ("DT1_23","006_1_23","DEU","1","23","23","ያድን ሱንስ ጋሪ ነት ፈካቴ፤ አን ኩዸ ለማንኬሰን ጄቹንስ ቶኮ ቶኮ ጎሳ ኬሳ ነመ ቶኮ ነንፍለዼ። ");
INSERT INTO gaze_vpl VALUES ("DT1_24","006_1_24","DEU","1","24","24","እሳንስ ከአኒ ብየ ጋራት ኦል በአኒ ሱሉለ ኤሽኮል ገአኒ ብየቲ በሳሰን። ");
INSERT INTO gaze_vpl VALUES ("DT1_25","006_1_25","DEU","1","25","25","እጀ ብየቲ ኬሳስ ዋ ፍደኒ ዹፈኒ፣ “ብይ ዋቀዮ ዋቅንኬኘ ኑፍ ኬኑ ኩን ጋሪዸ” ጄዸኒ ኑት ህመን። ");
INSERT INTO gaze_vpl VALUES ("DT1_26","006_1_26","DEU","1","26","26","እስን ገሩ ዸቁ ድደኒ አጀጀ ዋቀዮ ዋቀኬሰኒት ፍንጭልተን። ");
INSERT INTO gaze_vpl VALUES ("DT1_27","006_1_27","DEU","1","27","27","ዱንካነኬሰን ኬሰትስ አከነ ጄተኒ ጉንጉምተን፤ “ዋቀዮ ኑ ጅበ፤ ከናፉ ብየ ግብጢቲ ኑ ባሱን እሳቱ አከ እሳን ኑ በሌሰኒፍ ሀርከ አሞሮታት ደበርሴ ኑ ኬኑፍ። ");
INSERT INTO gaze_vpl VALUES ("DT1_28","006_1_28","DEU","1","28","28","ኤጋ ኑ ኤሰ ዸቁ ደንዴኘ? ኦቦሎትንኬኘ፣ ‘ጀር ኑ ጫላ ጀጀቦፊ ሆጃንሳኒ ዼዼራዸ፤ መጋላወንሳኒስ ጉርጉዳፊ ደላወን ሰሚ ገአኒን መርፈመኒሩ፤ ከነ ብረትሞ እልማን አናቅ አርግኔረ’ ጄዸኒ ኑ ሶዳችሰን።” ");
INSERT INTO gaze_vpl VALUES ("DT1_29","006_1_29","DEU","1","29","29","አንስ አከነን እስኒን ጄዼ፤ “ህንርፈትና፤ እሳን ህንሶዳትና። ");
INSERT INTO gaze_vpl VALUES ("DT1_30","006_1_30","DEU","1","30","30","ዋቀዮ ዋቅንኬሰን ከን ፉለኬሰን ዱረ ዴሙ ኩን አኩመ እጀኬሰን ዱረት ብየ ግብጥ ኬሰት እስኒ ጎዼ ሰነ እስኒፍ ንሎለ፤ ");
INSERT INTO gaze_vpl VALUES ("DT1_31","006_1_31","DEU","1","31","31","ገሞጂ ኬሰትስ አከሱመ። ሀመ አስ ጌሰንትስ ከራ ዴምተን ሁንደት አከምት አከ ዋቀዮ ዋቅንኬሰን አኩመ አባን እልመሳ ባቱት እስን ባቴ አርግተኒርቱ።” ");
INSERT INTO gaze_vpl VALUES ("DT1_32","006_1_32","DEU","1","32","32","ተኡስ እስን ዋቀዮ ዋቀኬሰን ");
INSERT INTO gaze_vpl VALUES ("DT1_33","006_1_33","DEU","1","33","33","እሰ እዶ እስን ቁበተን በርባዱፊ ዳንዲ እስን ዴሙ ቀብደን እስን አርግሲሱዻፍ ጄዼ ሀልከን እብዳን፣ ጉያሞ ዱሜሳን እስን ዱረ ዴሜ እስን ቀጄልቻ ቱሬ ህንአመኔ። ");
INSERT INTO gaze_vpl VALUES ("DT1_34","006_1_34","DEU","1","34","34","ዋቀዮስ ዮሙ ዋን እስን ጄተን ዸገኤት ዼከሜ አከነ ጄዼ ከከቴ፦ ");
INSERT INTO gaze_vpl VALUES ("DT1_35","006_1_35","DEU","1","35","35","“ዸሎተ ሀማ ከነ ኬሳ ነምን ቶኮዩ ብየ ጋሪ አን አከ አቦቲኬሰኒፍ ኬኑ ከኩ ገሌ ሰነ ህንአርጉ፤ ");
INSERT INTO gaze_vpl VALUES ("DT1_36","006_1_36","DEU","1","36","36","ካሌብ እልመ ዬፉኔ ሰነ መሌ ከን አርጉ ህንጅሩ። እን ብየ ሰነ ንአርገ፤ ሰበቢ እን ገራ ጉቱዻን ዋቀዮ ዱካ ቡኤፍ አን ለፈ እን ሚለሳረ ዻበቴ ሰነሳፊ ሰኚሳቲፍ ነንኬነ።” ");
INSERT INTO gaze_vpl VALUES ("DT1_37","006_1_37","DEU","1","37","37","ሰበቢኬሰኒፍ ዋቀዮ ነትሌ ዼከሜ አከነ ጄዼ፤ “አትዩ እት ህንገልቱ። ");
INSERT INTO gaze_vpl VALUES ("DT1_38","006_1_38","DEU","1","38","38","ገርጋራንኬ እያሱን እልም ኑን ገሩ እት ገለ። እን ዋን እስራኤሎተ ብየቲ ዻልችሱፍ እሰ ጀጀቤስ። ");
INSERT INTO gaze_vpl VALUES ("DT1_39","006_1_39","DEU","1","39","39","ዳእመን እስን ንቦጅአመን ጄተን፣ እልማንኬሰን ከኔን ዋን ቶላፊ ሀማ ገርገር ባሰኒ ህንቤክኔ ብየ ሰነት ንገሉ። አን እሳኒፈን ኬነ፤ እሳንስ ንዻሉ። ");
INSERT INTO gaze_vpl VALUES ("DT1_40","006_1_40","DEU","1","40","40","እስን ገሩ ዱበት ዴብኣቲ ዳንዲ ገረ ገላነ ዲማት ጌሱ ቀበዻቲ ገሞጂት ቀጄላ።” ");
INSERT INTO gaze_vpl VALUES ("DT1_41","006_1_41","DEU","1","41","41","እስንስ፣ “ኑ ዋቀዮት ጩቡ ሆጄትኔረ። ዸቅኔ አኩመ ዋቀዮ ዋቅንኬኘ ኑ አጀጄት ሎለ” ጄተኒ ዴብፍተን። ብየ ጋራ ዸቁን ዋን ሰልጳ እስንት ፈካቴ አከሲን ቶኮን ቶኮንኬሰን ምአ ሎላ ቀበተኒ ካተን። ");
INSERT INTO gaze_vpl VALUES ("DT1_42","006_1_42","DEU","1","42","42","ዋቀዮ ገሩ፣ “ ‘ዋን አን እስን ወጅን ህንጅሬፍ ሎላፍ ህንበእና። እስን ዲኖተኬሰኒን ንሞአተምቱ’ ጄዺ እሳንት ህም” ናን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("DT1_43","006_1_43","DEU","1","43","43","አንስ አከሱመን እስንት ህሜ፤ እስን ገሩ ነ ህንዸጌኜ። አጀጀ ዋቀዮት ፍንጭልተኒ ኦፍ ቱሉማኬሰኒን ብየ ጋራት ዱልተን። ");
INSERT INTO gaze_vpl VALUES ("DT1_44","006_1_44","DEU","1","44","44","አሞሮትን ጋረንረ ጅራተን እስንት ዹፈን፤ እሳንስ አኩመ ቱተ ከኒሳት በአኒ እስን ጉግሰን፤ ሴኢሪ ሀመ ሆርማት እስን ዸአን። ");
INSERT INTO gaze_vpl VALUES ("DT1_45","006_1_45","DEU","1","45","45","እስን ዴብተኒ ዹፍተኒ ፉለ ዋቀዮ ዱረት ቦሰን፤ እን ገሩ ቦእቸኬሰን ህንዸጌኜ፤ ጉረሳስ እስኒፍ ህንኬንኔ። ");
INSERT INTO gaze_vpl VALUES ("DT1_46","006_1_46","DEU","1","46","46","አከ ዬሮ እስን አች ጅራተኒት፣ ጉዮትን እስን ቃዴሽ ኬሰ ጅራተን ባይኤዸ። ");
INSERT INTO gaze_vpl VALUES ("DT2_1","006_2_1","DEU","2","1","1","ኤርገሲ አኩመ ዋቀዮ ነት ህሜት፣ ዱበት ዴብኔ ከራ ገላነ ዲማቲን ገረ ገሞጂት ቀጄሌ፤ ዬሮ ዼራዻፍስ ናኖ ብየ ጋራ ሴኢር ኬሰ ጆሬ። ");
INSERT INTO gaze_vpl VALUES ("DT2_2","006_2_2","DEU","2","2","2","ዋቀዮስ አከነ ናን ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("DT2_3","006_2_3","DEU","2","3","3","“ብየ ጋራ ከነ ናነኡን እስን ገአ፤ ገረ ካባት ገረገላ። ");
INSERT INTO gaze_vpl VALUES ("DT2_4","006_2_4","DEU","2","4","4","ሰበ ከነ አከነ ጄዺ አጀጅ፦ ‘እስን ብየ ኦቦሎተኬሰን ሰኚወን ኤሳዉ ከኔን ሴኢር ኬሰ ጅራተኒ ኬሰ ደርብቱ። እሳን እስን ሶዳቱ፤ እስን ገሩ ጀቤሳ ኦፍ ኤገዻ። ");
INSERT INTO gaze_vpl VALUES ("DT2_5","006_2_5","DEU","2","5","5","ሎላፍ እሳን ህንከካስና፤ አን ለፈሳኒራ እዶ እስን ሚለኬሰን እረ ዻበተንሌ እስኒፍ ህንኬኑቲ። አን ብየ ጋራ ሴኢር ዻለ ጎዼ ኤሳዉፍ ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("DT2_6","006_2_6","DEU","2","6","6","ኛተ አቺ ኛተኒፊ ብሻን ዹግደኒፍ ማለቀ ባፍቱፍ።’ ” ");
INSERT INTO gaze_vpl VALUES ("DT2_7","006_2_7","DEU","2","7","7","ዋቀዮ ዋቅንኬሰን ዋን እስን ሆጄተን ሁንዳን እስን ኤብሴረ። እን ዴምሰ ዼራ እስን ገሞጂ በልኣ ከነ ኬሰ ዴምተንረት እስን ኤጌረ። ዋቀዮ ዋቅንኬሰን ወጎተ አፉርተመን ከኔን እስን ወጅን ቱሬ፤ እስንስ ዋን ቶኮሌ ህንዸብኔ። ");
INSERT INTO gaze_vpl VALUES ("DT2_8","006_2_8","DEU","2","8","8","ኦቦሎተኬኘ እልማን ኤሳዉ ወረ ሴኢር ኬሰ ጅራተን ብረ ደበሬ ዴምኔ። ኑስ ዳንዲ አረባ ከን ኤላቲፊ ኤዝዮን ጌቤሪ ዹፉራ ገረገሌ ከራ ዳንዲ ገሞጂ ሞኣብ ዴምኔ። ");
INSERT INTO gaze_vpl VALUES ("DT2_9","006_2_9","DEU","2","9","9","ኤርገሲስ ዋቀዮ አከነ ናን ጄዼ፤ “ዋን አን ለፈ ሞኣብራ እስኒፍ ህንኬንኔፍ አከሱማን እሳን ህንረክስና፤ ወራናፍስ እሳን ህንከካስና። አን ኣርን ዻለ ጎዼ ሰኚ ሎጢፍ ኬኔራቲ።” ");
INSERT INTO gaze_vpl VALUES ("DT2_10","006_2_10","DEU","2","10","10","ኤሚሞን አች ጅራቻ ቱረን፤ እሳንስ ነሞተ ጀጀቦፊ ባይኤዸ፤ አኩመ አናቆታስ ዼዼሮ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("DT2_11","006_2_11","DEU","2","11","11","እሳን ኩኔንስ አኩመ አናቆታ፣ ሬፋይሞተ ጄዸመኒ ሄደሙ ቱረን፤ ሞኣቦን ገሩ ኤሚሞተ ጄዹን። ");
INSERT INTO gaze_vpl VALUES ("DT2_12","006_2_12","DEU","2","12","12","ሁሮን ኩኔን ሴኢር ኬሰ ጅራቻ ቱረን፤ እልማን ኤሳዉ ገሩ አርአኒ አቺ እሳን ባሰን። እሳንስ አኩመ እስራኤሎን ብየ ዋቀዮ ዻለ እሳኒፍ ኬኔ ሰነ ኬሰት ጎዸን ሰነ ሆሮተ አቺ በሌሰኒ ኦፊሳኒቲ ብየ ጀራ ኬሰ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("DT2_13","006_2_13","DEU","2","13","13","ዋቀዮ፣ “አሙመ ከኣቲ ለገ ዜሬድ ጬኣ” ኑን ጄዼ። ኑ ለገ ሰነ ጬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT2_14","006_2_14","DEU","2","14","14","ዬሮ ኑ ቃዴሽ በርኔ ካኔ ጀልቀቤ ሀመ ለገ ዜሬድ ጬኑት ወጋ ሶዶሚ ሰዴት ፉዸቴ። አኩመ ዋቀዮ እሳንት ከከቴት ዸሎትን ዺረ ወራና ሁንድ ዬሮ ሰነት ቁበተ ኬሳ ዹሜ። ");
INSERT INTO gaze_vpl VALUES ("DT2_15","006_2_15","DEU","2","15","15","ሀርክ ዋቀዮስ ቁበተ ኬሳ እሳን በሌሱዻፍ እሳንረ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT2_16","006_2_16","DEU","2","16","16","ዬሮ ሎልቶትን ሁንድ ሰበ ኬሳ ዹመንት፣ ");
INSERT INTO gaze_vpl VALUES ("DT2_17","006_2_17","DEU","2","17","17","ዋቀዮ አከነ ናን ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("DT2_18","006_2_18","DEU","2","18","18","“አት ሀርአ ዳሪ ሞኣብ፣ ኣር ኬሰ ደበርተ። ");
INSERT INTO gaze_vpl VALUES ("DT2_19","006_2_19","DEU","2","19","19","ዮሙ አሞኖተት ዹፍተንት አከሱማን እሳን ህንረክስና ዮካን ወራናፍ እሳን ህንከካስና፤ አን ብየሳኒ ኬሳ ቶኮሌ ዻለ ጎዼ እስኒፍ ህንኬኑቲ። አን ብየሳኒ ሰኚ ሎጢፍ ሀንዹራ ጎዼ ኬኔረ።” ");
INSERT INTO gaze_vpl VALUES ("DT2_20","006_2_20","DEU","2","20","20","ኩንስ ብየ ሬፋይሞተ አች ጅራቻ ቱረኒት ጄዸሜ ሄደመ፤ አሞኖትን ገሩ ዘምዙሞተ ጄዸኒ እሳን ዋሙ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT2_21","006_2_21","DEU","2","21","21","እሳንስ ነሞተ ጀጀቦፊ ባይኤዸ፤ አኩመ አናቆታ ዼዼሮ ቱረን። ዋቀዮስ ፉለ አሞኖተ አቺ እሳን ባሰኒ እዶሳኒ ቁበተን ሰና ዱራ እሳን በርበዴሴ። ");
INSERT INTO gaze_vpl VALUES ("DT2_22","006_2_22","DEU","2","22","22","ዋቀዮስ ዮሙ ሆሮተ ፉለሳኒ ዱራ በሌሴት እልማን ኤሳዉ ከኔን ሴኢር ኬሰ ጅራቻ ቱረንስ አከሱመ ጎዼ። እሳንስ ጀረ አቺ ባሰኒ ሀመ ሀርኣት ብየሳኒ ኬሰ ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("DT2_23","006_2_23","DEU","2","23","23","አዎተ ገንዶተ ሀመ ጋዛት ጅረን ኬሰ ጅራተንሞ ከፍቶሮትን ከፍቶሪ በአኒ ዹፈን ሱን በሌሰኒ እዶሳኒ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("DT2_24","006_2_24","DEU","2","24","24","“ከኣቲ ለገ አርኖን ጬኣ፤ አን ኩኖ፣ ስሆን አሞርቸ ሞቲ ሄሽቦኒቲፊ ብየሳሌ ደበርሴ ሀርከኬሰንት እስኒ ኬኔራቲ። ወራነ እት በናቲ ብየ ሰነ ቀበቹ ጀልቀባ። ");
INSERT INTO gaze_vpl VALUES ("DT2_25","006_2_25","DEU","2","25","25","አንስ ናስሱፊ ሶዳችሱኬሰን ሰቦተ ሰሚ ገድ ጅረን ሁንደት ቡሱ ሀርዹመ ነንጀልቀበ። እሳንስ ኦዱ ዋኤኬሰኒ ዸገአኒ ሰበቢኬሰኒፍ ሆለቱ፤ ናሱንስ እሳን ቀበተ።” ");
INSERT INTO gaze_vpl VALUES ("DT2_26","006_2_26","DEU","2","26","26","አንስ አከነ ጄዼ ገሞጂ ቅዴሞት ኬሳ ስሆን ሞትቸ ሄሽቦኒት ኤርገሞተ ነጋ ነንኤርጌ፤ ");
INSERT INTO gaze_vpl VALUES ("DT2_27","006_2_27","DEU","2","27","27","“አከ ኑ ብየኬ ኬሳን ደርብኑ ኑ ኤየም። ኑ ከራ ጉድቸራ ህንጎሩ፤ ምርገትስ ገረ ብታትስ ህንጎሩ። ");
INSERT INTO gaze_vpl VALUES ("DT2_28","006_2_28","DEU","2","28","28","ዋን ኛትኑፊ ብሻን ዹግኑ ማለቃን ኑት ጉርጉር። አከ ሚለ ቆፋን አች ኬሰ ደበሩ ኑፍ ኤየም፤ ");
INSERT INTO gaze_vpl VALUES ("DT2_29","006_2_29","DEU","2","29","29","አኩመ እልማን ኤሳዉ ከኔን ሴኢር ኬሰ ጅራተኒፊ ሞኣቦን ኣር ኬሰ ጅራተን ኑፍ ጎዸን ሰነ አትስ ሀመ ኑ ገረ ብየ ዋቀዮ ዋቅንኬኘ ኑ ኬኑት ገሉፍ ለገ ዮርዳኖስ ጬኑት አከሱመ ኑፍ ጎዽ።” ");
INSERT INTO gaze_vpl VALUES ("DT2_30","006_2_30","DEU","2","30","30","ስሆን ሞቲን ሄሽቦን ገሩ አከ ኑ ደበሩ ኑፍ ኤየሙ ድዴ። ዋቀዮ ዋቅንኬሰን አኩመ አመ ጎዼ ከነ ደበርሴ ሀርከኬሰንት እሰ ኬኑፍ መታፊ ገራሳ ጀቤሴ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("DT2_31","006_2_31","DEU","2","31","31","ዋቀዮስ፣ “ኩኖ፣ አን ስሆኒፊ ብየሳ ደበርሴ ሲፍ ኬኑ ጀልቀቤረ። አት ብየሳ ዻሉፍ ቀበቹ ጀልቀብ” ናን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("DT2_32","006_2_32","DEU","2","32","32","ዮሙ ስሆኒፊ ጉቱማን ሎልቶተሳ ኑ ወራኑፍ ያሀዝት በአንት፣ ");
INSERT INTO gaze_vpl VALUES ("DT2_33","006_2_33","DEU","2","33","33","ዋቀዮ ዋቅንኬኘ ደበርሴ ሀርከኬኘት እሰ ኑፍ ኬኔ፤ ኑስ እሰ፣ እልማንሳቲፊ ሎልቶተሳ ሁንደ ዾፍኔ። ");
INSERT INTO gaze_vpl VALUES ("DT2_34","006_2_34","DEU","2","34","34","ዬሮ ሰነትስ መጋላወንሳ ሁንደ ቀበትኔ ዺሮተ፣ ዱበርቶታፊ እጆሌ፣ ቶኮ ቶኮ መጋላወኒ ጉቱማን ጉቱት በርበዴስኔ። ነመ ቶኮሌ ህንሀምብፍኔ። ");
INSERT INTO gaze_vpl VALUES ("DT2_35","006_2_35","DEU","2","35","35","ገሩ ሆሪፊ ቦጁ መጋላወን ቀበትኔ ሰነ ኬሳ ቦጅኔ ኦፊኬኛፍ ፉዸትኔ። ");
INSERT INTO gaze_vpl VALUES ("DT2_36","006_2_36","DEU","2","36","36","መጋላ አሮኤር ከን ቀርቀረ ሱሉለ አርኖንት አርገሙፊ መጋላ ሱሉልቸ ኬሰት አርገሙ ጀልቀቤ መጋላ ሀመ ግልኣድት አርገሙ ኬሳ ቶኮዩ ኑ እትሱ ህንደንዴኜ። ዋቀዮ ዋቅንኬኘ ሁንደሳኒ ደበርሴ ኑፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT2_37","006_2_37","DEU","2","37","37","ገሩ አኩመ አጀጀ ዋቀዮ ዋቅንኬኘ ኑፍ ኬኔ ሰናት እስን ገረ ብዮተ አሞኖታ ቶኮትሌ ዮካን ገረ ብየ ቀርቀረ ለገ ያቦቅረት አርገሙ ዮካን ብዮተ ናኖ መጋላወን ጋረንረት አርገመኒት ህንደበሬ። ");
INSERT INTO gaze_vpl VALUES ("DT3_1","006_3_1","DEU","3","1","1","ኤርገሲስ ዴብኔ ከራ ባሻን ቀበትኔ ኦል ባኔ፤ ኦግ ሞትች ባሻንሞ ሎልቶተሳ ጉቱ ወጅን ኤድሬዪት ኑን ወል ሎሉፍ ገድ በኤ። ");
INSERT INTO gaze_vpl VALUES ("DT3_2","006_3_2","DEU","3","2","2","ዋቀዮስ፣ “ዋን አን እሰ፣ ጉቱማ ሎልቶተሳቲፊ ብየሳሌ ደበርሴ ሀርከኬት ኬኔፍ እሰ ህንሶዳትን። አኩመ ስሆን ሞቲ አሞሮታ ከን ሄሽቦን ቡልቻ ቱሬ ሰነ ጎቴ እሰሌ ጎዽ” ናን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("DT3_3","006_3_3","DEU","3","3","3","ዋቀዮ ዋቅንኬኘ ኦግ ሞቲ ባሻኒፊ ጉቱማ ሎልቶተሳ ደበርሴ ሀርከኬኘት ኬኔ። ኑስ ኡቱ ሆማ ህንሀምብስን እሳን በሌስኔ። ");
INSERT INTO gaze_vpl VALUES ("DT3_4","006_3_4","DEU","3","4","4","ዬሮ ሰነትስ መጋላወንሳ ሁንደ ቀበትኔ። መጋላወን ጃተመ ሞቱማ ኦግ ሞትቸ ባሻን ከኔን ኩታ ብየ አርጎብ ጀለ ቱረን ኬሳ ከን ኑ ህንቀበን ቶኮዩ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT3_5","006_3_5","DEU","3","5","5","መጋላወን ኩኔን ሁንድ ደላ ዸጋ ዼዼሮ፣ ከራፊ ደንቀራ ቀቡ ቱረን፤ አከሱመስ መጋላወን ደላ ህንቀብኔ ባይኤቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT3_6","006_3_6","DEU","3","6","6","ኑስ አኩመ ስሆን ሞቲ ሄሽቦን ጎኔ ሰነ ዺሮተ፣ ዱበርቶታፊ እጆሌ ቶኮ ቶኮ መጋላወኒ ጉቱማን ጉቱት በርበዴስኔ። ");
INSERT INTO gaze_vpl VALUES ("DT3_7","006_3_7","DEU","3","7","7","ሆሪፊ ቦጁ መጋላወንሳኒ ኬሳ ሳምኔ ሁንደ ገሩ ኦፊኬኛፍ ፉዸትኔ ገሌ። ");
INSERT INTO gaze_vpl VALUES ("DT3_8","006_3_8","DEU","3","8","8","ዬሮ ሰነት ሞቶተ አሞሮታ ለማን ከነራ ከራ በአ ዮርዳኖስ ብየ ሱሉለ አርኖኒቲ ጀልቀቤ ሀመ ቱሉ ሄርሞንት ጅሩ ፉዸትኔ። ");
INSERT INTO gaze_vpl VALUES ("DT3_9","006_3_9","DEU","3","9","9","ሲዶኖትንስ ሄርሞን ከነ ሲርዮን ጄዸኒ ዋሙ፤ አሞሮትንሞ ሴኒር ጄዸኒ ዋሙ። ");
INSERT INTO gaze_vpl VALUES ("DT3_10","006_3_10","DEU","3","10","10","ኑስ መጋላወን ድሬረት አርገመን ሁንደ፣ ግልኣድ ሁንደ፣ ባሻኒ ሀመ ሰልካፊ ኤድሬዪት ጅሩ ሁንደ፣ መጋላወን ሞቱማ ኦግ ከኔን ባሻን ኬሰት አርገመን ሁንደ ቀበትኔ። ");
INSERT INTO gaze_vpl VALUES ("DT3_11","006_3_11","DEU","3","11","11","ጎሰ ሬፋይሞታ ኬሳ ኦግ ሞቲ ባሻን ቆፈቱ ሀፌ። ኩኖ ስሬንሳ ስቢለራ ሆጄተሜ ደልገ ዼርንሳ ዹንዹመ ሰገል በልእንሳሞ ዹንዹመ አፉር ቱሬ። ስሬን ኩንስ አመዩ ረባ አሞኖታ ኬሰት አርገመ። ");
INSERT INTO gaze_vpl VALUES ("DT3_12","006_3_12","DEU","3","12","12","አን ብየ ዬሮ ሰነት ቀበትኔ ኬሳ ብየ ከራ ካበ አሮኤሪቲን ቀርቀረ ሱሉለ አርኖን ጅሩት ደበሌ ወለካ ብየ ጋራ ግልኣድ መጋላወንሳ ወጅን ጎሰ ሩቤኒፊ ጋዲፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT3_13","006_3_13","DEU","3","13","13","ብየ ግልኣድ ከን ሀፌፊ ጉቱማ ባሻን ጄቹንስ ሞቱማ ኦግ ወለካ ጎሰ ምናሴቲፈን ኬኔ። ጉቱማን ኩታ አርጎብ ከን ባሻን ኬሳ ሱን ብየ ሬፋይሞታ ጄዸሜ ቤከመ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT3_14","006_3_14","DEU","3","14","14","ያኢር እልም ምናሴሞ ጉቱማ ኩታ አርጎብ ከን ሀመ ዳሪ ጌሹሮታቲፊ መአካቶታት ጅሩ ፉዸቴ፤ ብይ ሱንስ መቃሳቲን ሞጋፈሜ፤ ከናፉ ባሻን ሀመ ሀርኣት ሃቦት ያኢር ጄዸመ። ");
INSERT INTO gaze_vpl VALUES ("DT3_15","006_3_15","DEU","3","15","15","ግልኣድሞ ማኪሪፈን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT3_16","006_3_16","DEU","3","16","16","ወለካ ሱሉለሳ ገሩ ዳንጋ ጎቹዻን ግልኣዲ ጀልቀቤ ሀመ ሱሉለ አርኖንት፣ አቺሞ ቡልቺንሰ ዳንጋ አሞኖታ ከን ሀመ ለገ ያቦቅት ጅሩ ጎሰ ሩቤኒፊ ጋዲፈን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT3_17","006_3_17","DEU","3","17","17","ዳንጋንሳ ከራ ልጣቲን ዮርዳኖስ እሰ አረባ ኬሰት አርገሙ ሰናዸ፤ ኩንስ ክኔሬቲ ጀልቀቤ ሀመ ገላነ አረባ ከን ገላነ ሶግዳ ጄዸሙት ድሪሬ ተበ ጵስጋቲ ገድት አርገመ። ");
INSERT INTO gaze_vpl VALUES ("DT3_18","006_3_18","DEU","3","18","18","አንስ ዬሮ ሰነት አከነ ጄዼን እስን አጀጄ፦ “ዋቀዮ ዋቅንኬሰን አከ ዻልተኒፍ ለፈ ከነ እስኒፍ ኬኔረ። ተኡስ ነሞትን ጀጀቦንኬሰን ሁንድ ወራናፍ ህዸተኒ ኦቦሎተኬሰን እስራኤሎተ ዱረ ገመት ጬኡ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("DT3_19","006_3_19","DEU","3","19","19","ገሩ ኒቶትንኬሰን፣ እጆሌንኬሰኒፊ ሆሪንኬሰን መጋላወን አን እስኒፍ ኬኔ ኬሰ ሃቱረን፤ አን አከ እስን ሆሪ ባይኤ ቀብደን ቤካቲ። ");
INSERT INTO gaze_vpl VALUES ("DT3_20","006_3_20","DEU","3","20","20","ኩንስ ሀመ ዋቀዮ አኩመ እስን ቦቆቺሴ ሰነ ኦቦሎተኬሰን ቦቆቺሴ እሳኒንስ ለፈ ዋቀዮ ዋቅንኬሰን ዮርዳኖሲን ገመት እሳኒፍ ኬኑ ሰነ ዻለንት። ሰነ ቦዴ ቶኮን ቶኮንኬሰን ገረ ብየ አን ዻለ እስኒፍ ኬኔት ንዴብቱ።” ");
INSERT INTO gaze_vpl VALUES ("DT3_21","006_3_21","DEU","3","21","21","አንስ ዬሮ ሰነት አከነ ጄዼን እያሱ አጀጄ፦ “አት ዋን ዋቀዮ ዋቅንኬ ሞቶተ ከኔን ለማን ጎዼ ሁንደ እጀኬቲን አርግቴርተ። ዋቀዮ፣ ሞቱሞተ እስን እት ያተን ሁንደስ አከሱመ ንጎዸ። ");
INSERT INTO gaze_vpl VALUES ("DT3_22","006_3_22","DEU","3","22","22","እስን እሳን ህንሶዳትና፤ ዋቀዮ ዋቅንኬሰን መታንሳ እስኒፍ ሎላቲ።” ");
INSERT INTO gaze_vpl VALUES ("DT3_23","006_3_23","DEU","3","23","23","ዬሮ ሰነት አን አከነ ጄዼ ዋቀዮን ነንከዸዼ፤ ");
INSERT INTO gaze_vpl VALUES ("DT3_24","006_3_24","DEU","3","24","24","“ያ ዋቀዮ ጎፍታ፣ አት ጉድነኬቲፊ ሀርከኬ ጀባ ሰነ ገርብቸኬት አርግሲሱ ጀልቀብዴርተ። ስላ ከን ሆጂ ጀባ አከሲ ከን አት ሆጄቱ ሆጄቹ ደንደኡ ዋቀ ከምቱ ሰሚረ ዮካን ለፈረ ጅረ? ");
INSERT INTO gaze_vpl VALUES ("DT3_25","006_3_25","DEU","3","25","25","አከ አን ጬኤ ብየቲ ጋሪ ዮርዳኖስ ገመ ጅርቱ ጄቹንስ ብየ ጋራ ጋሪ ሰናፊ ልባኖን አርጉ ና ኤየም።” ");
INSERT INTO gaze_vpl VALUES ("DT3_26","006_3_26","DEU","3","26","26","ዋቀዮ ገሩ ዋን ሰበቢኬሰኒፍ ነት ዼከሜፍ፣ ነ ዸገኡ ድዴ። ዋቀዮ አከነ ናን ጄዼ፤ “ኩን ንገአ፤ ለመተ ዋኤ ዋን ከና ነት ህንዱበትን። ");
INSERT INTO gaze_vpl VALUES ("DT3_27","006_3_27","DEU","3","27","27","ፊጤ ጵስጋት ኦል በኢቲ ገረ ልጣፊ ካባ፣ ገረ ክባፊ በኣ እላል። አት ዋን ዮርዳኖስ ህንጬኔፍ ብየቲ እጁመኬቲን እላል። ");
INSERT INTO gaze_vpl VALUES ("DT3_28","006_3_28","DEU","3","28","28","ገሩ አከ እን ሰበ ከነ ቀጄልቼ ጬስሴ አከ እሳን ብየ አት እላልቱ ከነ ዻለን ጎዹፍ እያሱ አጀጅ፤ እሰ ጀጀቤስ፤ ጭምስስ።” ");
INSERT INTO gaze_vpl VALUES ("DT3_29","006_3_29","DEU","3","29","29","ኑ ሱሉለ ቤት ጴኦር ብረ ጅሩ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT4_1","006_4_1","DEU","4","1","1","ያ እስራኤል፣ አጀጀወኒፊ ሴረወን አን እስን በርሲሱ ዸገኣ። አከ ጅራተኒፊ ዸቅጠኒ ብየ ዋቀዮ ዋቅን አቦቲኬሰኒ እስኒፍ ኬኑ ዻልተኒፍስ እሳን ዱካ ቡኣ። ");
INSERT INTO gaze_vpl VALUES ("DT4_2","006_4_2","DEU","4","2","2","አጀጀ ዋቀዮ ዋቀኬሰኒ ከን አን እስኒፍ ኬኑ ኤጋ መሌ ዋን ቶኮሌ እት ህንደበልና ዮካን እራ ህንህርእስና። ");
INSERT INTO gaze_vpl VALUES ("DT4_3","006_4_3","DEU","4","3","3","እስን ዋን ዋቀዮ በኣል ጴኦርት ሆጄቴ እጁመኬሰኒን አርግተኒርቱ። ዋቀዮ ዋቅንኬሰን ወረ እስን ግዱዻ በኣል ጴኦር ዱካ ቡአን ሁንደ በሌሴረ፤ ");
INSERT INTO gaze_vpl VALUES ("DT4_4","006_4_4","DEU","4","4","4","እስን ወር ዋቀዮ ዋቀኬሰን ቀበተን ሁንድ ገሩ ሀመ ሀርኣት ሉቡዻን ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("DT4_5","006_4_5","DEU","4","5","5","ኩኖ፣ አከ እስን ብየ ዻሉፍ እት ገሉፍ ጅርተንት እሳን ዱካ ቡተኒፍ አን አኩመ ዋቀዮ ዋቅንኮ ነ አጀጄት አጀጀወኒፊ ሴረወን እስን በርሲሴረ። ");
INSERT INTO gaze_vpl VALUES ("DT4_6","006_4_6","DEU","4","6","6","ኩንስ አከ ሰቦትን ዋኤ አጀጀወን ከና ሁንደ ዸገአኒ፣ “ዹጉማን ሰብን ጉዳን ኩን ሰበ ኦጌሳፊ ሁበታዸ” ጄዸኒፍ ኦጉማፊ ሁበትናኬሰን ሰቦተት አርግሲሳቲ አከ ጋሪት እሳን ኤጋ። ");
INSERT INTO gaze_vpl VALUES ("DT4_7","006_4_7","DEU","4","7","7","ሰብን ጉዳን አከ ዬሮ ኑ ዋቀዮ ዋቀኬኘ ዋመኑት ኑት ዽኣቱ ሰነ ዋቆንሳኒ እት ዽኣተን ከን ብራ ከም? ");
INSERT INTO gaze_vpl VALUES ("DT4_8","006_4_8","DEU","4","8","8","ሰብን ጉዳን አጀጀወኒፊ ሴረ ቀጄላ አከ ሴረ አን ሀርአ ፉለኬሰን ዱረ ካኡ ከና ቀቡ ብራ ከም? ");
INSERT INTO gaze_vpl VALUES ("DT4_9","006_4_9","DEU","4","9","9","አከ ዋን እጅኬ አርጌ ህንደገኔፍ ዮካን አከ ሀመ አት ሉቡዻን ጅርቱት ገራኬቲ ህንበድኔፍ ኦፉመ ኤገዹ፤ ጀባዹ ኦፍ ኤገዹ። ዋን ከነስ እጆሌኬቲፊ እጆሌ እጆሌ እጆሌኬቲ በርሲስ። ");
INSERT INTO gaze_vpl VALUES ("DT4_10","006_4_10","DEU","4","10","10","ጋፈ እስን ኮሬብት ፉለ ዋቀዮ ዋቀኬሰኒ ዱረ ዻበተን፣ ዬሮ እን፣ “አከ እሳን ሀመ ሉቡዻን ለፈረ ጅራተን ሁንደት ነ ሶዳቹ በረተኒ እጆሌ እጆሌሳኒሌ ነ ሶዳቹ በርሲሰኒፍ ዱቢኮ ሃዸገአኒቲ ነሞተ ወልት ቀብ” ናን ጄዼ ሰነ ያደዻ። ");
INSERT INTO gaze_vpl VALUES ("DT4_11","006_4_11","DEU","4","11","11","እስን ኡቱማ ቱሉን ሱን ቦበኣ እብደ ሀመ ዊርቱ ሰሚት ኦል በኤ ዱሜሰ ጉራቻፊ ዱከነ ልምጢዻን ሀጉገሜ ጅሩ እት ዽኣተኒ ሚለ ቱሉ ሰና ጀለ ዸዻበተን። ");
INSERT INTO gaze_vpl VALUES ("DT4_12","006_4_12","DEU","4","12","12","ኤርገሲስ ዋቀዮ እብደ ኬሳ እስንት ዱበቴ። እስንስ ሰገሌ ዱቢ ሰና መሌ ብፈ ቶኮሌ ህንአርግኔ፤ ሰገሌ ቶኮ ቆፈቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT4_13","006_4_13","DEU","4","13","13","እንስ ከኩሳ ጄቹንስ አጀጀወን ኩርነን አከ እስን እሳን ዱካ ቡተኒፍ እስን አጀጄ ሰነ እስኒፍ ለብሴ። ኤርገሲሞ ገበቴ ዸጋ ለመረት እሳን በሬሴ። ");
INSERT INTO gaze_vpl VALUES ("DT4_14","006_4_14","DEU","4","14","14","ዋቀዮስ ዬሮ ሰነት አከ አን አጀጀወኒፊ ሴረወን ብየ እስን ዮርዳኖስ ጬተኒ ዻልተን ሰነ ኬሰት ዱካ ቡኡ ቀብደን እስን በርሲሱ ነ አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("DT4_15","006_4_15","DEU","4","15","15","ጋፈ ዋቀዮ ኮሬብረት እብደ ኬሳ እስንት ዱበቴት እስን ብፈ ቶኮሌ ህንአርግኔ። ከናፉ ጀቤሳ ኦፍ ኤገዻ፤ ");
INSERT INTO gaze_vpl VALUES ("DT4_16","006_4_16","DEU","4","16","16","ኩንስ አከ እስን ህንጡሮፍኔ፣ አከ ዋቀ ቶልፈማ ብፈ ዺራቲን ዮካን ዱበርቲቲን ሶፈሜ ከምዩ ኦፊኬሰኒፍ ህንቶልፈትኔ ");
INSERT INTO gaze_vpl VALUES ("DT4_17","006_4_17","DEU","4","17","17","ዮካን ሆሪ ለፈረ ጅራቱ ዮካን ስምብረ ሰሚ ኬሰ በርሱ ከምዩ ");
INSERT INTO gaze_vpl VALUES ("DT4_18","006_4_18","DEU","4","18","18","ዮካን ኡመመ ለፈረ ሙኙቁ ከምዩ ዮካን ቁርጡሚ ለፈ ጀለ ብሻን ኬሰ ጅራቱ ከምዩ ህንቶልፈኔፍ። ");
INSERT INTO gaze_vpl VALUES ("DT4_19","006_4_19","DEU","4","19","19","አት ዮሙ ሰሚ ኦል እላልቴ አዱ፣ ጅአ፣ ኡርጂወኒፊ ራያ ሰሚ ሁንደ አርግቱት ጎዎምፈምቴ ፉለ ዋን ዋቀዮ ዋቅንኬ ሰቦተ ሰሚዻ ገዲ ሁንዳፍ ቆዴ ኬኔ ዱረት ገድ ጄቴ ህንሰገድን። ");
INSERT INTO gaze_vpl VALUES ("DT4_20","006_4_20","DEU","4","20","20","ዋቀዮ ገሩ አከ እስን አኩመ አመ ጅርተን ከነ ዻለሳ ታተኒፍ በዳ ስቢለ እት በቅሰን ጄቹንስ ብየ ግብጢቲ ባሴ እስን ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("DT4_21","006_4_21","DEU","4","21","21","ዋቀዮስ ሰበቢኬሰኒፍ ነት ዼከሜ አከ አን ለገ ዮርዳኖስ ጬኤ ብየ ጋሪ ከን ዋቀዮ ዋቅንኬሰን ዻለ ጎዼ እስኒፍ ኬኑ ሰነ ህንሴኔ ከከቴ። ");
INSERT INTO gaze_vpl VALUES ("DT4_22","006_4_22","DEU","4","22","22","አን ብዩመ ከነት ነንዱአ፤ አን ዮርዳኖስን ህንጬኡ፤ እስን ገሩ ጬተኒ ብየ ጋሪ ሰነ ዻሉፍ ጅርቱ። ");
INSERT INTO gaze_vpl VALUES ("DT4_23","006_4_23","DEU","4","23","23","አከ ከኩ ዋቀዮ ዋቅንኬሰን እስን ወጅን ገሌ ሰነ ህንደገትኔ ኦፍ ኤገዻ፤ ዋቆተ ቶልፈሞ ዋቀዮ ዋቅንኬሰን እስን ዾዌ ብፈ ከሚንዩ ኦፊኬሰኒፍ ህንቶልፈትና። ");
INSERT INTO gaze_vpl VALUES ("DT4_24","006_4_24","DEU","4","24","24","ዋቀዮ ዋቅንኬሰን እብደ ጉቤ በሌሱዻቲ፤ ዋቀ ህናፉዸስ። ");
INSERT INTO gaze_vpl VALUES ("DT4_25","006_4_25","DEU","4","25","25","እስን ኤርገ እጆሌፊ እጆሌ እጆሌኬሰኒ ሆርተኒ ብየ ሰነ ኬሰ በረ ዼራ ጅራተኒ ቦዴ፣ ዮ ጡሮፍተኒ ፈኪ ዋቆተ ቶልፈሞ ብፈ ከሚዩ ቶልችተኒ ፉለ ዋቀዮ ዋቀኬሰኒ ዱረት ዋን ሀማ ሆጄተኒ ዼከምሳፍ እሰ ከካፍተን፣ ");
INSERT INTO gaze_vpl VALUES ("DT4_26","006_4_26","DEU","4","26","26","አከ እስን ብየ ዮርዳኖስ ጬተኒ ዻልተንራ አሪቲዻን ዸበምተን አን ጉያ ሀርኣ ሰሚፊ ለፈ ዹጋ ባቶተ ጎዼ እስንት ነንዋመ። እዶ ሰነ ዬሮ ዼራ ህንጅራተን፤ እስን ጉቱማን ጉቱት በርበዶፍቱ። ");
INSERT INTO gaze_vpl VALUES ("DT4_27","006_4_27","DEU","4","27","27","ዋቀዮስ ሰቦተ ኬሰ እስን ፈፈጫሰ፤ ሰቦተ ወረ ዋቀዮ እሳን ግዱት እስን ፈፈጫሴ ኬሰትስ ሙራሰ ታተኒ ሀፍቱ። ");
INSERT INTO gaze_vpl VALUES ("DT4_28","006_4_28","DEU","4","28","28","እስንስ አችት ዋቆተ ሀርከ ነማቲን ሙካፊ ዸጋራ ሆጄተመን ከኔን አርጉ ዮካን ዸገኡ ዮካን ኛቹ ዮካን ፉንፈቹ ህንደንዴኜ ዋቄፈቱ። ");
INSERT INTO gaze_vpl VALUES ("DT4_29","006_4_29","DEU","4","29","29","ገሩ ዮ አችትስ ዋቀዮ ዋቀኬሰን በርባደን ንአርገቱ፤ እስን ዮ ገራፊ ያደኬሰን ጉቱዻን እሰ በርባደን ንአርገቱ። ");
INSERT INTO gaze_vpl VALUES ("DT4_30","006_4_30","DEU","4","30","30","ዮሙ ዽጰቴ ወን ኩን ሁንድ ስት ዹፉት፣ በሮተ ዹፉፍ ጅረን ኬሰ ገረ ዋቀዮ ዋቀኬቲት ንዴብተ፤ እሳፍስ ንአጀጀምተ። ");
INSERT INTO gaze_vpl VALUES ("DT4_31","006_4_31","DEU","4","31","31","ዋቀዮ ዋቅንኬ ዋቀ አራራት፤ እን ስ ህንገቱ ዮካን ስ ህንበሌሱ ዮካን ከኩ አቦቲኬቲፍ ከከቴ ሰነ ህንደገቱ። ");
INSERT INTO gaze_vpl VALUES ("DT4_32","006_4_32","DEU","4","32","32","ዋኤ በሮተ ዱሪ ከን ኡቱ አት ህንዸለትን ዱረ ጋፈ ዋቀዮ ለፈረት ነመ ኡሜ ጀልቀቤ ቱሬ ሰነ እያፈዻ፤ ዳሪ ሰሚ ቶኮራ ሀመ ዳሪ ካኒት እያፈዻ። ወን ጉዳን አከና ተኩማ ኡመሜ ዮካን ወን አከና ተኩማ ዸገአሜ ቤካ? ");
INSERT INTO gaze_vpl VALUES ("DT4_33","006_4_33","DEU","4","33","33","ሰብን አከኬሰን ሰገሌ ዋቃ ከን እብደ ኬሳ ዱበቱ ዸገኤ ሉቡዻን ጅራቴ ከን ብራ ተኩማ አርገሜራ? ");
INSERT INTO gaze_vpl VALUES ("DT4_34","006_4_34","DEU","4","34","34","ዋቅን ከምዩ ተኩማ አከ ዋቀዮ ዋቅንኬሰን ኡቱመ እጅኬሰን አርጉ ብየ ግብጥት እስኒ ጎዼ ሰነ ሰበ ቶኮ ሰበ ብራ ኬሳ ቆሩምሳን፣ መለቶፊ ድንቂዻን፣ ወራናን፣ ሀርከ ጀባፊ እሬ ድሪርፈሜን፣ ዮካን ሆጂ ጉዳፊ ሶዳችሳዻን ባሴ ከን ኦፊሳ ጎዸቹ ያሌ ጅረ? ");
INSERT INTO gaze_vpl VALUES ("DT4_35","006_4_35","DEU","4","35","35","እስንስ ዋቀዮ ዋቀ ተኡሳ አከ ቤክተኒፍ ወንቶትን ኩኔን እስንት አርግሲፈመን፤ እሰ መሌስ ከን ብራ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT4_36","006_4_36","DEU","4","36","36","እን ስ አደበቹፍ ጄዼ ሰሚዻ ሰገሌሳ ስ ዸጌስሴ። ለፈረት እብደሳ ጉድቸ ስት አርግሲሴ አትስ እብደ ኬሳ ዱቢሳ ዸጌሴ። ");
INSERT INTO gaze_vpl VALUES ("DT4_37","006_4_37","DEU","4","37","37","እን ዋን አቦቲኬ ጃለቴ እሳን ቦዴስ ሰኚወንሳኒ ፍለቴፍ ኦፊሳቲን ሁምነሳ ጉዳዻን ብየ ግብጢቲ ባሴ እስን ፍዴ፤ ");
INSERT INTO gaze_vpl VALUES ("DT4_38","006_4_38","DEU","4","38","38","ከነስ አከ ሀርአ ተኤ ጅሩ ከነ ሰቦተ ስ ጫላ ጉርጉዳፊ ጀጀቦ ስ ዱራ አርኤ ብየሳኒ ዻለ ጎዼ ሲፍ ኬኑፍ እት ስ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("DT4_39","006_4_39","DEU","4","39","39","ሀርአ አከ ዋቀዮ ኦል ሰሚ ጉባት፣ ገድ ለፈረትስ ዋቀ ተኤ ቤክ፤ ገራ ኬትስ ቀበዹ። ከን ብራስ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT4_40","006_4_40","DEU","4","40","40","አከ ሲፊ እጆሌኬ ወረ ስኢን ዱባቲፍ ቶሉፊ አከ ብየ ዋቀዮ ዋቅንኬ በረ በራን ሲፍ ኬኑት ኡሙሪንኬ ዼረቱፍ ቀጄልቸወኒፊ አጀጀወንሳ ከኔን አን ሀርአ ሲፍ ኬኑ ኤግ። ");
INSERT INTO gaze_vpl VALUES ("DT4_41","006_4_41","DEU","4","41","41","ዬሮ ሰነት ሙሴን መጋላወን በአ ዮርዳኖስ ሰዲ አዳን ባፈቴ፤ ");
INSERT INTO gaze_vpl VALUES ("DT4_42","006_4_42","DEU","4","42","42","ኩንስ ለፈ ነምን ነመ አጄሴ ዮ ኡቱ እት ህንያድን ነመ አጄሴ እት በቀቱዸ። እንስ መጋላወን ከኔን ኬሳ ቶኮት በቀቴ ሉቡሳ ኦልፈቹ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("DT4_43","006_4_43","DEU","4","43","43","መጋላወን ሱንስ ከኔን ቱረን፦ ቤዜር ከን ገሞጂ ኬሰ ተበረ ጅርቱ ጎሰ ሩቤኒፍ፣ ራሞት ከን ግልኣድት አርገምቱ ጎሰ ጋዲፍ፣ ጎላን ከን ባሻንት አርገምቱሞ ጎሰ ምናሴፍ። ");
INSERT INTO gaze_vpl VALUES ("DT4_44","006_4_44","DEU","4","44","44","ኩን ሴረ ሙሴን እስራኤሎተ ዱረ ካኤዸ። ");
INSERT INTO gaze_vpl VALUES ("DT4_45","006_4_45","DEU","4","45","45","ቀጄልች፣ አጀጅኒፊ ሴር ሙሴን ዮሙ እሳን ብየ ግብጢ በአንት እስራኤሎታፍ ኬኔ ከናዸ፤ ");
INSERT INTO gaze_vpl VALUES ("DT4_46","006_4_46","DEU","4","46","46","ኩንስ ዬሮ እሳን ሱሉለ ቤት ጴኦር ብየ በአ ዮርዳኖስት አርገምቱ ኬሰ ቱረንት ተኤ፤ ብይ ኩንስ ብየ ስሆን ሞቲ አሞሮታ ከን ሄሽቦን ኬሰ ጅራቻ ቱሬ ሙሴፊ እስራኤሎን ዬሮ ብየ ግብጢ በአንት እሰ ሞአተኒት። ");
INSERT INTO gaze_vpl VALUES ("DT4_47","006_4_47","DEU","4","47","47","እሳንስ ብየሳቲፊ ብየ ኦግ ሞትቸ ባሻን ጄቹንስ ብዮተ ሞቶተ አሞሪ ለማን በአ ዮርዳኖስት አርገመን ዻለ ጎዸኒ ፉዸተን። ");
INSERT INTO gaze_vpl VALUES ("DT4_48","006_4_48","DEU","4","48","48","ብይ ኩንስ አሮኤር ከን ዳሪ ሱሉለ አርኖኒ ጀልቀቤ ሀመ ጋረ ስሆንት ጄቹንስ ሀመ ሄርሞኒት በልአተ፤ ");
INSERT INTO gaze_vpl VALUES ("DT4_49","006_4_49","DEU","4","49","49","እንስ አረባ በአ ዮርዳኖሲ ሀመ ገላነ አረባት ጅሩ ከን ተበ ጵስጋቲ ገድት አርገሙ ሁንደ ደበለተ። ");
INSERT INTO gaze_vpl VALUES ("DT5_1","006_5_1","DEU","5","1","1","ሙሴን እስራኤሎተ ሁንደ ወልት ቀቤ አከነ እሳኒን ጄዼ፦ ያ እስራኤል አጀጀወኒፊ ሴረወን አን ሀርአ ኡቱመ እስን ዸጌሰኑ ለብሱ ከነ ዸገኣ። በረዻቲ ጀቤሳ እሳን ዱካ ቡኣ። ");
INSERT INTO gaze_vpl VALUES ("DT5_2","006_5_2","DEU","5","2","2","ዋቀዮ ዋቅንኬኘ ኮሬብት ኑ ወጅን ከኩ ገሌ። ");
INSERT INTO gaze_vpl VALUES ("DT5_3","006_5_3","DEU","5","3","3","ዋቀዮ ከኩ ከነ ኑ ወጅን፣ ኑ ወረ ሀርአ ሉቡዻን አስ ጅራትኑ ሁንደ ወጅን ገሌ መሌ አቦቲኬኘ ወጅን ህንገሌ። ");
INSERT INTO gaze_vpl VALUES ("DT5_4","006_5_4","DEU","5","4","4","ዋቀዮ ቱሉረት እብደ ኬሳ እፋን እፈት እስንት ዱበቴ። ");
INSERT INTO gaze_vpl VALUES ("DT5_5","006_5_5","DEU","5","5","5","ዬሮ ሰነት ዋን እስን እብደ ሶዳተኒ ቱሉት ኦል ህንበእኒፍ አን ዱቢ ዋቀዮ እስንት ህሙፍ እስኒፊ ዋቀዮ ግዱን ዻበዼ። እንስ አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("DT5_6","006_5_6","DEU","5","6","6","“አን ዋቀዮ ዋቀኬ ከን ግብጢ፣ ብየ ገርቡማቲ ስ ባሴዸ። ");
INSERT INTO gaze_vpl VALUES ("DT5_7","006_5_7","DEU","5","7","7","“አት አነ መሌ ዋቆተ ብራ ቶኮሌ ህንቀባትን። ");
INSERT INTO gaze_vpl VALUES ("DT5_8","006_5_8","DEU","5","8","8","አት ብፈ ዋን ኦል ሰሚ ጉባ ዮካን ገድ ለፈረ ዮካን ብሻን ለፈ ጀላ ኬሰ ጅሩ ዋቀ ቶልፈማ ከሚቲንዩ ኦፊኬቲፍ ህንቶልፈትን። ");
INSERT INTO gaze_vpl VALUES ("DT5_9","006_5_9","DEU","5","9","9","እሳኒፍ ህንሰገድን ዮካን እሳን ህንዋቄፈትን፤ አን ዋቀዮ ዋቅንኬ፣ ዋቀ ህናፉ ከን እጆሌ ወረ ነ ጅበኒ ሰበቢ ጩቡ አቦቲቲፍ ጄዼ ሀመ ዸሎተ ሰዲፊ አፉሪት አደቤ ");
INSERT INTO gaze_vpl VALUES ("DT5_10","006_5_10","DEU","5","10","10","ወረ ነ ጃለተኒ አጀጀወንኮ ኤገንሞ ሀመ ዸሎተ ኩማት ጃለቱዸ። ");
INSERT INTO gaze_vpl VALUES ("DT5_11","006_5_11","DEU","5","11","11","መቃ ዋቀዮ ዋቀኬቲ አከሱማን ህንዸእን፤ ዋቀዮ ወረ አኩመ አርገን መቃሳ ዸአን ኡቱ ህንአደብን ህንዺሱቲ። ");
INSERT INTO gaze_vpl VALUES ("DT5_12","006_5_12","DEU","5","12","12","አኩመ ዋቀዮ ዋቅንኬ ስ አጀጄት ጉያ ሰንበታ ቁልቁሌሱዻን ኤግ። ");
INSERT INTO gaze_vpl VALUES ("DT5_13","006_5_13","DEU","5","13","13","ጉዮተ ጀአ ሆጄዹ፤ ሆጂኬ ሁንደስ ሆጄተዹ፤ ");
INSERT INTO gaze_vpl VALUES ("DT5_14","006_5_14","DEU","5","14","14","ጉያን ቶርበፋን ገሩ ሰንበተ ዋቀዮ ዋቀኬቲት። ጋፈስ ሆጂ ቶኮሌ ህንሆጄትን፤ አት ዮካን እልምኬ ዮካን እንተልኬ ዮካን ሆጄታንኬ ዮካን ጦምቦሬንኬ ዮካን ቆትዮንኬ ዮካን ሀሬንኬ ዮካን ሆሪንኬ ከምዩ ዮካን አለጋን መጋላኬ ኬሰ ጅራቱ ቶኮዩ ሆማ ህንሆጄትን። ሆጄታንኬቲፊ ሆጄቱንኬ አኩመኬ ሃቦቆተን። ");
INSERT INTO gaze_vpl VALUES ("DT5_15","006_5_15","DEU","5","15","15","አከ አትስ ብየ ግብጥት ገርበ ቱርቴፊ ኤርገሲሞ ዋቀዮ ዋቅንኬ ሀርከ ጀባፊ እሬ ድሪርፈሜን አቺ ስ ባሴ ያደዹ። ከናፉ ዋቀዮ ዋቅንኬ አከ አት ሰንበተ ኤግዱ ስ አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("DT5_16","006_5_16","DEU","5","16","16","አከ ብየ ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ኬሰ በረ ዼራ ጅራቱፊ አከ ስት ቶሉፍ አኩመ ዋቀዮ ዋቅንኬ ስ አጀጄት አባኬቲፊ ሃዸኬቲፍ ኡልፍነ ኬን። ");
INSERT INTO gaze_vpl VALUES ("DT5_17","006_5_17","DEU","5","17","17","ህንአጄስን። ");
INSERT INTO gaze_vpl VALUES ("DT5_18","006_5_18","DEU","5","18","18","ህንኤጅን። ");
INSERT INTO gaze_vpl VALUES ("DT5_19","006_5_19","DEU","5","19","19","ህንሀትን። ");
INSERT INTO gaze_vpl VALUES ("DT5_20","006_5_20","DEU","5","20","20","ኦላኬት ሶባን ዹጋ ህንበእን። ");
INSERT INTO gaze_vpl VALUES ("DT5_21","006_5_21","DEU","5","21","21","ኒቲ ነማ ህንሀውን። መነ ነማ ዮካን ለፈ ቆቲሳ ዮካን ሆጄታ ዮካን ጦምቦሬሳ፣ ቆትዮሳ ዮካን ሀሬሳ፣ ዮካን ዋን ነማ ከምዩ ህንሀውን።” ");
INSERT INTO gaze_vpl VALUES ("DT5_22","006_5_22","DEU","5","22","22","አጀጀወን ዋቀዮ ቱሉ ጉባት፣ እብደ፣ ዱሜሳፊ ዱከነ ልምጢ ኬሰ ወልዳኬሰን ጉቱት ሰገሌ ጉዳዻን ለብሴ ከኔኒዸ፤ ወን እን እት ደበሌስ ህንጅሩ። ኤርገሲስ እን አጀጀወን ሰነ ገበቴወን ዸጋ ለመረት በሬሴ ነት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT5_23","006_5_23","DEU","5","23","23","ዬሮ እስን ኡቱ ቱሉን ሱን እብዳን ቦበኡ ዱከነ ኬሳ ሰገሌ ሰነ ዸጌሰንት፣ ሆገንቶትን ጎሶተኬሰኒቲፊ ማንጉዶትንኬሰን ሁንድ ገረኮ ዹፈን። ");
INSERT INTO gaze_vpl VALUES ("DT5_24","006_5_24","DEU","5","24","24","እስንስ አከነ ጄተን፤ “ኩኖ ዋቀዮ ዋቅንኬኘ ኡልፍናፊ ጉድነሳ ኑ አርግሲሴረ፤ እብደ ኬሳስ ሰገሌሳ ኑ ዸጌስሴረ። ኑ ሀርአ አከ ነምን ዮ ዋቅን እሰት ዱበቴሌ ጅራቹ ደንደኡ አርግኔረ። ");
INSERT INTO gaze_vpl VALUES ("DT5_25","006_5_25","DEU","5","25","25","አመ ገሩ ኑ ማሊፍ ዱነ? ኑ ዮ ሰገሌ ዋቀዮ ዋቀኬኛ ዴብኔ ዸጌኜ ንዱነ፤ እብዲ ጉዳን ኩንስ ኑ በርበዴሰ። ");
INSERT INTO gaze_vpl VALUES ("DT5_26","006_5_26","DEU","5","26","26","ነመ ዱኣ ህንኦሌ ሁንደ ኬሳ ኤኙቱ ተኩማ ሰገሌ ዋቀ ጅራታ እብደ ኬሳ ዱበቱ ዸገኤ አከ ኑ ዸጌኜ ጅራትኔ ከነ ኡቱ ህንዱእን ሀፌ? ");
INSERT INTO gaze_vpl VALUES ("DT5_27","006_5_27","DEU","5","27","27","እት ዽኣዹቲ ዋን ዋቀዮ ዋቅንኬኘ ጄዹ ሁንደ ዸገእ። ኤርገሲሞ ዋን ዋቀዮ ዋቅንኬኘ ስት ህሙ ሁንደ ኑት ህም። ኑ ንዸጌፈትና፤ ንአጀጀምነስ።” ");
INSERT INTO gaze_vpl VALUES ("DT5_28","006_5_28","DEU","5","28","28","ዋቀዮ ዮሙ እስን ነት ዱበተንት እስን ዸገኤረ፤ ዋቀዮስ አከነ ናን ጄዼ፤ “አን ዋን ነሞትን ኩኔን ሲን ጄዸን ዸገኤረ። ወን እሳን ጄዸን ሁንድኑ ጋሪዸ። ");
INSERT INTO gaze_vpl VALUES ("DT5_29","006_5_29","DEU","5","29","29","አከ ሀመ በረ በራት እሳኒፊ እጆሌ እሳኒት ቶሉፍ እሳን ኡቱ ዬሮ ሁንደ ገራ ነ ሶዳቴ አጀጀኮ ሁንደ ኤጉ ቀባተኒ አከም ጋሪ ቱሬ! ");
INSERT INTO gaze_vpl VALUES ("DT5_30","006_5_30","DEU","5","30","30","“ዸቂቲ፣ ‘ዱንካነኬሰንት ዴብኣ’ ጄዺን። ");
INSERT INTO gaze_vpl VALUES ("DT5_31","006_5_31","DEU","5","31","31","አት ገሩ አሱመ ነ ብረ ቱር። አን አጀጀወን፣ ቀጄልፈመወኒፊ ሴረወን አት አከ እሳን ብየ አን ዻለ ጎዼ እሳኒፍ ኬኑ ኬሰት ኤገኒፍ እሳን በርሲፍቱ ሁንደ ስት ነንህመ።” ");
INSERT INTO gaze_vpl VALUES ("DT5_32","006_5_32","DEU","5","32","32","ከናፉ ዋን ዋቀዮ ዋቅንኬሰን እስን አጀጄ ኦፍ ኤገናዻን ኤጋ፤ ምርገት ዮካን ብታት ህንጎርና። ");
INSERT INTO gaze_vpl VALUES ("DT5_33","006_5_33","DEU","5","33","33","አከ ብየ ዻልተን ኬሰ ጅራቹ ደንዴሰን፣ አከ እስንት ቶሌ ኡሙሪ ዼራሌ ቀባተኒፍ ከራ ዋቀዮ ዋቅንኬሰን እስን አጀጄ ሁንደረ ዴማ። ");
INSERT INTO gaze_vpl VALUES ("DT6_1","006_6_1","DEU","6","1","1","አጀጀወን፣ ቀጄልፈመወኒፊ ሴር እስን ዬሮ ብየ ዮርዳኖስ ጬተኒ ዻልተንት ኤግደን ከኔን አከ አን እስን በርሲሱፍ ዋቀዮ ዋቅንኬሰን ነ አጀጄ ከኔኒዸ፤ ");
INSERT INTO gaze_vpl VALUES ("DT6_2","006_6_2","DEU","6","2","2","ኩንስ አከ በረ ጅሬኘኬሰኒ ጉቱ እስን፣ እጆሌንኬሰኒፊ እጆሌን እጆሌኬሰኒ ቀጄልፈመወኒፊ አጀጀወን አን እስኒፍ ኬኑ ሁንደ ኤጉዻን ዋቀዮ ዋቀኬሰን ሶዳተኒ ኡሙሪንኬሰን ዼረቱፍ። ");
INSERT INTO gaze_vpl VALUES ("DT6_3","006_6_3","DEU","6","3","3","ያ እስራኤል ዸገእ፤ አከ ብየ ኣነኒፊ ደም ኬሳ ቡርቁ ሰነ ኬሰት አኩመ ዋቀዮ ዋቅን አቦቲኬቲ ስ አብደቺሴ ሰነት ስት ቶሌ ጉዳ ባይአቱፍ አጀጀም። ");
INSERT INTO gaze_vpl VALUES ("DT6_4","006_6_4","DEU","6","4","4","ያ እስራኤል ዸገእ፤ ዋቀዮ ዋቅንኬኘ ዋቀዮ ቶክቸ። ");
INSERT INTO gaze_vpl VALUES ("DT6_5","006_6_5","DEU","6","5","5","ገራኬ ጉቱዻን፣ ያደኬ ጉቱዻን፣ ሁምነኬ ጉቱዻን ዋቀዮ ዋቀኬ ጃለዹ። ");
INSERT INTO gaze_vpl VALUES ("DT6_6","006_6_6","DEU","6","6","6","አጀጀወን አን ሀርአ ሲፍ ኬኑ ኩኔን ገራኬ ኬሰ ሃጅራተን። ");
INSERT INTO gaze_vpl VALUES ("DT6_7","006_6_7","DEU","6","7","7","እጆሌኬስ ጭምሲ በርሲስ። ዬሮ መነ ቴሱ፣ ዬሮ ከራ ዴምቱ፣ ዬሮ ጪፍቱፊ ዬሮ ደመቅጡት ዋኤሳኒ ኦዴስ። ");
INSERT INTO gaze_vpl VALUES ("DT6_8","006_6_8","DEU","6","8","8","አከ መለቶት ሀርከት ህዸዹ፤ አደኬረትስ መጠንፈዹ። ");
INSERT INTO gaze_vpl VALUES ("DT6_9","006_6_9","DEU","6","9","9","ምችችለወን በልበለ መነኬቲቲፊ ከረወንኬረትስ እሳን በሬስ። ");
INSERT INTO gaze_vpl VALUES ("DT6_10","006_6_10","DEU","6","10","10","ዬሮ ዋቀዮ ዋቅንኬ ብየ መጋላወን ጉርጉዳፊ በበሬዶ ከኔን አት ህንእጃርን ሲፍ ኬኑፍ ገረ ብየ አቦቲኬ ጄቹንስ አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ ከከቴ ሰነት ስ ገልቹት፣ ");
INSERT INTO gaze_vpl VALUES ("DT6_11","006_6_11","DEU","6","11","11","ዬሮ መኔን ምአ ጎሰ ሁንዳ ከን አት ህንጉተትኒን ጉተሜ፣ ቦለ ብሻኒ ከን አት ህንቆትን፣ ሙኬን ወይኒቲፊ ኤጄርሳ ከኔን አት ህንዻብን ሲፍ ኬነመኒ አትስ ኛቴ ቁፍቱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT6_12","006_6_12","DEU","6","12","12","አት አከ ዋቀዮ ብየ ግብጥ፣ ብየ ገርቡማቲ ስ ባሴ ሰነ ህንደገትኔ ኦፍ ኤገዹ። ");
INSERT INTO gaze_vpl VALUES ("DT6_13","006_6_13","DEU","6","13","13","ዋቀዮን ዋቀኬ ሶዳዹ፤ እሱመ ቆፈ ተጃጅል፤ መቃሳቲንስ ከከዹ። ");
INSERT INTO gaze_vpl VALUES ("DT6_14","006_6_14","DEU","6","14","14","ዋቆተ ብራ ጄቹንስ ዋቆተ ሰቦተ ናኖኬቲ ዱካ ህንቡእን፤ ");
INSERT INTO gaze_vpl VALUES ("DT6_15","006_6_15","DEU","6","15","15","ሰበቢ ዋቀዮ ዋቅንኬ እን ግዱኬ ጅራቱ ሱን ዋቀ ህናፉ ተኤፍ፣ ኣሪንሳ ስረት ቦበኤ ለፈራ ስ በሌሰ። ");
INSERT INTO gaze_vpl VALUES ("DT6_16","006_6_16","DEU","6","16","16","አከ ማሳህ ኬሰት ጎተን ሰነ ዋቀዮ ዋቀኬሰን ህንቆርና። ");
INSERT INTO gaze_vpl VALUES ("DT6_17","006_6_17","DEU","6","17","17","አጀጀወን ዋቀዮ ዋቀኬሰኒ፣ ቀጄልፈመወኒፊ ሴረወን እን እስኒፍ ኬኔ አከ ጋሪት ኤጋ። ");
INSERT INTO gaze_vpl VALUES ("DT6_18","006_6_18","DEU","6","18","18","አከ ስት ቶሉፊ አከ ብየ ጋሪ ዋቀዮ አቦቲኬቲፍ ኬኑፍ ከከቴ ሰነ ሴንቴ ዻልቱፍ ዋን ፉለ ዋቀዮ ዱረት ቀጄላፊ ጋሪ ተኤ ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT6_19","006_6_19","DEU","6","19","19","አት አኩመ ዋቀዮ ጄዼ ሰነት ዲኖተኬ ሁንደ ፉለኬ ዱራ ንባፍተ። ");
INSERT INTO gaze_vpl VALUES ("DT6_20","006_6_20","DEU","6","20","20","ገረ ፉል-ዱራት ዮ እልምኬ፣ “ሂካን ቀጄልቸወኒ፣ አጀጀወኒቲፊ ሴረወን ዋቀዮ ዋቅንኬኘ እስን አጀጄ ከና ማል?” ጄዼ ስ ጋፈቴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT6_21","006_6_21","DEU","6","21","21","አከነ ጄዺ እት ህም፤ “ኑ ግብጥት ገርቦተ ፈረኦን ቱሬ፤ ዋቀዮ ገሩ ሀርከ ጀባዻን ግብጢ ባሴ ኑ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("DT6_22","006_6_22","DEU","6","22","22","ዋቀዮ ፉሉመኬኘ ዱረት ብየ ግብጥት፣ ፈረኦኒፊ ነሞተ መነሳ ኬሰ ጅራተን ሁንደረት መለቶፊ ድንቂወን ሶዳችሳፊ ጉርጉዳ ሆጄቴ። ");
INSERT INTO gaze_vpl VALUES ("DT6_23","006_6_23","DEU","6","23","23","እን ገሩ ብየ አቦቲኬኛፍ ከኩዻን ዋዳ ገሌ ሰነት ኑ ገልቼ ኑ ዻልችሱፍ ጄዼ አቺ ባሴ ኑ ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("DT6_24","006_6_24","DEU","6","24","24","ዋቀዮ አከ ኑ አኩመ አመ ጅሩ ከነት ዬሮ ሁንደ ኑት ቶሌ ጅራኑፍ አከ ኑ አጀጀወን ከኔን ሁንደ ኤግኑፊ አከ ዋቀዮ ዋቀኬኘ ሶዳትኑ ኑ አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("DT6_25","006_6_25","DEU","6","25","25","ኑ ዮ አኩመ እን ኑ አጀጄት ሴረ ከነ ሁንደ ፉለ ዋቀዮ ዋቀኬኛ ዱረት ኦፍ ኤገናዻን ኤግኔ፣ ሱን ቀጄሉማኬኘ ተአ።” ");
INSERT INTO gaze_vpl VALUES ("DT7_1","006_7_1","DEU","7","1","1","ዮሙ ዋቀዮ ዋቅንኬ ብየ አት ዻሉፍ እት ገላ ጅርቱ ከነት ስ ፍዴ ሰቦተ ሄዱ ጄቹንስ ሄቶተ፣ ግርጋሾተ፣ አሞሮተ፣ ከነኣኖተ፣ ፌርዞተ፣ ሂዎታፊ ዬቡሶተ ጄቹንስ ሰቦተ እስን ጫላ ጉርጉዳፊ ጀጀቦ ቶርበ ፉለኬ ዱራ አርኤ ባሱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT7_2","006_7_2","DEU","7","2","2","ዮሙ ዋቀዮ ዋቅንኬ ደበርሴ እሳን ሲፍ ኬኔ አትስ እሳን ሞአቱት፣ ጉቱማን ጉቱት እሳን በርበዴስ። እሳን ወጅን ከኩ ቶኮሌ ህንሴንን፤ ገራስሳኒ ህንላፍን። ");
INSERT INTO gaze_vpl VALUES ("DT7_3","006_7_3","DEU","7","3","3","እሳንት ህንሶዶምን፤ እልማንሳኒቲፍ እንተለንኬ ህንኬንን ዮካን እንተለንሳኒ እልማንኬቲፍ ህንፍድን፤ ");
INSERT INTO gaze_vpl VALUES ("DT7_4","006_7_4","DEU","7","4","4","ሰበቢንሳስ እሳን እልማንኬ ነ ዱካ ቡኡራ ዴብሰኒ አከ እሳን ዋቆተ ብራ ተጃጅለን ጎዹ፤ ዼከምስ ዋቀዮስ ስት ቦበኤ ደፌ ስ በሌሰ። ");
INSERT INTO gaze_vpl VALUES ("DT7_5","006_7_5","DEU","7","5","5","ወን እስን እሳን ጎቹ ቀብደን ከነ፦ እዶወን ኣርሳሳኒ ዲጋ፤ ሲዳወን ዋቄፈትናሳኒ ጨጨብሳ፤ ኡቱባወን ኣሼራሳኒስ ጅጅግሳ፤ ዋቆተሳኒስ እብዳን ጉባ። ");
INSERT INTO gaze_vpl VALUES ("DT7_6","006_7_6","DEU","7","6","6","አት ሰበ ዋቀዮ ዋቀኬቲፍ ቁልቁሉ ታቴዸ። ዋቀዮ ዋቅንኬ አከ አት ሰበሳቲፊ ቀቤኘሳ ጃለተማ ታቱፍ ጄዼ ሰቦተ ለፈረ ጅራተን ሁንደ ኬሳ ስ ፍለቴ። ");
INSERT INTO gaze_vpl VALUES ("DT7_7","006_7_7","DEU","7","7","7","ወን ዋቀዮ እስን ጃለቴ እስን ፍለቴፍ ዋን እስን ሰቦተ ካን ጫላ ባይኤ ታተኒፍ ምት፤ እስን ሰቦተ ሁንደ ጫላ ጥኖ ቱርተን። ");
INSERT INTO gaze_vpl VALUES ("DT7_8","006_7_8","DEU","7","8","8","ገሩ ወን ዋቀዮ ሀርከ ጀባዻን እስን ባሴ ብየ ገርቡማቲፊ እሬ ፈረኦን ሞትቸ ግብጥ ጀላ እስን ፉሬፍ ሰበቢ እስን ጃለቴ ከኩ አቦቲኬሰን ወጅን ገሌ ሰነ ኤጌፍ። ");
INSERT INTO gaze_vpl VALUES ("DT7_9","006_7_9","DEU","7","9","9","ከናፉ አከ ዋቀዮ ዋቅንኬ ዋቀ ተኤ ቤክ፤ እን ዋቀ አመነማ ወረ እሰ ጃለተኒ አጀጀሳስ ኤገኒፍ ከኩፊ አራረሳ ሀመ ዸሎተ ኩማት ኤጉዸ። ");
INSERT INTO gaze_vpl VALUES ("DT7_10","006_7_10","DEU","7","10","10","ወረ እሰ ጅበን ገሩ፣ በሌሱፍ ገቲሳኒ መታሳኒት ዴብሰ፤ ነመ እሰ ጅቡስ ገቲሳ መታሳት ዴብሱዻፍ ለፈረ ህንሀርክፈቱ። ");
INSERT INTO gaze_vpl VALUES ("DT7_11","006_7_11","DEU","7","11","11","ከናፉ አት አጀጀወን፣ ቀጄልቸወኒፊ ሴረወን አን ሀርአ ሲፍ ኬኑ ከኔን ኤግ። ");
INSERT INTO gaze_vpl VALUES ("DT7_12","006_7_12","DEU","7","12","12","ዮ አት ሴረወን ከኔኒፍ ጥዬፈትና ኬንቴ ኦፍ ኤገናዻን ዱካ ቡቴ፣ ዋቀዮ ዋቅንኬ አኩመ አቦቲኬቲፍ ከከቴ ሰነ ከኩፊ አራረሳ ሲፍስ ንኤገ። ");
INSERT INTO gaze_vpl VALUES ("DT7_13","006_7_13","DEU","7","13","13","እን ስ ጃለተ፤ ስ ኤብሰ፤ ስ ባይእሰስ። ብየ ሲፍ ኬኑፍ አቦቲኬቲፍ ከኩ ገሌ ኬሰት እጀ ገራኬቲ፣ ኦምሸ ለፈኬቲ ጄቹንስ ምዻን፣ ወይኒ ሃራፊ ዘይቲ፣ ጀቢወን ሎንኬቲ፣ ጦባላወን ቡሻዬኬቲ ሲፍ ኤብሰ። ");
INSERT INTO gaze_vpl VALUES ("DT7_14","006_7_14","DEU","7","14","14","አት ሰቦተ ከምዩ ጫላ ንኤብፈምተ፤ ዺረ ዮካን ዱበርቲኬ ኬሳ ቶኮሌ እጆሌ ህንዸቡ ዮካን ሎንኬ ኬሳ ቶኮሌ ህንመሴኑ። ");
INSERT INTO gaze_vpl VALUES ("DT7_15","006_7_15","DEU","7","15","15","ዋቀዮ ዹኩበ ሁንደ ስራ ፉዸ። እን ዹኩቦተ ሱከኔሳ አት ብየ ግብጥት አርግቴ ሰነ ወረ ስ ጅበንት ፍደ መሌ ስት ህንፍዱ። ");
INSERT INTO gaze_vpl VALUES ("DT7_16","006_7_16","DEU","7","16","16","አት ሰቦተ ዋቀዮ ዋቅንኬ ደበርሴ ስት ኬኑ ሁንደ በሌሱ ቀብደ። አት እሳኒፍ ገራ ህንላፍን፤ ኩን ክዮ ስት ተኣቲ ዋቆተሳኒ ህንዋቄፈትን። ");
INSERT INTO gaze_vpl VALUES ("DT7_17","006_7_17","DEU","7","17","17","አት፣ “ሰቦትን ኩኔን ኑ ጫላ ጀጀቦዸ፤ ኑ አከምት እሳን ባፍነ?” ጄቴ ያደ ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT7_18","006_7_18","DEU","7","18","18","ገሩ አት እሳን ህንሶዳትን፤ ዋን ዋቀዮ ዋቅንኬ ፈረኦኒፊ ጉቱማ ግብጥት ሆጄቴ ሰነ ያደዹ። ");
INSERT INTO gaze_vpl VALUES ("DT7_19","006_7_19","DEU","7","19","19","አት ቆርማተወን ጉርጉዳ፣ መለቶወኒፊ ድንቂወን፣ ሀርከ ጀባፊ እሬ ድሪርፈሜ ከን ዋቀዮ ዋቅንኬ እቲን ስ ባሴ ሰነ እጁመኬቲን አርግቴርተ። ዋቀዮ ዋቅንኬ ሰቦተ አት አመ ሶዳቱ ሁንደስ አከሱመ ጎዸ። ");
INSERT INTO gaze_vpl VALUES ("DT7_20","006_7_20","DEU","7","20","20","ከነ ጫላዩ ዋቀዮ ዋቅንኬ ሀመ ወር ሉቡዻን ሀፈኒ ስ ዱራ ዾከተንዩ በርበዳአንት ግዱሳኒት ሶንሰ ንኤርገ። ");
INSERT INTO gaze_vpl VALUES ("DT7_21","006_7_21","DEU","7","21","21","ሰበቢ ዋቀዮ ዋቅንኬ እን ግዱኬ ጅሩ ሱን ዋቀ ጉዳፊ ሶዳችሳ ተኤፍ እሳን ህንሶዳትን። ");
INSERT INTO gaze_vpl VALUES ("DT7_22","006_7_22","DEU","7","22","22","ዋቀዮ ዋቅንኬ ሰቦተ ሰነ ጥኖ ጥኖዻን ፉለኬ ዱራ ንባሰ፤ አከ ብኔንሶትን ቦሶና ናኖኬት ህንባይአኔፍ ዬሩመ ቶኮት እሳን በሌሱን ሲፍ ህንኤየመሙ። ");
INSERT INTO gaze_vpl VALUES ("DT7_23","006_7_23","DEU","7","23","23","ዋቀዮ ዋቅንኬ ገሩ ሀመ እሳን በደንት እሳን ራቴሱዻን ደበርሴ ሀርከኬት እሳን ኬነ። ");
INSERT INTO gaze_vpl VALUES ("DT7_24","006_7_24","DEU","7","24","24","ሞቶተሳኒስ ደበርሴ ስት ኬነ፤ አትስ መቃሳኒ ሰሚ ጀላ ንበሌስተ። ሀመ አት እሳን በሌስቱት ነምን ፉለኬ ዱረ ዻበቹ ደንደኡ ቶኮዩ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT7_25","006_7_25","DEU","7","25","25","ፈኪ ዋቆተሳኒ እብዳን ጉብ፤ ሜቲፊ ወርቄ እሳንረ ጅሩ ህንሀውን፤ ኦፊኬቲፍስ ህንፉዸትን፤ ዮ ከና አቺ እን ሰበቢ ፉለ ዋቀዮ ዋቀኬቲ ዱረት ጅብሲሳ ተኤፍ ክዮ ስት ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT7_26","006_7_26","DEU","7","26","26","ዋን ጅብሲሳ ገረ መነኬቲት ህንገልችን፤ ዮ ከና አቺ አትስ አኩመሳ በዲሳፍ አዳን ባፈምተ። ዋን እን በዲሳፍ አዳን ባፈሜፍ አት ጉቱማን ጉቱት እሰ ጅብ፤ በልፍስ። ");
INSERT INTO gaze_vpl VALUES ("DT8_1","006_8_1","DEU","8","1","1","እስን አከ ሉቡን ጅራተን፣ አከ ባይአተኒፊ አከ ብየ ዋቀዮ ከኩዻን አቦቲኬሰን አብደቺሴ ሰነት ገልተኒ ዻልተኒፍ አጀጀ አን ሀርአ ሲፍ ኬኑ ሁንደ ኦፍ ኤገናዻን ዱካ ቡኣ። ");
INSERT INTO gaze_vpl VALUES ("DT8_2","006_8_2","DEU","8","2","2","ዋቀዮ ዋቅንኬ ገድ ስ ቀቤ ስ ቆሩዻን ዋን ገራኬ ኬሰ ጅሩ ጄቹንስ አከ አት አጀጀወንሳ ኤግዱፊ ህንኤግኔ ቤኩፍ ከራ እን ወጎተ አፉርተመን ከኔን ጉቱ ገሞጂ ኬሰ ስ ቀጄልቼ ያደዹ። ");
INSERT INTO gaze_vpl VALUES ("DT8_3","006_8_3","DEU","8","3","3","እንስ ገድ ስ ዴብሴ ስ ቤሌሴ “መና” አት ዮካን አቦቲንኬ ህንቤክን ስ ሶሬ፤ ኩንስ አከ ነምን ዱቢ አፋን ዋቀዮቲ በኡ ሁንዳን መሌ ቡዴነ ቆፋን ህንጅራትኔ ስ በርሲሱፍ። ");
INSERT INTO gaze_vpl VALUES ("DT8_4","006_8_4","DEU","8","4","4","ወጎተ አፉርተመን ከኔን ኬሰ ኡፈትንኬ ህንዹምኔ፤ ሚልኬስ ህንኢቶፍኔ። ");
INSERT INTO gaze_vpl VALUES ("DT8_5","006_8_5","DEU","8","5","5","አከ ዋቀዮ ዋቅንኬ አኩመ አባን እልመሳ አደበቱ አከ ስ አደቡ ቤክ። ");
INSERT INTO gaze_vpl VALUES ("DT8_6","006_8_6","DEU","8","6","6","ዳንዲወንሳረ ዴሙፊ እሰ ሶዳቹዻን አጀጀወን ዋቀዮ ዋቀኬቲ ኤግ። ");
INSERT INTO gaze_vpl VALUES ("DT8_7","006_8_7","DEU","8","7","7","ዋቀዮ ዋቅንኬ ብየ ጋሪ ከን ለጌን፣ ሀሮወኒፊ ቡርቃወን ሱሉሎታፊ ጋረን ኬሳ ያአኒት ስ ገልቻቲ። ");
INSERT INTO gaze_vpl VALUES ("DT8_8","006_8_8","DEU","8","8","8","ብየ ቀመዲፊ ገርቡ፣ ወይኒፊ ሀርቡ፣ ሮማኒ፣ ዘይቲ ኤጄርሳቲፊ ደመ ባሱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT8_9","006_8_9","DEU","8","9","9","ብየ አት ህርእነ መሌ ቡዴነ ኛቱፊ ብየ አት ኬሳ ሆማ ህንዸብኔ፣ ብየ ከታን ስቢለ ተኤ፣ ብየ አት ጋረን ኬሳ ስቢለ ዲማ ባሱ ደንዴሱዸ። ");
INSERT INTO gaze_vpl VALUES ("DT8_10","006_8_10","DEU","8","10","10","ዬሮ ኛቴ ቁፍቱት፣ ሰበቢ ዋቀዮ ዋቅንኬ ብየ ጋሪ አከሲ ሲፍ ኬኔፍ እሰ ጀጀዹ። ");
INSERT INTO gaze_vpl VALUES ("DT8_11","006_8_11","DEU","8","11","11","አት አከ አጀጀወን፣ ቀጄልፈመወኒፊ ሴረወንሳ ከኔን አን ሀርአ ሲፍ ኬኑ ኤጉ ባቹዻን ዋቀዮ ዋቀኬ ህንደገትኔ ኦፍ ኤገዹ። ");
INSERT INTO gaze_vpl VALUES ("DT8_12","006_8_12","DEU","8","12","12","ዮ ከና አቺ ዮሙ ኛቴ ቁፍቱት፣ ዮሙ መነ ጋሪ እጃረቴ ኬሰ ጅራቱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT8_13","006_8_13","DEU","8","13","13","ዮሙ ሎኒፊ ቡሻዬንኬ ወል ሆረኒ ሜቲፊ ወርቄንኬ ደበሉፊ ዮሙ ወን አት ቀብዱ ሁንድ ባይአቱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT8_14","006_8_14","DEU","8","14","14","አት ኦፍ ቱልቴ ዋቀዮ ዋቀኬ እሰ ብየ ግብጥ፣ ብየ ገርቡማቲ ባሴ ስ ፍዴ ሰነ ንደገተ። ");
INSERT INTO gaze_vpl VALUES ("DT8_15","006_8_15","DEU","8","15","15","እን ገሞጂ በልኣፊ ሶዳችሳ፣ ብየ ዼቡቲፊ ከን ብሻን ህንቀብኔ፣ ብየ ቦፈ ሀዻ ቀቡፊ ቶርባንቀባን ኬሰ ጉቴ ሰነ ኬሰ ስ ዴምስሴ። ከታ ጀባ ኬሳስ ብሻን ሲፍ ቡርቅሲሴ። ");
INSERT INTO gaze_vpl VALUES ("DT8_16","006_8_16","DEU","8","16","16","አከ ዹመረት ስት ቶሉፍ ጄዼ ገድ ስ ቀቡፊ ስ ቆሩዻፍ፣ ዋን ተኩማ አቦቲንኬ ህንቤክን ገሞጂ ኬሰት “መና” አት ኛቱ ሲፍ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT8_17","006_8_17","DEU","8","17","17","አት፣ “ሁምነኮቲፊ ጀብነ ሀርከኮቱ ቀቤኘ ከነ ናፍ አርገምሲሴ ጄቴ” ያደ ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT8_18","006_8_18","DEU","8","18","18","ገሩ ዋቀዮ ዋቀኬ ያደዹ፤ ከን አኩመ ሀርአ ጅሩ ከነት አከ አት ቀቤኘ ሆረቱፍ ደንዴቲ ሲፍ ኬኔ ዋዳ ከኩዻን አቦቲኬቲፍ ገሌ ሰነ ሲፍ ኤጌሳቲ። ");
INSERT INTO gaze_vpl VALUES ("DT8_19","006_8_19","DEU","8","19","19","ዮ አት ዋቀዮ ዋቀኬ እራንፈቴ ዋቆተ ብራ ዱካ ቡቴ፣ ዮ እሳን ዋቄፈቴፊ እሳኒፍ ሰገዴ አከ እስን ዹጉማን በደን አን ሀርአ ዹጋ እስንት ነንበአ። ");
INSERT INTO gaze_vpl VALUES ("DT8_20","006_8_20","DEU","8","20","20","አኩመ ሰቦተ ዋቀዮ ፉለኬሰን ዱራ በሌሴ ሰና ዋቀዮ ዋቀኬሰኒፍ ዋን አጀጀሙ ድደኒፍ አከሱመ እስንስ ንበሌፈምቱ። ");
INSERT INTO gaze_vpl VALUES ("DT9_1","006_9_1","DEU","9","1","1","ያ እስራኤል ዸገእ። አት ሰቦተ ስ ጫላ ጉርጉዳፊ ሁምነ ቀቤዪ፣ መጋላወን ደላ ሰሚ ገኡን መርፈመን ቀበን አቺ ባፍቴ ዻሉፍ ዮርዳኖስ ጬኡፍ ጅርተ። ");
INSERT INTO gaze_vpl VALUES ("DT9_2","006_9_2","DEU","9","2","2","ነሞትን ሱን እልማን አናቅ ወረ ጀጀቦፊ ዼዼሮዸ! አትስ ዋኤሳኒ ንቤክተ፤ አከ፣ “ኤኙቱ አናቆተ ዱረ ዻበቹ ደንደአ?” ጄዸሙሌ ዸጌሴርተ። ");
INSERT INTO gaze_vpl VALUES ("DT9_3","006_9_3","DEU","9","3","3","ተኡስ ከን አኩመ እብደ ዋ ጉቤ ፍጡ ስ ዱረ ጬኡ ዋቀዮ ዋቀኬ ተኡሳ ሀርአ ቤክ። እን እሳን በሌሰ፤ ፉለኬ ዱረትስ ገድ እሳን ዴብሰ። አትስ አኩመ ዋቀዮ ስ አብደቺሴ ሰነት አሪቴ እሳን ባፍተ፤ ደፍቴስ እሳን ፍጠ። ");
INSERT INTO gaze_vpl VALUES ("DT9_4","006_9_4","DEU","9","4","4","ኤርገ ዋቀዮ ዋቅንኬ ፉለኬ ዱራ አርኤ እሳን ባሴ ቦዴ አት ገራኬት፣ “ዋቀዮ ሰበቢ ቀጄሉማኮቲፍ አከ አን ብየ ከነ ዻሉ አስ ነ ፍዴ” ህንጄዽን። ዋቀዮ ሰበቢ ሀምነሳኒቲፍ ሰቦተ ከኔን ፉለኬ ዱራ አርኤ ባሰ። ");
INSERT INTO gaze_vpl VALUES ("DT9_5","006_9_5","DEU","9","5","5","አት ብየሳኒት ገልቴ ከን ዻልቱ ቀጄሉማኬቲን ዮካን ጋሩማ ገራኬቲቲን ኡቱ ህንተእን ዋቀዮ ከኩ አቦቲኬ አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ ገሌ ሰነ ጉቱዻፍ ጄዼ ዋቀዮ ዋቅንኬ ሰቦተ ከኔን ሰበቢ ሀምነሳኒቲፍ ፉለኬ ዱራ አርኤ ባሰ። ");
INSERT INTO gaze_vpl VALUES ("DT9_6","006_9_6","DEU","9","6","6","ኤጋ ዋቀዮ ዋቅንኬ ከን ብየ ጋሪ ከነ አከ ዻልቱፍ ሲፍ ኬኑ ሰበቢ ቀጄሉማኬቲቲፍ አከ ህንተእን ሁበዹ፤ አት ሰበ መተ ጀቤሳቲ። ");
INSERT INTO gaze_vpl VALUES ("DT9_7","006_9_7","DEU","9","7","7","አት አከምት አከ ገሞጂ ኬሰት ዋቀዮ ዋቀኬ ዼከምሳፍ ከካፍቴ ያደዹ፤ ህንደገትንስ። አት ጋፈ ብየ ግብጢ ባቴ ጀልቀብዴ ሀመ አስ ጌሱት ዋቀዮት ፍንጭላ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("DT9_8","006_9_8","DEU","9","8","8","እስን ኮሬብትዩ ዋቀዮን ዼከምሳፍ ከካስናን ዋቀዮ እስን በርበዴሱፍ እስንት ኣሬ። ");
INSERT INTO gaze_vpl VALUES ("DT9_9","006_9_9","DEU","9","9","9","አን ዬሮ ገበቴወን ዸጋ ጄቹንስ ገበቴወን ከኩ ዋቀዮ እስን ወጅን ገሌ ሰና ፉዹፍ ቱሉት ኦል በኤት ጉያ አፉርተማፊ ሀልከን አፉርተመ ቱሉ ሰነ እረን ቱሬ፤ አን ቡዴነ ቶኮሌ ህንኛትኔ፤ ብሻንሌ ህንዹግኔ። ");
INSERT INTO gaze_vpl VALUES ("DT9_10","006_9_10","DEU","9","10","10","ዋቀዮስ ገበቴወን ዸጋ ለመ ከኔን ቁበ ዋቀዮቲን እረት በሬፈሜ ነት ኬኔ። አጀጀወን ዋቀዮ ዬሮ እስን ወልት ቀበምተንት ቱሉረት እብደ ኬሳ እስንት ለብሴ ሁንድ ገበቴወን ሰነረ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("DT9_11","006_9_11","DEU","9","11","11","ዹመ ጉያ አፉርተማቲፊ ሀልከን አፉርተማት ዋቀዮ ገበቴወን ዸጋ ለመ ጄቹንስ ገበቴወን ከኩ ነት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT9_12","006_9_12","DEU","9","12","12","ጋፈስ ዋቀዮ አከነ ናን ጄዼ፤ “ከኢ ደፊ ገድ ቡእ፤ ሰብንኬ ከን አት ብየ ግብጢቲ ባፍቴ ፍዴ ሱን ጡራኤራቲ። እሳን ዋን አን እሳን አጀጄራ ደፈኒ ገረ ገለኒ ኦፊሳኒቲፍ ዋቀ በቅፈሜ ሆጄተሜ ቶልፈተኒሩቲ።” ");
INSERT INTO gaze_vpl VALUES ("DT9_13","006_9_13","DEU","9","13","13","ዋቀዮ አመስ አከነ ናን ጄዼ፤ “አን ሰበ ከነ አርጌረ፤ ኩኖ እን ሰበ መተ ጀቤሰ! ");
INSERT INTO gaze_vpl VALUES ("DT9_14","006_9_14","DEU","9","14","14","አከ አን እሳን በሌሴ መቃሳኒሌ ሰሚ ገዲ ሀቁፍ ነ ዺስ፤ ስእሞ እሳን ጫላ ሰበ ጉዳፊ ጀባ ነንጎዸ።” ");
INSERT INTO gaze_vpl VALUES ("DT9_15","006_9_15","DEU","9","15","15","አንስ ኦፍረ ገረገሌ ኡቱመ ቱሉን ሱን ቦበኣ ጅሩ ቱሉራ ገድ ነንቡኤ። ገበቴወን ከኩ ለማን ሱንስ ነ ሀርከ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("DT9_16","006_9_16","DEU","9","16","16","አንስ ነንአርጌ፤ ኩኖ እስን ዋቀዮ ዋቀኬሰንት ጩቡ ሆጄተኒ ቱርተን፤ እስን ብፈ ጀቢቲን ዋቀ በቅፈሜ ሆጄተሜ ኦፊኬሰኒፍ ቶልፈተኒ ቱርተን። እስን ደፍተኒ ከራ ዋቀዮ እስን አጀጄራ ጀልአተን። ");
INSERT INTO gaze_vpl VALUES ("DT9_17","006_9_17","DEU","9","17","17","ከናፉ አን ገበቴወን ለማን ሰነ ሀርከኮራ ደርበዼ እጁመኬሰን ዱረት ነንጨጨብሴ። ");
INSERT INTO gaze_vpl VALUES ("DT9_18","006_9_18","DEU","9","18","18","ሰበቢ ጩቡ እስን ሆጄተን ሁንዳ ከን እስን ፉለ ዋቀዮ ዱረት ዋን ሀማ ሆጄቹዻን ዼከምሳፍ እሰ ከካፍተን ሰናቲፍ አን አመስ ፉለ ዋቀዮ ዱረት ጎምብፈሜ ኡቱን ቡዴነ ህንኛትኒፊ ብሻን ህንዹግን ጉያ አፉርተማፊ ሀልከን አፉርተመን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT9_19","006_9_19","DEU","9","19","19","ሰበቢ እን እስን በሌሱፍ ኣሬ ቱሬፍ፣ አን ኣሪፊ ዼከምሰ ዋቀዮ ነንሶዳዼ። ዋቀዮ ገሩ አመሌ ነ ዸገኤ። ");
INSERT INTO gaze_vpl VALUES ("DT9_20","006_9_20","DEU","9","20","20","ዋቀዮ አሮንን በሌሱፍ አከ መሌ እት ኣሬ ቱሬ፤ አን ገሩ ዬሮ ሰነ አሮኒፍስ ነንከዸዼ። ");
INSERT INTO gaze_vpl VALUES ("DT9_21","006_9_21","DEU","9","21","21","አከሱመስ አን ጩቡኬሰን ብፈ ጀቢ እስን ቶልፈተን ሰና ፉዼ እብዳን ነንጉቤ። ጨጨብሴስ ሀመ እን ቡላኣ አከ አዋራ ተኡት ቡሌሴ ቡርቃ ቱሉራ ገድ ያኡተን ፍርፍርሴ። ");
INSERT INTO gaze_vpl VALUES ("DT9_22","006_9_22","DEU","9","22","22","እስንስ ተቤራት፣ ማሳሂፊ ቂብሮት ሀታዋት ዋቀዮ ዼከምሲፍተን። ");
INSERT INTO gaze_vpl VALUES ("DT9_23","006_9_23","DEU","9","23","23","ዋቀዮ ዮሙ ቃዴሽ በርኔቲ እስን ባሴት፣ “ኦል በኣቲ ብየ አን እስኒፍ ኬኔ ሰነ ዻላ” እስኒን ጄዼ። እስን ገሩ አጀጀ ዋቀዮ ዋቀኬሰኒት ፍንጭልተን። እሰስ ህንአመኔ፤ ህንአጀጀምኔፍስ። ");
INSERT INTO gaze_vpl VALUES ("DT9_24","006_9_24","DEU","9","24","24","እስን ኤርገ አን እስን ቤኬ ጀልቀብደኒ ዋቀዮት ፍንጭልተኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("DT9_25","006_9_25","DEU","9","25","25","ሰበቢ ዋቀዮ አከ እስን በሌሱ ዱበቴ ቱሬፍ አን ጉያ አፉርተማፊ ሀልከን አፉርተመን ሰነ ፉለ ዋቀዮ ዱረት ለፈት ነንጎምብፈሜ። ");
INSERT INTO gaze_vpl VALUES ("DT9_26","006_9_26","DEU","9","26","26","አንስ አከነ ጄዼን ዋቀዮን ከዸዼ፤ “ያ ዋቀዮ ጎፍታ፣ አት ሰበኬ፣ ዻለኬ ከን ሁምነኬ ጉድቻፊ ሀርከኬ ጀባዻን ፉርቴ ብየ ግብጢ ባፍቴ ከነ ህንበሌስን። ");
INSERT INTO gaze_vpl VALUES ("DT9_27","006_9_27","DEU","9","27","27","ገርቦተኬ አብረሃም፣ ይስሃቂፊ ያቆብን ያደዹ። መተ ጀብነ ሰበ ከና፣ ሀምነሳቲፊ ጩቡሳ ህንእላልን። ");
INSERT INTO gaze_vpl VALUES ("DT9_28","006_9_28","DEU","9","28","28","ዮ ከና አቺ ብይ አት ኬሳ ኑ ባፍቴ ሱን፣ ‘ዋቀዮ ዋን ብየ ዋዳ እሳኒፍ ገሌ ሰነት እሳን ገልቹ ህንደንዴኜፊ ዋን እሳን ጅቤፍ ገሞጂ ኬሰት እሳን ፍጡፍ እሳን ባሴ’ ጄዸ። ");
INSERT INTO gaze_vpl VALUES ("DT9_29","006_9_29","DEU","9","29","29","እሳን ገሩ ሰበኬቲፊ ዻለኬ ከን አት ሁምነ ጀባፊ እሬ ድሪርፈሜን ባፍቴ ፍዴዸ።” ");
INSERT INTO gaze_vpl VALUES ("DT10_1","006_10_1","DEU","10","1","1","ዬሮ ሰነስ ዋቀዮ አከነ ናን ጄዼ፤ “ገበቴወን ዸጋ ከኔን ገበቴወን ጀልቀባ ፈካተን ለመ ሶፊቲ ቱሉት ኦል በኢ ነ ብረ ኮቱ። ታቦተ ሙካስ ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT10_2","006_10_2","DEU","10","2","2","አንስ ዱቢ ገበቴወን ጀልቀባ ከኔን አት ጨጨብስቴ ሰነረ ቱረን ገበቴወን ከኔንረት ነንበሬሰ። አትስ ታቦተ ኬሰ እሳን ኬሰ።” ");
INSERT INTO gaze_vpl VALUES ("DT10_3","006_10_3","DEU","10","3","3","አን ሙከ ላፍቶራ ታቦተ ቶልቼ ገበቴወን ዸጋ ለመ አኩመ ከኔን ጀልቀባት ነንሶፌ፤ ገበቴወን ለማንስ ሀርከት ቀበዼ ቱሉ ሰነት ኦል ነንበኤ። ");
INSERT INTO gaze_vpl VALUES ("DT10_4","006_10_4","DEU","10","4","4","ዋቀዮ ጉያ ወል ገኢ ሰነ ቱሉራ አጀጀወን ኩርነን እብደ ኬሳ እስንት ዱበቴ ሰነ አኩመ በሬፈመ ዱራት ገበቴወን ከኔንረት በሬሴ፤ ዋቀዮስ ገበቴወን ከኔን ነት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT10_5","006_10_5","DEU","10","5","5","አንስ ቱሉ ሰነራ ገድ ቡኤ አኩመ ዋቀዮ ነ አጀጄት ገበቴወን ሰነ ታቦተ እሰ አን ሆጄዼ ቱሬ ኬሰ ነንካኤ፤ እሳንስ አመ አች ጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT10_6","006_10_6","DEU","10","6","6","እስራኤሎንስ ብኤሮት ቤኔ ያአካኒ ከአኒ ገረ ሞሴራት ቀጄለን። አሮንስ አችት ዱኤ አዋለሜ፤ እልምሳ ኤሌኣዛር እዶሳ ቡኤ ሉበ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("DT10_7","006_10_7","DEU","10","7","7","አቺ ከአኒ ጉድጎዳ ዸቀን፤ ኤርገሲስ ገረ ዮጥባታ ብየ ብሻኖተ ያአን ቀብዱት ደርበን። ");
INSERT INTO gaze_vpl VALUES ("DT10_8","006_10_8","DEU","10","8","8","ዬሮ ሰነት ዋቀዮ ጎሰ ሌዊ አከ እን ታቦተ ከኩ ዋቀዮ ባቱፍ፣ አከ ፉለ ዋቀዮ ዱረ ዻበቴ እሰ ተጃጅሉፊ አከ መቃሳቲን ኤብሱፍ ሀመ ሀርኣት አዳን ባሴ። ");
INSERT INTO gaze_vpl VALUES ("DT10_9","006_10_9","DEU","10","9","9","ሰበቢን ጎስት ሌዊ አከ ኦቦሎተሳ ግዱት ቆደ ዮካን ዻለ ህንቀባትኔ ጎዸሜፍስ ከኑመ። አኩመን ዋቀዮ ዋቅንኬ እሳንት ህሜት፣ ዋቀዮ ዻለሳኒት። ");
INSERT INTO gaze_vpl VALUES ("DT10_10","006_10_10","DEU","10","10","10","አመስ አን አኩመ ዬሮ ጀልቀባ ጎዼ ሰነ ጉያ አፉርተማፊ ሀልከን አፉርተመ ቱሉ ሰነ እረን ቱሬ፤ ዋቀዮ አመስ ነ ዸገኤ። እን ስ በሌሱዻፍ ፌዺ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("DT10_11","006_10_11","DEU","10","11","11","ዋቀዮስ፣ “ዴም፤ አከ እሳን ብየ አን አቦቲሳኒቲፍ ኬኑዻፍ ከከዼ ሰነ ሴነኒ ዻለኒፍ ሰበ ከነ ዱረ ቡኢ ዴም” ናን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("DT10_12","006_10_12","DEU","10","12","12","ያ እስራኤል፣ ወን ዋቀዮ ዋቅንኬ ስራ በርባዱ ማል? አከ አት ዋቀዮ ዋቀኬ ሶዳቱ፣ አከ ዳንዲሳ ሁንደረ ዴምቱ፣ አከ እሰ ጃለቱ፣ አከ ዋቀዮ ዋቀኬ ገራኬ ጉቱፊ ሉቡኬ ጉቱዻን ተጃጅልቱ፣ ");
INSERT INTO gaze_vpl VALUES ("DT10_13","006_10_13","DEU","10","13","13","አከ ሲፍ ቶሉፍ፣ አከ አት አጀጀወኒፊ ቀጄልቸወን ዋቀዮ ከኔን አን ሀርአ ሲፍ ኬኑ ኤግዱ ምቲ? ");
INSERT INTO gaze_vpl VALUES ("DT10_14","006_10_14","DEU","10","14","14","ኩኖ ሰሚን፣ ሰሚን ሰሚወኒ ኦሊ፣ ለፍቲፊ ወን እሼ ኬሰ ጅሩ ሁንድኑ ከን ዋቀዮ ዋቀኬቲት። ");
INSERT INTO gaze_vpl VALUES ("DT10_15","006_10_15","DEU","10","15","15","ተኡስ አኩመ ሀርአ ተኤ ጅሩ ከነ፣ ዋቀዮ ጃለላን ቀልቢሳ አቦቲኬሰንረ ቡፈቴ፤ እስን ወረ ሰኚሳኒ ታተንስ ሰቦተ ሁንደ ጫልችሴ ፍለቴ። ");
INSERT INTO gaze_vpl VALUES ("DT10_16","006_10_16","DEU","10","16","16","ከናፉ ቀልቢኬሰን ዸግነ ቀባ፤ ስ አችስ መታ ጀቤዪ ህንተእና። ");
INSERT INTO gaze_vpl VALUES ("DT10_17","006_10_17","DEU","10","17","17","ዋቀዮ ዋቅንኬሰን ዋቀ ዋቆታ፣ ጎፍታ ጎፍቶታ፣ ዋቀ ጉዳ፣ ጀባፊ ሶዳችሳ፣ ከን ነመ ወል ህንጫልችፍኔፊ ከን መተኣ ህንፉዸኔዻቲ። ");
INSERT INTO gaze_vpl VALUES ("DT10_18","006_10_18","DEU","10","18","18","እን እጆሌ አቦቲ ህንቀብኔፊ ኒቶተ ዽርሶትንሳኒራ ዱአኒፍ ንፈልመ፤ አለጎተስ ኛታፊ ኡፈተሳኒ ኬኑዻን ጃለተ። ");
INSERT INTO gaze_vpl VALUES ("DT10_19","006_10_19","DEU","10","19","19","አለጎተ ጃለዻ፤ እስን መታንኬሰን ብየ ግብጥት አለጎተ ቱርተኒቲ። ");
INSERT INTO gaze_vpl VALUES ("DT10_20","006_10_20","DEU","10","20","20","ዋቀዮ ዋቀኬ ሶዳዹ፤ እሰ ተጃጅልስ። እሰት መጠን፤ መቃሳቲንስ ከከዹ። ");
INSERT INTO gaze_vpl VALUES ("DT10_21","006_10_21","DEU","10","21","21","እን ኡልፍነኬት፤ እን ዋቀኬ ከን ድንቂወን ጉርጉዳፊ ሶዳችሳ አት እጀኬቲን አርግቴ ሰነ ሲፍ ሆጄቴዸ። ");
INSERT INTO gaze_vpl VALUES ("DT10_22","006_10_22","DEU","10","22","22","አቦቲንኬ ወር ግብጥት ገድ ቡአን ነመ ቶርባተመ ቱረን፤ አመ ገሩ ዋቀዮ ዋቅንኬ አከ ኡርጂ ሰሚ ኬሳ ስባይእሴረ። ");
INSERT INTO gaze_vpl VALUES ("DT11_1","006_11_1","DEU","11","1","1","ዋቀዮ ዋቀኬ ጃለዹ፤ ዬሮ ሁንደስ ፌዺሳ፣ ቀጄልቸወንሳ፣ ሴረወንሳቲፊ አጀጀወንሳ ኤግ። ");
INSERT INTO gaze_vpl VALUES ("DT11_2","006_11_2","DEU","11","2","2","ከን አደቢ ዋቀዮ ዋቀኬሰኒ፣ ሱራሳ፣ ሀርከሳ ጀባፊ እሬሳ ከን ድሪርፈሜ ቤኬ ዮካን አርጌ እስኑመ መሌ አከ እጆሌኬሰን ህንተእን ሀርአ ያደዻ። ");
INSERT INTO gaze_vpl VALUES ("DT11_3","006_11_3","DEU","11","3","3","መለቶወኒፊ ወንቶተ እን ግብጥ ኬሰት ፈረኦን ሞቲ ግብጢፊ ብየሳ ጉቱረት ሆጄቴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT11_4","006_11_4","DEU","11","4","4","ዋን እን ሎልቶተ ግብጥ፣ ፈርዴኒፊ ጋሪወንስ ጎዼ፣ ኡቱመ እሳን እስን ዱካ ቡአኑ አከ እን ገላነ ዲማዻን እሳን ሀጉጌ፣ አከ እት ዋቀዮ በዲሰ በረ በራ እሳንት ፍዴ ያደዻ። ");
INSERT INTO gaze_vpl VALUES ("DT11_5","006_11_5","DEU","11","5","5","ዋን እን ሀመ እስን እዶ ከነ ጌሰንት ለፈ ገሞጂ ኬሰት እስኒፍ ጎዼ ከን አርጌ እጆሌኬሰን ምት፤ ");
INSERT INTO gaze_vpl VALUES ("DT11_6","006_11_6","DEU","11","6","6","እሳን ዋን እን ጋፈ ለፍት አፋንሼ በነቴ ጉቱማ እስራኤል ግዱት ዳታኒፊ አቢራም እልማን ኤሊያብ ነምቸ ጎሰ ሩቤን ሰነ ማቲሳኒ ወጅን፣ ዱንካኖተሳኒቲፊ ቀቤኘሳኒ ከን ሉቡ ቀቡ ሁንደ ልቅምስቴት እሳን ጎዼ ህንአርግኔ። ");
INSERT INTO gaze_vpl VALUES ("DT11_7","006_11_7","DEU","11","7","7","እጅኬሰን ገሩ ዋን ጉዳ ዋቀዮ ጎዼ ከኔን ሁንደ አርጌረ። ");
INSERT INTO gaze_vpl VALUES ("DT11_8","006_11_8","DEU","11","8","8","ከናፉ እስን አከ ዮርዳኖሲን ጬተኒ ብየ ዻሉፍ ጅርተንት ገሉፍ ጀባተኒፍ አጀጀወን አን ሀርአ እስኒ ኬኑ ሁንደ ኤጋ፤ ");
INSERT INTO gaze_vpl VALUES ("DT11_9","006_11_9","DEU","11","9","9","ኩንስ አከ እስን ብየ ዋቀዮ አቦቲኬሰኒፊ ሰኚሳኒቲፍ ኬኑፍ ከከቴ ከን ኣነኒፊ ደመ ባሱ ሰነ ኬሰት በረ ዼራ ጅራተኒፍ። ");
INSERT INTO gaze_vpl VALUES ("DT11_10","006_11_10","DEU","11","10","10","ብይ አት ዻሉፍ እት ገላ ጅርቱ ኩን አከ ብየ ግብጥ ከን አት ኬሳ ባቴ ዹፍቴ ከን አት አኩመ ለፈ ብቅልቱት ሰኚኬ ፈጫፍቴ ሚለኬቲን ብሻን ኦባፍቴ ሰና ምት። ");
INSERT INTO gaze_vpl VALUES ("DT11_11","006_11_11","DEU","11","11","11","ብይ አት ዮርዳኖስ ጬቴ ዻልቱ ኩን ገሩ ብየ ቱሉወኒፊ ሱሉለወኒ ከን ሰሚዻ ቦካ አርገቱዸ። ");
INSERT INTO gaze_vpl VALUES ("DT11_12","006_11_12","DEU","11","12","12","ብይ ኩን ብየ ዋቀዮ ዋቅንኬ ኩኑንሱዸ፤ ጀልቀበ ወጋቲ ሀመ ዹመ ወጋትስ እጅ ዋቀዮ ዋቀኬቲ እሼራ ህንቡቀኡ። ");
INSERT INTO gaze_vpl VALUES ("DT11_13","006_11_13","DEU","11","13","13","ዮ አጀጀወን አን ሀርአ እስኒፍ ኬኑ አመነሙማዻን ኤግደን ጄቹንስ ዮ እስን ዋቀዮ ዋቀኬሰን ጃለተኒ ገራኬሰን ጉቱፊ ሉቡኬሰን ጉቱዻን እሰ ተጃጅልተን፣ ");
INSERT INTO gaze_vpl VALUES ("DT11_14","006_11_14","DEU","11","14","14","አከ አት ምዻንኬ፣ ወይኒኬቲፊ ዘይቲኬ ገልፈቱፍ አን ዬሮሳት ቦካ ብራቲፊ ቦካ አርፋሳ ለፈኬት ነንሮብሰ። ");
INSERT INTO gaze_vpl VALUES ("DT11_15","006_11_15","DEU","11","15","15","ሎንኬቲፍ መርገ በኬ ነንኬነ፤ አትስ ኛቴ ቁፍተ። ");
INSERT INTO gaze_vpl VALUES ("DT11_16","006_11_16","DEU","11","16","16","ኦፍ ኤገዻ! ዮ ከና አቺ እስን አከ ገረገልተኒ ዋቆተ ብራ ዋቄፈተኒፊ እሳኒፍስ ሰገደን ጎዎምፈምቱ። ");
INSERT INTO gaze_vpl VALUES ("DT11_17","006_11_17","DEU","11","17","17","ኤርገሲ ዼከምስ ዋቀዮ እስንት ቦበአ፤ እንስ አከ ቦካን ህንሮብኔ፣ ለፍትስ ኦምሸ ህንኬንኔፍ ሰሚወን ንጩፈ፤ እስንስ ብየ ጋሪ ዋቀዮ እስኒፍ ኬኑራ ደፍተኒ ንበዱ። ");
INSERT INTO gaze_vpl VALUES ("DT11_18","006_11_18","DEU","11","18","18","ዱቢወንኮ ከኔን ገራፊ ቀልቢኬሰንት ቀበዻ፤ አከ መለቶት ሀርከት ህዸዻ፤ አደኬሰንረትስ መጠንፈዻ። ");
INSERT INTO gaze_vpl VALUES ("DT11_19","006_11_19","DEU","11","19","19","እጆሌኬሰንስ በርሲሳ፤ ዬሮ መነ ቴሱ፣ ዬሮ ከራ ዴምቱ፣ ዬሮ ጪፍቱፊ ዬሮ ደመቅጡት ዋኤሳኒ ኦዴስ። ");
INSERT INTO gaze_vpl VALUES ("DT11_20","006_11_20","DEU","11","20","20","ምችችለወን በልበለ መነኬቲቲፊ ከረወንኬረትስ እሳን በሬስ፤ ");
INSERT INTO gaze_vpl VALUES ("DT11_21","006_11_21","DEU","11","21","21","ኩንስ አከ ኡሙሪንኬሰኒፊ ኡሙሪን እጆሌኬሰኒ ብየ ዋቀዮ አቦቲኬሰኒፍ ኬኑፍ ከከቴ ኬሰት አኩመ ኡሙሪ ሰሚወን ለፋ ኦል ጅረኒት ዼረቱፍ። ");
INSERT INTO gaze_vpl VALUES ("DT11_22","006_11_22","DEU","11","22","22","ዮ እስን አጀጀወን አን እስኒፍ ኬኑ ከኔን ሁንደ ኦፍ ኤገኖዻን ዱካ ቡተን ጄቹንስ ዮ እስን ዋቀዮ ዋቀኬሰን ጃለተን፣ ከራሳ ሁንደረ ዴምተኒፊ እሰት መጠንተን፣ ");
INSERT INTO gaze_vpl VALUES ("DT11_23","006_11_23","DEU","11","23","23","ዋቀዮ ሰቦተ ሁንደ ፉለኬሰን ዱራ አርኤ ንባሰ፤ እስንስ ሰቦተ እስን ጫላ ጉርጉዳፊ ጀጀቦ ንዻልቱ። ");
INSERT INTO gaze_vpl VALUES ("DT11_24","006_11_24","DEU","11","24","24","ለፍት ሚልኬሰን እረ ዻበቴ ሁንድኑኬሰን ተአ፤ ዳሪንኬሰንስ ገሞጂዻ ሀመ ልባኖንት፣ ለገ ኤፍራጢሲ ሀመ ገላነ ልጣት ንበልአተ። ");
INSERT INTO gaze_vpl VALUES ("DT11_25","006_11_25","DEU","11","25","25","ነምን ከምዩ ፉለኬሰን ዱረ ዻበቹ ህንደንደኡ። ዋቀዮ ዋቅንኬሰን አኩመ እስን አብደቺሴት ርፈቺሱፊ ሶዳችሱኬሰን ለፈ እስን ዸቅጠን ሁንደረ ንቡሰ። ");
INSERT INTO gaze_vpl VALUES ("DT11_26","006_11_26","DEU","11","26","26","ኩኖ፣ አን ሀርአ ኤባፊ አባርሰ ፉለኬሰን ዱረ ነንካአ፤ ");
INSERT INTO gaze_vpl VALUES ("DT11_27","006_11_27","DEU","11","27","27","ኤብ ኩንስ ዮ እስን አጀጀወን ዋቀዮ ዋቀኬሰኒ ከኔን አን ሀርአ እስኒፍ ኬኑ ኤግደኒዸ። ");
INSERT INTO gaze_vpl VALUES ("DT11_28","006_11_28","DEU","11","28","28","አባርስሞ ዮ እስን አጀጀወን ዋቀዮ ዋቀኬሰኒ ዸገኡ ድደኒ ከራ አን ሀርአ እስን አጀጄራ ገረገልተኒ ዋቆተ ብራ ከኔን እስን ዱራን ህንቤክኔ ዱካ ቡተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("DT11_29","006_11_29","DEU","11","29","29","ዮሙ ዋቀዮ ዋቅንኬ ብየ አት ዻሉፍ እት ገልቱ ከነት ስ ፍዱት ቱሉ ጌርዚምረት ኤበ፣ ቱሉ ኤባልረትሞ አባርሰ ለብስተ። ");
INSERT INTO gaze_vpl VALUES ("DT11_30","006_11_30","DEU","11","30","30","ቱሉወን ኩኔን ዮርዳኖስ ገመት፣ ከራ ገረ ልጠ ቢፍቱት ጌሱን ገመ ልጣት፣ ሙከ ሞሬ ጉድቸ ብረት፣ ብየ ከነኣኖተ አረባ ኬሰ ጅራተን ኬሰት ፉሌ ግልጋልት አርገሙ ምቲ? ");
INSERT INTO gaze_vpl VALUES ("DT11_31","006_11_31","DEU","11","31","31","እስን ብየ ዋቀዮ ዋቅንኬሰን እስኒፍ ኬኑ ሴንተኒ ዻሉፍ ዮርዳኖስን ጬኡዻፍ ጅርቱ፤ ዮሙ ለፈ ሰነ ዻልተኒ እረ ጅራተንት፣ ");
INSERT INTO gaze_vpl VALUES ("DT11_32","006_11_32","DEU","11","32","32","አጀጀወኒፊ ሴረወን አን ሀርአ ፉለኬሰን ዱረ ካኡ ሁንደ ኤጋ። ");
INSERT INTO gaze_vpl VALUES ("DT12_1","006_12_1","DEU","12","1","1","ስርነወኒፊ ሴረወን እስን በረ ለፈረ ጅራተን ጉቱ ብየ ዋቀዮ ዋቅን አቦቲኬሰኒ አከ እስን ዻልተኒፍ እስኒፍ ኬኔ ኬሰት ኦፍ ኤገናዻን ኤግደን ከኔኒዸ። ");
INSERT INTO gaze_vpl VALUES ("DT12_2","006_12_2","DEU","12","2","2","እዶወን ሰቦትን እስንራ ፉዸተን ዋቆተሳኒ እት ዋቄፈተን ከኔን ቱሉወን ኦል ዼዼሮፊ ጋረንራ፣ አከሱመስ ከኔን ሙከ ለልሳ ከምዩ ጀላ ሁንደ ጉቱማን ጉቱት በሌሳ፤ ");
INSERT INTO gaze_vpl VALUES ("DT12_3","006_12_3","DEU","12","3","3","እዶወን ኣርሳሳኒ ዲጋ፤ ኡቱባወንሳኒ ከኔን ሰገዳ ጨጨብሳ፤ ኣሼራሳኒ እብዳን ጉባ፤ ፈኪ ዋቆተሳኒ ኩኩታ ገታ፤ መቃሳኒሌ እዶ ሰና በሌሳ። ");
INSERT INTO gaze_vpl VALUES ("DT12_4","006_12_4","DEU","12","4","4","እስን ሃለ እሳን ዋቄፈተኒን ዋቀዮ ዋቀኬሰን ህንዋቄፈትና። ");
INSERT INTO gaze_vpl VALUES ("DT12_5","006_12_5","DEU","12","5","5","ገሩ እዶ ዋቀዮ ዋቅንኬሰን መቃሳ አች ዻቡፍ ጄዼ እዶ ጅሬኘሳቲፍ ጎሶተኬሰን ሁንደ ኬሳ ፍለቱ በርባዳ። አችስ ዸቃ፤ ");
INSERT INTO gaze_vpl VALUES ("DT12_6","006_12_6","DEU","12","6","6","አችትስ ኣርሳ ጉበሙፊ ቀልመኬሰን፣ ኬናኬሰን ኩዸን ኬሳ ቶኮ፣ ኬና አዳ፣ ዋን ኬኑፍ ወሬግደኒፊ ኬና ፌዺዻን ኬንተን፣ ሎኒፊ ቡሻዬኬሰን ኬሳ ሀንገፈ ዽኤሳ። ");
INSERT INTO gaze_vpl VALUES ("DT12_7","006_12_7","DEU","12","7","7","አችትስ አቲፊ ወር መነኬ ጅራተን ፉለ ዋቀዮ ዋቀኬሰኒ ዱረት ንኛቱ፤ ሰበቢ ዋቀዮ ዋቅንኬሰን ሆጂ ሀርከኬሰኒ ሁንዳን እስን ኤብሴፍስ ንገመዱ። ");
INSERT INTO gaze_vpl VALUES ("DT12_8","006_12_8","DEU","12","8","8","አከ ኑ ሀርአ ጎዻ ጅሩ ከነ፣ አከ ቶኮን ቶኮን ነማ ዋኑመ ቶላ እት ፈካቴ ጎዹ ከነ ህንጎዽና፤ ");
INSERT INTO gaze_vpl VALUES ("DT12_9","006_12_9","DEU","12","9","9","እስን አመዩ ቦቆናፊ ዻለ ዋቀዮ ዋቅንኬሰን እስኒፍ ኬኑ ህንጌኜቲ። ");
INSERT INTO gaze_vpl VALUES ("DT12_10","006_12_10","DEU","12","10","10","ገሩ ዮርዳኖስ ጬተኒ ብየ ዋቀዮ ዋቅንኬሰን ዻለ ጎዼ እስኒፍ ኬኑ ኬሰ ንቁበቱ፤ እንስ አከ እስን ነጋን ጅራተኒፍ ዲኖተ ናኖኬሰኒ ሁንደ ጀላ ቦቆና እስኒ ኬነ። ");
INSERT INTO gaze_vpl VALUES ("DT12_11","006_12_11","DEU","12","11","11","ኤርገሲስ ገረ ዋቀዮ ዋቅንኬሰን እዶ ጅሬኘ መቃሳቲፍ ፍለቱት ዋን አን እስን አጀጄ ሁንደ ፍዱ ቀብዱ፤ ኩንስ ኣርሳ ጉበሙፊ ቀልመኬሰን፣ ኬናኬሰን ኩዸን ኬሳ ቶኮ፣ ኬና አዳ፣ አከሱመስ ወሬገ ፍለተማ ዋቀዮፍ ኬኑፍ ወሬግደን ሁንዳዸ። ");
INSERT INTO gaze_vpl VALUES ("DT12_12","006_12_12","DEU","12","12","12","አችትስ እስን፣ እልማኒፊ እንተለንኬሰን፣ ሆጄታፊ ጦምቦሬንኬሰን፣ አከሱመስ ሌዎትን መጋላወንኬሰን ኬሰ ጅራተን ከኔን ቆደ ዮካን ዻለ መታሳኒ ህንቀብኔስ ፉለ ዋቀዮ ዋቀኬሰኒ ዱረት ገመዳ። ");
INSERT INTO gaze_vpl VALUES ("DT12_13","006_12_13","DEU","12","13","13","አከ ኣርሳኬሰን ከን ጉበሙ እዱመ አርግተን ሁንደት ህንዽኤስኔ ኦፍ ኤገዻ። ");
INSERT INTO gaze_vpl VALUES ("DT12_14","006_12_14","DEU","12","14","14","እዶ ዋቀዮ ጎሶተኬ ኬሳ ፍለቱ ቶኮ ቆፈት ኣርሳወን ጉበመን ዽኤስ፤ አችትስ ዋን አን ስ አጀጁ ሁንደ ኤግ። ");
INSERT INTO gaze_vpl VALUES ("DT12_15","006_12_15","DEU","12","15","15","ተኡስ አኩመ ኤበ ዋቀዮ ዋቅንኬ ሲፍ ኬኑት፣ መጋላወንኬ ከምዩ ኬሰት ኩሩጴ ዮካን ገደምሰ ቀለዹቲ ሀመ ፌቴ ኛዹ፤ ወር አከ ሴራት ህንቁልቁላእኒፊ ወር ቁልቁላአንስ ፎን ከነ ኛቹ ንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("DT12_16","006_12_16","DEU","12","16","16","እስን ገሩ ዺገ ሰነ ህንኛትና፤ አኩመ ብሻኒት ለፈት ዸንገላሳ። ");
INSERT INTO gaze_vpl VALUES ("DT12_17","006_12_17","DEU","12","17","17","አት ምዻንኬ ዮካን ዳዺ ወይኒኬቲ ዮካን ዘይቲኬ ሀርከ ኩዸን ኬሳ ሀርከ ቶኮ ዮካን ኬና ሀንገፈ ሎንኬቲ ዮካን ከን ቡሻዬኬቲ ዮካን ዋን ኬኑፍ ወሬገ ጎቱ ከምዩ ዮካን ኬና ፌዺኬቲን ኬንቱ ዮካን ኬና አዳ መጋላወንኬ ኬሰት ህንኛትን። ");
INSERT INTO gaze_vpl VALUES ("DT12_18","006_12_18","DEU","12","18","18","ቆደ ከና እዶ ዋቀዮ ዋቅንኬ ፍለቱት አት፣ እልማንኬ፣ እንተለንኬ፣ ሆጄቶትንኬ ዺራ ዱበርቲን፣ ሌዎትን መጋላወንኬ ኬሰ ጅራተን ፉለ ዋቀዮ ዋቀኬቲ ዱረት ኛዻ፤ አትስ ዋን ሀርክኬ ሆጄቱ ሁንዳን ፉለ ዋቀዮ ዋቀኬቲ ዱረት ገመድ። ");
INSERT INTO gaze_vpl VALUES ("DT12_19","006_12_19","DEU","12","19","19","በረ ብየኬ ኬሰ ጅራቱ ጉቱ አከ ሌዎተ ህንደገትኔ ኦፍ ኤገዹ። ");
INSERT INTO gaze_vpl VALUES ("DT12_20","006_12_20","DEU","12","20","20","ዮሙ ዋቀዮ ዋቅንኬ አኩመ ስ አብደቺሴት ብየኬ ሲፍ በልእሱት፣ አት ዮ ፎን ዸራቴ፣ “አን ፎን ኛቹ ፌዸ” ጄቴ፣ ሀመ ፌቴ ኛቹ ደንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("DT12_21","006_12_21","DEU","12","21","21","ዮ እዶን ዋቀዮ ዋቅንኬ መቃሳ አች ዻበቹፍ ፍለቱ አከ መሌ ስራ ፈጎ ተኤ፣ አኩመ አን ስ አጀጄት ሎኒፊ ቡሻዬ ዋቀዮ ዋቅንኬ ሲፍ ኬኔ ኬሳ ቀለቹ፣ መጋላወንኬ ኬሰትስ ሀመ ፌቴ ኛቹ ደንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("DT12_22","006_12_22","DEU","12","22","22","አኩመ ኩሩጴን ዮካን ገደምስ ኛተሙ ሰነ እሳን ኛዹ፤ ወር አከ ሴራት ህንቁልቁላእኒፊ ወር ቁልቁላአን ሁንድ ኛቹ ንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("DT12_23","006_12_23","DEU","12","23","23","ገሩ አከ ዺገ ህንኛትኔ ኦፍ ኤገዹ፤ ሰበቢንሳ ዺግን ዋን ሉቡ ተኤፍ አት ፎን ወጅን ሉቡ ህንኛትን። ");
INSERT INTO gaze_vpl VALUES ("DT12_24","006_12_24","DEU","12","24","24","አት ዺገ ህንኛትን፤ አኩመ ብሻኒ ለፈት ዸንገላስ። ");
INSERT INTO gaze_vpl VALUES ("DT12_25","006_12_25","DEU","12","25","25","አከ ስኢፊ እጆሌኬ ከኔን ስ ዱባን ዸለተኒፍ ቶሉፍ አት ዺገ ህንኛትን፤ አት ፉለ ዋቀዮ ዱረት ዋን ቀጄላ ሆጄቻ ጅርታቲ። ");
INSERT INTO gaze_vpl VALUES ("DT12_26","006_12_26","DEU","12","26","26","ገሩ ወንቶተኬ ቁልቁሉፊ ዋን ኬኑፍ ወሬግዴ ፉዸዹ እዶ ዋቀዮ ፍለቱ ዸቅ። ");
INSERT INTO gaze_vpl VALUES ("DT12_27","006_12_27","DEU","12","27","27","ፎኒፊ ዺገ ኣርሳኬ ከን ጉበሙ እዶ ኣርሳ ዋቀዮ ዋቀኬቲረት ዽኤስ። ዺግን ኣርሳኬቲ እዶ ኣርሳ ዋቀዮ ዋቀኬቲ ብረት ዸንገላፈሙ ቀበ፤ ፎንሳ ገሩ ኛቹ ደንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("DT12_28","006_12_28","DEU","12","28","28","አከ ስኢፊ እጆሌኬ ከኔን ስ ዱበ ዸለተኒፍ ዬሮ ሁንደ ቶሉፍ ቀጄልቸወን አን ሲፍ ኬኑ ከኔን ሁንደ ኦፍ ኤገናዻን ኤግ፤ ሰበቢንሳ አት እጀ ዋቀዮ ዋቀኬቲ ዱረት ዋን ጋሪፊ ቀጄላ ሆጄቻ ጅርታቲ። ");
INSERT INTO gaze_vpl VALUES ("DT12_29","006_12_29","DEU","12","29","29","ዋቀዮ ዋቅንኬ ሰቦተ አት ዌረርቴ ብያ ባሱፍ ጅርቱ ፉለኬ ዱራ ንበሌሰ። አት ገሩ ዮሙ አሪቴ እሳን ባፍቴ ለፈሳኒረ ቁበቱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT12_30","006_12_30","DEU","12","30","30","ኤርገ እሳን ፉለኬ ዱራ በሌፈመኒ ቦዴስ፣ “ሰቦትን ኩኔን አከምት ዋቆተሳኒ ተጃጅሉ? አንስ አከሱመን ጎዸ” ጄቴ ዋኤ ዋቆተሳኒ ጋፈቹዻን ክዮ ኬሰ አከ ህንገሌ ኦፍ ኤገዹ። ");
INSERT INTO gaze_vpl VALUES ("DT12_31","006_12_31","DEU","12","31","31","እሳን ሰበቢ ዋቆተሳኒ ዋቄፈቹዻን ሆጂ ጅብሲሳ ዋቀዮ ጅቡ ሄዱ ሆጄተኒፍ፣ አት ሃለሳኒቲን ዋቀዮ ዋቀኬ ህንዋቄፈትን። እሳን እልማንሳኒቲፊ እንተለንሳኒሌ ዋቆተሳኒቲፍ ኣርሳ ጎዸኒ እብዳን ጉቡ። ");
INSERT INTO gaze_vpl VALUES ("DT12_32","006_12_32","DEU","12","32","32","አት ዋን አን ስ አጀጁ ሁንደ ኤግ፤ እት ህንደበልን፤ እራስ ህንህርእስን። ");
INSERT INTO gaze_vpl VALUES ("DT13_1","006_13_1","DEU","13","1","1","ዮ ራጂን ዮካን ነምን አብጁዻን ዋን ዹፋ ጅሩ ህሙ ቶኮ ግዱኬሰንት አርገሜ መለቶወን ዮካን ድንቂ እስንት ህሜ፣ ");
INSERT INTO gaze_vpl VALUES ("DT13_2","006_13_2","DEU","13","2","2","ዮ መለቶን ዮካን ድንቂ እን እስንት ህሜ ሱን ራወተሜ እንስ፣ “ኮቱ ዋቆተ ብራ ከኔን አት ዱራን ህንቤክኔ ዱካ ቡኔ ሃዋቄፈትኑ” ሲን ጄዼ፣ ");
INSERT INTO gaze_vpl VALUES ("DT13_3","006_13_3","DEU","13","3","3","አት ዱቢ ራጂ ዮካን ነመ አብጆቱ ሰና ህንዸጌፈትን፤ ዋቀዮ ዋቅንኬ አከ እስን ገራኬሰን ጉቱፊ ያደኬሰን ጉቱዻን እሰ ጃለተን ቆሩፍ ዋን ከነ ጎዻቲ። ");
INSERT INTO gaze_vpl VALUES ("DT13_4","006_13_4","DEU","13","4","4","ዋቀዮ ዋቀኬሰን ዱካ ቡኣ፤ እሰ ሶዳዻ። አጀጀወንሳ ኤጋ፤ እሳፍ አጀጀማ፤ እሰ ተጃጅላ፤ እሰትስ መጠና። ");
INSERT INTO gaze_vpl VALUES ("DT13_5","006_13_5","DEU","13","5","5","ራጃን ዮካን ነምች አብጁ አብጆቱ ሱን፣ ሰበቢ አከ እስን ዋቀዮ ዋቀኬሰን ከን ብየ ግብጢቲ እስን ባሴ ብየ ገርቡማ ጀላ እስን ፉሬ ሰነት ፍንጭልተን ዱበቴፍ አጄፈሙ ቀበ፤ እን ከራ ዋቀዮ ዋቅንኬሰን አከ ዱካ ቡተን እስን አጀጄራ እስን ጀልእሱፍ ያሌረ፤ ሀማ ኦፍ ኬሳ በሌስ። ");
INSERT INTO gaze_vpl VALUES ("DT13_6","006_13_6","DEU","13","6","6","ዮ ኦቦሌስኬ ዮካን እልምኬ ዮካን እንተልኬ ዮካን ኒቲንኬ ከን አት ጃለቱ ዮካን ምቹንኬ፣ “ኮቱ ዋቆተ ብራ ከኔን አትስ ታቱ አቦቲንኬ ህንቤክን ዋቄፈትና” ጄዼ ዾክሳዻን ስ ዶጎጎርሱ በርባዴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT13_7","006_13_7","DEU","13","7","7","ዮ እን ዋቆተ ሰቦተ ናኖኬቲ፣ ከኔን ዽኦ ዮካን ፈጎ ጅረን፣ ወረ ዳሪ ለፋ ቶኮ ሀመ ዳሪ ለፋ ካኒት ጅረኒ ዋቄፈትነ፣ ሲን ጄዼ፣ ");
INSERT INTO gaze_vpl VALUES ("DT13_8","006_13_8","DEU","13","8","8","ቶሌ ህንጄዽኒፍ ዮካን እሰ ህንዸገእን። ህንነእኒፍ። እሳፍ ህንህልን ዮካን ሀርከ እረ ህንቀብን። ");
INSERT INTO gaze_vpl VALUES ("DT13_9","006_13_9","DEU","13","9","9","አት እሰ አጄሱ ቀብደ። እሰ አጄሱፍስ ጀልቀበት ሀርክኬ፣ እት ኣንሴስ ሀርክ ሰበ ሁንዳ ሃከኡ። ");
INSERT INTO gaze_vpl VALUES ("DT13_10","006_13_10","DEU","13","10","10","ዋን እን አከ አት ዋቀዮ ዋቀኬ ከን ግብጥ፣ ብየ ገርቡማቲ ስ ባሴ ሰነራ ገረገልቱ ጎዼፍ ዸጋዻን ቱሚ እሰ አጄስ። ");
INSERT INTO gaze_vpl VALUES ("DT13_11","006_13_11","DEU","13","11","11","ኤርገሲ እስራኤሎን ሁንድ ዸገአኒ ንሶዳቱ፤ ስ ግዱዻስ ኤኙዩ ዴብኤ ዋን ሀማ አከሲ ህንሆጄቱ። ");
INSERT INTO gaze_vpl VALUES ("DT13_12","006_13_12","DEU","13","12","12","ዮ አት መጋላወን አከ አት ኬሰ ጅራቱፍ ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ኬሳ ቶኮትዩ ኡቱ አከስ ጄዸሙ ዸጌሴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT13_13","006_13_13","DEU","13","13","13","ዮ ነሞትን ሀሞን እስን ግዱዻ ከአኒ፣ “ኮታ ዋቆተ ብራ ከኔን እስን ህንቤክኔ ዋቄፈትና” ጄዸኒ ሰበ መጋላሳኒ ዶጎጎርሱ ተኤ፣ ");
INSERT INTO gaze_vpl VALUES ("DT13_14","006_13_14","DEU","13","14","14","ዱቢ ሰነ እያፈዹ፤ ቆረዹ፤ ስሪት ጋፈዹ። ኩኖ፣ ዮ ዱቢን ሱን ዹጋ ተኤ ወን ጅብሲሳን ኩን ግዱኬት ሆጄተሙንሳ ምርከናኤ፣ ");
INSERT INTO gaze_vpl VALUES ("DT13_15","006_13_15","DEU","13","15","15","አት ነሞተ መጋላ ሰነ ኬሰ ጅራተን ሁንደ ጎራዴዻን ፍጥ፤ መጋላ ሰነሌ ነሞተሼቲፊ ሆሪሼ ወጅን ጉቱማን ጉቱት በርበዴስ። ");
INSERT INTO gaze_vpl VALUES ("DT13_16","006_13_16","DEU","13","16","16","ምአ ቦጁ ከን መጋላ ሰና አርገሜ ሁንደ ወለካ ኦብዲሼት ወልት ቀቢቲ መጋላ ሰነ ጉቱ ቦጁሼ ወጅን ዋቀዮ ዋቀኬቲፍ ኣርሳ ጉቱማን ጉበሙ ጎዺቲ ጉብ። እሼን በረ በራን በርበዶፍቴ ሃሀፍቱ፤ ዴብቴስ ህንእጃረምን። ");
INSERT INTO gaze_vpl VALUES ("DT13_17","006_13_17","DEU","13","17","17","አከ ዋቀዮ ዼከምሰሳ ሶዳችሳራ ዴብኡፍ ወን አባረሜ ቶኮ ሀርከኬት ህንአርገምን፤ እን ሲፍ አራረመ፤ ገራ ሲፍ ላፈ፤ አኩመ አቦቲኬቲፍ ከከቴት ስ ባይእሰ፤ ");
INSERT INTO gaze_vpl VALUES ("DT13_18","006_13_18","DEU","13","18","18","ኩንስ ዋን አት አጀጀወንሳ ከኔን አን ሀርአ ሲፍ ኬኑ ሁንደ ኤግዴ ፉለሳ ዱረት ዋን ቀጄላ ሆጄቹዻን ዋቀዮ ዋቀኬቲፍ አጀጀምቱፍ። ");
INSERT INTO gaze_vpl VALUES ("DT14_1","006_14_1","DEU","14","1","1","እስን እጆሌ ዋቀዮ ዋቀኬሰኒት። ነመ ዱኤፍ ጄተኒ ኦፍ ህንሙርሙርና ዮካን ርፌንሰ አደኬሰኒን ኦል ጅሩ ህንሃደትና፤ ");
INSERT INTO gaze_vpl VALUES ("DT14_2","006_14_2","DEU","14","2","2","አት ዋቀዮ ዋቀኬቲፍ ሰበ ቁልቁሉዻቲ። ዋቀዮ አከ አት ቀቤኘሳ ጃለተማ ታቱፍ ጄዼ ሰቦተ ለፈረ ጅራተን ሁንደ ኬሳ ስ ፍለቴረ። ");
INSERT INTO gaze_vpl VALUES ("DT14_3","006_14_3","DEU","14","3","3","አት ዋን ጅብሲሳ ቶኮሌ ህንኛትን። ");
INSERT INTO gaze_vpl VALUES ("DT14_4","006_14_4","DEU","14","4","4","ሆሪን እስን ኛቹ ደንዴሰን ከኔኒዸ፤ ሰንጋ፣ ሆላ፣ ሬኤ፣ ");
INSERT INTO gaze_vpl VALUES ("DT14_5","006_14_5","DEU","14","5","5","ገደምሰ፣ ኩሩጴ፣ ቦሮፈ፣ ሬኤ ዲዳ፣ ዋልያ፣ ሳላፊ ሆላ ቱሉ። ");
INSERT INTO gaze_vpl VALUES ("DT14_6","006_14_6","DEU","14","6","6","ሆሪ ኮቴንሳ በቀቄ እዶ ለመት ገርገር ቆደሜ ከን ሀለለ ጉሩ ኛቹ ንደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("DT14_7","006_14_7","DEU","14","7","7","ገሩ ወረ ሀለለ ጉረን ዮካን ወረ ኮቴ በቀቃ ቀበን ኬሳ ጋለ፣ እሌቲ፣ ዮካን ኦሶሌ ህንኛትና፤ እሳን ኩኔን ሀለለ ጉረንዩ ዋን ኮቴንሳኒ ዱዳ ተኤፍ እሳን አከ ሴራት እስኒፍ ቁልቁሉ ምት። ");
INSERT INTO gaze_vpl VALUES ("DT14_8","006_14_8","DEU","14","8","8","ቦዬንስ ቁልቁሉ ምት፤ ኮቴንሳ በቀቃ ተኡስ ቦዬን ሀለለ ህንጉሩ። እስን ፎንሳኒ ህንኛትና ዮካን ረቀሳኒ ህንቱቅና። ");
INSERT INTO gaze_vpl VALUES ("DT14_9","006_14_9","DEU","14","9","9","ኡመመወን ብሻን ኬሰ ጅራተን ሁንደ ኬሳ ወረ ቆቾፊ ቆለ ቀበን ከምዩ ኛቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("DT14_10","006_14_10","DEU","14","10","10","ገሩ ወረ ቆቾፊ ቆለ ህንቀብኔ ከምዩ ህንኛትና፤ እሳን እስኒፍ ቁልቁሉ ምት። ");
INSERT INTO gaze_vpl VALUES ("DT14_11","006_14_11","DEU","14","11","11","እስን ስምብረ ቁልቁሉ ከምዩ ኛቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("DT14_12","006_14_12","DEU","14","12","12","እሳን ከኔን ገሩ ህንኛትና፤ እሳንስ ርሳ፣ ሩምቸ፣ ሩምቸ ጉራቸ፣ ");
INSERT INTO gaze_vpl VALUES ("DT14_13","006_14_13","DEU","14","13","13","ጩሉሌ፣ ጩሉሌ ጉራቸ፣ ጩሉሌ ጎሰ ገራ ገራ፣ ");
INSERT INTO gaze_vpl VALUES ("DT14_14","006_14_14","DEU","14","14","14","አራጌሰ ጎሰ ገራ ገራ፣ ");
INSERT INTO gaze_vpl VALUES ("DT14_15","006_14_15","DEU","14","15","15","ጉቺ፣ ኡሩንጉ፣ አላቲ ብሻኒ፣ ጮሮፌ ጎሰ ገራ ገራ፣ ");
INSERT INTO gaze_vpl VALUES ("DT14_16","006_14_16","DEU","14","16","16","ኡሩንጉ ጥና፣ ኡሩንጉ ጉዳ፣ ኡሩንጉ አዲ፣ ");
INSERT INTO gaze_vpl VALUES ("DT14_17","006_14_17","DEU","14","17","17","ኡሩንጉ ገሞጂ፣ አባ ኮዳ፣ ኡሩንጉ ጉዳ፣ ");
INSERT INTO gaze_vpl VALUES ("DT14_18","006_14_18","DEU","14","18","18","ሁሞ፣ አላቲ ጎሰ ከሚዩ፣ ሃዸ ጋዬቲፊ ስምብረ ሀልከኒት። ");
INSERT INTO gaze_vpl VALUES ("DT14_19","006_14_19","DEU","14","19","19","እልቢሶን በርሰን ሁንድኑ እስኒፍ ቁልቁሉ ምት፤ እሳን ህንኛትና። ");
INSERT INTO gaze_vpl VALUES ("DT14_20","006_14_20","DEU","14","20","20","ኡመመወን ቆቾ ቀበን ከኔን ቁልቁሉ ተአን ከምዩ ገሩ ኛቹ ደንዴሱ። ");
INSERT INTO gaze_vpl VALUES ("DT14_21","006_14_21","DEU","14","21","21","ዋን ኦፊሳቲን ዱኤ ቶኮሌ ህንኛትን። አከ እን ኛቱፍ አለጋ መጋላኬ ኬሰ ጅራቱፍ ኬን ዮካን ነመ ኦርማ ቶኮት ጉርጉረዹ። አት ገሩ ሰበ ዋቀዮ ዋቀኬቲፍ ቁልቁሌፈምቴዸ። እልሞ ሬኤ ቶኮ ኣነን ሃዻሼቲን ህንአፌልን። ");
INSERT INTO gaze_vpl VALUES ("DT14_22","006_14_22","DEU","14","22","22","ዋን ለፍት ቆቲሳኬ ወጋት ኬኑ ሁንደ ኬሳ ኩዸን ኬሳ ቶኮ ኮጳት ባሲ ካእ። ");
INSERT INTO gaze_vpl VALUES ("DT14_23","006_14_23","DEU","14","23","23","አከ ዋቀዮ ዋቀኬ ሶዳቹ በረቱፍ እዶ እን አከ መቃንሳ አች ጅራቱፍ ፍለቱት ምዻንኬ፣ ወይኒኬ ሃራፊ ዘይቲኬ አከሱመስ ሀንገፈ ሎኒፊ ቡሻዬኬ ፉለ ዋቀዮ ዋቀኬቲ ዱረት ኛዹ። ");
INSERT INTO gaze_vpl VALUES ("DT14_24","006_14_24","DEU","14","24","24","ገሩ ዮ እዶን ሱን አከ መሌ ፈጋቴ፣ አትስ ዋቀዮ ዋቀኬቲን ኤብፈምቴ ሰበቢ እዶን ዋቀዮ አከ መቃንሳ አች ጅራቱፍ ፍለቱ ሱን ፈጎ ተኤፍ ኬናኬ ኩዸን ኬሳ ቶኮ ባቹ ደዸብዴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT14_25","006_14_25","DEU","14","25","25","ኬናኬ ከን ኩዸን ኬሳ ቶኮ ሰነ ሜቲት ጌደሪቲ፣ ሜቲ ሰነ ቀበዹቲ እዶ ዋቀዮ ዋቅንኬ ፍለቱ ዸቅ። ");
INSERT INTO gaze_vpl VALUES ("DT14_26","006_14_26","DEU","14","26","26","ሜቲ ሰናንስ ዋኑመ ፌቴ ጄቹንስ፣ ሎን፣ ሆሎተ፣ ዳዺ ወይኒ ዮካን ዹጋቲ ጀባ፣ ዮካን ዋን በርባዴ ከምዩ ብት። ኤርገሲ አቲፊ ወር መነኬቲ ፉለ ዋቀዮ ዋቀኬቲ ዱረት ኛዻ ገመዳ። ");
INSERT INTO gaze_vpl VALUES ("DT14_27","006_14_27","DEU","14","27","27","ሌዎትን መጋላኬ ኬሰ ጅራተን ቆደ ዮካን ዻለ ኦፊሳኒ ዋን ህንቀብኔፍ አት እሳን ህንደገትን። ");
INSERT INTO gaze_vpl VALUES ("DT14_28","006_14_28","DEU","14","28","28","ዬሮ ሁንደ ዹመ ወጋ ሰደፋት ዋን ወጋ ሰነ ኬሰ ገልፈቴ ኩዸን ኬሳ ቶኮ ፉዺቲ መጋላወን ኬሰት ኩስ። ");
INSERT INTO gaze_vpl VALUES ("DT14_29","006_14_29","DEU","14","29","29","ኩንስ አከ ሌዎትን ቆደ ዮካን ዻለ ኦፊሳኒ ህንቀብኔ፣ አለጎን፣ እጆሌን አባ ህንቀብኔፊ ኒቶትን ዽርሶትንሳኒራ ዱአን ወር መጋላወን ኬሰ ጅራተን ኛተኒ ቁፈኒፊ አከ ዋቀዮ ዋቅንኬ ሆጂ ሀርከኬቲ ሁንዳን ስ ኤብሱፍ። ");
INSERT INTO gaze_vpl VALUES ("DT15_1","006_15_1","DEU","15","1","1","አት ዬሮ ሁንደ ዹመ ወጋ ቶርበፋት ገቲ ነማፍ ዺሱ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT15_2","006_15_2","DEU","15","2","2","ኩንስ አከነት ተአ፦ ነምን ልቂ ኬኑ ሁንዲ ልቂ ኦላሳ ነመ እስራኤሊፍ ልቄሴ ዺሱፊ ቀበ። ሰበቢ ዬሮን ዋቀዮ ከን እት ገቲን ነማፍ ዺፈሙ ለብሰሜፍ እን ኦላሳ ዮካን ኦቦሌሰሳ እስራኤልቸራ ዋን እሳፍ ልቄሴ ህንጋፈትን። ");
INSERT INTO gaze_vpl VALUES ("DT15_3","006_15_3","DEU","15","3","3","አት ዋን አለጋፍ ልቄስቴ ጋፈቹ ንደንዴሰ፤ ገሩ ዋን ኦቦሌስኬ ስራ ልቄፈቴ ዺሱፊ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT15_4","006_15_4","DEU","15","4","4","ተኡስ ዋን ዋቀዮ ዋቅንኬ ብየ አከ አት ዻልቱፍ ሲፍ ኬኑረት አከ መሌ ስ ኤብሱፍ ህዬስ ግዱኬት ህንአርገሙ፤ ");
INSERT INTO gaze_vpl VALUES ("DT15_5","006_15_5","DEU","15","5","5","ኩንስ ዮ አት ጉቱማን ጉቱት ዋቀዮ ዋቀኬቲፍ አጀጀምቴፊ ዮ አት አጀጀወን አን ሀርአ ሲፍ ኬኑ ከኔን ሁንደ ኤግዴ ቆፈ ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT15_6","006_15_6","DEU","15","6","6","ዋን ዋቀዮ ዋቅንኬ አኩመ ስ አብደቺሴት ስ ኤብሱፍ አት ሰቦተ ባይኤዻፍ ልቄስተ መሌ ቶኮራዩ ህንልቄፈቱ። አት ሰቦተ ባይኤ ቡልችተ መሌ እሳን ስ ህንቡልቸን። ");
INSERT INTO gaze_vpl VALUES ("DT15_7","006_15_7","DEU","15","7","7","መጋላወን ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ኬሰት ዮ ኦቦሎተኬ ግዱ ህዬስ ጅራቴ ኦቦሌሰኬ ሰነረት ገራንኬ ህንጀባትን ዮካን እሰ ገርጋሩራ ሀርከኬ ህንዴብፈትን። ");
INSERT INTO gaze_vpl VALUES ("DT15_8","006_15_8","DEU","15","8","8","ቆደ ከና ሀርከኬ እሳፍ ድሪርሲቲ ዋን እሰ ገኡ ልቄሲፍ። ");
INSERT INTO gaze_vpl VALUES ("DT15_9","006_15_9","DEU","15","9","9","አከ ያድን ሀማን፣ “ወጋን ቶርበፋን፣ ወጋን እት ገቲን ነማፍ ዺፈሙ ሱን ዽኣቴረ” ጄዹ ስ ኬሰት ኩፈሜ አት አከሲን ኦቦሌሰኬ ረከታ እጀ ሀማዻን እላልቴ ገርጋሩ ህንዺፍኔ ኦፍ ኤገዹ። እን ዋቀዮት ኦል እየተ፤ ኩንስ ጩቡ ስት ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT15_10","006_15_10","DEU","15","10","10","አት አርጁማዻን እሳፍ ኬን፤ ዮሙ ኬንቱፍስ ገራንኬ ህንጋብን፤ ሰበቢ ከናፍ ዋቀዮ ዋቅንኬ ሆጂኬ ሁንዳፊ ዋን ሀርክኬ ቀበቴ ሁንዳን ስ ኤብሰ። ");
INSERT INTO gaze_vpl VALUES ("DT15_11","006_15_11","DEU","15","11","11","ዮምዩ ታናን ህዬዪን ለፈረ ንጅራቱ። ከናፉ አን አከ አት ሀርከኬ ኦቦሎተኬቲፍ፣ ህዬዪፊ ረከቶተ ብየኬቲቲፍ ድሪርፈቱ ስን አጀጀ። ");
INSERT INTO gaze_vpl VALUES ("DT15_12","006_15_12","DEU","15","12","12","ዮ ነምን ጎሰ እብሮታ፣ ዺር ዮካን ዱበርቲን ስት ጉርጉረምቴ ወጋ ጀአ ሲፍ ሆጄቴ፣ ወጋ ቶርበፋት ብልሰ ባሲ ገድ ዺስ። ");
INSERT INTO gaze_vpl VALUES ("DT15_13","006_15_13","DEU","15","13","13","ዮሙ ገድ ዺፍቱትስ ሀርከ ዱዋ ህንጌጌስን። ");
INSERT INTO gaze_vpl VALUES ("DT15_14","006_15_14","DEU","15","14","14","ቡሻዬኬ ኬሳ፣ ኦብዲፊ እዶ ጩንፋ ወይኒኬቲራ አርጁማዻን ኬኒፍ። አኩመ ዋቀዮ ዋቅንኬ ስ ኤብሴት እሳፍ ኬን። ");
INSERT INTO gaze_vpl VALUES ("DT15_15","006_15_15","DEU","15","15","15","አከ አትስ ብየ ግብጥት ገርበ ቱርቴፊ አከ ዋቀዮ ዋቅንኬ ስ ፉሬ ያደዹ። ወን አን ሀርአ አጀጀ ከነ ሲፍ ኬኑፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("DT15_16","006_15_16","DEU","15","16","16","ገሩ ዮ ገርብችኬ ሱን ሰበቢ ስኢፊ ማቲኬ ጃለቱፍ ስ ወጅን ጅራቹን እት ቶሌ፣ “አን ስ ዺሴ ህንዴሙ” ሲን ጄዼ፣ ");
INSERT INTO gaze_vpl VALUES ("DT15_17","006_15_17","DEU","15","17","17","ሙታ ፉዺ በልበለረት ጉረሳ ኡር፤ እንስ በረ በራን ገርብቸኬ ተአ። ገርብቲኬስ አከሱመ ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("DT15_18","006_15_18","DEU","15","18","18","ገርብቸኬ ብልሶምሱን ዋን ኡልፋታ ስት ህንፈካትን፤ ተጃጅልሳ ከን ወጋ ጀኣ ሱን ገቲ ነመ ቀጠረሜ ሆጄቱ ቶኮት ሀርከ ለመ ቱሬቲ። ዋቀዮ ዋቅንኬ ዋን አት ሆጄቱ ሁንዳን ስ ኤብሰ። ");
INSERT INTO gaze_vpl VALUES ("DT15_19","006_15_19","DEU","15","19","19","ሎኒፊ ቡሻዬኬ ኬሳ ኮርመ ሀንገፈ ሁንደ ዋቀዮ ዋቀኬቲፍ አዳን ባስ፤ ቆትዮኬ ኬሳ ሀንገፋን ህንሆጄትን፤ ሀንገፈ ሆላኬቲራ ርፌንሰ ህንሙርን። ");
INSERT INTO gaze_vpl VALUES ("DT15_20","006_15_20","DEU","15","20","20","ወጋ ወጋዻን አቲፊ ማቲንኬ እዶ ዋቀዮ ዋቅንኬ ፍለቱት ፉለሳ ዱረት እሳን ኛቱ። ");
INSERT INTO gaze_vpl VALUES ("DT15_21","006_15_21","DEU","15","21","21","ዮ ሆሪን ሱን ህርእነ ቀባቴ ጄቹንስ ዮ እን ናፈ ዮካን ጃማ ዮካን ሙዳ ሀማ ከምዩ ቀባቴ፣ አት ሆሪ ሰነ ኣርሳ ጎቴ ዋቀዮ ዋቀኬቲፍ ህንዽኤስን። ");
INSERT INTO gaze_vpl VALUES ("DT15_22","006_15_22","DEU","15","22","22","አት መጋላኬ ኬሰት ኛዹ። አኩመ ዋን ሆሪን ሱን ኩሩጴ ዮካን ገደምሰ ተኤት ነምን አከ ሴራት ቁልቁሉ ህንተእኒፊ ከን ቁልቁሉ ተኤ ኛቹ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("DT15_23","006_15_23","DEU","15","23","23","አት ገሩ ዺገ ሰነ ህንኛትን፤ አኩመ ብሻኒት ለፈት ዸንገላስ። ");
INSERT INTO gaze_vpl VALUES ("DT16_1","006_16_1","DEU","16","1","1","ሰበቢ ዋቀዮ ዋቅንኬ ጅአ አቢቢ ኬሰ ሀልከኒን ግብጢ ስ ባሴፍ ጅአ አቢቢ ከበጅ፤ ፋሲካ ዋቀዮ ዋቀኬቲስ አያኔፈዹ። ");
INSERT INTO gaze_vpl VALUES ("DT16_2","006_16_2","DEU","16","2","2","እዶ ዋቀዮ ዋቅንኬ አከ መቃንሳ አች ጅራቱፍ ፍለቱት ቡሻዬኬ ዮካን ሎንኬ ኬሳ ፋሲካ ጎዺ ዋቀዮ ዋቀኬቲፍ ቀል። ");
INSERT INTO gaze_vpl VALUES ("DT16_3","006_16_3","DEU","16","3","3","አት አከ በረ ጅሬኘኬቲ ጉቱ ጉያ እት ግብጢ ባቴ ሰነ ያደቱፍ ፋሲካ ሰነ ቡዴነ ራጭቲ ቀቡ ወጅን ህንኛትን፤ ገሩ አት ሰበቢ አሪቲዻን ብየ ግብጢቲ ባቴፍ ቡልቲ ቶርበ መጥኖ ጄቹንስ ቡዴነ ረክና ኛዹ። ");
INSERT INTO gaze_vpl VALUES ("DT16_4","006_16_4","DEU","16","4","4","ጉቱማ ብየኬቲ ኬሰት ቡልቲ ቶርባፍ ራጭቲን ህንአርገምን። ፎን አት ገልገለ ጉያ ጀልቀባት ኣርሳ ጎቱ ሀመ በሪት ህንቱርን። ");
INSERT INTO gaze_vpl VALUES ("DT16_5","006_16_5","DEU","16","5","5","አት መጋላ ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ከምትዩ ፋሲካ ህንዽኤስን፤ ");
INSERT INTO gaze_vpl VALUES ("DT16_6","006_16_6","DEU","16","6","6","ገሩ ለፈ እን እዶ ጅሬኘ መቃሳቲፍ ፍለቱት ገልገለ ዬሮ ቢፍቱን ገድ ቡቱት ያደኖ ጉያ እት ብየ ግብጢቲ ባቴቲፍ ኣርሳ ፋሲካ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("DT16_7","006_16_7","DEU","16","7","7","ኣርሳ ፋሲካ ሰነ ዋዲቲ እዶ ዋቀዮ ዋቅንኬ ፍለቱት ኛዹ። ኤርገሲስ ገነመ ገረ ዱንካነኬቲት ዴብእ። ");
INSERT INTO gaze_vpl VALUES ("DT16_8","006_16_8","DEU","16","8","8","ቡልቲ ጀአ መጥኖ ኛዹ፤ ቡልቲ ቶርበፋትሞ ዋቀዮ ዋቀኬቲፍ ወል ገኢ ቁልቁሉ ጎዽ፤ ሆጂሌ ህንሆጄትን። ");
INSERT INTO gaze_vpl VALUES ("DT16_9","006_16_9","DEU","16","9","9","ጋፈ ምዻንኬ ሃሙ ጀልቀብዴ ካሲ ቶርበኖተ ቶርበ ለካእ። ");
INSERT INTO gaze_vpl VALUES ("DT16_10","006_16_10","DEU","16","10","10","ኤርገሲስ አኩመ ባይእነ ኤበ ዋቀዮ ዋቅንኬ ሲፍ ኬኔት ኬና ፌዺዻን ኬንቱ ዽኤሱዻን አያነ ቶርበኖታ ዋቀዮ ዋቀኬቲፍ አያኔፈዹ። ");
INSERT INTO gaze_vpl VALUES ("DT16_11","006_16_11","DEU","16","11","11","አት፣ እልማኒፊ እንተለንኬ፣ ሆጄቶትንኬ ዺሮትኒፊ ዱበርቲን፣ ሌዎትን መጋላወንኬ ኬሰ ጅራተን፣ አለጎን፣ እጆሌን አባ ህንቀብኔፊ ኒቶትን ዽርሶትንሳኒራ ዱአን ከኔን እስን ግዱ ጅራተን አችት፣ እዶ ዋቀዮ ዋቅንኬ እዶ ጅሬኘ መቃሳቲፍ ፍለቱት ፉለሳ ዱረት ንገመዱ። ");
INSERT INTO gaze_vpl VALUES ("DT16_12","006_16_12","DEU","16","12","12","አት አከ ግብጥት ገርበ ቱርቴ ያደዹ፤ ሴረ ከነስ አከ ጋሪት ኤግ። ");
INSERT INTO gaze_vpl VALUES ("DT16_13","006_16_13","DEU","16","13","13","ኤርገ ኦብዲፊ እዶ ጩንፋ ወይኒኬቲራ ኦምሸኬ ገልፈቴ ቦዴ ጉያ ቶርባፍ አያነ ዳሲ አያኔፈዹ። ");
INSERT INTO gaze_vpl VALUES ("DT16_14","006_16_14","DEU","16","14","14","አት፣ እልማኒፊ እንተለንኬ፣ ተጃጅልቶትንኬ ዺሮትኒፊ ዱበርቶትን፣ ሌዎትን፣ አለጎን፣ እጆሌን አቦቲ ህንቀብኔፊ ዱበርቶትን ዽርሶትንሳኒራ ዱአን ከኔን መጋላወንኬ ኬሰ ጅራተን አያነኬረት ገመዳ። ");
INSERT INTO gaze_vpl VALUES ("DT16_15","006_16_15","DEU","16","15","15","አያነ ከነስ እዶ ዋቀዮ ፍለቱት ቡልቲ ቶርባፍ ዋቀዮ ዋቀኬቲፍ አያኔፈዹ። ሰበቢ ዋቀዮ ዋቅንኬ ኦምሸኬቲፊ ሆጂ ሀርከኬቲ ሁንዳን ስ ኤብሱፍ ገመቹንኬ ጉቱ ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT16_16","006_16_16","DEU","16","16","16","ዺርኬ ሁንድ ወጋት ዬሮ ሰዲ እዶ እን ፍለቱት ፉለ ዋቀዮ ዋቀኬቲ ዱረት ዽኣቹ ቀቡ፤ ኩንስ ዬሮ አያነ መጥኖ፣ ዬሮ አያነ ቶርበኖታቲፊ ዬሮ አያነ ዳሲት። ነምን ቶኮዩ ሀርከ ዱዋ ፉለ ዋቀዮ ዱረት ህንዽኣትን፦ ");
INSERT INTO gaze_vpl VALUES ("DT16_17","006_16_17","DEU","16","17","17","ቶኮን ቶኮንኬሰን አኩመ ባይእነ ኤበ ዋቀዮ ዋቅንኬሰን እስኒፍ ኬኔት ኬና ፍዳ። ");
INSERT INTO gaze_vpl VALUES ("DT16_18","006_16_18","DEU","16","18","18","መጋላወን ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ሁንደቱ ጎሶተኬ ሁንዳፍ አቦቲ ሴራቲፊ ቆንዳልቶተ ሙድ፤ እሳንስ ዹጋዻን ነሞታፍ ሙርቲ ኬኑ። ");
INSERT INTO gaze_vpl VALUES ("DT16_19","006_16_19","DEU","16","19","19","አት ሙርቲ ህንጀልእስን ዮካን ነመ ወል ህንጫልችስን። መተኣ ህንፉዸትን፤ መተኣን እጀ ኦጌዪ ጃምሴ ዱቢ ቀጄልቶታስ ጀልእሰ። ");
INSERT INTO gaze_vpl VALUES ("DT16_20","006_16_20","DEU","16","20","20","አት አከ ሉቡዻን ጅራቴ ለፈ ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ዻልቱፍ ሙርቲ ቀጄላ ቆፈ ዱካ ቡእ። ");
INSERT INTO gaze_vpl VALUES ("DT16_21","006_16_21","DEU","16","21","21","እዶ ኣርሳ ከን ዋቀዮ ዋቀኬቲፍ ዻብዴ ብረ ሲዳ ኣሼራ ህንዻብን። ");
INSERT INTO gaze_vpl VALUES ("DT16_22","006_16_22","DEU","16","22","22","ሶዱ ዸጋ ከን ዋቀዮ ዋቅንኬ ጅቡ ኦፊኬቲፍ ህንዻበትን። ");
INSERT INTO gaze_vpl VALUES ("DT17_1","006_17_1","DEU","17","1","1","ሰንጋ ዮካን ሆላ ፈፈ ዮካን ህርእነ ከምዩ ቀቡ ዋቀዮ ዋቀኬቲፍ ኣርሳ ህንዽኤስን፤ ወን አከሲ እሰ ብረት ጅብሲሳዻቲ። ");
INSERT INTO gaze_vpl VALUES ("DT17_2","006_17_2","DEU","17","2","2","ዮ ዺር ዮካን ዱበርቲን መጋላወን ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ኬሳ ቶኮ ኬሰ ግዱኬ ጅራቱ ቶኮ ከኩሳ ጨብሱዻን ፉለ ዋቀዮ ዋቀኬቲ ዱረት ዋን ሀማ ሆጄቴ አርገሜ፣ ");
INSERT INTO gaze_vpl VALUES ("DT17_3","006_17_3","DEU","17","3","3","ዮ አጀጀኮ ደርቤ ዋቆተ ኦርማ ዋቄፈቴ፣ ገድ ጄዼ ቢፍቱፍ ዮካን ጅኣፍ ዮካን ኡርጂወን ሰሚቲፍ ሰገዴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT17_4","006_17_4","DEU","17","4","4","ዮ ወን ኩን ስት ህመሜ አትስ ዸጌሴ፣ ዱብቸ ገድ ቀቢ አከ ጋሪት ቆረዹ፤ ዮ ወን ጄዸሜ ሱን ዹጋ ተኤ ወን ጅብሲሳን አከሲ እስራኤል ኬሰት ሆጄተሙንሳ ምርከናኤ፣ ");
INSERT INTO gaze_vpl VALUES ("DT17_5","006_17_5","DEU","17","5","5","ነምቸ ዮካን ዱበርቲ ዋን ሀማ ከነ ሆጄቴ ገረ በልበለ መጋላ ሰናት ጌሲቲ ዸጋዻን ቱሚ አጄስ። ");
INSERT INTO gaze_vpl VALUES ("DT17_6","006_17_6","DEU","17","6","6","ነምን ዱት እሳፍ መሉ ቶኮ ዹገ በኡምሰ ነመ ለማ ዮካን ሰዲቲን ሃአጄፈሙ፤ ገሩ ዹገ በኡምሰ ነመ ቶኮ ቆፋን ነምን ከምዩ አጄፈሙ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("DT17_7","006_17_7","DEU","17","7","7","ዮሙ አጄፈሙስ ጀልቀበት ሀርክ ዹገ ባቶታ፣ እት ኣንሴሞ ከን ሰባ እሰረ ሃቡኡ፤ አት ዋን ሀማ ኦፍ ኬሳ ባሱ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT17_8","006_17_8","DEU","17","8","8","ዮ ዱቢወን ሙርቴሱፍ ረክሳ ተአን መነ ሙርቲኬት ዽኣተን ጄቹንስ ከን አከ ዺገ ዸንገላሱ፣ ወል ሞርሚ ሴረ ቶኮቲፊ ከን ብራ፣ ዮካን ሚዻ ዸግነረ ገኡ ከን ገራ ገራ ግዱት ወን ሙርቲ ኬኑፍ ረክሱ ዮ ከኤ፣ አት ለፈ ዋቀዮ ዋቅንኬ ፍለቱት ጌስ። ");
INSERT INTO gaze_vpl VALUES ("DT17_9","006_17_9","DEU","17","9","9","ገረ ሌዎተ ወረ ሉቦተ ተአኒቲፊ ቆንዳልቶተ ዬሮ ሰነ ሆጂረ ቱረኒ ዸቅ። ዋኤ ዱቢ ሰና እሳኒን መርአዹ፤ እሳንስ ሙርቲሳ ስት ህሙ። ");
INSERT INTO gaze_vpl VALUES ("DT17_10","006_17_10","DEU","17","10","10","አትስ አኩመ ያደ እሳን ሲፍ ኬነን ሰናት እዶ ዋቀዮ ፍለቱት ሙርቲ ኬኑ ቀብደ። ዋን ሁንደ ቀጄልፈመ እሳን ሲፍ ኬነኒን ሆጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT17_11","006_17_11","DEU","17","11","11","አከ ሴረ እሳን ስ በርሲሰኒቲፊ አከ ቀጄልፈመ እሳን ሲፍ ኬነኒት ሆጄዹ። ዋን እሳን ስት ህመንራ ምርገት ዮካን ብታት ህንጎርን። ");
INSERT INTO gaze_vpl VALUES ("DT17_12","006_17_12","DEU","17","12","12","ነምን አባ ሴራ ዮካን ሉበ ዋቀዮ ዋቀኬ ተጃጅሉፍ አች ዻበቱ ቱፈቱ ሃአጄፈሙ። አት ዋን ሀማ እስራኤል ኬሳ ባሱ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT17_13","006_17_13","DEU","17","13","13","ሰብን ሁንድስ ዋን ከነ ዸገኤ ንሶዳተ፤ እት ዴብኤስ ህንቱፈቱ። ");
INSERT INTO gaze_vpl VALUES ("DT17_14","006_17_14","DEU","17","14","14","አት ዮሙ ብየ ዋቀዮ ዋቅንኬ ሲፍ ኬኑት ገልቴ ዻልቱፊ ብየ ሰነ ኬሰ ቁበቴ፣ “አኩመ ሰቦተ ናኖኮ ጅራተኒት አንስ ሞቲ ኦፍ እረተን ሞስሰ” ጄቱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT17_15","006_17_15","DEU","17","15","15","ሞቲ ዋቀዮ ዋቅንኬ ፍለቱ ኦፍ እረት ሞስስ። ነመ ኦቦሌሰኬ እስራኤል ተኤ ኬሳ መሌ ነመ ብየ አላ ኦፍ እረት ህንሞስስን። ");
INSERT INTO gaze_vpl VALUES ("DT17_16","006_17_16","DEU","17","16","16","ሰበቢ ዋቀዮ፣ “ለመተ ገረስ ህንዴብተን” ጄዼ ስት ህሜፍ፣ ሞትች ኦፊሳቲ ፈርዴን ህንባይእፈትን ዮካን ለኮብሰ ፈርዴኒ ባይእፈቹፍ ጄዼ ገረ ግብጥት ሰበ ህንዴብስን። ");
INSERT INTO gaze_vpl VALUES ("DT17_17","006_17_17","DEU","17","17","17","አከ ያድንሳ ህንበድኔፍ እን ኒቶተ ባይኤ ፉዹ ህንቀቡ፤ ሜቲፊ ወርቄ ባይእሴስ ወልት ቀበቹ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("DT17_18","006_17_18","DEU","17","18","18","እን ዮሙ ቴሶ ሞቱማሳረ ታኡት ገረገልቻ ሴረ ከና ሉቦተ ሌዎተ ተአንራ ፉዸቴ ክታበ መረማረት ኦፊሳቲ ሃበሬፈቱ። ");
INSERT INTO gaze_vpl VALUES ("DT17_19","006_17_19","DEU","17","19","19","እን አከ ዋቀዮ ዋቀሳ ሶዳቹ በረቱፍ ዱቢ ሴረ ከና ሁንዳፊ አጀጀወን ከኔን ኦፍ ኤገናዻን ዱካ ቡኡፍ ክታብች እሰ ወጅን ሃቱሩ፤ እንስ በረ ጅሬኘሳ ጉቱ ሃዱብሱ፤ ");
INSERT INTO gaze_vpl VALUES ("DT17_20","006_17_20","DEU","17","20","20","ኩንስ አከ እን አከ ዋን ኦቦሎተሳ ጫሉት ኦፍ እላሌ ሴርቸራ ገረ ምርጋት ዮካን ብታት ህንጎሬፍ። አከሲንስ እኒፊ ሰኚንሳ ሞቱማሳረት እስራኤል ኬሰት በረ ዼራዻፍ ንሞኡ። ");
INSERT INTO gaze_vpl VALUES ("DT18_1","006_18_1","DEU","18","1","1","ሉቦትን ወር ሌዎተ ተአን ጄቹንስ ጎስት ሌዊ ሁንድ እስራኤል ወጅን ቆደ ለፋ ዮካን ዻለ ህንአርገተን። እሳን ኣርሳ እብዳን ዋቀዮፍ ዽኣቱራ ሃኛተን፤ ኩን ቆደሳኒቲ። ");
INSERT INTO gaze_vpl VALUES ("DT18_2","006_18_2","DEU","18","2","2","እሳን ኦቦሎተሳኒ ግዱት ዻለ ቶኮዩ ህንቀባትን፤ አኩመ እን እሳን አብደቺሴት ዋቀዮ ዻለሳኒቲ። ");
INSERT INTO gaze_vpl VALUES ("DT18_3","006_18_3","DEU","18","3","3","ቆድን ሉቦትን ሰበ ኣርሳ ኮርማ ዮካን ሆላ ዽኤሱራ አርገቹ መለን ፎን ሀርካ፣ ከን መንጋጋቲፊ ምአ ገራት። ");
INSERT INTO gaze_vpl VALUES ("DT18_4","006_18_4","DEU","18","4","4","መታ ምዻንኬቲ፣ ዳዺ ወይኒ ሃራፊ ዘይቲኬ ከን ጀልቀባ አከሱመስ ሱፊ ጀልቀባ ከን ሆላኬራ ሃዱሳኒ ኬኑ ቀብደ፤ ");
INSERT INTO gaze_vpl VALUES ("DT18_5","006_18_5","DEU","18","5","5","ኩንስ ሰበቢ ዋቀዮ ዋቅንኬ አከ እሳን ዬሮ ሁንደ ዻበተኒ መቃ ዋቀዮቲን ተጃጅለኒፍ ጎሶተኬ ሁንደ ኬሳ ሰኚሳኒ ፍለቴፍ። ");
INSERT INTO gaze_vpl VALUES ("DT18_6","006_18_6","DEU","18","6","6","ሌውች ቶኮ ዮ መጋላወንኬ ከኔን ጉቱማ እስራኤል ኬሰት አርገመን ከምዩ ኬሳ እዶ ጅራቱ በኤ ገራ ጉቱዻን እዶ ዋቀዮ ዋቅን ፍለቱ ዹፌ፣ ");
INSERT INTO gaze_vpl VALUES ("DT18_7","006_18_7","DEU","18","7","7","እንስ አኩመ ሌዎተ ፉለ ዋቀዮ ዱረ ዻበተኒ ተጃጅለኒት አችት መቃ ዋቀዮ ዋቀሳቲን ሃተጃጅሉ። ");
INSERT INTO gaze_vpl VALUES ("DT18_8","006_18_8","DEU","18","8","8","እን ቀቤኘ ማቲሳ ከን ጉርጉረሙራ ማለቀ አርገቱሌ ሌዎተ ምቾተሳ ወጅን ፋይዳ አርገሙ ወል ቅጤ ህርማቹ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("DT18_9","006_18_9","DEU","18","9","9","አት ዮሙ ብየ ዋቀዮ ዋቅንኬ ሲፍ ኬኑት ገልቱት፣ ሆጂ በልፈማ ሰቦትን አች ጅራተን ሆጄተን ሰነ ሆጄቹ ህንበረትን። ");
INSERT INTO gaze_vpl VALUES ("DT18_10","006_18_10","DEU","18","10","10","ነምን እልመሳ ዮካን እንተለሳ እብደት ኣርሳ ጎዹ፣ ነምን ዋ ህሙ ዮካን ፈልፈለ ሆጄቱ፣ ነምን ምልኪ እላሉ፣ ቶልፈቱን፣ ");
INSERT INTO gaze_vpl VALUES ("DT18_11","006_18_11","DEU","18","11","11","ዮካን ጥባርቱን፣ እላልቱን ዮካን ኤኬር ዱብስቱን ዮካን ነምን ነመ ዱኤ ወጅን ዱበቱ ቶኮዩ ግዱኬት ህንአርገምን። ");
INSERT INTO gaze_vpl VALUES ("DT18_12","006_18_12","DEU","18","12","12","ነምን ዋን አከሲ ሆጄቱ ከምዩ ፉለ ዋቀዮ ዱረት በልፈማዸ፤ ሰበቢ ሆጂ ጅብሲሳ ከናቲፍስ ዋቀዮ ዋቅን ፉለኬ ዱራ ሰቦተ አርኤ ንባሰ። ");
INSERT INTO gaze_vpl VALUES ("DT18_13","006_18_13","DEU","18","13","13","አት ፉለ ዋቀዮ ዋቀኬቲ ዱረት ህርእነ መሌ ጅራቹ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT18_14","006_18_14","DEU","18","14","14","ሰቦትን አት ለፈሳኒራ ቡቅፍቱ ወረ ፈልፈለ ሆጄተን ዮካን ወረ እላለኒዸ። ገሩ አከ አት ዋን አከሲ ሆጄቱ ዋቀዮ ዋቅንኬ ሲፍ ህንኤየመምኔ። ");
INSERT INTO gaze_vpl VALUES ("DT18_15","006_18_15","DEU","18","15","15","ዋቀዮ ዋቅንኬ ኦቦሎተኬ ኬሳ ራጂ አከኮቲ ቶኮ ሲፍ ካሰ። አትስ እሰ ዸገኡ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT18_16","006_18_16","DEU","18","16","16","ወን አት ጋፈ ወልዳን ኮሬብት ወልት ቀበሜ፣ “አን አከ ህንዱኔፍ ለመተ ሰገሌ ዋቀዮ ዋቀኮቲ ህንዸገኡ ዮካን እብደ ጉዳ ከነ ስአች ህንአርጉ” ጄቴ ዋቀዮን ዋቀኬ ከዸቴ ከናቲ። ");
INSERT INTO gaze_vpl VALUES ("DT18_17","006_18_17","DEU","18","17","17","ዋቀዮ አከነ ናን ጄዼ፦ “ወን እሳን ጄዸን ጋሪዸ። ");
INSERT INTO gaze_vpl VALUES ("DT18_18","006_18_18","DEU","18","18","18","አን ራጂ አከኬቲ ኦቦሎተሳኒ ግዱዻ እሳኒፍ ነንካሰ፤ ዱቢኮ አፋንሳ ኬሰ ነንካአ፤ እንስ ዋን አን እሰ አጀጁ ሁንደ እሳንት ህመ። ");
INSERT INTO gaze_vpl VALUES ("DT18_19","006_18_19","DEU","18","19","19","ነመ ዱቢኮ ከን ራጂን መቃኮቲን ዱበቱ ዸገኡ ድዱ ከምዩ፣ አን መታንኮ እሰ ነንጋፈዸ። ");
INSERT INTO gaze_vpl VALUES ("DT18_20","006_18_20","DEU","18","20","20","ገሩ ራጂን ዋን መቃኮቲን ዱበቱ ፈኬሴ ዋን አን አከ እን ዱበቱ እሰ ህንአጀጅን ከምዩ ዱበቱ ዮካን ከን መቃ ዋቆተ ብራቲን ዱበቱ ሃአጄፈሙ።” ");
INSERT INTO gaze_vpl VALUES ("DT18_21","006_18_21","DEU","18","21","21","አት ገራኬት፣ “ኑ ዱቢ ዋቀዮ ኑት ህንዱበትን አከምት ቤኩ ደንዴኘ?” ጄተ ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT18_22","006_18_22","DEU","18","22","22","ዮ ወን ራጂን ቶኮ መቃ ዋቀዮቲን ዱበቴ ኡቱ ህንጉተምን ሀፌ፣ ዱቢን ሱን ዱቢ ዋቀዮ ህንዱበትኒዸ። ራጂን ሱን እት ፈኬሴ ዱበቴራቲ እሰ ህንሶዳትን። ");
INSERT INTO gaze_vpl VALUES ("DT19_1","006_19_1","DEU","19","1","1","ዮሙ ዋቀዮ ዋቅንኬ ሰቦተ ብየሳኒ ሲፍ ኬኑ በሌሱት፣ ዮሙ አት አሪቴ እሳን ባፍቴ መጋላወኒፊ መኔንሳኒ ኬሰ ቁበቱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT19_2","006_19_2","DEU","19","2","2","ወለካ ብየ ዋቀዮ ዋቅንኬ አከ አት ዻልቱፍ ሲፍ ኬኑት ኦፊኬቲፍ መጋላወን ሰዲ አዳን ባፈዹ። ");
INSERT INTO gaze_vpl VALUES ("DT19_3","006_19_3","DEU","19","3","3","አከ ነምን ነመ አጄሴ ከምዩ እት በቀቱፍ ዳንዲወን ሆጄዹቲ ብየ ዋቀዮ ዋቅንኬ አከ ዻላት ሲፍ ኬኑ እዶ ሰዲት ቆድ። ");
INSERT INTO gaze_vpl VALUES ("DT19_4","006_19_4","DEU","19","4","4","ሴር ዋኤ ነመ ነመ አጄሴ ሉቡሳ ባፈቹፍ አችት በቀቱ ጄቹንስ ከን ኡቱ ሀምነ እት ህንያድን አከ ተሳ ነመ ኦላሳ አጄሱ ቶኮ እላሉ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("DT19_5","006_19_5","DEU","19","5","5","ነምን ቶኮ ዮ ሙከ ሙረቹፍ ነምቸ ኦላሳ ወጅን ቦሶነ ሴኔ ኡቱ ሙከ ሙሩፍ ቆቶሳ ኦል ፉዸቱ አኩመ ተሳ ስቢል እራ ቡቀኤ ነምቸ ኦላሳ ሰነ ዸኤ አጄሴ፣ ነምን ሱን መጋላወን ከኔን ኬሳ እሰ ቶኮት በቀቴ ሉቡ ኦፊሳ ኦልፈቹ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("DT19_6","006_19_6","DEU","19","6","6","ዮ ከና አቺ ነምን ሃሎ ዺጋ ባሱ ቶኮ ዋን ነምች ነመ አጄሴ ሱን ኡቱ ዱራን ዱርሴ ሀምነ እት ህንያድን ኦላሳ አጄሴፍ ዮ አጄፈሙ ህንቀባትንሌ ፈጎ ተኡዩ እን ኣሪዻን ዱካ ቡኤ ቀቀቤ እሰ አጄሱ ደንደአ። ");
INSERT INTO gaze_vpl VALUES ("DT19_7","006_19_7","DEU","19","7","7","ሰበቢን አን አከ አት መጋላ ሰዲ ኦፊኬቲፍ አዳን ባፈቱ ስ አጀጄፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("DT19_8","006_19_8","DEU","19","8","8","ዮ ዋቀዮ ዋቅንኬ አኩመ አቦቲኬቲፍ ከኩዻን ዋዳ ገሌ ሰነት ብየኬ ሲፍ በልእሴ ብየ ዋዳ እሳኒፍ ገሌ ሰነ ጉቱማት ሲፍ ኬኔ፣ ");
INSERT INTO gaze_vpl VALUES ("DT19_9","006_19_9","DEU","19","9","9","አት ዋቀዮን ዋቀኬ አከ ጃለቹፊ ዬሮ ሁንደ ከራሳረ አከ ዴምቱፍ አጀጀወን አን ሀርአ ሲፍ ኬኑ ሁንደ አከ ጋሪት ዮ ኤግዴ፣ መጋላወን ከኔንረት መጋላወን ሰዲ ንደበለተ። ");
INSERT INTO gaze_vpl VALUES ("DT19_10","006_19_10","DEU","19","10","10","አከ ለፈኬ ከን ዋቀዮ ዋቅንኬ ዻለ ጎዼ ሲፍ ኬኑ ኬሰት ዺግን ነመ ቁልቁሉ ህንዸንገላኔፊ አትስ የከ ዺገ ዸንገላሱት አከ ህንጋፈተምኔፍ ዋን ከነ ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("DT19_11","006_19_11","DEU","19","11","11","ገሩ ዮ ነምን ቶኮ ነመ ኦላሳ ጅቤ ርጴ ኤገቹዻን ሚዻ እራን ገኤ እሰ አጄሴ ኤርገሲሞ መጋላወን ከኔን ኬሳ ቶኮት በቀቴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT19_12","006_19_12","DEU","19","12","12","ማንጉዶትን መጋላ እን ኬሰ ጅራቻ ቱሬ ነመ እት ኤርገኒ መጋላ እን እት በቀቴ ሰና እሰ ሃፍችሲሰን፤ አከ እን አጄሱፍስ ነመ ሃሎ ዺጋ በኡት ደበርሰኒ እሰ ሃኬነን። ");
INSERT INTO gaze_vpl VALUES ("DT19_13","006_19_13","DEU","19","13","13","ገራ ህንላፍኒፍ፤ አከ ሲፍ ቶሉፍ የከ ዸንገላፈመ ዺገ ነመ ቁልቁሉ እስራኤል ኬሳ በሌስ። ");
INSERT INTO gaze_vpl VALUES ("DT19_14","006_19_14","DEU","19","14","14","ብየ ዋቀዮ ዋቅንኬ አከ ዻልቱፍ ሲፍ ኬኑ ኬሰት ዻለ ደበርፈሜ ሲፍ ኬነሙረት ዸጋ መለቶ ዳንጋ ኦላኬቲ ከን ነሞትን ዱሪ ዻበን ህንሂቅስን። ");
INSERT INTO gaze_vpl VALUES ("DT19_15","006_19_15","DEU","19","15","15","ነመ የከ ዮካን ሴረ ጨብሱ ከሚንዩ ህመተሜ ቶኮት ሙሩፍ ዹገ በኡምስ ነመ ቶኮ ገኣ ምት። ዱቢን ሱን ዹገ ባቶተ ለማን ዮካን ሰዲን ምርከኔፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("DT19_16","006_19_16","DEU","19","16","16","ዮ ዹገ ባቱን ጀልኣን ቶኮ ሶባን ነመ ቶኮት ዹጋ በኤ፣ ");
INSERT INTO gaze_vpl VALUES ("DT19_17","006_19_17","DEU","19","17","17","ነሞትን ወል ዸበን ለማን ፉለ ዋቀዮ ዱረት ሉቦታፊ አቦቲ ሙርቲ ከኔን ዬሮ ሰነት ሆጂረ ጅረን ዱረ ሃዻበተን። ");
INSERT INTO gaze_vpl VALUES ("DT19_18","006_19_18","DEU","19","18","18","አቦቲን ሙርቲስ ዱብቸ ገድ ፈጌሰኒ ሃቆረን፤ ዮ ዹገ ባቱን ሱን ሶብዱ ተኡንሳ ምርከናኤ ኦቦሌሰሳረት ሶባን ዹጋ በኤ፣ ");
INSERT INTO gaze_vpl VALUES ("DT19_19","006_19_19","DEU","19","19","19","ዋኑመ እን ኦቦሌሰሳ ጎቹ ያዴ ሰነ እሰ ጎዻ። አት ሀማ ኦፍ ኬሳ ባሱ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT19_20","006_19_20","DEU","19","20","20","ነሞትን ሀፈን ዋን ከነ ዸገአኒ ንሶዳቱ፤ ወን ሀማን አከሲስ ለመተ ግዱኬት ህንሆጄተሙ። ");
INSERT INTO gaze_vpl VALUES ("DT19_21","006_19_21","DEU","19","21","21","አት ገረ ላፍነ ቶኮዩ ህንአርግሲስን፤ ቆደ ሉቡ ሉቡን፣ ቆደ እጃ እጅ፣ ቆደ እልካኒ እልካን፣ ቆደ ሀርካ ሀርክ፣ ቆደ ሚላስ ሚል ባፈሙ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("DT20_1","006_20_1","DEU","20","1","1","ሰበቢ ዋቀዮ ዋቅንኬ እን ብየ ግብጢቲ ስ ባሴ ሱን ስ ወጅን ጅሩፍ ዮሙ ዲኖተኬ ሎሉፍ ባቱት ፈርዴኒፊ ጋሪወን አከሱመስ ሁምነ ወራና ከን ሁምነ ወራናኬ ጫሉ አርግቱት ህንሶዳትን። ");
INSERT INTO gaze_vpl VALUES ("DT20_2","006_20_2","DEU","20","2","2","ዮሙ አት ወራነት ዽኣቱት ሉብን ፉለ ዱረት በኤ ሎልቶተት ሃዱበቱ። ");
INSERT INTO gaze_vpl VALUES ("DT20_3","006_20_3","DEU","20","3","3","እንስ አከነ ሃጄዹ፤ “ያ እስራኤል፣ እስን ሀርአ ዲኖተኬሰን ሎሉፍ ወራነት ሴኑፍ ጅርቱ። ገራንኬሰን ህንራፈምን ዮካን ህንሶዳትና፤ ህንነእና ዮካን ፉለ ዲኖተኬሰኒ ዱረት ህንሆለትና። ");
INSERT INTO gaze_vpl VALUES ("DT20_4","006_20_4","DEU","20","4","4","ከን ሞአትና እስኒፍ ኬኑፍ ጄዼ ዲኖተኬሰን እስኒፍ ሎሉፍ እስን ወጅን በኡ ዋቀዮ ዋቀኬሰኒቲ።” ");
INSERT INTO gaze_vpl VALUES ("DT20_5","006_20_5","DEU","20","5","5","አጀጆትን ሎልቶታሞ ሎልቶታን አከነ ሃጄዸን፦ “ነምን መነ ሃራ እጃሬ ህንኤብሲስን ቶኮዩ ጅራ? እን ገረ መነሳት ሃዴብኡ፤ ዮ ከና አቺ እን ወራነረት ዱኤ ነምን ብራ መነሳ ኤብሰ። ");
INSERT INTO gaze_vpl VALUES ("DT20_6","006_20_6","DEU","20","6","6","ነምን ወይኒ ዻቤራ ህንኛትን ጅራ? እን ገረ መነሳ ሃዴሙ፤ ዮ ከና አቺ እን ሎለ ኬሰት ዱኤ ነምን ብራ ወይኒ ሰነ ኛተ። ");
INSERT INTO gaze_vpl VALUES ("DT20_7","006_20_7","DEU","20","7","7","ነምን ኒቲ ፉዹፍ ከዸቴ ኡቱ ህንፉዽን ዹፌ ጅራ? እን ገረ መነሳ ሃዴሙ፤ ዮ ከና አቺ እን ሎለረት ዱኤ ነምን ብራ እሼ ፉዸ።” ");
INSERT INTO gaze_vpl VALUES ("DT20_8","006_20_8","DEU","20","8","8","አጀጆትን ሎልቶታ አመስ፣ “ነምን ሶዳቱ ዮካን ከን ገራንሳ ራፈሙ ጅራ? አከ ገራን ኦቦሎተሳስ ህንራፈምኔፍ እን ገረ መነሳት ሃዴብኡ” ሃጄዸን። ");
INSERT INTO gaze_vpl VALUES ("DT20_9","006_20_9","DEU","20","9","9","አጀጆትን ዮሙ ሎልቶተት ዱበተኒ ራወተንት ሎልቶተረት አጀጆተ ሃሙደን። ");
INSERT INTO gaze_vpl VALUES ("DT20_10","006_20_10","DEU","20","10","10","አት ዮሙ መጋላ ቶኮ ዸኡፍ ባቱት፣ ዱራን ዱርሲ ነሞተ መጋላ ሰነ ኬሰ ጅራተኒፍ ዋምቸ ነጋ ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("DT20_11","006_20_11","DEU","20","11","11","ዮ እሳን ቶሌ ጄዸኒ በልበለ ሲፍ በነን፣ ነምን ሁንድ ሲፍ ሃቡሉ፤ ሆጄታኬስ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("DT20_12","006_20_12","DEU","20","12","12","ዮ እሳን ዋምቸ ነጋ ፉዸቹ ድደኒ ወራናፍ ስት በአን አት መጋለቲ መርስ። ");
INSERT INTO gaze_vpl VALUES ("DT20_13","006_20_13","DEU","20","13","13","ዮሙ ዋቀዮ ዋቅንኬ ደበርሴ እሳን ስት ኬኑት ዺሮተ መጋለቲ ኬሰ ጅራተን ሁንደ ጎራዴዻን ፍጥ። ");
INSERT INTO gaze_vpl VALUES ("DT20_14","006_20_14","DEU","20","14","14","ገሩ ነዼኒፊ እጆሌ፣ ሆሪፊ ዋን መጋለቲ ኬሰት አርገሙ ሁንደ ቦጅኢቲ ኦፊኬቲ ፉዸዹ፤ አት ቦጁ ዋቀዮ ዋቅንኬ ዲኖተኬረት ሲፍ ኬኔት ፈየደሙ ንደንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("DT20_15","006_20_15","DEU","20","15","15","አክ አት መጋላወን ሰቦተ ናኖኬቲ ህንተእን ከኔን አከ መሌ ፈጎ ተአን ጎቱስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("DT20_16","006_20_16","DEU","20","16","16","ተኡስ መጋላወን ሰቦተ ዋቀዮ ዋቅንኬ አከ ዻላት ሲፍ ኬኑ ኬሰት ዋን ሀፉረ ባፈቱ ቶኮሌ ህንሀምብስን። ");
INSERT INTO gaze_vpl VALUES ("DT20_17","006_20_17","DEU","20","17","17","አኩመ ዋቀዮ ዋቅንኬ ስ አጀጄት ጉቱማን ጉቱት እሳን በርበዴስ፤ እሳንስ ሄቶተ፣ አሞሮተ፣ ከነኣኖተ፣ ፌርዞተ፣ ሂዎታፊ ዬቡሶተ። ");
INSERT INTO gaze_vpl VALUES ("DT20_18","006_20_18","DEU","20","18","18","ዮ ከና አቺ አከ አት ዋን ጅብሲሳ እሳን ዋቆተሳኒ ዋቄፈቹዻን ሆጄተን ሰነ ዱካ ቡቱ ስ በርሲሱ፤ አትስ ዋቀዮ ዋቀኬት ጩቡ ሆጄተ። ");
INSERT INTO gaze_vpl VALUES ("DT20_19","006_20_19","DEU","20","19","19","አት ዮሙ ዬሮ ዼራዻፍ መጋላ ሰነ መርስቴ ቀበቹዻፍ እሼ ወራንቱት፣ ሙኬንሼ ቆቶዻን ጭርቴ ህንበሌስን፤ አት ምዻንሳኒ ኛቹ ደንዴሳቲ እሳን ህንጭርን። አት ከን እሳን መርስቱ ሙኬን ቦሶና ነሞተ ተአኒቲ? ");
INSERT INTO gaze_vpl VALUES ("DT20_20","006_20_20","DEU","20","20","20","ገሩ ሀመ መጋላን ስ ወጅን ወል ሎልቱ ሱን ኩፍቱት ሙኬን አከ እሳን ጉማ ህንነቀትኔ ቤክቱ ሙርቴ ሆጂ እጃርሰ መርሱቲፍ እት ፈየደሙ ንደንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("DT21_1","006_21_1","DEU","21","1","1","ዮ ነምን ቶኮ ብየ ዋቀዮ ዋቅንኬ አከ ዻልቱፍ ሲፍ ኬኑ ኬሰት ዱኤ አርገሜ ነምን እሰ አጄሴ ህንቤከምን፣ ");
INSERT INTO gaze_vpl VALUES ("DT21_2","006_21_2","DEU","21","2","2","ማንጉዶትንኬቲፊ አቦቲን ሙርቲኬ ዸቀኒ ፈጌኘ እዶ እን እት ዱኤፊ መጋላወን እት ዽኣተን ግዱ ጅሩ ሃሰፈረን። ");
INSERT INTO gaze_vpl VALUES ("DT21_3","006_21_3","DEU","21","3","3","ኤርገሲስ ማንጉዶትን መጋላ ሬፍቸት ኣንቱ ኬሰ ጅራተን ጎሮምሰ ተኩማ ህንሆጄትን ከን ዋንጆ ህንባትን ፉዸኒ ");
INSERT INTO gaze_vpl VALUES ("DT21_4","006_21_4","DEU","21","4","4","ጎሮምሰ ሰነ ገረ ሱሉለ ህንቆተምን ዮካን ወን ቶኮዩ እረ ህንፈጫፈምን ከን ብሻን ያኡ ቀቡት ሃጌሰን። ሱሉለ ሰነ ኬሰትስ ሞርመ ጎሮምሰ ሰና ሃጨብሰን። ");
INSERT INTO gaze_vpl VALUES ("DT21_5","006_21_5","DEU","21","5","5","ሉቦትን ጄቹንስ እልማን ሌዊ ሰበቢ አከ ተጃጅለኒፊ አከ መቃ ዋቀዮቲን ኤብሰኒፍ፣ አከ ዱቢ ወል ዸቢሳቲፊ ሚዻ ዸግና ከምረትዩ ሙርቲ ኬነኒፍ ዋቀዮ ዋቀኬቲን ፍለተመኒፍ እሳን ፉልዱራት ሃዽኣተን። ");
INSERT INTO gaze_vpl VALUES ("DT21_6","006_21_6","DEU","21","6","6","ኤርገሲ ማንጉዶትን መጋላ ሬፍቸት ባይኤ ዽኣቱ ሁንድ ጎሮምሰ ሱሉለ ኬሰት ሞርም ጨብሰሜ ሰነረት ሀርከሳኒ ሃዽቀተን። ");
INSERT INTO gaze_vpl VALUES ("DT21_7","006_21_7","DEU","21","7","7","እሳንስ አከነ ሃጄዸን፦ “ሀርክኬኘ ዺገ ከነ ህንዸንገላፍኔ ዮካን ዮሙ ወን ኩን ሆጄተሜ እጅኬኘ ህንአርግኔ። ");
INSERT INTO gaze_vpl VALUES ("DT21_8","006_21_8","DEU","21","8","8","ያ ዋቀዮ፣ ኣርሳ አራራ ከነ ሰበኬ እስራኤል ከን ፉርቴ ሰናፍ ፉዸዹ፤ ዺገ ነመ ቁልቁሉ ከናስ ሰበኬት ህንሄሬግን። የኪ ዺገ ዸንገላፈሜስ እሳኒ ሃዺፈሙ። ");
INSERT INTO gaze_vpl VALUES ("DT21_9","006_21_9","DEU","21","9","9","አትስ ሰበቢ ዋን ፉለ ዋቀዮ ዱረት ቀጄላ ተኤ ሆጄቴፍ የከ ዸንገላፈሙ ዺገ ነመ ቀጄላ አከሲን ግዱኬቲ ንበሌስተ።” ");
INSERT INTO gaze_vpl VALUES ("DT21_10","006_21_10","DEU","21","10","10","አት ዮሙ ዲኖተኬ ሎሉፍ ዱልቴ ዋቀዮ ዋቅንኬ ደበርሴ ሀርከኬት እሳን ሲፍ ኬኔ ቦጁ ፉዸቱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT21_11","006_21_11","DEU","21","11","11","ዮ ወረ ቦጅአመን ኬሰት ዱበርቲ በሬዱ ቶኮ አርግቴ እሼ ጃለቴ ኒቲ ኦፊኬቲ ጎዸቴ እሼ ፉዹ ደንዴሰ። ");
INSERT INTO gaze_vpl VALUES ("DT21_12","006_21_12","DEU","21","12","12","መነኬት እሼ ገልች፤ እሼንስ መታሼ ሃሃደቱ፤ ቄንሰሼስ ሃቆረቱ፤ ");
INSERT INTO gaze_vpl VALUES ("DT21_13","006_21_13","DEU","21","13","13","ኡፈተ እሼን ዬሮ ቦጅአምቴት ኡፈቻ ቱርቴስ እራ ባስ። ኤርገ እሼን መነኬ ኬሰ ጅራቴ ጅአ ቶኮ ጉቱ አባፊ ሃዸ እሼቲፍ ቦሴ ቦዴ አት እሼ ወጅን ጪፍቴ ዽርሰሼ ተኡ ደንዴሰ፤ እሼንስ ኒቲኬ ንታት። ");
INSERT INTO gaze_vpl VALUES ("DT21_14","006_21_14","DEU","21","14","14","አት ዮ እሼት ገመዱ ባቴ አከ እሼን ገረ ፌቴ ዴምቱ ገድ ዺስ። አት ዋን እሼ ሰልጵፍቴፍ እሼ ጉርጉሩ ዮካን አከ ገርብቲት እሼ እላሉ ህንቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("DT21_15","006_21_15","DEU","21","15","15","ነምን ቶኮ ዮ ኒቶተ ለመ ቀባቴ እሼ ቶኮ ጃለቴ ገሩ ለማንሳኒዩ እልማን ደአኒፍ፣ ዮ እልም ሀንገፍን ኒቲ እን ህንጃለትኔ ሰነራ ዸለቴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT21_16","006_21_16","DEU","21","16","16","ነምች ዮሙ ቀቤኘሳ እልማንሳቲፍ ቆዱት ምርገ ሀንገፉማ እልመ ኒቲ ጅቤ ሰና እልመ ኒቲ ጃለቱቲፍ ደበርሴ ኬኑ ህንቀቡ። ");
INSERT INTO gaze_vpl VALUES ("DT21_17","006_21_17","DEU","21","17","17","ገሩ እልመ ሀንገፍትቸ ኒቲ ህንጃለትኔ ሰነራ ዸልቼፍ ቆደ ዻለሳ ኬሳ ሀርከ ለመ ኬኑፊዻን እሰ ቤክስሱ ቀበ። እልም ሱን መለቶ ጀልቀባ ከን ጀብነ አባሳት። ምርግ ሀንገፉማ ከንሳት። ");
INSERT INTO gaze_vpl VALUES ("DT21_18","006_21_18","DEU","21","18","18","ነምን ቶኮ ዮ እልመ መተ ጀቤሳፊ ፍንጭላ አባፊ ሃዸሳቲፍ ህንአጀጀምኔፊ ከን ዮሙ እሰ አደበን ህንዸጌኜ ቀባቴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT21_19","006_21_19","DEU","21","19","19","አባፊ ሃትሳ ቀበኒ በልበለ መጋላሳ ዱረት ማንጉዶተት እሰ ሃፍደን። ");
INSERT INTO gaze_vpl VALUES ("DT21_20","006_21_20","DEU","21","20","20","እሳንስ፣ “ጉርባንኬኘ ኩን መተ ጀቤሳፊ ፍንጭላዸ፤ ኑፍ ህንአጀጀሙ፤ እን አልባዼሳፊ መቾፍቱዸ” ጄዸኒ ማንጉዶተት ሃህመን። ");
INSERT INTO gaze_vpl VALUES ("DT21_21","006_21_21","DEU","21","21","21","ኤርገሲስ ነሞትን መጋላሳ ሁንድ ዸጋዻን ቱመኒ እሰ አጄሱ። አት ሀማ ኦፍ ግዱዻ ባሱ ቀብደ። እስራኤሎን ሁንድ ዋን ከነ ዸገአኒ ንሶዳቱ። ");
INSERT INTO gaze_vpl VALUES ("DT21_22","006_21_22","DEU","21","22","22","ዮ ነምን ቶኮ ጩቡ አደቢ ዱአ እሰት ሙርሲሱ ሆጄቴ አጄፈሜ ሬፍሳ ሙከት ፈንፈሜ፣ ");
INSERT INTO gaze_vpl VALUES ("DT21_23","006_21_23","DEU","21","23","23","አት ሬፈሳ ሙከረ ቡልቹ ህንቀብዱ። ዋን ነምን ሙከረት ፈንፈሙ አባርሰ ዋቃ ጀለ ጅሩፍ እሰ ጋፉመ ሰነ አዋል። አት ብየ ዋቀዮ ዋቅንኬ አከ ዻላት ሲፍ ኬኑ ህንጡሬስን። ");
INSERT INTO gaze_vpl VALUES ("DT22_1","006_22_1","DEU","22","1","1","ኡቱ ሰንጋን ዮካን ሆላን ኦቦሌሰኬቲ በዳ ጅሩ ዮ አርግቴ፣ ዴብሲቲ እሰት ፍድ መሌ ጨልእፍቴ ብረ ህንደርብን። ");
INSERT INTO gaze_vpl VALUES ("DT22_2","006_22_2","DEU","22","2","2","ዮ ኦቦሌስ ሱን ስራ ፈጎ ጅራቴ ዮካን ዮ እሰ ቤኩ ባቴ ሰንጋ ዮካን ሆላ ሰነ ፉዺ ገሊቲ ሀመ እን በርባቸ ዹፉት ኦፍ ብረ ቱርስ። ኤርገሲ ዴብሲ እሳፍ ኬን። ");
INSERT INTO gaze_vpl VALUES ("DT22_3","006_22_3","DEU","22","3","3","ዮ ሀሬን ዮካን ወያን ዮካን ወን ፌዼዩ ኦቦሌሰኬ ጀላ በዴ አርግቴ አከሱመ ጎዽ መሌ ዺፍቴ ብረ ህንደርብን። ");
INSERT INTO gaze_vpl VALUES ("DT22_4","006_22_4","DEU","22","4","4","ዮ ሀሬን ዮካን ሰንጋን ኦቦሌሰኬቲ ከራረት ኩፌ አርግቴ አከ እን ኦል ካሴ ሚለሳቲን ዻቡ ገርጋር መሌ ብረ ህንደርብን። ");
INSERT INTO gaze_vpl VALUES ("DT22_5","006_22_5","DEU","22","5","5","ዱበርቲን ኡፈተ ዺራ ኡፈቹ ህንቀብዱ ዮካን ዺር ኡፈተ ዱበርቲ ኡፈቹ ህንቀቡ፤ ዋቀዮ ዋቅንኬ ነመ ዋን አከሲ ሆጄቱ ከምዩ ንጅባቲ። ");
INSERT INTO gaze_vpl VALUES ("DT22_6","006_22_6","DEU","22","6","6","አት ዮ መነ ስምብራ ከን ሙከረ ዮካን ለፈ ጅሩ ኡቱ ሃት ጩጪሼ ዮካን አንቃቁሼ ሀመቴ ጅርቱ ከራ ጭነት አርግቴ ሃዸ ሰነ ጩጪሼ ወጅን ህንፉዸትን፤ ");
INSERT INTO gaze_vpl VALUES ("DT22_7","006_22_7","DEU","22","7","7","አት ጩጪሼ ፉዸቹ ንደንዴሰ፤ ገሩ አከ ሲፍ ቶሌ በረ ዼራ ጅራቱፍ አከ ሃዸ ገድ ዺፍቴ ምርከኔፈዹ። ");
INSERT INTO gaze_vpl VALUES ("DT22_8","006_22_8","DEU","22","8","8","ዮሙ መነ ሃራ እጃርቱት አከ ነምን በንቲ መናራ ኩፌ መነኬት የከ ዸንገለኡ ዺጋ ህንፍድኔፍ ቀርቀረ በንቲሳት እትሰ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("DT22_9","006_22_9","DEU","22","9","9","እዶ ዻባ ወይኒኬቲ ኬሰ ሰኚ ጎሰ ለማ ህንፈጫስን፤ ዮ አት አከስ ጎቴ ሰኚ አት ፈጫፍቴ ሰነ ቆፈ ኡቱ ህንተእን እጅ እዶ ዻባ ወይኒኬቲስ ንበደ። ");
INSERT INTO gaze_vpl VALUES ("DT22_10","006_22_10","DEU","22","10","10","ቆትዮፊ ሀሬ ወልት ጨመዴ እቲን ህንቆትን። ");
INSERT INTO gaze_vpl VALUES ("DT22_11","006_22_11","DEU","22","11","11","ኡፈተ ሱፊፊ ቁንጬ ተልባ ከን ወልት ፎአሜ ዸአሜ ህንኡፈትን። ");
INSERT INTO gaze_vpl VALUES ("DT22_12","006_22_12","DEU","22","12","12","ሮገ ወያ ኡፈቱ አፍረንረት ሀንዳረ ቶልች። ");
INSERT INTO gaze_vpl VALUES ("DT22_13","006_22_13","DEU","22","13","13","ዮ ነምን ቶኮ ኒቲ ፉዼ ኤርገ እሼ ወጅን ጪሴ ቦዴ እሼ ጅቤ፣ ");
INSERT INTO gaze_vpl VALUES ("DT22_14","006_22_14","DEU","22","14","14","እሼስ ቃኔሴ መቃ በሌሱዻን፣ “አን ኒቲ ተነ ፉዼረ፤ ገሩ ዮሙ አን እሼ ወጅን ጪሴት ዋን ዱርቡማሼ ምርከኔሱ ህንአርገኔ” ጄዼ፣ ");
INSERT INTO gaze_vpl VALUES ("DT22_15","006_22_15","DEU","22","15","15","አባፊ ሃት እንተለቲ ረጋ ዱርቡማሼ ምርከኔሱ በልበለረት ማንጉዶተ መጋለቲት ሃዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("DT22_16","006_22_16","DEU","22","16","16","አባን እንተለቲስ ማንጉዶታን አከነ ሃጄዹ፤ “አን እንተለኮ ነመ ከነት ሄሩምሲሴረ፤ እን ገሩ እሼ ጅቤ። ");
INSERT INTO gaze_vpl VALUES ("DT22_17","006_22_17","DEU","22","17","17","መቃሼስ በሌሴ፣ ‘አን እንተለኬ ዱርቡማ እሼቲን ህንአርገኔ’ ጄዼ። ገሩ ረጋን ዱርቡማ እንተለኮቲ ምርከኔሱ ኩኖት።” ከነረት አባፊ ሃትሼ ፉለ ማንጉዶተ መጋለቲ ዱረት ወያ ሰነ ሃድሪርሰን፤ ");
INSERT INTO gaze_vpl VALUES ("DT22_18","006_22_18","DEU","22","18","18","ማንጉዶትን ሱንስ ነምቸ ሰነ ቀበኒ ሃአደበን። ");
INSERT INTO gaze_vpl VALUES ("DT22_19","006_22_19","DEU","22","19","19","እሳንስ ሰበቢ ነምች ኩን መቃ ዱርበ እስራኤል ቶኮ ጡሬሴፍ ሜቲ ሰቅሊ ዽበ ቶኮ ባስሰኒ አባ እንተለቲቲፍ ሃኬነን፤ እሼን ኒቲሳ ታቴ ሃጅራቱ፤ እንስ ሀመ ሉቡዻን ጅሩት እሼ ሂኩ ህንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("DT22_20","006_22_20","DEU","22","20","20","ተኡስ ዮ ህመናን ዽኣቴ ሱን ዹጋ ተኤ ረጋን ዱርቡማ እንተለቲ ምርከኔሱ ህንአርገምን፣ ");
INSERT INTO gaze_vpl VALUES ("DT22_21","006_22_21","DEU","22","21","21","እሼን በልበለ መነ አባሼ ዱረት ፍደምቴ ነሞትን መጋላሼ ሀመ እሼን ዱቱት ዸጋዻን እሼ ሃቱመን፤ እሼን ኡቱመ መነ አባሼ ጅርቱ ሰጋገሉዻን ጎቸ እስራኤል ኬሰት ቃኒ ተኤ ሆጄቴርት። አት ግዱኬቲ ዋን ሀማ ባሱ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT22_22","006_22_22","DEU","22","22","22","ዮ ነምን ቶኮ ኡቱ ኒቲ ነመ ብራ ወጅን ጪሱ አርገሜ ለማንሳኒዩ፣ ነምች እሼ ወጅን ጪሴፊ ዱበርቲን ሱን አጄፈሙ ቀቡ። አት እስራኤል ኬሳ ዋን ሀማ ባሱ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT22_23","006_22_23","DEU","22","23","23","ዮ ነምን ቶኮ ዱርበ ካዽመምቴ መጋላት አርጌ እሼ ወጅን ጪሴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT22_24","006_22_24","DEU","22","24","24","ዋን እሼን ኡቱ መጋላ ኬሰ ጅርቱ ነ ኦልቻ ጄቴ ህንእይኒፍ፣ ነምችሞ ዋን ኒቲ ነመ ብራ ሰልጵሴፍ፣ ለማንሳኒዩ ገረ በልበለ መጋላት ጌሳቲ ሀመ እሳን ዱአንት ዸጋዻን ቱማ። ዋን ሀማ ግዱኬሰኒ በሌሳ። ");
INSERT INTO gaze_vpl VALUES ("DT22_25","006_22_25","DEU","22","25","25","ገሩ ዮ ነምን ቶኮ ዱርበ ከዸተምቴ ቶኮ ባድያት አርጌ እሼ ጉዴዴ፣ ነምች ዋን ከነ ጎዼ ቆፍት ሃአጄፈሙ። ");
INSERT INTO gaze_vpl VALUES ("DT22_26","006_22_26","DEU","22","26","26","እንተለቲ ህንቱቅና፤ እሼን ጩቡ ዱኣን እሼ ገኡ ቶኮዩ ህንሆጄትኔቲ። ዱቢን አከሲ ነመ በላ ቡሴ ነምቸ ኦላሳ አጄሱን ወል ፈካተ፤ ");
INSERT INTO gaze_vpl VALUES ("DT22_27","006_22_27","DEU","22","27","27","ኩንስ ዋን ነምች ዱርበ ካዽመምቴ ሰነ ባድያት አርገቴ ዮ እይቴሌ ነምን እሼፍ ብርመቱ ህንአርገምኔፍ። ");
INSERT INTO gaze_vpl VALUES ("DT22_28","006_22_28","DEU","22","28","28","ነምን ቶኮ ዮ ዱርበ ህንካዽመምን ቶኮ አርጌ ሁምናን እሼ ጉዴዴ ወን ኩን ቤከሜ፣ ");
INSERT INTO gaze_vpl VALUES ("DT22_29","006_22_29","DEU","22","29","29","እን አባሼቲፊ ሜቲ ሰቅሊ ሸንተመ ሃባሱ። እን ዋን ጉዴዴ ዱርቡማሼ በሌሴፍ እሼ ፉዹ ቀበ። ሀመ ሉቡን ጅሩትስ እሼ ሂኩ ህንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("DT22_30","006_22_30","DEU","22","30","30","ነምን ቶኮ ኒቲ አባሳ ፉዹ ህንቀቡ፤ እን ስሬ አባሳ ህንጡሬስን። ");
INSERT INTO gaze_vpl VALUES ("DT23_1","006_23_1","DEU","23","1","1","ነምን ኮላፈሜ ዮካን ዸግን ሳለሳራ ሙረሜ ከምዩ ወልዳ ዋቀዮ ህንሴንን። ");
INSERT INTO gaze_vpl VALUES ("DT23_2","006_23_2","DEU","23","2","2","ነምን ሀራሙዻን ዸለቴ ዮካን ሰኚንሳ ከምዩ ሀመ ዸሎተ ኩርነፋት ወልዳ ዋቀዮ ህንሴንን። ");
INSERT INTO gaze_vpl VALUES ("DT23_3","006_23_3","DEU","23","3","3","ነምን ጎሰ አሞን ዮካን ጎሰ ሞኣብ ዮካን ሰኚንሳ ከምዩ ሀመ ዸሎተ ኩርነፋት ወልዳ ዋቀዮ ህንሴንን። ");
INSERT INTO gaze_vpl VALUES ("DT23_4","006_23_4","DEU","23","4","4","እሳን ዬሮ አት ግብጢ ባቴት ከራረት ቡዴናን ዮካን ብሻኒን ስ ህንስመትኔ፤ ቆደ ከና አከ እን ስ አባሩፍ በለኣም እልመ ቤኦር ነምቸ ብየ ጴቶር እሼ ጳዳን አራምት አርገምቱ ሰነ ኬሰ ጅራቱ ስት ብተን። ");
INSERT INTO gaze_vpl VALUES ("DT23_5","006_23_5","DEU","23","5","5","ተኡስ ዋቀዮ ዋቅንኬ አባርሰ ሰነ ኤበት ሲፍ ጌደሬ መሌ በለኣምን ህንዸጌኜ፤ ዋቀዮ ዋቅንኬ ስ ጃለታቲ። ");
INSERT INTO gaze_vpl VALUES ("DT23_6","006_23_6","DEU","23","6","6","አት ሀመ ሉቡዻን ጅርቱት አከ እሳን ነጌኛፊ በዻዹማ ቀባተን ህንበርባድን። ");
INSERT INTO gaze_vpl VALUES ("DT23_7","006_23_7","DEU","23","7","7","ዋን እን ኦቦሌሰኬ ተኤፍ ነመ ጎሰ ኤዶም ህንቱፈትን። አት ሰበቢ አከ አለጋት ብየሳ ኬሰ ጅራቴፍ ነመ ግብጥ ህንቱፈትን። ");
INSERT INTO gaze_vpl VALUES ("DT23_8","006_23_8","DEU","23","8","8","እጆሌን ዸሎተ ሰደፋ ከኔን እሳኒፍ ዸለተን ወልዳ ዋቀዮ ሴኑ ንደንደኡ። ");
INSERT INTO gaze_vpl VALUES ("DT23_9","006_23_9","DEU","23","9","9","ዮሙ ዲኖተኬ ሎሉፍ ባቱት ጡራኡማ ሁንደራ ኦፍ ኤግ። ");
INSERT INTO gaze_vpl VALUES ("DT23_10","006_23_10","DEU","23","10","10","ነምን ቶኮ ዮ ሀልከን አፌታ ዸንገላሱዻን ኦፍ ጡሬሴ እን ቁበተ ኬሳ ገድ በኤ አለ ሃቱሩ። ");
INSERT INTO gaze_vpl VALUES ("DT23_11","006_23_11","DEU","23","11","11","ገረ ገልገላ ገሩ ዽቀቴ ዬሮ አዱን ዺቱት ገረ ቁበታት ሃዴብኡ። ");
INSERT INTO gaze_vpl VALUES ("DT23_12","006_23_12","DEU","23","12","12","አት ቁበታን አለት ለፈ እት ገድ ባቱ ቆጴፈዹ። ");
INSERT INTO gaze_vpl VALUES ("DT23_13","006_23_13","DEU","23","13","13","ሜሻኬ ኬሳ ዋን እቲን ለፈ ቆቱ ቀባዹ፤ አት ዮሙ ገድ ቴሴ ካቱት ቦለ ቆቲቲ ብዮ እት ዴብስ። ");
INSERT INTO gaze_vpl VALUES ("DT23_14","006_23_14","DEU","23","14","14","ዋቀዮ ዋቅንኬ ስ ኤጉፊ ዲኖተኬ ደበርሴ ስት ኬኑዻፍ ቁበተኬ ኬሰ ዴዴብኣቲ፤ አከ እን ግዱኬት ዋን ጡራኣ አርጌ ስራ ህንዴብኔፍ ቁበንኬ ቁልቁሉ ተኡ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("DT23_15","006_23_15","DEU","23","15","15","ዮ ገርብች ቶኮ ኮሉ ስት ገሌ፣ አት ደበርስቴ ጎፍታሳት እሰ ህንኬንን። ");
INSERT INTO gaze_vpl VALUES ("DT23_16","006_23_16","DEU","23","16","16","እን ግዱኬ ለፈ ጃለቴፊ መጋላ ፍለቴ ኬሰ ሃጅራቱ። አትስ እሰ ህንጩንቁርስን። ");
INSERT INTO gaze_vpl VALUES ("DT23_17","006_23_17","DEU","23","17","17","ዺር ዮካን ዱበርቲን እስራኤል ከምዩ ሰጋገልቱ መነ ዋቀ ቶልፈማ ህንተእን። ");
INSERT INTO gaze_vpl VALUES ("DT23_18","006_23_18","DEU","23","18","18","ዱበርቲ ዮካን ዺረ ሰጋገሉ ቶኮራ አከ ገልቻት ኬና ፉቴ መነ ዋቀዮ ዋቀኬቲት ህንፍድን፤ ለቸንሳኒዩ ፉለ ዋቀዮ ዋቀኬቲ ዱረት ጅብሲሶዻቲ። ");
INSERT INTO gaze_vpl VALUES ("DT23_19","006_23_19","DEU","23","19","19","አት ማለቀ ዮካን ኛተ ዮካን ዋን ዸለ አርገምሲሱ ከምዩ ዸላን ኦቦሌሰኬቲፍ ህንልቄስን። ");
INSERT INTO gaze_vpl VALUES ("DT23_20","006_23_20","DEU","23","20","20","አት ነመ ኦርማራ ዸለ ጋፈቹ ንደንዴሰ፤ ገሩ አከ ዋቀዮ ዋቅንኬ ብየ አት ዻሉፍ እት ገልቱት ዋን ሀርክኬ ቱቄ ሁንዳን ስ ኤብሱፍ ኦቦሌሰኬራ ዸለ ህንፉዸትን። ");
INSERT INTO gaze_vpl VALUES ("DT23_21","006_23_21","DEU","23","21","21","አት ዮ ዋቀዮ ዋቀኬቲፍ ወሬገ ቶኮ ወሬግዴ፣ ሰበቢ ዋቀዮ ዋቅንኬ ጭምሴ ዋን ሰነ ስራ በርባዱፍ አከ ጩቡ ስት ህንታኔፍ ደፊቲ ኦፍራ ባስ መሌ ለፈረ ህንሀርክስን። ");
INSERT INTO gaze_vpl VALUES ("DT23_22","006_23_22","DEU","23","22","22","ዮ ወሬጉ ባቴ ገሩ አት ጩበማ ህንታቱ። ");
INSERT INTO gaze_vpl VALUES ("DT23_23","006_23_23","DEU","23","23","23","ዋን አረብንኬ ዱበቴ ጎቹፍ ኦፍ ኤገዹ፤ አፋኑመኬቲን ጃለቴ ዋቀዮ ዋቀኬቲፍ ወሬግዴርታቲ። ");
INSERT INTO gaze_vpl VALUES ("DT23_24","006_23_24","DEU","23","24","24","አት ዮ እዶ ዻባ ወይኒ ኦላኬቲ ኬሰ ሴንቴ፣ እጀ ፌቴ ሁንደ ኛዹ፤ ገሩ ቶኮሌ ጉቦኬ ኬሰ ህንካአን። ");
INSERT INTO gaze_vpl VALUES ("DT23_25","006_23_25","DEU","23","25","25","ዮ ለፈ ቆቲሳ ምዻን ኦላኬቲ ኬሰ ሴንቴ፣ አሼቲ ጭረቹ ንደንዴሰ፤ ገሩ ምዻንሳ ከን ዻበቱት ሃምቱኬ ህንቡስን። ");
INSERT INTO gaze_vpl VALUES ("DT24_1","006_24_1","DEU","24","1","1","ነምን ቶኮ ኤርገ ኒቲ ፉዼ ቦዴ ዮ ዋን ፈፋ እሼረት አርጌ እሼ ጅቤ፣ እን ወረቃ ረጋ ሂካ በሬሴ እት ኬኑዻን መነሳቲ ባሴ እሼ ሃጌጌሱ። ");
INSERT INTO gaze_vpl VALUES ("DT24_2","006_24_2","DEU","24","2","2","እሼን ኤርገ መነሳቲ ባቴ ቦዴ ዮ ኒቲ ነመ ብራ ታቴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT24_3","006_24_3","DEU","24","3","3","ዮ ዽርስሼ ለመፋን እሼ ጅቤ ወረቃ ሂካ በሬሴ ኬኔፊ መነሳቲ እሼ ባሴ ዮካን ዮ እን ዱኤ፣ ");
INSERT INTO gaze_vpl VALUES ("DT24_4","006_24_4","DEU","24","4","4","ዽርስ እን ጀልቀባ ከን እሼ ሂኬ ሱን ኤርገ እሼን ጡሮፍቴ ቦዴ ዴብኤ እሼ ፉዹን እሳፍ ህንኤየመሙ። ወን ኩን ፉለ ዋቀዮ ዱረት በልፈማዸ። አት ብየ ዋቀዮ ዋቅንኬ አከ ዻላት ሲፍ ኬኑት ጩቡ ህንፍድን። ");
INSERT INTO gaze_vpl VALUES ("DT24_5","006_24_5","DEU","24","5","5","ነምን ዽኤኘት ኒቲ ፉዼ ቶኮ ለፈ ወራናት ህንኤርገምን ዮካን አከ ሆጂ ብራ ሆጄቱ ህንድርቀምን፤ እን ወጋ ቶኮፍ መነ ኦፊሳ ሃቱሩ፤ ኒቲሳስ ሃገመቺሱ። ");
INSERT INTO gaze_vpl VALUES ("DT24_6","006_24_6","DEU","24","6","6","አት ዸጋ ዳኩቲፊ መጂሳ ዮካን መጂሳ ቆፈሌ ታናን አከ ቀብዲት ህንፉዸትን፤ ኩን ሉቡ ነማ ቀብዲ ጎዸኒ ፉዸቹ ተኣቲ። ");
INSERT INTO gaze_vpl VALUES ("DT24_7","006_24_7","DEU","24","7","7","ነምን ቶኮ ዮ ኦቦሌሰሳ ከን ጎሰ እስራኤል ቶኮ ሀቴ ገርብቸ ጎዸቴ ዮካን ጉርጉረቴ እን አጄፈሙ ቀበ። አት ዋን ሀማ ግዱኬቲ ባስ። ");
INSERT INTO gaze_vpl VALUES ("DT24_8","006_24_8","DEU","24","8","8","ዋኤ ነመ ለምጣኤ ገሩ አኩመ ሌዎትን ሉቦተ ተአን ቀጄልቸ ሲፍ ኬነን ሰነት ሆጄቹኬ ቀልቤፈዹ። አት ዋን አን እሳን አጀጄ ኦፍ ኤገናዻን ዱካ ቡኡ ቀብደ። ");
INSERT INTO gaze_vpl VALUES ("DT24_9","006_24_9","DEU","24","9","9","ዋን ዋቀዮ ዋቅንኬ ኤርገ እስን ብየ ግብጢቲ ባተኒ ቦዴ ከራረት ሚርያምት ፍዴ ሰነ ያደዹ። ");
INSERT INTO gaze_vpl VALUES ("DT24_10","006_24_10","DEU","24","10","10","ዮሙ ኦላኬቲፍ ልቂ ጎሰ ከሚዩ ኬንቱት ዋን እን አከ ቀብዲት ሲፍ ኬኑ ፉዸቹዻፍ መነሳ ህንሴንን። ");
INSERT INTO gaze_vpl VALUES ("DT24_11","006_24_11","DEU","24","11","11","አት አለ ቱሪቲ ነምች አት ዋ ልቄስቱፍ ሱን ቀብዲ ሲፍ ኬኑ ሰነ ሲፍ ሃፍዱ። ");
INSERT INTO gaze_vpl VALUES ("DT24_12","006_24_12","DEU","24","12","12","ዮ ነምን ሱን ህዬሰ ተኤ ቀብዲሳ ኦፍ ብረ ህንቡልችን። ");
INSERT INTO gaze_vpl VALUES ("DT24_13","006_24_13","DEU","24","13","13","አከ እን ኮቲሳ ኡፈቴ ቡሉፍ ኡቱ አዱን ህንዽእን ዴብሲፍ። እንስ ስ ኤብሰ፤ ወን ኩንሞ ፉለ ዋቀዮ ዋቀኬቲ ዱረት አከ ሆጂ ቀጄሉማት ሲፍ ሄደመ። ");
INSERT INTO gaze_vpl VALUES ("DT24_14","006_24_14","DEU","24","14","14","ኦቦሌሰኬ ነመ ጎሰ እስራኤል ዮካን አለጋ መጋላወንኬ ቶኮ ኬሰ ጅራቱሌ ታናን ህዬሰ ዮካን ረከታ ቀጠረሜ ቶኮ ህንሳምን። ");
INSERT INTO gaze_vpl VALUES ("DT24_15","006_24_15","DEU","24","15","15","ገቲ እን እቲን ሆጄቴ ጋፉመ ሰነ ኡቱ አዱን ህንልጥን ኬኒፍ፤ ዋን ህዬሰ ተኤፍ እን አብዲዻን ኤገታቲ። ዮ ከና አቺ እን ዋቀዮን ስት ዋመቴ ወን ኩን ጩቡ ስት ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT24_16","006_24_16","DEU","24","16","16","አቦቲን ሰበቢ እጆሌሳኒቲፍ አጄፈሙ ህንቀበን ዮካን እጆሌን ሰበቢ አቦቲሳኒቲፍ አጄፈሙ ህንቀበን፤ ቶኮን ቶኮን ነማ ሰበቢ ጩቡ ኦፊሳቲፍ ዱአ። ");
INSERT INTO gaze_vpl VALUES ("DT24_17","006_24_17","DEU","24","17","17","አት ሙርቲ አለጋ ዮካን እጆሌ አባ ህንቀብኔ ህንጀልእስን ዮካን ኡፈተ ሃዸ ህዬሳ ቀብዲ ህንፉዸትን። ");
INSERT INTO gaze_vpl VALUES ("DT24_18","006_24_18","DEU","24","18","18","አት አከ ብየ ግብጥት ገርብቸ ቱርቴፊ አከ ዋቀዮ ዋቅንኬ አቺ ስ ፉሬ ያደዹ። ወን አን አከ አት ዋን ከነ ሆጄቱፍ ስ አጀጁፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("DT24_19","006_24_19","DEU","24","19","19","ዮሙ ምዻን ለፈ ቆቲሳኬቲ ወልት ቀብዱት ዮ ብሲን ሀፌ ጅራቴ እሳፍ ጄቴ ዱበት ህንዴብእን፤ አከ ዋቀዮ ዋቅንኬ ሆጂ ሀርከኬቲ ሁንዳን ስ ኤብሱፍ አለጎተ፣ እጆሌ አባ ህንቀብኔፊ ሃዸ ህዬሳቲፍ ዺስ። ");
INSERT INTO gaze_vpl VALUES ("DT24_20","006_24_20","DEU","24","20","20","ዮሙ እጀ ሙከ ኤጄርሰኬቲ ሀርጫፍቱትስ ከን ሀፌ ፉናነቹፍ ጄቴ ህንዴብእን፤ ዋን ሀፌ ሰነ አለጋፍ፣ እጆሌ አባ ህንቀብኔፊ ሃዸ ህዬሳቲፍ ዺስ። ");
INSERT INTO gaze_vpl VALUES ("DT24_21","006_24_21","DEU","24","21","21","ዮሙ እጀ እዶ ዻባ ወይኒኬቲ ወልት ቀብዱትስ ዋን ሀፌ ፉናነቹዻፍ ህንዴብእን። ዋን ሀፌ ሰነ አለጋዻፍ፣ እጆሌ አባ ህንቀብኔፊ ሃዸ ህዬሳቲፍ ዺስ። ");
INSERT INTO gaze_vpl VALUES ("DT24_22","006_24_22","DEU","24","22","22","አት አከ ግብጥት ገርብቸ ቱርቴ ያደዹ። ወን አን አከ አት ዋን ከነ ጎቱ ስ አጀጁፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("DT25_1","006_25_1","DEU","25","1","1","ዮ ነሞትን ለመ ወል ዸበኒ ገረ መነ ሙርቲ ዹፈን፣ አቦቲን ሴራ እሰ ቁልቁሉ ገድ ዺሰኒ እሰ የከ ቀቡት ሙሩ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("DT25_2","006_25_2","DEU","25","2","2","ዮ ነምቸ በሌሳ ቀቡ ሰናፍ ገረፈሙን መሌ አባን ሙርቲ አከ እን ጪሱ ጎዼ ፉለ ነምቻ ዱረት ለኮብሰ የከሳቲፍ መሉን እሰ ሃገረፍሲሱ፤ ");
INSERT INTO gaze_vpl VALUES ("DT25_3","006_25_3","DEU","25","3","3","ተኡስ እን አፉርተመ ጫላ እሰ ህንገረፍሲስን። እን ከነ ጫላ ዮ ገረፈሜ ኦቦሌስኬ ፉለኬ ዱረት ንቃነአ። ");
INSERT INTO gaze_vpl VALUES ("DT25_4","006_25_4","DEU","25","4","4","ቆትዮ ምዻን ስርብሲሱት ጅሩ አፋን ህንህዽን። ");
INSERT INTO gaze_vpl VALUES ("DT25_5","006_25_5","DEU","25","5","5","ዮ ኦቦሎትን ወጅን ጅራተኒ እሳን ኬሳ ቶኮ ኡቱ እልመ ህንዸልችን ዱኤ፣ ኒቲንሳ ማቲዻ አለት ሄሩሙ ህንቀብዱ። ዋርሳንሼ እሼ ፉዼ ኒቲ ሃጎዸቱ፤ ዋን ዋርሳን ቶኮ ጉቱፊ ቀቡስ እሼዻፍ ሃጉቱ። ");
INSERT INTO gaze_vpl VALUES ("DT25_6","006_25_6","DEU","25","6","6","አከ መቃንሳ እስራኤል ግዱዻ ህንበድኔፍ እልም እሼን ዴሱ ሀንገፍን መቃ ኦቦሌሰ ዱኤ ሰናቲን ሃዋመሙ። ");
INSERT INTO gaze_vpl VALUES ("DT25_7","006_25_7","DEU","25","7","7","ተኡስ ዮ ነምች ሱን ኒቲ ኦቦሌሰሳ ፉዹ ህንበርባድኔ እሼን ገረ በልበለ መጋላት ማንጉዶተ ብረ ዸቅጤ፣ “ዋርሳንኮ መቃ ኦቦሌሰሳ እስራኤል ኬሰት ዋምስሱ ድዴረ። እን ዋን ዋርሳን ቶኮ ጉቱ ቀቡ ናፍ ህንጉቱ” ሃጄቱን። ");
INSERT INTO gaze_vpl VALUES ("DT25_8","006_25_8","DEU","25","8","8","ኤርገሲ ማንጉዶትን መጋላሳቲ ዋመኒ እሰ ሃሃሶፍሲሰን። ዮ እን ያደሳ ጌደረቹ ድዴ፣ “አን እሼ ፉዹ ህንፌዹ” ጄዼ፣ ");
INSERT INTO gaze_vpl VALUES ("DT25_9","006_25_9","DEU","25","9","9","ኒቲን ኦቦሌሰሳ ሱን ፉለ ማንጉዶታ ዱረት ገረሳ ዸቅጤ ኮጴ ሚለሳ ቶኮራ ባፍት፤ ፉለ እሳትስ ቱፍቴ፣ “ነመ ኦቦሌሰሳቲፍ መነ ህንዻብኔረት ዋን አከናቱ ራወተመ” ሃጄቱ። ");
INSERT INTO gaze_vpl VALUES ("DT25_10","006_25_10","DEU","25","10","10","ሰኚን ነመ ሰናስ እስራኤል ኬሰት፣ “ማቲ ኮጴን እራ ባፈሜ” ጄዸሜ ዋመመ። ");
INSERT INTO gaze_vpl VALUES ("DT25_11","006_25_11","DEU","25","11","11","ዮ ኡቱ ነሞትን ለመ ወል ሎለኒ፣ ኒቲን እሰ ቶኮ ዹፍቴ ዽርሰሼ ሀርከ ነምቸ እሰ ቱማ ጅሩ ሰናቲ ባሱፍ ሀርከሼ ሂጠቴ ሳለ ነምቻ ቀብዴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT25_12","006_25_12","DEU","25","12","12","አት ሀርከሼራ ሙር። ገራ ህንላፍኒፍ። ");
INSERT INTO gaze_vpl VALUES ("DT25_13","006_25_13","DEU","25","13","13","ኮሮጆኬ ኬሳ መዳሊወን ወል ጫለን ለመ ጄቹን ቶኮ ኡልፋታ ቶኮሞ ከን ህንኡልፋትኔ ህንቀባትን። ");
INSERT INTO gaze_vpl VALUES ("DT25_14","006_25_14","DEU","25","14","14","መነኬ ኬሳ ሰፈርቱወን ገራ ገራ ለመ ጄቹንስ ቶኮ ጉዳ ቶኮሞ ጥና ህንቀባትን። ");
INSERT INTO gaze_vpl VALUES ("DT25_15","006_25_15","DEU","25","15","15","አት አከ ብየ ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ኬሰ በረ ዼራ ጅራቱፍ መዳሊፊ ሰፈርቱ ቀጄላፊ አመነማ ተኤ ቀባዹ። ");
INSERT INTO gaze_vpl VALUES ("DT25_16","006_25_16","DEU","25","16","16","ዋቀዮ ዋቅንኬ ነመ ዋን አከሲ ሆጄቱ ከምዩ፣ ነመ ጀልእነ ሆጄቱ ከምዩስ ንበልፋቲ። ");
INSERT INTO gaze_vpl VALUES ("DT25_17","006_25_17","DEU","25","17","17","ዋን አማሌቆትን ዬሮ አት ግብጢ ባቱ ከራረት ስ ጎዸን ሰነ ያደዹ። ");
INSERT INTO gaze_vpl VALUES ("DT25_18","006_25_18","DEU","25","18","18","እሳን ዬሮ አት ደዸብዴ ቡቱቴ ቱርቴት ከራረት ስ አርገተኒ ወረ ዱባን ትረቻ ቱረን ሁንደ አጄሰን፤ ዋቀስ ህንሶዳትኔ። ");
INSERT INTO gaze_vpl VALUES ("DT25_19","006_25_19","DEU","25","19","19","ዮሙ ዋቀዮ ዋቅንኬ ብየ ዻለ ጎዼ ሲፍ ኬኑ ኬሰት ዲኖተ ናኖኬቲራ ቦቆና ሲፍ ኬኑት፣ ያደኖ አማሌቅ ሰሚ ጀላ በሌስ። ዋን ከነ ህንደገትን! ");
INSERT INTO gaze_vpl VALUES ("DT26_1","006_26_1","DEU","26","1","1","አት ዮሙ ብየ ዋቀዮ ዋቅንኬ ዻለ ጎዼ ሲፍ ኬኑት ገልቴ ዻልቴ ኬሰ ቁበቱት፣ ");
INSERT INTO gaze_vpl VALUES ("DT26_2","006_26_2","DEU","26","2","2","ምዻን ለፈ ብየ ዋቀዮ ዋቅንኬ ሲፍ ኬኑራ አርገቱ ሁንደራ መታሳ ፉዺቲ ጉቦ ኬሰ ካእ። ኤርገሲስ እዶ ዋቀዮ ዋቅንኬ እዶ ጅሬኘ መቃሳቲፍ ፍለቱ ዸቅ፤ ");
INSERT INTO gaze_vpl VALUES ("DT26_3","006_26_3","DEU","26","3","3","ሉበ ዬሮ ሰነት ሆጂረ ጅሩን፣ “አን ብየ ዋቀዮ አከ ኑ ኬኑ አቦቲኬኛፍ ዋዳ ገሌት ዹፉኮ ሀርአ ፉለ ዋቀዮ ዋቀኬቲ ዱረት ነንለብሰ” ጄዽ። ");
INSERT INTO gaze_vpl VALUES ("DT26_4","006_26_4","DEU","26","4","4","ሉብን ሱንስ ጉቦ ሰነ ስ ሀርካ ፉዼ እዶ ኣርሳ ዋቀዮ ዋቀኬቲ ዱረ ንካአ። ");
INSERT INTO gaze_vpl VALUES ("DT26_5","006_26_5","DEU","26","5","5","አትስ ዋቀዮ ዋቀኬ ዱረት አከነ ጄቴ ንለብስተ፤ “አባንኮ ነመ ብየ አራም ከን አሲፊ አች ጎዳኑ ቱሬ፤ እንስ ነሞተ ጥኖ ፉዸቴ ግብጥት ገድ ቡኤ፤ አችስ ጅራቴ ሰበ ጉዳ፣ ሁምነ ቀቤሳፊ አከ መሌ ባይኤ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("DT26_6","006_26_6","DEU","26","6","6","ወር ግብጥ ገሩ ኑ ሀጩጩፊ ኑ ዽጵሱዻን ሆጂ ጀባ ኑት ፌአን። ");
INSERT INTO gaze_vpl VALUES ("DT26_7","006_26_7","DEU","26","7","7","ኑ ኤርገሲ ገረ ዋቀዮ ዋቀ አቦቲኬኛት እየትኔ፤ ዋቀዮስ ሰገሌኬኘ ዸገኤ ረክነኬኘ፣ ደዸቢኬኛፊ ሀጩጨሙኬኘ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("DT26_8","006_26_8","DEU","26","8","8","ከናፉ ዋቀዮ ሀርከ ጀባፊ እሬ ድሪርፈሜን፣ ሶዳችሰ ጉዳዻን፣ መለቶፊ ድንቂዻን ግብጢ ኑ ባሴ። ");
INSERT INTO gaze_vpl VALUES ("DT26_9","006_26_9","DEU","26","9","9","እዶ ከነትስ ኑ ፍዴ ብየ ኣነኒፊ ደመ ባፍቱ ከነ ኑፍ ኬኔ፤ ");
INSERT INTO gaze_vpl VALUES ("DT26_10","006_26_10","DEU","26","10","10","አመስ ያ ዋቀዮ ኩኖ፣ አን ምዻን ለፈ አት ና ኬንቴራ መታሳ ፍዴረ።” ጉቦ ሰነስ ፉለ ዋቀዮ ዋቀኬቲ ዱረ ካኢቲ ፉለሳ ዱረት ገድ ጄዺ ሰገድ። ");
INSERT INTO gaze_vpl VALUES ("DT26_11","006_26_11","DEU","26","11","11","አት፣ ሌዎትኒፊ አለጎትን ግዱኬ ጅራተን ዋን ጋሪ ዋቀዮ ዋቅንኬ ሲፊ ማቲኬቲፍ ኬኔ ሁንዳን ገመዳ። ");
INSERT INTO gaze_vpl VALUES ("DT26_12","006_26_12","DEU","26","12","12","ዮሙ ወጋ ሰደፋት ጄቹንስ ወጋ እት ኬና ኩዸን ኬሳ ቶኮ ባፈሙት ምዻንኬራ ኤርገ ኬና ኩዸን ኬሳ ቶኮ ባፍቴ ራወቴ ቦዴ አከ እሳን መጋላወንኬ ኬሰት ኛተኒ ቁፈኒፍ ሌዎታፍ፣ አለጎታፍ፣ እጆሌ አባ ህንቀብኔፊ ሃዾተ ህዬሳቲፍ ኬን። ");
INSERT INTO gaze_vpl VALUES ("DT26_13","006_26_13","DEU","26","13","13","ኤርገሲ ዋቀዮ ዋቀኬቲን አከነ ጄዽ፤ “አን አኩመ አጀጀኬ ከን አት ነ አጀጄ ሁንዳት ቆደ ቁልቁሉ መነኮቲ ባሴ ሌዎታፍ፣ አለጎታፍ፣ እጆሌ አባ ህንቀብኔፊ ሃዾተ ህዬሳቲፍ ኬኔረ። አን አጀጀወንኬራ ህንጎሬ ዮካን ቶኮሳኒሌ ህንደገትኔ። ");
INSERT INTO gaze_vpl VALUES ("DT26_14","006_26_14","DEU","26","14","14","አን ዬሮን ገደረ ቱሬስ ኩታ ቁልቁሉ ሰነራ ሆማ ህንኛትኔ፤ ዮካን አን ዬሮን ጡራኤት እሰራ ዋን ቶኮሌ ህንፉኔ፤ ወረ ዱአኒፍስ ህንዽኤስኔ፤ አን ዋቀዮ ዋቀኮቲፍ አጀጀሜረ፤ ዋን አት ነ አጀጄ ሁንደስ ሆጄዼረ። ");
INSERT INTO gaze_vpl VALUES ("DT26_15","006_26_15","DEU","26","15","15","ሰሚራ፣ እዶ ጅሬኘኬቲ ቁልቁሉራ ገድ እላል፤ ሰበኬ እስራኤሊፊ ብየ አኩመ አቦቲኬኛፍ ዋዳ ገልቴት ኑ ኬንቴ ከን ኣነኒፊ ደም ኬሳ ቡርቁ ከነ ኤብስ።” ");
INSERT INTO gaze_vpl VALUES ("DT26_16","006_26_16","DEU","26","16","16","ዋቀዮ ዋቅንኬ አከ አት አጀጀወኒፊ ሴረወን ከኔን ኤግዱ ሀርአ ስ አጀጀ፤ አት አከ ገራኬ ጉቱፊ ሉቡኬ ጉቱዻን እሳን ኤግዱ ኦፍ ኤገዹ። ");
INSERT INTO gaze_vpl VALUES ("DT26_17","006_26_17","DEU","26","17","17","አት አከ ዋቀዮ ዋቀኬ ተኤፊ አከ ከራሳረ ዴዴብቱ፣ አከ ቀጄልቸወንሳ፣ አጀጀወኒፊ ሴረወንሳ ኤግዴ እሳፍ አጀጀምቱ ሀርአ ዱበቴርተ። ");
INSERT INTO gaze_vpl VALUES ("DT26_18","006_26_18","DEU","26","18","18","ዋቀዮስ አኩመ አብደቺሴ ሰነት አከ አት ሰበሳቲፊ ቀቤኘሳ ታቴ አጀጀወንሳ ሁንደ ኤግዱ ሀርአ ዱበቴረ። ");
INSERT INTO gaze_vpl VALUES ("DT26_19","006_26_19","DEU","26","19","19","እን አከ ሰቦተ ኡሜ ሁንዳን ኦልት ገለታን፣ መቃፊ ኡልፍናን ኦል ስ ካሱፊ አኩመ ዋዳ ገሌ ሰናት አከ አት ዋቀዮ ዋቀኬቲፍ ሰበ ቁልቁሉ ታቱ ዱበቴረ። ");
INSERT INTO gaze_vpl VALUES ("DT27_1","006_27_1","DEU","27","1","1","ሙሴፊ ማንጉዶትን እስራኤል አከነ ጄዸኒ ሰበ አጀጀን፤ “አጀጀወን አን ሀርአ እስኒፍ ኬኑ ከኔን ሁንደ ኤጋ። ");
INSERT INTO gaze_vpl VALUES ("DT27_2","006_27_2","DEU","27","2","2","ኤርገ ብየ ዋቀዮ ዋቅንኬ ሲፍ ኬኑት ገሉፍ ዮርዳኖስ ጬተኒ ቦዴ ዸጎተ ጉርጉዳ ዻቢቲ ኖራ ድብ። ");
INSERT INTO gaze_vpl VALUES ("DT27_3","006_27_3","DEU","27","3","3","ዮሙ አኩመ ዋቀዮ ዋቅን አቦቲኬቲ ስ አብደቺሴት ብየ ኣነኒፊ ደም ኬሳ ቡርቁ ከን ዋቀዮ ዋቅንኬ ሲፍ ኬኑት ገሉፍ ጬቱት ዱቢወን ሴረ ከና ሁንደ ዸጎተረት በሬስ። ");
INSERT INTO gaze_vpl VALUES ("DT27_4","006_27_4","DEU","27","4","4","አት ኤርገ ዮርዳኖስ ጬቴ ቦዴ አኩመ አን ሀርአ ስ አጀጁት ዸጎተ ከኔን ቱሉ ኤባልራ ዻቢ ኖራ ድብ። ");
INSERT INTO gaze_vpl VALUES ("DT27_5","006_27_5","DEU","27","5","5","አችትስ ዋቀዮ ዋቀኬቲፍ እዶ ኣርሳ ከን ዸጋራ ሆጄተሜ ዻብ፤ ምአ ስቢላ ቶኮዩ ህንፈየደምን። ");
INSERT INTO gaze_vpl VALUES ("DT27_6","006_27_6","DEU","27","6","6","እዶ ኣርሳ ዋቀዮ ዋቀኬቲ ዸጋ ህንሶፈምኒን ሆጄዹ፤ አችረትስ ዋቀዮ ዋቀኬቲፍ ኣርሳ ጉበሙ ዽኤስ። ");
INSERT INTO gaze_vpl VALUES ("DT27_7","006_27_7","DEU","27","7","7","አችትስ ኣርሳ ነጋ ቀሊ ኛዹቲ ፉለ ዋቀዮ ዋቀኬቲ ዱረት ገመድ። ");
INSERT INTO gaze_vpl VALUES ("DT27_8","006_27_8","DEU","27","8","8","ዸጎተረት ዱቢወን ሴረ ከና ሁንደ እብሲ በሬስ።” ");
INSERT INTO gaze_vpl VALUES ("DT27_9","006_27_9","DEU","27","9","9","ሙሴፊ ሌዎትን ሉቦተ ተአን እስራኤሎተ ሁንዳን አከነ ጄዸን፤ “ያ እስራኤል፣ ጨልእሲ ዸገእ! አት ሀርአ ሰበ ዋቀዮ ዋቀኬቲ ታቴርተ። ");
INSERT INTO gaze_vpl VALUES ("DT27_10","006_27_10","DEU","27","10","10","ዋቀዮ ዋቀኬቲፍ አጀጀሚቲ አጀጀወንሳቲፊ ቀጄልቸወን አን ሀርአ ሲፍ ኬኑ ዸገእ።” ");
INSERT INTO gaze_vpl VALUES ("DT27_11","006_27_11","DEU","27","11","11","ሙሴንስ ጋፈሱመ አከነ ጄዼ ሰበ አጀጄ፦ ");
INSERT INTO gaze_vpl VALUES ("DT27_12","006_27_12","DEU","27","12","12","ዮሙ እስን ዮርዳኖስን ጬተንት ጎሶትን ስምኦን፣ ሌዊ፣ ይሁዳ፣ ይሳኮር፣ ዮሴፊፊ ከን ቤንያም ሰበ ኤብሱፍ ጋረ ጌርዚምራ ሃዻበተን። ");
INSERT INTO gaze_vpl VALUES ("DT27_13","006_27_13","DEU","27","13","13","ጎሶትን ሩቤን፣ ጋድ፣ ኣሼር፣ ዜቡሎን፣ ዳኒፊ ንፍታሌምሞ አባሩፍ ቱሉ ኤባልራ ሃዻበተን። ");
INSERT INTO gaze_vpl VALUES ("DT27_14","006_27_14","DEU","27","14","14","ሌዎትን ሰገሌሳኒ ኦል ፉዸተኒ አከነ ጄዸኒ ሰበ እስራኤል ሁንደት ሃለብሰን፦ ");
INSERT INTO gaze_vpl VALUES ("DT27_15","006_27_15","DEU","27","15","15","“ነምን ፈኪ ሶፉ ዮካን በቅሴ ዋቀ ቶልፈማ ጄቹንስ ዋን ፉለ ዋቀዮ ዱረት በልፈማ ተኤ ሆጄቱ ከን ዋን ኦጉማ ሀርካቲን ሆጄተሜ ዾክሴ ኦል ዻቡ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_16","006_27_16","DEU","27","16","16","“ነምን አባሳ ዮካን ሃዸሳ ቃኔሱ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_17","006_27_17","DEU","27","17","17","“ነምን ዸጋ ዳሪ ኦላሳ ዺቡ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_18","006_27_18","DEU","27","18","18","“ነምን ነመ ጃማ ከራራ ጀልእሱ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_19","006_27_19","DEU","27","19","19","“ነምን ሙርቲ አለጋ፣ እጆሌ አባ ህንቀብኔቲፊ ኒቶተ ዽርሶትንሳኒራ ዱአኒ ጀልእሱ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_20","006_27_20","DEU","27","20","20","“ነምን ኒቲ አባሳ ወጅን ጪሱ ሃአባረሙ፤ እን ስሬ አባሳ ጡሬሴራቲ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_21","006_27_21","DEU","27","21","21","“ነምን ሆሪ ከምዩ ወጅን ወል ብረ ገኡ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_22","006_27_22","DEU","27","22","22","“ነምን ኦቦሌቲሳ እንተለ አባሳ ዮካን እንተለ ሃዸሳ ወጅን ጪሱ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_23","006_27_23","DEU","27","23","23","“ነምን ሃዸ ኒቲሳ ወጅን ጪሱ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_24","006_27_24","DEU","27","24","24","“ነምን ዾክሳዻን ኦላሳ አጄሱ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_25","006_27_25","DEU","27","25","25","“ነምን ነመ ቁልቁሉ አጄሱፍ ጄዼ መተኣ ፉዸቱ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT27_26","006_27_26","DEU","27","26","26","“ነምን ዱቢወን ሴረ ከና ኤጉዻን ጀባቴ ህንዻበትኔ ሃአባረሙ።” ኤርገሲስ ሰብን ሁንድ፣ “አሜን!” ሃጄዹ። ");
INSERT INTO gaze_vpl VALUES ("DT28_1","006_28_1","DEU","28","1","1","ዮ አት ጉቱማን ጉቱት ዋቀዮ ዋቀኬቲፍ አጀጀምቴ አጀጀወንሳ ከኔን አን ሀርአ ሲፍ ኬኑ ኦፍ ኤገናዻን ዱካ ቡቴ፣ ዋቀዮ ዋቅንኬ ሰቦተ ለፈረ ጅራተን ሁንዳ ኦልት ኦል ስ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("DT28_2","006_28_2","DEU","28","2","2","ዮ አት ዋቀዮ ዋቀኬቲፍ አጀጀምቴ ኤብ ኩን ሁንድ ሲፍ ተአ፤ ስ ፋነ ዴመስ፦ ");
INSERT INTO gaze_vpl VALUES ("DT28_3","006_28_3","DEU","28","3","3","አት መጋላት ንኤብፈምተ፤ ባድያትስ ንኤብፈምተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_4","006_28_4","DEU","28","4","4","እጅ ገደሜሰኬቲ፣ እጅ ለፈኬቲ፣ እጅ ሆሪኬቲ፣ ጀቢን ሎንኬቲቲፊ ኮርቤዪን ቡሻዬኬቲ ንኤብፈሙ። ");
INSERT INTO gaze_vpl VALUES ("DT28_5","006_28_5","DEU","28","5","5","ጉቦንኬቲፊ ምእ ቡኮኬቲ ንኤብፈሙ። ");
INSERT INTO gaze_vpl VALUES ("DT28_6","006_28_6","DEU","28","6","6","አት ዮሙ ገልቱ ንኤብፈምተ፤ ዮሙ ባቱስ ንኤብፈምተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_7","006_28_7","DEU","28","7","7","ዋቀዮ አከ ዲኖትንኬ ከኔን ስት ከአን ፉለኬ ዱረት ሞአተመን ንጎዸ። እሳን ከራ ቶኮን ስት ዹፉ፣ ገሩ ከራ ቶርባን ስ በቀቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_8","006_28_8","DEU","28","8","8","ዋቀዮ ጎምብሳኬቲፊ ዋን ሀርክኬ ቀበቴ ሁንደት ኤበሳ ንኤርገ። ዋቀዮ ዋቅንኬ ብየ ሲፍ ኬኑ ኬሰት ስ ኤብሰ። ");
INSERT INTO gaze_vpl VALUES ("DT28_9","006_28_9","DEU","28","9","9","ዮ አት አጀጀ ዋቀዮ ዋቀኬቲ ኤግዴ ከራሳረ ዴዴብቴ፣ ዋቀዮ አኩመ ከኩዻን ስ አብደቺሴት ሰበሳ ቁልቁሉ ጎዼ ስ ዻበ። ");
INSERT INTO gaze_vpl VALUES ("DT28_10","006_28_10","DEU","28","10","10","ኤርገሲ ሰቦትን ለፈረ ጅራተን ሁንድ አከ አት መቃ ዋቀዮቲን ዋመምቱ አርገኒ ስ ሶዳቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_11","006_28_11","DEU","28","11","11","ዋቀዮ ብየ ሲፍ ኬኑፍ አቦቲኬቲፍ ከከቴ ኬሰት እጆሌዻን፣ ጀቦታፊ ምዻን ለፋቲን ሶሩመ እረ ዸንገለኣ ሲፍ ኬነ። ");
INSERT INTO gaze_vpl VALUES ("DT28_12","006_28_12","DEU","28","12","12","ዋቀዮ ዬሮዻን ለፈኬት ቦካ ኤርጌ ሆጂ ሀርከኬቲ ሁንደ ኤብሱፍ ጎምብሳ በዻዹማሳ ጄቹንስ ሰሚወን ንበነ። አት ሰቦተ ሄዱዻፍ ንልቄስተ መሌ ቶኮሳኒራዩ ህንልቄፈቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_13","006_28_13","DEU","28","13","13","ዋቀዮ መታ ስ ጎዸ መሌ ኤጌ ስ ህንጎዹ። አት ዮ አጀጀወን ዋቀዮ ዋቀኬቲ ከኔን አን ሀርአ ሲፍ ኬኑ ኦፍ ኤገናዻን ኤግዴ ዱካ ቡቴ፣ ዬሮ ሁንደ እረ ኣንተ መሌ ጀለ ህንኣንቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_14","006_28_14","DEU","28","14","14","አት ዋቆተ ብራ ዱካ ቡኡፊ ተጃጅሉዻን አጀጀወን አን ሀርአ ሲፍ ኬኑ ከኔንራ ምርገትስ ብታትስ ህንጎርን። ");
INSERT INTO gaze_vpl VALUES ("DT28_15","006_28_15","DEU","28","15","15","ገሩ ዮ አት ዋቀዮ ዋቀኬቲፍ አጀጀሙ ባቴ አጀጀወንሳቲፊ ቀጄልቸወንሳ ከኔን አን ሀርአ ሲፍ ኬኑ ሁንደ ኦፍ ኤገናዻን ኤጉ ድዴ፣ አባርሰወን ኩኔን ሁንድ ስ ቀቀቡ፤ ስ ልቅምሱስ፦ ");
INSERT INTO gaze_vpl VALUES ("DT28_16","006_28_16","DEU","28","16","16","አት መጋላት ንአባረምተ፤ ባድያትስ ንአባረምተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_17","006_28_17","DEU","28","17","17","ጉቦንኬ ንአባረመ፤ ምእ ቡኮኬቲስ ንአባረመ። ");
INSERT INTO gaze_vpl VALUES ("DT28_18","006_28_18","DEU","28","18","18","እጅ ገደሜሰኬቲ፣ እጅ ለፈኬቲ፣ ጀቢን ሎንኬቲቲፊ ኮርቤዪን ቡሻዬኬቲ ንአባረሙ። ");
INSERT INTO gaze_vpl VALUES ("DT28_19","006_28_19","DEU","28","19","19","አት ዮሙ ገልቱ ንአባረምተ፤ ዮሙ ባቱሌ ንአባረምተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_20","006_28_20","DEU","28","20","20","አት ሰበቢ እሰ ዺፍቴ ዋን ሀማ ሆጄቴፍ ዋቀዮ ሀመ አት በርበዶፍቴ ደፍቴስ ለፈራ ዸበምቱት ዋን ሀርክኬ ሆጄቱ ሁንዳን አባርሰ፣ ጆንጀኡፊ ዼከምሰ ስት ኤርገ። ");
INSERT INTO gaze_vpl VALUES ("DT28_21","006_28_21","DEU","28","21","21","ዋቀዮ ሀመ ብየ አት ዻሉፍ እት ገልቱራ ስ በሌሱት ዹኩባን ስ ዸአ። ");
INSERT INTO gaze_vpl VALUES ("DT28_22","006_28_22","DEU","28","22","22","ዋቀዮ ሀመ አት ለፈራ ዸበምቱት፣ ዹኩበ ነመ ሁቅሱን፣ ዸግነ ጉባፊ ዹላዻን፣ ሆአ አዱቲፊ ቦነ ሀማዻን፣ ጮለጉፊ ዋጊዻን ስ ዸአ። ");
INSERT INTO gaze_vpl VALUES ("DT28_23","006_28_23","DEU","28","23","23","ሰሚን መታኬቲ ኦሊ ናሲ፣ ለፍት ሚለኬ ጀላ ስቢለ ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT28_24","006_28_24","DEU","28","24","24","ዋቀዮ ቦካ ለፈኬቲ አዋራፊ ዳራት ጌደረ፤ ኩንስ ሀመ አት በዱት ሰሚዻ ስት ገድ ሀርጨአ። ");
INSERT INTO gaze_vpl VALUES ("DT28_25","006_28_25","DEU","28","25","25","ዋቀዮ አከ አት ዲነኬ ዱረት ሞአተምቱ ጎዸ። አት ከራ ቶኮን እሳንት ዹፍተ፤ ገሩ ከራ ቶርባን እሳን ዱራ በቀተ፤ ሞቱሞተ ለፈረ ጅረን ሁንዳፍ ዋን ኮልፋ ታተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_26","006_28_26","DEU","28","26","26","ሬፍኬ ስምብሮተ ሰሚ ሁንዳፊ ብኔንሶተ ለፋቲፍ ኛተ ተአ፤ ነምን ሶዳችሴ እሳን አርኡስ ህንጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_27","006_28_27","DEU","28","27","27","ዋቀዮስ ዹኩበ አት ህንፈይኔ ጄቹንስ ዹላ ብየ ግብጢቲን፣ ኢታን፣ መዳ መለኡፊ ጭቶዻን ስ ዽጵሰ። ");
INSERT INTO gaze_vpl VALUES ("DT28_28","006_28_28","DEU","28","28","28","ዋቀዮ መራቱማዻን፣ ጃሙማፊ ቡርጃጀኡ ሰሙቲን ስ ዽጵሰ። ");
INSERT INTO gaze_vpl VALUES ("DT28_29","006_28_29","DEU","28","29","29","አት ጉያ ሳፋ አከ ጃማ ዱከነ ኬሰ ዋ ቀቀበቱት ዴምተ፤ ወን አት ሆጄቱ ሁንድኑ ሲፍ ህንምልካኡ፤ ጉዩመ ጉያን ጩንቁርፈምቴ ሳመምተ፤ ከን ስ ኦልቹስ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT28_30","006_28_30","DEU","28","30","30","አት ኒቲ ካዽመተ፤ ገሩ ነመ ብራቱ እሼ ወጅን ጪሰ። መነ እጃረተ፤ ገሩ ኬሰ ህንጅራቱ። ወይኒ ዻበተ፣ ገሩ እጀሳ ህንኛቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_31","006_28_31","DEU","28","31","31","ሰንጋንኬ ፉለኬ ዱረት ቀለመ፤ ገሩ አት ፎንሳራ ሆማ ህንኛቱ። ሀሬንኬ ሁምናን ስራ ፉዸተመ፤ ሲፍ ህንዴብፈሙስ። ሆሎትንኬ ዲኖተኬቲፍ ኬነሙ፤ ነምን እሳን ሀርካ ቡሱስ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT28_32","006_28_32","DEU","28","32","32","እልማኒፊ እንተለንኬ ነሞተ ኦርማቲፍ ኬነሙ፤ እጅኬስ ጉዩመ ጉያን እሳን ኤጉዻን ፈጀጀ፤ አት ሀርከ ኦል ፉዸቹፍ ሁምነ ህንቀባቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_33","006_28_33","DEU","28","33","33","ኦምሸ ለፈኬቲቲፊ ሁምነኬቲ ሁንደ ነሞትን አት ህንቤክኔ ንኛቱ፤ አት በረ ጅሬኘኬቲ ጉቱ ጩንቁርፈምቴ ጅራቹ መሌ ሆማ ህንቀባቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_34","006_28_34","DEU","28","34","34","ወን አት አርግቱ ሁንድ ስ መራቸ። ");
INSERT INTO gaze_vpl VALUES ("DT28_35","006_28_35","DEU","28","35","35","ዋቀዮ ፋነ ሚለኬቲቲ ጀልቀቤ ሀመ ጉባ መታኬቲ ገኡት መዳ ህንፈይኔ ከን ነመ ዽጵሱን ጅልባፊ ሚለኬ ንዸአ። ");
INSERT INTO gaze_vpl VALUES ("DT28_36","006_28_36","DEU","28","36","36","ዋቀዮ ስኢፊ ሞቲ አት ኦፍረት ሞስፍቴ ሰቦተ አት ዮካን አቦቲንኬ ህንቤክንት ንኬነ። አትስ አችት ዋቆተ ብራ፣ ዋቆተ ሙካቲፊ ከን ዸጋ ንዋቄፈተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_37","006_28_37","DEU","28","37","37","ሰቦተ ዋቀዮ እት ስ ጌሱ ሁንደ ኬሰት ዋን ቃኒ፣ ከን ኮልፋቲፊ ከን ቁበ እት ቀበን ንታተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_38","006_28_38","DEU","28","38","38","ለፈ ቆቲሳኬ ኬሰ ሰኚ ባይኤ ፈጫፈተ፤ ገሩ ሰበቢ ሀዋንስን ኛቴ ፍጡፍ ጥኖ ወልት ቀበተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_39","006_28_39","DEU","28","39","39","አትስ ወይኒ ዻብዴ ኩኑንስተ፤ ገሩ ዋን ራሞን ኛቱፍ ዳዺሳ ህንዹግዱ ዮካን እጀሳ ህንጭረቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_40","006_28_40","DEU","28","40","40","ብየኬ ጉቱ ኬሳ ሙከ ኤጄርሳ ቀባተ፤ ገሩ ዋን እጅሳ ለፈት ሀርጨኡፍ አት ዘይቲሳት ህንፈየደምቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_41","006_28_41","DEU","28","41","41","አት እልማኒፊ እንተለን ቀባተ፤ ገሩ እሳን ዋን ቦጅአመኒፍ ከንኬ ህንተአን። ");
INSERT INTO gaze_vpl VALUES ("DT28_42","006_28_42","DEU","28","42","42","ሙካፊ ኦምሸ ለፈ ቆቲሳኬቲ ሁንደ ቱተ ሀዋንሳቱ ፍጠ። ");
INSERT INTO gaze_vpl VALUES ("DT28_43","006_28_43","DEU","28","43","43","አለጋን ግዱኬ ጅራቱ ስ ጫላ ጉደተ፤ አት ገሩ ገድ ዴምተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_44","006_28_44","DEU","28","44","44","እሰቱ ሲፍ ልቄሰ መሌ አት እሳፍ ህንልቄስቱ። እን መታ ተአ፤ አት ገሩ ኤጌ ታተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_45","006_28_45","DEU","28","45","45","አባርስ ኩን ሁንድኑ ስ ቀቀበ። አት ዋን ዋቀዮ ዋቀኬቲፍ ህንአጀጀምኔፊ ዋን አጀጀወኒፊ ቀጄልቸወን እን ሲፍ ኬኔ ህንኤግኒፍ ሀመ አት በዱት አባርስ ኩን ስ ብራ ህንሀፉ፤ ስ ፉዸተስ። ");
INSERT INTO gaze_vpl VALUES ("DT28_46","006_28_46","DEU","28","46","46","እሳን በረ በራን ስኢፊ ሰኚኬት መለቶፊ ድንቂ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("DT28_47","006_28_47","DEU","28","47","47","አት ዋን ዬሮ ሶሮማት ገለታፊ ገመቹዻን ዋቀዮ ዋቀኬ ህንተጃጅልኒፍ፣ ");
INSERT INTO gaze_vpl VALUES ("DT28_48","006_28_48","DEU","28","48","48","ቤላፊ ዼቡዻን፣ ዳራፊ ህዩማ ሀማዻን ዲኖተ ዋቀዮ ስት ካሱ ንተጃጅልተ። እን ሀመ ስ በሌሱት ዋንጆ ስቢላ ሞርመኬት ካአ። ");
INSERT INTO gaze_vpl VALUES ("DT28_49","006_28_49","DEU","28","49","49","ዋቀዮ ብየ አከ መሌ ፈጎራ፣ ዳሪ ለፋቲስ ሰበ አከ ርሳ ደፌ ገድ ቡኡ ከን አት አፋንሳ ህንቤክኔ ስት ካሰ፤ ");
INSERT INTO gaze_vpl VALUES ("DT28_50","006_28_50","DEU","28","50","50","እንስ ሰበ ጃርሳፍ ኡልፍነ ህንኬንኔ፣ ከን ዳእመኒፍ ገራ ህንላፍኔፊ ከን አከ መሌ ሶዳችሱዸ። ");
INSERT INTO gaze_vpl VALUES ("DT28_51","006_28_51","DEU","28","51","51","እሳንስ ሀመ አት በዱት እጀ ሎንኬቲቲፊ እጀ ለፈኬቲ ንኛቱ። ሀመ አት በርበዶፍቱት ምዻን ቶኮዩ፣ ዳዺ ወይኒ ሃራ ዮካን ዘይቲ፣ ጀቦተ ሎንኬቲቲፊ ኮርቤዪ ቡሻዬኬቲ ቶኮሌ ሲፍ ህንዺሰን። ");
INSERT INTO gaze_vpl VALUES ("DT28_52","006_28_52","DEU","28","52","52","እሳን መጋላ ብየኬቲ ሁንደ ሀመ ደላወን እትሳ ከኔን አት አመነቱ ጅጅገንት ንመርሱ፤ መጋላ ብየ ዋቀዮ ዋቅንኬ ሲፍ ኬኑ ኬሰ ጅረን ሁንደዩ ንመርሱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_53","006_28_53","DEU","28","53","53","አት ሰበቢ ዽጵነ ዲኖትንኬ ዬሮ ስ መርሰንት ስት ፍደኒቲፍ እጀ ጉዴደኬቲ፣ ፎን እልማኒፊ እንተለንኬቲ ከኔን ዋቀዮ ዋቅንኬ ሲፍ ኬኔ ንኛተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_54","006_28_54","DEU","28","54","54","ነምን ግዱኬቲ አከ መሌ ገረ ላፌሳፊ ገራሚ ተኤዩ ኦቦሌሰሳቲፍ ዮካን ኒቲሳ ከን ጃለቱፍ ዮካን እጆሌሳ ወረ ሀፈኒፍ ገራ ህንላፉ፤ ");
INSERT INTO gaze_vpl VALUES ("DT28_55","006_28_55","DEU","28","55","55","እን ፎን እጆሌሳ ከን ኛቻ ጅሩራ ጥኖሼሌ ቶኮ እሳኒቲፍዩ ህንኬኑ። ሰበቢ ዽጵነ ዲኖትንኬ ዬሮ መጋላወንኬ ሁንደ መርሰንት ስራን ገአኒቲፍ ወን እሳፍ ሀፌ ከኑመ ቆፋቲ። ");
INSERT INTO gaze_vpl VALUES ("DT28_56","006_28_56","DEU","28","56","56","ኒቲን አርጃፊ ቦንቱን ግዱኬ ጅራቱ ከን ሰበቢ አከ መሌ አርጃፊ ቦንቱ ታቴፍ ሚለ እሼቲን ለፈ ህንቱቅኔዩ ዽርሰሼ ከን ጃለቱት፣ እልመሼቲፊ እንተለሼትሌ ንሀማት፤ ");
INSERT INTO gaze_vpl VALUES ("DT28_57","006_28_57","DEU","28","57","57","እሼን ሆባቲ ገራሼቲ በኡፊ እጆሌ ዴሱሌ ንጅብት። ሰበቢን እሼን ዋን ከነ ጎቱፍስ ዬሮ መርፈማፊ ረክናት፣ ዮሙ ዲኖትንኬ መጋላኬ ኬሰት ስ ዽጵሰንት ዾክስቴ ኛቹፍ ጄቴት። ");
INSERT INTO gaze_vpl VALUES ("DT28_58","006_28_58","DEU","28","58","58","ዮ አት ኦፍ ኤገናዻን ዱቢወን ሴረ ከና ከኔን ክታበ ከነ ኬሰት በሬፈመን ሁንደ ዱካ ቡኡ ዺፍቴ መቃ ዋቀዮ ዋቀኬቲ ከበጀማፊ ሶዳችሳ ሰነ ሶዳቹ ባቴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT28_59","006_28_59","DEU","28","59","59","ዋቀዮ ስኢፊ ሰኚኬት ዸእቸ ሶዳችሳ፣ በላ ዽጵሳፊ ከን ዬሮ ዼራ ቱሩ፣ ዹኩበ አከ መሌ ሀማፊ ደፌ ህንፈይኔ ንኤርገ። ");
INSERT INTO gaze_vpl VALUES ("DT28_60","006_28_60","DEU","28","60","60","ዹኩቦተ ግብጥ ከኔን አት ሶዳቱስ ስት ፍደ፤ እሳንስ ጭኒነኒ ስት ቀበቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_61","006_28_61","DEU","28","61","61","አከሱመስ ሀመ አት ዸበምቱት ዋቀዮ ዹኩቦታፊ ረክኖተ ብራ ከኔን ክታበ ሴራ ከነ ኬሰት ህንበሬፈምን ስት ፍደ። ");
INSERT INTO gaze_vpl VALUES ("DT28_62","006_28_62","DEU","28","62","62","እስን ሰበቢ ዋቀዮ ዋቀኬሰኒፍ አጀጀሙ ድደኒፍ እስን ወረ አከ ኡርጂወን ሰሚ ባይአተኒ ቱርተን ኬሳ ጥኖቱ ሀፈ። ");
INSERT INTO gaze_vpl VALUES ("DT28_63","006_28_63","DEU","28","63","63","አኩመ እስን ሶሮምሱፊ እስን ባይእሱን ዋቀዮ ገመቺሱ ሰነ እስን በሌሱፊ እስን በርበዴሱንስ እሰ ገመቺሰ። እስን ብየ ዻሉፍ እት ገልተን ኬሳ ንቡቃቱ። ");
INSERT INTO gaze_vpl VALUES ("DT28_64","006_28_64","DEU","28","64","64","ኤርገሲስ ዋቀዮ ዳሪ ለፋ ቶኮራ ሀመ ዳሪ ለፋ ካኒት ሰቦተ ሁንደ ግዱት ስ ብትኔሰ። አት አችት ዋቆተ ብራ፣ ዋቆተ ሙካቲፊ ከን ዸጋ ከኔን አቲፊ አቦቲንኬ ህንቤክን ንዋቄፈተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_65","006_28_65","DEU","28","65","65","አት ሰቦተ ሰነ ግዱት ቦቆና ህንአርገቱ፤ ለፈ ኮጴ ሚለኬቲረ ኬየቱሌ ህንአርገቱ። አችትስ ዋቀዮ ሰሙ ዽጰቱ፣ እጀ ሀዊዻን ፈጀጁፊ ገራ አብዲ ኩተቱ ሲፍ ኬነ። ");
INSERT INTO gaze_vpl VALUES ("DT28_66","006_28_66","DEU","28","66","66","አት ሀልከኒ ጉያ ሶዳዻን ቀበምቴ ኡቱ ሉቡንኬ ወቢ ህንአርገን፣ ዬሮ ሁንደ ያዶዻን ጅራተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_67","006_28_67","DEU","28","67","67","ሰበቢ ሶዳ ገራኬ ጉቱ ሰናቲፊ ዋን እጀኬቲን አርግቱ ሰናቲፍ ገነመ፣ “ኡቱ በርኡ ባቴ!” ገልገለሞ፣ “ኡቱ ዽኡ ባቴ!” ጄተ። ");
INSERT INTO gaze_vpl VALUES ("DT28_68","006_28_68","DEU","28","68","68","ከራ አን አት ለመተ አስ ህንዴብቱ ሲን ጄዼንስ ዋቀዮ ዶኒዻን ግብጥት ስ ዴብሰ። አችትስ አከ ገርቦተ ዺራ ዱበርቲት ዲኖተኬሰንት ጉርጉረሙፍ ኦፍ ዽኤስቱ፤ ገሩ ነምን ቶኮዩ እስን ህንብተቱ። ");
INSERT INTO gaze_vpl VALUES ("DT29_1","006_29_1","DEU","29","1","1","ዱቢን ከኩ ከን ዋቀዮ ከኩ ኮሬብት እሳን ወጅን ገሌ ሰነረት ደበሌ አከ እን ሞኣብ ኬሰት እስራኤሎተ ወጅን ገሉፍ ሙሴ አጀጄ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("DT29_2","006_29_2","DEU","29","2","2","ሙሴን እስራኤሎተ ሁንደ ወልት ዋሜ አከነ ጄዼን፦ ዋን ዋቀዮ ግብጥ ኬሰት ፈረኦንረት፣ ቆንዳልቶተሳ ሁንዳፊ ጉቱማ ብየሳረት ሆጄቴ ሁንደ እጅኬሰን አርጌረ። ");
INSERT INTO gaze_vpl VALUES ("DT29_3","006_29_3","DEU","29","3","3","እስን ቆሩምሰወን ጉርጉዳ ሰነ፣ መለቶወኒፊ ድንቂወን ጉርጉዳ ሰነ እጁመኬሰኒን አርግተኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("DT29_4","006_29_4","DEU","29","4","4","ዋቀዮ ገሩ ሀመ ሀርኣት ቀልቢ ሁበቱ ዮካን እጀ አርግቱ ዮካን ጉረ ዸገኡ እስኒ ህንኬንኔ። ");
INSERT INTO gaze_vpl VALUES ("DT29_5","006_29_5","DEU","29","5","5","ዬሮ ወጎተ አፉርተመን አን ገሞጂ ኬሰ እስን ጌጌሴ ሰነት ኡፈትንኬሰን እስንረት ህንዹምኔ ዮካን ኮጴን ሚለኬሰንረት ህንጭጭትኔ። ");
INSERT INTO gaze_vpl VALUES ("DT29_6","006_29_6","DEU","29","6","6","እስን ቡዴነ ህንኛትኔ፤ ዳዺ ወይኒ ዮካን ዹጋቲ ነመ መቼሱ ህንዹግኔ። አን አከ እስን አከ አን ዋቀዮ ዋቀኬሰን ተኤ ቤክተኒፈን ዋን ከነ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("DT29_7","006_29_7","DEU","29","7","7","ዮሙ እስን አስ ጌሰንት ስሆን ሞቲን ሄሽቦኒፊ ኦግ ሞቲን ባሻን ኑ ሎሉፍ ኑት በአን፤ ኑ ገሩ እሳን ሞአትኔ። ");
INSERT INTO gaze_vpl VALUES ("DT29_8","006_29_8","DEU","29","8","8","ብየሳኒስ ፉዸትኔ ጎሰ ሩቤኒፍ፣ ጎሰ ጋዲፊ ወለካ ጎሰ ምናሴቲፍ ዻለ ጎኔ ኬንኔ። ");
INSERT INTO gaze_vpl VALUES ("DT29_9","006_29_9","DEU","29","9","9","እስን አከ ዋን ሆጄተን ሁንዳን ምልኮፍተኒፍ ዱቢወን ከኩ ከና ኦፍ ኤገናዻን ዱካ ቡኣ። ");
INSERT INTO gaze_vpl VALUES ("DT29_10","006_29_10","DEU","29","10","10","ሁንድኬሰን ጄቹንስ ቀጄልችቶትኒፊ ሆገንቶትንኬሰን፣ ማንጉዶትኒፊ ቆንዳልቶትንኬሰን አከሱመስ ነሞትን እስራኤል ከኔን ብራ ሁንድኑ ሀርአ ፉለ ዋቀዮ ዋቀኬሰኒ ዱረ ዻበተኒርቱ፤ ");
INSERT INTO gaze_vpl VALUES ("DT29_11","006_29_11","DEU","29","11","11","እጆሌንኬሰኒፊ ኒቶትንኬሰን አከሱመስ አለጎን ሙከኬ ጭራ፣ ብሻንኬስ ወራባ ቁበተኬ ኬሰ ጅራተን ስ ወጅን ዻበተኒሩ። ");
INSERT INTO gaze_vpl VALUES ("DT29_12","006_29_12","DEU","29","12","12","አትስ ከኩ ዋቀዮ ሀርአ ስ ወጅን ገሌ ከካዻን ሲፍ ምርከኔሱ ከነ ዋቀዮ ዋቀኬ ወጅን ገሉፍ አስ ዻበቴርተ፤ ");
INSERT INTO gaze_vpl VALUES ("DT29_13","006_29_13","DEU","29","13","13","እንስ አኩመ ስ አብደቺሴ አቦቲኬ አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ ዋዳ ገሌ ሰነት አከ አት ሰበሳ ታቴ እንስ ዋቀኬ ተኡፍ ጀቤሴ ስ ዻቡፍ ዋን ከነ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("DT29_14","006_29_14","DEU","29","14","14","አንስ ከኩ ከካዻን ምርከናኤ ከነ እስን ቆፈ ወጅን ኡቱ ህንተእን፣ ");
INSERT INTO gaze_vpl VALUES ("DT29_15","006_29_15","DEU","29","15","15","ወረ ኑ ወጅን አስ ፉለ ዋቀዮ ዋቀኬኛ ዱረ ዻበተን ወረ ሀርአ አስ ህንጅሬ ወጅንስ ነንገለ። ");
INSERT INTO gaze_vpl VALUES ("DT29_16","006_29_16","DEU","29","16","16","አከ ኑ እት ግብጥ ኬሰ ጅራትኔፊ ዮሙ አስ ዹፍኑስ አከ ኑ እት ብዮተ ኬሰ ደበሬ እስን መታን ኬሰኑ ንቤክቱ። ");
INSERT INTO gaze_vpl VALUES ("DT29_17","006_29_17","DEU","29","17","17","እስንስ ግዱሳኒት ፈኪወንሳኒ ጅብሲሶ፣ ዋቆተሳኒ ቶልፈሞ ከኔን ሙከ፣ ዸጋ፣ ሜቲፊ ወርቄራ ሆጄተመን አርግተኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("DT29_18","006_29_18","DEU","29","18","18","አከ ዺር ዮካን ዱበርቲን በልበል ዮካን ጎስት ገራንሳ ዋቀዮ ዋቀኬኘራ ገረገሌ ዋቆተ ሰቦተ ሰና ፋነ ቡኤ እስን ግዱ ህንጅራትኔ ምርከኔፈዻ፤ አከ ህድ ሱሚ ሀዻኣ አከሲ ባሱ ቶኮዩ እስን ግዱ ህንጅራትኔ ቁልቁሌፈዻ። ");
INSERT INTO gaze_vpl VALUES ("DT29_19","006_29_19","DEU","29","19","19","ነምን አከሲ ዮሙ ዱቢ ከኩ ከና ዸገኡት፣ ገራሳት ኦፍ ኤብሴ፣ “አን ዮን አከ ፌዺኮት ዴሜሌ ነጋ ቀበ” ጄዼ ያደ። ኩንሞ ለፈ ጂዻረትስ ተኡ ለፈ ጎጎጋረት በዲሰ ፍደ። ");
INSERT INTO gaze_vpl VALUES ("DT29_20","006_29_20","DEU","29","20","20","ዋቀዮ ነመ ሰናፍ ጎንኩማ ዺፈመ ህንጎዹ፤ ዼከምስሳቲፊ ህናፋንሳ ነምቸ ሰነረት ቦበአ። አባርስ ክታበ ከነ ኬሰት በሬፈሜ ሁንድ እሰ ቀቀበ፤ ዋቀዮስ ሰሚ ጀላ መቃሳ ንዸበምሲሰ። ");
INSERT INTO gaze_vpl VALUES ("DT29_21","006_29_21","DEU","29","21","21","አኩመ ከኩ አባርሰ ክታበ ሴራ ከነ ኬሰት በሬፈሜ ሁንዳት፣ ዋቀዮ ጎሶተ እስራኤል ሁንደ ኬሳ በዲሳፍ ኮጳት እሰ ባሰ። ");
INSERT INTO gaze_vpl VALUES ("DT29_22","006_29_22","DEU","29","22","22","ዸሎትን እት ኣኑ ጄቹንስ እጆሌንኬሰን ወር እስኒን ዱበ ዹፈን አከሱመስ ኬሱሞትን ብዮተ ፈጎቲ ዹፈን ዸእቸ ጉዳ ብየቲረ ገኤፊ ዹኩበ ዋቀዮ እቲን እሼ ዸኤ ንአርጉ። ");
INSERT INTO gaze_vpl VALUES ("DT29_23","006_29_23","DEU","29","23","23","ጉቱማን ብየቲ ገሞጂ ጉብዱ ከን ሶግዳፊ ድኚን ጉተምቴ ከን ወን ቶኮዩ እረ ህንዻበምኔ፣ ከን ወን ቶኮዩ እረት ህንብቅሌ፣ ከን ብቅልቱን ቶኮዩ እረት ህንጉደትኔ ታት። በዲስን እሼረ ገኡስ አከ በዲሰ ሶዶሚቲፊ ጎሞራ፣ አድማቲፊ ዜቦኢም ከኔን ዋቀዮ ዼከምሰ ጉዳዻን እሳን በርበዴሴ ሰና ንተአ። ");
INSERT INTO gaze_vpl VALUES ("DT29_24","006_29_24","DEU","29","24","24","ሰብን ሁንድኑ፣ “ዋቀዮ ማሊፍ ዋን አከሲ ብየ ከነት ፍዴ? ዼከምስ ሶዳችሳን ቦበኡ ኩንስ ማሊፍ ዹፌ?” ጄዸኒ ጋፈቱ። ");
INSERT INTO gaze_vpl VALUES ("DT29_25","006_29_25","DEU","29","25","25","ዴቢንሳስ ከነ ተአ፤ “ኩን ሰበቢ ሰብን ኩን ከኩ ዋቀዮ ዋቅን አቦቲሳኒ ዬሮ ግብጢ እሳን ባሴት እሳን ወጅን ገሌ ሰነ ዺሰኒፍ። ");
INSERT INTO gaze_vpl VALUES ("DT29_26","006_29_26","DEU","29","26","26","እሳንስ ዸቀኒ ዋቆተ ብራ፣ ከኔን ህንቤክኒፍ ዋቆተ እን እሳኒፍ ህንኬንን ዋቄፈተን፤ ገድ ጄዸኒስ ሰገደኒፍ። ");
INSERT INTO gaze_vpl VALUES ("DT29_27","006_29_27","DEU","29","27","27","ከናፉ ዼከምስ ዋቀዮ ብየ ከነት ቦበኤ አከ እን አባርሰ ክታበ ከነ ኬሰት በሬፈሜ ሁንደ እት ፍዱ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("DT29_28","006_29_28","DEU","29","28","28","ዋቀዮስ ኣሪ ሶዳችሳፊ ዼከምሰ ጉዳዻን ብየሳኒቲ እሳን ቡቅሴ፤ አኩመ አመ ጅሩ ከነትስ ብየ ብራት እሳን ደርበቴ።” ");
INSERT INTO gaze_vpl VALUES ("DT29_29","006_29_29","DEU","29","29","29","ወንት ዾክሳን ከን ዋቀዮ ዋቀኬኛት፤ ከን ሙልእፈሜ ገሩ አከ ኑ ዱቢ ሴረ ከና ሁንደ ኤግኑፍ በረ በራን ከንኬኛፊ ከን እጆሌኬኛት። ");
INSERT INTO gaze_vpl VALUES ("DT30_1","006_30_1","DEU","30","1","1","ዮሙ ኤቢፊ አባርስ አን ፉለኬ ዱረ ካኤ ኩን ሁንድ ስ አርገቴ አት ሰቦተ ዋቀዮ ዋቅንኬ ኬሰት ስ ብትኔሱ ሁንደ ግዱ ጅራቱት ዮ አት ዋን ሰነ ያደቱ፣ ");
INSERT INTO gaze_vpl VALUES ("DT30_2","006_30_2","DEU","30","2","2","ዮሙ አቲፊ እጆሌንኬ ገረ ዋቀዮ ዋቀኬቲት ዴብተኒ አኩመ ዋን አን ሀርአ እስን አጀጁ ሁንዳት ገራኬሰኒፊ ሉቡኬሰን ጉቱዻን እሳፍ አጀጀምተን፣ ");
INSERT INTO gaze_vpl VALUES ("DT30_3","006_30_3","DEU","30","3","3","ዋቀዮ ዋቅንኬ ቦጁኬ ሲፍ ዴብሴ ገራ ሲፍ ላፉዻን ሰቦተ ግዱሳኒት ስ ብትኔሴ ሁንደ ኬሳ ዴብሴ ወልት ስ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("DT30_4","006_30_4","DEU","30","4","4","ዮ አት ሰሚ ጀለት ለፈ አከ መሌ ፈጎት ጌፈምቴ ጅራቴሌ ዋቀዮ ዋቅንኬ ወልት ስ ቀበ፤ ዴብሴስ ስ ፍደ። ");
INSERT INTO gaze_vpl VALUES ("DT30_5","006_30_5","DEU","30","5","5","እን ብየ አቦቲኬቲት ስ ገልቸ፤ አትስ ንዻልተ። እን አቦቲኬ ጫላ ስ ሶሮምሰ፤ አከ መሌ ስ ባይእሰስ። ");
INSERT INTO gaze_vpl VALUES ("DT30_6","006_30_6","DEU","30","6","6","አከ አት ገራኬ ጉቱዻን፣ ሉቡኬ ጉቱዻን እሰ ጃለቴ ጅራቱፍ ዋቀዮ ዋቅንኬ ገራኬቲፊ ገራ ሰኚወንኬቲ ዸግነ ንቀበ። ");
INSERT INTO gaze_vpl VALUES ("DT30_7","006_30_7","DEU","30","7","7","ዋቀዮ ዋቅንኬ አባርሰ ከነ ሁንደ ወረ ስ ጅበኒ ስ ረክሰንረ ንካአ። ");
INSERT INTO gaze_vpl VALUES ("DT30_8","006_30_8","DEU","30","8","8","አትስ ዴብቴ ዋቀዮፍ ንአጀጀምተ፤ አጀጀሳ ከኔን አን ሀርአ ስ አጀጁ ሁንደስ ንኤግደ። ");
INSERT INTO gaze_vpl VALUES ("DT30_9","006_30_9","DEU","30","9","9","ኤርገሲስ ዋቀዮ ዋቅንኬ ሆጂ ሀርከኬቲ ሁንዳፊ እጆሌ ጉዴደኬቲ በአኒን፣ ጀቦተኬቲፊ ምዻን ለፈ ቆቲሳኬቲቲን ስ ሶሮምሰ። ዋቀዮ አኩመ አቦቲኬት ገመዴ ሰነ ስትስ ገመዴ ስ ሶሮምሰ፤ ");
INSERT INTO gaze_vpl VALUES ("DT30_10","006_30_10","DEU","30","10","10","ኩንስ ዮ አት ዋቀዮ ዋቀኬቲፍ አጀጀምቴ አጀጀወኒፊ ቀጄልቸወንሳ ከኔን ክታበ ሴራ ከነ ኬሰት በሬፈመን ኤጉዻን ገራኬ ጉቱፊ ሉቡኬ ጉቱዻን ገረ ዋቀዮ ዋቀኬቲት ዴብቴ ተአ። ");
INSERT INTO gaze_vpl VALUES ("DT30_11","006_30_11","DEU","30","11","11","ወን አን ሀርአ ስ አጀጁ ኩን ረክሳ ዮካን ከን ስራ ፈጋቴ ምት። ");
INSERT INTO gaze_vpl VALUES ("DT30_12","006_30_12","DEU","30","12","12","አከ አት፣ “አከ ኑ ዸጌኜ እሰ ኤግኑፍ ኤኙቱ ገረ ሰሚት ኦል በኤ ፍዴ ኑት ህመ?” ጄቴ ህንጋፈትኔፍ እን ኦል ሰሚ ጉባ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT30_13","006_30_13","DEU","30","13","13","ዮካን አከ አት፣ “አከ ኑ ዸጌኜ እሰ ኤግኑፍ ኤኙቱ ገላነ ጬኤ ፍዴ ኑት ህመ?” ጄቴ ህንጋፈትኔፍ እን ገላነ ገመ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT30_14","006_30_14","DEU","30","14","14","ዱቢን ሱን ገሩ ባይኤ ስት ዽኦ ጅረ፤ አከ አት እሰ ኤግዱፍስ እን አፋንኬቲፊ ገራኬ ኬሰ ጅረ። ");
INSERT INTO gaze_vpl VALUES ("DT30_15","006_30_15","DEU","30","15","15","ኩኖ አን ሀርአ ጅሬኛፊ ኤበ፣ ዱኣፊ በዲሰ ፉለኬ ዱረ ካኤረ። ");
INSERT INTO gaze_vpl VALUES ("DT30_16","006_30_16","DEU","30","16","16","አን አከ አት ዋቀዮ ዋቀኬ ጃለቱ፣ አከ ከራሳረስ ዴምቱፊ አከ አት አጀጀወንሳ፣ ቀጄልቸወንሳቲፊ ሴረወንሳ ኤግዱ ስ አጀጀ፤ ኤርገሲስ አት ሉቡን ጅራቴ ንባይአተ፤ ዋቀዮ ዋቅንኬስ ብየ አት ዻሉፍ እት ገልቱት ስ ኤብሰ። ");
INSERT INTO gaze_vpl VALUES ("DT30_17","006_30_17","DEU","30","17","17","ገሩ ዮ ያድንኬ ከራራ ጀልአቴ አት አጀጀሙ ባቴ፣ ዮ አት ዋቆተ ካን ዋቄፈቹፊ እሳን ተጃጅሉፍ ጄቴ ፉዸተምቴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT30_18","006_30_18","DEU","30","18","18","አን አከ እስን ዹጉማን በደን ሀርአ እስንትን ህመ። እስን ዮርዳኖስን ጬተኒ ብየ እት ገልተኒ ዻልተን ኬሰስ በረ ዼራ ህንጅራተን። ");
INSERT INTO gaze_vpl VALUES ("DT30_19","006_30_19","DEU","30","19","19","አን አከን ጅሬኛፊ ዱአ፣ ኤባፊ አባርሰ ፉለኬ ዱረ ካኤ ጅሩ ሀርአ ሰሚፊ ለፈ ረጋን ጎዼ ስት ዋመ። ኤጋ አቲፊ እጆሌንኬ አከ ጅራተኒፍ ጅሬኘ ፍለዹ፤ ");
INSERT INTO gaze_vpl VALUES ("DT30_20","006_30_20","DEU","30","20","20","ኩንስ አከ አት ዋቀዮ ዋቀኬ ጃለቱፍ፣ አከ ዱቢሳ ዸጌሴ እሰት መጠንቴ ጅራቱፍ። ዋቀዮ ሰበቢ ጅሬኘኬ ተኤፍ፣ ብየ አቦቲኬ አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ ኬኑፍ ከከቴፍ ሰነ ኬሰት በረ ዼራ ሲፍ ኬነ። ");
INSERT INTO gaze_vpl VALUES ("DT31_1","006_31_1","DEU","31","1","1","ኤርገሲስ ሙሴን ዸቄ ዱቢ ከነ እስራኤል ሁንደት ዱበቴ፦ ");
INSERT INTO gaze_vpl VALUES ("DT31_2","006_31_2","DEU","31","2","2","“አን አመ ነመ ወጋ ዽባፊ ድግደማት፤ ስአችስ እስን ሆገኑ ህንደንደኡ። ዋቀዮ፣ ‘አት ዮርዳኖስ ህንጬቱ’ ናን ጄዼረ። ");
INSERT INTO gaze_vpl VALUES ("DT31_3","006_31_3","DEU","31","3","3","ዋቀዮ ዋቅንኬ መታንሳ ስ ዱረ ንጬአ። እን ሰቦተ ከኔን ፉለኬ ዱራ ንበርበዴሰ፤ አትስ ብየሳኒ ንዻልተ። አኩመ ዋቀዮ ጄዼት፣ እያሱንስ ስ ዱረ ንጬአ። ");
INSERT INTO gaze_vpl VALUES ("DT31_4","006_31_4","DEU","31","4","4","ዋቀዮ አኩመ ስሆኒፊ ኦግ ሞቶተ አሞሮታ ሰነ ብየሳኒ ወጅን በሌሴ ሰነ እሳን ከኔንስ ንበሌሰ። ");
INSERT INTO gaze_vpl VALUES ("DT31_5","006_31_5","DEU","31","5","5","ዋቀዮ ደበርሴ ሀርከኬሰንት እሳን ኬነ፤ እስንስ ዋን አን እስን አጀጄ ሁንደ እሳን ጎቹ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("DT31_6","006_31_6","DEU","31","6","6","ጭማ፤ ጀባዻ። ዋቀዮ ዋቅንኬሰን እስን ወጅን ዴማቲ እስን ሰበቢሳኒቲፍ ጄተኒ ህንሶዳትና ዮካን ህንርፈትና፤ እን ጎንኩማ እስን ህንዺሱ ዮካን እስን ህንገቱ።” ");
INSERT INTO gaze_vpl VALUES ("DT31_7","006_31_7","DEU","31","7","7","ከነረት ሙሴን እያሱ ኦፍት ዋሜ ፉለ እስራኤል ሁንዳ ዱረት አከነ ጄዼን፤ “አት ሰበቢ ብየ ዋቀዮ እሳኒፍ ኬኑፍ አቦቲሳኒቲፍ ከከቴት ገሉፍ ሰበ ከነ ወጅን ዴምቱፍ ጭም፤ ጀባዹስ፤ ብየቲስ አከ ዻለን ጎዽ። ");
INSERT INTO gaze_vpl VALUES ("DT31_8","006_31_8","DEU","31","8","8","ዋቀዮ መታንሳ ስ ዱረ ንዴመ፤ ስ ወጅንስ ንጅራተ፤ እን ስ ህንዺሱ ዮካን ስ ህንገቱ። ህንሶዳትን፤ አብዲስ ህንኩተትን።” ");
INSERT INTO gaze_vpl VALUES ("DT31_9","006_31_9","DEU","31","9","9","ሙሴንስ ሴረ ከነ በሬሴ እልማን ሌዊ ከኔን ሉቦተ ተአኒ ታቦተ ከኩ ዋቀዮ ባተኒፊ ማንጉዶተ እስራኤል ሁንደት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT31_10","006_31_10","DEU","31","10","10","ኤርገሲስ ሙሴን አከነ ጄዼ እሳን አጀጄ፤ “ዹመ ወጋ ቶርበፋት፣ ዬሮ እት ገቲን ዺፈሙት፣ ዬሮ እት አያን ዳሲ አያኔፈሙት፣ ");
INSERT INTO gaze_vpl VALUES ("DT31_11","006_31_11","DEU","31","11","11","ዮሙ እስራኤል ሁንድ ፉለ ዋቀዮ ዋቀኬቲ ዱረት ሙልአቹፍ ለፈ እን ፍለቱ ዹፈንት አከ እሳን ዸገአኒፍ ፉለሳኒ ዱረት ሴረ ከነ እሳኒ ዱብፍተ። ");
INSERT INTO gaze_vpl VALUES ("DT31_12","006_31_12","DEU","31","12","12","አከ እሳን ዱቢ ሴረ ከና ሁንደ ዸገአኒ ዋቀዮ ዋቀኬ ሶዳቹ በረተኒፊ ኦፍ ኤገናዻን ፋነ ቡአኒፍ ነሞተ ጄቹንስ ዺሮተ፣ ዱበርቶተ፣ እጆሌፊ አለጎተ መጋላወንኬ ኬሰ ጅራተን ወልት ቀብ። ");
INSERT INTO gaze_vpl VALUES ("DT31_13","006_31_13","DEU","31","13","13","በረ እስን ብየ ዮርዳኖስ ጬተኒ ዻልተን ኬሰ ጅራተን ጉቱ እጆሌንሳኒ ከኔን ሴረ ከነ ህንቤክኔስ ዸገኡፊ ዋቀዮ ዋቀሳኒ ሶዳቹ በረቹ ቀቡ።” ");
INSERT INTO gaze_vpl VALUES ("DT31_14","006_31_14","DEU","31","14","14","ዋቀዮ ሙሴዻን፣ “ዬሮን አት ዱቱ ዽኣቴረ። አከ አን ዋን እን ሆጄቹ መሉ እት ህሙፍ እያሱ ዋሚቲ ዱንካነ ወል ገኢ ብረት ዽኣዻ” ጄዼ። ሙሴፊ እያሱንስ ዹፈኒ ዱንካነ ወል ገኢ ዱረት ዽኣተን። ");
INSERT INTO gaze_vpl VALUES ("DT31_15","006_31_15","DEU","31","15","15","ዋቀዮ ኡቱባ ዱሜሳቲን ዹፌ ዱንካንቸ ኬሰት ሙልአቴ፤ ዱሜስ ሱንስ በልበለ ዱንካንቻ ዱረ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("DT31_16","006_31_16","DEU","31","16","16","ዋቀዮስ ሙሴዻን አከነ ጄዼ፤ “አት አቦቲኬ ወጅን ንቦቆተ፤ ሰብን ኩንሞ ዮሙሱመ ብየ ዻሉፍ እት ገሉት ዋቆተ ነሞተ ኦርማ ዱካ ቡኤ ሰጋገሉ ጀልቀበ። እሳን ነ ዺሰኒ ከኩ አን እሳን ወጅን ገሌ ንጨብሱ። ");
INSERT INTO gaze_vpl VALUES ("DT31_17","006_31_17","DEU","31","17","17","ጋፈስ አን እሳንት ኣሬ እሳን ነንዺሰ፤ ፉለኮስ እሳን ዱራ ነንዾክሰ፤ እሳንስ ንበርበዴፈሙ። በዲሳፊ ረኮ ባይኤቱ እሳንት ዹፈ፤ እሳንስ ጋፈስ፣ ‘በዲስን ኩን ዋን ዋቅንኬኘ ኑ ወጅን ህንጅሬፍ ኑት ዹፌ ምቲ?’ ጄዸኒ ጋፈቱ። ");
INSERT INTO gaze_vpl VALUES ("DT31_18","006_31_18","DEU","31","18","18","ዋን እሳን ገረ ዋቆተ ብራት ገረገለኒፍ አን ሰበቢ ሀምነሳኒ ሁንዳቲፍ ጉቱማን ጉቱት ፉለኮ እሳን ዱራ ነንዾክፈዸ። ");
INSERT INTO gaze_vpl VALUES ("DT31_19","006_31_19","DEU","31","19","19","“አከ እሳንት ረጋ ና ተኡፍ፣ ፋርፈትና ከነ በሬፈዹቲ አከ እሳን ፋርፈተኒፍ እስራኤሎተ በርሲስ። ");
INSERT INTO gaze_vpl VALUES ("DT31_20","006_31_20","DEU","31","20","20","ዮሙ አን ብየ ኣነኒፊ ደም ኬሳ ቡርቁ ከን አን አቦቲሳኒቲፍ ከኩዻን ዋዳ ገሌት እሳን ፍዱት እሳን ኛተኒ ቁፈኒ ነራ ገረገሉዻን ዋቆተ ብራ ዋቄፈቱ፤ ነ ዺሰኒስ ከኩኮ ንጨብሱ። ");
INSERT INTO gaze_vpl VALUES ("DT31_21","006_31_21","DEU","31","21","21","ፋርፈናን ኩንስ ዮሙ በዲስኒፊ ረክን እሳንት ዹፉት ረጋ እሳንት ተአ፤ ኩን ሰኚሳኒ ኬሰት ህንእራንፈተሙቲ። አን ኡቱ ብየ ከኩዻን ዋዳሳኒ ገሌት እሳን ህንፍድንዩ ዋን እሳን ጎቹፍ ያደን ነንቤካቲ።” ");
INSERT INTO gaze_vpl VALUES ("DT31_22","006_31_22","DEU","31","22","22","ከናፉ ሙሴን ጋፈስ ፋርፈትና ከነ በሬሴ እስራኤሎተ በርሲሴ። ");
INSERT INTO gaze_vpl VALUES ("DT31_23","006_31_23","DEU","31","23","23","ዋቀዮስ እያሱ እልመ ኑኒቲፍ አጀጀ፣ “አት ሰበቢ ብየ አን ከኩዻን ዋዳሳኒ ገሌት እስራኤሎተ ገልችቱፍ ጭም፣ ጀባዹ፤ አን መታንኮ ስ ወጅን ጅራ” ጄዹ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("DT31_24","006_31_24","DEU","31","24","24","ሙሴን ኤርገ ዱቢ ሴረ ከና ጀልቀባ ሀመ ዹማት ክታበረት በሬሴ ፍጤ ቦዴ፣ ");
INSERT INTO gaze_vpl VALUES ("DT31_25","006_31_25","DEU","31","25","25","ሌዎተ ታቦተ ከኩ ዋቀዮ ባተኒፍ አጀጀ ከነ ኬኔ፦ ");
INSERT INTO gaze_vpl VALUES ("DT31_26","006_31_26","DEU","31","26","26","“ክታበ ሴራ ከነ ፉዹቲ ታቦተ ከኩ ዋቀዮ ዋቀኬቲ ብረ ካእ። ኩንስ አከ እን አቹመ ታኤ ረጋ እስንት ተኡፍ። ");
INSERT INTO gaze_vpl VALUES ("DT31_27","006_31_27","DEU","31","27","27","አን አከ እስን ፍንጭልቶታፊ መተ ጀቤዪ ታተን ነንቤካቲ። እስን ዮ ኡቱመ አን ጅሩ ዋቀዮት ፍንጭልተን፣ ኤርገ አን ዱኤ ቦዴሞ ሀመም ጫላ ሃፍንጭልተን ሬ! ");
INSERT INTO gaze_vpl VALUES ("DT31_28","006_31_28","DEU","31","28","28","አከ አን አከ እሳን ዸገአኒፍ ዱቢ ከነ እሳንት ህሜ አከ እሳንት ረጋ ተኡፍ ሰሚፊ ለፈ ዋመቹ ደንደኡፍ ማንጉዶተ ጎሶተኬሰኒ ሁንዳፊ ቆንዳልቶተኬሰን ሁንደ ፉለኮ ዱረት ወልት ቀባ። ");
INSERT INTO gaze_vpl VALUES ("DT31_29","006_31_29","DEU","31","29","29","አን አከ እስን ኤርገ አን ዱኤ ቦዴ ጉቱማን ጉቱት ጡሮፍተኒ አጀጀ አን እስኒ ኬኔራ ገረገልተን ነንቤካቲ። በሮተ ዹፉፍ ጅረን ኬሰ ረክን እስንት ዹፈ፤ እስን ፉለ ዋቀዮ ዱረት ዋን ሀማ ሆጄተኒ ሆጂዹመ ሀርከኬሰኒቲን ዼከምሳፍ እሰ ከካፍቱቲ።” ");
INSERT INTO gaze_vpl VALUES ("DT31_30","006_31_30","DEU","31","30","30","ሙሴንስ ጀልቀባ ሀመ ዹማት ዱቢ ፋርፈትና ከና ጉቱማ ወልዳ እስራኤልት አከነ ጄዼ ዸጌስሴ፦ ");
INSERT INTO gaze_vpl VALUES ("DT32_1","006_32_1","DEU","32","1","1","ያ ሰሚወን፣ ዸገኣ፤ አን ነንዱበዸ፤ ያ ለፈ፣ አትስ ዱቢ አፋንኮቲ ዸገእ። ");
INSERT INTO gaze_vpl VALUES ("DT32_2","006_32_2","DEU","32","2","2","በርሲስንኮ አከ ቦካ ሃሮቡ፤ ዱቢንኮስ አከ ፍጤንሳ ገድ ሃጮጮጱ፤ መርገረት አከ ቲፉ፣ ብቅልቱ ጮርቃረትስ አከ ቦካ ጉዳ ሃሮቡ። ");
INSERT INTO gaze_vpl VALUES ("DT32_3","006_32_3","DEU","32","3","3","አን መቃ ዋቀዮ ነንለብሰ። ጉድነ ዋቀኬኛ ጀጀዻ! ");
INSERT INTO gaze_vpl VALUES ("DT32_4","006_32_4","DEU","32","4","4","እን ከታዸ፤ ሆጂንሳ ሙዳ ህንቀቡ፤ ዳንዲወንሳ ሁንድኑስ ቀጄላዸ። እን ዋቀ አመነማ ህንዶጎጎሬ፣ ቶላፊ ቀጄላዸ። ");
INSERT INTO gaze_vpl VALUES ("DT32_5","006_32_5","DEU","32","5","5","እሳን ሀምነ እሰት ሆጄተኒሩ፤ ስአች እሳን ሰበቢ ቃኒሳኒቲፍ እጆሌሳ ምት፤ እሳን ዸሎተ ጀልኣፊ ምጪረማዸ። ");
INSERT INTO gaze_vpl VALUES ("DT32_6","006_32_6","DEU","32","6","6","ያ ሰበ ጎዋ፣ ከን ኦጉማ ህንቀብኔ፣ አት አከስት ዋቀዮፍ ዴቢ ኬንታ? እን አባኬ፣ ኡማኬ፣ ከን ስ ሆጄቴፊ ስ ቶልቼ ምቲ? ");
INSERT INTO gaze_vpl VALUES ("DT32_7","006_32_7","DEU","32","7","7","በሮተ ዱሪ ያደዹ፤ ዸሎተ ደርቤሌ ቀልቤፈዹ። እን ሲፍ እብሳቲ አባኬ ጋፈዹ፤ ማንጉዶተኬስ ጋፈዹ፤ እሳን ስት ህሙቲ። ");
INSERT INTO gaze_vpl VALUES ("DT32_8","006_32_8","DEU","32","8","8","ዋቅን ዋን ሁንዳ ኦሊ ዮሙ ሰቦታፍ ዻለ እሳኒፍ ኬኔት፣ ዮሙ ሰኚ ነማስ ገርገር ቆቆዴት፣ አኩመ ባይእነ እልማን እስራኤልት ነሞታፍ ዳሪ ዻቤ። ");
INSERT INTO gaze_vpl VALUES ("DT32_9","006_32_9","DEU","32","9","9","ቆድን ዋቀዮ ሰበሳት፤ ያቆብሞ ዻለ ዹንፋሳት። ");
INSERT INTO gaze_vpl VALUES ("DT32_10","006_32_10","DEU","32","10","10","እን ለፈ ገሞጂ፣ ለፈ ኦናቲፊ ገሞጂ ነመ ጉቡ ኬሰት እሰ አርገቴ። እን ጋቸነ ተኤፊ እሰ ኤጌ፤ አከ ቀሮ እጀ እሳትስ እሰ ኤጌ፤ ");
INSERT INTO gaze_vpl VALUES ("DT32_11","006_32_11","DEU","32","11","11","አኩመ ርሳን መነሼ ዲግዴ እልማንሼረ ቆቾ ቀብዱ፣ አኩመ ቆቾሼ በልእፍቴ ኦል እሳን ፉዸቱ፣ አኩመ ቆቾ እሼቲንስ እሳን ባቱ ሰነ፣ ");
INSERT INTO gaze_vpl VALUES ("DT32_12","006_32_12","DEU","32","12","12","ዋቀዮ ቆፈቱ እሰ ጌጌሴ፤ ዋቅን ኦርማ ቶኮዩ እሰ ወጅን ህንቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT32_13","006_32_13","DEU","32","13","13","እን ለፈ ኦል ከኣረ እሰ ቡራቅስሴ፤ ምዻን ለፈ ቆቲሳ እሰ ሶሬ። ከታ ኬሳ ደመ እሰ ኛችሴ፤ ዸጋ ጉራቸ ኬሳሞ ዘይቲ ኬኔፍ፤ ");
INSERT INTO gaze_vpl VALUES ("DT32_14","006_32_14","DEU","32","14","14","ዸዻፊ ኣነን ሳወኒፊ ቡሻዬ፣ ጦባላወኒፊ ሬኦተ ጮመን፣ ኮርቤዪ ሆላ ፍለተሞ ባሻን፣ እጀ ቀመዲ ጋሪስ እሰ ሶሬ። አት ጩንፋ ዺገ ወይኒ ቁልቁሉስ ንዹግዴ። ");
INSERT INTO gaze_vpl VALUES ("DT32_15","006_32_15","DEU","32","15","15","ይሹሩን ንገበቴ፤ ንዺቴ፤ ኛቴ ቁፌ፤ ንኡልፋቴ፤ ንጩሉሉቄ። ዋቀ እሰ ኡሜ ንዺሴ፤ ከታ ፈይሳሳ ተኤስ ንቱፈቴ። ");
INSERT INTO gaze_vpl VALUES ("DT32_16","006_32_16","DEU","32","16","16","እሳን ዋቆተ ኦርማቲን እሰ ህናፍስሰን፤ ዋቆተ ጅብሲሶ እሳኒቲንስ እሰ ዼከምሲሰን። ");
INSERT INTO gaze_vpl VALUES ("DT32_17","006_32_17","DEU","32","17","17","እሳን ሀፉሮተ ሀሞ ዋቀ ህንተእኒፍ፣ ዋቆተ ህንቤክኒፍ፣ ዋቆተ ሬፉ ዹፈኒፍ፣ ዋቆተ አቦቲንኬሰን ህንሶዳቲኒፍ ኣርሳ ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("DT32_18","006_32_18","DEU","32","18","18","አት ከታ ስ ዸልቼ ገንቴ፤ ዋቀ ስ ኡሜ እራንፈቴ። ");
INSERT INTO gaze_vpl VALUES ("DT32_19","006_32_19","DEU","32","19","19","ዋቀዮ ዋን ከነ አርጌ እሳን ቱፈቴ፤ እን እልማኒፊ እንተለን ኦፊሳት ኣሬራቲ። ");
INSERT INTO gaze_vpl VALUES ("DT32_20","006_32_20","DEU","32","20","20","እንስ፣ “አን ፉለኮ እሳን ዱራ ነንዾክፈዸ፤ ዹመሳኒስ ነንአርገ” ጄዼ፤ እሳን ዸሎተ ጀልኣ፣ እጆሌ ህንአመነምኔዻቲ። ");
INSERT INTO gaze_vpl VALUES ("DT32_21","006_32_21","DEU","32","21","21","እሳን ዋን ዋቀ ህንተእኒን ነ ህናፍስሰን፤ ዋቆተ ቶልፈሞሳኒ ከኔን ፋይዳ ህንቀብኔንስ ነ ኣርሰን። አንስ ወረ ሰበ ህንተእኒን አከ እሳን ህናፈን ነንጎዸ፤ ሰበ ሁበትና ህንቀብኔንስ እሳን ነንኣርሰ። ");
INSERT INTO gaze_vpl VALUES ("DT32_22","006_32_22","DEU","32","22","22","ዼከምሰኮቲን እብድ ቀብሲፈሜራቲ፤ እንስ ሀመ ሲኦልት ገድ ዽዽሜ ንቦበአ። ለፋፊ ዋን እሼን ባፍቱ ንኛተ፤ ሁንዴ ቱሉወኒትሌ እብደ ቀብሲሰ። ");
INSERT INTO gaze_vpl VALUES ("DT32_23","006_32_23","DEU","32","23","23","“አን ዋን ሀማ እሳንረ ነንቱለ፤ ጥየኮስ እሳንት ነንፍጠዸ። ");
INSERT INTO gaze_vpl VALUES ("DT32_24","006_32_24","DEU","32","24","24","ቤለ ሀማ፣ ጎልፋ ኛቴ ነመ ፍጡፊ ዸእቸ እሳንት ነንኤርገ፤ እልካን ብኔንሳ ቀረማሳ፣ ሀዻ ቡቲ ለፈረ ሎቱስ እሳንት ነንኤርገ። ");
INSERT INTO gaze_vpl VALUES ("DT32_25","006_32_25","DEU","32","25","25","ከራ ጉዳረት ጎራዴን ወረ እጆሌ ህንቀብኔ እሳን ጎዸ፤ መነሳኒት ሶዳቱ ሞአ። ደርገጎትኒፊ ደርገጌቲወን፣ ዳእመኒፊ ማንጉዶትን ንዹሙ። ");
INSERT INTO gaze_vpl VALUES ("DT32_26","006_32_26","DEU","32","26","26","አንስ እሳን ነንብትኔሰ፤ ያደኖሳኒስ ሰኚ ነማ ኬሳ ነንበሌሰ። ");
INSERT INTO gaze_vpl VALUES ("DT32_27","006_32_27","DEU","32","27","27","ገሩ አከ ዲኖትንሳኒ ኦፍ ቱለኒ፣ ‘ሀርከኬኘቱ ሞአቴ መሌ፣ ዋቀዮ ዋን ከነ ሁንደ ህንጎኔ’ ህንጄኔ፣ አን ዻደትኖ ዲና ሶዳዼረ።” ");
INSERT INTO gaze_vpl VALUES ("DT32_28","006_32_28","DEU","32","28","28","እሳን ሰበ ቀልቢ ህንቀብኔ፣ ከን ሁበትና ቶኮሌ ህንቀብኔዸ። ");
INSERT INTO gaze_vpl VALUES ("DT32_29","006_32_29","DEU","32","29","29","እሳን ኡቱ ኦጌዪ ተአኒ ዋን ከነ ሁበተኒ ስላ ዹመሳኒ ንቤኩ ቱረን! ");
INSERT INTO gaze_vpl VALUES ("DT32_30","006_32_30","DEU","32","30","30","ዮ ከታንሳኒ እሳን ጉርጉሬ መሌ፣ ዮ ዋቀዮ ደበርሴ እሳን ኬኔ መሌ፣ አከምት ነምን ቶኮ ነመ ኩመ ቶኮ ዮካን ነምን ለመ ነመ ኩመ ኩዸን ጉግሰ? ");
INSERT INTO gaze_vpl VALUES ("DT32_31","006_32_31","DEU","32","31","31","ከታንሳኒ አከ ከታኬኛ ምት፤ ከነሞ ዲኖትንኬኘዩ ህንገነን። ");
INSERT INTO gaze_vpl VALUES ("DT32_32","006_32_32","DEU","32","32","32","ወይኒንሳኒ ወይኒ ሶዶሚቲፊ ለፈ ቆቲሳ ጎሞራራ ዹፈ። እጅ ወይኒሳኒ ሱሚዻን፣ ሁርቡንሳኒስ ዋን ሀዻኡን ጉተሜረ። ");
INSERT INTO gaze_vpl VALUES ("DT32_33","006_32_33","DEU","32","33","33","ወይኒንሳኒ ሀዻ ቦፋ፣ ሱሚ ቦፈ ሀዻንሳ ነመ አጄሱት። ");
INSERT INTO gaze_vpl VALUES ("DT32_34","006_32_34","DEU","32","34","34","“ኩን ዋን ነ ብረት ኤገሜ፣ ከን ገልሜኮ ኬሰትስ ቻፓዻን ጩፈሜ ምቲ? ");
INSERT INTO gaze_vpl VALUES ("DT32_35","006_32_35","DEU","32","35","35","ሃሎ ባሱን ከንኮት፤ አን ገቲ ነንዴብሰ። ዬሮሳት ሚልሳኒ ንሙጩጫተ፤ ጉያን በዲሰሳኒ ዽኣቴረ፤ በዲስንሳኒስ እሳንት አሪፈቴረ።” ");
INSERT INTO gaze_vpl VALUES ("DT32_36","006_32_36","DEU","32","36","36","ዋቀዮ ዮሙ አከ እሳን ሁምነ ዸበን፣ አከ ገርብችስ ተኡ ነምን ብርመዱን ቶኮዩ ህንሀፍኔ አርጉት፣ ሰበሳቲፍ ንሙርቴሰ፤ ተጃጅልቶተሳቲፍስ ገራ ላፈ። ");
INSERT INTO gaze_vpl VALUES ("DT32_37","006_32_37","DEU","32","37","37","እንስ አከነ ጄዸ፦ “ከታን እሳን እት ደአተን፣ ዋቆትን ቶልፈሞንሳኒ አመ ኤሰ ጅሩ? ");
INSERT INTO gaze_vpl VALUES ("DT32_38","006_32_38","DEU","32","38","38","ዋቆትን ጮመ ቀልመሳኒ ኛተን፣ ከኔን ዽባዩ ዳዺ ወይኒሳኒ ዹገንስ ኤሰ ጅሩ? ሜ ከአኒ እሳን ሃገርጋረን! ሜ ደአትኖ ሃኬነኒፍ! ");
INSERT INTO gaze_vpl VALUES ("DT32_39","006_32_39","DEU","32","39","39","“አከ አን መታንኮ እሰ ተኤ ቤካ! አነ መሌ ዋቅን ብራ ህንጅሩ። አን ነንአጄሰ፤ ነንጅራችሰስ፤ ነንመዴሰ፤ ነንፈይሰስ፤ ነምን ሀርከኮቲ ባሱ ደንደኡ ቶኮዩ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT32_40","006_32_40","DEU","32","40","40","አን ዹጉማን በረ በራን ጅራታዻቲ ሀርከኮ ሰሚት ኦል ቀቤ ነንከከዸ፤ ");
INSERT INTO gaze_vpl VALUES ("DT32_41","006_32_41","DEU","32","41","41","አን ዮሙን ጎራዴኮ ጨለቅሳ ቀረዼ ሀርክኮ ሙርቲዻፍ እሰ ቀበቱት፣ አን ዲኖተኮ ሃሎ ነንበአ፤ ወረ ነ ጅበኒፍሌ ዋን እሳኒፍ መሉ ነንኬነ። ");
INSERT INTO gaze_vpl VALUES ("DT32_42","006_32_42","DEU","32","42","42","ዮሙ ጎራዴንኮ ፎን ኛቱት፣ አን አከ ጥይኮ ዺጋን መቻኡ ነንጎዸ፤ ዺግን ሱንስ ዺገ ወረ ቀለመኒቲፊ ቦጅአመኒ ከን መታ ሆገንቶተ ዲናት።” ");
INSERT INTO gaze_vpl VALUES ("DT32_43","006_32_43","DEU","32","43","43","ሰበቢ እን ሃሎ ዺገ ተጃጅልቶተሳ በኡፍ፣ ያ ሰቦታ፣ ነሞተሳ ወጅን ገመዳ። እን ዲኖተሳ ሃሎ በአ፤ ብያፊ ሰበሳቲፍ አራረ ንቡሰ። ");
INSERT INTO gaze_vpl VALUES ("DT32_44","006_32_44","DEU","32","44","44","ሙሴንስ እያሱ እልመ ኑን ወጅን ዹፌ ዱቢወን ፋርፈትና ከነ ሁንደ ነሞተ ዸጌስሴ። ");
INSERT INTO gaze_vpl VALUES ("DT32_45","006_32_45","DEU","32","45","45","እንስ ዮሙ ዱቢወን ከኔን ሁንደ እስራኤሎተ ሁንደት ዱበቴ ፍጤት፣ ");
INSERT INTO gaze_vpl VALUES ("DT32_46","006_32_46","DEU","32","46","46","አከነ እሳኒን ጄዼ፤ “አከ እሳን ዱቢወን ሴረ ከና ሁንደ ኦፍ ኤገናዻን ኤገኒፍ አከ እስን እጆሌኬሰን አጀጀን፣ ዱቢወን አን ሀርአ እፈ ባሴ እስንት ህሙ ሁንደ ቀልቢት ቀበዻ። ");
INSERT INTO gaze_vpl VALUES ("DT32_47","006_32_47","DEU","32","47","47","እሳን እስኒፍ ጅሬኘ መሌ ዱቢ ፋይዳ ህንቀብኔ ምት። ዱቢወን ከናን ብየ ለገ ዮርዳኖስ ጬተኒ ዻልተን ኬሰ በረ ዼራ ንጅራቱ።” ");
INSERT INTO gaze_vpl VALUES ("DT32_48","006_32_48","DEU","32","48","48","ጋፈሱመ ዋቀዮ አከነ ጄዼ ሙሴት ህሜ፤ ");
INSERT INTO gaze_vpl VALUES ("DT32_49","006_32_49","DEU","32","49","49","“ብየ ሞኣብ ከን ፉሌ ዬርኮ ጅሩ፣ ቱሉወን አባሪም ኬሰ ቱሉ ኔቦት ኦል በኢቲ ብየ ከነኣን፣ ብየ አን እስራኤሎታፍ ዻለ ጎዼ ኬኑ ፉሌት እላል። ");
INSERT INTO gaze_vpl VALUES ("DT32_50","006_32_50","DEU","32","50","50","አኩመ ኦቦሌስኬ አሮን ቱሉ ሆርረት ዱኤ ገረ አቦቲሳት ወልት ቀበሜ ሰነ፣ አትስ ቱሉ ያበቱ ሰነረት ንዱተ፤ ገረ አቦቲኬቲትስ ወልት ቀበምተ። ");
INSERT INTO gaze_vpl VALUES ("DT32_51","006_32_51","DEU","32","51","51","ኩንስ ዋን እስን ለማኑ ገሞጂ ሲን፣ ቃዴሽ ኬሰት ብሻን መሪባ ብረት ፉለ እስራኤሎታ ዱረት ነ አመኑ ድደኒፊ ሰበቢ እስራኤሎተ ግዱት ቁልቁሉማኮ ህንኤግኒፍ። ");
INSERT INTO gaze_vpl VALUES ("DT32_52","006_32_52","DEU","32","52","52","ከናፉ አት ፈጎት አርግተ መሌ ብየ አን እስራኤሎታፍ ኬኑ ሰነት ህንገልቱ።” ");
INSERT INTO gaze_vpl VALUES ("DT33_1","006_33_1","DEU","33","1","1","ኤብ ሙሴን ነምን ዋቃ ሱን ኡቱ ህንዱእን ዱረ እቲን እስራኤሎተ ኤብሴ ከነ፤ ");
INSERT INTO gaze_vpl VALUES ("DT33_2","006_33_2","DEU","33","2","2","እንስ አከነ ጄዼ፦ “ዋቀዮ ቱሉ ሲናራ ዹፌ፤ እሳንረትስ ሴኢርራ አከ አዱ ገነማት በኤ፤ ቱሉ ጳራንራ እሳን ኤብሴ። እን ቁልቁሎተሳ ኩማተመ ወጅን ዹፌ፤ ከራ ሀርከሳ ምርጋቲን እብደ ቦበኡቱ በኤ። ");
INSERT INTO gaze_vpl VALUES ("DT33_3","006_33_3","DEU","33","3","3","ዹጉማን ስቱ ሰበ ጃለተ፤ ቁልቁሎትን ሁንድኑ ሀርከኬ ኬሰ ጅሩ። ሁንድሳኒ ሚለኬ ጀለት ኩፉ፤ ቀጄልፈመስ ስራ አርገቱ፤ ");
INSERT INTO gaze_vpl VALUES ("DT33_4","006_33_4","DEU","33","4","4","ሙሴን ሴረ ኑ ኬኔረ፤ ኩንስ ዻለ ወልዳ ያቆብ። ");
INSERT INTO gaze_vpl VALUES ("DT33_5","006_33_5","DEU","33","5","5","ዬሮ ሆገንቶትን ሰባ ጎሶተ እስራኤል ወጅን ወልት ቀበመንት እን ይሹሩንረት ሞቲ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("DT33_6","006_33_6","DEU","33","6","6","“ሩቤን ሃጅራቱ መሌ ህንዱእን፤ ዮካን ባይእን ነሞተሳ ህንጥናትን።” ");
INSERT INTO gaze_vpl VALUES ("DT33_7","006_33_7","DEU","33","7","7","ዋኤ ይሁዳስ አከነ ጄዼ፦ “ያ ዋቀዮ፣ እየ ይሁዳ ዸገእ፤ ገረ ሰበ እሳትስ እሰ ፍድ። እን ሀርከ ኦፊሳቲን ኦፍ ሃኤጉ። ዮሙ እን ዲኖተሳቲን ወል ሎሉት ገርጋራሳ ተእ!” ");
INSERT INTO gaze_vpl VALUES ("DT33_8","006_33_8","DEU","33","8","8","እን ዋኤ ሌዊስ አከነ ጄዼ፦ “ቱሚሚፊ ኡሪሚንኬ ተጃጅላኬ አመነማዻፍ ሃተኡ። አት ለፈ ማሳህ ጄዸሙት እሰ ቆርቴ፤ ብሻን መሪባረት እሰ ሎልቴ። ");
INSERT INTO gaze_vpl VALUES ("DT33_9","006_33_9","DEU","33","9","9","ዋኤ አባፊ ሃዸሳስ፣ ‘አን እሰ ህንአርግኔ’ ጄዼ። እን ኦቦሎተሳ አዳን ህንባፈትኔ፤ እጆሌሳስ ህንቤክኔ፤ እሳን ዱቢኬቲፍ አጀጀመኒ ከኩኬ ኤገኒሩቲ። ");
INSERT INTO gaze_vpl VALUES ("DT33_10","006_33_10","DEU","33","10","10","እን አጀጀኬ ያቆብን፣ ሴረ ኬሞ እስራኤልን ንበርሲሰ። ፉለኬ ዱረት እጣነ፣ እዶ ኣርሳኬቲረትሌ ኣርሳ ጉበሙ ጉቱ ንዽኤሰ። ");
INSERT INTO gaze_vpl VALUES ("DT33_11","006_33_11","DEU","33","11","11","ያ ዋቀዮ፣ ኦጉማሳ ሁንደ ኤብሲፍ፤ ዋን ሀርክሳ ሆጄቱትስ ገመድ። ሞኦ ወረ እሰት ከአኒ ጨብስ፤ አከ እሳን ለመተ ህንካኔ ጎዺቲ ዲኖተሳ ዸእ።” ");
INSERT INTO gaze_vpl VALUES ("DT33_12","006_33_12","DEU","33","12","12","ዋኤ ቤንያም አከነ ጄዼ፦ “ነምን ዋቀዮ እሰ ጃለቱ ኤጉምሰሳቲን ነጋን ሃጅራቱ፤ እን ጉያ ጉቱ እሰ ኤጋቲ፤ ነምን ዋቀዮ እሰ ጃለቱ ገቲቲሳ ግዱ ቦቆተ።” ");
INSERT INTO gaze_vpl VALUES ("DT33_13","006_33_13","DEU","33","13","13","ዋኤ ዮሴፍ አከነ ጄዼ፦ “ዋቀዮ ብየሳ ሃኤብሱ፤ ፍጤንሰ ፍለተማ ሰሚዻ ቡሱዻን ብሻን ቦለ ገድ ፈጎ ኬሳቲን፣ ");
INSERT INTO gaze_vpl VALUES ("DT33_14","006_33_14","DEU","33","14","14","ምዻን ፍለተማ አዱን ብቅልችቱን፣ ዋን አከ መሌ ጋሪ ከን ጅእ ኬኑን፣ ");
INSERT INTO gaze_vpl VALUES ("DT33_15","006_33_15","DEU","33","15","15","ኬናወን ፍለተሞ ቱሉወን ዱሪቲን፣ በዻዹማ ጋረን በረ በራቲን፣ ");
INSERT INTO gaze_vpl VALUES ("DT33_16","006_33_16","DEU","33","16","16","ኬና ፍለተማ ለፋቲፊ ጉቱማሳቲን፣ ሱራ እሰ ደገለ ቦበኡ ኬሰ ቱሬ ሰናቲን ሃኤብሱ። እሳን ኩኔን ሁንድ መታ ዮሴፍ ከን ኦቦሎተሳ ግዱት ቡልቻ ተኤ ሰናረ ሃቡአን። ");
INSERT INTO gaze_vpl VALUES ("DT33_17","006_33_17","DEU","33","17","17","እን ኡልፍናን ኮርመ ሀንገፈ ፈካተ፤ ጋንፈወንሳ አከ ጋንፈወን ገፈርሳት። እሳኒንስ ሀመ ዳሪ ለፋት ሰቦተ ንወራነ። እሳንስ ኩመ ኩርነን ኤፍሬም፣ አከሱመስ ኩማተመ ምናሴት።” ");
INSERT INTO gaze_vpl VALUES ("DT33_18","006_33_18","DEU","33","18","18","ዋኤ ዜቡሎንስ አከነ ጄዼ፦ “ዜቡሎን አት ገድ በኡኬቲን፣ ይሳኮር አትስ ዱንካኖተኬ ኬሰት ገመድ። ");
INSERT INTO gaze_vpl VALUES ("DT33_19","006_33_19","DEU","33","19","19","እሳን ሰቦተ ገረ ቱሉት ንዋሙ፤ አችትስ ኣርሳ ቀጄሉማ ንዽኤሱ፤ እሳን ሶሩመ እረ ዸንገለኣ ገላነ ኬሳቲን፣ ቀቤኘ ጭረቸ ኬሰ ዾክፈሜንስ ንገመዱ።” ");
INSERT INTO gaze_vpl VALUES ("DT33_20","006_33_20","DEU","33","20","20","ዋኤ ጋድሞ አከነ ጄዼ፦ “ነምን ቡልቺንሰ ጋድ በልእሱ ኤብፈማዸ! ጋድ እሬፊ መታ ጨጨብሳ አከ ሌንጫት አች ጅራተ። ");
INSERT INTO gaze_vpl VALUES ("DT33_21","006_33_21","DEU","33","21","21","እን ኦፊሳቲፍ ለፈ ገበታ ፍለቴ፤ ቆድን ሆገንቶታ እሳፍ ቱርፈሜ። ዮሙ ሆገንቶትን ሰባ ወልት ቀበመንት፣ እን ፌዺ ቀጄሉመ ዋቀዮቲፊ ሙርቲ እስራኤልት ሙሬ ሰነ ፊጣን ባሴ።” ");
INSERT INTO gaze_vpl VALUES ("DT33_22","006_33_22","DEU","33","22","22","ዋኤ ዳንስ እን አከነ ጄዼ፦ “ዳን አከ እልሞሌ ሌንጫ ከን ባሻን ኬሳ ኡታሌ በኡት።” ");
INSERT INTO gaze_vpl VALUES ("DT33_23","006_33_23","DEU","33","23","23","ዋኤ ንፍታሌምስ አከነ ጄዼ፦ “ንፍታሌም ሱራ ጎንፈቴረ፤ ኤበ ዋቀዮቲንስ ጉተሜረ፤ እን ብየ ከራ ልጣቲፊ ክባቲን ጅሩ ንዻለ።” ");
INSERT INTO gaze_vpl VALUES ("DT33_24","006_33_24","DEU","33","24","24","ዋኤ ኣሼርሞ አከነ ጄዼ፦ “ኣሼር እልማን ሁንደ ጫላ ኤብፈማዸ፤ እን ኦቦሎተሳ ዱረት ፉዸተመ ሃአርገቱ፤ ሚለሳስ ዘይቲ ኬሰ ሃጩጰቱ። ");
INSERT INTO gaze_vpl VALUES ("DT33_25","006_33_25","DEU","33","25","25","ደንቀራን በልበለኬቲ ስቢላፊ ናሲ ተአ፤ ጀብንኬስ አኩመ በሮተ ጅሬኘኬቲ ንተአ። ");
INSERT INTO gaze_vpl VALUES ("DT33_26","006_33_26","DEU","33","26","26","“ዋቅን አከ ዋቀ ይሹሩን፣ ከን ስ ገርጋሩፍ ጄዼ ሰሚወንረ፣ ሱራሳቲንስ ዱሜሶተረ ጉሉፉ ቶኮሌ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT33_27","006_33_27","DEU","33","27","27","ዋቅን በረ በራ እዶ ጅሬኛኬቲት፤ እሬን በረ በራስ ስ ጀላን ጅረ። እን፣ ‘እሳን በሌስ!’ ጄዼ ዲኖተኬ ፉለኬ ዱራ ንአርአ። ");
INSERT INTO gaze_vpl VALUES ("DT33_28","006_33_28","DEU","33","28","28","ከናፉ እስራኤል ኮጳሳ ነጋዻን ጅራተ፤ ለፈ ፍጤንስ ሰሚ እት ጮጮጱት፣ ብየ ምዻኒፊ ወይኒ ሃራት ነምን ቡርቃ ያቆብ ቱቁ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT33_29","006_33_29","DEU","33","29","29","ያ እስራኤል፣ አት ኤብፈማዸ! ሰብን ዋቀዮ እሰ ፈይሴ፣ ከን አከኬቲ ኤኙ? እን ጋቸነኬቲፊ ገርጋራኬት፤ ጎራዴ ኡልፍነኬቲትስ። ዲኖትንኬ ሶዳዻን ፉለኬ ዱራ ዱበት ዴብኡ፤ አትሞ እዶወን ዋቄፈትናሳኒረ ኤጄተ።” ");
INSERT INTO gaze_vpl VALUES ("DT34_1","006_34_1","DEU","34","1","1","ሙሴንስ ድሬ ሞኣቢ ከኤ ፉሌ ፊጤ ጵስጋ ከን ዬርኮት አርገሙት፣ ጋረ ኔቦት ኦል በኤ። አችትስ ዋቀዮ ጉቱማ ብየቲ እሰት አርግሲሴ፤ ኩንስ ግልኣዲ ሀመ ዳንት፣ ");
INSERT INTO gaze_vpl VALUES ("DT34_2","006_34_2","DEU","34","2","2","ጉቱማ ንፍታሌም፣ ብየ ኤፍሬሚቲፊ ምናሴ፣ ጉቱማ ብየ ይሁዳ ከን ሀመ ገላነ ልጣት በልአቴ ጅሩ፣ ");
INSERT INTO gaze_vpl VALUES ("DT34_3","006_34_3","DEU","34","3","3","ኔጌቢፊ መጋላ ሜጢ ከን ሱሉለ ዬርኮቲ ጀልቀቤ ሀመ ዞኣሪት አርገሙዸ። ");
INSERT INTO gaze_vpl VALUES ("DT34_4","006_34_4","DEU","34","4","4","ኤርገሲ ዋቀዮ፣ “ኩን ብየ አን ዬሮ፣ ‘ሰኚኬቲፍ ነንኬነ’ ጄዼት ከኩዻን አብረሃሚፍ፣ ይስሃቂፊ ያቆቢፍ ዋዳ ገሌዸ። አን አከ አት እጀኬቲን አርግቱ ጎዼረ፤ አት ገሩ አች ህንጬቱ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("DT34_5","006_34_5","DEU","34","5","5","ሙሴን ገርብች ዋቀዮስ አኩመ ዋቀዮ እሳን ጄዼት አቹመ ሞኣብ ኬሰት ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("DT34_6","006_34_6","DEU","34","6","6","እንስ ብየ ሞኣብት ሱሉለ ፉሌ ቤት ጴኦርት አርገሙ ኬሰት እሰ አዋሌ፤ ገሩ ሀመ ሀርኣት አዋልሳ ኤሰ አከ ጅሩ ነምን ቶኮዩ ህንቤኩ። ");
INSERT INTO gaze_vpl VALUES ("DT34_7","006_34_7","DEU","34","7","7","ሙሴን ዬሮ ዱኤት ነመ ወጋ ዽበ ቶኮፊ ድግደመ ቱሬ፤ ተኡስ እጅሳ ህንደዸብኔ፤ ሁምንሳስ ህንላፍኔ። ");
INSERT INTO gaze_vpl VALUES ("DT34_8","006_34_8","DEU","34","8","8","እስራኤሎን ሀመ ዬሮን ገዳ ራወቱት ድሬ ሞኣብረት ቡልቲ ሶዶመ ሙሴዻፍ ቦአን። ");
INSERT INTO gaze_vpl VALUES ("DT34_9","006_34_9","DEU","34","9","9","ዋን ሙሴን ሀርከሳ እሰረ ካኤ ቱሬፍ እያሱን እልም ኑን ሀፉረ ኦጉማቲን ጉተሜ። ከናፉ እስራኤሎን እሰ ዸገአኒ ዋን ዋቀዮ ሙሴ አጀጄ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("DT34_10","006_34_10","DEU","34","10","10","ኤርገሲ ራጂን አከ ሙሴ ከን እፋን እፈት ዋቀዮን ቤኩ ቶኮዩ እስራኤል ኬሰት ህንካኔ፤ ");
INSERT INTO gaze_vpl VALUES ("DT34_11","006_34_11","DEU","34","11","11","ከን ዋቀዮ አከ እን ፈረኦንረት፣ ቆንዳልቶተሳቲፊ ጉቱ ብየሳረት መለቶወኒፊ ድንቂወን ሰነ ሆጄቱፍ ግብጥት ኤርጌ ዋን ሰነ ሆጄቴ ቶኮዩ ህንጅሩ። ");
INSERT INTO gaze_vpl VALUES ("DT34_12","006_34_12","DEU","34","12","12","ነምን ቶኮዩ ተኩማ ሁምነ ጉዳ ዮካን ሆጂ አከ መሌ ሶዳችሳ ሙሴን ፉለ እስራኤሎተ ሁንዳ ዱረት አርግሲሴ ሰነ ህንአርግሲፍኔቲ። ");
INSERT INTO gaze_vpl VALUES ("JS1_1","007_1_1","JOS","1","1","1","ኤርገ ሙሴን ገርብች ዋቀዮ ሱን ዱኤ ቦዴ ዋቀዮ አከነ ጄዼ እያሱ እልመ ኑን ገርጋራ ሙሴ ሰነት ዱበቴ፦ ");
INSERT INTO gaze_vpl VALUES ("JS1_2","007_1_2","JOS","1","2","2","“ገርብችኮ ሙሴን ዱኤረ። ኤጋ አመ አቲፊ ሰብን ኩን ሁንድኑ ገረ ብየ አን እሳኒፍ፣ እስራኤሎታፍ ኬኑፍ ጅሩት ገሉፍ ለገ ዮርዳኖስ ጬኡፍ ቆጳኣ። ");
INSERT INTO gaze_vpl VALUES ("JS1_3","007_1_3","JOS","1","3","3","አንስ አኩመ ሙሴፍ ዋዳ ገሌ ሰነት እዶ ሚልኬሰን ገኤ ሁንደ እስኒፈን ኬነ። ");
INSERT INTO gaze_vpl VALUES ("JS1_4","007_1_4","JOS","1","4","4","ዳንጋንኬሰንስ ገሞጂዻ ጀልቀብዴ ሀመ ልባኖንት፣ ለግቸ ጉዳ ኤፍራጢሲ ጀልቀብዴ ብየ ሄቶታ ሁንደ ኬሰ ባቴ ከራ ዽኣቲን ሀመ ገላነ ጉዳት በልአት። ");
INSERT INTO gaze_vpl VALUES ("JS1_5","007_1_5","JOS","1","5","5","በረ ጅሬኘኬቲ ጉቱ ነምን ስ ዱረ ዻበቹ ደንደኡ ቶኮዩ ህንጅሩ። አን አኩመን ሙሴ ወጅን ቱሬ ሰነ ስ ወጅንስ ነንተአ፤ አን ጎንኩማ ስ ህንገቱ ዮካን ስ ህንዺሱ። ");
INSERT INTO gaze_vpl VALUES ("JS1_6","007_1_6","JOS","1","6","6","አት ሰበቢ አከ እሳን ብየ አን አቦቲ እሳኒቲፍ ኬኑፍ ከከዼ ሰነ ዻለኒፍ ሰበ ከነ ሆገኑፍ ጭም፤ እጀ ጀባዹስ። ");
INSERT INTO gaze_vpl VALUES ("JS1_7","007_1_7","JOS","1","7","7","“ጭም፤ እጀ ጀባዹስ። ሴረ ገርብችኮ ሙሴን ሲፍ ኬኔ ሁንዱማፍ ኦፍ ኤገናዻን አጀጀም፤ አከ ገረ ዴምቱ ሁንዱመት ሲፍ ምልካኡፍስ ምርገት ዮካን ብታት ህንጎርን። ");
INSERT INTO gaze_vpl VALUES ("JS1_8","007_1_8","JOS","1","8","8","ክታብን ሴራ ኩን አፋንኬቲ ህንቡእን። ዋን እሰ ኬሰት በሬፈሜ ሁንደ ጎቹፍ አከ ኦፍ ኤገቱፍስ ሀልከኒ ጉያ እት ያድ። አከሲንስ አት ንበዻተ፤ ንምልኮፍተስ። ");
INSERT INTO gaze_vpl VALUES ("JS1_9","007_1_9","JOS","1","9","9","አን አከነ ጄዼ ስ ህንአጀጅኔ? ጭም፤ እጀ ጀባዹስ። ዋን ዋቀዮ ዋቅንኬ እዶ አት ዴምቱ ሁንዱመት ስ ወጅን ተኡፍ፣ ህንሶዳትን፤ አብዲስ ህንኩተትን።” ");
INSERT INTO gaze_vpl VALUES ("JS1_10","007_1_10","JOS","1","10","10","ከናፉ እያሱን አከነ ጄዼ ቆንዳልቶተ ሰባ አጀጄ፦ ");
INSERT INTO gaze_vpl VALUES ("JS1_11","007_1_11","JOS","1","11","11","“ቁበተ ኬሰ ዴዴማቲ ነሞታን፣ ‘ገላኬሰን ቆጴፈዻ። እስን ብየ ዋቀዮ ዋቅንኬሰን እስኒ ኬኑፍ ጅሩ ሰነ ዻለ ኦፊኬሰኒ ጎተኒ ፉዸቹፍ ቡልቲ ሰዲ ኬሰት ዮርዳኖስ ንጬቱ።’ ” ");
INSERT INTO gaze_vpl VALUES ("JS1_12","007_1_12","JOS","1","12","12","እያሱን ገሩ ጎሰ ሩቤኒን፣ ጎሰ ጋዲቲፊ ወለካ ጎሰ ምናሴቲን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("JS1_13","007_1_13","JOS","1","13","13","“አጀጀ ገርብች ዋቀዮ ሙሴን እስኒ ኬኔ ሰነ ያደዻ፤ ‘ዋቀዮ ዋቅንኬሰን ቦቆና እስኒ ኬነ፤ ብየ ከነስ እስኒ ኬኔረ።’ ");
INSERT INTO gaze_vpl VALUES ("JS1_14","007_1_14","JOS","1","14","14","ኒቶትንኬሰን፣ እጆሌንኬሰኒፊ ሆሪንኬሰን ብየ ሙሴን ገመ በአ ዮርዳኖስ እስኒ ኬኔ ኬሰ ሃቱረን፤ ገሩ ነሞትንኬሰን ወር ሎላፍ ቆጳአን ሁንድ ኦቦሎተኬሰን ዱረ ገመት ሃጬአን። እስን ኦቦሎተኬሰን ገርጋሩ ቀብዱ፤ ");
INSERT INTO gaze_vpl VALUES ("JS1_15","007_1_15","JOS","1","15","15","ሀመ ዋቀዮ አኩመ እስኒ ጎዼ ሰነ እሳኒፍስ ቦቆና ኬኔ እሳንስ ብየ ዋቀዮ ዋቅንኬሰን እሳኒ ኬኑ ዻለንት እሳን ገርጋሩ ቀብዱ። ኤርገሲ ዴብተኒ ብየኬሰን ከን ሙሴን ገርብች ዋቀዮ ሱን ገመ በአ ዮርዳኖስት ከራ በአ ቢፍቱ እስኒ ኬኔ ሰነ ንዻልቱ።” ");
INSERT INTO gaze_vpl VALUES ("JS1_16","007_1_16","JOS","1","16","16","እሳንስ አከነ ጄዸኒ እያሱፍ ዴቢ ኬነን፤ “ኑ ዋን አት ኑ አጀጄ ከምዩ ንሆጄትነ፤ ገረ አት ኑ ኤርግቱ ከምዩስ ንዴምነ። ");
INSERT INTO gaze_vpl VALUES ("JS1_17","007_1_17","JOS","1","17","17","ኑ አኩመ ሙሴዻፍ ጉቱማን ጉቱት አጀጀምኔ ሰነ ሲፍስ አከሱመ ንአጀጀምነ። ዋቀዮ ዋቅንኬ ገሩ አኩመ ሙሴ ወጅን ቱሬ ሰነ ስ ወጅንስ ሃተኡ። ");
INSERT INTO gaze_vpl VALUES ("JS1_18","007_1_18","JOS","1","18","18","ነምን አጀጀኬት ፍንጭሉፊ ዱቢ አት ከራ ከሚንዩ እሰ አጀጄፍ ህንአጀጀምኔ ሁንድ ሃአጄፈሙ። አት ቆፍት ጭም፤ እጀ ጀባዹስ!” ");
INSERT INTO gaze_vpl VALUES ("JS2_1","007_2_1","JOS","2","1","1","ኤርገሲ እያሱን እልም ኑን፣ “ዸቃቲ ብየ ሰነ፣ ኬሱመቱ ዬርኮ በሳሳ” ጄዼ ዾክሳን በሳስቶተ ለመ ብየ ሽጢሚቲ ኤርጌ። እሳንስ ዴመኒ መነ ሰጋገልትቲ ረሃብ ጄዸምቱ ቶኮ ሴነኒ አቹመ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS2_2","007_2_2","JOS","2","2","2","ሞትቸ ዬርኮትስ፣ “ኩኖ! እስራኤሎተ ኬሳ ነሞትን ቶኮ ቶኮ ብየቲ በሳሱፍ ገልገለ ከነ አስ ዹፈኒሩ” ጄዸሜ ህመሜ። ");
INSERT INTO gaze_vpl VALUES ("JS2_3","007_2_3","JOS","2","3","3","ከናፉ ሞትች ዬርኮ፣ “ሰበቢ እሳን ጉቱማ ብየቲ በሳሱፍ ዹፈኒፍ ነሞተ ገረኬ ዹፈኒ መነኬ ሴነን ሰነ ገድ ባስ” ጄዼ ዻምሰ ከነ ረሃብት ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("JS2_4","007_2_4","JOS","2","4","4","ዱበርትቲን ገሩ ነሞተ ለማን ፉቴ ዾክስቴ። እሼንስ አከነ ጄቴ፤ “ዹጉመ ነሞትን ገረኮ ዹፈኒሩ፤ አን ገሩ አከ እሳን ኤሳ ዹፈን ህንቤክኔ። ");
INSERT INTO gaze_vpl VALUES ("JS2_5","007_2_5","JOS","2","5","5","እሳንስ ገልገለ ዮሙ ዬሮን ከር መጋለቲ ጩፈሙ ገኤት በአኒ ዴመን። ከራ እሳን ዴመንስ አን ህንቤኩ። እሳን ቀቀብዱ ተኣቲ ደፋ እሳን ዱካ ቡኣ።” ");
INSERT INTO gaze_vpl VALUES ("JS2_6","007_2_6","JOS","2","6","6","እሼን ገሩ ገረ በንቲ መናት ኦል እሳን ባፍቴ ጭዲ ተልባ ከን በንቲ መናረት ቱልቴ ቱርቴ ጀለ እሳን ዾክስቴ። ");
INSERT INTO gaze_vpl VALUES ("JS2_7","007_2_7","JOS","2","7","7","ከናፉ ነሞትን በሳስቶተ ሰነ ዱካ ቡኡዻፍ ከራ ገረ መልካ ዮርዳኖስ ጌሱረ ቡአኒ ቀጄለን፤ ከር ሱንስ አኩመ ዱካ ቡቶትን ሱን በአኒን ጩፈሜ። ");
INSERT INTO gaze_vpl VALUES ("JS2_8","007_2_8","JOS","2","8","8","እሼንስ ኡቱ በሳስቶትን ሱን ቡሉፍ ህንጭጪስን ገረ በንቲ መናት ኦል ባቴ ");
INSERT INTO gaze_vpl VALUES ("JS2_9","007_2_9","JOS","2","9","9","አከነ እሳኒን ጄቴ፤ “አን አከ ዋቀዮ ብየ ከነ እስኒ ኬኔፊ አከ እስን ሶዳቹን ኑረ ቡኤስ ነንቤከ፤ ነምን ብየ ከነ ኬሰ ጅራቱ ሁንድኑስ ሰበቢኬሰኒፍ ፉለኬሰን ዱረት ሶዳዻን ሆለቻ ጅረ። ");
INSERT INTO gaze_vpl VALUES ("JS2_10","007_2_10","JOS","2","10","10","ዮሙ እስን ግብጢ ባተንት አከ እት ዋቀዮ ገላነ ዲማ ፉለኬሰን ዱረት ጎግሴ፣ ዋን እስንስ ስሆኒፊ ኦግ ሞቶተ አሞሮታ ከኔን ገመ በአ ዮርዳኖስት ጉቱማን ጉቱት በሌስተን ሰነ ለማን ጎተን ዸጌኜረ። ");
INSERT INTO gaze_vpl VALUES ("JS2_11","007_2_11","JOS","2","11","11","ኑ ዮሙ ዋኤ ዋን ከና ዸጌኜት ሰበቢኬሰኒፍ ኦኔንኬኘ በቅጤ አብዲ ኩተትኔ። ዋቀዮ ዋቅንኬሰን ኦል ሰሚ ጉባት፣ ገድ ለፈረትስ ዋቃቲ። ");
INSERT INTO gaze_vpl VALUES ("JS2_12","007_2_12","JOS","2","12","12","“ኤጋ አመ ሰበቢ አን ገራ እስኒ ላፌፍ እስንስ አከሱመ አከ ማቲኮቲፍ ገራ ላፍተን መቃ ዋቀዮቲን ና ከከዻ። መለቶ ዹጋስ ና ኬና፤ ");
INSERT INTO gaze_vpl VALUES ("JS2_13","007_2_13","JOS","2","13","13","ኩንስ አከ እስን ሉቡ አባኮቲ፣ ሃዸኮቲ፣ ኦቦሎታፊ ኦቦሌቶተኮቲ፣ ዋን ከንሳኒ ተኤ ሁንዳፊ ሉቡኬኘ ዱአ ኦልችተኒፍ።” ");
INSERT INTO gaze_vpl VALUES ("JS2_14","007_2_14","JOS","2","14","14","ነሞትንስ፣ “ሉቡንኬኘ ሰበቢ ሉቡኬሰኒቲፍ ሃበዱ! ዮ እስን ዋን ኑ ሆጄትኑ ከነ ነመት ህሙ ባተን ኑ ዮሙ ዋቀዮ ብየ ከነ ኑ ኬኑት ገረ ላፍናፊ አመነሙማዻን ስ ስመትነ” ጄዸኒ እሼ አብደቺሰን። ");
INSERT INTO gaze_vpl VALUES ("JS2_15","007_2_15","JOS","2","15","15","ከናፉ እሼን ሰበቢ መን እሼን ኬሰ ጅራቱ ሱን ደላ መጋለቲቲን ወል ቀበቱፍ ፎዳ ኬሳን ፉኞዻን ገድ እሳን ቡፍቴ። ");
INSERT INTO gaze_vpl VALUES ("JS2_16","007_2_16","JOS","2","16","16","እሼንስ አከነ እሳኒን ጄቴ፤ “አከ ወር እስን ዱካ ቡአን ሱን እስን ህንአርግኔፍ ገረ ጋረኒት በቀዻ። ሀመ እሳን ዴብአንት ጉዮተ ሰዲ አችት ዾከዻ፤ ኤርገሲሞ ከራኬሰን ዴማ።” ");
INSERT INTO gaze_vpl VALUES ("JS2_17","007_2_17","JOS","2","17","17","ነሞትን ሱንስ አከነ ጄዸኒን፤ “ከኩን አት ኑ ከከቺፍቴ ኩን ከን ኑ ቀበቹ ደንደኡ፣ ");
INSERT INTO gaze_vpl VALUES ("JS2_18","007_2_18","JOS","2","18","18","ዮ አት ዮሙ ኑ ብየቲ ሴኑት ፉኞ ብልዲማ ከነ ፎዳ እቲን ገድ ኑ ቡፍቴ ከነት ሂቴ አባኬቲፊ ሃዸኬ፣ ኦቦሎተኬቲፊ ማቲኬ ሁንደ መነኬት ገልችቴ ቆፈ። ");
INSERT INTO gaze_vpl VALUES ("JS2_19","007_2_19","JOS","2","19","19","ነምን ቶኮዩ ዮ መነኬ ኬሳ ገረ ዳንዲ አላት ገድ በኤ፣ ዺግንሳ መቱመሳት ዴብአ፤ ኑ እት ህንጋፈተምኑ። ነመ ስ ወጅን መነኬ ኬሰ ጅሩሞ ዮ ሀርክ ቶኮዩ እሰ ቱቄ፣ ዺግንሳ መታኬኘት ዴብአ። ");
INSERT INTO gaze_vpl VALUES ("JS2_20","007_2_20","JOS","2","20","20","ገሩ ዮ አት ዋን ኑ ሆጄትኑ ከነ ነመት ህምቴ፣ ኑ ከኩ አት ኑ ከከቺፍቴ ሰነ ጀላ ብልሰ ባነ።” ");
INSERT INTO gaze_vpl VALUES ("JS2_21","007_2_21","JOS","2","21","21","እሼንስ፣ “ፉዸዼረ፤ አኩመ እስን ጄተን ሃተኡ” ጄቴ ዴብፍቴ። ከናፉ እሼን እሳን ኤርግቴ፤ እሳንስ ከአኒ ዴመን። እሼን ፉኞ ብልዲማ ሰነ ፎዳ ሰነት ሂቴ። ");
INSERT INTO gaze_vpl VALUES ("JS2_22","007_2_22","JOS","2","22","22","እሳንስ ዮሙ በአንት ገረ ጋረኒ ዴመኒ ሀመ ዱካ ቡቶትን ሱን ከራረ በርባደኒ እሳን ዸበኒ ዴብአንት ጉያ ሰዲ አች ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS2_23","007_2_23","JOS","2","23","23","በሳስቶትን ለማን ሱንስ ዴብአኒ ጋረን ኬሳ በአኒ መልካዻን ለገ ጬኡዻን ገረ እያሱ እልመ ኑን ዹፈን፤ ዋን እሳንረ ገኤ ሁንደስ እሰት ህመን። ");
INSERT INTO gaze_vpl VALUES ("JS2_24","007_2_24","JOS","2","24","24","እሳንስ እያሱዻን፣ “ዋቀዮ ዹጉማን ብየቲ ጉቱ ሀርከኬኘት ኬኔረ፤ ነሞትን ሁንድኑስ ሰበቢኬኛፍ ሶዳዻን ሆለቻ ጅሩ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JS3_1","007_3_1","JOS","3","1","1","እያሱፊ እስራኤሎን ሁንድኑ ገነመ በሪ ሽጢም ኬሳ በአኒ ገረ ለገ ዮርዳኖስ ዹፈን። ኡቱ ገመት ህንጬእን ዱረስ አች ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("JS3_2","007_3_2","JOS","3","2","2","ቡልቲ ሰዲ ቦዴ አጀጆትን ሎልቶታ ቁበተ ኬሰ ዴዴመኒ፣ ");
INSERT INTO gaze_vpl VALUES ("JS3_3","007_3_3","JOS","3","3","3","አከነ ጄዸኒ ነሞተ አጀጀን፦ “እስን ዮሙ ታቦተ ከኩ ዋቀዮ ዋቀኬሰኒቲፊ ሌዎተ ሉቦተ ተአን እሳኒ ታቦትቸ ባተን አርግተንት እዶኬሰኒ ካተኒ ታቦትቸ ፋነ ቡኡ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("JS3_4","007_3_4","JOS","3","4","4","እስን ሰበቢ ዱራን ከራ ከናን ህንደርብኒፍ፣ ከራ ዴሙን እስኒ መሉ ንቤክቱ። ገሩ እስኒፊ ታቦትቸ ግዱት ገርገር ፈጌኘ ገረ ዹንዹመ ኩመ ለመ ሀምብሳ፤ እትስ ህንዽኣትና።” ");
INSERT INTO gaze_vpl VALUES ("JS3_5","007_3_5","JOS","3","5","5","እያሱንስ ኡመታን፣ “ኦፍ ቁልቁሌሳ፤ ዋቀዮ ቦር ግዱኬሰንት ወንቶተ ድንቅሲሳ ንሆጄታቲ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS3_6","007_3_6","JOS","3","6","6","እያሱንስ ሉቦታን፣ “ታቦተ ከኩ ፉዻቲ ኡመተ ዱረ ደርባ” ጄዼ። ከናፉ እሳን ታቦትቸ ፉዸኒ ኡመተ ዱረ ደርበን። ");
INSERT INTO gaze_vpl VALUES ("JS3_7","007_3_7","JOS","3","7","7","ዋቀዮስ እያሱዻን አከነ ጄዼ፤ “አከ እሳን አከ አን አኩመን ሙሴ ወጅን ቱሬ ሰነ ስ ወጅን ጅሩ ቤከኒፍ፣ አን ሀርአ ፉለ እስራኤሎተ ሁንዳ ዱረት ነመ ጉዳ ስ ጎቹ ነንጀልቀበ። ");
INSERT INTO gaze_vpl VALUES ("JS3_8","007_3_8","JOS","3","8","8","አትስ ሉቦተ ታቦተ ከኩ ባተኒን፣ ‘እስን ዮሙ ቀርቀረ ብሻን ዮርዳኖስ ጌሰንት፣ ዸቃቲ ለገ ኬሰ ዸዻበዻ’ ጄዽ።” ");
INSERT INTO gaze_vpl VALUES ("JS3_9","007_3_9","JOS","3","9","9","እያሱንስ እስራኤሎታን አከነ ጄዼ፤ “አስ ኮታቲ ዱቢ ዋቀዮ ዋቀኬሰኒ ዸገኣ። ");
INSERT INTO gaze_vpl VALUES ("JS3_10","007_3_10","JOS","3","10","10","አክ እስን እት አከ ዋቅን ጅራታን ግዱኬሰን ጅሩፊ አከ እን ዹጉማን ከነኣኖተ፣ ሄቶተ፣ ሂዎተ፣ ፌርዞተ፣ ግርጋሾተ፣ አሞሮታፊ ዬቡሶተ ፉለኬሰን ዱራ አርኤ ባሱ ቤክተን ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("JS3_11","007_3_11","JOS","3","11","11","ኩኖ፣ ታቦትን ከኩ ጎፍታ ለፈ ሁንዱማ እስን ዱራን ዮርዳኖስ ንሴነ። ");
INSERT INTO gaze_vpl VALUES ("JS3_12","007_3_12","JOS","3","12","12","ከናፉ አመ ጎሶተ እስራኤል ኬሳ ነመ ኩዸ ለመ ጄቹንስ ቶኮ ቶኮ ጎሳ ኬሳ ነመ ቶኮ ቶኮ ፍለዻ። ");
INSERT INTO gaze_vpl VALUES ("JS3_13","007_3_13","JOS","3","13","13","አኩመ ሉቦትን ታቦተ ዋቀዮ ጎፍታ ለፈ ሁንዳ ባተን ሚለሳኒ ዮርዳኖስ ኬሰ ሴንስሰኒን፣ ብሻንሳ ከን ጉባዻ ገድ ያኡ ንጭተ፤ ቱለሜስ ኦል ዻበተ።” ");
INSERT INTO gaze_vpl VALUES ("JS3_14","007_3_14","JOS","3","14","14","ከናፍ ዮሙ ነሞትን ለገ ዮርዳኖስ ጬኡፍ ቁበተሳኒ ኬሳ በአንት፣ ሉቦትን ታቦተ ከኩ ባተኒ እሳን ዱረ ደርበኒ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("JS3_15","007_3_15","JOS","3","15","15","ዬሮ ምዻን ገልፈሙ ሁንደ ለግን ዮርዳኖስ ጉቴ እረ ዸንገለአ። ተኡስ አኩመ ሉቦትን ታቦትቸ ባተን ዮርዳኖስ ገአኒ ሚልሳኒ ቀርቀረ ብሻኒ ቱቄን፣ ");
INSERT INTO gaze_vpl VALUES ("JS3_16","007_3_16","JOS","3","16","16","ብሻን ቡርቃ ኦሊቲ ዹፉ ያኡ ዺሴ። እዶ መጋላ አዳም ጄዸሙ ከን ዛሬታን ብራ ሰነራ ፈጋቴ ቱለሜ ዻበቴ፤ ብሻን ገረ ገላነ አረባት ዮካን ገላነ ሶግዳት ገድ ያኡስ ጉቱማን ጉቱት ጭቴ። ከናፉ ነሞትን ፉሌ ዬርኮቲን ገረ ገማት ጬአን። ");
INSERT INTO gaze_vpl VALUES ("JS3_17","007_3_17","JOS","3","17","17","ዬሮ እስራኤሎን ሁንድ ደርባ ቱረንት ሉቦትን ታቦተ ከኩ ዋቀዮ ባተን ሱን ሀመ ሰብን ጉቱማን ጉቱት ለፈ ጎጎጋረ ጬኡት ወለካ ዮርዳኖስ ኬሰ ቀጄለኒ ለፈ ጎጎጋረ ዻበተን። ");
INSERT INTO gaze_vpl VALUES ("JS4_1","007_4_1","JOS","4","1","1","ዋቀዮስ ኤርገ ሰብን ጉቱን ዮርዳኖስን ጬኤ ቦዴ፣ እያሱዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("JS4_2","007_4_2","JOS","4","2","2","“ሰበ ኬሳ ነመ ኩዸ ለመ፣ ቶኮ ቶኮ ጎሳ ኬሳ ነመ ቶኮ ቶኮ ፍለዹቲ ");
INSERT INTO gaze_vpl VALUES ("JS4_3","007_4_3","JOS","4","3","3","አከ እሳን ወለካ ዮርዳኖስ ኬሳ እዶ ሉቦትን ዸዻበተን ሰና ዸጎተ ኩዸ ለመ ፉዸኒ፣ ባተኒ እስን ወጅን ዴመኒ እዶ እስን ኤደነ ቡልተንት ለፈ ከካአን እት ህም።” ");
INSERT INTO gaze_vpl VALUES ("JS4_4","007_4_4","JOS","4","4","4","ከናፍስ እያሱን፣ ነሞተ ኩዸ ለማን እስራኤሎተ ኬሳ፣ ቶኮ ቶኮ ጎሳ ኬሳ ቶኮ ቶኮ ፍለቴ ሰነ ወልት ዋሜ ");
INSERT INTO gaze_vpl VALUES ("JS4_5","007_4_5","JOS","4","5","5","አከነ ጄዼን፤ “ታቦተ ዋቀዮ ዋቀኬሰኒ ከነ ዱረ ደርባቲ ወለካ ዮርዳኖስ ሴና። ቶኮን ቶኮንኬሰንስ አኩመ ባይእነ ጎሶተ እስራኤሎታት ዸጋ ቶኮ ቶኮ ፉዸተኒ ገቲቲኬሰንት ባቹ ቀብዱ። ");
INSERT INTO gaze_vpl VALUES ("JS4_6","007_4_6","JOS","4","6","6","ኩንስ አከ ወን ኩን ግዱኬሰንት መለቶ ተኡፍ። ዮሙ እጆሌንኬሰን ገረ ፉልዱራት፣ ‘ዸጎትን ኩኔን ማል አርግሲሱ?’ ጄዸኒ እስን ጋፈተንት፣ ");
INSERT INTO gaze_vpl VALUES ("JS4_7","007_4_7","JOS","4","7","7","አከ ብሻን ለገ ዮርዳኖስ ፉለ ታቦተ ከኩ ዋቀዮ ዱረት ገርገር ጭቴ እት ህማ። ዮሙ ታቦትን ኩን ለገ ዮርዳኖስ ጬኤት ብሻን ዮርዳኖስ ገርገር ጭቴ። ዸጋወን ኩኔንስ ሰበ እስራኤሊፍ ያደኖ በረ በራ ተኡ።” ");
INSERT INTO gaze_vpl VALUES ("JS4_8","007_4_8","JOS","4","8","8","ከናፉ እስራኤሎን አኩመ እያሱን እሳን አጀጄ ጎዸን። እሳንስ አኩመ ዋቀዮ እያሱት ህሜ ሰነ፣ አኩመ ባይእነ ጎሶተ እስራኤሎታት ዸጎተ ኩዸ ለመ ወለካ ዮርዳኖስ ኬሳ ፉዸን፤ ሀመ እዶ ቁበተ እሳኒትስ ባተኒ አችት ለፈ ካአተን። ");
INSERT INTO gaze_vpl VALUES ("JS4_9","007_4_9","JOS","4","9","9","እያሱንስ ዸጎተ ኩዸ ለማን ወለካ ዮርዳኖስ ኬሰ እዶ ሉቦትን ታቦተ ከኩ ባተን ሱን እጃጃ ቱረን ሰነ ኦል ዸዻቤ። እሳንስ ሀመ ሀርኣት አቹመ ጅሩ። ");
INSERT INTO gaze_vpl VALUES ("JS4_10","007_4_10","JOS","4","10","10","ሉቦትን ታቦተ ከኩ ባተን ሱንስ ሀመ ወን ዋቀዮ አከ እን ነሞተት ህሙፍ እያሱ አጀጄ ሁንድ አኩመ ሙሴን እያሱ አጀጄት ራወተሙት ወለካ ዮርዳኖስ ኬሰ ዸዻበቻ ቱረን። ነሞትንስ ደፈኒ ጬአን፤ ");
INSERT INTO gaze_vpl VALUES ("JS4_11","007_4_11","JOS","4","11","11","አኩመ ሁንድሳኒ ጬአኒንስ ኡቱመ ነሞትን አርገኑ ታቦትን ዋቀዮቲፊ ሉቦትን ገረ ገመ ካኒት ጬአን። ");
INSERT INTO gaze_vpl VALUES ("JS4_12","007_4_12","JOS","4","12","12","እልማን ሩቤን፣ እልማን ጋዲፊ ወለካን ጎሰ ምናሴ አኩመ ሙሴን እሳን አጀጄት ምአ ሎላ ህዸተኒ እስራኤሎተ ዱረ ገረ ገማት ጬአን። ");
INSERT INTO gaze_vpl VALUES ("JS4_13","007_4_13","JOS","4","13","13","ነምን ገረ ኩመ አፉርተማ ተኡ ወራናፍ ህዸቴ ፉለ ዋቀዮ ዱረ ገረ ድሬ ዬርኮት ሎላፍ ጬኤ። ");
INSERT INTO gaze_vpl VALUES ("JS4_14","007_4_14","JOS","4","14","14","ዋቀዮስ ጉያ ሰነ ፉለ እስራኤሎተ ሁንዳ ዱረት እያሱ ነመ ጉዳ ጎዼ፤ እሳንስ አኩመ ሙሴፍ ኡልፍነ ኬና ቱረን ሰነ በረ ጅሬኘሳ ጉቱ እያሱፍስ ኡልፍነ ኬነን። ");
INSERT INTO gaze_vpl VALUES ("JS4_15","007_4_15","JOS","4","15","15","ኤርገሲስ ዋቀዮ እያሱዻን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("JS4_16","007_4_16","JOS","4","16","16","“አከ እሳን ዮርዳኖስ ኬሳ ኦል በአኒፍ ሉቦተ ታቦተ ከኩ ሴራ ባተን ሰነ አጀጅ።” ");
INSERT INTO gaze_vpl VALUES ("JS4_17","007_4_17","JOS","4","17","17","ከናፉ እያሱን፣ “ዮርዳኖስ ኬሳ ኦል በኣ” ጄዼ ሉቦተ አጀጄ። ");
INSERT INTO gaze_vpl VALUES ("JS4_18","007_4_18","JOS","4","18","18","ሉቦትንስ ታቦተ ከኩ ዋቀዮ ባተኒ ለገ ኬሳ ኦል በአን። አኩመ እሳን ሚለሳኒ ለፈ ጎጋረ ዻበተኒን ብሻን ዮርዳኖስ እዶ ኦፊት ዴብኤ አኩመ ዱራኒ ጉቴ እረ ዸንገለኤ። ");
INSERT INTO gaze_vpl VALUES ("JS4_19","007_4_19","JOS","4","19","19","ጉያ ኩርነፋ ጅአ ጀልቀባት ነሞትን ዮርዳኖስ ኬሳ ኦል በአኒ ግልጋል እሰ በአ ዳሪ ዬርኮ ኬሰ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("JS4_20","007_4_20","JOS","4","20","20","እያሱንስ ዸጎተ ኩዸ ለማን እሳን ዮርዳኖስ ኬሳ ፉዸን ሰነ ግልጋል ኬሰ ዸዻቤ። ");
INSERT INTO gaze_vpl VALUES ("JS4_21","007_4_21","JOS","4","21","21","እንስ እስራኤሎታን አከነ ጄዼ፤ “ገረ ፉልዱራት ዮ ሰኚንኬሰን፣ ‘ዸጋወን ኩኔን ማል አርግሲሱ?’ ጄዸኒ አቦቲሳኒ ጋፈተን፣ ");
INSERT INTO gaze_vpl VALUES ("JS4_22","007_4_22","JOS","4","22","22","‘እስራኤል ለፈ ጎጋረ ዮርዳኖስ ጬኤ’ ጄዻ እት ህማ። ");
INSERT INTO gaze_vpl VALUES ("JS4_23","007_4_23","JOS","4","23","23","ዋቀዮ ዋቅንኬሰን ሀመ እስን ገመት ጬተንት ፉሉመኬሰን ዱረት ዮርዳኖስ ጎግሴ ቱሬቲ። ዋቀዮ ዋቅንኬሰን አኩመ ሀመ ኑ ጬኑት ገላነ ዲማ ፉለኬኘ ዱረት ጎግሴ ሰነ ዮርዳኖሲንስ ጎግሴ። ");
INSERT INTO gaze_vpl VALUES ("JS4_24","007_4_24","JOS","4","24","24","እንስ አከ ሰብን ለፋ ሁንድኑ አከ ሀርክ ዋቀዮ ጀባ ተኤ አርግሲሱፊ አከ እስንስ ዬሮ ሁንደ ዋቀዮ ዋቀኬሰን ሶዳተኒፍ ዋን ከነ ሆጄቴ።” ");
INSERT INTO gaze_vpl VALUES ("JS5_1","007_5_1","JOS","5","1","1","ሞቶትን አሞሮታ ከኔን ገመ ዽአ ዮርዳኖስ ጅራተኒፊ ሞቶትን ከነኣኖታ ከኔን ቀርቀረ ገላና ጅራተን ሁንድ አከ ዋቀዮ ሀመ ኑ ጬኑት ፉለ ሰበ እስራኤል ዱረት ዮርዳኖስ ጎግሴ ዮሙ ዸገአንት ኦኔንሳኒ ንበቅጤ፤ ዴብአኒስ ፉለ እስራኤሎታ ዱረ ዻበቹ ሶዳተን። ");
INSERT INTO gaze_vpl VALUES ("JS5_2","007_5_2","JOS","5","2","2","ዋቀዮ ዬሮ ሰነ እያሱዻን፣ “ሃዱ ቀረ ቀቡ ቶልቺቲ አመስ እስራኤሎተ ዸግነ ቀብ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS5_3","007_5_3","JOS","5","3","3","ከናፉ እያሱን ሃዱ ቀረ ቀቡ ቶልቼ ግቤኣት ኣረሎትት እስራኤሎተ ዸግነ ቀቤ። ");
INSERT INTO gaze_vpl VALUES ("JS5_4","007_5_4","JOS","5","4","4","ሰበቢን እያሱን ዋን ከነ ሆጄቴፍ ከነ፦ ወር ብየ ግብጢ በአኒ ዹፈን ሁንድኑ ጄቹንስ ዺሮትን ሎለን ሁንድኑ ኤርገ ግብጢ በአኒ ቦዴ ገሞጂ ኬሰት ከራት ዹመን። ");
INSERT INTO gaze_vpl VALUES ("JS5_5","007_5_5","JOS","5","5","5","ነሞትን ግብጢ በአን ሁንድ ዸግነ ቀበተኒ ቱረን፤ ወር ዬሮ ግብጢ በአኒ ገሞጂ ኬሰ ዴማ ቱረንት ከራት ዸለተን ገሩ ዸግነ ህንቀበምኔ። ");
INSERT INTO gaze_vpl VALUES ("JS5_6","007_5_6","JOS","5","6","6","እስራኤሎን ሰበቢ ዋቀዮፍ አጀጀሙ ድደኒፍ ሀመ ነሞትን ዬሮ ግብጢ በአንት ሎሉ ደንደአን ሁንድ ዹመንት ወጋ አፉርተመ ገሞጂ ኬሰ ጆረን። ዋቀዮ አከ እሳን ብየ እን ኑ ኬኑፍ አቦቲሳኒ አብደቺሴ ቱሬ፣ ብየ ኣነኒፊ ደመ ባፍቱ ሰነ ህንአርግኔ እሳንት ከከቴ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("JS5_7","007_5_7","JOS","5","7","7","ከናፉ እን ቆደሳኒ እልማንሳኒ ካሴ፤ እሳንስ ወረ እያሱን ዸግነ ቀቤዸ። እሳን ሰበቢ ከራት ዸግነ ህንቀበምኒፍ ሀመ ሀርኣት ኡቱ ዸግነ ህንቀበምን ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("JS5_8","007_5_8","JOS","5","8","8","እሳንስ ኤርገ ሰብን ጉቱን ዸግነ ቀበሜ ቦዴ ሀመ ፈየንት ለፉመ ጅረን ሰነ ቁበተ ኬሰ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS5_9","007_5_9","JOS","5","9","9","ዋቀዮስ እያሱዻን፣ “አን ሀርአ አረብሶ ግብጥ ሰነ እስንራ ገንገልቼረ” ጄዼ። ከናፉ እዶን ሱን ሀመ ሀርኣት ግልጋል ጄዸሜ ዋመመ። ");
INSERT INTO gaze_vpl VALUES ("JS5_10","007_5_10","JOS","5","10","10","ገልገለ ቡልቲ ኩዸ አፉረፋ ጅአ ሰናት ሰብን እስራኤል ኡቱመ ድሬ ዬርኮረ ግልጋል ኬሰ ቁበቴ ጅሩ ፋሲካ አያኔፈቴ። ");
INSERT INTO gaze_vpl VALUES ("JS5_11","007_5_11","JOS","5","11","11","እሳንስ ጉያ ፋሲካት ኣኔ ዹፉ፣ ጋፉመ ሰነ ምዻን ብየቲ ኬሳ ዋ ኛተን፤ ኩንስ መጥኖፊ አሼቲ ዋደሜዸ። ");
INSERT INTO gaze_vpl VALUES ("JS5_12","007_5_12","JOS","5","12","12","መናንስ ጉዩመ እሳን ምዻን ብየ ሰና ኛተንት ኣኑ ገድ ቡኡ ዺሴ፤ ኤርገሲ መናን ቶኮዩ ወረ እስራኤሊፍ ገድ ህንቡኔ፤ ገሩ እሳን ወጋ ሰነ ኬሰ ምዻን ብየ ከነኣን ኛተን። ");
INSERT INTO gaze_vpl VALUES ("JS5_13","007_5_13","JOS","5","13","13","እያሱን ዮሙ ዬርኮት ዽኣቴት፣ ኦል ምልአቴ ነመ ጎራዴ ሉቅፈሜ ሀርከት ቀበቴ እሰ ዱረ ዻበቱ ቶኮ አርጌ። እያሱን ገረሳ ዸቄ፣ “አት ገረኬኘሞ ገረ ዲኖተኬኛት?” ጄዼ እሰ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("JS5_14","007_5_14","JOS","5","14","14","እንስ ዴብሴ፣ “አን ገረ ኤኙዩ ምት፤ ገሩ አን አመ አከ አጀጃ ሎልቶተ ዋቀዮት ዹፌረ” ጄዼ። እያሱንስ አዳን ለፈት ጎምብፈሜ ሰገዴ፣ “ኤርጋን ጎፍታንኮ ገርብቸሳቲፍ ቀቡ ማል?” ጄዼ እሰ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("JS5_15","007_5_15","JOS","5","15","15","አጀጃን ሎልቶተ ዋቀዮስ እያሱዻን፣ “ሰበቢ እዶን አት ዻበቱ ኩን ቁልቁሉ ተኤፍ ኮጴኬ ኦፍራ ባስ” ጄዼ። እያሱንስ አከሱመ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("JS6_1","007_6_1","JOS","6","1","1","ዬሮ ሰነት ዬርኮን ሰበቢ እስራኤሎታቲፍ ጀቤፈምቴ ጩፈምቴ ቱርቴ። ነምን ቶኮዩ ገድ ህንበኡ፤ ነምን ቶኮዩስ ኦል ህንሴኑ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS6_2","007_6_2","JOS","6","2","2","ዋቀዮስ እያሱዻን አከነ ጄዼ፤ “ኩኖ አን ሞቲሼቲፊ ሎልቶተሼ ወጅን ዬርኮ ደበርሴ ሀርከኬት ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("JS6_3","007_6_3","JOS","6","3","3","ህዸቶተ ሁንደ ወጅን ዬሮ ቶኮ መጋለቲረ ናነኣ፤ ከነስ ቡልቲ ጀአ ሆጄዻ። ");
INSERT INTO gaze_vpl VALUES ("JS6_4","007_6_4","JOS","6","4","4","ሉቦትን ቶርበስ መለከተ ቶርበ ከኔን ጋንፈ ሆላራ ሆጄተመን ቀበተኒ ታቦተ ዱረ ሃዴመን። እስንስ ጉያ ቶርበፋት ዬሮ ቶርበ መጋለቲረ ነናነኣ፤ ሉቦትንስ መለከተ ሃአፉፈን። ");
INSERT INTO gaze_vpl VALUES ("JS6_5","007_6_5","JOS","6","5","5","ዮሙ እሳን ሰገሌ መለከታ ዼራሳ ዸጌስሰንት ነምን ሁንድኑ ሰገሌ ጉዳዻን ሃእዩ፤ ደላን መጋላ ሰና ዮሙሱመ ጅገ፤ ነሞትንስ ኦል በኡ፤ ነምን ሁንድኑስ ቀጄሌ እት ሴነ።” ");
INSERT INTO gaze_vpl VALUES ("JS6_6","007_6_6","JOS","6","6","6","ከናፉ እያሱን እልም ኑን ሉቦተ ኦፍት ዋሜ፣ “ታቦተ ከኩ ዋቀዮ ፉዻቲ ሉቦትን ቶርበ መለከተ ባተኒ እሰ ዱረ ሃዴመን” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JS6_7","007_6_7","JOS","6","7","7","ነሞታንስ፣ “ፉለ ዱረት ዴማቲ መጋላ ሰነረ ናነኣ፤ ሎልቶትን ህዸተንስ ታቦተ ዋቀዮ ዱረ ሃዴመን” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS6_8","007_6_8","JOS","6","8","8","ኤርገ እያሱን ነሞተት ዱበቴ ቦዴ፣ ሉቦትን ቶርበን ፉለ ዋቀዮ ዱረት መለከተ ቶርበ ባተን ሱን መለከተሳኒ አፉፋ ዱረ ደርበን፤ ታቦትን ከኩ ዋቀዮስ እሳን ዱካ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("JS6_9","007_6_9","JOS","6","9","9","ሎልቶትን ምአ ሎላ ህዸተንስ ሉቦተ መለከተ አፉፋ ቱረን ዱረ ዴመን፤ ሎልቶትን ዱግደ ዱባሞ ታቦትቸ ዱካ ቡአን። ዬሮ ከነ ሁንደስ መለከትን አፉፈማ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS6_10","007_6_10","JOS","6","10","10","እያሱን ገሩ ነሞታን፣ “እየ ሎላ ህንእይና፤ ሰገሌኬሰን ኦል ህንፉዸትና፤ ሀመ ጉያ አን እያ እስኒን ጄዹት ዱቢ ቶኮሌ ህንዱበትና። ጋፈስ እያ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS6_11","007_6_11","JOS","6","11","11","ከናፉ እን አከ ታቦትን ዋቀዮ ባተሜ መጋላ ሰነረ ዬሮ ቶኮ ናነኡ ጎዼ። ኤርገሲስ ነሞትን ገረ ቁበታት ዴብአኒ አች ቡለን። ");
INSERT INTO gaze_vpl VALUES ("JS6_12","007_6_12","JOS","6","12","12","እያሱን ጉያ እት ኣኑ ገነመ በሪ ከኤ፤ ሉቦትንስ ታቦተ ዋቀዮ ኦል ፉዸን። ");
INSERT INTO gaze_vpl VALUES ("JS6_13","007_6_13","JOS","6","13","13","ሉቦትን ቶርበን መለከተ ቶርበ ባተንስ ታቦተ ዋቀዮ ዱረ ዴማ መለከተስ አፉፋ ፉለ ዱረት ቀጄለን። ሎልቶትን ምአ ሎላ ህዸተን እሳን ዱረ ቡአን፤ ሎልቶትን ዱግደ ዱባሞ ታቦተ ዋቀዮ ዱካ ቡአን፤ መለከንስ እቱመ ፉፌ አፉፈማ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS6_14","007_6_14","JOS","6","14","14","ከናፉ ጉያ ለመፋት ዬሮ ቶኮ መጋለቲረ ናነአኒ ገረ ቁበታት ዴብአን። ከነስ ቡልቲ ጀአ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("JS6_15","007_6_15","JOS","6","15","15","ጉያ ቶርበፋት ገነመ በሪ ከአኒ ሃሉመ ዱራ ሰናን ዬሮ ቶርበ መጋለቲረ ናነአን፤ እሳን ጋፉመ ሰነ ቆፈ ዬሮ ቶርበ መጋለቲረ ናነአን። ");
INSERT INTO gaze_vpl VALUES ("JS6_16","007_6_16","JOS","6","16","16","መርሳ ቶርበፋት ዮሙ ሉቦትን መለከተ አፉፈንት እያሱን አከነ ጄዼ ነሞተ አጀጄ፤ “እያ! ዋቀዮ መጋለቲ እስኒ ኬኔራቲ! ");
INSERT INTO gaze_vpl VALUES ("JS6_17","007_6_17","JOS","6","17","17","መጋለቲፊ ወን እሼ ኬሰ ጅሩ ሁንድኑ ዋቀዮፍ አዳን ሃባፈመን። ሰበቢ እሼን በሳስቶተ ኑ ኤርገትኔ ሰነ ዾክስቴፍ፣ ረሃብ ሰጋገልትቲን ቆፍት ወረ መነሼ ኬሰ ጅረን ሁንደ ወጅን ሃበራረምቱ። ");
INSERT INTO gaze_vpl VALUES ("JS6_18","007_6_18","JOS","6","18","18","እስን ገሩ አከ እሳን ኬሳ ቶኮሌ ፉዸተኒ አከሲን በዲሰ ኦፍት ህንፍድኔፍ ዋን ለጉ ተኤራ ፈጋዻ። ዮ ከና አቺ እስን ቁበተ እስራኤሊትዩ በዲሰ ፍደኒ ረክነ እራን ጌሱ። ");
INSERT INTO gaze_vpl VALUES ("JS6_19","007_6_19","JOS","6","19","19","ሜቲፊ ወርቄን ሁንድ፣ ምእ ናሲቲፊ ስቢላ ሁንድ ሰበቢ ዋቀዮፍ ቁልቁሌፈመኒፍ መንኩሰሳት ገሉ ቀቡ።” ");
INSERT INTO gaze_vpl VALUES ("JS6_20","007_6_20","JOS","6","20","20","ዮሙ መለከትን አፉፈሜት ነሞትን ንእየን፤ ዮሙ ሰገሌን መለከተ ሰና ዸገአሜ ነሞትንስ ሰገሌ ጉዳዻን እየንት ደላን መጋላ ሰና ንኩፌ። ከናፉ ነምን ሁንድ ፉል ዱረት ግርሴ ሴኑዻን መጋላ ሰነ ቀበቴ። ");
INSERT INTO gaze_vpl VALUES ("JS6_21","007_6_21","JOS","6","21","21","እሳንስ ዋን መጋላ ሰነ ዋቀዮፍ አዳን ባሰኒፍ ዋን እሰ ኬሰ ጅሩ ሁንደ ጄቹንስ ዺራ ዱበርቲ፣ ጥና ጉዳ፣ ሎን፣ ሆሎታፊ ሀሮተ ጎራዴዻን ፍጠን። ");
INSERT INTO gaze_vpl VALUES ("JS6_22","007_6_22","JOS","6","22","22","እያሱንስ ነሞተ ለማን ብየ ሰነ በሳሰኒ ቱረኒን፣ “መነ ሰጋገልቱ ሰና ኦል ሴናቲ አኩመ እስን እሼፍ ከከተንት እሼፊ ወረ ከንሼ ተአን ሁንደ ገድ ባሳ ፍዳ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS6_23","007_6_23","JOS","6","23","23","ከናፉ ደርገጎትን በሳሱ ዸቀኒ ቱረን ሱን ኦል ሴነኒ ረሃብ፣ አባሼቲፊ ሃዸሼ፣ ኦቦሎተሼቲፊ ዋን ከንሼ ተኤ ሁንዱማ ገድ ባሰን። ማቲሼ ሁንደስ አለት ባሰኒ ቁበተ እስራኤሊቲን አለ እሳን ቱርሰን። ");
INSERT INTO gaze_vpl VALUES ("JS6_24","007_6_24","JOS","6","24","24","ኤርገሲ ጉቱማ መጋላ ሰናቲፊ ዋን እሼ ኬሰ ጅሩ ሁንደ ጉበን፤ ገሩ ሜቲፊ ወርቄ፣ ምአ ናሲቲፊ ስቢላ መንኩሰ መነ ዋቀዮት ገልቸን። ");
INSERT INTO gaze_vpl VALUES ("JS6_25","007_6_25","JOS","6","25","25","እያሱን ገሩ ሰበቢ እሼን ነሞተ እን አከ በሳሰኒፍ ገረ ዬርኮት ኤርጌ ቱሬ ሰነ ዾክስቴፍ ረሃብ ሰጋገልቱ ሰነ ማቲሼቲፊ ዋን ከንሼ ተኤ ሁንደ ወጅን ንበራሬ፤ እሼንስ ሀመ አማት እስራኤሎተ ግዱ ጅራት። ");
INSERT INTO gaze_vpl VALUES ("JS6_26","007_6_26","JOS","6","26","26","እያሱንስ ዬሮ ሰነት አከነ ጄዼ ከከቴ፤ “ነምን መጋላ ዬርኮ ከነ ዴብሴ እጃሩ ፉለ ዋቀዮ ዱረት አባረማ ሃተኡ፦ “እን ሁንዴ እሼ ቡስናን፣ እልምሳ ሀንገፍት ሃዱኡ፤ ከረሼ እጃሩ ጀልቀብናን፣ እልምሳ ቁጥሱን ሃዱኡ።” ");
INSERT INTO gaze_vpl VALUES ("JS6_27","007_6_27","JOS","6","27","27","ከናፉ ዋቀዮ እያሱ ወጅን ቱሬ፤ መቃንሳስ ጉቱማ ብየቲ ኬሰት ቤከሜ። ");
INSERT INTO gaze_vpl VALUES ("JS7_1","007_7_1","JOS","7","1","1","እስራኤሎን ገሩ ዋን ዋቀዮፍ አዳን ባፈሜረት አመነሙማ ዸበን፤ ኣካን እልም ከርሚ፣ እልም ዘብዲ፣ እልም ዛራ ከን ጎሰ ይሁዳ ዋን ዋቀዮፍ አዳን ባፈሜ ሰነ ኬሳ ዋን ቶኮ ቶኮ ፉዸቴ። ከናፍስ ዼከምስ ዋቀዮ እስራኤልረት ቦበኤ። ");
INSERT INTO gaze_vpl VALUES ("JS7_2","007_7_2","JOS","7","2","2","ከነረት እያሱን ዬርኮዻ ገረ ኣይ ከን ቤት ኣዌን ብረ ገመ በአ ቤትኤልት አርገምቱ ሰናት ነመ ኤርጌ፣ “ዸቃቲ ናኖ ሰነ በሳሳ” ጄዼ። ከናፉ ነሞትን ኦል በአኒ ኣይን በሳሰን። ");
INSERT INTO gaze_vpl VALUES ("JS7_3","007_7_3","JOS","7","3","3","እሳንስ ገረ እያሱት ዴብአኒ፣ “ነምን ሁንድኑ ኣይት ኦል በኡ ህንቀቡ። ሰበቢ ነምን ሙራስን ቆፍት አች ጅሩፍ አከ እሳን ዸቀኒ ብየቲ ፉዸተኒፍ ነመ ኩመ ለመ ዮካን ኩመ ሰዲ ተኡ ኤርግ መሌ ነሞተ ሁንዱማ ህንደዸብሲስን” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("JS7_4","007_7_4","JOS","7","4","4","ከናፉ ነሞትን ገረ ኩመ ሰዲ ተአን ከአኒ ኦል በአን፤ እሳን ገሩ ነሞተ ኣይ ዱራ በቀተን፤ ");
INSERT INTO gaze_vpl VALUES ("JS7_5","007_7_5","JOS","7","5","5","ነሞትን ኣይስ ገረ ነመ ሶዶሚ ጀአ እሳን ጀላ ፍጠን። እሳንስ ከረ መጋለቲቲ ጀልቀበኒ ሀመ ሸባሪሚት እስራኤሎተ አርአኒ ኤዴደረት እሳን ፍጠን፤ ከናንስ ኦኔን ነሞታ በቅጤ አከ ብሻኒ ታቴ። ");
INSERT INTO gaze_vpl VALUES ("JS7_6","007_7_6","JOS","7","6","6","እያሱንስ ኡፈተሳ ተርሳሴ ፉለ ታቦተ ዋቀዮ ዱረት አዳን ለፈት ጎምብፈሜ ሀመ ገልገላት አቹመ ቱሬ። ማንጉዶትን ሰበ እስራኤልስ አከሱመ ጎዸኒ መታ ኦፊሳኒረት አዋረ ፍርፍርሰን። ");
INSERT INTO gaze_vpl VALUES ("JS7_7","007_7_7","JOS","7","7","7","እያሱንስ አከነ ጄዼ፤ “ያ ዋቀዮ ጎፍታ፣ አት ማሊፍ አከ እሳን ኑ ፍጠኒፍ ሀርከ አሞሮታት ኑ ኬኑፍ ጄቴ ሰበ ከነ ዮርዳኖሲን ጬስፍቴ? ስላ ኡቱ ዮርዳኖስ ገመት ሀፍኔ ኑፍ ወየ ቱሬ! ");
INSERT INTO gaze_vpl VALUES ("JS7_8","007_7_8","JOS","7","8","8","ያ ጎፍታ፣ ኤርገ ሰብን እስራኤል ዲኖተሳ በቀቴ አን አመ ማል ጄቹን ደንደአ? ");
INSERT INTO gaze_vpl VALUES ("JS7_9","007_7_9","JOS","7","9","9","ከነኣኖትኒፊ ሰቦትን ብየ ከና ከን ብራ ዋን ከነ ዸገአኒ ኑ መርሰኒ መቃኬኘ ለፈራ ንበሌሱ። ዮስ አት መቃኬ ጉዳ ሰናፍ ማል ጎተ?” ");
INSERT INTO gaze_vpl VALUES ("JS7_10","007_7_10","JOS","7","10","10","ዋቀዮስ እያሱዻን አከነ ጄዼ፤ “ኦል ከእ! አት ማሊፍ አዳን ጎምብፈምቴ? ");
INSERT INTO gaze_vpl VALUES ("JS7_11","007_7_11","JOS","7","11","11","እስራኤል ጩቡ ሆጄቴረ፤ እሳን ከኩኮ ከን አን አከ እሳን ኤገኒፍ እሳን አጀጄ ሰነ ጨብሰኒሩ። እሳን ዋን አዳን ና ባፈሜ ኬሳ ዋን ቶኮ ቶኮ ፉዸተኒሩ፤ ሀተኒሩ፤ ሶበኒሩ፤ ዋን ሰነስ ቀቤኘሳኒ ወጅን ኦል ካአተኒሩ። ");
INSERT INTO gaze_vpl VALUES ("JS7_12","007_7_12","JOS","7","12","12","ወን እስራኤሎን ዲኖተሳኒ ዱረ ዻበቹ ህንደንዴኜፍስ ከኑመ፤ እሳን ሰበቢ በዲሳፍ ረመደመኒፍ ዱግደ ዱበት ገረ ገለኒ ዲኖተሳኒ በቀተን። አን ሀመ አት ዋን በዲሳፍ አጀጀሜ ከምዩ ግዱኬሰኒ በሌስቱት ስአች እስን ወጅን ህንጅራዹ። ");
INSERT INTO gaze_vpl VALUES ("JS7_13","007_7_13","JOS","7","13","13","“ከኢቲ ሰበ ቁልቁሌስ። አከነስ እሳኒን ጄዽ፤ ‘ቦሪፍ ኦፍ ቁልቁሌሳ፤ ወን ዋቀዮ ዋቅን እስራኤል ጄዹ እሰ ከናቲ፤ ያ እስራኤል፣ ወን ህርሚ ተኤ ቶኮ ግዱኬሰን ጅረ። እስን ሀመ ዋን ሰነ ኦፍ ኬሳ ባፍተንት ዲኖተኬሰን ኦፍራ እትሱ ህንደንዴሰን። ");
INSERT INTO gaze_vpl VALUES ("JS7_14","007_7_14","JOS","7","14","14","“ ‘ከናፉ ገነመ ጎሰ ጎሳን ኦፍ ዽኤሳ። ጎስት ዋቀዮ ፍለቱ በልበለ በልበላን ገረ ፉለ ዱራት ሃበኡ፤ በልበል ዋቀዮ ፍለቱስ ማቲ ማቲዻን ገረ ፉለ ዱራት ሃበኡ፤ ማቲን ዋቀዮ ፍለቱስ ነመ ቶኮ ቶኮን ገረ ፉለ ዱራት ሃበኡ። ");
INSERT INTO gaze_vpl VALUES ("JS7_15","007_7_15","JOS","7","15","15","ነምን ዋን በሌፈሙ ቀቡ ወጅን ቀበሜ፣ ዋን ቀቡ ሁንዱማ ወጅን እብዳን ሃጉበሙ። እን ከኩ ዋቀዮ ጨብሴረ፤ ዋን እስራኤል ኬሰት ቃኒ ተኤስ ሆጄቴረ!’ ” ");
INSERT INTO gaze_vpl VALUES ("JS7_16","007_7_16","JOS","7","16","16","ከናፉ እያሱን ገነመ በሪን ከኤ ሰበ እስራኤል ጎሰ ጎሳን ገረ ፉለ ዱራት ባሴ፤ ጎስት ይሁዳስ ንፍለተሜ። ");
INSERT INTO gaze_vpl VALUES ("JS7_17","007_7_17","JOS","7","17","17","በልበል ይሁዳ ገረ ፉለ ዱራት በኤ፤ እያሱንስ በልበለ ዛራ አዳን ባሴ። በልበል ዛራስ ማቲ ማቲን ገረ ፉለ ዱራት በኤ፤ ዘብዲንስ ንፍለተሜ። ");
INSERT INTO gaze_vpl VALUES ("JS7_18","007_7_18","JOS","7","18","18","እያሱንስ ማቲሳ ነመ ቶኮ ቶኮን ገረ ፉለ ዱረት ባሴ፤ ኣካን እልም ከርሚ፣ እልም ዘብዲ፣ እልም ዛራ ከን ጎሰ ይሁዳ ንፍለተሜ። ");
INSERT INTO gaze_vpl VALUES ("JS7_19","007_7_19","JOS","7","19","19","ከነረት እያሱን ኣካኒን አከነ ጄዼ፤ “ያ እልመኮ፣ ዋቀዮ ዋቀ እስራኤሊፍ ኡልፍነ ኬን፤ ጩቡኬስ እሰት ህመዹ፤ ሜ ዋን ሆጄቴ ነት ህም፤ ነ ህንዾክስን።” ");
INSERT INTO gaze_vpl VALUES ("JS7_20","007_7_20","JOS","7","20","20","ኣካንስ አከነ ጄዼ ዴብሴ፤ “ወን ኩን ዹጋዸ! አን ዋቀዮ ዋቀ እስራኤልት ጩቡ ሆጄዼረ። ወን አን ሆጄዼስ ኩኖ ከነ፦ ");
INSERT INTO gaze_vpl VALUES ("JS7_21","007_7_21","JOS","7","21","21","አን ዋን ባብሎኒ ቦጅአሜ ኬሳ ዋሮ በሬዳ ቶኮ፣ ሜቲ ሰቅሊ ዽበ ለማፊ ወርቄ ሰቅሊ ሸንተመ ኡልፋቱ አርግናን ከጄሌ ፉዸዼረ። ምእ ኩንስ ዱንካነኮ ኬሰት ሜቲ ጀለ ለፈ ኬሰት ዾክፈሜረ።” ");
INSERT INTO gaze_vpl VALUES ("JS7_22","007_7_22","JOS","7","22","22","ከናፉ እያሱን ኤርገሞተ ኤርጌ፤ እሳንስ ገረ ዱንካነ ሰናት ፊገን፤ ምእ ሱንስ ዱንካንቸ ኬሰት፣ ሜቲ ጀለ ዾክፈሜ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS7_23","007_7_23","JOS","7","23","23","እሳን ምአ ሰነ ዱንካንቸ ኬሳ ጉረኒ ገረ እያሱቲፊ እስራኤሎተ ሁንዳት ፍደኒ ፉለ ዋቀዮ ዱረት ድሪርሰን። ");
INSERT INTO gaze_vpl VALUES ("JS7_24","007_7_24","JOS","7","24","24","ኤርገሲስ እያሱፊ እስራኤሎን ሁንድ ኣካን እልመ ዛራ፣ ሜቲ፣ ዋሮ፣ ሙራ ወርቄ፣ እልማንሳቲፊ እንተለንሳ፣ ሎንሳ፣ ሀሮተሳ፣ ሆሎተሳ፣ ዱንካነሳቲፊ ዋን እን ቀቡ ሁንደ ጉረኒ ሱሉለ ኣኮርት ጌሰን። ");
INSERT INTO gaze_vpl VALUES ("JS7_25","007_7_25","JOS","7","25","25","እያሱንስ፣ “አት ማሊፍ ረክነ ከነ ሁንደ ኑት ፍዴ? ዋቀዮ ሀርአ ረክነ ስት ፍደ” ጄዼን። እስራኤሎን ሁንድኑስ ዸጋዻን እሰ ቱመን፤ ጀረ ካንሌ ኤርገ ዸጋዻን ቱመኒ ቦዴ እብዳን እሳን ጉበን። ");
INSERT INTO gaze_vpl VALUES ("JS7_26","007_7_26","JOS","7","26","26","ኣካንረት ቱላ ዸጋ ጉዳ ሀመ ሀርኣትሌ ጅሩ ቶኮ ቱለን። ዋቀዮስ ዼከምሰሳ ጉዳ ሰነራ ዴብኤ። ከናፍስ እዶን ሱን ሀመ ሀርኣት ሱሉለ ኣኮር ጄዸሜ ዋመመ። ");
INSERT INTO gaze_vpl VALUES ("JS8_1","007_8_1","JOS","8","1","1","ኤርገሲስ ዋቀዮ እያሱዻን አከነ ጄዼ፤ “ህንሶዳትን ዮካን አብዲ ህንኩተትን። ሎልቶተ ሁንደ ፉዸዹቲ ኦል በኢ መጋላ ኣይ ሎል። አን ኩኖ ሞቲ ኣይ፣ ነመሳ፣ መጋላሳቲፊ ብየሳ ሀርከኬት ደበርሴ ኬኔራቲ። ");
INSERT INTO gaze_vpl VALUES ("JS8_2","007_8_2","JOS","8","2","2","አኩመ ዬርኮፊ ሞቲሼ ጎቴ ሰነ፣ ኣዪፊ ሞቲሼሌ ጎተ፤ ዬሮ ከነ ገሩ ቦጁፊ ሆሪሼ ኦፊኬሰኒ ፉዸቹ ደንዴሱ። ነመ ርጴ መጋለቲ ኤጉ ከራ ዱባቲን ካእ።” ");
INSERT INTO gaze_vpl VALUES ("JS8_3","007_8_3","JOS","8","3","3","እያሱፊ ሎልቶትን ሁንድኑስ ከአኒ ኣይን ሎሉፍ በአን። እንስ ሎልቶተሳ ወረ ጀጀቦ ኬሳ ነመ ኩመ ሶዶመ ፍለቴ ሀልከኒን ኤርጌ፤ ");
INSERT INTO gaze_vpl VALUES ("JS8_4","007_8_4","JOS","8","4","4","አከነስ ጄዼ እሳን አጀጄ፦ “ሜ ቀልቢዻን ነ ዸገኣ። እስን ቦሮ መጋላት ርጵጡ። ጉድፍተኒራ ህንፈጋትና። ሁንድኬሰን ቆጳኣ። ");
INSERT INTO gaze_vpl VALUES ("JS8_5","007_8_5","JOS","8","5","5","አኒፊ ወር ነ ወጅን ጅረን ሁንድ መጋላ ሰነት ዽኣትነ፤ ዮሙ ነሞትን አኩመ ዱራ ሰነ ፉለ ዱራን ኑት ዹፈን ኑ እሳን ዱራ በቀትነ። ");
INSERT INTO gaze_vpl VALUES ("JS8_6","007_8_6","JOS","8","6","6","እሳንስ ሰበቢ፣ ‘ጀር ኩን አኩመ ዱራ ሰነ ኑ በቀቻ ጅሩ’ ኑን ጄዸኒፍ፣ ሀመ ኑ መጋላ ሰነራ እሳን ፈጌስኑት ኑ ዱካ ቡኡ። ከናፉ ዮሙ ኑ እሳን በቀኑት፣ ");
INSERT INTO gaze_vpl VALUES ("JS8_7","007_8_7","JOS","8","7","7","እስንሞ እዶ እት ርጵጠኒ ካተኒ መጋላ ሰነ ቀበቱ። ዋቀዮ ዋቅንኬሰንስ መጋላ ሰነ ሀርከኬሰንት ደበርሴ ንኬነ። ");
INSERT INTO gaze_vpl VALUES ("JS8_8","007_8_8","JOS","8","8","8","እስን ዮሙ መጋላ ሰነ ቀበተንት እብደ እት ቀብሲሳ። ዋን ከነስ አኩመ ዋቀዮ አጀጄት ሆጄዻ። ኩኖ አን እስን አጀጄረ።” ");
INSERT INTO gaze_vpl VALUES ("JS8_9","007_8_9","JOS","8","9","9","ኤርገሲ እያሱን እሳን ኤርጌ፤ እሳንስ ገረ እዶ እት ርጰን ከን ገመ በአ ኣይቲን ቤትኤሊፊ ኣይ ግዱ ጅሩ ሰና ዸቀን፤ እያሱን ገሩ ሀልከን ሰነ ኡመተ ወጅን ቡሌ። ");
INSERT INTO gaze_vpl VALUES ("JS8_10","007_8_10","JOS","8","10","10","ጉያ እት ኣኑ ገነመ በሪ እያሱን ነሞተ ኦፊሳ ወልት ቀበቴ እኒፊ ማንጉዶትን እስራኤል ነሞተ ዱረ ኣይት ኦል ቀጄለን። ");
INSERT INTO gaze_vpl VALUES ("JS8_11","007_8_11","JOS","8","11","11","ሎልቶትን እሰ ወጅን ቱረን ሁንድኑ ኦል በአኒ ፉለ ዱራን መጋለቲት ዽኣተኒ ከራ ካበ ኣይቲን ቁበተን። ሱሉል ቶኮስ እሳኒፊ መጋለቲ ግዱት አርገመ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS8_12","007_8_12","JOS","8","12","12","እያሱን ነመ ገረ ኩመ ሸን ፉዸቴ ገመ ልጠ መጋለቲቲን ቤትኤሊፊ ኣይ ግዱት ርጵሲሴ። ");
INSERT INTO gaze_vpl VALUES ("JS8_13","007_8_13","JOS","8","13","13","እሳንስ ነሞተ፣ ጄቹንስ ሎልቶተ ገመ ካበ መጋለቲቲን ቱረን ሁንዳፊ ወረ ዱግደ ዱባን ገመ ልጣቲን ርጰኒ ቱረን እዶ እዶሳኒ ቀብሲሰን። እያሱን ገሩ ገረ ሱሉላት ገድ ቡኤ ሀልከን ሰነ አች ቡሌ። ");
INSERT INTO gaze_vpl VALUES ("JS8_14","007_8_14","JOS","8","14","14","ሞቲን ኣይ ዮሙ ዋን ከነ አርጌት፣ እኒፊ ነሞትን መጋላ ሰና ሁንድኑ እዶ አረባን ኦሊ ቶኮት እስራኤሎታን ወል ወራኑፍ ገነመ በሪን አሪፈተኒ በአን። እን ገሩ አከ ወራን ርጴ ዱግደ መጋላ ሰና ዱባን እሰ ኤገቱ ህንቤክኔ። ");
INSERT INTO gaze_vpl VALUES ("JS8_15","007_8_15","JOS","8","15","15","እያሱፊ እስራኤሎን ሁንድ ዋን አርአመን ኦፍ ፈኬሰኒ ዱግደ ዱበት ዴብአኒ ፉለሳኒ ዱረ ገረ ገሞጂት በቀተን። ");
INSERT INTO gaze_vpl VALUES ("JS8_16","007_8_16","JOS","8","16","16","ነሞትን ኣይ ሁንድኑስ አከ እስራኤሎተ አርአኒፍ ወልት ዋመመን፤ እሳንስ እያሱ ፋነ ቡአኒ አከሲን መጋለቲራ ፈጌፈመን። ");
INSERT INTO gaze_vpl VALUES ("JS8_17","007_8_17","JOS","8","17","17","ነምን እስራኤሎተ ፋነ ቡኤ አርኡፍ ህንበእን ቶኮዩ ኣይ ዮካን ቤትኤል ኬሰት ህንሀፍኔ። መጋለቲስ ኤጉምሰ መሌ ሀምብሰኒ እስራኤሎተ አርኡፍ በአን። ");
INSERT INTO gaze_vpl VALUES ("JS8_18","007_8_18","JOS","8","18","18","ዋቀዮስ እያሱዻን፣ “ሰበቢ አን መጋለቲ ሀርከኬት ደበርሴ ኬኑፍ፣ ኤቦ ሀርካ ቀብዱ ገረ ኣይት ዴብፈዹ” ጄዼ። ከናፉ እያሱን ኤቦሳ ገረ ኣይት ዴብፈቴ። ");
INSERT INTO gaze_vpl VALUES ("JS8_19","007_8_19","JOS","8","19","19","አኩመ እን ዋን ከነ ጎዼን ወር ርጰኒ ኤገቻ ቱረን ሱን ደፈኒ እዶሳኒቲ ከአኒ ፉል ዱረት ፊገን። እሳንስ መጋለቲ ሴነኒ ቀበተን፤ ደፈኒስ እብደ እት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("JS8_20","007_8_20","JOS","8","20","20","ነሞትን ኣይ ዮሙ ገረ ገለኒ ኦፍ ዱበ እላለንት ኣረ መጋለቲ ከን ሰሚት ኦል ከኡ አርገን፤ ገሩ ሰበቢ እስራኤሎን ዱራን ገረ ገሞጂት በቀተን ሱን አመ ወረ እሳን አርኣ ጅረንት ገረገለኒፍ፣ ጀር ኤሱመቱ በቀቹፍ ጨራ ቶኮሌ ህንአርገኔ። ");
INSERT INTO gaze_vpl VALUES ("JS8_21","007_8_21","JOS","8","21","21","እያሱፊ እስራኤሎን ሁንድኑ ዮሙ አከ ወር ርጴ ኤገቻ ቱሬ ሱን መጋለቲ ቀበቴፊ አከ ኣር መጋለቲራ ከኡ አርገንት ኦፍረ ገረ ገለኒ ነሞተ ኣይ ዸአን። ");
INSERT INTO gaze_vpl VALUES ("JS8_22","007_8_22","JOS","8","22","22","ነሞትን ርጰኒ ቱረንስ መጋላዻ በአኒ እሳንት ዹፈን፤ ከናፉ እስራኤሎን ገመና ገመሲን እሳን መርሰኒ ጀር እስራኤሎተ ግዱት ቀበመን። እስራኤሎንስ አከ ነምን ቶኮዩ ህንሀፍኔፍ ዮካን በቀቴ ህንምልቅኔፍ እሳን ፍጠን። ");
INSERT INTO gaze_vpl VALUES ("JS8_23","007_8_23","JOS","8","23","23","ሞቲ ኣይ ገሩ ሉቡዹማን ቀበኒ እያሱት ፍደን። ");
INSERT INTO gaze_vpl VALUES ("JS8_24","007_8_24","JOS","8","24","24","እስራኤሎን ዮሙ ዺሮተ ኣይ ሁንደ ድሬፊ ገሞጂ ጀር እት እስራኤሎተ አርአን ሰነት ቀለኒ እሳን ፍጠንት፣ እስራኤሎን ሁንድኑ ገረ ኣይት ደቸአኒ ወረ አችት ሀፌስ ጎራዴዻን በርበዴሰን። ");
INSERT INTO gaze_vpl VALUES ("JS8_25","007_8_25","JOS","8","25","25","ነሞትን ኣይ ከኔን ጋፈስ ዹመን ዺራ ዱበርቲን ኩመ ኩዸ ለመ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS8_26","007_8_26","JOS","8","26","26","እያሱን ሀመ ነሞተ ኣይ ኬሰ ጅራተን ሁንደ ፍጡት ሀርከሳ ከን ድሪርፈቴ እቲን ኤቦ ቀበቴ ሰነ ህንደቻፈትኔ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("JS8_27","007_8_27","JOS","8","27","27","እስራኤል ገሩ አኩመ ዋቀዮ እያሱ አጀጄት ሆሪፊ ቦጁ መጋለቲ ቆፈ ፉዸቴ። ");
INSERT INTO gaze_vpl VALUES ("JS8_28","007_8_28","JOS","8","28","28","አከስት እያሱን ኣይን ጉቤ ቱላ ዳራ ጎዼ ሀምብሴ፤ ሀመ ሀርኣትስ እሼን አኩመ በርበዶፍቴት ጅርት። ");
INSERT INTO gaze_vpl VALUES ("JS8_29","007_8_29","JOS","8","29","29","እንስ ሞቲ ኣይ ሙከረት ፈንሴ ሀመ ቢፍቱን ልጡት አቹመት እሰ ዺሴ። እያሱን ዮሙ አዱን ዺቴት አከ እሳን ሬፈሳ ሙከራ ገድ ቡሰኒ ከረ መጋለቲ ዱረት ደርበተን እሳን አጀጄ። እሳንስ ቱላ ዸጋ ጉዳ ሀመ ሀርኣትስ ጅሩ ሬፈ ሰነረት ቱለን። ");
INSERT INTO gaze_vpl VALUES ("JS8_30","007_8_30","JOS","8","30","30","ኤርገሲ እያሱን ቱሉ ኤባልረት ዋቀዮ ዋቀ እስራኤሊፍ እዶ ኣርሳ እጃሬ። ");
INSERT INTO gaze_vpl VALUES ("JS8_31","007_8_31","JOS","8","31","31","እዶ ኣርሳ ከነስ አኩመ ሙሴን ገርብች ዋቀዮ እስራኤሎተ አጀጄ ሰነት ሆጄቴ። እንስ አኩመ ክታበ ሴረ ሙሴ ኬሰት በሬፈሜት ዸጋ ህንሶፈምን ከን ስቢል ህንቱቅኒን ሆጄቴ፤ እሰረትስ ኣርሳ ጉበሙ ዽኤሰኒ ኣርሳ ነጋስ ዋቀዮፍ ቀለን። ");
INSERT INTO gaze_vpl VALUES ("JS8_32","007_8_32","JOS","8","32","32","እያሱንስ አቹመት ፉለ እስራኤሎታ ዱረት፣ ሴረ ሙሴን በሬሴ ቱሬ ሰነ ዸጋረት ገረገልቼ። ");
INSERT INTO gaze_vpl VALUES ("JS8_33","007_8_33","JOS","8","33","33","እስራኤሎን ሁንድኑ፣ አለጋፊ ዸለታን ብያ፣ ማንጉዶተሳኒ ወጅን፣ አጀጆተ ሎልቶታቲፊ አቦቲ ሴራ ወጅን፣ ሌዎተ ሉቦተ ተአን ከኔን ታቦተ ከኩ ዋቀዮ ባተን ሰነት ፉለ ዴብፈተኒ ብታ ምርጋን ዸዻበተን። አኩመ ሙሴን ገርብች ዋቀዮ አከ እሳን ሰበ እስራኤል ኤብሰኒፍ ጀልቀበት እሳን አጀጄ ሰነት ወለካንሳኒ ቱሉ ጌርዚም ዱረ ዸዻበተኒ ወለካንሳኒሞ ቱሉ ኤባል ዱረ ዸዻበተን። ");
INSERT INTO gaze_vpl VALUES ("JS8_34","007_8_34","JOS","8","34","34","ኤርገሲስ እያሱን አኩመ ክታበ ሴራ ኬሰት በሬፈሜት ዱቢ ሴራ ሁንደ ከን ኤባቲፊ ከን አባርሳ ንዱብሴ። ");
INSERT INTO gaze_vpl VALUES ("JS8_35","007_8_35","JOS","8","35","35","ዱቢ ሙሴን እሰ አጀጄ ሁንደ ኬሳ ወን እያሱን ወልዳ እስራኤል ሁንዳፍ አከሱመስ ዱበርቶታፍ፣ ዳእመኒፊ አለጎተ ግዱሳኒ ጅራተኒፍ ኡቱ ህንዱብስን ብረ ደርቤ ቶኮዩ ህንቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS9_1","007_9_1","JOS","9","1","1","ሞቶትን ሄቶታ፣ አሞሮታ፣ ከነኣኖታ፣ ፌርዞታ፣ ሂዎታቲፊ ዬቡሶታ ከኔን ገመ ልጠ ዮርዳኖስ ብየ ጋራ፣ ለፈ ገሞጂቲፊ ቀርቀረ ገላነ ጉድቻ ከን ሀመ ልባኖንት ጅሩ ኬሰ ጅራተን ዮሙ ዋን ከነ ዸገአንት፣ ");
INSERT INTO gaze_vpl VALUES ("JS9_2","007_9_2","JOS","9","2","2","እያሱፊ እስራኤልት ወራነ በኑፍ ወልት ቀበመን። ");
INSERT INTO gaze_vpl VALUES ("JS9_3","007_9_3","JOS","9","3","3","ነሞትን ግቤኦን ገሩ ዮሙ ዋን እያሱን ዬርኮፊ ኣይ ጎዼ ዸገአንት፣ ");
INSERT INTO gaze_vpl VALUES ("JS9_4","007_9_4","JOS","9","4","4","እሳንስ ገመሳኒቲን ደበ ሆጄቹፍ መርአተን፤ እሳንስ ነመ ከራ ዴሙ ፈካተኒ ኬሻ ሞፈኤፊ ቀልቀሎ ዳዺ ወይኒ ከን ዱሎሜ ተርሰኤ ኤርበሜ ሀሬሳኒት ፌአተኒ ቀጄለን። ");
INSERT INTO gaze_vpl VALUES ("JS9_5","007_9_5","JOS","9","5","5","ኮጴ ሞፈኤ ኤርበሜ ሚለት ካአተኒ ወያ ሞፈኤ ኡፈተን። ቡዴን እሳን ፉዸተኒ ዴመን ሁንድስ ጎጎጋፊ ከን አራኤ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS9_6","007_9_6","JOS","9","6","6","እሳንስ ቁበተ ግልጋልት እያሱ ብረ ዸቀኒ እሳፊ ነሞተ እስራኤሊን፣ “ኑ ብየ ፈጎዻ ዹፍኔ፤ ከናፉ ኮታ ወሊ ገልቴ ጎዸትና” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JS9_7","007_9_7","JOS","9","7","7","ነሞትን እስራኤልሞ ሂዎታን፣ “ተሪ እስን አሱመ ኑት ዽኦ ጅራቱ ተአ፤ ዮስ ኑ አከሚን እስን ወጅን ወሊ ገልቴ ጎዸቹ ደንዴኘሬ?” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JS9_8","007_9_8","JOS","9","8","8","እሳን ገሩ እያሱዻን፣ “ኑ ገርቦተኬት” ጄዸን። እያሱንስ፣ “እስን ኤኙዸ? ኤሳ ዹፍተን?” ጄዼ እሳን ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("JS9_9","007_9_9","JOS","9","9","9","እሳንስ አከነ ጄዸኒ ዴብሰኒፍ፤ “ኑ ገርቦንኬ ሰበቢ መቃ ዋቀዮ ዋቀኬቲ ዸጌኜፍ ብየ አከ መሌ ፈጎቲ ዹፍኔ። ኑ ኦዱ ዋኤሳቲፊ ዋን እን ብየ ግብጢ ኬሰት ሆጄቴ ሁንዱማ ዸጌኜራቲ፤ ");
INSERT INTO gaze_vpl VALUES ("JS9_10","007_9_10","JOS","9","10","10","ዋን እን ሞቶተ አሞሮታ ለማን ወረ ገመ በአ ዮርዳኖስ ጅራተን ጄቹንስ ስሆን ሞቲ ሄሽቦኒፊ ኦግ ሞቲ ባሻን ከን አሽታሮት ቡልቻ ቱሬ ሰነ ጎዼ ሁንዱማ ዸጌኜረ። ");
INSERT INTO gaze_vpl VALUES ("JS9_11","007_9_11","JOS","9","11","11","ማንጉዶትንኬኛፊ ጅራቶትን ብየኬኛ ሁንድኑ፣ ‘ከራኬሰኒፍ ዋን ኛተን ሀርከት ቀበዻቲ እሳን አርጉ ዸቃ፣ “ኑ ገርቦተኬሰኒዸ፤ ከናፉ ኮታ ወሊ ገልቴ ጎዸትና” ጄዻኒ’ ኑን ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JS9_12","007_9_12","JOS","9","12","12","ቡዴንኬኘ ኩን ጋፈ ኑ ህዸትኔ ገረኬሰን ዹፉፍ መና ባኔ ሆኣ ቱሬ። አመ ገሩ አከ እን ጎጎጌ አራኤ አርጋ። ");
INSERT INTO gaze_vpl VALUES ("JS9_13","007_9_13","JOS","9","13","13","ቀልቀሎን ኑ ዳዺ ወይኒ እት ጉተትኔ ኩንስ ሃራ ቱሬ፤ አመ ገሩ አከ እን ተተርሰኤ እላላ። ኡፈትንኬኛፊ ኮጴንኬኘስ ዴምሰ ከራ ዼራ ከናን ኑ ጀላ ዹሜረ።” ");
INSERT INTO gaze_vpl VALUES ("JS9_14","007_9_14","JOS","9","14","14","ነሞትን እስራኤል ገላሳኒራ ዋ ፉዸተን መሌ ዋቀዮን ጎርሰ ህንጋፈኔ። ");
INSERT INTO gaze_vpl VALUES ("JS9_15","007_9_15","JOS","9","15","15","እያሱንስ አከ እሳን ጅራተኒፍ እሳን ወጅን ወሊ ገልቴ ነጋ ጎዼ፤ ሆገንቶትን ወልዳስ ዋን ከነ ከኩዻን ምርከኔሰን። ");
INSERT INTO gaze_vpl VALUES ("JS9_16","007_9_16","JOS","9","16","16","ወር እስራኤልሞ ኤርገ ግቤኦኖተ ወጅን ወሊ ገልቴ ጎዸተን ጉያ ሰዲ ቦዴ አከ ጀር ወረ ናኖሳኒ ከኔን እሳንት ዽኦ ጅራተን ተአን ዸገአን። ");
INSERT INTO gaze_vpl VALUES ("JS9_17","007_9_17","JOS","9","17","17","ከናፉ እስራኤሎን ከአኒ ጉያ ሰደፋት ገረ መጋላሳኒ ጄቹንስ ገረ ግቤኦን፣ ኬፊራ፣ ገረ ብኤሮቲፊ ክርያት ዬኣሪም ዹፈን። ");
INSERT INTO gaze_vpl VALUES ("JS9_18","007_9_18","JOS","9","18","18","እስራኤሎን ገሩ ሰበቢ ሆገንቶትን ወልዳ መቃ ዋቀዮ ዋቀ እስራኤሊቲን እሳኒፍ ከከተኒ ቱረኒቲፍ እሳን ህንቱቅኔ። ወልዳን ሱን ጉቱንስ ሆገንቶተት ጉንጉሜ፤ ");
INSERT INTO gaze_vpl VALUES ("JS9_19","007_9_19","JOS","9","19","19","ሆገንቶትን ሁንድ ገሩ አከነ ጄዸኒ ዴብሰን፤ “ኑ ዋቀዮ ዋቀ እስራኤሊን እሳኒ ከከኔረ፤ ከናፉ ኑ አመ እሳን ቱቁ ህንደንዴኙ። ");
INSERT INTO gaze_vpl VALUES ("JS9_20","007_9_20","JOS","9","20","20","ወን ኑ እሳን ጎኑ ከነ፦ አከ ከኩሳኒ ከከትኔ ሰነ ጨብስኔ ዼከምስ ኑረ ህንቡኔፍ አከ እሳን ጅራተኒፍ እቱመ ዺፍነ።” ");
INSERT INTO gaze_vpl VALUES ("JS9_21","007_9_21","JOS","9","21","21","ሆገንቶትን ሱንስ እቱመ ፉፈኒ፣ “ጀር ሃጅራተን፤ ገሩ ጉቱማ ሰባቲፍ ወረ ሙከ ሙረኒፊ ወረ ብሻን ወራበን ሃተአን” ጄዸን። አከሲንስ ከኩን ሆገንቶትን እሳኒፍ ገለን ሱን ንኤገሜ። ");
INSERT INTO gaze_vpl VALUES ("JS9_22","007_9_22","JOS","9","22","22","እያሱንስ ግቤኦኖተ ኦፍት ዋሜ አከነ ጄዼን፤ “እስን ማሊፍ ኡቱመ ኑት ዽኦ ጅራተኑ፣ ‘ኑ ብየ እስንራ ፈጎ ተኤ ኬሰ ጅራትነ’ ጄተኒ ኑ ጎዎምስተን? ");
INSERT INTO gaze_vpl VALUES ("JS9_23","007_9_23","JOS","9","23","23","እስን አመ አባርሰ ጀለ ጅርቱ፤ ቶኮንኬሰንዩ መነ ዋቀኮቲፍ ሙከ ሙሩፊ ብሻን ወራቡ ጀላ ህንባተን።” ");
INSERT INTO gaze_vpl VALUES ("JS9_24","007_9_24","JOS","9","24","24","እሳንስ አከነ ጄዸኒ እያሱፍ ዴቢ ኬነን፤ “አከ ዋቀዮ ዋቅንኬ አከ ሙሴን ብየቲ ጉቱ እስኒ ኬኑፊ አከ እን ወረ አች ጅራተን ሁንደ ፉለኬሰን ዱራ በሌሱፍ ገርብቸሳ ሙሴ አጀጄ ኑ ገርቦተኬት ዹጉማን ህመሜረ። ከናፉ ኑ ሰበቢኬሰኒፍ ጄኔ ሉቡኬኛፍ ሶዳትኔ፤ ወን ኑ ዋን ከነ ጎኔፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("JS9_25","007_9_25","JOS","9","25","25","ኑ ኩኖ አመ ሀርከኬ ኬሰ ጅረ። አትስ ዋን ጋሪፊ ቀጄላ ሴቴ ሁንዱማ ኑረት ራወዹ።” ");
INSERT INTO gaze_vpl VALUES ("JS9_26","007_9_26","JOS","9","26","26","ከናፉ እያሱን እስራኤሎተ ዱራ እሳን ባሴ፤ እስራኤሎንስ እሳን ህንአጄፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JS9_27","007_9_27","JOS","9","27","27","እንስ ጉዩመ ሰነ ግቤኦኖተ ሰነ ሰበ ሁንዳፍ፣ አከሱመስ እዶ ዋቀዮ ፍለቱት እዶ ኣርሳ ዋቀዮቲፍ ወረ ሙከ ሙረኒፊ ወረ ብሻን ወራበን እሳን ጎዼ። እሳንስ ሀመ ሀርኣት ከኑመ ሆጄቱ። ");
INSERT INTO gaze_vpl VALUES ("JS10_1","007_10_1","JOS","10","1","1","አዶኒ-ዜዴቅ ሞቲን ዬሩሳሌም አከ እያሱን ኣይን ቀበቴ ጉቱማን ጉቱት በርበዴሴ፣ አከ እን አኩመ ዬርኮፊ ሞቲሼ ጎዼ ሰነ ኣዪፊ ሞቲሼ ጎዼ፣ አከሱመስ አከ ነሞትን ግቤኦን እስራኤሎተ ወጅን ወሊ ገልቴ ነጋ ጎዸተኒ እሳን ብረ ጅራተን ዸገኤ። ");
INSERT INTO gaze_vpl VALUES ("JS10_2","007_10_2","JOS","10","2","2","ሰበቢ መጋላን ግቤኦን አኩመ መጋላ ሞቶታ ቶኮት መጋላ ሀንገፈ ታቴፍ እኒፊ ነሞትንሳ አከ መሌ ርፈተን፤ መጋላን ግቤኦን መጋላ ኣይ ጫላ ጉዶ ቱርቴ፤ ነሞትን እሼስ ሎልቶተ ጀጀቦ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS10_3","007_10_3","JOS","10","3","3","ከናፉ አዶኒ-ዜዴቅ ሞትች ዬሩሳሌም ሱን ሆሃም ሞትቸ ኬብሮንት፣ ጵራም ሞትቸ የርሙትት፣ ያፊያ ሞትቸ ላኪሺፊ ዴቢር ሞትቸ ኤግሎንት ኤርጌ፣ ");
INSERT INTO gaze_vpl VALUES ("JS10_4","007_10_4","JOS","10","4","4","“ሰበቢ እሼን እያሱፊ እስራኤል ወጅን ወሊ ገልቴ ነጋ ጎዸቴፍ ኦል ኮታቲ ግቤኦንን ወራኑ ነ ገርጋራ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JS10_5","007_10_5","JOS","10","5","5","ከናፉ ሞቶትን አሞሮታ ሸነኑ ጄቹንስ ሞቲን ዬሩሳሌም፣ ሞቲን ኬብሮን፣ ሞቲን የርሙት፣ ሞቲን ላኪሺፊ ሞቲን ኤግሎን ሁምነ ወራና ወልት ደበለተን። እሳንስ ሎልቶተሳኒ ሁንደ ፉዸተኒ ኦል በአኒ ግቤኦንን መርሰኒ ወራነን። ");
INSERT INTO gaze_vpl VALUES ("JS10_6","007_10_6","JOS","10","6","6","ነሞትን ግቤኦንስ ቁበተ ግልጋል ገረ እያሱት ኤርጋ ኤርገኒ አከነ ጄዸኒን፤ “አት ገርቦተኬ ህንዺስን። ደፊ ኑ ቀቀቢቲ ኑ ኦልች፤ ሰበቢ ሞቶትን አሞሮታ ከኔን ብየ ጋራ ኬሰ ጅራተን ሁንድ ኑ ወራኑፍ ሎልቶተ ወልት ደበለተኒፍ ኑ ገርጋር።” ");
INSERT INTO gaze_vpl VALUES ("JS10_7","007_10_7","JOS","10","7","7","ከናፉ እያሱን ሎልቶተሳ ሁንደ ወጅን፣ ነሞተ ወራና ጀጀቤዪ ሁንደስ ደበለቴ ግልጋሊ ኦል በኤ። ");
INSERT INTO gaze_vpl VALUES ("JS10_8","007_10_8","JOS","10","8","8","ዋቀዮስ እያሱዻን፣ “እሳን ህንሶዳትን፤ አን ሀርከኬት ደበርሴ እሳን ኬኔረ። ቶኮንሳኒዩ ፉለኬ ዱረ ዻበቹ ህንደንደአን” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS10_9","007_10_9","JOS","10","9","9","ከናፉ እያሱን ግልጋሊ በኤ ሀልከን ጉቱ ዴማ ቡሌ ተሱመ እሳንት ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("JS10_10","007_10_10","JOS","10","10","10","ዋቀዮስ ፉለ እስራኤሎታ ዱረት እሳን ቡርጃጄሴ፤ እስራኤሎንስ ግቤኦንት ሞአትና ጉዳዻን እሳን ሞአተን። ከራ ቤት ሆሮንት ጌሱረ እሳን አርኣ ሀመ አዜቃፊ መቄዳት እሳን ጎጎረአን። ");
INSERT INTO gaze_vpl VALUES ("JS10_11","007_10_11","JOS","10","11","11","ኡቱመ እሳን እስራኤሎተ ዱራ ከራ ቤት ሆሮኒን ገረ አዜቃት ገድ በቀቻ ጅረኑ ዋቀዮ ሰሚዻ ጨቢ ጉርጉዳ እት ሮብሴ፤ ወረ ጎራዴ እስራኤሎታቲን ዹመን ጫላ ከኔን ጨቢ ከናን ዹመንቱ ባይአተ። ");
INSERT INTO gaze_vpl VALUES ("JS10_12","007_10_12","JOS","10","12","12","ጋፈ ዋቀዮ አሞሮተ ደበርሴ እስራኤሎተት ኬኔ ሰነ እያሱን ፉለ እስራኤሎታ ዱረት ዋቀዮን አከነ ጄዼ፦ “ያ አዱ፣ ግቤኦን ጉባ ዻበዹ፤ ያ ጅአ፣ አትስ ሱሉለ አያሎን ጉባ ዻበዹ።” ");
INSERT INTO gaze_vpl VALUES ("JS10_13","007_10_13","JOS","10","13","13","ከናፉ ሀመ ሰብን ዲኖተሳ ሃሎ ባፈቱት አዱን እዱመ ጅርቱ ዻበቴ፤ ጅእስ ንዻበቴ፤ ወን ኩን ክታበ ያሻር ኬሰት በሬፈሜረ ምቲ? አዱን ወለካ ሰሚ ኬሰ ዻበቴ ጉያ ቶኮ ጉቱ ኡቱ ህንዽእን ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("JS10_14","007_10_14","JOS","10","14","14","ጉያን ዋቀዮ ነመ ዸገኤ ከን አከሲ ጋፈሲን ዱረ ዮካን ኤርገሲ ተኩማ ተኤ ህንቤኩ። ዋቀዮ ዹጉማን እስራኤሊፍ ሎላ ቱሬ! ");
INSERT INTO gaze_vpl VALUES ("JS10_15","007_10_15","JOS","10","15","15","ኤርገሲ እያሱን እስራኤሎተ ሁንደ ወጅን ቁበተ ግልጋል ጅሩ ሰነት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("JS10_16","007_10_16","JOS","10","16","16","ሞቶትን ሸነን ሱን በቀተኒ ሆልቀ መቄዳ ኬሰት ዾከተኒ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS10_17","007_10_17","JOS","10","17","17","አከ ሞቶትን ሸነን ሆልቀ መቄዳ ኬሰት ዾከተን እያሱት ህመሜ፤ ");
INSERT INTO gaze_vpl VALUES ("JS10_18","007_10_18","JOS","10","18","18","እንስ አከነ ጄዼ፤ “ዸጋ ጉዳሳ አፋን ሆልቀ ሰናት ገንገልቻቲ አከ እሳን ኤገኒፍ ነሞተ አችት ረመዳ። ");
INSERT INTO gaze_vpl VALUES ("JS10_19","007_10_19","JOS","10","19","19","እስን ዲኖተኬሰን አርኣቲ ከራ ዱግደ ዱባቲን ሩኩታ መሌ ህንዻበትና! ሰበቢ ዋቀዮ ዋቅንኬሰን ደበርሴ ሀርከኬሰንት እሳን ኬኔፍ አከ እሳን መጋላወንሳኒ ሴነን ህንጎዽና።” ");
INSERT INTO gaze_vpl VALUES ("JS10_20","007_10_20","JOS","10","20","20","ከናፉ እያሱፊ እስራኤሎን ሀመ ነምን ሙራስን ሀፉት ጉቱማን ጉቱት እሳን በርበዴሰን። ወር ሀፈንሞ መጋላወንሳኒ ከኔን ጀጀቤፈመኒ እጃረመንት ገለን። ");
INSERT INTO gaze_vpl VALUES ("JS10_21","007_10_21","JOS","10","21","21","ሎልቶትን ሁንድ ነጉማን ገረ ቁበተ መቄዳ ገረ እያሱት ዴብአን፤ ነምን ቶኮዩ አፋንሳ እስራኤሎተት ህንበነትኔ። ");
INSERT INTO gaze_vpl VALUES ("JS10_22","007_10_22","JOS","10","22","22","እያሱንስ፣ “ሜ አፋን ሆልቀ ሰና በናቲ ሞቶተ ሸነን ሰነ ገድ ና ባሳ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS10_23","007_10_23","JOS","10","23","23","እሳንስ ሞቶተ ሸነን ሰነ ጄቹንስ ሞቲ ዬሩሳሌም፣ ሞቲ ኬብሮን፣ ሞቲ የርሙት፣ ሞቲ ላኪሺፊ ሞቲ ኤግሎን ሆልቀ ኬሳ ባሰኒ ፍደን። ");
INSERT INTO gaze_vpl VALUES ("JS10_24","007_10_24","JOS","10","24","24","ዮሙ እሳን ሞቶተ ከነ ሸነን እያሱት ፍደን፣ እን ነሞተ እስራኤል ሁንደ ወልት ዋሜ አጀጆተ ሎልቶታ ከኔን እሰ ወጅን ዹፈኒን፣ “ኮታቲ ሚለኬሰኒን ሞርመ ሞቶተ ከኔኒረ ኤጀዻ” ጄዼ። እሳንስ ገረ ፉለ ዱራት በአኒ ሚለሳኒቲን ሞርመ ሞቶተ ሰናረ ኤጄተን። ");
INSERT INTO gaze_vpl VALUES ("JS10_25","007_10_25","JOS","10","25","25","እያሱን፣ “ህንሶዳትና፤ አብዲስ ህንኩተትና። ጀባዻ፤ ጭማስ። ወን ዋቀዮ ዲኖተ እስን ሎሉፍ ዴምተን ሁንደረት ጎዹፍ ጅሩስ ከኑመ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JS10_26","007_10_26","JOS","10","26","26","እያሱን ኤርገሲ ሞቶተ ሰነ ዸኤ አጄሴ ሙኬን ሸንረት እሳን ፈንሴ፤ እሳንስ ሀመ ለፍት ገልገሎፍቱት አኩመ ሙከረት ፈንፈመንት ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS10_27","007_10_27","JOS","10","27","27","ዬሮ አዱን ዺቴት እያሱን አጀጀ ኬኔ፤ ጀርስ ሙኬንራ ገድ እሳን ቡሰኒ ሆልቀ እሳን ኬሰ ዾከተኒ ቱረን ሰነት እሳን ደደርበተን። አፋን ሆልቀ ሰናረስ ዸጋ ጉርጉዳ ሀመ ጉያ ሀርኣትሌ አቹመ ጅሩ ነቀን። ");
INSERT INTO gaze_vpl VALUES ("JS10_28","007_10_28","JOS","10","28","28","እያሱንስ ጉዩመ ሰነ መቄዳ ቀበቴ። እንስ መጋላ ሰናፊ ሞቲሼ ጎራዴዻን ዸኤ ነመ አች ኬሰ ጅሩ ሁንደ ፍጤ። ነመ ቶኮዩ ህንሀምብፍኔ። ሞቲ መቄዳስ አኩመ ሞቲ ዬርኮ ጎዼ ሰነ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("JS10_29","007_10_29","JOS","10","29","29","እያሱፊ እስራኤሎን እሰ ወጅን ቱረን ሁንድ መቄዳዻ በአኒ ዸቀኒ ልብና ሎለን። ");
INSERT INTO gaze_vpl VALUES ("JS10_30","007_10_30","JOS","10","30","30","ዋቀዮስ መጋላ ሰናፊ ሞቲሼ ደበርሴ ሀርከ እስራኤሎታት ኬኔ። እያሱን መጋለቲፊ ነመ እሼ ኬሰ ጅሩ ሁንደ ጎራዴዻን ፍጤ። እን ነመ ቶኮሌ አችት ህንሀምብፍኔ። ሞቲሼሌ አኩመ ሞቲ ዬርኮ ጎዼ ሰነ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("JS10_31","007_10_31","JOS","10","31","31","እያሱፊ እስራኤሎን ሁንድ እሰ ወጅን ልብናዻ ከአኒ ላኪሽ ዸቀን፤ እሳንስ መጋላ ሰነ መርሰኒ ወራነን። ");
INSERT INTO gaze_vpl VALUES ("JS10_32","007_10_32","JOS","10","32","32","ዋቀዮስ ላኪሽ ደበርሴ ሀርከ እስራኤሎታት ኬኔ፤ እያሱንስ ጉያ ለመፋት እሼ ቀበቴ። አኩመ ልብና ጎዼ ሰነ መጋላ ሰናፊ ወረ እሼ ኬሰ ጅራተን ሁንደ ጎራዴዻን ፍጤ። ");
INSERT INTO gaze_vpl VALUES ("JS10_33","007_10_33","JOS","10","33","33","ዬሮ ሰነት ሆራም ሞትች ጌዝር፣ ላኪሽ ገርጋሩዻፍ ዹፌ ቱሬ፤ እያሱን ገሩ እሳፊ ሎልቶተሳ ንሞአቴ፤ ነምን ቶኮዩ ህንሀፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JS10_34","007_10_34","JOS","10","34","34","ኤርገሲስ እያሱፊ እስራኤሎን ሁንድ ላኪሺ ከአኒ ገረ ኤግሎን ዸቀን፤ መርሰኒስ እሼ ወራነን። ");
INSERT INTO gaze_vpl VALUES ("JS10_35","007_10_35","JOS","10","35","35","ጉዩመ ሰነ እሼ ቀበተኒ አኩመ ላኪሽ ጎዸን ሰነ እሼፊ ነመ እሼ ኬሰ ጅሩ ሁንደ ጎራዴዻን ፍጠን። ");
INSERT INTO gaze_vpl VALUES ("JS10_36","007_10_36","JOS","10","36","36","እያሱፊ እስራኤሎን ሁንድስ እሰ ወጅን ኤግሎኒ ከአኒ ገረ ኬብሮንት ኦል በአኒ እሼ ወራነን። ");
INSERT INTO gaze_vpl VALUES ("JS10_37","007_10_37","JOS","10","37","37","እሳንስ መጋለቲ ቀበተኒ ሞቲሼ፣ ገንዶተሼቲፊ ነመ እሼ ኬሰ ጅሩ ሁንደ ጎራዴዻን ፍጠን። ነመ ቶኮዩ ህንሀምብፍኔ። አኩመ ኤግሎን ጎዸን ሰነ እሼፊ ነመ እሼ ኬሰ ጅሩ ሁንደ ጉቱማን ጉቱት በርበዴሰን። ");
INSERT INTO gaze_vpl VALUES ("JS10_38","007_10_38","JOS","10","38","38","ኤርገሲስ እያሱፊ እስራኤሎን ሁንድ እሰ ወጅን ኦፍረ ዴብአኒ ዴቢርን ዸአን። ");
INSERT INTO gaze_vpl VALUES ("JS10_39","007_10_39","JOS","10","39","39","እሳንስ መጋለቲ፣ ሞቲሼቲፊ ገንዶተሼ ቀበተኒ ጎራዴዻን ፍጠን። ነሞተሼ ኬሰ ጅራተን ሁንደስ ጉቱማን ጉቱት ፍጠን። ነመ ቶኮዩ ህንሀምብፍኔ። አኩመ ልብና፣ ሞቲሼቲፊ ኬብሮን ጎዸን ሰነ ዴቢሪፊ ሞቲሼ ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("JS10_40","007_10_40","JOS","10","40","40","እያሱንስ አከሲን ጉቱማ ብየ ሰና፣ ብየ ጋራ፣ ኔጌብ፣ ብየ ገሞጂ፣ ተበወን ቱሉቲፊ ሞቶተሳኒ ሁንደስ ሞአቴ። እን አኩመ ዋቀዮ ዋቅን እስራኤል አጀጄት ዋን ሀፉረ ባፈቱ ሁንደ ጉቱማን ጉቱት በሌሴ መሌ ነመ ቶኮሌ ህንሀምብፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JS10_41","007_10_41","JOS","10","41","41","እያሱን ቃዴሽ በርኔራ ጀልቀቤ ሀመ ጋዛት፣ ጉቱማ ብየ ጎሼን ሀመ ግቤኦንት ቀበቴ። ");
INSERT INTO gaze_vpl VALUES ("JS10_42","007_10_42","JOS","10","42","42","ሰበቢ ዋቀዮ ዋቅን እስራኤል እስራኤሊፍ ሎሌፍ እያሱን ሞቶተ ከኔኒፊ ለፈሳኒ ሎሉመ ቶኮን ሞአቴ። ");
INSERT INTO gaze_vpl VALUES ("JS10_43","007_10_43","JOS","10","43","43","ኤርገሲ እያሱን እስራኤሎተ ሁንደ ወጅን ገረ ቁበተ ግልጋልት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("JS11_1","007_11_1","JOS","11","1","1","ያቢን ሞትች ሃዞር ዋን ከነ ዸጌኛን ዮባብ ሞትቸ ማዶንት፣ ሞቶተ ሽምሮኒፊ አክሻፍት ኤርጋ ኤርገቴ፤ ");
INSERT INTO gaze_vpl VALUES ("JS11_2","007_11_2","JOS","11","2","2","አከሱመስ ሞቶተ ካባ ከኔን ቱሉወንረ ጅራተንት፣ ከኔን ገመ ክበ ክኔሬቲን አረባ ኬሰ ጅራተንት፣ ከኔን ገመ ዽአ ቢፍቱቲን ለፈ ገሞጂቲፊ ዶር ኬሰ ጅራተንት ኤርጋ ኤርገቴ፤ ");
INSERT INTO gaze_vpl VALUES ("JS11_3","007_11_3","JOS","11","3","3","ከነኣኖተ ገመ በአ ቢፍቱቲፊ ልጠ ቢፍቱቲን ጅራተንት፣ አሞሮተት፣ ሄቶተት፣ ፌርዞታት ዬቡሶተ ብየ ጋራ ኬሰ ጅራተንቲፊ ሞቶተ ሂዎታ ከኔን ጋረ ሄርሞን ጀለ ብየ ሚስጳ ኬሰ ጅራተንት ኤርጋ ኤርገቴ። ");
INSERT INTO gaze_vpl VALUES ("JS11_4","007_11_4","JOS","11","4","4","እሳንስ ቱተ ሎልቶተሳኒ ሁንደ፣ ፈርዴኒፊ ጋሪወን ሎላ ባይኤ ጄቹንስ ሁምነ ወራና ጉዳ ከን አከ ጭረቸ ቀርቀረ ገላና ባይአቱ ቀበተኒ ዹፈን። ");
INSERT INTO gaze_vpl VALUES ("JS11_5","007_11_5","JOS","11","5","5","ሞቶትን ኩኔን ሁንድ ሎልቶተሳኒ ወልት መከተኒ እስራኤሎተ ወራኑፍ ብሻኖተ ሜሮን ጭነ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("JS11_6","007_11_6","JOS","11","6","6","ዋቀዮ እያሱዻን አከነ ጄዼ፤ “ሰበቢ አን ቦር ዬሮ ከነት ሬፈሳኒ ሁንደ ደበርሴ እስራኤሎተት ኬኑፍ ህንሶዳትን። አት ህደ ኮቴ ፈርዴንሳኒ ኩኩቴ ጋሪወንሳኒስ ጉቡ ቀብደ።” ");
INSERT INTO gaze_vpl VALUES ("JS11_7","007_11_7","JOS","11","7","7","ከናፉ እያሱፊ ሎልቶትንሳ ሁንድ ተሱመ ብሻን ሜሮን ብረት እሳንት ዹፈኒ እሳን ዸአን፤ ");
INSERT INTO gaze_vpl VALUES ("JS11_8","007_11_8","JOS","11","8","8","ዋቀዮስ ደበርሴ ሀርከ እስራኤሎታት እሳን ኬኔ። እሳንስ ጀረ ሞአተኒ ሀመ ሲዶና ጉዶት፣ ሀመ ምስሬፎት ማይምት፣ ሀመ ሱሉለ ሚስጳ ከን ገመ በአ ቢፍቱት እሳን አርአን፤ ሀመ ነምን ሁንድ ዹሙትስ እሳን ዸአን። ");
INSERT INTO gaze_vpl VALUES ("JS11_9","007_11_9","JOS","11","9","9","እያሱንስ አኩመ ዋቀዮ አጀጄ ሰነ እሳን ጎዼ፤ እንስ ህደ ኮቴ ፈርዴንሳኒ ኩኩቴ ጋሪወንሳኒ ከን ሎላ ጉቤ። ");
INSERT INTO gaze_vpl VALUES ("JS11_10","007_11_10","JOS","11","10","10","ዬሮ ሰነት እያሱን ኦፍረ ዴብኤ አሶር ቀበቴ ሞቲሼ ጎራዴዻን አጄሴ። ሃዞርስ መጋላ ጉድቲ ሞቱሞተ ከኔን ሁንዱማ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("JS11_11","007_11_11","JOS","11","11","11","እሳንስ ነመ እሼ ኬሰ ጅሩ ሁንደ ጎራዴዻን ፍጠን። ዋን ሀፉረ ባፈቱ ቶኮሌ ኡቱ ህንሀምብስን ጉቱማን ጉቱት በሌሰን፤ እያሱን ሃዞርንስ ንጉቤ። ");
INSERT INTO gaze_vpl VALUES ("JS11_12","007_11_12","JOS","11","12","12","እያሱን መጋላወን ሞቶታ ሁንዳፊ ሞቶተሳኒሌ ቀበቴ ጎራዴዻን ፍጤ። እንስ አኩመ ገርብች ዋቀዮ ሙሴን አጀጄት ጉቱማን ጉቱት እሳን በሌሴ። ");
INSERT INTO gaze_vpl VALUES ("JS11_13","007_11_13","JOS","11","13","13","ተኡስ እስራኤሎን መጋላ ሃዞር እሼ እያሱን ጉቤ ሰነ መሌ መጋላወን ተበረት እጃረመን ቶኮሌ ህንጉብኔ። ");
INSERT INTO gaze_vpl VALUES ("JS11_14","007_11_14","JOS","11","14","14","እስራኤሎን ቦጁፊ ሆሪ መጋላ ሰና ሁንደ ኦፊሳኒቲፍ ፉዸተን፤ ነሞተ ሁንደ ገሩ ጉቱማን ጉቱት ጎራዴዻን ፍጠን፤ ነመ ሀፉረ ባፈቱ ቶኮሌ ህንሀምብፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JS11_15","007_11_15","JOS","11","15","15","አኩመ ዋቀዮ ገርብቸሳ ሙሴ አጀጄ ሰነ ሙሴንስ አከሱመ እያሱ አጀጄ፤ እያሱንስ አከሱመ ጎዼ፤ እን ዋን ዋቀዮ ሙሴ አጀጄ ኬሳ ዋን ቶኮሌ ኡቱ ህንሆጄትን ህንሀምብፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JS11_16","007_11_16","JOS","11","16","16","እያሱን አከሲን ጉቱማ ብየ ሰና ቀበቴ፤ ኩንስ ብየ ጋራ፣ ኔጌብ ሁንደ፣ ጉቱማ ጎሼን፣ ገሞጂ ገመ ልጠ አዱ፣ አረባፊ ጋረን እስራኤል ገሞጂሳኒ ወጅን፣ ");
INSERT INTO gaze_vpl VALUES ("JS11_17","007_11_17","JOS","11","17","17","ቱሉ ሀላቅ ከን ጋረ ሴኢርት ኦል ከኡ ጀልቀበኒ ሀመ በኣል ጋድ ከን ቱሉ ሄርሞን ጀለ ሀመ ሱሉለ ልባኖንት ጅሩ ቦጅኤ። እንስ ሞቶተሳኒ ሁንደ ጎጎረኤ አጄሴ። ");
INSERT INTO gaze_vpl VALUES ("JS11_18","007_11_18","JOS","11","18","18","እያሱንስ በረ ዼራ ሞቶተ ከኔን ሁንደት ወራነ በና ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS11_19","007_11_19","JOS","11","19","19","ሂዎተ ግቤኦን ኬሰ ጅራተን መሌ መጋላን ቶኮዩ እስራኤሎተ ወጅን ወሊ ገልቴ ነጋ ህንጎዸትኔ፤ እስራኤሎን መጋላወን ሁንደ ወራነኒ ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("JS11_20","007_11_20","JOS","11","20","20","አኩመ ዋቀዮ ሙሴ አጀጄ ሰነት ገረ ላፍነ ቶኮ መሌ እሳን በርበዴሱዻን ጉቱማን ጉቱት እሳን በሌሱዻፍ ጄዼ አከ እሳን እስራኤሎተት ወራነ በነኒፍ ከን ገራሳኒ ጀቤሴ ዋቀዮ መታሳት። ");
INSERT INTO gaze_vpl VALUES ("JS11_21","007_11_21","JOS","11","21","21","እያሱን ዬሮ ሰነት ዸቄ ብየ ጋራ ኬሳ ጄቹንስ ኬብሮን፣ ዴቢሪፊ ኣናብ፣ አከሱመስ ብየ ጋራ ይሁዳቲፊ ብየ ጋራ እስራኤል ሁንደ ኬሳ አናቆተ በርበዴሴ። እያሱንሳኒፊ መጋላወንሳኒስ ጉቱማን ጉቱት በርበዴሴ። ");
INSERT INTO gaze_vpl VALUES ("JS11_22","007_11_22","JOS","11","22","22","ጋዛ፣ ጋቲፊ አሽዶድ መሌ ኩታን ብየ እስራኤል ከን አናቆን ኬሰት ሀፈን ቶኮዩ ህንቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS11_23","007_11_23","JOS","11","23","23","ከናፉ እያሱን አኩመ ዋቀዮ ሙሴ አጀጄ ሰነት ብየ ጉቱ ቀበቴ አኩመ መነ ጎሰ ጎሰሳኒት ዻለ ጎዼ እስራኤሎታፍ ኬኔ። ብየቲንስ አከሲን ወራነራ ቦቆና አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("JS12_1","007_12_1","JOS","12","1","1","ወር ኩኔን ሞቶተ እስራኤሎን ሞአተኒ ብዮተሳኒ ጄቹንስ ገመ በአ አረባ ሁንደ ደበለቴ፣ በአ ዮርዳኖስ፣ ሱሉለ አርኖኒቲ ሀመ ቱሉ ሄርሞንት እራ ፉዸተኒዸ፦ ");
INSERT INTO gaze_vpl VALUES ("JS12_2","007_12_2","JOS","12","2","2","ስሆን ሞቲን አሞሮታ፣ ሄሽቦን ኬሰ ታኤ አሮኤር እሼ ቀርቀረ ሱሉለ አርኖንት አርገምቱ ሰና ጀልቀቤ ሀመ ለገ ያቦቅ ከነ ዳሪ አሞኖታት ቡልቻ ቱሬ፤ ኩንስ ወለካ ግልኣድ ደበለተ። ");
INSERT INTO gaze_vpl VALUES ("JS12_3","007_12_3","JOS","12","3","3","አከሱመስ በአ አረባ ገላነ ክኔሬቲቲ ጀልቀቤ ሀመ ገላነ አረባ ዮካን ገላነ ሶግዳት፣ ሀመ ቤት የሺሞትት፣ አቺሞ ከራ ክባቲን ሀመ ተበ ጵስጋት ቡልቻ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS12_4","007_12_4","JOS","12","4","4","ኦግ ሞትች ባሻን ከን ሰኚ ሬፋይም ኬሳ እሰ ዹማ ተኤ ሱን አሽታሮቲፊ ኤድሬዪ ቡልቻ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS12_5","007_12_5","JOS","12","5","5","እንስ ቱሉ ሄርሞን፣ ሰልካ፣ ጉቱማ ባሻን ሀመ ጌሹሮታቲፊ መአካታት፣ ወለካ ግልኣድሞ ሀመ ዳንጋ ስሆን ሞትቸ ሄሽቦንት ቡልቻ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS12_6","007_12_6","JOS","12","6","6","ሙሴን ገርብች ዋቀዮቲፊ እስራኤሎን እሳን ሞአተን። ሙሴን ገርብች ዋቀዮ ብየሳኒ ሩቤኖታፍ፣ ጎሰ ጋዲቲፊ ወለካ ጎሰ ምናሴቲፍ ዻለ ጎዼ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("JS12_7","007_12_7","JOS","12","7","7","ሞቶትን ብየ እያሱፊ እስራኤሎን ዮርዳኖሲን ገመ ልጠ ቢፍቱት ሞአተኒ ከኔኒዸ፦ ብይሳኒስ በኣል ጋድ ሱሉለ ልባኖን ኬሰ ጅርቱ ሰና ጀልቀቤ ሀመ ቱሉ ሀላቅ ከን ገረ ሴኢር ለፈ እያሱን አኩመ ጎሰ ጎሰሳኒት ዻለ ጎዼ እስራኤሎታፍ ኬኔ ሰናት ኦል ከኡዸ። ");
INSERT INTO gaze_vpl VALUES ("JS12_8","007_12_8","JOS","12","8","8","ብዮትን ኩኔንስ ብየ ጋራ፣ ብየ ከራ ልጣ፣ አረባ፣ ተበ ቱሉ፣ ለፈ አሎቲፊ ኔጌብ ጄቹንስ ብዮተ ሄቶታ፣ አሞሮታ፣ ከነኣኖታ፣ ፌርዞታ፣ ሂዎታቲፊ ዬቡሶታት። ");
INSERT INTO gaze_vpl VALUES ("JS12_9","007_12_9","JOS","12","9","9","ሞቲ ዬርኮ፣ ቶኮ ሞቲ ኣይ ከን ቤትኤል ብራ፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_10","007_12_10","JOS","12","10","10","ሞቲ ዬሩሳሌም፣ ቶኮ ሞቲ ኬብሮን፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_11","007_12_11","JOS","12","11","11","ሞቲ የርሙት፣ ቶኮ ሞቲ ላኪሽ፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_12","007_12_12","JOS","12","12","12","ሞቲ ኤግሎን፣ ቶኮ ሞቲ ጌዝር፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_13","007_12_13","JOS","12","13","13","ሞትቸ ዴቢር፣ ቶኮ ሞቲ ጋዴር፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_14","007_12_14","JOS","12","14","14","ሞቲ ሆርማ፣ ቶኮ ሞቲ ኣራድ፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_15","007_12_15","JOS","12","15","15","ሞቲ ልብና፣ ቶኮ ሞቲ አዱላም፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_16","007_12_16","JOS","12","16","16","ሞቲ መቄዳ፣ ቶኮ ሞቲ ቤትኤል፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_17","007_12_17","JOS","12","17","17","ሞቲ ተፉኣ፣ ቶኮ ሞቲ ሄፌር፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_18","007_12_18","JOS","12","18","18","ሞቲ አፌቅ፣ ቶኮ ሞትቸ ለሻሮን፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_19","007_12_19","JOS","12","19","19","ሞቲ ማዶን፣ ቶኮ ሞቲ ሃዞር፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_20","007_12_20","JOS","12","20","20","ሞቲ ሽምሮን ሜሮን፣ ቶኮ ሞቲ አክሻፍ፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_21","007_12_21","JOS","12","21","21","ሞቲ ተአናክ፣ ቶኮ ሞቲ ሜግዶ፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_22","007_12_22","JOS","12","22","22","ሞቲ ቃዴሽ፣ ቶኮ ሞቲ ዮቄንኣም ከን ቀርሜሎስ ጅራቱ፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_23","007_12_23","JOS","12","23","23","ሞቲ ዶር ከን ተበ ዶርራ ጅራቱ፣ ቶኮ ሞቲ ጎይም ከን ግልጋል ኬሳ ጅራቱ፣ ቶኮ ");
INSERT INTO gaze_vpl VALUES ("JS12_24","007_12_24","JOS","12","24","24","ሞቲ ቲርዛ፣ ቶኮ። ");
INSERT INTO gaze_vpl VALUES ("JS13_1","007_13_1","JOS","13","1","1","ዋቀዮስ ዬሮ እያሱን በረ ዼራ ጅራቴ ዱሎሜት አከነ ጄዼን፤ “አት አመ አከ መሌ ዱሎምቴርተ፤ ገሩ አመዩ ለፍት ዻለሙ ቀቡ ባይኤቱ ጅረ። ");
INSERT INTO gaze_vpl VALUES ("JS13_2","007_13_2","JOS","13","2","2","“ለፍት ሀፌ ሱንስ ከናዸ፦ “ጉቱማ ብየ ፍልስጤሞታቲፊ ጌሹሮታ፣ ");
INSERT INTO gaze_vpl VALUES ("JS13_3","007_13_3","JOS","13","3","3","ከራ በአ ግብጢቲን ለገ ሽሆሪ ሀመ ካበ ዳሪ አሽቀሎንት ጅሩ ሁንድ አከ ብየ ከነኣኖታት ሄደመ። ኩንስ ብየ አዎታ ከን ኩታ ብዮተ ቡልችቶተ ፍልስጤሞታ ሸነን ጄቹንስ ጋዛ፣ አሽዶድ፣ ኤቅሮን፣ ግቲፊ ኤቅሮን፤ ");
INSERT INTO gaze_vpl VALUES ("JS13_4","007_13_4","JOS","13","4","4","ከራ ክባቲንሞ ጉቱማ ብየ ከነኣኖታ፣ ሜኣራ ሲዶናቲ ሀመ አፌቂት ብየ አሞሮታ ");
INSERT INTO gaze_vpl VALUES ("JS13_5","007_13_5","JOS","13","5","5","ከን ብየ ጌባሎታት፤ አከሱመስ ከራ በኣቲን ጉቱማ ልባኖን፣ በኣል ጋድ ከን ቱሉ ሄርሞን ጀላ ሀመ ሌቦ ሀማትት። ");
INSERT INTO gaze_vpl VALUES ("JS13_6","007_13_6","JOS","13","6","6","“አን መታንኮ ጅራቶተ ብየ ጋራ ከኔን ልባኖኒ ሀመ ምስሬፎት ማይሚት ጅራተን ጄቹንስ ሲዶኖተ ሁንደ ፉለ እስራኤሎታ ዱራ አርኤ ነንባሰ። አት አኩመ አን ስ አጀጄት ብየ ከነ አከ ዻላት እስራኤሎታፍ ህር፤ ");
INSERT INTO gaze_vpl VALUES ("JS13_7","007_13_7","JOS","13","7","7","ከነስ ጎሶተ ሰገለኒፊ ወለካ ጎሰ ምናሴቲፍ ዻለ ጎዺ ህር።” ");
INSERT INTO gaze_vpl VALUES ("JS13_8","007_13_8","JOS","13","8","8","ወለካን ጎሰ ምናሴ ካን፣ ጎስት ሩቤኒፊ ጎስት ጋድ ብየ ዮርዳኖሲን ገመ በኣ ከን ሙሴን ገርብች ዋቀዮ እሳኒፍ ኬኔ ቱሬ ሰነ አኩመ እን እሳኒፍ ቆዴት ፉዸተን። ");
INSERT INTO gaze_vpl VALUES ("JS13_9","007_13_9","JOS","13","9","9","ብይ ሱንስ አሮኤር ከን ቀርቀረ ሱሉለ አርኖኒት፣ አርገምቱፊ መጋላ ወለካ ሱሉለ ሰና ኬሳቲ ጀልቀቤ ድሬ ሜዴባን ደበለቴ ሀመ ዲቦኒት ድሪረ፤ ");
INSERT INTO gaze_vpl VALUES ("JS13_10","007_13_10","JOS","13","10","10","አከሱመስ መጋላወን ስሆን ሞቲ አሞሮታ ከን ሄሽቦን ቡልቻ ቱሬ ሰና ሁንደ ደበለቴ ሀመ ዳሪ አሞኖታት ድሪረ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS13_11","007_13_11","JOS","13","11","11","ከነ መሌስ ግልኣድ፣ ብየ ጌሹሮታቲፊ መአካቶታ፣ ጉቱማ ቱሉ ሄርሞኒፊ ጉቱማ ባሻን ሀመ ሰልካት ");
INSERT INTO gaze_vpl VALUES ("JS13_12","007_13_12","JOS","13","12","12","ጄቹንስ ጉቱማ ሞቱማ ኦግ ከን ባሻን ኬሳ እሰ አሽታሮቲፊ ኤድሬዪ ቡልቻ ቱሬ ከን ሰኚ ሬፋይሞታ ኬሳ እሰ ዹማ ተኤ ሰናት ድሪረ። ሙሴንስ እሳን ሞአቴ ብየሳኒ ፉዸቴ። ");
INSERT INTO gaze_vpl VALUES ("JS13_13","007_13_13","JOS","13","13","13","ገሩ ሰበቢ እስራኤሎን አርአኒ እሳን ህንባስኒፍ ጌሹሮትኒፊ መአካቶትን ሀመ አማት እስራኤሎተ ግዱ ጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("JS13_14","007_13_14","JOS","13","14","14","ጎሰ ሌዊቲፍ ገሩ እን ዻለ ቶኮሌ ህንኬንኔ፤ አኩመ እን ዋዳ እሳኒፍ ገሌ ሰነት ኣርሳን እብዳን ዋቀዮ ዋቀ እስራኤሊፍ ዽኤፈሙ ዻለ እሳኒቲ። ");
INSERT INTO gaze_vpl VALUES ("JS13_15","007_13_15","JOS","13","15","15","ወን ሙሴን ጎሰ ሩቤኒፍ፣ በልበለ በልበላን ኬኔ ከናዸ፦ ");
INSERT INTO gaze_vpl VALUES ("JS13_16","007_13_16","JOS","13","16","16","ብየ አሮኤር ከን ቀርቀረ ሱሉለ አርኖን፣ መጋለቲ ወለካ ሱሉላቲ ጀልቀቤ ድሬ ሜዴባ ብረ ጅሩ ሁንደ ");
INSERT INTO gaze_vpl VALUES ("JS13_17","007_13_17","JOS","13","17","17","ሀመ ሄሽቦኒፊ መጋላወንሼ ከኔን ድሬረ ጅረን ሁንደ ጄቹንስ ዲቦን፣ ባሞት በኣል፣ ቤት በኣል ሜኦን፣ ");
INSERT INTO gaze_vpl VALUES ("JS13_18","007_13_18","JOS","13","18","18","ያህዛ፣ ቅዴሞት፣ ሜፍኣት፣ ");
INSERT INTO gaze_vpl VALUES ("JS13_19","007_13_19","JOS","13","19","19","ክርያታይም፣ ስብማ፣ ዜሬት ሸሀር እሼ ጋረ ሱሉላረት አርገምቱ፣ ");
INSERT INTO gaze_vpl VALUES ("JS13_20","007_13_20","JOS","13","20","20","ቤት ጴኦር፣ ተበ ጵስጋቲፊ ቤት የሺሞት ");
INSERT INTO gaze_vpl VALUES ("JS13_21","007_13_21","JOS","13","21","21","ጄቹንስ መጋላወን ድሬራ ሁንዱማፊ ጉቱማ ሞቱማ ስሆን ሞትቸ አሞሮታ ከን ሄሽቦን ኬሰ ጅራቴ ቡልቻ ቱሬ ሁንዳት። ሙሴንስ ስሆኒፊ ቡልችቶተ ምድያኖታ ከኔን ኤዊ፣ ሬቄም፣ ዙር፣ ሁሪፊ ሬባ ሞአቴ፤ እሳንስ ስሆኒን ወሊ ገለኒ ብየ ሰነ ኬሰ ጅራቻ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS13_22","007_13_22","JOS","13","22","22","እስራኤሎን ወረ ሎለ ኬሰት አጄፈመንረት ደበለኒ በለኣም እልመ ቤኦር ፈልፈልትቸ ሰነስ ጎራዴዻን አጄሰን። ");
INSERT INTO gaze_vpl VALUES ("JS13_23","007_13_23","JOS","13","23","23","ዳንጋን ሩቤኖታ ቀርቀረ ለገ ዮርዳኖስ ቱሬ። መጋላወን ከኔኒፊ ገንዶትንሳኒ አኩመ በልበለ በልበለሳኒት ዻለ ጎሰ ሩቤን። ");
INSERT INTO gaze_vpl VALUES ("JS13_24","007_13_24","JOS","13","24","24","ወን ሙሴን ጎሰ ጋዲቲፍ በልበለ በልበላን ኬኔ ከናዸ፦ ");
INSERT INTO gaze_vpl VALUES ("JS13_25","007_13_25","JOS","13","25","25","ዳንጋንሳኒስ የእዜር፣ መጋላወን ግልኣድ ሁንዱማፊ ወለካ ብየ አሞኖታ ከን ሀመ አሮኤርት ድሪሬ ገረ በአ ረባት አርገሙዸ፤ ");
INSERT INTO gaze_vpl VALUES ("JS13_26","007_13_26","JOS","13","26","26","አከሱመ ሄሽቦኒ ጀልቀቤ ሀመ ራማትት ሚስጳፊ ቤቶኒምት፣ መሀነዪሚ ጀልቀቤ ሀመ ዳንጋ ዴቢርት ድሪሩዸ፤ ");
INSERT INTO gaze_vpl VALUES ("JS13_27","007_13_27","JOS","13","27","27","አመሌ ሱሉለ ኬሰ፣ ቤት ሃራም፣ ቤት ኒምራ፣ ሱኮት፣ ዛፎኒፊ ብየ ስሆን ሞትች ሄሽቦን ቡልቹ ከን ገረ በአ ዮርዳኖስ ከን ሀመ ዹመ ገላነ ክኔሬትት ድሪሬ ጅሩ ሰናዸ። ");
INSERT INTO gaze_vpl VALUES ("JS13_28","007_13_28","JOS","13","28","28","መጋላወን ኩኔኒፊ ገንዶትንሳኒ አኩመ በልበለ በልበለሳኒት ዻለ ጎሰ ጋድ። ");
INSERT INTO gaze_vpl VALUES ("JS13_29","007_13_29","JOS","13","29","29","ወን ሙሴን ወለካ ጎሰ ምናሴቲፍ ጄቹንስ ወለካ ማቲ ሰኚ ምናሴቲፍ በልበለ በልበላን ኬኔ ከናዸ፦ ");
INSERT INTO gaze_vpl VALUES ("JS13_30","007_13_30","JOS","13","30","30","ዳንጋ ብየ መሀነዪሚቲ ጀልቀቤ ብየ ባሻን ጉቱ ደበለቴ ናኖ ቡልቺንሰ ኦግ ሞትቸ ባሻን ጄቹንስ ቁበተ ያኢር ከን ባሻን ኬሳ መጋላ ጃተመ፣ ");
INSERT INTO gaze_vpl VALUES ("JS13_31","007_13_31","JOS","13","31","31","ወለካ ብየ ግልኣድ፣ አሽታሮቲፊ ኤድሬዪ፣ መጋላ ኦግ ሞትች ባሻን ጅራቱት ድሪረ። ");
INSERT INTO gaze_vpl VALUES ("JS13_32","007_13_32","JOS","13","32","32","ኩን ዻለ ሙሴን ዬሮ ዮርዳኖስ ገመ ጄቹንስ ገመ በአ ዬርኮ ድሬ ሞኣብ ኬሰ ቱሬ ሰነት ቆዴዸ። ");
INSERT INTO gaze_vpl VALUES ("JS13_33","007_13_33","JOS","13","33","33","ጎሰ ሌዊቲፍ ገሩ ሙሴን ዋን ቶኮሌ ህንኬንኔ፤ አኩመ እን ዋዳ እሳኒፍ ገሌ ሰነት ዋቀዮ ዋቅን እስራኤል ዻለሳኒት። ");
INSERT INTO gaze_vpl VALUES ("JS14_1","007_14_1","JOS","14","1","1","ለፍት እስራኤሎን ብየ ከነኣን ኬሰት አከ ዻላት አርገተን ከን ኤሌኣዛር ሉብች፣ እያሱን እልም ኑንቲፊ ሀንገፎትን በልበለ ጎሶተ እስራኤል እሳኒፍ ቆደን ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("JS14_2","007_14_2","JOS","14","2","2","ዻልሳኒ ኩንስ አኩመ ዋቀዮ ሙሴ አጀጄት እጣዻን ጎሰ ሰገሊፊ ወለካ ጎሰ ቶኮቲፍ ኬነሜ። ");
INSERT INTO gaze_vpl VALUES ("JS14_3","007_14_3","JOS","14","3","3","ሙሴን ከራ በአ ዮርዳኖሲን ጎሶተ ለማኒፊ ወለካፍ ዻለ ጎዼ ኬኔ ቱሬ፤ ጎሰ ሌዊቲፍ ገሩ ወረ ካን ግዱት ዻለ ቶኮሌ ህንኬንኔ፤ ");
INSERT INTO gaze_vpl VALUES ("JS14_4","007_14_4","JOS","14","4","4","እልማን ዮሴፍ ጎሰ ለመ ተአኒ ቱረኒቲ፤ እሳንስ ምናሴፊ ኤፍሬም። ሌዎትን ገሩ መጋላወን ኬሰ ጅራተን፣ ቡሻዬፊ ሎንሳኒ ቦባፈተን መሌ ቆደ ለፋ ቶኮሌ ህንአርገኔ። ");
INSERT INTO gaze_vpl VALUES ("JS14_5","007_14_5","JOS","14","5","5","ከናፉ እስራኤሎን አኩመ ዋቀዮ ሙሴ አጀጄት ብየ ሰነ ህረተን። ");
INSERT INTO gaze_vpl VALUES ("JS14_6","007_14_6","JOS","14","6","6","ኤርገሲስ ነሞትን ይሁዳ ግልጋልት ገረ እያሱ ዹፈን፤ ካሌብ እልም ዬፉኔ ነምች ጎሰ ቄኔዝ ሱን አከነ ጄዼን፤ “አት ዋን ዋቀዮ ቃዴሽ በርኔ ኬሰት ዋኤኬቲፊ ዋኤኮ ሙሴ ነመ ዋቃ ሰነት ዱበቴ ንቤክተ። ");
INSERT INTO gaze_vpl VALUES ("JS14_7","007_14_7","JOS","14","7","7","ዬሮ ሙሴን ገርብች ዋቀዮ ሱን አከ አን ብየቲ በሳሱፍ ቃዴሽ በርኔቲ ነ ኤርጌ ኡሙሪንኮ ወጋ አፉርተመ ቱሬ። አንስ ገባሰ ዋን ምርከኔፈዼ ሰና ነንፍዴፍ፤ ");
INSERT INTO gaze_vpl VALUES ("JS14_8","007_14_8","JOS","14","8","8","ኦቦሎትንኮ ወር ነ ወጅን አች ዸቀን ገሩ አከ ኦኔን ሰባ ሶዳዻን በቅጡ ጎዸን። ተኡስ አን ገራኮ ጉቱዻን ዋቀዮ ዋቀኮ ዱካ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("JS14_9","007_14_9","JOS","14","9","9","ከናፉ ሙሴን ጋፈስ አከነ ጄዼ ና ከከቴ፤ ‘ሰበቢ አት ገራኬ ጉቱዻን ዋቀዮ ዋቀኮ ዱካ ቡቴፍ፣ ለፍት ሚልኬ ቱቄ ሱን ሀመ በረ በራት ዻለኬቲፊ ዻለ እልማንኬቲ ተአ።’ ");
INSERT INTO gaze_vpl VALUES ("JS14_10","007_14_10","JOS","14","10","10","“ኤጋ ዋቀዮ አኩመ ዋዳ ገሌ ሰነት፣ ጋፈ ሙሴዻን አከስ ጄዼ ከን ዬሮ እስራኤል ገሞጂ ኬሰ አሲፊ አች ጆራ ቱሬ ጀልቀቤ ወጋ አፉርተሚ ሸን ነ ጅራችሴረ። ከናፉ አን ሀርአ ኩኖ ወጋ ሰዴተሚ ሸን ጉቴረ! ");
INSERT INTO gaze_vpl VALUES ("JS14_11","007_14_11","JOS","14","11","11","አን ሀርአስ አኩመ ጋፈ ሙሴን ነ ኤርጌ ሰና ጀባዸ፤ አን አኩመን ዱር ቱሬ ሰነ አመዩ ዱለ ዸቁፍ ጀባዸ። ");
INSERT INTO gaze_vpl VALUES ("JS14_12","007_14_12","JOS","14","12","12","ኤጋ አመ ብየ ጋራ ከን ዋቀዮ ጋፈ ሰነ ዋዳ ና ገሌ ከነ ና ኬን። አት መታንኬዩ አከ አናቆን አች ኬሰ ጅራተን፣ አከ መጋላወንሳኒ ጉርጉዳ ተአኒፊ ደላ ጀባን መርፈመን ጋፈስ ዸጌሴርተ፤ ዮ ዋቀዮ ነ ገርጋሬ ገሩ አን አኩመ ዋቀዮ ጄዼ ሰነት አርኤ እሳን ባሰ።” ");
INSERT INTO gaze_vpl VALUES ("JS14_13","007_14_13","JOS","14","13","13","እያሱንስ ካሌብ እልመ ዬፉኔ ኤብሴ ኬብሮንን ዻለ ጎዼ ኬኔፍ። ");
INSERT INTO gaze_vpl VALUES ("JS14_14","007_14_14","JOS","14","14","14","ከናፉ ሰበቢ እን ገራሳ ጉቱዻን ዋቀዮ ዋቀ እስራኤል ዱካ ቡኤፍ ኬብሮን ሀመ ሀርኣትዩ ዻለ ካሌብ እልመ ዬፉኔ ነምቸ ጎሰ ቄኔዝ ሰና ታቴ ሀፍቴ። ");
INSERT INTO gaze_vpl VALUES ("JS14_15","007_14_15","JOS","14","15","15","ኬብሮን ዱራን መቃ ነምቸ አርባቅ ጄዸሙ ከን አናቆተ ሁንደ ኬሳ ነመ ጉዳ ቱሬ ቶኮቲን ክርያት አርባቅ ጄዸምቴ ዋመማ ቱርቴ። ኤርገሲስ ብየቲን ወራነራ ቦቆቴ። ");
INSERT INTO gaze_vpl VALUES ("JS15_1","007_15_1","JOS","15","1","1","ቆድን ጎሰ ይሁዳቲፍ በልበለ በልበላን ረመደሜ ሀመ ዳሪ ኤዶምት፣ ቀርቀረ ክባቲንሞ ሀመ ገሞጂ ሲንት በልአተ። ");
INSERT INTO gaze_vpl VALUES ("JS15_2","007_15_2","JOS","15","2","2","ዳሪንሳኒ ከራ ክባ ገሎ ገላና ቀርቀረ ክበ ገላነ ሶግዳቲ ጀልቀቤ ");
INSERT INTO gaze_vpl VALUES ("JS15_3","007_15_3","JOS","15","3","3","ክበ መልካ አቅረቢም ቀጣሙሬ ገረ ሲን እት ፉፌ ሀመ ክበ ቃዴሽ በርኔት ዴመ። ኤርገሲስ ሄዝሮን ደርቤ አዳርት ኦል በኤ ገረ ቀርቃት ጎረ። ");
INSERT INTO gaze_vpl VALUES ("JS15_4","007_15_4","JOS","15","4","4","ኤርገሲሞ አቺ ከኤ ከራ አዝሞኒን ደርቤ ሀመ ለፈ ጎጎጋ ግብጢት ዹፌ ገላነ ገኤ ዻበተ። ዳሪንሳኒ ከን ገረ ክባ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("JS15_5","007_15_5","JOS","15","5","5","ዳሪን ገረ በኣስ ገላነ ሶግዳ ቱሬ፤ እንስ ሀመ ዹመ ለገ ዮርዳኖስት ዴመ። ዳሪን ገረ ካባሞ ገሎ ገላና ከን ቀርቀረ ዮርዳኖሲ ጀልቀቤ ");
INSERT INTO gaze_vpl VALUES ("JS15_6","007_15_6","JOS","15","6","6","ገረ ቤት ሆግላት ኦል በኤ ኤርገሲሞ ከራ ካበ ቤት አረባቲን ገረ ዸጋ ቦሀን እልመ ሩቤንት ዴመ። ");
INSERT INTO gaze_vpl VALUES ("JS15_7","007_15_7","JOS","15","7","7","ዳሪን ሱንስ ኤርገሲ ሱሉለ ኣኮር ኬሳ ዴቢርት ኦል በኤ ገረ ግልጋል ገመ ክበ ለገ ሰናቲን ፉሌ መልካ አዱሚም ሰና ካበት ጎረ። ዳሪን ኩን እቱመ ፉፌ ገረ ብሻኖተ ኤን ሼሜሽ ደርቤ ኤን ሮጌልት ገድ በአ። ");
INSERT INTO gaze_vpl VALUES ("JS15_8","007_15_8","JOS","15","8","8","ኤርገሲስ ከራ ክበ ተበ መጋላ ዬቡሶታቲን ጄቹንስ ዬሩሳሌምቲን በኤ ሱሉለ ቤን ህኖም እራን ደርበ። አቺስ በኤ ቀርቀረ ካበ ሱሉለ ሬፋይምት ፊጤ ቱሉ ገመ ልጠ ሱሉለ ህኖም ጅሩት ኦል በኤ። ");
INSERT INTO gaze_vpl VALUES ("JS15_9","007_15_9","JOS","15","9","9","ዳሪን ሱን አመስ ፊጤ ጋራራ ከኤ ገረ ቡርቃ ብሻኖተ ኔፍቶኣት ቀጄሌ መጋላወን ቱሉ ኤፍሮኒን በኤ ገረ በኣላት ጄቹንስ ክርያት ዬኣሪምት ገድ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("JS15_10","007_15_10","JOS","15","10","10","ኤርገሲ በኣላራ ቱሉ ሴኢሪት ገረ ልጣት ገረገሌ ተበ ካበ ቱሉ ይኣሪም ጄቹንስ ኬሳሎንረ በኤ እት ፉፉዻን ቤት ሼሜሽት ገድ ቡኤ ቲምናህት ደርበ። ");
INSERT INTO gaze_vpl VALUES ("JS15_11","007_15_11","JOS","15","11","11","ገረ ካበ ተበ ኤቅሮንት ደርቤ ሽኬሮንት ጎሬ ቱሉ በኣላረ ቀጣሙሩዻን ሀመ የብንኤልት ዴመ። ዳሪን ሱንስ ገላነ ገኤ ዻበቴ። ");
INSERT INTO gaze_vpl VALUES ("JS15_12","007_15_12","JOS","15","12","12","ዳሪን ገረ ልጣሞ ቀርቀረ ገላነ ጉዳት። ");
INSERT INTO gaze_vpl VALUES ("JS15_13","007_15_13","JOS","15","13","13","እያሱን አኩመ ዋቀዮ እሰ አጀጄት፣ ቆደ ይሁዳራ ኩቴ ኬብሮን ብየ ክርያት አርባቅ ጄዸምቱ ሰነ ካሌብ እልመ ዬፉኔቲፍ ኬኔ። አርባቅ ኩንስ አባ አናቅ። ");
INSERT INTO gaze_vpl VALUES ("JS15_14","007_15_14","JOS","15","14","14","ካሌብስ እልማን አናቅ ሰደን ጄቹንስ ሼሻዪን፣ አሂመኒፊ ተልማይ ሰኚ አናቅ አርኤ አቺ ባሴ። ");
INSERT INTO gaze_vpl VALUES ("JS15_15","007_15_15","JOS","15","15","15","አቺስ ነሞተ ብየ ዴቢር እሼ ዱር ክርያት ሴፌር ጄዸማ ቱርቴ ሰነ ኬሰ ጅራተንት ዱሌ። ");
INSERT INTO gaze_vpl VALUES ("JS15_16","007_15_16","JOS","15","16","16","ካሌብስ፣ “አን ነመ ክርያት ሴፌር ሎሌ ቀበቱት እንተለኮ ኣክሳ ነንሄሩምሲሰ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS15_17","007_15_17","JOS","15","17","17","ኦቦሌስ ካሌብ፣ ኦትኒኤል እልም ቄነዝ መጋለቲ ቀበቴ፤ ካሌብስ እንተለሳ ኣክሳ እሰት ሄሩምሲሴ። ");
INSERT INTO gaze_vpl VALUES ("JS15_18","007_15_18","JOS","15","18","18","እሼንስ ዬሮ ገረ ኦትኒኤል ዹፍቴት አከ እን አባሼ ለፈ ቆቲሳ ከዸቱ እሰ ከካፍቴ። ካሌብስ ዮሙ እሼን ሀሬሼራ ቡቴት፣ “አን ማል ሲፍ ጎዹ?” ጄዼ እሼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("JS15_19","007_15_19","JOS","15","19","19","እሼንስ ዴብፍቴ፣ “ዋን አዳ ቶኮ ና ጎዽ። አኩመ ኔጌብ ኬሰት ለፈ ና ኬንቴ ሰነ ቡርቃወን ብሻኒስ ና ኬን” ጄቴን። ካሌብስ ቡርቃወን ኦሊቲፊ ገዲ ኬኔፍ። ");
INSERT INTO gaze_vpl VALUES ("JS15_20","007_15_20","JOS","15","20","20","ዻል ጎስት ይሁዳ በልበለ በልበላን አርገቴ ኩኖ ከነ፦ ");
INSERT INTO gaze_vpl VALUES ("JS15_21","007_15_21","JOS","15","21","21","ኔጌብ ኬሳ መጋላወን ጎሰ ይሁዳ ከኔን ቀርቀረ ክባት ዳሪ ኤዶምረት አርገመን ከኔኒዸ፦ ቀብዝኤል፣ ኤዴር፣ ያጉር፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_22","007_15_22","JOS","15","22","22","ቂና፣ ዲሞና፣ አድኣዳ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_23","007_15_23","JOS","15","23","23","ቃዴሽ፣ ሃዞር፣ ይትናን፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_24","007_15_24","JOS","15","24","24","ዚፍ፣ ቴሌም፣ በኣሎት፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_25","007_15_25","JOS","15","25","25","ሃዞር ሀዳታ፣ ኬሪዮት ከን ሄዝሮን ጄዸምቱ ሰነ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_26","007_15_26","JOS","15","26","26","አማም፣ ሼማ፣ ሞላዳ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_27","007_15_27","JOS","15","27","27","ሀዘር ገዳ፣ ሄሽሞን፣ ቤት ጴሌጥ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_28","007_15_28","JOS","15","28","28","ሀዘር ሹኣል፣ ቤርሼባ፣ ብዝዮትያ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_29","007_15_29","JOS","15","29","29","በኣላ፣ እዪም፣ ኤዜም፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_30","007_15_30","JOS","15","30","30","ኤልቶላድ፣ ክሲል፣ ሆርማ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_31","007_15_31","JOS","15","31","31","ሲቅላግ፣ መድማና፣ ሳንሳና፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_32","007_15_32","JOS","15","32","32","ሌባኦት፣ ሺሊሂም፣ ኣይኒፊ ርሞኒዸ፤ መጋላወኒፊ ገንዶትንሳኒ ወሉማ ገለት ድግደሚ ሰገል ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_33","007_15_33","JOS","15","33","33","ከራ ሱሉለ ልጠ ቢፍቱቲንሞ፦ ኤሽታኦል፣ ዞራ፣ አሽና፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_34","007_15_34","JOS","15","34","34","ዛኖኣ፣ ኤን ገኒም፣ ተፉኣ፣ ኤናም፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_35","007_15_35","JOS","15","35","35","የርሙት፣ አዱላም፣ ሶኮ፣ አዜቃ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_36","007_15_36","JOS","15","36","36","ሸአረዪም፣ ኣድታይም፣ ጌዴራፊ ጌዴሮታይሚዸ፤ መጋላወኒፊ ገንዶትንሳኒ ኩዸ አፉር ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_37","007_15_37","JOS","15","37","37","ዜናን፣ ሀዳሻ፣ ምግዳል ጋድ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_38","007_15_38","JOS","15","38","38","ድልኣን፣ ሚስጳ፣ ዮቅትኤል፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_39","007_15_39","JOS","15","39","39","ላኪሽ፣ ቦዝቃት፣ ኤግሎን፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_40","007_15_40","JOS","15","40","40","ከቦን፣ ለህማስ፣ ኪትሊሽ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_41","007_15_41","JOS","15","41","41","ጌዴሮት፣ ቤት ዳጎን፣ ነአማፊ መቄዳዸ፤ መጋላወኒፊ ገንዶትንሳኒ ኩዸ ጀአ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_42","007_15_42","JOS","15","42","42","ልብና፣ ኤቴር፣ አሻን፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_43","007_15_43","JOS","15","43","43","ይፍታ፣ አሽና፣ ኔዚብ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_44","007_15_44","JOS","15","44","44","ቄዪላ፣ አክዚቢፊ ማሬሻዸ፤ መጋላወኒፊ ገንዶትንሳኒ ሰገል ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_45","007_15_45","JOS","15","45","45","ኤቅሮን፣ ቁበተወኒፊ ገንዶተ ናኖሼ ጅረን ወጅን፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_46","007_15_46","JOS","15","46","46","አከሱመስ ከራ ልጠ ኤቅሮኒቲን ቁበተወኒፊ ገንዶተሳኒ ከኔን ናኖ አሽዶድ ጅረን ሁንደ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_47","007_15_47","JOS","15","47","47","አሽዶድ፣ መጋላሼቲፊ ገንዶተሼ፣ ጋዛ፣ መጋላሼቲፊ ገንዶተሼ ከኔን ሀመ ለገ ግብጢፊ ሀመ ቀርቀረ ገላነ ጉድቻት ጅረኒዸ። ");
INSERT INTO gaze_vpl VALUES ("JS15_48","007_15_48","JOS","15","48","48","ብየ ጋራ ኬሰትሞ፦ ሻሚር፣ የቲር፣ ሶኮ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_49","007_15_49","JOS","15","49","49","ደና፣ ክርያት ሰና ጄቹንስ ዴቢር፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_50","007_15_50","JOS","15","50","50","ኣናብ፣ ኤሽትሞኣ፣ ኣኒም፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_51","007_15_51","JOS","15","51","51","ጎሼን፣ ሆሎኒፊ ጊሎዸ፤ መጋላወኒፊ ገንዶትንሳኒ ኩዸ ቶኮ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_52","007_15_52","JOS","15","52","52","አራብ፣ ዱማ፣ ኤሽኣን፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_53","007_15_53","JOS","15","53","53","ያኑም፣ ቤት ተፉኣ፣ አፌቃ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_54","007_15_54","JOS","15","54","54","ሁምታ፣ ኬብሮን እሼ ክርያት አርባቅ ጄዸምቱፊ ዚኦሪዸ፤ መጋላወኒፊ ገንዶትንሳኒ ሰገል ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_55","007_15_55","JOS","15","55","55","ማኦን፣ ቀርሜሎስ፣ ዚፍ፣ ዩታ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_56","007_15_56","JOS","15","56","56","ይዝርኤል፣ ዮቅድኣም፣ ዛኖኣ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_57","007_15_57","JOS","15","57","57","ቃይን፣ ግቤኣፊ ቲምናሂዸ፤ መጋላወኒፊ ገንዶትንሳኒ ኩዸን ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_58","007_15_58","JOS","15","58","58","ሀልሁል፣ ቤት ዙር፣ ጌዶር፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_59","007_15_59","JOS","15","59","59","መኣራት፣ ቤት አኖቲፊ ኤልቴቆኒዸ፤ መጋላወኒፊ ገንዶትንሳኒ ጀአ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_60","007_15_60","JOS","15","60","60","ክርያት በኣል ከን ክርያት ዬኣሪም ጄዸምቱፊ ራባዸ፤ መጋላወኒፊ ገንዶትንሼ ለመ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_61","007_15_61","JOS","15","61","61","ገሞጂ ኬሰትሞ፦ ቤት አረባ፣ ምዲን፣ ሴካካ፣ ");
INSERT INTO gaze_vpl VALUES ("JS15_62","007_15_62","JOS","15","62","62","ኒብሻን፣ መጋላ ሶግዳቲፊ ኤን ጋዲዸ፤ መጋላወኒፊ ገንዶትንሳኒ ጀአ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS15_63","007_15_63","JOS","15","63","63","ሰብን ይሁዳ ገሩ ዬቡሶተ ዬሩሳሌም ኬሰ ጅራቻ ቱረን ሰነ አርአኒ ባሱ ህንደንዴኜ፤ ዬቡሶንስ ሀመ ሀርኣት ሰበ ይሁዳ ወጅን ዬሩሳሌም ኬሰ ጅራቱ። ");
INSERT INTO gaze_vpl VALUES ("JS16_1","007_16_1","JOS","16","1","1","ቆድን ዮሴፍ ዮርዳኖስ ዬርኮ ብረት አርገምቱ፣ ከራ በአ ብሻኖተ ዬርኮቲ ከኤ ገሞጂ ኬሰ ቀጣሙሬ ብየ ጋራ ቤትኤልት ኦል በአ። ");
INSERT INTO gaze_vpl VALUES ("JS16_2","007_16_2","JOS","16","2","2","ሉዝ እሼ ቤትኤል ጄዸምቱ ሰና ከኤ ገረ ብየ አርካዎታ ከን አጣሮት ኬሰት አርገምቱ ሰናት ጬአ። ");
INSERT INTO gaze_vpl VALUES ("JS16_3","007_16_3","JOS","16","3","3","አቺሞ ገረ ልጣ ብየ የፍሌጦታት ገድ ቡኤ ቤት ሆሮን ገኤ ገረ ጌዝር እት ፉፌ ገላንቸ ገኤ ዻበተ። ");
INSERT INTO gaze_vpl VALUES ("JS16_4","007_16_4","JOS","16","4","4","አከስት ምናሴፊ ኤፍሬም፣ እልማን ዮሴፍ ዻለሳኒ አርገተን። ");
INSERT INTO gaze_vpl VALUES ("JS16_5","007_16_5","JOS","16","5","5","ቆድን ጎስት ኤፍሬም በልበለ በልበላን አርገቴ ኩኖ ከነ፦ ዳሪን ዻለሳኒ ገረ በኣቲን አጣሮት አዳሪ ከኤ ሀመ ቤት ሆሮን ገረ ኦል ኣኑት ዴሜ ");
INSERT INTO gaze_vpl VALUES ("JS16_6","007_16_6","JOS","16","6","6","ሀመ ገላናት እት ፉፈ። ከራ ካባቲን ምክሜታቲ ከኤ ከራ በኣቲን ገረ ታናት ሺሎ ጎሬ አቺን ደርቤ በአ ያኖኣት ቀጄለ። ");
INSERT INTO gaze_vpl VALUES ("JS16_7","007_16_7","JOS","16","7","7","ኤርገሲሞ ያኖኣዻ ከኤ አጣሮቲፊ ነአራት ገድ ቡኤ ዬርኮረ ናነኤ ዮርዳኖስት ገድ በአ። ");
INSERT INTO gaze_vpl VALUES ("JS16_8","007_16_8","JOS","16","8","8","ዳሪን ሱን ተፉኣዻ ከኤ ገመ ልጣቲን ለገ ቃናት ገድ ቡኤ ገላነ ገኤ ዻበተ። ዻል ጎስት ኤፍሬም በልበለ በልበላን አርገቴ ከናዸ። ");
INSERT INTO gaze_vpl VALUES ("JS16_9","007_16_9","JOS","16","9","9","ዳሪን ኩን መጋላወኒፊ ኦሎተሳኒ ከኔን ዻለ ጎሰ ምናሴ ኬሰት ጎሰ ኤፍሬሚፍ ሀምብፈመን ሁንደስ ንደበለተ። ");
INSERT INTO gaze_vpl VALUES ("JS16_10","007_16_10","JOS","16","10","10","እሳን ከነኣኖተ ጌዝር ኬሰ ጅራቻ ቱረን ሰነ አርአኒ አቺ ህንባፍኔ ቱሬ፤ ሀመ ሀርኣት ከነኣኖትን ሰበ ኤፍሬም ግዱ ጅራቱ፤ ገሩ አከ ሆጂ ሁምና ሆጄተን ድርቀሙ። ");
INSERT INTO gaze_vpl VALUES ("JS17_1","007_17_1","JOS","17","1","1","ጎስት ምናሴስ ቆደ አርገቴ፤ እን እልመ ዮሴፍ ሀንገፈ ቱሬቲ። ማኪር እልም ምናሴ ሀንገፍትች አባን ግልኣዶታ ሱን ሰበቢ ሎልቱ ጀባ ተኤፍ ግልኣዲፊ ባሻን እሳፍ ኬነመን። ");
INSERT INTO gaze_vpl VALUES ("JS17_2","007_17_2","JOS","17","2","2","ከናፉ ቆድን ኩን ሰበ ምናሴ ወረ ሀፈኒፍ ጄቹንስ በልበለ አቢኤዜር፣ ሄሌቅ፣ አስሪኤል፣ ሼኬም፣ ሄፌሪፊ ሼሚዳፍ ኬነሜ። ኩኔንስ በልበለ በልበለሳኒቲን እልማን ምናሴ እልመ ዮሴፍ ከኔን ብራት። ");
INSERT INTO gaze_vpl VALUES ("JS17_3","007_17_3","JOS","17","3","3","ዜሎፌሃድ እልም ሄፌር፣ እልም ግልኣድ፣ እልመ ማኪር፣ እልም ምናሴ ሱን እንተለን መሌ እልማን ህንቀቡ ቱሬ። መቃን እንተለንሳስ መህላ፣ ኖሂ፣ ሆግላ፣ ሚልካፊ ቲርዛ። ");
INSERT INTO gaze_vpl VALUES ("JS17_4","007_17_4","JOS","17","4","4","እሳንስ ገረ ኤሌኣዛር ሉብቻ፣ ገረ እያሱ እልመ ኑንቲፊ ገረ ሆገንቶታ ዸቀኒ “ዋቀዮ አከ እን ኦቦሎተኬኘ ግዱት ዻለ ኑ ኬኑፍ ሙሴ አጀጄረ” ጄዸን። ከናፉ እያሱን አኩመ አጀጀ ዋቀዮት ኦቦሎተ አባሳኒ ወጅን ዻለ ኬኔፍ። ");
INSERT INTO gaze_vpl VALUES ("JS17_5","007_17_5","JOS","17","5","5","ምናሴን ግልኣዲፊ ባሻን ኬሳ ገመ በአ ዮርዳኖስት ለፈ እዶ ኩዸንት ህረሙ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS17_6","007_17_6","JOS","17","6","6","ኩንስ ሰበቢ እንተለን ጎሰ ምናሴ ሱን እልማን ዺራ ግዱት ቆደ አርገተኒፍ። ለፍት ግልኣድ እልማን ምናሴ ከኔን ሀፈኒፍ ኬነምቴ። ");
INSERT INTO gaze_vpl VALUES ("JS17_7","007_17_7","JOS","17","7","7","ዳንጋን ጎሰ ምናሴ ኣሼሪ ከኤ ሀመ ምክሜታት ከን ከራ በአ ሼኬም ጅርቱ ሰናት በልአተ። ዳንጋን ሱንስ አቺ ከኤ ክባን ገድ ቡኤ ሰበ ኤን ተፉኣ ኬሰ ጅራቱስ ደበለተ። ");
INSERT INTO gaze_vpl VALUES ("JS17_8","007_17_8","JOS","17","8","8","ብይ ተፉኣ ከን ምናሴ ቱርቴ፤ ተፉኣን መታንሼ ገሩ ከራ ዳንጋ ምናሴቲን ከን እልማን ኤፍሬም ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("JS17_9","007_17_9","JOS","17","9","9","ዳንጋን ሱን ከራ ክባቲን እቱመ ፉፌ ለገ ቃና ብረ ገአ። መጋላወን ኤፍሬም ከኔን መጋላወን ምናሴ ግዱት አርገመንቱ ቱሬ፤ ዳንጋን ምናሴ ገሩ ካበ ለግቻረ ደርቤ ገላነ ብረ ገኤ ዻበተ። ");
INSERT INTO gaze_vpl VALUES ("JS17_10","007_17_10","JOS","17","10","10","ብይ ሱን ከራ ክባቲን ከን ጎሰ ኤፍሬሚት፤ ከራ ካባቲንሞ ከን ጎሰ ምናሴት። ብይ ምናሴ ሀመ ገላናት ዴሜ ከራ ካባቲን ኣሼርን፣ ከራ በኣቲንሞ ይሳኮርን ዳንጌሰ። ");
INSERT INTO gaze_vpl VALUES ("JS17_11","007_17_11","JOS","17","11","11","ምናሴንስ ይሳኮሪፊ ኣሼር ኬሳ ቤት ሼኣን፣ ይብሌኣሚፊ ሰበ ዶር፣ ኤንዶር፣ ተአናኪፊ ሜግዶ ቁበተወን ናኖሳኒ ጅረን ወጅን ቀበ ቱሬ፤ ሰደፋንሞ ናፎቲዸ። ");
INSERT INTO gaze_vpl VALUES ("JS17_12","007_17_12","JOS","17","12","12","ተኡስ ሰበቢ ከነኣኖትን ብየ ሰነ ጅራቹፍ ኩተተኒ ቱረኒፍ ጎስት ምናሴ መጋላወን ከኔን ቀበቹ ህንደንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("JS17_13","007_17_13","JOS","17","13","13","ገሩ እስራኤሎን ዮሙ ጀብነ አርገቻ ዹፈንት አከ እሳን ሆጂ ሁምና ሆጄተን ጎዸን መሌ ከነኣኖተ አቺ ህንባፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JS17_14","007_17_14","JOS","17","14","14","ነሞትን ዮሴፍስ እያሱዻን፣ “አት ማሊፍ እጣ ቶኮፊ ቆደ ቶኮ ቆፈ ዻለ ኑ ኬንቴ? ኑ ሰበ አከ መሌ ባይኤፊ ሰበ ዋቀዮ ጉድሴ ኤብሴዸ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JS17_15","007_17_15","JOS","17","15","15","እያሱንስ፣ “ዮ እስን አከ መሌ ባይአተኒ ብይ ጋራ ኤፍሬም ኩን እስንት ዽጰቴ ቦሶነ ሴናቲ ብየ ፌርዞታቲፊ ሬፋይሞታ ኬሰት እዶ ጅሬኛ ቆጴፈዻ” ጄዼ ዴብሴፍ። ");
INSERT INTO gaze_vpl VALUES ("JS17_16","007_17_16","JOS","17","16","16","ነሞትን ዮሴፍስ፣ “ብይ ጋራ ኩን ኑ ህንገኡ፤ ከነኣኖትን ለፈ ድሪራረ ጅራተን ሁንድ፣ ወር ቤት ሼኣኒፊ ቁበተወንሼ አከሱመስ ወር ሱሉለ ይዝርኤል ኬሰ ጅራተን ሁንድ ጋሪወን ስቢላ ቀበን” ጄዸኒ ዴብሰን። ");
INSERT INTO gaze_vpl VALUES ("JS17_17","007_17_17","JOS","17","17","17","እያሱን ገሩ መነ ዮሴፊን ጄቹንስ ኤፍሬሚፊ ምናሴዻን አከነ ጄዼ፤ “እስን ሰበ አከ መሌ ባይኤ ከን ሁምነ ጉዳ ቀቡዸ። እጣ ቶኮ ቆፈ ህንቀባተን። ");
INSERT INTO gaze_vpl VALUES ("JS17_18","007_17_18","JOS","17","18","18","ብየ ጋራ ከን ቦሶና ገሩ ንቀባቱ፤ ቦሶነ ጭራ፤ ብየቲንስ ሀመ ቀርቀረ ዳንጋሼት ከኑመኬሰን ታት፤ ከነኣኖትን ዮ ጋሪወን ስቢላ ቀባተኒ ጀጀቦ ተአንስ እስን አሪተኒ እሳን ባሱ ደንዴሱ።” ");
INSERT INTO gaze_vpl VALUES ("JS18_1","007_18_1","JOS","18","1","1","ጉቱማን ወልዳ እስራኤል ሺሎት ወልት ቀበሜ ዱንካነ ወል ገኢ አችት ዻበቴ። ብየቲን ሀርከሳኒ ጀለ ገልቴ፤ ");
INSERT INTO gaze_vpl VALUES ("JS18_2","007_18_2","JOS","18","2","2","ተኡስ አመሌ ጎሶትን እስራኤል ቶርበ ዻለሳኒ ህንፉዸትኔ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS18_3","007_18_3","JOS","18","3","3","ከናፉ እያሱን እስራኤሎታን አከነ ጄዼ፤ “እስን ኡቱ ብየ ዋቀዮ ዋቅን አቦቲኬሰኒ እስኒ ኬኔ ከነ ህንፉዸትን ሀመ ዮሚት ቱርቱ? ");
INSERT INTO gaze_vpl VALUES ("JS18_4","007_18_4","JOS","18","4","4","ቶኮ ቶኮ ጎሳ ኬሳ ነመ ሰዲ ሰዲ ኬነዻ። አንስ አከ እሳን ብየ ሰነ እላለኒ አኩመ ዻለ ጎሰ ሁንዳት ዋኤሼ በሬሰኒፍ እሳን ነንኤርገ። እሳንስ ኤርገሲ ገረኮት ዴብኡ። ");
INSERT INTO gaze_vpl VALUES ("JS18_5","007_18_5","JOS","18","5","5","እስን ብየ ሰነ እዶ ቶርበት ቆዱ ቀብዱ። ይሁዳን ብየ ከራ ክባ ኬሰት ሀፌ መን ዮሴፍሞ ብየ ከራ ካባት ሀፉ ቀበ። ");
INSERT INTO gaze_vpl VALUES ("JS18_6","007_18_6","JOS","18","6","6","እስን ኤርገ ዋኤ ብየ እዶ ቶርበት ቆደምቴ ሰና በሬስተኒ ቦዴ ገባሰ ነት ፍዳ፤ አንስ ፉለ ዋቀዮ ዋቀኬኛ ዱረት እጣ እስኒ ቡሰ። ");
INSERT INTO gaze_vpl VALUES ("JS18_7","007_18_7","JOS","18","7","7","ጎስት ሌዊ ገሩ ግዱኬሰንት ቆደ ለፋ ህንአርገቱ፤ ሰበቢንሳስ ተጃጅል ሉቡማ ከን እሳን ዋቀዮፍ ኬነን ሱን ዻለሳኒት። ጎስት ጋድ፣ ከን ሩቤኒፊ ወለካን ጎሰ ምናሴ ዱራኑ ከራ በአ ዮርዳኖሲን ቆደሳኒ አርገተኒ ጅሩ። ሙሴን ገርብች ዋቀዮ ሱን እሳኒፍ ኬኔ ቱሬ።” ");
INSERT INTO gaze_vpl VALUES ("JS18_8","007_18_8","JOS","18","8","8","ከናፉ ጀር ከራሳኒ ቀበተኒ ቀጄለን፤ እያሱንስ ወረ ሃለ ብየቲ በሬሱ ዸቀኒን አከነ ጄዼ፤ “ዸቃቲ ብየ ሰነ ሰከተኣቲ ዋኤሼ ገልሜሳ። ኤርገሲሞ ገረኮ ኮታ፤ አንስ አሱመ ሺሎት ፉለ ዋቀዮ ዱረት እጣ እስኒፍ ነንቡሰ።” ");
INSERT INTO gaze_vpl VALUES ("JS18_9","007_18_9","JOS","18","9","9","ከናፉ ነሞትን ሱን ከአኒ ብየ ሰነ ኬሰ ዴዴመኒ ዋኤ ሃለሼስ መጋላ መጋላዻን እዶ ቶርበት ቆደኒ ክታበ መረማረት በሬሰኒ ቁበተ ሺሎት ገረ እያሱት ዴብአን። ");
INSERT INTO gaze_vpl VALUES ("JS18_10","007_18_10","JOS","18","10","10","እያሱን ኤርገሲ ሺሎ ኬሰት ፉለ ዋቀዮ ዱረት እጣ ቡሴፍ፤ አኩመ ቆደ ጎሰ እሳኒትስ እስራኤሎታፍ ብየቲ ህሬ። ");
INSERT INTO gaze_vpl VALUES ("JS18_11","007_18_11","JOS","18","11","11","እጣን ጀልቀባ አኩመ በልበለ በልበለሳኒት ጎሰ ቤንያሚፍ በኤ። ብይ እሳን እጣዻን አርገተንስ ጎሰ ይሁዳቲፊ ጎሰ ዮሴፍ ግዱት አርገመ። ");
INSERT INTO gaze_vpl VALUES ("JS18_12","007_18_12","JOS","18","12","12","ከራ ካባቲን ዳሪንሳኒ ዮርዳኖሲ ከኤ ካበ ተበ ዬርኮረ ደርቡዻን ከራ ልጣቲን ብየ ጋራት ገድ ቡኤ ገሞጂ ቤት ኣዌኒቲን በአ። ");
INSERT INTO gaze_vpl VALUES ("JS18_13","007_18_13","JOS","18","13","13","አቺ ከኤ ክበ ተበ ሉዝት ጄቹንስ ቤትኤልት ደርቤ ገረ አጣሮት አዳር ከን ጋረ ክበ ቤት ሆሮን እሰ ገዲ ሰናት ገድ ቡአ። ");
INSERT INTO gaze_vpl VALUES ("JS18_14","007_18_14","JOS","18","14","14","ዳሪን ሱንስ ከራ ክባቲን ጋረ ቤት ሆሮንት ገረገሌ ጅሩ ሰና ከኤ ከራ ልጣቲን ገረ ክባት ጎሬ መጋላ እልማን ይሁዳ ከን ክርያት በኣል ጄቹንስ ክርያት ዬኣሪም ገአ። ኩንስ ዳንጋ ልጣት። ");
INSERT INTO gaze_vpl VALUES ("JS18_15","007_18_15","JOS","18","15","15","ዳንጋን ክባ ከራ ልጣቲን ቀርቀረ ክርያት ዬኣሪሚቲ ጀልቀበ፤ ዳንጋንሳሞ ገረ ብሻን ኔፍቶኣት ገድ ቡአ። ");
INSERT INTO gaze_vpl VALUES ("JS18_16","007_18_16","JOS","18","16","16","ዳንጋን ሱንስ ከራ ካበ ሱሉለ ሬፋይሚቲን ገረ ጋረ ሱሉለ ቤን ህኖምት ገረገሉት ገድ ቡአ። እንስ ተበ ክበ መጋላ ዬቡሶታ ብራን ገረ ሱሉለ ህኖምት እት ፉፌ ገረ ኤን ሮጌልት ገድ ቡአ። ");
INSERT INTO gaze_vpl VALUES ("JS18_17","007_18_17","JOS","18","17","17","ኤርገሲ ገረ ካባት ጎሬ ኤን ሼሜሽ ዸቀ፤ አቺ ከኤስ ገረ ጌሊሎት ከን መልካ አዱሚምት ገረ ገልቴ ጅርቱ ሰና እት ፉፌ ሀመ ዸጋ ቦሀን እልመ ሩቤን ሰናት ገድ ቡአ። ");
INSERT INTO gaze_vpl VALUES ("JS18_18","007_18_18","JOS","18","18","18","አመስ ገረ ተበ ካበ አረባት እት ፉፌ ገረ አረባት ገድ ቡአ። ");
INSERT INTO gaze_vpl VALUES ("JS18_19","007_18_19","JOS","18","19","19","ኤርገሲ ተበ ካበ ቤት ሆግላት ቀጄሌ ከራ ካበ ገሎ ገላነ ሶግዳ ከን ከራ ክባቲን አፋን ዮርዳኖስት አርገምቱቲን በአ። ኩን ዳሪ ከራ ክባት። ");
INSERT INTO gaze_vpl VALUES ("JS18_20","007_18_20","JOS","18","20","20","ለግን ዮርዳኖስስ ከራ በኣቲን ዳሪ ተአ። ");
INSERT INTO gaze_vpl VALUES ("JS18_21","007_18_21","JOS","18","21","21","መጋላወን ጎስት ቤንያም አኩመ ማቲ ማቲሳኒት አርገተን ከኔኒዸ፦ ዬርኮ፣ ቤት ሆግላ፣ ኤሜቅ ቀዚዝ፣ ");
INSERT INTO gaze_vpl VALUES ("JS18_22","007_18_22","JOS","18","22","22","ቤት አረባ፣ ዜማራይም፣ ቤትኤል፣ ");
INSERT INTO gaze_vpl VALUES ("JS18_23","007_18_23","JOS","18","23","23","ኣዊም፣ ፋራ፣ ኦፍራ፣ ");
INSERT INTO gaze_vpl VALUES ("JS18_24","007_18_24","JOS","18","24","24","ኬፈር ኣሞናይ፣ ኦፍኒፊ ጌባዸ፤ መጋላወኒፊ ገንዶትንሳኒ ኩዸ ለመ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS18_25","007_18_25","JOS","18","25","25","ግቤኦን፣ ራማ፣ ብኤሮት፣ ");
INSERT INTO gaze_vpl VALUES ("JS18_26","007_18_26","JOS","18","26","26","ሚስጳ፣ ኬፊራ፣ ሞዛ፣ ");
INSERT INTO gaze_vpl VALUES ("JS18_27","007_18_27","JOS","18","27","27","ሬቄም፣ ይርጵኤል፣ ተራላ፣ ");
INSERT INTO gaze_vpl VALUES ("JS18_28","007_18_28","JOS","18","28","28","ዜላ፣ ሃኤሌፍ፣ መጋላ ዬቡሶታ ጄቹንስ ዬሩሳሌም፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_1","007_19_1","JOS","19","1","1","እጣን ለመፋን ጎሰ ስምኦኒፍ በልበለ በልበላን በኤ። ዻልሳኒስ ዻለ ጎሰ ይሁዳ ኬሰት አርገመ። ");
INSERT INTO gaze_vpl VALUES ("JS19_2","007_19_2","JOS","19","2","2","ኩንስ፦ ቤርሼባ ዮካን ሼባ፣ ሞላዳ፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_3","007_19_3","JOS","19","3","3","ሀዘር ሹኣል፣ ባላ፣ ኤዜም፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_4","007_19_4","JOS","19","4","4","ኤልቶላድ፣ ቤቱል፣ ሆርማ፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_5","007_19_5","JOS","19","5","5","ሲቅላግ፣ ቤት መርካቦት፣ ሀዘር ሱሳ፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_6","007_19_6","JOS","19","6","6","ቤት ሌባኦቲፊ ሻሩሄን፤ መጋላወኒፊ ገንዶትንሳኒ ኩዸ ሰዲ ቱረን፤ ");
INSERT INTO gaze_vpl VALUES ("JS19_7","007_19_7","JOS","19","7","7","አይን፣ ርሞን፣ ኤቴሪፊ አሻን፣ መጋላወኒፊ ገንዶተሳኒ አፍረን፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_8","007_19_8","JOS","19","8","8","አከሱመስ ገንዶተ ናኖ መጋላወን ከኔኒ ጅረን ከኔን ሀመ ");
INSERT INTO gaze_vpl VALUES ("JS19_9","007_19_9","JOS","19","9","9","ሰበቢ ቆድን ጎሰ ይሁዳ ሀመ እሳን በርባደኒ ኦል ተኤፍ ዻል ጎሰ ስምኦን ኩን ቆደ ጎሰ ይሁዳራ ፉዸተሜ። ከናፉ ጎስት ስምኦን ይሁዳ ኬሰት ዻለ አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("JS19_10","007_19_10","JOS","19","10","10","እጣን ሰደፋን ጎሰ ዜቡሎኒፍ በልበለ በልበላን በኤ፤ ኩንስ፦ ዳሪን ዻለሳኒ ሀመ ሳሪድት ዴመ። ");
INSERT INTO gaze_vpl VALUES ("JS19_11","007_19_11","JOS","19","11","11","አቺስ ከራ ልጣቲን ገረ መሬኣላት ገድ ቡኤ ደቤሼትት ሪቀቴ ሀመ ለገ ዮቄንኣም ዱረ ጅሩ ሰናት ዴመ። ");
INSERT INTO gaze_vpl VALUES ("JS19_12","007_19_12","JOS","19","12","12","ኤርገሲስ ሳሪድራ ገረ ክስሎት ታቦር ብየ በአ ቢፍቱት አርገምቱ ሰናት ገረ በኣት ጎሬ ዳቤራትት ቀጄሌ ሀመ ያፊያት ዴመ። ");
INSERT INTO gaze_vpl VALUES ("JS19_13","007_19_13","JOS","19","13","13","አቺስ ከራ በኣቲን እት ፉፌ ገት ሄፌሪፊ ኤትቃጥን ዸቀ፤ ርሞኒን ገድ በኤ ገረ ኔኣህት ጎረ። ");
INSERT INTO gaze_vpl VALUES ("JS19_14","007_19_14","JOS","19","14","14","ዳሪን ሱንስ ከራ ካባቲን ገረ ሀናቶንት ጎሬ ሱሉለ ይፍታ ኤልት ዹመ። ");
INSERT INTO gaze_vpl VALUES ("JS19_15","007_19_15","JOS","19","15","15","ከኔን እረትስ ቃታት፣ ናሃለል፣ ሽምሮን፣ ይደላፊ ቤትልሄም ደበለመኒሩ። እሳንስ ገንዶተሳኒ ወጅን መጋላወን ኩዸ ለመ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS19_16","007_19_16","JOS","19","16","16","መጋላወን ኩኔኒፊ ገንዶትንሳኒ ዻለ ጎስት ዜቡሎን በልበለ በልበላን አርገቴዸ። ");
INSERT INTO gaze_vpl VALUES ("JS19_17","007_19_17","JOS","19","17","17","እጣን አፉረፋን ጎሰ ይሳኮሪፍ በልበለ በልበላን በኤ። ");
INSERT INTO gaze_vpl VALUES ("JS19_18","007_19_18","JOS","19","18","18","ብይሳኒስ፦ ይዝርኤል፣ ኬሱሎት፣ ሱነም፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_19","007_19_19","JOS","19","19","19","ሀፋረይም፣ ሺኦን፣ አናሀረት፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_20","007_19_20","JOS","19","20","20","ረቢት፣ ክሾን፣ ኤቤዝ፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_21","007_19_21","JOS","19","21","21","ሬሜት፣ ኤን ገኒም፣ ኤን ሀዳፊ ቤት ጰጤጥ። ");
INSERT INTO gaze_vpl VALUES ("JS19_22","007_19_22","JOS","19","22","22","ዳሪንሳኒ ታቦር፣ ሸሀዙማፊ ቤት ሼሜሽ ቱቄ ዮርዳኖስ ገኤ ዻበተ። እሳንስ ገንዶተሳኒ ወጅን መጋላወን ኩዸ ጀአ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS19_23","007_19_23","JOS","19","23","23","መጋላወን ኩኔኒፊ ገንዶትንሳኒ ዻለ ጎስት ይሳኮር በልበለ በልበላን አርገቴዸ። ");
INSERT INTO gaze_vpl VALUES ("JS19_24","007_19_24","JOS","19","24","24","እጣን ሸነፋን ጎሰ ኣሼሪፍ በልበለ በልበላን በኤ። ");
INSERT INTO gaze_vpl VALUES ("JS19_25","007_19_25","JOS","19","25","25","ብይሳኒስ፦ ሄልቃት፣ ሀሊ፣ ቤቴን፣ አክሻፍ፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_26","007_19_26","JOS","19","26","26","አላሜሌክ፣ አማዲፊ ምሽኣል። ዳንጋን ሱንስ ከራ ልጣቲን ቀርሜሎሲፊ ሺሆር ልብናት ቱቀ። ");
INSERT INTO gaze_vpl VALUES ("JS19_27","007_19_27","JOS","19","27","27","ኤርገሲ ከራ በአ ቢፍቱቲን ገረ ቤት ዳጎንት ጎሬ ዜቡሎኒፊ ሱሉለ ይፍታ ኤልት ቀበቴ ካቡልን ገረ ብታት ዺሴ ከራ ካባቲን ቤት ኤሜቂፊ ኔኢኤልት ቀጄለ። ");
INSERT INTO gaze_vpl VALUES ("JS19_28","007_19_28","JOS","19","28","28","አቺስ ከኤ ገረ ኤብሮን፣ ሬሆብ፣ ገረ ሀሞኒፊ ቃናት ኦል በኤ ሀመ ሲዶና ጉድቻት ዴመ። ");
INSERT INTO gaze_vpl VALUES ("JS19_29","007_19_29","JOS","19","29","29","ዳንጋን ሱንስ ኤርገሲ ገረ ራማት ጎሬ መጋላ ጢሮስ ከን ደላ ጀባ ቀቡ ሰና ዸቄ ገረ ሆሳት ጎሬ ከራ አክዚቢቲን ገላነ ገኤ ዻበተ፤ ");
INSERT INTO gaze_vpl VALUES ("JS19_30","007_19_30","JOS","19","30","30","ኩንስ ብየ ኡማ፣ ብየ አፌቂቲፊ ሬሆብ ደበለተ። እሳንስ ገንዶተሳኒ ወጅን መጋላወን ድግደሚ ለመ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS19_31","007_19_31","JOS","19","31","31","መጋላወን ኩኔኒፊ ገንዶትንሳኒ ዻለ ጎስት ኣሼር በልበለ በልበላን አርገቴዸ። ");
INSERT INTO gaze_vpl VALUES ("JS19_32","007_19_32","JOS","19","32","32","እጣን ጀአፋን ጎሰ ንፍታሌሚፍ በልበለ በልበላን በኤ፤ ኩንስ፦ ");
INSERT INTO gaze_vpl VALUES ("JS19_33","007_19_33","JOS","19","33","33","ዳሪንሳኒ ሄሌፊፊ ሙከ ጉዳ ዘኣናኒም ኬሰ ጅሩ ሰና ከኤ አዳሚ ኔቄቢፊ የብንኤል እራን ገረ ለቁሚት ቀጄሌ ዮርዳኖስ ገኤ ዻበተ። ");
INSERT INTO gaze_vpl VALUES ("JS19_34","007_19_34","JOS","19","34","34","ዳሪን ሱን አዝኖት ታቦርት ቀጄሌ ገረ ልጣት ጎሩዻን ሁቆቅ ገኤ ዻበተ። እንስ ከራ ክባቲን ዜቡሎን፣ ከራ ልጣቲን ኣሼር፣ ከራ በኣቲንሞ ዮርዳኖስ ቱቀ። ");
INSERT INTO gaze_vpl VALUES ("JS19_35","007_19_35","JOS","19","35","35","መጋላወን ደላ ጀባ ቀበን ከኔኒዸ፦ ዝዲም፣ ዜር፣ ሀማት፣ ረቃት፤ ክኔሬት፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_36","007_19_36","JOS","19","36","36","አዳማ፣ ራማ፣ ሃዞር፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_37","007_19_37","JOS","19","37","37","ቃዴሽ፣ ኤድሬዪ፣ ኤን ሀጦር፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_38","007_19_38","JOS","19","38","38","ይሮን፣ ምግዳል ኤል፣ ሆሬም፣ ቤት አናቲፊ ቤት ሼሜሽ። እሳንስ ገንዶተሳኒ ወጅን መጋላወን ኩዸ ሰገል ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS19_39","007_19_39","JOS","19","39","39","መጋላወን ኩኔኒፊ ገንዶትንሳኒ ዻለ ጎስት ንፍታሌም በልበለ በልበላን አርገቴዸ። ");
INSERT INTO gaze_vpl VALUES ("JS19_40","007_19_40","JOS","19","40","40","እጣን ቶርበፋን ጎሰ ዳኒፍ በልበለ በልበላን በኤ። ");
INSERT INTO gaze_vpl VALUES ("JS19_41","007_19_41","JOS","19","41","41","ብይ እሳን ዻለንስ፦ ዞራ፣ ኤሽታኦል፣ ኢር ሼሜሽ፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_42","007_19_42","JOS","19","42","42","ሸአለቢን፣ አያሎን፣ ይትላ፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_43","007_19_43","JOS","19","43","43","ኤሎን፣ ቲምናህ፣ ኤቅሮን፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_44","007_19_44","JOS","19","44","44","ኤልቴቄ፣ ግቤቶን፣ ባእላት፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_45","007_19_45","JOS","19","45","45","ይሁድ፣ ቤኔ ቤራቅ፣ ገት ርሞን፣ ");
INSERT INTO gaze_vpl VALUES ("JS19_46","007_19_46","JOS","19","46","46","ሜያርቆኒፊ ረቆን ዮጴት ገረገሌ አርገሙ ሰናዸ። ");
INSERT INTO gaze_vpl VALUES ("JS19_47","007_19_47","JOS","19","47","47","እጆሌን ዳን ገሩ ሰበቢ ለፍት ዻለን ሱን እሳንት ዽጰቴፍ ኦል በአኒ ሌሼምን ወራነኒ ቀበተን፤ ኤርገ ጎራዴዻን ዸአኒ ቦዴ እሼ ዹንፈተን። እሳንስ ሌሼም ኬሰ ቁበተኒ ዳን ጄዸኒ መቃ አባሳኒቲን እሼ ሞጋሰን። ");
INSERT INTO gaze_vpl VALUES ("JS19_48","007_19_48","JOS","19","48","48","መጋላወን ኩኔኒፊ ገንዶትንሳኒ ዻለ ጎስት ዳን በልበለ በልበላን አርገቴዸ። ");
INSERT INTO gaze_vpl VALUES ("JS19_49","007_19_49","JOS","19","49","49","እስራኤሎንስ ኤርገ ብየቲ እጣዻን ቆደምቴ ሰነ ህረኒ ፍጠኒ ቦዴ ግዱሳኒት እያሱ እልመ ኑኒቲፍ ዻለ ኬነን፤ ");
INSERT INTO gaze_vpl VALUES ("JS19_50","007_19_50","JOS","19","50","50","ዻለ ከነስ አኩመ ዋቀዮ አጀጄት ኬነን። እሳንስ መጋላ እን ጋፈቴ ኬነኒፍ፤ መጋላን ሱንስ ትምናት ሴራ ከን ብየ ጋራ ኤፍሬምት አርገምቱዸ። እንስ መጋላ ሰነ እጃሬ ኬሰ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("JS19_51","007_19_51","JOS","19","51","51","ኩኔን ብዮተ ኤሌኣዛር ሉብች፣ እያሱን እልም ኑንቲፊ ሀንገፎትን ጎሶተ እስራኤል ሺሎት ፉለ ዋቀዮ ዱረት በልበለ ዱንካነ ወል ገኢረት እጣዻን ኬነኒዸ። እሳንስ አከሲን ብየቲ ቆዱ ጡሙረን። ");
INSERT INTO gaze_vpl VALUES ("JS20_1","007_20_1","JOS","20","1","1","ኤርገሲ ዋቀዮ እያሱዻን አከነ ጄዼ፦ ");
INSERT INTO gaze_vpl VALUES ("JS20_2","007_20_2","JOS","20","2","2","“አኩመ አን ከራ ሙሴቲን እስን አጀጄ ሰነት አከ እስራኤሎን መጋላወን እት ኮሉ ገለን ፍለተን እት ህም፤ ");
INSERT INTO gaze_vpl VALUES ("JS20_3","007_20_3","JOS","20","3","3","ኩንስ አከ ነምን ተሱመ ዮካን ኡቱ እት ህንያድን ነመ አጄሴ ከምዩ እት ኮሉ ገሌ ነመ ሃሎ ዺጋ ባሱ ዱራ በኡፍ። ");
INSERT INTO gaze_vpl VALUES ("JS20_4","007_20_4","JOS","20","4","4","እን ዮሙ መጋላወን ሰነ ኬሳ ቶኮት ኮሉ ገሉት ከረ መጋለቲረ ዻበቴ ፉለ ማንጉዶተ መጋላ ሰና ዱረት ዽመሳ ህመቹ ቀበ። እሳንስ ኤርገሲ መጋላሳኒት እሰ ስመተኒ አከ እን እሳን ወጅን ጅራቱፍ እዶ ኬኑፊ ቀቡ። ");
INSERT INTO gaze_vpl VALUES ("JS20_5","007_20_5","JOS","20","5","5","ዮ ነምን ሃሎ ዺጋ ባሱ እሰ ዱካ ቡኤሌ፣ ሰበቢ እን ኡቱ እት ህንያድኒፊ ኡቱ ዱራን ጅበ ወልራ ህንቀባትን ነመ ኦላሳ አጄሴፍ፣ እሳን ነምቸ ሰነ ደበርሰኒ ኬኑ ህንቀበን። ");
INSERT INTO gaze_vpl VALUES ("JS20_6","007_20_6","JOS","20","6","6","እን ሀመ ፉለ ወልዳ ዱረ ቆሩምሳፍ ዻበቱቲፊ ሀመ ሉብን ኦል ኣናን ዬሮ ሰነት ተጃጅላ ቱሬ ዱኡት መጋላዹመ ሰነ ኬሰ ጅራቹ ቀበ። ኤርገሲ እን መነሳት፣ ገረ መጋላ ኬሳ በቀቴ ሰናት ዴብኡ ደንደአ።” ");
INSERT INTO gaze_vpl VALUES ("JS20_7","007_20_7","JOS","20","7","7","ከናፉ እሳን ብየ ጋራ ንፍታሌም ኬሳ ቃዴሽ እሼ ገሊላ ኬሳ ሰነ፣ ብየ ጋራ ኤፍሬም ኬሳ ሼኬም፣ ብየ ጋራ ይሁዳ ኬሳሞ ክርያት አርባቅ ከን ኬብሮን ጄዸምቱ ሰነ ፍለተን። ");
INSERT INTO gaze_vpl VALUES ("JS20_8","007_20_8","JOS","20","8","8","ዮርዳኖስ ገማ ከራ ልጠ ዬርኮቲን፣ ብየ ጎሰ ሩቤን ኬሳ ቤዜር እሼ ገሞጂ ድሪራ ኬሳ ሰነ፣ ብየ ጎሰ ጋድ ኬሳ ራሞት እሼ ግልኣድ ኬሰት አርገምቱ፣ ብየ ጎሰ ምናሴ ኬሳሞ ጎላን እሼ ባሻን ኬሰት አርገምቱ ሰነ ፍለተን። ");
INSERT INTO gaze_vpl VALUES ("JS20_9","007_20_9","JOS","20","9","9","መጋላወን አከ ነምን ተሰ ነመ አጄሴ ከምዩ እት በቀቱፍ እስራኤሎተ ሁንዳፊ አለጎተ ግዱሳኒ ጅራተኒፍ ፍለተመን ከኔኒዸ፤ ኩንስ አከ እን ሀመ ሀርከ ወልዳ ጅሩት ነምቸ ሃሎ ዺጋ ባሱ ሰናን ህንአጄፈምኔፍ። ");
INSERT INTO gaze_vpl VALUES ("JS21_1","007_21_1","JOS","21","1","1","ሀንገፎትን ማቲ ሌዎታ ኤሌኣዛር ሉብቸት፣ እያሱ እልመ ኑንቲፊ ሀንገፎተ ማቲወን ጎሶተ እስራኤል ካንት ዽኣተኒ ");
INSERT INTO gaze_vpl VALUES ("JS21_2","007_21_2","JOS","21","2","2","ሺሎ ከነኣን ኬሰት አርገምቱ ሰነ ኬሰት፣ “ዋቀዮ አከ እስን መጋላ ኑ ኬሰ ጅራትኑ ለፈ ትካ ከን ሆሪኬኛፍ ተኡ ወጅን ኑ ኬንተን ከራ ሙሴቲን አጀጄ ቱሬ” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("JS21_3","007_21_3","JOS","21","3","3","ከናፉ እስራኤሎን አኩመ ዋቀዮ አጀጄት ዻለ ኦፊሳኒ ኬሳ መጋላወን ከኔኒፊ ለፈ ትካ ሌዎታፍ ኬነን። ");
INSERT INTO gaze_vpl VALUES ("JS21_4","007_21_4","JOS","21","4","4","እጣን ጀልቀባ ጎሰ ቆሃቲፍ በልበለ በልበላን በኤ። ሌዎተ ሰኚ አሮን ሉብቻቲፍስ ጎሰ ይሁዳ፣ ጎሰ ስምኦኒፊ ጎሰ ቤንያም ኬሳ መጋላወን ኩዸ ሰዲ እጣዻን አርገተን። ");
INSERT INTO gaze_vpl VALUES ("JS21_5","007_21_5","JOS","21","5","5","ሰኚ ቆሃት ወረ ሀፈኒፍሞ በልበለ ጎሰ ኤፍሬም፣ ጎሰ ዳኒፊ ወለካ ጎሰ ምናሴ ኬሳ መጋላወን ኩዸን እጣዻን አርገተን። ");
INSERT INTO gaze_vpl VALUES ("JS21_6","007_21_6","JOS","21","6","6","ሰኚወን ጌርሾኒፍ በልበለ ጎሰ ይሳኮር፣ ጎሰ ኣሼር፣ ጎሰ ንፍታሌሚፊ ወለካ ጎሰ ምናሴ ከን ባሻን ኬሳ ሰነራ መጋላወን ኩዸ ሰዲ እጣዻን አርገተን። ");
INSERT INTO gaze_vpl VALUES ("JS21_7","007_21_7","JOS","21","7","7","ሰኚወን ሜራሪስ በልበለ በልበላን ጎሰ ሩቤን፣ ጎሰ ጋዲፊ ጎሰ ዜቡሎን ኬሳ መጋላወን ኩዸ ለመ እጣዻን አርገተን። ");
INSERT INTO gaze_vpl VALUES ("JS21_8","007_21_8","JOS","21","8","8","ከናፉ እስራኤሎን አኩመ ዋቀዮ ከራ ሙሴቲን አጀጄ ሰነት መጋላወን ከኔኒፊ ለፈ ትካ እጣዻን ሌዎታፍ ኬነን። ");
INSERT INTO gaze_vpl VALUES ("JS21_9","007_21_9","JOS","21","9","9","ጎሰ ይሁዳፊ ጎሰ ስምኦንራ መጋላወን ከኔን መቃ መቃዻን ቆደን፤ ");
INSERT INTO gaze_vpl VALUES ("JS21_10","007_21_10","JOS","21","10","10","ሰበቢ እጣን ጀልቀባ እሳኒፍ በኤፍ መጋላወን ኩኔን ሰኚወን አሮን ወረ ሌዎታ ኬሳ በልበለ ቆሃት ተአኒፍ ኬነመን፦ ");
INSERT INTO gaze_vpl VALUES ("JS21_11","007_21_11","JOS","21","11","11","እሳንስ ክርያት አርባቅ ጄቹንስ ኬብሮን እሼ ብየ ጋራ ይሁዳ ኬሳ ሰነ ለፈ ትካ ናኖሼ ወጅን ኬነኒፍ። አርባቅ አባ አናቅ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JS21_12","007_21_12","JOS","21","12","12","ለፈ ቆቲሳፊ ገንዶተ ናኖ መጋለቲ ጅረን ገሩ ካሌብ እልመ ዬፉኔቲፍ ሀንዹራ ጎዸኒ ኬነን። ");
INSERT INTO gaze_vpl VALUES ("JS21_13","007_21_13","JOS","21","13","13","ከናፉ ሰኚወን አሮን ሉብቻቲፍ ኬብሮን ጄቹንስ መጋላ ነምን ነመ አጄሴ ህመተሙ ቶኮ እት በቀቱፊ ልብና፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_14","007_21_14","JOS","21","14","14","የቲር፣ ኤሽትሞኣ፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_15","007_21_15","JOS","21","15","15","ሆሎን፣ ዴቢር፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_16","007_21_16","JOS","21","16","16","ኣይን፣ ዩታኒፊ ቤት ሼሜሽ ለፈ ትካ ወጅን ኬነሜፍ፤ እሳን ኩኔን መጋላወን ሰገለን ጎሶተ ለማንራ ቆደመኒፊዸ። ");
INSERT INTO gaze_vpl VALUES ("JS21_17","007_21_17","JOS","21","17","17","ጎሰ ቤንያም እራስ ግቤኦን፣ ጌባእ፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_18","007_21_18","JOS","21","18","18","አናቶቲፊ አልሞን ለፈ ትካ ወጅን ኬነኒፍ፤ እሳንስ መጋላወን አፉሪዸ። ");
INSERT INTO gaze_vpl VALUES ("JS21_19","007_21_19","JOS","21","19","19","መጋላወን ለፈ ትካ ወጅን ሰኚወን አሮን ከኔን ሉቦተ ተአኒፍ ኬነመን ሁንድ ኩዸ ሰዲ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS21_20","007_21_20","JOS","21","20","20","ቆሃቶተ በልበለ ሌዊ ወረ ሀፈኒፍ ጎሰ ኤፍሬምራ መጋላወን ከኔንቱ እጣዻን አርገተን፦ ");
INSERT INTO gaze_vpl VALUES ("JS21_21","007_21_21","JOS","21","21","21","እሳንስ ብየ ጋራ ኤፍሬም ኬሳ ሼኬም ጄቹንስ መጋላ ነምን ነመ አጄሴ ህመተሙ እት በቀቱ ሰናፊ ጌዝር፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_22","007_21_22","JOS","21","22","22","ቅብጣይሚፊ ቤት ሆሮን፣ ወሉመት መጋላወን አፉር ለፈ ትካ ወጅን ፉዸተን። ");
INSERT INTO gaze_vpl VALUES ("JS21_23","007_21_23","JOS","21","23","23","አከሱመስ ጎሰ ዳን ኬሳ ኤልቴቄ፣ ግቤቶን፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_24","007_21_24","JOS","21","24","24","አያሎኒፊ ገት ርሞን፣ ወሉማ ገለት መጋላወን አፉር ለፈ ትካ ወጅን ፉዸተን። ");
INSERT INTO gaze_vpl VALUES ("JS21_25","007_21_25","JOS","21","25","25","ወለካ ጎሰ ምናሴ ኬሳሞ ተአናኪፊ ገት ርሞን፣ መጋላወን ለመ ለፈ ትካ ወጅን ፉዸተን። ");
INSERT INTO gaze_vpl VALUES ("JS21_26","007_21_26","JOS","21","26","26","መጋላወን ኩርነን ኩኔን ሁንዲፊ ለፍት ትካሳኒ በልበለ ጎሰ ቆሃት ወረ ሀፈኒፍ ኬነመን። ");
INSERT INTO gaze_vpl VALUES ("JS21_27","007_21_27","JOS","21","27","27","ጌርሾኖተ በልበለ ሌዊቲፍሞ፦ ወለካ ጎሰ ምናሴ ኬሳ፣ ጎላን እሼ ባሻን ኬሳ ጄቹንስ መጋላ ነምን ነመ አጄሴ ህመተሙ ቶኮ እት በቀቱ ሰናፊ ቤኤሽትራ፣ መጋላወን ለማፊ ለፈ ትካ እሳኒቱ ኬነሜፍ፤ ");
INSERT INTO gaze_vpl VALUES ("JS21_28","007_21_28","JOS","21","28","28","ጎሰ ይሳኮር ኬሳ ክሾን፣ ዳቤራት፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_29","007_21_29","JOS","21","29","29","የርሙቲፊ ኤን ገኒም፣ መጋላወን አፉሪፊ ለፈ ትካ እሳኒቱ ኬነሜፍ፤ ");
INSERT INTO gaze_vpl VALUES ("JS21_30","007_21_30","JOS","21","30","30","ጎሰ ኣሼር ኬሳ ምሽኣል፣ አብዶን፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_31","007_21_31","JOS","21","31","31","ሄልቃቲፊ ሬሆብ፣ መጋላወን አፉሪፊ ለፈ ትካ እሳኒቱ ኬነሜፍ፤ ");
INSERT INTO gaze_vpl VALUES ("JS21_32","007_21_32","JOS","21","32","32","ጎሰ ንፍታሌም ኬሳ ቃዴሽ እሼ ገሊላ ኬሳ፣ መጋላን ነምን ነመ አጄሴ ህመተሙ ቶኮ እት ኮሉ ገሉ አከሱመስ ሀሞት ዶሪፊ ቀርታን፣ መጋላወን ሰዲ ለፈ ትካሳኒ ወጅን ኬነሜፍ። ");
INSERT INTO gaze_vpl VALUES ("JS21_33","007_21_33","JOS","21","33","33","ጎሶተ ጌርሾኖታቲፍሞ መጋላወን ኩዸ ሰዲቱ ለፈ ትካ ወጅን ኬነሜ። ");
INSERT INTO gaze_vpl VALUES ("JS21_34","007_21_34","JOS","21","34","34","ሌዎተ ሀፈን ወረ በልበለ ሜራሪ ተአኒፍ፦ ጎሰ ዜቡሎን ኬሳ፣ ዮቄንኣም፣ ቀርታ፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_35","007_21_35","JOS","21","35","35","ድምናፊ ናሃለል፣ መጋላወን አፉርቱ ለፈ ትካ ወጅን ኬነሜ፤ ");
INSERT INTO gaze_vpl VALUES ("JS21_36","007_21_36","JOS","21","36","36","ጎሰ ሩቤን ኬሳ ቤዜር፣ ያህዛ፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_37","007_21_37","JOS","21","37","37","ቅዴሞቲፊ ሜፍኣት፣ መጋላወን አፉር ለፈ ትካ ወጅን ኬነሜፍ፤ ");
INSERT INTO gaze_vpl VALUES ("JS21_38","007_21_38","JOS","21","38","38","ጎሰ ጋድ ኬሳሞ፣ ራሞት እሼ ግልኣድ ኬሳ ጄቹንስ መጋላ ነምን ነመ አጄሴ ህመተሙ ቶኮ እት ኮሉ ገሉ፣ መሀነዪም፣ ");
INSERT INTO gaze_vpl VALUES ("JS21_39","007_21_39","JOS","21","39","39","ሄሽቦኒፊ የእዜር፣ ወሉማ ገለት መጋላወን አፉርቱ ለፈ ትካ ወጅን ኬነሜፍ። ");
INSERT INTO gaze_vpl VALUES ("JS21_40","007_21_40","JOS","21","40","40","ሌዎተ ሀፈን ወረ በልበለ ሜራሪ ተአኒፍ ወሉማ ገለት መጋላወን ኩዸ ለመቱ እጣዻን ኬነሜ። ");
INSERT INTO gaze_vpl VALUES ("JS21_41","007_21_41","JOS","21","41","41","መጋላወን ሌዎታ ከኔን ብየ እስራኤሎን ዹንፈተን ኬሰት አርገመን ለፈ ትካ ወጅን ወሉማ ገለት አፉርተሚ ሰዴት ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JS21_42","007_21_42","JOS","21","42","42","ቶኮን ቶኮን መጋላወን ከኔኒ ናኖሳኒቲ ለፈ ትካ ቀቡ ቱረን፤ መጋላወን ሁንድኑ አከኑመ። ");
INSERT INTO gaze_vpl VALUES ("JS21_43","007_21_43","JOS","21","43","43","ከናፉ ዋቀዮ ብየ አቦቲሳኒቲፍ ኬኑፍ ከከቴ ሁንደ ሰበ እስራኤሊፍ ኬኔ፤ እሳንስ ብየ ሰነ ቀበተኒ አች ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("JS21_44","007_21_44","JOS","21","44","44","ዋቀዮ አኩመ አቦቲሳኒቲፍ ከከቴ ሰነ ከራ ሁንዳን ቦቆናሳኒ ኬኔ። ዲንሳኒ ቶኮዩ ፉለሳኒ ዱረ ዻበቹ ህንደንዴኜ፤ ዋቀዮ ዲኖተሳኒ ሁንደ ደበርሴ ሀርከሳኒት ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("JS21_45","007_21_45","JOS","21","45","45","ዋዳ ጋሪ ዋቀዮ መነ እስራኤሊፍ ገሌ ኬሳ ቶኮዩ ህንሀፍኔ፤ ሁንድኑ ጉተሜረ። ");
INSERT INTO gaze_vpl VALUES ("JS22_1","007_22_1","JOS","22","1","1","ኤርገሲ እያሱን ጎሰ ሩቤን፣ ጎሰ ጋዲፊ ወለካ ጎሰ ምናሴ ወልት ዋሜ ");
INSERT INTO gaze_vpl VALUES ("JS22_2","007_22_2","JOS","22","2","2","አከነ ጄዼን፤ “እስን ዋን ሙሴን ገርብች ዋቀዮ አጀጄ ሁንዱማ ሆጄተኒርቱ፤ ዋን አን እስን አጀጄ ሁንደስ ና አጀጀምተኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("JS22_3","007_22_3","JOS","22","3","3","እስን በረ ዼራፍ፣ ሀመ ሀርኣትሌ ኦቦሎተኬሰን ህንደገትኔ፤ አጀጀ ዋቀዮ ዋቅንኬሰን እስኒ ኬኔስ ኤግደኒርቱ። ");
INSERT INTO gaze_vpl VALUES ("JS22_4","007_22_4","JOS","22","4","4","ዋቀዮ ዋቅንኬሰን አኩመ ዋዳ ገሌ ሰነት ኦቦሎተኬሰን ቦቆቺሴረ፤ እስን ብየ ሙሴን ገርብች ዋቀዮ ዮርዳኖስ ገማ እስኒ ኬኔ ሰነት ገረ መነኬሰኒት ዴብኣ። ");
INSERT INTO gaze_vpl VALUES ("JS22_5","007_22_5","JOS","22","5","5","ገሩ አከ ዋቀዮ ዋቀኬሰን ጃለተኒፍ፣ አከ ከራሳ ሁንደረ ዴምተኒፍ፣ አከ አጀጀወንሳ ኤግደኒፍ፣ አከ እሰት መጠንተኒፊ አከ ገራኬሰን ጉቱፊ ሉቡኬሰን ጉቱዻን እሰ ተጃጅልተኒፍ አጀጃፊ ሴረ ሙሴን ገርብች ዋቀዮ እስኒ ኬኔ ሰነ ጀቤሳ ኤጋ።” ");
INSERT INTO gaze_vpl VALUES ("JS22_6","007_22_6","JOS","22","6","6","ኤርገሲስ እያሱን ኤብሴ ገድ እሳን ዺሴ፤ እሳንስ ገረ መነሳኒት ዴብአን። ");
INSERT INTO gaze_vpl VALUES ("JS22_7","007_22_7","JOS","22","7","7","ሙሴን ወለካ ጎሰ ምናሴቲፍ ባሻን ኬሳ ለፈ ኬኔ ቱሬ፤ እያሱንሞ ወለካ ካኒፍ ዮርዳኖሲን ገመ ልጣት ኦቦሎተሳኒ ጭነት ለፈ ኬኔ። እያሱን ዮሙ ገረ መነሳኒት እሳን ኤርጌት እሳን ኤብሴ፤ ");
INSERT INTO gaze_vpl VALUES ("JS22_8","007_22_8","JOS","22","8","8","አከነስ ጄዼን፤ “ቀቤኘኬሰን ጉዳ ጄቹንስ ሆሪ ባይኤ፣ ሜቲ፣ ወርቄ፣ ናሲፊ ስቢለ አከሱመስ ኡፈተ ባይኤ ፉዸዻ ገላቲ ቦጁ ዲኖተኬሰንራ ቦጅተን ሰነ ኦቦሎተኬሰን ወጅን ቆደዻ።” ");
INSERT INTO gaze_vpl VALUES ("JS22_9","007_22_9","JOS","22","9","9","ከናፉ ጎስት ሩቤን፣ ጎስት ጋዲፊ ወለካን ጎሰ ምናሴ ገረ ብየ ኦፊሳኒ ገረ ግልኣድ እሼ አኩመ ዋቀዮ ከራ ሙሴቲን አጀጄት አርገተን ሰናት ዴብኡፍ ጄዸኒ ሺሎ እሼ ከነኣን ኬሳ ሰነት እስራኤሎተ ዺሰኒ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("JS22_10","007_22_10","JOS","22","10","10","ጎስት ሩቤን፣ ጎስቲ ጋዲፊ ወለካን ጎሰ ምናሴ ዮሙ ገሊሎት ብየ ከነኣን ኬሳ ከን ዮርዳኖስ ብራ ሰነ ገአንት፣ እዶ ኣርሳ ጉዳሳ ዮርዳኖስ ብረት ቶልቸን። ");
INSERT INTO gaze_vpl VALUES ("JS22_11","007_22_11","JOS","22","11","11","እስራኤሎትን ዮሙ አከ እሳን ገመ እስራኤሎታቲን ዳሪ ከነኣንረት ገሊሎት እሼ ዮርዳኖስ ጭና ሰነት እዶ ኣርሳ ቶልቸን ዸገአንት፣ ");
INSERT INTO gaze_vpl VALUES ("JS22_12","007_22_12","JOS","22","12","12","ጉቱማን ወልዳ እስራኤል እሳንት ዱሉፍ ሺሎት ወልት ቀበመን። ");
INSERT INTO gaze_vpl VALUES ("JS22_13","007_22_13","JOS","22","13","13","ከናፉ እስራኤሎትን ፊኔሃስ እልመ ኤሌኣዛር ሉብቻ ሰነ ገረ ጎሰ ሩቤን፣ ጎሰ ጋዲፊ ገረ ወለካ ጎሰ ምናሴ ወረ ግልኣድ ኬሰ ጅራተንት ኤርገን። ");
INSERT INTO gaze_vpl VALUES ("JS22_14","007_22_14","JOS","22","14","14","እሰ ወጅንስ ሀንገፎተ ኩዸን፣ ቶኮ ቶኮ ጎሰ እስራኤሊፍ ነመ ቶኮ ኤርገን፤ ቶኮን ቶኮንሳኒስ ሀንገፈ በልበለ ማቲ እስራኤል። ");
INSERT INTO gaze_vpl VALUES ("JS22_15","007_22_15","JOS","22","15","15","እሳንስ ግልኣድት ጎሰ ሩቤን፣ ጎሰ ጋዲፊ ወለካ ጎሰ ምናሴ ብረ ዹፈኒ አከነ እሳኒን ጄዸን፦ ");
INSERT INTO gaze_vpl VALUES ("JS22_16","007_22_16","JOS","22","16","16","“ጉቱማን ወልዳ ዋቀዮ አከነ ጄዸ፦ ‘እስን አከምት አከናን አመነሙማ ዋቀ እስራኤል ወጅን ቀብደን ሰነ ጨብስቱ? እስን አከምት ዋቀዮራ ገረገልተኒ እሰት ፍንጭሉዻን ኦፊኬሰኒፍ እዶ ኣርሳ ቶልፈቱ? ");
INSERT INTO gaze_vpl VALUES ("JS22_17","007_22_17","JOS","22","17","17","ጩቡን ጴኦር ኬሰት ሆጄተሜ ሱን ኑ ህንገኡ? ዸእች ሰበ ዋቀዮረ ቡኡዩ፣ ኑ ሀመ ሀርኣት ጩቡ ሰነራ ኦፍ ህንቁልቁሌስኔ። ");
INSERT INTO gaze_vpl VALUES ("JS22_18","007_22_18","JOS","22","18","18","እስን አመስ ዋቀዮራ ገረገሉኬሰኒ? “ ‘ዮ እስን ሀርአ ዋቀዮት ፍንጭልተን እንሞ ቦር ሀዋሰ እስራኤል ሁንደት ንዼከመ። ");
INSERT INTO gaze_vpl VALUES ("JS22_19","007_22_19","JOS","22","19","19","ዮ ለፍት እስን ቀበተን ሱን ጡሮፍቴ፣ ገረ ለፈ ዋቀዮ እዶ ዱንካን ዋቀዮ ዻበቱ ኮታቲ ኑ ወጅን ለፈ ቆደዻ። ገሩ እዶ ኣርሳ ዋቀዮ ዋቀኬኛ መሌ እዶ ኣርሳ ብራ ኦፊኬሰኒ ቶልፈተኒ ዋቀዮት ዮካን ኑት ህንፍንጭልና። ");
INSERT INTO gaze_vpl VALUES ("JS22_20","007_22_20","JOS","22","20","20","ዬሮ ኣካን እልም ዛራ ዋን ዾወማ ተኤ ፉዸቹዻን ጩቡ ሆጄቴት ወልዳ እስራኤል ሁንደት ዼከምስ ህንዹፍኔ? ነምን ሰበቢ ጩቡሳቲን ዱኤ እሰ ቆፈ ምት።’ ” ");
INSERT INTO gaze_vpl VALUES ("JS22_21","007_22_21","JOS","22","21","21","ከነረት ጎስት ሩቤን፣ ጎስት ጋዲፊ ወለካን ጎሰ ምናሴ አከነ ጄዸኒ ሀንገፎተ ማቲወን እስራኤሊፍ ዴብሰን፤ ");
INSERT INTO gaze_vpl VALUES ("JS22_22","007_22_22","JOS","22","22","22","“ዋቀዮ ዋቅን ዋቆታ፣ ዋቀዮ ዋቅን ዋቆታ ንቤከ! እስራኤልስ ሃቤኩ! ዮ ወን ኩን ዋቀዮት ፍንጭሉፍ ዮካንሳ አጀጀሙ ድዱፍ ተኤ ሀርአ ኑ ህንሀምብስን። ");
INSERT INTO gaze_vpl VALUES ("JS22_23","007_22_23","JOS","22","23","23","ዮ ኑ ዋቀዮራ ዴብኡፍ ጄኔ፣ ኣርሳ ጉበሙፊ ኬና ምዻኒ፣ ዮካን ኣርሳ ነጋ አችረት ዽኤሱፍ እዶ ኣርሳ ኦፊኬኛ ቶልፈትኔ ጅራትኔ፣ ዋቀዮ መታንሳ እት ኑ ሃጋፈቱ። ");
INSERT INTO gaze_vpl VALUES ("JS22_24","007_22_24","JOS","22","24","24","“ሰበቢን ኑ ዋን ከነ ጎኔፍ እጆሌንኬሰን ገረ ፉለ ዱራት እጆሌኬኛን አከነ ጄዹ ተአ ጄኔ ሶዳትኔት፤ ‘እስን ዋቀዮ ዋቀ እስራኤልራ ማል ቀብዱ? ");
INSERT INTO gaze_vpl VALUES ("JS22_25","007_22_25","JOS","22","25","25","ዋቀዮ ኑፊ እስን ጄቹንስ እስን ጎሰ ሩቤኒፊ ጎሰ ጋድ ግዱ ዮርዳኖስ ዳሪ ጎዼ ዻቤረ! እስን ዋቀዮራ ቆደ ቶኮሌ ህንቀብደን።’ ከናፉ እጆሌንኬሰን አከ እጆሌንኬኘ ዋቀዮን ሶዳቹ ዺሰን ጎዹ ተአ። ");
INSERT INTO gaze_vpl VALUES ("JS22_26","007_22_26","JOS","22","26","26","“ሰበቢን ኑ፣ ‘ኮታ ቆጶፍኔ እዶ ኣርሳ ቶኮ ቶልፈትና፤ ገሩ እዶን ኣርሳ ኩን ከን ኣርሳን ጉበሙ ዮካን ቀልምረት ዽኤፈሙ ምት’ ጄኔፍስ ከኑመ። ");
INSERT INTO gaze_vpl VALUES ("JS22_27","007_22_27","JOS","22","27","27","ከራ ብራሞ አከ እዶን ኣርሳ ኩን አከ ኑ ኣርሳኬኘ ከን ጉበሙ፣ ቀልመኬኛፊ ኣርሳ ነጋቲን እዶ ቁልቁሉሳት ዋቀዮን ዋቄፈኑፍ ኑ፣ እስኒፊ ዸሎተ ዹፉ ግዱት ዹጋ ባቱ ተኡፍ። ከነ ቦዴ እጆሌንኬሰን እጆሌኬኛን፣ ‘እስን ዋቀዮራ ቆደ ቶኮሌ ህንቀብደን’ ጄቹ ህንደንደአን። ");
INSERT INTO gaze_vpl VALUES ("JS22_28","007_22_28","JOS","22","28","28","“ኑስ አከነ ጄኔ፤ ‘ዮ እሳን በሮተ ዹፉፍ ጅረን ኬሰ ኑን ዮካን ዸሎተኬኛን አከስ ጄዸን፣ ሜ ፈኪ እዶ ኣርሳ ዋቀዮ ከን አቦቲንኬኘ ኣርሳ ጉበሙ ዮካን ቀልመረት ዽኤሱፍ ኡቱ ህንተእን አከ እን ኑፊ እስን ግዱት ዹገ ባቱ ተኡፍ ቶልቸን ከነ እላላ ጄናን።’ ");
INSERT INTO gaze_vpl VALUES ("JS22_29","007_22_29","JOS","22","29","29","“እዶ ኣርሳ ዋቀዮ ዋቀኬኛ ከን ዱንካነሳ ቁልቁሉ ዱረ ዻበቱ ሰነ መሌ ሀርአ እዶ ኣርሳ ከን ኣርሳን ጉበሙ፣ ኬናን ምዻኒቲፊ ቀልምረት ዽኤፈሙ ከን ብራ ቶልቹዻን ዋቀዮት ፍንጭሌ እሰራ ገረገሉን ኑራ ሃፈጋቱ።” ");
INSERT INTO gaze_vpl VALUES ("JS22_30","007_22_30","JOS","22","30","30","ፊኔሃስ ሉብች፣ ቀጄልችቶትን ሰባቲፊ ሀንገፎትን ማቲወን እስራኤል ዮሙ ዋን ጎስት ሩቤን፣ ጎስት ጋዲፊ ጎስት ምናሴ ጄዸን ዸገአንት ንገመደን። ");
INSERT INTO gaze_vpl VALUES ("JS22_31","007_22_31","JOS","22","31","31","ፊኔሃስ እልም ኤሌኣዛር ሉብቻስ እጆሌ ሩቤኒን፣ እጆሌ ጋዲፊ እልማን ምናሴቲን፣ “ኑ ሀርአ ሰበቢ እስን ዋን ከነ ኬሰት ዋቀዮፍ አመነሙማ ህንዺስኒፍ አከ ዋቀዮ ኑ ወጅን ጅሩ ቤክኔረ። እስን አመ እስራኤሎተ ሀርከ ዋቀዮ ጀላ ባፍተኒርቱ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS22_32","007_22_32","JOS","22","32","32","ኤርገሲስ ፊኔሃስ እልም ኤሌኣዛር ሉብቻፊ ቀጄልችቶትን ሱን እጆሌ ሩቤኒፊ እጆሌ ጋድ ወጅን ግልኣድት ወል ገኢ ጎዸተኒ ገረ ከነኣንት ዴብአኒ ኦዱ አቺ ፍደን እስራኤሎተት ህመን። ");
INSERT INTO gaze_vpl VALUES ("JS22_33","007_22_33","JOS","22","33","33","እሳንስ ኦዱ ከነ ዸገአኒ ገመደኒ ዋቀ ገለቴፈተን። ለመተስ እት ዴብአኒ ዋኤ እሳንት ዱሉፊ ብየ ጎስት ሩቤኒፊ ጎስት ጋድ ኬሰ ጅራቱ ሰነ በሌሱ ህንዱበትኔ። ");
INSERT INTO gaze_vpl VALUES ("JS22_34","007_22_34","JOS","22","34","34","ጎስት ሩቤኒፊ ጎስት ጋድስ መቃ ከናን እዶ ኣርሳ ሰነ ሞጋሰን፦ እዶን ኣርሳ ኩን አከ ዋቀዮ ዋቀ ተኤ ኑ ግዱት ዹጋ ባቱዸ። ");
INSERT INTO gaze_vpl VALUES ("JS23_1","007_23_1","JOS","23","1","1","ኤርገ በር ዼራን ደርቤ ዋቀዮስ ዲኖተ እሳን መርሰን ሁንደራ እስራኤሎተ ቦቆቺሴ ቦዴ እያሱን በረ ዼራ ጅራቴ ዱሎሜ፤ ");
INSERT INTO gaze_vpl VALUES ("JS23_2","007_23_2","JOS","23","2","2","እንስ እስራኤሎተ ሁንደ ጄቹንስ ማንጉዶተሳኒ፣ ሆገንቶተሳኒ፣ አቦቲ ሙርቲ እሳኒቲፊ ቆንዳልቶተሳኒ ኦፍት ዋሜ አከነ ጄዼን፦ “ኩኖ አን በረ ዼራ ጅራዼ ዱሎሜረ። ");
INSERT INTO gaze_vpl VALUES ("JS23_3","007_23_3","JOS","23","3","3","እስን መታን ኬሰኑ ዋን ዋቀዮ ዋቅንኬሰን እስኒፍ ጄዼ ሰቦተ ከነ ጎዼ ሁንዱማ አርግተኒርቱ፤ ዋቀዮ ዋቀኬሰንቱ እስኒፍ ሎሌ። ");
INSERT INTO gaze_vpl VALUES ("JS23_4","007_23_4","JOS","23","4","4","አከ አን እት ብየ ሰቦተ ሀፈኒ ጄቹንስ ብየ ሰቦተ አን ዮርዳኖሲ ጀልቀቤ ሀመ ልጠ ገላነ ጉድቻት ሞአዼ ሰና ሁንደ ጎሶተኬሰኒፍ ዻለ ጎዼ ኬኔ ሜ ያደዻ። ");
INSERT INTO gaze_vpl VALUES ("JS23_5","007_23_5","JOS","23","5","5","ዋቀዮ ዋቅንኬሰን መታንሳዩ ፉለኬሰን ዱራ አርኤ እሳን ባሰ። እን ፉለኬሰን ዱራ ዺቤ እሳን ባሰ፤ እስንሞ አኩመ ዋቀዮ ዋቅንኬሰን እስን አብደቺሴ ሰነት ብየሳኒ ቀበቱ። ");
INSERT INTO gaze_vpl VALUES ("JS23_6","007_23_6","JOS","23","6","6","“ጀባዻ ዻበዻ፤ አከ ዋን ክታበ ሴረ ሙሴ ኬሰት በሬፈሜ ሁንደ፣ ኡቱ ገረ ምርጋት ዮካን ብታት ህንጀልአትን ጀቤሳ ኤጋ። ");
INSERT INTO gaze_vpl VALUES ("JS23_7","007_23_7","JOS","23","7","7","ሰቦተ ግዱኬሰንት ሀፈን ከኔንት ህንመከምና፤ መቃ ዋቆተሳኒ ህንዸእና ዮካን እቲን ህንከከትና። ዋቆተ ሰነ ህንተጃጅልና ዮካን እሳኒፍ ህንሰገድና። ");
INSERT INTO gaze_vpl VALUES ("JS23_8","007_23_8","JOS","23","8","8","ገሩ አኩመ ሀመ ሀርኣት ጎቻ ቱርተን ሰነ ጀባዻ ዋቀዮ ዋቀኬሰንት መጠና። ");
INSERT INTO gaze_vpl VALUES ("JS23_9","007_23_9","JOS","23","9","9","“ዋቀዮ ሰቦተ ጉርጉዳፊ ሁምነ ቀቤዪ ፉለኬሰን ዱራ አርኤ ባሴረ፤ ሀመ አማት ነምን ቶኮዩ እስን ዱረ ዻበቹ ህንደንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("JS23_10","007_23_10","JOS","23","10","10","ሰበቢ ዋቀዮ ዋቅንኬሰን አኩመ ዋዳ ገሌ ሰነ እስኒ ሎሉፍ ነምንኬሰን ቶክች ነመ ኩመ ቶኮ አርአ። ");
INSERT INTO gaze_vpl VALUES ("JS23_11","007_23_11","JOS","23","11","11","ከናፉ ዋቀዮ ዋቀኬሰን ጭምሳ ጃለዻ። ");
INSERT INTO gaze_vpl VALUES ("JS23_12","007_23_12","JOS","23","12","12","“ገሩ ዮ እስን ከራራ ጀልአተኒ ሀምባ ሰቦተ ግዱኬሰን ጅራተን ከኔኒት መጠንተን፣ ዮ እስን እሳኒን ወልፉተኒ እሳንት መከምተን፣ ");
INSERT INTO gaze_vpl VALUES ("JS23_13","007_23_13","JOS","23","13","13","አከ ዋቀዮ ዋቅንኬሰን ስአች ሰቦተ ከኔን እስን ዱራ አርኤ ህንባፍኔ ቤከዻ። ቆደ ከና እሳን ሀመ እስን ብየ ጋሪ ዋቀዮ ዋቅንኬሰን እስኒፍ ኬኔ ከነ ኬሳ ዹምተንት እዳፊ ክዮ እስንት ተኡ፤ ዱግደኬሰንት ቀጬ፣ እጀኬሰንትስ ቆራቲ ተኡ። ");
INSERT INTO gaze_vpl VALUES ("JS23_14","007_23_14","JOS","23","14","14","“ኩኖ አን ከራ ለፈ ሁንዳ ዴሙፍን ጅረ። አከ ዋዳ ጋሪ ዋቀዮ ዋቅንኬሰን እስኒፍ ገሌ ሁንደ ኬሳ ቶኮዩ ኡቱ ህንጉተምን ሀፌ ህንጅሬ እስን ገራኬሰን ጉቱፊ ሉቡኬሰን ጉቱዻን ንቤክቱ። ዋዳን ሁንድ ጉተሜረ፤ ቶኮዩ ህንህርአትኔ። ");
INSERT INTO gaze_vpl VALUES ("JS23_15","007_23_15","JOS","23","15","15","ገሩ አኩመ ዋዳን ጋሪን ዋቀዮ ዋቀኬሰኒ ሁንድ ጉተሜ ሰነ፣ ዋቀዮ አከሱመ ዋን ሀማ እቲን እስን ሶዳችሴ ሰነ ሁንደ ሀመ ብየ ጋሪ እስኒ ኬኔ ከነራ እስን ፍጡት እስንት ፍደ። ");
INSERT INTO gaze_vpl VALUES ("JS23_16","007_23_16","JOS","23","16","16","ዮ እስን ከኩ ዋቀዮ ዋቅንኬሰን እስን አጀጄ ጨብስተኒ ዸቅጠኒ ዋቆተ ብራ ተጃጅልተኒፊ እሳኒፍ ሰገደን ዼከምስ ዋቀዮ እስንት ቦበአ፤ እስንስ ብየ ጋሪ እን እስኒ ኬኔ ሰነራ ደፍተኒ ንበዱ።” ");
INSERT INTO gaze_vpl VALUES ("JS24_1","007_24_1","JOS","24","1","1","እያሱንስ ኤርገሲ ጎሶተ እስራኤል ሁንደ ሼኬምት ወልት ቀቤ። እንስ ማንጉዶተ፣ ሆገንቶተ፣ አቦቲ ሙርቲፊ ቆንዳልቶተ እስራኤል ወልት ዋሜ፤ እሳንስ ፉለ ዋቃ ዱረት ዽኣተን። ");
INSERT INTO gaze_vpl VALUES ("JS24_2","007_24_2","JOS","24","2","2","እያሱን ሰበ ሁንዳን አከነ ጄዼ፤ “ዋቀዮ ዋቅን እስራኤል አከነ ጄዸ፦ ‘አቦቲንኬሰን በረ ዱሪ፣ ታራ አባ አብረሃሚፊ ናሆር ደበለተኒ ለገ ገመ ጅራተኒ ዋቆተ ብራ ዋቄፈተን። ");
INSERT INTO gaze_vpl VALUES ("JS24_3","007_24_3","JOS","24","3","3","አን ገሩ አባኬሰን አብረሃም ብየ ለገ ገማቲ ፉዼ ብየ ከነኣን ኬሰ እሰ ደበርሴ ሰኚ ባይኤ ኬኔፍ። አን ይስሃቅን እሳፈን ኬኔ፤ ");
INSERT INTO gaze_vpl VALUES ("JS24_4","007_24_4","JOS","24","4","4","ይስሃቂፍሞ ያቆቢፊ ኤሳዉን ኬኔ። ብያ ጋራ ሴኢር ኤሳዉፍን ኬኔ፤ ያቆቢፊ እልማንሳ ገሩ ግብጥት ገድ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("JS24_5","007_24_5","JOS","24","5","5","“ ‘አንስ ሙሴፊ አሮን ኤርጌ ዋነን አችት ሆጄዼን ነሞተ ግብጥ ዸእቻን ዸኤ አቺ እስን ባሴ። ");
INSERT INTO gaze_vpl VALUES ("JS24_6","007_24_6","JOS","24","6","6","ዬሮ አን አቦቲኬሰን ብየ ግብጥ ኬሳ ባሴት፣ እስን ገረ ገላና ዹፍተን፤ ወር ግብጥሞ ጋሪወን ሎላቲፊ ወረ ፈርዴን ያበተኒን ሀመ ገላነ ዲማት እሳን ሆርዶፈን። ");
INSERT INTO gaze_vpl VALUES ("JS24_7","007_24_7","JOS","24","7","7","እሳን ገርጋርሰ በርባዱፍ ዋቀዮት እየተን፤ እንስ እሳኒፊ ወረ ግብጥ ግዱ ዱከነ ቡሴ፤ ወረ ግብጥት ገላነ ፍዴ እሳን ኡካምሴ። እስን ዋን አን ወረ ግብጥ ጎዼ እጁመኬሰኒን አርግተን። ኤርገሲስ እስን በረ ዼራ ገሞጂ ኬሰ ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("JS24_8","007_24_8","JOS","24","8","8","“ ‘አንስ ብየ አሞሮተ ገመ በአ ዮርዳኖስ ጅራቻ ቱረን ሰናት እስን ነንፍዴ። እሳንስ እስን ሎለን፤ አን ገሩ ደበርሴ ሀርከኬሰንት እሳን ኬኔ። አን ፉለኬሰን ዱራ እሳን ነንበርበዴሴ፤ እስንስ ብየሳኒ ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("JS24_9","007_24_9","JOS","24","9","9","ባላቅ እልም ዝጶር ሞትች ሞኣብ ሱን ዬሮ እስራኤልት ዱሉፍ ቆጳኤት አከ እን እስን አባሩፍ በለኣም እልመ ቤኦርት ዻምሰ ኤርገቴ። ");
INSERT INTO gaze_vpl VALUES ("JS24_10","007_24_10","JOS","24","10","10","አን ገሩ በለኣምን ህንዸጌፈትኔ፤ ከናፉ እን እረ ዴዴብኤ እስን ኤብሴ፤ አንስ ሀርከሳ ኬሳ እስን ነንባሴ። ");
INSERT INTO gaze_vpl VALUES ("JS24_11","007_24_11","JOS","24","11","11","“ ‘እስንስ ኤርገሲ ለገ ዮርዳኖስ ጬተኒ ዬርኮ ዹፍተን። ጅራቶትን ዬርኮስ አኩመ አሞሮትን፣ ፌርዞን፣ ከነኣኖትን፣ ሄቶትን፣ ግርጋሾን፣ ሂዎትኒፊ ዬቡሶን ጎዸን ሰነ እስን ሎለን፤ አን ገሩ ደበርሴን ሀርከኬሰንት እሳን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("JS24_12","007_24_12","JOS","24","12","12","አን ሶንሰሳኒፊ ሞቶተ አሞሮታ ለማን ፉለኬሰን ዱራ አርኤ ባሱ እስን ዱረ ነንኤርጌ። እስን ጎራዴኬሰኒፊ እዳኬሰኒን እሳን ህንአሪኔ። ");
INSERT INTO gaze_vpl VALUES ("JS24_13","007_24_13","JOS","24","13","13","አን አከሲን ብየ እስን እት ህንደዸብኒፊ መጋላ እስን ህንጃርን እስኒፈን ኬኔ፤ እስንስ እሳን ኬሰ ጅራተኒ እዶ ዻባ ወይኒቲፊ ሙከ ኤጄርሳ ከን ኦፊኬሰኒ ህንዻብንራ ኛተን።’ ");
INSERT INTO gaze_vpl VALUES ("JS24_14","007_24_14","JOS","24","14","14","“ኤጋ ዋቀዮን ሶዳዻቲ አመነሙማ ጉቱዻን እሰ ተጃጅላ። ዋቆተ አቦቲንኬሰን ለገ ገማፊ ብየ ግብጥት ዋቄፈተን ሰነ ገታቲ ዋቀዮን ተጃጅላ። ");
INSERT INTO gaze_vpl VALUES ("JS24_15","007_24_15","JOS","24","15","15","እስን ገሩ ዮ ዋቀዮን ተጃጅሉ ህንበርባድኔ፣ ዋቆተ አቦቲንኬሰን ለገ ገመት ተጃጅላ ቱረን ሰነ ዮካን ዋቆተ አሞሮታ ብየሳኒ ኬሰ ጅራተን ከኔኒ ኬሳ ሀርአ ፍለዻ። አኒፊ መንኮ ገሩ ዋቀዮን ዋቄፈትነ።” ");
INSERT INTO gaze_vpl VALUES ("JS24_16","007_24_16","JOS","24","16","16","ሰብንስ አከነ ጄዼ ዴብሴፍ፤ “ዋቆተ ብራ ተጃጅሉዻፍ ጄኔ ዋቀዮን ዺሱን ኑራ ሃፈጋቱ! ");
INSERT INTO gaze_vpl VALUES ("JS24_17","007_24_17","JOS","24","17","17","ከን ብየ ግብጥ፣ ብየ ገርቡማ ሰነ ኬሳ ኑፊ አቦቲኬኘ ባሴ ዋን መለቶወን ጉርጉዳ ሰነ እጀኬኘ ዱረት ሆጄቴ ዋቀዮ ዋቀኬኛዸ። እን ከራኬኘ ሁንደ እረቲፊ ሰቦተ ኑ ግዱሳኒ ተሬ ሰነ ሁንደ ግዱት ኑ ኤጌ። ");
INSERT INTO gaze_vpl VALUES ("JS24_18","007_24_18","JOS","24","18","18","ዋቀዮ ሰቦተ ሁንደ፣ አሞሮተ ብየ ሰነ ኬሰ ጅራቻ ቱረንስ ፉለኬኘ ዱራ አርኤ ባሴ። ሰበቢ እን ዋቀኬኘ ተኤፍ ኑ ዋቀዮን ተጃጅለ።” ");
INSERT INTO gaze_vpl VALUES ("JS24_19","007_24_19","JOS","24","19","19","እያሱንስ ሰባን አከነ ጄዼ፤ “እስን ዋቀዮን ተጃጅሉ ህንደንዴሰን። እን ዋቀ ቁልቁሉዸ። እን ዋቀ ህናፉዸ። እን ፍንጭለኬሰኒፊ ጩቡኬሰን እስኒ ህንዺሱ። ");
INSERT INTO gaze_vpl VALUES ("JS24_20","007_24_20","JOS","24","20","20","ዮ እስን ዋቀዮን ዺፍተኒ ዋቆተ ኦርማ ተጃጅልተን፣ እን ኤርጉመ ዋን ጋሪ እስኒ ጎዼ ቦዴ ገረገሌ በላ እስንት ቡሴ እስን በሌሰ።” ");
INSERT INTO gaze_vpl VALUES ("JS24_21","007_24_21","JOS","24","21","21","ነሞትን ገሩ እያሱዻን፣ “ለክ! ኑ ዋቀዮን ተጃጅለ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JS24_22","007_24_22","JOS","24","22","22","እያሱንስ ዴብሴ፣ “እስን አከ ዋቀዮን ተጃጅሉ ፍለተን ኦፊኬሰንት ዹጋ ባቶተ ታተኒርቱ” ጄዼን። እሳንስ ዴብሰኒ፣ “ኤዬ፣ ኑ ዹጋ ባቶተ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JS24_23","007_24_23","JOS","24","23","23","ከነረት እያሱን፣ “ዮስ አመ ዋቆተ ኦርማ ከኔን እስን ግዱ ጅረን ሰነ ባሳ ገታቲ ገራኬሰን ዋቀዮ ዋቀ እስራኤልት ኬና” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JS24_24","007_24_24","JOS","24","24","24","ሰብንስ እያሱዻን፣ “ኑ ዋቀዮ ዋቀኬኘ ተጃጅለ፤ ንአጀጀምናፍስ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JS24_25","007_24_25","JOS","24","25","25","እያሱን ጉያ ሰነ ሰባፍ ከኩ ገሌ ሼኬምት አጀጃፊ ሴረ ባሴ። ");
INSERT INTO gaze_vpl VALUES ("JS24_26","007_24_26","JOS","24","26","26","እንስ ዋን ከነ ክታበ ሴረ ዋቃ ኬሰት በሬሴ። ዸጋ ጉዳ ቶኮስ ፉዼ እዶ ቁልቁሉ ዋቀዮ ብረት ቅልጡ ቶኮ ጀለ ዻቤ። ");
INSERT INTO gaze_vpl VALUES ("JS24_27","007_24_27","JOS","24","27","27","እን ነመ ሁንዳን አከነ ጄዼ፤ “ኩኖ! ዸጋን ኩን ዹጋ ኑት በኣ። እን ዱቢ ዋቀዮ ኑት ዱበቴ ሁንደ ዸገኤረ። ዮ እስን ዋቀኬሰኒፍ ህንአመነምን ዸጋን ኩን ዹጋ እስንት በአ።” ");
INSERT INTO gaze_vpl VALUES ("JS24_28","007_24_28","JOS","24","28","28","ከናፉ እያሱን ቶኮ ቶኮ ነማ ገረ ዻለ መታ መታሳት ኤርጌ። ");
INSERT INTO gaze_vpl VALUES ("JS24_29","007_24_29","JOS","24","29","29","ሰነ ቦዴ እያሱን እልም ኑን፣ ገርብች ዋቀዮ ሱን፣ ወጋ ዽበ ቶኮፊ ኩዸንት ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("JS24_30","007_24_30","JOS","24","30","30","እሳንስ ለፈ ዻለሳ፣ ትምናት ሴራ ከን ብየ ጋራ ኤፍሬም ኬሰት ከራ ካበ ቱሉ ገኣሽት አርገምቱ ሰነት እሰ አዋለን። ");
INSERT INTO gaze_vpl VALUES ("JS24_31","007_24_31","JOS","24","31","31","ሰብን እስራኤል በረ ጅሬኘ እያሱ ጉቱፊ በረ ማንጉዶተ ኤርገ እን ዱኤ አስ ሀፈኒ ጅራተኒ ዋን ዋቀዮ እስራኤሊፍ ጎዼ ሁንደ አርገኒ ኬሰ ዋቀዮን ተጃጅሌረ። ");
INSERT INTO gaze_vpl VALUES ("JS24_32","007_24_32","JOS","24","32","32","ለፌን ዮሴፍ ከን እስራኤሎን ብየ ግብጢ ባሰኒ ፍደንስ ሼኬምት ለፈ ያቆብ ሜቲ ዽበ ቶኮን እልማን ሀሞር፣ አባ ሼኬምራ ብቴ ሰነት አዋለሜ። ለፍት ኩንስ ዻለ ሰኚ ዮሴፍ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("JS24_33","007_24_33","JOS","24","33","33","ኤሌኣዛር እልም አሮንስ ዱኤ ግቤኣ ለፈ ብየ ጋራ ኤፍሬም ከን እልመሳ ፊኔሃሲፍ እጣዻን ኬነሜ ኬሰት አዋለሜ። ");
INSERT INTO gaze_vpl VALUES ("JG1_1","008_1_1","JDG","1","1","1","ኤርገ እያሱን ዱኤ ቦዴ እስራኤሎን፣ “ከነኣኖተ ሎሉዻፍ ኤኙ ዱርሴ ኑፍ ሃበኡ?” ጄዸኒ ዋቀዮን ጋፈተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_2","008_1_2","JDG","1","2","2","ዋቀዮስ፣ “ይሁዳን ዱርሴ ሃበኡ፤ ኩኖ፣ አን ብየቲ ደበርሴ ሀርከሳት ኬኔረ” ጄዼ ዴብሴፍ። ");
INSERT INTO gaze_vpl VALUES ("JG1_3","008_1_3","JDG","1","3","3","ነሞትን ይሁዳስ ኦቦሎተሳኒ እልማን ስምኦኒን፣ “ኮታ ገረ ለፈ ቆደኬኛት ከነኣኖተ ሎሉፍ ወጅን ባና፤ ኑስ ገመኬኛን ገረ ለፈ ቆደኬሰኒት እስን ወጅን ንባና” ጄዸን። ከናፉ ነሞትን ስምኦን እሳን ወጅን በአን። ");
INSERT INTO gaze_vpl VALUES ("JG1_4","008_1_4","JDG","1","4","4","ዮሙ ይሁዳን በኤትስ ዋቀዮ ከነኣኖታፊ ፌርዞተ ደበርሴ ሀርከሳኒት ኬኔ፤ እሳንስ እዶ ቤዜቅ ጄዸሙት ነመ ኩመ ኩዸን ፍጠን። ");
INSERT INTO gaze_vpl VALUES ("JG1_5","008_1_5","JDG","1","5","5","አችትስ አዶኒ-ቤዜቅ አርገኒ እሰ ሎለን፤ ከነኣኖታፊ ፌርዞተስ ሞአተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_6","008_1_6","JDG","1","6","6","አዶኒ-ቤዜቅ አቺ በቀቴ፤ እሳን ገሩ አርአኒ እሰ ቀበን፤ ቁበ አቡዱ ሀርካቲፊ ቁበ አቡዱ ሚለሳራ ኩተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_7","008_1_7","JDG","1","7","7","ኤርገሲስ አዶኒ-ቤዜቅ፣ “ሞቶትን ቁብን አቡዱን ሀርከሳኒቲፊ ቁብን አቡዱን ሚለሳኒ እራ ጭረሜ ቶርባተምን ዋን ማዲኮ ጀለት ሀርጨኤ ፉናነቻ ቱረን። አመ ገሩ ዋቅን ዋኑመ አን እሳንት ሆጄዼ ና ዴብሴ” ጄዼ። እሳንስ ዬሩሳሌምት እሰ ፍደን፤ እንስ አችት ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("JG1_8","008_1_8","JDG","1","8","8","ነሞትን ይሁዳ ዬሩሳሌሚንስ አከሱመ ዸአኒ ቀበተን። መጋለቲስ ጎራዴዻን ዸአኒ እብደ እት ቀብሲሰን። ");
INSERT INTO gaze_vpl VALUES ("JG1_9","008_1_9","JDG","1","9","9","ኤርገሲስ ነሞትን ይሁዳ ከነኣኖተ ብየ ጋራ፣ ኔጌቢፊ ገሞጂ ከራ ልጠ ቢፍቱ ኬሰ ጅራተን ሎሉዻፍ ገድ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("JG1_10","008_1_10","JDG","1","10","10","ነሞተ ከነኣን ከኔን ኬብሮን እሼ ዱር ክርያት አርባቅ ጄዸምቱ ኬሰ ጅራተንትስ ዱለኒ ሼሻዪን፣ አሂመኒፊ ተልማይን ሞአተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_11","008_1_11","JDG","1","11","11","አቺስ ነሞተ ብየ ዴቢር እሼ ዱር ክርያት ሴፌር ጄዸማ ቱርቴ ሰነ ኬሰ ጅራተንት ዱለን። ");
INSERT INTO gaze_vpl VALUES ("JG1_12","008_1_12","JDG","1","12","12","ካሌብስ፣ “አን ነመ ክርያት ሴፌር ሎሌ ቀበቱት እንተለኮ ኣክሳ ነንሄሩምሲሰ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG1_13","008_1_13","JDG","1","13","13","ኦቦሌስ ካሌብ ቁጥሱን፣ ኦትኒኤል እልም ቄነዝ መጋለቲ ቀበቴ፤ ካሌብስ እንተለሳ ኣክሳ እሰት ሄሩምሲሴ። ");
INSERT INTO gaze_vpl VALUES ("JG1_14","008_1_14","JDG","1","14","14","እሼንስ ዬሮ ገረ ኦትኒኤል ዹፍቴት፣ አከ እን አባሼ ለፈ ቆቲሳ ከዸቱ እሰ ከካፍቴ። ካሌብስ ዮሙ እሼን ሀሬሼራ ቡቴት፣ “አን ማል ሲፍ ጎዹ?” ጄዼ እሼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("JG1_15","008_1_15","JDG","1","15","15","እሼንስ ዴብፍቴ፣ “ዋን አዳ ቶኮ ና ጎዽ። አኩመ ኔጌብ ኬሰት ለፈ ና ኬንቴ ሰነ ቡርቃወን ብሻኒስ ና ኬን” ጄቴን። ካሌብስ ቡርቃወን ኦሊቲፊ ገዲ ኬኔፍ። ");
INSERT INTO gaze_vpl VALUES ("JG1_16","008_1_16","JDG","1","16","16","ሰኚወን ቄኒ ነምቸ አባ ኒቲ ሙሴ ሰና ነሞተ ገሞጂ ይሁዳ ኬሰ ኔጌብ እሼ ኣራድ ብረት አርገምቱ ኬሰ ጅራተን ግዱ ጅራቹፍ ጄዸኒ ነሞተ ይሁዳ ወጅን መጋላ ሜጢቲ ኦል በአን። ");
INSERT INTO gaze_vpl VALUES ("JG1_17","008_1_17","JDG","1","17","17","ነሞትን ይሁዳ ኦቦሎተሳኒ እልማን ስምኦን ወጅን ዸቀኒ ከነኣኖተ ዜፋት ኬሰ ጅራተን ወራነን፤ መጋለቲስ ጉቱማን ጉቱት በርበዴሰን። ከናፉ መጋለቲን ሆርማ ጄዸምቴ ዋመምቴ። ");
INSERT INTO gaze_vpl VALUES ("JG1_18","008_1_18","JDG","1","18","18","አከሱመስ ነሞትን ይሁዳ ጋዛ ገንዶተ ናኖሼ ወጅን፣ አሽቀሎን ገንዶተ ናኖሼ ወጅን፣ ኤቅሮን ናኖሼ ወጅን ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_19","008_1_19","JDG","1","19","19","ዋቀዮ ነሞተ ይሁዳ ወጅን ቱሬ። ከናፉ እሳን ብየ ጋራ ሰነ ቀበተን፤ ገሩ ሰበቢ ነሞትን ድሬረ ጅራተን ጋሪወን ስቢላ ቀበኒፍ አቺ እሳን ባሱ ህንደንዴኜ። ");
INSERT INTO gaze_vpl VALUES ("JG1_20","008_1_20","JDG","1","20","20","አኩመ ሙሴን አብደቺሴ ቱሬት ኬብሮን ካሌቢፍ ኬነምቴ፤ እንስ እልማን አናቅ ሰደን አቺ አርኤ ባሴ። ");
INSERT INTO gaze_vpl VALUES ("JG1_21","008_1_21","JDG","1","21","21","እጆሌን ቤንያም ገሩ ዬቡሶተ ዬሩሳሌም ኬሰ ጅራቻ ቱረን ሰነ አቺ ባሱ ህንደንዴኜ፤ ሀመ አማት ዬቡሶን ቤንያሞተ ወጅን እዶ ሰነ ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_22","008_1_22","JDG","1","22","22","ጎስት ዮሴፍሞ ቤትኤል ወራነን፤ ዋቀዮስ እሳን ወጅን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG1_23","008_1_23","JDG","1","23","23","ዮሙ እሳን ገረ ቤትኤል እሼ ዱር ሉዝ ጄዸምቱት በሳስቶተ ኤርገንት፣ ");
INSERT INTO gaze_vpl VALUES ("JG1_24","008_1_24","JDG","1","24","24","በሳስቶትን ሱን ነምቸ መጋላዻ በኤ ዹፉ ቶኮ አርገኒ፣ “ከራ እቲን መጋላ ሴነን ኑ አርግሲስ፤ ኑስ ዋን ጋሪ ሲፍ ጎነ” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("JG1_25","008_1_25","JDG","1","25","25","እንስ እት አርግሲሴ፤ እሳንስ ነምቸ ሰናፊ ማቲሳ ጉቱ ዺሰኒ መጋላ ሰነ ጎራዴዻን ዸአን። ");
INSERT INTO gaze_vpl VALUES ("JG1_26","008_1_26","JDG","1","26","26","ነምችስ ገረ ሄቶታ ዴሜ መጋላ ሎዛ ጄዸምቱ ሁንዴሴ፤ እሼንስ ሀመ አማት ሉዝ ጄዸምቴ ዋመምት። ");
INSERT INTO gaze_vpl VALUES ("JG1_27","008_1_27","JDG","1","27","27","ምናሴን ገሩ ነሞተ ቤት ሼኣኒቲፊ ገንዶተ ናኖሼ ዮካን ተአናኪፊ ገንዶተ ናኖሼ ዮካን ዶሪፊ ገንዶተ ናኖሼ ዮካን ይብሌኣሚፊ ገንዶተ ናኖሼ ዮካን ሜግዶፊ ገንዶተ ናኖሼ ጅራተን አቺ ህንባፍኔ፤ ከናፉ ከነኣኖትን እቱመ ፉፈኒ አች ጅራቹፍ ሙርቴፈተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_28","008_1_28","JDG","1","28","28","እስራኤሎን ዮሙ ጀባቻ ዹፈንት አከ እሳን ሆጂ ሁምና ሆጄተን እሳን ድርቅሲሰን መሌ ከነኣኖተ ጉቱማን ጉቱት አቺ ህንባፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JG1_29","008_1_29","JDG","1","29","29","ኤፍሬምስ ከነኣኖተ ጌዝር ኬሰ ጅራተን አቺ ህንባፍኔ፤ ከነኣኖትን ገሩ እቱመ ፉፈኒ አቹመ እሳን ግዱ ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_30","008_1_30","JDG","1","30","30","ዜቡሎንስ ከነኣኖተ ቅጥሮን ዮካን ነሀሎል ኬሰ ጅራተን ከኔን ግዱሳኒት ሀፈን ህንባፍኔ፤ ገሩ አከ እሳን ሆጂ ሁምና ሆጄተን ጎዸን። ");
INSERT INTO gaze_vpl VALUES ("JG1_31","008_1_31","JDG","1","31","31","ኣሼርስ ወረ አኮ ዮካን ሲዶን ዮካን አህላብ ዮካን አክዚብ ዮካን ሄልባ ዮካን አፊቂፊ ሬሆብ ኬሰ ጅራተን ህንባፍኔ፤ ");
INSERT INTO gaze_vpl VALUES ("JG1_32","008_1_32","JDG","1","32","32","ነሞትን ኣሼር ሰበቢ እሳን ጀረ አርአኒ ህንባስኒፍ ከነኣኖተ ብየ ሰነ ጅረን ግዱ ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("JG1_33","008_1_33","JDG","1","33","33","ንፍታሌም ወረ ቤት ሼሜሺፊ ቤት አናት ኬሰ ጅራተን ህንባፍኔ፤ ነሞትን ንፍታሌም ገሩ ከነኣኖተ ብየ ሰነ ቱረን ግዱ ጅራተን፤ ወር ቤት ሼሜሺፊ ቤት አናት ድርቀምሲፈመኒ ሆጂ ሁምና ሆጄቻፊ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JG1_34","008_1_34","JDG","1","34","34","አሞሮትንሞ ወረ ዳን ገረ ብየ ጋራት ዺበን መሌ አከ እሳን ሱሉለት ገድ ቡአን ህንኤየምኔፍ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG1_35","008_1_35","JDG","1","35","35","አሞሮትንስ እት ፉፈኒ ቱሉ ሄሬስረ፣ አያሎኒፊ ሸአልቢም ኬሰ ጅራተን፤ ገሩ ዮሙ ሁምን መነ ዮሴፍ ጀባቻ ዹፌት እሳንስ ሆጂ ሁምና እሳኒ ሆጄቹፍ ድርቅሲፈመን። ");
INSERT INTO gaze_vpl VALUES ("JG1_36","008_1_36","JDG","1","36","36","ዳሪን አሞሮታ አቅረቢሚ ጀልቀቤ ከራ ሴላቲን ኦል በአ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG2_1","008_2_1","JDG","2","1","1","ኤርገማን ዋቀዮ ግልጋሊ ቦኪምት ኦል በኤ አከነ ጄዼ፤ “አን ግብጢ እስን ባሴ ብየ አን አቦቲኬሰኒፍ ኬኑፍ ከከዼ ሰነት እስን ፍዴረ። አከነስ ነንጄዼ፤ ‘አን ከኩ እስን ወጅን ገሌ ሰነ ጎንኩማ ህንዲጉ፤ ");
INSERT INTO gaze_vpl VALUES ("JG2_2","008_2_2","JDG","2","2","2","እስንስ ወረ ለፈ ከነረ ጅራተን ወጅን ከኩ ህንገልና፤ እዶ ኣርሳሳኒ ገሩ ጨጨብሳ።’ ተኡስ እስን ናፍ ህንአጀጀምኔ። እስን ማሊፍ ዋን ከነ ጎተን? ");
INSERT INTO gaze_vpl VALUES ("JG2_3","008_2_3","JDG","2","3","3","ከናፉ አን አመ አከ ፉለኬሰን ዱራ አርኤ እሳን ህንባፍኔ እስንት ነንህመ፤ እሳን እዳ እስንት ተኡ፤ ዋቆንሳኒሞ ክዮ እስንት ተኡ።” ");
INSERT INTO gaze_vpl VALUES ("JG2_4","008_2_4","JDG","2","4","4","ዬሮ ኤርገማን ዋቀዮ ዋን ከነ እስራኤሎተ ሁንደት ዱበቴት ነሞትን ሰገሌሳኒ ኦል ፉዸተኒ ቦአን፤ ");
INSERT INTO gaze_vpl VALUES ("JG2_5","008_2_5","JDG","2","5","5","እሳንስ እዶ ሰነ ቦኪም ጄዸኒ ዋመን። አችትስ ዋቀዮፍ ኣርሳ ዽኤሰን። ");
INSERT INTO gaze_vpl VALUES ("JG2_6","008_2_6","JDG","2","6","6","ኤርገ እያሱን እስራኤሎተ ገድ ዺሴ ቦዴ ቶኮን ቶኮንሳኒ ብየቲ ዻሉፍ ገረ ዻለ ኦፊሳኒ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("JG2_7","008_2_7","JDG","2","7","7","ኡመትን በረ ጅሬኘ እያሱ ጉቱፊ በረ ማንጉዶተ ኤርገ እን ዱኤ አስ ሀፈኒ ጅራተኒ ዋን ጉዳ ዋቀዮ እስራኤሊፍ ጎዼ አርገን ሱንስ ዋቀዮን ተጃጅለን። ");
INSERT INTO gaze_vpl VALUES ("JG2_8","008_2_8","JDG","2","8","8","እያሱን እልም ኑን ገርብች ዋቀዮ ወጋ ዽበ ቶኮፊ ኩዸንት ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("JG2_9","008_2_9","JDG","2","9","9","እሳንስ ለፈ ዻለሳ ትምናት ሄሬስ ከን ብየ ጋራ ኤፍሬምት ከራ ካበ ቱሉ ገኣሽት አርገምቱ ሰነት እሰ አዋለን። ");
INSERT INTO gaze_vpl VALUES ("JG2_10","008_2_10","JDG","2","10","10","ኤርገ ዸሎትን ሱን ጉቱን ገረ አቦቲሳኒት ወልት ቀበመኒ ቦዴ ዸሎትን ዋቀዮን ህንቤክን ዮካን ዋን እን ሰበ እስራኤሊፍ ጎዼ ህንቤክን ከን ብራ ከኤ። ");
INSERT INTO gaze_vpl VALUES ("JG2_11","008_2_11","JDG","2","11","11","እስራኤሎንስ ፉለ ዋቀዮ ዱረት ዋን ሀማ ሆጄተን፤ በኣሊንስ ንተጃጅለን። ");
INSERT INTO gaze_vpl VALUES ("JG2_12","008_2_12","JDG","2","12","12","እሳን ዋቀዮ ዋቀ አቦቲሳኒ ከን ግብጢ እሳን ባሴ ሰነ ንዺሰን። ዋቆተ አደ አዳ ከኔን ሰቦተ ናኖሳኒ ጅራተኒ ዱካ ቡአን፤ ንዋቄፈተንስ። ዋቀዮንስ ዼከምሳፍ ከካሰን፤ ");
INSERT INTO gaze_vpl VALUES ("JG2_13","008_2_13","JDG","2","13","13","እሳን እሰ ዺሰኒ በኣሊፊ አሽቶሬትን ዋቄፈተኒሩቲ። ");
INSERT INTO gaze_vpl VALUES ("JG2_14","008_2_14","JDG","2","14","14","ዋቀዮስ እስራኤሎተት ዼከሜ ሳምቶተ እሳን ሳመንት ደበርሴ እሳን ኬኔ። ዲኖተ ናኖሳኒ ከኔን እሳን ኦፍራ እትሱ ህንደንዴኜ ሁንደት እሳን ጉርጉሬ። ");
INSERT INTO gaze_vpl VALUES ("JG2_15","008_2_15","JDG","2","15","15","ዮሙ እስራኤሎን ሎላፍ በአንት አኩመ እን ዱራን ከከቴ ሰነት ሀርክ ዋቀዮ እሳንት ሀማቴ አከ እሳን ሞአተመን ጎዸ ቱሬ። እሳንስ ረክነ ጉዳ ኬሰ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("JG2_16","008_2_16","JDG","2","16","16","ዋቀዮስ አቦቲ ሙርቲ ከኔን ሳምቶተ ጀላ እሳን ባሰን እሳኒፍ ካሴ። ");
INSERT INTO gaze_vpl VALUES ("JG2_17","008_2_17","JDG","2","17","17","እሳን ገሩ ዋቆተ ብራ ወጅን ሰጋገለኒ እሳን ዋቄፈተን መሌ አቦቲ ሙርቲ ሰነ ህንዸጌፈትኔ። ከራ አቦቲንሳኒ ዋቀዮፍ አጀጀሙዻን እረ ዴማ ቱረን ሰነራ ደፈኒ ጀልአተን፤ እሳን ዋን አቦቲንሳኒ ጎዸን ህንጎኔ። ");
INSERT INTO gaze_vpl VALUES ("JG2_18","008_2_18","JDG","2","18","18","ዋቀዮ ዬሮ አባ ሙርቲ ቶኮ እሳኒ ካሴት ሀመ አባን ሙርቲ ሱን ጅሩት እሰ ወጅን ጅራቴ ሀርከ ዲኖተሳኒ ጀላ እሳን ባሰ ቱሬ፤ ዋቀዮ ዬሮ እሳን ሰበቢ ወረ እሳን ጩንቁርሰኒፊ ወረ እሳን ሚዸኒቲን ወዋተንት ገራ ላፋፍ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("JG2_19","008_2_19","JDG","2","19","19","ዮሙ አባን ሙርቲ ሱን ዱኡ ገሩ እሳን ዋቆተ ብራ ዱካ ቡኡዻን፣ ተጃጅሉፊ እሳን ዋቄፈቹዻን አቦቲሳኒዩ ጫላ ገረ ሀምናት ዴብአን። ሆጂ ሀምናቲፊ መታ ጀብነሳኒራስ ህንዴብአን ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG2_20","008_2_20","JDG","2","20","20","ከናፉ ዋቀዮ እስራኤልት አከ መሌ ዼከሜ አከነ ጄዼ፤ “ዋን ሰብን ኩን ከኩ አን አቦቲሳቲፍ ገሌ ሰነ ጨብሴ አነስ ዸገኡ ድዴፍ፣ ");
INSERT INTO gaze_vpl VALUES ("JG2_21","008_2_21","JDG","2","21","21","አን ስአች ሰቦተ እያሱን ዬሮ ዱኤት እሳን ግዱት ዺሴ ሰነ እሳን ዱራ አርኤ ህንባሱ። ");
INSERT INTO gaze_vpl VALUES ("JG2_22","008_2_22","JDG","2","22","22","ከራ ሰቦተ ከናቲንስ አከ እሳን አኩመ አቦቲሳኒ ከራ ዋቀዮ ኤገኒ እረ ዴዴብአኒፊ አከ እሳን ህንኤግኔ እላሉፍ ጄዼ እስራኤልን ነንቆረ።” ");
INSERT INTO gaze_vpl VALUES ("JG2_23","008_2_23","JDG","2","23","23","ከናፉ ዋቀዮ አከ ሰቦትን ኩኔን አቹመት ሀፈን ኤየሜ፤ ሀርከ እያሱትስ ደበርሴ እሳን ኬኑዻን ደፌ አቺ እሳን ህንባፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JG3_1","008_3_1","JDG","3","1","1","ሰቦትን ዋቀዮ እስራኤሎተ ወራነ ከነኣን ኬሰት ዴምስፈሜ ከምዩረት ህርማተኒ ህንቤክን ሁንደ ቆሩፍ ጄዼ እዱመ እሳን ቱረንት ሀምብሴ ከኔኒዸ፤ ");
INSERT INTO gaze_vpl VALUES ("JG3_2","008_3_2","JDG","3","2","2","እንስ አከ እስራኤሎን ከናን ዱረ ወራነ ኬሰት ህርማተኒ ህንቤክን ሙጠትኖ አርገተኒፍ ዋን ከነ ጎዼ፤ ");
INSERT INTO gaze_vpl VALUES ("JG3_3","008_3_3","JDG","3","3","3","ከኔን ኡቱ ህንበእን አቹመት ሀፈንስ፦ ቡልችቶተ ፍልስጤሞታ ሸነን፣ ከነኣኖተ ሁንደ፣ ሲዶኖታፊ ሂዎተ ቱሉ በኣል ሄርሞኒ ጀልቀበኒ ሀመ በልበለ ሀማትት ጋረን ልባኖን ጉባ ጅራተኒዸ። ");
INSERT INTO gaze_vpl VALUES ("JG3_4","008_3_4","JDG","3","4","4","እሳን ኩኔን ወረ እስራኤሎን አጀጀ ዋቀዮ ከን እን ከራ ሙሴቲን አቦቲ እሳኒፍ ኬኔ ቱሬ ሰነ ኤጉፊ ኤጉ ባቹሳኒ እቲን ቆረመኒ እላለመኒፍ ሀምብፈመኒዸ። ");
INSERT INTO gaze_vpl VALUES ("JG3_5","008_3_5","JDG","3","5","5","ከናፉ እስራኤሎን ከነኣኖተ፣ ሄቶተ፣ አሞሮተ፣ ፌርዞተ፣ ሂዎታፊ ዬቡሶተ ግዱ ጅራተን። ");
INSERT INTO gaze_vpl VALUES ("JG3_6","008_3_6","JDG","3","6","6","እሳንስ እንተለን ጀራ ፉዸን፤ እንተለን ኦፊሳኒሞ እልማንሳኒት ሄሩምሲሰን፤ ዋቆተሳኒስ ንዋቄፈተን። ");
INSERT INTO gaze_vpl VALUES ("JG3_7","008_3_7","JDG","3","7","7","እስራኤሎን ፉለ ዋቀዮ ዱረት ዋን ሀማ ሆጄተን፤ ዋቀዮ ዋቀሳኒ እራንፈተኒ በኣሊፊ አሼራ ዋቄፈተን። ");
INSERT INTO gaze_vpl VALUES ("JG3_8","008_3_8","JDG","3","8","8","ኣሪን ዋቀዮ እስራኤሎተት ቦበኤ፤ ከናፉ ሞቲ ጳዳን አራም ኩሸን-ርሻታይምት ደበርሴ እሳን ጉርጉሬ፤ እስራኤሎንስ ወጋ ሰዴት እሰ ጀለት ቡለን። ");
INSERT INTO gaze_vpl VALUES ("JG3_9","008_3_9","JDG","3","9","9","ዋቀዮ ገሩ ዬሮ እሳን ገረሳት እየተንት ነመ እሳን ፉሩ ቶኮ ጄቹንስ ኦቦሌሰ ካሌብ ቁጥሱ፣ ኦትኒኤል እልመ ቄነዝ ሰነ አከ እን እሳን ፉሩፍ ካሴፍ። ");
INSERT INTO gaze_vpl VALUES ("JG3_10","008_3_10","JDG","3","10","10","ሀፉር ዋቀዮ እሰረ ቡኤ፤ ከናፉ እን አባ ሙርቲ እስራኤሎታ ተኤ ዱላፍ በኤ። ዋቀዮስ ኩሸን-ርሻታይም ሞትቸ ጳዳን አራም ሰነ ደበርሴ ሀርከ ኦኒኤልት ኬኔ፤ እንስ እሰ ሞአቴ። ");
INSERT INTO gaze_vpl VALUES ("JG3_11","008_3_11","JDG","3","11","11","ከናፉ ብይ ሱን ሀመ ኦትኒኤል እልም ቄነዝ ዱኡት ወጋ አፉርተመ ነጋ አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("JG3_12","008_3_12","JDG","3","12","12","አመስ እስራኤሎን ፉለ ዋቀዮ ዱረት ዋን ሀማ ሆጄተን፤ ሰበቢ እሳን ዋን ሀማ ከነ ሆጄተኒፍ ዋቀዮ አከ ኤግሎን ሞቲን ሞኣብ ሀርከሳ እሳንት ጭምሱፍ ደበርሴ እሳን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("JG3_13","008_3_13","JDG","3","13","13","እንስ አሞኖታፊ አማሌቆተ ወልት ቀበቴ እስራኤሎተ ወራኔ፤ እሳንስ መጋላ ሜጢ ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("JG3_14","008_3_14","JDG","3","14","14","እስራኤሎን ወጋ ኩዸ ሰዴት ኤግሎን ሞቲ ሞኣብ ጀለት ቡለን። ");
INSERT INTO gaze_vpl VALUES ("JG3_15","008_3_15","JDG","3","15","15","እስራኤሎን አመስ ገረ ዋቀዮት እየተን፤ እንስ ነመ እሳን ፉሩ ቶኮ ጄቹንስ ኤሁድ ነመ ሀርከ ብታቻ፣ እልመ ጌራ ሰነ ጎሰ ቤንያም ኬሳ እሳኒ ካሴ። እስራኤሎንስ አከ እን ኤግሎን ሞቲ ሞኣብ ሰናፍ ግብረ ጌሱ ናኦድን ኤርገን። ");
INSERT INTO gaze_vpl VALUES ("JG3_16","008_3_16","JDG","3","16","16","ኤሁድስ ጎራዴ ገመ ለማን ቀረ ቀቡ ከን ሜትረ ወለካ ዼረቱ ቶልፈቴ ኡፈተሳ ጀላን ተፈ ምርጋት ህዸቴ። ");
INSERT INTO gaze_vpl VALUES ("JG3_17","008_3_17","JDG","3","17","17","ግብረ ሰነ ኤግሎን ሞትቸ ሞኣብ ነምቸ አከ መሌ ፉርዳ ቱሬ ሰናፍ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("JG3_18","008_3_18","JDG","3","18","18","ናኦድ ኤርገ ግብረ ሰነ ዽኤሴ ቦዴ ነሞተ ባተኒፊ ዹፈን ጌጌሴ። ");
INSERT INTO gaze_vpl VALUES ("JG3_19","008_3_19","JDG","3","19","19","እን ገሩ እዶ ዸጋን ባፈሙ ከን ግልጋል ብረት አርገሙ ብረ ገኤ ዱበት ዴብኡዻን፣ “ያ ሞቲ አን ዋን ዾክሳት ስት ህሙ ቶኮ ቀበ” ጄዼ። ሞትችስ፣ “ጨልእሳ!” ጄዼ፤ ወር እሰ ብረ ቱረን ሁንድኑስ እሰ ዺሰኒ በአን። ");
INSERT INTO gaze_vpl VALUES ("JG3_20","008_3_20","JDG","3","20","20","ኡቱ ሞትች ኩታ መነሳ እዶ ቀበናኣ ቶኮ ኮጳሳ ታኤ ጅሩ ኤሁድ እት ዽኣቴ፣ “አን ኤርጋ ዋቀ ብራ ሲፍ ኤርገሜ ቀበ” ጄዼን። ኤግሎንስ ቴሶሳራ ኦል ከኤ፤ ");
INSERT INTO gaze_vpl VALUES ("JG3_21","008_3_21","JDG","3","21","21","ኤሁድ ሀርከሳ ብታ ድሪርሴ ተፈ ምርገሳራ ጎራዴ ሉቅፈቴ ገራ ሞትቻ ኬሰ ፉላሴ። ");
INSERT INTO gaze_vpl VALUES ("JG3_22","008_3_22","JDG","3","22","22","ቀበትኖንሳስ ኡቱ ህንሀፍን ገራ ሴኔ ስቢልሳ ዱባን በኤ። ናኦድ ጎራድቸ ገራ ሞትቻ ኬሳ ህንቡቅፍኔ፤ ሞርስ ጎራዴ ሰነ ሀጉጌ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG3_23","008_3_23","JDG","3","23","23","ኤርገሲስ ኤሁድ ኤግሎንት በልበለ ጩፌ ከራ ቦሮቲን በኤ ቀጄሌ። ");
INSERT INTO gaze_vpl VALUES ("JG3_24","008_3_24","JDG","3","24","24","ኤርገ ኤሁድ ዴሜ ቦዴ ተጃጅልቶትን ሞትቻ ዹፈን፤ በልበለ ኩታ መነ ኦል ኣኑስ አኩመ እን ጩፈሜ ጅሩት አርገን። እሳንስ፣ “ተሪ እን መነ ቦሊ ገድ ታኤ ጅረ ተአ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JG3_25","008_3_25","JDG","3","25","25","ሀመ ደዸበንትስ ኤገን፤ ገሩ ዋን እን ኡቱ በልበለ ህንበንን ቱሬፍ ፉርቱ ፉዸተኒ በልበለ በነን። ኩኖ ጎፍታንሳኒ ዱኤ ለፈረ ድሪሬ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG3_26","008_3_26","JDG","3","26","26","ኡቱመ እሳን ዻበተኒ ኤጋ ጅረኑ ኤሁድ ፈጋቴ ዴሜ። ከራ ለፈ ዸጋን እት ሶፈሙቲን ደርቤ ገረ ሴኢራት በቀቴ። ");
INSERT INTO gaze_vpl VALUES ("JG3_27","008_3_27","JDG","3","27","27","እንስ ዮሙ አች ገኤት ብየ ጋራ ኤፍሬም ኬሰት መለከተ አፉፌ፤ እስራኤሎንስ ሆገንቱማሳቲን ብየ ጋራ ሰነራ እሰ ወጅን ገድ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("JG3_28","008_3_28","JDG","3","28","28","ኤሁድስ፣ “ዲነኬሰን ሞኣብን ዋቀዮ ደበርሴ ሀርከኬሰንት እስኒ ኬኔራቲ ነ ዱካ ቡኣ!” ጄዼን። እሳንስ መልካ ዮርዳኖስ ከን ገረ ሞኣብት ጌሱ ሰነ ቀበተኒ ነመ ቶኮሌ አቺን ደርቡ ዾወን። ");
INSERT INTO gaze_vpl VALUES ("JG3_29","008_3_29","JDG","3","29","29","ዬሮ ሰነት ሞኣቦተ ሁንድሳኒ ጀጀቦፊ ሁምነ ቀቤዪ ተአን ኩመ ኩዸን ፍጠን፤ ነምን ቶኮዩ እሳን ጀላ ህንባኔ። ");
INSERT INTO gaze_vpl VALUES ("JG3_30","008_3_30","JDG","3","30","30","ጋፈ ሰነ ሞኣብ ሀርከ እስራኤልት ገልፈምቴ፤ ብየቲንስ ወጋ ሰዴተማፍ ነጋ አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("JG3_31","008_3_31","JDG","3","31","31","ኤሁድት ኣኔ ሸምጋር እልም አናት ከኤ፤ እንስ ኡሌ እቲን ቆትዮ ቱቱቀኒን ፍልስጤሞተ ዽበ ጀአ ፍጤ። አከሲንስ እስራኤሎተ በራሬ። ");
INSERT INTO gaze_vpl VALUES ("JG4_1","008_4_1","JDG","4","1","1","ኤርገ ኤሁድ ዱኤ ቦዴ እስራኤሎን አመስ ፉለ ዋቀዮ ዱረት ዋን ሀማ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("JG4_2","008_4_2","JDG","4","2","2","ከናፉ ዋቀዮ ያቢን ሞቲ ከነኣን ከን ሃዞር ታኤ ቡልቻ ቱሬት ደበርሴ እሳን ጉርጉሬ። አጀጃን ሎልቶተሳ ሲሳራ ጄዸመ ቱሬ፤ እንስ ሀሮሼት ሀጎይም ኬሰ ጅራተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG4_3","008_4_3","JDG","4","3","3","እን ሰበቢ ጋሪወን ስቢላ ዽበ ሰገል ቀቡፍ ወጋ ድግደመ አከ መሌ እስራኤሎተ ሀጩጬ፤ እሳንስ ገርጋርሰ በርባቸ ዋቀዮት እየተን። ");
INSERT INTO gaze_vpl VALUES ("JG4_4","008_4_4","JDG","4","4","4","ዬሮ ሰነት ኒቲን ለፊዶት ዴቦራን ራጅቲን እስራኤልን ቡልቻ ቱርቴ። ");
INSERT INTO gaze_vpl VALUES ("JG4_5","008_4_5","JDG","4","5","5","እሼንስ ብየ ጋራ ኤፍሬምት ሙከ ሜጢ ዴቦራ ከን ራማፊ ቤትኤል ግዱት አርገሙ ሰነ ጀለ ቴሴ ሙርቲ ኬና ቱርቴ። ሰብን እስራኤልስ ሙርቲ አርገቹፍ ገረሼ ዹፋ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG4_6","008_4_6","JDG","4","6","6","እሼንስ ባራቅ እልመ አቢኖአም ብየ ንፍታሌም መጋላ ቃዴሺቲ ዋምስፈቴ አከነ ጄቴን፤ “ዋቀዮ ዋቅን እስራኤል አከነ ጄዼ ስ አጀጀ፤ ‘ከእ፤ ጎሰ ንፍታሌሚፊ ጎሰ ዜቡሎን ኬሳ ነመ ኩመ ኩዸን ፉዸዹቲ ቱሉ ታቦሪት ኦል በእ። ");
INSERT INTO gaze_vpl VALUES ("JG4_7","008_4_7","JDG","4","7","7","አንስ ሲሳራ፣ አጀጃ ሎልቶተ ያቢን ሰነ ጋሪወን ሎላቲፊ ሎልቶተሳ ወጅን አከ እን ገረ ለገ ቂሾንት በኡ ነንከካሰ፤ እሰስ ሀርከኬት ደበርሴ ነንኬነ።’ ” ");
INSERT INTO gaze_vpl VALUES ("JG4_8","008_4_8","JDG","4","8","8","ባራቅስ፣ “ዮ አት ነ ወጅን ዴምቴ፣ አን ነንዴመ፤ ዮ አት ነ ወጅን ህንዴምን ገሩ አንስ ህንዴሙ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JG4_9","008_4_9","JDG","4","9","9","ዴቦራንስ፣ “አን ዹጉማን ስ ፋነ ነንዴመ። ዮ አት ሃለ ከናን ዴምቴ ገሩ ኡልፍን ስኢፍ ህንተኡ፤ ዋቀዮ ደበርሴ ሲሳራ ሀርከ ዱበርቲት ኬናቲ” ጄቴን። ከናፉ ዴቦራን ባራቅ ፋነ ገረ ቃዴሽ ዴምቴ፤ ");
INSERT INTO gaze_vpl VALUES ("JG4_10","008_4_10","JDG","4","10","10","ባራቅስ አችት ነሞተ ጎሰ ዜቡሎኒፊ ጎሰ ንፍታሌም ወልት ዋሜ። ነሞትን ኩመ ኩዸን እሰ ዱካ ቡአን፤ ዴቦራንስ እሰ ፋነ ዴምቴ። ");
INSERT INTO gaze_vpl VALUES ("JG4_11","008_4_11","JDG","4","11","11","ዬሮ ሰነት ሄቤር ነምች ጎሰ ቄን አባን ኒቲ ሙሴ ሱን ቄኖተ እልማን ሆባብ ካንራ ጭቴ ቃዴሽ ብረት ለፈ ዘኣናኒም ጄዸሙት ቅልጡ ጉዳ ጀለ ዱንካነሳ ዻበቴ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG4_12","008_4_12","JDG","4","12","12","ሲሳራን ዮሙ አከ ባራቅ እልም አቢኖአም ሱን ገረ ቱሉ ታቦርት ኦል በኤ ዸገኤት፣ ");
INSERT INTO gaze_vpl VALUES ("JG4_13","008_4_13","JDG","4","13","13","ጋሪወን ስቢላ ዽበ ሰገሊፊ ሎልቶተሳ ከኔን ሀሮሼት ሀጎይሚ ሀመ ለገ ቂሾንት አርገመን ሁንዱማ ወልት ቀበቴ። ");
INSERT INTO gaze_vpl VALUES ("JG4_14","008_4_14","JDG","4","14","14","ከነረት ዴቦራን ባራቂን፣ “ከእ! ጉያን ዋቀዮ ሲሳራ ደበርሴ ሀርከኬት ኬኔ ሀርአ። ኩኖ ዋቀዮ ስ ዱረ በኤረ” ጄቴ። ከናፉ ባራቅ ነሞተ ኩመ ኩዸን ፉዸቴ ቱሉ ታቦርራ ገድ ቡኤ። ");
INSERT INTO gaze_vpl VALUES ("JG4_15","008_4_15","JDG","4","15","15","ዋቀዮስ አከ ሲሳራን፣ ጋሪወንሳቲፊ ሎልቶትንሳ ሁንድኑ ጎራዴዻን ፉለ ባራቅ ዱረት ሞአተመኒ ዱበት ዴብአን ጎዼ፤ ሲሳራን ጋሪሳራ ቡኤ ሚላን በቀቴ። ");
INSERT INTO gaze_vpl VALUES ("JG4_16","008_4_16","JDG","4","16","16","ባራቅ ገሩ ጋሪወኒፊ ሎልቶተ ሲሳራ ሀመ ሀሮሼት ሀጎይሚት አርኤ፤ ሎልቶትን ሲሳራ ሁንድኑ ጎራዴዻን ዹመን። ነምን ቶኮዩ ህንሀፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JG4_17","008_4_17","JDG","4","17","17","ሲሳራን ገሩ ሰበቢ ያቢን ሞትቸ ሃዞሪፊ ሄቤር ነምቸ በልበለ ቄን ሰነ ግዱ ሀሪሮን ጋሪን ቱሬፍ ገረ ዱንካነ ያኤል ኒቲ ሄቤር ሰናት ሚላን በቀቴ። ");
INSERT INTO gaze_vpl VALUES ("JG4_18","008_4_18","JDG","4","18","18","ያኤልስ ሲሳራ ስመቹፍ ገድ ባቴ፣ “ኮቱ ያ ጎፍታኮ፤ ኮቱ ኦል ሴን፤ ህንሶዳትን” እሳን ጄቴ። እንስ ዱንካነሼ ሴኔ፤ እሼንስ ወያ እሰረ ቡፍቴ ዾክስቴ። ");
INSERT INTO gaze_vpl VALUES ("JG4_19","008_4_19","JDG","4","19","19","እንስ፣ “አን ዼቦዼረ፤ ማሎ ብሻን ና ኬን” ጄዼን። እሼንስ ቀቤ ኣነኒ በንቴ ዋን እን ዹጉ ኬንቴፊ እሰ ዾክስቴ። ");
INSERT INTO gaze_vpl VALUES ("JG4_20","008_4_20","JDG","4","20","20","እንስ፣ “በልበለ ዱንካና ዱረ ዻበዹ፤ ዮ ኤኙዩ ዹፌ፣ ‘ነምን አስ ጅራ?’ ሲን ጄዼ፣ ‘ህንጅሩ’ ጄዽ” እሼን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG4_21","008_4_21","JDG","4","21","21","ያኤል ኒቲን ሄቤር ገሩ ኡቱ ሲሳራን ህርበ ጭማ ኬሰ ጅሩ ቆፎ ዱንካናፊ ቡሩሰ ፉዸቴ ሱተ ጄቴ ብረ ጌሴ። ቆፎ ሰናንስ እሰ ወራንቴ ለፈት ሆዽቴ፤ እንስ ንዱኤ። ");
INSERT INTO gaze_vpl VALUES ("JG4_22","008_4_22","JDG","4","22","22","ዮሙ ባራቅ ሲሳራ ዱካ ቡኤ ዹፌትስ፣ ያኤል እሰ ስመቹዻፍ ገድ ባቴ፣ “ኮቱ ነመ አት በርባዱ ስተን አርግሲሳ” ጄቴን። ከናፉ እን እሼ ወጅን ገረ ዱንካንቻት ኦል ሴኔ ሲሳራ አኩመ እሌንሳ ቆፎዻን ወራነሜት ሬፈሳ አርጌ። ");
INSERT INTO gaze_vpl VALUES ("JG4_23","008_4_23","JDG","4","23","23","ዋቅንስ ጋፈ ሰነ አከ ያቢን ሞቲን ከነኣኖታ ፉለ እስራኤሎታ ዱረት ሞአተሙ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("JG4_24","008_4_24","JDG","4","24","24","ሀርክ እስራኤሎታስ ሀመ እሳን ያቢን ሞትቸ ከነኣኖታ ገላፈተንት ጀጀባቻ ዴሜ። ");
INSERT INTO gaze_vpl VALUES ("JG5_1","008_5_1","JDG","5","1","1","ጋፈስ ዴቦራፊ ባራቅ እልም አቢኖአም አከነ ጄዸኒ ፋርፈተን፦ ");
INSERT INTO gaze_vpl VALUES ("JG5_2","008_5_2","JDG","5","2","2","“ዮሙ እልማን ሞቶታ እስራኤልን ሆገነን፣ ዮሙ ሰብን እስራኤልስ ጃለቴ ኦፍ ኬኑት ዋቀዮን ገለቴፈዻ! ");
INSERT INTO gaze_vpl VALUES ("JG5_3","008_5_3","JDG","5","3","3","“ያ ሞቶተ፣ ዋን ከነ ዸገኣ! ቡልችቶትንስ ዸጌፈዻ! ዋቀዮን ነንፋርፈዸ፤ አመሌ ነንፋርፈዸ፤ ዋቀዮ ዋቀ እስራኤሊፍ ነንዌድሰ። ");
INSERT INTO gaze_vpl VALUES ("JG5_4","008_5_4","JDG","5","4","4","“ያ ዋቀዮ፣ ዬሮ አት ብየ ሴኢሪ ባቴ፣ ዬሮ አት ብየ ኤዶሚ ካቴ፣ ለፍት ንሶቾቴ፤ ሰሚወንስ ቦካ፣ ዱሜሶትንስ ብሻን ገድ ሮብሰን። ");
INSERT INTO gaze_vpl VALUES ("JG5_5","008_5_5","JDG","5","5","5","ቱሉወን ፉለ ዋቀዮ ዋቀ ሲና ዱረት፣ ፉለ ዋቀዮ ዋቀ እስራኤል ዱረት ንራፈመን። ");
INSERT INTO gaze_vpl VALUES ("JG5_6","008_5_6","JDG","5","6","6","“በረ እልመ አናት፣ ጀበነ ሸምጋር፣ በረ ያኤል ኬሰ ዳንዲወን ንኦነን፤ ከራ ዴምቶትንስ ዳንዲ ጀጀልኣረ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("JG5_7","008_5_7","JDG","5","7","7","ሀመ አን ዴቦራን፣ ሃዸ ተኤ እስራኤሊፍ ከኡት፣ ገንዶትን እስራኤል ዱዋ ሀፉ። ");
INSERT INTO gaze_vpl VALUES ("JG5_8","008_5_8","JDG","5","8","8","ዮሙ እሳን ዋቆተ ሃራ ፍለተንት፣ ወራን ሀመ ከረ መጋላት ዹፌ፤ ጋቸን ዮካን ኤቦን ቶኮ፣ እስራኤሎተ ኩመ አፉርተመ ግዱት ህንአርገምኔ። ");
INSERT INTO gaze_vpl VALUES ("JG5_9","008_5_9","JDG","5","9","9","ገራንኮ ቡልችቶተ እስራኤል ከኔን ፌዺዻን ሰበ ግዱት አርገመን ወጅን ጅረ። ዋቀዮን ሌልሳ! ");
INSERT INTO gaze_vpl VALUES ("JG5_10","008_5_10","JDG","5","10","10","“እስን ወር ሀሮተ አዳዲ ያበተን፣ ወር ኮራ በለዲ ቀቡረ ቴሰን፣ ወር ከራረ ዴምተን ሁበዻ፤ ");
INSERT INTO gaze_vpl VALUES ("JG5_11","008_5_11","JDG","5","11","11","ሰገሌ ፋርፈቶታ ዸገኣ። እሳን ሆጂ ቀጄሉማ ዋቀዮ፣ ሆጂ ቀጄሉማ ሎልቶትንሳ እስራኤል ኬሰት ጎዸን ኦዴሱ። “ኤርገሲ ሰቦትን ዋቀዮ፣ ገረ ከረ መጋለቲት ገድ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("JG5_12","008_5_12","JDG","5","12","12","‘ያ ዴቦራ! ደመቅ፤ ደመቅ፤ ደመቅ፤ ደመቅ፤ ፋርፈናስ ፋርፈዹ! ያ ባራቅ! ደመቅ፤ ያ እልመ አቢኖአም ቦጅአምቶተኬ ቦጅኢ ፉዸዹ።’ ");
INSERT INTO gaze_vpl VALUES ("JG5_13","008_5_13","JDG","5","13","13","“ነሞትን ሀፈንስ፣ ገረ ወረ ጉርጉዳት ገድ ቡአን፤ ሰብን ዋቀዮስ፣ አከ ሎልቱ ጀባት ገረኮ ዹፌ። ");
INSERT INTO gaze_vpl VALUES ("JG5_14","008_5_14","JDG","5","14","14","ወር ህድሳኒ አማሌቅ ኬሰ ጅሩ ቶኮ ቶኮስ ኤፍሬም ዹፈን፤ ቤንያምስ ነሞተ ስ ዱካ ቡአን ወጅን ቱሬ። አጀጆትን ሎልቶተ ማኪር፣ ወር ቦኩ አጀጁ ቀበተንስ ዜቡሎኒ ገድ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("JG5_15","008_5_15","JDG","5","15","15","ሀንገፎትን ይሳኮር ዴቦራ ወጅን ቱረን፤ ይሳኮርስ ባራቅ ወጅን ቱሬ፤ እንስ ባራቅ ወጅን ገረ ሱሉላት ገድ ቡኤ። ጎሰ ሩቤን ግዱ፣ ቆረትኖ ያዳ ጉዳቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG5_16","008_5_16","JDG","5","16","16","አት ማሊፍ መርአቹሳኒ ዸገኡፍ ጄቴ ጎለ ቡሻዬ ኬሰ ቱርቴ? ጎሰ ሩቤን ግዱ፣ ቆረትኖ ያዳ ጉዳሳቱ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG5_17","008_5_17","JDG","5","17","17","ግልኣድ ዮርዳኖስ ገመ ታኤ፤ ዳን ማሊፍ ዶኒወን ኬሰት ሀፌ? ኣሼር ቀርቀረ ገላናት ሀፌ፤ ቡፈተሳ ኬሰስ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG5_18","008_5_18","JDG","5","18","18","ሰብን ዜቡሎን ዱኣፍ ኦፍ ሳጥሌ፤ ንፍታሌምስ ጋረን ብየሳረት አከሱመ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("JG5_19","008_5_19","JDG","5","19","19","“ሞቶትን ዹፈኒ ሎለን፤ ሞቶትን ከነኣንስ ተአናክት ብሻኖተ ሜግዶ ብረት ሎለን፤ ቦጁ ሜቲ ቶኮሌ ህንፉዸትኔ። ");
INSERT INTO gaze_vpl VALUES ("JG5_20","008_5_20","JDG","5","20","20","ሰሚ ኬሳ ኡርጂወን ንሎለን፤ አዴምሰሳኒረትስ ሲሳራዻን ሎለን። ");
INSERT INTO gaze_vpl VALUES ("JG5_21","008_5_21","JDG","5","21","21","ለግን ዱሪ፣ ለግን ቂሾን፣ ለግን ቂሾን ሱን ሀጣኤ እሳን ፉዸቴ። ያ ሉቡኮ፣ ጀባዹ ፉል ዱረት ዴም! ");
INSERT INTO gaze_vpl VALUES ("JG5_22","008_5_22","JDG","5","22","22","ኮቴን ፈርዴኒ ጉድሴ ድድቼ፤ ንጉሉፈን፤ ጀቤሰኒስ ጉሉፈን። ");
INSERT INTO gaze_vpl VALUES ("JG5_23","008_5_23","JDG","5","23","23","ኤርገማን ዋቀዮስ፣ ‘ሜሮዝን አባራ። ሰበሼስ ጀቤሳቲ አባራ፤ አከ ዋቀዮ ወረ ጀጀቦት ከኡ ገርጋሩዻፍ፣ እሳን ዋቀዮን ገርጋሩዻፍ ህንዹፍኔቲ’ ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG5_24","008_5_24","JDG","5","24","24","“ያኤል ኒቲን ሄቤር ቄንቻ ሱን ዱበርቶተ ሁንደ ኬሳ ሃኤብፈምቱ፤ እሼን ዱበርቶተ ዱንካነ ኬሰ ጅራተን ሁንደ ኬሳ ሃኤብፈምቱ። ");
INSERT INTO gaze_vpl VALUES ("JG5_25","008_5_25","JDG","5","25","25","እን ብሻን ከዸቴ፤ እሼንሞ ኣነን ኬንቴፍ፤ ቀቤ ኡልፍናት እትቱ ዽኤስቴፍ። ");
INSERT INTO gaze_vpl VALUES ("JG5_26","008_5_26","JDG","5","26","26","ሀርከሼ ገረ ቆፎ ዱንካናት ሂጠቴ፤ ሀርከሼ ምርጋቲን ቡሩሰ ፉዸቴ፤ እሼንስ ሲሳራ ዾፍቴ መታሳ ቡሩቅስቴ፤ ወራንቴስ እሌሳ ኬሰ ፉላፍቴ። ");
INSERT INTO gaze_vpl VALUES ("JG5_27","008_5_27","JDG","5","27","27","እንስ ሚለሼ ጀለት ጎምብፈሜ፤ ኩፌ ድሪሬስ። ሚለሼ ጀለት ጎምብፈሜ፤ ንኩፌ፤ እዶ ጎምብፈሜትስ ኩፌ ዱኤ። ");
INSERT INTO gaze_vpl VALUES ("JG5_28","008_5_28","JDG","5","28","28","“ሃት ሲሳራ ፎዳ ኬሳን ገድ እላልቴ፤ ቃወ ኬሳንስ እይቴ፣ ‘ጋሪንሳ ማሊፍ ዹፉፍ ለፈረ ሀርክፈቴ? ድድቹን ጋሪወንሳ ማሊፍ ቱሬ?’ ጄቴ። ");
INSERT INTO gaze_vpl VALUES ("JG5_29","008_5_29","JDG","5","29","29","ዱበርቶተሼ ኬሳ እሼን ኦጌቲን ዴቢ ኬንቴፍ፤ ተኡስ እሼን ኦፉመሼቲን ዴብፍቴ፣ ");
INSERT INTO gaze_vpl VALUES ("JG5_30","008_5_30","JDG","5","30","30","‘እሳን ቦጁ አርገተኒ አዳን ቆደቹት ጅሩ ምቲ? ቶኮን ቶኮን ነማ ዱበርቲ ቶኮ ቶኮ ዮካን ለመ ለመ አርገተ ምቲ? ሲሳራዻፍ ኡፈትን ቦጁ ከን ሀሉዻን ፋዬፈሜ፣ ኡፈትን ሀሉዻን ሚዸግፈሜ ሆዸሜ፣ ሞርመኮቲፍሞ ኡፈተ አከ መሌ ሚዸግፈሜ ሆዸሜ ቆዱ ምቲ? ኩን ሁንድ ቦጁዸ።’ ");
INSERT INTO gaze_vpl VALUES ("JG5_31","008_5_31","JDG","5","31","31","“ከናፉ ያ ዋቀዮ፣ ዲኖትንኬ ሁንድ ሃበርበዳአን! ወር ስ ጃለተን ገሩ አከ ቢፍቱ፣ እሼ ሁምነ ጉቱን ባቱ ሰና ሃተአን።” ኤርገሲ ብየቲን ወጋ አፉርተመ ነጋ አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("JG6_1","008_6_1","JDG","6","1","1","እስራኤሎን ፉለ ዋቀዮ ዱረት ዋን ሀማ ሆጄተን፤ እንስ ደበርሴ ወጋ ቶርባፍ ሀርከ ምድያኖታት እሳን ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("JG6_2","008_6_2","JDG","6","2","2","እስራኤሎን ሰበቢ ሀርክ ምድያኖታ እሳንት ጀባቴፍ ቱሉወንረት፣ ሆልቃፊ ደአትኖ ጀባ ኬሰት ኦፊሳኒቲፍ እዶ ጅራተኒፊ እዶ እት ደአተን ቆጴፈተን። ");
INSERT INTO gaze_vpl VALUES ("JG6_3","008_6_3","JDG","6","3","3","ዬሮ እስራኤሎን ምዻን ፈጫፈተን ሁንደ ምድያኖትን፣ አማሌቆትኒፊ ነሞትን በአ ቢፍቱ ካን ዹፈኒ እሳን ዌረሩ ቱረን። ");
INSERT INTO gaze_vpl VALUES ("JG6_4","008_6_4","JDG","6","4","4","አችስ ቁበተኒ ምዻን ሀመ ጋዛት ጅሩ ሁንዱማ በሌሰን፤ እሳን ዋን ሉቡ ቀቡ ሆሎተ፣ ሎን ዮካን ሀሮተ ቶኮሌ እስራኤሎታፍ ህንሀምብፍኔ። ");
INSERT INTO gaze_vpl VALUES ("JG6_5","008_6_5","JDG","6","5","5","አኩመ ቱተ ሀዋንሳትስ ሆሪፊ ዱንካነሳኒ ፉዸተኒ እሳንረ ያአን። ነሞታፊ ጋለወንሳኒ ለካኡን ህንደንደአሙ ቱሬ፤ እሳንስ ብየ ሰነ በርበዴሱዻፍ ዌረረን። ");
INSERT INTO gaze_vpl VALUES ("JG6_6","008_6_6","JDG","6","6","6","ሰበቢ ምድያኖትን አከ መሌ እሳን ህዮምሰኒፍ እስራኤሎን ገርጋርሰ በርባቸ ገረ ዋቀዮት እየተን። ");
INSERT INTO gaze_vpl VALUES ("JG6_7","008_6_7","JDG","6","7","7","ዬሮ እስራኤሎን ሰበቢ ምድያኖታቲፍ ገረ ዋቀዮት እየተንት፣ ");
INSERT INTO gaze_vpl VALUES ("JG6_8","008_6_8","JDG","6","8","8","እን ራጂ አከነ ጄዼ ዱበቱ ቶኮ እሳኒፍ ኤርጌ፤ “ዋቀዮ ዋቅን እስራኤል አከነ ጄዸ፦ አን ብየ ግብጥ፣ ብየ ገርቡማቲ ባሴን እስን ፍዴ። ");
INSERT INTO gaze_vpl VALUES ("JG6_9","008_6_9","JDG","6","9","9","አን ሁምነ ወረ ግብጢፊ ሀርከ ጩንቁርስቶታ ጀላ እስን ፉሬ ፉለኬሰን ዱራስ አርኤ እሳን ባሴ ብየሳኒ እስኒ ኬኔረ። ");
INSERT INTO gaze_vpl VALUES ("JG6_10","008_6_10","JDG","6","10","10","እስኒንስ፣ ‘አን ዋቀዮ ዋቀኬሰን፤ ዋቆተ አሞሮታ ከኔን እስን ብየሳኒ ኬሰ ጅራተን ሰና ህንዋቄፈትና’ ጄዼረ። እስን ገሩ ሰገሌኮ ህንዸጌኜ።” ");
INSERT INTO gaze_vpl VALUES ("JG6_11","008_6_11","JDG","6","11","11","ኤርገማን ዋቀዮስ ገንደ ኦፍራ ጄዸሙ ዹፌ ቅልጡ ዮኣሽ ነምቸ ሰኚ አቢኤዜር ሰና ጀለ ታኤ፤ ግዴዎን እልም ዮኣሽሞ አከ ምድያኖትን ህንአርግኔፍ እዶ ወይኒን እት ጩንፈሙት ዾክሴ ቀመዲ ዸአተ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG6_12","008_6_12","JDG","6","12","12","ኤርገማን ዋቀዮስ እሰት ሙልአቴ፣ “ያ ሎልቱ ጎተነነ፣ ዋቀዮ ስ ወጅን ጅረ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JG6_13","008_6_13","JDG","6","13","13","ግዴዎን ገሩ አከነ ጄዼ ዴብሴ፤ “ገሩ ያ ጎፍታ፣ ኡቱ ዋቀዮ ኑ ወጅን ጅራቴ ወን ኩን ሁንድ ማሊፍ ኑረ ገአ? ድንቂወንሳ ከኔን አቦቲንኬኘ፣ ‘ዋቀዮ ብየ ግብጢቲ ኑ ባሴረ’ ጄዸኒ ኑት ህመን ሱን ሁንድ ኤሰ ጅሩሬ? አመ ገሩ ዋቀዮ ኑ ዺሴ ሀርከ ምድያኖታት ደበርሴ ኑ ኬኔረ።” ");
INSERT INTO gaze_vpl VALUES ("JG6_14","008_6_14","JDG","6","14","14","ዋቀዮ ገረ ግዴዎንት ገረገሌ፣ “ሁምነ ቀብዱ ከናን ዸቂቲ ሀርከ ምድያኖታ ጀላ እስራኤሎተ ብልሰ ባስ። አነቱ ስ ኤርጋ ጅረ ምቲ?” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JG6_15","008_6_15","JDG","6","15","15","ግዴዎን ገሩ፣ “ያ ጎፍታ፣ ጎስትኮ ሰኚ ምናሴ ኬሳ ባይኤ ደዸባዸ፤ አንስ ማቲኮ ኬሳ ነመ ገድ ኣናዸ። ኤጋ አን አከምን ሰበ እስራኤል ብልሶምሱ ደንደአሬ?” ጄዼ ጋፈቴ። ");
INSERT INTO gaze_vpl VALUES ("JG6_16","008_6_16","JDG","6","16","16","ዋቀዮስ፣ “አን ስ ወጅን ጅረ፤ አትስ ምድያኖተ ሁንደ ወልት ቀብዴ ዾፍተ” ጄዼ ዴብሴፍ። ");
INSERT INTO gaze_vpl VALUES ("JG6_17","008_6_17","JDG","6","17","17","ግዴዎንስ አከነ ጄዼ ዴብሴ፤ “ዮ አን ፉለኬ ዱረት ሱራ አርገዼ ጅራዼ፣ ከን ነት ዱበቻ ጅሩ ዹጉማን ስእ ተኡ መለቶ ነ አርግሲስ። ");
INSERT INTO gaze_vpl VALUES ("JG6_18","008_6_18","JDG","6","18","18","ማሎ ሀመ አን ዴብኤ ኣርሳኮ ፍዴ ፉለኬ ዱረት ዽኤሱት ህንዴምን።” ዋቀዮስ፣ “አን ሀመ አት ዴብቱት ስን ኤገ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JG6_19","008_6_19","JDG","6","19","19","ግዴዎን ገረ መነሳ ዴሜ እልሞ ሬኤ ቶኮ ቀሌ ቆጴሴ ዳኩ ኢፊ ቶኮ ፉዼ ቡዴነ ራጭቲ ህንቀብኔ ቶልቼ። ፎን ሰነስ ጉንዶረ ካኤ ብሻን ፎን ሰናሞ ኦኮቴት ነቄ ፍዱዻን ቅልጡ ጀለት ኣርሳ እሳፍ ዽኤሴ። ");
INSERT INTO gaze_vpl VALUES ("JG6_20","008_6_20","JDG","6","20","20","ኤርገማን ዋቃስ፣ “ፎኒፊ መጥኖ ከነ ፉዺቲ ከታ ከነረ ካእ፤ ብሻንሳሞ ዸንገላስ” ጄዼ። ግዴዎንስ አከሱመ ጎዼ። ");
INSERT INTO gaze_vpl VALUES ("JG6_21","008_6_21","JDG","6","21","21","ኤርገማን ዋቀዮ ሱንስ ፊጤ ኡሌ ሀርከሳ ቱሬቲን ፎኒፊ መጥኖ ሰነ ቱቄ። እብድ ከታ ኬሳ በኤ ፎኒፊ መጥኖ ሰነ ኛቴ። ኤርገማን ዋቀዮስ ፉለሳ ዱራ ዸበሜ። ");
INSERT INTO gaze_vpl VALUES ("JG6_22","008_6_22","JDG","6","22","22","ግዴዎን ዮሙ አከ ኤርገማ ዋቀዮ አርጌ ቤኬት፣ “ወዮ፣ ያ ዋቀዮ ጎፍታ! አን እፋን እፈት ኤርገማ ዋቀዮ አርጌራቲ!” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG6_23","008_6_23","JDG","6","23","23","ዋቀዮ ገሩ፣ “ነጋን ሲፍ ሃተኡ! ህንሶዳትን፣ አት ህንዱቱቲ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JG6_24","008_6_24","JDG","6","24","24","ከናፉ ግዴዎን ዋቀዮፍ አችት እዶ ኣርሳ እጃሬ፣ “ዋቀዮ ነጋዸ” ጄዼ ሞጋሴ። እዶን ኣርሳ ኩን ሀመ ሀርኣት ለፈ አቢኤዜሮታረ እዶ ኦፍራ ጄዸሙ ዻበቴረ። ");
INSERT INTO gaze_vpl VALUES ("JG6_25","008_6_25","JDG","6","25","25","ዋቀዮ ሀልከኑመ ሰነ አከነ እሳን ጄዼ፤ “ከረ ሎን አባኬቲ ኬሳ ኮርመ ለመፋ ከን ወጋ ቶርበ ጉቴ ቶኮ ፉዽ። እዶ ኣርሳ ከን አባንኬ በኣሊፍ ቶልቼ ዲግ፤ ኡቱባ ኣሼራ ከን እሰ ብረ ዻበሜስ ጅግስ። ");
INSERT INTO gaze_vpl VALUES ("JG6_26","008_6_26","JDG","6","26","26","ፊጤ ጋረ ከናረትስ ዋቀዮ ዋቀኬቲፍ እዶ ኣርሳ በሬዳሳ ቶልች። ቆራን ኡቱባ ኣሼራ ከን ጅግስቴ ሰነትስ ፈየደሚ ኮርመ ለመፋ ሰነ ኣርሳ ጉበሙ ጎዺቲ ዽኤስ።” ");
INSERT INTO gaze_vpl VALUES ("JG6_27","008_6_27","JDG","6","27","27","ግዴዎንስ ሆጄቶተሳ ኬሳ ነመ ኩዸን ፉዸቴ አኩመ ዋቀዮ እሰት ህሜ ሰነ ጎዼ። ገሩ ዋን ማቲሳቲፊ ነሞተ መጋላ ሰነ ጅራተን ሶዳቴፍ ጉያ አዲን ጎቹረ ሀልከን ፍለቴ። ");
INSERT INTO gaze_vpl VALUES ("JG6_28","008_6_28","JDG","6","28","28","ገነመ በሪ ዮሙ ነሞትን መጋላ ሰና ህርባ ከአንት እዶን ኣርሳ በኣል ዲገሜ፣ ኡቱባን ኣሼራስ ኩፌ ኮርም ለመፋን እዶ ኣርሳ ሃራ ቶልፈሜ ሰነረት ቀለሜ ቱሬ! ");
INSERT INTO gaze_vpl VALUES ("JG6_29","008_6_29","JDG","6","29","29","እሳንስ፣ “ኤኙቱ ዋን ከነ ሆጄቴ?” ጄዸኒ ወል ጋፈተን። ዮሙ ገድ ፈጌኛን ቆረተንትስ፣ “ግዴዎን እልመ ዮኣሽቱ ዋን ከነ ጎዼ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JG6_30","008_6_30","JDG","6","30","30","ነሞትን መጋላ ሰናስ ዮኣሺን፣ “እልመኬ ገድ ባስ። እን ሰበቢ እዶ ኣርሳ በኣል ዲጌ ኡቱባ ኣሼራስ ጅግሴፍ አጄፈሙ ቀበ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JG6_31","008_6_31","JDG","6","31","31","ዮኣሽ ገሩ ሰበ ኣሪዻን ጉተሜ እሰ መርሴ ሰናን አከነ ጄዼ፤ “እስን በኣሊፍ ፈልሙ በርባዱ? እሰስ ኦልቹ ፌቱ? ነምን እሳፍ ፈልሙ ዮ ጅራቴ እን ገነመ ሃዱኡ! በኣል ኡቱ ዹጉማን ዋቀ ተኤ ዮሙ ነምን ቶኮ እዶ ኣርሳሳ ዲጉ እን ኦፍራ ዾዉ ደንደአ ቱሬ።” ");
INSERT INTO gaze_vpl VALUES ("JG6_32","008_6_32","JDG","6","32","32","ከናፉ እሳን ሰበቢ እን እዶ ኣርሳሳ ጀላ ዲጌፍ፣ “በኣል መታንሳ ሃፈልመቱ” ጄቹዻን ግዴዎኒን፣ “ዬሩብ-በኣል” ጄዸኒ ዋመን። ");
INSERT INTO gaze_vpl VALUES ("JG6_33","008_6_33","JDG","6","33","33","ኤርገሲስ ምድያኖትን ሁንድ፣ አማሌቆትኒፊ ነሞትን ከራ በአ ቢፍቱ ሁምነሳኒ ወልት ደበለተኒ ዮርዳኖስ ጬኡዻን ሱሉለ ይዝርኤል ኬሰ ቁበተን። ");
INSERT INTO gaze_vpl VALUES ("JG6_34","008_6_34","JDG","6","34","34","ሀፉር ዋቀዮስ ዹፌ ግዴዎንረ ቡኤ፤ እንስ አከ አቢኤዜሮን እሰ ዱካ ቡአኒፍ ዋሙፍ መለከተ አፉፌ። ");
INSERT INTO gaze_vpl VALUES ("JG6_35","008_6_35","JDG","6","35","35","ጉቱማ ምናሴ ኬሰስ ኤርገሞተ ኤርገቴ፤ እሳንስ እሰ ዱካ ቡኡፍ ወልት ቀበመን፤ አከሱመስ ገረ ኣሼር፣ ዜቡሎኒፊ ንፍታሌምት ኤርገቴ፤ እሳንስ ጀረ ስመቹፍ ገድ ያአን። ");
INSERT INTO gaze_vpl VALUES ("JG6_36","008_6_36","JDG","6","36","36","ግዴዎንስ ዋቃን አከነ ጄዼ፤ “ዮ አት አኩመ ዋዳ ገልቴት ሀርከኮቲን እስራኤል ፉርቴ፣ ");
INSERT INTO gaze_vpl VALUES ("JG6_37","008_6_37","JDG","6","37","37","ኩኖ፣ አን ወያ ርፌንሰ ሆላራ ሆጄተሜ ቶኮ ኦብዲረ ነንድሪርሰ። ዮ ርፌንሰ ሆላ ሰነ ቆፈረ ፍጤንስ ቡኤ ለፍትሞ ጎጎጋ ተኤ፣ አን አከ አት አኩመ ጄቴ ሰነ ሀርከኮቲን እስራኤል ፉርቱ ነንቤከ።” ");
INSERT INTO gaze_vpl VALUES ("JG6_38","008_6_38","JDG","6","38","38","ወን ሱንስ አከሱመ ተኤ። ግዴዎንስ ጉያ እት ኣኑ ገነማን ከኤ፤ ዬሮ እን ወያ ርፌንሰ ሆላራ ሆጄተሜ ሰነ ምጪሬትስ ብሻን ወጪቲ ጉቱቱ ኬሳ ጩንፈሜ። ");
INSERT INTO gaze_vpl VALUES ("JG6_39","008_6_39","JDG","6","39","39","ከነረት ግዴዎን ዋቃን፣ “ነት ህንዼከምን። አመሌ ዋን ቶኮን ስ ጋፈዸ። አከ አን ርፌንሰ ሆላ ሰነረት ያሊ ብራ ጎዹፍ ና ኤየም። አመሞ ርፌንሰ ሰነ ጎጎግሲቲ ፍጤንሰ ለፈት ኡፍስ።” ");
INSERT INTO gaze_vpl VALUES ("JG6_40","008_6_40","JDG","6","40","40","ዋቅንስ ሀልከን ሰነ አከሱመ ጎዼ። ርፌንሰ ሆላ ሰነ ቆፈቱ ጎጎጋ ቱሬ፤ ለፍት ጉቱን ፍጤንሳን ሀጉገሜ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG7_1","008_7_1","JDG","7","1","1","ዬሩብ-በኣል ነምች ግዴዎን ጄዸሙ ሱኒፊ ነሞትንሳ ሁንድ ገነመ ከአኒ ቡርቃ ሀሮድ ብረ ቁበተን። ቁበን ምድያኖታ እዶ ነሞትን ግዴዎን ቁበተን ሰናን ከራ ካባቲን ጋረ ሞሬ ብረ ሱሉለ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG7_2","008_7_2","JDG","7","2","2","ዋቀዮስ ግዴዎኒን አከነ ጄዼ፤ “አከ አን ምድያኖተ ደበርሴ ሀርከሳኒት ህንኬንኔፍ እስራኤሎን ስ ወጅን ጅረን አከ መሌ ባይኤዸ። አከ ሰብን እስራኤል፣ ‘ጀብነ ኮቱ ነ ኦልቼ’ ጄዼ ነት ህንኮሬፍ፣ ");
INSERT INTO gaze_vpl VALUES ("JG7_3","008_7_3","JDG","7","3","3","‘ነምን ሶዳቴ ሆለቴ ከምዩ ቱሉ ግልኣድ ዺሴ ገረ መነሳት ሃዴብኡ’ ጄዺቲ አመ ሰበት ህም።” ከናፉ ነሞትን ኩመ ድግደሚ ለመ ዴብአኒ ኩመ ኩዸን አችት ሀፈን። ");
INSERT INTO gaze_vpl VALUES ("JG7_4","008_7_4","JDG","7","4","4","ዋቀዮ ገሩ ግዴዎኒን አከነ ጄዼ፤ “አመዩ ነሞተ ባይኤቱ ጅረ። እሳን ፉዸዹቲ ገረ ብሻኒት ገድ ቡእ፤ አን አችት እሳን ገርገር ሲፍ ፎአ። ዮ አን፣ ‘እን ኩን ስ ወጅን ንዴመ’ ጄዼ፣ እን ንዴመ፤ ዮ አን፣ ‘እን ኩን ስ ወጅን ህንዴሙ’ ጄዼ ገሩ እን ህንዴሙ።” ");
INSERT INTO gaze_vpl VALUES ("JG7_5","008_7_5","JDG","7","5","5","ከናፉ ግዴዎን ነሞተ ገረ ብሻኒት ገድ ቡሴ። ዋቀዮስ አችት፣ “ወረ አኩመ ሰሬት አረባን ብሻን ዹገን፣ ወረ ጅልቤንፈተኒ ዹገንራ ገርገር ባስ” እሳን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG7_6","008_7_6","JDG","7","6","6","ነሞትን ዽበ ሰዲ ኮኜሳኒቲን ወራበተኒ ዹገን። ወር ሀፈን ሁንድ ገሩ ዹጉፍ ጅልቤንፈተን። ");
INSERT INTO gaze_vpl VALUES ("JG7_7","008_7_7","JDG","7","7","7","ዋቀዮ ግዴዎኒን፣ “አን ነሞተ ሀርከሳኒቲን ዹገን ዽበ ሰደን ከናን ስ ፉሬ ምድያኖተ ደበርሴ ሀርከኬት ነንኬነ። ወር ካን ሁንድ ገረ ቄኤሳኒት ሃዴብአን” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JG7_8","008_7_8","JDG","7","8","8","ከናፉ ግዴዎን አከ እስራኤሎን ሀፈን ሁንድ ገረ ዱንካነሳኒት ዴብአን ጎዼ ነሞተ ዽበ ሰደን ገሩ ቱርፈቴ፤ እሳንስ ወረ ካንራ ገላፊ መለከተ ፉዸተን። ቁበን ምድያኖታስ ግዴዎኒን ገድ ሱሉለ ኬሰ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG7_9","008_7_9","JDG","7","9","9","ሀልከኑመ ሰነ ዋቀዮ ግዴዎኒን አከነ ጄዼ፤ “ከኢቲ ቁበተ ሰነት ገድ ቡእ፤ አን ደበርሴ ሀርከኬት ሲፍን ኬናቲ። ");
INSERT INTO gaze_vpl VALUES ("JG7_10","008_7_10","JDG","7","10","10","አት ዮ ገድ ቡኡ ሶዳቴ ገሩ ተጃጅላኬ ፉራ ወጅን ገረ ቁበተ ሰናት ገድ ቡኢቲ ");
INSERT INTO gaze_vpl VALUES ("JG7_11","008_7_11","JDG","7","11","11","ዋን እሳን ዱበቻ ጅረን ዸገእ። ሰነ ቦዴ ቁበተ ሰነ ሩኩቱዻፍ ጀብነ ንአርገተ።” ከናፉ እኒፊ ተጃጅላንሳ ፉራን ገረ ሞጋ ቁበተ ሰናት ገድ ቡአን። ");
INSERT INTO gaze_vpl VALUES ("JG7_12","008_7_12","JDG","7","12","12","ምድያኖትን፣ አማሌቆትኒፊ ነሞትን በአ ቢፍቱቲ ዹፈን ሁንድ አኩመ ሆማ ሀዋንሳ ወልት ጎበተኒ ሱሉልቸ ኬሰ ቁበተኒ ቱረን። ባይእን ጋለወንሳኒስ አኩመ ጭረቸ ቀርቀረ ገላና ለኮብሰ ህንቀቡ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG7_13","008_7_13","JDG","7","13","13","ግዴዎንስ ኡቱ ነምች ቶኮ ዋኤ አብጁሳ ምቹ ኦፊሳት ህሙ አች ገኤ። ነምች ሱንስ አከነ ጄዼ፤ “አን አብጁ ቶኮ ነንአብጆዼ፤ ኩኖ መጥኖን ገርቡ ቶኮ ገንገለቻ ዹፌ ቁበተ ምድያኖታረ ቡኤ። እንስ ዹፌ አከ ዱንካን ጅጉፍ ሁምናን ዸኤ፤ ዱንካን ሱንስ ንኩፌ።” ");
INSERT INTO gaze_vpl VALUES ("JG7_14","008_7_14","JDG","7","14","14","ምቹንሳስ ዴብሴ፣ “ኩን ጎራዴ ግዴዎን እልመ ዮኣሽ እስራኤልቻት መሌ ዋን ብራ ምት። ዋቅንስ ምድያኖታፊ ጉቱማ ቁበተ ሰና ደበርሴ ሀርከ ግዴዎንት ኬኔረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG7_15","008_7_15","JDG","7","15","15","ግዴዎን ዮሙ አብጁ ሰናፊ ሂካሳ ዸገኤት ዋቃፍ ሰገዴ። ገረ ቁበተ እስራኤሎታትስ ዴብኤ፣ “ከኣ! ዋቀዮ ቁበተ ምድያኖታ ደበርሴ ሀርከኬሰንት ኬኔራ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG7_16","008_7_16","JDG","7","16","16","እንስ ነሞተ ዽበ ሰደን ገሬ ሰዲት ቆዱዻን፣ ሀርከ ሁንደሳኒት መለከታፊ ኦኮቴ ጉጭ ኬሰ ጅሩ ቀበቺሴ። ");
INSERT INTO gaze_vpl VALUES ("JG7_17","008_7_17","JDG","7","17","17","ግዴዎንስ አከነ እሳኒን ጄዼ፤ “ነ እላላ፤ ዋን አን ሆጄዹስ ሆጄዻ፤ ዮሙ አን ቀርቀረ ቁበትቻት ዽኣዹት ቀልቤፈዻቲ ዋኑመ አን ጎዹ ጎዻ። ");
INSERT INTO gaze_vpl VALUES ("JG7_18","008_7_18","JDG","7","18","18","ዬሮ አኒፊ ወር ነ ወጅን ጅረን ሁንዲ መለከተኬኘ አፉፍኑት፣ እስንስ ናኖ ቁበትቻ ሁንደት አፉፋቲ፣ ‘ዋቀዮፍ፣ ግዴዎኒፍስ’ ጄዻ እያ።” ");
INSERT INTO gaze_vpl VALUES ("JG7_19","008_7_19","JDG","7","19","19","ግዴዎኒፊ ነሞትን እሰ ወጅን ቱረን ዽብ ሱን አኩመ ዋርድዮትን ወል ጌደረኒን ጀልቀበ ኤጉምሰ ወለካ ሀልከኒት ቀርቀረ ቁበተ ሰና ብረ ገአን። እሳንስ መለከተሳኒ አፉፈኒ ኦኮቴ ሀርከሳኒ ጅሩ ጨጨብሰን። ");
INSERT INTO gaze_vpl VALUES ("JG7_20","008_7_20","JDG","7","20","20","ገሬን ሰደኑ መለከተሳኒ አፉፈኒ ኦኮቴ ሀርከሳኒ ጅሩ ጨጨብሰን። ሀርከ ብታት ጉጨ፣ ሀርከ ምርጋትሞ መለከተ አፉፈን ቀበተኒ፣ “ጎራዴ ዋቀዮቲፊ ግዴዎን!” ጄዸኒ እየን። ");
INSERT INTO gaze_vpl VALUES ("JG7_21","008_7_21","JDG","7","21","21","ቶኮን ቶኮን ነማስ ናኖ ቁበትቻት እዶ ኬነሜፍ ቀበቴ፤ ምድያኖትን ሁንድስ እያ በቀተን። ");
INSERT INTO gaze_vpl VALUES ("JG7_22","008_7_22","JDG","7","22","22","ዬሮ መለከትን ዽብ ሰደን ሱን አፉፈሜት ዋቀዮ አከ ነምን ቁበተ ሰነ ኬሰ ቱሬ ቶኮ ቶኮን ጎራዴሳ ወልት ሉቅፈቱ ጎዼ፤ ራያን ወራናስ ከራ ዜሬራቲን ገረ ቤት ሺጣት፣ እሰ ብረስ ደርበኒ ሀመ ዳሪ አቤል ሜሆላ እሼ ጠባት ብረ ጅርቱ ሰናት በቀተኒ ዴመን። ");
INSERT INTO gaze_vpl VALUES ("JG7_23","008_7_23","JDG","7","23","23","እስራኤሎንስ ንፍታሌም፣ ኣሼሪፊ ምናሴ ሁንዱማ ኬሳ ዋመኒ ምድያኖተ ኦፍ ዱረ አርአን። ");
INSERT INTO gaze_vpl VALUES ("JG7_24","008_7_24","JDG","7","24","24","ግዴዎንስ ጉቱማ ብየ ጋራ ኤፍሬምት ኤርገሞተ ኤርጌ፣ “ኮታ ምድያኖተት ዱላቲ ብሻኖተ ሀመ ቤት ባራት ጅረኒፊ ለገ ዮርዳኖስ እሳን ዱርሳቲ ቀበዻ” ጄዼ። ከናፉ ነሞትን ኤፍሬም ሁንድ በአኒ ብሻኖተ ሀመ ቤት ባራት ጅረኒፊ ለገ ዮርዳኖስ ቀበተን። ");
INSERT INTO gaze_vpl VALUES ("JG7_25","008_7_25","JDG","7","25","25","አከሱመስ ሆገንቶተ ምድያኖታ ለማን ጄቹንስ ሄሬቢፊ ዜኤብን ቀበተን። ሄሬብ ከታ ሄሬብ ብረት ዜኤብሞ እዶ ወይኒ እት ጩንፈን ከን ዜኤቢት አጄሰን። እሳንስ ምድያኖተ አርአኒ መታ ሄሬቢፊ መታ ዜኤብ ገረ ገመ ለገ ዮርዳኖስ ግዴዎንት ፍደን። ");
INSERT INTO gaze_vpl VALUES ("JG8_1","008_8_1","JDG","8","1","1","ነሞትን ኤፍሬም፣ “አት ማሊፍ አከነ ኑ ጎቴ? ዬሮ ምድያንን ዸኡፍ ዱልቴት ማሊፍ ኑ ህንዋምን?” ጄዸኒ ግዴዎን ጋፈተን። አከ መሌስ እሰት ዼከመን። ");
INSERT INTO gaze_vpl VALUES ("JG8_2","008_8_2","JDG","8","2","2","እንሞ አከነ ጄዼ ዴብሴፍ፤ “ወን አን ሆጄዼ ዮ ዋን እስን ሆጄተኒን ወል ብረ ቀበሜ ገቲ ማሊ ቀበ? ቀርሚን ወይኒ ኤፍሬም ኦምሸ ወይኒ አቢኤዜር ሰነ ሁንደ ህንጫሉ? ");
INSERT INTO gaze_vpl VALUES ("JG8_3","008_8_3","JDG","8","3","3","ዋቅን ሆገንቶተ ምድያኖታ ጄቹንስ ሄሬቢፊ ዜኤብን ደበርሴ ሀርከኬሰንት ኬኔረ። ኤጋ አን ዋን እስን ሆጄተኒን ወጅን ከን ወል ቅጣቱ ማል ሆጄቹን ደንደአ ቱሬ?” ዮሙ እን ዋን ከነ ጄዼትስ ኣሪን እሳን እሰት ኣረን ንቀበናኤ። ");
INSERT INTO gaze_vpl VALUES ("JG8_4","008_8_4","JDG","8","4","4","ግዴዎኒፊ ነሞትን እሰ ወጅን ቱረን ዽብ ሰደን ዹፈኒ ዮርዳኖስ ጬአን፤ እሳን አከ መሌ ደዸበንዩ እቱመ ፉፈኒ ጀረ አርአን። ");
INSERT INTO gaze_vpl VALUES ("JG8_5","008_8_5","JDG","8","5","5","እንስ ነሞተ ሱኮቲቲን፣ “ሎልቶተኮቲፍ ቡዴነ ኬና፤ እሳን ባይኤ ነ ዱራ ደዸበኒሩቲ፤ አን አመዩ ሞቶተ ምድያኖታ ጄቹንስ ዜባፊ ዘልሙና አርኣ ጅረ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG8_6","008_8_6","JDG","8","6","6","ቆንዳልቶትን ሱኮት ገሩ፣ “ሎልቶተኬቲፍ ኑ ቡዴነ ከን ኬንኑ አት ዜባፊ ዘልሙና ሀርከኬት ገልፈቴርታ?” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("JG8_7","008_8_7","JDG","8","7","7","ግዴዎንስ ዴብሴ፣ “ቶሌ ካ፣ ዮሙ ዋቀዮ ደበርሴ ዜባፊ ዘልሙና ሀርከኮት ኬኑት አን ቆራቲ ገሞጂቲፊ አረንገማዻን ፎንኬሰን ጭጭረ” ጄዼን። ");
INSERT INTO gaze_vpl VALUES ("JG8_8","008_8_8","JDG","8","8","8","አቺስ ገረ ነሞተ ጴኑኤል ዸቄ አኩመ ወረ ዱራ ሰነ ከዸቴት እሳንስ ጋፈቴ፤ እሳን ገሩ አኩመ ወር ሱኮት ዴብሰንት ዴቢ ኬነን። ");
INSERT INTO gaze_vpl VALUES ("JG8_9","008_8_9","JDG","8","9","9","ከናፉ እን ነሞተ ጴኑኤሊን፣ “አን ዬሮ ሞአዼ ዴብኡት ገሞ ከነ ነንጅግሰ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG8_10","008_8_10","JDG","8","10","10","ዬሮ ሰነት ዜባፊ ዘልሙናን ሎልቶተሳኒ ከኔን ኩመ ኩዸ ሸንት ሄደመን ወጅን እዶ ቀርቀር ጄዸሙ ቱረን፤ እሳን ኩኔንስ ሎልቶተ ነሞተ በአ ቢፍቱቲ ወልት ቀበመን ኬሳ ሀፈን ሁንዳዸ፤ ወር ጎራዴ ህዸተን ኩምን ኩዸ ለመ ዹመኒ ቱረኒቲ። ");
INSERT INTO gaze_vpl VALUES ("JG8_11","008_8_11","JDG","8","11","11","ግዴዎንስ ከራ ወረ በአ ኖባሂቲፊ ዮግብሃቲን ዱንካነ ኬሰ ጅራተኒ በኤ ሎልቶተ ሆማ ህንብርአትን ዸኤ፤ ራያን ወራና ሱን ኦፍ ደገቴ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("JG8_12","008_8_12","JDG","8","12","12","ሞቶትን ምድያን ለማን ጄቹንስ ዜባፊ ዘልሙናን ንበቀተን፤ ግዴዎን ገሩ አርኤ እሳን ቀበቴ፤ ሎልቶተሳኒስ ገርገር ብትኔሴ። ");
INSERT INTO gaze_vpl VALUES ("JG8_13","008_8_13","JDG","8","13","13","ኤርገሲ ግዴዎን እልም ዮኣሽ ከራ መልካ ሄሬስ በኤ ዱላ ገሌ። ");
INSERT INTO gaze_vpl VALUES ("JG8_14","008_8_14","JDG","8","14","14","እንስ ደርገጌሰ ሱኮት ቶኮ ቀቤ ቆረቴ፤ ደርገጌስ ሱንስ መቃ ቆንዳልቶተ ሱኮቲፊ ማንጉዶተ መጋለቲ ወሉመት መቃ ነመ ቶርባተሚ ቶርበ በሬሴ ኬኔፍ። ");
INSERT INTO gaze_vpl VALUES ("JG8_15","008_8_15","JDG","8","15","15","ግዴዎንስ ዹፌ ነሞተ ሱኮቲን፣ “ዜባፊ ዘልሙናን እስን፣ ‘ኑ ነሞተኬ ወረ ደዸበኒፍ ቡዴነ ከን ኬንኑ አት ዛብሄሊፊ ዘልሙና ሀርከኬት ገልፈቴርታ?’ ጄተኒ ዋኤሳኒ ነት ቆስተን ሱን ኩኖት” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG8_16","008_8_16","JDG","8","16","16","እንስ ማንጉዶተ መጋላ ሰና ፉዼ ቆራቲፊ አረንገማ ገሞጂቲን አደቡዻን ነሞተ ሱኮቲቲፍ በሩምሰ ኬኔ። ");
INSERT INTO gaze_vpl VALUES ("JG8_17","008_8_17","JDG","8","17","17","ገሞ ጴኑኤልስ ጅግሴ ነሞተ መጋለቲ ፍጤ። ");
INSERT INTO gaze_vpl VALUES ("JG8_18","008_8_18","JDG","8","18","18","ኤርገሲስ እን፣ “ነሞትን እስን ታቦርት ፍጠን ወረ አከሚቲ?” ጄዼ ዜባፊ ዘልሙና ጋፈቴ። እሳንስ፣ “ነሞቱመ አከኬሰኒ ከኔን ሁንድሳኒ እልማን ሞቲ ፈፈካተኒዸ” ጄዸኒን። ");
INSERT INTO gaze_vpl VALUES ("JG8_19","008_8_19","JDG","8","19","19","ግዴዎንስ ዴብሴ፣ “እሳን ኦቦሎተኮ እልማኑመ ሃዸኮቲ ቱረን። ዹጋ ዋቀዮ ጅራታ፣ ኡቱ እስን እሳን አጄሱ ባተኒ አን እስን ህንአጄሱ ቱሬ” ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG8_20","008_8_20","JDG","8","20","20","እንስ ገረ ዬቴር እልመሳ ሀንገፍትቻት ገረገሌ፣ “ከኢቲ እሳን ፍጥ!” ጄዼን። ዬቴር ገሩ ሰበቢ እጆሌ ተኤፍ ሶዳቴ ጎራዴሳ ህንሉቅፈትኔ። ");
INSERT INTO gaze_vpl VALUES ("JG8_21","008_8_21","JDG","8","21","21","ኤርገሲስ ዜባፊ ዘልሙናን፣ “ከኢቲ አቱምት ኑ አጄስ፤ ‘ጀብን ነማ አኩመ ዸግነሳቲ’ ” ጄዸኒን። ግዴዎንስ ከኤ እሳን አጄሴ፤ ፋየ ሞርመ ጋለወንሳኒስ ፉዸቴ። ");
INSERT INTO gaze_vpl VALUES ("JG8_22","008_8_22","JDG","8","22","22","ነሞትን እስራኤልስ ግዴዎኒን፣ “አት ዋን ሀርከ ምድያኖታ ጀላ ኑ ባፍቴፍ አት፣ እልምኬቲፊ እልም እልመኬቲ ኑ ቡልቻ” ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JG8_23","008_8_23","JDG","8","23","23","ግዴዎን ገሩ፣ “አን እስን ህንቡልቹ፤ እልምኮስ እስን ህንቡልቹ። ዋቀዮቱ እስን ቡልቸ” እሳኒን ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG8_24","008_8_24","JDG","8","24","24","እንስ፣ “አን ዋ ቶኮ እስን ከዸዸ፤ ኩንስ አከ ቶኮን ቶኮንኬሰን ቆደ ቦጁኬሰኒራ ሎቲ ና ኬንተኒዸ” ጄዼ። ሎቲ ወርቄ ካአቹን በርቴ እሽማኤሎታ ቱሬቲ። ");
INSERT INTO gaze_vpl VALUES ("JG8_25","008_8_25","JDG","8","25","25","እሳንስ፣ “ኑ ገመቹዻን ኬንነ” ጄዸኒ ዴብሰን። ከናፉ ወያ ለፈረ ድሪርሰኒ ቶኮን ቶኮን ነማ ቦጁሳራ ሎቲ እት ደርበቴ። ");
INSERT INTO gaze_vpl VALUES ("JG8_26","008_8_26","JDG","8","26","26","አመርቲን ወርቄ ከን እን ከዸቴ ሰቅሊ ኩመ ቶኮፊ ዽበ ቶርበ ዮካን ኪሎ ግራሚ ኩዸ ሰገሊፊ ወለካ ኡልፋተ ቱሬ፤ ኩንስ ዋን ሞርመት ህዸተን፣ ኡፈተ ዲማ ዺልጌ ከን ሞቶትን ምድያን ኡፈተኒፊ ፎንጫ ሞርመ ጋለወንሳኒረ ቱሬ ህንደበለቱ። ");
INSERT INTO gaze_vpl VALUES ("JG8_27","008_8_27","JDG","8","27","27","ግዴዎንስ ወርቄ ሰናን ድረተ ቶልቼ መጋላ እት ዸለቴ ኦፍራ ኬሰ ካኤ። እስራኤሎን ሁንድስ አችት ኤፉድቸ ዋቄፈቹዻን ሰጋገለን። ኩንስ ግዴዎኒፍ ማቲሳት ክዮ ተኤ። ");
INSERT INTO gaze_vpl VALUES ("JG8_28","008_8_28","JDG","8","28","28","ምድያኖትንስ አከሲን ፉለ እስራኤሎታ ዱረት ሞአተመን፤ ለመተስ መታሳኒ ኦል ህንቀበትኔ። ብየቲንስ በረ ግዴዎን ኬሰ ወጋ አፉርተመ ነጋ አርገቴ። ");
INSERT INTO gaze_vpl VALUES ("JG8_29","008_8_29","JDG","8","29","29","ዬሩብ-በኣል እልም ዮኣሽ አች ጅራቹፍ ገረ መነ ኦፊሳት ዴብኤ። ");
INSERT INTO gaze_vpl VALUES ("JG8_30","008_8_30","JDG","8","30","30","እን ሰበቢ ኒቶተ ባይኤ ፉዼፍ እልማን ቶርባተመ ቀበ ቱሬ። ");
INSERT INTO gaze_vpl VALUES ("JG8_31","008_8_31","JDG","8","31","31","ሳጀቶንሳ ከን ሼኬም ኬሰ ጅራቻ ቱርቴስ እልመ ዴሴፊ ቱርቴ፤ እንስ አቢሜሌክ ጄዼ እሰ ሞጋሴ። ");
INSERT INTO gaze_vpl VALUES ("JG8_32","008_8_32","JDG","8","32","32","ግዴዎን እልም ዮኣሽ በረ ዼራ ጅራቴ ዱኤ። እንስ ኦፍራ ብየ አቢኤዜሮታ ኬሰት፣ ለፈ አዋለ አባሳ ዮኣሽት አዋለሜ። ");
INSERT INTO gaze_vpl VALUES ("JG8_33","008_8_33","JDG","8","33","33","አኩመ ግዴዎን ዱኤን እስራኤሎን አመሌ በኣል ወጅን ሰጋገለን። በኣል ቤሪንስ ዋቀሳኒ ጎዸተኒ ");
INSERT INTO gaze_vpl VALUES ("JG8_34","008_8_34","JDG","8","34","34","ዋቀዮ ዋቀሳኒ ከን ሀርከ ዲኖተሳኒ ሁንዱማ ጀላ እሳን ባሴ ሰነ ደገተን። ");
INSERT INTO gaze_vpl VALUES ("JG8_35","008_8_35","JDG","8","35","35","እሳንስ ማቲ ዬሩብ-በኣሊፍ ጄቹንስ ግዴዎኒፍ ዋን ጋሪ እን እሳኒፍ ጎዼ ሁንደ ያደተኒ አርጁማ ህንጎኔፍ። ");
INSERT INTO gaze_vpl VALUES ("JG9_1","008_9_1","JDG","9","1","1","አቢሜሌክ እልም ዬሩብ-በኣል ገረ ኦቦሎተ ሃዸሳ ከኔን ሼኬም ኬሰ ጅራተኒ ዸቄ እሳኒፊ ጎሰ ሃዸሳ ሁንዳን አከነ ጄዼ፤ ");
INSERT INTO gaze_vpl VALUES ("JG9_2","008_9_2","JDG","9","2","2","“ጅራቶተ ሼኬም ሁንዱማን፣ ‘ከም እስኒ ወየ? ዮ እልማን ዬሩብ-በኣል ቶርባተምን እስን ቡልቸንሞ ዮ ነምን ቶኮ እስን ቡልቼ ወየ?’ ጄዻ ጋፈዻ። አከ አን ፎኒፊ ዺገኬሰን ተኤሞ ያደዻ።” ");
INSERT INTO gaze_vpl VALUES ("JG9_3","008_9_3","JDG","9","3","3","ኦቦሎትን ሃዸሳስ ዱቢ ከነ ጉረ ሼኬሞታቲን ገአን፤ ገራንሳኒስ ገረ አቢሜሌክ ጎሩ ከጄሌ፤ እሳን፣ “እን ኦቦሌሰኬኘ” ጄዸኒሩቲ። ");
INSERT INTO gaze_vpl VALUES ("JG9_4","008_9_4","JDG","9","4","4","እሳንስ መነ ሰገዳ በኣል ቤሪት ኬሳ ሜቲ ገረ ግራሚ ዽበ ሰዴት ኡልፋቱ ኬነኒፍ፤ አቢሜሌክስ ሜቲ ሰናን ከሽለቦተ እሰ ፋነ ቡአን ቀጠረቴ። ");
INSERT INTO gaze_vpl VALUES ("JG9_5","008_9_5","JDG","9","5","5","ገረ መነ አባሳ ከን ኦፍራት አርገሙ ዸቄ ኦቦሎተሳ እልማን ዬሩብ-በኣል ቶርባተመ ዸጋ ቶኮረት ቀሌ። ዮታም እልም ይሩበኣል ቁጥሱን ገሩ ዾከቴ እሰ ጀላ ምልቄ። ");
INSERT INTO gaze_vpl VALUES ("JG9_6","008_9_6","JDG","9","6","6","ነሞትን ሼኬሚፊ ቤት ሚሎ ሁንድ አቢሜሌክን ሞስሱፍ ጄዸኒ ሼኬምት ኡቱባ ሙካ ጉዳ ቶኮ ብረት ወልት ቀበመን። ");
INSERT INTO gaze_vpl VALUES ("JG9_7","008_9_7","JDG","9","7","7","ዮታም ዮሙ ወን ኩን እት ህመሜት ፊጤ ጋረ ጌርዚምት ኦል በኤ ሰገሌ ጉዳዻን አከነ እሳኒን ጄዼ፤ “ያ ጅራቶተ ሼኬም፣ አከ ዋቅን እስን ዸገኡፍ ነ ዸጌፈዻ። ");
INSERT INTO gaze_vpl VALUES ("JG9_8","008_9_8","JDG","9","8","8","ጋፍ ቶኮ ሙኬን ሞቲ ሞስፈቹፍ በአን፤ እሳንስ ሙከ ኤጄርሳቲን፣ ‘ሞቲ ኑ ተእ’ ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JG9_9","008_9_9","JDG","9","9","9","“ሙክን ኤጄርሳ ገሩ፣ ‘አን ሙኬን ሁንዳ ኦልት ራፈሙዻፍ ጄዼ ዘይቲኮ ከን ዋቅኒፊ ነምን እቲን ከበጀመን ዾወዹሬ?’ ጄዼ ዴብሴ። ");
INSERT INTO gaze_vpl VALUES ("JG9_10","008_9_10","JDG","9","10","10","“እት ኣንሰኒስ ሙኬን ሙከ ሀርቡቲን፣ ‘ኮቱቲ ሞቲ ኑ ተእ’ ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JG9_11","008_9_11","JDG","9","11","11","“ሙክን ሀርቡ ገሩ ዴብሴ፣ ‘አን ሙኬን ሁንዳ ኦልት በኤ ራፈሙፍ ጄዼ እጀኮ ምኣዋፊ ጋሪ ሰነ ኬኑ ዺሱሬ?’ ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG9_12","008_9_12","JDG","9","12","12","“ሙኬንስ ሙከ ወይኒቲን፣ ‘ኮቱቲ ሞቲ ኑ ተእ’ ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JG9_13","008_9_13","JDG","9","13","13","“ሙክን ወይኒ ገሩ ዴብሴ፣ ‘አን ሙኬን ሁንዳ ኦልት በኤ ራፈሙፍ ጄዼ ዳዺ ወይኒኮቲ ከን ዋቃፊ ነመ ገመቺሱ ሰነ ኬኑ ዺሱ?’ ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG9_14","008_9_14","JDG","9","14","14","“ዹመረትስ ሙኬን ሁንድ ሙከ ቆራቲቲን፣ ‘ኮቱቲ ሞቲ ኑ ተእ’ ጄዸን። ");
INSERT INTO gaze_vpl VALUES ("JG9_15","008_9_15","JDG","9","15","15","“ሙክን ቆራቲስ ሙኬኒን፣ ‘እስን ዮ ዹጉማን ነ ሞስፈቹ ፌተን፣ ኮታቲ ጋድሰኮ ጀለት ደኤፈዻ፤ ዮ አከስ ተኡ ባቴ ገሩ እብድ ሙከ ቆራቲ ኬሳ በኤ ብርብርሰ ልባኖን ሃበርበዴሱ!’ ጄዼ። ");
INSERT INTO gaze_vpl VALUES ("JG9_16","008_9_16","JDG","9","16","16","“ኤጋ እስን አቢሜሌክን ሞስሱንኬሰን ዮ ከራ ዹጋቲፊ አመነሙማን ተኤ፣ ዮ ዬሩብ-በኣሊፊ ማቲሳቲፍ ዋን ጋሪ ጎቹፍ ተኤ፣ ዮ ዋን እሳፍ መሉ እሳፍ ጎቹፍ ተኤ፣ ");
INSERT INTO gaze_vpl VALUES ("JG9_17","008_9_17","JDG","9","17","17","አባንኮ ሉቡሳ ዱኣፍ ሳጥሌ ሀርከ ምድያኖታ ጀላ እስን ባሱፍ እስኒ ሎሌራቲ፤ ");
INSERT INTO gaze_vpl VALUES ("JG9_18","008_9_18","JDG","9","18","18","እስን ገሩ ሀርአ ማቲ አባኮት ካተኒ እልማንሳ ጄቹንስ ነመ ቶርባተመ ዸጋ ቶኮረት ቀልተን፤ ሰበቢ እን ፍረኬሰን ተኤፍ አቢሜሌክ እልመ ገርብቲ ሰነ ነሞተ ሼኬምረት ሞስፍተን፤ ");
INSERT INTO gaze_vpl VALUES ("JG9_19","008_9_19","JDG","9","19","19","ኤጋ ዮ እስን ሀርአ ዹጋፊ አመነሙማዻን ዬሩብ-በኣሊፊ ማቲሳቲፍ ዋን ጋሪ ጎተን፣ እስን አቢሜሌክት ገመዳ፤ እንስ እስንት ሃገመዱ! ");
INSERT INTO gaze_vpl VALUES ("JG9_20","008_9_20","JDG","9","20","20","አከስ ተኡ ባናን ገሩ እብድ መነ አቢሜሌኪ በኤ ነሞተ ሼኬሚፊ ቤት ሚሎ ሃፍጡ፤ አከሱመስ እብድ ነሞተ ሼኬሚፊ ቤት ሚሎ ብራ በኤ አቢሜሌክን ሃበሌሱ!” ");
INSERT INTO gaze_vpl VALUES ("JG9_21","008_9_21","JDG","9","21","21","ዮታምስ ብኤርት በቀቴ ሰበቢ ኦቦሌሰሳ አቢሜሌክን ሶዳቴፍ አቹመ ጅራቴ። ");
INSERT INTO gaze_vpl VALUES ("JG9_22","008_9_22","JDG","9","22","22","ኤርገ አቢሜሌክ ወጋ ሰዲ እስራኤል ቡልቼ ቦዴ፣ ");
INSERT INTO gaze_vpl VALUES ("JG9_23","008_9_23","JDG","9","23","23","ዋቅንስ አቢሜሌኪፊ ነሞተ ሼኬም ግዱት ሀፉረ ሀማ ኤርጌ፤ ሼኬሞንስ አቢሜሌክት ደበ ሆጄተን። ");
INSERT INTO gaze_vpl VALUES ("JG9_24","008_9_24","JDG","9","24","24","ዋቅንስ የከ እልማን ዬሩብ-በኣል ቶርባተመን ሰነት ሆጄተሜፊ ዺገሳኒ ከን ዸንገላፈሜ ሰናፍ፣ አቢሜ