﻿USE sofia;
DROP TABLE IF EXISTS sofia.gaz_vpl;
CREATE TABLE gaz_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gaz_vpl WRITE;
INSERT INTO gaz_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Jalqabatti Waaqni samiiwwanii fi lafa uume. ");
INSERT INTO gaz_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Lafti kan bifa hin qabnee fi duwwaa turte; dukkannis tuujuba irra ture; Hafuurri Waaqaas bishaan irra sosochoʼa ture. ");
INSERT INTO gaz_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Waaqnis, “Ifni haa taʼu” jedhe; ifnis ni taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Waaqnis akka ifni sun gaarii taʼe arge; ifaa fi dukkanas gargar baase. ");
INSERT INTO gaz_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Waaqnis ifa sanaan “Guyyaa” jedhe; dukkana sanaan immoo “Halkan” jedhee moggaase. Galgalas taʼe; ganamas taʼe; guyyaa tokkoffaa. ");
INSERT INTO gaz_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Waaqnis, “Bishaanii fi bishaan gargar baasuuf bantiin bishaanota gidduu haa jiraatu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Kanaafuu Waaqni bantii tolchee bishaan bantii jalaatii fi kan bantiin olii gargar baase. Akkasumas taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Waaqnis bantii sana “samii” jedhee moggaase. Galgalas taʼe; ganamas taʼe; guyyaa lammaffaa. ");
INSERT INTO gaz_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Waaqnis, “Bishaan samiidhaa gad jiru iddoo tokkotti walitti haa qabamu; lafti gogaanis haa mulʼatu” jedhe. Akkasumas taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Waaqni lafa gogaa sanaan “lafa” jedhe; bishaanicha walitti qabameen immoo “galaana” jedhee moggaase. Waaqnis wanni kun akka gaarii taʼe arge. ");
INSERT INTO gaz_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Ammas Waaqni, “Lafti biqiltuuwwan haa baastu; biqiltuuwwan akkuma gosa gosa isaaniitti sanyii baasan, mukkeen ija kennanii iji isaanii immoo sanyii of keessaa qabu adduma addaan akkuma gosa gosa isaaniitti lafa irratti haa argaman” jedhe. Akkasumas taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Laftis biqiltuu akkuma gosa isaatti sanyii baasu, muka ija kennu, kan iji isaas sanyii of keessaa qabu adduma addaan akkuma gosa isaatti baaste. Waaqnis wanni kun akka gaarii taʼe arge. ");
INSERT INTO gaz_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Galgalas taʼe; ganamas taʼe; guyyaa sadaffaa. ");
INSERT INTO gaz_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Waaqnis akkana jedhe; “Guyyaa fi halkan gargar baasuuf bantii samii irratti ifawwan haa taʼan; isaanis mallattoowwan waqtiileen, guyyoonnii fi waggoonni ittiin beekaman haa taʼan; ");
INSERT INTO gaz_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","isaanis ifawwan bantii samii irraa kan lafaaf ifa kennan haa taʼan.” Akkasumas taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Waaqni ifa gurguddaa lama uume; kunis akka ifni guddaan guyyaa, inni xinnaan immoo halkan moʼuuf. Akkasuma urjiiwwan illee uume. ");
INSERT INTO gaz_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Waaqnis akka isaan lafaaf ifa kennaniif bantii samii irra isaan kaaʼe; ");
INSERT INTO gaz_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","kunis akka isaan guyyaa fi halkan moʼanii fi akka ifa sana dukkana irraa gargar baasaniif. Waaqnis wanni kun akka gaarii taʼe arge. ");
INSERT INTO gaz_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Galgalas taʼe; ganamas taʼe; guyyaa afuraffaa. ");
INSERT INTO gaz_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Waaqnis, “Bishaan uumamawwan lubbu qabeeyyii munyuuqaniin haa guutamu; simbirroonnis lafaa olitti, bantii samii keessa haa barrisan” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Kanaafuu Waaqni uumamawwan galaanaa gurguddaa, lubbu qabeeyyii munyuuqan kanneen galaana keessa jiraatan hundaa fi simbirroota qoochoo qaban hunda akkuma gosa isaaniitti uume. Waaqnis wanni kun akka gaarii taʼe arge. ");
INSERT INTO gaz_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Waaqnis, “Horaa; baayʼadhaa; bishaan galaanotaas guutaa; simbirroonnis lafa irratti haa baayʼatan” jedhee isaan eebbise. ");
INSERT INTO gaz_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Galgalas taʼe; ganamas taʼe; guyyaa shanaffaa. ");
INSERT INTO gaz_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Waaqnis, “Lafti akkuma gosa gosa isaaniitti uumamawwan lubbuu qabeeyyii jechuunis horii, uumamawwan lafa irra mumunyuuqan, bineensota akkuma gosa gosa isaaniitti haa kennitu” jedhe. Akkasumas taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Waaqni bineensota akkuma gosa gosa isaaniitti, horii akkuma gosa gosa isaaniitti, uumamawwan lafa irra mumunyuuqanis akkuma gosa gosa isaaniitti uume. Waaqni wanni kun akka gaarii taʼe arge. ");
INSERT INTO gaz_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Waaqnis, “Kottaa akka bifa keenyaatti, akka fakkeenya keenyaattis nama uumnaa; isaanis qurxummii galaanaa irratti, simbirroo samii irratti, horii irratti, lafa hundumaa fi uumamawwan lafa irra munyuuqan hundumaa irratti aangoo haa qabaatan” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Kanaafuu Waaqni akka bifa isaatti nama uume; akka bifa Waaqaatti isa uume; innis dhiiraa fi dubartii taasisee isaan uume. ");
INSERT INTO gaz_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Waaqnis isaan eebbisee, “Horaa, baayʼadhaas; lafa guutaatii harka keessan jalattis bulfadhaa. Qurxummii galaanaa irratti, simbirroota samii irratti, uumama lafa irra munyuuqu hunda irratti aangoo qabaadhaa” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Ergasii Waaqni akkana jedhe; “Kunoo ani akka isaan nyaata isinii taʼaniif biqiltuu lafa hunda irratti sanyii kennu hundaa fi muka iji isaa sanyii of keessaa qabu gosa hunda isinii kenneera. ");
INSERT INTO gaz_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Anis bineensa lafaa hundaaf, simbirroota samii hundaaf, uumama lafa irra munyuuqu hundaaf jechuunis waan hafuura jireenyaa of keessaa qabu hundaaf akka nyaata isaanii taʼuuf biqiltuu lalisaa hunda nan kenna.” Akkasumas taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Waaqnis waan hojjete hunda ilaale; wanni sunis dhugumaan gaarii ture. Galgalas taʼe; ganamas taʼe; guyyaa jaʼaffaa. ");
INSERT INTO gaz_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Uumamni samiitii fi lafaa, kan waan isaan keessa jiru hundaas haala kanaan xumurame. ");
INSERT INTO gaz_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Waaqni hojii hojjechaa ture hunda guyyaa torbaffaatti fixe; kanaafuu inni guyyaa torbaffaatti hojii isaa hundumaa irraa boqote. ");
INSERT INTO gaz_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Waaqni sababii gaafa sana hojii waa uumuu kan hojjechaa ture hunda irraa boqoteef guyyaa torbaffaa eebbisee qulqulleesse. ");
INSERT INTO gaz_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Seenaan samiiwwaniitii fi lafaa kan yeroo isaan uumamanii, yeroo Waaqayyo Waaqni lafaa fi samiiwwan uumee kanaa dha. ");
INSERT INTO gaz_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","Sababii Waaqayyo Waaqni bokkaa hin roobsiniif, namni lafa qotus waan hin jiraatiniif margi tokko iyyuu lafa irratti hin mulʼanne; biqiltuunis lafa qotiisaa irratti hin biqille ture. ");
INSERT INTO gaz_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Garuu bishaan lafa keessaa burqee lafa hunda obaasa ture. ");
INSERT INTO gaz_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Waaqayyo Waaqni biyyoo lafaa irraa nama tolche; hafuura jireenyaas funyaan isaatti baafate; namnis uumama jiraataa taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Waaqayyo Waaqnis Eeden keessatti gama baʼa biiftuutti iddoo biqiltuu qopheesse; nama tolche sanas achi keessa kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Waaqayyo Waaqni mukkeen gosa hundaa lafa keessaa biqilche; inni mukkeen ija namaatti tolanii fi nyaataafis gaarii taʼan biqilche. Iddoo biqiltuu sana keessas muka jireenyaatii fi muka waan gaarii fi waan hamaa nama beeksisutu ture. ");
INSERT INTO gaz_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Lagni iddoo biqiltuu sana obaasu tokkos Eeden keessaa burqa ture; lagni sun Eedenii kaʼee gargar baʼee laga afur taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Maqaan laga tokkoffaa Phiishoon; innis guutummaa biyya Hawiilaa, iddoo warqeen jirutti naannaʼee yaaʼa. ");
INSERT INTO gaz_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Warqeen biyya sanaa gaarii dha; hapheen urgaaʼuu fi sardooniksiin achitti argamu. ");
INSERT INTO gaz_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Maqaan isa lammaffaa Giihooni; innis guutummaa lafa Itoophiyaatti naannaʼee yaaʼa. ");
INSERT INTO gaz_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Maqaan laga sadaffaa Xegroosi; innis karaa baʼa biiftuutiin Asoor cina yaaʼa. Lagni afuraffaan immoo Efraaxiis jedhama. ");
INSERT INTO gaz_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Waaqayyo Waaqni akka inni isa misoomsuu fi akka inni isa eeguuf jedhee nama fuudhee Iddoo Biqiltuu Eeden keessa kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Waaqayyo Waaqnis akkana jedhee nama ajaje; “Muka iddoo biqiltuu kana keessa jiru hunda irraa nyaachuu ni dandeessa; ");
INSERT INTO gaz_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","garuu muka waan gaarii fi waan hamaa nama beeksisu sana irraa hin nyaatin; gaafa isa irraa nyaatte dhugumaan ni duutaatii.” ");
INSERT INTO gaz_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Waaqayyo Waaqni, “Namni kophaa isaa taʼuun gaarii miti; gargaartuu isatti toltu nan tolchaaf” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Waaqayyo Waaqnis bineensaa fi simbirroota samii hundumaa lafa irraa tolche. Maqaa inni isaaniif baasu ilaaluuf jedhees gara namichaatti isaan fide; wanni namichi sun tokkoo tokkoo uumamawwan lubbu qabeeyyii ittiin waame kam iyyuu maqaa taʼeef. ");
INSERT INTO gaz_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Namichi sunis horii qeʼee hundaaf, simbirroota samii hundaaf, bineensa hundaaf maqaa baase. Addaamiif garuu gargaartuun isatti toltu hin argamne. ");
INSERT INTO gaz_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Kanaafis Waaqayyo Waaqni akka namichi hirribaan of wallaalu godhe; utuma inni rafaa jiruu lafee cinaacha isaa keessaa tokko fuudhee iddoo sana fooniin duuche. ");
INSERT INTO gaz_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Waaqayyo Waaqni lafee cinaachaa kan namicha keessaa fuudhe sana irraa dubartii tolchee gara namichaatti geesse. ");
INSERT INTO gaz_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Namichis akkana jedhe; “Egaa lafeen kun lafee lafee kootii ti; foon kunis foon foon kootii ti; isheen waan dhiira irraa argamteef ‘dubartii’ jedhamti.” ");
INSERT INTO gaz_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Kanaafuu namni abbaa fi haadha isaa ni dhiisa; niitii isaatti ni maxxana; isaanis foon tokko taʼu. ");
INSERT INTO gaz_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Namichii fi niitiin isaa qullaa isaanii turan; garuu wal hin qaanaʼan ture. ");
INSERT INTO gaz_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bineensa Waaqayyo Waaqni uume hunda keessaa bofti haxxee ture. Dubartittiidhaanis, “Dhuguma Waaqni, ‘Muka iddoo biqiltuu keessa jiru kam irraa iyyuu hin nyaatinaa’ isiniin jedheeraa?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Dubartittiinis deebiftee bofa sanaan akkana jette; “Ija mukkeen iddoo biqiltuu keessa jiranii nyaachuu ni dandeenya; ");
INSERT INTO gaz_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","garuu Waaqni, ‘Muka walakkaa iddoo biqiltuu sanaa keessa jiru irraa ija hin nyaatinaa; ittis hin buʼinaa; yoo kanaa achii ni duutuu’ jedheera.” ");
INSERT INTO gaz_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bofichis deebisee dubartittiidhaan akkana jedhe; “Isin dhugumaan hin duutan. ");
INSERT INTO gaz_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Waaqni akka yommuu isin ija mukichaa nyaattan iji keessan banamu, akka isin waan gaarii fi waan hamaa beekuudhaan akka Waaqaa taatan ni beekaatii.” ");
INSERT INTO gaz_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Dubartittiinis yommuu akka iji mukichaa nyaataaf gaarii, kan ija namaatti tolu, ogummaa argachuufis akka nama gojomaasisu argitetti fudhattee nyaatte. Dhirsi ishees ishee wajjin ture; isaafis ni laatte; innis ni nyaate. ");
INSERT INTO gaz_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Iji lachan isaaniis ni baname; qullaa hafuu isaaniis beekan; kanaafis baala harbuu hodhanii marxoo tolfatan. ");
INSERT INTO gaz_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Akkuma aduun qabbanoofteenis namichii fi niitiin isaa utuu Waaqayyo Waaqni iddoo biqiltuu sana keessa deemuu sagalee isaa dhagaʼan; isaanis mukkeen iddoo biqiltuu keessa Waaqayyo Waaqa duraa dhokatan. ");
INSERT INTO gaz_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Waaqayyo Waaqni garuu namicha waamee, “Ati eessa jirta?” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Namichis deebisee, “Ani utuu ati iddoo biqiltuu keessa deemtuu nan dhagaʼe; waan qullaa koo tureefis nan sodaadhe; nan dhokadhes” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Innis, “Eenyutu akka ati qullaa taate sitti hime? Muka ani ija isaa hin nyaatin jedhee si ajaje sana irraa nyaatte moo?” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Namichis, “Dubartittii ati akka isheen na wajjin jiraattuuf naa kennite sanatu ija mukichaa irraa naa kenne; anis nan nyaadhe” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Waaqayyo Waaqnis dubartittiidhaan, “Wanni ati hojjette kun maali?” jedhe. Dubartittiin immoo, “Bofti na gowwoomsinaanan nyaadhe” jette. ");
INSERT INTO gaz_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Kanaafuu Waaqayyo Waaqni bofichaan akkana jedhe; “Ati sababii waan kana gooteef, “Horii hundumaa keessaa, bineensa hundumaa keessaas kan abaaramte ni taata! Bara jireenya keetii guutuu garaa keetiin lafa irra loota; biyyoo illee ni nyaatta. ");
INSERT INTO gaz_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Siʼii fi dubartittii, sanyii keetii fi sanyii ishee gidduutti diinummaa nan uuma; inni mataa kee ni tuma; atis koomee isaa ni iddita.” ");
INSERT INTO gaz_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Dubartittiidhaanis akkana jedhe; “Yommuu ati mucaa deessutti ani dhiphina kee akka malee nan baayʼisa; ciniinsuudhaanis ijoollee ni deessa. Fedhiin kee garuma dhirsa keetii taʼa; innis sirratti ol aantummaa qabaata.” ");
INSERT INTO gaz_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Addaamiin immoo akkana jedhe; “Waan ati dubbii niitii keetii dhageessee muka ani ija isaa irraa, ‘hin nyaatin’ jedhe irraa nyaatteef, “Lafti sababii keetiif kan abaaramte taati; atis bara jireenya keetii guutuu dadhabbiidhaan ishee irraa nyaatta. ");
INSERT INTO gaz_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Isheen qoraattii fi sokorruu sitti biqilchiti; atis biqiltuu lafaa ni nyaatta. ");
INSERT INTO gaz_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ati waan lafa irraa argamteef, hamma lafatti deebitutti dafqa fuula keetiitiin buddeena nyaatta; waan biyyoo taateefis, gara biyyootti deebita.” ");
INSERT INTO gaz_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Addaamis sababii isheen haadha jiraatoo hundaa taateef niitii isaa “Hewaan” jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Waaqayyo Waaqni Addaamii fi Hewaaniif gogaa irraa uffata hojjetee isaanitti uffise. ");
INSERT INTO gaz_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Waaqayyo Waaqnis, “Kunoo namni waan gaarii fi waan hamaa beekuudhaan nu keessaa akka isa tokkoo taʼeera. Ammas harka isaa hiixatee, ija muka jireenyaa ciratee nyaachuun, bara baraanis jiraachuun isaaf eeyyamamuu hin qabu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Kanaafuu Waaqayyo Waaqni lafa biqiltuu Eeden keessaa namicha baasee akka inni lafuma irraa argame sana misoomsu godhe. ");
INSERT INTO gaz_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Erga nama achii baasee booddee karaa muka jireenyaatti geessu eegsisuuf jedhee kiirubeelotaa fi goraadee bobaʼu kan asii fi achi gaggaragalu tokko Iddoo Biqiltuu Eedeniitiin gama baʼa biiftuu kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Addaam niitii isaa Hewaan bira gaʼe; isheenis ulfooftee Qaayinin deesse. Isheenis, “Ani gargaarsa Waaqayyootiin ilma tokko argadheera” jette. ");
INSERT INTO gaz_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Itti aansitees obboleessa isaa Abeelin deesse. Abeel tiksee hoolotaa ture; Qaayin immoo lafa qota ture. ");
INSERT INTO gaz_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Yeroo muraasa keessatti Qaayin waan lafti baafteef keessaa Waaqayyoof aarsaa dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeel immoo hangafoota hoolota isaa keessaa cooma cooma isaa dhiʼeesse. Waaqayyo faara tolaadhaan gara Abeelii fi gara aarsaa inni dhiʼeesse sanaa ilaale. ");
INSERT INTO gaz_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Gara Qaayinii fi gara aarsaa isaa garuu hin ilaalle. Kanaafuu Qaayin akka malee aaree fuulli isaa gurraachaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Waaqayyos Qaayiniin akkana jedhe; “Ati maaliif aarte? Fuulli kees maaliif gurraachaʼe? ");
INSERT INTO gaz_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Utuu waan qajeelaa hojjettee silaa ati fudhatama argatta mitii? Garuu yoo waan qajeelaa hojjechuu baatte cubbuun balbala kee duratti riphee si eeggata; si qabachuu barbaadas; ati garuu isa moʼachuu qabda.” ");
INSERT INTO gaz_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Qaayinis ergasii obboleessa isaa Abeeliin, “Kottu mee dirreetti baanaa” jedhe. Utuma dirree irra jiranuus Qaayin obboleessa isaa Abeelitti kaʼee isa ajjeese. ");
INSERT INTO gaz_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Waaqayyos, “Obboleessi kee Abeel eessa jira?” jedhee Qaayin gaafate. Qaayin immoo, “Ani hin beeku; ani eegduu obboleessa kootiitii?” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Waaqayyo akkana jedhe; “Ati maal goote? Dhiigni obboleessa keetii lafaa natti iyyaa jira. ");
INSERT INTO gaz_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Ati amma abaaramaa dha; lafa dhiiga obboleessa keetii si harkaa fudhachuuf afaan banatte irraas ni ariʼamta. ");
INSERT INTO gaz_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Yeroo ati lafa qotattutti lafti deebitee midhaan siif hin kennitu. Ati lafa irratti joortuu boqonnaa hin qabne taata.” ");
INSERT INTO gaz_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Qaayin immoo Waaqayyoon akkana jedhe; “Adabamuun koo waan ani baachuu dandaʼuun ol. ");
INSERT INTO gaz_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kunoo ati harʼa biyyaa na ariʼaa jirta; anis fuula kee duraa nan dhokadha; lafa irratti joortuu boqonnaa hin qabne nan taʼa; namni na argatu kam iyyuus na ajjeesa.” ");
INSERT INTO gaz_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Waaqayyo garuu, “Akkana miti; namni Qaayinin ajjeesu kam iyyuu dachaa torba haaloo baafama” jedheen. Waaqayyos akka namni isa argatu tokko iyyuu isa hin ajjeefneef Qaayinitti mallattoo godhe. ");
INSERT INTO gaz_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Ergasiis Qaayin fuula Waaqayyoo duraa baʼee Eeden irraa karaa baʼa biiftuutiin biyya Noodi keessa jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qaayin niitii isaa beeke; isheenis ulfooftee Henookin deesse. Qaayinis magaalaa tokko hundeesse; magaalaa sanas Henook jedhee maqaa ilma isaatiin waame. ");
INSERT INTO gaz_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henook Iiraadin dhalche; Iiraadi Meʼeelin dhalche; Mehuuyaaʼeel Matusaaʼelin dhalche; Matusaaʼel immoo Laamehin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Laameh dubartoota maqaan isaanii Aadaa fi Xiilaa jedhamu lamaan fuudhe. ");
INSERT INTO gaz_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aadaan Yaabaalin deesse; Yaabaalis abbaa warra dunkaana keessa jiraatanii horii horsiisanii ture. ");
INSERT INTO gaz_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Maqaan obboleessa isaa Yuubaal ture; inni immoo abbaa warra kiraara rukutaniitii fi ulullee afuufanii ti. ");
INSERT INTO gaz_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Xiilaan immoo ilma Tuubaal Qaayin jedhamu kan naasii fi sibiila tumee meeshaawwan garaa garaa hojjetu deesse; obboleettiin Tuubaal Qaayinis Naʼamaa turte. ");
INSERT INTO gaz_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Laameh niitota isaatiin akkana jedhe; “Aadaa fi Xiilaan na dhagaʼaa; yaa niitota Laamehii dubbii koo dhaggeeffadhaa. Nama tokko waan inni na madeesseef, dargaggeessa tokko waan inni na miidheef ani isa ajjeeseera. ");
INSERT INTO gaz_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Yoo Qaayiniif dachaa torba haaloon baafame Laamehiif immoo dachaa torbaatamii torba ni baafama.” ");
INSERT INTO gaz_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Addaam ammas niitii isaa beeke; isheenis ilma deesse; maqaa isaas, “Erga Qaayin Abeelin ajjeesee as Waaqni iddoo Abeel daaʼima biraa naa kenneera” jettee “Seeti” jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Seetiifis ilmi ni dhalate; innis Enoosh jedhee isa moggaase. Bara sana namoonni maqaa Waaqayyoo waammachuu jalqaban. ");
INSERT INTO gaz_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Kun galmee sanyii Addaam. Waaqni yeroo nama uumetti akka fakkeenya Waaqaatti isa tolche. ");
INSERT INTO gaz_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Innis dhiiraa fi dubartii taasisee isaan uume; isaan eebbises. Yeroo uumamanis “Nama” jedhee isaan waame. ");
INSERT INTO gaz_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Addaam waggaa 130 jiraate; innis akka fakkaattii isaatti, akka bifa isaattis ilma dhalchee Seeti jedhee maqaa baaseef. ");
INSERT INTO gaz_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Addaam erga Seeti dhalatee booddee waggaa 800 jiraate; innis ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Walumatti Addaam waggaa 930 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Seeti waggaa 105 jiraatee Enooshin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Erga Enooshin dhalchee booddees Seeti waggaa 807 jiraate; innis ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Walumatti Seeti waggaa 912 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoosh waggaa 90 jiraatee Qeenaanin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Erga Qeenaanin dhalchee booddees Enoosh waggaa 815 jiraate; innis ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Walumatti Enoosh waggaa 905 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qeenaan waggaa 70 jiraatee Mahalaleelin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Erga Mahalaleeliin dhalchee booddee Qeenaan waggaa 840 jiraate; innis ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Walumatti Qeenaan waggaa 910 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalaleel waggaa 65 jiraatee Yaaredin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Erga Yaaredin dhalchee booddee Mahalaleel waggaa 830 jiraate; innis ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Walumatti Mahalaleel waggaa 895 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaared waggaa 162 jiraatee Henookin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Erga Henookin dhalchee booddee Yaared waggaa 800 jiraate; innis ilmaanii fi intallan biraa qaba ture. ");
INSERT INTO gaz_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Walumatti Yaared waggaa 962 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henook waggaa 65 jiraatee Matuuselaa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Henook erga Matuuselaa dhalchee booddee waggaa 300 Waaqa wajjin deddeebiʼe; innis ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Walumatti Henook waggaa 365 jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henook Waaqa wajjin deddeebiʼe; waan Waaqni isa fudhateef inni deebiʼee hin argamne. ");
INSERT INTO gaz_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matuuselaan waggaa 187 jiraatee Laamehin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Erga Laamehin dhalchee booddee Matuuselaan waggaa 782 jiraate; innis ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Walumatti Matuuselaan waggaa 969 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Laameh waggaa 182 jiraatee ilma dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Innis, “Hojii nu lafa Waaqayyo abaare kana irratti hojjennuu fi dadhabbii harka keenyaa kana keessatti nu jajjabeessa” jechuudhaan maqaa isaa Nohi jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Laameh erga Nohin dhalchee booddee waggaa 595 jiraate; innis ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Walumatti Laameh 777 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nohi erga waggaa 500 jiraatee booddee Seem, Haamii fi Yaafetin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Yeroo namoonni biyya lafaa irratti baayʼachuu jalqabanii intallan dhalataniifitti, ");
INSERT INTO gaz_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Ilmaan Waaqaa akka intallan namootaa babbareedoo taʼan argan; isaan keessaas abbuma filatan fuudhan. ");
INSERT INTO gaz_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Yommus Waaqayyo, “Namni waan foon taʼeef Hafuurri koo bara baraan isa keessa hin jiraatu; barri jireenya isaas waggaa dhibba tokkoo fi digdama taʼa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Bara sanaa fi ergasiis Nefiiliimonni lafa irra turan; ilmaan Waaqaas yommuu gara intallan namaa dhaqanitti ijoollee dhalchan. Isaanis gootota durii warra beekamoo turan. ");
INSERT INTO gaz_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Waaqayyos akka jalʼinni namaa lafa irratti baayʼatee, wanni namni yeroo hunda garaa isaatti yaadu hundinuus jalʼaa qofa taʼe arge. ");
INSERT INTO gaz_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Waaqayyos waan lafa irratti nama uumeef ni gaabbe; garaan isaas ni gadde. ");
INSERT INTO gaz_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Kanaafuu Waaqayyo, “Ani sanyii namaa kan ofii kootiin uume lafa irraa nan balleessa. Namaa fi horii, uumama lafa irra munyuuqu, simbirroota samii nan balleessa; ani isaan uumuu kootti gaabbeeraatii” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nohi garuu fuula Waaqayyoo duratti surraa argate. ");
INSERT INTO gaz_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Seenaan Nohii fi maatii isaa kanaa dha. Nohi namoota bara isaa turan gidduutti nama qajeelaa, nama hirʼina hin qabne kan Waaqa wajjin deddeebiʼu ture. ");
INSERT INTO gaz_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Nohi ilmaan sadii dhalche; isaanis: Seem, Haamii fi Yaafet. ");
INSERT INTO gaz_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Lafti fuula Waaqaa duratti faalamtee jeequmsaan guutamte turte. ");
INSERT INTO gaz_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Sababii namoonni lafa irraa hundinuu karaa isaanii faalaniif, Waaqni akka lafti faalamte arge. ");
INSERT INTO gaz_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Kanaafuu Waaqni Nohiin akkana jedhe; “Waan lafti sababii isaaniitiin jeequmsaan guutamteef, ani nama hunda nan balleessa; kunoo ani dhugumaan lafaa fi isaan nan barbadeessa. ");
INSERT INTO gaz_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ati muka Goofar irraa doonii tolfadhu; keessa isaattis kutaa garaa garaa qopheessi; keessaa fi duuba isaas hapheedhaan duuchi. ");
INSERT INTO gaz_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Haalli ati ittiin doonicha tolchitu kanaa dha; dheerina isaa dhundhuma dhibbaa sadii, balʼina isaa dhundhuma shantama, ol dheerina isaa dhundhuma soddoma godhi. ");
INSERT INTO gaz_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Doonichaaf bantii dhundhuma tokko ol kaʼu hojjedhu; cinaacha isaa irrattis balbala baasi; kanas abbaa darbii sadii jechuunis kan gadii, kan gidduutii fi kan gubbaa godhii hojjedhu. ");
INSERT INTO gaz_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Kunoo, ani uumamawwan lubbu qabeeyyii hunda samii jalaa balleessuuf bishaan badiisaa lafatti nan fida; wanni lafa irra jiraatu hundinuus ni bada. ");
INSERT INTO gaz_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Si wajjin garuu kakuu nan gala; atis doonii seenta; atii fi ilmaan kee, niitiin keetii fi niitonni ilmaan keetiis ni seentu. ");
INSERT INTO gaz_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Uumamawwan lubbu qabeeyyii hundumaa keessaa akka isaan si wajjin jiraataniif lama lama, kormaa fi dhalaa doonichatti galchi. ");
INSERT INTO gaz_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Simbirroota keessaa akkuma gosa gosa isaaniitti, horii keessaa akkuma gosa gosa isaaniitti, uumamawwan lafa irra munyuuqan keessaas akkuma gosa gosa isaaniitti, lama lama taʼanii jiraachuuf gara kee dhufu. ");
INSERT INTO gaz_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Waan nyaatamu hunda keessaa waa fuudhii of biratti walitti qabi! Kunis nyaata keetii fi nyaata isaanii ni taʼa.” ");
INSERT INTO gaz_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nohi akkuma Waaqni isa ajajetti waan hunda hojjete. ");
INSERT INTO gaz_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Waaqayyos Nohiin akkana jedhe; “Ani akka ati dhaloota kana keessaa na duratti qajeelaa taate argeeraatii maatii kee hundumaa wajjin doonicha seeni. ");
INSERT INTO gaz_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Bineensa qulqulluu gosa hunda keessaa kormaa fi dhalaa cimdii torba, bineensa qulqulluu hin taʼin gosa hunda keessaa cimdii tokko, ");
INSERT INTO gaz_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","gosa simbirrootaa hunda keessaa illee akka sanyiin lafa hunda irratti hafee jiraatuuf kormaa fi dhalaa cimdii torba fudhadhuu seeni. ");
INSERT INTO gaz_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ani guyyaa torba booddee halkan afurtamaa fi guyyaa afurtama bokkaa nan roobsa; uumama jiraataa ani mataan koo uume hunda lafa irraa nan haxaaʼa.” ");
INSERT INTO gaz_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nohis waan Waaqayyo isa ajaje hunda ni hojjete. ");
INSERT INTO gaz_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yeroo bishaan badiisaa dhufetti Nohi nama waggaa dhibba jaʼa ture. ");
INSERT INTO gaz_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Nohii fi ilmaan isaa, niitii isaatii fi niitonni ilmaan isaa bishaan badiisaa jalaa baʼuuf doonii seenan. ");
INSERT INTO gaz_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Bineensonni qulqulluu fi kan qulqulluu hin taʼin, simbirroonnii fi uumamawwan lafa irra munyuuqan hundi, cimdii cimdiidhaan, ");
INSERT INTO gaz_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","kormaa fi dhalaan gara Nohi dhufanii akkuma Waaqni Nohiin ajajetti doonicha seenan. ");
INSERT INTO gaz_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Guyyaa torba booddee bishaan badiisaa lolaʼee lafa guute. ");
INSERT INTO gaz_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Bara jireenya Nohi waggaa dhibba jaʼaffaa keessa, jiʼa lammaffaatti, jiʼa sana keessaas guyyaa kudha torbaffaatti burqaawwan tuujuba gurguddaa hundi ni dhoʼan; foddaawwan bishaan samiis ni banaman. ");
INSERT INTO gaz_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Bokkaanis guyyaa afurtamaa fi halkan afurtama lafatti roobe. ");
INSERT INTO gaz_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Guyyuma sana Nohii fi ilmaan isaa, Seem, Haamii fi Yaafet, niitii isaatii fi niitota ilmaan isaa sadanii wajjin doonicha seenan. ");
INSERT INTO gaz_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Isaanis bineensota hunda, akkuma gosa isaaniitti, horii hunda akkuma gosa isaaniitti, uumamawwan lafa irra munyuuqan hundaa fi simbirroota hunda akkuma gosa isaaniitti, waan qoochoo qabu hundas of faana fudhatanii seenan. ");
INSERT INTO gaz_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","Uumamawwan hafuura jireenyaa of keessaa qaban hundinuus cimdii cimdiidhaan gara Nohi dhufanii doonicha seenan. ");
INSERT INTO gaz_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Bineensonni akkuma Waaqni Nohin ajajetti dooniitti galan kormaa fi dhalaa uumamawwan lubbu qabeeyyii hundaa turan; ergasii immoo Waaqayyo alaan itti cufe. ");
INSERT INTO gaz_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Bishaan badiisaas ittuma fufee guyyaa afurtamaaf lafa irra ture; bishaan sunis dabalaa deemee doonii sana lafa irraa ol kaase. ");
INSERT INTO gaz_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Bishaanichis ol kaʼee lafa irratti akka malee baayʼate; dooniin sunis bishaanicha irra deeme. ");
INSERT INTO gaz_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Bishaanichis akka malee ol kaʼaa deemee tulluuwwan samii jala jiran hunda haguuge. ");
INSERT INTO gaz_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bishaanichi dhundhuma kudha shan caalaa ol kaʼuudhaan tulluuwwan dhokse. ");
INSERT INTO gaz_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Uumamawwan lubbu qabeeyyiin lafa irra jiraatan hundi jechuunis, simbirroonni, horiin, bineensonni, uumamawwan lafa irra munyuuqan hundii fi namoonni hundi ni barbadaaʼan. ");
INSERT INTO gaz_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Wanni lafa gogaa irra jiraatu kan funyaan isaatiin hafuura jireenyaa baafatu hundinuu ni duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Uumamawwan lubbu qabeeyyiin lafa irra jiraatan hundinuu ni haxaaʼaman; namnii fi horiin, uumamawwan lafa irra munyuuqanii fi simbirroonni samii, lafa irraa ni haxaaʼaman. Nohii fi warra isa wajjin doonii keessa turan qofattu hafe. ");
INSERT INTO gaz_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Bishaan sunis bultii dhibba tokkoo fi shantama lafa irra lolaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Waaqni garuu Nohin, bineensotaa fi horii isa wajjin doonii keessa turan hunda yaadate. Innis bubbee lafatti erge; bishaanichis gad gale. ");
INSERT INTO gaz_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Burqaawwan tuujubawwaniitii fi foddaawwan samiiwwanii ni cufaman; bokkaan samii keessaa gad roobus ni caame. ");
INSERT INTO gaz_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","Bishaan sunis suutuma suuta lafa irraa hirʼachaa deemee dhuma bultii dhibba tokkoo fi shantamaatti gad buʼe. ");
INSERT INTO gaz_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Dooniin sunis guyyaa kudha torbaffaa jiʼa torbaffaatti tulluu Araaraati gubbaa qubate. ");
INSERT INTO gaz_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Bishaanichi hamma jiʼa kurnaffaatti gaduma galaa deeme. Guyyaa jalqaba jiʼa kurnaffaattis mataawwan tulluuwwanii mulʼatan. ");
INSERT INTO gaz_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Guyyaa afurtama booddee Nohi foddaa dooniitti baasee ture sana bane; ");
INSERT INTO gaz_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","innis arraagessa tokko gad dhiise; arraagessi sunis hamma bishaanichi lafa irraa gogutti asii fi achi deddeebiʼaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Ergasii immoo akka bishaanichi lafa irraa hirʼate hubachuuf gugee tokko erge. ");
INSERT INTO gaz_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Garuu sababii bishaan lafa hunda irra guutee jiruuf gugeen sun iddoo qubatu dhabdee gara Nohi dooniitti deebite. Innis harka isaa gad hiixatee gugee sana gara dooniitti iddoo ofii jirutti ol galche. ");
INSERT INTO gaz_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Ammas guyyaa torba turee gugee sana doonii keessaa gad baasee erge. ");
INSERT INTO gaz_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Gugeen sunis galgala yommuu gara isaatti deebitetti kunoo, baala ejersaa kan amma kutame afaanitti qabattee turte. Kanaanis Nohi akka bishaanichi gad hirʼate beeke. ");
INSERT INTO gaz_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Ammas guyyaa biraa torba turee gugee sana deebisee erge; gugeen sun garuu lammata gara isaatti hin deebine. ");
INSERT INTO gaz_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Umurii Nohii waggaa dhibba jaʼaa fi tokkoffaatti, guyyaa tokkoffaa jiʼa jalqabaatti, bishaanichi lafa irraa goge. Nohis qadaada doonii sanaa irraa fuudhee ilaalee kunoo akka lafti gogde arge. ");
INSERT INTO gaz_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Guyyaa digdamii torbaffaa jiʼa lammaffaatti lafti guutummaan guutuutti gogde. ");
INSERT INTO gaz_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Waaqnis Nohiin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","“Atii fi niitiin kee, ilmaan keetii fi niitonni ilmaan keetii kottaa doonii keessaa baʼaa. ");
INSERT INTO gaz_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Akka isaan lafa irratti baayʼataniif, akka isaan horanii lafa irratti baayʼataniif, gosa uumamawwan lubbu qabeeyyii si wajjin jiran hunda jechuunis simbirroota, bineensotaa fi uumamawwan lafa irra munyuuqan hunda gad baasi.” ");
INSERT INTO gaz_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Kanaafuu Nohi ilmaan isaatii fi niitii isaa, niitota ilmaan isaa wajjin gad baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Bineensonni hundii fi uumamawwan lafa irra munyuuqan hundinuu, simbirroonni hundi jechuunis wanni lafa irra jiraatu hundi gosuma gosaan doonii sana keessaa gad baʼan. ");
INSERT INTO gaz_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nohis Waaqayyoof iddoo aarsaa ijaare; horii fi simbirroota qulqulluu hunda keessaa fuudhee iddoo aarsaa sana irratti aarsaa gubamu dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Waaqayyos foolii tolaa sana urgeeffatee garaa isaa keessatti akkana jedhe; “Yoo wanni namni ijoollummaa isaatii jalqabee garaa isaatti yaadu hammina taʼe illee ani sababii namaatiif jedhee lammata lafa hin abaaru. Ani akkan kanaan dura godhe sana deebiʼee uumamawwan jiraatoo hunda hin balleessu. ");
INSERT INTO gaz_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","“Hamma lafti jirtutti, midhaan facaasuu fi walitti qabuun, dhaamochii fi hoʼi, bonnii fi ganni, halkanii fi guyyaan gonkumaa hin hafan.” ");
INSERT INTO gaz_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Waaqni akkana jedhee Nohii fi ilmaan isaa eebbise; “Horaa, baayʼadhaa, lafas guutaa. ");
INSERT INTO gaz_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Sodaachisuu fi naasisuun keessan bineensota lafaa hundumaa fi simbirroota samii hundumaa, uumamawwan lafa irra munyuuqan hundumaa fi qurxummiiwwan galaanaa hundumaa irra haa buʼu; isaan harka keessanitti kennamaniiru. ");
INSERT INTO gaz_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Wanni jiraatuu fi wanni munyuuqu hundi nyaata isiniif ni taʼa. Ani akkuman biqila lalisaa isinii kenne sana ammas waan hunda isiniif nan kenna. ");
INSERT INTO gaz_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","“Isin garuu foon lubbuu isaa wajjin jechuunis dhiiga isaa wajjin hin nyaatinaa. ");
INSERT INTO gaz_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ani dhugumaan dhiiga keessan kan lubbuun keessan keessa jirtu nan barbaada. Bineensa hunda irraa nan barbaada. Obboleessa nama hundaa irraas lubbuu namaa nan barbaada. ");
INSERT INTO gaz_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","“Nama dhiiga namaa dhangalaasu, dhiigni isaa harka namaatiin dhangalaafama; Waaqni bifa Waaqaatiin nama uumeetii. ");
INSERT INTO gaz_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","Isinis horaa, baayʼadhaa; lafa guutaa, irrattis baayʼadhaa.” ");
INSERT INTO gaz_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Ergasii Waaqni Nohii fi ilmaan isaa warra isaa wajjin turaniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","“Kunoo ani isinii fi sanyii keessan warra isin booddee wajjin kakuu koo nan hundeessa. ");
INSERT INTO gaz_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","Akkasumas uumamawwan lubbu qabeeyyii isin wajjin turan hunda jechuunis simbirroota, horii fi bineensota lafaa hunda, waan isin wajjin doonii keessaa baʼe hunda, uumamawwan lafa irra jiraatan hunda wajjinis kakuu koo nan hundeessa. ");
INSERT INTO gaz_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Akka siʼachi wanni lubbuu qabu hundi deebiʼee bishaan badiisaatiin hin badneef, siʼachi bishaan badiisaa lafa balleessuuf gonkumaa akka hin dhufneef ani isin wajjin kakuu koo nan hundeessa.” ");
INSERT INTO gaz_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Waaqni akkana jedhe; “Mallattoon kakuu kan ani ofii kootii fi isin gidduutti, uumamawwan lubbuu qabeeyyii isin bira jiran hunda gidduutti, dhaloota dhufuuf jiru hundaaf galu kanaa dha. ");
INSERT INTO gaz_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","Ani sabbata koo duumessa keessa dhaabeera; innis kakuu anaa fi lafa gidduu jiruuf mallattoo taʼa. ");
INSERT INTO gaz_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yeroo ani lafa irratti duumessa fidee sabbanni koo duumessa keessaan mulʼatutti, ");
INSERT INTO gaz_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ani kakuu koo kan ofii kootii fi isin gidduu, uumamawwan lubbu qabeeyyii gosa hundaa gidduus jiru sana nan yaadadha. Bishaanonnis deebiʼanii lubbuu hunda balleessuuf gonkumaa bishaan badiisaa hin taʼan. ");
INSERT INTO gaz_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Yeroo sabbanni koo duumessa keessaan mulʼatutti, ani isa ilaalee kakuu bara baraa kan Waaqaa fi uumamawwan lubbu qabeeyyii gosa hundaa kanneen lafa irra jiraatan gidduu jiru sana nan yaadadha.” ");
INSERT INTO gaz_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Kanaafuu Waaqni Nohiin, “Kun mallattoo kakuu ani ofii kootii fi lubbuu lafa irra jiraatu hunda gidduu dhaabe sanaa ti” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Ilmaan Nohi warri doonii keessaa baʼan Seem, Haamii fi Yaafet turan. Haam abbaa Kanaʼaanii ti. ");
INSERT INTO gaz_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Ilmaan Nohi jara kana sadan turan; sanyiin namaa kan lafa hunda irra bittinneeffames isaanuma irraa argame. ");
INSERT INTO gaz_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nohi qonnaan bulaa taʼee wayinii dhaabuutti nama jalqabaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Innis daadhii wayinii sanaa dhugee machaaʼe; qullaa isaas dunkaana isaa keessa ciise. ");
INSERT INTO gaz_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Haam abbaan Kanaʼaan qullaa abbaa isaa argee obboloota isaa lamaan ala turanitti hime. ");
INSERT INTO gaz_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Seemii fi Yaafeti garuu wayyaa fuudhanii gatiittii isaanii lamaan irra buufatanii dugda duubaan deemanii qullaa abbaa isaaniitti uffisan. Waan fuulli isaanii achi garagalee tureef isaan qullaa abbaa isaanii hin argine. ");
INSERT INTO gaz_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nohis yeroo machiin isaa irraa galetti waan ilmi isaa inni xinnaan isatti hojjete beekee ");
INSERT INTO gaz_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","akkana jedhe; “Kanaʼaan abaaramaa haa taʼu! Inni obboloota isaatiif garba garbootaa haa taʼu.” ");
INSERT INTO gaz_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Akkanas jedhe; “Waaqayyo Waaqni Seem haa eebbifamu! Kanaʼaan immoo garbicha Seem haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Waaqni biyya Yaafet haa balʼisu; Yaafet dunkaanota Seem keessa haa jiraatu; Kanaʼaan immoo garbicha isaa haa taʼu.” ");
INSERT INTO gaz_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bishaan badiisaa booddee Nohi waggaa 350 jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Walumatti Nohi waggaa 950 jiraatee duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Seenaan ilmaan Nohi jechuunis kan Seem, kan Haamii fi kan Yaafet kana; isaanis bishaan badiisaa booddee ilmaan dhalchan. ");
INSERT INTO gaz_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ilmaan Yaafet: Goomer, Maagoog, Meedee, Yaawaan, Tuubaal, Meshekii fi Tiiraas turan. ");
INSERT INTO gaz_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ilmaan Goomer: Ashkenas, Riifaatii fi Toogarmaa turan. ");
INSERT INTO gaz_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ilmaan Yaawaan: Eliishaa, Tarshiish, Kitiimii fi Roodaanota turan. ");
INSERT INTO gaz_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Uummanni qarqara galaanaas tokkoon tokkoon isaanii akkuma afaan isaaniittii fi akkuma saba isaaniitti gara biyyoota isaaniitti bibittinnaaʼan. ");
INSERT INTO gaz_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ilmaan Haam: Kuushi, Misrayim, Fuuxii fi Kanaʼaan turan. ");
INSERT INTO gaz_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Ilmaan Kuushi: Saabaa, Hawiilaa, Sabtaa, Raʼimaa fi Sabtekaa turan. Ilmaan Raʼimaa: Shebaa fi Dedaan turan. ");
INSERT INTO gaz_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuushi abbaa Naamruud; Naamruudis lafa irratti loltuu jabaa taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Innis fuula Waaqayyoo duratti adamsaa jabaa ture; kanaafuu, “Fuula Waaqayyoo duratti adamsaa jabaa akka Naamruudi” jedhame. ");
INSERT INTO gaz_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Jalqabni mootummaa isaa Shineʼaar keessatti Baabilon, Ereki, Akaadii fi Kaalnee ture. ");
INSERT INTO gaz_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Innis biyya sanaa baʼee Asoor dhaqe; achittis Nanawwee, Rehoobootii fi Kaalahi ijaare; ");
INSERT INTO gaz_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","akkasumas Resen ishee Nanawwee fi Kaalah gidduutti argamtu ni ijaare; Resen kunis magaalaa guddoo dha. ");
INSERT INTO gaz_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Misrayim immoo abbaa Luudiimootaa, Anaamiimotaa, Lehaabiimotaa, Naftahiimootaa, ");
INSERT INTO gaz_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fatrusiimotaa, Kaseluhiimotaa, jechuunis warra Filisxeemonni irraa dhalatanii fi Kaftooriimotaa ti. ");
INSERT INTO gaz_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kanaʼaan abbaa Siidoon ilma isaa hangaftichaa, akkasumas kan Heetotaa, ");
INSERT INTO gaz_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Yebuusotaa, Amoorotaa, Girgaashotaa, ");
INSERT INTO gaz_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiiwotaa, Arkaawotaa, Siinotaa, ");
INSERT INTO gaz_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwaadewotaa, Zemaarotaatii fi Hamaatotaa ture. Ergasii gosoonni Kanaʼaan ni bibittinnaaʼan; ");
INSERT INTO gaz_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","daariin Kanaʼaanis Siidoonii kaʼee karaa Geraaraatiin hamma Gaazaatti balʼate; karaa Sodoom, Gomoraa, Adimaatii fi Zebooʼiimiitiinis hamma Leshaatti balʼate. ");
INSERT INTO gaz_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Ilmaan Haam akkuma gosaa fi afaan isaaniitti, akkuma biyyaa fi saba isaaniitti kanneenii dha. ");
INSERT INTO gaz_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Seemiifis ilmaan ni dhalatan; obboleessi Seem hangafti Yaafet ture; Seemis abbaa ilmaan Eeber hundaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ilmaan Seem Eelaam, Ashuur, Arfaakshad, Luudii fi Arraam turan. ");
INSERT INTO gaz_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ilmaan Arraam Uuzi, Huuli, Geterii fi Meshek turan. ");
INSERT INTO gaz_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaakshad Sheelaa dhalche; Sheelaan immoo Eeberin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Eeberiifis ilmaan lamatu dhalate; sababii bara isaa keessa lafti gargar qoodamteef maqaan isa tokkoo Felegi jedhamee moggaafame; maqaan obboleessa isaa immoo Yooqxaan jedhamee moggaafame. ");
INSERT INTO gaz_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Yooqxaan immoo Almoodaad, Sheleef, Hazarmaawet, Yaaraa, ");
INSERT INTO gaz_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadooraam, Uuzaal, Diqlaa, ");
INSERT INTO gaz_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Oobaal, Abiimaaʼeel, Shebaa, ");
INSERT INTO gaz_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Oofiir, Hawiilaa fi Yoobaabin dhalche. Warri kunneen hundinuu ilmaan Yooqxaanii ti. ");
INSERT INTO gaz_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Lafti jireenya isaanii Meeshaa kaʼee karaa Sefaariitiin hamma gaarran baʼa biiftuutti balʼata. ");
INSERT INTO gaz_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Ilmaan Seemi akkuma gosaa fi afaan isaaniitti, akkuma biyyaa fi saba isaaniitti kanneenii dha. ");
INSERT INTO gaz_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Warri kun gosoota ilmaan Nohi kanneen akkuma dhaloota isaaniitti saba isaanii keessa jiranii dha; bishaan badiisaatiin booddee saboonni warruma kana irraa lafa irra faffacaʼan. ");
INSERT INTO gaz_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bara sana addunyaan guutuun afaan tokkoo fi haasaa tokko qaba ture. ");
INSERT INTO gaz_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Namoonni akkuma gara baʼa biiftuutti godaananiin, Shineʼaar keessatti lafa diriiraa argatanii achi qubatan. ");
INSERT INTO gaz_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Isaanis, “Kottaa mee xuubii hojjennee ibiddaan gubnaa” waliin jedhan. Isaanis qooda dhagaa, xuubiitti fayyadaman; hapheedhaaf immoo leeleetti fayyadaman. ");
INSERT INTO gaz_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Ergasii, “Kottaa mee akka ofii keenyaa maqaa argannuu fi akka addunyaa guutuu irra hin bibittinnoofneef magaalaa gamoon isaa samii qaqqabu tokko ijaarrannaa” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Waaqayyo garuu magaalaa fi gamoo isaan ijaaraa turan sana ilaaluuf gad buʼe. ");
INSERT INTO gaz_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Waaqayyos akkana jedhe; “Erga isaan akka saba tokko kan afaanuma tokko dubbatuutti waan kana hojjechuu jalqabanii, yoos amma wanni isaan hojjechuuf karoorfatan kan isaaniif hin dandaʼamne tokko iyyuu hin jiraatu. ");
INSERT INTO gaz_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kottaa mee gad buunee, akka isaan wal hin hubanneef afaan isaanii waliin dhoofnaa!” ");
INSERT INTO gaz_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Kanaafuu Waaqayyo achii isaan baasee lafa hunda irra isaan bittinneesse; isaanis magaalaa ijaaruu dhiisan. ");
INSERT INTO gaz_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Waan Waaqayyo achitti afaan addunyaa hunda waliin makeef iddoon sun Baabilon jedhame; Waaqayyo iddoo sanaa isaan baasee lafa hunda irra isaan bittinneesse. ");
INSERT INTO gaz_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Seenaan maatii Seem kana. Bishaan badiisaa booddee waggaa lamatti Seem yeroo umuriin isaa waggaa 100 guutetti Arfaakshadin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Seem erga Arfaakshadin dhalchee booddee waggaa 500 jiraatee ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaakshad waggaa 35 jiraatee Sheelaa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Arfaakshad erga Sheelaa dhalchee booddee waggaa 403 jiraatee ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Sheelaan waggaa 30 jiraatee Eeberin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Sheelaan erga Eeberin dhalchee booddee waggaa 403 jiraatee ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Eeber waggaa 34 jiraatee Felegin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Eeber erga Felegin dhalchee booddee waggaa 430 jiraatee ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Felegi waggaa 30 jiraatee Reʼuu dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Felegi erga Reʼuu dhalchee booddee waggaa 209 jiraatee ilmaanii fi intallan biraas dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Reʼuun waggaa 32 jiraatee Seruugin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Reʼuun erga Seruugin dhalchee booddee waggaa 207 jiraatee ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruugi waggaa 30 jiraatee Naahoorin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Seruugi erga Naahoorin dhalchee booddee waggaa 200 jiraatee ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naahoor waggaa 29 jiraatee Taaraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Naahoor erga Taaraa dhalchee booddee waggaa 119 jiraatee ilmaanii fi intallan biraa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taaraan waggaa 70 jiraatee Abraam, Naahoorii fi Haaraanin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Seenaan maatii Taaraa kana. Taaraan Abraam, Naahoorii fi Haaraanin dhalche. Haaraan immoo Looxin dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Haaraan utuma abbaan isaa Taaraan jiruu Uuri biyya Kaldootaa keessatti lafuma itti dhalatetti duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abraamii fi Naahoor niitii fuudhan. Maqaan niitii Abraam Saaraa, maqaan niitii Naahoor immoo Miilkaa ture. Miilkaan intala Haaraan. Haaraan kun immoo abbaa Miikaatii fi Yiskaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saaraan dhabduu turte; ijoollees hin deenye. ");
INSERT INTO gaz_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taaraan ilma isaa Abraamin, ilma ilma isaa jechuunis Loox ilma Haaraanii fi niitii ilma isaa jechuunis Saaraa niitii Abraam fudhatee Kanaʼaan dhaquuf, Uuri biyya Kaldootaatii walii wajjin baʼan; garuu yeroo Kaaraan gaʼanitti achuma qubatan. ");
INSERT INTO gaz_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taaraan waggaa 205 jiraatee Kaaraanitti duʼe. ");
INSERT INTO gaz_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Waaqayyo Abraamiin akkana jedhe; “Biyya kee, saba keetii fi mana abbaa keetii dhiisiitii gara biyya ani si argisiisuu dhaqi. ");
INSERT INTO gaz_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","“Ani saba guddaa sin taasisa; sin eebbisas; maqaa kee illee guddaa nan taasisa; atis eebba taataa. ");
INSERT INTO gaz_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ani warra si eebbisan nan eebbisa; warra si abaaran nan abaara; sabni lafa irraa hundinuu karaa keetiin eebbifama.” ");
INSERT INTO gaz_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Kanaafuu Abraam akkuma Waaqayyo isatti himetti kaʼee deeme; Looxis isa wajjin deeme. Abraam yeroo Kaaraanii baʼetti nama waggaa torbaatamii shan ture. ");
INSERT INTO gaz_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Innis niitii isaa Saaraa, ilma obboleessa isaa Loox, qabeenya walitti kuufatan hundumaa fi namoota Kaaraanitti argatan hundumaa qabatee Kanaʼaan dhaquuf kaʼe; isaanis achi gaʼan. ");
INSERT INTO gaz_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abraamis hamma qilxuu Mooree kan Sheekem keessatti argamuutti biyyattii keessa deeme. Yeroo sana warri Kanaʼaan biyya sana keessa turan. ");
INSERT INTO gaz_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Waaqayyo Abraamitti mulʼatee, “Ani biyya kana sanyii keetiif nan kenna” jedheen. Kanaafuu inni achitti Waaqayyo isatti mulʼate sanaaf iddoo aarsaa ijaare. ");
INSERT INTO gaz_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Achii kaʼee gara gaarran Beetʼeel irraa gara baʼa biiftuutti argamanii deemee Beetʼeelin gara lixa biiftuutti, Aayin immoo gara baʼa biiftuutti hambisee dunkaana isaa dhaabbate. Achitti Waaqayyoof iddoo aarsaa ijaaree maqaa Waaqayyoo waammate. ");
INSERT INTO gaz_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Abraam ergasii kaʼee gara Negeebitti karaa isaa itti fufe. ");
INSERT INTO gaz_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Bara sana beelli biyya sanatti buʼee ture; beelli sun waan hammaateef Abraam achi jiraachuuf jedhee Gibxitti gad buʼe. ");
INSERT INTO gaz_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Innis yeroo Gibxi seenuu gaʼetti niitii isaa Saaraan akkana jedhe; “Ani akka ati dubartii bareedduu taate nan beeka. ");
INSERT INTO gaz_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Warri Gibxi yommuu si argan, ‘Kun niitii isaa ti’ jedhanii na ajjeesu; siʼi immoo ni hambisu. ");
INSERT INTO gaz_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Akka isaan siif jedhanii haala tolaan na ilaalanii fi akka lubbuun koos sababii keetiin duʼa ooltuuf maaloo, ‘Ani obboleettii isaa ti’ jedhi.” ");
INSERT INTO gaz_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Yeroo Abraam Gibxi seenettis warri Gibxi akka Sooraan dubartii baayʼee bareedduu taate argan. ");
INSERT INTO gaz_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Qondaaltonni Faraʼooniis yommuu ishee arganitti ishee jajanii Faraʼoonitti himan; isheenis masaraa mootummaa Faraʼooniitti geeffamte. ");
INSERT INTO gaz_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Faraʼoon sababii isheetiif jedhee Abraamin haala tolaadhaan ilaale; Abraamis hoolotaa fi loon, harroota korommii fi dhaltuu, tajaajiltoota dhiiraa dubartii, gaalas argate. ");
INSERT INTO gaz_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Waaqayyo garuu sababii niitii Abraam, sababii Saaraatiif jedhee Faraʼoonii fi warra mana isaa jiraatan dhukkuba hamaan dhaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Kanaafuu Faraʼoon Abraamin ofitti waamee akkana jedheen; “Ati maal natti hojjette? Akka isheen niitii kee taate maaliif natti hin himin? ");
INSERT INTO gaz_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ati maaliif, ‘Isheen obboleettii koo ti’ jettee, akka ani niitummaaf ishee fudhadhu na goote? Ammas niitiin kee kunoo ti; ishee fudhadhuu deemi!” ");
INSERT INTO gaz_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Faraʼoonis waaʼee Abraam irratti namoota isaa ajaje; isaanis Abraamii fi niitii isaa, waan inni qabu hunda wajjin geggeessan. ");
INSERT INTO gaz_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abraam niitii isaatii fi waan qabu hunda wajjin Gibxii kaʼee Negeebitti ol baʼe; Looxis isa wajjin deeme. ");
INSERT INTO gaz_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abraamis horiin, meetii fi warqeedhaan akka malee soorome. ");
INSERT INTO gaz_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Innis Negeebii kaʼee hamma Beetʼeel, iddoo Beetʼeelii fi Aayi gidduu, lafa dunkaanni isaa jalqabatti ture sana gaʼutti iddoo tokkoo gara iddoo biraatti deemsa isaa itti fufe; ");
INSERT INTO gaz_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","iddoon sunis lafa inni yeroo jalqabaatiif iddoo aarsaa itti ijaaree dha. Abraamis achitti maqaa Waaqayyoo waammate. ");
INSERT INTO gaz_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Loox namichi Abraam wajjin deemaa ture suni akkasuma bushaayee, saawwanii fi dunkaanota qaba ture. ");
INSERT INTO gaz_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Yeroo isaan walii wajjin jiraatanitti lafti isaanitti dhiphatte; sababii qabeenyi isaanii akka malee guddateefis isaan wal bira jiraachuu hin dandeenye. ");
INSERT INTO gaz_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","Kanaafuu tiksoota Abraamii fi tiksoota Loox gidduutti lolli uumame. Yeroo sanatti Kanaʼaanonnii fi Feerzonnis biyya sana keessa jiraachaa turan. ");
INSERT INTO gaz_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Abraamis Looxiin akkana jedhe; “Nu waan obboloota taaneef, siʼii fi ana gidduu yookaan tiksoota keetii fi tiksoota koo gidduu lolli hin jiraatin. ");
INSERT INTO gaz_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Lafti hundi fuula kee dura jirti mitii? Kottu gargari godaannaa. Yoo ati gara bitaatti deemte, ani gara mirgaatti nan deema; yoo ati gara mirgaatti deemte immoo ani gara bitaatti nan deema.” ");
INSERT INTO gaz_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Looxis ol jedhee ilaalee akka hurufni Yordaanos hundi akkuma iddoo biqiltuu Waaqayyoo akkuma biyya Gibxi kan karaa Zoʼaar irra jiru sanaa bishaan baayʼee qabu arge. Kunis utuu Waaqayyo Sodoomii fi Gomoraa hin balleessiniin dura ture. ");
INSERT INTO gaz_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Kanaafuu Loox hurufa Yordaanos guutummaatti ofii isaatii filatee gara baʼa biiftuutti godaane. Jarri lamaanis akkasitti gargari baʼan. ");
INSERT INTO gaz_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abraam biyya Kanaʼaan keessa jiraate; Loox immoo magaalaawwan dirree irra jiran gidduu jiraatee dunkaana isaa Sodoom bira dhaabbate. ");
INSERT INTO gaz_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Warri Sodoom jalʼoota fuula Waaqayyoo duratti akka malee cubbuu hojjetan turan. ");
INSERT INTO gaz_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Erga Loox isa biraa godaanee booddee Waaqayyo Abraamiin akkana jedhe; “Iddoo amma jirtu kanaa ija kee ol fudhadhuutii gara kaabaa fi kibbaa, gara baʼa biiftuutii fi lixa biiftuu ilaali. ");
INSERT INTO gaz_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Anis biyya ati argitu kana hunda bara baraan siʼii fi sanyii keetiif nan kenna. ");
INSERT INTO gaz_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ani sanyii kee akkuma biyyoo lafaa nan baayʼisa; yoo namni biyyoo lafaa lakkaaʼuu dandaʼe, sanyiin kee akkasuma lakkaaʼamuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Kaʼiitii dheerinaa fi balʼina lafa kanaa keessa dedeemi; ani isa siifin kennaatii.” ");
INSERT INTO gaz_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Kanaafuu Abraam dunkaana isaa buqqifatee qilxuuwwan Mamree kanneen Kebroonitti argaman bira jiraachuu dhaqe; achittis iddoo aarsaa Waaqayyoof tolche. ");
INSERT INTO gaz_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Bara sana keessa Amraafel mootiin Shineʼaar, Ariyook mootiin Elaasaar, Kedoorlaaʼomer mootiin Eelaamii fi Tidiʼaal mootiin Sabootaa kaʼanii, ");
INSERT INTO gaz_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Beraa mooticha Sodoom, Birishaa mooticha Gomoraa, Shinaab mooticha Adimaa, Shemeeber mooticha Zebooʼiimii fi mooticha Belaa ishee Zoʼaar jedhamtu sanaa loluu dhaqan. ");
INSERT INTO gaz_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Mootonni shanan kunneen hundi sulula Siidiim isa Galaana Soogiddaa jedhamu keessatti wal gaʼanii humna tokkummaa uummatan. ");
INSERT INTO gaz_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Isaanis waggaa kudha shan Kedoorlaaʼomer jalatti bulan; waggaa kudha sadaffaatti garuu ni fincilan. ");
INSERT INTO gaz_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Waggaa kudha afuraffaatti Kedoorlaaʼomerii fi mootonni isa wajjin turan baʼanii warra Refaayiim Ashteroot Qaarnaayimiitti, warra Zuuziim Haamitti, warra Eemiim Shaawii Kiriyaataayimiitti, ");
INSERT INTO gaz_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","warra Hoori immoo lafa gaara Seeʼiiriitii jalqabanii hamma Eel Phaaraan kan gammoojjiitti dhiʼoo jiru sanaatti moʼatan. ");
INSERT INTO gaz_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Ergasii of irra deebiʼanii Een Mishiphaati jechuunis Qaadesh dhaqanii biyya warra Amaaleq hundaa fi warra Amoor kanneen Hazezoon Taamaar keessa jiraatan humnaan qabatan. ");
INSERT INTO gaz_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Mootichi Sodoom, mootichi Gomoraa, mootichi Adimaa, mootichi Zebooʼiimii fi mootichi Belaa jechuunis Zoʼaar baʼanii Sulula Siidiim keessatti loluuf hiriiran. ");
INSERT INTO gaz_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Isaanis Kedoorlaaʼomer mootii Eelaam, Tidiʼaal mootii Sabootaa, Amraafel mootii Shineʼaariitii fi Ariyook mootii Elaasaar lolan; mootonni afran kunneen mootota shananiin morman. ");
INSERT INTO gaz_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Sululli Siidiim boolla leeleetiin guutamee ture; mootonni Sodoomii fi mootonni Gomoraas baqatanii namoonni tokko tokko boolla sana keessa buʼan; warri hafan immoo gara gaarraniitti baqatan. ");
INSERT INTO gaz_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Mootonni afran sun miʼaa fi nyaata warra Sodoomii fi Gomoraa hunda saamanii sokkan. ");
INSERT INTO gaz_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Waan Loox ilmi obboleessa Abraam Sodoom keessa jiraachaa tureef mootonni sun isa illee qabeenyuma isaa wajjin boojiʼanii deeman. ");
INSERT INTO gaz_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Namichi baqatee baʼe tokko dhufee oduu kana Abraam Ibrichatti hime. Abraamis qilxuuwwan Mamree kan namicha Amoorii sana bira jiraachaa ture; Mamreen kun obboleessa Eshkoolii fi Aaneer ture; isaan Abraam wajjin kakuu galanii turan. ");
INSERT INTO gaz_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abraam akka firri isaa boojiʼame dhageenyaan namoota mana isaatti dhalatanii leenjifaman 318 walitti waammatee hidhachiisee hamma Daaniitti faana buʼe. ");
INSERT INTO gaz_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Abraamis isaan loluuf jedhee halkaniin namoota isaa gargari qoode; hamma Hoobaa ishee kaaba Damaasqootti argamtu sanaattis faana buʼee isaan dhaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Innis miʼa hunda deebifate; fira ofii isaa Looxii fi qabeenya isaa, dubartootaa fi namoota kaanis deebifate. ");
INSERT INTO gaz_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abraam Kedoorlaaʼomeri fi mootota isa wajjin turan moʼatee deebinaan mootiin Sodoom Sulula Shaawii kan Sulula Mootii jedhamu keessatti isa simachuu baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Malkiiseedeq mootiin Saaleemis buddeenaa fi daadhii wayinii fideef; innis luba Waaqayyo Waaqa Waan Hundaa Olii ture; ");
INSERT INTO gaz_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","innis akkana jedhee Abraamin eebbise; “Abraam, Waaqayyo Waaqa Waan Hundaa Olii, isa samii fi lafa uume sanaan haa eebbifamu. ");
INSERT INTO gaz_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Waaqayyo Waaqni Waan Hundaa Olii, inni diinota kee dabarsee harka keetti kenne sun haa eebbifamu.” Ergasii Abraam waan hunda irraa kudhan keessaa tokko isaaf kenne. ");
INSERT INTO gaz_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mootiin Sodoomis Abraamiin, “Namoota naa kenniitii qabeenya immoo ofii keetii fudhadhu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abraam garuu mootii Sodoomiitiin akkana jedhe; “Ani harka koo gara Waaqayyo, Waaqa Waan Hundaa Olii, Uumaa samiitii fi lafaatti ol fudhadhee kakadheen jira; ");
INSERT INTO gaz_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","akka ati, ‘Anatu Abraamin sooromse’ hin jenneef ani waan kan kee taʼe keessaa tokko iyyuu, foʼaa yookaan teepha ittiin kophee hidhatan iyyuu hin fudhadhu. ");
INSERT INTO gaz_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Waan namoonni koo nyaatanii fi qooda namoota ana wajjin deemanii jechuunis qooda Aaneer, kan Eshkooliitii fi kan Mamree malee ani ofii koo homaa hin fudhadhu; isaan qooda isaanii haa fudhatan.” ");
INSERT INTO gaz_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Kana booddee dubbiin Waaqayyoo mulʼataan gara Abraam dhufee akkana jedhe; “Yaa Abraam hin sodaatin; ani gaachana keetii fi gatii kee guddicha.” ");
INSERT INTO gaz_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abraam garuu, “Yaa Waaqayyo Gooftaa, waan ani ijoollee hin qabneef namni qabeenya koo dhaaluuf jiru Eliiʼezer namicha Damaasqoo kana; egaa ati maal naa kennita?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abraam, “Kunoo ati ijoollee tokko illee naa hin kennine; hojjetaan mana koo jiraatu tokko kunoo na dhaaluuf jira” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Kunoo dubbiin Waaqayyoo gara isaa dhufee, “Ilma gudeeda keetiitu dhaaltuu kee taʼa malee namichi kun dhaaltuu kee hin taʼu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Innis Abraamin gad baasee, “Samiiwwan ol ilaaliitii yoo urjiiwwan lakkaaʼuu dandeesse lakkaaʼi” jedhe. Itti fufees, “Sanyiin kees akkanuma baayʼata” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abraam Waaqayyotti amane; innis qajeelummaatti lakkaaʼeef. ");
INSERT INTO gaz_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Innis, “Ani Waaqayyo isa akka ati ishee dhaaltuuf biyya kana siif kennuuf jedhee Uuri biyya Kaldootaa keessaa si baasee dha” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abraam garuu, “Yaa Waaqayyoo Gooftaa, ani biyya kana dhaaluu koo akkamittin beeka?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Kanaafuu Waaqayyo, “Goromsa tokko, reʼee tokkoo fi korbeessa hoolaa tokko kanneen tokkoon tokkoon isaanii waggaa sadii sadii guutan, akkasumas gugee tokkoo fi gugee sookkee tokko naa fidi” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abraamis warra kana hunda gara isaatti fidee, qixxee lamaanitti kukkute; warra qixxee lamaanitti kukkutamanis gamaa gamana kaaʼe; simbirroota garuu qixxee lamaanitti hin kukkunne. ");
INSERT INTO gaz_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Ergasii allaattiin foon sanatti gad buute; Abraam garuu irraa ariʼe. ");
INSERT INTO gaz_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Utuma aduun dhiʼaa jirtuu hirribni guddaan Abraamin qabe; kunoo dukkanni guddaanii fi sodaachisaan isa irra buʼe. ");
INSERT INTO gaz_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Waaqayyos akkana isaan jedhe; “Akka sanyiin kee biyya kan isaa hin taʼin keessatti alagaa taʼee waggaa dhibba afuris achitti garboomfamee cunqurfamu dhugumaan beeki. ");
INSERT INTO gaz_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ani garuu saba isaan akkuma garbootaatti tajaajilan sana nan adaba; ergasii immoo isaan qabeenya guddaa fudhatanii achii baʼu. ");
INSERT INTO gaz_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ati garuu nagaan gara abbootii keetii dhaqxa; bara dheeraas jiraattee awwaalamta. ");
INSERT INTO gaz_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Sanyiin kee dhaloota afuraffaatti as deebiʼa; cubbuun Amoorotaa amma iyyuu hin guunneetii.” ");
INSERT INTO gaz_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Yommuu aduun lixxee dukkanaaʼettis kunoo barbadaan ibiddaa aaru guca tokko wajjin mulʼatee foon kukkutame sana gidduu darbe. ");
INSERT INTO gaz_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Gaafa sanas Waaqayyo akkana jedhee Abraam wajjin kakuu gale; “Ani biyya laga Gibxii jalqabee hamma laga Efraaxiis guddichaatti jiru kana sanyii keetiif nan kenna; ");
INSERT INTO gaz_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","kunis biyya Qeenotaa, Qeneezotaa, Qadmoonotaas, ");
INSERT INTO gaz_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","kan Heetotaa, Feerzotaa, Refaayimootaa, ");
INSERT INTO gaz_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoorotaa, Kanaʼaanotaa Girgaashotaatii fi kan Yebuusotaa jechuu dha.” ");
INSERT INTO gaz_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Saaraan niitiin Abraam ijoollee isaaf hin deenye turte. Garuu isheen garbittii Aggaar jedhamtu tokko qabdi turte; Aggaaris nama biyya Gibxi turte; ");
INSERT INTO gaz_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saaraanis Abraamiin, “Kunoo Waaqayyo ijoollee na dhowwateera. Dhaqiitii garbittii koo wajjin ciisi; tarii ani karaa isheetiin ijoollee nan argadhan taʼaatii” jette. Abraamis waan Sooraan jette fudhate. ");
INSERT INTO gaz_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Erga Abraam waggaa kudhan Kanaʼaan keessa jiraatee booddee niitiin isaa Saaraan garbittii ishee Aggaar kan nama biyya Gibxi turte sana fuutee akka isheen niitii isaa taatuuf dhirsa isheetiif kennite. ");
INSERT INTO gaz_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abraamis Aggaar wajjin ciise; isheenis ni ulfoofte. Yommuu akka ulfoofte of irratti beektetti giiftii ishee tuffachuu jalqabde. ");
INSERT INTO gaz_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Saaraan immoo Abraamiin, “Miidhaa na mudate kanatti situ gaafatama. Garbittii koo anattu bobaa kee jala siif galche; amma garuu isheen akka ulfoofte of irratti beeknaan na tuffatte. Egaa Waaqayyo sii fi ana gidduutti murtii haa kennu” jette. ");
INSERT INTO gaz_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abraamis, “Garbittiin kee keessa harkuma kee jirti; waanuma feete ishee godhi” jedheen. Saaraanis akka malee ishee cunqursite; kanaafuu Aggaar fuula ishee duraa sokkite. ");
INSERT INTO gaz_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ergamaan Waaqayyoo gammoojjii keessatti, burqaa bishaanii tokko biratti Aggaarin arge; burqaan bishaanii sunis karaa Shuuritti geessu irra ture. ");
INSERT INTO gaz_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Ergamaan sunis, “Yaa Aggaar, garbittii Saaraa, ati eessaa dhufte? Eessa dhaquutti jirta?” jedhe. Isheenis, “Giiftii koo Saaraa baqachuuttin jira” jetteen. ");
INSERT INTO gaz_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Kana irratti ergamaan Waaqayyoo sun, “Gara giiftii keetiitti deebiʼi; gad of qabiitii isheef buli” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ergamaan Waaqayyoo sunis itti dabalee, “Ani sanyii kee akka malee nan baayʼisa; sababii baayʼina isaatiifis namni tokko iyyuu lakkaaʼuu hin dandaʼu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ergamaan Waaqayyoo sun amma illee akkana isheen jedhe; “Kunoo ati ulfoofteerta; ilmas ni deessa. Maqaa isaas Ishmaaʼeel jedhii moggaasi; Waaqayyo dhiphachuu kee dhagaʼeeraatii. ");
INSERT INTO gaz_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Inni nama akka harree diidaa taʼa; harki isaa nama hunda irratti kaʼa; harki nama hundaas isa irratti kaʼa; obboloota isaa hundaanis jibbamaa jiraata.” ");
INSERT INTO gaz_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Isheenis maqaa Waaqayyo isheetti dubbate sanaa, “Elrooʼii” jettee waamte. Isheen, “Ani dhugumaan Isa na argu sana argeera” jetteertiitii. ");
INSERT INTO gaz_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Sababiin boolli bishaanii sun, “Beʼeer Lahaayirooʼii” jedhameefis kanuma. Innis hamma harʼaatti illee Qaadeshii fi Bereed gidduu jira. ");
INSERT INTO gaz_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aggaaris Abraamiif ilma deesse; Abraamis ilma isheen deesse sana Ishmaaʼeel jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Yeroo Aggaar Ishmaaʼeelin isaaf deessetti Abraam nama waggaa saddeettamii jaʼaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Yeroo Abraam nama waggaa sagaltamii sagalii turetti Waaqayyo isatti mulʼatee akkana jedheen; “Ani Waaqa Waan Hundumaa Dandaʼuu dha; ati fuula koo dura amanamummaan deddeebiʼi; hirʼinas hin qabaatin. ");
INSERT INTO gaz_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Ani kakuu koo anaa fi si gidduu nan dhaaba; guddaas sin baayʼisa.” ");
INSERT INTO gaz_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Abraamis adda isaatiin lafatti gombifame; Waaqnis akkana isaan jedhe; ");
INSERT INTO gaz_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","“Kunoo, kakuun ani si wajjin galu kana: ati abbaa saba baayʼee taata. ");
INSERT INTO gaz_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Ati siʼachi Abraam jedhamtee hin waamamtu; waan ani abbaa saboota baayʼee si taasiseef maqaan kee Abrahaam taʼa. ");
INSERT INTO gaz_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ani akka ati guddaa baayʼattu nan godha; akka sabni hedduun si keessaa argamu nan godha; mootonnis si keessaa ni argamu. ");
INSERT INTO gaz_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","Ani Waaqa keetii fi Waaqa sanyii kee kan si duubaan dhufuu taʼuuf jedhee kakuu koo anaa, sii fi sanyii kee kan si duubaa, dhaloota dhufuuf jiru gidduutti kakuu bara baraa godhee nan dhaaba. ");
INSERT INTO gaz_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Biyya Kanaʼaan guutuu lafa ati amma orma taatee jiraattu kana ani dhaala bara baraa godhee siʼii fi sanyiiwwan kee warra si booddeetiif nan kenna; anis Waaqa isaanii nan taʼa.” ");
INSERT INTO gaz_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Waaqni Abrahaamiin akkana jedhe; “Ati immoo kakuu koo eeguu qabda; ati, sanyiin kee warri si duubaas dhaloota isaanii keessatti kakuu koo eeguu qabdu. ");
INSERT INTO gaz_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Kakuun koo kan isin anaa fi siʼi gidduutti, sanyii kee kan siʼi duubaan dhufu gidduuttis eeguu qabdan kanaa dha; innis isin keessaa dhiirri hundinuu dhagna haa qabatu. ");
INSERT INTO gaz_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Qola keessan dhagna qabadhaa; kunis kakuu anaa fi isin gidduu jiruuf mallattoo taʼa. ");
INSERT INTO gaz_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Isin keessaa dhiirri guyyaa saddeet guute dhagna haa qabatu; dhaloota keessan hunda keessatti dhiirri mana keetti dhalate yookaan kan nama biyya ormaa irraa maallaqa keetiin bitame hundi kan sanyii kee hin taʼin dhagna haa qabatu. ");
INSERT INTO gaz_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Mana keetti dhalatanis yookaan maallaqa keetiin bitamanis isaan dhagna haa qabatan. Kakuun koo kan foon keessan irratti godhame kun kakuu bara baraa taʼa. ");
INSERT INTO gaz_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Dhiirri dhagna hin qabatin, kan qola foon isaa dhagna hin qabatin kam iyyuu saba ofii isaa keessaa balleeffama; inni kakuu koo cabseeraatii.” ");
INSERT INTO gaz_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Waaqni ammas Abrahaamiin akkana jedhe; “Ati siʼachi niitii kee Sooraadhaan, Sooraa hin jettu; maqaan ishee Saaraa taʼa. ");
INSERT INTO gaz_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ani ishee nan eebbisa; ishee irraas ilma siif nan kenna. Akka isheen haadha sabootaa taatuufis ishee nan eebbisa; mootonni sabootaas ishee keessaa argamu.” ");
INSERT INTO gaz_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Abrahaamis addaan gombifame; kolfees, “Nama waggaa dhibbaatiif ilmi ni dhalataa? Saaraanis waggaa sagaltamatti mucaa deessii?” jedhee yaade. ");
INSERT INTO gaz_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Abrahaamis Waaqaan, “Maaloo utuu Ishmaaʼeel fuula kee dura naa jiraatee!” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Waaqnis akkana jedhe; “Tole; garuu niitiin kee Saaraan ilma siif deessi; maqaa isaas Yisihaaq jedhii moggaasi. Anis kakuu koo sanyii isaa kan isa duubaan dhufuuf kakuu bara baraa godhee isa wajjin nan dhaaba. ");
INSERT INTO gaz_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Waaʼee Ishmaaʼeel immoo ani si dhagaʼeera; kunoo ani, isa nan eebbisa; akka inni baayʼatu nan godha; guddaa isa nan baayʼisa. Inni abbaa bulchitoota kudha lamaa taʼa; anis saba guddaa isa nan godha. ");
INSERT INTO gaz_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Kakuu koo garuu Yisihaaq isa Saaraan waggaa dhufu keessa yeroo kanatti siif deessu wajjin nan dhaaba.” ");
INSERT INTO gaz_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Waaqni erga Abrahaam wajjin haasaʼee fixatee booddee isa biraa ol baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Abrahaamis guyyuma sana ilmaan isaa Ishmaaʼeelii fi warra mana isaatti dhalatan yookaan warra maallaqa isaatiin bitaman hunda, dhiira mana isaa hundumaas fuudhee akkuma Waaqni isatti himetti dhagna qabe. ");
INSERT INTO gaz_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahaam yeroo dhagna qabatetti nama waggaa sagaltamii sagalii ture. ");
INSERT INTO gaz_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ilmi isaa Ishmaaʼeel immoo yeroo dhagna qabatetti nama waggaa kudha sadii ture. ");
INSERT INTO gaz_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahaamii fi ilmi isaa Ishmaaʼeel guyyuma sana dhagna qabatan. ");
INSERT INTO gaz_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Dhiirri mana Abrahaam hundinuu, warri mana isaatti dhalatan yookaan warri orma irraa maallaqaan bitamanis isa wajjin dhagna qabatan. ");
INSERT INTO gaz_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Utuma Abrahaam guyyaa saafaadhaan qilxuu Mamree bira balbala dunkaana isaa dura taaʼee jiruu Waaqayyo isatti mulʼate. ");
INSERT INTO gaz_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Abrahaamis ol ilaalee namoota isa bira dhadhaabatan sadii arge. Innis akkuma isaan argeen balbala dunkaana isaa duraa kaʼee isaan simachuudhaaf itti fiige; hamma lafa gaʼuttis gad jedhee harka fuudhe. ");
INSERT INTO gaz_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","Innis akkana jedheen; “Gooftaa ko, yoo ani si duratti fudhatama argadhe, garbicha kee bira hin darbin. ");
INSERT INTO gaz_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Bishaan xinnoo isiniif haa fidan; miilla dhiqadhaatii muka kana jala boqodhaa. ");
INSERT INTO gaz_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Erga isin gara garbicha keessanii dhuftanii, ani akka isin dadhabbii baatanii karaa keessan itti fuftaniif waan isin nyaattan isiniifin kenna.” Isaanis, “Akkuma jette sana godhi” jedhanii deebisan. ");
INSERT INTO gaz_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Kanaafuu Abrahaam dafee Saaraatti dunkaana seenee, “Dafii daakuu bullaaʼaa safartuu sadii sukkuumiitii maxinoo tolchi” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Innis gara saawwaniitti fiigee jabbii gabbatee itti tole tokko filatee hojjetaa tokkotti kenne; hojjetaan sunis qopheessuuf ariifate. ");
INSERT INTO gaz_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Abrahaamis itittuu fi aannan, foon jabbii qopheeffame sanas geessee isaanii dhiʼeesse; yeroo isaan nyaachaa turanittis Abrahaam muka tokko jala isaan bira dhaabachaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Isaanis, “Niitiin kee Saaraan eessa jirti?” jedhanii isa gaafatan. Innis, “Kuunnoo dunkaana keessa jirti” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Isaan keessaa tokko, “Ani dhugumaan bara dhufu keessa yeroo akkanaatti deebiʼee gara kee nan dhufa; niitiin kee Saaraanis ilma ni deessi” jedhe. Yeroo sana Saaraan balbala dunkaanaa kan isa duubaan jiru keessaan dhaggeeffachaa turte. ");
INSERT INTO gaz_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahaamii fi Saaraan umuriin isaanii dheeratee dulloomanii turan; Saaraanis umurii itti mucaa daʼuu dandeessu dabartee turte. ");
INSERT INTO gaz_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Kanaafuu Saaraan, “Ani erga jaaree bututee, gooftaan koos erga dulloomee booddee, gammachuu kana qabaachuu nan dandaʼaa?” jettee of keessatti kolfite. ");
INSERT INTO gaz_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Kana irratti Waaqayyo Abrahaamiin akkana jedhe; “Saaraan maaliif, ‘Ani ergan dulloomee booddee amma dhugumaan mucaa nan daʼaa?’ jettee kolfite? ");
INSERT INTO gaz_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Wanni Waaqayyoof hin dandaʼamne tokko iyyuu jiraa? Ani bara dhufu keessa yeroo murteeffametti deebiʼee gara kee nan dhufa; Saaraanis ilma ni deessi.” ");
INSERT INTO gaz_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saaraanis waan sodaatteef sobdee, “Ani hin kolfine” jette. Inni garuu, “Lakkii kolfiteertaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Namoonni sun yommuu deemuuf kaʼanitti gara Sodoom gad ilaalan; Abrahaamis isaan geggeessuuf jedhee isaan wajjin baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Ergasii Waaqayyo akkana jedhe; “Ani waanan gochuuf jiru Abrahaamin nan dhoksaa? ");
INSERT INTO gaz_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahaam dhugumaan saba guddaa fi jabaa taʼa; sabni lafa irraa hundinuu karaa isaatiin eebbifama. ");
INSERT INTO gaz_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Akka inni ijoollee isaatii fi sanyii isaa warra isa duubaan dhufan, akka isaan waan qajeelaa fi sirrii taʼe hojjechuudhaan karaa Waaqayyoo eegan ajajuuf ani isa filadheeraatii; kunis akka Waaqayyo waan Abrahaamiif kakate sana isaaf guutuuf.” ");
INSERT INTO gaz_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Waaqayyos akkana jedhe; “Iyyi Sodoomii fi Gomoraa irratti iyyame guddaa dha; cubbuun isaaniis waan akka malee hamaa taʼeef ");
INSERT INTO gaz_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","ani gad buʼee akka wanni isaan hojjetan akkuma iyya na qaqqabe sanaa hamaa taʼe nan ilaala. Yoo akkas taʼuu baate immoo natu beeka.” ");
INSERT INTO gaz_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Namoonni sunis garagalanii Sodoomitti qajeelan; Abrahaam garuu Waaqayyo dura dhaabatee hafe. ");
INSERT INTO gaz_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Abrahaamis isatti dhiʼaatee akkana jedhe; “Ati nama qajeelaa nama jalʼaa wajjin ni balleessitaa? ");
INSERT INTO gaz_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Yoo namoonni qajeeloon shantamni magaalattii keessa jiraatan hoo? Ati dhugumaan ishee ni balleessitaa? Sababii qajeelota shantamman ishee keessa jiraatan sanaatiif jettee ishee hin oolchituu? ");
INSERT INTO gaz_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Qajeelaa fi hamaa wal qixxee ilaaluudhaan nama qajeelaa nama hamaa wajjin balleessuun sirraa haa fagaatu. Kun sirraa haa fagaatu! Abbaan murtii lafa hundaa waan qajeelaa hin hojjetuu?” ");
INSERT INTO gaz_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Waaqayyos, “Ani yoo magaalaa Sodoom keessatti qajeeltota shantama argadhe, isaaniif jedhee iddoo sana guutuu nan oolcha” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahaam ammas akkana jedhe; “Kunoo ani utuman awwaaraa fi daaraa taʼee jiruu Gooftaatti dubbachuuf ija jabaadheera; ");
INSERT INTO gaz_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","yoo baayʼinni qajeeltotaa shantama irraa shan hirʼate hoo? Ati sababii namoota shanan sanaatiif jettee magaalaa sana guutuu ni balleessitaa?” Innis, “Ani yoo nama afurtamii shan achitti argadhe ishee hin balleessu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahaam amma illee, “Yoo qajeeltonni afurtamni qofti achitti argaman hoo?” jedhee isatti dubbate. Gooftaanis, “Ani warra afurtama sanaaf jedhee nan dhiisa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Abrahaamis, “Mee nan dubbadhaatii Gooftaan, hin aarin. Yoo namoonni soddomni qofti achitti argaman hoo?” jedhe. Gooftaanis, “Ani yoon nama soddoma achitti argadhe ishee hin balleessu” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahaamis, “Kunoo amma erga ani Gooftaatti dubbachuuf ija jabaadhe, yoo namoonni digdamni qofti achitti argaman hoo?” jedhe. Gooftaanis, “Ani sababii namoota digdama sanaatiif jedhee ishee hin balleessu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Abrahaamis, “Yaa Gooftaa amma illee yeroo tokko waa sin gaafadhaatii maaloo hin aarin; yoo namni kudhan qofti achitti argame hoo?” jedhe. Gooftaan immoo, “Ani sababii namoota kurnan sanaatiif jedhee ishee hin balleessu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Waaqayyos erga Abrahaam wajjin dubbatee fixee booddee achii deeme. Abrahaam immoo iddoo ofii isaatti deebiʼe. ");
INSERT INTO gaz_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ergamoonni Waaqayyoo sun lamaan galgala sana Sodoom gaʼan; Looxis karra Sodoomii dura taaʼaa ture. Innis yeroo jara argetti, isaan simachuuf kaʼee isaanitti deeme; gad jedhees adda isaatiin lafatti gombifame. ");
INSERT INTO gaz_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","Innis, “Yaa gooftota ko, maaloo mana garbicha keessaniitti goraatii miilla dhiqadhaa bulaa; barii barraaqaan kaatanii karaa keessan itti fufuu dandeessu” jedhe. Isaan immoo, “Hin taʼu; nu waltajjii karaa irra bullaa” jedhaniin. ");
INSERT INTO gaz_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Inni garuu akka malee isaan dirqisiise; kanaafuu goranii mana isaa seenan; innis maxinoo tolchee nyaata qopheesseef; isaanis ni nyaatan. ");
INSERT INTO gaz_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Utuu isaan hin rafin namoonni kutaalee magaalaa Sodoom hunda keessaa dhufan hundi dargaggoonnii fi jaarsoliin mana sana marsan. ");
INSERT INTO gaz_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Isaanis Looxin waamanii, “Namoonni galgala kana gara kee dhufan eessa jiru? Akka nu isaan wajjin ciifnuuf gad nuu yaasi” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Looxis jara sanatti gad baʼee balbala of duubaan cufe; ");
INSERT INTO gaz_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","Akkanas jedhe; “Yaa obboloota ko, waan hamaa kana hin hojjetinaa! ");
INSERT INTO gaz_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kunoo ani intallan lama kanneen takkumaa dhiira wajjin hin ciisin qaba. Lamaanuu gad isinii nan baasa; isinis waan feetan isaan gochuu dandeessu. Namoota kanneen garuu waan isaan bantii mana koo jala jiraniif homaa isaan hin godhinaa.” ");
INSERT INTO gaz_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Isaanis, “Badi asii!” jedhaniin. Ittuma fufaniis, “Namichi kun nama ormaa kan nu keessa jiraachuu dhufee dha; amma immoo abbaa murtii nutti taʼuu fedha! Nu waan hamaa jara irratti hojjennu caalaa sirratti hojjenna” jedhaniin. Isaanis Looxin humnaan dhiibanii balbala sana cabsuu gaʼan. ");
INSERT INTO gaz_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Namoonni sunis hiixatanii Looxin harkisanii manatti ol deebisan; balbalichas ni cufan. ");
INSERT INTO gaz_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Ergasii immoo namoota balbala manaa dura turan sana akka isaan balbalicha hin argineef xinnaa fi guddaa isaanii dhaʼichaan ija jaamsan. ");
INSERT INTO gaz_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Namoonni lamaan sun Looxiin akkana jedhan; “Ati nama biraa tokko illee jechuunis soddoota, ilmaan yookaan intallan yookaan nama kan kee taʼe tokko illee magaalaa kana keessaa qabdaa? Asi keessa isaan baafadhu; ");
INSERT INTO gaz_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","nu iddoo kana balleessuuf deemnaatii. Sababii iyyi saba ishee irratti iyyame fuula Waaqayyoo duratti guddaa taʼeef, Waaqni akka nu ishee balleessinuuf nu ergeera.” ");
INSERT INTO gaz_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Kanaafuu Loox gad baʼee soddoota isaa warra intallan isaa fuudhuuf jiraniin, “Sababii Waaqayyo magaalaa kana balleessuuf kaʼeef, dafaatii asii baʼaa!” jedhe. Soddoonni isaa garuu waan inni qoosu seʼan. ");
INSERT INTO gaz_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Yeroo boruun diimatetti ergamoonni Waaqayyoo sun Looxin jarjarsanii, “Niitii keetii fi intallan kee lamaan as jiran fudhadhuutii dafii baʼi! Yoo kanaa achii yeroo magaalattiin adabamtutti atis ni baddaa” jedhaniin. ");
INSERT INTO gaz_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Inni garuu duubatti harkifate; waan Waaqayyo isaaniif garaa laafeef namoonni sun harka isaatii fi harka niitii isaa, intallan isaa lamaanis harka qabanii magaalattii keessaa isaan baasan. ");
INSERT INTO gaz_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Akkuma gad isaan baasaniinis ergamoota sana keessaa inni tokko, “Lubbuu kee oolfachuuf baqadhu! Of duuba hin milʼatin! Dirree irra iddoo tokko illee hin dhaabatin! Tulluuwwanitti ol baqadhu; yoo kanaa achii ni baddaa!” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loox garuu akkana isaaniin jedhe; “Yaa gooftota ko, maaloo akkas miti! ");
INSERT INTO gaz_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","Kunoo garbichi kee fuula kee duratti fudhatama argateera; ati lubbuu koo oolchitee gara laafina guddaa na argisiifteerta. Ani garuu gara tulluutti ol baqachuu hin dandaʼu; balaan kun na argata; anis nan duʼa. ");
INSERT INTO gaz_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kunoo, magaalaan itti baqachuun dandaʼamu tokko as dhiʼoo jirti; isheen xinnoo dha. Ani gara isheetti nan baqadha; isheen baayʼee xinnoo dha mitii? Akkasitti lubbuun koo ni baraaramti.” ");
INSERT INTO gaz_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ergamaan sunis akkana jedheen; “Kunoo, ani kadhaa kana siif nan dhagaʼa; magaalaa ati waaʼee ishee dubbattu kana ani hin balleessu. ");
INSERT INTO gaz_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Garuu sababii ani hamma ati achi geessutti homaa gochuu hin dandeenyeef dafii achitti baqadhu!” Wanni magaalaan sun Zoʼaar jedhamteefis kanuma. ");
INSERT INTO gaz_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Yeroo Loox Zoʼaar gaʼetti aduun baatee turte. ");
INSERT INTO gaz_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Waaqayyo samiiwwan keessaa Waaqayyo biraa, dinyii bobaʼu Sodoomii fi Gomoraa irratti roobse. ");
INSERT INTO gaz_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Innis akkasiin magaalaawwan kanneenii fi dirreewwan sana guutuu, warra magaalaawwan sana keessa jiraatan hundaa fi biqiltuu biyya sanaa balleesse. ");
INSERT INTO gaz_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Niitiin Looxi garuu of duuba ilaaltee utubaa soogiddaa taatee hafte. ");
INSERT INTO gaz_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abrahaamis guyyaa itti aanu ganama obboroon kaʼee iddoo duraan fuula Waaqayyoo dura dhaabachaa ture sanatti deebiʼe. ");
INSERT INTO gaz_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Innis gara magaalaawwan Sodoomii fi Gomoraa, gara lafa dirree sanaa hundaas ilaalee aara akka aara boolla ibiddaa keessaa baʼuu tokko isaa biyya sana keessaa ol kaʼu arge. ");
INSERT INTO gaz_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Waaqni yeroo magaalaawwan dirree sanaa balleessetti Abrahaamin yaadate; kanaafuu yommuu magaalaawwan Loox keessa jiraachaa ture balleessetti Looxin balaa sana keessaa baase. ");
INSERT INTO gaz_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loox waan Zoʼaar keessa jiraachuu sodaateef intallan isaa lamaan wajjin Zoʼaarii baʼee gaarran irra qubate. Innis intallan isaa lamaan wajjin holqa tokko keessa jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Gaaf tokko intalli isaa isheen hangafti ishee quxisuudhaan akkana jette; “Abbaan keenya dulloomeera; akka bartee lafa hunda irra jiruutti dhiirri nu wajjin ciisu tokko iyyuu naannoo kan hin jiru. ");
INSERT INTO gaz_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Kottu mee abbaa keenya daadhii wayinii obaasnee isa wajjin ciifnaa; akkasiin sanyiin abbaa keenyaa lafa irratti akka hafu goona.” ");
INSERT INTO gaz_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Isaanis halkan sana abbaa isaanii daadhii wayinii obaasan; intalli isheen hangafti ol seentee isa wajjin ciifte. Inni yeroo isheen ciiste yookaan yeroo isheen kaate hin beekne. ");
INSERT INTO gaz_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Guyyaa itti aanutti intalli hangafti ishee quxisuudhaan akkana jette; “Kunoo ani eda abbaa koo wajjin ciiseera. Kottu edanas daadhii wayinii isa obaasnaa; atis ol seenii isa wajjin ciisi; akkasitti sanyiin abbaa keenyaa akka hafu goona.” ");
INSERT INTO gaz_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Isaan halkan sanas abbaa isaanii daadhii wayinii obaasan; intalli quxisuun dhaqxee isa wajjin ciiste. Inni ammas yeroo isheen ciiste yookaan yeroo isheen kaate hin beekne. ");
INSERT INTO gaz_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Akkasiin intallan Loox lamaanuu abbaa isaaniitiif ulfaaʼan. ");
INSERT INTO gaz_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Intalli isheen hangafti ilma deessee maqaa isaa Moʼaab jettee moggaafte. Inni abbaa Moʼaabota harʼaa ti. ");
INSERT INTO gaz_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Intalli isheen quxisuunis ilma deessee maqaa isaa Ben-Amii jettee moggaafte; inni immoo abbaa Amoonota harʼaa ti. ");
INSERT INTO gaz_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahaam achii kaʼee Negeebitti godaanee Qaadeshii fi Shuuri gidduu jiraate. Innis yeroodhaaf Geraaraa keessa ture. ");
INSERT INTO gaz_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Achittis Abrahaam, “Isheen obboleettii koo ti” jedhee waaʼee niitii isaa, waaʼee Saaraa dubbate. Abiimelek mootiin Geraaraas nama itti ergee Saaraa fudhate. ");
INSERT INTO gaz_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Waaqni immoo halkan abjuudhaan Abiimelekitti dhufee, “Kunoo sababii dubartii sana fuudhatteef ati nama duʼee dha; isheen dhirsa qabdiitii” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abiimelek garuu isheetti hin dhiʼaanne ture; kanaafuu inni akkana jedhe; “Yaa Gooftaa ati saba qajeelaa balleessitaa? ");
INSERT INTO gaz_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Inni mataan isaa, ‘Isheen obboleettii koo ti’ naan hin jennee? Isheenis akkasuma, ‘Inni obboleessa koo ti’ hin jennee? Anis sammuu qulqulluu fi harka qulqulluudhaan waan kana hojjedhe.” ");
INSERT INTO gaz_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Waaqni abjuu sana keessa akkana isaan jedhe; “Eeyyee! Ani akka ati sammuu qulqulluudhaan waan kana hojjette beeka; kanaafuu ani akka ati cubbuu natti hin hojjenneef si dhowween jira. Sababiin ani akka ati ishee bira geessu si hin dhiisiniifis kanuma. ");
INSERT INTO gaz_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Egaa amma niitii namichaa deebisiif; inni waan raajii taʼeef, Waaqa siif kadhata; atis ni jiraatta. Garuu yoo ishee deebisuu baatte, ati akka duutu, warri kan kee taʼan hundis akka duʼan dhugumaan beeki.” ");
INSERT INTO gaz_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Abiimelek guyyaa itti aanu ganama obboroon kaʼee qondaaltota isaa hunda walitti waamee waan taʼe hunda isaanitti hime; isaanis akka malee sodaatan. ");
INSERT INTO gaz_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Abiimelekis Abrahaamin ofitti waamee akkana jedheen; “Ati maaliif akkana nu goote? Ani maal si goonaan ati cubbuu guddaa akkanaa anaa fi mootummaa kootti fidde? Ati waan namni hin hojjenne anatti hojjette.” ");
INSERT INTO gaz_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Abiimelekis “Ati maaliif waan kana hojjette?” jedhee Abrahaamin gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahaam immoo akkana jedhee deebise; “Ani, ‘Biyya kana keessa dhugumaan Waaqa sodaachuun hin jiru; isaan sababii niitii kootiif jedhanii na ajjeesu’ jedheen yaadee ture. ");
INSERT INTO gaz_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Taʼus isheen dhugumaan obboleettii koo ti; yoo haadha koo irraa dhalachuu baatte iyyuu isheen intaluma abbaa koo ti; isheenis niitii koo taate. ");
INSERT INTO gaz_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Anis yeroo Waaqni mana abbaa kootii na baase sana isheedhaan, ‘Haalli ati ittiin jaalala naaf qabdu mulʼiftu kanaa dha; lafa nu dhaqnu hundumaatti, “Inni obboleessa koo ti” jedhiitii waaʼee koo dubbadhun’ jedhe.” ");
INSERT INTO gaz_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Abiimelek ergasii hoolaa fi loon, garboota dhiiraa fi nadheenii fidee Abrahaamiif kenne; niitii isaa Saaraas ni deebiseef. ");
INSERT INTO gaz_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","Abiimelekis, “Kunoo biyyi koo fuula kee dura jira; idduma feete jiraadhu” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saaraadhaanis, “Kunoo ani meetii saqilii kuma tokko obboleessa keetiifin kenna. Kunis akka dhugaa qabaachuun kee fuula warra si wajjin jiranii duratti beekamuuf; ati guutumaan guutuutti dhugaa argatteerta” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Abrahaamis Waaqa kadhate; Waaqni immoo Abiimelek, niitii isaatii fi garboota isaa dubartoota fayyise; isaanis ijoollee godhatan. ");
INSERT INTO gaz_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Waaqayyo sababii niitii Abrahaam sababii Saaraatiif jedhee gadameessa dubartoota mana Abiimelek jiraatanii hunda cufee tureetii. ");
INSERT INTO gaz_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Waaqayyo akkuma dubbate sana Saaraa yaadate; Waaqayyo waan waadaa galeef sana ni raawwateef. ");
INSERT INTO gaz_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Saaraan ulfooftee bara dulluma isaa keessa yeruma Waaqni waadaa isaaf seene sanatti Abrahaamiif ilma deesse. ");
INSERT INTO gaz_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrahaamis ilma Saaraan isaaf deesse sana Yisihaaq jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Abrahaam akkuma Waaqni isa ajaje sanatti Yisihaaq dhalatee guyyaa saddeetitti dhagna isa qabe. ");
INSERT INTO gaz_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Yeroo ilmi isaa Yisihaaq dhalateefitti Abrahaam nama waggaa dhibbaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saaraanis, “Waaqni kolfa naa kenneera; namni waan kana dhagaʼu hundis na wajjin kolfa” jette. ");
INSERT INTO gaz_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Ittuma fuftees, “Silaa eenyutu Abrahaamiin, ‘Saaraan daaʼima hoosisti’ jedha ture? Garuu ani bara dulluma isaa keessa ilma nan daʼeef” jette. ");
INSERT INTO gaz_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mucichi guddatee harma guufame; Abrahaam gaafa Yisihaaq harma guufame sana cidha guddaa qopheesse. ");
INSERT INTO gaz_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Saaraan garuu yeroo ilmi Aggaar Gibxittiin Abrahaamiif deesse sun Yisihaaqitti qoosu argite; ");
INSERT INTO gaz_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","isheenis Abrahaamiin, “Garbittii kanaa fi ilma ishee ariʼi; ilmi garbittii kanaa kun ilma koo Yisihaaq wajjin hin dhaaluutii” jette. ");
INSERT INTO gaz_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Wanni kunis sababii ilma isaatiif Abrahaamin akka malee rakkise. ");
INSERT INTO gaz_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Waaqni garuu akkana jedheen; “Waaʼee garbittii keetiitii fi waaʼee mucichaa hin yaaddaʼin. Sababii sanyiin kee Yisihaaqiin siif waamamuuf waan Saaraan siin jettu hunda dhagaʼi. ");
INSERT INTO gaz_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Inni sanyii kee waan taʼeef ani ilma garbittii sanaa saba nan taasisa.” ");
INSERT INTO gaz_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abrahaamis guyyaa itti aanu ganama obboroon kaʼee nyaata muraasaa fi bishaan qalqala tokko fuudhee Aggaariif kenne. Waan kanas gatiittii ishee irra kaaʼeefii mucaa wajjin ariʼe; isheenis achii baatee Gammoojjii Bersheebaa keessa joorte. ");
INSERT INTO gaz_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Yommuu bishaan qalqala keessaa dhumetti, isheen mucaa ishee daggala tokko jala keesse. ");
INSERT INTO gaz_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","Isheenis, “Mucaa kana isaa duʼu ani hin ilaalu” jettee garaa isheetti waan yaaddeef gara darba xiyyaa tokko xinnoo achi hiiqxee naannoo isaa teesse; achi teessees sagalee ishee ol fudhattee boosse. ");
INSERT INTO gaz_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Waaqni booʼicha mucichaa ni dhagaʼe; ergamaan Waaqayyoo samii keessaa Aggaarin waamee akkana jedheen; “Yaa Aggaar ati maal taate? Hin sodaatin; Waaqni booʼicha mucichaa iddoo inni ciisee jiruu dhagaʼeeraatii. ");
INSERT INTO gaz_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Sababii ani saba guddaa isa godhuuf kaʼiitii harka keetiin mucicha ol fuudhi; jabeessiitii isa qabi.” ");
INSERT INTO gaz_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Waaqni ija ishee baneefii jennaan boolla bishaanii tokko argite. Kanaafuu dhaqxee qalqala sana bishaaniin guuttee, waan inni dhugu mucichaaf kennite. ");
INSERT INTO gaz_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Waaqnis mucicha wajjin ture; mucichis ni guddate. Innis gammoojjii keessa jiraate; xiyya darbachuudhaanis beekamaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Innis gammoojjii Phaaraan keessa jiraate; haati isaas biyya Gibxiitii niitii argatteef. ");
INSERT INTO gaz_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Yeroo sana Abiimelekii fi Fiikool ajajaan loltoota isaa Abrahaamiin akkana jedhan; “Waan ati hojjettu hunda keessatti Waaqni si wajjin jira. ");
INSERT INTO gaz_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Ati akka ana yookaan ijoollee koo yookaan sanyii koo hin gowwoomsine amma as fuula Waaqaa duratti naa kakadhu. Akkuma ani garaa siif laafe sana atis anaa fi biyya amma orma taatee keessa jiraattu kanaaf garaa laafi.” ");
INSERT INTO gaz_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahaamis, “Ani nan kakadha” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Ergasii Abrahaam waaʼee boolla bishaanii garboonni Abiimelek isa irraa fudhatan tokkoo Abiimelekitti himate. ");
INSERT INTO gaz_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abiimelek immoo, “Ani nama waan kana hojjete hin beeku. Atis natti hin himne; ani waaʼee isaa harʼuman dhagaʼe” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Kanaafuu Abrahaam hoolaa fi loon fidee Abiimelekiif kenne; jarri lamaanis walii galtee uummatan. ");
INSERT INTO gaz_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahaam gorommii hoolaa torba bushaayee keessaa kophaatti baase; ");
INSERT INTO gaz_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abiimelekis, “Hiikkaan gorommii hoolaa torban ati kophaa isaanii baafte kanneenii maali?” jedhee Abrahaamin gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahaamis, “Akka ani boolla bishaanii kana qotadhe akka ragaa taʼuuf, gorommii hoolaa torban kanneen na harkaa fudhadhu” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Sababii jarri lamaan sun achitti walii kakataniif iddoon sun Bersheebaa jedhamee waamame. ");
INSERT INTO gaz_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Erga walii galteen sun Bersheebaatti taʼee booddee Abiimelekii fi Fiikool ajajaan loltoota isaa gara biyya Filisxeemotaatti deebiʼan. ");
INSERT INTO gaz_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Abrahaamis Bersheebaa keessa muka tamirii dhaabe; innis achitti maqaa Waaqayyo Waaqa Bara Baraa waammate. ");
INSERT INTO gaz_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahaam biyya Filisxeemotaa keessa bara dheeraa jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Yeroo muraasa booddee Waaqni Abrahaamin qore. Innis, “Abrahaam!” jedhee isa waame. Abrahaamis, “Kunoo asan jira” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Waaqnis akkana jedheen; “Ilma kee Yisihaaq, ilma kee tokkicha isa jaallattu sana fudhiitii biyya Mooriyaa dhaqi. Tulluu ani sitti himu irratti qalma gubamu godhiitii isa dhiʼeessi.” ");
INSERT INTO gaz_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Abrahaamis guyyaa itti aanu ganama barraaqaan kaʼee harree isaa feʼate. Innis hojjettoota isaa keessaa nama lamaa fi ilma isaa Yisihaaqin fudhatee qoraan qalma gubamuuf gaʼu cabsatee gara iddoo Waaqni isatti hime sanaatti qajeele. ");
INSERT INTO gaz_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Guyyaa sadaffaattis Abrahaam ol ilaalee iddoo sana fagootti arge. ");
INSERT INTO gaz_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Innis hojjettoota isaatiin, “Isin harree wajjin asuma turaa. Anii fi mucichi duuba sana dhaqnaa; achittis waaqeffannee gara keessanitti deebinaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahaamis qoraan aarsaa gubamuuf taʼu fuudhee ilma isaa Yisihaaqin baachise; ofii isaatii immoo ibiddaa fi billaa harkatti qabate. Isaan lamaan utuu walumaan deemaa jiranuu, ");
INSERT INTO gaz_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yisihaaq, “Yaa abbaa koo” jedhee abbaa isaa Abrahaamitti dubbate. Abrahaamis, “Asan jira ilma koo” jedhee deebise. Yisihaaqis deebisee, “Ibiddii fi qoraan kunoo ti; hoolaan qalma gubamuuf taʼu immoo eessa jira?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahaamis deebisee, “Yaa ilma ko, Waaqni mataan isaa hoolaa qalma gubamuuf taʼu ni kenna” jedhe. Isaan lamaanis walumaan karaa isaanii itti fufan. ");
INSERT INTO gaz_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Yeroo iddoo Waaqni isatti hime sana gaʼanitti, Abrahaam iddoo aarsaa achitti ijaaree iddoo aarsaa sana irra qoraan naqe; ilma isaa Yisihaaqin hidhees iddoo aarsaa sana irra qoraan gubbaa ciibse. ");
INSERT INTO gaz_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Ergasii inni ilma isaa qaluuf jedhee harka isaa hiixatee billaa fudhate. ");
INSERT INTO gaz_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ergamaan Waaqayyoo garuu, “Abrahaam! Abrahaam!” jedhee samii keessaa isa waame. Abrahaamis, “Kunoo asan jira” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Innis, “Ati harka keetiin gurbicha hin tuqin; waan tokko illee isa hin godhin. Waan ati ilma kee, ilmuma tokkicha anaaf jettee hin mararfatiniif, ani akka ati Waaqa sodaattu amma beekeera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahaamis ol ilaalee kunoo korbeessa hoolaa kan gaanfi isaa daggala keessatti qabamee jiru tokko arge; innis dhaqee hoolaa sana fuudhee qooda ilma isaa qalma gubamu godhee dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Kanaafuu Abrahaam iddoo sana “Waaqayyo ni kenna” jedhee moggaase; hamma harʼaatti illee, “Tulluu Waaqayyoo irratti, ni kennama” jedhama. ");
INSERT INTO gaz_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ergamaan Waaqayyoo sunis samii keessaa lammata Abrahaamin waamee ");
INSERT INTO gaz_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","akkana jedheen; “Waaqayyo akkana jedha; sababii ati waan kana gootee fi ilma kee, ilmuma kee tokkicha illee na hin dhowwatiniif ani maqaa kootiin nan kakadha; ");
INSERT INTO gaz_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ani dhugumaan eebba, sin eebbisa; sanyii kees akkuma urjii samiitii fi akkuma cirracha qarqara galaanaa nan baayʼisa. Sanyiiwwan kees magaalaawwan diina isaanii ni dhuunfatu. ");
INSERT INTO gaz_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Waan ati naa ajajamteef sabni lafa irraa hundinuu karaa sanyii keetiin eebbifama.” ");
INSERT INTO gaz_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Ergasii Abrahaam tajaajiltoota isaatti deebiʼe; isaanis walumaan Bersheebaatti qajeelan; Abrahaamis Bersheebaa keessa jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Yeroo muraasa booddee akkana jedhamee Abrahaamitti himame; “Kunoo, Miilkaan obboleessa kee Naahooriif ilmaan deesseerti; ");
INSERT INTO gaz_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","ilmaan isheen deesses inni hangafni Uuzi, obboleessi isaa Buuz, abbaan Arraam immoo Qamuʼeel, ");
INSERT INTO gaz_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Keseedi, Hazoo, Fiildaas, Yiidlaafii fi Betuuʼeel jedhamu.” ");
INSERT INTO gaz_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Betuuʼeel Ribqaa dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Naahor saajjatoo Reʼuumaa jedhamtu tokko qaba ture; isheen ilmaan Xebaa, Gaham, Tahaashii fi Maʼakaa jedhaman deesseef. ");
INSERT INTO gaz_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saaraan waggaa dhibba tokkoo fi digdamii torba jiraatte; barri jireenya Saaraas kanuma ture. ");
INSERT INTO gaz_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Isheenis Kiriyaati Arbaaq jechuunis Kebroon biyya Kanaʼaan keessaa sanatti duute; Abrahaamis Saaraadhaaf gadduu fi booʼuudhaaf jedhee dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abrahaam reeffa niitii isaa biraa kaʼee Heetotaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","“Ani gidduu keessanitti ormaa fi keessummaa dha. Akka ani duʼaa koo itti awwaalladhuuf lafa awwaalaaf taʼu natti gurguraa.” ");
INSERT INTO gaz_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Heetonnis akkana jedhanii Abrahaamii fi deebii kennan; ");
INSERT INTO gaz_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","“Gooftaa, nu dhagaʼi. Ati nu gidduutti shuumii jabaa dha. Duʼaa kee iddoo awwaala keenyaa keessaa kan akka malee filatamaa taʼetti awwaalladhu. Nu keessaa namni iddoo awwaala isaatti duʼaa kee awwaallachuu si dhowwatu tokko iyyuu hin jiru.” ");
INSERT INTO gaz_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Abrahaamis ol kaʼee fuula namoota biyya sanaa fuula Heetotaa duratti gad jedhee harka fuudhe. ");
INSERT INTO gaz_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","Akkanas isaaniin jedhe; “Ani duʼaa koo akkan awwaalladhu fedhii yoo qabaattan na dhagaʼaatii Efroon ilma Zoohar sana naa kadhadhaa. ");
INSERT INTO gaz_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","Innis holqa Makfelaa jedhamu kan qarqara lafa qotiisaa isaatti argamu sana natti ni gurgura. Inni iddoo awwaalaa sana gatii guutuudhaan fuula keessan duratti akka natti gurguruuf naa gaafadhaa.” ");
INSERT INTO gaz_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efroon Heetichi saba isaa gidduu taaʼaa ture; innis utuma Heetonni gara karra magaalaa isaa dhufan sun hundi dhagaʼanuu akkana jedhee Abrahaamiif deebii kenne; ");
INSERT INTO gaz_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","“Gooftaa ko, akkana miti; mee na dhaggeeffadhu; ani lafa qotiisaa kana siif nan kenna; holqa achi jirus siif nan kenna; ani fuula saba koo duratti holqa kana siifin kenna; duʼaa kee itti awwaalladhu.” ");
INSERT INTO gaz_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahaam amma illee fuula saba biyya sanaa duratti gad jedhee harka fuudhee, ");
INSERT INTO gaz_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","utuma isaan dhagaʼanuu Efrooniin, “Yoo fedhii kee taʼe, na dhagaʼi. Ani gatii lafa qotiisaa kanaa nan kaffala. Akka ani duʼaa koo achitti awwaalladhuuf gatii kana na harkaa fudhadhu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efroonis akkana jedhee Abrahaamiif deebii kenne; ");
INSERT INTO gaz_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","“Gooftaa ko, mee na dhagaʼi; gatiin lafa kanaa meetii saqilii dhibba afur taʼa; garuu kun anaa fi si gidduutti maali? Duʼaa kee itti awwaalladhu.” ");
INSERT INTO gaz_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahaamis waan Efroon dubbate sana fudhatee gatii inni utuma Heetonni dhagaʼanuu himate sana madaaleef; gatiin sunis akka madaalii daldaltoota yeroo sanaatti meetii saqilii dhibba afur ture. ");
INSERT INTO gaz_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Akkasitti lafti qotiisaa Efroon kan fuula Mamree dura, Makfelaa keessa jiru sun jechuunis lafti qotiisaatii fi holqi isa keessa jiru, mukni daangaa lafa qotiisaa sana keessa jiru hundi, ");
INSERT INTO gaz_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","fuula Heetota gara karra magaalaa dhufan hundaa duratti akka dhaalaatti Abrahaamitti dabarfame. ");
INSERT INTO gaz_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Ergasii Abrahaam biyya Kanaʼaan keessa, holqa Makfelaa kan Mamree bira jechuunis Kebroon bira jiru sanatti niitii isaa Saaraa Awwaallate. ");
INSERT INTO gaz_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Akkasitti lafa qotiisaa sunii fi holqi achi keessaa akka lafa awwaalaa taʼuuf Heetota irraa akka dhaalaatti Abrahaamitti dabarfame. ");
INSERT INTO gaz_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Yeroo sana Abrahaam dulloomee, umuriin isaa akka malee dheeratee ture; Waaqayyos waan hundumaan isa eebbise. ");
INSERT INTO gaz_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Innis tajaajilaa mana isaa hangafa kan waan inni qabu hunda irratti itti gaafatamaa taʼeen akkana jedhe; “Mee harka kee gudeeda koo jala kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ani akka ati intallan warra Kanaʼaan kanneen ani gidduu isaanii jiraadhuu keessaa ilma kootiif niitii hin fidneef Waaqayyo Waaqa samiitii fi Waaqa lafaatiin kakattu nan barbaada; ");
INSERT INTO gaz_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","garuu gara biyya kootii fi gara firoota koo dhaqiitii ilma koo Yisihaaqiif niitii barbaadi.” ");
INSERT INTO gaz_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Tajaajilaan sun immoo, “Yoo dubartiin sun na wajjin gara biyya kanaa dhufuuf fedhii qabaachuu baatte hoo? Ani ilma kee gara biyya ati keessaa dhufte sanaatti deebisee geessuun qabaa?” jedhee isa gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahaamis akkana isaan jedhe; “Ati akka ilma koo deebiftee biyya sanatti hin geessine of eeggadhu. ");
INSERT INTO gaz_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Waaqayyo Waaqni samii inni mana abbaa kootii fi biyya ani itti dhaladhe keessaa na fidee, ‘Ani biyya kana sanyii keetiif nan kenna’ jechuudhaan natti dubbatee kakatee waadaa naa seene sun akka ati achii ilma kootiif niitii fidduuf ergamaa isaa fuula kee dura ni erga. ");
INSERT INTO gaz_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Yoo dubartiin sun si wajjin dhufuuf fedhii qabaachuu baatte immoo ati kakuu koo kana irraa bilisa taata. Ilma koo garuu gonkumaa achi hin deebisin.” ");
INSERT INTO gaz_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Kanaafuu tajaajilaan sun harka isaa gudeeda gooftaa isaa Abrahaam jala kaaʼee waaʼee waan kanaa kakateef. ");
INSERT INTO gaz_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Tajaajilaan sunis gaala gooftaa isaa keessaa kudhan fudhatee gooftaa isaa biraa immoo kennaawwan filatamoo gosa hundaa feʼatee qajeele; innis magaalaa Naahoor ishee kaaba dhiʼa Phaadaan Arraam keessatti argamtuu dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Innis akka gaalawwan sun magaalattiin alatti boolla bishaanii cina jijilbeenfatan godhe; yeroon sun gara galgalaa yeroo itti dubartoonni bishaan waraabbachuu baʼan ture. ");
INSERT INTO gaz_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Innis akkana jedhee kadhate; “Yaa Waaqayyo Waaqa gooftaa koo Abrahaam, harʼa na milkeessiitii gooftaa koo Abrahaamiif garaa laafi. ");
INSERT INTO gaz_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kunoo, ani burqaa kana bira dhaabadheen jira; intallan warra magaalaa kanaas bishaan waraabbachuuf as baʼaa jiru. ");
INSERT INTO gaz_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Intalli ani, ‘Maaloo akka ani bishaan dhuguuf okkotee kee gad qabi’ jedheenii isheenis, ‘Dhugi; ani gaalawwan kees siifin obaasaa’ naan jettu ishee ati garbicha kee Yisihaaqiif filatte haa taatu. Anis kanaan akka ati gooftaa kootiif garaa laafte beeka.” ");
INSERT INTO gaz_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Utuu inni kadhatee hin fixatin Ribqaan okkotee ishee gatiittiitti baadhattee dhufte. Isheenis intala ilma Miilkaa kan Betuuʼeel jedhamu sanaa turte; Miilkaan immoo niitii obboleessa Abrahaam kan Naahoor jedhamu sanaa ti. ");
INSERT INTO gaz_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Intalli sunis akka malee bareedduu fi durba turte; dhiirri tokko iyyuu ishee wajjin hin ciifne. Isheenis gara burqaatti gad buutee okkotee isheetti bishaan guuttattee ol deebite. ");
INSERT INTO gaz_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Tajaajilaan sunis ishee simachuuf itti fiigee, “Maaloo okkotee kee keessaa bishaan xinnoo ishee naa kenni” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Isheenis, “Yaa gooftaa ko, dhugi” jetteenii daftee okkotee ishee harkatti gad buufattee bishaan dhugaatii kenniteef. ");
INSERT INTO gaz_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Isheenis erga bishaan isa obaaftee booddee, “Ani gaalawwan keetiifis hamma isaan dhuganii dheebuu baʼanitti nan waraaba” jette. ");
INSERT INTO gaz_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Daftees okkotee ishee keessaa bidiruutti garagalchitee ammas bishaan waraabuudhaaf gara boolla bishaaniitti fiigde; gaalawwan isaa hundaafis bishaan waraabde. ");
INSERT INTO gaz_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Namichi sunis akka Waaqayyo karaa isaaf milkeesse yookaan akka isaaf hin milkeessin baruuf jedhee calʼisee xiyyeeffatee ishee ilaalaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Erga gaalawwan bishaan dhuganii booddee namichi amartii funyaanii kan warqee kan walakkaa saqilii ulfaatuu fi bitawoo warqee kan saqilii kudhan ulfaatu lama gad baasee, ");
INSERT INTO gaz_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","“Ati intala eenyuu ti? Yoo mana abbaa keetii iddoon bulan jiraatte maaloo mee natti himi” jedhee gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Isheenis, “Ani intala Betuuʼeel; Betuuʼeel immoo ilma Miilkaan Naahooriif deessee dha” isaan jette. ");
INSERT INTO gaz_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Itti dabaltees, “Cidii fi okaa baayʼee qabna; kutaan isin bultanis jira” jetteen. ");
INSERT INTO gaz_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Namichis gad jedhee Waaqayyoof sagade; ");
INSERT INTO gaz_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","akkanas jedhe; “Waaqayyo Waaqni gooftaa koo Abrahaam kan arjummaa isaatii fi amanamummaa isaa gooftaa koo hin dhowwatin sun haa eebbifamu. Waaqayyo anas gara mana obboloota gooftaa kootti karaa irra na qajeelcheera.” ");
INSERT INTO gaz_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Intalattiinis fiigdee dhaqxee warra mana haadha ishee jiranitti waaʼee waan kanaa himte. ");
INSERT INTO gaz_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribqaan obboleessa Laabaa jedhamu tokko qabdi turte; Laabaanis fiigee namicha burqaa bishaanii bira jiru sana bira dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","Innis yommuu obboleettii isaa irratti amartii funyaanii warqeetii fi bitawoo argetti, yommuu utuu Ribqaan waan namichi sun isheedhaan jedhe dubbattuu dhagaʼetti, gara namichaatti gad baʼe; namichis burqaa bishaanii cina gaalawwan bira dhaabatee ture. ");
INSERT INTO gaz_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Namicha sanaanis, “Yaa namicha Waaqayyo eebbise, kottu; ati maaliif ala dhaabatta? Ani manicha qopheesseera; gaalawwaniifis iddoo qopheesseera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Kanaafuu namichi sun gara manaa dhaqe; Laabaanis gaalawwan irraa feʼiisa buusee cidii fi okaa kenneef; akka miilla isaanii dhiqataniif immoo namichaa fi warra isa wajjin turaniif bishaan kenne. ");
INSERT INTO gaz_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Ergasiis nyaanni dhiʼaateef; namichi sun garuu, “Ani hamman dhimma koo himadhutti hin nyaadhu” jedhe. Laabaanis, “Himadhukaa” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Innis akkana jedhe; “Ani tajaajilaa Abrahaamii ti. ");
INSERT INTO gaz_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Waaqayyo, gooftaa koo guddaa eebbiseera; innis sooromeera. Hoolotaa fi loowwan, meetii fi warqee, garboota dhiiraatii fi dubartii, gaalawwanii fi harroota isaaf kenneera. ");
INSERT INTO gaz_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Niitiin gooftaa kootii Saaraan bara dulluma ishee keessa ilma isaaf deesse; innis waan qabu hunda ilma isaatiif kenneera. ");
INSERT INTO gaz_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Gooftaan koo akkana jedhee na kakachiise; ‘Ati intallan Kanaʼaan kanneen ani biyya isaanii keessa jiraadhu keessaa ilma koof niitii hin fidin; ");
INSERT INTO gaz_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","garuu gara mana abbaa kootii fi gara gosa koo dhaqiitii ilma kootiif niitii fidi.’ ");
INSERT INTO gaz_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","“Anis, ‘Yoo dubartiin sun na wajjin dhufuuf fedhii qabaachuu baattee hoo?’ jedhee gooftaa koo nan gaafadhe. ");
INSERT INTO gaz_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","“Innis akkana naan jedhe; ‘Waaqayyo inni ani fuula isaa dura jiraadhu ergamaa isaa si wajjin ergee karaa kee siif milkeessa; atis gosa koo fi mana abbaa koo keessaa ilma kootiif niitii ni fidda. ");
INSERT INTO gaz_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ati yommuu gara gosa koo dhaqxu kakuu koo irraa bilisa taata; yoo isaan intala sana sitti kennuu didani iyyuu ati kakuu koo irraa bilisa taata.’ ");
INSERT INTO gaz_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","“Ani harʼa yommuun gara burqaa kanaa dhufetti akkanan jedhe; ‘Yaa Waaqayyo, Waaqa gooftaa koo Abrahaam yoo fedhii kee taʼe karaa ani deemu naa milkeessi. ");
INSERT INTO gaz_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Kunoo, ani burqaa kana bira dhaabadheera; yoo durbi tokko bishaan waraabbachuu dhuftee ani immoo, “Maaloo okkotee kee keessaa bishaan xinnoo ishee na obaasi” jedheenii, ");
INSERT INTO gaz_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","isheenis, “Dhugi; ani gaalawwan keetiifis nan waraaba” naan jette, isheen kan Waaqayyo ilma gooftaa kootiif file haa taatu.’ ");
INSERT INTO gaz_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","“Utuu ani garaa koo keessatti kadhadhee hin fixatin Ribqaan okkotee ishee gatiittiitti baadhattee gad dhufte. Isheenis gara burqaa sanaatti gad buutee bishaan waraabbatte; anis, ‘Maaloo bishaan na obaasi’ nan jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","“Isheenis daftee okkotee ishee gatiittii irraa gad buufattee, ‘Dhugi; ani gaalawwan kees nan obaasaa’ jette. Anis nan dhuge; isheen immoo gaalawwan obaafte. ");
INSERT INTO gaz_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","“Anis, ‘Ati intala eenyuu ti?’ jedheen ishee gaafadhe. “Ishee immoo, ‘Ani intala Betuuʼeel; Betuuʼeel immoo ilma Miilkaan Naahooriif deessee dha’ jette. “Anis funyaan isheetti amartii, harka isheetti immoo bitawoo nan kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","Anis gad jedhee Waaqayyoof nan sagade; Waaqayyo Waaqa gooftaa koo Abrahaam isa akka ani intala fira isaa ilma isaatiif geessu karaa qajeelaa irra na buuse sana nan eebbise. ");
INSERT INTO gaz_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Egaa isin yoo gooftaa kootti garaa laafummaa fi amanamummaa argisiiftan natti himaa; yoo taʼuu baate immoo akka ani gara bitaatti yookaan gara mirgaatti goru natti himaa.” ");
INSERT INTO gaz_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Laabaa fi Betuuʼeelis akkana jedhanii deebisan; “Wanni kun Waaqayyo biraa dhufe; nu waan hamaa yookaan waan tolaa sitti dubbachuu hin dandeenyu. ");
INSERT INTO gaz_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kunoo, Ribqaan fuula kee dura jirti; ishee fudhadhuu deemi; isheenis akkuma Waaqayyo dubbatetti niitii ilma gooftaa keetii haa taatu.” ");
INSERT INTO gaz_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tajaajilaan Abrahaamis yommuu waan isaan jedhan dhagaʼetti lafatti gombifamee Waaqayyoof sagade. ");
INSERT INTO gaz_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Kana booddees tajaajilaan sun faaya meetii fi warqee, uffata adda addaas baasee Ribqaadhaaf kenne; obboleessa isheetii fi haadha isheetiifis kennaa gatii guddaa baasu kenne. ");
INSERT INTO gaz_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Innii fi namoonni isa wajjin turanis nyaatanii dhuganii achuma bulan. Yommuu isaan guyyaa itti aanu ganamaan kaʼanitti tajaajilaan sun, “Akka ani gara gooftaa kootti deebiʼuuf na geggeessaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Obboleessi isheetii fi haati ishee garuu, “Intalattiin guyyuma kudhan illee nu bira haa turtu; ergasiis isheen deemuu dandeessi” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Inni garuu, “Erga Waaqayyo karaa koo naa milkeessee isin na hin tursinaa; akka ani gara gooftaa kootti deebiʼuuf na geggeessaa” isaaniin jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Isaanis, “Mee intalattii waamnee waan isheen jettu gaafanna” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Kana irratti isaan Ribqaa waamanii, “Namicha kana wajjin deemuu feetaa?” jedhanii ishee gaafatan. Isheenis, “Ani nan deema” jette. ");
INSERT INTO gaz_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Kanaafuu isaan obboleettii isaanii Ribqaa fi guddiftuu ishee, tajaajilaa Abrahaamii fi namoota isaa wajjin geggeessan. ");
INSERT INTO gaz_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Isaanis akkana jedhanii Ribqaa eebbisan; “Yaa obboleettii keenya, kumaa kumaatama taʼi; sanyiin kee karra diinota isaa haa dhaalu.” ");
INSERT INTO gaz_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Ribqaa fi tajaajiltuuwwan ishee qophaaʼanii gaalawwan isaanii yaabbatanii namicha faana buʼan; namichis Ribqaa fudhatee deeme. ");
INSERT INTO gaz_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Yeroo sana Yisihaaq boolla bishaanii Beʼeer Lahaayirooʼiitii dhufee Negeeb keessa jiraachaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Innis gaaf tokko gara galgalaa utuu bakkeetti baʼee waa yaadaa jiruu oli ilaalee kunoo gaalawwan dhufaa jiran arge. ");
INSERT INTO gaz_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribqaanis ol ilaaltee Yisihaaqin argite; gaala irraas buutee ");
INSERT INTO gaz_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","tajaajilaa sanaan, “Namichi nu simachuuf bakkee keessa as deemaa jiru sun eenyu?” jettee gaafatte. Tajaajilaan sunis, “Inni gooftaa koo ti” jedhee deebiseef. Kanaafuu haguuggii ishee fudhattee ofitti haguugde. ");
INSERT INTO gaz_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tajaajilaan sunis waan hojjete hunda Yisihaaqitti hime. ");
INSERT INTO gaz_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Yisihaaqis dunkaana haadha isaa Saaraatti ol ishee galfate; Ribqaa fuudhes. Akkasiin isheen niitii isaa taate; innis ishee jaallate; Yisihaaqis duʼa haadha isaa irraa ni jajjabaate. ");
INSERT INTO gaz_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahaamis niitii biraa kan maqaan ishee Qexuuraa jedhamu fuudhe. ");
INSERT INTO gaz_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Isheenis Zimraan, Yoqshaan, Medaan, Midiyaan, Yishbaaqii fi Shuwaa isaaf deesse. ");
INSERT INTO gaz_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yoqshaan Shebaa fi Dedaan dhalche; ilmaan Dedaan immoo Ashuurim, Letuushimotaa fi Leʼumoota turan. ");
INSERT INTO gaz_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ilmaan Midiyaan Eefaa, Eefer, Henook, Abiidaa fi Eldaaʼaa turan. Warri kunneen hundi sanyiiwwan Qexuuraa ti. ");
INSERT INTO gaz_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahaam waan qabu hundumaa Yisihaaqiif kenne. ");
INSERT INTO gaz_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ilmaan saajjatoowwan isaatiif garuu utuma lubbuun jiruu kennaa kenneefii ilma isaa Yisihaaq biraa gara biyya baʼa biiftuutti isaan erge. ");
INSERT INTO gaz_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Abrahaam waggaa dhibba tokkoo fi torbaatamii shan jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Innis umurii dheeraa fi jireenya gaarii jiraatee dulloomee hafuura dhumaa baafatee duʼe; saba isaattis dabalame. ");
INSERT INTO gaz_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ilmaan isaa Yisihaaqii fi Ishmaaʼeel lafa qotiisaa Efroon ilma Zoohar namicha gosa Heeti sanaa keessatti holqa Makfelaa kan Mamree biratti argamutti isa awwaalan. ");
INSERT INTO gaz_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Lafti qotiisaa sunis kan Abrahaam Heetota irraa bitatee dha; Abrahaamis achitti niitii isaa Saaraa biratti awwaalame. ");
INSERT INTO gaz_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Erga Abrahaam duʼee booddee Waaqni ilma isaa Yisihaaqin eebbise; Yisihaaqis Beʼeer Lahaayirooʼii bira jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Seenaan maatii Ishmaaʼeel ilma Abrahaam kan Aggaar garbittiin Saaraa intalli biyya Gibxi sun Abrahaamiif deesse sanaa kana. ");
INSERT INTO gaz_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","Maqaan ilmaan Ishmaaʼeel kan akkuma dhaloota isaaniitti tartiibaan barreeffame kana: Nabaayooti ilma Ishmaaʼeel hangafticha, Qeedaar, Adbiʼeel, Mibsaami, ");
INSERT INTO gaz_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Mishmaa, Duumaa, Maasaa, ");
INSERT INTO gaz_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadaad, Teemaa, Yexuur, Naafiishii fi Qeedmaa. ");
INSERT INTO gaz_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Jarri kunneen ilmaan Ishmaaʼeel; maqaawwan kunneenis akkuma gandootaa fi iddoo qubata isaaniitti maqaawwan bulchitoota gosoota kudha lamaanii ti. ");
INSERT INTO gaz_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishmaaʼeel waggaa dhibba tokkoo fi soddomii torba jiraate; innis hafuura dhumaa baafatee duʼe; saba isaattis dabalame. ");
INSERT INTO gaz_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Sanyiin isaa immoo daangaa Gibxi bira, karaa Asooritti geessu irra, lafa Hawiilaa jalqabee hamma Shuuriitti jiru irra jiraatan. Isaanis obboloota isaanii hundatti diina taʼanii jiraatan. ");
INSERT INTO gaz_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Seenaan maatii Yisihaaq ilma Abrahaam kana. Abrahaam Yisihaaqin dhalche; ");
INSERT INTO gaz_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Yisihaaq yeroo Ribqaa fuudhetti nama waggaa afurtamaa ture; Ribqaan kunis intala Betuuʼeel namicha Arraam kan kaaba dhiʼa Phaadaan Arraamiitii fi obboleettii Laabaa namicha Arraam sanaa ti. ");
INSERT INTO gaz_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Yisihaaq sababii niitiin isaa dhabduu turteef Waaqayyo isheef kadhate. Waaqayyos kadhannaa isaatiif deebii kennee niitiin isaa Ribqaani ulfoofte. ");
INSERT INTO gaz_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Daaʼimmanis garaa ishee keessatti wal dhiibaa turan; isheenis, “Wanni kun maaliif natti dhufe?” jette; kanaafuu Waaqayyo gaafachuu dhaqxe. ");
INSERT INTO gaz_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Waaqayyo immoo akkana jedheen; “Saboota lamatu gadameessa kee keessa jira; uummanni lamaan ati deessus gargari baʼu; sabni tokko saba kaan irra ni jabaata; inni hangafni isa quxisuu tajaajila.” ");
INSERT INTO gaz_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Yeroo daʼumsi ishee gaʼetti ilmaan lakkuutu gadameessa ishee keessa ture. ");
INSERT INTO gaz_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Mucaan jalqabatti dhalate diimaa dha; dhagni isaa guutuun uffata rifeensa qabu fakkaata ture; kanaafuu Esaawu jedhanii isa moggaasan. ");
INSERT INTO gaz_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Kana booddee obboleessi isaa koomee Esaawu harkaan qabatee gad baʼe; maqaan isaas Yaaqoob jedhame. Yeroo Ribqaan isaan deessetti, Yisihaaq nama waggaa jaatamaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ijoolleen kunis ni guddattan; Esaawu adamsaa beekamaa fi nama bakkee ooluu taʼe; Yaaqoob garuu nama calʼisaa dunkaana keessa oolu taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yisihaaq waan foon bineensa bosonaa miʼeeffateef Esaawun jaallate; Ribqaan garuu Yaaqoobin jaallatte. ");
INSERT INTO gaz_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Gaaf tokko utuu Yaaqoob ittoo qopheessaa jiruu Esaawu akka malee beelaʼee bakkeedhaa dhufe. ");
INSERT INTO gaz_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Innis Yaaqoobiin, “Ani akka malee beelaʼeeraatii, mee ittoo diimaa sana irraa xinnoo naa kenni!” jedhe. Sababiin inni Edoom jedhameefis kanuma. ");
INSERT INTO gaz_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaaqoob immoo deebisee, “Dura mirga hangafummaa keetii natti gurguri kaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaawus, “Kunoo, ani duʼuu gaʼeera; yoos mirgi hangafummaa maal na fayyada ree?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaaqoob garuu, “Duraan dursii naa kakadhu” jedheen; akkasiin inni kakatee mirga hangafummaa isaa Yaaqoobitti gurgurate. ");
INSERT INTO gaz_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Ergasiis Yaaqoob buddeenaa fi ittoo misiraa Esaawuuf kenne; innis nyaatee dhugee kaʼee achii deeme. Esaawus akkasiin mirga hangafummaa isaa tuffate. ");
INSERT INTO gaz_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Beela isa bara Abrahaam biyyichatti buʼe sana malee beelli biraa tokko ammas biyya sanatti buʼe; Yisihaaqis gara Geraaraa gara Abiimelek mooticha Filisxeem dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Waaqayyos Yisihaaqitti mulʼatee akkana jedhe; “Biyya ani akka ati keessa jiraattuuf sitti himu keessa jiraadhu malee Gibxitti gad hin buʼin. ");
INSERT INTO gaz_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Biyyuma kana jiraadhu; ani si wajjin nan taʼa; sin eebbisas; biyya kana hunda sii fi sanyii keetiif nan kennaatii. Ani kakuun abbaa kee Abrahaamiif kakadhe sana nan guuta. ");
INSERT INTO gaz_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ani akkuma urjiiwwan samii sanyii kee nan baayʼisa; biyya kana hundas isaaniif nan kenna; saboonni lafa irra jiran hundinuus karaa sanyii keetiitiin eebbifamu. ");
INSERT INTO gaz_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Kunis waan Abrahaam dubbii koo dhagaʼee fedhii koo, ajaja koo, labsii kootii fi seera koo eegeef.” ");
INSERT INTO gaz_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Yisihaaqis Geraaraa keessa jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Innis yommuu namoonni biyya sanaa waaʼee niitii isaa isa gaafatanitti waan Ribqaan bareedduu taateef, “Namoonni naannoo kanaa sababii isheetiif na ajjeesu taʼa” jedhee yaaduudhaan, “Isheen niitii koo ti” jechuu sodaatee, “Isheen obboleettii koo ti” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Erga Yisihaaq yeroo dheeraa achi jiraatee booddee, Abiimelek mootichi Filisxeemii foddaa keessaan gad ilaale; utuu Yisihaaq niitii isaa Ribqaa hooqsuu arge. ");
INSERT INTO gaz_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Abiimelekis Yisihaaqin ofitti waamee, “Isheen dhugumaan niitii kee ti! Yoos ati maaliif, ‘Isheen obboleettii koo ti’ jette ree?” jedheen. Yisihaaqis, “Waan ani sababii isheetiif lubbuu koo nan dhaba taʼa jedhee yaadeef” jedhee deebiseef. ");
INSERT INTO gaz_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abiimelek immoo, “Wanni ati nutti hojjette kun maali? Utuu namoota kanneen keessaa tokko niitii kee wajjin ciisee jiraatee silaa ati yakka nutti fiddee turte” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Kana irratti Abiimelek, “Namni namicha kana yookaan niitii isaa tuqu kam iyyuu dhugumaan ajjeefamuu qaba” jedhee nama hundaaf ajaja kenne. ");
INSERT INTO gaz_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yisihaaqis biyya sanatti midhaan facaafatee waan Waaqayyo isa eebbiseef baruma sana keessa dachaa dhibba galfate. ");
INSERT INTO gaz_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","Innis ni hore; hamma akka malee sooromuttis qabeenyi isaa ittuma fufee baayʼate. ");
INSERT INTO gaz_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Innis bushaayee, loowwanii fi hojjettoota hedduu qaba ture; Filisxeemonnis isatti hinaafan. ");
INSERT INTO gaz_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Kanaafuu Filisxeemonni boolla bishaanii hojjettoonni abbaa isaa bara Abrahaam keessa qotan hundatti biyyoo naqanii duuchan. ");
INSERT INTO gaz_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Abiimelekis Yisihaaqiin, “Ati baayʼee nu caalaa jabaatteertaatii nurraa deemi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Yisihaaq achii kaʼee sulula Geraaraa keessa qubatee achi jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yisihaaqis boollawwan bishaanii bara abbaa isaa bara Abrahaam keessa qotaman kanneen Filisxeemonni erga Abrahaam duʼee booddee duuchan sana deebisee bane; innis maquma abbaan isaa kenneefii ture sanaan isaan waame. ");
INSERT INTO gaz_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Tajaajiltoonni Yisihaaq sulula sana keessatti lafa qotanii boolla bishaan burquu argatan. ");
INSERT INTO gaz_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tiksoonni Geraaraa, “Bishaan kun kan keenya!” jedhanii tiksoota Yisihaaq wajjin wal lolan. Kanaafuu inni sababii wal falmaniif boolla bishaanii sana, “Eeseeq” jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Ergasiis boolla bishaanii biraa qotan; isaan garuu boolla bishaanii sana irrattis wal lolan; kana irratti Yisihaaq boolla bishaanii sana “Sixinaa” jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Innis achii kaʼee iddoo biraa dhaqee boolla bishaanii biraa achitti qote; namni tokko iyyuu isa irratti wal hin lolle. Innis, “Waaqayyo amma iddoo balʼaa nuu kenneera; nu biyyattii keessatti ni baayʼanna” jechuudhaan Rehooboot jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Innis achii kaʼee gara Bersheebaatti ol baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Waaqayyos halkanuma sana isatti mulʼatee akkana jedheen; “Ani Waaqa abbaa kee Abrahaam; ani waan si wajjin jiruuf hin sodaatin. Garbicha koo Abrahaamiif jedhees ani sin eebbisa; sanyii kees nan baayʼisa.” ");
INSERT INTO gaz_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Yisihaaq achitti iddoo aarsaa ijaaree maqaa Waaqayyoo waammate. Dunkaana isaas achi dhaabbate; tajaajiltoonni isaas iddoo sanatti boolla bishaanii qotatan. ");
INSERT INTO gaz_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Ergasiis Abiimelek gorsaa isaa Ahuzaatii fi ajajaa loltoota isaa Fiikool wajjin Geraaraadhaa kaʼee gara Yisihaaq dhufe. ");
INSERT INTO gaz_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yisihaaq immoo, “Isin erga na jibbitanii of biraa na ariitanii maaliif gara koo dhuftan?” isaaniin jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Isaanis akkana jedhanii deebisan; “Nu akka Waaqayyo si wajjin jiru ifaan ifatti argineerra; kanaafuu nu, ‘Kakuun walii galtee gidduu keenya jechuunis nuu fi si gidduu jiraachuu qaba’ jenne; mee kottu si wajjin walii galtee godhannaa. ");
INSERT INTO gaz_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","Kunis akkuma nu utuu waan gaarii malee waan hamaa sirraan hin gaʼin nagaan of irraa si geggeessine sana akka atis nu hin miineef. Ati amma illee nama Waaqayyo eebbisee dha.” ");
INSERT INTO gaz_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Yisihaaqis nyaata isaaniif qopheesse; isaanis ni nyaatan; ni dhuganis. ");
INSERT INTO gaz_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Namoonni sun guyyaa itti aanu ganama barraaqa kaʼanii walii kakatan. Yisihaaqis isaan geggeesse; jarris nagumaan isa biraa deeman. ");
INSERT INTO gaz_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Guyyuma sana hojjettoonni Yisihaaq dhufanii waaʼee boolla bishaanii qotan sanaa isaatti himan. Isaanis, “Nu bishaan arganneerra!” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Innis boolla bishaanii sana, “Shibeʼaa” jedhee moggaase. Hamma harʼaatti maqaan magaalaa sanaa Bersheebaa jedhama. ");
INSERT INTO gaz_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaawu yeroo umuriin isaa waggaa afurtama guuteetti Yoodiiti intala Biʼeer namicha gosa Heeti akkasumas Baasmati intala Eeloon namicha gosa Heeti fuudhe. ");
INSERT INTO gaz_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Isaanis Yisihaaqii fi Ribqaa gaddisiisan. ");
INSERT INTO gaz_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yisihaaq dulloomee yeroo iji isaa arguu dadhabetti ilma isaa hangafa Esaawun ofitti waamee, “Yaa ilma koo” jedheen. Innis, “Kunoo asan jira” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Yisihaaq akkana jedhe; “Kunoo, ani dulloomeera; guyyaa duʼa koo hin beeku. ");
INSERT INTO gaz_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Kanaafuu maaloo miʼa adamoo keetii jechuunis korojoo xiyya keetii fi iddaa kee qabadhuutii gara dirreetti baʼiitii bineensa naa adamsi. ");
INSERT INTO gaz_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Akka ani utuun hin duʼiniin dura si eebbisuuf, nyaata miʼaawaa gosa ani jaalladhu naa qopheessiitii akka ani nyaadhuuf naa dhiʼeessi.” ");
INSERT INTO gaz_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Yommuu Yisihaaq ilma isaa Esaawutti dubbatetti Ribqaan ni dhaggeeffatti turte. Yeroo Esaawu bineensa adamsee fiduuf gara dirreetti gad baʼetti, ");
INSERT INTO gaz_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribqaan ilma ishee Yaaqoobiin akkana jette; “Kunoo, ani utuu abbaan kee obboleessa kee Esaawutti dubbatuu dhagaʼeera; ");
INSERT INTO gaz_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","innis, ‘Akka ani utuun hin duʼin fuula Waaqayyoo duratti si eebbisuuf bineensa adamsii fidiitii akka ani nyaadhuuf nyaata miʼaawu naa qopheessi’ jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Egaa yaa ilma ko, akkuma ani si ajajutti dubbii koo dhagaʼi. ");
INSERT INTO gaz_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Ani akkan abbaa keetiif akkuma inni jaallatutti nyaata miʼaawaa qopheessuuf gara bushaayee dhaqiitii ilmoolee reʼee filatamoo lama naa fidi. ");
INSERT INTO gaz_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Akka inni nyaatee utuu hin duʼin si eebbisuuf abbaa keetiif nyaata dhiʼeessi.” ");
INSERT INTO gaz_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaaqoobis haadha isaa Ribqaadhaan akkana jedhe; “Kunoo, obboleessi koo Esaawu dabbasaaʼaa dha; ani garuu rifeensa hin qabu. ");
INSERT INTO gaz_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Yoo abbaan koo na qaqqabatee waan ani isa gowwoomse seʼe, ani qooda eebbaa abaarsa ofitti nan fida.” ");
INSERT INTO gaz_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Haati isaa immoo, “Yaa ilma ko, abaarsi sun naaf haa taʼu; ati waanuma ani siin jedhe godhi; dhaqiitii reʼoota sana naa fidi” jetteen. ");
INSERT INTO gaz_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Innis dhaqee ilmoolee reʼootaa sana qabee haadha isaatiif fide; isheen immoo akkuma abbaan isaa jaallatutti nyaata miʼaawu qopheessiteef. ");
INSERT INTO gaz_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Ergasiis Ribqaan uffata Esaaw ilma ishee hangaftichaa kan ishee bira ture keessaa kan hunda irra bareedu fuutee Yaaqoob ilma ishee isa quxisuu sanatti uffifte. ");
INSERT INTO gaz_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Harka isaatii fi morma isaa iddoo rifeensa hin qabnetti gogaa reʼootaa uffifte. ");
INSERT INTO gaz_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Ergasiis nyaata miʼaawaa fi buddeena qopheessitee turte sana ilma ishee Yaaqoobitti kennite. ");
INSERT INTO gaz_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Innis gara abbaa isaa dhaqee, “Yaa abbaa koo” jedhe. Innis, “Yaa ilma ko, kunoo asan jira; ati eenyu?” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaaqoobis abbaa isaatiin akkana jedhe; “Ani Esaawu ilma kee isa hangafticha; akkuma ati natti himte sana godheera; akka na eebbiftuuf mee ol jedhiitii waan ani adamsee fide nyaadhu.” ");
INSERT INTO gaz_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yisihaaq ilma isaatiin, “Yaa ilma ko, akkamitti akkana daftee argatte?” jedhe. Yaaqoob immoo, “Waaqayyo Waaqa keetu na milkoomse” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yisihaaqis Yaaqoobiin, “Akka ani si qaqqabadhee ilma koo Esaaw taʼuu fi taʼuu baachuu kee beekuuf mee as dhiʼaadhu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaaqoobis abbaa isaa Yisihaaqitti dhiʼaate; abbaan isaas isa qaqqabatee, “Sagaleen kun sagalee Yaaqoob; harki kun garuu harka Esaawu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Waan harki isaa akkuma harka Esaawu rifeensa qabuuf Yisihaaq gargar baasee isa beekuu hin dandeenye; kanaafuu isa eebbise. ");
INSERT INTO gaz_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","Innis, “Ati dhugumaan ilma koo Esaawuu?” jedhee gaafate. Inni immoo, “Eeyyee ani isuma” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yisihaaqis, “Yaa ilma ko, akka ani nyaadhee si eebbisuuf mee waan adamsitee fidde sana naa kenni” jedhe. Yaaqoob ni dhiʼeesseef; innis ni nyaate; daadhii wayiniis ni fideef; innis ni dhuge. ");
INSERT INTO gaz_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Abbaan isaa Yisihaaqis, “Yaa ilma koo as kottuu na dhungadhu” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Innis itti dhiʼaatee isa dhungate. Yisihaaqis foolii wayyaa isaa suufee isa eebbise; akkanas jedhe; “Ilaa, fooliin ilma koo, akkuma foolii lafa qotiisaa Waaqayyo eebbisee ti. ");
INSERT INTO gaz_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Waaqni fixeensa samii, lafa gabbataa, midhaanii fi wayinii akka malee baayʼatu siif haa kennu. ");
INSERT INTO gaz_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Saboonni si haa tajaajilan; uummannis siif haa sagadan. Obboloota kee irratti gooftaa taʼi; ilmaan haadha keetiis siif haa sagadan. Warri si abaaran haa abaaraman; warri si eebbisan immoo haa eebbifaman.” ");
INSERT INTO gaz_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Akkuma Yisihaaq Yaaqoobin eebbisee fixee Yaaqoob immoo fuula abbaa isaa fuula Yisihaaq duraa gad baʼeen, obboleessi isaa Esaawu adamoodhaa dhufee ol gale. ");
INSERT INTO gaz_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Innis nyaata miʼaawaa qopheessee abbaa isaatiif fide; abbaa isaatiinis, “Yaa abbaa ko, ati akka na eebbiftuuf ol jedhiitii waan ani ilmi kee adamsee fide nyaadhu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Abbaan isaa Yisihaaqis, “Ati eenyu?” jedhee isa gaafate. Innis, “Ani ilma kee Esaawu hangafticha” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yommus Yisihaaq akka malee hollachaa, “Yoos namni waa adamsee naa fide eenyu ree? Ani utuu ati hin dhufin hunduma isaa nyaadheen isa eebbise; inni dhugumaan ni eebbifama!” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esaawu yommuu waan abbaan isaa dubbate dhagaʼetti, abbaa isaatiin, “Yaa abbaa ko, anas eebbisi!” jedhee sagalee ol fudhatee hiqqifatee booʼe. ");
INSERT INTO gaz_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yisihaaq garuu, “Obboleessi kee haxxummaadhaan dhufee eebba kee fudhateera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaawus, “Maqaan isaa iyyuu dhugumaan Yaaqoob jedhama mitii? Inni kana wajjin yeroo lama na gowwoomsuu isaa ti; jalqabatti hangafummaa koo narraa fudhate; amma immoo eebba koo fudhateera” jedhe. Ergasiis inni, “Ati eebba tokko illee naa hin hambifnee ree?” jedhee gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yisihaaq immoo akkana jedhee Esaawuuf deebise; “Kunoo ani akka inni sirratti gooftaa taʼuu fi akka firoonni isaa hundi tajaajiltoota isaa taʼan godheera; akka inni midhaanii fi daadhii wayinii qabaatuufis isa eebbiseera. Egaa yaa ilma koo ani maal siif gochuun dandaʼa?” ");
INSERT INTO gaz_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaawus abbaa isaatiin, “Yaa abbaa ko, ati eebbuma tokko qofa qabdaa? Yaa abbaa ko, anas eebbisi!” jedhe. Esaawus sagalee ol fudhatee booʼe. ");
INSERT INTO gaz_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Abbaan isaa Yisihaaqis akkana jedhee deebiseef; “Iddoon jireenya keetii lafa gabbataa irraa ni fagaata; fixeensa samii gubbaa irraas ni fagaata. ");
INSERT INTO gaz_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Ati goraadeedhaan jiraatta; obboleessa kees ni tajaajilta. Yeroo isaan mormitutti garuu waanjoo isaa cabsitee morma kee irraa buufta.” ");
INSERT INTO gaz_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Esaawu sababii abbaan isaa Yaaqoobin eebbiseef Yaaqoobitti haaloo qabate. Innis garaa isaatti, “Yeroon itti abbaa kootiif booʼan dhiʼaateera; anis yeroo sana obboleessa koo Yaaqoobin nan ajjeesa” jedhee yaade. ");
INSERT INTO gaz_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Yommuu wanni Esaawu ilmi ishee hangaftichi jedhe isheetti himametti Ribqaan Yaaqoob ilma ishee quxisuu waamsiftee akkana jetteen; “Kunoo, obboleessi kee Esaawu si ajjeesee garaa isaa qabbaneeffachuu barbaada. ");
INSERT INTO gaz_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Kanaafuu yaa ilma koo na dhagaʼi; kaʼiitii gara obboleessa koo Laabaa kan Kaaraan keessa jiraatu sanaatti baqadhu. ");
INSERT INTO gaz_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Hamma aariin obboleessa keetii qabbanaaʼutti yeroo gabaabaaf isa bira turi. ");
INSERT INTO gaz_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Yommuu aariin obboleessa keetii qabbanaaʼee innis waan ati isa goote sana irraanfatutti ani dhaamsa sitti ergee achii sin fichisiisa. Ani maaliifan guyyaa tokkotti isin lachuu dhaba?” ");
INSERT INTO gaz_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Ribqaanis Yisihaaqiin akkana jette; “Ani sababii dubartoota Heetotaa kanneeniif jiraachuu jibbeera. Yoo Yaaqoob dubartoota biyya kanaa jechuunis dubartoota Heetotaa kanneen keessaa niitii fuudhe, jireenyi koo maal anaaf godha ree!” ");
INSERT INTO gaz_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yisihaaqis Yaaqoobin waamee eebbisee akkana jedhee isa ajaje: “Intallan warra Kanaʼaan keessaa hin fuudhin. ");
INSERT INTO gaz_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Ammuma kaʼiitii gara kaaba dhiʼa Phaadaan Arraam mana abbaa haadha keetii mana Betuuʼeel dhaqi. Achiis intallan obboleessa haadha keetii intallan Laabaa keessaa tokko fuudhi. ");
INSERT INTO gaz_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Waaqni Waan Hunda Dandaʼu sun si haa eebbisu; sanyii siif haa kennu; akka ati saba balʼaa taatuufis si haa baayʼisu. ");
INSERT INTO gaz_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Ati biyya amma alagummaadhaan keessa jiraattu, biyya Waaqni dhaala godhee Abrahaamiif kenne sana akka dhaaltuuf inni eebba Abrahaamiif kenne sii fi sanyii keetiif haa kennu.” ");
INSERT INTO gaz_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Yisihaaqis akkasitti Yaaqoobin erge; Yaaqoobis gara kaaba dhiʼa Phaadaan Arraam gara Laabaa ilma Betuuʼeel namicha Arraam sanaa dhaqe; Laabaan kun immoo obboleessa Ribqaa, haadha Yaaqoobii fi Esaawu. ");
INSERT INTO gaz_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Esaawu akka Yisihaaq Yaaqoobin eebbisee akka inni achii niitii fuudhuuf gara kaaba dhiʼa Phaadaan Arraamitti isa ergee fi akka isa eebbisettis “Intallan warra Kanaʼaan hin fuudhin” jedhee isa ajaje yommuu beeketti; ");
INSERT INTO gaz_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaaqoob abbaa fi haadha isaatiif ajajamee gara kaaba dhiʼa Phaadaan Arraam dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Esaawus intallan warra Kanaʼaan fuula abbaa isaa Yisihaaq duratti hammam jibbamoo akka taʼan hubate. ");
INSERT INTO gaz_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","Kanaafuu Esaaw gara Ishmaaʼeel ilma Abrahaam dhaqee Maahalaati intala Ishmaaʼeel obboleettii Nabaayoti niitota dur qabu irratti dabalee fuudhe. ");
INSERT INTO gaz_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaaqoob Bersheebaa baʼee Kaaraan dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Innis iddoo tokko gaʼee aduun dhiinaan achi bule; dhagoota achi turan keessaas tokko fudhatee mataa jala kaaʼatee rafuuf ciise. ");
INSERT INTO gaz_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Innis achitti abjuu abjoote; kunoo yaabbannoo lafa dhaabatee fiixeen isaa immoo samii gaʼu tokko arge; kunoo ergamoonni Waaqayyoo yaabbannoo sana irra ol baʼaa fi gad buʼaa turan. ");
INSERT INTO gaz_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Kunoo Waaqayyo yaabbannoo sana gara irraa dhaabatee akkana jedhe; “Ani Waaqayyo Waaqa abbaa kee Abrahaamii fi Waaqa Yisihaaq; ani lafa ati irra ciiftu kana siif fi sanyii keetiif nan kenna. ");
INSERT INTO gaz_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Sanyiin kee akkuma biyyoo lafaa ni baayʼata; atis gara dhiʼaatti, gara baʼaatti, gara kaabaattii fi kibbaatti ni babalʼatta. Uummanni lafa irraa hundinuu karaa keetii fi karaa sanyii keetiitiin ni eebbifama. ");
INSERT INTO gaz_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Kunoo ani si wajjinan jira; lafa ati dhaqxu hundattis sin eega; gara biyya kanaattis deebisee sin fida. Ani hamman waanan waadaa siif gale sana siif guututti si hin dhiisu.” ");
INSERT INTO gaz_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Yaaqoobis yommuu hirribaa kaʼetti, “Dhugumaan Waaqayyo iddoo kana jira; ani waan kana hin hubanne” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Innis sodaatee, “Iddoon kun akkam nama sodaachisa! Kun mana Waaqaa ti malee waan biraa miti; kun karra samiiti” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yaaqoobis guyyaa itti aanu ganama obboroo kaʼee dhagaa mataa jala kaaʼatee ture sana fuudhee akka utubaatti ol dhaabe; fiixee isaa irrattis zayitii dhangalaase. ");
INSERT INTO gaz_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Innis maqaa iddoo sanaa Beetʼeel jedhee moggaase; duraan garuu magaalaan sun Luuzi jedhama ture. ");
INSERT INTO gaz_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Ergasiis Yaaqoob akkana jedhee wareege; “Yoo Waaqni na wajjin taʼe, yoo inni karaa ani deemu kana irratti na eege, yoo waan ani nyaadhuu fi waan ani uffadhu naa kenne, ");
INSERT INTO gaz_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","yoo ani nagaan mana abbaa kootti deebiʼe, Waaqayyo Waaqa koo ni taʼa; ");
INSERT INTO gaz_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","dhagaan ani utubaa godhee ol dhaabe kunis mana Waaqaa taʼa; waan ati naa kennitu keessaas kudhan keessaa tokko siifin kenna.” ");
INSERT INTO gaz_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yaaqoobis karaa isaa itti fufee gara warra biyya baʼaa dhufe. ");
INSERT INTO gaz_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Innis ilaalee kunoo boolla bishaanii tokko dirree irratti arge; kunoo karri hoolotaa sadii sababii achii bishaan dhuganiif boolla bishaanii sana bira ciciisaa turan. Dhagaan afaan boolla bishaanii sanaa irra ture guddaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Yeroo karri hoolotaa hundi achitti walitti qabamanitti tiksoonni afaan boolla bishaanii irraa dhagaa gangalchanii hoolota bishaan obaasu turan. Ergasii immoo dhagaa sana iddoo isaatti deebisanii afaan boolla bishaanii irra kaaʼu turan. ");
INSERT INTO gaz_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaaqoobis tiksoota sanaan, “Yaa obboloota ko, isin warra eessaati?” jedhee gaafate. Isaanis, “Nu warra Kaaraaniiti” jedhanii deebisan. ");
INSERT INTO gaz_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Innis, “Laabaa ilma Naahoor beektuu?” jedheen. Jarris, “Eeyyee, beekna” jedhanii deebisan. ");
INSERT INTO gaz_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yaaqoob immoo, “Inni fayyumaa?” jedhee isaan gaafate. Isaanis, “Eeyyee, fayyuma; kunoo intalli isaa Raahel iyyuu hoolota fiddee dhufaa jirti” jedhaniin. ");
INSERT INTO gaz_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Innis, “Kunoo, amma lafti guyyaa dha; yeroo itti hoolonni walitti qabaman miti. Hoolota bishaan obaasaatii dhaqaa dheechisaa” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Isaanis, “Nu hamma karri hoolotaa hundinuu walitti qabamanii dhagaan sun afaan boolla bishaanii irraa gangalfamutti hin dandeenyu; ergasii hoolota bishaan obaafna” jedhanii deebisan. ");
INSERT INTO gaz_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Utuma inni jara wajjin haasaʼaa jiruu, Raahel waan tiksee turteef hoolota abbaa ishee ooftee dhufte. ");
INSERT INTO gaz_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaaqoob yommuu Raahel, intala obboleessa haadha isaa intala Laabaatii fi hoolota Laabaa argetti dhaqee dhagaa afaan boolla bishaanii irraa gangalchee hoolota eessuma isaa bishaan obaase. ");
INSERT INTO gaz_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Yaaqoobis Raaheliin dhungate; sagalee ol fudhatees booʼe. ");
INSERT INTO gaz_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Inni fira abbaa ishee akka taʼee fi ilma Ribqaa akka taʼe Raahelitti hime; isheenis fiigaa dhaqxee abbaa isheetti himte. ");
INSERT INTO gaz_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laabaan akkuma waaʼee ilma obboleettii isaa waaʼee Yaaqoob dhagaʼeen isa simachuuf ariifatee baʼe. Innis erga hammatee dhungatee booddee mana isaatti fudhatee gale; Yaaqoobis waan kana hunda Laabaatti hime. ");
INSERT INTO gaz_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laabaan immoo, “Ati dhugumaan foon kootii fi dhiiga koo ti” jedheen. Yaaqoob erga jiʼa tokko guutuu Laabaa wajjin turee booddee, ");
INSERT INTO gaz_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laabaan akkana isaan jedhe; “Ati sababii fira koo taateef tola naa hojjechuu qabdaa? Mindaan kee akka hammam taʼuu qabu natti himi.” ");
INSERT INTO gaz_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laabaan intallan lama qaba ture; maqaan ishee hangafaa Liyaa ture; maqaan ishee quxisuu immoo Raahel jedhama ture. ");
INSERT INTO gaz_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Iji Liyaa dadhabaa ture; Raahel garuu bareedduu fi simboo qabeettii turte. ");
INSERT INTO gaz_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaaqoob Raahelin jaallatee, “Ani waaʼee intala kee ishee quxisuu, Raaheliif jedhee waggaa torba sin tajaajila” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laabaan immoo, “Nama biraaf ishee kennuu irra siif kennuu naa wayya; asuma na bira turi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Kanaafuu Yaaqoob Raahelin argachuuf jedhee waggaa torba tajaajile. Inni waan ishee jaallateef waggoonni kunneen guyyoota muraasa isatti fakkaatan. ");
INSERT INTO gaz_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Yaaqoobis Laabaadhaan, “Waan yeroon koo xumurameef akka ani ishee bira gaʼuuf niitii koo naa kenni” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Kanaafuu Laabaan namoota iddoo sana jiran hunda walitti qabee cidha qopheesse. ");
INSERT INTO gaz_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Garuu yeroo lafti galgalaaʼetti intala isaa Liyaa fidee Yaaqoobiif kenne; Yaaqoobis ishee bira gaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laabaanis akka isheen hojjettuu ishee taatuuf garbittii isaa Zilfaa, intala isaa Liyaadhaaf kenne. ");
INSERT INTO gaz_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Yommuu lafti bariʼetti kunoo Liyaa taʼuun ishee beekame! Yaaqoobis Laabaadhaan, “Wanni ati na goote kun maali? Ani Raaheliif jedhee si hin tajaajillee? Yoos ati maaliif na gowwoomsite ree?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laabaanis akkana jedhee deebise; “Biyya keenya keessatti intala hangafa dura intala quxisuu heerumsiisuun duudhaa keenya miti. ");
INSERT INTO gaz_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Torban misirrummaa intala kanaa raawwadhu; ergasii yoo ati waggaa biraa torba naaf hojjette quxisuu ishees siif kennina.” ");
INSERT INTO gaz_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaaqoobis akkasuma godhe. Torban sanas Liyaa wajjin dabarse; ergasiis Laabaan intala isaa Raahelin isatti heerumsiise. ");
INSERT INTO gaz_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laabaan akka isheen hojjettuu ishee taatuuf xomboree isaa Bilihaa, intala isaa Raaheliif kenne. ");
INSERT INTO gaz_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaaqoobis Raahel bira gaʼe; innis Liyaa caalaatti Raahelin jaallate. Waggoota biraa torbas Laabaaf hojjete. ");
INSERT INTO gaz_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Waaqayyo yommuu akka Liyaan hin jaallatamin argetti gadameessa ishee baneef; Raahel garuu dhabduu turte. ");
INSERT INTO gaz_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liyaan ulfooftee ilma deesse. Isheenis waan, “Waaqayyo dhiphina koo argeeraatii dhugumaan siʼachi dhirsi koo na jaallata” jetteef maqaa isaa Ruubeen jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Isheen ammas yommuu ulfooftee ilma deessetti, “Waaqayyo sababii akka ani hin jaallatamin dhagaʼeef ilma kanas naa kenne” jettee maqaa isaa Simiʼoon jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Ammas ulfooftee ilma deesse; isheenis, “Sababii ani ilmaan sadii isaaf daʼeef amma dhirsi koo natti maxxana” jette; kanaafuu mucaan sun Lewwii jedhamee moggaafame. ");
INSERT INTO gaz_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Ammas isheen ulfooftee ilma deesse; isheenis, “Amma Waaqayyo nan galateeffadha” jette. Kanaafuu maqaa isaa Yihuudaa jettee moggaafte. Ergasiis daʼuu ni dhiifte. ");
INSERT INTO gaz_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raahel yommuu akka Yaaqoobiif ijoollee tokko iyyuu hin daʼin argitetti obboleettii isheetti hinaafte. Yaaqoobiinis, “Ijoollee naa kenni, yoo kanaa achii nan duʼa!” jette. ");
INSERT INTO gaz_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaaqoobis isheetti aaree, “Anatu iddoo Waaqa isa ijoollee si dhowwate sanaa jira moo?” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Isheenis, “Xomboreen koo Bilihaan kunoo ti; akka isheen qooda koo ijoollee naaf deessee anis karaa isheetiin ijoollee argadhuuf dhaqii ishee bira gaʼi” jette. ");
INSERT INTO gaz_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Isheenis xomboree ishee Bilihaa akka niitii isaa taatuuf kenniteef. Yaaqoobis ishee bira gaʼe; ");
INSERT INTO gaz_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","isheenis ulfooftee ilma isaaf deesse. ");
INSERT INTO gaz_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Kana irratti Raahel, “Waaqni naa murteesseera; kadhannaa koos dhagaʼee ilma naa kenneera” jette. Kanaafuu maqaa isaa Daan jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Xomboreen Raahel Bilihaan ammas ulfooftee Yaaqoobiif ilma lammaffaa deesse. ");
INSERT INTO gaz_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Raahelis, “Ani obboleettii koo walʼaansoo guddaa qabee moʼadheera” jette. Maqaa isaa Niftaalem jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liyaan akka ijoollee daʼuu dhiifte hubatte; xomboree ishee Zilfaa fuutee akka niitii isaa taatuuf Yaaqoobiif kennite. ");
INSERT INTO gaz_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Xomboreen Liyaa Zilfaanis Yaaqoobiif ilma deesse. ");
INSERT INTO gaz_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liyaan immoo, “Maal milkiin akkanaa!” jettee maqaa isaa Gaad jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Xomboreen Liyaa Zilfaan Yaaqoobiif ilma lammaffaa deesse. ");
INSERT INTO gaz_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Ergasiis Liyaan, “Ani akkaman gammade! Dubartoonnis, ‘Eebbifamtuu’ naan jedhu” jette. Kanaafuu maqaa isaa Aasheer jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Yeroo haamaa qamadiitti Ruubeen gara bakkeetti baʼee ija hudhaa argatee haadha isaa Liyaadhaaf fide. Raahelis Liyaadhaan, “Maaloo ija hudhaa ilma keetii irraa waa naa kenni” jette. ");
INSERT INTO gaz_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Liyaan immoo, “Dhirsa koo narraa fudhachuun kee sitti xinnaatee? Hudhaa ilma koos ni fudhattaa?” jetteen. Raahelis, “Qooda hudhaa ilma keetii inni edana si wajjin haa bulu” jetteen. ");
INSERT INTO gaz_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Gaafa sana galgala yeroo Yaaqoob lafa qotiisaatii galetti Liyaan isa simachuuf gad baatee, “Waan ani hudhaa ilma kootiin si kireeffadheef ati harʼa na wajjin bulu qabda” jetteen. Yaaqoobis halkan sana ishee wajjin bule. ");
INSERT INTO gaz_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Waaqnis Liyaa dhagaʼe; isheenis ulfooftee Yaaqoobiif ilma shanaffaa deesse. ");
INSERT INTO gaz_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liyaanis, “Waan ani xomboree koo dhirsa kootiif kenneef Waaqni gatii koo naa baaseera” jette. Kanaafuu Yisaakor jettee isa moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liyaan ammas ulfooftee Yaaqoobiif ilma jaʼaffaa deesse. ");
INSERT INTO gaz_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","Liyaanis, “Waaqni kennaa gaarii naaf kenneera; sababii ani ilmaan jaʼa isaaf daʼeef dhirsi koo siʼachi ulfina naa kenna” jette. Kanaafuu maqaa isaa Zebuuloon jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Ergasiis intala tokko deessee Diinaa jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Waaqnis Raahelin yaadate; kadhannaa ishees dhagaʼee gadameessa ishee baneef. ");
INSERT INTO gaz_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Isheenis ulfooftee ilma deessee, “Waaqni qaanii koo narraa fuudheera” jette. ");
INSERT INTO gaz_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Isheenis maqaa isaa Yoosef jettee moggaaftee, “Waaqayyo ilma biraa naaf haa dabalu” jette. ");
INSERT INTO gaz_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Erga Raahel Yoosefin deessee booddee Yaaqoob Laabaadhaan akkana jedhe; “Akka ani biyya dhalootaa kootti deebiʼuuf, gad na dhiisi. ");
INSERT INTO gaz_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ani nan deemaatii niitota koo fi ijoollee koo warra ani isaaniif jedhee siif tajaajile naa kenni. Akka ani hojii baayʼee siif hojjedhe ati iyyuu beekta.” ");
INSERT INTO gaz_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laabaan garuu akkana jedheen; “Maaloo yoo ani fuula kee duratti fudhatama argadhee jiraadhe asuma turi; ani akka Waaqayyo sababii keetiin na eebbise mulʼataan beekeeraatii.” ");
INSERT INTO gaz_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Itti fufees, “Mee mindaa ani siif kaffaluu qabu natti himi; ani siifin kaffalaatii” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaaqoobis akkana jedheen; “Akka ani hammam siif hojjedhe, horiin kees hammam akka harka kootti baayʼate atuu ni beekta. ");
INSERT INTO gaz_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Wanni xinnaan ati utuu ani hin dhufin dura qabdu sun amma akka malee siif baayʼateera; lafa ani ture kamitti iyyuu Waaqayyo si eebbiseera. Garuu yeroon ani itti maatii kootiif yaadu yoomi ree?” ");
INSERT INTO gaz_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Innis, “Wanni ani siif kennu maali ree?” jedhee gaafate. Yaaqoob immoo akkana jedhee deebise; “Homaa naaf hin kennin; garuu yoo ati waan kana naaf goote ani ittuma fufee bushaayee kee nan tiksa; nan eegas; ");
INSERT INTO gaz_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","ani harʼa bushaayee kee hunda keessa baʼee hoolota cocorree fi buburree hunda, hoolaa magaalaa fi reʼoota cocorree yookaan buburree hunda addaan nan baasa; isaan kunneen mindaa koo taʼu. ");
INSERT INTO gaz_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Yeroo ati mindaa naa kennite sana toʼachuu dhuftutti, amanamummaan koo dhugaa naa baʼa. Hoolotaa fi reʼoota koo keessatti reʼeen cocorree yookaan buburree hin taʼin kam iyyuu, hoolaa keessaa immoo kan gurraacha hin taʼin kam iyyuu yoo argame akka waan hatameetti haa ilaalamu.” ");
INSERT INTO gaz_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laabaanis, “Tole, akkuma ati jette haa taʼu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Guyyuma sana Laabaan korbeeyyii reʼee halluu qaxxaamuroo qabanii fi buburree hunda, goromii reʼee cocorree fi buburree kanneen adaadii qaban hunda, akkasumas hoolota gugurraacha hunda fuudhee ilmaan isaatti kenne. ");
INSERT INTO gaz_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Innis ofii isaatii fi Yaaqoob gidduutti lafa adeemsa guyyaa sadii hambise; Yaaqoob immoo bushaayee Laabaa kanneen hafan tiksuu itti fufe. ");
INSERT INTO gaz_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaaqoobis damee alaltuu, kan looziitii fi hadheessa jiidhaa isaa darbee darbee naannessee qoola isaa irraa quncisuudhaan dhagna mukichaa isa keessaa adii sana mulʼise. ");
INSERT INTO gaz_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Yaaqoobis yeroo bushaayeen sun bishaan dhuguuf dhufanitti damee qolli irraa quncifame sana fuula isaanii dura bidiruu bishaan itti obaasan keessa kaaʼe. Bushaayeen yeroo sun bishaan dhuguu dhufanitti gojomaʼanii ");
INSERT INTO gaz_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","ulee sana duratti wal hobobsu turan; isaanis ilmoolee halluu qaxxaamuroo qaban, cocorree fi buburree dhalan. ");
INSERT INTO gaz_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaaqoobis ilmoolee bushaayee kophaatti baase; bushaayee Laabaa kanneen hafan garuu warra halluu qaxxaamuroo qabanii fi gurraacha dura dhaabe. Akkasitti hoolota isaa addaan baase malee bushaayee Laabaatti hin makne. ");
INSERT INTO gaz_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Yeroo dhaltuuwwan jajjaboon gojomaʼan kam iyyuu, Yaaqoob akka isaan ulee sana biratti wal hobobsaniif jedhee ulee sana fuula isaanii dura bidiruu keessa kaaʼaa ture; ");
INSERT INTO gaz_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","dhaltuuwwan dadhaboo dura garuu ulee sana hin keenye. Kanaafuu warri dadhaboon kan Laabaa, warri jajjaboon immoo kan Yaaqoob taʼan. ");
INSERT INTO gaz_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Namichi kun haala kanaan akka malee soorome; innis bushaayee baayʼee, garboota dubartootaatii fi dhiirotaa, gaalawwanii fi harroota qaba ture. ");
INSERT INTO gaz_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Yaaqoobis akka ilmaan Laabaa, “Yaaqoob waan abbaan keenya qabu hunda fudhateera; qabeenya kana hundas waanuma kan abbaa keenyaa ture irraa argate” jedhan dhagaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaaqoobis fuula Laabaa ilaale; kunoo fuulli isaa akka duraatti isatti hin tolle. ");
INSERT INTO gaz_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Waaqayyos Yaaqoobiin, “Biyya abbaa keetii fi fira keetti deebiʼi; anis si wajjin nan taʼa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Kanaafuu Yaaqoob akka isaan bakkeetti lafa bushaayeen isaa jiranitti gad baʼaniif gara Raahelii fi Liyaatti ergaa erge. ");
INSERT INTO gaz_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Innis akkana isaaniin jedhe; “Ani akka abbaan keessan akka kanaan duraa sana fuula natti hin tolle hubadheera; garuu Waaqni abbaa kootii na wajjin jira. ");
INSERT INTO gaz_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Akka ani humna koo guutuudhaan abbaa keessaniif hojjedhe isinuu beektu; ");
INSERT INTO gaz_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","taʼus abbaan keessan mindaa koo yeroo kudhan geeddaruudhaan na gowwoomse. Waaqni garuu akka inni na miidhu hin eeyyamneef. ");
INSERT INTO gaz_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Yeroo inni, ‘Bushaayeen cocorreen mindaa kee taʼu’ jedhetti, bushaayeen hundi ilmaan cocorree dhalan; yeroo inni, ‘warri halluu qaxxaamuroo qaban mindaa kee taʼu’ jedhetti immoo bushaayeen hundi ilmaan qaxxaamuroo qaban dhalan. ");
INSERT INTO gaz_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Waaqni karaa kanaan horii abbaa keessanii fuudhee naa kenne. ");
INSERT INTO gaz_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","“Anis gaaf tokko waqtii gaana bushaayeetti abjuu keessa ol ilaalee kunoo korbeeyyiin reʼootatti hobobsan akka halluu qaxxaamuroo qaban, cocorree fi buburree taʼan nan arge. ");
INSERT INTO gaz_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Ergamaan Waaqayyoos abjuu keessa, ‘Yaaqoob’ naan jedhe. Ani, ‘Kunoo asan jira’ jedheen deebise. ");
INSERT INTO gaz_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Inni immoo akkana naan jedhe; ‘Akka korbeeyyiin reʼootaa kanneen bushaayeetti hobobsan hundinuu halluu qaxxaamuroo qaban, cocorree fi buburree taʼan ol jedhii ilaali. Ani waan Laabaan sitti hojjete hunda argeeraatii. ");
INSERT INTO gaz_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ani Waaqa Beetʼeel lafa ati itti utubaa dibdee wareega naaf wareegde sanaa ti. Amma kaʼiitii biyya kana keessaa baʼiitii gara biyya fira keetiitti deebiʼi.’ ” ");
INSERT INTO gaz_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Kana irratti Raahelii fi Liyaan akkana jedhanii deebisan; “Qoodni yookaan dhaalli mana abbaa keenyaatti nuu hafe jiraa? ");
INSERT INTO gaz_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Inni akkuma ormaatti nu ilaala mitii? Inni nu gurgurateeraatii maallaqa sababii keenyaaf kenname nyaatee fixeera. ");
INSERT INTO gaz_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Qabeenyi Waaqni abbaa keenya irraa fuudhe hundi kan keenyaa fi kan ijoollee keenyaa ti. Egaa waan Waaqni sitti hime hunda godhi.” ");
INSERT INTO gaz_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Yaaqoobis ijoollee isaatii fi niitota isaa gaalawwan irra kaaʼate; ");
INSERT INTO gaz_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","horii fi qabeenya kaaba dhiʼa Phaadaan Arraamiitti horatte hunda of dura oofee gara biyya Kanaʼaan abbaa isaa Yisihaaq bira dhaquuf kaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laabaan hoolota isaa irraa rifeensa murmuruu dhaqe; Raahel immoo waaqota abbaa ishee hatte. ");
INSERT INTO gaz_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaaqoobis akka isa dhiisee baqachuu yaade isa dhoksuudhaan Laabaan namicha Arraam sana gowwoomse. ");
INSERT INTO gaz_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Innis waan qabu hunda fudhatee baqate; laga Efraaxiis ceʼee biyya gaara Giliʼaaditti qajeele. ");
INSERT INTO gaz_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Akka Yaaqoob baqate guyyaa sadaffaatti Laabaatti himame. ");
INSERT INTO gaz_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Laabaanis firoota isaa fudhatee guyyaa torba Yaaqoob duukaa buʼee biyya gaara Giliʼaaditti isa qaqqabe. ");
INSERT INTO gaz_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Waaqnis halkan abjuudhaan gara Laabaan namicha biyya Arraam sanaa dhufee, “Ati waan gaariis taʼu hamaa tokko iyyuu Yaaqoobitti akka hin dubbanne of eeggadhu” isaan jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Yaaqoob yeroo Laabaan isa qaqqabetti, biyya gaaraa Giliʼaad keessa dunkaana isaa dhaabbatee ture; Laabaa fi firoonni isaas achi qubatan. ");
INSERT INTO gaz_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laabaanis Yaaqoobiin akkana jedhe; “Ati na gowwoomsitee intallan koo akka boojiʼamtoota waraanaatti fudhattee deemuun kee maal gochuu kee ti? ");
INSERT INTO gaz_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ati maaliif dhoksaan baqatte? Maaliifis na gowwoomsite? Akka ani gammachuu fi faarfannaadhaan, dibbee fi baganaadhaan si geggeessuuf maaliif natti himuu didde? ");
INSERT INTO gaz_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ati akka ani ijoollee ijoollee kootiitii fi intallan koo dhungadhee nagaatti jedhu naaf hin eeyyamne. Ati hojii gowwummaa hojjete. ");
INSERT INTO gaz_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ani isin miidhuuf humna qaba; garuu eda Waaqni abbaa keessanii, ‘Ati waan gaariis taʼu hamaa tokko illee Yaaqoobitti akka hin dubbanne of eeggadhu’ naan jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Ati sababii mana abbaa keetiitti deebiʼuu akka malee hawwiteef deemteerta; garuu maaliif waaqota koo hatte?” ");
INSERT INTO gaz_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaaqoobis akkana jedhee Laabaaf deebii kenne; “Ati intallan kee humnaan narraa fudhatta jedhee waanan sodaadheef nan deeme. ");
INSERT INTO gaz_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Namni ati waaqota kee isa biratti argattu jiraachuu hin qabu. Akka wanni kan kee taʼe na bira jiruu fi akka hin jirre atuu fuula firoota keenyaa duratti sakattaʼi; yoo jiraate immoo fudhadhu.” Yaaqoob Raahel waaqota sana hattuu ishee Yaaqoob hin beeku ture. ");
INSERT INTO gaz_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laabaanis dunkaana Yaaqoob, dunkaana Liyaatii fi dunkaana xomboreewwan lamaanii seenee homaa dhabe. Erga dunkaana Liyaatii baʼee booddees dunkaana Raahel seene. ");
INSERT INTO gaz_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raahel immoo waaqota mana keessaa hatte sana kooraa gaalawwan ishee jala keessee irra taaʼaa turte. Laabaanis waan dunkaanicha keessa jiru hunda keessa barbaade; garuu homaa hin arganne. ");
INSERT INTO gaz_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raahelis abbaa isheetiin, “Yaa gooftaa ko, sababii ani kaʼee fuula kee dura dhaabachuu dadhabeef hin aarin; ani xuriin of irraa qabaa” jette. Innis ni sakattaʼe malee waaqota sana hin arganne. ");
INSERT INTO gaz_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Yaaqoobis Laabaatti aaree isatti dheekkame. Innis akkana jedhee gaafate; “Yakki koo maali? Wanni ati akkana na adamsituuf ani cubbuu maalii hojjedheeti? ");
INSERT INTO gaz_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ati miʼa koo hunda sakattaateerta; egaa miʼa mana keetii keessaa maal argatte? Yoo jiraate firoota keetii fi firoota koo duratti dhiʼeessiitii isaan nu lamaan gidduutti murtii haa kennan. ");
INSERT INTO gaz_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","“Ani waggoota digdaman kana si wajjin jiraadheera. Hoolonnii fi reʼoonni kee tokko iyyuu hin gatanne; ani bushaayee kee keessaas korbeeyyii hin nyaanne. ");
INSERT INTO gaz_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Ani horii bineensi cabse gara keetti hin fidne; horii bades anatu kaffalaa ture. Waan guyyaas taʼu halkan hatame hundaaf ati na kaffalchiifatta turte. ");
INSERT INTO gaz_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Haalli ani keessa jiraadhe kana ture; guyyaa hoʼa, halkan immoo dhaamochatu na waxala ture; hirribnis ija koo irraa bade. ");
INSERT INTO gaz_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Akkasiin ani waggoota digdamman kana mana kee ture. Ani waggaa kudha afur intallan kee lamaaniif jedhee, waggaa jaʼa immoo bushaayee keetiif jedhee siif hojjedheera; ati immoo yeroo kudhan mindaa koo geeddarte. ");
INSERT INTO gaz_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Waaqni abbaa ko, Waaqni Abrahaam, Sodaan Yisihaaq utuu na wajjin jiraachuu baate ati silaa harka duwwaa na baasta turte. Waaqni garuu rakkina koo fi dadhabbii koo argee eda sitti dheekkame.” ");
INSERT INTO gaz_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laabaan akkana jedhee Yaaqoobiif deebise; “Dubartoonni kunneen intallan koo ti; ijoolleen kunneenis ijoolluma koo ti; bushaayeen kunneenis bushaayee koo ti. Wanni ati argitu hundi kanuma koo ti. Yoos ani waaʼee intallan koo kanneeniitii fi waaʼee ijoollee isaan daʼanii harʼa maal gochuun dandaʼa? ");
INSERT INTO gaz_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Kottu mee anii fi ati amma walii kakannaa; kakuun kunis anaa fi si gidduutti ragaa haa taʼu.” ");
INSERT INTO gaz_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Yaaqoobis dhagaa tokko fuudhee akka utubaatti dhaabe. ");
INSERT INTO gaz_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Innis firoota isaatiin, “Dhagaa walitti qabaa” jedhe. Isaanis dhagaa walitti qabanii tuulan; jarris tuullaa sana biratti nyaata nyaatan. ");
INSERT INTO gaz_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laabaan tuullaa sanaan “Yigaarsahaadutaa” jedhee moggaase; Yaaqoob immoo “Giliʼaad” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laabaanis, “Tuullaan kun anaa fi si gidduutti ragaa dha” jedhe. Gaalaʼaad jedhamuun isaa kanumaaf. ");
INSERT INTO gaz_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Akkasumas Miisphaa jedhame; Laabaan akkana jedhee tureetii; “Yeroo nu gargar baanutti Waaqayyo sii fi ana gidduutti eegduu haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Yoo ati intallan koo rakkifte yookaan yoo ati intallan koo irratti niitota biraa fuute, yoo namni tokko iyyuu nu bira hin jirre kunoo Waaqni anaa fi siʼi gidduutti ragaa dha.” ");
INSERT INTO gaz_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Laabaan ammas Yaaqoobiin akkana jedhe; “Tuullaa kanaa fi utubaa ani sii fi ana gidduu dhaabe kana ilaali. ");
INSERT INTO gaz_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Akka ani si miidhuuf jedhee tuullaa kana darbee gara keetti hin ceene, akka atis na miidhuuf jettee tuullaa kanaa fi utubaa kana dabartee gara kootti hin ceene tuullaan kun ragaa dha; utubaan kunis ragaa dha. ");
INSERT INTO gaz_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Waaqni Abrahaam, Waaqni Naahoor, Waaqni abbootii isaanii nu gidduutti murtii haa kennu.” Yaaqoobis akkasitti maqaa Sodaa abbaa isaa Yisihaaqiin kakate. ");
INSERT INTO gaz_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Innis biyya gaaraa sanatti aarsaa dhiʼeessee firoota isaa nyaatatti waame. Isaanis erga nyaatanii booddee achuma bulan. ");
INSERT INTO gaz_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laabaanis guyyaa itti aanu ganama bariidhaan kaʼee ijoollee ijoollee isaatii fi intallan isaa dhungatee isaan eebbise. Ergasiis achii kaʼee gara iddoo isaatti deebiʼe. ");
INSERT INTO gaz_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaaqoobis karaa isaa itti fufe; ergamoonni Waaqayyoos isatti dhufan. ");
INSERT INTO gaz_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Innis yommuu isaan argetti, “Kun buufata Waaqaa ti” jedhe; iddoo sanas Mahanayiim jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaaqoobis gara obboleessa isaa Esaawu kan biyya Edoom lafa Seeʼiir jedhamu keessa jiraatuutti ergamoota of dura erge. ");
INSERT INTO gaz_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Innis akkana jedhee isaan ajaje: “Isin gooftaa koo Esaawuun akkana jedhaa: ‘Garbichi kee Yaaqoob akkana jedha; ani Laabaa bira jiraadhee hamma ammaattis isuma biran ture. ");
INSERT INTO gaz_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ani loonii fi harroota, hoolotaa fi reʼoota, hojjettoota dhiiraatii fi dubartootas qaba. Ammas ani fuula kee duratti surraa akkan argadhuuf ergaa kana gooftaa kootti nan erga.’ ” ");
INSERT INTO gaz_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ergamoonni sunis gara Yaaqoobitti deebiʼanii, “Nu obboleessa kee Esaawu bira dhaqneerra; innis si simachuuf dhufaa jira; namoonni dhibba afur isa wajjin jiru” jedhaniin. ");
INSERT INTO gaz_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaaqoobis akka malee sodaatee dhiphate; namoota isa wajjin turanis garee lamatti qoode; bushaayee, loowwanii fi gaalawwan illee akkasuma garee lamatti qoode. ");
INSERT INTO gaz_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Innis, “Yoo Esaawu dhufee garee tokko dhaʼe, gareen kaan jalaa baʼa” jedhee yaade. ");
INSERT INTO gaz_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Yaaqoob akkana jedhee kadhate; “Yaa Waaqa abbaa koo Abrahaam, Waaqa abbaa koo Yisihaaq, yaa Waaqayyo, isa ‘Ati gara biyya keetii fi gara firoota keetiitti deebiʼi, ani waan gaarii siifin godhaa’ naan jette sun, ");
INSERT INTO gaz_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","ani gaarummaa fi amanamummaa ati ana garbicha kee argisiifte kana hundaaf hin malu. Ani yeroo Yordaanos kana ceʼetti ulee koo qofa qaban ture; amma garuu garee lama taʼeen jira. ");
INSERT INTO gaz_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Ani akka ati harka obboleessa koo Esaawu jalaa na baastu sin kadhadha. Ani, ‘Inni dhufee na ajjeesa; haadhotas ijoollee isaanii wajjin ni ajjeesa’ jedhee sodaadheeraatii. ");
INSERT INTO gaz_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Ati garuu, ‘Ani dhugumaan waan gaarii siifin godha; sanyii kees akka cirracha galaanaa kan lakkaaʼamuu hin dandeenye sanaa nan godha’ jetteerta.” ");
INSERT INTO gaz_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Inni halkan sana achuma bule; waan of biraa qabu keessaas kennaa obboleessa isaa Esaawuuf kennu filate; ");
INSERT INTO gaz_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","isaanis reʼoota dhaltuu dhibba lama, korbeeyyii reʼee digdama, hoolota dhaltuu dhibba lama, korbeeyyii hoolaa digdama, ");
INSERT INTO gaz_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","gaalawwan dhalaa soddoma ilmaan isaanii wajjin, saawwan afurtama, jiboota loonii kudhan, harroota dhaltuu digdama, wadala harrootaa kudhan turan. ");
INSERT INTO gaz_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Innis karra karraan addaan baasee tajaajiltoota isaatti kennee, “Na dura darbaa deemaa; karrawwan horii gidduuttis lafa hambisaa” jedhee tajaajiltoota isaa ajaje. ");
INSERT INTO gaz_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Namicha fuula duraan jiru sanaanis akkana jedhe: “Yoo Esaaw obboleessi koo sitti dhufe, ‘Ati kan eenyuu ti? Eessa dhaqxa? Horiin fuula kee dura jiru kun kan eenyuu ti?’ jedhee si gaafate, ");
INSERT INTO gaz_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ati, ‘Kan garbicha kee Yaaqoob. Isaanis kennaa gooftaa koo Esaawuuf ergamanii dha; kunoo, Yaaqoobis nu duubaan dhufaa jira’ jechuu qabda.” ");
INSERT INTO gaz_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Namicha lammaffaa, sadaffaa fi warra karrawwan sana faana deeman hundas akkana jedhee ajaje; “Isinis yoo Esaawun argitan waanuma kana isatti himaa. ");
INSERT INTO gaz_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","Akkasumas, ‘Kunoo garbichi kee Yaaqoob nu duubaan dhufaa jira’ jedhaa.” Inni, “Ani kennaa of dura ergeef kanaan isa nan araarfadha; ergasii immoo ani yommuun isa argutti tarii inni na simata taʼa” jedhee yaadee tureetii. ");
INSERT INTO gaz_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Kennaan Yaaqoobiis isa dura darbe; Yaaqoob garuu halkan sana qubata sana keessa bule. ");
INSERT INTO gaz_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Halkanuma sana Yaaqoob kaʼee niitota isaa lamaan, xomboreewwan isaa lamaanii fi ilmaan isaa kudha tokko fudhatee malkaa Yaaboq ceʼe. ");
INSERT INTO gaz_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Innis erga laga isaan ceesisee booddee qabeenya isaa hunda erge. ");
INSERT INTO gaz_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Yaaqoob immoo kophaa isaa hafe; namichi tokkos hamma lafti bariitutti walʼaansoo isa qabe. ");
INSERT INTO gaz_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Namichis yommuu akka Yaaqoobin moʼachuu hin dandeenye argetti, buusaa luqqeettuu Yaaqoob tuqe; yeroo inni namicha wajjin walʼaansoo qabettis luqqeettuun Yaaqoob ni adoode. ");
INSERT INTO gaz_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Namichis, “Waan bariʼuu gaʼeef gad na dhiisi” jedhe. Yaaqoob garuu, “Yoo ati na eebbifte malee ani gad si hin dhiisu” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Namichis, “Maqaan kee eenyu” jedhee isa gaafate. Inni immoo, “Yaaqoob” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Namichis, “Ati sababii Waaqaa fi namoota wajjin walʼaansoo qabdee moʼatteef siʼachi Israaʼel jedhamta malee Yaaqoob hin jedhamtu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Yaaqoobis, “Maaloo maqaa kee natti himi” jedheen. Inni garuu, “Ati maaliif maqaa koo gaafatta?” jedheen. Ergasiis inni achumatti isa eebbise. ");
INSERT INTO gaz_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yaaqoobis, “Ani ifaan ifatti Waaqa argeeraatii; lubbuun koo garuu oolfamteerti” jedhee iddoo sana Pheniiʼeel jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Akkuma inni Phenuuʼeelin darbeen aduun isatti baate; innis sababii luqqeettuu isaatiif okkolaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Kanaafuu Israaʼeloonni hamma harʼaatti ribuu tafaa hin nyaatan; inni buusaa luqqeettuu Yaaqoob kan tafaan wal qabatu tuqee tureetii. ");
INSERT INTO gaz_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaaqoobis ol jedhee ilaalee kunoo Esaawu namoota dhibba afur wajjin utuu dhufaa jiruu arge; innis Liyaatti, Raahelii fi xomboreewwan lamaanitti ijoollee gargari hire. ");
INSERT INTO gaz_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Xomboreewwanii fi ijoollee isaanii dura aanse; Liyaa fi ijoollee ishee itti aansee, Raahelii fi Yoosefin immoo dugda duuba buuse. ");
INSERT INTO gaz_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Ofii isaatii immoo isaan dura darbee hamma obboleessa isaa bira gaʼutti yeroo torba lafatti gad jedhee harka fuudhe. ");
INSERT INTO gaz_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaawu garuu Yaaqoobin simachuuf itti fiigee isa hammate; morma isaattis marmee isa dhungate. Isaan lachanuu walitti booʼan. ");
INSERT INTO gaz_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esaawus ol jedhee ilaalee dubartootaa fi ijoollee argee, “Warri si wajjin jiran kunneen eenyu?” jedhee gaafate. Yaaqoobis deebise, “Isaan ijoollee Waaqni arjummaadhaan ana garbicha keetiif kennee dha” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Xomboreewwanii fi ijoolleen isaanii dhiʼaatanii gad jedhanii harka fuudhan. ");
INSERT INTO gaz_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","Itti aansaniis Liyaa fi ijoolleen ishee dhufanii gad jedhanii harka fuudhan. Dhuma irratti immoo Yoosefii fi Raahel dhufanii gad jedhani harka fuudhan. ");
INSERT INTO gaz_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaawu, “Bushaayee fi loon ani argu kun hundi maali?” jedhee gaafate. Yaaqoobis, “Ani fuula kee fuula gooftaa koo duratti fudhatama argachuuf jedhee ti” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaawu immoo, “Yaa obboleessa koo ani waan na gaʼu qaba. Ati waan qabdu ofuma keetii hambifadhu” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaaqoobis akkana jedhe; “Maaloo akkas miti! Yoo ani fuula kee duratti fudhatama argadhee jiraadhe, kennaa kana na harkaa fudhadhu. Egaa amma ati fuula tolaadhaan na simatteerta; fuula kee arguun anaaf akkuma fuula Waaqaa arguutii. ");
INSERT INTO gaz_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Sababii Waaqni natti arjoomee anis waan na barbaachisu hunda qabuuf maaloo kennaa ani siif fide kana fudhadhu.” Esaawus waan Yaaqoob cimsee isa kadhateef kennaa sana ni fudhate. ");
INSERT INTO gaz_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Esaawus, “Kottu karaa keenya itti fufnee haa deemnu; ani si dura nan buʼaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yaaqoob garuu akkana isaan jedhe; “Akka ijoolleen dadhaboo taʼanii fi akka anis hoolotaa fi saawwan hoosisaniif kunuunsa gochuu qabu ati gooftaan koo ni beekta. Horiin kunneen yoo guyyuma tokkoon jarjarsuudhaan oofaman hundi isaanii ni dhumu. ");
INSERT INTO gaz_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Gooftaan koo garbicha isaa dura darbee haa deemu; ani immoo hamman Seeʼiiritti gooftaa koo qaqqabutti akkuma humna bushaayee fuula koo dura jirutii fi akkuma humna ijoolleetti suuta jedhee nan deema.” ");
INSERT INTO gaz_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaawus, “Yoos namoota koo keessaa muraasa si biratti nan dhiisa” jedhe. Yaaqoob immoo, “Kun maaliif barbaachisaa? Fuula gooftaa koo duratti fudhatama argachuun qofti na gaʼa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Esaawus guyyuma sana karaa isaa irra Seeʼiiritti deebiʼe. ");
INSERT INTO gaz_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaaqoob garuu Sukooti dhaqee achitti ofii isaatiif mana ijaarrate; horii isaatiif immoo daasii ijaare. Kanaafuu iddoon sun Suukooti jedhame. ");
INSERT INTO gaz_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaaqoob erga kaaba dhiʼa Phaadaan Arraamiitii deebiʼee booddee nagaan magaalaa Sheekem ishee biyya Kanaʼaan keessaa sana gaʼee fuula magaalattii dura qubate. ");
INSERT INTO gaz_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Innis lafa dunkaana isaa irra dhaabate sana ilmaan Hamoor irraa meetii dhibbaan bitate; Hamoor immoo abbaa Sheekem. ");
INSERT INTO gaz_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Yaaqoobis achitti iddoo aarsaa ijaaree El Elohee Israaʼel jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Diinaan intalli Liyaan Yaaqoobiif deesse sun dubartoota biyyattii ilaaluudhaaf gad baate. ");
INSERT INTO gaz_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sheekem ilmi Hamoor namicha gosa Hiiwii kan bulchaa biyya sanaa ture ishee arge; innis qabee humnaan ishee gudeede. ");
INSERT INTO gaz_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Qalbiin isaas Diinaa intala Yaaqoobiin fudhatame; innis ishee jaallatee afaan tolaa itti dubbate. ");
INSERT INTO gaz_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Sheekemis abbaa isaa Hamooriin, “Intala kana na fuusisi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaaqoob yommuu intalli isaa Diinaan akka gudeedamte dhagaʼetti, ilmaan isaa dirree irra horii tiksu turan; kanaafuu Yaaqoob hamma isaan galanitti ni calʼise. ");
INSERT INTO gaz_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Hamoor abbaan Sheekemis Yaaqoob wajjin dubbachuu dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ilmaan Yaaqoobis akkuma waan uumame sana dhagaʼaniin dirreedhaa dhufan. Isaanis sababii Sheekem intala Yaaqoob wajjin ciisuudhaan Israaʼel keessatti waan jibbisiisaa hojjeteef ni gaddan; akka malees aaran. ");
INSERT INTO gaz_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamoor garuu akkana isaaniin jedhe; “Qalbiin ilma koo Sheekem intala keessan irra buʼeera. Maaloo isatti ishee heerumsiisaa. ");
INSERT INTO gaz_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Fuudhaa fi heerumaan walitti firoomnaa; intallan keessan nuu kennaa; intallan keenyas fuudhaa. ");
INSERT INTO gaz_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","Nu wajjin jiraadhaa; biyyattiin fuula keessan dura jirti; keessa jiraadhaatii itti daldalaa; qabeenyas itti horadhaa.” ");
INSERT INTO gaz_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sheekemis abbaa Diinaatii fi obboloota isheetiin akkana jedhe; “Ani fuula keessan duratti fudhatama argannaan waanuma isin naan jettan isiniif nan kenna. ");
INSERT INTO gaz_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Isinis gabbara misirrittiitii fi kennaa ani fiduu qabu hamma feetan natti muraa; anis waan isin naan jettan nan baasa. Intalattii qofa natti heerumsiisaa.” ");
INSERT INTO gaz_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Ilmaan Yaaqoob immoo waan Sheekem obboleettii isaanii Diinaa gudeedeef yeroo Sheekemii fi abbaa isaa Hamooriif deebii kennanitti haxxummaadhaan dubbatan. ");
INSERT INTO gaz_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Isaanis akkana isaaniin jedhan; “Nu waan akkanaa gochuu hin dandeenyu; nu nama dhagna hin qabatiniif intala keenya kennuu hin dandeenyu. Kun nuuf salphina. ");
INSERT INTO gaz_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Nu waan tokko qofaan tole isiniin jenna; kunis yoo isin dhiira keessan hunda dhagna qabdanii akkuma keenya taatanii dha. ");
INSERT INTO gaz_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Ergasii nu intallan keenya isinii kennina; intallan keessan immoo ni fuuna. Gidduu keessan ni jiraanna; isin wajjinis saba tokko ni taana. ");
INSERT INTO gaz_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Garuu yoo isin dhagna qabachuu diddan nu obboleettii keenya fudhannee deemna.” ");
INSERT INTO gaz_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Dubbiin isaanii Hamoorii fi Sheekem ilma Hamoor ni gammachiise. ");
INSERT INTO gaz_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sheekem namoota mana abbaa isaa jiraatan hunda caalaa kabajamaa ture; inni sababii intala Yaaqoobitti gammadeef waan kana lafa irra hin harkifne; ");
INSERT INTO gaz_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Hamoorii fi ilmi isaa Sheekem gara karra magaalaa isaanii dhufanii namoota magaalaa isaaniitiin akkana jedhan; ");
INSERT INTO gaz_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","“Jarri kun nuuf warra nagaa ti; kanaafuu biyyattii keessa jiraatanii itti haa daldalatan. Biyyattiin isaaniif lafa balʼaa qabdi; nu intallan isaanii haa fuunu; isaanis intallan keenya haa fuudhan. ");
INSERT INTO gaz_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Garuu namoonni kunneen akka saba tokkootti nu wajjin jiraachuuf tole kan jedhan yoo dhiironni keenya akkuma isaanii dhagna qabatan qofa. ");
INSERT INTO gaz_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Loon isaanii, qabeenyi isaaniitii fi horiin isaanii kaan hundinuu kanuma keenya hin taʼanii? Kanaafuu kottaa tole isaaniin jennaa; isaanis nu wajjin ni jiraatu.” ");
INSERT INTO gaz_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Namoonni karra magaalaa sanaatiin gad baʼan hundinuu Hamoorii fi ilma isaa Sheekemiin walii galan; dhiironni karra magaalaa sanaatiin gad baʼan hundinuus dhagna qabatan. ");
INSERT INTO gaz_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Guyyaa sadii booddee utuma isaan dhukkubsachaa jiranuu, ilmaan Yaaqoobii keessaa namni lama Simiʼoonii fi Lewwiin, obboloonni Diinaa, goraadee isaanii fudhatanii magaalaa homaa quba hin qabne sana dhaʼanii dhiira hunda ajjeesan. ");
INSERT INTO gaz_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Isaanis goraadeedhaan Hamoorii fi ilma isaa Sheekemin ajjeesanii Diinaa immoo mana Sheekemiitii fudhatanii qajeelan. ");
INSERT INTO gaz_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ilmaan Yaaqoobis reeffawwan irra darbanii magaalaa obboleettiin isaanii itti gudeedamte sana saaman. ");
INSERT INTO gaz_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Isaanis bushaayee isaanii, loon isaanii, harroota isaaniitii fi waan isaan magaalaa keessaa fi alaa qaban hunda fudhatan. ");
INSERT INTO gaz_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Qabeenya isaanii hunda, dubartootaa fi ijoollee isaanii hunda fudhatanii deeman; waan mana keessa jiru hundas ni boojiʼan. ");
INSERT INTO gaz_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaaqoobis Simiʼoonii fi Lewwiidhaan akkana jedhe; “Isin akka ani Kanaʼaanotaa fi Feerzota biyya kana jiraatanitti xireeffatamu gochuudhaan rakkoo natti fiddan. Nu baayʼinaan xinnoo dha; yoo isaan humna walitti dabalatanii na lolan anii fi warri mana koo hundinuu ni dhumna.” ");
INSERT INTO gaz_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Isaan garuu, “Yoos inni akkuma sagaagaltuu tokkootti obboleettii keenyatti haa taphatuu ree?” jedhanii deebisan. ");
INSERT INTO gaz_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Waaqni Yaaqoobiin, “Kaʼiitii Beetʼeelitti ol baʼii achi jiraadhu; achittis Waaqa yeroo ati obboleessa kee Esaawun baqatetti sitti mulʼate sanaaf iddoo aarsaa tolchi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Yaaqoob warra mana isaa jiranii fi warra isa wajjin turan hundaan akkana jedhe; “Waaqota ormaa kanneen isin of biraa qabdan irraa fagaadhaa; of qulqulleessaa; uffata keessanis geeddaradhaa. ");
INSERT INTO gaz_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kottaa kaanee Beetʼeelitti ol baanaa; anis achitti Waaqa gaafa rakkina kootii deebii naa kenne isa iddoo ani dhaqe hundumatti na wajjin ture sanaaf iddoo aarsaa nan tolcha.” ");
INSERT INTO gaz_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Isaanis waaqota ormaa kanneen isaan of biraa qaban hundaa fi lootii gurra isaanii Yaaqoobitti kennan; Yaaqoobis fuudhee qilxuu Sheekemii jalatti awwaale. ");
INSERT INTO gaz_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Isaanis kaʼanii qajeelan; akka namni tokko iyyuu isaan duukaa hin buuneef naasisuun Waaqaa magaalaawwan naannoo isaanii jiran irra buʼe. ");
INSERT INTO gaz_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaaqoobii fi namoonni isa wajjin turan hundi gara Luuzi kan Beetʼeel jedhamtuu ishee biyya Kanaʼaan keessatti argamtu sanaa dhufan. ");
INSERT INTO gaz_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Innis achitti iddoo aarsaa tolchee sababii yeroo inni obboleessa isaa jalaa baqachaa turetti Waaqni achitti isatti of mulʼiseef iddoo sana El Beetʼeel jedhee waame. ");
INSERT INTO gaz_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Debooraan guddiftuun Ribqaa duutee Beetʼeelii gaditti qilxuu jalatti awwaalamte. Maqaan isaas Aloonbaakut jedhame. ");
INSERT INTO gaz_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Erga Yaaqoob kaaba dhiʼa Phaadaan Arraamiitii deebiʼee booddee Waaqni ammas isatti mulʼatee isa eebbise. ");
INSERT INTO gaz_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Waaqni, “Maqaan kee Yaaqoob; siʼachi garuu ati Yaaqoob hin jedhamtu; maqaan kee Israaʼel jedhama” jedheen. Maqaan isaas Israaʼel jedhame. ");
INSERT INTO gaz_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Waaqni akkana isaan jedhe; “Ani Waaqa Waan Hunda Dandaʼu dha; hori; baayʼadhus. Sabnii fi waldaan sabootaa sirraa argamu; mootonnis mudhii kee keessaa baʼu. ");
INSERT INTO gaz_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Ani biyya Abrahaamii fi Yisihaaqiif kenne siifis nan kenna; ani biyya kana sanyii kee warra si booddeetiifis nan kenna.” ");
INSERT INTO gaz_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Waaqnis iddoo itti isa wajjin haasaʼaa ture sanatti isa dhiisee ol baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaaqoob iddoo itti Waaqni isa wajjin dubbate sana utubaa dhagaa tokko dhaabee kennaa dhugaatii irratti dhangalaase; zayitiis irratti dhangalaase. ");
INSERT INTO gaz_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Yaaqoobis iddoo itti Waaqni isa wajjin dubbate sana Beetʼeel jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Isaanis Beetʼeelii kaʼanii adeemsa isaanii itti fufan. Akkuma isaan Efraataatti dhiʼaataniinis Raahel ciniinsuun qabamtee akka malee muddamte. ");
INSERT INTO gaz_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Utuu isheen daʼuuf ciniinsuu jabaa keessa jirtuus deessiftuun, “Ati waan ilma biraa deessuuf hin sodaatin” jetteen. ");
INSERT INTO gaz_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Raahel garuu waan duʼuu geesseef utuma lubbuun ishee baʼaa jirtuu Ben-Oonii jettee ilma ishee moggaafte. Abbaan isaa garuu Beniyaam jedhee isa moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Akkasiin Raahel duutee karaa Efraataatti geessu irratti awwaalamte; Efraataan kun immoo Beetlihem. ");
INSERT INTO gaz_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaaqoobis awwaala ishee irra soodduu dhaabe; soodduun sunis hamma harʼaattuu awwaala Raahel argisiisa. ");
INSERT INTO gaz_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israaʼel ammas achii kaʼee Migdaal Eederiin gamatti dunkaana isaa dhaabbate. ");
INSERT INTO gaz_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Utuu Israaʼel biyya sana jiraatuu Ruubeen ol seenee saajjatoo abbaa isaa Bilihaa wajjin ciise; Israaʼelis waan kana dhagaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ilmaan Liyaa: Ruubeen jechuunis ilma Yaaqoob isa hangafa, Simiʼoon, Lewwii, Yihuudaa, Yisaakorii fi Zebuuloon. ");
INSERT INTO gaz_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ilmaan Raahel: Yoosefii fi Beniyaam. ");
INSERT INTO gaz_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ilmaan Bilihaa jechuunis xomboree Raahel: Daanii fi Niftaalem. ");
INSERT INTO gaz_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ilmaan Zilfaa jechuunis xomboree Liyaa: Gaadii fi Aasheer. ");
INSERT INTO gaz_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaaqoobis gara abbaa isaa, gara Yisihaaq, gara magaalaa Mamree ishee Kiriyaati Arbaaq kan Kebroon jedhamtuu, iddoo Abrahaamii fi Yisihaaq alagoota taʼanii jiraachaa turan sanaa dhufe. ");
INSERT INTO gaz_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Yisihaaq waggaa dhibba tokkoo fi saddeettama jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Innis umurii quufee, dulloomee hafuura isaa kan dhumaa baafatee duʼe; gara saba isaattis dabalame. Ilmaan isaa Esaawuu fi Yaaqoobis isa awwaalan. ");
INSERT INTO gaz_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Seenaan maatii Esaawu kan Edoom jedhamu sanaa kana. ");
INSERT INTO gaz_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaaw niitota isaa dubartootaa Kanaʼaan keessaa fuudhe; isaanis Aadaa intala Eeloon namicha gosa Heetii fi Oholiibaamaa intala Aannaa ilma Zibeʼoon namicha gosa Hiiwii, ");
INSERT INTO gaz_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","akkasumas Baasmati intala Ishmaaʼeel obboleettii Nabaayoti. ");
INSERT INTO gaz_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aadaan Eliifaazin Esaawuuf deesse; Baasmati immoo Reʼuuʼeelin deesse. ");
INSERT INTO gaz_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholiibaamaanis Yeʼuushi, Yaʼilaamii fi Qooraahi deesse. Isaan kunneen ilmaan Esaawu kanneen Kanaʼaanitti isaaf dhalatanii dha. ");
INSERT INTO gaz_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaawu niitota isaa, ilmaan isaa, intallan isaatii fi warra mana isaa jiraatan hunda, akkasumas karra loon isaa, horii isaa kaan hundaa fi qabeenya biyya Kanaʼaanitti horate hunda fudhatee obboleessa isaa Yaaqoob biraa kaʼee biyya biraa dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Waan qabeenyi isaanii akka malee baayʼateef isaan walii wajjin jiraachuu dadhaban; lafti isaan jiraachaa turanis sababii baayʼina horii isaaniitiif isaan gaʼuu hin dandeenye. ");
INSERT INTO gaz_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Esaawu biyya gaara Seeʼiir keessa jiraate; Esaawu jechuun Edoomii dha. ");
INSERT INTO gaz_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Seenaan maatii Esaawu abbaa Edoomotaa kan warra biyya gaara Seeʼiir keessa jiraatanii kana. ");
INSERT INTO gaz_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Maqaan ilmaan Esaawu: Eliifaaz, ilma Aadaa niitii Esaawuutii fi Reʼuuʼeel ilma Baasmati niitii Esaawuu ti. ");
INSERT INTO gaz_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ilmaan Eliifaaz: Teemaan, Oomaar, Zefoo, Gaataamii fi Qenaz. ");
INSERT INTO gaz_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Eliifaaz ilmi Esaawus saajjatoo Tiimnaa jedhamtu qaba ture; isheenis Amaaleqin Eliifaaziif deesse. Isaan kunneen ilmaan ilmaan Aadaa niitii Esaawu. ");
INSERT INTO gaz_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ilmaan Reʼuuʼeel: Nahaati, Zeraa, Shamaa fi Miizaah. Isaan kunneen ilmaan ilmaan Baasmati niitii Esaawu. ");
INSERT INTO gaz_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholiibaamaan niitiin Esaawu intalli Aannaa ilma Zibeʼoon Esaawuuf: Yeʼuushi, Yaʼilaamii fi Qooraahi deesse. ");
INSERT INTO gaz_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Isaan kunneen sanyiiwwan Esaawu keessaa hangafoota turan: Ilmaan Eliifaaz ilma Esaawu isa hangafaa: Teemaan hangafticha, Oomaar hangafticha, Zefoo hangafticha, Qenaz hangafticha, ");
INSERT INTO gaz_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Qooraahi hangafticha, Gaataam hangaftichaa fi Amaaleq hangafticha. Isaan kunneen hangafoota biyya Edoom keessatti Eliifaaz irraa dhalatanii dha; isaanis ilmaan Aadaa ti. ");
INSERT INTO gaz_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Ilmaan Reʼuuʼeel ilma Esaawu: Nahaati hangafticha, Zeraa hangafticha, Shamaa hangaftichaa fi Miizaah hangafticha. Isaan kunneen hangafoota biyya Edoomitti Raaquʼel irraa dhalatanii dha; isaanis ilmaan Baasmati niitii Esaawu. ");
INSERT INTO gaz_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Ilmaan Oholiibaamaa niitii Esaawu: Yeʼuushi hangafticha, Yaʼilaamaa hangaftichaa fi Qooraahi hangafticha. Isaan kunneen hangafoota Ahiliibaamaa niitii Esaawu intala Aannaa irraa dhalatanii dha. ");
INSERT INTO gaz_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Isaan kunneen ilmaan Esaawu Edoom jedhamu sanaa turan; isaan kunneenis hangafoota isaanii turan. ");
INSERT INTO gaz_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Isaan kunneen ilmaan Seeʼiir namicha gosa Hoorii kanneen biyya sana keessa jiraachaa turanii dha; isaanis: Looxaan, Sobaal, Zibeʼoon, Aannaa, ");
INSERT INTO gaz_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Diishoon, Eezerii fi Diishaan. Ilmaan Seeʼiir kanneen biyya Edoom keessaa kunneen hangafoota hoorotaa turan. ");
INSERT INTO gaz_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ilmaan Looxaan: Hoorii fi Hoomaam. Tiimnaa obboleettii Looxaan. ");
INSERT INTO gaz_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ilmaan Sobaal: Aliwaan, Maanahaat, Eebaal, Shefoo fi Oonaami. ");
INSERT INTO gaz_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ilmaan Zibeʼoon: Ayyaa fi Aannaa. Aannaan kunis namicha utuu harroota abbaa isaa Zibeʼoon tiksuu gammoojjii keessatti burqaa bishaan danfaa argatee dha. ");
INSERT INTO gaz_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ijoollee Aannaa: Diishoonii fi Oholiibaamaa intala Aannaa. ");
INSERT INTO gaz_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ilmaan Diishoon: Hemdaan, Eshbaan, Yitraanii fi Keraan. ");
INSERT INTO gaz_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ilmaan Eezeri: Bilhaan, Zaawaanii fi Aqaan. ");
INSERT INTO gaz_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ilmaan Diishaan: Uuzii fi Araan. ");
INSERT INTO gaz_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Isaan kunneen hangafoota Hoorotaa ti: Looxaan, Sobaali, Zibeʼoon, Aannaa, ");
INSERT INTO gaz_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Diishoon, Eezerii fi Diishaan. ");
INSERT INTO gaz_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Mootonni utuu mootiin Israaʼel tokko iyyuu hin moʼin dura Edoom keessatti moʼan kanneen turan: ");
INSERT INTO gaz_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Belaa ilmi Beʼoor mootii Edoom taʼe. Magaalaan isaa Diinhaabaa jedhamee moggaafame. ");
INSERT INTO gaz_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Belaa duunaan Yoobaab ilmi Zeraa namichi Bozraa iddoo isaa buʼee mootii taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yoobaab duunaan Hushaam namichi biyya Teemaan iddoo isaa buʼee mootii taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushaam duunaan Hadaad ilmi Bedad inni biyya Moʼaabitti Midiyaanin moʼate sun iddoo isaa buʼee mootii taʼe. Maqaan magaalaa isaa Aawiit jedhame. ");
INSERT INTO gaz_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaad duunaan Samlaan namichi Masreeqaa iddoo isaa buʼee mootii taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlaan duunaan Shaawul namichi biyya Rehoobooti ishee laga bira jirtu sanaa iddoo isaa buʼee mootii taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaawul duunaan Baʼaal-Haanaan ilmi Akboor iddoo isaa buʼee mootii taʼe. ");
INSERT INTO gaz_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Baʼaal-Haanaan ilmi Akboor duunaan immoo Hadaad iddoo isaa buʼee mootii taʼe. Magaalaan isaas Faaʼuu jedhame. Maqaan niitii isaa immoo Maheexabiʼeel jedhama ture. Isheenis intala Maxreed intala Mee-Zaahaab turte. ");
INSERT INTO gaz_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Hangafoonni Esaawu irraa dhalatan akkuma gosa gosa isaaniittii fi akkuma naannoo jireenya isaaniitti maqaa maqaan kanneenii dha: Tiimnaa, Aalwaa, Yeteeti, ");
INSERT INTO gaz_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholiibaamaa, Eelaa, Phiinoon, ");
INSERT INTO gaz_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Qenaz, Teemaan, Mibzaar, ");
INSERT INTO gaz_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magidiiʼeelii fi Iiraam. ");
INSERT INTO gaz_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaaqoob biyya abbaan isaa ture, Kanaʼaan keessa jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Seenaan maatii Yaaqoob kana. Yoosef yeroo dargaggeessa waggaa kudha torba turetti obboloota isaa, ilmaan niitota abbaa isaa jechuunis ilmaan Bilihaatii fi Zilfaa wajjin bushaayee tiksa ture; innis waaʼee obboloota isaa oduu hamaa abbaa isaatiif fide. ");
INSERT INTO gaz_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Israaʼel waan bara dullumaa keessa isa dhalcheef ilmaan isaa hunda caalaa Yoosefin jaallata ture; innis qoloo faayeffame hojjeteef. ");
INSERT INTO gaz_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Obboloonni isaas yommuu akka abbaan isaanii isaan hunda caalaa isa jaallate hubatanitti Yoosefin jibban; afaan nagaas itti dubbachuu hin dandeenye. ");
INSERT INTO gaz_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Yoosef abjuu abjootee obboloota isaatti hime; isaanis ittuma caalchisanii isa jibban. ");
INSERT INTO gaz_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Innis akkana isaaniin jedhe; “Mee abjuu ani arge kana dhagaʼaa: ");
INSERT INTO gaz_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nu lafa qotiisaa keessatti bissii midhaanii hidhaa ture; kunoo, bissiin koo ol jedhee dhaabate; bissiiwwan keessan immoo bissii kootti naannaʼanii gad jedhanii sagadaniif.” ");
INSERT INTO gaz_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Obboloonni isaas, “Ati nu irratti mootii taʼuu barbaaddaa? Dhugumaan situ nu bulchaa?” jedhaniin. Isaanis sababii abjuu isaatii fi sababii waan inni dubbateetiif ittuma caalchisanii isa jibban. ");
INSERT INTO gaz_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ergasiis abjuu biraa abjootee obboloota isaatti hime. Akkanas jedheen; “Kunoo, ani abjuu biraa abjoodheera; aduu fi jiʼi, urjiiwwan kudha tokkos gad jedhanii naa sagadu.” ");
INSERT INTO gaz_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yommuu inni waan kana abbaa isaatii fi obboloota isaatti himetti abbaan isaa, “Abjuun ati abjootte kun maali? Ani, haati keetii fi obboloonni kee dhugumaan dhufnee fuula kee duratti gad jennee siif sagadnaa?” jedhee isatti dheekkame. ");
INSERT INTO gaz_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Obboloonni isaa isatti hinaafan; abbaan isaa garuu waan kana garaatti qabate. ");
INSERT INTO gaz_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Gaaf tokko obboloonni isaa bushaayee abbaa isaanii Sheekem bira dheechisuu dhaqan; ");
INSERT INTO gaz_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Israaʼelis Yoosefiin, “Akkuma ati beektu obboloonni kee Sheekem bira bushaayee dheechisaa jiru. Mee kottu ani gara isaaniitti si ergaa” jedhe. Yoosefis, “Kunoo asan jira” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Israaʼel immoo, “Mee dhaqiitii akka obboloonni kee, bushaayeenis nagaa taʼanii fi akka hin taʼin ilaaliitii deebiʼii natti himi” jedheen. Innis akkasiin Sulula Kebrooniitii Sheekemitti isa erge. Yoosefis Sheekem gaʼe; ");
INSERT INTO gaz_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","namichi tokko isa arge; kunoo inni dirree irra jooraa ture; namichi sunis, “Ati maal barbaadda?” jedhee isa gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yoosefis deebisee, “Ani obboloota koon barbaada. Ati iddoo isaan bushaayee isaanii dheechisan mee natti himi” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Namichis deebisee, “Isaan asii deemaniiru; ani ‘Gara Dootaan haa dhaqnu’ jechuu isaanii dhagaʼeera” jedhe. Yoosefis obboloota isaa duukaa buʼee Dotaayin biratti isaan argate. ");
INSERT INTO gaz_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Isaan garuu fagootti isa arganii isa ajjeesuuf utuu inni isaan bira hin gaʼin mariʼatan. ");
INSERT INTO gaz_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Isaanis akkana waliin jedhan; “Kunoo abbaan abjuu sun dhufaa jira! ");
INSERT INTO gaz_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kottaa ajjeefnee boollawwan as jiran keessaa tokkotti isa gannee bineensa hamaatu isa nyaate jenna. Ergasii immoo abjuun isaa maal akka taʼu ilaalla.” ");
INSERT INTO gaz_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruubeen waan kana dhageenyaan isaan harkaa isa baase. Innis akkana jedhe; “Lakkii isa hin ajjeefnu; ");
INSERT INTO gaz_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","dhiiga hin dhangalaasinaa. Gammoojjii keessatti boolla kana keessa isa buusaa malee harka keessaniin isa hin tuqinaa.” Ruubeen isaan harkaa isa baasee gara abbaa isaatti isa deebisuuf akkana jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yeroo Yoosef obboloota isaa bira gaʼetti isaan qoloo inni uffate, qoloo miidhagaa sana isa irraa baasanii, ");
INSERT INTO gaz_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","isa fuudhanii boollatti gad darbatan. Boolli sunis duwwaa ture; bishaanis hin qabu ture. ");
INSERT INTO gaz_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Obboloonni isaa buddeena nyaachuuf tataaʼan; ol jedhaniis kunoo, daldaltoota warra Ishmaaʼeel kanneen Giliʼaadii dhufaa jiran argan. Isaanis urgooftuu, haphee dibataatii fi qumbii gaalawwan isaaniitti feʼatanii Gibxitti geessaa turan. ");
INSERT INTO gaz_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Yihuudaanis obboloota isaatiin akkana jedhe; “Obboleessa keenya ajjeefnee dhiiga isaa dhoksuun buʼaa maalii nuu qaba? ");
INSERT INTO gaz_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kottaa Ishmaaʼeelootatti isa gurgurra malee harka keenyaan isa hin tuqnuu; inni obboleessa keenyaa fi foon keenya.” Obboloonni isaas yaada kana fudhatan. ");
INSERT INTO gaz_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Yommuu daldaltoonni Midiyaan achiin darbuuf dhufanittis obboloonni Yoosef boolla keessaa harkisanii ol isa baasanii meetii saqilii digdamaatti Ishmaaʼeelootatti isa gurguratan; jarris Gibxitti isa geessan. ");
INSERT INTO gaz_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruubeen gara boolla sanaatti deebiʼe; Yoosef boolla sana keessa hin turre; innis uffata ofii isaa tarsaase. ");
INSERT INTO gaz_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Innis gara obboloota isaa dhaqee, “Gurbichi achi hin jiru! Egaa ani eessan dhaqa?” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Isaanis qoloo Yoosef fuudhanii reʼee tokko qalanii qoloo sana dhiiga keessa cuuphan. ");
INSERT INTO gaz_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Qoloo miidhagaa sanas abbaa isaaniitti geessanii, “Nu qoloo kana arganneerra; mee qoloo ilma keetii taʼuu fi taʼuu baachuu isaa ilaali” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Innis qoloo sana beekee, “Kun qoloo ilma kootii ti! Bineensa hamaatu isa nyaate. Dhugumaan Yoosef ciccirameera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Kana irratti Yaaqoob uffata ofii isaa tarsaase; wayyaa gaddaa mudhiitti hidhatee guyyaa baayʼee ilma isaatiif gadde. ");
INSERT INTO gaz_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ilmaan isaatii fi intallan isaa hundinuu isa jajjabeessuuf kaʼan; inni garuu jajjabaachuu didee, “Lakkii ani gaddaa gara ilma koo siiʼoolitti gad buʼa” jedhe. Akkasiin abbaan isaa ni booʼeef. ");
INSERT INTO gaz_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Gidduu sana warri Midiyaan sun Gibxi keessatti Phoxiifaaraa namicha qondaaltota Faraʼoon keessaa tokko ture kan ajajaa waardiyyaa taʼe tokkotti Yoosefin gurguratan. ");
INSERT INTO gaz_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yeroo kanatti Yihuudaan obboloota isaa biraa deemee namicha Adulaam kan Hiiraam jedhamu tokko bira jiraachuuf gad buʼe. ");
INSERT INTO gaz_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Achittis Yihuudaan intala namicha Kanaʼaan kan Shuuwaan jedhamu tokkoo arge; innis ishee fuudhee ishee bira gaʼe; ");
INSERT INTO gaz_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","isheenis ulfooftee ilma deesse; maqaan isaas Eer jedhame. ");
INSERT INTO gaz_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ammas ulfooftee ilma deesse; maqaa isaas Oonaan jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ammas ittuma dabaltee ulfooftee ilma biraa deessee maqaa isaa Sheelaa jettee moggaafte. Isheenis Kiziibitti isa deesse. ");
INSERT INTO gaz_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yihuudaanis Eer ilma isaa hangafticha niitii fuusise; maqaan ishee Taamaar jedhama ture. ");
INSERT INTO gaz_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Garuu Eer ilmi Yihuudaa hangaftichi sun fuula Waaqayyoo duratti hamaa ture; kanaafuu Waaqayyo isa ajjeese. ");
INSERT INTO gaz_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Yihuudaanis Oonaaniin, “Obboleessa keetiif sanyii dhaabuuf jedhiitii niitii obboleessa keetii bira gaʼiitii dirqama waarsummaa keetii isheef guuti” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Oonaan garuu akka ijoolleen dhalattu sun kan isaa hin taane beeke; kanaafuu akka obboleessa isaatiif sanyii hin dhaabneef jedhee yeroo niitii obboleessa isaa bira gaʼu hunda afeetaa lafatti dhangalaasa ture. ");
INSERT INTO gaz_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wanni inni hojjete sun fuula Waaqayyoo duratti hamaa ture; kanaafuu Waaqayyo isas ni ajjeese. ");
INSERT INTO gaz_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Ergasii Yihuudaan niitii ilma isaa Taamaariin, “Hamma ilmi koo Sheelaa guddatutti haadha hiyyeessaa taʼiitii mana abbaa keetii jiraadhu” jedhe. Inni, “Mucaan kunis akkuma obboloota isaa duʼaa laata” jedhee yaadee tureetii. Kanaafuu Taamaar mana abbaa ishee jiraachuu dhaqxe. ");
INSERT INTO gaz_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bara dheeraa booddees intalli Shuuwaa niitiin Yihuudaa duute. Yihuudaanis gadda isaa irraa bayyanannaan gara Tiimnaahitti lafa warra hoolota isaa irraa rifeensa murmuraniitti ol baʼe; michuun isaa Hiiraam namichi Adulaam isa wajjin deeme. ");
INSERT INTO gaz_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Taamaaris, “Kunoo abbaan dhirsa keetii hoolota isaa irraa rifeensa murmuruuf jedhee Tiimnaahitti ol baʼaa jira” jedhanii yeroo itti himanitti, ");
INSERT INTO gaz_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","wayyaa haadha hiyyeessaa of irraa baaftee of dhoksuuf haguuggii haguuggatte; ergasiis balbala Enaayimitti ol galchu kan daandii Tiimnaahitti geessu irra jiru dura teesse. Sheelaa guddatu iyyuu isheen akka niitummaadhaan isaaf hin kennamin beektee turteetii. ");
INSERT INTO gaz_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Yihuudaan yommuu ishee argetti sababii isheen fuula ishee haguuggattee turteef sagaagaltuu ishee seʼe. ");
INSERT INTO gaz_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Innis utuu akka isheen niitii ilma isaa taate hin beekin karaa cina iddoo isheen jirtu ishee bira dhaqee, “Mee kottu si wajjin nan ciisaa” jedheen. Isheenis, “Ati na wajjin ciisuuf maal naa kennita?” jettee isa gaafatte. ");
INSERT INTO gaz_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Inni immoo, “Ani bushaayee koo keessaa ilmoo reʼee tokko siifin erga” jedheen. Isheenis, “Hamma ilmoo sana naa ergitutti waan biraa qabsiisa naa kennitaa?” jetteen. ");
INSERT INTO gaz_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Innis, “Ani qabsiisa maalin siif kenna?” jedheen. Isheenis deebiftee, “Chaappaa kee hidhaa isaa wajjin, ulee qabattee deemtus naa kenni” jetteen. Innis wantoota kanneen kenneefii ishee wajjin ciise; isheenis ni ulfoofte. ");
INSERT INTO gaz_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Erga achii deemtee booddee haguuggii ishee of irraa baaftee wayyaa dhirsi ishee irraa duunaan uffattee turte sana deebiftee uffatte. ");
INSERT INTO gaz_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yihuudaan waan qabsiisa kenne dubartii sana irraa deebifachuuf jedhee karaa michuu isaa namicha Adulaam sanaatiin ilmoo reʼee ergeef; namichi garuu ishee hin argine. ");
INSERT INTO gaz_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Namichis, “Sagaagaltuun Enaayim bira, daandii irra taaʼaa turte sun eessa jirti?” jedhee warra achi jiraatan gaafate. Jarri immoo deebisanii, “Sagaagaltuun tokko iyyuu as hin turre” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Innis gara Yihuudaatti deebiʼee, “Ani dubartittii arguu hin dandeenye. Akkasumas warri iddoo sana jiraatan, ‘Sagaagaltuun tokko iyyuu as hin turre’ jedhan” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yihuudaanis, “Isheen waan qabatte sana haa hambifattu; yoo kanaa achii nu waan kolfaa taanaa. Kunoo ani ilmoo reʼee kana isheef ergeera; ati garuu ishee dhabde” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Gara jiʼa sadii booddee, “Taamaar niitiin ilma keetii sagaagaltuu taateerti; kanaanis isheen amma ulfoofteerti” jedhanii Yihuudaatti himan. Yihuudaan immoo, “Gadi baasaatii ibiddaan gubaa ishee ajjeesaa!” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Isheenis utuma gad baafamaa jirtuu, “Ani abbaa miʼa kanaa irraa ulfaaʼeera” jettee abbaa dhirsa isheetti ergaa ergite. Akkasumas, “Chaappaa fi kirriin isaa, uleen kunis kan eenyuu akka taʼe mee ilaalii addaan baafadhu” jetteen. ");
INSERT INTO gaz_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yihuudaanis miʼa kana beekee, “Sababii ani ilma koo Sheelaatti ishee hin heerumsiisiniif, isheen na caalaa qajeeltuu dha” jedhe. Innis deebiʼee ishee bira hin geenye. ");
INSERT INTO gaz_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Yommuu yeroon daʼumsa ishee gaʼetti, kunoo, ilmaan lakkuutu gadameessa ishee keessa ture. ");
INSERT INTO gaz_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Utuu isheen daʼumsa irra jirtuu inni tokko harka isaa gad baafate; deessiftuunis qabdee, “Isa kanatu dura lafa gaʼe” jettee kirrii diimaa harka isaatti hiite. ");
INSERT INTO gaz_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Akkuma inni harka isaa ol deebifateen kunoo obboleessi isaa dhalate; deessiftuunis, “Ati akkamiin ofuma keetiin cabsitee baate?” jette. Maqaan isaas Faares jedhame. ");
INSERT INTO gaz_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Obboleessi isaa kan kirrii diimaa harka irraa qabu sunis ni dhalate; innis Zaaraa jedhamee moggaafame. ");
INSERT INTO gaz_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yeroo kanatti Yoosef Gibxitti geeffamee ture. Phoxiifaaraan namichi Gibxi qondaalli Faraʼoon kan ajajaa waardiyyaa ture sun Ishmaaʼeeloota achi isa geessan irraa isa bitate. ");
INSERT INTO gaz_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Yoosefis waan Waaqayyo isa wajjin tureef nama milkaaʼaa taʼe; innis mana gooftaa isaa namicha biyya Gibxi sanaa jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Gooftaan isaas akka Waaqayyo isa wajjin jiruu fi akka Waaqayyo waan inni hojjetu hunda keessatti isa milkoomse arge; ");
INSERT INTO gaz_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yoosefis fuula gooftaa isaa duratti fudhatama argatee hojjetaa isaa amanamaa taʼe. Phoxiifaaraanis mana isaa irratti isa muude; waan qabu hundumas akka inni eeguuf imaanaa itti kenne. ");
INSERT INTO gaz_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Gaafa inni mana isaatii fi waan inni qabu hunda irratti isa muudee jalqabee Waaqayyo sababii Yoosefiif jedhee mana namicha Gibxi sanaa eebbise. Eebbi Waaqayyoos waan Phoxiifaaraan manaa fi alaa qabu hunda irra ture. ");
INSERT INTO gaz_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Kanaafuu Phoxiifaaraan waan qabu hunda harka Yoosef jala galche; innis waan nyaatu qofa malee qabeenya isaa tokko illee hin beeku ture. Yoosef dhaaba toleessaa fi miidhagaa ture; ");
INSERT INTO gaz_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","niitiin gooftaa isaas waan kana booddee ija ishee Yoosef irra buufattee, “Kottuu na bira gaʼi!” jetteen. ");
INSERT INTO gaz_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Inni garuu didee akkana isheen jedhe; “Kunoo, gooftaan koo waan mana keessa jiru tokko illee hin beeku; inni waan qabu hunda natti kenneera. ");
INSERT INTO gaz_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mana kana keessatti namni na caalu tokko iyyuu hin jiru. Sababii ati niitii isaa taateef siʼi malee wanni gooftaan koo natti hin kennin tokko iyyuu hin jiru. Yoos ani akkamittan waan hamaa akkasii raawwachuudhaan Waaqatti cubbuu hojjedha ree?” ");
INSERT INTO gaz_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Isheen guyyuma guyyaan Yoosefitti dubbattu iyyuu, inni ishee bira gaʼuu yookaan ishee biratti argamuu illee ni dide. ");
INSERT INTO gaz_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Gaaf tokko Yoosef hojii isaa hojjechuuf mana seene; tajaajiltoota warra mana sanaa keessaas namni tokko iyyuu achi hin turre. ");
INSERT INTO gaz_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Isheenis wayyaa isaa qabattee, “Kottuutii na bira gaʼi!” jetteen. Inni garuu wayyaa isaa isheetti gad lakkisee fiigee manaa baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Isheenis yommuu akka inni wayyaa isaa isheetti gad lakkisee fiigee manaa baʼe argitetti, ");
INSERT INTO gaz_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","hojjettoota mana ishee waamtee akkana jetteen; “Kunoo, inni Ibricha kana akka nutti taphatuuf fide! Inni na bira gaʼuuf natti ol seennaan ani sagalee guddaan iyye. ");
INSERT INTO gaz_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Innis gargaarsa barbaachaaf iyyuu koo dhageenyaan wayyaa isaa na biratti dhiisee fiigee manaa baʼe.” ");
INSERT INTO gaz_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Isheen hamma gooftaan isaa galutti wayyaa isaa of bira keesse. ");
INSERT INTO gaz_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Akkana jettees oduu kana isatti himte: “Garbichi Ibrichi ati nuu fidde sun natti taphachuuf natti ol seene. ");
INSERT INTO gaz_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Garuu akkuma ani gargaarsa barbaachaaf iyyeen inni wayyaa isaa na biratti dhiisee fiigee manaa baʼe.” ");
INSERT INTO gaz_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Gooftaan isaa yommuu oduu niitiin isaa, “Wanni garbichi kee na godhe kana” jettee itti himte sana dhagaʼetti aaree gubate. ");
INSERT INTO gaz_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Gooftaan isaas Yoosefin fuudhee mana hidhaa iddoo hidhamtoonni mootichaa itti eegaman keessa buuse. Taʼus yeroo Yoosef mana hidhaa keessa turetti, ");
INSERT INTO gaz_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Waaqayyo isa wajjin ture; fuula ajajaa mana hidhaa sanaa durattis gaarummaa isaa itti argisiise; akka fudhatamas argatu godhe. ");
INSERT INTO gaz_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ajajaan mana hidhaa sunis namoota mana hidhaa jiran hunda irratti Yoosefin muude; waan achitti hojjetamu hunda irrattis itti gaafatamaa isa godhe. ");
INSERT INTO gaz_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Sababii Waaqayyo isa wajjin turee fi waan inni hojjetu kam iyyuu isaa milkeesseef ajajaan mana hidhaa sun waan itti gaafatama Yoosef jala jiru hundaaf yaaddoo tokko illee hin qabu ture. ");
INSERT INTO gaz_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Kana booddee namichi mootii Gibxiitiif dhugaatii dhiʼeessuu fi namichi buddeena tolchu gooftaa isaanii mootii Gibxi sana gaddisiisan. ");
INSERT INTO gaz_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Faraʼoonis qondaaltota isaa lamaanitti jechuunis itti gaafatamaa dhugaatiitii fi itti gaafatamaa tolchaa buddeenaatti aare; ");
INSERT INTO gaz_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","innis mana ajajaa waardiyyaa keessa mana hidhaa iddoo Yoosef itti hidhamee ture keessa isaan buuse. ");
INSERT INTO gaz_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ajajaan waardiyyaa Yoosefitti isaan kenne; Yoosefis isaan tajaajilaa ture. Jarris guyyaa baayʼee mana hidhaa turan; ");
INSERT INTO gaz_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","isaan lachanuu jechuunis namichi mootii Gibxiitiif dhugaatii dhiʼeessuu fi namichi buddeena tolchu tokkoon tokkoon isaanii halkanuma tokko keessatti abjuu abjootan; tokkoon tokkoon abjuu sanaas hiikkaa mataa isaa qaba ture. ");
INSERT INTO gaz_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Yoosef guyyaa itti aanu ganama isaan bira dhaqe; kunoo utuu gaddanii jiranuus isaan arge. ");
INSERT INTO gaz_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Innis, “Fuulli keessan harʼa maaliif akkana dukkanaaʼa?” jedhee qondaaltota Faraʼoon warra isa wajjin mana gooftaa isaa keessa mana hidhaa turan sana gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Isaanis, “Nu lachuu abjuu abjoonnee nama nuu hiiku dhabne” jedhaniin. Kana irratti Yoosef, “Hiikkaan kan Waaqaa ti mitii? Mee abjuu keessan natti himaa” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Itti gaafatamaan dhugaatii sun akkana jedhee abjuu isaa Yoosefitti himate; “Abjuu koo keessatti kunoo muka wayinii tokkotu fuula koo dura ture; ");
INSERT INTO gaz_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","mukti wayinii sunis damee sadii qaba ture. Innis akkuma lateen daraare; hurbuun ija isaas ni bilchaatte. ");
INSERT INTO gaz_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Xoofoon Faraʼoon na harka ture; anis ija wayinii fuudhee xoofoo Faraʼoonitti cuunfee xoofoo sana harka Faraʼoonitti kenne.” ");
INSERT INTO gaz_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yoosefis akkana jedheen; “Hiikkaan isaa kana; dameewwan sadan sun guyyaa sadii. ");
INSERT INTO gaz_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Guyyaa sadii keessatti Faraʼoon mataa kee ol qaba; taayitaa keettis si deebisa; akkuma yeroo dhugaatii dhiʼeessaafii turte sana atis xoofoo Faraʼoon harka isaatti ni kennita. ");
INSERT INTO gaz_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Garuu yeroo sitti tolutti na yaadadhu; waan gaariis naa godhi. Waaʼee koo Faraʼoonitti himiitii mana hidhaa kanaa na baasi. ");
INSERT INTO gaz_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ana biyya Ibrootaatii hatanii na fidaniitii; biyya kana keessattis ani waan boolla kana keessa na buusisu tokko illee hin hojjenne.” ");
INSERT INTO gaz_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Itti gaafatamaan buddeenaa sunis yommuu akka Yoosef abjuu sanaaf hiikkaa gaarii kenne argetti Yoosefiin akkana jedhe; “Anis abjuu tokkon abjoodhe; kunoo gundoowwan buddeenaa sadii mataa koo irra turan. ");
INSERT INTO gaz_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Gundoo ol aanu irra buddeena gosa garaa garaa kan Faraʼooniif qopheeffametu ture; garuu simbirroonni matuma koo irratti gundoo sana keessaa nyaachaa turan.” ");
INSERT INTO gaz_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yoosef immoo akkana jedhe; “Hiikkaan isaa kana; gundoowwan sadan sun guyyaa sadii. ");
INSERT INTO gaz_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Guyyaa sadii keessatti Faraʼoon mataa kee ol qaba; mukatti si rarraasa. Simbirroonnis foon kee ni nyaatu.” ");
INSERT INTO gaz_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Guyyaan sadaffaan guyyaa itti Faraʼoon dhalate ture; Faraʼoonis qondaaltota isaatiif cidha qopheesse. Innis itti gaafatamaa dhugaatiitii fi itti gaafatamaa buddeenaa sana fuula qondaaltota isaa duratti dhiʼeesse: ");
INSERT INTO gaz_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Itti gaafatamaa dhugaatii sana hojii isaatti deebise; namichi xoofoo sana ammas harka Faraʼoonitti kenne. ");
INSERT INTO gaz_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Itti gaafatamaa buddeenaa sana garuu akkuma Yoosef abjuu isaanii hiikeefitti rarraase. ");
INSERT INTO gaz_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Taʼus itti gaafatamaan dhugaatii sun Yoosefin ni irraanfate malee isa hin yaadanne. ");
INSERT INTO gaz_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Erga waggaan lama guutuun darbee booddee Faraʼoon abjuu tokko abjoote. Kunoo inni qarqara laga Abbayyaa dhaabachaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","Kunoo, saawwan babbareedoo fi gagabbatoon torba laga Abbayyaa keessaa ol baʼan; isaanis shambaqqoo keessa dheedaa turan. ");
INSERT INTO gaz_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Ammas kunoo, saawwan fofokkisoo fi huhuqqatoon kanneen biraa torba laga Abbayyaa keessaa ol baʼanii saawwan ededa lagaa turan sana bira dhadhaabatan. ");
INSERT INTO gaz_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Saawwan fofokkisoo fi huhuqqatoon sunis saawwan babbareedoo fi gagabbatoo torban sana nyaatan. Faraʼoonis hirribaa dammaqe. ");
INSERT INTO gaz_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Ammas deebiʼee rafee abjuu lammaffaa abjoote; kunoo mataan midhaanii torba misee tolee somaa tokko irratti guddachaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Ergasii immoo kunoo mataan midhaan qaqancaroo hobombolettii baʼaa biiftuutiin gubatanii torba biraa bibbiqilan. ");
INSERT INTO gaz_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Mataan midhaan qaqancaroo sanaas mataa misee tole torban sana lilliqimse; Faraʼoonis hirribaa dammaqe; kunoo wanni sunis abjuu ture. ");
INSERT INTO gaz_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Ganama sana yaadni isaa ni jeeqame; inni nama ergee tolfattootaa fi beektota Gibxi hunda waamsifate. Faraʼoonis abjuu isaa isaanitti hime; garuu namni abjuu sana isaaf hiikuu dandaʼu tokko illee hin argamne. ");
INSERT INTO gaz_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Ergasii itti gaafatamaan dhugaatii sun Faraʼooniin akkana jedhe; “Ani harʼa balleessaa koo yaadadheera. ");
INSERT INTO gaz_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Yeroo tokko Faraʼoon tajaajiltoota isaatti aaree anaa fi itti gaafatamaa buddeenaa sana mana ajajaa waardiyyaa keessatti hidhe. ");
INSERT INTO gaz_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Tokkoon tokkoon keenya halkanuma tokkoon abjuu abjoonne; tokkoon tokkoon abjuu sanaas hiikkaa mataa isaa qaba ture. ");
INSERT INTO gaz_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Ibrichi dargaggeessi tokko nu wajjin achi ture; innis tajaajilaa ajajaa eegumsaa ture. Nu abjuu keenya itti himannaan inni tokkoo tokkoo keenyaaf akkuma abjuu keenyaatti hiikkaa isaa nutti hime. ");
INSERT INTO gaz_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Akkuma inni nuu hiike sana taʼe; ani iddoo kootti nan deebiʼe; namichi kaanis ni fannifame.” ");
INSERT INTO gaz_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Faraʼoonis nama ergee Yoosefin waamsise; boolla hidhaa keessaa baasaniis dafanii isa fidan. Innis haaddatee uffata isaas geeddarratee fuula Faraʼoon duratti dhiʼaate. ");
INSERT INTO gaz_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Faraʼoonis Yoosefiin, “Ani abjuu abjoodheen ture; garuu namni tokko iyyuu naa hiikuu hin dandeenye. Ani akka ati yeroo abjuu dhageessu hiikuu dandeessu dhagaʼeera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yoosef immoo, “Ani hiikuu hin dandaʼu; Waaqni garuu Faraʼooniif deebii nagaa ni kenna” jedhee Faraʼooniif deebise. ");
INSERT INTO gaz_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Faraʼoonis Yoosefiin akkana jedhe; “Ani abjuu kootiin qarqara laga Abbayyaa irra dhaabachaan ture; ");
INSERT INTO gaz_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","Kunoo saawwan gagabbatoo fi babbareedoon torba lagicha keessaa ol baʼanii shambaqqoo keessa dheedaa turan. ");
INSERT INTO gaz_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Isaan duubaan immoo saawwan huhuqqatoo, baayʼee fofokkisoo fi qaqalloon biraa torba ol baʼan; ani takkumaa saawwan fofokkisoo akkanaa guutummaa biyya Gibxi keessatti hin argine. ");
INSERT INTO gaz_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Saawwan huhuqqatoo fi fofokkisoon sun saawwan gagabbatoo duraan ol baʼan torban sana nyaatan. ");
INSERT INTO gaz_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Garuu erga isaan nyaatanii booddee namni tokko illee akka isaan saawwan sana nyaatan beekuu hin dandeenye; isaan akkuma utuu hin nyaatiniin dura turan sana fofokkisoo turaniitii. Anis hirribaa nan dammaqe. ");
INSERT INTO gaz_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","“Akkasumas ani abjuu kootiin mataa midhaanii torba kan misee fi gaggaarii somaa tokko irratti guddachaa jiru nan arge. ");
INSERT INTO gaz_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Isaan duubaanis kunoo mataan midhaanii cocoollagaan, qaqallaan kan hobombolettii baʼa biiftuutiin gubate torba ol baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Mataawwan midhaanii qaqalʼaan sun mataa midhaanii gaggaarii torban sana liqimsan; anis waan kana tolchitootatti nan hime; garuu namni tokko iyyuu naa ibsuu hin dandeenye.” ");
INSERT INTO gaz_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yoosef immoo Faraʼooniin akkana jedhe; “Abjuun Faraʼoon lamaanuu tokkuma. Waaqni waan hojjechuuf jiru Faraʼoonitti mulʼiseera. ");
INSERT INTO gaz_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Saawwan babbareedoon torba waggaa torba; mataawwan midhaanii gaggaarii torbas waggaa torba; abjuun sun tokkuma. ");
INSERT INTO gaz_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Saawwan qaqalloo fi fofokkisoon torban duubaan ol baʼanis waggaa torba; mataawwan midhaanii qaqancaroon hobombolettii baʼa biiftuutiin gubatan torban immoo waggoota beelaa torba. ");
INSERT INTO gaz_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","“Wanni kun akkuma ani Faraʼoonitti himee dha. Waaqni waan hojjechuuf jiru Faraʼoonitti argisiiseera. ");
INSERT INTO gaz_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Barri quufaa guddaan isaa torba biyya Gibxi guutuutti ni dhufa; ");
INSERT INTO gaz_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","isaan booddeedhaan garuu waggoonni beelaa torba ni dhufu. Quufni biyya Gibxi hundi ni irraanfatama; beelli sunis biyya balleessa. ");
INSERT INTO gaz_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Waan beelli duubaan dhufu sun baayʼee hamaa taʼuuf quufni biyyattii hin yaadatamu. ");
INSERT INTO gaz_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Abjuun kun bifa lamaan Faraʼoonitti kennamuun isaa waan dubbichi Waaqaan murteeffameef dha; Waaqnis waan kana dafee ni raawwata. ");
INSERT INTO gaz_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","“Kanaafuu Faraʼoon nama hubataa fi beekaa tokko filatee biyya Gibxi irratti haa muudu. ");
INSERT INTO gaz_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Faraʼoon akka isaan waggoota quufaa torban keessa midhaan biyya Gibxiitii galfamu harka shan keessaa harka tokko walitti qabaniif qondaaltota biyya irratti haa muudu. ");
INSERT INTO gaz_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Isaanis waggoota gaarii dhufuuf jiran kana keessa midhaan hunda walitti haa qaban; akka nyaataaf taʼuufis midhaan kana taayitaa Faraʼoon jalatti magaalaawwan keessatti haa kuusan; haa eeganis. ");
INSERT INTO gaz_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Midhaan kunis akka biyyattiin beelaan hin badneef waggoota beelaa torban Gibxitti dhufuuf jiru keessa akka fayyaduuf biyyattiidhaaf ol haa kaaʼamu.” ");
INSERT INTO gaz_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Dubbichis Faraʼoonii fi qondaaltota isaa hunda biratti gaarii ture. ");
INSERT INTO gaz_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Faraʼoonis, “Nama akka namicha kanaa kan Hafuurri Waaqaa keessa jiru argachuu dandeenyaa ree?” jedhee isaan gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Faraʼoonis Yoosefiin akkana jedhe; “Erga Waaqni waan kana hunda sitti mulʼise, namni akka kee hubataa fi beekaa taʼe tokko iyyuu hin jiru. ");
INSERT INTO gaz_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ati masaraa koo irratti itti gaafatamaa taata; sabni koo hundinuus ajaja kee jalatti bula. Ani ulfina teessoo qofaan si caala.” ");
INSERT INTO gaz_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Faraʼoonis Yoosefiin, “Ilaa, ani biyya Gibxi hunda irratti si muudeera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Ergasii Faraʼoon qubeelaa chaappaa isaa quba isaa irraa baasee quba Yoosefitti kaaʼe. Uffata quncee talbaa haphii irraa hojjetame isatti uffise; amartii warqee morma isaatti kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Innis gaarii isaa isa lammaffaa irra isa teessise; namoonnis, “Sagadaa!” jechaa fuula isaa dura deemanii iyyaa turan; akkanaan Faraʼoon biyya Gibxi hunda irratti isa muude. ");
INSERT INTO gaz_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Ergasiis Faraʼoon Yoosefiin, “Ani Faraʼoonii dha; garuu ajaja kee malee namni guutummaa Gibxi harka isaa yookaan miilla isaa sochoosu tokko iyyuu hin jiru” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Faraʼoonis Yoosefiif maqaa Zaafenaat-Phaneʼaa jedhamu baase; intala Phooxiiferaa lubicha magaalaa Ooni kan Aasenati jedhamtu illee itti heerumsiise. Yoosefis biyya Gibxi hunda keessa naannaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yoosef yeroo tajaajila Faraʼoon mooticha Gibxi jalqabetti nama waggaa soddomaa ture; innis fuula Faraʼoon duraa baʼee deemee biyya Gibxi hunda keessa nanaannaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Waggoota quufaa torban sana keessa lafti midhaan akka malee baayʼatu kennite. ");
INSERT INTO gaz_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yoosefis midhaan waggoota torban sana keessa Gibxii galfame hunda walitti qabee magaalaawwan keessatti kuuse. Midhaan lafa qotiisaa naannoo magaalaas tokkoo tokkoo magaalaa sanaa keessatti kuuse. ");
INSERT INTO gaz_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yoosefis midhaan baayʼinni isaa guddaa akka cirracha galaanaa taʼe kuuse. Waan midhaan sun safaramuu hin dandaʼaminiif inni safaruu dhiise. ");
INSERT INTO gaz_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Yoosef utuu waggoonni beelaa sun hin dhufin dura Aasenati intala Phooxiiferaa lubicha magaalaa Ooni irraa ilmaan lama dhalche. ");
INSERT INTO gaz_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yoosefis, “Waaqni rakkina koo hundaa fi mana abbaa koo hunda na irraanfachiiseera” jedhee maqaa ilma isaa hangaftichaa Minaasee jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","“Waaqni biyya ani itti rakkadhe keessatti na baayʼiseera” jedhee ilma isaa isa lammaffaa immoo Efreem jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Gibxi keessatti waggoonni quufaa torban sun darbee, ");
INSERT INTO gaz_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","akkuma Yoosef dubbate sana waggoonni beelaa torba jalqabe. Biyyoota biraa hunda keessa beelatu ture; biyya Gibxi guutuu keessa garuu midhaanitu ture. ");
INSERT INTO gaz_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Yeroo Gibxi guutuun beelaʼuu jalqabetti namoonni midhaan barbaadanii Faraʼoonitti iyyatan; Faraʼoon immoo warra Gibxi hundumaan, “Yoosef bira dhaqaatii waan inni isinitti himu godhaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Beelli guutuummaa biyyattii keessa babalʼannaan Yoosef mankuusaalee hundumaa banee namoota Gibxitti midhaan gurgure; beelli Gibxi hunda keessatti hammaatee tureetii. ");
INSERT INTO gaz_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Waan guutuu addunyaa irratti beelli hammaateef biyyoonni hundinuu Yoosef irraa midhaan bitachuuf gara Gibxi dhufaa turan. ");
INSERT INTO gaz_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaaqoob yommuu akka Gibxi keessa midhaan jiru dhagaʼetti, ilmaan isaatiin, “Isin maaliif wal ilaaltu?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Itti fufees, “Kunoo ani akka Gibxi keessa midhaan jiru dhagaʼeera. Akka nu duʼa jalaa baanee jiraannuuf gad buʼaatii achii midhaan nuu bitaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Obboloota Yoosef keessaa kudhan Gibxi keessaa midhaan bituuf gad buʼan. ");
INSERT INTO gaz_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yaaqoob garuu balaatu isa irra gaʼa jedhee waan sodaateef obboleessa Yoosef Beniyaamin isaan wajjin hin ergine. ");
INSERT INTO gaz_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Beelli biyya Kanaʼaan keessa waan tureef ilmaan Israaʼelis warra midhaan bitachuu dhaqan wajjin deeman. ");
INSERT INTO gaz_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yoosefis bulchaa biyyattii kan uummata biyyattii hundatti midhaan gurguru ture. Obboloonni Yoosefis yommuu achi gaʼanitti fuula isaaniitiin lafatti gombifamanii sagadaniif. ");
INSERT INTO gaz_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yoosef akkuma obboloota isaa argeen isaan beeke; garuu akkuma nama isaan hin beekneetti afaan hamaa isaanitti dubbatee, “Isin eessaa dhuftan?” jedhee isaan gaafate. Jarris, “Midhaan bitachuuf jennee Kanaʼaanii dhufne” jedhanii deebisan. ");
INSERT INTO gaz_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yoo Yoosef obboloota isaa beeke iyyuu jarri isa hin beekne. ");
INSERT INTO gaz_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Innis abjuu waaʼee isaanii abjoote sana yaadatee, “Isin basaastota dadhabbii biyyattii basaasuuf dhuftanii dha!” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Isaan immoo akkana jedhanii deebisan; “Yaa gooftaa akkas miti; nu garboonni kee midhaan bitachuu dhufne. ");
INSERT INTO gaz_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nu hundi ilmaan abbaa tokkoo ti; nu garboonni kee namoota amanamoo dha malee basaastota miti.” ");
INSERT INTO gaz_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Innis, “Akkas miti; isin dadhabbii biyyattii basaasuu dhuftan” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Isaan garuu akkana jedhanii deebisan; “Nu garboonni kee obboloota kudha lama, ilmaanuma abbaa tokkoo kan biyya Kanaʼaan jiraatuu ti. Kunoo quxisuun hunda keenyaa amma abbaa keenya bira jira; inni tokko garuu hin jiru.” ");
INSERT INTO gaz_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yoosef garuu akkana jedheen; “Akkuma ani isiniin jedhe sana isin basaastota! ");
INSERT INTO gaz_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Akki isin ittiin qoramtan kana; ani maqaa Faraʼooniin nan kakadha; yoo obboleessi keessan quxisuun sun as dhufe malee isin asii hin sochootan. ");
INSERT INTO gaz_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Akka inni dhaqee obboleessa keessan fiduuf of keessaa nama tokko ergaa; isin warri haftan immoo mana hidhaatti galfamtu; akkasiinis dubbiin keessan qoratamee akka dhugaa taʼee fi akka dhugaa hin taʼin ni ilaalama; yoo kanaa achii, ani maqaa Faraʼooniin nan kakadha; isin dhugumaan basaastota!” ");
INSERT INTO gaz_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Innis hunda isaanii guyyaa sadii mana hidhaa keessa turse. ");
INSERT INTO gaz_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Guyyaa sadaffaatti Yoosef akkana isaaniin jedhe; “Isin waan kana godhaa; ni jiraattu; ani Waaqa nan sodaadhaatii. ");
INSERT INTO gaz_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Isin yoo namoota amanamoo taatan obboloota keessan keessaa tokko as mana hidhaa haa turu; warri kaan garuu deemaa; maatii keessan kanneen beelaʼaniif midhaan geessaa. ");
INSERT INTO gaz_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Garuu obboleessa keessan quxisuu naa fidaa; akkasiin dubbiin keessan ni mirkaneeffama; isinis hin duutan.” Isaanis akkasuma godhan. ");
INSERT INTO gaz_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Isaanis akkana waliin jedhan; “Nu dhugumaan sababii obboleessa keenyaatiif adabamaa jirra. Yeroo inni nu kadhatetti lubbuun isaa hammam akka dhiphachaa turte argineerra; nu garuu isa dhagaʼuu didne; dhiphinni kun kanaaf nutti dhufe.” ");
INSERT INTO gaz_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Ruubeen immoo, “Ani, ‘Gurbaa kana hin miidhinaa’ jedhee isinitti hin himnee? Isin garuu na dhagaʼuu diddan! Kunoo nu dhiiga isaatti ni gaafatamna” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Sababii Yoosef karaa nama afaan hiikuutiin isaanitti dubbachaa tureef isaan akka inni waan isaan dubbatan hubatu hin beekne. ");
INSERT INTO gaz_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yoosef achi isaan irraa garagalee booʼuu jalqabe; ergasii immoo isaanitti garagalee isaanitti dubbate. Simiʼooninis isaan keessaa baasisee fuuluma isaanii duratti hiisise. ");
INSERT INTO gaz_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yoosef akka qalqalloo isaaniitti midhaan guutaniif, akka meetii tokkoo tokkoo isaanii deebisanii qalqalloo isaanii keessa isaaniif kaaʼanii fi akka karaa isaaniitiif galaa isaaniif kennan ajaje. Erga wanni kun isaaniif godhamee booddee ");
INSERT INTO gaz_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","jarri midhaan isaanii harroota isaaniitti feʼatanii qajeelan. ");
INSERT INTO gaz_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Isaan keessaa inni tokko iddoo bulanitti harree isaatiif nyaata kennuuf jedhee qalqalloo isaa bane; kunoo afaan qalqalloo keessattis meetii isaa argate. ");
INSERT INTO gaz_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Innis obboloota isaatiin, “Meetiin koo naa deebiʼeera; kunoo qalqalloo koo keessa jira” jedhe. Kana irratti isaan naʼanii walitti garagalanii hollachaa, “Wanni Waaqni nutti hojjete kun maali?” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Isaanis gara biyya Kanaʼaan abbaa isaanii Yaaqoob bira dhufanii waan isaan irra gaʼe hunda isatti himan; akkanas jedhan; ");
INSERT INTO gaz_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","“Namichi gooftaa biyya sanaa taʼe afaan hamaa nutti dubbatee akka waan nu biyyattii basaasuu dhaqneetti nu lakkaaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nu garuu akkana jenneen; ‘Nu namoota amanamoo dha malee basaastota miti. ");
INSERT INTO gaz_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nu obboloota kudha lama ilmaanuma abbaa tokkoo ti; inni tokko hin jiru; quxisuun hunda keenyaa immoo abbaa keenya bira biyya Kanaʼaan jira.’ ");
INSERT INTO gaz_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","“Namichi gooftaa biyya sanaa taʼe immoo akkana nuun jedhe; ‘Akki ani akka isin namoota amanamoo taatanii fi hin taʼin ittiin beeku kana; obboloota keessan keessaa isa tokko as na biratti dhiisaatii maatii keessan kan beelaʼaniif midhaan geessaa. ");
INSERT INTO gaz_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Garuu akka ani akka isin namoota amanamoo malee basaastota hin taʼin beekuuf obboleessa keessan isa quxisuu sana naa fidaa. Ergasii ani obboleessa keessan deebisee isinii kenna; isinis biyya kana keessatti daldalachuu ni dandeessu.’ ” ");
INSERT INTO gaz_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Yommuu isaan qalqalloo isaanii keessaa midhaan garagalchanitti, kunoo meetiin tokkoo tokkoo isaanii hidhaa hidhaan qalqalloo isaanii keessa ture. Isaanii fi abbaan isaanii yeroo meetii hidhame sana arganitti ni rifatan. ");
INSERT INTO gaz_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Abbaan isaanii Yaaqoobis, “Isin ijoollee koo na dhabsiiftan. Yoosef hin jiru; Simiʼoonis hin jiru. Amma immoo Beniyaamin fudhachuu barbaaddu. Wanni hundi natti hammaateera!” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Ruubeen immoo abbaa isaatiin, “Yoo ani deebisee isa siif fiduu baadhe ilmaan koo lamaan ajjeesuu ni dandeessa; isa imaanaa natti kenni; ani deebisee isa nan fida” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaaqoob garuu akkana jedhe; “Ilmi koo isin wajjin achi gad hin buʼu; obboleessi isaa duʼeera; isa qofatu hafe. Yoo karaa keessan irratti balaan isa irra gaʼe, isin akka arriin koo gaddaan awwaala seenu gootu.” ");
INSERT INTO gaz_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Amma illee beelli biyyattiitti baayʼee hammaatee ture. ");
INSERT INTO gaz_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Erga isaan midhaan biyya Gibxiitii fidan sana nyaatanii fixanii booddee abbaan isaanii, “Ammas dhaqaatii midhaan xinnoo dabalaa nuu bitaa” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yihuudaan immoo akkana isaan jedhe; “Namichi sun, ‘Yoo obboleessi keessan isin wajjin dhufe malee isin lammata ija koo hin argitan’ jedhee of eeggannoo cimaa nuu kenne. ");
INSERT INTO gaz_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Yoo ati obboleessa keenya nu wajjin ergite nu dhaqnee midhaan siif binna. ");
INSERT INTO gaz_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Sababii namichi sun, ‘Yoo obboleessi keessan isin wajjin dhufe malee isin lammata ija koo hin argitan’ nuun jedheef, yoo ati isa ergite malee nu gad hin buunu.” ");
INSERT INTO gaz_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israaʼel immoo, “Isin maaliif akka obboleessa biraa qabdan namichatti himuudhaan rakkina natti fiddan?” jedhee gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Isaanis akkana jedhanii deebisan; “Namichi waaʼee mataa keenyaatii fi waaʼee maatii keenyaa jabeessee nu gaafate. Innis, ‘Abbaan keessan amma iyyuu jiraa? Obboleessa biraa qabduu?’ jedhee nu gaafate; nu gaaffiidhuma isaa deebifneef. Yoos akka inni, ‘Obboleessa keessan as fidaa’ nuun jedhu akkamiin beekuu dandeenya ree?” ");
INSERT INTO gaz_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Yihuudaanis abbaa isaa Israaʼeliin akkana jedhe; “Akka nu, atii fi ijoolleen keenya duʼa jalaa baanee jiraannuuf gurbicha na wajjin ergi; nu kaanee deemnaatii. ");
INSERT INTO gaz_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ani wabii isaafin taʼa; waaʼee isaas anuma mataa koo gaafachuu ni dandeessa. Yoo ani deebisee isa siif fidee fuula kee dura dhaabuu baadhe, ani bara jireenya koo guutuu fuula kee duratti balleessaa kanatti nan gaafatama. ");
INSERT INTO gaz_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Utuu turuu baannee silaa yoona yeroo lama dhaqnee deebineerra ture.” ");
INSERT INTO gaz_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Kana irratti abbaan isaanii Israaʼel akkana isaaniin jedhe; “Erga akkas taʼee waan kana godhaa; oomisha biyya kanaa filatamaa keessaa kennaa tokko tokko jechuunis haphee dibatan xinnoo ishee, damma xinnaa isaa, urgooftuu fi qumbii xinnoo ishee, ocholoonii fi lawuzii xinnoo ishee geessaatii namichaaf kennaa. ");
INSERT INTO gaz_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Isin waan meetii afaan qalqalloo keessanii keessa kaaʼamee isinii deebiʼe sana deebisuu qabdaniif meetii sana harka lama fudhadhaatii deemaa; meetiin sun dogoggoraan dhufe taʼaatii. ");
INSERT INTO gaz_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Obboleessa keessanis fudhadhaatii dafaa gara namichaatti deebiʼaa. ");
INSERT INTO gaz_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Akka inni obboleessa keessan kaanii fi Beniyaam illee isin wajjin deebisee erguuf Waaqni Waan Hunda Dandaʼu akka namichi garaa isinii laafu haa godhu. Ani yoo ijoollee dhabe illee ijoollee nan dhaba.” ");
INSERT INTO gaz_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Namoonni sunis kennaawwan sana, meetii sana harka lamaa fi Beniyaaminis fudhatanii ariitiidhaan Gibxitti gad buʼanii fuula Yoosef dura dhadhaabatan. ");
INSERT INTO gaz_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yoosefis yommuu Beniyaamin isaan biratti argetti hangafa hojjettoota mana isaatiin, “Namoota kana mana kootti geessi; horii tokko qalii nyaata qopheessi; isaan saʼaatii jaʼatti na wajjin nyaatuutii” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Namichi sunis akkuma Yoosef isa ajaje godhe; jara sanas mana Yoosefitti geesse. ");
INSERT INTO gaz_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Namoonni sun yeroo mana Yoosefitti geeffamanitti sodaatanii akkana jedhan; “Nu sababii meetii yeroo jalqabaa deebiʼee afaan qalqalloo keenyaa keessatti argame sanaatiif as fidamne; inni nu rukutee, nu moʼatee, akka garbootaatti nu qabatee harroota keenya fudhachuu barbaada.” ");
INSERT INTO gaz_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Kanaafuu jarri gara hangafa hojjettoota Yoosefitti ol baʼanii balbala manaa duratti itti dubbatan. ");
INSERT INTO gaz_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","Akkanas jedhan; “Yaa gooftaa, nu yeroo jalqabaa midhaan bitachuuf as gad buunee turre. ");
INSERT INTO gaz_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Nus yeroo iddoo bullu geenyee qalqalloo keenya bannetti tokkoon tokkoon keenya afaan qalqalloo keenyaa keessatti meetii keenya akkuma jirutti arganne. Kanaafuu meetii sana deebifnee fidnee dhufneerra. ");
INSERT INTO gaz_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Meetii biraas ittiin midhaan bitachuuf fidnee dhufneerra. Eenyu akka meetii keenya qalqalloo keenya keessa nuu kaaʼes hin beeknu.” ");
INSERT INTO gaz_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Innis deebisee, “Homaa miti; hin sodaatinaa. Waaqni keessan, Waaqni abbaa keessanii qalqalloo keessanitti badhaadhummaa isinii naqeera; meetiin keessan na gaʼee jira” jedheen. Ergasiis Simiʼoonin gara isaaniitti gad baase. ");
INSERT INTO gaz_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Hangafni hojjettootaa sunis jara sana mana Yoosefitti geessee akka isaan miilla isaanii dhiqataniif bishaan kenneef; harroota isaaniitiif immoo okaa kenne. ");
INSERT INTO gaz_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Isaanis achitti akka nyaatan waan dhagaʼaniif dhufaatii Yoosef kan saʼaatii jaʼaatiif kennaa isaanii qopheeffatan. ");
INSERT INTO gaz_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yeroo Yoosef manatti galetti isaan kennaa manatti ol galchanii turan sana kennaniif; fuula isaa durattis lafatti gombifamanii harka fuudhan. ");
INSERT INTO gaz_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Innis nagaa isaan gaafatee, “Abbaan keessan jaarsi isin waaʼee isaa natti himtan sun akkam? Inni amma iyyuu jiraa?” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Jarris, “Tajaajilaan kee abbaan keenya amma iyyuu ni jira; nagumas” jedhanii deebisan. Ulfina isaaf kennuufis gad jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Innis ol ilaalee obboleessa isaa, ilma haadha isaa Beniyaamin argee, “Inni kun obboleessa keessan quxisuu isin waaʼee isaa natti himtan sanaa?” jedhee gaafate. Itti fufees, “Ilma ko, Waaqni si haa eebbisu” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yoosef yommuu obboleessa isaa argetti garaan raafamee dafee gad baʼe; booʼuu barbaadees kutaa mana isaa seenee achitti booʼe. ");
INSERT INTO gaz_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Ergasiis fuula isaa dhiqatee gad baʼe; of jajjabeessees, “Nyaanni haa dhiʼaatu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Jarris sababii warri Gibxi Ibroota wajjin hin nyaanneef Yoosefiif kophaatti, obboloota isaatiif kophaatti, warra Gibxi kanneen isa wajjin nyaataniifis kophaatti dhiʼeessan; Ibroota wajjin nyaachuun warra Gibxi biratti jibbisiisaa tureetii. ");
INSERT INTO gaz_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Namoonni sunis akkuma umurii isaaniitti hangafaa jalqabanii hamma quxisuutti fuula isaa dura tataaʼanii dinqifatanii wal ilaalan. ");
INSERT INTO gaz_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Maaddii Yoosef irraas nyaanni qoodameef; qoodni Beniyaam garuu qooda tokko tokko isaaniitiif kenname dachaa shan taʼa ture. Jarris akkasiin Yoosef wajjin dhuganii itti hoʼe. ");
INSERT INTO gaz_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yoosefis akkana jedhee hangafa hojjettoota mana isaa ajaje; “Qalqalloo jara kanaa hamma baachuu dandaʼutti midhaan itti guuti; meetii tokkoo tokkoo isaaniis afaan qalqalloo isaanii keessa kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Xoofoo koo isa meetii irraa hojjetame immoo meetii inni ittiin midhaan bitachuu dhufe wajjin afaan qalqalloo isa quxisuu sanaa keessa kaaʼi.” Namichis akkuma Yoosef isa ajaje godhe. ");
INSERT INTO gaz_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Namoonni sun akkuma lafti bariiteen harroota isaanii wajjin geggeeffaman. ");
INSERT INTO gaz_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Utuma isaan magaalaa sana irraa hin fagaatin Yoosef hangafa hojjettoota isaatiin akkana jedhe; “Dafii jara kana duukaa buʼi; yommuu qaqqabdutti immoo akkana jedhiin; ‘Isin maaliif waan gaarii waan hamaadhaan deebiftu? ");
INSERT INTO gaz_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Xoofoon kun xoofoo gooftaan koo ittiin dhuguu fi ittiin waa himu mitii? Isin waan kana gochuudhaan waan hamaa hojjettan.’ ” ");
INSERT INTO gaz_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Innis yommuu isaan qaqqabetti waanuma kana isaanitti dubbate. ");
INSERT INTO gaz_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Jarris akkana isaan jedhan; “Gooftaan koo maaliif dubbii akkanaa dubbata? Waan akkanaa hojjechuun tajaajiltoota kee irraa haa fagaatu! ");
INSERT INTO gaz_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Kunoo nu meetii afaan qalqalloo keenyaa keessatti arganne iyyuu biyya Kanaʼaaniitii deebifnee siif fidne. Yoos nu maaliif mana gooftaa keetiitii meetii yookaan warqee hanna ree? ");
INSERT INTO gaz_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Tajaajiltoota kee keessaa namni wanni kun biratti argame kam iyyuu haa duʼu; nu warri hafne immoo garboota gooftaa koo ni taana.” ");
INSERT INTO gaz_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Inni immoo jaraan, “Amma akkuma isin jettan haa taʼu; abbaan wanti kun biratti argame garbicha naaf taʼa; isin warri kaan immoo gad dhiifamtu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Tokkoon tokkoon isaanii dafanii qalqalloo isaanii lafa keeyyatanii hiikan. ");
INSERT INTO gaz_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Hangafni hojjettootaa sunis hangafaa jalqabee hamma quxisuutti sakattaʼe. Xoofoon sunis qalqalloo Beniyaam keessatti argame. ");
INSERT INTO gaz_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Kana irratti isaan uffata isaanii tarsaasan. Hundi isaanii harroota isaanii feʼatanii magaalattiitti deebiʼan. ");
INSERT INTO gaz_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yoosef yeroo Yihuudaa fi obboloonni isaa ol seenanitti amma iyyuu mana keessa ture; isaanis fuula isaa duratti kukkufan. ");
INSERT INTO gaz_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yoosefis, “Wanti isin hojjettan kun maal? Akka namni akka kootii hooda himuudhaan waa arguu dandaʼu isin hin beektanii?” isaaniin jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yihuudaan immoo akkana jedhee deebise; “Nu gooftaa kootiin maal jechuu dandeenya? Nu maal dubbachuu dandeenya? Nu qulqulluu taʼuu keenya akkamiin mirkaneessuu dandeenya? Waaqni balleessaa garboota keetii ifatti baaseera. Kunoo nu garboota gooftaa koo ti; nu hundi keenya, namni xoofoon sun biratti argames garboota kee ti.” ");
INSERT INTO gaz_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yoosef garuu, “Waan akkanaa hojjechuun narraa haa fagaatu! Nama xoofoon biratti argame qofatu garbicha koo taʼa. Warri haftan garuu nagaadhaan gara abbaa keessaniitti deebiʼaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Yihuudaan immoo Yoosefitti dhiʼaatee akkana jedhe: “Maaloo gooftaa ko, akka garbichi kee waan tokko gooftaa kootti dubbatu eeyyamiif. Ati akkuma Faraʼoon taatus garbicha keetti hin aarin. ");
INSERT INTO gaz_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Gooftaan koo, ‘Isin abbaa yookaan obboleessa qabduu?’ jedhee garboota isaa gaafatee ture. ");
INSERT INTO gaz_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nus, ‘Abbaa dulloomaa tokko qabna; ilmi quxisuun bara dulluma isaa keessa isaaf dhalate tokkos jira. Obboleessi isaas duʼeera; ijoollee haati isaa deesse keessaa isa qofatu hafe; abbaan isaa isa jaallata’ jennee turre. ");
INSERT INTO gaz_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","“Atis garboota keetiin, ‘Akka ani ija kootiin isa arguuf naa fidaa’ jette. ");
INSERT INTO gaz_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nus gooftaa kootiin, ‘Mucichi abbaa isaa dhiisee deemuu hin dandaʼu; yoo inni isa dhiisee biraa deeme abbaan isaa ni duʼa’ jenne. ");
INSERT INTO gaz_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ati immoo garboota keetiin, ‘Yoo obboleessi keessan inni quxisuun isin wajjin dhufuu baate, isin lammata fuula koo hin argitan’ jette. ");
INSERT INTO gaz_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","Nus yeroo gara garbicha kee abbaa kootti deebinetti waan gooftaan koo jedhe isatti himne. ");
INSERT INTO gaz_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","“Abbaan keenya, ‘Ammas dhaqaatii midhaan xinnoo dabalaa nuu bitaa’ nuun jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nu garuu, ‘Nu dhaquu hin dandeenyu; yoo obboleessi keenya inni quxisuun nu wajjin jiraate qofa dhaqna. Yoo obboleessi keenya inni quxisuun nu wajjin dhaquu baate nu fuula namichaa arguu hin dandeenyu’ jenne. ");
INSERT INTO gaz_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","“Abbaan koo garbichi kee immoo akkana nuun jedhe; ‘Akka niitiin koo ilmaan lama naa deesse isin ni beektu. ");
INSERT INTO gaz_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Isaan keessaas inni tokko na biraa baʼe; anis, “Inni dhugumaan ciccirameera” nan jedhe. Ani ergasii isa hin argine. ");
INSERT INTO gaz_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Yoo isin isa kanas na duraa fuutanii balaan isa irra gaʼe, isin akka arriin koo gaddaan awwaala seenu gootu.’ ");
INSERT INTO gaz_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","“Kanaafuu amma yeroo ani gara garbicha kee abbaa kootti deebiʼutti, yoo mucichi nu wajjin jiraachuu baate abbaan koo kan jireenyi isaa jireenya mucichaatiin walitti hidhame sun, ");
INSERT INTO gaz_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","akka mucichi nu wajjin hin jirre argee duʼa. Nu garboonni kees akka arriin abbaa keenya garbicha keetii gaddaan awwaala seenu goona. ");
INSERT INTO gaz_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Ani garbichi kee akka mucaan kun nagaadhaan deebiʼu abbaa koo duratti wabii taʼee, ‘Yaa abbaa ko, yoo ani deebisee isa siif fiduu baadhe, ani bara jireenya koo guutuu fuula abbaa koo duratti balleessaa kanatti nan gaafatama!’ jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","“Egaa amma ani garbichi kee iddoo mucichaa garbicha gooftaa koo taʼee asitti nan hafa; mucichi immoo obboloota isaa wajjin haa deebiʼu. ");
INSERT INTO gaz_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Yoo mucichi na wajjin hin jiraatin ani akkamittin gara abbaa kootii deebiʼuu dandaʼa? Waawuu; akka ani gadda abbaa kootti dhufu argu na hin godhin.” ");
INSERT INTO gaz_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Kana irratti Yoosef namoota hunda duratti of qabuu dadhabee, “Namoota hunda fuula koo duraa gad yaasaa!” jedhee iyye. Kanaaf yommuu Yoosef obboloota isaatti of beeksisetti namni tokko iyyuu isa bira hin turre. ");
INSERT INTO gaz_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Sababii inni guddisee booʼeef warri Gibxi ni dhagaʼan; warra masaraa Faraʼoon birattis ni dhagaʼame. ");
INSERT INTO gaz_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yoosefis obboloota isaatiin, “Ani Yoosef; abbaan koo amma iyyuu jiraa?” jedhee gaafate. Obboloonni isaa garuu sababii fuula isaa duratti naʼanii turaniif deebii isaaf kennuu hin dandeenye. ");
INSERT INTO gaz_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Yoosefis obboloota isaatiin, “Mee as natti dhiʼaadhaa” jedhe. Isaan isatti dhiʼaannaan inni akkana jedhe; “Ani Yoosef obboleessa keessan isa isin Gibxitti gurgurtan sanaa dha! ");
INSERT INTO gaz_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Ammas sababii asitti na gurgurtaniif hin gaabbinaa; ofittis hin aarinaa. Waaqni lubbuu baraaruuf jedhee isin dura na ergeeraatii. ");
INSERT INTO gaz_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Waggoota lamaan kana beelatu biyyattii keessa ture; waggoota shanan dhufan keessas lafa qotachuu fi midhaan galfachuun hin jiru. ");
INSERT INTO gaz_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Waaqni lafa irratti sanyii isiniif hambisuu fi furii guddaadhaan lubbuu keessan oolchuuf jedhee isin dura na erge. ");
INSERT INTO gaz_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","“Waaqatu as na erge malee isin miti. Inni Faraʼooniif abbaa na godhe; warra mana isaa jiran hunda irratti gooftaa, biyya Gibxi hunda irratti immoo bulchaa na godhe. ");
INSERT INTO gaz_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","Ammas dafaa gara abbaa kootti deebiʼaatii akkana isaan jedhaa; ‘Ilmi kee Yoosef akkana jedha: Waaqni Gibxi hunda irratti gooftaa na godheera. Gara kootti gad buʼi; hin turinis. ");
INSERT INTO gaz_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Ati biyya Gooshen keessa ni jiraatta; ati, ijoolleen keetii fi ijoolleen ijoollee keetii, bushaayeen kee, loon keetii fi wanni ati qabdu hundi natti dhiʼaattanii jiraatu. ");
INSERT INTO gaz_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Sababii amma iyyuu waggaan beelaa shan dhufaa jiruuf ani achitti sin soora; yoo kanaa achii atii fi warri mana kee jiraatan, wanni ati qabdu hundinuus ni rakkattu.’ ");
INSERT INTO gaz_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","“Akka namni isinitti dubbachaa jiru kun anuma taʼe kunoo, iji keessan, iji obboleessa koo Beniyaamis ni arga. ");
INSERT INTO gaz_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Ulfina Gibxi keessatti naa kenname hundaa fi waan argitan hunda abbaa kootti himaa. Abbaa koos dafaatii as fidaa.” ");
INSERT INTO gaz_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Ergasiis morma obboleessa isaa Beniyaamitti marmee booʼe; Beniyaamis booʼaa isa hammate. ");
INSERT INTO gaz_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yoosefis obboloota isaa hunda dhungatee itti booʼe. Ergasii obboloonni isaa isa wajjin haasaʼan. ");
INSERT INTO gaz_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Yommuu akka obboloonni Yoosef dhufan masaraa Faraʼoonitti dhagaʼametti, Faraʼoonii fi qondaaltonni isaa ni gammadan. ");
INSERT INTO gaz_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Faraʼoonis Yoosefiin akkana jedhe; “Obboloota keetiin akkana jedhi; ‘Waan kana godhaa: Horii keessan feʼadhaa biyya Kanaʼaaniitti deebiʼaatii ");
INSERT INTO gaz_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","abbaan keessanii fi maatiiwwan keessan natti fidaa. Ani lafa biyya Gibxi keessaa lafa hunda caalu isiniif nan kenna. Isin cooma biyyattii ni nyaattu.’ ");
INSERT INTO gaz_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","“Akkasumas akkana jedhii isaanitti himi; ‘Waan kana godhaa: Ijoollee keessaniifis, niitota keessaniifis biyya Gibxiitii gaariiwwan fudhadhaa; abbaa keessanis fidaatii kottaa. ");
INSERT INTO gaz_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Waaʼee qabeenya keessanii hin yaaddaʼinaa; wanni biyya Gibxi guutuu keessaa waan hunda caalu kan keessan taʼaatii.’ ” ");
INSERT INTO gaz_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Ilmaan Israaʼelis akkasuma godhan. Yoosefis akkuma Faraʼoon isa ajajetti gaariiwwan kenneefii karaa isaaniitiif illee galaa galaaseef. ");
INSERT INTO gaz_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Tokkoo tokkoo isaaniitiif wayyaa kenne; Beniyaamiif garuu meetii saqilii dhibba sadiitii fi wayyaa irraa jalaa shan kenne. ");
INSERT INTO gaz_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Abbaa isaatiif immoo harroota, wanni biyya Gibxi gaggaariin itti feʼame kudhan, akkasumas harroota dhaltuu midhaan, buddeenaa fi galaan biraa karaa isaatiif itti feʼame kudhan erge. ");
INSERT INTO gaz_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Innis akkasitti obboloota isaa erge; innis yeroo isaan qajeelanitti, “Karaatti wal hin lolinaa!” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Isaanis Gibxi keessaa ol baʼanii gara biyya Kanaʼaan abbaa isaanii Yaaqoob bira dhaqan. ");
INSERT INTO gaz_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Isaanis, “Yoosef amma iyyuu jira! Biyya Gibxi guutuu iyyuu isumatu bulcha” jedhaniin. Yaaqoob immoo naasuudhaan of wallaale; jara amanuus hin dandeenya. ");
INSERT INTO gaz_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Garuu yeroo jarri waan Yoosef isaaniin jedhe hunda isatti himanii innis gaariiwwan Yoosef isa fichisiisuuf ergeef sana argetti lubbuun abbaa isaanii Yaaqoob ni bayyanatte. ");
INSERT INTO gaz_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Israaʼelis, “Na gaʼa! Ilmi koo Yoosef amma iyyuu jira. Anis utuun hin duʼin dhaqee isa nan arga” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Israaʼel waan qabu hunda fudhatee kaʼe; yeroo Bersheebaa gaʼettis Waaqa abbaa isaa Waaqa Yisihaaqiifis aarsaa dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Waaqnis halkan mulʼataan, “Yaaqoob! Yaaqoob!” jedhee Israaʼelitti dubbate. Innis, “Kunoo ani as jira” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Waaqnis akkana jedhe; “Ani Waaqayyo, Waaqa abbaa keetii ti. Gibxitti gad buʼuu hin sodaatin; ani achitti saba guddaa sin taasisaatii. ");
INSERT INTO gaz_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ani si wajjin Gibxitti gad buʼee deebisee sin fida. Harkuma Yooseftu ija kee walitti siif qaba.” ");
INSERT INTO gaz_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Yaaqoobis Bersheebaadhaa kaʼee qajeele; ilmaan Israaʼelis abbaa isaanii Yaaqoob, ijoollee isaaniitii fi niitota isaanii gaariiwwan Yaaqoobin baachuuf Faraʼoon erge sana irra teessisan. ");
INSERT INTO gaz_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Yaaqoobii fi sanyiin isaa hundis horii isaaniitii fi qabeenya Kanaʼaanitti horatan of faana fudhatanii Gibxitti godaanan. ");
INSERT INTO gaz_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","Innis sanyii isaa hunda jechuunis ilmaan isaa, ilmaan ilmaan isaa, intallan isaatii fi intallan ilmaan isaa fudhatee Gibxitti godaane. ");
INSERT INTO gaz_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Maqaawwan ilmaan Israaʼel warra Gibxitti godaanan sanaa jechuunis Yaaqoobii fi sanyiiwwan isaa kanneenii dha: Ruubeen jechuunis ilma Yaaqoob hangafticha. ");
INSERT INTO gaz_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","Ilmaan Ruubeen: Henook, Faluusoo, Hezroonii fi Karmii. ");
INSERT INTO gaz_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ilmaan Simiʼoon: Yemuuʼeel, Yaamiin, Oohad, Yaakiin, Zooharii fi Shaawul ilma dubartii Kanaʼaan sanaa. ");
INSERT INTO gaz_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ilmaan Lewwii: Geershoon, Qohaatii fi Meraarii. ");
INSERT INTO gaz_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ilmaan Yihuudaa: Eeri, Oonaan, Sheelaa, Faaresii fi Zaaraa. Eerii fi Oonaan garuu biyya Kanaʼaanitti duʼan. Ilmaan Faares: Hezroonii fi Hamuul. ");
INSERT INTO gaz_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ilmaan Yisaakor: Toolaa, Fuwaa, Yoobii fi Shimroon. ");
INSERT INTO gaz_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ilmaan Zebuuloon: Sered, Eeloonii fi Yahiliʼeel. ");
INSERT INTO gaz_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Isaan kunneen intala isaa Diinaa dabalatee ilmaan Liyaan kaaba dhiʼa Phaadaan Arraamitti Yaaqoobiif deessee dha. Ilmaanii fi intallan isaa kunneen walumaa galatti soddomii sadii turan. ");
INSERT INTO gaz_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ilmaan Gaad: Ziifiyon, Hagii, Shuunii, Esboon, Eerii, Aroodii fi Ariʼeel. ");
INSERT INTO gaz_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ilmaan Aasheer: Yimnaa, Yishwaa, Yishwii fi Beriiyaa. Obboleettiin isaaniis Seraa dha. Ilmaan Beriiyaa: Hebeerii fi Malkiiʼeel. ");
INSERT INTO gaz_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Isaan kunneen ijoollee Ziifaan Yaaqoobiif deessee dha. Ziifaan ishee Laabaan intala isaa Liyaadhaaf kenne sanaa dha. Isaan walumaa galatti kudha jaʼa turan. ");
INSERT INTO gaz_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ilmaan Raahel niitii Yaaqoob: Yoosefii fi Beniyaam. ");
INSERT INTO gaz_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Minaasee fi Efreem, Aasenati intala Phooxiiferaa lubicha magaalaa Ooni sanaa irraa Gibxi keessatti Yoosefiif dhalatan. ");
INSERT INTO gaz_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ilmaan Beniyaam: Belaa, Beker, Ashbeel, Geeraa, Naʼamaan, Eehii, Roosh, Muufiim, Hufiimii fi Ardi. ");
INSERT INTO gaz_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Isaan kunneen ilmaan Raahel Yaaqoobiif deessee dha; isaanis walumaa galatti nama kudha afur turan. ");
INSERT INTO gaz_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ilmi Daan: Hushiimii dha. ");
INSERT INTO gaz_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ilmaan Niftaalem: Yahizeel, Guunii, Yeexerii fi Shiileem. ");
INSERT INTO gaz_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Isaan kunneen ilmaan Bilihaan Yaaqoobiif deessee dha; Bilihaan ishee Laabaan intala isaa Raaheliif kenne sanaa dha; isaan walumaa galatti nama torba turan. ");
INSERT INTO gaz_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Namoonni Yaaqoob wajjin Gibxitti godaanan utuu niitota ilmaan isaa hin dabalatin sanyiin isaa walumaa galatti jaatamii jaʼa turan. ");
INSERT INTO gaz_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ilmaan Gibxitti Yoosefiif dhalatan lamaan dabalatee miseensonni maatii Yaaqoob warri Gibxitti godaanan walumaa galatti torbaatama turan. ");
INSERT INTO gaz_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yaaqoobis akka inni dhaqee karaa Gooshenitti nama geessu gaafatuuf Yihuudaa of dura gara Yoosefitti erge. Yommuu isaan Gooshen gaʼanitti, ");
INSERT INTO gaz_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yoosef gaarii isaa qopheeffatee abbaa isaa Israaʼel simachuuf Gooshenitti qajeele. Innis akkuma fuula isaa duratti mulʼateen morma isaatti marmee yeroo dheeraa booʼe. ");
INSERT INTO gaz_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Israaʼelis Yoosefiin, “Ani sababii akka ati amma iyyuu lubbuun jirtu ofii kootiin argeef siʼachi duʼu illee hin gaabbu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Yoosefis obboloota isaatii fi warra mana abbaa isaa jiraataniin akkana jedhe; “Ani ol baʼee Faraʼoonitti nan dubbadha; akkanas nan jedhaan; ‘Obboloonni koo fi warri mana abbaa koo jiraatan kanneen biyya Kanaʼaan jiraachaa turan natti dhufaniiru. ");
INSERT INTO gaz_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Namoonni kunneen tiksoota; isaan loon tikfatuutii. Isaan bushaayee isaanii, loonii fi waan qaban hunda fudhatanii dhufan.’ ");
INSERT INTO gaz_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Yoo Faraʼoon ofitti isin waamee, ‘Hojiin keessan maal?’ jedhee isin gaafate, ");
INSERT INTO gaz_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","‘Nu garboonni kee akkuma abbootii keenyaa ijoollummaa keenyaa jalqabnee hamma ammaatti horii tikfachaa turre’ jedhaa deebisaa. Yoos inni sababii tiksoonni hundinuu warra Gibxi biratti jibbamaniif akka isin biyya Gooshen keessa jiraattan isinii eeyyamaa.” ");
INSERT INTO gaz_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yoosefis gara Faraʼoon dhaqee, “Abbaan kootii fi obboloonni koo bushaayee isaanii, loon isaaniitii fi waan qaban hunda fudhatanii biyya Kanaʼaan dhufanii kunoo biyya Gooshen jiru” jedhee itti hime. ");
INSERT INTO gaz_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Innis obboloota isaa keessaa nama shan filatee Faraʼoonitti dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Faraʼoonis, “Hojiin keessan maali?” jedhee obboloota Yoosef gaafate. Isaanis, “Nu garboonni kee akkuma abbootii keenyaa tiksoota” jedhanii deebisaniif. ");
INSERT INTO gaz_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Akkanas jedhaniin; “Sababii beelli biyya Kanaʼaanitti cimee bushaayeen garboota keetii waan dheedan dhabaniif nu yeroo gabaabaa as jiraachuu dhufne. Akka nu garboonni kee biyya Gooshen keessa jiraannuuf maaloo nuu eeyyami.” ");
INSERT INTO gaz_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Faraʼoonis Yoosefiin akkana jedhe; “Abbaan keetii fi obboloonni kee siif dhufaniiru; ");
INSERT INTO gaz_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","lafti Gibxi fuuluma kee dura jira; abbaa keetii fi obboloota kee iddoo lafa hundumaa caalu irra qubachiisi. Isaan biyya Gooshen keessa haa jiraatan. Ati yoo namoota isaan keessaa dandeettii qaban beekte loon koo irratti itti gaafatamtoota isaan godhi.” ");
INSERT INTO gaz_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Ergasii Yoosef abbaa isaa Yaaqoobin fidee fuula Faraʼoon duratti dhiʼeesse. Erga Yaaqoob Faraʼoonin eebbisee booddee, ");
INSERT INTO gaz_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Faraʼoon, “Umuriin kee hammam?” jedhee isa gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaaqoobis Faraʼooniin akkana jedhe; “Barri ani keessummummaan jiraadhe waggaa dhibbaa tokkoo fi soddoma. Baroonni koos muraasa; hamaadhas; innis bara abbootiin koo keessummummaan jiraatan sanaan wal qixxee miti.” ");
INSERT INTO gaz_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Kana booddee, Yaaqoob Faraʼoonin eebbisee fuula isaa duraa gad baʼe. ");
INSERT INTO gaz_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Yoosefis akkuma Faraʼoon isa ajajetti abbaa isaatii fi obboloota isaa Gibxi keessa qubachiise; lafa lafa hunda caalu, aanaa Raamsee handhuuraa godhee isaanii kenne. ");
INSERT INTO gaz_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Akkasumas Yoosef abbaa isaatiif, obboloota isaatii fi warra mana abbaa isaa jiran hundaaf akkuma baayʼina ijoollee isaaniitti midhaan kenne. ");
INSERT INTO gaz_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Waan beelli akka malee cimeef biyyattii guutuu keessa wanni nyaatamu hin jiru ture; sababii beela sanaatiinis Gibxii fi Kanaʼaan akka malee miidhaman. ");
INSERT INTO gaz_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yoosefis kaffaltii midhaan namoonni bitachaa turan sanaa maallaqa biyya Gibxii fi Kanaʼaan keessatti argamu hunda walitti qabee masaraa Faraʼoonitti galche. ");
INSERT INTO gaz_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Maallaqni warra Gibxii fi warra Kanaʼaan dhumnaan warri Gibxi hundi gara Yoosef dhufanii, “Midhaan nuu kenni. Nu maaliif fuula kee duratti duuna? Maallaqni keenya dhumeera” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yoosef immoo, “Erga maallaqni keessan dhumee horii keessan fidaa; qooda horii keessanii ani midhaan isiniif nan kenna” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Isaanis horii isaanii Yoosefitti fidan; Yoosefis qooda fardeen isaanii, qooda bushaayee isaanii, qooda loowwan isaaniitii fi qooda harroota isaanii midhaan kenneef. Innis bara sana geeddaraa horii isaanii hundaa midhaan isaan soore. ");
INSERT INTO gaz_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Waggaan sun dhumnaan jarri waggaa itti aanutti gara isaa dhufanii akkana jedhan; “Erga maallaqni keenya dhumee horiin keenya kan kee taʼee as, yaa gooftaa keenya akka dhagna keenyaa fi lafa keenya malee wanni tokko iyyuu nuuf hin hafin nu gooftaa keenya jalaa hin dhoksinu. ");
INSERT INTO gaz_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nu maaliif fuula kee duratti duuna? Nuu fi lafti keenyas maaliif badna? Nuu fi lafa keenya fudhadhuutii qooda isaa midhaan nuuf kenni. Nu lafa keenya wajjin Faraʼooniif ni garboomna. Akka nu duʼa jalaa baanee jiraannuuf, akka laftis duwwaa hin hafneef sanyii nuuf kenni.” ");
INSERT INTO gaz_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Yoosefis lafa biyya Gibxi hundumaa Faraʼooniif bite. Warri Gibxi hundi waan beelli isaanitti cimeef lafa isaanii gurguran; laftis kan Faraʼoon taʼe; ");
INSERT INTO gaz_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yoosefis daangaa biyya Gibxi tokko irraa hamma daangaa kaaniitti saba garbummaa jala galche. ");
INSERT INTO gaz_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Lafti inni hin bitin lafa lubootaa qofa ture; kunis sababii isaan Faraʼoon irraa qooda argatanii fi sababii qooda Faraʼoon isaaniif kennu sanaan jiraataniif. Kanaafuu isaan lafa isaanii hin gurgurre. ");
INSERT INTO gaz_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yoosefis saba sanaan akkana jedhe; “Kunoo ani harʼa isinii fi lafa keessan Faraʼooniif biteera. Kunoo lafatti sanyii facaafadhaa. ");
INSERT INTO gaz_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Yommuu midhaan galfamutti harka shan keessaa harka tokko Faraʼooniif ni kennitu. Harka afran hafe immoo sanyii facaafattan, nyaata ofii keessanii, nyaata warra mana keessan jiraataniitii fi nyaata ijoollee keessanii godhattu.” ");
INSERT INTO gaz_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Jarris, “Ati duʼa nu oolchiteerta; nu fuula gooftaa keenyaa duratti fudhatama haa argannuu malee Faraʼooniif garboota ni taana” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Yoosefis akkasiin akka harka shan keessaa harki tokko kan Faraʼoon taʼuuf Gibxi keessatti seera lafaa dhaabe; seerri sun hamma harʼaatti illee ittiin hojjetamaa jira. Lafa lubootaa qofattu utuu kan Faraʼoon hin taʼin hafe. ");
INSERT INTO gaz_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israaʼeloonnis Gibxi keessa kutaa biyya Gooshen keessa qubatan. Achittis qabeenya argatan; horaniis guddaa baayʼatan. ");
INSERT INTO gaz_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaaqoob waggaa kudha torba biyya Gibxi keessa jiraate; barri jireenya isaas waggaa dhibba tokkoo afurtamii torba ture. ");
INSERT INTO gaz_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Israaʼelis yeroon duʼa isaa dhiʼaannaan ilma isaa Yoosefin ofitti waamee akkana jedheen; “Yoo ani fuula kee duratti fudhatama argadhe, mee harka kee gudeeda koo jala kaaʼiitii akka gaarummaa na argisiiftuu fi akka naaf amanamtu waadaa naaf seeni. Gibxitti na hin awwaalin; ");
INSERT INTO gaz_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","yeroo ani abbootii koo wajjin boqodhutti biyya Gibxii na baasii iddoo isaan itti awwaalamanitti na awwaali.” Innis, “Akkuma ati jette nan godha” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Israaʼelis, “Naa kakadhu” jedheen. Yoosefis ni kakateef. Israaʼel immoo mataa ulee isaatti irkatee sagade. ");
INSERT INTO gaz_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yeroo muraasa booddee, “Kunoo, abbaan kee dhukkubsateera” jedhanii Yoosefitti himan. Innis ilmaan isaa lamaan Minaasee fi Efreemin fudhatee dhaqe. ");
INSERT INTO gaz_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yaaqoob yeroo, “Ilmi kee Yoosef gara kee dhufeera” jedhanii itti himanitti, Israaʼel of jajjabeessee kaʼee siree irra taaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaaqoobis Yoosefiin akkana jedhe; “Waaqni Waan Hunda Dandaʼu biyya Kanaʼaan keessatti Luuzitti natti mulʼatee achitti na eebbise; ");
INSERT INTO gaz_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","akkanas naan jedhe; ‘Ani akka ati hortuu fi akka ati baayʼattu nan godha. Tuuta sabaa sin godha; ani biyya kana dhaala bara baraa godhee sanyiiwwan kee warra si booddeetiif nan kenna.’ ");
INSERT INTO gaz_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","“Egaa amma ilmaan kee lamaan warri utuu ani as gara kee hin dhufin dura Gibxitti siif dhalatan sun akkuma ilmaan kootti ilaalamu; akkuma Ruubeenii fi Simiʼoon kan koo taʼan sana Efreemii fi Minaaseenis kanuma koo taʼu. ");
INSERT INTO gaz_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ijoolleen isaan booddeen siif dhalatan kan kee taʼu. Dhaala qoodachuu keessatti immoo maqaa obboloota isaanii jalatti lakkaaʼamu. ");
INSERT INTO gaz_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Yeroo ani kaaba dhiʼa Phaadaaniitii deebiʼaa turetti utuma Efraataa gaʼuuf xinnuma nuu hafee jiruu Raahel biyya Kanaʼaan keessatti na jalaa duunaan achumatti karaa Efraataa dhaqu biratti awwaalladhe.” Efraataan kunis Beetlihemii dha. ");
INSERT INTO gaz_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Israaʼel yeroo ilmaan Yoosef argetti, “Isaan kunneen eenyu?” jedhee gaafate. ");
INSERT INTO gaz_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yoosef immoo abbaa isaatiin, “Isaan kunneen ilmaan biyya kanatti Waaqni naaf kennee dha” jedhe. Kana irratti Israaʼel, “Akka ani isaan eebbisuuf natti fidi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yeroo kanatti Israaʼel dulloomee iji isaa dadhabee ture; innis waa hubachuu hin dandaʼu ture. Kanaafuu Yoosef ilmaan isaa Israaʼelitti dhiʼeesse; Israaʼelis isaan dhungate; isaan hammates. ");
INSERT INTO gaz_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Israaʼelis Yoosefiin, “Ani fuuluma kee iyyuu nan arga jedhee hin yaadne; Waaqni garuu akka ani ijoollee kee iyyuu argu naa eeyyame” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Yoosefis jilba Israaʼel irraa achi isaan butee fuula isaatiin lafatti gad gombifame. ");
INSERT INTO gaz_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Innis ergasii lamaan isaanii iyyuu fuudhee Efreemin karaa mirga isaatiin gara harka Israaʼel isa bitaatti, Minaasee immoo bitaa isaatiin gara harka Israaʼel isa mirgaatti fidee isatti dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Israaʼel garuu utuma Efreem quxisuu taʼee jiruu harka isaa mirgaa mataa Efreem irra kaaʼe; Minaaseen immoo utuma hangafa taʼee jiruu Israaʼel harka isaa wal qaxxaamursee harka isaa bitaa mataa Minaasee irra kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Innis akkana jedhee Yoosefin eebbise; “Waaqni inni abbootiin koo Abrahaamii fi Yisihaaq fuula isaa dura jiraatan, Waaqni inni bara jireenya koo guutuu hamma harʼaatti tiksee koo ture sun, ");
INSERT INTO gaz_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ergamaan Waaqayyoo kan balaa hunda jalaa na baase sun ilmaan kanneen haa eebbisu. Isaan maqaa kootiin, maqaa abbootii koo Abrahaamii fi Yisihaaqiin haa waamaman; isaan lafa irratti guddaa haa baayʼatan.” ");
INSERT INTO gaz_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yoosef yommuu akka abbaan isaa harka isaa mirgaa mataa Efreem irra kaaʼe argetti ni gadde; kanaafuu inni harka abbaa isaa mataa Efreem irraa fuudhee mataa Minaasee irra kaaʼuuf jedhee kaase. ");
INSERT INTO gaz_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yoosef abbaa isaatiin, “Yaa abbaa ko, akkas miti; inni kun hangafa; harka kee mirgaa mataa isaa irra kaaʼi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Abbaan isaa garuu didee akkana jedheen; “Ani nan beeka; yaa ilma koo nan beeka. Innis saba taʼa; saba guddaa isaa taʼa. Taʼus obboleessi isaa inni quxisuun isa caalaa guddaa taʼa; sanyiin isaas tuuta saba baayʼee ni taʼa.” ");
INSERT INTO gaz_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Innis gaafa sana akkana jedhee isaan eebbise; “Israaʼel maqaa keetiin eebba kana kenna; ‘Waaqni akka Efreemii fi akka Minaasee isin haa taasisu.’ ” Yoosefis akkasiin Minaasee dura Efreemin dabarse. ");
INSERT INTO gaz_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Ergasii Israaʼel Yoosefiin akkana jedhe; “Kunoo ani duʼuu gaʼeera; Waaqni garuu isin wajjin taʼee biyya abbaa keessaniitti isin deebisa. ");
INSERT INTO gaz_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ani qooda obboloota keetii caalchisee qooda tokko siifin kenna; kunis lafa ol kaʼaa ani Amoorota irraa goraadee koo fi iddaa kootiin fudhadhe sanaa dha.” ");
INSERT INTO gaz_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Yaaqoob ilmaan isaa ofitti waamee akkana jedhe: “Akka ani waan bara dhumaa keessa isinitti dhufu isinitti himuuf mee walitti qabamaa. ");
INSERT INTO gaz_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","“Yaa ilmaan Yaaqoob mee walitti qabamaa dhaggeeffadhaa; abbaa keessan Israaʼelin dhaggeeffadhaa. ");
INSERT INTO gaz_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","“Yaa Ruubeen, ati ilma koo hangafa; humna koo, mallattoo jalqabaa kan jabina kootii ti; ati ulfinaan ni caalta; humnaan illee ni caalta. ");
INSERT INTO gaz_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Ati akka bishaanii asii fi achi raafamta; ol aantummaas hin qabaattu; ati siree abbaa keetiitti ol baatee, afata kootti ol baatee xureessiteertaatii. ");
INSERT INTO gaz_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","“Simiʼoonii fi Lewwiin obboloota; goraadeen isaanii miʼa fincilaa ti. ");
INSERT INTO gaz_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Lubbuun koo marii isaaniitti hin seenin; ulfinni koos yaaʼii isaaniitti hin dabalamin; isaan dheekkamsa isaaniitiin nama ajjeesaniiruutii; fedhii ofii isaaniitiinis qotiyyoo naafachiisaniiru. ");
INSERT INTO gaz_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Aariin isaanii inni hamaan, dheekkamsi isaanii inni gara jabeessi abaaramaa haa taʼu! Ani Yaaqoob keessa isaan nan bittinneessa; Israaʼel keessas isaan nan facaasa. ");
INSERT INTO gaz_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","“Yaa Yihuudaa obboloonni kee si leellisu; harki kee morma diina keetii qaba; ilmaan abbaa keetii siif sagadu. ");
INSERT INTO gaz_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Yaa Yihuudaa ati saafela leencaa ti; yaa ilma koo ati adamoodhaa deebita. Inni akka leencaa, akka leenca dhalaas, riphee ciisa; eenyutu ija jabaatee isa kaasa ree? ");
INSERT INTO gaz_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Hamma bulchaan dhufutti bokkuun harka Yihuudaatii, uleen bulchiinsaa miilla isaa gidduudhaa hin dhabamu; saboonnis isaaf ni ajajamu. ");
INSERT INTO gaz_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Inni harree isaa muka wayiniitti, ilmoo harree isaa immoo damee filatamaatti hidhata; wayyaa isaa daadhii wayiniitiin, wandaboo isaa immoo dhiiga gumaa wayiniitiin miiccata. ");
INSERT INTO gaz_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Iji isaa daadhii wayinii irra diimata; ilkaan isaa immoo aannan irra addaata. ");
INSERT INTO gaz_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","“Zebuuloon qarqara galaanaa jiraata; buufata dooniiwwaniis taʼa; daangaan isaas hamma Siidoonaatti balʼata. ");
INSERT INTO gaz_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","“Yisaakor harree jabaa feʼiisa lama gidduu ciisuu dha. ");
INSERT INTO gaz_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Innis yeroo akka iddoon boqonnaa isaa hammam gaarii taʼee fi akka lafti isaa tolaa taʼe argutti baʼaa baachuuf gatiittii isaa gad qabata; hojii humnaa hojjechuuf of kenna. ");
INSERT INTO gaz_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","“Daan gosoota Israaʼel keessaa akka isa tokkootti, saba isaatiif murtii qajeelaa ni kenna. ");
INSERT INTO gaz_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daan bofa qarqara karaa ti; akka buutii daandii irraa, kan akka namichi farda yaabbatu gara duubaatti kufuuf kottee fardaa idduu ni taʼa. ");
INSERT INTO gaz_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","“Yaa Waaqayyo, ani fayyisuu kee nan eeggadha. ");
INSERT INTO gaz_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","“Gaad weerartootaan ni dhaʼama; inni garuu faana buʼee isaan dhaʼa. ");
INSERT INTO gaz_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","“Aasheer buddeenni isaa furdaa dha; inni mootiidhaaf nyaata tolaa ni kenna. ");
INSERT INTO gaz_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","“Niftaalem borofa hiikamtee dha; dubbii gaariis ni dubbata. ");
INSERT INTO gaz_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","“Yoosef muka wayinii ija qabeessa, muka wayinii ija qabeessa burqaa bishaaniitti dhiʼoo jiruu dha; dameen isaa dallaa irra yaaʼa. ");
INSERT INTO gaz_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Warri iddaa qabatan waraana isatti banan; isatti futtaasan; isa jibbanis. ");
INSERT INTO gaz_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Garuu iddaan isaa jabaatee hafe; irreen harka isaa, harka Waaqa Jabaa Yaaqoobiin jabeeffame. Achiis Tiksee sanaan, Kattaa Israaʼeliin, ");
INSERT INTO gaz_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Waaqa abbaa keetii isa si gargaaruun, Waaqa Waan Hunda Dandaʼu isa eebba samii gubbaatiin, eebba gadi fagoo isa jalaatiin, eebba harmaatii fi gadameessaatiin si eebbisu sanaan ni eebbifamta. ");
INSERT INTO gaz_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Eebbi abbaa keetii, eebba tulluuwwan durii, arjummaa gaarran durii caala. Kun hundi mataa Yoosefiitti, gubbee mataa isa obboloota isaa keessaa hoogganaa taʼeetti haa qabatu. ");
INSERT INTO gaz_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","“Beniyaam yeeyyii baayʼee beelaʼee dha; ganama waan adamse itti gaggabee nyaata; galgala immoo boojuu hira.” ");
INSERT INTO gaz_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Warri kunneen hundi gosoota Israaʼel kudha lamaan; kunis waan abbaan isaanii yeroo eebba tokkoo tokkoo isaaniif taʼuun isaan eebbisetti isaanitti dubbatee dha. ");
INSERT INTO gaz_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Ergasiis Yaaqoob akkana jedhee isaan ajaje; “Ani gara saba kootiitti walitti qabamuu gaʼeera; holqa lafa qotiisaa Efroon namicha gosa Heeti sanaatti abbootii koo biratti na awwaalaa. ");
INSERT INTO gaz_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Holqi kunis holqa biyya Kanaʼaan keessatti Mamree biratti lafa qotiisaa Makfelaa keessatti argamu kan Abrahaam iddoo awwaalaa godhachuuf Efroon namicha gosa Heeti sana irraa lafa qotiisaa wajjin bitatee dha. ");
INSERT INTO gaz_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abrahaamii fi niitiin isaa Saaraan achitti awwaalaman; Yisihaaqii fi niitiin isaa Ribqaan achitti awwaalaman; anis achumattan Liyaa awwaale. ");
INSERT INTO gaz_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Lafti qotiisaatii fi holqi isa keessa jiru Heetota irraa bitaman.” ");
INSERT INTO gaz_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaaqoob akkuma ilmaan isaa ajajuu raawwateen miilla isaa siree irratti ol deebifatee hafuura dhumaa baafate; gara saba isaattis walitti qabame. ");
INSERT INTO gaz_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yoosefis abbaa isaa irratti kufee booʼeef; isa dhungates. ");
INSERT INTO gaz_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Ergasii immoo Yoosef tajaajiltoota isaa kanneen ogeessota fayyaa taʼan akka isaan reeffa abbaa isaa qorichaan sukkuuman ajaje; jarris reeffa Israaʼel qorichaan sukkuuman; ");
INSERT INTO gaz_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","waan kana gochuun bultii afurtama guutuu isaanitti fudhate; yeroon qoricha reeffa dibuuf barbaachisu kana tureetii. Warri Gibxiis bultii torbaatama isaaf booʼan. ");
INSERT INTO gaz_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Guyyoonni gaddaa darbinaan Yoosef warra mana Faraʼoon jiraataniin akkana jedhe; “Yoo ani fuula keessan duratti fudhatama argadheera taʼe, akkana jedhaatii Faraʼoonitti naa himaa: ");
INSERT INTO gaz_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‘Abbaan koo akkana jedhee na kakachiiseera; “Kunoo ani duʼuu gaʼeera; awwaala ani biyya Kanaʼaan keessatti ofii kootiif qotadhetti na awwaalaa.” Kanaafuu maaloo ani amma dhaqee abbaa koo nan awwaalladha; ergasii immoo nan deebiʼa.’ ” ");
INSERT INTO gaz_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Faraʼoonis, “Dhaqiitii akkuma inni si kakachiise sanatti abbaa kee awwaalladhu” jedheen. ");
INSERT INTO gaz_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Yoosefis abbaa isaa awwaallachuu dhaqe. Qondaaltonni Faraʼoon hundinuu hangafoonni mana isaatii fi hangafoonni Gibxi hundi isa wajjin deeman. ");
INSERT INTO gaz_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Akkasumas warri mana Yoosef jiraatan, obboloota isaatii fi warri mana abbaa isaa jiraatan hundi isa wajjin deeman. Ijoollee isaanii, bushaayee isaaniitii fi loon isaanii qofattu, Gooshenitti hafe. ");
INSERT INTO gaz_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Gaariiwwanii fi warri farda yaabbatanis isa wajjin deeman. Tuunni sunis akka malee guddaa ture. ");
INSERT INTO gaz_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Isaanis yommuu Yordaanos gama oobdii Axaad bira gaʼanitti sagalee isaanii ol fudhatanii gadoodanii booʼan. Yoosefis achitti abbaa isaatiif guyyaa torba booʼe. ");
INSERT INTO gaz_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Namoonni Kanaʼaan warri achi jiraachaa turan booʼicha oobdii Axaad biratti booʼame sana arganii, “Booʼichi kun warra Gibxiitiif booʼicha guddaa dha” jedhan. Kanaafuu iddoon sun Abeel Misraayim jedhamee moggaafame. Iddoon sunis Yordaanos gamatti argama. ");
INSERT INTO gaz_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Ilmaan Yaaqoob akkuma inni isaan ajaje sana godhan; ");
INSERT INTO gaz_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","isaanis biyya Kanaʼaanitti isa geessanii holqa Mamree biratti lafa qotiisaa Makfelaa keessatti argamu kan Abrahaam iddoo awwaalaa godhachuudhaaf Efroon namicha gosa Heeti sana irra lafa qotiisaa wajjin bitate sanatti awwaalan. ");
INSERT INTO gaz_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yoosef erga abbaa isaa awwaallatee booddee obboloota isaatii fi warra isa wajjin abbaa isaa awwaaluu dhaqan hunda wajjin Gibxitti deebiʼe. ");
INSERT INTO gaz_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Obboloonni Yoosef erga abbaan isaanii duʼee booddee, “Yoo Yoosef hamaa nu isatti hojjennee hundaaf haaloo qabatee haaloo nutti baʼe hoo?” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Isaanis akkana jedhanii Yoosefitti dhaammatan; “Abbaan kee utuu hin duʼin dura akkana jedhee ajaje; ");
INSERT INTO gaz_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‘Isin akkana jedhaa Yoosefitti himaa; ani akka ati cubbuu fi balleessaa obboloonni kee si miidhuuf jedhanii sitti hojjetan sana isaanii dhiiftu sin kadhadha.’ Maaloo cubbuu tajaajiltoota Waaqa abbaa keetii dhiisi.” Yoosefis yommuu ergaa isaanii dhagaʼetti ni booʼe. ");
INSERT INTO gaz_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Obboloonni isaas dhufanii fuula isaa duratti lafa dhaʼanii, “Kunoo nu garboota kee ti” jedhan. ");
INSERT INTO gaz_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yoosef garuu akkana isaaniin jedhe; “Hin sodaatinaa. Anatu iddoo Waaqaa buʼaa? ");
INSERT INTO gaz_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Isin hamaa natti yaaddan; Waaqni garuu akkuma amma taʼee jiru kana lubbuu nama baayʼee baraaruuf jedhee waan gaariif yaade. ");
INSERT INTO gaz_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Egaa hin sodaatinaa. Ani isinii fi ijoollee keessan nan sooraatii.” Innis waan garaa isaan ciibsu isaanitti dubbatee isaan jajjabeesse. ");
INSERT INTO gaz_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yoosef maatii abbaa isaa wajjin Gibxi keessa ture. Innis waggaa dhibba tokkoo fi kudhan jiraate. ");
INSERT INTO gaz_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Dhaloota sadaffaa ijoollee Efreem arge. Akkasumas ilmaan Maakiir ilma Minaasee jilba Yoosef irratti dhalatan. ");
INSERT INTO gaz_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Yoosefis obboloota isaatiin akkana jedhe; “Ani duʼuu gaʼeera. Waaqni garuu dhugumaan dhufee isin gargaara; biyya kanaa isin baasees gara biyya Abrahaamiif, Yisihaaqii fi Yaaqoobiif kakuun waadaa gale sanaatti isin geessa.” ");
INSERT INTO gaz_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Yoosefis ijoollee Israaʼel kakachiisee akkana jedheen; “Waaqni dhugumaan dhufee isin gargaara; isinis lafee koo biyya kanaa ol baasuu qabdu.” ");
INSERT INTO gaz_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yoosefis waggaa dhibba tokkoo fi kudhanitti duʼe. Jarris qorichaan sukkuumanii Gibxitti sanduuqa reeffaa keessa isa kaaʼan.");
INSERT INTO gaz_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Maqaan ilmaan Israaʼel kanneen maatii isaanii qabatanii Yaaqoob wajjin Gibxi dhaqanii kanaa dha: ");
INSERT INTO gaz_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruubeen, Simiʼoon, Lewwii fi Yihuudaa; ");
INSERT INTO gaz_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Yisaakor, Zebuuloonii fi Beniyaam; ");
INSERT INTO gaz_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daanii fi Niftaalem; Gaadii fi Aasheer. ");
INSERT INTO gaz_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Namoonni sanyii Yaaqoob irraa dhalatan walumaa galatti torbaatama turan; Yoosef durumaanuu Gibxi ture. ");
INSERT INTO gaz_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Yoosefii fi obboloota isaa hundi, dhaloonni sun hundinuus, ni duʼan. ");
INSERT INTO gaz_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Israaʼeloonni garuu horanii akka malee baayʼatan; baayʼataniis akka malee jabaatan; biyyattii keessas ni guutan. ");
INSERT INTO gaz_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Ergasii mootiin waaʼee Yoosef hin beekin haaraan tokko bulchaa Gibxi taʼe. ");
INSERT INTO gaz_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Innis saba isaatiin akkana jedhe; “Kunoo, Israaʼeloonni nu caalaa baayʼataniiru; nu caalaas jabaataniiru. ");
INSERT INTO gaz_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Kottaa akka isaan kana caalaa hin baayʼanneef, yoo waraanni kaʼes diinota keenya gargaaranii akka nu hin waraannee fi akka biyyattii keessaa baqatanii hin baaneef haxxummaadhaan isaan qabna.” ");
INSERT INTO gaz_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Kanaafuu itti gaafatamtoota isaan cunqursanii hojii humnaa hojjechiisan isaanitti muudan; Israaʼeloonnis Fiitoomii fi Raamsee magaalaawwan waa itti kuusan godhanii Faraʼooniif ijaaran. ");
INSERT INTO gaz_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Isaan garuu hamma cunqursaan isaanitti jabaachaa deeme sana baayʼatanii lafa guutan; kana irratti warri Gibxi saba Israaʼel sodaatan. ");
INSERT INTO gaz_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Warri Gibxis Israaʼelootatti gara jabinaan isaan hojjechiifatan. ");
INSERT INTO gaz_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Isaanis suphee fi xuubii hojjechiisuudhaan, lafa qotiisaa keessas hojii garaa garaa hunda hojjechiisuudhaan hojii itti cimsanii jireenya isaanitti hadheessan; warri Gibxi hojii jabaa jara hojjechiisan hunda keessatti garaa isaaniif hin laafan ture. ");
INSERT INTO gaz_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Mootiin Gibxi deessistoota Ibrootaa kanneen Siipaaraa fi Fuuhaa jedhamaniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","“Isin yommuu dubartoota Ibrootaa daʼumsa irratti gargaartanii fi barcuma daʼumsaa irratti isaan argitan, yoo dhiira taʼe ajjeesaa; yoo durba taate immoo haa jiraattuu dhiisaa.” ");
INSERT INTO gaz_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Deessistoonni sun garuu waan Waaqa sodaataniif, waan mootiin Gibxi isaanitti hime sana hin goone; ijoollee dhiiraas akka isaan jiraataniif dhiisan. ");
INSERT INTO gaz_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Mootiin Gibxis deessistoota sana ofitti waamee, “Isin maaliif waan kana gootan? Maaliifis ijoollee dhiiraa akka isaan jiraataniif dhiiftan?” jedhee isaan gaafate. ");
INSERT INTO gaz_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Deessistoonni sunis, “Dubartoonni Ibrootaa akka dubartoota warra Gibxi miti; isaan waan jajjaboo taʼaniif utuu deessistoonni isaan bira hin gaʼin daʼanii nama eegu” jedhanii Faraʼooniif deebisan. ");
INSERT INTO gaz_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Waaqnis deessistoota sanaaf waan gaarii godhe; Israaʼeloonnis baayʼatanii akka malee jabaatan. ");
INSERT INTO gaz_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Sababii isaan Waaqa sodaataniif Waaqni deessistoota sanaaf maatii ofii isaanii kenneef. ");
INSERT INTO gaz_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Kana irratti Faraʼoon, “Ilma dhalatu hunda laga Abbayyaa keessa buusaa; durbi hundi garuu haa jiraattuu dhiisaa” jedhee saba isaa hunda ajaje. ");
INSERT INTO gaz_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Sanyii Lewwii keessaa namichi tokko intala Lewwii tokko fuudhe; ");
INSERT INTO gaz_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","isheenis ulfooftee ilma deesse. Yommuu akka inni bareedaa taʼe argitetti jiʼa sadii isa dhoksite. ");
INSERT INTO gaz_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Kana caalaa isa dhoksuu akka hin dandeenye yeroo beektetti garuu guuboo dhallaadduu irraa hojjetame tokko fuutee haphee fi leelee itti dhoobde; mucaa sana guuboo keessa ciibsitee qarqara laga Abbayyaa shambaqqoo keessa keesse. ");
INSERT INTO gaz_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Obboleettiin isaa immoo waan mucicha irra gaʼu ilaaluuf jettee fagoo dhaabachaa turte. ");
INSERT INTO gaz_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Yeroo sana intalli Faraʼoon dhagna dhiqachuuf gara laga Abbayyaatti gad buute; dubartoonni ishee tajaajilanis qarqara laga sanaa irra asii fi achi dedeemaa turan. Isheenis guuboo sana shambaqqoo keessatti argitee akka dhaqxee fidduuf garbittii ishee ergite. ");
INSERT INTO gaz_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Isheenis guuboo bantee mucaa sana argite; kunoo mucichis booʼaa ture. Isheenis garaa laafteefii, “Kun daaʼimman Ibrootaa keessaa tokkoo dha” jette. ");
INSERT INTO gaz_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Obboleettiin mucichaas intala Faraʼooniin, “Akka isheen hoosiftee siif guddiftuuf dhaqee dubartoota Ibrootaa keessaa guddiftuu tokko siif waamuu?” jette. ");
INSERT INTO gaz_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Isheenis, “Eeyyee, dhaqi” jetteen. Intalli sunis dhaqxee haadha mucaa sanaa waamte. ");
INSERT INTO gaz_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Intalli Faraʼoonis dubartittiidhaan, “Mucaa kana fuudhii naa hoosisi; ani mindaa kee siifin kennaa” jette. Dubartiin sunis daaʼima sana fuutee hoosifte. ");
INSERT INTO gaz_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mucaan sun guddannaan isheen intala Faraʼoonitti fidde. Innis ilma ishee taʼe. Isheenis, “Ani bishaan keessaa isa nan baase” jechuudhaan maqaa isaa Musee jettee moggaafte. ");
INSERT INTO gaz_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Museen erga guddatee booddee gaafa tokko lafa sabni isaa ture dhaqee utuu isaan hojii dadhabsiisaa hojjetanuu arge; utuu namni Gibxi tokkos Ibroota saba isaa keessaa nama tokko rukutuu arge. ");
INSERT INTO gaz_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Innis asii fi achi ilaalee akka namni tokko iyyuu hin jirre mirkaneeffate; namicha Gibxi sana ajjeesee cirracha keessa dhokse. ");
INSERT INTO gaz_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Guyyaa itti aanutti immoo gad baʼee utuu Ibroonni lama wal lolanuu arge. Ibricha balleessaa qabuunis, “Ati maaliif Ibricha akka keetii rukutta?” jedhee gaafate. ");
INSERT INTO gaz_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Namichi sunis, “Eenyutu nurratti bulchaa fi abbaa murtii si godhe? Akkuma namicha Gibxi ajjeefte sana ana illee ajjeesuu barbaaddaa?” jedheen. Kana irratti Museen, “Dhugumaan wanni ani hojjedhe sun beekameera jechuu dha” jedhee sodaate. ");
INSERT INTO gaz_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Faraʼoon yommuu waan kana dhagaʼetti Musee ajjeesuu yaale; Museen garuu Faraʼoon jalaa gara Midiyaanitti baqate; yommuu achi gaʼettis boolla tokko bira taaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Lubni Midiyaan tokko intallan torba qaba ture; isaanis dhufanii bushaayee abbaa isaanii obaasuuf bishaan budduuqsanii bidiruutti guutaa turan. ");
INSERT INTO gaz_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Tiksoonnis dhufanii isaan ariʼan; Museen garuu kaʼee isaan gargaaree bushaayee isaanii obaaseef. ");
INSERT INTO gaz_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Yeroo dubarri sun gara abbaa isaanii Reʼuuʼeelitti deebiʼanitti, inni, “Isin harʼa akkamiin daftanii deebitan?” jedhee isaan gaafate. ");
INSERT INTO gaz_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Isaanis, “Namicha Gibxi tokkotu tiksoota jalaa nu baase; inni bishaan iyyuu nuu budduuqsee bushaayee nuuf obaase” jedhanii deebisan. ");
INSERT INTO gaz_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Inni immoo intallan isaatiin, “Inni eessa jira? Isin maaliif isa dhiiftanii dhuftan? Akka inni waa nyaatuufis dhaqaatii waamaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Museenis namicha bira jiraachuu jaallate; namichis intala isaa Ziphooraa Museetti heerumsiise. ");
INSERT INTO gaz_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Siipaaraan ilma deesse; Museenis, “Ani alagaa taʼee biyya ormaa jiraadheera” jechuudhaan maqaa isaa Geershoom jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Bara dheeraa sana keessa mootiin Gibxi ni duʼe. Namoonni Israaʼelis sababii garbummaa keessa turaniif ni aadan; ni iyyanis; iyyi isaan sababii garbummaa jala turaniif gargaarsa argachuuf iyyanis Waaqa bira gaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Waaqnis aaduu isaanii dhagaʼee kakuu isaa kan Abrahaam, Yisihaaqii fi Yaaqoob wajjin gale sana yaadate. ");
INSERT INTO gaz_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Waaqnis saba Israaʼel ilaale; Waaqni akka isaan itti jiran beeke. ");
INSERT INTO gaz_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Museen bushaayee abbaa niitii isaa Yetroo lubicha Midiyaan sanaa tiksaa ture; innis gaaf tokko hamma dhiʼa lafa gammoojjiitti bushaayee sana oofee gara tulluu Waaqaa gara Kooreeb dhufe. ");
INSERT INTO gaz_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Achittis Ergamaan Waaqayyoo daggala bobaʼu keessaa arraba ibiddaa keessaan isatti mulʼate. Museenis daggalli sun bobaʼu illee akka hin gubatin arge. ");
INSERT INTO gaz_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Museenis, “Daggalli kun maaliif hin gubatu laata? Ani itti goree waan dinqisiisaa kana ilaaluu qaba” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Waaqayyos yommuu akka Museen ilaaluuf achi gore argetti, Waaqni daggala sana keessaa, “Musee! Musee!” jedhee isa waame. Museenis, “Kunoo ani asan jira” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Waaqni immoo, “As hin dhiʼaatin; Sababii iddoon ati dhaabatu kun qulqulluu taʼeef kophee kee baafadhu” jedheen. ");
INSERT INTO gaz_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Itti fufees, “Ani Waaqa abbaa keetii, Waaqa Abrahaam, Waaqa Yisihaaqii fi Waaqa Yaaqoob” jedhe. Kana irratti Museen Waaqa ilaaluu waan sodaateef fuula isaa dhokfate. ");
INSERT INTO gaz_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Waaqayyo akkana jedhe; “Ani dhugumaan dhiphina saba koo warra Gibxi keessa jiraatan irra gaʼu argeera. Iyya isaan warra humnaan isaan hojjechiisan jalaa baʼuuf iyyanis dhagaʼeera; ani rakkina isaaniis nan beeka. ");
INSERT INTO gaz_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Kanaafuu ani harka warra Gibxiitii isaan baasee gara biyya gaarii fi balʼaatti, biyya aannanii fi dammi keessaa burquutti jechuunis gara biyya Kanaʼaanotaatti, Heetotaatti, Amoorotaatti, Feerzotaatti, Hiiwotaattii fi Yebuusotaatti ol isaan baasuuf jedhee gad buʼeera. ");
INSERT INTO gaz_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Amma kunoo iyyi Israaʼelootaa na bira gaʼeera. Ani haala itti warri Gibxi isaan cunqursanis argeera. ");
INSERT INTO gaz_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Kanaafuu ati amma dhaqi. Ani akka ati saba koo Israaʼeloota Gibxi keessaa baaftuuf Faraʼoonitti sin erga.” ");
INSERT INTO gaz_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Museen garuu Waaqaan, “Faraʼoon bira dhaqee Gibxii Israaʼeloota baasuuf ani eenyu?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Waaqnis akkana jedhe; “Ani si wajjin nan taʼa. Ati saba sana Gibxii yommuu baaftutti isin tulluu kana irratti Waaqa waaqeffattu. Si erguu kootiifis kun mallattoo siif taʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Museen immoo Waaqaan, “Kunoo ani gara Israaʼelootaa dhaqee, ‘Waaqni abbaa keessanii na ergeera’ yommun jedhutti yoo isaan, ‘Maqaan isaa eenyu?’ jedhanii na gaafatan, ani maal jedheen isaanitti hima?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Waaqnis Museedhaan, “ANI ANUMA; ati saba Israaʼeliin, ‘Inni ANI ANUMA jedhu sun gara keessanitti na ergeera’ jedhi” jedheen. ");
INSERT INTO gaz_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Waaqni ammas Museedhaan akkana jedhe; “Israaʼelootaan akkana jedhi; ‘Waaqayyo Waaqni abbootii keessanii, Waaqni Abrahaam, Waaqni Yisihaaq, Waaqni Yaaqoob isinitti na ergeera.’ “Maqaan kun bara baraan maqaa koo ti; maqaa ani dhalootaa hamma dhalootaatti ittiin yaadatamuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","“Dhaqii maanguddoota Israaʼel walitti qabiitii akkana jedhiin; ‘Waaqayyo Waaqni abbootii keessanii, Waaqni Abrahaam, kan Yisihaaqii fi kan Yaaqoob natti mulʼatee akkana jedhe: “Ani isin ilaaleera; waan Gibxitti isin irra gaʼes argeera. ");
INSERT INTO gaz_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Kanaafuu ani rakkina Gibxi keessaa isin baasee biyya aannanii fi dammi keessaa burqu jechuunis biyya Kanaʼaanotaa, Heetotaa, Amoorotaa, Feerzotaa, Hiiwotaatii fi biyya Yebuusotaatti isin geessuuf murteesseera.” ’ ");
INSERT INTO gaz_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","“Maanguddoonni Israaʼel si dhagaʼu. Atii fi maanguddoonni Israaʼel mootii Gibxi bira dhaqxanii, ‘Waaqayyo Waaqni Ibrootaa nutti mulʼateera; egaa amma akka nu Waaqayyo Waaqa keenyaaf aarsaa dhiʼeessinuuf gara gammoojjiitti karaa guyyaa sadii nuu eeyyami’ jettuun. ");
INSERT INTO gaz_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Garuu akka mootiin Gibxi yoo irreen jabaan isa dirqisiise malee deemuuf isinii hin eeyyamne anuu beeka. ");
INSERT INTO gaz_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Ani dinqii isaan gidduutti hojjedhu hundaan irree koo hiixadhee namoota Gibxi nan dhaʼa. Ergasii inni akka deemtan isiniif eeyyama. ");
INSERT INTO gaz_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","“Anis akka sabni kun fuula warra Gibxi duratti surraa argatu nan godha; isinis yommuu Gibxii baatanitti harka duwwaa hin baatan. ");
INSERT INTO gaz_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Tokkoon tokkoon dubartii miʼa meetii, miʼa warqeetii fi uffata gaafattee ollaa isheettii fi dubartii mana ishee jiraattu irraa haa fudhattu; kanaanis ilmaanii fi intallan keessanitti uffiftu. Akkasiinis qabeenya warra Gibxi boojitanii baatu.” ");
INSERT INTO gaz_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Museen, “Yoo isaan, ‘Waaqayyo sitti hin mulʼanne’ jedhanii na amanuu yookaan na dhagaʼuu didan hoo?” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Kana irratti Waaqayyo, “Wanti harka kee keessa jiru sun maali?” jedheen. Museen immoo, “Ulee dha” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Waaqayyos, “Lafa buusi” jedheen. Museen lafa buufnaan uleen sun bofa taʼe; innis irraa baqate. ");
INSERT INTO gaz_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Waaqayyo garuu Museedhaan, “Harka kee hiixadhuutii eegee isaa qabi” jedhe. Museenis hiixatee bofa sana qabe; bofti sunis harka isaa keessatti deebiʼee ulee taʼe. ");
INSERT INTO gaz_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Waaqayyos, “kun akka isaan Waaqayyo Waaqni abbootii isaanii, Waaqni Abrahaam, Waaqni Yisihaaq, Waaqni Yaaqoob sitti mulʼate akka amananiif” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Waaqayyos Museedhaan, “Harka kee bobaa kee keessa kaaʼadhu” jedhe. Museenis harka isaa bobaa isaa keessa kaaʼate; yommuu inni baafatettis, kunoo harki isaa lamxii akka cabbii taʼe. ");
INSERT INTO gaz_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Innis Museedhaan, “Harka kee deebisii bobaa kee keessa kaaʼadhu” jedhe; Museenis deebisee harka isaa bobaa isaa keessa kaaʼate; yommuu inni baafatettis, kunoo harki isaa deebiʼee akkuma dhagna isaa isa kaanii taʼe. ");
INSERT INTO gaz_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Waaqayyos akkana jedhe; “Isaan yoo si amanuu baatanii mallattoo isa jalqabaa fudhachuu didan mallattoo lammaffaa ni amanu taʼa. ");
INSERT INTO gaz_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Yoo isaan mallattoo kana lamaan amanuu baatanii si dhagaʼuu didan bishaan laga Abbayyaa budduuqsiitii lafa gogaa irratti dhangalaasi. Bishaan ati lagicha irraa budduuqsite sunis lafa gogaa irratti dhiiga taʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Museenis Waaqayyoon, “Yaa Gooftaa, ani duris taʼu yookaan erga ati garbicha keetti dubbachuu jalqabdee as nama arraba qajeelu miti. Ani nama afaan isaa hidhamee arrabni isaas itti ulfaatuu dha” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Waaqayyos akkana isaan jedhe; “Kan afaan namaa uume eenyu? Kan akka namni arrab-didaa taʼu yookaan duudu godhu eenyu? Kan agartuu ijaa namaaf kennu yookaan jaamsu eenyu? Anuma Waaqayyoo mitii? ");
INSERT INTO gaz_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Amma dhaqi; ani afaan kee wajjin nan taʼa; waan ati jettus sin barsiisa.” ");
INSERT INTO gaz_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Museen garuu, “Yaa Gooftaa, maaloo nama biraa ergi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Dheekkamsi Waaqayyoos Musee irratti bobaʼe; innis akkana jedhe; “Obboleessi kee Aroon Lewwichi jira mitii? Ani akka inni akka gaariitti dubbatu nan beeka. Kunoo, inni gara kee dhufuutti jira. Inni yommuu si argutti ni gammada. ");
INSERT INTO gaz_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ati isatti dubbatee afaan isaa keessa dubbii ni keessa; anis afaan keetii fi afaan isaa wajjin nan taʼa; waan isin hojjettanis isin nan barsiisa. ");
INSERT INTO gaz_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Inni uummatatti siif dubbata; inni afaan siif taʼa; ati immoo isaaf akka Waaqaa ni taata. ");
INSERT INTO gaz_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ati ulee ittiin mallattoo argisiiftu kana harkatti qabadhu.” ");
INSERT INTO gaz_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Museen gara abbaa niitii isaa gara Yetrootti deebiʼee, “Akka ani gara saba koo warra Gibxi jiraatanitti deebiʼee hamma ammaatti lubbuun jiraachuu isaanii arguuf maaloo naa eeyyami” jedheen. Yootooris, “Nagaan dhaqi” jedheen. ");
INSERT INTO gaz_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Waaqayyo Midiyaanitti Museedhaan, “Namoonni si ajjeesuu barbaadan hundi duʼaniiruutii Gibxitti deebiʼi” jedhee ture. ");
INSERT INTO gaz_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Kanaafuu Museen niitii isaatii fi ilmaan isaa fuudhatee harree irra kaaʼee Gibxitti deebiʼe. Innis ulee Waaqaa harkatti qabatee ture. ");
INSERT INTO gaz_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Waaqayyo Museedhaan akkana jedhe; “Ati yeroo Gibxitti deebitutti dinqiiwwan ani akka ati hojjetuuf humna siif kenne sana hunda fuula Faraʼoon duratti hojjedhu. Ani garuu akka inni saba sana gad hin lakkifne mata jabeessa isa nan godha. ");
INSERT INTO gaz_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Ati Faraʼooniin akkana jedhi; ‘Waaqayyo akkana jedha: Israaʼel ilma koo hangafa; ");
INSERT INTO gaz_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","anis, “Akka ilmi koo na tajaajiluuf gad lakkisi” jedhee sitti himeera. Ati garuu isa gad lakkisuu didde; kanaafuu, kunoo ani ilma kee hangafa nan ajjeesa.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Waaqayyo karaa irratti iddoo bultiitti Museetti dhufee isa ajjeesuu barbaade. ");
INSERT INTO gaz_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Ziphooraa garuu dhagaa qara qabu fudhattee qola dhagna ilma ishee kuttee ittiin miilla Musee tuqxe. Isheenis, “Ati dhugumaan anaaf misirricha dhiigaati” jette. ");
INSERT INTO gaz_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Waaqayyos isa dhiise. Yeroo sana isheen waaʼee dhagna qabaatiif, “Misirricha dhiigaa ti” jette. ");
INSERT INTO gaz_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Waaqayyos Arooniin, “Ati Musee simachuuf gara gammoojjii dhaqi!” jedhe. Innis dhaqee Tulluu Waaqaa irratti Musee argatee isa dhungate. ");
INSERT INTO gaz_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Yeroo sana Museen dubbii Waaqayyo akka inni dubbatuuf isa erge hundaa fi mallattoowwan akka inni hojjetuuf isa ajaje hunda Aroonitti hime. ");
INSERT INTO gaz_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Musee fi Aroon maanguddoota Israaʼel hunda walitti qaban; ");
INSERT INTO gaz_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aroonis waan Waaqayyo Museetti hime hunda jaratti hime. Mallattoowwanis fuula namootaa duratti hojjete; ");
INSERT INTO gaz_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","isaanis ni amanan. Jarris yommuu akka Waaqayyo saba Israaʼel ilaalee fi akka inni rakkina isaaniis arge dhagaʼanitti gad jedhanii sagadan. ");
INSERT INTO gaz_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Ergasii Musee fi Aroon Faraʼoon bira dhaqanii, “Waaqayyo Waaqni Israaʼel akkana jedha; ‘Akka inni gammoojjiitti ayyaana naa ayyaanessuuf saba koo gad dhiisi.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Faraʼoon immoo, “Akka ani isaaf ajajamee Israaʼelin gad dhiisuuf Waaqayyo kun eenyu? Ani Waaqayyo sana hin beeku; Israaʼelinis gad hin dhiisu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Isaanis akkana jedhan; “Waaqni Ibrootaa nutti dhufeera. Akka nu Waaqayyo Waaqa keenyaaf aarsaa dhiʼeessinuuf gara gammoojjiitti karaa guyyaa sadii nuu eeyyami; akkas taʼuu baannaan inni dhaʼichaan yookaan goraadeedhaan nu dhaʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mootiin Gibxi garuu, “Yaa Musee fi Aroon, isin maaliif saba kana hojii dhowwitu? Hojii keessanitti deebiʼaa!” isaaniin jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Faraʼoonis ittuma fufee, “Kunoo sabni biyyattii amma baayʼateera; isin immoo hojii isaan dhowwaa jirtu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Guyyuma sana Faraʼoon akkana jedhee itti gaafatamtoota hojiitii fi qondaaltota sabaa ajaje; ");
INSERT INTO gaz_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","“Siʼachi xuubii hojjechuudhaaf saba kanaaf cidii hin kenninaa; isaan ofuma isaaniitii dhaqanii cidii haa barbaaddatan. ");
INSERT INTO gaz_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Garuu akka isaan lakkoobsa xuubii kan duraan hojjechaa turan sana hojjetan godhaa; hamma isaanitti ramadame hin hirʼisinaa. Isaan dhibaaʼoo dha; kanaafuu, ‘Nu dhaqnee Waaqa keenyaaf aarsaa dhiʼeessina’ jedhanii iyyaa jiru. ");
INSERT INTO gaz_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Akka isaan hojiidhaan qabamanii dubbii sobaatiif xiyyeeffannoo hin kennineef hojii isaanitti cimsaa.” ");
INSERT INTO gaz_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Itti gaafatamtoonni hojiitii fi qondaaltonni sabaa gad yaaʼanii saba sanaan akkana jedhan; “Faraʼoon akkana jedha: ‘Ani siʼachi cidii isinii hin kennu. ");
INSERT INTO gaz_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Lafa itti argachuu dandeessan dhaqaatii ofii keessanii cidii barbaaddadhaa; hojiin keessan garuu gonkumaa hin hirʼatu.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Sabni sun qooda cidii, haafa walitti qabachuuf jedhee biyya Gibxii guutuu keessa faffacaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Itti gaafatamtoonni sunis, “Isin hojii keessan kan guyyaa guyyaa akkuma yeroo cidiin ture sanaatti hojjedhaa raawwadhaa” jedhanii isaan jarjarsaa turan. ");
INSERT INTO gaz_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Israaʼeloonni qondaaltota hojii taʼan kanneen itti gaafatamtoota garboota Faraʼooniin muudamanis reebamanii, “Isin kaleessaa fi harʼa maaliif qooda xuubii kan akka hojjettaniif isinii ramadame sana akkuma duriitti hin guuttanne?” jedhamanii gaafatamaa turan. ");
INSERT INTO gaz_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Israaʼeloonni toʼattoota hojii taʼanis dhaqanii akkana jedhanii Faraʼoonitti iyyatan; “Ati maaliif tajaajiltoota kee akkas goota? ");
INSERT INTO gaz_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Cidiin tajaajiltoota keetiif hin kennamu; taʼus, ‘Xuubii hojjedhaa!’ nuun jedhan. Kunoo tajaajiltoonni kee reebamaa jiru; balleessaan garuu kanuma saba keetii ti.” ");
INSERT INTO gaz_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Faraʼoonis akkana jedhe; “Isin dhibaaʼoo dha; isin dhibaaʼoo dha! Kanaafuu isin, ‘Nu dhaqnee Waaqayyoof aarsaa dhiʼeessina’ jettan. ");
INSERT INTO gaz_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","Amma dhaqaatii hojjedhaa; cidiin isiniif hin kennamu; garuu xuubii isinitti ramadame hojjetanii guutuu qabdu.” ");
INSERT INTO gaz_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Israaʼeloonni toʼattoota hojii taʼan yommuu, “Isin lakkoobsa xuubii kan guyyaa guyyaatti akka hojjettaniif isin irraa eegamu sana hirʼisuu hin qabdan” jedhamee isaanitti himametti akka rakkina keessa seenan hubatan. ");
INSERT INTO gaz_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Yeroo Faraʼoon biraa gad baʼanitti utuu Musee fi Aroon isaan eeganuu argatan; ");
INSERT INTO gaz_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","isaanis, “Waan isin akka Faraʼoonii fi qondaaltonni isaa nu xireeffatan gootanii akka isaan nu ajjeesaniif goraadee harka isaanii keessa keessaniif Waaqayyo isinitti haa ilaalu; isinitti haa murus!” jedhan. ");
INSERT INTO gaz_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Museen gara Waaqayyootti deebiʼee akkana jedhe; “Yaa Gooftaa, ati maaliif saba kanatti rakkina fidde? Ati kanaaf na ergitee? ");
INSERT INTO gaz_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Gaafa ani maqaa keetiin dubbachuuf Faraʼoon bira dhaqee jalqabee inni saba keetti rakkinuma fidaa jira; ati garuu gonkumaa saba kee hin furre.” ");
INSERT INTO gaz_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Waaqayyos Museedhaan, “Amma waan ani Faraʼoon irratti hojjedhu ati ni argita: sababii irree koo jabaa sanaatiif mootichi gad isaan dhiisa; sababii irree koo jabaa sanaatiifis mootichi biyya isaa keessaa isaan ariʼa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Waaqni ammas Museedhaan akkana jedhe; “Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","Ani akka Waaqa Waan Hunda Dandaʼuuttan Abrahaamitti, Yisihaaqittii fi Yaaqoobitti mulʼadhe; garuu maqaa koo Waaqayyoon isaanitti of hin beeksifne. ");
INSERT INTO gaz_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Akkasumas ani biyya Kanaʼaan lafa isaan akka alagaatti keessa jiraattan sana isaanii kennuuf jedhee isaan wajjin kakuu galeera. ");
INSERT INTO gaz_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Kana irrattis, ani aaduu saba Israaʼel kanneen warra Gibxiin garboomfaman sanaa dhagaʼee kakuu koo yaadadheera. ");
INSERT INTO gaz_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","“Kanaafuu saba Israaʼeliin akkana jedhi: ‘Ani Waaqayyo; waanjoo warra Gibxi jalaa isin nan baasa; ani garbummaa isaanii jalaa isin nan baasa; irree diriiraa fi murtii jabaadhaanis isin nan fura. ");
INSERT INTO gaz_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ani akka saba ofii kootti isin fudhadha; Waaqa keessan nan taʼa. Yeroo sana isin akka ani Waaqayyo Waaqa keessan kan waanjoo warra Gibxi jalaa isin baase taʼe ni beektu. ");
INSERT INTO gaz_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Ani biyya isan Abrahaamiif, Yisihaaqii fi Yaaqoobiif kennuuf harka koo ol qabadhee kakadhe sanatti isin nan galcha. Dhaala godhees isiniif kenna. Ani Waaqayyo.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Museenis waan kana saba Israaʼelitti hime; isaan garuu waan abdii kutatanii fi garbummaa hamaa keessa turaniif isa hin dhageenye. ");
INSERT INTO gaz_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","“Dhaqiitii akka inni biyya isaa keessaa Israaʼeloota gad lakkisuuf Faraʼoon mooticha Gibxitti himi.” ");
INSERT INTO gaz_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Museen garuu Waaqayyoon, “Kunoo Israaʼeloonni na hin dhageenye; yoos Faraʼoon akkamitti na dhagaʼa ree? Afaan koo qajeelchee hin dubbatatuutii” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Waaqayyo garuu waaʼee Israaʼelootaatii fi waaʼee Faraʼoon mooticha Gibxi Musee fi Aroonitti dubbatee akka isaan saba Israaʼel Gibxii baasan isaan ajaje. ");
INSERT INTO gaz_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Hangafoonni balbalawwan isaanii kanneenii dha: Ilmaan Ruubeen ilma Israaʼel hangaftichaa: Henook, Faluus, Hezroonii fi Karmii. ");
INSERT INTO gaz_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Ilmaan Simiʼoon: Yemuuʼeel, Yaamiin, Oohad, Yaakiin, Zoohar, Shaawul ilma dubartittii Kanaʼaan. ");
INSERT INTO gaz_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Maqaan ilmaan Lewwiis akkuma dhaloota isaaniitti kanaa dha: Geershoon, Qohaatii fi Meraarii. ");
INSERT INTO gaz_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Ilmaan Geershoon akkuma maatii isaaniitti: Loobeenii fi Shimeʼii. ");
INSERT INTO gaz_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Ilmaan Qohaati: Amraam, Yizihaar, Kebroonii fi Uziiʼeel. Qohaati waggaa 133 jiraate. ");
INSERT INTO gaz_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Ilmaan Meraarii: Mahilii fi Muusii. ");
INSERT INTO gaz_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amraam obboleettii abbaa isaa Yookebeedin fuudhe; isheenis Aroonii fi Musee deesseef. ");
INSERT INTO gaz_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Ilmaan Yizihaar: Qooraahi, Naafegii fi Zikrii. ");
INSERT INTO gaz_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Ilmaan Uziiʼeel: Miishaaʼeel, Elzaafaanii fi Sitrii. ");
INSERT INTO gaz_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aroon intala Amiinaadaab obboleettii Nahishoon Eliishebaa fuudhe; isheenis Naadaab, Abiihuu, Eleʼaazaarii fi Iitaamaarin deesseef. ");
INSERT INTO gaz_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Ilmaan Qooraahi: Asiir, Elqaanaa fi Abiiʼaasaaf. ");
INSERT INTO gaz_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Eleʼaazaar ilmi Aroon intallan Fuutʼeel keessaa tokko fuudhe; isheenis Fiinehaasin deesseef. ");
INSERT INTO gaz_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Aroonii fi Museen warri Waaqayyo, “Isin akkuma kutaa kutaa isaaniitti Gibxi keessaa Israaʼeloota baasaa” jedheen sun isaanuma kana. ");
INSERT INTO gaz_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Isaanis warra waaʼee Gibxi keessaa Israaʼeloota baasuu Faraʼoon mooticha Gibxitti dubbatan sanaa dha. Musee fi Aroon isaanuma kana. ");
INSERT INTO gaz_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Waaqayyo yeroo Gibxi keessatti Museetti dubbate sana ");
INSERT INTO gaz_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","akkana jedheen; “Ani Waaqayyoo dha. Waan ani sitti himu hunda Faraʼoon mooticha Gibxitti himi.” ");
INSERT INTO gaz_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Museen garuu Waaqayyoon, “Kunoo, ani waan afaan koo qajeelchee dubbachuu hin dandeenyeef Faraʼoon akkamiin na dhagaʼa?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Waaqayyo Museedhaan akkana jedhe; “Ilaa, ani Faraʼooniif waaqa si godheera; obboleessi kee Aroon immoo raajii siif taʼa. ");
INSERT INTO gaz_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ati waan ani si ajaju hunda ni dubbata; obboleessi kee Aroon immoo akka inni Israaʼeloota biyya isaa keessaa gad dhiisu Faraʼoonitti ni hima. ");
INSERT INTO gaz_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ani garuu Faraʼoonin mata jabeessa nan godha; yoo ani biyya Gibxi keessatti mallattoowwanii fi dinqiiwwan koo baayʼise iyyuu, ");
INSERT INTO gaz_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","inni isin hin dhaggeeffatu. Ani harka koo Gibxi irratti ol nan kaasa; murtii jabaadhaanis raayyaa koo, saba Israaʼel biyya Gibxi keessaa nan baasa. ");
INSERT INTO gaz_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Warri Gibxi yommuu ani harka koo Gibxi irratti ol kaafadhee saba Israaʼel achi keessaa baasutti akka ani Waaqayyo taʼe ni beeku.” ");
INSERT INTO gaz_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Musee fi Aroonis akkuma Waaqayyo isaan ajaje godhan. ");
INSERT INTO gaz_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Yeroo Faraʼoonitti dubbatanitti Museen nama waggaa saddeettama ture; Aroon immoo nama waggaa saddeettamii sadii ture. ");
INSERT INTO gaz_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Waaqayyos Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","“Yommuu Faraʼoon, ‘Dinqii hojjedhaa’ isiniin jedhutti, ati immoo Arooniin, ‘Ulee kee fuudhiitii fuula Faraʼoon duratti lafa buusi’ jetta; uleen sunis bofa taʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Musee fi Aroon Faraʼoon bira dhaqanii akkuma Waaqayyo isaan ajaje sana godhan. Aroon fuula Faraʼoonii fi qondaaltota isaa duratti ulee isaa lafa buuse; uleen sunis bofa taate. ");
INSERT INTO gaz_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Faraʼoonis beektotaa fi falfaltoota ofitti waame; tolfattoonni Gibxi ogummaa isaanii dhokataa sanaan akkasuma godhan. ");
INSERT INTO gaz_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Tokkoon tokkoon isaanii ulee isaanii lafa buusan; uleen isaaniis bofa taʼe. Uleen Aroon garuu ulee isaanii liqimsite. ");
INSERT INTO gaz_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Taʼus Faraʼoon akkuma Waaqayyo dubbate sana mata jabeessa taʼee isaan dhaggeeffachuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Kana irratti Waaqayyo Museedhaan akkana jedhe; “Faraʼoon mata jabeessa taʼeera; saba sanas gad dhiisuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Ganamaan gara Faraʼoon dhaqi; kunoo inni bishaanitti gad baʼa. Ulee bofatti geeddaramte sana harkatti qabadhuutii qarqara laga Abbayyaatti isa eegi. ");
INSERT INTO gaz_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Akkanas jedhiin; ‘Waaqayyo Waaqni Ibrootaa akkana jedhee sitti na ergeera: Akka sabni koo dhaqee gammoojjii keessatti naaf sagaduuf gad lakkisi. Ati garuu hamma ammaatti ajajamuu diddeerta. ");
INSERT INTO gaz_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Waaqayyo akkana jedha: Akka ani Waaqayyo taʼe ati kanaan beekta: Kunoo ani ulee harka koo keessa jiru kanaan bishaan Abbayyaa nan dhaʼa; bishaan sunis dhiigatti geeddarama. ");
INSERT INTO gaz_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Qurxummiiwwan laga Abbayyaa keessaa ni duʼu; lagni sunis ni ajaaʼa; warri Gibxis bishaan laga sanaa dhuguu hin dandaʼan.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Waaqayyo immoo Museedhaan akkana jedhe; “Arooniin akkana jedhi; ‘Ulee kee qabadhuutii bishaanota Gibxi irratti, lageen isaanii irratti, doloolloo isaanii irratti, haroo isaaniitii fi kuusaa bishaanii hunda irratti harka kee diriirsi.’ Isaanis dhiigatti geeddaramu. Gibxi guutuun dhiigaan guutama; qodaan mukaatii fi okkoteen dhagaa dhiigaan guutaman.” ");
INSERT INTO gaz_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Musee fi Aroon akkuma Waaqayyo isaan ajaje sana godhan. Aroon ulee isaa ol fuudhee fuula Faraʼooniitii fi qondaaltota isaa duratti bishaan Abbayyaa dhaʼe; bishaan sun hundis dhiigatti geeddarame. ");
INSERT INTO gaz_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Qurxummiiwwan Abbayyaa duunaan lagichi ajaaʼe; warri Gibxis bishaan isaa dhuguu hin dandeenye. Gibxi guutuunis dhiigaan guutame. ");
INSERT INTO gaz_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Garuu tolfattoonni Gibxi tolcha isaaniitiin akkasuma hojjetan; Faraʼoonis mata jabeessa taʼe. Innis akkuma Waaqayyo jedhe sana Musee fi Aroon dhagaʼuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Faraʼoonis deebiʼee masaraa isaa seene; innis waan kana yaadatti illee hin qabanne. ");
INSERT INTO gaz_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Warri Gibxi hundi waan bishaan laga sanaa dhuguu hin dandaʼiniif bishaan dhugaatii baafachuuf jedhanii qarqara Abbayyaa qotatan. ");
INSERT INTO gaz_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Erga Waaqayyo Abbayyaan dhaʼee guyyaan torba darbe. ");
INSERT INTO gaz_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Waaqayyo Museedhaan akkana jedhe; “Faraʼoon bira dhaqii akkana jedhiin; ‘Waaqayyo akkana jedha: Akka sabni koo na tajaajiluuf gad dhiisi. ");
INSERT INTO gaz_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Yoo ati gad isa dhiisuu didde immoo kunoo ani biyya kee guutuutti dhaʼicha fattee nan erga. ");
INSERT INTO gaz_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Lagni Abbayyaa fatteedhaan guutuma; isaanis ol baʼanii mana keetti, dinqa keetti, siree keetti, mana hojjettoota keetiitti, saba keetti, iddoo ibiddaa keetti, qodaa bukoo keetiittis namʼu. ");
INSERT INTO gaz_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Fatteewwan kunneen siʼii fi saba kee, qondaaltota kee hundas ni yaabbatu.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Waaqayyo Museedhaan akkana jedhe; “Arooniin akkana jedhi; ‘Ulee kee qabadhuutii harka kee burqaawwan irratti, lageenii fi kuusaa bishaanii irratti ol kaafadhuutii akka fatteewwan biyya Gibxitti dhufan godhi.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Aroon harka isaa bishaanota Gibxitti ol kaafate; fatteewwanis ol baʼanii biyya sana guutan. ");
INSERT INTO gaz_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Tolfattoonnis falfala isaaniitiin akkasuma godhan; biyya Gibxittis fatteewwan fidan. ");
INSERT INTO gaz_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Faraʼoonis Musee fi Aroonin ofitti waamee, “Akka inni anaa fi saba koo irraa fatteewwan fageessuuf Waaqayyo kadhadhaa; anis akka sabni keessan dhaqee Waaqayyoof aarsaa dhiʼeessuuf gadin dhiisa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Museenis Faraʼooniin, “Akka fatteewwan siʼii fi manneen kee irraa badanii laga Abbayyaa qofa keessatti hafaniif yeroo ani itti siif, qondaaltota keetii fi saba keetiif illee Waaqa kadhadhu ati na beeksisi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Faraʼoon immoo, “Bor” jedheen. Museenis akkana jedhee deebise; “Waaqayyo Waaqa keenyaa fakkaatu kan tokko iyyuu akka hin jirre akka beektuuf akkuma ati jettu taʼa. ");
INSERT INTO gaz_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Fatteewwan sun siʼii fi manneen kee irraa, qondaaltota keetii fi saba kee irraa ni badu; laga Abbayyaa qofa keessattis ni hafu.” ");
INSERT INTO gaz_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Musee fi Aroon erga Faraʼoon biraa gad baʼanii booddee Museen waaʼee fatteewwan Waaqni Faraʼoonitti erge sanaa Waaqayyotti iyye. ");
INSERT INTO gaz_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Waaqayyos akkuma Museen kadhate godhe. Fatteewwan sunis mana keessatti, oobdii irratti, dirree irrattis dhuman. ");
INSERT INTO gaz_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Fatteewwan sunis walitti qabamanii tuulaman; biyyattiinis ni ajoofte. ");
INSERT INTO gaz_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Faraʼoon garuu yommuu akka dhaʼichi sun qabbanaaʼe argetti akkuma Waaqayyo dubbatee ture sana mata jabeessa taʼee Musee fi Aroonin dhagaʼuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Ergasiis Waaqayyo Museedhaan, “Arooniin, ‘Ulee kee ol kaasiitii awwaara lafaa dhaʼi’ jedhi; awwaarri sunis biyya Gibxi guutuu keessatti injiraan taʼa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Isaanis akkasuma godhan. Yommuu Aroon harka isaa isa ulee qabate ol kaafatee awwaara lafaa dhaʼetti injiraan namaa fi horiitti duudde. Awwaarri guutuu biyya Gibxi keessa jiru hundi injiraan taʼe. ");
INSERT INTO gaz_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Tolfattoonni garuu falfala isaaniitiin injiraan gad yaasuu yaalanii dadhaban. Injiraanis namaa fi horii irra ture. ");
INSERT INTO gaz_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Tolfattoonnis Faraʼooniin, “Kun quba Waaqaa ti” jedhan. Faraʼoon garuu akkuma Waaqayyo dubbate sana mata jabeessa taʼee dhagaʼuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Waaqayyo Museedhaan akkana jedhe; “Ganama barii kaʼiitii fuula Faraʼoon duratti dhiʼaadhu; kunoo inni gara bishaanitti gad baʼa; akkanas jedhiin; ‘Waaqayyo akkana jedha: Akka inni na tajaajiluuf saba koo gad dhiisi. ");
INSERT INTO gaz_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Yoo ati saba koo gad dhiisuu didde immoo kunoo, ani tuuta tisiisaa sitti, qondaaltota keetti, saba keetti, manneen keetti nan erga. Manneen warra Gibxi, lafti isaan jiraatanis tisiisaan guutamu. ");
INSERT INTO gaz_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","“ ‘Ani garuu guyyaa sana iddoo sabni koo jiraatu Gooshenin haala addaatiin nan ilaala; akka ati akka ani Waaqayyo biyya kana keessa jiru beektuuf tisiisni tokko iyyuu achi hin jiraatu. ");
INSERT INTO gaz_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ani saba kootii fi saba kee gidduutti garaa garummaa nan uuma. Mallattoon kunis bori taʼa.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Waaqayyos akkasuma godhe. Tisiisni baayʼeen mana Faraʼoonii fi manneen qondaaltota isaatti duude; biyyi Gibxi guutuunis tisiisaan balleeffame. ");
INSERT INTO gaz_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Faraʼoonis Musee fi Aroonin ofitti waamee, “Dhaqaatii biyyuma kana keessatti Waaqa keessaniif aarsaa dhiʼeessaa” jedheen. ");
INSERT INTO gaz_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Museen immoo deebisee akkana jedhe; “Akkas gochuun qajeelaa hin taʼu; aarsaan nu Waaqayyo Waaqa keenyaaf dhiʼeessinu warra Gibxi biratti jibbamaa dha. Kunoo, yoo nu aarsaa fuula isaanii duratti jibbamu dhiʼeessine isaan dhagaadhaan nu hin tumanii ree? ");
INSERT INTO gaz_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Akkuma inni nu ajajetti nu Waaqayyo Waaqa keenyaaf aarsaa dhiʼeessuuf gara gammoojjii karaa guyyaa sadii deemuu qabna.” ");
INSERT INTO gaz_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Faraʼoonis, “Ani akka isin gammoojjii keessatti Waaqayyo Waaqa keessaniif aarsaa dhiʼeessitaniif gadin isin dhiisa; garuu baayʼee fagaattani hin deeminaa. Isinis Waaqa naa kadhadhaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Museenis akkana jedhee deebise; “Kunoo, ani akkuman si biraa deemeen akka bor tisiisni Faraʼoon irraa, qondaaltota isaatii fi saba isaa irraa kaʼu Waaqayyo nan kadhadha. Yaa Faraʼoon ati garuu, akka sabni kun Waaqayyoof aarsaa dhiʼeessuuf gad dhiisuu diddee ammas nu hin gowwoomsin.” ");
INSERT INTO gaz_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Museenis ergasii Faraʼoon biraa baʼee Waaqayyo kadhate; ");
INSERT INTO gaz_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Waaqayyos akkuma Museen isa kadhate sana godhe; tisiisni sunis Faraʼoonin, qondaaltota isaatii fi saba isaa gad dhiisee deeme; tisiisni tokko iyyuu hin hafne. ");
INSERT INTO gaz_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Faraʼoon garuu ammas mata jabeessa taʼe; saba sanas gad dhiisuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Waaqayyo Museedhaan akkana jedhe; “Faraʼoon bira dhaqiitii akkana jedhiin; ‘Waaqayyo Waaqni Ibrootaa akkana jedha; “Akka sabni koo na tajaajiluuf gad dhiisi.” ");
INSERT INTO gaz_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Yoo ati gad dhiisuu diddee isaan danqite, ");
INSERT INTO gaz_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","kunoo harki Waaqayyoo horii kee kanneen dirree irra oolan fardeen, harrootaa fi gaalawwan keetti, loon, hoolotaa fi reʼoota keetti dhaʼicha hamaa ni fida. ");
INSERT INTO gaz_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Waaqayyo garuu akka horiin saba Israaʼel tokko iyyuu hin duuneef horii Israaʼelii fi horii warra Gibxi gidduutti garaa garummaa ni uuma.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Waaqayyo yeroo murteessee, “Waaqayyo bor waan kana biyyattii keessatti ni hojjeta” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Waaqayyos guyyaa itti aanutti waan kana hojjete: Horiin warra Gibxi hundi ni dhume; horii warra Israaʼel keessaa garuu tokko iyyuu hin duune. ");
INSERT INTO gaz_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Faraʼoonis namoota qoratan ergee, kunoo akka horii saba Israaʼel keessaa tokko illee hin duʼin beeke. Taʼus Faraʼoon mata jabeessa taʼee saba sana gad dhiisuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Waaqayyo immoo Musee fi Arooniin akkana jedhe; “Daaraa harka guutuu iddoo ibiddaatii hammaaraa; Museenis daaraa sana fuula Faraʼoon duratti samiitti ol haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Innis biyya Gibxi guutuu keessatti awwaara taʼa; dhullaan malaa yaasu namaa fi horii guutuu biyyattii keessa jiranitti yaaʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Isaan boolla ibiddaa irraa daaraa hammaarratanii fuula Faraʼoon dura dhaabatan. Museenis daaraa sana samiitti ol facaase; dhullaan malaa yaasus namaa fi horiitti yaaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Tolfattoonnis sababii dhullaatiif Musee dura dhaabachuu hin dandeenye; dhullaan tolfattootaa fi warra Gibxi hundatti yaaʼee tureetii. ");
INSERT INTO gaz_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Garuu Waaqayyo akkuma Museetti hime sana Waaqayyo Faraʼoonin mata jabeessa godhe; innis Musee fi Aroonin dhagaʼuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Waaqayyo Museedhaan akkana jedhe; “Ganama barii kaʼiitii fuula Faraʼoon dura dhaabadhu; akkanas jedhiin; ‘Waaqayyo Waaqni Ibrootaa akkana jedha; akka sabni koo na tajaajiluuf gad dhiisi; ");
INSERT INTO gaz_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","yoo kanaa achii ani amma dhaʼicha koo hunda sitti, qondaaltota keetii fi saba keetti nan erga; kunis akka ati akka Waaqni akka koo lafa hunda irra hin jirre beektuuf. ");
INSERT INTO gaz_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Silaa amma ani harka koo ol fudhadhee siʼii fi saba kee dhukkuba hamaan dhaʼuu nan dandaʼa ture; atis lafa irraa badda turte. ");
INSERT INTO gaz_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Ani garuu humna koo sirratti argisiisuu fi akka maqaan koo lafa hunda irratti labsamuuf jedheen kaayyoo kanaaf si jiraachise. ");
INSERT INTO gaz_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ati amma iyyuu saba koo irratti ol ol of qabda; jaras gad hin dhiiftu. ");
INSERT INTO gaz_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Kunoo ani bori yeroo akkanaatti cabbii hamaa erga Gibxi hundeeffamtee jalqabee hamma ammaatti takkumaa Gibxitti hin buʼin tokko nan buusa. ");
INSERT INTO gaz_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Egaa amma nama ergiitii horii keetii fi waan alaa qabdu hunda manatti galchisiisi; cabbiin sunis namaa fi horii manatti hin galin kanneen alatti hafan hundatti ni buʼa; isaanis ni dhumu.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Qondaaltota Faraʼoon keessaa warri dubbii Waaqayyoo sodaatan garboota isaaniitii fi horii isaanii manatti galfachuuf ariifatanii sokkan. ");
INSERT INTO gaz_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Warri dubbii Waaqayyootiif xiyyeeffannoo hin kennin immoo garboota isaaniitii fi horii isaanii alatti dhiisan. ");
INSERT INTO gaz_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Waaqayyo Museedhaan, “Akka cabbiin biyya Gibxi hundatti namatti, horii fi biqiltuu lafa qotiisaa Gibxi hunda irratti buʼuuf harka kee gara samiitti diriirsi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Yommuu Museen ulee isaa gara samiitti diriirsettis Waaqayyo kakawwee fi cabbii erge; ibiddis gara lafaatti gad buʼe. Waaqayyos biyya Gibxitti cabbii roobse; ");
INSERT INTO gaz_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","cabbiin ni buʼe; ibiddis cabbii wajjin wal make. Cabbiin hamaan akkanaa erga Gibxi saba taatee beekamtee as takkumaa guutuu biyyattiitti hin buune. ");
INSERT INTO gaz_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Cabbiin sunis biyya Gibxi keessatti waan ala jiru hunda namas horiis ni dhaʼe; biqiltuu lafa qotiisaa hundas ni balleesse; muka hundas ni barbadeesse. ");
INSERT INTO gaz_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Lafti cabbiin itti hin buʼin biyya Gooshen iddoo Israaʼeloonni jiraatan qofa ture. ");
INSERT INTO gaz_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Faraʼoonis Musee fi Aroonin ofitti waamee akkana jedheen; “Ani amma cubbuu hojjedheera; Waaqayyo qajeelaa dha; anii fi sabni koo garuu balleessaa hojjenneerra. ");
INSERT INTO gaz_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Sababii bakakkaa fi cabbiin nutti baayʼateef isin Waaqayyoon nuuf kadhadhaa. Anis gad isin nan dhiisa; isin hammana caalaa as turuu hin qabdan.” ");
INSERT INTO gaz_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Museenis akkana jedhee deebise; “Ani yommuu magaalaa kana keessaa baʼutti harka koo balʼisee Waaqayyo nan kadhadha. Bakakkaan ni dhowwama; cabbiinis siʼachi hin jiraatu; kanaanis ati akka lafti kan Waaqayyoo taate ni beekta. ");
INSERT INTO gaz_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Ani garuu akka atii fi qondaaltonni kee amma iyyuu Waaqayyo Waaqa hin sodaanne nan beeka.” ");
INSERT INTO gaz_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Waan talbaan daraaree, garbuun immoo bilchaatee tureef talbaa fi garbuun ni badan. ");
INSERT INTO gaz_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Qamadii fi honboriin garuu waan turanii bilchaataniif hin badne. ");
INSERT INTO gaz_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Museenis Faraʼoon biraa deemee magaalaa keessaa gad baʼe; innis harka isaa gara Waaqayyootti balʼise; bakakkaa fi cabbiin ni dhowwaman. Bokkaanis deebiʼee biyyattiitti hin roobne. ");
INSERT INTO gaz_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Faraʼoonis yommuu akka bokkaan, cabbii fi bakakkaan dhowwaman argetti ammas cubbuu hojjete; innii fi qondaaltonni isaa mata jabeeyyii taʼan. ");
INSERT INTO gaz_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Akkuma Waaqayyo karaa Museetiin dubbate sana, Faraʼoon mata jabeessa taʼe; saba Israaʼelis gad dhiisuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Waaqayyos Museedhaan akkana jedhe; “Faraʼoonitti ol seeni; ani akka mallattoowwan koo kanneen isaan gidduutti hojjedhuuf jedhee Faraʼoonii fi qondaaltota isaa mata jabeeyyii godheera; ");
INSERT INTO gaz_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","kunis akka ati waan ani warra Gibxi godhe, mallattoo ani isaan gidduutti argisiises ijoollee keetii fi ijoollee ijoollee keetiitti himtee akka ani Waaqayyo taʼe akka beektaniif taʼe.” ");
INSERT INTO gaz_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Musee fi Aroonis Faraʼoon bira dhaqanii akkana jedhaniin; “Waaqayyo Waaqni Ibrootaa akkana jedha: ‘Ati hamma yoomiitti fuula koo duratti gad of qabuu didda? Akka isaan na tajaajilaniif saba koo gad dhiisi. ");
INSERT INTO gaz_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Yoo ati gad isaan dhiisuu didde, kunoo ani bori biyya keetti hawwaannisa nan fida. ");
INSERT INTO gaz_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Hawwaannisni kunis hamma namni tokko iyyuu arguu dadhabutti lafa haguuga. Innis waanuma cabbii irraa isinii hafe illee ni fixa; mukkeen alatti isinii guddachaa jiranis nyaatee fixa. ");
INSERT INTO gaz_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Inni mana kee, mana qondaaltota keetii hundaa fi mana warra Gibxi hundumaa guuta; kunis waan abbootiin keetii fi abbootiin abbootii keetii gaafa biyya kana qubatanii jalqabanii hamma harʼaatti hin arginii dha.’ ” Kana booddee Museen garagalee Faraʼoon biraa baʼe. ");
INSERT INTO gaz_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Qondaaltonni Faraʼoonis, “Namichi kun hamma yoomiitti kiyyoo nutti taʼa? Namoonni kun akka Waaqayyo Waaqa isaanii tajaajilaniif gad dhiisi. Akka Gibxi badde ati amma illee hin hubannee?” jedhaniin. ");
INSERT INTO gaz_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Musee fi Aroonin deebisanii Faraʼoonitti geessan; Faraʼoonis, “Dhaqaatii Waaqayyo Waaqa keessan waaqeffadhaa! Garuu eenyutu deema?” jedheen. ");
INSERT INTO gaz_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Museenis, “Nu sababii ayyaana Waaqayyoo ayyaaneffannuuf dargaggoota keenyaa fi maanguddoota keenya, ilmaanii fi intallan keenya, bushaayee fi loon keenya qabannee deemna” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Faraʼoonis akkana jedhe; “Yoo ani dubartoota keessanii fi ijoollee keessan isin wajjin gad dhiise, mee Waaqayyo isin wajjin haa taʼu! Kunoo waan hamaatu isin dura jira. ");
INSERT INTO gaz_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Kun hin taʼu! Akka warri dhiiraa qofti dhaqanii Waaqayyo waaqeffatan godhaa; isin kanuma barbaaddaniitii.” Isaanis fuula Faraʼoon duraa gad baafaman. ");
INSERT INTO gaz_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Waaqayyos Museedhaan, “Akka hawwaannisni biyya Gibxitti buʼee biqiltuu lafa qotiisaa hunda, waan cabbii irraa hafe hundas nyaatuuf harka kee Gibxi irratti diriirsi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Museenis ulee isaa Gibxi irratti diriirsinaan Waaqayyo guyyaa sana guutuu fi halkan sana guutuu akka bubbeen baʼa biiftuu biyyattii keessatti bubbisu godhe; ganama itti aanus bubbeen sun hawwaannisa fidee dhufe; ");
INSERT INTO gaz_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","hawwaannisni sunis Gibxi guutuu weerare; biyya hunda keessas baayʼinaan qubate. Dhaʼichi hawwaannisaa kan akkasii duraan takkumaa buʼee hin beeku; ergasiis takkumaa deebiʼee hin buune. ");
INSERT INTO gaz_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Hawwaannisni sunis hamma lafti gurraachaʼutti lafa hunda haguuge; innis waan cabbii irraa hafe hunda, waan alatti biqile hunda, ija mukaa illee ni nyaate. Biyya Gibxi hunda keessatti wanni lalisaan tokko iyyuu muka irratti yookaan biqiltuu irratti hin hafne. ");
INSERT INTO gaz_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Faraʼoonis dafee Musee fi Aroonin waamee akkana jedheen; “Ani Waaqayyo Waaqa keessanii fi isinitti cubbuu hojjedheera. ");
INSERT INTO gaz_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Egaa mee cubbuu koo naa dhiisaa; akka inni dhaʼicha nama ajjeesu kana narraa fuudhuufis Waaqayyo Waaqa keessan naa kadhadhaa.” ");
INSERT INTO gaz_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Museenis Faraʼoon biraa gad baʼee Waaqayyo kadhate. ");
INSERT INTO gaz_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Waaqayyos bubbee sana gara bubbee lixa biiftuu jabaatti geeddare; bubbeen sunis hawwaannisa sana fuudhee Galaana Diimaatti naqe. Gibxi keessatti hawwaannisni tokko iyyuu hin hafne. ");
INSERT INTO gaz_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Waaqayyo garuu Faraʼoonin mata jabeessa godhe; Faraʼoonis Israaʼeloota gad hin dhiifne. ");
INSERT INTO gaz_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Waaqayyo immoo Museedhaan, “Akka dukkanni Gibxi irra buʼuuf harka kee gara samiitti diriirsi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Museen harka isaa gara samiitti diriirse; dukkanni limixiin isaa guyyaa sadii Gibxi guutuu haguuge. ");
INSERT INTO gaz_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Guyyaa sadan sana namni wal hin argu ture; lafa jiruus hin sochoʼu ture. Israaʼeloonni hundi garuu iddoo jiraatanitti ifa qabu turan. ");
INSERT INTO gaz_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Faraʼoonis Musee ofitti waamee, “Dhaqaatii Waaqayyo waaqeffadhaa. Dubartoonnii fi ijoolleen keessanis isin wajjin haa deemani; bushaayee fi loon keessan qofa dhiisaa deemaa” jedheen. ");
INSERT INTO gaz_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Museen garuu akkana jedhe; “Ati akka nu Waaqayyo Waaqa keenyaaf aarsaa fi qalma gubamu dhiʼeessinuuf nuu eeyyamuu qabda. ");
INSERT INTO gaz_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Horiin keenyas nu wajjin dhaquu qaba; kotteen tokko iyyuu hin hafu. Waaqayyo Waaqa keenya waaqeffachuuf isaan keessaa tokko tokkotti fayyadamna; hamma achi geenyutti Waaqayyo waaqeffachuuf maalitti akka fayyadamnu hin beeknu.” ");
INSERT INTO gaz_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Waaqayyo garuu Faraʼoonin mata jabeessa godhe; innis gad isaan dhiisuu dide. ");
INSERT INTO gaz_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Faraʼoonis Museedhaan, “Fuula koo duraa badi! Lammata fuula koo akka hin argine beekkadhu; ati gaafa fuula koo argite ni duuta!” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Museenis deebisee, “Akkuma ati jette, ani lammata fuula keetti hin mulʼadhu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Waaqayyo Museedhaan akkana jedhe; “Ani amma illee dhaʼicha tokko Faraʼoonii fi Gibxitti nan fida. Ergasii inni asii isin baasa; yeroo asii isin baasutti immoo inni guutumaan guutuutti isin ariʼa. ");
INSERT INTO gaz_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Akka tokkoon tokkoon dhiiraatii fi tokkoon tokkoon dubartii ollaa isaanii irraa miʼa meetiitii fi miʼa warqee ergifatan saba kanatti himi.” ");
INSERT INTO gaz_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Waaqayyo akka sabni Israaʼel fuula warra Gibxi duratti surraa argatan godhe; kana malees Museen biyya Gibxi keessatti, fuula qondaaltota Faraʼooniitii fi fuula saba Gibxi duratti akka malee ulfina qabeessa ture. ");
INSERT INTO gaz_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Museen akkana jedhe; “Waaqayyo akkana jedha; ‘Ani gara halkan walakkaatti Gibxi hunda keessa nan darba. ");
INSERT INTO gaz_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","Ilma Faraʼoon namicha teessoo irra taaʼu sanaa hangafaa jalqabee hamma ilma xomboree ishee midhaan daaktu sanaa hangafaatti ilmi hangafni biyya Gibxi keessaa hundi ni duʼa; akkasumas hangafni horii hundi ni duʼa. ");
INSERT INTO gaz_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Biyya Gibxi guutuu keessattis wawwaachuu guddaan takkumaa dhagaʼamee hin beekin yookaan deebiʼees hin dhagaʼamne tokko ni dhufa. ");
INSERT INTO gaz_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Garuu saba Israaʼel keessaa nama tokkotti iyyuu yookaan horii tokkotti iyyuu sareen tokko iyyuu hin duttu.’ Isinis waan kanaan akka Waaqayyo Gibxii fi Israaʼel gidduutti garaa garummaa fidu ni beektu. ");
INSERT INTO gaz_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Qondaaltonni kee kunneen hundinuu gara koo dhufanii naa sagadan; ‘Atis, namoonni si duukaa buʼan hundinuus deemaa!’ jedhu; anis ergasii nan deema.” Museenis akka malee aaree Faraʼoon biraa baʼe. ");
INSERT INTO gaz_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Waaqayyo Museedhaan, “Akka dinqiin koo biyya Gibxitti baayʼatuuf Faraʼoon isin dhagaʼuu dida” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Musee fi Aroonis dinqiiwwan kanneen hunda fuula Faraʼoon duratti hojjetan; Waaqayyo garuu Faraʼoonin mata jabeessa godhe; innis akka Israaʼeloonni biyya isaa keessaa hin baane dhowwe. ");
INSERT INTO gaz_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Waaqayyos biyya Gibxi keessatti Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","“Jiʼi kun jiʼa jalqabaa isinii haa taʼu; innis waggaa keessaa jiʼa jalqabaa isinii haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Jiʼa kana keessa bultii kurnaffaatti tokkoon tokkoon namaa xobbaallaa hoolaa tokko akkuma manneen abbootii isaaniitti tokkoo tokkoo manaatii fi xobbaallaa hoolaa tokko akka fudhatu guutummaa hawaasa Israaʼelitti himaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Yoo warri mana tokko jiraatan muraasa taʼanii hoolaa tokko guutummaatti fixuu baatan, isaan akkuma baayʼina namoota achi jiraataniitti ollaa isaanitti aanu wajjin haa qoodatan. Isinis akkuma waan tokkoon tokkoon namaa nyaachuu dandaʼuutti xobbaallaa hoolaa hammam akka barbaachisu murteessuu qabdu. ");
INSERT INTO gaz_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Xobbaallaan keessan ilmoo hoolaa waggaa tokkoo kan mudaa hin qabne taʼuu qaba; xobbaallaa sanas hoolota keessaa yookaan reʼoota keessaa fudhachuu dandeessu. ");
INSERT INTO gaz_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Xobbaallaa sanas hamma bultii kudha afuraffaa jiʼa kanaatti eegaa; yaaʼiin waldaa Israaʼel guutuunis galgala sana xobbaallaa sana haa qalatu. ");
INSERT INTO gaz_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Ergasii immoo dhiiga sana irraa xinnoo fuudhanii michichila balbalaa lamaanii fi buusaa balbalaa isa ol aanu kan mana itti xobbaallaa sana nyaatanii haa diban. ");
INSERT INTO gaz_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Isaanis halkanuma sana foon sana ibiddaan waaddatanii biqiltuu hadhooftuu fi maxinoon haa nyaatan. ");
INSERT INTO gaz_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Ibiddaan waaddadhaatii nyaadhaa malee foon dheedhii yookaan kan bishaaniin affeelame hin nyaatinaa; mataa isaa, lukaa fi miʼa garaa wajjin waaddadhaatii nyaadhaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Hamma lafti bariitutti homaa hin hambisinaa; waan hamma ganamaatti irraa hafu garuu gubaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Haalli isin itti nyaattanis kunoo ti; mudhii keessan hidhadhaa; kophee keessan miillatti kaaʼadhaa; ulee keessan illee harkatti qabadhaatii jarjarsuun nyaadhaa; inni Faasiikaa Waaqayyoo ti. ");
INSERT INTO gaz_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","“Anis halkanuma sana Gibxi keessa nan darba; hangafa Gibxis namaa fi horii nan dhaʼa; waaqota Gibxi hundattis nan mura; ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Dhiigni sunis manneen isin keessa jiraattan irratti mallattoo isinii taʼa; ani yommuun dhiiga sana argutti isin irra nan darba. Yeroo ani biyya Gibxi dhaʼuttis dhaʼichi badiisaa tokko iyyuu isin hin tuqu. ");
INSERT INTO gaz_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","“Guyyaan kun guyyaa yaadannoo isiniif haa taʼu; akka ayyaanaatti Waaqayyoof ni ayyaaneffattu; dhaloota keessan hunda keessattis sirna bara baraa godhattanii ni eegdu. ");
INSERT INTO gaz_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","Isin bultii torba maxinoo nyaachuu qabdu; guyyaa jalqabaatti mana keessanii raacitii baasaa gataa; namni kam iyyuu guyyaa jalqabaatii kaasee hamma guyyaa torbaffaatti yoo buddeena bukaaʼe nyaate saba Israaʼel keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Guyyaa jalqabaatti wal gaʼii qulqulluu qabaadhaa; wal gaʼii qulqulluu biraa immoo guyyaa torbaffaatti qabaadhaa. Waan namni hundi nyaatu qopheessuu malee guyyoota kanneen hojii tokko iyyuu hin hojjetinaa; wanni isin hojjechuu dandeessan kanuma. ");
INSERT INTO gaz_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","“Sababii guyyaan ani itti raayyaa keessan Gibxi keessaa baase guyyuma kana taʼeef Ayyaana Maxinoo kana ayyaaneffadhaa; guyyaa kanas sirna bara baraa godhadhaatii dhaloota keessan hunda keessatti ayyaaneffadhaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Isin jiʼa jalqabaa keessa galgala bultii kudha afuraffaadhaa hamma galgala guyyaa digdamii tokkoffaatti maxinoo nyaattu. ");
INSERT INTO gaz_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Bultii torbaaf raacitiin tokko illee mana keessanitti hin argamin; alagaas taʼu dhalataan biyyaa, namni waan raacitii qabu nyaatu kam iyyuu waldaa Israaʼel keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Waan raacitii qabu tokko illee hin nyaatinaa; lafa jiraattan hundatti Maxinoo nyaadhaa.” ");
INSERT INTO gaz_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Museen maanguddoota Israaʼel hunda ofitti waamee akkana jedheen; “Dhaqaatii maatii keessaniif xobbaallaa filadhaatii Faasiikaa qalaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Hiisophii qabaa tokkoo fuudhaa; dhiiga waciitii keessa jiru sana keessa cuuphaatii michichila balbalaa lamaanii fi buusaa balbalaa isa ol aanu dibaa. Isin keessaa namni tokko iyyuu hamma lafti bariitutti balbala mana ofii isaatii gad hin baʼin. ");
INSERT INTO gaz_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Waaqayyo yeroo warra Gibxi dhaʼuuf biyyattii keessa darbutti michichila balbalaa lamaan irrattii fi buusaa balbalaa isa ol aanu irratti dhiiga sana argee balbala sana bira darba; akka inni waa balleessu sun mana keessan seenee isin ajjeesus hin eeyyamuuf. ");
INSERT INTO gaz_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","“Isinis qajeelfama kana akka seera bara baraa kan isinii fi sanyii keessaniif kennameetti kabajaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Isinis yeroo biyya Waaqayyo akkuma waadaa gale sanatti isinii kennu seentanitti sirna kana eegaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Yommuu ijoolleen keessan, ‘Sirni kun isiniif hiikkaa maalii qaba?’ jedhanii isin gaafatanitti, ");
INSERT INTO gaz_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","akkana jedhaa isaanitti himaa; ‘Kun qalma Faasiikaa Waaqayyoo ti; inni yeroo warra Gibxi dhaʼetti manneen Israaʼeloota Gibxi keessa turan sanaa irra darbee manneen keenya nuuf oolcheeraatii.’ ” Kana irratti namoonni gad jedhanii waaqeffatan. ");
INSERT INTO gaz_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Israaʼeloonnis akkuma Waaqayyo Musee fi Aroonin ajaje sana godhan. ");
INSERT INTO gaz_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Halkan walakkaatti Waaqayyo ilma Faraʼoon namicha teessoo irra taaʼu hangafaa jalqabee hamma ilma namicha boolla mana hidhaa keessa jiru hangafaatti hangafoota Gibxi hunda dhaʼe; hangafoota horiis akkasuma dhaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Faraʼoonii fi qondaaltonni isaa hundi, warri Gibxi hundis halkaniin kaʼan; sababii manni namni keessaa hin duʼin tokko iyyuu hin turiniif booʼicha guddaatu Gibxi keessa ture. ");
INSERT INTO gaz_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Faraʼoonis halkan sanaan Musee fi Aroonin ofitti waamee akkana jedhe; “Kaʼaa! Isinii fi Israaʼeloonni saba koo keessaa baʼaa! Akkuma gaafattan sana dhaqaatii Waaqayyoon waaqeffadhaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Akkuma jettan sana bushaayee fi loon keessan fudhadhaatii deemaa; anas eebbisaa.” ");
INSERT INTO gaz_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Warri Gibxis akka sabni sun dafee biyya sanaa baʼu jarjarsan; isaanis, “Yoo kanaa achii nu hundi ni dhumnaa” jedhan. ");
INSERT INTO gaz_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Kanaafuu sabni sun bukoo isaanii utuu hin bukaaʼin fudhatanii, qodaa bukoo isaaniis wayyaa isaaniitiin maranii gatiittiitti baadhatan. ");
INSERT INTO gaz_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israaʼeloonnis akkuma Museen isaanitti hime sana godhan; isaanis miʼa meetiitii fi warqee, wayyaas warra Gibxi gaafatan. ");
INSERT INTO gaz_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Sababii Waaqayyo fuula warra Gibxi duratti Israaʼelootaaf surraa kenneef, warri Gibxi waan isaan gaafatan hunda kennaniif; isaanis akkasiin qabeenya warra Gibxi boojiʼanii baʼan. ");
INSERT INTO gaz_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israaʼeloonnis Raamseedhaa kaʼanii Sukootitti qajeelan. Isaanis nadheenii fi ijoollee malee namoota lafoo gara kuma dhibba jaʼa turan. ");
INSERT INTO gaz_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Uummanni walitti makame hedduun, akkasumas horiin jechuunis bushaayee fi loon baayʼeen isaan wajjin baʼan. ");
INSERT INTO gaz_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Isaanis bukoo Gibxi fudhatanii dhufan sana irraa Maxinoo tolfatan. Sababii isaan jarjarsuudhaan Gibxi keessaa baafamanii yeroo itti nyaata qopheeffatan illee dhabaniif bukoon sun raacitii hin qabu ture. ");
INSERT INTO gaz_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Barri Israaʼeloonni Gibxi keessa jiraatan waggaa 430 ture. ");
INSERT INTO gaz_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Dhuma waggaa 430 sanaatti guyyuma sana raayyaan Waaqayyoo hundi biyya Gibxiitii baʼe. ");
INSERT INTO gaz_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Waaqayyo Gibxi keessaa isaan baasuudhaaf dammaqee halkan sana waan isaan eegeef, halkan kun Israaʼeloota hundumaaf halkan itti Waaqayyoof ulfina kennuudhaaf dammaqanii eeganii dha. ");
INSERT INTO gaz_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Waaqayyos Musee fi Arooniin akkana jedhe; “Seerri Faasiikaa kanaa dha: “Ormi tokko iyyuu isa irraa hin nyaatin. ");
INSERT INTO gaz_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","Garbichi bitame kam iyyuu erga dhagna qabdanii booddee haa nyaatu; ");
INSERT INTO gaz_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","keessummaan yookaan namni hojjetaan qacarame garuu hin nyaatin. ");
INSERT INTO gaz_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","“Hoolaan sun manuma tokko keessatti haa nyaatamu; foon isaa tokko iyyuu manaa gad hin baasinaa. Lafee isaa keessaas tokko iyyuu hin cabsinaa. ");
INSERT INTO gaz_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","Waldaan Israaʼel hundis ayyaana kana haa ayyaaneffatu. ");
INSERT INTO gaz_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","“Ormi isin wajjin jiraatu yoo Faasiikaa Waaqayyoo ayyaanessuu barbaade inni dhiirota mana isaa jiraatan hunda dhagna haa qabu; ergasiis akkuma dhalataa biyyaatti ayyaanicha haa ayyaanessu. Dhiirri dhagna hin qabatin tokko iyyuu garuu hoolaa sana hin nyaatin. ");
INSERT INTO gaz_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Dhalataa biyyaatiifis taʼu orma isin gidduu jiraatuuf seerri tokkuma.” ");
INSERT INTO gaz_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israaʼeloonni hundis akkuma Waaqayyo Musee fi Aroonin ajaje sana godhan. ");
INSERT INTO gaz_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Waaqayyos gaafuma sana kutaa kutaa isaaniitiin Israaʼeloota biyya Gibxi keessaa baase. ");
INSERT INTO gaz_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","“Dhiira hangafa hunda addaan naa baasi; Israaʼeloota keessaa namas taʼu horiin hangafni gadameessa banu kam iyyuu kan koo ti.” ");
INSERT INTO gaz_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Yommus Museen uummataan akkana jedhe; “Sababii Waaqayyo irree jabaadhaan achii isin baaseef guyyaa itti mana garbummaatii Gibxi keessaa baatan kana yaadadhaa. Waan raacitii qabu tokko illee hin nyaatinaa. ");
INSERT INTO gaz_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Isin jiʼa Abiibii keessa guyyaa harʼaa baatan. ");
INSERT INTO gaz_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Yeroo Waaqayyo gara biyya Kanaʼaanotaa, Heetotaa, Amoorotaa, biyya Hiiwotaa fi Yebuusotaatti jechuunis biyya aannanii fi damma baasu kan inni akka siif kennu abbootii keetiif kakate sanatti si galchutti ati jiʼa kana keessa ayyaana kana ayyaaneffatta; ");
INSERT INTO gaz_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","ati bultii torba Maxinoo nyaatta; guyyaa torbaffaatti immoo ayyaana Waaqayyoo taʼa. ");
INSERT INTO gaz_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Guyyaa torban sana Maxinoo nyaadhu; wanni raacitii qabu tokko iyyuu si biratti hin argamin; daangaa kee hunda keessattis raacitiin hin argamin. ");
INSERT INTO gaz_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Gaafas, ‘Ani waan Waaqayyo yeroo ani Gibxi keessaa baʼetti naa godhe sanaaf jedhee waan kana godha’ jedhiitii ilma keetti himi. ");
INSERT INTO gaz_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Sirni kunis akka seerri Waaqayyoo arraba kee irra jiraatuuf harka kee irratti akka mallattoo, adda kee irratti immoo akka yaadannoo siif taʼa. Waaqayyo harka isaa jabaa sanaan Gibxii si baaseetii. ");
INSERT INTO gaz_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Atis sirna kana wagguma waggaan yeroo isaatti eeguu qabda. ");
INSERT INTO gaz_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","“Yommuu Waaqayyo akkuma siʼii fi abbootii keetiif kakuudhaan waadaa gale sanatti biyya Kanaʼaanotaatti si galchee biyyattii siif kennutti, ");
INSERT INTO gaz_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ati hangafa gadameessa banu hunda Waaqayyoof kennita. Kormi horii keetii hangafni hundinuus kan Waaqayyoo ti. ");
INSERT INTO gaz_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Harree hangafa kam iyyuu ilmoo hoolaatiin furi; yoo furuu baatte garuu morma isaa cabsi. Ilmaan kee keessaas hangafa kam iyyuu furi. ");
INSERT INTO gaz_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","“Bara dhufuuf jiru keessa yoo ilmi kee, ‘Kun maal jechuu dha?’ jedhee si gaafate ati akkana jedhiin; ‘Waaqayyo harka jabaadhaan Gibxii, mana garbummaa keessaa nu baase. ");
INSERT INTO gaz_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Yommuu Faraʼoon mataa jabaatee gad nu dhiisuu didetti, Waaqayyo hangafa Gibxi hunda namaa fi horii ajjeese. Sababiin ani korma hangafa gadameessa banu hunda Waaqayyoof aarsaa dhiʼeessuu fi sababiin ani ilmaan koo keessaa hangafa hunda furuuf kanuma.’ ");
INSERT INTO gaz_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Waaqayyo irree jabaadhaan Gibxii nu baasuu isaatiif wanni kun harka kee irratti mallattoo, adda kee irrattis mallattoo taʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Yeroo Faraʼoon saba sana gad dhiisetti karichi gabaabaa taʼu iyyuu Waaqni karaa biyya Filisxeem irra isaan hin qajeelchine; sababiin isaas Waaqni, “Isaan yoo waraanni isaan mudate yaada geeddarratanii Gibxitti deebiʼuu dandaʼan” jedhee ti. ");
INSERT INTO gaz_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Kanaafuu Waaqni karaa naannoo gammoojjiitiin gara Galaana Diimaatti saba sana qajeelche. Israaʼeloonnis waraanaaf qophaaʼanii biyya Gibxiitii baʼan. ");
INSERT INTO gaz_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Sababii Yoosef, “Waaqni dhugumaan isin gargaara; isinis gaafas lafee koo asii fuudhaa baʼaa” jedhee Israaʼeloonni kakachiisee tureef Museen lafee Yoosef fuudhee baʼe. ");
INSERT INTO gaz_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Isaanis Sukootii kaʼanii Eetaam keessa qarqara gammoojjii qubatan. ");
INSERT INTO gaz_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Waaqayyo akka isaan halkanii guyyaa deemuu dandaʼaniif guyyaa utubaa duumessaatiin isaan dura deemee karaa isaan argisiise; halkan immoo isaaniif ibsuuf jedhee utubaa ibiddaatiin isaan dura deemaa ture. ");
INSERT INTO gaz_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Utubaan duumessaa guyyaa guyyaa, utubaan ibiddaa immoo halkan halkan uummata duraa hin dhabamne ture. ");
INSERT INTO gaz_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Ergasii Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","“Akka isaan of irra garagalanii Phii Hahiiroti bira, Migdoolii fi galaana gidduu qubatan Israaʼelootatti himi. Isaan fuullee Baʼaal Zefoon, galaana cina qubachuu qabu. ");
INSERT INTO gaz_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Faraʼoonis, ‘Israaʼeloonni burjaajaʼanii biyya keessa jooraa jiru; gammoojjiin isaan marseera’ jedhee yaade. ");
INSERT INTO gaz_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Anis garaa Faraʼoon nan jabeessa; inni faana dhaʼee isaan duukaa buʼa. Anis karaa Faraʼooniitii fi karaa loltoota isaa hundaatiin ofii kootiif ulfina nan argadha; warri Gibxi akka ani Waaqayyo taʼe ni beeku.” Israaʼeloonnis akkasuma godhan. ");
INSERT INTO gaz_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Mootiin Gibxi akka sabni sun baqatee baʼe yommuu itti himametti Faraʼoonii fi qondaaltonni isaa yaada waaʼee saba sanaa qaban geeddarratanii, “Akka sabni Israaʼel nu tajaajiluu dhiisee deemuuf gad dhiisuun keenya maal gochuu keenya?” jedhan. ");
INSERT INTO gaz_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Innis gaarii isaa qopheeffatee, loltoota isaas fudhatee kaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Gaariiwwan filatamoo dhibba jaʼa, gaariiwwan Gibxi biraa hunda kanneen ajajjuuwwan isaan hunda irra jiran fudhatee kaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Waaqayyos Faraʼoon mooticha Gibxi mata jabeessa godhe; Faraʼoonis Israaʼeloota warra sodaa malee baʼaa turan sana duukaa buʼee ariʼe. ");
INSERT INTO gaz_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Warri Gibxis fardeenii fi gaariiwwan Faraʼoon hundi, abbootiin fardaatii fi loltoonni lafoon Israaʼeloota duukaa buʼanii isaanii Phii Hahiiroti bira fuullee Baʼaal Zefoon qarqara galaanaa qubatanii jiran qaqqaban. ");
INSERT INTO gaz_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Yeroo Faraʼoon itti dhiʼaatettis Israaʼeloonni ol ilaalanii kunoo warri Gibxi dugda duubaan isaan faana dhufan argan. Isaanis sodaatanii Waaqayyotti iyyatan. ");
INSERT INTO gaz_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Isaanis Museedhaan akkana jedhan; “Ati waan iddoon awwaalaa Gibxi hin jirreef akka nu gammoojjii keessatti dhumnuuf as nu fiddee? Ati Gibxi nu baasuun kee maal nu gochuu kee ti? ");
INSERT INTO gaz_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nu Gibxi keessatti, ‘Akka warra Gibxi tajaajilluuf nu dhiisi’ siin hin jennee? Gammoojjii keessatti dhumuu irra warra Gibxi tajaajiluu nuu wayya ture!” ");
INSERT INTO gaz_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Museen akkana jedhee saba sanaaf deebise; “Hin sodaatinaa; jabaadhaa dhaabadhaa! Fayyisuu Waaqayyoo kan inni harʼa isinii godhu ilaalaa! Warra Gibxi kan harʼa argitan kana lammata deebitanii hin argitan. ");
INSERT INTO gaz_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Waaqayyo isiniif lola; isin gab jedhaa.” ");
INSERT INTO gaz_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Waaqayyos Museedhaan akkana jedhe; “Ati maaliif natti iyyita? Akka isaan adeemsa isaanii itti fufaniif Israaʼelootatti himi. ");
INSERT INTO gaz_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ulee kee ol fuudhiitii harka kee galaana irra diriirfadhu; akka Israaʼeloonni lafa gogaa irra galaana gidduu darbaniif bishaan gargari qoodi. ");
INSERT INTO gaz_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Ani immoo akka isaan dugda isaanii duubaan seenaniif garaa warra Gibxi nan jabeessa. Anis Faraʼoonii fi loltoota isaa hunda irratti, gaariiwwan isaatii fi abbootii fardaa isaa irratti ulfina nan argadha. ");
INSERT INTO gaz_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Yeroo ani Faraʼoon irratti, gaariiwwan isaatii fi abbootii fardaa isaa irratti ulfina argadhutti warri Gibxi akka ani Waaqayyo taʼe ni beeku.” ");
INSERT INTO gaz_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Yommus ergamaan Waaqayyoo kan saba Israaʼel dura deemaa ture sun kaʼee gara dugda isaanii duubaatti darbe. Utubaan duumessaa sunis fuula isaanii duraa kaʼee isaan duuba dhaabate; ");
INSERT INTO gaz_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","utubaan sunis loltoota Gibxii fi loltoota Israaʼel gidduu seene. Duumessi sun halkan sana gama tokkotti dukkana, gama kaanitti immoo ifa fide; kanaafuu halkan sana guutuu garee lamaan keessaa tokko illee garee kaanitti hin dhiʼaanne. ");
INSERT INTO gaz_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Museenis harka isaa galaana irra diriirfate; Waaqayyos halkan sana guutuu bubbee baʼa biiftuu jabaadhaan galaanicha gara duubaatti deebisee galaanicha lafa gogaa godhe. Bishaan sunis gargari qoodame; ");
INSERT INTO gaz_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israaʼeloonnis galaanicha gidduu lafa gogaa irra darban; bishaanichis karaa mirgaa isaaniitii fi karaa bitaa isaanii keenyan taʼeef. ");
INSERT INTO gaz_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Warri Gibxi isaan duukaa buʼanii fardeen Faraʼoon, gaariiwwan isaatii fi abbootiin fardaa isaa galaana seenan. ");
INSERT INTO gaz_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Yommuu lafti bariʼetti Waaqayyo utubaa ibiddaatii fi duumessaa keessaa loltoota Gibxi sana gad ilaalee gara itti goran isaan wallaalchise. ");
INSERT INTO gaz_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Akka isaan rakkinaan oofaniifis gommaa gaariiwwan isaanii irraa baase. Warri Gibxis, “Waan Waaqayyo gama Israaʼelootaa dhaabatee warra Gibxi lolaa jiruuf kottaa isaan duraa baqannaa” jedhan. ");
INSERT INTO gaz_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Waaqayyos Museedhaan, “Akka bishaanonni warra Gibxi irra, gaariiwwanii fi abbootii fardaa isaanii irra garagalaniif harka kee galaana irratti diriirsi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Museenis harka isaa galaanicha irratti diriirse; yeroo lafti bariʼettis galaanni sun iddoo isaatti deebiʼe. Warri Gibxis bishaan sana jalaa baqatan; Waaqayyos haxaaʼee galaanatti isaan naqe. ");
INSERT INTO gaz_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Bishaan sun iddoo isaatti deebiʼee gaariiwwanii fi abbootii fardaa jechuunis loltoota Faraʼoon kanneen Israaʼeloota duukaa buʼanii galaana seenan sana hunda liqimse. Isaan keessaas namni tokko iyyuu hin hafne. ");
INSERT INTO gaz_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Israaʼeloonni garuu bishaanichi karaa mirga isaaniitii fi karaa bitaa isaaniitiin keenyan taʼeefii galaanicha keessa lafa gogaa irra darban. ");
INSERT INTO gaz_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Gaafas Waaqayyo harka warra Gibxi jalaa Israaʼeloota baase; warri Israaʼelis reeffa warra Gibxi qarqara galaanaatti argan. ");
INSERT INTO gaz_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Israaʼeloonnis yommuu humna guddaa kan Waaqayyo warra Gibxi irratti mulʼise sana arganitti, Waaqayyoon sodaatan; isaanis Waaqayyoo fi tajaajilaa isaa Musee amanan. ");
INSERT INTO gaz_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Yommus Musee fi Israaʼeloonni Faarfannaa kana Waaqayyoof faarfatan: “Ani Waaqayyoof nan faarfadha; inni ol ol jedheeraatii. Inni fardaa fi namicha farda yaabbate galaanatti gad darbateera. ");
INSERT INTO gaz_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","“Waaqayyo jabina kootii fi faarfannaa koo ti; inni fayyina koo taʼeera. Inni Waaqa koo ti; anis isa nan jajadha; inni Waaqa abbaa kootii ti; anis isa ol ol nan qaba. ");
INSERT INTO gaz_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Waaqayyo goota waraanaa ti; maqaan isaa Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Inni gaariiwwan Faraʼoonii fi loltoota isaa galaanatti gad darbateera. Qondaaltota Faraʼoon keessaa filatamtoonni, Galaana Diimaa keessa dhidhimaniiru. ");
INSERT INTO gaz_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Tuujubni isaan irra gara gale; isaanis akkuma dhagaa tuujubatti gad dhidhiman. ");
INSERT INTO gaz_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","Yaa Waaqayyo, harki kee mirgaa humnaan ulfina qabeessa. Yaa Waaqayyo, harki kee mirgaa diina ni hurreessa. ");
INSERT INTO gaz_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","“Ati guddina ulfina keetiitiin warra siin morman gad darbatte. Aarii kee bobaʼaa ni ergite; innis akkuma habaqiitti gubee isaan fixe. ");
INSERT INTO gaz_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Hafuura funyaan keetiitiin bishaanonni tuulaman. Bishaan yaaʼu akkuma keenyaniitti ol dhaabate; tuujuboonnis walakkaa galaanaatti ititan. ");
INSERT INTO gaz_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","Diinni, ‘Ani faana buʼee isaan qaqqaba. Boojuu nan qoodadha; ani isaan irratti fedhii koo nan guutadha. Goraadee koo nan luqqifadha; harki koo isaan barbadeessa’ jedhee nan dhaadate. ");
INSERT INTO gaz_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ati garuu bubbee kee itti bubbifte; galaanni immoo isaan irra gara gale. Isaanis akkuma sibiilaa bishaanota jajjaboodhaan liqimfaman. ");
INSERT INTO gaz_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","Yaa Waaqayyo, waaqota keessaa eenyutu si fakkaata? Qulqullinaan simboo qabeessi, ulfinaan sodaachisaan, hojii dinqii hojjechuuttis kan akka keetii eenyu? ");
INSERT INTO gaz_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","“Ati harka kee mirgaa diriirfannaan, lafti isaan liqimsite. ");
INSERT INTO gaz_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","Ati saba furte sana, jaalala kee hin geeddaramneen geggeessita. Jabina keetiinis gara iddoo jireenya keetii qulqulluutti isaan qajeelchita. ");
INSERT INTO gaz_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Saboonni dhagaʼanii hollatu; muddamsuunis saba Filisxeem qabate. ");
INSERT INTO gaz_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Hangafoonni Edoom ni rifatu; bulchitoota Moʼaabis naasuutu qabata; warri Kanaʼaanis bishaanuma taʼu; ");
INSERT INTO gaz_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","sodaa fi abdii kutachuun isaan irra buʼa. Yaa Waaqayyo, hamma sabni kee darbutti, hamma sabni ati bitatte sun darbutti jabina harka keetiitiin isaan akkuma dhagaa calʼisu. ");
INSERT INTO gaz_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Yaa Waaqayyo, ati gara tulluu dhaala keetiitti, gara lafa iddoo jireenya keetii godhachuuf tolfatteetti, yaa Gooftaa ati gara iddoo qulqulluu harki kee hundeesseetti ol galchitee isaan dhaabda. ");
INSERT INTO gaz_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","“Waaqayyo, bara baraa hamma bara baraatti moʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Yommuu fardeen, gaariiwwanii fi abbootiin fardaa kan Faraʼoon galaana seenanitti Waaqayyo bishaanota isaan irra garagalche; Israaʼeloonni garuu lafa gogaa irra deemanii galaana keessa darban. ");
INSERT INTO gaz_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Miiriyaam obboleettiin Aroon raajittiin sun dibbee harkatti qabattee kaate; dubartoonni hundinuus dibbee isaanii fudhatanii sirbaa ishee faana buʼan. ");
INSERT INTO gaz_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miiriyaamis akkana jettee isaaniif faarfatte: “Waaqayyo faarfadhaa; inni ulfinaan moʼateeraatii. Inni fardaa fi namicha farda yaabbate galaanatti gad darbateera.” ");
INSERT INTO gaz_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Museenis saba Israaʼel Galaana Diimaa biraa fuudhee qajeelche; isaanis Gammoojjii Shuuri seenan. Israaʼeloonnis utuu bishaan hin argatin guyyaa sadii gammoojjii keessa deeman. ");
INSERT INTO gaz_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Isaanis yommuu Maaraa gaʼanitti bishaan isaa dhuguu hin dandeenye; bishaan sun hadhaaʼaa tureetii. Wanni iddoon sun Maaraa jedhameefis kanuma. ");
INSERT INTO gaz_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Jarri sunis, “Nu maal haa dhugnuu?” jedhanii Museetti guunguman. ");
INSERT INTO gaz_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Yommus Museen Waaqayyotti iyyinaan, Waaqayyo muka tokko isa argisiise. Innis muka sana bishaanitti gad darbate; bishaan sunis ni miʼaawe. Waaqayyos iddoo sanatti sirnaa fi seera isaaniif baase; achittis isaan qore. ");
INSERT INTO gaz_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Innis akkana jedhe; “Ati yoo sagalee Waaqayyo Waaqa keetii garaa tokkoon dhageesse, yoo waan fuula isaa duratti qajeelaa taʼe hojjette, yoo ajaja isaa qalbeeffattee fi yoo seera isaa hunda eegde, ani dhukkuba warra Gibxitti fide sana keessaa tokko iyyuu sitti hin fidu; ani Waaqayyo si fayyisuudhaatii.” ");
INSERT INTO gaz_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Isaanis gara Eelim iddoo burqaan kudha lamaa fi mukkeen meexxii torbaatamni turan dhufanii achi bishaan bira qubatan. ");
INSERT INTO gaz_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Waldaan Israaʼel hundi biyya Gibxiitii baʼanii jiʼa lammaffaatti, jiʼa sana keessaas guyyaa kudha shanaffaatti Eeliimii kaʼanii gara gammoojjii Siin isa Eelimii fi Siinaa gidduu jiru sanaa dhaqan. ");
INSERT INTO gaz_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Gammoojjii keessattis hawaasni sun guutuun Musee fi Aroonitti guunguman. ");
INSERT INTO gaz_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","Israaʼeloonnis akkana isaaniin jedhan; “Nu biyya Gibxitti yeroo okkotee foonii bira teenyee hamma quufnutti buddeena nyaachaa turre sana harka Waaqayyootti utuu duuneerra taʼee! Isin garuu akka waldaan kun guutuun beelaʼee dhumu gochuuf achii nu baaftanii gammoojjii kanatti nu fiddaniirtu.” ");
INSERT INTO gaz_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Waaqayyo immoo Museedhaan akkana jedhe; “Kunoo, ani samii irraa buddeena gad isinii nan roobsa. Sabni sunis guyyuma guyyaan gad baʼee waan guyyaa tokkoof isa gaʼu walitti haa qabatu. Anis karaa kanaan isaan qoree seera koo eeguu fi eeguu baachuu isaanii nan ilaala. ");
INSERT INTO gaz_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Isaanis guyyaa jaʼaffaatti waan walitti qabatan sana haa qopheeffatan; wanni kunis waan isaan guyyaa biraa walitti qabatanitti harka lama haa taʼu.” ");
INSERT INTO gaz_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Musee fi Aroon Israaʼeloota hundaan akkana jedhan; “Kan biyya Gibxiitii isin baase Waaqayyo akka taʼe galgala kana ni beektu. ");
INSERT INTO gaz_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Ganama immoo ulfina Waaqayyoo argitu; inni akka isin isatti guungumtan dhagaʼeeraatii. Nu eenyu taanaan isin nutti guungumtu?” ");
INSERT INTO gaz_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Museenis akkana jedhe; “Yeroo inni akka isin nyaattaniif galgala foon, ganama immoo buddeena isin barbaaddan hunda isinii kennutti isin akka inni Waaqayyo taʼe ni beektu; inni guungummii isin isatti guungumtan dhagaʼeeraatii. Nu eenyuu dha? Isin Waaqayyotti guungumaa jirtu malee nutti hin guungumne.” ");
INSERT INTO gaz_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Yommus Museen, “Waldaa Israaʼel hundaan, ‘Sababii inni akka isin guungumtan dhagaʼeef isin fuula Waaqayyoo duratti dhiʼaadhaa’ jedhi” jedhee Aroonitti hime. ");
INSERT INTO gaz_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Yeroo Aroon guutummaa waldaa saba Israaʼelitti dubbachaa turetti isaan gara gammoojjii ilaalaa turan; kunoo, ulfinni Waaqayyoo duumessa keessaan mulʼate. ");
INSERT INTO gaz_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Waaqayyos Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","“Ani guungummii saba Israaʼel dhagaʼeera. Ati immoo, ‘Isin yeroo lafti dimimmisooftutti foon nyaattu; ganama immoo buddeena nyaattanii quuftu. Isinis yeroo sana akka ani Waaqayyo Waaqa keessan taʼe ni beektu’ jedhii isaanitti himi.” ");
INSERT INTO gaz_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Galgaluma sana dimbiriqqeen dhuftee iddoo qubannaa sana guutte; guyyaa itti aanu ganama immoo fixeensi naannoo qubannaa sanaa ture. ");
INSERT INTO gaz_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Yommuu fixeensi buʼettis, kunoo wantoonni haphiin akka qorraa lafa irraa addaatan dirree gammoojjii irra bubbuʼan. ");
INSERT INTO gaz_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israaʼeloonnis yommuu waan kana arganitti, “Wanni kun maali?” waliin jedhan. Isaan wanni sun maal akka taʼe hin beekne tureetii. Museenis akkana isaaniin jedhe; “Wanni kun buddeena akka isin nyaattaniif Waaqayyo isiniif kennee dha. ");
INSERT INTO gaz_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Waaqayyo akkana jedhee ajajeera: ‘Tokkoon tokkoon namaa hamma barbaadu walitti haa qabatu. Akkuma baayʼina nama dunkaana keessan keessaatti tokkoo tokkoo namaatiif gomoorii tokko fudhadhaa.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israaʼeloonni akkuma isaanitti himame godhan; garri tokko baayʼee, warri kaan immoo xinnoo walitti qabatan. ");
INSERT INTO gaz_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","Yommuu isaan gomooriidhaan safaranitti isa baayʼee walitti qabate irraa hin hafne; isa xinnoo walitti qabatettis hin hirʼanne. Tokkoon tokkoon namaa hammuma barbaadu walitti qabate. ");
INSERT INTO gaz_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Museenis, “Namni tokko iyyuu waan walitti qabate keessaa tokko illee ganamaaf hin bulfatin” jedheen. ");
INSERT INTO gaz_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Taʼus isaan keessaa namoonni tokko tokko Musee hin dhageenye; waan walitti qabatan keessaas gartokko ganamaaf bulfatan; innis raammaʼee ajaaʼe. Kanaafuu Museen isaanitti aare. ");
INSERT INTO gaz_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Tokkoon tokkoon namaa ganama ganama hammuma barbaadu walitti qabate; innis yommuu aduun hoʼitetti baqee bade. ");
INSERT INTO gaz_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Guyyaa jaʼaffaatti jarri harka lama jechuunis mata mataatti gomoorii lama walitti qabatan; hooggantoonni waldichaa hundis dhaqanii Museetti himan. ");
INSERT INTO gaz_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","Innis akkana jedheen; “Waaqayyo akkana jedhee ajaje: ‘Bor guyyaa sanbata boqonnaa taʼa; innis sanbata Waaqayyoof qulqullaaʼee dha. Waan tolfachuu barbaaddan tolfadhaa; waan affeelachuu barbaaddanis affeeladhaa. Waan irraa hafu hunda immoo hamma ganamaatti turfadhaa.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Jarris akkuma Museen isaan ajajetti hamma ganamaatti turfatan; nyaanni sunis hin ajoofne yookaan hin raammofne. ");
INSERT INTO gaz_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Museenis akkana jedhe; “Waan guyyaan harʼaa sanbata Waaqayyoo taʼeef nyaata kana harʼa nyaadhaa; isin harʼa dirree irratti isa hin argattan. ");
INSERT INTO gaz_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Isinis nyaata sana guyyaa jaʼa walitti qabadhaa; guyyaa torbaffaatti jechuunis guyyaa Sanbataatiin garuu tokko iyyuu hin argamu.” ");
INSERT INTO gaz_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Jara sana keessaa namoonni tokko tokko immoo guyyaa torbaffaatti walitti qabachuuf gad baʼan; garuu homaa hin arganne. ");
INSERT INTO gaz_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Kana irratti Waaqayyo Museedhaan akkana jedhe; “Isin hamma yoomiitti ajaja koo fi qajeelfama koo eeguu diddu? ");
INSERT INTO gaz_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Waaqayyo Sanbata akka isinii kenne hubadhaa. Sababiin inni guyyaa jaʼaffaatti buddeena guyyaa lamaaf taʼu isinii kennuufis kanuma. Namni hundinuu guyyaa torbaffaatti idduma jiru haa turu. Namni tokko iyyuu gad hin baʼin.” ");
INSERT INTO gaz_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Sabni sunis guyyaa torbaffaatti ni boqote. ");
INSERT INTO gaz_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Sabni Israaʼel buddeena sana “mannaa” jedhee moggaase. Mannaan kunis sanyii dinbilaalaa fakkaata; adiidhas; miʼaan isaas akka bixxillee dammaan tolfamee ti. ");
INSERT INTO gaz_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Museen akkana jedhe; “Waaqayyo akkana jedhee ajaje: ‘Akka inni dhaloota dhufuuf turfamuuf Mannaa gomoorii tokko fuudhaa; kunis akka isaan buddeena ani yeroo biyya Gibxi keessaa isin baasetti akka isin gammoojjii keessatti nyaattaniif isinii kenne sana arganiif.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Museen Arooniin, “Okkotee tokko fuudhiitii mannaa gomoorii tokko itti naqi; akka mannaan kun dhaloota dhufuuf turfamuuf fuula Waaqayyoo dura kaaʼi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Aroonis akkuma Waaqayyo Musee ajaje sanatti akka mannaan sun turfamuuf fuula Dhugaa Baʼuu dura kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Sabni Israaʼel hamma biyya keessa qubatamu sana gaʼanitti waggaa afurtama mannaa nyaatan; isaanis hamma daarii biyya Kanaʼaan gaʼanitti mannaa nyaatan. ");
INSERT INTO gaz_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Gomooriin tokko harka kurnaffaa iifii tokkoo ti. ");
INSERT INTO gaz_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Waldaan ijoollee Israaʼel hundi akkuma Waaqayyo ajajetti Gammoojjii Siiniitii kaʼanii iddoo tokko irraa gara iddoo biraatti darbaa dhaqanii Refiidiim qubatan. Garuu sabni sun bishaan dhugaatii hin arganne. ");
INSERT INTO gaz_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Kanaafuu isaan, “Bishaan dhugnu nuu kenni” jedhanii Musee lolan. Museen immoo deebisee, “Isin maaliif na loltu? Waaqayyos maaliif qortu?” jedheen. ");
INSERT INTO gaz_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Jarris bishaan dheebotanii Museetti guunguman; akkanas jedhan; “Ati maaliif akka nu, ijoolleen keenyaa fi horiin keenya dheebuun dhumnuuf biyya Gibxiitii nu baafte?” ");
INSERT INTO gaz_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Kana irratti Museen gara Waaqayyootti iyyee, “Ani saba kana maal godha? Isaan dhagaan na tumuuf xinnumatu hafe” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Waaqayyo immoo akkana jedhee Museef deebii kenne; “Saba kana dura darbii deemi. Maanguddoota Israaʼel keessaa tokko tokko of faana fudhadhuutii ulee ittiin laga Abbayyaa dhoofte sana harkatti qabadhuu deemi. ");
INSERT INTO gaz_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Kunoo ani kattaa Kooreeb sana bira fuula kee dura achi nan dhaabadha; akka namoonni bishaan dhuganiif ati kattaa sana dhaʼi; bishaanis isa keessaa ni baʼa.” Kanaafuu Museen fuula maanguddoota Israaʼel duratti akkasuma godhe. ");
INSERT INTO gaz_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Sababii Israaʼeloonni lola kaasanii fi sababii isaan, “Waaqayyo nu wajjin jira moo hin jiru?” jechuudhaan Waaqayyoon qoraniif Museen iddoo sana Maasaahii fi Mariibaa jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amaaleqoonni dhufanii Refiidiimitti Israaʼeloota lolan. ");
INSERT INTO gaz_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Museenis Iyyaasuudhaan, “Namoota keenya keessaa muraasa filadhuutii dhaqii Amaaleqoota loli. Ani bor ulee Waaqaa harka kootti qabadhee fiixee gaara irra nan dhaabadha” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Yeroo Museen, Aroonii fi Huuri fiixee gaaratti ol baʼanitti, Iyyaasuun akkuma Museen ajajetti Amaaleqoota lola ture. ");
INSERT INTO gaz_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Yeroo Museen harka isaa ol qabatutti Israaʼeloonni ni moʼatu turan; yeroo inni harka isaa gad buufatu immoo Amaaleqoonni ni moʼatu turan. ");
INSERT INTO gaz_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Isaanis yeroo harki Musee dadhabaa deemetti dhagaa tokko fuudhanii isa jala kaaʼan; innis irra taaʼe. Aroonii fi Huuri inni tokko garanaan inni kaan immoo garasiin goranii akka harki isaa hamma aduun dhiitutti gad hin deebineef ol qabaniif. ");
INSERT INTO gaz_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Akkasiin Iyyaasuun loltoota Amaaleqootaa goraadeedhaan moʼate. ");
INSERT INTO gaz_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Ergasii Waaqayyo Museedhaan akkana jedhe; “Akka wanni kun yaadatamuuf kitaabatti barreessi; Iyyaasuun waan kana dhagaʼuu isaa mirkaneessi; ani guutumaan guutuutti yaadannoo Amaaleqootaa samii jalaa nan balleessaatii.” ");
INSERT INTO gaz_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Museenis iddoo aarsaa ijaaree, “Waaqayyo Faajjii koo ti” jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Innis, “Harki gara teessoo Waaqayyootti ol kaafameera. Waaqayyos dhaloota tokkoo gara dhaloota kaaniitti Amaaleqoota ni lola” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Yetroo lubichi Midiyaaniitii fi abbaan niitii Musee sun waan Waaqni Musee fi saba isaa Israaʼeliif godhe hunda, akkasumas akka Waaqayyo itti Israaʼelin Gibxii baase dhagaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","2","Erga Museen niitii isaa Ziphooraa ergee booddee Yetroo abbaan niitii Musee, ishee fi ");
INSERT INTO gaz_vpl VALUES ("EX18_3","003_18_3","EXO","18","3","3","ilmaan ishee lamaan simate. Maqaan ilma isaa tokkoo Geershoom jedhame; Museen, “Ani biyya ormaa keessatti alagaa taʼeera” jedheeraatii. ");
INSERT INTO gaz_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Kaan immoo, “Waaqni abbaa kootii gargaaraa kooti; inni goraadee Faraʼoon jalaa na baaseera” jechuudhaan Eliiʼezer jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Yetroon abbaan niitii Musees niitii Museetii fi ilmaan Musee wajjin gammoojjii keessatti gara tulluu Waaqaa iddoo Museen qubatee jirutti isa bira dhufe. ");
INSERT INTO gaz_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetroonis, “Ani abbaan niitii keetii Yootoor niitii keetii fi ilmaan ishee lamaan wajjin gara kee dhufaa jira” jedhee dhaamsa itti ergee ture. ");
INSERT INTO gaz_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Museenis abbaa niitii isaa simachuuf gad baʼe; gad jedhees harka fuudhee isa dhungate. Isaanis nagaa wal gaafatanii dunkaana seenan. ");
INSERT INTO gaz_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Museen waan Waaqayyo sababii saba Israaʼeliif jedhee Faraʼoonii fi warra Gibxi irratti hojjete, rakkina karaa irratti isaan mudate hundaa fi akka itti Waaqayyo isaan oolche abbaa niitii isaatti hime. ");
INSERT INTO gaz_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Yetroonis waan gaarii Waaqayyo harka warra Gibxi keessaa isaan baasuudhaan saba Israaʼeliif godhe hundaaf ni gammade. ");
INSERT INTO gaz_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","Innis akkana jedhe; “Waaqayyo harka warra Gibxii fi harka Faraʼoon keessaa isin baasee fi inni saba sana harka warra Gibxiitii baase sun haa eebbifamu. ");
INSERT INTO gaz_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Ani amma akka Waaqayyo waaqota kaan hunda caalaa guddaa taʼe nan beeka; inni warra of tuulummaadhaan Israaʼelin rakkisan irratti waan kana raawwateeraatii.” ");
INSERT INTO gaz_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Yommus Yetroon abbaan niitii Musee sun aarsaa gubamuu fi aarsaa biraa Waaqaaf fide; Aroonis fuula Waaqaa duratti Musee fi abbaa niitii Musee wajjin buddeena nyaachuuf maanguddoota Israaʼel hunda wajjin dhufe. ");
INSERT INTO gaz_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Guyyaa itti aanutti Museen sabaaf murtii kennuuf taaʼe; sabni sunis ganamaa hamma galgalaatti naannoo isaa dhaabate. ");
INSERT INTO gaz_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Abbaan niitii isaas yommuu waan Museen sabaaf hojjetu hunda argetti, “Wanni ati sabaaf hojjettu kun maali? Ati maaliif kophaa kee teessee sabni kun immoo ganamaa hamma galgalaatti naannoo kee dhadhaabata?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Museen immoo akkana jedhee deebiseef; “Sabni kun fedhii Waaqaa barbaacha gara koo dhufaatii. ");
INSERT INTO gaz_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Isaan yommuu falmii qabaatanitti dhimma isaanii natti dhiʼeeffatu; anis abbootii dhimmaa gidduutti murtii nan kenna; sirnaa fi seera Waaqaas isaanitti nan hima.” ");
INSERT INTO gaz_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Abbaan niitii Musee akkana jedhee deebise; “Wanni ati gootu kun gaarii miti. ");
INSERT INTO gaz_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Atii fi sabni si bira dhufu kun akkasumaan of dadhabsiiftu. Hojiin kunis akka malee sitti ulfaata; ati kophaa kee hojjechuu hin dandeessu. ");
INSERT INTO gaz_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ani gorsa siif kennaatii amma na dhagaʼi; Waaqni si wajjin haa taʼu. Ati fuula Waaqaa duratti iddoo buʼaa sabaa taatee dhimma isaanii Waaqatti fiduu qabda. ");
INSERT INTO gaz_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Sirnaa fi seera isaan barsiisi; akka isaan itti jiraachuu qabanii fi waan isaan hojjechuu qaban isaanitti argisiisi. ");
INSERT INTO gaz_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Kana malees ati saba hunda keessaa namoota dandeetii qaban jechuunis, namoota Waaqa sodaatan, namoota amanamoo kanneen mattaʼaa jibban filadhuutii ajajjuuwwan kumaa, ajajjuuwwan dhibbaa, ajajjuuwwan shantamaatii fi ajajjuuwwan kudhanii godhii muudadhu. ");
INSERT INTO gaz_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Isaan yeroo hunda sabaaf murtii haa kennan; dubbii cimaa hunda garuu sitti haa fidan; dubbii laayyoo immoo ofumaan haa murteessan. Kun baʼaa kee siif salphisa; isaan si wajjin baʼaa ni baatuutii. ");
INSERT INTO gaz_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Yoo ati waan kana goote, yoo Waaqnis waanuma kana si ajaje ati jabaattee dhaabachuu dandeessa; sabni kun hundis nagaadhaan mana ofii isaatti gala.” ");
INSERT INTO gaz_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Museenis abbaa niitii isaa dhagaʼee waan inni jedhe hunda godhe. ");
INSERT INTO gaz_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Innis Israaʼel hunda keessaa namoota dandeettii qaban filatee hooggantoota sabaa, ajajjuuwwan kumaa, ajajjuuwwan dhibbaa, ajajjuuwwan shantamaatii fi ajajjuuwwan kudhanii isaan godhate. ");
INSERT INTO gaz_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Isaanis abbootii murtii taʼanii yeroo hunda saba sana tajaajilan; dubbii jabaa Museetti fidan; dubbii laayyoo taʼe hunda immoo ofumaan murteessan. ");
INSERT INTO gaz_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Ergasiis Museen abbaa niitii isaa geggeesse; Yootooris deebiʼee biyya isaatti gale. ");
INSERT INTO gaz_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israaʼeloonni erga Gibxii baʼanii as jiʼa sadaffaa keessa guyyuma itti Gibxii baʼan sana Gammoojjii Siinaa gaʼan. ");
INSERT INTO gaz_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Isaanis erga Refiidiimii kaʼanii booddee Gammoojjii Siinaa seenan; sabni Israaʼelis Gammoojjii sana keessa fuullee tulluu sanaa qubatan. ");
INSERT INTO gaz_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Museenis gara Waaqaatti ol baʼe; Waaqayyos tulluu irraa isa waamee akkana jedheen; “Ati mana Yaaqoobiin akkana jetta; saba Israaʼelittis waan kana himi: ");
INSERT INTO gaz_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‘Waan ani warra Gibxi godhee fi akka ani itti qoochoo risaa irratti isin baadhee gara kootti isin fide isin mataan keessan iyyuu argitaniirtu. ");
INSERT INTO gaz_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Ammas isin yoo naaf ajajamtan, yoo kakuu koo eegdan isin saboota hunda keessaa qabeenya addaa naaf taatu. Yoo lafti hundinuu kan koo taʼe illee, ");
INSERT INTO gaz_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","isin mootummaa lubootaatii fi saba qulqulluu naaf taatu.’ Dubbiin ati saba Israaʼelitti himuu qabdus kanuma.” ");
INSERT INTO gaz_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Museen deebiʼee maanguddoota sabaa walitti waamee, dubbii akka inni dubbatuuf Waaqayyo isa ajaje sana hunda fuula isaanii duratti dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Jarri hundinuus afaan tokkoon, “Nu waan Waaqayyo jedhe hundumaa ni goona” jedhanii deebisan; Museen immoo waan jarri jedhan deebisee Waaqayyotti fide. ");
INSERT INTO gaz_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Waaqayyo Museedhaan akkana jedhe; “Akka sabni kun anaa si wajjin dubbatu dhagaʼee yeroo hunda si amanatuuf kunoo ani duumessa yabbuu keessaan gara kee nan dhufa.” Ergasiis Museen waan sabni sun jedhe Waaqayyotti hime. ");
INSERT INTO gaz_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Waaqayyos Museedhaan akkana jedhe; “Gara sabaa dhaqiitii harʼaa fi bori isaan qulqulleessi. Akka isaan wayyaa isaanii miiccatanii ");
INSERT INTO gaz_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","guyyaa sadaffaaf qophaaʼan godhi; gaafa sana utuma sabni hundi ilaaluu Waaqayyo Tulluu Siinaa irratti gad ni buʼaatii. ");
INSERT INTO gaz_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Naannoo tullichaatti saba sanaaf daangaa tolchiitii akkana jedhiin; ‘Isin akka tulluu sanatti ol hin baane yookaan akka qarqara isaa illee hin tuqne of eeggadhaa. Namni tulluu sana tuqu kam iyyuu haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Inni dhagaadhaan haa tumamu yookaan xiyyaan haa waraanamu; harki tokko iyyuu isa hin tuqin; horiis taʼu namni akka jiraatu hin eeyyamamuuf.’ Isaan yeroo malakanni utuu gargar hin citin afuufamu qofa tulluutti ol baʼuu dandaʼu.” ");
INSERT INTO gaz_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Museen tulluu irraa gara sabaatti gad buʼee saba sana qulqulleesse; isaanis uffata isaanii miiccatan. ");
INSERT INTO gaz_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Innis saba sanaan, “Guyyaa sadaffaaf of qopheessaa; dubartii biras hin gaʼinaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Ganama guyyaa sadaffaa sana tulluu sana irra bakakkaa, balaqqeessaa fi duumessa yabbuu, akkasumas sagalee malakataa guddaatu dhagaʼame. Warri iddoo qubataa sana keessa jiraatan hundis ni hollatan. ");
INSERT INTO gaz_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Museenis saba sana iddoo qubannaatii baasee gara Waaqaatti fide; jarris miilla tulluu sanaa jala dhadhaabatan. ");
INSERT INTO gaz_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Tulluun Siinaa hundis sababii Waaqayyo ibiddaan irratti gad buʼeef aaraan haguugame. Aarri sunis akkuma aara boolla ibiddaatii baʼuutti ol baʼe; tulluun sunis guutumaan guutuutti akka malee raafame; ");
INSERT INTO gaz_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","sagaleen malakataa ittuma guddachaa deeme. Museenis ni dubbate; sagaleen Waaqaas deebii kenneef. ");
INSERT INTO gaz_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Waaqayyo fiixee Tulluu Siinaa irratti gad buʼee Musee gara fiixee tulluu sanaatti ol waame. Museenis ol baʼe; ");
INSERT INTO gaz_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Waaqayyo immoo akkana isaan jedhe; “Akka isaan Waaqayyo ilaaluuf jedhanii daarii hin dabarree fi akka isaan keessaas namni baayʼeen hin duuneef gad buʼiitii isaan akeekkachiisi. ");
INSERT INTO gaz_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Akka Waaqayyo isaan hin balleessineef luboonni Waaqayyotti dhiʼaatan iyyuu of haa qulqulleessan.” ");
INSERT INTO gaz_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Museen immoo Waaqayyoon, “Sababii ati mataan kee, ‘Naannoo Tullichaatti daangaa dhaabiitii isa qulqulleessiitii addaan baasi’ jettee akeekkachiisa nuu kenniteef sabni kun Tulluu Siinaatti ol baʼuu hin dandaʼu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Waaqayyos, “Gadi buʼiitii Aroonin fidii kottu. Garuu luboonnii fi uummanni gara Waaqayyootti ol dhufuuf jedhanii daangaa hin darbin; yoo kanaa achii inni isaan balleessa” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Museenis gad buʼee waan kana uummatatti hime. ");
INSERT INTO gaz_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Waaqni akkana jedhee dubbii kana hunda dubbate: ");
INSERT INTO gaz_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","“Ani Waaqayyo Waaqa kee kan Gibxii, biyya garbummaatii si baasee dha. ");
INSERT INTO gaz_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","“Ati ana malee waaqota biraa tokko illee hin qabaatin. ");
INSERT INTO gaz_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","Ati bifa waan ol samii gubbaa yookaan gad lafa irra yookaan bishaan lafa jalaa keessa jiru kamiitiin iyyuu Waaqa tolfamaa ofii keetiif hin tolfatin. ");
INSERT INTO gaz_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Isaaniif hin sagadin yookaan isaan hin waaqeffatin; ani Waaqayyo Waaqni kee Waaqa hinaafu kan sababii cubbuu abbootiitiif jedhee ijoollee warra na jibbanii hamma dhaloota sadii fi afuriitti adabee ");
INSERT INTO gaz_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","warra na jaallatanii ajajawwan koo eegan immoo hamma dhaloota kumaatti jaallatuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","Maqaa Waaqayyo Waaqa keetii akkasumaan hin dhaʼin; Waaqayyo warra akkuma argan maqaa isaa dhaʼan utuu hin adabin hin dhiisuutii. ");
INSERT INTO gaz_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","Guyyaa Sanbataa qulqulleessuudhaan yaadadhu. ");
INSERT INTO gaz_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Guyyoota jaʼa hojjedhu; hojii kee hundas hojjetadhu; ");
INSERT INTO gaz_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","guyyaan torbaffaan garuu sanbata Waaqayyo Waaqa keetii ti. Gaafas hojii tokko illee hin hojjetin; ati yookaan ilmi kee yookaan intalli kee yookaan hojjetaan kee yookaan xomboreen kee yookaan horiin kee yookaan alagaan magaalaa kee keessa jiraatu tokko iyyuu homaa hin hojjetin. ");
INSERT INTO gaz_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Waaqayyo guyyaa jaʼa keessatti samii fi lafa, galaanaa fi waan isaan keessa jiru hunda uumee guyyaa torbaffaatti boqoteetii. Kanaafuu Waaqayyo Sanbata eebbisee qulqulleesse. ");
INSERT INTO gaz_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","Akka biyya Waaqayyo Waaqni kee siif kennu keessa bara dheeraa jiraattuuf abbaa keetii fi haadha keetiif ulfina kenni. ");
INSERT INTO gaz_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","Hin ajjeesin. ");
INSERT INTO gaz_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","Hin ejjin. ");
INSERT INTO gaz_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","Hin hatin. ");
INSERT INTO gaz_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","Ollaa keetti sobaan dhugaa hin baʼin. ");
INSERT INTO gaz_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","Mana namaa hin hawwin. Niitii namaa yookaan hojjetaa isaa yookaan xomboree isaa yookaan qotiyyoo isaa yookaan harree isaa yookaan waan namaa kam iyyuu hin hawwin.” ");
INSERT INTO gaz_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Jarri hundinuus yommuu bakakkaa fi balaqqeessa, sagalee malakataatii fi tulluu aaru hubatanitti sodaadhaan hollatan. Isaan fagoo dhaabatanii ");
INSERT INTO gaz_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Museedhaan, “Ati mataan kee nutti dubbadhu; nu ni dhaggeeffannaa. Garuu Waaqni nutti hin dubbatin. Yoo kanaa achii nu ni dhumnaa” jedhan. ");
INSERT INTO gaz_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Museen immoo saba sanaan, “Hin sodaatinaa. Akka Waaqa sodaachuun isin wajjin jiraatee cubbuu hojjechuu irraa isin eeguuf jedhee Waaqni isin qoruuf dhufeera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Yeroo Museen dukkana limixii iddoo Waaqni turetti dhiʼaatetti, namoonni fagoo dhaabatan. ");
INSERT INTO gaz_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Ergasii Waaqayyo Museedhaan akkana jedhe; “Saba Israaʼelitti waan kana himi: ‘Akka ani samii irraa isinitti dubbadhe isin mataan keessan argitaniirtu; ");
INSERT INTO gaz_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","ana biratti waaqota kam iyyuu hin tolfatinaa. Waaqota meetii yookaan waaqota warqee hin tolfatinaa. ");
INSERT INTO gaz_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","“ ‘Biyyoo lafaa irraa iddoo aarsaa naa tolchiitii isa irratti qalma gubamu, aarsaa nagaa, hoolota kee, reʼoota keetii fi loon kee aarsaa dhiʼeessi. Ani iddoo akka maqaan koo itti yaadatamu godhu hundatti gara kee dhufee sin eebbisa. ");
INSERT INTO gaz_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Yoo dhagaa irraa iddoo aarsaa naa ijaarte immoo dhagaa soofame irraa hin ijaarin; yoo meeshaadhaan isa tuqxe ni xureessitaatii. ");
INSERT INTO gaz_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Akka qullaan kee isa irratti hin mulʼanneef gulantaadhaan iddoo aarsaa kootti ol hin baʼin.’ ");
INSERT INTO gaz_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","“Seerawwan ati isaan dura keessu kanneenii dha: ");
INSERT INTO gaz_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","“Ati yoo Ibroota keessaa garbicha bitatte inni waggaa jaʼa siif haa hojjetu. Waggaa torbaffaatti garuu inni kaffaltii malee bilisa haa baʼu. ");
INSERT INTO gaz_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Inni yoo kophaa isaa dhufee jiraate kophaa isaa bilisoomee haa deemu; yeroo dhufutti inni yoo niitii qabaate isheenis isa wajjin haa deemtu. ");
INSERT INTO gaz_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Yoo gooftaan isaa niitii isa fuusisee isheenis ilmaan yookaan intallan deesseefii jiraatte, ishee fi ijoolleen ishee kan gooftaa ishee taʼu; namichi qofti bilisa taʼee haa deemu. ");
INSERT INTO gaz_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","“Garuu garbichi sun, ‘Ani gooftaa koo fi niitii koo, ijoollee koos nan jaalladha; ani bilisa baʼee deemuu hin barbaadu’ yoo jedhe, ");
INSERT INTO gaz_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","gooftaan isaa fuula abbootii murtii duratti isa haa dhiʼeessu; gara balbalaatti yookaan gara michichila balbalaatti geessees mutaadhaan gurra isaa haa uru. Ergasii inni bara jireenya isaa guutuu isa tajaajila. ");
INSERT INTO gaz_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","“Namni yoo intala isaa akka garbittiitti gurgurate, isheen akka garbichi tokko itti bilisa baʼutti bilisa hin baʼin. ");
INSERT INTO gaz_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Yoo isheen goofticha ofii isaatiif ishee filate sanatti toluu baatte inni akka isheen furamtuu haa godhu. Inni waan isheef amanamuu dhabeef dabarsee ormatti ishee gurguruuf mirga hin qabu. ");
INSERT INTO gaz_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Yoo ilma isaatiif ishee filate immoo mirga intala ofii isaatiif kennu isheefis haa kennu. ");
INSERT INTO gaz_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Yoo niitii biraa fuudhe immoo niitii isaa kan jalqabaa sana nyaata, uffataa fi mirga niitiif malu itti hin hirʼisin. ");
INSERT INTO gaz_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Yoo inni wantoota sadan kanneen isheef gochuu dide garuu isheen kaffaltii maallaqaa tokko malee bilisa baʼuu qabdi. ");
INSERT INTO gaz_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","“Namni nama rukutee ajjeesu innis haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Inni riphee utuu hin eeggatin Waaqatu harka isaa buuse yoo taʼe garuu iddoo ani ramadutti haa baqatu. ");
INSERT INTO gaz_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Garuu yoo namni tokko ittuma yaadee dabaan nama ajjeese iddoo aarsaa koo biraa fuudhaatii ajjeesaa. ");
INSERT INTO gaz_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","“Namni abbaa isaa yookaan haadha isaa rukutu haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","“Namni nama hatee yoo gurgurate yookaan namichi hatame sun harka isaatti yoo argame hattichi haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","“Namni abbaa isaa yookaan haadha isaa arrabsu haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","“Yoo namoonni wal lolanii inni tokko isa kaan dhagaadhaan yookaan abootteedhaan rukutee namichi rukutame sun duʼuu baatee garuu siree irratti hafe, ");
INSERT INTO gaz_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ergasii immoo yoo inni kaʼee ulee isaa dhadhaabachaa asii fi achi ala keessa deddeeme namichi isa dhaʼe sun itti hin gaafatamu; sababii yeroo namicha miidhame sanaa jalaa balleesseef garuu gatii haa baasu; hamma inni guutumaan guutuutti fayyuttis isa haa walʼaanu. ");
INSERT INTO gaz_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","“Yoo namni tokko uleedhaan garbicha isaa yookaan garbittii isaa dhaʼee garbichi sunis harka isaatti duʼe namichi haa adabamu; ");
INSERT INTO gaz_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","garuu sababii garbichi sun qabeenya isaa taʼeef yoo garbichi sun bultii tokko yookaan bultii lama booddee kaʼe, namichi hin adabamu. ");
INSERT INTO gaz_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","“Yoo namoonni wal lolaa jiran dubartii ulfoofte tokkotti buʼanii ulfii garaadhaa baʼee garuu miidhamni hamaan ishee hin qaqqabin, namichi ishee miidhe sun waan dhirsi dubartittii isa gaafatee fi waan abbootiin murtii murteessan baasuu qaba. ");
INSERT INTO gaz_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Yoo miidhamni hamaan jiraate garuu, qooda lubbuu, lubbuu; ");
INSERT INTO gaz_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","qooda ijaa, ija; qooda ilkaanii, ilkaan; qooda harkaa, harka; qooda miillaa, miilla; ");
INSERT INTO gaz_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","qooda gubuu, gubuu; qooda madaa, madaa; qooda buruqsuu, buruqsuu baafta. ");
INSERT INTO gaz_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","“Namni tokko yoo ija garbicha isaa yookaan ija garbittii isaa rukutee jaamse, inni qooda ija sanaa garba sana bilisa haa baasu. ");
INSERT INTO gaz_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Inni yoo ilkaan garbicha isaa yookaan ilkaan garbittii isaa rukutee cabse, qooda ilkaan sanaa garba sana bilisa haa baasu. ");
INSERT INTO gaz_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","“Qotiyyoon tokko yoo dhiira yookaan dubartii waraanee ajjeese qotiyyoon sun dhagaadhaan tumamee haa ajjeefamu; foon isaas hin nyaatamin. Garuu abbaan qotiyyoo sanaa itti hin gaafatamu. ");
INSERT INTO gaz_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Yoo qotiyyoon sun durumaanuu amala nama waraanuu qabaachuun isaa beekamee abbaan isaas akka isa eeggatu gorfamee garuu waan inni isa eeggachuu dideef qotiyyoon sun dhiira yookaan dubartii ajjeese, qotiyyoon sun dhagaadhaan rukutamee haa ajjeefamu; abbaan qotiyyoo sanaas haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Taʼus inni yoo gumaa gaafatame waan gaafatame hunda kaffalee lubbuu isaa haa oolfatu. ");
INSERT INTO gaz_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Yoo qotiyyoon sun ilma yookaan intala tokko waraane illee seeruma kanatu hojjeta. ");
INSERT INTO gaz_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Yoo qotiyyoon sun garbicha yookaan garbittii waraane abbaan qotiyyoo sanaa gooftaa garba sanaatiif meetii saqilii soddoma haa kaffalu; qotiyyoon sunis dhagaan rukutamee haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","“Namni tokko yoo boolla afaan banaa dhiise yookaan yoo boolla qotee utuu hin duuchin dhiisee sangaan yookaan harreen boolla sana keessa buʼe, ");
INSERT INTO gaz_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","abbaan boolla sanaa abbaa horii sanaatiif maallaqa haa baasu; horiin duʼe sun immoo kan isaa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","“Yoo qotiyyoon nama tokkoo qotiyyoo nama biraa miidhee duʼaan gaʼe jarri qotiyyoo fayyaa sana haa gurgurani; gatii qotiyyoo sanaatii fi qotiyyoo duʼe sana qixxeetti haa qooddatani. ");
INSERT INTO gaz_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Yoo qotiyyoon sun durumaanuu amala horii waraanuu qabaachuun isaa beekamee garuu waan abbaan isaa isa eeggachuu dideef abbaan qotiyyoo sanaa qooda qotiyyoo, qotiyyoo haa baasu; qotiyyoon duʼe sun immoo kan isaa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","“Namni tokko yoo sangaa yookaan hoolaa hatee qalate yookaan gurgurate, qooda qotiyyoo tokkoo sangaa shan, qooda hoolaa tokkoo immoo hoolaa afur haa baasu. ");
INSERT INTO gaz_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","“Hattuun tokko utuu cabsee seenuu yoo qabamee tumamee kanumaan duʼe, namichi isa ajjeese sun dhiiga isaatti yakkaan hin gaafatamu; ");
INSERT INTO gaz_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","garuu yoo wanni kun erga aduun baatee taʼe, namichi dhiiga sanatti yakkaan ni gaafatama. “Hattuun waan hate haa deebisu; homaa hin qabu yoo taʼe garuu hanna isaatiif gatii baasuudhaaf haa gurguramu. ");
INSERT INTO gaz_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","Horiin hatame sun sangaa yookaan harree yookaan hoolaa taanaan yoo utuu lubbuun jiruu harka isaatti argame hattuun sun dachaa baasuu qaba. ");
INSERT INTO gaz_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","“Namni tokko yoo utuu lafa qotiisaa yookaan dhaabaa wayinii keessa horii tikfatuu horii isaa gad lakkisee horiin sun dhaqee kaloo nama biraa dheede, inni lafa qotiisaa ofii isaa irraa yookaan dhaabaa wayinii ofii isaa irraa kan waan hunda caalu iddoo haa buusuuf. ");
INSERT INTO gaz_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","“Yoo ibiddi kaʼee daggala seenee akkasiin midhaan tuulame yookaan midhaan dhaabatu yookaan lafa qotiisaa gube, namichi ibidda qabsiise sun gatii baasuu qaba. ");
INSERT INTO gaz_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","“Namni tokko yoo maallaqa yookaan miʼa imaanaa namatti kennatee, wanni sun mana namichaatii hatamee hattuun sun qabame, hattichi dachaa kaffaluu qaba. ");
INSERT INTO gaz_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Yoo hattuun sun hin argamin garuu abbaan mana sanaa akka miʼa nama kaanii tuqee fi akka hin tuqin mirkaneessuuf fuula abbootii murtii duratti haa dhiʼeeffamu. ");
INSERT INTO gaz_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","Namni tokko yoo qotiyyoo, harree, hoolaa, uffata yookaan miʼa bade tokko miliqsee namni tokko dhufee, ‘Kun kan koo ti’ jedhe, falmiin isaanii fuula abbootii murtii duratti haa dhiʼeeffamu. Namichi abbootiin murtii itti muran sunis ollaa isaatiif harka lama haa baasu. ");
INSERT INTO gaz_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","“Yoo namni tokko ollaa isaatiif harree, qotiyyoo, hoolaa yookaan horii biraa imaanaa kennatee horiin suni utuu namni hin argin duʼe yookaan miidhame yookaan hatame, ");
INSERT INTO gaz_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","namichi sun akka qabeenya ollaa isaa hin tuqin mirkaneessuuf fuula Waaqayyoo duratti haa kakatu; abbaan qabeenyaa sunis kakuu kana fudhachuu qaba; gatiis hin gaafatu. ");
INSERT INTO gaz_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Yoo horiin sun isa jalaa hatamee jiraate garuu namichi abbaa horii sanaatiif baasuu qaba. ");
INSERT INTO gaz_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Yoo horii sana bineensatu nyaate taʼe immoo akka ragaa taʼuuf waan bineensa irraa hafe haa dhiʼeessu malee horii nyaatame sanaaf gatii hin baasin. ");
INSERT INTO gaz_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","“Namni tokko yoo ollaa isaa irraa horii ergifatee horiin sun iddoo abbaan horii hin jirretti miidhame yookaan duʼe, namichi ergifate sun gatii haa baasu. ");
INSERT INTO gaz_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Yoo abbaan horii sanaa achi jiraate garuu namichi ergifate sun gatii baasuu hin qabu. Yoo horiin sun kireeffamee jiraate immoo maallaqni baafame sun kiraa horii duʼe sanaa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","“Namni tokko yoo durba hin kaadhimatamin gowwoomsee ishee wajjin ciise, inni gabbara misirrittiif malu baaseefii ishee haa fuudhu. ");
INSERT INTO gaz_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Yoo abbaan ishee intalattii namichaaf kennuu dide immoo namichi sun gabbara durbaaf malu baasuu qaba. ");
INSERT INTO gaz_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","“Ati akka dubartiin falfaltuun lubbuun jiraattu hin eeyyamin. ");
INSERT INTO gaz_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","“Namni horii wajjin ciisu kam iyyuu ajjeefamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","“Namni Waaqayyo tokkichaaf malee Waaqa biraatiif aarsaa dhiʼeessu galaafatamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","“Isinis waan biyya Gibxii keessatti alagoota turtaniif alagaatti daba hin hojjetinaa; hin cunqursinaas. ");
INSERT INTO gaz_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","“Haadha hiyyeessaatii fi ijoollee abbaan irraa duʼe hin hacuucinaa. ");
INSERT INTO gaz_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Yoo isin isaan miitanii isaan immoo natti booʼan ani dhugumaan booʼicha isaanii nan dhagaʼa. ");
INSERT INTO gaz_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Aariin koo ni bobaʼa; anis goraadeedhaanan isin fixa; niitonni keessan haadhota hiyyeessaa taʼu; ijoolleen keessanis kanneen abbaa hin qabne taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","“Ati yoo saba koo keessaa hiyyeessa si bira jiraatu tokkoof maallaqa liqeessite, akka nama hiiqii argachuuf kennuu hin taʼin; dhalas hin gaafatin. ");
INSERT INTO gaz_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Ati yoo wayyaa nama biraa qabdii qabatte, utuu aduun hin dhiʼin deebisiif; ");
INSERT INTO gaz_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","wanni inni dhagna isaatti uffatu wayuma sanaatii. Wanni inni uffatee rafu biraa maali? Ani waanan gara laafessa taʼeef, yoo inni natti ol iyyate nan dhagaʼa. ");
INSERT INTO gaz_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","“Waaqa hin arrabsin; bulchaa saba keetiis hin abaarin. ");
INSERT INTO gaz_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","“Mataa midhaan keetiitii fi dhangalaʼaa wayinii keetii irraa aarsaa dhiʼeessuu hin tursin. “Ilmaan kee keessaas hangafa naa kennuu qabda. ");
INSERT INTO gaz_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Loon keetii fi hoolota kee akkanuma godhi. Isaanis bultii torba haadha isaanii bira haa turan; guyyaa saddeettaffaatti garuu naa kenni. ");
INSERT INTO gaz_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","“Isin saba koo qulqulluu ni taatu. Kanaafuu foon horii bineensi alatti cabsee kam iyyuu hin nyaatinaa; foon akkanaa saree dura buusaa. ");
INSERT INTO gaz_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","“Oduu sobaa hin odeessin; dhuga baʼuu jalʼaa kennuudhaan nama balleessaa hojjete hin gargaarin. ");
INSERT INTO gaz_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","“Waan hamaa hojjechuuf jettee nama baayʼee faana hin buʼin. Fuula seeraa duratti yommuu dhugaa baatu, gara nama baayʼee gortee murtii hin jalʼisin; ");
INSERT INTO gaz_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","murtii irratti hiyyeessaaf hin loogin. ");
INSERT INTO gaz_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","“Yoo sangaa yookaan harree diina keetii kan baduutti jiru argite deebisii geessiif. ");
INSERT INTO gaz_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Yoo harree nama si jibbu tokkoo utuu isheen baʼaa baattee kuftee jirtuu argite achitti hin dhiisin; isa gargaarii ol kaasi. ");
INSERT INTO gaz_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","“Murtii irratti hiyyeessa saba keetii jalaa murtii hin dabsin. ");
INSERT INTO gaz_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Himata sobaa keessatti hin hirmaatin; waan ani nama balleessaa hojjete hin qulqulleessineef nama yakka hin qabne yookaan nama qajeelaa hin ajjeesin. ");
INSERT INTO gaz_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","“Ati mattaʼaa hin fudhatin; mattaʼaan ogeeyyii ni jaamsaatii; dubbii qajeeltotaas jalʼisa. ");
INSERT INTO gaz_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","“Alagaa hin cunqursin; isin waan biyya Gibxiitti alagaa turtaniif alagaa taʼuun maal akka taʼe isin mataan keessan ni beektuutii. ");
INSERT INTO gaz_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","“Waggaa jaʼa lafa qotiisaa kee facaafadhu; midhaanis galfadhu; ");
INSERT INTO gaz_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","waggaa torbaffaatti garuu lafa sana boqochiisi malee hin qotin. Akkasiin hiyyeeyyiin saba keetii laficha irraa nyaata argatu; waan isaan irraa hafe immoo bineensi haa nyaatu. Muka wayinii keetiitii fi muka ejersa keetiis akkasuma godhi. ");
INSERT INTO gaz_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","“Guyyaa jaʼa hojii kee hojjetadhu; akka sangaan keetii fi harreen kee boqotaniif, akka garbichi mana keetti dhalatee fi alagaan aara galfataniif guyyaa torbafaatti hin hojjetin. ");
INSERT INTO gaz_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","“Waan ani isinitti hime hunda eegaa; maqaa waaqota biraa hin waammatinaa; afaan keessanii iyyuu hin baʼin. ");
INSERT INTO gaz_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","“Ati waggaatti yeroo sadii ayyaana naa ayyaaneffadhu. ");
INSERT INTO gaz_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","“Ayyaana Maxinoo Ayyaaneffadhu; akkuma ani si ajaje sana bultii torba Maxinoo nyaadhu. Waan kanas jiʼa Abiibii keessa yeroo murtaaʼetti godhi; ati jiʼa sana keessa Gibxii baateetii. “Namni tokko iyyuu harka duwwaa fuula koo duratti hin dhiʼaatin. ");
INSERT INTO gaz_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","“Mataa midhaan keetii kan lafa qotiisaa keetti facaafatteen Ayyaana Galchaa Midhaanii ayyaaneffadhu. “Dhuma waggaatti yeroo midhaan kee lafa qotiisaa irraa walitti qabattutti Ayyaana Galchaa Midhaanii ayyaaneffadhu. ");
INSERT INTO gaz_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","“Dhiirri hundi waggaatti yeroo sadii fuula Waaqayyoo Gooftaa duratti haa dhiʼaatu. ");
INSERT INTO gaz_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","“Dhiiga aarsaa waan raacitii qabu wajjin naa hin dhiʼeessin. “Coomni aarsaa ayyaana koos hamma bariitti hin turin. ");
INSERT INTO gaz_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","“Mataa midhaan lafa keetii keessaa filatamaa isaa gara mana Waaqayyo Waaqa keetii fidi. “Ilmoo reʼee aannan haadha isheetiin hin affeelin. ");
INSERT INTO gaz_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","“Akka inni karaa irratti si eegee iddoo ani qopheessetti si galchuuf kunoo ani fuula kee dura ergamaa koo tokko nan erga. ");
INSERT INTO gaz_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Xiyyeeffadhuutii waan inni jedhu dhaggeeffadhu. Isatti hin fincilin; inni waan Maqaa koo of irraa qabuuf fincila kee siif hin dhiisuutii. ");
INSERT INTO gaz_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Yoo ati waan inni jedhu akka gaarii dhaggeeffatee waan ani dubbadhu hunda goote, ani diinota keetti diina nan taʼa; warra siin mormaniinis nan morma. ");
INSERT INTO gaz_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ergamaan koos fuula kee dura deemee biyya Amoorotaatti, Heetotaatti, Feerzotaatti, Kanaʼaanotaatti, Hiiwotaattii fi Yebuusotaatti si galcha; anis jara nan balleessa. ");
INSERT INTO gaz_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Waaqota isaaniitiif hin sagadin; hin waaqeffatinis; hojii isaanii faanas hin buʼin. Ati isaan balleessitee soodduu waaqeffannaa isaanii illee caccabsuu qabda. ");
INSERT INTO gaz_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Waaqayyo Waaqa kee waaqeffadhu; innis midhaan keetii fi bishaan kee ni eebbisa. Dhukkubas isin gidduudhaa nan balleessa; ");
INSERT INTO gaz_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","biyya kee keessatti dubartiin ulfi irraa baʼu yookaan dhabduun tokko iyyuu hin argamtu. Jireenya guutuus siif nan kenna. ");
INSERT INTO gaz_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","“Ani sodaachisuu koo si dura ergee saba ati itti dhuftu hunda nan burjaajessa. Akka diinonni kee hundinuu dugda sitti galanii baqatanis nan godha. ");
INSERT INTO gaz_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Akka inni Hiiwota, Kanaʼaanotaa fi Heetota karaa kee irraa ariʼuuf ani si duraan sonsa nan erga. ");
INSERT INTO gaz_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Akka lafti onee bineensi wal horee sitti hin baayʼanneef ani waggaa tokko keessatti saba kana si duraa ariʼee hin baasu. ");
INSERT INTO gaz_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Hamma ati baayʼattee biyyattii dhaaltutti ani xinnoo xinnoon fuula kee duraa isaan nan baasa. ");
INSERT INTO gaz_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","“Anis daarii kee Galaana Diimaadhaa jalqabee hamma Galaana Filisxeemiitti, lafa alootii jalqabee hamma Laga Efraaxiisiitti siifin dhaaba. Namoota biyya sana jiraatanis dabarsee harka keetti nan kenna; ati immoo of duraa ariitee isaan baafta. ");
INSERT INTO gaz_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Ati isaan wajjin yookaan waaqota isaanii wajjin kakuu tokko illee hin galin. ");
INSERT INTO gaz_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Akka isaan biyya kee keessa jiraatan hin eeyyamaniif; yoo akkas taʼe isaan akka ati cubbuu natti hojjettu si godhu; ati waaqota isaanii waaqeffannaan kun dhugumaan kiyyoo sitti taʼaatii.” ");
INSERT INTO gaz_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Waaqayyo Museedhaan akkana jedhe; “Atii fi Aroon, Naadaabii fi Abiihuu, maanguddoota Israaʼel keessaas namoonni torbaatamni gara Waaqayyotti ol baʼaa; alaalatti sagadaa; ");
INSERT INTO gaz_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","garuu Museen qofti Waaqayyotti haa dhiʼaatu; warri kaan immoo hin dhiʼaatin. Sabni isa wajjin ol hin baʼin.” ");
INSERT INTO gaz_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Museenis dhaqee dubbii fi seera Waaqayyoo hunda saba sanatti hime; sabni sunis, “Nu waan Waaqayyo jedhe hunda ni goona” jedhee afaan tokkoon deebise. ");
INSERT INTO gaz_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Ergasii Museen waan Waaqayyo dubbatte hunda barreesse. Guyyaa itti aanu ganamaanis kaʼee miilla tulluu jalatti iddoo aarsaa ijaare; utubaa dhagaa kudha lama kanneen gosoota Israaʼel kudha lamaan iddoo buʼanis dhaabe. ");
INSERT INTO gaz_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Innis dargaggoota Israaʼel erge; isaanis aarsaa gubamuu fi jiboota aarsaa nagaa godhanii Waaqayyoof dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Museenis walakkaa dhiiga sanaa waciitiitti naqe; walakkaa hafe immoo iddoo aarsaa irratti faffacaase. ");
INSERT INTO gaz_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Innis kitaaba kakuu fuudhee saba sanaaf dubbise. Isaanis, “Nu waan Waaqayyo jedhe hunda ni goona; ni ajajamnas” jedhanii deebisan. ");
INSERT INTO gaz_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Yommus Museen dhiiga sana fuudhee sabatti faffacaasee, “Kunoo kun dhiiga kakuu kan Waaqayyo akkuma dubbii kana hundaatti isinii dhaabee dha” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Musee fi Aroon, Naadaabii fi Abiihuu, maanguddoonni Israaʼel torbaatamnis ol baʼanii ");
INSERT INTO gaz_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Waaqa Israaʼel argan. Miilla isaa jalattis waan akka afaa dhagaa Sanpeer kan akkuma samiitti qulqullaaʼe tokkotu afamee ture. ");
INSERT INTO gaz_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Waaqni garuu qondaaltota saba Israaʼel kanneenitti harka isaa ol itti hin kaafne; isaan Waaqa argan; ni nyaatan; ni dhuganis. ");
INSERT INTO gaz_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Waaqayyos Museedhaan, “Gara kootti tulluutti ol baʼi; asis turi; anis gabateewwan dhagaa kanneen ani akka qajeelfama isaanii taʼuuf seeraa fi ajajawwan itti barreesse siif nan kenna” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Ergasii Museen gargaaraa isaa Iyyaasuu wajjin kaʼee deeme; Museenis tulluu Waaqaatti ol baʼe. ");
INSERT INTO gaz_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Innis maanguddoota sanaan akkana jedhe; “Hamma nu gara keessanitti deebinutti asitti nu eegaa. Kunoo Aroonii fi Huuri isin bira jiran; namni falmii qabu isaan bira dhaquu dandaʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Yeroo Museen tulluutti ol baʼetti duumessi tulluu sana haguuge; ");
INSERT INTO gaz_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","ulfinni Waaqayyoos Tulluu Siinaa irra buʼe. Duumessi sunis guyyaa jaʼa tulluu sana haguuge; guyyaa torbaffaatti immoo Waaqayyo duumessicha keessaa Musee waame. ");
INSERT INTO gaz_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ulfinni Waaqayyoos ibidda waa gubu fakkaatee fiixee tulluu irraa saba Israaʼelitti mulʼachaa ture. ");
INSERT INTO gaz_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Museen tulluutti ol baʼee duumessa keessa seene. Innis guyyaa afurtamaa fi halkan afurtama tulluu sana irra ture. ");
INSERT INTO gaz_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","“Akka isaan kennaa naa fidaniif saba Israaʼelitti himi. Nama garaa isaa guutuudhaan kennuu fedhu hunda harkaa kennaa naa fuudhaa. ");
INSERT INTO gaz_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","“Kennaan isaan harkaa fuutanis: “Warqee, meetii fi naasii; ");
INSERT INTO gaz_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi wayyaa haphii quncee talbaa irraa hojjetame; rifeensa reʼee; ");
INSERT INTO gaz_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","gogaa korbeessa hoolaa kan halluu diimaa cuuphame, gogaa duugame, muka laaftoo, ");
INSERT INTO gaz_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","ibsaadhaaf, zayitii ejersaa, urgooftuuwwan immoo zayitii dibatamuu fi ixaana urgaaʼuuf; ");
INSERT INTO gaz_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","dhagaawwan sardooniksii, dooqa gati jabeessa, dirataa fi qomee irratti kaaʼatamuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","“Ergasii akka isaan iddoo qulqulluu naa qopheessan godhi; anis gidduu isaanii nan jiraadha. ");
INSERT INTO gaz_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Dunkaana qulqulluu kanaa fi miʼa isaa hunda akkuma bifa ani sitti argisiisuutti hojjedhaa. ");
INSERT INTO gaz_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","“Isaan muka laaftoo irraa taabota haa tolchan; taabonni sunis dhundhuma lamaa fi walakkaa dheerata; dhundhuma tokkoo fi walakkaa balʼata; dhundhuma tokkoo fi walakkaa ol dheerata ture. ");
INSERT INTO gaz_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Keessaa fi duuba isaatti warqee qulqulluu uffisi; naannoo isaattis marsaa faaya warqee naannessii tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Taabota sanaafis qubeelaa warqee afur tolchiitii miilla isaa afranitti jechuunis lama gama tokkoon, lama immoo gama kaaniin itti kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Muka laaftoo irraa danqaraawwan tolchiitii warqee itti uffisi. ");
INSERT INTO gaz_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Taaboticha ittiin baachuudhaaf danqaraawwan sana qubeelaawwan keessa loosi. ");
INSERT INTO gaz_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Danqaraawwan kunneen qubeelaawwan taabotichaa keessa haa turan; keessaa baafamuus hin qaban. ");
INSERT INTO gaz_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Atis dhuga baʼumsa ani sitti kennu Taaboticha keessa kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","“Warqee qulqulluu irraa teessoo araaraa tolchi; dheerinni isaas dhundhuma lamaa fi walakkaa, balʼinni isaa immoo dhundhuma tokkoo fi walakkaa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Moggaa lamaan teessoo araaraa irratti warqee tumame irraa Kiirubeelii lama tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Kiirubii tokko moggaa tokko irratti, kiirubii lammaffaa immoo moggaa kaan irratti tolchi; kiirubeelii sanas teessoo araaraa wajjin kutaa warqee tokkicha irraa moggaa lamaan irratti tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Kiirubeeliin sun qoochoo isaanii ol balʼifatanii teessoo araaraa ittiin haa gaaddiseessan; Kiirubeeliin kunneen fuula isaanii walitti garagalfatanii teessoo araaraa haa ilaalan. ");
INSERT INTO gaz_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Teessoo araaraa sana taaboticha irra kaaʼi; dhuga baʼuu ani sitti kennu immoo taaboticha keessa kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Ani achitti si arga; teessoo araaraa irraa, kiirubeelii lamaan taabota kakuu seeraa irra jiran gidduudhaa waaʼee ajajawwan ani saba Israaʼeliitiif sitti kennu hundaa sittin hima. ");
INSERT INTO gaz_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","“Muka laaftoo irraa minjaala dhundhuma lama dalga dheeratu, kan dhundhuma tokko balʼatee ol dheerinni isaa immoo dhundhuma tokkoo fi walakkaa taʼe tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Warqee qulqulluu itti uffisiitii naannoo isaatti marsaa warqee tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Naannoo isaa irrattis hidhii hamma balʼina harkaa gaʼuu fi faaya warqee tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Minjaala kanaafis qubeelaa warqee afur hojjedhuutii goleewwan afranitti iddoo miilli afran jiranitti kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Qubeelaawwan kunneenis akka danqaraa ittiin minjaala baatan qabataniif xiyyoo sanatti dhiʼaachuu qabu. ");
INSERT INTO gaz_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Muka laaftoo irraa loosawwan tolchi; warqee itti uffisiitii minjaala sana ittiin baadhu. ");
INSERT INTO gaz_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Dhibaayyuu dhiʼeessuufis caabiiwwan isaa, waciitiiwwan isaa, okkoteewwan isaatii fi waciitiiwwan isaa warqee qulqulluu irraa tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Buddeena ilaalchaas yeroo hunda fuula koo dura minjaala kana irra kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","“Baattuu ibsaas warqee qulqulluu irraa tolchi; baattuun ibsaa kunis tumamee haa tolfamu; somaa isaa, damee isaa, waciitii isaa, hudhaa isaatii fi daraaraa isaa warqeedhuma sana irraa tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Bitaa mirga baattuu ibsaa sana keessaas dameewwan jaʼa jechuunis sadii gama tokkoon, sadii immoo gama kaaniin haa baafaman. ");
INSERT INTO gaz_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Xoofoowwan lawuzii fakkaatan kanneen tokkoon tokkoon isaanii hudhaa fi daraaraa qaban sadii damee tokko irratti, waciitiiwwan lawuzii fakkaatan kanneen tokkoon tokkoon isaanii hudhaa fi daraaraa qaban sadii immoo damee kaan irratti tolchi; dameewwan jaʼaan baattuu ibsaa irraa babbaʼan hunda irrattis akkasuma tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Xoofoowwan hudhaa fi daraaraa qaban kanneen bifa lawuziitiin hojjetaman afur baattuu ibsaa sana irra haa jiraatan. ");
INSERT INTO gaz_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Hudhaan tokko cimdii jalqabaa kan dameewwan baattuu ibsaa irraa babbaʼan jala, hudhaan lammaffaan cimdii lammaffaa jala, hudhaan sadaffaan immoo cimdii sadaffaa jala ture. Walumaa galatti dameewwan jaʼatu ture. ");
INSERT INTO gaz_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Hudhaawwanii fi dameewwan hundinuu baattuu ibsaa sana wajjin warqeedhuma qulqulluu tumame tokko irraa haa tolfaman. ");
INSERT INTO gaz_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","“Atis ibsaawwan torba tolchiif; akka lafa fuula isaanii dura jiru ibsaniifis baattuu ibsaa irra isaan dhadhaabi. ");
INSERT INTO gaz_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Wanni ittiin daaraa isaa dhadhaʼanii fi caabiin daaraa sana baattu warqee qulqulluu irraa haa hojjetaman. ");
INSERT INTO gaz_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Baattuun ibsaatii fi miʼi isaa hundi warqee qulqulluu taalaantii tokkootiin haa hojjetamani. ");
INSERT INTO gaz_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Atis akkuma fakkeenya tulluu irratti sitti argisiifame sanaatti hojjechuu kee mirkaneeffadhu. ");
INSERT INTO gaz_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","“Golgaawwan kudhan kanneen quncee talbaa gaarii foʼamee fi kan kirrii bifa cuquliisaa, dhiilgee fi bildiimaa irraa hojjetamaniin dunkaana qulqulluu hojjedhu; golgaawwan sana irrattis ogeessi harka qajeelu tokko kiirubeelii haa hojjetu. ");
INSERT INTO gaz_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Golgaawwan hundinuu wal qixxee haa taʼan; dheerinni tokkoo tokkoo golgaawwanii dhundhuma digdamii saddeeti, balʼinni isaa immoo dhundhuma afur haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Golgaawwan shan walitti qabsiisi; golgaawwan hafan shanan kaan illee akkasuma walitti qabsiisi. ");
INSERT INTO gaz_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Golgaawwan walitti qabsiifaman kanneen jalqabaa keessaa handaara isa moggaa irratti huccuu bifa cuquliisaa irraa gurroowwan tolchi; golgaawwan walitti qabsiifaman lammaffaa irrattis akkasuma tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Gurroowwan shantama golgaa tokko irratti tolchi; gurroowwan shantama immoo golgaawwan walitti qabsiifaman lammaffaa keessaa moggaa isa tokkootti tolchi. Gurroowwan sunis gamaa gamanatti haa tolfaman. ");
INSERT INTO gaz_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Akka dunkaanni qulqulluun sun tokko taʼuufis hokkoowwan warqee shantama tolchiitii golgaawwan sana ittiin walitti qabsiisi. ");
INSERT INTO gaz_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","“Haguuggii gubbaa dunkaana qulqulluu irra jiru haguuguufis golgaawwan rifeensa reʼootaa kudha tokko hojjedhu. ");
INSERT INTO gaz_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Golgaawwan kudha tokkoon sun hundi wal qixxee haa taʼan; dheerinni isaanii dhundhuma soddoma, balʼinni isaanii immoo dhundhuma afur haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Golgaawwan shan iddoo tokkotti walitti qabsiisi; golgaawwan jaʼan kaan immoo iddoo tokkotti walitti qabsiisi; golgaa jaʼaffaa sanas fuula dunkaanichaa duraan iddoo lamatti ol dachaasi. ");
INSERT INTO gaz_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Golgaawwan gama tokkoon walitti qabsiifaman keessaa handaara isa moggaa irratti gurroowwan shantama tolchi; golgaawwan gama kaan irratti walitti qabsiifaman keessaas handaara isa moggaa irratti gurroowwan shantama tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Ergasiis qabduuwwan naasii shantama tolchi; qabduuwwan sanas akka inni tokko taʼuuf ittiin walitti qabsiisuuf gurroowwan keessa galchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Wanni golgaawwan dunkaanichaa irraa hafe, walakkaan golgaa hafe sanaa dugda dunkaana qulqulluu irraan gad haa rarraʼu. ");
INSERT INTO gaz_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Akka dunkaana qulqulluu sana haguuguufis dheerina golgaawwan dunkaanicha irraa hafe keessaa dhundhumni tokko gama tokkoon, dhundhumni tokko immoo gama kaaniin bitaa fi mirgaan dunkaana qulqulluu irraan gad haa rarraʼu. ");
INSERT INTO gaz_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Dunkaana sanaafis irra buusaa kaldhee korbeessa hoolaa kan halluu diimaa cuuphame, isa irraan immoo irra buusaa gogaa duugamee hojjedhu. ");
INSERT INTO gaz_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","“Dunkaana qulqulluu sanaafis muka laaftoo irraa tuggeewwan qaqqajeeloo hojjedhu. ");
INSERT INTO gaz_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Dheerinni tokkoo tokkoo tuggeewwan sanaas dhundhuma kudhan, balʼinni isaa immoo dhundhuma tokkoo fi walakkaa haa taʼu; ");
INSERT INTO gaz_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","tokkoon tokkoon tuggeewwan sanaas akka wal keessa galuu dandaʼuuf mucha lama lama haa qabaatu; tuggeewwan dunkaana qulqulluu sanaa hunda akkasitti tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Gama kibba dunkaana qulqulluu sanaatiifis tuggeewwan digdama hojjedhu; ");
INSERT INTO gaz_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","tuggeewwan digdamman sana jalatti miilla meetii afurtama jechuunis tuggee tokko jalatti miilla lama gurra isaa lamaaniif, tuggee kaan jalattis miilla lama gurra isaa lamaaniif tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Gama dunkaana qulqulluu sanaa kaaniifis karaa kaabaatiin tuggeewwan digdama tolchi; ");
INSERT INTO gaz_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","miilla meetiis afurtama jechuunis tuggee tokko jalatti miilla lama, tuggee kaan jalattis miilla lama tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Karaa lixa biiftuutiin, dugda duuba dunkaana qulqulluu sanaatiif tuggee jaʼa tolchi; ");
INSERT INTO gaz_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","karaa dugda duubaas golee dunkaana qulqulluu sanaatiif utubaa lama tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Tuggeewwan golee kunneen jalaa hamma gubbaatti walitti fayyifamanii bantii irratti qubeelaa tokkoon walitti haa qabsiifaman; tuggeewwan golee lamaaniis akkasuma taʼuu qabu. ");
INSERT INTO gaz_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Kanaafuu tuggeewwan saddeeti kanneen miilla meetii kudha jaʼa qabanitu jira; tokkoon tokkoon tuggee sanaas miilla lama lama qaba. ");
INSERT INTO gaz_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","“Akkasumas muka laaftoo irraa dagaleewwan tolchi; tuggeewwan dunkaana qulqulluu sana irra gama tokkoon jiraniif dagaleewwan shan, ");
INSERT INTO gaz_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","tuggeewwan gama kaaniin jiraniif dagaleewwan shan, shan tuggeewwan dugda duubaan karaa lixa biiftuutiin jiraniif immoo dagaleewwan shan tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Dagalee walakkaa jiru sana akka inni gidduu tuggeewwaniitiin moggaa tokkoo hamma moggaa kaaniitti fullaʼu godhi. ");
INSERT INTO gaz_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Tuggeewwan sana irras warqee itti uffisi. Akka dagaleewwan baataniif qubeelaawwan warqee itti tolchi; dagaleewwan sanas akkasuma warqee itti uffisi. ");
INSERT INTO gaz_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","“Dunkaana qulqulluu kana akkuma karoora tulluu irratti sitti argisiifame sanaatti dhaabi. ");
INSERT INTO gaz_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","“Kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa haphii irraa golgaa tulchi; golgaa kana irrattis ogeessi harka qajeelu tokko fakkii kiirubeelii haa tolchu. ");
INSERT INTO gaz_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Golgaa kana hokkoo warqeetiin utubaawwan muka laaftoo kanneen warqeen itti uffifamee miilla meetii afur irra dhadhaabatan afuritti rarraasi. ");
INSERT INTO gaz_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Golgaa sana hokkoowwanitti rarraasiitii taabota kakuu seeraa immoo dugda isaa duubaan kaaʼi. Golgaan sunis Iddoo qulqulluu, Iddoo Iddoo Hunda Caalaa Qulqulluu taʼe sana irraa addaan baasa. ");
INSERT INTO gaz_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Teessoo araaraas Iddoo Iddoo Hunda Caalaa Qulqulluu taʼe sana keessa taabota kakuu seeraa irra kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Minjaala sanas golgaadhaan ala, gama kaaba dunkaana qulqulluutiin dhaabi; baattuu ibsaa immoo fuullee minjaala sanaa gama kibba dunkaanichatiin dhaabi. ");
INSERT INTO gaz_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","“Balbala dunkaanichaatiif immoo golgaa kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼamee harkaan irratti hodhame tokko faayessii tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Golgaa kanaafis hokkoo warqeetii fi utubaa muka laaftoo kan warqeen itti uffifame shan tolchi. Naasii tumiitii miilla shan tolchiif. ");
INSERT INTO gaz_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","“Muka laaftoo irraa iddoo aarsaa dhundhuma sadii ol dheeratu ijaari; iddoon aarsaa kunis dheerina dhundhuma shanii fi balʼina dhundhuma shanii qabaatee gama afraniinuu wal qixxee haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Tokkoo tokkoo goleewwan afraniitti gaanfa tolchi; gaanfaa fi iddoon aarsaa sun mukuma tokko irraa haa taʼu; iddoo aarsaa sana irrattis naasii uffisi. ");
INSERT INTO gaz_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Miʼa isaa hunda jechuunis waan ittiin daaraa haran, waan ittiin daaraa hammaaran, waciitii, hokkoo fooniitii fi baattuu ibiddaa naasii irraa tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Naasii wal keessa xaxameen gingilchaa hojjedhuutii tokkoo tokkoo rogawwan gingilchaa sanaa afraniif qubeelaawwan naasii tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Gingilchaa sanas akka inni hamma walakkaa iddoo aarsaatti ol kaʼuuf qarqara iddoo aarsaa jalaan kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Iddoo aarsaa sanaafis danqaraawwan muka laaftoo tolchiitii naasii itti uffisi. ");
INSERT INTO gaz_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Danqaraawwan sunis akka yeroo iddoon aarsaa baatamutti gama lamaaniin oolaniif qubeelaawwan keessa haa loofaman. ");
INSERT INTO gaz_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Akkuma tulluu irratti sitti argisiifame sanatti iddoo aarsaa kan keessi isaa duwwaa taʼe saanqaa irraa hojjedhu. ");
INSERT INTO gaz_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","“Dunkaana qulqulluu sanaaf oobdii hojjedhu. Oobdichis gama kibbaatiin dhundhuma dhibba tokko haa dheeratu; innis golgaa quncee talbaa gaarii foʼame irraa hojjetamee ");
INSERT INTO gaz_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","utubaawwan digdamaa fi miilla naasii digdama qaban haa qabaatu; hokkoowwanii fi somaawwan utubaawwan kanneenis meetii irraa haa hojjetaman. ");
INSERT INTO gaz_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Gama kaabaatiinis akkasuma dhundhuma dhibba tokko dheeratee golgaawwan utubaawwan digdamaa fi miilla naasii digdama qaban haa qabaatu; hokkoowwanii fi somaawwan utubaawwan kanaas meetii irraa haa tolfaman. ");
INSERT INTO gaz_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","“Oobdiin kun gama lixaatiin dhundhuma shantama balʼatee golgaawwan, utubaa kudhanii fi miilla kudhan qaban haa qabaatu. ");
INSERT INTO gaz_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Oobdiin kun fiixee baʼaatiin karaa baʼa biiftuutiin akkasuma dhundhuma shantama haa balʼatu. ");
INSERT INTO gaz_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Golgaawwan dhundhuma kudha shan dhedheeratanii utubaa sadii fi miilla sadii qabanis karaa balbala tokkoo irra haa jiraatan. ");
INSERT INTO gaz_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Golgaawwan dhundhuma kudha shan dhedheeratanii utubaa sadii fi miilla sadii qabanis gama kaaniin haa jiraatan. ");
INSERT INTO gaz_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","“Balbala oobdii sanaatiifis golgaa dhundhuma digdama dheeratee utubaa afurii fi miilla afur qabu kan kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen dhaʼamee irratti faayeffamee hojjetame tokko tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Utuboonni naannoo oobdii sanaa hundinuu somaawwanii fi hokkoowwan meetiitii fi miillawwan naasii haa qabaatan. ");
INSERT INTO gaz_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Oobdiin sun dheerina dhundhuma dhibba tokkoo fi balʼina dhundhuma shantamaa haa qabaatu; golgaa quncee talbaa gaarii foʼamee dhundhuma shan ol dheeratuu fi miillawwan naasii irraa hojjetame haa qabaatu. ");
INSERT INTO gaz_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Miʼi tajaajila dunkaana qulqulluu sanaatiif fayyadu biraa hundi, tajaajila kam iyyuu taanaan, qofoo dunkaanichaatii fi qofoo oobdii sanaa hunda dabalatee naasii irraa haa hojjetamu. ");
INSERT INTO gaz_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","“Akka ibsaan ittuma fufee bobaʼuuf akka isaan zayitii ejersa cuunfame taliila isaa ibsaadhaaf siif fidan saba Israaʼel ajaji. ");
INSERT INTO gaz_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aroonii fi ilmaan isaa dunkaana wal gaʼii keessatti golgaa fuula taabota kakuu seeraa dura jiruun alatti akka ibsaan sun galgalaa hamma ganamaatti fuula Waaqayyoo duratti bobaʼuu haa godhan. Wanni kunis saba Israaʼel keessatti dhaloota dhufuuf seera bara baraa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","“Akka isaan luboota taʼanii na tajaajilaniif obboleessa kee Aroon, isa wajjinis ilmaan isaa Naadaab, Abiihuu, Eleʼaazaarii fi Iitaamaarin saba Israaʼel keessaa ofitti dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Akka inni ulfinaa fi miidhagina argatuufis obboleessa kee Arooniif uffata qulqulluu hodhi. ");
INSERT INTO gaz_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Akka inni luba taʼee na tajaajiluuf namoota beekumsa qaban kanneen ani ogummaa akkanaa kenneef hunda akka isaan akka inni addaan baafamuuf jedhanii Arooniif uffata hodhan itti himi. ");
INSERT INTO gaz_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Uffanni isaan hojjetanis: kiisii qomaa, dirata, wandaboo, kittaa miidhagfamee dhawame, marata mataatii fi sabbataa dha. Jarris akka isaan luboota taʼanii na tajaajilaniif obboleessa kee Aroonii fi ilmaan isaatiif uffata qulqulluu kana haa hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Ogeeyyiin sunis warqee fi kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼametti haa fayyadaman. ");
INSERT INTO gaz_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","“Ogeessa harka tolu tokko warqee, kirrii bifa cuquliisaa, dhiilgee fi bildiimaa fi quncee talbaa kan qalʼifamee foʼameen dirata hojjechiisi. ");
INSERT INTO gaz_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Diranni kunis akka walitti guduunfamuu dandaʼuuf funyoo gatiittii lama kanneen fiixee isaa lamaanitti rarraafaman haa qabaatu. ");
INSERT INTO gaz_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Sabbanni isaa kan ogummaadhaan dhaʼames akkuma isaa dirata wajjin tokko taʼee warqeedhaan, kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen haa hojjetamu. ");
INSERT INTO gaz_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","“Dhagaawwan sardooniksii lama fuudhiitii maqaa ilmaan Israaʼel isaan irratti soofii barreessi. ");
INSERT INTO gaz_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","Akkuma toora dhaloota isaaniitti, maqaa jaʼa dhagaa tokko irratti, maqaa jaʼaan hafes dhagaa kaan irratti soofii barreessi. ");
INSERT INTO gaz_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Akkuma ogeessi faayaa tokko chaappaa soofee hojjetu sana atis dhagaa lamaan sana irratti maqaa ilmaan Israaʼel soofii barreessi; ergasiis faaya warqee itti naannessiitii ");
INSERT INTO gaz_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","akka inni ilmaan Israaʼeliif dhagaa yaadannoo taʼuuf funyoo gatiittii dirata sanatti qabsiisi. Aroonis maqaa sana yaadannoo godhee fuula Waaqayyoo duratti gatiittii isaa lamaanitti haa baatu. ");
INSERT INTO gaz_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ati immoo faaya warqee itti naannessiitii ");
INSERT INTO gaz_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","foncaa warqee qulqulluu kan akka funyootti foʼame lama tolchi; foncaa foʼame sana illee faaya sanatti qabsiisi. ");
INSERT INTO gaz_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","“Ogeessa harka tolu tokko kiisii qomaa kan murtii hojjechiisi; isas akkuma dirata sanaatti warqeedhaan, kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen hojjedhu. ");
INSERT INTO gaz_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kiisiin qomaa kun gama afraniinuu wal qixxee fi dachaa taʼee dheerina taakkuu tokkoo fi balʼina taakkuu tokko haa qabaatu. ");
INSERT INTO gaz_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Dhagaawwan gati jabeeyyiis toora afuriin irratti maxxansi. Toora jalqabaa irratti sardiyoon, tophaaziyoonii fi biiralee; ");
INSERT INTO gaz_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","toora lammaffaa irratti baluur, sanpeerii fi almaaz; ");
INSERT INTO gaz_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","toora sadaffaa irratti yaakinti, kelqedoonii fi yaakinti, ");
INSERT INTO gaz_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","toora afuraffaa irratti biiralee, sardooniksii fi yaasphiidi maxxansi. Dhagaawwan kanneenittis marsaa faaya warqee tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Dhagaawwan kudha lama kanneen tokkoo tokkoo isaanii irratti maqaa gosoota kudha lama keessaa maqaan tokko akkuma chaappaatti soofame haa jiraatan; tokkoon tokkoon dhagaawwan sanaas maqaa ilmaan Israaʼel tokko tokkoof dhaabata. ");
INSERT INTO gaz_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","“Kiisii qomaatiifis foncaa warqee qulqulluu akka funyootti foʼame tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Kiisii qomaa sanaafis qubeelaa warqee lama tolchiitii qubeelaa warqee lamaan roga kiisii qomaa lamaanitti qabsiisi. ");
INSERT INTO gaz_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Foncaa warqee sana lamaanis qubeelaawwan rogawwan kiisii qomaa sanatti guduunfi. ");
INSERT INTO gaz_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Mataa lamaan foncaa lamaan sanaa kaan immoo marsaawwan faayaa lamaanitti guduunfiitii karaa fuula duraatiin foncaa dirataa kan gatiittiitti qabsiisi. ");
INSERT INTO gaz_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Qubeelaawwan warqee lama tolchiitii rogawwan kiisii qomaa biraa kanneen karaa moggaa keessaatiin diratatti aananii jiran lamaanitti kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ammas qubeelaawwan warqee lama biraa tolchiitii sabbata dirataatiin olitti hodhaatti dhiʼeessii funyoo gatiittii lamaan fuula dirataa duraan jiru sana jalaan itti hidhi. ");
INSERT INTO gaz_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Akka kiisiin qomaa dirata irraa hin sosochooneef qubeelaawwan kiisii qomaa sun sabbata mudhiitiin walitti qabsiifamanii funyoo bifa cuquliisaatiin qubeelaawwan diratatti haa qabsiifaman. ");
INSERT INTO gaz_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","“Aroon yeroo iddoo qulqulluu ol seenu hunda akka fuula Waaqayyoo duratti yaadannoo bara baraa taʼuuf laphee isaa irratti kiisii qomaa kan murtiitiin maqaa ilmaan Israaʼel ni baata. ");
INSERT INTO gaz_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Akka isaan yeroo Aroon fuula Waaqayyoo dura dhufu hunda laphee isaa irra jiraataniif Uriimii fi Tumiimii akkasuma kiisii qomaa keessa kaaʼi. Akkasiinis Aroon yeroo hunda miʼa ittiin Israaʼelootaaf murtii kennu fuula Waaqayyoo duratti laphee isaa irratti baata. ");
INSERT INTO gaz_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","“Huccuu bifti isaa guutumaan guutuutti cuquliisa taʼe irraa wandaboo dirataa tolchi; ");
INSERT INTO gaz_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","walakkaa gubbaa isaattis afaan ittiin mataa seensifatan tolchi. Akka inni hin tarsaaneefis qarqara afaan isaa irra wanni faayeffamee qopheeffame haa jiraatu. ");
INSERT INTO gaz_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Naannoo xiyyoo wandaboo sanaatti immoo kirrii bifa cuquliisaa, dhiilgee fi bildiimaadhaan roomaanii hojjedhuutii gidduu isaatti immoo bilbila warqee tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Bilbilli warqeetii fi roomaaniin sun wal jala dadarbanii naannoo xiyyoo wandaboo sanaatti haa hojjetaman. ");
INSERT INTO gaz_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aroon yeroo tajaajilu wandaboo kana haa uffatu; akka inni hin duuneef yommuu inni fuula Waaqayyoo dura iddoo qulqulluu seenuu fi yommuu inni achii gad baʼutti sagaleen bilbila sanaa ni dhagaʼama. ");
INSERT INTO gaz_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","“Warqee qulqulluu irraa faaya tolchii, Kan Waaqayyoof Qulqulleeffame, jedhiitii akkuma waan chaappaa irratti soofamuutti soofii barreessi. ");
INSERT INTO gaz_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Faaya sana marata mataatiin wal qabsiisuuf funyoo bifa cuquliisaa itti hidhi; innis marata mataa fuula duraan haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Faayi kunis adda Aroon irra taaʼa; Aroonis yakka kennaawwan qulqulluu ilmaan Israaʼel dhiʼeessan keessatti argamu hunda ni baata. Kunis akka isaan fuula Waaqayyoo duratti fudhatama argataniif adda Aroon irra jiraata. ");
INSERT INTO gaz_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","“Quncee talbaa kan qalʼifamee foʼame dhoofsisiitii qomee hojjedhu; marata mataa illee quncee talbaa gaarii irraa tolchi. Sabbannis ogeessa harka qajeeluun haa tolfamu. ");
INSERT INTO gaz_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","Akka ilmaan Aroonis ulfinaa fi miidhagina argataniif qomee, sabbataa fi marata mataa tolchiif. ");
INSERT INTO gaz_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Erga uffata kana obboleessa kee Aroonittii fi ilmaan isaatti uffiftee booddee dibii isaan muudi. Akka isaan luboota taʼanii na tajaajilaniifis isaan qulqulleessi. ");
INSERT INTO gaz_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","“Qumxaa wayyaa jalaa kan mudhiidhaa jalqabee hamma gudeedaatti qullaa namaa dhoksu quncee talbaa irraa hojjedhuuf. ");
INSERT INTO gaz_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Aroonii fi ilmaan isaa akka balleessaa hojjetanii hin duuneef yeroo dunkaana wal gaʼii seenan yookaan Iddoo Qulqulluu sanatti tajaajila kennuuf iddoo aarsaatti dhiʼaatan uffata kana uffachuu qabu. “Kunis Aroonii fi sanyii isaatiif sirna bara baraa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","“Akka isaan luboota taʼanii na tajaajilaniif wanni ati isaan qulqulleessuuf gootu kanaa dha; dibicha tokkoo fi korbeeyyii hoolaa kanneen mudaa hin qabne lama fuudhi. ");
INSERT INTO gaz_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Daakuu qamadii filatamaa irraa Maxinoo, Maxinoo zayitiidhaan sukkuumamee fi bixxillee zayitiin irra dibame tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","Isaan kanas gundoo keessa kaaʼiitii dibichaa fi korbeeyyii hoolaa wajjin dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Ergasii immoo Aroonii fi ilmaan isaa gara balbala dunkaana wal gaʼiitti fidiitii bishaaniin isaan dhiqi. ");
INSERT INTO gaz_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Uffatas fuudhiitii qomee, wandaboo dirataa, dirataa fi kiisii qomaa Aroonitti uffisi. Dirata sanas sabbata ogummaadhaan dhaʼameen hidhi. ");
INSERT INTO gaz_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Mataa isaatti marata mari; marata sanatti immoo gonfoo qulqulluu qabsiisi. ");
INSERT INTO gaz_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Zayitii ittiin dibdu fuudhiitii mataa isaa irratti dhangalaasuudhaan isa dibi. ");
INSERT INTO gaz_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ilmaan isaa fidii qomee isaanitti uffisi; ");
INSERT INTO gaz_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","mataa isaaniitti marata mari. Ergasii immoo Aroonii fi ilmaan isaatti sabbata hidhi. Lubummaanis seera bara baraatiin kan isaanii ti. “Atis akkasiin Aroonii fi ilmaan isaa muudi. ");
INSERT INTO gaz_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","“Dibicha sana gara fuula dunkaana wal gaʼiitti fidi; Aroonii fi ilmaan isaa immoo harka isaanii mataa isaa irra haa kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Atis fuula Waaqayyoo duratti, balbala dunkaana wal gaʼii irratti isa qali. ");
INSERT INTO gaz_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Dhiiga dibicha sanaa irraa xinnoo fuudhiitii quba keetiin gaanfa iddoo aarsaa dibi; kan hafe immoo miilla iddoo aarsaa irratti dhangalaasi. ");
INSERT INTO gaz_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Moora miʼa garaatti haguugame hunda, haguuggii tiruutii fi moora kalee lamaanitti haguugame fuudhiitii iddoo aarsaa irratti gubi. ");
INSERT INTO gaz_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Foon dibicha sanaa, gogaa isaatii fi cumaa isaa garuu qubata keessaa gad baasii gubi. Inni aarsaa cubbuu ti. ");
INSERT INTO gaz_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","“Korbeeyyii hoolaa sana keessaa tokko fidi; Aroonii fi ilmaan isaas harka isaanii mataa isaa irra haa kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Korbeessa hoolaa sana qalii dhiiga isaa fuudhiitii gama hundaan iddoo aarsaatti facaasi. ");
INSERT INTO gaz_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Korbeessa hoolaa sana gargar kukkutii miʼa garaatii fi luka isaa miiciitii mataa fi kutaawwan kaan wajjin kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Korbeessa hoolaa sana guutumaan guutuutti iddoo aarsaa irratti gubi. Kunis qalma Waaqayyoof gubamu, aarsaa urgaaʼaa ibiddaan Waaqayyoof dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","“Korbeessa hoolaa kaan illee fidi; Aroonii fi ilmaan isaa harka isaanii mataa isaa irra haa kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Korbeessa hoolaa sana qali; dhiiga isaa irraas fuudhiitii fiixee gurra Aroon mirgaatii fi fiixee gurra ilmaan isaa mirgaa dibi; quba abbuudduu harka mirgaa isaaniitii fi quba abbuudduu miilla mirgaa isaanii illee dibi. Dhiiga hafe immoo gama hundaan iddoo aarsaatti facaasi. ");
INSERT INTO gaz_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Dhiiga iddoo aarsaa irra jiru irraa, zayitii ittiin diban irraas fuudhiitii Aroonii fi uffata isaatti, ilmaan isaatii fi uffata isaaniitti facaasi. Akkasiin innii fi ilmaan isaa, uffanni isaaniis ni qulqullaaʼu. ");
INSERT INTO gaz_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","“Korbeessa hoolaa kana irraas cooma, duboo, moora miʼa garaa haguugu, haguuggii tiruu, kalee lamaanii fi moora isaanitti jiru, akkasumas tafa mirgaa fuudhii. Korbeessi hoolaa kunis hoolaa ittiin lubummaa kennanii dha. ");
INSERT INTO gaz_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Gundoo Maxinoo baatu kan fuula Waaqayyoo dura jiru sana irraa maxinoo tokko, maxinoo zayitiidhaan tolfame tokkoo fi bixxillee tokko fuudhi. ");
INSERT INTO gaz_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Wantoota kanneen hunda harka Aroonii fi harka ilmaan isaa keessa kaaʼiitii aarsaa sochoofamu godhii fuula Waaqayyoo duratti sochoosi. ");
INSERT INTO gaz_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Ergasii immoo harka isaaniitii fuudhii akka urgaa Waaqayyotti tolu taʼuuf aarsaa gubamu wajjin iddoo aarsaa irratti gubi; kunis aarsaa ibiddaan Waaqayyoof dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Erga handaraafa hoolaa Aroon ittiin luba taʼe sana fuutee booddee aarsaa sochoofamu godhiitii fuula Waaqayyoo duratti sochoosi; kunis qooda kee ti. ");
INSERT INTO gaz_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","“Handaraafa aarsaa sochoofamuu, luka korbeessa hoolaa isa kan Aroonii fi ilmaan isaa isa yeroo isaan luba taʼan aarsaa taʼee dhiʼaate sana qulqulleessi. ");
INSERT INTO gaz_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Kunis qooda bara baraa kan sabni Israaʼel yeroo hunda Aroonii fi ilmaan isaatiif kennuu dha. Innis gumaacha sabni Israaʼel aarsaa nagaa irraa Waaqayyoof kennuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","“Akka isaan ittiin dibamanii luba taʼaniif uffanni Aroon qulqulluun kan ilmaan isaa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ilmi iddoo isaa buʼee luba taʼuudhaan Iddoo Qulqulluu keessa tajaajiluuf gara dunkaana wal gaʼii dhufu bultii torba uffata kana haa uffatu. ");
INSERT INTO gaz_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","“Korbeessa hoolaa isa ittiin luba taʼan sana fuudhiitii foon isaa Iddoo Qulqulluutti affeeli. ");
INSERT INTO gaz_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aroonii fi ilmaan isaa foon hoolaa sanaatii fi buddeena gundoo irraa sana balbala dunkaana wal gaʼii duratti haa nyaatan. ");
INSERT INTO gaz_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Isaanis aarsaa isaan ittiin luba taʼanii fi qulqulleeffamuu isaaniitiif ittiin araarri buʼe haa nyaatan. Sababii aarsaan sun qulqulluu taʼeef garuu namni kaan hin nyaatin. ");
INSERT INTO gaz_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Yoo foon korbeessa hoolaa ittiin luba taʼan kam iyyuu yookaan buddeenni kam iyyuu hafee bule ibiddaan gubi; sababii qulqulluu taʼeef nyaatamuu hin qabu. ");
INSERT INTO gaz_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","“Waan ani si ajaje hunda Aroonii fi ilmaan isaatiif godhi. Bultii torba guutuu seera lubummaa isaaniif raawwadhu. ");
INSERT INTO gaz_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Akka araarri buʼuufis guyyuma guyyaan dibicha qalii aarsaa cubbuu dhiʼeessi. Iddoo aarsaa sanaaf aarsaa araaraa dhiʼeessuudhaan qulqulleessi; addaan baasuudhaafis isa dibi. ");
INSERT INTO gaz_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Iddoo aarsaa sanaafis bultii torba araara buusiitii isa qulqulleessi. Yoos iddoon aarsaa sun waan hunda caalaa qulqulluu taʼa; wanni isa tuqu hundinuus ni qulqulleeffama. ");
INSERT INTO gaz_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","“Wanni ati yeroo hunda iddoo aarsaa irratti guyyaa guyyaan dhiʼeessitu kanaa dha: Xobbaallaawwan kanneen umuriin isaanii waggaa tokko tokko taʼe lama; ");
INSERT INTO gaz_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","tokko ganama, kaan immoo galgala dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Xobbaallaa jalqabaa sana wajjinis daakuu baʼeessa isaa iifii tokko irraa harka kudhan keessaa harki tokko zayitii ejersaa kan cuunfamee iinii tokko harka afur keessaa harka tokkoon sukkuumame dhiʼeessi; akkasumas daadhii wayinii iinii harka afur keessaa harka tokko dhibaayyuu godhii dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Xobbaallaa hoolaa kaan immoo kennaa midhaaniitii fi kan dhibaayyuu wajjin akkuma isa ganamaa sanaatti galgala dhiʼeessi; kunis aarsaa urgaaʼaa ibiddaan Waaqayyoof dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","“Qalmi gubamu kun dhaloota dhufu keessattis yeroo hunda balbala dunkaana wal gaʼii irratti fuula Waaqayyoo duratti haa dhiʼeeffamu. Anis gara keessan dhufee achitti isinitti nan dubbadha; ");
INSERT INTO gaz_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","saba Israaʼel wajjinis achumatti wal argina; iddoon sunis ulfina kootiin ni qulqulleeffama. ");
INSERT INTO gaz_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","“Ani dunkaana wal gaʼii fi iddoo aarsaa sana nan qulqulleessa; Aroonii fi ilmaan isaas akka isaan luboota taʼanii na tajaajilaniif nan qulqulleessa. ");
INSERT INTO gaz_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Anis saba Israaʼel keessa nan jiraadha; Waaqa isaaniis nan taʼa. ");
INSERT INTO gaz_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Isaanis akka ani Waaqayyo Waaqa isaanii kan gidduu isaanii jiraachuuf jedhee biyya Gibxiitii keessaa isaan baase taʼe ni beeku; ani Waaqayyo Waaqa isaanii ti. ");
INSERT INTO gaz_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","“Iddoo aarsaa kan ixaanni irratti aarfamu muka laaftoo irraa tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Iddoon aarsaa kunis dalga dheerina dhundhuma tokko, balʼina dhundhuma tokkootii fi ol dheerina dhundhuma lamaa qabaatee gama afraniinuu wal qixxee haa taʼu; gaanfawwan isaas iddoo aarsaa sanaan walitti waanuma tokko irraa haa tolfaman. ");
INSERT INTO gaz_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Gubbaa isaa irra, cinaacha isaa hundumaa fi gaanfawwan isaatti warqee qulqulluu uffisiitii naannoo isaatti marsaa warqee naannessii tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Iddoo aarsaa sanaafis marsaawwan warqee isaatii gaditti qubeelaawwan warqee lama tolchi; qubeelaawwan kanas akka isaan danqaraawwan ittiin iddoo aarsaa baatan qabataniif gamaa gamanaan cinaacha lamaanitti tolchi. ");
INSERT INTO gaz_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Danqaraawwan muka laaftoo tolchiitii warqee itti uffisi. ");
INSERT INTO gaz_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Iddoo aarsaa sanas fuula golgaa taabota kakuu seeraa bira jiru sanaa dura, fuula teessoo araaraa kan kakuu seeraatiin ol jiruu dura iddoo ani itti si argu sana dhaabi. ");
INSERT INTO gaz_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","“Aroon yommuu ganama ganama ibsaa qoqopheessutti iddoo aarsaa irratti ixaana urgaaʼaa haa aarsu. ");
INSERT INTO gaz_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Akka ixaanni sun dhaloota dhufu keessatti illee yeroo hunda fuula Waaqayyoo duratti aaruuf Aroon yommuu galgala galgala ibsaa qabsiisutti ixaana haa aarsu. ");
INSERT INTO gaz_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Iddoo aarsaa kana irratti ixaana gosa biraa yookaan qalma gubamu yookaan kennaa midhaanii hin dhiʼeessin; dhibaayyuus irratti hin dhibaafatin. ");
INSERT INTO gaz_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aroonis waggaatti yeroo tokko gaanfawwan iddoo aarsaa irratti aarsaa araara buusu haa dhiʼeessu; aarsaan waggaatti dhiʼeeffamu kun dhiiga aarsaa cubbuu kan araarri ittiin argamu wajjin dhaloota dhufu keessatti haa dhiʼeeffamu. Aarsaan kunis Waaqayyoof waan hundumaa caalaa qulqulluu dha.” ");
INSERT INTO gaz_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Ergasiis Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","“Yommuu ati baayʼina saba Israaʼel lakkooftutti tokkoon tokkoon namaa yeroo lakkaaʼamutti furii lubbuu isaa Waaqayyoof haa kennu. Yoos yeroo ati isaan lakkooftutti dhaʼichi tokko iyyuu isaan hin argatu. ");
INSERT INTO gaz_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Namni warra lakkaaʼamanitti dabalamu kam iyyuu akkuma saqilii iddoo qulqulluu kan geeraa digdamaa ulfaatu sanaatti walakkaa saqilii haa kennu. Walakkaan saqilii kunis kennaa Waaqayyoof dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Warra lakkaaʼaman keessaa kanneen umuriin isaanii waggaa digdama yookaan isaa oli taʼe hundinuu Waaqayyoof kennaa haa dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Yommuu isin lubbuu keessan furuuf jettanii Waaqayyoof kennaa dhiʼeessitanitti sooreyyiin walakkaa saqiliitii oli hin kennin; hiyyeeyyiinis walakkaa saqiliitii gad hin kennin. ");
INSERT INTO gaz_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Maallaqa furii sanas Israaʼeloota harkaa fudhiitii tajaajila dunkaana wal gaʼii sanaa irra oolchi; kunis lubbuu keessaniif furii taʼuuf fuula Waaqayyoo duratti yaadannoo saba Israaʼel taʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Ergasiis Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","“Gabatee naasii kan miilla naasii qabu dhiqannaadhaaf tolchi. Isas dunkaana wal gaʼiitii fi iddoo aarsaa gidduu kaaʼiitii bishaan itti naqi. ");
INSERT INTO gaz_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aroonii fi ilmaan isaa bishaani sanaan harka isaaniitii fi miilla isaanii haa dhiqatan. ");
INSERT INTO gaz_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Isaanis akka hin duuneef yeroo dunkaana wal gaʼii seenan bishaaniin dhiqatu; akkasumas yommuu aarsaa ibiddaan Waaqayyoof dhiʼeeffamu gubuudhaaf tajaajiluuf iddoo aarsaatti dhiʼaatanitti, ");
INSERT INTO gaz_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","akka hin duuneef harka isaaniitii fi miilla isaanii haa dhiqatan. Kunis dhaloota dhufu keessatti Aroonii fi sanyii isaatiif seera dhaabataa taʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Ergasiis Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","“Urgooftuuwwan urgooftuu hunda caalan jechuunis qumbii qulqulluu saqilii 500, qarafaa urgaaʼaa walakkaa isaa jechuunis saqilii 250, marga citaa urgaaʼaa saqilii 250, ");
INSERT INTO gaz_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","burgudii saqilii 500 fudhadhu; hundi isaa iyyuu akkuma saqilii iddoo qulqulluutti haa taʼu; akkasumas zayitii ejersaa iinii tokko fudhadhu. ");
INSERT INTO gaz_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","Urgooftuuwwan kanneeniinis zayitii ittiin diban qulqulluu isaa jechuunis makaa urgaaʼaa akkuma ogeessa urgooftuu qopheessu tokkootti tolchi. Kunis zayitii ittiin diban qulqulluu isaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Zayitii kanaanis dunkaana wal gaʼii, taabota kakuu seeraa, ");
INSERT INTO gaz_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","minjaalaa fi miʼa isaa hunda, baattuu ibsaa fi miʼa isaa, iddoo aarsaa ixaanaa, ");
INSERT INTO gaz_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","iddoo aarsaa qalma gubamuutii fi miʼa isaa hunda, gabatee itti dhiqatanii fi miilla isaa dibi. ");
INSERT INTO gaz_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Akka isaan waan hunda caalaa qulqulluu taʼaniif isaan qulqulleessi; wanni isaan tuqu kam iyyuus ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","“Akka isaan luboota taʼanii na tajaajilaniif Aroonii fi ilmaan isaa dibi qulqulleessi. ");
INSERT INTO gaz_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","Israaʼelootaan akkana jedhi; ‘Kun zayitiin qulqulluu ittiin dhaloota dhufuuf jiru diban naaf haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Zayitii kana dhagna nama biraa irratti hin dhangalaasin yookaan zayitii kam iyyuu karaa kanaan hin qopheessin. Zayitiin kun qulqulluu dha; innis isiniif qulqulluu haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Namni shittoo shittoo sana fakkaatu hojjetu kan nama biraattis dibu saba isaa keessaa haa balleeffamu.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Waaqayyos Museedhaan akkana jedhe; “Urgooftuu jechuunis hamphee urgaaʼu, elellaan urgaaʼu, aannan muka urgaaʼuu, ixaana makaa hin qabne kan hundi isaa iyyuu baayʼina wal qixxee qabu fudhadhuutii, ");
INSERT INTO gaz_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","akkuma namni urgooftuu qopheessu tokko hojjetutti ixaana makamaa urgaaʼu tolchi. Ixaana kanattis soogidda naqiitii qulqulleessi; akka qulqulluu taʼus godhi. ");
INSERT INTO gaz_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Isa keessaas gartokko daakii bulleessiitii dunkaana wal gaʼii keessa fuula taabota kakuu seeraa dura iddoo ani itti si argu sana kaaʼi. Innis kan waan hunda caalaa qulqullaaʼuu isiniif haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Haala kanaan ixaana ofii keessaniif hin qopheeffatinaa; akka inni Waaqayyoof qulqulluu taʼes hubadhu. ");
INSERT INTO gaz_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Namni urgaa isaatti gammaduuf jedhee waan isa fakkaatu tokko illee hojjetu saba ofii keessaa haa balleeffamu.” ");
INSERT INTO gaz_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","“Ilaa, ani gosa Yihuudaa keessaa Bezaliʼeel ilma Uuri, ilma Huuri filadheera; ");
INSERT INTO gaz_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ani Hafuura Waaqaatiin, ogummaadhaan, dandeettii fi beekumsa hojii harkaa gosa hundumaan isa guuteera; ");
INSERT INTO gaz_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Kunis akka inni warqeedhaan, meetii fi naasiidhaan hojii ogummaa hojjetuuf; ");
INSERT INTO gaz_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","akka inni dhagaawwan muree qopheessuuf, akka muka soofuu fi akka hojii ogummaa harkaa kan gosa hundaa keessatti hirmaatuuf. ");
INSERT INTO gaz_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Akkasumas ani kunoo akka inni isa gargaaruuf Oholiiyaab ilma Ahiisaamaak kan gosa Daan sana muudeera. ");
INSERT INTO gaz_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","“Isaanis dunkaana wal gaʼii, taabota kakuu seeraatii fi teessoo araaraa kan taabota sana irra jiru, miʼa dunkaana sanaa hunda jechuunis ");
INSERT INTO gaz_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","minjaalaa fi miʼa isaa, baattuu ibsaa kan warqee qulqulluu irraa tolfamee fi miʼa isaa hunda, iddoo aarsaa ixaanaa, ");
INSERT INTO gaz_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","iddoo aarsaa qalma gubamuutii fi miʼa isaa hunda, gabatee itti dhiqatanii fi miilla isaa, ");
INSERT INTO gaz_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","wayyaawwan miidhagfamanii dhaʼaman, wayyaawwan Aroon lubichaaf qulqulleeffamanii fi wayyaawwan ilmaan isaa yeroo lubummaadhaan tajaajilan uffatan, ");
INSERT INTO gaz_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","Iddoo Qulqulluu sanaaf immoo zayitii dibataatii fi ixaana urgaaʼu haa qopheessan. ");
INSERT INTO gaz_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","“Saba Israaʼeliin akkana jedhi; ‘Isin Sanbattoota koo eegaa. Ani Waaqayyo isa isin qulqulleessu akkan taʼe akka beektaniif kun dhaloota dhufu keessatti anaa fi isin gidduutti mallattoo taʼa. ");
INSERT INTO gaz_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","“ ‘Waan Sanbanni isiniif qulqulluu taʼeef isa eegaa. Namni Sanbata xureessu haa ajjeefamu; namni guyyaa sana hojii hojjetu kam iyyuu saba isaa keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Guyyaa jaʼa hojiin haa hojjetamu; guyyaan torbaffaan garuu sanbata boqonnaa ti; guyyaan kun Waaqayyoof qulqulluu dha. Namni guyyaa Sanbataa hojii hojjetu kam iyyuu haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Israaʼeloonni Sanbata kana kakuu bara baraa godhatanii dhaloota dhufu keessa haa eegan. ");
INSERT INTO gaz_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Kunis anaa fi Israaʼeloota gidduutti mallattoo bara baraa taʼa; Waaqayyo guyyaa jaʼa keessatti samii fi lafa uumee guyyaa torbaffaatti boqotee aara galfateeraatii.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Waaqayyo akkuma Gaara Siinaa irratti Museetti dubbatee raawwateen gabatee dhugaa lamaan jechuunis gabateewwan dhuga baʼumsaa kanneen qubni Waaqaa irratti barreesse sana isatti kenne. ");
INSERT INTO gaz_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Sabni sunis yommuu akka Museen tulluu irra ture argetti Aroonin marsee, “Musee namicha biyya Gibxiitii baasee nu fide sana waan inni taʼe hin beeknuutii kaʼii waaqota nu dura deeman nuu tolchi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aroon immoo, “Warqee gurraa kan niitonni keessan, ilmaan keessanii fi intallan keessan keeyyatan irraa baasaatii natti fidaa” jedhee deebiseef. ");
INSERT INTO gaz_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Namoonni hundinuu warqee gurra isaanii of irraa baasanii Aroonitti fidan. ");
INSERT INTO gaz_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Innis warqee sana isaan harkaa fuudhee miʼa ittiin hojjetaniin baqsee Waaqa tolfamaa bifa jabbiitiin hojjetame tokko tolche; isaanis, “Yaa Israaʼel isaan kunneen waaqota kee warra biyya Gibxiitii si baasanii dha” jedhan. ");
INSERT INTO gaz_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aroonis yommuu waan kana argetti fuula jabbii sanaa duratti iddoo aarsaa ijaaree, “Bori Waaqayyoof ayyaanni ni ayyaaneffama” jedhee labse. ");
INSERT INTO gaz_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Isaanis guyyaa itti aanu ganama bariin kaʼanii, aarsaa gubamu dhiʼeessanii aarsaa nagaas fidan. Kana irratti nyaachuu fi dhuguuf tataaʼan; sirbuufis kaʼan. ");
INSERT INTO gaz_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Waaqayyo Museedhaan akkana jedhe; “Sabni kee kan ati biyya Gibxiitii baaftee fidde sun xuraaʼeeraatii gad buʼi. ");
INSERT INTO gaz_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Isaan dafanii karaa ani isaan ajaje irraa jalʼataniiru; Waaqa tolfamaa bifa jabbiitiin baqfamee qopheeffame illee ofii isaaniitiif tolfatanii aarsaa dhiʼeessaniifii, ‘Yaa Israaʼel isaan kunneen waaqota kee warra biyya Gibxiitii si baasanii dha’ jedhanii isa waaqeffataniiru. ");
INSERT INTO gaz_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","“Waaqayyo Museedhaan akkana jedhe; ‘Kunoo, ani akka sabni kun mata jabeessa taʼe argeera. ");
INSERT INTO gaz_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Kanaafuu akka aariin koo isaanitti bobaʼuu fi akka ani isaan balleessuuf na dhiisi. Yommus ani saba guddaa si taasisa.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Museen garuu fuula gargaarsa Waaqayyo Waaqa isaa barbaaddate; akkanas jedhe; “Yaa Waaqayyo, dheekkamsi kee maaliif saba kee warra ati humna guddaa fi irree jabaadhaan biyya Gibxiitii baafte sanatti bobaʼa? ");
INSERT INTO gaz_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Warri Gibxii maaliif, ‘Inni duruma iyyuu yaada hamaadhaan tulluuwwan irratti isaan fixuu fi lafa irraa isaan balleessuuf Gibxii isaan baasee?’ jedhu. Aarii kee bobaʼaa sana irraa deebiʼi; obsis; saba keettis badiisa hin fidin. ");
INSERT INTO gaz_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Garboota kee Abrahaam, Yisihaaqii fi Israaʼelin warra, ‘Ani sanyii kee akka urjiiwwan samii irraa nan baayʼisa; lafa ani waadaa isaaniif seene kana hundas sanyii keessaniif nan kenna; isaanis bara baraan lafa sana ni dhaalu’ jettee maqaa keetiin kakatteef sana yaadadhu.” ");
INSERT INTO gaz_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Kana irratti Waaqayyo yaada geeddaratee badiisa saba isaatti fiduuf ture sana dhiise. ");
INSERT INTO gaz_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Museenis gabateewwan kakuu lamaan sana harkatti qabatee deebiʼee tulluu irraa gad buʼe. Gabatee sana irrattis karaa lachuu, duraa duubaan barreeffamee ture. ");
INSERT INTO gaz_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Gabateewwan sanas Waaqatu hojjete; katabbiin sunis katabbii Waaqaa kan gabateewwan sana irratti soofamee barreeffamee dha. ");
INSERT INTO gaz_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iyyaasuunis yommuu waca namootaa dhagaʼetti Museedhaan, “Iddoo buufataa keessa sagalee waraanaatu jira” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Museen immoo akkana jedhee deebise: “Sagaleen ani dhagaʼu kun sagalee sirbaati malee sagalee mooʼuu, yookaan sagalee moʼatamuu miti.” ");
INSERT INTO gaz_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Museenis akkuma iddoo qubataatti dhiʼaatee jabbii fi shuubbisa sana argeen aaree gubate; gabateewwan sana harka isaa irraa darbatee tulluu sana jalatti caccabse. ");
INSERT INTO gaz_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Innis jabbii jarri tolchan sana fuudhee ibiddaan gube; daakee bulleessees bishaanitti firfirsee Israaʼeloota obaase. ");
INSERT INTO gaz_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Museenis Arooniin, “Sabni kun maal si goonaan ati cubbuu guddaa akkasii keessa isaan buufte?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aroon immoo deebisee akkana jedhe; “Yaa gooftaa ko, aartee hin gubatin; akka sabni kun gara hamminaatti jalʼatu atuu beekta. ");
INSERT INTO gaz_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Isaan, ‘Musee namicha Gibxii baasee nu fide sana waan inni taʼe hin beeknuutii waaqota nu dura deeman nuu tolchi’ naan jedhan. ");
INSERT INTO gaz_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Anis, ‘Namni warqee qabu of irraa haa baasu’ jedheen; isaanis warqee sana natti kennan; anis ibidda keessa nan buuse; inni immoo jabbii taʼee baʼe!” ");
INSERT INTO gaz_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Museen akka sabni sun gad dhiisiitti jiraate, Aroonis akka isaan toʼannaadhaan ala taʼan akka godhee fi akka isaan diinota isaanii birattis waan kolfaa taʼan arge. ");
INSERT INTO gaz_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Kanaafuu Museen karra qubataa dura dhaabatee, “Mee warri gara Waaqayyo gortan hundi gara koo kottaa” jedhe. Lewwonni hundis isa biratti walitti qabaman. ");
INSERT INTO gaz_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Ergasii inni akkana isaaniin jedhe; “Waaqayyo Waaqni Israaʼel akkana jedha; ‘Tokkoon tokkoon namaa mudhii isaatti goraadee haa hidhatu; tokkoon tokkoon namaas qubata sana keessa karra tokko irraa gara karra kaaniitti asii fi achi deemee obboloota isaa, michoota isaatii fi ollaa isaa haa ajjeesu.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lewwonnis akkuma Museen isaan ajaje godhan; guyyaa sana saba sana keessaa nama gara kuma sadiitu duʼe. ");
INSERT INTO gaz_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Museenis, “Isin waan ilmaan keessanii fi obboloota keessanitti kaataniif harʼa Waaqayyoof addaan baafamtaniirtu; innis guyyaa harʼaa isin eebbiseera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Museen guyyaa itti aanutti saba sanaan, “Isin cubbuu guddaa hojjettaniirtu. Garuu ani amma gara Waaqayyootti ol nan baʼa; tarii ani cubbuu keessaniif araara nan buusa taʼa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Museenis deebiʼee gara Waaqayyoo dhaqee akkana jedhe; “Wayyoo! Sabni kun cubbuu akkam guddaa hojjete! Isaan ofii isaaniitiif waaqota warqee tolfataniiru. ");
INSERT INTO gaz_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Taʼus maaloo amma cubbuu isaanii dhiisiif; yoo kanaa achi kitaaba barreessite sana keessaa maqaa koo haqi.” ");
INSERT INTO gaz_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Waaqayyo immoo Museedhaan akkana jedhe; “Ani nama cubbuu natti hojjete kitaaba koo irraa nan haqa. ");
INSERT INTO gaz_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Amma kaʼiitii gara lafa ani sitti hime sanaatti saba kana qajeelchi; kunoo ergamaan koos fuula kee dura ni deema. Garuu gaafa yeroon ani isaan adabu gaʼutti ani cubbuu isaaniitiif isaan nan adaba.” ");
INSERT INTO gaz_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Sababii balleessaa isaan jabbii Aroon tolche sanaan hojjetaniitiif Waaqayyo balaadhaan saba sana dhaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Waaqayyo Museedhaan akkana jedhe; “Atii fi sabni ati biyya Gibxiitii baaftee fidde kun asii baʼaatii gara biyya ani Abrahaamiif, Yisihaaqii fi Yaaqoobiif, ‘Ani sanyii keetiif nan kenna’ jedhee kakadhe sanaa dhaqaa. ");
INSERT INTO gaz_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ani ergamaa koo fuula kee duraan ergee Kanaʼaanota, Amoorota, Heetota, Feerzota, Hiiwotaa fi Yebuusota ariʼee nan baasa. ");
INSERT INTO gaz_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Gara biyya aannanii fi dammi keessaa burquu dhaqi. Garuu waan ati saba mata jabeessa taateef ani akka karaatti si hin balleessineef si wajjin hin deemu.” ");
INSERT INTO gaz_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Jarri yommuu oduu hamaa kana dhagaʼanitti gadduu jalqaban; isaan keessaas namni tokko iyyuu faaya tokko illee hin kaaʼanne. ");
INSERT INTO gaz_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Waaqayyo Museedhaan akkana jedheeraatii; “Saba Israaʼeliin akkana jedhi; ‘Isin saba mata jabeeyyii dha. Ani utuu yeruma muraasa illee isin wajjin deemee silaa isin balleessa ture; isin amma faayawwan keessan of irraa baasaa; anis waanan isin godhu nan murteessaa.’ ” ");
INSERT INTO gaz_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Kanaafuu Israaʼeloonni Gaara Kooreeb biratti faayawwan isaanii of irraa baasan. ");
INSERT INTO gaz_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Museen dunkaana tokko fuudhee iddoo qubataa sana keessaa baasee achi fageessee dhaaba ture; dunkaana sanas, “dunkaana wal gaʼii” jedhee moggaase. Namni Waaqayyoon barbaadatu hundinuu iddoo qubataa sana keessaa baʼee gara dunkaana wal gaʼii sanaa dhaqa ture. ");
INSERT INTO gaz_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Yeroo Museen baʼee gara dunkaana sanaa dhaqu hunda sabni hundinuu kaʼee balbala dunkaana ofii isaa dura dhaabatee hamma inni dunkaanicha seenutti ilaala ture. ");
INSERT INTO gaz_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Yeroo Museen dunkaana sana seenutti utubaan duumessaa gad buʼee balbala dunkaanichaa dura dhaabata ture; Waaqayyos Musee wajjin dubbata ture. ");
INSERT INTO gaz_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Sabni yeroo utubaa duumessaa kan balbala dunkaanaa dura dhaabatu argutti hundi isaa ol kaʼee tokkoon tokkoon namaa dunkaana ofii isaa duratti sagada ture. ");
INSERT INTO gaz_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Waaqayyos akkuma nama michuu isaa wajjin haasaʼu tokkootti ifumaan ifatti Museetti dubbachaa ture. Ergasiis Museen iddoo qubataatti deebiʼa ture; gargaaraan isaa, Iyyaasuun ilmi Nuuni dargaggeessi suni garuu dunkaana sana biraa hin deemu ture. ");
INSERT INTO gaz_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Museen Waaqayyoon akkana jedhe; “Ilaa, ati, ‘saba kana dura buʼii baasi’ naan jetteerta; garuu ana wajjin eenyun akka ergitu na hin beeksifne. Ati, ‘Ani maqaadhaan si beeka; ati na biratti fudhatama argateerta’ jette. ");
INSERT INTO gaz_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ammas ani fuula kee duratti surraa argadhee yoon jiraadhe, akka ani si beekuu fi akka ani fuula kee duratti surraa argadhuuf karaa kee na barsiisi; akka sabni kun saba kee taʼes yaadadhu.” ");
INSERT INTO gaz_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Waaqayyos deebisee, “Ani si wajjin nan deema; boqonnaas siifin kenna” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Museen immoo akkana jedheen; “Yoo ati nu wajjin deemuu baate, asii nu hin baasin. ");
INSERT INTO gaz_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ati nu wajjin deemuu baannaan namni akkamiin akka ati anaa fi saba keetti gammaddu beeka? Wanni anaa fi saba kee saboota lafa irraa kaan hunda irraa addaan baasu biraa maali ree?” ");
INSERT INTO gaz_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Waaqayyo immoo Museedhaan, “Ani waan ati amma kadhatte kana nan godha; ati fuula koo duratti ayyaana argatteertaatii; anis maqaadhaan si beeka” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Museenis, “Maaloo ulfina kee na argisiisi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Waaqayyo immoo akkana jedhe; “Ani gaarummaa koo hundumaa fuula kee dura nan dabarsa; maqaa Waaqayyoo fuula kee duratti nan labsa. Ani kanan maaru nan maara; kanan garaa laafuufiis garaa nan laafa. ");
INSERT INTO gaz_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Garuu waan namni fuula koo argee jiraachuu hin dandeenyeef ati fuula koo arguu hin dandeessu.” ");
INSERT INTO gaz_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Ergasiis Waaqayyo akkana jedhe; “Kunoo as na bira iddoon ati kattaa irra dhaabachuu dandeessu jira. ");
INSERT INTO gaz_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Ani yeroo ulfinni koo darbuutti jiru holqa kattaa keessa si kaaʼee hamma ani darbutti harka kootiin si daʼeessa. ");
INSERT INTO gaz_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Ergasiis ani harka koo nan fudhadha; atis dugda koo ni argita; fuulli koo garuu argamuu hin qabu.” ");
INSERT INTO gaz_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Waaqayyo Museedhaan akkana jedhe; “Gabateewwan dhagaa lama akkuma kanneen duraa sanaatti soofi; anis dubbii gabateewwan ati caccabsite sana irra turan isaan irratti nan barreessa. ");
INSERT INTO gaz_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Atis ganamaan qophaayiitii Tulluu Siinaatti ol baʼi. Achitti, fiixee tulluu sanaa irratti fuula koo duratti of dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Namni tokko iyyuu si wajjin hin dhufin yookaan tulluu sana irratti eessumattuu hin mulʼatin. Bushaayee fi loon iyyuu fuula tulluu sanaa duratti hin bobbaʼin.” ");
INSERT INTO gaz_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Museenis gabateewwan dhagaa lama akkuma kanneen jalqabaatti soofe; innis gabateewwan lamaanis harkatti qabatee akkuma Waaqayyo isa ajajetti ganama bariin Tulluu Siinaatti ol baʼe. ");
INSERT INTO gaz_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Waaqayyo duumessaan gad buʼee isa wajjin achi dhaabate; maqaa Waaqayyoos ni labse. ");
INSERT INTO gaz_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Waaqayyo fuula Musee dura darbee akkana jedhee labse; “Waaqayyo, Waaqayyo Waaqa gara laafessaa fi arjaa, kan dafee hin aarre, kan jaalallii fi amanamummaan isaa guddaa, ");
INSERT INTO gaz_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","kan araara isaa dhaloota kumaatamaaf tursu, kan hammina, fincilaa fi cubbuu namaaf dhiisuu dha. Taʼu illee inni nama yakka hojjetu adabu malee hin dhiisu; inni hamma dhaloota sadaffaa fi afuraffaatti sababii cubbuu abbootii isaaniitiif jedhee ijoollee isaaniitii fi ijoollee ijoollee isaanii ni adaba.” ");
INSERT INTO gaz_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Museen yommuu suma lafatti gad jedhee sagade. ");
INSERT INTO gaz_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","Innis, “Yaa Gooftaa, yoo ani fuula kee duratti ayyaana argadhee jiraadhe, Gooftaan nu wajjin haa deemu. Yoo sabni kun saba mata jabeessa taʼe illee hammina keenyaa fi cubbuu keenya nuu dhiisi; dhaala kees nu godhadhu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Kana irratti Waaqayyo akkana jedhe; “Kunoo ani si wajjin kakuu nan gala. Ani fuula saba kee hundaa duratti dinqiiwwan kanaan dura saba kam iyyuu keessatti, addunyaa hunda keessatti takkumaa hin hojjetamin nan hojjedha. Sabni ati keessa jiraattus akka hojiin ani Waaqayyo siif hojjedhu hammam sodaachisaa taʼe ni arga. ");
INSERT INTO gaz_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Waan ani harʼa si ajajuuf ajajami. Anis Amoorota, Kanaʼaanota, Heetota, Feerzota, Hiiwotaa fi Yebuusota fuula kee duraa ariʼee nan baasa. ");
INSERT INTO gaz_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Akka warra biyya ati itti galuuf deemtu sana keessa jiraatan wajjin kakuu hin galleef of eeggadhu; yoo kanaa achii isaan kiyyoo sitti taʼu. ");
INSERT INTO gaz_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Iddoowwan aarsaa isaanii diigaa; siidaawwan waaqeffannaa isaanii caccabsaa; utubaawwan Aasheeraa isaaniis jijjigsaa. ");
INSERT INTO gaz_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Sababii Waaqayyo maqaan isaa Hinaafaa jedhamu sun Waaqa hinaafu taʼeef ati Waaqa biraa hin waaqeffatin. ");
INSERT INTO gaz_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","“Ati akka warra biyya sana keessa jiraatan wajjin kakuu hin galleef of eeggadhu. Sababiin isaa isaan yommuu waaqota isaanii wajjin sagaagalanii fi yommuu waaqota isaaniitiif aarsaa dhiʼeessanitti si waamu; atis aarsaa isaanii ni nyaatta. ");
INSERT INTO gaz_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Yeroo ati ilmaan kee intallan isaanii fuusiftee, intallan isaanii sun waaqota isaanii wajjin sagaagalanitti isaan akka ilmaan kees akkuma isaanii sagaagalan godhu. ");
INSERT INTO gaz_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","“Waaqota tolfamoo baqfamanii hojjetaman hin tolfatin. ");
INSERT INTO gaz_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","“Ayyaana Maxinoo ayyaaneffadhu. Ati sababii jiʼa Abiibii keessa Gibxii baateef akkuma ani si ajaje sanatti jiʼa Abiibii keessa yeroo murteeffametti bultii torba Maxinoo nyaadhu. ");
INSERT INTO gaz_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","“Kan jalqabatti gadameessa saaqee baʼu hundi kan koo ti; kormi horii keetii hangafni jechuunis kormi looniitii fi kormi hoolotaa hangafni koo ti. ");
INSERT INTO gaz_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Harree hangafa xobbaallaa hoolaatiin furi; yoo furuu baatte immoo morma isaa cabsi. Ilmaan kee hangafa hundas furi. “Namni tokko iyyuu harka duwwaa fuula koo duratti hin dhiʼaatin. ");
INSERT INTO gaz_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","“Guyyaa jaʼa hojii hojjedhu; guyyaa torbaffaatti garuu boqodhu. Yeroo qonnaatii fi yeroo midhaan galfamutti boqodhu. ");
INSERT INTO gaz_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","“Mataa qamadii jalqabaa irratti Ayyaana Torbanootaa ayyaaneffadhu; dhuma waggaa irratti immoo ayyaana galchaa midhaanii ayyaaneffadhu. ");
INSERT INTO gaz_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Dhiirri kee hundi waggaatti yeroo sadii fuula Waaqayyo Gooftaa, fuula Waaqa Israaʼel duratti haa dhiʼaatan. ");
INSERT INTO gaz_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ani Namoota Ormaa si duraa ariʼee nan baasa; daangaa kee nan balʼisa; yoo ati waggaatti yeroo sadii Waaqayyo Waaqa kee duratti dhiʼaachuu dhaqxus namni tokko iyyuu biyya kee fudhachuu hin hawwu. ");
INSERT INTO gaz_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","“Dhiiga aarsaa waan raacitii qabu wajjin naa hin dhiʼeessin; qalmi Ayyaana Faasiikaa irraa hafus hamma bariitti hin turin. ");
INSERT INTO gaz_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","“Mataa midhaan lafa keetii keessaa filatamaa isaa gara mana Waaqayyo Waaqa keetii fidi. “Ilmoo reʼee aannan haadha isheetiin hin affeelin.” ");
INSERT INTO gaz_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Waaqayyos Museedhaan, “Dubbii kana barreessi; ani akkuma dubbii kanaatti siʼii fi saba Israaʼel wajjin kakuu galeeraatii” jedhe. ");
INSERT INTO gaz_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Museenis utuu buddeena hin nyaatin yookaan utuu bishaan hin dhugin guyyaa afurtamaa fi halkan afurtama Waaqayyo bira achi ture. Innis dubbii kakuu sana jechuunis Ajajawwan Kurnan gabateewwan sana irratti barreesse. ");
INSERT INTO gaz_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Museen gabateewwan Dhuga baʼumsaa lamaan sana harkatti qabatee Tulluu Siinaa irraa gad buʼe; innis sababii Waaqayyo wajjin dubbachaa tureef akka fuulli isaa calaqqisu hin beekne ture. ");
INSERT INTO gaz_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Yommuu Aroonii fi sabni Israaʼel hundi Musee arganitti kunoo, fuulli isaa calaqqisaa ture; isaanis isatti dhiʼaachuu sodaatan. ");
INSERT INTO gaz_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Museen garuu isaan waame; Aroonii fi bulchitoonni hawaasichaa hundinuus gara isaatti deebiʼan; innis isaanitti dubbate. ");
INSERT INTO gaz_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Sabni Israaʼel hundi isatti dhiʼaate; innis waan Waaqayyo Gaara Siinaa irratti isatti dubbate hunda isaan ajaje. ");
INSERT INTO gaz_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Museen yommuu isaanitti dubbatee fixatetti fuula isaa haguuggate. ");
INSERT INTO gaz_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Yommuu Waaqayyo wajjin dubbachuudhaaf fuula isaa duratti ol seenu garuu hamma achii baʼutti haguuggii sana of irraa fuudha ture. Yommuu inni achii baʼee waan ajajame sana saba Israaʼelitti himutti, ");
INSERT INTO gaz_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","isaan akka fuulli isaa calaqqisu argan. Ergasii Museen hamma Waaqayyo wajjin dubbachuuf ol galutti fuula isaa deebisee haguuggata ture. ");
INSERT INTO gaz_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Museen waldaa Israaʼel guutuu walitti qabee akkana jedheen; “Wanni Waaqayyo akka isin hojjettan isin ajaje kana: ");
INSERT INTO gaz_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Guyyaa jaʼa hojiin haa hojjetamu; guyyaan torbaffaan garuu isiniif guyyaa qulqulluu dha; Waaqayyoof immoo sanbata boqonnaa taʼa. Namni guyyaa kana hojii hojjetu kam iyyuu haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Guyyaa Sanbataatiin lafa jiraattan kamitti iyyuu ibidda hin qabsiisinaa.” ");
INSERT INTO gaz_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Museenis waldaa Israaʼel guutuudhaan akkana jedhe; “Wanni Waaqayyo ajaje kana: ");
INSERT INTO gaz_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Waan qabdan irraa Waaqayyoof kennaa dhiʼeessaa. Namni fedhii qabu hundinuu: “kennaa warqee, meetii fi naasii Waaqayyoof haa fidu. ");
INSERT INTO gaz_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa gaarii, rifeensa reʼee, ");
INSERT INTO gaz_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","gogaa korbeessa hoolaa kan halluu diimaa cuuphamee fi gogaa duugame, muka laaftoo, ");
INSERT INTO gaz_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","ibsaadhaaf zayitii ejersaa, zayitii ittiin dibanii fi ixaana urgaaʼuuf immoo urgooftuuwwan, ");
INSERT INTO gaz_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","dhagaawwan sardooniksii, dooqa gati jabeessa, dirataa fi qomee irratti kaaʼatamu kan biraa haa fidu. ");
INSERT INTO gaz_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","“Isin keessaa namoonni ogeeyyiin hundi dhufanii waan Waaqayyo ajaje hunda haa hojjetan: ");
INSERT INTO gaz_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","“Kunis dunkaana qulqulluu dunkaana isaatii fi irra buusaa isaa wajjin, hokkoowwan isaa, tuggee isaa, dagalee isaa, utubaa isaa, miilla isaa, ");
INSERT INTO gaz_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","taabota danqaraa isaa wajjin, teessoo araaraatii fi golgaa isa dhoksus, ");
INSERT INTO gaz_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","minjaala danqaraa isaatii fi miʼa isaa hunda wajjin, buddeena ilaalchaa; ");
INSERT INTO gaz_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","baattuu ibsaa kan ifaaf taʼu miʼa isaa wajjin, ifa sanaafis ibsaa fi zayitii, ");
INSERT INTO gaz_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","iddoo aarsaa ixaanaa danqaraa isaa wajjin, zayitii ittiin dibanii fi ixaana urgaaʼu, karra ittiin dunkaana qulqulluu seenaniifis golgaa balbalaa, ");
INSERT INTO gaz_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","iddoo aarsaa kan qalma gubamuu gingilchaa isaa kan naasii irraa hojjetame wajjin, danqaraawwan isaatii fi miʼa isaa hunda, caabii naasii miilla isaa wajjin, ");
INSERT INTO gaz_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","golgaawwan oobdii utubaawwanii fi miillawwan isaanii wajjin, golgaa karra oobdii sanaa, ");
INSERT INTO gaz_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","dunkaana qulqulluu fi qofoowwan oobdii dunkaana qulqulluutii fi funyoowwan isaanii, ");
INSERT INTO gaz_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","wayyaawwan foʼamanii dhaʼaman kanneen isaan yeroo iddoo qulqulluu keessa tajaajilan uffataman jechuunis wayyaawwan Aroon lubichaaf qulqulleeffamanii fi wayyaawwan ilmaan isaa yeroo lubummaadhaan tajaajilanitti uffatan haa hojjetan.” ");
INSERT INTO gaz_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Ergasiis hawaasni Israaʼel guutuun Musee biraa baʼanii deeman; ");
INSERT INTO gaz_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","namni fedhii qabuu fi namni yaadni isaa isa kakaase hundi dhufee hojii dunkaana wal gaʼii sanaatiif, tajaajila isaa hundaa fi hojii wayyaawwan qulqulluu sanaatiif kennaa Waaqayyoof fide. ");
INSERT INTO gaz_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Dhiirrii fi dubartiin fedhii qaban hundi miʼa warqee irraa hojjetame kanneen gosa gosaa fidan; bitawoo, lootii, qubeelaa fi faaya fidan. Hundi isaanii iyyuu warqee isaanii aarsaa sochoofamu godhanii Waaqayyoof dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Namni kirrii bifa cuquliisaa, dhiilgee yookaan bildiimaa yookaan quncee talbaa baʼeessa yookaan rifeensa reʼee, kaldhee korbeessa hoolaa kan halluu diimaa cuuphamee fi gogaa duugame qabu hundi ni fide. ");
INSERT INTO gaz_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Warri kennaa meetii yookaan naasii dhiʼeessan kennaa Waaqayyoof dhiʼeeffamu godhanii fidan. Namni muka laaftoo kan qooda hojii sanaa kamiif iyyuu taʼu qabu hundas ni fide. ");
INSERT INTO gaz_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Dubartoonni ogeeyyiin hundis harkaan foʼanii kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa baʼeessa foʼan sana fidan. ");
INSERT INTO gaz_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Dubartoonni fedhii fi ogummaa qaban hundinuus rifeensa reʼee foʼan. ");
INSERT INTO gaz_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Bulchitoonni dhagaawwan sardooniksii fi dhagaawwan gati jabeeyyii biraa dirataa fi kiisii qomaatti akka kaaʼatamuuf fidan. ");
INSERT INTO gaz_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Akkasumas urgooftuu fi zayitii ibsaadhaaf, zayitii ittiin dibanii fi ixaana urgaaʼus fidan. ");
INSERT INTO gaz_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Dhiironnii fi dubartoonni Israaʼel warri fedhii qaban hundi hojii akka isaan hojjetaniif Waaqayyo karaa Museetiin isaan ajaje sana hundaaf fedhii isaaniitiin Waaqayyoof kennaa fidan. ");
INSERT INTO gaz_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Yommus Museen saba Israaʼeliin akkana jedhe; “Ilaa Waaqayyo gosa Yihuudaa keessaa Bezaliʼeel ilma Uuri ilma Huuri filateera; ");
INSERT INTO gaz_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","Hafuura Waaqaatiin, ogummaadhaan, dandeettii fi beekumsa hojii harkaa gosa hundumaan isa guuteera. ");
INSERT INTO gaz_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Kunis akka inni warqeedhaan, meetii fi naasiidhaan hojii ogummaa hojjetuuf, ");
INSERT INTO gaz_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","akka dhagaawwan muree qopheessuuf, akka muka soofuu fi akka hojii ogummaa harkaa kan gosa hundaa keessatti hirmaatuuf. ");
INSERT INTO gaz_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Waaqnis Bezaliʼeelii fi Oholiiyaab ilma Ahiisaamaak kan gosa Daan sanaaf dandeettii isaan ittiin warra kaan barsiisan kenne. ");
INSERT INTO gaz_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Akka isaan ogeeyyii hojii harkaa, bifa baastotaa fi warra kirrii bifa cuquliisaatiin, dhiilgeen, bildiimaa fi quncee talbaa baʼeessaan miidhagsanii fi wayyaa dhooftota hundi isaanii ogeeyyii hojii harkaatii fi bifa baastota taʼaniif ogummaa hojii gosa hundaa hojjechuutiin isaan guute. ");
INSERT INTO gaz_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","Bezaliʼeel, Oholiiyaabii fi namni Waaqayyo ogummaa fi dandeettii isaan ittiin hojii ijaarsa iddoo qulqulluu sanaa hunda beekan kenneef hundi akkuma Waaqayyo ajajetti hojii kana haa hojjetan.” ");
INSERT INTO gaz_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Museen Bezaliʼeel, Oholiiyaabii fi ogeessa Waaqayyo dandeettii kenneef kan dhufee hojii sana hojjechuuf fedhii qabu hunda waame. ");
INSERT INTO gaz_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Isaanis kennaawwan Israaʼeloonni ijaarsa iddoo qulqulluu sanaatiif jedhanii fidan hunda Musee harkaa fuudhan. Namoonni Israaʼelis fedhii isaaniitiin ganama ganama kennaa isaanii fiduu itti fufan. ");
INSERT INTO gaz_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Ogeeyyiin hojii harkaa kanneen iddoo qulqulluu sana hojjetan hundi hojii isaanii dhiisanii dhufanii ");
INSERT INTO gaz_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Museedhaan, “Sabni kun waan hojii Waaqayyo akka hojjetamuuf ajaje sanaaf barbaachisu caalaa fidaa jira” jedhan. ");
INSERT INTO gaz_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Museenis ajaja kenne; isaanis, “Dhiirri yookaan dubartiin tokko iyyuu waan biraa tokko illee kennaa godhee iddoo qulqulluu sanaaf hin dhiʼeessin” jedhanii iddoo qubataa sana keessatti labsan. Kanaafuu namoonni itti fufanii waa fiduu dhowwaman. ");
INSERT INTO gaz_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Wanti isaan duraanuu qaban hojii hunda hojjechuuf gaʼaa fi irraa hafaa tureetii. ");
INSERT INTO gaz_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Hojjettoota sana keessaas ogeeyyiin hundi golgaawwan kudhan kanneen quncee talbaa gaarii foʼamee fi kan kirrii bifa cuquliisaa, dhiilgee fi bildiimaa irraa hojjetamaniin dunkaana qulqulluu haa hojjetan; golgaawwan sana irrattis ogeeyyiin harka qajeelan kiirubeelii hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Golgaawwan sun hundinuu wal qixxee taʼanii tokkoon tokkoon isaanii dheerina dhundhuma digdamii saddeetiitii fi balʼina dhundhuma afur qabu ture. ");
INSERT INTO gaz_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Isaanis golgaawwan shan walitti qabsiisan; shanan kaan illee akkasuma walitti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Isaanis golgaawwan walitti qabsiifaman kanneen jalqabaa keessaa handaara isa moggaa irratti huccuu bifa cuquliisaa irraa gurroowwan tolchan; golgaawwan walitti qabsiifaman lammaffaa irrattis akkasuma tolfaman. ");
INSERT INTO gaz_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Isaanis golgaa tokko irratti gurroowwan shantama tolchan; gurroowwan shantama immoo golgaawwan walitti qabsiifaman lammaffaa keessaa isa moggaa irratti tolchan; gurroowwan sunis gamaa gamanaan turan. ");
INSERT INTO gaz_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Akka dunkaanni qulqulluun sun tokko taʼuufis hokkoowwan warqee shantama tolchanii golgaawwan sana ittiin walitti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Isaanis haguuggii gubbaa dunkaana qulqulluu sanaa irra jiru haguuguuf golgaawwan rifeensa reʼee kudha tokko hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Golgaawwan kudha tokkoon sun hundi wal qixxee turan; dheerinni isaanii dhundhuma soddoma, balʼinni isaanii immoo dhundhuma afur ture. ");
INSERT INTO gaz_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Isaanis golgaawwan shan iddoo tokkotti walitti qabsiisan; golgaawwan kaan jaʼaan immoo iddoo tokkotti walitti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Ergasiis golgaawwan gama tokkoon walitti qabsiifaman keessaa handaara isa moggaa irratti gurroowwan shantama tolchan; golgaawwan gama kaan irratti walitti qabsiifaman keessaas handaara isa moggaa irratti gurroowwan shantama tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Akka dunkaanni sun tokko taʼuuf ittiin walitti qabsiisuuf qabduuwwan naasii shantama tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Dunkaana sanaafis irra buusaa kaldhee korbeessa hoolaa kan halluu diimaa cuuphame, isa irraan immoo irra buusaa gogaa duugamee hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Dunkaana qulqulluu sanaafis muka laaftoo irraa tuggeewwan qaqqajeeloo hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dheerinni tokkoo tokkoo tuggeewwan sanaas dhundhuma kudhan, balʼinni isaa immoo dhundhuma tokkoo fi walakkaa ture. ");
INSERT INTO gaz_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Tokkoon tokkoon tuggeewwan sanaas akka wal keessa galuu dandaʼuuf mucha lama lama qaba ture. Tuggeewwan dunkaana qulqulluu sanaa hunda akkasitti tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Gama kibba dunkaana qulqulluu sanaatiifis tuggeewwan digdama hojjetan; ");
INSERT INTO gaz_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","tuggeewwan digdamman sana jalatti miilla meetii afurtama jechuunis tuggee tokko jalatti miilla lama gurra isaa lamaaniif, tuggee kaan jalattis miilla lama gurra isaa lamaaniif tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Gama dunkaana qulqulluu sanaa kaaniifis karaa kaabaatiin tuggeewwan digdama tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Isaaniifis miilla meetiis afurtama jechuunis tuggee tokko jalatti miilla lama, tuggee kaan jalattis miilla lama tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Karaa lixa biiftuutiin, dugda duuba dunkaana qulqulluu sanaatiif tuggee jaʼa hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Karaa dugda duubaas golee dunkaana qulqulluu sanaatiif utubaa lama tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Tuggeewwan golee kunneen jalaa hamma gubbaatti walitti fayyifamanii bantii irratti qubeelaa tokkoon walitti qabsiifaman; tuggeewwan golee lamaaniis akkanuma hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Kanaafuu tuggeewwan saddeeti kanneen miilla meetii kudha jaʼa qabanitu ture; tokkoon tokkoon tuggee sanaas miilla lama lama qaba ture. ");
INSERT INTO gaz_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Akkasumas muka laaftoo irraa dagaleewwan tolchan; tuggeewwan dunkaana qulqulluu sana irra gama tokkoon jiraniif dagaleewwan shan, ");
INSERT INTO gaz_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","tuggeewwan gama kaaniin jiraniif shan, tuggeewwan dugda duubaan karaa lixa biiftuutiin jiraniif immoo dagaleewwan shan tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Dagalee walakkaa jiru sana akka inni gidduu tuggeewwaniitiin moggaa tokkoo hamma moggaa kaaniitti fullaʼu godhan. ");
INSERT INTO gaz_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Tuggeewwan sanaattis warqee dibanii akka dagaleewwan baataniif qubeelaawwan warqee itti tolchan. Dagaleewwan sanaattis akkasuma warqee uffisan. ");
INSERT INTO gaz_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Isaanis kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa haphii irraa golgaa tolchan; golgaa kana irrattis ogeessi harka qajeelu tokko fakkii kiirubeelii tolche. ");
INSERT INTO gaz_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Golgaa sanaafis utubaawwan muka laaftoo afur tolchanii warqee itti uffisan; utubaa sanaafis hokkoowwan warqee hojjetanii miilla meetii afur itti tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Isaanis balbala dunkaanichaatiif golgaa kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼamee harkaan irratti hodhame tokko faayessanii tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Isaanis utuboota hokkoo qaban shan hojjetanii, fiixee fi somaawwan utubootaatti warqee uffisan; miilla isaanii shananis naasii irraa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bezaliʼeel muka laaftoo irraa taabota tolche; taabonni sunis dhundhuma lamaa fi walakkaa dheerata; dhundhuma tokkoo fi walakkaa balʼata; dhundhuma tokkoo fi walakkaa ol dheerata ture. ");
INSERT INTO gaz_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Innis keessaa fi duuba isaatti warqee qulqulluu uffise; naannoo isaattis marsaa faaya warqee naannessee tolche. ");
INSERT INTO gaz_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Qubeelaa warqee afur tolcheefii miilla isaa afranitti qabsiise; qubeelaa lama gama tokkoon, qubeelaa kaan immoo gama kaaniin itti kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Ergasiis muka laaftoo irraa danqaraawwan tolchee warqee itti uffise. ");
INSERT INTO gaz_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Innis taabota sana ittiin baachuudhaaf danqaraawwan sana qubeelaawwan keessa loose. ");
INSERT INTO gaz_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Innis warqee qulqulluu irraa teessoo araaraa tolche; teessoon sunis dheerina dhundhuma lamaa fi walakkaa fi balʼina dhundhuma tokkoo fi walakkaa qaba ture. ");
INSERT INTO gaz_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Moggaa lamaan teessoo araaraa irratti warqee tumame irraa Kiirubeelii lama tolche. ");
INSERT INTO gaz_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Innis Kiirubii tokko moggaa tokko irratti, Kiirubii lammaffaa moggaa kaan irratti tolche; kiirubeelii lamaan sana moggaa teessoo araaraa lamaan irratti teessoo araaraa wajjin mukuma tokko irraa tolche. ");
INSERT INTO gaz_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Kiirubeeliin sun qoochoo isaanii ol balʼifatanii teessoo araaraa sanatti gaaddiseessu turan. Kiirubeeliin kunneen fuula isaanii walitti garagalfatanii gara teessoo araaraa ilaalu turan. ");
INSERT INTO gaz_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Isaanis muka laaftoo irraa minjaala dalga dheerinni isaa dhundhuma lama, balʼinni isaa dhundhuma tokko, ol dheerinni isaa dhundhuma tokkoo fi walakkaa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Isaanis warqee qulqulluu itti uffisanii naannoo isaatti marsaa warqee tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Naannoo isaa irrattis hidhii hamma balʼina harkaa gaʼuu fi faaya warqee tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Isaanis qubeelaa warqee afur minjaala sanaaf hojjetanii iddoo miilli afran turetti goleewwan afranitti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Qubeelaawwan sunis akka danqaraa minjaalli sun ittiin baatamu qabaniif xiyyoo sanatti dhiʼeeffamanii kaaʼaman. ");
INSERT INTO gaz_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Danqaraawwan minjaalli ittiin baatamu sun muka laaftoo irraa hojjetamanii warqeen itti uffifamee ture. ");
INSERT INTO gaz_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Miʼoota minjaala sana irra kaaʼaman jechuunis caabiiwwan isaa, waciitiiwwan isaa, waciitiiwwan isaatii fi okkoteewwan isaa kanneen ittiin dhibaayyuu dhibaafatan warqee qulqulluu irraa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Baattuu ibsaa, somaa isaatii fi damee isaa wajjin warqee qulqulluu irraa tumanii tolchan; waciitii isaa, hudhaa isaatii fi daraaraa isaa illee warqeedhuma tokko irraa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Bitaa mirga baattuu ibsaa sana keessaas dameewwan jaʼa jechuunis sadii gama tokkoon sadii immoo gama kaaniin baafaman. ");
INSERT INTO gaz_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Xoofoowwan lawuzii fakkaatan kanneen tokkoon tokkoon isaanii hudhaa fi daraaraa qaban sadii damee tokko irratti, waciitiiwwan lawuzii fakkaatan kanneen tokkoon tokkoon isaanii hudhaa fi daraaraa qaban sadii immoo damee kaan irratti tolchan. Dameewwan jaʼaan baattuu ibsaa irraa babbaʼan hunda irrattis akkasuma tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Xoofoowwan hudhaa fi daraaraa qaban kanneen bifa lawuziitiin tolfaman afur baattuu ibsaa sana irra turan. ");
INSERT INTO gaz_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Hudhaan tokko cimdii jalqabaa kan dameewwan baattuu ibsaa irraa babbaʼan jala, hudhaan lammaffaan cimdii lammaffaa jala, hudhaan sadaffaan immoo cimdii sadaffaa jala ture; walumaa galatti dameewwan jaʼatu ture. ");
INSERT INTO gaz_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Hudhaawwanii fi dameewwan hundinuu baattuu ibsaa sana wajjin warqeedhuma qulqulluu tumame tokko irraa tolfaman. ");
INSERT INTO gaz_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Ibsaa torban sana, waan ittiin daaraa isaa dhadhaʼanii fi baattuu daaraa sana baattu illee warqee qulqulluu irraa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Baattuu ibsaatii fi miʼa isaa hunda warqee qulqulluu taalaantii tokko irraa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Isaanis muka laaftoo irraa iddoo aarsaa ixaanaa tolchan; iddoon aarsaa kunis dalga dheerina dhundhuma tokko, balʼina dhundhuma tokkoo fi ol dheerina dhundhuma lamaa qabaatee gama afraniinuu wal qixxee ture. Gaanfawwan isaas iddoo aarsaa sanaan walumatti hojjetaman. ");
INSERT INTO gaz_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Isaanis gubbaa isaa irra, cinaacha isaa hundumaa fi gaanfawwan isaatti warqee qulqulluu uffisanii naannoo isaatti marsaa warqee naannessanii tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Iddoo aarsaa sanaafis marsaawwan warqee isaatii gaditti qubeelaawwan warqee lama tolchan; qubeelaawwan kanas akka isaan danqaraawwan ittiin iddoo aarsaa baatan qabataniif gamaa gamanaan cinaacha lamaanitti tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Isaanis danqaraawwan muka laaftoo tolchanii warqee itti uffisan. ");
INSERT INTO gaz_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Akkasumas akkuma ogeessa urgooftuu qopheessu tokkootti zayitii ittiin diban qulqulluu fi ixaana urgaaʼaa makaa hin qabne tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Isaanis muka laaftoo irraa iddoo aarsaa qalma gubamuu kan dhundhuma sadii ol dheeratu ijaaran; iddoon aarsaa kunis dheerina dhundhuma shanii fi balʼina dhundhuma shanii qabaatee gama afraniinuu wal qixxee ture. ");
INSERT INTO gaz_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Tokkoo tokkoo goleewwan afraniitti gaanfa tolchan; gaanfaa fi iddoo aarsaa sana mukuma tokko irraa tolchan; iddoo aarsaa sana irrattis naasii uffisan. ");
INSERT INTO gaz_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Isaanis miʼa isaa hunda jechuunis waan ittiin daaraa haran, waan ittiin daaraa hammaaran, waciitii, hokkoo fooniitii fi baattuu ibiddaa naasii irraa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Iddoo aarsaa sanaafis naasii wal keessa xaxameen gingilchaa hojjetanii akka inni hamma walakkaa iddoo aarsaatti ol baʼee marsaa isaa jalaan jiraatu godhan. ");
INSERT INTO gaz_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Akka isaan danqaraawwan qabataniifis goleewwan gingilchaa naasii sanaa afraniif qubeelaawwan naasii hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Danqaraawwan muka laaftoos tolchanii naasii itti uffisan. ");
INSERT INTO gaz_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Iddoo aarsaa sana ittiin baachuufis danqaraawwan sana qubeelaawwan gamaa gamanaan iddoo aarsaa irra jiran keessa galchan. Iddoo aarsaa sanas keessa isaa duwwaa godhanii saanqaa irraa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Isaanis gabatee itti dhiqatan kan naasii miilla isaa kan naasii irraa hojjetame wajjin of ilaaleewwan dubartoota balbala dunkaana wal gaʼii dura tajaajilanii irraa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Kanatti aansanii oobdii tolchan. Oobdichis gama kibbaatiin dhundhuma dhibba tokko dheeratee golgaa quncee talbaa kan qalʼifamee foʼame irraa hojjetames qaba ture; ");
INSERT INTO gaz_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","utubaawwan digdamaa fi miilla naasii digdama qaba ture; utubaawwan kunneenis hokkoowwanii fi somaawwan meetii irraa hojjetaman qabu ture. ");
INSERT INTO gaz_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Gama kaabaatiinis akkasuma dhundhuma dhibba tokko dheeratee utubaawwan digdamaa fi miilla naasii digdama qaba ture; utubaawwan sunis hokkoowwanii fi somaawwan meetii irraa tolfaman qabu turan. ");
INSERT INTO gaz_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Gama lixaatiin dhundhuma shantama balʼatee golgaawwan utubaa kudhanii fi miilla kudhan qaba ture; hokkoowwanii fi somaawwan utuboota sanaas meetii irraa hojjetaman. ");
INSERT INTO gaz_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Fiixee baʼaatiin, karaa baʼa biiftuutiin dhundhuma shantama balʼata ture. ");
INSERT INTO gaz_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Golgaawwan dhundhuma kudha shan dhedheeratanii utubaa sadii fi miilla sadii qabanis karaa balbala tokkoo irra turan. ");
INSERT INTO gaz_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Golgaawwan dhundhuma kudha shan dhedheeratanii utubaa sadii fi miilla sadii qabanis balbala oobdii sana irra gama kaaniin turan. ");
INSERT INTO gaz_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Golgaawwan naannoo oobdii sanaa hundi quncee talbaa kan qaldhifamee foʼame irraa tolfaman. ");
INSERT INTO gaz_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Miillawwan utuboota sanaa naasii irraa tolfaman. Hokkoowwanii fi somaawwan utubootaa immoo meetii irraa tolfamanii fiixee utuboota sanaatti meetii uffisan. Utuboonni oobdii sanaa hundinuus somaawwan meetii qabu turan. ");
INSERT INTO gaz_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Golgaan balbala oobdii sanaa kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen dhaʼamee irratti faayeffamee hojjetame tolfame. Innis dhundhuma digdama dalga dheeratee akkuma oobdichaa dhundhuma shan ol dheerata ture; ");
INSERT INTO gaz_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","utubaa afurii fi miilla naasii afuris qaba ture. Hokkoowwanii fi somaawwan isaanii meetii irraa tolfamanii fiixee isaaniitti meetiin uffifamee ture. ");
INSERT INTO gaz_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Qofoon dunkaana qulqulluutii fi qofoon naannoo oobdii sanaa hundi naasii irraa tolfaman. ");
INSERT INTO gaz_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Baayʼinni miʼa dunkaanni qulqulluun jechuunis dunkaanni dhuga baʼumsaa ittiin hojjetamee kan Lewwonni ajaja Museetiin qajeelfama Iitaamaar ilma Aroon lubichaatiin galmeessan kanaa dha. ");
INSERT INTO gaz_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Bezaliʼeel ilmi Uuri jechuunis ilmi ilma Huur namichi gosa Yihuudaa sun waan Waaqayyo Musee ajaje hunda hojjete. ");
INSERT INTO gaz_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Oholiiyaab ilmi Ahiisaamaak namichi gosa Daan sunis isa wajjin ture; innis ogeessa hojii harkaa, ogeessa bifa baasuu fi kan kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen waa faayessu ture. ");
INSERT INTO gaz_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Baayʼinni warqee aarsaa sochoofamuu kan hojii iddoo qulqulluu sanaa hunda irra oole walumaa galatti akka madaalii saqilii iddoo qulqulluutti taalaantii 29 fi saqilii 730 ture. ");
INSERT INTO gaz_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Meetiin namoota waldaa keessaa lakkaaʼaman irraa argames akka madaalii saqilii iddoo qulqulluutti taalaantii 100 fi saqilii 1,775 ture. ");
INSERT INTO gaz_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Namoonni warra duraan lakkaaʼamanii jiranitti dabalaman kanneen umuriin isaanii waggaa digdama yookaan hammanaa ol taʼe 603,550 turan. Isaan kunneenis akka madaalii iddoo qulqulluutti matuma mataan beekaa tokko tokko jechuun walakkaa saqilii tokko tokkoo baasan. ");
INSERT INTO gaz_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Meetii taalaantii 100 sanaan miillawwan iddoo qulqulluutii fi miillawwan golgaatu hojjetame; taalaantii 100 fi miilla 100 hojjetame; miilla tokkoof taalaantii tokkotu barbaachise jechuu dha. ");
INSERT INTO gaz_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Isaanis saqilii 1,775 sana hokkoo utubaawwanii tolchuuf, fiixee utubaawwaniitti uffisuu fi somaawwan isaanii tolchuuf itti fayyadaman. ");
INSERT INTO gaz_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Naasiin aarsaa sochoofamuus taalaantii 70 fi saqilii 2,400 ture. ");
INSERT INTO gaz_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Isas miilla balbala dunkaana wal gaʼii, iddoo aarsaa kan naasii irraa hojjetame, gingilchaa isaa kan naasii irraa hojjetamee fi miʼa isaa hunda tolchuuf itti fayyadaman; ");
INSERT INTO gaz_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","akkasumas miilli naannoo oobdii, miilli balbala oobdii, qofoowwan dunkaana qulqulluu hundii fi qofoowwan naannoo oobdii hundi naasii irraa hojjetaman. ");
INSERT INTO gaz_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Isaanis uffata kirrii bifa cuquliisaa, dhiilgee fi bildiimaan dhaʼame kan iddoo qulqulluu keessa tajaajiluuf fayyadu hojjetan. Akkuma Waaqayyo Musee ajajettis uffata qulqulluu Arooniif hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Isaanis warqee fi kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen dirata hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Isaanis kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa qalʼaa isaa tolchuuf jedhanii warqee sana ogummaa harkaatiin tumanii akka baalaatti haphisanii foʼaa foʼaatti gargar kukkutan. ");
INSERT INTO gaz_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Isaanis akka inni walitti guduunfamuu dandaʼuuf funyoo gatiittii kan golee isaa lamaanitti hidhamee ture dirata sanaaf tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Sabbanni isaa kan ogummaadhaan dhaʼames akkuma isaa dirata wajjin tokko taʼee warqeedhaan, kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen akkuma Waaqayyo Musee ajajetti hojjetame. ");
INSERT INTO gaz_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Isaanis dhagaawwan sardooniksii qopheessanii marsaa faaya warqee naannoo isaatti tolchan; maqaa ilmaan Israaʼelis akka chaappaatti isaan irratti soofan. ");
INSERT INTO gaz_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Ergasiis akka ilmaan Israaʼeliif dhagaa yaadannoo taʼuuf akkuma Waaqayyo Musee ajajetti dhagaawwan sana funyoo gatiittii dirata sanatti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Isaanis akkuma dirata sanaatti warqeedhaan, kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen ogummaadhaan kiisii qomaa tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kiisiin qomaa kun gama afraniinuu wal qixxee ture; innis walitti dachaa taʼee dheerina taakkuu tokkoo fi balʼina taakkuu tokkoo qaba ture. ");
INSERT INTO gaz_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Dhagaawwan gati jabeeyyiis toora afuriin irratti maxxansan. Toora jalqabaa irratti sardiyoon, tophaaziyoonii fi biiralee, ");
INSERT INTO gaz_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","toora lammaffaa irratti baluur, sanpeerii fi almaaz, ");
INSERT INTO gaz_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","toora sadaffaa irratti yaakinti, kelqedoonii fi yaakinti, ");
INSERT INTO gaz_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","toora afuraffaa irratti biiralee, sardooniksii fi yaasphiidi maxxansan. Dhagaawwan kanneenittis marsaa faaya warqee tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Dhagaawwan kudha lama kanneen tokkoo tokkoo isaanii irratti maqaa gosoota kudha lama keessaa maqaan tokko akkuma chaappaatti soofame ni turan; tokkoon tokkoon dhagaawwan sanaas maqaa ilmaan Israaʼel tokko tokkoof dhaabate. ");
INSERT INTO gaz_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Kiisii qomaatiifis foncaa warqee qulqulluu akka funyootti foʼanii tolchan. ");
INSERT INTO gaz_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Isaanis marsaa faaya warqee lamaa fi qubeelaa warqee lama tolchanii qubeelaawwan sana rogawwan kiisii qomaa keessaa lamatti guduunfan. ");
INSERT INTO gaz_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Foncaa warqee sana lamaanis qubeelaawwan rogawwan kiisii qomaa sanatti guduunfan. ");
INSERT INTO gaz_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Mataa lamaan foncaa lamaan sanaa kaan immoo marsaawwan faayaa lamaanitti guduunfanii karaa fuula duraatiin foncaa dirataa kan gatiittiitti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Qubeelaawwan warqee lama tolchanii rogawwan kiisii qomaa biraa kanneen karaa moggaa keessaatiin diratatti aananii jiran lamaanitti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Ergasiis qubeelaawwan warqee lama biraa tolchanii sabbata mudhiitii olitti garjalee funyoo gatiittii lamaan, fuula dirataa duraan jiru sanaatti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Isaanis akka kiisiin qomaa dirata irraa hin sosochooneef qubeelaawwan kiisii qomaa sana sabbata mudhiitiin walitti qabsiisanii akkuma Waaqayyo Musee ajajetti funyoo bifa cuquliisaatiin qubeelaawwan diratatti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Isaanis huccuu guutumaan guutuutti bifti isaa cuquliisa taʼe irraa wandaboo dirataa tolchan; ");
INSERT INTO gaz_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","walakkaa gubbaa wandaboo sanaattis afaan ittiin mataa seensifatan tolchan; akka inni hin tarsaaneefis qarqara afaan isaa irra waa naannessanii hodhan. ");
INSERT INTO gaz_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Isaanis xiyyoo wandaboo sanaatti kirrii bifa cuquliisaa, dhiilgee, bildiimaa fi quncee talbaa kan qalʼifamee foʼameen roomaanii hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Warqee qulqulluu irraas bilbila hojjetanii roomaanota gidduudhaan naannoo xiyyoo wandabootti qabsiisan. ");
INSERT INTO gaz_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Bilbillii fi roomaaniin sun akkuma Waaqayyo Musee ajajetti tokko tokkoon wal keessa makamanii naannoo xiyyoo wandaboo tajaajilaaf uffatamu sanaatti qabsiifaman. ");
INSERT INTO gaz_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Aroonii fi ilmaan isaatiif immoo kittaa quncee talbaa kan qalʼifamee foʼameen dhoofsisanii hojjetan; ");
INSERT INTO gaz_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","akkasumas quncee talbaa qalʼaa isaatiin marata mataa, quncee talbaatiin gonfoo, quncee talbaa kan qalʼifamee foʼameen immoo uffata wayyaa jalaa hojjetaniif. ");
INSERT INTO gaz_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Sabbannis quncee talbaa kan qalʼifamee foʼamee fi kirrii bifa cuquliisaa, dhiilgee fi bildiimaan faayeffame akkuma Waaqayyo Musee ajajetti hojjetame. ");
INSERT INTO gaz_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Isaanis warqee qulqulluu irraa faaya gonfoo qulqulluu tolchanii akkuma waan chaappaa irratti qirixamuutti: Kan Waaqayyoof Qulqulleeffame, jedhanii irratti barreessan. ");
INSERT INTO gaz_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Ergasiis faaya sana marata mataatiin wal qabsiisuuf jedhanii akkuma Waaqayyo Musee ajajetti funyoo bifa cuquliisaa itti hidhan. ");
INSERT INTO gaz_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Akkasiin hojiin dunkaana qulqulluu kan dunkaana wal gaʼii hundi xumurame. Israaʼeloonnis akkuma Waaqayyo Musee ajajetti waan hunda hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Isaanis dunkaana qulqulluu sana Museetti fidan: dunkaanaa fi miʼa isaa hunda, hokkoowwan isaa, tuggeewwan isaa, dagaleewwan isaa, utuboota isaatii fi miillawwan isaa; ");
INSERT INTO gaz_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","irra buusa kalʼee korbeessa hoolaa kan halluu diimaa cuuphame, irra buusa gogaa duugameetii fi golgaa daʼeessu; ");
INSERT INTO gaz_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","taabota kakuu seeraa, danqaraa isaatii fi teessoo araaraa wajjin; ");
INSERT INTO gaz_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","minjaala miʼa isaa hundaa fi buddeena ilaalchaa wajjin; ");
INSERT INTO gaz_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","baattuu ibsaa kan warqee qulqulluu irraa hojjetame, ibsaawwan tarree galanii fi miʼa isaa hunda wajjin, zayitii ibsaa; ");
INSERT INTO gaz_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","iddoo aarsaa kan warqee irraa hojjetame, zayitii ittiin diban, ixaana urgaaʼu, golgaa balbala dunkaanaa; ");
INSERT INTO gaz_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","iddoo aarsaa kan naasii irraa hojjetame, gingilchaa isaa kan naasii irraa hojjetame wajjin, danqaraawwan isaatii fi miʼa isaa hunda, caabii miilla isaa wajjin; ");
INSERT INTO gaz_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","golgaawwan oobdii utubaawwanii fi miillawwan isaanii wajjin, golgaa karra oobdii sanaa, funyoowwanii fi qofoowwan oobdii, miʼa dunkaana qulqulluu kan dunkaana wal gaʼii hunda; ");
INSERT INTO gaz_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","wayyaawwan foʼamanii dhaʼaman kanneen yeroo iddoo qulqulluu keessa tajaajilan uffataman, jechuunis wayyaawwan Aroon lubichaaf qulqulleeffamanii fi wayyaawwan ilmaan isaa yeroo lubummaadhaan tajaajilanitti uffatan feʼa. ");
INSERT INTO gaz_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Israaʼeloonnis akkuma Waaqayyo Musee ajajetti hojii hunda hojjetan. ");
INSERT INTO gaz_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Museenis hojii sana toʼatee akkuma Waaqayyo ajajetti hojjechuu isaanii arge. Museenis isaan eebbise. ");
INSERT INTO gaz_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Waaqayyo Museedhaan akkana jedhe: ");
INSERT INTO gaz_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","“Guyyaa jalqaba jiʼa jalqabaatti dunkaana qulqulluu jechuunis dunkaana wal gaʼii dhaabi. ");
INSERT INTO gaz_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Taabota kakuu seeraa isa keessa kaaʼiitii taaboticha golgaadhaan daʼeessi. ");
INSERT INTO gaz_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Minjaala ol galchiitii miʼa isaa tottolchi. Ergasiis baattuu ibsaa ol galchiitii ibsaa isaa irra dhaabi. ");
INSERT INTO gaz_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Iddoo aarsaa ixaanaa kan warqee irraa hojjetame fuula taabota kakuu seeraa dura dhaabiitii balbala dunkaana qulqulluutti immoo golgaa fannisi. ");
INSERT INTO gaz_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","“Iddoo aarsaa qalma gubamuu sanas fuula balbala dunkaana qulqulluu jechuunis dunkaana wal gaʼii dura dhaabi; ");
INSERT INTO gaz_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","gabatee itti dhiqatanis dunkaana wal gaʼiitii fi iddoo aarsaa gidduu dhaabiitii bishaan itti naqi. ");
INSERT INTO gaz_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Naannoo isaattis oobdii hojjedhuutii balbala isaatti golgaa kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","“Zayitii ittiin diban fuudhiitii dunkaana qulqulluu fi waan isa keessa jiru hunda dibi; dunkaanichaa fi miʼa isaa hunda qulqulleessi; innis ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Ergasiis iddoo aarsaa qalma gubamuutii fi miʼa isaa hunda dibi; iddoo aarsaa sana qulqulleessi; innis waan hunda caalaa qulqullaaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Gabatee itti dhiqatanii fi miilla isaa dibiitii isaan qulqulleessi. ");
INSERT INTO gaz_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","“Aroonii fi ilmaan isaa gara balbala dunkaana wal gaʼiitti fidiitii bishaaniin isaan dhiqi. ");
INSERT INTO gaz_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Ergasii Aroonitti wayyaa qulqulluu uffisi; akka inni lubummaadhaan na tajaajiluufis dibiitii isa qulqulleessi. ");
INSERT INTO gaz_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ilmaan isaas fidiitii kittaa itti uffisi. ");
INSERT INTO gaz_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Akka isaan lubummaadhaan na tajaajilaniifis akkuma abbaa isaanii dibde sanatti isaan dibi; dibamuun isaanii kunis dhaloota dhufu hunda keessatti lubummaa itti fufu taʼa.” ");
INSERT INTO gaz_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Museenis akkuma Waaqayyo isa ajajetti waan hunda hojjete. ");
INSERT INTO gaz_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Kanaafuu dunkaanni qulqulluun sun waggaa lamaffaa keessa guyyaa jalqabaa kan jiʼa jalqabaatti dhaabame. ");
INSERT INTO gaz_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Museen yeroo dunkaana qulqulluu sana dhaabetti miillawwan dunkaanichaa itti kaaʼe; tuggeewwan isaa dhadhaabe; dagaleewwan isaa loose; utuboota isaa dhadhaabe. ");
INSERT INTO gaz_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Innis akkuma Waaqayyo isa ajajetti dunkaana qulqulluu irraan dunkaana diriirsee dunkaana sanatti immoo irra buusa uffise. ");
INSERT INTO gaz_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Dhuga baʼumsa sana fuudhee taabota keessa kaaʼe; danqaraawwanis taabotatti hidhe; teessoo araaraa immoo taabota gubbaa kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Museen akkuma Waaqayyo isa ajajetti taabota sana dunkaana qulqulluutti ol galchee golgaa daʼeessu fanniseef; taabota kakuu seeraa sanas daʼeesse. ");
INSERT INTO gaz_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Museenis minjaala sana gama kaaba dunkaana qulqulluutiin dunkaana wal gaʼii keessa golgaa sanaan ala kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Akkuma Waaqayyo isa ajajettis fuula Waaqayyoo duratti buddeena achi irra kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Baattuu ibsaa immoo gama kibbaa dunkaana qulqulluutiin dunkaana wal gaʼii keessa fuullee minjaalaatiin kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","Akkuma Waaqayyo isa ajajettis ibsaawwan sana fuula Waaqayyoo dura dhadhaabe. ");
INSERT INTO gaz_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Museenis iddoo aarsaa kan warqee irraa hojjetame sana fuula golgaa duraan dunkaana wal gaʼii keessa dhaabe. ");
INSERT INTO gaz_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","Akkuma Waaqayyo isa ajajettis ixaana urgaaʼaa isa irratti aarse. ");
INSERT INTO gaz_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Balbala dunkaana qulqulluu irrattis golgaa fannise. ");
INSERT INTO gaz_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Inni akkuma Waaqayyo isa ajajetti iddoo aarsaa qalma gubamuu sana balbala dunkaana qulqulluu kan dunkaana wal gaʼii bira dhaabee qalma gubamuu fi kennaa midhaanii isa irratti dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Gabatee sanas dunkaana wal gaʼiitii fi iddoo aarsaa gidduu kaaʼee bishaan dhiqataa itti naqe; ");
INSERT INTO gaz_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Museen, Aroonii fi ilmaan Arooniis harka isaaniitii fi miilla isaanii dhiqachuuf itti fayyadamu turan. ");
INSERT INTO gaz_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Isaanis akkuma Waaqayyo Musee ajajetti yeroo dunkaana wal gaʼii seenan yookaan yeroo iddoo aarsaatti dhiʼaatan hunda ni dhiqatu turan. ");
INSERT INTO gaz_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Museenis naannoo dunkaana qulqulluutii fi iddoo aarsaatti oobdii hojjetee balbala waltajjichaa irra golgaa dhaabe; akkasiin Museen hojii sana hojjetee fixe. ");
INSERT INTO gaz_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Ergasiis duumessi dunkaana wal gaʼii haguuge; ulfinni Waaqayyoos dunkaana qulqulluu sana guute. ");
INSERT INTO gaz_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Museenis sababii duumessi sun dunkaana wal gaʼii irra buʼee fi sababii ulfinni Waaqayyoo dunkaana qulqulluu guuteef dunkaana wal gaʼii seenuu hin dandeenye. ");
INSERT INTO gaz_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Israaʼeloonni karaa isaanii hunda keessatti yommuu duumessi dunkaana qulqulluu irraa kaʼu hunda kaʼanii deemsa isaanii itti fufu turan. ");
INSERT INTO gaz_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","Yoo duumessi irraa kaʼuu baate garuu hamma gaafa duumessi sun irraa kaʼuutti hin deeman ture. ");
INSERT INTO gaz_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Kanaafuu karaa isaanii hunda keessatti fuula saba Israaʼel hundaa duratti guyyaa guyyaa duumessi Waaqayyoo dunkaana qulqulluu irra ture; halkan halkan immoo ibiddi duumessa sana keessa ture.");
INSERT INTO gaz_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Waaqayyo Musee waamee dunkaana wal gaʼii keessaa akkana jedhee itti dubbate; ");
INSERT INTO gaz_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","“Israaʼelootatti dubbadhu; akkanas jedhiin: ‘Isin keessaa namni kam iyyuu yommuu horii keessaa Waaqayyoof kennaa dhiʼeessutti karra loonii yookaan bushaayee keessaa haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","“ ‘Yoo kennaan sun qalma gubamu kan karra loonii taʼe, namichi sun korma hirʼina hin qabne haa dhiʼeessu. Akka aarsaan sun fuula Waaqayyoo duratti fudhatama argatuufis balbala dunkaana wal gaʼii duratti haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Namichis mataa horii aarsaa gubamuuf dhiʼeeffamu sanaa irra harka isaa haa kaaʼu; kunis araara isaaf buusuuf qooda isaa fudhatama argata. ");
INSERT INTO gaz_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Innis fuula Waaqayyoo duratti korma haa qalu; ilmaan Aroon luboonni dhiiga sana fuudhanii iddoo aarsaa kan balbala dunkaana wal gaʼii dura jirutti gama hundaan haa facaasan. ");
INSERT INTO gaz_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Innis aarsaa gubamu sana irraa gogaa baasee kutaa kutaatti murmura. ");
INSERT INTO gaz_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ilmaan Aroon lubichaa immoo iddoo aarsaa irratti ibidda qabsiisanii qoraan irra haa naqan. ");
INSERT INTO gaz_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Ergasiis ilmaan Aroon luboonni kutaa murmurame, mataa fi cooma isaas qoraan iddoo aarsaa irratti bobaʼu irra tarree haa naqan. ");
INSERT INTO gaz_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Innis miʼa garaatii fi miilla qalma sanaa bishaaniin haa dhiqu; lubichis hunda isaa iddoo aarsaa irratti haa gubu. Kunis aarsaa gubamu kan ibiddaan dhiʼaatuu fi kan urgaan isaa Waaqayyotti toluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","“ ‘Yoo aarsaan sun qalma gubamu kan bushaayee jechuunis hoolaa yookaan reʼee taʼe namichi dhiʼeessu sun korma hirʼina hin qabne haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Innis gama kaaba iddoo aarsaatiin fuula Waaqayyoo duratti haa qalu; ilmaan Aroon luboonni immoo gama hundaan dhiiga isaa iddoo aarsaatti haa facaasan. ");
INSERT INTO gaz_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Namichi sunis kutaa kutaatti haa murmuru; lubichi immoo mataa fi cooma isaa qoraan iddoo aarsaa irratti bobaʼaa jiru irra tarree haa naqu. ");
INSERT INTO gaz_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Innis miʼa garaatii fi miilla qalma sanaa bishaaniin haa dhiqu; lubichi immoo hunda isaa fidee iddoo aarsaa irratti haa gubu. Kunis aarsaa gubamu kan ibiddaan dhiʼaatuu fi kan urgaan isaa Waaqayyotti toluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","“ ‘Yoo aarsaan Waaqayyoof dhiʼaatu sun qalma gubamu kan simbirrootaa taʼe namichi sun gugee yookaan gugee sookkee haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Lubichi sun gara iddoo aarsaatti haa fidu; mataa isaas micciiree irraa haa kutu; ergasii immoo iddoo aarsaa irratti haa gubu; dhiigni isaa immoo iddoo aarsaa cinatti haa coccobu. ");
INSERT INTO gaz_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Miʼa garaa isaa baallee isaa wajjin baasee karaa baʼa biiftuutiin iddoo aarsaa cinatti lafa daaraan jirutti haa gatu. ");
INSERT INTO gaz_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Karaa qoochoo isaatiin haa baqaqsu; garuu guutumaan guutuutti gargar hin baasin; ergasii lubichi iddoo aarsaa irratti qoraan bobaʼaa jiru irratti haa gubu. Kunis aarsaa gubamu kan ibiddaan dhiʼaatuu fi kan urgaan isaa Waaqayyotti toluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","“ ‘Namni tokko yommuu kennaa midhaanii Waaqayyoof dhiʼeessutti, kennaan isaa daakuu bullaaʼaa haa taʼu. Innis zayitii itti haa naqu; ixaanas itti dabalee, ");
INSERT INTO gaz_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","ilmaan Aroon luboota sanatti haa fidu. Lubichis daakuu bullaaʼaa zayitiin itti naqame sana irraa konyee tokko ixaana hunda wajjin haa fuudhu; kanas kutaa yaadannoo aarsaa gubamu kan ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti toluu godhee iddoo aarsaa irratti haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Kennaan midhaanii hafe immoo kan Aroonii fi ilmaan isaa ti; kunis kutaa aarsaawwan hunda caalaa qulqulluu kan ibiddaan Waaqayyoof dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","“ ‘Yeroo ati kennaa midhaanii barbadaa ibiddaa irratti tolfamee dhiʼeessitutti, kennaan sun daakuu bullaaʼaa jechuunis maxinoo zayitiin itti makame yookaan bixxillee raacitii malee tolfamee zayitiin irra dibame haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kennaan kee kennaa midhaanii kan eelee irratti qopheeffame taanaan kennaan sun daakuu bullaaʼaa hin bukaaʼin kan zayitiin itti makame irraa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Isa caccabsiitii gubbaa isaatti zayitii naqi; inni kennaa midhaanii ti. ");
INSERT INTO gaz_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kennaan midhaan keetii yoo eelee irratti qopheeffame, kennaan sun daakuu bullaaʼaa fi zayitii irraa haa qopheeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kennaa midhaanii kan wantoota kanneen irraa qopheeffame Waaqayyoof fidi; kanas luba iddoo aarsaatti geessutti kenni. ");
INSERT INTO gaz_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Innis Kennaa midhaanii sana irraa kutaa yaadannoo fuudhee kennaa ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti tolu godhee iddoo aarsaa irratti haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Kennaan midhaanii hafe immoo kan Aroonii fi ilmaan isaa ti; kunis kutaa aarsaawwan hunda caalaa qulqulluu kan ibiddaan Waaqayyoof dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","“ ‘Kennaan midhaanii kan isin Waaqayyoof dhiʼeessitan hundinuu utuu raacitiin itti hin makamin qopheeffamuu qaba; isin kennaa ibiddaan Waaqayyoof dhiʼeeffamu tokko keessatti raacitii yookaan damma tokko illee gubuu hin qabdaniitii. ");
INSERT INTO gaz_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Kennaa kanas akka mataa midhaaniitti Waaqayyoof dhiʼeessu dandeessu; garuu akka kennaa urgaaʼaa tokkootti iddoo aarsaa irratti dhiʼaachuu hin qabu. ");
INSERT INTO gaz_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kennaa midhaan keetii hunda soogiddaan miʼeessi; soogidda kakuu Waaqa keetii kennaa midhaan keetii keessaa hin hambisin; kennaa kee hundatti soogidda dabali. ");
INSERT INTO gaz_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","“ ‘Ati yoo mataa midhaanii keessaa kennaa midhaanii Waaqayyoof fidde, mataa midhaan asheetee ibiddaan waadamee sukkuumamee dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Zayitii itti naqiitii ixaanas itti dabali; kun kennaa midhaanii ti. ");
INSERT INTO gaz_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Lubni sunis kutaa yaadannoo midhaan sukkuumamee sanaatii fi zayitii sana ixaana hunda wajjin kennaa ibiddaan Waaqayyoof dhiʼeeffamu godhee haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","“ ‘Kennaan nama tokkoo yoo aarsaa nagaa taʼe, namichi sunis karra loonii keessaa horii tokko, korma yookaan dhalaa yoo dhiʼeesse, inni horii hirʼina hin qabne fuula Waaqayyoo duratti haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Namichi sun mataa kennaa isaa irra harka isaa haa kaaʼu; balbala dunkaana wal gaʼii durattis haa qalu. Ergasii immoo ilmaan Aroon luboonni sun dhiiga horii sana iddoo aarsaa sanatti gama hundaan haa facaasan. ");
INSERT INTO gaz_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Innis aarsaa nagaa irraa aarsaa ibiddaan Waaqayyoof dhiʼeeffamu haa fidu; kunis moora miʼa garaa haguuguu fi kan itti maxxanu hunda, ");
INSERT INTO gaz_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kalee lamaanii fi moora isaan irra jiru kan mudhiitti dhiʼaatu, haguuggii tiruu kan namichi kaleedhaan walitti qabee baasu faʼa. ");
INSERT INTO gaz_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Ergasiis ilmaan Aroon waan kana aarsaa ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti tolu godhanii iddoo aarsaa irratti aarsaa gubamu kan qoraan bobaʼu irra jiru irratti haa guban. ");
INSERT INTO gaz_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","“ ‘Inni yoo bushaayee keessaa horii tokko akka aarsaa nagaatti Waaqayyoof dhiʼeesse, korma yookaan dhalaa hirʼina hin qabne haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Inni yoo xobbaallaa hoolaa dhiʼeesse, fuula Waaqayyoo duratti haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Namichi sunis mataa kennaa isaa irra harka isaa kaaʼee balbala dunkaana wal gaʼii duratti haa qalu. Ergasii immoo ilmaan Aroon dhiiga horii sanaa iddoo aarsaa irratti gama hundaan haa facaasan. ");
INSERT INTO gaz_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Innis aarsaa nagaa sana irraa qalma ibiddaan Waaqayyoof dhiʼeeffamu haa fidu; kunis cooma isaa, duboo isaa kan lafee dugdaatti dhiʼeeffamee kutame hunda, moora miʼa garaa haguuguu fi kan itti maxxanu hunda, ");
INSERT INTO gaz_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","kalee lamaanii fi moora isaan irra jiru kan mudhiitti dhiʼaatu, haguuggii tiruu kan namichi kaleedhaan walitti qabee baasu faʼi. ");
INSERT INTO gaz_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Lubni sunis waan kana nyaata godhee iddoo aarsaa irratti haa gubu; nyaanni kunis aarsaa ibiddaan Waaqayyoof dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","“ ‘Yoo kennaan isaa reʼee taʼe, inni fuula Waaqayyoo duratti haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Namichi sun mataa reʼee sanaa irra harka isaa kaaʼee fuula dunkaana wal gaʼii duratti haa qalu. Ergasii immoo ilmaan Aroon dhiiga horii sanaa iddoo aarsaa irratti gama hundaan haa facaasan. ");
INSERT INTO gaz_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Innis waan dhiʼeessu keessaa kennaa kana kennaa ibiddaan Waaqayyoof dhiʼeeffamu godhee haa dhiʼeessu; kunis moora miʼa garaa haguuguu fi kan itti maxxanu hunda, ");
INSERT INTO gaz_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kalee lamaanii fi moora isaan irra jiru kan mudhiitti dhiʼaatu, haguuggii tiruu kan namichi kaleedhaan walitti qabee baasu faʼi. ");
INSERT INTO gaz_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Lubni sunis waan kana nyaata godhee iddoo aarsaa irratti haa gubu; kunis aarsaa urgaaʼaa ibiddaan dhiʼeeffamuu dha. Coomni hundinuu kan Waaqayyoo ti. ");
INSERT INTO gaz_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","“ ‘Isin cooma tokko illee yookaan dhiiga tokko illee hin sooratinaa; wanni kun lafa isin jiraattan hundatti dhaloota dhufuuf jiru keessatti seera hin geeddaramnee dha.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Waaqayyo akkana jedhee Museetti dubbate; ");
INSERT INTO gaz_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","“Israaʼelootaan akkana jedhi; ‘Yoo namni utuu hin beekin waan Waaqayyo dhowwe cabsuudhaan cubbuu hojjete. ");
INSERT INTO gaz_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","“ ‘Lubichi dibame yoo cubbuu hojjetee akkasiin sabatti cubbuu fide, inni cubbuu hojjete sanaaf dibicha hirʼina hin qabne tokko aarsaa cubbuu godhee Waaqayyoof haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Innis dibicha sana balbala dunkaana wal gaʼii irratti fuula Waaqayyoo duratti haa dhiʼeessu. Mataa dibicha sanaa irras harka isaa kaaʼee fuula Waaqayyoo duratti haa qalu. ");
INSERT INTO gaz_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Lubni dibame sun dhiiga dibicha sanaa irraa fuudhee dunkaana wal gaʼiitti qabatee haa seenu. ");
INSERT INTO gaz_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Lubni sunis quba isaa dhiiga keessa cuphee dhiiga sana irraa golgaa iddoo qulqulluu duratti yeroo torba fuula Waaqayyoo duratti haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Ergasiis lubni sun dhiiga sana irraa gaanfawwan iddoo aarsaa ixaana urgaaʼu kan dunkaana wal gaʼii keessa fuula Waaqayyoo dura jiru sana irratti haa naqu. Dhiiga dibicha sanaa kan hafe hunda immoo balbala dunkaana wal gaʼii irratti miilla iddoo aarsaa gubamuu jalatti haa dhangalaasu. ");
INSERT INTO gaz_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Innis dibicha aarsaa cubbuutiif dhiʼeeffame sana irraa cooma hunda haa baasu; kunis moora miʼa garaa haguuguu fi kan itti maxxanu hunda, ");
INSERT INTO gaz_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kalee lamaanii fi moora isaan irra jiru kan mudhiitti dhiʼaatu, haguuggii tiruu kan inni kaleedhaan walitti qabee baasu faʼi; ");
INSERT INTO gaz_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","waan kanas akkuma loon aarsaa nagaatiif dhiʼeeffamu irraa moorri baafamu sanatti haa baasu. Lubnis iddoo aarsaa kan aarsaa gubamuu irratti haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Garuu gogaa dibicha sanaatii fi foon isaa hunda, mataa fi miilla isaa, miʼa garaatii fi cumaa isaa, ");
INSERT INTO gaz_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","jechuunis waan dibicha sanaa kan hafe hunda qubata keessaa gad baasee gara iddoo seeraan qulqulluu taʼe kan daaraan itti gatamuutti haa geessu; daaraa tuulame irrattis ibidda qoraaniitiin haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","“ ‘Yoo waldaan Israaʼel hundi utuu hin beekin cubbamee waan ajaja Waaqayyoo keessatti dhowwame hojjete waldaan sun waaʼee waan sanaa beekuu baatu illee yakka qabeessa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Yommuu cubbuun isaan hojjetan beekamutti waldaan sun dibicha tokko aarsaa cubbuu godhee dunkaana wal gaʼii duratti fidee haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Maanguddoonni waldaa fuula Waaqayyoo duratti mataa dibicha sanaa irra harka isaanii haa kaaʼan; dibichi sunis fuula Waaqayyoo duratti haa qalamu. ");
INSERT INTO gaz_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Lubni dibame sun dhiiga dibicha sanaa irraa fuudhee gara dunkaana wal gaʼiitti haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Innis quba isaa dhiiga keessa cuuphee golgaa duratti yeroo torba fuula Waaqayyoo duratti haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Lubni sunis dhiiga sana irraa gaanfawwan iddoo aarsaa kan dunkaana wal gaʼii keessa fuula Waaqayyoo dura jiru sana irratti haa naqu. Dhiiga dibicha sanaa kan hafe hunda immoo balbala dunkaana wal gaʼii irratti miilla iddoo aarsaa gubamuu jalatti haa dhangalaasu. ");
INSERT INTO gaz_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Inni cooma hunda irraa baasee iddoo aarsaa irratti haa gubu; ");
INSERT INTO gaz_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","dibicha kanas akkuma dibicha aarsaa cubbuutiif dhiʼeeffame sana godhe haa godhu; lubnis haaluma kanaan araara isaaniif buusa; isaanis dhiifama argatu. ");
INSERT INTO gaz_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Innis ergasii dibicha sana qubata keessaa gad baasee akkuma dibicha jalqabaa gube sana haa gubu; kunis aarsaa cubbuu waldaa ti. ");
INSERT INTO gaz_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","“ ‘Bulchaan tokko yoo utuu hin beekin cubbuu hojjetee waan ajaja Waaqayyo Waaqa isaa keessatti dhowwame hojjete inni yakka qabeessa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Inni yommuu cubbuu hojjete sana beeketti korma reʼee kan hirʼina hin qabne tokko aarsaa ofii isaatiif haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Mataa reʼee sanaa irra harka isaa kaaʼee iddoo aarsaan gubamu itti qalamutti fuula Waaqayyoo duratti haa qalu; kunis aarsaa cubbuu ti. ");
INSERT INTO gaz_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Lubni sunis ergasii dhiiga aarsaa cubbuutiif dhiʼeeffame irraa quba isaatiin fuudhee gaanfa iddoo aarsaa kan aarsaan gubamu irratti dhiʼeeffamutti haa naqu; dhiiga hafe immoo miilla iddoo aarsaa jalatti haa dhangalaasu. ");
INSERT INTO gaz_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Innis akkuma cooma aarsaa nagaatiif dhiʼeeffame gube sana moora hunda iddoo aarsaa irratti haa gubu; lubichi haala kanaan namichaaf araara cubbuu buusa; innis dhiifama argata. ");
INSERT INTO gaz_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","“ ‘Saba keessaa namni tokko yoo utuu hin beekin waan ajaja Waaqayyoo keessatti dhowwame keessaa tokko illee cabsuudhaan cubbuu hojjete inni yakka qabeessa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Inni yommuu akka cubbuu hojjete beeketti cubbuu hojjete sanaaf reʼee dhaltuu hirʼina hin qabne tokko aarsaa ofii isaatiif haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Mataa reʼee aarsaa cubbuutiif dhiʼeeffamte sanaa irras harka isaa kaaʼee iddoo aarsaa gubamuutti haa qalu. ");
INSERT INTO gaz_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Lubni sunis ergasii dhiiga sana irraa quba isaatiin fuudhee gaanfa iddoo aarsaa kan aarsaan gubamu irratti dhiʼeeffamutti haa naqu; dhiiga hafe hunda immoo miilla iddoo aarsaa jalatti haa dhangalaasu. ");
INSERT INTO gaz_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Akkuma moorri itti aarsaa nagaa irraa baafamutti inni moora hunda haa baasu; lubni immoo aarsaa urgaan isaa Waaqayyotti tolu godhee iddoo aarsaa irratti haa gubu. Akkasiinis lubni araara buusaaf; innis dhiifama argata. ");
INSERT INTO gaz_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","“ ‘Inni yoo hoolaa tokko aarsaa cubbuu ofii isaatiif fide, dhaltuu hirʼina hin qabne haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Mataa hoolaa sanaa irras harka isaa kaaʼee iddoo aarsaan gubamu itti qalamutti aarsaa cubbuutiif haa qalu. ");
INSERT INTO gaz_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Lubni sunis ergasii dhiiga aarsaa cubbuutiif dhiʼeeffame irraa quba isaatiin fuudhee gaanfa iddoo aarsaa kan aarsaa gubamuutti haa naqu; dhiiga hafe hunda immoo miilla iddoo aarsaa jalatti haa dhangalaasu. ");
INSERT INTO gaz_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Akkuma moorri itti hoolaa aarsaa nagaatiif dhiʼeeffamu irraa baafamutti inni moora hunda haa baasu; lubni immoo aarsaa ibiddaan Waaqayyoof dhiʼeeffamu gubbaatti iddoo aarsaa irratti haa gubu. Lubnis akkasiin cubbuu namichi hojjeteef araara buusaaf; innis dhiifama argata. ");
INSERT INTO gaz_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","“ ‘Namni tokko yoo waan nama kakachiisu dhagaʼee waaʼee waan arge yookaan beeku sanaa dhugaa baʼuu diduudhaan cubbuu hojjete inni itti gaafatama. ");
INSERT INTO gaz_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","“ ‘Yookaan namni tokko yoo waan akka seeraatti xuraaʼaa taʼe jechuunis raqa bineensa xuraaʼaa yookaan horii xuraaʼaa yookaan uumamawwan xuraaʼoo kanneen lafa irra munyuuqanii utuu hin beekin tuqe inni xuraaʼeera; yakka qabeessas taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","Yookaan inni yoo xuraaʼummaa namaa jechuunis waan isa xureessu kam iyyuu utuu hin beekin tuqe, yommuu waan sana beeketti yakka qabeessa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","Yookaan namni yoo utuu itti hin yaadin waan gaarii yookaan hamaa gochuuf kakate, waaʼee waan utuu itti hin yaadin kakate sanaa beekuu baatu illee maalumaafuu yommuu waan sana beeketti inni yakka qabeessa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","Inni yoo karaa kanneen keessaa tokkoon iyyuu yakka qabeessa taʼe karaa kamiin akka hojjete haa himatu; ");
INSERT INTO gaz_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","adaba cubbuu hojjete sanaatiifis akka aarsaa cubbuu isaaf taatuuf bushaayee keessaa hoolaa yookaan reʼee dhaltuu Waaqayyoof haa fidu; lubnis cubbuu namichaatiif aarsaa araaraa haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","“ ‘Namichi sun cubbuu hojjeteef hoolaa dhiʼeessuutti harka qalleessa yoo taʼe adabbii cubbuu isaatiif gugee lama yookaan gugee sosookkee lama, tokko aarsaa cubbuutiif tokko immoo aarsaa gubamuuf Waaqayyoof haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Lubattis isaan haa fidu; lubni immoo kan aarsaa cubbuutiif taatu duraan dursee haa dhiʼeessu. Innis mataa ishee micciiree morma ishee haa cabsu; garuu irraa hin kutin. ");
INSERT INTO gaz_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Dhiiga aarsaa cubbuu sana irraa fuudhee cinaacha iddoo aarsaatti haa facaasu; dhiigni hafe immoo miilla iddoo aarsaa jalatti haa dhangalaafamu; kun aarsaa cubbuu ti. ");
INSERT INTO gaz_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Ergasiis lubichi akkuma ajajametti kan lammaffaa sana aarsaa gubamu godhee cubbuu namichi hojjeteef aarsaa araaraa haa dhiʼeessu; innis dhiifama argata. ");
INSERT INTO gaz_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","“ ‘Namichi sun yoo gugee lama yookaan gugee sosookkee lama dhiʼeessuutti harka qalleessa taʼe inni cubbuu hojjete sanaaf daakuu bullaaʼaa iifii tokkoo keessaa harka kurnaffaa aarsaa cubbuutiif haa dhiʼeessu. Sababii wanni kun aarsaa cubbuu taʼeef namichi zayitii yookaan ixaana itti hin dabalin. ");
INSERT INTO gaz_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Innis lubatti haa fidu; lubichi immoo konyee tokko irraa fuudhee akka kutaa yaadannoo tokkootti aarsaa ibiddaan Waaqayyoof dhiʼeeffame gubbaatti iddoo aarsaa irratti haa gubu; kun aarsaa cubbuu ti. ");
INSERT INTO gaz_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Lubichis haala kanaan cubbuu namichi hojjeteef araara buusa; innis dhiifama argata. Aarsaan hafe immoo akkuma aarsaa midhaaniitti kan lubichaa taʼa.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","“Namni yoo seera cabsee utuu hin beekin waan Waaqayyoof qulqulleeffame kam iyyutti cubbuu hojjete inni adabbii cubbuu isaatiif bushaayee keessaa korbeessa hoolaa kan hirʼina hin qabne kan gatiin isaa akka saqilii iddoo qulqulluutti meetiidhaan tilmaamame tokko aarsaa yakkaa godhee Waaqayyoof haa fidu; kun aarsaa yakkaa ti. ");
INSERT INTO gaz_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Namichi sunis waan wantoota qulqulluu irraa hirʼise sana iddoo haa buusu; gatii waan sanaa illee harka shan keessaa harka tokko itti dabalee hunda isaa lubatti haa kennu; lubni sunis korbeessa hoolaa aarsaa yakkaatiif dhiʼeeffame sanaan araara buusaaf; innis dhiifama argata. ");
INSERT INTO gaz_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","“Namni yoo cubbuu hojjetee waan ajajawwan Waaqayyoo keessatti dhowwame hojjete, inni yoo beekuu baate illee yakka qabeessa taʼeera; itti gaafatamas. ");
INSERT INTO gaz_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Innis akka tilmaama keetiitti bushaayee keessaa korbeessa hoolaa hirʼina hin qabne tokko aarsaa yakkaa godhee lubatti haa fidu. Lubichis haaluma kanaan yakka namichi utuu hin beekin hojjeteef araara buusa; innis dhiifama argata. ");
INSERT INTO gaz_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Kun aarsaa yakkaa ti; namichi sun Waaqayyotti yakka hojjeteera.” ");
INSERT INTO gaz_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","“Namni yoo waaʼee waan imaanaa isatti kennamee yookaan waan isa bira kaaʼamee yookaan waan hatame tokkoo ollaa isaa gowwoomsuudhaan yookaan saamuudhaan cubbuu hojjetee Waaqayyoof amanamuu baate, ");
INSERT INTO gaz_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","yookaan yoo qabeenya bade argee waaʼee isaa soba dubbate yookaan yoo sobaan kakate yookaan yoo cubbuu akkasii kan namoonni hojjetan kam iyyuu hojjete, ");
INSERT INTO gaz_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","yoo akkasiin cubbuu hojjetee yakka qabeessa taʼe inni waan hate yookaan waan humnaan saame yookaan waan imaanaa isatti kenname yookaan waan bade kan lafaa arge sana ");
INSERT INTO gaz_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","yookaan waan sobaan itti kakate hunda haa deebisu. Inni waan sana guutummaatti iddoo haa buusu; gatii waan sanaas harka shan keessaa harka tokko itti dabalee hunda isaa guyyuma aarsaa yakka ofii isaa dhiʼeeffatutti abbaa qabeenya sanaatiif haa kennu. ");
INSERT INTO gaz_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Ergasiis inni bushaayee keessaa korbeessa hoolaa hirʼina hin qabne kan gatiin isaa gatii adabbii yakka tokkootti tilmaamamu aarsaa yakka ofii isaa kan Waaqayyoof dhiʼeeffamu godhee lubatti haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Lubichi haaluma kanaan fuula Waaqayyoo duratti araara isaaf buusa; innis wantoota kanneen keessaa waan hojjete kan yakka qabeessa isa godhe kamiif iyyuu dhiifama argata.” ");
INSERT INTO gaz_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","“Aroonii fi ilmaan isaatiif ajaja kana kenni: ‘Seerri aarsaa gubamuu kanaa dha; aarsaan gubamu hamma lafti bariitutti halkan guutuu ibidda iddoo aarsaa irra jiru gubbaa haa turu; ibiddis ittuma fufee iddoo aarsaa irratti haa bobaʼu. ");
INSERT INTO gaz_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Lubni sunis uffata isaa kan quncee talbaa irraa hojjetamee fi uffata wayyaa jalaan dhagna isaatti aanu kan quncee talbaa irraa hojjetame haa uffatu; ergasiis daaraa aarsaa gubamuu kan ibiddi iddoo aarsaa irratti gubee fixe sana haree iddoo aarsaa cina haa kaaʼu. ");
INSERT INTO gaz_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Ergasiis uffata sana of irraa baasee kan biraa haa uffatu; daaraa sanas baatee qubata keessaa gad baasee lafa akka seeraatti qulqulluu taʼetti haa geessu. ");
INSERT INTO gaz_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ibiddi iddoo aarsaa irra jiru yeroo hunda bobaʼuu qaba; yoom iyyuus hin dhaamin. Lubichi ganama ganama ibidda sanatti qoraan haa naqu; aarsaa gubamu ibidda irratti haa qopheessu; kana irrattis cooma aarsaa nagaa haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Iddoo aarsaa irratti ibiddi yeroo hunda haa bobaʼu; gonkumaas hin dhaamin. ");
INSERT INTO gaz_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","“ ‘Seerri kennaa midhaanii kanaa dha: Ilmaan Aroon waan kana fuullee iddoo aarsaatti fuula Waaqayyoo duratti haa dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Lubnis daakuu bullaaʼaa konyee tokkoo fi zayitii, ixaana kennaa midhaanii irra jiru hunda wajjin fuudhee urgaa Waaqayyotti tolu godhee akka kutaa yaadannootti iddoo aarsaa irratti haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Aroonii fi ilmaan isaa immoo waan irraa hafe haa nyaatan; kun maxinoo iddoo qulqulluutti nyaatamuu qabuu dha; isaanis oobdii dunkaana wal gaʼii keessatti haa nyaatan. ");
INSERT INTO gaz_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Wanni kun raacitiidhaan tolfamuu hin qabu; ani kennaa ibiddaan naa dhiʼeeffamu keessaa akka qooda isaaniitti waan kana isaaniif kenneera. Kunis akkuma aarsaa cubbuutii fi aarsaa yakkaatti waan hunda caalaa qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Sanyiin Aroon kan dhiira taʼe kam iyyuu waan kana nyaachuu dandaʼa. Kunis qooda kennaa ibiddaan Waaqayyoof dhiʼeeffamu keessaa dhaloota keessan kan dhufutti bara baraan Arooniif kennamee dha; namni isa tuqu hundinuus ni qulqullaaʼa.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","“Kennaan Aroonii fi ilmaan isaa guyyaa inni dibamutti Waaqayyoof dhiʼeessuu qaban kanaa dha: Daakuu bullaaʼaa iifii kudhan keessaa tokkoo jechuunis walakkaa isaa ganama, walakkaa immoo galgala yeroo hunda kennaa midhaanii godhanii haa dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Kunis zayitiidhaan eelee irratti haa tolfamu; akka gaariitti walitti makiitii kennaa midhaan sanaa caccabsii urgaa Waaqayyotti tolu godhii dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ilmi isaa kan luba taʼee dibamee iddoo isaa buʼu waan kana haa qopheessu; kennaan kun sababii qooda Waaqayyoo kan bara baraa taʼeef guutummaatti haa gubamu. ");
INSERT INTO gaz_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kennaan midhaanii kan lubichi dhiʼeessu hundi guutummaatti haa gubamu; aarsaan sun nyaatamuu hin qabuutii.” ");
INSERT INTO gaz_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","“Aroonii fi ilmaan isaatiin akkana jedhi: ‘Seerri aarsaan cubbuu ittiin dhiʼeeffamu kanaa dha: Aarsaan cubbuu iddoo aarsaan gubamu itti qalamutti fuula Waaqayyoo duratti haa qalamu; aarsaan kun waan hunda caalaa qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Lubni isa dhiʼeessu aarsaa kana haa nyaatu; kunis oobdii dunkaana wal gaʼii keessatti iddoo qulqulluutti nyaatamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Namni foon sana tuqu kam iyyuu ni qulqullaaʼa; yoo dhiigni isaa tokko iyyuu uffatatti facaʼe uffata sana iddoo qulqulluutti miicuu qabda. ");
INSERT INTO gaz_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Okkoteen suphee kan foon sun itti affeelame haa cabsamu; yoo okkotee naasiitti affeelame garuu haqamee bishaaniin haa dhiqamu. ");
INSERT INTO gaz_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Dhiirri gosa lubootaa taʼe kam iyyuu foon kana nyaachuu ni dandaʼa; kun waan hunda caalaa qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Garuu aarsaan cubbuu kan araara buusuudhaaf dhiigni isaa gara dunkaana wal gaʼii Iddoo Qulqulluutti fidamu kam iyyuu nyaatamuu hin qabu; inni gubamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","“ ‘Seerri aarsaa yakkaa kan waan hunda caalaa qulqulluu taʼe sanaa kana: ");
INSERT INTO gaz_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Aarsaan yakkaa iddoo aarsaan gubamu itti qalamutti haa qalamu; dhiigni isaa immoo gama hundaan iddoo aarsaatti facaafamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Moorri isaa hundinuus aarsaa taʼee dhiʼeeffamuu qaba; kunis duboo fi moora miʼa garaa haguugu, ");
INSERT INTO gaz_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kalee lamaanii fi moora isaan irra jiru kan mudhiitti dhiʼaatu, haguuggiin tiruu kan kaleewwan wajjin baʼu wal faana haa dhiʼaatu. ");
INSERT INTO gaz_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Lubichis aarsaa ibiddaan Waaqayyoof dhiʼaatu godhee iddoo aarsaa irratti haa gubu; kun aarsaa yakkaa ti. ");
INSERT INTO gaz_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Dhiirri gosa lubootaa taʼe kam iyyuu foon kana nyaachuu dandaʼa; kun garuu iddoo qulqulluutti nyaatamuu qaba; aarsaan kun waan hunda caalaa qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","“ ‘Seerri aarsaan cubbuutii fi aarsaan yakkaa ittiin dhiʼeeffamu tokkuma; aarsaawwan kunneenis kan luba ittiin araara buusuu taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Lubni namaaf jedhee aarsaa gubamu dhiʼeessu tokko gogaa aarsaa gubamu sanaa ofii isaatiif haa fudhatu. ");
INSERT INTO gaz_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kennaan midhaanii kan barbadaa ibiddaa irratti yookaan eelee irratti yookaan beddee irratti bilchaate kam iyyuu luba isa dhiʼeessuuf haa kennamu; ");
INSERT INTO gaz_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","kennaan midhaanii kam iyyuu jechuunis kan zayitiin itti makame yookaan goggogaan ilmaan Aroon hundaaf wal qixxee haa kennamu. ");
INSERT INTO gaz_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","“ ‘Seerri aarsaa nagaa kan namni tokko ittiin Waaqayyoof dhiʼeessuu qabu kana. ");
INSERT INTO gaz_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","“ ‘Inni yoo galata galchuuf aarsaa dhiʼeeffate, aarsaa galataa kana wajjin maxinoo zayitiin itti makame, bixxillee raacitii malee tolfamee zayitiin irra dibamee fi maxinoo daakuu bullaaʼaa kan akka gaarii sukkuumamee zayitiin itti makame haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Aarsaa nagaa kan galataaf dhiʼeeffatu wajjinis kennaa maxinoo raacitii qabu haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Aarsaa hunda keessaa tokko tokko fuudhee akka kennaa Waaqayyoof dhiʼeeffamu tokkootti haa fidu; kunis luba dhiiga aarsaa nagaa facaasu sanaaf haa kennamu. ");
INSERT INTO gaz_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Foon aarsaa nagaa kan galataaf dhiʼeeffamu gaafuma dhiʼaate sana nyaatamee dhumuu qaba; wanni tokko iyyuu isa irraa hafee buluu hin qabu. ");
INSERT INTO gaz_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","“ ‘Yoo aarsaan isaa wareega guuttachuuf yookaan aarsaa fedhiidhaan dhiʼaatu taʼe, aarsaan sun guyyuma inni dhiʼeesse nyaatamuu qaba; kan hafe garuu guyyaa itti aanu nyaatamuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Foon aarsaa sana irraa hamma guyyaa sadaffaatti hafe gubamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Foon aarsaa nagaa sana irraa yoo wanni tokko iyyuu guyyaa sadaffaatti nyaatame aarsaan sun hin fudhatamu. Kun sababii xuraaʼaa taʼeef nama dhiʼeesse sanaaf fudhatama hin qabaatu. Namni foon sana irraa nyaatu itti gaafatama. ");
INSERT INTO gaz_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","“ ‘Foon waan akka seeraatti xuraaʼaa taʼe kam iyyuu tuqe hin nyaatamin; foon sun gubamuu qaba. Foon kaan garuu namni akka seeraatti qulqulluu taʼe kam iyyuu nyaachuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Garuu namni xuraaʼaan yoo foon aarsaa nagaa kan Waaqayyoof dhiʼeeffame nyaate, inni saba ofii keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Namni yoo waan xuraaʼaa jechuunis xuraaʼummaa namaa yookaan horii xuraaʼaa yookaan waan xuraaʼaa kam iyyuu, waan jibbisiisaa tuqee ergasii immoo foon aarsaa nagaa kan Waaqayyoof dhiʼaate keessaa nyaate namni sun saba ofii keessaa haa balleeffamu.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","“Israaʼelootaan akkana jedhi; ‘Moora loonii yookaan kan hoolaa yookaan kan reʼee kamii iyyuu hin nyaatinaa. ");
INSERT INTO gaz_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Coomni horii duʼee argamee yookaan bineensi ajjeesee waan biraaf haa oolu; isin garuu isa nyaachuu hin qabdan. ");
INSERT INTO gaz_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Namni horii ibiddaan Waaqayyoof dhiʼeeffame irraa cooma isaa nyaate kam iyyuu saba ofii isaa keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Isin lafa jiraattan hundatti dhiiga simbirroo yookaan horii gosa kamii iyyuu hin nyaatinaa. ");
INSERT INTO gaz_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Namni kam iyyuu yoo dhiiga nyaate saba ofii isaa keessaa haa balleeffamu.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","“Israaʼelootaan akkana jedhi; ‘Namni aarsaa nagaa Waaqayyoof dhiʼeessu kanuma irraa fuudhee aarsaa ofii isaa Waaqayyoof haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Aarsaa ibiddaan Waaqayyoof dhiʼeeffamus harkuma isaatiin haa fidu; cooma sana handaraafa wajjin haa fidu; handaraafas aarsaa sochoofame godhee fuula Waaqayyoo duratti haa sochoosu. ");
INSERT INTO gaz_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Lubichi cooma sana iddoo aarsaa irratti haa gubu. Handaraafni isaa garuu Aroonii fi ilmaan isaatiif haa kennamu. ");
INSERT INTO gaz_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Tafa mirgaa kan aarsaa nagaa keessanii kennaa godhaatii lubaaf kennaa. ");
INSERT INTO gaz_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ilmi Aroon kan dhiigaa fi cooma aarsaa nagaa dhiʼeessu sun tafa mirgaa qooda ofii isaa godhee haa fudhatu. ");
INSERT INTO gaz_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ani aarsaa nagaa kan Israaʼelootaa irraa handaraafa sochoofamee fi tafa dhiʼaate sana fudhadheera; kanas akka qooda isaan bara baraan Israaʼeloota irraa argataniitti Aroon lubichaa fi ilmaan isaatii kenneera.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Gaafa isaan lubummaadhaan Waaqayyoon tajaajiluuf dhiʼaatanitti aarsaa ibiddaan Waaqayyoof dhiʼaate irraa qoodni Aroonii fi ilmaan isaatiif ramadame kana. ");
INSERT INTO gaz_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Guyyaa isaan dibamanitti, akka Israaʼeloonni qooda isaanii godhanii bara baraan dhaloota dhufutti waan kana isaanii kennan Waaqayyo ajajeera. ");
INSERT INTO gaz_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Egaa seerri dhiʼeessuu aarsaa gubamuu, kennaa midhaanii, aarsaa cubbuu, aarsaa yakkaa, seerri dibamuu lubummaatii fi aarsaa nagaa kanaa dha; ");
INSERT INTO gaz_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","kunis ajaja Waaqayyo gaafa akka Israaʼeloonni Gammoojjii Siinaatti kennaa isaanii Waaqayyoof dhiʼeessan Gaara Siinaa irratti Museedhaaf kennee dha. ");
INSERT INTO gaz_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","“Aroonii fi ilmaan isaa, uffata isaanii, zayitii ittiin diban, dibicha aarsaa cubbuutiif dhiʼeeffamu, korbeeyyii hoolaa lamaa fi gundoo maxinoo baatu fidi; ");
INSERT INTO gaz_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","waldaa hundas balbala dunkaana wal gaʼii duratti walitti qabi.” ");
INSERT INTO gaz_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Museenis akkuma Waaqayyo isa ajaje sana godhe; waldaan hundis balbala dunkaana wal gaʼii duratti walitti qabame. ");
INSERT INTO gaz_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Museenis waldaa sanaan, “Wanni Waaqayyo akka hojjetamu ajaje kana” jedhe. ");
INSERT INTO gaz_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Ergasiis Museen Aroonii fi ilmaan isaa gara fuula duraatti fidee bishaaniin isaan dhiqe. ");
INSERT INTO gaz_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Innis Aroonitti kittaa uffisee sabbataan hidheef; wandaboos itti uffisee isa irratti dirata dabaleef; dirata sanas sabbata ogummaadhaan hojjetameen hidheef. ");
INSERT INTO gaz_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Kiisii qomaa itti kaaʼee kiisii sana keessa immoo Uriimii fi Tumiimii kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Museenis akkuma Waaqayyo isa ajajetti mataa Aroonitti marata mare; marata sana irrattis karaa fuula duraatiin faaya warqee kan gonfoo qulqulluu tolche. ");
INSERT INTO gaz_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Ergasii Museen zayitii ittiin diban fuudhee dunkaana qulqulluu fi waan achi keessa jiru hunda dibee qulqulleesse. ");
INSERT INTO gaz_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Zayitii sana irraas fuudhee iddoo aarsaa irratti yeroo torba facaase; akka isaan qulqulleessuufis iddoo aarsaatii fi miʼa isaa hunda akkasumas gabatee itti dhiqatan miilla isaa wajjin zayitii dibe. ");
INSERT INTO gaz_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Zayitii ittiin diban irraas fuudhee mataa Aroon irratti dhangalaase; isa qulqulleessuufis isa dibe. ");
INSERT INTO gaz_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Museenis akkuma Waaqayyo isa ajajetti ilmaan Aroon gara fuula duraatti baasee kittaa itti uffise; sabbata hidheefii gonfoo mataa isaaniitti kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Ergasii immoo aarsaa cubbuutiif dibicha dhiʼeesse; Aroonii fi ilmaan isaas mataa dibicha sanaa irra harka isaanii kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Museenis dibicha sana qalee dhiiga fuudhee iddoo aarsaa qulqulleessuuf quba isaatiin gaanfa iddoo aarsaa hunda dibe; dhiiga hafe immoo miilla iddoo aarsaa jalatti gad naqe. Araara isaaf buusuufis iddoo aarsaa sana qulqulleesse. ");
INSERT INTO gaz_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Akkasumas moora naannoo miʼa garaa jiru, haguuggii tiruu, kalee lamaanii fi moora isaanii fuudhee iddoo aarsaa irratti gube. ");
INSERT INTO gaz_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Dibicha sana, gogaa isaa, foon isaatii fi cumaa isaa garuu akkuma Waaqayyo isa ajajetti qubata keessaa gad baasee gube. ");
INSERT INTO gaz_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Ergasii immoo aarsaa gubamuuf korbeessa hoolaa dhiʼeesse; Aroonii fi ilmaan isaas mataa hoolaa sanaa irra harka isaanii kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Museen immoo korbeessa hoolaa sana qalee dhiiga isaa iddoo aarsaatti gama hundaan facaase. ");
INSERT INTO gaz_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Korbeessa hoolaa sana gargar kukkutee mataa, buʼaa fi cooma isaa gube. ");
INSERT INTO gaz_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Innis miʼa garaatii fi luka bishaaniin dhiqee korbeessa hoolaa sana guutuu iddoo aarsaa irratti gube. Kunis aarsaa gubamu, foolii namatti tolu, aarsaa nyaataa akkuma Waaqayyo Musee ajajetti Waaqayyoof dhiʼeeffamee dha. ");
INSERT INTO gaz_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Innis ergasii korbeessa hoolaa kaan jechuunis hoolaa ittiin muudan sana dhiʼeesse; Aroonii fi ilmaan isaa immoo mataa hoolaa sanaa irra harka isaanii kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Museenis hoolaa sana qalee dhiiga isaa irraa fuudhee fiixee gurra Aroon mirgaa, quba abbuudduu harka isaa mirgaatii fi quba abbuudduu miilla isaa mirgaa dibe. ");
INSERT INTO gaz_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Ilmaan Aroonis gara fuula duraatti baasee dhiiga fuudhee fiixee gurra isaanii mirgaa, quba abbuudduu harka isaanii mirgaatii fi quba abbuudduu miilla isaanii mirgaa ittiin tuqe. Ergasiis dhiiga sana iddoo aarsaatti gama hundaan facaase. ");
INSERT INTO gaz_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Innis cooma, duboo, moora naannoo miʼa garaa jiru, haguuggii tiruu, kalee lamaanii fi moora isaanii, tafa mirgaa fuudhe. ");
INSERT INTO gaz_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Ergasiis gundoo maxinoo baatu kan fuula Waaqayyoo dura ture sana irraa maxinoo tokko, maxinoo zayitiidhaan tolfame tokkoo fi bixxillee tokko fuudhe; waan kanas cooma sanaa fi tafa mirgaa irra kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Innis wantoota kanneen hunda harka Aroonii fi harka ilmaan isaa keessa kaaʼee aarsaa sochoofamu godhee fuula Waaqayyoo duratti sochoose. ");
INSERT INTO gaz_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Museenis wantoota kanneen harka isaaniitii fuudhee aarsaa ittiin luba taʼan kan ibiddaan Waaqayyoof dhiʼeeffamu, foolii namatti tolu, aarsaa nyaataa godhee iddoo aarsaa irratti aarsaa gubamu gubbaatti gube. ");
INSERT INTO gaz_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Museenis handaraafa fuudhee aarsaa sochoofamu godhee fuula Waaqayyoo duratti sochoose; kunis akkuma Waaqayyo isa ajajetti qooda Museen korbeessa hoolaa ittiin luba taʼan irraa argatuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Ergasiis Museen zayitii ittiin dibanii fi dhiiga iddoo aarsaa irra jiru irraa fuudhee Aroonii fi uffata isaatti, ilmaan isaattii fi uffata isaaniitti facaase; akkasiinis Aroonii fi uffata isaa, ilmaan isaatii fi uffata isaanii qulqulleesse. ");
INSERT INTO gaz_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Museenis Aroonii fi ilmaan isaatiin akkana jedhe; “Foon sana balbala dunkaana wal gaʼii duratti affeellaa; akkuma ani ‘Aroonii fi ilmaan isaa haa nyaatan’ jedhee ajajetti foon sana buddeena gundoo aarsaan ittiin luboota taʼan keessa kaaʼamu sana keessa jiru wajjin achumatti nyaadhaa. ");
INSERT INTO gaz_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Foonii fi buddeena hafu immoo ibiddaan gubaa. ");
INSERT INTO gaz_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Sababii luba taʼuun keessan bultii torba fudhatuuf hamma yeroon luba taʼuu keessanii raawwatutti bultii torba balbala dunkaana wal gaʼii duraa hin deeminaa. ");
INSERT INTO gaz_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Waan harʼa hojjetame kana Waaqayyotu araara isinii buusuuf akka hojjetamu ajaje. ");
INSERT INTO gaz_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Isin akka hin duuneef bultii torba halkanii fi guyyaa balbala dunkaana wal gaʼii dura turaatii waan Waaqayyo isin irraa barbaadu hojjedhaa; wanni ani ajajame kanaatii.” ");
INSERT INTO gaz_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Aroonii fi ilmaan isaa waan Waaqayyo karaa Museetiin ajaje hunda hojjetan. ");
INSERT INTO gaz_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Museen bultii saddeettaffaatti Aroon, ilmaan Aroonii fi maanguddoota Israaʼel waame; ");
INSERT INTO gaz_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Arooniinis akkana jedhe; “Aarsaa cubbuutiif dibicha tokko, aarsaa gubamuuf immoo korbeessa hoolaa tokko kanneen hirʼina hin qabne fuudhii fuula Waaqayyoo duratti dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Ergasiis Israaʼelootaan akkana jedhi: ‘Aarsaa cubbuutiif korbeessa reʼee tokko, aarsaa gubamuuf immoo dibicha tokkoo fi korbeessa hoolaa kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hirʼina hin qabne, ");
INSERT INTO gaz_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","aarsaa nagaatiif immoo sangaa tokkoo fi korbeessa hoolaa tokko, kennaa midhaanii kan zayitiidhaan sukkuumame wajjin fuula Waaqayyoo duratti aarsaa gochuuf dhiʼeessi. Harʼa Waaqayyo isinitti mulʼataatii.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Isaanis waan Museen isaan ajaje sana fuula dunkaana wal gaʼii duratti fidan; waldaan hundinuus dhufee fuula Waaqayyoo dura dhaabate. ");
INSERT INTO gaz_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Museenis, “Akka ulfinni Waaqayyoo isinitti mulʼatuuf wanni Waaqayyo akka isin gootan isin ajaje kana” jedhe. ");
INSERT INTO gaz_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Ergasii Museen Arooniin akkana jedhe; “Gara iddoo aarsaa kottuutii aarsaa cubbuu keetiitii fi aarsaa kee kan gubamu dhiʼeeffadhuutii ofii keetii fi sabaaf araara buusi; akkuma Waaqayyo ajajettis aarsaa sabaa dhiʼeessiitii araara isaaniif buusi.” ");
INSERT INTO gaz_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Aroon gara iddoo aarsaa dhufee dibicha aarsaa kan sababii cubbuu isaatiif dhiʼaate sana qale. ");
INSERT INTO gaz_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ilmaan isaas dhiiga isatti fidan; inni immoo dhiiga sana keessa quba isaa cuuphee gaanfawwan iddoo aarsaa dibe; dhiiga hafe immoo miiloo iddoo aarsaa jalatti dhangalaase. ");
INSERT INTO gaz_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Innis akkuma Waaqayyo Musee ajajetti aarsaa cubbuu sana irraa moora, kaleewwanii fi haguuggii tiruu iddoo aarsaa irratti gube; ");
INSERT INTO gaz_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","foonii fi gogaa isaa immoo qubata keessaa baasee gube. ");
INSERT INTO gaz_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Inni ergasii aarsaa gubamu qale. Ilmaan isaas dhiiga fidanii itti kennan; innis iddoo aarsaa irratti gama hundaan facaase. ");
INSERT INTO gaz_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Isaanis aarsaa gubamu buʼaa buʼaadhaan, mataa wajjin isatti kennan; innis iddoo aarsaa irratti gube. ");
INSERT INTO gaz_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Miʼa garaatii fi luka qalma sanaas dhiqee iddoo aarsaa irratti, aarsaa gubamu gubbaatti gube. ");
INSERT INTO gaz_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Itti aansees Aroon aarsaa sabaa dhiʼeesse; reʼee aarsaa cubbuu sabaatiif dhiʼeeffamu sana fuudhee qale; akkuma duraan hojjetettis aarsaa cubbuu godhee dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Innis aarsaa gubamu fidee akkuma ajajametti dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Kennaa midhaaniis fidee konyee tokko irraa fuudhee aarsaa ganama ganama gubamu irratti dabalee iddoo aarsaa irratti gube. ");
INSERT INTO gaz_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aroonis sangaa fi korbeessa hoolaa sana aarsaa nagaa kan sabaaf jedhamee dhiʼeeffamu godhee qale. Ilmaan isaa immoo dhiiga fidanii isatti kennan; innis dhiiga sana iddoo aarsaa irratti gama hundaan facaase. ");
INSERT INTO gaz_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Cooma sangaatii fi korbeessa hoolaa sanaa jechuunis duboo, moora miʼa garaa haguugu, kaleewwanii fi haguuggii tiruu, ");
INSERT INTO gaz_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","handaraafota irra kaaʼan; Aroonis cooma sana iddoo aarsaa irratti gube. ");
INSERT INTO gaz_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Aroonis akkuma Museen isa ajajetti handaraafotaa fi tafa mirgaa aarsaa sochoofamu godhee fuula Waaqayyoo duratti sochoose. ");
INSERT INTO gaz_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Aroon harka isaa sabatti balʼisee isaan eebbise. Erga aarsaa cubbuu, aarsaa gubamuu fi aarsaa nagaa dhiʼeessee booddees gad buʼe. ");
INSERT INTO gaz_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Musee fi Aroonis dunkaana wal gaʼii seenan; yommuu achii baʼanittis saba eebbisan; ulfinni Waaqayyoos saba hundatti mulʼate. ");
INSERT INTO gaz_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ibiddis Waaqayyo biraa baʼee aarsaa gubamuu fi cooma iddoo aarsaa irra ture sana fixe; sabni hundis waan kana argee ililche; adda isaatiinis gombifamee sagade. ");
INSERT INTO gaz_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ilmaan Aroon jechuunis Naadaabii fi Abiihuu girgiraa isaanii fudhatanii ibidda itti naqanii ixaana irratti firfirsan; isaanis ibidda hin eeyyamamne kan Inni hin ajajin fuula Waaqayyoo duratti dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Kanaafuu ibiddi Waaqayyo biraa baʼee gubee isaan fixe; isaanis fuula Waaqayyoo duratti dhuman. ");
INSERT INTO gaz_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Museenis Arooniin akkana jedhe; “Wanni Waaqayyo dubbate kanaa dha: “ ‘Ani warra natti dhiʼaatan gidduutti, qulqullina koo nan argisiisa; saba hunda durattis ani nan ulfaadha.’ ” Aroon immoo ni calʼise. ");
INSERT INTO gaz_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Museenis Miishaaʼeelii fi Elzaafaan ilmaan Uziiʼeel obboleessa abbaa Aroon sanaa ofitti waamee, “Kottaatii durbiiwwan keessan fuula iddoo qulqulluu duraa fuudhaatii qubata keessaa gad baasaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Jarris dhufanii akkuma Museen ajajetti akkuma isaan kittaa isaanii uffatanii jiranitti fuudhanii qubata keessaa gad isaan baasan. ");
INSERT INTO gaz_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Ergasii Museen Aroonii fi ilmaan Aroon, Eleʼaazaarii fi Iitaamaariin akkana jedhe; “Mataa keessan filachuu hin dhiisinaa; wayyaa keessanis hin tarsaasinaa; yoo kanaa achii isin ni duutu; Waaqayyos saba guutuutti dheekkama. Garuu firoonni keessan manni Israaʼel hundi warra Waaqayyo ibiddaan balleesse sanaaf booʼuu dandaʼu. ");
INSERT INTO gaz_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Sababii zayitiin Waaqayyoo kan ittiin diban isin irra jiruuf isin balbala dunkaana wal gaʼii duraa hin deeminaa; yoo kanaa achii ni duutu.” Isaanis akkuma Museen isaan ajaje godhan. ");
INSERT INTO gaz_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Waaqayyos Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","“Atii fi ilmaan kee yommuu dunkaana wal gaʼii ol seentanitti daadhii wayinii yookaan dhugaatii nama macheessu hin dhuginaa. Yoo kanaa achii ni duutu. Wanni kun dhaloota dhufuuf seera bara baraa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Isin waan qulqulluu fi waan qulqulluu hin taʼin, waan xuraaʼaa fi waan xuraaʼaa hin taʼin addaan baaftanii beekuu qabdu; ");
INSERT INTO gaz_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","seera Waaqayyo karaa Museetiin isaanii kenne hundas saba Israaʼel barsiisuu qabdu.” ");
INSERT INTO gaz_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Museenis Aroonii fi ilmaan Aroon warra hafan jechuunis Eleʼaazaarii fi Iitaamaariin akkana jedhe; “Kennaa midhaanii kan aarsaawwan ibiddaan Waaqayyoof dhiʼeeffaman sana irraa hafe fuudhaatii utuu inni hin bukaaʼin tolchaatii iddoo aarsaa biratti nyaadhaa; aarsaan kun waan hunda caalaa qulqulluudhaatii. ");
INSERT INTO gaz_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Wanni kun aarsaawwan ibiddaan Waaqayyoof dhiʼeeffaman keessaa sababii qooda keetii fi qooda ilmaan keetii taʼeef lafa qulqulluutti nyaadhaa; ani akkana ajajameeraatii. ");
INSERT INTO gaz_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Garuu ati, ilmaan keetii fi intallan kee handaraafa sochoofamee fi tafa dhiʼeeffame sana nyaachuu dandeessu. Waan kanas iddoo seeraan qulqulluu taʼetti nyaadhaa. Wanni kun qooda keetii fi qooda ilmaan keetii taʼee aarsaa nagaa kan saba Israaʼel irraa isiniif kennamee dhaatii. ");
INSERT INTO gaz_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Tafni dhiʼeeffamee fi handaraafni sochoofame sun akka aarsaa sochoofamu tokkootti akka fuula Waaqayyoo duratti sochoofamuuf cooma aarsaa ibiddaan dhiʼeeffame wajjin fidamuu qaba; kunis akkuma Waaqayyo ajajetti qooda keetii fi qooda ilmaan keetii kan bara baraa ti.” ");
INSERT INTO gaz_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Museenis reʼee aarsaa cubbuu sana jabeessee barbaade; kunoo reʼeen sun gubamee ture; innis ilmaan Aroon warra hafanitti jechuunis Eleʼaazaarii fi Iitaamaaritti aaree akkana jedhee isaan gaafate; ");
INSERT INTO gaz_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","“Isin maaliif aarsaa cubbuu sana iddoo qulqulluutti hin nyaatin? Aarsaan sun waan hunda caalaa qulqulluu dha; innis akka isin fuula Waaqayyoo duratti araara isaaniif buusuudhaan yakka sabaa balleessitaniif isiniif kenname. ");
INSERT INTO gaz_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Kunoo, dhiigni isaa Iddoo Qulqulluutti ol hin galfamne; isin akkuma ani ajajetti reʼee sana naannoo Iddoo Qulqulluutti nyaachuu qabdu ture.” ");
INSERT INTO gaz_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aroonis Museedhaan akkana jedhe; “Kunoo, isaan harʼa aarsaa isaanii kan cubbuutii fi aarsaa isaanii kan gubamu fuula Waaqayyoo duratti dhiʼeessaniiru; garuu wanni akkasii kun na qaqqabeera. Utuu ani aarsaa cubbuu sana harʼa nyaadhee jiraadhee silaa wanni sun fuula Waaqayyoo duratti ni fudhatama turee?” ");
INSERT INTO gaz_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Museenis yommuu waan kana dhagaʼetti ni gammade. ");
INSERT INTO gaz_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Waaqayyos Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","“Israaʼelootaan akkana jedhaa: ‘Bineensota lafa irra jiraatan hunda keessaa kanneen isin nyaachuu dandeessan isaan kanaa dha: ");
INSERT INTO gaz_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","Bineensa kotteen isaa guutumaan guutuutti baqaqaa taʼe kan alala guuru kam iyyuu nyaachuu dandeessu. ");
INSERT INTO gaz_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","“ ‘Kanneen alala qofa guuran yookaan kotteen isaanii qofti baqaqaa taʼe garuu nyaachuu hin qabdan. Gaalli yoo alala guure iyyuu kottee baqaqaa hin qabu; inni isiniif qulqulluu miti. ");
INSERT INTO gaz_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Osoleen yoo alala guurte iyyuu kottee baqaqaa hin qabdu; isheen isiniif qulqulluu miti. ");
INSERT INTO gaz_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Illeettiin yoo alala guurte iyyuu kottee baqaqaa hin qabdu; isheen isiniif qulqulluu miti. ");
INSERT INTO gaz_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Booyyeen yoo kottee baqaqaa qabaate iyyuu alala hin guuru; inni isiniif qulqulluu miti. ");
INSERT INTO gaz_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Isin foon isaanii nyaachuu yookaan raqa isaanii tuquu hin qabdan; isaan isiniif qulqulluu miti. ");
INSERT INTO gaz_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","“ ‘Uumamawwan bishaan galaanotaa fi bishaan lageenii keessa jiraatan hunda keessaa kanneen qoochoo fi qola qaban kam iyyuu nyaachuu dandeessu. ");
INSERT INTO gaz_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Garuu uumamawwan galaanotaa fi lageen keessa jiraatan kanneen qoochoo fi qola hin qabne hundi, uumamawwan bishaan keessa munyuuqan hundi yookaan kanneen bishaan keessa jiraatan hundi isiniif xuraaʼoo haa taʼan. ");
INSERT INTO gaz_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Isaan isin duratti xuraaʼoo waan taʼaniif foon isaanii hin nyaatinaa; raqni isaaniis xuraaʼaa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Wanni bishaan keessa jiraatu kan qoochoo fi qola hin qabne kam iyyuu isiniif xuraaʼaa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","“ ‘Isaan kunneen simbirroota isin jibbuu qabdanii dha; hin nyaataman; isaan xuraaʼoo dha: risaa, rumicha, rumicha gurraacha, ");
INSERT INTO gaz_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","culullee, culullee gurraacha gosa garaa garaa, ");
INSERT INTO gaz_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","arraagessa gosa garaa garaa, ");
INSERT INTO gaz_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","guchii, urunguu, allaattii bishaanii, coroffee gosa garaa garaa, ");
INSERT INTO gaz_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","urunguu xinnaa, daakiyyee, urunguu guddaa, ");
INSERT INTO gaz_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","urunguu adii, urunguu gammoojjii, allaattii raqaa, ");
INSERT INTO gaz_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","huummoo, huummoo gosa kamii iyyuu, haadha gaayyee, simbira halkanii. ");
INSERT INTO gaz_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","“ ‘Ilbiisonni barrisan kanneen miilla afraniinuu deeman hundi isiniif xuraaʼoo haa taʼani. ");
INSERT INTO gaz_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Taʼus ilbiisonni barrisan kanneen miilla afraniinuu deeman keessaa tokko tokko nyaachuu ni dandeessu; isaanis warra ittiin lafa irra utaaluuf miilla dadachaʼu qabanii dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Isaan keessaas hawwaannisa gosa garaa garaa, hawwaannisa magariisa garaa garaa, farda waaqaa garaa garaa fi korophisa garaa garaa nyaachuu dandeessu. ");
INSERT INTO gaz_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Garuu ilbiisota barrisan kanneen miilla afur qaban biraa hundi isiniif xuraaʼoo haa taʼan. ");
INSERT INTO gaz_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","“ ‘Isin wantoota kanneeniin of xureessitu; namni raqa isaanii tuqu kam iyyuu hamma galgalaatti xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Namni reeffa isaanii tokko illee lafaa fuudhu kam iyyuu uffata isaa miiccachuu qaba; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","“ ‘Bineensi kottee baqaqaa qabu kan kotteen isaa guutumaan guutuutti gargar hin qoodamin yookaan alala hin guurre kam iyyuu isiniif xuraaʼaa dha; namni raqa isaanii tuqu kam iyyuus xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Bineensota miilla afuriin deeman hunda keessaa kanneen faanaan ejjetan isiniif xuraaʼoo dha; namni raqa isaanii tuqu kam iyyuus hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Namni raqa isaanii lafaa fuudhu kam iyyuu uffata isaa miiccachuu qaba; inni hamma galgalaatti xuraaʼaa taʼa. Isaanis isiniif xuraaʼoo dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","“ ‘Uumamawwan lafa irra munyuuqan keessaa isaan kunneen isiniif xuraaʼoo dha; isaanis: tuqaa, hantuuta, loccuu gurguddaa gosa gosaa, ");
INSERT INTO gaz_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","loccuu cirrachaa, naacha, qarcoo, qarcabboo fi gaararraa dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","Uumamawwan lafa irra munyuuqan keessaa isaan kunneen isiniif xuraaʼoo dha; namni raqa isaanii tuqus hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Uumamawwan sana keessaa tokko yoo duʼee miʼa wayii irra buʼe, miʼi sun faayidaan isaa waan fedhe iyyuu taʼu, inni muka irraa, huccuu irraa, gogaa irraa yookaan keeshaa irraa hojjetamu illee miʼi sun xuraaʼaa taʼa; miʼa sana bishaan keessa buusaa. Innis hamma galgalaatti xuraaʼaa taʼee ergasii immoo qulqulluu taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Isaan keessaa tokko okkotee keessa yoo buʼe, wanni okkotee sana keessa jiru hundi xuraaʼaa taʼa; isinis okkotee sana cabsuu qabdu. ");
INSERT INTO gaz_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Nyaanni nyaatamuu dandaʼu kan garuu bishaan okkotee akkasii keessaa itti naqame kam iyyuu xuraaʼaa dha; dhugaatiin okkotee sana keessaa dhugamuu dandaʼu kam iyyuus xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Wanni raqa uumamawwan kanaa keessaa tokko iyyuu irra buʼu kam iyyuu xuraaʼaa taʼa; eeleen yookaan okkoteen waa itti bilcheessan cabsamuu qaba. Isaan xuraaʼoo dha; isinis akka miʼa xuraaʼaatti isaan ilaalaa. ");
INSERT INTO gaz_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Burqaan yookaan boolli bishaan itti kuufamu immoo qulqulluu taʼee tura; garuu namni raqa kana keessaa tokko illee tuqu xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Raqni tokko sanyii facaafamuuf jiru irra yoo buʼe sanyiin sun qulqulluu taʼee hafa. ");
INSERT INTO gaz_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Garuu sanyii sana irratti bishaan naqamee raqni wayii yoo irra buʼe sanyiin sun isiniif xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","“ ‘Horiin akka isin nyaattaniif isiniif eeyyamame tokko yoo duʼe, namni raqa isaa tuqe kam iyyuu hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Namni raqa sana irraa waa nyaatu wayyaa isaa miiccachuu qaba; inni hamma galgalaatti xuraaʼaa taʼa. Namni raqa sana lafaa fuudhe wayyaa isaa miiccadhuu qaba; innis hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","“ ‘Uumamni lafa irra munyuuqu kam iyyuu xuraaʼaa dha; nyaatamuus hin qabu. ");
INSERT INTO gaz_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Uumama lafa irra looʼu kan garaadhaan lafa irra looʼu yookaan miilla afuriin yookaan miilla hedduun deemu kam iyyuu hin nyaatinaa; inni xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Uumamawwan kanneen keessaa tokkoon iyyuu of hin xureessinaa. Isin akka xuraaʼoo hin taaneef isaaniin of hin xureessinaa. ");
INSERT INTO gaz_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ani Waaqayyo Waaqa keessanii dha; waan ani qulqulluu taʼeef isinis of qulqulleessaatii qulqulloota taʼaa. Uumama lafa irra munyuuqu kamiin iyyuu of hin xureessinaa. ");
INSERT INTO gaz_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ani Waaqayyo kan Waaqa keessan taʼuuf jedhee biyya Gibxiitii isin baasee dha; kanaafuu ani qulqulluudhaatii isinis qulqulluu taʼaa. ");
INSERT INTO gaz_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","“ ‘Seerri waaʼee horii, simbirroo, lubbuu qabeeyyii bishaan keessa munyuuqan hundaa fi uumama lafa irra munyuuqu hundaa kanaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Isin waan xuraaʼaa fi waan qulqulluu, uumama nyaatamuu fi kan hin nyaatamne addaan baaftanii beekuu qabdu.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","“Israaʼelootaan akkana jedhi: ‘Dubartiin ulfooftee ilma deessee jirtu akka seeraatti akkuma yeroo xurii of irraa qabdu sanaatti bultii torbaaf xurooftuu taati. ");
INSERT INTO gaz_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Ilmi sunis guyyaa saddeettaffaatti dhagna haa qabatu. ");
INSERT INTO gaz_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Ergasiis dubartiin sun dhiiga ishee irraa qulqulleeffamuuf bultii soddomii sadii eeggachuu qabdi. Ishee hamma yeroon qulqulleeffamuu ishee raawwatamutti waan qulqulluu hin tuqin yookaan gara iddoo qulqulluu hin dhaqin. ");
INSERT INTO gaz_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Isheen yoo durba deessee jiraatte akkuma yeroo xurii of irraa qabdu sanaatti torban lamaaf xurooftuu taati; ergasii immoo dhiiga ishee irraa qulqulleeffamuuf bultii jaatamii jaʼa eeggachuu qabdi. ");
INSERT INTO gaz_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","“ ‘Isheen gaafa yeroon qulqulleeffamuu ishee kan sababii ilmaa yookaan intalaa raawwatamutti, xobbaallaa hoolaa kan waggaa tokkoo aarsaa gubamuuf, gugee sookkee tokko yookaan gugee tokko aarsaa cubbuutiif balbala dunkaana wal gaʼii duratti gara lubaa haa fiddu. ");
INSERT INTO gaz_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Innis isheedhaaf araara buusuuf jedhee waan kana fuula Waaqayyoo duratti aarsaa dhiʼeessa; isheenis ergasii akka seeraatti dhangalaʼaa dhiiga ishee irraa qulqulloofti. “ ‘Seerri dubartii ilma yookaan durba deessuu kanaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","Isheen yoo xobbaallaa hoolaa fiduu hin dandeenye, gugee lama yookaan gugee sosookkee lama, tokko aarsaa gubamuuf kaan immoo aarsaa cubbuutiif haa fiddu. Haala kanaan lubichi isheedhaaf araara buusa; isheenis ni qulqulloofti.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Waaqayyos Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","“Namni yoo gogaa dhagna isaa irraa iitoo yookaan finniisa yookaan baarolee qabaatee wanni sun gogaa dhagna isaa irratti gara lamxiitti geeddarame, namichi sun gara Aroon lubichaatti yookaan ilmaan isaa luboota keessaa gara isa tokkootti haa geeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Lubni sun madaa gogaa dhagna namichaa irra jiru haa qoru; yoo rifeensi madaa sana irra jiru addaatee madaan sun gogaa keessa darbee foonitti gad seene, dhukkubni sun dhukkuba lamxii ti. Lubichis erga isa qoree booddee akka inni akka seeraatti xuraaʼaa taʼe haa labsu. ");
INSERT INTO gaz_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Yoo baaroleen gogaa namichaa irra jiru addaatee garuu gogaa keessa darbee foonitti gad hin seenin, yoo rifeensi madaa sana irra jirus hin addaatin, lubichi namicha madaaʼe sana bultii torba kophaatti baasee haa tursu. ");
INSERT INTO gaz_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Bultii torbaffaatti immoo lubichi isa haa qoru; lubni yoo akka madaan sun hin geeddaraminii fi akka inni gogaa namichaa irra hin faffacaʼin arge ammas bultii torba kophaatti baasee isa haa tursu. ");
INSERT INTO gaz_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Amma illee lubichi bultii torbaffaatti namicha haa qoru; kunoo, yoo madaan sun qooree gogaa irra hin faffacaʼin, lubichi akka namichi qulqulluu taʼe haa labsu; wanni sun cittoo dha. Namichi wayyaa isaa haa miiccatu; inni ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Garuu inni erga qulqulluu taʼuun isaa akka labsamuuf lubatti of argisiisee booddee yoo cittoon sun gogaa isaa irra faffacaʼe inni amma illee lubatti of argisiisuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Lubichis isa haa qoru; yoo cittoon sun gogaa irra faffacaʼee jiraate lubichi akka inni xuraaʼaa taʼe haa labsu; wanni kun lamxii dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","“Namni yoo lamxii qabaate inni lubatti fidamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Lubichi isa haa qoru; kunoo yoo iiti adiin kan rifeensa addeesse gogaa irra jiraatee fi foon iita sanaa diimatee mulʼate, ");
INSERT INTO gaz_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","wanni sun dhukkuba gogaa kan hin fayyinee dha; lubichis akka namichi xuraaʼaa taʼe haa labsu. Waan inni duraanuu xuraaʼaa taʼeef lubichi kophaatti baasee isa tursuun barbaachisaa miti. ");
INSERT INTO gaz_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","“Dhukkubni sun hamma lubni arguu dandaʼutti gogaa isaa irra yoo faffacaʼee gogaa namicha madaaʼe sanaa mataadhaa hamma miillaatti haguuge, ");
INSERT INTO gaz_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","lubichi isa haa qoru; kunoo yoo dhukkubni sun guutumaan guutuutti dhagna namichaa wal gaʼe inni akka namichi qulqulluu taʼe haa labsu. Waan dhagni isaa guutuun addaateef namichi sun qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Inni garuu yeroo iita foon isaa keessaan diimatee mulʼatu qabaatu xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Lubichi yeroo foon diimatee mulʼatu argutti akka namichi sun xuraaʼaa taʼe haa labsu; foon diimate xuraaʼaa dha; namichis lamxii qaba. ");
INSERT INTO gaz_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Yookaan yoo foon diimaan geeddaramee addaate namichi lubatti of argisiisuu haa dhaqu. ");
INSERT INTO gaz_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Lubnis isa haa qoru; yoo madaan sun addaate lubichi akka namichi madaaʼe sun qulqulluu taʼe haa labsu; namichis ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","“Namni gogaa isaa irraa dhullaa yoo qabaatee dhullaan sun fayyee jiraate, ");
INSERT INTO gaz_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","yoo iddoo dhullaan ture sanatti iiti adiin yookaan baaroleen diimaan adiin mulʼate inni lubatti of haa argisiisu. ");
INSERT INTO gaz_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Lubnis isa haa qoru; kunoo yoo wanni sun waan gogaa keessa darbee foon seene fakkaatee rifeensi isa keessaas addaate lubichi akka inni xuraaʼaa taʼe haa labsu. Wanni kun dhukkuba lamxii iddoo dhullaan turetti baʼee dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Garuu yommuu lubni baarolee sana qorutti, kunoo yoo rifeensi adiin irra hin jiraatinii fi yoo baaroleen sun utuu gogaa darbee foon hin seenin qooree jiraate lubni kophaatti baasee bultii torba isa haa tursu. ");
INSERT INTO gaz_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Yoo baaroleen sun gogaa irra faffacaʼe, lubichi akka namni sun xuraaʼaa taʼe haa labsu; kun dhukkuba namatti darbuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Garuu baaroleen sun yoo hin geeddaraminii fi yoo hin faffacaʼin, inni godaannisa dhullaa sanaa ti; lubnis akka namichi qulqulluu taʼe haa labsu. ");
INSERT INTO gaz_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","“Yoo namni gogaa isaa irraa gubaa qabaatee foon diimaa iddoo gubamaa sanaa irratti baaroleen diimaan adiin yookaan adiin mulʼate, ");
INSERT INTO gaz_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","lubni baarolee sana haa qoru; kunoo yoo rifeensi achi irra jiru addaatee baaroleen sunis gogaa keessa darbee foon seene wanni kun lamxii iddoo gubate sana irratti baʼuu dha. Lubichi akka namni sun xuraaʼaa taʼe haa labsu; dhukkubni kun dhukkuba lamxii ti. ");
INSERT INTO gaz_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Garuu yoo lubni iddoo gubate sana qoree rifeensi adiin baarolee sana irra hin jiraatinii fi yoo baaroleen sun utuu gogaa keessa darbee foon hin seenin qooree jiraate lubichi namicha sana kophaatti baasee bultii torba haa tursu. ");
INSERT INTO gaz_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Guyyaa torbaffaatti lubichi isa haa qoru; yoo baaroleen sun gogaa irra faffacaʼee jiraate lubni sun akka namichi xuraaʼaa taʼe haa labsu; dhukkubni kun dhukkuba lamxii ti. ");
INSERT INTO gaz_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Taʼus yoo baaroleen sun hin geeddaraminii fi utuu gogaa irra hin faffacaʼin bade wanni kun iitoo gubaa sana keessa baʼee dha. Lubichi akka namichi qulqulluu taʼe haa labsu; wanni kun godaannisa gubaa sanaa ti. ");
INSERT INTO gaz_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","“Yoo dhiirri yookaan dubartiin mataa irraa yookaan areeda irraa madaa qabaatan, ");
INSERT INTO gaz_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","lubni madaa sana haa qoru; kunoo yoo madaan sun gogaa keessa darbee foon seenee rifeensi achi irra jiru keelloo fakkaatee qaqalʼate, lubichi akka namichi sun xuraaʼaa taʼe haa labsu; kun hooqxoo mataa yookaan areedaa kan namatti darbuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Garuu yeroo lubni madaa akkanaa qorutti kunoo yoo madaan sun waan gogaa darbee foon seene hin fakkaatinii fi yoo rifeensi gurraachi tokko iyyuu madaa sana irra hin jiraatin lubni sun namicha hooqxoon qabe sana kophaatti baasee bultii torba haa tursu. ");
INSERT INTO gaz_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Guyyaa torbaffaatti lubni madaa sana haa qoru; kunoo yoo hooqxoon sun hin faffacaʼin, yoo rifeensi keelloon achi irra hin jiraatinii fi hooqxoon sun waan gogaa keessa darbee foon seene hin fakkaatin, ");
INSERT INTO gaz_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","namichi sun iddoo madaaʼe sana qofa dhiisee mataa isaa haa haadatu; lubni sunis ammas namicha sana kophaatti baasee bultii torba haa tursu. ");
INSERT INTO gaz_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Guyyaa torbaffaattis lubni sun hooqxoo sana haa qoru; kunoo yoo hooqxoon sun gogaa irra hin faffacaʼinii fi waan gogaa keessa darbee foon seene hin fakkaatin lubichi akka namichi sun qulqulluu taʼe haa labsu; namichi wayyaa isaa haa miiccatu; innis ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Garuu erga akka namichi qulqulluu taʼe labsamee booddee yoo hooqxoon sun gogaa irra faffacaʼe, ");
INSERT INTO gaz_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","lubni isa haa qoru; kunoo yoo hooqxoon sun gogaa irra faffacaʼee jiraate lubichi rifeensa keelloo sakattaʼuu hin qabu; namichi sun xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Garuu akka hubannaa lubichaatti hooqxoon sun geeddaramuu baatee rifeensi gurraachi irratti biqillaan hooqxoon sun fayyeera; namichis qulqulluu dha; lubnis akka inni qulqulluu taʼe haa labsu. ");
INSERT INTO gaz_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","“Yommuu dhiirri yookaan dubartiin gogaa dhagna isaa irraa baarolee qabaatanitti, ");
INSERT INTO gaz_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","lubni isaan haa qoru; kunoo yoo baaroleen sun adii daalacha taʼe kun cittoo gogaa irratti baʼe kan nama hin miinee dha; namichis qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","“Namni yoo rifeensi mataa isaa dhumee molaaʼe inni qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Yoo rifeensi mataa isaa fuula duraan irraa dhumee molaaʼes inni qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Garuu inni yoo moluu mataa isaa irraa yookaan moluu adda isaa irraa madaa adii diimatu qabaate wanni kun lamxii moluu mataa isaa yookaan moluu adda isaa keessaa baʼuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Lubni isa haa qoru; kunoo yoo madaan iitaʼe kan mataa isaa irraa yookaan adda isaa irraa sun akkuma lamxii gogaa irratti baʼee adii diimatu taʼe, ");
INSERT INTO gaz_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","namichi dhukkubsataa fi xuraaʼaa dha. Sababii madaa mataa namichaa irra jiru sanaatiifis akka namichi xuraaʼaa taʼe lubni sun haa labsu. ");
INSERT INTO gaz_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","“Namni lamxii akkasii qabu uffata tatarsaʼaa haa uffatu; rifeensa mataa isaatti waa hin maratin; afaan isaas haguuggatee, ‘Ani xuraaʼaa dha! Ani xuraaʼaa dha!’ jedhee haa iyyu. ");
INSERT INTO gaz_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Inni hamma dhukkubni sun irra jirutti xuraaʼaa dha; kophaa isaa haa jiraatu; qubata keessaas baʼee ala haa jiraatu. ");
INSERT INTO gaz_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","“Yoo uffanni suufii irraa yookaan quncee talbaa irraa hojjetame kam iyyuu, ");
INSERT INTO gaz_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","uffanni quncee talbaa irraa yookaan suufii irraa dhaʼame yookaan wal keessa loofamee hojjetame kam iyyuu, gogaan yookaan wanni gogaa irraa hojjetame kam iyyuu lamxii qabaate, ");
INSERT INTO gaz_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","yoo dhukkubni uffata irra yookaan gogaa irra yookaan uffata dhaʼame irra yookaan wal keessa loofamee hojjetame irra yookaan miʼa gogaa irra jiru sun magariisa taʼe yookaan diimate wanni kun waan lamxii taʼeef lubatti haa argisiifamu. ");
INSERT INTO gaz_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Lubnis lamxii sana qoree miʼa dhukkubaan faalame sana kophaatti baasee bultii torba haa tursu. ");
INSERT INTO gaz_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Guyyaa torbaffaatti lubichi lamxii sana haa qoru; yoo lamxiin sun uffata irra yookaan wayyaa dhaʼame irra yookaan uffata wal keessa loofamee hojjetame irra yookaan gogaa waan kamiif iyyuu fayyadu irra faffacaʼe wanni kun lamxii hamaa dha; miʼi sunis xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Sababii lamxiin sun hamaa taʼeef lubichi uffata yookaan wayyaa suufii irraa yookaan quncee talbaa irraa hojjetame yookaan wal keessa loofamee hojjetame yookaan miʼa gogaa irraa hojjetame kan dhukkuba sanaan faalame kam iyyuu haa gubu; miʼi sunis gubamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","“Garuu yeroo lubni lamxii sana qorutti kunoo yoo lamxiin sun uffata irra yookaan wayyaa dhaʼame irra yookaan wal keessa loofamee hojjetame irra yookaan miʼa gogaa irraa hojjetame irra faffacaʼuu baate, ");
INSERT INTO gaz_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","lubichi akka miʼi lamxiidhaan faalame sun miiccamu haa ajaju. Ergasii immoo miʼa sana kophaatti baasee ammas bultii torba haa tursu. ");
INSERT INTO gaz_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Erga miʼi lamxiidhaan faalame sun miiccamee booddee lubichi miʼa sana haa qoru; lamxiin sun yoo faffacaʼu baate illee bifti isaa geeddaramuu baannaan uffanni sun xuraaʼaa dha. Yoo lamxiin sun gama tokkoon yookaan gama kaaniin miʼa sana faalee jiraate, miʼi sun ibiddaan haa gubamu. ");
INSERT INTO gaz_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Erga miʼi sun miiccamee booddee yeroo lubni qorutti yoo lamxiin sun badee jiraate lubichi iddoo lamxiidhaan faalame sana uffata yookaan gogaa yookaan wayyaa dhaʼame yookaan wal keessa loofamee hojjetame irraa haa tarsaasu. ");
INSERT INTO gaz_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Garuu yoo lamxiin sun deebiʼee uffata irratti yookaan wayyaa dhaʼame irratti yookaan wal keessa loofame hojjetame irratti yookaan miʼa gogaa irraa hojjetame kam iyyuu irratti argame, lamxiin sun faffacaʼaa jira; wanni lamxii qabu ibiddaan haa gubamu. ");
INSERT INTO gaz_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Uffanni yookaan wayyaan dhaʼame yookaan wal keessa loofamee hojjetame yookaan miʼi gogaa irraa hojjetame kan miiccamee lamxiin irraa bade kam iyyuu ammas haa miiccamu; innis ni qulqullaaʼa.” ");
INSERT INTO gaz_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Wanni kun seera akka uffanni suufii irraa yookaan quncee talbaa irraa hojjetame, wayyaan dhaʼame yookaan wal keessa loofamee hojjetame yookaan miʼi gogaa irraa hojjetamee lamxiidhaan faalame kam iyyuu xuraaʼaa taʼee fi akka hin taʼin labsuuf kennamee dha. ");
INSERT INTO gaz_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","“Kun seera nama lamxii qabu tokkoof guyyaa inni itti qulqulleeffamuuf kennamee dha; namichi lubatti haa fidamu. ");
INSERT INTO gaz_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Lubni sun iddoo qubataa keessaa gad baʼee namicha haa qoru. Kunoo, yoo namichi lamxii qabu sun fayyee jiraate, ");
INSERT INTO gaz_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","lubichi akka sababii namicha qulqulleeffamu sanaatiif simbirroonni lubbuu qaban qulqulluun lamaa fi mukni birbirsaa, kirriin bildiimaa fi hiisophiin fidaman haa ajaju. ");
INSERT INTO gaz_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Lubni sunis ergasii akka simbirroota sana keessaa isheen tokko bishaan yaaʼu kan okkotee keessa jiru irratti qalamtu haa ajaju. ");
INSERT INTO gaz_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Innis simbirroo lubbuu qabdu sana fuudhee muka birbirsaa, kirrii bildiimaa fi hiisophii wajjin dhiiga simbirroo bishaan yaaʼu irratti qalamte sanaa keessa haa cuuphu. ");
INSERT INTO gaz_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Lubichi namicha lamxii irraa qulqulleeffamu sanatti yeroo torba faffacaasee akka inni qulqulluu taʼe haa labsu; ergasii simbirroo lubbuu qabdu sana dirreetti gad haa dhiisu. ");
INSERT INTO gaz_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","“Namichi qulqulleeffamu sun uffata isaa miiccachuu, rifeensa isaa hunda haaddachuu fi dhagna isaa bishaaniin dhiqachuu qaba; akkasiin inni akka seeraatti qulqulluu taʼa. Ergasii iddoo qubataatti ol galuu dandaʼa; garuu bultii torba dunkaana isaatiin ala turuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Guyyaa torbaffaattis rifeensa isaa hunda haaddachuu qaba; mataa isaa, areeda isaa, nyaara isaatii fi rifeensa isaa biraa haa haaddatu. Uffata isaas miiccatee dhagna isaa bishaaniin dhiqachuu qaba; innis ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","“Guyyaa saddeettaffaattis namichi sun korbeeyyii hoolaa kanneen hirʼina hin qabne lamaa fi hoolaa dhalaa waggaa tokkoo kan hirʼina hin qabne tokko, daakuu bullaaʼaa iifii tokkoo kan zayitiidhaan sukkuumame irraa harka kudhan keessaa harka sadii kan kennaa midhaaniitiif taʼuu fi zayitii loogii tokkoo haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Lubni akka namichi qulqulluu taʼe labsu sun namicha qulqulleefamu sanaa fi kennaawwan isaa balbala dunkaana wal gaʼii irratti fuula Waaqayyoo duratti haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","“Ergasiis lubichi korbeeyyii hoolaa sana keessaa tokko fuudhee aarsaa yakkaa godhee loogii zayitii tokko wajjin haa dhiʼeessu; innis aarsaa sochoofamu godhee fuula Waaqayyoo duratti haa sochoosu. ");
INSERT INTO gaz_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Xobbaallaa hoolaa sanas iddoo aarsaan cubbuutii fi aarsaan gubamu itti qalamanitti haa qalu. Akkuma aarsaa cubbuu sana aarsaan yakkaas kan lubaa ti; aarsaan kun waan hunda caalaa qulqulluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Lubichis dhiiga aarsaa yakkaa sana irraa fuudhee fiixee gurra mirgaa namicha qulqulleeffamu sanaa, quba abbuudduu harka isaa mirgaatii fi quba abbuudduu miilla isaa mirgaa haa dibu. ");
INSERT INTO gaz_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Lubni sun zayitii loogii sana irraa fuudhee barruu harka isaa bitaatti haa naqu; ");
INSERT INTO gaz_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","quba harka isaa mirgaas zayitii barruu harka isaa irra jiru keessa cuuphee quba isaatiin yeroo torba fuula Waaqayyoo duratti haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Lubni sun zayitii barruu isaa irratti hafe irraa fuudhee fiixee gurra mirgaa namicha qulqulleeffamuu qabu sanaa, quba abbuudduu harka isaa mirgaatii fi quba abbuudduu miilla isaa mirgaa, dhiiga aarsaa yakkaa sana irratti dabalee haa dibu. ");
INSERT INTO gaz_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Lubichi zayitii barruu harka isaa irratti hafe immoo mataa namicha qulqulleeffamuu sanaatti naqee fuula Waaqayyoo duratti araara haa buusuuf. ");
INSERT INTO gaz_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","“Ergasiis lubichi aarsaa cubbuu dhiʼeessee namicha xuraaʼummaa ofii irraa qulqulleeffamu sanaaf araara haa buusu. Sana booddee lubni sun aarsaa gubamu haa qalu; ");
INSERT INTO gaz_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","kanas kennaa midhaanii wajjin iddoo aarsaa irratti dhiʼeessee araara isaaf haa buusu; namichis qulqulluu taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","“Taʼus namichi sun yoo hiyyeessa taʼee waan kana dhiʼeessuu hin dandeenye, akka sochoofamee araarri isaaf buufamuuf inni xobbaallaa hoolaa tokko aarsaa yakkaa godhee daakuu bullaaʼaa zayitiidhaan sukkuumame kan kennaa midhaaniitiif taʼu iifii tokko irraa harka kudhan keessaa harka tokko zayitii loogii tokko wajjin haa fidu; ");
INSERT INTO gaz_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","akkasumas waan fiduu dandaʼu jechuunis gugee lama yookaan gugee sosookkee lama, tokko aarsaa cubbuutiif kaan immoo aarsaa gubamuuf haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","“Guyyaa saddeettaffaatti inni qulqullaaʼummaa isaatiif balbala dunkaana wal gaʼii irratti fuula Waaqayyoo duratti waan kana lubatti haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Lubni sunis xobbaallaa hoolaa aarsaa yakkaa sana zayitii loogii tokko wajjin fuudhee aarsaa sochoofamu godhee fuula Waaqayyoo duratti haa sochoosu. ");
INSERT INTO gaz_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Xobbaallaa hoolaa sanas aarsaa yakkaatiif qalee dhiiga isaa irraa fuudhee fiixee gurra mirgaa namicha qulqulleeffamu sanaa, quba abbuudduu harka isaa mirgaatii fi quba abbuudduu miilla isaa mirgaa haa dibu. ");
INSERT INTO gaz_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Lubichis zayitii sana irraa fuudhee barruu harka isaa bitaa irratti haa naqu; ");
INSERT INTO gaz_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","quba harka isaa mirgaatiinis zayitii barruu isaa irra jiru sana irraa yeroo torba fuula Waaqayyoo duratti haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Zayitii barruu isaa irra jiru irraa fuudhee idduma dhiiga aarsaa yakkaa ittiin tuqe sana jechuunis fiixee gurra namicha qulqulleeffamu sanaa mirgaa, quba abbuudduu harka isaa mirgaatii fi quba abbuudduu miilla isaa mirgaa haa dibu. ");
INSERT INTO gaz_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Lubichis fuula Waaqayyoo duratti araara isaaf buusuuf zayitii barruu isaa irratti hafe sana mataa namicha qulqulleeffamu sanaa irratti haa naqu. ");
INSERT INTO gaz_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Lubni sunis gugeewwan yookaan gugee sosookkee namichi dhiʼeessuu dandaʼu haa dhiʼeessu; ");
INSERT INTO gaz_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","isaan kanneen keessaas tokko aarsaa cubbuutiif, kaan immoo aarsaa gubamuuf, kennaa midhaanii wajjin haa dhiʼeessu. Haala kanaanis lubichi namicha qulqulleeffamu sanaaf fuula Waaqayyoo duratti araara ni buusa.” ");
INSERT INTO gaz_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Kun seera nama lamxii qabaatee waan ittiin qulqulleeffamu baasuu hin dandeenyeef kennamee dha. ");
INSERT INTO gaz_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Waaqayyos Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","“Yommuu isin biyya Kanaʼaan kan ani akka dhaalaatti isiniif kennu sana seentanii anis mana biyya sanaa keessaa tokkotti dhukkuba lamxii facaasutti, ");
INSERT INTO gaz_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","abbaan mana sanaa deemee, ‘Ani mana koo keessatti waan lamxii fakkaatu tokko argeera’ jedhee lubatti haa himu. ");
INSERT INTO gaz_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Lubichis akka wanni mana sana keessa jiru tokko iyyuu xuraaʼaa dha jedhamee hin labsamneef utuu lamxii sana qoruuf ol hin seenin dura akka mana sana keessaa miʼi gad baafamu haa ajaju. Ergasii lubichi ol seenee manicha haa qoru. ");
INSERT INTO gaz_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Innis lamxii keenyan manaa irra jiru haa qoru; yoo wanni sun dhooqa magariisa yookaan diimatu qabaatee keenyan manaa keessa gad seene, ");
INSERT INTO gaz_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","lubichi mana sana keessaa balbalaan gad baʼee bultii torbaaf mana sana haa cufu. ");
INSERT INTO gaz_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Guyyaa torbaffaatti lubichi mana sana qoruuf haa deebiʼu. Kunoo yoo lamxiin sun keenyan manaa irratti babalʼatee jiraate, ");
INSERT INTO gaz_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","lubichi akka dhagaawwan faalaman achi keessaa baafamanii lafa xuraaʼaa magaalaan ala jirutti gataman haa ajaju. ");
INSERT INTO gaz_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Akka keenyan mana sanaa karaa keessaatiin guutummaatti soqamee wanni irraa hooqame sunis lafa xuraaʼaa magaalaan ala jirutti gad gatamu haa godhu. ");
INSERT INTO gaz_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Iddoo dhagaawwan sun hooqamanii baʼan sanas dhagaawwan haaraa fidanii iddoo haa buusan; dhoqqee haaraadhaanis manicha haa maragan. ");
INSERT INTO gaz_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","“Yoo lamxiin sun erga dhagaawwan baʼanii manichi hooqamee maragamee booddee deebiʼee mana keessatti mulʼate, ");
INSERT INTO gaz_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","lubichi dhaqee haa qoru; lamxiin sun kunoo yoo mana keessa babalʼatee jiraate, kun lamxii hamaa dha; manichis xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Manni sun haa diigamu; dhagaan isaa, mukni isaa akkasumas maraggiin isaa hundinuu lafa xuraaʼaa magaalaan ala jirutti haa gatamu. ");
INSERT INTO gaz_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","“Namni yoo utuu manichi cufamee jiruu ol seene, namni sun hamma galgalaatti xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Namni mana sana seenee rafe yookaan keessatti waa nyaate uffata isaa haa miiccatu. ");
INSERT INTO gaz_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","“Garuu yoo lubni lamxii sana qoruudhaaf dhufee erga manichi maragamee booddee lamxiin sun babalʼachuu baate waan lamxiin sun badeef lubni sun akka manni sun qulqullaaʼe haa labsu. ");
INSERT INTO gaz_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Innis manicha qulqulleessuuf simbirroo lama, muka birbirsaa, kirrii bildiimaa fi hiisophii haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Innis simbirroo sana keessaa tokko bishaan yaaʼu kan okkotee keessa jiru irratti haa qalu. ");
INSERT INTO gaz_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Ergasiis birbirsaa, hiisophii, kirrii bildiimaa fi simbirroo lubbuu qabdu sana fuudhee dhiiga simbirroo qalamtee fi bishaan yaaʼu keessa cuuphee yeroo torba mana sanatti haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Innis dhiiga simbirrootiin, bishaan yaaʼuun, simbirroo jirtuun, birbirsaan, hiisophii fi kirrii bildiimaadhaan manicha haa qulqulleessu. ");
INSERT INTO gaz_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Simbirroo jirtuu immoo magaalaan alatti baasee dirreetti gad haa dhiisu. Haala kanaanis manichaaf araara buusa; manichis ni qulqullaaʼa.” ");
INSERT INTO gaz_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Kun seera dhukkuba lamxiitii fi hooqxoodhaaf, ");
INSERT INTO gaz_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","lamxii wayyaa irratti yookaan mana keessatti mulʼatuuf, ");
INSERT INTO gaz_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","iitoodhaaf, finniisaaf yookaan baaroleedhaaf, ");
INSERT INTO gaz_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","akka wanni tokko qulqulluu yookaan xuraaʼaa taʼe addaan baasuuf kennamee dha. Kun seera lamxiidhaaf kennamee dha. ");
INSERT INTO gaz_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Waaqayyo Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","“Akkana jedhaatii Israaʼelootatti himaa; ‘Namni kam iyyuu dhangalaʼaa saala isaa keessaa baʼu yoo qabaate, inni sababii dhangalaʼaa sanaatiifuu xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Dhangalaʼaan sun ittuma fufee saala isaa keessaa baʼus dhaabatus namicha inuma xureessa. Akki itti dhangalaʼaan saala isaa keessaa baʼu sun isa xureessus kanaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","“ ‘Sireen namni dhangalaʼaan saala isaa keessaa baʼu irra ciisu hundinuu xuraaʼaa taʼa; wanni inni irra taaʼu hundinuus xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Namni siree namicha sanaa tuqu uffata isaa haa miiccatu; dhagna isaa bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Namni waan namichi dhangalaʼaan saala isaa keessaa baʼu sun irra taaʼe irra taaʼu kam iyyuu uffata isaa haa miiccatu; dhagna isaas bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","“ ‘Namni nama dhangalaʼaan saala isaa keessaa baʼu sana tuqu uffata isaa haa miiccatu; dhagna isaas bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","“ ‘Yoo namni dhangalaʼaan saala isaa keessaa baʼu sun nama qulqullaaʼaa kamitti iyyuu tufe, namichi itti tufame sun uffata isaa haa miiccatu; dhagna isaa bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","“ ‘Kooraan namni dhangalaʼaan saala isaa keessaa baʼu sun irra taaʼu hundinuu xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Namni waan isa jala ture tuqu kam iyyuu hamma galgalaatti xuraaʼaa taʼa. Namni isaan kanneen lafaa fuudhu uffata isaa haa miiccatu; dhagna isaa bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","“ ‘Namni namichi dhangalaʼaan saala isaa keessaa baʼu sun utuu harka isaa bishaaniin hin dhiqatin tuqu kam iyyuu uffata isaa haa miiccatu; dhagna isaa bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","“ ‘Okkoteen suphee kan namni dhangalaʼaan saala isaa keessaa baʼu sun tuqu haa caccabsamu; miʼi muka irraa hojjetame kam iyyuu bishaaniin haa dhiqamu. ");
INSERT INTO gaz_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","“ ‘Namni yommuu dhangalaʼaan saala isaa keessaa baʼu irraa qulqulleeffamutti akka seeraatti qulqulleeffamuu isaatiif bultii torba haa lakkaaʼatu; uffata isaa haa miiccatu; dhagna isaas bishaan yaaʼuun haa dhiqatu; innis ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Innis guyyaa saddeettaffaatti gugee lama yookaan gugee sosookkee lama qabatee fuula Waaqayyoo dura dhufee balbala dunkaana wal gaʼii irratti lubatti haa kennu. ");
INSERT INTO gaz_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Lubichis isa tokko aarsaa cubbuutiif kaan immoo aarsaa gubamuuf haa dhiʼeessu. Haala kanaanis lubni sun sababii dhangalaʼaa nama sanaatiif fuula Waaqayyoo duratti araara buusa. ");
INSERT INTO gaz_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","“ ‘Namni tokko yommuu afeetaa dhangalaasutti dhagna isaa guutuu bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Uffanni yookaan itilleen afeetaan tuqu kam iyyuu bishaaniin haa miiccamu; miʼi sun hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Namni yoo niitii tokko wajjin ciisee afeetaa dhangalaase, lamaan isaanii iyyuu bishaaniin dhagna isaanii haa dhiqatan; isaan hamma galgalaatti xuraaʼoo taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","“ ‘Dubartiin yoo dhangalaʼaa dhiigaa kan yeroo isaa eeggatee dhagna ishee keessaa baʼu qabaatte, isheen xuraaʼummaa xurii jiʼaa isheetiin bultii torba turti; namni ishee tuqu kam iyyuu hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","“ ‘Wanni isheen yeroo xurii isheetti irra ciiftu xuraaʼaa taʼa; wanni isheen irra teessu kam iyyuus xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Namni siree ishee tuqu uffata isaa haa miiccatu; dhagna isaas bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Namni waan isheen irra teessu tuqu uffata isaa haa miiccatu; dhagna isaas bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Namni yoo sirees taʼu waan isheen irra taaʼaa turte kam iyyuu tuqe inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","“ ‘Namni yoo ishee wajjin ciisee xuraaʼummaan ishee isa tuqe, inni bultii torba xuraaʼaa taʼa; sireen inni irra ciisu kam iyyuus xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","“ ‘Dubartiin tokko yoo yeroo xurii jiʼaa ishee malee guyyaa baayʼeedhaaf dhangalaʼa dhiigaa qabaatte yookaan yoo dhangalaʼa dhiigaa kan yeroo xurii ishee booddees ittuma fufu qabaatte isheen akkuma yeroo xurii ishee sanatti hamma dhangalaʼaan sun jirutti xurooftuu taati. ");
INSERT INTO gaz_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Sireen isheen yeroo dhangalaʼaan ishee ittuma fufee yaaʼutti irra ciiftu akkuma siree ishee kan yeroo xurii jiʼaa ishee sanaatti xuraaʼaa taʼa; wanni isheen irra teessu kam iyyuu akkuma yeroo xurii isheetti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Namni isaan tuqu kam iyyuu ni xuraaʼa; inni uffata isaa haa miiccatu; dhagna isaas bishaaniin haa dhiqatu; inni hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","“ ‘Isheen erga dhangalaʼaa ishee irraa qulqullooftee booddee guyyaa torba haa lakkaaʼattu; ergasii immoo akka seeraatti ni qulqulloofti. ");
INSERT INTO gaz_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Isheenis guyyaa saddeettaffaatti gugee lama yookaan gugee sosookkee lama fuutee, balbala dunkaana wal gaʼii irratti lubatti haa fiddu. ");
INSERT INTO gaz_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Lubichis isa tokko aarsaa cubbuutiif, kaan immoo aarsaa gubamuuf haa dhiʼeessu. Haala kanaanis sababii xuraaʼummaa dhangalaʼaa isheetiif fuula Waaqayyoo duratti araara buusa. ");
INSERT INTO gaz_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","“ ‘Isin akka Israaʼeloonni iddoo bultii koo kan gidduu isaanii jiru sana xureessuudhaan xuraaʼummaa isaaniitiin hin duuneef waan isaan xureessu irraa addaan isaan baasuu qabdu.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Wanni kun seera nama dhangalaʼaan saala isaa keessaa baʼuuf, nama afeetaan saala isaa keessaa baʼu xureessuuf, ");
INSERT INTO gaz_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","dubartii xurii jiʼaa qabduuf, dhiira yookaan dubartii dhangalaʼaan saala keessaa baʼuu fi nama dubartii akka seeraatti qulqulluu hin taʼin tokko wajjin ciisu kamiif iyyuu kennamee dha. ");
INSERT INTO gaz_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Waaqayyos duʼa ilmaan Aroon kanneen yeroo fuula Waaqayyoo duratti dhiʼaatanitti duʼan sana lamaanii booddee Museetti dubbate. ");
INSERT INTO gaz_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","Waaqayyo Museedhaan akkana jedhe; “Sababii ani teessoo araaraa gararraatti duumessaan mulʼadhuuf akka obboleessi kee Aroon yeruma fedhetti gara Iddoo Iddoo Hunda Caalaa Qulqulluu kan golgaa keessa fuula teessoo araaraa dura taabota irra jiru sanaa ol hin seenne itti himi; yoo kanaa achii inni ni duʼa. ");
INSERT INTO gaz_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","“Akki Aroon itti Iddoo Iddoo Hunda Caalaa qulqulluu sana seenu kanaa dha: Aarsaa cubbuutiif dibicha tokko, aarsaa gubamuuf immoo korbeessa hoolaa tokko haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","Innis kittaa quncee talbaa irraa hojjetame qulqulluu isaatii fi uffata dhagna isaatti aanu kan quncee talbaa irraa hojjetame haa kaaʼatu. Sabbata quncee talbaa irraa hojjetame hidhatee marata mataa kan quncee talbaa irraa hojjetames haa maratu; kunneen uffata qulqulluu dha. Kanaafuu inni utuu uffata sana hin uffatin dhagna isaa bishaaniin haa dhiqatu. ");
INSERT INTO gaz_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Waldaa saba Israaʼel irraas aarsaa cubbuutiif korommii reʼee lama, aarsaa gubamuuf immoo korbeessa hoolaa tokko haa fuudhu. ");
INSERT INTO gaz_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","“Aroon aarsaa cubbuu ofii isaatiif dibicha sana dhiʼeessee ofii isaatii fi warra mana isaa jiraniif araara haa buusu. ");
INSERT INTO gaz_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Ergasiis reʼoota lamaan sana fuudhee balbala dunkaana wal gaʼii irratti fuula Waaqayyoo duratti haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aroonis reʼoota sana lamaanitti ixaa haa buusu; ixaa tokko Waaqayyoof, kaan immoo reʼee gad lakkifamuuf haa buusu. ");
INSERT INTO gaz_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Aroonis reʼee ixaan Waaqayyoo irra buʼe sana fidee aarsaa cubbuu godhee haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Garuu reʼeen akka reʼee gad lakkifamu taʼuuf ixaadhaan filatame sun akka reʼee gad lakkifamu tokkootti gammoojjiitti gad ariʼamuudhaan akka araara buusuuf utuu lubbuudhaan jiruu fuula Waaqayyo duratti haa dhiʼeeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","“Aroonis aarsaa cubbuu ofii isaatiif dibicha sana dhiʼeessee ofii isaatii fi warra mana isaa jiraniif araara haa buusu; dibicha sanas cubbuu ofii isaatiif haa qalu. ");
INSERT INTO gaz_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Innis girgiraa barbadaa ibiddaa iddoo aarsaa kan fuula Waaqayyoo dura jiru irraa itti guutame tokko fuudhee ixaana urgaaʼaa daakamee bullaaʼes konyee lama fuudhee golgaa sana keessa haa seenu. ");
INSERT INTO gaz_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Innis akka hin duuneef, akka aarri ixaana sanaa teessoo araaraa kan dhuga baʼumsaa gubbaa jiru sana haguuguuf ixaana sana ibidda fuula Waaqayyoo dura jirutti haa naqu. ");
INSERT INTO gaz_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Dhiiga dibicha sanaa irraa fuudhee karaa fuulduraatiin teessoo araaraatti quba isaatiin haa facaasu; ergasii immoo dhiiga isaa fuudhee fuula teessoo araaraa duratti yeroo torba quba isaatiin haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","“Reʼee sanas aarsaa cubbuu sabaa godhee haa qalu; dhiiga isaas fuudhee golgaa keessa seenuudhaan akkuma dhiiga dibicha sanaa godhe sana haa godhu; dhiiga sanas teessoo araaraa irrattii fi fuula teessoo araaraa duratti haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Cubbuun isaanii waanuma fedhe taʼu illee inni sababii xuraaʼummaa fi fincila saba Israaʼeliif Iddoo Iddoo Hunda Caalaa Qulqulluu sana haala kanaan araara haa buusu; dunkaana wal gaʼii kan xuraaʼummaa isaanii keessa isaan gidduu jiruufis akkasuma haa godhu. ");
INSERT INTO gaz_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Yeroo Aroon Iddoo Iddoo Hunda Caalaa Qulqulluu sana keessatti araara buusuuf ol seenee jalqabee hamma inni ofii isaatiif, warra mana isaa jiranii fi waldaa Israaʼel hundaaf araara buusee gad baʼutti namni tokko iyyuu dunkaana wal gaʼii keessatti hin argamin. ");
INSERT INTO gaz_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","“Ergasiis iddoo aarsaa kan fuula Waaqayyoo dura jiru sanatti gad baʼee iddoo aarsaa sanaaf araara haa buusu. Innis dhiiga dibicha sanaa irraa fuudhee, dhiiga reʼee sanaa irraas fuudhee gaanfa iddoo aarsaa sanaa hunda irratti haa naqu. ");
INSERT INTO gaz_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Innis iddoo aarsaa sana xuraaʼummaa saba Israaʼel irraa qulqulleessee addaan baasuuf dhiiga sana irraa quba isaatiin yeroo torba iddoo aarsaa irratti haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","“Aroon erga Iddoo Iddoo Hunda Caalaa Qulqulluu sana, dunkaana wal gaʼiitii fi iddoo aarsaatiif araara buusee raawwatee booddee reʼee lubbuudhaan jiru sana gara fuulduraatti haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Innis harka isaa lamaanuu mataa reʼee lubbuudhaan jiru sanaa irra kaaʼee achi irratti hamminaa fi fincila saba Israaʼel jechuunis cubbuu isaanii hunda hima. Yakka hundas mataa reʼee sanaa irra kaaʼee reʼee sana nama hojii kanaaf filatame tokkotti kennee gara gammoojjiitti haa ariʼu. ");
INSERT INTO gaz_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Reʼeen sunis cubbuu isaanii hunda of irratti baatee gara lafa namni hin dhaqneetti geessa; namichis gammoojjii keessatti isa gad dhiisa. ");
INSERT INTO gaz_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","“Ergasiis Aroon dunkaana wal gaʼii seenee uffata quncee talbaa irraa hojjetame kan utuu Iddoo Iddoo Hunda Caalaa Qulqulluu sana hin seenin uffate sana baafatee achumatti haa dhiisu. ");
INSERT INTO gaz_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Innis lafa qulqulluu tokkotti dhagna isaa bishaaniin dhiqatee uffata isa haa uffatu; ergasii immoo gad baʼee ofii isaatii fi saba sanaaf araara buusuuf, ofii isaatiif aarsaa gubamu, saba sanaafis aarsaa gubamu haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Cooma aarsaa cubbuu illee iddoo aarsaa irratti haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","“Namichi reʼee sana akka reʼee gad lakkifamu tokkootti gad dhiisu sun wayyaa isaa miiccatee dhagna isaa bishaaniin haa dhiqatu; ergasii gara qubataatti ol galuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Dibichii fi reʼeen aarsaa cubbuutiif dhiʼeeffaman kanneen dhiigni isaanii araara buusuuf Iddoo Iddoo Hunda Caalaa Qulqulluutti fidame sun qubata keessaa haa baafaman; gogaan isaanii, foonii fi miʼi garaa isaanii haa gubamu. ");
INSERT INTO gaz_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Namichi wantoota kanneen gubus uffata isaa miiccatee dhagna isaa bishaaniin haa dhiqatu; ergasii gara qubataatti ol galuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","“Seerri bara baraan isiniif kenname kanaa dha: Dhalataa biyyaas taʼu alagaan isin gidduu jiraatu guyyaa kurnaffaa jiʼa torbaffaatti gad of haa qabu; hojii tokko iyyuus hin hojjetin. ");
INSERT INTO gaz_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Sababiin isaa isin qulqulleessuuf guyyaan kun guyyaa itti araarri buʼu dha; ergasiis isin fuula Waaqayyoo duratti cubbuu keessan hunda irraa ni qulqullooftu. ");
INSERT INTO gaz_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Kun waan sanbata boqonnaa taʼeef isin gad of deebisuu qabdu; innis seera bara baraa ti. ");
INSERT INTO gaz_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Lubni iddoo abbaa isaa buʼee luba ol aanaa taʼuuf dibamee muudamu araara buusuu qaba; innis wayyaa qulqulluu kan quncee talbaa irraa hojjetame uffatee, ");
INSERT INTO gaz_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Iddoo Iddoo Hunda Caalaa Qulqulluuf, dunkaana wal gaʼiitiif, iddoo aarsaatiif, lubootaa fi miseensota waldaa hundaafis araara haa buusu. ");
INSERT INTO gaz_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","“Seerri bara baraan isiniif kenname kanaa dha: Kunis akka cubbuu Israaʼelootaa hundaaf waggaatti yeroo tokko araarri buufamuuf.” Wanni sunis akkuma Waaqayyo Musee ajajetti hojjetame. ");
INSERT INTO gaz_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","“Aroonii fi ilmaan isaatti, saba Israaʼel hundattis akkana jedhii himi; ‘Wanni Waaqayyo ajaje kunoo kana: ");
INSERT INTO gaz_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Saba Israaʼel keessaa namni kam iyyuu yoo qubata keessatti yookaan qubataan alatti sangaa yookaan hoolaa yookaan reʼee qalee ");
INSERT INTO gaz_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","dunkaana qulqulluu Waaqayyoo duratti aarsaa godhee Waaqayyoof dhiʼeessuuf balbala dunkaana wal gaʼiitti fiduu baate namichi sun dhiiga dhangalaase sanatti ni gaafatama; inni dhiiga dhangalaaseeraatii saba isaa keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Kunis akka Israaʼeloonni aarsaawwan amma alatti dhiʼeessaa jiran kana Waaqayyoof fidaniif. Isaanis aarsaawwan kanneen aarsaa nagaa godhanii Waaqayyoof dhiʼeessuuf balbala dunkaana wal gaʼii irratti lubatti haa fidan. ");
INSERT INTO gaz_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Lubichis dhiiga sana iddoo aarsaa Waaqayyoo kan balbala dunkaana wal gaʼii irra jiru sanatti haa facaasu; cooma isaas urgaa Waaqayyotti tolu godhee haa gubu. ");
INSERT INTO gaz_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Isaanis siʼachi waaqota tolfamoo bifa reʼee kanneen duukaa buʼanii sagaagalaa turan sanaaf aarsaa isaanii tokko illee dhiʼeessuu hin qaban; kunis isaaniif dhaloota dhufuuf seera bara baraa taʼa.’ ");
INSERT INTO gaz_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","“Akkanas isaaniin jedhi; ‘Saba Israaʼel keessaa namni kam iyyuu yookaan alagaan isaan gidduu jiraatu kam iyyuu yoo aarsaa gubamu yookaan qalma dhiʼeessee ");
INSERT INTO gaz_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","balbala dunkaana wal gaʼii duratti Waaqayyoof aarsaa dhiʼeessuuf fiduu baate namichi sun saba isaa keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","“ ‘Saba Israaʼel keessaa namni kam iyyuu yookaan alagaan gidduu isaanii jiraatu kam iyyuu dhiiga yoo nyaate, ani nama dhiiga nyaate sana fuula ittin hammaa dha; saba isaa keessaas isa nan balleessa. ");
INSERT INTO gaz_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Sababii jireenyi waan lubbuu qabu tokkoo dhiiga keessa jiruuf ani ittiin araara lubbuu keessaniif buusuudhaaf dhiiga sana iddoo aarsaa irratti isinii kenneera; wanni jireenya namaatiif araara buusus dhiiga. ");
INSERT INTO gaz_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Kanaafuu ani Israaʼelootaan, “Isin keessaa namni tokko iyyuu dhiiga hin nyaatin yookaan alagaan gidduu keessan jiraatu dhiiga hin nyaatin” nan jedha. ");
INSERT INTO gaz_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","“ ‘Saba Israaʼel keessaa namni kam iyyuu yookaan alagaan gidduu keessan jiraatu kan bineensa yookaan simbira nyaatamu adamsu kam iyyuu dhiiga waan sanaa dhangalaasee biyyoo itti haa deebisu; ");
INSERT INTO gaz_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","jireenyi waan lubbuu qabu tokkoo dhiiga isaa ti. Sababiin ani Israaʼelootaan, “Waan jireenyi waan lubbuu qabu hundaa dhiiga isaa taʼeef isin dhiiga waan lubbuu qabu tokko illee hin nyaatinaa; namni dhiiga nyaatu kam iyyuu saba keessaa haa balleeffamuu” jedheefis kanuma. ");
INSERT INTO gaz_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","“ ‘Namni kam iyyuu dhalataa biyyaas taʼu alagaan waan duʼee argame yookaan bineensi ciccire nyaatu uffata isaa haa miiccatu; dhagna isaas bishaaniin haa dhiqatu; inni hamma galgalaatti akka seeraatti xuraaʼaa dha; ergasii ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Yoo uffata isaa miiccachuu fi dhagna isaa dhiqachuu baate garuu inni cubbuu sanatti ni gaafatama.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","“Akkana jedhii Israaʼelootatti himi; ‘Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Isin waan isaan biyya Gibxi, biyya isin keessa jiraachaa turtan sana keessatti hojjetan hin hojjetinaa; waan biyya Kanaʼaan, biyya ani itti isin galchuuf jiru keessatti hojjetamus hin hojjetinaa. Seera isaanii duukaa hin buʼinaa. ");
INSERT INTO gaz_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Isin seera kootiif ajajamaa; ajaja koos sirriitti eegaa; ani Waaqayyo Waaqa keessanii dha. ");
INSERT INTO gaz_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ajaja koo fi seera koo eegaa; namni isaaniif ajajamu isaaniin jiraataatii; ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","“ ‘Namni kam iyyuu fira dhiigaa kam iyyuu wajjin wal bira gaʼuuf itti hin dhiʼaatin; ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","“ ‘Haadha kee wajjin wal bira gaʼuudhaan abbaa kee hin salphisin; isheen haadha kee ti; ishee wajjin wal bira hin gaʼin. ");
INSERT INTO gaz_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","“ ‘Niitii abbaa keetii wajjin wal bira hin gaʼin; wanni kun abbaa kee salphisa. ");
INSERT INTO gaz_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","“ ‘Isheen manuma keettis taʼu yookaan alatti dhalattu illee obboleettii kee, intala abbaa keetii yookaan haadha keetii wajjin wal bira hin gaʼin. ");
INSERT INTO gaz_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","“ ‘Intala ilma keetii yookaan intala intala keetii wajjin wal bira hin gaʼin; wanni kun si salphisa. ");
INSERT INTO gaz_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","“ ‘Intala niitii abbaa keetii kan abbaa keetiif dhalatte wajjin wal bira hin gaʼin; isheen obboleettii kee ti. ");
INSERT INTO gaz_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","“ ‘Obboleettii abbaa keetii wajjin wal bira hin gaʼin; isheen abbaa keetiif fira dhiigaa ti. ");
INSERT INTO gaz_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","“ ‘Obboleettii haadha keetii wajjin wal bira hin gaʼin; isheen haadha keetiif fira dhiigaa ti. ");
INSERT INTO gaz_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","“ ‘Wal bira gaʼuuf jettee niitii obboleessa abbaa keetiitti dhiʼaattee isa hin salphisin; isheen niitii obboleessa abbaa keetii ti. ");
INSERT INTO gaz_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","“ ‘Niitii ilma keetii wajjin wal bira hin gaʼin. Isheen niitii ilma keetii ti; ishee wajjin wal bira hin gaʼin. ");
INSERT INTO gaz_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","“ ‘Niitii obboleessa keetii wajjin wal bira hin gaʼin; wanni sun obboleessa kee salphisa. ");
INSERT INTO gaz_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","“ ‘Dubartii tokkoo fi intala ishee wajjin wal bira hin gaʼin. Intala ilma dubartii sanaa yookaan intala intala ishee wajjin wal bira hin gaʼin; isaan isheedhaaf fira dhiigaa ti; wanni kun jalʼina. ");
INSERT INTO gaz_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","“ ‘Utuu niitiin kee lubbuudhaan jirtuu obboleettii ishee masaanuu ishee gootee hin fuudhin; ishee wajjinis wal bira hin gaʼin. ");
INSERT INTO gaz_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","“ ‘Yeroo dubartiin tokko xuraaʼummaa xurii jiʼaa of irraa qabdutti, bira gaʼuudhaaf jettee isheetti hin dhiʼaatin. ");
INSERT INTO gaz_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","“ ‘Niitii namaa wajjin wal bira geessee isheedhaan of hin xureessin. ");
INSERT INTO gaz_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","“ ‘Ijoollee kee keessaa tokko illee akka Moolekiif aarsaa taʼaniif hin kennin; ati maqaa Waaqa keetii hin xureessin. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","“ ‘Akka namni dubartii wajjin ciisu ati dhiira wajjin hin ciisin; wanni kun hojii jibbisiisaa dha. ");
INSERT INTO gaz_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","“ ‘Horii kam iyyuu wajjin wal bira geessee of hin xureessin; dubartiin horii wajjin wal bira gaʼuuf ofii ishee itti hin kennin; kun waan karaa irraa goree dha. ");
INSERT INTO gaz_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","“ ‘Sababii namoonni ani ariʼee isin duraa baasuuf jiru kunneen haala kanaan xuraaʼaniif isin karaa kanneen keessaa kamiin iyyuu of hin xureessinaa. ");
INSERT INTO gaz_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","Lafti iyyuu xuroofteerti; kanaafuu ani sababii cubbuu isheetiifan ishee adabe; laftis jiraattota ishee ni tufti. ");
INSERT INTO gaz_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Isin garuu ajaja koo fi seera koo eegaa. Dhalataan biyyaatii fi alagoonni isin gidduu jiraatanis waan jibbisiisaa kana keessaa kam iyyuu hin hojjetin. ");
INSERT INTO gaz_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Namoonni isiniin dura biyya sana keessa jiraatanis waan kana hunda hojjetanii akkasiin biyyattiin xuroofte. ");
INSERT INTO gaz_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Isinis lafa kana yoo xureessitan, lafti akkuma saboota isin dura turan tufte sana isiniin illee ni tufti. ");
INSERT INTO gaz_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","“ ‘Namni wantoota jibbisiisoo kanneen keessaa tokko illee hojjetu kam iyyuu saba isaa keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","Ajaja koo eegaa; barteewwan jibbisiisoo isin dura hojjetamaa turan sana keessaa tokko illee duukaa buutanii ittiin of hin xureessinaa; ani Waaqayyo Waaqa keessan.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","“Akkana jedhii waldaa saba Israaʼel hundatti himi; ‘Ani Waaqayyo Waaqni keessan qulqulluudhaatii isinis qulqulloota taʼaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","“ ‘Tokkoon tokkoon keessan haadha keessanii fi abbaa keessaniif ulfina kennaa; Sanbatoota koos eegaa. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","“ ‘Gara waaqota tolfamootti hin deebiʼinaa yookaan sibiila baqfame irraa ofii keessaniif waaqota hin tolfatinaa. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","“ ‘Yommuu aarsaa nagaa Waaqayyoof dhiʼeessitanitti akka aarsaan keessan fudhatama isiniif argatu godhaatii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Aarsaan isin dhiʼeessitanis guyyuma sana yookaan guyyaa itti aanu haa nyaatamu; garuu wanni hafee hamma guyyaa sadaffaatti ture haa gubamu. ");
INSERT INTO gaz_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Waan kana keessaa tokko iyyuu yoo guyyaa sadaffaatti nyaatame xuraaʼaa dha; fudhatamas hin argatu. ");
INSERT INTO gaz_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Namni waan sana nyaatu sababii waan Waaqayyoon qulqulleeffame xureesseef itti gaafatama; namichi sun saba isaa keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","“ ‘Yommuu oomisha lafa keessanii walitti qabattanitti hamma daariitti hin haaminaa; qarmii isaa illee hin funaannatinaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Qarmii iddoo dhaabaa wayinii keetii hin funaanin yookaan ija wayinii keetii kan harcaʼe hin funaanin. Hiyyeeyyii fi alagootaaf dhiisaa. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","“ ‘Hin hatinaa. “ ‘Hin sobinaa. “ ‘Walis hin gowwoomsinaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","“ ‘Sobaan maqaa kootiin hin kakatinaa; akkasiinis maqaa Waaqa keessanii hin xureessinaa. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","“ ‘Ollaa kee gowwoomsitee waa irraa hin fudhatin yookaan hin saamin. “ ‘Mindaa nama qaxarame tokkoo hamma bariʼutti of bira hin bulchin. ");
INSERT INTO gaz_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","“ ‘Nama gurra duudaa hin abaarin yookaan nama jaamaa dura gufuu hin kaaʼin; garuu Waaqa kee sodaadhu. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","“ ‘Murtii hin jalʼisinaa; nama wal caalchisuudhaan gara hiyyeessaa hin gorinaa; nama guddaafis hin looginaa; ollaa keetiif garuu murtii qajeelaa kenni. ");
INSERT INTO gaz_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","“ ‘Saba kee gidduutti hamii hin facaasin. “ ‘Waan jireenya ollaa keetii balaa irra buusu hin hojjetin. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","“ ‘Garaa keetti obboleessa kee hin jibbin; akka cubbuu isaa keessatti qooda hin qabaanneef ollaa kee ifaan ifatti itti dheekkami. ");
INSERT INTO gaz_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","“ ‘Saba kee keessaa nama tokkotti iyyuu haaloo hin baʼin yookaan haaloo itti hin qabatin; ollaa kee garuu akkuma ofii keetiitti jaalladhu. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","“ ‘Sirna koo eegaa. “ ‘Horii gosa gosaa walitti hin diqaalomsinaa. “ ‘Midhaan gosa lama lafa qotiisaa keessanitti hin facaasinaa. “ ‘Wayyaa waan lama irraa hojjetame hin uffatinaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","“ ‘Namni garbittii nama biraaf kaadhimamte kan hin furamin yookaan bilisummaan ishee hin kennaminiif wajjin yoo wal bira gaʼe isaan adabamuu qabu; taʼus waan dubartiin sun hin bilisoominiif isaan hin ajjeefamin. ");
INSERT INTO gaz_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Namichi sun garuu korbeessa hoolaa tokko aarsaa yakkaatiif gara balbala dunkaana wal gaʼiitti Waaqayyoof haa fidu. ");
INSERT INTO gaz_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Lubichis korbeessa hoolaa aarsaa yakkaa sanaan cubbuu namichi hojjete sanaaf fuula Waaqayyoo duratti araara haa buusu; cubbuun namichaas ni dhiifamaaf. ");
INSERT INTO gaz_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","“ ‘Isin yommuu biyyattiitti galtanii muka ija kennu kan gosa hundaa dhaabdanitti, akka waan iji isaa dhowwameetti fudhadhaa. Isin akka waan iji sun hamma waggaa sadiitti dhowwameetti ilaalaa; iji sun hin nyaatamin. ");
INSERT INTO gaz_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Waggaa afuraffaatti immoo iji isaa hundinuu ni qulqullaaʼa; Waaqayyoofis aarsaa galataa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Waggaa shanaffaatti garuu ija isaa nyaachuu dandeessu. Haala kanaan oomishni keessan ni guddata. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","“ ‘Utuu dhiigni keessa jiruu foon kam iyyuu hin nyaatinaa. “ ‘Tolcha yookaan falfala hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","“ ‘Rifeensa mataa keessanii naannessitanii hin haaddatinaa yookaan qarqara areeda keessaniis hin murmuratinaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","“ ‘Nama duʼeef jettanii dhagna keessan hin mammadeessinaa yookaan mallattoo tumaa tokko illee of irratti hin tolfatinaa. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","“ ‘Akka lafti halalummaatti deebitee hamminaan hin guutamneef intala kee akka isheen ejjitu gochuudhaan ishee hin salphisin. ");
INSERT INTO gaz_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","“ ‘Sanbatoota koo eegaa; iddoo qulqulluu koos kabajaa. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","“ ‘Isin akka hin xuroofneef ilaaltota bira hin deeminaa yookaan warra ekeraa dubbisan hin barbaadinaa. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","“ ‘Warra dulloomaniif kaʼi; jaarsaaf ulfina kenni; Waaqa kee sodaadhu. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","“ ‘Yoo alagaan biyya keessan keessa isin wajjin jiraate isa hin cunqursinaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Alagaan isin gidduu jiraatu sun akka dhalataa biyya keessaniitti haa ilaalamu. Akka ofii keessaniitti isa jaalladhaa; isinis biyya Gibxitti alagoota turtaniitii. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","“ ‘Isin yommuu dheerina, ulfinaa fi baayʼina wayii safartanitti madaalii gowwoomsaatti hin fayyadaminaa. ");
INSERT INTO gaz_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Safartuu fi madaalii dhugaatti, iifii fi iinii dhugaatti fayyadamaa. Ani Waaqayyo Waaqa keessan kan biyya Gibxii baasee isin fidee dha. ");
INSERT INTO gaz_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","“ ‘Ajajaa fi seera koo hunda eegaatii duukaa buʼaa. Ani Waaqayyo.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","“Israaʼelootaan akkana jedhi; ‘Namni Israaʼel yookaan alagaan Israaʼel keessa jiraatu kan ilmaan isaa keessaa Moolekiif kennu kam iyyuu haa ajjeefamu; sabni biyya sanaa dhagaadhaan isa haa tumu. ");
INSERT INTO gaz_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Sababii namichi sun ilmaan isaa Moolekiif kennuudhaan iddoo qulqulluu koo xureessee maqaa koo qulqulluu sana salphiseef, ani fuula itti hammaadhee saba isaa keessaa isa nan balleessa. ");
INSERT INTO gaz_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Sabni biyya sanaa yeroo namichi sun ilmaan isaa keessaa tokko Moolekiif kennutti yoo fuula irraa deebifatee isa ajjeesuu dhiise, ");
INSERT INTO gaz_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ani namicha sanaa fi maatii isaatti fuula hammaadhee isaa fi warra isa faana buʼanii sagaagaluudhaan Moolekitti of kennan hunda saba isaanii keessaa nan balleessa. ");
INSERT INTO gaz_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","“ ‘Nama isaan duukaa buʼuudhaan sagaagaluuf jedhee gara ilaaltotaatii fi warra ekeraa dubbisaniitti deebiʼutti ani fuula ittan hammaadha; saba isaa keessaa isa nan balleessa. ");
INSERT INTO gaz_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","“ ‘Of qulqulleessaa; qulqullootas taʼaa; ani Waaqayyo Waaqa keessaniitii. ");
INSERT INTO gaz_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Sirna koo eegaa; duukaa buʼaas. Ani Waaqayyo isa isin qulqulleessuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","“ ‘Namni abbaa isaa yookaan haadha isaa abaare kam iyyuu haa ajjeefamu. Inni abbaa isaa yookaan haadha isaa abaareeraatii dhiigni isaa matuma isaatti deebiʼa. ");
INSERT INTO gaz_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","“ ‘Yoo namni niitii nama biraa wajjin jechuunis niitii ollaa isaa wajjin sagaagale namichi sagaagalee fi niitiin sagaagalte sun haa ajjeefaman. ");
INSERT INTO gaz_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","“ ‘Namni yoo niitii abbaa isaa wajjin ciise inni abbaa isaa salphiseera. Namichis, dubartiin sunis haa ajjeefaman; dhiigni isaanii matuma isaaniitti deebiʼa. ");
INSERT INTO gaz_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","“ ‘Yoo namni niitii ilma isaa wajjin ciise lamaan isaanii iyyuu haa ajjeefaman. Isaan haraamuu dha; dhiigni isaanii matuma isaaniitti deebiʼa. ");
INSERT INTO gaz_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","“ ‘Yoo namni akkuma dubartii wajjin ciisutti dhiira wajjin ciise lamaan isaanii iyyuu waan jibbisiisaa hojjetaniiru. Isaan haa ajjeefaman; dhiigni isaanii matuma isaaniitti deebiʼa. ");
INSERT INTO gaz_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","“ ‘Namni tokko yoo intalaa fi haadha ishee fuudhe, wanni kun xuraaʼummaa dha. Akka isin gidduutti xuraaʼummaan akkasii hin argamneef namichii fi dubartoonni lamaan ibiddaan haa gubaman. ");
INSERT INTO gaz_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","“ ‘Namni tokko yoo horii wajjin wal bira gaʼe haa ajjeefamu; horii sana illee ajjeesaa. ");
INSERT INTO gaz_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","“ ‘Yoo dubartiin horii kamitti iyyuu dhiʼaattee horii sana wajjin wal bira geesse, dubartiin sunii fi horiin sun haa ajjeefaman; dhiigni isaanii matuma isaaniitti deebiʼa. ");
INSERT INTO gaz_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","“ ‘Namni tokko yoo obboleettii isaa jechuunis intala abbaa isaa yookaan intala haadha isaa fuudhee wal bira gaʼan wanni kun salphina. Isaan utuma sabni isaanii arguu saba isaanii keessaa haa balleeffaman; namichi kun obboleettii isaa salphiseera; itti gaafatamas. ");
INSERT INTO gaz_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","“ ‘Namni tokko yoo yeroo dubartiin tokko xurii jiʼaa of irraa qabdutti ishee bira gaʼe, inni madda dhangalaʼaa ishee ifatti baaseera; isheenis madda dhangalaʼa ishee mulʼifteerti. Lamaan isaanii iyyuu saba isaanii keessaa haa balleeffaman. ");
INSERT INTO gaz_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","“ ‘Obboleettii haadha keetii yookaan abbaa keetii wajjin wal bira hin gaʼin; wanni sun fira dhiigaa salphisaatii; isin lamaanuus itti gaafatamtu. ");
INSERT INTO gaz_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","“ ‘Namni tokko yoo niitii eessuma isaa wajjin wal bira gaʼe inni eessuma isaa salphiseera. Isaan itti gaafatamu; utuu ijoollee hin argatinis duʼu. ");
INSERT INTO gaz_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","“ ‘Namni tokko yoo niitii obboleessa isaa fuudhe, wanni kun hojii xuraaʼummaa ti; innis obboleessa isaa salphiseera. Isaan ijoollee malee hafu. ");
INSERT INTO gaz_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","“ ‘Akka lafti ani akka isin keessa jiraattaniif itti isin fidu sun isin hin tufneef ajajaa fi seera koo hunda eegaa; duukaa buʼaas. ");
INSERT INTO gaz_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Isin bartee saboota ani fuula keessan duraa ariʼee baasuuf jiru kanneenii duukaa hin buʼinaa; sababii isaan wantoota kanneen hunda hojjetaniif ani isaan jibbeera. ");
INSERT INTO gaz_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Ani garuu, “Isin lafa isaanii ni dhaaltu; anis lafa aannanii fi damma baasu dhaala godhee isiniifin kenna” jedheera. Ani Waaqayyo Waaqa keessan kan saboota kaan irraa addaan isin baasee dha. ");
INSERT INTO gaz_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","“ ‘Kanaafuu isin bineensa qulqullaaʼaa fi xuraaʼaa, simbirroo xuraaʼaa fi qulqullaaʼaa addaan baasaa. Bineensa yookaan simbirroo yookaan waan lafa irra munyuuqu kanneen ani isiniif xuraaʼota jedhee addaan baase kamiin iyyuu of hin xureessinaa. ");
INSERT INTO gaz_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Sababii ani Waaqayyo qulqulluu taʼee fi akka isin kan koo taataniifis saboota kaan irraa addaan isin baaseef, isin qulqulloota naaf taʼaa. ");
INSERT INTO gaz_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","“ ‘Dhiirri yookaan dubartiin ilaalan yookaan ekeraa dubbisan haa ajjeefaman. Isaan dhagaadhaan haa tumaman; dhiigni isaanii matuma isaaniitti deebiʼa.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Waaqayyo Museedhaan akkana jedhe; “Akkana jedhiitii ilmaan Aroon luboota sanatti dubbadhu: ‘Lubni tokko nama fira isaa keessaa duʼeef jedhee of hin xureessin; ");
INSERT INTO gaz_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","garuu firoota dhiigaatiif jechuunis haadha isaa, abbaa isaa, ilma isaa, intala isaa, obboleessa isaa, ");
INSERT INTO gaz_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","yookaan obboleettii isaa kan sababii hin heeruminiif isa wajjin jiraattuuf jedhee of xureessuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Garuu namoota karaa fuudhaa fi heerumaatiin firoota isaa taʼaniif jedhee of hin xureessin; akkasiinis xuraaʼaa hin taʼin. ");
INSERT INTO gaz_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","“ ‘Luboonni mataa isaanii yookaan qarqara areeda isaanii hin haadatin yookaan dhagna isaanii hin madeessin. ");
INSERT INTO gaz_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Isaan Waaqa isaaniitiif qulqulloota haa taʼan; maqaa Waaqa isaaniis hin xureessin. Isaan waan aarsaa ibiddaan Waaqayyoof dhiʼeeffamu, nyaata Waaqa isaanii sana dhiʼeessaniif qulqulloota taʼuu qabu. ");
INSERT INTO gaz_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","“ ‘Luboonni sababii Waaqa isaaniitiif qulqulloota taʼaniif isaan dubartoota sagaagalummaadhaan xuraaʼan yookaan kanneen dhirsoota isaanii hiikan fuudhuu hin qaban. ");
INSERT INTO gaz_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Ati isa qulqulleessi; inni nyaata Waaqa keetii dhiʼeessaatii. Inni siif haa qulqullaaʼu; ani Waaqayyo inni isin qulqulleessu qulqulluudhaatii. ");
INSERT INTO gaz_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","“ ‘Intalli luba tokkoo yoo sagaagalummaadhaan of xureessite isheen abbaa ishee salphifti; isheen ibiddaan haa gubamtu. ");
INSERT INTO gaz_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","“ ‘Lubni obboloota isaa keessaa luba ol aanaa taʼee zayitiin ittiin diban mataa isaa irratti naqame kan akka uffata lubummaa uffatuuf muudame tokko mataa isaa filachuu hin dhiisin yookaan uffata ofii hin tarsaasin. ");
INSERT INTO gaz_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Inni iddoo reeffi jiru hin seenin. Abbaa isaatiif yookaan haadha isaatiif iyyuu jedhee of hin xureessin; ");
INSERT INTO gaz_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","yookaan sababii zayitiin ittiin diban kan Waaqa isaa isa irra jiruuf inni iddoo qulqulluu sana keessaa hin baʼin yookaan iddoo qulqulluu Waaqa isaa hin xureessin. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","“ ‘Dubartiin inni fuudhu durba taʼuu qabdi. ");
INSERT INTO gaz_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Inni haadha hiyyeessaa, niitii dhirsi hiike yookaan niitii sagaagalummaadhaan xuroofte hin fuudhin; garuu gosa isaa keessaa durba haa fuudhu; ");
INSERT INTO gaz_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","kunis akka inni gosa isaa keessatti sanyii isaa hin xureessineef. Ani Waaqayyo isa qulqulleessuu dha.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","“Arooniin akkana jedhi: ‘Dhaloota itti aanu keessatti sanyii kee keessaa namni hirʼina qabu kam iyyuu nyaata Waaqa isaa dhiʼeessuuf hin dhiʼaatin. ");
INSERT INTO gaz_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Namni hirʼina kam iyyuu qabu tokko iyyuu jechuunis namni jaamaan yookaan naafni, namni bifaa fi dhagna hin tolle, ");
INSERT INTO gaz_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","namni miilla yookaan harka cabaa qabu, ");
INSERT INTO gaz_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","yookaan namni dugda goophoo yookaan ooluun yookaan namni dhibee ijaa qabu yookaan namni madaa malaʼu qabu, yookaan namni cittoo qabuu fi namni kolaafame hin dhiʼaatin. ");
INSERT INTO gaz_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Sanyii Aroon lubichaa keessaa namni hirʼina qabu kam iyyuu aarsaa ibiddaan Waaqayyoof dhiʼeeffamu dhiʼeessuuf hin dhiʼaatin. Inni waan hirʼina qabuuf nyaata Waaqa isaa dhiʼeessuuf hin dhiʼaatin. ");
INSERT INTO gaz_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Innis nyaata Waaqa isaa kan nyaata hunda caalaa qulqulluu taʼee fi nyaata qulqulluu nyaachuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Garuu inni sababii hirʼina qabuuf akka iddoo qulqulluu koo hin xureessineef golgaa keessa hin seenin yookaan iddoo aarsaatti hin dhiʼaatin. Ani Waaqayyo isa isaan qulqulleessuu dha.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Museen Aroonitti, ilmaan Aroonittii fi Israaʼeloota hundatti waan kana hime. ");
INSERT INTO gaz_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","“Akka isaan maqaa koo qulqullicha hin xureessineef, akka isaan aarsaa qulqulluu Israaʼeloonni addaan baasanii naa fidan sana akka gaariitti eeganiif Aroonii fi ilmaan isaatti himi. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","“Akkanas Isaaniin jedhi: ‘Dhaloota dhufu keessa yoo sanyii kee keessaa namni tokko illee utuu akka seeraatti hin qulqullaaʼin aarsaa Israaʼeloonni Waaqayyoof addaan baasanitti dhiʼaate namni sun fuula koo duraa haa balleeffamu. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","“ ‘Sanyii Aroon keessaa namni tokko yoo lamxii yookaan dhangalaʼaa saala isaa keessaa baʼu qabaate inni hamma qulqullaaʼutti aarsaa qulqulluu sana hin nyaatin. Akkasumas yoo waan reeffaan xuraaʼe yookaan nama afeetaa saala isaa keessaa dangalaʼu tuqe, ");
INSERT INTO gaz_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","yookaan yoo waan lafa irra looʼu kan isa xureessu yookaan nama isa xureessu kam iyyuu tuqe, xuraaʼummaa kam iyyuu taanaan, ");
INSERT INTO gaz_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","namni waan akkasii kam iyyuu tuqu hamma galgalaatti xuraaʼaa taʼa. Inni yoo dhagna isaa bishaaniin dhiqate malee aarsaa qulqulluu sana keessaa tokko illee hin nyaatin. ");
INSERT INTO gaz_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Inni yeroo aduun lixxutti ni qulqullaaʼa; ergasii immoo sababii wanni sun nyaata isaa taʼeef aarsaa qulqulluu sana nyaachuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Inni waan duʼee argame yookaan waan bineensi ciccire nyaachuudhaan of hin xurreessin. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","“ ‘Luboonni akka ajaja koo tuffachuudhaan cubbuu hojjetanii hin duuneef ajaja koo haa eegan. Ani Waaqayyo isaan qulqulleessuu dha. ");
INSERT INTO gaz_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","“ ‘Namni maatii lubaa hin taʼin yookaan keessummaan lubaa yookaan namni lubichaaf qaxaramee hojjetu tokko illee aarsaa qulqulluu sana nyaachuu hin dandaʼu. ");
INSERT INTO gaz_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Garuu yoo lubni maallaqaan garbicha bitate, yookaan yoo garbichi mana isaatti dhalate, garbichi sun nyaata lubichaa nyaachuu dandaʼu. ");
INSERT INTO gaz_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Intalli lubaa yoo nama luba hin taʼinitti heerumte, isheen aarsaa qulqulluu sana irraa nyaachuu hin dandeessu. ");
INSERT INTO gaz_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Taʼus intalli lubaa yoo haadha hiyyeessaa taate yookaan dhirsaan wal hiiktee utuu ijoollee hin qabaatin akkuma yeroo ijoollummaa isheetti mana abbaa ishee jiraachuuf deebite, isheen nyaata abbaa ishee irraa nyaachuu ni dandeessi. Ormi garuu nyaachuu hin dandaʼu. ");
INSERT INTO gaz_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","“ ‘Namni yoo utuu hin beekin aarsaa qulqulluu tokko nyaate, inni waan sana iddoo buusee gatii waan sanaa harka shan keessaa harka tokko itti dabalee lubichaaf haa kennu. ");
INSERT INTO gaz_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Luboonnis aarsaa qulqulluu Israaʼeloonni Waaqayyoof dhiʼeessan hin xureessin ");
INSERT INTO gaz_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","yookaan akka sabni sun aarsaa qulqulluu sana nyaatu eeyyamuufiidhaan yakka gatii baasisu isaanitti hin fidin. Ani Waaqayyo isaan qulqulleessuu dha.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","“Aroonitti, ilmaan isaattii fi Israaʼeloota hundatti akkana jedhii himi; ‘Yeroo saba Israaʼel keessaa namni tokko yookaan alagaan Israaʼel keessa jiraatu kam iyyuu aarsaa gubamu godhee wareega isaa yookaan aarsaa fedhiidhaan dhiʼaatu Waaqayyoof dhiʼeessutti, ");
INSERT INTO gaz_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","isin akka wanni sun fudhatama isiniif argatuuf loon, hoolota yookaan reʼoota keessaa korma hirʼina hin qabne tokko dhiʼeessuu qabdu. ");
INSERT INTO gaz_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Sababii inni isinii hin fudhatamneef waan hirʼina qabu kam iyyuu hin dhiʼeessinaa ");
INSERT INTO gaz_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Yeroo namni loon yookaan bushaayee keessaa wareega guuttachuuf aarsaa fedhiidhaan dhiʼeeffamu godhee aarsaa nagaa Waaqayyoof dhiʼeessutti akka wanni sun fudhatama argatuuf wanni sun waan fayyaalessa yookaan waan hirʼina hin qabne haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Horii jaamaa yookaan cabaa yookaan dooluu yookaan kormommuu yookaan kan dhangalaʼaan dhagna isaa keessaa baʼu yookaan kan madaa malaʼu qabu Waaqayyoof hin dhiʼeessinaa. Kanneen akkasii keessaa tokko iyyuu aarsaa ibiddaan Waaqayyoof dhiʼeeffamu gootanii iddoo aarsaa irra hin kaaʼinaa. ");
INSERT INTO gaz_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Taʼus sangaa yookaan hoolaa gar malee dheeraa yookaan gar malee gabaabaa taʼe aarsaa fedhiidhaan dhiʼaatu gootanii dhiʼeessuu ni dandeessu; garuu wanni kun wareega keessan guutuuf fudhatama hin argatu. ");
INSERT INTO gaz_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Horii kolaafame yookaan kan tumame, kan kolaan isaa baqaqfame yookaan irraa murame tokko Waaqayyoof hin dhiʼeessinaa; isin waan akkasii biyya keessan keessatti hin godhinaa; ");
INSERT INTO gaz_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","horii akkasii nama ormaa harkaa fuutanii nyaata Waaqa keessanii gootanii hin dhiʼeessinaa. Horiin sun waan kolaafamee hirʼina qabuuf isiniif hin fudhatamu.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","“Dibichi yookaan hoolaan yookaan reʼeen yommuu dhalatutti hamma bultii torbaatti haadha isaa wajjin haa turu. Guyyaa saddeettaffaadhaa jalqabee immoo aarsaa ibiddaan Waaqayyoof dhiʼeeffamu taʼee fudhatama ni argata. ");
INSERT INTO gaz_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Guyyuma tokkotti, saʼa yookaan hoolaa ilmoo isaa wajjin hin qalinaa. ");
INSERT INTO gaz_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","“Gaafa aarsaa galataa Waaqayyoof dhiʼeessitanitti akka isiniif fudhatamuuf haala kanaan dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Aarsaan kunis gaafuma sana nyaatamuu qaba; waan tokko illee hin bulchinaa. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","“Ajajawwan koo eegaa; duukaa buʼaas. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Maqaa koo qulqullicha hin xureessinaa. Akka ani qulqulluu taʼe Israaʼeloonni haa beeksisan. Ani Waaqayyo kan isin qulqulleessu ");
INSERT INTO gaz_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","kanan Waaqa keessan taʼuudhaaf biyya Gibxii isin baasee dha. Ani Waaqayyo.” ");
INSERT INTO gaz_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","“Akkana jedhiitii Israaʼelootatti dubbadhu; ‘Kunneen ayyaanota koo murtaaʼoo, ayyaanota Waaqayyoo kanneen isin guyyoota wal gaʼii qulqulluu jettanii labsitanii dha. ");
INSERT INTO gaz_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","“ ‘Guyyoonni isin hojii itti hojjettan jaʼatu jira; guyyaan torbaffaan garuu sanbata boqonnaa, guyyaa wal gaʼii qulqulluu ti. Isin hojii tokko illee hin hojjetinaa; iddoo isin jiraattan kamitti iyyuu kun sanbata Waaqayyoo ti. ");
INSERT INTO gaz_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","“ ‘Isaan kunneen ayyaanota Waaqayyoo murteeffamoo, waldaawwan qulqulluu isin yeroo isaaniitti labsitanii dha; ");
INSERT INTO gaz_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Faasiikaan Waaqayyoo galgala bultii kudha afuraffaa jiʼa jalqabaatti jalqabama. ");
INSERT INTO gaz_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Guyyaa kudha shanaffaa jiʼa jalqabaatti Ayyaana Waaqayyoo kan maxinootu jalqabama; isinis guyyaa torba buddeena raacitii hin qabne nyaadhaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Guyyaa jalqabaatti wal gaʼii qulqulluu qabaadhaa; hojii idilees hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Bultii torba aarsaa ibiddaan Waaqayyoof dhiʼeeffamu dhiʼeessaa. Bultii torbaffaatti wal gaʼii qulqulluu qabaadhaa; hojii idilees hin hojjetinaa.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","“Akkana jedhii Israaʼelootatti dubbadhu; ‘Yommuu biyya ani isiniif kennutti galtanii oomisha walitti qabdanitti bissii mataa midhaan walitti qabdan sanaa lubatti fidaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Innis akka bissiin sun fudhatama isiniif argatuuf fuula Waaqayyoo duratti haa sochoosu; lubichis guyyaa Sanbata booddee jirutti haa sochoosu. ");
INSERT INTO gaz_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Guyyaa bissii sana sochooftanitti, xobbaallaa hoolaa waggaa tokkoo kan hirʼina hin qabne aarsaa gubamu godhaatii Waaqayyoof dhiʼeessaa; ");
INSERT INTO gaz_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","kana wajjinis aarsaa midhaanii daakuu bullaaʼaa zayitiidhaan sukkuumame iifii tokko irraa harka kudhan keessaa harka lama aarsaa urgaaʼaa ibiddaan Waaqayyoof dhiʼeeffamuu fi dhibaayyuu daadhii wayinii iinii tokko irraa harka afur keessaa harka tokko dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Isin hamma gaafa kennaa kana Waaqayyoof dhiʼeessitanitti buddeena yookaan akaayii yookaan asheetii hin nyaatinaa. Kunis iddoo isin jiraattan hundatti dhaloota dhufuuf seera bara baraa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","“ ‘Guyyaa Sanbata booddee jiru, gaafa bissii aarsaa sochoofamu fiddanii jalqabaatii torbanoota torba guutuu lakkaaʼaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Hamma guyyaa Sanbata torbaffaa booddee jiruutti guyyaa shantama lakkaaʼaa; ergasii immoo aarsaa midhaan haaraa Waaqayyoof dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Iddoo jiraattan hundatti buddeena lama kan daakuu bullaaʼaa iifii tokkoo irraa harka kudhan keessaa harka lamaa kan raacitiin itti makamee tolfame kennaa hangafa kan sochoofamu godhaatii Waaqayyoof fidaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Buddeena kana wajjinis xobbaallaawwan hoolaa torba kanneen hirʼina hin qabnee fi kanneen waggaa tokko tokkoo, dibicha tokkoo fi korbeeyyii hoolaa lama dhiʼeessaa. Isaanis aarsaa midhaan isaaniitii fi aarsaa dhibaayyuu isaanii wajjin Waaqayyoof aarsaa gubamu taʼu; kunis aarsaa ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti toluu dha. ");
INSERT INTO gaz_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Ergasiis aarsaa cubbuutiif korma reʼee tokko akkasumas xobbaallaa hoolaa lama kanneen waggaa tokko tokkoo aarsaa nagaatiif qalaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Lubni immoo xobbaallaa hoolaa sana lamaan aarsaa sochoofamu godhee buddeena jalqabaa wajjin fuula Waaqayyoo duratti haa sochoosu. Isaan kunneenis kan Waaqayyoof qulqulleeffamanii dha; qooda lubootaatis. ");
INSERT INTO gaz_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Isin gaafuma sana wal gaʼii qulqulluu labsaa; hojii idilees hin hojjetinaa. Kunis iddoo isin jiraattan hundatti dhaloota dhufuuf seera bara baraa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","“ ‘Yommuu oomisha lafa keessanii walitti qabdanitti hamma qarqaraatti hin haaminaa yookaan qarmii isaa hin funaaninaa; waan kana hiyyeeyyii fi alagootaaf hambisaa. Ani Waaqayyo Waaqa keessan.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","“Israaʼelootaan akkana jedhi; ‘Isin guyyaa jalqaba jiʼa torbaffaatti sanbata boqonnaa qabaadhaa; yaaʼii qulqulluu sagalee malakataatiin ayyaaneffamus qabaadhaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Aarsaa ibiddaan Waaqayyoof dhiʼeeffamu dhiʼeessaa malee hojii idilee hin hojjetinaa.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","“Guyyaan kurnaffaan jiʼa torbaffaa guyyaa araarri buʼuu dha. Wal gaʼii qulqulluu qabaadhaa; gad ofi deebisaa; Waaqayyoofis aarsaa ibiddaan dhiʼeeffamu dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Sababii guyyaan sun Guyyaa Araarri Buʼu, yeroo itti fuula Waaqayyo Waaqa keessanii duratti araarri isiniif buʼu taʼeef hojii tokko illee hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Namni gaafuma sana gad of hin deebifne kam iyyuu saba isaa keessaa baafamee ni balleeffama. ");
INSERT INTO gaz_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Nama gaafa sana hojii tokko illee hojjetu kam iyyuus ani saba isaa gidduudhaa nan balleessa. ");
INSERT INTO gaz_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Isin hojii tokko iyyuu hin hojjetinaa. Kunis lafa isin jiraattan hundatti dhaloota dhufuuf seera bara baraa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Kun isiniif sanbata boqonnaa ti; isinis gad of deebisuu qabdu. Galgala bultii saglaffaa jiʼa sanaatii jalqabaatii hamma galgala itti aanutti sanbata keessan ayyaaneffadhaa.” ");
INSERT INTO gaz_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","“Israaʼelootaan akkana jedhi; ‘Bultii kudha shanaffaa jiʼa torbaffaatti Ayyaana Dunkaana Qulqulluu Waaqayyootu jalqabama; kunis bultii torba tura. ");
INSERT INTO gaz_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Guyyaan jalqabaa wal gaʼii qulqulluu dha; hojii idilees hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Guyyaa torba aarsaa ibiddaan Waaqayyoof dhiʼeeffamu dhiʼeessaa; guyyaa saddeettaffaatti immoo wal gaʼii qulqulluu godhadhaatii aarsaa ibiddaan Waaqayyoof dhiʼeeffamu dhiʼeessaa; kun guyyaa wal gaʼiin qulqulluun itti xumuramuu dha; hojii idilees hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","“ ‘Kunneen ayyaanota Waaqayyoo murtaaʼoo isin aarsaa ibiddaan Waaqayyoof dhiʼeeffamu, aarsaa gubamu, aarsaa midhaanii, qalmaa fi dhibaayyuu guyyaa kamiif iyyuu barbaachisu dhiʼeessuuf wal gaʼiiwwan qulqulluu itti labsitanii dha. ");
INSERT INTO gaz_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Aarsaawwan kunneen kennaawwan isin Sanbata Waaqayyootiif dhiʼeessitanii fi kennaawwan keessan, kennaawwan wareega keessanii fi kennaawwan isin fedhiidhaan kennitan hunda irratti dabaltanii Waaqayyoof fiddanii dha. ");
INSERT INTO gaz_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","“ ‘Erga oomisha lafa keessanii walitti qabdanii booddee bultii kudha shanaffaa jiʼa torbaffaatii jalqabaatii bultii torba Waaqayyoof ayyaana ayyaaneffadhaa; guyyaan jalqabaa sanbata boqonnaa ti; guyyaan saddeettaffaanis akkasuma sanbata boqonnaa ti. ");
INSERT INTO gaz_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Guyyaa jalqabaa ija muka gaarii, damee meexxii, damee muka baala qabuutii fi alaltuu qabadhaatii guyyaa torba fuula Waaqayyo Waaqa keessanii duratti gammadaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Wagguma waggaan ayyaana Waaqayyoo guyyaa torba ayyaaneffadhaa. Kunis dhaloota dhufuuf seera bara baraa haa taʼu; jiʼa torbaffaattis isa ayyaaneffadhaa. ");
INSERT INTO gaz_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Bultii torba daasii keessa turaa; dhalataan Israaʼel hundinuu daasii keessa haa turu; ");
INSERT INTO gaz_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","ijoolleen keessanis akkasiin akka ani yeroo biyya Gibxiitii Israaʼeloota baasetti daasii keessa isaan turse ni beeku. Ani Waaqayyo Waaqa keessan.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Museenis ayyaanota Waaqayyoo murtaaʼoo Israaʼelootatti labse. ");
INSERT INTO gaz_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","“Akka ibsaan ittuma fufee bobaʼuuf akka isaan zayitii ejersaa kan cuunfamee taliila taʼe siif fidaniif ijoollee Israaʼel ajaji. ");
INSERT INTO gaz_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aroonis ibsaawwan sana golgaa taabota kakuu seeraa kan dunkaana wal gaʼii keessa jiru sanaan alatti fuula Waaqayyoo duratti galgalaa hamma ganamaatti ittuma fufee haa qopheessu. Kunis dhaloota keessaniif seera bara baraa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Ibsaawwan baattuu ibsaa kan warqee qulqulluu irraa hojjetaman irra fuula Waaqayyoo dura jiran sun ittuma fufanii qopheeffamuu qabu. ");
INSERT INTO gaz_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","“Daakuu bullaaʼaa fuudhiitii buddeena kudha lama tolchi; tokkoon tokkoon buddeena sanaas daakuu iifii tokkoo irraa harka kudhan keessaa harka lama lamaan haa tolfamu. ");
INSERT INTO gaz_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Buddeena kanas toora tokko keessa jaʼa jaʼa godhiitii minjaala warqee qulqulluu irraa hojjetamee fuula Waaqayyoo dura jiru irra toora lamaan kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Akka inni qooda buddeena sanaa kutaa yaadannootii fi aarsaa ibiddaan Waaqayyoof dhiʼeeffamu taʼuuf tokkoo tokkoo toora sanaa irra ixaana qulqulluu kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Buddeenni kunis akka kakuu bara baraa taʼee saba Israaʼel iddoo buʼuuf yeroo hunda Sanbatuma Sanbataan fuula Waaqayyoo dura haa kaaʼamu. ");
INSERT INTO gaz_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Buddeenni kun qooda Arooniitii fi ilmaan isaa ti; isaanis sababii buddeenni kun qooda isaanii kan bara baraa kan aarsaa ibiddaan Waaqayyoof dhiʼeeffame keessaa kutaa waan hunda caalaa qulqullaaʼe taʼeef iddoo qulqulluutti isa haa nyaatan.” ");
INSERT INTO gaz_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Namichi haati isaa gosa Israaʼelii fi abbaan isaa immoo nama biyya Gibxii taʼe tokko Israaʼeloota gidduu baʼe; lollis qubata keessatti isaa fi Israaʼelicha tokko gidduutti kaʼe. ");
INSERT INTO gaz_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ilmi dubartii Israaʼel sunis Maqaa Waaqaa arrabse; ni abaares; kanaafuu Museetti isa fidan. Maqaan haadha namicha sanaas Sheloomiit jedhama; isheen immoo intala namicha gosa Daanii kan Dibraayi jedhamuu ti. ");
INSERT INTO gaz_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Isaanis hamma fedhiin Waaqayyoo isaanii ifutti eegumsa jala isa tursan. ");
INSERT INTO gaz_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Waaqayyos Museedhaan akkana jedhe: ");
INSERT INTO gaz_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","“Namicha Waaqa arrabse sana qubata keessaa gad baasi. Warri isa dhagaʼan hundinuu harka isaanii mataa isaa irra haa kaaʼan; waldaan hundi immoo dhagaadhaan isa haa tumu. ");
INSERT INTO gaz_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Israaʼelootaan akkana jedhi; ‘Namni kam iyyuu yoo Waaqa isaa abaare inni cubbuu hojjeteef itti gaafatama; ");
INSERT INTO gaz_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","namni Maqaa Waaqayyoo arrabsu haa ajjeefamu. Waldaan hundi dhagaadhaan isa haa tumu. Alagaas taʼu dhalataan biyyaa yoo Maqaa Waaqaa arrabse haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","“ ‘Namni nama ajjeese kam iyyuu haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Namni horii namaa ajjeese horii sana iddoo haa buusu. ");
INSERT INTO gaz_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Namni tokko yoo ollaa isaa miidhe, wanni inni nama sana godhe isa irrattis haa godhamu; ");
INSERT INTO gaz_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","kunis qooda cabaa cabaa, qooda ijaa ija, qooda ilkaanii ilkaan jechuu dha. Innis akkuma nama miidhe sana isa irrattis haa godhamu. ");
INSERT INTO gaz_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Namni horii ajjeese horii sana iddoo haa buusu; namni nama ajjeese garuu haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Alagaas taʼu dhalataa biyyaatiif seera tokkicha qabaadhaa. Ani Waaqayyo Waaqa keessan.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Museen waan kana Israaʼelootatti hime; isaanis namicha Waaqa arrabse sana qubata keessaa gad baasanii dhagaadhaan tuman; Israaʼeloonni akkuma Waaqayyo Musee ajaje godhan. ");
INSERT INTO gaz_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Waaqayyo Gaara Siinaa irratti Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","“Akkana jedhii Israaʼelootatti himi: ‘Yommuu biyya ani isinii kennutti galtan, biyyattiin mataan ishee sanbata Waaqayyoo haa kabajju. ");
INSERT INTO gaz_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Waggaa jaʼa lafa qotiisaa kee facaafadhu; waggaa jaʼa immoo wayinii kee irraa qori; ija isaas walitti qabadhu. ");
INSERT INTO gaz_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Waggaa torbaffaatti garuu lafti sanbata boqonnaa haa qabaatu; kunis sanbata Waaqayyoof kabajamuu dha. Lafa qotiisaa kee hin facaafatin yookaan wayinii kee irraa hin qorin. ");
INSERT INTO gaz_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Waan ofiin biqile hin haammatin yookaan wayinii hin qoramin irraa ija walitti hin qabatin. Lafti boqonnaa waggaa tokkoo haa argattu. ");
INSERT INTO gaz_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Wanni lafti waggaa sanbataatti kennitu nyaata kee haa taʼu jechuunis siʼi mataa keetiif, garboota kee dhiiraa fi dubartiidhaaf, warra qaxaramanii hojjetanii fi alagoota yeroodhaaf si wajjin jiraataniif nyaata haa taʼu; ");
INSERT INTO gaz_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","akkasumas horii keetii fi bineensa daggalaa kanneen biyya kee keessa jiraataniif nyaata haa taʼu. Wanni lafti baaftu kam iyyuu haa nyaatamu. ");
INSERT INTO gaz_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","“ ‘Waggoota sanbataa torba jechuunis waggoota torba yeroo torba lakkaaʼi; waggoonni sanbataa torban waggoota afurtamii sagal taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Guyyaa kurnaffaa jiʼa torbaffaatti immoo guutummaa biyya keessanii keessatti malakata dhageessisi; Guyyaa Araarri Buʼuttis guutummaa biyyaa keessatti malakata dhageessisaa. ");
INSERT INTO gaz_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Waggaa shantamaffaa qulqulleessaatii guutummaa biyyattii keessatti jiraattota hundaaf bilisummaa labsaa. Kunis iyyoobeeliyyuu isinii taʼa; tokkoon tokkoon namaa deebiʼee gara qabeenya isaattii fi gara maatii isaatti haa galu. ");
INSERT INTO gaz_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Waggaan shantamaffaan iyyoobeeliyyuu isiniif haa taʼu; hin facaafatinaa; waan ofiin biqile hin haammatinaa; wayinii hin qoramin irraas ija isaa walitti hin qabatinaa. ");
INSERT INTO gaz_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Kun sababii iyyoobeeliyyuu taʼeef qulqulluu isiniif haa taʼu; waan lafa qotiisaa irraa galfamu nyaadhaa. ");
INSERT INTO gaz_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","“ ‘Waggaa Iyyoobeeliyyuu kana keessa tokkoon tokkoon namaa gara qabeenya isaatti haa deebiʼu. ");
INSERT INTO gaz_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","“ ‘Yoo nama saba kee taʼetti lafa gurgurte yookaan waan tokko isa irraa bitte, wal hin gowwoomsinaa. ");
INSERT INTO gaz_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Ati waggoota waggaa Iyyoobeeliyyuu booddee jiran irratti hundooftee nama saba keetii irraa bitadhu. Innis baayʼina waggoota galchaa midhaanii lakkaaʼee sitti haa gurguru. ");
INSERT INTO gaz_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Yoo waggaan baayʼee taʼe gatii isaa dabaliif; yoo waggaan isaa gabaabaa taʼe immoo gatii isaa hirʼisi; sababiin isaa wanni inni sitti gurguru baayʼina midhaanii ti. ");
INSERT INTO gaz_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Wal hin cunqursinaa; garuu Waaqa sodaadhaa. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","“ ‘Ajaja koo duukaa buʼaa; seera koo illee eegaa; isinis biyyattii keessa nagaan ni jiraattu. ");
INSERT INTO gaz_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Lafti ija ni kenniti; isinis hamma quuftanitti nyaattu; nagaadhaanis ni jiraattu. ");
INSERT INTO gaz_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","Isinis, “Nu yoo facaafachuu yookaan midhaan keenya walitti qabachuu baanne waggaa torbaffaatti maal nyaanna?” jettanii gaafattu taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Akka lafti midhaan waggaa sadiif gaʼu isinii kennituuf ani waggaa jaʼaffaatti eebba koo isiniif nan erga. ");
INSERT INTO gaz_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Yeroo waggaa saddeettaffaatti facaafattanittis waanuma duraan galfattan irraa nyaattu; hamma midhaan waggaa saglaffaa walitti qabattanitti midhaanuma kana nyaattu. ");
INSERT INTO gaz_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","“ ‘Lafti sababii kanuma koo taateef bara baraan hin gurguramin; isin anaaf alagaa fi keessummoota. ");
INSERT INTO gaz_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","Biyya akka dhaalaatti qabattan guutuu keessatti waan ittiin lafa furtan baasaa. ");
INSERT INTO gaz_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","“ ‘Obboleessi kee tokko hiyyoomee lafa isaa yoo gurgure, namni fira isaa kan dhiʼoo taʼe dhufee waan firri isaa gurgure sana haa furuuf. ");
INSERT INTO gaz_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Garuu yoo namichi sun fira lafa isaa furuuf dhabee inni mataan isaa waan ittiin lafa isaa furatu argate, ");
INSERT INTO gaz_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","waggoota yeroo inni lafa isaa gurgure sanaa as jiran lakkaaʼee namicha itti gurgure sanaaf maallaqa isaa haa deebisu; innis gara lafa ofiitti haa deebiʼu. ");
INSERT INTO gaz_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Garuu yoo waan namicha sanaaf deebisu dhabee, wanni inni gurgure sun hamma waggaa iyyoobeeliyyuutti harkuma namicha bite sanaa haa turu. Waggaa Iyyoobeeliyyuu keessa ni deebiʼaaf; innis gara qabeenya isaatti ni deebiʼa. ");
INSERT INTO gaz_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","“ ‘Namni yoo magaalaa dallaa qabdu keessatti mana jireenyaa gurgurate, gaafa gurguratee jalqabee waggaa tokko keessatti furachuu dandaʼa. Mirgi furachuu isaas hamma waggaa tokkootti tura. ");
INSERT INTO gaz_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Yoo utuu waggaan tokko hin guutin furamuu baate manni magaalaa dallaa qabdu keessatti argamu sun qabeenya namicha biteetii fi kan sanyii isaa taʼee hafa. Waggaa Iyyoobeeliyyuuttis hin deebiʼu. ");
INSERT INTO gaz_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Manneen gandoota dallaan itti hin ijaaramin keessa jiran garuu waan akka lafa baadiyyaatti hedamaniif furamuu dandaʼu. Bara Iyyoobeeliyyuuttis ni deebifamu. ");
INSERT INTO gaz_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","“ ‘Lewwonni garuu manneen isaanii kanneen magaalaawwan isaanii keessatti argaman furachuuf yeroo kam iyyuu mirga qabu. ");
INSERT INTO gaz_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Qabeenyi Lewwotaa furamuu ni dandaʼa; manneen magaalaa isaan qabatan keessatti gurguraman bara Iyyoobeeliyyuutti ni deebifamu; manneen magaalaa Lewwotaa keessatti argaman Israaʼeloota gidduutti qabeenya Lewwotaatii. ");
INSERT INTO gaz_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Lafti dheedaa kan naannoo magaalaa isaaniitti argamu garuu sababii qabeenya isaanii kan bara baraa taʼeef hin gurguramin. ");
INSERT INTO gaz_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","“ ‘Yoo obboleessi kee tokko hiyyoomee isin gidduutti of gargaaruu dadhabe, akka inni isin gidduu jiraachuu dandaʼuuf akkuma alagaa yookaan keessummaa tokko gargaartutti isa gargaar. ");
INSERT INTO gaz_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Akka namni sun si wajjin jiraachuu dandaʼuuf Waaqa kee sodaadhu malee dhala tokko iyyuu isa irraa hin fudhatin. ");
INSERT INTO gaz_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Maallaqa kee dhalaan hin liqeessiniif yookaan nyaata kee buʼaa itti herregattee hin kenniniif. ");
INSERT INTO gaz_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ani Waaqayyo Waaqa keessan kan biyya Kanaʼaan isiniif kennuu fi Waaqa keessan taʼuuf biyya Gibxii isin baasee dha. ");
INSERT INTO gaz_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","“ ‘Yoo obboleessi kee tokko hiyyoomee sitti of gurgure akka garbichaatti isa hin hojjechiifatin. ");
INSERT INTO gaz_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Inni akka hojjetaa qaxaramaa yookaan nama yeroodhaaf isin wajjin jiraatuu haa taʼu; inni hamma Waggaa Iyyoobeeliyyuutti siif haa hojjetu. ");
INSERT INTO gaz_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Ergasii inni ijoollee isaa wajjin gad haa lakkifamu; inni gara maatii isaatii fi qabeenya abbootii isaatti haa deebiʼu. ");
INSERT INTO gaz_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Israaʼeloonni sababii garboota koo warra ani biyya Gibxiitii baasee fide taʼaniif akka garbootaatti hin gurguramin. ");
INSERT INTO gaz_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Waaqa kee sodaadhu malee gara jabinaan isaan hin bulchin. ");
INSERT INTO gaz_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","“ ‘Garboonni kee dhiironnii fi dubartoonni saboota naannoo kee jiraatan gidduudhaa haa dhufan; isin isaan keessaa garboota bitachuu dandeessu. ");
INSERT INTO gaz_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Akkasumas keessummoota isin gidduu jiraatanii fi maatii isaanii warra biyya keessanitti dhalatan keessaa garboota bitachuu dandeessu; isaanis qabeenya keessan haa taʼan. ");
INSERT INTO gaz_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Akka qabeenya dhaalamuutti ijoollee keessanitti dabarsuu dandeessu; bara jireenya isaanii guutuus isaan garboomfachuu dandeessu; Israaʼeloota obboloota keessan taʼan garuu gara jabinaan hin bulchinaa. ");
INSERT INTO gaz_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","“ ‘Yoo alagaan yookaan keessummaan si wajjin jiraatu tokko sooromee obboleessi kee immoo hiyyoomee alagaa si wajjin jiraatutti yookaan maatii alagaa sanaatti of gurgure, ");
INSERT INTO gaz_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","inni erga of gurguree booddee furamuuf mirga qaba. Firoota isaa keessaas namni tokko isa furuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","Obboleessi abbaa isaa yookaan ilmi obboleessa abbaa isaa yookaan aantee isaa keessaa firri dhiigaa isa furuu dandaʼa. Yookaan inni iyyuu yoo soorome of furuu dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Innii fi namichi isa bite sun waggaa inni itti of gurguree jalqabee hamma waggaa Iyyoobeeliyyuutti haa lakkaaʼan. Gatiin furii isaas baayʼina waggoota sanaa irratti hundaaʼa; yeroon inni namicha isa bitate sana bira ture immoo akka nama qacaramee hojjete tokkootti herregama. ");
INSERT INTO gaz_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Yoo akka herrega isaaniitti waggoonni baayʼeen hafan inni gatii ittiin bitame sana keessaa harka baayʼee namicha sanaaf deebisuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Yoo waggoonni hamma Waggaa Iyyoobeeliyyuutti hafan muraasa taʼan inni waggoota hafan sana herregatee gatii furama isaa haa kaffalu. ");
INSERT INTO gaz_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Inni akkuma nama waggaa waggaatti qaxaramu tokkootti isa wajjin haa jiraatu; fuula kee durattis inni gara jabinaan isa hin bulchin. ");
INSERT INTO gaz_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","“ ‘Yoo inni karaa kanneeniin furamuu baates innii fi ijoolleen isaa Waggaa Iyyoobeeliyyuutti furamuu qabu; ");
INSERT INTO gaz_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Israaʼeloonni garboota kootii. Isaan garboota koo kanneen ani biyya Gibxii baasee fidee dha. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","“ ‘Waaqota tolfamoo hin tolfatinaa; fakkii yookaan dhagaa waaqeffannaa hin dhaabbatinaa; fuula isaanii duratti sagaduuf jettaniis biyya keessan keessatti dhagaa soofame hin dhaabinaa. Ani Waaqayyo Waaqa keessan. ");
INSERT INTO gaz_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","“ ‘Sanbatoota koo eegaa; iddoo qulqulluu koos kabajaa. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","“ ‘Yoo isin sirna koo duukaa buutanii ajajawwan koos eegdanii hojii irra oolchitan, ");
INSERT INTO gaz_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","ani yeroo isaatti bokkaa isiniifan kenna; lafti midhaan ishee, mukkeen dirrees ija isaanii ni kennu. ");
INSERT INTO gaz_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Midhaan dhaʼachuun keessan hamma yeroo ija wayinii cirattaniitti itti fufa; ija wayinii cirachuun keessan hamma yeroo facaasaatti ittuma fufa; isinis nyaata keessan hamma quuftanitti nyaattanii lafa keessan irra nagaadhaan jiraattu. ");
INSERT INTO gaz_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","“ ‘Ani biyyattii keessa nagaa nan buusa; isin ni raftu; wanni tokko iyyuu isin hin sodaachisu. Biyyattii keessaa bineensota hamoo nan baasa; goraadeenis biyya keessan keessa hin darbu. ");
INSERT INTO gaz_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Isin diinota keessan ni ariitu; isaan immoo goraadeedhaan fuula keessan duratti dhumu. ");
INSERT INTO gaz_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Isin nama shan taatanii nama dhibba tokko ariitu; dhibba tokko taatanii immoo kuma kudhan ariitu; diinonni keessan goraadeedhaan fuula keessan duratti dhumu. ");
INSERT INTO gaz_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","“ ‘Ani fuula tolaadhaan gara keessan ilaalee akka isin hortanii baayʼattan nan godha; kakuu isin wajjin qabus nan jabeessa. ");
INSERT INTO gaz_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Isin midhaan bara darbee nyaachaa utuu inni gombisaa keessaa hin dhumin, midhaan haaraadhaaf iddoo qopheessuuf jettanii midhaan bara darbee sana gad baaftu. ");
INSERT INTO gaz_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Iddoo jireenya kootii isin gidduu nan godhadha; lubbuun koos isin hin balfitu. ");
INSERT INTO gaz_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ani isin gidduu jiraadhee Waaqa keessan nan taʼa; isinis saba koo ni taatu. ");
INSERT INTO gaz_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Ani Waaqayyo Waaqa keessan kan akka isin lammata garboota warra Gibxi hin taaneef biyya Gibxii baasee isin fidee dha; ani hidhaa waanjoo keessanii kutee akka isin mataa ol qabattanii deemtan godheera. ");
INSERT INTO gaz_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","“ ‘Garuu yoo na dhagaʼuu diddanii ajajawwan kanneen hunda eeguu baattan, ");
INSERT INTO gaz_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","yoo sirna koo tuffattanii seera koo balfitan, yoo ajajawwan kanneen hunda eeguu baattanii kakuu koo cabsitan, ");
INSERT INTO gaz_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ani wantoota kanneen isinittin fida: Isaanis naasuu, dhukkuba nama huqqisu, dhukkuba dhagna nama gubu kan agartuu namaa balleessee jireenya namaa gogsu isinitti nan fida. Isin akkasumaan midhaan facaafattu; diinota keessantu nyaataatii. ");
INSERT INTO gaz_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Akka isin diinota keessaniin moʼamtaniif ani fuula isinittan hammaadha; warri isin jibban isin bulchu; isin utuu eenyu iyyuu isin hin ariʼin ni baqattu. ");
INSERT INTO gaz_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","“ ‘Yoo isin wantoota kanneen hunda booddee naa ajajamuu diddan ani cubbuu keessaniif dachaa torba isin adaba. ");
INSERT INTO gaz_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Of tuulummaa humna keessanii nan cabsa; samii keessan akka sibiilaa, lafa keessan immoo akka naasii nan godha. ");
INSERT INTO gaz_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Humni keessan akkasumaan bada; lafti keessan midhaan isaa, mukkeenis ija isaanii hin kennaniitii. ");
INSERT INTO gaz_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","“ ‘Yoo isin naan mormitanii na dhagaʼuu diddan, ani akkuma cubbuu keessaniitti dhaʼicha dachaa torba isinitti nan fida. ");
INSERT INTO gaz_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Anis bineensota bosonaa isinittan erga; isaanis ijoollee keessan isin jalaa ni butatu; horii keessan ni barbadeessu; baayʼinni keessan ni xinnaata; daandiiwwan keessanis duwwaa hafu. ");
INSERT INTO gaz_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","“ ‘Yoo isin waan kanneeniin deebiʼuu diddanii naan mormuu keessan itti fuftan garuu, ");
INSERT INTO gaz_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ani mataan koo isiniinan morma; sababii cubbuu keessaniitiifis dachaa torba isin nan miidha. ");
INSERT INTO gaz_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Kakuu cabsuu keessaniifis goraadee isinitti fidee haaloo isin nan baafadha. Yommuu isin gara magaalaawwan keessaniitti baqattanitti ani gidduu keessanitti dhaʼicha nan erga; isinis dabarfamtanii harka diinotaatti kennamtu. ");
INSERT INTO gaz_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Yommuu ani madda buddeena keessanii gogsutti, dubartoonni kudhan eelee tokkotti buddeena tolchu, isaanis buddeena sana madaalanii isinii kennu; isin ni nyaattu; garuu hin quuftan. ");
INSERT INTO gaz_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","“ ‘Yoo isin waan kanaanis na dhagaʼuu diddanii garuu naan mormuutti fuftan, ");
INSERT INTO gaz_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","anis aaree isiniin nan morma; ani mataan koo sababii cubbuu keessaniitiif dachaa torba isiniinan adaba. ");
INSERT INTO gaz_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Isin foon ilmaan keessaniitii fi foon intallan keessanii ni nyaattu. ");
INSERT INTO gaz_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Iddoowwan sagadaa keessan barbadeessee iddoowwan aarsaa ixaanaa keessan nan caccabsa; reeffa keessanis waaqota keessan warra lubbuu hin qabne sana irra nan tuula; isinis nan balfa. ");
INSERT INTO gaz_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Magaalaawwan keessan nan diiga; iddoowwan qulqulluu keessan nan onsa; urgaa keessan gammachiisaas hin urgeeffadhu. ");
INSERT INTO gaz_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Ani akka diinonni keessan kanneen achi jiraatan rifataniif biyyattii nan onsa; ");
INSERT INTO gaz_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","ani saboota gidduu isin nan bittinneessa; goraadee koo luqqifadhees isin nan ariʼa. Biyyi keessan ni ona; magaalaawwan keessan immoo ni diigamu. ");
INSERT INTO gaz_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Biyyattiinis yeroo ontee isin biyya diinota keessanii keessa jiraattanitti sanbata isheetti ni gammaddi; laftis boqottee sanbata isheetti gammaddi. ");
INSERT INTO gaz_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Biyyattiin yeroo onte kana hunda boqonnaa sanbatootaa kan yeroo isin ishee irra jiraattanitti hin argatin ni argatti. ");
INSERT INTO gaz_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","“ ‘Warra isin keessaa hafan, ani utuma isaan biyya diinota isaanii jiranuu garaa isaaniitti naasuu nan buusa. Sagaleen baala qilleensi raasuu isaan ariʼa; utuma namni isaan ariʼu tokko illee hin jiraatin isaan akkuma waan goraadee jalaa baqataniitti fiigu; ni kukkufus. ");
INSERT INTO gaz_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Namni isaan ariʼu jiraachuu baatu illee isaan akkuma waan goraadee jalaa baqataniitti wal gufachiisu. Isin fuula diinota keessanii dura dhaabachuu hin dandeessan. ");
INSERT INTO gaz_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Isin saboota ormaa gidduutti dhumtu; lafti diinota keessaniis isin liqimsiti. ");
INSERT INTO gaz_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Warri isin keessaa hafan immoo sababii cubbuu isaaniitiif lafa diinota isaanii keessatti badu; sababii cubbuu abbootii isaaniitiinis ni badu. ");
INSERT INTO gaz_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","“ ‘Garuu yoo isaan cubbuu isaaniitii fi cubbuu abbootii isaanii jechuunis gantummaa fi daba isaan natti hojjetan ");
INSERT INTO gaz_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","kan akka ani isaaniin mormuu fi akka ani biyya diinota isaaniitti isaan ergu himatan, yoo garaan isaanii kan dhagna hin qabatin sun gad of deebisee isaan gatii cubbuu isaaniitiif malu baasan, ");
INSERT INTO gaz_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ani kakuu koo kanan Yaaqoob wajjin gale, kakuu koo kanan Yisihaaq wajjin gale, kakuu koo kanan Abrahaam wajjin gale sana nan yaadadha; biyyattiis nan yaadadha. ");
INSERT INTO gaz_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Lafti isaan malee hafti; yeroo isaan malee haftuttis sanbatoota isheetti ni gammaddi. Isaan sababii seera koo tuffatanii ajaja koos balfaniif gatii cubbuu isaanii ni baasu. ");
INSERT INTO gaz_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Taʼus utuu isaan biyya diinota isaanii keessa jiranuu ani kakuu koo kanan isaan wajjin gale sana cabsee guutumaan guutuutti isaan balleessuuf jedhee isaan hin tuffadhu yookaan isaan hin balfu. Ani Waaqayyo Waaqa isaanii ti. ");
INSERT INTO gaz_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Garuu ani isaaniif jedhee kakuu ani abbootii isaanii warra ani Waaqa isaanii taʼuuf utuu saboonni arganuu biyya Gibxiitii baasee fide sana wajjin gale nan yaadadha. Ani Waaqayyo.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Kunneen labsiiwwan, seerawwanii fi qajeelcha Waaqayyo Gaara Siinaa irratti harka Museetiin ofii isaatii fi Israaʼeloota gidduutti baasee dha. ");
INSERT INTO gaz_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","“Akkana jedhii Israaʼelootatti himi: ‘Namni yoo gatii wal madaalu kennuudhaan Waaqayyoof nama kennuuf wareega addaa godhe, ");
INSERT INTO gaz_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","dhiira umuriin isaa waggaa digdamaa hamma jaatamaa taʼeef, akka safartuu saqilii iddoo qulqulluutti herregni isaa meetii saqilii shantama haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","Yoo dubartii taate immoo herregni ishee meetii saqilii soddoma haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","Yoo nama umuriin isaa waggaa shanii fi digdama gidduu taʼe, herregni dhiiraa meetii saqilii digdamatti, kan dubartii immoo meetii saqilii kudhanitti haa herregamu. ");
INSERT INTO gaz_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","Nama umuriin isaa jiʼa tokkoo hamma waggaa shanii taʼe immoo herregni isaa, dhiiraaf meetii saqilii shan, durbaaf immoo meetii saqilii sadii haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","Namni umuriin isaa waggaa jaatama yookaan sanaa ol taʼe dhiirri meetii saqilii kudha shanitti, dubartiin immoo meetii saqilii kudhanitti haa herregamu. ");
INSERT INTO gaz_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","Namni wareega wareegu hiyyoomee gatii murtaaʼe sana yoo baasuu dadhabe, Museen nama sana lubatti haa fidu; lubni immoo akkuma dandeettii namicha wareega wareege sanaatti gatii isaa haa herreguuf. ");
INSERT INTO gaz_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","“ ‘Wanni namichi sun wareege horii fuula Waaqayyoo duratti aarsaa fudhatama qabu yoo taʼe horiin Waaqayyoof kenname kan akkasii hundi ni qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Namichis horii sana geeddaruu yookaan horii gaarii horii jibbamaan yookaan horii jibbamaa horii gaarii iddoo hin buusin; yoo inni horii tokko horii biraa iddoo buuse horiin lamaanuu qulqulluu taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Yoo horiin inni wareege sun akka seeraatti xuraaʼaa jechuunis kan Waaqayyoof aarsaa taʼee dhiʼaachuu hin dandeenye taʼe namichi sun horii sana gara lubatti haa fidu; ");
INSERT INTO gaz_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","lubichis akka horiin sun gaarii yookaan jibbamaa taʼe haa madaalu. Gatiin lubni madaale akkasuma haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Namichi sun yoo horii sana furachuu barbaade gatii herregame sanatti harka shan keessaa harka tokko itti dabaluu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","“ ‘Yoo namni tokko mana ofii Waaqayyoof qulqulleesse, akka manni sun gaarii yookaan gadhee taʼe lubichi gatii isaa haa herregu. Gatiin lubni madaale akkasuma haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Namichi mana isaa Waaqaaf qulqulleesse sun yoo mana ofii furachuu barbaade, gatii herregame sanatti harka shan keessaa harka tokko itti dabaluu qaba; manni sunis deebiʼee kan isaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","“ ‘Yoo namni lafa dhaalaan argate irraa Waaqayyoof qulqulleesse gatiin lafa sanaa akkuma baayʼina sanyii lafa sanaaf barbaachisuutti jechuunis garbuun safartuun homeerii tokko meetii saqilii shantamatti herregama. ");
INSERT INTO gaz_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Yoo inni lafa qotiisaa isaa Waggaa Iyyoobeeliyyuu keessa qulqulleesse gatiin duraan hedame sun hin geeddaramu. ");
INSERT INTO gaz_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Garuu yoo inni waggaa Iyyoobeeliyyuu booddee lafa qotiisaa isaa qulqulleesse lubichi akkuma baayʼina waggoota hamma waggaa Iyyoobeeliyyuu itti aanuutti jiraniitti herrega; gatiin shallagame gad buʼa. ");
INSERT INTO gaz_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Yoo namichi lafa qotiisaa isaa Waaqaaf addaan baasu sun lafa qotiisaa isaa furachuu barbaade, inni gatii hedametti harka shan keessaa harka tokko haa dabalu; lafti qotiisaa sunis deebiʼee kan isaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Taʼus yoo inni lafa qotiisaa sana furachuu baate, yookaan dabarsee nama biraatti gurgure, lafti qotiisaa sun deebiʼee furamuu hin dandaʼu. ");
INSERT INTO gaz_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Lafti qotiisaa sun yommuu Waggaa Iyyoobeeliyyuu keessa gad dhiifamutti akkuma lafa qotiisaa Waaqayyoof kennameetti addaan baafama; kunis qabeenya lubootaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","“ ‘Yoo namni tokko lafa qotiisaa dhaalaan hin argatin kan ofii isaatii bitate Waaqayyoof qulqulleesse, ");
INSERT INTO gaz_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","lubni gatii lafa qotiisaa sanaa hamma Waggaa Iyyoobeeliyyuutti herrega; namichis gatii herregame sana gaafuma sana kan Waaqayyoof qulqulleeffame godhee haa baasu. ");
INSERT INTO gaz_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Waggaa Iyyoobeeliyyuuttis lafti qotiisaa sun namichuma irraa bitame kan abbaa lafa qotiisaa sanaa tureef ni deebiʼa. ");
INSERT INTO gaz_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Gatiin hundinuu akka madaalii saqilii iddoo qulqulluutti jechuunis geeraan digdamni saqilii tokkootti herregama. ");
INSERT INTO gaz_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","“ ‘Taʼus namni tokko iyyuu horii hangafa qulqulleessuu hin dandaʼu; hangafti duraanuu Waaqayyoof qulqulleeffameeraatii; sangaas taʼu hoolaan hangafni kan Waaqayyoo ti. ");
INSERT INTO gaz_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Yoo horiin sun xuraaʼaa taʼe inni gatii herregame irratti harka shan keessaa harka tokko dabalee deebisee bitachuu dandaʼa. Yoo inni furachuu baate immoo horiin sun gatii isaaf herregametti gurgurama. ");
INSERT INTO gaz_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","“ ‘Garuu wanni namni qabu kan inni Waaqayyoof qulqulleessu tokko illee jechuunis namas taʼu horiin yookaan lafti dhaalaan argame hin gurguramu yookaan hin furamu. Wanni akkasiin qulqulleeffame hundinuu akka malee Waaqayyoof qulqulluudhaatii. ");
INSERT INTO gaz_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","“ ‘Namni akka ajjeefamuuf murteeffame tokko illee hin furamu; inni ajjeefamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","“ ‘Wanni lafti baaftu kam iyyuu sanyiis taʼu ija mukaa harka kudhan keessaa harki tokko kan Waaqayyoo ti; kun waan Waaqayyoof qulqulleeffamee dha. ");
INSERT INTO gaz_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Namni yoo kennaa isaa kan harka kudhan keessaa harka tokko taʼe sana furachuu barbaade inni gatii kennaa sanaaf herregame irratti harka shan keessaa harka tokko dabalee haa baasu. ");
INSERT INTO gaz_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Kennaan karra loonii fi bushaayee guutuu keessaa harka kudhan keessaa harka tokko taʼe jechuunis horiin ulee tiksee jala baʼee darbu hunda keessaa harka kudhan keessaa harki tokko Waaqayyoof qulqullaaʼa. ");
INSERT INTO gaz_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Inni horii jibbamaa keessaa horii gaarii hin filatin yookaan iddoo hin buusin; yoo inni iddoo buuse horiin lamaanuu qulqulluu taʼu; furamuus hin dandaʼu.’ ” ");
INSERT INTO gaz_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Kunneen ajajawwan Waaqayyo Gaara Siinaa irratti karaa Museetiin Israaʼelootaaf kennee dha.");
INSERT INTO gaz_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Erga sabni Israaʼel biyya Gibxiitii baʼee booddee waggaa lammaffaa keessaa, guyyaa jalqaba jiʼa lammaffaatti Waaqayyo dunkaana wal gaʼii keessatti, Gammoojjii Siinaa keessatti Museetti dubbate. Innis akkana jedheen; ");
INSERT INTO gaz_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","“Waldaa saba Israaʼel hunda lakkaaʼaatii balbala balbalaanii fi maatii maatiidhaan maqaa dhiirotaa tokko tokkoon barreessaa. ");
INSERT INTO gaz_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Namoota Israaʼel keessaa dhiirota umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hunda atii fi Aroon kutaa kutaa isaaniitiin lakkaaʼaa. ");
INSERT INTO gaz_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Tokkoo tokkoo gosaa keessaa namni hangafa maatii ofii isaa taʼe isin gargaaruu qaba. ");
INSERT INTO gaz_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","“Maqaan namoota isin gargaaruu qabanii kanneenii dha: “Gosa Ruubeen keessaa Eliizuur ilma Shedeeʼuur; ");
INSERT INTO gaz_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","gosa Simiʼoon keessaa Shilumiiʼeel ilma Zuriishadaayi; ");
INSERT INTO gaz_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","gosa Yihuudaa keessaa Nahishoon ilma Amiinaadaab; ");
INSERT INTO gaz_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","gosa Yisaakor keessaa Naatnaaʼel ilma Zuuwaar; ");
INSERT INTO gaz_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","gosa Zebuuloon keessaa Eliiyaab ilma Heeloon; ");
INSERT INTO gaz_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ilmaan Yoosef keessaa: gosa Efreem keessaa Eliishaamaa ilma Amiihuud; gosa Minaasee keessaa Gamaaliʼeel ilma Phedaasuur; ");
INSERT INTO gaz_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","gosa Beniyaam keessaa Abiidaan ilma Gaadeyoon, ");
INSERT INTO gaz_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","gosa Daan keessaa Ahiiʼezer ilma Amiishadaay; ");
INSERT INTO gaz_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","gosa Aasheer keessaa Fagiʼeel ilma Okraan; ");
INSERT INTO gaz_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","gosa Gaad keessaa Eliyaasaaf ilma Deʼuuʼeel; ");
INSERT INTO gaz_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","gosa Niftaalem keessaa Ahiiraa ilma Eenaan.” ");
INSERT INTO gaz_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Namoonni kunneen warra dura buʼoota gosoota abbootii isaanii taʼanii waldaa sana keessaa filatamanii dha. Isaanis hangafoota balbalawwan Israaʼel turan. ");
INSERT INTO gaz_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Musee fi Aroon namoota maqaan isaanii eerame kanneen fudhatanii, ");
INSERT INTO gaz_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","guyyaa jalqaba jiʼa lammaffaatti waldaa hunda walitti waaman. Namoonni sunis akkuma balbalaa fi maatii isaaniitti hidda dhaloota isaanii himatan; dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii maqaan isaanii tokko tokkoon galmeeffame; ");
INSERT INTO gaz_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","innis akkuma Waaqayyo Musee ajajetti Gammoojjii Siinaa keessatti saba sana lakkaaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Sanyii Ruubeen ilma Israaʼel hangaftichaa keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti tokko tokkoon maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Baayʼinni gosa Ruubeen nama 46,500 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Sanyii Simiʼoon keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti tokko tokkoon maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Baayʼinni gosa Simiʼoon nama 59,300 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Sanyii Gaad keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Baayʼinni gosa Gaad nama 45,650 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Sanyii Yihuudaa keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Baayʼinni gosa Yihuudaa nama 74,600 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Sanyii Yisaakor keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Baayʼinni gosa Yisaakor nama 54,400 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Sanyii Zebuuloon keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmeewwan balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Baayʼinni gosa Zebuuloon nama 57,400 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ilmaan Yoosef keessaa: Sanyii Efreem keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Baayʼinni gosa Efreem nama 40,500 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Sanyii Minaasee keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Baayʼinni gosa Minaasee nama 32,200 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Sanyii Beniyaam keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Baayʼinni gosa Beniyaam nama 35,400 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Sanyii Daan keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Baayʼinni gosa Daan nama 62,700 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Sanyii Aasheer keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaaniitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Baayʼinni gosa Aasheer nama 41,500 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Sanyii Niftaalem keessaa: Dhiironni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen lola dhaquu dandaʼan hundinuu akkuma galmee balbalaa fi maatii isaanitti maqaa maqaadhaan barreeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Baayʼinni gosa Niftaalem nama 53,400 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Dhiironni kunneen warra Musee fi Aroon hangafoota Israaʼel kudha lamaaniin lakkaaʼaman turan; hangafoonni kunneenis tokkoon tokkoon isaanii iddoo buʼoota maatii isaanii turan. ");
INSERT INTO gaz_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Israaʼeloonni umuriin isaanii waggaa digdamaatii fi hammasii olii kanneen Israaʼel keessatti lolaaf baʼuu dandaʼan hundinuu akkuma maatii isaaniitti lakkaaʼaman. ");
INSERT INTO gaz_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Walumaa galatti baayʼinni namaa 603,550 ture. ");
INSERT INTO gaz_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Lewwonni garuu akka gosa abbootii isaaniitti warra kaan wajjin hin lakkaaʼamne. ");
INSERT INTO gaz_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Waaqayyo Museedhaan akkana jedhee ture: ");
INSERT INTO gaz_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","“Ati gosa Lewwii hin lakkaaʼin yookaan lakkoobsa saba Israaʼeloota kaaniitti hin dabalin. ");
INSERT INTO gaz_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Qooda kanaa akka Lewwonni itti gaafatamtoota dunkaana dhuga baʼumsaa, miʼa isaa hundaa fi waan inni qabu hundaa taʼaniif isaan muudi. Isaanis dunkaana qulqulluu fi miʼa isaa hunda haa baatan; dunkaanicha haa tajaajilan; naannoo isaas haa qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Yeroo dunkaanni qulqulluun deemuu qabutti Lewwonni dunkaana sana haa buqqisan; yeroo dunkaanichi dhaabamus Lewwonni haa dhaaban. Namni dunkaanichatti dhiʼaatu biraa haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israaʼeloonnis tokkoon tokkoon namaa qubata isaa keessaa fi faajjii isaa jalatti kutaa kutaadhaan dunkaana isaanii haa dhaabbatan. ");
INSERT INTO gaz_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Taʼus Lewwonni akka dheekkamsi Waaqayyoo waldaa Israaʼelitti gad hin buuneef dunkaanota isaanii naannoo dunkaana dhuga baʼumsaa haa dhadhaabatan. Lewwonni eegumsa dunkaana dhuga baʼumsaatti itti gaafatamtoota taʼuu qabu.” ");
INSERT INTO gaz_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israaʼeloonni akkuma Waaqayyo Musee ajaje sanatti waan kana hunda hojjetan. ");
INSERT INTO gaz_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Waaqayyo Musee fi Arooniin akkana jedhe: ");
INSERT INTO gaz_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","“Israaʼeloonnis tokkoon tokkoon namaa faajjii ofii isaanii jalatti faajjii maatii isaa wajjin dunkaana irraa xinnuma fagaatee naannoo dunkaana wal gaʼii haa qubatu.” ");
INSERT INTO gaz_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Gama baʼaatiin, karaa baʼa biiftuutiin: kutaawwan qubata Yihuudaa faajjii isaanii jala haa qubatan. Hoogganaan ijoollee Yihuudaa Nahishoon ilma Amiinaadaabii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Lakkoobsi kutaa isaas namoota 74,600. ");
INSERT INTO gaz_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Gosti Yisaakor isaanitti aanee haa qubatu. Hoogganaan ijoollee Yisaakor Naatnaaʼel ilma Zuuwaar ture. ");
INSERT INTO gaz_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Lakkoobsi kutaa isaas namoota 54,400. ");
INSERT INTO gaz_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Gosti Zebuuloon kanatti haa aanu. Hoogganaan ijoollee Zebuuloon Eliiyaab ilma Heeloonii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Lakkoobsi kutaa isaas namoota 57,400. ");
INSERT INTO gaz_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Namoonni qubata Yihuudaatti lakkaaʼaman hundis akkuma kutaa kutaa isaaniitti 186,400 turan. Isaanis duraan dursanii qajeelu. ");
INSERT INTO gaz_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Gama kibbaatiin: kutaawwan qubata Ruubeen faajjii isaanii jalaan haa qubatan. Hoogganaan ijoollee Ruubeen Eliizuur ilma Shedeeʼuurii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Lakkoobsi kutaa isaas namoota 46,500. ");
INSERT INTO gaz_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Gosti Simiʼoon isaanitti aanee haa qubatu. Hoogganaan gosa Simiʼoon Shilumiiʼeel ilma Zuriishadaayii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Lakkoobsi kutaa isaas namoota 59,300. ");
INSERT INTO gaz_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gosti Gaad isaanitti haa aanu. Hoogganaan gosa Gaad Eliyaasaaf ilma Deʼuuʼeelii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Lakkoobsi kutaa isaas namoota 45,650. ");
INSERT INTO gaz_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Namoonni qubata Ruubeenitti lakkaaʼaman hundis akkuma kutaa kutaa isaaniitti 151,450 turan. Isaan kunneenis warra duraatti aananii deemu. ");
INSERT INTO gaz_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Ergasiis dunkaanni wal gaʼiitii fi qubanni Lewwotaa qubatawwan gidduu haa deeman. Isaanis akkuma toora qubata isaaniitti tokkoon tokkoon isaanii iddoo isaanii eeggatanii faajjii isaanii jala haa deeman. ");
INSERT INTO gaz_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Gama dhiʼaatiin gareen qubata Efreem faajjii isaanii jalaan haa qubatan. Hoogganaan ilmaan Efreem Eliishaamaa ilma Amiihuudii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Lakkoobsi kutaa isaas namoota 40,500: ");
INSERT INTO gaz_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Gosti Minaasee isaanitti haa aanu. Hoogganaan ijoollee Minaasee Gamaaliʼeel ilma Phedaasuurii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Lakkoobsi kutaa isaas namoota 32,200. ");
INSERT INTO gaz_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Gosti Beniyaam itti haa aanu. Hoogganaan ilmaan Beniyaam Abiidaan ilma Gaadeyoonii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Lakkoobsi kutaa isaas namoota 35,400: ");
INSERT INTO gaz_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Namoonni qubata Efreemitti lakkaaʼaman hundis kutaa kutaa isaaniitti 108,100 turan. Isaan kunneen immoo kutaa sadaffaa taʼanii deeman. ");
INSERT INTO gaz_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Gama kaabaatiin kutaawwan qubata Daan faajjii isaanii jalaan haa qubatan. Hoogganaan gosa Daan Ahiiʼezer ilma Amiishadaayii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Lakkoobsi kutaa isaas namoota 62,700. ");
INSERT INTO gaz_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Gosti Aasheer isaanitti aanee haa qubatu. Hoogganaan ijoollee Aseer Fagiʼeel ilma Okraanii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Lakkoobsi kutaa isaas namoota 41,500: ");
INSERT INTO gaz_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Gosti Niftaalemitti haa aanu. Hoogganaan ijoollee Niftaalem Ahiiraa ilma Eenaanii ti. ");
INSERT INTO gaz_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Lakkoobsi kutaa isaas namoota 53,400: ");
INSERT INTO gaz_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Namoonni qubata Daaniitti lakkaaʼaman hundis 157,600 turan. Isaanis dhuma irratti faajjii isaanii jalaan haa deeman. ");
INSERT INTO gaz_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Namoonni kunneen saba Israaʼel warra akkuma maatii isaaniitti lakkaaʼamanii dha. Lakkoobsi warra qubata keessaa kanneen kutaa kutaa isaaniitiin lakkaaʼaman hundaa 603,550. ");
INSERT INTO gaz_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lewwonni garuu akkuma Waaqayyo Musee ajaje sanatti Israaʼeloota kaan wajjin hin lakkaaʼamne. ");
INSERT INTO gaz_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Akkasiin Israaʼeloonni waan Waaqayyo Musee ajaje hunda hojjetan; isaanis haaluma kanaan faajjii isaanii jala haa qubatan; haaluma kanaanis tokkoon tokkoon isaanii balbalaa fi maatii isaanii wajjin baʼanii haa deeman. ");
INSERT INTO gaz_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Yeroo Waaqayyo Tulluu Siinaa irratti Museetti dubbatetti seenaan sanyii Aroonii fi Musee kanaa dha. ");
INSERT INTO gaz_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Maqaan ilmaan Aroon: Naadaab hangafticha, Abiihuu, Eleʼaazaarii fi Iitaamaar. ");
INSERT INTO gaz_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Kunneen maqaawwan ilmaan Aroon jechuunis luboota muudaman kanneen akka luboota taʼanii tajaajilaniif dibaman sanaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Naadaabii fi Abiihuu garuu yeroo Gammoojjii Siinaa keessatti ibidda hin eeyyamamin fuula Waaqayyoo duratti dhiʼeessanitti fuuluma isaa duratti duʼan. Isaan ilmaan tokko illee hin qaban ture. Kanaafuu Eleʼaazaarii fi Iitaamaar bara abbaan isaanii Aroon lubbuun jiraatetti luboota taʼanii tajaajilan. ");
INSERT INTO gaz_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","“Gosa Lewwii fidiitii akka isaan Aroon lubicha gargaaraniif isa dura dhaabi. ");
INSERT INTO gaz_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Isaanis hojii dunkaana qulqulluu hojjechuudhaan waan isa irraa barbaadamuu fi waan waldaa hunda irraa barbaadamu fuula dunkaana wal gaʼii duratti haa raawwatan. ");
INSERT INTO gaz_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Isaan hojii dunkaana qulqulluu hojjetanii dirqama Israaʼelootaa guutuudhaan miʼa dunkaana wal gaʼii hunda haa eegan. ");
INSERT INTO gaz_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Lewwota sana Aroonii fi ilmaan isaatti kenni; isaan warra saba Israaʼel keessaa guutumaan guutuutti isatti kennamanii dha. ");
INSERT INTO gaz_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Ati akka isaan luboota taʼanii tajaajilaniif Aroonii fi ilmaan isaa muudi; namni biraa kan iddoo qulqulluu sanatti dhiʼaatu garuu ajjeefamuu qaba.” ");
INSERT INTO gaz_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","“Kunoo ani Israaʼeloota keessaa qooda dhiira hangafa dubartoota Israaʼel hundaa Lewwota fudhadheera. Lewwonni kan koo ti; ");
INSERT INTO gaz_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","hangafti hundinuu kan kootii. Ani yeroo biyya Gibxi keessatti hangafa hunda ajjeesetti hangafa Israaʼel hunda jechuunis namas taʼu horii ofii kootiif addaan baafadheera. Isaan kan koo taʼan. Ani Waaqayyo.” ");
INSERT INTO gaz_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Waaqayyo Gammoojjii Siinaa keessatti Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","“Lewwota maatii isaaniitii fi balbala isaaniitiin lakkaaʼi. Dhiira jiʼa tokkoo yookaan hammasii olii hunda lakkaaʼi.” ");
INSERT INTO gaz_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Museen akkuma dubbiin Waaqayyoo isa ajajetti isaan lakkaaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Kunneen maqaawwan ilmaan Lewwii ti: Geershoon, Qohaatii fi Meraarii. ");
INSERT INTO gaz_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Kunneen maqaawwan ilmaan Geershoonii ti: Loobeenii fi Shimeʼii. ");
INSERT INTO gaz_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Balbalawwan Qohaatotaa: Amraam, Yizihaar, Kebroonii fi Uziiʼeel. ");
INSERT INTO gaz_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Balbalawwan Meraarotaa: Mahilii fi Muusii. ");
INSERT INTO gaz_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Balbalawwan Liibnii fi Shimeʼii kan Geershoon turan; isaanis balbalawwan Geershoonotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Baayʼinni dhiirota umuriin isaanii jiʼa tokkoo fi hammasii olii kanneen lakkaaʼaman hundaa 7,500 ture. ");
INSERT INTO gaz_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Balbalawwan Geershoonotaa karaa lixa biiftuutiin dunkaana qulqulluu dugda duubaan qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Hoogganaan balbalawwan Geershoonotaas Eliyaasaaf ilma Laaʼel ture. ");
INSERT INTO gaz_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Itti gaafatamni Geershoononni dunkaana wal gaʼii keessatti qabanis dunkaana qulqulluu, dunkaanaa fi irra buusaa isaa, golgaa balbala dunkaana wal gaʼii irra jiru, ");
INSERT INTO gaz_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","golgaawwan oobdii, golgaa balbala dallaa kan dunkaana qulqulluu fi iddoo aarsaatti naannaʼee jiru, funyoo fi tajaajila akkanaa kennu hunda eeguu ture. ");
INSERT INTO gaz_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Balbalawwan Amraamotaa, Yizihaarotaa, Kebroonotaa fi Uziiʼeelotaa balbalawwan Qohaatii ti; isaanis balbalawwan Qohaatotaa turan. ");
INSERT INTO gaz_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Baayʼinni dhiirota jiʼa tokkoo fi hammasii olii hundaa 8,600 ture. Qohaatonni iddoo qulqulluu sana eeguutti itti gaafatamtoota turan. ");
INSERT INTO gaz_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Balbalawwan Qohaatotaa karaa kibba dunkaana qulqulluutiin qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Hoogganaan maatiiwwan balbalawwan Qohaatotaas Eliisaafaan ilma Uziiʼeel ture. ");
INSERT INTO gaz_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Isaanis taabota, minjaala, baattuu ibsaa, iddoowwan aarsaa, miʼa iddoo qulqulluu ittiin tajaajilan, golgaa fi wantoota tajaajila akkanaa kennan hunda eeguutti itti gaafatamtoota turan. ");
INSERT INTO gaz_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Hoogganaan Lewwotaa hangafti Eleʼaazaar ilma Aroon lubichaa ture. Innis warra itti gaafatamtoota eegumsa iddoo qulqulluu turan sana irratti dibame. ");
INSERT INTO gaz_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Balbalawwan Mahelootaa fi Muusotaa kan Meraarii turan; isaanis balbalawwan Meraarotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Baayʼinni dhiirota umuriin isaanii jiʼa tokkoo fi hammasii olii kanneen lakkaaʼaman hundaa 6,200 ture. ");
INSERT INTO gaz_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Hoogganaan maatiiwwan balbalawwan Meraarotaas Zuriiʼel ilma Abiihaayilii ti; isaanis karaa kaaba dunkaana qulqullummaatiin qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Meraaronnis tuggeewwan dunkaana qulqulluu, dagaleewwan isaa, utubaawwan isaa, miillawwan isaa, miʼa isaa hundaa fi wantoota tajaajila akkanaa kennan hunda, ");
INSERT INTO gaz_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","akkasumas utubaawwan oobdii sanatti naannaʼanii jiran, miillawwan isaanii, qofoo dunkaanaa fi funyoowwan isaa eeguuf muudaman. ");
INSERT INTO gaz_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Museen, Aroonii fi ilmaan Aroon dunkaana qulqulluu irraa karaa baʼaa, qixa baʼa biiftuutiin fuula dunkaana wal gaʼii dura qubatan. Isaanis iddoo Israaʼelootaa buʼanii iddoo qulqulluu eeguutti itti gaafatamtoota turan. Namni biraa kan iddoo qulqulluu sanatti dhiʼaatu haa ajjeefamu. ");
INSERT INTO gaz_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Lewwonni lakkaaʼaman hundi kanneen Musee fi Aroon ajaja Waaqayyootiin akkuma balbala balbala isaaniitti lakkaaʼan, dhiironni jiʼa tokkoo fi hammasii olii hundi 22,000 turan. ");
INSERT INTO gaz_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Waaqayyo Museedhaan akkana jedhe; “Dhiirota Israaʼel hangafoota kanneen jiʼa tokkootii fi hammasii olii hunda lakkaaʼii maqaa isaanii barreessi. ");
INSERT INTO gaz_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Qooda ijoollee Israaʼel kanneen hangafa taʼan hundaa Lewwota naa fudhadhu; qooda ilmaan hangafa horii Israaʼelootaa hundaas horii Lewwotaa naa fudhadhu. Ani Waaqayyo.” ");
INSERT INTO gaz_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Museen akkuma Waaqayyo isa ajajetti hangafoota Israaʼel hunda lakkaaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Dhiironni hangafoonni jiʼa tokkoo fi hammasii olii kanneen maqaa maqaan barreeffaman hundii 22,273 turan. ");
INSERT INTO gaz_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","“Qooda ijoollee Israaʼel kanneen hangafa taʼan hundaa Lewwota fudhadhu; qooda horii Israaʼelootaas horii Lewwotaa fudhadhu. Lewwonni kan koo ti. Ani Waaqayyo. ");
INSERT INTO gaz_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Israaʼeloota hangafoota 273 kanneen baayʼina Lewwotaa caalan furuuf, ");
INSERT INTO gaz_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","tokkoo tokkoo isaaniitiif akkuma madaalii saqilii iddoo qulqulluutti saqilii shan shan fuudhi; saqiliin tokko geeraa digdama. ");
INSERT INTO gaz_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Maallaqa Israaʼeloota dabalaman furuuf fuudhame sanas Aroonii fi ilmaan isaatti kenni.” ");
INSERT INTO gaz_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Museen maallaqa sana Israaʼeloota lakkoobsaan warra Lewwotaan furamaniin ol taʼan sana irraa fuudhe. ");
INSERT INTO gaz_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Innis akka madaalii saqilii iddoo qulqulluutti meetii saqilii 1,365 ulfaattu Israaʼeloota hangafa irraa fuudhe. ");
INSERT INTO gaz_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Museenis akkuma dubbii Waaqayyootti, akkuma Waaqni Musee ajajetti maallaqa furii sana Aroonii fi ilmaan isaatti kenne. ");
INSERT INTO gaz_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Waaqayyo Musee fi Arooniin akkana jedhe: ");
INSERT INTO gaz_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","“Lewwota keessaa gosa Qohaatotaa balbala balbalaa fi maatii maatii isaaniitiin lakkaaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Dhiirota umuriin isaanii waggaa soddomaa hamma shantamaa kanneen hojii dunkaana wal gaʼii hojjechuuf dhufan hunda lakkaaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","“Hojiin Qohaatonni wantoota waan hunda caalaa qulqulluu taʼaniin wal qabatee dunkaana wal gaʼii keessatti hojjetan kanaa dha. ");
INSERT INTO gaz_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Yommuu qubanni deemuuf kaʼutti Aroonii fi ilmaan isaa ol galanii golgaa daʼeessu sana gad haa buusan; golgaa sanaanis taabota kakuu seeraatti haa haguugan. ");
INSERT INTO gaz_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Waan kanattis gogaa duugame uffisanii huccuu bifti isaa guutumaan guutuutti cuquliisa taʼe irraan haa afan. Danqaraawwanis iddoo iddoo isaanii keessa haa galchan. ");
INSERT INTO gaz_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","“Isaanis huccuu bifa cuquliisaa tokko minjaala Buddeena Ilaalchaatti uffisanii gabatee, caabii fi waciitii akkasumas okkotee ittiin dhibaayyuu dhiʼeessan isa irra haa kaaʼan; buddeenni yeroo hunda achii hin dhabamne sunis isa irra haa kaaʼamu. ");
INSERT INTO gaz_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Huccuu bildiimaa isaan irra haa diriirsan; gogaa duugame itti haa uwwisan; danqaraawwan isaas iddoo isaanii keessa haa galchan. ");
INSERT INTO gaz_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","“Huccuu bifti isaa cuquliisaa fuudhanii baattuu ibsaa kan ibsuuf tolchame ibsaa isaa wajjin, waan ittiin foʼaa ibsaa kutanii fi baattuu daaraa, meeshaawwan zayitii kanneen hojii kanaaf oolan hundas ittiin haa haguugan. ");
INSERT INTO gaz_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Ergasiis waan kanaa fi miʼa isaa hunda gogaa duugameen maranii wasaasaa ittiin waa baatan irra haa kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","“Huccuu biftii isaa cuquliisa taʼes iddoo aarsaa kan warqee irraa hojjetametti uffisanii gogaa duugame itti haa haguugan; danqaraawwan isaas iddoo isaanii keessa haa galchan. ");
INSERT INTO gaz_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","“Meeshaawwan ittiin iddoo qulqulluu keessa tajaajilan hundas fuudhanii huccuu bifa cuquliisaatiin maranii gogaa duugameen haguuganii wasaasaa ittiin waa baatan irra haa kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","“Isaanis iddoo aarsaa irraa daaraa haranii huccuu diimaa dhiilgee itti haa uffisan. ");
INSERT INTO gaz_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Ergasiis miʼa iddoo aarsaa ittiin tajaajilan hunda, baattuu ibiddaa, qabduuwwan foonii, meeshaa ittiin daaraa hammaaranii fi waciitii isa irra haa kaaʼan. Gogaa duugamee isa irraan haa afan; danqaraawwan isaas iddoo isaanii keessa haa galchan. ");
INSERT INTO gaz_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","“Erga Aroonii fi ilmaan isaa meeshaawwan qulqulluu sanaa fi miʼa qulqulluu hunda haguuganii fixanii booddee yeroo qubanni sun godaanuuf kaʼutti Qohaatonni miʼa kana baachuudhaaf haa dhufan. Isaan garuu miʼa qulqulluu sana hin tuqin; yoo tuqan ni duʼuutii. Qohaatonni waan dunkaana wal gaʼii keessa jiru hunda haa baatan. ");
INSERT INTO gaz_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","“Eleʼaazaar ilmi Aroon lubichaa itti gaafatamaa zayitii ibsaa, ixaana urgaaʼaa, kennaa midhaanii kan yeroo baayʼee dhiʼeeffamuu fi zayitii ittiin dibanii haa taʼu. Inni dunkaana qulqulluu hundaa fi waan isa keessa jiru hundatti, miʼaa fi meeshaawwan isaa qulqulluuttis itti gaafatamaa haa taʼu.” ");
INSERT INTO gaz_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Waaqayyo Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","“Balbalawwan gosa Qohaatii Lewwota keessaa hin balleessinaa. ");
INSERT INTO gaz_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Akka isaan yommuu wantoota waan hunda caalaa qulqulluu taʼanitti dhiʼaatanitti, akka lubbuun jiraatan malee hin duuneef waan kana isaaniif godhaa: Aroonii fi ilmaan isaa iddoo qulqulluu seenanii waan tokkoon tokkoon namaa hojjetuu fi baatu haa qoqqoodan. ");
INSERT INTO gaz_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Qohaatonni garuu akka hin duuneef yeroo xinnaaf illee wantoota qulqulluu ilaaluudhaaf ol seenuu hin qaban.” ");
INSERT INTO gaz_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Waaqayyo Museen akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","“Geershoonotas maatii maatii isaanii fi balbala balbala isaaniitiin lakkaaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Dhiirota umuriin isaanii waggaa soddomaa hamma shantamaa kanneen hojii dunkaana wal gaʼii hojjechuu dhufan hunda lakkaaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","“Tajaajilli balbalawwan Geershoonotaa hojii hojjechuu fi baʼaa baachuudhaan tajaajilan kanaa dha: ");
INSERT INTO gaz_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Isaan golgaa dunkaana qulqulluu, dunkaana wal gaʼii, uffata isaa fi irra buusaa isaa kan gogaa duugame irraa hojjetame, golgaa balbala dunkaana wal gaʼii, ");
INSERT INTO gaz_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","golgaawwan dallaa dunkaana qulqulluu fi iddoo aarsaatti naannaʼee jiru sanaa, golgaa balbala isaa, funyoo fi miʼa tajaajila kanaaf fayyadu hunda baatu. Geershoononni waan wantoota kanaan hojjetamuu qabu hunda haa hojjetan. ");
INSERT INTO gaz_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tajaajilli Geershoonotaa hundi baʼaa baachuus taʼu hojiin biraa ajaja Aroonii fi ilmaan isaa kennaniin haa adeemsifamu. Waan isaan baachuu qaban hundas akkuma itti gaafatama isaaniitti qoqoodaafii. ");
INSERT INTO gaz_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Tajaajilli balbalawwan Geershoonotaa dunkaana wal gaʼiitti kennan kanaa dha. Hojiin isaaniis Iitaamaar ilma Aroon lubichaatiin haa qajeelfamu. ");
INSERT INTO gaz_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","“Meraarota balbala balbalaa fi maatii maatii isaaniitiin lakkaaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","Dhiirota umuriin isaanii waggaa soddomaa hamma shantamaa kanneen hojii dunkaana wal gaʼii hojjechuuf dhufan hunda lakkaaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Wanni isaan yeroo hojii dunkaana wal gaʼii hojjetanitti godhan kanaa dha: kunis tuggeewwan dunkaana qulqulluu, dagaleewwan isaa, utubootaa fi miillawwan isaanii, ");
INSERT INTO gaz_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","utuboota oobdiitti naannaʼanii jiran miillawwan isaanii wajjin, qofoowwan dunkaanaa, funyoowwan, miʼa isaanii hundaa fi wantoota hojii kanaaf fayyadan hunda baachuu dha. Isinis waan tokkoon tokkoon namaa baatu addaan baasaatii ramadaafii. ");
INSERT INTO gaz_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tajaajilli balbalawwan Meraarotaa qajeelfama Iitaamaar ilma Aroon lubichaa jala dunkaana wal gaʼii keessatti kennan kanaa dha.” ");
INSERT INTO gaz_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Museen, Aroonii fi hooggantoonni waldaas Qohaatota balbala balbalaa fi maatii maatii isaaniitiin lakkaaʼan. ");
INSERT INTO gaz_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","Dhiironni umuriin isaanii waggaa soddomaa hamma shantamaa kanneen hojii dunkaana wal gaʼii keessaa sana keessa hojjechuuf dhufan hundi ");
INSERT INTO gaz_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","balbala balbalaan lakkaaʼamanii 2,750 turan. ");
INSERT INTO gaz_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Kun lakkoobsa balbalawwan Qohaatota warra dunkaana wal gaʼii keessa hojjechaa turanii ti. Musee fi Aroon akkuma ajaja Waaqayyoo kan karaa Museetiin kennameetiin isaan lakkaaʼan. ");
INSERT INTO gaz_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Geershoononni balbala balbalaa fi maatii maatii isaaniitiin lakkaaʼaman. ");
INSERT INTO gaz_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","Dhiironni umuriin isaanii waggaa soddomaa hamma shantamaa kanneen hojii dunkaana wal gaʼii keessa hojjechuuf dhufan hundi ");
INSERT INTO gaz_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","balbala balbalaa fi maatii maatii isaaniitiin lakkaaʼamanii 2,630 turan. ");
INSERT INTO gaz_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Balbalawwan Geershoonotaa, warri hojii dunkaana wal gaʼii keessa hojjetan kanneen Musee fi Aroon akkuma ajaja Waaqayyootti lakkaaʼan hundi kanneenii dha. ");
INSERT INTO gaz_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Meraaronnis balbala balbalaa fi maatii maatii isaaniitiin lakkaaʼaman. ");
INSERT INTO gaz_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","Dhiironni umuriin isaanii waggaa soddomaa hamma shantamaa kanneen hojii dunkaana wal gaʼii keessa tajaajiluu dhufan hundi ");
INSERT INTO gaz_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","balbala balbala isaaniitiin lakkaaʼamanii 3,200 turan. ");
INSERT INTO gaz_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Warri balbalawwan Meraarotaa keessaa lakkaaʼaman kanneen Musee fi Aroon akkuma ajaja Waaqayyoo kan karaa Museetiin kenname sanaatti lakkaaʼan kanneenii dha. ");
INSERT INTO gaz_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Museen, Aroonii fi hooggantoonni Israaʼel Lewwota hunda balbala balbalaa fi maatii maatii isaaniitiin lakkaaʼan. ");
INSERT INTO gaz_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","Dhiironni umuriin isaanii waggaa soddomaa hamma shantamaa kanneen hojii tajaajilaa hojjechuu fi dunkaana wal gaʼii baachuu dhufanii ");
INSERT INTO gaz_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","lakkaaʼaman hundi 8,580 turan. ");
INSERT INTO gaz_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Isaanis akkuma ajaja Waaqayyoo kan karaa Museetiin kennameetiin tokkoon tokkoon isaanii waan hojjechuu qabanitti ramadaman; wanni isaan baachuu qabanis isaanitti himame. Akkasiin isaan akkuma Waaqayyo Musee ajajetti lakkaaʼaman. ");
INSERT INTO gaz_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","“Nama dhukkuba gogaa kan namatti darbu qabu yookaan nama dhangalaʼaa dhagnaa qabu yookaan nama sababii waan duʼe tokkootiin xuraaʼaa taʼe kam iyyuu akka qubata keessaa baasaniif saba Israaʼel ajaji. ");
INSERT INTO gaz_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Dhiiras dubartiis gad baasaa; akka isaan qubata isaanii iddoo ani gidduu isaanii jiraadhu sana hin xureessineef qubata keessaa isaan baasaa.” ");
INSERT INTO gaz_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Israaʼeloonnis akkanuma godhanii qubata keessaa isaan baasan. Isaanis akkuma Waaqayyo Museetti hime sana godhan. ");
INSERT INTO gaz_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","“Warra Israaʼeliin akkana jedhi: ‘Yoo dhiirri yookaan dubartiin tokko karaa kamiin iyyuu nama kaanitti balleessa hojjechuudhaan Waaqayyo duratti amanamummaa dhabe, namni sun yakkamaa dha; ");
INSERT INTO gaz_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","cubbuu hojjetes himachuu qaba. Yakka isaatiifis guutumaan guutuutti haa kiisu. Kiisii sana irrattis harka shan keessaa harka tokko dabalee namicha miidhame sanaaf haa kennu. ");
INSERT INTO gaz_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Namni yakki isa irratti hojjetame sun yoo fira aantee kan kiisii sana isaaf fuudhu qabaachuu baate garuu kiisiin sun kan Waaqayyoo ti; korbeessa hoolaa ittiin araarri isaaf buufamu wajjin lubaaf haa kennamu. ");
INSERT INTO gaz_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Buusiiwwan qulqulluun Israaʼeloonni lubatti fidan hundi kan isaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Wantoonni qulqulluun kanuma abbootii isaanii ti; wanni isaan lubichaaf kennan garuu kanuma lubichaa ti.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Ergasii Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","“Akkana jedhiitii saba Israaʼelitti dubbadhu: ‘Yoo niitiin nama kamii iyyuu karaa irraa baduudhaan isaaf amanamuu baattee ");
INSERT INTO gaz_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","dhiira biraa wajjin ciifte, yoo dhirsi ishees waan kana beekuu baate, yoo xuraaʼummaan ishee akkuma dhokatetti hafe, yoo namni ishee irratti dhugaa baʼu hin argamin, isheen yoo waan kana irratti hin qabamin, ");
INSERT INTO gaz_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","yoo dhirsa ishee hafuurri hinaaffaa qabatee inni niitii isaa shakke, yoo isheen xurooftuu taate yookaan yoo inni hinaafee ishee shakkee isheen xurooftuu hin taʼin, ");
INSERT INTO gaz_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","inni niitii isaa lubatti haa geessu. Akkasumas inni kennaa daakuu garbuu iifii harka kudhan keessaa harka tokko qooda ishee haa geessu. Kennaan midhaanii kan sababii hinaaffaatiif dhiʼeeffamu kun waan kennaa yaadannoo kan yakka yaadachiisu taʼeef, inni zayitii fi ixaana itti naquu hin qabu. ");
INSERT INTO gaz_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","“ ‘Lubichis ishee fidee fuula Waaqayyoo dura ishee haa dhaabu. ");
INSERT INTO gaz_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","Ergasii inni bishaan qulqulluu okkotee supheetti haa naqu; lafa dunkaana qulqulluu irraa biyyoo fuudhee bishaan sana keessa haa buusu. ");
INSERT INTO gaz_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Lubichis erga dubartii sana fuula Waaqayyoo dura dhaabee booddee rifeensa mataa ishee hiikee kennaa yaadannoo jechuunis kennaa midhaanii kan hinaaffaaf dhiʼeeffamu sana harka ishee keessa kaaʼa; bishaan hadhaaʼaa abaarsa fidu sanas harka ofiitti qabata. ");
INSERT INTO gaz_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Lubichis dubartii sana ni kakachiisa; akkanas jedhaan; “Yoo utuu ati dhirsa qabduu namni biraa si wajjin hin ciisinii fi yoo ati karaa irraa baddee hin xuraaʼin bishaan hadhaaʼaan abaarsa fidu kun si hin miidhin. ");
INSERT INTO gaz_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Garuu ati yoo karaa irraa baddee utuu dhirsa qabduu nama dhirsa kee hin taʼin wajjin ciiftee of xureessitee argamte;” ");
INSERT INTO gaz_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","kana irratti lubichi kakaa abaarsaa ishee kakachiisa; akkanas jedhaan; “Waaqayyo gudeeda kee tortorsee garaa kee illee bokoksee saba kee gidduutti kakaa fi abaarsaaf si haa godhu. ");
INSERT INTO gaz_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","Akka garaan kee bokokuu fi akka gudeedni kee tortoruuf bishaan abaarsa fidu kun dhagna kee haa seenu.” “ ‘Dubartiin sunis, “Ameen, ameen” haa jettu. ");
INSERT INTO gaz_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","“ ‘Lubichis abaarsawwan sana kitaaba maramaa irratti haa barreessu; ergasiis bishaan hadhaaʼaa sanatti irraa haa dhiqu. ");
INSERT INTO gaz_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Innis akka dubartiin sun bishaan hadhaaʼaa abaarsa fidu sana dhugdu haa godhu; bishaan abaarsaa fi dhiphina hamaa fidu sunis ishee seena. ");
INSERT INTO gaz_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Lubichis kennaa midhaanii kan hinaaffaa sana ishee harkaa fuudhee fuula Waaqayyoo duratti sochoosee gara iddoo aarsaa fida. ");
INSERT INTO gaz_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Lubni sunis kennaa midhaanii sana irraa konyee tokko kennaa yaadannootiif fuudhee iddoo aarsaa irratti haa gubu; ergasiis akka dubartiin sun bishaan sana dhugdu haa godhu. ");
INSERT INTO gaz_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Yoo isheen of xureessitee dhirsa isheetiif amanamuu baatte, yommuu isheen bishaan abaarsa fidu sana dhugdutti bishaan sun ishee seenee dhiphina hamaa isheetti fida; garaan ishee ni bokoka; gudeedni ishee ni tortora; isheenis saba ishee biratti abaaramtuu taati. ");
INSERT INTO gaz_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Garuu yoo dubartiin sun of xureessuu baattee fi yoo qulqulluu taate isheen yakka irraa bilisa taati; daʼuus ni dandeessi. ");
INSERT INTO gaz_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","“ ‘Yoo dubartiin utuma dhirsa qabduu karaa irraa gortee of xureessite ");
INSERT INTO gaz_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","yookaan yoo dhiirri sababii niitii ofii shakkuuf hafuurri hinaaffaa isa qabate, seerri hinaaffaaf kenname kanaa dha. Lubichi dubartii sana fuula Waaqayyoo dura dhaabee seera kana hunda ishee irratti haa raawwatu. ");
INSERT INTO gaz_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Dhirsi sun balleessaa irraa bilisa taʼa; dubartiin sun garuu gatii cubbuu ishee argatti.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","“Akkana jedhii saba Israaʼelitti dubbadhu: ‘Dhiirri yookaan dubartiin tokko yoo Waaqayyoof addaan of baasuuf wareega addaa yookaan wareega Naazirummaa wareegan, ");
INSERT INTO gaz_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","daadhii wayinii fi dhugaatii nama macheessu irraa of haa eeggatan; namni sun dhangaggaaʼaa daadhii wayinii irraa hojjetame yookaan dhangaggaaʼaa dhugaatii nama macheessuu biraa hin dhugin. Inni cuunfaa gumaa wayinii dhuguu yookaan ija wayinii asheetii yookaan goggogaa isaa nyaachuu hin qabu. ");
INSERT INTO gaz_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Innis bara Naazirummaa isaa hunda keessa waan gumaa wayinii irraa argamu kam iyyuu sanyii isaas taʼu qola isaa nyaachuu hin qabu. ");
INSERT INTO gaz_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","“ ‘Bara wareega addaan baafamuu isaa hunda keessa qarabaan tokko iyyuu mataa isaa hin tuqin. Hamma yeroon inni itti Waaqayyoof addaan baafame sun xumuramutti inni qulqulluu haa taʼu; akka rifeensi mataa isaa guddatuufis gad haa dhiisu. ");
INSERT INTO gaz_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","“ ‘Naazirichi bara Waaqayyoof addaan of baase hunda keessa reeffatti dhiʼaachuu hin qabu. ");
INSERT INTO gaz_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Sababii mallattoon inni ittiin Waaqayyoof addaan baafame mataa isaa irra jiruuf yoo abbaan isaa yookaan haati isaa, obboleessi isaa yookaan obboleettiin isaa duʼan illee isaaniif jedhee akka seeraatti of hin xureessin. ");
INSERT INTO gaz_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Inni bara itti addaan baafame sana hunda keessa kan Waaqayyoof qulqulleeffamee dha. ");
INSERT INTO gaz_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","“ ‘Yoo namni tokko iddoo Naazirichi jirutti akka tasaa duʼee akkasiin rifeensa inni addaan baase sana xureesse, inni guyyaa itti qulqulleeffamutti jechuunis guyyaa torbaffaatti mataa isaa haa haaddatu. ");
INSERT INTO gaz_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Ergasiis inni guyyaa saddeettaffaatti gugee lama yookaan gugee sosookkee lama balbala dunkaana wal gaʼii irratti lubatti haa fidu. ");
INSERT INTO gaz_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Sababii inni iddoo reeffi jirutti argamuudhaan cubbuu hojjeteef lubichi isa tokko aarsaa cubbuu, isa kaan immoo aarsaa gubamu godhee araara buusuuf haa dhiʼeessuuf. Guyyuma sanas rifeensa mataa isaa addaan haa baasu. ");
INSERT INTO gaz_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Inni yeroo itti addaan baafame keessa ammas Waaqayyoof addaan of haa baasu; xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼes aarsaa yakkaa godhee haa fidu. Garuu sababii inni yeroo addaan baʼiisa isaa keessa xureeffameef guyyoonni darban hin lakkaaʼaman. ");
INSERT INTO gaz_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","“ ‘Egaa yeroo addaan baʼumsi isaa xumuramutti seerri Naazirichaa kanaa dha: Inni gara karra dunkaana wal gaʼiitti haa fidamu. ");
INSERT INTO gaz_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Achitti aarsaa isaa Waaqayyoof haa dhiʼeessu; kunis xobbaallaa korbeessa hoolaa hirʼina hin qabnee kan umuriin isaa waggaa tokko taʼe aarsaa gubamuuf, xobbaallaa hoolaa dhaltuu hirʼina hin qabne kan umuriin ishee waggaa tokko taʼe aarsaa cubbuutiif, korbeessa hoolaa hirʼina hin qabne aarsaa nagaatiif, ");
INSERT INTO gaz_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","kana wajjinis Maxinoo gundoo tokko, Maxinoo daakuu bullaaʼaa irraa tolfame kan zayitiidhaan sukkuumame, bixxillee zayitiin irra dibame akkasumas kennaa midhaanii fi dhibaayyuu isaanii haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","“ ‘Lubichis fuula Waaqayyoo duratti isaan fidee aarsaa cubbuutii fi aarsaa gubamu haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","Innis korbeessa hoolaa sana Maxinoo gundoo irra jiru sana wajjin aarsaa nagaa godhee Waaqayyoof haa dhiʼeessu; akkasumas lubichi kennaa midhaaniitii fi dhibaayyuu isaa haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","“ ‘Ergasii Naazirichi balbala dunkaana wal gaʼii duratti rifeensa addaan baase sana haa haaddatu. Rifeensa sanas fuudhee ibidda aarsaa nagaa jalaan jiru sana keessa haa buusu. ");
INSERT INTO gaz_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","“ ‘Erga Naazirichi rifeensa ittiin addaan baafame sana haaddatee booddee lubni sun foon gatiittii korbeessa hoolaa kan affeelamee fi Maxinoo fi bixxillee hin bukaaʼin gundoo sana irraa fuudhee harka namichaa irra haa kaaʼu. ");
INSERT INTO gaz_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Ergasiis lubichi aarsaa sochoofamu godhee fuula Waaqayyoo duratti isaan haa sochoosu; isaanis handaraafa sochoofamee fi tafa dhiʼeeffame sana wajjin lubichaaf kan qulqulleeffamanii dha. Ergasii Naazirichi daadhii wayinii dhuguu ni dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","“ ‘Seerri Naaziricha waan kennuu dandaʼu kaan dabalatee akkuma addaan baʼumsa isaatti kennaa isaa Waaqayyoof wareegu tokkoo kanaa dha. Innis akkuma seera Naazirichaatti waan wareege sana raawwachuu qaba.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","“Aroonii fi ilmaan isaatti akkana jedhii himi; ‘Akki isin itti Israaʼeloota eebbiftan kanaa dha. Akkana jedhaanii: ");
INSERT INTO gaz_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","“ ‘ “Waaqayyo si haa eebbisu; si haa eegus; ");
INSERT INTO gaz_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","Waaqayyo fuula isaa siif haa ibsu; garaa siif haa laafu. ");
INSERT INTO gaz_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","Waaqayyo fuula isaa gara keetti haa deebisu; nagaas siif haa kennu.” ’ ");
INSERT INTO gaz_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","“Akkasitti isaan maqaa koo saba Israaʼel irra kaaʼu; anis isaan nan eebbisa.” ");
INSERT INTO gaz_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Museen erga dunkaana qulqulluu sana dhaabee fixatee booddee, dunkaanichaa fi miʼa isaa hunda dibe; ni qulqulleesses. Akkasumas iddoo aarsaatii fi miʼa isaa hunda dibee qulqulleesse. ");
INSERT INTO gaz_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Ergasii hooggantoonni Israaʼel, hangafoonni maatiiwwanii kanneen hooggantoota gosootaa taʼanii warra lakkaaʼaman sana qajeelchanis kennaa dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Isaanis gaariiwwan haguugaman jaʼaa fi sangoota kudha lama jechuunis tokkoo tokkoo hooggantootaa irraa sangaa tokko, lama lama taʼanii immoo gaarii tokko kennaa ofii godhanii fuula Waaqayyoo duratti fidan. Kennaawwan kanneenis dunkaana qulqulluu sana duratti dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","“Akka isaan hojii dunkaana wal gaʼii hojjechuu keessatti fayyadaniif kennaawwan kanneen isaan harkaa fuudhi. Waan kana akkuma hojiin tokkoo tokkoo namaa barbaaddutti Lewwotatti kenni.” ");
INSERT INTO gaz_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Museenis gaariiwwanii fi sangoota sana fuudhee Lewwotatti kenne. ");
INSERT INTO gaz_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Innis akkuma hojii isaaniitiif malutti gaariiwwan lamaa fi sangoota afur ilmaan Geershoonitti kenne; ");
INSERT INTO gaz_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","gaariiwwan afurii fi sangoota saddeet akkuma hojii isaaniitiif malutti ilmaan Meraaritti kenne. Isaan hundinuu qajeelfama Iitaamaar ilma Aroon lubichaa jala turan. ");
INSERT INTO gaz_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Ilmaan Qohaati garuu sababii miʼa qulqulluu gatiittiitti baachuun hojii isaanii taʼeef Museen homaa isaaniitti hin kennine. ");
INSERT INTO gaz_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Yeroo iddoon aarsaa dibametti hooggantoonni kennaawwan isaanii eebba iddoo aarsaatiif fidanii iddoo aarsaa duratti dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Waaqayyo Museedhaan, “Dura buʼaan tokko guyyuma tokko kennaa isaa sirna eebba iddoo aarsaa sanaatiif haa dhiʼeessu” jedhee tureetii. ");
INSERT INTO gaz_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Namni guyyaa jalqabaatti kennaa ofii fide Nahishoon ilma Amiinaadaab kan gosa Yihuudaa ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokkoo fi waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu kan tokkoon tokkoon isaanii akka kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","cilfaa warqee kan saqilii kudhan ulfaatee ixaanaan guutame tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokkoo fi xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokko taʼe ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Guyyaa lammaffaattis Naatnaaʼel ilma Zuuwaar dura buʼaa Yisaakoritu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Kennaan inni fides gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kan tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","caabii warqee kan saqilii kudhan ulfaatee ixaanaan guutame tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokkoo fi xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Guyyaa sadaffaatti Eliiyaab ilma Heeloon hangafa ijoollee Zebuuloonitu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korommii reʼee shanii fi xobbaallaa korbeeyyii hoolaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Guyyaa afuraffaatti Eliizuur ilma Shedeeʼuur dura buʼaa ijoollee Ruubeenitu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kan tokkoo tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi xobbaallaa korbeeyyii hoolaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Guyyaa shanaffaatti Shilumiiʼeel ilma Zuriishadaayi hoogganaa ijoollee Simiʼoonitu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko, kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokko ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Guyyaa jaʼaffaatti Eliyaasaaf ilma Deʼuuʼeel dura buʼaa ijoollee Gaaditu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kana akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korommii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Guyyaa torbaffaatti Eliishaamaa ilma Amiihuud dura buʼaa ijoollee Efreemitu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokko ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Guyyaa saddeettaffaatti Gamaaliʼeel ilma Phedaasuur hoogganaa ijoollee Minaaseetu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame, ");
INSERT INTO gaz_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe, ");
INSERT INTO gaz_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korommii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Guyyaa saglaffaatti Abiidaan ilma Gaadeyoon dura buʼaa ijoollee Beniyaamitu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame, ");
INSERT INTO gaz_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Guyyaa kudhannaffaatti Ahiiʼezer ilma Amiishadaay dura buʼaa ijoollee Daanitu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame, ");
INSERT INTO gaz_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi korbeeyyii hoolaa xixinnaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Guyyaa kudha tokkoffaatti Fagiʼeel ilma Okraan hoogganaa ijoollee Aasheeritu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daaku bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame, ");
INSERT INTO gaz_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Guyyaa kudha lammaffaatti Ahiiraa ilma Eenaan hoogganaa ijoollee Niftaalemitu kennaa isaa fide. ");
INSERT INTO gaz_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Kennaan isaas gabatee meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii dhibba tokkoo fi soddoma ulfaatu tokko, waciitii meetii kan akka madaalii saqilii iddoo qulqulluutti saqilii torbaatama ulfaatu tokko kanneen tokkoon tokkoon isaanii akkuma kennaa midhaaniitti daakuu bullaaʼaa zayitiidhaan sukkuumameen guutaman, ");
INSERT INTO gaz_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","xuwwee warqee kan saqilii kudhan ulfaatee ixaanaan guutame tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","aarsaa gubamuufis dibicha loonii tokko, korbeessa hoolaa tokko, xobbaallaa hoolaa kan umuriin isaa waggaa tokko taʼe tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","aarsaa cubbuutiif immoo korbeessa reʼee tokko, ");
INSERT INTO gaz_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","aarsaa nagaatiif qaluufis sangoota lama, korbeeyyii hoolaa shan, korbeeyyii reʼee shanii fi xobbaallaawwan hoolaa shan kanneen umuriin isaanii waggaa tokko tokkoo ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Kennaan hooggantoonni Israaʼel gaafa iddoon aarsaa dibame sana sirna eebbaatiif dhiʼeessan kana ture; isaanis gabatee meetii kudha lama, waciitii meetii kudha lamaa fi xuwwee warqee kudha lama: ");
INSERT INTO gaz_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","Tokkoon tokkoon isaanii meetii saqilii dhibba tokkoo fi soddoma ulfaatu ture; tokkoon tokkoon waciitii meetii saqilii torbaatama ulfaata ture. Miʼi meetii kun akka madaalii saqilii iddoo qulqulluutti walumaa galatti saqilii kuma lamaa fi dhibbaa afur ulfaata ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Xuwweewwan warqee kudha lamaan kanneen ixaanaan guutamanis tokkoon tokkoon isaanii akka madaalii saqilii iddoo qulqulluutti saqilii kudhan ulfaatu turan. Xuwweewwan warqee walumaa galatti saqilii dhibba tokkoo fi digdama ulfaatu turan. ");
INSERT INTO gaz_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Baayʼinni horii aarsaa gubamuuf dhiʼeeffamanii walumaa galatti jiboota loonii kudha lama, korbeeyyii hoolaa kudha lama, xobbaallaawwan hoolaa kanneen umuriin isaanii waggaa tokko taʼe kudha lama ture; kennaan midhaaniis isaan wajjin dhiʼeeffameera. Korbeeyyiin reʼee kudha lama aarsaa cubbuutiif dhiʼeeffamanii turan. ");
INSERT INTO gaz_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Baayʼinni horii aarsaa nagaatiif dhiʼeeffamanii walumaa galatti sangoota digdamii afur, korbeeyyii hoolaa jaatama, korbeeyyii reʼee jaatamaa fi xobbaallaawwan hoolaa kanneen umuriin isaanii waggaa tokko ture. ");
INSERT INTO gaz_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Museen yommuu Waaqayyo wajjin dubbachuuf dunkaana wal gaʼii ol seenetti teessoo araaraa kan taabota kakuu seeraa irra jiruun olitti kiirubeelii lamaan gidduudhaa sagalee isatti dubbatu dhagaʼe. Waaqayyo isa wajjin dubbate. ");
INSERT INTO gaz_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","“Aroonitti akkana jedhii dubbadhu; ‘Yeroo ati ibsaawwan torban qabsiiftutti isaan iddoo baattuu ibsaa fuula dura jiru haa ibsan.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aroonis akkasuma godhe; innis akkuma Waaqayyo Musee ajajetti akka isaan fuula baattuu ibsaa duraan ifa kennaniif ibsaawwan sana qabsiise. ");
INSERT INTO gaz_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Akki itti baattuun ibsaa tolfame akkana: Miilla isaa irraa jalqabee hamma daraaraa isaatti warqee tumame irraa hojjetame. Baattuun ibsaa sun akkuma fakkeenya Waaqayyo Museetti argisiise sanaatti hojjetame. ");
INSERT INTO gaz_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Waaqayyo Museedhaan akkana jedhe: ");
INSERT INTO gaz_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","“Saba Israaʼel keessaa Lewwota fuudhii qulqulleessi. ");
INSERT INTO gaz_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Isaan qulqulleessuufis waan kana godhi: bishaan qulqullaaʼummaa isaanitti facaasi; akka isaan dhagna isaanii guutuu haaddatanii akkasiin uffata ofii miiccatanii of qulqulleessan godhi. ");
INSERT INTO gaz_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Isaanis dibicha loonii tokko kennaa midhaanii kan daakuu bullaaʼaa zayitiidhaan sukkuumame wajjin haa fuudhan; atis dibicha loonii lammaffaa aarsaa cubbuutiif fuudhi. ");
INSERT INTO gaz_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Lewwota fuula dunkaana wal gaʼii duratti dhiʼeessiitii waldaa Israaʼelootaa guutuu walitti qabi. ");
INSERT INTO gaz_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Lewwotas fuula Waaqayyoo duratti dhiʼeessi; sabni Israaʼel harka isaanii Lewwota irra haa kaaʼan. ");
INSERT INTO gaz_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Aroonis akka Lewwonni Waaqayyo tajaajiluu dandaʼaniif saba Israaʼel keessaa aarsaa sochoofamu godhee fuula Waaqayyoo duratti isaan haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","“Erga Lewwonni harka isaanii mataa jiboota sanaa irra kaaʼanii booddee ati Lewwotaaf araaraa buusuudhaaf dibicha tokko aarsaa cubbuu, kaan immoo aarsaa gubamu godhiitii Waaqayyoof dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","Akka Lewwonni fuula Aroonii fi fuula ilmaan isaa dura dhaabatan godhi; ergasiis aarsaa sochoofamu godhiitii Waaqayyotti isaan dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Haala kanaan Israaʼeloota kaan keessaa Lewwota addaan baasi; Lewwonnis kan koo haa taʼan. ");
INSERT INTO gaz_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","“Erga ati Lewwota qulqulleessitee aarsaa sochoofamu gootee isaan dhiʼeessitee booddees isaan hojii dunkaana wal gaʼii hojjechuuf haa dhufan. ");
INSERT INTO gaz_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Isaan Israaʼeloota keessaa guutumaan guutuutti naaf kennamuu qabu. Ani qooda hangafa saba Israaʼel kan gadameessa saaqu hundaa Lewwota ofii kootiif fudhadheera. ");
INSERT INTO gaz_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Israaʼel keessaa dhiirri hangafni hundi namas taʼu horiin kan koo ti. Ani yeroon biyya Gibxi keessatti hangafa hunda ajjeese sana ofii kootiifan addaan isaan baafadhe. ");
INSERT INTO gaz_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ani qooda ilmaan Israaʼel hangafoota hundaa Lewwota fudhadheera. ");
INSERT INTO gaz_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Yommuu Israaʼeloonni iddoo qulqulluutti dhiʼaatanitti akka dhaʼichi isaan hin arganneef, akka isaan Israaʼelootaaf araara buusanii fi akka isaan tajaajila Israaʼelootaa dunkaana wal gaʼii keessatti raawwataniif ani Lewwota saba Israaʼel hunda keessaa Aroonii fi ilmaan isaatiif kennaa godhee kenneera.” ");
INSERT INTO gaz_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Museen, Aroonii fi waldaan Israaʼel guutuun akkuma Waaqayyo Musee ajaje sana Lewwotas godhan. ");
INSERT INTO gaz_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lewwonnis of qulqulleessanii wayyaa ofii miiccatan. Aroonis akkuma aarsaa sochoofamuutti fuula Waaqayyoo duratti isaan dhiʼeesse; isaan qulqulleessuufis araara isaaniif buuse. ");
INSERT INTO gaz_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Ergasii Lewwonni qajeelcha Aroonii fi ilmaan isaatiin hojii dunkaana wal gaʼii hojjechuudhaaf dhufan. Isaanis akkuma Waaqayyo Musee ajaje sana Lewwotas godhan. ");
INSERT INTO gaz_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","“Kun seera Lewwotaaf kennamee dha: Dhiironni umuriin isaanii waggaa digdamii shanii fi hammasii olii hojii dunkaana wal gaʼii keessatti hirmaachuuf haa dhufan; ");
INSERT INTO gaz_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","umurii waggaa shantamaatti garuu tajaajila isaanii haa dhaaban; deebiʼaniis hin tajaajilin. ");
INSERT INTO gaz_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Hojii dunkaana wal gaʼii irratti obboloota ofii gargaaruu ni dandaʼu; ofii isaaniitii garuu hojii sana hin hojjetin. Egaa kun haala itti ati itti gaafatama Lewwotaa ramadduu dha.” ");
INSERT INTO gaz_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Waaqayyo erga isaan Gibxii baʼanii booddee jiʼa jalqabaa kan waggaa lammaffaatti Gammoojjii Siinaa keessatti akkana jedhee Museetti dubbate; ");
INSERT INTO gaz_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","“Israaʼeloonni yeroo murtaaʼetti Faasiikaa haa ayyaaneffatan. ");
INSERT INTO gaz_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Isin akkuma seeraa fi dambii ayyaana kanaa hundaatti yeroo murtaaʼetti jiʼa sana keessa, dimimmisa galgala guyyaa kudha afuraffaatti ayyaaneffadhaa.” ");
INSERT INTO gaz_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Museen akka isaan Faasiikaa ayyaaneffatan Israaʼelootatti hime; ");
INSERT INTO gaz_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","isaanis jiʼa jalqabaa keessa dimimmisa galgala guyyaa kudha afuraffaatti Gammoojjii Siinaa keessatti ayyaaneffatan. Sabni Israaʼel akkuma Waaqayyo Musee ajajetti waan hunda godhe. ");
INSERT INTO gaz_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Isaan keessaa namoonni tokko tokko sababii reeffa tuqanii xuraaʼaniif guyyaa sana Faasiikaa ayyaaneffachuu hin dandeenye. Isaan guyyuma sana gara Musee fi Aroonii dhufanii, ");
INSERT INTO gaz_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","Museedhaan akkana jedhan; “Nu sababii reeffa namaa tuqneef xuroofneerra; garuu maaliif yeroo murtaaʼe sanatti Israaʼeloota kaan wajjin aarsaa Waaqayyoo dhiʼeessuu dhowwamne?” ");
INSERT INTO gaz_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Museenis, “Hamma ani waan Waaqayyo waaʼee keessan ajaju dhagaʼutti turaa” jedheen. ");
INSERT INTO gaz_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Waaqayyos Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","“Israaʼelootaan akkana jedhi: ‘Isin keessaa yookaan ilmaan keessan keessaa namni tokko yoo reeffa tuqee xuraaʼe yookaan karaa fagoo deeme, inni amma iyyuu Faasiikaa Waaqayyoo ayyaaneffachuu ni dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Isaanis jiʼa lammaffaa keessa guyyaa kudha afuraffaa dimimmisa galgala Faasiikaa haa ayyaaneffatan. Faasiikaa sanas Maxinoo fi baala hadhaaʼaa wajjin haa nyaatan. ");
INSERT INTO gaz_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Isaanis wantoota kanneen keessaa tokko iyyuu hamma ganamaatti hambisuu yookaan lafee isaa keessaa tokko iyyuu cabsuu hin qaban. Isaan yommuu Faasiikaa ayyaaneffatanitti dambiiwwan hunda duukaa buʼuu qabu. ");
INSERT INTO gaz_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Garuu namni qulqulluu taʼee karaa hin deemin yoo Faasiikaa ayyaaneffachuu baate inni sababii yeroo murtaaʼetti aarsaa Waaqayyoo hin dhiʼeessiniif saba isaa keessaa haa balleeffamu. Namichi sun gatii cubbuu isaa ni argata. ");
INSERT INTO gaz_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","“ ‘Alagaan isin gidduu jiraatu kan Faasiikaa Waaqayyoo ayyaaneffachuu fedhu tokko akkuma seeraa fi dambii Faasiikaatti haa ayyaaneffatu. Isinis alagaa fi dhalataa biyyaatiif seeruma tokkicha qabaadhaa.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Gaafa dunkaanni qulqulluun dhaabame sana duumessi dunkaana sana jechuunis dunkaana dhuga baʼumsaa haguuge. Duumessi dunkaana qulqulluudhaan olii sunis galgalaa hamma ganamaatti ibidda fakkaata ture. ");
INSERT INTO gaz_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Wanni kunis yeroo hunda akkanuma ture; guyyaa duumessi isa haguuga ture; halkan immoo duumessi sun ibidda fakkaata ture. ");
INSERT INTO gaz_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Yeroo duumessi sun dunkaana irraa kaʼu Israaʼeloonni kaʼanii deemu turan; lafa duumessi buʼu immoo Israaʼeloonni ni qubatu. ");
INSERT INTO gaz_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israaʼeloonni ajaja Waaqayyootiin kaʼanii deemu; ajajuma isaatiinis qubatu. Yeroo duumessi dunkaana qulqulluun ol jiru isaanis qubata keessa turan. ");
INSERT INTO gaz_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Yoo duumessi sun guyyaa hedduu dunkaana gubbaa tures Israaʼeloonni seera Waaqayyootiif waan ajajamaniif iddoo sanaa kaʼanii hin deeman ture. ");
INSERT INTO gaz_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Yeroo tokko tokko duumessi sun guyyaa xinnaadhaaf dunkaana qulqulluu gubbaa oolee bula ture; isaanis ajaja Waaqayyootiin qubatu; ajajuma isaatiinis kaʼanii deemu. ");
INSERT INTO gaz_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Yeroo tokko tokko duumessi sun galgalaa hamma ganamaatti jiraata ture; yommuu duumessi ganamaan kaʼu isaanis kaʼanii deemu. Guyyaas taʼu halkan, yeroo duumessi kaʼu isaanis kaʼanii deemu. ");
INSERT INTO gaz_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Yeroo duumessi sun guyyaa lamas taʼu jiʼa tokko yookaan waggaa tokko dunkaana qulqulluu irra turutti Israaʼeloonni qubatuma keessa turu malee kaʼanii hin deeman ture; yeroo duumessichi kaʼutti garuu kaʼanii deemu. ");
INSERT INTO gaz_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Isaan ajaja Waaqayyootiin qubatu; ajajuma Waaqayyootiinis kaʼanii deemu. Akkuma ajaja Waaqayyo karaa Museetiin kenne sanaattis seera isaatiif ajajamu. ");
INSERT INTO gaz_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Waaqayyo Museedhaan akkana jedhe: ");
INSERT INTO gaz_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","“Meetii tumame irraa malakata lama tolfadhuutii hawaasa walitti waamuu fi akka qubanni kaʼee deemu gochuuf itti fayyadami. ");
INSERT INTO gaz_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Yeroo malakanni lamaan afuufamanitti hawaasni hundi balbala dunkaana wal gaʼiitti fuula kee duratti walitti haa qabamu. ");
INSERT INTO gaz_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Yoo malakanni tokko qofti afuufame garuu hooggantoonni jechuunis abbootiin gosoota Israaʼel fuula kee duratti walitti haa qabaman. ");
INSERT INTO gaz_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Yeroo malakanni afuufamutti gosoonni gama baʼa biiftuutiin qubatan kaʼanii haa deeman. ");
INSERT INTO gaz_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Yeroo malakanni siʼa lammaffaa afuufamutti immoo gosoonni gama kibbaatiin qubatan kaʼanii haa deeman. Malakanni afuufamu sun mallattoo isaan ittiin qubata keessaa baʼanii dha. ");
INSERT INTO gaz_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Hawaasa walitti qabuudhaaf malakata afuufi; garuu mallattoo wal fakkaatuun hin afuufin. ");
INSERT INTO gaz_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","“Ilmaan Aroon luboonni malakatawwan sana haa afuufan. Kunis isinii fi dhaloota dhufuuf seera bara baraa haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Isin yommuu biyya keessan keessatti diina isin cunqursu tokkotti duuluuf baatanitti malakatawwan sana afuufaa. Yoos Waaqayyo Waaqni keessan isin yaadatee diina keessan jalaa isin baasa. ");
INSERT INTO gaz_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Akkasumas guyyaa gammachuu keessanii jechuunis gaafa ayyaana beekamaa fi Ayyaana Baatii Haaraatti aarsaa keessan kan gubamuu fi aarsaa keessan kan nagaa irratti malakatawwan afuufaa; wanni kunis fuula Waaqa keessanii duratti yaadannoo isiniif taʼa. Ani Waaqayyo Waaqa keessan.” ");
INSERT INTO gaz_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Jiʼa lammaffaa waggaa lammaffaa keessa guyyaa digdammaffaatti duumessi sun dunkaana dhuga Baʼumsaa irraa kaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Israaʼeloonnis Gammoojjii Siinaatii kaʼanii hamma duumessi sun Gammoojjii Phaaraanii keessa qubatutti iddoo tokko irraa gara iddoo biraatti deeman. ");
INSERT INTO gaz_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Isaan yeroo jalqabaa kanatti ajaja Waaqayyo karaa Museetiin kenneen kaʼanii deeman. ");
INSERT INTO gaz_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Kutaan qubata ijoollee Yihuudaa faajjii isaanii jalaan jalqabatti deeman. Nahishoon ilmi Amiinaadaab ajajaa isaanii ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Naatnaaʼel ilmi Zuuwaar ajajaa kutaa gosa Yisaakor ture; ");
INSERT INTO gaz_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","Eliiyaab ilmi Heeloon ajajaa kutaa gosa Zebuuloon ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Dunkaanni qulqulluun sunis achii buqqifame; akkasiin Geershoononnii fi Meraaronni warri dunkaana baatan kaʼanii deeman. ");
INSERT INTO gaz_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Kutaan qubata Ruubeenis faajjii isaanii jalaan itti aananii deeman. Eliizuur ilmi Shedeeʼuur ajajaa isaanii ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Shilumiiʼeel ilmi Zuriishadaayi ajajaa kutaa gosa Simiʼoon ture; ");
INSERT INTO gaz_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Eliyaasaaf ilmi Deʼuuʼeel ajajaa kutaa gosa Gaad ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Ergasii Qohaatonni miʼa qulqulluu baatanii kaʼanii deeman. Dunkaanni qulqulluun sun immoo utuu isaan achi hin gaʼin dhaabamee ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Kutaan qubata Efreemis faajjii isaanii jalaan itti aananii deeman. Eliishaamaan ilmi Amiihuud ajajaa isaanii ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Gamaaliʼeel ilmi Phedaasuur ajajaa kutaa gosa Minaasee ture; ");
INSERT INTO gaz_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","Abiidaan ilmi Gaadeyoon ajajaa kutaa gosa Beniyaam ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Dhuma irratti kutaan qubata Daan eegduu karaa duubaa kan kutaawwan hundaa taʼanii faajjii isaanii jalaan kaʼanii deeman. Ahiiʼezer ilmi Amiishadaay ajajaa isaanii ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Fagiʼeel ilmi Okraan ajajaa kutaa gosa Aasheer ture; ");
INSERT INTO gaz_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","Ahiiraan ilmi Eenaan ajajaa kutaa gosa Niftaalem ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Egaa kutaawwan saba Israaʼel yommuu kaʼanii deemanitti tartiiba kanaan sochoʼan. ");
INSERT INTO gaz_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Ergasii Museen Hoobaab ilma Reʼuuʼeel, namicha Midiyaan abbaa niitii Musee sanaan akkana jedhe; “Nu biyya Waaqayyo, ‘Ani isinii kenna’ nuun jedhe sana dhaquuf deemaa jirra. Nu waan gaarii siif goonaatii kottuu nu wajjin deemi; Waaqayyo waan gaarii Israaʼelootaaf kakateeraatii.” ");
INSERT INTO gaz_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Inni immoo, “Lakki ani hin deemuu; ani biyyuma kootti gara saba kootti nan deebiʼa” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Museen garuu akkana jedheen; “Maaloo nu dhiistee hin deemin. Ati gammoojjii keessatti iddoo nu qubannu ni beekta; ijas nuu taʼuu dandeessa. ");
INSERT INTO gaz_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Yoo ati nu wajjin deemte nu waan gaarii Waaqayyo nuu kennu si wajjin qoodanna.” ");
INSERT INTO gaz_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Isaan tulluu Waaqayyoo irraa kaʼanii guyyaa sadii deeman. Taabonni kakuu Waaqayyoos iddoo isaan boqotan isaaniif barbaaduuf jedhee guyyaa sadanuu isaan dura deeme. ");
INSERT INTO gaz_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Duumessi Waaqayyoo sun yeroo isaan qubata keessaa baʼan guyyaa guyyaa isaan irra ture. ");
INSERT INTO gaz_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Yeroo taabonni sun kaʼee deemu Museen akkana jedha ture; “Yaa Waaqayyo, kaʼi! Diinonni kee haa bittinneeffaman; warri si jibbanis fuula kee duraa haa baqatan.” ");
INSERT INTO gaz_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Yeroo inni boqochuuf dhufu akkana jedha ture; “Yaa Waaqayyo, gara kumaatama Israaʼel hedduutti deebiʼi.” ");
INSERT INTO gaz_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Sabni sun utuma Waaqayyo isa dhagaʼuu waaʼee rakkina isaa guungume; innis yommuu waan kana dhagaʼetti ni aare. Kana irratti ibiddi Waaqayyoo isaan gidduutti bobaʼee qarqara qubata isaanii gube. ");
INSERT INTO gaz_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Sabni Museetti iyye; Museen immoo Waaqayyoon kadhatee ibiddi sun dhaame. ");
INSERT INTO gaz_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Sababii ibiddi Waaqayyo biraa gad buʼee gidduu isaaniitti bobaʼeef, iddoon sun “Tabeeraa” jedhamee waamame. ");
INSERT INTO gaz_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Sabni wal makaan isaan wajjin tures nyaata biraa dharraʼe; Israaʼeloonni ammas akkana jedhanii booʼuu jalqaban; “Nu utuu foon nyaannu argannee! ");
INSERT INTO gaz_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nu biyya Gibxi keessatti qurxummii toluma nyaanne; akkasumas dabaaqula, habaabii, goodarree, qullubbii diimaa fi qullubbii adii nyaanne sana ni yaadanna. ");
INSERT INTO gaz_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","Amma garuu fedhiin nyaataa nurraa badeera; mannaa kana malees waan tokko illee hin arginu!” ");
INSERT INTO gaz_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mannaan sun akka sanyii dinbilaalaa taʼee bifti isaa haphee fakkaata ture. ");
INSERT INTO gaz_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Namoonnis mannaa sana nanaannaʼanii walitti qabanii dhagaa daakuutti daakachaa yookaan mooyyeetti tumachaa turan. Isaanis mannaa sana okkoteetti affeelu yookaan maxinoo isaa tolfatu turan. Innis akka waan zayitii ejersaatiin qopheeffameetti miʼaawa ture. ");
INSERT INTO gaz_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Galgala yommuu fixeensi qubata irra buʼetti mannaan sunis gad buʼe. ");
INSERT INTO gaz_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Museen utuu namoonni maatii hundaa balbala dunkaana ofii isaa duratti booʼanuu dhagaʼe. Waaqayyos akka malee aare; Museen immoo ni dhiphate. ");
INSERT INTO gaz_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Innis akkana jedhee Waaqayyoon gaafate; “Ati maaliif dhiphina kana garbicha keetti fidde? Ati kan baʼaa saba kanaa hunda narra keesse ani maal balleessee si gaddisiiseeti? ");
INSERT INTO gaz_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Saba kana hunda anatu ulfaaʼee? Anatu isaan daʼee? Ati maaliif akka ani akkuma guddiftuun daaʼima baattutti gara biyya ati abbootii isaaniitiif kakuudhaan waadaa galteetti irree kootti baadhee isaan geessuudhaaf na ajajja? ");
INSERT INTO gaz_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Ani saba kana hundaaf foon eessaan argadha? Isaan, ‘Foon nyaannu nuu kenni!’ jedhanii natti booʼu. ");
INSERT INTO gaz_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Ani kophaa koo saba kana hunda baachuu hin dandaʼu; baʼaan kun akka malee natti ulfaata. ");
INSERT INTO gaz_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ati yoo akkana na goota taʼe, yoo ani fuula kee duratti fudhatama argadhee jiraadhe, maaloo ammuma na ajjeesi; akka ani gidiraa natti dhufu argus na hin godhin.” ");
INSERT INTO gaz_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Waaqayyos Museedhaan akkana jedhe; “Maanguddoota Israaʼel keessaa nama torbaatama kanneen hooggantootaa fi qondaaltota sabaa taʼuu isaanii beektu naa fidi. Akka isaan gara dunkaana wal gaʼii dhufanii si wajjin achi dhadhaabatan godhi. ");
INSERT INTO gaz_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ani gad buʼee achitti si wajjin nan dubbadha; Hafuura sirra jiru irraas fuudhee isaan irra nan kaaʼa; isaanis akka ati kophaa kee baʼaa sana hin baanneef baʼaa saba sanaa si wajjin baatu. ");
INSERT INTO gaz_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","“Saba kanaan akkana jedhi: ‘Isin bori foon nyaattuutii of qulqulleessaa qophaaʼaa. Waaqayyo yeroo isin, “Nu utuu foonuma nyaannu argannee! Yeroo nu biyya Gibxi keessa jirru nuu wayya ture!” jettanii boossan dhagaʼeeraatii. Waaqayyo amma foon isinii kenna; isinis ni nyaattu. ");
INSERT INTO gaz_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Isin hamma guyyaa tokkoo, yookaan lamaa, yookaan shanii, kudhanii, yookaan digdamaa qofa hin nyaattan; ");
INSERT INTO gaz_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","garuu jiʼa tokko guutuu hamma funyaaniin isin baʼutti, hamma nuffitanittis nyaattu; isin Waaqayyo gidduu keessan jiru sana diddanii, “Nu maaliif biyya Gibxi keessaa baane?” jettanii fuula isaa duratti boossanii turtaniitii.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Museen garuu akkana jedhe; “Kunoo ani namoota lafoo kuma dhibba jaʼa gidduun jira; ati immoo, ‘Ani foon isaan jiʼa guutuu nyaatan kennaaf!’ jetta. ");
INSERT INTO gaz_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Utuma bushaayee fi karri loonii isaaniif qalamanii iyyuu gaʼaa laata? Utuma qurxummiin galaana keessaa hundi isaanii qabamee iyyuu gaʼaa laata?” ");
INSERT INTO gaz_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Waaqayyo Museedhaan akkana jedhe; “Harki Waaqayyoo gabaabaadhaa? Ati akka wanni ani siin jedhu siif guutamuu fi akka siif hin guutamne amma ni argita.” ");
INSERT INTO gaz_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Museen dhaqee waan Waaqayyo jedhe sana sabatti hime. Innis saba sana keessaa maanguddoota torbaatama walitti qabee akka isaan naannoo dunkaanaa dhadhaabatan godhe. ");
INSERT INTO gaz_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Ergasiis Waaqayyo duumessaan gad buʼee isatti dubbate; Hafuura isa irra jirus fuudhee maanguddoota torbaatamman sana irra buuse. Isaanis yeroo Hafuurri sun isaan irra boqotetti raajii dubbatan; ergasii immoo deebiʼanii raajii sana hin dubbanne. ");
INSERT INTO gaz_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Taʼu illee namoonni lama kanneen maqaan isaanii Eldaadii fi Meedaad jedhaman qubata keessatti hafanii turan. Isaanis maanguddoota sana keessatti galmeeffamanii turan malee gad baʼanii gara dunkaanaa hin dhaqne ture. Hafuurri immoo isaan irra illee buʼe; isaanis qubata keessatti raajii dubbatan. ");
INSERT INTO gaz_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Dargaggeessi tokko fiigee dhaqee, “Eldaadii fi Meedaad raajii dubbachuutti jiru” jedhee Museetti hime. ");
INSERT INTO gaz_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Iyyaasuun ilmi Nuuni kan ijoollummaa ofiitii jalqabee gargaartuu Musee ture sun kaʼee, “Yaa Musee, yaa gooftaa ko, isaan dhowwi!” jedhee dubbate. ");
INSERT INTO gaz_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Museen garuu akkana jedhee deebise; “Ati anaaf hinaaftaa? Ani utuu sabni Waaqayyoo hundinuu raajota taʼanii Waaqayyos Hafuura isaa isaan irra kaaʼee nan hawwa!” ");
INSERT INTO gaz_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Ergasiis Musee fi maanguddoonni Israaʼel gara qubataatti deebiʼan. ");
INSERT INTO gaz_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Bubbeen tokkos Waaqayyo biraa baʼee galaana keessaa dimbiriqqee gara qubataatti oofe. Bubbeen sunis dimbiriqqee sana naannoo qubata sanaatti gama hundaan hamma deemsa guyyaa tokkoo fagaatu harcaasee hamma dhundhuma lamaa oli tuule. ");
INSERT INTO gaz_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Guyyaa sana guutuu fi halkan sana guutuu, guyyaa itti aanu guutuus sabni sun gad baʼee dimbiriqqee sana walitti qabate; isaan keessaas namni homeerii kudhanii gad walitti qabate hin turre. Ergasii dimbiriqqee sana naannoo qubata sanaa afatan. ");
INSERT INTO gaz_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Garuu utuma foon sun amma illee gidduu ilkaan isaanii jiruu, utuu hin alanfatin Waaqayyo isaanitti aaree dhaʼicha hamaadhaan isaan dhaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Sababii isaan namoota nyaata biraa dharraʼan achitti awwaalaniif maqaan iddoo sanaa, “Qiibrooti Haataaʼabaa” jedhame. ");
INSERT INTO gaz_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Sabni sunis Qiibrooti Haataaʼabaadhaa kaʼee gara Haxerooti dhaqee achi jiraate. ");
INSERT INTO gaz_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Miiriyaamii fi Aroon sababii Museen dubartii Itoophiyaa fuudheef isaan mormuudhaan dubbachuu jalqaban; inni dubartii Itoophiyaa fuudhee tureetii. ");
INSERT INTO gaz_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","Isaanis, “Waaqayyo karaa Musee qofaan dubbatee? Inni karaa keenyaanis dubbatee ture mitii?” jedhan. Waaqayyos dubbii kana dhagaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Museen namoota lafa irra jiraatan hunda caalaa nama akka malee gad of qabu ture. ");
INSERT INTO gaz_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Waaqayyos yommusuma Museen, Aroonii fi Miiriyaamiin, “Isin sadanuu gara dunkaana wal gaʼiitti gad baʼaa” jedhe. Isaan sadanuus gad baʼan. ");
INSERT INTO gaz_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Ergasii Waaqayyo utubaa duumessaa keessaan gad buʼee balbala dunkaanaa irra dhaabatee Aroonii fi Miiriyaamin waame. Jarri lachuu isatti dhiʼaannaan, ");
INSERT INTO gaz_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","inni akkana jedheen; “Dubbii koo dhagaʼaa: “Yoo raajiin Waaqayyoo gidduu keessan jiraate, ani mulʼata keessa isatti of nan mulʼisa; abjuudhaanis isatti nan dubbadha. ");
INSERT INTO gaz_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Garuu garbichi koo Museen akkana miti; inni mana koo hunda keessatti amanamaa dha. ");
INSERT INTO gaz_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ani utuu dhoksaadhaan hin taʼin, ifaan ifatti isatti nan dubbadha; inni bifa Waaqayyoo ni arga. Yoos isin maaliif garbicha koo Museedhaan mormuudhaan dubbachuu hin sodaanne ree?” ");
INSERT INTO gaz_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Aariin Waaqayyos isaan irratti bobaʼe; innis isaan dhiisee deeme. ");
INSERT INTO gaz_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Yommuu duumessi sun dunkaana gubbaadhaa ol kaʼetti kunoo, Miiriyaam lamxooftee akkuma cabbii addaattee turte. Aroonis gara isheetti garagalee akka isheen lamxii qabdu arge; ");
INSERT INTO gaz_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","innis Museedhaan akkana jedhe; “Maaloo yaa gooftaa ko, cubbuu nu gowwummaadhaan hojjenne sana nutti hin lakkaaʼin. ");
INSERT INTO gaz_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Akka gatata foon isaa gariin nyaatamee gadameessa haadha isaa keessaa baʼu tokkoo ishee hin godhin.” ");
INSERT INTO gaz_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Museen Waaqayyotti booʼee, “Yaa Waaqayyo, maaloo ishee fayyisi!” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Waaqayyo akkana jedhee Museedhaaf deebii kenne; “Utuu abbaan ishee fuula isheetti tufee silaa isheen bultii torba salphina keessa turti mitii ree? Isheen bultii torba qubataan ala haa turtu; ergasii deebitee dhufuu dandeessi.” ");
INSERT INTO gaz_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Miiriyaam bultii torba qubataan ala turte; sabni sunis hamma isheen deebitutti deemsa itti hin fufne. ");
INSERT INTO gaz_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Ergasii sabni sun Haxerootii kaʼee Gammoojjii Phaaraan keessa qubate. ");
INSERT INTO gaz_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","“Akka isaan dhaqanii biyya Kanaʼaan ishee ani Israaʼelootaaf kennuuf jiru sana basaasaniif namoota ergi. Tokkoo tokkoo abbootii gosaa keessaa hoogganaa tokko ergi.” ");
INSERT INTO gaz_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Museen ajaja Waaqayyootiin Gammoojjii Phaaraan keessaa isaan erge. Hundi isaanii hooggantoota Israaʼelootaa turan. ");
INSERT INTO gaz_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Maqaan isaanii kanneenii dha: Gosa Ruubeen keessaa Shamuuʼaa ilma Zakuur; ");
INSERT INTO gaz_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","gosa Simiʼoon keessaa Shaafaaxi ilma Hoorii; ");
INSERT INTO gaz_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","gosa Yihuudaa keessaa Kaaleb ilma Yefunee; ");
INSERT INTO gaz_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","gosa Yisaakor keessaa Yigiʼaal ilma Yoosef; ");
INSERT INTO gaz_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","gosa Efreem keessaa Hoosheeʼaa ilma Nuuni; ");
INSERT INTO gaz_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","gosa Beniyaam keessaa Phaaltii ilma Raaphuu; ");
INSERT INTO gaz_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","gosa Zebuuloon keessaa Gadiiʼeel ilma Soodii; ");
INSERT INTO gaz_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","gosa Minaasee jechuunis gosa Yoosef keessaa Gadii ilma Suus; ");
INSERT INTO gaz_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","gosa Daan keessaa Amiiʼeel ilma Gemaal; ");
INSERT INTO gaz_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","gosa Aasheer keessaa Sexuur ilma Miikaaʼel; ");
INSERT INTO gaz_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","gosa Niftaalem keessaa Naahibii ilma Wofsii; ");
INSERT INTO gaz_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","gosa Gaad keessaa Geʼuuʼeel ilma Maakii ti. ");
INSERT INTO gaz_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Egaa maqaawwan kunneen maqaawwan namoota akka isaan biyya sana basaasaniif jedhee Museen ergee dha. Museenis Hoosheeʼaa ilma Nuuni sana, “Iyyaasuu” jedhee moggaase. ");
INSERT INTO gaz_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Museen yommuu akka isaan biyya Kanaʼaanii basaasaniif isaan ergetti akkana jedheen; “Karaa Negeeb darbaatii gara biyya gaaraatti ol baʼaa. ");
INSERT INTO gaz_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","Biyyi sun maal akka fakkaattu, namoonni achi jiraatanis jajjaboo yookaan dadhaboo, muraasa yookaan hedduu taʼuu isaanii ilaalaa. ");
INSERT INTO gaz_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","Isaan biyya akkamii keessa jiraatu? Gaarii yookaan gadhee? Magaalaawwan akkamii keessa jiraatu? Dallaa dhagaa hin qaban moo daʼoo jabaa qabu? ");
INSERT INTO gaz_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","Lafti isaa gabbataa dha moo gabbataa miti? Muka qaba moo hin qabu. Jabaadhaatii ija biyyattii keessaa muraasa fidaa.” Waqtiin sun yeroo iji wayinii kan jalqabaa itti bilchaatu ture. ");
INSERT INTO gaz_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Isaan ol baʼanii Gammoojjii Siin irraa jalqabanii hamma Rehoobitti gara Leeboo Hamaatitti biyyattii basaasan. ");
INSERT INTO gaz_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Isaanis karaa Negeeb ol baʼanii gara Kebroon lafa Ahiiman, Sheeshaayii fi Talmaayi ilmaan Anaaq sun jiraataniitti dhufan. Kebroon kunis utuu Zooʼaan isheen biyya Gibxi sun hin ijaaramin waggaa torbaan dura ijaaramte. ");
INSERT INTO gaz_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Isaanis yommuu Sulula Eshkool gaʼanitti hurbuu ija wayinii tokko kutan. Wayinii sanas roomaanii fi harbuu wajjin nama lama taʼanii danqaraadhaan baatan. ");
INSERT INTO gaz_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Iddoon sun sababii hurbuu ija wayinii kan warri Israaʼel kutan sanaatiif Sulula Eshkool jedhame. ");
INSERT INTO gaz_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Jarris dhuma bultii afurtamaatti biyya sana basaasanii deebiʼan. ");
INSERT INTO gaz_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Isaanis gara Qaadesh ishee Gammoojjii Phaaraan keessaa gara Musee fi Aroon, gara waldaa Israaʼel guutuu deebiʼanii dhufan. Achittis gabaasa isaaniif dhiʼeessan; ija biyyattiis isaan argisiisan. ");
INSERT INTO gaz_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Isaanis akkana jedhanii Museetti himan: “Nu gara biyya ati itti nu ergite sanaa dhaqneerra; biyyattiin aannanii fi damma baafti! Iji ishees kunoo kana. ");
INSERT INTO gaz_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Garuu namoonni achi jiraatan jajjaboo dha; magaalaawwan ishee dallaa jabaa qabu; gurguddaa dhas. Nu sanyii Anaaq iyyuu achitti argineerra. ");
INSERT INTO gaz_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Amaaleqoonni Negeeb keessa jiraatu; Heetonni, Yebuusonnii fi Amooronni biyya gaaraa keessa jiraatu; Kanaʼaanonni immoo galaana biraa fi qarqara Yordaanos jiraatu.” ");
INSERT INTO gaz_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Kaalebis fuula Musee duratti saba calʼisiisee, “Nu dafnee ol baanee biyyattii haa dhaallu; moʼachuu ni dandeenyaatii” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Namoonni isa wajjin ol baʼanii turan garuu, “Nu warra sana dhaʼuu hin dandeenyu; isaan nurra jajjaboo dha” jedhan. ");
INSERT INTO gaz_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Isaanis waaʼee biyya basaasan sanaa saba Israaʼel gidduutti oduu gadhee tamsaasan. Akkanas jedhan; “Biyyi nu basaasne sun biyya warra ishee keessa jiraatu iyyuu nyaattuu dha. Namoonni nu achitti argine hundinuu dhedheeroo dha. ");
INSERT INTO gaz_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Achitti Nefiiliimota argine; ilmaan Anaaq Nefiiliimota irraa dhufan. Nu ofuma keenyatti iyyuu korophisa fakkaanne; fuula isaanii durattis akkasuma taane.” ");
INSERT INTO gaz_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Halkan sana namoonni waldaa sanaa hundinuu sagalee isaanii ol fudhatanii booʼan. ");
INSERT INTO gaz_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israaʼeloonni hundinuu Musee fi Aroonitti guunguman; waldaan guutuunis akkana isaaniin jedhe; “Nu utuu biyyuma Gibxitti dhumnee jiraannee! Yookaan utuu gammoojjii kana keessatti dhumnee jiraannee! ");
INSERT INTO gaz_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Waaqayyo maaliif akka nu goraadeedhaan dhumnuuf jedhee biyya kanatti nu fida? Niitonni keenyaa fi ijoolleen keenya ni boojiʼamu. Biyya Gibxitti deebiʼuun nuu hin wayyuu?” ");
INSERT INTO gaz_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Isaanis, “Amma hoogganaa filannee biyya Gibxitti haa deebinu” waliin jedhan. ");
INSERT INTO gaz_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Kana irratti Musee fi Aroon fuula guutummaa yaaʼii Israaʼel kanneen achitti walitti qabamanii duratti addaan lafatti gombifaman. ");
INSERT INTO gaz_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Jarreen biyyattii keessa deemanii basaasan keessaa Iyyaasuun ilmi Nuuniitii fi Kaaleb ilmi Yefunee uffata ofii tarsaasanii, ");
INSERT INTO gaz_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","guutummaa yaaʼii Israaʼelootaatiin akkana jedhan; “Biyyi nu keessa deemnee basaasne sun akka malee gaarii dha. ");
INSERT INTO gaz_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Waaqayyo yoo nutti gammade biyya sanatti nu galchee biyyattii aannanii fi damma baaftu sana nuu kenna. ");
INSERT INTO gaz_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Isin garuu Waaqayyotti hin fincilinaa. Waan nu isaan lilliqimsinuuf namoota biyya sanaa hin sodaatinaa. Gaaddisni isaan irraa kaʼeera; Waaqayyo nu wajjin jira. Isaan hin sodaatinaa.” ");
INSERT INTO gaz_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Waldaan guutuun garuu dhagaan isaan tumuudhaaf mariʼate. Ulfinni Waaqayyoos fuula dunkaana wal gaʼii duratti Israaʼeloota hundatti mulʼate. ");
INSERT INTO gaz_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Waaqayyos Museedhaan akkana jedhe; “Sabni kun hamma yoomiitti akkana na tuffata? Utuma ani mallattoowwan kanneen hunda gidduu isaaniitti hojjedhuu isaan hamma yoomiitti na amanuu didu? ");
INSERT INTO gaz_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ani golfaadhaan dhaʼee isaan nan balleessa; siʼi garuu saba isaan caalaa guddaa fi jabaa sin godha.” ");
INSERT INTO gaz_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Museen Waaqayyoon akkana jedhe; “Warri Gibxi waaʼee waan kanaa ni dhagaʼu! Ati humna keetiin saba kana gidduu isaaniitii baaftee fiddeertaatii. ");
INSERT INTO gaz_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Isaanis waaʼee waan kanaa saba biyya sana keessa jiraatutti ni odeessu. Yaa Waaqayyo, isaan akka ati saba kana gidduu jirtu dhagaʼaniiru; yaa Waaqayyo isaan akka ati fuuluma isaaniitti mulʼatu, akka duumessi kee isaaniin ol jiruu fi akka ati guyyaa utubaa duumessaatiin, halkan immoo utubaa ibiddaatiin isaan dura deemtu dhagaʼanii jiru. ");
INSERT INTO gaz_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Yoo ati saba kana yeruma tokkotti barbadeessite, saboonni oduu waaʼee keetii dhagaʼan, ");
INSERT INTO gaz_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‘Waaqayyo biyya kakuudhaan waadaa isaaniif gale sanatti saba kana galchuu hin dandeenye; inni kanumaaf gammoojjii keessatti isaan gogorraʼe’ jedhu. ");
INSERT INTO gaz_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","“Egaa akkuma ati akkana jettee dubbatte sanatti jabinni Gooftaa haa argisiifamu: ");
INSERT INTO gaz_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‘Waaqayyo dafee hin aaru; jaalalli isaa immoo guddaa dha; inni cubbuu fi fincila namaaf dhiisa. Taʼu illee inni nama yakka hojjetu adabu malee hin dhiisu; inni hamma dhaloota sadaffaa fi afuraffaatti sababii cubbuu abbootii isaaniitiif jedhee ijoollee ni adaba.’ ");
INSERT INTO gaz_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Akkuma yeroo isaan biyya Gibxii baʼanii jalqabdee hamma ammaatti dhiifama isaaniif goote sana akkuma jaalala kee guddaa sanaatti cubbuu saba kanaa dhiisiif.” ");
INSERT INTO gaz_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Waaqayyo akkana jedhee deebiseef; “Ani akkuma ati kadhatte sana isaaniif dhiiseera. ");
INSERT INTO gaz_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Taʼu illee akkuma ani dhugumaan jiraataa taʼee fi akkuma ulfinni Waaqayyoo dhugumaan lafa hunda guute sana, ");
INSERT INTO gaz_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","namoota ulfina koo arganii, mallattoowwan ani biyya Gibxiitii fi gammoojjii keessatti hojjedhe arganii garuu naa ajajamuu didanii yeroo kudhan na qoran sana keessaa namni tokko iyyuu, ");
INSERT INTO gaz_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","tokkoon isaanii biyya ani kakuudhaan abbootii isaaniitiif waadaa gale sana hin argan. Namni na tuffate tokko biyya sana hin argu. ");
INSERT INTO gaz_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Garbicha koo Kaaleb garuu sababii inni hafuura addaa qabuu fi sababii garaa guutuudhaan na duukaa buʼaa jiruuf, ani biyya inni dhaqe sanatti isa galcha; sanyiin isaas biyya sana ni dhaala. ");
INSERT INTO gaz_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Sababii Amaaleqoonnii fi Kanaʼaanonni Sululoota keessa jiraataniif, isin bor deebiʼaatii karaa Galaana Diimaatiin gammoojjiitti qajeelaa.” ");
INSERT INTO gaz_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Waaqayyo Musee fi Arooniin akkana jedhe: ");
INSERT INTO gaz_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","“Waldaan hamaan kun hamma yoomiitti natti guunguma? Ani guungummii Israaʼeloota guungumtoota sanaa dhagaʼeera. ");
INSERT INTO gaz_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Akkana jedhii isaanitti himi; ‘Waaqayyo akkana jedha; ani jiraataadhaatii, akkuma isin gurra kootti dubbattan sana anis isinitti godha: ");
INSERT INTO gaz_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Reeffi keessan jechuunis reeffi warra umuriin isaanii waggaa digdamaa fi digdamaa olii kanneen lakkoobsa uummataa keessatti lakkaaʼamanii natti guunguman hundaa gammoojjii kana keessatti harcaʼee hafa. ");
INSERT INTO gaz_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Kaaleb ilma Yefuneetii fi Iyyaasuu ilma Nuuni malee tokkoon keessan iyyuu biyya ani keessa isin qubachiisuuf kakadhe sanatti hin galtan. ");
INSERT INTO gaz_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ani garuu ijoollee keessan warra isin ni boojiʼamu jettan sana itti nan galcha; isaanis biyya isin tuffattan sana ni beeku. ");
INSERT INTO gaz_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Isin garuu, reeffi keessan gammoojjuma kana keessatti harcaʼa. ");
INSERT INTO gaz_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ijoolleen keessan waggaa afurtama gammoojjii kana keessa ni jooru; hamma isin hundi gammoojjii keessatti dhumtanitti isaan sababii amanamummaa dhabuu keessaniitiif achitti rakkatu. ");
INSERT INTO gaz_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Isin akkuma bultii afurtama biyya sana basaastan, akkasuma bultiin tokko akka waggaa tokkootti lakkaaʼamee waggaa afurtama cubbuu keessaniif dhiphattu; yeroo sana isin akka ani isiniin mormu ni beektu.’ ");
INSERT INTO gaz_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ani Waaqayyo waan kana dubbadheen jira; ani dhugumaan waan kana waldaa hamaa naan mormuuf walitti gurmaaʼe kana guutuutti nan fida. Isaan gammoojjii kana keessatti dhumu; asumattis ni duʼu.” ");
INSERT INTO gaz_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Namoonni Museen akka isaan biyyattii basaasaniif erge yommuu achii deebiʼanitti waaʼee biyya sanaa gabaasa hamaa waldaatti gabaasanii akka waldaan Museetti guungumu godhan jechuunis ");
INSERT INTO gaz_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","namoonni waaʼee biyyattii gabaasa hamaa gabaasuutti gaafataman sun dhaʼichaan fuula Waaqayyoo duratti dhuman. ");
INSERT INTO gaz_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Namoota biyyattii basaasuu dhaqan keessaa Iyyaasuu ilma Nuunitii fi Kaaleb ilma Yefunee qofatu duʼa oole. ");
INSERT INTO gaz_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Museen waan kana hunda Israaʼelootatti himnaan isaan akka malee booʼan. ");
INSERT INTO gaz_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Isaanis guyyaa itti aanu ganamaan fiixee biyya gaaraatti ol baʼanii, “Nu cubbuu hojjenneerra; nu amma gara lafa Waaqayyo waadaa nuu gale sanaa dhaqna” jedhan. ");
INSERT INTO gaz_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Museen garuu akkana jedhe; “Isin maaliif ajaja Waaqayyoo cabsitu? Wanni kun isiniif hin milkaaʼu! ");
INSERT INTO gaz_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Akka diinota keessaniin hin moʼatamneef ol hin baʼinaa; Waaqayyo isin wajjin hin jiruutii; ");
INSERT INTO gaz_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Amaaleqoonnii fi Kanaʼaanonni achitti isinitti dhufuutii. Sababii isin Waaqayyo irraa garagaltaniif inni isin wajjin hin jiraatu; goraadeedhaan barbadeeffamtu.” ");
INSERT INTO gaz_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Isaan garuu utuu Musee fi taabonni kakuu Waaqayyoo qubata keessaa gad hin baʼin yaaduma isaaniitiin kaʼanii fiixee biyya gaaraatti ol baʼan. ");
INSERT INTO gaz_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Yommus Amaaleqoonnii fi Kanaʼaanonni gaara sana irra jiraatan gad buʼanii isaan dhaʼanii hamma Hormaatti isaan ariʼan. ");
INSERT INTO gaz_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","“Saba Israaʼelitti akkana jedhii dubbadhu: ‘Yommuu biyya ani akka isin keessa jiraattaniif isiniif kennu sana seentanii ");
INSERT INTO gaz_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","aarsaa ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti tolu, loon keessaa yookaan bushaayee keessaa fuutanii aarsaa gubamu yookaan qalma wareega addaatiif yookaan aarsaa fedhii keessanii yookaan aarsaa ayyaana waggaa Waaqayyoof dhiʼeessitu, ");
INSERT INTO gaz_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","namni aarsaa dhiʼeessu sun daakuu bullaaʼaa iifii harka kudhan keessaa harka tokko kan zayitii iinii harka afur keessa harka tokkootiin sukkuumame kennaa midhaanii godhee Waaqayyoof haa dhiʼeessu. ");
INSERT INTO gaz_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Tokkoo tokkoo xobbaallaa hoolaa kan aarsaa gubamuuf yookaan qalmaaf dhiʼeeffamu wajjinis daadhii wayinii iinii harka afur keessaa harka tokko dhibaayyuudhaaf qopheessi. ");
INSERT INTO gaz_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","“ ‘Korbeessa hoolaa tokko wajjinis daakuu bullaaʼaa iifii harka kudhan keessaa harka lama kan zayitii iinii harka sadii keessaa harka tokkoon sukkumameen kennaa midhaanii qopheessi. ");
INSERT INTO gaz_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Daadhii wayinii iinii harka sadii keessaa harka tokko dhibaayyuu urgaan isaa Waaqayyotti tolu godhii dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","“ ‘Ati yommuu dibicha loonii tokko aarsaa gubamu yookaan qalma wareega addaatiif yookaan aarsaa nagaatiif Waaqayyoof qopheessitutti, ");
INSERT INTO gaz_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","dibicha sana wajjin kennaa midhaanii fidi; kennaan sunis daakuu bullaaʼaa iifii harka kudhan keessaa harka sadii kan zayitii walakkaa iiniitiin sukkuumame haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Akkasumas daadhii wayinii iinii walakkaa dhibaayyuu godhii fidi. Wanni kunis aarsaa ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti tolu taʼa. ");
INSERT INTO gaz_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","Tokkoon tokkoon dibicha loonii yookaan korbeessa hoolaa, tokkoon tokkoon xobbaallaa hoolaa yookaan korbeessa reʼee xinnaa haaluma kanaan haa qopheeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Akkuma baayʼina waan qopheessitan sanaatti akkuma lakkoobsa isaaniitti, tokkoo tokkoo isaaniitiif akkanuma godhaa. ");
INSERT INTO gaz_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","“ ‘Namni dhalataa biyya sanaa taʼe hundinuu yeroo aarsaa ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti tolu fidutti wantoota kanneen haaluma kanaan haa hojjetu. ");
INSERT INTO gaz_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Dhaloota dhufu keessattis alagaan yookaan namni gidduu keessan jiraatu yeroo aarsaa ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti tolu dhiʼeessutti akkuma isin gootan kana haa godhu. ");
INSERT INTO gaz_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Yaaʼiin sun isinii fi alagaa isin gidduu jiraatuuf illee seeruma tokko haa qabaatu; kunis dhaloota dhufuuf seera bara baraa ti. Atii fi alagaan sun fuula Waaqayyoo duratti wal qixxee dha. ");
INSERT INTO gaz_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Isiniifis alagaa isin gidduu jiraatuufis seerrii fi dambiin tokkuma haa taʼu.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Waaqayyos Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","“Akkana jedhii Israaʼelootatti dubbadhu: ‘Isin yeroo biyya ani itti isin galchu sana seentanii ");
INSERT INTO gaz_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","midhaan ishee nyaattanitti, nyaata sana irraa Waaqayyoof kennaa dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Bukoo keessan kan jalqabaa irraa maxinoo tokko kennaa dhiʼeessaa; isas akka aarsaa oobdii irraa fuudhameetti dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dhaloota dhufu hundumaa keessatti bukoo keessan kan jalqabaa irraa Waaqayyoof kennaa kennuu qabdu. ");
INSERT INTO gaz_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","“ ‘Yoo isin utuu hin beekin ajajawwan Waaqayyo Museetti kenne kanneen keessaa tokko illee ");
INSERT INTO gaz_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","jechuunis yoo isin ajaja Waaqayyoo kan gaafa Waaqayyo ajaja kana kennee jalqabee dhaloota dhufu keessa illee ittuma fufuudhaan karaa Museetiin isin ajaje kam iyyuu cabsitan, ");
INSERT INTO gaz_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","yoo wanti kun dogoggoraan utuu waldaan hin beekin hojjetamee jiraate waldaan sun hundi dibicha loonii aarsaa gubamu kan urgaan isaa Waaqayyotti tolu, kennaa midhaaniitii fi dhibaayyuu ajajame wajjin, aarsaa cubbuutiif immoo korbeessa reʼee haa dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Lubnis waldaa saba Israaʼel hundaaf araara haa buusu; isaanis waan utuu hin beekin cubbuu hojjetaniif, balleessaa isaaniitiifis waan aarsaa ibiddaan dhiʼeeffamuu fi aarsaa cubbuu Waaqayyoof fidaniif dhiifama ni argatu. ");
INSERT INTO gaz_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Sababii sabni hundi balleessaa dogoggoraan hojjetame sana keessatti hirmaateefis waldaan saba Israaʼel hundii fi alagaawwan isaan gidduu jiraatan dhiifama ni argatu. ");
INSERT INTO gaz_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","“ ‘Garuu yoo namni tokko qofti utuu hin beekin cubbuu hojjete inni goromtii reʼee kan umuriin ishee waggaa tokkoo aarsaa cubbuutiif haa fidu. ");
INSERT INTO gaz_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Lubni sunis namicha utuu itti hin yaadin cubbuu hojjete sanaaf fuula Waaqayyoo duratti araara haa buusu; erga araarri isaaf buʼee booddee immoo namichi sun dhiifama ni argata. ");
INSERT INTO gaz_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Dhalataa Israaʼeliifis taʼu yookaan alagaa isin gidduu jiraatuuf, nama utuu itti hin yaadin cubbuu hojjete hundaaf seerri tokkuma haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","“ ‘Garuu dhalataa biyyaas taʼu yookaan alagaan, namni beekaa cubbuu hojjetu Waaqayyoon arrabsuu isaa ti; namichi sun saba isaa keessaa haa balleeffamu. ");
INSERT INTO gaz_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Namichi sun sababii dubbii Waaqayyoo tuffatee fi sababii ajaja isaa cabseef inni haa balleeffamu; balleessaa isaattis isatu gaafatama.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Yeroo sabni Israaʼel gammoojjii keessa turetti, namni tokko utuu guyyaa Sanbataatiin qoraan walitti qabatuu argame. ");
INSERT INTO gaz_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Warri utuu inni qoraan walitti qabatuu arganis Museetti, Arooniitii fi waldaa guutuutti isa geessan; ");
INSERT INTO gaz_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","sababii wanni isa godhan hin beekaminiif hidhanii isa tursan. ");
INSERT INTO gaz_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Waaqayyo Museedhaan, “Namichi duʼuu qaba. Waldaan sun guutuun qubataan alatti dhagaadhaan isa haa tumu” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Waldaan sun akkuma Waaqayyo Musee ajajetti namicha sana qubata keessaa gad baasee dhagaadhaan tumee ajjeese. ");
INSERT INTO gaz_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","“Akkana jedhii Israaʼelootatti dubbadhu: ‘Dhaloota dhufu hunda keessa qarqara wayyaa keessanii irratti handaara tolfadhaa; tokkoon tokkoon handaara sanaas foʼaa bifa cuquliisaa haa qabaatu. ");
INSERT INTO gaz_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Isin handaara kana ilaaltanii ajaja Waaqayyoo hunda yaadattu; kunis akka ajaja kana eegdanii hawwii garaa keessaniitii fi hawwii ija keessanii duukaa buʼuudhaan hin sagaagalleef. ");
INSERT INTO gaz_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Yoos isin ajaja koo hunda yaadattanii ni eegdu; Waaqa keessaniifis qulqulloota ni taatu. ");
INSERT INTO gaz_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ani Waaqayyo Waaqa keessan kan Waaqa isinii taʼuuf jedhee biyya Gibxii isin baasee dha. Ani Waaqayyo Waaqa keessan.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Qooraahi ilmi Yizihaar, ilmi Qohaati, ilmi Lewwii, gosa Ruubeen keessaa immoo ilmaan Eliiyaab, Daataanii fi Abiiraam akkasumas Ooni ilmi Phelet kaʼanii ");
INSERT INTO gaz_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","Museedhaan morman. Isaan wajjinis namoota Israaʼel jechuunis hooggantoota waldaa bebeekamoo kanneen miseensa yaaʼii taʼanii muudamanii turan 250 gaʼantu ture. ");
INSERT INTO gaz_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Isaanis Musee fi Arooniin mormuuf jedhanii tokkummaadhaan walitti qabamanii dhufanii akkana isaaniin jedhan; “Isin dubbii baayʼiftaniirtu! Waldaan kun guutummaatti tokkoon tokkoon isaanii iyyuu qulqulluu dha; Waaqayyos isaan wajjin jira. Yoos isin maaliif waldaa Waaqayyoo irratti of tuultu ree?” ");
INSERT INTO gaz_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Museen dubbii kana dhageenyaan addaan lafatti gombifame. ");
INSERT INTO gaz_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Ergasiis Qooraahii fi warra isa duukaa buʼan hundaan akkana jedhe: “Bori ganama Waaqayyo nama kan isaa taʼee fi nama qulqulluu taʼe ni argisiisa; akka namni sun gara isaatti dhiʼaatu illee ni godha. Inni nama filate sana akka inni itti dhiʼaatu godha. ");
INSERT INTO gaz_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Qooraahi, atii fi warri si duukaa buʼan hundi waan kana godhaa: Girgiraawwan fudhadhaatii ");
INSERT INTO gaz_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","bori fuula Waaqayyoo duratti ibiddaa fi ixaana itti naqaa. Namni Waaqayyo filatu inni nama qulqulluu taʼa. Isin Lewwonni dubbii baayʼiftaniirtu!” ");
INSERT INTO gaz_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Museenis Qooraahiidhaan akkana jedhe; “Isin Lewwonni mee dhagaʼaa! ");
INSERT INTO gaz_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Waaqni Israaʼel waldaa Israaʼel kaan keessaa isin filatee akka isin hojii dunkaana qulqulluu Waaqayyoo hojjettanii fi akka isin fuula waldaa dura dhaabatanii isaan tajaajiltaniif jedhee ofitti isin dhiʼeessuun isaa isin hin gaʼuu? ");
INSERT INTO gaz_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Inni siʼii fi Lewwota si wajjin jiran hunda ofitti dhiʼeesseera; isin garuu lubummaa illee fudhachuu barbaaddan. ");
INSERT INTO gaz_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Kanaafuu atii fi miiltonni kee hundinuu walitti qabamtanii Waaqayyoon mormitan. Aroon isin itti guungumtan kun eenyuu dha?” ");
INSERT INTO gaz_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Museenis ergasii ilmaan Eliiyaab Daataanii fi Abiiraam waamsise. Isaan garuu akkana jedhan; “Nu hin dhufnu! ");
INSERT INTO gaz_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","Ati gammoojjii keessatti nu fixuuf jettee biyya aannanii fi damma baasu keessaa nu baasuun kee si hin gaʼuu? Amma immoo gooftaa nutti taʼuu feetaa? ");
INSERT INTO gaz_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Kana malee iyyuu ati biyya aannanii fi damma baasutti nu hin galchine yookaan dhaala lafa qotiisaatii fi iddoo dhaabaa wayinii nuu hin kennine. Ati ija namoota kanaa ni baaftaa? Lakkii, nu hin dhufnu!” ");
INSERT INTO gaz_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Museen akka malee aaree Waaqayyoon, “Aarsaa isaanii hin fudhatin. Ani harree tokko illee isaan irraa hin fudhanne yookaan isaan keessaa nama tokko illee hin miine” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Museen Qooraahiidhaan akkana jedhe; “Atii fi miiltonni kee hundinuu akkasumas ati, isaanii fi Aroon bori fuula Waaqayyoo duratti argamaa. ");
INSERT INTO gaz_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Tokkoon tokkoon namaa girgiraa isaa fudhatee, ixaana itti naqatee fuula Waaqayyoo duratti haa dhiʼeessu; girgiraawwan kunneenis walumaa galatti 250 taʼu. Akkasumas atii fi Aroon girgiraa keessan dhiʼeessuu qabdu.” ");
INSERT INTO gaz_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Tokkoon tokkoon namaa girgiraa isaa fudhatee, ibiddaa fi ixaana itti naqatee Musee fi Aroon wajjin balbala dunkaana wal gaʼii dura dhaabate. ");
INSERT INTO gaz_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Yeroo Qooraahi isaaniin mormuuf jedhee duukaa buutota isaa hunda balbala dunkaana wal gaʼii duratti walitti qabetti, ulfinni Waaqayyoo waldaa guutuutti mulʼate. ");
INSERT INTO gaz_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Waaqayyo Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","“Akka ani yeruma tokkoon isaan fixuuf waldaa kana irraa gargar baʼaa.” ");
INSERT INTO gaz_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Musee fi Aroon garuu addaan lafatti gombifamanii akkana jedhanii iyyan; “Yaa Waaqayyo Waaqa hafuurota sanyii nama hundaa, ati yoo namni tokko yakke waldaa guutuutti dheekkamtaa?” ");
INSERT INTO gaz_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","“Waldaa kanaan, ‘Dunkaanota Qooraahi, kan Daataaniitii fi Abiiraam irraa fagaadhaa’ jedhi.” ");
INSERT INTO gaz_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Museenis kaʼee gara Daataanii fi Abiiraam dhaqe; maanguddoonni Israaʼelis isa duukaa buʼan. ");
INSERT INTO gaz_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Innis waldaa sanaan, “Dunkaana namoota hamoo kanneenii irraa fagaadhaa! Isin akka sababii cubbuu isaanii hundaan hin barbadeeffamneef waan kan isaanii taʼe kam iyyuu hin tuqinaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Isaan dunkaanota Qooraahi, kan Daataanii fi kan Abiiraamiis irraa fagaatan. Daataanii fi Abiiraamiis gad baʼanii niitota, ijoollee fi daaʼimman isaanii wajjin balbala dunkaanota isaanii dura dhadhaabachaa turan. ");
INSERT INTO gaz_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Ergasii Museen akkana jedhe; “Ani wantoota kanneen hunda akkan hojjedhuuf Waaqayyo akka na erge, kunis yaada koo akka hin taʼin isin kanaan ni beektu: ");
INSERT INTO gaz_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Yoo namoonni kunneen duʼuma uumamaan dhufu duʼanii fi wanni nama hundatti dhufu isaanitti dhufe Waaqayyo na hin ergine. ");
INSERT INTO gaz_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Garuu yoo Waaqayyo waan guutummaan guutuutti haaraa taʼe tokko isaanitti fidee lafti afaan bantee waan isaan qaban hunda wajjin isaan liqimsite, yoo isaanis utuma lubbuun jiranuu boolla buʼan, isin akka namoonni kunneen Waaqayyoon tuffatan ni beektan.” ");
INSERT INTO gaz_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Akkuma inni waan kana hunda dubbatee fixateen lafti isaan jalaa baqaqxe; ");
INSERT INTO gaz_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","lafti sunis afaan bantee warra mana isaanii, namoota Qooraahi hundaa fi qabeenya isaanii hunda wajjin isaan liqimsite. ");
INSERT INTO gaz_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Isaanis waan qaban hunda wajjin jiraatti boolla buʼan; laftis isaan irratti afaan walitti deebifatte; isaanis akkasiin waldaa keessaa balleeffaman. ");
INSERT INTO gaz_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Isaan iyyinaan Israaʼeloonni naannoo isaanii turan hundinuu, “Lafti kun nuunis ni liqimsiti!” jedhanii iyyaa baqatan. ");
INSERT INTO gaz_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ibiddi Waaqayyo biraa gad buʼee namoota 250 kanneen aarsaa ixaanaa dhiʼeessaa turan sana fixe. ");
INSERT INTO gaz_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","“Akka inni girgiraawwan sana lafa jarri itti gubamanii fuudhee cilee isaanii kan bobaʼu achi fageessee keessaa bittinneessuuf Eleʼaazaar ilma Aroon lubichaatti himi; girgiraawwan sun qulqulluudhaatii. ");
INSERT INTO gaz_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Girgiraawwan kunneenis girgiraawwan namoota lubbuu isaaniitti muruudhaan cubbuu hojjetanii ti. Girgiraawwan sanas iddoo aarsaatti uffisuudhaaf tumii haphisi; isaan fuula Waaqayyoo duratti dhiʼeeffamanii qulqulluu taʼaniiruutii. Isaanis Israaʼelootaaf mallattoo haa taʼan.” ");
INSERT INTO gaz_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Eleʼaazaar lubichi girgiraawwan naasii kanneen namoonni gubaman sun dhiʼeessan sana iddoo aarsaatti uffisuudhaaf jedhee walitti qabee tume. ");
INSERT INTO gaz_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Kanas akkuma Waaqayyo karaa Museetiin isa ajajetti hojjete. Kunis akka sanyii Aroon malee namni tokko iyyuu ixaana aarsuuf fuula Waaqayyoo duratti hin dhiʼaanne, yoo kanaa achii akka inni akkuma Qooraahiitii fi miiltota isaa sanaa taʼu Israaʼeloota yaadataniif. ");
INSERT INTO gaz_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Guyyaa itti aanutti waldaan Israaʼel hundi, “Isin saba Waaqayyoo fixxan” jedhanii Musee fi Aroonitti guunguman. ");
INSERT INTO gaz_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Garuu yeroo waldaan sun Musee fi Arooniin mormuudhaaf walitti qabamee gara dunkaana wal gaʼii ilaaletti, kunoo duumessi dunkaana sana haguuge; ulfinni Waaqayyoos ni mulʼate. ");
INSERT INTO gaz_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Musee fi Aroon gara fuuldura dunkaana wal gaʼii dhaqan; ");
INSERT INTO gaz_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Waaqayyos Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","“Akka ani yommusuma isaan balleessuuf, waldaa kana biraa fagaadhu.” Isaanis addaan lafatti gombifaman. ");
INSERT INTO gaz_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Ergasii Museen Arooniin akkana jedhe; “Girgiraa kee fudhadhuutii iddoo aarsaa irraa ixaana ibidda wajjin itti naqadhuutii araara isaaniif buusuudhaaf gara waldaatti fiigi. Dheekkamsi Waaqayyo biraa dhufeera; dhaʼichi jalqabeera.” ");
INSERT INTO gaz_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Aroon akkuma Museen jedhe sana fiigee gidduu waldaa seene. Yeroo kanatti dhaʼichi gidduu waldaatti jalqabee ture. Aroon garuu ixaana dhiʼeessee araara isaaniif buuse. ");
INSERT INTO gaz_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Innis warra jiruu fi warra duʼe gidduu ijaajje; dhaʼichi sunis ni dhaabate. ");
INSERT INTO gaz_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Garuu namoota sababii Qooraahiitiif dhuman malee namoota 14,700 gaʼantu dhaʼicha sanaan dhume. ");
INSERT INTO gaz_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Aroon sababii dhaʼichi sun dhaabateef gara balbala dunkaana wal gaʼii gara Museetti deebiʼe. ");
INSERT INTO gaz_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","“Israaʼelootatti dubbadhuutii hooggantoota gosa abbootii isaanii harkaa ulee tokko tokko, walumaa galatti uleewwan kudha lama fuudhi. Maqaa tokkoo tokkoo namaas ulee isaa irratti barreessi. ");
INSERT INTO gaz_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Sababii tokkoo tokkoo hoogganaa gosa abbootiitiif uleen tokko jiraachuu qabuuf maqaa Aroon ulee Lewwii irratti barreessi. ");
INSERT INTO gaz_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Uleewwan kanneenis dunkaana wal gaʼii keessa fuula taabota kakuu seeraa dura iddoo ani itti isiniin wal argu sana kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Uleen nama ani filadhuu ni lata; anis guungummii Israaʼeloonni yeroo hunda isinitti guunguman of irraa nan kuta.” ");
INSERT INTO gaz_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Museen Israaʼelootatti dubbate; hooggantoonni isaaniis uleewwan kudha lama jechuunis hooggantoota tokkoo tokkoo gosa abbootii isaaniitiif ulee tokko tokko isatti kennan; uleen Aroonis uleewwan sana keessa ture. ");
INSERT INTO gaz_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Museenis uleewwan sana dunkaana dhuga baʼumsaa keessa fuula Waaqayyoo dura kaaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Guyyaa itti aanutti Museen dunkaana dhuga baʼumsaa seenee uleen Aroon kan gosa Lewwii iddoo buʼu sun isaa latu qofa utuu hin taʼin hudhee daraaree lawuzii naqate arge. ");
INSERT INTO gaz_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Museen ulee sana hunda fuula Waaqayyoo duraa alatti gad baasee Israaʼeloota hundatti fide. Isaanis ilaalanii tokkoon tokkoon namaa ulee ofii isaa fudhate. ");
INSERT INTO gaz_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Waaqayyo Museedhaan akkana jedhe; “Ulee Aroon fuudhiitii akka inni finciltootaaf mallattoo taʼuuf fuula taabota kakuu seeraa dura deebisii kaaʼi. Kun akka isaan hin dhumneef natti guungumuu isaanii sana dhaabachiisa.” ");
INSERT INTO gaz_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Museenis akkuma Waaqayyo isa ajaje sana godhe. ");
INSERT INTO gaz_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Israaʼeloonni Museedhaan akkana jedhan; “Nu ni duuna! Nu badneerra; nu hundinuu badneerra! ");
INSERT INTO gaz_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Namni dunkaana qulqulluu Waaqayyootti dhiʼaatu kam iyyuu ni duʼa. Nu amma duʼuuf jirraa?” ");
INSERT INTO gaz_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Waaqayyo Arooniin akkana jedhe; “Ati, ilmaan keetii fi maatiin abbaa keetii si wajjin yakka iddoo qulqulluutti hojjetametti ni gaafatamtu. Yakka lubummaatti hojjetame siʼii fi ilmaan kee qofatu itti gaafatama. ");
INSERT INTO gaz_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Akka isaan yeroo atii fi ilmaan kee fuula dunkaana dhuga baʼumsaa duratti tajaajiltanitti sitti dabalamanii si gargaaraniif obboloota kee warra gosa Lewwii, warra gosa abbaa keetii sana fidi. ");
INSERT INTO gaz_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Isaanis ajaja kee dhagaʼuudhaan hojiiwwan dunkaana keessaa hunda haa hojjetan; garuu miʼa iddoo qulqulluutti yookaan iddoo aarsaatti dhiʼaachuu hin qaban. Yoo akkas taʼe isaanis, atis ni duutu. ");
INSERT INTO gaz_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Isaanis dunkaana wal gaʼii eeguudhaaf isinitti dabalamuu qabu; hojii dunkaana sanaa hundas haa hojjetan. Namni biraa iddoo isin jirtanitti dhiʼaachuu hin qabu. ");
INSERT INTO gaz_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","“Isin akka dheekkamsi ammas Israaʼeloota irra hin buuneef eegumsa iddoo qulqulluutii fi eegumsa iddoo aarsaatti ni gaafatamtu. ");
INSERT INTO gaz_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ani mataan koo obboloota keessan Lewwota kennaawwan isinii kennaman godhee saba Israaʼel keessaa filadheera; isaanis akka hojii dunkaana wal gaʼii keessaa hojjetaniif Waaqayyoof kennamanii jiru. ");
INSERT INTO gaz_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Garuu hojii iddoo aarsaatii fi hojii golgaa keessaa hunda siʼii fi ilmaan kee qofatu hojjeta. Ani hojii lubummaa kennaa godhee isiniif nan kenna. Namni biraa kan iddoo qulqulluutti dhiʼaatu haa ajjeefamu.” ");
INSERT INTO gaz_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Waaqayyo Arooniin akkana jedhe; “Ani mataan koo itti gaafatamaa aarsaawwan naa dhiʼeeffamanii si godheera; ani aarsaawwan qulqulluu Israaʼeloonni naaf dhiʼeessan hunda akka isaan bara baraan qoodaa fi gaʼee keessan taʼaniif siʼii fi ilmaan keetiif kenneera. ");
INSERT INTO gaz_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kunis aarsaawwan waan hunda caalaa qulqulluu taʼan kanneen ibiddi hin tuqin keessaa qooda kee taʼa. Kennaawwan isaan aarsaawwan waan hunda caalaa qulqulluu taʼan godhanii naaf fidan jechuunis aarsaawwan midhaanii yookaan aarsaawwan cubbuu yookaan aarsaawwan yakkaa hunda keessaa qoodni sun kan keetii fi kan ilmaan keetii ti. ");
INSERT INTO gaz_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Isas iddoo iddoo hunda caalaa qulqulluu taʼetti nyaadhu; dhiirri hundi haa nyaatu; innis qulqulluu siif haa taʼu. ");
INSERT INTO gaz_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","“Wanni kunis kanuma kee ti; aarsaan sochoofamu kan kennaa saba Israaʼel hunda irraa addaan baafame kanuma kee ti. Anis waan kana siʼii fi ilmaan keetii fi intallan kee kanneen si wajjin jiraataniif qooda bara baraa godhee kenneera. Mana kee keessaa namni akka seeraatti qulqulluu taʼe kam iyyuu waan kana nyaachuu ni dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","“Zayitii ejersaa filatamaa hunda, daadhii wayinii filatamaa hundaa fi waan galfatan keessaa mataa midhaanii kan isaan Waaqayyoof dhiʼeessan siif nan kenna. ");
INSERT INTO gaz_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Mataan midhaanii kan isaan waan biyyattii irraa argatan hunda keessaa Waaqayyoof fidan kan kee haa taʼu; mana kee keessaa namni akka seeraatti qulqulluu taʼe kam iyyuu waan kana nyaachuu ni dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","“Israaʼel keessatti wanni qulqulleeffamee Waaqayyoof kenname hundinuu kee ti. ");
INSERT INTO gaz_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","Wanni gadameessa saaqu kam iyyuu namas taʼu horiin Waaqayyoof dhiʼeeffamu hundi kan kee ti. Ati garuu ilma hangafa, horii qulqulluu hin taʼin keessaa immoo korma hangafa furuu qabda. ");
INSERT INTO gaz_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Yeroo umuriin isaanii jiʼa tokko taʼutti akka saqilii iddoo qulqulluu kan geeraa digdama ulfaatu sanaatti gatii furii murtaaʼe meetii saqilii shaniin isaan furi. ");
INSERT INTO gaz_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","“Garuu sangaa hangafa, hoolaa hangafaa fi reʼee hangafa hin furin; isaan qulqulluu dha. Dhiiga isaanii iddoo aarsaa irratti facaasi; cooma isaanii immoo aarsaa ibiddaan dhiʼeeffamu kan urgaan isaa Waaqayyotti tolu godhiitii gubi. ");
INSERT INTO gaz_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Akkuma handaraafni aarsaa sochoofamuutii fi tafni mirgaa kan kee taʼe sana foon isaaniis kan kee taʼa. ");
INSERT INTO gaz_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","Ani waan aarsaa qulqulluu Israaʼeloonni Waaqayyoof dhiʼeessan irraa addaan baafame hunda siif, ilmaan keetii fi intallan keetiif qooda bara baraa godhee nan kenna. Innis fuula Waaqayyoo duratti siʼii fi sanyii keetiif kakuu soogiddaa kan bara baraa ti.” ");
INSERT INTO gaz_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Waaqayyo Arooniin akkana jedhe; “Ati biyya isaanii keessatti dhaala tokko illee yookaan qooda tokko illee isaan gidduudhaa hin qabaattu; ani saba Israaʼel keessatti qooda keetii fi dhaala kee ti. ");
INSERT INTO gaz_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","“Kunoo ani kennaa Israaʼel keessa jiru kudhan keessaa tokko hunda waan isaan tajaajila dunkaana wal gaʼii tajaajilaniif dhaala godhee Lewwotaaf kenneera. ");
INSERT INTO gaz_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Siʼachi Israaʼeloonni akka cubbuu hin baannee fi akka hin duuneef dunkaana wal gaʼiitti hin dhiʼaatin. ");
INSERT INTO gaz_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Kan hojii dunkaana wal gaʼii hojjetuu fi kan itti gaafatama yakka achitti hojjetamuu fudhatu Lewwotuma. Kunis dhaloota dhufuuf seera bara baraa ti. Isaan saba Israaʼel keessatti dhaala tokko illee hin argatan. ");
INSERT INTO gaz_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Qooda kanaa ani waan Israaʼeloonni kudhan keessaa tokko aarsaa godhanii Waaqayyoof dhiʼeessan sana dhaala isaanii godhee Lewwotaaf kenneera. Sababiin ani, ‘Isaan saba Israaʼel keessatti dhaala tokko illee hin qabaatan’ jedhee waaʼee isaanii dubbadheefis kanuma.” ");
INSERT INTO gaz_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","“Akkana jedhii Lewwotatti dubbadhu: ‘Yommuu kennaa harka kudhan keessaa harka tokko kan ani dhaala keessan godhee isiniif kenne sana Israaʼeloota irraa fudhatanitti isin kennaa sana harka kudhan keessaa harka tokko aarsaa Waaqayyoo godhaa dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Aarsaan keessanis akkuma midhaan oobdii irraa yookaan akkuma cuunfaa iddoo ija wayinii itti cuunfanii keessaa baʼeetti isiniif herregama. ");
INSERT INTO gaz_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Isinis haaluma kanaan kennaa harka kudhan keessaa harka tokko kan Israaʼeloota irraa argatan hunda keessaa Waaqayyoof aarsaa ni dhiʼeessitu; kennaawwan kanneen keessaas waan qooda Waaqayyoo taʼe Aroon lubichaaf kennaa. ");
INSERT INTO gaz_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Waan isinii kenname hunda keessaa kutaa waan hunda caalaa gaarii fi qulqulluu taʼe qooda Waaqayyoo godhaatii dhiʼeessaa.’ ");
INSERT INTO gaz_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","“Lewwotaan akkana jedhi: ‘Yommuu isin kutaa waan hunda caalaa gaarii taʼe dhiʼeessitanitti kutaan sun akka midhaan oobdii irraa yookaan akka cuunfaa iddoo ija wayinii itti cuunfan keessaa baʼeetti isinii herregama. ");
INSERT INTO gaz_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Sababii wanni kun mindaa hojii dunkaana wal gaʼii kan isin hojjettanii taʼeef isinii fi namoonni mana keessan jiraatan waan hafe sana iddoo barbaadan kamitti iyyuu nyaachuu dandeessu. ");
INSERT INTO gaz_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Qooda isaa kan waan hunda caalu sana dhiʼeessuudhaan isin waan kana keessatti yakka hin qabaattan; yoos isin aarsaa Israaʼelootaa qulqulluu sana hin xureessitan; hin duutanis.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Waaqayyo Musee fi Arooniin akkana jedhe: ");
INSERT INTO gaz_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","“Seerri Waaqayyo ajaje kana: Akka Israaʼeloonni goromsa diimtuu hirʼina yookaan hanqina hin qabne kan takkumaa waanjoon morma ishee hin tuqin tokko siif fidan itti himi. ");
INSERT INTO gaz_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Goromsa sanas Eleʼaazaar lubichatti kennaa; raaddi sunis qubata keessaa gad baafamtee fuula isaa duratti haa qalamtu. ");
INSERT INTO gaz_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Eleʼaazaar lubichi quba isaatiin dhiiga goromsa sanaa irraa xinnoo fuudhee dunkaana wal gaʼii duratti yeroo torba haa facaasu. ");
INSERT INTO gaz_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Utuma inni ilaaluu gogaan, foon, dhiignii fi cumaan goromsa sanaa haa gubamu. ");
INSERT INTO gaz_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Lubni sun qoraan birbirsaa, hiisophii fi kirrii bildiimaa goromsa gubamtu sanatti haa darbatu. ");
INSERT INTO gaz_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Lubni sun ergasii wayyaa ofii isaa miiccatee dhagna ofii isaa illee bishaaniin dhiqachuu qaba. Innis qubatatti galuu dandaʼa; garuu hamma galgalaatti akka seeraatti xuraaʼaa taʼee tura. ");
INSERT INTO gaz_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Namichi goromsa sana gubus wayyaa isaa miiccatee dhagna isaa bishaaniin haa dhiqatu; innis hamma galgalaatti xuraaʼee tura. ");
INSERT INTO gaz_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","“Namni qulqulluun tokko daaraa goromsa sanaa walitti haree qubata keessaa baasee iddoo seeraan qulqulluu taʼe tokko haa kaaʼu. Daaraa kanas waldaan Israaʼel bishaan ittiin qulqulleessan wajjin itti fayyadamuudhaaf ol kaaʼata; innis cubbuu irraa qulqulleeffamuuf fayyada. ");
INSERT INTO gaz_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Namni daaraa goromsa sanaa walitti haru sunis wayyaa ofii isaa miiccachuu qaba; innis akkasuma hamma galgalaatti xuraaʼaa taʼa. Kunis Israaʼelootaa fi alagoota gidduu isaanii jiraataniif seera bara baraa taʼa. ");
INSERT INTO gaz_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","“Namni reeffa nama kamii iyyuu tuqu bultii torba xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Inni guyyaa sadaffaa fi guyyaa torbaffaatti bishaaniin of qulqulleessuu qaba; ergasii qulqulluu taʼa. Garuu yoo guyyaa sadaffaa fi torbaffaatti of qulqulleessuu baate inni hin qulqullaaʼu. ");
INSERT INTO gaz_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Namni reeffa nama kamii iyyuu tuqee of hin qulqulleessin hundi dunkaana Waaqayyoo qulqullicha sana xureessa. Namni sun saba Israaʼel keessaa ni balleeffama. Sababii bishaan ittiin qulqulleessan isatti hin facaafaminiif inni xuraaʼaa dha; xuraaʼummaan isaas isuma irratti hafa. ");
INSERT INTO gaz_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","“Yeroo namni tokko dunkaana keessatti duʼutti seerri kana: Namni dunkaana sana seenu hundii fi namni dunkaana keessa jiru hundi bultii torbaaf xuraaʼaa taʼa; ");
INSERT INTO gaz_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","qodaan afaan banaa kan qadaadni jabeeffamee itti hin qadaadamin hundi xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","“Namni alatti nama goraadeedhaan ajjeefame yookaan nama ofumaan duʼe tuqu kam iyyuu yookaan namni lafee namaa yookaan awwaala tuqu kam iyyuu bultii torbaaf xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","“Nama xuraaʼaaf aarsaa ittiin qulqulleessuuf gubame sana irraa daaraa xinnaa isaa fuudhii okkotee tokkotti naqiitii bishaan yaaʼu itti dhangalaasi. ");
INSERT INTO gaz_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Ergasiis namni akka seeraatti qulqulluu taʼe hiisophii xinnaa isaa fuudhee bishaan sana keessa cuuphee dunkaanaa fi miʼa isaa hundatti, namoota achi turanittis haa faffacaasu. Akkasumas nama lafee namaa yookaan awwaala yookaan nama ajjeefame yookaan nama ofumaan duʼe tuqetti haa faffacaasu. ");
INSERT INTO gaz_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Namichi qulqulluun sun guyyaa sadaffaa fi torbaffaatti namicha xuraaʼaa sanatti haa faffacaasu; guyyaa torbaffaatti immoo isa qulqulleessuu qaba. Namichi qulqulleefamu sun wayyaa ofii isaa miiccachuu, dhagna ofii isaas bishaaniin dhiqachuu qaba; innis galgala sana qulqulluu taʼa. ");
INSERT INTO gaz_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","Garuu namni xuraaʼaan yoo of qulqulleessuu baate, inni sababii iddoo qulqulluu Waaqayyo xureesseef waldaa keessaa ni balleeffama. Bishaan ittiin qulqulleessan sun isatti hin facaafamneetii inni xuraaʼaa dha. ");
INSERT INTO gaz_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kun isaaniif seera bara baraa ti. “Namichi bishaan ittiin qulqulleessan faffacaasu sun wayyaa ofii isaa haa miiccatu; namni bishaan ittiin qulqulleessan tuqu hamma galgalaatti xuraaʼaa taʼa. ");
INSERT INTO gaz_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Wanni namni xuraaʼaan tokko tuqu kam iyyuu xuraaʼaa taʼa; namni waan sana tuqu hamma galgalaatti xuraaʼaa taʼa.” ");
INSERT INTO gaz_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Jiʼa jalqabaatti waldaan Israaʼelootaa guutuun Gammoojjii Siin gaʼe; isaanis Qaadesh keessa turan. Miiriyaamis achitti duutee awwaalamte. ");
INSERT INTO gaz_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Waldaan sun bishaan hin qabu ture; kanaafuu waldaan sun Musee fi Arooniin mormuuf walitti qabame. ");
INSERT INTO gaz_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Isaanis akkana jedhanii Musee fi Arooniin lolan; “Maaloo utuu nus gaafuma obboloonni keenya fuula Waaqayyoo duratti duʼan sana duunee jiraannee! ");
INSERT INTO gaz_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Isin maaliif waldaa Waaqayyoo gammoojjii kanatti fiddan? Akka nuu fi horiin keenya asitti dhumnuufii? ");
INSERT INTO gaz_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Maaliif biyya Gibxiitii iddoo hamaa kanatti gad nu baaftan? Iddoon kun midhaan yookaan harbuu yookaan ija wayinii yookaan roomaanii hin qabu. Bishaan dhugaatiis hin jiru!” ");
INSERT INTO gaz_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Musee fi Aroon waldaa biraa gara balbala dunkaana wal gaʼii deemanii addaan lafatti gombifaman; ulfinni Waaqayyoos isaanitti mulʼate. ");
INSERT INTO gaz_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Waaqayyos Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","“Ulee sana fuudhiitii, atii fi obboleessi kee Aroonis waldaa walitti qabaa. Fuuluma isaanii durattis kattaa sanatti dubbadhaa; kattaan sunis bishaan baasa. Atis kattaa sana keessaa waldaadhaaf bishaan baafta; akkasiin isaanii fi horiin isaanii bishaan dhuguu dandaʼu.” ");
INSERT INTO gaz_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Kanaafuu Museen akkuma inni isa ajaje sanatti ulee fuula Waaqayyoo dura jiru sana fuudhe. ");
INSERT INTO gaz_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Musee fi Aroon kattaa sana duratti waldaa walitti qaban; Museenis waldaa sanaan, “Finciltoota nana, mee dhagaʼaa; nu kattaa kana keessaa bishaan isinii baasuu qabnaa?” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Museen harka ol fudhatee ulee isaa sanaan yeroo lama kattaa sana dhaʼe. Bishaan achi keessaa lolaanaan waldaa fi horiin isaanii dhugan. ");
INSERT INTO gaz_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Waaqayyo garuu Musee fi Arooniin akkana jedhe; “Sababii isin fuula Israaʼelootaa duratti akka qulqullummaa kootiitti na kabajjanii natti amanuu diddaniif, isin biyya ani isaanii kenne sanatti waldaa kana hin galchitan.” ");
INSERT INTO gaz_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Kun bishaan Mariibaa, lafa Israaʼeloonni itti Waaqayyoon wal dhabanii fi lafa inni itti akka qulqulluu taʼe gidduu isaaniitti of argisiisee ti. ");
INSERT INTO gaz_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Museen akkana jedhee Qaadesh irraa mootii Edoomiitti ergamoota erge: “Obboleessi kee Israaʼel akkana jedha: Ati waaʼee rakkina nutti dhufe hundaa ni beekta. ");
INSERT INTO gaz_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","Abbootiin keenya Gibxitti gad buʼan; nus waggaa hedduu achi jiraanne. Warri Gibxis nuu fi abbootii keenya cunqursan; ");
INSERT INTO gaz_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","garuu nu Waaqayyotti iyyaannaan, inni nu dhagaʼee ergamaa isaa ergee biyya Gibxii nu baase. “Nu amma as Qaadeshitti jechuunis magaalaa daarii biyya keetii irra jiru tokko keessa jirra. ");
INSERT INTO gaz_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Maaloo mee akka biyya kee keessa baanee dabarru nuu eeyyami. Nu lafa qotiisaa yookaan iddoo dhaabaa wayinii tokko keessa iyyuu hin yaanu yookaan bishaan boolla bishaanii tokkoo iyyuu si duraa hin dhugnu. Nu karaa mootichaa irra godaanna malee hamma daarii kee keessaa baanutti bitaa mirgatti hin gorru.” ");
INSERT INTO gaz_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Edoom immoo akkana jedhee deebii kenne: “Isin asiin darbuu hin dandeessan; yoo darbuu yaaltan immoo nu isinitti kaanee goraadeedhaan isin dhoofna.” ");
INSERT INTO gaz_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israaʼeloonnis akkana jedhanii deebii kennan: “Nu karuma guddicha irra yaana; yoo nu yookaan horiin keenya bishaan keessan kam iyyuu dhuge, nu gatii isiniif kaffalla. Nu miilla qofaan yaanee darbuu feena; kana malee waan biraa hin feenu.” ");
INSERT INTO gaz_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Isaan amma illee akkana jedhanii deebisan: “Isin asiin hin dabartan.” Edoomis loltoota baayʼee fi jajjaboo fudhatee isaanitti gad baʼe. ");
INSERT INTO gaz_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Sababii Edoom biyya ofii isaa keessaan darbuu isaan dhowweef Israaʼeloonni isaan irraa deebiʼan. ");
INSERT INTO gaz_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Sabni Israaʼel hundinuu Qaadeshii kaʼee Tulluu Hoori gaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Waaqayyos Tulluu Hoori cinatti daangaa Edoom biratti Musee fi Arooniin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","“Aroon gara abbootii isaatti walitti qabama. Sababii isin lachuu bishaan Mariibaa biratti ajaja kootti finciltaniif, inni biyya ani Israaʼelootaaf kennutti hin galu. ");
INSERT INTO gaz_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aroonii fi ilma isaa Eleʼaazaar fuudhiitii Tulluu Hooritti ol baasi. ");
INSERT INTO gaz_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","Aroon irraa uffata isaa baasiitii ilma isaa Eleʼaazaaritti uffisi; Aroon gara abbootii isaatti walitti qabamaatii. Inni achitti duʼa.” ");
INSERT INTO gaz_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Museen akkuma Waaqayyo isa ajaje sana godhe: Isaanis utuma waldaan Israaʼel guutuun ilaaluu Tulluu Hooritti ol baʼan. ");
INSERT INTO gaz_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Museenis uffata Aroon irraa baasee ilma isaa Eleʼaazaaritti uffise. Aroonis achuma tulluu sana gubbaatti duʼe. Musee fi Eleʼaazaaris tulluu sana irraa gad buʼan; ");
INSERT INTO gaz_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","yommuu waldaan Israaʼel hundi akka Aroon duʼe dhagaʼetti manni Israaʼel guutuun bultii soddoma booʼeef. ");
INSERT INTO gaz_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mootiin Aaraad namichi Kanaʼaan kan Negeeb keessa jiraatu sun akka Israaʼel karaa Ataariim irra dhufaa jiru dhageenyaan Israaʼeloota lolee isaan keessaa nama tokko tokko boojiʼe. ");
INSERT INTO gaz_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Israaʼeloonnis, “Yoo ati saba kana dabarsitee harka keenyatti kennite, nu guutumaan guutuutti magaalaa isaanii barbadeessina” jedhanii Waaqayyoof wareegan. ");
INSERT INTO gaz_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Waaqayyos iyya Israaʼel dhagaʼee warra Kanaʼaan dabarsee harka isaaniitti kenne. Israaʼeloonnis isaanii fi magaalaawwan isaanii illee guutumaan guutuutti barbadeessan; kanaafuu iddoon sun Hormaa jedhamee waamame. ");
INSERT INTO gaz_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Isaanis Edoom duubaan darbanii deemuuf jedhanii Gaara Hoorii kaʼanii karaa Galaana Diimaatti geessu irra qajeelan. Sabni sun garuu karumatti obsa fixate; ");
INSERT INTO gaz_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","isaanis Waaqaa fi Museedhaan mormanii akkana jechuudhaan dubbatan; “Isin maaliif akka gammoojjii keessatti dhumnuuf biyya Gibxii nu baaftan? Buddeenni hin jiru! Bishaan hin jiru! Nus nyaata balfamaa kana jibbineerra!” ");
INSERT INTO gaz_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Waaqayyos bofawwan hadhaa qaban gidduu isaaniitti erge; bofawwan sunis isaan iddanii Israaʼeloonni baayʼeen dhuman. ");
INSERT INTO gaz_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Sabni sunis gara Musee dhufee akkana jedhe; “Nu yeroo Waaqayyoo fi sitti afaan dabarre sana cubbuu hojjenne. Akka Waaqayyo bofawwan kanneen nurraa fageessuuf nuuf kadhadhu.” Museen saba sanaaf kadhate. ");
INSERT INTO gaz_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Waaqayyo Museedhaan akkana jedhe; “Bofa tokko tolchiitii utubaatti fannisi; namni bofni idde kam iyyuu bofa ati tolchite sana ilaalee jiraachuu dandaʼa.” ");
INSERT INTO gaz_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Museen bofa naasii tokko tolchee utubaatti fannise. Ergasiis namni bofti idde kam iyyuu yeroo bofa naasii sana ilaalu ni jiraata ture. ");
INSERT INTO gaz_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israaʼeloonni fuula duratti qajeelanii Oobooti keessa qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Ergasiis Oobootii kaʼanii Iyyee Abaariim lafa karaa baʼa biiftuutiin fuullee Moʼaabitti gammoojjii keessatti argamu qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Achiis kaʼanii Sulula Zered keessa qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Achii kaʼaniis daarii Arnoon lafa gammoojjii keessaa kan bulchiinsa Amoorotaa keessa seentu sana irra qubatan. Arnoon lafa daarii Moʼaab irraa kan Moʼaabii fi Amoor gidduu jirtuu dha. ");
INSERT INTO gaz_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Sababiin Kitaabni Waraana Waaqayyoo akkana jedhuuf kana: “Waaheb Suufaa keessaa fi lageen, Arnoonii fi ");
INSERT INTO gaz_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","irraan-gadee sululaa kan gara Aaritti geessuu fi daarii Moʼaab irratti argamu.” ");
INSERT INTO gaz_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Achii kaʼanii gara Biʼeer boolla bishaanii kan Waaqayyo Museedhaan, “Saba walitti qabi; ani bishaan kennaafii” jedhe sanaa karaa isaanii itti fufan. ");
INSERT INTO gaz_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Israaʼelis faarfannaa kana faarfate: “Yaa boolla bishaanii nana, burqi! Isinis waaʼee isaa faarfadhaa; ");
INSERT INTO gaz_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Boolla bishaanii ilmaan mootii qotan, kan kabajamoonni sabaa, qajeelcha warra seera kennuutiin ulee isaaniitiin qotan faarfadhaa.” Isaan ergasii gammoojjii sana keessaa baʼanii Mataanaa dhaqan; ");
INSERT INTO gaz_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Mataanaadhaa kaʼanii Nahaaliʼeel dhaqan; Nahaaliʼeelii kaʼanii Baamooti dhaqan; ");
INSERT INTO gaz_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Baamootii immoo kaʼanii sulula Moʼaab, iddoo itti fiixeen Phisgaa gammoojjiitti garagaltu qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Israaʼelis Sihoon mooticha Amoorotaatiin akkana jechuuf ergamoota ergate: ");
INSERT INTO gaz_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","“Akka nu biyya kee keessaan darbinu nuuf eeyyami. Nu lafa qotiisaa yookaan iddoo dhaabaa wayinii tokkotti iyyuu hin gorru yookaan bishaan boolla bishaanii tokkoo illee hin dhugnu. Nu hamma biyya kee keessaa baanutti karaa mootichaa irra yaana.” ");
INSERT INTO gaz_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Sihoon garuu akka Israaʼel biyya isaa keessa baʼee darbu hin eeyyamne. Innis loltoota ofii guutuu walitti qabatee Israaʼelin loluuf gammoojjiitti gad baʼe. Yommuu Yaahazi gaʼettis Israaʼeliin wal lole. ");
INSERT INTO gaz_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Israaʼel garuu goraadeedhaan isa ajjeesee Arnoonii jalqabee hamma Yaaboq gaʼutti biyya isaa qabate; garuu sababii dallaan daangaa Amoorotaa jabaa tureef inni hamma daangaa Amoonotaa qofatti deemuu dandaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Israaʼelis magaalaawwan Amoorotaa hunda, Heshboonii fi qubatawwan naannoo ishee jiran hunda qabatee keessa qubate. ");
INSERT INTO gaz_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshboon kun magaalaa Sihoon mootii Amoorotaa isa mooticha Moʼaab kan duraa lolee biyya isaa hunda hamma Arnoonitti irraa fudhate sanaa ture. ");
INSERT INTO gaz_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Sababiin weellistoonni akkana jedhaniif kana: “Gara Heshboon kottaa; isheen deebitee haa ijaaramtu; Magaalaan Sihoonis haa haaromfamtu. ");
INSERT INTO gaz_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","“Heshboon keessaa ibiddi, magaalaa Sihoon keessaa arrabni ibiddaa baʼe. Ibiddi sun Aari magaalaa Moʼaab, jiraattota gaara Arnooniis gubee barbadeesse. ");
INSERT INTO gaz_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Yaa Moʼaab, siif wayyoo! Yaa warra Kemoosh, isin barbadooftaniirtu! Inni ilmaan isaa akka baqattootaatti, intallan isaa immoo akka boojiʼamtootaatti, Sihoon mootii Amoorotaatti dabarsee kenneera. ");
INSERT INTO gaz_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","“Nu garuu isaan garagalchineerra; Heshboon hamma Diiboonitti barbadoofteerti. Nus hamma Noofaa ishee gara Meedebaatti diriirtu sanaatti isaan barbadeessineerra.” ");
INSERT INTO gaz_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Akkasiin Israaʼel biyya Amoor keessa qubate. ");
INSERT INTO gaz_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Museen Yaʼizeeritti basaastota erge; isaanis qubatawwan naannoo ishee qabatanii Amoorota achi keessa jiraachaa turan ariʼanii baasan. ");
INSERT INTO gaz_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Isaanis ergasii deebiʼanii karaa Baashaan qabatanii ol baʼan; Oogi mootichi Baashaaniitii fi loltoonni isaa guutuun Edreyiitti isaaniin wal loluuf itti gad baʼan. ");
INSERT INTO gaz_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Waaqayyo Museedhaan akkana jedhe; “Sababii ani guutuu loltoota isaatii fi biyya isaa illee dabarsee harka keetti kenneef isa hin sodaatin. Waanuma Sihoon mootiin Amoorotaa kan Heshboon bulchaa ture sana goote isa illee godhi.” ");
INSERT INTO gaz_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Isaan isa, ilmaan isaatii fi loltoota isaa hunda utuu nama tokko illee hin hambisiniif dhaʼanii biyya isaa illee irraa fudhatan. ");
INSERT INTO gaz_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Israaʼeloonni gara dirree Moʼaabitti qajeelanii Yerikoon gama qarqara Yordaanos qubatan. ");
INSERT INTO gaz_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Baalaaq ilmi Ziphoori waan Israaʼel Amoorotatti hojjete hunda arge; ");
INSERT INTO gaz_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Moʼaabis waan sabni sun akka malee baayʼee taʼeef ni sodaate. Moʼaabis sababii Israaʼelootaatiif raafame. ");
INSERT INTO gaz_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Warri Moʼaabis maanguddoota Midiyaaniin, “Namoonni baayʼeen kunneen akkuma qotiyyoon marga bakkee dheedee fixu sana waan naannoo keenya jiru dheedee fixa” jedhan. Kana irratti Baalaaq ilmi Ziphoori kan yeroo sana mootii Moʼaab ture sun, ");
INSERT INTO gaz_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","akka isaan Balaʼaam ilma Beʼoor kan biyyuma itti dhalate keessa laga Efraaxiis bira Phetoori keessa jiraachaa ture sana waamaniif ergamoota erge. Baalaaqis akkana jedhe: “Kunoo, sabni tokko biyya Gibxii baʼee dhufeera; kunoo isaan lafa guutanii natti aananii qubataniiru. ");
INSERT INTO gaz_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Sababii isaan na caalaa humna qabaniif amma kottuutii isaan abaari. Yoos ani isaan moʼadhee biyya keessaa ariʼee isaan baasuu nan dandaʼa taʼa. Ani akka warri ati eebbiftu eebbifaman, warri ati abaartus abaaraman nan beekaatii.” ");
INSERT INTO gaz_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Maanguddoonni Moʼaabii fi Midiyaan sun kaʼanii kaffaltii mortuu sanaa fudhatanii deeman. Isaanis yommuu Balaʼaam bira gaʼanitti waan Baalaaq jedheen sana itti himan. ");
INSERT INTO gaz_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Balaʼaamis, “Halkan kana asuma bulaa; anis deebii Waaqayyo naaf kennu isinitti nan hima” jedheen. Qondaaltonni Moʼaab sun isuma bira turan. ");
INSERT INTO gaz_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Waaqni gara Balaʼaam dhufee, “Namoonni si wajjin jiran kunneen eenyu?” jedhee gaafate. ");
INSERT INTO gaz_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Balaʼaamis akkana jedhee Waaqaaf deebii kenne; “Baalaaq ilmi Ziphoori, mootichi Moʼaab akkana jedhee ergaa kana natti erge: ");
INSERT INTO gaz_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‘Kunoo, sabni biyya Gibxii baʼee dhufe tokko lafa guuteera; ati amma kottuutii isaan naaf abaari. Yoos ani isaan lolee ariʼee biyyaa baasuu nan dandaʼa taʼaatii.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Waaqayyo garuu Balaʼaamiin, “Isaan wajjin hin deemin. Sababii isaan eebbifamoo taʼaniif ati saba sana hin abaarin” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Balaʼaam ganama itti aanu kaʼee qondaaltota Baalaaqiin, “Sababii Waaqayyo isin wajjin deemuu na dhowweef, isin amma kaʼaa biyya keessanitti deebiʼaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Qondaaltonni Moʼaab gara Baalaaqitti deebiʼanii, “Balaʼaam nu wajjin dhufuu dide” jedhaniin. ");
INSERT INTO gaz_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Baalaaqis qondaaltota warra duraa sana caalaa baayʼee fi caalaa bebeekamoo kan biraa erge. ");
INSERT INTO gaz_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Isaanis dhufanii Balaʼaamiin akkana jedhan: “Wanni Baalaaq ilmi Ziphoori jedhu kunoo kana: ‘Maaloo wanni tokko iyyuu gara koo dhufuu si hin dhowwin; ");
INSERT INTO gaz_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","ani ulfina guddaa siif nan kennaatii; waan ati jettu hundas nan guuta. Kottuu saba kana naa abaari.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Balaʼaam garuu akkana jedhee deebiseef; “Utuu Baalaaq masaraa isaa kan meetii fi warqeen guutame sana naaf kenne illee, ani ajaja Waaqayyo Waaqa kootiin alatti waan xinnaa yookaan guddaa tokko illee hojjechuu hin dandaʼu. ");
INSERT INTO gaz_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Akka ani waan Waaqayyo natti himu kan biraa beekuu dandaʼuuf isinis akkuma warra kaanii as bulaa.” ");
INSERT INTO gaz_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Halkan sana Waaqayyo gara Balaʼaam dhufee, “Sababii namoonni kunneen si waamuu dhufaniif, isaan wajjin deemi; garuu waanuma ani sitti himu qofa hojjedhu” jedheen. ");
INSERT INTO gaz_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Balaʼaam ganamaan kaʼee harree isaa irra kooraa kaaʼatee qondaaltota Moʼaab sana wajjin deeme. ");
INSERT INTO gaz_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Waaqni garuu inni deemnaan itti aare; ergamaan Waaqayyoo tokkos isaan mormuuf jedhee karaa irra dhaabate. Balaʼaamis harree isaa yaabbatee deemaa ture; tajaajiltoonni isaa lamaan isa wajjin turan. ");
INSERT INTO gaz_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Harreen sun immoo ergamaa Waaqayyoo kan goraadee luqqifatee harkatti qabatee karaa irra dhaabatu arginaan of irra gara galtee karaa irraa gortee lafa qotiisaa seente. Balaʼaamis karaatti ishee deebisuudhaaf harree sana rukute. ");
INSERT INTO gaz_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Ergamaan Waaqayyoo sun garuu daandii dhiphoo, iddoo dhaabaa wayinii lama kanneen gama lamaan dallaa qaban gidduu baatu irra dhaabate. ");
INSERT INTO gaz_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Harreen sun ergamaa Waaqayyoo arginaan, dallaatti maxxantee miilla Balaʼaam dallaatti buufte. Inni ammas harree sana rukute. ");
INSERT INTO gaz_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ergamaan Waaqayyoos fuula duratti hiiqee daandii dhiphaa iddoo ittiin mirgatti yookaan bitaatti goran hin qabne tokko irra dhaabate. ");
INSERT INTO gaz_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Harreen sun ergamaa Waaqayyoo arginaan Balaʼaam jalaa gad ciifte; innis aaree ulee ofiitiin harree sana rukute. ");
INSERT INTO gaz_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Kana irratti Waaqayyo afaan harree sanaa banee harreen sun Balaʼaamiin, “Ani maal si yakkinaan ati akkas yeroo sadii na rukutte?” jette. ");
INSERT INTO gaz_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Balaʼaamis harree sanaan, “Ati na gowwoomsite; ani utuu goraadee of harkaa qabaadhee silaa ammuman si ajjeesa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Harreen sun amma illee Balaʼaamiin akkana jette; “Ani harree kee kan ati hamma harʼaatti guyyaa hunda yaabbattu mitii? Ani takkumaa waan akkasii sitti hojjedhee beekaa?” Innis, “Lakkii” jedhee deebiseef. ");
INSERT INTO gaz_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Yommus Waaqayyo ija Balaʼaam bane; Balaʼaamis ergamaa Waaqayyoo kan goraadee luqqifatee karaa irra dhaabatu arge. Kana irratti inni addaan lafatti gombifamee sagade. ");
INSERT INTO gaz_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ergamaan Waaqayyoo sun akkana jedhee isa gaafate; “Ati maaliif yeroo sadan kana harree kee rukutte? Kunoo ani waan karaan kee fuula koo duratti jalʼaa taʼeef siin mormuudhaafan dhufe. ");
INSERT INTO gaz_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","Harreen kun na argitee yeroo kana sadanuu narraa gorte. Utuu isheen narraa goruu baattee silaa ani yoona si ajjeesee ishee immoo hambisa ture.” ");
INSERT INTO gaz_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Balaʼaamis ergamaa Waaqayyootiin, “Ani cubbuu hojjedheera. Ani akka ati naan mormuuf jettee karaa irra dhaabatte hin hubanne. Ammas yoo sitti hin tolin ani nan deebiʼa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ergamaan Waaqayyoo sunis Balaʼaamiin, “Namoota kana wajjin deemi; garuu waanuma ani sitti himu qofa dubbadhu” jedhe. Akkasiin Balaʼaam qondaaltota Baalaaq sana wajjin deeme. ");
INSERT INTO gaz_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Baalaaqis akka Balaʼaam dhufaa jiru dhageenyaan, magaalaa Moʼaab kan daarii Arnoon irratti argamtutti isa simachuudhaaf kaʼee deeme. ");
INSERT INTO gaz_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Baalaaqis Balaʼaamiin akkana jedhe; “Ani dhaamsa ariifachiisaa sitti hin erginee? Ati maaliif na bira hin dhufne? Ani dhugumaan ulfina siif kennuu hin dandaʼuu?” ");
INSERT INTO gaz_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Balaʼaamis, “Kunoo ani si bira dhufeera. Garuu ani waanuman arge dubbachuu nan dandaʼaa? Ani waanuma Waaqni afaan koo keessa kaaʼu qofan dubbachuu qaba” jedhee deebise. ");
INSERT INTO gaz_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Balaʼaamis kaʼee Baalaaq wajjin Qiiriyaati Haxoti dhaqe. ");
INSERT INTO gaz_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Baalaaq loonii fi hoolaa aarsaa dhiʼeessee gara tokko Balaʼaamii fi qondaaltota isa wajjin turaniif kenne. ");
INSERT INTO gaz_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Ganama itti aanus Baalaaq, Balaʼaamin Baamooti Baʼaalitti ol baase; innis achi dhaabatee saba Israaʼel warra daangaa gamaa irra jiran arge. ");
INSERT INTO gaz_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Balaʼaamis Baalaaqiin, “Iddoo aarsaa torba asitti naaf ijaari; amma illee korommii loonii torbaa fi korbeeyyii hoolaa torba naa qopheessi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Baalaaqis akkuma Balaʼaam jedhe sana godhe; isaan lamaan tokkoo tokkoo iddoo aarsaa irratti korma looniitii fi korbeessa hoolaa tokko tokko aarsaa dhiʼeessan. ");
INSERT INTO gaz_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Ergasii Balaʼaam Baalaaqiin akkana jedhe; “Ani xinnoo achi sirraa nan siqa; ati immoo asuma aarsaa kee bira turi. Tarii Waaqayyo anaa wajjin wal arguuf ni dhufa taʼa. Waan inni natti mulʼisu kam iyyuu ani sittin hima.” Innis gara gaara tokkoo dhaqe. ");
INSERT INTO gaz_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Waaqayyo isaan wal arginaan Balaʼaam, “Ani iddoo aarsaa torba qopheessee tokkoo tokkoo isaa irratti korma loonii tokkoo fi korbeessa hoolaa tokko qopheesseera” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Waaqayyo ergaa tokko afaan Balaʼaam keessa kaaʼee, “Baalaaqitti deebiʼiitii ergaa kana itti himi” jedheen. ");
INSERT INTO gaz_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Balaʼaam Baalaaqitti deebiʼee isaa qondaaltota Moʼaab wajjin aarsaa isaa bira dhaabatu arge. ");
INSERT INTO gaz_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Balaʼaam ergaa isaa akkana jedhee dubbate: “Baalaaq Arraam irraa, mootichi Moʼaab gaarran baʼaa irraa na fide. Innis, ‘Kottuutii Yaaqoobin naa abaari; kottuutii Israaʼelin naa balaaleffadhu’ jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ani akkamittan warra Waaqni hin abaarin abaaruu dandaʼa? Ani akkamittan warra Waaqayyo hin balaaleffatin balaaleffachuu dandaʼa? ");
INSERT INTO gaz_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Fiixee gaarranii irraa ani isa nan arga; tulluuwwan irraas isa nan ilaala. Saba kophaa isaa jiraatu, kan saba kaan keessatti of hin lakkoofne nan arga. ");
INSERT INTO gaz_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Eenyutu awwaara Yaaqoob lakkaaʼuu dandaʼa? Eenyutu Israaʼel keessaa kurmaana isaa illee lakkaaʼa? Ani duʼa nama qajeelaa haa duʼu; dhumni koos akkuma dhuma isaa haa taʼu!” ");
INSERT INTO gaz_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Baalaaqis Balaʼaamiin, “Wanni ati na goote kun maali? Ani akka ati diina koo naa abaartuufin si fide; ati kunoo isaan eebbifte malee waan tokko iyyuu isaan hin goone!” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Innis, “Ani waan Waaqayyo afaan koo keessa kaaʼu hin dubbadhuu?” jedhee deebii kenneef. ");
INSERT INTO gaz_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Baalaaq, “Mee gara lafa itti isaan arguu dandeessu biraa na wajjin kottu; ati gara tokko qofa malee hunduma isaanii arguu hin dandeessu. Achiis isaan naa abaari” jedheen. ");
INSERT INTO gaz_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Inni gara dirree Xoofiim kan fiixee Phisgaa irratti argamuutti isa geesse; achittis iddoo aarsaa torba ijaaree tokkoo tokkoo iddoo aarsaa sanaa irratti korma loonii tokkoo fi korbeessa hoolaa tokko aarsaa dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Balaʼaamis Baalaaqiin, “Ati hamma ani achi siqee Waaqa wajjin wal argutti asuma aarsaa kee bira turi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Waaqayyo Balaʼaam wajjin wal argee ergaa tokko afaan isaa keessa kaaʼee, “Baalaaqitti deebiʼiitii ergaa kana itti himi” jedheen. ");
INSERT INTO gaz_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Balaʼaam Baalaaq bira dhaqee isaa qondaaltota Moʼaab wajjin aarsaa isaa bira dhaabatu arge. Baalaaqis, “Waaqayyo maal jedhe?” jedhee Balaʼaamiin gaafate. ");
INSERT INTO gaz_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Balaʼaam akkana jedhee ergaa isaa dubbate: “Yaa Baalaaq, kaʼiitii dhaggeeffadhu; yaa ilma Ziphoori na dhagaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Waaqni nama miti; inni hin sobu; yookaan gaabbuudhaaf inni ilma namaa miti. Inni waa dubbatee ergasii hin hojjetuu? Inni waa abdachiisee ergasii hin raawwatuu? ");
INSERT INTO gaz_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Kunoo ani eebbisuudhaaf ajaja argadheera; inni eebbiseera; anis geeddaruu hin dandaʼu. ");
INSERT INTO gaz_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","“Inni Yaaqoob keessatti daba hin argine; rakkina tokko illee Israaʼel keessatti hin argine. Waaqayyo Waaqni isaanii isaan wajjin jira; ililleen Mootii isaan wajjin jira. ");
INSERT INTO gaz_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Waaqayyo biyya Gibxiitii isaan baase; inni jabina akka jabina gafarsaa qaba. ");
INSERT INTO gaz_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Yaaqoob irratti falfalli tokko iyyuu hin hojjetu; Israaʼel irrattis tolchi tokko iyyuu hin hojjetu. Amma Yaaqoobii fi Israaʼeliin, ‘Waan Waaqni hojjete ilaalaa!’ jedhama. ");
INSERT INTO gaz_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Kunoo sabni sun akka leenca dhalaatti kaʼa; akkuma leencaattis ol jedha; inni hamma waan adamsate nyaatee fixutti, hamma dhiiga waan ajjeefate sanaa dhuguttis hin ciisu.” ");
INSERT INTO gaz_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Baalaaq Balaʼaamiin, “Ati gonkumaa isaan hin abaarin yookaan isaan hin eebbisin” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Balaʼaamis, “Ani akka waan Waaqayyo jedhu kam iyyuu hojjedhu sitti hin himnee?” jedhee Baalaaqiif deebise. ");
INSERT INTO gaz_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Ergasii Baalaaq Balaʼaamiin, “Mee kottu amma illee ani iddoo biraa sin geessaa. Tarii achii jara naaf abaaruun kee Waaqa gammachiisa taʼaatii” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Baalaaqis Balaʼaamin fiixee tulluu Pheʼoor kan irra dhaabatanii gammoojjii sana gad ilaalanitti ol baase. ");
INSERT INTO gaz_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Balaʼaamis Baalaaqiin, “Iddoo aarsaa torba asitti naaf ijaari; ammas korommii loonii torbaa fi korbeeyyii hoolaa torba naaf qopheessi” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Baalaaqis akkuma Balaʼaam jedheen sana godhe; tokkoo tokkoo iddoo aarsaa irrattis korma loonii tokkoo fi korbeessa hoolaa tokko aarsaa dhiʼeesse. ");
INSERT INTO gaz_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Balaʼaam yeroo akka Israaʼelin eebbisuun Waaqayyoon gammachiise argetti akka yeroo kaanii falfala barbaacha hin dhaqne; garuu fuula isaa gara gammoojjiitti deebifate. ");
INSERT INTO gaz_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Yommuu Balaʼaam ol milʼatee akka Israaʼel gosa gosaan qubate argetti Hafuurri Waaqaa isa irra buʼe; ");
INSERT INTO gaz_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","innis akkana jedhee ergaa isaa dubbate: “Ergaa Balaʼaam ilma Beʼoor, ergaa nama iji isaa sirriitti arguu, ");
INSERT INTO gaz_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ergaa nama dubbii Waaqaa dhagaʼuu isa Waaqa Waan Hunda Dandaʼu irraa mulʼata argu kan kufee iji isaa banamu sanaa: ");
INSERT INTO gaz_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","“Yaa Yaaqoob, dunkaanonni kee, Yaa Israaʼel, iddoon ati jiraattu akkam miidhaga! ");
INSERT INTO gaz_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","“Isaan akkuma sulula diriiraa, akkuma iddoo biqiltuu kan afaan lagaa, akkuma argeessa Waaqayyo dhaabee, akkuma birbirsaa qarqara bishaanii ti. ");
INSERT INTO gaz_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","Okolee isaa keessaa bishaantu lolaʼa; sanyiin isaa bishaan baayʼee argata. “Mootiin isaa Agaag caala; mootummaan isaa ni kabajama. ");
INSERT INTO gaz_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","“Waaqayyo Gibxii isa baase; inni jabina akka jabina gafarsaa qaba. Inni saba diinota isaa taʼe nyaata; lafee isaanii ni caccabsa; xiyya ofii isaatiin isaan waraana. ");
INSERT INTO gaz_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","Inni akkuma leencaa ciiseera; akkuma leenca dhalaas ciiseera; eenyutu isa dammaqsa? “Warri si eebbisan haa eebbifaman; warri si abaaranis haa abaaraman!” ");
INSERT INTO gaz_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Baalaaq Balaʼaamitti aare. Innis harka ofii isaa walitti rurrukutee Balaʼaamiin akkana jedhe; “Ani akka ati diina koo abaartuufan si waammadhe; ati kunoo yeroo sadan kana isaan eebbifte. ");
INSERT INTO gaz_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Amma dafii asii deemii mana keetti gali! Ani ulfina guddaa siif nan kenna jedheen ture; amma garuu Waaqayyo akka ati ulfina hin arganne si godheera.” ");
INSERT INTO gaz_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Balaʼaamis Baalaaqiin akkana jedhe; “Ani ergamoota ati natti ergite sanatti akkana jedheen hime mitii? ");
INSERT INTO gaz_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‘Utuu Baalaaq masaraa meetii fi warqeen guutame sana naaf kennee iyyuu, ani waanuma Waaqayyo jedhe qofan dubbadha malee ajaja Waaqayyootiin alatti waan yaada koo gaarii yookaan hamaa tokko iyyuu hojjechuu hin dandaʼu.’ ");
INSERT INTO gaz_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Kunoo ani amma saba kootti nan deebiʼa; garuu mee kottu ani waan sabni kun bara dhufu keessa saba keetiif godhu sin beeksisaa.” ");
INSERT INTO gaz_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Inni akkana jedhee ergaa isaa dubbate: Ergaa Balaʼaam ilma Beʼoor, ergaa nama iji isaa sirriitti arguu, ");
INSERT INTO gaz_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","ergaa nama dubbii Waaqaa dhagaʼuu kan beekumsa Waaqa Waan Hundaa Olii qabu kan Waaqa Waan Hunda Dandaʼu irraa mulʼata argu kan kufee diriiruu, iji isaas kan banamu sanaa: ");
INSERT INTO gaz_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","“Ani isa nan arga; garuu amma miti; ani isa nan ilaala; garuu dhiʼootti miti. Yaaqoob keessaa urjiin tokko ni baʼa; Israaʼel keessaa bokkuun tokko ol kaʼa. Inni adda warra Moʼaab, buqqee mataa ilmaan Seet hundaas ni caccabsa. ");
INSERT INTO gaz_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edoom ni moʼatama; Seeʼiir, diinni isaa ni moʼatama; Israaʼel garuu jabaachaa deema. ");
INSERT INTO gaz_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Yaaqoob keessaa bulchaan tokko ni kaʼa; warra magaalaa sana keessatti lubbuudhaan hafanis ni barbadeessa.” ");
INSERT INTO gaz_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Ergasiis Balaʼaam Amaaleqin argee akkana jedhee ergaa ofii isa dubbate: “Amaaleq saboota keessaa kan jalqabaa ture; dhumni isaa garuu barbadaaʼuu dha.” ");
INSERT INTO gaz_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Ergasii Qeenota argee akkana jedhee ergaa ofii isaa itti dubbate: “Iddoon ati jiraattu jabaa dha; manni kees kattaa keessatti ijaarame; ");
INSERT INTO gaz_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","taʼus isin warri Qeenotaa, gaafa Asoor isin boojiʼu ni baddu.” ");
INSERT INTO gaz_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Innis akkana jedhee ergaa isaa itti dubbate: “Wayyoo! Yeroo Waaqayyo waan kana hojjetu eenyutu jiraachuu dandaʼa? ");
INSERT INTO gaz_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Dooniiwwan qarqara Kitiim irraa ni dhufu; isaanis Asoorii fi Eeberin ni qabatu; garuu isaanis ni barbadeeffamu.” ");
INSERT INTO gaz_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Ergasii Balaʼaam kaʼee mana ofii isaatti deebiʼe; Baalaaq immoo karaa ofii isaa qajeele. ");
INSERT INTO gaz_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israaʼeloonni yeroo Shixiim keessa turanitti dhiironni isaanii dubartoota Moʼaab wajjin sagaagaluu jalqaban. ");
INSERT INTO gaz_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Dubartoonni kunneenis gara qalma waaqota isaaniitti saba sana afeerraan, sabni sun qalma sana nyaatee waaqota sanaaf sagade. ");
INSERT INTO gaz_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Israaʼel Baʼaal Pheʼoor duukaa buʼe. Dheekkamsi Waaqayyoos isaanitti bobaʼe. ");
INSERT INTO gaz_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Waaqayyo Museedhaan akkana jedhe; “Akka dheekkamsi Waaqayyoo jabaan sun saba Israaʼel irraa deebiʼuuf, hangafoota saba sanaa hunda fuudhiitii guyyaa adiidhaan fuula Waaqayyoo duratti isaan fannisi.” ");
INSERT INTO gaz_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Museen abbootii murtii Israaʼeliin, “Tokkoon tokkoon keessan namoota keessan kanneen Baʼaal Pheʼoor duukaa buʼan fixaa” jedhe. ");
INSERT INTO gaz_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Kunoo namichi Israaʼel tokko utuma isaan balbala dunkaana wal gaʼii duratti booʼaa jiranuu fuula Museetii fi fuula waldaa Israaʼel guutuu duratti dubartii Midiyaan tokko gara maatii ofii isaatti fidate. ");
INSERT INTO gaz_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Fiinehaas ilmi Eleʼaazaar ilma Aroon lubichaa waan kana arginaan waldaa sana keessaa baʼee eeboo harkatti qabatee ");
INSERT INTO gaz_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","namicha Israaʼel sana duukaa buʼee dunkaana seene; namicha Israaʼelii fi dubartittiis walitti waraanee dhagna isheetti fullaase. Akkasiin dhaʼichi Israaʼelitti dhufe sun ni dhowwame. ");
INSERT INTO gaz_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Garuu baayʼinni namoota dhaʼicha sanaan dhumanii 24,000 gaʼee ture. ");
INSERT INTO gaz_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Waaqayyos Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","“Fiinehaas ilmi Eleʼaazaar ilma Aroon lubicha sanaa dheekkamsa koo Israaʼeloota irraa deebiseera; inni akka ani hinaaffaa kootiin isaan hin balleessineef, akkuma ani ulfina kootiif isaan gidduutti hinaafu sana innis hinaafeeraatii. ");
INSERT INTO gaz_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Kanaafuu kunoo akka ani kakuu koo kan nagaa isa wajjin godhadhu itti naaf himi. ");
INSERT INTO gaz_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Sababii inni ulfina Waaqa isaatiif hinaafee Israaʼelootaaf araara buuseef, innii fi sanyiin isaa kakuu lubummaa kan bara baraa qabaatu.” ");
INSERT INTO gaz_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Maqaan namicha Israaʼel kan dubartii Midiyaan wajjin ajjeefame sanaa Zimrii ilma Saaluu ti; innis hoogganaa maatii Simiʼoon. ");
INSERT INTO gaz_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Maqaan dubartii Midiyaan kan ajjeefamte sanaa Kozbii intala Zuuri hangafa maatii Midiyaan tokkoo ti. ");
INSERT INTO gaz_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","“Midiyaanota akka diinaatti ilaaliitii ajjeesi; ");
INSERT INTO gaz_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","kunis waan isaan sababii Pheʼooriitii fi obboleettii isaanii Kozbii intala hoogganaa warra Midiyaan, dubartii guyyaa sababii Pheʼooriitiin dhaʼichi dhufe sana ajjeefamte sanaa irratti isin gowwoomsan sana akka diinaatti isin ilaalaniif.” ");
INSERT INTO gaz_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Dhaʼicha sana booddee Waaqayyo Musee fi Eleʼaazaar ilma Aroon lubichaatiin akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","“Waldaa saba Israaʼel warra umuriin isaanii waggaa digdamaa fi hammasii ol taʼe kanneen loltoota Israaʼel keessa tajaajiluu dandaʼan hunda maatii maatiidhaan lakkaaʼaa.” ");
INSERT INTO gaz_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Musee fi Eleʼaazaar lubichi dirreewwan Moʼaab irratti, Yordaanos biratti, Yerikoo gamatti akkana jedhanii isaan wajjin dubbatan; ");
INSERT INTO gaz_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","“Akkuma Waaqayyo Musee ajajetti namoota umuriin isaanii waggaa digdamaatii fi hammasii olii lakkaaʼaa.” ");
INSERT INTO gaz_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Ilmaan Ruubeen ilma Israaʼel hangaftichaa: karaa Henookiitiin, balbala Hanookotaa; karaa Faluutiin, balbala Faluuwotaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","karaa Hezrooniitiin, balbala Asroonotaa; karaa Karmiitiin, balbala Karmootaa. ");
INSERT INTO gaz_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","Jarri kunneen balbalawwan Ruubeen; baayʼinni isaaniis 43,730 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ilmi Faluus Eliiyaab; ");
INSERT INTO gaz_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ilmaan Eliiyaabis Nemuuʼeel, Daataanii fi Aberoon. Daataanii fi Abiiraam kunneen qondaaltota waldaa kanneen Musee fi Aroonitti fincilanii dha; isaan yeroo Qooraahii fi duukaa buutonni isaa Waaqayyotti fincilan sanas achi keessa turan. ");
INSERT INTO gaz_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Laftis afaan banattee Qooraahii fi isaan illee liqimsite; warri garee Qooraahi immoo yeroo ibiddii namoota 250 fixe sana dhuman. Isaanis mallattoo namoonni ittiin of eeggatan taʼan. ");
INSERT INTO gaz_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Ilmaan Qooraahi garuu hin duune. ");
INSERT INTO gaz_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Ilmaan Simiʼoon akkuma balbala balbala isaaniitti kanneenii dha: karaa Nemuuʼeel, balbala Nemuuʼeelotaa; karaa Yaamiin, balbala Yaamiinotaa; karaa Yaakiin, balbala Yaakiinotaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","karaa Zeraan, balbala Zerootaa; karaa Shaawul, balbala Shaawulootaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","Jarri kunneen balbalawwan Simiʼoonii ti; isaanis namoota 22,200 turan. ");
INSERT INTO gaz_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Ilmaan Gaad akkuma balbala balbala isaaniitti kanneenii dha: karaa Zefoon, balbala Zefoonotaa; karaa Hagii, balbala Hagootaa; karaa Shuunii, balbala Shuunotaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","karaa Oznii, balbala Oznootaa; karaa Eerii, balbala Eerotaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","karaa Arood, balbala Aroodotaa; karaa Ariʼeel, balbala Ariʼeelotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","Jarri kunneen balbalawwan Gaadii ti; baayʼinni isaaniis 40,500 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Eerii fi Oonaan ilmaan Yihuudaa ti; isaan garuu Kanaʼaan keessatti duʼan. ");
INSERT INTO gaz_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Ilmaan Yihuudaa akkuma balbala balbala isaaniitti kanneenii dha: karaa Sheelaa, balbala Sheelaanotaa; karaa Faares, balbala Faaresotaa; karaa Zaaraa, balbala Zaarotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Ilmaan Faaresis kanneenii dha: karaa Hezroon, balbala Hezroonotaa; karaa Hamuul, balbala Hamuulotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","Jarri kunneen balbalawwan Yihuudaa ti; baayʼinni isaaniis 76,500 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Ilmaan Yisaakor akkuma balbala balbala isaaniitti kanneenii dha: karaa Toolaa, balbala Toolotaa; karaa Fuwaa, balbala Fuuwotaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","karaa Yaashuub, balbala Yaashuubotaa; karaa Shimroon, balbala Shimroonotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","Jarri kunneen balbalawwan Yisaakor; baayʼinni isaaniis 64,300 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Ilmaan Zebuuloon akkuma balbala balbala isaaniitti kanneenii dha: karaa Sered, balbala Seredootaa; karaa Eeloon, balbala Eeloonotaa; karaa Yahiliʼeel, balbala Yahiliʼeelotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","Jarri kunneen balbalawwan Zebuuloon; baayʼinni isaaniis 60,500 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Ilmaan Yoosef akkuma balbala balbala isaaniitti: Minaasee fi Efreem. ");
INSERT INTO gaz_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Ilmaan Minaasee: karaa Maakiir, balbala Maakiirotaa; Maakiir kun abbaa Giliʼaad; karaa Giliʼaad, balbala Giliʼaadotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Ilmaan Giliʼaad isaan kanneenii dha: karaa Iiʼezer, balbala Iiʼezerootaa; karaa Heleq, balbala Heleqootaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","karaa Asriʼeel, balbala Asriiʼeelotaa, karaa Sheekem, balbala Sheekemotaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","karaa Shemiidaa, balbala Shemiidaa; karaa Heefer, balbala Heeferotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelofehaad ilmi Heefer ilmaan hin qabu ture; inni intallan qofa qaba ture; maqaan isaaniis Mahilaa, Nohii, Hoglaa, Miilkaa fi Tiirzaa dha. ");
INSERT INTO gaz_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Jarri kunneen balbalawwan Minaasee ti; baayʼinni isaaniis 52,700 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Ilmaan Efreem akkuma balbala balbala isaaniitti kanneenii dha: karaa Shuutelaa, balbala Shuutelootaa; karaa Beker, balbala Bekerotaa; karaa Taahan, balbala Taahanotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Ilmaan Shuutelaa isaan kanneenii dha: karaa Eeraan, balbala Eeraanotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","Jarri kunneen balbalawwan Efreem; baayʼinni isaaniis 32,500 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Ilmaan Beniyaam akkuma balbala balbala isaaniitti kanneenii dha: karaa Belaa, balbala Belaaʼotaa; karaa Ashbeel, balbala Asbeelotaa; karaa Ahiiraam, balbala Ahiiraamotaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","karaa Shefuufaami, balbala Shefuufaamotaa; karaa Huufaam, balbala Huufaamotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Ilmaan Belaa, karaa Ardii fi Naʼamaan: karaa Ardii, balbala Ardootaa; karaa Naʼamaan, balbala Naʼamaanotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Jarri kunneen balbalawwan Beniyaam; baayʼinni isaaniis 45,600 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Ilmaan Daan akkuma balbala balbala isaaniitti kanneenii dha: karaa Shuuhaam, balbala Shuuhaamotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Isaan hundinuu balbalawwan Shuuhaamotaa ti; baayʼinni isaaniis 64,400 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Ilmaan Aasheer akkuma balbala balbala isaaniitti kanneenii dha: karaa Yimnaa, balbala Yuumnootaa; karaa Yishwii, balbala Yishwiiyotaa; karaa Beriiyaa, balbala Beriiyootaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","karaa ilmaan Beriiyaa immoo: karaa Hebeer, balbala Hebeerotaa; karaa Malkiiʼeel, balbala Malkiiʼeelotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Aasheer intala Seraa jedhamtu tokko qaba ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Jarri kunneen balbalawwan Aasheer; baayʼinni isaaniis 53,400 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Ilmaan Niftaalem akkuma balbala balbala isaaniitti kanneenii dha: karaa Yahizeel, balbala Yahizeelotaa, karaa Guunii, balbala Guunotaa; ");
INSERT INTO gaz_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","karaa Yeexer, balbala Yeexirotaa; karaa Shiileem, balbala Shiileemotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Jarri kunneen balbalawwan Niftaalem; baayʼinni isaaniis 45,400 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Walumaa galatti baayʼinni dhiira Israaʼel 601,730 ture. ");
INSERT INTO gaz_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","“Biyyi sun akkuma baayʼina maqaa namaatti dhaala taʼee isaan kanneeniif haa qoodamu. ");
INSERT INTO gaz_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Balbala guddaadhaaf dhaala guddaa, balbala xinnaadhaaf immoo dhaala xinnaa kenni; tokkoon tokkoon balbalaa akkuma baayʼina namoota galmeeffamaniitti dhaala isaa haa argatu. ");
INSERT INTO gaz_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Garuu biyyi sun ixaadhaan haa qoqoodamtu. Isaanis akkuma maqaawwan gosoota abbootii isaaniitti ni dhaalu. ");
INSERT INTO gaz_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Tokkoon tokkoon dhaala sanaa garee guddaa fi garee xinnaa gidduutti ixaadhaan haa qoodamu.” ");
INSERT INTO gaz_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Lewwonni balbala balbalaan lakkaaʼaman kanneenii dha: karaa Geershoon, balbala Geershoonotaa; karaa Qohaati, balbala Qohaatotaa; karaa Meraarii, balbala Meraarotaa ti. ");
INSERT INTO gaz_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","Jarri kunneenis balbalawwan Lewwotaa ti: balbala Liibnotaa, balbala Kebroonotaa, balbala Mahelootaa, balbala Muusotaa, balbala Qooraahotaa. Qohaati abbaa Amraam; ");
INSERT INTO gaz_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","maqaan niitii Amraam Yookebeed. Isheen intala Lewwii kan biyya Gibxitti Lewwiif dhalattee dha. Amraamiifis Aroon, Musee fi obboleettii isaanii Miiriyaam deesse. ");
INSERT INTO gaz_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aroon abbaa Naadaab, Abiihuu, Eleʼaazaarii fi Iitaamaar. ");
INSERT INTO gaz_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Naadaabii fi Abiihuu garuu yeroo ibidda hin eeyyamamin fuula Waaqayyoo duratti dhiʼeessan sana duʼan. ");
INSERT INTO gaz_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Dhiironni umuriin isaanii jiʼa tokkoo fi hammasii ol taʼe kanneen lakkaaʼaman hundi 23,000 turan. Isaanis sababii gidduu isaaniitti dhaala hin argatiniif Israaʼeloota kaan wajjin hin lakkaaʼamne. ");
INSERT INTO gaz_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Isaan kunneen warra yeroo Musee fi Eleʼaazaar lubichi dirreewwan Moʼaab irratti, Yordaanos biratti, Yerikoo gamatti Israaʼeloota lakkaaʼan sana lakkaaʼamanii dha. ");
INSERT INTO gaz_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Namoota karaa Museetii fi Aroon lubichaan Gammoojjii Siinaa keessatti lakkaaʼaman keessaa namni tokko iyyuu isaan gidduu hin turre. ");
INSERT INTO gaz_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Sababii Waaqayyo waaʼee isaanii, “Isaan Gammoojjii keessatti ni dhumu” jedhee dubbatee tureef, Kaaleb ilma Yefunee fi Iyyaasuu ilma Nuuni malee isaan keessaa namni tokko iyyuu hin hafne. ");
INSERT INTO gaz_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Balbala Minaasee ilma Yoosef keessaas intallan Zelofehaad ilma Heefer, ilma Giliʼaad, ilma Maakiirii fi ilma Minaaseetu dhiʼaate. Maqaan intallan sanaas Mahilaa, Nohii, Hoglaa, Miilkaa fi Tiirzaa dha. ");
INSERT INTO gaz_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Isaanis balbala dunkaana wal gaʼii dura, fuula Musee fi Eleʼaazaar lubichaa dura, fuula hooggantootaatii fi waldaa hundaa dura dhaabatanii akkana jedhan; ");
INSERT INTO gaz_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","“Abbaan keenya Gammoojjii keessatti duʼe. Inni hooggantoota Qooraahi kanneen Waaqayyotti fincilan sana keessa hin turre. Garuu inni cubbudhuma ofii isaatiin duʼe. Ilmaanis hin qabu ture. ");
INSERT INTO gaz_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Maaliif maqaan abbaa keenyaa sababii inni ilma hin qabneef balbala isaa keessaa bada? Firoota abbaa keenyaa gidduutti dhaala nuu kenni.” ");
INSERT INTO gaz_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Museen dubbii isaanii sana fuula Waaqayyoo duratti dhiʼeesse; ");
INSERT INTO gaz_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Waaqayyos akkana jedheen; ");
INSERT INTO gaz_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","“Wanni intallan Zelofehaad jedhan kun sirrii dha. Atis firoota abbaa isaanii gidduutti dhaala kenniif; dhaala abbaa isaaniis isaaniif dabarsi. ");
INSERT INTO gaz_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","“Israaʼelootaan akkana jedhi; ‘Yoo namni utuu ilma hin dhalchin duʼe, dhaala isaa intala isaatiif dabarsaa. ");
INSERT INTO gaz_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Yoo inni intalas qabaachuu baate dhaala isaa obboloota isaatiif kennaa. ");
INSERT INTO gaz_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Yoo inni obboloota qabaachuu baate dhaala isaa obboloota abbaa isaatiif kennaa. ");
INSERT INTO gaz_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Yoo abbaan isaa obboloota qabaachuu baate immoo dhaala isaa balbala isaa keessaa fira aanteef kennaa; firri sun haa dhaalu. Kunis akkuma Waaqayyo Musee ajaje sanatti saba Israaʼeliif sirna seera qabeessa haa taʼu.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Waaqayyo Museedhaan akkana jedhe; “Tulluu Abaariim kanatti ol baʼiitii biyya ani saba Israaʼeliif kenne ilaali. ");
INSERT INTO gaz_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Erga biyya sana argitee booddee atis akkuma obboleessa kee Aroon gara saba keetiitti walitti qabamta; ");
INSERT INTO gaz_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","yeroo waldaan Gammoojjii Siin keessatti natti finciletti isin lachanuus ajaja kootti finciltanii turtaniitii. Isin bishaanota sana biratti fuula isaanii duratti qulqullina koo hin mulʼifne.” Bishaanonni kunneenis bishaanota Mariibaa Qaadesh kan Gammoojjii Siin keessa jiranii dha. ");
INSERT INTO gaz_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Museenis Waaqayyoon akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","“Waaqayyo Waaqni hafuurota nama hundaa waldaa kana irratti nama tokko haa muudu; ");
INSERT INTO gaz_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","namichi kunis akka sabni Waaqayyoo akkuma hoolota tiksee hin qabnee hin taaneef kan isaan dura gad baʼuu fi ol galu, kan gad isaan baasuu fi ol isaan galchuu dha.” ");
INSERT INTO gaz_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Waaqayyo Museedhaan akkana jedhe; “Iyyaasuu ilma Nuuni, namicha hafuurri keessa jiru sana fuudhii harka kee isa irra kaaʼi. ");
INSERT INTO gaz_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Akka inni fuula Eleʼaazaar lubichaatii fi fuula waldaa Israaʼel hundaa dura dhaabatu godhi; fuuluma isaanii durattis isa muudi. ");
INSERT INTO gaz_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Akka sabni Israaʼel hundi isaaf ajajamuuf aangoo kee irraa kenniif. ");
INSERT INTO gaz_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Innis fuula Eleʼaazaar lubichaa kan fuula Waaqayyoo duratti Uriimiidhaan gaafatee murtii isaaf kennuu dura dhaabachuu qaba. Innii fi waldaan Israaʼelootaa hundi ajaja isaatiin baʼu; ajajuma isaatiinis galu.” ");
INSERT INTO gaz_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Museen akkuma Waaqayyo isa ajaje sana godhe. Innis Iyyaasuu geessee akka inni fuula Eleʼaazaar lubichaatii fi fuula waldaa Israaʼel hundaa dura dhaabatu godhe. ");
INSERT INTO gaz_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Ergasiis akkuma Waaqayyo karaa Museetiin ajaje sana harka ofii isaa isa irra kaaʼee isa muude. ");
INSERT INTO gaz_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","“Ajaja kana Israaʼelootaaf kenni; akkanas jedhiin: ‘Aarsaa nyaataa kan ibiddaan anaaf dhiʼeeffamu kan fooliin isaa natti tolu sana yeroo murtaaʼetti naa dhiʼeessuu keessan mirkaneeffadhaa.’ ");
INSERT INTO gaz_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","Akkana isaaniin jedhi; ‘Aarsaan isin ibiddaan Waaqayyoof dhiʼeessitan isa kana: xobbaallaawwan hoolaa lama kanneen umuriin isaanii waggaa tokko tokkootii fi kanneen hirʼina hin qabne aarsaa gubamu kan yeroo hunda guyyuma guyyaan dhiʼeeffamu godhaa dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","Xobbaallaa hoolaa tokko ganama, kaan immoo galgala dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","Kana wajjinis kennaa midhaanii kan daakuu bullaaʼaa iifii tokko irraa harka kudhan keessaa harki tokko zayitii ejersaa kan cuunfamee iinii tokko harka afur keessaa harka tokkoon sukkuumame dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Kunis aarsaa yeroo hunda gubamu kan fooliin isaa toluu fi kan ibiddaan Waaqayyoof dhiʼeeffamu kan Tulluu Siinaa irratti ajajamee dha. ");
INSERT INTO gaz_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Dhibaayyuun tokkoo tokkoo xobbaallaa hoolaa wajjin dhiʼeeffamus dhugaatii cimaa iinii tokko irraa harka afur keessaa harka tokko haa taʼu; dhibaayyuu sanas iddoo qulqulluu keessatti Waaqayyoof dhangalaasi. ");
INSERT INTO gaz_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Xobbaallaa hoolaa kaan immoo akkuma kennaa midhaaniitii fi kan dhibaayyuu wajjin ganama dhiʼeessite sanaa galgalas dhiʼeessi. Kunis aarsaa ibiddaan dhiʼeeffamu kan fooliin isaa Waaqayyotti toluu dha. ");
INSERT INTO gaz_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","“ ‘Guyyaa Sanbataa xobbaallaawwan hoolaa lama kanneen umuriin isaanii waggaa tokko taʼee fi hirʼina hin qabne aarsaa dhibaayyuutii fi kennaa midhaanii akkasumas kennaa midhaanii kan daakuu bullaaʼaa iifii tokko irraa harka kudhan keessaa harki lama zayitiidhaan sukkuumame wajjin dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Kunis aarsaa gubamu kan aarsaa yeroo hunda gubamuu fi dhibaayyuu isaatti dabalamee Sanbata Sanbataan dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","“ ‘Jalqaba jiʼoota keessanii hundatti jiboota loonii lama, korbeessa hoolaa tokko, xobbaallaawwan hoolaa torba kanneen umuriin isaanii waggaa tokko taʼee fi kanneen hirʼina hin qabne aarsaa gubamu godhaatii Waaqayyoof dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Tokkoo tokkoo jiboota loonii wajjin kennaa midhaanii kan daakuu bullaaʼaa iifii tokkoo irraa harka kudhan keessaa harki sadii zayitiidhaan sukkuumame, korbeessa hoolaa sana wajjinis kennaa midhaanii kan daakuu bullaaʼaa iifii tokkoo irraa harka kudhan keessaa harki lama zayitiidhaan sukkuumame dhiʼeeffamuu qaba; ");
INSERT INTO gaz_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","tokkoo tokkoo xobbaallaa hoolaa wajjinis kennaan midhaanii kan daakuu bullaaʼaa iifii tokkoo irraa harka kudhan keessaa harki tokko zayitiidhaan sukkuumame dhiʼeeffamuu qaba. Kunis aarsaa gubamu kan ibiddaan Waaqayyoof dhiʼeeffamuu fi fooliin isaa toluu dha. ");
INSERT INTO gaz_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Tokkoo tokkoo dibicha loonii wajjin dhibaayyuu daadhii wayinii iinii tokkoo irraa walakkaa isaa, tokkoo tokkoo xobbaallaa hoolaa wajjin iinii tokko irraa harka sadii keessaa harka tokko, korbeessa hoolaa sana wajjinis iinii tokko irraa harka afur keessaa harki tokko haa dhiʼeeffamu. Kunis aarsaa gubamu kan waggaa keessatti baatii haaraatti dhiʼeeffamuu dha. ");
INSERT INTO gaz_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Akkasumas aarsaa cubbuutiif korbeessa reʼee tokko Waaqayyoof dhiʼeessaa; innis aarsaa yeroo hunda gubamuu fi dhibaayyuu isaatti dabalamee dhiʼeeffama. ");
INSERT INTO gaz_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","“ ‘Bultii kudha afuraffaa jiʼa jalqabaatti Faasiikaan Waaqayyoo ayyaaneffamuu qaba. ");
INSERT INTO gaz_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Bultii kudha shanaffaa jiʼa kanaatti ayyaanatu jira; isinis guyyaa torba Maxinoo nyaattu. ");
INSERT INTO gaz_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Guyyaa jalqabaatti wal gaʼii qulqulluu qabaadhaa; hojii idilees hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Jiboota loonii lama, korbeessa hoolaa tokko, xobbaallaawwan hoolaa torba kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne aarsaa gubamu godhaatii ibiddaan Waaqayyoof dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Tokkoo tokkoo dibicha loonii wajjinis kennaa midhaanii kan daakuu bullaaʼaa iifii tokkoo irraa harka kudhan keessaa harki sadii zayitiidhaan sukkuumame, korbeessa hoolaa wajjin iifii tokko irraa harka kudhan keessaa harka lama, ");
INSERT INTO gaz_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","xobbaallaawwan hoolaa torban wajjin tokkoo tokkoo xobbaallaa hoolaatiif iifii tokko irraa harka kudhan keessaa harka tokko dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Akkasumas akka araarri isinii buʼuuf korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessi. ");
INSERT INTO gaz_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Kanas aarsaa gubamu kan yeroo hunda ganama ganama dhiʼeeffamutti dabalaatii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Haaluma kanaan nyaata aarsaa ibiddaan dhiʼeeffamuu kan fooliin isaa Waaqayyotti tolu sana bultii torbaaf guyyuma guyyaan dhiʼeessaa; innis aarsaa gubamuu fi dhibaayyuu isaa kan yeroo hunda dhiʼeeffamutti dabalamee haa dhiʼeeffamu. ");
INSERT INTO gaz_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Bultii torbaffaatti wal gaʼii qulqulluu qabaadhaa; hojii idilees hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","“ ‘Ayyaana Torbanootaa keessa guyyaa ayyaana mataa midhaaniitti yeroo kennaa midhaan haaraa Waaqayyoof dhiʼeessitan sana wal gaʼii qulqulluu godhadhaa; hojii idilees hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Jiboota loonii lama, korbeessa hoolaa tokkoo fi xobbaallaawwan hoolaa torba kanneen umuriin isaanii waggaa tokko tokko taʼe aarsaa gubamu kan fooliin isaa Waaqayyotti tolu dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Tokkoo tokkoo dibicha loonii wajjinis kennaan midhaanii kan daakuu bullaaʼaa iifii tokkoo irraa harka kudhan keessaa harki sadii zayitiidhaan sukkuumame haa dhiʼeeffamu. Korbeessa hoolaa wajjin iifii tokko irraa harka kudhan keessaa harki lama, ");
INSERT INTO gaz_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","Xobbaallaawwan hoolaa torban sana wajjinis iifii tokko irraa harka kudhan keessaa harki tokko haa dhiʼeeffamu. ");
INSERT INTO gaz_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Akkasumas akka araarri isinii buʼuuf korbeessa reʼee tokko itti dabalaa dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Aarsaawwan kanneen dhibaayyuu isaanii wajjin, aarsaa gubamu kan yeroo hunda dhiʼeeffamuu fi kennaa midhaan isaatti dabalaatii dhiʼeessaa; horiin sunis kan hirʼina hin qabne taʼuu isaanii mirkaneeffadhaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","“ ‘Guyyaa jalqaba jiʼa torbaffaatti wal gaʼii qulqulluu godhadhaa; gaafas hojii idilee hin hojjetinaa. Guyyaan kun guyyaa isin itti malakata afuuftanii dha. ");
INSERT INTO gaz_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Dibicha loonii tokko, korbeessa hoolaa tokkoo fi xobbaallaawwan hoolaa torba kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne aarsaa gubamu kan fooliin isaa Waaqayyotti tolu dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Dibicha sana wajjinis kennaa midhaanii kan daakuu bullaaʼaa iifii tokkoo irraa harka kudhan keessaa harka sadii zayitiidhaan sukkuumame dhiʼeessaa. Korbeessa hoolaa wajjinis iifii tokko irraa harka kudhan keessaa harka lama, ");
INSERT INTO gaz_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","xobbaallaawwan hoolaa torban sana wajjinis iifii tokko harka kudhan keessaa harka tokko dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Akkasumas akka araarri isinii buufamuuf korbeessa reʼee tokko itti dabalaatii aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Aarsaawwan kunneen akkuma amala isaaniitti aarsaawwan gubaman kanneen jiʼa jiʼattii fi guyyaa guyyaatti dhiʼeeffamanii fi kennaawwan midhaaniittii fi dhibaayyuu isaaniitti dabalamanii dhiʼeeffamanii dha. Isaanis aarsaawwan ibiddaan Waaqayyoof dhiʼeeffaman kanneen fooliin isaanii toluu dha. ");
INSERT INTO gaz_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","“ ‘Bultii kurnaffaa jiʼa torbaffaa kanaatti wal gaʼii qulqulluu godhadhaa; isinis gad of deebisaa; hojii tokko illees hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Dibicha loonii tokko, korbeessa hoolaa tokkoo fi xobbaallaawwan hoolaa torba kanneen umuriin isaanii waggaa tokko tokko taʼe kanneen hundi isaanii hirʼina hin qabne aarsaa gubamu kan fooliin isaa Waaqayyotti tolu godhaa dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Dibicha sana wajjinis kennaa midhaanii kan daakuu bullaaʼaa iifii tokko irraa harka kudhan keessaa harki sadii zayitiidhaan sukkuumamee dhiʼeessaa; korbeessa hoolaa wajjinis iifii tokko irraa harka kudhan keessaa harka lama, ");
INSERT INTO gaz_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","xobbaallaawwan hoolaa torban sana wajjinis iifii tokko irraa harka kudhan keessa harka tokko dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Akkasumas aarsaa cubbuu kan araaraa buusuuf dhiʼeeffamuu fi aarsaa gubamu kan yeroo hunda dhiʼeeffamu, kennaa midhaan isaatii fi dhibaayyuu isaatti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","“ ‘Bultii kudha shanaffaa jiʼa torbaffaatti wal gaʼii qulqulluu godhadhaa; hojii idilee hin hojjetinaa. Waaqayyoofis bultii torba ayyaana ayyaaneffadhaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Jiboota loonii kudha sadii, korbeeyyii hoolaa lamaa fi xobbaallaawwan hoolaa kudha afur kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne aarsaa gubamu kan fooliin isaa Waaqayyotti toluu fi kan ibiddaan dhiʼeeffamu dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Tokkoo tokkoo jiboota kudha sadanii wajjinis kennaa midhaanii kan daakuu bullaaʼaa iifii tokkoo irraa harka kudhan keessaa harki sadii zayitiidhaan sukkuumame dhiʼeessaa; tokkoo tokkoo korbeeyyii hoolaa lamaan sanaa wajjinis iifii tokko irraa harka kudhan keessaa harka lama, ");
INSERT INTO gaz_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","tokkoo tokkoo xobbaallaawwan hoolaa kudha afran sanaa wajjinis iifii tokko irraa harka kudhan keessaa harka tokko dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_16","005_29_16","NUM","29","16","16","Akkasumas aarsaa gubamu kan yeroo hunda dhiʼeeffamu kennaa midhaan isaattii fi dhibaayyuu isaatti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_17","005_29_17","NUM","29","17","17","“ ‘Bultii lammaffaatti jiboota loonii kudha lama, korbeeyyii hoolaa lamaa fi xobbaallaawwan hoolaa kudha afur kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_18","005_29_18","NUM","29","18","18","Akka lakkoobsa murtaaʼeettii fi akkuma amala isaaniitti jiboota loonii, korbeeyyii hoolaatii fi xobbaallaawwan hoolaa sana wajjin kennaa midhaan isaaniitii fi dhibaayyuu isaanii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_19","005_29_19","NUM","29","19","19","Akkasumas aarsaa gubamu kan yeroo hunda dhiʼeeffamu, kennaa midhaan isaattii fi dhibaayyuu isaaniitti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_20","005_29_20","NUM","29","20","20","“ ‘Bultii sadaffaatti jiboota loonii kudha tokko, korbeeyyii hoolaa lamaa fi xobbaallaawwan hoolaa kudha afur kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_21","005_29_21","NUM","29","21","21","Akka lakkoobsa murtaaʼeettii fi akkuma amala isaaniitti jiboota loonii, korbeeyyii hoolaa sanaa fi xobbaallaawwan hoolaa sana wajjinis kennaa midhaan isaaniitii fi dhibaayyuu isaanii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_22","005_29_22","NUM","29","22","22","Akkasumas aarsaa gubamu kan yeroo hunda dhiʼeeffamu, kennaa midhaan isaatii fi dhibaayyuu isaatti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_23","005_29_23","NUM","29","23","23","“ ‘Bultii afuraffaatti jiboota loonii kudhan, korbeeyyii hoolaa lamaa fi xobbaallaawwan hoolaa kudha afur kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_24","005_29_24","NUM","29","24","24","Akka lakkoobsa murtaaʼeettii fi akkuma amala isaaniitti jiboota loonii, korbeeyyii hoolaa sanaa fi xobbaallaawwan hoolaa sana wajjin kennaa midhaan isaaniitii fi dhibaayyuu isaanii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_25","005_29_25","NUM","29","25","25","Akkasumas aarsaa gubamu kan yeroo hunda dhiʼeeffamu, kennaa midhaan isaattii fi dhibaayyuu isaatti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_26","005_29_26","NUM","29","26","26","“ ‘Bultii shanaffaatti jiboota loonii sagal, korbeeyyii hoolaa lamaa fi xobbaallaawwan hoolaa kudha afur kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_27","005_29_27","NUM","29","27","27","Akka lakkoobsa murtaaʼeettii fi akkuma amala isaaniitti jiboota loonii, korbeeyyii hoolaa sanaa fi xobbaallaawwan hoolaa sana wajjin kennaa midhaan isaaniitii fi dhibaayyuu isaanii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_28","005_29_28","NUM","29","28","28","Akkasumas aarsaa gubamu kan yeroo hunda dhiʼeeffamu, kennaa midhaan isaatii fi dhibaayyuu isaatti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_29","005_29_29","NUM","29","29","29","“ ‘Bultii jaʼaffaatti jiboota loonii saddeeti, korbeeyyii hoolaa lamaa fi xobbaallaawwan hoolaa kudha afur kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_30","005_29_30","NUM","29","30","30","Akka lakkoobsa murtaaʼeettii fi akkuma amala isaaniitti jiboota loonii, korbeeyyii hoolaa sanaa fi xobbaallaawwan hoolaa sana wajjin kennaa midhaan isaaniitii fi dhibaayyuu isaanii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_31","005_29_31","NUM","29","31","31","Akkasumas aarsaa gubamu kan yeroo hunda dhiʼeeffamu, kennaa midhaan isaatii fi dhibaayyuu isaatti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_32","005_29_32","NUM","29","32","32","“ ‘Bultii torbaffaatti jiboota loonii torba, korbeeyyii hoolaa lamaa fi xobbaallaawwan hoolaa kudha afur kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_33","005_29_33","NUM","29","33","33","Akka lakkoobsa murtaaʼeettii fi akkuma amala isaaniitti jiboota loonii, korbeeyyii hoolaa sanaa fi xobbaallaawwan hoolaa sana wajjin kennaa midhaaniitii fi dhibaayyuu isaanii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_34","005_29_34","NUM","29","34","34","Akkasumas aarsaa gubamu kan yeroo hunda dhiʼeeffamu, kennaa midhaan isaatii fi dhibaayyuu isaatti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_35","005_29_35","NUM","29","35","35","“ ‘Bultii saddeettaffaatti wal gaʼii qulqulluu godhadhaa; hojii idilee hin hojjetinaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_36","005_29_36","NUM","29","36","36","Dibicha loonii tokko, korbeessa hoolaa tokkoo fi xobbaallaawwan hoolaa torba kanneen umuriin isaanii waggaa tokko tokko taʼee fi kanneen hundi isaanii hirʼina hin qabne aarsaa gubamu kan ibiddaan dhiʼeeffamuu fi kan fooliin isaa Waaqayyotti tolu dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_37","005_29_37","NUM","29","37","37","Akka lakkoobsa murtaaʼeettii fi akkuma amala isaaniitti dibicha loonii, korbeessa hoolaa sanaa fi xobbaallaawwan hoolaa sana wajjin kennaa midhaan isaaniitii fi dhibaayyuu isaanii dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_38","005_29_38","NUM","29","38","38","Akkasumas aarsaa gubamu kan yeroo hunda dhiʼeeffamu, kennaa midhaan isaatii fi dhibaayyuu isaatti dabalaatii korbeessa reʼee tokko aarsaa cubbuutiif dhiʼeessaa. ");
INSERT INTO gaz_vpl VALUES ("NU29_39","005_29_39","NUM","29","39","39","“ ‘Aarsaa keessan kan gubamu, kennaa midhaan keessanii, dhibaayyuu keessanii fi aarsaa keessan kan nagaa, kan wareega keessaniitii fi aarsaa fedhii keessaniin dhiʼeessitanitti dabalaatii ayyaana keessan beekamaa sana irratti Waaqayyoof dhiʼeessaa.’ ” ");
INSERT INTO gaz_vpl VALUES ("NU29_40","005_29_40","NUM","29","40","40","Museenis waan Waaqayyo isa ajaje hunda Israaʼelootatti hime. ");
INSERT INTO gaz_vpl VALUES ("NU30_1","005_30_1","NUM","30","1","1","Museen abbootii gosoota Israaʼeliin akkana jedhe: “Wanni Waaqayyo ajaje kanaa dha: ");
INSERT INTO gaz_vpl VALUES ("NU30_2","005_30_2","NUM","30","2","2","Namni tokko yoo Waaqayyoof waa wareege yookaan akka waan tokko hojjetu ofumaa isaatiin yoo kakate, inni kakuu ofii sana hin cabsin; qooda kanaa waan dubbate hunda guutuu qaba. ");
INSERT INTO gaz_vpl VALUES ("NU30_3","005_30_3","NUM","30","3","3","“Yoo intalli tokko utuma mana abbaa ishee jirtuu Waaqayyoof wareega wareegde yookaan waan tokko gochuudhaaf dirqama keessa seente, ");
INSERT INTO gaz_vpl VALUES ("NU30_4","005_30_4","NUM","30","4","4","yoo abbaan ishees waaʼee wareega ishee yookaan dirqama keessa seenuu ishee dhagaʼee homaa isheen jechuu baate wareegni isheettii fi dirqamni isheen seente sun hundi hin geeddaramu. ");
INSERT INTO gaz_vpl VALUES ("NU30_5","005_30_5","NUM","30","5","5","Yoo abbaan ishee waan kana dhagaʼee ishee dhowwe garuu wareega ishee yookaan kakuu isheen ittiin dirqama seente keessaa tokko iyyuu hin guutamu; sababii abbaan ishee ishee dhowweef Waaqayyo ishee ni bilisoomsa. ");
INSERT INTO gaz_vpl VALUES ("NU30_6","005_30_6","NUM","30","6","6","“Yoo isheen erga wareega seentee booddee yookaan erga dubbii utuu itti hin yaadin dubbatteen dirqama seentee booddee heerumte, ");
INSERT INTO gaz_vpl VALUES ("NU30_7","005_30_7","NUM","30","7","7","dhirsi ishees yoo waan kana dhagaʼee homaa isheen jechuu baate wareegni ishee yookaan dirqamni isheen seente sun hin geeddaramu. ");
INSERT INTO gaz_vpl VALUES ("NU30_8","005_30_8","NUM","30","8","8","Garuu dhirsi ishee yoo yeroo waan kana dhagaʼutti ishee dhowwe, wareega ishee kan dirqama keessa ishee galchu yookaan waadaa isheen utuu itti hin yaadin dirqama keessa of galchite sana ishee jalaa diiga; Waaqayyos ishee bilisoomsa. ");
INSERT INTO gaz_vpl VALUES ("NU30_9","005_30_9","NUM","30","9","9","“Wareegni haadha hiyyeessaa yookaan dubartii dhirsa jalaa baatee, dirqamni isheen seente kam iyyuu ishee qabata. ");
INSERT INTO gaz_vpl VALUES ("NU30_10","005_30_10","NUM","30","10","10","“Yoo dubartiin dhirsa ishee wajjin jiraattu tokko wareega tokko wareegdee yookaan waan tokko gochuudhaaf kakuudhaan dirqama keessa of galchite, ");
INSERT INTO gaz_vpl VALUES ("NU30_11","005_30_11","NUM","30","11","11","dhirsi ishees yoo waan kana dhagaʼee homaa isheedhaan jechuu baate yookaan yoo ishee dhowwuu baate wareegni ishee yookaan waadaan isheen ittiin dirqama keessa of galchite sun hundi hin geeddaramu. ");
INSERT INTO gaz_vpl VALUES ("NU30_12","005_30_12","NUM","30","12","12","Garuu yoo dhirsi ishee yeroo waan kana dhagaʼutti ishee jalaa diige, wareega ishee yookaan waadaa afaan isheetii baʼe keessaa tokko iyyuu hojii irra hin oolu; sababii dhirsi ishee ishee jalaa diigeef, Waaqayyo ishee bilisoomsa. ");
INSERT INTO gaz_vpl VALUES ("NU30_13","005_30_13","NUM","30","13","13","Dhirsi ishee wareega isheen wareegdu yookaan waadaa isheen gad of qabuuf kakuudhaan seentu kam iyyuu fudhachuu yookaan diiguu ni dandaʼa. ");
INSERT INTO gaz_vpl VALUES ("NU30_14","005_30_14","NUM","30","14","14","Garuu yoo dhirsi ishee guyyuma guyyaan homaa isheen jechuu baate, inni wareega ishee yookaan dirqama ishee irra jiru hunda fudhateera jechuu dha. Inni sababii gaafa waaʼee waan kanaa dhagaʼe sana homaa isheedhaan hin jedhiniif waan sana fudhateera. ");
INSERT INTO gaz_vpl VALUES ("NU30_15","005_30_15","NUM","30","15","15","Taʼus inni yoo erga waaʼee waan kanaa dhagaʼee booddee waadaa sana diige yakka isheetti ni gaafatama.” ");
INSERT INTO gaz_vpl VALUES ("NU30_16","005_30_16","NUM","30","16","16","Isaan kunneen seerawwan dhirsaa fi niitii gidduu akkasumas abbaa fi intala isaa kan yeroo ijoollummaa isheetti mana isaa jirtu gidduu jiraachuu qabu kan Waaqayyo Musee ajajee dha. ");
INSERT INTO gaz_vpl VALUES ("NU31_1","005_31_1","NUM","31","1","1","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU31_2","005_31_2","NUM","31","2","2","“Saba Israaʼeliif jedhiitii warra Midiyaan irratti haaloo baʼi. Ergasii ati gara saba keetiitti walitti qabamta.” ");
INSERT INTO gaz_vpl VALUES ("NU31_3","005_31_3","NUM","31","3","3","Kana irratti Museen saba sanaan akkana jedhe; “Akka isaan warra Midiyaanitti duulanii haaloo Waaqayyoo isaan irratti baʼaniif namoota keessan keessaa muraasa hidhachiisaa. ");
INSERT INTO gaz_vpl VALUES ("NU31_4","005_31_4","NUM","31","4","4","Tokkoo tokkoo gosa Israaʼel keessaa nama kuma tokko tokkoo duulatti ergaa.” ");
INSERT INTO gaz_vpl VALUES ("NU31_5","005_31_5","NUM","31","5","5","Akkasitti tokkoo tokkoo gosa Israaʼel keessaa namoonni kumni tokko tokko walitti buufamanii namni kumni kudha lama lolaaf hidhate. ");
INSERT INTO gaz_vpl VALUES ("NU31_6","005_31_6","NUM","31","6","6","Museenis tokkoo tokkoo gosaa keessaa nama kuma tokko tokko Fiinehaas ilma Eleʼaazaar lubichaa isa miʼa iddoo qulqulluutii fi malakata afuufamu harkatti qabate sana wajjin gara waraanaatti erge. ");
INSERT INTO gaz_vpl VALUES ("NU31_7","005_31_7","NUM","31","7","7","Isaanis akkuma Waaqayyo Musee ajaje sanatti warra Midiyaan lolanii dhiira hunda ajjeesan. ");
INSERT INTO gaz_vpl VALUES ("NU31_8","005_31_8","NUM","31","8","8","Mootonni Midiyaan shanan jechuunis Eewii, Reqem, Zuuri, Huurii fi Rebaanis warra ajjeefaman keessa turan. Akkasumas Balaʼaam ilma Beʼoor goraadeedhaan ajjeesan. ");
INSERT INTO gaz_vpl VALUES ("NU31_9","005_31_9","NUM","31","9","9","Israaʼeloonni dubartootaa fi ijoollee warra Midiyaan boojiʼan; loon, bushaayee fi qabeenya isaanii hundas ni saaman. ");
INSERT INTO gaz_vpl VALUES ("NU31_10","005_31_10","NUM","31","10","10","Magaalaawwan Midiyaanonni keessa jiraatan hundaa fi qubatawwan isaanii hunda ibiddaan guban. ");
INSERT INTO gaz_vpl VALUES ("NU31_11","005_31_11","NUM","31","11","11","Isaanis waan boojiʼanii fi waan saaman hunda namaa fi horii illee fuudhanii ");
INSERT INTO gaz_vpl VALUES ("NU31_12","005_31_12","NUM","31","12","12","warra boojiʼan, waan qabatanii fi waan saaman gara iddoo qubata isaanii kan fuula Yerikoo dura, Yordaanos cina, dirreewwan Moʼaab keessa jiruutti gara Museetti, gara Eleʼaazaar lubichaatii fi gara waldaa Israaʼelitti fidan. ");
INSERT INTO gaz_vpl VALUES ("NU31_13","005_31_13","NUM","31","13","13","Museen, Eleʼaazaar lubichii fi hooggantoonni waldaa hundi qubataan alatti isaan simachuuf gad baʼan. ");
INSERT INTO gaz_vpl VALUES ("NU31_14","005_31_14","NUM","31","14","14","Museenis ajajjuuwwan loltootaa jechuunis ajajjuuwwan kumaatii fi ajajjuuwwan dhibbaa kanneen lolaa galanitti aare. ");
INSERT INTO gaz_vpl VALUES ("NU31_15","005_31_15","NUM","31","15","15","Innis akkana jedhee isaan gaafate; “Isin maaliif dubartoota hunda hambiftan? ");
INSERT INTO gaz_vpl VALUES ("NU31_16","005_31_16","NUM","31","16","16","Kunoo warri waan Pheʼooritti taʼe sana keessatti gorsa Balaʼaam fudhachuudhaan akka dhaʼichi saba Waaqayyoo irra buʼuuf Israaʼeloota Waaqayyo irraa deebisan isaan turan. ");
INSERT INTO gaz_vpl VALUES ("NU31_17","005_31_17","NUM","31","17","17","Ammas ilmaan dhiiraa hunda fixaa; akkasumas dubartii dhiira wajjin ciifte hunda ajjeesaa. ");
INSERT INTO gaz_vpl VALUES ("NU31_18","005_31_18","NUM","31","18","18","Garuu dubara takkumaa dhiira wajjin hin ciisin ofii keessaniif hambifadhaa. ");
INSERT INTO gaz_vpl VALUES ("NU31_19","005_31_19","NUM","31","19","19","“Isin keessaa namni nama ajjeese kam iyyuu yookaan namni nama ajjeefame tuqe kam iyyuu bultii torba qubataan ala haa turu. Bultii sadaffaa fi bultii torbaffaattis ofii keessanii fi boojuu keessan qulqulleessaa. ");
INSERT INTO gaz_vpl VALUES ("NU31_20","005_31_20","NUM","31","20","20","Uffata hunda akkasumas waan gogaa irraa, rifeensa reʼee irraa yookaan muka irraa hojjetame hunda qulqulleessaa.” ");
INSERT INTO gaz_vpl VALUES ("NU31_21","005_31_21","NUM","31","21","21","Ergasiis Eleʼaazaar lubichi loltoota duula dhaqanii turan sanaan akkana jedhe; “Qajeelfamni seeraa kan Waaqayyo Museef kenne kanaa dha: ");
INSERT INTO gaz_vpl VALUES ("NU31_22","005_31_22","NUM","31","22","22","Warqee, meetii, naasii, sibiila, qorqorroo, dilaalii fi ");
INSERT INTO gaz_vpl VALUES ("NU31_23","005_31_23","NUM","31","23","23","wanni ibidda irraa hafuu dandaʼu kam iyyuu ibidda keessa dabarfamee qulqullaaʼuu qaba. Garuu wanni sun bishaan qulqullaaʼummaatiinis qulqulleeffamuu qaba. Wanni ibidda irra hafuu hin dandeenye kam iyyuu bishaan sanaan qulqulleeffama. ");
INSERT INTO gaz_vpl VALUES ("NU31_24","005_31_24","NUM","31","24","24","Guyyaa torbaffaatti uffata keessan miiccadhaa; isinis ni qulqulleeffamtu. Ergasii qubatatti galuu dandeessu.” ");
INSERT INTO gaz_vpl VALUES ("NU31_25","005_31_25","NUM","31","25","25","Waaqayyo Museedhaan akkana jedhe; ");
INSERT INTO gaz_vpl VALUES ("NU31_26","005_31_26","NUM","31","26","26","“Ati, Eleʼaazaar lubichii fi abbootiin maatii waldaa sanaa namootaa fi horii boojiʼaman lakkaaʼaa. ");
INSERT INTO gaz_vpl VALUES ("NU31_27","005_31_27","NUM","31","27","27","Boojuu sanas loltoota duula dhaqanii turanii fi waldaa hunda gidduutti iddoo lamatti qoodi. ");
INSERT INTO gaz_vpl VALUES ("NU31_28","005_31_28","NUM","31","28","28","Loltoota duulan irraa namas taʼu loon, harroota, hoolota yookaan reʼoota dhibba shan keessaa tokko Waaqayyoof gibira fuudhi. ");
INSERT INTO gaz_vpl VALUES ("NU31_29","005_31_29","NUM","31","29","29","Gibira sanas walakkaa qooda isaanii irraa fuudhii qooda Waaqayyoo godhiitii Eleʼaazaar lubichatti kenni. ");
INSERT INTO gaz_vpl VALUES ("NU31_30","005_31_30","NUM","31","30","30","Walakkaa qooda saba Israaʼel irraa immoo namas taʼu loon, harroota, hoolota, reʼoota yookaan horii biraa shantama keessaa tokko fuudhiitii Lewwota warra itti gaafatamtoota dunkaana Waaqayyoo taʼanitti kenni.” ");
INSERT INTO gaz_vpl VALUES ("NU31_31","005_31_31","NUM","31","31","31","Musee fi Eleʼaazaar lubichi akkuma Waaqayyo Musee ajaje sana godhan. ");
INSERT INTO gaz_vpl VALUES ("NU31_32","005_31_32","NUM","31","32","32","Wanti boojuu loltoonni fudhatan irraa hafe hoolota 675,000, ");
INSERT INTO gaz_vpl VALUES ("NU31_33","005_31_33","NUM","31","33","33","loon 72,000, ");
INSERT INTO gaz_vpl VALUES ("NU31_34","005_31_34","NUM","31","34","34","harroota 61,000, ");
INSERT INTO gaz_vpl VALUES ("NU31_35","005_31_35","NUM","31","35","35","dubartoonni takkumaa dhiira wajjin hin ciisin 32,000 turan. ");
INSERT INTO gaz_vpl VALUES ("NU31_36","005_31_36","NUM","31","36","36","Qoodni walakkaa kan warra duulaniif qoodame: Hoolota 337,500 ");
INSERT INTO gaz_vpl VALUES ("NU31_37","005_31_37","NUM","31","37","37","keessaa gibirri Waaqayyoo 675 ture; ");
INSERT INTO gaz_vpl VALUES ("NU31_38","005_31_38","NUM","31","38","38","loon 36,000 keessaa gibirri Waaqayyoo 72 ture; ");
INSERT INTO gaz_vpl VALUES ("NU31_39","005_31_39","NUM","31","39","39","harroota 30,500 keessaa gibirri Waaqayyoo 61 ture; ");
INSERT INTO gaz_vpl VALUES ("NU31_40","005_31_40","NUM","31","40","40","nama 16,000 keessaa gibirri Waaqayyoo 32 ture. ");
INSERT INTO gaz_vpl VALUES ("NU31_41","005_31_41","NUM","31","41","41","Museen akkuma Waaqayyo isa ajaje sanatti gibira sana qooda Waaqayyoo godhee Eleʼaazaar lubichatti kenne. ");
INSERT INTO gaz_vpl VALUES ("NU31_42","005_31_42","NUM","31","42","42","Qooda walakkaa kan Museen warra duulan irraa Israaʼelootaaf qoode: ");
INSERT INTO gaz_vpl VALUES ("NU31_43","005_31_43","NUM","31","43","43","Walakkaan boojuu kan waldaa sanaa hoolota 337,500, ");
INSERT INTO gaz_vpl VALUES ("NU31_44","005_31_44","NUM","31","44","44","loon 36,000, ");
INSERT INTO gaz_vpl VALUES ("NU31_45","005_31_45","NUM","31","45","45","harroota 30,500, ");
INSERT INTO gaz_vpl VALUES ("NU31_46","005_31_46","NUM","31","46","46","nama 16,000 ture. ");
INSERT INTO gaz_vpl VALUES ("NU31_47","005_31_47","NUM","31","47","47","Museen akkuma Waaqayyo isa ajaje sanatti walakkaa saba Israaʼel irraa namaa fi horii shantama keessaa tokko fuudhee Lewwota warra itti gaafatamtoota dunkaana Waaqayyoo taʼanitti kenne. ")