﻿USE sofia;
DROP TABLE IF EXISTS sofia.gax_vpl;
CREATE TABLE gax_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gax_vpl WRITE;
INSERT INTO gax_vpl VALUES ("GN1_1","002_1_1","GEN","1","1","1","Waaqi jalqaba ol-gubba'aa fi lafa dade. ");
INSERT INTO gax_vpl VALUES ("GN1_2","002_1_2","GEN","1","2","2","Latti akka hin qadduuyyu; duwwaalle'e. Dukkanti qilee abbaaya'aa irra jirtiiyyu; Ayyaanni Waaqaalle bisaan irra tatacho'aa ture. ");
INSERT INTO gax_vpl VALUES ("GN1_3","002_1_3","GEN","1","3","3","Achiin duuba Waaqi, «Ifi te'uu ti» jedhe. Ifille te'e. ");
INSERT INTO gax_vpl VALUES ("GN1_4","002_1_4","GEN","1","4","4","Waaqi ifi dansaa akka te'e dhagge; inni ifa dukkana irraa gargar baase. ");
INSERT INTO gax_vpl VALUES ("GN1_5","002_1_5","GEN","1","5","5","Waaqi ifaan «Guyyaa», dukkanaan «Halkan» jedhee maqaa baase. Kun guyyaa qaraa ti. ");
INSERT INTO gax_vpl VALUES ("GN1_6","002_1_6","GEN","1","6","6","Waaqi, «Bisaan gad hafee fi bisaan ol hafe akka gargar baasu, gubbaan gombobbittiin teetuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN1_7","002_1_7","GEN","1","7","7","Maarre Waaqi gubbaa gombobbittii godhee, bisaan gubbaa gombobbittii tanaan gad jiru, bisaan gubbaa gombobbittii tanaan ol jiruun gargar baase. Akkasuma teete. ");
INSERT INTO gax_vpl VALUES ("GN1_8","002_1_8","GEN","1","8","8","Waaqi gubbaa gombobbittii «Gubbaa» jedhee maqaa baase. Dhiite, bariitelle'e. Kun guyyaa lammeesso'oo ti. ");
INSERT INTO gax_vpl VALUES ("GN1_9","002_1_9","GEN","1","9","9","Waaqi, «Latti godduun akka mudhattuuf, bisaan gubba'aan jala jiru wolitti dacha'uu ti» jedhe. Akkasuma teete. ");
INSERT INTO gax_vpl VALUES ("GN1_10","002_1_10","GEN","1","10","10","Waaqi, lafa goddu'uun, «Lafa», bisaan wolitti dacha'een, «Abbaayaa» jedhee maqaa baase. Tunille dansaa akka teete dhagge. ");
INSERT INTO gax_vpl VALUES ("GN1_11","002_1_11","GEN","1","11","11","Achiin duuba Waaqi, «Latti biqiltoota adda addaa: mukoota lafa irraa ka akkuma gosa ifiititti midhaan buusuu fi midhaan sanyii ifi keessaa qabu buusu, baachuu ti» jedhe. Akkasuma teete. ");
INSERT INTO gax_vpl VALUES ("GN1_12","002_1_12","GEN","1","12","12","Maarre latti biqiltoota adda addaa: mukoota lafa irraa ka akkuma gosa ifiititti midhaan buusuu fi midhaan sanyii ifi keessaa qabu buusu baache; Waaqi tunille dansaa akka teete dhagge. ");
INSERT INTO gax_vpl VALUES ("GN1_13","002_1_13","GEN","1","13","13","Latti dhiite, bariitelle'e; kun guyyaa sadeesso'oo ti. ");
INSERT INTO gax_vpl VALUES ("GN1_14","002_1_14","GEN","1","14","14","Akkasuma Waaqi, «Guyya'aa fi halkan gargar baasiisaaf gubbaa irratti ifooti jiraatanuu ti! Isaan beessisa yenna'aa, beessisa bonaa-gannaatii fi wogga'aa, ");
INSERT INTO gax_vpl VALUES ("GN1_15","002_1_15","GEN","1","15","15","ifoota gubba'aa te'anee lafa irratti ka ifa kennanu te'anuu ti» jedhe. Tunille akkasuma teete. ");
INSERT INTO gax_vpl VALUES ("GN1_16","002_1_16","GEN","1","16","16","Waaqi ifa gugurdaa lama godhe; ifi guddichi guyyaa, ifi diqqayyichi halkan akka ifu godhe. Urjootalle dade. ");
INSERT INTO gax_vpl VALUES ("GN1_17","002_1_17","GEN","1","17","17","Waaqi akka lafa irratti issanuuf gubbaa irra isaan keye. ");
INSERT INTO gax_vpl VALUES ("GN1_18","002_1_18","GEN","1","18","18","Guyya'aa fi halkan irratti baallii akka isaan qabatanuuf, ifa dukkana irraa gargar akka baasanuuf inni achi isaan keye. Waaqi tunille dansaa akka teete dhagge. ");
INSERT INTO gax_vpl VALUES ("GN1_19","002_1_19","GEN","1","19","19","Latti dhiite, bariitelle'e; kun guyyaa arfeesso'oo ti. ");
INSERT INTO gax_vpl VALUES ("GN1_20","002_1_20","GEN","1","20","20","Achiin duuba Waaqi, «Bisaan lubbuu qabeeyyii adda addaatiin ka guutame te'uu ti; sinbirrootille lafaan gubbaa irra kaatuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN1_21","002_1_21","GEN","1","21","21","Maarre Waaqi bineensa gugurdaa abbaayaa keessaa, lubbuu qabeeyyii bisaan keessa le'anu mara, sinbirroota gosa adda addaa mara dade. Waaqi Tunille dansaa akka teete dhagge. ");
INSERT INTO gax_vpl VALUES ("GN1_22","002_1_22","GEN","1","22","22","Waaqi, «Hora'aa heddadha'a; bisaan abbaaya'aa guuta'a; sinbirrootille lafa irra guuttuu ti» jedhee isaan eebbise. ");
INSERT INTO gax_vpl VALUES ("GN1_23","002_1_23","GEN","1","23","23","Latti dhiite, bariitelle'e; kun guyyaa shaneesso'oo ti. ");
INSERT INTO gax_vpl VALUES ("GN1_24","002_1_24","GEN","1","24","24","Achiin duuba Waaqi, «Latti, dada lubbuu qabanu, gosa adda addaa mara: horii, bineensota lafarra lowanu, bineensa gudda'aa fi diqqaa mara baattuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN1_25","002_1_25","GEN","1","25","25","Waaqi bineensota lafaa akka gosa isaaniititti, horii akka gosa isaaniititti, bineensota lafa irra lowanu mara akka gosa isaaniititti dade. Inni tunille dansaa akka teete dhagge. Tunille akkasuma teete. ");
INSERT INTO gax_vpl VALUES ("GN1_26","002_1_26","GEN","1","26","26","Achiin duuba Waaqi, «Kowa'a, akka bifaa fi akka fakkeenna keennaatitti, nama dannaa ti. Nami qurxummii abbaaya'aa, sinbirroota, horii, bineensota lafa irraa maraa fi bineensota lafa irra lowanu mara irratti baallii qabaatuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN1_27","002_1_27","GEN","1","27","27","Maarre Waaqi akka bifa ifiititti nama dade. Dhiiraa fi dubartii godhee isaan dade. ");
INSERT INTO gax_vpl VALUES ("GN1_28","002_1_28","GEN","1","28","28","Waaqi, «Hora'a, heddadha'a, lafa guuta'a, harkatti isii galfadha'a! Qurxummii abbaaya'aa irratti, sinbirroottan irratti, dada lafa irra munyuuqanu mara irratti baallii qabaatanuu ti» jedhee isaan eebbise. ");
INSERT INTO gax_vpl VALUES ("GN1_29","002_1_29","GEN","1","29","29","Waaqi, «Ani biqiltuu midhaan buuttuu fi midhaan sanyii ifi keessaa qabu buuttu ta lafa irraa duudii akka nyaattanuuf isinii kenneera. ");
INSERT INTO gax_vpl VALUES ("GN1_30","002_1_30","GEN","1","30","30","Akkasuma bineensa maraa fi sinbirroota qilleensaa maraaf, akka sagalee isaaniif te'u marraa fi biqiltuu baalaa isaaniif kenneera» jedhe; tunille akkasuma teete. ");
INSERT INTO gax_vpl VALUES ("GN1_31","002_1_31","GEN","1","31","31","Waaqi waan huje mara ilaale; martinuu guddoo dansaa teete; latti dhiite, bariitelle'e; kun guyyaa jayeesso'oo ti. ");
INSERT INTO gax_vpl VALUES ("GN2_1","002_2_1","GEN","2","1","1","Maarre ol-gubba'aa fi latti, wonni isaan keessa jiranu martille akka kanaan dadamanee muummeffamane. ");
INSERT INTO gax_vpl VALUES ("GN2_2","002_2_2","GEN","2","2","2","Waaqi hujii huje mara hobbaasee, guyyaa torbeesso'oo foorfate. ");
INSERT INTO gax_vpl VALUES ("GN2_3","002_2_3","GEN","2","3","3","Waaqi waan dade mara hobbaasee, guyyaa torbeesso'ootitti waan foorfateef, guyyaa torbeesso'oo san eebbise; woyyoonselle'e. ");
INSERT INTO gax_vpl VALUES ("GN2_4","002_2_4","GEN","2","4","4","Kun dabarsii dadama ol-gubba'aa fi lafaa ti. Yennaa Mootiin Waan Maraa Waaqi ol-gubba'aa fi lafa dade, ");
INSERT INTO gax_vpl VALUES ("GN2_5","002_2_5","GEN","2","5","5","inni lafa irratti bokkeya waan roobisiisee hin jirreef, nami lafa hujulle waan hin jirreef, biqiltuun lafa irra hin jirtuuyyu; wonni tokkolle lattee hin jirtu. ");
INSERT INTO gax_vpl VALUES ("GN2_6","002_2_6","GEN","2","6","6","Teetuu malee, maddi lafa keessaa ol bayee lafa duudii obaasaa ture. ");
INSERT INTO gax_vpl VALUES ("GN2_7","002_2_7","GEN","2","7","7","Achiin duuba Mootiin Waan Maraa Waaqi biyyee lafa irraa fuudhee, nama tolchee, hafuura jiru'uu funnaan isaatitti baafate; namille dada lubbuu qabaatee jiraatu te'e. ");
INSERT INTO gax_vpl VALUES ("GN2_8","002_2_8","GEN","2","8","8","Mootiin Waan Maraa Waaqi karaa aduun baatu Edenitti oorruu dhaabe; nama dade sanille achi keessa keye. ");
INSERT INTO gax_vpl VALUES ("GN2_9","002_2_9","GEN","2","9","9","Mootiin Waan Maraa Waaqi muka ilti namaa halchitu ka adda addaa, ka midhaan isaalle nyaatiisaaf dansaa te'e lafa keessaa lachisiise; muki midhaan isaa nyaatanee jiruu namaa kennu, muki dhibiin ka hantu'uu fi dansaa ittiin beekanulle addee oorru'uu san wodhakkaa jiraayyu. ");
INSERT INTO gax_vpl VALUES ("GN2_10","002_2_10","GEN","2","10","10","Addee oorru'uu san obaasiisaaf Eden keessaa maddi burqe; maddi achii bayee, gargar qoodamee laga afur te'e. ");
INSERT INTO gax_vpl VALUES ("GN2_11","002_2_11","GEN","2","11","11","Maqaan laga qaraa Phiishon; inni lafa Hawiila'aa duudii lafa worqiin jirtutti marsee yaa'a. ");
INSERT INTO gax_vpl VALUES ("GN2_12","002_2_12","GEN","2","12","12","Worqiin lafa sanii dansa'a; uddowa'aa fi dhakaan gatii guddo'oolle achi jiran. ");
INSERT INTO gax_vpl VALUES ("GN2_13","002_2_13","GEN","2","13","13","Maqaan laga lammeesso'oo Giihon; inni lafa Itoophiya'aa marsee yaa'a. ");
INSERT INTO gax_vpl VALUES ("GN2_14","002_2_14","GEN","2","14","14","Maqaan laga sadeesso'oo Xeegros; innille qachaa Asoorii gara baya adu'uutiin yaa'a. Lagi arfeesso'oolle Efraaxiis jedhama. ");
INSERT INTO gax_vpl VALUES ("GN2_15","002_2_15","GEN","2","15","15","Mootiin Waan Maraa Waaqi namicha fuudhee addee oorruu Edenii san akka hujuu fi akka eegu achi keessa keye. ");
INSERT INTO gax_vpl VALUES ("GN2_16","002_2_16","GEN","2","16","16","Mootiin Waan Maraa Waaqi namicha ajajee, «Midhaan muka addee oorruu Edenii kana keessa jiranu mara irraa hin nyaatta; ");
INSERT INTO gax_vpl VALUES ("GN2_17","002_2_17","GEN","2","17","17","midhaan muka nyaatanee hantu'uu fi dansaa ittiin beekanu san irraa ammoo hin nyaatin. Gaafa isa irraa nyaatte ammoo dhuguma hin duuta» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN2_18","002_2_18","GEN","2","18","18","Achiin duuba Mootiin Waan Maraa Waaqi, «Namichi qofii ifii te'uun dansa'aa moti; ani waa'ela qarqaartuu isaa, isaaf hin dada» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN2_19","002_2_19","GEN","2","19","19","Mootiin Waan Maraa Waaqi biyyee irraa bineensotaa fi sinbirroota dadee, maan jedhee akka inni waamu ilaaliisaaf gara namichaa fide; wonni namichi dada lubbuu qabeeyyii ittiin waame duudiin maqaa te'eef. ");
INSERT INTO gax_vpl VALUES ("GN2_20","002_2_20","GEN","2","20","20","Maarre namichi horii maraaf, sinbirroota maraaf, bineensota maraafille maqaa baase; namichaaf ammoo waa'elli qarqaaraan hin dhagganne. ");
INSERT INTO gax_vpl VALUES ("GN2_21","002_2_21","GEN","2","21","21","Maarre Mootiin Waan Maraa Waaqi namichatti hirriiba hamaa buusee, adoo inni rafuu, cinaacha isaa keessaa tokkocha fuudhee, addee cinaachaa san fooniin cufe. ");
INSERT INTO gax_vpl VALUES ("GN2_22","002_2_22","GEN","2","22","22","Mootiin Waan Maraa Waaqi cinaacha namicha keessaa fuudhe san irraa, namittii dadee, gara namichaa fide. ");
INSERT INTO gax_vpl VALUES ("GN2_23","002_2_23","GEN","2","23","23","Achiin duuba namichi, «Amma reefuu, lafeen isi'ii lafee tiyya irraa, foon isi'ii foon kiyya irraa dhaggame; isiin namicha irraa waan dhagganteef, ‹Namittii› jedhantee waamantuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN2_24","002_2_24","GEN","2","24","24","Tanaaf nami abba'aa fi haadha ifii hin lakkisa niitii ifii woliin hin tokkooma; isaanille foon tokko hin te'an. ");
INSERT INTO gax_vpl VALUES ("GN2_25","002_2_25","GEN","2","25","25","Namichaa fi niitiin isaa lamaanuu qullaa jiraniiyyu, te'uu malee wol hin fokkifatanuuyyu. ");
INSERT INTO gax_vpl VALUES ("GN3_1","002_3_1","GEN","3","1","1","Bineensa Mootiin Waan Maraa Waaqi dade mara keessaa bofi irra caalaa malte'e. Inni namitti'iin, «Dhuguma Waaqi, ‹Mukoota oorruu tana keessa jiranu mara irraa hin nyaatina'a› isiniin jedheeraa?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN3_2","002_3_2","GEN","3","2","2","Namittiin bofaan, «Nuuti mukoota addee oorru'uu tana keessa jiranu mara nyaatuu hin dandeenna; ");
INSERT INTO gax_vpl VALUES ("GN3_3","002_3_3","GEN","3","3","3","ammoo muka addee oorru'uu wodhakkaa jiru qofa, Waaqi, ‹Midhaan isaa hin nyaatina'a, hin tuqinaalle'e! Kana yoo gootane hin duutan› jedheera» jette. ");
INSERT INTO gax_vpl VALUES ("GN3_4","002_3_4","GEN","3","4","4","Bofi deebisee, «Hin duutanu. ");
INSERT INTO gax_vpl VALUES ("GN3_5","002_3_5","GEN","3","5","5","Isin midhaan muka sanii yennaa nyaattane, ilti teessan akka banantu, hantu'uu fi dansaa beekiisaan akka Waaqaa akka teetanu, Waaqi waan beekuuf» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN3_6","002_3_6","GEN","3","6","6","Namittiin muki sun nyaatiisaaf dansaa, ilatti ka toluu fi ka nama qaroonsu akka te'e yennaa dhaggite, midhaan isaa fuutee nyaatte; dhirsa isi'ii ka isii woliin jirulle'eef kennite; innille nyaate. ");
INSERT INTO gax_vpl VALUES ("GN3_7","002_3_7","GEN","3","7","7","Achiin duuba ilti lamaaniituu banantee, akka qullaa jiranulle beekane; tanaaf baala harru'uu wolitti hodhanee ifi gollatane. ");
INSERT INTO gax_vpl VALUES ("GN3_8","002_3_8","GEN","3","8","8","Yennaa galgalootte namichii fi namittiin Mootiin Waan Maraa Waaqi addee oorru'uu keessa ideemuun qoonqoo isaa dhage'ane; isaan Mootii Waan Maraa Waaqa duraa mukoota addee oorru'uu san odduu dhokatane. ");
INSERT INTO gax_vpl VALUES ("GN3_9","002_3_9","GEN","3","9","9","Mootiin Waan Maraa Waaqi ammoo namicha waamee, «Eessa jirta?» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN3_10","002_3_10","GEN","3","10","10","Namichille, «Ani addee oorru'uu keessatti qoonqoo teete dhage'ee, qullaa waan jiruuf, sodaadhee dhokadhe» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN3_11","002_3_11","GEN","3","11","11","Waaqi, «Qullaa akka jirtu eentu sitti hime? Midhaan muka ani ‹Hin nyaatin› jedhee si ajaje san nyaattee?» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN3_12","002_3_12","GEN","3","12","12","Namichille deebisee, «Namittii akka na woliin leetuuf ati naaf kennitettuu midhaan muka sanii naaf kenne; anille nyaadhe» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN3_13","002_3_13","GEN","3","13","13","Achiin duuba Mootiin Waan Maraa Waaqi, namitti'iin, «Wonni ati goote kun maan inni?» jedhe. Namittiin, «Bofi na sobee jennaan nyaadhe» jette. ");
INSERT INTO gax_vpl VALUES ("GN3_14","002_3_14","GEN","3","14","14","Mootiin Waan Maraa Waaqi bofaan, «Kana waan gooteef, ati horii maraa fi bineensota mara keessaa ka abaarante hin teeta. Gadhaa keetiin lafa irra hin loota; bara jiruu teetii mara biyyee hin nyaatta. ");
INSERT INTO gax_vpl VALUES ("GN3_15","002_3_15","GEN","3","15","15","Ani si'ii fi namittii tana oddu'utti, sanyii isi'iitii fi sanyii teeti oddu'utti diinummaa hin buusa. Sanyiin isi'ii sun mataa keeti hin butucha; atille jimuu isaa hin iddita» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN3_16","002_3_16","GEN","3","16","16","Namittiille'een, «Yennaa ulfoottutti gaargala sitti hin fakkansa; ciniinsu'uun ijoollee hin deetta. Tanuma keessa fedhii dhirsa keetii hin qabaatta; inni si irratti bulchaa hin te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN3_17","002_3_17","GEN","3","17","17","Namichalle'een, «Ati dubbii niitii teetii waan dhageetteef, midhaan muka ani, ‹Hin nyaatin› jedhee si ajajelle waan nyaatteef, «Latti sababa keetiif ta abaarante hin teeti; atille bara jiruu teetii mara eloo guddo'oon irraa hin nyaatta. ");
INSERT INTO gax_vpl VALUES ("GN3_18","002_3_18","GEN","3","18","18","Latti qore'ee fi qumi'uuduu si'iif hin baachi; atille biqiltuu badda'aa nyaatta. ");
INSERT INTO gax_vpl VALUES ("GN3_19","002_3_19","GEN","3","19","19","Ati biyye'e, deebitee biyyee hin teeta. Biyyee irraa waan dadanteef, gara isi'ii haga deebitutti, danfitee eloottee sagalee teeti hin nyaatta» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN3_20","002_3_20","GEN","3","20","20","Namichi niitiin isaa haadha worra jiraata'aa waan teeteef, maqaa isi'ii «Heewwan» jedhee baase; ");
INSERT INTO gax_vpl VALUES ("GN3_21","002_3_21","GEN","3","21","21","Mootiin Waan Maraa Waaqi Addaamii fi niitii isaatiif gogaa irraa woyaa hujee itti uffise. ");
INSERT INTO gax_vpl VALUES ("GN3_22","002_3_22","GEN","3","22","22","Achiin duuba Mootiin Waan Maraa Waaqi, «Kunoo, nami hantu'uu fi dansaa beekiisaan nu keessaa akka tokkoo te'eera. Ammalle harka ifiitiin hiixatee midhaan muka jiru'uu fuudhee nyaatiisaan, haga bara baraa le'uu hin qabu!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN3_23","002_3_23","GEN","3","23","23","Tanaaf Mootiin Waan Maraa Waaqi addee oorruu Edenii keessaa isa baasee, lafa irraa dadame akka qotu godhe. ");
INSERT INTO gax_vpl VALUES ("GN3_24","002_3_24","GEN","3","24","24","Waaqi nama baaseen duuba, eennulle gara muka jiru'uu akka hin dhikaanneef, addee oorruu Edenii maddii aduun baatuun ergantoota ifii dada ol-gubba'aa ta koola qadduu fi shallaagaa akka ibiddaa bobe'u ka gara mara garagaggalu keye. ");
INSERT INTO gax_vpl VALUES ("GN4_1","002_4_1","GEN","4","1","1","Namichi niitii ifii Heewwan bira geye; isiin ulfoottee ilma deette; «Ani qarqaarsa Waaqaatiin ilma tokko dhaggadheera» jettee maqaa isaa, «Qaayin» baache. ");
INSERT INTO gax_vpl VALUES ("GN4_2","002_4_2","GEN","4","2","2","Ammalle obboleessa isaa «Abeel» deette. Abeel tissee hoole'ee te'ee, Qaayin ammoo qottuu lafaa te'e. ");
INSERT INTO gax_vpl VALUES ("GN4_3","002_4_3","GEN","4","3","3","Gaafa tokko Qaayin midhaan lafaa irraa Mootii Waan Maraatiif kennansa dhikeesse; ");
INSERT INTO gax_vpl VALUES ("GN4_4","002_4_4","GEN","4","4","4","Abeelille buruusota qara dhalatane keessaa qalee, cooma isaanii ciincaa Mootii Waan Maraatiif dhikeesse; Mootiin Waan Maraa Abeelii fi kennansa isaatitti gammade. ");
INSERT INTO gax_vpl VALUES ("GN4_5","002_4_5","GEN","4","5","5","Qaayinii fi kennansa isaatitti ammoo hin gammanne. Maarre Qaayin aaree bobe'ee, mataa buuse. ");
INSERT INTO gax_vpl VALUES ("GN4_6","002_4_6","GEN","4","6","6","Yennaa san Mootiin Waan Maraa Qaayiniin, «Maaf aartee bobeette? Maaf mataa buutte? ");
INSERT INTO gax_vpl VALUES ("GN4_7","002_4_7","GEN","4","7","7","Waan dansaa adoo hujjee jiraattee, fudhatama dhaggattaayyuu motii? Waan dansaa yoo hin hujin ammoo, cubbuun balbala teeti duratti dhokatteerti; ati ammoo isii injifatuu qadda!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN4_8","002_4_8","GEN","4","8","8","Achiin duuba Qaayin obboleessa ifii Abeeliin, «Koy, gara diidaa baanaa» jedhe. Yennaa gara diidaa bayane, Qaayin obboleessa ifii Abeel irratti ka'ee ijjeese. ");
INSERT INTO gax_vpl VALUES ("GN4_9","002_4_9","GEN","4","9","9","Yennaa san Mootiin Waan Maraa, «Obboleessi keeti Abeel eessa jira?» jedhee Qaayin gaafate; inni deebisee, «Ani hin beeku, obboleessa kiyya ka eegu anaa?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN4_10","002_4_10","GEN","4","10","10","Mootiin Waan Maraalle Qaayiniin, «Wonni ati goote kun maan? Dhiigi obboleessa keetii lafa irraa gara kiyya iyyata. ");
INSERT INTO gax_vpl VALUES ("GN4_11","002_4_11","GEN","4","11","11","Lafa dhiiga obboleessa keetii uniisaaf afaan bante irratti, amma ati abaarantee hin ari'anta. ");
INSERT INTO gax_vpl VALUES ("GN4_12","002_4_12","GEN","4","12","12","Yennaa lafa qottu, latti midhaan sii hin baachu; biyya lafaa irra baqataa daaqaleessa hin teeta» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN4_13","002_4_13","GEN","4","13","13","Qaayin deebisee Mootii Waan Maraatiin, «Adabami kiyya ka ani ba'atuu dande'u caala. ");
INSERT INTO gax_vpl VALUES ("GN4_14","002_4_14","GEN","4","14","14","Kunoo, ati adha lafa qotii irraa na ariiteerta; fuula keeti duraa dhokatuu qaba. Ani biyya lafaa irra baqataa daaqaleessa hin te'a; nami na dhagge martinuu na hin ijjeesa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN4_15","002_4_15","GEN","4","15","15","Mootiin Waan Maraa ammoo, «Akkasii moti. Nami tokko yoo si ijjeese, ani dachaa torba haluu isa hin baya» jedheen. Tanaaf Mootiin Waan Maraa nami Qaayin dhagge akka hin ijjeenneef, beessisa itti godhe. ");
INSERT INTO gax_vpl VALUES ("GN4_16","002_4_16","GEN","4","16","16","Achiin duuba Qaayin Mootii Waan Maraa duraa bayee, addee oorruu Edeniitiin gara aduun baatu lafa, «Daaqiisa» jedhantu le'e. ");
INSERT INTO gax_vpl VALUES ("GN4_17","002_4_17","GEN","4","17","17","Qaayin niitii ifii bira geye; isiin ulfoottee ilma deette; maqaan isaalle, «Henok» jedhame; Qaayin qachaa tokko ijaaree, «Henok» jedhee maqaa ilma ifii itti baase. ");
INSERT INTO gax_vpl VALUES ("GN4_18","002_4_18","GEN","4","18","18","Henok, Iraad uumate; Iraad, Mahuyaa'el uumate; Mahuyaa'el, Maatushaa'el uumate; Maatushaa'elille, Laamek uumate. ");
INSERT INTO gax_vpl VALUES ("GN4_19","002_4_19","GEN","4","19","19","Laamek dubartoota lama fuudhe; maqaan takkatti'ii Aada'a, maqaan taanii Xiila'a. ");
INSERT INTO gax_vpl VALUES ("GN4_20","002_4_20","GEN","4","20","20","Aadaan, Yaabaal deette; inni abbaa sanyii worra dunkaana keessa le'anee horii horsiisanee ti. ");
INSERT INTO gax_vpl VALUES ("GN4_21","002_4_21","GEN","4","21","21","Maqaan obboleessa isaalle Yubaal; inni abbaa sanyii worra kiraara dhowaneetii fi suusullee afuufanee ti. ");
INSERT INTO gax_vpl VALUES ("GN4_22","002_4_22","GEN","4","22","22","Xiilaan, Tubaal-Qaayin deette. Inni sibiilaa fi sageettuu irraa meya adda addaa mara huje. Obboleettiin Tubaal-Qaayinii, Naa'ima'a. ");
INSERT INTO gax_vpl VALUES ("GN4_23","002_4_23","GEN","4","23","23","Laamek niitota ifiitiin, «Ee Aada'a, ee Xiila'a! Na dhage'a'a; niitota Laamekii, waan ani jedhu dhage'a'a. Nami yoo na madeesse, dargaggeessi yoo na dirmammeesse ani hin ijjeesa. ");
INSERT INTO gax_vpl VALUES ("GN4_24","002_4_24","GEN","4","24","24","Ka Qaayin ijjeesu dachaa torba haluu ka bayanu yoo te'e, ka na ijjeesu dachaa torbaatamii torba haluu bayan» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN4_25","002_4_25","GEN","4","25","25","Addaam ammalle niitii ifii bira geye; isiille ilma deettee, «Nama Qaayin ijjeese, addee Abeelii Waaqi ilma naa kenne» jettee maqaa isaa, «Sheeti» jettee baatte. ");
INSERT INTO gax_vpl VALUES ("GN4_26","002_4_26","GEN","4","26","26","Sheetille ilma uumate; innille maqaa isaa, «Enoshi» jedhee baase; namooti bara san maqaa Mootii Waan Maraa waammatiisa jalqabane. ");
INSERT INTO gax_vpl VALUES ("GN5_1","002_5_1","GEN","5","1","1","Tun dabarsii sanyii Addaamii ti. Waaqi yennaa ilmaan namaa dade, akka fakkeenna ifiititti isaan dade. ");
INSERT INTO gax_vpl VALUES ("GN5_2","002_5_2","GEN","5","2","2","Dhiiraa fi dubartii dadee, eebbisee, «Nama» jedhee maqaa baase. ");
INSERT INTO gax_vpl VALUES ("GN5_3","002_5_3","GEN","5","3","3","Addaam woggaa dhibbaa fi soddoma yennaa geye, ilma isa fakkaatu, ka bifa isaa qabu uumate; maqaa isaalle, «Sheeti» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("GN5_4","002_5_4","GEN","5","4","4","Sheeti dhalateen duuba, Addaam woggaa dhibba saddeeti le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_5","002_5_5","GEN","5","5","5","Addaam wolumatti woggaa dhibba sagalii fi soddoma le'ee, achiin duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN5_6","002_5_6","GEN","5","6","6","Sheeti dhalatee woggaa dhibbaa fi shanitti Enoshi uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_7","002_5_7","GEN","5","7","7","Enoshi dhalateen duuba, Sheeti woggaa dhibba saddeetii fi torba le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_8","002_5_8","GEN","5","8","8","Sheeti wolumatti woggaa dhibba sagalii fi kudhanii lama le'ee, achiin duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN5_9","002_5_9","GEN","5","9","9","Enoshi dhalatee woggaa sagaltamatti Qayinaan uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_10","002_5_10","GEN","5","10","10","Qayinaan dhalateen duuba, Enoshi woggaa dhibba saddeetii fi kudhanii shan le'ee, ilmaanii fi ijoollee durraa dhibiille uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_11","002_5_11","GEN","5","11","11","Enoshi wolumatti woggaa dhibba sagalii fi shan le'ee, achiin duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN5_12","002_5_12","GEN","5","12","12","Qayinaan dhalatee woggaa torbaatamatti Mahalalel uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_13","002_5_13","GEN","5","13","13","Mahalalel dhalateen duuba, Qayinaan woggaa dhibba saddeetii fi afurtama le'ee, ilmaanii fi ijoollee durraa dhibiille uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_14","002_5_14","GEN","5","14","14","Qayinaan wolumatti woggaa dhibba sagalii fi kudhan le'ee, achiin duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN5_15","002_5_15","GEN","5","15","15","Mahalalel dhalatee woggaa jaatamii shanitti Yaared uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_16","002_5_16","GEN","5","16","16","Yaared dhalateen duuba, Mahalalel woggaa dhibba saddeetii fi soddoma le'ee, ilmaanii fi ijoollee durraa dhibiille uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_17","002_5_17","GEN","5","17","17","Mahalalel wolumatti woggaa dhibba saddeetii fi sagaltamii shan le'ee, achiin duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN5_18","002_5_18","GEN","5","18","18","Yaared dhalatee woggaa dhibba tokkoo fi jaatamii lamatti Henok uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_19","002_5_19","GEN","5","19","19","Henok dhalateen duuba, Yaared woggaa dhibba saddeeti le'ee, ilmaanii fi ijoollee durraa dhibiille uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_20","002_5_20","GEN","5","20","20","Yaared wolumatti woggaa dhibba sagalii fi jaatamii lama le'ee, achiin duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN5_21","002_5_21","GEN","5","21","21","Henok dhalatee woggaa jaatamii shanitti Matusaalaa uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_22","002_5_22","GEN","5","22","22","Matusaalaan dhalateen duuba, Henok woggaa dhibba sad Waaqa woliin le'ee, ilmaanii fi ijoollee durraa dhibiille uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_23","002_5_23","GEN","5","23","23","Henok wolumatti woggaa dhibba sadii fi jaatamii shan le'e. ");
INSERT INTO gax_vpl VALUES ("GN5_24","002_5_24","GEN","5","24","24","Henok bara jiruu ifii mara Waaqa woliin le'e; Waaqi waan isa fudhateef, inni achiin duuba hin dhagganne. ");
INSERT INTO gax_vpl VALUES ("GN5_25","002_5_25","GEN","5","25","25","Matusaalaan dhalatee Woggaa dhibbaa fi saddeettamii torbatti Laamek uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_26","002_5_26","GEN","5","26","26","Laamek dhalateen duuba, Matusaalaan woggaa dhibba torbaa fi saddeettamii lama le'ee, ilmaanii fi ijoollee durraa dhibiille uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_27","002_5_27","GEN","5","27","27","Matusaalaan wolumatti woggaa dhibba sagalii fi jaatamii sagal le'ee, achii duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN5_28","002_5_28","GEN","5","28","28","Laamek dhalatee woggaa dhibbaa fi saddeettamii lamatti ilma uumate; ");
INSERT INTO gax_vpl VALUES ("GN5_29","002_5_29","GEN","5","29","29","Laamek, «Hujii nuuti lafa Waaqi abaare tana irratti hunyu, ta nuuti itti eloonnu irraa nu hin foorfachiisa» jedhee maqaa isaa, «Nohi» baase; ");
INSERT INTO gax_vpl VALUES ("GN5_30","002_5_30","GEN","5","30","30","Nohi dhalateen duuba, Laamek woggaa dhibba shanii fi sagaltamii shan le'ee, ilmaanii fi ijoollee durraa dhibiille uumate. ");
INSERT INTO gax_vpl VALUES ("GN5_31","002_5_31","GEN","5","31","31","Laamek wolumatti woggaa dhibba torbaa fi torbaatamii torba le'ee, achiin duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN5_32","002_5_32","GEN","5","32","32","Nohi dhalatee woggaa dhibba shaniin duuba Seem, Kaamii fi Yaafet uumate. ");
INSERT INTO gax_vpl VALUES ("GN6_1","002_6_1","GEN","6","1","1","Yennaa namooti biyya lafaa irratti heddatuu jalqabanetti, ijoolleen durraalle isaaniif dhalatane. ");
INSERT INTO gax_vpl VALUES ("GN6_2","002_6_2","GEN","6","2","2","Worri «Ilmaan Waaqaa» jedhamanu ijoolleen durraa sun dadansaa akka teete yennaa dhaggane, isaan keessaa akkuma filatanetti niitii fuudhane. ");
INSERT INTO gax_vpl VALUES ("GN6_3","002_6_3","GEN","6","3","3","Achiin duuba Mootiin Waan Maraa, «Namooti ka du'anu waan te'aneef, Ayyaanni Kiyya ka jiruu kennu isaan woliin haga bara baraa hin le'u; isaan woggaa dhibbaa fi diddama qofa le'an» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN6_4","002_6_4","GEN","6","4","4","Bara sanii fi bara saniin duuba, ijoolleen durraa ta namaatii fi worri, «Ilmaan Waaqaa» jedhamanu wolitti makamaneen worri dhalatane worri bineeyyiin jiraniiyyu; isaan bara durii namoota janna hunnaan nama caalanuu fi worra beekkamane. ");
INSERT INTO gax_vpl VALUES ("GN6_5","002_6_5","GEN","6","5","5","Mootiin Waan Maraa hammeenni namaa lafa irratti attam akka bacate, yaadi isaanii yennaa mara marroo hammeennaa akka te'e dhagge. ");
INSERT INTO gax_vpl VALUES ("GN6_6","002_6_6","GEN","6","6","6","Mootiin Waan Maraa lafa irratti nama daduu isaatitti gaddee, guddoo gaabbe. ");
INSERT INTO gax_vpl VALUES ("GN6_7","002_6_7","GEN","6","7","7","Tanaaf Mootiin Waan Maraa, «Isaan daduu kiyyatti waan gaddeef, namoota, horii, bineensota, waan lafa irra munyuuquu fi sinbirroota lafa irraa haxowee hin balleessa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN6_8","002_6_8","GEN","6","8","8","Nohi ammoo Mootii Waan Maraa duratti fudhatama dhaggate. ");
INSERT INTO gax_vpl VALUES ("GN6_9","002_6_9","GEN","6","9","9","Nohi dhaloota san keessatti nama balchaa, ka komii hin qannee fi ka Waaqa woliin ideeme. ");
INSERT INTO gax_vpl VALUES ("GN6_10","002_6_10","GEN","6","10","10","Ilmaan Nohi uumate sadiin Sheem, Kaamii fi Yaafet. ");
INSERT INTO gax_vpl VALUES ("GN6_11","002_6_11","GEN","6","11","11","Yennaa san kolbaan lafa irraa duudiin Waaqa duratti hamoolee teete; lattille hunnaan wolitti ka'iisaan guutante. ");
INSERT INTO gax_vpl VALUES ("GN6_12","002_6_12","GEN","6","12","12","Waaqi biyya lafaa ilaalee, kolbaan marti hammeennaan akka le'iisatti jirtu dhagge. ");
INSERT INTO gax_vpl VALUES ("GN6_13","002_6_13","GEN","6","13","13","Waaqi Nohiin, «Latti hunnaan wolitti ka'iisaan waan guutanteef, ani isaan mara lafa irraa balleessiisaaf murteeffadheera. ");
INSERT INTO gax_vpl VALUES ("GN6_14","002_6_14","GEN","6","14","14","Ati muka dansaa irraa hoboloo guddittii huji; keessa isi'iititti kolloo kolloo baasi! Keessaa fi duuballe'een leyyaa lafa keessaa dhaggamuun duuchi! ");
INSERT INTO gax_vpl VALUES ("GN6_15","002_6_15","GEN","6","15","15","Dheerinna isi'ii meetira dhibba tokkoo fi soddomii sad, badhinna isi'ii meetira diddamii lama, hojjaa meetira kudhanii sad godhi. ");
INSERT INTO gax_vpl VALUES ("GN6_16","002_6_16","GEN","6","16","16","Hoboloo guddittii san heellichoo itti godhi; heellichoo oddu'utti saantimeetira afurtamii afur addee duwwaa lakkisi; cinaa irratti balbala godhi. Hoboloo san hojjaa isi'ii jala, jiddu'uu fi gubbaa tolchii addee saditti gargar qoodi! ");
INSERT INTO gax_vpl VALUES ("GN6_17","002_6_17","GEN","6","17","17","Ani kunoo, gubba'aan jalatti waan lubbuu qabu mara lafa irraa balleessiisaaf, bisaan badi'ii hin fida; wonni lafa irratti lubbuu qabu marti hin bada. ");
INSERT INTO gax_vpl VALUES ("GN6_18","002_6_18","GEN","6","18","18","Ani ammoo si woliin gondooroo hin gondooradha; atii fi niitiin teeti, ilmaan teetii fi niitoleen ilmaan teetii gara hoboloo gudditti'ii seena'a. ");
INSERT INTO gax_vpl VALUES ("GN6_19","002_6_19","GEN","6","19","19","Waan lubbuu qabu maralle, si woliin jiru'uun akka jiraatanu, gosuma gosa keessaa, lama lama tolchii, kormaa fi dhalaa gara hoboloo guddittii sanii seensisi. ");
INSERT INTO gax_vpl VALUES ("GN6_20","002_6_20","GEN","6","20","20","Sinbirroota akkuma gosa gosa isaaniitiin, horii akkuma gosa gosa isaaniitiin, wonni lafa irra lowu akkuma gosa gosa isaaniitiin, gosi martinuu lama lama te'anee, jiru'uun jiraatiisaaf gara keeti dhufanuu ti. ");
INSERT INTO gax_vpl VALUES ("GN6_21","002_6_21","GEN","6","21","21","Ammalle sagalee adda addaa ta atii fi wonni lubbuu qabanu kun marti nyaattanu hoboloo guddittii keessatti tuuli» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN6_22","002_6_22","GEN","6","22","22","Nohi akkuma Waaqi isa ajajetti kana mara huje. ");
INSERT INTO gax_vpl VALUES ("GN7_1","002_7_1","GEN","7","1","1","Mootiin Waan Maraa Nohiin, «Dhaloota kana keessaa ati callaan balchaa akka teete waan dhaggeef, atii fi maatiin teeti gara hoboloo guddittii tanaa seena'a. ");
INSERT INTO gax_vpl VALUES ("GN7_2","002_7_2","GEN","7","2","2","Hori'ii fi bineensa qulqulluu te'ane mara keessaa korma torba torbaa fi dhalaa torba torba, ka qulqulluu hin te'in mara keessalle'ee korma tokko tokkoo fi dhalaa tokko tokko fuudhiitii gara hoboloo gudditti'ii galchi. ");
INSERT INTO gax_vpl VALUES ("GN7_3","002_7_3","GEN","7","3","3","Sinbirrootalle gosuma gosa isaanii keessaa korma torba torbaa fi dhalaa torba torba lafa irratti gosi isaanii akka jiru'uun jiraatanu hobolo'otti galchi. ");
INSERT INTO gax_vpl VALUES ("GN7_4","002_7_4","GEN","7","4","4","Ani guyyaa torbaan duuba guyyaa afurtamaa fi halkan afurtama lafa irratti bokkeenni akka roobu godha; dada lubbuu qabu ka ani dade mara lafa irraa haxowee balleessa!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN7_5","002_7_5","GEN","7","5","5","Nohille kana mara akkuma Mootiin Waan Maraa isa ajaje godhe. ");
INSERT INTO gax_vpl VALUES ("GN7_6","002_7_6","GEN","7","6","6","Yennaa bisaan badi'ii lafatti dhufe san, Nohi nama woggaa dhibba jaa ti. ");
INSERT INTO gax_vpl VALUES ("GN7_7","002_7_7","GEN","7","7","7","Bisaan badi'ii jalaa bayiisaaf Nohii fi niitiin isaa, ilmaan isaatii fi niitoleen isaanii gara hoboloo gudditti'ii seenane. ");
INSERT INTO gax_vpl VALUES ("GN7_8","002_7_8","GEN","7","8","8","Hori'ii fi bineensi qulqulluu te'anee fi qulqulluu hin te'in, sinbirrootille, wonni lafa irra lowulle martinuu, ");
INSERT INTO gax_vpl VALUES ("GN7_9","002_7_9","GEN","7","9","9","lama lama, kormaa fi dhalaan, akka Waaqi ajajetti, gara Nohii dhufanee woliin hoboloo guddittii san seenane. ");
INSERT INTO gax_vpl VALUES ("GN7_10","002_7_10","GEN","7","10","10","Guyyaa torbaan duuba bisaan badi'ii dhufe. ");
INSERT INTO gax_vpl VALUES ("GN7_11","002_7_11","GEN","7","11","11","Kunille bara jiruu Nohii woggaa dhibba jayeesso'oo, ji'a lammeesso'oo, ji'a san keessa guyyaa kudhanii torbeesso'oo te'e; gaafas burqituun golba qile'ee gugurdoon dho'anee, foddaan gubba'aa banante. ");
INSERT INTO gax_vpl VALUES ("GN7_12","002_7_12","GEN","7","12","12","Bokkeenni guyyaa afurtamaa fi halkan afurtama lafa irratti bu'e. ");
INSERT INTO gax_vpl VALUES ("GN7_13","002_7_13","GEN","7","13","13","Guyyuma jedhame san Nohi, niitiin Nohii, ilmaan isaa Seem, Kaam, Yaafetille, niitoleen ilmaan isaa sadiinuu, isa woliin hoboloo guddittii san seenane. ");
INSERT INTO gax_vpl VALUES ("GN7_14","002_7_14","GEN","7","14","14","Bineensoti gosa adda addaa, horiin gosa adda addaa marti, wonni lafa irra lowanu marti, sinbirrooti gosa adda addaa marti, dadi koolaan ka'anu marti, ");
INSERT INTO gax_vpl VALUES ("GN7_15","002_7_15","GEN","7","15","15","dadi hafuura jiru'uu ifi keessaa qaddu marti lama lama te'anee Nohi woliin gara hoboloo guddittii sanii seenane. ");
INSERT INTO gax_vpl VALUES ("GN7_16","002_7_16","GEN","7","16","16","Worri seenanelle, akkuma Waaqi isa ajajetti, kormaa fi dhalaa dada maraatiiyyu; achiin duuba Waaqi balbala hobolo'oo itti cufe. ");
INSERT INTO gax_vpl VALUES ("GN7_17","002_7_17","GEN","7","17","17","Bisaan badi'ii guyyaa afurtama lafa irratti roobuma roobee, lafa irra guutee, hoboloon lafa irraa ol kaate. ");
INSERT INTO gax_vpl VALUES ("GN7_18","002_7_18","GEN","7","18","18","Bisaan lafa irraa guddoo ol ka'ee, hoboloon guddittiin sun bisaan irra deente. ");
INSERT INTO gax_vpl VALUES ("GN7_19","002_7_19","GEN","7","19","19","Bisaan lafa irraa guddoo ol ka'ee, gaarota ol dhedheeraa gubba'aan jala jiranu mara dhosse. ");
INSERT INTO gax_vpl VALUES ("GN7_20","002_7_20","GEN","7","20","20","Bisaan qaccee gaara irraayyuu gara meetira torbaa dabaree dhosse. ");
INSERT INTO gax_vpl VALUES ("GN7_21","002_7_21","GEN","7","21","21","Wonni lubbuu qabaa, dadi lafa irra munyuuqanu martinuu, sinbirrooti, horiin, bineensi, nami martinuu du'ane. ");
INSERT INTO gax_vpl VALUES ("GN7_22","002_7_22","GEN","7","22","22","Wonni lafa irra le'u ka hafuura baafatu marti du'e. ");
INSERT INTO gax_vpl VALUES ("GN7_23","002_7_23","GEN","7","23","23","Waaqi waan dadamee lafa irra le'u, nama, horii, waan lafa irra lowanuu fi sinbirroota haxowee balleesse; isaan lafa irraa haxowamanee badane. Nohii fi waan isa woliin hoboloo guddittii keessa jiru qofattuu hafe. ");
INSERT INTO gax_vpl VALUES ("GN7_24","002_7_24","GEN","7","24","24","Bisaan guyyaa dhibbaa fi shantama gad hin dhidhanne. ");
INSERT INTO gax_vpl VALUES ("GN8_1","002_8_1","GEN","8","1","1","Waaqi ammoo Nohi, hori'ii fi bineensota isa woliin hoboloo guddittii keessa jiranu mara qaabate; inni qilleensa lafa irratti buuse; Bisaanille gad dhidhatuu jalqabe. ");
INSERT INTO gax_vpl VALUES ("GN8_2","002_8_2","GEN","8","2","2","Burqituun golba qile'eetii fi balbalti gubba'aalle cufante; bokkeenni gubba'aalle caamee, ");
INSERT INTO gax_vpl VALUES ("GN8_3","002_8_3","GEN","8","3","3","bisaan laana laana gad dhidhatuu jalqabe. Guyyaa dhibbaa fi shantamaan duuba lafa irraa dhidhate. ");
INSERT INTO gax_vpl VALUES ("GN8_4","002_8_4","GEN","8","4","4","Hoboloon guddittiin sun ji'a torbeesso'oo keessa, guyyaa kudhanii torbeesso'oo, gaara Araaraatii gubbaa dhuttee teette. ");
INSERT INTO gax_vpl VALUES ("GN8_5","002_8_5","GEN","8","5","5","Bisaan haga ji'a kudhaneesso'oo dhidhataatuma deeme; ji'a kudhaneesso'oo keessa guyyaa qaraa, qacceen gaarotaa mudhatte. ");
INSERT INTO gax_vpl VALUES ("GN8_6","002_8_6","GEN","8","6","6","Guyyaa afurtamaan duuba Nohi qowa hobolo'otti baaseeru san banee, ");
INSERT INTO gax_vpl VALUES ("GN8_7","002_8_7","GEN","8","7","7","harraaqessa erge; harraaqessi sun haga bisaan lafa irraa gogutti asii fi achi ka'aa ture. ");
INSERT INTO gax_vpl VALUES ("GN8_8","002_8_8","GEN","8","8","8","Achiin duuba Nohi bisaan lafa irraa akka gad dhidhate ilaaliisaaf saphaliisa erge. ");
INSERT INTO gax_vpl VALUES ("GN8_9","002_8_9","GEN","8","9","9","Ammoo bisaan ammalle lafa duudii irra waan jiruuf, addee itti tee'u dhabee, gara hoboloo guddittii sanii deebi'ee gara isaa dhufe; inni harka ifii gad baasee qabee, hoboloo guddittii sanitti ol seensise. ");
INSERT INTO gax_vpl VALUES ("GN8_10","002_8_10","GEN","8","10","10","Guyyaa torba tureen duuba, ammalle saphaliisa hoboloo guddittii keessaa erge. ");
INSERT INTO gax_vpl VALUES ("GN8_11","002_8_11","GEN","8","11","11","Saphaliisi sun kichuu baala ejersaa afaan ifiititti qabatee, galgaluma san deebi'ee gara isaa dhufe. Akka kanaan Nohi akka bisaan lafa irraa gad dhidhateeru beeke. ");
INSERT INTO gax_vpl VALUES ("GN8_12","002_8_12","GEN","8","12","12","Achiin duuba Nohi guyyaa torba dhibii turee, saphaliisa erge; saphaliisi eega san gara isaa hin deebine. ");
INSERT INTO gax_vpl VALUES ("GN8_13","002_8_13","GEN","8","13","13","Nohi dhalatee woggaa dhibba jaa fi tokkeesso'otti, ji'a tokkeesso'oo keessa, guyyaa tokkeesso'oo, bisaan lafa irraa goge; Nohille heellichoo Hoboloo gudditti'ii irraa kaasee, ilaale; irri lafaalle akka gogeeru dhagge. ");
INSERT INTO gax_vpl VALUES ("GN8_14","002_8_14","GEN","8","14","14","Ji'a lammeesso'oo keessa, guyyaa diddamii torbeesso'ootitti, latti guutumatti godde. ");
INSERT INTO gax_vpl VALUES ("GN8_15","002_8_15","GEN","8","15","15","Achiin duuba Waaqi, Nohiin, ");
INSERT INTO gax_vpl VALUES ("GN8_16","002_8_16","GEN","8","16","16","«Niitii teeti, ijoollee teetii fi niitii ijoollee teetii woliin hoboloo keessaa bayi. ");
INSERT INTO gax_vpl VALUES ("GN8_17","002_8_17","GEN","8","17","17","Dadi lubbuu qabanu ka si woliin jiranu martinuu sinbirrooti, horiin, bineensoti, worri lafa irra lowanu martinuu, lafa irratti horanee akka heddatanu, si woliin akka bayanu godhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN8_18","002_8_18","GEN","8","18","18","Maarre Nohi ijoollee ifii, niitii ifiitii fi niitii ijoollee ifii woliin gad baye. ");
INSERT INTO gax_vpl VALUES ("GN8_19","002_8_19","GEN","8","19","19","Horiin marti, bineensoti marti, sinbirrooti marti, worri lafa irra lowanu marti, akkuma gosa gosa isaaniititti hoboloo guddittii san keessaa gad bayane. ");
INSERT INTO gax_vpl VALUES ("GN8_20","002_8_20","GEN","8","20","20","Nohi addee ciinca'aa Mootii Waan Maraatiif ijaare; horii qulqulluu mara keessaa, sinbirroota qulqulluu mara keessaa addee ciinca'aa san irratti ciincaa dhikeesse. ");
INSERT INTO gax_vpl VALUES ("GN8_21","002_8_21","GEN","8","21","21","Fooleen ciinca'aa sun Mootii Waan Maraa yennaa gammachiitte, Mootiin Waan Maraa gadhaa ifii keessatti, «Ani sababa namaatiif deebi'ee lafa hin abaaru; yaadi isaanii ijoollumma'aanuu hamaa akka te'e ani waan beekuuf, akka amma godhe kana, waan lubbuu qabu lafa irraa ijjumaa deebi'ee hin balleessu. ");
INSERT INTO gax_vpl VALUES ("GN8_22","002_8_22","GEN","8","22","22","«Haga latti tun jirtutti facaasu'uu fi haamuun, qabbanaa fi o'i, bonaa fi ganni, guyya'aa fi halkan, hin dhaabbatanu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN9_1","002_9_1","GEN","9","1","1","Waaqi Nohii fi ilmaan isaa eebbisee, «Hora'aa, heddadha'a, lafa guuta'a! ");
INSERT INTO gax_vpl VALUES ("GN9_2","002_9_2","GEN","9","2","2","Bineensoti lafa irraa marti, sinbirrooti marti, bineensoti lafa irra lowanu marti, qurxummiin abbaaya'aa marti, isin sodaatanee bararaqanuu ti; isaan harka keessanitti kennamaneeran. ");
INSERT INTO gax_vpl VALUES ("GN9_3","002_9_3","GEN","9","3","3","Wonni jiraatee tacho'u martinuu sagalee isiniif te'anuu ti. Akkuma duri biqiltuu magariisa akka sagalee isiniif te'anu kenne, amma waan kana mara sagalee akka isiniif te'anu kenneera. ");
INSERT INTO gax_vpl VALUES ("GN9_4","002_9_4","GEN","9","4","4","Ammoo jiruun dhiiga keessa waan jirtuuf, foon dhiigi keessa jiru ammalle hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("GN9_5","002_9_5","GEN","9","5","5","Ani lubbuu teessan eegiisaaf, dhiiga keessan harka nama nama san ijjeeseetii fi bineensa nama san ijjeesee irraa hin barbaada. ");
INSERT INTO gax_vpl VALUES ("GN9_6","002_9_6","GEN","9","6","6","«Ani Waaqi akka bifa tiyyaatitti, nama waan dadeef, nami dhiiga namaa dhangalaasu dhiigi isaa harka namaatiin hin dhangalaafama. ");
INSERT INTO gax_vpl VALUES ("GN9_7","002_9_7","GEN","9","7","7","«Isin hora'a, heddadha'a, bacadha'aa lafa guuta'a!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN9_8","002_9_8","GEN","9","8","8","Achiin duuba Waaqi Nohii fi ilmaan isaa ta isa woliin jirtuun, ");
INSERT INTO gax_vpl VALUES ("GN9_9","002_9_9","GEN","9","9","9","«Kunoo ani isinii fi sanyii teessan worra isiniin duubaa woliin gondooroo tiyya hin gondoora; ");
INSERT INTO gax_vpl VALUES ("GN9_10","002_9_10","GEN","9","10","10","akkasuma dada lubbuu qabu ka isin woliin jiru mara, sinbirroota mara, horii mara, bineensota mara, waan isin woliin hoboloo guddittii san keessaa bayane mara woliin gondooroo tiyya hin gondoora. ");
INSERT INTO gax_vpl VALUES ("GN9_11","002_9_11","GEN","9","11","11","Ani ijjumaa dada lubbuu qabu bisaan badi'iitiin lafa irraa deebi'ee akka hin balleessineef, bisaan badi'ii ijjumaa deebi'ee lafa akka hin balleessine, ani isin woliin gondooroo tiyya hin gondoora. ");
INSERT INTO gax_vpl VALUES ("GN9_12","002_9_12","GEN","9","12","12","Gondooroo ani isinii fi dada lubbuu qabu ka isin woliin jiruuf, dhaloota dhufu maralle'ee gondoore tanaaf beessisa kana kenna: ");
INSERT INTO gax_vpl VALUES ("GN9_13","002_9_13","GEN","9","13","13","ani hiituu tiyya duumensa keessa keya; hiituun tunille beessisa Gondooroo anaa fi biyyaa lafaa oddu'utti te'e hin teeti. ");
INSERT INTO gax_vpl VALUES ("GN9_14","002_9_14","GEN","9","14","14","Yennaa ani gubbaa duumensaan gollee, hiituun duumensa keessaan mudhattu, ");
INSERT INTO gax_vpl VALUES ("GN9_15","002_9_15","GEN","9","15","15","ani gondooroo tiyya ta isinii fi dada lubbuu qabu mara woliin gondoore hin qaabadha; bisaan badi'ii dada lubbuu qabu mara deebi'ee ijjumaa hin balleessu. ");
INSERT INTO gax_vpl VALUES ("GN9_16","002_9_16","GEN","9","16","16","Yennaa hiituun duumensa keessaan mudhattu, ani isii ilaalee, gondooroo haga bara baraa ta anaa fi dada lubbuu qabu ka lafa irra jiru mara oddu'utti gondoore hin qaabadha» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN9_17","002_9_17","GEN","9","17","17","Waaqi Nohiin, «Beessisi gondooro'oo ka ani ifii fi dada lubbuu qabu ka lafa irra jiru mara oddu'utti gondoore hiituu tana» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN9_18","002_9_18","GEN","9","18","18","Nohii fi ilmaan isaa ta hoboloo guddittii keessaa baate Seem, Kaamii fi Yaafet. Kaam abbaa Kana'aanii ti. ");
INSERT INTO gax_vpl VALUES ("GN9_19","002_9_19","GEN","9","19","19","Isaan sadiin kun ilmaan Nohii ti; kolbaan lafa irraa duudiinuu ilmaan sadiin tana irraa dhutte. ");
INSERT INTO gax_vpl VALUES ("GN9_20","002_9_20","GEN","9","20","20","Nohi, nama lafa qotu, ka woynii dhaabiisa jalqabe. ");
INSERT INTO gax_vpl VALUES ("GN9_21","002_9_21","GEN","9","21","21","Gaafa tokko inni yennaa daadhii woyni'ii unee machowe, qullaa dunkaanii ifii keessa rafe. ");
INSERT INTO gax_vpl VALUES ("GN9_22","002_9_22","GEN","9","22","22","Abbaan Kana'aanii, Kaam, abbaa ifii qullaa jiruun dhaggee, alatti obboleeyyan ifii lamatti hime. ");
INSERT INTO gax_vpl VALUES ("GN9_23","002_9_23","GEN","9","23","23","Achiin duuba Seemii fi Yaafet woyaa fuudhanee gurmuu ifii lamaan irra buufatanee, dudda duubaan deemanee nafa abbaa isaanii qullaa san dhossane; fuulli isaanii irraa waan garagaleeruuf, nafa qullaa abbaa ifii san hin dhaggine. ");
INSERT INTO gax_vpl VALUES ("GN9_24","002_9_24","GEN","9","24","24","Nohi machii yennaa bayyanate, waan ilmi isaa maandhichi isa irratti godhe beekee, ");
INSERT INTO gax_vpl VALUES ("GN9_25","002_9_25","GEN","9","25","25","«Kana'aan ka abaarame te'uu ti; garbicha garboota obboleeyyan ifii te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN9_26","002_9_26","GEN","9","26","26","Nohi ammalle, «Mootiin Waan Maraa Waaqi Seemii, leellifamuu ti; Kana'aan garbicha Seemii te'uu ti. ");
INSERT INTO gax_vpl VALUES ("GN9_27","002_9_27","GEN","9","27","27","Waaqi biyya Yaafetii badhisuu ti! Yaafet dunkaanii Seemii keessa le'uu ti; Kana'aan garbicha Yaafetiille te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN9_28","002_9_28","GEN","9","28","28","Bisaan badi'iitiin duuba Nohi woggaa dhibba sadii fi shantama le'e. ");
INSERT INTO gax_vpl VALUES ("GN9_29","002_9_29","GEN","9","29","29","Inni wolumatti woggaa dhibba sagalii fi shantama le'ee, achiin duuba du'e. ");
INSERT INTO gax_vpl VALUES ("GN10_1","002_10_1","GEN","10","1","1","Ilmaan Nohii, Seem, Kaamii fi Yaafet; bisaan badi'iitiin duuba, isaan sadiin kun ijoollee uumatane; hiddi dhaloota sanyii isaanii kanatti aanee laakkowama. ");
INSERT INTO gax_vpl VALUES ("GN10_2","002_10_2","GEN","10","2","2","Ilmaan Yaafetii: Gomer, Maagoog, Maada'i, Yaawaan, Tubaal, Meshekii fi Tiiraas. ");
INSERT INTO gax_vpl VALUES ("GN10_3","002_10_3","GEN","10","3","3","Ilmaan Gomerii: Ashikenaas, Riifaatii fi Togaarma'a. ");
INSERT INTO gax_vpl VALUES ("GN10_4","002_10_4","GEN","10","4","4","Ilmaan Yaawaanii: Eliishaa, Tarshiish, Kitiimii fi Rodaaniim. ");
INSERT INTO gax_vpl VALUES ("GN10_5","002_10_5","GEN","10","5","5","Worri lafa qarqara abbaayaa Mediteraaniya'aa keessa le'u, sanyii Yaafetii tana irraa dhufane. Isaan akka biyya biyya isaaniititti, akka afaan afaan isaaniititti, akka gosa gosa isaaniititti qoqoodamee worra le'u. ");
INSERT INTO gax_vpl VALUES ("GN10_6","002_10_6","GEN","10","6","6","Ilmaan Kaamii: Kuushi, Misraayiimii, Fuxii fi Kana'aan. ");
INSERT INTO gax_vpl VALUES ("GN10_7","002_10_7","GEN","10","7","7","Sanyiin Kuushii: Saabaa, Hawiilaa, Sabtaa, Ra'ima'aa fi Sabtekaas. Ilmaan Ra'ima'aa: Sheeba'aa fi Dedaan. ");
INSERT INTO gax_vpl VALUES ("GN10_8","002_10_8","GEN","10","8","8","Kuushi Naamrud uumate; Naamrud lafa irratti nama qaraa jabaa lolaan injifataa te'e. ");
INSERT INTO gax_vpl VALUES ("GN10_9","002_10_9","GEN","10","9","9","Inni qarqaarsa Mootii Waan Maraatiin adamsaa jaba'a; tanaaf, namooti, «Mootiin Waan Maraa akka Naamrudii adamsaa jabaa si godhu» jedhan. ");
INSERT INTO gax_vpl VALUES ("GN10_10","002_10_10","GEN","10","10","10","Inni jalqaba qachoota biyya Shiinaarii ka «Baabilon» jedhamee beekkamu keessaa Baabel, Erek, Akaadii fi Kaalne irratti mootii te'e. ");
INSERT INTO gax_vpl VALUES ("GN10_11","002_10_11","GEN","10","11","11","Achi irraa gara biyya Asoorii dhaqee qachoota Nanawwe'ee, Rohobot-Irii fi Kalaa ijaare. ");
INSERT INTO gax_vpl VALUES ("GN10_12","002_10_12","GEN","10","12","12","Akkuma Nanawwe'ee fi Kalaa wodhakka'atti qachaa guddicha Resen ijaare. ");
INSERT INTO gax_vpl VALUES ("GN10_13","002_10_13","GEN","10","13","13","Sanyiin Misraayiimii: Ludiin, Anaamiim, Lehabiim, Naftuhiim, ");
INSERT INTO gax_vpl VALUES ("GN10_14","002_10_14","GEN","10","14","14","Fatrusiim, Kasluhiim ka worri Filisxeemotaa irraa dhaggamee fi Kaftoriim uumate. ");
INSERT INTO gax_vpl VALUES ("GN10_15","002_10_15","GEN","10","15","15","Kana'aan ilma ifii angaficha Sidoonii fi ka itti aanu Heeti uumate. ");
INSERT INTO gax_vpl VALUES ("GN10_16","002_10_16","GEN","10","16","16","Inni ammalle abbaa Yibusootaa, Amoorotaa, Girgaashotaa, ");
INSERT INTO gax_vpl VALUES ("GN10_17","002_10_17","GEN","10","17","17","Hiiwotaa, Arqotaa, Siinotaa, ");
INSERT INTO gax_vpl VALUES ("GN10_18","002_10_18","GEN","10","18","18","Arwaadotaa, Simaarotaa, kamaatotaatiiyyu; duuba irra maatiin Kana'aanii, ");
INSERT INTO gax_vpl VALUES ("GN10_19","002_10_19","GEN","10","19","19","haga meessaa Kana'aanii ka Sidoon irraa gara fuullee Gergariitii haga Gaaza'aatitti, gara fuullee Sodoomii, Gomora'aa, Adima'aatii fi Zebo'iimiitiin haga Laasha'aa faffacaate. ");
INSERT INTO gax_vpl VALUES ("GN10_20","002_10_20","GEN","10","20","20","Sanyiin Kaamii ka maatii maati'iin, afaan afaaniin, lafa lafaan, gosa gosaan qoqoodamane isaan kana. ");
INSERT INTO gax_vpl VALUES ("GN10_21","002_10_21","GEN","10","21","21","Obboleessi angafichi Yaafetii, Seemille, ilmaan uumate; ilmaan Ebeerii marti sanyii isaa ti. ");
INSERT INTO gax_vpl VALUES ("GN10_22","002_10_22","GEN","10","22","22","Ilmaan Seemii: Ilaam, Ashuur, Arfaaksaad, Ludii fi Aaram. ");
INSERT INTO gax_vpl VALUES ("GN10_23","002_10_23","GEN","10","23","23","Ilmaan Aaramii: Uz, Hul, Geterii fi Maash. ");
INSERT INTO gax_vpl VALUES ("GN10_24","002_10_24","GEN","10","24","24","Arfaaksaad, Shalaa uumate; Shalaan, Ebeer uumate; ");
INSERT INTO gax_vpl VALUES ("GN10_25","002_10_25","GEN","10","25","25","Ebeer ilmaan lama uumate; bara tokkochi dhalate latti waan qoqoodanteef, maqaan isaa, «Feleg» jedhame; maqaan obboleessa isaa Yoqxaan. ");
INSERT INTO gax_vpl VALUES ("GN10_26","002_10_26","GEN","10","26","26","Ilmaan Yoqxaan uumate: Almodaad, Sheleef, Hasarmaaweti, Yaaraa, ");
INSERT INTO gax_vpl VALUES ("GN10_27","002_10_27","GEN","10","27","27","Hadoraam, Uzaal, Diqilaa, ");
INSERT INTO gax_vpl VALUES ("GN10_28","002_10_28","GEN","10","28","28","Obaal, Abiimaa'el, Sheebaa, ");
INSERT INTO gax_vpl VALUES ("GN10_29","002_10_29","GEN","10","29","29","Ofiir, Hawiila'aa fi Yobaab; worri kun martinuu ilmaan Yoqxaanii ti. ");
INSERT INTO gax_vpl VALUES ("GN10_30","002_10_30","GEN","10","30","30","Latti isaan keessa le'ane, biyya koobittii gara aduun baatuu Meshaa irraa ka'ee haga Sefariititti badhatti. ");
INSERT INTO gax_vpl VALUES ("GN10_31","002_10_31","GEN","10","31","31","Sanyiin Seemii ka maatii maati'iin, afaan afaaniin, lafa lafaan, gosa gosaan qoqoodamane isaan kana. ");
INSERT INTO gax_vpl VALUES ("GN10_32","002_10_32","GEN","10","32","32","Maatiin ilmaan Nohii, akka dhaloota isaaniitiin, gosa gosa isaaniitiin ka qoqoodamane isaan kana; bisaan badi'iitiin duuba, gosi biyya adda addaa ta lafa irratti faffacaate marti, sanyii ilmaan Nohii irraa dhaggante. ");
INSERT INTO gax_vpl VALUES ("GN11_1","002_11_1","GEN","11","1","1","Bara san kolbaan biyya lafaa duudiin afaan tokkocha dubbatti. ");
INSERT INTO gax_vpl VALUES ("GN11_2","002_11_2","GEN","11","2","2","Isaan gara aduun baatu irraa yennaa godaanane, dirree takka lafa Shiinaariititti dhaqanee achitti qubatane. ");
INSERT INTO gax_vpl VALUES ("GN11_3","002_11_3","GEN","11","3","3","Isaan, «Kowa'a, faara loonnee, akka jabaatu gunnaa» woliin jedhane; addee dhaka'aa faara looba'aa, addee siminto'oo leyyaa biyyee keessaa dhaggamutti fayyadamane. ");
INSERT INTO gax_vpl VALUES ("GN11_4","002_11_4","GEN","11","4","4","Achiin duuba isaan, «Kowa'a, qachaa qacceen xelleephoo isaa ol-gubbaa gewu ijaarrannee, lafa duudii irratti akka hin bittinnoonneef, worra gurraa teena!» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN11_5","002_11_5","GEN","11","5","5","Mootiin Waan Maraa qacha'aa fi xelleephoo ilmaan namaa ijaarane san ilaaliisaaf gad bu'e. ");
INSERT INTO gax_vpl VALUES ("GN11_6","002_11_6","GEN","11","6","6","Inni, «Kunoo, isaan kolbaa takka'a; marti isaaniituu afaan tokkocha dubbatan; kun waan isaan huju'uuf jiranu keessaa ka jalqabaa ti; waan isaan hujiisaaf yaada qabanu keessaa, takkaalle wonni isaan hujuu dadhabanu hin jirtu. ");
INSERT INTO gax_vpl VALUES ("GN11_7","002_11_7","GEN","11","7","7","Kowa'a, gad buunee, akka isaan wolii hin galle, afaan isaanii wol keessa akka makamu goona» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN11_8","002_11_8","GEN","11","8","8","Maarre Mootiin Waan Maraa lafa duudii irra isaan bittinneessee, qachaalle ijaariisa lakkisane. ");
INSERT INTO gax_vpl VALUES ("GN11_9","002_11_9","GEN","11","9","9","Mootiin Waan Maraa achitti afaan biyya lafaa wol keessa akka makamu waan godheef, maqaan addee sanii, «Baabel» jedhamee moggaafame; Mootiin Waan Maraa achi irraa biyya lafaa duudii irra isaan bittinneesse. ");
INSERT INTO gax_vpl VALUES ("GN11_10","002_11_10","GEN","11","10","10","Sanyiin Seemii isaan kana: Bisaan badi'iitiin duuba woggaa lama turee, Seem dhalatee woggaa dhibbatti, ilma ifii Arfaaksaad uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_11","002_11_11","GEN","11","11","11","Arfaaksaad uumateen duuba, Seem woggaa dhibba shan le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_12","002_11_12","GEN","11","12","12","Arfaaksaad dhalatee woggaa soddomii shanitti, Shalaa uumate; ");
INSERT INTO gax_vpl VALUES ("GN11_13","002_11_13","GEN","11","13","13","Shalaan dhalateen duuba, Arfaaksaad woggaa dhibba afurii fi sad le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_14","002_11_14","GEN","11","14","14","Shalaan dhalatee woggaa soddomatti, Ebeer uumate; ");
INSERT INTO gax_vpl VALUES ("GN11_15","002_11_15","GEN","11","15","15","Ebeer dhalateen duuba, Shalaan woggaa dhibba afurii fi sad le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_16","002_11_16","GEN","11","16","16","Ebeer dhalatee woggaa soddomii afuritti, Feleg uumate; ");
INSERT INTO gax_vpl VALUES ("GN11_17","002_11_17","GEN","11","17","17","Feleg dhalateen duuba, Ebeer woggaa dhibba afurii fi soddoma le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_18","002_11_18","GEN","11","18","18","Feleg dhalatee woggaa soddomatti, Re'uu uumate; ");
INSERT INTO gax_vpl VALUES ("GN11_19","002_11_19","GEN","11","19","19","Re'uun dhalateen duuba, Feleg woggaa dhibba lamaa fi sagal le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_20","002_11_20","GEN","11","20","20","Re'uun dhalatee woggaa soddomii lamatti, Seruug uumate; ");
INSERT INTO gax_vpl VALUES ("GN11_21","002_11_21","GEN","11","21","21","Seruug dhalateen duuba, Re'uun woggaa dhibba lamaa fi torba le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_22","002_11_22","GEN","11","22","22","Seruug dhalatee woggaa soddomatti, Naahor uumate; ");
INSERT INTO gax_vpl VALUES ("GN11_23","002_11_23","GEN","11","23","23","Naahor dhalateen duuba, Seruug woggaa dhibba lama le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_24","002_11_24","GEN","11","24","24","Naahor dhalatee woggaa diddamii sagalitti, Taaraa uumate; ");
INSERT INTO gax_vpl VALUES ("GN11_25","002_11_25","GEN","11","25","25","Taaraan dhalateen duuba, Naahor woggaa dhibba tokkoo fi kudhanii sagal le'ee, ilmaanii fi ijoollee durraa dhibii uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_26","002_11_26","GEN","11","26","26","Taaraan dhalatee woggaa torbaatamatti, Abraam, Naahorii fi Kaaraan uumate. ");
INSERT INTO gax_vpl VALUES ("GN11_27","002_11_27","GEN","11","27","27","Sanyiin Taara'aa isaan kana: Taaraan abbaa Abraamii, Naahoriitii fi Kaaraanii ti; Kaaraan abbaa Looxii ti. ");
INSERT INTO gax_vpl VALUES ("GN11_28","002_11_28","GEN","11","28","28","Kaaraan abbaan isaa Taaraan adoo jiruu addee itti dhalatetti, lafa Kaldootaa, Ur keessatti du'e. ");
INSERT INTO gax_vpl VALUES ("GN11_29","002_11_29","GEN","11","29","29","Abraamii fi Naahor niitii fuudhane; maqaan niitii Abraamii Saaraayi; maqaan niitii Naahoriille Miilka'a. Isiin intala Kaaraanii ti; Kaaraan Miilka'aa fi Yiiska'aafille abba'a. ");
INSERT INTO gax_vpl VALUES ("GN11_30","002_11_30","GEN","11","30","30","Saaraan maseena; isiin ijoollee hin qaddu. ");
INSERT INTO gax_vpl VALUES ("GN11_31","002_11_31","GEN","11","31","31","Taaraan ilma ifii Abraam, akaakoo ifii Looxii ilma Kaaraanii, Saaraayii niitii ilmaa ifii Abraamii, fudhatee isaan woliin, biyya Kaldootaa Ur irraa ka'anee gara lafa Kana'aanii dhaqanee achi qubatane. ");
INSERT INTO gax_vpl VALUES ("GN11_32","002_11_32","GEN","11","32","32","Taaraan woggaa dhibba lamaa fi shan le'ee, achiin duuba Kaaraan keessatti du'e. ");
INSERT INTO gax_vpl VALUES ("GN12_1","002_12_1","GEN","12","1","1","Mootiin Waan Maraa, Abraamiin, «Biyya teeti, gosa teeti, maatii abbaa keetiille lakkisiitii, gara lafa ani sitti mudhisuu dhaqi. ");
INSERT INTO gax_vpl VALUES ("GN12_2","002_12_2","GEN","12","2","2","«Ani gosa guddoo si hin godha; si hin eebbisa. Gurra keeti hin guddisa; worra dhibi'iifille eebba hin teeta. ");
INSERT INTO gax_vpl VALUES ("GN12_3","002_12_3","GEN","12","3","3","Ani worra si eebbisu hin eebbisa; worra si abaaru hin abaara. Kolbaan lafa irraa duudiin karaa keetiin ta eebbifante hin teeti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN12_4","002_12_4","GEN","12","4","4","Maarre Abraam akkuma Mootiin Waan Maraa isatti hime deeme; Looxille isa woliin deeme. Abraam biyya Kaaraaniitii yennaa baye san, woggaan isaa torbaatamii shan. ");
INSERT INTO gax_vpl VALUES ("GN12_5","002_12_5","GEN","12","5","5","Abraam niitii ifii Saaraayii fi ilma obboleessa ifii Loox, waan qabanu maraa fi hojjattoota Kaaraanitti dhaggatanelle fudhatanee, gara lafa Kana'aanii deemiisaaf ka'ane. Isaan lafa Kana'aanii yennaa geyane, ");
INSERT INTO gax_vpl VALUES ("GN12_6","002_12_6","GEN","12","6","6","Abraam lafa san keessa dabaree, addee, «Sheekem» jedhantu, haga qilxaa woyyicha Moree deeme. Yennaa san worri Kana'aanotaa lafa san keessa jiraniiyyu. ");
INSERT INTO gax_vpl VALUES ("GN12_7","002_12_7","GEN","12","7","7","Yennaa san Mootiin Waan Maraa Abraamitti mudhatee, «Ani lafa tana sanyii teetiif hin kenna» jedhe; Abraamille addee sanitti, Mootii Waan Maraa ka isatti mudhateef addee ciinca'aa ijaare. ");
INSERT INTO gax_vpl VALUES ("GN12_8","002_12_8","GEN","12","8","8","Achii ka'ee gara lafa koobittii ta Bet'el irraa gara baya adu'uutitti dhaggantuu dhaqe; dunkaanii ifiille Beti'el irraa gara seensa adu'uutitti, Aayin irraa gara baya adu'uutitti dhaabate; achille'etti addee ciinca'aa Mootii Waan Maraatiif ijaaree, achitti maqaa Mootii Waan Maraa waammate. ");
INSERT INTO gax_vpl VALUES ("GN12_9","002_12_9","GEN","12","9","9","Achiin duuba, Abraam gara kibba Kana'aanii garuma duraa deeme. ");
INSERT INTO gax_vpl VALUES ("GN12_10","002_12_10","GEN","12","10","10","Biyya kibba Kana'aaniititti beelti hantuun waan buuteef, Abraam yennaa beelaa san achitti dabarsiisaaf, gara biyya Gibxi'ii gad bu'e. ");
INSERT INTO gax_vpl VALUES ("GN12_11","002_12_11","GEN","12","11","11","Inni Biyya Gibxi'ii seeniisaaf yennaa dhikaate, niitii ifii Saaraayiin, «Ani akka ati dubartii dansitti'ii hin beeka; ");
INSERT INTO gax_vpl VALUES ("GN12_12","002_12_12","GEN","12","12","12","Worri Gibxi'ii yennaa si dhagge, ‹Tun niitii isaa ti› jedhanee na hin ijjeesan; si ammoo hin lakkisan. ");
INSERT INTO gax_vpl VALUES ("GN12_13","002_12_13","GEN","12","13","13","Marroo teetiif akka naaf tolu, sababa keetiif akka jiraadhuuf, ‹Ani obboleettii isaa ti› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN12_14","002_12_14","GEN","12","14","14","Abraam biyya Gibxi'ii yennaa seene, worri Gibxi'ii niitiin isaa guddoo dansittii akka teete dhaggane. ");
INSERT INTO gax_vpl VALUES ("GN12_15","002_12_15","GEN","12","15","15","Qondaaltoti mootii Gibxi'ii yennaa isii dhaggane, dansummaa isi'ii mooticha Gibxi'iititti jajane. Gara mana mootichaalle isii geessane. ");
INSERT INTO gax_vpl VALUES ("GN12_16","002_12_16","GEN","12","16","16","Mootichille isi'iif jedhee Abraamitti tole; inni hoolee, loon, harree, gaalota, tajaajiltoota dhiiraatii fi dubarti'ii isaaf kenne. ");
INSERT INTO gax_vpl VALUES ("GN12_17","002_12_17","GEN","12","17","17","Ammoo sababa Saaraayii niitii Abraamiitiif, Mootiin Waan Maraa mootichaa fi kolbaa mana mootichaa keessa jirtutti dhukkuba hamaa buuse. ");
INSERT INTO gax_vpl VALUES ("GN12_18","002_12_18","GEN","12","18","18","Maarre mootichi biyya Gibxi'ii Abraam waamee, «Wonni ati na irratti hujje kun maan? Akka isiin niitii teeti teete maaf natti hin himin? ");
INSERT INTO gax_vpl VALUES ("GN12_19","002_12_19","GEN","12","19","19","Ati maaf, ‹Isiin obboleettii tiyya› jette? Tanaaf ani niitii isii godhadhee fuudhe. Amma niitiin teeti kunoo ti; fudhadhuu deemi!» Jedheen. ");
INSERT INTO gax_vpl VALUES ("GN12_20","002_12_20","GEN","12","20","20","Mootichi marroo Abraamiitiif namoota ajajee, isaan niitii isaatii fi waan inni qabu mara woliin biyya Gibxiitii isa baasane. ");
INSERT INTO gax_vpl VALUES ("GN13_1","002_13_1","GEN","13","1","1","Abraam niitii ifiitii fi waan qabu mara fudhatee, gara biyya kibba Kana'aanii deeme; Looxille isa woliin deeme. ");
INSERT INTO gax_vpl VALUES ("GN13_2","002_13_2","GEN","13","2","2","Abraam hori'iin, meeti'ii fi worqi'iin guddoo dureessa. ");
INSERT INTO gax_vpl VALUES ("GN13_3","002_13_3","GEN","13","3","3","Inni kibba Kana'aaniitii ka'ee, asii fi achi goggodaanee, haga Bet'elii deemee, Bet'elii fi Aayi odduu lafa dur dunkaana ifii itti dhaabbateeru takka geye. ");
INSERT INTO gax_vpl VALUES ("GN13_4","002_13_4","GEN","13","4","4","Dur inni addee tanatti addee ciincaa itti ciincessanu ijaareeraayyu; inni achitti maqaa Mootii Waan Maraa waammate. ");
INSERT INTO gax_vpl VALUES ("GN13_5","002_13_5","GEN","13","5","5","Looxiin Abraam woliin deemelle hori'ii fi maatii, akkasuma tajaajiltoota ifii qabaayyu. ");
INSERT INTO gax_vpl VALUES ("GN13_6","002_13_6","GEN","13","6","6","Abraamii fi Loox horii guddaa waan qabanuuf, woliin turiisaaf lafa marraa isaan lamaaniifuu geettu dhabanee, ");
INSERT INTO gax_vpl VALUES ("GN13_7","002_13_7","GEN","13","7","7","tissitoota horii Abraamiitii fi tissitoota horii Looxii oddu'utti lolli ka'e; yennaa san Kana'aanotii fi Pheeriisoti lafa san keessa le'aniiyyu. ");
INSERT INTO gax_vpl VALUES ("GN13_8","002_13_8","GEN","13","8","8","Achiin duuba Abraam, Looxiin, «Nuuti obboleeyyan waan teeneef, si'ii fi ana oddu'utti, tissitoota horii keetiitii fi tissitoota horii kiyyaa oddu'utti lolli ka'uu hin malle. ");
INSERT INTO gax_vpl VALUES ("GN13_9","002_13_9","GEN","13","9","9","Kunoo, latti duudiin si dura jirtii motii? Gargar baanuu ti! Ati yoo gara bita'aa fudhatte, ani gara middaa deema; yookiin ati yoo gara middaa fudhatte, ani gara bita'aa deema» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN13_10","002_13_10","GEN","13","10","10","Loox adaala ilaalee, dhooqi Yordaanosii haga qachaa Zo'aariititti akka oorruu Mootiin Waan Maraa Edenitti godhee, akka lafa Gibxi'iille bisaan akka qaddu dhagge; tun Mootiin Waan Maraa qachoota Sodoomiitii fi Gomora'aa balleessiisaan dura. ");
INSERT INTO gax_vpl VALUES ("GN13_11","002_13_11","GEN","13","11","11","Maarre Loox dhooqa Yordaanosii mara filatee, gara baya adu'uu godaane. Akka kanaan isaan lamaan gargar bayane. ");
INSERT INTO gax_vpl VALUES ("GN13_12","002_13_12","GEN","13","12","12","Abraam lafa Kana'aanii keessa le'ee, Loox ammoo qachoota dhooqa Yordaanosii odduu le'e; dunkaana ifiille Yordaanos biratti dhaabbate. ");
INSERT INTO gax_vpl VALUES ("GN13_13","002_13_13","GEN","13","13","13","Bara san kolbaan Sodoomii hamoolee, worra cubbuu guddo'oon Mootii Waan Maraa yakkeeru. ");
INSERT INTO gax_vpl VALUES ("GN13_14","002_13_14","GEN","13","14","14","Loox isa irraa gargar bayeen duuba, Mootiin Waan Maraa Abraamiin, «Ol jedhiitii, lafa amma jirtu tana, kaabaa fi kibba, gara aduun baatuu fi seentu ilaali; ");
INSERT INTO gax_vpl VALUES ("GN13_15","002_13_15","GEN","13","15","15","Lafa ati dhaggitu tana duudii si'ii fi sanyii teetiif hin kenna; isiille haga bara baraa teessan hin teeti. ");
INSERT INTO gax_vpl VALUES ("GN13_16","002_13_16","GEN","13","16","16","Ani sanyii teeti akka maansa lafaa hin godha; nami maansa lafaa laakkowuu yoo dande'e, sanyiin teetille laakkowamuu hin dandeetti. ");
INSERT INTO gax_vpl VALUES ("GN13_17","002_13_17","GEN","13","17","17","Ani isii waan sii kennuuf, ka'iitii, dheerinna fi badhinna lafaa keessa deemi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN13_18","002_13_18","GEN","13","18","18","Maarre Abraam dunkaana ifii buqqifatee, qilxaa Mamre'ee ka Hebroonitti dhiko'oo bira dhufee qubate. Achille'etti addee ciinca'aa Mootii Waan Maraatiif ijaare. ");
INSERT INTO gax_vpl VALUES ("GN14_1","002_14_1","GEN","14","1","1","Bara san mootiin biyya Shiinaarii Amraafel, mootiin biyya Elaasaarii Aryook, mootiin biyya Elaamii Kador-Laa'omer, mootiin gosa biyya adda addaa Tidaal mootummaa irra jiraniiyyu. ");
INSERT INTO gax_vpl VALUES ("GN14_2","002_14_2","GEN","14","2","2","Mootoleen tun mootii Sodoomii Beeraa, mootii Gomora'aa Birishaa, mootii Aadima'aa Shanaab, mootii Zebo'iimii Shemeber, mootii qachaa Bela'aa, ka amma qachaa «Zo'aar» jedhamu loliisaaf dhaqane. ");
INSERT INTO gax_vpl VALUES ("GN14_3","002_14_3","GEN","14","3","3","Worri loliisaaf yaa'e kun dhooqa siidiimii ta amma «Abbaayaa sooddaa» jedhantu keessatti wolitti gurmaaye. ");
INSERT INTO gax_vpl VALUES ("GN14_4","002_14_4","GEN","14","4","4","Mootoleen tun woggaa kudhanii lamaaf, mooticha Kador-Laa'omeriif tajaajilanee, woggaa kudhanii sadeesso'ootitti ammoo finqilaan itti ka'ane. ");
INSERT INTO gax_vpl VALUES ("GN14_5","002_14_5","GEN","14","5","5","Woggaa kudhanii arfeesso'ootitti Kador-Laa'omerii fi mootoleen isa woliin gurmaayane loltoota ifii woliin dhufanee, worra Refaa'iimii addee «Ashitaarot-Karnaayim» jedhantutti, worra Zuziimii addee «Ham» jedhantutti, worra Emiimii addee «Dirree Kiriiyataayim» jedhantutti, ");
INSERT INTO gax_vpl VALUES ("GN14_6","002_14_6","GEN","14","6","6","worra Hooriille gaara Se'iirii irraa haga El-Phaaranii irga goomole'eetitti injifatane. ");
INSERT INTO gax_vpl VALUES ("GN14_7","002_14_7","GEN","14","7","7","Achiin duuba isaan deebi'anee gara En-Miisphaatii ta «Qaadeshi» jedhantuu dhufanee, lafa Amaaleqootaa duudii qabatanee, Amoorota worra Haazezon-Taamaar keessa le'anulle injifatane. ");
INSERT INTO gax_vpl VALUES ("GN14_8","002_14_8","GEN","14","8","8","Achiin duuba mootiin Sodoomii, mootiin gomora'aa, mootiin Aadima'aa, mootiin Zebo'iimii, mootiin Bela'aa ka «Zo'aar» jedhamu, bayanee dhooqa Siidiimii keessatti isaan lolane. ");
INSERT INTO gax_vpl VALUES ("GN14_9","002_14_9","GEN","14","9","9","Isaan mootii biyya Elaamii Kador-Laa'omer woliin, mootii gosa biyya adda addaa woliin, mootii biyya Shiinaarii Amraafel woliin, mootii biyya Elaasaarii Aryook woliin wol lolane; akka kanaan moototi shanan mootota arfan woliin wol lolane. ");
INSERT INTO gax_vpl VALUES ("GN14_10","002_14_10","GEN","14","10","10","Dhooqi Siidiimii boolla leyyaa lafa keessaa dhaggamuun guutanteertiiyyu; mootiin Sodoomiitii fi Gomora'aa adoo baqatanuu boolla bu'ane; worri hafe ammoo gara gaaraa baqate. ");
INSERT INTO gax_vpl VALUES ("GN14_11","002_14_11","GEN","14","11","11","Moototi arfan sun worra Sodoomiitii fi Gomora'aa irraa waan isaan qabanu mara, sagalee isaaniille fudhatanee deemane. ");
INSERT INTO gax_vpl VALUES ("GN14_12","002_14_12","GEN","14","12","12","Ilmi obboleessa Abraamii Loox, Sodoom keessa le'aa waan tureef, isaan waan inni qabu maraa fi isa booji'anee deemane. ");
INSERT INTO gax_vpl VALUES ("GN14_13","002_14_13","GEN","14","13","13","Namichi miliqee bayeeru tokko ammoo, gara Abraamii Ibraawichaa dhufee waan te'e mara itti hime; yennaa san Abraam qilxoota Mamree Amoorichaa bira le'aayyu; Mamreen obboleessa Eshikoliitii fi Anerii ti. Isaan kun yennaa lolaa Abraam qarqaariisaaf wolii galtee godhataneeran. ");
INSERT INTO gax_vpl VALUES ("GN14_14","002_14_14","GEN","14","14","14","Abraam booji'amiisa ilma obboleessa ifii yennaa dhage'e, namoota dhibba sadii fi kudhanii saddeeti worra mana isaatitti dhalatanee lolaaf leenji'ane waamee, worra booji'e san haga Daaniititti hordofe. ");
INSERT INTO gax_vpl VALUES ("GN14_15","002_14_15","GEN","14","15","15","Inni halkaniin akka lolanuuf namoota ifii gargar qoqoodee, diinota ifii lolee injifatee, haga Hobaa Damaasqoo irraa gara kaabaa jirtuu ari'ane. ");
INSERT INTO gax_vpl VALUES ("GN14_16","002_14_16","GEN","14","16","16","Waan isaan booji'aneeranu mara, ilma obboleessa ifii Loox, waan inni qabu woliin, dubartootaa fi worra booji'ameeru dhibiille deebisee fide. ");
INSERT INTO gax_vpl VALUES ("GN14_17","002_14_17","GEN","14","17","17","Abraam Kador-Laa'omerii fi mootota isa woliin jiranu injifatee adoo deebi'iisatti jiruu, mootiin Sodoomii dhooqa Shawwee ta «Dhooqa mooti'ii» jedhantutti isa qophatiisaaf baye. ");
INSERT INTO gax_vpl VALUES ("GN14_18","002_14_18","GEN","14","18","18","Mootichi Saalemii Malkiisedeq, hayyicha Waaqa Ol Aana'aa, daabbo'oo fi daadhii woyni'ii Abraamiif fidee, ");
INSERT INTO gax_vpl VALUES ("GN14_19","002_14_19","GEN","14","19","19","isa eebbisee, «Waaqi Ol Aanaan, ka ol-gubba'aa fi lafa dade, Abraam eebbisuu ti; ");
INSERT INTO gax_vpl VALUES ("GN14_20","002_14_20","GEN","14","20","20","Waaqi Ol Aanaan, ka diinota keeti harka keetitti kenne, leellifamuu ti!» jedhe. Abraamille waan booju'uun dhaggate mara irraa kudhan keessa tokko Malkiisedeqiif kenne. ");
INSERT INTO gax_vpl VALUES ("GN14_21","002_14_21","GEN","14","21","21","Mootichi Sodoomii, Abraamiin, «Waan dhibii mara fudhadhuu, namoota kiyya naa deebis» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN14_22","002_14_22","GEN","14","22","22","Abraam deebisee, «Mootii Waan Maraa Waaqa Ol Aanaa, ka ol-gubba'aa fi lafa dade duratti hin kakadha; ");
INSERT INTO gax_vpl VALUES ("GN14_23","002_14_23","GEN","14","23","23","akka ati, ‹Anatti Abraam duroonse› hin jenneef, waan keeti keessaa liilana tokko yookiin waan kophe'een hidhatanulle hin fudhadhu. ");
INSERT INTO gax_vpl VALUES ("GN14_24","002_14_24","GEN","14","24","24","Waan namooti kiyya nyaatane malee, ani womaa hin fudhadhu, worri na woliin dhaqe Aner, Eshikolii fi Mamreen qooda ifii fudhatanuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN15_1","002_15_1","GEN","15","1","1","Wonni kun teeteen duuba, jechi Mootiin Waan Maraa mudhi'iin gara Abraamii dhufee, «Abraam, hin sodaatin, ani wontee teeti; ani gatii guddoo si'iif hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN15_2","002_15_2","GEN","15","2","2","Abraam ammoo, «Ee, Goottaa, Mootii waan maraa, adoo ani uumaa dhabeeruu, gatiin naaf kennitu maan naa gooti? Nami na dhaalu Elii'ezaar nama Damaasqo'oo ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN15_3","002_15_3","GEN","15","3","3","Abraam ammalle, «Kunoo, ati uumaa naaf waan hin kenniniif, garbicha mana kiyya keessatti dhalate tokkotti na dhaalaara» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN15_4","002_15_4","GEN","15","4","4","Achiin duuba jechi Mootii Waan Maraa gara isaa dhufee, «Inni si hin dhaalu, ilma ati ifii uumattutti si dhaala» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN15_5","002_15_5","GEN","15","5","5","Mootiin Waan Maraa alatti isa baasee, «Gara gubba'aa ol ilaaliitii, yoo laakkowuu dandeette, urjoota laakkowi» jedhe. Achiin duuba, inni Abraamiin, «Maarre sanyiin teetille akkasuma hin teeti» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN15_6","002_15_6","GEN","15","6","6","Abraam Mootii Waan Maraatitti dhugeeffate; dhugeeffannaan isaalle akka balchumma'aatitti isaaf laakkowante. ");
INSERT INTO gax_vpl VALUES ("GN15_7","002_15_7","GEN","15","7","7","Achiin duuba inni, Abraamiin, «Ani Mootiin Waan Maraa biyya tana akka ati dhaaltuuf, Ur lafa kaldootaa keessaa si baase» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN15_8","002_15_8","GEN","15","8","8","Abraam ammoo, «Ee, Goottaa, Mootii Waan Maraa, akka dhaalu attamiin beeka?» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN15_9","002_15_9","GEN","15","9","9","Mootiin Waan Maraa, Abraamiin, «Goronsa woggaa sadii, re'ee dhaltuu woggaa sadii, korbeessa hoole'ee ka woggaa sadii, saphaliisaa fi maddoo naa fidi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN15_10","002_15_10","GEN","15","10","10","Abraam isaan kana mara gara isaa fidee, addee lama lamatti kukkutee, ka kukkutamane san gama tokko gama kaaniin wolitti fuula galchee keye; sinbirroota ammoo hin kukkunne. ");
INSERT INTO gax_vpl VALUES ("GN15_11","002_15_11","GEN","15","11","11","Yennaa allaattiin reeffa nyaatiisaaf dhutte, Abraam irraa ari'e. ");
INSERT INTO gax_vpl VALUES ("GN15_12","002_15_12","GEN","15","12","12","Adoo aduun seeniisatti jirtuu, hirriibi hamaan Abraamitti bu'ee, soda'aa fi dukkanti dimmi isatti dhutte. ");
INSERT INTO gax_vpl VALUES ("GN15_13","002_15_13","GEN","15","13","13","Achiin duuba Mootiin Waan Maraa, Abraamiin, «Sanyiin teeti biyya ormaa keessatti alagaa te'iisaaf, achille'etti garboota te'iisaaf, woggaa dhibba afur akka cunqurfamu'uuf jiranu beeki! ");
INSERT INTO gax_vpl VALUES ("GN15_14","002_15_14","GEN","15","14","14","Ani ammoo gosa biyya isaan garboonfattu san hin adaba; isaan karra guddoo fudhatanee achii hin bayan. ");
INSERT INTO gax_vpl VALUES ("GN15_15","002_15_15","GEN","15","15","15","Ati ifiif, dulloontee bara dheeraa leetee, nageyaan duutee, hin awwaalanta. ");
INSERT INTO gax_vpl VALUES ("GN15_16","002_15_16","GEN","15","16","16","Yennaan worri Amoorotaa adabamanu haga ammaa waan hin geyiniif, sanyiin teeti haga dhaloota arfeesso'ootitti deebi'anee hin dhufanu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN15_17","002_15_17","GEN","15","17","17","Yennaa aduun seentee dukkanootte, okkoteen ibiddaa ta aartuu fi umeessaan bobe'u foon gargar kukkutame wodhakkaa dabare. ");
INSERT INTO gax_vpl VALUES ("GN15_18","002_15_18","GEN","15","18","18","Gaafas Mootiin Waan Maraa Abraam woliin gondooroo gondoorate, «Ani lafa tana laga Gibxi'iitii jalqabee haga laga guddicha Efraaxiisiititti sanyii teetiif hin kenna. ");
INSERT INTO gax_vpl VALUES ("GN15_19","002_15_19","GEN","15","19","19","Latti tun lafa Qenootaa, lafa Qeniizotaa, lafa Qadimonootaa, ");
INSERT INTO gax_vpl VALUES ("GN15_20","002_15_20","GEN","15","20","20","Heetotaa, Pheriizotaa, Refaa'otaa, ");
INSERT INTO gax_vpl VALUES ("GN15_21","002_15_21","GEN","15","21","21","Amoorotaa, Kana'aanotaa, Girgaashotaatii fi Yibusootaa ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN16_1","002_16_1","GEN","16","1","1","Niitiin Abraamii Saaraayi, ijoollee isaaf deettee hin jirtuuyyu. Isiin hojjattuu «Aggaar» jedhantu takka qaddi; Aggaar nama biyya Gibxi'ii ti. ");
INSERT INTO gax_vpl VALUES ("GN16_2","002_16_2","GEN","16","2","2","Saaraayille Abraamiin, «Mootiin Waan Maraa ijoollee dewuu akka na dhoogge hin dhaggita; hojjattuu tiyya bira geyi! Karaa isi'iitiin ijoollee hin dhaggadha fa'aa» jette. Abraamille dubbii Saaraayii dhage'e. ");
INSERT INTO gax_vpl VALUES ("GN16_3","002_16_3","GEN","16","3","3","Niitiin Abraamii Saaraayi hojjattuu ifii Aggaarii nama biyya Gibxi'ii san fiddee, akka niiti'iititti dhirsa ifiitiif kennite; kunille Abraam biyya kana'aanii keessa woggaa kudhan le'een duuba te'e. ");
INSERT INTO gax_vpl VALUES ("GN16_4","002_16_4","GEN","16","4","4","Abraam Aggaar bira geyee, isiille ulfootte; isiin akka ulfootte yennaa dhaggite, giittii ifii irratti mataa dhaadde. ");
INSERT INTO gax_vpl VALUES ("GN16_5","002_16_5","GEN","16","5","5","Achiin duuba Saaraayi Abraamiin, «Tun balleessaa teeti. Anumattuu isii si'iif kenne; isiin ammoo akka ulfootte beettee, na irratti mataa dhaadde. Ati yookiin ani sirrii akka teene, Mootiin Waan Maraa muruu ti» jette. ");
INSERT INTO gax_vpl VALUES ("GN16_6","002_16_6","GEN","16","6","6","Abraam ammoo Saaraayiin, «Ati giittii hojjattuu teetii ti; akka jaalatte isii godhi» jedhe. Achiin duuba Saaraayi waan isii miicceef, isiille jalaa baqatte. ");
INSERT INTO gax_vpl VALUES ("GN16_7","002_16_7","GEN","16","7","7","Ergamaan Mootii Waan Maraa goomolee keessatti madda bisaanii biratti Aggaar dhagge; maddi bisaanii sun karaa Shuur geessu gubbaa jiraayyu. ");
INSERT INTO gax_vpl VALUES ("GN16_8","002_16_8","GEN","16","8","8","Inni, hojjattuu Saaraayii, Aggaariin, «Eessaa dhutte? Eessa dhaqaarta?» jedheen. Isiin, «Giittii tiyya Saaraayi jalaa baqatiisatti jira» jette. ");
INSERT INTO gax_vpl VALUES ("GN16_9","002_16_9","GEN","16","9","9","Ergamaan Mootii Waan Maraalle, isi'iin, «Gara giittii teetii deebi'iitii, isii tajaajili» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN16_10","002_16_10","GEN","16","10","10","Ergamaan Mootii Waan Maraa itti dabalee, «Ani sanyii teeti hin baceessa; bacinna isaaniitiin ka ka'e, eennulle isaan laakkowee hin dande'u. ");
INSERT INTO gax_vpl VALUES ("GN16_11","002_16_11","GEN","16","11","11","Ati amma ulfootteerta, ilmalle hin deetta; iyya ati miicantee iyyite Mootiin Waan Maraa waan dhage'eef, maqaa isaalle ‹Ishimaa'el› jetta. ");
INSERT INTO gax_vpl VALUES ("GN16_12","002_16_12","GEN","16","12","12","Inni akka harree diidaa hin le'a; inni nama mara hin morma; nami martille isa hin morma. Fira ifii mara irraa adda bayee hin le'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN16_13","002_16_13","GEN","16","13","13","Aggaarille, «Ani dhugumaan Mootii Waan Maraa ka na dhaggu dhaggee?» waan jetteef, Mootii Waan Maraa ka isi'itti dubbate san, «El-Ro'i» jettee waante. ");
INSERT INTO gax_vpl VALUES ("GN16_14","002_16_14","GEN","16","14","14","Tanaaf namooti baleessa Qaadeshii fi Baared wodhakkaa jiru, «Be'er-Lahaayi-Ro'i» jedhanee waamane. ");
INSERT INTO gax_vpl VALUES ("GN16_15","002_16_15","GEN","16","15","15","Aggaar ilma Abraamiif deette; Abraamille ilma ifii ka Aggaar deette, «Ishimaa'el» jedhee maqaa baase. ");
INSERT INTO gax_vpl VALUES ("GN16_16","002_16_16","GEN","16","16","16","Aggaar yennaa Ishimaa'el isaaf deette, Abraam nama woggaa saddeettamii jaa ti. ");
INSERT INTO gax_vpl VALUES ("GN17_1","002_17_1","GEN","17","1","1","Abraam nama woggaa sagaltamii sagalii yennaa te'etti, Mootiin Waan Maraa Abraamitti mudhatee, «Ani Waaqa waan mara dande'u; naaf ajajamiitii ka komii hin qanne te'i. ");
INSERT INTO gax_vpl VALUES ("GN17_2","002_17_2","GEN","17","2","2","Anille wodhakkaa tiyyaa fi teetitti gondooroo hin gondoora; sanyii teeti hin baceessa» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN17_3","002_17_3","GEN","17","3","3","Achiin duuba Abraam fuulaan lafatti gombifame; Waaqille isaan ");
INSERT INTO gax_vpl VALUES ("GN17_4","002_17_4","GEN","17","4","4","«Gondooroo ani si woliin gondooru tana: Ati abbaa gosa biyya adda addaa heddu'uu hin teeta. ");
INSERT INTO gax_vpl VALUES ("GN17_5","002_17_5","GEN","17","5","5","Maqaan keeti haganaa achi, ‹Abraam› hin jedhamu, ani abbaa gosa biyya adda addaa heddu'uu waan si godhuuf, maqaan keeti, ‹Abrahaam› jedhama. ");
INSERT INTO gax_vpl VALUES ("GN17_6","002_17_6","GEN","17","6","6","Ani sanyii hedduu sii hin kenna. Isaan gosa biyya adda addaa hin te'an; isaan keessaa gariin mootota hin te'an. ");
INSERT INTO gax_vpl VALUES ("GN17_7","002_17_7","GEN","17","7","7","«Ani si'iif Waaqa te'ee, si'iin duuballe sanyii teetiif Waaqa te'iisaaf Gondooroo tiyya anaa fi si wodhakka'atti, dhaloota si'iin duuba jiranu, sanyii isaanii wodhakkaalle'etti Gondooroo haga bara baraa godhee, jabeessee hin gondoora. ");
INSERT INTO gax_vpl VALUES ("GN17_8","002_17_8","GEN","17","8","8","Lafa ati amma alagaa itti teete, lafa Kana'aanotaa mara si'ii fi sanyii teetiif haga bara baraa hin kenna; ani Waaqa isaaniille hin te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN17_9","002_17_9","GEN","17","9","9","Ammalle Waaqi Abrahaamiin, «Atii fi sanyiin teeti, dhalooti si'iin duubaalle gondooroo tiyya eegadha'a. ");
INSERT INTO gax_vpl VALUES ("GN17_10","002_17_10","GEN","17","10","10","Gondooroon tiyya ta anaa fi si wodhakka'atti, dhalooti si'iin duubaalle eegatuu qaddanu, ‹Isin keessaa dhiirti martinuu haqanqabaa qabatanuu ti› ka jedhu. ");
INSERT INTO gax_vpl VALUES ("GN17_11","002_17_11","GEN","17","11","11","Isin haqanqabaa qabadha'a! Kunille gondooroo anaa fi isin wodhakkaa jirtuuf beessisa hin te'a. ");
INSERT INTO gax_vpl VALUES ("GN17_12","002_17_12","GEN","17","12","12","Dhaloota mara keessatti dhiira te'ee mana keeti keessatti ka dhalatu mara, garbicha mana keeti keessatti dhalatu, sanyii teeti keessaa adoo hin te'in ka orma irraa beese'een bitamelle, dhalatee guyyaa saddeetitti haqanqabaa qabamuu ti. ");
INSERT INTO gax_vpl VALUES ("GN17_13","002_17_13","GEN","17","13","13","Garbichi mana keeti keessatti dhalatee fi ka beese'een bitamelle lamaanuu haqanqabaa qabamanuu ti. Gondooroon tiyya ta beessisi isi'ii foon keessan irratti mudhatu gondooroo bara baraa hin teeti. ");
INSERT INTO gax_vpl VALUES ("GN17_14","002_17_14","GEN","17","14","14","Dhiirti haqanqabaa hin qabatin marti, gondooroo tiyya waan cassiteef, kolbaa ifii keessaa hin balleeffanti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN17_15","002_17_15","GEN","17","15","15","Waaqi ammalle Abrahaamiin, «Niitii teeti Saaraayi, haganaa achi ‹Saaraayi› jettee hin waamin; ammaan jalqabee maqaan isi'ii ‹Saaraa› jedhamuu ti. ");
INSERT INTO gax_vpl VALUES ("GN17_16","002_17_16","GEN","17","16","16","Ani isii hin eebbisa; isii irraa ilma si'iif hin kenna. Ani isii hin eebbisa, isiille haadha gosa biyya adda addaa hin teeti; sanyii isi'ii keessaa gariin mootota hin te'an» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN17_17","002_17_17","GEN","17","17","17","Achiin duuba Abrahaam fuulaan lafatti gad gombifame; ammoo kollee, «Nami jaarsi woggaa dhibbaa ilma dande'ee uumataa? Saaraan jaartiin woggaa sagaltamaa ilma deettee dandeettii?» ifiin jedhe. ");
INSERT INTO gax_vpl VALUES ("GN17_18","002_17_18","GEN","17","18","18","Inni Waaqaan, «Ishimaa'el ilma waadaa ati naaf galte adoo te'ee dansa'aayyu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN17_19","002_17_19","GEN","17","19","19","Waaqi ammoo, «Waawwo'o. Niitiin teeti Saaraan ilma siif hin deetti; maqaa isaalle, ‹Yisihaq› jettaan. Ani Gondooroo tiyya ta bara baraa isaa fi sanyii isaa ta isa duubaatiif hin gondoora. ");
INSERT INTO gax_vpl VALUES ("GN17_20","002_17_20","GEN","17","20","20","Marroo Ishimaa'eliitiif waan ati daadimatte si'iif dhage'eera; ani isa eebbisee, ijoollee isaaf kennee, sanyii isaa bacaa hin godha. Inni abbaa sooreyyii gugurdoo kudhanii lamaa hin te'a; gosa guddoolle isa hin godha. ");
INSERT INTO gax_vpl VALUES ("GN17_21","002_17_21","GEN","17","21","21","Ani ammoo Gondooroo tiyya, Yisihaqii Saaraan bara dhufu yennaa tanatti si'iif deettu woliin hin gondoora» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN17_22","002_17_22","GEN","17","22","22","Waaqi Abrahaam woliin dubbateen duuba isa biraa ol baye. ");
INSERT INTO gax_vpl VALUES ("GN17_23","002_17_23","GEN","17","23","23","Gaafasuma Abrahaam ilma ifii Ishimaa'el, tajaajiltoota mana isaa keessatti dhalatane mara, worra beesee isaatiin bitamane mara, namoota mana isaa keessa jiranu keessaa dhiira ka te'ane maraayyuu fuudhee, akkuma Waaqi isa ajajetti haqanqabaa qabe. ");
INSERT INTO gax_vpl VALUES ("GN17_24","002_17_24","GEN","17","24","24","Abrahaam haqanqabaa yennaa qabatu, woggaan isaa sagaltamii sagal. ");
INSERT INTO gax_vpl VALUES ("GN17_25","002_17_25","GEN","17","25","25","Ilmi Abrahaamii Ishimaa'el yennaa haqanqabaa qabatu, woggaan isaa kudhanii sad. ");
INSERT INTO gax_vpl VALUES ("GN17_26","002_17_26","GEN","17","26","26","Abrahaamii fi ilmi isaa Ishimaa'el gaafuma tokko haqanqabaa qabatane. ");
INSERT INTO gax_vpl VALUES ("GN17_27","002_17_27","GEN","17","27","27","Namooti mana isaa keessaa martille, tajaajiltooti mana isaa keessatti dhalatanee fi worri orma irraa beese'een bitamanee dhufane, Abrahaam woliin haqanqabaa qabatane. ");
INSERT INTO gax_vpl VALUES ("GN18_1","002_18_1","GEN","18","1","1","Abrahaam Saafowa seensuma dunkaana ifii dura tee'eeruun, qilxaa Mamre'ee biratti, Mootiin Waan Maraa isatti mudhate. ");
INSERT INTO gax_vpl VALUES ("GN18_2","002_18_2","GEN","18","2","2","Inni ol ilaalee namooti sadiin isa bira dhaabbataneeranuun dhagge; akkuma isaan dhaggeen, isaan qophatiisaaf seensuma dunkaani'ii duraa gara isaanii rukkisee, lafatti gad gombifamee, ");
INSERT INTO gax_vpl VALUES ("GN18_3","002_18_3","GEN","18","3","3","tokkochaan, «Goottaa kiyya, ani yoo si duratti fudhatama dhaggadhe tajaajilaa keeti irra hin dabarin. ");
INSERT INTO gax_vpl VALUES ("GN18_4","002_18_4","GEN","18","4","4","Me, bisaan diqqaa isaa isinii fida; miila keessan dhiqadha'aatii, muka kana jalatti foorfadha'a. ");
INSERT INTO gax_vpl VALUES ("GN18_5","002_18_5","GEN","18","5","5","Gara mana ana tajaajilaa keessanii eega dhuttanee, dadhabbii akka baatanuuf, daabboo diqqoo takka isinii fida; achiin duuba dabaruu hin dandeettan» jedhe; isaan deebisanee, «Akkuma jette san godhi» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN18_6","002_18_6","GEN","18","6","6","Abrahaam ariifatee gara Saara'aa dunkaana keessa dhaqee, «Dafiitii, bullaa dansittii meya itti safaranu sad, sukkuumii, bilcheessi» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN18_7","002_18_7","GEN","18","7","7","Achiin duuba Abrahaam gara tikaa rukkisee, jabbilee bobbosoqqee keessaa tokkocha fuudhee, tajaajilaa dafee qalee qopheessu tokkotti kenne. ");
INSERT INTO gax_vpl VALUES ("GN18_8","002_18_8","GEN","18","8","8","Achiin duuba inni itittuu, aananii fi foon qophowe san geessee, isaaniif dhikeesse; yennaa isaan nyaatanu, Abrahaam muka jala isaan bira dhaabbateeraayyu. ");
INSERT INTO gax_vpl VALUES ("GN18_9","002_18_9","GEN","18","9","9","Yennaa san isaan, «Niitiin teeti Saaraan eessa jirti?» jedhaneen. Inni, «As dunkaana keessa jirti» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN18_10","002_18_10","GEN","18","10","10","Isaan keessaa tokkochi, «Bara dhufu yennaa akkanaa tana deebi'ee gara keeti hin dhufa; yennaa san Saaraan niitiin teetii ilma hin deetti» jedhe. Yennaa inni tana dubbatu Saaraan balbala dunkaani'ii ta Abrahaamiin duuba jirtu dura dhaabbattee dhage'iisatti jirtiiyyu. ");
INSERT INTO gax_vpl VALUES ("GN18_11","002_18_11","GEN","18","11","11","Abrahaamii fi Saaraan guddoo dulloomaneeraniiyyu; Saaraalle aadaan dubarti'ii irraa dhaabbatteertiiyyu. ");
INSERT INTO gax_vpl VALUES ("GN18_12","002_18_12","GEN","18","12","12","Maarre saaraan, gadhaa ifii keessatti «Ani eega dulloomee gergeshe, dhirsi kiyyalle dulloomee gergeshe, ani isa bira geyiisaaf halcha'aayyuu hin qabaadhaa?» jettee kollite. ");
INSERT INTO gax_vpl VALUES ("GN18_13","002_18_13","GEN","18","13","13","Achiin duuba Mootiin Waan Maraa, Abrahaamiin, «Maaf Saaraan, ‹Ani dulloomee gergesheen duuba, ani dhugumaan deyiisa hin dande'aa?› jette. ");
INSERT INTO gax_vpl VALUES ("GN18_14","002_18_14","GEN","18","14","14","Wonni Mootiin Waan Maraa dadhabu ijjumaayyuu hin jirtii? Bara dhufu yennaa akkanaa tana ani deebi'ee gara keeti hin dhufa; akkuma sitti hime Saaraan yennaa san ilma hin deetti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_15","002_18_15","GEN","18","15","15","Saaraan guddoo waan sodaatteef, «Ani hin kolline» jettee mormatte. Inni ammoo, «Dhuguma, kolliteerta» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_16","002_18_16","GEN","18","16","16","Namooti sadiin sun yennaa achii ka'ane, gara Sodoomii ilaalane; Abraamille geegessiisaaf isaan woliin baye. ");
INSERT INTO gax_vpl VALUES ("GN18_17","002_18_17","GEN","18","17","17","Mootiin Waan Maraa, «Ani waan godhu'uu jiru Abrahaam hin dhossu. ");
INSERT INTO gax_vpl VALUES ("GN18_18","002_18_18","GEN","18","18","18","Abrahaam gosa guddo'oo fi hunnaamettii hin te'a; gosi lafa irra jirtu marti karaa isaatiin hin eebbifanti. ");
INSERT INTO gax_vpl VALUES ("GN18_19","002_18_19","GEN","18","19","19","Balchumma'aa fi haqa hujiisaan karaa Mootii Waan Maraa akka eegatanu, ijoollee ifiitii fi worra mana ifii gorsiisaan akka sooressu ani isa filadheera; ijoolleen isaa waan kana yoo goote, anille waadaa isaaf gale duudii hin muummessa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_20","002_18_20","GEN","18","20","20","Achiin duuba Mootiin Waan Maraa, «Iyyannoon worra Sodoomiitii fi Gomora'aa irratti dhikaatte attam attam guddo'o! Cubbuun isaaniille akka malee guddo'o! ");
INSERT INTO gax_vpl VALUES ("GN18_21","002_18_21","GEN","18","21","21","Ani gad bu'ee wonni isaan hujane martinuu akka iyyannoo gara kiyya dhikaatte sanii te'uu isi'ii hin ilaala» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_22","002_18_22","GEN","18","22","22","Achiin duuba namooti lamaan gara Sodoomii deemiisa ka'ane; Mootiin Waan Maraa ammoo Abrahaam woliin hafe. ");
INSERT INTO gax_vpl VALUES ("GN18_23","002_18_23","GEN","18","23","23","Yennaa san Abrahaam gara Mootii Waan Maraa dhikaatee, «Ati dhugumaan balchoota dabaaleyyii woliin lafa irraa balleessaartaa? ");
INSERT INTO gax_vpl VALUES ("GN18_24","002_18_24","GEN","18","24","24","Namooti balchooti shantam qachaa san keessa yoo jiraatane, qachaa duudii hin balleessitaa? Namoota balchoota shantama achi keessa le'anuuf jettee hin lakkittuu? ");
INSERT INTO gax_vpl VALUES ("GN18_25","002_18_25","GEN","18","25","25","Ati dhugumaan balchoota dabaaleyyii woliin hin ijjeettu; ati tana hin gootu; yoo tana goote namooti balchooti dabaaleyyii woliin hin adabaman; tun ijjumaa hin teetu. Ka biyya lafaa duudi'itti muru, sirri'itti muruu hin qabuu ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_26","002_18_26","GEN","18","26","26","Mootiin Waan Maraa deebisee, «Ani namoota balchoota shantama qachaa Sodoomii keessatti yoo dhagge, ani isaaniif jedhee qachaa san duudii hin fayyisa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_27","002_18_27","GEN","18","27","27","Abrahaam deebisee, «Ani nama woy hin baane buku'uu fi daadha'a; Goottaa kiyya sodaa malee waan sitti dubbadheef, maganne'ee naaf araaram. ");
INSERT INTO gax_vpl VALUES ("GN18_28","002_18_28","GEN","18","28","28","Balchoota shantama keessaa shanan hin dhidhatan fa'a; sababa shanan dhidhataneef qachaa duudii hin balleessitaa?» jedhe. Mootiin Waan Maraa deebisee, «Ani balchoota afurtamii shan achitti yoo dhagge, ani qachaa san duudii hin balleessu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_29","002_18_29","GEN","18","29","29","Abrahaam ammalle isaan, «Balchoota afurtama qofa achitti yoo dhaggite hoo?» jedhe. Inni deebisee, «Balchoota afurtama yoo dhagge hin balleessu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_30","002_18_30","GEN","18","30","30","Achiin duuba Abrahaam, «Mootii waan maraa, ammalle deebi'ee yoo dubbadhe hin aarin. Balchoota soddoma qofa qachaa san keessatti yoo dhaggite hoo?» jedhe. Inni deebisee, «Ani balchoota soddoma qachaa san keessatti yoo dhagge, qachaa san hin balleessu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_31","002_18_31","GEN","18","31","31","Abrahaamille, «Mootii waan maraa, sodaa malee waan sitti dubbadheef, maganne'ee naaf araaram. Balchooti diddam qofa achitti yoo dhaggamane hoo?» jedhe. Inni deebisee, «Ani balchoota diddama saniif jedhee, qachaa san hin balleessu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_32","002_18_32","GEN","18","32","32","Achiin duuba Abrahaam, «Mootii waan maraa, takkattii tana qofa dubbadha, maganne'ee natti hin aarin. Balchooti kudhan qofa achitti yoo dhaggame hoo?» jedhe. Inni deebisee, «Ani balchoota kudhan yoo achitti dhagge, qachaa san hin balleessu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN18_33","002_18_33","GEN","18","33","33","Mootiin Waan Maraa Abrahaam woliin dubbatee fixateen duuba deeme; Abrahaamille gara addee ifii deebi'e. ");
INSERT INTO gax_vpl VALUES ("GN19_1","002_19_1","GEN","19","1","1","Ergantooti Waaqaa lamaan galgaluma san gara Sodoomii dhutte; Yennaa san Loox karra qacha'aa bira tee'eeraayyu. Inni yennaa isaan dhagge, isaan qophatiisaaf itti dhaqee lafatti gad gombifamee, ");
INSERT INTO gax_vpl VALUES ("GN19_2","002_19_2","GEN","19","2","2","«Goottota tiyya, maganne'ee, gara mana tajaajilaa keessanii kowa'a. Miila keessan dhiqa'aatii bula'a; barii ganama deemuu dandeettan» jedhe. Isaan ammoo, «Waawwo'o; nuuti asuma badhinna qacha'aa bulla» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN19_3","002_19_3","GEN","19","3","3","Inni ammoo jabeessee isaan waan kadhateef, isa woliin gara mana isaa dhaqane. Loox daabboo bilcheessanee, sagalee galgalaa dansaa akka isaaniif qopheessanu tajaajiltoota ifii ajaje. Yennaa sagaleen qophootte isaan nyaatane. ");
INSERT INTO gax_vpl VALUES ("GN19_4","002_19_4","GEN","19","4","4","Isaan adoo hin rafiniin dura, namooti qachaa Sodoomii, dargaggeeyyi'ii fi jaarsoleen dhiirti qachaa sanii marti mana san marsane. ");
INSERT INTO gax_vpl VALUES ("GN19_5","002_19_5","GEN","19","5","5","Isaan Loox waamanee, «Namooti galgala kana gara keeti buliisaaf dhufane meet? Akka isaan bukkoonsinu gad nutti baasi» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN19_6","002_19_6","GEN","19","6","6","Loox gara isaanii gad bayee, balbala ifi duubaan cufatee, ");
INSERT INTO gax_vpl VALUES ("GN19_7","002_19_7","GEN","19","7","7","«Maganne'ee Obboleeyyan tiyya, waan daba akkasii hin hujina'a! ");
INSERT INTO gax_vpl VALUES ("GN19_8","002_19_8","GEN","19","8","8","Kunoo, ani durra lamaan ta dhiirti ijjumaa bira hin geyin qaba; isaan gad isiniif baasaa akka feetane godha'a. Namoota kana waan tokkolle hin godhina'a; isaan keessummoota tiyya waan te'aneef, ani isaan eeguu qaba» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN19_9","002_19_9","GEN","19","9","9","Isaan ammoo deebisanee, «Namicha alagaa kana, asii badi! Waan nuuti goonu ka nutti hintu, ati eennuu? Hantuu namoota san irratti goonu caalaa hin goona» jedhane. Isaan Loox duubatti darbanee, balbala cassiisaaf bira geyane. ");
INSERT INTO gax_vpl VALUES ("GN19_10","002_19_10","GEN","19","10","10","Namooti keessummooti sun ammoo harka ifii gad baafatanee, Loox gara manaa ol seensisanee, balbala cufane. ");
INSERT INTO gax_vpl VALUES ("GN19_11","002_19_11","GEN","19","11","11","Achiin duuba isaan worra balbala manaa duraa san diqqa'aa haga gudda'aatitti ila sipheessanee, isaan balbala dhagguu dadhabane. ");
INSERT INTO gax_vpl VALUES ("GN19_12","002_19_12","GEN","19","12","12","Achiin duuba worri keessummootaa sun Looxiin, «Qachaa kana keessaa ilmaanii fi ijoollee durraa, worra durra teeti kadhateeru yookiin fira dhibii yoo qabaatte as keessaa baasi. ");
INSERT INTO gax_vpl VALUES ("GN19_13","002_19_13","GEN","19","13","13","Nuuti addee tana balleessaarra; iyyati worra addee tanaa irratti gara Mootii Waan Maraa dhikaate guddaa waan te'eef, Mootiin Waan Maraa qachaa kana akka balleessinuuf nu ergeera» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN19_14","002_19_14","GEN","19","14","14","Achiin duuba Loox gara worra durra isaa kadhateeruu dhaqee, «Ariifadha'a, addee tana keessaa baya'a; Mootiin Waan Maraa addee tana waan balleessaaruuf qachaa kana keessaa baya'a» jedheen. Worri durra isaa kadhateeru ammoo waan taphatu itti fakkaatte. ");
INSERT INTO gax_vpl VALUES ("GN19_15","002_19_15","GEN","19","15","15","Boruyyaa barii ganama ergantooti Waaqaa sun Looxiin, «Ariifadhuu, qachaan kun yennaa badu woliin akka hin banneef, niitii teeti, ijoollee teeti ta durraa lamaan fudhadhuutii addee tanaa bayi» jedhanee Loox ariifachiisane. ");
INSERT INTO gax_vpl VALUES ("GN19_16","002_19_16","GEN","19","16","16","Loox ammoo mame; te'ulle Mootiin Waan Maraa waan isa marareef, namooti lamaan sun isa, niitii isaa, ijoollee isaa ta durraa lamaan harka qabanee qachaa keessaa akka baasanu godhe. ");
INSERT INTO gax_vpl VALUES ("GN19_17","002_19_17","GEN","19","17","17","Qachaa keessaa isaan baasaneen duuba, ergamaa Waaqaa keessaa tokkochi, «Jiruu teessan hamburatiisaaf baqadha'a; ifiin duuba hin ilaalina'a! Dhooqa keessatti eessalle'etti hin dhaabbatina'a! Akka hin duuneef gara gaaraa baqadha'a!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN19_18","002_19_18","GEN","19","18","18","Loox ammoo deebisee, «Waawwo'o, Goottota tiyya; ");
INSERT INTO gax_vpl VALUES ("GN19_19","002_19_19","GEN","19","19","19","ani tajaajilaan keessan isin duratti fudhatama dhaggadheera; jiruu tiyyalle fayyisiisaaf arjummaa guddoo naaf gootaneertan. Ani ammoo gara gaaraa baqadhee jalaa bayuu waan hin dandeenneef, badiin tun kara'atti na dhaqqaddee, ani hin du'a. ");
INSERT INTO gax_vpl VALUES ("GN19_20","002_19_20","GEN","19","20","20","Kunoo, qachaan sun itti baqatiisaaf dhikoo jira, qachaa diqqaalle'e. Akkuma isin dhaggitanu qachaa diqqa'aa motii ree? Ani achitti baqadhee jiruun tiyya akka fayyitu naaf godhi» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN19_21","002_19_21","GEN","19","21","21","Ergamaan Waaqaa deebisee, «Tole, akkuma ati jette teetu; qachaa jette sanille hin balleessu. ");
INSERT INTO gax_vpl VALUES ("GN19_22","002_19_22","GEN","19","22","22","Haga ati achi geettutti, ani womaa godhee waan hin dandeenneef, ariifadhuu, achi baqadhu» jedheen. Qachaan sun diqqaa waan te'eef, maqaan isaa, «Zo'aar» jedhame. ");
INSERT INTO gax_vpl VALUES ("GN19_23","002_19_23","GEN","19","23","23","Yennaa Loox Zo'aar gewu, aduun bayiisatti jirtiiyyu. ");
INSERT INTO gax_vpl VALUES ("GN19_24","002_19_24","GEN","19","24","24","Achiin duuba Mootiin Waan Maraa dhakaa bobe'uu fi ibidda qachoota Sodoomii fi Gomora'aa irratti ol-gubbaa irraa akka gad roobu godhe. ");
INSERT INTO gax_vpl VALUES ("GN19_25","002_19_25","GEN","19","25","25","Inni qachoota san, dhooqa san mara, namoota qachaa san keessaa maraa fi waan lafa san irratti lateeru mara balleesse. ");
INSERT INTO gax_vpl VALUES ("GN19_26","002_19_26","GEN","19","26","26","Niitiin Looxii ammoo, gara duubaa ilaaltee, soodduu sooddaa teete. ");
INSERT INTO gax_vpl VALUES ("GN19_27","002_19_27","GEN","19","27","27","Abrahaam boruyyaa barii ganama ka'ee, addee dur Mootii Waan Maraa dura dhaabbate dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN19_28","002_19_28","GEN","19","28","28","Inni gara qachaa Sodoomiitii fi Gomora'aa, gara dhooqa Yordaanosii duudii gad ilaalee, aarri akka aara barbada ibiddaa ol ka'uun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN19_29","002_19_29","GEN","19","29","29","Waaqi ammoo yennaa qachoota dhooqa Yordaanosii addee Loox le'aa ture balleesse, Abrahaam yaadatee, Loox badii hantuu san jalaa fayyise. ");
INSERT INTO gax_vpl VALUES ("GN19_30","002_19_30","GEN","19","30","30","Loox Zo'aar keessa le'uu waan sodaateef, ijoollee durraa ta ifii lamaan fudhatee, gaaratti ol bayee goda keessa le'e. ");
INSERT INTO gax_vpl VALUES ("GN19_31","002_19_31","GEN","19","31","31","Gaafa tokko intalti isaa angafittiin maandhitti'iin, «Abbaan keenna dulloomaara; akka ijoollee qabaannu, nami nu fuudhu tokkolle biyya tana hin jiru. ");
INSERT INTO gax_vpl VALUES ("GN19_32","002_19_32","GEN","19","32","32","Koy, abbaa keenna daadhii woyni'ii obaannee macheessinee, isa irraa sanyii lafa irratti hattu akka dhaggannu, isa woliin rannaa» jette. ");
INSERT INTO gax_vpl VALUES ("GN19_33","002_19_33","GEN","19","33","33","Galgala san isaan abbaa ifii daadhii woyni'ii obaasanee macheessanee, intalti angafittiin ol seentee abbaa ifii woliin ratte; inni yennaa isiin seentee ratte yookiin yennaa isiin kaatelle hin beenne. ");
INSERT INTO gax_vpl VALUES ("GN19_34","002_19_34","GEN","19","34","34","Guyyaa lammeesso'oo, intalti angafittiin intala maandhitti'iin, «Kunoo, ani eda abbaa kiyya woliin rafeera; galgala adhaalle daadhii woyni'ii isa obaannee macheessinuu ti; abbaa keenna irraa sanyii lafa irratti hattu akka dhaggannu, atille seeniitii isa woliin rafi» jette. ");
INSERT INTO gax_vpl VALUES ("GN19_35","002_19_35","GEN","19","35","35","Isaan galgala sanille abbaa ifii daadhii woyni'ii obaasanee macheessane; intalti maandhittiille kaatee, isa woliin ratte; inni yennaa isiin seente yookiin yennaa isiin kaatelle hin beenne. ");
INSERT INTO gax_vpl VALUES ("GN19_36","002_19_36","GEN","19","36","36","Akka kanaan ijoolleen durraa ta Looxii lamaanuu abbaa ifiitiif ulfootte. ");
INSERT INTO gax_vpl VALUES ("GN19_37","002_19_37","GEN","19","37","37","Intalti angafittiin ilma deettee, maqaa isaa, «Mo'aab» jettee baafatte; inni abbaa sanyii Mo'aabota ammaa ti. ");
INSERT INTO gax_vpl VALUES ("GN19_38","002_19_38","GEN","19","38","38","Intalti maandhittiille ilma deettee, maqaa isaa, «Ben-Amii» jettee baafatte; inni abbaa sanyii Amoonota ammaa ti. ");
INSERT INTO gax_vpl VALUES ("GN20_1","002_20_1","GEN","20","1","1","Abrahaam lafa le'aa ture Mamre'ee ka'ee, Qaadeshii fi Shuur wodhakkaa qubate. Qachaa Geraarii keessa alagaa te'ee yennaa le'e, ");
INSERT INTO gax_vpl VALUES ("GN20_2","002_20_2","GEN","20","2","2","Abrahaam niitii ifii Saaraa, «Isiin Obboleettii tiyya» jedhe. Abiimelekiin mootiin Geraarii tana dhage'ee, itti ergee Saaraa fudhate. ");
INSERT INTO gax_vpl VALUES ("GN20_3","002_20_3","GEN","20","3","3","Waaqi ammoo halkan oojju'uun gara Abiimelekii dhufee, «Ati sababa dubartii dhirsa qaddu fudhatteef, ati du'aarta» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN20_4","002_20_4","GEN","20","4","4","Abiimelek ammoo isii bira geyee hin jiruuyyu; maarre inni, «Goottaa kiyya, ani dhugumaan yakkaa hujee hin jiru! Anaa fi kolbaa tiyya hin balleessitaa? ");
INSERT INTO gax_vpl VALUES ("GN20_5","002_20_5","GEN","20","5","5","Abrahaamittuu, anaan, ‹Isiin obboleettii tiyya›, isi'ittuu, anaan, ‹Inni obboleessa kiyya› hin jennee? Ani wodanaa qulqullu'uun waan kana godheera; ani yakkaa hin qabu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN20_6","002_20_6","GEN","20","6","6","Achiin duuba Waaqi, oojju'uun deebisee, «Ee, akka ati wodanaa qulqullu'uun waan kana goote beekeera; tanaaf isii bira geettee akka ati na hin yakkine ka si dhoogge ana. ");
INSERT INTO gax_vpl VALUES ("GN20_7","002_20_7","GEN","20","7","7","Amma ammoo niitii namichaa isaaf deebisi. Inni raagaa waan te'eef, akka ati hin duune, si'iif hin daadimata. Yoo isii hin deebisin ammoo, dhugumaan atii fi kolbaan teeti duudiille akka duutanu beeki» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN20_8","002_20_8","GEN","20","8","8","Maarre Abiimelek barii ganamaan ka'ee, qondaaltota ifii mara wolitti waamee, waan kana mara isaanitti hime; isaanille guddoo sodaatane. ");
INSERT INTO gax_vpl VALUES ("GN20_9","002_20_9","GEN","20","9","9","Achiin duuba Abiimelek Abrahaam waamee, «Ati maaf akkas nu goote? Ani maan si yakkinaan anaa fi mootummaa tiyya irratti cubbuu guddoo akkasii fidde? Ati waan hujamu'uuf hin malle na irratti hujje» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN20_10","002_20_10","GEN","20","10","10","Ammalle Abiimelek, Abrahaamiin, «Ati maan yaaddee, waan kana goote?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN20_11","002_20_11","GEN","20","11","11","Abrahaam deebisee, «Addee tana keessa nami Waaqa sodaatu ijjumaa hin jiru; isaan niitii tiyyaaf jedhanee na ijjeesan jedhee waan yaadeef tana godhe. ");
INSERT INTO gax_vpl VALUES ("GN20_12","002_20_12","GEN","20","12","12","Karaa tokkoon, isiin dhugumaan obboleettii tiyya. Haati tiyya hin deenne malee, isiin intala abbaa kiyyaa ti; anille isii fuudhe. ");
INSERT INTO gax_vpl VALUES ("GN20_13","002_20_13","GEN","20","13","13","Yennaa Waaqi akka ani mana abbaa kiyyaatii bayee gara lafa ormaa akka ideemuu na tolche, ani isi'iin, addee dhandhe maratti, ‹Inni obboleessa kiyya› jedhiisaan waan dansaa naaf godhi» jedheeraayyu. ");
INSERT INTO gax_vpl VALUES ("GN20_14","002_20_14","GEN","20","14","14","Achiin duuba Abiimelek hoolota, loon, tajaajiltoota dhiiraatii fi dubartootaa fuudhee Abrahaamiif kenne; niitii isaa Saaraalle isaaf deebisee, ");
INSERT INTO gax_vpl VALUES ("GN20_15","002_20_15","GEN","20","15","15","«Kunoo, latti tiyya duudiin si dura jirti; addee jaalatte qubadhu» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN20_16","002_20_16","GEN","20","16","16","Saaraalle'een, «Kunoo, fuula worra si woliin jiruu mara duratti akka ati yakkaa hin qanne mirkaneessiisaaf, obboleessa keetiif meetii kuma tokko kenneera» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN20_17","002_20_17","GEN","20","17","17","Achiin duuba Abrahaam Waaqa daadimate; Waaqille Abiimelekii fi niitii isaa, tajaajiltoota isaa worra dubartootaalle fayyisee, akka isaan ijoollee deyanu godhe. ");
INSERT INTO gax_vpl VALUES ("GN20_18","002_20_18","GEN","20","18","18","Sababa Saaraa niitii Abrahaamiitiif, Mootiin Waan Maraa gadaamessa dubartoota mana Abiimelekii keessaa mara cufeeraayyu. ");
INSERT INTO gax_vpl VALUES ("GN21_1","002_21_1","GEN","21","1","1","Mootiin Waan Maraa akkuma jedhe Saaraa yaadatee, waadaa gale isi'iif muummesse. ");
INSERT INTO gax_vpl VALUES ("GN21_2","002_21_2","GEN","21","2","2","Dullummaa Abrahaamii keessa, yennaa Waaqi isatti dubbatetti, Saaraan ulfoottee ilma isaaf deette. ");
INSERT INTO gax_vpl VALUES ("GN21_3","002_21_3","GEN","21","3","3","Abrahaam ilma Saaraan isaaf deette san, «Yisihaq» jedhee maqaa baase. ");
INSERT INTO gax_vpl VALUES ("GN21_4","002_21_4","GEN","21","4","4","Ilmi isaa Yisihaq dhalatee guyyaa saddeetesso'ootitti, akkuma Waaqi ajajetti, Abrahaam haqanqabaa isa qabe. ");
INSERT INTO gax_vpl VALUES ("GN21_5","002_21_5","GEN","21","5","5","Yennaa Yisihaq dhalate, Abrahaam nama woggaa dhibbaa ti. ");
INSERT INTO gax_vpl VALUES ("GN21_6","002_21_6","GEN","21","6","6","Saaraan, «Waaqi gammadaa fi kolla naaf fideera; nami waan kana dhage'e marti na woliin hin kolla» jette. ");
INSERT INTO gax_vpl VALUES ("GN21_7","002_21_7","GEN","21","7","7","Saaraan itti dabaltee, « ‹Saaraan Abrahaamiif ijoollee deettee hin hoositti fa'a› eentu jedheera? Ani ammoo bara dullummaa isaa keessa ilma deyeef» jette. ");
INSERT INTO gax_vpl VALUES ("GN21_8","002_21_8","GEN","21","8","8","Mucaan guddatee, harma irraa gu'e; Abrahaam guyyaa Yisihaq harma irraa gu'e, jila guddoo godhe. ");
INSERT INTO gax_vpl VALUES ("GN21_9","002_21_9","GEN","21","9","9","Saaraan ammoo, ilmi Aggaarii Gibxittii sanii, ka isiin Abrahaamiif deette, ilma isi'ii Yisihaq woliin taphatuun dhaggite. ");
INSERT INTO gax_vpl VALUES ("GN21_10","002_21_10","GEN","21","10","10","Maarre Saaraan, Abrahaamiin, «Ilmi garbittii tanaa, ilma kiyya Yisihaq woliin dhaaluu waan hin malleef, garbittii tana ilma isi'ii woliin ari'i» jette. ");
INSERT INTO gax_vpl VALUES ("GN21_11","002_21_11","GEN","21","11","11","Ishimaa'elille ilmuma isaa waan te'eef, dubbiin tun guddoo Abrahaam rakkitte. ");
INSERT INTO gax_vpl VALUES ("GN21_12","002_21_12","GEN","21","12","12","Waaqi ammoo Abrahaamiin, «Marroo muca'aatii fi dubartii garbittii teetiitiif hin rakkatin; karaa Yisihaqiitiin sanyii ani waadaa sii gale waan qabaattuuf, waan Saaraan siin jettu mara godhi. ");
INSERT INTO gax_vpl VALUES ("GN21_13","002_21_13","GEN","21","13","13","Ilmi garbitti'iille ilmuma keetii waan te'eef, ani gosa guddoo isa hin godha» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN21_14","002_21_14","GEN","21","14","14","Abrahaam boruyyaa barii ganama ka'ee, daabbo'oo fi bisaan qalqallu'utti guutee dudda isi'iititti ba'achiisee, mucaalle kenneefii ari'e. Isiin achii baatee goomolee Bersheeba'aa keessa joonjite. ");
INSERT INTO gax_vpl VALUES ("GN21_15","002_21_15","GEN","21","15","15","Yennaa bisaan qalqalluu keessaa sun dhumate, Aggaar mucaa tusee takka jalatti lakkittee, ");
INSERT INTO gax_vpl VALUES ("GN21_16","002_21_16","GEN","21","16","16","haga darbata laaye'ee irraa fagaattee teettee, «Yennaa mucaan kiyya du'u, tee'ee hin ilaalu» jette. Adduma teette sanitti iyyitee bowiisa jalqadde. ");
INSERT INTO gax_vpl VALUES ("GN21_17","002_21_17","GEN","21","17","17","Waaqille iyya bowiisa muca'aa dhage'e; ergamaan Waaqaalle ol-gubba'aa Aggaar waamee, «Aggaar, maanti si rakkise? Hin sodaatin. Waaqi iyya bowiisa muca'aa dhage'eera. ");
INSERT INTO gax_vpl VALUES ("GN21_18","002_21_18","GEN","21","18","18","Ani gosa guddoo waan isa godhuuf, ka'ii mucaa habbaariitii, harka keetille'een jabeessii isa qabi» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN21_19","002_21_19","GEN","21","19","19","Achiin duuba Waaqi ila isi'ii banee boolla bisaanii dhaggite. Isiin dhaxxee, bisaan qalqallu'utti guuttee, mucaa ifiille obaatte. ");
INSERT INTO gax_vpl VALUES ("GN21_20","002_21_20","GEN","21","20","20","Akkuma mucaan guddataa deemeen Waaqi isa woliin jiraayyu; inni goomolee keessa le'ee, nama adhii guube'eetiin beekkame te'e. ");
INSERT INTO gax_vpl VALUES ("GN21_21","002_21_21","GEN","21","21","21","Inni goomolee Phaaraanii keessa le'e; haati isaalle durra worra Gibxi'ii isa fuusifatte. ");
INSERT INTO gax_vpl VALUES ("GN21_22","002_21_22","GEN","21","22","22","Yennaa san Abiimelek, ajajaa loltuu ifii Fikool woliin dhaqee, Abrahaamiin, «Waaqi waan ati hujju maraan si woliin jira. ");
INSERT INTO gax_vpl VALUES ("GN21_23","002_21_23","GEN","21","23","23","Anaa fi ijoollee tiyya yookiin sanyii tiyya akka hin sonne, akkuma ani si'iif addatame, atille anaa fi lafa alagaa teetee leetuuf addatamummaa akka mudhittu, amma asitti maqaa Waaqaatiin naa kakadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN21_24","002_21_24","GEN","21","24","24","Abrahaamille, «Tole, hin kakadha» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN21_25","002_21_25","GEN","21","25","25","Abrahaam marroo boolla bisaanii ta tajaajiltooti Abiimelekii fudhatteertuu Abiimelekitti iyyate; ");
INSERT INTO gax_vpl VALUES ("GN21_26","002_21_26","GEN","21","26","26","Abiimelekille, «Kana ka godhe eennu akka te'e ani hin beeku; ati natti hin hinne; haga adhaalle ani hin dhageenne» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN21_27","002_21_27","GEN","21","27","27","Achiin duuba Abrahaam hoolotaa fi loon fuudhee Abiimelekiif kennee, isaan lamaanuu wol gondoorane. ");
INSERT INTO gax_vpl VALUES ("GN21_28","002_21_28","GEN","21","28","28","Abrahaam goromee hoole'ee torba tika san irraa fowe. ");
INSERT INTO gax_vpl VALUES ("GN21_29","002_21_29","GEN","21","29","29","Abiimelekille, Abrahaamiin, «Goromee hoole'ee torba tana ati maaf foote?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN21_30","002_21_30","GEN","21","30","30","Abrahaam deebisee, «Akka ani boolla bisaanii tana qote dhugaa akka naaf baatu, goromee hoole'ee torba tana na irraa fudhadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN21_31","002_21_31","GEN","21","31","31","Tanaaf isaan lamaanuu achitti waan wolii kakataneef, addeen sun, «Bersheebaa» jedhante. ");
INSERT INTO gax_vpl VALUES ("GN21_32","002_21_32","GEN","21","32","32","Abrahaamii fi Abiimelek Bersheeba'atti wol gondooraneen duuba, Abiimelekii fi ajajaan loltootaa Fikool, ka'anee gara lafa Filisxeemotaa deebi'ane. ");
INSERT INTO gax_vpl VALUES ("GN21_33","002_21_33","GEN","21","33","33","Achiin duuba Abrahaam Bersheeba'atti muka «Tamariiski» jedhamu tokko dhaabee, maqaa Mootii Waan Maraa Waaqa bara baraa waammate. ");
INSERT INTO gax_vpl VALUES ("GN21_34","002_21_34","GEN","21","34","34","Abrahaam biyya Filisxeemotaa keessa alagaa te'ee yennaa hedduu le'e. ");
INSERT INTO gax_vpl VALUES ("GN22_1","002_22_1","GEN","22","1","1","Wonni kun teeteen duuba, Waaqi Abrahaam haga ilaale. Inni, «Abrahaam!» jedhee waame. Abrahaamille, «Kunoo as jira» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN22_2","002_22_2","GEN","22","2","2","Achiin duuba Waaqi, «Ilma keeti tokkochuma jaalattu san Yisihaq fuudhiitii, lafa Moriiya'aa dhaqi! Gaara ani sitti mudhisu tokko irratti ciincaa godhii isa naaf dhikeessi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN22_3","002_22_3","GEN","22","3","3","Maarre Abrahaam boruyyaa barii ganamaan ka'ee, qoraan ciincaa ittiin ciincessu caffatee, harree ifii fe'atee, ilma ifii Yisihaqii fi tajaajiltoota ifii ta dhiiraa dargaggeeyyii lamaan fudhatee, lafa Waaqi isatti hime dhaqiisaaf kara'atti baye. ");
INSERT INTO gax_vpl VALUES ("GN22_4","002_22_4","GEN","22","4","4","Guyyaa sadeesso'oo Abrahaam ol ilaalee addee san fago'otti dhagge. ");
INSERT INTO gax_vpl VALUES ("GN22_5","002_22_5","GEN","22","5","5","Achiin duuba Abrahaam tajaajiltoota dargaggeeyyii ifiitiin, «Isin harree woliin as tura'a; anii fi mucaan kiyya achi dhandhee, Waaqa waaqonfannee gara keessan hin deebina» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN22_6","002_22_6","GEN","22","6","6","Abrahaam qoraan ciincaan ittiin ciinceffamu fuudhee ilma ifii Yisihaqitti ba'achiisee, ifiif ibiddaa fi billowa qabate. Maarre isaan lamaanuu woliin ideemane. ");
INSERT INTO gax_vpl VALUES ("GN22_7","002_22_7","GEN","22","7","7","Yisihaq abbaa ifii Abrahaamiin, «Abbaa!» jedhe; innille, «Ilma kiyya, maan?» jedhe. Yisihaqille, «Ibiddii fi qoraan kunoo ti; ammoo hooleen ciincaa ciincessinu meet ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN22_8","002_22_8","GEN","22","8","8","Abrahaam deebisee, «Ilma kiyya, Waaqinuu hoolee ciincaa ciincessinu hin qopheessa» jedhe. Isaan lamaanuu woliin deemiisa itti fufane. ");
INSERT INTO gax_vpl VALUES ("GN22_9","002_22_9","GEN","22","9","9","Isaan addee Waaqi isatti mudhise san yennaa geyane, Abrahaam addee ciincaa itti ciincessanu achitti ijaaree, qoraan miidhassee irra naqee, ilma ifii Yisihaq hidhee, qoraan gubbaa irkise. ");
INSERT INTO gax_vpl VALUES ("GN22_10","002_22_10","GEN","22","10","10","Achiin duuba Abrahaam ilma ifii qaliisaaf, billowa fudhatee harka diriirfate. ");
INSERT INTO gax_vpl VALUES ("GN22_11","002_22_11","GEN","22","11","11","Ergamaan Mootii Waan Maraa ammoo ol-gubbaa irraa, «Abrahaam, Abrahaam!» jedhee isaa waame. Abrahaamille, «Kunoo as jira» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN22_12","002_22_12","GEN","22","12","12","Ergamaan Mootii Waan Maraalle, «Mucaa hin tuqin yookiin waan tokkolle isa hin godhin; ati ilma keeti tokkochuma san waan naaf hin mararfatiniif, ani akka ati Waaqa sodaattu beekeera» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN22_13","002_22_13","GEN","22","13","13","Abrahaamille adaala ifii ilaalee, korbeessa hoole'ee ka gaafi isaa haxanxari'iin qabameeru tokko dhagge. Inni dhaqee korbeessa fuudhee, addee ilma ifii ciincaa dhikeesse. ");
INSERT INTO gax_vpl VALUES ("GN22_14","002_22_14","GEN","22","14","14","Maarre Abrahaam addee san, «Yaahwee yir'ee» jedhee moggaase; adhalle namooti, «Mootiin Waan Maraa gaara irratti hin qopheessa» jedhan. ");
INSERT INTO gax_vpl VALUES ("GN22_15","002_22_15","GEN","22","15","15","Ergamaan Mootii Waan Maraa ol-gubbaa irraa yennaa lammeesso'oo Abrahaam waamee, ");
INSERT INTO gax_vpl VALUES ("GN22_16","002_22_16","GEN","22","16","16","«Mootiin Waan Maraa, ‹Ati kana waan gooteef, ilma keeti tokkochuma sanille naaf waan hin mararfatiniif, ani maqaa kiyyaan kakadheera; ");
INSERT INTO gax_vpl VALUES ("GN22_17","002_22_17","GEN","22","17","17","ani dhugumaan si hin eebbisa; sanyii teeti akka urjoota ol-gubba'aatii fi akka maansa abbaaya'aa hin baceessa. Isaan qachoota diinota ifii hin qabatan. ");
INSERT INTO gax_vpl VALUES ("GN22_18","002_22_18","GEN","22","18","18","Ati waan naaf ajajanteef, sanyii teetiin gosi biyya adda addaa marti hin eebbifaman› jedheera» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN22_19","002_22_19","GEN","22","19","19","Achiin duuba Abrahaam gara tajaajiltoota dargaggeeyyii ifii ta dhiiraa deebi'ee, isaan woliin ka'ee gara qachaa Bersheeba'aa deebi'anee achi le'e. ");
INSERT INTO gax_vpl VALUES ("GN22_20","002_22_20","GEN","22","20","20","Wonni kun teeteen duuba, Abrahaam obboleessa isaa Naahoriif, Miilkaan ijoollee akka deette dhage'e; isaanille ");
INSERT INTO gax_vpl VALUES ("GN22_21","002_22_21","GEN","22","21","21","angafichi Uz, obboleessi isaa Buus, Qamu'elii abbaa Aaramii, ");
INSERT INTO gax_vpl VALUES ("GN22_22","002_22_22","GEN","22","22","22","Kesed, Hazoo, Fiildaashi, Yiidlaafii fi Butu'el. ");
INSERT INTO gax_vpl VALUES ("GN22_23","002_22_23","GEN","22","23","23","Butu'el Ribqaa uumate; isaan kana saddeeti, Miilkaan Naahorii obboleessa Abrahaamiitiif deette. ");
INSERT INTO gax_vpl VALUES ("GN22_24","002_22_24","GEN","22","24","24","Gursumeettiin ta «Ri'umaan» jedhantulle Xebaa, Gaaham, Tahashii fi Ma'akaa Naahoriif deette. ");
INSERT INTO gax_vpl VALUES ("GN23_1","002_23_1","GEN","23","1","1","Saaraan woggaa dhibba tokkoo fi diddamii torba leete. ");
INSERT INTO gax_vpl VALUES ("GN23_2","002_23_2","GEN","23","2","2","Isiin kiriiyat-Arbaa ta «Hebroon» jedhantu, lafa Kana'aanii keessatti duute; Abrahaam isi'iif guddoo gaddee bowe. ");
INSERT INTO gax_vpl VALUES ("GN23_3","002_23_3","GEN","23","3","3","Abrahaam reeffa biraa ka'ee, worra Heetotaatiin, ");
INSERT INTO gax_vpl VALUES ("GN23_4","002_23_4","GEN","23","4","4","«Ani orma alagaa odduu teessan le'iisatti jiru; reeffa niitii tiyyaa akka itti awwaaladhu, addee awwaalaa naaf gurgura'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN23_5","002_23_5","GEN","23","5","5","Isaan deebisanee, Abrahaamiin, ");
INSERT INTO gax_vpl VALUES ("GN23_6","002_23_6","GEN","23","6","6","«Gootta'a, me nu dhage'i; ati nu oddu'utti sooressa gudda'a. Reeffa niitii teetii addee awwaalaa ta nuuti qannu keessaa ta caaltutti awwaaladhu. Nu keessaa nami tokkooyyuu lafa reeffa niitii teetii itti awwaalatu, ka si dhooggu hin jiru» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN23_7","002_23_7","GEN","23","7","7","Achiin duuba Abrahaam lafaa ka'ee, kolbaa biyya sanii, worra Heetotaatiif gad jedhee, ");
INSERT INTO gax_vpl VALUES ("GN23_8","002_23_8","GEN","23","8","8","isaaniin, «Ani reeffa niitii tiyyaa akka awwaaladhuuf fedhii teessan eega teete, Efron ilma Zohaarii ");
INSERT INTO gax_vpl VALUES ("GN23_9","002_23_9","GEN","23","9","9","lafa isaa irraa goda Makfela'aa ta irga fichaa isaa akka naa gurguru gaafadha'a. Inni gatii guutu'uun lafa awwaalaa, addee isin jirtanutti naa gurguruu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN23_10","002_23_10","GEN","23","10","10","Efroninuu addee wolgeyi'ii karra qacha'aa bira worra Heetotaa dhibii woliin tee'eeraayyu. Efroniin nama biyya Heetii kunille, Heetoti, worri achi jiranu marti adoo dhage'anuu, Abrahaamiin, ");
INSERT INTO gax_vpl VALUES ("GN23_11","002_23_11","GEN","23","11","11","«Waawwo'o, goottaa kiyya, na dhage'i. Ani ficha'aa fi goda fichaa keessaalle kolbaan tiyya duratti si'iif kenna. Reeffa niitii teetii itti awwaaladhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN23_12","002_23_12","GEN","23","12","12","Abrahaam ammoo kolbaa lafa sanii duratti gad jedhee, ");
INSERT INTO gax_vpl VALUES ("GN23_13","002_23_13","GEN","23","13","13","isaan marti adoo dhage'anuu, Efroniin, «Yoo fedhii teeti teetee, na dhageette, ani gatii ficha'aa hin kenna, anarraa fudhadhu; anille reeffa niitii tiyyaa achitti awwaaladha» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN23_14","002_23_14","GEN","23","14","14","Efron deebisee, Abrahaamiin, ");
INSERT INTO gax_vpl VALUES ("GN23_15","002_23_15","GEN","23","15","15","«Goottaa kiyya, na dhage'i; cittuun lafaa ta meetii dhibba afurii baattu si'ii fi ana oddu'utti maan isiin? Reeffa niitii teetii itti awwaaladhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN23_16","002_23_16","GEN","23","16","16","Abrahaamille dubbii Efronii fudhatee, haguma Efron adoo worri Heetota dhage'uu dubbate san, meetii dhibba afurii akkuma madaallii daldaltootaatitti madaalee kenneef. ");
INSERT INTO gax_vpl VALUES ("GN23_17","002_23_17","GEN","23","17","17","Akka kanaan latti Efronii ta Makfelaa keessaa, ta Mamree irraa gara aduun baatu jirtu, fichaan sun goda isa keessa jirtuu fi mukoota irra jiranu mara woliin dabarfamee ");
INSERT INTO gax_vpl VALUES ("GN23_18","002_23_18","GEN","23","18","18","addee worri Heetotaa duudiin karra qachaa sanii keessatti wolitti qabamane duratti qabeenna Abrahaamiif te'e. ");
INSERT INTO gax_vpl VALUES ("GN23_19","002_23_19","GEN","23","19","19","Achiin duuba, Abrahaam reeffa niitii ifii Saara'aa goda fichaa Makfelaa keessaa, ta Mamree irraa gara aduun baatu jirtu, lafa Kana'aanii Hebroon keessatti awwaale. ");
INSERT INTO gax_vpl VALUES ("GN23_20","002_23_20","GEN","23","20","20","Maarre ficha'aa fi godi fichaa keessa jirtu, ta worra Heetotaa, lafa awwaalaa, qabeenna Abrahaamii teete. ");
INSERT INTO gax_vpl VALUES ("GN24_1","002_24_1","GEN","24","1","1","Yennaa san Abrahaam guddoo dulloomeeraayyu; Mootiin Waan Maraalle waan maraan isa eebbiseera. ");
INSERT INTO gax_vpl VALUES ("GN24_2","002_24_2","GEN","24","2","2","Abrahaam namoota mana isaa keessaa tajaajilaa ifii ka irra caalaa jaarsichaa, ka waan inni qabu mara irratti baalli qabuun, «Kakatiisaaf harka keetiin gudeeda kiyya qabadhu. ");
INSERT INTO gax_vpl VALUES ("GN24_3","002_24_3","GEN","24","3","3","Ati dubartoota worra Kana'aanii worra ani odduu isaanii le'u kana keessaa, ilma kiyya akka hin fuusinneef, Mootii Waan Maraa Waaqa ol-gubba'aa fi lafaatiin si kakachiisa! ");
INSERT INTO gax_vpl VALUES ("GN24_4","002_24_4","GEN","24","4","4","Ammoo gara biyya tiyyaatii fi gosa tiyyaa deemiitii ilma kiyya Yisihaqiif niitii barbaadii fidi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_5","002_24_5","GEN","24","5","5","Ammoo tajaajilaan sun, Abrahaamiin, «Intalti na faana biyya tana dhufuu hin barbaaddu fa'a te'a; yoos ilma keeti lafa ati keessaa dhuttetti deebisuu?» jedhee gaafate. ");
INSERT INTO gax_vpl VALUES ("GN24_6","002_24_6","GEN","24","6","6","Abrahaam deebisee, «Waawwo'o, ilma kiyya akka achi hin geessine ifi eeggadhu! ");
INSERT INTO gax_vpl VALUES ("GN24_7","002_24_7","GEN","24","7","7","Mootiin Waan Maraa Waaqi ol-gubba'aa, ka mana abbaa kiyyaatii fi lafa itti dhaladhe keessaa na baasee, ‹Lafa tana sanyii teetiif hin kenna› jedhee natti dubbatee naaf kakate, inni ergamaa ifii si'iin dura hin erga; atille niitii ilma kiyyaaf achii barbaaddee hin fidda. ");
INSERT INTO gax_vpl VALUES ("GN24_8","002_24_8","GEN","24","8","8","Intalti si faana dhufiisa yoo hin fedhin ammoo, ilma kiyya achi hin geessin malee, ati kakuu tana irraa bilisa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_9","002_24_9","GEN","24","9","9","Maarre tajaajilaan sun harka ifiitiin gudeeda Abrahaamii goottaa ifii qabatee, waan Abrahaam isa gaafate san godhiisaaf kakate. ");
INSERT INTO gax_vpl VALUES ("GN24_10","002_24_10","GEN","24","10","10","Achiin duuba tajaajilaan sun gaalota goottaa ifii keessaa kudhan fuudhee, kennansa dadansaa goottaa ifii itti fe'ee, gara qachaa Naahor keessa le'uu, Aaram biyya bisaan lama oddu'uu dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN24_11","002_24_11","GEN","24","11","11","Inni yennaa achi geye, qacha'aan alatti gaalota boolla bisaanii takka biratti jijilbiissise; yennaan sunille gara galgalaa yennaa dubartooti bisaan woraabbatiisaaf baatu. ");
INSERT INTO gax_vpl VALUES ("GN24_12","002_24_12","GEN","24","12","12","Inni daadimatee, «Mootii Waan Maraa, Waaqa goottaa kiyya Abrahaamii, adha yaada kiyya naa guutii, goottaa kiyya Abrahaamiifille jaalala keeti ka bara baraa mudhisi. ");
INSERT INTO gax_vpl VALUES ("GN24_13","002_24_13","GEN","24","13","13","Kunoo, ani boolla bisaanii tana bira dhaabbatiisatti jira; durri kolbaa qachaa kanaalle bisaan woraabbatiisaaf as dhufiisatti jiran. ");
INSERT INTO gax_vpl VALUES ("GN24_14","002_24_14","GEN","24","14","14","Isaan keessaa takkatti'iin, ‹Maganne'ee, bisaan unaa, okkotee teeti gad naaf qabi› hin jedhaan; isiille, ‹Uni, ani gaalota keetille hin obaasa› yoo anaan jette, isiin tun ta ati garbicha keeti Yisihaqiif filatte teetuu ti. Tanaan ani akka ati jaalala keeti ka bara baraa goottaa kiyya Abrahaamiif mudhitte hin beeka» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_15","002_24_15","GEN","24","15","15","Inni adoo daadimatee hin fixinuu, Ribqaan okkotee ba'attee dhutte; isiin intala Batu'elii ti; Batu'el ilma Naahorii obboleessa Abrahaamii ti; haati isaa Miilka'a. ");
INSERT INTO gax_vpl VALUES ("GN24_16","002_24_16","GEN","24","16","16","Isiin durra banti'ii, guddoo shaggitti'i; nami tokkolle isii bira geyee hin jiru. Isiin gara boolla bisaanii gad buutee, okkotee ifii guutattee ol deebite. ");
INSERT INTO gax_vpl VALUES ("GN24_17","002_24_17","GEN","24","17","17","Achiin duuba tajaajilaan sun ariiti'iin gara isi'ii dhaqee, «Maganne'ee, okkotee teeti keessaa bisaan diqqaa isaa na obaas» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_18","002_24_18","GEN","24","18","18","Isiin, «Goottaa kiyya, uni» jettee, ariifattee okkotee ifii harkatti gad buufattee, isa obaatte. ");
INSERT INTO gax_vpl VALUES ("GN24_19","002_24_19","GEN","24","19","19","Inni dheebuu bayeen duuba, isiin, «Gaalota keetiifille haga isaan dheebuu bayanutti hin woraabaaf» jetteen. ");
INSERT INTO gax_vpl VALUES ("GN24_20","002_24_20","GEN","24","20","20","Maarre isiin ariifattee bisaan okkotee keessaa goonga'atti naxxee, haga gaaloti isaa dheebuu bayanutti, ammalle woraabiisaaf gara boollaa rukkitte. ");
INSERT INTO gax_vpl VALUES ("GN24_21","002_24_21","GEN","24","21","21","Namichille, waan inni dhaqeef, akka Mootiin Waan Maraa isaaf milkeesse mirkaneeffatiisaaf, cadhisee isii ilaale. ");
INSERT INTO gax_vpl VALUES ("GN24_22","002_24_22","GEN","24","22","22","Gaaloti isaa yennaa dheebuu bayane, qubee worqi'ii gara giraama shanii teetu, ta funnaanitti keyatanu, irmuura worqi'ii lama ka gara giraama dhibba tokkoo fi kudhan te'u akka harkatti keyattuuf fuudhee, ");
INSERT INTO gax_vpl VALUES ("GN24_23","002_24_23","GEN","24","23","23","«Ati intala eennuu ti? Maganne'ee natti himi; anii fi worri na woliin jiru akka bulluuf mana abbaa keetii keessa addeen bulti'ii jirtii?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_24","002_24_24","GEN","24","24","24","Isiin deebittee, «Ani intala Batu'elii ti; inni ilma Miilkaan Naahoriif deette» jette. ");
INSERT INTO gax_vpl VALUES ("GN24_25","002_24_25","GEN","24","25","25","Isiin itti dabaltee, «Nuuti hicaace'ee fi buuyyoo okeyaa bacaa, addee bulti'iille hin qanna» jette. ");
INSERT INTO gax_vpl VALUES ("GN24_26","002_24_26","GEN","24","26","26","Achiin duuba namichi gad jedhee Mootii Waan Maraatiif sagadee, ");
INSERT INTO gax_vpl VALUES ("GN24_27","002_24_27","GEN","24","27","27","«Mootiin Waan Maraa addatamumma'aa fi jaalala ifii ka bara baraa goottaa kiyya Abrahaamiif eege, Waaqi goottaa kiyya Abrahaamii leellifamuu ti. Ideensa kiyya irratti na sooressee gara mana worra goottaa kiyya Abrahaamii ka na fide isa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_28","002_24_28","GEN","24","28","28","Achiin duuba intalti rukkittee, waan te'e mara namoota mana haadha isi'iititti hinte. ");
INSERT INTO gax_vpl VALUES ("GN24_29","002_24_29","GEN","24","29","29","Ribqaan obboleessa, «Laabaan» jedhamu tokko qaddiiyyu; inni gara namicha addee boolla bisaanii jiruu rukke'een bayee, ");
INSERT INTO gax_vpl VALUES ("GN24_30","002_24_30","GEN","24","30","30","qubee funnaaniitii fi irmuura harka obboleettii ifii irratti dhaggee, waan namichi isi'iin jedhelle hintuun dhage'ee, gara namichaa dhaqee boolla bisaanii cinaa gaalota bira dhaabbatuun isa dhagge. ");
INSERT INTO gax_vpl VALUES ("GN24_31","002_24_31","GEN","24","31","31","Laabaan, namichaan, «Ati nama Mootiin Waan Maraa eebbise, koy gara manaa dhandhaa, maaf ala as dhaabbatta? Si'iif mana qopheesseera; gaalota keetille'eef addee qopheesseera» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_32","002_24_32","GEN","24","32","32","Maarre namichi gara manaa dhaqe; Laabaalle fe'iisa gaalota irraa hiikee, hicaace'ee fi buuyyoo okeyaa kenneef. Achiin duuba namichaa fi worra isa woliin jiranuuf bisaan miilaa kenne. ");
INSERT INTO gax_vpl VALUES ("GN24_33","002_24_33","GEN","24","33","33","Yennaa sagaleen dhikaate, namichi ammoo, «Waan dhufeef haga himutti hin nyaadhu» jedhe. Laabaan, «Nutti himi ree» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN24_34","002_24_34","GEN","24","34","34","Maarre inni, «Ani tajaajilaa Abrahaamii ti. ");
INSERT INTO gax_vpl VALUES ("GN24_35","002_24_35","GEN","24","35","35","Mootiin Waan Maraa waan maraan goottaa kiyya guddoo eebbisee duroonseera. Inni hoole'ee fi re'ee, loon, meeti'ii fi worqii, tajaajiltoota dhiiraatii fi dubarti'ii, gaalotaa fi harreelee isaaf kenneera. ");
INSERT INTO gax_vpl VALUES ("GN24_36","002_24_36","GEN","24","36","36","Saaraan niitiin goottaa kiyyaalle dullummaa keessa ilma isaaf deetteerti; goottaan kiyyalle waan qabu mara ilma saniif kenneera. ");
INSERT INTO gax_vpl VALUES ("GN24_37","002_24_37","GEN","24","37","37","Goottaan kiyya na kakachiisee, ‹Lafa Kana'aanii, ta ani keessa le'u keessaa ilma kiyya niitii hin fuusisin; ");
INSERT INTO gax_vpl VALUES ("GN24_38","002_24_38","GEN","24","38","38","ammoo gara kolbaa abbaa kiyyaa, gara fira kiyyaa dhaqiitii, niitii ilma kiyyaaf fidi› jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_39","002_24_39","GEN","24","39","39","Anille goottaa kiyyaan, ‹Yoo intalti na faana dhufuu dhadde maan godha?› jedhee gaafadhe. ");
INSERT INTO gax_vpl VALUES ("GN24_40","002_24_40","GEN","24","40","40","Inni deebisee, ‹Mootiin Waan Maraa ka ani yennaa mara tajaajile, ergamaa ifii si woliin ergee ideensa keeti hin milkeessa, atille kolbaa abbaa kiyyaatii fi fira kiyya keessaa ilma kiyyaaf niitii hin fidda. ");
INSERT INTO gax_vpl VALUES ("GN24_41","002_24_41","GEN","24","41","41","Ati yennaa gara fira kiyyaa dhaxxee, yoo isaan intala sitti kennuu didanelle, ati kakuu tiyya irraa bilisa hin teeta› anaan jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_42","002_24_42","GEN","24","42","42","«Ani adha gara boolla bisaanii yennaa dhufe, ‹Mootii Waan Maraa, Waaqa Abrahaamii goottaa kiyyaa, yoo fedha keeti teete, waan ani dhufeef kana naa milkeessi. ");
INSERT INTO gax_vpl VALUES ("GN24_43","002_24_43","GEN","24","43","43","Ani boolla bisaanii bira as dhaabbatiisatti jira; intala bisaan woraabbatiisaaf dhuttu takkaan, «Maganne'ee okkotee teeti keessaa bisaan diqqaa isaa na obaas» jedhee hin gaafadha; ");
INSERT INTO gax_vpl VALUES ("GN24_44","002_24_44","GEN","24","44","44","isiille anaan, «Uni, gaalota keetille'eef hin woraaba» yoo jette, isiin ta Mootiin Waan Maraa ilma goottaa kiyyaatiif file teetuu ti› jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_45","002_24_45","GEN","24","45","45","Ani gadhaa kiyya keessatti daadimadhee adoo hin fixinuu, Ribqaan okkotee ifii ba'atte dhutte; isiin gara boolla bisaanii gad dhaxxee bisaan woraabbatte. Anille isi'iin, ‹Maganne'ee bisaan na obaas› jedheen. ");
INSERT INTO gax_vpl VALUES ("GN24_46","002_24_46","GEN","24","46","46","Isiin ariifattee okkotee ifi irraa gad buufattee, ‹Uni, gaalota keetille hin obaasa› jette. Maarre ani unee, isiin gaalotalle obaatte. ");
INSERT INTO gax_vpl VALUES ("GN24_47","002_24_47","GEN","24","47","47","Ani, ‹Ati intala eennuu ti?› jedhee gaafannaan, isiin, ‹Ani intala Batu'elii ilma Naahorii ti; haati isaa Miilka'a› jette. Achiin duuba ani qubee funnaan isi'iititti, irmuura harkatti keyee, ");
INSERT INTO gax_vpl VALUES ("GN24_48","002_24_48","GEN","24","48","48","gad jedhee Mootii Waan Maraatiif sagade. Mootii Waan Maraa, Waaqa Abrahaamii goottaa kiyyaa, ka intala obboleessa goottaa kiyyaa fuudhee ilma isaatiif akka ani geessuuf na sooresse leellise. ");
INSERT INTO gax_vpl VALUES ("GN24_49","002_24_49","GEN","24","49","49","Amma, gadhi-laafumma'aa fi addatamummaa goottaa kiyyatti yoo mudhittanu teete, natti hima'a; yoo hin mudhinne teetelle natti hima'a; anille waan godhu hin murteeffadha» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_50","002_24_50","GEN","24","50","50","Achiin duuba Laabaanii fi Batu'el, «Wonni kun Mootii Waan Maraa irraa waan dhutteef, nuuti waan tokkolle jedhiisa hin dandeennu. ");
INSERT INTO gax_vpl VALUES ("GN24_51","002_24_51","GEN","24","51","51","Kunoo, Ribqaan fuula keeti dura jirti; fudhadhuu deemi. Akkuma Mootiin Waan Maraa dubbate, isiin niitii ilma goottaa keetii teetuu ti» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN24_52","002_24_52","GEN","24","52","52","Tajaajilaan Abrahaamii sun yennaa waan isaan jedhane kana dhage'e, gad jedhee Mootii Waan Maraatiif sagade. ");
INSERT INTO gax_vpl VALUES ("GN24_53","002_24_53","GEN","24","53","53","Achiin duuba tajaajilaan Abrahaamii faaya meeti'iitii fi worqi'iitii, woyootalle fidee Ribqa'aaf kenne; inni kennansa gatii guddo'oo obboleessa isi'iitii fi haadha isi'iitiif kenne. ");
INSERT INTO gax_vpl VALUES ("GN24_54","002_24_54","GEN","24","54","54","Achiin duuba innii fi namooti isa woliin jiranu nyaatanee unanee, achuma bulane. Isaan yennaa boruyyaa ganama ka'ane, tajaajilaan Abrahaamii, «Gara goottaa kiyyaa akka deebi'u, na geegessa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN24_55","002_24_55","GEN","24","55","55","Obboleessi isi'iitii fi haati isi'ii ammoo, «Intalti guyyuma kudhan nu woliin turtuu ti; achiin duuba deemuu dandeetti» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN24_56","002_24_56","GEN","24","56","56","Inni ammoo isaaniin, «Eega Mootiin Waan Maraa deemmaa tiyya naa milkeesse, na hin tursina'a; gara goottaa kiyyaa akka dhaquuf na geegessa'a» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN24_57","002_24_57","GEN","24","57","57","Isaan deebisanee, «Me, intala waannee waan isiin jettu gaafanna» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN24_58","002_24_58","GEN","24","58","58","Maarre isaan Ribqaa waamanee, «Namicha kana woliin hin deentaa?» jedhanee gaafatane. Isiin, «Ee, hin deema» jette. ");
INSERT INTO gax_vpl VALUES ("GN24_59","002_24_59","GEN","24","59","59","Maarre isaan Ribqaa obboleettii isaanii, guddittuu isi'ii woliin, tajaajilaa Abrahaamiille namoota isaa woliin geegessane. ");
INSERT INTO gax_vpl VALUES ("GN24_60","002_24_60","GEN","24","60","60","Isaan, Ribqaa eebbisanee, «Obboleettii teenna, haadha kuma heddu'uu te'i; sanyiin teeti qachaa diinota ifii qabatanuu ti» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN24_61","002_24_61","GEN","24","61","61","Achiin duuba Ribqa'aa fi durri tajaajiltooti isi'ii gaala ifii irra tee'anee, tajaajilaa Abrahaamii woliin deemiisaaf ka'ane. Maarre inni Ribqaa fuudhee deeme. ");
INSERT INTO gax_vpl VALUES ("GN24_62","002_24_62","GEN","24","62","62","Yisihaq yennaa san gara boolla bisaanii ta, «Be'er-Lahaayi-Ro'i» jedhantuu dhufee, lafa goomolee «Negeb» jedhantu keessa le'iisatti jiraayyu. ");
INSERT INTO gax_vpl VALUES ("GN24_63","002_24_63","GEN","24","63","63","Inni gaafa tokko galgala alatti bayee, yaadaan qabamee adoo deemuu, gaalota dhufiisatti jiranu dhagge. ");
INSERT INTO gax_vpl VALUES ("GN24_64","002_24_64","GEN","24","64","64","Ribqaalle yennaa Yisihaq dhaggite, gaala ifii irraa gad buutee, ");
INSERT INTO gax_vpl VALUES ("GN24_65","002_24_65","GEN","24","65","65","«Namichi diida keessa as nutti dhufiisatti jiru sun eennu?» jettee tajaajilaa Abrahaamii gaafatte. Tajaajilaan deebisee, «Inni ilma goottaa kiyyaa ti» jedhe. Maarre isiin shaashii ifii fudhattee fuula ifii buqatte. ");
INSERT INTO gax_vpl VALUES ("GN24_66","002_24_66","GEN","24","66","66","Tajaajilaalle waan godhe mara Yisihaqitti hime. ");
INSERT INTO gax_vpl VALUES ("GN24_67","002_24_67","GEN","24","67","67","Achiin duuba Yisihaq isii fidee gara dunkaana Saaraa haadha ifii seensifate. Inni Ribqaa fuudhee, isiille niitii isaa teete; inni isii jaalatee, gadda haadha ifii irralle'ee jajjabaate. ");
INSERT INTO gax_vpl VALUES ("GN25_1","002_25_1","GEN","25","1","1","Abrahaam niitii dhibii ta, «Qexuuraa» jedhantu fuudhe. ");
INSERT INTO gax_vpl VALUES ("GN25_2","002_25_2","GEN","25","2","2","Isiin Zimraan, Yokshaan, Medaan, Miidiyaan, Ishibaakii fi Shuwaa isaaf deette. ");
INSERT INTO gax_vpl VALUES ("GN25_3","002_25_3","GEN","25","3","3","Yokshaan Sheeba'aa fi Dedaan uumate; sanyii Dedaanii Ashuriim, Letushiimii fi Le'umiim. ");
INSERT INTO gax_vpl VALUES ("GN25_4","002_25_4","GEN","25","4","4","Ilmaan Miidiyaanii Efaa, Efer, Henok, Abiidaa fi Elda'a. Isaan kun martinuu ilmaan Qexuura'aa ti. ");
INSERT INTO gax_vpl VALUES ("GN25_5","002_25_5","GEN","25","5","5","Abrahaam waan qabu mara Yisihaqiif kenne. ");
INSERT INTO gax_vpl VALUES ("GN25_6","002_25_6","GEN","25","6","6","Ammoo adoo jiruu, ilmaan dubartooti dhibiin isaa deetteef kennansa kenneefii, gara lafa baya adu'uu Yisihaq irraa akka isaan fagaatanu godhe. ");
INSERT INTO gax_vpl VALUES ("GN25_7","002_25_7","GEN","25","7","7","Barri Abrahaam le'e woggaa dhibbaa fi torbaatamii shan. ");
INSERT INTO gax_vpl VALUES ("GN25_8","002_25_8","GEN","25","8","8","Abrahaam guddoo dulloomee, baralle quufee, gara worra isaa ka addee dhuga'aa jiruu gale. ");
INSERT INTO gax_vpl VALUES ("GN25_9","002_25_9","GEN","25","9","9","Ilmaan isaa Yisihaqii fi Ishimaa'el goda Makfela'aa fichaa Efronii ilma Zohaarii Heetichaa, ka Mamree irraa gara aduun baatuu san keessatti isa awwaalane. ");
INSERT INTO gax_vpl VALUES ("GN25_10","002_25_10","GEN","25","10","10","Abrahaam fichaa san worra Heetotaa irraa bitate; inni niitii ifii Saaraa biratti achitti awwaalame. ");
INSERT INTO gax_vpl VALUES ("GN25_11","002_25_11","GEN","25","11","11","Abrahaam du'een duuba Waaqi ilma isaa Yisihaq eebbise. Yisihaqille «Be'er-Lahaayi-Ro'i» addee jedhantu baleessa bisaanii bira le'e. ");
INSERT INTO gax_vpl VALUES ("GN25_12","002_25_12","GEN","25","12","12","Hiddi dhaloota sanyii Ishimaa'elii, ta Aggaariin nama biyya Gibxi'ii, tajaajiltuun Saara'aa, Abrahaamiif deette, ");
INSERT INTO gax_vpl VALUES ("GN25_13","002_25_13","GEN","25","13","13","ilmaan Ishimaa'el uumate, akka gogeessa dhaloota isaaniititti asii gaditti galmowaneeran. Isaanille ilma Ishimaa'elii angaficha Nabaayoot, Qedaar, Adbi'el, Miibsaam, ");
INSERT INTO gax_vpl VALUES ("GN25_14","002_25_14","GEN","25","14","14","Miishimaa, Dumaa, Maasaa, ");
INSERT INTO gax_vpl VALUES ("GN25_15","002_25_15","GEN","25","15","15","Hadaad, Temaa, Yetuur, Nafiishii fi Qedimaas. ");
INSERT INTO gax_vpl VALUES ("GN25_16","002_25_16","GEN","25","16","16","Ilmaan Ishimaa'elii tun, abbootii gosa kudhanii lamaa ti; maqaan isaanii ollootaa fi addee quttuma isaaniitiin waamama. ");
INSERT INTO gax_vpl VALUES ("GN25_17","002_25_17","GEN","25","17","17","Ishimaa'el woggaa dhibbaa fi soddomii torba le'ee du'e. ");
INSERT INTO gax_vpl VALUES ("GN25_18","002_25_18","GEN","25","18","18","Sanyiin Ishimaa'elii biyya Gibxii irraa gara aduun baatu, karaa Asoor geessu, Awiila'aa fi Shuur odduu le'ane; isaan sanyii Abrahaamii dhibii woliin diinumma'aan wol irraa fagaatanee le'aniiyyu. ");
INSERT INTO gax_vpl VALUES ("GN25_19","002_25_19","GEN","25","19","19","Hiddi dhaloota sanyii Yisihaqii ilma Abrahaamii kana: Abrahaam Yisihaq uumate. ");
INSERT INTO gax_vpl VALUES ("GN25_20","002_25_20","GEN","25","20","20","Yisihaqille nama woggaa afurtamaa yennaa te'e, Ribqaa fuudhe; isiin intala Batu'elii, obboleettii Laabaanii worra Sooriya'aa ka Aaram biyya bisaan lama oddu'uu keessa le'uu ti. ");
INSERT INTO gax_vpl VALUES ("GN25_21","002_25_21","GEN","25","21","21","Ribqaan maseena waan teeteef, Yisihaq marroo isi'iitiif Mootii Waan Maraa daadimate. Mootiin Waan Maraalle daadimata isaa dhage'ee, niitiin isaa Ribqaan ulfootte. ");
INSERT INTO gax_vpl VALUES ("GN25_22","002_25_22","GEN","25","22","22","Isiin lakkuu waan ulfootteef, Annoolleen gadhaa isi'ii keessatti wol dhiibane; isiille, «Wonni akkasii maaf na irratti teete?» jettee, Mootii Waan Maraa gaafatte. ");
INSERT INTO gax_vpl VALUES ("GN25_23","002_25_23","GEN","25","23","23","Mootiin Waan Maraa si'iin, «Gosa biyya adda addaa lamatti gadaamessa keeti keessa jira; isaan woliif diina hin te'an. Gosi takkaan taan caalaa hin jabaatti; angafi maandhicha hin tajaajila» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN25_24","002_25_24","GEN","25","24","24","Yennaan isiin deettu geennaan, Rebqaan lakkuu deette. ");
INSERT INTO gax_vpl VALUES ("GN25_25","002_25_25","GEN","25","25","25","Ka dura dhalate diimaa, nafi isaa duudiin woyaa dabbasittii waan fakkaattuuf, maqaa isaa, «Esaawuu» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN25_26","002_25_26","GEN","25","26","26","Annuun lammeesso'oo yennaa dhalate, jimuu Esaawuu waan qabateeruuf, maqaa isaa, «Yaaqoob» jedhane. Yennaa isaan dhalatane san Yisihaq nama woggaa jaatamaa ti. ");
INSERT INTO gax_vpl VALUES ("GN25_27","002_25_27","GEN","25","27","27","Ijoolleen yennaa guddatte, Esaawu nama adamoo beeku, ka ala oolu te'e; Yaaqoob ammoo nama cadhisaa qe'ee oolu te'e. ");
INSERT INTO gax_vpl VALUES ("GN25_28","002_25_28","GEN","25","28","28","Yisihaq, bineensa Esaawu adamsee ijjeesu waan nyaatuuf isa jaalate; Ribqaan ammoo Yaaqoob jaalatte. ");
INSERT INTO gax_vpl VALUES ("GN25_29","002_25_29","GEN","25","29","29","Gaafa tokko Yaaqoob unata bilcheeffatuun, Esaawu guddoo beelowee adamoo irraa dhufee, ol seenee, ");
INSERT INTO gax_vpl VALUES ("GN25_30","002_25_30","GEN","25","30","30","Yaaqoobiin, «Ani waan gaggabeeruuf, unata diimaa kana irraa naa kenni» jedhe. Tanaaf inni, «Edoom» jedhame. ");
INSERT INTO gax_vpl VALUES ("GN25_31","002_25_31","GEN","25","31","31","Yaaqoob deebisee, «Ati dursii angafummaa teeti natti gurgur» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN25_32","002_25_32","GEN","25","32","32","Esaawulle, «Kunoo, ani amma beelaan du'aara; angafummaan tun maan naa gooti» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN25_33","002_25_33","GEN","25","33","33","Yaaqoob ammoo, «Dursii naa kakadhu» jedhe. Maarre inni isaaf kakatee angafummaa ifii Yaaqoobitti gurgurate. ");
INSERT INTO gax_vpl VALUES ("GN25_34","002_25_34","GEN","25","34","34","Achiin duuba Yaaqoob daabbo'oo fi ittoo san kenneefii, inni nyaatee unee, ka'ee deeme. Akka kanaan Esaawu angafummaa ifii tuffate. ");
INSERT INTO gax_vpl VALUES ("GN26_1","002_26_1","GEN","26","1","1","Beela bara Abrahaamii biyyatti buute malee, beelti dhibiin biyyatti buute. Yisihaqille gara Abiimelekii mootii Filisxeemotaa, qachaa Geraarii dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN26_2","002_26_2","GEN","26","2","2","Mootiin Waan Maraa Yisihaqitti mudhatee, «Lafa ani akka ati keessa leetu sitti himu keessa le'i malee, gara biyya Gibxi'ii gad hin bu'in. ");
INSERT INTO gax_vpl VALUES ("GN26_3","002_26_3","GEN","26","3","3","Lafuma tana keessa turi! Anille si woliin hin jiraadha; si'ille hin eebbisa. Ani lafa tana mara si'ii fi sanyii teetii kennee, kakuu abbaa keeti Abrahaamiif kakadhe hin muummessa. ");
INSERT INTO gax_vpl VALUES ("GN26_4","002_26_4","GEN","26","4","4","Ani sanyii teeti akka urjoota gubba'aa baceessee, lafa tana maralle isaanii hin kenna; gosi adda addaa ta lafa irraa martinuu karaa sanyii teetiitiin hin eebbifanti. ");
INSERT INTO gax_vpl VALUES ("GN26_5","002_26_5","GEN","26","5","5","Sababa Abrahaam naaf ajajamee, ajaja kiyya, seerata kiyyaa fi seera kiyya eegateef, ani si hin eebbisa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN26_6","002_26_6","GEN","26","6","6","Maarre Yisihaq Geraar keessa le'e. ");
INSERT INTO gax_vpl VALUES ("GN26_7","002_26_7","GEN","26","7","7","Namooti addee sanii marroo niitii isaa yennaa isa gaafatane, «Isiin obboleettii tiyya» jedhe; isiin dansittii waan teeteef, namooti addee sanii Ribqa'aaf jedhanee na ijjeesan jedhee, «Isiin niitii tiyya» jedhuu sodaate. ");
INSERT INTO gax_vpl VALUES ("GN26_8","002_26_8","GEN","26","8","8","Yisihaq yennaa hedduu achi tureen duuba, gaafa tokko mootiin Filisxeemotaa Abiimelek foddaa manaatiin gad ilaalee, Yisihaq niitii ifii Ribqa'atti riiqatuun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN26_9","002_26_9","GEN","26","9","9","Tanaaf Abiimelek isa waansisee, «Dhugumaan isiin niitii teeti! Ati maaf, ‹Isiin obboleettii tiyya› jette ree?» jedhee isa gaafate. Inni deebisee, «Sababa isi'iitiif na ijjeesan jedhee yaadee ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN26_10","002_26_10","GEN","26","10","10","Abiimelekille, «Wonni ati nu irratti hujje kun maan? Namoota keessaa tokko niitii teeti woliin silaa diqquma hin rafin hafe; nu'ulle yakkaameyyii gootee dhadde» jedhe ");
INSERT INTO gax_vpl VALUES ("GN26_11","002_26_11","GEN","26","11","11","Achiin duuba Abiimelek, ajaja baasee, «Eennulle namicha kana yookiin niitii isaalle yoo tuqe ijjeefamuu ti» jedhee namoota mara ifi eeggachiise. ");
INSERT INTO gax_vpl VALUES ("GN26_12","002_26_12","GEN","26","12","12","Yisihaq lafa sanitti midhaan facaasee, wogguma san dachaa dhibba galfate; Mootiin Waan Maraa waan isa eebbiseef, ");
INSERT INTO gax_vpl VALUES ("GN26_13","002_26_13","GEN","26","13","13","inni dureessa te'ee, haga guddoo tujaara te'utti tujaarummaan isaa ittuma guddataa ideente. ");
INSERT INTO gax_vpl VALUES ("GN26_14","002_26_14","GEN","26","14","14","Inni loon, hoolota, re'ootaa fi tajaajiltoota hedduu waan qabuuf, worri Filisxeemotaa isa hinaafe. ");
INSERT INTO gax_vpl VALUES ("GN26_15","002_26_15","GEN","26","15","15","Tanaaf isaan boolla bisaanii ta adoo abbaan Yisihaqii Abrahaam jiruu, tajaajiltooti Abrahaamii qotane mara biyyee itti guutanee duuchane. ");
INSERT INTO gax_vpl VALUES ("GN26_16","002_26_16","GEN","26","16","16","Achiin duuba Abiimelek, Yisihaqiin, «Ati nu caalaa guddoo hunnaamessa teeteerta, nu irraa deem» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN26_17","002_26_17","GEN","26","17","17","Maarre Yisihaq achii deemee, dhooqa Geraarii keessa qubatee, achi le'e. ");
INSERT INTO gax_vpl VALUES ("GN26_18","002_26_18","GEN","26","18","18","Yisihaq boolla bisaanii ta tajaajiltooti Abrahaamii abbaa isaa qotaneeranu, ta worri Filisxeemotaa Abrahaam du'een duuba duuchane, deebisee qochisiisee, maquma abbaan isaa dur baase innille itti baase. ");
INSERT INTO gax_vpl VALUES ("GN26_19","002_26_19","GEN","26","19","19","Tajaajiltooti Yisihaqii dhooqa san keessa qotanee madda bisaanii dhaggatane. ");
INSERT INTO gax_vpl VALUES ("GN26_20","002_26_20","GEN","26","20","20","Tissitooti worra Geraarii, «Bisaan kun keenna» jedhanee, tissitoota Yisihaqii woliin wol falmane. Waan isaan bisaan wol falmaneef, Yisihaq maqaa boolla bisaanii san, «Eseeq» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("GN26_21","002_26_21","GEN","26","21","21","Achiin duuba tissitooti Yisihaqii boolla bisaanii dhibii qotanee, isii irralle'etti falmii kaasane; maarre Yisihaq boolla bisaanii san, «Sixinaa» jedhee, maqaa baase. ");
INSERT INTO gax_vpl VALUES ("GN26_22","002_26_22","GEN","26","22","22","Inni achi irra dabaree boolla bisaanii dhibii qochisiise; isii irratti isaan wol falmii hin kaanne. Maarre inni boolla bisaanii san, «Amma Mootiin Waan Maraa addee badhoo nuu kenneera; nuutille lafa tana keessatti hin horra» jedhee, maqaa boolla bisaanii san, «Rehobot» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("GN26_23","002_26_23","GEN","26","23","23","Yisihaq achii ka'ee, gara qachaa Bersheeba'aatitti ol baye. ");
INSERT INTO gax_vpl VALUES ("GN26_24","002_26_24","GEN","26","24","24","Mootiin Waan Maraa gaafuma san halkan, isatti mudhatee, «Ani Waaqa abbaa keeti Abrahaamii ti; ani si woliin waan jiruuf, hin sodaatin. Tajaajilaa kiyya Abrahaamiif jedhee si hin eebbisa; sanyii teetille hin baceessa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN26_25","002_26_25","GEN","26","25","25","Maarre Yisihaq achitti addee ciinca'aa ijaaree, maqaa Mootii Waan Maraa waammate; inni achitti qubatee, tajaajiltooti isaalle boolla bisaanii achitti qotane. ");
INSERT INTO gax_vpl VALUES ("GN26_26","002_26_26","GEN","26","26","26","Achiin duuba Abiimelek, gorsaa ifii Ahuzaatii fi ajajaa loltoota ifii Fikool woliin qachaa Geraariitii bayee gara Yisihaqii dhufe. ");
INSERT INTO gax_vpl VALUES ("GN26_27","002_26_27","GEN","26","27","27","Yisihaq isaaniin, «Ana jibbitanee eega na ariitane, isin maaf gara kiyya dhuttane ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN26_28","002_26_28","GEN","26","28","28","Isaan deebisanee, «Mootiin Waan Maraa akka si woliin jiru qulleeffannee dhaggineerra; tanaaf kaku'uun wolii galtee godhatuu barbaanna. Gondooroon si woliin nuuti godhuu barbaannu ");
INSERT INTO gax_vpl VALUES ("GN26_29","002_26_29","GEN","26","29","29","akkuma nuuti adoo si hin tuqin, waan dansaa sii goonee, nageyaan si lakkinne, akka atille nu hin miine. Amma Mootiin Waan Maraa si eebbiseera» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN26_30","002_26_30","GEN","26","30","30","Achiin duuba Yisihaq sagalee isaaniif qopheessee, isaanille nyaatanee unane. ");
INSERT INTO gax_vpl VALUES ("GN26_31","002_26_31","GEN","26","31","31","Boruyyaa bari'iin ganama ka'anee, woliif kakatane; Yisihaqille isaan geegessee, nageyaan isa biraa deemane. ");
INSERT INTO gax_vpl VALUES ("GN26_32","002_26_32","GEN","26","32","32","Guyyuma san tajaajiltooti Yisihaqii dhufanee, marroo boolla bisaanii ta qotane sanii isatti himanee, «Bisaan dhaggineerra» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN26_33","002_26_33","GEN","26","33","33","Inni boolla bisaanii san, «Sheebaa» jedhee maqaa baase. Maqaan qachaa sanii tanaaf haga adhaa, «Bersheebaa» jedhamee waamama. ");
INSERT INTO gax_vpl VALUES ("GN26_34","002_26_34","GEN","26","34","34","Esaawu yennaa woggaa afurtama geye, Yoditii intala Berii nama gosa Heetiitii fi Basmaatii intala Eloonii nama gosa Heetii fuudhe. ");
INSERT INTO gax_vpl VALUES ("GN26_35","002_26_35","GEN","26","35","35","Dubartooti tun Yisihaqii fi Ribqa'atti gadda guddaa fidane. ");
INSERT INTO gax_vpl VALUES ("GN27_1","002_27_1","GEN","27","1","1","Yisihaq dulloomee yennaa ilti isaa baararroottetti, ilma isaa angaficha Esaawu waamee, «Ilma kiyya» jedheen. Innille deebisee, «Kunoo, ani as jira» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_2","002_27_2","GEN","27","2","2","Yisihaq, «Kunoo, ani dulloomeera; guyyaa du'a tiyyaalle hin beeku. ");
INSERT INTO gax_vpl VALUES ("GN27_3","002_27_3","GEN","27","3","3","Tanaaf, meya adamo'oo keeti, korojoo teeti, guube'ee fi daaya keeti fudhadhuu bayii bineensa naaf adansi. ");
INSERT INTO gax_vpl VALUES ("GN27_4","002_27_4","GEN","27","4","4","Dhandhama ani jaaladhu qopheessiitii naa fidi; ani nyaadhee, adoo hin du'iniin dura akka si eebbisu naaf dhikeessi» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN27_5","002_27_5","GEN","27","5","5","Yennaa Yisihaq ilma ifii Esaawutti dubbate san Ribqaan dhage'iisatti jirtiiyyu. Maarre yennaa Esaawu bineensa adansiisaaf baye, ");
INSERT INTO gax_vpl VALUES ("GN27_6","002_27_6","GEN","27","6","6","Ribqaan ilma ifii Yaaqoobiin, «Abbaan keeti obboleessa keeti Esaawu'utti dubbatuun ani dhage'eera; ");
INSERT INTO gax_vpl VALUES ("GN27_7","002_27_7","GEN","27","7","7","inni, ‹Bineensa adansiitii, dhandhama ani jaaladhu qopheessiitii naa dhikeessi; ani nyaadhee, adoo hin du'iniin dura Mootii Waan Maraa duratti si hin eebbisa› jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_8","002_27_8","GEN","27","8","8","Amma, ilma kiyya, naaf ajajamii waan ani sitti himu godhi. ");
INSERT INTO gax_vpl VALUES ("GN27_9","002_27_9","GEN","27","9","9","Dhandhama abbaan keeti jaalattu akka qopheessuuf, gara re'ee teennaa dhaqiitii buruusoo lama fidi. ");
INSERT INTO gax_vpl VALUES ("GN27_10","002_27_10","GEN","27","10","10","Achiin duuba inni adoo hin du'iniin dura akka si eebbisu, abbaa keetiif fuutee dhikeessita» jette. ");
INSERT INTO gax_vpl VALUES ("GN27_11","002_27_11","GEN","27","11","11","Yaaqoob haadha ifii Ribqa'aan, «Kunoo, obboleessi kiyya Esaawu nafi isaa dabbasicha; nafi kiyya ammoo mucucaataa dabbasaa hin qanne. ");
INSERT INTO gax_vpl VALUES ("GN27_12","002_27_12","GEN","27","12","12","Dedha fa'a abbaan kiyya yoo na qaqqabee ilaale, ani waan isatti murge fakkaadhee, eebba adoo hin te'in abaarsa ifitti fida» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_13","002_27_13","GEN","27","13","13","Ribqaan deebittee, «Ilma kiyya, abaarsa keeti ani hin fudhadha; akka ani jedhe godhiitii, deemii buruusota naa fidi» jette. ");
INSERT INTO gax_vpl VALUES ("GN27_14","002_27_14","GEN","27","14","14","Maarre inni dhaqee buruusota gara haadha ifii fide; haati isaalle akkuma abbaan isaa jaalatutti dhandhama qopheessite. ");
INSERT INTO gax_vpl VALUES ("GN27_15","002_27_15","GEN","27","15","15","Achiin duuba isiin woyaa Esaawuu ilma isi'ii angafichaa adduu ta mana jirtu fuutee, ilma maandhicha Yaaqoobitti uffitte. ");
INSERT INTO gax_vpl VALUES ("GN27_16","002_27_16","GEN","27","16","16","Isiin gogaa buruusoo re'e'eelle harka isaatii fi morma isaa mucucaata'atti uffitte. ");
INSERT INTO gax_vpl VALUES ("GN27_17","002_27_17","GEN","27","17","17","Isiin dhandhamaa fi daabboo qopheessitelle ilma ifii maandhicha Yaaqoobitti kennite. ");
INSERT INTO gax_vpl VALUES ("GN27_18","002_27_18","GEN","27","18","18","Yaaqoob gara abbaa ifii dhaqee, «Abbaa» jedheen. Innille deebisee, «Kunoo, ani as jira, ati ilma kam?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_19","002_27_19","GEN","27","19","19","Yaaqoob abbaa ifiitiin, «Ani Esaawuu ilma keeti angaficha; ani akka ati jette godheera. Ol jedhii tee'iitii, akka na eebbittu, foon ani adansee fide nyaadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_20","002_27_20","GEN","27","20","20","Yisihaq, «Ilma kiyya, attam akkas ariifattee dhaggatte?» jedhee gaafate. Innille deebisee, «Mootii Waan Maraa Waaqa keetitti na milkeesse» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_21","002_27_21","GEN","27","21","21","Yisihaq, «Ani si qaqqabee, dhugumaan ilma kiyya Esaawu akka teete yookiin hin te'in akka beekuuf, as dhikaadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_22","002_27_22","GEN","27","22","22","Yaaqoob gara abbaa ifii Yisihaqii dhikaate; innille isa qaqqabee, «Qoonqoon, qoonqoo Yaaqoobii ti; harki ammoo harka Esaawuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_23","002_27_23","GEN","27","23","23","Harki isaa dabbasicha akka harka obboleessa isaa Esaawuu waan te'eef, abbaan isaa isa beekuu hin dandeenne. Tanaaf inni isa eebbisiisaaf jedhee, ");
INSERT INTO gax_vpl VALUES ("GN27_24","002_27_24","GEN","27","24","24","«Ati dhugumaan ilma kiyya Esaawuu?» jedhee gaafate. Inni deebisee, «Ee, ana» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_25","002_27_25","GEN","27","25","25","Yisihaq, «Ilma kiyya, foon ati adansitee fidde nyaadhee, akka si eebbisuuf, as naa fidi» jedhe. Yaaqoobille isatti fidee, innille nyaate; daadhii woyni'iille akka unuuf fidee innille une. ");
INSERT INTO gax_vpl VALUES ("GN27_26","002_27_26","GEN","27","26","26","Achiin duuba abbaan isaa Yisihaq, «Ilma kiyya, as koyii, na sunqadhu» isaan jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_27","002_27_27","GEN","27","27","27","Maarre inni gara isaa dhufee isa sunqate; Yisihaqille foolee woyaa isaa ulatee, isa eebbisee, «Fooleen ilma kiyyaa, akka foolee fichaa Mootiin Waan Maraa eebbisee ti. ");
INSERT INTO gax_vpl VALUES ("GN27_28","002_27_28","GEN","27","28","28","Waaqi karfaffuu ol-gubba'aa, lafa laayyoo, midhaanii fi woynii bacaa sii kennu. ");
INSERT INTO gax_vpl VALUES ("GN27_29","002_27_29","GEN","27","29","29","Gosi biyya adda addaa si tajaajiltuu ti; kolbaan hedduulle si'iif gad jettuu ti. Obboleeyyan teeti irratti goottaa te'i; ilmaan haadha teetii si'iif gad jettuu ti. Worri si abaare abaaramuu ti; worri si eebbise eebbifamuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_30","002_27_30","GEN","27","30","30","Yisihaq akkuma Yaaqoob eebbisee ka'een, Yaaqoob fuula abbaa ifii duraa gad bayeeruun, obboleessi isaa Esaawuun adamo'oo dhufee seene. ");
INSERT INTO gax_vpl VALUES ("GN27_31","002_27_31","GEN","27","31","31","Innille dhandhama qopheessee gara abbaa ifii fidee, «Abba'a, ol jedhii tee'i; akka na eebbittuuf, foon ani adansee fide nyaadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_32","002_27_32","GEN","27","32","32","Abbaan isaa Yisihaq, «Ati eennu?» jedhee gaafate. Inni deebisee, «Ani ilma keeti angaficha, Esaawu'u» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN27_33","002_27_33","GEN","27","33","33","Yisihaq guddoo nayee hollatee, «Ka bineensa adansee naa fide, inni eennu ree? Dhufa teetiin dura ani nyaadhee isa eebbiseera; ee, inni ka eebbifame hin te'a!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_34","002_27_34","GEN","27","34","34","Esaawu yennaa tana dhage'e, qoonqoo guddo'oon iyyee laaleffatee bowee, abbaa ifiitiin, «Abba'a, analle eebbisi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_35","002_27_35","GEN","27","35","35","Yisihaq ammoo, «Obboleessi keeti sobaan dhufee, eebba keeti fudhateera» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_36","002_27_36","GEN","27","36","36","Esaawu, «Ana sobiisi isaa kun yennaa lammeesso'oo ti. Yaaqoob jedhamuun isaa sirri'i; tanaan dura angafummaa tiyya na irraa fudhatee, ammalle eebba kiyya na irraa fudhate» jedhe. Achiin duuba, «Ati eebba tokkolle naaf hin hamburree?» jedhee abbaa ifii gaafate. ");
INSERT INTO gax_vpl VALUES ("GN27_37","002_27_37","GEN","27","37","37","Yisihaq deebisee Esaawu'uun, «Ani si'i irratti Yaaqoob goottonseera; obboleeyyan isaa mara tajaajiltoota isaa godheera. Midhaanii fi woynii bacaa isaaf kenneera. Ilma kiyya, maan si'iif godhuu dande'a ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_38","002_27_38","GEN","27","38","38","Esaawu abbaa ifiitiin, «Abba'a, ati eebba tokko qofa qaddaa? Abba'a, analle eebbisi» jedhee, qoonqoo ol qabatee bowe. ");
INSERT INTO gax_vpl VALUES ("GN27_39","002_27_39","GEN","27","39","39","Abbaan isaa Yisihaq deebisee, isaan, «Ati lafa laayyoo irraa, karfaffuu irraa fagaattee leeta. ");
INSERT INTO gax_vpl VALUES ("GN27_40","002_27_40","GEN","27","40","40","Shallaagaa keetiin leeta; obboleessa keeti tajaajilta. Yennaa didde ammoo, waanjoo isaa morma keeti irraa hin buufatta» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_41","002_27_41","GEN","27","41","41","Abbaan isaa waan isa eebbiseef, Esaawuun Yaaqoob jibbe. Inni gadhaa ifiititti, «Yennaan abbaan kiyya du'u dhikaatteerti; achiin duuba ani obboleessa kiyya Yaaqoob hin ijjeesa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN27_42","002_27_42","GEN","27","42","42","Ribqaan ammoo marroo yaada Esaawu'uu yennaa dhageette, Yaaqoobitti ergitee, «Dhage'i, obboleessi keeti Esaawu si ijjeesee, haluu bayiisaaf yaadateera. ");
INSERT INTO gax_vpl VALUES ("GN27_43","002_27_43","GEN","27","43","43","Tanaaf amma, ilma kiyya, waan ani siin jedhu godhi. Ka'iitii gara obboleessa kiyya Laabaanii ka Kaaraan keessa jiruu baqadhu. ");
INSERT INTO gax_vpl VALUES ("GN27_44","002_27_44","GEN","27","44","44","Haga obboleessi keeti aarii caffatu yenna'aaf isa woliin turi. ");
INSERT INTO gax_vpl VALUES ("GN27_45","002_27_45","GEN","27","45","45","Obboleessi keeti yennaa aarii caffate, waan ati isa goote hin dedha. Achiin duuba ani nama sitti ergee achii si deebisa. Ani maaf isin lamaanuu guyyaa tokkotti dhabaa?» jetteen. ");
INSERT INTO gax_vpl VALUES ("GN27_46","002_27_46","GEN","27","46","46","Achiin duuba Ribqaan Yisihaqiin, «Sababa dubartoota Heetotaa ta Esaawu fuudhee tanaaf, ani le'ii tiyya jibbeera; Yaaqoobille dubartoota Heetotaa tama akkanaa tana, lafa tana keessaa niitii yoo fuudhe, ani du'iisa fedha» jette. ");
INSERT INTO gax_vpl VALUES ("GN28_1","002_28_1","GEN","28","1","1","Yisihaq Yaaqoob waamee, eebbisee, isa ajajee, «Dubartoota worra Kana'aanii hin fuudhin. ");
INSERT INTO gax_vpl VALUES ("GN28_2","002_28_2","GEN","28","2","2","Gara biyya phaadaan-Aaramii, mana Batu'elii abbaa haadha teetii dhaqiitii, durroota Laabaanii obboleessa haadha teetii keessaa takkattii achii fuudhi. ");
INSERT INTO gax_vpl VALUES ("GN28_3","002_28_3","GEN","28","3","3","Waaqi waan mara dande'u si eebbisuu ti! Akka ati abbaa gosa biyya adda addaa heddu'uu teetu, ijoollee hedduu sii kennuu ti! ");
INSERT INTO gax_vpl VALUES ("GN28_4","002_28_4","GEN","28","4","4","Inni akkuma Abrahaam eebbise, si'ii fi sanyii teetille eebbisuu ti! Lafa Abrahaamii kenne, ta ati amma akka alaga'aa teetee leetu, si'iif kennuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN28_5","002_28_5","GEN","28","5","5","Akka kanaan Yisihaq Yaaqoob erge; innille gara biyya phaadaan-Aaramii, gara Laabaanii ilma Batu'elii nama biyya Aaramii dhaqe. Inni obboleessa Ribqaa haadha Esaawu'uutii fi Yaaqoobii ti. ");
INSERT INTO gax_vpl VALUES ("GN28_6","002_28_6","GEN","28","6","6","Yisihaq akka Yaaqoob eebbisee, niitii akka achii fuudhu, gara biyya phaadaan-Aaramii akka erge Esaawu hubate; Yisihaq yennaa Yaaqoob eebbise, «Dubartii worra Kana'aanii hin fuudhin» jedhee akka isa ajajelle hubate. ");
INSERT INTO gax_vpl VALUES ("GN28_7","002_28_7","GEN","28","7","7","Yaaqoob abba'aa fi haadha ifiitiif ajajamee, gara biyya phaadaan-Aaramii akka dhaqeerulle hubate. ");
INSERT INTO gax_vpl VALUES ("GN28_8","002_28_8","GEN","28","8","8","Maarre abbaan isaa Yisihaq dubartoota worra kana'aanii akka hin jaalanne Esaawu yennaa dhagge, ");
INSERT INTO gax_vpl VALUES ("GN28_9","002_28_9","GEN","28","9","9","maarre inni gara Ishimaa'elii ilma Abrahaamii dhaqee, intala isaa Mahilaati, obboleettii Nabaayootii, dubartoota dur fuudheeru irratti ede'ee fuudhe. ");
INSERT INTO gax_vpl VALUES ("GN28_10","002_28_10","GEN","28","10","10","Yaaqoob Bersheeba'aa bayee gara Kaaraanii dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN28_11","002_28_11","GEN","28","11","11","Inni addee takka geyee, aduun waan seenteef, achi bule. Dhakaa addee sanii keessaa tokko fuudhee, boraafatee rafe. ");
INSERT INTO gax_vpl VALUES ("GN28_12","002_28_12","GEN","28","12","12","Inni achitti oojjatee, riqaa lafa irratti ijjatee qacceen isaa ol-gubbaa geettu, ergantooti Waaqaa isa irra ol bayaa, gad bu'anuun oojju'uun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN28_13","002_28_13","GEN","28","13","13","Mootiin Waan Maraa qaccee riqa'aa gubbaa dhaabbatee, «Ani Mootii Waan Maraa Waaqa Abrahaamii akaakoo keetiitii fi Yisihaqii abbaa keetii ti. Ani lafa ati irra irkatteertu tana sanyii teetiif hin kenna. ");
INSERT INTO gax_vpl VALUES ("GN28_14","002_28_14","GEN","28","14","14","Sanyiin teeti akka maansa lafaa hin bacatti; isaan gara aduun seentuu fi baatu, gara kaabaa fi kibbaa hin babadhatan; kolbaan biyya lafaa duudiin si'ii fi sanyii teetiin hin eebbifaman. ");
INSERT INTO gax_vpl VALUES ("GN28_15","002_28_15","GEN","28","15","15","Ani si woliin hin jiraadha; addee ati dhaxxu maratti ani si hin eega; gara lafa tanaalle si hin deebisa. Waan waadaa sii gale mara haga sii godhutti ani si hin lakkisu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN28_16","002_28_16","GEN","28","16","16","Achiin duuba Yaaqoob hirriibaa dammaqee, «Mootiin Waan Maraa dhugumaan addee tana jira! Ani ammoo hin beenne» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN28_17","002_28_17","GEN","28","17","17","Inni sodaatee, «Addeen tun attam attam sodaachitti! Isiin mana Waaqaa ti; balbala ol-gubba'aa ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN28_18","002_28_18","GEN","28","18","18","Yaaqoob boruyyaa barii ganama ka'ee, dhakaa boraafate san fuudhee, akka sooddu'uu dhaabee, qaccee isaa irratti zayitii ejersaa cosse. ");
INSERT INTO gax_vpl VALUES ("GN28_19","002_28_19","GEN","28","19","19","Inni maqaa addee sanii, «Bet'el» jedhee moggaase. Dur maqaan addee sanii, «Luz» jedhamaayyu. ");
INSERT INTO gax_vpl VALUES ("GN28_20","002_28_20","GEN","28","20","20","Yaaqoob Mootii Waan Maraatiif waadaa galee, «Yoo ati na woliin jiraatee, karaa ani deemu kana irratti na eedde, sagalee nyaadhuu fi woyaa uffadhu yoo naaf kennite, ");
INSERT INTO gax_vpl VALUES ("GN28_21","002_28_21","GEN","28","21","21","nageyaan gara mana abbaa kiyyaa yoo deebi'e, ati Mootii Waan Maraa Waaqa kiyya hin teeta. ");
INSERT INTO gax_vpl VALUES ("GN28_22","002_28_22","GEN","28","22","22","Dhakaan ani akka sooddu'uu dhaabe kunille, mana Waaqaa hin te'a; waan naaf kennitu mara keessaa kudhan keessaa tokko si'iif hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN29_1","002_29_1","GEN","29","1","1","Yaaqoob ittuma ideemee, gara kolbaa biyya gara aduun baatuu geye. ");
INSERT INTO gax_vpl VALUES ("GN29_2","002_29_2","GEN","29","2","2","Inni achi diida keessatti boolla bisaanii takka dhagge. Hooloti karra sadiille boolla bisaanii san bira ciitteertiiyyu; hooloti sun boolla tana keessaa bisaan unti. Afaan boolla sanille dhakaa gudda'aan cufama. ");
INSERT INTO gax_vpl VALUES ("GN29_3","002_29_3","GEN","29","3","3","Yennaa karri hoolotaa martinuu achitti wolitti dacha'ane, tissitooti dhakaa afaan boolla bisaanii irraa konkolaachisanee hoolota obaasan; achiin duuba dhakaa addee isaatitti deebisanee afaan boolla bisaanii irra keyan. ");
INSERT INTO gax_vpl VALUES ("GN29_4","002_29_4","GEN","29","4","4","Yaaqoob, «Obboleeyyan tiyya, isin eessaa dhuttane?» jedhee tissitoota gaafate. Isaan deebisanee, «Nuuti Kaaraanii dhunne» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN29_5","002_29_5","GEN","29","5","5","Inni isaaniin, «Laabaanii akaakoo Naahorii beettanii?» jedhe. Isaan deebisanee, «Ee, hin beenna» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN29_6","002_29_6","GEN","29","6","6","Yaaqoobille, isaaniin, «Inni nageyaa?» jedhe. Isaan deebisanee, «Ee, nageya; kunoo, intalti isaa Raahel hoolee fiddee dhufiisatti jirti» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN29_7","002_29_7","GEN","29","7","7","Inni, «Kunoo, latti guyya'a; yennaan galchuma hori'ii hin geenne. Hoolee bisaan obaasa'aatii geessa'aa dheechisa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN29_8","002_29_8","GEN","29","8","8","Isaan ammoo, «Haga karri hoole'ee martinuu wolitti qabantee dhakaa afaan boolla bisaanii irraa konkolaachifamutti, nuuti tana goonee hin dandeennu. Achiin duuba nuuti hoolee hin obaanna» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN29_9","002_29_9","GEN","29","9","9","Adoo inni isaan woliin dubbatiisatti jiruu, Raahel tissituu waan teeteef, hoolee abbaa ifii fiddee dhutte. ");
INSERT INTO gax_vpl VALUES ("GN29_10","002_29_10","GEN","29","10","10","Yaaqoob yennaa Raahelii intala Laabaanii abuyyaa ifiitii fi hoolee isaa dhagge, itti dhikaatee dhakaa boolla bisaanii irraa konkolaachisee, hoolee isaa san bisaan obaase. ");
INSERT INTO gax_vpl VALUES ("GN29_11","002_29_11","GEN","29","11","11","Achiin duuba inni Raahel sunqatee waan gammadeef bowe. ");
INSERT INTO gax_vpl VALUES ("GN29_12","002_29_12","GEN","29","12","12","Inni, «Ani ilma adaadaa teeti Ribqa'aa ti» jedhee isi'itti hime. Isiille rukkittee abbaa ifiititti hinte. ");
INSERT INTO gax_vpl VALUES ("GN29_13","002_29_13","GEN","29","13","13","Laabaan oduu marroo Yaaqoobii ilma obboleettii ifii yennaa dhage'e, isa qophatiisaaf rukkisee gad bayee, hanqafatee, gara manaa seensise. Yaaqoob waan te'eeru mara yennaa itti hime, ");
INSERT INTO gax_vpl VALUES ("GN29_14","002_29_14","GEN","29","14","14","Laabaan, «Ee, dhugumaan, ati foon kiyyaa fi dhiiga kiyya» jedhe. Yaaqoob ji'a tokko guutuu isa bira ture. ");
INSERT INTO gax_vpl VALUES ("GN29_15","002_29_15","GEN","29","15","15","Laabaan Yaaqoobiin, «Ati hidda kiyya waan teetiif, toluma naaf hujuu hin malle. Meeqa akka ani isi'iif kaffalu barbaadda?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN29_16","002_29_16","GEN","29","16","16","Laabaan durra lama qabaayyu; maqaan angafitti'ii Liya'a; ka maandhitti'ii Raahel. ");
INSERT INTO gax_vpl VALUES ("GN29_17","002_29_17","GEN","29","17","17","Liyaan intala ila kuulaa ti; Raahel ammoo dansittii dhaaba toltu. ");
INSERT INTO gax_vpl VALUES ("GN29_18","002_29_18","GEN","29","18","18","Yaaqoob Raahel waan jaalateef, Laabaaniin, «Akka ani intala teeti maandhittii Raahel fuudhu yoo naaf eeyyante, ani woggaa torba si hin tajaajila» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN29_19","002_29_19","GEN","29","19","19","Laabaan deebisee, «Ani nama dhibi'iif isii kennu'uu mannaa, isi'iif kennuu woyya; as na bira turi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN29_20","002_29_20","GEN","29","20","20","Maarre Yaaqoob Raahel fuudhiisaaf jedhee, woggaa torba tajaajile; inni waan isii jaalateef, woggooti kun guyyoota diqqaa isatti fakkaatane. ");
INSERT INTO gax_vpl VALUES ("GN29_21","002_29_21","GEN","29","21","21","Achiin duuba Yaaqoob, Laabaaniin, «Yennaan tajaajila kiyyaa dhumatteerti; Raahel akka fuudhuuf naa kenni» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN29_22","002_29_22","GEN","29","22","22","Maarre Laabaan jila fuudhaa fi heerumaa jilisee, kolbaa achi jirtu mara waame. ");
INSERT INTO gax_vpl VALUES ("GN29_23","002_29_23","GEN","29","23","23","Galgala san ammoo, addee Raahelii, intala ifii Liyaa fuudhee Yaaqoobitti geesse; Yaaqoobille isii woliin rafe. ");
INSERT INTO gax_vpl VALUES ("GN29_24","002_29_24","GEN","29","24","24","Laabaan tajaajiltuu ifii Zilfaa, akka tajaajiltuu isi'ii teetuuf, Liya'aaf kenne. ");
INSERT INTO gax_vpl VALUES ("GN29_25","002_29_25","GEN","29","25","25","Boruyyaa ganama Yaaqoob akka Liyaa teete beekee, gara Laabaanii dhaqee, «Wonni ati na goote kun maan? Ani Raahel fuudhiisaaf si tajaajile. Ati maaf na sodde ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN29_26","002_29_26","GEN","29","26","26","Laabaan deebisee, «Biyya teenna keessatti intala angafitti'iin dura intala maandhittii hin heerumsiisanu. ");
INSERT INTO gax_vpl VALUES ("GN29_27","002_29_27","GEN","29","27","27","Torbaan waajibumma'aa Liyaa woliin fixadhu; woggaa torba ta dhibii deebitee yoo na tajaajilte, Raahelille si'iif hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN29_28","002_29_28","GEN","29","28","28","Yaaqoob akkuma inni jedhe godhe; yennaa inni torbaan waajibumma'aa Liyaa woliin fixate, Laabaan intala ifii Raahel isa heerumsiise. ");
INSERT INTO gax_vpl VALUES ("GN29_29","002_29_29","GEN","29","29","29","Laabaan tajaajiltuu ifii Bilhaa, akka tajaajiltuu isi'ii teetuuf, Raaheliif kenne. ");
INSERT INTO gax_vpl VALUES ("GN29_30","002_29_30","GEN","29","30","30","Yaaqoob Raahel wolille'een rafee, Liyaa caalaa isii jaalate. Achiin duuba inni woggaa torba ta dhibii Laabaan tajaajile. ");
INSERT INTO gax_vpl VALUES ("GN29_31","002_29_31","GEN","29","31","31","Liyaa caalaa akka Yaaqoob Raahel jaalate Mootiin Waan Maraa yennaa dhagge, Liyaan akka ijoollee deettu godhe; Raahel ammoo maseena teete. ");
INSERT INTO gax_vpl VALUES ("GN29_32","002_29_32","GEN","29","32","32","Liyaan ulfoottee ilma deette. Isiin, «Mootiin Waan Maraa rakkoo tiyya dhagge; amma dhugumaan dhirsi kiyya na hin jaalata» jettee, maqaa isaa Ruuben baafatte. ");
INSERT INTO gax_vpl VALUES ("GN29_33","002_29_33","GEN","29","33","33","Isiin ammalle ulfoottee ilma dhibii deettee, «Mootiin Waan Maraa akka ani hin jaalatamin dhage'ee, ammalle ilma kana naaf kenne» jettee, maqaa isaa Shimi'oon baafatte. ");
INSERT INTO gax_vpl VALUES ("GN29_34","002_29_34","GEN","29","34","34","Liyaan ammalle ulfoottee ilma dhibii deette. Isiin, «Ani ilmaan sad waan isaaf deyeef, amma dhirsi kiyya jaalalaan natti hin maxxana» jettee, maqaa isaa Lewwii baafatte. ");
INSERT INTO gax_vpl VALUES ("GN29_35","002_29_35","GEN","29","35","35","Achiin duuba Liyaan ammalle ulfoottee ilma dhibii deette. Isiin, «Amma ani Mootii Waan Maraa hin leellisa» jettee, maqaa isaa Yihudaa baafatte. ");
INSERT INTO gax_vpl VALUES ("GN30_1","002_30_1","GEN","30","1","1","Raahel akka ijoollee Yaaqoobiif deyaa hin jirre yennaa beette, obboleettii ifii hinaattee, Yaaqoobiin, «Ijoollee naaf kenni, yookiin ani hin du'a» jette. ");
INSERT INTO gax_vpl VALUES ("GN30_2","002_30_2","GEN","30","2","2","Yaaqoob guddoo aaree, «Ani addee Waaqaa bu'ee hin dande'u. Ka ijoollee si dhooggate isa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN30_3","002_30_3","GEN","30","3","3","Achiin duuba Raahel, «Bilhaan tajaajiltuun tiyya kunoo ti; akka isiin ijoollee naaf deettu, isii bira geyi. Akka kanaan, karaa isi'iitiin ani haadha ijoolle'ee hin te'a» jette. ");
INSERT INTO gax_vpl VALUES ("GN30_4","002_30_4","GEN","30","4","4","Maarre isiin Balhaan dhirsa ifiitiif kennitee, innille isii bira geye. ");
INSERT INTO gax_vpl VALUES ("GN30_5","002_30_5","GEN","30","5","5","Balhaan ulfoottee Yaaqoobiif ilma deette. ");
INSERT INTO gax_vpl VALUES ("GN30_6","002_30_6","GEN","30","6","6","Raahel, «Waaqi naaf mure. Inni daadimata kiyya dhage'ee, ilma naaf kenne» jettee, maqaa isaa Daan baafatte. ");
INSERT INTO gax_vpl VALUES ("GN30_7","002_30_7","GEN","30","7","7","Balhaan garbittiin Raahelii ammalle ulfoottee Yaaqoobiif ilma lammeesso'oo deette. ");
INSERT INTO gax_vpl VALUES ("GN30_8","002_30_8","GEN","30","8","8","Achiin duuba Raahel, «Ani obboleettii tiyya woliin wodhaantoo jadduu qabadhee, injifadhe» jettee, maqaa isaa Niftaalem baafatte. ");
INSERT INTO gax_vpl VALUES ("GN30_9","002_30_9","GEN","30","9","9","Liyaan akka deya lakkitte yennaa beette, tajaajiltuu ifii Zilfaa fuutee, akka niiti'iititti Yaaqoobiif kennite. ");
INSERT INTO gax_vpl VALUES ("GN30_10","002_30_10","GEN","30","10","10","Achiin duuba Zilfaan Yaaqoobiif ilma deette. ");
INSERT INTO gax_vpl VALUES ("GN30_11","002_30_11","GEN","30","11","11","Liyaan, «Milkaaye» jettee, maqaa isaa Gaad baafatte. ");
INSERT INTO gax_vpl VALUES ("GN30_12","002_30_12","GEN","30","12","12","Tajaajiltuun Liya'aa, Zilfaan ilma dhibii deettee jennaan, ");
INSERT INTO gax_vpl VALUES ("GN30_13","002_30_13","GEN","30","13","13","Liyaan, «Ani guddoo gammadeera! Amma dubartooti, ‹Ta gammadde› naan jedhan» jettee, maqaa isaa Asheer baafatte. ");
INSERT INTO gax_vpl VALUES ("GN30_14","002_30_14","GEN","30","14","14","Yennaa haammaa qamadi'ii, Ruuben gaafa tokko alatti bayee, midhaan muka fedhii jaalalaa kakkaasu dhaggee, Liyaa haadha ifiitiif fide. Raahel Liya'aan, «Maganne'ee, midhaan muka fedhii jaalalaa kakkaasu ka ilmi keetii fide san irraa naafille kenni» jette. ");
INSERT INTO gax_vpl VALUES ("GN30_15","002_30_15","GEN","30","15","15","Liyaan deebittee, «Ka dhirsa kiyya na irraa fudhatte si hanqattee, amma midhaan muka fedhii jaalalaa kakkaasu, ka ilmi kiyya fidelle fudhatiisa barbaaddaa?» jette. Raahelille, «Ati midhaan muka fedhii jaalala kakkaasu ka ilmi keeti sii fide naa yoo kennite, halkan edanaa Yaaqoob woliin buluu dandeetta» jette. ");
INSERT INTO gax_vpl VALUES ("GN30_16","002_30_16","GEN","30","16","16","Galgala san Yaaqoob ficha'aa yennaa dhufe, Liyaan gad itti baatee, «Ani midhaan muka jaalala kakkaasu ka ilmi kiyya fideen waan si bitadheef, galgala adhaa na woliin bulta» jette. Maarre inni halkan san isii woliin bule. ");
INSERT INTO gax_vpl VALUES ("GN30_17","002_30_17","GEN","30","17","17","Waaqi daadimata Liya'aa dhage'ee, isiin ulfoottee ilma shaneesso'oo Yaaqoobiif deette. ");
INSERT INTO gax_vpl VALUES ("GN30_18","002_30_18","GEN","30","18","18","Liyaan, «Ani tajaajiltuu tiyya dhirsa kiyyaaf kenninaan, Waaqi gatii naaf kenne» jettee, maqaa isaa Yisaakor baafatte. ");
INSERT INTO gax_vpl VALUES ("GN30_19","002_30_19","GEN","30","19","19","Liyaan ammalle ulfoottee ilma jayeesso'oo Yaaqoobiif deettee, ");
INSERT INTO gax_vpl VALUES ("GN30_20","002_30_20","GEN","30","20","20","«Waaqi kennansa dansaa naaf kenneera. Ani ilmaan jaa waan isaa deyeef, amma dhirsi kiyya ulfinna naaf hin kenna!» jettee, maqaa isaa Zebuloon baafatte. ");
INSERT INTO gax_vpl VALUES ("GN30_21","002_30_21","GEN","30","21","21","Duuba irra isiin intala deettee, maqaa isi'ii «Dinaa» jette. ");
INSERT INTO gax_vpl VALUES ("GN30_22","002_30_22","GEN","30","22","22","Achiin duuba Waaqi Raahel qaabate; inni daadimata isi'ii dhage'ee akka isiin deettu godhe. ");
INSERT INTO gax_vpl VALUES ("GN30_23","002_30_23","GEN","30","23","23","Isiin ulfoottee ilma deettee, «Waaqi salphinna kiyya na irraa fuudhe. ");
INSERT INTO gax_vpl VALUES ("GN30_24","002_30_24","GEN","30","24","24","Mootiin Waan Maraa ilma dhibii naaf kenne» jettee, maqaa isaa Yoseef baafatte. ");
INSERT INTO gax_vpl VALUES ("GN30_25","002_30_25","GEN","30","25","25","Raahel Yoseef deetteen duuba, Yaaqoob, Laabaaniin, «Gara lafa itti dhaladheetii fi biyya tiyyaa akka dhaquuf gad na lakkisi. ");
INSERT INTO gax_vpl VALUES ("GN30_26","002_30_26","GEN","30","26","26","Ani attam attam akka si'iif huje atinuu hin beetta; ani hin deema, dubartoota tiyyaa fi ijoollee tiyya ta ani si'iif tajaajilee dhaggadhe naaf kenni» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN30_27","002_30_27","GEN","30","27","27","Laabaan ammoo Yaaqoobiin, «Ani yoo si duratti fudhatama dhaggadhe, maganne'ee turi; sababa keetiif akka Mootiin Waan Maraa na eebbise, mudhii addaatiin beekeera. ");
INSERT INTO gax_vpl VALUES ("GN30_28","002_30_28","GEN","30","28","28","Mindaa ani si'iif kaffalu'uu male natti himi, ani si'iif hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN30_29","002_30_29","GEN","30","29","29","Yaaqoob deebisee, «Attam akka si'iif tajaajile, horiin keetille ani kunuunsuun attam akka si'iif horelle atinuu hin beetta. ");
INSERT INTO gax_vpl VALUES ("GN30_30","002_30_30","GEN","30","30","30","Yennaa hin dhufiniin dura, horii diqqaan keeti, amma guddoo bacateera. Addee ani dhaqe duudi'itti Mootiin Waan Maraa si eebbiseera. Ani maatii tiyyaaf yoom wo godha ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN30_31","002_30_31","GEN","30","31","31","Laabaan, «Maan si'iif kennu ree?» jedhee gaafate. Yaaqoob, «Waan ani si'iin jedhu kana, yoo naaf goote, ani horii keeti deebi'ee hin kunuunsa, hin tissalle'e. ");
INSERT INTO gax_vpl VALUES ("GN30_32","002_30_32","GEN","30","32","32","Ani adha horii keeti keessa deemee, hoolota keessaa titiifu'uu fi buburree, buruusoo gugurraayyee mara, re'oota keessalle'ee buruusoo titiifu'uu fi gugurraayyee mara addaan baasa. Isaan mindaa kiyyaa te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("GN30_33","002_30_33","GEN","30","33","33","Akka kanaan addatamummaa tiyya hin dhaggita. Ati mindaa kiyya qorqoriisaaf yennaa dhuttu, re'oota titiifuu yookiin buburree hin te'in, yookiin hoolota gugurraayyee hin te'in yoo qabaadhe, akka hatamane hin beetta» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN30_34","002_30_34","GEN","30","34","34","Laabaan deebisee, «Tole, akkuma ati jette teetuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN30_35","002_30_35","GEN","30","35","35","Gaafuma san Laabaan korbeeyyii re'e'ee tattalee, titiifuu, re'oota dhaltuu buburre'ee fi titiifuu yookiin xibaanxibbee adaadii nafa irraa qaddu mara, buruusoo hoole'ee gugurraayyee mara addaan baasee, ilmaan ifii akka tissanu godhe. ");
INSERT INTO gax_vpl VALUES ("GN30_36","002_30_36","GEN","30","36","36","Achiin duuba Laabaan ideensa guyyaa sadii Yaaqoob irraa fagaate. Yaaqoob hoole'ee fi re'ee Laabaanii ka hafane tisse. ");
INSERT INTO gax_vpl VALUES ("GN30_37","002_30_37","GEN","30","37","37","Yaaqoob ulee muka jiidhaa gosa sadii muree, dabaree dabaree quncee irraa quncisee buburreesse. ");
INSERT INTO gax_vpl VALUES ("GN30_38","002_30_38","GEN","30","38","38","Hoole'ee fi re'een bisaan uniisaaf yennaa dhufanu, korbeeyyiin waan hoqonsiteef, inni ulee buburreesse san fuula isaanii dura gongaa isaan keessaa unanu keessa keye. Hoole'ee fi re'een bisaan uniisaaf yennaa dhufanu, ");
INSERT INTO gax_vpl VALUES ("GN30_39","002_30_39","GEN","30","39","39","maarre isaan yennaa ulee saniin duratti hoqonsane, ilmoolee tattalee, titiifu'uu fi buburree dhalane. ");
INSERT INTO gax_vpl VALUES ("GN30_40","002_30_40","GEN","30","40","40","Yaaqoob ilmoolee tana qofitti baasee, hoole'ee fi re'ee Laabaanii tattale'ee fi gugurraayyee fuula dura dhaabbachiise. Akka kanaan Yaaqoob hoole'ee fi re'ee ifii, hoole'ee fi re'ee Laabaaniitiin addaan fowate. ");
INSERT INTO gax_vpl VALUES ("GN30_41","002_30_41","GEN","30","41","41","Yennaa hoole'ee fi re'een jajjabooti hoqonsanu, isaan ulee san fuula duratti akka hoqonsanu, ulee san isaan bira dhadhaaba. ");
INSERT INTO gax_vpl VALUES ("GN30_42","002_30_42","GEN","30","42","42","Inni ammoo hoole'ee fi re'ee dadadhaboolee dura ulee san hin dhaabuuyyu. Maarre hoole'ee fi re'een dadadhabooleen ta Laabaanii yennaa teetu, jajjaboon ta Yaaqoobii teete. ");
INSERT INTO gax_vpl VALUES ("GN30_43","002_30_43","GEN","30","43","43","Yaaqoob akka kanaan guddoo duroommate. Inni horii bacaa, tajaajiltoota dhiiraatii fi dubarti'ii, gaalotaa fi harreelee hedduu qabaayyu. ");
INSERT INTO gax_vpl VALUES ("GN31_1","002_31_1","GEN","31","1","1","Ilmaan Laabaanii, «Yaaqoob waan abbaan keenna qabu mara fudhate; inni qabeenna kana mara abbaa keenna irraa dhaggate» jettuun Yaaqoob dhage'e. ");
INSERT INTO gax_vpl VALUES ("GN31_2","002_31_2","GEN","31","2","2","Yaaqoob ammalle Laabaan akka dur isa jaalattu akka isa jaalataa hin jirre hubate. ");
INSERT INTO gax_vpl VALUES ("GN31_3","002_31_3","GEN","31","3","3","Achiin duuba Mootiin Waan Maraa Yaaqoobiin, «Gara lafa abbootii teetiitii fi fira keetii deebi'i. Ani si woliin hin jiraadha» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN31_4","002_31_4","GEN","31","4","4","Maarre Yaaqoob gara Raaheliitii fi Liya'aa ergee, addee lafa hoolotii fi Re'ooti isaa jirtutti waansise. ");
INSERT INTO gax_vpl VALUES ("GN31_5","002_31_5","GEN","31","5","5","Inni isaaniin, «Abbaan keessan akka dur na jaalattu gara duraa akka na jaalataa hin jirre hubadheera. Waaqi abbaa kiyyaa ammoo na woliin jira. ");
INSERT INTO gax_vpl VALUES ("GN31_6","002_31_6","GEN","31","6","6","Ani hunna tiyya adoo hin qusatin abbaa keessaniif akka huje, isin lamaanuu hin beettan. ");
INSERT INTO gax_vpl VALUES ("GN31_7","002_31_7","GEN","31","7","7","Laabaan ammoo na sobee mindaa kiyya yennaa kudhan jijjiire. Te'uu malee Waaqi akka inni na miidhu hin goone. ");
INSERT INTO gax_vpl VALUES ("GN31_8","002_31_8","GEN","31","8","8","Yennaa Laabaan, ‹Re'ooti titiifuun mindaa keeti› jedhe, hoolotii fi re'ooti marti ilmoolee titiifuu dhalane. Inni yennaa, ‹Re'ooti tattaleen mindaa keeti› jedhelle, hoolotii fi re'ooti duudiin ilmoolee tattalee dhalane. ");
INSERT INTO gax_vpl VALUES ("GN31_9","002_31_9","GEN","31","9","9","Akka kanaan Waaqi hoole'ee fi re'ee abbaa keessan irraa fuudhee naaf kenne. ");
INSERT INTO gax_vpl VALUES ("GN31_10","002_31_10","GEN","31","10","10","«Yennaa hoole'ee fi re'een rarragatanu, ani oojjadhee, korbeeyyiin tattaleen, buburre'ee fi titiifuun hoqonsanuun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN31_11","002_31_11","GEN","31","11","11","Achiin duuba Ergamaan Waaqaa oojju'uun, ‹Yaaqoob!› jedhee na waame; anille, ‹As jira› jedheen. ");
INSERT INTO gax_vpl VALUES ("GN31_12","002_31_12","GEN","31","12","12","Ergamaan Waaqaa, ‹Kunoo, korbeeyyii tattalee, buburre'ee fi titiifuu qofatti hoqonsiisatti jira. ");
INSERT INTO gax_vpl VALUES ("GN31_13","002_31_13","GEN","31","13","13","Ani addee ati soodduu dhaaddee, zayitii ejersaa itti naxxee naaf kakatetti, Waaqa Bet'elitti sitti mudhate. Amma lafa tana keessaa ariiti'iin bayiitii gara lafa itti dhalattee deebi'i› naan jedhe» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN31_14","002_31_14","GEN","31","14","14","Raahelii fi Liyaan deebisanee, «Mana Abbaa keennaatitti qoodi dhaalaaf nu'uuf hafeeru jiraa ree? ");
INSERT INTO gax_vpl VALUES ("GN31_15","002_31_15","GEN","31","15","15","Inni akka ormaatitti nu ilaala. Inni nu gurgureera; beesee marroo teennaaf kennantelle nyaatee fixeera. ");
INSERT INTO gax_vpl VALUES ("GN31_16","002_31_16","GEN","31","16","16","Karri Waaqi abbaa keenna irraa fuudhe tun marti teennaa fi ta ijoollee teennaa ti; tanaaf waan Waaqi siin jedhe mara godhi» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("GN31_17","002_31_17","GEN","31","17","17","Maarre Yaaqoob dubartoota ifiitii fi ijoollee ifii gaala irra teessisee, ");
INSERT INTO gax_vpl VALUES ("GN31_18","002_31_18","GEN","31","18","18","inni horii ifii mara, meya qabu mara, horii Phaadaan-Aaram keessatti horate oofatee gara biyya Kana'aanii, gara abbaa ifii Yisihaqii dhaqiisaaf ka'e. ");
INSERT INTO gax_vpl VALUES ("GN31_19","002_31_19","GEN","31","19","19","Laabaan rifeensa hoole'ee muriisa dhaqeeruun, Raahel waaqota abbaa ifii ka Laabaanii mana keessaa hatte. ");
INSERT INTO gax_vpl VALUES ("GN31_20","002_31_20","GEN","31","20","20","Yaaqoob akka baqataaru Laabaanitti adoo hin himin isa sobee deeme. ");
INSERT INTO gax_vpl VALUES ("GN31_21","002_31_21","GEN","31","21","21","Yaaqoob waan qabu mara fudhatee baqate. Inni laga Efraaxiisiitiin gamatti bu'ee gara biyya koobitti'ii gara Giil'aadii deemiisaaf ka'e. ");
INSERT INTO gax_vpl VALUES ("GN31_22","002_31_22","GEN","31","22","22","Guyyaa sadiin duuba akka Yaaqoob baqate Laabaan dhage'e. ");
INSERT INTO gax_vpl VALUES ("GN31_23","002_31_23","GEN","31","23","23","Maarre inni fira ifii woliin Yaaqoob hordofe. Guyyaa torbaan duuba Laabaan biyya koobittii Giil'aadii keessatti itti dhikaate. ");
INSERT INTO gax_vpl VALUES ("GN31_24","002_31_24","GEN","31","24","24","Waaqi ammoo halkan oojju'uun gara Laabaanii dhufee, «Waan hantuu Yaaqoobitti akka hin dubbanne ifi eeggadhu!» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN31_25","002_31_25","GEN","31","25","25","Maarre Laabaan Yaaqoob dhaqqabe. Yaaqoob biyya koobittii sanitti dunkaana ifii dhaabate; Laabaanille Giil'aad biyya koobittii san keessatti fira ifii woliin dunkaana ifii dhaabate. ");
INSERT INTO gax_vpl VALUES ("GN31_26","002_31_26","GEN","31","26","26","Laabaan, «Ati na soddee, akka dubartoota lola keessatti booji'antee durra tiyya fudhattee baduun keeti maan godhuu keeti? ");
INSERT INTO gax_vpl VALUES ("GN31_27","002_31_27","GEN","31","27","27","Ati maaf na soddee, adoo natti hin himin dhossa'aan baqatte? Adoo natti hintee jiraattee, silaa ani gammadaan, weeddu'uun, dibbe'ee fi kiraaraan akka ani si geegessaayyu. ");
INSERT INTO gax_vpl VALUES ("GN31_28","002_31_28","GEN","31","28","28","Ati akka ani akaakotaa fi durra tiyya sunqadhee nageya itti dhaamulle natti hin hinne. Wonni ati goote kun waan fokkisiisa'a. ");
INSERT INTO gax_vpl VALUES ("GN31_29","002_31_29","GEN","31","29","29","Ani si miidhiisaaf hunna qabaayyu; halkan edaa ammoo Waaqi abbaa keetii natti dubbatee, ‹Waan hantuu Yaaqoobitti akka hin dubbanne, ifi eeggadhu!› naan jedhe. ");
INSERT INTO gax_vpl VALUES ("GN31_30","002_31_30","GEN","31","30","30","Akka ati gara biyya abbaa keetii deebi'iisaaf guddoo barbaadde ani hin beeka; ammoo waaqota kiyya maaf hatte?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN31_31","002_31_31","GEN","31","31","31","Yaaqoob deebisee, «Durra teeti hunnaan na irraa fudhatta jedhee waan sodaadheef. ");
INSERT INTO gax_vpl VALUES ("GN31_32","002_31_32","GEN","31","32","32","Nu keessaa nami waaqota keeti fudhateeru yoo dhaggame ijjeefamuu ti. Firoota keenna dhugaa bayoota godhadhuutii, waan keeti mara ilaalladhuutii fudhadhu» jedheen. Yaaqoob akka Raahel waaqota Laabaanii hatteertu waan hin beenneef tana jedhe. ");
INSERT INTO gax_vpl VALUES ("GN31_33","002_31_33","GEN","31","33","33","Laabaan gara dunkaana Yaaqoobii, gara dunkaana Liya'aa, gara dunkaana dubartoota tajaajiltoota lamaaniille seene; ammoo waaqota ifii hin dhaggine. Achiin duuba inni gara dunkaana Raahelii seene. ");
INSERT INTO gax_vpl VALUES ("GN31_34","002_31_34","GEN","31","34","34","Raahel waaqota mana keessaa fuutee kooraa gaalaa jalatti dhossitee irra teette. Laabaan dunkaana duudii keessa ilaale; ammoo waaqota ifii hin dhaggine. ");
INSERT INTO gax_vpl VALUES ("GN31_35","002_31_35","GEN","31","35","35","Raahel abbaa ifiitiin, «Abba'a, natti hin mufatin; xuriin waan natti dhutteertuuf, si duraa ka'uu hin dandeenne» jetteen. Maarre inni addee duudii ilaale; ammoo waaqota ifii hin dhaggine. ");
INSERT INTO gax_vpl VALUES ("GN31_36","002_31_36","GEN","31","36","36","Achiin duuba Yaaqoob aaree, «Ani maan balleesse? Ati wonni na ariituuf, ani seera maan yakke? ");
INSERT INTO gax_vpl VALUES ("GN31_37","002_31_37","GEN","31","37","37","Ati waan qabu mara keessa ilaalteen duuba, waan keeti te'e maan dhaggite? Waan tokkolle yoo dhaggitee jiraatte, nu keessaa eentu sirrii akka te'e isaan akka muranuuf, as fira keetii fi fira kiyya dura keyi. ");
INSERT INTO gax_vpl VALUES ("GN31_38","002_31_38","GEN","31","38","38","Ani woggaa diddama si'iif hujeera. Yennaa tana keessatti hoolotii fi re'ooti teeti gadha'aa hin ganne; korbeeyyii teetille ani hin nyaanne. ");
INSERT INTO gax_vpl VALUES ("GN31_39","002_31_39","GEN","31","39","39","Bineensi yennaa horii nyaatu mara, ka dhidhate san aninuu bakka buuse malee, ani gara keeti hin finne. Horii halkan yookiin guyyaa hatamelle, na kaffalchiitte. ");
INSERT INTO gax_vpl VALUES ("GN31_40","002_31_40","GEN","31","40","40","Yennaa hedduu guyyaa o'aan, halkan boojji'iin rakkadhe; rafiisalle hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("GN31_41","002_31_41","GEN","31","41","41","Ani woggaa diddama akka kanaan mana keeti keessa ture; woggaa kudhanii afur durra teeti lamaan fuudhiisaaf, woggaa jaa hoole'ee fi re'ee teeti dhaggatiisaaf tajaajile. Yennaa san keessatti ati mindaa kiyya yennaa kudhan jijjiirte. ");
INSERT INTO gax_vpl VALUES ("GN31_42","002_31_42","GEN","31","42","42","Waaqi abbaa kiyyaa, Waaqi Abrahaamii, ka Yisihaq isa sodaatu adoo na woliin hin jiraatinii, ati silaa harka duwwaa na ariiteertaayyu. Ammoo Waaqi rakkoo tiyyaa fi eloo tiyya dhaggee, halkan edaa si xixe» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN31_43","002_31_43","GEN","31","43","43","Laabaan deebisee, «Dubartooti tun durra tiyya; ijoolleen isaaniille ijoollee tiyya; hoole'ee fi re'een tun tiyya. Wonni ati dhaggitu kun martinuu tiyya. Durra tiyya tanaa fi ijoollee isaanii ammoo ani attam miidhuu dande'a ree? ");
INSERT INTO gax_vpl VALUES ("GN31_44","002_31_44","GEN","31","44","44","Koottu amma anii fi ati wolii galtee godhanna; wolii galtee san qaabatiisaaf soodduu dhaabbanna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN31_45","002_31_45","GEN","31","45","45","Maarre Yaaqoob dhakaa tokko fuudhee soodduu dhaabe. ");
INSERT INTO gax_vpl VALUES ("GN31_46","002_31_46","GEN","31","46","46","Inni firoota ifiitiin «Dhakaa wolitti qaba'a» jedhe; isaanille dhakaa wolitti qabanee tuulaneen duuba, tuulaa san biratti sagalee nyaatane. ");
INSERT INTO gax_vpl VALUES ("GN31_47","002_31_47","GEN","31","47","47","Laabaan tuulaa dhaka'aa san, afaan Aaramiitiin, «Yagaar-sahadutaa» jedhee moggaase. Yaaqoob ammoo afaan Ibrootaatiin, «Gaal-Ed» jedhee moggaase. ");
INSERT INTO gax_vpl VALUES ("GN31_48","002_31_48","GEN","31","48","48","Laabaan Yaaqoobiin, «Tuulaan dhaka'aa tun anaa fi si wodhakka'atti dhugaa baati» jedhe. Tanaaf addeen sun «Gaal-Ed» jedhante. ");
INSERT INTO gax_vpl VALUES ("GN31_49","002_31_49","GEN","31","49","49","Laabaan ammalle, «Yennaa nu gargar baanu Waaqi nu eeguutii» waan jedheef, addee saniin, «Miisphaa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN31_50","002_31_50","GEN","31","50","50","Laabaan itti dabalee, «Ati yoo durra tiyya rakkitte yookiin yoo dubartii dhibii fuute, eennulle nu woliin jiraachuu dhabulle, Waaqi dhugaa teenna akka te'e qaabadhu. ");
INSERT INTO gax_vpl VALUES ("GN31_51","002_31_51","GEN","31","51","51","Wodhakkaa teennatti dhakaan ani tuulee fi soodduun ani dhaabelle kunoo ti. ");
INSERT INTO gax_vpl VALUES ("GN31_52","002_31_52","GEN","31","52","52","Ani si miidhiisaaf tuulaa dhaka'aa tana akka hin dabarre, atille na miidhiisaaf tuulaa dhaka'aatii fi soodduu tana akka hin dabarre, tuulaa dhaka'aatii fi soodduun tun dhugaa baatota teenna. ");
INSERT INTO gax_vpl VALUES ("GN31_53","002_31_53","GEN","31","53","53","Yoo wolii galtee tana hin eegin, Waaqi Abrahaamii, Waaqi Naahoorii, Waaqi abbaa isaanii nu adabuu ti» jedhe. Achiin duuba, Yaaqoob maqaa Waaqa abbaan isaa Yisihaq sodaatuutiin wolii galtee tana eegatiisaaf kakate. ");
INSERT INTO gax_vpl VALUES ("GN31_54","002_31_54","GEN","31","54","54","Yaaqoob gaara irratti ciincaa dhikeessee, sagalee akka nyaatanuuf fira ifii waame. Isaan nyaataneen duuba, halkan achi bulane. ");
INSERT INTO gax_vpl VALUES ("GN31_55","002_31_55","GEN","31","55","55","Laabaan barii ganamaan ka'ee, akaakotaa fi durra ifii sunqatee, eebbise; achiin duuba inni gara mana ifii deebi'e. ");
INSERT INTO gax_vpl VALUES ("GN32_1","002_32_1","GEN","32","1","1","Yaaqoob adoo deemiisatti jiruu, ergantooti Waaqaa isa woliin wol wolde'ane. ");
INSERT INTO gax_vpl VALUES ("GN32_2","002_32_2","GEN","32","2","2","Inni yennaa isaan dhagge, «Kun quttuma Waaqaa ti» jedhee, maqaa addee sanii Mahanaayim baase. ");
INSERT INTO gax_vpl VALUES ("GN32_3","002_32_3","GEN","32","3","3","Yaaqoob ifiin dura gara biyya Edoomii, gara lafa Se'iir jedhantuu obboleessa ifii Esaawutti ergantoota erge. ");
INSERT INTO gax_vpl VALUES ("GN32_4","002_32_4","GEN","32","4","4","Yaaqoob worra erge san ajajee, «Goottaa kiyya Esaawu'uun, ‹Ani tajaajilaan keeti Yaaqoob haga ammaa alagaa te'ee Laabaan bira le'aa ture. ");
INSERT INTO gax_vpl VALUES ("GN32_5","002_32_5","GEN","32","5","5","Ani loonii fi harree, hoole'ee fi re'ee, tajaajiltoota dhiiraatii fi dubarti'ii qaba. Ani fudhatama akka dhaggadhuuf ergaa tana si goottaa kiyyatti himadha› jedheera Yaaqoob jedha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN32_6","002_32_6","GEN","32","6","6","Ergantooti yennaa gara Yaaqoobii deebi'anee dhufane, «Nuuti gara obboleessa keeti Esaawuu dhandheerra; innille amma gara keeti dhufiisatti jira; namooti dhibba afuriille isa woliin jiran» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN32_7","002_32_7","GEN","32","7","7","Yaaqoob guddoo sodaatee, yaaddowee, namoota isa bira jiranu, hoole'ee fi re'ee, loon, gaalalle golii lamatti gargar qoode. ");
INSERT INTO gax_vpl VALUES ("GN32_8","002_32_8","GEN","32","8","8","Inni, «Esaawuun golii tokko yoo miidhe, goliin tuun miliquu hin dandeetti» jedhee yaadee ti. ");
INSERT INTO gax_vpl VALUES ("GN32_9","002_32_9","GEN","32","9","9","Achiin duuba Yaaqoob daadimatee, «Ee, Waaqa akaakoo kiyya Abrahaamii, Waaqa abbaa kiyya Yisihaqii naa dhage'i! Sittuu, ‹Biyya keetitti, fira keetitti deebi'i; anille waan dansaa si'iif hin godha› anaan jedhe. ");
INSERT INTO gax_vpl VALUES ("GN32_10","002_32_10","GEN","32","10","10","Gadhi-laafumma'aa fi addatamummaan ati ana tajaajilaa keetitti mudhitte sun, naaf hin malle; yennaa qaraa ulee malee, ani womaa qabadhee laga Yordaanosii hin buune; amma golii lama tana woliin deebi'eera. ");
INSERT INTO gax_vpl VALUES ("GN32_11","002_32_11","GEN","32","11","11","Inni dhufee ana, haadhoti'ii fi ijoollee hin ijjeesa fa'a jedhee waan sodaadheef, ati harka obboleessa kiyya Esaawuu jalaa akka na baachu si gaafadha. ");
INSERT INTO gax_vpl VALUES ("GN32_12","002_32_12","GEN","32","12","12","Atuu, ‹Ani waan dansaa si'iif hin godha; sanyii teetille akka maansa abbaaya'aa, ka sababa bacinna isaatiif laakkowamuu hin dandeennee hin godha› jetteerta» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN32_13","002_32_13","GEN","32","13","13","Maarre inni halkan san achuma bulee, waan ifii qabu keessaa kennansa obboleessa ifii Esaawu'uuf dhikeessu, ");
INSERT INTO gax_vpl VALUES ("GN32_14","002_32_14","GEN","32","14","14","re'oota dhaltuu dhibba lamaa fi korbeeyyii re'ootaa diddama, hoolota dhaltuu dhibba lamaa fi korbeeyyii hoolotaa diddama, ");
INSERT INTO gax_vpl VALUES ("GN32_15","002_32_15","GEN","32","15","15","gaalota hoosisanu soddoma ilmoolee isaanii woliin, sa'oolee afurtamaa fi korommii kudhan, harreelee dhaltuu diddamaa fi harreelee wodala kudhan file. ");
INSERT INTO gax_vpl VALUES ("GN32_16","002_32_16","GEN","32","16","16","Inni horii kana cinna cinnaan qoqoodee, tajaajiltoota ifiititti kennee, «Anaan duratti dabara'aatii, wodhakkaa cinna cinna hori'iititti lafa lakkisa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN32_17","002_32_17","GEN","32","17","17","Yaaqoob tajaajilaa dura jiruun, «Esaawuun obboleessi kiyya sitti dhufee, ‹Ati ka eennuu ti? Eessa dhaxxa? Horiin ati oofattu kun ka eennuu ti?› jedhee yennaa si gaafate, ");
INSERT INTO gax_vpl VALUES ("GN32_18","002_32_18","GEN","32","18","18","ati, ‹Horiin kun ka tajaajilaa keeti Yaaqoobii ti. Inni horii kana goottaa kiyya Esaawu'uuf kennansa erge. Innille duuba keennaan dhufiisatti jira› jettaan» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN32_19","002_32_19","GEN","32","19","19","Yaaqoob cinna lammeesso'ootiin, cinna sadeesso'oolle'een, worra cinna hori'ii san oofu maraanuu, «Isinille yoo Esaawu isinitti dhufe, dubbuma tana itti hima'a. ");
INSERT INTO gax_vpl VALUES ("GN32_20","002_32_20","GEN","32","20","20","‹Kunoo, tajaajilaan keeti Yaaqoob nu duubaan dhufiisatti jira› jedha'aan» jedhee gorse. Yaaqoob, «Kennansa ani ifi dura ergeef kanaan Esaawu naa araarama fa'a. Achiin duuba ani yennaa isa dhagge, inni na fudhata fa'a te'a» jedhee yaade. ");
INSERT INTO gax_vpl VALUES ("GN32_21","002_32_21","GEN","32","21","21","Yaaqoob kennansa san dursee dabarsee ergee, ifiif ammoo halkan san addee quttumaa san bule. ");
INSERT INTO gax_vpl VALUES ("GN32_22","002_32_22","GEN","32","22","22","Yaaqoob halkanuma san ka'ee, niitota ifii lamaan, tajaajiltoota ifii ta durraa lamaanii fi ijoollee ifii kudhanii tokko fudhatee laga Yaaboqiitiin gamatti bu'e. ");
INSERT INTO gax_vpl VALUES ("GN32_23","002_32_23","GEN","32","23","23","Inni gamatti isaan buuseen duuba, waan qabu maralle gamatti buuse. ");
INSERT INTO gax_vpl VALUES ("GN32_24","002_32_24","GEN","32","24","24","Inni ammoo qofuu hafe. Achiin duuba nami tokko dhufee haga boruun dayya'utti Yaaqoob woliin wodhaantoo qabate. ");
INSERT INTO gax_vpl VALUES ("GN32_25","002_32_25","GEN","32","25","25","Namichi sun akka dande'ee Yaaqoob hin injifanne yennaa dhagge, luqqee Yaaqoobii dhowe; Yaaqoobille adoo isaa woliin wodhaantoo qabatuu kurreen Yaaqoobii buqqaate. ");
INSERT INTO gax_vpl VALUES ("GN32_26","002_32_26","GEN","32","26","26","Achiin duuba namichi, Yaaqoobiin, «Boruun dayya'aaraa, na lakkis!» jedhe. Yaaqoob ammoo, «Yoo na eebbitte malee, ani si hin lakkisu!» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN32_27","002_32_27","GEN","32","27","27","Maarre namichi, «Maqaan keeti eennu?» jedhee gaafate. Innille deebisee, «Maqaan kiyya Yaaqoob» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN32_28","002_32_28","GEN","32","28","28","Achiin duuba namichi, «Ati Waaqaa fi nama woliin wodhaantoo qabattee injifatteerta; tanaaf, haganaa achi maqaan keeti Israa'el jedhamuu ti malee, Yaaqoob hin jedhamin» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN32_29","002_32_29","GEN","32","29","29","Achiin duuba Yaaqoob, namichaan, «Maganne'ee maqaa keeti natti himi!» jedhee isa gaafate. Inni ammoo, «Maqaa kiyya maaf gaafatta?» jedhee, achitti isa eebbise. ");
INSERT INTO gax_vpl VALUES ("GN32_30","002_32_30","GEN","32","30","30","Yaaqoobille, «Ani Waaqa fuula kiyya duratti dhaggee, haga ammaa jiru'uun jira» jedhe; tanaaf maqaa addee sanii, «Pheeni'el» jedhee moggaase. ");
INSERT INTO gax_vpl VALUES ("GN32_31","002_32_31","GEN","32","31","31","Yaaqoob pheeni'elii ka'ee deemiisatti jiruun aduun baate; inni luqqee waan miidhameef hokkoliisatti jiraayyu. ");
INSERT INTO gax_vpl VALUES ("GN32_32","002_32_32","GEN","32","32","32","Yaaqoob namicha woliin wodhaantoo qabatuun, namichi foon kurree luqqee isaa irraa waan dhoweef, Israa'elooti haga adhaa foon kurree luqqee irraa hin nyaatanu. ");
INSERT INTO gax_vpl VALUES ("GN33_1","002_33_1","GEN","33","1","1","Yaaqoob ol ilaalee, Esaawuun namoota dhibba afur woliin dhufiisatti jiruun dhagge; tanaaf inni ijoollee Liya'atti, Raahelii fi dubartoota tajaajiltoota lamaanitti qoqoode. ");
INSERT INTO gax_vpl VALUES ("GN33_2","002_33_2","GEN","33","2","2","Inni dubartoota tajaajiltoota lamaan ijoollee isaanii woliin dura aansee, Liya'aa fi ijoollee isi'ii itti aansee, Raahelii fi Yoseef duuba aanse. ");
INSERT INTO gax_vpl VALUES ("GN33_3","002_33_3","GEN","33","3","3","Yaaqoob isaaniin dura deemee, haga obboleessa ifii bira gewutti yennaa torba lafatti gad isaaf gombifame. ");
INSERT INTO gax_vpl VALUES ("GN33_4","002_33_4","GEN","33","4","4","Esaawu ammoo isa qophatiisaaf itti rukkisee, hanqafatee isa sunqate. Isaan lamaanuu bowane. ");
INSERT INTO gax_vpl VALUES ("GN33_5","002_33_5","GEN","33","5","5","Esaawu ol ilaalee, dubartootaa fi ijoollee yennaa dhagge, «Kolbaan si woliin jirtu tun ta eennuu ti?» jedhee gaafate. Yaaqoob, «Isaan, ijoollee Waaqi badhaadha ifiitiin ana tajaajilaa keetiif kenne» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN33_6","002_33_6","GEN","33","6","6","Achiin duuba dubartooti tajaajiltoota ijoollee ifii woliin dhufanee gad gombifamaneef; ");
INSERT INTO gax_vpl VALUES ("GN33_7","002_33_7","GEN","33","7","7","achiin duuba Liya'aa fi ijoolleen isi'ii dhufanee gad gombifamaneef; dhuma irratti Raahelii fi Yoseefille dhufanee gad gombifamaneef. ");
INSERT INTO gax_vpl VALUES ("GN33_8","002_33_8","GEN","33","8","8","Esaawu, «Horiin cinna cinnaan oofanuun dhagge kana maan yaaddee naaf ergite?» jedhee gaafate. Yaaqoob deebisee, «Goottaa kiyya, si duratti fudhatama dhaggatiisaaf erge» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN33_9","002_33_9","GEN","33","9","9","Esaawu ammoo, «Obboleessa kiyya, ani bacaa qaba. Keeti si'iifuu te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN33_10","002_33_10","GEN","33","10","10","Yaaqoob, «Waawwo'o; ani si duratti fudhatama yoo dhaggadhe, kennansa kiyya ana irraa fudhadhu. Ati waan na fudhatteef, fuula keeti dhaggiisi, fuula Waaqaa akka dhaggeetitti laakkowa. ");
INSERT INTO gax_vpl VALUES ("GN33_11","002_33_11","GEN","33","11","11","Waaqi arjumma'aan waan naaf barbaachisu mara waan kenneef, maganne'ee kennansa ani si'iif fide kana fudhadhu» jedhe. Yaaqoob waan isa uttiseef, Esaawu kennansa fudhate. ");
INSERT INTO gax_vpl VALUES ("GN33_12","002_33_12","GEN","33","12","12","Achiin duuba Esaawu, «Ka'i ideennaa ti. Ani si dura hin deema» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN33_13","002_33_13","GEN","33","13","13","Yaaqoob ammoo deebisee, «Goottaa kiyya, ijoolleen, hoole'ee fi re'een, ilmooleen isaaniille, loonii fi jabbiin dadhaboolee akka te'ane hin beetta. Guyyuma tokkoofille ariiti'iin yoo oofamane, isaan martinuu hin du'an. ");
INSERT INTO gax_vpl VALUES ("GN33_14","002_33_14","GEN","33","14","14","Tanaaf, maganne'ee goottaa kiyya, ati ana tajaajilaa keeti dura deemi. Ani akka ideensa hori'iitii fi ijoolle'eetitti laanuma haga Edoomitti si dhaqqabutti si hordofa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN33_15","002_33_15","GEN","33","15","15","Esaawu deebisee, «Namoota na woliin jiranu keessaa garii si biratti lakkisa» jedhe. Yaaqoob ammoo, «Ani fuula goottaa kiyyaa duratti fudhatama dhaggatiisa qofa malee, kun maaniif barbaachisa?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN33_16","002_33_16","GEN","33","16","16","Tanaaf Esaawu gaafuma san gara Edoomii deebi'e. ");
INSERT INTO gax_vpl VALUES ("GN33_17","002_33_17","GEN","33","17","17","Yaaqoob ammoo gara addee, «Suukoot» jedhantuu ideemee, achitti ifiif mana, loon ifiitiif gosee ijaare; tanaaf maqaa addee sanii, «Suukoot» jedhee moggaase. ");
INSERT INTO gax_vpl VALUES ("GN33_18","002_33_18","GEN","33","18","18","Yaaqoob phaadaan-Aaramii yennaa deebi'e, nageyaan gara qachaa Sheekemii ka biyya Kana'aanii keessaa dhufe; inni achi qacha'aan fuula dura qubate. ");
INSERT INTO gax_vpl VALUES ("GN33_19","002_33_19","GEN","33","19","19","Inni sanyii Hamoorii, abbaa Sheekemii irraa lafa dunkaanii irratti dhaabate san, meetii dhibbaan bitate. ");
INSERT INTO gax_vpl VALUES ("GN33_20","002_33_20","GEN","33","20","20","Inni achitti addee ciinca'aa ijaaree, «Waaqi, Waaqa Israa'elii ti» jedhee maqaa baase. ");
INSERT INTO gax_vpl VALUES ("GN34_1","002_34_1","GEN","34","1","1","Gaafa tokko Dinaan intalti Yaaqoobii, ta Liyaan deette, dubartoota biyya sanii ilaaliisaaf gad baate. ");
INSERT INTO gax_vpl VALUES ("GN34_2","002_34_2","GEN","34","2","2","Sheekemiin ilmi Hamoorii, nami gosa Hiiwoo, bulchaan lafa sanii, yennaa isii dhagge, hunnaan bantii isi'ii balleesse. ");
INSERT INTO gax_vpl VALUES ("GN34_3","002_34_3","GEN","34","3","3","Inni ammoo shaggummaa Dina'aatiin booji'amee, isii jaalatee, akka isiille isa jaalattuuf hawadate. ");
INSERT INTO gax_vpl VALUES ("GN34_4","002_34_4","GEN","34","4","4","Abbaa ifiille'een, «Intala tana na fuusis» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN34_5","002_34_5","GEN","34","5","5","Yaaqoob intalti isaa Dinaan akka bantii badde dhage'e; ilmaan isaa ammoo horii isaa keessa ala waan jiranuuf, haga isaan deebi'anee dhufanutti cadhi jedhe. ");
INSERT INTO gax_vpl VALUES ("GN34_6","002_34_6","GEN","34","6","6","Achiin duuba abbaan Sheekemii Hamoor Yaaqoob woliin dubbatiisaaf bayee dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN34_7","002_34_7","GEN","34","7","7","Ilmaan Yaaqoobii akkuma tikaa dhufaneen waan te'e dhage'ane. Sheekem intala Yaaqoobii hunnaan bantii balleessiisaan kolbaa Israa'elii waan salphiseef, isaan guddoo aarane. ");
INSERT INTO gax_vpl VALUES ("GN34_8","002_34_8","GEN","34","8","8","Hamoor ammoo obboleeyyan Dina'aatiin, «Ilmi kiyya Sheekem intala teessan guddoo jaalateera. Maganne'ee fuudhuutii kenna'aaf. ");
INSERT INTO gax_vpl VALUES ("GN34_9","002_34_9","GEN","34","9","9","Ilmaanii fi durri teenna wol fuudhanuu ti; durra teessan nuu kenna'a; isinille durra teenna fuudha'a. ");
INSERT INTO gax_vpl VALUES ("GN34_10","002_34_10","GEN","34","10","10","As biyya teenna keessa nu woliin turuu dandeettan; addee feetane le'aa, daldalataa lafa qabaatuu hin dandeettan» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN34_11","002_34_11","GEN","34","11","11","Sheekem abbaa Dina'aatii fi obboleeyyan Dina'aatiin, «Ani fuula keessan duratti fudhatama dhaggadhuutii malee, waanuma isin jettane hin kenna. ");
INSERT INTO gax_vpl VALUES ("GN34_12","002_34_12","GEN","34","12","12","Gatii intalaa haga feetane na gaafadha'a; isuma callaa fuudhuutii malee, waan isin feetane mara hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN34_13","002_34_13","GEN","34","13","13","Sheekem obboleettii isaanii Dinaa waan bantii balleesseef, ilmaan Yaaqoobii, isaa fi Hamoorii abbaa isaatiif sobaan deebii kennaneef. ");
INSERT INTO gax_vpl VALUES ("GN34_14","002_34_14","GEN","34","14","14","Isaan, Sheekemii fi abbaa isaatiin, «Nuuti nama haqanqabaa hin qabatiniif, obboleettii teenna kennuu hin dandeennu; kun nu'uuf salphinna. ");
INSERT INTO gax_vpl VALUES ("GN34_15","002_34_15","GEN","34","15","15","Isin akka keenna teetanee, dhiirti teessan duudiin haqanqabaa akka qabatanu yoo gootane qofa, isii isiniif kennuu dandeenna. ");
INSERT INTO gax_vpl VALUES ("GN34_16","002_34_16","GEN","34","16","16","Achiin duuba nuuti durra teenna isiniif hin kennina; nuutille durra teessan hin fuuna; kolbaa tokko teenee woliin hin leena. ");
INSERT INTO gax_vpl VALUES ("GN34_17","002_34_17","GEN","34","17","17","Isin yoo nu dhage'uu dhaddanee haqanqabaa qabatuu diddane, nuuti intala teenna fudhannee hin ideenna» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN34_18","002_34_18","GEN","34","18","18","Wonni isaan dubbatane Hamoorii fi ilma isaa Sheekemitti dansaa teetee mudhatte. ");
INSERT INTO gax_vpl VALUES ("GN34_19","002_34_19","GEN","34","19","19","Sheekem intala Yaaqoobii waan jaalateef, waan jedhame godhiisaaf hin turre; inni namoota mana abbaa ifii mara caalaa ulfinna qabaayyu. ");
INSERT INTO gax_vpl VALUES ("GN34_20","002_34_20","GEN","34","20","20","Maarre Hamoorii fi ilma isaa Sheekem gara karra qachaa ifii dhaqanee, namoota qachaa saniitiin, ");
INSERT INTO gax_vpl VALUES ("GN34_21","002_34_21","GEN","34","21","21","«Kolbaan tun kolbaa nageyaa ti; nu woliin lafa tana le'anuu ti; bilisaan asii fi achi deddeemanee daldalatanuu ti; kunoo latti nu'uu fi isaaniifille hin geetti; nuutille durra isaanii hin fuuna; durra teennalle isaaniif hin kennina. ");
INSERT INTO gax_vpl VALUES ("GN34_22","002_34_22","GEN","34","22","22","Akkuma isaanii, dhiirti teenna martinuu yoo haqanqabaa qabanne qofa isaaniin wolii gallee woliin leena; kolbaa tokkolle hin teena. ");
INSERT INTO gax_vpl VALUES ("GN34_23","002_34_23","GEN","34","23","23","Yoo akkana goone, loon isaanii, qabeennii fi horiin isaanii marti keenna hin te'anii motii ree? Waan isaan jedhane yoo wolii galle qofa, isaan nu woliin le'uu dande'an» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN34_24","002_34_24","GEN","34","24","24","Kolbaan qacha'aa marti yaada Hamoorii fi ilma isaa Sheekem dhikeessane irratti wolii galanee, dhiirti marti haqanqabaa qabatane. ");
INSERT INTO gax_vpl VALUES ("GN34_25","002_34_25","GEN","34","25","25","Guyyaa sadiin duuba, dhiirti haqanqabaa qabatte adoo hin fayyin, ilmaan Yaaqoobii lamaan, obboleeyyan Dina'aa Shimi'oonii fi Lewwiin, shallaagaa ifii fudhatanee, eennulle adoo hin beekin, gara qacha'aa seenanee, dhiira mara, ");
INSERT INTO gax_vpl VALUES ("GN34_26","002_34_26","GEN","34","26","26","Hamoorii fi ilma isaa Sheekemille ijjeesane. Achiin duuba Dinaa mana Sheekemiitii fudhatanee deemane. ");
INSERT INTO gax_vpl VALUES ("GN34_27","002_34_27","GEN","34","27","27","Ilmaan Yaaqoobii dhibiin reeffa irra dhufanee, sababa obboleettiin isaanii bantii baddeef, qachaa san saamane. ");
INSERT INTO gax_vpl VALUES ("GN34_28","002_34_28","GEN","34","28","28","Isaan hoole'ee fi re'ee isaanii, loon isaanii, harree isaanii, waan qachaa keessaatii fi alaa mara fudhatane. ");
INSERT INTO gax_vpl VALUES ("GN34_29","002_34_29","GEN","34","29","29","Isaan waan gatii qabu mara fudhatanee, dubarti'ii fi ijoollee mara booji'anee, waan mana keessa jiru mara saamane. ");
INSERT INTO gax_vpl VALUES ("GN34_30","002_34_30","GEN","34","30","30","Yaaqoob Shimi'oonii fi Lewwi'iin, «Worri biyya tanaa, worri Kana'aanii, worri Pheriizonii jibbanee akka na ijjeesanu godhiisaan, rakkoo natti fiddane; laakkossi nama kiyyaa diqqa'a. Isaan wolitti dacha'anee yoo na lolan; anii fi maatiin tiyya hin banna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN34_31","002_34_31","GEN","34","31","31","Shimi'oonii fi Lewwiin deebisanee, «Sheekem obboleettii teenna akka sagaagaltitti'ii tolchuutii ree?» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN35_1","002_35_1","GEN","35","1","1","Waaqi Yaaqoobiin, «Ka'ii gara Bet'elii ol bayii, achi le'i! Yennaa ati obboleessa keeti Esaawu duraa baqatte ana Waaqa sitti mudhateef, addee ciinca'aa ijaar!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN35_2","002_35_2","GEN","35","2","2","Tanaaf Yaaqoob maatii ifiitii fi worra isa woliin jiruun, «Waaqota orma odduu teessanii qaddanu baasa'a; nafa keessan qulqulleeffadha'a; woyaa teessanille jijjiiradha'a. ");
INSERT INTO gax_vpl VALUES ("GN35_3","002_35_3","GEN","35","3","3","Kowaa gara Bet'elii deenna. Waaqa yennaa rakkoo tiyyaa na qarqaaree, addee maratti na woliin jiraateef, addee ciinca'aa achitti hin ijaara» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN35_4","002_35_4","GEN","35","4","4","Maarre isaan waaqota orma odduu ifiitii qabanu mara, qubee gurraalle Yaaqoobitti kennanee, inni qilxaa guddaa qachaa Sheekemii biraa jalatti awwaale. ");
INSERT INTO gax_vpl VALUES ("GN35_5","002_35_5","GEN","35","5","5","Yennaa Yaaqoobii fi maatiin isaa achii deemiisaaf ka'ane, Waaqi kolbaa adaala qachootaa irratti sodaa guddoo waan buuseef, isaan hin hordonne. ");
INSERT INTO gax_vpl VALUES ("GN35_6","002_35_6","GEN","35","6","6","Yaaqoob worra isa woliin jiru mara woliin gara Luzii, lafa Kana'aan keessaa, ta amma Bet'el jedhantuu dhaqane. ");
INSERT INTO gax_vpl VALUES ("GN35_7","002_35_7","GEN","35","7","7","Yaaqoob achitti addee ciinca'aa ijaare; yennaa inni obboleessa ifii duraa baqatee ideeme, Waaqi achitti waan isatti mudhateeruuf, addee san, «El-Bet'el» jedhee maqaa baase. ");
INSERT INTO gax_vpl VALUES ("GN35_8","002_35_8","GEN","35","8","8","Yennaa san Deboraan Ribqaa gudditte duutee, qilxaa Bet'el irraa gara kibbaa jiru tokko jalatti awwaalante; tanaaf qilxaan sun, «Qilxaa bowaa» jedhame. ");
INSERT INTO gax_vpl VALUES ("GN35_9","002_35_9","GEN","35","9","9","Yennaa Yaaqoob phaadaan-Aaramii deebi'ee dhufe, Waaqi ammalle isatti mudhatee, isa eebbise. ");
INSERT INTO gax_vpl VALUES ("GN35_10","002_35_10","GEN","35","10","10","Waaqi, «Maqaan keeti Yaaqoob; haganaa achi ammoo maqaan keeti, ‹Israa'el› jedhama malee, ‹Yaaqoob› hin jedhamu» jedheen. Tanaaf akkuma Waaqi maqaa isa moggaasetti maqaan isaa, «Israa'el» jedhame. ");
INSERT INTO gax_vpl VALUES ("GN35_11","002_35_11","GEN","35","11","11","Waaqi isaan, «Ani Waaqa waan mara dande'u. Hori, bacadhu! Gosi biyya adda addaa si irraa hin dhaggaman; moototille si irraa hin dhalatan. ");
INSERT INTO gax_vpl VALUES ("GN35_12","002_35_12","GEN","35","12","12","Lafuma Abrahaamii fi Yisihaqiif kenne, si'ii fi sanyii teetiifille hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN35_13","002_35_13","GEN","35","13","13","Achiin duuba Waaqi addee isatti dubbate sanitti isa lakkisee biraa ol baye. ");
INSERT INTO gax_vpl VALUES ("GN35_14","002_35_14","GEN","35","14","14","Yaaqoob addee Waaqi isatti dubbate sanitti soodduu dhaabee, daadhii woyni'iitii fi zayitii ejersaa irratti dhangalaase. ");
INSERT INTO gax_vpl VALUES ("GN35_15","002_35_15","GEN","35","15","15","Tanaaf Yaaqoob maqaa addee Waaqi isatti dubbatee san, «Bet'el» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("GN35_16","002_35_16","GEN","35","16","16","Yaaqoobii fi maatiin isaa Bet'elii ka'anee, biyya Efraataa geyaaranuun, Raahel ciniinsuu jadduu ciniinsifatte. ");
INSERT INTO gax_vpl VALUES ("GN35_17","002_35_17","GEN","35","17","17","Ciniinsuun yennaa itti jabaatte, dubartiin deessittuu isi'ii, «Raahel, ati ilma dhibii waan deyaartuuf hin sodaatin!» jetteen. ");
INSERT INTO gax_vpl VALUES ("GN35_18","002_35_18","GEN","35","18","18","Raahel ammoo du'iisaaf lubbuun keessaa bayaartuun, maqaa muca'aa, «Ben-Onii» jettee baatte. Abbaan isaa ammoo, «Beniyaamin» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("GN35_19","002_35_19","GEN","35","19","19","Achiin duuba Raahel duutee, karaa Efraataa dhaqu, ka amma Betlihem jedhamu cina'atti awwaalante. ");
INSERT INTO gax_vpl VALUES ("GN35_20","002_35_20","GEN","35","20","20","Yaaqoob irreensa Raahelii irratti soodduu dhaabe. Soodduun sun haga adhaa achi jirti. ");
INSERT INTO gax_vpl VALUES ("GN35_21","002_35_21","GEN","35","21","21","Israa'el achii deemee, xelleephoo Edariitiin gara kaanitti qubate. ");
INSERT INTO gax_vpl VALUES ("GN35_22","002_35_22","GEN","35","22","22","Yaaqoob lafa san adoo le'iisatti jiruu, Ruuben niitii abbaa ifii Bilhaa gursumeettii woliin rafe; Yaaqoobille waan kana dhage'e. Yaaqoob ilmaan kudhanii lama qabaayyu. ");
INSERT INTO gax_vpl VALUES ("GN35_23","002_35_23","GEN","35","23","23","Ilmaan Liyaan Yaaqoobiif deette: Ruuben ilma angaficha, Shimi'oon, Lewwii, Yihudaa, Yisaakor, Zebuloon. ");
INSERT INTO gax_vpl VALUES ("GN35_24","002_35_24","GEN","35","24","24","Ilmaan Raahel Yaaqoobiif deette: Yoseefii fi Beniyaamin. ");
INSERT INTO gax_vpl VALUES ("GN35_25","002_35_25","GEN","35","25","25","Ilmaan garbittiin Raahelii Bilbaan Yaaqoobiif deette: Daanii fi Naftaalem. ");
INSERT INTO gax_vpl VALUES ("GN35_26","002_35_26","GEN","35","26","26","Ilmaan garbittii Liya'aa Zilfaan Yaaqoobiif deette: Gaadii fi Asheer. Ilmaan Yaaqoobii worri phaadaan-Aaramitti dhalatane isaan kana. ");
INSERT INTO gax_vpl VALUES ("GN35_27","002_35_27","GEN","35","27","27","Yaaqoob qachaa Mamre'eetitti Kebroon bira, addee Abrahaamii fi Yisihaq le'ane gara abbaa ifii Yisihaqii dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN35_28","002_35_28","GEN","35","28","28","Yisihaq woggaa dhibbaa fi saddeettama le'e. ");
INSERT INTO gax_vpl VALUES ("GN35_29","002_35_29","GEN","35","29","29","Yisihaq guddoo dulloomee, baralle quufee du'e; ilmaan isaa Esaawu'uu fi Yaaqoob isa awwaalane. ");
INSERT INTO gax_vpl VALUES ("GN36_1","002_36_1","GEN","36","1","1","Hiddi sanyii Esaawuu ka «Edoom» jedhamuu asii gad jiran. ");
INSERT INTO gax_vpl VALUES ("GN36_2","002_36_2","GEN","36","2","2","Esaawuun dubartoota Kana'aan keessaa, Aadaa intala Eloonii nama gosa Heetii, Oholiibaamaa intala Aannaa ilma Zibe'onii nama gosa Hiiwoo fuudhe; ");
INSERT INTO gax_vpl VALUES ("GN36_3","002_36_3","GEN","36","3","3","ammalle intala Ishimaa'elii, obboleettii Nabaayootii, Basmaati fuudhe. ");
INSERT INTO gax_vpl VALUES ("GN36_4","002_36_4","GEN","36","4","4","Aadaan, Eliifaaziin isaaf deette; Basmaati Rewu'el deetteef; ");
INSERT INTO gax_vpl VALUES ("GN36_5","002_36_5","GEN","36","5","5","Oholiibaamaan ammoo Ye'ush, Yaalamii fi Qoraahi deetteef; ilmaan Esaawu'uu tun biyya Kana'aaniititti dhalatane. ");
INSERT INTO gax_vpl VALUES ("GN36_6","002_36_6","GEN","36","6","6","Esaawuun dubartoota ifii, ilmaan ifii, durra ifii, namoota mana ifii mara, loon, horii dhibii mara, qabeenna biyya Kana'aaniititti horate maralle fudhatee, Yaaqoobii obboleessa ifii biraa ka'ee, gara lafa dhibi'ii deeme. ");
INSERT INTO gax_vpl VALUES ("GN36_7","002_36_7","GEN","36","7","7","Qabeenni isaanii guddoo waan bacateef, latti isaan gewuu waan dhaddeef, isaan lamaanuu woliin le'iisa hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("GN36_8","002_36_8","GEN","36","8","8","Tanaaf Esaawuun ka «Edoom» jedhamu biyya koobittii Se'iir keessa le'e. ");
INSERT INTO gax_vpl VALUES ("GN36_9","002_36_9","GEN","36","9","9","Hiddi dhaloota sanyii Esaawu'uu, ka «Edoomota» jedhamanu, worra biyya koobittii Se'iir keessa le'eef abbaa ka te'ee, asii gad jiran. ");
INSERT INTO gax_vpl VALUES ("GN36_10","002_36_10","GEN","36","10","10","Esaawuun niitii ifii Aadaa irraa ilma Eliifaaz, niitii ifii Basmaati irraa ilma Rewu'el uumate. ");
INSERT INTO gax_vpl VALUES ("GN36_11","002_36_11","GEN","36","11","11","Ilmaan Eliifaazii: Temaan, Omaar, Zafoo, Gaataamii fi Qenaz. ");
INSERT INTO gax_vpl VALUES ("GN36_12","002_36_12","GEN","36","12","12","Eliifaaziin ilmi Esaawu'uu, niitii gursumeettii «Tiimnaa» jedhantu qabaayyu; isiille Amaaleqi deetteef. Isaan kun akkoowwan Aadaa haadha manaa Esaawu'uu ti. ");
INSERT INTO gax_vpl VALUES ("GN36_13","002_36_13","GEN","36","13","13","Ilmaan Rewu'elii: Naahaat, Zeraa, Shamaa fi Miiza'a. Isaan kun akkoowwan Basmaatii haadha manaa Esaawu'uu ti. ");
INSERT INTO gax_vpl VALUES ("GN36_14","002_36_14","GEN","36","14","14","Oholiibaamaan, niitiin Esaawu'uu, intalti Aannaa ilma Zibe'onii, ilmaan, «Ye'ush, Yaalam, Qoraahi» jedhamanu Esaawu'uuf deette. ");
INSERT INTO gax_vpl VALUES ("GN36_15","002_36_15","GEN","36","15","15","Bulchitooti sanyii Esaawu'uu, ta ilma isaa angaficha Eliifaaz irraa dhutte: Temaan, Omaar, Zafoo, Qenaz, ");
INSERT INTO gax_vpl VALUES ("GN36_16","002_36_16","GEN","36","16","16","Qoraahi, Gaataamii fi Amaaleqi; isaan ilmaan Eliifaazii worra lafa Edoomiititti bulchitoota te'e, akkoowwan Aadaa haadha manaa Esaawu'uu ti. ");
INSERT INTO gax_vpl VALUES ("GN36_17","002_36_17","GEN","36","17","17","Bulchitooti sanyii Rewu'elii ilma Esaawu'uu: Naahaat, Zeraa, Shamaa fi Miiza'a; isaan kun ilmaan Rewu'elii worra lafa Edoomiititti bulchitoota te'ane, akkoowwan Basmaatii haadha manaa Esaawu'uu ti. ");
INSERT INTO gax_vpl VALUES ("GN36_18","002_36_18","GEN","36","18","18","Worri Oholiibaamaa haadha manaa Esaawu'uu irraa dhalatanee, bulchitoota te'ane: Ye'ush, Yaalamii fi Qoraahi; isaan kun Oholiibaamaa haadha manaa Esaawu'uu intala Aannaa irraa dhalatanee bulchitoota te'ane. ");
INSERT INTO gax_vpl VALUES ("GN36_19","002_36_19","GEN","36","19","19","Isaan kun sanyii Esaawu'uu ka «Edoom» jedhamuu, worra bulchitoota te'ane. ");
INSERT INTO gax_vpl VALUES ("GN36_20","002_36_20","GEN","36","20","20","Ilmaan Se'iirii nama biyya Hoorii, worri duruu biyya keessa jiranu: Loxaan, Shobaal, Zibe'on, Aannaa, ");
INSERT INTO gax_vpl VALUES ("GN36_21","002_36_21","GEN","36","21","21","Diishon, Ezerii fi Diishaan; isaan kun lafa Edoomiititti worra bulchitoota gosa Hoorii te'ane. ");
INSERT INTO gax_vpl VALUES ("GN36_22","002_36_22","GEN","36","22","22","Ilmaan Loxaanii: Hoorii fi Hemaan; Tiimnaan obboleettii Loxaanii ti. ");
INSERT INTO gax_vpl VALUES ("GN36_23","002_36_23","GEN","36","23","23","Ilmaan Shobaalii: Alwaa, Manahaat, Ebaal, Shefoo fi Onaam. ");
INSERT INTO gax_vpl VALUES ("GN36_24","002_36_24","GEN","36","24","24","Ilmaan Zebe'onii: Ayya'aa fi Aannaan; Aannaaniin kun harree Zibe'onii abbaa ifii adoo tissuu, goomolee keessatti ka madda o'u dhagge. ");
INSERT INTO gax_vpl VALUES ("GN36_25","002_36_25","GEN","36","25","25","Ilmi Aanna'aa Diishon; intalti isaa Oholiibaama'a. ");
INSERT INTO gax_vpl VALUES ("GN36_26","002_36_26","GEN","36","26","26","Ilmaan Diishonii: Hemdaan, Eshibaan, Yitraanii fi Keraan. ");
INSERT INTO gax_vpl VALUES ("GN36_27","002_36_27","GEN","36","27","27","Ilmaan Ezerii: Bilhaa, Zaawaanii fi Aqaan. ");
INSERT INTO gax_vpl VALUES ("GN36_28","002_36_28","GEN","36","28","28","Ilmaan Diishaanii: Uzii fi Aaraan. ");
INSERT INTO gax_vpl VALUES ("GN36_29","002_36_29","GEN","36","29","29","Bulchitooti worra gosa hoorii: Loxaan, Shobaal, Zibe'on, Aannaa, ");
INSERT INTO gax_vpl VALUES ("GN36_30","002_36_30","GEN","36","30","30","Diishon, Ezer, Diishaan. Isaan kun lafa Edoomiititti worra bulchitoota gosa Hoorii te'ane. ");
INSERT INTO gax_vpl VALUES ("GN36_31","002_36_31","GEN","36","31","31","Israa'el irratti mootiin adoo hin mootomin dura, lafa Edoomii irratti moototi mootomane ka asii gad jiranu. ");
INSERT INTO gax_vpl VALUES ("GN36_32","002_36_32","GEN","36","32","32","Bel'aan ilmi Be'orii biyya Edoomii irratti mootii te'e; maqaan qachaa isaa Diinhaba'a. ");
INSERT INTO gax_vpl VALUES ("GN36_33","002_36_33","GEN","36","33","33","Bel'aan yennaa du'e, Yobaab ilmi Zera'aa nami biyya Bozra'aa mootii te'e. ");
INSERT INTO gax_vpl VALUES ("GN36_34","002_36_34","GEN","36","34","34","Yobaab yennaa du'e, Hushaam nami biyya Teema'aa mootii te'e. ");
INSERT INTO gax_vpl VALUES ("GN36_35","002_36_35","GEN","36","35","35","Hushaam yennaa du'e, Hadaad ilmi Badadii ka cinaa biyya Mo'aabiititti worra Miidiyaanii injifate mootii te'e; maqaan qachaa isaalle Aawiit jedhama. ");
INSERT INTO gax_vpl VALUES ("GN36_36","002_36_36","GEN","36","36","36","Hadaad yennaa du'e, Samlaan nami biyya Masreqa'aa mootii te'e. ");
INSERT INTO gax_vpl VALUES ("GN36_37","002_36_37","GEN","36","37","37","Samlaan yennaa du'e, Shaawul nami qachaa Rehobotii ka laga qarqaraa mootii te'e. ");
INSERT INTO gax_vpl VALUES ("GN36_38","002_36_38","GEN","36","38","38","Shaawul yennaa du'e, Ba'aal-Hanaan ilmi Akborii mootii te'e. ");
INSERT INTO gax_vpl VALUES ("GN36_39","002_36_39","GEN","36","39","39","Ba'aal-Hanaan ilmi Akborii yennaa du'e, Hadaad mootii te'e; maqaan qachaa isaa Phaawu jedhama. Niitiin isaa ta «Mahexaabel» jedhantu, intala Maxiredii nama biyya Mezahabii ti. ");
INSERT INTO gax_vpl VALUES ("GN36_40","002_36_40","GEN","36","40","40","Bulchitooti sanyii Esaawu'uu irraa dhufane tun, akka maatii maatii isaaniititti, akka addee addee isaaniititti tarreeffamaneeran. Maqaan isaanii: Tiimnaa, Alwaa, Yetet, ");
INSERT INTO gax_vpl VALUES ("GN36_41","002_36_41","GEN","36","41","41","Oholiibaamaa, Elaa, Phiinon, ");
INSERT INTO gax_vpl VALUES ("GN36_42","002_36_42","GEN","36","42","42","Qenaz, Temaan, Miibzaar, ");
INSERT INTO gax_vpl VALUES ("GN36_43","002_36_43","GEN","36","43","43","Magdii'elii fi Iraam. Isaan kun sanyii Esaawu'uu, bulchitoota Edoomii ti. Latti maatiin tun tokko tokkoonuu leete, maqaa maatii saniitiin beekkama. Esaawuun kun abbaa Edoomotaa ti. ");
INSERT INTO gax_vpl VALUES ("GN37_1","002_37_1","GEN","37","1","1","Yaaqoob lafa abbaan isaa le'eeru, lafa Kana'aanii keessa le'e. ");
INSERT INTO gax_vpl VALUES ("GN37_2","002_37_2","GEN","37","2","2","Dabarsiin maatii Yaaqoobii ta asii gadii tana. Yoseef dargageessa woggaa kudhanii torbaa yennaa te'etti, ijoollee niitota abbaa ifii, ilmaan Bilha'aatii fi Zilfa'aa obboleeyyan ifii woliin hoole'ee fi re'ee tissaa ture; inni oduu waan badduu isaan hujanee fidee abbaa isaaniititti hime. ");
INSERT INTO gax_vpl VALUES ("GN37_3","002_37_3","GEN","37","3","3","Yaaqoob ilma dullummaa keessa dhaggate waan te'eef, ilmaan ifii mara caalaa Yoseef jaalate; inni qoloo seesa qaddu ta harka dheertu'uu hojjachiiseef. ");
INSERT INTO gax_vpl VALUES ("GN37_4","002_37_4","GEN","37","4","4","Obboleeyyan isaa akka abbaan isaanii isaan mara caalaa isa jaalate yennaa dhaggane, isa jibbanee, dubbii nageyaa isatti dubbatuu hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("GN37_5","002_37_5","GEN","37","5","5","Gaafa tokko Yoseef oojjuu oojjatee, yennaa inni obboleeyyan ifiititti hime, ittuu caalchisanee isa jibbane. ");
INSERT INTO gax_vpl VALUES ("GN37_6","002_37_6","GEN","37","6","6","Inni, «Ani oojjuu oojjadhe isinitti hima. ");
INSERT INTO gax_vpl VALUES ("GN37_7","002_37_7","GEN","37","7","7","Nuuti fichaa wodhakka'atti laddee qamadi'ii hidhiisatti jiraayyu; laddeen tiyya ol kaatee dhaabbatte; laddeen teessanille isii marsitee sagaddeef» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN37_8","002_37_8","GEN","37","8","8","Obboleeyyan isaa deebisanee, «Ati dhugumaan nu irratti mootii hin te'a jettee yaaddaa? Ati dhugumaan nu irratti baallii hin qabaadha jettee yaaddaa?» jedhaneen; obboleeyyan isaa sababa oojjuu isaatii fi waan inni jedheetiif ittuma caalchisanee isa jibbane. ");
INSERT INTO gax_vpl VALUES ("GN37_9","002_37_9","GEN","37","9","9","Ammalle oojjuu dhibii oojjatee, obboleeyyan ifiititti himee, «Kunoo, ani oojjuu dhibii oojjadhee, aduun, ji'aa fi urjiin kudhanii tokko naaf sagadanuun dhagge» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN37_10","002_37_10","GEN","37","10","10","Yennaa inni abbaa ifiitii fi obboleeyyan ifiititti hime, abbaan isaa «Oojjuun tun oojjuu attamii ti? Ati dhugumaan anii fi haati teeti, obboleeyyan teetille si'iif hin saganna jettee yaaddaa?» jedhee isa xixe. ");
INSERT INTO gax_vpl VALUES ("GN37_11","002_37_11","GEN","37","11","11","Obboleeyyan isaa isa hinaafane; abbaan isaa ammoo waan kana qalbi'itti qabate. ");
INSERT INTO gax_vpl VALUES ("GN37_12","002_37_12","GEN","37","12","12","Gaafa tokko obboleeyyan Yoseefii horii abbaa ifii tissiisaaf gara Sheekemii dhaqane. ");
INSERT INTO gax_vpl VALUES ("GN37_13","002_37_13","GEN","37","13","13","Yaaqoob, Yoseefiin, «Obboleeyyan teeti Sheekemitti akka horii tissiisatti jiranu hin beetta. Gara isaanii si ergaa koy» jedhe. Yoseefille, «Tole» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN37_14","002_37_14","GEN","37","14","14","Abbaan isaa, «Dhaqii, obboleeyyan teetii fi horiin nageyaan akka jiranu ilaaliitii, deebi'ii natti himi» jedheen; akka kanaan abbaan Yoseefii dhooqa Kebroonii irraa isa erge. Yoseef yennaa Sheekem geye, ");
INSERT INTO gax_vpl VALUES ("GN37_15","002_37_15","GEN","37","15","15","isaa diida keessa daddaaqu, namichi tokko dhaggee, «Ati maan barbaadda?» jedhee gaafate. ");
INSERT INTO gax_vpl VALUES ("GN37_16","002_37_16","GEN","37","16","16","Yoseef deebisee, «Obboleeyyan tiyya barbaadiisatti jira; maganne'ee addee isaan horii tissiisatti jiranu natti himi» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN37_17","002_37_17","GEN","37","17","17","Namichi, «Isaan, ‹Dootaan dhandha› woliin jedhanuun waan dhage'eef, asii deemaneeran» jedheen. Tanaaf Yoseef obboleeyyan ifii faana dhaqee Dootaanitti isaan dhagge. ");
INSERT INTO gax_vpl VALUES ("GN37_18","002_37_18","GEN","37","18","18","Obboleeyyan Yoseefii adoo inni isaanitti hin dhikaatin, fago'otti isa dhagganee, isa ijjeesiisaaf mala dhowane. ");
INSERT INTO gax_vpl VALUES ("GN37_19","002_37_19","GEN","37","19","19","Isaan wol woliin, «Kunoo, abbaan oojju'uu sun dhufe. ");
INSERT INTO gax_vpl VALUES ("GN37_20","002_37_20","GEN","37","20","20","Kowa'a, isa ijjeennee, reeffa isaa boolla tana keessaa takkatti'itti qolaansinee, bineensatti nyaate jenna. Achiin duuba oojjuun isaa maan akka teetu hin ilaalla» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN37_21","002_37_21","GEN","37","21","21","Ruuben ammoo tana yennaa dhage'e, «Hin ijjeennu» jedhee harka isaanii keessaa isa baase. ");
INSERT INTO gax_vpl VALUES ("GN37_22","002_37_22","GEN","37","22","22","Ruuben, isaaniin, «Dhiiga hin dhangalaasina'a; boolla goomole'ee tana keessa buusa'a malee, isa hin miidhina'a» jedhe. Inni harka isaanii keessaa isa baasiisee, abbaa isaatiif isa deebisiisaaf tana jedhe. ");
INSERT INTO gax_vpl VALUES ("GN37_23","002_37_23","GEN","37","23","23","Yoseef obboleeyyan ifii bira yennaa geye, isaan qoloo isaa ta seesa qaddu ta harka dheertu'uu san irraa baasanee, ");
INSERT INTO gax_vpl VALUES ("GN37_24","002_37_24","GEN","37","24","24","boolla duwwaa bisaan keessa hin jirre, keessa buusane. ");
INSERT INTO gax_vpl VALUES ("GN37_25","002_37_25","GEN","37","25","25","Achiin duuba isaan sagalee nyaatiisaaf tetee'ane; isaan yennaa ol ilaalane daldaltooti Ishimaa'elootaa, Giil'aadi irraa gara biyya Gibxi'ii gad bu'aaranuun dhaggane. Gaaloti isaanii uddowaa, fiqire'ee fi qumbii ba'ataneeran. ");
INSERT INTO gax_vpl VALUES ("GN37_26","002_37_26","GEN","37","26","26","Achiin duuba Yihudaan obboleeyyan ifiitiin, «Yoo obboleessa keenna ijjeennee, du'a isaa dhossine, bu'aa maan dhagganna? ");
INSERT INTO gax_vpl VALUES ("GN37_27","002_37_27","GEN","37","27","27","Kowa'a, worra Ishimaa'elootaa kanatti isa gurgurra. Inni obboleessa keenna, foonuma keenna waan te'eef, harka keennaan isa hin ijjeennu» jedhe; obboleeyyan isaalle yaada kanatti wolii galane. ");
INSERT INTO gax_vpl VALUES ("GN37_28","002_37_28","GEN","37","28","28","Worri Ishimaa'elootaa daldaltooti Miidiyaanii karaa saniin dabaraa turane; obboleeyyan Yoseefii boolla keessaa ol harkittee isa baattee, meetii diddamatti worra Ishimaa'elootaatitti gurguratte. Isaanille gara biyya Gibxi'ii isa geessane. ");
INSERT INTO gax_vpl VALUES ("GN37_29","002_37_29","GEN","37","29","29","Ruuben yennaa gara boollaa deebi'ee dhufe, Yoseef akka achi hin jirre dhaggee, gaddee woyaa ifii tarsaase. ");
INSERT INTO gax_vpl VALUES ("GN37_30","002_37_30","GEN","37","30","30","Inni gara obboleeyyan ifii deebi'ee, «Mucaan achi hin jiru! Ani eessa goru naa woyya ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN37_31","002_37_31","GEN","37","31","31","Achiin duuba isaan re'ee qalanee, qoloo Yoseefii dhiiga keessa cuuphane. ");
INSERT INTO gax_vpl VALUES ("GN37_32","002_37_32","GEN","37","32","32","Isaan qoloo seesa qaddu ta harka dheertu'uu san fuudhanee gara abbaa ifii geessanee, «Nuuti qoloo tana dhaggineerra; me ilaali, woyaa ilma keetii moo ta isaatii moti?» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("GN37_33","002_37_33","GEN","37","33","33","Innille qoloo beekee, «Qoloo ilma kiyyaa ti! Bineensatti isa nyaateera. Dhugumaan Yoseef kukkutameera» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN37_34","002_37_34","GEN","37","34","34","Achiin duuba Yaaqoob gaddaan woyaa ifii tarsaasee, woyaa gaddaa uffatee, guyyaa hedduu ilma ifiitiif gadde. ");
INSERT INTO gax_vpl VALUES ("GN37_35","002_37_35","GEN","37","35","35","Ilmaan isaatii fi durri isaa duudiin isa jajjabeessiisaaf dhufane; inni ammoo jajjabaatiisa didee, «Ani haga du'utti, ilma kiyyaaf hin gadda» jedhe. Tanaaf ilma ifii Yoseefiif bowe. ");
INSERT INTO gax_vpl VALUES ("GN37_36","002_37_36","GEN","37","36","36","Yennaa san worri Miidiyaanii, biyya Gibxi'ii keessatti, ajajaa eeddota mana mootumma'aa ka te'e, qondaalticha mootii Gibxi'ii Phoxiifaaritti Yoseef gurgure. ");
INSERT INTO gax_vpl VALUES ("GN38_1","002_38_1","GEN","38","1","1","Yennaa san Yihudaan obboleeyyan ifii lakkisee, namicha qachaa Adulaamii, ka maqaan isaa, «Hiiraa» jedhamu tokko bira qubate. ");
INSERT INTO gax_vpl VALUES ("GN38_2","002_38_2","GEN","38","2","2","Achitti Yihudaan intala nama biyya Kana'aanii, ka maqaan isaa, «Shuwaa» jedhamuu tokkoo dhagge; inni isii fuudhee isii woliin rafe. ");
INSERT INTO gax_vpl VALUES ("GN38_3","002_38_3","GEN","38","3","3","Isiille ulfoottee ilma deette; innille maqaa isaa «Eer» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("GN38_4","002_38_4","GEN","38","4","4","Ammalle ulfoottee ilma deette; maqaa isaa, «Onaan» jette. ");
INSERT INTO gax_vpl VALUES ("GN38_5","002_38_5","GEN","38","5","5","Ammalle dabaltee ilma dhibii deette; maqaa isaa, «Shelaa» jette. Isiin biyya Kiziibiititti mucaa kana deette. ");
INSERT INTO gax_vpl VALUES ("GN38_6","002_38_6","GEN","38","6","6","Yihudaan ilma ifii angaficha Eer, intala, «Taamaar» jedhantu fuusise. ");
INSERT INTO gax_vpl VALUES ("GN38_7","002_38_7","GEN","38","7","7","Ilmi Yihuda'aa angafichi, Eer ammoo, Waaqa duratti nama hamaa waan te'eef, Waaqi isa ijjeese. ");
INSERT INTO gax_vpl VALUES ("GN38_8","002_38_8","GEN","38","8","8","Achiin duuba Yihudaan, Onaanii obboleessa Eeriitiin, «Gara niitii obboleessa keeti ka du'ee dhaqii, isii dhaaliitii, obboleessa keetiif sanyii dabarsi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN38_9","002_38_9","GEN","38","9","9","Onaan sanyiin ta isaa akka hin teene waan beekeef, niitii obboleessa ifii woliin yennaa rafu mara, bisaan ifii ka sanyii te'u san lafatti jissee, obboleessa ifii sanyii malee hambure. ");
INSERT INTO gax_vpl VALUES ("GN38_10","002_38_10","GEN","38","10","10","Wonni Onaan godhe kun Mootii Waan Maraa waan gaddisiitteef, Mootii Waan Maraa isalle ijjeese. ");
INSERT INTO gax_vpl VALUES ("GN38_11","002_38_11","GEN","38","11","11","Achiin duuba Yihudaan, «Ilmi kiyya akkuma obboleessa ifii du'a» jedhee waan sodaateef, Taamaarii niitii ilma ifiitiin, «Haga ilmi kiyya Shelaan guddatutti haadha hiyyeessaa te'ii mana abbaa keetii tee'i» jedheen; Taamaarille dhaxxee mana abbaa ifii teette. ");
INSERT INTO gax_vpl VALUES ("GN38_12","002_38_12","GEN","38","12","12","Bara heddu'uun duuba, niitiin Yihuda'aa intalti Shuwa'aa duute; Yihudaan gadda ifii fixateen duuba, ka'ee jaala ifii ka, «Hiiraa» jedhamu, nama qachaa Adulaamii san woliin gara Tiimnaa lafa hoolota isaa irraa rifeensa muranu dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN38_13","002_38_13","GEN","38","13","13","Namooti, Taamaariin, «Abbaan sodda'aa keeti hoolota ifii irraa rifeensa mursiisiisaaf, Tiimna'atti ol hin baya» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN38_14","002_38_14","GEN","38","14","14","Shelaan fuudha geyeeraayyu; Taamaar ammoo isatti akka heerumsiifamaa hin jirre dhaggitee, woyaa haadha hiyyeessumma'aa jijjiirattee, fuula ifii shaashi'iin hagooggattee, karaa Tiimnaa dhaqu cinaa, seensuma Enaayimii dura teette. ");
INSERT INTO gax_vpl VALUES ("GN38_15","002_38_15","GEN","38","15","15","Taamaar fuula ifii shaashi'iin waan hagooggatteef, Yihudaan sagaagaltittii seye malee, isii hin beenne. ");
INSERT INTO gax_vpl VALUES ("GN38_16","002_38_16","GEN","38","16","16","Isiin niitii ilma isaa akka teete waan hin beekiniif inni gara isi'ii dhaqee, «Si woliin rafuu?» jedheen. Isiin, «Yoo ani si woliin rafe maan naa kennita?» jettee gaafatte. ");
INSERT INTO gax_vpl VALUES ("GN38_17","002_38_17","GEN","38","17","17","Inni deebisee, «Re'oota tiyya keessaa korbeessa buruusoo sii erga» jedheen. Isiin deebittee, «Haga ati korbeessa buruusoo naa ergitu waan qabadhu tokko naa kenni» jetteen. ");
INSERT INTO gax_vpl VALUES ("GN38_18","002_38_18","GEN","38","18","18","Yihudaan, «Waan qabattu maan sii kenna?» jedhe. Isiin, «Qubee maqaan keeti irra jiru, waan ittiin mormatti hidhatanu woliin, ulee qabatteertu tanalle natti kenni» jette. Innille kenneefii, isii woliin rafe; isiille isaaf ulfootte. ");
INSERT INTO gax_vpl VALUES ("GN38_19","002_38_19","GEN","38","19","19","Achiin duuba Taamaar gara manaa dhaxxee, shaashii hagooggatte ifi irraa fuutee, woyaa haadha hiyyeessumma'aa san deebittee uffatte. ");
INSERT INTO gax_vpl VALUES ("GN38_20","002_38_20","GEN","38","20","20","Yennaa diqqo'oon duuba, Yihudaan qube'ee fi waan ittiin mormatti hidhatanu, ulee dubartitti'itti kenneerulle deebifatiisaaf, buruusoo korbeessa re'e'ee tokko, jaala ifii nama qachaa Adulaamiitiin erge; inni ammoo isii dhaggiisaaf hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("GN38_21","002_38_21","GEN","38","21","21","Inni namoota qachaa Enaamiitiin, «Sagaagaltittiin seensuma qachaa Enaamii cinaa jirtu takka eessa gorte?» jedhe. Isaan deebisanee, «Lakkii, sagaagaltittiin as hin jirtu» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN38_22","002_38_22","GEN","38","22","22","Maarre inni gara Yihuda'aa deebi'ee, «Ani dubartittii dhagguu hin dandeenne; namooti achi le'anulle, ‹Sagaagaltittiin as hin jirtu› anaan jedhane» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN38_23","002_38_23","GEN","38","23","23","Yihudaan deebisee, «Ani korbeessa buruusoo san isi'iif ergeeraayyu; ati ammoo isii dhagguu hin dandeenne; namooti akka nutti hin kolline, waan qabatte san fudhattuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN38_24","002_38_24","GEN","38","24","24","Gara ji'a sadiitiin duuba, «Niitiin ilma keetii Taamaar sagaagaltee ulfootteerti» jedhee nami tokko Yihuda'atti hime. Yihudaan, «Gad isii baasa'a, guba'aa ijjeesa'a» jedhee ajaje. ");
INSERT INTO gax_vpl VALUES ("GN38_25","002_38_25","GEN","38","25","25","Isiin yennaa qabantee gad baate, «Ani abbaa qube'ee fi ulee tanaatiif ulfoye. Qubee maqaan irra jiruu fi waan ittiin hidhatanu woliin, ulee tanalle ilaaliitii, ka eennuu akka te'ane natti himi?» jettee abbaa soddaa ifii Yihuda'atti ergite. ");
INSERT INTO gax_vpl VALUES ("GN38_26","002_38_26","GEN","38","26","26","Yihudaan meya san hubatee ilaalee, «Waan ani ilma kiyya Shelaa isii fuusisuu dhabeef, isiin na caalaa dhugaa qaddi» jedhe. Inni deebi'ee isii woliin hin ranne. ");
INSERT INTO gax_vpl VALUES ("GN38_27","002_38_27","GEN","38","27","27","Yennaan Taamaar deettu yennaa geette, lakkuu akka gadha'aa qaddu beekkame. ");
INSERT INTO gax_vpl VALUES ("GN38_28","002_38_28","GEN","38","28","28","Adoo isiin deyiisatti jirtuu, finni tokko harka gad baafate. Dubartittiin deessittu qaddee, liilana diimaa harka isaatitti hiitee, «Isatti dursee dhalate» jette. ");
INSERT INTO gax_vpl VALUES ("GN38_29","002_38_29","GEN","38","29","29","Yennaa inni harka ifii keessatti deebifate ammoo, obboleessi isaa dursee dhalate. Dubartittiin deessitelle, «Ati attam attam cassitee baate!» jettee, maqaa isaa «Faares» jette. ");
INSERT INTO gax_vpl VALUES ("GN38_30","002_38_30","GEN","38","30","30","Achiin duuba, finni liilana diimaa harka irraa qabu dhalate; maqaa isaalle, «Zaaraa» jedhanee baasane. ");
INSERT INTO gax_vpl VALUES ("GN39_1","002_39_1","GEN","39","1","1","Yoseef gara biyya Gibxi'ii gad geessane; qondaaltota mootii Gibxi'ii keessaa tokkochi, phoxiifaariin nami biyya Gibxi'ii ajajaan eeddota mana mootumma'aa, worra Ishimaa'elootaa ka gara biyya Gibxi'ii isa fide irraa Yoseef bitate. ");
INSERT INTO gax_vpl VALUES ("GN39_2","002_39_2","GEN","39","2","2","Mootiin Waan Maraa waan Yoseef woliin jiraateef, wonni inni huju teeteef; inni mana goottaa ifii, Phoxiifaarii nama biyya Gibxi'ii keessa le'aa ture. ");
INSERT INTO gax_vpl VALUES ("GN39_3","002_39_3","GEN","39","3","3","Phoxiifaar akka Mootiin Waan Maraa Yoseef woliin jiruu fi hujiin isaa marti akka isaaf teetu akka godhe dhaggee, ");
INSERT INTO gax_vpl VALUES ("GN39_4","002_39_4","GEN","39","4","4","Yoseefitti gammadee, tajaajilaa ifii godhate; inni ajajaa mana ifii isa godhee, qabeenna ifii mara irralle'etti itti gaafatamaa godhe. ");
INSERT INTO gax_vpl VALUES ("GN39_5","002_39_5","GEN","39","5","5","Yennaa saniin jalqabee, Mootiin Waan Maraa sababa Yoseefiitiif jedhee, qabeenna manaatii fi fichaa namicha biyya Gibxi'ii san mara eebbise. ");
INSERT INTO gax_vpl VALUES ("GN39_6","002_39_6","GEN","39","6","6","Tanaaf Phoxiifaar waan qabu mara harka Yoseefiititti lakkise; Phoxiifaar waan nyaatu malee, waan tokkolle'eef hin yaaddawuuyyu. Yoseef akkaa fi dhaaballe'een nama miidhaga'a. ");
INSERT INTO gax_vpl VALUES ("GN39_7","002_39_7","GEN","39","7","7","Yennaa diqqo'oon duuba niitiin goottaa isaa Yoseef ilaaltee jaalattee, «Ana woliin rafi» jetteen. ");
INSERT INTO gax_vpl VALUES ("GN39_8","002_39_8","GEN","39","8","8","Inni ammoo didee, niitii goottaa ifii saniin, «Goottaan kiyya waan mana keessaa maraaf tokkolle hin yaaddawu; waan qabu mara irratti itti gaafatamaa na godheera. ");
INSERT INTO gax_vpl VALUES ("GN39_9","002_39_9","GEN","39","9","9","Mana kana keessatti goottaan kiyya na caalaa baallii hin qabu; ati waan niitii isaa teeteef si malee, wonni inni natti hin kennin hamburate tokkolle hin jiru. Ani attam waan hantuu akkanaa hujee, Waaqa yakka ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN39_10","002_39_10","GEN","39","10","10","Dubartittiin guyyuma guyya'aan Yoseefitti dubbattulle, inni ammoo isii woliin rafiisa yookiin isii biratti dhaggamiisa didate. ");
INSERT INTO gax_vpl VALUES ("GN39_11","002_39_11","GEN","39","11","11","Gaafa tokko Yoseef hujii ifii hujatiisaaf, gara manaa yennaa seene, tajaajiltoota manaa keessaa tokkolle achi hin jiranuuyyu. ");
INSERT INTO gax_vpl VALUES ("GN39_12","002_39_12","GEN","39","12","12","Niitiin goottaa isaa woyaa isaa qabattee, «Koy, na woliin rafi» jetteen. Yoseef ammoo woyaa ifii isii harkatti lakkisee, baqatee manaa baye. ");
INSERT INTO gax_vpl VALUES ("GN39_13","002_39_13","GEN","39","13","13","Isiin akka inni woyaa ifii isii harkatti lakkisee, alatti baqatee baye yennaa dhaggite, ");
INSERT INTO gax_vpl VALUES ("GN39_14","002_39_14","GEN","39","14","14","tajaajiltoota mana isi'ii keessa hujanu waantee, «Kunoo, namicha Ibraawicha nu fokkisiisaaf abbaan manaa kiyya as fide kana ilaala'a. Inni hunnaan na woliin rafiisaaf gara kolloo tiyyaa seene; ani ammoo qoonqoo ol qabadhee itti iyye. ");
INSERT INTO gax_vpl VALUES ("GN39_15","002_39_15","GEN","39","15","15","Inni akka ani qoonqoo ol qabadhee iyye dhage'ee, woyaa ifii na biratti lakkisee, baqatee manaa baye» jette. ");
INSERT INTO gax_vpl VALUES ("GN39_16","002_39_16","GEN","39","16","16","Isiin haga goottaan isaa galutti woyaa isaa ifi bira keyattee eedde. ");
INSERT INTO gax_vpl VALUES ("GN39_17","002_39_17","GEN","39","17","17","Achiin duuba isiin, «Garbichi Ibraawichi ati as fidde sun na fokkisiisaaf gara kolloo tiyyaa seene. ");
INSERT INTO gax_vpl VALUES ("GN39_18","002_39_18","GEN","39","18","18","Akkuma ani qoonqoo ol qabadhee iyyeen, woyaa ifii na biratti lakkisee, alatti baqate» jette. ");
INSERT INTO gax_vpl VALUES ("GN39_19","002_39_19","GEN","39","19","19","Niitiin isaa, «Garbichi keeti akkana na godhe» jettee waan isatti hinte yennaa dhage'e, goottaan Yoseefii guddoo aare. ");
INSERT INTO gax_vpl VALUES ("GN39_20","002_39_20","GEN","39","20","20","Tanaaf Yoseef fuudhee, mana hidha'aa ka worri mootichi hiisiseeru keessa jirutti isa galche. Yoseefille hidhaa keessa achi ture. ");
INSERT INTO gax_vpl VALUES ("GN39_21","002_39_21","GEN","39","21","21","Mootiin Waan Maraa ammoo Yoseef woliin jiraatee, jaalala ifii ka bara baraa isatti mudhisee, ajajaa mana hidha'aa duratti akka Yoseef fudhatama dhaggatu godhe. ");
INSERT INTO gax_vpl VALUES ("GN39_22","002_39_22","GEN","39","22","22","Ajajaan mana hidha'aa sun, namoota mana hidha'aa keessa jiranu maraa fi waan mana hidha'aa san keessatti hujamu mara irratti Yoseef itti gaafatamaa godhe. ");
INSERT INTO gax_vpl VALUES ("GN39_23","002_39_23","GEN","39","23","23","Mootiin Waan Maraa Yoseef woliin jiraatee, wonni inni huju marti akka isaaf teetu waan godheef, ajajaan mana hidha'aa waan Yoseef itti gaafatamaa itti te'e isatti lakkisee, itti hin yaaddonne. ");
INSERT INTO gax_vpl VALUES ("GN40_1","002_40_1","GEN","40","1","1","Wonni kun teetee yennaa diqqo'oon duuba, itti gaafatamaan daadhii woyni'ii mootichaatii fi itti gaafatamaan mana sagalee mootichaa yakkaa mooticha gaddisiichu hujane. ");
INSERT INTO gax_vpl VALUES ("GN40_2","002_40_2","GEN","40","2","2","Mootichi qondaaltota ifii lamaan itti gaafatamaa daadhii woyni'iitii fi itti gaafatamaa mana sagale'eetitti aaree, ");
INSERT INTO gax_vpl VALUES ("GN40_3","002_40_3","GEN","40","3","3","adduma Yoseef itti hidhameeru, mana ajajaa eeddotaa keessatti akka hidhamanu godhe. ");
INSERT INTO gax_vpl VALUES ("GN40_4","002_40_4","GEN","40","4","4","Ajajaan mana hidha'aa Yoseefitti isaan kennee, innille isaan tajaajile. Isaan mana hidha'aa keessa yennaa diqqoo turane. ");
INSERT INTO gax_vpl VALUES ("GN40_5","002_40_5","GEN","40","5","5","Halkan tokko qondaaltoti mootichaa lamaanuu, itti gaafatamaan daadhii woynii mootichaatii fi itti gaafatamaan mana sagalee mootichaa oojjuu oojjatane. Oojjuun tokko tokkoon isaaniituu oojjatane tun, hiikaa adda addaa qaddiiyyu. ");
INSERT INTO gax_vpl VALUES ("GN40_6","002_40_6","GEN","40","6","6","Boruyyaa ganama yennaa Yoseef gara isaanii dhufe, isaan fuula badaneeranuun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN40_7","002_40_7","GEN","40","7","7","Inni, «Isin adha maaf fuula baddaneertan?» jedhee isaan gaafate. ");
INSERT INTO gax_vpl VALUES ("GN40_8","002_40_8","GEN","40","8","8","Isaan deebisanee, «Halkan edaa nuuti lamaanuu oojjuu oojjannee, ammoo nami hiiku tokkolle dhabame» jedhane. Yoseef isaaniin, «Oojjuu hiikiisaaf ka dandeessisu Waaqa; oojjuu teessan natti hima'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN40_9","002_40_9","GEN","40","9","9","Itti gaafatamaan daadhii woynii mootichaa oojjuu ifii Yoseefitti himee, «Ani oojju'uun muka woyni'ii tokko fuula kiyya duratti dhagge; ");
INSERT INTO gax_vpl VALUES ("GN40_10","002_40_10","GEN","40","10","10","muki woyni'ii sun dameelee sad qabaayyu. Akkuma baala baaseen daraaree, unkuruurrille bilchaate. ");
INSERT INTO gax_vpl VALUES ("GN40_11","002_40_11","GEN","40","11","11","Ani muduunuu mootichaa qabadheeraayyu; maarre ani unkuruura fuudhee, muduunuu keessatti cunfee, mootichatti kenne» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN40_12","002_40_12","GEN","40","12","12","Yoseef namichaan, «Hiikkaan Oojjuu teetii tana: dameeleen sadiin sun guyyoota sad. ");
INSERT INTO gax_vpl VALUES ("GN40_13","002_40_13","GEN","40","13","13","Guyyaa sad keessatti mootichi Gibxi'ii hidhaa keessaa si hiika; yakkaa teeti sii lakkisee, addee hujii teeti duriititti si deebisa; akkuma dur itti gaafatamaa daadhii woyni'ii isaa yennaa teeteertu gootu, muduunuu harka mootichaatitti hin kennita. ");
INSERT INTO gax_vpl VALUES ("GN40_14","002_40_14","GEN","40","14","14","Yennaa si'iif tolu sanitti ammoo na yaadadhu! Maganne'ee, marroo waan kiyyaa mooticha Gibxi'iititti himiitii, mana hidha'aa kana keessaa na baasiisaan waan dansaa naa godhi! ");
INSERT INTO gax_vpl VALUES ("GN40_15","002_40_15","GEN","40","15","15","Ani biyya Ibrootaa keessaa hunnaan hatamee dhufe; biyya kanalle'etti waan mana hidha'aa keessa na galchu, waan tokkolle hujee hin jiru» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN40_16","002_40_16","GEN","40","16","16","Itti gaafatamaan mana sagale'eelle hiikkaan oojju'uu dansaa akka teete dhaggee, oojjuu ifiille Yoseefitti himatee, «Anille oojju'uun daabboon kollonjoon sadiin mataa irra na jirtuun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN40_17","002_40_17","GEN","40","17","17","Kollonjoo ol aantu keessa sagaleen adda addaa ta mootichaaf qophoottetti jiraayyu; sinbirrooti ammoo kollonjoo san keessaa sagalee san nyaatiisatti jirtiiyyu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN40_18","002_40_18","GEN","40","18","18","Yoseef deebisee, «Hiikkaan oojjuu teetii tana: saaxaraan sadiin sun guyyoota sad. ");
INSERT INTO gax_vpl VALUES ("GN40_19","002_40_19","GEN","40","19","19","Guyyaa sad keessatti mootichi Gibxi'ii hidhaa keessaa si hiikee, morma keeti si irraa mursiiseen duuba reeffa keeti mukatti hin fannisiisa; sinbirrootille foon keeti hin nyaatan» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN40_20","002_40_20","GEN","40","20","20","Guyyaa sadiin duuba, mootichi biyya Gibxi'ii jila dhaloota ifii irratti, qondaaltota ifiitiif nyaata qopheesse; inni fuula qondaaltota ifii duratti itti gaafatamaa daadhii woyni'ii ifiitii fi itti gaafatamaa mana sagalee ifii hiike. ");
INSERT INTO gax_vpl VALUES ("GN40_21","002_40_21","GEN","40","21","21","Mootichi itti gaafatamaa daadhii woyni'ii ifii addee isaa ta duriititti deebise; innille akkuma durii muduunuu harka mootichaatitti kenne. ");
INSERT INTO gax_vpl VALUES ("GN40_22","002_40_22","GEN","40","22","22","Itti gaafatamaa mana sagale'ee ammoo muka irratti fannisiise. Wonni marti akkuma Yoseef isaaniif hiike teete. ");
INSERT INTO gax_vpl VALUES ("GN40_23","002_40_23","GEN","40","23","23","Itti gaafatamaan daadhii woyni'ii ammoo Yoseef hin qaabanne; inni marroo waan isaa mara dedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_1","002_41_1","GEN","41","1","1","Woggaa lamaan duuba, mootichi biyya Gibxi'ii oojjuu oojjate; inni oojju'uun laga Nayilii bira dhaabbatee, ");
INSERT INTO gax_vpl VALUES ("GN41_2","002_41_2","GEN","41","2","2","loon dadansaan gagabboon torba bisaan keessaa bayanee, achi dhadhaabbatanee, marra dheedanuun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN41_3","002_41_3","GEN","41","3","3","Achiin duuba, ammalle loon huhuqqoon googiraan torba bisaan keessaa bayanee, loon dadansaa gagabboo kaan bira dhaabbatane. ");
INSERT INTO gax_vpl VALUES ("GN41_4","002_41_4","GEN","41","4","4","Loon huhuqqoon googiraan sun loon dadansaa gagabboo kaan nyaatane. Achiin duuba mootichi dammaqe. ");
INSERT INTO gax_vpl VALUES ("GN41_5","002_41_5","GEN","41","5","5","Mootichi Gibxi'ii ammalle deebi'ee rafee, lammeessoo oojjuu oojjate. Unkuruurri midhaanii torba midhaan unkuruurfatee, dansoomee agadaa tokko irratti lateeruun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN41_6","002_41_6","GEN","41","6","6","Saniin duuba, unkuruura midhaanii ka qoore ka qilleensi gara aduun baatuu gube torba lateeruun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN41_7","002_41_7","GEN","41","7","7","Unkuruurri qomore sun unkuruura midhaanii dadansaa san nyaate. Achiin duuba mootichi dammaqee, akka oojjuu teete beeke. ");
INSERT INTO gax_vpl VALUES ("GN41_8","002_41_8","GEN","41","8","8","Boruyyaa ganama yaad mootichaa waan raafameef, worra xano'ootii fi worra beekkolee biyya Gibxi'ii maratti ergee waansisee, oojjuu ifii isaanitti hime; nami tokkolle ammoo oojjuu isaa hiikuu hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("GN41_9","002_41_9","GEN","41","9","9","Achiin duuba itti gaafatamaan daadhii woyni'ii mootichaan, «Ani yakkaa tiyya adha qaabadhe. ");
INSERT INTO gax_vpl VALUES ("GN41_10","002_41_10","GEN","41","10","10","Yennaa takka ati itti gaafatamaa mana sagale'eetii fi natti mufattee, mana ajajaa eeddotaa keessatti nu hiisitteertaayyu. ");
INSERT INTO gax_vpl VALUES ("GN41_11","002_41_11","GEN","41","11","11","Adoo achi keessa jirruu nuuti lamaanuu halkanuma tokkocha oojjuu oojjanne; oojjuun sun tokko tokkoonuu hiikkaa adda addaa qaddiiyyu. ");
INSERT INTO gax_vpl VALUES ("GN41_12","002_41_12","GEN","41","12","12","Dargaggeessi worra Ibrootaa tokko, tajaajilaan ajajaa eeddotaa, hidhaa keessa nu woliin ture. Yennaa nuuti oojjuu teenna isatti hinne; innille hiikkaa oojjuu teennaa nu'uuf hime. ");
INSERT INTO gax_vpl VALUES ("GN41_13","002_41_13","GEN","41","13","13","Wonni marti akkuma inni jedhe teetee; ani addee tiyyatti deebi'ee, itti gaafatamaan mana sagale'ee ammoo fannifame» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_14","002_41_14","GEN","41","14","14","Tanaaf mootichi Yoseefitti ergee, yoosuma mana hidha'aa keessaa fidane. Innille mataa haadatee, woyaalle jijjiiratee, mooticha dura dhikaate. ");
INSERT INTO gax_vpl VALUES ("GN41_15","002_41_15","GEN","41","15","15","Mootichi isaan, «Ani oojjuu oojjadheeru qaba. Nami tokkolle ammoo hiikkaa isi'ii naaf himuu hin dandeenne. Ati yennaa oojjuu si'itti himane hiikuu dandeetta jechuu dhage'eera» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_16","002_41_16","GEN","41","16","16","Yoseef deebisee, «Ani oojjuu hiikuu hin dande'u, Waaqi ammoo hiikkaa dansaa oojjuu teetiif hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_17","002_41_17","GEN","41","17","17","Achiin duuba mootichi Yoseefiin, «Ani oojju'uun laga Nayilii bira dhaabbadhee, ");
INSERT INTO gax_vpl VALUES ("GN41_18","002_41_18","GEN","41","18","18","loon dadansaan gagabboon torba laga keessaa bayanee, marra dheedanuun dhagge. ");
INSERT INTO gax_vpl VALUES ("GN41_19","002_41_19","GEN","41","19","19","Achiin duuba, loon huhuqqoon googiraan dhibiin torba bisaan keessaa bayanuun dhagge. Ani loon akkas jibbisiisanu lafa Gibxi'ii keessatti ijjumaa dhaggee hin beeku. ");
INSERT INTO gax_vpl VALUES ("GN41_20","002_41_20","GEN","41","20","20","Loon huhuqqoon jibbisiisanu sun, loon dadansaa gagabboo torba ka qaraa san nyaatane. ");
INSERT INTO gax_vpl VALUES ("GN41_21","002_41_21","GEN","41","21","21","Isaan ammoo loon torba san nyaataneen duuba, akkuma durii huhuqqatanee googiraawanee waan jiranuuf, akka isaan nyaataneeranu nami tokkolle beekuu hin dandeenne. Ani achiin duuba dammaqe. ");
INSERT INTO gax_vpl VALUES ("GN41_22","002_41_22","GEN","41","22","22","Ani ammalle oojjuu dhibii oojjadhee, unkuruura midhaanii ka midhaan unkuruurfate dadansaa torba agadaa tokko irratti lateeru dhagge. ");
INSERT INTO gax_vpl VALUES ("GN41_23","002_41_23","GEN","41","23","23","Achiin duuba, unkuruurri qooraan dhibiin torba ka qilleensa gara aduun baatuutiin gubatane torba latane. ");
INSERT INTO gax_vpl VALUES ("GN41_24","002_41_24","GEN","41","24","24","Achiin duuba unkuruurri qoore sun unkuruura dadansaa torba san liqinsane. Ani oojjuu san worra morutti hime; nami hiikkaa isi'ii naaf hime ammoo tokkolle hin jiru» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_25","002_41_25","GEN","41","25","25","Yoseef mootichaan, «Hiikkaan oojjuu teeti lamaaniituu tokkuma. Waaqi waan gara duraa hujaaru si'itti mudhiseera. ");
INSERT INTO gax_vpl VALUES ("GN41_26","002_41_26","GEN","41","26","26","Loon dadasaan torba woggaa torba; unkuruurri midhaanii dadansaalle woggaa torba. Hiikkaan oojjuu lamaaniituu tokkuma. ");
INSERT INTO gax_vpl VALUES ("GN41_27","002_41_27","GEN","41","27","27","Loon huhuqqoon jibbisiisanu torbaa fi unkuruurri midhaanii qooraan qilleensa gara aduun baatuutiin gubatane ka isaaniin duuba dhufane, woggaa beelaa torba. ");
INSERT INTO gax_vpl VALUES ("GN41_28","002_41_28","GEN","41","28","28","Dubbiin akkuma ani sitti hime, mooticha! Waaqi waan gara duraa hujaaru si'itti mudhiseera. ");
INSERT INTO gax_vpl VALUES ("GN41_29","002_41_29","GEN","41","29","29","Lafa Gibxi'ii mara keessatti woggooti misa gudda'aa torba hin dhufan. ");
INSERT INTO gax_vpl VALUES ("GN41_30","002_41_30","GEN","41","30","30","Woggoota torba saniin duuba ammoo, woggooti beelaa torba hin dhufan; woggooti misa gudda'aa ka lafa Gibxi'ii sun duudiin hin dedhama; beelti biyya hin fixxi. ");
INSERT INTO gax_vpl VALUES ("GN41_31","002_41_31","GEN","41","31","31","Beelti itti aantu hantuu waan teetuuf, woggoota misa gudda'aa san hin dedhan. ");
INSERT INTO gax_vpl VALUES ("GN41_32","002_41_32","GEN","41","32","32","Oojjuun lamaan ati oojjatte tun waan Waaqaan murteeffamee fi waan inni yennaa dhikoo keessatti godhu'uu jiru mudhitti. ");
INSERT INTO gax_vpl VALUES ("GN41_33","002_41_33","GEN","41","33","33","«Maarre mooti'i, nama qarumma'aa fi hubantii qabu filadhuutii, biyya Gibxi'ii irratti muudi. ");
INSERT INTO gax_vpl VALUES ("GN41_34","002_41_34","GEN","41","34","34","Ammalle qondaaltota dhibii worra woggoota misa gudda'aa torba san keessa, midhaan harka shan keessaa tokko fuudhanu filadhuutii muudi. ");
INSERT INTO gax_vpl VALUES ("GN41_35","002_41_35","GEN","41","35","35","Isaan woggoota dansaa dhufaartu keessatti midhaan mara wolitti guuranee, baallii mootichaa jalatti qachaa keessatti wolitti qabanee eeganuu ti. ");
INSERT INTO gax_vpl VALUES ("GN41_36","002_41_36","GEN","41","36","36","Woggoota beelaa torba ta biyya Gibxi'ii irratti dhufaartu keessatti, biyyi beelaan akka hin banne, midhaan kun biyyaaf akka te'u maffamanuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_37","002_41_37","GEN","41","37","37","Yaadi kun mooticha Gibxi'iitii fi qondaaltota isaa mara gammachiise. ");
INSERT INTO gax_vpl VALUES ("GN41_38","002_41_38","GEN","41","38","38","Mootichi, qondaaltota ifiitiin, «Nuuti nama Ayyaanni Waaqaa keessa jiru ka akkanaa kana dhaggatiisa dandeennaa?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_39","002_41_39","GEN","41","39","39","Maarre mootichi, Yoseefiin, «Waaqi waan kana mara si'itti mudhiseera. Qaro'oo fi hubataan akka keetii tokkolle hin jiru. ");
INSERT INTO gax_vpl VALUES ("GN41_40","002_41_40","GEN","41","40","40","Ani biyya tiyya irratti bulchaa si godha. Kolbaan tiyya martille akka ati ajajjutti hin ajajanti. Na qofatti baalli'iin si caala» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_41","002_41_41","GEN","41","41","41","Mootichi Gibxi'ii, Yoseefiin, «Kunoo, ani lafa Gibxi'ii duudii irratti baallii sii kenneera» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_42","002_41_42","GEN","41","42","42","Achiin duuba mootichi qubee ifii ta chaappa'aa ifi irraa baasee, quba Yoseefiititti keye. Inni woyaa quncee talba'aa irraa hujante dansaalle itti uffisee, haachaba worqi'ii morma isaatitti keye. ");
INSERT INTO gax_vpl VALUES ("GN41_43","002_41_43","GEN","41","43","43","Mootichi garreettaa fardaa ka isatti aanu irra isa teessisee, worri garreettaa farda isaa dura deemanu lallabaa, «Gad jedha'a! Gad jedha'a!» jedhane; mootichi akka kanaan lafa Gibxi'ii mara irratti Yoseefiif baallii kenne. ");
INSERT INTO gax_vpl VALUES ("GN41_44","002_41_44","GEN","41","44","44","Mootichi Yoseefiin, «Ani mootii te'ulle, eeyyama keetiin malee nami lafa Gibxi'ii keessa jiru marti harka yookiin miila ifii hin tatachoofatu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_45","002_41_45","GEN","41","45","45","Mootichi, «Zaafenaat-Phane'aa» jedhee maqaa Yoseefiif kenne; intala Phoxii-Feraa hayyicha qachaa Onii, ta «Asenaat» jedhantu, Yoseef heerumsiise. Yoseefille lafa Gibxi'ii duudii keessa deddeeme. ");
INSERT INTO gax_vpl VALUES ("GN41_46","002_41_46","GEN","41","46","46","Yoseef yennaa mooticha biyya Gibxi'ii tajaajiliisa jalqabe nama woggaa soddomaa ti. Inni mana mootumma'aa lakkisee lafa Gibxi'ii mara keessa deddeeme. ");
INSERT INTO gax_vpl VALUES ("GN41_47","002_41_47","GEN","41","47","47","Woggaa misaa torba san keessa latti midhaan bacaa kennite. ");
INSERT INTO gax_vpl VALUES ("GN41_48","002_41_48","GEN","41","48","48","Yoseefille midhaan woggaa misaa torba lafa Gibxi'ii keessatti dhaggame san qachoota keessatti kuuse. Midhaan inni qachuma qacha'atti wolitti qabe sun fichuma adaala qachoota saniitii ka dhaggame. ");
INSERT INTO gax_vpl VALUES ("GN41_49","002_41_49","GEN","41","49","49","Yoseef midhaan akka maansa qarqara abbaaya'aa bacatu kuuse; midhaan guddoo waan bacateef inni safariisaayyuu lakkise. ");
INSERT INTO gax_vpl VALUES ("GN41_50","002_41_50","GEN","41","50","50","Woggooti beelaa sun adoo hin dhufin dura, Yoseef ilmaan lama Asenaatii intala Phoxii-Feraa irraa uumate; Phoxii-Feraan hayyicha qachaa Onii ti. ");
INSERT INTO gax_vpl VALUES ("GN41_51","002_41_51","GEN","41","51","51","Yoseef, «Waaqi rakkinna kiyya maraa fi worra kiyya mara akka dedhu na godhe» jedhee maqaa ilma ifii angafichaa, «Minaasee» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("GN41_52","002_41_52","GEN","41","52","52","Yoseef ilma lammeesso'oo, «Waaqi lafa ani itti rakkadhetti ijoollee na horsiise» jedhee maqaa isaa, «Efreem» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("GN41_53","002_41_53","GEN","41","53","53","Woggooti misaa torba ta biyya Gibxi'ii keessaa muummotte. ");
INSERT INTO gax_vpl VALUES ("GN41_54","002_41_54","GEN","41","54","54","Achiin duuba akkuma Yoseef jedhe, woggooti beelaa torba dhufiisa jalqabane. Biyya dhibii duudii keessa beelti buute; biyya Gibxi'ii ammoo sagaleen jirtiiyyu. ");
INSERT INTO gax_vpl VALUES ("GN41_55","002_41_55","GEN","41","55","55","Biyya Gibxi'ii duudii keessatti beelti jabaannaan, kolbaan sagale'eef mootichatti iyyite. Inni worra Gibxi'iitiin, «Gara Yoseefii dhaqa'aatii, waan inni isiniin jedhu godha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN41_56","002_41_56","GEN","41","56","56","Beelti biyya Gibxi'ii duudii keessatti jabaannaan, Yoseef mana kuusa'aa banee midhaan kolbaa Gibxi'iititti gurgure. ");
INSERT INTO gax_vpl VALUES ("GN41_57","002_41_57","GEN","41","57","57","Beelti biyya lafaa duudii irratti waan jabaatteef, namooti biyya lafaa duudii irraa midhaan Yoseef irraa bitatiisaaf, gara biyya Gibxi'ii dhufane. ");
INSERT INTO gax_vpl VALUES ("GN42_1","002_42_1","GEN","42","1","1","Yaaqoob midhaan biyya Gibxi'ii akka jiru yennaa beeke, ilmaan ifiitiin, «Maaf cadhittanee woli ilaaltan? ");
INSERT INTO gax_vpl VALUES ("GN42_2","002_42_2","GEN","42","2","2","Ani biyya Gibxi'ii midhaan akka jiru dhage'eera; nuuti akka hin duuneef, midhaan achii nuuf bita'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN42_3","002_42_3","GEN","42","3","3","Maarre obboleeyyan Yoseefii kudhan biyya Gibxi'iitii midhaan bitatiisaaf gara biyya Gibxi'ii dhaqane. ");
INSERT INTO gax_vpl VALUES ("GN42_4","002_42_4","GEN","42","4","4","Yaaqoob wonni hantuun isa irra dhaqqaddi jedhee waan sodaateef, Beniyaaminii tiruu Yoseefii, obboleeyyan isaa worra kaan woliin hin ergine. ");
INSERT INTO gax_vpl VALUES ("GN42_5","002_42_5","GEN","42","5","5","Lafa Kana'aaniititti beelti waan buuteef, ilmaan Israa'elii kolbaa dhibii hedduu woliin midhaan bitatiisaaf gara biyya Gibxi'ii dhaqane. ");
INSERT INTO gax_vpl VALUES ("GN42_6","002_42_6","GEN","42","6","6","Yoseef bulchaa biyya Gibxi'ii waan te'eef, inni worra midhaan bitatiisa dhufuuf midhaan gurgursiisaayyu. Maarre obboleeyyan isaa gara isaa yennaa dhufane, isa duratti fuulaan lafatti gad jedhaneef. ");
INSERT INTO gax_vpl VALUES ("GN42_7","002_42_7","GEN","42","7","7","Yoseef yennaa obboleeyyan ifii dhagge, isaan eennu akka te'ane beeke; ammoo akka isaan hin beennee te'ee, aari'iin, «Eessaa dhuttane?» jedhee gaafate. Isaan deebisanee, «Nuuti midhaan bitatiisaaf biyya Kana'aaniitii dhunne» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN42_8","002_42_8","GEN","42","8","8","Yoseef obboleeyyan ifii beekulle, isaan isa hin beenneeyyu. ");
INSERT INTO gax_vpl VALUES ("GN42_9","002_42_9","GEN","42","9","9","Achiin duuba Yoseef oojjuu ifii marroo isaanii oojjate qaabatee, isaaniin, «Isin worra woy dooyu; biyyi teenna eessa gulaan dadhabbii akka qaddu ilaaliisaaf dhuttane» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN42_10","002_42_10","GEN","42","10","10","Obboleeyyan isaa ammoo, «Lakkii, gootta'a. Nuuti tajaajiltooti teeti midhaan bitatiisaaf dhunne. ");
INSERT INTO gax_vpl VALUES ("GN42_11","002_42_11","GEN","42","11","11","Nuuti martinuu ilmaan abbaa tokkoo ti; nuuti worra addatama'a malee, worra dooyuu moti» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN42_12","002_42_12","GEN","42","12","12","Yoseef, isaaniin, «Lakkii! Isin biyyi teenna eessa gulaan dadhabbii akka qaddu ilaaliisaaf dhuttaneertan» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN42_13","002_42_13","GEN","42","13","13","Isaan deebisanee, «Nuuti tajaajiltooti teeti obboleeyyan kudhanii lama, ilmaan abbaa tokkoo, ka lafa Kana'aanii keessa le'uu ti. Obboleessi keenna maandhichi amma abbaa keenna bira jira. Tokkochi du'eera» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN42_14","002_42_14","GEN","42","14","14","Yoseef ammoo isaaniin, «Akkuma ani isiniin jedhe: isin worra dooyu. ");
INSERT INTO gax_vpl VALUES ("GN42_15","002_42_15","GEN","42","15","15","Isin amma tanaan qorqorantan: obboleessi keessan maandhichi haga as dhufutti, ani maqaa mootichaatiin kakadhaa, asii hin baatanu. ");
INSERT INTO gax_vpl VALUES ("GN42_16","002_42_16","GEN","42","16","16","Isin keessaa nami tokko deemee obboleessa keessan fiduu ti. Wonni isin jettane dhugaa te'uu isi'ii haga qorqorantutti isin worri hafe hin hidhantan. Dubbiin teessan soba yoo teete, maqaa mootichaatiin kakadhaa, isin worra dooyu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN42_17","002_42_17","GEN","42","17","17","Achiin duuba Yoseef guyyaa sadiif isaan hiisise. ");
INSERT INTO gax_vpl VALUES ("GN42_18","002_42_18","GEN","42","18","18","Guyyaa sadeesso'ootitti, Yoseef, isaaniin, «Ani nama Waaqa sodaatu waan te'eef, hin leetaniitii waan ani isinitti himu kana godha'a: ");
INSERT INTO gax_vpl VALUES ("GN42_19","002_42_19","GEN","42","19","19","Isin namoota addatamu yoo teetane, obboleeyyan teessan keessaa tokkochi as hidhaa keessatti hafuu ti; worri hafe maatii teessan ta beelowiisatti jirtu saniif midhaan ba'atee deemuu ti. ");
INSERT INTO gax_vpl VALUES ("GN42_20","002_42_20","GEN","42","20","20","Achiin duuba obboleessa keessan maandhicha as naa fida'a. Kanaan akka isin dhugaa dubbatiisatti jirtanu ani hin beeka, isinille hin duutanu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN42_21","002_42_21","GEN","42","21","21","Isaan wol woliin, «Nuuti yakkaa obboleessa keenna irratti hunyeef, amma rakkatiisatti jirra; nuuti rakkoo isaa dhagginee, innille akka nuuti isa fayyinnuuf nu kadhatee, nuuti ammoo isa dhage'uu didanne. Nuuti amma sababa kanaaf rakkoo tana keessa jirra» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN42_22","002_42_22","GEN","42","22","22","Achiin duuba Ruuben, isaaniin, «Ani akka isin mucaa hin miine isinitti himeeraayyu; isin ammoo na dhage'uu diddane. Maarre nuuti amma waan isa irratti hunyeef gatii dhaggatiisatti jirra» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN42_23","002_42_23","GEN","42","23","23","Yoseef waan isaan jedhanu hin beekaayyu; isaan ammoo karaa nama afaan hiikuutiin isa woliin waan dubbatiisatti jiranuuf, akka inni dubbii isaanii beeku hin beenne. ");
INSERT INTO gax_vpl VALUES ("GN42_24","002_42_24","GEN","42","24","24","Yoseef isaan biraa deemee bowe; achiin duuba gara isaanii deebi'ee isaanitti dubbate. Isaan keessaa Shimi'oon fuudhee adoo isaan dhagganuu hiisise. ");
INSERT INTO gax_vpl VALUES ("GN42_25","002_42_25","GEN","42","25","25","Yoseef akka qalqalluu isaanii midhaaniin guutanee, beesee isaan midhaaniif kaffalaneeranu deebisanee, subba tokko tokkoo isaanii keessa keyanee, galaalle galaasanuuf tajaajiltoota ifii ajaje. ");
INSERT INTO gax_vpl VALUES ("GN42_26","002_42_26","GEN","42","26","26","Obboleeyyan Yoseefii midhaan harree ifiititti fe'atanee achii deemane. ");
INSERT INTO gax_vpl VALUES ("GN42_27","002_42_27","GEN","42","27","27","Addee halkan bulanetti, isaan keessaa tokkochi harree ifiitiif midhaan kenniisaaf, qalqalluu ifii yennaa hiikee, afaan qalqalluu ifii keessatti beesee ifii dhagge. ");
INSERT INTO gax_vpl VALUES ("GN42_28","002_42_28","GEN","42","28","28","Inni obboleeyyan ifii waamee, «Beeseen ani midhaaniif kaffale naaf deebiteerti. Kunoo, qalqalluu kiyya keessa jirti!» jedhe. Isaan sodaatanee hollatanee, wol woliin, «Waaqi maan nutti fide?» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN42_29","002_42_29","GEN","42","29","29","Isaan lafa Kana'aanii gara abbaa ifii Yaaqoobii yennaa dhufane, waan isaan irra dhaqqabe mara isatti himane. ");
INSERT INTO gax_vpl VALUES ("GN42_30","002_42_30","GEN","42","30","30","Isaan, «Bulchaan biyya Gibxi'ii, aari'iin nutti dubbatee, ‹Biyya tiyya dooyiisa dhuttane› jedhee, nu himate. ");
INSERT INTO gax_vpl VALUES ("GN42_31","002_42_31","GEN","42","31","31","Nuuti ammoo, ‹Nuuti namoota addatamu malee, worra dooyuu moti. ");
INSERT INTO gax_vpl VALUES ("GN42_32","002_42_32","GEN","42","32","32","Nuuti obboleeyyan kudhanii lama, ilmaan abbaa tokkoo ti. Obboleessi keenna tokkochi du'eera; tokkochi lafa kana'aanii abbaa keenna woliin jira› jenneen. ");
INSERT INTO gax_vpl VALUES ("GN42_33","002_42_33","GEN","42","33","33","Achiin duuba bulchaan biyya Gibxi'ii sun, ‹Namoota addatamu te'uu keessan akka ani ittiin beeku, isin keessaa tokko na woliin turuu ti; worri hafe maatii teessan ta beelowiisatti jirtu saniif midhaan fuudha'aa deema'a. ");
INSERT INTO gax_vpl VALUES ("GN42_34","002_42_34","GEN","42","34","34","Obboleessa keessan maandhicha san as na bira fida'a. Akka kanaan isin namoota addatamu malee, worra dooyu akka isin hin te'in hin beeka; achiin duuba obboleessa keessan ka isin na biratti lakkittane isiniif hin deebisa; isinille as turtanee daldalatuu hin dandeettan› nuun jedhe» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN42_35","002_42_35","GEN","42","35","35","Isaan qalqalluu ifii keessaa yennaa midhaan baasanu, tokko tokkoon isaaniituu qalqalluu ifii keessatti beesee ifii dhaggane. Isaanii fi abbaan isaanii Yaaqoob yennaa beesee dhaggane sodaatane. ");
INSERT INTO gax_vpl VALUES ("GN42_36","002_42_36","GEN","42","36","36","Abbaan isaanii Yaaqoob, isaaniin, «Isin akka ani ijoollee tiyya mara dhabu barbaaddanii? Yoseef hin jiru; Shimi'oonille hin jiru; amma Beniyaaminille fudhatanee deemuu barbaaddan. Tun martinuu anuma irratti teete» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN42_37","002_42_37","GEN","42","37","37","Achiin duuba Ruuben abbaa ifiitiin, «Ani yoo Beniyaamin deebisee gara keeti fiduu dhabe, ilmaan tiyya lamaan ijjeesi; Beniyaamin harka kiyyatti kenni, anille deebisee isa sii fida» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN42_38","002_42_38","GEN","42","38","38","Yaaqoob ammoo, «Ani Beniyaamin akka si woliin deemu hin lakkisu. Obboleessi isaa waan du'eef, isa qofatti hafe. Yennaa isin gara biyya Gibxi'ii deentanu, rakkinni tokko yoo isa irra dhaqqabe, dulluu tiyya keessa gaddaan akka boolla seenu gootan» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN43_1","002_43_1","GEN","43","1","1","Lafa Kana'aanii keessa beelti ittuma jabaataa deente. ");
INSERT INTO gax_vpl VALUES ("GN43_2","002_43_2","GEN","43","2","2","Maatiin Yaaqoobii midhaan isaan biyya Gibxi'iitii fidane san nyaatanee yennaa fixane, abbaan isaanii, «Ammalle gara biyya Gibxi'ii dhaqa'aatii midhaan diqqaa isaa nu'uuf bita'a» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN43_3","002_43_3","GEN","43","3","3","Yihudaan ammoo abba'aan, «Namichi sun, ‹Isin yoo obboleessa keessan fiddanee woliin dhufuu dhabaattane, deebitanee fuula kiyya hin dhaggitanu› jedhee nu ifi eeggachiiseera. ");
INSERT INTO gax_vpl VALUES ("GN43_4","002_43_4","GEN","43","4","4","Ati yoo Beniyaamin nu woliin ergite, dhandhee midhaan si'iif hin binna. ");
INSERT INTO gax_vpl VALUES ("GN43_5","002_43_5","GEN","43","5","5","Yoo isa hin ergin ammoo, bulchaan biyya sanii, ‹Obboleessa keessan fiddanee yoo hin dhufin fuula kiyya dura hin dhikaatina'a› waan nuun jedheeruuf, nuutille achi hin dhandhu» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN43_6","002_43_6","GEN","43","6","6","Israa'elille, «Isin obboleessa dhibii akka qaddanu namichatti hintanee, maaf rakkoo guddoo natti fiddane» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN43_7","002_43_7","GEN","43","7","7","Isaan deebisanee, «Namichi marroo teennaa fi marroo maatii teennaa jabeessee nu gaafatee, ‹Abbaan keessan jiraa? Obboleessa dhibii qaddanii?› jedhe. Nuutille gaaffii isaa deebinne. Akka inni, ‹Obboleessa keessan as fida'a› nuun jedhu attam beekuu dandeenna ree?» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("GN43_8","002_43_8","GEN","43","8","8","Achiin duuba Yihudaan, abbaa ifii Yaaqoobiin, «Nuuti, atii fi ijoolleen teenna beelaan akka hin duune, Beniyaamin na woliin ergi. Nuutille ammuma kaanee ideenna. ");
INSERT INTO gax_vpl VALUES ("GN43_9","002_43_9","GEN","43","9","9","Ani wobii isaa hin te'a; isaaf itti hin gaafatama. Ani yoo deebisee isa si'iif hin fidin, bara le'ii tiyyaa mara na komadhu. ");
INSERT INTO gax_vpl VALUES ("GN43_10","002_43_10","GEN","43","10","10","Nuuti adoo turuu dhannee jiraannee, silaa haga ammaa yennaa lama achi geennee deebineerraayyu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN43_11","002_43_11","GEN","43","11","11","Achiin duuba abbaan isaanii Yaaqoob, isaaniin, «Yoo akkas teete, waan biyya teennatti dhaggamu keessaa waan irra caalaa tolu: fiqiree, damma, uddowaa, qumbii, midhaan muka ‹Almond› jedhamuu, midhaan meexxi'iille qalqalluu keessan keessa keya'aatii kennansa namichaaf kenna'a. ");
INSERT INTO gax_vpl VALUES ("GN43_12","002_43_12","GEN","43","12","12","Beeseen gaafa duraa deebitee afaan qalqalluu keessanii keessatti dhaggantelle, hin dedhanteerti fa'aa, deebisa'aa geessa'aaf! Tanaaf beesee harka lama qabadha'aa dhaqa'a! ");
INSERT INTO gax_vpl VALUES ("GN43_13","002_43_13","GEN","43","13","13","Obboleessa keessanille fudhadha'aatii, ammuma gara namicha sanii deema'a. ");
INSERT INTO gax_vpl VALUES ("GN43_14","002_43_14","GEN","43","14","14","Waaqi waan mara dande'u, namichi sun akka isin mararee, obboleessa keessan ka dhibii kaanii fi Beniyaaminille akka isiniif gad lakkisu godhuu ti. Ani ijoollee tiyya ka dhabu yoo te'e, dhabuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN43_15","002_43_15","GEN","43","15","15","Maarre obboleeyyan sun kennansa sanii fi beesee harka lama san, Beniyaaminille fuudhanee, gara biyya Gibxi'ii ka'ane. Isaan dhaqanee Yoseef dura dhaabbatane. ");
INSERT INTO gax_vpl VALUES ("GN43_16","002_43_16","GEN","43","16","16","Yoseef yennaa Beniyaamin isaan woliin jiruun dhagge, toowataa mana ifiitiin, «Namoota kana gara mana kiyyaa geessi. Isaan sagalee guyya'aa na woliin waan nyaatanuuf, horii tokko qaliitii qopheessi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN43_17","002_43_17","GEN","43","17","17","Toowataan sun akkuma Yoseef itti hime godhee, namoota san gara mana Yoseefii geesse. ");
INSERT INTO gax_vpl VALUES ("GN43_18","002_43_18","GEN","43","18","18","Namooti sun gara mana Yoseefii waan geeffamaneef sodaatanee, «Nuuti waan beesee gaafa duraa deebitee afaan qalqalluu keennaa keessa keyanteef, achi geeffamaarra. Inni nu lolee, harree teenna fudhatee, garboota ifii nu godhata» jedhanee yaadane. ");
INSERT INTO gax_vpl VALUES ("GN43_19","002_43_19","GEN","43","19","19","Tanaaf isaan balbala manaa dura yennaa geyane, toowataa mana Yoseefiitiin, ");
INSERT INTO gax_vpl VALUES ("GN43_20","002_43_20","GEN","43","20","20","«Gootta'a, nuuti tanaan dura yennaa tokko, midhaan bitatiisaaf gara Gibxi'ii dhunneerraayyu. ");
INSERT INTO gax_vpl VALUES ("GN43_21","002_43_21","GEN","43","21","21","Addee bulletti ammoo, qalqalluu keenna hiinnee, tokko tokkoon keennaayyuu beesee midhaaniin bitanne akkuma jirtuun afaan qalqalluu keennaa keessatti dhaggine; amma beesee san deebinnee finneerra. ");
INSERT INTO gax_vpl VALUES ("GN43_22","002_43_22","GEN","43","22","22","Midhaan daballee bitatiisaaf beesee daballee finneerra. Yennaa san nama beesee teenna qalqalluu keenna keessa keye nuuti hin beennu» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN43_23","002_43_23","GEN","43","23","23","Toowataan sun, «Hin yaaddoyina'a. Hin sodaatina'a. Waaqi keessan, Waaqi abbaa keessanii, beesee qalqalluu keessan keessa keyeera. Ani kaffaltii teessan fudhadheera» jedhe. Achiin duuba inni Shimi'oon gara isaanii gad baase. ");
INSERT INTO gax_vpl VALUES ("GN43_24","002_43_24","GEN","43","24","24","Toowataan sun namoota san gara mana Yoseefii seensisee, bisaan miila dhiqatanu kenneef. Harreelee isaaniitiifille okeya kenne. ");
INSERT INTO gax_vpl VALUES ("GN43_25","002_43_25","GEN","43","25","25","Isaan akka Yoseef woliin sagalee guyya'aa nyaatanu waan dhage'aneeranuuf, kennansa ifii isaaf kenniisaaf qopheessane. ");
INSERT INTO gax_vpl VALUES ("GN43_26","002_43_26","GEN","43","26","26","Yennaa Yoseef manatti gale, isaan kennansa qopheessane isaaf kennanee, isa duratti fuulaan lafatti gad jedhaneef. ");
INSERT INTO gax_vpl VALUES ("GN43_27","002_43_27","GEN","43","27","27","Yoseef nageya isaanii gaafatee, «Jaarsi abbaan keessan sun attam? Haga ammaa hinuma jiraa?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN43_28","002_43_28","GEN","43","28","28","Isaan deebisanee, «Garbichi keeti, abbaan keenna, fayya'a; haga ammaalle hinuma jira» jedhaneen. Isaan ulfinna Yoseefiitiif, fuula isaa duratti lafatti gad jedhane. ");
INSERT INTO gax_vpl VALUES ("GN43_29","002_43_29","GEN","43","29","29","Yoseef obboleessa tiruu ifii Beniyaamin yennaa dhagge, «Obboleessi keessan maandhichi ka isin marroo isaa natti hintane kanaa?» jedhee gaafate. Inni, Beniyaaminiin, «Ilma kiyya, Waaqi si eebbisu» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN43_30","002_43_30","GEN","43","30","30","Yoseef yennaa obboleessa ifii dhagge, waan itti dhage'ameef, ariifatee gad bayee, kolloo ifii keessa dhaqee achitti bowe. ");
INSERT INTO gax_vpl VALUES ("GN43_31","002_43_31","GEN","43","31","31","Achiin duuba inni fuula ifii dhiqatee, gad baye. Ifi qabatee, sagalee akka fidanu ajaje. ");
INSERT INTO gax_vpl VALUES ("GN43_32","002_43_32","GEN","43","32","32","Gibxooti worra Ibrootaa woliin nyaatiis tuffatama waan itti fakkaattuuf, Yoseefiif qorii takka'atti, obboleeyyan isaatiif qorii dhibi'itti, Gibxoota Yoseef biratti akka nyaatanuuf qorii dhibi'itti dhikeessane. ");
INSERT INTO gax_vpl VALUES ("GN43_33","002_43_33","GEN","43","33","33","Obboleeyyan Yoseefii akkuma angafumma'aa fi maandhummaa isaaniititti, fuula isaa dura tetee'ane. Isaan baaseffatiisaan wol ilaalane. ");
INSERT INTO gax_vpl VALUES ("GN43_34","002_43_34","GEN","43","34","34","Qorii Yoseefii irraa sagalee fuudhanee isaaniif kennanee, Beniyaaminiif ammoo worra kaan caalaa harka shan kennane. Akka kanaan obboleeyyan Yoseefii isa woliin nyaatanee unanee guddoo gammadane. ");
INSERT INTO gax_vpl VALUES ("GN44_1","002_44_1","GEN","44","1","1","Yoseef toowataa mana ifii ajajee, «Namoota kanaaf midhaan haga qalqalluun isaanii qabatuu dandu'utti itti guutiif; beesee tokko tokkoo isaaniille afaan qalqalluu isaanii keessa keyi. ");
INSERT INTO gax_vpl VALUES ("GN44_2","002_44_2","GEN","44","2","2","Muduunuu tiyya ta meetii irraa hujante, beesee inni midhaaniin bitate woliin afaan qalqalluu mucaa maandhichaa keessa keyi» jedhe; toowataalle akkuma Yoseef itti hime godhe. ");
INSERT INTO gax_vpl VALUES ("GN44_3","002_44_3","GEN","44","3","3","Barii ganamaan obboleeyyan sun harreelee ifii fudhatanee akka deemanu godhane. ");
INSERT INTO gax_vpl VALUES ("GN44_4","002_44_4","GEN","44","4","4","Adoo isaan qachaa irraa hin fagaatin, Yoseef toowataa mana ifiitiin, «Ka'ii namoota hordof! Yennaa isaan dhaqqadde, ‹Nuuti waan dansaa isiniif goone; isin maaf hantuu nu'uuf gootane? ");
INSERT INTO gax_vpl VALUES ("GN44_5","002_44_5","GEN","44","5","5","Muduunuun isin hattane ta goottaan kiyya itti uniisaa fi oojjuu hiikiisaaf itti fayyadamuu motii ree? Yakkaan isin hujjane tun guddo'o› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN44_6","002_44_6","GEN","44","6","6","Toowataan sun yennaa jara dhaqqabe, akkuma Yoseef jedhe isaanitti hime. ");
INSERT INTO gax_vpl VALUES ("GN44_7","002_44_7","GEN","44","7","7","Isaan toowataa saniin, «Ati goottaa keenna, maaf waan akkanaa dubbatta? Nuuti waan akkasii tokkolle hunyee hin jirru! ");
INSERT INTO gax_vpl VALUES ("GN44_8","002_44_8","GEN","44","8","8","Nuuti beesee qalqalluu keenna keessatti dhaggineeyyuu biyya Kana'aaniitii finnee si'iif deebinneerra. Maarre nuuti mana goottaa keetii keessaa meetii yookiin worqii maaf hanna ree? ");
INSERT INTO gax_vpl VALUES ("GN44_9","002_44_9","GEN","44","9","9","Ati yoo nu keessaa qalqalluu nama tokkochaa keessatti muduunuu meeti'ii san dhaggite, inni du'uu ti; nuuti worri hafelle garboolee teeti hin teena» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN44_10","002_44_10","GEN","44","10","10","Toowataan sun, «Akkuma isin jettane teetuu ti; teetuu malee, nama muduunuu hate qofatti garbicha kiyya te'a. Isin worri hafe ammoo bilisaan deemuu dandeettan» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN44_11","002_44_11","GEN","44","11","11","Achiin duuba isaan martinuu ariifatanee qalqalluu ifii lafatti gad buusanee hiikane. ");
INSERT INTO gax_vpl VALUES ("GN44_12","002_44_12","GEN","44","12","12","Toowataan mana Yoseefii sun qalqalluu angafichaa irraa jalqabee haga qalqalluu maandhichaatitti findigee keessa barbaadee, qalqalluu Beniyaaminii keessatti muduunuu dhagge. ");
INSERT INTO gax_vpl VALUES ("GN44_13","002_44_13","GEN","44","13","13","Obboleeyyan yennaa tana dhaggite woyaa ifii tarsaatte. Achiin duuba qalqalluu ifii harre'etti fe'attee gara qacha'aa deebite. ");
INSERT INTO gax_vpl VALUES ("GN44_14","002_44_14","GEN","44","14","14","Yihuda'aa fi obboleeyyan isaa yennaa gara Yoseefii deebi'anee dhufane, Yoseef ammalle achuma jiraayyu; tanaaf obboleeyyan isa duratti fuulaan lafatti gad jedhane. ");
INSERT INTO gax_vpl VALUES ("GN44_15","002_44_15","GEN","44","15","15","Yoseef isaaniin, «Wonni isin gootane kun maan? Nami akka kiyyaa beekkumsa addaatiin woy qorqoree akka beeku hin beettanuu?» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN44_16","002_44_16","GEN","44","16","16","Yihudaan deebisee, «Nuuti goottaa kiyyaan maan jenna ree? Yakkaameyyii akka hin te'in attamiin ifi mudhisuu dandeenna ree? Waaqi yakkaa teenna mudhiseera; nama muduunuun irratti mudhatte qofa adoo hin te'in, nuuti martinuu garboota teeti hin teenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN44_17","002_44_17","GEN","44","17","17","Yoseef ammoo, «Ani ijjumaa tana hin godhu! Nama muduunuun irratti dhaggame qofatti garbicha kiyya te'a. Isin worri hafe nageyaan gara abbaa keessanii deebi'a'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN44_18","002_44_18","GEN","44","18","18","Achiin duuba Yihudaan gara Yoseefii dhaqee, «Maganne'ee, goottaa kiyya, dubbii takka sitti dubbadha; ati qixxee mooticha Gibxi'ii teetulle natti hin mufatin. ");
INSERT INTO gax_vpl VALUES ("GN44_19","002_44_19","GEN","44","19","19","Goottaa kiyya, ati tanaan qara, ‹Abbaa yookiin obboleeyyan qaddanii?› jettee nu gaafatte. ");
INSERT INTO gax_vpl VALUES ("GN44_20","002_44_20","GEN","44","20","20","Nuutille, ‹Abbaa jaarsa qanna. Obboleessa maandhicha abbaan keenna dulluu keessa uumate qanna. Obboleessi ilma maandhicha kanaa du'eera; ijoollee haati isaa dheette keessaa ka jiru isa qofa waan te'eef, abbaan keenna guddoo isa jaalata› jenneerraayyu. ");
INSERT INTO gax_vpl VALUES ("GN44_21","002_44_21","GEN","44","21","21","Achiin duuba ati, nu'uun, ‹Akka ani ila tiyyaan isa dhaggu, isa gara kiyya fida'a. Ani isa dhagguu barbaada› jette. ");
INSERT INTO gax_vpl VALUES ("GN44_22","002_44_22","GEN","44","22","22","Nuuti, ‹Mucaan abbaa ifii lakkisee dhufuu hin dande'u; yoo isa lakkisee dhufe, abbaan isaa hin du'a› si goottaa keennaan jenneerraayyu. ");
INSERT INTO gax_vpl VALUES ("GN44_23","002_44_23","GEN","44","23","23","Ati ammoo, ‹Isin yoo obboleessa keessan maandhicha hin fidin, deebitanee fuula kiyya hin dhaggitanu› nu'uun jetteerta. ");
INSERT INTO gax_vpl VALUES ("GN44_24","002_44_24","GEN","44","24","24","«Maarre nuuti gara abbaa keennaa deebinee gallee, waan ati jette isatti hinneerra. ");
INSERT INTO gax_vpl VALUES ("GN44_25","002_44_25","GEN","44","25","25","Achiin duuba, abbaan keenna, ‹Ammalle deebi'a'aatii midhaan diqqaa isaa nuu bita'a› jedhe. ");
INSERT INTO gax_vpl VALUES ("GN44_26","002_44_26","GEN","44","26","26","Nuuti abbaa keennaan, ‹Obboleessi keenna maandhichi yoo nu woliin hin deemin, fuula namichaa dhagguu hin dandeennu; tanaaf Obboleessi keenna maandhich yoo nu woliin deeme malee, deemuu hin dandeennu› jenneen. ");
INSERT INTO gax_vpl VALUES ("GN44_27","002_44_27","GEN","44","27","27","Abbaan kiyyalle nu'uun, ‹Niitiin tiyya Raahel ilmaan lama akka naaf deette hin beettan. ");
INSERT INTO gax_vpl VALUES ("GN44_28","002_44_28","GEN","44","28","28","Isaan keessaa tokkochi na biraa haga bayee jalqabee, ani waan isa hin dhagginiif, dhugumaan bineensatti isa kukkutatee nyaateera jedhee yaade. ");
INSERT INTO gax_vpl VALUES ("GN44_29","002_44_29","GEN","44","29","29","Isin amma ilma kanalle na duraa fudhatanee, wonni hantuun yoo isa dhaqqadde, akka ani dulluu tiyya keessa gaddaan boolla seenu gootan› jedhe. ");
INSERT INTO gax_vpl VALUES ("GN44_30","002_44_30","GEN","44","30","30","«Maarre amma, gootta'a, ani obboleessa kiyya maandhicha woliin malee, gara abbaa kiyya tajaajilaa keetii yoo deebi'e, inni akka malee waan isa jaalatuuf, ");
INSERT INTO gax_vpl VALUES ("GN44_31","002_44_31","GEN","44","31","31","akka inni nu woliin hin jirre yennaa dhagge hin du'a. Nuuti tajaajiltooti teetille abbaa keenna tajaajilaa keeti dulluu keessa gaddaan akka boolla seenu goona. ");
INSERT INTO gax_vpl VALUES ("GN44_32","002_44_32","GEN","44","32","32","Kana caalaalle ani abbaa kiyya duratti fayyaa muca'aatiif wobii te'ee, abbaa kiyyaan, ‹Ani mucaa keeti deebisee gara keeti yoo hin fidin, bara le'ii tiyyaa mara na komadhu› jedheera. ");
INSERT INTO gax_vpl VALUES ("GN44_33","002_44_33","GEN","44","33","33","Tanaaf maganne'ee, ani tajaajilaan keeti, addee muca'aa si goottaa kiyyaaf garbicha te'ee, asitti hafuu ti; mucaan ammoo obboleeyyan ifii woliin deebi'uu ti. ");
INSERT INTO gax_vpl VALUES ("GN44_34","002_44_34","GEN","44","34","34","Mucaan yoo na woliin hin jiraatin, ani attam gara abbaa kiyyaa deebi'uu dande'a ree? Ani gadda abbaa kiyya irratti dhufu san ossatiisa hin dande'u» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN45_1","002_45_1","GEN","45","1","1","Achiin duuba Yoseef worra isa bira dhaabbatu mara duratti ifi qabatuu dadhabee, «Namoota mara na irraa gad baasa'a» jedhee ajaje; yennaa Yoseef obboleeyyan ifiititti eennummaa ifii hime nami tokkolle isa woliin hin jiruuyyu. ");
INSERT INTO gax_vpl VALUES ("GN45_2","002_45_2","GEN","45","2","2","Worri Gibxi'iitii fi worri mana mootumma'aalle haga dhage'anutti Yoseef qoonqoo ol qabatee bowe. ");
INSERT INTO gax_vpl VALUES ("GN45_3","002_45_3","GEN","45","3","3","Yoseef obboleeyyan ifiitiin, «Ani Yoseef. Abbaan kiyya haga ammaa hin jiraa?» jedhe. Obboleeyyan isaa ammoo fuula isaa duratti guddoo waan sodaatteef deebii isaaf deebisuu hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("GN45_4","002_45_4","GEN","45","4","4","Achiin duuba Yoseef obboleeyyan ifiitiin, «Gara kiyya dhikaadha'a» jedhe. Isaanille gara isaa dhikaatane. Innille isaaniin, «Ani obboleessa keessan Yoseef, ka isin gara biyya Gibxi'ii gurgurtane. ");
INSERT INTO gax_vpl VALUES ("GN45_5","002_45_5","GEN","45","5","5","Waaqi lubbuu kolba'aa fayyisiisaaf, isiniin dura waan na ergeef, isin waan as na gurgurtaneef hin yaaddoyina'a yookiin ifitti hin aarina'a. ");
INSERT INTO gax_vpl VALUES ("GN45_6","002_45_6","GEN","45","6","6","Lafa irratti beelti haga buuteen amma woggaa lama; woggaa shanan ammalle dhufu'uu jirtu keessatti hin qotatanu, hin haammatanulle'e. ");
INSERT INTO gax_vpl VALUES ("GN45_7","002_45_7","GEN","45","7","7","Kolbaan hedduun akka fayyituuf jiruu teessan fayyisiisaan, sanyiin teessan lafa irratti akka hattuuf, Waaqi isiniin dura as na erge. ");
INSERT INTO gax_vpl VALUES ("GN45_8","002_45_8","GEN","45","8","8","Maarre ka as na erge Waaqa malee, isinii moti. Waaqi qondaala ol aanaa mooticha biyya Gibxi'ii, itti gaafatamaa mana mootummaa mootichaatii fi lafa Gibxi'ii duudii irratti bulchaa na godheera. ");
INSERT INTO gax_vpl VALUES ("GN45_9","002_45_9","GEN","45","9","9","«Amma ariifadha'aa gara abbaa kiyyaa dhaqa'aatii, ilmi keeti Yoseef, ‹Waaqi lafa Gibxi'ii mara irratti bulchaa na godheera. Hin turinii na bira koy! ");
INSERT INTO gax_vpl VALUES ("GN45_10","002_45_10","GEN","45","10","10","Lafa natti dhikaattu lafa Gooshenii keessa hin leeta; atii fi ijoolleen teeti, ijoolleen ijoollee teetii, hoole'ee fi re'een teeti, loon keeti, wonni ati qaddu martille natti hin dhikaatan. ");
INSERT INTO gax_vpl VALUES ("GN45_11","002_45_11","GEN","45","11","11","Ammalle woggooti beelaa shan waan hatteef, ati, maatiin teetii fi horiin keeti akka hin beelonne, ani Gooshenitti waan isinii barbaachisu hin godha› jedha'aatii itti hima'a. ");
INSERT INTO gax_vpl VALUES ("GN45_12","002_45_12","GEN","45","12","12","«Ani afaan kiyyaan akka isinitti dubbadhe, isinuu dhaggitaneertan, obboleessi kiyya Beniyaamille dhaggeera. ");
INSERT INTO gax_vpl VALUES ("GN45_13","002_45_13","GEN","45","13","13","Biyya Gibxi'ii keessatti ulfinna guddaa attamii akka ani qabuu fi marroo waan dhaggitanee mara abbaa kiyyatti hima'a. Abbaa kiyyalle ariifadha'aa as fida'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN45_14","002_45_14","GEN","45","14","14","Achiin duuba inni morma Beniyaaminii obboleessa ifii hanqafatee bowe; Beniyaaminille morma isaa hanqafatee bowe. ");
INSERT INTO gax_vpl VALUES ("GN45_15","002_45_15","GEN","45","15","15","Yoseef obboleeyyan ifii mara sunqatee itti bowe. Tanaan duuba obboleeyyan isaa isa woliin haasowane. ");
INSERT INTO gax_vpl VALUES ("GN45_16","002_45_16","GEN","45","16","16","Oduun dhufiisa obboleeyyan Yoseefii mana mootumma'aatitti yennaa dhage'ante, mootichi Gibxi'iitii fi qondaaltoti isaa akka malee gammadane. ");
INSERT INTO gax_vpl VALUES ("GN45_17","002_45_17","GEN","45","17","17","Maarre mootichi, Yoseefiin, «Obboleeyyan teetiin, ‹Geejjiba keessan fe'adha'aatii gara lafa Kana'aanii deebi'a'a. ");
INSERT INTO gax_vpl VALUES ("GN45_18","002_45_18","GEN","45","18","18","Abbaa keessanii fi maatii teessan gara kiyya fida'a. Ani lafa Gibxi'ii keessaa ta irra caalaa dansa'aa isiniif hin kenna, isinille sagalee dansaa lafa sanii hin nyaattan› jedhi. ");
INSERT INTO gax_vpl VALUES ("GN45_19","002_45_19","GEN","45","19","19","Dabalii isaan ajajiitii, ‹Garreettaa geejjibaa ka niitota teessan, ijoollee teessanii fi abbaa keessan itti feetanee fiddanu, biyya Gibxi'iitii fudhadha'aa deema'a. ");
INSERT INTO gax_vpl VALUES ("GN45_20","002_45_20","GEN","45","20","20","Biyya Gibxi'ii keessatti lafa irra caalaa dansa'aa waan dhaggattanuuf, karra teessan ta lakkittanee dhuttanuuf hin qucuucamina'a› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN45_21","002_45_21","GEN","45","21","21","Maarre ilmaan Yaaqoobii akkuma jedhame godhane. Akkuma mootichi ajaje, Yoseef garreettaa geejjibaatii fi ideensa kara'aatiif galaa isaaniif kenne. ");
INSERT INTO gax_vpl VALUES ("GN45_22","002_45_22","GEN","45","22","22","Inni woyaa adduu tokko tokkoo isaaniitiifuu kenne; Beniyaaminiif ammoo woyaa adduu shanii fi meetii dhibba sad kenne. ");
INSERT INTO gax_vpl VALUES ("GN45_23","002_45_23","GEN","45","23","23","Abbaa ifiitiif waan dadansaa biyya Gibxi'iititti dhaggamanu fe'iisa harreele'ee kudhan, dabaleelle ideensa kara'aatiif galaa akka te'u midhaanii fi daabboo, sagalee dhibiille fe'iisa harreelee dhaltu'uu kudhan erge. ");
INSERT INTO gax_vpl VALUES ("GN45_24","002_45_24","GEN","45","24","24","Inni obboleeyyan ifii ergee, isaanille ka'aaranuun, inni, «Karaa irratti wol hin lolina'a!» isaaniin jedhe. ");
INSERT INTO gax_vpl VALUES ("GN45_25","002_45_25","GEN","45","25","25","Maarre isaan biyya Gibxi'iitii bayanee, lafa Kana'aanii keessatti gara Yaaqoobii abbaa ifii dhufane. ");
INSERT INTO gax_vpl VALUES ("GN45_26","002_45_26","GEN","45","26","26","Isaan, abbaa ifiitiin, «Yoseef haga ammaa hin jira! Lafa Gibxi'ii duudii irrattiiyyuu bulchaa te'eera» jedhane. Yaaqoob ammoo nayee gaggabe; inni dubbii isaaniille dhugeeffatiisa hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("GN45_27","002_45_27","GEN","45","27","27","Te'uu malee waan Yoseef isaaniin jedhe mara yennaa isaan itti himane, gara biyya Gibxi'ii akka ittiin isa fidanu garreettaa geejjibaa ka Yoseef ergelle yennaa dhagge bayyanate. ");
INSERT INTO gax_vpl VALUES ("GN45_28","002_45_28","GEN","45","28","28","Achiin duuba Yaaqoob, «Ilmi kiyya Yoseef haga ammaa jiraachuun isaa na geetti! Ani adoo hin du'in dhaqee isa dhagguu qaba» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN46_1","002_46_1","GEN","46","1","1","Maarre Yaaqoob waan qabu mara fudhatee gara biyya Gibxi'ii dhaqiisaaf ka'ee, Bersheebaa yennaa geye, Waaqa Yisihaqii abbaa ifiitiif ciincaa dhikeesse. ");
INSERT INTO gax_vpl VALUES ("GN46_2","002_46_2","GEN","46","2","2","Halkan Waaqi mudhi'iin, «Yaaqoob, Yaaqoob!» jedhee waame. Yaaqoobille, «Ani kunoo as jira» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN46_3","002_46_3","GEN","46","3","3","Achiin duuba Waaqi, «Ani Waaqa; Waaqa abbaa keetii ti; ani achitti gosa guddoo waan si godhuuf, gara biyya Gibxi'ii dhaqiisa hin sodaatin. ");
INSERT INTO gax_vpl VALUES ("GN46_4","002_46_4","GEN","46","4","4","Ani si woliin gara biyya Gibxi'ii hin dhaqa; sanyii teeti gara lafa tanaa deebisee hin fida. Yennaa ati duutu Yoseef harka ifiitiin ila teeti wolitti siif hin qaba» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN46_5","002_46_5","GEN","46","5","5","Achiin duuba Yaaqoob Bersheeba'aa ka'e. Ilmaan isaalle abbaa ifii Yaaqoob, ilme'ee fi ibidda ifii garreettaa geejjibaa ka mootichi Gibxi'ii akka ittiin dhufanuuf ergetti yaassisane. ");
INSERT INTO gax_vpl VALUES ("GN46_6","002_46_6","GEN","46","6","6","Isaan horii ifiitii fi waan lafa Kana'aaniititti horatane mara fudhatanee gara biyya Gibxi'ii dhaqane. Akka kanaan Yaaqoob sanyii ifii mara woliin, ");
INSERT INTO gax_vpl VALUES ("GN46_7","002_46_7","GEN","46","7","7","ilmaan ifiitii fi ilmaan ilmaan ifii woliin, ijoollee durraa ta ilmaan ifiitii fi maatii ifii mara woliin gara biyya Gibxi'ii dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN46_8","002_46_8","GEN","46","8","8","Israa'elooti gara biyya Gibxi'ii dhaqane, sanyiin Yaaqoobii ta asii gad jirtu. Ilma angaficha Yaaqoobii Ruubenii ");
INSERT INTO gax_vpl VALUES ("GN46_9","002_46_9","GEN","46","9","9","fi ilmaan Ruubenii: Henok, Faluu, Hezronii fi Karmi. ");
INSERT INTO gax_vpl VALUES ("GN46_10","002_46_10","GEN","46","10","10","Ilmaan Shimi'oonii: Yimu'el, Yaamiin, Ohad, Yaakiin, Zohaarii fi Shaawul; Shaawul dubartii worra Kana'aaniititti deye. ");
INSERT INTO gax_vpl VALUES ("GN46_11","002_46_11","GEN","46","11","11","Ilmaan Lewwi'ii: Gershoon, Qehaatii fi Meraar. ");
INSERT INTO gax_vpl VALUES ("GN46_12","002_46_12","GEN","46","12","12","Ilmaan Yihuda'aa: Eer, Onaan, Shelaa, Faaresii fi Zaara'a (Eerii fi Onaan ammoo lafa Kana'aanii keessatti du'ane). Ilmaan Faaresii: Hezronii fi Hamul. ");
INSERT INTO gax_vpl VALUES ("GN46_13","002_46_13","GEN","46","13","13","Ilmaan Yisaakorii: Tolaa, Fuwaa, Yobii fi Shimroon. ");
INSERT INTO gax_vpl VALUES ("GN46_14","002_46_14","GEN","46","14","14","Ilmaan Zebuloonii: Sered, Eloonii fi Yaahile'el. ");
INSERT INTO gax_vpl VALUES ("GN46_15","002_46_15","GEN","46","15","15","Ilmaan Yaaqoobii ta Liyaan niitii isaa phaadaan-Aaramitti deetteef, intala isaa Dinaalle dabalatee, wolumatti ilmaan isaatii fi ilmaan ilmaan isaa soddomii sad. ");
INSERT INTO gax_vpl VALUES ("GN46_16","002_46_16","GEN","46","16","16","Ilmaan Gaadii: Ziifiyon, Haagii, shunii, Esbon, Erii, Arodii, Ar'eli. ");
INSERT INTO gax_vpl VALUES ("GN46_17","002_46_17","GEN","46","17","17","Ilmaan Asheerii: Yiimnaa, Yishwaa, Yishwii fi Berii'a; obboleettiin isaanii Sera'a; ilmaan Berii'aa: Heberii fi Malkii'el. ");
INSERT INTO gax_vpl VALUES ("GN46_18","002_46_18","GEN","46","18","18","Isaan kudhanii jaa kun, ta Laabaan intala ifii Liya'aaf garbumma'aan kenne, Zilfaa irraa ka dhalatane, ilmaan ilmaan Yaaqoobii ti. ");
INSERT INTO gax_vpl VALUES ("GN46_19","002_46_19","GEN","46","19","19","Ilmaan Raahelii niitii Yaaqoobii Yoseefii fi Beniyaamin. ");
INSERT INTO gax_vpl VALUES ("GN46_20","002_46_20","GEN","46","20","20","Biyya Gibxi'iititti Yoseef intala Phoxii-Feraa hayyicha Onii, Asenaati irraa Minaase'ee fi Efreem uumate. ");
INSERT INTO gax_vpl VALUES ("GN46_21","002_46_21","GEN","46","21","21","Ilmaan Beniyaaminii: Bel'aa, Beker, Ashbel, Geraa, Na'amaan, Ehii, Roshi, Mufiim, Hufiimii fi Ardi'i. ");
INSERT INTO gax_vpl VALUES ("GN46_22","002_46_22","GEN","46","22","22","Ilmaan Yaaqoobii worri Raahel deetteef kun ijoollee isaanii woliin wolumatti nama kudhanii afur. ");
INSERT INTO gax_vpl VALUES ("GN46_23","002_46_23","GEN","46","23","23","Ilmi Daanii Hushiim. ");
INSERT INTO gax_vpl VALUES ("GN46_24","002_46_24","GEN","46","24","24","Ilmaan Naftaalemii: Yaahize'el, Gunii, Yezerii fi Shiilem. ");
INSERT INTO gax_vpl VALUES ("GN46_25","002_46_25","GEN","46","25","25","Isaan torbaan kun, ta Laabaan intala ifii Raaheliif garbumma'aan kenne, Bilhaa irraa ka dhalatane, ilmaan ilmaan Yaaqoobii ti. ");
INSERT INTO gax_vpl VALUES ("GN46_26","002_46_26","GEN","46","26","26","Namooti Yaaqoob woliin gara biyya Gibxi'ii dhaqane, dubartoota ilmaan isaa adoo itti hin dabalin, sanyii isaa ka te'ane callaan namoota jaatamii jaa. ");
INSERT INTO gax_vpl VALUES ("GN46_27","002_46_27","GEN","46","27","27","Ilmaan lama ta biyya Gibxi'ii keessatti Yoseefiif dhalatte woliin laakkossi maatii Yaaqoobii torbaatama. ");
INSERT INTO gax_vpl VALUES ("GN46_28","002_46_28","GEN","46","28","28","Yaaqoob akka Yoseef Gooshen keessatti isa dhagguuf Yihudaa ifiin dura gara isaa erge. Yaaqoobii fi kolbaan isaa yennaa lafa Gooshenii geyane, ");
INSERT INTO gax_vpl VALUES ("GN46_29","002_46_29","GEN","46","29","29","Yoseef abbaa ifii Yaaqoob qophatiisaaf garreettaa fardaa qopheeffatee, Gooshen dhaqe. Yoseef akkuma abbaa ifii dhaggeen, morma isaatitti maratee, yennaa dheertu'uuf bowe. ");
INSERT INTO gax_vpl VALUES ("GN46_30","002_46_30","GEN","46","30","30","Yaaqoob Yoseefiin, «Haga ammaa akka ati lubbu'uun jirtu waan dhaggeef, ani amma du'ulle hin qoru!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN46_31","002_46_31","GEN","46","31","31","Achiin Yoseef obboleeyyan ifiitii fi maatii abbaa ifiitiin, «Ani ol deemee mootichaan, ‹Obboleeyyan tiyyaa fi maatiin abbaa kiyyaa ka lafa Kana'aanii turane gara kiyya dhufaneeran. ");
INSERT INTO gax_vpl VALUES ("GN46_32","002_46_32","GEN","46","32","32","Isaan worra horii tissu; isaan duruuyyuu horii horsiisaa turane. Ammalle hoole'ee fi re'ee ifii, loon ifiitii fi waan qabanu maraayyuu fidatanee dhufaneeran› jedhaan. ");
INSERT INTO gax_vpl VALUES ("GN46_33","002_46_33","GEN","46","33","33","Mootichi isin waamee, ‹Hujiin teessan maan?› jedhee yennaa isin hin gaafate, ");
INSERT INTO gax_vpl VALUES ("GN46_34","002_46_34","GEN","46","34","34","isin, ‹Nuuti garbooti teeti akkuma abbootii teenna ta durii, ijoollummaa teennaa jalqannee tissitoota hori'ii ti› jedha'aan. Tana yennaa jettane, worri Gibxi'ii tissitoota waan tuffatanuuf, lafa Gooshenii keessa le'iisaaf eeyyama hin dhaggatan» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN47_1","002_47_1","GEN","47","1","1","Yoseef gara mooticha Gibxi'ii dhaqee, «Abbaan kiyyaa fi obboleeyyan tiyya, hoolotaa fi re'oota ifii, horii ifiitii fi waan qabanu mara woliin lafa Kana'aaniitii dhufaneeran. Isaan amma lafa Gooshenii keessa jiran» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN47_2","002_47_2","GEN","47","2","2","Inni obboleeyyan ifii keessaa nama shan filee mooticha dura dhikeesse. ");
INSERT INTO gax_vpl VALUES ("GN47_3","002_47_3","GEN","47","3","3","Mootichi, «Hujiin teessan maan?» jedhee obboleeyyan Yoseefii gaafate. Isaan deebisanee, «Nuuti, tajaajiltooti teeti, akkuma abbootii teenna ta durii, horsiittuu hoole'ee ti. ");
INSERT INTO gax_vpl VALUES ("GN47_4","002_47_4","GEN","47","4","4","Lafa Kana'aanii keessa beelti waan jabaatteef, horiin keennalle marra dheedu waan dhabeef, nuuti yenna'aaf as le'iisaaf dhunneerra. Tanaaf maganne'ee, lafa Gooshenii keessa akka leenu nuu eeyyami» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN47_5","002_47_5","GEN","47","5","5","Achiin duuba Mootichi Gibxi'ii Yoseefiin, «Abbaan keetii fi obboleeyyan teeti eega sii dhufanee, ");
INSERT INTO gax_vpl VALUES ("GN47_6","002_47_6","GEN","47","6","6","Latti Gibi'ii kunoo harka keeti jirti; biyya Gibxi'ii keessaa lafa irra caalaa dansa'aa Gooshenitti isaan qussiisi. Isaan keessaa dandeettii addaa ka qabanu yoo jiraatane, horii kiyya irratti itti gaafatantoota godhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN47_7","002_47_7","GEN","47","7","7","Achiin duuba Yoseef abbaa ifii Yaaqoob ol seensisee mooticha dura dhikeesse; Yaaqoobille mooticha eebbise. ");
INSERT INTO gax_vpl VALUES ("GN47_8","002_47_8","GEN","47","8","8","Achiin duuba mootichi, «Woggaan teeti meeqa?» jedhee Yaaqoob gaafate. ");
INSERT INTO gax_vpl VALUES ("GN47_9","002_47_9","GEN","47","9","9","Yaaqoobille, «Ani asii fi achi daaqaa woggaa dhibbaa fi soddoma tureera. Woggooti sunille abbootiin tiyya ta durii asii fi achi daaqaa ta turte caalaa diqqo'oo fi rakkinnaan ta guutante» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN47_10","002_47_10","GEN","47","10","10","Achiin duuba Yaaqoob mooticha eebbisee biraa deeme. ");
INSERT INTO gax_vpl VALUES ("GN47_11","002_47_11","GEN","47","11","11","Maarre Yoseef akkuma mootichi ajaje abbaa ifiitii fi obboleeyyan ifii lafa Gibxi'ii keessaa addee irra dansa'aa, qachaa Raamsesii bira lafa kenneef. ");
INSERT INTO gax_vpl VALUES ("GN47_12","002_47_12","GEN","47","12","12","Yoseef abbaa ifii, obboleeyyan ifiitii fi worra mana abbaa ifii maraaf, akkuma laakkossa nama harka isaanii eegatuutitti sagalee isaaniif kenne. ");
INSERT INTO gax_vpl VALUES ("GN47_13","002_47_13","GEN","47","13","13","Lafa duudii keessa beelti waan jabaatteef, wonni nyaatanu dhabame; kolbaan Gibxi'iitii fi Kana'aanii beelaan guddoo miidhante. ");
INSERT INTO gax_vpl VALUES ("GN47_14","002_47_14","GEN","47","14","14","Yoseef beesee namooti biyya Gibxi'iitii fi Kana'aanii ittiin midhaan bitatane mara wolitti qabee, gara mana mootummaa mooticha Gibxi'ii fide. ");
INSERT INTO gax_vpl VALUES ("GN47_15","002_47_15","GEN","47","15","15","Beeseen worra Gibxi'iitii fi Kana'aanii yennaa dhumatte, worri Gibxi'ii martinuu gara Yoseefii dhufee, «Nuuti maaf ila teeti duratti duuna? Beeseen teenna dhumatteerti. Sagalee nuu kenni» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN47_16","002_47_16","GEN","47","16","16","Yoseef deebisee, «Beeseen isin duraa yoo dhumatte, horii keessan fida'a! Ani jijjiirraa isaanii midhaan isiniif hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN47_17","002_47_17","GEN","47","17","17","Maarre kolbaan horii ifii gara Yoseefii fiddee, inni jijjiirraa fardoo, hoolee, re'ee, loonii fi harree isaaniitiif sagalee isaaniif kenne. Woggaa san inni jijjiirraa horii isaanii maraaf sagalee isaaniif kenne. ");
INSERT INTO gax_vpl VALUES ("GN47_18","002_47_18","GEN","47","18","18","Woggaan sun yennaa dabarte, woggaa itti aantu isaan gara isaa dhufanee, «Beeseen teenna akka dhumatte, horiin keennalle keeti akka te'e, si goottaa keenna hin dhossinu; nafaa fi lafa teenna malee, wonni nuuf hafe tokkolle hin jiru. ");
INSERT INTO gax_vpl VALUES ("GN47_19","002_47_19","GEN","47","19","19","Nuutii fi latti teennalle ila teeti duratti bannaa ree? Nu'uu fi lafa teennalle bitadhuutii sagalee nuu kenni; nuuti lafa teenna woliin mootichaaf garboota hin teena. Nyaannee jiru'uun akka leenuuf midhaan nuu kenni; latti teennalle duwwaa akka hin teene sanyii facaafannu nuu kenni» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN47_20","002_47_20","GEN","47","20","20","Maarre Yoseef lafa biyya Gibxi'ii mara mootichaaf bite. Beelti waan jabaatteef, nami Gibxi'ii martinuu lafa ifii Yoseefitti gurgure; Lattille qabeenna mootichaa teete. ");
INSERT INTO gax_vpl VALUES ("GN47_21","002_47_21","GEN","47","21","21","Yoseef biyya Gibxi'ii qacce'ee haga qacce'eetitti kolbaa garboota mooticha Gibxi'ii godhe. ");
INSERT INTO gax_vpl VALUES ("GN47_22","002_47_22","GEN","47","22","22","Yoseef lafa hayyootaa callaa hin binne; hayyooti durgoo yennaa mara mooticha irraa waan fudhatanuuf, isaan lafa ifii hin gurgurre. ");
INSERT INTO gax_vpl VALUES ("GN47_23","002_47_23","GEN","47","23","23","Yoseef kolba'aan, «Ani amma isinii fi lafa teessan mootichaaf waan biteef, kunoo ani sanyii isiniif hin kenna, fichaa keessanitti facaafadha'a. ");
INSERT INTO gax_vpl VALUES ("GN47_24","002_47_24","GEN","47","24","24","Ammoo yennaa midhaan galutti, harka shan keessaa tokko mootichaaf hin kennitan. Harka afur ka hafe sanyi'iif, sagalee teessaniif, sagalee worra keessaniitii fi ijoollee teessanii te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN47_25","002_47_25","GEN","47","25","25","Isaan deebisanee, «Ati lubbuu teenna hamburteerta; gootta'a, si'uma duratti fudhatama dhagganuu ti; nuuti garboota mootichaa hin teena» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN47_26","002_47_26","GEN","47","26","26","Maarre Yoseef biyya Gibxi'ii keessatti harka shan keessaa tokko mootichaaf akka kennamu seera haga adhaa jiru tume. Latti qabeenna mootichaa hin te'in lafa hayyootaa qofa. ");
INSERT INTO gax_vpl VALUES ("GN47_27","002_47_27","GEN","47","27","27","Israa'elooti biyya Gibxi'ii lafa Gooshenii keessa le'ane. Isaan achitti qabeenna dhaggatanee, ijoollee horanee laakkossaan bacatane. ");
INSERT INTO gax_vpl VALUES ("GN47_28","002_47_28","GEN","47","28","28","Yaaqoob biyya Gibxi'ii keessa woggaa kudhanii torba le'e; woggaan isaalle dhibba tokkoo fi afurtamii torba teete. ");
INSERT INTO gax_vpl VALUES ("GN47_29","002_47_29","GEN","47","29","29","Yennaan Yaaqoob du'u dhikaannaan, inni ilma ifii Yoseef gara ifii waamee, «Ani si duratti fudhatama yoo qabaadhe, harka keetiin gudeeda kiyya qabadhuu akka biyya Gibxi'ii keessatti na hin awwaalle naaf kakadhu. ");
INSERT INTO gax_vpl VALUES ("GN47_30","002_47_30","GEN","47","30","30","Yennaa ani du'e, biyya Gibxi'ii keessaa fuudhii na baasiitii, addee abbootiin tiyya itti awwaalamanetti na awwaali» jedheen. Yoseef deebisee, «Ani akkuma ati jette hin godha» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN47_31","002_47_31","GEN","47","31","31","Yaaqoob, «Anaaf kakadhu» jedheen; Yoseefille akka tana godhu kakate. Achiin duuba Yaaqoob mataa taqee ifii irratti Waaqaaf sagade. ");
INSERT INTO gax_vpl VALUES ("GN48_1","002_48_1","GEN","48","1","1","Yennaa diqqo'oon duuba, «Abbaan keeti dhibameera» jedhanee Yoseefitti himane. Maarre inni ilmaan ifii lamaan Minaase'ee fi Efreem fudhatee gara abbaa ifii dhaqe. ");
INSERT INTO gax_vpl VALUES ("GN48_2","002_48_2","GEN","48","2","2","Yennaa, «Ilmi keeti Yoseef gara keeti dhufeera» jedhanee Yaaqoobitti himane, inni ifi jajjabeessee, ol jedhee taqee ifii irra tee'e. ");
INSERT INTO gax_vpl VALUES ("GN48_3","002_48_3","GEN","48","3","3","Yaaqoob, Yoseefiin, «Waaqi waan mara dande'u, lafa Kana'aanii keessa, addee, ‹Luz› jedhantutti natti mudhatee na eebbisee, ");
INSERT INTO gax_vpl VALUES ("GN48_4","002_48_4","GEN","48","4","4","‹Ani si horsiisee si hin baceessa. Abbaa kolbaa heddu'uu si hin godha; lafa tana haga bara baraa sanyii teetiif hin kenna› anaan jedhe. ");
INSERT INTO gax_vpl VALUES ("GN48_5","002_48_5","GEN","48","5","5","«Tanaaf ilmaan teeti lamaan, ta adoo ani gara keeti achi hin dhufiniin dura biyya Gibxi'ii keessatti sii dhalatte, amma tiyya; Efreemii fi Minaaseen akkuma Ruubenii fi Shimi'oonii kiyya hin te'an. ");
INSERT INTO gax_vpl VALUES ("GN48_6","002_48_6","GEN","48","6","6","Ijoolleen ati isaaniin duuba uumatte keeti hin te'an; isaan dhaala ifii maqaa obboleeyyan ifii Efreemiitii fi Minaase'eetiin dhaggatan. ");
INSERT INTO gax_vpl VALUES ("GN48_7","002_48_7","GEN","48","7","7","Yennaa ani phaadaan-Aaramii deebi'u biyya Kana'aanii keessatti Efraataa geyaaruun, Raahel kara'atti na duraa duutee, karaa Efraataa dhaqu cina'atti awwaale» jedhe. Efraataan amma, «Betlihem» jedhama. ");
INSERT INTO gax_vpl VALUES ("GN48_8","002_48_8","GEN","48","8","8","Yaaqoob yennaa ilmaan Yoseefii dhagge, «Isaan kun eennu fa'a?» jedhee gaafate. ");
INSERT INTO gax_vpl VALUES ("GN48_9","002_48_9","GEN","48","9","9","Yoseef deebisee abbaa ifiitiin, «Isaan ilmaan tiyya ta Waaqi as biyya tanatti naaf kenne» jedhe. Yaaqoob, «Akka ani isaan eebbisu gara kiyya fidi!» Yoseefiin jedhe. ");
INSERT INTO gax_vpl VALUES ("GN48_10","002_48_10","GEN","48","10","10","Yennaa tana Yaaqoob waan dulloomeeruuf ilti isaa caararroottee, hubatee dhagguu hin dandeenne. Maarre Yoseef ilmaan ifii gara isaa fide; innille hanqafatee sunqate. ");
INSERT INTO gax_vpl VALUES ("GN48_11","002_48_11","GEN","48","11","11","Yaaqoob, Yoseefiin, «Ani deebi'ee ijjumaa si dhagga jedhee hin yaadanne; amma Waaqi ijoollee teetiiyyuu na dhaggisiise» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN48_12","002_48_12","GEN","48","12","12","Achiin duuba Yoseef jilba abbaa ifii irraa isaan kaasee, inni ifiif lafatti gad gombifame. ");
INSERT INTO gax_vpl VALUES ("GN48_13","002_48_13","GEN","48","13","13","Yoseef ilmaan ifii lamaanuu fuudhee, Efreem midda ifiitiin Yaaqoobiif gara bita'aatiin, Minaasee bitaa ifiitiin Yaaqoobiif gara middaatiin itti dhikeesse. ");
INSERT INTO gax_vpl VALUES ("GN48_14","002_48_14","GEN","48","14","14","Yaaqoob ammoo harka ifii wol qaxxaamursee harka ifii middicha mataa Efreemii maandhichaa irra, harka ifii bitaacha mataa Minaasee angafichaa irra keye. ");
INSERT INTO gax_vpl VALUES ("GN48_15","002_48_15","GEN","48","15","15","Achiin duuba inni Yoseef eebbisee, «Waaqi abbootiin tiyya Abrahaamii fi Yisihaq tajaajilte jiruu tiyya mara haga adhaa ka na eege. ");
INSERT INTO gax_vpl VALUES ("GN48_16","002_48_16","GEN","48","16","16","Ergamaan miidhaa mara irraa na wode inni ijoollee tana eebbisuu ti. Maqaa kiyya, maqaa abbootii tiyyaa Abrahaamii fi Yisihaqii waansisanee, lafa irrattille horanee bacatanuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN48_17","002_48_17","GEN","48","17","17","Yoseef yennaa abbaan isaa harka ifii middicha mataa Efreemii irra keyeeruun dhagge itti hin gammanne; maarre inni harka abbaa ifii mataa Efreemii irraa gara mataa Minaase'ee dabarsiisaaf qabe. ");
INSERT INTO gax_vpl VALUES ("GN48_18","002_48_18","GEN","48","18","18","Yoseef abbaa ifiitiin, «Abbaa kiyya, akkasii moti! Kun angaficha waan te'eef, harka keeti middicha mataa isaa irra keyi!» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN48_19","002_48_19","GEN","48","19","19","Abbaan isaa ammoo didee, «Ani hin beeka, ilma kiyya, ani hin beeka. Sanyiin Minaase'eelle kolbaa guddoo hin teeti; te'uu malee, obboleessi isaa maandhich isa hin caala; sanyiin isaalle kolbaa biyya adda addaa guddoo hin teeti» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN48_20","002_48_20","GEN","48","20","20","Maarre inni guyyaa san isaan eebbisee, «Israa'elooti, ‹Waaqi akka Efreemii fi Minaase'ee si godhuu ti› jedhanee maqaa keetiin nama hin eebbisan» jedhe. Akkasiin Yaaqoob Efreem Minaase'een dura aanse. ");
INSERT INTO gax_vpl VALUES ("GN48_21","002_48_21","GEN","48","21","21","Achiin duuba Yaaqoob Yoseefiin, «Kunoo, ani du'aara; Waaqi ammoo si woliin jiraatee gara lafa abbootii teetii si hin deebisa. ");
INSERT INTO gax_vpl VALUES ("GN48_22","002_48_22","GEN","48","22","22","Ani ka obboleeyyan teeti woliin qoodantane caalaa, lafa dansaa Sheekemii ta shallaaga'aa fi guubee worra Amoorotaa irraa fudhadhe si'iif hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN49_1","002_49_1","GEN","49","1","1","Achiin duuba Yaaqoob ilmaan ifii waammatee, «Waan gara duraa isinitti dhufu akka isinitti himuuf, wolitti dacha'a'a! ");
INSERT INTO gax_vpl VALUES ("GN49_2","002_49_2","GEN","49","2","2","«Ilmaan Yaaqoobii, wolitti dacha'a'aa dhage'a'a; abbaa keessan Yaaqoob dhage'a'a. ");
INSERT INTO gax_vpl VALUES ("GN49_3","002_49_3","GEN","49","3","3","«Ruuben, ati ilma kiyya angaficha, hunna tiyyaa fi jabeenna kiyya ka qaraa ti; ulfinnaa fi hunnaan ilmaan tiyya mara hin caalta. ");
INSERT INTO gax_vpl VALUES ("GN49_4","002_49_4","GEN","49","4","4","Te'uu malee, ati ka akka bisaanii daaquu waan teeteef, obboleeyyan teeti hin sooressitu; rifanoo abbaa keetii irra waan baateef, dubartoota gursumeeyyii abbaa keetii woliin ratteerta. ");
INSERT INTO gax_vpl VALUES ("GN49_5","002_49_5","GEN","49","5","5","«Shimi'oonii fi Lewwiin obboleeyyan; shallaagaan isaanii meya isaan hunnaan nama irratti ka'anu. ");
INSERT INTO gax_vpl VALUES ("GN49_6","002_49_6","GEN","49","6","6","Isaan aari'iin namoota waan ijjeesaneef, taphaaf jedhanee korommii waan mogolchaneef, ani marii isaaniititti hin galu; yaa'ii isaaniille hin qoodamu. ");
INSERT INTO gax_vpl VALUES ("GN49_7","002_49_7","GEN","49","7","7","Aariin isaanii jadduu, mufiin isaanii gadhi-jabeettii waan teeteef, ta abaarante teetuu ti! Ani gosa Yaaqoobii odduu isaan qoqoodee Israa'el keessa isaan hin bittinneessa. ");
INSERT INTO gax_vpl VALUES ("GN49_8","002_49_8","GEN","49","8","8","«Yihuda'a, obboleeyyan teeti si hin leellisan; ati diina keeti hin injifatta; ilmaan abbaa keetii si duratti gad hin jedhan. ");
INSERT INTO gax_vpl VALUES ("GN49_9","002_49_9","GEN","49","9","9","Ilmi kiyya Yihudaan akka ilmee neenqaa, ta adamo'oo gara mandhee ifii deebituu ti. Akka neenqaa diriirfatee irkata; eentu isa kaasiisaaf itti guula? ");
INSERT INTO gax_vpl VALUES ("GN49_10","002_49_10","GEN","49","10","10","Ka kolbaan duudiin ajajantuuf, haga bara baraa ka bulchu, ka mootummaan isaaf malte, haga dhufutti, bokkuun harka Yihuda'aatii hin baatu. Mootoleen maatii Yihuda'aa irraa hin dhufan; nami tokko Yihudaa irraa yennaa mara barcumaa mootumma'aa irra hin tee'a. Ka mootummaan isaaf malte haga dhufutti Yihudaan hin bulcha; gosi biyya adda addaalle isaaf hin ajajaman. ");
INSERT INTO gax_vpl VALUES ("GN49_11","002_49_11","GEN","49","11","11","Inni woynii bacaa qaba; harree ifii muka woyni'iititti, ilmayyoo harree ifii woynii filatantetti hidhata. Inni woyaa ifii daadhii woyni'iitiin, bullukkoo ifii dhiiga midhaan woyni'iitiin dhiqata. ");
INSERT INTO gax_vpl VALUES ("GN49_12","002_49_12","GEN","49","12","12","Ilti isaa daadhii woyni'ii caalaa diimatti; ilkaan isaa aanan caalaa addaata. ");
INSERT INTO gax_vpl VALUES ("GN49_13","002_49_13","GEN","49","13","13","«Zebuloon qarqara abbaaya'aa hin le'a; qarqarri abbaaya'aa ka isaa sun lafa buufata hoboloota gugurddo'oo hin te'a. Meessaan lafa isaa Sidoon hin te'a. ");
INSERT INTO gax_vpl VALUES ("GN49_14","002_49_14","GEN","49","14","14","«Yisaakor akka harree jadduu, wodhakkaa fe'iisaa ciittuu ti. ");
INSERT INTO gax_vpl VALUES ("GN49_15","002_49_15","GEN","49","15","15","Ammoo addeen isaa ta fooraa dansaa, latti isaalle attam akka gammachiittu yennaa dhagge, fe'amiisaaf dudda ifii cillaaffatee garba te'a. ");
INSERT INTO gax_vpl VALUES ("GN49_16","002_49_16","GEN","49","16","16","«Daan kolbaa ifii gosa Israa'elii keessaa takkattii hin bulcha. ");
INSERT INTO gax_vpl VALUES ("GN49_17","002_49_17","GEN","49","17","17","Daan akka dhudhuufaa karaa irgaa, akka buutii daandii cina'aa, ta kottee fardaa idditee nama irra tee'eeru irraa buuttuu ti. ");
INSERT INTO gax_vpl VALUES ("GN49_18","002_49_18","GEN","49","18","18","«Ee Mootii Waan Maraa, ani fayyisiisa keeti eegadha. ");
INSERT INTO gax_vpl VALUES ("GN49_19","002_49_19","GEN","49","19","19","«Saantuun Gaad hin miiti; inni ammoo deebisee isaan hin miidha. ");
INSERT INTO gax_vpl VALUES ("GN49_20","002_49_20","GEN","49","20","20","«Latti Asheerii sagalee dansaa bacaa kenniti. Inni sagalee mootichaaf teetu hin kenna. ");
INSERT INTO gax_vpl VALUES ("GN49_21","002_49_21","GEN","49","21","21","«Naftaalem akka ilmee dansaa gadansaa bilisa; inni jechoota dadansaa dubbata. ");
INSERT INTO gax_vpl VALUES ("GN49_22","002_49_22","GEN","49","22","22","«Yoseef akka muka woyni'ii midhaanicha, madda bira jiru, ka dameen dalleya irra baatuu ti. ");
INSERT INTO gax_vpl VALUES ("GN49_23","002_49_23","GEN","49","23","23","Worri daaya qabatu isa duchiisanee, diinumma'aan daaya itti gad lakkisan. ");
INSERT INTO gax_vpl VALUES ("GN49_24","002_49_24","GEN","49","24","24","Ammoo hunna Waaqa Yaaqoobiitiin, maqaa tissee jabaa Israa'eliitiin, guubeen isaatii fi irreen isaa hin jabaatti. ");
INSERT INTO gax_vpl VALUES ("GN49_25","002_49_25","GEN","49","25","25","Waaqi abbaa keetii ka si qarqaaru, Waaqi waan mara dande'u, rooba gubba'aatiin, madda golbaatiin, horii heddu'uu fi ijoollee hedduu kenniisaan si eebbisu. ");
INSERT INTO gax_vpl VALUES ("GN49_26","002_49_26","GEN","49","26","26","Eebbi abbaa keetii waan eebba gaarota bara duriitii jalqabanee jiranuu fi kooba bara baraa irraa dhagganu caala. Eebbi kun marti mataa Yoseefii, ka obboleeyyan ifii irraa adda baye surrii isaa irratti bu'uu ti. ");
INSERT INTO gax_vpl VALUES ("GN49_27","002_49_27","GEN","49","27","27","«Beniyaamin akka yayyii beelottee ti; ganamaan waan adanse nyaata; galgala waan booji'e qoqooda» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN49_28","002_49_28","GEN","49","28","28","Gosi Israa'elii kudhanii lama isaan kana. Abbaan isaanii eebba isaaniif te'uun tokko tokkoo isaanii yennaa isaan eebbise, wonni isaaniin jedhe tana. ");
INSERT INTO gax_vpl VALUES ("GN49_29","002_49_29","GEN","49","29","29","Achiin duuba Yaaqoob, isaan gorsee, «Ani du'uu geyeera; isin abbootii tiyya woliin goda fichaa Efronii namicha biyya Heetii keessatti na awwaala'a. ");
INSERT INTO gax_vpl VALUES ("GN49_30","002_49_30","GEN","49","30","30","Godi sun lafa Kana'aanii keessa, Mamree irraa gara aduun baatu, fichaa Makfela'aa keessa jirti; Abrahaam fichaa godi awwaalaa tun keessa jirtu, addee awwaalaatiif Efronii heeticha irraa bitate. ");
INSERT INTO gax_vpl VALUES ("GN49_31","002_49_31","GEN","49","31","31","Abrahaamii fi niitii isaa Saaraa achitti awwaalane; Yisihaqii fi niitii isaa Ribqaa achitti awwaalane; anille Liyaa achitti awwaale. ");
INSERT INTO gax_vpl VALUES ("GN49_32","002_49_32","GEN","49","32","32","Fichaan sunii fi godi fichaa san keessaa sun namoota biyya Heetii irraa bitamane» isaaniin jedhe. ");
INSERT INTO gax_vpl VALUES ("GN49_33","002_49_33","GEN","49","33","33","Yaaqoob ilmaan ifiititti gorsee yennaa fixe, miila ifii taqee irratti ol deebifatee, du'ee, gara kolbaa ifii ta addee dhuga'aa jirtuu gale. ");
INSERT INTO gax_vpl VALUES ("GN50_1","002_50_1","GEN","50","1","1","Yennaa Yaaqoob du'e, Yoseef fuula abbaa ifii irratti jigee itti bowee sunqate. ");
INSERT INTO gax_vpl VALUES ("GN50_2","002_50_2","GEN","50","2","2","Achiin duuba Yoseef tajaajiltoota ifii ogeeyyii qorsaa, akka reeffa abbaa isaa qorsaan sukkuumanee gossanu ajaje. Maarre ogeeyyiin qorsaalle akkuma Yoseef ajaje godhane. ");
INSERT INTO gax_vpl VALUES ("GN50_3","002_50_3","GEN","50","3","3","Reeffa qorsaan sukkuumanee gossuun, guyyaa afurtama waan fudhatuuf, isaan guyyaa afurtamatti hobbaasane. Worri Gibxi'iille guyyaa torbaatama isaaf bowe. ");
INSERT INTO gax_vpl VALUES ("GN50_4","002_50_4","GEN","50","4","4","Isaan yennaa nageeffatane, Yoseef qondaaltota mootichaatiin, «Ani yoo isin duratti fudhatama dhaggadhe, maganne'ee mootichaan, ");
INSERT INTO gax_vpl VALUES ("GN50_5","002_50_5","GEN","50","5","5","‹Abbaan kiyya yennaa du'a geyeeru, addee awwaalaa ta inni ifiif qopheeffate, lafa Kana'aanii keessatti akka ani isa awwaalu na kakachiiseera; tanaaf maganne'ee, dhaqee abbaa kiyya awwaaladhee deebi'a› jedha'aatii naaf hima'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN50_6","002_50_6","GEN","50","6","6","Mootichi deebisee, «Akkuma inni si Kakachiise, dhaqiitii abbaa keeti awwaali» jedheen. ");
INSERT INTO gax_vpl VALUES ("GN50_7","002_50_7","GEN","50","7","7","Maarre Yoseef abbaa ifii awwaaliisaaf dhaqe. Qondaaltoti mootichaa marti, jaarsoleen mana mootummaa isa keessa jiranuu fi jaarsoleen lafa Gibxi'ii marti Yoseef woliin dhaqane. ");
INSERT INTO gax_vpl VALUES ("GN50_8","002_50_8","GEN","50","8","8","Akkasuma maatiin Yoseefii, obboleeyyan isaatii fi maatiin abbaa isaa duudiin isa woliin dhaqane. Ijoollee didiqqoo, re'ee, hoole'ee fi loon isaanii qofatti lafa Gooshenii keessatti hafe. ");
INSERT INTO gax_vpl VALUES ("GN50_9","002_50_9","GEN","50","9","9","Worri garreettaa fardaatii fi abbootiin fardaalle isa woliin dhaqane. Gobbuun sun akka malee guddo'o. ");
INSERT INTO gax_vpl VALUES ("GN50_10","002_50_10","GEN","50","10","10","Isaan laga Yordaanosiitiin gama eeddummee Axaadii bira yennaa geyane, abbaa ifiitiif wiiccifatanee bowane; Yoseef achitti guyyaa torba abbaa ifiitiif boochise. ");
INSERT INTO gax_vpl VALUES ("GN50_11","002_50_11","GEN","50","11","11","Worri lafa Kana'aanii keessa le'anu bowicha namoota eeddummee Axaadii biraa dhagganee, «Worri Gibxi'ii bowiisa guddaa bowiisatti jiran!» jedhanee, maqaa addee sanii, «Abeel-Miizraayim» jedhanee baasane; hiikkaan afaan Ibrootaatiin, «Bowa worra Gibxi'ii» jechu'u. Addeen sun laga Yordaanosiitiin gamatti dhagganti. ");
INSERT INTO gax_vpl VALUES ("GN50_12","002_50_12","GEN","50","12","12","Maarre ilmaan Yaaqoobii akkuma inni isaan ajaje godhane; ");
INSERT INTO gax_vpl VALUES ("GN50_13","002_50_13","GEN","50","13","13","ilmaan isaa reeffa isaa lafa Kana'aaniititti geessanee, goda awwaalaa ta fichaa Makfela'aa keessatti, ta Mamree irraa gara aduun baatu jirtutti awwaalane. Goda awwaalaa tana Abrahaam addee awwaalaa akka teetuuf Efronii namicha biyya Heetii irraa bitate. ");
INSERT INTO gax_vpl VALUES ("GN50_14","002_50_14","GEN","50","14","14","Yoseef abbaa ifii awwaaleen duuba, obboleeyyan isaatii fi worra abbaa isaa awwaaliisaaf isa woliin deemaneeranu mara woliin gara biyya Gibxi'ii deebi'e. ");
INSERT INTO gax_vpl VALUES ("GN50_15","002_50_15","GEN","50","15","15","Yaaqoob du'een duuba, Obboleeyyan Yoseefii, «Yoseef haluu qabatee, waan hantuu nuuti isa irratti hunye maraaf haluu nu bayinaa?» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN50_16","002_50_16","GEN","50","16","16","Maarre isaan ergaa gara Yoseefii erganee, «Abbaan keeti adoo hin du'in dura nu ajajee, ");
INSERT INTO gax_vpl VALUES ("GN50_17","002_50_17","GEN","50","17","17","‹Yakkaa obboleeyyan teetiitii fi balleessaa isaan hujanee si miidhane, isaaniif lakkis› jennee akka sitti hinnu nutti himeera; tanaaf amma nu tajaajiltooti Waaqa abbaa keetii yakkaa nuuti si yakkine mara maganne'ee nuu lakkis!» jedhane. Yoseef yennaa ergaa tana dhage'e bowe. ");
INSERT INTO gax_vpl VALUES ("GN50_18","002_50_18","GEN","50","18","18","Achiin duuba obboleeyyan isaalle dhufanee, isa duratti jiganee, «Nuuti garboota teeti» jedhane. ");
INSERT INTO gax_vpl VALUES ("GN50_19","002_50_19","GEN","50","19","19","Yoseef ammoo, «Hin sodaatina'a! Ani bakka Waaqaa hin bu'u. ");
INSERT INTO gax_vpl VALUES ("GN50_20","002_50_20","GEN","50","20","20","Isin hantuu na godhiisaaf mala dhoottane; Waaqi ammoo gara waan dansa'aa jijjiire; inni lubbuu namoota heddu'uu ka ammaa fayyisiisaaf tana godhe. ");
INSERT INTO gax_vpl VALUES ("GN50_21","002_50_21","GEN","50","21","21","Maarre hin sodaatina'a. Ani isinii fi ijoollee teessaniif waan barbaachisu hin kenna» jedhe. Yoseef gadhi-laafinnaan obboleeyyan ifiititti dubbatee isaan jajjabeesse. ");
INSERT INTO gax_vpl VALUES ("GN50_22","002_50_22","GEN","50","22","22","Yoseefii fi maatiin abbaa isaa biyya Gibxi'ii keessa turane. Yoseef woggaa dhibbaa fi kudhan le'ee du'e. ");
INSERT INTO gax_vpl VALUES ("GN50_23","002_50_23","GEN","50","23","23","Yoseef ijoollee Efreemiitii fi ijoollee ijoollee Efreemii dhagge. Akkasuma ijoollee Maakiirii ilma Minaase'eelle akka ijoollee ifiititti laakkowate. ");
INSERT INTO gax_vpl VALUES ("GN50_24","002_50_24","GEN","50","24","24","Achiin duuba Yoseef, obboleeyyan ifiitiin, «Ani du'aara. Waaqi ammoo isin woliin hin jiraata. Inni lafa tana keessaa gara lafa Abrahaamiif, Yisihaqii fi Yaaqoobiif waadaa galetti isin hin deebisa» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN50_25","002_50_25","GEN","50","25","25","Maarre Yoseef ilmaan Yaaqoobiitiin, «Waaqi dhugumaan isin woliin hin jiraata; yennaa inni gara lafa sanii isin deebisu, lafee tiyya asii fuutanee akka deentanu naaf kakadha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("GN50_26","002_50_26","GEN","50","26","26","Yoseef woggaa dhibbaa fi kudhani tti du'e. Isaan reeffa isaa qorsaan sukkuumanee gossanee, biyya Gibxi'ii keessatti saanduqa keessa keyane.");
INSERT INTO gax_vpl VALUES ("EX1_1","003_1_1","EXO","1","1","1","Ilmaan Yaaqoobii ka «Israa'el» jedhamane, worri maatii ifii woliin gara biyya Gibxi'ii deemane maqaan isaanii asii gad jira: ");
INSERT INTO gax_vpl VALUES ("EX1_2","003_1_2","EXO","1","2","2","Ruuben, Shimi'oon, Lewwii, Yihudaa, ");
INSERT INTO gax_vpl VALUES ("EX1_3","003_1_3","EXO","1","3","3","Yisaakor, Zebuloon, Beniyaamin, ");
INSERT INTO gax_vpl VALUES ("EX1_4","003_1_4","EXO","1","4","4","Daan, Niftaalem, Gaadi fi Asheer fa'a. ");
INSERT INTO gax_vpl VALUES ("EX1_5","003_1_5","EXO","1","5","5","Laakkossi sanyii Yaaqoobii wolumatti torbaatama; ilmi isaa Yoseef isaaniin duraayyuu biyya Gibxi'ii keessa jira. ");
INSERT INTO gax_vpl VALUES ("EX1_6","003_1_6","EXO","1","6","6","Barri isaanii geennaan Yoseef, obboleeyyan isaatii fi dhalooti sun marti du'ane. ");
INSERT INTO gax_vpl VALUES ("EX1_7","003_1_7","EXO","1","7","7","Sanyiin Israa'elii ka achitti hafane ammoo horanee guddoo bacatanee, lafa Gibxi'ii guutane. ");
INSERT INTO gax_vpl VALUES ("EX1_8","003_1_8","EXO","1","8","8","Achiin duuba mootiin haarenni ka marroo Yoseefii hin beenne biyya Gibxi'ii irratti mootii te'e. ");
INSERT INTO gax_vpl VALUES ("EX1_9","003_1_9","EXO","1","9","9","Inni kolbaa ifiitiin, «Kunoo, Israa'elooti guddoo bacatanee nu caaliisatti jiran. ");
INSERT INTO gax_vpl VALUES ("EX1_10","003_1_10","EXO","1","10","10","Laakkossi isaanii akka hin bacanne, lolli yoo ka'e diina keenna woliin nu lolanee biyyaa akka hin baane godhiisaaf kowa'a mala itti dhoonna» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX1_11","003_1_11","EXO","1","11","11","Tanaaf worri Gibxi'ii kolbaa Israa'elii cunqursiisaaf, worra hujii hunnaa isaan hujisiisu itti filane. Israa'elooti qachaa woy itti kuufatanu Fiitoomii fi Raamses mooticha Fara'ooniif ijaarane. ");
INSERT INTO gax_vpl VALUES ("EX1_12","003_1_12","EXO","1","12","12","Te'uu malee akkuma worri Gibxi'ii irra caalaa Israa'eloota cunqursuun isaanille irra caalaa bacatanee lafa guutane; tanaaf, worri Gibxi'ii akka malee Israa'eloota sodaatane. ");
INSERT INTO gax_vpl VALUES ("EX1_13","003_1_13","EXO","1","13","13","Worri Gibxi'ii Israa'elootatti gadhaa jabaatanee akka garbaatitti hujii hunnaa hujisiifatane. ");
INSERT INTO gax_vpl VALUES ("EX1_14","003_1_14","EXO","1","14","14","Hujii jajjadduu faara loobiisaatii fi simintoo hujiisaatiin, hujii adda addaa ta fichaa keessaatiin, hujii hunnaa jajjadduu ifii mara gadhaa itti jabaatanee hujisiisanee jireenna itti hadheessane. ");
INSERT INTO gax_vpl VALUES ("EX1_15","003_1_15","EXO","1","15","15","Achiin duuba mootiin Gibxi'ii worra dubartoota Ibrootaa deeysiisanu, ka, «Siifraa fi Phuwaa» jedhamanuun, ");
INSERT INTO gax_vpl VALUES ("EX1_16","003_1_16","EXO","1","16","16","«Yennaa dubartoota Ibroota deeysiittanu annuun dhalatu dhiira yoo te'e yennuma san ijjeesa'a, durra yoo teete ammoo hin ijjeesina'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX1_17","003_1_17","EXO","1","17","17","Deeysiittooti sun ammoo Waaqa waan sodaataneef, akka mootiin Gibxi'ii isaan ajaje san hin goone; annoolee dhiiraalle hin ijjeenne. ");
INSERT INTO gax_vpl VALUES ("EX1_18","003_1_18","EXO","1","18","18","Maarre Mootiin Gibxi'ii deeysiittoota san waamee, «Maaf akkas gootane? Annoolee dhiiraa maaf ijjeesuu dhaddane?» jedhee gaafate. ");
INSERT INTO gax_vpl VALUES ("EX1_19","003_1_19","EXO","1","19","19","Isaanille deebisanee, «Dubartooti worra Ibrootaa akka dubartoota worra Gibxi'iitii moti; isaan jajjaba waan te'aneef, adoo deeysiittooti isaan bira hin geyin deyan» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX1_20","003_1_20","EXO","1","20","20","Maarre Waaqi deeysiittoota saniif waan dansaa godhe; kolbaan Israa'eliille irra caalaa bacatte. ");
INSERT INTO gax_vpl VALUES ("EX1_21","003_1_21","EXO","1","21","21","Worri deeysiittootaa sun Waaqa waan sodaataneef, tokko tokkoo isaaniitiif maatii kenne. ");
INSERT INTO gax_vpl VALUES ("EX1_22","003_1_22","EXO","1","22","22","Achiin duuba mootichi, «Ijoollee dhiiraa ta Ibrootaa ta dhalattu mara fuudha'aatii laga Nayiliititti gata'a, ijoollee durraa ta dhalattu ammoo hin gatina'a» jedhee kolbaa ifii mara ajaje. ");
INSERT INTO gax_vpl VALUES ("EX2_1","003_2_1","EXO","2","1","1","Bara san namichi sanyii Lewwi'ii tokko dubartii sanyii Lewwi'ii fuudhe; ");
INSERT INTO gax_vpl VALUES ("EX2_2","003_2_2","EXO","2","2","2","isiille ulfoottee ilma isaaf deette. Ilmi dhalate sun miidhagaa akka te'e yennaa dhaggite haga ji'a sadii isa dhossite. ");
INSERT INTO gax_vpl VALUES ("EX2_3","003_2_3","EXO","2","3","3","Haga san caalaa dhossuu yennaa dadhadde ammoo, saaxaraa allaaduu irraa hujame tokko fuutee, akka bisaan keessa hin seenne leyyaa lafa keessaa dhaggamuun duuchite; achiin duuba annuu san keessa irkittee allaaduu qarqara laga Nayilii odduu keette. ");
INSERT INTO gax_vpl VALUES ("EX2_4","003_2_4","EXO","2","4","4","Obboleettiin annuu sanii ammoo waan inni te'u ilaaliisaaf irraa fagaattee dhaabbatteertiiyyu. ");
INSERT INTO gax_vpl VALUES ("EX2_5","003_2_5","EXO","2","5","5","Achiin duuba intalti mooticha biyya Gibxi'ii dhiqatiisaaf gara laga Nayilii dhutte; yennaa san dubartooti isii tajaajiltu laga san qarqara deddeemiisatti jiraniiyyu. Isiille saaxaraa allaaduu odduu jiru dhaggitee, tajaajiltittii ifii ergitee akka saaxaraa san fiddu goote. ");
INSERT INTO gax_vpl VALUES ("EX2_6","003_2_6","EXO","2","6","6","Isiin yennaa saaxaraa san bante annuu keessatti dhaggite. Annuun waan bowiisatti jiruuf, isaaf gadditee, «Kun annuu Ibrootaa ti» jette. ");
INSERT INTO gax_vpl VALUES ("EX2_7","003_2_7","EXO","2","7","7","Achiin duuba obboleettiin isaa intala Mootichaatiin, «Annuu kana akka hoosittee si'iif guddittu dubartoota Ibrootaa keessaa takkattii dhaqee si'iif waamuu?» jette. ");
INSERT INTO gax_vpl VALUES ("EX2_8","003_2_8","EXO","2","8","8","Isiille, «Ee! Dhaqii waami!» jetteen. Maarre intaltille dhaxxee haadhuma annu'uu fidde. ");
INSERT INTO gax_vpl VALUES ("EX2_9","003_2_9","EXO","2","9","9","Intalti mootichaalle isi'iin, «Annuu kana fuudhiitii hoosisii naaf guddisi; anille si'iif hin kaffala» jette. Maarre isiille annuu san fuutee hoosittee gudditte. ");
INSERT INTO gax_vpl VALUES ("EX2_10","003_2_10","EXO","2","10","10","Mucaan sun yennaa guddate, isiin gara intala mootichaa isa geessite; innille isi'iif ilma te'e. Isiille bisaan keessaa waan isa baacheef, maqaa isaa «Muusee» jette. ");
INSERT INTO gax_vpl VALUES ("EX2_11","003_2_11","EXO","2","11","11","Muuseen guddateen duuba guyyaa tokko addee kolbaan isaa jirtu dhaqee hujii hunnaa jajjadduu hujanuun dhagge. Nami Gibxi'ii tokko kolbaa Muuse'ee keessaa Ibraawicha tokko dhaanuun dhagge. ");
INSERT INTO gax_vpl VALUES ("EX2_12","003_2_12","EXO","2","12","12","Inni asii fi achi ilaalee nami isa dhaggu tokkolle akka hin jirre hubateen duuba, nama Gibxi'ii san ijjeesee reeffa isaa maansa jala dhosse. ");
INSERT INTO gax_vpl VALUES ("EX2_13","003_2_13","EXO","2","13","13","Guyyaa itti aanulle bayee Ibrooti lama wol loltuun dhagge. Nama balleessaa qabuun «Ati maaf nama Ibraawicha gosa keetii dhaanta?» jedhee gaafate. ");
INSERT INTO gax_vpl VALUES ("EX2_14","003_2_14","EXO","2","14","14","Namichille deebisee «Nu irratti bulcha'aa fi abbaa mura'aa ka si godhe eennu? Akkuma nama Gibxi'ii san ijjeette analle ijjeesiisaaf yaaddee ree?» jedhe. Achiin duuba Muuseen sodaatee «Wonni ani tolche beekkameera» jedhee yaade. ");
INSERT INTO gax_vpl VALUES ("EX2_15","003_2_15","EXO","2","15","15","Mootichi yennaa waan kana dhage'e, Muusee ijjeesiisaaf barbaade; Muuseen ammoo isa duraa baqatee gara lafa Miidiya'aa deemee boolla bisaanii takka bira le'e. ");
INSERT INTO gax_vpl VALUES ("EX2_16","003_2_16","EXO","2","16","16","Hayyichi Miidiyaanii tokko ijoollee durraa torba qabaayyu; isaan gara boolla bisaanii san dhufanee hoolee abbaa ifii bisaan obaasiisaaf bisaan woraabanee goongaa guutane. ");
INSERT INTO gax_vpl VALUES ("EX2_17","003_2_17","EXO","2","17","17","Tissitooti dhibiin dhufanee isaan ari'ane; Muuseen ammoo ka'ee durra saniif rogee hoolee isaanii bisaan obaase. ");
INSERT INTO gax_vpl VALUES ("EX2_18","003_2_18","EXO","2","18","18","Isaan yennaa gara abbaa ifii Rewu'elii deebi'ane, inni, «Isin adha maaf haganattuu ariifattanee deebitane?» jedhee gaafate. ");
INSERT INTO gax_vpl VALUES ("EX2_19","003_2_19","EXO","2","19","19","Isaanille deebisanee, «Nami Gibxi'ii tokko tissitooti nu ariinaan nu'uuf rogee, bisaanille nuu woraabee hoolee teenna nu'uuf obaase» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX2_20","003_2_20","EXO","2","20","20","Innille durra ifiitiin «Meet inni? Isin maaf isa lakkittanee dhuttane? Akka inni nu woliin sagalee nyaatu, dhaqa'aatii waama'a!» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX2_21","003_2_21","EXO","2","21","21","Maarre Muuseen namicha san woliin le'iisaaf jaalate; namichi sunille intala ifii Siiforaa akka niitii isaaf teetu Muuse'eef kenne. ");
INSERT INTO gax_vpl VALUES ("EX2_22","003_2_22","EXO","2","22","22","Isiin ilma isaaf deette; Muuseelle, «Ani lafa ormaatitti galeera» jedhee, maqaa isaa Gershoom baase. Gershoom jechuun «Galtuu» jechu'u. ");
INSERT INTO gax_vpl VALUES ("EX2_23","003_2_23","EXO","2","23","23","Bara heddu'uun duuba mootichi biyya Gibxi'ii du'e; Israa'elooti garbooma keessatti qarqaarsa dhaggatiisaaf iyyatane; iyyi isaan garbummaa jalaa bayiisaaf iyyane gara Waaqaa ol dhaxxe. ");
INSERT INTO gax_vpl VALUES ("EX2_24","003_2_24","EXO","2","24","24","Waaqille iyya isaanii dhage'ee, gondooroo ifii ta Abrahaam, Yisihaqii fi Yaaqoob woliin gondoore qaabate. ");
INSERT INTO gax_vpl VALUES ("EX2_25","003_2_25","EXO","2","25","25","Maarre Waaqi akka Israa'elooti garbummaa keessa jiranu dhaggee, isaaniif yaadate. ");
INSERT INTO gax_vpl VALUES ("EX3_1","003_3_1","EXO","3","1","1","Gaafa tokko Muuseen hoole'ee fi re'ee soddaa ifii ta Yetroo hayyicha Miidiyaanii adoo tissuu, gaafa tokko hoole'ee fi re'ee san goomolee keessa oofee gara gaara Horeebii ka, «Gaara Woyyicha» jedhamuu dhufe. ");
INSERT INTO gax_vpl VALUES ("EX3_2","003_3_2","EXO","3","2","2","Achitti ergamaan Waaqaa bobe'a ibiddaa ka tusee keessaa bobe'u keessaa itti mudhatte. Muuseen tuseen sun ibidda irra jiraattulle akka hin gubanne dhagge. ");
INSERT INTO gax_vpl VALUES ("EX3_3","003_3_3","EXO","3","3","3","Maarre Muuseen, «Tuseen tun maaf hin gubanne? Dhaqee baasa guddaa kana ilaala» jedhee herrege. ");
INSERT INTO gax_vpl VALUES ("EX3_4","003_3_4","EXO","3","4","4","Mootiin Waan Maraa Waaqi akka Muuseen ilaaliisaaf dhaqe yennaa dhagge, tusee keessaa, «Muuse'e! Muuse'e!» jedhee waame. Muuseelle, «Ani kunoo as jira!» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX3_5","003_3_5","EXO","3","5","5","Waaqille, «As hin dhikaatin! Addeen ati irra dhaabbatteertu lafa woyyittii waan teeteef, kophee teeti baafadhu» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX3_6","003_3_6","EXO","3","6","6","Achiin duuba, «Ani Waaqa abbootii teetii, Waaqa Abrahaamii, Waaqa Yisihaqii, Waaqa Yaaqoobii ti» jedhe. Maarre Muuseen Waaqa ilaaluu waan sodaateef, fuula ifii gollate. ");
INSERT INTO gax_vpl VALUES ("EX3_7","003_3_7","EXO","3","7","7","Achiin duuba Mootiin Waan Maraa, «Ani dhugumaan rakkinna kolbaa tiyya ta biyya Gibxi'ii keessaa dhaggeera; iyya isaan worra isaan garboonfatu jalaa bayiisaaf iyyanulle dhage'eera; farra isaaniille beekeera. ");
INSERT INTO gax_vpl VALUES ("EX3_8","003_3_8","EXO","3","8","8","Ani harka worra Gibxi'ii keessaa isaan baasee, gara lafa dansaa aananii fi dammaa gara lafa Kana'aanotaa, gara lafa Heetotaa, gara lafa Amoorotaa, gara lafa Pheriizotaa, gara lafa Hiiwotaatii fi Yibusootaa ol isaan fidiisaaf gad bu'eera. ");
INSERT INTO gax_vpl VALUES ("EX3_9","003_3_9","EXO","3","9","9","Amma kunoo, iyyi Israa'elootaa na bira geetteerti; worri Gibxi'ii akka isaan cunqursaarulle dhaggeera. ");
INSERT INTO gax_vpl VALUES ("EX3_10","003_3_10","EXO","3","10","10","Maarre amma deemi. Akka ati kolbaa tiyya Israa'el biyya Gibxi'ii keessaa baattuuf gara mooticha Gibxi'ii si erga» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX3_11","003_3_11","EXO","3","11","11","Muuseen ammoo Waaqaan, «Gara mootii Gibxi'ii dhaqee, kolbaa Israa'elii biyya Gibxi'iitii ka baasu ani eennu?» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX3_12","003_3_12","EXO","3","12","12","Waaqille deebisee, «Ani si woliin hin jiraadha. Kolbaa tiyya biyya Gibxi'iitii baattee yennaa fidde gaara kana irratti na hin waaqonfatta; kunille akka ani si erge beessisa si'iif hin te'a» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX3_13","003_3_13","EXO","3","13","13","Muuseelle Waaqaan, «Ani gara Israa'elootaa dhaqee, ‹Waaqi abbootii teessanii gara keessan na ergeera› isaaniin yoo jedhe, isaan ammoo, ‹Maqaan isaa eennu?› jedhanee yoo na gaafatane, ani maan isaanitti hima?» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX3_14","003_3_14","EXO","3","14","14","Waaqi Muuse'een, «Ani Waaqa jiraata'a; ati kolbaa Israa'eliitiin ‹Waaqi jiraataan gara keessan na ergeera› jetta» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX3_15","003_3_15","EXO","3","15","15","Waaqi ammalle Muuse'een, «Israa'elootaan, ‹Mootiin Waan Maraa, Waaqi abbootii teessanii, Waaqi Abrahaamii, Waaqi Yisihaqii, Waaqi Yaaqoobii gara keessan na ergeera› jedhi; kun maqaa kiyya ka bara baraa ti; dhalooti martinuu kanumaan na qaabatan. ");
INSERT INTO gax_vpl VALUES ("EX3_16","003_3_16","EXO","3","16","16","Dhaqii, jaarsolee Israa'elii wolitti qabiitii, ‹Mootiin Waan Maraa, Waaqi abbootii teessanii, Waaqi Abrahaamii, Waaqi Yisihaqii, Waaqi Yaaqoobii natti mudhatee: Ani biyya Gibxi'ii keessatti isin ilaalee waan isin godhane dhaggeera. ");
INSERT INTO gax_vpl VALUES ("EX3_17","003_3_17","EXO","3","17","17","Rakkinna keessan ka biyya Gibxi'ii jalaa isin baasee, gara lafa aananii fi dammaa, gara lafa Kana'aanotaa, gara lafa Heetotaa, gara lafa Amoorotaa, gara lafa Pheriizotaa, gara lafa Hiiwotaa, gara lafa Yibusootaa ol isin baasiisaaf waadaa isiniif galeera anaan jedhe› jedhii itti himi; ");
INSERT INTO gax_vpl VALUES ("EX3_18","003_3_18","EXO","3","18","18","«Jaarsoleen kolbaa Israa'eliille dubbii teeti hin dhage'an. Achiin duuba atii fi jaarsoleen sun gara mooticha Gibxi'ii dhaqa'aatii, ‹Mootiin Waan Maraa, Waaqi Ibrootaa, nu'utti mudhateera. Goomolee keessa karaa guyyaa sadii ideennee, Mootii Waan Maraa Waaqa keennaaf ciincaa akka dhikeessinu nu'uuf eeyyam› jedha'aan; ");
INSERT INTO gax_vpl VALUES ("EX3_19","003_3_19","EXO","3","19","19","Mootichi Gibxi'ii irree jaddu'uun malee akka inni gad isin hin lakkinne ani ammoo hin beeka. ");
INSERT INTO gax_vpl VALUES ("EX3_20","003_3_20","EXO","3","20","20","Maarre ani harka kiyya diriirsee bilbaasa odduu isaaniititti tolchu maraan, worra Gibxi'ii hin dhowa; achiin duuba inni akka isin ideentanu hin lakkisa. ");
INSERT INTO gax_vpl VALUES ("EX3_21","003_3_21","EXO","3","21","21","«Ani worri Gibxi'ii akka isin ulfeessanu waan godhuuf, yennaa achii baatanu harka duwwaa hin ideentanu. ");
INSERT INTO gax_vpl VALUES ("EX3_22","003_3_22","EXO","3","22","22","Dubartiin Israa'elootaa tokko tokkooyyuu ollaa ifiitii fi dubartii worra Gibxi'ii ta mana isi'ii leetu seesa meeti'iitii fi worqi'ii akkasuma woyaa akka kennituuf gaafattuu ti. Seesa kana ilmaanii fi durra teessanitti naxxanee, woyaalle itti hin uffittan; akka kanaan qabeenna worra Gibxi'ii guurattan» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_1","003_4_1","EXO","4","1","1","Achiin duuba Muuseen deebisee, «Israa'elooti, ‹Mootiin Waan Maraa si'itti hin mudhanne› jedhanee, yoo na dhugeeffatuu dhabane, dubbii tiyyalle yoo dhage'uu didane maan godha ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_2","003_4_2","EXO","4","2","2","Mootiin Waan Maraa Muuse'een, «Wonni ati harkatti qabatteertu sun maan?» jedheen. Innille, «Ule'e» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX4_3","003_4_3","EXO","4","3","3","Mootiin Waan Maraa deebisee, «Ulee san lafa buus!» jedheen; yennaa Muuseen ulee san lafa buuse, ulee sun bofa teete; Muuseelle irraa dheete. ");
INSERT INTO gax_vpl VALUES ("EX4_4","003_4_4","EXO","4","4","4","Achiin duuba Mootiin Waan Maraa Muuse'een, «Hiixadhuu harka keetiin eegee isaa qabi!» jedheen; maarre Muusee hiixatee bofa san qabe; bofi sunille deebi'ee ulee te'e. ");
INSERT INTO gax_vpl VALUES ("EX4_5","003_4_5","EXO","4","5","5","Mootiin Waan Maraa, «Kanaan ani Mootiin Waan Maraa, Waaqi abbootii isaanii, Waaqi Abrahaamii, Waaqi Yisihaqii, Waaqi Yaaqoobii akka si'itti mudhadhe hin dhugeeffatan» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX4_6","003_4_6","EXO","4","6","6","Ammalle Mootiin Waan Maraa Muuse'een, «Harka keeti bobaa teeti keessa keyadhu!» jedhe. Innille harka ifii bobaa ifii keessa keyate; yennaa inni harka bobaa keessaa fuudhu, harki isaa akka dhakaa bokkeyaa akka dhukkuba goga'aa farrisiisa'aa addaate. ");
INSERT INTO gax_vpl VALUES ("EX4_7","003_4_7","EXO","4","7","7","Achiin duuba Mootiin Waan Maraa, «Harka keeti bobaa teeti keessatti deebis!» jedheen. Muuseelle harka ifii bobaa ifii keessatti deebifate; yennaa inni achi keessaa baafatu, harki fayyee akka nafa isaa kaan fakkaate. ");
INSERT INTO gax_vpl VALUES ("EX4_8","003_4_8","EXO","4","8","8","Achiin duuba Mootiin Waan Maraa, «Isaan yoo si dhugeeffatuu dhabane yookiin bilbaasa qaraalle yoo fudhatuu dhabane, bilbaasa lammeesso'oo kana hin dhugeeffatan. ");
INSERT INTO gax_vpl VALUES ("EX4_9","003_4_9","EXO","4","9","9","Bilbaasa kana lamaanuu yoo dhugeeffatuu dhabane, dubbii teetille yoo caqasuu didane, bisaan laga Nayilii woraabiitii lafa godduu irratti dhangalaas; bisaan ati lagaa woraadde sun lafa godduu irratti dhiiga hin te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_10","003_4_10","EXO","4","10","10","Muuseen ammoo Mootii Waan Maraatiin, «Ee Goottaa kiyya, na hin ergin. Ani duruu nama gikkisu, arrab kiyyalle hin ulfaata; haga ati ana garbicha keeti woliin dubbii jalqadelle ani nama dandeettii dubbi'ii qabu ijjumaa hin teene» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_11","003_4_11","EXO","4","11","11","Achiin duuba Mootiin Waan Maraa, «Afaan namaa ka dade eennu? Ka afaan namaatii fi gurra namaa duudaa godhu eennu? Ka ila namaa akka dhaggitu godhu yookiin ballaa godhu eennu? Ana Mootii Waan Maraatii motii? ");
INSERT INTO gax_vpl VALUES ("EX4_12","003_4_12","EXO","4","12","12","Amma, deemi; ani akka ati dubbattuuf si hin qarqaara; waan ati jettulle si hin barsiisa» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_13","003_4_13","EXO","4","13","13","Muusee ammoo, «Ee, Gootta'a, maganne'e nama dhibii ergi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_14","003_4_14","EXO","4","14","14","Achiin duuba Mootiin Waan Maraa Muuse'etti aaree bobe'ee, «Obboleessi keeti Aaron sanyiin Lewwi'ii hin jiraa motii? Inni akka dansaa akka dubbatu ani hin beeka. Kunoo inni gara keeti dhufiisaaf ammaayyuu karaa irra jira; inni yennaa si dhagge gadhaan isaa hin gammada. ");
INSERT INTO gax_vpl VALUES ("EX4_15","003_4_15","EXO","4","15","15","Ati isatti hin dubbatta; waan inni dubbatulle itti akeetta. Akka dubbattanu isin lamaanuu ani hin qarqaara; waan tolchitanulle isin hin barsiisa. ");
INSERT INTO gax_vpl VALUES ("EX4_16","003_4_16","EXO","4","16","16","Inni addee teeti bu'ee kolba'atti hin dubbata. Achiin duuba ati akka ana Waaqaa teetee, waan inni dubbatu itti hin hinta. ");
INSERT INTO gax_vpl VALUES ("EX4_17","003_4_17","EXO","4","17","17","Ulee bilbaasa ittiin tolchitu tana harkatti qabadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_18","003_4_18","EXO","4","18","18","Achiin duuba Muuseen gara soddaa ifii gara Yetroo deebi'ee, «Gara fira kiyyaa ka Gibxii keessa jiranuu deebi'ee dhaqee, akka isaan haga ammaa lubbu'uun jiranu ilaala!» jedheen. Yetrolle Muuse'een «Nageyaan dhaqi!» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_19","003_4_19","EXO","4","19","19","Muuseen Miidiyaan keessa adoo jiruu, Mootiin Waan Maraa, «Worri ijjeesiisaaf si barbaade martinuu amma waan du'aneeranuuf, gara Gibxi'ii deebi'ii deemi» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX4_20","003_4_20","EXO","4","20","20","Maarre Muuseen niitii ifiitii fi ilmaan ifii mara harree irra teessisee, gara Gibxi'ii deebi'uu jalqabe; inni ulee Waaqaa sanille harkatti qabateeraayyu. ");
INSERT INTO gax_vpl VALUES ("EX4_21","003_4_21","EXO","4","21","21","Mootiin Waan Maraa Muuse'een, «Yennaa gara biyya Gibxi'ii deebite, bilbaasota ani akka ati hujjuuf hunna si'iif kenne mara fuula mooticha Gibxi'ii duratti akka mudhittu hin dedhin; ani ammoo akka inni akka ideentuuf kolbaa gad hin lakkinne, mataa isaa hin jabeessa. ");
INSERT INTO gax_vpl VALUES ("EX4_22","003_4_22","EXO","4","22","22","Achiin duuba ati mootichaan, ‹Mootiin Waan Maraa: Israa'el ilma kiyya angaficha; ");
INSERT INTO gax_vpl VALUES ("EX4_23","003_4_23","EXO","4","23","23","akka inni deemee dhaqee na waaqonfatuuf gad lakkisi si'iin jennaan, ati ammoo akka inni deemu gad lakkisuu didde. Maarre amma ani ilma keeti angaficha hin ijjeesa jedheera› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX4_24","003_4_24","EXO","4","24","24","Muuseen gara Gibxi'ii adoo deemuu, addee inni buleerutti Mootiin Waan Maraa itti dhufee, isa ijjeesiisaaf barbaade. ");
INSERT INTO gax_vpl VALUES ("EX4_25","003_4_25","EXO","4","25","25","Niitiin isaa Siiforaan ammoo dhakaa qara qabu fuutee, ilma ifii haqanqabaa qaddee, shoggoraa saniin miila Muuse'ee tuxxee, «Dhiiga dhangala'e kanaan, dhugumaan ati karaa fuudhaatiin fira kiyya» jetteen. ");
INSERT INTO gax_vpl VALUES ("EX4_26","003_4_26","EXO","4","26","26","Maarre Mootiin Waan Maraa Muusee lakkise; isiin sababa haqanqaba'aatiif, «Dhiiga dhangala'e kanaan, ati karaa fuudhaatiin fira kiyya» jetteen. ");
INSERT INTO gax_vpl VALUES ("EX4_27","003_4_27","EXO","4","27","27","Mootiin Waan Maraalle Aaroniin, «Muusee qophatiisaaf gara goomole'ee dhaqi» jedhe. Maarre inni gaara Waaqaa irratti isa qophatee sunqate. ");
INSERT INTO gax_vpl VALUES ("EX4_28","003_4_28","EXO","4","28","28","Achiin duuba Muuseen, dubbii Mootiin Waan Maraa akka inni dubbatuuf isa erge mara, bilbaasota akka inni tolchuuf isa ajaje mara Aaronitti hime. ");
INSERT INTO gax_vpl VALUES ("EX4_29","003_4_29","EXO","4","29","29","Maarre Muuse'ee fi Aaron deemanee jaarsolee sooreyyii Israa'elootaa mara wolitti qabane. ");
INSERT INTO gax_vpl VALUES ("EX4_30","003_4_30","EXO","4","30","30","Aaron waan Mootiin Waan Maraa Muuse'etti hime mara isaanitti hime; Muuseelle fuula kolba'aa duratti bilbaasota huje. ");
INSERT INTO gax_vpl VALUES ("EX4_31","003_4_31","EXO","4","31","31","Isaanille dhugeeffatane; Mootiin Waan Maraa akka Israa'elooti garbummaa keessa jiranu dhaggee, isaaniif akka yaadate, yennaa dhage'ane, jilbiiffatanee sagadane. ");
INSERT INTO gax_vpl VALUES ("EX5_1","003_5_1","EXO","5","1","1","Achiin duuba Muuse'ee fi Aaron gara mootii Gibxi'ii dhaqanee, «Mootiin Waan Maraa, Waaqi Israa'elii, ‹Kolbaa tiyya goomolee keessatti jila akka naaf jilisanu gad isaan lakkisi› jedheera» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("EX5_2","003_5_2","EXO","5","2","2","Mootichi Gibxi'ii deebisee, «Mootiin Waan Maraa ka ani isaaf ajajamee, Israa'eloota akka deemanu gad lakkisu kun eennu inni? Ani Mootii Waan Maraa san hin beeku; Israa'elootalle akka deemanu gad hin lakkisu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX5_3","003_5_3","EXO","5","3","3","Muuse'ee fi Aaronille deebisanee, «Waaqi Ibrootaa nu'utti mudhateera; karaa guyyaa sadii goomolee keessa ideennee, Mootii Waan Maraa Waaqa keennaaf ciincaa akka dhikeessinu nu'uuf eeyyami. Nuuti yoo kana hin tolchin inni balaa yookiin woraana nu'utti hin fida» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("EX5_4","003_5_4","EXO","5","4","4","Mootichi Gibxi'ii ammoo, «Muuse'ee fi Aaroniin! Isin maaf kolbaa hujii dhooggitan? Gara hujii teessanii deebi'a'a! ");
INSERT INTO gax_vpl VALUES ("EX5_5","003_5_5","EXO","5","5","5","Kunoo, kolbaan lafa tanaa bacatteerti; isin akka isaan hujii lakkisanu godhiisatti jirtan» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX5_6","003_5_6","EXO","5","6","6","Guyyuma san Mootichi Gibxi'ii worra hunnaan isaan hojjachiisuu fi worra Israa'eloota hojjatoota toowatanu ajajee, ");
INSERT INTO gax_vpl VALUES ("EX5_7","003_5_7","EXO","5","7","7","«Akka qara tolchaa turtane, hicaacee dhoqqe'een loobanu haganaa achi kolba'aaf hin dhikeessina'a! Isaanuu ifumaaf barbaadanee fidatanuu ti! ");
INSERT INTO gax_vpl VALUES ("EX5_8","003_5_8","EXO","5","8","8","Laakkossa loobaa faara ijaarsaalle haga qara hujjanu hin dhidhisina'a; haguma qara itti murteeffame san akka fidanu godha'a. Isaan booseya; tanaaf, ‹Dhandhee ciincaa Waaqa keennaaf dhikeessina› jedhaa natti iyyan. ");
INSERT INTO gax_vpl VALUES ("EX5_9","003_5_9","EXO","5","9","9","Isaan oduu dharaa akka hin caqanne, huji'iin akka qabamanuuf, hujii ulfaattuu akka isaan hujanu tolcha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX5_10","003_5_10","EXO","5","10","10","Worri hunnaan isaan hojjachiisuu fi worri Israa'eloota hojjattoota toowatanu dhaqanee kolbaa Israa'eliitiin, «Mootichi, ‹Ani haganaa achi hicaacee isiniif hin kennu. ");
INSERT INTO gax_vpl VALUES ("EX5_11","003_5_11","EXO","5","11","11","Isinuu ifumaaf addee itti dhaggitanee barbaadadha'aatii fudhadha'a; hujiin teessan ammoo haga qaraa irraa hin dhidhatin› jedheera» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX5_12","003_5_12","EXO","5","12","12","Maarre kolbaan hicaacee barbaadiisaaf lafa Gibxi'ii mara keessa bittinnootte. ");
INSERT INTO gax_vpl VALUES ("EX5_13","003_5_13","EXO","5","13","13","Worri hunnaan isaan hojjachiisanu ammoo, «Akkuma qara yennaa hicaaceen isiniif kennamu hojjattanu, hujii guyyuma guyya'aan akka hujjanu murteeffame san hobbaasa'a» jedhaa dhiibbaa itti jabeessane. ");
INSERT INTO gax_vpl VALUES ("EX5_14","003_5_14","EXO","5","14","14","Worri hunnaan isaan hojjachiisanu, toowattoota hojjatoota Israa'eliitiin, «Laakkossa loobaa faara ijaarsaa ka kale'eetii fi ka adhaa akkuma qara akka hujanuuf murteeffame maaf hujuu dhaddane?» jedhaa dikaa gaafatane. ");
INSERT INTO gax_vpl VALUES ("EX5_15","003_5_15","EXO","5","15","15","Achiin duuba toowattooti hojjattoota Israa'elii gara mooticha Gibxi'ii dhaqanee, «Ati maaf nu worra tajaajiltoota teetii akkana goota? ");
INSERT INTO gax_vpl VALUES ("EX5_16","003_5_16","EXO","5","16","16","Nu worra tajaajiltoota teetiitiif hicaaceen hin kennanne, te'uu malee ‹Loobaa faara ijaarsaa huja'a› nu'uun jedhan; nuuti tajaajiltooti teeti dikamiisatti jirra; balleessaan ammoo ta kolbaa teetii ti» jedhanee iyyatane. ");
INSERT INTO gax_vpl VALUES ("EX5_17","003_5_17","EXO","5","17","17","Mootichi Gibxi'iille deebisee, «Isin booseya; hujii hujiisa hin jaalattanu! Tanaaf, ‹Dhandhee ciincaa Mootii Waan Maraatiif dhikeessina› jettan; ");
INSERT INTO gax_vpl VALUES ("EX5_18","003_5_18","EXO","5","18","18","amma huji'itti deebi'a'a! Hicaaceen tokkolle isiniif hin kennamu; te'uu malee laakkossa loobaa faara ijaarsaa akkuma qara akka hujanuuf murteeffame san guutuu huja'a» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX5_19","003_5_19","EXO","5","19","19","Toowattooti hojjatoota Israa'elii, laakkossi loobaa faara ijaarsaa akka isaan guyyuma guyya'aan hujanuuf murteeffame akka hin dhidhanne yennaa itti himame rakkoon guddoon akka isaa dhaqqadde beekane. ");
INSERT INTO gax_vpl VALUES ("EX5_20","003_5_20","EXO","5","20","20","Isaan mooticha biraa yennaa bayane, worra isaan eegaa ture Muuse'ee fi Aaron dhaggane. ");
INSERT INTO gax_vpl VALUES ("EX5_21","003_5_21","EXO","5","21","21","Isaan Muuse'ee fi Aaroniin, «Mootichi fi qondaaltoti isaa akka nu xireeffatanu gootanee, shallaagaa ittiin nu ijjeesanu harka isaanii keessa waan keettaneef, Mootiin Waan Maraa ilaalee, isinitti muruu ti!» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX5_22","003_5_22","EXO","5","22","22","Muuseen gara Mootii Waan Maraa deebi'ee, «Ee Mootii Waan Maraa kolbaa tana irratti rakkoo tana maaf fidde? Tanaaf as na ergitee? ");
INSERT INTO gax_vpl VALUES ("EX5_23","003_5_23","EXO","5","23","23","Haga ani maqaa keetiin dubbatiisaaf mooticha bira dhaqeen jalqabee, inni kolbaa tana rakkisiisatti jira; ati ammoo kolbaa teeti qarqaariisaaf waan tokkolle hin goone!» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX6_1","003_6_1","EXO","6","1","1","Achiin duuba Mootiin Waan Maraa Muuse'een, «Waan ani mooticha Gibxi'ii godhu ati amma hin dhaggita. Ani irree tiyya jaddu'uun akka inni kolbaan tiyya gad lakkisu hin tolcha. Dhugumaan, ani irree tiyya jaddu'uun akka inni biyya ifii keessaa isaan oofu isa hin tolcha» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX6_2","003_6_2","EXO","6","2","2","Waaqi Muuse'een, «Ani Mootii Waan Maraa ti; ");
INSERT INTO gax_vpl VALUES ("EX6_3","003_6_3","EXO","6","3","3","ani Mootiin Waan Maraa Ka Waan Mara Dande'u Abrahaamitti, Yisihaqii fi Yaaqoobitti mudhadheera. Ammoo maqaa kiyya ‹Mootii Waan Maraa ti› jedhee isaanitti ifi hin beessinne. ");
INSERT INTO gax_vpl VALUES ("EX6_4","003_6_4","EXO","6","4","4","Biyya Kana'aanii, ta isaan alagaa te'anee keessa le'ane, isaanii kenniisaaf gondooroo tiyya isaan woliin godheera. ");
INSERT INTO gax_vpl VALUES ("EX6_5","003_6_5","EXO","6","5","5","Amma aaduu Israa'elootaa ta worri Gibxi'ii waan isaan garboonfateef aadanu dhage'ee, ani gondooroo tiyya qaabadheera. ");
INSERT INTO gax_vpl VALUES ("EX6_6","003_6_6","EXO","6","6","6","«Tanaaf ati Israa'elootaan, ‹Mootiin Waan Maraa: Ani Mootii Waan Maraa ti; ani garbummaa Gibxi'ii jalaa isin baasee isin hin bilisoonsa. Irree tiyya ol kaasee, adabbii gugurdoo isaanitti fidee, isin hin woda ");
INSERT INTO gax_vpl VALUES ("EX6_7","003_6_7","EXO","6","7","7","Ani kolbaa tiyya isin tolfadhee, Waaqa keessan isiniif hin te'a. Yennaa ani garbummaa Gibxi'ii jalaa isin bilisa baase ani Mootii Waan Maraa Waaqa keessan akka te'e hin beettan. ");
INSERT INTO gax_vpl VALUES ("EX6_8","003_6_8","EXO","6","8","8","Lafa Abrahaamiif, Yisihaqii fi Yaaqoobiif kenniisaaf waadaa gale sanitti akka isin galtanu godhee, isiniif hin kenna. Ani Mootii Waan Maraa ti jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX6_9","003_6_9","EXO","6","9","9","Muuseelle waan kana Israa'elootatti hime; garbummaan hantuun addii waan isaan kutachiitteef, isaan ammoo isa hin caqanne. ");
INSERT INTO gax_vpl VALUES ("EX6_10","003_6_10","EXO","6","10","10","Achiin duuba Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX6_11","003_6_11","EXO","6","11","11","«Gara mooticha Gibxi'ii dhaqiitii, Israa'elooti lafa isaa keessaa akka bayanu akka inni isaan gad lakkisu itti himi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX6_12","003_6_12","EXO","6","12","12","Muuseen ammoo deebisee, «Kunoo, Israa'elootinuu na hin dhageenne; mootichi fa'a ana nama akka dansaa dubbatiisa hin beenne attam dhage'uu dande'a ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX6_13","003_6_13","EXO","6","13","13","Mootiin Waan Maraa Muuse'ee fi Aaronitti dubbatee, Israa'eloota biyya Gibxi'ii keessaa baasiisaaf, dhaqanee Israa'eloota fi mooticha Gibxi'iititti akka himanu isaan ajaje. ");
INSERT INTO gax_vpl VALUES ("EX6_14","003_6_14","EXO","6","14","14","Ilmi angafichi Yaaqoobii Ruuben, ilmaan afur: Heenoki, Faluu, Hezronii fi Karmii qaba. Isaan abbootii sanyii Ruubenii ti. ");
INSERT INTO gax_vpl VALUES ("EX6_15","003_6_15","EXO","6","15","15","Shimi'oon ilmaan jaa: Yimu'el, Yaamiin, Ohad, Yaakiin, Zohaar, Shaawul ta dubartiin Kana'aanotaa deette qaba. Isaan abbootii sanyii Shimi'oonii ti. ");
INSERT INTO gax_vpl VALUES ("EX6_16","003_6_16","EXO","6","16","16","Lewwiin ilmaan sad: Gershoon, Qehaatii fi Meraari qaba. Isaan abbootii sanyii Lewwootaa ti. Lewwiin woggaa dhibbaa fi soddomii torba le'e. ");
INSERT INTO gax_vpl VALUES ("EX6_17","003_6_17","EXO","6","17","17","Gershoon ilmaa lama: Liibnii fi Shime'i qaba. ");
INSERT INTO gax_vpl VALUES ("EX6_18","003_6_18","EXO","6","18","18","Qehaat ilmaan afur: Amraam, Yizhaar, Hebroon fi Uzii'el qaba. Qehaat woggaa dhibbaa fi soddomii sad le'e. ");
INSERT INTO gax_vpl VALUES ("EX6_19","003_6_19","EXO","6","19","19","Meraar ilmaa lama: Maahilii fi Mushi qaba. Isaan abbootii sanyii fira Lewwi'ii ti. ");
INSERT INTO gax_vpl VALUES ("EX6_20","003_6_20","EXO","6","20","20","Amraam obboleettii abbaa ifii Yokebeed fuudhe. Isiin Aaron fi Muusee isaaf deette. Amraam woggaa dhibbaa fi soddomii torba le'e. ");
INSERT INTO gax_vpl VALUES ("EX6_21","003_6_21","EXO","6","21","21","Yizhaar ilmaa sad: Qoraahi, Nefegii fi Ziikri qaba. ");
INSERT INTO gax_vpl VALUES ("EX6_22","003_6_22","EXO","6","22","22","Uzii'el ilmaa sad: Miishaa'el, Elzaafaanii fi Siitri qaba. ");
INSERT INTO gax_vpl VALUES ("EX6_23","003_6_23","EXO","6","23","23","Aaron intala Aminaadaabii, obboleettii Nahasoonii Elishebaa fuudhe. Isiille Naadaab, Abiihuu, Ele'azaarii fi Itaamaar deetteef. ");
INSERT INTO gax_vpl VALUES ("EX6_24","003_6_24","EXO","6","24","24","Qoraahi ilmaan sad: Asiir, Elqaana'aa fi Abii'aasaaf qaba. Isaan abbootii sanyii Qoraahii ti. ");
INSERT INTO gax_vpl VALUES ("EX6_25","003_6_25","EXO","6","25","25","Ilmi Aaronii Ele'azaar, durra Futii'elii keessaa takkattii fuudhe; isiin Fiinehaas isaaf deette. Isaan kun sooreyyii abbootii sanyii Lewwi'ii ti. ");
INSERT INTO gax_vpl VALUES ("EX6_26","003_6_26","EXO","6","26","26","Muuse'ee fi Aaron worra Mootiin Waan Maraa, «Gosa Israa'elii akka fira fira isaaniititti biyya Gibxi'ii keessaa baasa'a!» jedhee itti dubbate. ");
INSERT INTO gax_vpl VALUES ("EX6_27","003_6_27","EXO","6","27","27","Akka inni Israa'eloota gad lakkisuuf mooticha Gibxi'iititti worri dubbate isaanuma kana. ");
INSERT INTO gax_vpl VALUES ("EX6_28","003_6_28","EXO","6","28","28","Mootiin Waan Maraa lafa Gibxi'ii keessatti Muuse'etti yennaa dubbate, ");
INSERT INTO gax_vpl VALUES ("EX6_29","003_6_29","EXO","6","29","29","«Ani Mootii Waan Maraa ti. Waan ani si'itti hime mara mooticha Gibxi'iititti himi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX6_30","003_6_30","EXO","6","30","30","Muuseen ammoo deebisee «Ani nama akka dansaa dubbatiisa hin dandeenne akka te'e atinuu hin beetta; mootichi attamiin dubbii tiyya dhage'uu dande'a ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX7_1","003_7_1","EXO","7","1","1","Mootiin Waan Maraa Muuse'een, «Kunoo, ani mooticha Gibxi'ii irratti akka Waaqaa si godheera; obboleessi keeti Aaron ammoo akka raagichaa te'ee addee teeti hin dubbata. ");
INSERT INTO gax_vpl VALUES ("EX7_2","003_7_2","EXO","7","2","2","Ati waan ani si ajaje mara hin dubbatta; obboleessi keeti Aaron akka Israa'elooti biyya isaa keessaa baatuuf akka inni isaan gad lakkisu mootichatti hin hima. ");
INSERT INTO gax_vpl VALUES ("EX7_3","003_7_3","EXO","7","3","3","Ani ammoo mooticha Gibxi'ii mataa hin jabeessa; bilbaasaa fi baasa hedduu biyya Gibxi'iititti tolchulle inni isin hin caqasu. ");
INSERT INTO gax_vpl VALUES ("EX7_4","003_7_4","EXO","7","4","4","Achiin duuba ani adabbii jadduu Gibxi'itti fidee, muraa guddo'oon gumii tiyya kolbaa tiyya Israa'eloota lafa Gibxi'ii keessaa hin baasa. ");
INSERT INTO gax_vpl VALUES ("EX7_5","003_7_5","EXO","7","5","5","Ani biyya Gibxi'ii adabee Israa'eloota achi keessaa yennaa baase, worri Gibxi'ii akka ani Mootii Waan Maraa te'e hin beekan» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX7_6","003_7_6","EXO","7","6","6","Muuse'ee fi Aaronille akkuma Mootiin Waan Maraa isaan ajaje godhane. ");
INSERT INTO gax_vpl VALUES ("EX7_7","003_7_7","EXO","7","7","7","Muuse'ee fi Aaron mootichatti yennaa dubbatanu, Muuseen nama woggaa saddeettamaa, Aaron ammoo nama woggaa saddeettamii sadii ti. ");
INSERT INTO gax_vpl VALUES ("EX7_8","003_7_8","EXO","7","8","8","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("EX7_9","003_7_9","EXO","7","9","9","«Mootichi ‹Bilbaasa huja'a› yoo jedhe, ati Aaroniin ‹Ulee teeti fuudhiitii mooticha dura buusi› jedhi; uleen sunille bofa hin teeti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX7_10","003_7_10","EXO","7","10","10","Maarre Muuse'ee fi Aaron gara mootichaa dhaqanee akkuma Mootiin Waan Maraa isaan ajaje godhane. Aaron ulee ifii mootichaa fi qondaaltota isaa dura buuse; ulee sunille bofa teete. ");
INSERT INTO gax_vpl VALUES ("EX7_11","003_7_11","EXO","7","11","11","Achiin duuba mootichi worra qaroole'ee fi worra xanoo xanu waame; isaanille ogummaa ifii ta dhossa'aatiin akkuma san godhane. ");
INSERT INTO gax_vpl VALUES ("EX7_12","003_7_12","EXO","7","12","12","Tokko tokkoon isaaniituu ulee ifii lafa buusane; uleen sunille bofa teete. Uleen Aaronii ammoo ulee isaanii liqinsite. ");
INSERT INTO gax_vpl VALUES ("EX7_13","003_7_13","EXO","7","13","13","Te'uu malee mootichi mataa jabaatee, akkuma Mootiin Waan Maraa dubbate Muuse'ee fi Aaron dhage'iisa didate. ");
INSERT INTO gax_vpl VALUES ("EX7_14","003_7_14","EXO","7","14","14","Achiin duuba Mootiin Waan Maraa Muuse'een, «Mootichi mataa jabaatee, kolbaan akka deentu gad lakkisuu dide. ");
INSERT INTO gax_vpl VALUES ("EX7_15","003_7_15","EXO","7","15","15","Tanaaf, yennaa inni gara laga Nayilii gad bu'u, ganamaan gara isaa dhaqi. Ulee teeti ta bofa teete san qabadhuutii isa dhaggiisaaf, laga qarqaratti isa eegi. ");
INSERT INTO gax_vpl VALUES ("EX7_16","003_7_16","EXO","7","16","16","Achiin duuba isaan, ‹Mootiin Waan Maraa Waaqi Ibrootaa sitti na ergee: Kolbaan tiyya dhaxxee goomolee keessatti akka na waaqonfattu gad lakkisi! Si'iin jedheera. Ati ammoo haga ammaa dhage'uu didde. ");
INSERT INTO gax_vpl VALUES ("EX7_17","003_7_17","EXO","7","17","17","Amma Mootiin Waan Maraa: Akka ani Mootii Waan Maraa te'e tanaan beetta si'iin jedheera. Kunoo ani ulee harkaa qabu tanaan bisaan Nayilii hin dhowa; bisaan sunille gara dhiigaatitti hin jijjiirama. ");
INSERT INTO gax_vpl VALUES ("EX7_18","003_7_18","EXO","7","18","18","Qurxummiin laga Nayilii keessa jirtu hin dhumatti; lagi sun hin ajowa; worri Gibxi'iille bisaan san uniisa hin dande'anu› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX7_19","003_7_19","EXO","7","19","19","Mootiin Waan Maraa Muuse'een, «Dhaqii Aaroniin, ‹Ulee teeti harkatti qabadhuutii, bisaan biyya Gibxi'ii lagoota, anguree, baleessa, eela mara irratti harka keeti diriirsi. Isaan gara dhiigaa hin jijjiiraman; bisaan lafa sanii marti, ka waabaa keessa jirulle gara dhiigaa hin jijjiirama› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX7_20","003_7_20","EXO","7","20","20","Achiin duuba Muuse'ee fi Aaron akkuma Mootiin Waan Maraa isaan ajaje godhane. Aaron mootichaa fi qondaaltota isaa duratti ulee ifiitiin bisaan dhowe; bisaan laga Nayilii marti gara dhiigaa jijjiirame. ");
INSERT INTO gax_vpl VALUES ("EX7_21","003_7_21","EXO","7","21","21","Qurxummiin laga Nayilii keessa jirtu marti dhumatte; lagille ajowee, worri Gibxi'ii bisaan laga sanii uniisa hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("EX7_22","003_7_22","EXO","7","22","22","Worri Gibxi'ii ka xanoo xanu, ogummaa ifii ta dhossa'aatiin akkuma san godhane; mootichi mataa jabaatee, akkuma Mootiin Waan Maraa dubbate, Muuse'ee fi Aaron dhage'iisa didate. ");
INSERT INTO gax_vpl VALUES ("EX7_23","003_7_23","EXO","7","23","23","Inni deebi'ee gara mana ifii deeme; waan te'e kana qalbi'itti hin qabanne. ");
INSERT INTO gax_vpl VALUES ("EX7_24","003_7_24","EXO","7","24","24","Bisaan lagaa uniisa waan dadhabaneef, worri Gibxi'ii marti bisaan uni'ii dhaggatiisaaf, laga Nayilii qarqaratti boolla bisaanii qotatane. ");
INSERT INTO gax_vpl VALUES ("EX7_25","003_7_25","EXO","7","25","25","Mootiin Waan Maraa bisaan laga Nayilii gara dhiigaa jijjiireen duuba guyyaan torba dabare. ");
INSERT INTO gax_vpl VALUES ("EX8_1","003_8_1","EXO","8","1","1","Achiin duuba Mootiin Waan Maraa Muuse'een, «Gara mootichaa dhaqiitii, ‹Mootiin Waan Maraa: Kolbaan tiyya akka na waaqonfattuuf gad lakkis! ");
INSERT INTO gax_vpl VALUES ("EX8_2","003_8_2","EXO","8","2","2","Ati isaan gad lakkisuu yoo didde ammoo, ani raacha biyya teetitti buusiisaan hin adaba. ");
INSERT INTO gax_vpl VALUES ("EX8_3","003_8_3","EXO","8","3","3","Lagi Nayilii raachaan akka malee hin guutama. Isaan achi keessaa bayanee gara mana mootumma'aa keetii, gara kolloo taqee teetii, gara taqee teetii, gara mana qondaaltota teetii, kolbaa teeti irratti, akkasuma addee ibiddaatii fi meya bukoo itti bukeessanu keeti keessalle hin guutan. ");
INSERT INTO gax_vpl VALUES ("EX8_4","003_8_4","EXO","8","4","4","Raachi sun utaalee si'i irra, kolbaa keetii fi qondaaltota teeti mara irra hin bu'a jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_5","003_8_5","EXO","8","5","5","Achille'een duuba Mootiin Waan Maraa Muuse'een, «Raachi dhufee lafa Gibxi'ii akka guutuuf, Aaron ulee ifii qabatee harka ifii laga, angure'ee fi baleessa mara irra akka diriirsu itti himi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_6","003_8_6","EXO","8","6","6","Maarre Aaron bisaan biyya Gibxi'ii mara irratti harkaa ifii diriirse; raachille dhufee lafa san guute. ");
INSERT INTO gax_vpl VALUES ("EX8_7","003_8_7","EXO","8","7","7","Worri xanoo xanulle ammoo ogummaa ifii ta dhossa'aatiin akkuma san godhane; isaanille raachi dhufee lafa san akka guutu godhane. ");
INSERT INTO gax_vpl VALUES ("EX8_8","003_8_8","EXO","8","8","8","Mootichi Muuse'ee fi Aaron waamee, «Akka inni raacha kana balleessuuf, gara Mootii Waan Maraa naaf daadimadha'a; akka isaan dhaqanee, Mootii Waan Maraatiif ciincaa dhikeessanu, anille kolbaa teessan gad hin lakkisa» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX8_9","003_8_9","EXO","8","9","9","Muuseelle deebisee Mootichaan, «Raachi kun si'i irraa, qondaaltotaa fi kolbaa teeti irraa akka badu guyyaa ani daadimadhu ati qabadhu. Achiin duuba raachi kun si'ii fi mana keeti keessaa badee laga Nayilii keessa qofatti hin hafa» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_10","003_8_10","EXO","8","10","10","Mootichille deebisee, «Boru naaf daadimadhu» jedheen. Muuseelle, «Ka akka Mootii Waan Maraa, Waaqa keennaa tokkolle akka hin jirre akka ati beettuuf, akkuma ati jette teetuu ti. ");
INSERT INTO gax_vpl VALUES ("EX8_11","003_8_11","EXO","8","11","11","Raachi si'i irraa, qondaaltota teetii fi kolbaa teeti irraa badee, laga Nayilii keessa qofatti hin hafa» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX8_12","003_8_12","EXO","8","12","12","Achiin duuba Muuse'ee fi Aaron mooticha biraa gad bayanee, Mootiin Waan Maraa raacha mootichatti fide san akka balleessuuf, Muuseen gara Mootii Waan Maraa daadimate. ");
INSERT INTO gax_vpl VALUES ("EX8_13","003_8_13","EXO","8","13","13","Mootiin Waan Maraa waan Muuseen daadimate san tolche; raachi sun manoota keessatti, badhinna dalleya keessaatii fi diida keessatti dhumate. ");
INSERT INTO gax_vpl VALUES ("EX8_14","003_8_14","EXO","8","14","14","Worri Gibxi'ii raacha san wolitti qabanee tuulane; tanaaf latti ajootte. ");
INSERT INTO gax_vpl VALUES ("EX8_15","003_8_15","EXO","8","15","15","Mootichi raachi akka irraa goome yennaa dhagge, mataa jabaatee, akkuma Mootiin Waan Maraa dubbate, Muuse'ee fi Aaron dhage'iisa didate. ");
INSERT INTO gax_vpl VALUES ("EX8_16","003_8_16","EXO","8","16","16","Achiin duuba Mootiin Waan Maraa Muuse'een, «Bukuun biyya Gibxi'ii marti bookee akka teetuuf, ati Aaroniin, ‹Ulee teeti fuudhiitii, bukuu lafa irraa dhowi› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_17","003_8_17","EXO","8","17","17","Isaanille akkasuma godhane; Aaron harka ifii diriirsee ulee ifiitiin bukuu lafa irraa yennaa dhowe, namaa fi horii irratti bookeen buute; bukuun biyya Gibxi'ii marti gara booke'ee jijjiirante. ");
INSERT INTO gax_vpl VALUES ("EX8_18","003_8_18","EXO","8","18","18","Bookeen namaa fi hori'itti duudde. Worri xanoo xanu ogummaa ifii ta dhossa'aatiin bookee buusiisaaf yennaa wodhaanane ammoo, hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("EX8_19","003_8_19","EXO","8","19","19","Worri xanoo xanu, mootichaan, «Kun hujii Waaqa ti!» jedhane. Mootichi ammoo mataa jabaatee, akkuma Mootiin Waan Maraa dubbate, Muuse'ee fi Aaron dhage'iisa didate. ");
INSERT INTO gax_vpl VALUES ("EX8_20","003_8_20","EXO","8","20","20","Mootiin Waan Maraa ammalle Muuse'een, «Boru ganama bari'iin ka'iitii, yennaa mootichi laga deemu, isa dura dhaabbadhuutii, ‹Mootiin Waan Maraa: Kolbaan tiyya akka na waaqonfattuuf, gad lakkisi! ");
INSERT INTO gax_vpl VALUES ("EX8_21","003_8_21","EXO","8","21","21","Ati kolbaa tiyya gad lakkisuu yoo didde ammoo, ani tuuta faachaa si'itti, qondaaltota teetii fi kolbaa teetitti hin buusa. Manni worra Gibxi'ii marti, addeen isaan jiranu marti faachaan hin guutaman. ");
INSERT INTO gax_vpl VALUES ("EX8_22","003_8_22","EXO","8","22","22","« ‹Guyyaa san ammoo, akka ani, Mootiin Waan Maraa lafa tana keessa jiru akka ati beettuuf, lafa kolbaan tiyya keessa leetu Gooshen, akka faachi achi hin jiraanne hin tolcha. ");
INSERT INTO gax_vpl VALUES ("EX8_23","003_8_23","EXO","8","23","23","Ani kolbaa tiyyaa fi kolbaa teeti oddu'utti garaagarummaa hin tolcha; bilbaasi kunille boru hin te'a jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_24","003_8_24","EXO","8","24","24","Mootiin Waan Maraa akkuma dubbate tolche. Tuuti faachaa Mana mootichaatii fi mana qondaaltota isaatitti bu'e; latti Gibxi'ii marti faachaan guutantee badde. ");
INSERT INTO gax_vpl VALUES ("EX8_25","003_8_25","EXO","8","25","25","Achiin duuba mootichi Muuse'ee fi Aaron waamee, «Dhaqa'aatii biyyuma tana keessatti Waaqa keessaniif ciincaa dhikeessa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_26","003_8_26","EXO","8","26","26","Muuseen ammoo deebisee «Ciincaan nuuti Mootii Waan Maraa Waaqa keennaaf dhikeessinu, worra Gibxi'ii biratti diqatamaa waan te'uuf, tana godhuun sirri'ii moti. Ciincaa isaan duratti diqatamaa te'e, yoo dhikeessine dhaka'aan nu hin tumanuu? ");
INSERT INTO gax_vpl VALUES ("EX8_27","003_8_27","EXO","8","27","27","Akkuma inni nu ajaje guyyaa sad goomolee keessa deennee, Mootii Waan Maraa Waaqa keennaaf ciincaa dhikeessuu qanna» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_28","003_8_28","EXO","8","28","28","Mootichille, «Akka Mootii Waan Maraa Waaqa keessaniif goomolee keessatti ciincaa dhikeessitanu, ani gad isin hin lakkisa; garuu fagaattanee hin deemina'a. Anaafille daadimadha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_29","003_8_29","EXO","8","29","29","Muuseelle deebisee, «Akkuma si biraa deemeen, Mootii Waan Maraa hin daadimadha. Faachi si'i, qondaaltota teetii fi kolbaa teeti irraa hin ka'a. Ati ammoo kolbaan dhaxxee, Mootii Waan Maraatiif ciincaa dhikeessiisa dhooggitee ammalle nu hin sobin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX8_30","003_8_30","EXO","8","30","30","Achiin duuba Muuseen mooticha biraa deemee, Mootii Waan Maraa daadimate. ");
INSERT INTO gax_vpl VALUES ("EX8_31","003_8_31","EXO","8","31","31","Mootiin Waan Maraalle waan Muuseen daadimate tolche. Faachi tokkolle adoo hin hafin mooticha, qondaaltota isaatii fi kolbaa isaa irraa bade. ");
INSERT INTO gax_vpl VALUES ("EX8_32","003_8_32","EXO","8","32","32","Mootichi ammoo yennaa tanalle mataa jabaatee, kolbaa gad lakkisuu didate. ");
INSERT INTO gax_vpl VALUES ("EX9_1","003_9_1","EXO","9","1","1","Achiin duuba Mootiin Waan Maraa Muuse'een, «Gara mootichaa dhaqiitii, ‹Mootiin Waan Maraa Waaqi Ibrootaa: Kolbaan tiyya dhaxxee akka na waaqonfattuuf gad lakkisi. ");
INSERT INTO gax_vpl VALUES ("EX9_2","003_9_2","EXO","9","2","2","Ati ammalle akka isaan deemanu yoo gad lakkisuu dide, ");
INSERT INTO gax_vpl VALUES ("EX9_3","003_9_3","EXO","9","3","3","ani horii keeti ka diida tikatu fardoolee teeti, harreelee teeti, gaalota keeti, hoolota teetii fi re'oota teeti irratti dhukkuba hamaa hin buusa. ");
INSERT INTO gax_vpl VALUES ("EX9_4","003_9_4","EXO","9","4","4","Horii Israa'elootaatii fi horii worra Gibxi'ii wodhakka'atti garaagarummaa hin tolcha; horiin Israa'elootaa hin du'u jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX9_5","003_9_5","EXO","9","5","5","Mootiin Waan Maraa guyyaa murteessee, «Ani waan kana boru lafa tanatti hin fida» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX9_6","003_9_6","EXO","9","6","6","Guyyaa itti aanu Mootiin Waan Maraa akkuma jedhe godhe; horiin worra Gibxi'ii marti dhumatee, ka Israa'eloota ammoo tokkolle hin duune. ");
INSERT INTO gax_vpl VALUES ("EX9_7","003_9_7","EXO","9","7","7","Mootichi akka ilaalanu namoota ergee, horiin Israa'elootaa tokkolle akka hin du'in hubate; te'uu malee mootichi mataa jabaatee kolbaa gad lakkisuu didate. ");
INSERT INTO gax_vpl VALUES ("EX9_8","003_9_8","EXO","9","8","8","Achiin duuba Mootiin Waan Maraa Muuse'ee fi Aaroniin, «Badaa ibiddaa irraa daadhaa ooboo takkaa fuudha'aatii, Muuseen mooticha duratti qilleensa irratti ol qolaansuu ti. ");
INSERT INTO gax_vpl VALUES ("EX9_9","003_9_9","EXO","9","9","9","Daadhaan sun lafa Gibxi'ii mara irratti bukuu te'ee, namaa fi horii irratti iita maloottu hin te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX9_10","003_9_10","EXO","9","10","10","Isaanille bukuu fuudhanee fuula mootichaa dura dhaabbatane; Muuseelle daadhaa san qilleensa irratti ol qolaansee, kolba'aa fi horiin marti iitowane. ");
INSERT INTO gax_vpl VALUES ("EX9_11","003_9_11","EXO","9","11","11","Worri xanoo xanuu fi worri Gibxi'ii marti waan iitowaneeranuuf, worri xanoo xanu Muusee dura dhaabbatiisa hin dandeenne ");
INSERT INTO gax_vpl VALUES ("EX9_12","003_9_12","EXO","9","12","12","Mootiin Waan Mara ammoo mooticha mataa jabeessee, akkuma Mootiin Waan Maraa Muuse'etti dubbate, mootichi Muuse'ee fi Aaron dhage'iisa didate. ");
INSERT INTO gax_vpl VALUES ("EX9_13","003_9_13","EXO","9","13","13","Achiin duuba Mootiin Waan Maraa Muuse'een, «Boru ganama bari'iin ka'iitii, mooticha dura dhikaadhuutii, ‹Mootiin Waan Maraa Waaqi Ibrootaa: Kolbaan tiyya akka na waaqonfattuuf gad lakkisi. ");
INSERT INTO gax_vpl VALUES ("EX9_14","003_9_14","EXO","9","14","14","Yoo gad lakkisuu didde, biyya lafaa mara irra ka akka kiyyaa tokkolle akka hin jirre, akka ati beettuuf ani amma si irratti, qondaaltota teetii fi kolbaa teeti irratti balaa hamaa hin fida. ");
INSERT INTO gax_vpl VALUES ("EX9_15","003_9_15","EXO","9","15","15","Ani akka harka kiyya ol fudhadhetti si'ii fi kolbaa teeti adoo dhowee jiraadhee, silaa ati lafa irraa ijjumaa baddeerta. ");
INSERT INTO gax_vpl VALUES ("EX9_16","003_9_16","EXO","9","16","16","Te'uu malee hunna tiyya si'itti mudhisiisaa fi maqaan kiyya biyya mara irratti akka beekkamuuf, ani si lakkise. ");
INSERT INTO gax_vpl VALUES ("EX9_17","003_9_17","EXO","9","17","17","Ati ammoo haga ammaa ol ifi qaddee kolbaan tiyya akka deentu gad lakkisuu didde. ");
INSERT INTO gax_vpl VALUES ("EX9_18","003_9_18","EXO","9","18","18","Tanaaf, boru yennaa akkanaa tana bokkeya dhaka'aa hamaa ka dabarsii biyya Gibxi'ii keessatti bu'ee hin beenne, hin buusa. ");
INSERT INTO gax_vpl VALUES ("EX9_19","003_9_19","EXO","9","19","19","Bokkeenni dhaka'aa hori'ii fi nama gara manaa hin galin waan ala jiru mara waan ijjeesuuf, ati amma horii keetii fi waan ala jiru mara manatti akka galchanu ajaji jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX9_20","003_9_20","EXO","9","20","20","Qondaaltoti mootichaa worri jecha Mootii Waan Maraa sodaate, garboolee ifiitii fi horii ifii manatti galfatiisaaf ariifate. ");
INSERT INTO gax_vpl VALUES ("EX9_21","003_9_21","EXO","9","21","21","Worri gariin ka jecha Mootii Waan Maraa tuffate, garboolee ifiitii fi horii ifii alatti lakkise. ");
INSERT INTO gax_vpl VALUES ("EX9_22","003_9_22","EXO","9","22","22","Achiin duuba Mootiin Waan Maraa Muuse'een, «Lafa Gibxi'ii mara irratti, namaa fi horii irratti, waan lafa Gibxi'ii irratti latu mara irratti bokkeenni dhaka'aa akka bu'u harka keeti gara gubba'aa ol kaasi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX9_23","003_9_23","EXO","9","23","23","Yennaa Muuseen ulee ifii gara gubba'aa ol kaase, Mootiin Waan Maraa mandiisu'uu fi bokkeya dhaka'aa buusee balaqqeettiille balaqqitte. Maarre Mootiin Waan Maraa bokkeya dhaka'aa lafa Gibxi'ii irratti roobisiise ");
INSERT INTO gax_vpl VALUES ("EX9_24","003_9_24","EXO","9","24","24","Bokkeenni dhaka'aa hamaan bu'e; balaqqeettiin balaqqitte. Haga Gibxi biyya teeteen jalqaddee bubbeen bokkeyaa ta teetee hin beenne teete. ");
INSERT INTO gax_vpl VALUES ("EX9_25","003_9_25","EXO","9","25","25","Bokkeenni dhaka'aa kun biyya Gibxii keessatti namaa fi horii alatti hafane mara dhowe. Waan diida keessatti lateeru mara dhowee, mukoota mara caccasse. ");
INSERT INTO gax_vpl VALUES ("EX9_26","003_9_26","EXO","9","26","26","Addee worri Israa'elootaa le'anu lafa Gooshenii qofatti, bokkeenni dhaka'aa hin buune. ");
INSERT INTO gax_vpl VALUES ("EX9_27","003_9_27","EXO","9","27","27","Achiin duuba Mootichi Muuse'ee fi Aaron waamee, «Ani amma yakkeera. Mootiin Waan Maraa balcha'a. Ani fi kolbaa tiyya ammoo yakkineerra. ");
INSERT INTO gax_vpl VALUES ("EX9_28","003_9_28","EXO","9","28","28","Bokkeenni dhaka'aatii fi mandiisuun waan nutti bacatteef, Mootii Waan Maraa nu'uuf daadimadha'a. Anille gad isin hin lakkisa. Haganaa achi as hin turtanu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX9_29","003_9_29","EXO","9","29","29","Muuseen deebisee, «Ani qachaa keessaa yennaa baye, harka kiyya gara Mootii Waan Maraa ol kaasee hin daadimadha. Latti tun ta Mootii Waan Maraa akka teete akka ati beettuuf, mandiisuun hin dhaabbatti. Bokkeenni dhaka'aalle haganaa achi hin jiraatu. ");
INSERT INTO gax_vpl VALUES ("EX9_30","003_9_30","EXO","9","30","30","Garuu ati fi qondaaltoti teeti Mootii Waan Maraa Waaqa akka hin sodaanne ani hin beeka» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX9_31","003_9_31","EXO","9","31","31","Yennaa san talbaan daraaree garbuun ammoo shawwee waan te'eef, talba'aa fi garbuulle bokkeya dhaka'aatiin badane. ");
INSERT INTO gax_vpl VALUES ("EX9_32","003_9_32","EXO","9","32","32","Qamadi'ii fi ajjaan ammoo duuba irra waan bilchaatanuuf hin banne. ");
INSERT INTO gax_vpl VALUES ("EX9_33","003_9_33","EXO","9","33","33","Achiin duuba Muuseen mooticha biraa deemee, qachaa keessaa bayee, daadimatiisaaf, harka ifii gara Mootii Waan Maraa ol kaase. Mandiisu'uu fi bokkeenni dhaka'aa dhaabbatee, bokkeennille roobiisaa lakkise. ");
INSERT INTO gax_vpl VALUES ("EX9_34","003_9_34","EXO","9","34","34","Mootichi mandiisuun, bokkeenni dhaka'aatii fi bokkeenni akka dhaabbate yennaa dhagge, ammalle yakkaa huje. Innii fi qondaaltoti isaa mataa jabaatane. ");
INSERT INTO gax_vpl VALUES ("EX9_35","003_9_35","EXO","9","35","35","Akkuma Mootiin Waan Maraa Muuse'etti dubbate, mootichi mataa jabaatee, Israa'elooti akka deemanu gad lakkisuu didate. ");
INSERT INTO gax_vpl VALUES ("EX10_1","003_10_1","EXO","10","1","1","Achiin duuba Mootiin Waan Maraa Muuse'een, «Ati gara mootichaa dhaqi. Ani bilbaasota kiyya kana odduu isaaniititti tolchiisaaf, mootichaa fi qondaaltota isaa mataa jabeesseera. ");
INSERT INTO gax_vpl VALUES ("EX10_2","003_10_2","EXO","10","2","2","Ati ammoo waan ani worra Gibxi'ii irratti tolche, bilbaasota ani isaan oddu'utti huje kana, dabarsitee ilmaan teetii fi ilmaan ilmaan teetiititti hin hinta. Isin akka ani Mootii Waan Maraa te'e tanaan hin beettan» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_3","003_10_3","EXO","10","3","3","Maarre Muuse'ee fi Aaron gara mootichaa dhaqanee, «Mootiin Waan Maraa, Waaqi Ibrootaa, ‹Ati haga yoomii naaf ajajamuu didda? Kolbaan tiyya deentee akka na waaqonfattuuf gad lakkisi. ");
INSERT INTO gax_vpl VALUES ("EX10_4","003_10_4","EXO","10","4","4","Ati kolbaa tiyya yoo gad lakkisuu didde, ani boru tuuta awwaannisaa biyya teetitti hin fida. ");
INSERT INTO gax_vpl VALUES ("EX10_5","003_10_5","EXO","10","5","5","Awwaannisi sun haga latti mudhatiisa dhaddutti lafa hin golla. Waan diqqoo bokkeya dhaka'aa irraa hafe, muka diida keessatti quunxiisatti jirulle mara hin nyaata. ");
INSERT INTO gax_vpl VALUES ("EX10_6","003_10_6","EXO","10","6","6","Mana keeti keessa, mana qondaaltota teetiitii fi mana worra Gibxootaa mara keessa hin guuta. Abbootiin teetii fi abbootiin abbootii teetii, lafa tanatti haga qubataneen jalqabanee haga adhaa, waan kana ijjumaa dhagganee hin beekanu› jedha» jedhane. Achiin duuba Muuseen mooticha biraa bayee deeme. ");
INSERT INTO gax_vpl VALUES ("EX10_7","003_10_7","EXO","10","7","7","Qondaaltoti mootichaalle, mootichaan, «Haga yoomii namichi kun tiyyoo nu'utti te'a? Kolbaan tun deentee Mootii Waan Maraa Waaqa ifii akka waaqonfattuuf gad lakkisi; ati worri Gibxi'ii akka badane haga ammaa hin hubannee?» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("EX10_8","003_10_8","EXO","10","8","8","Achiin duuba Muuse'ee fi Aaron waamamanee gara mootichaa deebi'anee dhufane; inni isaaniin, «Dhaqa'aatii, Mootii Waan Maraa, Waaqa keessan waaqonfadha'a! Garuu worri dhaqu kun eennu fa'a?» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_9","003_10_9","EXO","10","9","9","Muuseelle deebisee, «Tun jila Mootii Waan Maraatiif jilifannu waan teeteef, nuuti ijoolle'ee fi jaarsolee teenna, ilmaanii fi ijoollee durraa teenna, hoole'ee fi re'ee teenna, loon keennalle fudhannee hin deenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_10","003_10_10","EXO","10","10","10","Mootichille, «Isin dubartootaa fi ijoollee teessan fudhattanee akka deentanu, ani yoo gad isin lakkise, Mootiin Waan Maraa isin woliin jiraatuu ti; isin garuu waan hantuu yaadattaneertan. ");
INSERT INTO gax_vpl VALUES ("EX10_11","003_10_11","EXO","10","11","11","Waawwo'o! Ka isin gaafattane kanuma waan te'eef, worri dhiiraa callaan deemee Mootii Waan Maraa waaqonfatuu ti» jedhe. Achiin duuba Muuse'ee fi Aaron mooticha biraa ari'amane. ");
INSERT INTO gax_vpl VALUES ("EX10_12","003_10_12","EXO","10","12","12","Mootiin Waan Maraa Muuse'een, «Awwaannisi biyya Gibxi'ii irratti dhufee, waan bokkeya dhaka'aa irraa hafe maraa fi waan diida keessatti quunxiisatti jiru mara akka nyaatu harka keeti biyya Gibxi'ii irratti ol diriirsi!» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_13","003_10_13","EXO","10","13","13","Maarre Muuseen ulee ifii biyya Gibxi'ii irratti ol kaasee, guyya'aa fi halkan san Mootiin Waan Maraa qilleensi gara aduun baatuu lafa san irratti akka dhufu godhe; boruyyaa ganama qilleensi awwaannisa fide. ");
INSERT INTO gax_vpl VALUES ("EX10_14","003_10_14","EXO","10","14","14","Awwaannisi sun bacatee dhufee, lafa Gibxi'ii maratti tuute. Balaan awwaannisaa ka akkasii tanaan qara ijjumaa mudhatee hin beeku; gara duraalle hin jiraatu. ");
INSERT INTO gax_vpl VALUES ("EX10_15","003_10_15","EXO","10","15","15","Haga gurraachottutti awwaannisi sun lafa gollee, waan bokkeya dhaka'aa irraa hafe mara, waan diida keessatti quunxiisatti jiru maraa fi midhaan muka irraa mara nyaate. Lafa Gibxi'ii mara irratti wonni magariis tokkolle hin hanne. ");
INSERT INTO gax_vpl VALUES ("EX10_16","003_10_16","EXO","10","16","16","Mootichille Muuse'ee fi Aaron ariiti'iin waansisee, isaaniin, «Mootii Waan Maraa Waaqa keessanii fi isin irralle'etti cubbuu hujeera. ");
INSERT INTO gax_vpl VALUES ("EX10_17","003_10_17","EXO","10","17","17","Amma yennaa tokko qofa cubbuu tiyya naaf araarama'a; balaa hamaa kana akka na irraa balleessuuf, gara Mootii Waan Maraa Waaqa keessanii naa daadimadha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_18","003_10_18","EXO","10","18","18","Muuse'ee fi Aaronille mooticha biraa deemanee gara Mootii Waan Maraa daadimatane. ");
INSERT INTO gax_vpl VALUES ("EX10_19","003_10_19","EXO","10","19","19","Mootiin Waan Maraa qilleensa gara qilleensa jabaa gara aduun seentuutitti jijjiiree, qilleensi sun Awwaannisa san oofee abbaayaa diintu'utti naqe. Biyya Gibxi'ii keessatti awwaannisi tokkolle hin hanne. ");
INSERT INTO gax_vpl VALUES ("EX10_20","003_10_20","EXO","10","20","20","Mootiin Waan Maraa ammoo mooticha mataa jabeessee, mootichi akka deemanuuf Israa'eloota gad lakkisuu didate. ");
INSERT INTO gax_vpl VALUES ("EX10_21","003_10_21","EXO","10","21","21","Achiin duuba Mootiin Waan Maraa Muuse'een, «Dukkanti dimmi biyya Gibxi'iititti akka buutu, harka keeti gara gubba'aa ol kaasi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_22","003_10_22","EXO","10","22","22","Maarre Muuseen harka ifii gara gubba'aa ol kaasee, haga guyyaa sadii dukkanti dimmi biyya Gibxi'ii irratti buute. ");
INSERT INTO gax_vpl VALUES ("EX10_23","003_10_23","EXO","10","23","23","Haga guyyaa sadii san nami tokkolle wol dhagguu hin dandeenne yookiin addee jiranu sanii hin kaane. Te'uu malee, latti Israa'elooti leetu marti ifa qaddiiyyu. ");
INSERT INTO gax_vpl VALUES ("EX10_24","003_10_24","EXO","10","24","24","Achiin duuba Mootichi Muusee waamee, «Dhaqa'aatii Mootii Waan Maraa waaqonfadha'a; dubartooti teessanii fi ijoolleen teessanille isin woliin dhaqanuu ti; hooleen, re'e'ee fi horiin keessan ammoo asitti hafanuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_25","003_10_25","EXO","10","25","25","Muuseen ammoo deebisee, «Ciinca'aa fi kennansa gubamu ka Mootii Waan Maraa Waaqa keennaaf dhikeessinu ati nu'uuf kenni ree. ");
INSERT INTO gax_vpl VALUES ("EX10_26","003_10_26","EXO","10","26","26","Horiin keenna marti nu woliin dhaquu qaba; qenci tokkolle asitti hin hafu. Mootii Waan Maraa Waaqa kennaaf ka dhikeessinu isaan keessaa filanna; haga achi geennutti Mootii Waan Maraatiif ka dhikeessinu hin beennu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_27","003_10_27","EXO","10","27","27","Mootiin Waan Maraa mooticha mataa jabeessee, mootichi akka isaan deemanu hin feene. ");
INSERT INTO gax_vpl VALUES ("EX10_28","003_10_28","EXO","10","28","28","Mootichi Muuse'een, «Fuula kiyya duraa bayi! Deebitee fuula kiyya duratti akka hin mudhanne beekkadhu! Guyyaa fuula kiyya dhaggite, ati hin duuta!» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX10_29","003_10_29","EXO","10","29","29","Muuseelle deebisee, «Akkuma ati jette, ani deebi'ee fuula keeti duratti hin mudhadhu!» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX11_1","003_11_1","EXO","11","1","1","Achiin duuba Mootiin Waan Maraa Muuse'een, «Ani amma balaa tokko callaa mooticha Gibxi'iitii fi kolbaa isaa irratti hin fida; saniin duuba mootichi akka isin asii deentanu gad isin hin lakkisa; nami tokkolle adoo hin hafin isin maraayyuu hin ari'a. ");
INSERT INTO gax_vpl VALUES ("EX11_2","003_11_2","EXO","11","2","2","Kolbaan Israa'elii marti ollaa ifii irraa meya meeti'iitii fi worqi'ii gaafatanee akka fudhatanu itti himi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX11_3","003_11_3","EXO","11","3","3","Mootiin Waan Maraa worri Gibxi'ii akka Israa'eloota ulfeessanu godhe. Muuseelle biyya Gibxi'iititti, qondaaltota mootichaatii fi fuula kolba'aa mara duratti nama ulfinnaa te'e. ");
INSERT INTO gax_vpl VALUES ("EX11_4","003_11_4","EXO","11","4","4","Maarre Muuseen mootichaan, «Mootiin Waan Maraa, ‹Halkan wodhakkaa ani lafa Gibxi'ii mara keessa hin deddeema; ");
INSERT INTO gax_vpl VALUES ("EX11_5","003_11_5","EXO","11","5","5","ilmaan angafooti Gibxi keessaa marti hin du'an; ilma angaficha mooticha barcumaa mootumma'aa irra tee'uun jalqabee haga ilmaan angafoota dubartoota garboolee daakuu daattuutitti, angafooti hori'iille martinuu hin du'an. ");
INSERT INTO gax_vpl VALUES ("EX11_6","003_11_6","EXO","11","6","6","Biyya Gibxi'ii mara keessatti, iyyi wiiccifataa ka kanaan qara te'ee hin beenne yookiin ka gara duraalle hin teene hin te'a. ");
INSERT INTO gax_vpl VALUES ("EX11_7","003_11_7","EXO","11","7","7","Namaa fi horii Israa'elootaatitti ammoo sareelle itti hin duttu; worra Israa'elootaatii fi worra Gibxi'ii oddu'utti Mootiin Waan Maraa garaagarummaa akka godhe kanaan hin beettan› jedheera» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX11_8","003_11_8","EXO","11","8","8","Muuseen, «Qondaaltoti teeti tun marti gara kiyya dhufanee, na duratti gad jedhanee, ‹Atii fi kolbaan si gula deentu martinuu deema'a!› jedhanee na hin kadhatan; saniin duuba ani hin deema» jedhe. Achiin duuba Muuseen aarii jaddu'uun mooticha biraa bayee deeme. ");
INSERT INTO gax_vpl VALUES ("EX11_9","003_11_9","EXO","11","9","9","Mootiin Waan Maraa Muuse'een, «Bilbaasi kiyya biyya Gibxi'ii irratti akka bacatuuf, mootichi isin dhage'uu hin didata» jedheeraayyu. ");
INSERT INTO gax_vpl VALUES ("EX11_10","003_11_10","EXO","11","10","10","Muuse'ee fi Aaronille fuula mootichaa duratti bilbaasota kana mara godhane; Mootiin Waan Maraa ammoo mooticha mataa waan jabeesseef, mootichi Israa'elooti biyya isaa keessaa akka bayanu gad hin lakkinne. ");
INSERT INTO gax_vpl VALUES ("EX12_1","003_12_1","EXO","12","1","1","Mootiin Waan Maraa biyya Gibxi'ii keessatti Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("EX12_2","003_12_2","EXO","12","2","2","«Jiin kun ji'a qaraa, ji'a jalqaba wogga'aa isiniif te'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX12_3","003_12_3","EXO","12","3","3","Ji'a kana guyyaa kudhaneesso'ootitti, nami tokko tokkooyyuu maatii ifiitiif, buruusoo korbeessa hoole'ee yookiin re'e'ee tokko akka qopheessu wolde'a Israa'eliititti himi. ");
INSERT INTO gax_vpl VALUES ("EX12_4","003_12_4","EXO","12","4","4","Maatiin takka buruusoo korbeessa hoole'ee yookiin re'e'ee san nyaatanee fixiisaaf laakkossi isaanii yoo diqqaate, nami sun ollaa ifii woliin akkuma laakkossa namoota maatii saniititti qoodamanuu ti; haga nami tokko nyaatuu dande'u shallaganee qoodamanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX12_5","003_12_5","EXO","12","5","5","Buruusoon sun korbeeyyii woggaa tokkoo ta fafa hin qanne te'anuu ti; isaan kana hoolee yookiin re'ee keessaa filadha'a. ");
INSERT INTO gax_vpl VALUES ("EX12_6","003_12_6","EXO","12","6","6","Buruusoo san ji'a san keessa haga guyyaa kudhanii arfeesso'ootitti tissitanee, guyyaa kudhanii arfeesso'oo galgala dimimmisa kolbaan Israa'elii marti qalattuu ti. ");
INSERT INTO gax_vpl VALUES ("EX12_7","003_12_7","EXO","12","7","7","Achiin duuba isaan dhiiga diqqaa isaa fuudhanee, mana foon itti nyaatanu san mikikkila balbalaa ka cinaa lamaaniituu, mikikkila balbalaa ka gubba'aalle dibanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX12_8","003_12_8","EXO","12","8","8","Halkanuma san foon san ibiddatti woddanee baala hadhowuu fi daabboo uukoo hin qanne woliin nyaatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX12_9","003_12_9","EXO","12","9","9","Foon dheedhii yookiin foon iffeelame hin nyaatina'a; mataa, manye'ee fi meya gadha'aa woliin ibiddatti wodda'aatii nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("EX12_10","003_12_10","EXO","12","10","10","Foon san irraa tokkolle haga bari'iititti hin hamburina'a; yoo hafe ibiddaan guba'a. ");
INSERT INTO gax_vpl VALUES ("EX12_11","003_12_11","EXO","12","11","11","Jila irra dabaramaa ta ana Mootii Waan Maraa ulfeessiisaaf jilifattanu waan teeteef, yennaa nyaattanu, akka nama karaa deemiisaaf qophowee, woyaa uffadha'aa, kophee keyadha'aa, ulee teessan harkatti qabadha'aatii ariiti'iin nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("EX12_12","003_12_12","EXO","12","12","12","«Halkanuma san ani biyya Gibxi'ii keessa deddeemee, waan angafa te'e mara, ka namaatii fi ka hori'iille hin ijjeesa; waaqota biyya Gibxi'ii mara irratti hin mura. Ani Mootii Waan Maraa ti. ");
INSERT INTO gax_vpl VALUES ("EX12_13","003_12_13","EXO","12","13","13","Mana isin keessa jirtanu irratti dhiigi beessisa isiniif hin te'a; ani yennaa dhiiga san dhagge, isin irra hin dabara; Yennaa biyyaa Gibxi'iititti balaa buusu, isin irratti balaan tokkolle hin bu'u. ");
INSERT INTO gax_vpl VALUES ("EX12_14","003_12_14","EXO","12","14","14","«Guyyaan kun guyyaa yaadanno'oo isiniif te'uu ti. Dhaloota dhufuufille seerata bara baraa te'ee, ana Mootii Waan Maraa ulfeessiisaaf jilifattan. ");
INSERT INTO gax_vpl VALUES ("EX12_15","003_12_15","EXO","12","15","15","«Guyyaa jila tanaa guyyaa torba daabboo uukoo hin qanne nyaadha'a; guyyaa jalqabaatii haga guyyaa torbeesso'oo nami daabboo uukoo qaddu nyaate Israa'el keessaa waan bawuuf, guyyaa tokkeesso'oo daabboo uukoo qaddu mana keessan keessaa balleessa'a. ");
INSERT INTO gax_vpl VALUES ("EX12_16","003_12_16","EXO","12","16","16","Guyyaa tokkeesso'ootii fi guyyaa torbeesso'oo yaa'ii woyyittii godhadha'a. Guyyoota kana nami marti waan nyaatu qopheeffatuutii malee, hujii tokkolle hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("EX12_17","003_12_17","EXO","12","17","17","«Ani guyyaa kanatti kolbaa tiyya biyya Gibxi'ii keessaa waan baaseef, jila daabboo uukoo hin qannee jilifadha'a; guyyaa kana dhaloota dhufuufille seerata bara baraa godhadha'aatii eegadha'a. ");
INSERT INTO gax_vpl VALUES ("EX12_18","003_12_18","EXO","12","18","18","Ji'a jalqabaa, guyyaa kudhanii arfeesso'oo galgala irraa jalqaddanee haga guyyaa diddamii tokkeesso'oo galgalaatitti daabboo uukoo hin qanne nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("EX12_19","003_12_19","EXO","12","19","19","Haga guyyaa torbaa uukoon ijjumaa mana keessan keessatti hin dhaggamin; alagaa yookiin dhalataa biyyaalle yoo te'e, nami waan uukoo qabu nyaate kolbaa Israa'elii keessaa bayuu qaba. ");
INSERT INTO gax_vpl VALUES ("EX12_20","003_12_20","EXO","12","20","20","Addee jirtanu maratti daabboo uukoo hin qanne nyaadha'a malee, waan uukoo qabu hin nyaatina'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX12_21","003_12_21","EXO","12","21","21","Achiin duuba Muuseen jaarsolee Israa'elootaa mara waamee, «Ariifadha'aa dhaqa'aatii akka maatii maatii keessaniititti buruusoo korbeessa hoole'ee yookiin re'e'ee filadha'aatii, Jila Irra Dabaramaatiif qaladha'a. ");
INSERT INTO gax_vpl VALUES ("EX12_22","003_12_22","EXO","12","22","22","Baala muka hisoophii qabaa tokko fuudha'aatii, dhiiga qorii keessaatitti cuupha'aatii, mikikkila balbalaa ka cinaa lamaaniituu, mikikkila balbalaa ka gubba'aalle diba'a; haga ganamaatitti nami tokkolle mana ifiitii gad hin bayin. ");
INSERT INTO gax_vpl VALUES ("EX12_23","003_12_23","EXO","12","23","23","Mootiin Waan Maraa balaa buusiisaaf, biyya Gibxi'ii keessa yennaa deddeemu, mikikkila balbalaa ka cinaa lamaaniituu irratti, mikikkila balbalaa ka gubba'aa irralle'etti dhiiga dhaggee, balbala san irra hin dabara. Ka balleessu sun mana keessan seenee akka isin ijjeesu itti hin lakkisu. ");
INSERT INTO gax_vpl VALUES ("EX12_24","003_12_24","EXO","12","24","24","Isinii fi sanyiin teessan seerata haga bara baraa ka isiniif kenname kanaaf ajajamuu qaddan. ");
INSERT INTO gax_vpl VALUES ("EX12_25","003_12_25","EXO","12","25","25","Lafa Mootiin Waan Maraa isinii kenniisaaf waadaa gale sanitti yennaa galtane seerata kana eegadha'a. ");
INSERT INTO gax_vpl VALUES ("EX12_26","003_12_26","EXO","12","26","26","Ijoolleen teessan, ‹Jilti tun ta maanii ti inni?› jettee yennaa isin gaafattu, ");
INSERT INTO gax_vpl VALUES ("EX12_27","003_12_27","EXO","12","27","27","isin ammoo, ‹Mootiin Waan Maraa biyya Gibxi'ii irratti balaa yennaa buuse, biyya Gibxi'ii keessatti mana Israa'elootaa irra dabaree, qe'ee teenna waan hambureef, ciincaa Jila Irra Dabaramaa ta Mootii Waan Maraa ti› jedha'aan» jedhe. Achiin duuba kolbaan gad jettee sagadde. ");
INSERT INTO gax_vpl VALUES ("EX12_28","003_12_28","EXO","12","28","28","Israa'elootille waan Mootiin Waan Maraa Muuse'ee fi Aaron ajaje mara goote. ");
INSERT INTO gax_vpl VALUES ("EX12_29","003_12_29","EXO","12","29","29","Halkan wodhakkaa Mootiin Waan Maraa biyya Gibxi'ii keessatti angafa te'anee ka dhalatane mara, ilma angaficha mooticha barcumaa mootummaa irra tee'uutii jalqabee, haga angafoota worra mana hidha'aa ka boollaa keessa jiruutii fi angafoota hori'ii mara ijjeese. ");
INSERT INTO gax_vpl VALUES ("EX12_30","003_12_30","EXO","12","30","30","Halkan san mootichi, qondaaltoti isaatii fi worri biyya Gibxi'ii marti hirriibaa ka'ane; manni nami keessaa hin du'in tokkolle waan hin jirreef, biyya Gibxi'ii keessatti iyyi wiiccifataa te'e ");
INSERT INTO gax_vpl VALUES ("EX12_31","003_12_31","EXO","12","31","31","Halkanuma san mootichi Muuse'ee fi Aaron waansisee, «Ka'a'a! Isinii fi Israa'elooti kolbaa tiyya keessaa baya'a! Akkuma jettane dhaqa'aatii Mootii Waan Maraa keessan waaqonfadha'a. ");
INSERT INTO gax_vpl VALUES ("EX12_32","003_12_32","EXO","12","32","32","Akkuma jettane hoolee, re'e'ee fi loon keessan fudhadha'aatii deema'a. Analle eebbisa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX12_33","003_12_33","EXO","12","33","33","Worri Gibxi'ii, «Nuuti martinuu hin dhumanna» waan jedhaneef, akka Israa'elooti biyya isaanii keessaa ariifatanee bayanu muddane. ");
INSERT INTO gax_vpl VALUES ("EX12_34","003_12_34","EXO","12","34","34","Tanaaf Israa'elooti bukoo ifii uukoo adoo itti hin naqin meya bukoo itti bukeessanutti naqanee, woya'aan maranee, fuudhanee gurmu'utti kaafatane. ");
INSERT INTO gax_vpl VALUES ("EX12_35","003_12_35","EXO","12","35","35","Israa'elooti akkuma Muuseen isaanitti hime, meya meeti'ii, meya worqi'iitii fi woyaa akka isaanii kennanu, worra Gibxi'ii gaafatane. ");
INSERT INTO gax_vpl VALUES ("EX12_36","003_12_36","EXO","12","36","36","Mootiin Waan Maraalle worri Gibxi'ii Israa'eloota akka ulfeessanu waan godheef, waan isaan gaafatane mara isaaniif kennane; tanaaf Israa'elooti worra Gibxi'ii irraa qabeenna isaanii guuratanee bayane. ");
INSERT INTO gax_vpl VALUES ("EX12_37","003_12_37","EXO","12","37","37","Israa'elooti Raamsesii ka'anee haga Suukootii deemane; isaan dubartootaa fi ijoollee maleenama kuma dhibba jaa. ");
INSERT INTO gax_vpl VALUES ("EX12_38","003_12_38","EXO","12","38","38","Worri Israa'eloota hin te'in kolbaan hedduun, hooleen, re'e'ee fi loon baca'atti isaan woliin baye. ");
INSERT INTO gax_vpl VALUES ("EX12_39","003_12_39","EXO","12","39","39","Isaan bukoo biyya Gibxi'iitii fudhatanee bayane saniin daabboo uukoo hin qanne bilcheeffatane; yennaa Gibxi keessaa bayanu ariiti'iin waan bayaneef, bukoo isaanii keessa uukoon hin jirtu; ideensa kara'aatiif galaa qopheeffatiisaafille yennaa dhabane. ");
INSERT INTO gax_vpl VALUES ("EX12_40","003_12_40","EXO","12","40","40","Israa'elooti woggaa dhibba afurii fi soddoma biyya Gibxi'ii keessa le'ane. ");
INSERT INTO gax_vpl VALUES ("EX12_41","003_12_41","EXO","12","41","41","Dhuma woggaa dhibba afurii fi soddomaa sanitti, kolbaan Mootii Waan Maraa marti biyya Gibxi'ii keessaa baate. ");
INSERT INTO gax_vpl VALUES ("EX12_42","003_12_42","EXO","12","42","42","Mootiin Waan Maraa halkan biyya Gibxi'ii keessaa isaan baase san waan isaan eegeef, halkan sun dhaloota Israa'elootaa mara keessatti ulfinna Mootii Waan Maraatiif kenniisaaf, Israa'elooti marti eeddoo irra buluu qaban. ");
INSERT INTO gax_vpl VALUES ("EX12_43","003_12_43","EXO","12","43","43","Mootiin Waan Maraa Muuse'ee fi Aaroniin, «Kun seerata Jila Irra Dabaramaa ti; nami ormaa sagalee Jila Irra Dabaramaa hin nyaatin; ");
INSERT INTO gax_vpl VALUES ("EX12_44","003_12_44","EXO","12","44","44","garbichi bitattane garuu haqanqabaa isa qaddaneen duuba nyaatuu dande'a. ");
INSERT INTO gax_vpl VALUES ("EX12_45","003_12_45","EXO","12","45","45","Nami keessumma'aa yookiin tajaajilaan qaxarame ammoo nyaatuu hin dande'u. ");
INSERT INTO gax_vpl VALUES ("EX12_46","003_12_46","EXO","12","46","46","«Sagalee san mana tokko keessatti nyaadha'a malee, foon san irraa tokkolle mana keessaa gad hin bayin; lafee foon sanii hin cassina'a. ");
INSERT INTO gax_vpl VALUES ("EX12_47","003_12_47","EXO","12","47","47","«Kolbaan Israa'elii marti jila tana jilifatuu qaban; ");
INSERT INTO gax_vpl VALUES ("EX12_48","003_12_48","EXO","12","48","48","Alagaan isin woliin le'u, jila Mootii Waan Maraa ulfeessiisaaf jilifattanu tana ka jilifatiisaaf barbaade, ilmaan isaa marti haqanqabaa qabatuu qaban; achiin duuba akka dhalataa biyyaa te'ee jila tanatti hirmaatuu ti. Nami haqanqabaa hin qabatin ammoo sagalee jila sanii hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("EX12_49","003_12_49","EXO","12","49","49","Seerri kun isinii fi alagaa isin woliin le'uufille tokkochuma te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX12_50","003_12_50","EXO","12","50","50","Israa'elooti marti waan Mootiin Waan Maraa Muuse'ee fi Aaron ajaje mara godhane. ");
INSERT INTO gax_vpl VALUES ("EX12_51","003_12_51","EXO","12","51","51","Mootiin Waan Maraa guyyuma san gumii kolbaa Israa'elii mara biyya Gibxi'ii keessaa baase. ");
INSERT INTO gax_vpl VALUES ("EX13_1","003_13_1","EXO","13","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX13_2","003_13_2","EXO","13","2","2","«Waan angafa te'ee dhalate mara naaf adda baasi. Israa'eloota keessatti ka gadaamessa saaqe, ka namaatii fi ka hori'iille kiyya te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX13_3","003_13_3","EXO","13","3","3","Achiin duuba Muuseen kolba'aan, «Mootiin Waan Maraa, irree jaddu'uun achi keessaa waan isin baaseef, lafa garbumma'aa, biyya Gibxi'ii keessaa guyyaa baatane kana qaabadha'a. Guyyaa kana waan uukoo qabu hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("EX13_4","003_13_4","EXO","13","4","4","Guyyaa adhaa, ji'a ‹Abiib› jedhamu keessa biyya Gibxi'ii keessaa bayaartan. ");
INSERT INTO gax_vpl VALUES ("EX13_5","003_13_5","EXO","13","5","5","Mootiin Waan Maraa lafa aananii fi dammaa ta inni isinii kenniisaaf, abbootii teessan ta duriitiif waadaa gale lafa kana'aanotaa, lafa Heetotaa, lafa Amoorotaa, lafa Hiiwotaatii fi lafa Yibusootaa sanitti yennaa galtane, ji'a kana keessa jila tana jilifattan. ");
INSERT INTO gax_vpl VALUES ("EX13_6","003_13_6","EXO","13","6","6","Guyyaa torba daabboo uukoo hin qanne nyaattanee, guyyaa torbeesso'oo ulfinna Mootii Waan Maraatiif jila jilifattan. ");
INSERT INTO gax_vpl VALUES ("EX13_7","003_13_7","EXO","13","7","7","Guyyaa torbaan kana daabboo uukoo hin qanne nyaattan; daabboon uukoo qaddu adaala lafa teessanii keessa eessalle hin jiraatin. ");
INSERT INTO gax_vpl VALUES ("EX13_8","003_13_8","EXO","13","8","8","Guyyaa san isin, ‹Kun yennaa nuuti biyya Gibxi'ii keessaa baane waan Mootiin Waan Maraa nu'uuf godhe› jettanee ilmaan teessanitti hintan. ");
INSERT INTO gax_vpl VALUES ("EX13_9","003_13_9","EXO","13","9","9","Mootiin Waan Maraa irree jadduu ifiitiin biyya Gibxi'ii keessaa waan isin baaseef, seerri Mootii Waan Maraa afaan keessanii akka hin buune, akka beessisa harka keessan irraatii fi akka yaadannoo adda keessan irraa isinii hin te'a. ");
INSERT INTO gax_vpl VALUES ("EX13_10","003_13_10","EXO","13","10","10","Seera jila tanaa eegadha'aatii guyyaa isaaf murteeffame sanitti wogguma wogga'aan jilifadha'a. ");
INSERT INTO gax_vpl VALUES ("EX13_11","003_13_11","EXO","13","11","11","«Mootiin Waan Maraa akkuma isinii fi abbootii teessan ta duriitiif waadaa gale lafa Kana'aanotaa sanitti isin galchee, yennaa isiniif kenne, ");
INSERT INTO gax_vpl VALUES ("EX13_12","003_13_12","EXO","13","12","12","ilmaan angafoota gadaamessa haadhaa saaqane mara, horii keessalle'ee kormaa fi korbeessa ka matooma dhalate Mootii Waan Maraatiif kenna'a. ");
INSERT INTO gax_vpl VALUES ("EX13_13","003_13_13","EXO","13","13","13","Harree wodala ka matooma dhalate mara ammoo buruusoo korbeessa hoole'eetiin wodadha'a; yoo wodatiisa dhaddane morma isaa cassa'a. Ilmaan teessan ta angafa dhalatte mara wodadha'a. ");
INSERT INTO gax_vpl VALUES ("EX13_14","003_13_14","EXO","13","14","14","«Hegeri ilmi keeti, ‹Wonni ati tolchitu kun maan› jedhee yoo si gaafate, tokko tokkoon keessan, ‹Mootiin Waan Maraa irree jadduu ifiitiin lafa garbumma'aa biyya Gibxi'ii keessaa nu baase. ");
INSERT INTO gax_vpl VALUES ("EX13_15","003_13_15","EXO","13","15","15","Mootichi biyya Gibxi'ii mataa jabaatee yennaa gad nu lakkisuu dide, Mootiin Waan maraa ammoo, waan angafa te'ee biyya Gibxi'ii keessatti dhalate, ka namaatii fi ka hori'ii mara ijjeese. Tanaaf horii keessaa angafa te'ee ka dhalate, kormaa fi korbeessa mara Mootii Waan Maraatiif ciincaa dhikeessinee, ilmaan angafoota ammoo wodanna› jedha'aa itti hima'a. ");
INSERT INTO gax_vpl VALUES ("EX13_16","003_13_16","EXO","13","16","16","Mootiin Waan Maraa irree jadduu ifiitiin biyya Gibxi'ii keessaa waan nu baaseef, akka beessisa harka keeti irraatii fi akka yaadannoo adda keeti irraa si'iif hin te'a jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX13_17","003_13_17","EXO","13","17","17","Mootichi biyya Gibxi'ii kolbaan akka deentuuf yennaa gad lakkise, Waaqi, «Lolli yoo isaanitti ka'e kolbaan tun yaada ifii jijjiirattee, gara biyya Gibxi'ii deebiti» jedhee waan yaadeef, karaa lafa Filisxeemotaatiin isaan hin sooressine. ");
INSERT INTO gax_vpl VALUES ("EX13_18","003_13_18","EXO","13","18","18","Tanaaf Waaqi akka kolbaan karaa lafa goomole'ee keessa dabartee gara abbaayaa diintu'uu geessu irra martee akka ideentu godhe. Israa'elootille lolaaf qophowanee, biyya Gibxi'ii keessaa bayane. ");
INSERT INTO gax_vpl VALUES ("EX13_19","003_13_19","EXO","13","19","19","Yoseef, «Waaqi dhugumaan isin hin yaadata; achiin duuba isin lafee tiyya fuudha'aa asii baya'a» jedhee Israa'eloota waan kakachiiseeruuf, Muuseen lafee Yoseefii fuudhee baye. ");
INSERT INTO gax_vpl VALUES ("EX13_20","003_13_20","EXO","13","20","20","Israa'elooti Suukootii ka'anee, irga goomolee Etaamiititti qubatane. ");
INSERT INTO gax_vpl VALUES ("EX13_21","003_13_21","EXO","13","21","21","Akka isaan halkanii fi guyyaa deemuu dande'anu, Mootiin Waan Maraa guyyaa utubaa duumensaatiin isaan sooressaa, halkan utubaa ibiddaatiin ifa isaaniif issaa isaaniin dura deeme. ");
INSERT INTO gax_vpl VALUES ("EX13_22","003_13_22","EXO","13","22","22","Guyyaa utubaan duumensaa, halkan utubaan ibiddaa kolbaa duraa yennaan dhabame hin jiru. ");
INSERT INTO gax_vpl VALUES ("EX14_1","003_14_1","EXO","14","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX14_2","003_14_2","EXO","14","2","2","«Israa'elooti deebi'anee Phiihahiirot bira, wodhakkaa Miigdoliitii fi abbaayaa diintu'uu, fuullee Ba'aal-Zefonii qarqara abbaaya'aa akka qubatanu itti himi. ");
INSERT INTO gax_vpl VALUES ("EX14_3","003_14_3","EXO","14","3","3","Mootichi Gibxi'ii, ‹Goomoleen karaa wollaalchittee, Israa'elooti joonjanee lafa keessa maran› jedhee hin herrega. ");
INSERT INTO gax_vpl VALUES ("EX14_4","003_14_4","EXO","14","4","4","Ani mataa isaa waan jabeessuuf, inni isaan hin hordofa; ani ammoo mootichaa fi loltoota isaa mara irratti ulfinna hin dhaggadha; worri Gibxi'iille akka ani Waaqa te'e kanaan beekan» jedhe. Israa'elootille akkuma isaanitti himame godhane. ");
INSERT INTO gax_vpl VALUES ("EX14_5","003_14_5","EXO","14","5","5","Kolbaan akka baqattee baate mooticha Gibxi'iititti yennaa himane, innii fi qondaaltoti isaa yaada jijjiiratanee, «Kolbaan Israa'elii nu'uuf hujiisa lakkisanee akka deemanu tolchuun keenna kun maan?» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX14_6","003_14_6","EXO","14","6","6","Maarre mootichi garreettaa ifii ka fardaan harkifamuu fi loltoota ifii qopheeffate. ");
INSERT INTO gax_vpl VALUES ("EX14_7","003_14_7","EXO","14","7","7","Inni garreettaa fardaan harkifamu ka filame dhibba jaa, garreettaa fardaan harkifamu ka worra Gibxi'ii ka dhibiille ajajjoota isaanii woliin fudhatee ka'e. ");
INSERT INTO gax_vpl VALUES ("EX14_8","003_14_8","EXO","14","8","8","Mootiin Waan Maraa mooticha mataa jabeessee, Israa'eloota irree jaddu'uun bayiisatti jiranu hordofe. ");
INSERT INTO gax_vpl VALUES ("EX14_9","003_14_9","EXO","14","9","9","Worri Gibxi'ii, abbootiin fardaa ta mootichaatii fi garreettaan fardaan harkifamu ka mootichaa, abbootiin fardaa ta dhibi'ii fi loltooti miilaa isaan hordofanee, fuullee Ba'aal-Zefonii abbaayaa diintuu qarqara, Phiihahiirot bira qubataneeranuun isaan dhaqqabane. ");
INSERT INTO gax_vpl VALUES ("EX14_10","003_14_10","EXO","14","10","10","Mootichii fi loltooti isaa isaan hordofanee akka itti dhikaatane dhagganee, Israa'elooti guddoo sodaatanee gara Mootii Waan Maraa iyyane. ");
INSERT INTO gax_vpl VALUES ("EX14_11","003_14_11","EXO","14","11","11","Isaan Muuse'een, «Biyya Gibxi'ii keessa addeen awwaalaa waan hin jirreef goomolee keessatti akka dhumannuuf as nu fiddee? Biyyaa Gibxi'ii keessaa nu baattee wonni ati nu tolchite kun maan? ");
INSERT INTO gax_vpl VALUES ("EX14_12","003_14_12","EXO","14","12","12","Nuuti biyya Gibxi'ii keessatti, ‹Goomolee keessatti du'iisaa manna, worra Gibxi'iitiif garboota teenee akka tajaajillu, nu lakkisi› ta si'iin jenne tanaafii motii?» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX14_13","003_14_13","EXO","14","13","13","Muuseelle deebisee, «Worra Gibxi'ii ka adha dhaggitanu kana deebitanee lammeessoo waan hin dhaggineef, hin sodaatina'a; jabaadha'aatii dhaabbadha'a; adha Mootiin Waan Maraa isin baasiisaaf, waan inni tolchu ilaala'a. ");
INSERT INTO gax_vpl VALUES ("EX14_14","003_14_14","EXO","14","14","14","Mootiin Waan Maraa isiniif waan loluuf itita'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX14_15","003_14_15","EXO","14","15","15","Achiin duuba Mootiin Waan Maraa Muuse'een, «Isin maaf gara kiyya iyyitan? Isaan gara duraa akka deemanu Israa'elootatti himi. ");
INSERT INTO gax_vpl VALUES ("EX14_16","003_14_16","EXO","14","16","16","Ati ammoo ulee teeti fudhadhuutii, harka keeti abbaayaa irra diriirsi; akka Israa'elooti abbaayaa keessa lafa godduu irra gamatti bu'anu, bisaan gargar kuti. ");
INSERT INTO gax_vpl VALUES ("EX14_17","003_14_17","EXO","14","17","17","Gibxooti akka Israa'eloota gula seenanu ani gadhaa isaanii hin jabeessa. Ani mootichaa fi loltoota isaa mara irratti, garreettaa fardaan harkifamuu fi abbootii fardaa ta isaa irratti ulfinna hin dhaggadha. ");
INSERT INTO gax_vpl VALUES ("EX14_18","003_14_18","EXO","14","18","18","Yennaa ani mooticha irratti, garreettaa isaa ka fardaan harkifamuu fi abbootii fardaa ta isaa irratti ulfinna dhaggadhe, worri Gibxi'ii akka ani Mootii Waan Maraa te'e hin beekan» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX14_19","003_14_19","EXO","14","19","19","Ergamaan waaqaa ka Israa'elootaan dura deemaa ture, duubatti dabaree isaaniin duuba deeme; utubaan duumensaalle duubatti dabaree dhaabbatee, ");
INSERT INTO gax_vpl VALUES ("EX14_20","003_14_20","EXO","14","20","20","worra Gibxi'iitii fi Israa'eloota odduu seenee, halkan san duudii mogguu Israa'elootaatitti ifa kennee, mogguu Gibxootaa ammoo dukkaneesse. ");
INSERT INTO gax_vpl VALUES ("EX14_21","003_14_21","EXO","14","21","21","Muuseelle harka ifii abbaayaa irra diriirse; Mootiin Waan Maraa ammoo halkan guutuu qilleensa jabaa gara aduun baatuu kaasee abbaayaa gara duubaa deebisee, bisaan gargar kutee, lafa godduu tolche. ");
INSERT INTO gax_vpl VALUES ("EX14_22","003_14_22","EXO","14","22","22","Israa'elootille bisaan middaa fi bitaa isaaniititti akka dalleya dhaka'aa te'ee dhaabbateeruun lafa godduu irra abbaayaa keessa qaxxaamurane. ");
INSERT INTO gax_vpl VALUES ("EX14_23","003_14_23","EXO","14","23","23","Worri Gibxi'iille fardoolee mootichaatiin, garreettaa isaa ka fardaan harkifamuu fi abbootii fardaa maraan isaan ari'anee, isaan gula abbaayaa odduu seenane. ");
INSERT INTO gax_vpl VALUES ("EX14_24","003_14_24","EXO","14","24","24","Yennaa latti bariite Mootiin Waan Maraa utubaa ibiddaatii fi duumensa keessaa loltoota worra Gibxi'ii gad ilaalee, akka isaan gara itti goranu wollaalanu godhe. ");
INSERT INTO gax_vpl VALUES ("EX14_25","003_14_25","EXO","14","25","25","Korboo garreettaa fardaan harkifamu ka isaanii akka dhaabbattu godhe. Worri Gibxi'iille, «Mootiin Waan Maraa isaaniif jedhee, nu worra Gibxi'ii loliisatti waan jiruuf, kowa'a Israa'eloota duraa baqanna» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX14_26","003_14_26","EXO","14","26","26","Achiin duuba Mootiin Waan Maraa Muuse'een, «Bisaan worra Gibxi'ii irra, garreettaa isaanii ka fardaan harkifamuu fi abbootii fardaa ta isaanii irra akka garagaluuf, harka keeti abbaayaarra diriirsi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX14_27","003_14_27","EXO","14","27","27","Muuseelle harka ifii abbaayaarra diriirse; abbaayaalle ganama addee ifiititti deebite. Worri Gibxi'ii isii duraa gara duubaa baqate. Mootiin Waan Maraa akka isaan abbaayaa keessatti hafanu godhe. ");
INSERT INTO gax_vpl VALUES ("EX14_28","003_14_28","EXO","14","28","28","Bisaan sun adde'etti deebi'ee garreettaa fardaan harkifamuu fi abbootii fardaa, loltoota mootichaa mara worra Israa'eloota gula gara abbaaya'aa seenane mara liqinse; isaan keessaa nami tokkolle hin hanne. ");
INSERT INTO gax_vpl VALUES ("EX14_29","003_14_29","EXO","14","29","29","Israa'elooti ammoo bisaan middaa fi bitaa isaaniititti akka dalleya dhaka'aa te'ee dhaabbateeruun lafa godduu irra abbaayaa keessa qaxxaamurane. ");
INSERT INTO gax_vpl VALUES ("EX14_30","003_14_30","EXO","14","30","30","Guyyaa san Mootiin Waan Maraa Israa'eloota harka worra Gibxi'ii jalaa baase; Israa'elootille reeffa worra Gibxi'ii ka abbaayaa qarqara ciisu dhaggane. ");
INSERT INTO gax_vpl VALUES ("EX14_31","003_14_31","EXO","14","31","31","Mootiin Waan Maraa irree jadduu ifiitiin worra Gibxi'ii irratti waan huje yennaa dhaggane, Israa'elooti Mootii Waan Maraa sodaatanee, isaa fi Muusee tajaajilaa isaatitti addatane. ");
INSERT INTO gax_vpl VALUES ("EX15_1","003_15_1","EXO","15","1","1","Achiin duuba Muuse'ee fi Israa'elooti faaruu asii gad jirtu tana Mootii Waan Maraatiif faarfatanee, «Mootiin Waan Maraa abbootii fardaatii fi fardoo isaanii abbaaya'atti naqee, ulfinna waan dhaggateef, ani isaaf hin faarfadha. ");
INSERT INTO gax_vpl VALUES ("EX15_2","003_15_2","EXO","15","2","2","Mootiin Waan Maraa jabeenna naa te'ee, akka faarfadhu na tolcheera; inni fayyinna naa te'eera. Inni Waaqa kiyya; anille isa hin leellifadha; Waaqa abbaa kiyyaa, ani isa hin saadadha. ");
INSERT INTO gax_vpl VALUES ("EX15_3","003_15_3","EXO","15","3","3","Mootiin Waan Maraa lolticha goota; Maqaan isaa Mootii Waan Maraa ti. ");
INSERT INTO gax_vpl VALUES ("EX15_4","003_15_4","EXO","15","4","4","Inni garreettaa mootichaa ka fardaan harkifamuu fi loltoota isaa abbaaya'atti naqe; qondaaltoti mootichaa worri filamane abbaayaa diintuu keessatti liqinfamane. ");
INSERT INTO gax_vpl VALUES ("EX15_5","003_15_5","EXO","15","5","5","Bisaan qileen isaan irra garagale; akka dhaka'aa abbaaya'atti gad lixane. ");
INSERT INTO gax_vpl VALUES ("EX15_6","003_15_6","EXO","15","6","6","«Ee Mootii Waan Maraa, harki keeti middichi, hunnaan arnya qaba. Ee Mootii Waan Maraa, harki keeti middichi diinota butuche. ");
INSERT INTO gax_vpl VALUES ("EX15_7","003_15_7","EXO","15","7","7","Guddinna arnya keetiitiin worra si mormu balleessite. Mufii teeti ta akka ibiddaa bobeettu itti ergitee, akka huuraa isaan muxuqi goote. ");
INSERT INTO gax_vpl VALUES ("EX15_8","003_15_8","EXO","15","8","8","Hafuura funnaan keetiitiin, bisaan tuulame. Bisaan yaa'u akka dalleya dhaka'aa dhaabbate; bisaan qile'ee abbaayaa wodhakka'atti itite. ");
INSERT INTO gax_vpl VALUES ("EX15_9","003_15_9","EXO","15","9","9","«Diinni kooree, ‹Ani isaan hin ari'a; isaan hin qaba; booji'ee karra isaanii hin qoodama; waan fedhe mara irraa hin fudhadha. Shallaagaa kiyya hin buqqifadha; harki kiyyalle isaan hin balleessa› jedhe. ");
INSERT INTO gax_vpl VALUES ("EX15_10","003_15_10","EXO","15","10","10","Ati ammoo hafuura keeti itti baafannaan, abbaayaani isaan irra garagaltee, akkuma sibiilaa bisaan jabaa keessatti liqinfamane. ");
INSERT INTO gax_vpl VALUES ("EX15_11","003_15_11","EXO","15","11","11","«Ee Mootii Waan Maraa, waaqota keessaa ka akka keetii eennu? Ka arnya woyyumma'aa qabu, ka ulfinnaan sodaatame, ka bilbaasa huju, ka akka keetii eennu? ");
INSERT INTO gax_vpl VALUES ("EX15_12","003_15_12","EXO","15","12","12","Ati harka keeti middicha diriirsitee, latti isaan liqinsite. ");
INSERT INTO gax_vpl VALUES ("EX15_13","003_15_13","EXO","15","13","13","«Ati jaalala keeti ka bara baraatiin kolbaa wodatte hin sooressita; jabeenna keetiin gara addee woyyitti'ii isaan hin geessita. ");
INSERT INTO gax_vpl VALUES ("EX15_14","003_15_14","EXO","15","14","14","Gosi biyya adda addaa dhageettee hin hollatti; worri biyya Filisxeemotaalle hin muddaman. ");
INSERT INTO gax_vpl VALUES ("EX15_15","003_15_15","EXO","15","15","15","Bulchitooti Edoomii hin bararaqan; Sooressitooti Mo'aabii sodaatanee hin romman; kolbaan Kana'aaniille hin sheephitti. ");
INSERT INTO gax_vpl VALUES ("EX15_16","003_15_16","EXO","15","16","16","Ee Mootii Waan Maraa, kolbaa teetiif haga dabartutti kolbaan ati wodatte haga dabartutti hunna irree teetiitiin isaan akka dhaka'aa hin cadhisan; bararaqii fi naasuun isaanitti hin buuti. ");
INSERT INTO gax_vpl VALUES ("EX15_17","003_15_17","EXO","15","17","17","Ee Mootii Waan Maraa, addee woyyittii teetitti Ee Gootta'a, addee harki keeti ijaare sanitti isaan galchitee, lafa teeti kooba gubbaa irratti isaan hin qubachiitta. ");
INSERT INTO gax_vpl VALUES ("EX15_18","003_15_18","EXO","15","18","18","Mootiin Waan Maraa haga bara baraa hin bulcha» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX15_19","003_15_19","EXO","15","19","19","Fardoon, garreettaan fardaan harkifamuu fi abbootii fardaa ta mootichaa abbaayaa keessa yennaa timane, Mootiin Waan Maraa bisaan abbaaya'aa isaan irra garagalchee, Israa'elooti ammoo abbaayaa keessa lafa godduu irra ideemanee qaxxaamurane. ");
INSERT INTO gax_vpl VALUES ("EX15_20","003_15_20","EXO","15","20","20","Achiin duuba Miiriyamiin raagittiin, obboleettiin Aaronii, dibbee fudhattee baatee, dubartooti martinuu dibbee dhowaa, sirbaa isii gula yaa'ane. ");
INSERT INTO gax_vpl VALUES ("EX15_21","003_15_21","EXO","15","21","21","Miiriyamille, faarfattee, isaaniin «Inni akka malee waan saadameef, Mootii Waan Maraatiif faarfadha'a. Inni fardo'oo fi abbootii fardo'oo abbaaya'atti naqeera» jette. ");
INSERT INTO gax_vpl VALUES ("EX15_22","003_15_22","EXO","15","22","22","Achiin duuba Muuseen kolbaa Israa'elii abbaayaa diintu'uu kaasee, gara lafa goomole'ee Shuur geesse. Isaan guyyaa sad bisaan adoo hin dhaggatin goomolee keessa deemane. ");
INSERT INTO gax_vpl VALUES ("EX15_23","003_15_23","EXO","15","23","23","Isaan yennaa gara Maaraa dhufane, bisaan Maaraa sun waan hadhowuuf, uniisa hin dandeenne. Tanaaf maqaan addee sanii, «Maaraa» jedhame. ");
INSERT INTO gax_vpl VALUES ("EX15_24","003_15_24","EXO","15","24","24","Maarre kolbaan, «Maan unna?» jettee Muuse'etti gungunte. ");
INSERT INTO gax_vpl VALUES ("EX15_25","003_15_25","EXO","15","25","25","Achiin duuba Muuseen gara Mootii Waan Maraa iyyee, Mootiin Waan Maraa muka tokko itti mudhise; innille muka san bisaanitti qolaansee, bisaan sun tole. Achitti Mootiin Waan Maraa seerataa fi seera isaaniif kennee, achumatti haga isaan ilaale. ");
INSERT INTO gax_vpl VALUES ("EX15_26","003_15_26","EXO","15","26","26","Inni, isaaniin, «Isin qoonqoo ana Mootii Waan Maraa ta Waaqa keessanii miidhassitanee yoo caqattane, fuula kiyya duratti waan sirrii te'e yoo tolchitane, ajaja kiyya yoo qalbeeffattane, seerata kiyya maralle yoo eegattane, dhukkuba worra Gibxi'iititti fide mara tokkolle isinitti hin fidu; ani Mootii Waan Maraa ka isin fayyisu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX15_27","003_15_27","EXO","15","27","27","Achiin duuba isaan Eliim addee maddi kudhanii lamaa fi muki meexxi'ii torbaatam jiru dhufanee, achi bisaan bira qubatane. ");
INSERT INTO gax_vpl VALUES ("EX16_1","003_16_1","EXO","16","1","1","Kolbaan Israa'elii marti biyya Gibxi'iitii bayaneen duuba, ji'a lammeesso'oo guyyaa kudhanii shaneesso'oo, Eliimii ka'anee gara goomolee Siinii ta Eliimii fi gaara Siina'aa wodhakkaa jirtuu dhufane. ");
INSERT INTO gax_vpl VALUES ("EX16_2","003_16_2","EXO","16","2","2","Kolbaan Israa'elii marti goomolee san keessatti Muuse'ee fi Aaronitti gungumanee, ");
INSERT INTO gax_vpl VALUES ("EX16_3","003_16_3","EXO","16","3","3","isaaniin, «Achi biyya Gibxi'ii keessatti okkotee foonii cinaa teennee, daabbo'oo fi foon haga feene nyaataa harka Waaqaatitti adoo dhumannee nuu woyya. Isin ammoo kolbaa duudii goomolee tana keessatti beelaan fixiisaaf as fiddane» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX16_4","003_16_4","EXO","16","4","4","Achiin duuba Mootiin Waan Maraa Muuse'een, «Kunoo ani amma sagalee ol gubbaa irraa gad isiniif roobisiisa; kolbaalle gad baatee, guyyuma guyya'aan ta guyyaa tokkoof teetu qofa guurattuu ti. Ani tanaan akka isaan ajaja kiyya eegatanu haga isaan ilaala. ");
INSERT INTO gax_vpl VALUES ("EX16_5","003_16_5","EXO","16","5","5","Guyyaa jayeesso'oo, ka qara guyyaa tokkoof guuratanu san harka lama guuratanuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_6","003_16_6","EXO","16","6","6","Maarre Muuse'ee fi Aaronille Israa'eloota maraan, «Biyya Gibxi'ii keessaa ka isin baase Mootii Waan Maraa akka te'e, galgala adhaa hin beettan; ");
INSERT INTO gax_vpl VALUES ("EX16_7","003_16_7","EXO","16","7","7","Inni gungunsuu isin isa irratti gunguntane waan dhage'eef, boru ganama ulfinna Mootii Waan Maraa hin dhaggitan; nuuti womaa moti; isa irratti gunguma'a malee, nu irratti hin gungumina'a» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX16_8","003_16_8","EXO","16","8","8","Achiin duuba Muuseen, «Mootiin Waan Maraa gungunsuu isin isa irratti gunguntane waan dhage'eef, galgala foon isin nyaattanu, ganama daabboo isin barbaaddanu mara yennaa isinii kenne, akka inni Mootii Waan Maraa te'e hin beettan. Nuuti womaa moti; isin isa irratti gunguntane malee, nu irrattii moti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_9","003_16_9","EXO","16","9","9","Achiin duuba Muuseen Aaroniin, «Kolbaa Israa'elii maraan, ‹Mootiin Waan Maraa gungunsuu teessan waan dhage'eef, fuula isaa dura dhikaadha'a› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_10","003_16_10","EXO","16","10","10","Aaron kolbaa Israa'elii maratti adoo dubbatiisatti jiruu, isaan gara goomole'ee ilaalanee, achitti ulfinni Mootii Waan Maraa duumensa keessatti mudhate. ");
INSERT INTO gax_vpl VALUES ("EX16_11","003_16_11","EXO","16","11","11","Ammalle Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX16_12","003_16_12","EXO","16","12","12","«Ani gungunsuu Israa'elootaa dhage'eera. Ati isaaniin ‹galgala adhaa dimimmisa foon hin nyaattan; ganama daabboo hin quuttan; achiin duuba ani Mootii Waan Maraa Waaqa keessan akka te'e hin beettan› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_13","003_16_13","EXO","16","13","13","Galgala san barbadi-kille dhuttee addee quttumaa guutte; ganama fixeensi adaala addee quttumaa san jiraayyu. ");
INSERT INTO gax_vpl VALUES ("EX16_14","003_16_14","EXO","16","14","14","Yennaa fixeensi bu'e, solloqqeen hephelleen dhakaa roobaa fakkaattu, diida lafa goomole'ee irratti mudhatte. ");
INSERT INTO gax_vpl VALUES ("EX16_15","003_16_15","EXO","16","15","15","Israa'elooti yennaa waan san dhaggite, maan akka te'e waan hin beenneef, «Wonni kun maan inni?» jedhanee wol gaafatane. Muuseen isaaniin, «Wonni kun akka isin nyaattanuuf, daabboo Mootiin Waan Maraa isiniif kenne. ");
INSERT INTO gax_vpl VALUES ("EX16_16","003_16_16","EXO","16","16","16","Mootiin Waan Maraa, ‹Tokko tokkoon keessan haga isiniif barbaachisu guuradha'a. Nama dunkaanii teessan keessa jiru tokko tokkoofuu Omeera tokko fuudha'a› jedhee ajajeera» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_17","003_16_17","EXO","16","17","17","Israa'elootille akkuma isaanitti himame tolchane; gariin bacaa, gariin diqquma guuratane; ");
INSERT INTO gax_vpl VALUES ("EX16_18","003_16_18","EXO","16","18","18","yennaa safaratane, ka bacaa guurrateef irraa hin hanneef; ka diqqeessee guurateefille irraa hin dhidhanne; nami tokko tokkooyyuu haguma isaaf barbaachise guurate. ");
INSERT INTO gax_vpl VALUES ("EX16_19","003_16_19","EXO","16","19","19","Achiin duuba Muuseen isaaniin, «Nami tokkolle waan guurate san boruuf hin bulfatin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_20","003_16_20","EXO","16","20","20","Te'uu malee worri gariin jecha Muuse'ee dhageettaa didee, waan guurate san irraa boruuf bulfate; wonni sun ammoo corroqottee ajootte; Maarre Muuseen isaanitti aare. ");
INSERT INTO gax_vpl VALUES ("EX16_21","003_16_21","EXO","16","21","21","Ganama ganama nami martinuu haga nyaataaf isaanii barbaachisu guuratane; yennaa aduun o'ite wonni sun baxxe. ");
INSERT INTO gax_vpl VALUES ("EX16_22","003_16_22","EXO","16","22","22","Guyyaa jayeesso'oo nami martinuu litirii lama, dachaa lama guurate; sooressitooti kolba'aa gara Muuse'ee dhufanee waan kana isatti himane; ");
INSERT INTO gax_vpl VALUES ("EX16_23","003_16_23","EXO","16","23","23","innille deebisee isaaniin, «Mootiin Waan Maraa, guyyaan boruu isaaf woyyoomee guyyaa fooraa akka te'u ajajeera; tanaaf adhuma waan bilcheeffattanu bilcheeffadha'a, waan iffeelattanulle iffeeladha'a; waan hafe haga boru ganamaatitti maffadha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_24","003_16_24","EXO","16","24","24","Isaanille akkuma Muuseen ajaje haga ganamaatitti maffatane; wonni sunille hin ajoonne yookiin hin corroqoonne. ");
INSERT INTO gax_vpl VALUES ("EX16_25","003_16_25","EXO","16","25","25","Muuseen, «Adha kanuma nyaadha'a; sababille guyyaan adhaa Sanbata guyyaa fooraa ka Mootii Waan Maraatiif woyyoome waan te'eef, waan nyaattanu kana adha tokkolle lafa irratti hin dhaggitanu. ");
INSERT INTO gax_vpl VALUES ("EX16_26","003_16_26","EXO","16","26","26","Guyyaa jaa waan nyaataa kana guuradha; guyyaan torbeesso'oo, guyyaa fooraa Sanbata ammoo wonni tokkolle hin jiraattu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_27","003_16_27","EXO","16","27","27","Te'uu malee, guyyaa torbeesso'oo san worri gariin waan nyaatanu san guuratiisaaf yaa'ane; ammoo waan tokkolle hin dhagganne. ");
INSERT INTO gax_vpl VALUES ("EX16_28","003_16_28","EXO","16","28","28","Achiin duuba Mootiin Waan Maraa Muuse'een, «Isin haga yoomii ajajaa fi seerata kiyya eegatuu diddan? ");
INSERT INTO gax_vpl VALUES ("EX16_29","003_16_29","EXO","16","29","29","Ani Mootiin Waan Maraa guyyaa fooraa Sanbata akka isiniif kenne qalbeeffadha'a; tanaaf ani gaafa guyyaa jayeesso'oo waan nyaattanu ta guyyaa lamaa isiniif kenne. Guyyaa torbeesso'oo eennulle addee jiru turuu ti malee, qe'ee ifiitii hin bayin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_30","003_16_30","EXO","16","30","30","Maarre guyyaa torbeesso'oo kolbaan foorfatte. ");
INSERT INTO gax_vpl VALUES ("EX16_31","003_16_31","EXO","16","31","31","Kolbaa Israa'elii waan nyaatanu saniin «Mannaa» jette. Wonni sun adii akka midhaan dinbilaalaa, mi'aan isaalle akka daabboo dammaan hujantee ti. ");
INSERT INTO gax_vpl VALUES ("EX16_32","003_16_32","EXO","16","32","32","Muuseen, «Mootiin Waan Maraa, ‹Biyya Gibxi'ii keessaa yennaa isin baase, lafa goomole'ee keessatti mannaa isin nyaachisaa ture kana, dhalooti dhufulle akka dhagguuf, mannaa kana irraa Omeerii tokko massa'a› jedhee ajajeera» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_33","003_16_33","EXO","16","33","33","Maarre Muuseen Aaroniin, «Okkotee fuudhiiti, mannaa litirii tokko itti naqi. Achiin duuba fuula Mootii Waan Maraa duratti, dhaloota dhufuuf massi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX16_34","003_16_34","EXO","16","34","34","Akkuma Mootiin Waan Maraa Muusee ajaje, Aaron mannaa san Saanduqa Gondooro'oo duratti masse. ");
INSERT INTO gax_vpl VALUES ("EX16_35","003_16_35","EXO","16","35","35","Israa'elooti lafa itti qubatane Kana'aan haga geyanutti woggaa afurtama mannaa nyaatane. ");
INSERT INTO gax_vpl VALUES ("EX16_36","003_16_36","EXO","16","36","36","Omeeriin tokko eefaa harka kudhan keessaa harka tokko. ");
INSERT INTO gax_vpl VALUES ("EX17_1","003_17_1","EXO","17","1","1","Kolbaan Israa'elii marti akkuma Mootiin Waan Maraa isaan ajaje goomolee «Siin» jedhantuu ka'anee, addee takka irraa gara addee takkaa adoo deddeemanuu, lafa «Refiidiim» jedhantu qubatane; addee san ammoo bisaan unanu hin jiru. ");
INSERT INTO gax_vpl VALUES ("EX17_2","003_17_2","EXO","17","2","2","Tanaaf isaan «Bisaan unnu nuuf kenni» jedhanee Muuse'etti moromaa kaasane. Muuseen deebisee, «Isin maaf moromaa natti kaachan? Mootii Waan Maraalle maaf haga ilaaltan?» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX17_3","003_17_3","EXO","17","3","3","Kolbaan ammoo akka malee dheebottee, «Nuuti, ijoolleen teennaa fi horiin keenna dheebu'uun akka dhumannuuf ati biyya Gibxi'ii keessaa nu baattee?» jedhanee Muuse'een wol dhabane. ");
INSERT INTO gax_vpl VALUES ("EX17_4","003_17_4","EXO","17","4","4","Achiin duuba Muuseen, «Ani kolbaa tana maan godha? Kunoo isaan dhaka'aan na tumiisaaf qopheeffataneeran» jedhee, gara Mootii Waan Maraa iyye. ");
INSERT INTO gax_vpl VALUES ("EX17_5","003_17_5","EXO","17","5","5","Mootiin Waan Maraa Muuse'een, «Sooressitoota kolbaa Israa'elii keessaa garii fudhadhuutii, ulee teeti ta laga Nayiliitiin dhoottelle qabadhuutii, kolba'aan dura deemi. ");
INSERT INTO gax_vpl VALUES ("EX17_6","003_17_6","EXO","17","6","6","Anille gaara Siina'aatitti rassaa irra si dura hin dhaabbadha; ati rassaa san hin dhootta; akka kolbaan untuuf, bisaan rassaa san keessaa hin burqa» jedhe. Muuseelle sooressitoota Israa'elii duratti akkasuma godhe. ");
INSERT INTO gax_vpl VALUES ("EX17_7","003_17_7","EXO","17","7","7","Israa'elooti, «Mootiin Waan Maraa nu woliin jira moo hin jiru?» jedhanee, moromaa waan kaasaneef, Muuseen maqaa addee sanii, «Mariibaa» jedhee moggaase; Mootii Waan Maraalle haga waan ilaalaneef, inni maqaa addee sanii, «Maasaa» jedhee moggaase. ");
INSERT INTO gax_vpl VALUES ("EX17_8","003_17_8","EXO","17","8","8","Amaaleqooti Refiidiim dhuttee Israa'eloota lolte. ");
INSERT INTO gax_vpl VALUES ("EX17_9","003_17_9","EXO","17","9","9","Muuseelle Iyaasu'uun, «Namoota keenna keessaa filiitii dhaqii Amaaleqoota loli. Anille ulee Waaqi akka ani bilbaasa ittiin hojjadhuuf naaf kenne qabadhee kooba gubbaa hin dhaabbadha» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX17_10","003_17_10","EXO","17","10","10","Iyaasuulle akkuma Muuseen isa ajaje dhaqee Amaaleqoota lole; Muuseen, Aaronii fi Huur kooba gubba'atti ol bayane. ");
INSERT INTO gax_vpl VALUES ("EX17_11","003_17_11","EXO","17","11","11","Yennaa Muuseen harka ifii ol kaase, Israa'elooti injifataa turte; yennaa inni harka ifii gad buufate ammoo Amaaleqooti injifataa turte. ");
INSERT INTO gax_vpl VALUES ("EX17_12","003_17_12","EXO","17","12","12","Harki Muuse'ee yennaa dadhabu, Aaronii fi Huur dhakaa fidanee isa jala keyane; innille irra tee'e. Tokko gara middaatiin, kuun gara bita'aatiin haga aduun seentutti, harki isaa akka gad hin buune kiphane. ");
INSERT INTO gax_vpl VALUES ("EX17_13","003_17_13","EXO","17","13","13","Akka kanaan Iyaasuun shallaaga'aan Amaaleqoota injifate. ");
INSERT INTO gax_vpl VALUES ("EX17_14","003_17_14","EXO","17","14","14","Achiin duuba Mootiin Waan Maraa Muuse'een, «Yennaa maraaf qaabbii akka teetu dabarsii injifannoo tanaa kitaaba maramaa kana irratti barreessi. Anille Amaaleqoota ijjumaa lafa irraa akka balleessu Iyaasu'utti himi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX17_15","003_17_15","EXO","17","15","15","Muuseen addee ciinca'aa ijaaree, «Mootiin Waan Maraa baandiraa kiyya» jedhee moggaase. ");
INSERT INTO gax_vpl VALUES ("EX17_16","003_17_16","EXO","17","16","16","Itti dabaleelle, «Harki kiyya gara barcumaa mootumma'aa ka Mootii Waan Maraa waan diriirfameeruuf, Mootiin Waan Maraa dhalootaa haga dhalootaatitti Amaaleqoota hin lola» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX18_1","003_18_1","EXO","18","1","1","Hayyichi worra Miidiya'aa Yetro, abbaan sodda'aa ka Muuse'ee, waan Mootiin Waan Maraa Muuse'ee fi kolbaa Israa'eliitiif godhe, attam akka inni biyya Gibxi'ii keessaa isaan baase dhage'e. ");
INSERT INTO gax_vpl VALUES ("EX18_2","003_18_2","EXO","18","2","3","Muuseen niitii ifii Siiforaa ifi biraa deebiseen duuba, abbaan sodda'aa ka isaa isi'ii fi ilmaan isi'ii lamaan ta isiin Muuse'eef deette gara ifii fudhate; maarre Muuseen, «Ani biyya ormaatitti alagaa te'eera» jedhee, ilma ifii angaficha, «Gershoom» jedhee maqaa baase. ");
INSERT INTO gax_vpl VALUES ("EX18_4","003_18_4","EXO","18","4","4","Ilma lammeesso'oolle, «Waaqi abbaa kiyyaa, qarqaaraa kiyya; shallaagaa mooticha Gibxi'ii jalaa na baaseera» jedhee, maqaa isaa, «Elii'ezer» jedhee baase. ");
INSERT INTO gax_vpl VALUES ("EX18_5","003_18_5","EXO","18","5","5","Abbaan sodda'aa ka Muuse'ee Yetro, niitii Muuse'eetii fi ilmaan isaa lamaan woliin goomolee keessa, gaara woyyicha bira addee inni qubateerutti, gara Muuse'ee dhaqe. ");
INSERT INTO gax_vpl VALUES ("EX18_6","003_18_6","EXO","18","6","6","Yetro, «Ani abbaan keeti ka sodda'aa Yetro, niitii teetii fi ilmaan isi'ii lamaan woliin gara keeti dhufiisatti jira» jedhee, itti erge. ");
INSERT INTO gax_vpl VALUES ("EX18_7","003_18_7","EXO","18","7","7","Maarre Muuseen abbaa soddaa ifii qophatiisaaf, gad bayee, isaaf sagadee, sunqate; isaan nageya wol fuudhanee, achiin duuba gara dunkaani'ii ol seenane. ");
INSERT INTO gax_vpl VALUES ("EX18_8","003_18_8","EXO","18","8","8","Achiin duuba Muuseen marroo waan Mootiin Waan Maraa kolbaa Israa'eliitiif jedhee, mooticha Gibxi'iitii fi kolbaa Gibxi'ii irratti huje, rakkinna karaa irratti isaan dhaqqabe mara, Mootiin Waan Maraa attam akka isaan baaselle abbaa soddaa ifiititti hime. ");
INSERT INTO gax_vpl VALUES ("EX18_9","003_18_9","EXO","18","9","9","Abbaan sodda'aa ka isaa Yetro, Mootiin Waan Maraa harka worra Gibxi'ii keessaa isaan baasiisaan, waan dansaa inni Israa'elootaaf godhe maratti gammadee, ");
INSERT INTO gax_vpl VALUES ("EX18_10","003_18_10","EXO","18","10","10","«Mootiin Waan Maraa ka harka mooticha Gibxi'iitii fi worra Gibxi'ii jalaa isin baase, ka harka worra Gibxi'ii jalaa kolbaa baase leellifamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX18_11","003_18_11","EXO","18","11","11","Worra Gibxi'ii ka Israa'eloota kooraan rakkise irratti inni waan kana waan tolcheef, akka Mootiin Waan Maraa waaqota mara caalu ani amma beeke» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX18_12","003_18_12","EXO","18","12","12","Achiin duuba abbaan sodda'aa ka Muuse'ee, kennansa gubamuu fi ciincaa dhibii Waaqaaf fide; Aaron jaarsolee Israa'elootaa mara woliin abbaa sodda'aa ka Muuse'ee woliin Waaqa duratti sagalee woyyittii san nyaatiisaaf dhufe. ");
INSERT INTO gax_vpl VALUES ("EX18_13","003_18_13","EXO","18","13","13","Guyyaa itti aanu Muuseen kolba'aaf muraa kenniisaaf tee'e; isaanille ganamaa haga galgalaatitti isa marsanee dhaabbatane. ");
INSERT INTO gax_vpl VALUES ("EX18_14","003_18_14","EXO","18","14","14","Abbaan sodda'aa ka isaa, waan inni kolba'aaf tolchiisatti jiru yennaa dhagge, «Wonni ati kolba'aaf tolchiisatti jirtu kun maan? Kolbaan tun marti ganamaa haga galgalaatitti si marsitee dhaabbattuun, ati abbaa mura'aa teetee, maaf qofi teetta?» jedhee gaafate. ");
INSERT INTO gax_vpl VALUES ("EX18_15","003_18_15","EXO","18","15","15","Muuseen deebisee abbaa sodda'aa ka ifiitiin, «Kolbaan fedha Waaqaa gaafatiisaaf, gara kiyya waan dhuttuuf, ani tana godhe. ");
INSERT INTO gax_vpl VALUES ("EX18_16","003_18_16","EXO","18","16","16","Isaan yennaa wol dhabane na bira dhufan; isaan keessaa ka dhugaa irra jiru murteessee, seerataa fi seera Waaqaa itti hima» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX18_17","003_18_17","EXO","18","17","17","Achiin duuba abbaan sodda'aa ka Muuse'ee Yetro deebisee, «Wonni ati tolchiisatti jirru dansa'aa moti. ");
INSERT INTO gax_vpl VALUES ("EX18_18","003_18_18","EXO","18","18","18","Atii fi kolbaan gara keeti dhuttulle ifi eleessiisatti jirtan; hujiin tun guddoo ulfaattu'u. Ati qofii teeti hujii tana hujuu hin dandeettu. ");
INSERT INTO gax_vpl VALUES ("EX18_19","003_18_19","EXO","18","19","19","Ani amma gorsa tokko si'iif kenna na caqasi; Waaqi si woliin jiraatuu ti. Ati kolbaa bakka bu'iitii haajaa isaanii Waaqa dura dhikeessi. ");
INSERT INTO gax_vpl VALUES ("EX18_20","003_18_20","EXO","18","20","20","Ati Seerataa fi seera Waaqaa isaan barsiisi; karaa isaan deemanuu fi waan isaan hujanu itti mudhisi. ");
INSERT INTO gax_vpl VALUES ("EX18_21","003_18_21","EXO","18","21","21","Garuu kolbaa mara keessaa namoota dandeettii qabanu, ka Waaqa sodaatanu, ka addatamummaa qabanuu fi ka safuu fudhatiisa hin jaalanne filiitii, ajajjoota kumaa, ajajjoota dhibbaa, ajajjoota shantamaa, ajajjoota kudhanii tolchii muudi. ");
INSERT INTO gax_vpl VALUES ("EX18_22","003_18_22","EXO","18","22","22","Isaan yennaa mara kolba'aaf muraa kennanuu ti; waan isaan dhibe gara keeti fidanuu ti. Waan kasoo isaanummaan murteessanuu ti. Isaan hujii waan si qarqaaranuuf, ba'aan si irraa hin sallatti. ");
INSERT INTO gax_vpl VALUES ("EX18_23","003_18_23","EXO","18","23","23","Ati yoo tana goote, Waaqille tanuma yoo si ajaje, ati hin eloottu; kolbaalle haajaa ifii guutattee gara mana ifii hin deebiti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX18_24","003_18_24","EXO","18","24","24","Maarre Muuseen gorsa abbaa sodda'aa ka ifii dhage'ee, waan inni jedhe mara godhe. ");
INSERT INTO gax_vpl VALUES ("EX18_25","003_18_25","EXO","18","25","25","Inni Israa'eloota keessaa worra dandeettii qabu filee, sooressitoota kolba'aa akka te'anu, ajajjoota kumaa, ajajjoota dhibbaa, ajajjoota shantamaatii fi ajajjoota kudhanii tolchee baallii isaaniif kenne. ");
INSERT INTO gax_vpl VALUES ("EX18_26","003_18_26","EXO","18","26","26","Isaan abbootii mura'aa te'anee kolbaa tajaajilane; haajaa isaan dhibe gara Muuse'ee fidanee, haajaa kasoo te'e ammoo ifumaaf murteessane. ");
INSERT INTO gax_vpl VALUES ("EX18_27","003_18_27","EXO","18","27","27","Achiin duuba Muuseen abbaa sodda'aa ka ifii Yetro geegessee, abbaan sodda'aa ka isaa Yetro gara biyya ifii deebi'e. ");
INSERT INTO gax_vpl VALUES ("EX19_1","003_19_1","EXO","19","1","1","Israa'elooti biyya Gibxi'ii keessaa bayanee, ji'a sadeesso'oo guyyaa tokkeesso'oo goomolee Siina'aa geyane. ");
INSERT INTO gax_vpl VALUES ("EX19_2","003_19_2","EXO","19","2","2","Isaan Refiidiimii ka'anee goomolee Siina'aa keessa, fuullee gaara Siina'aa achi qubatane. ");
INSERT INTO gax_vpl VALUES ("EX19_3","003_19_3","EXO","19","3","3","Achiin duuba Muuseen gara Mootii Waan Maraa gaaratti ol baye. Waaqille gaara gubba'aa Muusee waamee, «Sanyii Yaaqoobii, kolbaa Israa'eliitiin, ");
INSERT INTO gax_vpl VALUES ("EX19_4","003_19_4","EXO","19","4","4","‹Waan ani worra Gibxi'ii irratti godhe, akka risaan ilmoolee ifii koolaan ba'atu, isin ba'adhee gara kiyya attam akka isin fide dhaggitaneertan. ");
INSERT INTO gax_vpl VALUES ("EX19_5","003_19_5","EXO","19","5","5","Amma isin guutumatti naaf yoo ajajantane, gondooroo tiyyalle yoo eegatane, gosa biyya adda addaa mara keessaa kolbaa irra caalaa jaalatantane hin teetan. Latti duudiin tiyya teetulle, ");
INSERT INTO gax_vpl VALUES ("EX19_6","003_19_6","EXO","19","6","6","isin mootummaa hayyootaa kolbaa woyyittii naaf hin teetan› jedhi. Tun waan ati kolbaa Israa'eliititti hintu» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX19_7","003_19_7","EXO","19","7","7","Maarre Muuseen gad bu'ee jaarsolee kolba'aa waamee dubbii Mootiin Waan Maraa akka inni dubbatu isa ajaje mara isaanitti hime. ");
INSERT INTO gax_vpl VALUES ("EX19_8","003_19_8","EXO","19","8","8","Achiin duuba kolbaan marti afaan tokkochaan, «Waan Mootiin Waan Maraa jedhe mara hin tolchina» jedhanee deebisane. Maarre Muuseen waan kolbaan jette deebi'ee Mootii Waan Maraatitti hime. ");
INSERT INTO gax_vpl VALUES ("EX19_9","003_19_9","EXO","19","9","9","Mootiin Waan Maraa Muuse'een, «Ani si woliin dubbadhuun kolbaan akka dhageettu, yennaa maralle akka si'itti addattu, ani duumensa ciggaa keessa gara keeti hin dhufa» jedhe. Achiin duuba Muuseen waan kolbaan jette Mootii Waan Maraatitti hime. ");
INSERT INTO gax_vpl VALUES ("EX19_10","003_19_10","EXO","19","10","10","Mootiin Waan Maraalle Muuse'een, «Gara kolba'aa dhaqiitii adhaa fi boru isaan woyyoonsi. Woyaa ifiille akka dhiqatanu godhi; ");
INSERT INTO gax_vpl VALUES ("EX19_11","003_19_11","EXO","19","11","11","guyyaa sadeesso'oo adoo isaan dhagganuu, ani gaara Siina'aa irratti waan gad bu'uuf, guyyaa saniif qophowanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX19_12","003_19_12","EXO","19","12","12","Cinaa gaaraatitti naannessii, meessaa buusiitii, ‹Gara gaaraa akka ol hin baane yookiin irga isaa akka hin tundhe ifi eegadha'a; nami gaara san tuqe ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX19_13","003_19_13","EXO","19","13","13","Harki adoo isa hin tuqin, dhaka'aan tumamee yookiin daayaan woraanamee ijjeefamuu ti. Nami yookiin horiin yoo gaara san tuqe ijjeefamuu ti. Qoonqoon tultulla'aa adoo wol irraa hin citin, yennaa tultullaan afuufame qofa kolbaan gara gaaraa ol bawuu dandeetti› jedhii itti himi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX19_14","003_19_14","EXO","19","14","14","Achiin duuba Muuseen gaara irraa gara kolba'aa gad bu'ee, isaan woyyoonsee, woyaa ifiille akka dhiqatanu godhe. ");
INSERT INTO gax_vpl VALUES ("EX19_15","003_19_15","EXO","19","15","15","Muuseen kolba'aan, «Guyyaa sadeesso'ootiif ifi qopheeffadha'a; dubartii bira hin geyina'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX19_16","003_19_16","EXO","19","16","16","Gaafa guyyaa sadeesso'oo ganama gaara san irratti duumensi ciggaan mudhate; mandiisuun mandiite; balaqqeettiin balaqqitte; qoonqoon tultulla'aa guddoon afuufante; kolbaan addee quttumaa san jirtu marti naatee hollatte. ");
INSERT INTO gax_vpl VALUES ("EX19_17","003_19_17","EXO","19","17","17","Achiin duuba Muuseen kolbaa addee quttumaatii baasee gara Waaqaa fidee, isaanille gaara jala dhaabbatane. ");
INSERT INTO gax_vpl VALUES ("EX19_18","003_19_18","EXO","19","18","18","Waaqi ibiddaan gaara irratti waan gad bu'eef, gaarri Siina'aa aaraan gollame; aarri akka aara boolla ibiddaa keessaa bawuu, gaara san irraa aare. Gaarri sun guutumatti raafame. ");
INSERT INTO gax_vpl VALUES ("EX19_19","003_19_19","EXO","19","19","19","Qoonqoon tultulla'aalle ittuma dabalamaa dhutte. Achiin duuba Muuseen dubbate; Waaqille qoonqoo akka mandiisu'uutiin deebii kenne. ");
INSERT INTO gax_vpl VALUES ("EX19_20","003_19_20","EXO","19","20","20","Mootiin Waan Maraa qaccee gaara Siina'aa irratti gad bu'ee, gara qaccee gaaraa Muusee waame. Muuseelle ol baye. ");
INSERT INTO gax_vpl VALUES ("EX19_21","003_19_21","EXO","19","21","21","Mootiin Waan Maraalle Muuse'een, «Kolbaan ana Mootii Waan Maraa ilaaliisaaf, meessaa dabaranee, hedduun isaanii akka hin dhumanne, gad bu'ii itti gorsi. ");
INSERT INTO gax_vpl VALUES ("EX19_22","003_19_22","EXO","19","22","22","Hayyooti gara kiyya dhikaatanuuyyuu ifi adda baasuu qaban; yoo akkas hin te'in ani isaan hin adaba» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX19_23","003_19_23","EXO","19","23","23","Muuseelle Mootii Waan Maraatiin, «Ati, ‹Adaala gaara kanaatitti meessaa naqa'aatii, isa woyyoonsa'a› waan nuun jetteertuuf, kolbaan gara gaara kanaa ol bawuu hin dandeettu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX19_24","003_19_24","EXO","19","24","24","Mootiin Waan Maraalle deebisee Muuse'een, «Gad bu'iitii, Aaron woliin deebi'ii koy; hayyootii fi kolbaan ammoo gara kiyya dhufiisaaf meessaa dabaruu hin qabanu; yoo isaan dabarane, ani isaan hin adaba» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX19_25","003_19_25","EXO","19","25","25","Muuseelle gara kolba'aa gad bu'ee, waan Mootiin Waan Maraa jedhe isaanitti hime. ");
INSERT INTO gax_vpl VALUES ("EX20_1","003_20_1","EXO","20","1","1","Waaqi jechoota asii gad jiru kana mara dubbate: ");
INSERT INTO gax_vpl VALUES ("EX20_2","003_20_2","EXO","20","2","2","«Ani Mootii Waan Maraa Waaqa keeti, ka lafa garbumma'aa, biyya Gibxi'ii keessaa si baase. ");
INSERT INTO gax_vpl VALUES ("EX20_3","003_20_3","EXO","20","3","3","«Ana malee waaqota dhibii hin waaqonfatin. ");
INSERT INTO gax_vpl VALUES ("EX20_4","003_20_4","EXO","20","4","4","«Bifa waan ol-gubbaa jiruutiin yookiin waan lafa irra jiruutiin yookiin waan bisaan keessa jiruutiin, bifa waan tokkootille'een waaqa dharaa hin hujatin. ");
INSERT INTO gax_vpl VALUES ("EX20_5","003_20_5","EXO","20","5","5","Isaaniif hin sagadin; isaan hin waaqonfatinille'e. Ani Mootiin Waan Maraa Waaqi keeti Waaqa hinaatticha waan te'eef, worra na jibbu sababa cubbuu abbootii isaaniitiif, ijoollee isaanii haga dhaloota sadiitii fi afuriititti hin adaba. ");
INSERT INTO gax_vpl VALUES ("EX20_6","003_20_6","EXO","20","6","6","Worra na jaalatuu fi worra ajaja kiyya eegatu ammoo dhaloota isaanii haga dhaloota kumaatitti jaalala kiyya ka bara baraa isaanitti hin mudhisa. ");
INSERT INTO gax_vpl VALUES ("EX20_7","003_20_7","EXO","20","7","7","«Ani Mootiin Waan Maraa nama maqaa kiyya akkasumaan dhowu adabu malee waan hin lakkinneef, maqaa kiyya akkasumaan hin dhowin. ");
INSERT INTO gax_vpl VALUES ("EX20_8","003_20_8","EXO","20","8","8","«Guyyaa Sanbataa woyyoonsiisaaf qaabadhu! ");
INSERT INTO gax_vpl VALUES ("EX20_9","003_20_9","EXO","20","9","9","Guyyaa jaa elowiitii hujii teeti mara hujadhu. ");
INSERT INTO gax_vpl VALUES ("EX20_10","003_20_10","EXO","20","10","10","Guyyaan torbeesso'oo ammoo Mootii Waan Maraa Waaqa keetiif guyyaa fooraa ti; guyyaa san ati, ijoolleen teeti ta dhiiraatii fi ta durraa, tajaajiltooti teeti ta dhiiraatii fi ta durraa, horiin keetii fi nami alagaan si bira jiru marti hujii tokkolle hin hujin. ");
INSERT INTO gax_vpl VALUES ("EX20_11","003_20_11","EXO","20","11","11","Ani Mootiin Waan Maraa guyyaa jaa keessatti ol-gubbaa, lafa, abbaaya'aa fi waan isii keessa jiru mara dade; guyyaa torbeesso'oo ammoo foorfadhe; tanaaf ani Mootiin Waan Maraa guyyaa Sanbataa eebbisee woyyoonse. ");
INSERT INTO gax_vpl VALUES ("EX20_12","003_20_12","EXO","20","12","12","«Lafa ani Mootiin Waan Maraa Waaqi keeti si'iif kennu keessatti bara dheeraa akka leetu, abba'aa fi haadha teetiif ulfinna kenni. ");
INSERT INTO gax_vpl VALUES ("EX20_13","003_20_13","EXO","20","13","13","«Hin ijjeesin; ");
INSERT INTO gax_vpl VALUES ("EX20_14","003_20_14","EXO","20","14","14","«Hin gaarayyeeffatin; ");
INSERT INTO gax_vpl VALUES ("EX20_15","003_20_15","EXO","20","15","15","«Hin hatin; ");
INSERT INTO gax_vpl VALUES ("EX20_16","003_20_16","EXO","20","16","16","«Nama irratti dharaan dhugaa hin bayin; ");
INSERT INTO gax_vpl VALUES ("EX20_17","003_20_17","EXO","20","17","17","«Mana namaa hin kajeelin; haadha manaa isaa, tajaajilaa isaa, tajaajiltuu isaa, loon isaa, harree isaa, karra isaa mara hin kajeelin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX20_18","003_20_18","EXO","20","18","18","Kolbaan sun mandiisu'uu fi balaqqeettii yennaa dhaggite, tultullaa afuufamu dhageettee, gaarri aaruun yennaa dhaggite soda'aan hollattee, fagaattee dhaabbattee, ");
INSERT INTO gax_vpl VALUES ("EX20_19","003_20_19","EXO","20","19","19","Muuse'een, «Nuuti akka hin duune, Waaqi nu woliin akka dubbatu hin godhin; atinuu nu woliin dubbadhu; nuuti hin caqanna» jette. ");
INSERT INTO gax_vpl VALUES ("EX20_20","003_20_20","EXO","20","20","20","Muuseen kolbaa saniin, «Hin sodaatina'a! Sodaan Waaqaa isin bira jiraattee, cubbuu hujiisa irraa akka isin eedduuf, Waaqi haga isin ilaaliisaaf dhufeera» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX20_21","003_20_21","EXO","20","21","21","Kolbaan irraa fagaattee dhaabbatteertuun, Muuseen addee Waaqi jiru gara duumensa ciggaa dukkanowaa sanii dhikaate. ");
INSERT INTO gax_vpl VALUES ("EX20_22","003_20_22","EXO","20","22","22","Achiin duuba Mootiin Waan Maraa Muuse'een, «Ati Israa'elootaan, ‹Mootiin Waan Maraa: Ani ol-gubbaa irraa akka isinitti dubbadhe isinuu dhaggitaneertan; ");
INSERT INTO gax_vpl VALUES ("EX20_23","003_20_23","EXO","20","23","23","isin ana malee, waaqota meeti'ii fi worqii irraa hujattanee hin waaqonfatina'a. ");
INSERT INTO gax_vpl VALUES ("EX20_24","003_20_24","EXO","20","24","24","« ‹Ati addee ciinca'aa faara irraa naaf hujiitii, isa irratti kennansa gubamuu fi kennansa tokkumma'aa hoolee, re'e'ee fi loon keeti keessaa dhikeessi. Ani addee maqaa kiyya akka itti waamamu godhe san gara keeti dhufee si hin eebbisa. ");
INSERT INTO gax_vpl VALUES ("EX20_25","003_20_25","EXO","20","25","25","Ati dhaka'aan addee ciinca'aa naaf yoo ijaartu teete, meya ittiin boccu saniin waan batteessituuf, dhakaa bocameen hin ijaarin. ");
INSERT INTO gax_vpl VALUES ("EX20_26","003_20_26","EXO","20","26","26","Nafi keeti qullaa akka hin mudhanneef, yaabbannoo irra gara addee ciinca'aa tiyyatti ol hin bayin jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX21_1","003_21_1","EXO","21","1","1","Achiin duuba Mootiin Waan Maraa Muuse'een, «Seerri ati Israa'elootaaf kennitu asii gad jira: ");
INSERT INTO gax_vpl VALUES ("EX21_2","003_21_2","EXO","21","2","2","«Sanyii Ibrootaa keessaa garbicha yoo bitattane, woggaa jaa isin tajaajiluu ti. Woggaa torbeesso'oo ammoo waan tokkolle adoo hin kaffaliniif akkasumaan deemuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_3","003_21_3","EXO","21","3","3","Inni yoo qofuu dhufee jiraate, qofuma deemuu ti; inni yennaa dhufu niitii yoo qabaate ammoo, isii fudhatee deemuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_4","003_21_4","EXO","21","4","4","Yoo goottaan isaa niitii isa fuusisee, isiin ilmaan yookiin durra isaaf deetee yoo jiraate, dubartiin sunii fi ijoolleen sun ta gootta'aa te'anuu ti; namichi qofuma deemuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_5","003_21_5","EXO","21","5","5","«Garbichi sun ammoo, ‹Ani goottaa kiyya, niitii tiyyaa fi ijoollee tiyya hin jaaladha! Bilisa bawuu hin barbaadu› yoo jedhe, ");
INSERT INTO gax_vpl VALUES ("EX21_6","003_21_6","EXO","21","6","6","goottaan isaa Waaqa dura isa geessuu ti. Achiin duuba gara balbalaa yookiin gara mikikkila balbalaa geessee gurra isaa muta'aan uruu ti. Achiin duuba inni haga jiruu ifii garba isaa hin te'a. ");
INSERT INTO gax_vpl VALUES ("EX21_7","003_21_7","EXO","21","7","7","«Nami tokko intala ifii akka garbittii teetuuf yoo gurgure, isiin akka garbicha dhiiraa bilisa hin bayin. ");
INSERT INTO gax_vpl VALUES ("EX21_8","003_21_8","EXO","21","8","8","Isiin goottaa ifii ka niitii isii godhatiisaaf filate yoo gammachiisuu dhadde, inni akka isiin wodantu godhuu ti. Inni waan isi'iif hin malle waan isii irratti godheef, ormatti dabarsee isii hin gurgurin. ");
INSERT INTO gax_vpl VALUES ("EX21_9","003_21_9","EXO","21","9","9","Nami tokko akka ilmi isaa fuudhuuf garbittii yoo bitate, akkuma intala ifiititti ilaaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_10","003_21_10","EXO","21","10","10","Dubartii dhibii yoo fuusise ammoo, muttaaritti'iif sagalee, uffanaa fi waan isi'iif barbaachisu hin dhooggatin. ");
INSERT INTO gax_vpl VALUES ("EX21_11","003_21_11","EXO","21","11","11","Waan sadiin kana yoo isi'iif hin guutin, kaffaltii tokko malee deentuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_12","003_21_12","EXO","21","12","12","«Nami nama dhaanee ijjeesu, innille ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_13","003_21_13","EXO","21","13","13","Te'uu malee, inni gaadee adoo hin ijjeesin, danuu yoo teete, addee ani isaa qopheessetti baqatuu ti ");
INSERT INTO gax_vpl VALUES ("EX21_14","003_21_14","EXO","21","14","14","Nami tokko beekaa nama yoo ijjeese ammoo, addee ciincaa tiyyaatii baasa'aatii isa ijjeesa'a. ");
INSERT INTO gax_vpl VALUES ("EX21_15","003_21_15","EXO","21","15","15","«Nami abbaa ifii yookiin haadha ifii dhaanu ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_16","003_21_16","EXO","21","16","16","«Nami nama hatee gurgure yookiin isa harkalle'etti yoo dhaggame, nami hate sun ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_17","003_21_17","EXO","21","17","17","«Nami abbaa yookiin haadha ifii abaaru ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_18","003_21_18","EXO","21","18","18","«Nami wol lolee, tokkochi kaan dhakaan yookiin tuntummu'uun dhowee, nami dhowame sun adoo hin du'in taqee irra yoo ciise, ");
INSERT INTO gax_vpl VALUES ("EX21_19","003_21_19","EXO","21","19","19","ulee dhadhaabbataa yoo deddeemu teete, nami isa dhowe sun itti hin gaafatamu; te'uu malee, yennaa hujii isaa waan duraa balleesseef, nama miidhame saniif qodha kennuu ti; haga inni guutumatti fayyutti isa ilaaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_20","003_21_20","EXO","21","20","20","«Nami tokko garbicha ifii yookiin garbittii ifii ule'een dhowee yoo ijjeese, adabamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_21","003_21_21","EXO","21","21","21","Garbichi sun guyyaa tokkoon yookiin guyyaa lamaan duuba yoo fayye, garbichi sun duruu qabeenna isaa waan te'eef adabamuu hin qabu. ");
INSERT INTO gax_vpl VALUES ("EX21_22","003_21_22","EXO","21","22","22","«Namooti adoo wol lolanuu dubartii ulfaatitti bu'anee, ulfi sun irraa bayee, isiin guddoo miidhamuu dhaddulle, nami isii miidhe sun waan dhirsi isi'ii isa gaafatee fi waan abbootiin mura'aa itti murte kennuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_23","003_21_23","EXO","21","23","23","Miidham hamaa yoo te'e ammoo, qooda lubbu'uu, lubbuu; ");
INSERT INTO gax_vpl VALUES ("EX21_24","003_21_24","EXO","21","24","24","qooda ilaa, ila; qooda ilkaanii, ilkaan; qooda harkaa harka; qooda miilaa, miila; ");
INSERT INTO gax_vpl VALUES ("EX21_25","003_21_25","EXO","21","25","25","qooda gubiisaa, gubiisa; qooda mada'aa, madaa; qooda dhaaniisaa, dhaaniisa; seera jedhuun murteessi. ");
INSERT INTO gax_vpl VALUES ("EX21_26","003_21_26","EXO","21","26","26","«Nami tokko ila garbicha ifii yookiin ila garbittii ifii dhowee yoo balleesse, qodha ilaatiif garboota san bilisa baasuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_27","003_21_27","EXO","21","27","27","Ilkaan garbichaa yookiin ilkaan garbitti'ii yoo casselle, qodha ilkaaniitiif garboota san bilisa baasuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_28","003_21_28","EXO","21","28","28","«Kormi tokko dhiira yookiin dubartii takka nyaatee yoo ijjeese, kormi sun dhaka'aan tumamee ijjeefamuu ti; foon isaa ammoo hin nyaatamin; abbaan kormaa ammoo itti hin gaafatamin. ");
INSERT INTO gax_vpl VALUES ("EX21_29","003_21_29","EXO","21","29","29","Kormi sun duruu ka nama nyaatu te'ee, abbaan korma sanii akka dhooggatuuf itti himanee, inni dhooggatuu dhabee, dhiira yookiin dubartii nyaatee yoo ijjeese, kormi sun dhaka'aan tumamee ijjeefamuu ti; abbaan korma saniille ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_30","003_21_30","EXO","21","30","30","Te'uu malee, qodha akka kennu yoo gaafatame, waan itti murteeffame san kaffaliisaan lubbuu ifii wodatuu ti ");
INSERT INTO gax_vpl VALUES ("EX21_31","003_21_31","EXO","21","31","31","Kormi tokko ilma yookiin intala nyaatee yoo ijjeese, akkuma seera kanaatitti murteeffamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_32","003_21_32","EXO","21","32","32","Kormi tokko garbicha yookiin garbittii takka yoo nyaate, meetii giraama sagaltama qodha kennuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_33","003_21_33","EXO","21","33","33","«Nami tokko boolla qotee adoo hin duuchiin lakkisee, boolla san keessa qotiyyoon yookiin harreen yoo buute, ");
INSERT INTO gax_vpl VALUES ("EX21_34","003_21_34","EXO","21","34","34","nami boolla qote sun abbaa qotiyyo'ootiif yookiin abbaa harre'eetiif qodha kennu ti; qotiyyoon duute sun yookiin harreen duute sun ammoo isaaf te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_35","003_21_35","EXO","21","35","35","Kormi nama tokkoo korma nama dhibi'ii yoo ijjeese, korma jiru san gurguranee beesee itti gurguranee fi korma du'e san wol qixxee qoodatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX21_36","003_21_36","EXO","21","36","36","Te'uu malee, kormi sun ka nama nyaatu te'ee, abbaan korma sanii dhooggatuu yoo dhabe, addee korma du'e sanii korma dhibii kennuu ti; korma du'e san ammoo ifiif fudhatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_1","003_22_1","EXO","22","1","1","«Nami tokko qotiyyoo tokko yookiin hoolee hatee yoo qalate yookiin yoo gurgurate, qooda qotiyyoo tokko sanii qotiyyoo shan, qooda hoolee takkattii sanii hoolee afur kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_2","003_22_2","EXO","22","2","2","Hattichi tokko balbala cassee adoo seenuu qabamee tumamee, yoo du'e, dhiiga isaa ka dhangalaafameef gumaan hin jiru. ");
INSERT INTO gax_vpl VALUES ("EX22_3","003_22_3","EXO","22","3","3","Aduun baateen duuba yoo ijjeefame garuu, ka ijjeese sun yakkaamessa hin te'a. «Hattichi qabame sun waan hate san kaffaluu qaba; inni womaa yoo hin qabaanne teete ammoo, waan hate san kaffaliisaaf inninuu gurguramuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_4","003_22_4","EXO","22","4","4","«Horiin inni hate sun kormi yookiin hooleen yookiin harreen lubbu'uun adoo jiranuu harka isaatitti yoo dhaggamane, waan tokkoof dachaa lama kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_5","003_22_5","EXO","22","5","5","«Nami tokko horii ifii fichaa keessa yookiin oorruu woyni'ii keessa akka dheedanu gad lakkisee, midhaan nama dhibi'ii yoo nyaatane, fichaa ifii dansaa irraa yookiin oorruu woynii ifii dansaa irraa nama saniif kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_6","003_22_6","EXO","22","6","6","«Ibiddi tokko ka'ee daggala qabatee, tuulaa midhaanii yookiin midhaan fichaa keessaa yoo nyaate, nami ibidda qassiise sun gatii midhaan sanii guutuu kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_7","003_22_7","EXO","22","7","7","«Nami tokko beesee yookiin meya ifii akka isaaf massu namatti kennatee, mana nama sanii keessaa hattuun yoo hatte, hatichi sun yoo qabame dachaa lama kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_8","003_22_8","EXO","22","8","8","Hattichi sun yoo dhabame ammoo, abbaan manaa meya nama sanii akka hatee hin jirre kakatiisaaf, abbootii mura'aa dura dhikaatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_9","003_22_9","EXO","22","9","9","«Nami tokko qotiyyoo tokko, harree takka, hoolee takka, woyaa yookiin qabeenna te'e maraayyuu seera malee qabateeruun, ka dhibiin, ‹Kun kiyya› jedhee, moromaan yoo kaate, worri wol morome sun lamaanuu haajaa san abbootiin mura'aa dura dhikeessanuu ti; nami abbootiin mura'aa yakkaa itti murte sun nama saniif dachaa lama kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_10","003_22_10","EXO","22","10","10","«Nami tokko harree takka, qotiyyoo tokko, hoolee takka yookiin horii dhibiille nama bira keyateeruun horiin sun yoo du'e yookiin yoo miidhame yookiin nami adoo hin dhaggin yoo fudhatame, ");
INSERT INTO gax_vpl VALUES ("EX22_11","003_22_11","EXO","22","11","11","nami horii bira keyatane sun horii nama sanii akka fudhatee hin jirre abbootii mura'aa duratti kakatuu ti; abbaan hori'ii sunille yaada kana fudhatuu qaba; kaffaltiin hin jiraatin. ");
INSERT INTO gax_vpl VALUES ("EX22_12","003_22_12","EXO","22","12","12","Horiin sun nama bira keyatane san biraa yoo hatamee jiraate ammoo nami sun kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_13","003_22_13","EXO","22","13","13","Horii san bineensi yoo nyaatee jiraate, mirkaneessiisaaf, raqa bineensi nyaatee hafe san dhikeessuu ti; horii nyaatameef kaffaltiin hin jiraatin. ");
INSERT INTO gax_vpl VALUES ("EX22_14","003_22_14","EXO","22","14","14","«Nami tokko horii nama irraa ergifatee, horii sun adoo abbaan hori'ii sun bira hin jiraatin yoo miidhame yookiin yoo du'e, abbaan ergifate sun kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_15","003_22_15","EXO","22","15","15","Abbaan hori'ii sun yoo bira jiraate ammoo, abbaan ergifate sun hin kaffalin; horiin sun yoo kireeffamee jiraate, beeseen kira'aaf kaffalante sun gatii horii saniitiif kaffalantuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_16","003_22_16","EXO","22","16","16","«Nami tokko durra hin kadhatamin sossobee bantii isi'ii yoo balleesse, maraa isi'ii kennee isii fuudhuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_17","003_22_17","EXO","22","17","17","Abbaan isi'ii isaaf kenniisa yoo didate, nami sun goronsa banti'ii kennuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_18","003_22_18","EXO","22","18","18","«Dubartiin falfaltu ijjeefantuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_19","003_22_19","EXO","22","19","19","«Nami horii woliin rafe ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_20","003_22_20","EXO","22","20","20","«Ana Mootii Waan Maraatiif malee, nami waaqota dhibi'iif ciincaa dhikeessu ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX22_21","003_22_21","EXO","22","21","21","«Isinille biyya Gibxi'ii keessatti alagaa waan teetaneertanuuf, alagaa hin miidhina'a yookiin hin cunqursina'a. ");
INSERT INTO gax_vpl VALUES ("EX22_22","003_22_22","EXO","22","22","22","«Haadha hiyyeessaa yookiin ijoollee abba'aa fi haadha hin qanne gad hin qabina'a ");
INSERT INTO gax_vpl VALUES ("EX22_23","003_22_23","EXO","22","23","23","Isin yoo isaan gad qaddanee isaan gara kiyya iyyane, dhugumaan ani iyya isaanii hin dhage'a. ");
INSERT INTO gax_vpl VALUES ("EX22_24","003_22_24","EXO","22","24","24","Ani isinitti aaree, shallaaga'aan isin hin ijjeesa; niitiin teessan haadha hiyyeessaa hin teeti; ijoolleen teessanille ta abbaa hin qanne hin teeti. ");
INSERT INTO gax_vpl VALUES ("EX22_25","003_22_25","EXO","22","25","25","«Kolbaa tiyya keessaa nama hiyyeessaaf beesee yoo liqeessitane, akka nama dhalaan liqeessuu isatti hin te'ina'a; dhala isa hin gaafatina'a. ");
INSERT INTO gax_vpl VALUES ("EX22_26","003_22_26","EXO","22","26","26","Woyaa namaa qaddii yoo qabattane, adoo aduun hin seenin isaaf deebisa'a. ");
INSERT INTO gax_vpl VALUES ("EX22_27","003_22_27","EXO","22","27","27","Wonni inni nafa ifiitiin gollatu tana qofa waan teeteef, maan uffatee rafa ree? Yoo inni gara kiyya iyye, ani mararaa waan te'eef, isaaf hin dhage'a. ");
INSERT INTO gax_vpl VALUES ("EX22_28","003_22_28","EXO","22","28","28","«Waaqa hin faanshessina'a yookiin bulchaa kolbaa teessanii hin abaarina'a. ");
INSERT INTO gax_vpl VALUES ("EX22_29","003_22_29","EXO","22","29","29","«Midhaan haammattanee galfattanu keessaa mataa naa kenniisaaf hin rincicina'a. «Ilmaan teessan keessaa angafa naaf kenna'a. ");
INSERT INTO gax_vpl VALUES ("EX22_30","003_22_30","EXO","22","30","30","Loonii fi hoolee teessan keessalle'ee akkasuma tolcha'a; isaan guyyaa torba haadha ifii woliin turanuu ti; guyyaa saddeetesso'oo ammoo isaan naaf kenna'a. ");
INSERT INTO gax_vpl VALUES ("EX22_31","003_22_31","EXO","22","31","31","«Isin kolbaa naaf woyyoonte hin teetan; tanaaf foon horii bineensi ijjeesee sare'eef kenna'a malee hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_1","003_23_1","EXO","23","1","1","«Oduu dharaa hin odeessina'a; dharaan dhugaa bayiisaan nama yakkaamessa hin qarqaarina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_2","003_23_2","EXO","23","2","2","«Hantuu hujiisaaf namoota hedduu hin hordofina'a; addee seeraatitti namoota hedduu hordofiisaan haqa hin dassina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_3","003_23_3","EXO","23","3","3","Hiyyeessi muraa dura yennaa dhikaate, waan inni hiyyeessa te'eef isaaf hin rogina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_4","003_23_4","EXO","23","4","4","«Qotiyyoo yookiin harree diina keessanii ta balleya baddeertu yoo dhaggitane isaaf galcha'a. ");
INSERT INTO gax_vpl VALUES ("EX23_5","003_23_5","EXO","23","5","5","Harreen nama isin jibbuu fe'iisa jalatti jiddeertuun yoo dhaggitane, isa qarqaara'a malee lakkittanee irra hin dabarina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_6","003_23_6","EXO","23","6","6","«Hiyyeessi muraa dura yennaa dhikaate, haqa isaa hin dassina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_7","003_23_7","EXO","23","7","7","Ani yakkaamessa akka nama yakkaa hin qanneetitti hin laakkowu; tanaaf, waan dharaa irraa fagaadha'a; nama yakkaa hin qanne yookiin nama balchaa hin ijjeesina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_8","003_23_8","EXO","23","8","8","«Safuun ila worra akka dansaa dhagguu waan balleessituuf, jecha worra balchoole'eelle waan micciirtuuf, safuu hin fudhatina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_9","003_23_9","EXO","23","9","9","«Alagaa hin cunqursina'a; isinille biyya Gibxi'iititti alagaa waan teetaneertanuuf, waan alaga'atti dhage'amu isinuu hin beettan. ");
INSERT INTO gax_vpl VALUES ("EX23_10","003_23_10","EXO","23","10","10","«Woggaa jaa fichaa keessanitti midhaan facaafadha'aatii galfadha'a; ");
INSERT INTO gax_vpl VALUES ("EX23_11","003_23_11","EXO","23","11","11","woggaa torbeesso'oo ammoo bulcha'a malee hin qotina'a; waan achi keessaa dhaggamu worri hiyyeeyyiin kolbaa teessan keessaa nyaatanuu ti; ka isaan irraa hafe bineensi nyaatu ti. Muka woyni'ii keessanii fi muka ejersaa keessanille akkasuma godha'a. ");
INSERT INTO gax_vpl VALUES ("EX23_12","003_23_12","EXO","23","12","12","«Guyyaa jaa hujii teessan hujadha'a; qotiyyoon teessan, harreen teessan, garbi mana keessan keessatti dhalatee fi alagaan isinii huju akka foorfatanu, guyyaa torbeesso'oo ammoo hujii hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_13","003_23_13","EXO","23","13","13","«Waan ani isinitti hime kana mara hubadha'a; maqaa waaqota dhibi'ii hin waammatina'a; maqaan isaanii afaan keessanille'ee hin bayin. ");
INSERT INTO gax_vpl VALUES ("EX23_14","003_23_14","EXO","23","14","14","«Wogga'atti yennaa sad jila naaf jilifadha'a. ");
INSERT INTO gax_vpl VALUES ("EX23_15","003_23_15","EXO","23","15","15","«Jila daabboo uukoo hin uukoonnee jilifadha'a; akkuma ani isin ajaje guyyaa torbeesso'oo daabboo uukoo hin qanne nyaadha'a; ji'a biyya Gibxi'ii keessaa baatane waan te'eef, jila tana ji'a ‹Abibiib› jedhamu keessa guyyaa murteeffametti jilifadha'a. «Nami tokkolle harka duwwaa na dura hin dhikaatin. ");
INSERT INTO gax_vpl VALUES ("EX23_16","003_23_16","EXO","23","16","16","«Midhaan facaafattane ka mata'aa yennaa galfattanu, jila midhaan galfatiisaa jilifadha'a. «Dhuma wogga'aa irratti mukoota fichaa keessan keessa jiranu irraa midhaan yennaa guurattanu, jila midhaan galfatiisaa jilifadha'a. ");
INSERT INTO gax_vpl VALUES ("EX23_17","003_23_17","EXO","23","17","17","«Wogga'atti yennaa sad dhiirti marti Mootii Waan Maraa Goottaa dura dhikaattuu ti. ");
INSERT INTO gax_vpl VALUES ("EX23_18","003_23_18","EXO","23","18","18","«Dhiiga ciinca'aa ka anaaf dhikaatu woliin waan uukoo qabu hin dhikeessina'a. «Moorri yennaa jilaa kennansa ciinca'aatiif naaf dhikaatu haga bari'ii hin turin. ");
INSERT INTO gax_vpl VALUES ("EX23_19","003_23_19","EXO","23","19","19","«Waan latti isiniif baache keessaa midhaan mata'aa ka irra caalaa dansa'aa ana Mootii Waan Maraa Waaqa keessaniif dhikeessa'a. «Buruusoo re'e'ee aanan haadha isi'iitiin hin iffeelina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_20","003_23_20","EXO","23","20","20","«Kunoo, karaa irratti akka isin eeguuf, gara addee ani qopheessee akka isin fiduuf, ani ergamaa isiniin dura ergeera. ");
INSERT INTO gax_vpl VALUES ("EX23_21","003_23_21","EXO","23","21","21","Isin ifi eeggadha'a; dubbii isaalle qalbeeffadha'a. Isalle hin mormina'a; ani maqaa kiyyaan waan isa ergeef inni finqila keessan isiniif hin araaramu. ");
INSERT INTO gax_vpl VALUES ("EX23_22","003_23_22","EXO","23","22","22","Waan inni jedhe akka dansaa yoo caqattane, waan ani ajaje maralle yoo tolchitane, ani diina keessaniif diina hin te'a; worra isin mormulle hin morma. ");
INSERT INTO gax_vpl VALUES ("EX23_23","003_23_23","EXO","23","23","23","Ergamaan kiyya isiniin dura deemee gara lafa Amoorotaa, lafa Heetotaa, lafa Pheriizotaa, lafa Kana'aanotaa, lafa Hiiwotaa, lafa Yibusootaa isin hin geessa; anille isaan hin balleessa. ");
INSERT INTO gax_vpl VALUES ("EX23_24","003_23_24","EXO","23","24","24","Isin waaqota isaaniitiif hin sagadina'a yookiin isaan hin waaqonfatina'a! Hujii isaaniille gula hin deemina'a. Waaqota isaanii balleessa'a; soodduu woyyittii isaaniille caccassa'a. ");
INSERT INTO gax_vpl VALUES ("EX23_25","003_23_25","EXO","23","25","25","Ana Mootii Waan Maraa Waaqa keessan waaqonfadha'a; anille midhaanii fi bisaan keessan hin eebbisa; dhukkuballe odduu teessanii hin balleessa. ");
INSERT INTO gax_vpl VALUES ("EX23_26","003_23_26","EXO","23","26","26","Lafa teessan keessa dubartiin ulfi irraa bawu yookiin maseenti hin jiraattu; bara jiruu teessaniille hin dheeressa. ");
INSERT INTO gax_vpl VALUES ("EX23_27","003_23_27","EXO","23","27","27","«Ani diinota keessan akka na sodaatanu hin tolcha; kolbaa isin loltanu hin joonjessa; diinoti keessan marti akka isin dheetanu hin tolcha. ");
INSERT INTO gax_vpl VALUES ("EX23_28","003_23_28","EXO","23","28","28","Ani worra Hiiwotaa, worra Kana'aanotaatii fi worra Heetotaa isin duraa ari'iisaaf soonsa itti hin erga. ");
INSERT INTO gax_vpl VALUES ("EX23_29","003_23_29","EXO","23","29","29","Latti ontee bineensi akka isinitti hin bacanne, woggaa tokko keessatti isin duraa isaan hin ari'u. ");
INSERT INTO gax_vpl VALUES ("EX23_30","003_23_30","EXO","23","30","30","Haga isin hortanee lafa qabattanutti diqqeessee diqqeessee isin duraa isaan hin ari'a. ");
INSERT INTO gax_vpl VALUES ("EX23_31","003_23_31","EXO","23","31","31","«Meessaa keessan abbaayaa diintuu irraa haga abbaayaa Filisxeemotaa, goomolee irraa haga laga Efraaxiisii hin godha. Ani kolbaa lafa san keessa leetu harka keessanitti dabarsee hin kenna; isinille ifi duraa isaan hin ariitan. ");
INSERT INTO gax_vpl VALUES ("EX23_32","003_23_32","EXO","23","32","32","Isaan woliin yookiin waaqota isaanii woliin woli hin gondooratina'a. ");
INSERT INTO gax_vpl VALUES ("EX23_33","003_23_33","EXO","23","33","33","Akka isaan lafa teessan keessa le'anu hin godhina'a. Yoo akkas gootane, isaan akka isin na irratti cubbuu hujjanu hin godhan. Isin waaqota isaanii yoo waaqonfattane, tiyyoo isinitti hin teeti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX24_1","003_24_1","EXO","24","1","1","Achiin duuba Mootiin Waan Maraa Muuse'een, «Ati, Aaron, Naadaab, Abiihu'uu fi jaarsoleen Israa'elii torbaatam gara ana Mootii Waan Maraa kowa'a. Fagoo dhaabbadha'aatii sagada'a. ");
INSERT INTO gax_vpl VALUES ("EX24_2","003_24_2","EXO","24","2","2","Ati callaan na bira dhikaadhu malee, worri dhibiin na bira hin dhikaatin; kolbaalle si woliin ol hin bayin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX24_3","003_24_3","EXO","24","3","3","Muuseen dhaqee waan Mootiin Waan Maraa dubbatee fi seera isaa mara kolba'atti yennaa hime, kolbaan afaan tokkoon, «Waan Mootiin Waan Maraa jedhe mara hin goona» jettee deebitte. ");
INSERT INTO gax_vpl VALUES ("EX24_4","003_24_4","EXO","24","4","4","Achiin duuba Muuseen, waan Mootiin Waan Maraa dubbate mara barreesse. Inni guyyaa itti aanu ganama ka'ee gaara jalatti addee ciinca'aa hujee, soodduu kudhanii lama ta gosa Israa'elii kudhanii lama bakka buutu dhaabe. ");
INSERT INTO gax_vpl VALUES ("EX24_5","003_24_5","EXO","24","5","5","Achiin duuba inni Israa'eloota dargaggoota dhiiraa ergee, isaanille kennansa gubamuu fi kennansa tokkumma'aa ka Mootii Waan Maraatiif ciinceffamu dardaroota dhikeessane. ");
INSERT INTO gax_vpl VALUES ("EX24_6","003_24_6","EXO","24","6","6","Muuseelle dhiiga san gamisa fuudhee qori'itti naqee, gamisa hafe addee ciinca'aa irratti dhangalaase. ");
INSERT INTO gax_vpl VALUES ("EX24_7","003_24_7","EXO","24","7","7","Achiin duuba inni kitaaba Gondooro'oo fuudhee kolba'aaf dubbise; isaanille, «Waan Mootiin Waan Maraa jedhe mara hin goona; isaafille hin ajajanna» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX24_8","003_24_8","EXO","24","8","8","Achiin duuba Muuseen dhiiga san fuudhee kolba'atti fiffixee, «Kun dhiiga Gondooro'oo ka Mootiin Waan Maraa yennaa ajaja kana isinii kenne isin woliin gondoorate» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX24_9","003_24_9","EXO","24","9","9","Achiin duuba Muuseen, Aaron, Naadaab, Abiihu'uu fi jaarsoleen Israa'elii torbaatam gara gaaraa ol bayanee, ");
INSERT INTO gax_vpl VALUES ("EX24_10","003_24_10","EXO","24","10","10","Waaqa Israa'elii dhaggane. Miila isaatiin jala dhakaa gatii guddo'oo ka «Safiiros» jedhamu, qulqulluu akka ol-gubba'aatitti jiraayyu. ");
INSERT INTO gax_vpl VALUES ("EX24_11","003_24_11","EXO","24","11","11","Waaqi jaarsolee kolbaa Israa'elii tanatti balaa hin buunne; isaanille Waaqa dhagganee, fuula isaa duratti nyaatanee unane. ");
INSERT INTO gax_vpl VALUES ("EX24_12","003_24_12","EXO","24","12","12","Mootiin Waan Maraa Muuse'een, «Gara gaaraa, gara kiyya ol bayiitii as turi; anille dhakaa baxxicha lama ka seerrii fi ajaji qajeelfama isaaniif te'u irratti barreesse sitti hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX24_13","003_24_13","EXO","24","13","13","Achiin duuba Muuseen qarqaaraa ifii Iyaasuu woliin ka'anee, Muuseen gara gaara Waaqaa ol baye. ");
INSERT INTO gax_vpl VALUES ("EX24_14","003_24_14","EXO","24","14","14","Inni jaarsolee saniin, «Haga nuuti deebinee gara keessan dhunnutti, as tura'a; Aaronii fi Huur isin woliin waan jiranuuf, nami wol dhabu yoo jiraate isaan bira dhaquu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX24_15","003_24_15","EXO","24","15","15","Yennaa Muuseen gara gaaraa ol baye, duumensi gaara golle. ");
INSERT INTO gax_vpl VALUES ("EX24_16","003_24_16","EXO","24","16","16","Ulfinni Mootii Waan Maraa gaara Siina'aa irra bu'e; duumensi sun haga guyyaa jaa gaara gollee, guyyaa torbeesso'oo Mootiin Waan Maraa duumensa keessaa Muusee waame. ");
INSERT INTO gax_vpl VALUES ("EX24_17","003_24_17","EXO","24","17","17","Ulfinni Mootii Waan Maraa ibidda wo nyaatu fakkaatee qaccee gaaraa irratti Israa'elootatti mudhate. ");
INSERT INTO gax_vpl VALUES ("EX24_18","003_24_18","EXO","24","18","18","Achiin duuba Muuseen duumensa keessa gara gaara ol baye. Guyyaa afurtamaa fi halkan afurtama achi ture. ");
INSERT INTO gax_vpl VALUES ("EX25_1","003_25_1","EXO","25","1","1","Mootiin Waan Maraa Muuse'een ");
INSERT INTO gax_vpl VALUES ("EX25_2","003_25_2","EXO","25","2","2","«Israa'elooti kennansa akka naaf kennanu itti himi; nama fedhii ifiitiin kennansa naa fidu irraa fuudhi. ");
INSERT INTO gax_vpl VALUES ("EX25_3","003_25_3","EXO","25","3","3","Kennansi ati isaan irraa fuutu: worqii, meeti'ii fi sageettuu, ");
INSERT INTO gax_vpl VALUES ("EX25_4","003_25_4","EXO","25","4","4","woyaa bifa cuquliisaa, woyaa dhiillee, woyaa liilana diima'aatii fi woyaa quncee talba'aa, woyaa rifeensa re'e'ee, ");
INSERT INTO gax_vpl VALUES ("EX25_5","003_25_5","EXO","25","5","5","gogaa korbeessa hoole'ee ka hallame, gogaa hoolee galaanaa, muka gololchaa, ");
INSERT INTO gax_vpl VALUES ("EX25_6","003_25_6","EXO","25","6","6","zayitii ejersaa ta ifaaf teetu, uddowaa zayitii ejersaa ta dibatanutti naqanu, hixaana foolee dansa'aa, ");
INSERT INTO gax_vpl VALUES ("EX25_7","003_25_7","EXO","25","7","7","dhakaa gatii guddo'ootii fi dooqa adda addaa ka woyaa hayyumma'aa ta qomaatii fi kiisii qomaatitti naqanu. ");
INSERT INTO gax_vpl VALUES ("EX25_8","003_25_8","EXO","25","8","8","«Achiin duuba akka ani odduu isaanii jiraadhuuf, dunkaanii woyyittii naaf hujanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_9","003_25_9","EXO","25","9","9","Dunkaanii woyyittii tanaa fi meya isii keessaa mara akka ani sitti mudhisutti huji. ");
INSERT INTO gax_vpl VALUES ("EX25_10","003_25_10","EXO","25","10","10","«Saanduqa Gondooro'oo ta dheerinni isi'ii ciqilee lamaa fi wodhakka'aa, badhinni isi'ii ciqilee tokkoo fi wodhakka'aa, hojjaan isi'ii ciqilee tokkoo fi wodhakka'aa muka gololchaa irraa akka hujanu tolchi. ");
INSERT INTO gax_vpl VALUES ("EX25_11","003_25_11","EXO","25","11","11","Keessa isi'iitii fi duuba isi'ii worqii itti gonfi; roga isi'ii irra naannessiitii xiyyoo worqi'ii itti huji. ");
INSERT INTO gax_vpl VALUES ("EX25_12","003_25_12","EXO","25","12","12","Qubee worqi'ii afur hujiitii, lamaan gara tokkoon, lamaan gara kaaniin, miila isi'ii afurittuu qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX25_13","003_25_13","EXO","25","13","13","Muka gololchaa irraa danqaraa bociitii worqii itti gonfi. ");
INSERT INTO gax_vpl VALUES ("EX25_14","003_25_14","EXO","25","14","14","Danqaraa isii ittiin ba'atanu, qubeelee Saanduqa Gondooro'oo ta gama lamaaniin jirtu san keessa loosi. ");
INSERT INTO gax_vpl VALUES ("EX25_15","003_25_15","EXO","25","15","15","Danqaraan sun qubeelee Saanduqa Gondooro'oo san keessuma tee'uutii malee achi keessaa hin bayin. ");
INSERT INTO gax_vpl VALUES ("EX25_16","003_25_16","EXO","25","16","16","Achiin duuba dhakaa baxxicha lama ka ajaji irratti barreeffame ka ani si'iif kennu, saanduqa gonddooro'oo san keessa keyi. ");
INSERT INTO gax_vpl VALUES ("EX25_17","003_25_17","EXO","25","17","17","«Qadaaddaa Saanduqa Gondooro'oo ta worqi'ii, ta gumaa cubbu'uu irra keyanu ta dheerinni isi'ii ciqilee lamaa fi wodhakka'aa, badhinni isi'ii ciqilee tokkoo fi wodhakka'aa ta worqi'ii huji. ");
INSERT INTO gax_vpl VALUES ("EX25_18","003_25_18","EXO","25","18","18","Dada ol-gubba'aa ta koola qaddu lama worqii tumante irraa qaccee lama ta qadaaddaa Saanduqa Gondooro'oo irratti huji. ");
INSERT INTO gax_vpl VALUES ("EX25_19","003_25_19","EXO","25","19","19","Dada ol-gubba'aa san tokko qaccee gara tokkootitti, dada ol-gubba'aa ta lammeesso'oo qaccee garakaaniititti keyi; dada ol-gubba'aa ta koola qabanu san qaccee qadaaddaa Saanduqa Gondooro'oo lamaanittuu wolitti qassiisii tokko tolchi. ");
INSERT INTO gax_vpl VALUES ("EX25_20","003_25_20","EXO","25","20","20","Dadi ol-gubba'aa ta koola qabanu sun koola ifii ol badhifatanee qadaaddaa san irra gonbobanuu ti; fuula wolitti galanee, qadaaddaa Saanduqa Gondooro'oo san ilaalanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_21","003_25_21","EXO","25","21","21","Qadaaddaa Saanduqa Gondooro'oo san Saanduqa Gondooro'oo gubbaa keyi; dhakaa baxxicha seerri irratti barreeffame ka ani si'ii kennu sanille Saanduqa Gonddooro'oo san keessa keyi. ");
INSERT INTO gax_vpl VALUES ("EX25_22","003_25_22","EXO","25","22","22","Dada ol-gubba'aa ta koola qabanu lama ta qadaaddaa addee araara cubbu'uu ka Saanduqa Gondooro'oo irra jiranu wodhakka'atti si'iin wol dhaggee, achitti ajaja kiyya mara kolbaa Israa'eliitiif si'itti hin kenna. ");
INSERT INTO gax_vpl VALUES ("EX25_23","003_25_23","EXO","25","23","23","«Xarapheessaa dheerinni isaa ciqilee lama, badhinni isaa ciqilee tokko, hojjaan isaa ciqilee tokkoo fi wodhakka'aa muka gololchaa irraa huji. ");
INSERT INTO gax_vpl VALUES ("EX25_24","003_25_24","EXO","25","24","24","Worqii qulluu itti gonfi; roga isaa irralle naannessii worqii itti gonfi. ");
INSERT INTO gax_vpl VALUES ("EX25_25","003_25_25","EXO","25","25","25","Xiyyoo haga badhinna ganaa harkaa geettu irga isaa irratti naannessii worqii itti gonfi. ");
INSERT INTO gax_vpl VALUES ("EX25_26","003_25_26","EXO","25","26","26","Xarapheessaa saniif qubee worqi'ii afur hujiitii, addee miilli isaa afur jiranutti roga isaa afur irratti qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX25_27","003_25_27","EXO","25","27","27","Qubeeleen afur sun danqaraa xarapheessaa ittiin ba'atanu akka qaddu, xiyyoo san biratti dhikaatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_28","003_25_28","EXO","25","28","28","Danqaraa muka gololchaa irraa huji; worqii itti gonfiittii xarapheessaa san ittiin ba'adhu. ");
INSERT INTO gax_vpl VALUES ("EX25_29","003_25_29","EXO","25","29","29","Waan daadhii woyni'ii ittiin dhikeessanu gabataa, qorii, kobolaa fi muduunuu worqii qullittii irraa huji. ");
INSERT INTO gax_vpl VALUES ("EX25_30","003_25_30","EXO","25","30","30","Daabboo na dura dhikaattu yennaa mara fuula kiyya dura xarapheessaa kana irra keyi. ");
INSERT INTO gax_vpl VALUES ("EX25_31","003_25_31","EXO","25","31","31","«Waan issaa irra keyanu worqii qullittii irraa huji. Miila isaa, ulee isaa, muduunuu daraaraa fakkaattu, guntuta daraara'aatii fi daraaraa seesaa waan ifa irra keyanu san woliin wolitti qassiisii tokko tolchii huji. ");
INSERT INTO gax_vpl VALUES ("EX25_32","003_25_32","EXO","25","32","32","Waan issaa irra keyanu kana irratti dameelee jaa, gara tokkoon sad, gara kaaniin sad huji. ");
INSERT INTO gax_vpl VALUES ("EX25_33","003_25_33","EXO","25","33","33","Dameelee jaanuu, tokko tokkoo isaanii irratti muduunuun daraaraa muka ‹Almond› jedhamuu fakkaattu ta seesa guntuta daraara'aatii fi seesa daraara'aa qaddu sad jiraatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_34","003_25_34","EXO","25","34","34","Waan issaa irra keyanu san irra, muduunuun daraaraa muka ‹Almond› jedhamu fakkaattu afur ta seesa guntuta daraara'aatii fi seesa daraara'aa qaddu jiraatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_35","003_25_35","EXO","25","35","35","Dameelee waan issaa irra keyanuu lamaan karaa jalaa guntuti daraara'aa tokko, dameelee lamaan lammeesso'oo jala guntuti daraara'aa ka lammeesso'oo, dameelee lamaan sadeesso'oo jala guntuti daraara'aa ka sadeesso'oo jiraatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_36","003_25_36","EXO","25","36","36","Guntuti daraara'aatii fi dameeleen sun martinuu waan issaa irra keyanu san woliin wolitti qassiifamanee tokko te'anee, worqii qullittii irraa hujamanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_37","003_25_37","EXO","25","37","37","«Akka issaan addee waan issaa irra keyanu duraatiif ifa kennanu, issaa torba hujiitii, waan issaa irra keyanu san irra keyi. ");
INSERT INTO gax_vpl VALUES ("EX25_38","003_25_38","EXO","25","38","38","Qarapha'aa fi qoriin daadha'aa worqii qullittii irraa hujamanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_39","003_25_39","EXO","25","39","39","Wonni ifa irra keyanuu fi mey isi'ii marti worqii qullittii kiiloogiraama soddomii shaniin hujamanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX25_40","003_25_40","EXO","25","40","40","Akka ani gaara irratti sitti mudhise sanitti ilaalii huji. ");
INSERT INTO gax_vpl VALUES ("EX26_1","003_26_1","EXO","26","1","1","«Dunkaanii Woyyittii, gollaa haadaa qoola kudhan: liilana quncee talba'aa dansaa, liilana bifa cuquliisaa, liilana bifa dhiille'eetii fi liilana diimaa irraa wolitti fowantee dhowateen huji. Nami hujii harkaa beeku, fakkii dada ol-gubba'aa ta koola qadduu irratti hujuu ti. ");
INSERT INTO gax_vpl VALUES ("EX26_2","003_26_2","EXO","26","2","2","Gollaan haadaa sun tokko tokkoon isaa dheerinni ciqilee diddamii saddeeti badhinni ciqilee afur, marti isaaniituu wol qixa te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("EX26_3","003_26_3","EXO","26","3","3","Qoola woya'aa san shanan wolitti hodhi; shanan hafane kaanille akkasuma tolchi. ");
INSERT INTO gax_vpl VALUES ("EX26_4","003_26_4","EXO","26","4","4","Irga qoola woya'aa ka wolitti hodhantee sanitti qubeelee bifa cuquliisaa itti naqi. Qoola woya'aa ta wolitti hodhante ta gama kaanii irralle'etti akkasuma tolchi. ");
INSERT INTO gax_vpl VALUES ("EX26_5","003_26_5","EXO","26","5","5","Irga qoola woya'aa ka wolitti hodhamanee ka qaraatitti qubeelee shantama, ka lammeesso'oo irralle'etti qubeelee shantama, ta moggaa gama lamaaniituu fuullee wolitti galchii itti naqi. ");
INSERT INTO gax_vpl VALUES ("EX26_6","003_26_6","EXO","26","6","6","Achiin duuba Dunkaaniin Woyyittiin takkattii akka teetu, qoola woya'aa ta wolitti hodhamane san wolitti qassiisiisaaf hookkoo worqi'ii shantama huji. ");
INSERT INTO gax_vpl VALUES ("EX26_7","003_26_7","EXO","26","7","7","«Dunkaanii Woyyittii san akka gollanuuf, gollaa rifeensa re'e'ee irraa hujame kudhanii tokko huji. ");
INSERT INTO gax_vpl VALUES ("EX26_8","003_26_8","EXO","26","8","8","Gollaan kudhanii tokko sun tokko tokkoon isaaniituu dheerinni isaanii ciqilee soddoma, badhinni isaanii ciqilee afur, marti isaaniituu wol qixa te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("EX26_9","003_26_9","EXO","26","9","9","Gollaa shanan wolitti qassiisii hodhi; jaan hafane kaanille gara kaaniin wolitti qassiisii hodhi. Gollaa jayeesso'oo Dunkaanii Woyyittii fuula duraan irra dachaasi. ");
INSERT INTO gax_vpl VALUES ("EX26_10","003_26_10","EXO","26","10","10","Irga gollaa wolitti hodhamane ka qaraatitti qubeelee shantama, ka lammeesso'oo irralle'etti qubeelee shantama itti hodhi. ");
INSERT INTO gax_vpl VALUES ("EX26_11","003_26_11","EXO","26","11","11","Hookkoo sageettu'uu shantama hujiitii, gollaa gama lamaanii san wolitti qassiisiisaan Dunkaanii Woyyittii takkattii akka teetu hookkoo san qubeelee shantama san keessa galchi. ");
INSERT INTO gax_vpl VALUES ("EX26_12","003_26_12","EXO","26","12","12","Gollaan Dunkaanii Woyyitti'ii irraa hafe gamsi isaa gara duubaatiin gad rarra'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX26_13","003_26_13","EXO","26","13","13","Gara dheerinnaatiin, gollaan hafe gara lamaaniinuu, ciqileen tokko tokko Dunkaanii Woyyittii irra gad rarra'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX26_14","003_26_14","EXO","26","14","14","Gogaa korbeessa hoole'ee ka hallame irraa Dunkaanii Woyyittii saniif irbuusa huji; ka dhibiille gogaa hoolee galaanaa irraa hujiitii irra buusi. ");
INSERT INTO gax_vpl VALUES ("EX26_15","003_26_15","EXO","26","15","15","«Mikikkiloota Dunkaanii Woyyittii ol dhaabbachiisanu muka gololchaa irraa huji. ");
INSERT INTO gax_vpl VALUES ("EX26_16","003_26_16","EXO","26","16","16","Dheerinni mikikkiloota sanii ciqilee kudhan, badhinni isaanii ciqilee tokkoo fi wodhakkaa te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("EX26_17","003_26_17","EXO","26","17","17","Mikikkilooti Dunkaanii Woyyitti'ii sun akka wol keessa seenanu qaccee irratti gaafa lama ka cinaa wolii jiru huji; akka kanaan mikikkiloota Dunkaanii Woyyitti'ii mara huji. ");
INSERT INTO gax_vpl VALUES ("EX26_18","003_26_18","EXO","26","18","18","Dunkaanii Woyyittii cinaa gara kibbaatiif mikikkiloota diddama huji. ");
INSERT INTO gax_vpl VALUES ("EX26_19","003_26_19","EXO","26","19","19","Mikikkiloota diddama saniif shafee meetii irraa hujante afurtama huji; gaafoti lama ka mikikkila tokkoo akka keessa seenanuuf shafee lama lama huji. ");
INSERT INTO gax_vpl VALUES ("EX26_20","003_26_20","EXO","26","20","20","Dunkaanii Woyyittii san cinaa gara kaabaatiif mikikkiloota diddama huji. ");
INSERT INTO gax_vpl VALUES ("EX26_21","003_26_21","EXO","26","21","21","Mikikkiloota diddama saniif, shafee meetii irraa hujante afurtama hujiitii, mikikkila tokko tokko jala shafee lama lama keyi. ");
INSERT INTO gax_vpl VALUES ("EX26_22","003_26_22","EXO","26","22","22","Dunkaanii Woyyittii cinaa gara aduun seentuutiif mikikkila jaa huji. ");
INSERT INTO gax_vpl VALUES ("EX26_23","003_26_23","EXO","26","23","23","Roga irga irgaatiif mikikkila lama lama huji. ");
INSERT INTO gax_vpl VALUES ("EX26_24","003_26_24","EXO","26","24","24","Roga lamaan kana irratti mikikkilooti kun jalaa haga gubba'aatitti lama lama te'anee, qubee takkattii keessa seenuu qaban. Gara lamaaniinuu akkasuma te'uu qaba. ");
INSERT INTO gax_vpl VALUES ("EX26_25","003_26_25","EXO","26","25","25","Maarre mikikkiloota saddeetii fi shafee meetii irraa hujante kudhanii jaatti achi jira; mikikkila tokko tokkoofuu shafee lama lamatti itti keyama. ");
INSERT INTO gax_vpl VALUES ("EX26_26","003_26_26","EXO","26","26","26","«Muka gololchaa irraa danqaraa shanan mikikkiloota cinaa gara tokkootiif, ");
INSERT INTO gax_vpl VALUES ("EX26_27","003_26_27","EXO","26","27","27","shan mikikkiloota cinaa gara kaaniitiif, shanan hafane mikikkiloota gara seensa adu'uu jiranuuf huji. ");
INSERT INTO gax_vpl VALUES ("EX26_28","003_26_28","EXO","26","28","28","Danqaraan wodhakka'aa, mikikkiloota wodhakkaa cinaa kaan irraa haga cinaa gara kaaniititti fulla'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX26_29","003_26_29","EXO","26","29","29","Mikikkiloota san worqii itti gonfi; danqarooti sun akka keessa seenanu qubeelee worqi'ii huji; danqaroota sanille worqii itti gonfi. ");
INSERT INTO gax_vpl VALUES ("EX26_30","003_26_30","EXO","26","30","30","«Dunkaanii Woyyittii san akka ani gaara irratti sitti mudhise sanitti dhaabi. ");
INSERT INTO gax_vpl VALUES ("EX26_31","003_26_31","EXO","26","31","31","«Gollaa liilana quncee talba'aa dansaa ka bifa cuquliisaa, ka bifa dhiille'eetii fi diimaa irraa wolitti fowamee dhowanteen huji. Nami hujii harkaa beeku, fakkii dada ol-gubba'aa ta koola qadduu irratti hujuu ti. ");
INSERT INTO gax_vpl VALUES ("EX26_32","003_26_32","EXO","26","32","32","Hookkoo worqii irraa hujame ka utuboota muka gololchaa ka worqiin itti gonfanteertu irra jiranu irratti fannisiitii, shafee meetii irraa hujame irra dhaabi. ");
INSERT INTO gax_vpl VALUES ("EX26_33","003_26_33","EXO","26","33","33","Gollaa san hookkota san irratti fannis. Saanduqa Gondooro'oo gollaa san gara duubaatiin keyi; Gollaan sun addee irra caalaa woyyitti'ii fi addee woyyittii gargar qooda. ");
INSERT INTO gax_vpl VALUES ("EX26_34","003_26_34","EXO","26","34","34","Qadaaddaa addee gumaa cubbu'uu, Saanduqa Gondooro'oo ka Addee Irra Caalaa Woyyittii san keessa jiru irra keyi. ");
INSERT INTO gax_vpl VALUES ("EX26_35","003_26_35","EXO","26","35","35","Xarapheessaa addee irra caalaa woyyitti'iin ala Dunkaanii Woyyittii keessa gara kaabaatiin keyiitii, waan issaa irra keyanu fuullee isaa gara kibbaatiin keyi. ");
INSERT INTO gax_vpl VALUES ("EX26_36","003_26_36","EXO","26","36","36","«Seensuma Dunkaanii Woyyitti'iitiif, gollaa liilana quncee talba'aa dansaa ka bifa cuquliisaa, ka bifa dhiille'eetii fi diimaa irraa nama hujii harkaa beekuun wolitti fowamee dhowame keyi. ");
INSERT INTO gax_vpl VALUES ("EX26_37","003_26_37","EXO","26","37","37","Gollaa kanaaf hookkoo worqi'iitii fi utubaa muka gololchaa shan ka worqii itti gonfame huji. Utuboota kanaaf shafee sageettu'uu shan tumi. ");
INSERT INTO gax_vpl VALUES ("EX27_1","003_27_1","EXO","27","1","1","«Addee ciinca'aa muka gololchaatiin ijaari. Dheerinni isi'ii ciqilee shan, badhinni isi'iille ciqilee shan, hojjaan isi'ii ciqilee sad te'uu ti. Cinaan isi'ii martinuu wol qixxee te'uu qaban. ");
INSERT INTO gax_vpl VALUES ("EX27_2","003_27_2","EXO","27","2","2","Gaafotii fi addeen ciinca'aa tokko akka te'anu roga isi'ii arfanuu irratti gaafota itti baasiitii, sageettuu itti gonfi. ");
INSERT INTO gax_vpl VALUES ("EX27_3","003_27_3","EXO","27","3","3","Okkotee daadhaa itti haranu, waan ibidda irratti bobeessanu, qorii dhiiga fiffixanu qabattu, filaa foonii sageettuu irraa huji. ");
INSERT INTO gax_vpl VALUES ("EX27_4","003_27_4","EXO","27","4","4","Waan akka meemme'ee ka cilee qabatee daadhaa gad harcaasu sageettuu irraa itti huji; roga waan akka meemme'ee san arfanuu irratti qubeelee sageettu'uu itti huji. ");
INSERT INTO gax_vpl VALUES ("EX27_5","003_27_5","EXO","27","5","5","Haga hidha addee ciinca'aa ol akka dheerattu, waan akka meemme'ee san xiyyoo isi'ii jala keyi. ");
INSERT INTO gax_vpl VALUES ("EX27_6","003_27_6","EXO","27","6","6","Addee ciinca'aa san akka ittiin ba'atanu, danqaraa muka gololchaa hujiitii sageettuu itti gonfi. ");
INSERT INTO gax_vpl VALUES ("EX27_7","003_27_7","EXO","27","7","7","Yennaa addee ciinca'aa san ba'atanu danqaroota gama lamaan qubeelee san keessa loosi. ");
INSERT INTO gax_vpl VALUES ("EX27_8","003_27_8","EXO","27","8","8","Akkuma ani gaara irratti sitti mudhise sanitti, addee ciinca'aa falaxaa irraa boollessii huji. ");
INSERT INTO gax_vpl VALUES ("EX27_9","003_27_9","EXO","27","9","9","«Badhinna Dunkaanii Woyyitti'iititti dalleya ijaari; dalleenni sun gollaa quncee talba'aa dansaa irraa fowamee hujame qabaatuu ti; dalleenni sun gara kibbaatiin ciqilee dhibba dheeratee, ");
INSERT INTO gax_vpl VALUES ("EX27_10","003_27_10","EXO","27","10","10","utuboota shafee sageettu'uu qabu diddama ka hookko'oo fi qubeelee meetii irraa hujamane ifi irraa qabu qabaatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_11","003_27_11","EXO","27","11","11","Gara kaabaatille'een akkuma kana ciqilee dhibba dheeratee, utuboota shafee sageettu'uu qabu diddama ka hookko'oo fi qubeelee meetii irraa hujamane ifi irraa qabu qabaatuun hujamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_12","003_27_12","EXO","27","12","12","«Badhinni dalleya keessaa sun gara seensa adu'uutiin, ciqilee shantama badhatee, golla'aa fi utuboota kudhan shafee kudhan qabanu qabaatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_13","003_27_13","EXO","27","13","13","Dhuma gara ila boru'uu, karaa aduun baatuun, ciqilee shantama badhatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_14","003_27_14","EXO","27","14","14","Dheerinni golla'aa seensuma irraa gara tokkoon ciqilee kudhanii shan te'ee, utuboota sad ka shafee sad qabanu qabaatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_15","003_27_15","EXO","27","15","15","Akkasuma seensuma irraa gara kaaniin dheerinni golla'aa ciqilee kudhanii shan te'ee, utuboota sad ka shafee sad qabanu qabaatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_16","003_27_16","EXO","27","16","16","«Seensuma gara badhinna dalleya keessaa ka Dunkaanii Woyyitti'ii saniif, gollaa ciqilee diddama dheeratu, ka liilana quncee talba'aa dansaa ka bifa cuquliisaa, ka bifa dhiille'eetii fi diimaa irraa nama hujii harkaa beekuun wolitti fowamee dhowame, utuboota afur ka shafee afur qabanu qopheessi. ");
INSERT INTO gax_vpl VALUES ("EX27_17","003_27_17","EXO","27","17","17","Utubooti naannoo badhinna dalleya keessaa sanii marti qubeelee meetii irraa hujante, hookko'oo fi shafeelee sageettuu irraa hujante qabaatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_18","003_27_18","EXO","27","18","18","Dheerinni badhinna dalleya keessaa sun ciqilee dhibba, badhinni isaa ciqilee shantama te'uu ti; gollaa quncee talba'aa dansaa irraa hujame ka hojjaan isaa ciqilee shaniitii fi shafee meetii irraa hujamane qabu te'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_19","003_27_19","EXO","27","19","19","Mey Dunkaanii Woyyittii keessatti tajaajila adda addaa kennu marti, chikaalli Dunkaanii Woyyitti'iitii fi chikaalli badhinna dalleya keessaa marti ka sageettuu irraa hujamane te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("EX27_20","003_27_20","EXO","27","20","20","«Ifi yennaa mara akka ifu, Israa'elooti zayitii ejersaa qulluu akka sii fidanu ajaji. ");
INSERT INTO gax_vpl VALUES ("EX27_21","003_27_21","EXO","27","21","21","Aaronii fi ilmaan isaa Dunkaanii Woldeenna'aa keessatti, gollaa Dunkaanii Dhugaa Bayaa fuula dura jiruun alatti ifi galgalaa haga ganamaatitti ana Mootii Waan Maraa duratti akka ifu godhanuu ti. Kun Israa'eloota oddu'utti dhaloota dhufuuf seerata bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_1","003_28_1","EXO","28","1","1","«Hayyoota te'anee akka na tajaajilanu, kolbaa Israa'elii keessaa obboleessa keeti Aaron, ilmaan isaa Naadaab, Abiihuu, Ele'azaar fi Itaamaar woliin gara keeti dhikeessi. ");
INSERT INTO gax_vpl VALUES ("EX28_2","003_28_2","EXO","28","2","2","Kabajja'aa fi ulfinna isaatiif, obboleessa keeti Aaroniif woyaa woyyumma'aa huji. ");
INSERT INTO gax_vpl VALUES ("EX28_3","003_28_3","EXO","28","3","3","Maarre akka inni hayyicha te'ee na tajaajilu, isa adda baasiisaaf, Aaroniif woyaa akka hujanu, worra ani ogummaa kenneeruuf maratti himi. ");
INSERT INTO gax_vpl VALUES ("EX28_4","003_28_4","EXO","28","4","4","Woyaan isaan hujanu: kiisii qomaa, woyaa hayyumma'aa ta qomaa, qoloo, qoloo haga miilaa dheerattu, marata mata'aatii fi hiitu'u. Obboleessi keeti Aaronii fi ilmaan isaa hayyoota te'anee akka na tajaajilanu, woyaa woyyumma'aa isaaniif hujanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_5","003_28_5","EXO","28","5","5","Isaan woyaa san worqii, liilana bifa cuquliisaa, ka bifa dhiille'ee, ka bifa diimaa ka quncee talba'aatiin hujanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_6","003_28_6","EXO","28","6","6","«Worri hujii harkaa beeku sun woyaa hayyumma'aa ta qomaa worqi'iin, liilana quncee talba'aa dansaa ka bifa cuquliisaatiin, ka bifa dhiille'eetiin, ka bifa diima'aa ka wolitti fowameen hujanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_7","003_28_7","EXO","28","7","7","Gurmuu lamaan irra hiituu lama ta qaccee duraa fi duubaa lama wolitti hiitu qabaattuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_8","003_28_8","EXO","28","8","8","Hiituun worra hujii harkaa beekuun hujante sun, akkuma woyaa hayyumma'aa ta qomaa san worqi'iin, liilana bifa cuquliisaatiin, ka bifa dhiille'eetiin, ka bifa diima'aa ka quncee talba'aa dansa'aan wolitti fowantee hujantee, woyaa hayyumma'aa ta qomaa woliin tokko teetee, wolitti qassiifantee hujantuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_9","003_28_9","EXO","28","9","9","«Ati dhakaa gatii guddo'oo lama fuudhiitii, maqaa ijoollee Yaaqoobii kudhanii lamaa irratti qiriixi; ");
INSERT INTO gax_vpl VALUES ("EX28_10","003_28_10","EXO","28","10","10","akkuma tarree dhaloota isaaniititti, dhakaa tokkocha irratti maqaa jaa, ka hafe jaan dhakaa kaan irratti qiriixi. ");
INSERT INTO gax_vpl VALUES ("EX28_11","003_28_11","EXO","28","11","11","Akkuma nama chaappaa qiriixuu atille maqaa ijoollee Yaaqoobii dhakaa lamaan san irratti qiriixi; achiin duuba dhakoota san, seesa xiyyoo worqi'ii ka daraaraa fakkaatu keessa galchi. ");
INSERT INTO gax_vpl VALUES ("EX28_12","003_28_12","EXO","28","12","12","Yaadannoo ijoollee Yaaqoobii akka te'u, dhakaa lamaan san, fannoo woyaa hayyumma'aa ta qomaa irratti qassiisi. Ani Mootiin Waan Maraa yennaa mara kolbaa tiyya akka yaadadhu, Aaron maqaa isaanii gurmuu ifii irratti ba'atuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_13","003_28_13","EXO","28","13","13","Ati xiyyoo seesa worqi'ii ta daraaraa fakkaattu hujiitii, ");
INSERT INTO gax_vpl VALUES ("EX28_14","003_28_14","EXO","28","14","14","haachaba worqii qullu'uu, ka akka wodaro'oo fowame lama hujiitii, xiyyoo seesa worqi'ii ka daraaraa fakkaatu saniin wolitti qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX28_15","003_28_15","EXO","28","15","15","«Kiisii qomaa ta mey fedha kiyya ittiin gaafatanu keessa tee'u, akka nami hujii harkaa beeku huju huji. Akkuma woyaa hayyumma'aa ta qomaa worqi'iin, liilana bifa cuquliisaatiin, ka bifa dhiille'eetiin, ka bifa diima'aa ka quncee talba'aa dansa'aan wolitti fowantee dhowantee san huji. ");
INSERT INTO gax_vpl VALUES ("EX28_16","003_28_16","EXO","28","16","16","Kiisiin sun dheerinni isi'ii taakkuu tokko, badhinni isi'iille taakkuu tokko teetee, dachaafantee rogi isi'ii arfanuu wolqixa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_17","003_28_17","EXO","28","17","17","Achiin duuba isii irratti dhakaa gatii guddo'oo tarree afuriin itti maxxansi; tarree qaraatitti dhakaan gatii guddo'oo saardiyon, tophaaziyon fi simaaragidos, ");
INSERT INTO gax_vpl VALUES ("EX28_18","003_28_18","EXO","28","18","18","tarree lammeesso'ootitti kaarbunkil, safiirosii fi Yaasphis, ");
INSERT INTO gax_vpl VALUES ("EX28_19","003_28_19","EXO","28","19","19","tarree sadeesso'ootitti Hiiyaakinxos, kaalqedon, ametiisxos, ");
INSERT INTO gax_vpl VALUES ("EX28_20","003_28_20","EXO","28","20","20","tarree arfeesso'ootitti kirisoliixos, sardoniikis fi beerilos seesa xiyyoo worqi'ii ta daraaraa fakkaattuun itti maxxansi. ");
INSERT INTO gax_vpl VALUES ("EX28_21","003_28_21","EXO","28","21","21","Gosa Israa'elii kudhanii lamaaf qaabbii akka te'u, dhakoota gatii guddo'oo kudhanii lamaan san irratti, maqaan ilmaan Yaaqoobii kudhanii lamaa ka tokko tokkootuu akka chaappa'aa irratti qiriixamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_22","003_28_22","EXO","28","22","22","«Kiisii qomaa saniif seesa haachaba worqii qullu'uu, ka akka wodaro'oo fowame huji. ");
INSERT INTO gax_vpl VALUES ("EX28_23","003_28_23","EXO","28","23","23","Qubeelee worqi'ii lama hujiitii roga kiisii qomaa san lamaanitti qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX28_24","003_28_24","EXO","28","24","24","Seesa haachaba worqii qullu'uu lamaan san, qubeelee lama ta roga kiisii qomaa irra jirtu saniin wolitti qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX28_25","003_28_25","EXO","28","25","25","Qaccee seesa haachabootaa san lamaan, hiituu woyaa hayyumma'aa ta qomaa ta gara duraatiin jirtu ta gurmuu irra qaxxaamurtu keessa galchiitii, xiyyoo seesa worqi'ii lama ta daraaraa fakkaatu saniin wolitti qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX28_26","003_28_26","EXO","28","26","26","Qubeelee worqi'ii lama hujiitii, roga lama ka kiisii qomaa ka dhibi'iititti, qaccee kiisii qomaa ta gara keessaa ta woyaa hayyumma'aatitti aantee jirtutti qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX28_27","003_28_27","EXO","28","27","27","Ammalle qubeelee worqi'ii ta dhibii lamaan hujiitii, gara duraatiin, hiituu woyaa hayyumma'aa ta qomaa ta gurmuu irra qaxxaamurtu gara jalaatiin addee hiituun woyaa hayyumma'aa ta qomaa wolitti hodhanteertuun gubba'atti qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX28_28","003_28_28","EXO","28","28","28","Qubeelee kiisii qomaa irra jirtu, kiisiin qomaa woyaa hayyumma'aa ta qomaatiin akka wol gad hin lakkinne, hiitu'uun wolitti qassiisiisaan, liilana bifa cuquliisaatiin qubeelee woyaa hayyumma'aa ta qomaatiin wolitti hidhi. ");
INSERT INTO gax_vpl VALUES ("EX28_29","003_28_29","EXO","28","29","29","«Aaron yennaa gara addee woyyitti'ii seenu, yennuma mara ana Mootii Waan Maraa duratti akka isaan ittiin yaadatamanu, maqaa ilmaan Yaaqoobii kiisii qomaa, ta mey fedhii tiyya ittiin gaafatanu keessa jiru keessatti qoma ifii irratti ba'atuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_30","003_28_30","EXO","28","30","30","Uriimii fi tumiimille kiisii qomaa san keessa hin keetta; maarre Aaron gara addee woyyittii fuula ana Mootii Waan Maraa dura yennaa seenu, Uriimii fi tumiim kiisii qomaa san keessa keyatee, qoma ifii irratti ba'atuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_31","003_28_31","EXO","28","31","31","«Qoloon woyaa hayyumma'aa ta qomaa woliin uffatanu guutumatti bifa cuquliisaa teetuu ti; ");
INSERT INTO gax_vpl VALUES ("EX28_32","003_28_32","EXO","28","32","32","Gara gubba'aa wodhakkaa isi'iitiin qowa mataan seenu qabaattuu ti; qowi sun akka hin tarsaane goodamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_33","003_28_33","EXO","28","33","33","Irga handaara isaatitti fakkii midhaan muka rumaanii ta bifa cuquliisaa, ta bifa dhiille'eetii fi ta bifa liilana diima'aa hujiitii odduu odduu isaaniititti bilbila worqi'ii itti hidhi. ");
INSERT INTO gax_vpl VALUES ("EX28_34","003_28_34","EXO","28","34","34","Bilbilli worqi'iitii fi fakkiin midhaan muka rumaanii irga handaara qolo'ootitti tarreessi; tarreen isaalle bilbila worqi'ii, fakkii midhaan muka rumaanii te'anee handaara qolo'oo irratti naanneffaman. ");
INSERT INTO gax_vpl VALUES ("EX28_35","003_28_35","EXO","28","35","35","Aaron yennaa tajaajilu qoloo tana uffatuu ti; inni ana Mootii Waan Maraa dura addee woyyittii yennaa seenuu fi yennaa gad bawu akka hin duuneef qililleettiin bilbilaa dhage'amuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_36","003_28_36","EXO","28","36","36","«Kallacha worqii qullittii irraa hujiitii, ‹Ka Mootii Waan Maraatiif Woyyoome› jedhiitii akka chaappaa irratti qiriixanu irratti qiriixi. ");
INSERT INTO gax_vpl VALUES ("EX28_37","003_28_37","EXO","28","37","37","Marata mata'aatitti qassiisiisaaf liilana bifa cuquliisaa itti hidhi. Marata san irratti gara fuula duraatiin te'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_38","003_28_38","EXO","28","38","38","Aaron kallacha san adda ifii irratti keyatuu ti; Aaron yakkaa kennansa woyyicha kolbaan Israa'elii naaf adda baachee dhikeessitu keessa jirtu hin ba'ata. Kolbaan Israa'elii ana Mootii Waan Maraa duratti fudhatama akka qabaattu kallachi sun yennaa mara adda Aaronii irra jiraatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_39","003_28_39","EXO","28","39","39","«Qoloo haga miilaa dheerattuu fi marata mata'aa quncee talba'aa dansa'aan huji; hiituun sunille ta nami hujii harkaa beeku huje teetuu ti. ");
INSERT INTO gax_vpl VALUES ("EX28_40","003_28_40","EXO","28","40","40","«Ilmaan Aaronii kabajja'aa fi ulfinna akka qabaatanu, qoloo haga miilaa dheerattu, hiitu'uu fi gullee mata'aa isaaniif huji. ");
INSERT INTO gax_vpl VALUES ("EX28_41","003_28_41","EXO","28","41","41","Woyaa tana obboleessa keeti Aaronii fi ilmaan isaatitti uffitteen duuba, isaan muudiitii hayyoota tolchi; hayyoota te'anee akka na tajaajilanu isaan woyyoonsi. ");
INSERT INTO gax_vpl VALUES ("EX28_42","003_28_42","EXO","28","42","42","«Nafi isaanii ka hilaa akka hin mudhanne, quncee talba'aa irraa mutaandii woyaa jalaan hidhatanu ta hidha irraa kaatee haga gudeedaa geettu isaaniif huji. ");
INSERT INTO gax_vpl VALUES ("EX28_43","003_28_43","EXO","28","43","43","Nafi isaanii ka hilaa mudhatee isaan akka hin duuneef, Aaronii fi ilmaan isaa yennaa gara Dunkaanii Woldeenna'aa seenanu yookiin tajaajiliisaaf gara addee woyyitti'ii seenanee gara addee ciinca'aa yennaa dhikaatanu mara mutaandii woyaa jalaan hidhatanu tana hidhatanuu ti. «Kun Aaronii fi sanyii isaatiif seerata bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX29_1","003_29_1","EXO","29","1","1","«Aaronii fi ilmaan isaa hayyoota te'anee akka na tajaajilanu, isaan woyyoonsiisaaf wonni ati tolchitu kana: Dardara tokkoo fi korbeeyyii hoole'ee lama ta fafa hin qanne fuudhi. ");
INSERT INTO gax_vpl VALUES ("EX29_2","003_29_2","EXO","29","2","2","Bullaa qamadi'ii dansaa ta uukoo hin qanne irraa daabboo, bixee zayiti'iin sukkuumantee fi bixee hephellittii zayitiin irra dibante hujiitii, ");
INSERT INTO gax_vpl VALUES ("EX29_3","003_29_3","EXO","29","3","3","saaxaraa keessa keyiitii, kormaa fi korbeeyyii hoole'ee lama woliin naaf dhikeessi. ");
INSERT INTO gax_vpl VALUES ("EX29_4","003_29_4","EXO","29","4","4","Achiin duuba Aaronii fi ilmaan isaa gara seensuma Dunkaanii Woldeenna'aa fidiitii, nafa isaanii bisaaniin dhiqi. ");
INSERT INTO gax_vpl VALUES ("EX29_5","003_29_5","EXO","29","5","5","Woyaa hayyootaa fuudhiitii, qoloo haga miilaa dheerattu, qoloo woyaa hayyumma'aa woliin uffatanu, woyaa hayyumma'aa ta qomaatii fi kiisii qomaa Aaronitti uffisi. ");
INSERT INTO gax_vpl VALUES ("EX29_6","003_29_6","EXO","29","6","6","Marata mata'aa itti mariitii, kallacha worqii irraa hujame marata mata'aa sanitti qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX29_7","003_29_7","EXO","29","7","7","Zayitii muudaa fuudhiitii, mataa isaa irratti dhangalaasii isa muudi. ");
INSERT INTO gax_vpl VALUES ("EX29_8","003_29_8","EXO","29","8","8","Ilmaan isaa fidiitii qoloo haga miilaa dheerattu itti uffisi. ");
INSERT INTO gax_vpl VALUES ("EX29_9","003_29_9","EXO","29","9","9","Hidha Aaroniitii fi ilmaan isaatitti hiituu hidhi; maratalle mataa isaaniititti mari. Akka kanaan Aaronii fi ilmaan isaa hayyoota akka te'anu godhi. Hayyummaan seera bara baraa isaaniif teetuu ti. ");
INSERT INTO gax_vpl VALUES ("EX29_10","003_29_10","EXO","29","10","10","«Dardara Dunkaanii Woldeenna'aa dura fidiitii, Aaronii fi ilmaan isaa mataa isaa irra harka akka keyanu godhi. ");
INSERT INTO gax_vpl VALUES ("EX29_11","003_29_11","EXO","29","11","11","Dardara san seensuma Dunkaanii Wolgeyi'iititti Mootii Waan Maraa duratti qali. ");
INSERT INTO gax_vpl VALUES ("EX29_12","003_29_12","EXO","29","12","12","Dhiiga korma sanii irraa diqqaa isaa fuudhiitii, quba keetiin gaafota addee ciinca'aa dibi. Ka hafe addee ciinca'aa jalatti dhangalaasi. ");
INSERT INTO gax_vpl VALUES ("EX29_13","003_29_13","EXO","29","13","13","Achiin duuba moora meya gadha'aa, qaccee tiru'uutii fi kalattii lamaanuu moora isii irra jiru woliin fuudhiitii addee ciinca'aatitti ciincessi. ");
INSERT INTO gax_vpl VALUES ("EX29_14","003_29_14","EXO","29","14","14","Foon dardaraa, gogaa isaatii fi meya gadha'aa ka isaa addee quttumaatiin alatti gubi. Kun ciincaa araara cubbu'uutiif dhikaatu. ");
INSERT INTO gax_vpl VALUES ("EX29_15","003_29_15","EXO","29","15","15","«Korbeeyyii hoole'ee lamaan san keessaa tokkocha fuudhii, Aaronii fi ilmaan isaa mataa isaa irra harka ifii akka keyanu godhi. ");
INSERT INTO gax_vpl VALUES ("EX29_16","003_29_16","EXO","29","16","16","Korbeessa san qaliitii, dhiiga isaa fuudhiitii cinaa addee ciinca'aa arfanittuu fiffixi. ");
INSERT INTO gax_vpl VALUES ("EX29_17","003_29_17","EXO","29","17","17","Foon korbeessaa san kukkuttii, meya gadha'aatii fi luka isaa dhiqiitii, mata'aa fi foon kukkutame kaan woliin keyi. ");
INSERT INTO gax_vpl VALUES ("EX29_18","003_29_18","EXO","29","18","18","Achiin duuba foon korbeessaa san mara addee ciinca'aa irratti gubi; kun kennansa ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu, ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu. ");
INSERT INTO gax_vpl VALUES ("EX29_19","003_29_19","EXO","29","19","19","«Korbeessa hoole'ee kaanille fuudhiitii, Aaronii fi ilmaan isaa mataa isaa irra harka ifii akka keyanu godhi. ");
INSERT INTO gax_vpl VALUES ("EX29_20","003_29_20","EXO","29","20","20","Korbeessa san qaliitii, dhiiga isaa irraa diqqaa isaa fuudhiitii, qaccee gurra Aaronii ka gara middaatii fi gurra ilmaan isaa ka gara middaa, quba isaanii abguddicha ka harka middichaatii fi quba isaanii abguddicha ka miila middichaa dibi; ka hafe cinaa addee ciinca'aa arfanittuu fiffixi. ");
INSERT INTO gax_vpl VALUES ("EX29_21","003_29_21","EXO","29","21","21","Dhiiga addee ciinca'aa irraa diqqaa isaatii fi zayitii muudaa irraa diqqoo isi'ii fuudhiitii Aaronii fi woyaa isaatitti, ilmaan isaatii fi woyaa isaaniititti fiffixi. Achiin duuba Aaronii fi woyaan isaa, ilmaan isaatii fi woyaan isaanii hin woyyooman. ");
INSERT INTO gax_vpl VALUES ("EX29_22","003_29_22","EXO","29","22","22","«Korbeessa hayyuu ittiin te'anu waan te'eef, korbeessa san irraa: cooma duma isaa, moora meya gadha'aa, qaccee tiru'uu, kalattii lamaanuu moora isi'ii woliin, luka gara middaa fuudhi. ");
INSERT INTO gax_vpl VALUES ("EX29_23","003_29_23","EXO","29","23","23","Saaxaraa daabboo uukoo hin qannee ta Mootii Waan Maraa dura jirtu keessaa xaltaa, bixee zayiti'iin sukkuumantee fi bixee hephellittii fuudhi. ");
INSERT INTO gax_vpl VALUES ("EX29_24","003_29_24","EXO","29","24","24","Kana maraa harka Aaroniitii fi ilmaa isaa irra keyiitii kennansa tachoofamu godhiitii ana Mootii Waan Maraa duratti tachoosi. ");
INSERT INTO gax_vpl VALUES ("EX29_25","003_29_25","EXO","29","25","25","Achiin duuba harka isaanii irraa fuudhiitii addee ciinca'aa irratti, kennansa gubamu woliin gubi. Kun kennansa ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu, ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu. ");
INSERT INTO gax_vpl VALUES ("EX29_26","003_29_26","EXO","29","26","26","Yennaa Aaron hayyuu te'u cormii korbeessa hoole'ee fuuteen duuba, kennansa tachoofamu godhiitii ana Mootii Waan Maraa duratti tachoosi. Kun qooda keeti hin te'a. ");
INSERT INTO gax_vpl VALUES ("EX29_27","003_29_27","EXO","29","27","27","«Aaronii fi ilmaan isaa yennaa hayyoota te'anu, cormii tachoofantee fi luka korbeessa hoole'ee ta dhikaatte san woyyoonsi. ");
INSERT INTO gax_vpl VALUES ("EX29_28","003_29_28","EXO","29","28","28","Kennansa tokkumma'aa ka Israa'elooti ana Mootii Waan Maraatiif dhikeessitu keessaa, kun yennaa mara qooda Aaroniitii fi ilmaan isaa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("EX29_29","003_29_29","EXO","29","29","29","«Aaron du'een duuba woyaa isaa woyyittii san akka muudantee hayyuu ittiin teetu sanyiin isaa uffattuu ti. ");
INSERT INTO gax_vpl VALUES ("EX29_30","003_29_30","EXO","29","30","30","Ilmi addee isaatitti hayyuu te'ee addee woyyittii keessa tajaajilaaf gara Dunkaanii Woldeenna'aa seenu guyyaa torba uffatuu ti. ");
INSERT INTO gax_vpl VALUES ("EX29_31","003_29_31","EXO","29","31","31","«Foon korbeessa hoole'ee ka yennaa isaan hayyuu te'anu qalame san fuudhiitii addee woyyitti'itti iffeeli. ");
INSERT INTO gax_vpl VALUES ("EX29_32","003_29_32","EXO","29","32","32","Aaronii fi ilmaan isaa foon korbeessaa sanii fi daabboo saaxaraa keessaa san seensuma Dunkaanii Woldeenna'aatitti nyaatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX29_33","003_29_33","EXO","29","33","33","Isaan kennansa yennaa isaan hayyuu te'anu gumaa cubbu'uutiif dhikaate san nyaatanuu ti; kennansi kun woyyuu waan te'eef, nami dhibiin hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("EX29_34","003_29_34","EXO","29","34","34","Foon korbeessa yennaa isaan hayyuu te'anu qalamee yookiin daabboon hattee yoo bulte gubi; sagalee woyyittii waan teeteef hin nyaatamin. ");
INSERT INTO gax_vpl VALUES ("EX29_35","003_29_35","EXO","29","35","35","«Seera isaan hayyoota ittiin te'anu guyyaa torba keessatti muummessiisaan, Aaronii fi ilmaan isaatiif, waan ani si ajaje mara tolchi. ");
INSERT INTO gax_vpl VALUES ("EX29_36","003_29_36","EXO","29","36","36","Gumaa cubbu'uu tolchiisaaf, guyyuma guyya'aan dardara tokko araara cubbu'uutiif ciincessi. Gumaa cubbu'uu tolchiisaan addee ciinca'aa qulqulleessiitii, isii woyyoonsiisaaf muudi. ");
INSERT INTO gax_vpl VALUES ("EX29_37","003_29_37","EXO","29","37","37","Guyyaa torba addee ciinca'aatiif gumaa cubbu'uu tolchiisaan isii woyyoonsi. Achiin duuba addeen ciinca'aa sun irra caalaa woyyittii hin teeti; wonni isii tuqu marti woyyuu hin teeti. ");
INSERT INTO gax_vpl VALUES ("EX29_38","003_29_38","EXO","29","38","38","«Yennaa mara guyyuma guyya'aan buruusoo korbeeyyii hoole'ee ta woggaa tokko tokkoo lama addee ciinca'aa irratti ciincaa dhikeessi. ");
INSERT INTO gax_vpl VALUES ("EX29_39","003_29_39","EXO","29","39","39","Buruusoo korbeessa hoole'ee tokko ganama, buruusoo korbeessa hoole'ee tokko galgala ciincaa dhikeessi. ");
INSERT INTO gax_vpl VALUES ("EX29_40","003_29_40","EXO","29","40","40","Buruusoo korbeessa hoole'ee ka qara dhikaatu woliin bullaa qamadi'ii dansaa kiiloogiraama tokko ta zayitii ejersaa qullittii litirii tokkoon sukkuumantee fi kennansa daadhii woyni'ii litirii tokko dhikeessi. ");
INSERT INTO gax_vpl VALUES ("EX29_41","003_29_41","EXO","29","41","41","Buruusoo korbeessa hoole'ee kaan akkuma buruusoo korbeessa hoole'ee ka qaraa kaanitti kennansa midhaaniitii fi kennansa daadhii woyni'ii woliin kennansa ibiddaan gubamee dhikaatu, ka foolee dansaa qabu, ka ana Mootii Waan Maraa gammachiisu godhiitii, galgala dimimmisa ciincaa dhikeessi. ");
INSERT INTO gax_vpl VALUES ("EX29_42","003_29_42","EXO","29","42","42","«Kennansi gubamu kun dhaloota dhufuufille seensuma Dunkaanii Woldeenna'aatitti ana Mootii Waan Maraa duratti yennaa mara dhikaata. Ani achitti si'iin wol dhaggee, si'itti hin dubbadha. ");
INSERT INTO gax_vpl VALUES ("EX29_43","003_29_43","EXO","29","43","43","Ani achitti Israa'elootalle'een wol hin dhagga; addeen sunille ulfinna kiyyaan hin woyyoonti. ");
INSERT INTO gax_vpl VALUES ("EX29_44","003_29_44","EXO","29","44","44","«Maarre ani Dunkaanii Woldeenna'aatii fi addee ciinca'aa hin woyyoonsa; Aaronii fi ilmaan isaalle hayyoota te'anee akka na tajaajilanu hin woyyoonsa. ");
INSERT INTO gax_vpl VALUES ("EX29_45","003_29_45","EXO","29","45","45","Achiin duuba ani Israa'eloota odduu jiraadhee Waaqa isaanii hin te'a. ");
INSERT INTO gax_vpl VALUES ("EX29_46","003_29_46","EXO","29","46","46","Odduu isaanii jiraatiisaaf biyya Gibxi'ii keessaa ka isaan baase ani Mootii Waan Maraa Waaqa isaanii akka te'e hin beekan. Ani Mootii Waan Maraa Waaqa isaanii ti. ");
INSERT INTO gax_vpl VALUES ("EX30_1","003_30_1","EXO","30","1","1","«Addee ciinca'aa ta hixaana itti ciincessanu muka gololchaatiin ijaari. ");
INSERT INTO gax_vpl VALUES ("EX30_2","003_30_2","EXO","30","2","2","Dheerinni isi'ii ciqilee tokko, badhinni isi'ii ciqilee tokko, hojjaan isi'ii ciqilee lama te'ee, rogi arfanuu wol qixa te'uu ti. Roga arfanittuu gaafota itti baasi. ");
INSERT INTO gax_vpl VALUES ("EX30_3","003_30_3","EXO","30","3","3","Gubbaa isi'iitii fi roga isi'ii mara, gaafota isi'iille worqii qulluu itti gonfi. Roga isi'ii irra naannessii xiyyoo worqi'ii itti huji. ");
INSERT INTO gax_vpl VALUES ("EX30_4","003_30_4","EXO","30","4","4","Danqaraa keessa loosanee addee ciinca'aa ittiin ba'atiisaaf, qubee worqi'ii lama hujiitii xiyyoo jalatti gama lamaanittuu qassiisi. ");
INSERT INTO gax_vpl VALUES ("EX30_5","003_30_5","EXO","30","5","5","Muka gololchaa irraa danqaraa hujiitii worqii itti gonfi. ");
INSERT INTO gax_vpl VALUES ("EX30_6","003_30_6","EXO","30","6","6","Addee ciinca'aa san gollaa Saanduqa Gondooro'ootiin duratti fannifameeruun fuula dura, qadaaddaa addee gumaan araara cubbu'uu irra keyamu ka Saanduqa Gondooro'oo irra jiru addee ani si'iin wol dhaggu san dura keyi. ");
INSERT INTO gax_vpl VALUES ("EX30_7","003_30_7","EXO","30","7","7","«Aaron yennaa issaa qopheessu, ganama ganama addee ciinca'aa irratti hixaana foolee dansaa qabu aarsuu ti. ");
INSERT INTO gax_vpl VALUES ("EX30_8","003_30_8","EXO","30","8","8","Inni galgala dimimmisa yennaa issaa issu, hixaana aarsuu ti; maarre hixaanni dhaloota dhufuuf, ana Mootii Waan Maraa duratti yennaa mara hin aarfama. ");
INSERT INTO gax_vpl VALUES ("EX30_9","003_30_9","EXO","30","9","9","Addee ciinca'aa tana irratti hixaana dhooggame hin aarsin yookiin kennansa gubamu yookiin kennansa midhaanii hin dhikeessin; kennansa daadhii woyni'iille irratti hin dhibaasin. ");
INSERT INTO gax_vpl VALUES ("EX30_10","003_30_10","EXO","30","10","10","Aaron wogga'atti yennaa tokko, gumaa cubbu'uu gaafota isi'ii irratti tolchuu ti. Gumaan araara cubbu'uu ka wogga'atti tolfamu kun dhiiga araaraa cubbu'uu woliin dhaloota dhufu maraaf tolfamuu qaba. Gumaan kun ana Mootii Waan Maraatiif irra caalaa woyyicha» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX30_11","003_30_11","EXO","30","11","11","Mootiin Waan Maraa ammalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX30_12","003_30_12","EXO","30","12","12","«Ati kolbaa Israa'elii yennaa laakkottu, isaan yennaa laakkowamanu, balaan akka isaanitti hin buune, wodoo lubbuu ifii ana Mootii Waan Maraatiif kaffalanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX30_13","003_30_13","EXO","30","13","13","Worri laakkossatti dabalamu martinuu akka madaallii Dunkaanii Woyyitti'iititti meetii gara giraama kudhanii tokkoo kennuu ti. Kennansi kun ana Mootii Waan Maraatiif kennama. ");
INSERT INTO gax_vpl VALUES ("EX30_14","003_30_14","EXO","30","14","14","Worri laakkossatti dabalamu marti, ka woggaa diddamaatii fi woggaa diddamaa olii, kennansa naaf kennanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX30_15","003_30_15","EXO","30","15","15","Gumaa araara cubbuu teessaniitiif, kennansa ana Mootii Waan Maraatiif yennaa kennitanu, dureessichi meetii gara giraama kudhanii tokkoo caalaa, hiyyeessille meetii gara giraama kudhanii tokkoo hanqisee hin kennin. ");
INSERT INTO gax_vpl VALUES ("EX30_16","003_30_16","EXO","30","16","16","Beesee gumaa cubbu'uu tana Israa'eloota irraa fuudhiitii tajaajila Dunkaanii Woldeenna'aa irra oolchi. Lubbuu teessaniif gumaa cubbu'uu tolchiis kun isin Israa'elootaaf ana Mootii Waan Maraa duratti yaadannoo hin te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX30_17","003_30_17","EXO","30","17","17","Mootiin Waan Maraa ammalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX30_18","003_30_18","EXO","30","18","18","«Akka itti dhiqatanu, gabataa itti dhiqatanuu fi waan isa irra keyanu sageettuu irraa hujiitii wodhakkaa Dunkaanii Woldeenna'aatii fi addee ciinca'aa keyiitii, bisaan itti naqi. ");
INSERT INTO gax_vpl VALUES ("EX30_19","003_30_19","EXO","30","19","19","Aaronii fi ilmaan isaa bisaan saniin harkaa fi miila ifii dhiqatanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX30_20","003_30_20","EXO","30","20","20","Isaan yennaa Dunkaanii Woldeenna'aa seenanu akka hin duune bisaan saniin dhiqatanuu ti. Isaan kennansa ibiddaan gubamu ana Mootii Waan Maraatiif dhikeessiisaan tajaajiliisaaf gara addee ciinca'aa yennaa dhikaatanulle, ");
INSERT INTO gax_vpl VALUES ("EX30_21","003_30_21","EXO","30","21","21","akka hin duuneef harkaa fi miila ifii bisaan saniin dhiqatanuu ti. Kun dhaloota dhufuuf, Aaronii fi sanyii isaatiif seerata bara baraa te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX30_22","003_30_22","EXO","30","22","22","Mootiin Waan Maraa ammalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX30_23","003_30_23","EXO","30","23","23","«Uddowaa dansaa: fiqiree qumbi'ii gara kiiloogiraama jaa, qarafaa gara kiiloogiraama sadii, marra uddowu gara kiiloogiraama sadii, ");
INSERT INTO gax_vpl VALUES ("EX30_24","003_30_24","EXO","30","24","24","dakkara gara kiiloogiraama jaa fuudhiitii akka madaallii Dunkaanii Woyyitti'iititti, zayitii ejersaalle gara litirii afurii itti ede'iitii, ");
INSERT INTO gax_vpl VALUES ("EX30_25","003_30_25","EXO","30","25","25","akka fiqiree worri hujii isi'ii beeku hujuu godhiitii zayitii muudamaa woyyittii huji. Isiin zayitii muudamaa woyyittii hin teeti. ");
INSERT INTO gax_vpl VALUES ("EX30_26","003_30_26","EXO","30","26","26","Achiin duuba Dunkaanii Woldeenna'aatii fi Saanduqa Gondooro'oo, ");
INSERT INTO gax_vpl VALUES ("EX30_27","003_30_27","EXO","30","27","27","xarapheessa'aa fi meya isaa mara, waan issaa irra keyanuu fi meya isi'ii mara, addee ciinca'aa ta hixaanni irratti aarfamu, ");
INSERT INTO gax_vpl VALUES ("EX30_28","003_30_28","EXO","30","28","28","addee ciinca'aa ta kennansa gubamuutii fi meya isi'ii mara, akkasuma gabataa itti dhiqatanuu fi waan isa irra keyanu dibi. ");
INSERT INTO gax_vpl VALUES ("EX30_29","003_30_29","EXO","30","29","29","Akka isaan irra caalaa woyyoomanu ati isaan woyyoonsi; isaanille irra caalaa woyyuu hin te'an; ka isaan tuqe marti woyyuu hin te'a. ");
INSERT INTO gax_vpl VALUES ("EX30_30","003_30_30","EXO","30","30","30","Hayyoota te'anee akka na tajaajilanu Aaronii fi ilmaan isaa muudiitii woyyoonsi. ");
INSERT INTO gax_vpl VALUES ("EX30_31","003_30_31","EXO","30","31","31","«Kolbaa Israa'eliitiin, ‹Tun dhaloota dhufuuf zayitii woyyittii tiyya ta muudamaa ti. ");
INSERT INTO gax_vpl VALUES ("EX30_32","003_30_32","EXO","30","32","32","Zayitii tana nama mara irratti hin dhangalaasina'a. Zayitii akka kanaa ta dhibiille hin hujina'a; isiin woyyitti'i; akka isiin woyyuu teetelle qalbeeffadha'a. ");
INSERT INTO gax_vpl VALUES ("EX30_33","003_30_33","EXO","30","33","33","Nami zayitii akka kanaa ta dhibii hujee, hayyoota malee nama dhibii muude marti, kolbaa ifii keessaa bawuu ti› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX30_34","003_30_34","EXO","30","34","34","Mootiin Waan Maraa Muuse'een, «Uddowaa dansaa: ceem'aa muka uddowuu, uddowaa muka adda addaa irraa dhaggamu, aanan muka uddowuutii fi hixaana muka hin qanne ka madaalliin isaanii wol qixxee te'ane fuudhiitii, ");
INSERT INTO gax_vpl VALUES ("EX30_35","003_30_35","EXO","30","35","35","akka fiqiree worri hujii isi'ii beeku hujuu, atille soodda itti naqiitii hixaana qulluu woyyicha qopheessi. ");
INSERT INTO gax_vpl VALUES ("EX30_36","003_30_36","EXO","30","36","36","Isa irraa diqqaa isaa daakii bulleessiitii, Dunkaanii Woldeenna'aa keessaa addee ani si'iin wol dhaggu Saanduqa Gondooro'oo fuula dura keyi; inni irra caalaa woyyuu si'iif te'a. ");
INSERT INTO gax_vpl VALUES ("EX30_37","003_30_37","EXO","30","37","37","Hixaana akkasii ifiif hin qopheeffatin; inni ana Mootii Waan Maraatiif woyyuu akka te'e qalbeeffadhu. ");
INSERT INTO gax_vpl VALUES ("EX30_38","003_30_38","EXO","30","38","38","Nami ittiin gammadiisaaf hixaana akkasii hujate, kolbaa ifii keessaa bawuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX31_1","003_31_1","EXO","31","1","1","Achiin duuba Mootiin Waan Maraa Muuse'een ");
INSERT INTO gax_vpl VALUES ("EX31_2","003_31_2","EXO","31","2","2","«Kunoo, ani gosa Yihuda'aa keessaa akaakoo Huurii, ilma Urii Bazaali'el filadhee, ");
INSERT INTO gax_vpl VALUES ("EX31_3","003_31_3","EXO","31","3","3","ogumma'aan, dandeetti'ii fi beekkumsaan hujii harkaa mara akka huju Ayyaana kiyyaan isa guuteera. ");
INSERT INTO gax_vpl VALUES ("EX31_4","003_31_4","EXO","31","4","4","Inni akka itti worqii, meeti'ii fi sageettuu hujanu karoora hin baasa. ");
INSERT INTO gax_vpl VALUES ("EX31_5","003_31_5","EXO","31","5","5","Inni dhakaa dhodhoosee qiriixee, mukalle bocee xabbee, hujii harkaa mara hin huja. ");
INSERT INTO gax_vpl VALUES ("EX31_6","003_31_6","EXO","31","6","6","Ammalle, gosa Daanii keessaa ilma Ahisamaakii Aholiiyaab akka isa qarqaaru fileera; waan ani si ajaje mara akka hujanu, worra hujii harkaa beeku maraafille ani ogummaa kenneera. ");
INSERT INTO gax_vpl VALUES ("EX31_7","003_31_7","EXO","31","7","7","Dunkaanii Woldeenna'aa, Saanduqa Gondooro'ootii fi qadaaddaa araarri cubbu'uu irra keyamu ka isii irra jiru, meya Dunkaanii Woldeenna'aa mara, ");
INSERT INTO gax_vpl VALUES ("EX31_8","003_31_8","EXO","31","8","8","xarapheessa'aa fi meya isaa mara, waan issaa irra keyanu ka worqii qulluu irraa hujamee fi meya isi'ii mara, addee ciinca'aa ta hixaanni irratti aarfamu, ");
INSERT INTO gax_vpl VALUES ("EX31_9","003_31_9","EXO","31","9","9","addee ciinca'aa ta kennansa gubamuutii fi meya isi'ii mara, gabataa itti dhiqatanuu fi waan gabataan sun irra keyamu, ");
INSERT INTO gax_vpl VALUES ("EX31_10","003_31_10","EXO","31","10","10","woyaa kuulante woyyittii ta Aaronii fi ilmaan isaa yennaa hayyumma'aan tajaajilanu uffatanu, ");
INSERT INTO gax_vpl VALUES ("EX31_11","003_31_11","EXO","31","11","11","zayitii muudaa, addee woyyitti'iifille hixaana uddowu akkuma ani si ajajetti hujanuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX31_12","003_31_12","EXO","31","12","12","Achiin duuba Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX31_13","003_31_13","EXO","31","13","13","«Kolbaa Israa'eliitiin, ‹Guyyaa Sanbataa kiyya eeggadha'a. Ani Mootii Waan Maraa ka isin woyyoonsu akka te'e akka beettanuuf, dhaloota dhufu mara keessatti Sanbati kun anaa fi isin wodhakka'atti beessisa hin te'a. ");
INSERT INTO gax_vpl VALUES ("EX31_14","003_31_14","EXO","31","14","14","Guyyaan Sanbataa isiniif woyyuu waan te'eef, Sanbata eeggadha'a. Nami Sanbata eegatuu dhabe ijjeefamuu ti; guyyaa san nami hujii huju marti kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("EX31_15","003_31_15","EXO","31","15","15","Guyyaa jaa hujii teessan hujadha'a; guyyaan torbeesso'oo ammoo guyyaa ana Mootii Waan Maraatiif woyyoome Sanbati guyyaa fooraa ti. Nami guyyaa Sanbataa hujii huje marti ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX31_16","003_31_16","EXO","31","16","16","Kolbaan Israa'elii dhaloota dhufu mara keessatti, Gondooroo bara baraa gootee, guyyaa Sanbataa eeggatiisaaf jilifattuu ti. ");
INSERT INTO gax_vpl VALUES ("EX31_17","003_31_17","EXO","31","17","17","Ani Mootiin Waan Maraa guyyaa jaa keessatti gubba'aa fi lafa dadee, guyyaa torbeesso'oo ammoo hujii irraa hafuura fudhadhee foorfadhe; guyyaan kun anaa fi Israa'eloota wodhakka'atti haga bara baraa beessisa hin te'a› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX31_18","003_31_18","EXO","31","18","18","Mootiin Waan Maraa gaara Siina'aa irratti Muusee woliin dubbatee yennaa fixe, dhakaa baxxicha lamaan ka qubuma ifiitiin irratti barreesse san Muuse'etti kenne. ");
INSERT INTO gax_vpl VALUES ("EX32_1","003_32_1","EXO","32","1","1","Kolbaan sun Muuseen gaara irraa gad bu'iisa dhabee akka ture yennaa dhaggite, Aaronitti dachaatee, «Muuseen nu sooressee biyya Gibxi'ii keessaa nu baase sun maan akka te'e hin beennu; tanaaf ka'iitii waaqota nuun dura deemanu nuu huji» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("EX32_2","003_32_2","EXO","32","2","2","Aaronille deebisee, «Worqii gurraa ta dubartoota teessanii, ta ilmaan teessaniitii fi durra teessanii irraa baasa'aatii gara kiyya fida'a» jedheen. ");
INSERT INTO gax_vpl VALUES ("EX32_3","003_32_3","EXO","32","3","3","Maarre kolbaan martinuu worqii gurraa ta ifii baafatanee gara Aaronii fidane. ");
INSERT INTO gax_vpl VALUES ("EX32_4","003_32_4","EXO","32","4","4","Innille worqii san harka isaaniitii fuudhee, meya fakkii ittiin hujatanu keessatti baqisiisee, bifa itti baasee, fakkii jabbi'ii worqii irraa huje. Achiin duuba, kolbaan, «Ee Israa'el, waaqi keeti ka biyya Gibxi'ii keessaa si baase isa kana» jette. ");
INSERT INTO gax_vpl VALUES ("EX32_5","003_32_5","EXO","32","5","5","Aaronille yennaa waan kana dhagge, fakkii jabbi'ii ta worqii irraa hujante san duratti, addee ciinca'aa ijaaree, «Boru Mootii Waan Maraatiif guyyaa jilaa te'uu ti» jedhee lallabe. ");
INSERT INTO gax_vpl VALUES ("EX32_6","003_32_6","EXO","32","6","6","Maarre boruyyaa kolbaan ganamaan kaatee kennansa gubamu dhikeessitee, kennansa tokkumma'aalle kennite. Achiin duuba isaan nyaataa fi uniisatti gad tee'ane; sirba fokkisiisulle sirbiisatti ka'ane. ");
INSERT INTO gax_vpl VALUES ("EX32_7","003_32_7","EXO","32","7","7","Achiin duuba Mootiin Waan Maraa Muuse'een «Kolbaan teeti ta ati sooressitee biyya Gibxi'ii keessaa baatte waan gara baddeef, ka'ii gad bu'i. ");
INSERT INTO gax_vpl VALUES ("EX32_8","003_32_8","EXO","32","8","8","Isaan waan ani isaan ajaje irraa goranee, worqii baqisiifante irraa waaqa dharaa ka fakkii jabbi'ii ifiif hujatanee isi'iif sagadane; ciincaalle isi'iif dhikeessanee, ‹Ee Israa'el, waaqi keeti ka biyya Gibxi'ii keessaa si baase isa kana› jedhane. ");
INSERT INTO gax_vpl VALUES ("EX32_9","003_32_9","EXO","32","9","9","Ani kolbaa tana dhaggeera. Isaan worra mataa jabaatu. ");
INSERT INTO gax_vpl VALUES ("EX32_10","003_32_10","EXO","32","10","10","Aariin tiyya isaan irratti bobeettee, akka ani isaan fixu ati na lakkisi. Achiin duuba ani gosa guddoo takka si hin tolcha» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_11","003_32_11","EXO","32","11","11","Muuseen ammoo Mootii Waan Maraa Waaqa ifii daadimatee, «Ee Mootii Waan Maraa, kolbaa teeti ta ati hunna guddo'oo fi irree jaddu'uun biyya Gibxi'ii keessaa baatte irratti aariin teeti maaf bobeetti? ");
INSERT INTO gax_vpl VALUES ("EX32_12","003_32_12","EXO","32","12","12","Worri Gibxi'ii, ‹Mootiin Waan Maraa duruuyyuu yaada hama'aaf, gaara irratti isaan ijjeesee, lafa irraa isaan balleessiisaaf, biyya Gibxi'ii keessaa isaan baase› maaf jedhan ree? Ati aarii teeti ta bobeettu tana caffadhu; kolbaa teeti irralle'etti balaa hin buusin. ");
INSERT INTO gax_vpl VALUES ("EX32_13","003_32_13","EXO","32","13","13","Tajaajiltoota teeti Abrahaam, Yisihaqii fi Yaaqoob ta maqaa keetiin isaaniif kakattee, ‹Sanyii teessan akka urjii ol gubba'aa hin baceessa; lafa isiniif waadaa gale tana mara sanyii teessaniif hin kenna; latti sun haga bara baraa lafa isaan dhaalanu hin teeti› jette san qaabadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_14","003_32_14","EXO","32","14","14","Achiin duuba Mootiin Waan Maraa aarii san caffatee, balaa kolbaa ifii irratti fidiisaaf yaadate san lakkise. ");
INSERT INTO gax_vpl VALUES ("EX32_15","003_32_15","EXO","32","15","15","Muuseen dhakaa baxxicha lamaan ka gama lamaaniinuu seerri kudhan duraa fi duubaan itti barreeffameeru san harkatti qabatee, gaara irraa gad bu'e. ");
INSERT INTO gax_vpl VALUES ("EX32_16","003_32_16","EXO","32","16","16","Dhakoota baxxicha kana ka huje Waaqa; dhakoota baxxacha kana irratti qiriixee ka seera kana barreesselle Waaqaayyu. ");
INSERT INTO gax_vpl VALUES ("EX32_17","003_32_17","EXO","32","17","17","Iyaasuun hogaa caanca kolba'aa yennaa dhage'e, Muuse'een, «Addee quttumaa keessa caanca lolaatitti jira» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_18","003_32_18","EXO","32","18","18","Muuseelle deebisee, «Caanci ani dhage'e kun caanca sirbaati malee, caanca qeexalaa yookiin caanca bowichaatii moti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_19","003_32_19","EXO","32","19","19","Muuseen gara addee quttumaatitti yennaa dhikaate, fakkii jabbi'iitii fi qeexala kolba'aa dhaggee, aaree bobe'ee, dhakaa baxxicha seerri irratti barreeffameeru san harka ifii irraa qolaansee, gaara jalatti caccasse. ");
INSERT INTO gax_vpl VALUES ("EX32_20","003_32_20","EXO","32","20","20","Fakkii jabbi'ii ta isaan hujane san fuudhee ibiddaan gube. Achiin duuba daakee bulleessee, bisaanitti bittinneessee kolbaan Israa'elii akka untu godhe. ");
INSERT INTO gax_vpl VALUES ("EX32_21","003_32_21","EXO","32","21","21","Inni Aaroniin, «Kolbaan tun maan si goonaan ati akka isaan cubbuu guddoo akkanaa hujanu goote?» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_22","003_32_22","EXO","32","22","22","Aaronille deebisee Muuse'een, «Goottaa kiyya, ati natti hin aarin; kolbaan tun hammeennaan akka qabanteertu atinuu hin beetta. ");
INSERT INTO gax_vpl VALUES ("EX32_23","003_32_23","EXO","32","23","23","Isaan anaan, ‹Muuseen nu sooressee biyya Gibxi'ii keessaa nu baase sun maan akka te'e hin beennu; waaqota nuun dura deemanu nuu huji!› jedhane. ");
INSERT INTO gax_vpl VALUES ("EX32_24","003_32_24","EXO","32","24","24","Maarre ani, ‹Nami faaya worqi'ii qaddanu marti baafadha'a› jedhee itti hime; achiin duuba isaan worqii san natti kennanee, anille worqii san ibidda keessa buusee, worqiin sun fakkii jabbi'ii teetee baate» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_25","003_32_25","EXO","32","25","25","Kolbaan seera malee jiraattee, diinoti isaanii akka isaanitti murganu, Aaron akka isaan gad lakkise, Muuseen dhagge. ");
INSERT INTO gax_vpl VALUES ("EX32_26","003_32_26","EXO","32","26","26","Maarre inni seensuma addee quttumaa dura dhaabbattee, «Nami ka Mootii Waan Maraa te'e marti gara kiyya dhufuu ti!» jedhe; worri Lewwootaa marti gara isaa dacha'ane. ");
INSERT INTO gax_vpl VALUES ("EX32_27","003_32_27","EXO","32","27","27","Achiin duuba inni, isaaniin, «Mootiin Waan Maraa, Waaqi Israa'elii, ‹Nami tokko tokkooyyuu shallaagaa ifii hidhatee, addee quttumaa keessa cinaa tokko irraa haga cinaa taanii asii fi achi deemaa obboleessa ifii, jaala ifiitii fi ollaa ifii ijjeesuu ti› jedha» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_28","003_32_28","EXO","32","28","28","Lewwootille akkuma Muuseen isaan ajaje tolchane, guyyuma sanuu nami gara kuma sadii dhumate. ");
INSERT INTO gax_vpl VALUES ("EX32_29","003_32_29","EXO","32","29","29","Achiin duuba Muuseen Lewwootaan, «Ilmaan teessanii fi obboleeyyan teessan irratti waan kaataneef adha Mootii Waan Maraatiif adda baataneertan, tanaaf inni adha isin eebbiseera» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_30","003_32_30","EXO","32","30","30","Guyyaa itti aanu Muuseen kolba'aan, «Isin cubbuu guddoo hujjaneertan; tanaaf ani amma gara Mootii Waan Maraa gara gaaraa ol hin baya; cubbuu teessaniif gumaa tolcha fa te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_31","003_32_31","EXO","32","31","31","Maarre Muuseen gara Mootii Waan Maraa deebi'ee, «Aanne'e! Kolbaan tun cubbuu guddoo hujjeerti; worqii irraa waaqota hujanee waaqonfataneeran. ");
INSERT INTO gax_vpl VALUES ("EX32_32","003_32_32","EXO","32","32","32","Amma ammoo, maganne'ee cubbuu isaanii, isaaniif araarami; yoo araaramuu dhadde ammoo kitaaba maqaa kiyya itti barreessite keessaa maqaa kiyya haqi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_33","003_32_33","EXO","32","33","33","Mootiin Waan Maraa deebisee, Muuse'een, «Nama na duratti cubbuu huje qofa, ani maqaa isaa kitaaba kiyya keessaa haqa. ");
INSERT INTO gax_vpl VALUES ("EX32_34","003_32_34","EXO","32","34","34","Amma dhaqiitii kolbaa san addee ani sitti hime san geessi! Ergamaan kiyyalle si'iin dura hin deema. Te'uu malee, yennaan ani isaan adabu yoo geette, cubbuu isaaniitiif, ani isaan hin adaba» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX32_35","003_32_35","EXO","32","35","35","Maarre kolbaan akka Aaron worqii irraa fakkii jabbi'ii huju waan gooteef, Mootiin Waan Maraa balaa isaanitti buuse. ");
INSERT INTO gax_vpl VALUES ("EX33_1","003_33_1","EXO","33","1","1","Mootiin Waan Maraa Muuse'een, «Atii fi kolbaan ati biyya Gibxi'ii keessaa baatte, gara lafa ani, ‹Sanyii teetiif hin kenna› jedhee, Abrahaamiif, Yisihaqii fi Yaaqoobiif kaku'uun waadaa gale sanii deema'a. ");
INSERT INTO gax_vpl VALUES ("EX33_2","003_33_2","EXO","33","2","2","Ani ergamaa isiniin dura ergee, Kana'aanota, Amoorota, Heetota, Pheriizota, Hiiwotaa fi Yibusoota ari'ee hin baasa. ");
INSERT INTO gax_vpl VALUES ("EX33_3","003_33_3","EXO","33","3","3","Gara lafa aananii fi dammaa san deema'a. Isin kolbaa mataa jabaattu waan teetaneef, karaa irratti akka isin hin balleessineef, ani isin woliin hin deemu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX33_4","003_33_4","EXO","33","4","4","Kolbaan dubbii rakkittuu tana yennaa dhageette, bowiisa jalqadde; nami tokkolle seesa adda addaa hin keyanne. ");
INSERT INTO gax_vpl VALUES ("EX33_5","003_33_5","EXO","33","5","5","Mootiin Waan Maraa Muuse'een «Ati Israa'elootaan, ‹Isin kolbaa mataa jabaattu waan teetaneef, ani haguma diqqaalle isin woliin adoo deemu te'ee isin hin balleessa. Amma seesa adda addaa ifi irraa baafadha'a; ani waan isin godhu hin murteessa› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX33_6","003_33_6","EXO","33","6","6","Maarre Israa'elooti gaara siina'aa irratti seesa ifii ka adda addaa ifi irraa baafatte. ");
INSERT INTO gax_vpl VALUES ("EX33_7","003_33_7","EXO","33","7","7","Muuseen Dunkaanii san fuudhee addee quttumaatiin ala irraa fageessee dhaabee, «Dunkaanii Woldeenna'aa» jedhee moggaase. Nami Mootii Waan Maraa wo gaafatuu barbaadu marti gara Dunkaanii Woldeenna'aa ta addee quttumaatiin ala jirtu san dhaqa. ");
INSERT INTO gax_vpl VALUES ("EX33_8","003_33_8","EXO","33","8","8","Yennaa Muuseen bayee gara dunkaani'ii deemu mara, kolbaan marti kaatee seensuma dunkaanii ifii dura dhaabbattee, haga Muuseen dunkaanii seenu ilaalti. ");
INSERT INTO gax_vpl VALUES ("EX33_9","003_33_9","EXO","33","9","9","Akkuma Muuseen gara Dunkaani'ii seeneen utubaan duumensaa gad bu'ee seensuma Dunkaani'ii dura dhaabbata; Mootiin Waan Maraalle duumensa keessaa Muusee woliin dubbata. ");
INSERT INTO gax_vpl VALUES ("EX33_10","003_33_10","EXO","33","10","10","Kolbaan utubaan duumensaa seensuma Dunkaani'ii dura dhaabbatuun yennaa dhaggitu mara, isaan martinuu ol ka'anee seensuma dunkaanii ifii duratti sagadan. ");
INSERT INTO gax_vpl VALUES ("EX33_11","003_33_11","EXO","33","11","11","Akkuma nami nama dhibii woliin dubbatu, Mootiin Waan Maraa fuula duratti Muusee woliin dubbata; achiin duuba Muuseen gara addee quttumaa deebi'a; Iyaasuun ilmi Nunii dargaggeessichi isa qarqaaru sun ammoo dunkaanii lakkisee hin deemu. ");
INSERT INTO gax_vpl VALUES ("EX33_12","003_33_12","EXO","33","12","12","Muuseen Mootii Waan Maraatiin, «Ati, ‹Kolbaa tana sooressi› jettee natti hinteerta; te'uu malee, nama na woliin ergitu natti hin hinne; ati, ‹Ani si beeka; na birattille fudhatama qadda› naan jetteerta. ");
INSERT INTO gax_vpl VALUES ("EX33_13","003_33_13","EXO","33","13","13","Ani si biratti yoo fudhatama qabaadhe, akka si beeku, yennaa mara si biratti fudhatama qabaadhu karaa keeti na barsiisi. Kolbaan tunille kolbaa teeti akka teete qaabadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX33_14","003_33_14","EXO","33","14","14","Mootiin Waan Maraalle deebisee, «Anumatti si woliin ideema; fooralle si'iif hin kenna» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX33_15","003_33_15","EXO","33","15","15","Muuseelle deebisee, «Ati yoo nu woliin hin ideenne teete asii nu hin baasin. ");
INSERT INTO gax_vpl VALUES ("EX33_16","003_33_16","EXO","33","16","16","Ati yoo nu woliin hin ideemin, anii fi kolbaan teeti si biratti fudhatama akka qannu nami attam beeka ree? Ati nu woliin yoo hin jiraatin, anaa fi kolbaa teeti, kolbaa biyya lafaa ta dhibii irraa wonni nu adda godhu maan ree?» jedhe ");
INSERT INTO gax_vpl VALUES ("EX33_17","003_33_17","EXO","33","17","17","Mootiin Waan Maraa Muuse'een, «Ati na biratti fudhatma waan qadduuf, maqaa keetille'een waan si beekuuf, waan ati na gaafatte kana mara si'iif hin godha» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX33_18","003_33_18","EXO","33","18","18","Achiin duuba Muuseen, «Maganne'e, ulfinna keeti natti mudhisi» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX33_19","003_33_19","EXO","33","19","19","Mootiin Waan Maraa deebisee, «Dansummaa tiyya mara si'iin dura hin dabarsa; ani maqaa kiyya, Mootii Waan Maraa si biratti hin lallaba. Ani namuma mararfadhu, hin mararfadha; namuma itti gadhaa laafuuf, gadhaa hin laafaaf. ");
INSERT INTO gax_vpl VALUES ("EX33_20","003_33_20","EXO","33","20","20","Garuu, nami fuula kiyya dhagge le'uu waan hin dandeenneef, ati fuula kiyya dhagguu hin dandeettu. ");
INSERT INTO gax_vpl VALUES ("EX33_21","003_33_21","EXO","33","21","21","Kunoo, addeen ati rassaa irra dhaabbattu, na bira jirti. ");
INSERT INTO gax_vpl VALUES ("EX33_22","003_33_22","EXO","33","22","22","Yennaa ulfinni kiyya achiin dabaru, baqaqa rassa'aa keessa si keyee, ani haga dabarutti harka kiyyaan si golla. ");
INSERT INTO gax_vpl VALUES ("EX33_23","003_33_23","EXO","33","23","23","Achiin duuba ani harka kiyya si duraa fuudhee, ati dudda kiyya hin dhaggita; garuu fuula kiyya hin dhaggitu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX34_1","003_34_1","EXO","34","1","1","Mootiin Waan Maraa Muuse'een, «Dhakaa baxxicha lama kama qaraa kaan fakkeessiitii boci. Anille jechoota dhakaa ati caccassite kaan irra jiranu san irratti hin barreessa. ");
INSERT INTO gax_vpl VALUES ("EX34_2","003_34_2","EXO","34","2","2","Ganamaan qophowiitii gara gaara siina'aa ol bayi. Achitti qaccee gaaraa gubba'atti na dura dhaabbadhu. ");
INSERT INTO gax_vpl VALUES ("EX34_3","003_34_3","EXO","34","3","3","Nami tokkolle si woliin ol hin bayin yookiin gaara irratti eessalle'etti hin mudhatin; gaara san jala horiille hin tikatin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX34_4","003_34_4","EXO","34","4","4","Maarre Muuseen dhakaa baxxicha lama ka seerri irratti barreeffame kama qaraa kaan ka fakkaatu bocee, akkuma Mootiin Waan Maraa isa ajaje dhakaa baxxicha lama ka seerri irratti barreeffame san harkatti qabatee barii ganama gara gaara Siina'aa ol baye. ");
INSERT INTO gax_vpl VALUES ("EX34_5","003_34_5","EXO","34","5","5","Achiin duuba Mootiin Waan Maraa duumensa keessa gad bu'ee achitti isa woliin dhaabbatee maqaa ifii, Mootii Waan Maraa lallabe. ");
INSERT INTO gax_vpl VALUES ("EX34_6","003_34_6","EXO","34","6","6","Inni Muusee dura dabaree, lallabee, «Ani Mootiin Waan Maraa, Mootii Waan Maraa, Waaqa mararaa arja'a; ka aari'iif hin ariifanne; jaalalli kiyya ka bara baraatii fi arjummaan tiyya baca'a. ");
INSERT INTO gax_vpl VALUES ("EX34_7","003_34_7","EXO","34","7","7","Jaalala kiyya ka bara baraa haga dhaloota kuma heddu'uutitti hin eegadha; hammeenna, finqilaa fi cubbuu hin araarama. Te'uu malee, yakkaamessa adoo hin adabin hin lakkisu; ijoollee isaaniitii fi ijoollee ijoollee isaanii haga dhaloota sadii fi afuriititti, cubbuu abbooti'iitiif hin adaba» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX34_8","003_34_8","EXO","34","8","8","Muuseen yennuma san lafatti gad gombifamee sagadee, ");
INSERT INTO gax_vpl VALUES ("EX34_9","003_34_9","EXO","34","9","9","«Ee Gootta'a, ani yoo si biratti fudhatama dhaggadhee jiraadhe, ani akka ati nu woliin ideentu si daadimadha. Kolbaan tun mataa jabeeyyii teetulle, hammeennaa fi cubbuu teenna nuu araaramiitii kolbaa teeti nu tolfadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX34_10","003_34_10","EXO","34","10","10","Achiin duuba Mootiin Waan Maraa Muuse'een, «Kunoo, ani Gondooroo si woliin godhataara; kolbaa teeti mara duratti biyya lafaa irratti kolbaa lafa irra jirtu mara keessatti baasa tanaan qara te'ee hin beenne hin godha. Kolbaan ati odduu leetu, baasa ani Mootiin Waan Maraa sii godhu hin dhaggiti. ");
INSERT INTO gax_vpl VALUES ("EX34_11","003_34_11","EXO","34","11","11","Waan ani adha si ajaju muummessi. Ani Amoorota, Kana'aanota, Heetota, Pheriizota, Hiiwotaa fi Yibusoota si duraa hin ari'a. ");
INSERT INTO gax_vpl VALUES ("EX34_12","003_34_12","EXO","34","12","12","Akka isaan tiyyoo si'itti hin teene, addee ati dhaqaartu worra lafa san keessa le'u woliin Gondooroo akka hin goone ifi eeggadhu. ");
INSERT INTO gax_vpl VALUES ("EX34_13","003_34_13","EXO","34","13","13","Addee ciinca'aa ta isaanii diiga'a; soodduu isaanii woyyittii butucha'a; utubaa waaqa dharaa ta, ‹Asheeraa› jedhantu ta isaanii jissa'a. ");
INSERT INTO gax_vpl VALUES ("EX34_14","003_34_14","EXO","34","14","14","Ani Mootii Waan Maraa, Waaqa hinaatticha waan te'eef, waaqa dhibii hin waaqonfatin. ");
INSERT INTO gax_vpl VALUES ("EX34_15","003_34_15","EXO","34","15","15","«Kolbaa lafa sanii woliin akka wol hin Gondoorre ifi eeggadhu; sababille isaan waaqota ifii gula fiiganee yennaa ciincaa dhikeessanu si hin waaman; atille ciincaa san hin nyaatta. ");
INSERT INTO gax_vpl VALUES ("EX34_16","003_34_16","EXO","34","16","16","Ilmaan teeti durra isaanii yennaa fuusifatte, durri sun waaqota ifii gula fiiganee, ilmaan teetille akka isaanii waaqota isaanii gula akka hin fiinne ifi eeggadhu. ");
INSERT INTO gax_vpl VALUES ("EX34_17","003_34_17","EXO","34","17","17","«Sibiila baqe irraa waaqota dharaa hin hujatin. ");
INSERT INTO gax_vpl VALUES ("EX34_18","003_34_18","EXO","34","18","18","«Jila daabboo uukoo hin qannee jilifadhu; ji'a Abiibii keessa biyya Gibxi'iitii waan baateef, akkuma ani si ajajetti guyyaa torba daabboo uukoo hin qanne nyaadhu. ");
INSERT INTO gax_vpl VALUES ("EX34_19","003_34_19","EXO","34","19","19","«Ilmi angafa te'ee dhalate marti kiyya; jibichi yookiin korbeessi qara dhalatelle kiyya. ");
INSERT INTO gax_vpl VALUES ("EX34_20","003_34_20","EXO","34","20","20","Harree korma qara dhalate buruusoo korbeessa hoole'eetiin wodi; yoo woduu dhadde ammoo morma isaa micciiri; ilmaan teeti keessaa angaficha wodi. «Nami tokkolle harka duwwaa na dura hin dhikaatin. ");
INSERT INTO gax_vpl VALUES ("EX34_21","003_34_21","EXO","34","21","21","«Guyyaa jaa hujii teeti hujadhu; guyyaa torbeesso'oo ammoo foorfadhu; yennaa qottee facaafattu, yennaa midhaan galfattulle teetu foorfadhu. ");
INSERT INTO gax_vpl VALUES ("EX34_22","003_34_22","EXO","34","22","22","«Midhaan qamadi'ii ka matooma bilchaatu yennaa galfattu, jila torbaan torbaa jilifadhu; dhuma wogga'aa irralle'etti, jila midhaan galfatiisaa jilifadhu. ");
INSERT INTO gax_vpl VALUES ("EX34_23","003_34_23","EXO","34","23","23","Dhiirtiin marti wogga'atti yennaa sad ana Mootii Waan Maraa ka Waan Mara Dande'u, Waaqa Israa'el duratti dhaggamanuu ti. ");
INSERT INTO gax_vpl VALUES ("EX34_24","003_34_24","EXO","34","24","24","Ani gosa biyya adda addaa si duraa ari'ee lafa teeti si'iif hin badhisa; wogga'atti yennaa sad ana Goottaa Waaqa keeti duratti dhaggamiisaaf yennaa ol baatu, nami tokkolle lafa teeti hin fudhatu. ");
INSERT INTO gax_vpl VALUES ("EX34_25","003_34_25","EXO","34","25","25","«Daabboo uukoo qaddu dhiiga ciinca'aa ka anaaf dhikaate woliin hin dhikeessin; foon horii Jila Irra Dabaramaatiif qalame irraa haga ganamaa hin tursin. ");
INSERT INTO gax_vpl VALUES ("EX34_26","003_34_26","EXO","34","26","26","«Waan latti si'iif baache keessaa midhaan matoomaa ka irra caalaa dansa'aa ana Mootii Waan Maraa Waaqa keetiif dhikeessi. «Buruusoo re'e'ee aanan haadha isi'iitiin hin iffeelin» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX34_27","003_34_27","EXO","34","27","27","Achiin duuba Mootiin Waan Maraa Muuse'een, «Ani jechoota kanaan si woliin, kolbaa Israa'elii wolille'een Gondooroo waan gondooradheef, jechoota kana barreeffadhu!» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX34_28","003_34_28","EXO","34","28","28","Muuseen midhaan adoo hin nyaatin, bisaanille adoo hin unin guyyaa afurtamaa fi halkan afurtama Mootii Waan Maraa woliin achi ture. Inni jechoota Gondooro'oo, ajajoota kudhan dhakaa baxxicha irratti barreesse. ");
INSERT INTO gax_vpl VALUES ("EX34_29","003_34_29","EXO","34","29","29","Muuseen dhakaa baxxicha lama ka seerri irratti barreeffame san harkatti qabatee gaara irraa yennaa gad bu'e, inni Mootii Waan Maraa woliin dubbataa waan tureef, fuulli isaa akka ifiisatti jiru hin beenne. ");
INSERT INTO gax_vpl VALUES ("EX34_30","003_34_30","EXO","34","30","30","Aaronii fi Israa'elooti marti Muusee yennaa dhaggane, fuulli isaa waan ifiisatti jiruuf gara isaa dhikaatiisa sodaatane. ");
INSERT INTO gax_vpl VALUES ("EX34_31","003_34_31","EXO","34","31","31","Muuseen ammoo isaan waamee, Aaronii fi sooressitooti kolba'aa marti gara isaa deebi'ane; innille isaanitti dubbate. ");
INSERT INTO gax_vpl VALUES ("EX34_32","003_34_32","EXO","34","32","32","Achiin duuba kolbaan Israa'elii marti Muusee bira dhufanee, inni ajaja Mootiin Waan Maraa gaara Siina'aa gubba'atti isatti dubbate san isaan ajaje. ");
INSERT INTO gax_vpl VALUES ("EX34_33","003_34_33","EXO","34","33","33","Muuseen isaanitti dubbatee fixeen duuba fuula ifii hagooggate. ");
INSERT INTO gax_vpl VALUES ("EX34_34","003_34_34","EXO","34","34","34","Muuseen Mootii Waan Maraa woliin dubbbatiisaaf, fuula isaa dura yennaa dhikaatu, hagoogguu fuula ifii irraa dhooggata; yennaa gad bayu ammoo waan ajajame mara Israa'elootatti hima. ");
INSERT INTO gax_vpl VALUES ("EX34_35","003_34_35","EXO","34","35","35","Isaan fuulli Muuse'ee akka ifu dhaggane. Achiin duuba inni Mootii Waan Maraa woliin dubbatiisaaf, yennaa dhaqu mara fuula ifii hin hagooggata. ");
INSERT INTO gax_vpl VALUES ("EX35_1","003_35_1","EXO","35","1","1","Muuseen wolde'a gumii Israa'elii mara wolitti qabee, isaaniin, «Wonni akka isin gootanuuf Mootiin Waan Maraa isin ajaje ta asii gad jirtu: ");
INSERT INTO gax_vpl VALUES ("EX35_2","003_35_2","EXO","35","2","2","Guyyaan jaa guyyaa huji'ii ti; guyyaan torbeesso'oo ammoo Sanbata woyyicha ka ana Mootii Waan Maraatiif itti foorfattanu. Nami guyyaa Sanbataa hujii huje marti ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("EX35_3","003_35_3","EXO","35","3","3","Guyyaa Sanbataa mana keessanitti ibiddalle hin gabbifatina'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX35_4","003_35_4","EXO","35","4","4","Muuseen kolbaa Israa'elii maraan «Wonni Mootiin Waan Maraa isin ajaje asii gad jirti: ");
INSERT INTO gax_vpl VALUES ("EX35_5","003_35_5","EXO","35","5","5","Isin waan qaddanu keessaa ana Mootii Waan Maraatiif kennansa dhikeessa'a! Nami kennansa kenniisaaf fedhu, kennansa worqi'ii, ka meeti'iitii fi sageettu'uu dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("EX35_6","003_35_6","EXO","35","6","6","Woyaa bifa cuquliisaa, woyaa bifa dhiille'eetii fi woyaa bifa liilana diima'aa, woyaa quncee talba'aa, woyaa rifeensa re'e'ee, ");
INSERT INTO gax_vpl VALUES ("EX35_7","003_35_7","EXO","35","7","7","gogaa korbeessa hoole'ee ka hallame, gogaa hoolee galaanaa, muka gololchaa, ");
INSERT INTO gax_vpl VALUES ("EX35_8","003_35_8","EXO","35","8","8","zayitii ejersaa ta ifaaf teetu, uddowaa zayitii ejersaa ta dibatanutti naqanu, hixaana foolee dansa'aa, ");
INSERT INTO gax_vpl VALUES ("EX35_9","003_35_9","EXO","35","9","9","dhakaa gatii guddo'ootii fi dooqa adda addaa ka woyaa hayyumma'aa ta qomaatii fi kiisii qomaatitti naqanu dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("EX35_10","003_35_10","EXO","35","10","10","«Isin keessaa worri ogummaa qabu marti dhufee waan Mootiin Waan Maraa ajaje mara hujuu ti: ");
INSERT INTO gax_vpl VALUES ("EX35_11","003_35_11","EXO","35","11","11","Dunkaanii Woyyittii, irbuusa isi'ii ka jala aanuu fi ka gubbaa aanu, hookkota isi'ii, danqaraa isi'ii, mikikkiloota isi'ii, utuboota isi'iitii fi shafee utuboota isi'ii, ");
INSERT INTO gax_vpl VALUES ("EX35_12","003_35_12","EXO","35","12","12","Saanduqa Gondooro'oo utuboota isi'ii woliin, qadaaddaa addee gumaan araara cubbu'uu irra keyamuu fi gollaa isaa, ");
INSERT INTO gax_vpl VALUES ("EX35_13","003_35_13","EXO","35","13","13","xarapheessaa, danqaraa isaatii fi meya isaa mara woliin, daabboo na dura dhikaattulle, ");
INSERT INTO gax_vpl VALUES ("EX35_14","003_35_14","EXO","35","14","14","issa'aafille waan issaa irra keyanu meya isi'ii woliin, issa'aa fi zayitii ejersaa ta ifaaf teetu, ");
INSERT INTO gax_vpl VALUES ("EX35_15","003_35_15","EXO","35","15","15","addee ciinca'aa ta hixaanni irratti aarfamu danqaraa isi'ii woliin, zayitii muudaatii fi hixaana uddowu, gollaa karaa balbala seensuma Dunkaanii Woyyitti'ii, ");
INSERT INTO gax_vpl VALUES ("EX35_16","003_35_16","EXO","35","16","16","addee ciinca'aa ta kennansa gubamuu, waan akka meemme'ee ka sageettuu irraa hujame ka cilee kiphee daadhaa gad harcaasu ka isi'ii woliin, danqaraa isi'ii meya isaa mara woliin, qorii itti dhiqatanu ta sageettuu irraa hujante shafee isi'ii woliin; ");
INSERT INTO gax_vpl VALUES ("EX35_17","003_35_17","EXO","35","17","17","gollaa badhinna dalleya keessaa utuboota isaatii fi shafee utubootaa woliin, gollaa seensuma gara badhinna sanii; ");
INSERT INTO gax_vpl VALUES ("EX35_18","003_35_18","EXO","35","18","18","chikaalota Dunkaani'ii, chikaalota badhinna dalleya keessaa saniitii fi wodaroota isaanii; ");
INSERT INTO gax_vpl VALUES ("EX35_19","003_35_19","EXO","35","19","19","woyaa kuulante woyyittii ta Aaroniin hayyichii fi ilmaan isaa addee woyyittii keessa yennaa hayyumma'aan tajaajilanu uffatanu hujanuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX35_20","003_35_20","EXO","35","20","20","Achiin duuba kolbaan Israa'elii marti Muusee biraa ka'anee deemane. ");
INSERT INTO gax_vpl VALUES ("EX35_21","003_35_21","EXO","35","21","21","Nami kennansa kenniisaaf fedhee, gadhaan isaa isa kakkaase, dhufee hujii Dunkaanii Woldeenna'aatiif, tajaajila isi'ii maraaf, woyaa hayyootaatiifille kennansa Mootii Waan Maraatiif fidane. ");
INSERT INTO gax_vpl VALUES ("EX35_22","003_35_22","EXO","35","22","22","Worri fedhii qabu marti dhiirtii fi dubartiille dhufanee faaya worqi'ii ka adda addaa: dirata, qubee gurraa, qubee qubaatii fi seesa adda addaa mara kennane. Isaan martinuu kennansa addaa worqii ifii Mootii Waan Maraatiif fidane. ");
INSERT INTO gax_vpl VALUES ("EX35_23","003_35_23","EXO","35","23","23","Worri woyaa bifa cuquliisaa, woyaa dhiillee, liilana diimaa, woyaa rifeensa re'e'ee, woyaa quncee talba'aa dansaa, gogaa korbeessa hoole'ee ka hallame qabu marti fide. ");
INSERT INTO gax_vpl VALUES ("EX35_24","003_35_24","EXO","35","24","24","Nami meetii yookiin sageettuu qabu marti Mootii Waan Maraatiif kenne; nami muka gololchaa qabulle hujii adda addaatiif ka te'u fide. ");
INSERT INTO gax_vpl VALUES ("EX35_25","003_35_25","EXO","35","25","25","Dubartooti ogummaa qabanu marti woyaa bifa cuquliisaa, bifa dhiille'ee, liilana diimaa yookiin woyaa quncee talba'aa dansaa, waan harka ifiitiin suqane mara fidane. ");
INSERT INTO gax_vpl VALUES ("EX35_26","003_35_26","EXO","35","26","26","Dubartooti huji'iif fedhii qabaatanee ogummaa qabanu marti rifeensa re'e'ee suqane. ");
INSERT INTO gax_vpl VALUES ("EX35_27","003_35_27","EXO","35","27","27","Sooressitooti dhakaa gatii guddo'ootii fi dooqa adda addaa ka woyaa hayyumma'aa ta qomaatii fi kiisii qomaatitti naqanu fidane. ");
INSERT INTO gax_vpl VALUES ("EX35_28","003_35_28","EXO","35","28","28","Akkasuma isaan uddowaa, zayitii ejersaa ta ifaaf teetuu fi ta muudaaf teetu, hixaana foolee dansa'aalle fidane. ");
INSERT INTO gax_vpl VALUES ("EX35_29","003_35_29","EXO","35","29","29","Kolbaan Israa'elii marti dhiirtii fi dubartooti, hujii Mootiin Waan Maraa akka isaan hujanuuf karaa Muuse'eetiin isaan ajaje maraaf, kennansa fedhii ifii Mootii Waan Maraatiif fidane. ");
INSERT INTO gax_vpl VALUES ("EX35_30","003_35_30","EXO","35","30","30","Achiin duuba Muuseen Israa'elootaan, «Kunoo, Mootiin Waan Maraa gosa Yihuda'aa keessaa akaakoo Huurii, ilma Urii Bazaali'el filateera; ");
INSERT INTO gax_vpl VALUES ("EX35_31","003_35_31","EXO","35","31","31","ogumma'aan, dandeetti'ii fi beekkumsaan, ogummaa hujii harkaa ta adda addaalle akka huju ayyaana ifiitiin isa guuteera. ");
INSERT INTO gax_vpl VALUES ("EX35_32","003_35_32","EXO","35","32","32","Inni akka itti worqii, meeti'ii fi sageettuu hujanu karoora baasa. ");
INSERT INTO gax_vpl VALUES ("EX35_33","003_35_33","EXO","35","33","33","Inni dhakaa dhodhoosee qiriixee, mukalle bocee xabbee, hujii harkaa mara hin huja. ");
INSERT INTO gax_vpl VALUES ("EX35_34","003_35_34","EXO","35","34","34","Mootiin Waan Maraa innii fi ilmi Ahisamaakii Aholiiyaab ka gosa Daanii, worra kaan akka barsiisanu isaan lamaaniifuu dandeettii kenneera. ");
INSERT INTO gax_vpl VALUES ("EX35_35","003_35_35","EXO","35","35","35","Isaan ogeeyyii hujii harkaa, worra karoora baasu, liilana bifa cuquliisaatiin, ka bifa dhiille'eetiin, ka bifa diima'aa ka quncee talba'aa dansa'aatiin worra kuuluu fi worra woyaa dhowu, ogeeyyii waan maraatii fi worra karoora baasu te'anee hujii adda addaa akka hujanu inni ogumma'aan isaan guuteera. ");
INSERT INTO gax_vpl VALUES ("EX36_1","003_36_1","EXO","36","1","1","«Maarre, Bazaali'elii fi Aholiiyaab, nami ogummaa qabu, ka Mootiin Waan Maraa hujii addee woyyitti'ii mara attam akka jalqabu akka beekuuf, ogumma'aa fi dandeettii kenneef marti, akkuma Mootiin Waan Maraa ajajetti worra huji huju» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX36_2","003_36_2","EXO","36","2","2","Achiin duuba Muuseen Bazaali'elii fi Aholiiyaab, nama ogummaa qabu ka Mootiin Waan Maraa dandeettii kenneef, worra dhufee hujii hujiisaaf fedhelle waame. ");
INSERT INTO gax_vpl VALUES ("EX36_3","003_36_3","EXO","36","3","3","Isaan kennansa Israa'elooti ijaarsa addee Woyyitti'ii jalqabiisaaf fidde mara Muusee harkaa fuudhane. Kolbaan Israa'eliille kennansa fedhii ifii ganama mara Muuse'etti kennite. ");
INSERT INTO gax_vpl VALUES ("EX36_4","003_36_4","EXO","36","4","4","Maarre Worri ogummaa hujii harkaa qabu ka hujii addee Woyyitti'ii hujiisatti jiru marti hujii lakkisanee gara Muuse'ee dhaqanee, ");
INSERT INTO gax_vpl VALUES ("EX36_5","003_36_5","EXO","36","5","5","Muuse'een, «Kolbaan hujii Mootiin Waan Maraa akka hujantu ajajeef ka barbaachisu caalaa kennansa fidiisatti jirti» jedhane. ");
INSERT INTO gax_vpl VALUES ("EX36_6","003_36_6","EXO","36","6","6","Achiin duuba Muuseen, «Nami tokkolle dhiirti yookiin dubartiin kennansa addee Woyyitti'ii dabalanee waan tokkolle hin kennin» jedhanee addee quttumaa keessa guutumatti akka lassanu ajaje. Maarre kolbaan kennansa akka hin finne dhooggane. ");
INSERT INTO gax_vpl VALUES ("EX36_7","003_36_7","EXO","36","7","7","Sababille kennansi qara fidaneeyyuu hujii hujantu mara geyee irraa hin hafa. ");
INSERT INTO gax_vpl VALUES ("EX36_8","003_36_8","EXO","36","8","8","Namoota hujii Dunkaanii Woyyitti'ii san hujanu keessaa worri ogummaa qabu marti gollaa qoola kudhan: ka liilana quncee talba'aa dansaa, ka bifa cuquliisaa, ka bifa dhiille'ee fi diimaa irraa wolitti fowamee dhowameen, ta fakkiin dada ol-gubba'aa ta koola qaddu, nama hujii harkaa beekuun, irratti hodhanteen Dunkaanii Woyyittii hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_9","003_36_9","EXO","36","9","9","Gollaan sun tokko tokkoon isaa dheerinni ciqilee diddamii saddeeti badhinni ciqilee afur, marti isaaniituu wol qixa. ");
INSERT INTO gax_vpl VALUES ("EX36_10","003_36_10","EXO","36","10","10","Isaan qoola golla'aa san shanan wolitti hodhanee, shanan hafane kaanille akkasuma tolchane. ");
INSERT INTO gax_vpl VALUES ("EX36_11","003_36_11","EXO","36","11","11","Achiin duuba isaan irga qoola golla'aa ka wolitti hodhamee sanitti qubeelee bifa cuquliisaa itti naqe; qoola golla'aa ka wolitti hodhame ka gama kaanii irralle'etti akkasuma tolchane. ");
INSERT INTO gax_vpl VALUES ("EX36_12","003_36_12","EXO","36","12","12","Isaan ammalle irga qoola golla'aa ka wolitti hodhamane ka qaraatitti qubeelee shantama, ka lammeesso'oo irralle'etti qubeelee shantama, ta moggaa gama lamaaniituu fuullee wolitti galchanee itti naqane. ");
INSERT INTO gax_vpl VALUES ("EX36_13","003_36_13","EXO","36","13","13","Achiin duuba isaan Dunkaaniin Woyyittiin takkattii akka teetu, qoola golla'aa ta wolitti hodhamane san wolitti qassiisiisaaf hookkoo worqi'ii shantama hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_14","003_36_14","EXO","36","14","14","Isaan Dunkaanii Woyyittii san akka gollanuuf, gollaa rifeensa re'e'ee irraa hujame kudhanii tokko hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_15","003_36_15","EXO","36","15","15","Gollaan kudhanii tokko sun tokko tokkoon isaaniituu dheerinni isaanii ciqilee soddoma, badhinni isaanii ciqilee afur te'anee marti isaaniituu wol qixa. ");
INSERT INTO gax_vpl VALUES ("EX36_16","003_36_16","EXO","36","16","16","Isaan gollaa shanan wolitti qassiisanee hodhanee, jaan hafane kaanille gara kaaniin wolitti qassiisanee hodhane. ");
INSERT INTO gax_vpl VALUES ("EX36_17","003_36_17","EXO","36","17","17","Achiin duuba isaan irga gollaa wolitti hodhamane ka qaraatitti qubeelee shantama, ka lammeesso'oo irralle'etti qubeelee shantama itti hodhane. ");
INSERT INTO gax_vpl VALUES ("EX36_18","003_36_18","EXO","36","18","18","Isaan gollaa gama lamaanii san wolitti qassiisanee Dunkaanii Woyyittii takkattii tolchiisaaf hookkoo sageettu'uu shantama hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_19","003_36_19","EXO","36","19","19","Achiin duuba isaan gogaa korbeessa hoole'ee ka hallame irraa Dunkaanii Woyyittii saniif irbuusa hujane; ka dhibiille gogaa hoolee galaana irraa hujanee irra buusane. ");
INSERT INTO gax_vpl VALUES ("EX36_20","003_36_20","EXO","36","20","20","Isaan mikikkiloota Dunkaanii Woyyittii ittiin ol dhaabbachiisanu muka gololchaa irraa hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_21","003_36_21","EXO","36","21","21","Dheerinni mikikkiloota sanii ciqilee kudhan, badhinni isaanii ciqilee tokkoo fi wodhakka'a. ");
INSERT INTO gax_vpl VALUES ("EX36_22","003_36_22","EXO","36","22","22","Mikikkilooti Dunkaanii Woyyitti'ii sun akka wol keessa seenanu qaccee irratti gaafa lama ka cinaa wolii jiru hujane; isaan akka kanaan mikikkiloota Dunkaanii Woyyitti'ii mara hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_23","003_36_23","EXO","36","23","23","Isaan Dunkaanii Woyyittii cinaa gara kibbaatiif mikikkiloota diddama hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_24","003_36_24","EXO","36","24","24","Mikikkiloota diddama saniifille shafee meetii irraa hujante afurtama hujane; gaafoti lama ka mikikkila tokkoo akka keessa seenanuuf shafee lama lama hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_25","003_36_25","EXO","36","25","25","Isaan Dunkaanii Woyyittii san cinaa gara kaabaatiif mikikkiloota diddama hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_26","003_36_26","EXO","36","26","26","Mikikkiloota diddama saniifille, shafee meetii irraa hujante afurtama hujanee, mikikkila tokko tokko jala shafee lama lama keyane. ");
INSERT INTO gax_vpl VALUES ("EX36_27","003_36_27","EXO","36","27","27","Isaan Dunkaanii Woyyittii cinaa gara aduun seentuutiif mikikkila jaa hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_28","003_36_28","EXO","36","28","28","Roga Dunkaanii Woyyitti'ii ka irga irgaatiifille mikikkila lama lama hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_29","003_36_29","EXO","36","29","29","Roga lamaan kana irratti mikikkilooti kun jalaa haga gubba'aatitti lama lama te'anee, qubee takkattii keessa seenan. Gara lamaaniinuu akkasuma te'an. ");
INSERT INTO gax_vpl VALUES ("EX36_30","003_36_30","EXO","36","30","30","Maarre mikikkiloota saddeetii fi shafee meetii irraa hujante kudhanii jaatti achi jiraayyu; mikikkila tokko tokkoofuu shafee lama lamatti itti keyame. ");
INSERT INTO gax_vpl VALUES ("EX36_31","003_36_31","EXO","36","31","31","Isaan ammalle muka gololchaa irraa danqaraa shanan mikikkiloota cinaa gara tokkootiif, ");
INSERT INTO gax_vpl VALUES ("EX36_32","003_36_32","EXO","36","32","32","shanan mikikkiloota cinaa gara kaaniitiif, shanan hafane mikikkiloota gara seensa adu'uu jiranuuf hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_33","003_36_33","EXO","36","33","33","Isaan danqaraa wodhakka'aa, ka mikikkiloota wodhakkaa cinaa kaan irraa haga cinaa gara kaaniititti fulla'u hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_34","003_36_34","EXO","36","34","34","Isaan mikikkiloota san worqii itti gonfanee, danqarooti sun akka keessa seenanu qubeelee worqi'ii hujane; danqaroota sanille worqii itti gonfane. ");
INSERT INTO gax_vpl VALUES ("EX36_35","003_36_35","EXO","36","35","35","Isaan liilana quncee talba'aa dansaa, ka bifa cuquliisaa, ka bifa dhiille'ee fi diimaa irraa wolitti fowamee dhowameen gollaa nami hujii harkaa beeku, fakkii dada ol-gubba'aa ta koola qadduu irratti hodhe hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_36","003_36_36","EXO","36","36","36","Isaan gollaa saniif utuboota muka gololchaa afur hujanee worqii itti gonfane; utuboota saniif hookkoo worqi'ii afur itti hujanee, meetii baqisiifame irralle'ee shafee afur itti hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_37","003_36_37","EXO","36","37","37","Isaan seensuma Dunkaanii Woyyitti'iitiif, liilana quncee talba'aa dansaa, ka bifa cuquliisaa, ka bifa dhiille'ee fi diimaa irraa fowamee dhowameen nama hujii harkaa beekuun gollaa hujane. ");
INSERT INTO gax_vpl VALUES ("EX36_38","003_36_38","EXO","36","38","38","Isaan gollaa saniif utubaa hookkoo qabanu shan hujane; guutuu utuboota saniitii fi qubeelee isaanii worqii itti gonfane; utuboota saniifille shafee shan sageettuu irraa hujane. ");
INSERT INTO gax_vpl VALUES ("EX37_1","003_37_1","EXO","37","1","1","Bazaali'el Saanduqa Gondooro'oo ta dheerinni isi'ii ciqilee lamaa fi wodhakka'aa, badhinni isi'ii ciqilee tokkoo fi wodhakka'aa, hojjaan isi'ii ciqilee tokkoo fi wodhakka'aa muka gololchaa irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX37_2","003_37_2","EXO","37","2","2","Inni keessa isi'iitii fi duuba isi'ii worqii qulluu itti gonfe; roga isi'ii irra naannessee xiyyoo worqii itti huje. ");
INSERT INTO gax_vpl VALUES ("EX37_3","003_37_3","EXO","37","3","3","Inni qubee worqi'ii afur hujee, lamaan gara tokkoon, lamaan gara kaaniin, miila isi'ii afurittuu qassiise. ");
INSERT INTO gax_vpl VALUES ("EX37_4","003_37_4","EXO","37","4","4","Achiin duuba inni muka gololchaa irraa danqaraa bocee worqii itti gonfe. ");
INSERT INTO gax_vpl VALUES ("EX37_5","003_37_5","EXO","37","5","5","Danqaraa isii ittiin ba'atanu, qubeelee Saanduqa Gondooro'oo ta gama lamaaniin jirtu san keessa galche. ");
INSERT INTO gax_vpl VALUES ("EX37_6","003_37_6","EXO","37","6","6","Qadaaddaa addee gumaan araara cubbu'uu irra keyamu ta dheerinni isi'ii ciqilee lamaa fi wodhakka'aa, badhinni isi'ii ciqilee tokkoo fi wodhakka'aa worqii irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX37_7","003_37_7","EXO","37","7","7","Achiin duuba inni dada ol-gubba'aa ta koola qaddu lama worqii tumante irraa qaccee lama ta qadaaddaa Saanduqa Gondooro'oo irratti huje. ");
INSERT INTO gax_vpl VALUES ("EX37_8","003_37_8","EXO","37","8","8","Dada ol-gubba'aa ta koola qaddu san tokko qaccee gara tokkootitti, dada ol-gubba'aa ta koola qaddu ta lammeesso'oo qaccee garakaaniititti keye; dada ol-gubba'aa ta koola qaddu san qaccee qadaaddaa Saanduqa Gondooro'oo lamaanittuu wolitti qassiisee tokko tolche. ");
INSERT INTO gax_vpl VALUES ("EX37_9","003_37_9","EXO","37","9","9","Dadi ol-gubba'aa ta koola qaddu sun koola ifii ol badhifatanee qadaaddaa san irra gonboobaneeraniiyyu; fuula ifiille wolitti galanee, qadaaddaa Saanduqa Gondooro'oo san ilaalaniiyyu. ");
INSERT INTO gax_vpl VALUES ("EX37_10","003_37_10","EXO","37","10","10","Inni Xarapheessaa dheerinni isaa ciqilee lamaa, badhinni isaa ciqilee tokkoo, hojjaan isaa ciqilee tokkoo fi wodhakka'aa muka gololchaa irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX37_11","003_37_11","EXO","37","11","11","Achiin duuba inni Worqii qulluu itti gonfe; roga isaa irralle naannessee worqii itti gonfe. ");
INSERT INTO gax_vpl VALUES ("EX37_12","003_37_12","EXO","37","12","12","Inni xiyyoo haga badhinna ganaa harkaa geettu irga isaa irratti naannessee worqii itti gonfe. ");
INSERT INTO gax_vpl VALUES ("EX37_13","003_37_13","EXO","37","13","13","Xarapheessaa saniif qubee worqi'ii afur hujee, addee miilli isaa afur jirutti roga isaa afur irratti qassiise. ");
INSERT INTO gax_vpl VALUES ("EX37_14","003_37_14","EXO","37","14","14","Qubeeleen afur sun danqaraa xarapheessaa ittiin ba'atanu akka qaddu, xiyyoo san bira keye. ");
INSERT INTO gax_vpl VALUES ("EX37_15","003_37_15","EXO","37","15","15","Danqaraa muka gololchaa irraa huje; xarapheessaa san ittiin ba'atiisaaf worqii itti gonfe. ");
INSERT INTO gax_vpl VALUES ("EX37_16","003_37_16","EXO","37","16","16","Waan daadhii woyni'ii ittiin dhikeessanu gabataa, qorii, kobolaa fi muduunuu worqii qullittii irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX37_17","003_37_17","EXO","37","17","17","Inni Waan issaa irra keyanu worqii qullittii irraa huje. Miila isi'ii, ulee isi'ii, muduunuu daraaraa fakkaattu, guntuta daraara'aatii fi daraaraa seesaa waan issaa irra keyanu san woliin wolitti qassiisee tokko tolchee huje. ");
INSERT INTO gax_vpl VALUES ("EX37_18","003_37_18","EXO","37","18","18","Waan ifa irra keyannu kana irratti dameelee jaa, gara tokkoon sad, gara kaaniin sad huje. ");
INSERT INTO gax_vpl VALUES ("EX37_19","003_37_19","EXO","37","19","19","Dameelee waan issaa irra keyanuu jaanuu irratti, muduunuun daraaraa muka «Almond» jedhamuu fakkaattu ta seesa guntuta daraara'aatii fi seesa daraara'aa qaddu sad jiraniiyyu. ");
INSERT INTO gax_vpl VALUES ("EX37_20","003_37_20","EXO","37","20","20","Waan issaa irra keyanu san irra, muduunuun daraaraa muka «Almond» jedhamuu fakkaattu afur ta seesa guntuta daraara'aatii fi seesa daraara'aa qaddu jirtiiyyu. ");
INSERT INTO gax_vpl VALUES ("EX37_21","003_37_21","EXO","37","21","21","Dameelee waan issaa irra keyanuu lamaan qaraa jala guntuti daraara'aa tokko, dameelee lamaan ka lammeesso'oo jala guntuti daraara'aa ka lammeesso'oo, dameelee lamaan sadeesso'oo jala guntuti daraara'aa ka sadeesso'oo jiraniiyyu. ");
INSERT INTO gax_vpl VALUES ("EX37_22","003_37_22","EXO","37","22","22","Guntuti daraara'aatii fi dameeleen sun martinuu waan issaa irra keyanu san woliin wolitti qassiifamanee tokko te'anee, worqii qullittii irraa hujamane. ");
INSERT INTO gax_vpl VALUES ("EX37_23","003_37_23","EXO","37","23","23","Inni ifa torba waan ifa irra keyanu, qarapha'aa fi waan daadhaa itti harcaasanu worqii qulluu irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX37_24","003_37_24","EXO","37","24","24","Inni waan issaa irra keyanuu fi meya isi'ii mara worqii qullittii kiiloogiraama soddomii shanii irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX37_25","003_37_25","EXO","37","25","25","Inni addee ciinca'aa ta hixaana itti ciincessanu muka gololchaatiin ijaare. Dheerinni isi'ii ciqilee tokko, badhinni isi'ii ciqilee tokko, hojjaan isi'ii ciqilee lama te'ee, rogi arfanuu wol qixa. Roga arfanittuu gaafota itti baase ");
INSERT INTO gax_vpl VALUES ("EX37_26","003_37_26","EXO","37","26","26","Inni gubbaa isi'iitii fi roga isi'ii mara, gaafota isi'iille worqii qulluu itti gonfe. Roga isi'ii irra naannessee xiyyoo worqi'ii itti huje. ");
INSERT INTO gax_vpl VALUES ("EX37_27","003_37_27","EXO","37","27","27","Inni danqaraa keessa loosanee addee ciinca'aa ittiin ba'atanu, qubee worqi'ii lama hujee, xiyyoo jalatti gama lamaanittuu qassiise. ");
INSERT INTO gax_vpl VALUES ("EX37_28","003_37_28","EXO","37","28","28","Inni muka gololchaa irraa danqaraa hujee worqii itti gonfe. ");
INSERT INTO gax_vpl VALUES ("EX37_29","003_37_29","EXO","37","29","29","Inni akka worri fiqiree dansaa qopheessu hujuu, zayitii woyyittii ta muudaatii fi hixaana qulluu ka foolee dansa'aalle huje. ");
INSERT INTO gax_vpl VALUES ("EX38_1","003_38_1","EXO","38","1","1","Bazaali'el addee ciinca'aa ta kennansa gubamuu muka gololchaatiin ijaare. Dheerinni isi'ii ciqilee shan, badhinni isi'iille ciqilee shan, hojjaan isi'ii ciqilee sad. ");
INSERT INTO gax_vpl VALUES ("EX38_2","003_38_2","EXO","38","2","2","Inni gaafotii fi addeen ciinca'aa tokko akka te'anu roga isi'ii arfanuu irratti gaafota itti baasee, sageettuu itti gonfe. ");
INSERT INTO gax_vpl VALUES ("EX38_3","003_38_3","EXO","38","3","3","Meya addee ciinca'aa san mara okkotee daadhaa itti haranu, waan ibidda irratti bobeessanu, qorii dhiiga fiffixanu qabattu, filaa fooniille sageettuu irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX38_4","003_38_4","EXO","38","4","4","Inni waan akka meemme'ee sageettuu irraa hujee, haga hidha addee ciinca'aa ol akka dheerattu, xiyyoo isi'ii jala keye. ");
INSERT INTO gax_vpl VALUES ("EX38_5","003_38_5","EXO","38","5","5","Inni roga arfan waan akka meemme'ee san irratti danqaraa ittiin ba'atanu akka keessa galchanu qubeelee afur itti huje. ");
INSERT INTO gax_vpl VALUES ("EX38_6","003_38_6","EXO","38","6","6","Inni addee ciinca'aa san akka ittiin ba'atanu, danqaraa muka gololchaa hujee sageettuu itti gonfe. ");
INSERT INTO gax_vpl VALUES ("EX38_7","003_38_7","EXO","38","7","7","Danqaraa san addee ciinca'aa akka ittiin ba'atanu, qubeelee addee ciinca'aa cinaa gama lamaaniitiin jirtu san keessa galche. Inni addee ciinca'aa san boollessee falaxaa irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX38_8","003_38_8","EXO","38","8","8","Inni gabataa itti dhiqatanuu fi shafee isaa ta sageettu'uu, daaw'itii sageettu'uu ta dubartoota seensuma Dunkaanii Woldeenna'aa tajaajilanuu irraa huje. ");
INSERT INTO gax_vpl VALUES ("EX38_9","003_38_9","EXO","38","9","9","Inni itti aansee badhinna Dunkaanii Woldeenna'aatitti dalleya ijaare. Badhinni dalleyaa keessaa sun karaa kibbaatiin ciqilee dhibba; gollaa quncee talba'aa dansaa irraa wolitti fowamee hujame qabaatee, ");
INSERT INTO gax_vpl VALUES ("EX38_10","003_38_10","EXO","38","10","10","utuboota shafee sageettu'uu qabanu diddama ka hookko'oo fi qubeelee meetii irraa hujamane ifi irraa qabanu qabaayyu. ");
INSERT INTO gax_vpl VALUES ("EX38_11","003_38_11","EXO","38","11","11","Gara kaabaatille'een akkuma kana ciqilee dhibba dheeratee, utuboota shafee sageettu'uu qabanu diddama ka hookko'oo fi qubeelee meetii irraa hujamane ifi irraa qabanu qabaayyu. ");
INSERT INTO gax_vpl VALUES ("EX38_12","003_38_12","EXO","38","12","12","Badhinni dalleya keessaa sun gara seensa adu'uutiin, ciqilee shantama badhatee, golla'aa fi utuboota kudhan shafee kudhan qabanu, ka hookko'oo fi qubeelee meetii irraa hujamane ifi irraa qabanu qabaayyu. ");
INSERT INTO gax_vpl VALUES ("EX38_13","003_38_13","EXO","38","13","13","Dhuma gara ila boru'uu, karaa aduun baatulle'een, ciqilee shantama badhata. ");
INSERT INTO gax_vpl VALUES ("EX38_14","003_38_14","EXO","38","14","14","Dheerinni golla'aa seensuma irraa gara tokkoon ciqilee kudhanii shan te'ee, utuboota sad ka shafee sad qabanu qabaayyu. ");
INSERT INTO gax_vpl VALUES ("EX38_15","003_38_15","EXO","38","15","15","Akkasuma seensuma irraa gara kaaniin dheerinni golla'aa ciqilee kudhanii shan te'ee, utuboota sad ka shafee sad qabanu qaba. ");
INSERT INTO gax_vpl VALUES ("EX38_16","003_38_16","EXO","38","16","16","Gollaan cinaa badhinna dalleya keessaa jiru marti quncee talba'aa dansaa wolitti fooyame irraa hujame. ");
INSERT INTO gax_vpl VALUES ("EX38_17","003_38_17","EXO","38","17","17","Shafeen utubootaa ta sageettuu irraa hujante yoo teetu, hookko'oo fi qubeeleen utuboota irra jiranu meetii irraa hujamane; guutuun utubootaalle meetiin itti gonfanteerti. Utubooti badhinna dalleya keessaa marti qubeelee qaban. ");
INSERT INTO gax_vpl VALUES ("EX38_18","003_38_18","EXO","38","18","18","Gollaan seensuma badhinna dalleya keessaa liilana quncee talba'aa dansaa ka bifa cuquliisaa, ka bifa dhiille'ee fi diimaa irraa nama hujii harkaa beekuun dhowame. Dheerinni isaa ciqilee diddama; akkuma gollaa badhinna dalleya keessaa hojjaan isaa ciqilee shan. ");
INSERT INTO gax_vpl VALUES ("EX38_19","003_38_19","EXO","38","19","19","Utubooti isaa afurii fi shafeen isaa arfanuu sageettuu irraa hujamane; hookkoti utubootaatii fi qubeeleen utubootaa meetii irraa hujamane. Guutuun utubootaalle meetiin itti gonfanteerti. ");
INSERT INTO gax_vpl VALUES ("EX38_20","003_38_20","EXO","38","20","20","Chikaaloti Dunkaanii Woyyitti'iitii fi ka badhinna dalleya keessaa marti sageettuu irraa hujamane. ");
INSERT INTO gax_vpl VALUES ("EX38_21","003_38_21","EXO","38","21","21","Mey Dunkaanii Woyyitti'ii, ka Itaamaariin Lewwichi ilmi Aaronii hayyichaa, ajaja Muuse'eetiin, tarre'etti barreessee qopheesse asii gad jira: ");
INSERT INTO gax_vpl VALUES ("EX38_22","003_38_22","EXO","38","22","22","Akaakoon Huurii ilmi Urii Bazaali'el, gosa Yihuda'aa keessaa waan Mootiin Waan Maraa Muusee ajaje mara huje. ");
INSERT INTO gax_vpl VALUES ("EX38_23","003_38_23","EXO","38","23","23","Gosa Daanii keessaa ilmi Ahisamaakii Aholiiyaab, ka hujii harkaa beeku, ka karoora baasu fi ka liilana quncee talba'aa dansaa bifa cuquliisaatiin, ka bifa dhiille'ee fi diima'aan woy seesee hodhu isa woliin jiraayyu. ");
INSERT INTO gax_vpl VALUES ("EX38_24","003_38_24","EXO","38","24","24","Dunkaanii Woyyittii ijaariisaaf worqiin kennansa tachoofamuuf kennante sun wolumatti akka madaallii Dunkaanii Woyyitti'iititti kiiloogiraama kuma tokko. ");
INSERT INTO gax_vpl VALUES ("EX38_25","003_38_25","EXO","38","25","25","Meetiin kolbaa laakkowante irraa wolitti qabante, akka madaallii Dunkaanii Woyyitti'iititti gara kiiloogiraama kuma sadii fi dhibba afurii fi soddomaa ti. ");
INSERT INTO gax_vpl VALUES ("EX38_26","003_38_26","EXO","38","26","26","Namooti worra qara laakkowametti dabalamane ka woggaan isaanii diddamaa fi diddamaa olii laakkossi isaanii kuma dhibba jaa fi kuma sadii fi dhibba shanii fi shantama. Isaan kun mataa mataa isaaniititti akka madaallii Dunkaanii Woyyitti'iititti meetii gara giraama kudhanii tokkoo kennane. ");
INSERT INTO gax_vpl VALUES ("EX38_27","003_38_27","EXO","38","27","27","Meetiin kiiloogiraam kum sadii fi dhibbi afur baqisiifantee shafee Dunkaanii Woyyitti'iitii fi shafee golla'aa dhibba hujante. Shafeen tokko tokkoo meetii kiiloogiraama soddomii fi afuriin hujante. ");
INSERT INTO gax_vpl VALUES ("EX38_28","003_38_28","EXO","38","28","28","Meetii kiiloo giraama soddoma hatteen Bazaali'el utuba'aa fi hookkota utubootaa hujee guutuu utubootaalle itti gonfe. ");
INSERT INTO gax_vpl VALUES ("EX38_29","003_38_29","EXO","38","29","29","Sageettuun kennansa tachoofamuuf kennante kiiloogiraama kuma lamaa fi dhibba afurii fi diddamii shan. ");
INSERT INTO gax_vpl VALUES ("EX38_30","003_38_30","EXO","38","30","30","Isuma tanaan shafee seensuma Dunkaanii Woldeenna'aa, addee ciinca'aatii fi waan akka meemme'ee ta addee ciinca'aa sanii, meya isi'ii maralle, ");
INSERT INTO gax_vpl VALUES ("EX38_31","003_38_31","EXO","38","31","31","Shafee dalleya badhinna Dunkaanii Woldeenna'aa, shafee karra badhinna Dunkaanii Woldeenna'aa, chikaalota Dunkaanii Woldeenna'aa ka badhinna Dunkaanii Woldeenna'aatitti naanneffameeru mara huje. ");
INSERT INTO gax_vpl VALUES ("EX39_1","003_39_1","EXO","39","1","1","Isaan woyaa kuulante ta addee woyyittii keessa yennaa tajaajilanu uffatanu liilana bifa cuquliisaa, ka bifa dhiille'eetii fi diima'aatiin hujane. Isaan akkuma Mootiin Waan Maraa Muusee ajaje, woyaa woyyittiille Aaroniif hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_2","003_39_2","EXO","39","2","2","Isaan woyaa hayyumma'aa ta qomaa worqi'iin, liilana bifa cuquliisaatiin, ka bifa dhiille'eetiin, ka bifa diima'aa ka quncee talba'aa dansa'aa ka wolitti fowameen hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_3","003_39_3","EXO","39","3","3","Isaan worqii worri hujii harkaa beeku baqisiisanee hephelleessanee hujane akka liilanaa kukkutanee liilana bifa cuquliisaa, ka bifa dhiille'eetii fi diima'aatiin wolitti fowane. ");
INSERT INTO gax_vpl VALUES ("EX39_4","003_39_4","EXO","39","4","4","Gurmuu lamaan irra hiituu lama ta qaccee duraa fi duubaa lama wolitti hiitu woyaa hayyumma'aa ta qomaa saniif hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_5","003_39_5","EXO","39","5","5","Hiituun worra hujii harkaa beekuun hujante sun akkuma Mootiin Waan Maraa Muusee ajaje, akkuma woyaa hayyumma'aa ta qomaa san worqi'iin, liilana bifa cuquliisaatiin, ka bifa dhiille'eetiin, ka bifa diima'aa ka quncee talba'aa dansa'aan wolitti fowantee hujantee, woyaa hayyumma'aa ta qomaa woliin tokko teetee wolitti qassiifante. ");
INSERT INTO gax_vpl VALUES ("EX39_6","003_39_6","EXO","39","6","6","Isaan dhakaa gatii guddo'oo lama fuudhanee, maqaa ijoollee Yaaqoobii kudhanii lamaa akka chaappa'aa irratti qiriixane. ");
INSERT INTO gax_vpl VALUES ("EX39_7","003_39_7","EXO","39","7","7","Achiin duuba isaan akkuma Mootiin Waan Maraa Muusee ajaje, dhakaa gatii guddo'oo san Yaadannoo ilmaan Yaaqoobiitiif, hiituu woyaa hayyumma'aa ta qomaa ta gurmuu Aaronii irratti qassiisane. ");
INSERT INTO gax_vpl VALUES ("EX39_8","003_39_8","EXO","39","8","8","Isaan kiisii qomaa ta akka nami hujii harkaa beeku hujuu hujane; akkuma woyaa hayyumma'aa ta qomaa worqi'iin, liilana bifa cuquliisaatiin, ka bifa dhiille'eetiin, ka bifa diima'aa ka quncee talba'aa dansa'aa ka wolitti fowameen hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_9","003_39_9","EXO","39","9","9","Kiisiin sun dheerinni isi'ii taakkuu tokko, badhinni isi'iille taakkuu tokko teetee, dachaafantee rogi isi'ii arfanuu wolqixa. ");
INSERT INTO gax_vpl VALUES ("EX39_10","003_39_10","EXO","39","10","10","Achiin duuba isaan isii irratti dhakaa gatii guddo'oo tarree afuriin itti maxxansane; tarree qaraatitti dhakaan gatii guddo'oo saardiyon, tophaaziyon fi simaaragidos, ");
INSERT INTO gax_vpl VALUES ("EX39_11","003_39_11","EXO","39","11","11","tarree lammeesso'ootitti kaarbunkil, safiirosii fi Yaasphis, ");
INSERT INTO gax_vpl VALUES ("EX39_12","003_39_12","EXO","39","12","12","tarree sadeesso'ootitti hiiyaakinxos, kaalqedon, ametiisxos, ");
INSERT INTO gax_vpl VALUES ("EX39_13","003_39_13","EXO","39","13","13","tarree arfeesso'ootitti kirisoliixos, sardoniikis fi beerilos seesa xiyyoo worqi'ii ta daraaraa fakkaattuun itti maxxansane. ");
INSERT INTO gax_vpl VALUES ("EX39_14","003_39_14","EXO","39","14","14","Gosa Israa'elii kudhanii lamaaf qaabbii akka te'u, dhakoota gatii guddo'oo kudhanii lamaan san irratti, maqaan ilmaan Yaaqoobii kudhanii lamaa ka tokko tokkootuu akka chaappa'aa irratti qiriixameera. ");
INSERT INTO gax_vpl VALUES ("EX39_15","003_39_15","EXO","39","15","15","Isaan kiisii qomaa saniif seesa haachaba worqii qullu'uu, ka akka wodaro'oo fowame hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_16","003_39_16","EXO","39","16","16","Xiyyoo seesa worqi'ii ta daraaraa fakkaattuu fi qubeelee worqi'ii lama hujanee roga kiisii qomaa san lamaanitti qassiisane. ");
INSERT INTO gax_vpl VALUES ("EX39_17","003_39_17","EXO","39","17","17","Seesa haachaba worqii qullu'uu lamaan san, qubeelee lama ta roga kiisii qomaa irra jirtu saniin wolitti qassiisane. ");
INSERT INTO gax_vpl VALUES ("EX39_18","003_39_18","EXO","39","18","18","Qaccee seesa haachabootaa san lamaan, hiituu woyaa hayyumma'aa ta qomaa ta gara duraatiin jirtu ta gurmuu irra qaxxaamurtu keessa galchanee, xiyyoo seesa worqi'ii lama ta daraaraa fakkaatu saniin wolitti qassiisane. ");
INSERT INTO gax_vpl VALUES ("EX39_19","003_39_19","EXO","39","19","19","Qubeelee worqi'ii lama hujanee, roga lama ka kiisii qomaa ka dhibi'iititti, qaccee kiisii qomaa ta gara keessaa ta woyaa hayyumma'aatitti aantee jirtutti qassiisane. ");
INSERT INTO gax_vpl VALUES ("EX39_20","003_39_20","EXO","39","20","20","Achiin duuba isaan qubeelee worqi'ii ta dhibii lamaan hujanee, gara duraatiin, hiituu woyaa hayyumma'aa ta qomaa ta gurmuu irra qaxxaamurtu gara jalaatiin addee hiituun woyaa hayyumma'aa ta qomaa wolitti hodhanteertuun gubba'atti qassiisane. ");
INSERT INTO gax_vpl VALUES ("EX39_21","003_39_21","EXO","39","21","21","Akkuma Mootiin Waan Maraa Muusee ajaje, qubeelee kiisii qomaa irra jirtu, kiisiin qomaa woyaa hayyumma'aa ta qomaatiin akka wol gad hin lakkinne, hiitu'uun wolitti qassiisiisaan, liilana bifa cuquliisaatiin qubeelee woyaa hayyumma'aa ta qomaatiin wolitti hidhane. ");
INSERT INTO gax_vpl VALUES ("EX39_22","003_39_22","EXO","39","22","22","Qoloo woyaa hayyumma'aa ta qomaa woliin uffatanu guutumatti liilana bifa cuquliisaatiin hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_23","003_39_23","EXO","39","23","23","Gara gubba'aa wodhakkaa isi'iitiin qowa mataan seenu qaddiiyyu; qowi sun akka hin tarsaane goodameera. ");
INSERT INTO gax_vpl VALUES ("EX39_24","003_39_24","EXO","39","24","24","Handaara qoloo sanii ka liilana bifa cuquliisaatiin, ka bifa dhiille'eetii fi diima'aa ka quncee talba'aa dansa'aatiin wolitti fowamee dhowame san jalatti fakkii midhaan muka rumaanii itti hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_25","003_39_25","EXO","39","25","25","Isaan worqii qulluu irraa bilbilalle hujanee, handaara sanitti naannessanee, odduu odduu fakkii midhaan muka rumaanii sanitti hidhane. ");
INSERT INTO gax_vpl VALUES ("EX39_26","003_39_26","EXO","39","26","26","Bilbilli fi fakkiin midhaan muka rumaanii sun irga handaara qolo'oo san irratti tarreeffamanee wol geyan; qoloo tana akkuma Mootiin Waan Maraa Muusee ajajetti, hayyichi yennaa tajaajila hayyumma'aa uffata. ");
INSERT INTO gax_vpl VALUES ("EX39_27","003_39_27","EXO","39","27","27","Isaan ammalle Aaronii fi ilmaan isaatiif quncee talba'aa dansaa irraa qoloo haga miilaa dheerattu, ");
INSERT INTO gax_vpl VALUES ("EX39_28","003_39_28","EXO","39","28","28","marata mata'aa, gullee mata'aatii fi mutaandii woyaa jalaan hidhatanu ta hidhaa kaatee haga gudeedaa geettu ta fowantee dhowante isaaniif hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_29","003_39_29","EXO","39","29","29","Hiituu liilana quncee talba'aa dansaa irraa wolitti fowantee dhowante ta bifa cuquliisaa, ta bifa dhiille'eetii fi diimaa irraa akkuma Mootiin Waan Maraa Muusee ajajetti hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_30","003_39_30","EXO","39","30","30","Isaan kallacha woyyicha, worqii qulqullu'uu hujanee, akka barreeffama chaappaa irratti barreeffamee, «Mootii Waan Maraatiif ka woyyoome» jedhanee irratti qiriixane. ");
INSERT INTO gax_vpl VALUES ("EX39_31","003_39_31","EXO","39","31","31","Achiin duuba isaan akkuma Mootiin Waan Maraa Muusee ajajetti, liilana bifa cuquliisaatiin hidhanee, marata mata'aatitti qassiisane. ");
INSERT INTO gax_vpl VALUES ("EX39_32","003_39_32","EXO","39","32","32","Maarre hujiin Dunkaanii Woyyittii, Dunkaanii Woldeenna'aa sun hobbaate. Israa'elooti waan mara akkuma Mootiin Waan Maraa Muusee ajajetti hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_33","003_39_33","EXO","39","33","33","Achiin duuba isaan Dunkaanii Woyyittii Woldeenna'aa gara Muuse'ee fidane: Dunkaanii Woyyitti'ii fi meya isi'ii mara, hookkoo isi'ii, mikikkiloota isi'ii, danqaraa isi'ii, utuboota isi'ii, shafeelee isi'ii, ");
INSERT INTO gax_vpl VALUES ("EX39_34","003_39_34","EXO","39","34","34","irbuusa gogaa korbeessa hoole'ee ka hallame, irbuusa gogaa hoolee galaanaa, gollaa; ");
INSERT INTO gax_vpl VALUES ("EX39_35","003_39_35","EXO","39","35","35","Saanduqa Gondooro'oo utuboota isi'ii woliin, qadaaddaa addee gumaan araara cubbu'uu irra keyamulle; ");
INSERT INTO gax_vpl VALUES ("EX39_36","003_39_36","EXO","39","36","36","xarapheessaa meya isaa mara woliin, daabboo Waaqa dura dhikaatulle; ");
INSERT INTO gax_vpl VALUES ("EX39_37","003_39_37","EXO","39","37","37","waan issaa irra keyanu ka worqii qulluu irraa hujame ifa isaa ka tarreeffamee fi meya isaa mara woliin, zayitii ejersaa ta ifaaf teetu; ");
INSERT INTO gax_vpl VALUES ("EX39_38","003_39_38","EXO","39","38","38","addee ciinca'aa ta worqii irraa hujante; zayitii muudaa, hixaana foolee dansa'aatii fi gollaa seensuma Dunkaanii Woyyitti'ii; ");
INSERT INTO gax_vpl VALUES ("EX39_39","003_39_39","EXO","39","39","39","addee ciinca'aa ta sageettuu irraa hujante waan akka meemme'ee ta sageettuu irraa hujante ta isi'ii woliin, danqaraa isi'iitii fi meya isi'ii mara woliin; qorii itti dhiqatanu shafee isi'ii woliin; ");
INSERT INTO gax_vpl VALUES ("EX39_40","003_39_40","EXO","39","40","40","gollaa badhinna dalleya Dunkaanii Woldeenna'aa keessaa utuboota isaatii fi shafeelee utuboota isaa, gollaa seensuma badhinna dalleya Dunkaanii Woldeenna'aa keessaa; wodarootaa fi chikaalota dunkaanii ittiin dhaabanu, chikaalota badhinna dalleya Dunkaanii Woldeenna'aa keessaa, meya Dunkaanii Woyyitti'ii mara; ");
INSERT INTO gax_vpl VALUES ("EX39_41","003_39_41","EXO","39","41","41","woyaa kuulante woyyittii ta Aaroniin hayyichii fi ilmaan isaa addee woyyittii keessa yennaa hayyumma'aan tajaajilanu uffatanu fidane. ");
INSERT INTO gax_vpl VALUES ("EX39_42","003_39_42","EXO","39","42","42","Israa'elooti hujii mara akkuma Mootiin Waan Maraa Muusee ajajetti hujane. ");
INSERT INTO gax_vpl VALUES ("EX39_43","003_39_43","EXO","39","43","43","Muuseen hujii mara akkuma Mootiin Waan Maraa ajajetti hujuu isaanii dhagge. Achiin duuba inni isaan eebbise. ");
INSERT INTO gax_vpl VALUES ("EX40_1","003_40_1","EXO","40","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("EX40_2","003_40_2","EXO","40","2","2","«Dunkaanii Woyyittii, Dunkaanii Woldeenna'aa san ji'a tokkeesso'oo guyyaa qaraa dhaabi. ");
INSERT INTO gax_vpl VALUES ("EX40_3","003_40_3","EXO","40","3","3","Saanduqa Gondooro'oo ka dhakaan baxxichi ajaji kudhan irratti barreeffameeru keessa jiru san isii keessa keyiitii, golla'aan golli. ");
INSERT INTO gax_vpl VALUES ("EX40_4","003_40_4","EXO","40","4","4","Xarapheessaa Dunkaanii Woyyittii keessa galchiitii meya isaa irra naqi; achiin duuba waan issaa irra keyanulle Dunkaanii Woyyittii keessa galchiitii issaa isi'ii irra naqi. ");
INSERT INTO gax_vpl VALUES ("EX40_5","003_40_5","EXO","40","5","5","Addee ciinca'aa ta hixaanni irratti aarfamu ta worqii irraa hujante san Saanduqa Gondooro'oo ka dhakaan baxxichi ajaji irratti barreeffameeru keessa jiru san dura keyiitii, seensuma Dunkaanii Woyyitti'iille'etti gollaa keyi. ");
INSERT INTO gax_vpl VALUES ("EX40_6","003_40_6","EXO","40","6","6","«Addee ciinca'aa ta kennansa gubamuu seensuma Dunkaanii Woyyitti'ii, Dunkaanii Woldeenna'aa san dura keyi; ");
INSERT INTO gax_vpl VALUES ("EX40_7","003_40_7","EXO","40","7","7","qorii itti dhiqatanu Dunkaanii Woldeenna'aatii fi addee ciinca'aa wodhakkaa keyiitii, bisaan itti naqi. ");
INSERT INTO gax_vpl VALUES ("EX40_8","003_40_8","EXO","40","8","8","Badhinna dalleya keessaa ka Dunkaanii Woyyitti'ii keessaatitti naannessiitii dalleya itti ijaari; seensuma badhinna dalleya Dunkaanii Woyyitti'ii keessaa sanitti gollaa keyi. ");
INSERT INTO gax_vpl VALUES ("EX40_9","003_40_9","EXO","40","9","9","«Zayitii muudaa fuudhiitii Dunkaanii Woyyitti'ii fi waan isii keessa jiru mara muudi; isi'ii fi waan isii keessa jiru mara woyyoonsi; isiille woyyuu hin teeti. ");
INSERT INTO gax_vpl VALUES ("EX40_10","003_40_10","EXO","40","10","10","Achiin duuba addee ciinca'aa ta kennansa gubamuu fi meya isi'ii mara muudi; addee ciinca'aa san woyyoonsi; isiille woyyuu hin teeti. ");
INSERT INTO gax_vpl VALUES ("EX40_11","003_40_11","EXO","40","11","11","Qorii itti dhiqatanuu fi shafee isi'iille muudiitii woyyoonsi. ");
INSERT INTO gax_vpl VALUES ("EX40_12","003_40_12","EXO","40","12","12","«Aaronii fi ilmaan isaa gara seensuma Dunkaanii Woldeenna'aa san fidiitii bisaaniin dhiqi. ");
INSERT INTO gax_vpl VALUES ("EX40_13","003_40_13","EXO","40","13","13","Achiin duuba woyaa woyyittii Aaronitti uffisi; isa muudiitii akka inni hayyuu te'ee na tajaajilu woyyoonsi. ");
INSERT INTO gax_vpl VALUES ("EX40_14","003_40_14","EXO","40","14","14","Ilmaan isaa fidiitii qoloo haga miilaa dheerattu itti uffisi. ");
INSERT INTO gax_vpl VALUES ("EX40_15","003_40_15","EXO","40","15","15","Isaan hayyoota te'anee akka na tajaajilanu, akkuma abbaa isaanii muudde isaanille muudi; muudam isaanii kun dhaloota dhufu mara keessatti hayyummaa bara baraa te'ee hin jiraata» jedhe. ");
INSERT INTO gax_vpl VALUES ("EX40_16","003_40_16","EXO","40","16","16","Muuseen waan mara akkuma Mootiin Waan Maraa isa ajajetti huje. ");
INSERT INTO gax_vpl VALUES ("EX40_17","003_40_17","EXO","40","17","17","Maarre Dunkaaniin Woyyittiin woggaa lammeesso'oo keessaa ji'a tokkeesso'oo guyyaa qaraa dhaabbatte. ");
INSERT INTO gax_vpl VALUES ("EX40_18","003_40_18","EXO","40","18","18","Muuseen Dunkaanii Woyyittii san yennaa dhaabe, shafeelee isi'ii addee addee isi'iititti keyee, mikikkiloota isi'ii irratti dhaabe; danqaroota isi'ii keessa galchee, utuboota isi'iille dhaabe. ");
INSERT INTO gax_vpl VALUES ("EX40_19","003_40_19","EXO","40","19","19","Achiin duuba inni akkuma Mootiin Waan Maraa isa ajajetti gollaa Dunkaanii Woyyittii irra diriirse. ");
INSERT INTO gax_vpl VALUES ("EX40_20","003_40_20","EXO","40","20","20","Inni dhakaa baxxicha lamaan ajaji irratti barreeffameeru san fuudhee Saanduqa Gondooro'oo keessa keye; danqaroota qubeelee Saanduqa Gondooro'oo keessa galchee, qadaaddaa addee gumaan araara cubbu'uu irra keyamu irra keye. ");
INSERT INTO gax_vpl VALUES ("EX40_21","003_40_21","EXO","40","21","21","Achiin duuba akkuma Mootiin Waan Maraa isa ajajetti Saanduqa Gondooro'oo Dunkaanii Woyyittii keessa galchee, gollaa ittiin gollu fannisee, Saanduqa Gondooro'oo ta dhakaan baxxichi lama ka ajaji kudhan irratti barreeffameeru keessa jiru san golle. ");
INSERT INTO gax_vpl VALUES ("EX40_22","003_40_22","EXO","40","22","22","Muuseen xarapheessaa san Dunkaanii Woyyittii san gara kaabaatiin, golla'aan ala, Dunkaanii Woldeenna'aa san keessa keye. ");
INSERT INTO gax_vpl VALUES ("EX40_23","003_40_23","EXO","40","23","23","Akkuma Mootiin Waan Maraa isa ajajetti fuula Mootii Waan Maraa duratti daabboo irra keye. ");
INSERT INTO gax_vpl VALUES ("EX40_24","003_40_24","EXO","40","24","24","Inni waan issaa irra keyanu Dunkaanii Woldeenna'aa keessa fuullee xarapheessa'aa Dunkaanii Woyyittii gara kibbaatiin keyee, ");
INSERT INTO gax_vpl VALUES ("EX40_25","003_40_25","EXO","40","25","25","akkuma Mootiin Waan Maraa isa ajajetti issaa fuula Mootii Waan Maraa dura keye. ");
INSERT INTO gax_vpl VALUES ("EX40_26","003_40_26","EXO","40","26","26","Muuseen addee ciinca'aa ta worqii irraa hujante san Dunkaanii Woldeenna'aa keessa gollaa fuula dura keyee, ");
INSERT INTO gax_vpl VALUES ("EX40_27","003_40_27","EXO","40","27","27","akkuma Mootiin Waan Maraa isa ajajetti hixaana foolee dansa'aa irratti aarse. ");
INSERT INTO gax_vpl VALUES ("EX40_28","003_40_28","EXO","40","28","28","Achiin duuba inni seensuma Dunkaanii Woyyitti'iititti gollaa hidhe. ");
INSERT INTO gax_vpl VALUES ("EX40_29","003_40_29","EXO","40","29","29","Inni addee ciinca'aa ta kennansa gubamuu seensuma Dunkaanii Woyyitti'ii, Dunkaanii Woldeenna'aa san biratti qopheessee, akkuma Mootiin Waan Maraa isa ajajetti kennansa gubamuu fi kennansa midhaanii achi irratti dhikeesse. ");
INSERT INTO gax_vpl VALUES ("EX40_30","003_40_30","EXO","40","30","30","Inni qorii itti dhiqatanu wodhakkaa Dunkaanii Woldeenna'aatii fi addee ciinca'aa keyee, akka dhiqatanuuf bisaan itti naqee, ");
INSERT INTO gax_vpl VALUES ("EX40_31","003_40_31","EXO","40","31","31","Muuseen, Aaronii fi ilmaan isaa harka fi miila ifii itti dhiqatane. ");
INSERT INTO gax_vpl VALUES ("EX40_32","003_40_32","EXO","40","32","32","Akkuma Mootiin Waan Maraa Muusee ajajetti, isaan yennaa Dunkaanii Woldeenna'aa seenanu yookiin yennaa addee ciinca'aatitti dhikaatanu mara hin dhiqatan. ");
INSERT INTO gax_vpl VALUES ("EX40_33","003_40_33","EXO","40","33","33","Achiin duuba Muuseen badhinna dalleya keessaa ka Dunkaanii Woyyitti'iitii fi addee ciinca'aatitti naannessee dalleya ijaaree, seensuma badhinna dalleya keessaa ka Dunkaanii Woyyitti'ii keessaatitti gollaa hidhe; maarre akka kanaan Muuseen hujii fixe. ");
INSERT INTO gax_vpl VALUES ("EX40_34","003_40_34","EXO","40","34","34","Achiin duuba duumensi Dunkaanii Woldeenna'aa gollee, ulfinni Mootii Waan Maraalle Dunkaanii Woyyittii san guute. ");
INSERT INTO gax_vpl VALUES ("EX40_35","003_40_35","EXO","40","35","35","Duumensi Dunkaanii Woldeenna'aa irratti waan bu'eef, ulfinni Mootii Waan Maraalle Dunkaanii Woyyittii waan guuteef, Muuseen gara Dunkaanii Woldeenna'aa seeniisaaf hin dandeenne. ");
INSERT INTO gax_vpl VALUES ("EX40_36","003_40_36","EXO","40","36","36","Yennaa duumensi Dunkaanii Woyyittii irraa ka'e mara, Israa'elooti ka'anee ideeman; ");
INSERT INTO gax_vpl VALUES ("EX40_37","003_40_37","EXO","40","37","37","duumensi Dunkaanii Woyyittii irraa yoo ka'uu dhabe ammoo, haga guyyaa duumensi irraa ka'utti achii ka'anee hin ideemanu. ");
INSERT INTO gax_vpl VALUES ("EX40_38","003_40_38","EXO","40","38","38","Maarre Israa'elooti yennaa ideemanu mara, guyyaa guyyaa duumensi Mootii Waan Maraa Dunkaanii Woyyittii irra, halkan halkan ibiddi duumensa keessa jiruun dhaggan.");
INSERT INTO gax_vpl VALUES ("LV1_1","004_1_1","LEV","1","1","1","Mootiin Waan Maraa Dunkaanii Woldeenna'aa keessaa Muusee waamee, ");
INSERT INTO gax_vpl VALUES ("LV1_2","004_1_2","LEV","1","2","2","«Kolbaa Israa'elootaatiin ‹Isin keessaa nami ana Mootii Waan Maraatiif kennansa hori'ii yennaa dhikeessu, loon keessaa yookiin hoolee keessaa yookiin re'ee keessaa dhikeessuu ti› jedhi. ");
INSERT INTO gax_vpl VALUES ("LV1_3","004_1_3","LEV","1","3","3","Kennansi kun kennansa hori'ii ka gubamu yoo te'e, korma fafa hin qanne te'uu ti; Mootii Waan Maraa duratti fudhatama akka qabaatu, seensuma gara Dunkaanii Woldeenna'aa duratti dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_4","004_1_4","LEV","1","4","4","Nami sun harka ifii mataa horii kennansa gubamuu san irra kewuu ti; kunille gumaa cubbuu isaatiif bakka isaa bu'ee fudhatama qabaata. ");
INSERT INTO gax_vpl VALUES ("LV1_5","004_1_5","LEV","1","5","5","Inni korma ana Mootii Waan Maraa duratti qaluu ti; achiin duuba ilmaan Aaronii hayyooti dhiiga san fidanee addee ciinca'aa ta gara seensuma Dunkaanii Woldeenna'aa jirtu san cinaa isi'ii mara irratti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_6","004_1_6","LEV","1","6","6","Inni kennansa gubamu san gogaa irraa qalee kukkutuu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_7","004_1_7","LEV","1","7","7","Ilmaan Aaronii hayyichaa addee ciinca'aa irratti ibidda gabbisanee qoraan itti naqanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_8","004_1_8","LEV","1","8","8","Achiin duuba ilmaan Aaronii hayyooti foon kukkutame san, mata'aa fi cooma woliin qoraan addee ciinca'aa irratti bobe'u san irra tarree galchanee naqanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_9","004_1_9","LEV","1","9","9","Inni meya gadha'aatii fi manyee bisaaniin dhiquu ti; hayyichi meya gadha'aatii fi manyee san mara addee ciinca'aa irratti gubee aarsuu ti; kennansi kun ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu. ");
INSERT INTO gax_vpl VALUES ("LV1_10","004_1_10","LEV","1","10","10","«Kennansi gubamu kun tika hoole'ee yookiin tika re'ee keessaa yoo te'e, korbeessa fafa hin qanne te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_11","004_1_11","LEV","1","11","11","Inni addee ciinca'aa cinaa gara kaabaatitti fuula ana Mootii Waan Maraa duratti korbeessa san qaluu ti; ilmaan Aaronii hayyooti dhiiga isaa cinaa addee ciinca'aa san maratti dhangalaasanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_12","004_1_12","LEV","1","12","12","Inni foon san kukkutuu ti; hayyichille foon kukkutame san, mata'aa fi cooma woliin qoraan addee ciinca'aa irratti bobe'u san irra tarree galchee naquu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_13","004_1_13","LEV","1","13","13","Namichi meya gadha'aatii fi manyeelee san bisaaniin dhiquu ti. Hayyichi ammoo kennansa gubamu san mara addee ciinca'aa irratti gubuu ti; kennansi gubamu kun ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu. ");
INSERT INTO gax_vpl VALUES ("LV1_14","004_1_14","LEV","1","14","14","«Kennansi gubamu ka inni dhikeessu waan koolaan ka'u keessaa yoo te'e, saphaliisa yookiin maddoo te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_15","004_1_15","LEV","1","15","15","Hayyichi kennansa san addee ciinca'aatitti fidee, mataa micciiree, addee ciinca'aa irratti gubuu ti; dhiiga isi'ii cinaa addee ciinca'aa irratti coccossuu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_16","004_1_16","LEV","1","16","16","Daakuu isi'ii baala isi'ii woliin keessaa baasee, addee ciinca'aa gara baya adu'uutitti, addee daadhaa itti gatanutti gatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV1_17","004_1_17","LEV","1","17","17","Inni karaa koola isi'iitiin gad quncisuutii malee, irraa hin kutin; achiin duuba hayyichi qoraan addee ciinca'aa irratti bobe'u san irratti gubuu ti. Kun kennansa gubamu, ka ibiddaan gubamee dhikaatu, ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu. ");
INSERT INTO gax_vpl VALUES ("LV2_1","004_2_1","LEV","2","1","1","«Eennulle kennansa midhaanii ana Mootii Waan Maraatiif yennaa dhikeessu, bullaa dansaa irraa dhikeessuu ti. Inni zayitii ejersaa itti dhangalaasee, hixaanalle irra keyee, ");
INSERT INTO gax_vpl VALUES ("LV2_2","004_2_2","LEV","2","2","2","gara ilmaan Aaronii hayyootatti geessuu ti. Hayyichi bullaa dansaa ooboo tokko guutu'uu fi zayitiin ejersaa san, hixaana maraayyuu woliin fuudhee, yaadanno'oof akka te'u, kennansa ibiddaan gubamee dhikaatu, ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu godhee, addee ciinca'aa irratti gamisa gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV2_3","004_2_3","LEV","2","3","3","Ka hafe, kennansa midhaanii ka ana Mootii Waan Maraatiif dhikaatu, ka irra caalaa woyyicha te'e keessaa tokko waan te'eef, Aaronii fi ilmaan isaatiif kennamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV2_4","004_2_4","LEV","2","4","4","«Kennansi midhaanii ka boolla ibiddaa keessatti bilcheeffame yoo te'e, bullaa dansaa ta zayitii ejersaatiin sukkuumante, daabboo uukoo hin qanne yookiin bixee hephellittii zayitiin ejersaa irra dibame te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV2_5","004_2_5","LEV","2","5","5","Kennansi midhaanii ka eelee sibiilaatitti bilcheeffame yoo te'e, bullaa dansaa ta daabboo uukoo hin qanne ta zayitii ejersaatiin sukkuumante te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV2_6","004_2_6","LEV","2","6","6","Kennansa midhaanii waan te'eef daabboo san didiqqeessii caccassiitii zayitii ejersaa itti naqi. ");
INSERT INTO gax_vpl VALUES ("LV2_7","004_2_7","LEV","2","7","7","Kennansi midhaanii disitii keessatti ka bilcheeffame yoo te'e, bullaa dansaa ta zayitii ejersaatiin makante teetuu ti. ");
INSERT INTO gax_vpl VALUES ("LV2_8","004_2_8","LEV","2","8","8","Kennansa midhaanii ka waan kana irraa hujame ana Mootii Waan Maraatiif fidiitii, hayyicha gara addee ciinca'aa geessutti dhikeessi. ");
INSERT INTO gax_vpl VALUES ("LV2_9","004_2_9","LEV","2","9","9","Hayyichi kennansa midhaanii ka dhikaate kana irraa gamisa fuudhee, yaadanno'oof akka te'u, kennansa ibiddaan gubamee dhikaatu, ka akka dakkara foolee dansaa qadduu ka ana Mootii Waan Maraa gammachiisu godhee addee ciinca'aa irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV2_10","004_2_10","LEV","2","10","10","Ka hafe, kennansa midhaanii ka ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu keessaa irra caalaa woyyicha te'e keessaa tokko waan te'eef, Aaronii fi ilmaan isaatiif kennamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV2_11","004_2_11","LEV","2","11","11","«Kennansa midhaanii ka ibiddaan gubamu woliin uukoo yookiin damma gubiisa waan hin barbaachinneef, kennansa midhaanii ka gubamu ka ati ana Mootii Waan Maraatiif dhikeessitu keessa uukoon yookiin dammi hin jiraatin. ");
INSERT INTO gax_vpl VALUES ("LV2_12","004_2_12","LEV","2","12","12","Isin kennansa midhaan mata'aa ana Mootii Waan Maraatiif kennuu hin dandeettan; isaan kun ammoo kennansa gubamu ka foolee dansaa qabu te'anee, addee ciinca'aa irratti hin gubamanu. ");
INSERT INTO gax_vpl VALUES ("LV2_13","004_2_13","LEV","2","13","13","Kennansa midhaanii keeti mara sooddaan mi'eessita. Kennansa midhaanii keeti keessaa soodda gondooroo Waaqa keetii hin lakkisin; kennansa keeti mara soodda keessa buusi. ");
INSERT INTO gax_vpl VALUES ("LV2_14","004_2_14","LEV","2","14","14","«Ati kennansa midhaan mata'aa ana Mootii Waan Maraatiif yoo fidde, midhaan shawwee ibiddatti woddamee sharame dhikeessi. ");
INSERT INTO gax_vpl VALUES ("LV2_15","004_2_15","LEV","2","15","15","Inni kennansa midhaanii waan te'eef zayitii ejersaa itti dhangalaasiitii hixaanalle irra keyi. ");
INSERT INTO gax_vpl VALUES ("LV2_16","004_2_16","LEV","2","16","16","Kun kennansa ana Mootii Waan Maraatiif ibiddaan gubamee dhikaatu waan te'eef, hayyichi kennansa midhaan sharameetii fi zayitii ejersaa san gamisa, hixaana maraayyuu woliin yaadanno'oof akka te'u, ibiddaan gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_1","004_3_1","LEV","3","1","1","«Nami tokko kennansa tokkummma'aa loon keessaa yoo kennu te'e, korma yookiin sa'a fafa hin qanne Mootii Waan Maraa duratti dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_2","004_3_2","LEV","3","2","2","Inni harka ifii mataa horii kennansa dhikeessee san irra keyee, seensuma Dunkaanii woldeenna'aa duratti qaluu ti. Ilmaan Aaronii hayyooti dhiiga san cinaa addee ciinca'aa mara irratti dhangalaasanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_3","004_3_3","LEV","3","3","3","Kennansa tokkumma'aa kana irraa, ka ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu, moora meya gadha'aatitti marateeru maraa fi ka meya gadha'aa wolitti hidheeru mara, ");
INSERT INTO gax_vpl VALUES ("LV3_4","004_3_4","LEV","3","4","4","kalattii lamaanuu, moora isii irra jiru ka cinaa dirraa woliin, qaccee tiru'uu kalattii woliin baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_5","004_3_5","LEV","3","5","5","Achiin duuba ilmaan Aaronii addee ciinca'aa irratti, qoraan kennansa gubamuuf bobe'u irratti, kennansa ibiddaan gubamee dhikaatu, ka foolee dansaa qabu ana Mootii Waan Maraa gammachiisu godhanee gubanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_6","004_3_6","LEV","3","6","6","«Kennansi tokkumma'aaf kennamu karra hoole'ee yookiin re'e'ee keessaa yoo te'e, korbeessa yookiin dhaltuu fafa hin qanne te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_7","004_3_7","LEV","3","7","7","Nami tokko buruusoo hoole'ee yoo kenne, fuula ana Mootii Waan Maraa dura dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_8","004_3_8","LEV","3","8","8","Harka ifii mataa horii kennansa dhikeessee san irra keyee Dunkaanii Woldeenna'aa duratti qaluu ti. Ilmaan Aaronii dhiiga san cinaa addee ciinca'aa mara irratti dhangalaasanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_9","004_3_9","LEV","3","9","9","Kennansa tokkumma'aa kana irraa, ka ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu, duma hoole'ee irraa baasee, moora meya gadha'aatitti marateeruu fi meya gadha'aa wolitti hidheeru mara, ");
INSERT INTO gax_vpl VALUES ("LV3_10","004_3_10","LEV","3","10","10","kalattii lamaanuu, moora isii irra jiru ka cinaa dirraa woliin, qaccee tiru'uu kalattii woliin dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_11","004_3_11","LEV","3","11","11","Akka kennansa sagale'ee ka ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatuutitti, hayyichi isaan kana addee ciinca'aa irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_12","004_3_12","LEV","3","12","12","«Kennansi isaa re'ee yoo te'e, fuula ana Mootii Waan Maraa dura dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_13","004_3_13","LEV","3","13","13","Harka ifii mataa isi'ii irra keyee Dunkaanii Woldeenna'aa duratti qaluu ti. Ilmaan Aaronii dhiiga isi'ii cinaa addee ciinca'aa san maratti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_14","004_3_14","LEV","3","14","14","Kennansa kana irraa, ka ibiddaan gubamee dhikaatu, moora meya gadha'aatitti marateeru maraa fi moora meya gadha'aa wolitti hidheeru mara, ");
INSERT INTO gax_vpl VALUES ("LV3_15","004_3_15","LEV","3","15","15","kalattii lamaanuu, moora isii irra jiru ka cinaa dirraa woliin, qaccee tiru'uulle dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_16","004_3_16","LEV","3","16","16","Coomi martinuu kiyya waan te'eef, kennansa sagale'ee ka ibiddaan gubamee dhikaatu, ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu godhee, hayyichi addee ciinca'aa irratti ibiddaan gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV3_17","004_3_17","LEV","3","17","17","«Isin cooma mara, dhiiga maralle hin nyaatina'a! Kun addee leetanu maratti dhaloota dhufu maraaf seerata haga bara baraa te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV4_1","004_4_1","LEV","4","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV4_2","004_4_2","LEV","4","2","2","«Kolbaa Israa'elootaatiin, ‹Eennulle adoo hin beekin cubbuu yennaa hujee fi ajaja kiyya keessaa tokko irra dabaree waan dhooggame yoo huje, ");
INSERT INTO gax_vpl VALUES ("LV4_3","004_4_3","LEV","4","3","3","hayyichi guddaan cubbuu yoo huje, kolbaalle'etti yakkaa yoo fide, cubbuu huje saniif dardara fafa hin qanne kennansa araara cubbu'uutiif dhikaatu ana Mootii Waan Maraatiif dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_4","004_4_4","LEV","4","4","4","Dardara san seensuma Dunkaanii Woldeenna'aatitti ana Mootii Waan Maraa dura dhikeessuu ti. Harka ifii mataa dardara sanii irra keyee fuula kiyya duratti qaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_5","004_4_5","LEV","4","5","5","Hayyichi guddaan dhiiga dardara sanii irraa diqqaa isaa fuudhee gara Dunkaanii Woldeenna'aa seenuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_6","004_4_6","LEV","4","6","6","Inni quba ifii dhiiga sanitti cuuphee, diqqaa isaa gollaa addee irra caalaa woyyitti'ii gara duraatiin yennaa torba ana Mootii Waan Maraa duratti fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_7","004_4_7","LEV","4","7","7","Achiin duuba hayyichi dhiiga diqqaa isaa gaafota addee ciinca'aa ta Dunkaanii Woldeenna'aa keessaa, ta ana Mootii Waan Maraa duratti hixaana irratti aarsanu sanitti dibuu ti. Dhiiga dardaraa ka hafe, addee ciinca'aa ta kennansa gubamuu, ta seensuma Dunkaanii Woldeenna'aa dura jirtu jalatti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_8","004_4_8","LEV","4","8","8","Inni moora dardara araara cubbu'uutiif dhikaatee san mara: moora meya gadha'aatitti marateeruu fi wolitti hidheeru, ");
INSERT INTO gax_vpl VALUES ("LV4_9","004_4_9","LEV","4","9","9","kalattii lamaanuu moora isii irra jiru ka cinaa dirraa woliin, qaccee tiru'uu kalattii woliin dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_10","004_4_10","LEV","4","10","10","Akkuma moora kennansa tokkumma'aaf dhikaate irraa fuudhamee san, hayyichi addee ciinca'aa ta kennansa gubamuu irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_11","004_4_11","LEV","4","11","11","Ammoo gogaa dardaraatii fi foon isaa mara, akkasuma mata'aa fi manyee isaa, meya gadha'aa, ");
INSERT INTO gax_vpl VALUES ("LV4_12","004_4_12","LEV","4","12","12","addee quttumaatiin alatti baasee, addee akka aadaa dhugeeffanna'aatitti qulqulluu teete, addee daadhaan itti haramutti, ibidda qoraaniitiin gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_13","004_4_13","LEV","4","13","13","« ‹Wolde'i Israa'elii marti adoo hin beekiniiyyuu cubbuu hujanee, ajaja kiyya keessaa tokko irra dabaranee waan dhooggame yoo hujane, wonni sun wolde'a san duratti beekkamuu dhaddulle, isaan yakkaameyyi'i. ");
INSERT INTO gax_vpl VALUES ("LV4_14","004_4_14","LEV","4","14","14","Cubbuun wolde'i huje sun yennaa beekkante, dardara araara cubbu'uutiif kennamu fidanee Dunkaanii Woldeenna'aa dura dhikeessanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_15","004_4_15","LEV","4","15","15","Jaarsoleen wolde'aa Mootii Waan Maraa duratti harka ifii mataa dardara sanii irra keyanee, dardarri sun Mootii Waan Maraa duratti qalamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_16","004_4_16","LEV","4","16","16","Achiin duuba hayyichi guddaan dhiiga dardara sanii irraa diqqaa isaa fuudhee, gara Dunkaanii Woldeenna'aa seenuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_17","004_4_17","LEV","4","17","17","Inni quba ifii dhiiga sanitti cuuphee, diqqaa isaa gollaa addee irra caalaa woyyitti'ii gara duraatiin yennaa torba ana Mootii Waan Maraa duratti fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_18","004_4_18","LEV","4","18","18","Inni dhiiga diqqaa isaa gaafota addee ciinca'aa ta Dunkaanii Woldeenna'aa keessaa, ta ana Mootii Waan Maraa duratti hixaana irratti aarsanu sanitti dibuu ti. Dhiiga dardaraa ka hafe, addee ciinca'aa ta kennansa gubamuu, ta seensuma Dunkaanii Woldeenna'aa dura jiru jalatti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_19","004_4_19","LEV","4","19","19","Inni moora dardara sanii mara baasee addee ciinca'aa irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_20","004_4_20","LEV","4","20","20","Inni dardara kana akkuma dardara araara cubbu'uutiif dhikaate sanii godhuu ti; akka kanaan hayyichi gumaa cubbuu isaaniitiif hin dhikeessa; isaalle araara cubbu'uu hin dhaggatan. ");
INSERT INTO gax_vpl VALUES ("LV4_21","004_4_21","LEV","4","21","21","Achiin duuba inni dardara san addee quttumaatiin alatti baasee, akkuma dardara qaraa gube san gubuu ti; kun ciincaa araara cubbuu wolde'aa hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV4_22","004_4_22","LEV","4","22","22","« ‹Sooressi tokko adoo hin beekin cubbuu hujee, ajaja Mootii Waan Maraa ka Waaqa ifii keessaa tokko irra dabaree waan dhooggame tokko yoo huje, inni yakkaamessa. ");
INSERT INTO gax_vpl VALUES ("LV4_23","004_4_23","LEV","4","23","23","Inni cubbuu huje san yoo beeke, korbeessa re'e'ee ka fafa hin qanne, kennansa fiduu qaba. ");
INSERT INTO gax_vpl VALUES ("LV4_24","004_4_24","LEV","4","24","24","Kun ciincaa araara cubbu'uu waan te'eef, harka ifii mataa korbeessa sanii irra keyee, addee kennansi gubamu ana Mootii Waan Maraa duratti qalamutti qaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_25","004_4_25","LEV","4","25","25","Achiin duuba hayyichi dhiiga korbeessa araara cubbu'uutiif dhikaatee san irraa quba ifiitiin diqqaa isaa fuudhee, gaafota addee ciinca'aa ta kennansi gubamu irratti gubamu dibuu ti; ka hafe ammoo addee ciinca'aa jalatti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_26","004_4_26","LEV","4","26","26","Moora isaa mara akkuma moora kennansa tokkumma'aa gube san addee ciinca'aa irratti gubuu ti. Akka kanaan hayyichi cubbuu namichaatiif gumaa cubbu'uu kennuu ti; namichille araara cubbu'uu hin dhaggata. ");
INSERT INTO gax_vpl VALUES ("LV4_27","004_4_27","LEV","4","27","27","« ‹Kolbaa keessaa nami tokko adoo hin beekin cubbuu hujee, ajaja Mootii Waan Maraa keessaa tokko irra dabaree waan dhooggame tokko yoo huje, inni yakkaamessa. ");
INSERT INTO gax_vpl VALUES ("LV4_28","004_4_28","LEV","4","28","28","Inni cubbuu huje san yoo beeke, re'ee dhaltuu fafa hin qanne, kennansa fiduu qaba. ");
INSERT INTO gax_vpl VALUES ("LV4_29","004_4_29","LEV","4","29","29","Inni harka ifii mataa re'ittii araara cubbu'uutiif dhikaatte sanii irra keyee, addee kennansa gubamuutitti qaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_30","004_4_30","LEV","4","30","30","Achiin duuba hayyichi dhiiga re'ittii sanii irraa diqqaa isaa quba ifiitiin fuudhee, gaafota addee ciinca'aa ta kennansi gubamu irratti gubamu dibuu ti; ka hafe addee ciinca'aa jalatti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_31","004_4_31","LEV","4","31","31","Inni akkuma moora kennansa tokkumma'aaf dhikaatee san, moora isi'ii mara baasuu ti; hayyichi foolee dansaa ana Mootii Waan Maraa gammachiittu godhee addee ciinca'aa irratti gubuu ti. Akka kanaan hayyichi gumaa cubbu'uu isaaf kennuu ti; namichille araara hin dhaggata. ");
INSERT INTO gax_vpl VALUES ("LV4_32","004_4_32","LEV","4","32","32","« ‹Inni araara cubbu'uutiif buruusoo hoole'ee yoo fide, dhaltuu fafa hin qanne fiduu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_33","004_4_33","LEV","4","33","33","Inni harka ifii mataa isi'ii irra keyee addee kennansi gubamu itti qalamutti qaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_34","004_4_34","LEV","4","34","34","Achiin duuba hayyichi dhiiga hoolittii araara cubbu'uutiif dhikaatte san irraa diqqaa isaa quba ifiitiin fuudhee, gaafota addee ciinca'aa ta kennansa gubamuu san dibuu ti; ka hafe addee ciinca'aa jalatti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV4_35","004_4_35","LEV","4","35","35","Inni akkuma moora kennansa tokkumma'aaf dhikaatee san, moora isi'ii mara baasuu ti; hayyichi addee ciinca'aa ta kennansi gubamu ana Mootii Waan Maraatiif gubamu irratti gubuu ti. Akka kanaan hayyichi cubbuu isaatiif gumaa cubbu'uu kennuu ti; namichille araara hin dhaggata. ");
INSERT INTO gax_vpl VALUES ("LV5_1","004_5_1","LEV","5","1","1","« ‹Nami tokko mana mura'aatitti waan beekuu fi waan dhagge dhugaa akka bayu waamamee, dhugaa bayuu yoo dide, inni yakkaa saniif itti hin gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV5_2","004_5_2","LEV","5","2","2","Yookiin nami tokko waan aadaa dhugeeffanna'aatiin qulqulluu hin te'inii reeffa bineensa qulqulluu hin te'inii yookiin reeffa horii qulqulluu hin te'inii yookiin reeffa bineensota gadha'aan lafa irra lowanuu adoo hin beekinille yoo tuqe, inni battoweera; yakkaamessalle'e. ");
INSERT INTO gax_vpl VALUES ("LV5_3","004_5_3","LEV","5","3","3","« ‹Yookiin nami tokko battummaa gosa tamiille teetu, battii nafa namaa keessaa yaatu adoo hin beekinille yoo tuqe, wonni inni tuqe sun battii akka teete yennaa beeke irraa kaasee, yakkaamessa hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV5_4","004_5_4","LEV","5","4","4","« ‹Yookiin nami tokko waanuma te'e maraayyuu, waan dansaa yookiin waan hantuu godhiisaaf, yaada malee adoo ifi hin eegatin yoo kakate, inni beekuu dhabulle, yennaa beekeen irraa kaasee, inni yakkaamessa hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV5_5","004_5_5","LEV","5","5","5","« ‹Eennulle waan akkasii kana keessaa waan tokkoon yakkaamessa yennaa te'e, cubbuu ifii faaci'atuu ti. ");
INSERT INTO gax_vpl VALUES ("LV5_6","004_5_6","LEV","5","6","6","Inni Cubbuu huje saniif, tika hoole'ee yookiin re'e'ee keessaa gorontii hoole'ee yookiin gorontii re'e'ee, kennansa araara cubbu'uu ana Mootii Waan Maraatiif fiduu ti; hayyichille cubbuu isaatiif gumaa hin godha. ");
INSERT INTO gax_vpl VALUES ("LV5_7","004_5_7","LEV","5","7","7","« ‹Inni hoolee yookiin re'ee yoo hin qanne te'e, saphaliisa lama yookiin maddoo lama, takkattii kennansa araara cubbu'uutiif, taan kennansa gubamuuf, ana Mootii Waan Maraatiif fiduu ti. ");
INSERT INTO gax_vpl VALUES ("LV5_8","004_5_8","LEV","5","8","8","Inni gara hayyichaa isaan fiduu ti; hayyichi isaan keessaa dursee takkattii morma micciiree adoo irraa hin kutin kennansa araara cubbu'uutiif dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV5_9","004_5_9","LEV","5","9","9","Dhiiga kennansa araara cubbu'uutiif dhikaatee san irraa diqqaa isaa fuudhee, cinaa addee ciinca'aatitti fiffixuu ti; kennansa araara cubbu'uu waan te'eef, dhiiga hafe addee ciinca'aa jalatti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV5_10","004_5_10","LEV","5","10","10","Takkattii taanille akkuma seeraatitti akka kennansa gubamuutitti dhikeessuu ti. Hayyichi cubbuu inni huje saniif, gumaa dhikeessuu ti; namichille araara hin dhaggata. ");
INSERT INTO gax_vpl VALUES ("LV5_11","004_5_11","LEV","5","11","11","« ‹Inni saphaliisa lama yookiin maddoo lama yoo harkaa hin qanne te'e, bullaa dansaa kiiloogiraama lamaa cubbuu huje saniif kennansa araara cubbu'uu dhikeessuu ti. Kun kennansa araara cubbu'uu waan te'eef, zayitii ejersaa yookiin hixaana itti hin naqin. ");
INSERT INTO gax_vpl VALUES ("LV5_12","004_5_12","LEV","5","12","12","Inni hayyichatti geessuu ti; bullaan tun kennansa araara cubbu'uutiif dhikaatu waan teeteef, hayyichi ooboo tokko guutuu irraa fuudhee, yaadannoo akka teetu, kennansa ana Mootii Waan Maraatiif ibiddaan gubamu irratti, addee ciinca'aa irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV5_13","004_5_13","LEV","5","13","13","Akka kanaan hayyichi cubbuu namichi huje tamiifuu gumaa hin kenna; namichille araara cubbu'uu hin dhaggata. Bullaan irraa hatte akkuma kennansa midhaanii hayyichaaf teetuu ti› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV5_14","004_5_14","LEV","5","14","14","Mootiin Waan Maraa Muuse'een ");
INSERT INTO gax_vpl VALUES ("LV5_15","004_5_15","LEV","5","15","15","«Nami tokko adoo hin beekin waan ana Mootii Waan Maraatiif woyyoome balleessee yoo yakke, sababa yakkaa saniitiif, hoolee keessaa korbeessa fafa hin qanne ana Mootii Waan Maraatiif dhikeessuu ti. Kennansa sababa yakka'aatiif dhikaatu waan te'eef, gatiin isaa akka madaallii Dunkaanii Woyyitti'ii ittiin madaalamutti ati itti madaaltetti te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV5_16","004_5_16","LEV","5","16","16","Inni waan woyyuu te'e keessaa ta balleesse bakka buusuu ti; gatii isi'ii keessaa harka shan keessaa harka tokko itti dabalee, hayyichatti kennuu ti; hayyichi korbeessa hoole'ee ka kennansa sababa yakka'aatiif dhikaatu san woliin gumaa cubbuu isaatiif hin dhikeessa. Namichille cubbuu ifiitiif araara hin dhaggata. ");
INSERT INTO gax_vpl VALUES ("LV5_17","004_5_17","LEV","5","17","17","«Nami tokko cubbuu hujee, ajaja kiyya keessaa waan dhooggame, adoo hin beekinuu tokkolle yoo casse, inni yakkaamessa; yakkaa ifiitiif itti hin gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV5_18","004_5_18","LEV","5","18","18","Inni horii keessaa korbeessa fafa hin qanne, gatii ati itti madaaltetti kennansa sababa yakka'aatiif dhikaatuuf, gara hayyichaa fiduu ti. Hayyichi balleessaa inni adoo hin beekin huje saniif gumaa hin kenna; namichille araara hin dhaggata. ");
INSERT INTO gax_vpl VALUES ("LV5_19","004_5_19","LEV","5","19","19","Dhugumaan namichi ana Mootii Waan Maraa duratti yakkaa waan hujeef, kun kennansa sababa yakka'aatiif dhikaatu» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV6_1","004_6_1","LEV","6","1","1","Ammalle Mootiin Waan Maraa Muuse'een ");
INSERT INTO gax_vpl VALUES ("LV6_2","004_6_2","LEV","6","2","2","«Seerri nama waan asii gad jiru kana maraan ollaa ifii sobiisaan, ana Mootii Waan Maraa yakkee kana: nami tokko marroo waan magannee itti kenname takkaa yookiin marroo waan qaddii itti kenname takkaa ollaa ifii yoo sobe, ollaa ifii yoo saame, bu'aa dhaggatiisaaf ollaa ifii irratti dhiibbaa yoo tolche, ");
INSERT INTO gax_vpl VALUES ("LV6_3","004_6_3","LEV","6","3","3","yookiin waan badeeru tokko dhaggee akka hin dhagginiititti dharaan yoo kakate yookiin cubbuu akkanaa tana keessaa takkattiille yoo huje, ");
INSERT INTO gax_vpl VALUES ("LV6_4","004_6_4","LEV","6","4","4","akka kanaan cubbuu hujee yakkaamessa yoo te'e, inni waan hate yookiin waan saame yookiin waan magannee itti kenname yookiin bu'aa dhaggatiisaaf ollaa ifii irratti dhiibbaa waan tolche yookiin waan baddeertuun dhagge san, ");
INSERT INTO gax_vpl VALUES ("LV6_5","004_6_5","LEV","6","5","5","yookiin waan akka waan hin dhagginiititti sobaan kakate san maraayyuu deebisuu ti. Guyyaa kennansa sababa yakkaa ifiitiif dhikeessu, gatii isi'iititti harka shan keessaa harka tokko itti dabalee abbaa karraatiif deebisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_6","004_6_6","LEV","6","6","6","Inni horii keessaa korbeessa hoole'ee ka fafa hin qanne, gatii ati itti madaaltetti, kennansa sababa yakka'aatiif dhikaatu ana Mootii Waan Maraatiif gara hayyichaa fiduu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_7","004_6_7","LEV","6","7","7","Hayyichi waan namichi hujee yakkaa itti te'e san maraaf, fuula kiyya duratti gumaa godhee kennuu ti; namichille araara hin dhaggata» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV6_8","004_6_8","LEV","6","8","8","Mootiin Waan Maraa Muuse'een ");
INSERT INTO gax_vpl VALUES ("LV6_9","004_6_9","LEV","6","9","9","«Aaronii fi ilmaan isaa ajaja kana ajaji: ‹Kun seerata kennansa gubamuu ti: kennansi gubamu halkan guutuu haga bari'iititti addee ciinca'aa irra turuu ti; ibiddille addee ciinca'aa irratti itti bobe'aa buluu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_10","004_6_10","LEV","6","10","10","Hayyichi lukee nafa isaatitti aantu ta quncee talba'aa irraa hujante hidhatee, woyaa ifii ta quncee talba'aa irraa hujante uffatee, daadhaa kennansa addee ciinca'aatitti gubamuu san irraa fuudhee, addee ciinca'aatiin cina'atti gad naquu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_11","004_6_11","LEV","6","11","11","Achiin duuba woyaa ifii san jijjiiratee daadhaa san addee quttumaatiin ala addee aadaa dhugeeffanna'aatiin qulqulluu teetetti geessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_12","004_6_12","LEV","6","12","12","Ibiddi addee ciinca'aa irraa ittuma bobe'uutii malee ijjumaa hin dhaamin. Hayyichi ganama ganama qoraan itti dabaluu ti; kennansa gubamulle ibidda san irratti tarree galchee, moora kennansa tokkumma'aa san irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_13","004_6_13","LEV","6","13","13","Ibiddi yennaa mara addee ciinca'aa irratti bobe'uutii malee ijjumaa hin dhaamin. ");
INSERT INTO gax_vpl VALUES ("LV6_14","004_6_14","LEV","6","14","14","« ‹Seerri kennansa midhaanii asii gad jira: Sanyii ilmaan Aaronii keessaa hayyichi tokko addee ciinca'aatiin duratti, kennansa midhaanii ana Mootii Waan Maraa dura dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_15","004_6_15","LEV","6","15","15","Hayyichi bullaa dansaa zayitiin ejersaa itti dhangalaafame san ooboo tokko guutuu, hixaana kennansa midhaanii irra jiru san mara woliin fuudhee, ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu godhee, yaadannoo akka te'u, addee ciinca'aa irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_16","004_6_16","LEV","6","16","16","Ka hafe Aaronii fi ilmaan isaa uukoo malee, badhinna dalleya keessaa ka Dunkaanii Woldeenna'aatitti addee woyyittii keessatti nyaatanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_17","004_6_17","LEV","6","17","17","Uukoo malee bilcheeffantuu ti. Ani kennansa midhaanii ka ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu keessaa qooda isaanii akka teetuuf kenneera. Isiin akkuma kennansa araara cubbu'uutii fi yakka'aatiif dhikaatuu guddoo woyyitti'i. ");
INSERT INTO gax_vpl VALUES ("LV6_18","004_6_18","LEV","6","18","18","Sanyii Aaronii keessaa dhiirti martinuu kennansa ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu irraa hin nyaatan; kun dhalootaa haga dhalootaatitti qooda isaanii hin te'a. Nami kennansa san tuqe marti woyyuu hin te'a› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV6_19","004_6_19","LEV","6","19","19","Mootiin Waan Maraa ammalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV6_20","004_6_20","LEV","6","20","20","«Aaronii fi ilmaan isaa keessaa guyyaa hayyichi guddaan muudamu, kennansi ana Mootii Waan Maraatiif fidanu: bullaa dansaa kennansa yennaa mara dhikaatuuf, kiiloo giraamii lama keessaa gamisa barii, gamisa galgala dhikeessanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_21","004_6_21","LEV","6","21","21","Bullaa zayitii ejersaatiin sukkuumantee akka dansaa wolitti makantee, eelee sibiilaatitti bilcheeffantee, caccaffantee akka kennansa midhaaniititti, ta foolee dansaa qaddu ta ana Mootii Waan Maraa gammachiittu naaf dhikeessanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_22","004_6_22","LEV","6","22","22","Ilmaan Aaronii keessaa hayyichi isa bakka bu'iisaaf muudamelle akkasuma tolchuu ti. Kun ana Mootii Waan Maraatiif seera bara baraa ti. Qooda kiyya waan te'eef duudumaa gubamuu qaba. ");
INSERT INTO gax_vpl VALUES ("LV6_23","004_6_23","LEV","6","23","23","Kennansi midhaanii ka hayyichi dhikeessu martinuu gubamuu ti malee hin nyaatamin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV6_24","004_6_24","LEV","6","24","24","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV6_25","004_6_25","LEV","6","25","25","«Aaronii fi ilmaan isaatiin, ‹Kun seera kennansa araara cubbu'uutiif dhikaatuu ti: horiin araara cubbu'uutiif kennamu irraa caalaa woyyuu ka te'e keessaa tokko waan te'eef, addee kennansi gubamu itti qalamutti, fuula ana Mootii Waan Maraa duratti qalamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_26","004_6_26","LEV","6","26","26","Hayyichi kennansa araara cubbu'uu ciincessu addee woyyittii keessatti badhinna dalleya keessaa ka Dunkaanii Woldeenna'aa keessatti foon san nyaatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_27","004_6_27","LEV","6","27","27","Wonni foon san tuqe marti woyyuu te'a; dhiigi horii sanii woya'atti yoo faca'e, addeen inni itti faca'e sun addee woyyitti'itti dhiqantuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_28","004_6_28","LEV","6","28","28","Okkoteen foon sun itti iffeelame caccabuu qaddi; okkotee sageettuu irraa hujante yoo teete ammoo rigantee bisaaniin dhiqantuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_29","004_6_29","LEV","6","29","29","Horiin qalame sun irra caalaa woyyuu ka te'e keessaa tokko waan te'eef, maatii hayyootaa keessaa dhiirti martinuu foon san nyaatanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV6_30","004_6_30","LEV","6","30","30","Horii araara cubbu'uutiif dhikaatee, dhiigi isaa gumaa cubbu'uutiif Dunkaanii Woldeenna'aa keessa addee irra caalaa woyyittii teete yoo seene, foon horii sanii gubamuutii malee hin nyaatamin. ");
INSERT INTO gax_vpl VALUES ("LV7_1","004_7_1","LEV","7","1","1","« ‹Seerri irra caalaa woyyicha te'e keessaa tokko ka te'e, ka kennansa sababa yakka'aatiif dhikaatuu asii gad jira: ");
INSERT INTO gax_vpl VALUES ("LV7_2","004_7_2","LEV","7","2","2","Adduma kennansi gubamu itti qalamutti kennansi sababa yakka'aatiif dhikaatulle qalamuu ti; dhiigi isaalle cinaa addee ciinca'aa maratti fiffixamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_3","004_7_3","LEV","7","3","3","Coomi duma isaatii fi moorri meya gadha'aa gollu, ");
INSERT INTO gax_vpl VALUES ("LV7_4","004_7_4","LEV","7","4","4","kalattiin lamaanuu, moora isii irra jiru ka cinaa dirraa woliin, qaccee tiru'uu kalattii woliin kennansaaf dhikaatanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_5","004_7_5","LEV","7","5","5","Kennansa sababa yakka'aatiif dhikaatanu waan te'aneef, hayyichi akka kennansa ibiddaan gubamee Mootii Waan Maraatiif dhikaatuu addee ciinca'aa irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_6","004_7_6","LEV","7","6","6","Maatii hayyichaa keessaa dhiirti martinuu nyaattuu ti; kennansi kun ka irra caalaa woyyuu te'e keessaa tokko waan te'eef, addee woyyitti'itti nyaatamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_7","004_7_7","LEV","7","7","7","« ‹Kennansi araara cubbu'uutiif dhikaatu akkuma kennansa sababa yakka'aatiif dhikaatuu waan te'eef, seerri isaanii tokkuma; foon kennansaaf dhikaate sun hayyicha gumaa tolchuuf te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_8","004_7_8","LEV","7","8","8","Hayyichi horii nami kennansa gubamuuf fide san gubu, gogaa horii kennansa gubamuuf dhikaatee san ifiif fudhatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_9","004_7_9","LEV","7","9","9","Kennansi midhaanii ka barbada ibiddaa irratti woddame yookiin ka okkote'etti iffeelame yookiin ka eelee sibiilaatitti akowame sun hayyicha kennansa dhikeesse saniif kennamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_10","004_7_10","LEV","7","10","10","Kennansi midhaanii ka zayiti'iin sukkuumame yookiin ka zayitii hin qanne marti ilmaan Aaronii maraaf wol qixa qoodamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_11","004_7_11","LEV","7","11","11","« ‹Seerri kennansa tokkumma'aa ka Mootii Waan Maraatiif dhikaatuu ka asii gad jiru: ");
INSERT INTO gax_vpl VALUES ("LV7_12","004_7_12","LEV","7","12","12","Nami tokko kennansa galataa yoo dhikeesse, kennansa galataa san woliin bixee bullaa dansaa uukoo hin qanne ta zayiti'iin sukkuumante, bixee hephellittii uukoo hin qanne ta zayitiin irra dibamee fi zayiti'iin sukkuumante dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_13","004_7_13","LEV","7","13","13","Kennansa galataa ka tokkumma'aa kana woliin daabboo uukoo qaddu kennansa dhikeessuu qaba. ");
INSERT INTO gax_vpl VALUES ("LV7_14","004_7_14","LEV","7","14","14","Gosa daabboo kennansaaf dhikaatte tokko tokkooyyuu irraa tokko tokko fuudhee ana Mootii Waan Maraatiif adda baasee, kennansa dhikeessee, hayyicha dhiiga kennansa tokkumma'aaf dhikaatu fiffixu saniif kennuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_15","004_7_15","LEV","7","15","15","Foon kennansa galataa ka tokkumma'aa sun guyyuma kennansaaf dhikaate san nyaatamuutii malee, ijjumaa hin bulin. ");
INSERT INTO gax_vpl VALUES ("LV7_16","004_7_16","LEV","7","16","16","« ‹Kennansi sun kennansa woreegaa yookiin kennansa fedhi'iin kennamu yoo te'elle, guyyuma dhikaate san nyaatamuu ti; wonni irraa hafe ammoo guyyaa itti aanu nyaatamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_17","004_7_17","LEV","7","17","17","Foon kennansaaf dhikaate san irraa hafee haga guyyaa sadii ture ibiddaan gubamuu qaba. ");
INSERT INTO gax_vpl VALUES ("LV7_18","004_7_18","LEV","7","18","18","Foon kennansa tokkumma'aa sun guyyaa sadeesso'oo yoo nyaatame, kennansi namichaa fudhatama hin qabu; hin laakkowamuufille'e; battii waan te'eef, nami isa nyaate itti hin gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV7_19","004_7_19","LEV","7","19","19","« ‹Foon aadaa dhugeeffanna'aatiin waan battii te'e tuqe marti gubamuutii malee hin nyaatamin. Foon qulqulluu te'e ammoo nami akka aadaa dhugeeffanna'aatitti qulqulluu te'e marti nyaatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_20","004_7_20","LEV","7","20","20","Nami akka aadaa dhugeeffanna'aatitti qulqulluu hin te'in foon kennansa tokkumma'aa ka ana Mootii Waan Maraa dhikaate irraa yoo nyaate, kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_21","004_7_21","LEV","7","21","21","Eennulle nama batticha yookiin horii batticha yookiin waan battii te'e mara tuqee, foon kennansa tokkumma'aa ka ana Mootii Waan Maraa dhikaate san yoo nyaate, kolbaa ifii keessaa bawuu ti› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV7_22","004_7_22","LEV","7","22","22","Ammalle Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV7_23","004_7_23","LEV","7","23","23","«Kolbaa Israa'eliitiin, ‹Moora loonii, moora re'e'ee yookiin moora hoole'ee hin nyaatina'a! ");
INSERT INTO gax_vpl VALUES ("LV7_24","004_7_24","LEV","7","24","24","Moora horii ifiin du'ee yookiin ka bineensi ijjeesee hujii dhibi'iif itti fayyadama'a malee hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("LV7_25","004_7_25","LEV","7","25","25","Nami moora horii kennansa ana Mootii Waan Maraatiif ibiddaan gubamee dhikaatuu san nyaatu, kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_26","004_7_26","LEV","7","26","26","Addee leetanu maratti dhiiga maraayyuu ka sinbirre'ee yookiin ka bineensaalle yoo te'e hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("LV7_27","004_7_27","LEV","7","27","27","Eennulle dhiiga yoo nyaate, kolbaa ifii keessaa bawuu ti› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV7_28","004_7_28","LEV","7","28","28","Mootiin Waan Maraa ammalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV7_29","004_7_29","LEV","7","29","29","«Kolbaa Israa'elootaatiin, ‹Nami kennansa tokkumma'aa ana Mootii Waan Maraatiif dhikeessu, kennansuma san irraa fuudhee kennansa naaf dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_30","004_7_30","LEV","7","30","30","Inni kennansa ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu harkuma ifiitiin dhikeessuu ti; moora cormii woliin fiduu ti; kennansa tachoofamuuf ana Mootii Waan Maraatiif dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_31","004_7_31","LEV","7","31","31","Hayyichi moora san addee ciinca'aa irratti gubuu ti; cormiin ammoo Aaronii fi ilmaan isaatiif kennamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_32","004_7_32","LEV","7","32","32","Kennansa tokkumma'aaf dhikaate luka gara middaa hayyichaaf kenna'a. ");
INSERT INTO gax_vpl VALUES ("LV7_33","004_7_33","LEV","7","33","33","Ilmaan Aaronii keessaa dhiiga fi moora kennansa tokkumma'aa san ciinca'aaf ka dhikeesse, luka gara middaa ifiif fudhatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV7_34","004_7_34","LEV","7","34","34","Ani kennansa Israa'elootaa ka tokkumma'aa irraa, cormii tachoofantee fi luka ol fuudhante fuudhee, yennaa mara qooda isaanii akka te'u, Aaronii hayyichaa fi ilmaan isaatiif kenneera. Kun seera yennaa maraa ti. ");
INSERT INTO gax_vpl VALUES ("LV7_35","004_7_35","LEV","7","35","35","Aaronii fi ilmaan isaa guyyaa hayyuu te'anee ana Mootii Waan Maraa tajaajiliisaaf muudamane, kennansa ibiddaan gubamee ana Mootii Waan Maraatiif dhikaate irraa qoodi isaaniif kenname kana. ");
INSERT INTO gax_vpl VALUES ("LV7_36","004_7_36","LEV","7","36","36","Guyyaa isaan muudamane, Israa'elooti dhalootaa haga dhalootaatitti yennaa mara qooda isaanii akka te'u godhanee akka kennanu ani Mootiin Waan Maraa ajajeera› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV7_37","004_7_37","LEV","7","37","37","Seerri kennansa gubamuu, seerri kennansa midhaanii, seerri kennansa araara cubbu'uutiif dhikaatuu, seerri kennansa sababa yakka'aatiif dhikaatuu, seerri kennansa muudama hayyootaatiif dhikaatuu fi seerri kennansa tokkumma'aa kana. ");
INSERT INTO gax_vpl VALUES ("LV7_38","004_7_38","LEV","7","38","38","Kun goomolee Siina'aa keessatti, Israa'elooti kennansa ifii akka Mootii Waan Maraatiif kennanu guyyaa ajaje, gaara Siina'aa irratti seera Mootiin Waan Maraa Muuse'eef kenne. ");
INSERT INTO gax_vpl VALUES ("LV8_1","004_8_1","LEV","8","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV8_2","004_8_2","LEV","8","2","2","«Aaronii fi ilmaa isaa woliin woyaa hayyumma'aa ta isaanii, zayitii muudaa, dardara araara cubbu'uutiif kennamu, buruusota korbeeyyii hoole'ee lamaa fi kollonjoo daabboo uukoo hin qanne qaddu fidi. ");
INSERT INTO gax_vpl VALUES ("LV8_3","004_8_3","LEV","8","3","3","Achiin duuba kolbaa Israa'elii duudii seensuma Dunkaanii Woldeenna'aa duratti wolitti qabi!» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV8_4","004_8_4","LEV","8","4","4","Muuseelle akkuma Mootiin Waan Maraa isa ajaje tolchee, kolbaan marti seensuma Dunkaanii Woldeenna'aa duratti wolitti qabamane. ");
INSERT INTO gax_vpl VALUES ("LV8_5","004_8_5","LEV","8","5","5","Muuseelle isaaniin, «Akka isin tolchitanuuf wonni Mootiin Waan Maraa ajaje kana» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV8_6","004_8_6","LEV","8","6","6","Achiin duuba Muuseen Aaronii fi ilmaan isaa gara duraa akka dhufanu godhee bisaaniin isaan dhiqe. ");
INSERT INTO gax_vpl VALUES ("LV8_7","004_8_7","LEV","8","7","7","Aaronitti qoloo haga miilaa dheertuu itti uffisee, hiituu itti hidhee, qoloo gubba'aatii fi woyaa hayyumma'aa ta qomaa itti uffise. Inni woyaa hayyumma'aa ta qomaa san hiituu isi'ii ta worra ogummaa woyaa dhowiisa akka dansaa beekuun dhowanteen itti hidhe. ");
INSERT INTO gax_vpl VALUES ("LV8_8","004_8_8","LEV","8","8","8","Inni kiisii qomaa itti hodhee, uriimii fi tumiim keessa keye. ");
INSERT INTO gax_vpl VALUES ("LV8_9","004_8_9","LEV","8","9","9","Akkuma Mootiin Waan Maraa isa ajaje marata mata'aa mataa isaatitti maree, marata san irratti gara fuula duraatiin kallacha worqii irraa hujame ka beessisa woyyumma'aa itti qassiise. ");
INSERT INTO gax_vpl VALUES ("LV8_10","004_8_10","LEV","8","10","10","Achiin duuba Muuseen zayitii muudaa fuudhee, Dunkaanii Woldeenna'aatii fi waan isii keessa jiru mara muudee woyyoonse. ");
INSERT INTO gax_vpl VALUES ("LV8_11","004_8_11","LEV","8","11","11","Inni zayitii muudaa san irraa diqqoo isi'ii fuudhee addee ciinca'aa irratti yennaa torba fiffixee, addee ciinca'aatii fi meya isi'ii mara, qorii itti dhiqatanu waan qoriin sun irra keyatantu woliinuu Mootii Waan Maraatiif woyyoonsiisaaf muude. ");
INSERT INTO gax_vpl VALUES ("LV8_12","004_8_12","LEV","8","12","12","Aaron woyyoonsiisaaf zayitii muudaa san irraa diqqoo isi'ii mataa isaa irratti dhangalaasee isa muude. ");
INSERT INTO gax_vpl VALUES ("LV8_13","004_8_13","LEV","8","13","13","Akkuma Mootiin Waan Maraa isa ajajetti, Muuseen ilmaan Aaronii gara duraa fidee, qoloo haga miilaa dheeratu itti uffisee, hiituu itti hidhee, marata mata'aa mataa isaaniititti mare. ");
INSERT INTO gax_vpl VALUES ("LV8_14","004_8_14","LEV","8","14","14","Achiin duuba inni dardara araara cubbu'uutiif dhikaatu fidee, Aaronii fi ilmaan isaalle harka ifii mataa dardara sanii irra keyane. ");
INSERT INTO gax_vpl VALUES ("LV8_15","004_8_15","LEV","8","15","15","Muuseen dardara san qalee, addee ciinca'aa qulqulleessiisaaf, dhiiga diqqaa isaa fuudhee, quba ifiitiin gaafota addee ciinca'aa san mara dibee, ka hafe addee ciinca'aa jalatti dhangalaase; akka kanaan inni gumaa cubbu'uu addee ciinca'aatiif dhikeessee addee ciinca'aa san woyyoonse. ");
INSERT INTO gax_vpl VALUES ("LV8_16","004_8_16","LEV","8","16","16","Muuseen moora meya gadha'aa gollu mara, qaccee tiru'uutii fi kalattii lamaanuu moora isii irra jiru mara woliin fuudhee addee ciinca'aa irratti gube. ");
INSERT INTO gax_vpl VALUES ("LV8_17","004_8_17","LEV","8","17","17","Muuseen akkuma Mootii Waan Maraa isa ajajetti waan dardara sanii ka hafe, gogaa isaa foon isaatii fi meya gadha'aa addee quttumaatiin alatti baasee gube. ");
INSERT INTO gax_vpl VALUES ("LV8_18","004_8_18","LEV","8","18","18","Achiin duuba inni korbeessa hoole'ee kennansa gubamuuf dhikeessee, Aaronii fi ilmaan isaa harka ifii mataa korbeessa sanii irra keyane. ");
INSERT INTO gax_vpl VALUES ("LV8_19","004_8_19","LEV","8","19","19","Achiin duuba Muuseen korbeessa san qalee, dhiiga isaa cinaa addee ciinca'aa san maratti dhangalaase. ");
INSERT INTO gax_vpl VALUES ("LV8_20","004_8_20","LEV","8","20","20","Inni korbeessa san kukkutee, mataa isaa, foon kukkutamee fi moora isaa gube. ");
INSERT INTO gax_vpl VALUES ("LV8_21","004_8_21","LEV","8","21","21","Meya gadha'aatii fi manyee isaa bisaaniin dhiqee, akkuma Mootiin Waan Maraa isa ajajetti, foon korbeessaa maraayyuu, kennansa ibiddaan gubamee Mootii Waan Maraatiif dhikaatu, ka foolee dansaa qabu godhee, addee ciinca'aa irratti gube. ");
INSERT INTO gax_vpl VALUES ("LV8_22","004_8_22","LEV","8","22","22","Achiin duuba Muuseen korbeessa lammeesso'oo ka seera muudama hayyootaatiif dhikaatu fidee, Aaronii fi ilmaa isaa mataa isaa irra harka ifii keyane. ");
INSERT INTO gax_vpl VALUES ("LV8_23","004_8_23","LEV","8","23","23","Muuseen korbeessa san qalee, dhiiga isaa irraa diqqaa isaa fuudhee, qaccee gurra Aaronii ka gara middaa, quba isaa abguddicha ka harka middichaatii fi quba isaa abguddicha ka miila middichaa isse. ");
INSERT INTO gax_vpl VALUES ("LV8_24","004_8_24","LEV","8","24","24","Achiin duuba inni ilmaan Aaronii gara duraa fidee, dhiiga san irraa diqqaa isaa fuudhee, qaccee gurra isaanii ka gara middaa, quba isaanii abguddicha ka harka middichaatii fi quba isaanii abguddicha ka miila middichaa isse. Dhiiga hafe cinaa addee ciinca'aa maratti dhangalaase. ");
INSERT INTO gax_vpl VALUES ("LV8_25","004_8_25","LEV","8","25","25","Cooma isaa: cooma dumaa, moora meya gadha'aa mara, qaccee tiru'uu, kalattii lamaanuu moora isii irra jiru woliin, luka gara middalle fuudhe. ");
INSERT INTO gax_vpl VALUES ("LV8_26","004_8_26","LEV","8","26","26","Achiin duuba daabboo uukoo hin qanne, ta kollonjoo fuula Mootii Waan Maraa dura jirtu irraa bixee tokko, bixee daabboo zayiti'iin sukkuumantee tokkoo fi bixee hephellittii fuudhee moora sanii fi luka gara middaa san irra keye; ");
INSERT INTO gax_vpl VALUES ("LV8_27","004_8_27","LEV","8","27","27","Inni kana maraa harka Aaroniitii fi harka ilmaan isaa irra keye. Isaanille kennansa tachoofamu Mootii Waan Maraatiif dhikeessane. ");
INSERT INTO gax_vpl VALUES ("LV8_28","004_8_28","LEV","8","28","28","Achiin duuba Muuseen kennansa san harka isaanii irraa fuudhee akka ciincaa muudama hayyootaatiif dhikaatuu, ka foolee dansaa qabuu godhee addee ciinca'aa irratti, kennansa gubamu irratti gube. ");
INSERT INTO gax_vpl VALUES ("LV8_29","004_8_29","LEV","8","29","29","Muuseen akkuma Mootiin Waan Maraa isa ajajetti cormii korbeessa hoole'ee ta ciincaa muudama hayyootaatiif dhikaatu ta qooda ifii fuudhee, kennansa tachoofamu Mootii Waan Maraatiif dhikeesse. ");
INSERT INTO gax_vpl VALUES ("LV8_30","004_8_30","LEV","8","30","30","Achiin duuba Muuseen zayitii muudaatii fi dhiiga diqqaa isaa addee ciinca'aa irraa fuudhee, Aaronii fi woyaa isaatitti, ilmaan isaatii fi woyaa ilmaan isaatitti fiffixee, Aaronii fi woyaa isaa, ilmaan isaatii fi woyaa isaanii woyyoonse. ");
INSERT INTO gax_vpl VALUES ("LV8_31","004_8_31","LEV","8","31","31","Achiin duuba Muuseen Aaronii fi ilmaan isaatiin, «Foon san seensuma Dunkaanii Woldeenna'aa duratti iffeela'aatii, akkuma Mootiin Waan Maraa ajajetti, daabboo kollonjoo kennansa muudama hayyootaatiif dhikaatte keessa jirtu woliin, achumatti nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("LV8_32","004_8_32","LEV","8","32","32","Foonii fi daabboo hatte ibiddaan guba'a. ");
INSERT INTO gax_vpl VALUES ("LV8_33","004_8_33","LEV","8","33","33","Seerri muudama hayyummaa teessanii guyyaa torba waan fudhatuuf, haga guyyaan muudama hayyummaa teessanii muummowutti, haga guyyaa torbaa seensuma Dunkaanii Woldeenna'aa dura tura'a. ");
INSERT INTO gax_vpl VALUES ("LV8_34","004_8_34","LEV","8","34","34","Waan adha hujame kana cubbuu teessaniif gumaa tolchiisaaf Mootii Waan Maraatitti ajaje. ");
INSERT INTO gax_vpl VALUES ("LV8_35","004_8_35","LEV","8","35","35","Akkuma Mootiin Waan Maraa na ajajetti, haga guyyaa torbaa halkanii fi guyyaa seensuma Dunkaanii Woldeenna'aa dura tura'a. Akka hin duuneef waan Mootiin Waan Maraa isin irraa barbaadu huja'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV8_36","004_8_36","LEV","8","36","36","Maarre Aaronii fi ilmaan isaa waan Mootiin Waan Maraa karaa Muuse'eetiin ajaje mara godhane. ");
INSERT INTO gax_vpl VALUES ("LV9_1","004_9_1","LEV","9","1","1","Muuseen guyyaa saddeetesso'oo Aaronii fi ilmaan isaa, jaarsolee Israa'elootaalle waame. ");
INSERT INTO gax_vpl VALUES ("LV9_2","004_9_2","LEV","9","2","2","Inni Aaroniin, «Kennansa araara cubbuu teetiitiif dhikaatu dardara tokko, kennansa gubamuuf korbeessa hoole'ee tokko, lamaanuu ka fafa hin qanne fuudhiitii fuula Mootii Waan Maraa dura dhikeessi. ");
INSERT INTO gax_vpl VALUES ("LV9_3","004_9_3","LEV","9","3","3","Achiin duuba Israa'elootaan, ‹Kennansa araara cubbu'uutiif dhikaatu korbeessa re'e'ee tokko, kennansa gubamuufille jibicha woggaa tokkootii fi korbeessa hoole'ee ka woggaa tokkoo lamaanuu ka fafa hin qanne fuudha'a! ");
INSERT INTO gax_vpl VALUES ("LV9_4","004_9_4","LEV","9","4","4","Adha Mootiin Waan Maraa waan isinitti mudhatuuf, Kennansa tokkumma'aatiif kormaa fi korbeessa hoole'ee, kennansa midhaanii ka zayiti'iin sukkuumame woliin ciincessiisaaf Mootii Waan Maraa dura dhikeessa'a› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV9_5","004_9_5","LEV","9","5","5","Isaan waan Muuseen ajaje mara Dunkaanii Woldeenna'aa dura fidane; wolde'i duudiin dhufanee fuula Mootii Waan Maraa dura dhaabbatane. ");
INSERT INTO gax_vpl VALUES ("LV9_6","004_9_6","LEV","9","6","6","Achiin duuba Muuseen isaaniin, «Ulfinni Mootii Waan Maraa akka isinitti mudhatuuf, tun waan Mootiin Waan Maraa isin ajaje» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV9_7","004_9_7","LEV","9","7","7","Muuseen ammalle Aaroniin, «Addee ciinca'aa dhaqiitii, kennansa keeti ka araaraa cubbu'uutiif dhikaatuu fi kennansa keeti ka gubamu ciincessiitii, kolba'aa fi ifiifille gumaa cubbu'uu kenni. Akkuma Mootiin Waan Maraa ajajetti marroo kolba'aatiif kennansa dhikeessiitii gumaa cubbuu isaanii kenni» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV9_8","004_9_8","LEV","9","8","8","Maarre Aaron gara addee ciinca'aa dhaqee, jibicha araaraa cubbuu isaatiif dhikaate san qale. ");
INSERT INTO gax_vpl VALUES ("LV9_9","004_9_9","LEV","9","9","9","Ilmaan isaa dhiiga jibichaa san isatti fiddee, inni quba ifii dhiiga san keessa cuuphee gaafota addee ciinca'aa san dibe; ka hafe addee ciinca'aa jalatti dhangalaase. ");
INSERT INTO gax_vpl VALUES ("LV9_10","004_9_10","LEV","9","10","10","Akkuma Mootiin Waan Maraa Muusee ajajetti, kennansa araara cubbu'uutiif dhikaatu irraa moora, kalattii lamaanuu, qaccee tiru'uu addee ciinca'aa irratti gube. ");
INSERT INTO gax_vpl VALUES ("LV9_11","004_9_11","LEV","9","11","11","Inni foonii fi gogaa addee quttumaatiin alatti ibiddaan gube. ");
INSERT INTO gax_vpl VALUES ("LV9_12","004_9_12","LEV","9","12","12","Achiin duuba inni kennansa gubamu san qale. Ilmaan isaa dhiiga jibichaa isatti fidanee, inni cinaa addee ciinca'aa maratti dhangalaase. ");
INSERT INTO gax_vpl VALUES ("LV9_13","004_9_13","LEV","9","13","13","Ilmaan isaa kennansa gubamiisaaf qalame san kukkuttee mataa woliin isatti fidde. Innille addee ciinca'aa irratti gube. ");
INSERT INTO gax_vpl VALUES ("LV9_14","004_9_14","LEV","9","14","14","Achiin duuba inni meya gadha'aatii fi manyee dhiqee kennansa gubamu woliin addee ciinca'aa irratti, kennansa gubamu irratti gube. ");
INSERT INTO gax_vpl VALUES ("LV9_15","004_9_15","LEV","9","15","15","Achiin duuba Aaron kennansa marroo kolba'aa dhikeesse. Korbeessa re'e'ee ka araara cubbuu kolba'aatiif dhikaate san fuudhee qalee, akkuma qara araara cubbuu ifiitiif dhikeesse san araara cubbu'uutiif dhikeesse. ");
INSERT INTO gax_vpl VALUES ("LV9_16","004_9_16","LEV","9","16","16","Inni horii kennansa gubamuuf dhikaate san fidee akkuma seeraatitti ciincaa dhikeesse. ");
INSERT INTO gax_vpl VALUES ("LV9_17","004_9_17","LEV","9","17","17","Inni kennansa midhaaniille fidee, ooboo tokko irraa fuudhee, ciincaa ganama ganama dhikaatutti ede'ee addee ciinca'aa irratti gube. ");
INSERT INTO gax_vpl VALUES ("LV9_18","004_9_18","LEV","9","18","18","Aaron kormaa fi korbeessa hoole'ee ka marroo kolba'aa kennansa tokkumma'aatiif dhikaate san qale. Ilmaan isaa dhiiga horii sanii isatti fidanee, inni cinaa addee ciinca'aa mara irratti dhangalaase. ");
INSERT INTO gax_vpl VALUES ("LV9_19","004_9_19","LEV","9","19","19","Ilmaan Aaronii moora kormaatii fi moora korbeessa hoole'ee, duma isaa, moora meya gadha'aa, kalattii lamaanuu, qaccee tiru'uulle fuudhanee, ");
INSERT INTO gax_vpl VALUES ("LV9_20","004_9_20","LEV","9","20","20","cormii kormaatii fi korbeessaa san irra keyane; Aaronille moora san mara addee ciinca'aa irratti gube. ");
INSERT INTO gax_vpl VALUES ("LV9_21","004_9_21","LEV","9","21","21","Akkuma Muuseen ajajetti cormi'ii fi luka gara middaa, kennansa tachoofamu fuula Mootii Waan Maraa dura dhikeesse. ");
INSERT INTO gax_vpl VALUES ("LV9_22","004_9_22","LEV","9","22","22","Achiin duuba Aaron harka ifii gara kolba'aa diriirsee isaan eebbise; ciincaa araara cubbu'uutiif dhikaatu, kennansa gubamuu fi kennansa tokkumma'aa dhikeesseen duuba gad bu'e. ");
INSERT INTO gax_vpl VALUES ("LV9_23","004_9_23","LEV","9","23","23","Muuse'ee fi Aaron gara dunkaanii woldeenna'aa seenane; isaan yennaa gad bayane kolbaa eebbisane; ulfinni Mootii Waan Maraalle kolbaa san maratti mudhate. ");
INSERT INTO gax_vpl VALUES ("LV9_24","004_9_24","LEV","9","24","24","Ibiddi Mootii Waan Maraa biraa gad bu'ee kennansa gubamuu fi moora addee ciinca'aa irra jiru san mara nyaatee fixe; kolbaan marti waan kana dhagganee, gammadanee ilillisaa gad gombifamane. ");
INSERT INTO gax_vpl VALUES ("LV10_1","004_10_1","LEV","10","1","1","Ilmaan Aaronii, Naadaabii fi Abiihuun girgiraa ifii fudhatanee, ibidda itti naqanee, hixaanalle itti naqane; ibidda inni hin ajajin Mootii Waan Maraa dura dhikeessane. ");
INSERT INTO gax_vpl VALUES ("LV10_2","004_10_2","LEV","10","2","2","Maarre ibiddi Mootii Waan Maraa biraa dhufee, gubee isaan fixe; isaanille Mootii Waan Maraa duratti du'ane. ");
INSERT INTO gax_vpl VALUES ("LV10_3","004_10_3","LEV","10","3","3","Achiin duuba Muuseen Aaroniin, «Kun waan Mootiin Waan Maraa qara yennaa dubbate, «‹Ani worra gara kiyya dhikaatu oddu'utti woyyummaa tiyya hin mudhisa; kolbaa mara duratti ulfinna hin dhaggadha› jedheera» jedhe. Aaron garuu womaa hin dubbanne. ");
INSERT INTO gax_vpl VALUES ("LV10_4","004_10_4","LEV","10","4","4","Muuseen Miishaa'elii fi Elzaafaan ilmaan Uzii'elii abbaa diqqaa Aaronii waamee, «Kowa'aatii reeffa ilmaan obboleessa keessanii addee woyyittii tana irraa fageessa'aatii, addee quttumaatiin alatti baasa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV10_5","004_10_5","LEV","10","5","5","Maarre isaanille dhufanee akkuma muuseen isaan ajajetti, akkuma isaan qoloo haga miilaa dheerattu uffatane saniin reeffa isaanii ba'atanee addee quttumaatiin alatti baasane. ");
INSERT INTO gax_vpl VALUES ("LV10_6","004_10_6","LEV","10","6","6","Achiin duuba Muuseen Aaronii fi ilmaan Aaronii Ele'azaarii fi Itaamaariin, «Isin akka hin duuneef, Mootiin Waan Maraa kolba'atti akka hin mufanne, gadditanee rifeensa mataa keessanii filatiisa hin dhabina'a! Woyaa teessanille hin tarsaafatina'a! Garuu obboleeyyan teessan ta Mootiin Waan Maraa ibiddaan fixe saniif firri keessan Israa'elooti marti bowuu hin dande'an. ");
INSERT INTO gax_vpl VALUES ("LV10_7","004_10_7","LEV","10","7","7","Mootiin Waan Maraa zayitii muudaa ta ifiitiin waan isin muudeeruuf, akka hin duuneef seensuma Dunkaanii Woldeenna'aa duraa hin deemina'a» jedhe. Isaanille akkuma Muuseen isaan ajaje godhane. ");
INSERT INTO gax_vpl VALUES ("LV10_8","004_10_8","LEV","10","8","8","Mootiin Waan Maraa Aaroniin, ");
INSERT INTO gax_vpl VALUES ("LV10_9","004_10_9","LEV","10","9","9","«Akka hin duuneef atii fi ilmaan teeti Dunkaanii Woldeenna'aa yennaa seentanu daadhii woyni'ii yookiin untoo nama macheessitu hin unina'a. Kun dhaloota dhufu maraaf seerata haga bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV10_10","004_10_10","LEV","10","10","10","Isin waan woyyuu te'ee fi waan woyyuu hin te'in, waan aadaa dhugeeffanna'aatiin qulqulluu hin te'inii fi waan qulqulluu te'e gargar baasa'aa beeka'a. ");
INSERT INTO gax_vpl VALUES ("LV10_11","004_10_11","LEV","10","11","11","Seerata ani Mootiin Waan Maraa karaa Muuse'eetiin kenne mara kolbaa Israa'elii barsiisa'a!» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV10_12","004_10_12","LEV","10","12","12","Muuseen Aaronii fi ilmaan Aaronii worra hafe Ele'azaarii fi Itaamaaniin, «Kennansi midhaanii ka kennansa ibiddaan gubamee Mootii Waan Maraatiif dhikaatu irraa hafe sun kennansa irra caalaa woyyuu te'e keessaa tokko waan te'eef, fuudha'aatii, uukoo malee bukeessa'aatii, addee ciinca'aa biratti nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("LV10_13","004_10_13","LEV","10","13","13","Kennansa ibiddaan gubamee Mootii Waan Maraatiif dhikaatu keessaa kun qooda keetii fi qooda ilmaan teetii waan te'eef, addee woyyitti'itti isa nyaadha'a! Ani tana ajajameera. ");
INSERT INTO gax_vpl VALUES ("LV10_14","004_10_14","LEV","10","14","14","Atii fi ilmaan teeti, durri teetille cormii tachoofantee fi luka ol fuudhante san nyaadha'a. Kun kennansa tokkumma'aa ka Israa'elooti dhikeessitu keessaa qooda keetii fi ijoollee teetii waan te'eef, addee akka aadaa dhugeeffanna'aatiin qulqulluu teetetti nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("LV10_15","004_10_15","LEV","10","15","15","Luki ol fuudhantee fi cormiin kennansa tachoofamuuf dhikaatte sun, moora kennansa ibiddaan gubamuuf dhikaate, ka kennansa tachoofamuuf Mootii Waan Maraatiif akka dhikaatu kenname woliin dhikaatuu ti. Kun akkuma Mootiin Waan Maraa ajajetti haga bara baraa qooda keetii fi qooda ijoollee teetii hin te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV10_16","004_10_16","LEV","10","16","16","Muuseen korbeessa re'e'ee ka kennansa araara cubbu'uutiif dhikaate san yennaa jabeessee iyyaafate, akka inni gubameeru beekee, ilmaan Aaronii worra hafe, Ele'azaarii fi Itaamaaritti aaree, ");
INSERT INTO gax_vpl VALUES ("LV10_17","004_10_17","LEV","10","17","17","«Kennansi araara cubbu'uutiif dhikaate sun kennansa irra caalaa woyyuu te'e keessaa tokko waan te'eef, isin maaf addee woyyitti'itti nyaatuu dhaddane? Mootiin Waan Maraa akka isin fuula isaa duratti gumaa kennitanee kolbaa irraa yakkaa akka balleessitanu isiniif kenneeyyu. ");
INSERT INTO gax_vpl VALUES ("LV10_18","004_10_18","LEV","10","18","18","Dhiigi korbeessaa sun gara addee woyyitti'ii waan seenuu dhabeef, akkuma ani isin ajajetti silaa isin korbeessa san addee woyyitti'itti nyaatuu qaddaniiyyu» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV10_19","004_10_19","LEV","10","19","19","Aaronille deebisee Muuse'een, «Kunoo, isaan adha kennansa araara cubbu'uutiif dhikaatuu fi kennansa gubamu fuula Mootii Waan Maraa dura dhikeessaneeran; wonni akkasii kun analle dhaqqaddeerti; ani adha kennansa araara cubbu'uutiif dhikaate kana adoo nyaadhee jiraadhee silaa Mootiin Waan Maraa natti hin gammadaa ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV10_20","004_10_20","LEV","10","20","20","Muuseelle dubbii tana yennaa dhage'e gammade. ");
INSERT INTO gax_vpl VALUES ("LV11_1","004_11_1","LEV","11","1","1","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("LV11_2","004_11_2","LEV","11","2","2","«Israa'elootaan, ‹Bineensota maraa fi horii mara keessaa ka isin nyaatuu dandeettanu: ");
INSERT INTO gax_vpl VALUES ("LV11_3","004_11_3","LEV","11","3","3","ka kotteen isaa baqaqa qadduu fi ka alalfatu mara nyaatuu hin dandeettan. ");
INSERT INTO gax_vpl VALUES ("LV11_4","004_11_4","LEV","11","4","4","« ‹Bineensota alalfatu ka kotteen isaa baqaqa hin qanne yookiin ka kotteen isaa baqaqa qabaattee hin alalfanne hin nyaatina'a. Gaalli hin alalfata, garuu kotteen isaa baqaqa waan hin qanneef, akka aadaa dhugeeffanna'aatitti battii isiniif te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV11_5","004_11_5","LEV","11","5","5","Osoleen hin alalfatti, garuu kotteen isi'ii baqaqa waan hin qanneef, battii isiniif teetuu ti. ");
INSERT INTO gax_vpl VALUES ("LV11_6","004_11_6","LEV","11","6","6","Hilleensi hin alalfata, garuu kotteen isaa baqaqa waan hin qanneef, battii isiniif te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV11_7","004_11_7","LEV","11","7","7","Booyyee kotteen isi'ii baqaqa qaddi, garuu waan hin alalfanneef, battii isiniif teetuu ti. ");
INSERT INTO gax_vpl VALUES ("LV11_8","004_11_8","LEV","11","8","8","Isaan kun isiniif battii waan te'aneef, foon isaanii hin nyaatina'a; reeffa isaaniille hin tuqina'a. ");
INSERT INTO gax_vpl VALUES ("LV11_9","004_11_9","LEV","11","9","9","« ‹Bineensota abbaayaa keessatti yookiin laga keessatti dadamane keessaa, ka koolaa fi solloqqee qabanu nyaadhu. ");
INSERT INTO gax_vpl VALUES ("LV11_10","004_11_10","LEV","11","10","10","Bineensota abbaayaa keessatti yookiin laga keessatti dadamanee munyuuqanu mara keessaa, ka koola hin qanne yookiin ka solloqqee hin qanne ammoo hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("LV11_11","004_11_11","LEV","11","11","11","Isaan isiniif battii waan te'aneef, foon isaanii hin nyaatina'a; reeffa isaanille hin tuqina'a. ");
INSERT INTO gax_vpl VALUES ("LV11_12","004_11_12","LEV","11","12","12","Waan bisaan keessa le'u keessaa wonni koolaa fi solloqqee hin qanne marti isiniif battii te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV11_13","004_11_13","LEV","11","13","13","« ‹Gosa sinbirre'ee keessaa ta isiniif battii teetee fi ta isin ijjumaa hin nyaanne: risaa, allaattii, rumicha, ");
INSERT INTO gax_vpl VALUES ("LV11_14","004_11_14","LEV","11","14","14","culullee, jajjuu, ");
INSERT INTO gax_vpl VALUES ("LV11_15","004_11_15","LEV","11","15","15","harraaqqessa gosa adda addaa, ");
INSERT INTO gax_vpl VALUES ("LV11_16","004_11_16","LEV","11","16","16","guchii, baabboo, haanqaa, jajjuu gosa adda addaa, ");
INSERT INTO gax_vpl VALUES ("LV11_17","004_11_17","LEV","11","17","17","urunguu, huummoo, qillisaa, ");
INSERT INTO gax_vpl VALUES ("LV11_18","004_11_18","LEV","11","18","18","urunguu adii, urunguu goomole'ee, allaattii gosa adda addaa, ");
INSERT INTO gax_vpl VALUES ("LV11_19","004_11_19","LEV","11","19","19","qongaa, dhaatii, looyyituu, cirricho'o. ");
INSERT INTO gax_vpl VALUES ("LV11_20","004_11_20","LEV","11","20","20","« ‹Dadi didiqqoon koolaan ka'anu ka luka afuriin deemanu marti isiniif battii te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("LV11_21","004_11_21","LEV","11","21","21","Te'uu malee dadi koola qabaatanee, luka afuriin deemanu keessaa ka ittiin utaaliisaaf luka qondhooffatu qabanu mara hin nyaattan. ");
INSERT INTO gax_vpl VALUES ("LV11_22","004_11_22","LEV","11","22","22","Kana keessaa, ka akka korophiisa gosa adda addaa, farda waaqaa gosa adda addaa, awwaannisa gosa adda addaa hin nyaattan. ");
INSERT INTO gax_vpl VALUES ("LV11_23","004_11_23","LEV","11","23","23","Ka dhibiin ammoo dadi didiqqoon ka koola qabaatanee luka afuriin ideemanu marti isiniif battii te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("LV11_24","004_11_24","LEV","11","24","24","« ‹Isaan kun isin batteessan; nami reeffa isaanii tuqe marti haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_25","004_11_25","LEV","11","25","25","Nami reeffa isaanii lafaa fuudhe marti woyaa ifii dhiqatuu ti; inni haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_26","004_11_26","LEV","11","26","26","« ‹Bineensii fi horiin kotteen isaanii baqaqa qabaattee addee lamatti hin qoodaminii fi ka hin alalfanne isiniif battii te'anuu ti; nami reeffa isaanii tuqe marti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_27","004_11_27","LEV","11","27","27","Dada luka afuriin ideemanu keessaa ka barru'uun ideemanu marti isiniif battii te'anuu ti; nami reeffa isaanii tuqe marti haga galgala battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_28","004_11_28","LEV","11","28","28","Isaan isiniif battii waan te'aneef, nami reeffa isaanii lafaa fuudhe marti woyaa ifii dhiqatuu ti; inni haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_29","004_11_29","LEV","11","29","29","« ‹Bineensota lafa irra munyuuqanu keessaa worri battii te'e: tuqaa, hantuuta, qarcoo gosa adda addaa, ");
INSERT INTO gax_vpl VALUES ("LV11_30","004_11_30","LEV","11","30","30","bulee goggogaa, naacha, qocaa, wokkallaa, gaararraa, ");
INSERT INTO gax_vpl VALUES ("LV11_31","004_11_31","LEV","11","31","31","bineensota lafa irra munyuuqanu mara keessaa isaan kun isiniif batti'i; nami reeffa isaanii tuqe marti haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_32","004_11_32","LEV","11","32","32","Bineensoti akkasii du'ee meya muka irraa, woyaa irraa, gogaa irraa yookiin keeshaa irraa hujame irra yoo bu'e, mey sun marti battii hin te'a; bisaan keessa keya'a; te'uu malee haga galgalaatitti battii hin te'an; achiin duuba qulqulluu hin te'an. ");
INSERT INTO gax_vpl VALUES ("LV11_33","004_11_33","LEV","11","33","33","Reeffi isaanii meya faara irraa hujame keessa yoo bu'e, wonni keessa jiru marti battii waan teetuuf meya san cassa'a. ");
INSERT INTO gax_vpl VALUES ("LV11_34","004_11_34","LEV","11","34","34","Bisaan meya san keessaa Sagalee nyaatanu maratti yoo cophe, sagaleen sun battii hin teeti; wonni meya san keessaa unanu marti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_35","004_11_35","LEV","11","35","35","Wonni reeffi isaanii irra bu'e marti battii hin te'a; eeleen yookiin okkoteen sun cacadduu ti. Isaan martinuu batti'i; akka batti'iititti isaan ilaala'a. ");
INSERT INTO gax_vpl VALUES ("LV11_36","004_11_36","LEV","11","36","36","Wonni dhibiin ta reeffa bineensotaa fi horii kanaa tuqe marti battii te'anulle, maddi yookiin boolli bisaanii hin battoottu. ");
INSERT INTO gax_vpl VALUES ("LV11_37","004_11_37","LEV","11","37","37","Reeffi isaanii midhaan sanyi'ii irra yoo bu'e, sanyiin sun hin battoottu. ");
INSERT INTO gax_vpl VALUES ("LV11_38","004_11_38","LEV","11","38","38","Ammoo midhaan sanyi'iititti bisaan copheeruun reeffi bineensotaa fi horii sanii yoo irra bu'e, sanyiin sun isiniif battii hin teeti. ");
INSERT INTO gax_vpl VALUES ("LV11_39","004_11_39","LEV","11","39","39","« ‹Bineensaa fi horiin akka isin nyaattanu eeyyamame keessaa tokko yoo du'e, nami reeffa isaa tuqe haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_40","004_11_40","LEV","11","40","40","Nami foon bineensaa fi horii du'ee san nyaate woyaa ifii dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. Nami reeffa san lafaa fuudhe marti woyaa ifii dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV11_41","004_11_41","LEV","11","41","41","« ‹Dadi gadha'aan lafa irra sinqiiqqataa deemanu marti batti'i; isaan hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("LV11_42","004_11_42","LEV","11","42","42","Dadi gadha'aan lafa irra sinqiiqqatanu, ka gadha'aan lafa irra lowanu, ka miila afuriin sinqiiqqataa deemanu yookiin ka miila bacaa qabanu marti isiniif battii waan te'aneef hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("LV11_43","004_11_43","LEV","11","43","43","Bineensota akkanaa kana nyaattanee ifi hin batteessina'a; karaa isaaniitiin battii ifi hin godhina'a yookiin isaaniin hin battowina'a. ");
INSERT INTO gax_vpl VALUES ("LV11_44","004_11_44","LEV","11","44","44","Ani Mootii Waan Maraa Waaqa keessan; ani woyyuu waan te'eef, isinille ifi adda baasa'aatii, woyyuu te'a'a. Dada gadha'aan lafa irra sinqiiqqatanu kanaan ifi hin batteessina'a. ");
INSERT INTO gax_vpl VALUES ("LV11_45","004_11_45","LEV","11","45","45","Ani Waaqa keessan te'iisaaf, Mootii Waan Maraa ka biyya Gibxi'ii keessaa isin baase; tanaaf, ani woyyuu waan te'eef, isinille woyyuu te'a'a. ");
INSERT INTO gax_vpl VALUES ("LV11_46","004_11_46","LEV","11","46","46","« ‹Seerri marroo bineensotaa, marroo sinbirrootaa, marroo bineensota bisaan keessaatii fi marroo bineensota lafa irra munyuuqanu maraaf kenname kana. ");
INSERT INTO gax_vpl VALUES ("LV11_47","004_11_47","LEV","11","47","47","Isin waan battii te'ee fi waan qulqulluu te'e, dada lafa irraa ta lubbuu qaddu keessaa ka nyaatamanuu fi ka hin nyaatanne gargar baasa'aatii beeka'a› jedha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV12_1","004_12_1","LEV","12","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV12_2","004_12_2","LEV","12","2","2","«Israa'elootaan, ‹Dubartiin ulfoottee ilma yennaa deettu, akkuma xuriin isi'ii ji'uma ji'aan yennaa dhutte battoottu, akka aadaa dhugeeffanna'aatitti guyyaa torbaaf battii hin teeti. ");
INSERT INTO gax_vpl VALUES ("LV12_3","004_12_3","LEV","12","3","3","Guyyaa saddeeteso'ootitti mucaan haqanqabaa qabatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV12_4","004_12_4","LEV","12","4","4","Achiin duuba dubartittiin haga xurii ifii irraa qulqulloontutti, guyyaa soddomii sad eegattuu ti. Haga guyyaan qulqulloomiisa isi'ii muummowutti waan woyyuu te'e hin tuqin yookiin gara addee woyyitti'ii hin dhaqin. ");
INSERT INTO gax_vpl VALUES ("LV12_5","004_12_5","LEV","12","5","5","Yoo durra deette akkuma yennaa xurii isi'ii haga torbaan lamaa battii hin teeti. Achiin duuba isiin xurii ifii irraa qulqulloomiisaaf, guyyaa jaatamii jaa eegattuu ti. ");
INSERT INTO gax_vpl VALUES ("LV12_6","004_12_6","LEV","12","6","6","« ‹Dubartittiin ilma yookiin intala deettee yennaan qulqulloomiisa isi'ii yennaa muummotte, isiin kennansa gubamuuf buruusoo hoole'ee ka woggaa tokkoo, kennansa araara cubbu'uutiif dhikaatu maddoo yookiin saphaliisa seensuma Dunkaanii Woldeenna'aa duratti gara hayyichaa fidduu ti. ");
INSERT INTO gax_vpl VALUES ("LV12_7","004_12_7","LEV","12","7","7","Innille cubbuu isi'iitiif gumaa tolchiisaaf fuula Mootii Waan Maraa dura dhikeessuu ti. Isiille akka aadaa dhugeeffanna'aatitti dhiiga isii irraa dhangala'u irraa hin qulqulloonti. Seerri yennaa dubartiin ilma yookiin intala deettee kana. ");
INSERT INTO gax_vpl VALUES ("LV12_8","004_12_8","LEV","12","8","8","« ‹Isiin buruusoo hoole'ee dhikeessuu yoo hin dandeenne, saphaliisa lama yookiin maddoo lama takkattii kennansa gubamuuf, takkattii araara cubbu'uutiif dhikeessituu ti; akka kanaan hayyichi cubbuu isi'iitiif gumaa tolchee, isiin hin qulqulloonti› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV13_1","004_13_1","LEV","13","1","1","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("LV13_2","004_13_2","LEV","13","2","2","«Nama gogaa nafa ifii irratti iita yookiin robbii yookiin baarilee qabaatee, gara dhukkuba goga'aa farrisiisa'aatitti yoo jijjiiramu te'e, gara Aaronii yookiin ilmaan isaa keessaa gara nama hayyuu te'ee fidanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_3","004_13_3","LEV","13","3","3","Hayyichi madaa gogaa namichaa san qorqoruu ti; rifeensi madaa san keessa jiru adii te'ee yoo jiraate, addeen mada'aa sun gogaa keessa dabartee gara keessaa boollottee yoo jiraate, kun dhukkuba goga'aa farrisiisa'a. Hayyichi qorqoree hubateen duuba akka aadaa dhugeeffanna'aatitti akka inni battii te'eeru beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_4","004_13_4","LEV","13","4","4","Baarileen gogaa namichaa irraa sun gara keessaa boollottee yoo hin jiraanne, rifeensi isii keessaalle adii te'ee yoo hin jiraanne, hayyichi nama dhibamaa san haga guyyaa torbaa qofi isa baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_5","004_13_5","LEV","13","5","5","Guyyaa torbeesso'ootitti hayyichi isa qorqoree, madaan sun akkuma duraa teetee gogaa isaa keessa babadhataa yoo hin jiraanne, hayyichi ammalle haga guyyaa torbaa qofi isa baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_6","004_13_6","LEV","13","6","6","Hayyichi ammalle guyyaa torbeesso'ootitti isa qorqoruu ti; madaan sun qoortee gogaa keessa babadhatiisa lakkittee qoortee yoo jiraatte, dhukkubi sun robbii waan te'eef, hayyichi qulqullummaa isaa beessisuu ti. Namichille woyaa ifii dhiqatuu ti; inni qulqulluu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV13_7","004_13_7","LEV","13","7","7","Hayyichi isa qorqoree qulqulluu akka inni te'e beessiseen duuba robbiin sun gogaa isaa keessaa babadhataa yoo deente, inni ammalle hayyicha dura dhikaatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_8","004_13_8","LEV","13","8","8","Hayyichi isa qorqoree robbiin sun gogaa isaa keessa babadhataa deemee yoo jiraate, dhukkubi sun dhukkuba goga'aa farrisiisa'a; hayyichi namichi sun battii akka te'e beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_9","004_13_9","LEV","13","9","9","«Nami tokko dhukkuba goga'aa farrisiisaa yoo qabaate gara hayyichaa fidanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_10","004_13_10","LEV","13","10","10","Hayyichi isa qorqoruu ti; Gogaa isaa keessa iiti adiin rifeensa isaa adii gootee, iita san keessaa foon diimaan yoo ol baye, ");
INSERT INTO gax_vpl VALUES ("LV13_11","004_13_11","LEV","13","11","11","dhukkuba goga'aa farrisiisaa hidda naqate waan te'eef namichi sun battii akka te'e hayyichi beessisuu ti. Inni battii waan te'eef hayyichi qofi isa hin baasin. ");
INSERT INTO gax_vpl VALUES ("LV13_12","004_13_12","LEV","13","12","12","«Dhukkubi sun guddatee gogaa namichaa mara irratti bayee, hayyichi qorqoree yennaa ilaalu, mata'aa haga miila isaa yoo golle, ");
INSERT INTO gax_vpl VALUES ("LV13_13","004_13_13","LEV","13","13","13","hayyichi ammalle isa qorqoree, dhukkubi sun nafa namichaa mara akka golle yoo dhagge, namichi qulqulluu akka te'e beessisuu ti. Gogaan isaa marti adii waan te'eef, inni qulqulluu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV13_14","004_13_14","LEV","13","14","14","Madaan sun kulkultee foon diimaan yoo isa irratti mudhate ammoo inni battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV13_15","004_13_15","LEV","13","15","15","Hayyichi qorqoree foon diimaa yoo isa irratti dhagge, namichi battii akka te'e beessisuu ti. Foon diimaan sun battii waan te'eef, namichi dhukkuba goga'aa farrisiisaa qaba. ");
INSERT INTO gax_vpl VALUES ("LV13_16","004_13_16","LEV","13","16","16","Foon diimaan sun deebi'ee yoo addaate ammoo inni gara hayyichaa dhaquu qaba. ");
INSERT INTO gax_vpl VALUES ("LV13_17","004_13_17","LEV","13","17","17","Hayyichille isa qorqoruu ti. Madaan sun deebitee yoo addaatte namichi sun qulqulluu akka te'e hayyichi beessisuu ti; achiin duuba inni qulqulluu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV13_18","004_13_18","LEV","13","18","18","«Nami tokko gogaa ifii irratti iita qabaatee, iiti sun yoo fayye, ");
INSERT INTO gax_vpl VALUES ("LV13_19","004_13_19","LEV","13","19","19","addee iitaa san irratti, iiti adiin yookiin baarileen diimattee addaattu yoo mudhatte, inni gara hayyichaa dhaquu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_20","004_13_20","LEV","13","20","20","Hayyichille qorqoruu ti; iiti sun gogaa keessa dabartee boollottee, rifeensi isii keessaalle addaatee yoo jiraate, dhukkubi sun dhukkuba goga'aa farrisiisaa, iita irratti baye waan te'eef, namichi battii akka te'e hayyichi beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_21","004_13_21","LEV","13","21","21","Hayyichi yennaa qorqoree rifeensi adiin iita san keessa yoo hin jiraanne, iiti sun gogaa keessa dabartee adoo hin boollowin, qoortee yoo jiraatte, hayyichi haga guyyaa torbaa qofi isa baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_22","004_13_22","LEV","13","22","22","Robbiin sun gogaa keessa babadhatte yoo jiraatte, dhukkuba goga'aa farrisiisaa waan te'eef, hayyichi akka inni battii te'e beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_23","004_13_23","LEV","13","23","23","Robbiin sun adduma jirtutti hattee yoo hin babadhatin, gadaannisa iitaa qofa waan te'eef, hayyichi akka inni qulqulluu te'e beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_24","004_13_24","LEV","13","24","24","«Nama tokko gogaan isaa yennaa gubate, addee gubate san irratti baarileen diimattee addaattu yookiin addiin yoo mudhatte, ");
INSERT INTO gax_vpl VALUES ("LV13_25","004_13_25","LEV","13","25","25","Hayyichi baarilee san qorqoruu ti; rifeensi baarilee san keessa jiru adii te'ee yoo jiraate, addeen mada'aa sun gogaa keessa dabartee gara keessaa boollottee yoo jiraate, kun dhukkuba goga'aa farrisiisaa addee gubatte san keessatti baye waan te'eef, hayyichi namichi battii akka te'e beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_26","004_13_26","LEV","13","26","26","Hayyichi baarilee san qorqoree, rifeensi adiin isii keessa yoo hin jiraanne, baarileen sun gogaa keessa dabartee adoo hin boollowin, qoortee yoo jiraatte, hayyichi haga guyyaa torbaa qofi isa baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_27","004_13_27","LEV","13","27","27","Guyyaa torbeesso'ootitti hayyichi ammalle qorqoruu ti; baarileen sun gogaa keessa babadhattee yoo jiraate, dhukkuba goga'aa farrisiisaa waan te'eef, hayyichi akka inni battii te'e beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_28","004_13_28","LEV","13","28","28","Baarileen sun adduma jirtutti hattee gogaa keessa adoo hin babadhatin qoortee yoo jiraatte, gadaannisa iita addee gubatee qofa waan te'eef, hayyichi akka namichi qulqulluu te'e beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_29","004_13_29","LEV","13","29","29","«Namichi tokko yookiin dubartiin takka mataa irratti yookiin areeda irraa madaa yoo qabaatane, ");
INSERT INTO gax_vpl VALUES ("LV13_30","004_13_30","LEV","13","30","30","hayyichi madaa san qorqoruu ti; madaan sun gogaa keessa dabartee, rifeensi isii keessaa hadhooticha te'ee qadhatee yoo jiraate, dhukkuba citto'oo yookiin dhukkuba goga'aa farrisiisaa mataa irratti yookiin areeda irratti baye waan te'eef, hayyichi nami sun battii akka te'e beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_31","004_13_31","LEV","13","31","31","Hayyichi madaa akkasii tana yennaa qorqore ammoo, madaan sun gogaa keessa adoo hin dabarin, rifeensi gurraachille keessa yoo hin jiraatin, hayyichi nama san haga guyyaa torbaa qofi isa baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_32","004_13_32","LEV","13","32","32","Guyyaa torbeesso'ootitti hayyichi ammalle madaa san qorqoruu ti; madaan sun adoo hin babadhatin, rifeensi isii keessaa booka fakkaatee gogaa keessa dabartee gara keessaa boollottee yoo hin jiraatin, ");
INSERT INTO gax_vpl VALUES ("LV13_33","004_13_33","LEV","13","33","33","hayyichi addee mada'aa san qofa lakkisee rifeensa irraa haadatuu ti; hayyichi guyyaa torba itti dabalee ammalle qofi isa baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_34","004_13_34","LEV","13","34","34","Guyyaa torbeesso'ootitti hayyichi ammalle madaa san qorqoruu ti; madaa sun gogaa keessa dabartee babadhattee yoo hin jiraatin, hayyichi akka inni qulqulluu te'e beessisuu ti. Namichille woyaa ifii dhiqatuu ti; inni qulqulluu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV13_35","004_13_35","LEV","13","35","35","Inni qulqulluu akka te'e beessifameen duuba madaan sun gogaa keessa babadhataa yoo deente ammoo, ");
INSERT INTO gax_vpl VALUES ("LV13_36","004_13_36","LEV","13","36","36","hayyichi isa qorqoruu ti; madaan sun gogaa keessa babadhattee yoo jiraatte, namichi battii waan te'eef, hayyichi rifeensa booka fakkaatu san ilaaluu hin barbaachisu. ");
INSERT INTO gax_vpl VALUES ("LV13_37","004_13_37","LEV","13","37","37","Te'uu malee, akka ilaalcha hayyichaatitti madaan sun achumatti hattee, rifeensi guraachi keessatti latee yoo jiraate, madaan sun fayyiteerti. Namichi qulqullu'u; akka inni qulqulluu te'e hayyichi beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_38","004_13_38","LEV","13","38","38","«Namichi tokko yookiin dubartiin takka gogaa ifii irratti baarilee adii yoo qabaatane, ");
INSERT INTO gax_vpl VALUES ("LV13_39","004_13_39","LEV","13","39","39","hayyichi isaan qorqoruu ti; madaan sun babadhattee shankallittii yoo teete, robbii gogaa irratti baate malee ta miituu moti; namichi sun qulqullu'u. ");
INSERT INTO gax_vpl VALUES ("LV13_40","004_13_40","LEV","13","40","40","«Nami tokko rifeensa mataa ifii yoo dhabe, molu'utti isa nyaate; inni qulqullu'u. ");
INSERT INTO gax_vpl VALUES ("LV13_41","004_13_41","LEV","13","41","41","Inni rifeensa ifii adda irraa yoo dhabe, molu'utti isa nyaate; inni qulqullu'u. ");
INSERT INTO gax_vpl VALUES ("LV13_42","004_13_42","LEV","13","42","42","Inni moluu ifii irratti yookiin adda ifii irratti madaa diimattee addaattu yoo qabaate, dhukkuba goga'aa farrisiisaa mataa isaa irratti yookiin adda isaa irratti baye. ");
INSERT INTO gax_vpl VALUES ("LV13_43","004_13_43","LEV","13","43","43","Hayyichi isa qorqoruu ti; mataa isaa irratti yookiin adda isaa irratti madaan diimattee addaattu ta dhukkuba goga'aa farrisiisaa fakkaattu yoo mudhatte, ");
INSERT INTO gax_vpl VALUES ("LV13_44","004_13_44","LEV","13","44","44","nami sun dhukkuba goga'aa farrisiisaa qaba; battiille'e. Inni mataa ifii irraa madaa waan qabuuf, hayyichi akka inni battii te'e beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_45","004_13_45","LEV","13","45","45","«Nami dhukkuba goga'aa farrisiisaa qabu woyaa tarsaate uffatuu ti; mataa ifii hin filatin; woyaa afaanitti qabatee, ‹Ani batti'i! Ani batti'i!› jedhaa lallabuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_46","004_13_46","LEV","13","46","46","Inni haga dhukkuba goga'aa farrisiisaa san qabu batti'i. Inni qofi le'uu ti; addee quttumaatiin ala le'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_47","004_13_47","LEV","13","47","47","«Woyaan rifeensa hoole'eetiin yookiin quncee talba'aatiin hujante takka, dhukkuba goga'aa farrisiisa'aan yoo tuttuqante, ");
INSERT INTO gax_vpl VALUES ("LV13_48","004_13_48","LEV","13","48","48","woyaa meya worra woyaa dhowuutiin dhowante yookiin ta harkaan dhowante yookiin ta rifeensa hoole'ee irraa hujante yookiin ta quncee talba'aa irraa hujante yookiin gogaan marti yookiin waan gogaa irraa hujamelle yoo te'e, ");
INSERT INTO gax_vpl VALUES ("LV13_49","004_13_49","LEV","13","49","49","addeen tuttuqante sun magariisottee yookiin diimattee woyaa irratti yookiin waan gogaa irraa hujame irratti yookiin woyaa meya worra woyaa dhowuutiin dhowante irratti yookiin ta harkaan dhowante irratti yookiin meya gogaa irraa hujame mara irratti yoo mudhatte, dhukkuba goga'aa farrisiisaa babadhataa deemu waan te'eef hayyichatti mudhifamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_50","004_13_50","LEV","13","50","50","Hayyichi dhukkuba san qorqoree, woyaa dhukkubaan tuttuqante san guyyaa torbaaf qofi baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_51","004_13_51","LEV","13","51","51","Guyyaa torbeesso'ootitti ammalle qorqoruu ti; dhukkubi sun woyaa irratti, woyaa meya worra woyaa dhowuutiin dhowante yookiin ta harkaan dhowante irratti, waan gogaa irraa hujame irratti yoo mudhate, dhukkuba goga'aa farrisiisaa hama'a; mey sunille batti'i. ");
INSERT INTO gax_vpl VALUES ("LV13_52","004_13_52","LEV","13","52","52","Hayyichi woyaa yookiin woyaa meya worra woyaa dhowuutiin dhowante yookiin ta harkaan dhowante, Woyaa rifeensa hoole'eetiin yookiin quncee talba'aatiin hujante yookiin meya gogaa irraa hujame mara ka dhukkuba goga'aa farrisiisa'aan tuttuqame gubuu ti; inni dhukkuba goga'aa farrisiisaa hamaa waan te'eef, mey sun gubamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_53","004_13_53","LEV","13","53","53","«Hayyichi yennaa qorqoru, dhukkubi sun woyaa irratti yookiin woyaa meya worra woyaa dhowuutiin dhowante irratti yookiin ta harkaan dhowante irratti yookiin meya gogaa irraa hujame irratti babadhatee yoo hin jiraanne, ");
INSERT INTO gax_vpl VALUES ("LV13_54","004_13_54","LEV","13","54","54","mey tuttuqame sun akka dhiqamu ajajuu ti. Achiin duuba meya san ammalle guyyaa torbaaf qofi baasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_55","004_13_55","LEV","13","55","55","Mey tuttuqame sun dhiqameen duuba hayyichi qorqoruu ti; dhukkubi sun bifa ifii yoo hin jijjiiratin, meya keessa babadhatuu dhabulle, mey sun batti'i; dhukkubi sun meya san gara keessaatiin yookiin gara duubaatiin tuttuqee jiraatulle ibiddaan gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_56","004_13_56","LEV","13","56","56","Mey sun dhiqameen duuba ammoo hayyichi yennaa qorqoru, dhukkubi sun woyaa irraa qooree yoo jiraate, addee dhukkubi tuttuqe san woyaa irraa yookiin waan gogaa irraa hujame irraa yookiin woyaa meya worra woyaa dhowuutiin dhowante yookiin ta harkaan dhowante irraa tarsaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_57","004_13_57","LEV","13","57","57","Dhukkubi sun ammalle woyaa irratti yookiin woyaa meya worra woyaa dhowuutiin dhowante yookiin ta harkaan dhowante irratti yookiin meya gogaa irraa hujame irratti deebi'ee yoo mudhatte, inni dhukkuba babadhataa deemu waan te'eef, mey dhukkuba goga'aa farrisiisaa qabu sun marti ibiddaan gubamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV13_58","004_13_58","LEV","13","58","58","Woyaan yookiin woyaa meya worra woyaa dhowuutiin dhowante yookiin ta harkaan dhowante yookiin mey gogaa irraa hujame marti dhiqamee irraa badeen duuba deebi'ee dhiqamuu ti; mey sun qulqulluu hin te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV13_59","004_13_59","LEV","13","59","59","Kun seera uffanni rifeensa hoole'ee irraa hujame yookiin woyaan meya worra woyaa dhowuutiin dhowante yookiin ta harkaan dhowante yookiin mey gogaa irraa hujame martille ka dhukkuba goga'aa farrisiisa'aan tuttuqame, dhukkuba goga'aa farrisiisaa irraa akka qulqulloome yookiin battii akka te'e ittiin beekkamu. ");
INSERT INTO gax_vpl VALUES ("LV14_1","004_14_1","LEV","14","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV14_2","004_14_2","LEV","14","2","2","«Seerri nama dhukkuba goga'aa farrisiisaa qabu akka aadaa dhugeeffanna'aatitti akka inni qulqulloomuuf gara hayyichaa yennaa fidanuu ka asii gad jiru: ");
INSERT INTO gax_vpl VALUES ("LV14_3","004_14_3","LEV","14","3","3","Hayyichi addee quttumaatiin alatti bayee nama dhukkuba goga'aa farrisiisaa qabu san qorqoruu ti. Nami sun dhukkuba san irraa fayyee yoo jiraate, ");
INSERT INTO gax_vpl VALUES ("LV14_4","004_14_4","LEV","14","4","4","hayyichi sinbirroota qulqulluu lama ta lubbu'uun jirtu, muka hindheensaa, liilana dhiille'ee fi baala muka hisoophii namicha qulqulleeffamu saniif akka fidanu ajajuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_5","004_14_5","LEV","14","5","5","Achiin duuba hayyichi sinbirroota san keessaa takkattii, okkotee bisaan maddaa keessa jiru irratti akka qalantu ajajuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_6","004_14_6","LEV","14","6","6","Achiin duuba sinbirree lubbu'uun jirtu san fuudhee muka hindheensaa, liilana dhiille'ee fi baala muka hisoophii woliin dhiiga sinbirree okkotee bisaan maddaa keessa jiru irratti qalante san keessa cuuphuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_7","004_14_7","LEV","14","7","7","Dhiiga nama dhukkuba goga'aa farrisiisaa irraa qulqulleeffamu sanitti yennaa torba fiffixee akka inni qulqulluu te'e beessisuu ti. Achii duuba Sinbirree lubbu'uun jirtu san diidatti gad lakkisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_8","004_14_8","LEV","14","8","8","«Nami qulqulloome sun woyaa ifii dhiqatuu ti; rifeensa ifii mara haadatee, nafa ifii bisaaniin dhiqatuu ti; achiin duuba inni akka aadaa dhugeeffanna'aatitti qulqulluu hin te'a. Tanaan duuba addee quttumaatitti deebi'uu ti; te'uu malee haga guyyaa torbaa dunkaanii ifiititti adoo hin galin ala turuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_9","004_14_9","LEV","14","9","9","Guyyaa torbeesso'ootitti ammalle rifeensa ifii mara haadatuu ti; rifeensa mata'aa, ka areeda, ka gaara ilaatii fi ka nafa ifii irraa mara haadatuu ti; woyaa ifii dhiqatee, nafa ifiille bisaaniin dhiqatuu ti; achiin duuba inni qulqulluu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV14_10","004_14_10","LEV","14","10","10","«Guyyaa saddeetesso'oo ammoo buruusoo korbeeyyii hoole'ee lama ta fafa hin qannee fi gorontii hoole'ee buruusoo takkattii ta woggaa tokkoo ta fafa hin qanne dhikeessuu ti; akkasuma kennansa midhaanii bullaa dansaa kiiloogiraama jaa ta zayitii ejersaatiin sukkuumantee fi zayitii ejersaa buttullee tokko fiduu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_11","004_14_11","LEV","14","11","11","Hayyichi akka inni qulqulloome beessisu sun namicha qulqulloomuu fi kennansa inni kenne san woliin gara Dunkaanii Woldeenna'aa fuula Mootii Waan maraa dura dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_12","004_14_12","LEV","14","12","12","«Achiin duuba hayyichi buruusoo korbeeyyii hoole'ee san keessaa tokko fuudhee, zayitii ejersaa buttullee tokko woliin kennansa sababa yakka'aatiif dhikaatu, kennansa tachoofamu fuula Mootii Waan Maraa dura dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_13","004_14_13","LEV","14","13","13","Inni buruusoo korbeessa hoole'ee san addee woyyittii kennansi araara cubbu'uutii fi kennansi gubamu qalamutti qaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_14","004_14_14","LEV","14","14","14","Hayyichi dhiiga buruusoo korbeessa hoole'ee ka kennansa sababa yakka'aatiif dhikaatuu san irraa diqqaa isaa fuudhee, qaccee gurra namicha qulqulloomuu san ka gara middaa, quba isaa abguddicha ka harka middichaatii fi quba isaa abguddicha ka miila middichaa dibuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_15","004_14_15","LEV","14","15","15","Hayyichi zayitii ejersaa san irraa diqqoo isi'ii fuudhee barruu harka ifii bitaachaatitti dhangalaasuu ti; ");
INSERT INTO gax_vpl VALUES ("LV14_16","004_14_16","LEV","14","16","16","Quba ifii ka harka middichaa zayitii barruu harka isaa bitaacha keessa jirtu keessa cuuphee yennaa torba Mootii Waan Maraa duratti fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_17","004_14_17","LEV","14","17","17","Zayitii ejersaa ta barruu harka isaa keessatti hatte san qaccee gurra namicha qulqulloomuu san ka gara middaa, quba isaa abguddicha ka harka middichaatii fi quba isaa abguddicha ka miila middichaa dhiiga kennansa sababa yakka'aatiif dhikaatee san irratti dabalee dibuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_18","004_14_18","LEV","14","18","18","Zayitii ejersaa ta barruu harka isaatitti hatte san hayyichi mataa namicha qulqulloomuu san dibee, Mootii Waan Maraa duratti gumaa isaaf godhuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_19","004_14_19","LEV","14","19","19","«Achiin duuba hayyichi kennansa araara cubbu'uutiif dhikaatu san ciincessee, nama battummaa ifii irraa qulqulloomu saniif gumaa godhuu ti. Saniin duuba horii kennansa gubamuu san qalee, ");
INSERT INTO gax_vpl VALUES ("LV14_20","004_14_20","LEV","14","20","20","addee ciinca'aa irratti kennansa midhaanii woliin dhikeessee, gumaa isaaf godhuu ti; innille qulqulluu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV14_21","004_14_21","LEV","14","21","21","«Te'uu malee, nami sun hiyyeessa te'ee waan kana dhikeessuu yoo dadhabe, cubbuu ifiitiif gumaa godhiisaaf, kennansa tachoofamu ka sababa yakka'aatiif dhikaatu buruusoo korbeessa hoole'ee tokko fuudhee, kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumante kiiloo lama, zayitii ejersaa buttullee tokko woliin fiduu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_22","004_14_22","LEV","14","22","22","Akkasuma saphaliisa lama yookiin maddoo lama keessaa ka dande'u, takkattii kennansa araara cubbu'uutiif, takkattii kennansa gubamuuf dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_23","004_14_23","LEV","14","23","23","«Isaan kana guyyaa saddeetesso'oo qulqulloomiisa ifiitiif seensuma Dunkaanii Woldeenna'aatitti fuula kiyya duratti gara hayyichaa fiduu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_24","004_14_24","LEV","14","24","24","Hayyichi buruusoo korbeessa hoole'ee ka sababa yakka'aatiif dhikaatu san fuudhee, zayitii ejersaa buttullee tokko woliin kennansa tachoofamu ana Mootii Waan Maraa dura dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_25","004_14_25","LEV","14","25","25","Inni buruusoo korbeessa hoole'ee ka sababa yakka'aatiif dhikaate san qalee, dhiiga isaa irraa diqqaa isaa fuudhee, qaccee gurra namicha qulqulloomuu san ka gara middaa, quba isaa abguddicha ka harka middichaatii fi quba isaa abguddicha ka miila middichaa dibuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_26","004_14_26","LEV","14","26","26","Hayyichi zayitii ejersaa san irraa diqqoo isi'ii fuudhee barruu harka ifii bitaachaatitti dhangalaasuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_27","004_14_27","LEV","14","27","27","Quba ifii ka harka middichaatiin barruu harka ifii keessaa zayitii ejersaa san diqqoo isi'ii yennaa torba ana Mootii Waan Maraa duratti fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_28","004_14_28","LEV","14","28","28","Zayitii ejersaa diqqoo ta barruu harka isaa keessa jirtu san irraa diqqoo isi'ii adduma dhiiga horii sababa yakka'aatiif dhikaate dibe san, qaccee gurra namicha qulqulloomuu san ka gara middaa, quba isaa abguddicha ka harka middichaatii fi quba isaa abguddicha ka miila middichaa itti dabalee dibuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_29","004_14_29","LEV","14","29","29","Hayyichi zayitii ejersaa ta barruu harka isaatitti hatte, gumaa cubbu'uu isaaf tolchiisaaf, ana Mootii Waan Maraa duratti, mataa namicha qulqulloomu saniititti dibuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_30","004_14_30","LEV","14","30","30","Achiin duuba inni saphaliisa yookiin maddoo namichi fiduu dande'e san ciincessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_31","004_14_31","LEV","14","31","31","Takkattii kennansa araara cubbu'uutiif taan ammoo kennansa gubamuuf, kennansa midhaanii woliin dhikeessuu ti. Akka kanaan hayyichi namicha qulqulloomu saniif fuula ana Mootii Waan Maraa duratti gumaa hin tolcha» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV14_32","004_14_32","LEV","14","32","32","Kun Seera nama dhukkuba farrisiisa'aan qabamee, hiyyeessa waan te'eef, ittiin qulqulloomiisaaf, kennansa barbaachisaa te'e kennuu dadhabee ti. ");
INSERT INTO gax_vpl VALUES ("LV14_33","004_14_33","LEV","14","33","33","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("LV14_34","004_14_34","LEV","14","34","34","«Lafa kana'aanii, ta ani qooda keessan godhee isiniif kennu sanitti yennaa galtanu, ani mana lafa sanii tokko keessatti dhukkuba goga'aa farrisiisaa yoo buuse, ");
INSERT INTO gax_vpl VALUES ("LV14_35","004_14_35","LEV","14","35","35","abbaan mana sanii gara hayyichaa dhaqee, ‹Waan dhukkuba goga'aa farrisiisaa fakkaatu mana kiyya keessatti dhaggeera› jedhee hayyichatti himuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_36","004_14_36","LEV","14","36","36","Hayyichi mana san dhaqee dhukkuba goga'aa farrisiisaa san adoo hin qorqoriniin dura, mey mana san keessa jiru marti akka hin battoonne, mana keessaa akka gad baasanu ajajuu ti; achiin duuba hayyichi mana san seenee qorqoruu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_37","004_14_37","LEV","14","37","37","Hayyichi dhukkuba goga'aa farrisiisaa san dhaaba manaa irra qorqoruu ti; wonni bifa magariisaa yookiin diintuun dhaaba mana dhaka'aa boollessitee yoo dhaggante, ");
INSERT INTO gax_vpl VALUES ("LV14_38","004_14_38","LEV","14","38","38","Hayyichi mana keessaa bayee guyyaa torbaaf mana san cufuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_39","004_14_39","LEV","14","39","39","Guyyaa torbeesso'ootitti hayyichi deebi'ee mana san qorqoruu ti; dhukkubi sun dhaaba mana dhaka'aa irra faffaca'ee yoo jiraate, ");
INSERT INTO gax_vpl VALUES ("LV14_40","004_14_40","LEV","14","40","40","hayyichi dhakaan dhukkubi goga'aa farrisiisaan irratti dhaggame sun hoqonqolamee bayee qacha'aan alatti addee batti'itti akka gatamu ajajuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_41","004_14_41","LEV","14","41","41","Saniin duuba inni dhaaba mana dhaka'aa san mara gara keessaatiin irraa duguugee, waan irraa hoqooqame san qacha'aan alatti addee batti'itti akka gatamu godhuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_42","004_14_42","LEV","14","42","42","Achiin duuba dhakaa dhibii fidanee addee dhakaa kaan baasanetti keyanee, faara haareyaan dhoobbanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_43","004_14_43","LEV","14","43","43","«Dhakaan keessaa bayee, dhaabi mana dhaka'aa sun hoqooqamee dhoobbameen duuba dhukkubi deebi'ee mana keessatti yoo mudhate, ");
INSERT INTO gax_vpl VALUES ("LV14_44","004_14_44","LEV","14","44","44","hayyichi dhaqee qorqoruu ti; dhukkubi sun mana keessa faffaca'ee yoo jiraate, dhukkuba goga'aa farrisiisaa hama'a; manni sunille batti'i. ");
INSERT INTO gax_vpl VALUES ("LV14_45","004_14_45","LEV","14","45","45","Manni sun diigamee, dhakaan isaa, muki isaa, faarri isaa ka itti dhoobbame marti qacha'aan alatti addee batti'itti gatamanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_46","004_14_46","LEV","14","46","46","Manni sun cufameeruun nami tokko keessa yoo seene, nami sun haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV14_47","004_14_47","LEV","14","47","47","Nami mana san keessa rafe yookiin keessatti nyaate woyaa ifii dhiqatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_48","004_14_48","LEV","14","48","48","«Manni sun dhoobbameen duuba hayyichi dhufee yoo qorqoru ammoo, dhukkubi goga'aa farrisiisaan sun mana san keessa faffaca'ee yoo hin jiraatin, dhukkubi sun waan badeeruuf, manni sun qulqulluu akka te'e hayyichi beessisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_49","004_14_49","LEV","14","49","49","Mana san qulqulloonsiisaaf, inni sinbirree lama, muka hindheensaa, liilana dhiille'ee fi baala hisoophii dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_50","004_14_50","LEV","14","50","50","Sinbirroota san keessaa takkattii okkotee bisaan maddaa keessa jiru irratti qaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_51","004_14_51","LEV","14","51","51","Achiin duuba muka hindheensaa, baala muka hisoophii, liilana dhiille'ee fi sinbirree lubbu'uun jirtu san fuudhee, dhiiga sinbirree qalanteetii fi bisaan maddaa ka okkotee keessa jiru san keessa cuuphee mana sanitti yennaa torba fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_52","004_14_52","LEV","14","52","52","Inni dhiiga simbirre'eetiin, bisaan maddaatiin, sinbirree lubbu'uun jirtuun, muka hindheensaatiin, baala muka hisoophiitii fi liilana dhiille'een mana san qulqulloonsuu ti. ");
INSERT INTO gax_vpl VALUES ("LV14_53","004_14_53","LEV","14","53","53","Achiin duuba inni sinbirree lubbu'uun jirtu san qacha'aan alatti diidatti gad lakkisuu ti. Akka kanaan inni mana saniif gumaa tolchee, manni sun qulqulluu hin te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV14_54","004_14_54","LEV","14","54","54","Seerri kun seera dhukkuba goga'aa farrisiisa'aa, dhukkuba citto'oo, ");
INSERT INTO gax_vpl VALUES ("LV14_55","004_14_55","LEV","14","55","55","dhukkuba goga'aa farrisiisaa ka woyaa keessaa yookiin ka mana keessaa, ");
INSERT INTO gax_vpl VALUES ("LV14_56","004_14_56","LEV","14","56","56","ka iitaa, ka robbi'ii yookiin ka baarile'ee ti. ");
INSERT INTO gax_vpl VALUES ("LV14_57","004_14_57","LEV","14","57","57","Wonni tokko qulqulluu akka te'e yookiin qulqulluu akka hinte'in isaan kanaan beekkama. Seerri kun seera marroo dhukkuba gosa kana maraa ti. ");
INSERT INTO gax_vpl VALUES ("LV15_1","004_15_1","LEV","15","1","1","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("LV15_2","004_15_2","LEV","15","2","2","«Kolbaa Israa'eliitiin, ‹Nami nafa hilaa isaa keessaa woy dhangala'u, wonni dhangala'u sun batti'i. ");
INSERT INTO gax_vpl VALUES ("LV15_3","004_15_3","LEV","15","3","3","Nafa hilaa isaa keessaa wonni dhangala'u sun ittuma fufee yoo dhangala'e yookiin dhangala'iisa yoo lakkiselle nami sun batti'i; wonni isa keessaa dhangala'u sun akki ittiin battummaa fiddu: ");
INSERT INTO gax_vpl VALUES ("LV15_4","004_15_4","LEV","15","4","4","« ‹Taqeen nami nafa hilaa isaa keessaa woy dhangala'u irra irkate marti battii hin teeti; wonni inni irra te'e martille hin battootti. ");
INSERT INTO gax_vpl VALUES ("LV15_5","004_15_5","LEV","15","5","5","Nami taqee isaa tuqe marti woyaa ifii dhiqatuu ti; nafa ifiille bisaaniin dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_6","004_15_6","LEV","15","6","6","Waan nami nafa hilaa ka isaa keessaa woy dhangala'u irra tee'e irra nami tee'e marti woyaa ifii dhiqatuu ti; nafa ifiille bisaaniin dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_7","004_15_7","LEV","15","7","7","Nama nafa hilaa isaa keessaa woy dhangala'u nami tuqe marti woyaa ifii dhiqatuu ti; nafa ifiille bisaaniin dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_8","004_15_8","LEV","15","8","8","Nami nafa hilaa isaa keessaa woy dhangala'u nama qulqulluu tokkotti yoo tufe, nami inni itti tufe sun woyaa ifii dhiqatuu ti; nafa ifiille dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_9","004_15_9","LEV","15","9","9","Kooraan nami nafa hilaa isaa keessa woy dhangala'u irra tee'e marti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_10","004_15_10","LEV","15","10","10","Waan nama san jala jiru mara nami tuqe marti haga galgalaatitti battii hin te'a; waan nami sun irra tee'e mara nami fuudhe woyaa ifii dhiqatuu ti; nafa ifiille bisaaniin dhiqatuu ti; Garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_11","004_15_11","LEV","15","11","11","Nami nafa hilaa isaa keessaa woy dhangala'u harkaa ifii adoo hin dhiqatin nama tokko yoo tuqe, nami inni tuqe sun woyaa ifii dhiqatuu ti; nafa ifiille bisaaniin dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_12","004_15_12","LEV","15","12","12","Okkoteen nami nafa hilaa isaa keessaa woy dhangala'u tuqe cadduu ti; meya muka irraa hujame yoo te'e bisaaniin dhiqamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV15_13","004_15_13","LEV","15","13","13","« ‹Nami waan nafa hilaa isaa keessaa dhangala'u irraa yennaa qulqulloome, akka aadaa dhugeeffanna'aatitti guyyaa torba eegatuu ti; woyaa ifii dhiqatee, nafa ifiille bisaan maddaatiin dhiqatuu ti; inni qulqulluu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_14","004_15_14","LEV","15","14","14","Guyyaa saddeeteso'ootitti saphaliisa lama yookiin maddoo lama fidee, seensuma Dunkaanii Woldeenna'aatitti ana Mootii Waan Maraa dura dhufee hayyichatti kennuu ti. ");
INSERT INTO gax_vpl VALUES ("LV15_15","004_15_15","LEV","15","15","15","Hayyichille isaan keessaa takkattii kennansa araara cubbu'uutiif, taan ammoo kennansa gubamuuf dhikeessuu ti; akka kanaan sababa waan nafa hilaa isaa keessaa dhangala'u saniitiif fuula ana Mootii Waan Maraa duratti namicha saniif gumaa tolchuu ti. ");
INSERT INTO gax_vpl VALUES ("LV15_16","004_15_16","LEV","15","16","16","« ‹Nama tokko bisaan sanyi'ii isa keessaa yoo dhangala'e, nafa ifii mara bisaaniin dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_17","004_15_17","LEV","15","17","17","Woyaan yookiin wonni gogaa irraa hujame ta bisaan sanyi'ii tuqe sun marti bisaaniin dhiqantuu ti; garuu haga galgalaatitti battii hin teeti. ");
INSERT INTO gax_vpl VALUES ("LV15_18","004_15_18","LEV","15","18","18","Nami tokko dubartii woliin rafee, bisaan isaa ka sanyii te'u isa keessaa yennaa dhangala'e, isaan lamaanuu nafa ifii bisaaniin dhiqatanuu ti; garuu haga galgalaatitti battii hin te'an. ");
INSERT INTO gax_vpl VALUES ("LV15_19","004_15_19","LEV","15","19","19","« ‹Dubartii takka xuriin yoo dhutte, battummaan isi'ii ta xuri'ii haga guyyaa torbaa hin turti; nami isii tuqelle haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_20","004_15_20","LEV","15","20","20","Yennaa xuriin isi'ii dhutteertu, wonni isiin irra irkatte yookiin irra teette marti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_21","004_15_21","LEV","15","21","21","Nami taqee isi'ii tuqe marti, woyaa ifiitii fi nafa ifii bisaaniin dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_22","004_15_22","LEV","15","22","22","Nami waan isiin irra teete irra te'ee woyaa ifiitii fi nafa ifii bisaaniin dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_23","004_15_23","LEV","15","23","23","Taqee isi'ii yookiin waan isiin irra teette mara nami tuqe haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_24","004_15_24","LEV","15","24","24","Nami tokko isii woliin rafee xuriin isi'ii sun yoo isa tuxxe, inni haga guyyaa torbaa battii hin te'a; taqeen inni irra irkate marti battii hin teeti. ");
INSERT INTO gax_vpl VALUES ("LV15_25","004_15_25","LEV","15","25","25","« ‹Dubartii takka yennaa xuriin isi'ii ta ji'uma ji'aan dhuttu irra dabartee dhiigi isii irraa guyyaa hedduu yoo jige yookiin xuriin isi'ii dabarteen duuba dhiigi isii irraa jigu sun yoo hin lakkisin, akkuma yennaa xurii isi'ii san, haga dhiigi sun dhaabbatu battii hin teeti. ");
INSERT INTO gax_vpl VALUES ("LV15_26","004_15_26","LEV","15","26","26","Akkuma yennaa xuriin isi'ii ji'uma ji'aan dhutteertu sanii, yennaa dhiigi isii irraa jigiisa hin lakkisin mara, taqeen isiin irra irkatte marti yookiin wonni isiin irra teette marti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_27","004_15_27","LEV","15","27","27","Nami waan san tuqe marti battii hin te'a; inni woyaa ifiitii fi nafa ifii bisaaniin dhiqatuu ti; garuu haga galgalaatitti battii hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV15_28","004_15_28","LEV","15","28","28","« ‹Dhiigi isii irraa jigu sun yennaa dhaabbate, guyyaa torba eegattuu ti; saniin duuba akka aadaa dhugeeffanna'aatitti qulqulluu hin teeti. ");
INSERT INTO gax_vpl VALUES ("LV15_29","004_15_29","LEV","15","29","29","Guyyaa saddeetesso'ootitti saphaliisa lama yookiin maddoo lama fiddee seensuma Dunkaanii Woldeenna'aatitti hayyichatti kennituu ti. ");
INSERT INTO gax_vpl VALUES ("LV15_30","004_15_30","LEV","15","30","30","Hayyichi isaan keessaa takkattii kennansa araara cubbu'uutiif, taan kennansa gubamuuf dhikeessuu ti. Akka kanaan battummaa dhiiga isii irraa jigu saniif fuula ana Mootii Waan Maraa duratti gumaa isi'iif hin tolcha. ");
INSERT INTO gax_vpl VALUES ("LV15_31","004_15_31","LEV","15","31","31","« ‹Kolbaan Israa'elii Dunkaanii Woldeenna'aa tiyya ta odduu isaanii jirtu san akka hin batteessine, battummaa ifiille'een akka hin duune, isin waan isaan batteessu irraa adda isaan baasa'a› jedha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV15_32","004_15_32","LEV","15","32","32","Seerri nama nafa hilaa isaa keessaa woy dhangala'uuf yookiin nama bisaan isaa ka sanyii te'u keessaa dhangala'uuf, ");
INSERT INTO gax_vpl VALUES ("LV15_33","004_15_33","LEV","15","33","33","dubartii xuriin isi'ii dhutteertuuf, dhiira yookiin dubartii woy keessaa dhangala'uuf, dhiira dubartii akka aadaa dhugeeffanna'aatitti battootteertu woliin rafuuf kenname kana. ");
INSERT INTO gax_vpl VALUES ("LV16_1","004_16_1","LEV","16","1","1","Ilmaan Aaronii lamaan Mootii Waan Mara dura dhikaatanee du'aneen duuba, Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV16_2","004_16_2","LEV","16","2","2","«Ani qadaaddaa addee gumaan araara cubbu'uu irra keyamu irratti duumensaan waan mudhadhuuf, obboleessi keeti Aaron gara addee irra caalaa woyyitti'ii ta gollaa keessa, qadaaddaa addee gumaan araara cubbu'uu irra keyamu ka Saanduqa Gondooro'oo irra jiru san dura yennaa ifii barbaade mara akka hin seenne itti himi. Inni ajaja kana yoo hin muummessin hin du'a. ");
INSERT INTO gax_vpl VALUES ("LV16_3","004_16_3","LEV","16","3","3","Inni gara addee irraa caalaa woyyitti'ii adoo hin seeniniin dura kennansa araara cubbu'uutiif dardara tokko, kennansa gubamuuf, korbeessa hoole'ee tokko dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_4","004_16_4","LEV","16","4","4","«Inni qoloo haga miilaa dheerattu woyyittii quncee talba'aa irraa hujante lukee nafa isaatitti aantu ta quncee talba'aa irraa hujante woliin uffatuu ti; hiituu quncee talbaa irraa hujante hidhatee, marata mata'aa ka quncee talba'aa irraa hujame mata'atti maratuu ti. Isaan kun uffana woyyoomane waan te'aneef, inni nafa ifii dhiqatee uffatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_5","004_16_5","LEV","16","5","5","Inni korbeeyyii re'e'ee lama kennansa araara cubbu'uutiif, korbeessa hoole'ee tokko kennansa gubamuuf, kolbaa Israa'elii irraa fuudhuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_6","004_16_6","LEV","16","6","6","«Aaronille kennansa araara cubbuu ifiitiif dardara dhikeesse san, ifii fi maatii ifiitiif gumaa cubbu'uu tolchuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_7","004_16_7","LEV","16","7","7","Achiin duuba inni korbeeyyii re'e'ee san lamaanuu fuudhee seensuma Dunkaanii Woldeenna'aatitti fuula ana Mootii Waan Maraa dura dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_8","004_16_8","LEV","16","8","8","Aaron korbeeyyii re'e'ee lamaan san tokko ana Mootii Waan Maraatiif kenniisaaf, kaan gad lakkisiisaaf hixaa buusuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_9","004_16_9","LEV","16","9","9","Inni korbeessa ana Mootii Waan Maraatiif hixaan itti bu'e san fidee kennansa araara cubbu'uutiif ciincessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_10","004_16_10","LEV","16","10","10","Korbeessa cubbuu kolba'aatiif gumaa tolchiisaaf goomole'etti akka gad lakkifamu hixaan itti bu'e san ammoo ana Mootii Waan Maraa dura lubbu'uun dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_11","004_16_11","LEV","16","11","11","«Aaron dardara kennansa araara cubbuu ifiitiif dhikaatu san dhikeessee, ifii fi maatii ifiitiif gumaa tolchiisaaf qaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_12","004_16_12","LEV","16","12","12","Addee ciinca'aa ta fuula kiyya dura jirtu san irraa kashila girigiraa guutu'uu fi hixaana bulleeffame ka uddaa dansaa qabu ooboo lama fuudhee, gara addee irra caalaa woyyitti'ii geessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_13","004_16_13","LEV","16","13","13","Hixaana san ana Mootii Waan Maraa duratti ibiddatti naquu ti. Akka inni hin duuneef, aarri hixaana sanii qadaaddaa addee gumaan araara cubbu'uu irra keyamu ta Saanduqa Gondooro'oo irra jirtu san hin golla. ");
INSERT INTO gax_vpl VALUES ("LV16_14","004_16_14","LEV","16","14","14","Inni dhiiga dardaraa san irraa diqqaa isaa fuudhee quba ifiitiin qadaaddaa gumaa cubbu'uu gubba'atti gara duraatiin itti fiffixuu ti; achiin duuba dhiiga san diqqaa isaa qadaaddaa gumaa cubbu'uu san duratti yennaa torba fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_15","004_16_15","LEV","16","15","15","«Achiin duuba inni korbeessa re'e'ee san araara cubbuu kolba'aatiif qaluu ti; dhiiga isaalle gara addee irra caalaa woyyitti'ii ta gollaa keessaa geessee akkuma dhiiga dardaraa godhe san qadaaddaa gumaan araara cubbu'uu gubba'atti fiffixuu ti; qadaaddaa araara cubbu'uu san duralle'etti fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_16","004_16_16","LEV","16","16","16","Akka kanaan inni sababa battummaa, finqilaa fi cubbuu Israa'elootaa maraatiif addeen irra caalaa woyyitti'ii akka hin battoonne gumaa araara cubbu'uu hin tolcha; Dunkaanii Woldeenna'aa ta odduu isaanii battummaa isaanii wodhakkaa jirtulle akkasuma hin godha. ");
INSERT INTO gax_vpl VALUES ("LV16_17","004_16_17","LEV","16","17","17","Yennaa Aaron addee woyyittii keessatti gumaa cubbu'uu tolchiisaaf, Dunkaanii Woldeenna'aa seenu, haga inni ifiif, maatii ifiitii fi kolbaa Israa'elii duudi'iif gumaa cubbu'uu tolchee gad bayutti, nami tokkolle Dunkaanii Woldeenna'aa keessa hin jiraatin. ");
INSERT INTO gax_vpl VALUES ("LV16_18","004_16_18","LEV","16","18","18","«Achiin duuba inni gara addee ciinca'aa ta fuula kiyya dura jirtuu gad bayee, gumaa cubbu'uu isi'iif tolchuu ti; dhiiga dardaraatii fi korbeessa re'e'ee san irraa diqqaa isaa fuudhee gaafota addee ciinca'aa san mara dibuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_19","004_16_19","LEV","16","19","19","Dhiiga san irraa diqqaa isaa fuudhee quba ifiitiin yennaa torbaa addee ciinca'aa irratti fiffixee, battummaa kolbaa Israa'elii irraa adda baasee, addee ciinca'aa san qulqulleessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_20","004_16_20","LEV","16","20","20","«Aaron addee irra caalaa woyyitti'iif, Dunkaanii Woldeenna'aatiif, addee ciinca'aatiifille gumaa cubbu'uu tolchee fixeen duuba, korbeessa re'e'ee ka lubbu'uun jiru san dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_21","004_16_21","LEV","16","21","21","Inni harka ifii lamaanuu mataa korbeessa re'e'ee ka lubbu'uun jiruu san irra keyee, hammeennaa fi finqila, cubbuu Israa'elootaa mara faaci'ee mataa korbeessa sanii irra keyuu ti. Achiin duuba Aaron korbeessa san gad lakkisee nami hujii tanaaf filame gara lafa goomole'ee geessa. ");
INSERT INTO gax_vpl VALUES ("LV16_22","004_16_22","LEV","16","22","22","Korbeessi sun cubbuu isaanii mara ba'atee gara lafa goomole'ee deema; namichille korbeessa san lafa nami keessa le'uu hin dandeenne goomolee keessatti gad hin lakkisa. ");
INSERT INTO gax_vpl VALUES ("LV16_23","004_16_23","LEV","16","23","23","«Achiin duuba Aaron gara Dunkaanii Woldeenna'aa seenee, woyaa quncee talba'aa irraa hujante ta yennaa addee irra caalaa woyyitti'ii seenu uffatu san ifi irraa baafatee achitti lakkisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_24","004_16_24","LEV","16","24","24","Addee woyyittii sanitti nafa ifii bisaaniin dhiqatee woyaa ifii uffatuu ti. Achiin duuba gad bayee gumaa cubbuu ifii tolchiisaaf kennansa gubamu dhikeessuu ti; kolba'aatiifille gumaa cubbu'uu tolchiisaaf, kennansa gubamu dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_25","004_16_25","LEV","16","25","25","Cooma horii kennansa araara cubbu'uutiif dhikaatee san addee ciinca'aa irratti gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_26","004_16_26","LEV","16","26","26","«Namichi korbeessa re'e'ee san lafa goomole'ee geessee gad lakkise sun woyaa ifiitii fi nafa ifii dhiqateen duuba gara addee quttumaa seenuu hin dande'a. ");
INSERT INTO gax_vpl VALUES ("LV16_27","004_16_27","LEV","16","27","27","Dardarrii fi korbeessi re'e'ee ka kennansa araara cubbu'uutiif dhikaatane, ka dhiigi isaanii gumaa cubbu'uu tolchiisaaf addee irra caalaa woyyitti'ii seene sun, gogaan, foonii fi cumaan isaanii addee quttumaatiin alatti gad baasanee gubanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_28","004_16_28","LEV","16","28","28","Namichi isaan kana gube woyaa ifiitii fi nafa ifii dhiqatuu qaba; achiin duuba gara addee quttumaa seenuu hin dande'a. ");
INSERT INTO gax_vpl VALUES ("LV16_29","004_16_29","LEV","16","29","29","«Seerati bara baraa ka isiniif kenname ka asii gad jiru: ji'a torbeesso'oo guyyaa kudhaneesso'ootitti, Israa'elootii fi nami ormaa ka isaan keessa jiru marti ifi gad qabuu ti; hujii tokkolle hin hujin. ");
INSERT INTO gax_vpl VALUES ("LV16_30","004_16_30","LEV","16","30","30","Guyyaa kanatti isin qulqulleessiisaaf gumaan araara cubbu'uu waan tolfamuuf, isin ana Mootii Waan Maraa duratti cubbuu teessan mara irraa hin qulqulloontan. ");
INSERT INTO gax_vpl VALUES ("LV16_31","004_16_31","LEV","16","31","31","Kun Sanbata guyyaa fooraa ti; ifi gad qaba'a; kun seerata bara baraa ti. ");
INSERT INTO gax_vpl VALUES ("LV16_32","004_16_32","LEV","16","32","32","Hayyichi muudamee addee abbaa ifiititti hayyicha guddaa te'e sun qoloo woyyittii quncee talba'aa irraa hujante uffatee gumaa cubbu'uu tolchuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_33","004_16_33","LEV","16","33","33","Addee irra caalaa woyyittii, Dunkaanii Woldeenna'aa, addee ciinca'aatiif, hayyootaa fi kolbaa maraafille gumaa cubbu'uu tolchuu ti. ");
INSERT INTO gax_vpl VALUES ("LV16_34","004_16_34","LEV","16","34","34","Kun seerata bara baraa ka wogga'atti yennaa tokko cubbuu kolbaa Israa'eliitiif gumaa tolchitanu isiniif te'uu ti» jedhe. Tunille akkuma Mootiin Waan Maraa Muusee ajaje hujante. ");
INSERT INTO gax_vpl VALUES ("LV17_1","004_17_1","LEV","17","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV17_2","004_17_2","LEV","17","2","2","«Ati Aaronii fi ilmaan isaatitti, Israa'eloota maralle'etti, waan ani Mootiin Waan Maraa ajaje kana himi! ");
INSERT INTO gax_vpl VALUES ("LV17_3","004_17_3","LEV","17","3","3","Isaaniin, ‹Israa'elootaa keessaa nami addee quttumaatitti yookiin addee quttumaatiin alatti dardara, buruusoo korbeessa hoole'ee yookiin re'e'ee qalee, ");
INSERT INTO gax_vpl VALUES ("LV17_4","004_17_4","LEV","17","4","4","fuula Dunkaanii Woyyittii tiyyaa duratti ana Mootii Waan Maraatiif kennansa gara seensuma Dunkaanii Woldeenna'aa yoo hin fidin, nami sun yakkaan dhiiga dhangalaasiisaa itti muramuu ti; inni dhiiga waan dhangalaaseef kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("LV17_5","004_17_5","LEV","17","5","5","Tanaaf kolbaan Israa'elii ciincaa diida keessatti Mootii Waan Maraatiif dhikeessite seensuma Dunkaanii Woldeenna'aa duratti gara hayyichaa fiddi; kennansa dhikaate san hayyichi kennansa tokkumma'aa godhee Mootii Waan Maraatiif dhikeessa. ");
INSERT INTO gax_vpl VALUES ("LV17_6","004_17_6","LEV","17","6","6","Hayyichi dhiiga san addee ciinca'aa ta seensuma Dunkaanii Woldeenna'aa duraatitti fiffixuu ti; cooma san ka foolee dansaa qabu, ka Mootii Waan Maraa gammachiisu godhee gubuu ti. ");
INSERT INTO gax_vpl VALUES ("LV17_7","004_17_7","LEV","17","7","7","Haganaa achi kolbaan Israa'elii Mootii Waan Maraatiif addatamuu lakkittee, waaqota dharaa ka fakkii re'e'ee waaqonfatiisaan sagaagaltee, ciincaa hin dhikeessin; kun dhaloota dhufu mara keessatti seerata bara baraa isaaniif te'uu ti› jedhi. ");
INSERT INTO gax_vpl VALUES ("LV17_8","004_17_8","LEV","17","8","8","«Ati isaaniin, ‹Isin Israa'eloota keessaa yookiin nama ormaa ka isin odduu jiru keessaa nami kennansa gubamu yookiin ciincaa dhibii dhikeessu tokko, ");
INSERT INTO gax_vpl VALUES ("LV17_9","004_17_9","LEV","17","9","9","Mootii Waan Maraatiif ciincaa gara seensuma Dunkaanii Woldeenna'aa yoo hin fidin kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("LV17_10","004_17_10","LEV","17","10","10","« ‹Isin Israa'eloota keessaa yookiin orma isin odduu jiru keessaa nami tokko dhiiga yoo une yookiin foon dhiiga qabu yoo nyaate, ani diina itti hin te'a; nama san kolbaa keessaa hin baasa› jedhi. ");
INSERT INTO gax_vpl VALUES ("LV17_11","004_17_11","LEV","17","11","11","Lubbuun dada maraa dhiiga keessa waan jirtuuf, gumaa lubbu'uulle ka te'u dhiiga waan te'eef, addee ciinca'aa irratti gumaa lubbuu teessanii akka te'u ani Mootiin Waan Maraa dhiiga isiniif kenneera. ");
INSERT INTO gax_vpl VALUES ("LV17_12","004_17_12","LEV","17","12","12","Tanaaf ani, ‹Isin kolbaan Israa'elii dhiiga hin unina'a; ormi isin odduu le'ulle dhiiga hin unin› jedhe. ");
INSERT INTO gax_vpl VALUES ("LV17_13","004_17_13","LEV","17","13","13","«Isin Israa'eloota keessaa yookiin orma isin odduu jiru keessaa nami tokko bineensa yookiin sinbirree nyaatamanu mara keessaa adansee yoo qabate dhiiga keessaa jissee biyye'een golluu ti. ");
INSERT INTO gax_vpl VALUES ("LV17_14","004_17_14","LEV","17","14","14","Lubbuun dada maraa dhiiga keessa waan jirtuuf, ani kolbaa Israa'eliitiin, ‹Dhiiga dada maraa hin unina'a; nami dhiiga san unu marti kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("LV17_15","004_17_15","LEV","17","15","15","« ‹Isin Israa'eloota keessa yookiin orma isin odduu jiru keessaa foon waan ifiin du'ee yookiin ka bineensi dhibiin qabee ijjeese nami nyaate, woyaa ifii dhiqatuu ti; nafa ifiille dhiqatuu ti; garuu akka aadaa dhugeeffanna'aatitti haga galgalaa battii hin te'a; achiin duuba inni qulqulluu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV17_16","004_17_16","LEV","17","16","16","Woyaa ifiitii fi nafa ifiille bisaaniin yoo hin dhiqatin yakkaa ifiitiif itti hin gaafatama› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV18_1","004_18_1","LEV","18","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV18_2","004_18_2","LEV","18","2","2","«Kolbaa Israa'eliitiin, ‹Ani Mootii Waan Maraa Waaqa keessan; ");
INSERT INTO gax_vpl VALUES ("LV18_3","004_18_3","LEV","18","3","3","Waan worri biyya Gibxi'ii ta keessa leetane huju hin hujina'a; waan worri lafa kana'aanii ta ani amma itti isin galchu hujanulle hin hujina'a; aadaa isaaniille hin hordofina'a. ");
INSERT INTO gax_vpl VALUES ("LV18_4","004_18_4","LEV","18","4","4","Ani Mootii Waan Maraa Waaqa keessan; seera kiyyaaf ajajama'a; seerata kiyyalle ifi eegadha'aa hordofa'a. ");
INSERT INTO gax_vpl VALUES ("LV18_5","004_18_5","LEV","18","5","5","Ani Mootii Waan Maraa ti; seerataa fi seera kiyya nami eegate lubbu'uun waan jiraatuuf isaan kana eegadha'a. ");
INSERT INTO gax_vpl VALUES ("LV18_6","004_18_6","LEV","18","6","6","« ‹Ani Mootii Waan Maraa ti; eennulle dubartii fira ifii bira geyiisaaf woliin hin rafin. ");
INSERT INTO gax_vpl VALUES ("LV18_7","004_18_7","LEV","18","7","7","Ati haadha teeti woliin rattee bira geettee abbaa keeti hin salphisin; isiin haadha teeti waan teeteef isii bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_8","004_18_8","LEV","18","8","8","Niitii abbaa keetii bira geyiisaan abbaa keeti hin salphisin. ");
INSERT INTO gax_vpl VALUES ("LV18_9","004_18_9","LEV","18","9","9","Obboleettii teeti bira geyiisaaf woliin hin rafin; intala abbaan keeti dubartii dhibii irraa uumate yookiin haati teeti nama dhibi'ii deette bira geyiisaaf woliin hin rafin. ");
INSERT INTO gax_vpl VALUES ("LV18_10","004_18_10","LEV","18","10","10","Ati akka hin salphanneef, intala ilma keetii yookiin intala intala teetii bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_11","004_18_11","LEV","18","11","11","Obboleettii teeti waan teeteef, intala abbaa keetii ta masaanuu haadha teetii bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_12","004_18_12","LEV","18","12","12","Fira abbaa keetii waan teeteef, adaadaa teeti bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_13","004_18_13","LEV","18","13","13","Fira haadha teetii waan teeteef, obboleettii haadha teetii bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_14","004_18_14","LEV","18","14","14","Haadiqqoo teeti waan teeteef, niitii obboleessa abbaa keetii bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_15","004_18_15","LEV","18","15","15","Niitii ilma keetii waan teeteef, niitii ilma keetii bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_16","004_18_16","LEV","18","16","16","Wosoo teeti waan teeteef niitii obboleessa keetii bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_17","004_18_17","LEV","18","17","17","Ati dubartii takka bira yoo geette, fira isi'ii waan te'aneef, intala isi'ii yookiin intala ilma isi'ii yookiin intala intala isi'ii bira hin geyin; tun waan hantu'u. ");
INSERT INTO gax_vpl VALUES ("LV18_18","004_18_18","LEV","18","18","18","Haga niitiin teeti lubbu'uun jirtu obboleettii isi'ii fuutee masaanuu isi'ii hin tolchin; isii biralle hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_19","004_18_19","LEV","18","19","19","« ‹Dubartii xuriin dhuttee battootteertu bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_20","004_18_20","LEV","18","20","20","Niitii nama dhibi'ii bira geettee ifi hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV18_21","004_18_21","LEV","18","21","21","Ani Mootii Waan Maraa ti; ijoollee teeti keessaa tokkolle waaqa dharaa Moleekiif, ciincaa tolchiisaaf dabarsitee kennitee, maqaa Waaqa keetii hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV18_22","004_18_22","LEV","18","22","22","Waan battii waan te'eef, akka dubartii bira geettu dhiira bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_23","004_18_23","LEV","18","23","23","« ‹Waan battii waan te'eef, bineensaa fi horii bira geettee ifi hin batteessin; dubartiille horii bira hin geyin. ");
INSERT INTO gax_vpl VALUES ("LV18_24","004_18_24","LEV","18","24","24","« ‹Isinille waan kana keessaa tokkolle'een ifi hin batteessina'a; kolbaan gosa adda addaa ta ani isin duraa oofee baasu waan kanaan waan battootteertuuf, ");
INSERT INTO gax_vpl VALUES ("LV18_25","004_18_25","LEV","18","25","25","lattille battootte; anille cubbuu isi'iitiif isii adabe; lattille worra isii keessa le'u tutte. ");
INSERT INTO gax_vpl VALUES ("LV18_26","004_18_26","LEV","18","26","26","Isin ammoo seerataa fi seera kiyya eeggadha'a; isin dhalataan biyyaa yookiin nami ormaa ka odduu teessan le'u waan battii tana hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("LV18_27","004_18_27","LEV","18","27","27","Worri isiniin dura lafa san keessa le'u waan battii tana waan hujeef, latti sun battootteerti. ");
INSERT INTO gax_vpl VALUES ("LV18_28","004_18_28","LEV","18","28","28","Latti akkuma gosa biyya adda addaa ta isiniin duraa tutte, yoo isin isii batteessitane, isnille hin tutti. ");
INSERT INTO gax_vpl VALUES ("LV18_29","004_18_29","LEV","18","29","29","Nami waan battii tana huje marti kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("LV18_30","004_18_30","LEV","18","30","30","« ‹Ani Mootii Waan Maraa Waaqa keessan; ajaja kiyya eegadha'a; waan battii worri isiniin dura lafa san keessa le'u huje keessaa waan tokkolle hin hujina'a; hujii tanalle'een ifi hin batteessina'a› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV19_1","004_19_1","LEV","19","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV19_2","004_19_2","LEV","19","2","2","«Kolbaa Israa'elii duudi'iin, ‹Ani Mootiin Waan Maraa Waaqi keessan woyyicha waan te'eef, isinille woyyuu te'a'a. ");
INSERT INTO gax_vpl VALUES ("LV19_3","004_19_3","LEV","19","3","3","Ani Mootii Waan Maraa Waaqa keessan; isin marti abba'aa fi haadha teessaniif ulfinna kenna'a; guyyaa Sanbataa kiyya eeggadha'a. ");
INSERT INTO gax_vpl VALUES ("LV19_4","004_19_4","LEV","19","4","4","« ‹Ani Mootii Waan Maraa Waaqa keessan; isin gara waaqota dharaa hin deebi'ina'a yookiin waan baqisiifamu irraa waaqota dharaa hin hujatina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_5","004_19_5","LEV","19","5","5","« ‹Kennansa tokkumma'aa ana Mootii Waan Maraatiif ciincessiisaaf yennaa dhikeessitanu, akka fudhatama qabaatutti dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("LV19_6","004_19_6","LEV","19","6","6","Ciincaan sun guyyuma isin dhikeessitane san yookiin guyyaa itti aanu nyaatamuu ti; ka irraa hafee haga guyyaa sadii geye gubamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV19_7","004_19_7","LEV","19","7","7","Guyyaa sadeesso'ootitti yoo nyaatane, battii waan te'eef, ciincaan sun fudhatama hin qabu. ");
INSERT INTO gax_vpl VALUES ("LV19_8","004_19_8","LEV","19","8","8","Nami isa nyaate waan Mootii Waan Maraatiif woyyoome waan batteesseef, itti hin gaafatama; nami sun kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("LV19_9","004_19_9","LEV","19","9","9","« ‹Lafa teessan irraa midhaan yennaa galfattanu, midhaan irga ficha'aa jiru hin haammatina'a yookiin woxoo hin qocatina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_10","004_19_10","LEV","19","10","10","Ani Mootii Waan Maraa Waaqa keessan; midhaan woyni'ii yennaa wolitti qabattanu, ka damee irratti hafe yookiin ka lafatti harca'e hiyyeessaa fi nama ormaa ka odduu teessan le'uuf lakkisa'a malee, deebitanee woxoo hin qocatina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_11","004_19_11","LEV","19","11","11","« ‹Hin hatina'a! Dhara hin dubbatina'a! Wol hin sobina'a! ");
INSERT INTO gax_vpl VALUES ("LV19_12","004_19_12","LEV","19","12","12","« ‹Ani Mootii Waan Maraa ti; maqaa kiyyaan dharaan kakatanee, maqaa kiyya hin batteessina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_13","004_19_13","LEV","19","13","13","Nama hin sobina'a yookiin hin saamina'a; mindaa nama qaxartanee adoo hin kaffalin hin bulchina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_14","004_19_14","LEV","19","14","14","Ani Mootii Waan Maraa ti; ana Waaqa keeti sodaadhu malee, nama gurra duuda'aa hin abaarina'a yookiin nama ballaa dura gufuu hin keyina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_15","004_19_15","LEV","19","15","15","« ‹Haqa hin dassina'a; nama maraaf muraa dhuga'aa kenna'a malee, hiyyummaa isaa ilaaltanee hiyyeessaaf hin golina'a; dureessalle durummaa isaatiif ulfinna hin kennina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_16","004_19_16","LEV","19","16","16","« ‹Ani Mootii Waan Maraa ti; kolbaa teessan keessa asii fi achi deemaa hin hamatina'a. Waan lubbuu namaa balleessu tokkolle hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_17","004_19_17","LEV","19","17","17","« ‹Ati gadhaa keeti keessatti obboleessa keeti hin jibbin; Yakkaa isaatiif gorsa isaaf kenni malee, sababa isaatiif yakkaamessa hin te'in. ");
INSERT INTO gax_vpl VALUES ("LV19_18","004_19_18","LEV","19","18","18","Ani Mootii Waan Maraa ti; ati akka ifi jaalattu nama jaaladhu malee, haluu hin bayin, quuqaalle itti hin qabatin. ");
INSERT INTO gax_vpl VALUES ("LV19_19","004_19_19","LEV","19","19","19","« ‹Seera kiyya eegadha'a. Horii gosa gara garaa wol hin dhaggachiisina'a. Sanyii gosa gara garaa lama fichaa tokko keessatti hin facaasina'a. Woyaa waan gosa lamaa irraa dhowante hin uffatina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_20","004_19_20","LEV","19","20","20","« ‹Nami tokko garbittii nama dhibi'iif kadhatante yoo woliin rafe, isiin ta wodante yookiin ta bilisa baate yoo hin te'in, itti gaafatamuu ti! Te'uu malee dubartiin sun waan bilisa hin bayiniif isaan hin ijjeefamanu. ");
INSERT INTO gax_vpl VALUES ("LV19_21","004_19_21","LEV","19","21","21","Namichi garuu kennansa sababa yakka'aatiif dhikaatu korbeessa hoole'ee tokko seensuma Dunkaanii Woldeenna'aa duratti ana Mootii Waan Maraatiif dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV19_22","004_19_22","LEV","19","22","22","Hayyichi ammoo korbeessa hoole'ee kennansa sababa yakka'aatiif dhikaate san cubbuu namichi hujeef, ana Mootii Waan Maraa duratti gumaa tolchuu ti; cubbuu isaatiifille araarri hin kennama. ");
INSERT INTO gax_vpl VALUES ("LV19_23","004_19_23","LEV","19","23","23","« ‹Isin lafa Kana'aaniititti galtanee muka midhaan isaa nyaatanu yennaa dhaabbatane midhaan muka sanii nyaatiis akka dhooggame beeka'a; woggaa sadiif midhaan muka sanii hin nyaatina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_24","004_19_24","LEV","19","24","24","Woggaa arfeesso'ootitti ammoo midhaan muka sanii marti kennansa galataa ka ana Mootii Waan Maraatiif woyyoome hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV19_25","004_19_25","LEV","19","25","25","Ani Mootii Waan Maraa Waaqa keessan; Woggaa shaneesso'ootitti ammoo midhaan muka sanii nyaadha'a; akka kanaan midhaan isin galfattanu isiniif hin misa. ");
INSERT INTO gax_vpl VALUES ("LV19_26","004_19_26","LEV","19","26","26","« ‹Foon dhiigi keessa jiru hin nyaatina'a. Moruu yookiin xanoo hujiisa hin baratina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_27","004_19_27","LEV","19","27","27","« ‹Rifeensa mataa keessanii jala hin quxatina'a, areeda keessanille gabaassitanee hin muratina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_28","004_19_28","LEV","19","28","28","« ‹Ani Mootii Waan Maraa Waaqa keessan; nama du'eef nafa ifi hin ciccirina'a. Nafa keessanille hin naqqafatina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_29","004_19_29","LEV","19","29","29","« ‹Latti gara sagaagalumma'aa akka hin deebine yookiin hammeennaan akka hin guutane, intala teeti hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV19_30","004_19_30","LEV","19","30","30","« ‹Ani Mootii Waan Maraa ti; Sanbata kiyya eeggadha'a; addee woyyittii tiyyaaf ulfinna kenna'a. ");
INSERT INTO gax_vpl VALUES ("LV19_31","004_19_31","LEV","19","31","31","« ‹Ani Mootii Waan Maraa Waaqa keessan; isin akka hin battoonneef gara worra ekeraa dubbisuu hin dhaqina'a yookiin moruu hin barbaadatina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_32","004_19_32","LEV","19","32","32","« ‹Ani Mootii Waan Maraa ti; Waaqa keeti sodaadhu! Nama guddaa duraa ka'i; jaarsaaf ulfinna kenni. ");
INSERT INTO gax_vpl VALUES ("LV19_33","004_19_33","LEV","19","33","33","« ‹Nami ormaa lafa teessan keessa isin woliin yennaa le'u, isa hin cunqursina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_34","004_19_34","LEV","19","34","34","Ani Mootii Waan Maraa Waaqa keessan; nama ormaa ka isin woliin le'u akkuma nama dhalataa biyya keessaniititti ilaala'a; isinille biyya Gibxi'iititti orma teetanee waan turtaneertanuuf, akkuma ifi jaalattanu isa jaaladha'a. ");
INSERT INTO gax_vpl VALUES ("LV19_35","004_19_35","LEV","19","35","35","« ‹Miki'iin, waan ittiin madaaltanuu fi waan ittiin safartanuun nama hin sobina'a. ");
INSERT INTO gax_vpl VALUES ("LV19_36","004_19_36","LEV","19","36","36","Ani Mootii Waan Maraa Waaqa keessan ka biyya Gibxi'ii keessaa isin baase! Mikii, madaallii, waan ittiin safartanuu fi waan dhangala'u waan ittiin safartanu ka sirrii te'etti fayyadama'a. ");
INSERT INTO gax_vpl VALUES ("LV19_37","004_19_37","LEV","19","37","37","« ‹Ani Mootii Waan Maraa ti; seerataa fi seera kiyya mara eeggadha'aatii hordofa'a› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV20_1","004_20_1","LEV","20","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV20_2","004_20_2","LEV","20","2","2","«Kolbaa Israa'eliitiin, ‹Isin keessaa yookiin nama ormaa ka isin woliin le'u keessaa nami tokkolle ilmaan ifii keessaa waaqa dharaa Moleekiif ciincaa yoo dhikeesse ijjeefamuu ti; kolbaan Israa'elii marti dhaka'aan isa tuntuu ti. ");
INSERT INTO gax_vpl VALUES ("LV20_3","004_20_3","LEV","20","3","3","Inni ilmaan ifii keessaa waaqa dharaa Moleekiif kennee, addee woyyittii tiyya batteessee maqaa kiyya woyyichalle waan salphiseef, ani diina itti hin te'a; kolbaa keessalle'ee isa hin baasa. ");
INSERT INTO gax_vpl VALUES ("LV20_4","004_20_4","LEV","20","4","4","Nami sun ilmaan ifii keessaa waaqa dharaa Moleekiif yennaa kennu kolbaan lafa sanii dhaggaa itti lakkittee yoo isa hin ijjeesin, ");
INSERT INTO gax_vpl VALUES ("LV20_5","004_20_5","LEV","20","5","5","ani nama sanii fi maatii isaatitti diina hin te'a; isaa fi worra isa woliin waaqa dharaa Moleek waaqonfatu mara Kolbaa keessaa hin baasa. ");
INSERT INTO gax_vpl VALUES ("LV20_6","004_20_6","LEV","20","6","6","« ‹Nama naaf addatamuu lakkisee, gara worra ekeraa dubbisuutii fi gara worra moruu dhaqee isaan hordofu, ani diina itti hin te'a; kolbaa keessalle'ee isa baasa. ");
INSERT INTO gax_vpl VALUES ("LV20_7","004_20_7","LEV","20","7","7","Ani Mootii Waan Maraa Waaqa keessan waan te'eef, ifi adda baasa'aatii, woyyuu te'a'a. ");
INSERT INTO gax_vpl VALUES ("LV20_8","004_20_8","LEV","20","8","8","Ani Mootii Waan Maraa ka isin woyyoonsu; seerata kiyya eeggadha'aatii, muummessa'a. ");
INSERT INTO gax_vpl VALUES ("LV20_9","004_20_9","LEV","20","9","9","« ‹Nami tokko abbaa ifii yookiin haadha ifii yoo abaare ijjeefamuu ti; abba'aa fi haadha ifii waan abaareef dhiiga ifiitiif isattuu itti gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV20_10","004_20_10","LEV","20","10","10","« ‹Nami tokko niitii nama dhibi'ii yoo gaarayyeeffate, namichi gaarayyeeffatee fi namittiin inni gaarayyeeffate sun isaan lamaanuu ijjeefamanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV20_11","004_20_11","LEV","20","11","11","Nami tokko niitii abbaa ifii woliin yoo rafe, abbaa ifii waan salphiseef innii fi isiille lamaanuu ijjeefamanuu ti; dhiiga ifiitiif isaanumatti itti gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV20_12","004_20_12","LEV","20","12","12","Nami tokko niitii ilma ifii woliin yoo rafe, kobaa waan te'eef, isaan lamaanuu ijjeefamanuu ti; dhiiga isaaniitiif isaanumatti itti gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV20_13","004_20_13","LEV","20","13","13","Nami tokko akkuma dubartii woliin rafu dhiira yoo damaame isaan lamaanuu waan battii waan hujaneef ijjeefamanuu ti; dhiiga isaaniitiif isaanumatti itti gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV20_14","004_20_14","LEV","20","14","14","Nami tokko dubartii takka fuudhee, haadha isi'iille yoo fuudhe, tun waan batti'i. Battummaan akkasii odduu teessan akka hin jiraanne, isaa fi isaan lamaanuu ibiddaan gubamanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV20_15","004_20_15","LEV","20","15","15","Nami tokko horii bira yoo geye, ijjeefamuu ti; horii sanille ijjeesa'a. ");
INSERT INTO gax_vpl VALUES ("LV20_16","004_20_16","LEV","20","16","16","Dubartiin takka horii woliin yoo ratte, isi'ii fi horii sanille ijjeesa'a; dhiiga isaaniitiif isaanumatti itti gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV20_17","004_20_17","LEV","20","17","17","« ‹Nami tokko obboleettii ifii yookiin intala abbaan isaa dubartii dhibii irraa uumate yookiin intala haati isaa abbaa dhibi'iif deette yoo fuudhe, battii waan teeteef, kolbaa ifii keessaa bayanuu ti; obboleettii ifii waan salphiseef itti hin gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV20_18","004_20_18","LEV","20","18","18","Nami tokko dubartii xuriin dhutteertu yoo bira geye, xurii isi'ii waan saaxileef, isiille xurii ifii waan saaxilteef, isaan lamaanuu kolbaa ifii keessaa bayanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV20_19","004_20_19","LEV","20","19","19","« ‹Obboleettii haadha teetii yookiin adaadaa teeti bira hin geyin; tun fira ifii salphisuu waan teeteef isaan lamaanuu itti hin gaafataman. ");
INSERT INTO gax_vpl VALUES ("LV20_20","004_20_20","LEV","20","20","20","Nami tokko niitii obboleessa abbaa ifii bira yoo geye, inni abbaa diqqaa ifii waan salphiseef, isaan lamaanuu itti hin gaafataman; ijoollee maleelle hin du'an. ");
INSERT INTO gax_vpl VALUES ("LV20_21","004_20_21","LEV","20","21","21","Nami tokko niitii obboleessa ifii yoo fuudhe, tun hujii batti'i; obboleessa ifii waan salphiseef isaan lamaanuu ijoollee malee hin hafan. ");
INSERT INTO gax_vpl VALUES ("LV20_22","004_20_22","LEV","20","22","22","« ‹Latti kana'aanii akka isin keessa leetanu ta ani isin itti galchu sun akka isin hin tunne, seerataa fi seera kiyya mara eegadha'aatii muummessa'a. ");
INSERT INTO gax_vpl VALUES ("LV20_23","004_20_23","LEV","20","23","23","Isin akka aadaa kolbaa gosa adda addaa ta ani isin duraa ari'ee baasaaru san hin le'ina'a; isaan waan kana waan hujaneef, ani isaan diqadheera. ");
INSERT INTO gax_vpl VALUES ("LV20_24","004_20_24","LEV","20","24","24","Isin ammoo lafa isaanii hin boojitan; lafa aananii fi dammaa san ani isiniif hin kenna. Ani Mootii Waan Maraa Waaqa keessan ka gosa biyya adda addaa keessaa adda isin baase. ");
INSERT INTO gax_vpl VALUES ("LV20_25","004_20_25","LEV","20","25","25","Tanaaf horii, bineensotaa fi allaatota qulqulluu te'anee fi qulqulluu hin te'in gargar baasa'a; isin horii, bineensotaa fi allaatota yookiin waan lafa irra munyuuqu mara keessaa ta ani akka batti'iititti adda baase saniin ifi hin batteessina'a. ");
INSERT INTO gax_vpl VALUES ("LV20_26","004_20_26","LEV","20","26","26","Ani Mootiin Waan Maraa woyyicha waan te'eef, isin kiyya akka teetanu gosa biyya adda addaa keessaa waan isin adda baaseef, isinille naaf woyyuu te'a'a. ");
INSERT INTO gax_vpl VALUES ("LV20_27","004_20_27","LEV","20","27","27","« ‹Isin keessa dhiirti yookiin dubartiin ekeraa dubbisanu yookiin moruu moranu ijjeefamanuu ti; dhaka'aan tumamanuu ti; dhiiga ifiitiif isaanumatti itti gaafatama› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV21_1","004_21_1","LEV","21","1","1","Mootiin Waan Maraa Muuse'een, «Ati ilmaan Aaronii hayyootaan, ‹Mootiin Waan Maraa: Hayyichi tokko reeffa nama ifii tuqiisaan akka aadaa dhugeeffanna'aatitti ifi hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV21_2","004_21_2","LEV","21","2","2","Te'uu malee fira ifii ka dhiko'oo abbaa yookiin haadha ifii, ilma ifii yookiin intala ifii, obboleessa ifii ");
INSERT INTO gax_vpl VALUES ("LV21_3","004_21_3","LEV","21","3","3","yookiin obboleettii ifii ta hin heerumin reeffa isaanii tuqiisaan ifi batteessuu hin dande'a. ");
INSERT INTO gax_vpl VALUES ("LV21_4","004_21_4","LEV","21","4","4","Worra fuudhaa fi heerumaan isa woliin firoome reeffa isaanii tuqiisaan ifi hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV21_5","004_21_5","LEV","21","5","5","« ‹Hayyooti mataa ifii hin haadatin yookiin areeda ifii cinaa hin haadatin yookiin nafa ifiille hin mummurin. ");
INSERT INTO gax_vpl VALUES ("LV21_6","004_21_6","LEV","21","6","6","Isaan kennansa ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu, sagalee ana Waaqa isaaniitiif dhikaattu hayyoota dhikeessanu waan te'aneef, woyyoomanuu ti; isaan ana Waaqa ifiitiif woyyoomanuu ti malee, maqaa kiyya hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV21_7","004_21_7","LEV","21","7","7","Isaan hayyoota ana Waaqaaf woyyoomane waan te'aneef, dubartii sagaagaltee battootte yookiin dubartii abbaan manaa lakkise hin fuudhin. ");
INSERT INTO gax_vpl VALUES ("LV21_8","004_21_8","LEV","21","8","8","Isaan worra ana Waaqa keetiif sagalee dhikeessanu waan te'aneef, ati isaan akka woyyuu te'anetti laakkow; ani Mootiin Waan Maraa ka isin woyyoonsu woyyuu waan te'eef, isaan woyyoota isiniif te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("LV21_9","004_21_9","LEV","21","9","9","Intalti hayyichaa takka sagaagaltee yoo ifi batteessite, abbaa ifii waan salphitteef ibiddaan gubantuu ti. ");
INSERT INTO gax_vpl VALUES ("LV21_10","004_21_10","LEV","21","10","10","« ‹Hayyichi guddaan ka obboleeyyan ifii keessaa zayitii muudaa mataa isaatitti naqane, ka woyaa hayyumma'aa akka uffatuufille muudame gadda mudhisiisaaf, rifeensa mataa ifii filatiisa hin lakkisin; woyaa ifiille hin tarsaasin. ");
INSERT INTO gax_vpl VALUES ("LV21_11","004_21_11","LEV","21","11","11","Inni addee reeffi jiru hin seenin; addee reeffi abbaa isaa yookiin haadha isaa jiru te'ulle achi seenee ifi hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV21_12","004_21_12","LEV","21","12","12","Ani Mootii Waan Maraa ti; zayitiin muudaa ta ana Waaqa isaa ta inni ittiin woyyoome isa irra waan jirtuuf, addee woyyittii keessaa gad bayee, addee woyyittii ana Waaqa isaa hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV21_13","004_21_13","LEV","21","13","13","« ‹Intalti inni fuudhu ta bantii qaddu teetuu ti; ");
INSERT INTO gax_vpl VALUES ("LV21_14","004_21_14","LEV","21","14","14","Inni gosa ifii keessaa intala bantii qaddu fuudhuutii malee, haadha hiyyeessaa, dubartii abbaan manaa lakkise yookiin dubartii sagaagaliisaan battootte hin fuudhin. ");
INSERT INTO gax_vpl VALUES ("LV21_15","004_21_15","LEV","21","15","15","Ani Mootii Waan Maraa ka isa woyyoonsu waan te'eef, inni kolbaa ifii keessatti sanyii ifii hin batteessin jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV21_16","004_21_16","LEV","21","16","16","Ammalle Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV21_17","004_21_17","LEV","21","17","17","«Ati Aaroniin, ‹Mootiin Waan Maraa: Dhalootaa haga dhalootaatitti sanyii teeti keessaa nami fafa qabu kennansa sagale'ee ana Waaqa ifiitiif dhikeessiisaaf hin dhufin. ");
INSERT INTO gax_vpl VALUES ("LV21_18","004_21_18","LEV","21","18","18","Nami fafa qabu hin dhikaatin. Ballaan yookiin naafi, nami fuula farqu'uu, farri, ");
INSERT INTO gax_vpl VALUES ("LV21_19","004_21_19","LEV","21","19","19","nami harka yookiin miila caba'aa, ");
INSERT INTO gax_vpl VALUES ("LV21_20","004_21_20","LEV","21","20","20","nami xukkeeru yookiin nami qancaraan, nami fafa ilaa qabu yookiin nami dhukkuba goga'aa qabu yookiin nami midhattii tumameeru kennansa sagale'ee hin dhikeessin. ");
INSERT INTO gax_vpl VALUES ("LV21_21","004_21_21","LEV","21","21","21","Sanyii Aaronii hayyichaa keessaa nami fafa qabu kennansa ibiddaan gubamu ana Mootii Waan Maraatiif hin dhikeessin. Inni fafa waan qabuuf, sagalee ana Waaqa ifii dhikeessiisaaf hin dhufin. ");
INSERT INTO gax_vpl VALUES ("LV21_22","004_21_22","LEV","21","22","22","Nami akkasii sagalee irra caalaa ana Waaqa isaatiif woyyuu teete keessaa tokko teete waan teeteef, sagalee woyyittii san nyaatuu hin dande'a. ");
INSERT INTO gax_vpl VALUES ("LV21_23","004_21_23","LEV","21","23","23","Te'uu malee sababa fafa isaatiif, inni addee woyyittii tiyya akka hin batteessine, gara golla'aa hin dhikaatin yookiin gara addee ciinca'aa hin dhikaatin; ka isaan woyyoonsu ana Mootii Waan Maraa ti jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV21_24","004_21_24","LEV","21","24","24","Maarre Muuseen waan kana Aaronitti, ilmaan isaatii fi kolbaa israa'elii maratti hime. ");
INSERT INTO gax_vpl VALUES ("LV22_1","004_22_1","LEV","22","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV22_2","004_22_2","LEV","22","2","2","«Ani Mootii Waan Maraa ti; Aaronii fi ilmaan isaa maqaa kiyya akka hin batteessine, kennansa woyyicha ka kolbaan Israa'elii naaf adda baasane, ulfinnaan akka eeganu itti himi. ");
INSERT INTO gax_vpl VALUES ("LV22_3","004_22_3","LEV","22","3","3","Isaaniin, ‹Ani Mootii Waan Maraa ti: Dhalootaa haga dhalootaatitti, sanyii teeti keessaa nami tokko akka aadaa dhugeeffanna'aatitti adoo hin qulqulloomin, kennansa woyyicha kolbaan Israa'elii ana Mootii Waan Maraatiif adda baasanetti yoo dhikaate, nami sun fuula kiyya duraa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("LV22_4","004_22_4","LEV","22","4","4","« ‹Sanyii Aaronii keessa nami dhukkuba goga'aa farrisiisaa qabu yookiin nami nafa hilaa isaa keessaa woy dhangala'u haga qulqulloomutti kennansa woyyicha san hin nyaatin. Nami waan reeffa tuqee battowe tuqe yookiin nami nafa hilaa isaa keessaa bisaan sanyii te'u dhangala'u, ");
INSERT INTO gax_vpl VALUES ("LV22_5","004_22_5","LEV","22","5","5","yookiin bineensota gadha'aan lafa irra lowanu ka isa batteessu yoo tuqe yookiin nama isa batteessu yoo tuqe, battummaan isaa tamiiyyuu teetulle, ");
INSERT INTO gax_vpl VALUES ("LV22_6","004_22_6","LEV","22","6","6","hayyichi waan akkasii kana tuqe haga galgalaatitti battii hin te'a; nafa ifii bisaaniin haga dhiqatutti sagalee woyyittii san hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("LV22_7","004_22_7","LEV","22","7","7","Yennaa aduun seentu inni qulqulluu hin te'a; achiin duuba sagalee isaa waan teeteef, sagalee woyyittii san nyaatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV22_8","004_22_8","LEV","22","8","8","Ani Mootii Waan Maraa ti; inni akka hin battoonneef, foon waan ifiin du'ee yookiin ka bineensi dhibiin qabee ijjeese hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("LV22_9","004_22_9","LEV","22","9","9","« ‹Ani Mootii Waan Maraa ka isaan woyyoonsu; hayyooti ajaja kiyya tuffatanee yakkaameyyii akka hin teene, yookiin akka hin duune, ajaja kiyya eegatanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV22_10","004_22_10","LEV","22","10","10","« ‹Maatii hayyichaa malee, keessummaan hayyichaa yookiin hojjataan isaaf qaxaramee huju sagalee woyyittii tana hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("LV22_11","004_22_11","LEV","22","11","11","Garbichi hayyichi beesee ifiitiin bitate yookiin ka mana isaatitti dhalate ammoo sagalee qooda hayyichaa san nyaatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV22_12","004_22_12","LEV","22","12","12","Intalti hayyichaa takka nama sanyii hayyichaa hin te'in yoo heerumte, sagalee woyyittii tana hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("LV22_13","004_22_13","LEV","22","13","13","Garuu intalti hayyichaa ijoollee adoo hin deyin dhirsi isi'ii yoo isii lakkise yookiin yoo du'e, isiin akkuma yennaa ijoollummaa ifii gara mana abbaa ifii yoo deebite, sagalee qooda abbaa ifii san nyaatuu hin dandeetti. Te'uu malee nami maatii hayyichaa hin te'in, sagalee san hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("LV22_14","004_22_14","LEV","22","14","14","« ‹Nami maatii hayyichaa hin te'in tokko, adoo hin beekin sagalee woyyittii san yoo nyaate, gatii waan nyaatee san harka shan keessaa harka tokko itti dabalee hayyichaaf deebisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV22_15","004_22_15","LEV","22","15","15","Hayyooti sagalee woyyittii ta kolbaan Israa'elii ana Mootii Waan Maraatiif dhikeessite san hin batteessin. ");
INSERT INTO gax_vpl VALUES ("LV22_16","004_22_16","LEV","22","16","16","Ani Mootii Waan Maraa ka isaan woyyoonsu; nami sagalee woyyittii tana nyaatee yakkaa isa adabissiittu akka huju hin godhina'a jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV22_17","004_22_17","LEV","22","17","17","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV22_18","004_22_18","LEV","22","18","18","«Ati Aaroniin, ilmaa isaatii fi kolbaa Israa'elii maraan, ‹Mootiin Waan Maraa: Nama Israa'elii yookiin nama ormaa ka Israa'el keessa le'u keessaa, nami tokko waadaa gale yookiin kennansa gubamu fedhii ifiitiin ana Mootii Waan Maraatiif yoo dhikeesse, ");
INSERT INTO gax_vpl VALUES ("LV22_19","004_22_19","LEV","22","19","19","horiin inni dhikeesse sun fudhatama akka qabaatu korma loonii, korbeessa hoole'ee yookiin re'e'ee ka fafa hin qanne te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV22_20","004_22_20","LEV","22","20","20","Horiin fafa qabu fudhatama waan hin qabaanneef, waan fafa qabu tokkolle hin dhikeessina'a. ");
INSERT INTO gax_vpl VALUES ("LV22_21","004_22_21","LEV","22","21","21","Nami tokko waadaa gale muummessiisaaf yookiin kennansa fedhii ifii kenniisaaf, loon keessaa yookiin hoole'ee fi re'ee keessaa kennansa tokkumma'aa ana Mootii Waan Maraatiif yennaa dhikeessu fudhatama akka qabaatuuf, ka fafa hin qannee fi komii hin qanne te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV22_22","004_22_22","LEV","22","22","22","Horii ballaa yookiin cabaa yookiin horii fafa qabu yookiin ka robbii qabu yookiin horii madaan isaa malaa qabu yookiin dhukkuba goga'aa qabu ana Mootii Waan Maraatiif kennansa hin dhikeessina'a; horii akkasii addee ciinca'aa irratti kennansa ibiddaan gubamu ana Mootii Waan Maraatiif hin dhikeessina'a. ");
INSERT INTO gax_vpl VALUES ("LV22_23","004_22_23","LEV","22","23","23","Korma yookiin hoolee ka harki yookiin luki isaanii akka malee dheeratanu yookiin gabaabbatanu kennansa fedhii teessanii gootanee dhikeessuu hin dandeettan; kennansa waadaa galameef ammoo fudhatama hin qabu. ");
INSERT INTO gax_vpl VALUES ("LV22_24","004_22_24","LEV","22","24","24","Horii midhattiin isaa kolaafame yookiin tumame yookiin baqaffame yookiin murame ana Mootii Waan Maraatiif kennansa hin dhikeessina'a. Lafa teessan keessatti horii akkasii kennansa hin dhikeessina'a. ");
INSERT INTO gax_vpl VALUES ("LV22_25","004_22_25","LEV","22","25","25","« ‹Horii akkasii orma irraa fuutanee sagalee ana Waaqa keessanii gootanee hin dhikeessina'a. Horiin akkasii fafa yookiin komii waan qabuuf fudhatama hin qabu jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV22_26","004_22_26","LEV","22","26","26","Mootiin Waan Maraa ammalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV22_27","004_22_27","LEV","22","27","27","«Jabbiin, ilmooleen hoole'ee yookiin re'e'ee yoo dhalatane guyyaa torba haadha ifii bira turanuu ti; guyyaa saddeetesso'ootiin jalqabee kennansa ana Mootii Waan Maraatiif ibiddaan gubamuuf fudhatama qaban. ");
INSERT INTO gax_vpl VALUES ("LV22_28","004_22_28","LEV","22","28","28","Sa'a waatii isaa woliin yookiin hoolee ilmee isi'ii woliin guyyuma tokko hin qalina'a. ");
INSERT INTO gax_vpl VALUES ("LV22_29","004_22_29","LEV","22","29","29","Kennansa galataa ana Mootii Waan Maraatiif yennaa dhikeessitanu akka isiniif fudhatama qabaatu akkasitti dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("LV22_30","004_22_30","LEV","22","30","30","Ani Mootii Waan Maraa ti; kennansa san guyyuma dhikaate san nyaadha'a malee, tokkolle boruuf hin hamburatina'a. ");
INSERT INTO gax_vpl VALUES ("LV22_31","004_22_31","LEV","22","31","31","«Ani Mootii Waan Maraa ti; ajaja kiyya eegadha'a; muummessaalle'e. ");
INSERT INTO gax_vpl VALUES ("LV22_32","004_22_32","LEV","22","32","32","Ani Mootii Waan Maraa ka isin woyyoonsu; Kolbaa Israa'elii maratti ani woyyicha akka te'e beekkamuu qaba. Maqaa kiyya woyyicha hin batteessina'a. ");
INSERT INTO gax_vpl VALUES ("LV22_33","004_22_33","LEV","22","33","33","Ani Mootii Waan Maraa ti; Waaqa isiniif te'iisaaf biyya Gibxi'ii keessaa ka isin baase ana» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV23_1","004_23_1","LEV","23","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV23_2","004_23_2","LEV","23","2","2","«Ati kolbaa Israa'eliitiin, ‹Mootiin Waan Maraa: jilti ana Mootii Waan Maraatiif filante, ta yaa'ii woyyittii isin itti lassitanu ta asii gad jirtu; ");
INSERT INTO gax_vpl VALUES ("LV23_3","004_23_3","LEV","23","3","3","« ‹Guyyooti jaa ka isin hujii hujjanu; guyyaan torbeesso'oo ammoo Sanbata fooraa, guyyaa yaa'ii ana Mootii Waan Maraatiif woyyoome; guyyaa sanbataa ka ana Mootii Waan Maraatiif woyyoome waan te'eef, addee leetanu maratti hujii hin hujina'a› jedha» jedhiin. ");
INSERT INTO gax_vpl VALUES ("LV23_4","004_23_4","LEV","23","4","4","Itti dabalee, «Yennaan jilaa ta ana Mootiin Waan Maraatiif filante, ta yaa'ii woyyittii isin itti lassitanu: ");
INSERT INTO gax_vpl VALUES ("LV23_5","004_23_5","LEV","23","5","5","Jilti irra dabaramaa, ta Mootii Waan Maraa, ji'a tokkeesso'oo guyyaa kudhanii afurfeesso'ootitti galgala dimimmisa jilifanti. ");
INSERT INTO gax_vpl VALUES ("LV23_6","004_23_6","LEV","23","6","6","Jilti irra dabaramaa ta Mootii Waan Maraa ta daabboo uukoo hin qannee guyyaa kudhanii shaneesso'ootitti jalqabanti. Guyyaa torba daabboo uukoo hin qanne nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("LV23_7","004_23_7","LEV","23","7","7","Guyyoota kana keessaa guyyaa tokkeesso'oo yaa'ii woyyittii godhadha'a; ijjumaa hujii hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("LV23_8","004_23_8","LEV","23","8","8","Guyyaa torba kennansa ibiddaan gubamu ana Mootii Waan Maraatiif dhikeessa'a; guyyaa torbeesso'oo yaa'ii woyyittii godhadha'a malee, ijjumaa hujii hin hujina'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV23_9","004_23_9","LEV","23","9","9","Ammalle Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV23_10","004_23_10","LEV","23","10","10","«Ati kolbaa Israa'eliitiin, ‹Mootiin Waan Maraa: Lafa ani isiniif kennu sanitti galtanee midhaan yennaa galfattanu laddee matoomaa hayyichaaf kenna'a. ");
INSERT INTO gax_vpl VALUES ("LV23_11","004_23_11","LEV","23","11","11","Laddeen sun akka isiniif fudhatama qabaattu, hayyichi ana Mootii Waan Maraa duratti tachoosee kennansa tachoofamu dhikeessuu ti. Hayyichi laddee san guyyaa Sanbatatti aanu dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_12","004_23_12","LEV","23","12","12","Guyyaa laddee san kennansa tachoofamu dhikeessitanu, buruusoo korbeessa hoole'ee ka fafa hin qannee fi ka woggaa tokkoo kennansa gubamu, ana Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("LV23_13","004_23_13","LEV","23","13","13","Bullaa dansaalle kiiloogiraama lama ta zayitii ejersaa gara litirii tokkootiin sukkuumante ta foolee dansaa qaddu ta ana Mootii Waan Maraa gammachiittu, daadhii woyni'iille litirii tokko woliin dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("LV23_14","004_23_14","LEV","23","14","14","Kennansa kana ana Waaqa keessaniif haga dhikeessitanutti, shawwee midhaan kanaa, akum'ee yookiin daabboo isaa hujjanee hin nyaatina'a. Seerri kun addee leetanu maratti dhaloota dhufu maraaf seerata haga bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_15","004_23_15","LEV","23","15","15","« ‹Guyyaa Sanbatatti aanu, guyyaa laddee matoomaa kennansa tachoofamu dhikeessitaneen jalqaba'aatii torbaan yennaa torba laakkowa'a! ");
INSERT INTO gax_vpl VALUES ("LV23_16","004_23_16","LEV","23","16","16","Sanbata torbeesso'ootiin duuba guyyaa shantameesso'oo ammalle midhaan barano'oo irraa ana Mootii Waan Maraatiif kennansa dhikeessa'a! ");
INSERT INTO gax_vpl VALUES ("LV23_17","004_23_17","LEV","23","17","17","Addee leetanu mara keessaa daabboo xaltaa lama lama ta bullaa dansaa kiiloogiraama lama irraa hujante ta uukoo qaddu, midhaan qara bilchaate irraa kennansa tachoofamu ana Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("LV23_18","004_23_18","LEV","23","18","18","Kennansa daabbo'oo kana woliin buruusoo korbeeyyii hoole'ee torba ta woggaa tokko tokkoo ta fafa hin qanne, dardara tokkoo fi korbeeyyii hoole'ee lama kennansa gubamu ana Mootii Waan Maraatiif dhikeessa'a! Kun kennansa midhaaniitii fi kennansa daadhii woyni'ii woliin kennansa ibiddaan gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisuu te'anee dhikeeffamanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_19","004_23_19","LEV","23","19","19","Achiin duuba korbeessa re'e'ee tokko ciincaa araara cubbu'uutiif, buruusoo korbeeyyii hoole'ee lama ta woggaa tokko tokkoo kennansa tokkumma'aatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("LV23_20","004_23_20","LEV","23","20","20","Hayyichi daabboo midhaan qara bilchaatee san buruusoo korbeeyyii hoole'ee lamaan san woliin kennansa tachoofamu ana Mootii Waan Maraatiif dhikeessuu ti; isaan kun kennansa Mootii Waan Maraatiif woyyoome qooda hayyichaa ti. ");
INSERT INTO gax_vpl VALUES ("LV23_21","004_23_21","LEV","23","21","21","Guyyaa san wol geyii woyyittii lassa'a malee hujii ijjumaa hin hujina'a! Kun addee leetanu maratti dhaloota dhufu maraaf, seerata haga bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_22","004_23_22","LEV","23","22","22","« ‹Ani Mootii Waan Maraa Waaqa keessan; midhaan lafa teessanii yennaa galfattanu haga fichaa qarqaraatitti hin haammatina'a; woxoo midhaan galfattanu sanii hiyyeessaa fi alaga'aaf lakkisa'a› jedha» jedhiin. ");
INSERT INTO gax_vpl VALUES ("LV23_23","004_23_23","LEV","23","23","23","Ammalle Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV23_24","004_23_24","LEV","23","24","24","«Ati kolbaa Israa'eliitiin, ‹Mootiin Waan Maraa: Ji'a torbeesso'oo guyyaan jalqabaa guyyaa fooraa ti. Guyyaa yaadanno'oo lassiisaaf tultullaa afuufa'a; isin yaa'ii woyyittii qabaatuu qaddan. ");
INSERT INTO gax_vpl VALUES ("LV23_25","004_23_25","LEV","23","25","25","Guyyaa san kennansa ibiddaan gubamu ana Mootii Waan Maraatiif dhikeessa'a malee ijjumaa hujii hin hujina'a› jedha» jedhiin. ");
INSERT INTO gax_vpl VALUES ("LV23_26","004_23_26","LEV","23","26","26","Mootiin Waan Maraa ammalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV23_27","004_23_27","LEV","23","27","27","«Ji'a torbeesso'oo kanatti guyyaan kudhaneesso'oo, guyyaa gumaan cubbu'uu tolfamu te'uu ti. Guyyaa kana ifi gad qaba'a; yaa'ii woyyittii godhadha'a; kennansa ibiddaan gubamulle Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("LV23_28","004_23_28","LEV","23","28","28","Guyyaa gumaa cubbu'uu ka ana Mootii Waan Maraa Waaqa keessan duratti, gumaan cubbu'uu isiniif tolfamu waan te'eef, ijjumaa hujii hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("LV23_29","004_23_29","LEV","23","29","29","Nami guyyaa san gad ifi hin qanne kolbaa ifii keessaa bayuu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_30","004_23_30","LEV","23","30","30","Nama guyyaa san hujii huju mara ani kolbaa isaa keessaa hin balleessa. ");
INSERT INTO gax_vpl VALUES ("LV23_31","004_23_31","LEV","23","31","31","Tanaaf guyyaa san ijjumaa hujii hin hujina'a; kun addee leetanu maratti dhaloota dhufu maraaf seerata haga bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_32","004_23_32","LEV","23","32","32","Kun guyyaa Sanbataa ka itti foorfattanu isiniif te'uu ti; gad ifi qaba'aatii, ji'a san keessa galgala guyyaa sagaleesso'ootii jalqaba'aa, haga galgala guyyaa itti aanuutitti Sanbata ulfeessa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV23_33","004_23_33","LEV","23","33","33","Ammalle Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV23_34","004_23_34","LEV","23","34","34","«Ati kolbaa Israa'eliitiin, ‹Mootiin Maraa: Ji'a torbeesso'oo guyyaa kudhanii shaneesso'ootitti jilti gose'ee ana Mootii Waan Maraatiif jalqabantee, haga guyyaa torbaa turtuu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_35","004_23_35","LEV","23","35","35","Guyyaan jalqabaa guyyaa yaa'ii woyyitti'ii ti; hujii ijjumaa hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("LV23_36","004_23_36","LEV","23","36","36","Guyyaa torbaanuu kennansa ibiddaan gubamu ana Mootii Waan Maraatiif dhikeessa'a. Guyyaa saddeetesso'oo yaa'ii woyyittii godhadha'aatii kennansa ibiddaan gubamu ana Mootii Waan Maraatiif dhikeessa'a; guyyaan sun guyyaa yaa'ii muummessitanu waan te'eef ijjumaa hujii hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("LV23_37","004_23_37","LEV","23","37","37","« ‹Guyyooti jilaa ka ana Mootii Waan Maraatiif filamane, ka isin kennansa gubamu, kennansa midhaanii, ciinca'aa fi kennansa daadhii woyni'ii guyyaa isaaniif murteeffametti ana Mootii Waan Maraatiif ibiddaan dhikeessiisaaf, yaa'ii woyyittii itti lassitanu isaan kana. ");
INSERT INTO gax_vpl VALUES ("LV23_38","004_23_38","LEV","23","38","38","Kennansi asii olii kun marti guyyaa Sanbata kiyyaa, guyyoota kennansa keessan ka adda addaa, kennansa waadaa galtanee fi kennansa fedhii teessanii ana Mootii Waan Maraatiif dhikeessitanu irratti ka dabalamee dhikaatu. ");
INSERT INTO gax_vpl VALUES ("LV23_39","004_23_39","LEV","23","39","39","« ‹Ji'a torbeesso'oo, guyyaa kudhanii shaneesso'ootitti, Midhaan keessan fichaa irraa galfattaneen duuba, guyyaa torba ana Mootii Waan Maraatiif jila tana jilifadha'a. Guyyaan jalqabaa guyyaa fooraa te'uu ti; guyyaan saddeetesso'oolle guyyaa fooraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_40","004_23_40","LEV","23","40","40","Guyyaa jalqabaa sanitti, midhaan dadansaa, baala meexxi'ii, damee baala qadduu fi muka laga qarqaratti latu qabadha'aatii guyyaa torba ana Mootii Waan Maraa Waaqa keessan duratti firinxiixa'a. ");
INSERT INTO gax_vpl VALUES ("LV23_41","004_23_41","LEV","23","41","41","Jila tana wogguma wogga'atti ji'a torbeesso'oo keessa guyyaa torba ana Mootii Waan Maraatiif jila jilifadha'a; kun dhaloota dhufu maraaf seerata haga bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_42","004_23_42","LEV","23","42","42","Guyyaa torba gosee keessa tee'a'a; nami dhalootaan Israa'el te'e marti gosee keessa turuu ti. ");
INSERT INTO gax_vpl VALUES ("LV23_43","004_23_43","LEV","23","43","43","Ani Mootii Waan Maraa Waaqa keessan; ani kolbaa Israa'elii biyya Gibxi'ii keessaa yennaa baase gosee keessa akka le'anu akka isaan tolche dhalooti keessan tanaan beekan jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV23_44","004_23_44","LEV","23","44","44","Maarre Muuseen akka kanaan guyyoota jila Mootii Waan Maraatiif filamane kolbaa Israa'eliititti beessise. ");
INSERT INTO gax_vpl VALUES ("LV24_1","004_24_1","LEV","24","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV24_2","004_24_2","LEV","24","2","2","«Ifi yennaa mara akka ifu, Israa'elooti zayitii qulluu muka ejersaa irraa cunfantee dhimbiibante akka sii fiddu ajaji! ");
INSERT INTO gax_vpl VALUES ("LV24_3","004_24_3","LEV","24","3","3","Aaron Dunkaanii Woldeenna'aa keessatti, gollaa dhugaa bayaatiin alatti, galgalaa haga ganamaatitti, ifa yennaa mara ana Mootii Waan Maraa duratti tarree galchuu ti; kun dhaloota dhufu maraaf seerata haga bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_4","004_24_4","LEV","24","4","4","Aaron waan issaa irra keyanu ta worqii qulluu irraa hujante san irratti, ifi sun akka hin dhaanne ana Mootii Waan Maraa duratti tarree galchuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_5","004_24_5","LEV","24","5","5","«Bullaa dansaa fuudhiitii xaltaa daabbo'oo kudhanii lama, tokko tokkoon isaa kiiloogiraama lama lama ka te'e bilcheessi. ");
INSERT INTO gax_vpl VALUES ("LV24_6","004_24_6","LEV","24","6","6","Xaltaa daabbo'oo san xarapheessaa worqii qulluu irraa hujame irratti tarree lamaan, jaan jaaniin fuula kiyya dura wol irra naqi. ");
INSERT INTO gax_vpl VALUES ("LV24_7","004_24_7","LEV","24","7","7","Xaltaa daabbo'oo san woliin qooda yaadannoo kennansa ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu akka te'u, hixaana qulluu tarree lamaan san irra kaayi. ");
INSERT INTO gax_vpl VALUES ("LV24_8","004_24_8","LEV","24","8","8","Aaron bakka kolbaa Israa'elii bu'ee daabboo tana, Sanbata mara ana Mootii Waan Maraa duratti tarree galchuu ti. Tun Gondooroo bara baraa teetuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_9","004_24_9","LEV","24","9","9","Daabboon tun qooda Aaroniitii fi qooda ilmaan isaa ti; kennansa ibiddaan gubamee ana Mootii Waan Maraatiif dhikaatu keessaa qooda isaanii ka irra caalaa woyyicha te'e keessaa tokko waan te'eef, addee woyyitti'itti nyaatanuu ti. Kun seerata haga bara baraa ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV24_10","004_24_10","LEV","24","10","10","Nami haati isaa dubartii Israa'elii teete, ka abbaan isaa nama Gibxi'ii te'e tokko odduu Israa'elootaatitti gad bayee, Israa'elicha tokko woliin wol lolane. ");
INSERT INTO gax_vpl VALUES ("LV24_11","004_24_11","LEV","24","11","11","Ilmi dubartii Israa'elii sun maqaa Waaqaa abaaree waan faanshesseef, gara Muuse'ee isa fidane; haati isaa intala Dibrii nama gosa Daanii ti; maqaan isi'ii «Shelomiit» jedhama. ");
INSERT INTO gax_vpl VALUES ("LV24_12","004_24_12","LEV","24","12","12","Fedhi Mootii Waan Maraa haga isaanitti mudhatutti, isaan mana hidha'aatitti isa galchane. ");
INSERT INTO gax_vpl VALUES ("LV24_13","004_24_13","LEV","24","13","13","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV24_14","004_24_14","LEV","24","14","14","«Nama maqaa Waaqaa abaaree faanshesse san addee quttumaatiin alatti baasi. Worri faanshessiisa isaa dhage'e marti akka inni yakkaa huje dhugaa bayiisaaf harka ifii mataa isaa irra keyanuu ti; achiin duuba wolde'i marti dhaka'aan isa tumanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_15","004_24_15","LEV","24","15","15","Kolbaa Israa'eliitiin, ‹Nami maqaa Waaqa ifii abaaru marti cubbuu waan hujeef, itti hin gaafatama. ");
INSERT INTO gax_vpl VALUES ("LV24_16","004_24_16","LEV","24","16","16","Nami maqaa Mootii Waan Maraa faanshessu ijjeefamuu ti! Kolbaan wolde'i marti dhaka'aan isa tumanuu ti; alagaalle te'u yookiin dhalataa biyyaalle te'u nami maqaa Waaqaa faanshessu ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_17","004_24_17","LEV","24","17","17","« ‹Nami nama yoo ijjeese ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_18","004_24_18","LEV","24","18","18","Nami horii namaa ijjeese abbaa saniif horuma gosa sanii bakka buusuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_19","004_24_19","LEV","24","19","19","Nami tokko nama yoo miidhe, wonni inni nama irratti godhe sun isa irralle'etti godhamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_20","004_24_20","LEV","24","20","20","Yoo inni lafee namaa casse, lafeen isaalle cadduu ti; yoo inni ila namaa balleesse, ilti isaalle badduu ti; yoo inni ilkaan nama casse, ilkaan isaalle cabuu ti. Akkuma nama dhibii miidhe, innille miidhamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_21","004_24_21","LEV","24","21","21","Nami horii ijjeese, horii ijjeese san bakka buusuu ti; nami nama ijjeese ammoo ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV24_22","004_24_22","LEV","24","22","22","Ani Mootii Waan Maraa Waaqa keessan; nama alaga'aa fi nama dhalataa biyyaa te'eefille seeruma tokko qabaadha'a› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV24_23","004_24_23","LEV","24","23","23","Achiin duuba Muuseen waan kana mara kolbaa Israa'eliititti hime; isaan namicha san addee quttumaatiin alatti baasanee dhaka'aan tumanee ijjeesane. Akka kanaan kolbaan Israa'elii waan Mootiin Waan Maraa Muusee ajaje mara goote. ");
INSERT INTO gax_vpl VALUES ("LV25_1","004_25_1","LEV","25","1","1","Mootiin Waan Maraa gaara Siina'aa irratti Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV25_2","004_25_2","LEV","25","2","2","«Ati kolbaa Israa'eliitiin, ‹Mootiin Waan Maraa: Lafa ani isiniif kennu sanitti yennaa galtanu, foora sanbataa ka woggaa torbeesso'oo mara lafa qotiisa lakkisiisaan ana Mootii Waan Maraa ulfeessa'a. ");
INSERT INTO gax_vpl VALUES ("LV25_3","004_25_3","LEV","25","3","3","Woggaa jaa fichaa keessanitti facaafadha'aa, muka woyni'ii keessanille quxadha'aatii, midhaan keessan galfadha'a. ");
INSERT INTO gax_vpl VALUES ("LV25_4","004_25_4","LEV","25","4","4","Woggaan torbeesso'oo ammoo foora sanbataa ka woggaa torbaa ka ana Mootii Waan Maraatiif woyyoome; fichaa keessanitti hin facaafatina'a; muka woyni'ii keessanille hin quxina'a. ");
INSERT INTO gax_vpl VALUES ("LV25_5","004_25_5","LEV","25","5","5","Midhaan haaga'ee hin haammatina'a. Muka woyni'ii ka hin quxamin irraa midhaan hin guuratina'a. Lattille woggaa fooraa qabaattuu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_6","004_25_6","LEV","25","6","6","Foora sanbataa ka woggaa torbaa keessa wonni latti baachu marti si'iif, garboota teeti ta dhiiraatii fi ta dubarti'iitiif, hojjataa qaxaramee hujuu fi alagaa yenna'aaf isin woliin le'uuf sagalee te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_7","004_25_7","LEV","25","7","7","Horii keetii fi bineensa biyya teeti keessa jiranu maraafille sagalee te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_8","004_25_8","LEV","25","8","8","« ‹Woggaa fooraa torba yennaa torba laakkow; wolumatti woggaa afurtamii sagal hin te'an. ");
INSERT INTO gax_vpl VALUES ("LV25_9","004_25_9","LEV","25","9","9","Achiin duuba ji'a torbeesso'oo guyyaa kudhaneesso'oo, guyyaa gumaa cubbu'uu, biyya teessan addee maratti tultullaan afuufamuu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_10","004_25_10","LEV","25","10","10","Woggaa shantameesso'oo woyyoonsa'a; namoota biyya teessan keessa jiru maraaf bilisummaa lassa'a. Woggaan tun jila woggaa shantameesso'oo isiniif teetuu ti. Woggaa tanatti tokko tokkoon keessan gara qabeenna maatii teessaniitii fi gara fira keessanii deebi'a'a. ");
INSERT INTO gax_vpl VALUES ("LV25_11","004_25_11","LEV","25","11","11","Woggaan shantameesso'oo tun jila woggaa shantameesso'oo isiniif teetuu ti; ficha'atti hin facaafatina'a; midhaan ifiin late yookiin woynii hin quxamin irraa midhaan hin guuratina'a. ");
INSERT INTO gax_vpl VALUES ("LV25_12","004_25_12","LEV","25","12","12","Woggaan shantameesso'oo jila woggaa shantameesso'oo waan teeteef, ta woyyoonte isiniif teetuu ti; waan fichaa keessatti ifiin late callaa nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("LV25_13","004_25_13","LEV","25","13","13","« ‹Woggaa shantameesso'oo tana keessa nami martinuu gara qabeenna ifii deebi'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_14","004_25_14","LEV","25","14","14","Isin lafa yoo wolitti gurgurtane yookiin yoo wol irraa bitattane wol hin dagina'a. ");
INSERT INTO gax_vpl VALUES ("LV25_15","004_25_15","LEV","25","15","15","Isin akka bacinna laakkossa woggoota jila woggaa shantameesso'ootiif hatteetitti shallaga'aatii nama biyya teessanii irraa bitadha'a. Innille akka laakkossa woggoota midhaan irraa galfatiisa dande'anuutitti shallagee gurguruu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_16","004_25_16","LEV","25","16","16","Wonni inni isinitti gurguru laakkossa woggaa isin midhaan irraa galfattanuun waan te'eef, yoo woggaan hedduu teete, gatii itti dabala'a; yoo woggaan diqqoo teete gatii irraa cassa'a. ");
INSERT INTO gax_vpl VALUES ("LV25_17","004_25_17","LEV","25","17","17","Ani Mootii Waan Maraa Waaqa keessan waan te'eef, ana Waaqa keessan sodaadha'a malee, wol hin dagina'a. ");
INSERT INTO gax_vpl VALUES ("LV25_18","004_25_18","LEV","25","18","18","« ‹Lafa irra nageyaan akka leetanu, seerata kiyya eegadha'a; seera kiyyaaf ajajamiisaafille ifi eegadha'a. ");
INSERT INTO gax_vpl VALUES ("LV25_19","004_25_19","LEV","25","19","19","Achiin duuba latti midhaan hin kenniti; isinille nyaattanee quuttanee, nageyaan hin leetan. ");
INSERT INTO gax_vpl VALUES ("LV25_20","004_25_20","LEV","25","20","20","« ‹Isin: yoo hin facaafatin yookiin midhaan yoo hin galfatin woggaa torbeesso'oo keessa maan nyaanna jettanee gaafattan fa'a te'a. ");
INSERT INTO gax_vpl VALUES ("LV25_21","004_25_21","LEV","25","21","21","Woggaa jayeesso'ootitti latti midhaan woggaa sadiif gewu akka isiniif kennitu ani eebba kiyya isiniif hin erga. ");
INSERT INTO gax_vpl VALUES ("LV25_22","004_25_22","LEV","25","22","22","Woggaa saddeetesso'ootitti midhaan yennaa facaafattanu, midhaan galisoo san nyaattan; haga midhaan woggaa sagaleesso'oo galfattanulle'etti midhaanuma san nyaatan. ");
INSERT INTO gax_vpl VALUES ("LV25_23","004_25_23","LEV","25","23","23","« ‹Latti tiyya waan teeteef, isin ammoo alagaa yenna'aaf lafa tiyya irra jirtanu waan teetaneef, latti gurgurantee achumaan hin hafin. ");
INSERT INTO gax_vpl VALUES ("LV25_24","004_25_24","LEV","25","24","24","« ‹Lafa ifiif qabattane mara keessatti mirgi lafa deebisanee wodatanu jiraatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_25","004_25_25","LEV","25","25","25","Isin worra Israa'elii keessaa nami tokko hiyyoommatee, lafa ifii yoo gurgure, nami fira aantii isaa deebisee isaaf wodatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_26","004_25_26","LEV","25","26","26","Nami sun fira aanti'ii ka lafa san isaaf wodu yoo hin qabaatin, inninuu deebisee wodatiisaaf karra yoo dhaggate ammoo, ");
INSERT INTO gax_vpl VALUES ("LV25_27","004_25_27","LEV","25","27","27","lafa san haga itti gurgureen jalqabee, woggoota dabarane laakkowee, waan irraa hafe namichaaf deebisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_28","004_25_28","LEV","25","28","28","Deebisee wodatiisaaf harki isaa yoo hanqate ammoo, haga jila woggaa shantameesso'ootitti, latti sun abbuma bitate san harka turtuu ti; woggaa shantameesso'ootitti abbaa qara gurgureef deebituu ti; namichi keessaa bayee gara lafa ifii deebi'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_29","004_25_29","LEV","25","29","29","« ‹Nami tokko qachaa guddaa dalleya dhaka'aa qabu keessa jiru keessatti mana ifii yoo gurgure, gurgureen duuba woggaa tokko keessatti wodatiisaaf mirga qaba. ");
INSERT INTO gax_vpl VALUES ("LV25_30","004_25_30","LEV","25","30","30","Manni sun woggaa tokko keessatti yoo hin wodamin, manni qachaa guddaa dalleya dhaka'aa qabu san keessaa sun, namicha bitatee fi sanyii isaatiif te'uu ti; manni sun woggaa shantameesso'ootitti hin wodamin. ");
INSERT INTO gax_vpl VALUES ("LV25_31","004_25_31","LEV","25","31","31","Manooti ollaa dalleya dhaka'aa hin qanne keessa jiranu ammoo akka mana diida keessa jiruutitti laakkowamanee, wodamanee, woggaa shantameesso'oo keessa deebifamanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_32","004_25_32","LEV","25","32","32","Te'uu malee, worri Lewwootaa manoota qachaa isaanii keessa jiranu yennaa mara wodatiisaaf mirga qaban. ");
INSERT INTO gax_vpl VALUES ("LV25_33","004_25_33","LEV","25","33","33","Manooti qachoota Lewwootaa keessa jiranu, odduu Israa'elootaatitti qabeenna Lewwootaa waan te'aneef, worri Lewwootaa mana qachoota ifii keessaa gurguranee yoo wodatiisa dhabane, woggaa shantameesso'ootitti manni sun Lewwootaaf deebi'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_34","004_25_34","LEV","25","34","34","Addeen horii itti bobbaafatanu ta adaala qachaa isaanii jirtu ammoo qabeenna isaanii ka bara baraa waan teeteef, hin gurguramin. ");
INSERT INTO gax_vpl VALUES ("LV25_35","004_25_35","LEV","25","35","35","« ‹Isin keessaa nami tokko hiyyoommatee ifi qarqaariisa yoo dadhabe, akka inni odduu teessan le'iisa dande'u, akkuma nama alaga'aatii fi nama yenna'aaf odduu teessan jiru qarqaartanu isa qarqaara'a. ");
INSERT INTO gax_vpl VALUES ("LV25_36","004_25_36","LEV","25","36","36","Isin ammoo ana Mootii Waan Maraa keessan sodaadha'a; akka inni odduu teessan le'uuf, waan tokkolle dhalaan isa irraa hin fudhatina'a. ");
INSERT INTO gax_vpl VALUES ("LV25_37","004_25_37","LEV","25","37","37","Beesee teeti dhalaan isaaf hin liqeessin; sagalee isatti gurgurtu irraa bu'aa hin barbaadin. ");
INSERT INTO gax_vpl VALUES ("LV25_38","004_25_38","LEV","25","38","38","Ani Mootii Waan Maraa Waaqa keessan, ka lafa kana'aanii isiniif kenniisaaf, Waaqa keessanille isiniif te'iisaaf, biyya Gibxi'ii keessaa isin baase. ");
INSERT INTO gax_vpl VALUES ("LV25_39","004_25_39","LEV","25","39","39","« ‹Isin keessaa nami tokko hiyyoommatee isinitti ifi yoo gurgure, akka garbaatitti isa hin hujisiisin. ");
INSERT INTO gax_vpl VALUES ("LV25_40","004_25_40","LEV","25","40","40","Isin biratti inni akka nama qaxaramee hujuu yookiin akka nama yenna'aaf odduu teessan jiruutitti laakkowamuu ti; inni haga woggaa shantameesso'ootitti isinii hujuu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_41","004_25_41","LEV","25","41","41","Achiin duuba innii fi ijoolleen isaa bilisa bayanee fira ifii, gara qabeenna abbootii ifii ta duriititti deebi'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_42","004_25_42","LEV","25","42","42","Israa'elooti tajaajiltoota tiyya ta ani biyya Gibxi'ii keessaa baase waan te'aneef, akka garbaa hin gurguramin. ");
INSERT INTO gax_vpl VALUES ("LV25_43","004_25_43","LEV","25","43","43","Isin ana Waaqa keessan sodaadha'a malee, gadhi-jabeennaan isaan hin bulchina'a. ");
INSERT INTO gax_vpl VALUES ("LV25_44","004_25_44","LEV","25","44","44","Garboota teessan ta dhiiraatii fi ta dubarti'ii gosa biyya adda addaa ta adaala keessan jiranu keessaa bitatuu hin dandeettan. ");
INSERT INTO gax_vpl VALUES ("LV25_45","004_25_45","LEV","25","45","45","Akkasuma worra yenna'aaf odduu teessan le'uu fi worra fira isaanii ka biyya teessan keessatti dhalate bitatiisa hin dandeettan; isaan qabeenna keessan hin te'an. ");
INSERT INTO gax_vpl VALUES ("LV25_46","004_25_46","LEV","25","46","46","Akka qabeenna keessanii ijoolleen teessan isaan dhaaltuu ti; bara jiruu isaanii mara garboota isaan godhatuu dandeettan. Te'uu malee Israa'eloota obboleeyyan teessan gadhi-jabeennaan hin bulchina'a. ");
INSERT INTO gax_vpl VALUES ("LV25_47","004_25_47","LEV","25","47","47","« ‹Nami alagaan yookiin nami yenna'aaf odduu teessan le'u tokko yoo duroome, nami biyya teessanii tokko hiyyoommatee nama alaga'aa ka odduu teessan le'utti yookiin nama fira alaga'aa sanitti yoo ifi gurgure, ");
INSERT INTO gax_vpl VALUES ("LV25_48","004_25_48","LEV","25","48","48","inni ifi gurgureen duuba mirga wodamiisaa hin qaba. Nami obboleessa isaa, ");
INSERT INTO gax_vpl VALUES ("LV25_49","004_25_49","LEV","25","49","49","wosiilli isaa yookiin ilmi wosiila isaa yookiin sanyii worra isaa keessaa nami tokko isa wodiisa hin dande'a yookiin inninuu yoo karra dhaggate ifi wodatiisa hin dande'a. ");
INSERT INTO gax_vpl VALUES ("LV25_50","004_25_50","LEV","25","50","50","Inni woggaa ifi itti gurgureen jalqabee haga woggaa shantameesso'ootitti nama isa bitate san woliin yennaa isaa laakkowanuu ti; gatiin inni ittiin lakkifamu akka laakkossa woggoota saniititti, akka nama qaxaramee huju tokkoof kaffalamutti shallagama. ");
INSERT INTO gax_vpl VALUES ("LV25_51","004_25_51","LEV","25","51","51","Woggaan hedduun hattee yoo jiraatte, gatii inni ittiin ifi gurgure keessaa, gatiin laakkossa woggaa hatte sanii shallagantee, gatii wodoo ifii isaaf kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_52","004_25_52","LEV","25","52","52","Haga jila woggaa shantameesso'ootitti woggaan diqqoon callaan yoo hattee jiraatte, haga woggaa hatte saniititti gatii isaaf kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_53","004_25_53","LEV","25","53","53","Inni akka nama wogga'aa gara wogga'aatitti qaxaramee le'uu ti; namichi isa bitate sun isin duratti gadhi-jabeennaan isa hin bulchin. ");
INSERT INTO gax_vpl VALUES ("LV25_54","004_25_54","LEV","25","54","54","Akka kanaan yoo wodamiisa dhabe, innii fi ijoolleen isaa jila woggaa shantameesso'ootitti gad lakkifamanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV25_55","004_25_55","LEV","25","55","55","Isin kolbaan Israa'elii tajaajiltoota tiyya; isin tajaajiltoota tiyya ta ani biyya Gibxi'ii keessaa baase; ani Mootii Waan Maraa Waaqa keessan› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV26_1","004_26_1","LEV","26","1","1","Mootiin Waan Maraa, «Ani Mootiin Waan Maraa Waaqa keessan; isin waaqota dharaa hin hujatina'a yookiin fakkii yookiin soodduu woyyittii hin dhaabbatina'a; dhakaa qiriixamelle itti sagadiisaaf biyya teessan keessatti hin dhaabina'a! ");
INSERT INTO gax_vpl VALUES ("LV26_2","004_26_2","LEV","26","2","2","Ani Mootii Waan Maraa ti! Guyyaa Sanbataa kiyya eegadha'a; addee woyyittii tiyyaafille ulfinna kenna'a. ");
INSERT INTO gax_vpl VALUES ("LV26_3","004_26_3","LEV","26","3","3","«Isin seerata kiyya yoo eegattane, ajaja kiyyaafille akka dansaa yoo ajajantane, ");
INSERT INTO gax_vpl VALUES ("LV26_4","004_26_4","LEV","26","4","4","Bokkeya yennaa isaatitti isiniif hin kenna; latti midhaan hin baachi; mukille midhaan hin buusa. ");
INSERT INTO gax_vpl VALUES ("LV26_5","004_26_5","LEV","26","5","5","Midhaan adoo dhowattanuu yennaan unkuruura woyni'ii murattanu hin geetti; unkuruura woyni'iille adoo murattanuu yennaan midhaan facaafattanu hin geetti; sagalee barbaaddane maralle hin nyaattan; lafa teessan keessalle nageyaan hin leetan. ");
INSERT INTO gax_vpl VALUES ("LV26_6","004_26_6","LEV","26","6","6","«Lafaaf nageya hin kenna; isin hin foorfattan; nami isin sodaachisu tokkolle hin jiraatu. Ani bineensa hamaa lafa irraa hin balleessa; diinni keessan haganaa achi isin hin lolu. ");
INSERT INTO gax_vpl VALUES ("LV26_7","004_26_7","LEV","26","7","7","Isin diinota keessan hin ariitan; isaanille shallaagaa keessaniin isin duratti hin dhumatan. ");
INSERT INTO gax_vpl VALUES ("LV26_8","004_26_8","LEV","26","8","8","Isin nami shan isaan nama dhibba hin ariitan; isin nami dhibbi isaan nama kuma kudhan hin ariitan; diinoti keessanille shallaagaa keessaniin isin duratti hin dhumatan. ");
INSERT INTO gax_vpl VALUES ("LV26_9","004_26_9","LEV","26","9","9","Ani gara keessan hin ilaala; akka isin hortanu godhee, isin hin baceessa. Gondooroo isin woliin godhadhe hin eegadha. ");
INSERT INTO gax_vpl VALUES ("LV26_10","004_26_10","LEV","26","10","10","Isin midhaan bara dabaree adoo nyaattanuu, midhaan bara haareyaatiif addee dhaggatiisaaf, midhaan bara dabaree san hin haxoottan. ");
INSERT INTO gax_vpl VALUES ("LV26_11","004_26_11","LEV","26","11","11","Ani addee leetoo tiyyaa odduu teessanitti hin godhadha; isin hin jibbulle'e. ");
INSERT INTO gax_vpl VALUES ("LV26_12","004_26_12","LEV","26","12","12","Ani yennaa mara odduu teessan le'ee, Waaqa isiniif hin te'a; isinille kolbaa tiyya hin teetan. ");
INSERT INTO gax_vpl VALUES ("LV26_13","004_26_13","LEV","26","13","13","Akka isin haganaa achi worra Gibxi'iitiif garba hin teene, biyya Gibxi'ii keessaa ka isin baase, ana Mootii Waan Maraa Waaqa keessan; ani waanjoo garbumma'aa isin irraa cassee, ol jettanee akka deentanu isin godheera. ");
INSERT INTO gax_vpl VALUES ("LV26_14","004_26_14","LEV","26","14","14","«Isin naaf ajajamiisa dhaddanee, ajaja kiyya mara yoo hin eegatin, ");
INSERT INTO gax_vpl VALUES ("LV26_15","004_26_15","LEV","26","15","15","seerata kiyyalle tuffattanee, seera kiyya yoo jibbitane, akka ajaja kiyyaatitti hujuu dhaddanee, gondooroo tiyya yoo diiddane, ");
INSERT INTO gax_vpl VALUES ("LV26_16","004_26_16","LEV","26","16","16","ani waan asii gad jiru isinitti hin fida: bararaqa dedhaa, dhukkuba balleessu, o'a ila isin balleessee jiruu gossu isinitti fida; isin sanyii hin facaafatan, garuu diinota keessanitti nyaata. ");
INSERT INTO gax_vpl VALUES ("LV26_17","004_26_17","LEV","26","17","17","Akka diinni keessan isin injifatu, ani diina isinitti hin te'a; worri isin jibbu isin hin bulcha; adoo nami isin hin ari'in hin baqattan. ");
INSERT INTO gax_vpl VALUES ("LV26_18","004_26_18","LEV","26","18","18","«Tana maraan duuba isin ammalle naaf yoo hin ajajamin, ani sababa cubbuu teessaniitiif dachaa torba isin hin adaba. ");
INSERT INTO gax_vpl VALUES ("LV26_19","004_26_19","LEV","26","19","19","Ani hunna teessan ta isin ittiin koortanu hin cassa; bokkeenni akka hin roonne, gubbaa akka sibiilaa, lafa akka sageettu'uu hin godha. ");
INSERT INTO gax_vpl VALUES ("LV26_20","004_26_20","LEV","26","20","20","Latti teessan midhaan waan hin baanneef, muki keessanille midhaan waan hin buunneef, hunni teessan toluma dhumatti. ");
INSERT INTO gax_vpl VALUES ("LV26_21","004_26_21","LEV","26","21","21","«Isin na mormitanee, na dhage'iisa yoo diddane, ani akka cubbuu teessaniititti dachaa torba rakkinna isinitti fida. ");
INSERT INTO gax_vpl VALUES ("LV26_22","004_26_22","LEV","26","22","22","Ani bineensota ijoollee teessan isin duraa fudhatu, ka horii keessan balleessu, ka laakkossa keessanille diqqeessee, nami karaa irra deemu akka dhabamu godhu isinitti hin erga. ");
INSERT INTO gax_vpl VALUES ("LV26_23","004_26_23","LEV","26","23","23","«Waan kanalle'een gara kiyya deebi'uu diddanee, anaan yoo mormitane, ");
INSERT INTO gax_vpl VALUES ("LV26_24","004_26_24","LEV","26","24","24","ani isin mormee sababa cubbuu teessaniitiif dachaa torba rakkinna isinitti hin fida. ");
INSERT INTO gax_vpl VALUES ("LV26_25","004_26_25","LEV","26","25","25","Gondooroo tiyya waan diiddaneef, haluu bayiisaaf, shallaagaa isinitti hin fida. Yennaa isin qachaa keessatti wolitti qabantanu, ani balaa odduu teessanitti hin erga; harka diinaatitti dabarfantanee hin kennantan. ");
INSERT INTO gax_vpl VALUES ("LV26_26","004_26_26","LEV","26","26","26","Yennaa ani sagalee isin dhooggu, dubartiin kudhan eelee takka'atti daabboo isiniif bilcheessitee, madaaltee isinii hin dhikeessiti; isin hin nyaattan, ammoo hin quuttanu. ");
INSERT INTO gax_vpl VALUES ("LV26_27","004_26_27","LEV","26","27","27","«Waan kanalle'een gara kiyya deebi'uu diddanee, anaan yoo mormitane, ");
INSERT INTO gax_vpl VALUES ("LV26_28","004_26_28","LEV","26","28","28","achiin duuba aarii tiyyaan isin mormee, sababa cubbuu teessaniitiif, dachaa torba isin hin adaba. ");
INSERT INTO gax_vpl VALUES ("LV26_29","004_26_29","LEV","26","29","29","Isin foon ijoollee teessan ta dhiiraatii fi ta durraa hin nyaattan. ");
INSERT INTO gax_vpl VALUES ("LV26_30","004_26_30","LEV","26","30","30","Addee waaqonfanna'aa teessan hin balleessa; addee ciinca'aa teessan ta hixaanni irratti aarfamu hin diiga; reeffa keessan waaqota dharaa keessan ka lubbuu hin qanne san irratti hin tuula; isinille hin diqadha. ");
INSERT INTO gax_vpl VALUES ("LV26_31","004_26_31","LEV","26","31","31","Qachoota keessan hin diiga; addee woyyittii teessanille hin onsa; ciincaa keessan ka foolee dansaa qabu sanille hin fudhadhu. ");
INSERT INTO gax_vpl VALUES ("LV26_32","004_26_32","LEV","26","32","32","Diinoti keessan ka lafa teessan keessa le'anu, dhagganee akka rifatanu lafa teessan hin onsa. ");
INSERT INTO gax_vpl VALUES ("LV26_33","004_26_33","LEV","26","33","33","Gosa biyya adda addaa keessa isin bittinneessee, shallaagaa buqqifadhee isin hin ari'a; latti teessan duwwaa teetee, qachooti keessanille hin ona. ");
INSERT INTO gax_vpl VALUES ("LV26_34","004_26_34","LEV","26","34","34","Achiin duuba latti woggoota onte san mara, yennaa isin biyya diinota keessanii keessa jirtanu foora sanbataa ka woggoota torbaa ka ifii sanitti hin gammaddi; achiin duuba latti foorfattee, Sanbata ifiititti hin gammaddi. ");
INSERT INTO gax_vpl VALUES ("LV26_35","004_26_35","LEV","26","35","35","Latti woggoota Sanbataa ta yennaa isin keessa leetane san foora hin qanne, yennaa ontee teettu san mara hin qabaatti. ");
INSERT INTO gax_vpl VALUES ("LV26_36","004_26_36","LEV","26","36","36","«Isin keessaa worra lubbu'uun hafe, lafa diinota isaanii keessa jiranuun sodaa hantuu isaanitti hin erga. Shokokkeessi baala qilleensi tachoosuu isaan hin bararassa; nami isaan ari'u adoo hin jiraatin akka nama shallaagaa dheetuu hin baqatan; hin jiganille'e. ");
INSERT INTO gax_vpl VALUES ("LV26_37","004_26_37","LEV","26","37","37","Nami isaan ari'u adoo hin jiraatin, akka nama shallaagaa dheetuu adoo baqatanuu wol gufatan. Maarre isin diinota keessan dura dhaabbatiisa hin dandeettanu. ");
INSERT INTO gax_vpl VALUES ("LV26_38","004_26_38","LEV","26","38","38","Isin gosa biyya adda addaa oddu'utti hin dhumattan; latti diinota keessanii isin hin liqinsiti. ");
INSERT INTO gax_vpl VALUES ("LV26_39","004_26_39","LEV","26","39","39","Isin keessaa worri lubbu'uun hafe, sababa cubbuu ifiitii fi sababa cubbuu abbootii ifiitiif lafa diinota ifii keessatti hin yaayyan. ");
INSERT INTO gax_vpl VALUES ("LV26_40","004_26_40","LEV","26","40","40","«Te'uu malee isaan cubbuu ifiitii fi cubbuu abbootii ifii ta isaan maltumma'aan na mormatane yoo faaci'atane, ");
INSERT INTO gax_vpl VALUES ("LV26_41","004_26_41","LEV","26","41","41","cubbuu akka ani diina isaanitti te'uu fi gara lafa diina isaaniititti akka ani isaan ari'u goote san yoo faaci'atane, gadhaan isaanii ka jabaate sun laafee, adabbii cubbuu ifii yoo fudhatane, ");
INSERT INTO gax_vpl VALUES ("LV26_42","004_26_42","LEV","26","42","42","ani gondooroo tiyya ta Yaaqoob, Yisihaqii fi Abrahaamii woliin godhe san hin qaabadha. Lafa sanille hin qaabadha. ");
INSERT INTO gax_vpl VALUES ("LV26_43","004_26_43","LEV","26","43","43","Isaan lakkisanee waan deemaneef, latti ontee, addee isaan hin jirretti woggoota Sanbata ifiititti hin gammaddi; isaan seera kiyya tuffatanee, seerata kiyya waan jibbaneef adabbii cubbuu ifii hin fudhatan. ");
INSERT INTO gax_vpl VALUES ("LV26_44","004_26_44","LEV","26","44","44","Te'uu malee, waan kanalle'een, ani Mootii Waan Maraa Waaqa isaanii waan te'eef, gondooroo isaan woliin godhe hin diigu; yennaa isaan lafa diina ifii keessa jiranu ijjumaa isaan balleessiisaaf, isaan hin gatu yookiin hin diqadhu. ");
INSERT INTO gax_vpl VALUES ("LV26_45","004_26_45","LEV","26","45","45","Ani ammoo gondooroo tiyya ta abbootii isaanii, gosi biyya adda addaa adoo dhaggituu, Waaqa isaaniif te'iisaaf, biyya Gibxi'ii keessaa yennaa isaan baase isaan woliin godhe san, isaaniif jedhee hin qaabadha. Ani Mootii Waan Maraa ti!» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV26_46","004_26_46","LEV","26","46","46","Kun Seerata, seeraa fi ajaja Mootiin Waan Maraa gaara Siina'aa irratti ifii fi kolbaa Israa'elii wodhakka'atti karaa Muuse'eetiin dhaabe. ");
INSERT INTO gax_vpl VALUES ("LV27_1","004_27_1","LEV","27","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("LV27_2","004_27_2","LEV","27","2","2","«Ati kolbaa Israa'eliitiin, ‹Nami tokko nama ana Mootii Waan Maraatiif adda baasee kenniisaaf waadaa yoo gale, akka nami sun itti shallagametti, gatiin inni kaffalu, ");
INSERT INTO gax_vpl VALUES ("LV27_3","004_27_3","LEV","27","3","3","akka madaallii addee woyyitti'iititti dhiira woggaa diddamaa haga woggaa jaatamaatiif meetii giraama dhibba shanii fi torbaatama, ");
INSERT INTO gax_vpl VALUES ("LV27_4","004_27_4","LEV","27","4","4","dubartii yoo teete ammoo meetii giraama dhibba sadii fi afurtama, ");
INSERT INTO gax_vpl VALUES ("LV27_5","004_27_5","LEV","27","5","5","dhiira woggaa shanii haga woggaa diddamaatiif meetii giraama dhibba lamaa fi soddoma, dubartii yoo teete ammoo meetii giraama dhibba tokkoo fi kudhanii shan, ");
INSERT INTO gax_vpl VALUES ("LV27_6","004_27_6","LEV","27","6","6","dhiira ji'a tokkoo haga woggaa shaniitiif meetii giraama shantamii torba, dubartii yoo teete ammoo meetii giraama soddomii afur ");
INSERT INTO gax_vpl VALUES ("LV27_7","004_27_7","LEV","27","7","7","dhiira woggaa jaatamaa oliitiif meetii giraama dhibba tokkoo fi torbaatamii tokko, dubartii yoo teete ammoo meetii giraama dhibba tokkoo fi kudhanii shan kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_8","004_27_8","LEV","27","8","8","« ‹Nami waadaa gale sun hiyyeessa te'ee shallaggii san kaffaluu yoo dadhabe, nama kenniisaaf waadaa gale san fuula hayyichaa dura dhikeessuu ti; hayyichille gatii inni kaffaliisaaf dande'utti shallaguu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_9","004_27_9","LEV","27","9","9","« ‹Wonni inni kenniisaaf waadaa gale sun horii kennansa ana Mootii Waan Maraatiif fudhatama qabu yoo te'e, horiin akkasii ka ana Mootii Waan Maraatiif kenname woyyuu hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV27_10","004_27_10","LEV","27","10","10","Nami sun kennansa dhikaate san dansaa hama'aan yookiin hamaa dansa'aan hin jijjiirin yookiin bakka hin buusin; horii tokko horii dhibi'iin bakka yoo buuse, horiin sun lamaanuu ana Mootii Waan Maraatiif woyyoomanuu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_11","004_27_11","LEV","27","11","11","Wonni inni ana Mootii Waan Maraatiif kenniisaaf waadaa gale sun horii akka aadaa dhugeeffanna'aatitti ka qulqulluu hin te'in, ana Mootii Waan Maraatiif kenniisaaf ka fudhatama hin qanne yoo te'e, horiin sun hayyicha dura dhikaatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_12","004_27_12","LEV","27","12","12","Hayyichi horii san dansaa yookiin badaa te'uu isaa ilaalee shallaguu ti. Achiin duuba shallaggiin sun akkuma hayyichi shallagetti hin teeti. ");
INSERT INTO gax_vpl VALUES ("LV27_13","004_27_13","LEV","27","13","13","Abbichi horii san wodatiisa yoo barbaade, shallaggii sanitti harka shan keessaa harka tokko itti dabaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_14","004_27_14","LEV","27","14","14","« ‹Nami tokko mana ifii ana Mootii Waan Maraatiif woyyuu akka te'u yoo adda baase, hayyichi manni sun dansaa yookiin badaa te'uu isaa ilaalee shallaguu ti. Achiin duuba shallaggiin sun akkuma hayyichi shallagetti hin teeti ");
INSERT INTO gax_vpl VALUES ("LV27_15","004_27_15","LEV","27","15","15","Abbichi mana ifii adda baase sun mana san wodatiisa yoo barbaade, shallaggii sanitti harka shan keessaa harka tokko itti dabaluu ti. Manni sun deebi'ee ka isaa hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV27_16","004_27_16","LEV","27","16","16","« ‹Nami tokko lafa maatii ifii irraa dhaale irraa fichaa kutee ana Mootii Waan Maraatiif adda baasee kennansa yoo dhikeesse, latti sun haga sanyii itti facaafantuutiin shallagantuu ti; sanyiin itti facaafantu garbuu kiiloogiraama dhibba tokko, latti sun meetii giraama dhibba shanii fi torbaatamatti hin shallaganti. ");
INSERT INTO gax_vpl VALUES ("LV27_17","004_27_17","LEV","27","17","17","Nami sun fichaa ifii san yennaa jila woggaa shantameesso'ootitti adda baasee yoo kenne, shallaggiin sun akkuma hayyichi murteesse sanitti te'a. ");
INSERT INTO gax_vpl VALUES ("LV27_18","004_27_18","LEV","27","18","18","Inni fichaa ifii san woggaa shantameesso'ootiin duuba yoo kennee jiraate ammoo, hayyichi akka laakkossa woggoota haga jila woggaa shantameesso'oo ta itti aantuutitti woggoota hafaneeranu ilaalee, shallaggii fichaa sanii irraa dhidhisuu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_19","004_27_19","LEV","27","19","19","Abbichi fichaa ifii kenne sun deebisee wodatiisa yoo barbaade, gatii fichaan itti shallagamee sanitti harka shan keessaa harka tokko itti dabaluu ti; fichaan sun ka isaa hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV27_20","004_27_20","LEV","27","20","20","Te'uu malee fichaa san yoo hin wodatin yookiin nama dhibi'itti yoo gurgure deebi'ee fichaa san wodatiisa hin dande'u. ");
INSERT INTO gax_vpl VALUES ("LV27_21","004_27_21","LEV","27","21","21","Fichaan sun woggaa shantameesso'ootitti yennaa gad lakkifamu, ka woyyoome te'ee, akka fichaa ana Mootii Waan Maraatiif kennamiisaaf murteeffameetitti, qabeenna hayyootaa hin te'a. ");
INSERT INTO gax_vpl VALUES ("LV27_22","004_27_22","LEV","27","22","22","« ‹Nami tokko fichaa bitate ka lafa maatii ifii irraa dhaale hin te'in, ana Mootii Waan Maraatiif adda yoo baase, ");
INSERT INTO gax_vpl VALUES ("LV27_23","004_27_23","LEV","27","23","23","hayyichi shallaggii fichaa sanii haga jila woggaa shantameesso'ootitti laakkowee shallaguu ti; namichille akka waan Mootii Waan Maraatiif woyyuu te'eetitti guyyuma san kaffaluu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_24","004_27_24","LEV","27","24","24","Jila woggaa shantameesso'ootitti fichaan sun abbicha lafaa ka qara inni irraa bite saniif hin deebi'a. ");
INSERT INTO gax_vpl VALUES ("LV27_25","004_27_25","LEV","27","25","25","Shallaggiin martinuu akka madaallii addee woyyitti'iititti te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_26","004_27_26","LEV","27","26","26","« ‹Te'uu malee angafi hori'ii duruuyyuu ka ana Mootii Waan Maraa waan te'eef, eennulle angafa hori'ii ana Mootii Waan Maraatiif adda baasuu hin dande'u; angafa jabbii loonii, angafa ilmoolee hoole'ee yookiin re'e'ee te'ulle ka ana Mootii Waan Maraa ti. ");
INSERT INTO gax_vpl VALUES ("LV27_27","004_27_27","LEV","27","27","27","Horii qulqulluu hin te'in yoo te'e, gatii itti shallagame harka shan keessaa harka tokko itti dabalee wodatuu ti. Inni yoo hin wodatin, gatii itti shallagametti gurguramuu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_28","004_27_28","LEV","27","28","28","« ‹Wonni ana Mootii Waan Maraatiif kennamiisaaf murteeffame martinuu irra caalaa woyyuu waan teeteef, wonni nami naaf kenniisaaf murteesse horiin, nami, latti maatii ifii irraa inni dhaale tokkolle hin gurguramin yookiin hin wodamin. ");
INSERT INTO gax_vpl VALUES ("LV27_29","004_27_29","LEV","27","29","29","Namalle yoo te'e hin wodamin; inni ijjeefamuu qaba. ");
INSERT INTO gax_vpl VALUES ("LV27_30","004_27_30","LEV","27","30","30","«‹Waan latti baachu mara keessaa, midhaan biyyeen baachu yookiin midhaan mukaalle te'u kudhan keessaa tokko ka ana Mootii Waan Maraa ti. Ana Mootii Waan Maraatiifille ka woyyoome. ");
INSERT INTO gax_vpl VALUES ("LV27_31","004_27_31","LEV","27","31","31","Nami kennansa ifii ka kudhan keessaa tokko kenne san wodatiisa barbaadu, gatii kennansa saniititti, harka shan keessaa harka tokko itti dabalee wodatuu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_32","004_27_32","LEV","27","32","32","Horii keessaa kudhan keessa tokko, ka laakkowamiisaaf ulee tissitootaa jala dabaranu mara keessaa kudhaneessoon, ka ana Mootii Waan Maraatiif woyyoome te'uu ti. ");
INSERT INTO gax_vpl VALUES ("LV27_33","004_27_33","LEV","27","33","33","Horiin kudhaneesso'oo sun badaa yookiin dansaalle te'u, nami kennu sun hin filin yookiin bakka hin buusin; horii tokko horii dhibi'ii bakka yoo buuse, lamaanuu ana Mootii Waan Maraatiif woyyoomanuu ti; wodamiisaaf hin dande'anu› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("LV27_34","004_27_34","LEV","27","34","34","Kun ajaja Mootiin Waan Maraa gaara Siina'aa irratti kolbaa Israa'eliitiif karaa Muuse'eetiin kenne.");
INSERT INTO gax_vpl VALUES ("NU1_1","005_1_1","NUM","1","1","1","Kolbaan Israa'elii biyya Gibxi'iitii baatee woggaa lammeesso'ootitti, ji'a lammeesso'oo guyyaa jalqabaa, goomolee Siina'aa keessatti, Dunkaanii Woldeenna'aa keessatti Waaqi Muuse'etti dubbate. Inni Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU1_2","005_1_2","NUM","1","2","2","«Kolbaa Israa'elii duudii akka gosa gosa isaaniititti, akka maatii maatii isaaniititti dhiira ka te'ane mara laakkowiitii maqaa isaanii galmeessi! ");
INSERT INTO gax_vpl VALUES ("NU1_3","005_1_3","NUM","1","3","3","Atii fi Aaron kolbaa Israa'elii keessaa dhiira worra woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loluu dande'anu mara akka kutaa kutaa isaaniititti laakkowa'a! ");
INSERT INTO gax_vpl VALUES ("NU1_4","005_1_4","NUM","1","4","4","Gosa tokko tokkooyyuu keessaa nami tokko, ka sooressa maatii ifii te'e, isin qarqaaruu ti. ");
INSERT INTO gax_vpl VALUES ("NU1_5","005_1_5","NUM","1","5","5","Maqaan worra isin qarqaaruu: gosa Ruubenii keessaa, ilma Shiide'urii Eliizur; ");
INSERT INTO gax_vpl VALUES ("NU1_6","005_1_6","NUM","1","6","6","gosa Shimi'oonii keessaa, ilma Zuriishadaayii Shiilumii'el; ");
INSERT INTO gax_vpl VALUES ("NU1_7","005_1_7","NUM","1","7","7","gosa Yihuda'aa keessaa, ilma Aminaadaabii Nahasoon; ");
INSERT INTO gax_vpl VALUES ("NU1_8","005_1_8","NUM","1","8","8","gosa Yisaakorii keessaa, ilma Zuwaarii Nataani'el; ");
INSERT INTO gax_vpl VALUES ("NU1_9","005_1_9","NUM","1","9","9","gosa Zebuloonii keessaa, ilma Helonii Eliiyaab; ");
INSERT INTO gax_vpl VALUES ("NU1_10","005_1_10","NUM","1","10","10","ilmaan Yoseefii gosa Efreemii keessaa, ilma Amiihudii Eliishaama'a; gosa Minaase'ee keessaa, ilma Phedaazurii Gamaali'el; ");
INSERT INTO gax_vpl VALUES ("NU1_11","005_1_11","NUM","1","11","11","gosa Beniyaaminii keessaa, ilma Giidewonii Abiidaan; ");
INSERT INTO gax_vpl VALUES ("NU1_12","005_1_12","NUM","1","12","12","gosa Daanii keessaa, ilma Amiishadaayii Ahii'ezer; ");
INSERT INTO gax_vpl VALUES ("NU1_13","005_1_13","NUM","1","13","13","gosa Aheerii keessaa, ilma Okraanii Fagi'el; ");
INSERT INTO gax_vpl VALUES ("NU1_14","005_1_14","NUM","1","14","14","gosa Gaadii keessaa, ilma Dewu'elii Elii'aasaaf; ");
INSERT INTO gax_vpl VALUES ("NU1_15","005_1_15","NUM","1","15","15","gosa Naftaalemii keessaa, ilma Enaanii Ahiira'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU1_16","005_1_16","NUM","1","16","16","Kolbaa hedduu keessaa, sooressitooti gosa abbootii isaanii ta durii, maatii kolbaa Israa'eliitiif worri mataa te'anee filamane isaan kana. ");
INSERT INTO gax_vpl VALUES ("NU1_17","005_1_17","NUM","1","17","17","Muuse'ee fi Aaron worra maqaan isaanii dhowame kana fudhatanee, ");
INSERT INTO gax_vpl VALUES ("NU1_18","005_1_18","NUM","1","18","18","ji'a lammeesso'oo guyyaa jalqabaa, wolde'a gumi'ii mara wolitti qabanee, dhiira worra woggaa diddamaatii fi diddamaa olii, akka gosaa fi maatii isaaniititti, tokko tokkoon maqaan isaanii galmeessane. ");
INSERT INTO gax_vpl VALUES ("NU1_19","005_1_19","NUM","1","19","19","Akkuma Mootiin Waan Maraa isa ajajetti, Muuseen goomolee Siina'aa keessatti isaan laakkowe. ");
INSERT INTO gax_vpl VALUES ("NU1_20","005_1_20","NUM","1","20","20","Sanyii Ruubenii ilma angaficha Israa'elii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_21","005_1_21","NUM","1","21","21","Gosa Ruubenii keessaa worri laakkowame 46,500. ");
INSERT INTO gax_vpl VALUES ("NU1_22","005_1_22","NUM","1","22","22","Sanyii Shimi'oonii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu akka gosaa fi maatii isaaniititti maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_23","005_1_23","NUM","1","23","23","Gosa Shimi'oonii keessaa worri laakkowame 59,300. ");
INSERT INTO gax_vpl VALUES ("NU1_24","005_1_24","NUM","1","24","24","Sanyii Gaadii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_25","005_1_25","NUM","1","25","25","Gosa Gaadii keessaa worri laakkowame 45,650. ");
INSERT INTO gax_vpl VALUES ("NU1_26","005_1_26","NUM","1","26","26","Sanyii Yihuda'aa keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_27","005_1_27","NUM","1","27","27","Gosa Yihuda'aa keessaa worri laakkowame 74,600. ");
INSERT INTO gax_vpl VALUES ("NU1_28","005_1_28","NUM","1","28","28","Sanyii Yisaakorii keessa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_29","005_1_29","NUM","1","29","29","Gosa Yisaakorii keessaa worri laakkowame 54,400. ");
INSERT INTO gax_vpl VALUES ("NU1_30","005_1_30","NUM","1","30","30","Sanyii Zebuloonii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_31","005_1_31","NUM","1","31","31","Gosa Zebuloonii keessaa worri laakkowame 57,400. ");
INSERT INTO gax_vpl VALUES ("NU1_32","005_1_32","NUM","1","32","32","Ilmaan Yoseefii keessaa, sanyii Efreemii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_33","005_1_33","NUM","1","33","33","Gosa Efreemii keessaa worri laakkowame 40,500. ");
INSERT INTO gax_vpl VALUES ("NU1_34","005_1_34","NUM","1","34","34","Sanyii Minaase'ee keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_35","005_1_35","NUM","1","35","35","Gosa Minaase'ee keessaa worri laakkowame 32,200. ");
INSERT INTO gax_vpl VALUES ("NU1_36","005_1_36","NUM","1","36","36","Sanyii Beniyaaminii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_37","005_1_37","NUM","1","37","37","Gosa Beniyaaminii keessaa worri laakkowame 35,400. ");
INSERT INTO gax_vpl VALUES ("NU1_38","005_1_38","NUM","1","38","38","Sanyii Daanii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_39","005_1_39","NUM","1","39","39","Gosa Daanii keessaa worri laakkowame 62,700. ");
INSERT INTO gax_vpl VALUES ("NU1_40","005_1_40","NUM","1","40","40","Sanyii Asheerii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_41","005_1_41","NUM","1","41","41","Gosa Asheerii keessaa worri laakkowame 41,500. ");
INSERT INTO gax_vpl VALUES ("NU1_42","005_1_42","NUM","1","42","42","Sanyii Naftaalemii keessaa dhiirti worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu, akka gosaa fi maatii isaaniititti, maqaan isaanii tokko tokkoon galmeeffame. ");
INSERT INTO gax_vpl VALUES ("NU1_43","005_1_43","NUM","1","43","43","Gosa Naftaalemii keessaa worri laakkowame 53,400. ");
INSERT INTO gax_vpl VALUES ("NU1_44","005_1_44","NUM","1","44","44","Muuseen, Aaronii fi sooreyyiin Israa'elii kudhanii lamaan maatii ifii bakka bu'anee worri laakkowane isaan kana. ");
INSERT INTO gax_vpl VALUES ("NU1_45","005_1_45","NUM","1","45","45","Dhiirti Israa'elii worri woggaan isaanii diddamaatii fi diddamaa olii, ka dhaqanee loliisaaf dande'anu martinuu akka maatii isaaniititti laakkowamane. ");
INSERT INTO gax_vpl VALUES ("NU1_46","005_1_46","NUM","1","46","46","Worri laakkowame martinuu wolumatti 603,550. ");
INSERT INTO gax_vpl VALUES ("NU1_47","005_1_47","NUM","1","47","47","Te'uu malee, maatiin gosa Lewwootaa ammoo gosa dhibii woliin hin laakkowanne. ");
INSERT INTO gax_vpl VALUES ("NU1_48","005_1_48","NUM","1","48","48","Sababille Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU1_49","005_1_49","NUM","1","49","49","«Gosa Lewwootaa hin laakkowin yookiin isaan laakkossa Israa'eloota dhibi'iititti hin dabalin! ");
INSERT INTO gax_vpl VALUES ("NU1_50","005_1_50","NUM","1","50","50","Tanaa mannaa, worra Lewwootaa dunkaanii dhugaa bayaa ta ani itti waaqonfamuu fi meya isii keessaa, waan isi'ii mara irratti itti gaafatantoota isaan godhi. Isaan isi'ii fi meya isi'ii mara ba'atanuu ti; isii keessa tajaajilaa, adaala isi'ii qubatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU1_51","005_1_51","NUM","1","51","51","Yennaa dunkaanii dhugaa bayaa buqqisanu, worri Lewwootaa buqqisuu ti; yennaa dhaabanulle worri Lewwootaa dhaabuu ti. Nami dhibiin ka isii bira dhaqe ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("NU1_52","005_1_52","NUM","1","52","52","Israa'elooti dhibiin golii golii ifiitiin baandiraa ifii biratti dunkaanii dhaabatanee adduma addaan qubatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU1_53","005_1_53","NUM","1","53","53","Lewwooti ammoo akka ani Israa'elootatti hin mufanne adaala dunkaanii dhugaa bayaatitti qubatanuu ti. Lewwooti dunkaanii dhugaa bayaa eegiisaaf itti gaafatantoota te'anuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU1_54","005_1_54","NUM","1","54","54","Israa'elooti waan mara akkuma Mootiin Waan Maraa Muusee ajajetti godhane. ");
INSERT INTO gax_vpl VALUES ("NU2_1","005_2_1","NUM","2","1","1","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("NU2_2","005_2_2","NUM","2","2","2","«Israa'elooti Dunkaanii Woldeenna'aa irraa fagaatanee, nami tokko tokkooyyuu baandiraa maatii ifii jala, adaala Dunkaanii Woldeenna'aatitti qubatuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU2_3","005_2_3","NUM","2","3","3","Ila boru'uu, karaa aduun baatuun, goliin quttuma Yihuda'aa loltoota ifii woliin baandiraa ifii jala hin qubatan. Sooressi kolbaa Yihuda'aa, ilma Aminaadaabii Nahasoon. ");
INSERT INTO gax_vpl VALUES ("NU2_4","005_2_4","NUM","2","4","4","Goliin isaa loltooti laakkowamane 74,600. ");
INSERT INTO gax_vpl VALUES ("NU2_5","005_2_5","NUM","2","5","5","Gosi Yisaakorii isaanitti aananee hin qubatan. Sooressi kolbaa Yisaakorii, ilma Zuwaarii Nataani'el. ");
INSERT INTO gax_vpl VALUES ("NU2_6","005_2_6","NUM","2","6","6","Goliin isaa loltooti laakkowamane 54,400. ");
INSERT INTO gax_vpl VALUES ("NU2_7","005_2_7","NUM","2","7","7","Gosi Zebuloonii isaanitti hin aanan. Sooressi kolbaa Zebuloonii, ilma Helonii Eliiyaab. ");
INSERT INTO gax_vpl VALUES ("NU2_8","005_2_8","NUM","2","8","8","Goliin isaa loltooti laakkowamane 57,400. ");
INSERT INTO gax_vpl VALUES ("NU2_9","005_2_9","NUM","2","9","9","Addee quttumaa ta worra Yihuda'aa keessa akka golii golii isaaniititti akka qubatanu, namooti laakkowamane marti wolumatti 86,400. Worri dursee duula bayu isaan kana. ");
INSERT INTO gax_vpl VALUES ("NU2_10","005_2_10","NUM","2","10","10","Goliin quttuma Ruubenii gara kibbaatiin, baandiraa ifii jala hin qubatan. Sooressi kolbaa Ruubenii ilma Shiide'urii Eliizur. ");
INSERT INTO gax_vpl VALUES ("NU2_11","005_2_11","NUM","2","11","11","Goliin isaa loltooti laakkowame 46,500. ");
INSERT INTO gax_vpl VALUES ("NU2_12","005_2_12","NUM","2","12","12","Gosi Shimi'oonii isaanitti aananee hin qubatan. Sooressi kolbaa Shimi'oonii, ilma Zuriishadaayii Shiilumii'el. ");
INSERT INTO gax_vpl VALUES ("NU2_13","005_2_13","NUM","2","13","13","Goliin isaa loltooti laakkowame 59,300. ");
INSERT INTO gax_vpl VALUES ("NU2_14","005_2_14","NUM","2","14","14","Gosi Gaadii isaanitti hin aanan. Sooressi kolbaa Gaadii, ilma Dewu'elii Elii'aasaaf. ");
INSERT INTO gax_vpl VALUES ("NU2_15","005_2_15","NUM","2","15","15","Goliin isaa loltooti laakkowame 45,650. ");
INSERT INTO gax_vpl VALUES ("NU2_16","005_2_16","NUM","2","16","16","Quttuma Ruubenii keessaa dhiirti loltooti akka golii golii isaaniititti laakkowame wolumatti 151,450. Worri kun lammeessoo te'anee duula hin bayan. ");
INSERT INTO gax_vpl VALUES ("NU2_17","005_2_17","NUM","2","17","17","Achiin duuba Dunkaaniin Woldeenna'aatii fi goliin Lewwootaa golii worra qaraatii fi golii worra duubaa wodhakkaa deeman. Isaan adduma addaan bayanee akkuma dur addee quttuma ifii jiranuutitti baandiraa ifii qabatanee hin deeman. ");
INSERT INTO gax_vpl VALUES ("NU2_18","005_2_18","NUM","2","18","18","Goliin gosa Efreemii loltoota ifii woliin karaa aduun seentuun baandiraa ifii jala hin qubatan. Sooressi gosa Efreemii, ilma Amiihudii Eliishaama'a. ");
INSERT INTO gax_vpl VALUES ("NU2_19","005_2_19","NUM","2","19","19","Goliin isaa loltooti laakkowamanee 40,500. ");
INSERT INTO gax_vpl VALUES ("NU2_20","005_2_20","NUM","2","20","20","Gosi Minaase'ee isaanitti aananee hin qubatan. Sooressi kolbaa Minaase'ee, ilma Phedaazurii Gamaali'el. ");
INSERT INTO gax_vpl VALUES ("NU2_21","005_2_21","NUM","2","21","21","Goliin isaa loltooti laakkowamane 32,200. ");
INSERT INTO gax_vpl VALUES ("NU2_22","005_2_22","NUM","2","22","22","Gosi Beniyaaminii isaanitti hin aanan. Sooressi kolbaa Beniyaaminii, ilma Giidewonii Abiidaan. ");
INSERT INTO gax_vpl VALUES ("NU2_23","005_2_23","NUM","2","23","23","Goliin isaa loltooti laakkowamane 35,400. ");
INSERT INTO gax_vpl VALUES ("NU2_24","005_2_24","NUM","2","24","24","Quttuma Efreemii keessaa dhiirti akka golii golii ifiititti laakkowamane wolumatti 108,100. Isaan sadeessoo te'anee duula hin bayan. ");
INSERT INTO gax_vpl VALUES ("NU2_25","005_2_25","NUM","2","25","25","Goliin quttuma gosa Daanii loltoota ifii woliin gara kaabaatiin, baandiraa ifii jala hin qubatan. Sooressi kolbaa Daanii ilma Amiishadaayii Ahii'ezer. ");
INSERT INTO gax_vpl VALUES ("NU2_26","005_2_26","NUM","2","26","26","Goliin isaa loltooti laakkowamane 62,700. ");
INSERT INTO gax_vpl VALUES ("NU2_27","005_2_27","NUM","2","27","27","Gosi Asheerii isaanitti hin aanan. Sooressi kolbaa Asheerii ilma Okraanii Fagi'el. ");
INSERT INTO gax_vpl VALUES ("NU2_28","005_2_28","NUM","2","28","28","Goliin isaa loltooti laakkowamane 41,500. ");
INSERT INTO gax_vpl VALUES ("NU2_29","005_2_29","NUM","2","29","29","Gosi Niftaalemii isaanitti hin aanan. Sooressi kolbaa Niftaalemii, ilma Enaanii Ahiira'a. ");
INSERT INTO gax_vpl VALUES ("NU2_30","005_2_30","NUM","2","30","30","Goliin isaa loltooti laakkowamane 53,400. ");
INSERT INTO gax_vpl VALUES ("NU2_31","005_2_31","NUM","2","31","31","Quttuma Daanii keessaa dhiirti akka golii golii isaaniititti worri laakkowamane 157,600. Isaan dhuma irra baandiraa ifii qabatanee hin bayan. ");
INSERT INTO gax_vpl VALUES ("NU2_32","005_2_32","NUM","2","32","32","Israa'elooti akka maatii maatii isaaniititti, akka golii golii isaaniititti loltooti laakkowamane martinuu wolumatti 603,550. ");
INSERT INTO gax_vpl VALUES ("NU2_33","005_2_33","NUM","2","33","33","Lewwooti ammoo akkuma Mootiin Waan Maraa Muusee ajajetti gosa Israa'elootaa dhibii woliin hin laakkowanne. ");
INSERT INTO gax_vpl VALUES ("NU2_34","005_2_34","NUM","2","34","34","Maarre Israa'elooti waan mara akkuma Mootiin Waan Maraa Muusee ajaje godhanee, baandiraa ifii qabatanee, golii golii'ii fi maatii maatii ifii woliin duula bayane. ");
INSERT INTO gax_vpl VALUES ("NU3_1","005_3_1","NUM","3","1","1","Mootiin Waan Maraa gaara Siina'aa irratti yennaa Muuse'etti dubbate, maatiin Muuse'ee fi Aaronii isaan kana. ");
INSERT INTO gax_vpl VALUES ("NU3_2","005_3_2","NUM","3","2","2","Ilmaan Aaronii angafichi Naadaab, kuun Abiihuu, Ele'azaarii fi Itaamaar. ");
INSERT INTO gax_vpl VALUES ("NU3_3","005_3_3","NUM","3","3","3","Isaan kun worra hayyoota te'anee hujii hayyumma'aa hujiisaaf muudamane. ");
INSERT INTO gax_vpl VALUES ("NU3_4","005_3_4","NUM","3","4","4","Naadaabii fi Abiihuun goomolee Siina'aatitti ibidda hin ajajaminiin Mootii Waan Maraa duratti ciincaa yennaa dhikeessane du'ane. Isaan ijoollee hin qabanu. Tanaaf Ele'azaarii fi Itaamaar qofatti yennaa abbaan isaanii Aaron jiru hayyoota te'ee tajaajilane. ");
INSERT INTO gax_vpl VALUES ("NU3_5","005_3_5","NUM","3","5","5","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU3_6","005_3_6","NUM","3","6","6","«Gosa Lewwi'ii fidiitii, hayyicha Aaron akka qarqaaranuuf fuula isaa duratti dhikeessi. ");
INSERT INTO gax_vpl VALUES ("NU3_7","005_3_7","NUM","3","7","7","Isaan Dunkaanii Woldeenna'aa duratti isaa fi wolde'a gumi'ii duudi'iif, hujii dunkaanii dhugaa bayaa hujan. ");
INSERT INTO gax_vpl VALUES ("NU3_8","005_3_8","NUM","3","8","8","Isaan meya Dunkaanii Woldeenna'aa mara eegaa, hujii dunkaanii dhugaa bayaa keessaalle hujiisaan kolbaa Israa'elii tajaajilan. ");
INSERT INTO gax_vpl VALUES ("NU3_9","005_3_9","NUM","3","9","9","Lewwooti Israa'eloota keessaa Aaronii fi ilmaan isaatiif waan kennamaneef, ati Aaronii fi ilmaan isaatiif isaan kenni. ");
INSERT INTO gax_vpl VALUES ("NU3_10","005_3_10","NUM","3","10","10","Aaronii fi ilmaan isaa akka hujii hayyumma'aa hujanuuf ati isaan muudi. Nami dhibiin addee woyyittii bira yoo dhikaate ammoo ijjeefamuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU3_11","005_3_11","NUM","3","11","11","Mootiin Waan Maraa ammalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU3_12","005_3_12","NUM","3","12","12","«Kunoo ani Israa'eloota keessaa addee ilma angaficha kennansa fudhadhu, Israa'eloota mara keessaa ani Lewwoota fudhadheera. Tanaaf, Lewwooti kiyya. ");
INSERT INTO gax_vpl VALUES ("NU3_13","005_3_13","NUM","3","13","13","Ani Mootii Waan Maraa ti; angafooti marti kiyya waan te'aneef, ani biyya Gibxi'ii keessatti, angafoota worra Gibxootaa mara yennaa ijjeese, angafoota hori'iitii fi angafoota ijoollee Israa'elootaa mara akka isaan kiyya te'anu filadheera. Tanaaf Lewwooti kiyya te'aneeran» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU3_14","005_3_14","NUM","3","14","14","Mootiin Waan Maraa goomolee Siina'aa keessatti Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU3_15","005_3_15","NUM","3","15","15","«Lewwoota akka maatii maatii isaaniitii fi akka fira isaaniititti, dhiira dhalattee ji'a tokkootii fi ji'a tokko olii mara laakkowi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU3_16","005_3_16","NUM","3","16","16","Maarre Muuseen akkuma Mootiin Waan Maraa ajajetti isaan laakkowe. ");
INSERT INTO gax_vpl VALUES ("NU3_17","005_3_17","NUM","3","17","17","Maqaan ilmaan Lewwi'ii Gershoon, Qehaatii fi Meraari. ");
INSERT INTO gax_vpl VALUES ("NU3_18","005_3_18","NUM","3","18","18","Maqaan ilmaan Gershoonii akka fira fira isaaniititti Liibnii fi Shime'i. ");
INSERT INTO gax_vpl VALUES ("NU3_19","005_3_19","NUM","3","19","19","Maqaan ilmaan Qehaatii akka fira fira isaaniititti Amraam, Yizhaar, Hebroonii fi Uzii'el. ");
INSERT INTO gax_vpl VALUES ("NU3_20","005_3_20","NUM","3","20","20","Maqaan ilmaan Meraarii akka fira fira isaaniititti Maahilii fi Mushiis; isaan kun akka fira fira abbootii isaanii ta duriititti maatii Lewwootaa ti. ");
INSERT INTO gax_vpl VALUES ("NU3_21","005_3_21","NUM","3","21","21","Firri Liibniitii fi shime'ii sanyii Gershoonii ti. Isaan kun fira Gershoonotaa ti. ");
INSERT INTO gax_vpl VALUES ("NU3_22","005_3_22","NUM","3","22","22","Laakkossi dhiira isaanii ta dhalattee ji'a tokkootii fi ji'a tokkoo olii wolumatti 7,500. ");
INSERT INTO gax_vpl VALUES ("NU3_23","005_3_23","NUM","3","23","23","Firri Gershootaa dunkaanii dhugaa bayaatiin duuba karaa aduun seentu qubatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU3_24","005_3_24","NUM","3","24","24","Sooressi fira Gershoonotaa, Eliyaafii ilma Laa'elii ti. ");
INSERT INTO gax_vpl VALUES ("NU3_25","005_3_25","NUM","3","25","25","Ilmaan Gershoonotaa Dunkaanii Woldeenna'aa keessatti dunkaanii dhugaa bayaa, irbuusa isi'ii woliin, gollaa Dunkaanii Woldeenna'aa, ");
INSERT INTO gax_vpl VALUES ("NU3_26","005_3_26","NUM","3","26","26","gollaa badhinna dalleya keessaa, gollaa badhinna dalleya keessaa ka adaala dunkaanii dhugaa bayaatii fi addee ciinca'aa, wodaroota isi'ii, hujii waan kanaan wol qabatte maraayyuu eegiisaaf itti gaafatamummaa qaban. ");
INSERT INTO gax_vpl VALUES ("NU3_27","005_3_27","NUM","3","27","27","Amraam, Yizhaar, Hebroonii fi Uzii'el gosa Qehaatii ti; isaan kun maatii Qehaatii ti. ");
INSERT INTO gax_vpl VALUES ("NU3_28","005_3_28","NUM","3","28","28","Laakkossi dhiira isaanii ta dhalattee ji'a tokkootii fi ji'a tokkoo olii 8,600. Isaan kun addee woyyittii eegiisaaf itti gaafatamummaa qaban. ");
INSERT INTO gax_vpl VALUES ("NU3_29","005_3_29","NUM","3","29","29","Firri Qehaatii dunkaanii dhugaa bayaa gara kibbaatitti qabatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU3_30","005_3_30","NUM","3","30","30","Sooressi fira Qehaatii, ilma Uzii'elii Elzaafaan. ");
INSERT INTO gax_vpl VALUES ("NU3_31","005_3_31","NUM","3","31","31","Isaan kun Saanduqa Gondooro'oo, xarapheessaa, waan issaa irra keyanu, addee ciinca'aa, meya addee Woyyitti'ii ka isaan itti fayyadamanu, golla'aa fi hujii waan kanaan wol qabaatte mara eegiisaaf itti gaafatamummaa qaban. ");
INSERT INTO gax_vpl VALUES ("NU3_32","005_3_32","NUM","3","32","32","Ilmi Aaronii Ele'azaar sooressa bulchaa Lewwootaa ti; inni worra addee Woyyittii eegiisaaf itti gaafatantoota te'ane irratti muudame. ");
INSERT INTO gax_vpl VALUES ("NU3_33","005_3_33","NUM","3","33","33","Firri Maahiliitii fi Mushii fira Meraarii jala jiran; isaan kun fira Meraarii ti. ");
INSERT INTO gax_vpl VALUES ("NU3_34","005_3_34","NUM","3","34","34","Laakkossi dhiira isaanii ta dhalattee ji'a tokkootii fi ji'a tokkoo olii 6,200. ");
INSERT INTO gax_vpl VALUES ("NU3_35","005_3_35","NUM","3","35","35","Sooressi fira Meraarii ilma Abiihaayilii Zurii'el. Isaan dunkaanii dhugaa bayaa cinaa gara kaabaatiin qubatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU3_36","005_3_36","NUM","3","36","36","Ilmaan Meraarii mikikkila dunkaanii dhugaa bayaa, danqaraa, utubaa, miila utuba'aa, hujii waan kanaan wol qabate mara, ");
INSERT INTO gax_vpl VALUES ("NU3_37","005_3_37","NUM","3","37","37","utubaa badhinna dalleya keessaatitti naannowaneeranu, miila utubooti dhaabbatanu woliin, chikaala'aa fi wodaroo dunkaani'ii eegiisaaf muudamane. ");
INSERT INTO gax_vpl VALUES ("NU3_38","005_3_38","NUM","3","38","38","Muuseen, Aaronii fi ilmaan isaa dunkaanii dhugaa bayaa san karaa aduun baatuun Dunkaanii Woldeenna'aa dura gara ila boru'uutiin qubatanuu ti. Isaan Israa'eloota bakka bu'anee addee woyyittii eegiisaaf itti gaafatantoota. Nami dhibiin ka itti dhikaate ijjeefamuu ti. ");
INSERT INTO gax_vpl VALUES ("NU3_39","005_3_39","NUM","3","39","39","Muuse'ee fi Aaron akka Mootiin Waan Maraa isaan ajajetti Lewwoota keessaa akka fira fira isaaniititti worri laakkowane, dhiirti martinuu ta dhalattee ji'a tokkootii fi ji'a tokkoo olii wolumatti 22,000. ");
INSERT INTO gax_vpl VALUES ("NU3_40","005_3_40","NUM","3","40","40","Mootiin Waan Maraa Muuse'een, «Israa'eloota keessaa dhiira angafa ta ji'a tokkootii fi ji'a tokkoo olii mara laakkowiitii, maqaa maqa'aan galmeessi. ");
INSERT INTO gax_vpl VALUES ("NU3_41","005_3_41","NUM","3","41","41","Ani Mootii Waan Maraa ti; ati addee angafoota Israa'elootaa mara worra Lewwootaa, addee angafoota horii Israa'elootaa mara horii worra Lewwootaa naaf fuudhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU3_42","005_3_42","NUM","3","42","42","Maarre Muuseen akkuma Mootiin Waan Maraa isa ajaje Israa'eloota keessaa dhiira angafoota mara laakkowe. ");
INSERT INTO gax_vpl VALUES ("NU3_43","005_3_43","NUM","3","43","43","Dhiirti angafooti ta ji'a tokkootii fi ji'a tokkoo olii ka maqaa maqa'aan galmeeffamane wolumatti 22,273. ");
INSERT INTO gax_vpl VALUES ("NU3_44","005_3_44","NUM","3","44","44","Achiin duuba Mootiin Waan Maraa Muuse'etti dubbatee, ");
INSERT INTO gax_vpl VALUES ("NU3_45","005_3_45","NUM","3","45","45","«Ani Mootii Waan Maraa ti. Ati addee angafoota Israa'elootaa mara Lewwoota, addee angafoota horii Israa'elootaa mara angafoota horii Lewwootaa naaf fuudhi. Lewwooti kiyya te'anuu ti. ");
INSERT INTO gax_vpl VALUES ("NU3_46","005_3_46","NUM","3","46","46","Laakkossi dhiira angafoota Israa'elootaa dhibba lamaa fi torbaatamii sadiin laakkossa Lewwootaa caalan. Isaan kana wodiisaaf, ");
INSERT INTO gax_vpl VALUES ("NU3_47","005_3_47","NUM","3","47","47","tokko tokkoo isaaniitiif akka sheeqelii addee woyyitti'iititti, meetii sheeqelii shan shan fuudhi. Meetiin sheeqeliin tokko geraa diddama. ");
INSERT INTO gax_vpl VALUES ("NU3_48","005_3_48","NUM","3","48","48","Beesee Israa'eloota irraa fuudhiitii, marroo ilmaan angafoota Israa'elii 273 ka wodamuu qabanuu saniif Aaronii fi ilmaan isaatiif kenni!» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU3_49","005_3_49","NUM","3","49","49","Maarre Muuseen beesee ilmaan angafoota Israa'elootaa ka laakkossi isaanii Lewwoota caalee ka wodamiisaa san fuudhe. ");
INSERT INTO gax_vpl VALUES ("NU3_50","005_3_50","NUM","3","50","50","Beeseen inni Israa'eloota worra angafoota te'anee dhalatane irraa fuudhe, akka sheeqelii addee woyyitti'iititti meetiin tun gara kiiloogiraama 15.5 teeti. ");
INSERT INTO gax_vpl VALUES ("NU3_51","005_3_51","NUM","3","51","51","Muuseen akkuma Mootiin Waan Maraa isa ajajetti beesee isaan ittiin wodamane san Aaronii fi ilmaan isaatiif kenne. ");
INSERT INTO gax_vpl VALUES ("NU4_1","005_4_1","NUM","4","1","1","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("NU4_2","005_4_2","NUM","4","2","2","«Lewwoota keessaa ilmaan Qehaatii akka firaa fi maatii maatii isaaniititti, ");
INSERT INTO gax_vpl VALUES ("NU4_3","005_4_3","NUM","4","3","3","Dunkaanii Woldeenna'aa keessa tajaajiliisaaf dhiira dhuttu, ta woggaa soddomaa haga woggaa shantamaa mara laakkowi. ");
INSERT INTO gax_vpl VALUES ("NU4_4","005_4_4","NUM","4","4","4","Hujiin ilmaan Qehaatii Dunkaanii Woldeenna'aa keessatti waan irra caalaa woyyuu te'e eegiisa. ");
INSERT INTO gax_vpl VALUES ("NU4_5","005_4_5","NUM","4","5","5","Israa'elooti yennaa addee quttumaatii godaaniisaaf qophowanu, Aaronii fi ilmaan isaa ol seenanee gollaa Saanduqa Gondooro'oo ta dhugaa bayaa gollu fuudhanee Saanduqa Gondooro'oo sanitti maranuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_6","005_4_6","NUM","4","6","6","Achiin duuba gogaa hoolee galaanaa itti uffisanuu ti; woyaa bifi isi'ii guutumatti bifa cuquliisaa teete irra diriirsanee, muka rare'een ba'atanu addee isaaniititti galchanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_7","005_4_7","NUM","4","7","7","«Xarapheessaa daabboo Waaqa dura dhikaattu irra keyanu irra woyaa bifa cuquliisaa afanee, gabataa, qorii, muduunu'uu fi kobola kennansa daadhii woyni'ii ittiin dhikeessanu ka worqii irraa hujamane, daabboolle yennaa mara irra keyanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_8","005_4_8","NUM","4","8","8","Woyaa diintuu irra afanee, gogaa hoolee galaanaa irra buusanee, muka rare'een ba'atanu addee isaaniititti galchanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_9","005_4_9","NUM","4","9","9","«Woyaa bifa cuquliisaa teete san fuudhanee, waan issaa irra keyanuu fi ifa isi'ii woliin, qaraphaa issaa ittiin dhaanfanu, qorii daadha'aa, meya zayiti'iitii fi meya isi'ii maratti uffisanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_10","005_4_10","NUM","4","10","10","Achiin duuba isaan meya isi'ii mara woliin gogaa hoolee galaanaatiin maranee goongaa ittiin ba'atu irra keyanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_11","005_4_11","NUM","4","11","11","«Addee ciinca'aa ta worqii irraa hujante irralle woyaa bifa cuquliisaa afanee, gogaa hoolee galaanaatiin maranee, muka rare'een ba'atanu ka isi'iille addee isaaniititti galchanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_12","005_4_12","NUM","4","12","12","«Meya addee woyyitti'itti ittiin tajaajilanu mara fuudhanee, woyaa bifa cuquliisaa keessa keyanee, gogaa hoolee galaanaatiin maranee, goongaa ittiin ba'atanu irra keyanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_13","005_4_13","NUM","4","13","13","«Addee ciinca'aa ta sageettuu irraa hujante san irraa daadhaa haranee, woyaa dhiillee irra afanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_14","005_4_14","NUM","4","14","14","Achiin duuba meya addee ciinca'aatitti ittiin tajaajilanu mara, waan ibidda irratti bobeessanu, filaa foonii, akkaafaa, qorii dhiiga fiffixanu qabattu, addee ciinca'aa ta sageettuu irraa hujante san irra keyanuu ti. Isaan gogaa hoolee galaanaa irra buusanee, muka rare'een ba'atanu addee isaaniititti galchanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_15","005_4_15","NUM","4","15","15","«Yennaa addee quttumaatii ka'anu, Aaronii fi ilmaan isaa meya woyyichaa fi waan tajaajila kanaaf te'u mara itti uffisaneen duuba, ilmaan Qehaatii dhufanee ba'atanuu ti. Akka hin duune ammoo meya woyyicha san tuquu hin qabanu. Hujiin ilmaan Qehaatii Dunkaana Woldeenna'aatii fi waan Dunkaanii Woldeenna'aa keessaa ba'atiisa. ");
INSERT INTO gax_vpl VALUES ("NU4_16","005_4_16","NUM","4","16","16","«Ilmi Aaronii hayyichaa Ele'azaar, zayitii isse'ee, hixaana foolee tolu, kennansa midhaanii ka guyyaa maraa, zayitii muudaa, Dunkaanii Woyyitti'ii fi waan isii keessaa, meya isi'ii keessaa woyyicha mara eegiisaaf itti gaafatamummaa qaba» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU4_17","005_4_17","NUM","4","17","17","Ammalle Mootiin Waan Maraa Muuse'ee fi Aaronitti dubbatee, ");
INSERT INTO gax_vpl VALUES ("NU4_18","005_4_18","NUM","4","18","18","«Maatiin Qehaatii, fira Lewwi'ii keessaa hin godhina'a. ");
INSERT INTO gax_vpl VALUES ("NU4_19","005_4_19","NUM","4","19","19","Qehaatoti waan irra caalaa Woyyuu te'etti dhikaatanee akka hin duune, Aaronii fi ilmaan isaa addee woyyittii seenanee waan isaan godhiisa malanee fi waan isaan ba'atiisa malane itti mudhisanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU4_20","005_4_20","NUM","4","20","20","Ammoo isaan akka hin duuneef, waan woyyuu san yennaa diqqo'oofille ilaaliisaaf ol hin seenin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU4_21","005_4_21","NUM","4","21","21","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU4_22","005_4_22","NUM","4","22","22","«Gershoonota akka fira firaa fi maatii maatii isaaniititti laakkowi. ");
INSERT INTO gax_vpl VALUES ("NU4_23","005_4_23","NUM","4","23","23","Dhiira woggaa soddomaa haga woggaa shantamaa, ta Dunkaanii Woldeenna'aa keessa tajaajiliisaaf dandeettu mara laakkowi. ");
INSERT INTO gax_vpl VALUES ("NU4_24","005_4_24","NUM","4","24","24","«Tajaajilli fira Gershoonotaa ka hujiisaatii fi ba'atiisaa ka asii gadii kana: ");
INSERT INTO gax_vpl VALUES ("NU4_25","005_4_25","NUM","4","25","25","Isaan gollaa dunkaanii dhugaa bayaa, gollaa Dunkaanii Woldeenna'aa, irbuusa isi'iitii fi gogaa hoolee galaanaa ka irbuusa isi'ii gollu, gollaa gara seensuma Dunkaanii Woldeenna'aa, ");
INSERT INTO gax_vpl VALUES ("NU4_26","005_4_26","NUM","4","26","26","gollaa badhinna dalleya keessaa ka dunkaanii dhugaa bayaatii fi addee ciinca'aa marsu, wodaroota golla'aatii fi meya tajaajila waan kanaa mara ba'atiisa; isaan tajaajila meya kanaaf male mara godhan. ");
INSERT INTO gax_vpl VALUES ("NU4_27","005_4_27","NUM","4","27","27","Tajaajilli Gershoonotaa marti, ba'aan yookiin hujii dhibii hujiisi akka Aaronii fi ilmaan isaa isaanitti mudhisanetti hujanuu ti; waan isaan ba'atiisaaf itti gaafatamummaa qabanu isin isaanitti hima'a. ");
INSERT INTO gax_vpl VALUES ("NU4_28","005_4_28","NUM","4","28","28","Hujiin fira Gershoonii Dunkaanii Woldeenna'aa keessa tajaajilli isaanii kana. Hujii isaanii ilma Aaronii hayyichaa Itaamaaritti toowata. ");
INSERT INTO gax_vpl VALUES ("NU4_29","005_4_29","NUM","4","29","29","«Ilmaan Meraarii akka fira firaa fi akka maatii maatii isaaniititti, ");
INSERT INTO gax_vpl VALUES ("NU4_30","005_4_30","NUM","4","30","30","worra woggaa soddomaa haga woggaa shantamaa, ka Dunkaanii Woldeenna'aa keessa hujiisaaf dande'anu mara laakkowi. ");
INSERT INTO gax_vpl VALUES ("NU4_31","005_4_31","NUM","4","31","31","Dunkaanii Woldeenna'aa keessa wonni ba'atiisaaf itti gaafatamanu mikikkila dunkaanii dhugaa bayaa, danqaraa isi'ii woliin, utubaa isi'iitii fi miila isiin ittiin dhaabbatu, ");
INSERT INTO gax_vpl VALUES ("NU4_32","005_4_32","NUM","4","32","32","utubaa badhinna dalleya keessaa ka Dunkaanii Woldeenna'aatitti naannowaneeranu shafee utubooti sun ittiin dhaabbatanu woliin, chikaala dunkaani'ii, wodaroo dunkaani'ii, meya waan kanaa maraa fi waan tajaajila kanaan wol qabate mara ba'atiisa. Nami tokko tokkooyyuu waan inni ba'atiisa male itti himi. ");
INSERT INTO gax_vpl VALUES ("NU4_33","005_4_33","NUM","4","33","33","Tajaajilli fira Meraarii, toowannaa Itaamaarii ilma Aaronii hayyichaa jalatti, Dunkaanii Woldeenna'aa keessatti hujanu tana» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU4_34","005_4_34","NUM","4","34","34","Muuseen, Aaronii fi sooreyyiin wolde'a gumi'ii, sanyii Qehaatii akka fira fira isaaniitii fi akka maatii maatii isaaniititti, ");
INSERT INTO gax_vpl VALUES ("NU4_35","005_4_35","NUM","4","35","35","dhiira woggaa soddomaa haga woggaa shantamaa, ka Dunkaanii Woldeenna'aa keessa tajaajiliisaaf dande'anu mara laakkowane. ");
INSERT INTO gax_vpl VALUES ("NU4_36","005_4_36","NUM","4","36","36","Laakkossi isaanii akka fira fira isaaniititti 2,750. ");
INSERT INTO gax_vpl VALUES ("NU4_37","005_4_37","NUM","4","37","37","Isaan kun akkuma Mootiin Waan Maraa Muusee ajajetti, fira Qehaatotaa mara, worra Dunkaanii Woldeenna'aa keessa tajaajilanu, ka Muuse'ee fi Aaron laakkowane. ");
INSERT INTO gax_vpl VALUES ("NU4_38","005_4_38","NUM","4","38","38","Worri Gershoonotaa akka fira fira isaaniitii fi akka maatii maatii isaaniititti, ");
INSERT INTO gax_vpl VALUES ("NU4_39","005_4_39","NUM","4","39","39","dhiirti woggaa soddomaa haga woggaa shantamaa, ka Dunkaanii Woldeenna'aa keessa tajaajiliisaaf dande'anu marti laakkowamane. ");
INSERT INTO gax_vpl VALUES ("NU4_40","005_4_40","NUM","4","40","40","Worri akka fira fira isaaniitii fi akka maatii maatii isaaniititti laakkowame laakkossi isaanii 2,630. ");
INSERT INTO gax_vpl VALUES ("NU4_41","005_4_41","NUM","4","41","41","Isaan kun wolumatti fira Gershoonotaa ka Dunkaanii Woldeenna'aa keessa tajaajilane. Akkuma Mootiin Waan Maraa ajajetti Muuse'ee fi Aaron isaan laakkowane. ");
INSERT INTO gax_vpl VALUES ("NU4_42","005_4_42","NUM","4","42","42","Worri Meraarotaa akka fira fira isaaniitii fi akka maatii maatii isaaniititti, ");
INSERT INTO gax_vpl VALUES ("NU4_43","005_4_43","NUM","4","43","43","dhiirti woggaa soddomaa haga woggaa shantamaa, ka Dunkaanii Woldeenna'aa keessa tajaajiliisaaf dande'anu marti laakkowamane. ");
INSERT INTO gax_vpl VALUES ("NU4_44","005_4_44","NUM","4","44","44","Worri akka fira fira isaaniititti laakkowame laakkossi isaanii 3,200. ");
INSERT INTO gax_vpl VALUES ("NU4_45","005_4_45","NUM","4","45","45","Isaan kun wolumatti fira Meraarotaa ti. Akkuma Mootiin Waan Maraa Muusee ajajetti Muuse'ee fi Aaron isaan laakkowane. ");
INSERT INTO gax_vpl VALUES ("NU4_46","005_4_46","NUM","4","46","46","Maarre Muuseen, Aaronii fi sooreyyiin wolde'a gumi'ii, sanyii Lewwootaa akka fira fira isaaniitii fi akka maatii maatii isaaniititti, ");
INSERT INTO gax_vpl VALUES ("NU4_47","005_4_47","NUM","4","47","47","dhiira woggaa soddomaa haga woggaa shantamaa, ka hujii tajaajilaatii fi Dunkaanii Woldeenna'aa ba'atiisaa dande'anu mara laakkowane. ");
INSERT INTO gax_vpl VALUES ("NU4_48","005_4_48","NUM","4","48","48","Laakkossi isaanii 8,580. ");
INSERT INTO gax_vpl VALUES ("NU4_49","005_4_49","NUM","4","49","49","Akkuma Mootiin Waan Maraa Muusee ajajetti nami tokko tokkooyyuu, maan akka hujuu fi maan akka ba'atu itti himame. Akka kanaan isaan akkuma Mootiin Waan Maraa Muusee ajajetti laakkowamane. ");
INSERT INTO gax_vpl VALUES ("NU5_1","005_5_1","NUM","5","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU5_2","005_5_2","NUM","5","2","2","«Israa'elooti nama dhukkuba goga'aa farrisiisaa qabu, nama nafa hilaa isaa keessaa woy dhangala'u, nama reeffa tuqiisaan akka aadaa dhugeeffanna'aatitti qulqulluu hin te'in mara addee quttumaa keessaa akka baasanu ajaji. ");
INSERT INTO gax_vpl VALUES ("NU5_3","005_5_3","NUM","5","3","3","Addee quttumaa ta ani odduu isaanii le'u, akka isaan hin batteessine, worra qulqulluu hin te'in dhiiraa fi dubartii addee quttumaa keessaa alatti baasi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU5_4","005_5_4","NUM","5","4","4","Israa'elooti tana godhanee, addee quttuma keessaa alatti isaan baasane. Isaan akkuma Mootiin Waan Maraa Muusee ajaje godhane. ");
INSERT INTO gax_vpl VALUES ("NU5_5","005_5_5","NUM","5","5","5","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU5_6","005_5_6","NUM","5","6","6","«Ati Israa'elootaan, ‹Nami tokko dhiirti yookiin dubartiin ana Mootii Waan Maraatiif addatamiisa dhabiisaan nama dhibii yennaa yakke, nami sun yakkaamessa. ");
INSERT INTO gax_vpl VALUES ("NU5_7","005_5_7","NUM","5","7","7","Inni cubbuu huje san faaci'atuu ti. Yakkaa ifiitiif gatii guutuu kaffaluu ti; harka shan keessaa harka tokko itti dabaleelle, nama yakke saniif kennuu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_8","005_5_8","NUM","5","8","8","Namichi yakkame sun du'ee firri aanti'ii ka gatii san fuudhu yoo dhabame ammoo, gatiin kaffalamu sun ka ana Mootii Waan Maraa ti; korbeessa hoole'ee ka yakkaa namichi hujeef, gumaa cubbu'uutiif kennamu san woliin hayyichaaf kennamuu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_9","005_5_9","NUM","5","9","9","Kennansi woyyichi Israa'elooti fiddu marti, hayyichaaf kennamuu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_10","005_5_10","NUM","5","10","10","Wonni hayyichaaf kenname kama hayyichaa ti› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU5_11","005_5_11","NUM","5","11","11","Achiin duuba Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU5_12","005_5_12","NUM","5","12","12","«Ati Israa'elootaan, ‹Mootiin Waan Maraa: Dubartiin takka abbaa manaa ifiitiif addatamuu dhabiisaan ");
INSERT INTO gax_vpl VALUES ("NU5_13","005_5_13","NUM","5","13","13","nama dhibii woliin yoo ratte, waan kana dhirsi isi'ii ka hin dhaggine yoo te'e, nami isii dhagge yoo hin jiraatin, battummaan isi'iille yoo hin mudhatin, ");
INSERT INTO gax_vpl VALUES ("NU5_14","005_5_14","NUM","5","14","14","dhirsi isi'ii isii hinaafee mamee, isiin yoo battoottee jiraatte yookiin yoo hin battowin jiraatte, ");
INSERT INTO gax_vpl VALUES ("NU5_15","005_5_15","NUM","5","15","15","Namichi sun niitii ifii san gara hayyichaa geessuu ti. Marroo isi'iitiif kennansa barbaachisu bullaa garbu'uulle kiiloo tokko geessuu ti. Kennansi kun kennansa midhaanii ka marroo hinaaffa'aatiif dhikaatu, ka yakkaa qaabachiisu waan te'eef, inni zayitii ejersaatii fi hixaana itti hin naqin. ");
INSERT INTO gax_vpl VALUES ("NU5_16","005_5_16","NUM","5","16","16","« ‹Hayyichi dubartii san fidee, fuula Mootii Waan Maraa dura dhaabbachiisuu ti; ");
INSERT INTO gax_vpl VALUES ("NU5_17","005_5_17","NUM","5","17","17","achiin duuba bisaan woyyicha meya faaraatitti woraabee, dunkaanii dhugaa bayaa keessaa bukuu fuudhee bisaan sanitti naquu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_18","005_5_18","NUM","5","18","18","Hayyichi mataa dubartitti'ii irraa hagoogguu buusee, kennansa midhaanii ka yakkaa qaabachiisu, ka marroo hinaaffa'aatiif dhikeeffamu, harkatti qabachiisee, fuula Mootii Waan Maraa dura dhaabbachiisuu ti. Harka ifiititti bisaan hadhowaa abaarsa fidu qabatuu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_19","005_5_19","NUM","5","19","19","Achiin duuba hayyichi, dubartittii san kakachiisiisaan: Ati heerumtee abbaa manaa qadduun, nami dhibiin yoo si woliin hin rafin yookiin ati yoo hin battowin, bisaan hadhowaan abaarsa fidu kun si hin miidhin. ");
INSERT INTO gax_vpl VALUES ("NU5_20","005_5_20","NUM","5","20","20","Ati ammoo abbaa manaa keeti jala jiraataa isaaf addatamuu dhabiisaan, nama dhibii woliin rattee yoo ifi batteessitee jiraatte, ");
INSERT INTO gax_vpl VALUES ("NU5_21","005_5_21","NUM","5","21","21","hayyichi, dubartittii san kakuu abaarsaa kakachisiisaan: Mootiin Waan Maraa gadhaa keeti iitessee, gudeeda keeti huqqisee, kolbaa teeti oddu'utti ta abaarante si godhuu ti; ");
INSERT INTO gax_vpl VALUES ("NU5_22","005_5_22","NUM","5","22","22","bisaan abaarsa fidu kun nafa keeti keessa seenee gadhaa keeti iitessee, gudeeda keeti huqqisuu ti. « ‹Dubartittiille: ameen, ameen jettuu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_23","005_5_23","NUM","5","23","23","« ‹Hayyichi abaarsa kana kitaaba maramaa irratti barreessee, achiin duuba barreeffama san bisaan hadhowaa san keessatti dhiquu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_24","005_5_24","NUM","5","24","24","Bisaan hadhowaa abaarsa fidu san obaasuu ti; bisaan abaarsa fidu kun isii keessa seenee dhibee hantuu itti hin fida. ");
INSERT INTO gax_vpl VALUES ("NU5_25","005_5_25","NUM","5","25","25","Achiin duuba hayyichi kennansa midhaanii ka marroo hinaaffa'aatiif dhikaatu san dubartittii san harkaa fuudhee, fuula ana Mootii Waan Maraa duratti tachoosee, gara addee ciinca'aatitti dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_26","005_5_26","NUM","5","26","26","Achiin duuba hayyichi kennansa midhaanii ka yaadanno'oo san harka tokko fuudhee, addee ciinca'aa irratti gubuu ti. Saniin duuba inni akka dubartittiin bisaan san untu godhuu ti. ");
INSERT INTO gax_vpl VALUES ("NU5_27","005_5_27","NUM","5","27","27","Isiin yoo ifi batteessitee abbaa manaa ifiitiif addatamuu dhaddeertu teete, yennaa inni bisaan abaarsa fidu san isii obaasu, bisaan gadhaa isi'ii seenu sun dhibee hantuu isi'itti fidee, gadhaa isi'ii iitessee, gudeeda isi'ii huqqisee, isiin kolbaa ifii oddu'utti ta abaarante hin teeti. ");
INSERT INTO gax_vpl VALUES ("NU5_28","005_5_28","NUM","5","28","28","Dubartittiin ammoo yoo ifi hin batteessin teete, isiin hin miidhantu ijoolleelle deyuu hin dandeetti. ");
INSERT INTO gax_vpl VALUES ("NU5_29","005_5_29","NUM","5","29","29","« ‹Seerri marroo hinaaffa'aatiif kenname kana: Dubartittiin adoo abbaa manaa jala jirtuu seera irraa gortee, yoo ifi batteessite, ");
INSERT INTO gax_vpl VALUES ("NU5_30","005_5_30","NUM","5","30","30","yookiin yaadi hinaaffa'aa abbaa mana isi'iititti dhufee, inni yoo isii hinaafe, hayyichi dubartittii san ana Mootii Waan Maraa dura fiduu ti! Hayyichi akka seera kanaatitti isii irratti muummessuu ti! ");
INSERT INTO gax_vpl VALUES ("NU5_31","005_5_31","NUM","5","31","31","Abbaan manaa yakkaa akka hin qanne akkasitti hin beekkama; dubartittiin ammoo akka yakkaa ifiititti hin dhaggatti› jedhi!» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU6_1","005_6_1","NUM","6","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU6_2","005_6_2","NUM","6","2","2","«Ati kolbaa Israa'eliitiin, ‹Nami tokko dhiirti yookiin dubartiin ana Mootii Waan Maraatiif ifi adda baasiisaan, naazireticha te'iisaaf, waadaa yoo gale, ");
INSERT INTO gax_vpl VALUES ("NU6_3","005_6_3","NUM","6","3","3","daadhii woyni'ii irraa, untoo dhibii ta nama macheessitu irraa ifi eeggatuu ti; daadhii woyni'ii dhangaggoottuu yookiin untoo dhibii nama macheessitu hin unin. Cunfaa midhaan woyni'iille hin unin yookiin midhaan woyni'ii shawwee yookiin gogaa hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("NU6_4","005_6_4","NUM","6","4","4","Inni bara ana Mootii Waan Maraatiif ifi adda baase mara waan midhaan woyni'ii irraa hujame mara yookiin qollofa woyni'iituu hin nyaatin. ");
INSERT INTO gax_vpl VALUES ("NU6_5","005_6_5","NUM","6","5","5","« ‹Inni bara ana Mootii Waan Maraatiif ifi adda baasiisaaf waadaa gale mara rifeensa mataa ifii hin quxatin yookiin hin haadatin; haga barri inni ana Mootii Waan Maraatiif ifi adda baase muummowutti, inni woyyuu te'uu ti; rifeensa mataa ifii guddifatuu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_6","005_6_6","NUM","6","6","6","Inni bara ana Mootii Waan Maraatiif ifi adda baase mara reeffa namaatitti hin dhikaatin. ");
INSERT INTO gax_vpl VALUES ("NU6_7","005_6_7","NUM","6","7","7","Beessisi ana Mootii Waan Maraatiif adda ifi baasiisaa rifeensi mataa isaa irra waan jiruuf, abbaan yookiin haati, obboleessi yookiin obboleettiin isaa yoo du'anelle reeffatti dhikaatiisaan ifi hin batteessin. ");
INSERT INTO gax_vpl VALUES ("NU6_8","005_6_8","NUM","6","8","8","Bara ifi addaan baase mara inni ana Mootii Waan Maraatiif woyyoomeera. ");
INSERT INTO gax_vpl VALUES ("NU6_9","005_6_9","NUM","6","9","9","« ‹Nami tokko dedhuma isa biratti du'ee, rifeensa mataa isaa ka inni ittiin adda baye san yoo batteesse, guyyaa itti qulqulloomu, guyyaa torbeesso'oo rifeensa mataa ifii haadatuu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_10","005_6_10","NUM","6","10","10","Guyyaa saddeetesso'oo Dunkaanii Woldeenna'aa duratti ilmoolee saphaliisaa lama yookiin maddo'oo lama gara hayyichaa fiduu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_11","005_6_11","NUM","6","11","11","Inni reeffatti dhikaatiisaan waan cubbameef, hayyichi saphaliisa tokkocha kennansa sababa cubbu'uutiif dhikaatuuf, saphaliisa tokkocha ammoo kennansa gubamuuf dhikeessuu ti. Inni gaafuma san rifeensa mataa ifii deebisee adda baasuu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_12","005_6_12","NUM","6","12","12","Inni bara ifi adda baase san ana Mootii Waan Maraatiif ifi woyyoonsuu ti. Sababa yakka'aatiif korbeessa hoole'ee ka woggaa tokkoo fiduu ti. Inni waan battoweef, barri inni duri adda ifi baase ka qaraa sun hin laakkowamu. ");
INSERT INTO gax_vpl VALUES ("NU6_13","005_6_13","NUM","6","13","13","« ‹Seerri nama barri adda ifi baasiisi isaa dabaree ka asii gad jiru: Inni gara seensuma Dunkaanii Woldeenna'aa dura dhikeeffamuu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_14","005_6_14","NUM","6","14","14","Inni achitti kennansa ifii ana Mootii Waan Maraatiif: kennansa gubamuuf korbeessa hoole'ee buruusoo woggaa tokkoo ka fafa hin qanne tokkocha, kennansa araara cubbu'uutiif dhikaatu gorontii hoole'ee buruusoo ta woggaa tokkoo ta fafa hin qanne takkattii, kennansa tokkumma'aatiif korbeessa hoole'ee ka fafa hin qanne tokkocha, ");
INSERT INTO gax_vpl VALUES ("NU6_15","005_6_15","NUM","6","15","15","kennansa midhaaniitii fi kennansa daadhii woyni'ii ka isaan woliin dhikaatanu woliin, akkasuma daabboo uukoo hin qanne kollonjoo tokko, xaltaa bullaa dansa'aa ka zayiti'iin sukkuumamee fi bixee hephellittii uukoo hin qanne ta zayitiin irra dibante dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_16","005_6_16","NUM","6","16","16","« ‹Hayyichi waan kana maraa fuudhee, kennansa araara cubbu'uutiif dhikaatuu fi kennansa gubamu, ");
INSERT INTO gax_vpl VALUES ("NU6_17","005_6_17","NUM","6","17","17","korbeessa hoole'ee ka kennansa tokkumma'aatiif dhikaate san daabboo uukoo hin qanne kollonjoo tokko kennansa ifii ana Mootii Waan Maraatiif dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_18","005_6_18","NUM","6","18","18","Achiin duuba nami ana Mootii Waan Maraatiif adda baye sun rifeensa mataa ifii seensuma Dunkaanii Woldeenna'aa duratti haadatee, ibidda kennansi tokkumma'aa itti ciinceffamu keessa keyuu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_19","005_6_19","NUM","6","19","19","« ‹Achiin duuba, foon harka korbeessaa yennaa iffeelame, hayyichi daabboo uukoo hin qanne tokkoo fi bixee hephellittii uukoo hin qanne takkattii kollonjoo keessaa fuudhee, harka isaa keessa keyuu ti. ");
INSERT INTO gax_vpl VALUES ("NU6_20","005_6_20","NUM","6","20","20","Achiin duuba hayyichi waan kana kennansa tachoofamu ana Mootii Waan Maraatiif dhikeessuu ti. Kun martinuu cormi'ii fi luka korbeessaa ka kennansa addaa te'anetti dabalamanee qooda hayyichaa woyyicha te'an. Saniin duuba, nami adda baye sun daadhii woyni'ii unuu hin dande'a. ");
INSERT INTO gax_vpl VALUES ("NU6_21","005_6_21","NUM","6","21","21","« ‹Seerri nama ana Mootii Waan Maraatiif adda ifi baasiisaaf waadaa galee kana. Ammoo nami ana Mootii Waan Maraatiif adda baye sun waan kenniisaaf male caalaa kenniisaaf yoo waadaa gale, akkuma seera nama ana Mootii Waan Maraatiif adda bayeetitti, waadaa gale san muummessuu ti› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU6_22","005_6_22","NUM","6","22","22","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU6_23","005_6_23","NUM","6","23","23","«Ati Aaronii fi ilmaan isaatiin, ‹Dubbii asii gad jirtuun ilmaan Israa'elii eebbisa'a: ");
INSERT INTO gax_vpl VALUES ("NU6_24","005_6_24","NUM","6","24","24","« ‹Mootiin Waan Maraa isin eebbisu, isin eegu! ");
INSERT INTO gax_vpl VALUES ("NU6_25","005_6_25","NUM","6","25","25","« ‹Mootiin Waan Maraa fuula ifii isiniif issu, isin mararu! ");
INSERT INTO gax_vpl VALUES ("NU6_26","005_6_26","NUM","6","26","26","« ‹Mootiin Waan Maraa fuula ifii gara keessan deebifatu, nageya isiniif kennu!› jedhiin. ");
INSERT INTO gax_vpl VALUES ("NU6_27","005_6_27","NUM","6","27","27","«Maarre isaan maqaa kiyya waamanee kolbaa Israa'elii hin eebbisan, anille isaan hin eebbisa» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU7_1","005_7_1","NUM","7","1","1","Muuseen yennaa dunkaanii dhugaa bayaa dhaabee fixe, dunkaanii dhugaa bayaatii fi meya isi'ii mara, addee ciinca'aatii fi meya isi'ii mara zayitii ejersaa muudee woyyoonse. ");
INSERT INTO gax_vpl VALUES ("NU7_2","005_7_2","NUM","7","2","2","Achiin duuba sooressitooti Israa'elootaa ka worra laakkowameef itti gaafatantoota te'ane sooressitooti maatii maati'ii kennansa kennane. ");
INSERT INTO gax_vpl VALUES ("NU7_3","005_7_3","NUM","7","3","3","Isaan garreettaa geejjibaa ka itti uffifame jaa fi korommii kudhanii lama, sooreyyiin tokko tokkooyyuu korommii tokko tokko, akkasuma lama lama te'anee, garreettaa geejjibaa tokko tokko kennane; isaan kennansa kana dunkaanii dhugaa bayaa duratti dhikeessane. ");
INSERT INTO gax_vpl VALUES ("NU7_4","005_7_4","NUM","7","4","4","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU7_5","005_7_5","NUM","7","5","5","«Tajaajila Dunkaanii Woldeenna'aatiif kennansa kana sooreyyii irraa fuudhi; Lewwootaaf akkuma hujii isaaniititti isaaniif kenni» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU7_6","005_7_6","NUM","7","6","6","Maarre Muuseen garreettaa geejjibaatii fi korommii san Lewwootaaf kenne. ");
INSERT INTO gax_vpl VALUES ("NU7_7","005_7_7","NUM","7","7","7","Inni garreettaa geejjibaa lamaa fi korommii afur akkuma hujii isaaniititti worra Gershooniitiif kenne. ");
INSERT INTO gax_vpl VALUES ("NU7_8","005_7_8","NUM","7","8","8","Inni garreettaa geejjibaa afurii fi korommii saddeeti karaa ilma Aaronii hayyichaa Itaamaariitiin, akka tajaajila isaaniititti, worra Meraariitiif kenne. ");
INSERT INTO gax_vpl VALUES ("NU7_9","005_7_9","NUM","7","9","9","Worri Qahaatotaa ammoo meya woyyicha gurmuu ifii irratti waan ba'atanuuf, Muuseen garreettaa geejjibaatii fi korommii isaaniif hin kennine. ");
INSERT INTO gax_vpl VALUES ("NU7_10","005_7_10","NUM","7","10","10","Addeen ciinca'aa yennaa eebbifantu sooressitootille eebba isi'iitiif kennansa fidanee addee ciinca'aa duratti dhikeessane. ");
INSERT INTO gax_vpl VALUES ("NU7_11","005_7_11","NUM","7","11","11","Mootiin Waan Maraa Muuse'een, «Sooressitoota keessaa eebba addee ciinca'aatiif, guyyuma guyya'atti nami tokko kennansa ifii akka dhikeessu isaanitti himi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU7_12","005_7_12","NUM","7","12","12","Guyyaa qaraa kennansa ifii ka dhikeesse gosa Yihuda'aa keessaa, ilma Aminaadaabii Nahasoon; ");
INSERT INTO gax_vpl VALUES ("NU7_13","005_7_13","NUM","7","13","13","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_14","005_7_14","NUM","7","14","14","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_15","005_7_15","NUM","7","15","15","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_16","005_7_16","NUM","7","16","16","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_17","005_7_17","NUM","7","17","17","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Aminaadaabii Nahasoon dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_18","005_7_18","NUM","7","18","18","Guyyaa lammeesso'oo sooressi gosa Yisaakorii ilmi Zuwaarii Nataani'el kennansa ifii dhikeesse; ");
INSERT INTO gax_vpl VALUES ("NU7_19","005_7_19","NUM","7","19","19","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_20","005_7_20","NUM","7","20","20","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu, ");
INSERT INTO gax_vpl VALUES ("NU7_21","005_7_21","NUM","7","21","21","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokkoo fi buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_22","005_7_22","NUM","7","22","22","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_23","005_7_23","NUM","7","23","23","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Zuwaarii Nataani'el dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_24","005_7_24","NUM","7","24","24","Guyyaa sadeesso'oo sooressi gosa Zebuloonii ilmi Helonii Eliiyaab kennansa ifii dhikeesse; ");
INSERT INTO gax_vpl VALUES ("NU7_25","005_7_25","NUM","7","25","25","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_26","005_7_26","NUM","7","26","26","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_27","005_7_27","NUM","7","27","27","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_28","005_7_28","NUM","7","28","28","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_29","005_7_29","NUM","7","29","29","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Helonii Eliiyaab dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_30","005_7_30","NUM","7","30","30","Guyyaa arfeesso'oo sooressi gosa Ruubenii ilmi Shiide'urii Eliizur kennansa ifii dhikeesse; ");
INSERT INTO gax_vpl VALUES ("NU7_31","005_7_31","NUM","7","31","31","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_32","005_7_32","NUM","7","32","32","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_33","005_7_33","NUM","7","33","33","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_34","005_7_34","NUM","7","34","34","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_35","005_7_35","NUM","7","35","35","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Shiide'urii Eliizur dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_36","005_7_36","NUM","7","36","36","Guyyaa shaneesso'oo sooressi gosa Shimi'oonii ilmi Zuriishadaayii Shiilumii'el kennansa ifii dhikeesse; ");
INSERT INTO gax_vpl VALUES ("NU7_37","005_7_37","NUM","7","37","37","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_38","005_7_38","NUM","7","38","38","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_39","005_7_39","NUM","7","39","39","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_40","005_7_40","NUM","7","40","40","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_41","005_7_41","NUM","7","41","41","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Zuriishadaayii Shiilumii'el dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_42","005_7_42","NUM","7","42","42","Guyyaa jayeesso'oo sooressi gosa Gaadii ilmi Dewu'elii Elii'aasaaf kennansa ifii dhikeesse; ");
INSERT INTO gax_vpl VALUES ("NU7_43","005_7_43","NUM","7","43","43","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_44","005_7_44","NUM","7","44","44","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_45","005_7_45","NUM","7","45","45","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_46","005_7_46","NUM","7","46","46","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_47","005_7_47","NUM","7","47","47","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Dewu'elii Elii'aasaaf dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_48","005_7_48","NUM","7","48","48","Guyyaa torbeesso'oo sooressi gosa Efreemii ilmi Amiihudii Eliishaama kennansa ifii dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_49","005_7_49","NUM","7","49","49","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_50","005_7_50","NUM","7","50","50","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_51","005_7_51","NUM","7","51","51","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_52","005_7_52","NUM","7","52","52","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_53","005_7_53","NUM","7","53","53","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Amiihudii Eliishaama dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_54","005_7_54","NUM","7","54","54","Guyyaa saddeetesso'oo sooressi gosa Minaase'ee ilmi Phedaazurii Gamaali'el kennansa ifii dhikeesse; ");
INSERT INTO gax_vpl VALUES ("NU7_55","005_7_55","NUM","7","55","55","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_56","005_7_56","NUM","7","56","56","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_57","005_7_57","NUM","7","57","57","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_58","005_7_58","NUM","7","58","58","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_59","005_7_59","NUM","7","59","59","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Phedaazurii Gamaali'el dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_60","005_7_60","NUM","7","60","60","Guyyaa sagaleesso'oo sooressi gosa Beniyaaminii ilmi Gedewoonii Abiidaan kennansa ifii dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_61","005_7_61","NUM","7","61","61","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_62","005_7_62","NUM","7","62","62","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_63","005_7_63","NUM","7","63","63","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_64","005_7_64","NUM","7","64","64","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_65","005_7_65","NUM","7","65","65","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Gedewoonii Abiidaan dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_66","005_7_66","NUM","7","66","66","Guyyaa kudhaneesso'oo sooressi gosa Daanii ilmi Amiishadaayii Ahii'ezer kennansa ifii dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_67","005_7_67","NUM","7","67","67","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_68","005_7_68","NUM","7","68","68","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_69","005_7_69","NUM","7","69","69","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_70","005_7_70","NUM","7","70","70","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_71","005_7_71","NUM","7","71","71","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Amiishadaayii Ahii'ezer dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_72","005_7_72","NUM","7","72","72","Guyyaa kudhanii tokkeesso'oo sooressi gosa Asheerii ilmi Okraanii Fagi'el kennansa ifii dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_73","005_7_73","NUM","7","73","73","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_74","005_7_74","NUM","7","74","74","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_75","005_7_75","NUM","7","75","75","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_76","005_7_76","NUM","7","76","76","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_77","005_7_77","NUM","7","77","77","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Okraanii Fagi'el dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_78","005_7_78","NUM","7","78","78","Guyyaa kudhanii lammeesso'oo sooressi gosa Naftaalemii ilmi Enaanii Ahiira kennansa ifii dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_79","005_7_79","NUM","7","79","79","Kennansi inni dhikeesse gabataa meetii irraa hujame tokko akka sheeqelii addee woyyitti'iititti, ka sheeqelii dhibbaa fi soddoma madaaluu fi qorii boollittii meetii irraa hujante takka, akka sheeqelii addee woyyitti'iititti ta sheeqelii torbaatama madaaltu dhikeesse; isaan lamaanuu kennansa midhaanii bullaa dansaa zayitii ejersaatiin sukkuumanteen guutamaneeran. ");
INSERT INTO gax_vpl VALUES ("NU7_80","005_7_80","NUM","7","80","80","Girgiraa worqii irraa hujamee hixaanaan guutame tokko ka sheeqelii kudhan madaalu; ");
INSERT INTO gax_vpl VALUES ("NU7_81","005_7_81","NUM","7","81","81","kennansa gubamuuf dardara tokko, korbeessa hoole'ee tokko, buruusoo korbeessa hoole'ee tokko ka woggaa tokkoo; ");
INSERT INTO gax_vpl VALUES ("NU7_82","005_7_82","NUM","7","82","82","kennansa araara cubbu'uutiif dhikaatuuf korbeessa re'e'ee tokko; ");
INSERT INTO gax_vpl VALUES ("NU7_83","005_7_83","NUM","7","83","83","kennansa tokkumma'aatiif korommii lama, korbeeyyii hoole'ee shan, korbeeyyii re'e'ee shanii fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo shan. Kun kennansa ilmi Enaanii Ahiira dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU7_84","005_7_84","NUM","7","84","84","Gaafa addeen ciinca'aa muudante kennansi sooreyyiin Israa'elootaa, eebba isi'iitiif dhikeessane isaan kana: gabataa meetii irraa hujame kudhanii lama, qorii boollittii meetii irraa hujante kudhanii lama, girgiraa worqii hujame kudhanii lama; ");
INSERT INTO gax_vpl VALUES ("NU7_85","005_7_85","NUM","7","85","85","gabataan meetii irraa hujame sun tokko tokkoon isaatuu sheeqelii dhibbaa fi soddoma, qoriin meetii irraa hujante tokko tokkoon isi'iituu sheeqelii torbaatama madaalan; wolumatti meetiin meya kanaa akka sheeqelii addee woyyitti'iititti sheeqelii kuma lamaa fi dhibba afur madaalti. ");
INSERT INTO gax_vpl VALUES ("NU7_86","005_7_86","NUM","7","86","86","Girgiraa worqii irraa hujame kudhanii lama ka hixaanaan guutame, akka sheeqelii addee woyyitti'iititti tokko tokkoon isaaniituu sheeqelii kudhan madaalan; wolumatti worqiin girgiroota kanaa sheeqelii dhibbaa fi diddama madaalti. ");
INSERT INTO gax_vpl VALUES ("NU7_87","005_7_87","NUM","7","87","87","Kennansa midhaanii ka isaanii woliin wolumatti horiin ciinca'aaf dhikaate dardaroota kudhanii lama, korbeeyyii hoole'ee kudhanii lama, buruusoo korbeeyyii hoole'ee ta woggaa tokko tokkoo kudhanii lama; kennansa araara cubbu'uutiifille korbeeyyii re'e'ee kudhanii lama. ");
INSERT INTO gax_vpl VALUES ("NU7_88","005_7_88","NUM","7","88","88","Horiin ciincaa kennansa tokkumma'aatiif dhikaate wolumatti korommii diddamii afur, korbeeyyii hoole'ee jaatama, korbeeyyii re'e'ee jaatama, buruusoo korbeeyyii hoole'ee ta woggaa tokko tokkoo jaatama. Kennansi gaafa addeen ciinca'aa muudante, eebba isi'iitiif dhikeessane isaan kana. ");
INSERT INTO gax_vpl VALUES ("NU7_89","005_7_89","NUM","7","89","89","Muuseen Mootii Waan Maraa woliin dubbatiisaaf Dunkaanii Woldeenna'aa yennaa seene, qadaaddaa Saanduqa addee gumaan araara cubbu'uu irra keyamu ka dada ol-gubba'aa ta koola qaddu lamaan wodhakkaa jiru gubba'aa qoonqoo isatti dubbattu dhage'e. Mootiin Waan Maraa isatti dubbate. ");
INSERT INTO gax_vpl VALUES ("NU8_1","005_8_1","NUM","8","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU8_2","005_8_2","NUM","8","2","2","«Ati Aaroniin ‹Issaa torba waan issaa irra keyanu irra yennaa keettu, akka adaala waan issaa irra keyanu duratti ifanu keyi› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU8_3","005_8_3","NUM","8","3","3","Aaronille akkuma Mootiin Waan Maraa Muusee ajajetti, issaa san waan issaa irra keyanu fuula duratti akka ifanu keye. ");
INSERT INTO gax_vpl VALUES ("NU8_4","005_8_4","NUM","8","4","4","Wonni issaa irra keyanu akka fakkeenna Mootiin Waan Maraa Muuse'etti mudhisetti jalaa ka'ee haga qaccee isi'ii ta akka daraara'aatitti worqii tumante irraa hujameera. ");
INSERT INTO gax_vpl VALUES ("NU8_5","005_8_5","NUM","8","5","5","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU8_6","005_8_6","NUM","8","6","6","«Lewwoota odduu Israa'elootaatii fuudhiitii akka aadaa dhugeeffanna'aatitti isaan qulqulleessi. ");
INSERT INTO gax_vpl VALUES ("NU8_7","005_8_7","NUM","8","7","7","Isaan qulqulleessiisaaf, waan asii gad jiru kana godhi: bisaan ittiin qulqulloomanu itti fiffixi; achiin duuba akka isaan rifeensa nafa ifii duudii haadatanee woyaa ifiille dhiqatanee ifi qulqulleeffatanu isaanitti himi. ");
INSERT INTO gax_vpl VALUES ("NU8_8","005_8_8","NUM","8","8","8","Isaan dardara tokkoo fi kennansa midhaanii bullaa dansaa ta zayiti'iin sukkuumante ka isaan woliin dhikaatanu fidanuu ti; atille araara cubbu'uutiif dardara dhibii tokko fidi. ");
INSERT INTO gax_vpl VALUES ("NU8_9","005_8_9","NUM","8","9","9","Kolbaa Israa'elii duudii wolitti qabiitii, Dunkaanii Woldeenna'aa duratti Lewwoota dhikeessi! ");
INSERT INTO gax_vpl VALUES ("NU8_10","005_8_10","NUM","8","10","10","Yennaa ati Lewwoota fuula kiyya duratti dhikeessitu, Israa'elooti harka ifii mataa isaanii irra keyanuu ti! ");
INSERT INTO gax_vpl VALUES ("NU8_11","005_8_11","NUM","8","11","11","Lewwooti akka hujii tiyya hujanu Aaron Israa'eloota oddu'uu akka kennansa tachoofamuu fuula kiyya duratti isaan dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU8_12","005_8_12","NUM","8","12","12","Lewwooti harka ifii mataa dardara lamaanii san irra keyanuu ti; Aaron dardara tokko kennansa araara cubbu'uutiif dhikeessee, dardara kaanille Lewwootaaf gumaa cubbu'uu godhiisaaf kennansa gubamu ana Mootii Waan Maraatiif dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU8_13","005_8_13","NUM","8","13","13","«Worra Lewwootaa Aaronii fi ilmaan isaa dura dhaabbachiisiitii akka kennansa tachoofamuu fuula kiyya duratti dhikeessi. ");
INSERT INTO gax_vpl VALUES ("NU8_14","005_8_14","NUM","8","14","14","Karaa kanaan Lewwooti Israa'eloota kaan oddu'uu adda baasi; isaanille kiyya hin te'an. ");
INSERT INTO gax_vpl VALUES ("NU8_15","005_8_15","NUM","8","15","15","Ati isaan qulqulleessitee akka kennansa tachoofamuu dhikeessiteen duuba, isaan Dunkaanii Woldeenna'aa keessa tajaajiliisaaf ol seenanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU8_16","005_8_16","NUM","8","16","16","Israa'eloota keessaa isaan guutumatti naaf kennamaneeran; Israa'eloota mara keessaa angafa addee fudhadhu, Lewwoota fudhadheera. ");
INSERT INTO gax_vpl VALUES ("NU8_17","005_8_17","NUM","8","17","17","Ani yennaa angafa biyya Gibxi'ii keessaa mara ijjeese, ka worra Israa'elii adda baafadhe; tanaaf, Israa'eloota keessaa dhiira te'ee ka dhalate, angafi namaatii fi hori'iille kiyya. ");
INSERT INTO gax_vpl VALUES ("NU8_18","005_8_18","NUM","8","18","18","Ani addee ilmaan angafa Israa'elootaa mara fudhadhu, Lewwoota fudhadheera. ");
INSERT INTO gax_vpl VALUES ("NU8_19","005_8_19","NUM","8","19","19","Isaan Dunkaanii Woldeenna'aa keessa addee Israa'elootaa bu'anee akka tajaajilanuuf, Israa'elooti addee woyyitti'itti dhikaatanee balaan akka itti hin buune akka isaaniif araarsanuuf, ani Israa'eloota mara keessaa Lewwoota Aaronii fi ilmaan isaatiif kennansa godhee kenneera» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU8_20","005_8_20","NUM","8","20","20","Maarre Muuseen, Aaronii fi kolbaan Israa'elii duudiin akkuma Mootiin Waan Maraa Muusee ajajetti Lewwoota adda baasane. ");
INSERT INTO gax_vpl VALUES ("NU8_21","005_8_21","NUM","8","21","21","Lewwooti ifi qulqulloonsanee woyaa ifiille dhiqatane; achiin duuba Aaron akka kennansa tachoofamuu Mootii Waan Maraa duratti isaan dhikeessee, isaan qulqulleessiisaaf gumaa cubbu'uu isaaniif tolche. ");
INSERT INTO gax_vpl VALUES ("NU8_22","005_8_22","NUM","8","22","22","Saniin duuba Lewwooti sooressummaa Aaronii fi ilmaan isaatiin Dunkaanii Woldeenna'aa keessa tajaajila ifii tajaajiliisaaf ol seenane; kolbaan akkuma Mootiin Waan Maraa marroo Lewwootaa Muusee ajajetti waan mara isaaniif goote. ");
INSERT INTO gax_vpl VALUES ("NU8_23","005_8_23","NUM","8","23","23","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU8_24","005_8_24","NUM","8","24","24","«Wonni Lewwoota ilaalu asii gad jira; Dhiirti Lewwootaa ta woggaan isaanii diddamii shaniitii fi achii olii Dunkaanii Woldeenna'aa keessa tajaajiliisaaf dhufanuu ti; ");
INSERT INTO gax_vpl VALUES ("NU8_25","005_8_25","NUM","8","25","25","woggaan isaanii shantama yennaa guutte ammoo tajaajila ifii irraa hin foorfatan; achiin duuba hin tajaajilanu. ");
INSERT INTO gax_vpl VALUES ("NU8_26","005_8_26","NUM","8","26","26","Isaan tajaajila obboleeyyan isaanii Dunkaanii Woldeenna'aa keessa tajaajilanu obboleeyyan ifii qarqaaran malee, ifiif hujii hin hujanu. Akka kanatti itti gaafatamummaa worra Lewwootaa tarree galchita» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU9_1","005_9_1","NUM","9","1","1","Israa'elooti biyya Gibxi'iitii bayaneen duuba woggaa lammeesso'oo, ji'a tokkeesso'oo keessa, Mootiin Waan Maraa goomolee Siina'aa keessatti Muuse'etti dubbatee, ");
INSERT INTO gax_vpl VALUES ("NU9_2","005_9_2","NUM","9","2","2","«Israa'elooti Jila Irra Dabaramaa yennaa isi'ii eeganee jilifatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU9_3","005_9_3","NUM","9","3","3","Ji'uma kana guyyaa kudhanii arfeesso'ootitti, dimimmisa galgala yennaa isi'ii eegadha'aatii, akkuma seerataa fi sirna isi'iititti jilifadha'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU9_4","005_9_4","NUM","9","4","4","Maarre Muuseen akka isaan Jila Irra Dabaramaa jilifatanuuf Israa'elootatti hime. ");
INSERT INTO gax_vpl VALUES ("NU9_5","005_9_5","NUM","9","5","5","Israa'elootille akkuma Mootiin Waan Maraa Muusee ajajetti ji'a tokkeesso'oo keessa, guyyaa kudhanii arfeesso'oo dimimmisa galgala goomolee Siina'aa keessatti Jila Irra Dabaramaa jilifatane. ");
INSERT INTO gax_vpl VALUES ("NU9_6","005_9_6","NUM","9","6","6","Isaan keessaa namooti akka aadaa dhugeeffanna'aatitti reeffa namaa tuqiisaan battowane, gaafas worra kaan woliin Jila Irra Dabaramaa jilifatiisa hin dandeenne; isaan gaafasuma gara Muuse'eetii fi Aaronii dhufanee, ");
INSERT INTO gax_vpl VALUES ("NU9_7","005_9_7","NUM","9","7","7","«Nuuti reeffa namaa tuqiisaan battoonneerra; garuu Israa'eloota kaan woliin yennaa kennansi kennamu nuuti Mootii Waan Maraatiif kennansa akka hin dhikeessine maaf dhoogganna?» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU9_8","005_9_8","NUM","9","8","8","Muuseen deebisee, «Mootiin Waan Maraa marroo teessaniif waan jedhu haga dhage'utti, eegadha'a» isaaniin jedhe. ");
INSERT INTO gax_vpl VALUES ("NU9_9","005_9_9","NUM","9","9","9","Achiin duuba Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU9_10","005_9_10","NUM","9","10","10","«Ati Israa'elootaan, ‹Isin keessaa yookiin sanyii teessan keessaa worri reeffa namaa tuqiisaan battowe yoo jiraate yookiin yennaa Jila Irra Dabaramaa karaa fagoo deemiisatti jiru yoo jiraate, Jila Irra Dabaramaa jilifatiisa hin dande'an. ");
INSERT INTO gax_vpl VALUES ("NU9_11","005_9_11","NUM","9","11","11","Garuu ji'a lammeesso'oo, guyyaa kudhanii arfeesso'ootitti galgala dimimmisa jilifatanuu ti. Buruusoo korbeessa hoole'ee ka Jila Irra Dabaramaatiif qalame san daabboo uukoo hin qannee fi baala hadhowu woliin nyaatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU9_12","005_9_12","NUM","9","12","12","Isaan foon buruusoo korbeessa hoole'ee san haga boruyyaatitti hin hamburatin yookiin lafee isaalle hin cassin. Isaan yennaa Jila Irra Dabaramaa jilifatanu akka sirna Jila Irra Dabaramaatitti jilifatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU9_13","005_9_13","NUM","9","13","13","Ammoo nami akka aadaa dhugeeffanna'aatitti qulqulluu te'ee, karaa adoo hin ideemin Jila Irra Dabaramaa hin jilifatin hafe, kennansa Mootii Waan Maraatiif dhikeessu yennaa isaatitti waan hin dhikeessiniif, inni kolbaa ifii keessaa bawuu ti. Inni akka cubbuu ifiititti itti hin gaafatama. ");
INSERT INTO gax_vpl VALUES ("NU9_14","005_9_14","NUM","9","14","14","«‹Alagaan odduu teessan le'u Jila Irra Dabaramaa yoo jilifatuu barbaade, akka seerataa fi sirna Jila Irra Dabaramaatitti jilifatuu ti. Isin worra alaga'aatii fi worra dhalataa biyyaatiif seeraa fi sirna tokkochuma qabaadha'a› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU9_15","005_9_15","NUM","9","15","15","Gaafa dunkaaniin dhugaa bayaa dhaabbatte, duumensi dhufee isii golle. Duumensi sun galgalaa haga ganamaatitti ibidda fakkaataayyu. ");
INSERT INTO gax_vpl VALUES ("NU9_16","005_9_16","NUM","9","16","16","Gaafa mara akkasuma te'aa ture; duumensi sun dunkaanii dhugaa bayaa golle; inni halkan ibidda fakkaataayyu. ");
INSERT INTO gax_vpl VALUES ("NU9_17","005_9_17","NUM","9","17","17","Yennaa duumensi dunkaanii irraa ka'u mara Israa'elootille ka'anee deeman; addee duumensi bu'etti isaanille hin qubataniiyyu. ");
INSERT INTO gax_vpl VALUES ("NU9_18","005_9_18","NUM","9","18","18","Israa'elooti ajaja Mootii Waan Maraatiin ka'anee deemanee, ajaja Mootii Waan Maraatiin qubatan. Haga duumensi dunkaanii dhugaa bayaa gubbaa jiru, isaan quttumuma san keessa turan. ");
INSERT INTO gax_vpl VALUES ("NU9_19","005_9_19","NUM","9","19","19","Duumensi dunkaanii dhugaa bayaa irraa adoo hin ka'in guyyaa hedduu yennaa ture, Israa'elooti ajaja Mootii Waan Maraa eegatan malee, ka'anee hin deemanu. ");
INSERT INTO gax_vpl VALUES ("NU9_20","005_9_20","NUM","9","20","20","Yennaa tokko tokko duumensi guyyaa diqqaa qofa dunkaanii dhugaa bayaa irra tura; isaanille ajaja Mootii Waan Maraatiin addee quttuma ifii turan yookiin ajaja Mootii Waan Maraatiin ka'anee deeman. ");
INSERT INTO gax_vpl VALUES ("NU9_21","005_9_21","NUM","9","21","21","Yennaa tokko tokko duumensi sun galgalaa haga ganamaa qofa dunkaanii dhugaa bayaa irra tura; ganama yennaa duumensi sun dunkaanii dhugaa bayaa irraa ka'e, isaanille ka'anee deeman. Galgalalle te'u gamanalle duumensi dunkaanii dhugaa bayaa irraa yennaa ka'e mara isaanille ka'anee deeman. ");
INSERT INTO gax_vpl VALUES ("NU9_22","005_9_22","NUM","9","22","22","Duumensi sun dunkaanii dhugaa bayaa irra guyyaa lama yookiin ji'a tokko yookiin yennaa hedduu turulle, Israa'elooti adduma quttumaa turan malee, ka'anee hin deemanu; yennaa duumensi sun dunkaanii dhugaa bayaa irraa ka'e ammoo, isaanille ka'anee deeman. ");
INSERT INTO gax_vpl VALUES ("NU9_23","005_9_23","NUM","9","23","23","Isaan ajaja Mootii Waan Maraatiin qubatan; ajaja Mootii Waan Maraatiin ka'aneelle deeman; isaan ajaja Mootii Waan Maraa ka karaa Muuse'eetiin kenname hin eegataniiyyu. ");
INSERT INTO gax_vpl VALUES ("NU10_1","005_10_1","NUM","10","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU10_2","005_10_2","NUM","10","2","2","«Kolbaa wolitti waamiisaa fi addee quttumaatii ka'anee akka deemanu godhiisaaf meetii tumante irraa tultullaa lama huji. ");
INSERT INTO gax_vpl VALUES ("NU10_3","005_10_3","NUM","10","3","3","Yennaa tultullaan lamaanuu afuufamanu, kolbaan duudiin seensuma Dunkaanii Woldeenna'aatitti, si duratti wolitti qabamanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU10_4","005_10_4","NUM","10","4","4","Yennaa tultullaan tokkochi callaan afuufamu, sooreyyiin fira kolbaa Israa'elii callaan si duratti wolitti qabamanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU10_5","005_10_5","NUM","10","5","5","Yennaa tultullaan tokko qoonqoo guddo'oon afuufamu, gosi karaa aduun baatu qabatteertu kaatee ideentuu ti. ");
INSERT INTO gax_vpl VALUES ("NU10_6","005_10_6","NUM","10","6","6","Yennaa lammeesso'oo, tultullaan yennaa afuufamu, gosi gara kibbaa qubatteertu kaatee ideentuu ti. Guddittee afuufiisi, beessisa ka'anee deemiisaa ti. ");
INSERT INTO gax_vpl VALUES ("NU10_7","005_10_7","NUM","10","7","7","Kolbaa wolitti qabiisaaf, tultullaa afuufi; ammoo guddittee hin afuufin. ");
INSERT INTO gax_vpl VALUES ("NU10_8","005_10_8","NUM","10","8","8","«Ilmaan Aaronii hayyooti, tultullaa afuufanuu ti! Kun isiniif, dhaloota dhufuufille seerata bara baraa te'uu ti. ");
INSERT INTO gax_vpl VALUES ("NU10_9","005_10_9","NUM","10","9","9","Biyya teessan keessatti diinota isin cunqursanu loliisaaf yennaa duultanu, tultullaa guddisa'aatii afuufa'a; achiin duuba ana Mootii Waan Maraa Waaqa keessan biratti hin qaabatantan; diinota keessan jalalle'ee hin baatan. ");
INSERT INTO gax_vpl VALUES ("NU10_10","005_10_10","NUM","10","10","10","Akkasuma guyyaa gammadaa, yennaa jila beekkantee, yennaa baatii ji'aatitti, tultullaa kana kennansa gubamuu fi kennansa tokkumma'aa irratti afuufa'a; kun ana Waaqa keessan duratti yaadannoo isiniif hin te'a. Ani Mootii Waan Maraa Waaqa keessan» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU10_11","005_10_11","NUM","10","11","11","Kolbaan Israa'elii biyya Gibxi'iitii baateen duuba, woggaa lammeesso'oo, ji'a lammeesso'ootitti, guyyaa diddameesso'oo, duumensi dunkaanii dhugaa bayaa san irraa ka'e. ");
INSERT INTO gax_vpl VALUES ("NU10_12","005_10_12","NUM","10","12","12","Achiin duuba Israa'elooti goomolee Siina'aatii bayane, haga duumensi goomolee Phaaraanii keessatti dhaabbatutti ka'anee deemane. ");
INSERT INTO gax_vpl VALUES ("NU10_13","005_10_13","NUM","10","13","13","Akkuma Mootiin Waan Maraa karaa Muuse'eetiin ajajetti, yennaa jalqabaatiif ka'anee deemane. ");
INSERT INTO gax_vpl VALUES ("NU10_14","005_10_14","NUM","10","14","14","Goliin quttuma Yihuda'aa loltoota ifii woliin baandiraa ifii qabatanee dursanee deemane. Ajajaan isaanii ilma Aminaadaabii Nahasoon. ");
INSERT INTO gax_vpl VALUES ("NU10_15","005_10_15","NUM","10","15","15","Ajajaan loltoota gosa Yisaakorii, ilma Zuwaarii Nataani'el; ");
INSERT INTO gax_vpl VALUES ("NU10_16","005_10_16","NUM","10","16","16","ajajaan loltoota gosa Zebuloonii, ilma Helonii Eliiyaab. ");
INSERT INTO gax_vpl VALUES ("NU10_17","005_10_17","NUM","10","17","17","Achiin duuba dunkaaniin dhugaa bayaa buqqaatee, ilmaan Gershootaatii fi Meraarotaa worri dunkaanii dhugaa bayaa ba'ateerulle ka'anee deemane. ");
INSERT INTO gax_vpl VALUES ("NU10_18","005_10_18","NUM","10","18","18","Itti aananee, goliin quttuma gosa Ruubenii loltoota ifii woliin baandiraa ifii qabatanee bayane; ajajaan isaanii, ilma Shiide'urii Eliizur. ");
INSERT INTO gax_vpl VALUES ("NU10_19","005_10_19","NUM","10","19","19","Ajajaan gosa Shimi'oonii, ilma Zuriishadaayii Shiilumii'el. ");
INSERT INTO gax_vpl VALUES ("NU10_20","005_10_20","NUM","10","20","20","Ajajaan gosa Gaadii ilma Dewu'elii Elii'aasaaf. ");
INSERT INTO gax_vpl VALUES ("NU10_21","005_10_21","NUM","10","21","21","Achiin duuba Lewwooti fira Qehaatotaa meya woyyicha ba'atanee bayane; adoo isaan quttuma itti aanu hin geyin, dunkaaniin dhugaa bayaa dhaabante. ");
INSERT INTO gax_vpl VALUES ("NU10_22","005_10_22","NUM","10","22","22","Itti aananee, goliin quttuma gosa Efreemii loltoota ifii woliin baandiraa ifii qabatane bayane; ajajaan isaanii ilma Amiihudii Eliishaama'a. ");
INSERT INTO gax_vpl VALUES ("NU10_23","005_10_23","NUM","10","23","23","Ajajaan gosa Minaase'ee ilma Phedaazurii Gamaali'el; ");
INSERT INTO gax_vpl VALUES ("NU10_24","005_10_24","NUM","10","24","24","ajajaan gosa Beniyaamiille ilma Gedewoonii Abiidaan. ");
INSERT INTO gax_vpl VALUES ("NU10_25","005_10_25","NUM","10","25","25","Dhuma irratti goliin quttuma gosa Daanii ka karaa duubaatiin quttuma maraafuu eedduu te'ane, loltoota ifii woliin baandiraa ifii qabatanee bayane; ajajaan isaanii ilma Amiishadaayii Ahii'ezer. ");
INSERT INTO gax_vpl VALUES ("NU10_26","005_10_26","NUM","10","26","26","Ajajaan golii gosa Asheerii ilma Okraanii Fagi'el; ");
INSERT INTO gax_vpl VALUES ("NU10_27","005_10_27","NUM","10","27","27","ajajaan golii gosa Naftaalemiille ilma Enaanii Ahiira'a. ");
INSERT INTO gax_vpl VALUES ("NU10_28","005_10_28","NUM","10","28","28","Tarreen duulaa ta Israa'elooti golii goli'iin addee quttumaatii ka'anee ittiin deemane akka kana. ");
INSERT INTO gax_vpl VALUES ("NU10_29","005_10_29","NUM","10","29","29","Muuseen abbaa soddaa ifii ilma Ruubenii Miidiyaantichaa Habaabiin, «Nuuti addee Mootiin Waan Maraa, ‹Ani isiniif hin kenna› jedhe sanitti galiisaaf kaaneerra; atille nu woliin koy; Mootiin Waan Maraa waan dansaa Israa'eliif waadaa waan galeef, nuutille waan dansaa si'iif hin goona» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU10_30","005_10_30","NUM","10","30","30","Habaab deebisee, «Lakkii, ani hin deemu; ani gara biyya tiyyaatii fi kolbaa tiyyaa deebi'ee deemaara» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU10_31","005_10_31","NUM","10","31","31","Muuseen ammoo, «Maganne'ee nu biraa hin deebi'in! Goomolee keessa addee nuuti qubatuu dandeennu hin beetta; sooressa kara'aa nu'uuf teeta. ");
INSERT INTO gax_vpl VALUES ("NU10_32","005_10_32","NUM","10","32","32","Ati yoo nu woliin deente, nuuti waan dansaa Mootiin Waan Maraa nuu kennu san mara si woliin hin qoodanna» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU10_33","005_10_33","NUM","10","33","33","Maarre kolbaan gaara Mootii Waan Maraa gaara Siina'aatii kaatee guyyaa sad ideente. Saanduqi Gondooroo Mootii Waan Maraa addee isaan itti qubatanu isaaniif barbaadiisaaf guyyaa sadiin san isaaniin dura deeme. ");
INSERT INTO gax_vpl VALUES ("NU10_34","005_10_34","NUM","10","34","34","Yennaa isaan addee quttumaatii ka'anu, duumensi Mootii Waan Maraa guyyaa isaaniin gubbaarra deeme. ");
INSERT INTO gax_vpl VALUES ("NU10_35","005_10_35","NUM","10","35","35","Yennaa Saanduqi Gondooro'oo ka'ee deemu mara Muuseen, «Ee Mootii Waan Maraa, ka'i! Diinoti keeti bittinnowanuu ti; nyaaphoti keeti si duraa baqatanuu ti» jedhaayyu. ");
INSERT INTO gax_vpl VALUES ("NU10_36","005_10_36","NUM","10","36","36","Yennaa Saanduqi Gondooro'oo dhaabbatu mara Muuseen, «Ee Mootii Waan Maraa! Gara Israa'eloota kuma heddu'uu deebi'i» jedhaayyu. ");
INSERT INTO gax_vpl VALUES ("NU11_1","005_11_1","NUM","11","1","1","Kolbaan marroo rakkoo ifiitiif Mootii Waan Maraa irratti gungumiisa jalqadde. Mootiin Waan Maraa yennaa gungunsuu isaanii dhage'e, guddoo aare. Achiin duuba ibiddi Mootii Waan Maraa biraa odduu isaaniititti bobe'ee, quttuma isaanii mogguu takkaa gubee muxuqi godhe. ");
INSERT INTO gax_vpl VALUES ("NU11_2","005_11_2","NUM","11","2","2","Yennaa kolbaan gara Muuse'ee iyyite, inni gara Mootii Waan Maraa daadimatee, ibiddille dhaame. ");
INSERT INTO gax_vpl VALUES ("NU11_3","005_11_3","NUM","11","3","3","Ibiddi Mootii Waan Maraa odduu isaaniititti waan bobe'eef, maqaan addee sanii «Tabeeraa» jedhamee moggaafame. ");
INSERT INTO gax_vpl VALUES ("NU11_4","005_11_4","NUM","11","4","4","Worri biyya ormaa gariin ka Israa'eloota woliin jiranu, sagalee dhibii guddoo dharra'ane; Israa'elootille gungumanee, «Foon nyaannu adoo dhaggannee! ");
INSERT INTO gax_vpl VALUES ("NU11_5","005_11_5","NUM","11","5","5","Nuuti biyya Gibxi'ii keessatti gatii malee, qurxummii nyaannu, baaqulaa, waan baaqulaa fakkaatu ka dheedhii nyaatanu, waan goodarree fakkaatu, shunkurti'ii fi qullubbii qaabanne; ");
INSERT INTO gax_vpl VALUES ("NU11_6","005_11_6","NUM","11","6","6","amma ammoo halchaan nyaataa nurraa baddeerti; mannaa tana malee, waan tokkolle hin dhagginu» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU11_7","005_11_7","NUM","11","7","7","Mannaan waan midhaan dinbilaalaa fakkaatee, akka ceem'aa jiru. ");
INSERT INTO gax_vpl VALUES ("NU11_8","005_11_8","NUM","11","8","8","Kolbaan asii fi achi deentee qoccee, daaku'utti daatti yookiin mooyye'etti tunti. Achiin duuba isaan okkote'etti iffeelan yookiin bixee hephellittii bixisan. Mi'aan isi'iille akka bixee zayitii ejersaatiin bixifantee ti. ");
INSERT INTO gax_vpl VALUES ("NU11_9","005_11_9","NUM","11","9","9","Halkan fixeensi addee quttumaatitti yennaa bu'u, mannaan sun fixeensa woliin bu'a. ");
INSERT INTO gax_vpl VALUES ("NU11_10","005_11_10","NUM","11","10","10","Kolbaan akka maatii maatii ifiititti, seensuma dunkaanii ifii duratti gungumanuun Muuseen dhage'e. Achiin duuba Mootiin Waan Maraa guddoo aare; Muuseelle akka malee gaddee, ");
INSERT INTO gax_vpl VALUES ("NU11_11","005_11_11","NUM","11","11","11","Mootii Waan Maraatiin, «Maaniif rakkinna kana ana tajaajilaa keeti irratti fidde? Ani dokonkora maan hujee, ati ba'aa kolbaa tana maraa natti feete? ");
INSERT INTO gax_vpl VALUES ("NU11_12","005_11_12","NUM","11","12","12","Natti kolbaa tana mara ulfoyee deye moo? Ati maaniif, ‹Akka guddifattuu annuu habbaarattuu, isaan habbaaradhuutii biyya ani abbootii isaaniitiif kaku'uun waadaa galetti isaan galchi› naan jette? ");
INSERT INTO gax_vpl VALUES ("NU11_13","005_11_13","NUM","11","13","13","Isaan, ‹Foon nyaannu nuu kenni› jedhaa gara kiyya dhufanee natti bowan; isaan kana maraaf ani foon eessaa fuudha ree? ");
INSERT INTO gax_vpl VALUES ("NU11_14","005_11_14","NUM","11","14","14","Kolbaan tun akka ba'aa guddo'oo waan natti ulfaattuuf, ani qofii tiyya kolbaa tana mara ba'atiisa hin dande'u. ");
INSERT INTO gax_vpl VALUES ("NU11_15","005_11_15","NUM","11","15","15","Ati akkana yoo na gootu teete, ammuma ana ijjeesi! Ani si duratti fudhatama dhaggadhee yoo jiraadhe, farra na hin dhaggisiisin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU11_16","005_11_16","NUM","11","16","16","Mootiin Waan Maraa Muuse'een «Maanguddoo Israa'elii keessaa worra sooreyyi'ii fi qondaaltota kolba'aa te'uu isaanii beettu, nama torbaatama wolitti naa qabi. Akka isaan achi si bira dhaabbatanu gara Dunkaanii Woldeenna'aa fidi. ");
INSERT INTO gax_vpl VALUES ("NU11_17","005_11_17","NUM","11","17","17","Ani dhufee achitti si woliin hin dubbadha; Ayyaana si irra jiru irraa qoodee isaan irra hin keya; ati qofii teeti akka hin ba'anne isaanille ba'aa kolba'aa si hin qarqaaran» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU11_18","005_11_18","NUM","11","18","18","Ati ammalle kolba'aan, «Ka isin, ‹Biyya Gibxi'ii keessatti nutti toleeraayyu! Foon nyaannu adoo dhaggannee!› jettanee boottane Mootiin Waan Maraa dhage'eera; amma foon hin nyaataniitii, boruuf ifi woyyoonsa'a! Inni foon isiniif hin kenna; isinille foon hin nyaatan. ");
INSERT INTO gax_vpl VALUES ("NU11_19","005_11_19","NUM","11","19","19","Isin guyyaa tokko yookiin guyyaa lama yookiin guyyaa shan, guyyaa kudhan yookiin guyyaa diddama qofa hin nyaattanu; ");
INSERT INTO gax_vpl VALUES ("NU11_20","005_11_20","NUM","11","20","20","Ammoo isin Mootii Waan Maraa ka odduu teessan jiru jibbitanee, ‹Maaf biyya Gibxi'iitii baane?› jettanee waan isatti gunguntaneef, ji'a tokko guutuu, haga funnaaniin isin dhufutti, haga diqattanutti hin nyaattan» jedhi. ");
INSERT INTO gax_vpl VALUES ("NU11_21","005_11_21","NUM","11","21","21","Muuseen ammoo Mootii Waan Maraatiin, «Kunoo kolbaan na woliin jirtu, ta ati, ‹Ji'a guutuu foon isaaniif hin kenna› jettu, laakkossi loltoota miilaa 600,000. ");
INSERT INTO gax_vpl VALUES ("NU11_22","005_11_22","NUM","11","22","22","Adoo hoole'ee fi re'een, loonille karri duudiin isaaniif qalamanelle'ee isaan hin geyaa? Qurxummiin abbaayaa keessaa duudiin isaaniif yoo wolitti qabanelle isaan hin geettii?» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU11_23","005_11_23","NUM","11","23","23","Mootiin Waan Maraa deebisee, «Harki kiyya gabaaba'aa ree? Jechi kiyya akka te'uu fi hin teene ammuma hin dhaggita» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU11_24","005_11_24","NUM","11","24","24","Maarre Muuseen gad bayee waan Mootiin Waan Maraa jedhe kolba'atti hime. Inni maanguddoota torbaatama adaala dunkaani'iititti wolitti qabee dhaabbachiise. ");
INSERT INTO gax_vpl VALUES ("NU11_25","005_11_25","NUM","11","25","25","Achiin duuba Mootiin Waan Maraa duumensa keessa gad dhufee Muuse'etti dubbate. Inni Ayyaana Muuseen qabu irraa qoodee maanguddoota torbaatamaaf kenne. Yennaa Ayyaanni isaan irratti bu'e raaga dubbatane; ammoo itti deebi'anee raaga hin dubbanne. ");
INSERT INTO gax_vpl VALUES ("NU11_26","005_11_26","NUM","11","26","26","Maanguddoota torbaatama san keessaa lamaan Eldaadii fi Medaad, addee quttumaatitti hafane malee gara dunkaani'ii hin dhandhe. Te'uu malee, achuma addee quttumaa san keessatti Ayyaanni irratti bu'ee raaga dubbatane. ");
INSERT INTO gax_vpl VALUES ("NU11_27","005_11_27","NUM","11","27","27","Dargaggeessi tokko gara Muuse'ee rukkisee, «Eldaadii fi Medaad addee quttumaa keessatti raaga dubbatiisatti jiran» jedhee itti hime. ");
INSERT INTO gax_vpl VALUES ("NU11_28","005_11_28","NUM","11","28","28","Achiin duuba ilmi Nunii Iyaasuun, ka ijoollummaa ifiitii jalqabee qarqaraa Muuse'ee te'e, «Goottaa kiyya Muuse'e! Isaan dhooggi!» jedheen. ");
INSERT INTO gax_vpl VALUES ("NU11_29","005_11_29","NUM","11","29","29","Muuseen ammoo deebisee, «Ati naaf jettee hinaafaartaa? Kolbaan Mootii Waan Maraa martinuu adoo raagota te'anee, Mootiin Waan Maraa adoo Ayyaana ifii isaan irratti buusee, ani hin jaaladha!» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU11_30","005_11_30","NUM","11","30","30","Achiin duuba Muuse'ee fi maanguddooti Israa'elii sun gara addee quttumaa deebi'ane. ");
INSERT INTO gax_vpl VALUES ("NU11_31","005_11_31","NUM","11","31","31","Dedhuma Mootiin Waan Maraa qilleensa ergee abbaayaa irraa barbadi-kille oofee gara addee quttumaa fide; barbadi-killeen sun lafa irraa meetira tokkoo tuulamanee, addee quttumaatii fi adaala addee quttumaa san maddii maraanuu, haga ideensa guyyaa tokkoo guutane. ");
INSERT INTO gax_vpl VALUES ("NU11_32","005_11_32","NUM","11","32","32","Maarre kolbaan guyyaa sanii fi halkan san guutuu, guyyaa itti aanulle guutuu, barbadi-killee san qabatane; nami homerii kudhanii gad wolitti qabate hin jiru. Isaan goffatiisaaf adaala addee quttumaa san duudi'itti afane. ");
INSERT INTO gax_vpl VALUES ("NU11_33","005_11_33","NUM","11","33","33","Ammoo foon san adoo nyaatiisatti jiranuu, Mootiin Waan Maraa kolba'atti aaree, balaa guddaa isaanitti fide. ");
INSERT INTO gax_vpl VALUES ("NU11_34","005_11_34","NUM","11","34","34","Tanaaf, worra sagalee dhibii dharra'e waan achitti awwaalaneef, maqaa addee sanii «Qibrot-Hatawaa» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU11_35","005_11_35","NUM","11","35","35","Kolbaan Qirot-Hatawa'aa kaatee, Haseroot dhaxxee qubate. ");
INSERT INTO gax_vpl VALUES ("NU12_1","005_12_1","NUM","12","1","1","Muuseen intala worra Itoophiya'aa waan fuudheef, Miiryaamii fi Aaron isa irratti ka'anee, ");
INSERT INTO gax_vpl VALUES ("NU12_2","005_12_2","NUM","12","2","2","«Mootiin Waan Maraa karaa Muuse'ee qofaan dubbateeraa? Inni karaa keennalle'een dubbateeraa motii?» jedhane. Mootiin Waan Maraa waan isaan jedhane dhage'e. ");
INSERT INTO gax_vpl VALUES ("NU12_3","005_12_3","NUM","12","3","3","Muuseen namoota lafa irra jiranu mara caalaa, gadhi-laafessa. ");
INSERT INTO gax_vpl VALUES ("NU12_4","005_12_4","NUM","12","4","4","Dedhuma Mootiin Waan Maraa Muuse'een, Aaronii fi Miiryaamiin, «Isin sadiinuu gara Dunkaanii Woldeenna'aa kowaa» jedhe. Maarre isaan sadiinuu dhaqane. ");
INSERT INTO gax_vpl VALUES ("NU12_5","005_12_5","NUM","12","5","5","Achiin duuba Mootiin Waan Maraa utubaa duumensa keessa gad bu'ee, seensuma dunkaani'ii irra dhaabbatee, Aaronii fi Miiryaam waame. Isaan lamaanuu gara duraa yennaa dhufane, ");
INSERT INTO gax_vpl VALUES ("NU12_6","005_12_6","NUM","12","6","6","inni isaaniin, «Amma jecha kiyya dhage'a'a! Raagaan tokko odduu teessan yoo jiraate, ani mudhi'iin isatti ifi mudhisa; oojjuulle'een isatti hin dubbadha. ");
INSERT INTO gax_vpl VALUES ("NU12_7","005_12_7","NUM","12","7","7","Muusee tajaajilaa kiyya woliin ammoo akkas hin dubbadhu; inni mana kiyya mara keessatti addatama'a. ");
INSERT INTO gax_vpl VALUES ("NU12_8","005_12_8","NUM","12","8","8","Ani isa woliin ifatti, fuula duratti dubbadha malee, hiibbo'oonii moti; inni akka akki kiyya jiruuyyuu hin dhagga! Isin attam tajaajilaa kiyya Muusee irratti dubbatiisa sodaatuu dhaddane?» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU12_9","005_12_9","NUM","12","9","9","Mootiin Waan Maraa guddoo isaanitti aaree isaan biraa deeme. ");
INSERT INTO gax_vpl VALUES ("NU12_10","005_12_10","NUM","12","10","10","Yennaa duumensi dunkaanii irraa ka'e, Miiryaamiin dhukkuba goga'aa farrisiisa'aan qabantee adii akka dhakaa bokkeyaa teete. Aaron garagalee Miiryaam yennaa ilaale, isiin dhukkuba goga'aa farrisiisa'aan qabanteertuun dhagge. ");
INSERT INTO gax_vpl VALUES ("NU12_11","005_12_11","NUM","12","11","11","Achiin duuba Aaron Muuse'een, «Maganne'e, goottaa kiyya, cubbuu nuuti gowwumma'aan hunye tana nutti hin laakkowin. ");
INSERT INTO gax_vpl VALUES ("NU12_12","005_12_12","NUM","12","12","12","Akka finna adoo hin dhalatin du'ee, shamiisatti jiruun gadaamessa haadhaa keessaa bayuu, isii hin tolchin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU12_13","005_12_13","NUM","12","13","13","Maarre Muuseen gara Mootii Waan Maraa iyyee, «Ee, Waaqa, isii fayyis!» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU12_14","005_12_14","NUM","12","14","14","Mootiin Waan Maraa Muuse'een, «Abbaan isi'iituu fuula isi'iititti yoo tufe, isiin guyyaa torba hin fokkifattii motii? Maarre isiin guyyaa torba addee quttumaatii baatuu ti; achiin duuba deebi'uu hin dandeetti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU12_15","005_12_15","NUM","12","15","15","Maarre Miiryaam addee quttumaatii baatee guyyaa torba turte; haga isiin deebitutti kolbaalle addee quttumaatii hin tachoone. ");
INSERT INTO gax_vpl VALUES ("NU12_16","005_12_16","NUM","12","16","16","Achiin duuba kolbaan sun Haserootii kaatee goomolee Phaaraanii keessa qubatte. ");
INSERT INTO gax_vpl VALUES ("NU13_1","005_13_1","NUM","13","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU13_2","005_13_2","NUM","13","2","2","«Lafa Kana'aanii ta ani Israa'elootaaf kennu san dhaqanee akka dooyanuuf, gosa Israa'elii kudhanii lamaanuu keessaa sooressa tokko tokko filii ergi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU13_3","005_13_3","NUM","13","3","3","Maarre Muuseen akka ajaja Mootii Waan Maraatitti goomolee lafa Phaaraanii keessaa isaan erge; isaan martinuu sooreyyii Israa'elootaa ti. ");
INSERT INTO gax_vpl VALUES ("NU13_4","005_13_4","NUM","13","4","4","Maqaan isaanii ka asii gad jiru kana: Gosa Ruubenii keessaa, Shamaa'uu ilma Zaakurii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_5","005_13_5","NUM","13","5","5","gosa Shimi'oonii keessaa, Shaafaatii ilma Horii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_6","005_13_6","NUM","13","6","6","gosa Yihuda'aa keessa, Kaalebii ilma Yofunee ti; ");
INSERT INTO gax_vpl VALUES ("NU13_7","005_13_7","NUM","13","7","7","gosa Yisaakorii keessaa, Yigaalii ilma Yoseefii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_8","005_13_8","NUM","13","8","8","gosa Efreemii keessaa, Hose'aa ilma Nunii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_9","005_13_9","NUM","13","9","9","gosa Beniyaaminii keessaa, Phaaltii ilma Raafuu ti; ");
INSERT INTO gax_vpl VALUES ("NU13_10","005_13_10","NUM","13","10","10","gosa Zebuloonii keessaa, Gaadi'elii ilma Sodii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_11","005_13_11","NUM","13","11","11","gosa Minaase'ee gosa Yoseefii keessaa, Gadii ilma Susii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_12","005_13_12","NUM","13","12","12","gosa Daanii keessaa, Amii'elii ilma Gemaalii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_13","005_13_13","NUM","13","13","13","gosa Asheerii keessaa, Sexurii ilma Mikaa'elii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_14","005_13_14","NUM","13","14","14","gosa Naftaalemii keessaa, Nahibii ilma Wofsii ti; ");
INSERT INTO gax_vpl VALUES ("NU13_15","005_13_15","NUM","13","15","15","gosa Gaadii keessaa, Gewu'elii ilma Maakii ti. ");
INSERT INTO gax_vpl VALUES ("NU13_16","005_13_16","NUM","13","16","16","Maqaan namoota Muuseen akka dhaqanee lafa san dooyanuuf erge isaan kana; Muuseen Hose'aa ilma Nuii, «Iyaasuu» jedhee maqaa moggaase. ");
INSERT INTO gax_vpl VALUES ("NU13_17","005_13_17","NUM","13","17","17","Muuseen lafa Kana'aanii akka dooyanuuf yennaa isaan erge, «Karaa kibba Kana'aaniitiin gara biyya koobitti'ii ol baya'aatii, ");
INSERT INTO gax_vpl VALUES ("NU13_18","005_13_18","NUM","13","18","18","latti sun attam akka jirtu, kolbaan achi keessaa jajjadduu yookiin dadhadduu, hedduu yookiin diqqoo akka teete, ");
INSERT INTO gax_vpl VALUES ("NU13_19","005_13_19","NUM","13","19","19","latti isaan keessa le'anu dansaa yookiin badduu akka teete, qachaan isaan keessa le'anu ka dalleya hin qanne yookiin ka dalleya dhaka'aa qabu akka te'e, ");
INSERT INTO gax_vpl VALUES ("NU13_20","005_13_20","NUM","13","20","20","lattille jiituu yookiin godduu akka teete, muki akka irra jiruu fi hin jirre ilaala'a. Itti jabaadha'aatii, midhaan lafa sanii keessaa garii fida'a» jedhe. Yennaan sun yennaa midhaan woyni'ii ka qaraa bilchaatu. ");
INSERT INTO gax_vpl VALUES ("NU13_21","005_13_21","NUM","13","21","21","Maarre isaanille ol bayanee goomolee Ziiniitii kaasane haga Rehoobii, ta seensuma qachaa Haamaatitti dhikoo jirtuu dooyane. ");
INSERT INTO gax_vpl VALUES ("NU13_22","005_13_22","NUM","13","22","22","Isaan karaa Negebiitiin, addee sanyiin Aanaaqotaa gosi Ahimaanii, gosi Sheshaayiitii fi gosi Talmaayii le'anu gara Hebroonii dhufane. Hebroon qachaan biyya Gibxi'ii keessaa Zo'aan adoo hin ijaaraminiin dura woggaa torbaan dura ijaarante. ");
INSERT INTO gax_vpl VALUES ("NU13_23","005_13_23","NUM","13","23","23","Isaan dhooqa Eshikolii yennaa geyane, unkuruura midhaan woyni'ii muranee, wodhakkaa isaan lamaaniititti danqaraa irra keyanee gurmuu irratti ba'atanee, midhaan muka Rumaaniitii fi harru'uu woliin fidane. ");
INSERT INTO gax_vpl VALUES ("NU13_24","005_13_24","NUM","13","24","24","Israa'elooti unkuruura midhaan woyni'ii achii waan murataneef, addee san, «Dhooqa Eshikolii» jedhanee moggaasane. ");
INSERT INTO gax_vpl VALUES ("NU13_25","005_13_25","NUM","13","25","25","Isaan guyyaa afurtamaaf lafa san dooyanee deebi'anee, ");
INSERT INTO gax_vpl VALUES ("NU13_26","005_13_26","NUM","13","26","26","Qaadeshitti goomolee Phaaraanii keessatti gara Muuse'ee, gara Aaroniitii fi gara kolbaa Israa'elii duudi'ii dhufanee waan dhaggane wolde'a duudi'itti himanee, midhaan lafa saniille isaanitti mudhisane. ");
INSERT INTO gax_vpl VALUES ("NU13_27","005_13_27","NUM","13","27","27","Isaan Muuse'een, «Nuuti lafa ati itti nu ergite san dhandheerra; isiin lafa aananii fi dammaa ti; midhaan lafa saniille kunoo ti. ");
INSERT INTO gax_vpl VALUES ("NU13_28","005_13_28","NUM","13","28","28","Garuu kolbaan lafa san keessa leetu jajjaddu'u; qachooti isaaniille akka malee gugurdaa ka dalleya dhaka'aa qabanu; nuuti sanyii Aanaaqotaalle achitti dhaggineerra. ");
INSERT INTO gax_vpl VALUES ("NU13_29","005_13_29","NUM","13","29","29","Worri Amaaleqootaa lafa kibba Kana'aanii keessa le'an; worri Heetotaa, worri Yibusootaatii fi Amoorotaa biyya Koobittii keessa le'an; worri Kana'aanotaa qarqara abbaayaa Mediteraaniya'aatii fi laga Yordaanosii le'an» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU13_30","005_13_30","NUM","13","30","30","Achiin duuba Kaaleb kolbaa Muusee duratti cadhisiisee, «Nuuti isaan injifatiisa waan dandeennuuf, ammuma dhandhee lafa san qabannuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU13_31","005_13_31","NUM","13","31","31","Namooti Kaaleb woliin dhaqane ammoo, «Isaan nu caalaa worra jajjaba waan te'aneef, nuuti isaan loliisaaf hin dandeennu» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU13_32","005_13_32","NUM","13","32","32","Maarre isaan marroo lafa dhaqanee dooyanee oduu gadhee odeessanee, «Latti nuuti dhandhee dooyanne sun, lafa worra isii keessa le'iisaaf dhaqu fixxu; kolbaan nuuti achitti dhaggine martinuu dhedheertu'u. ");
INSERT INTO gax_vpl VALUES ("NU13_33","005_13_33","NUM","13","33","33","Nuuti achitti namoota hojja'aa fi hunnaan nama caalanu sanyii Aanaaqotaa Nefiliim dhaggineerra; nuuti yennaa ifi ilaallu korophiisa ifitti fakkaanne; isaanille'etti akkasuma fakkaanne» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU14_1","005_14_1","NUM","14","1","1","Halkan san guutuu kolbaan duudiin qoonqoo ol qabattee bootte. ");
INSERT INTO gax_vpl VALUES ("NU14_2","005_14_2","NUM","14","2","2","Israa'elooti marti Muuse'ee fi Aaron irratti gungumanee, wolde'i marti isaaniin, «Biyya Gibxi'ii keessatti yookiin as goomolee keessatti adoo dhumannee jiraannee nuu woyyaayyu! ");
INSERT INTO gax_vpl VALUES ("NU14_3","005_14_3","NUM","14","3","3","Mootiin Waan Maraa maaniif akka shallaaga'aan dhumannu lafa tana nu fide? Dubartooti teennaa fi ijoolleen teenna hin fudhatan. Gara biyya Gibxi'ii deebi'uu nuu hin woyyuu?» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU14_4","005_14_4","NUM","14","4","4","Maarre isaan, «Kowa'a, sooressa filannee, gara biyya Gibxi'ii deebinaa!» woliin jedhane. ");
INSERT INTO gax_vpl VALUES ("NU14_5","005_14_5","NUM","14","5","5","Achiin duuba Muuse'ee fi Aaron wolde'a kolbaa Israa'elii mara duratti fuulaan lafatti gad gombifamane. ");
INSERT INTO gax_vpl VALUES ("NU14_6","005_14_6","NUM","14","6","6","Worra lafa dooyane san keessaa lamaan, ilmi Nunii Iyaasu'uu fi ilmi Yofune'ee Kaaleb gaddanee woyaa ifi irratti tarsaasanee, ");
INSERT INTO gax_vpl VALUES ("NU14_7","005_14_7","NUM","14","7","7","Wolde'a kolbaa Israa'elii duudi'iin, «Latti nuuti dooyiisaaf keessa ideenne guddoo dansa'a. ");
INSERT INTO gax_vpl VALUES ("NU14_8","005_14_8","NUM","14","8","8","Mootiin Waan Maraa yoo nutti gammade, lafa aananii fi dammaa tana nuuf kennee itti nu hin galcha. ");
INSERT INTO gax_vpl VALUES ("NU14_9","005_14_9","NUM","14","9","9","Isin callaan Mootii Waan Maraa irratti hin ka'inaa malee, nuuti akka daabbo'oo isaan waan liqinsinuuf, kolbaa biyya sanii hin sodaatina'a. Gaaddisi isaanii isaan irraa deemeera; nu woliin ammoo Mootiin Waan Maraa hin jira; isaan hin sodaatina'a» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU14_10","005_14_10","NUM","14","10","10","Ammoo wolde'i sun duudiin dhaka'aan isaan tumiisaaf dudubbatane. Achiin duuba dedhuma ulfinni Mootii Waan Maraa Dunkaanii Woldeenna'aatitti Israa'eloota maratti mudhate. ");
INSERT INTO gax_vpl VALUES ("NU14_11","005_14_11","NUM","14","11","11","Mootiin Waan Maraa Muuse'een, «Kolbaan tun haga Yoomii na tuffatti? Adoo ani bilbaasa odduu isaaniititti tolchiisatti jiruu, haga yoomii natti dhugeeffatuu didan? ");
INSERT INTO gax_vpl VALUES ("NU14_12","005_14_12","NUM","14","12","12","Ani balaa itti buusee isaan hin balleessa; si ammoo kolbaa isaan caaltuu fi isaan caalaa jabaattuuf abbaa hin godha» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU14_13","005_14_13","NUM","14","13","13","Muuseen ammoo Mootii Waan Maraatiin, «Ati hunna teetiin kolbaa tana biyya Gibxi'ii keessaa waan baatteef, Worri biyya Gibxi'ii waan ati kolbaa tana goote hin dhage'an. ");
INSERT INTO gax_vpl VALUES ("NU14_14","005_14_14","NUM","14","14","14","Worra lafa tana keessa le'utti hin himan. Ee Mootii Waan Maraa, ati fuula duratti mudhattee, kolbaa tana odduu akka jirtu, duumensi keeti isaaniin gubbaa akka jiru, ati guyyaa utubaa duumensaatiin, halkan utubaa ibiddaatiin isaaniin dura akka ideente duruu dhage'aneeran. ");
INSERT INTO gax_vpl VALUES ("NU14_15","005_14_15","NUM","14","15","15","Ati amma yennuma tokkotti kolbaa tana duudii yoo ijjeette, gosi biyya adda addaa ta gurra keeti dhageetteertu, ");
INSERT INTO gax_vpl VALUES ("NU14_16","005_14_16","NUM","14","16","16","‹Mootiin Waan Maraa kolbaa tana biyya isi'iif kenniisaaf kaku'uun waadaa galetti galchuu waan dadhabeef, goomolee keessatti fixe› hin jedhan. ");
INSERT INTO gax_vpl VALUES ("NU14_17","005_14_17","NUM","14","17","17","Tanaaf, amma Mootii Waan Maraa, hunna teeti nutti mudhisi. Ati dur, ");
INSERT INTO gax_vpl VALUES ("NU14_18","005_14_18","NUM","14","18","18","‹Ani Mootiin Waan Maraa aariisaaf hin ariifadhu; jaalalli kiyya ka bara baraa gudda'a; cubbu'uu fi irra-dabara namaaf hin lakkisa; te'uu malee, yakkaamessa adoo hin adabin hin lakkisu; ijoollee sababa yakkaa abbooti'iitiif haga dhaloota sadiitii fi afuriititti hin adaba› jetteerta. ");
INSERT INTO gax_vpl VALUES ("NU14_19","005_14_19","NUM","14","19","19","Ammalle akka jaalala keeti guddaa ka bara baraatitti, akkuma yennaa isaan biyya Gibxi'iitii ka'anee jalqaddee haga ammaatitti isaaniif ossatte, kolbaa tana cubbuu isaanii isaaniif araaram» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU14_20","005_14_20","NUM","14","20","20","Mootiin Waan Maraa deebisee, «Akkuma ati daadimattetti, anille isaaniif araarameera. ");
INSERT INTO gax_vpl VALUES ("NU14_21","005_14_21","NUM","14","21","21","Te'uu malee ani jiraataa ulfinni kiyya lafa duudii guutu waan te'eef, ");
INSERT INTO gax_vpl VALUES ("NU14_22","005_14_22","NUM","14","22","22","namoota ulfinna kiyyaa fi bilbaasa adda addaa ka ani biyya Gibxi'iitii fi goomolee keessatti mudhise dhagganee naaf ajajamuu didanee, yennaa hedduu haga na ilaalane kana keessaa nami tokkolle, ");
INSERT INTO gax_vpl VALUES ("NU14_23","005_14_23","NUM","14","23","23","lafa ani abbootii isaaniitiif kaku'uun waadaa gale san ijjumaa hin dhaggu. Worra na tuffate keessaa nami tokkolle ijjumaa isii hin dhaggu. ");
INSERT INTO gax_vpl VALUES ("NU14_24","005_14_24","NUM","14","24","24","Ammoo tajaajilaan kiyya Kaaleb ilaalcha adda te'e waan qabuu fi gadhaa tokkochaan waan na hordofeef, lafa inni dhaqee dooye sanitti isa hin galcha; sanyiin isaalle lafa san hin dhaalti. ");
INSERT INTO gax_vpl VALUES ("NU14_25","005_14_25","NUM","14","25","25","Worri Amaaleqootaatii fi worri Kana'aanotaa dhooqa keessa waan le'anuuf, boru deebi'a'aatii karaa abbaayaa diintu'uutiin gara goomole'ee deema'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU14_26","005_14_26","NUM","14","26","26","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("NU14_27","005_14_27","NUM","14","27","27","«Haga yoomii kolbaan jallaamettiin tun na irratti gungunti? Ani gungunsuu Israa'elootaa tana dhage'eera. ");
INSERT INTO gax_vpl VALUES ("NU14_28","005_14_28","NUM","14","28","28","Ati isaaniin, ‹Mootiin Waan Maraa: Ani jiraata'a; waan isin dubbattanuun dhage'e, akkuma isin jettane isin irratti hin godha. ");
INSERT INTO gax_vpl VALUES ("NU14_29","005_14_29","NUM","14","29","29","Isin worri laakkowantane, akka laakkossa keessan maraatitti worri woggaan teessan woggaa diddamaatii fi woggaa diddamaa olii, worri na irratti gunguntane, as lafa goomole'ee tana keessatti hin dhumattan. ");
INSERT INTO gax_vpl VALUES ("NU14_30","005_14_30","NUM","14","30","30","Kaalebii ilma Yofune'eetii fi Iyaasuu ilma Nunii malee, akka isin itti galtanee leetanu lafa waadaa isiniif galetti, isin keessaa nami tokkolle itti hin galu. ");
INSERT INTO gax_vpl VALUES ("NU14_31","005_14_31","NUM","14","31","31","Ijoollee teessan ta isin hin fudhataman jettanu, ani ammoo, lafa isin tuffatane sanitti akka isaan gammadanu isaan itti hin galcha. ");
INSERT INTO gax_vpl VALUES ("NU14_32","005_14_32","NUM","14","32","32","Isin ammoo dhumattanee reeffi keessa goomolee tana keessatti hin hafa. ");
INSERT INTO gax_vpl VALUES ("NU14_33","005_14_33","NUM","14","33","33","Ijoolleen teessan woggaa afurtama goomolee tana keessa tissitoota hin te'an; haga marti keessan duutanee dhumattanutti, sababa dhugeeffannaa dhabiisa keessaniitiif achitti hin rakkatan. ");
INSERT INTO gax_vpl VALUES ("NU14_34","005_14_34","NUM","14","34","34","Akkuma guyyaa afurtama lafa san dooyiisa irratti fixxane, akkasuma guyyaan tokko woggaa tokkotti laakkowamee, woggaa afurtamaaf cubbuu teessaniif hin rakkattan. Yennaa san isin irratti ka'iisa kiyya hin beettan. ");
INSERT INTO gax_vpl VALUES ("NU14_35","005_14_35","NUM","14","35","35","Ani Mootiin Waan Maraa tana dubbadheera; kolbaa jallaamettii wolii galtee na irratti kaate tana irratti tana hin fida; isaan goomolee tana keessatti du'anee, hin hobba'an jedha› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU14_36","005_14_36","NUM","14","36","36","Namooti Muuseen akka lafa san dhaqanee dooyanuuf erginaan, achii deebi'anee marroo biyya sanii oduu gadhee kolba'atti odeessanee akka kolbaan Muusee irratti gunguntu godhane, ");
INSERT INTO gax_vpl VALUES ("NU14_37","005_14_37","NUM","14","37","37","marroo lafa sanii oduu gadhee waan odeessaneef, balaan itti bu'ee Mootii Waan Maraa duratti du'ane. ");
INSERT INTO gax_vpl VALUES ("NU14_38","005_14_38","NUM","14","38","38","Namoota lafa san dooyiisaaf dhaqane keessaa, Iyaasuu ilma Nuniitii fi Kaalebii ilma Yofune'ee qofatti hafe. ");
INSERT INTO gax_vpl VALUES ("NU14_39","005_14_39","NUM","14","39","39","Muuseen waan kana Israa'eloota maratti yennaa hime, isaan laaleffatanee bowane. ");
INSERT INTO gax_vpl VALUES ("NU14_40","005_14_40","NUM","14","40","40","Isaan boruyyaa ganama ka'anee biyya koobittii qaccee gaaraatitti ol bayanee, «Nuuti cubbuu hunyeerra; garuu gara addee Mootiin Waan Maraa waadaa nuu galee ol hin baana» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU14_41","005_14_41","NUM","14","41","41","Muuseen ammoo, «Isin ammalle maaf ajaja Mootii Waan Maraatiif ajajamuu diddan? Tun isiniif hin teetu. ");
INSERT INTO gax_vpl VALUES ("NU14_42","005_14_42","NUM","14","42","42","Mootiin Waan Maraa waan isin woliin hin jirreef ol hin bayina'a. Diinoti keessan isin hin injifatan. ");
INSERT INTO gax_vpl VALUES ("NU14_43","005_14_43","NUM","14","43","43","Worri Amaaleqootaatii fi worri Kana'aanotaa achitti isinitti hin dhufan; sababa isin Mootii Waan Maraa irraa fagaattanee innille isin woliin hin jirreef, shallaaga'aan hin dhumattan» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU14_44","005_14_44","NUM","14","44","44","Te'uu malee, isaan gara gaara biyya koobitti'ii ol bayiisumatti gamane. Saanduqi Gondooroo Mootii Waan Maraatii fi Muuseen ammoo addee quttumaa lakkisanee hin kaane. ");
INSERT INTO gax_vpl VALUES ("NU14_45","005_14_45","NUM","14","45","45","Achiin duuba worri Amaaleqootaatii fi worri Kana'aanotaa ka biyya koobittii san keessa le'anu gad dhufanee, isaan lolanee, haga Horma'aa gad isaan ari'ane. ");
INSERT INTO gax_vpl VALUES ("NU15_1","005_15_1","NUM","15","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU15_2","005_15_2","NUM","15","2","2","«Ati Israa'elootaan, ‹Mootiin Waan Maraa: Lafa akka isin keessa leetanuuf ani isiniif kennutti yennaa galtane, ");
INSERT INTO gax_vpl VALUES ("NU15_3","005_15_3","NUM","15","3","3","kennansa gubamuuf yookiin ciinca'aafille, waadaa addaa yookiin kennansa fedhii teessanii yookiin kennansa guyyaa jilaa loon keessaa yookiin hoolee keessaa kennansa foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu godha'aatii ana Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU15_4","005_15_4","NUM","15","4","4","Nami kennansa ifii dhikeessu kennansa midhaanii bullaa dansaa gara kiiloogiraama tokkoo, ta zayitii ejersaa gara litirii tokkootiin sukkuumante ana Mootii Waan Maraatiif dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_5","005_15_5","NUM","15","5","5","Buruusoo hoole'ee ta kennansa gubamuuf yookiin ciinca'aaf dhikaattu tokko tokkooyyuu woliin kennansa daadhii woyni'ii gara litirii tokkoo dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_6","005_15_6","NUM","15","6","6","Korbeessa hoole'ee woliin kennansa midhaanii bullaa dansaa kiiloogiraama lama ta zayitii ejersaa gara litirii tokkoo fi wodhakka'aatiin sukkuumante dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_7","005_15_7","NUM","15","7","7","Daadhii woyni'ii gara litirii tokkoo fi wodhakkaa ta foolee dansaa qaddu ta ana Mootii Waan Maraa gammachiittulle dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_8","005_15_8","NUM","15","8","8","Kennansa gubamuuf yookiin ciinca'aaf, kennansa addaa yookiin kennansa tokkumma'aa dardara tokko ana Mootii Waan Maraatiif yennaa dhikeessu, ");
INSERT INTO gax_vpl VALUES ("NU15_9","005_15_9","NUM","15","9","9","dardara san woliin kennansa midhaanii, bullaan dansaan kiiloogiraama sad ta zayitii ejersaa gara litirii lamaatiin sukkuumante dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_10","005_15_10","NUM","15","10","10","Kennansa daadhii woyni'iille gara litirii lamaa ta foolee dansaa qaddu ta ana Mootii Waan Maraa gammachiittu dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_11","005_15_11","NUM","15","11","11","« ‹Dardara tokko tokkooyyuu, korbeessa hoole'ee tokko tokkooyyuu, buruusoo hoole'eetii fi re'e'ee tokko tokkooyyuu akkuma kanatti dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_12","005_15_12","NUM","15","12","12","Akkuma laakkossi kennansa hori'ii dabalamuun, tokkoofuu akkasuma godha'a. ");
INSERT INTO gax_vpl VALUES ("NU15_13","005_15_13","NUM","15","13","13","Dhalataan biyya Israa'elii martinuu, kennansa ibiddaan gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu yennaa dhikeessu, waan kana mara godhuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_14","005_15_14","NUM","15","14","14","Dhaloota dhufu mara keessatti alagaan yookiin nami dhibiin ka odduu teessan le'u kennansa ibiddaan gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu yennaa dhikeessu, akkuma seera isin ittiin dhikeessitanutti dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_15","005_15_15","NUM","15","15","15","Kolbaa keessatti isinii fi alagaa odduu teessan le'uuf seerri tokkuma te'uu ti; kun dhaloota dhufuuf seera bara baraa ti; isinii fi alagaan odduu teessan le'ulle ana Mootii Waan Maraa duratti tokkuma. ");
INSERT INTO gax_vpl VALUES ("NU15_16","005_15_16","NUM","15","16","16","Isinii fi alagaan odduu teessan le'u seeraa fi qajeelfamuma tokko hin qabaattan jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU15_17","005_15_17","NUM","15","17","17","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU15_18","005_15_18","NUM","15","18","18","«Ati Israa'elootaan, ‹Mootiin Waan Maraa: Lafa ani itti isin geessutti yennaa galtane, ");
INSERT INTO gax_vpl VALUES ("NU15_19","005_15_19","NUM","15","19","19","sagalee lafa saniille yennaa nyaattane, sagalee san irraa kennansa ana Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU15_20","005_15_20","NUM","15","20","20","Midhaan keessan ka qara dhowattane irraa bulla sharante irraa bixee hephellittii takkattii, akkuma midhaan eeddummee irraa fuutanee kennansa dhikeessitanutti kennansa ana Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU15_21","005_15_21","NUM","15","21","21","Dhaloota dhufu mara keessatti, midhaan keessan ka qaraa irraa bullaa sharante irraa, kennansa kana ana Mootii Waan Maraatiif hin dhikeessitan. ");
INSERT INTO gax_vpl VALUES ("NU15_22","005_15_22","NUM","15","22","22","« ‹Isin adoo hin beekin ajaja ani Mootiin Waan Maraa Muusee ajaje yoo eegatuu dhaddane, ");
INSERT INTO gax_vpl VALUES ("NU15_23","005_15_23","NUM","15","23","23","ajaja ani Mootiin Waan Maraa karaa Muuse'eetiin isin ajaje kana maraa gaafa Muuse'etti kenneen jalqaddanee, dhalootaa haga dhalootaatitti yoo eegatuu dhaddane, ");
INSERT INTO gax_vpl VALUES ("NU15_24","005_15_24","NUM","15","24","24","kolbaalle adoo hin beekin yoo eegatuu dhadde, kolbaan duudiin dardara tokko kennansa gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu dhikeessituu ti! Dardara san wolille'een akka seera isaatitti kennansa midhaaniitii fi kennansa daadhii woyni'ii ka isaa woliin, kennansa araara cubbu'uutiifille korbeessa re'e'ee tokko dhikeessituu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_25","005_15_25","NUM","15","25","25","Kolbaan adoo hin beekin waan tolchiteef, adoo hin beekin tolchiisa ifiitiifille kennansa araara cubbu'uu ana Mootii Waan Maraatiif waan dhikeessiteef, hayyichi kolbaa duudi'iif gumaa tolchuu ti; isaan araara hin dhaggatan. ");
INSERT INTO gax_vpl VALUES ("NU15_26","005_15_26","NUM","15","26","26","Kolbaa Israa'elii duudi'ii fi alagaan odduu isaanii le'u duudiin, adoo hin beekin waan itti galaneef, araara hin dhaggatan. ");
INSERT INTO gax_vpl VALUES ("NU15_27","005_15_27","NUM","15","27","27","« ‹Nami tokko adoo hin beekin yoo cubbuu huje, suphee re'e'ee ta woggaa tokkoo kennansa araara cubbu'uutiif dhikeessuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_28","005_15_28","NUM","15","28","28","Hayyichi nama adoo hin beekin cubbuu huje saniif ana Mootii Waan Maraa duratti gumaa cubbu'uu dhikeessuu ti; inni araara hin dhaggata. ");
INSERT INTO gax_vpl VALUES ("NU15_29","005_15_29","NUM","15","29","29","Dhalataa biyyaa nama Israa'eliille te'u yookiin alagaa maraafuu ka adoo hin beekin cubbuu hujeef, seerri tokkuma. ");
INSERT INTO gax_vpl VALUES ("NU15_30","005_15_30","NUM","15","30","30","« ‹Dhalataan biyya Israa'elii yookiin alagaan beekaa yoo cubbuu huje ammoo, ana Mootii Waan Maraa waan tuffateef, kolbaa ifii keessaa bawuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_31","005_15_31","NUM","15","31","31","Inni jecha kiyya waan faanshesseef, ajaja kiyyalle waan diigeef, nami sun dhugumaan kolbaa keessaa bawuu qaba; yakki isaalle isuma irratti hafa jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU15_32","005_15_32","NUM","15","32","32","Israa'elooti yennaa goomolee keessa jiranu, nami tokko guyyaa Sanbataa qoraan caffatuun dhaggane. ");
INSERT INTO gax_vpl VALUES ("NU15_33","005_15_33","NUM","15","33","33","Worri qoraan caffatuun isa dhagge sun gara Muuse'ee fi Aaronii, gara wolde'a Israa'elii duudi'iille isa fide. ");
INSERT INTO gax_vpl VALUES ("NU15_34","005_15_34","NUM","15","34","34","Maan akka isa godhanu waan hin beekkaminiif akka hidhamu godhane. ");
INSERT INTO gax_vpl VALUES ("NU15_35","005_15_35","NUM","15","35","35","Achiin duuba Mootiin Waan Maraa Muuse'een, «Namichi du'uu qaba; wolde'i duudiin addee quttumaatiin alatti dhaka'aan isa tumuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU15_36","005_15_36","NUM","15","36","36","Maarre wolde'i duudiin addee quttumaatiin alatti akkuma Mootiin Waan Maraa Muusee ajaje, dhaka'aan tumanee isa ijjeesane. ");
INSERT INTO gax_vpl VALUES ("NU15_37","005_15_37","NUM","15","37","37","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU15_38","005_15_38","NUM","15","38","38","«Ati Israa'elootaan, ‹Mootiin Waan Maraa: Isin qaccee woyaa teessanii irratti handaara itti baafadha'a; handaara tokko tokkooyyuu irratti jirbii bifa cuquliisaa itti hidha'a. Dhalooti dhufu martinuu tana godhuu ti. ");
INSERT INTO gax_vpl VALUES ("NU15_39","005_15_39","NUM","15","39","39","Waan gadhaan keessan halche, waan ilti teessan dhaggite gula ideentanee akka hin sagaagalle, akka isin ajaja kiyya maraaf ajajantanu handaarri kun isin qaabachiisa. ");
INSERT INTO gax_vpl VALUES ("NU15_40","005_15_40","NUM","15","40","40","Achiin duuba isin ajaja kiyya maraaf ajajamiisa hin qaabattan; ana Waaqa keessaniifille hin woyyoontan. ");
INSERT INTO gax_vpl VALUES ("NU15_41","005_15_41","NUM","15","41","41","Ani Mootii Waan Maraa Waaqa keessan, ka Waaqa isinii te'iisaaf biyya Gibxi'ii keessaa isin baase; ani Mootii Waan Maraa Waaqa keessan jedha› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_1","005_16_1","NUM","16","1","1","Ilmi Yizhaarii Qoraahi akaakoon Qehaatii sanyii Lewwi'ii, ilmaan Eliiyaabii Daataanii fi Abiiram, ilmi Pheletii On worri sanyii Ruubenii, ");
INSERT INTO gax_vpl VALUES ("NU16_2","005_16_2","NUM","16","2","2","isaan wolille'een dhiirti Israa'elootaa dhibbi lamaa fi shantam, sooreyyiin kolba'aa worri beekkamane, miseensoti kora mura'aa Muusee irratti ka'ane. ");
INSERT INTO gax_vpl VALUES ("NU16_3","005_16_3","NUM","16","3","3","Isaan Muuse'ee fi Aaron mormiisaaf wolitti qabamanee dhufanee, isaaniin, «Isin ijjumaa bira dabartane! Kolbaan duudiinuu woyyoota; tokko tokkoo isaaniituu Waaqi isaan woliin jira; maarre isin maaf wolde'a Waaqaa irratti ol ifi qaddan ree?» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU16_4","005_16_4","NUM","16","4","4","Muuseen yennaa tana dhage'e, fuulaan lafatti gombifame. ");
INSERT INTO gax_vpl VALUES ("NU16_5","005_16_5","NUM","16","5","5","Achiin duuba Muuseen Qoraahii fi hordofattoota isaa maraan, «Boru barii Mootiin Waan Maraa ka isaa eennu akka te'e, woyyichille eennu akka te'e hin mudhisa; nama san gara ifii hin fida; inni nama filatu san gara ifii hin dhikeessa. ");
INSERT INTO gax_vpl VALUES ("NU16_6","005_16_6","NUM","16","6","6","Atii fi hordofattooti teeti martinuu girgiraa qabadha'aatii, ");
INSERT INTO gax_vpl VALUES ("NU16_7","005_16_7","NUM","16","7","7","boru barii Mootii Waan Maraa duratti kashilaa fi hixaana itti naqa'a. Nami Mootiin Waan Maraa filate nama woyyicha hin te'a. Isin worri Lewwootaa ijjumaa bira dabartaneertan» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_8","005_16_8","NUM","16","8","8","Muuseen ammalle Qoraahiin, «Ammalle, isin Lewwooti dhage'a'a! ");
INSERT INTO gax_vpl VALUES ("NU16_9","005_16_9","NUM","16","9","9","Waaqi Israa'elii isatti dhikaattanee hujii dunkaanii dhugaa bayaa ta Mootii Waan Maraa akka hujjanuuf, kolbaa dura dhaabbatanee akka isaan tajaajiltanuuf, kolbaa Israa'elii keessaa adda isin baasuun isaa isinitti diqqaattee ree? ");
INSERT INTO gax_vpl VALUES ("NU16_10","005_16_10","NUM","16","10","10","Inni isinii fi Lewwoota obboleeyyan teessan maraayyuu ifitti dhikeesseera; isin ammoo ammalle hayyoota te'iisaaf barbaaddan. ");
INSERT INTO gax_vpl VALUES ("NU16_11","005_16_11","NUM","16","11","11","Tanaaf atii fi hordofattooti teeti martinuu Mootii Waan Maraa mormiisaaf wolitti qabantane; Aaroniin isin irratti gunguntanu sun eennu inni?» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_12","005_16_12","NUM","16","12","12","Achiin duuba Muuseen ilmaan Eliiyaabii Daataanii fi Abiiramitti ergee waansise. Isaan ammoo, «Nuuti hin dhunnu; ");
INSERT INTO gax_vpl VALUES ("NU16_13","005_16_13","NUM","16","13","13","ati lafa aananii fi dammaa keessaa nu baachee goomolee keessatti nu ijjeesiisaaf ka as nu fidde si hin geettuu? Ammalle nu irratti goottaa te'iisaaf barbaaddaa? ");
INSERT INTO gax_vpl VALUES ("NU16_14","005_16_14","NUM","16","14","14","Ati lafa aananii fi dammaatitti nu hin galchine yookiin ficha'aa fi lafa woyni'ii nuu hin kennine; ati ballaa nu seetaa? Lakkii, nuuti hin dhunnu» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU16_15","005_16_15","NUM","16","15","15","Achiin duuba Muuseen guddoo aaree, Mootii Waan Maraatiin, «Ati kennansa isaanii hin fudhatin. Ani harree tokkolle isaan irraa hin fudhanne yookiin isaan keessaa nama tokkolle hin miine» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_16","005_16_16","NUM","16","16","16","Saniin duuba Muuseen Qoraahiin, «Boru atii fi hordofattooti teeti martinuu, Aaronille Mootii Waan Maraa duratti dhaggama'a. ");
INSERT INTO gax_vpl VALUES ("NU16_17","005_16_17","NUM","16","17","17","Namooti keeti martinuu girgiraa ifii qabatanee, hixaana itti naqatanuu ti; wolumatti girgiraa dhibba lamaa fi shantama, Mootii Waan Maraa dura dhikeessanuu ti; atii fi Aaronille dhikeessa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_18","005_16_18","NUM","16","18","18","Maarre nami tokko tokkooyyuu girgiraa ifii qabatee, kashilaa fi hixaana itti naqatee, Muuse'ee fi Aaron woliin addee seensuma Dunkaanii Woldeenna'aa dhaabbate. ");
INSERT INTO gax_vpl VALUES ("NU16_19","005_16_19","NUM","16","19","19","Qoraahi hordofattoota ifii mara fuullee Muuse'ee fi Aaronitti, seensuma Dunkaanii Woldeenna'aatitti yennaa wolitti qabe, ulfinni Mootii Waan Maraa wolde'a duudi'itti mudhate. ");
INSERT INTO gax_vpl VALUES ("NU16_20","005_16_20","NUM","16","20","20","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("NU16_21","005_16_21","NUM","16","21","21","«Ani ammuma akka isaan balleessu, isin wolde'a kana irraa adda baya'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_22","005_16_22","NUM","16","22","22","Muuse'ee fi Aaron ammoo lafatti gad gombifamanee iyyanee, «Ee Waaqa, ati Waaqa dada maraaf jiruu kennitu. Nami tokko yoo cubbuu huje, ati wolde'a duudi'itti aartaa ree?» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU16_23","005_16_23","NUM","16","23","23","Achiin duuba Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU16_24","005_16_24","NUM","16","24","24","«Ati kolba'aan, ‹Dunkaanii Qoraahii irraa, dunkaanii Daataaniitii fi dunkaanii Abiiramii irraa fagaadha'a› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_25","005_16_25","NUM","16","25","25","Maarre Muuseen ka'ee gara Daataaniitii fi Abiiramii dhaqe; jaarsoleen Israa'elii isa gula deemane. ");
INSERT INTO gax_vpl VALUES ("NU16_26","005_16_26","NUM","16","26","26","Inni wolde'a ifi eeggachiisee, «Dunkaanii namoota jallaameyyii kanaa irraa fagaadha'a! Waan isaanii hin tuqina'a; yoo akkas hin te'in sababa cubbuu isaanii maraatiif isaan woliin hin baddan» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_27","005_16_27","NUM","16","27","27","Maarre isaan dunkaanii Qoraahii irraa, dunkaanii Daataaniitii fi Abiiramii irraa fagaatane. Daataanii fi Abiiram bayanee dhufanee addee seensuma dunkaanii ifii, dubartoota ifiitii fi ijoollee ifii woliin dhaabbataniiyyu. ");
INSERT INTO gax_vpl VALUES ("NU16_28","005_16_28","NUM","16","28","28","Achiin duuba Muuseen wolde'aan, «Waan kana mara akka ani godhu Mootiin Waan Maraa akka na ergeeru, anille hujii tana mara ka huju yaaduma kiyyaan akka hin te'in tanaan beettan: ");
INSERT INTO gax_vpl VALUES ("NU16_29","005_16_29","NUM","16","29","29","Namooti kun akkuma nami martinuu du'u yoo du'ane yookiin wonni nama irratti te'u callaan yoo isaan irratti teete, Mootiin Waan Maraa na hin ergine. ");
INSERT INTO gax_vpl VALUES ("NU16_30","005_16_30","NUM","16","30","30","Ammoo Mootiin Waan Maraa waan te'ee hin beenne godhee, waan isaanii mara woliin, latti afaan ifii bantee isaan liqinsitee, isaan jiru'uun addee worri du'e jirutti yoo gad bu'ane, namooti kun akka Mootii Waan Maraa tuffataneeranu hin beettan» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_31","005_16_31","NUM","16","31","31","Akkuma Muuseen dubbii tana fixateen, latti Daataanii fi Abiiram jalaa gargar baqaxxee, ");
INSERT INTO gax_vpl VALUES ("NU16_32","005_16_32","NUM","16","32","32","afaan bantee isaanii fi maatii isaanii, hordofattoota Qoraahiitii fi waan isaan qabanu mara woliin liqinsite. ");
INSERT INTO gax_vpl VALUES ("NU16_33","005_16_33","NUM","16","33","33","Maarre isaan jiru'uun addee worri du'e jirutti waan qabanu mara woliin gad bu'ane; latti itti cufantee, isaan kolbaa keessaa badane. ");
INSERT INTO gax_vpl VALUES ("NU16_34","005_16_34","NUM","16","34","34","Kolbaan israa'elii ta adaala isaanii jirtu marti, iyya isaanii yennaa dhageette, «Latti nu'ulle hin liqinsiti fa'a» jettee baqatte. ");
INSERT INTO gax_vpl VALUES ("NU16_35","005_16_35","NUM","16","35","35","Ibiddille Mootii Waan Maraa biraa dhufee namoota dhibba lamaa fi shantama, worra hixaana aarsiisatti jiru muxuqi godhe. ");
INSERT INTO gax_vpl VALUES ("NU16_36","005_16_36","NUM","16","36","36","Achiin duuba Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU16_37","005_16_37","NUM","16","37","37","«Ele'azaarii ilma Aaronii hayyichaatiin, ‹Girgirooti hixaana itti aarsane sun woyyoota waan te'aneef, kashila keessaa fuudhi; kashila san fageessii bittinneessi. ");
INSERT INTO gax_vpl VALUES ("NU16_38","005_16_38","NUM","16","38","38","Girgirooti kun girgiroota namooti jiruu ifii balleessiisaaf cubbuu ittiin hujane; girgirooti kun gara Mootii Waan Maraa dhikaatanee waan woyyoomaneef, hephelleessii tumiitii, gonfaa addee ciinca'aa godhi. Kolbaa Israa'eliitiif ifi eeggannoo te'anuu ti› jedhiin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_39","005_16_39","NUM","16","39","39","Maarre Ele'azaariin hayyichi girgiraa sageettuu irraa hujamane, ka namooti gubatanee fixamane hixaana itti aarsane san fuudhee, hephelleessee tumee addee ciinca'aatiif gonfaa godhe. ");
INSERT INTO gax_vpl VALUES ("NU16_40","005_16_40","NUM","16","40","40","Akkuma Mootiin Waan Maraa karaa Muuse'eetiin isatti hime, sanyii Aaronii malee, eennulle Mootii Waan Maraa dura dhikaatee hixaana akka hin aarsineef, akka Qoraahiitii fi akka hordofattoota isaalle akka hin teene, Israa'elootaaf waan ittiin qaabatanu godhe. ");
INSERT INTO gax_vpl VALUES ("NU16_41","005_16_41","NUM","16","41","41","Boruyyaa kolbaan Israa'elii duudiin, «Isin kolbaa Mootii Waan Maraa ijjeettaneertan» jedhanee, Muuse'ee fi Aaron irratti gungumane. ");
INSERT INTO gax_vpl VALUES ("NU16_42","005_16_42","NUM","16","42","42","Yennaa wolde'i Muuse'ee fi Aaron mormiisaaf wolitti qabamee gara Dunkaanii Woldeenna'aa deebi'e ammoo, dedhuma duumensi Dunkaanii Woldeenna'aa gollee, ulfinni Mootii Waan Maraalle mudhate. ");
INSERT INTO gax_vpl VALUES ("NU16_43","005_16_43","NUM","16","43","43","Achiin duuba Muuse'ee fi Aaron gara Dunkaanii Woldeenna'aa dura dhaqane. ");
INSERT INTO gax_vpl VALUES ("NU16_44","005_16_44","NUM","16","44","44","Mootiin Waan Maraalle Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU16_45","005_16_45","NUM","16","45","45","«Ani ammuma akka isaan fixuuf isin wolde'a kana irraa fagaadha'a» jedhe. Muuse'ee fi Aaron fuulaan lafatti gad gombifamane. ");
INSERT INTO gax_vpl VALUES ("NU16_46","005_16_46","NUM","16","46","46","Achiin duuba Muuseen Aaroniin, «Mufiin Mootii Waan Maraa biraa baateerti; balaan jalqabeera; ati girgiraa keeti fudhadhuutii, kashila ibidda addee ciinca'aa irraa itti naqiitii, hixaanalle itti naqiitii, cubbuu isaaniitiif gumaa tolchiisaaf ariifadhuu gara wolde'aa gad bayi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU16_47","005_16_47","NUM","16","47","47","Maarre Aaron akkuma Muuseen ajaje, girgiraa fudhatee, addee balaan jalqabeeru san rukkisee wolde'a odduu seenee, hixaana aarsee, cubbuu kolba'aatiif gumaa cubbu'uu tolche. ");
INSERT INTO gax_vpl VALUES ("NU16_48","005_16_48","NUM","16","48","48","Inni worra du'anee fi worra jiranu wodhakkaa dhaabbate; balaalle dhaabbate. ");
INSERT INTO gax_vpl VALUES ("NU16_49","005_16_49","NUM","16","49","49","Te'uu malee, worra sababa Qoraahiitiif dhumate adoo hin dabalatin, worri balaa saniin dhumate kuma kudhanii afurii fi dhibba torba. ");
INSERT INTO gax_vpl VALUES ("NU16_50","005_16_50","NUM","16","50","50","Balaan waan dhaabbateef, Aaron addee seensuma Dunkaanii Woldeenna'aatitti gara Muuse'ee deebi'e. ");
INSERT INTO gax_vpl VALUES ("NU17_1","005_17_1","NUM","17","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU17_2","005_17_2","NUM","17","2","2","«Israa'elootatti himiitii, sooressitoota gosa abbootii isaanii ta durii irraa ulee tokko tokko wolumatti ulee kudhanii lama fuudhiitii, ulee nama tokko tokkootuu irratti maqaa isaa barreessi. ");
INSERT INTO gax_vpl VALUES ("NU17_3","005_17_3","NUM","17","3","3","Sooressi gosa abbootii isaanii ta durii tokko ulee tokko waan qabuuf, ulee gosa Lewwi'ii irratti maqaa Aaronii barreessi. ");
INSERT INTO gax_vpl VALUES ("NU17_4","005_17_4","NUM","17","4","4","Uloota san fuudhiitii, addee ani si'iin itti wol dhaggu, Dunkaanii Woldeenna'aa keessa Saanduqa Gondooro'oo dura keyi. ");
INSERT INTO gax_vpl VALUES ("NU17_5","005_17_5","NUM","17","5","5","Achiin duuba uleen nama ani fileeruu hin quunxiti. Akka kanaan gungumiisa Israa'elootaa ta isaan yennaa mara si irratti gungumanu si irraa kuta» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU17_6","005_17_6","NUM","17","6","6","Maarre Muuseen kanuma Israa'elootatti hime; sooreyyiin gosa Israa'eliille akka gosa gosa ifiititti ulee tokko tokko, wolumatti ulee kudhanii lama isatti kennite; uloota san keessaa takkattiin ulee Aaronii ti. ");
INSERT INTO gax_vpl VALUES ("NU17_7","005_17_7","NUM","17","7","7","Achiin duuba Muuseen uloota san dunkaanii dhugaa bayaa keessaa Mootii Waan Maraa dura keye. ");
INSERT INTO gax_vpl VALUES ("NU17_8","005_17_8","NUM","17","8","8","Boruyyaa, Muuseen gara dunkaanii dhugaa bayaa yennaa ol seene, uleen Aaronii ta maqaa gosa Lewwi'iitiin dhikaatte, quunxitee, daraartee, midhaan muka, «Almond» jedhamuu buutteertiiyyu. ");
INSERT INTO gax_vpl VALUES ("NU17_9","005_17_9","NUM","17","9","9","Achiin duuba Muuseen uloota san mara Mootii Waan Maraa duraa fuudhee Israa'eloota maratti mudhise. Isaan uloota san ilaalanee, sooreyyiin tokko tokkoon isaaniituu ulee ifii fudhatane. ");
INSERT INTO gax_vpl VALUES ("NU17_10","005_17_10","NUM","17","10","10","Mootiin Waan Maraa Muuse'een, «Worra finqila'aaf beessisa akka teetu, ulee Aaronii Saanduqa Gondooro'oo duratti deebisi. Tun isaan na irratti gungumanee akka hin dhumanne gooti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU17_11","005_17_11","NUM","17","11","11","Muuseen akkuma Mootiin Waan Maraa isa ajaje godhe. ");
INSERT INTO gax_vpl VALUES ("NU17_12","005_17_12","NUM","17","12","12","Achiin duuba Israa'elooti Muuse'een, «Nuuti hin duuna! Nuuti dhumataarra! Marti keennaayyuu badaarra! ");
INSERT INTO gax_vpl VALUES ("NU17_13","005_17_13","NUM","17","13","13","Nami tokkolle yoo dunkaanii dhugaa bayaa ta Mootii Waan Maraa bira dhufe hin du'a. Marti keennaayyuu dhumannuu tii ree?» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU18_1","005_18_1","NUM","18","1","1","Mootiin Waan Maraa Aaroniin, «Atii fi ilmaan teeti, maatiin abbootii teetii ta durii yakkaa addee Woyyittii keessatti hujjaneef itti gaafatantan; yakkaa tajaajila hayyumma'aatiif ammoo si'ii fi ilmaan teeti qofatti itti gaafatama. ");
INSERT INTO gax_vpl VALUES ("NU18_2","005_18_2","NUM","18","2","2","Atii fi ilmaan teeti, dunkaanii dhugaa bayaa duratti yennaa tajaajiltanu akka isin qarqaaranu, gosa abbootii teetii ta durii keessaa obboleeyyan teeti Lewwoota as fidi. ");
INSERT INTO gax_vpl VALUES ("NU18_3","005_18_3","NUM","18","3","3","Isaan itti gaafatamummaa teeti jalatti hujii dunkaani'ii hujanuutii malee, meya Addee Woyyitti'ii yookiin addee ciinca'aa tuquu hin qabanu. Yoo tuqane atii fi isaanille hin duutan. ");
INSERT INTO gax_vpl VALUES ("NU18_4","005_18_4","NUM","18","4","4","Isaan itti gaafatamummaa eegiisa Dunkaanii Woldeenna'aa fudhatanee, hujii dunkaanii keessatti hujatu mara hujiisaan si qarqaaran; nami gosa Lewwi'ii hin te'in ammoo si woliin hin hujin. ");
INSERT INTO gax_vpl VALUES ("NU18_5","005_18_5","NUM","18","5","5","Mufiin tiyya ammalle Israa'elootatti akka hin deebine, tajaajila Addee Woyyitti'iitii fi addee ciinca'aa si'ii fi ilmaan teeti qofatti itti gaafatama. ");
INSERT INTO gax_vpl VALUES ("NU18_6","005_18_6","NUM","18","6","6","Ani Mootiin Waan Maraa obboleeyyan teessan Lewwoota, Israa'eloota oddu'uu filee, hujii Dunkaanii Woldeenna'aa keessaa akka hujanuuf isinii kenneera. ");
INSERT INTO gax_vpl VALUES ("NU18_7","005_18_7","NUM","18","7","7","Te'uu malee, hujii addee ciinca'aatii fi hujii gollaa keessaa mara si'ii fi ilmaan teeti qofatti itti gaafatama. Akka isin hayyoota teetanee tajaajiltanuuf, ani hujii hayyumma'aa isiniif kenneera; isin malee nami dhibiin ka addee woyyitti'itti dhikaatu ijjeefamuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU18_8","005_18_8","NUM","18","8","8","Achiin duuba Mootiin Waan Maraa Aaroniin, «Kennansa naaf dhikaatu mara irratti itti gaafatamaa si godheera; kennansa woyyicha Israa'elooti naaf kennitu mara si'ii fi ilmaan teetiif qooda yennaa maraa akka te'u kenneera. ");
INSERT INTO gax_vpl VALUES ("NU18_9","005_18_9","NUM","18","9","9","Kennansa irra caalaa woyyichaa ka ibiddaan hin gubanne ifiif fudhadhu; kennansa irra caalaa woyyichaa ka isaan naaf kennanu marti, kennansi midhaanii yookiin kennansi gumaa cubbu'uutiif dhikaatu yookiin kennansi isaan sababa yakka'aatiif dhikeessanu marti keetii fi ka ilmaan teetii ti. ");
INSERT INTO gax_vpl VALUES ("NU18_10","005_18_10","NUM","18","10","10","Addee Woyyittii keessatti waan kana mara nyaadhu; dhiirti marti waan kana nyaattuu ti; wonni kun si'iif woyyu'u. ");
INSERT INTO gax_vpl VALUES ("NU18_11","005_18_11","NUM","18","11","11","«Kennansi tachoofamu ka Israa'elooti dhikeessitu marti keeti te'uu ti; ani si'iif, ilmaan teetii fi ijoollee durraa teetiif qooda yennaa maraa akka te'u kenneera. Nami mana keeti keessa jiru ka akka aadaa dhugeeffanna'aatitti qulqulluu te'e marti nyaatuu hin dande'a. ");
INSERT INTO gax_vpl VALUES ("NU18_12","005_18_12","NUM","18","12","12","«Zayitii ejersaatii fi daadhii woyni'ii keessaa ta caaltu, midhaan mata'aa keessaa ka caalu, ka Israa'elooti ana Mootii Waan Maraatiif kennane ani sii hin kenna. ");
INSERT INTO gax_vpl VALUES ("NU18_13","005_18_13","NUM","18","13","13","Midhaan mata'aa ka lafa isaanii keessaa, ka isaan ana Mootii Waan Maraatiif fidanu marti keeti. Nami mana keeti keessa jiru ka akka aadaa dhugeeffanna'aatitti qulqulluu te'e marti nyaatuu hin dande'a. ");
INSERT INTO gax_vpl VALUES ("NU18_14","005_18_14","NUM","18","14","14","«Israa'el keessaa wonni ana Mootii Waan Maraatiif murteeffame marti keeti te'uu ti. ");
INSERT INTO gax_vpl VALUES ("NU18_15","005_18_15","NUM","18","15","15","«Wonni Angafa te'e marti, nami yookiin horiin ka Israa'elooti ana Mootii Waan Maraatiif dhikeessanu keeti te'anuu ti. Angafa namaatii fi angafa hori'ii ka qulqulluu hin te'iniif ammoo wodoo fudhatuu qadda. ");
INSERT INTO gax_vpl VALUES ("NU18_16","005_18_16","NUM","18","16","16","Ijoolleen ji'a tokkoo, akka sheeqelii Addee Woyyitti'iititti meetii sheeqelii shan ta gara geraa diddama madaaltuun wodamanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU18_17","005_18_17","NUM","18","17","17","Angafi loonii, angafi hoole'ee, angafi re'e'ee ammoo woyyuu waan te'aneef wodoo hin fudhatin; dhiiga isaanii addee ciinca'aatitti fiffixi; cooma isaanille kennansa ibiddaan gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu godhiitii addee ciinca'aa irratti gubi. ");
INSERT INTO gax_vpl VALUES ("NU18_18","005_18_18","NUM","18","18","18","Foon isaanii akkuma foon cormi'iitii fi foon luka middaa ka kennansa tachoofamuuf dhikaatuu keeti te'uu ti. ");
INSERT INTO gax_vpl VALUES ("NU18_19","005_18_19","NUM","18","19","19","«Kennansi woyyichi ka Israa'elooti ana Mootii Waan Maraatiif dhikeessitu marti si'iif, ilmaan teetii fi ijoollee durraa teetiif qooda yennaa mara akka te'u kenneera. Tun si'ii fi sanyii teetiif ana Mootii Waan Maraa duratti Gondooroo sooddaa ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU18_20","005_18_20","NUM","18","20","20","Mootiin Waan Maraa ammalle Aaroniin, «Ati lafa Israa'elii keessaa dhaala hin fudhatu; Israa'el odduulle'etti qooda lafaa hin qabaattu. Israa'el oddu'utti ani Mootiin Waan Maraa qooda keetii fi dhaala keeti. ");
INSERT INTO gax_vpl VALUES ("NU18_21","005_18_21","NUM","18","21","21","«Lewwooti Dunkaanii Woldeenna'aa keessa waan tajaajilanuuf, waan kolbaan Israa'elii kudhan keessaa tokko naaf fiddu mara ani isaaniif dhaala godhee kenneera. ");
INSERT INTO gax_vpl VALUES ("NU18_22","005_18_22","NUM","18","22","22","Cubbuu itti te'ee akka hin duune, Israa'elooti dhibiin ammaa jalqabanee Dunkaanii Woldeenna'aatitti hin dhikaatin. ");
INSERT INTO gax_vpl VALUES ("NU18_23","005_18_23","NUM","18","23","23","Worri Lewwootaa Dunkaanii Woldeenna'aa keessa tajaajilanuu ti. Isaan yakkaa achi keessatti hujanuuf itti hin gaafataman. Kun dhaloota dhufuuf seerata bara baraa ti. Isaan Israa'eloota oddu'utti lafa dhaalanu hin qabaatanu. ");
INSERT INTO gax_vpl VALUES ("NU18_24","005_18_24","NUM","18","24","24","Waan Israa'elooti kudhan keessa tokko kennansa addaa godhanee ana Mootii Waan Maraatiif dhikeessanu, ani Lewwootaaf kenneera; tanaaf ani isaaniin, ‹Israa'eloota oddu'utti lafa dhaaltanu hin qabaattanu› jedheera» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU18_25","005_18_25","NUM","18","25","25","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU18_26","005_18_26","NUM","18","26","26","«Ati worra Lewwootaatiin, ‹Waan Israa'elooti kudhan keessaa tokko ana Mootii Waan Maraatiif fiddu, ka ani dhaala keessan godhee isiniif kennu san yennaa fudhattanu, isinille ka fudhattanne san keessaa kudhan keessaa tokko kennansa ana Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU18_27","005_18_27","NUM","18","27","27","Kennansi keessan kun akka midhaan eeddummee keessaa kennamuutii fi akka cunfaa woyni'ii ta addee woynii itti cunfanu keessaa kennantuutitti isiniif hin laakkowama. ");
INSERT INTO gax_vpl VALUES ("NU18_28","005_18_28","NUM","18","28","28","Akka kanaan isinille waan Israa'elooti kudhan keessaa tokko ana Mootii Waan Maraatiif fiddu, ka fudhattanu mara irraa qooda kiyya Aaronii hayyichatti kenna'a. ");
INSERT INTO gax_vpl VALUES ("NU18_29","005_18_29","NUM","18","29","29","Kennansa fudhattanu mara keessaa ka irra caalaa dansaa te'ee fi irra caalaa woyyicha te'e qooda kiyya godha'aatii dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU18_30","005_18_30","NUM","18","30","30","Isin waan irra caalaa dansaa san yennaa dhikeessitanu, akkuma midhaan eeddummee keessaa kennamuutii fi akka cunfaa woyni'ii ta addee woynii itti cunfanu keessaa kennantuutitti isiniif hin laakkowama. ");
INSERT INTO gax_vpl VALUES ("NU18_31","005_18_31","NUM","18","31","31","Tajaajila isin Dunkaanii Woldeenna'aa keessa tajaajiltanuuf kaffaltii waan isinii te'uuf, isinii fi maatiin teessan waan hafe san eessalle'etti nyaatuu hin dandeettan. ");
INSERT INTO gax_vpl VALUES ("NU18_32","005_18_32","NUM","18","32","32","Eega waan irra caalaa dansaa te'e dhikeessitane, isin yakkaameyyii hin teetanu. Achiin duuba kennansa woyyicha Israa'elootaa hin batteessitanu; hin duutanulle'e› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU19_1","005_19_1","NUM","19","1","1","Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("NU19_2","005_19_2","NUM","19","2","2","«Kun qajeelfama seeraa ka ani ajaje: Goronsa arrowa komii hin qanne, ka waanjoon mormarra keyamee hin beenne akka fidanu Israa'elootatti himi. ");
INSERT INTO gax_vpl VALUES ("NU19_3","005_19_3","NUM","19","3","3","Goronsa san Ele'azaarii hayyichatti kenna'a. Goronsi sun fuudhamee addee quttumaatiin alatti hayyicha duratti gorra'amuu ti. ");
INSERT INTO gax_vpl VALUES ("NU19_4","005_19_4","NUM","19","4","4","Achiin duuba hayyichi Ele'azaar dhiiga goronsaa quba ifiitiin diqqaa isaa fuudhee yennaa torba fuullee Dunkaanii Woldeenna'aatitti fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("NU19_5","005_19_5","NUM","19","5","5","Goronsi sun gogaan isaa, foon isaa, dhiigii fi meen gadhaa isaalle duudiin hayyicha duratti gubamuu ti. ");
INSERT INTO gax_vpl VALUES ("NU19_6","005_19_6","NUM","19","6","6","Hayyichi muka hindheensaa, damee hisoophiitii fi liilana diimaa fuudhee ibidda goronsi keessatti gubamiisatti jiru sanitti qolaansuu ti. ");
INSERT INTO gax_vpl VALUES ("NU19_7","005_19_7","NUM","19","7","7","Achiin duuba, inni woyaa ifiitii fi nafa ifii bisaaniin dhiqatee, gara addee quttumaa deebi'uu ti; garuu haga galgalaatitti akka aadaa dhugeeffannna'aatitti qulqullu'uu moti. ");
INSERT INTO gax_vpl VALUES ("NU19_8","005_19_8","NUM","19","8","8","Nami goronsa gube woyaa ifiitii fi nafa ifii bisaaniin dhiqatuu ti; innille haga galgalaatitti qulqullu'uu moti. ");
INSERT INTO gax_vpl VALUES ("NU19_9","005_19_9","NUM","19","9","9","Achiin duuba nami akka aadaa dhugeeffanna'aatitti qulqulluu te'e daadhaa goronsaa san haree, addee quttumaatiin alatti, addee akka aadaa dhugeeffanna'aatitti qulqulluu teete keessatti naquu ti; daadhaan sun kolbaa Israa'eliitiif bisaan ittiin qulqulloomanu qopheessiisaaf te'a. Kunille cubbuu irraa ittiin qulqulleessiisaaf te'a. ");
INSERT INTO gax_vpl VALUES ("NU19_10","005_19_10","NUM","19","10","10","Namichi daadhaa goronsaa harelle woyaa ifii dhiqatuu ti; innille haga galgalaatitti qulqullu'uu moti. Kun Israa'elootaa fi orma odduu isaanii le'uufille seerata haga bara baraa hin te'a. ");
INSERT INTO gax_vpl VALUES ("NU19_11","005_19_11","NUM","19","11","11","«Nami reeffa namaa tuqe marti guyyaa torbaaf akka aadaa dhugeeffanna'aatitti qulqullu'uu moti. ");
INSERT INTO gax_vpl VALUES ("NU19_12","005_19_12","NUM","19","12","12","Inni guyyaa sadeesso'ootii fi guyyaa torbeesso'oo bisaaniin ifi qulqulleessuu ti; achiin duuba qulqulluu hin te'a; guyyaa sadeesso'ootii fi guyyaa torbeesso'oo yoo ifi hin qulqulleessin ammoo qulqulluu hin te'u. ");
INSERT INTO gax_vpl VALUES ("NU19_13","005_19_13","NUM","19","13","13","Nami reeffa namaa tuqee adoo ifi hin qulqulleessin hafe, dunkaanii dhugaa bayaa tiyya hin batteessa; inni kolbaa Israa'elii keessaa bawuu ti. Bisaan ittiin qulqulloomiisaa isatti waan hin fiffixaminiif, battummaan isaa isuma irratti hafa. ");
INSERT INTO gax_vpl VALUES ("NU19_14","005_19_14","NUM","19","14","14","«Nami tokko dunkaanii keessatti yennaa du'u seerri muummeffamu ka asii gad jiru: Nami tokko dunkaanii keessatti yoo du'ee, nami dunkaanii keessa jiru yookiin nami gara dunkaanii sanii seenu guyyaa torbaaf qulqullu'uu moti. ");
INSERT INTO gax_vpl VALUES ("NU19_15","005_19_15","NUM","19","15","15","Meen afaan banaa jiru ka cuqqaallaan jabaan irra hin jirre marti qulqullu'uu moti. ");
INSERT INTO gax_vpl VALUES ("NU19_16","005_19_16","NUM","19","16","16","Nami nama shallaaga'aan diidatti ijjeefameeru yookiin nama akkasumaan du'eeru yookiin lafee namaa yookiin irreensa namaa tuqe, guyyaa torbaaf qulqullu'uu moti. ");
INSERT INTO gax_vpl VALUES ("NU19_17","005_19_17","NUM","19","17","17","«Nama san qulqulleessiisaaf, daadhaa goronsa arrowaa ka cubbuu ittiin qulqulleessiisaaf gubate irra diqqaan isaa fuudhamee, okkote'etti naqamee, bisaan maddaa itti naqamuu ti. ");
INSERT INTO gax_vpl VALUES ("NU19_18","005_19_18","NUM","19","18","18","Achiin duuba nami akka aadaa dhugeeffanna'aatitti qulqulluu te'e damee hisoophii fuudhee, bisaan keessa cuuphee, dunkaani'itti, waan dunkaanii keessa jirutti, namoota achi jiranu maratti, ka lafee nama du'ee tuqetti yookiin ka irreensa tuqetti yookiin ka nama ijjeefame tuqetti yookiin ka reeffa nama akkasumaan du'e tuqetti fiffixuu ti. ");
INSERT INTO gax_vpl VALUES ("NU19_19","005_19_19","NUM","19","19","19","Nami qulqulluu te'e, guyyaa sadeesso'ootii fi guyyaa torbeesso'oo nama qulqulluu hin te'initti bisaan fiffixuu ti. Guyyaa torbeesso'oo sanitti isa qulqulleessuu ti. Nami qulqulloome sun woyaa ifiitii fi nafa ifii bisaaniin dhiqatee, galgaluma san hin qulqullooma. ");
INSERT INTO gax_vpl VALUES ("NU19_20","005_19_20","NUM","19","20","20","«Nami qulqulluu hin te'in ammoo, yoo ifi hin qulqulleessin, addee woyyittii tiyya waan batteesseef, kolbaa keessaa bawuu ti; bisaan ittiin qulqulloomiisaa waan itti hin fiffixaminiif inni qulqullu'uu moti. ");
INSERT INTO gax_vpl VALUES ("NU19_21","005_19_21","NUM","19","21","21","Kun seera haga bara baraa isaaniif te'uu ti; nami bisaan ittiin qulqulloomiisaa itti fiffixame woyaa ifii dhiqatuu ti; nami bisaan itti qulqulloomiisaa tuqe marti haga galgalaatitti qulqullu'uu moti. ");
INSERT INTO gax_vpl VALUES ("NU19_22","005_19_22","NUM","19","22","22","Wonni nami qulqulluu hin te'in tuqe marti qulqullu'uu moti; nami waan qulqulluu hin te'in san tuqelle haga galgalaatitti qulqullu'uu moti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU20_1","005_20_1","NUM","20","1","1","Ji'a tokkeesso'oo keessa kolbaan Israa'elii duudiin gara goomolee Ziinii dhuttee Qaadeshitti qubatte. Achitti Miiryaam duutee awwaalante. ");
INSERT INTO gax_vpl VALUES ("NU20_2","005_20_2","NUM","20","2","2","Addee san bisaan waan hin jirreef, Muuse'ee fi Aaron mormiisaaf, kolbaan wolitti qabante. ");
INSERT INTO gax_vpl VALUES ("NU20_3","005_20_3","NUM","20","3","3","Kolbaan Muuse'ee fi Aaron loltee, «Yennaa obboleeyyan teenna Mootii Waan Maraa duratti dhumatanu nuutille adoo dhumannee jiraannee! ");
INSERT INTO gax_vpl VALUES ("NU20_4","005_20_4","NUM","20","4","4","Isin maaf kolbaa Mootii Waan Maraa as goomolee tana keessa nu fiddane? Nuutille, horiin keennalle akka asitti dhumannuufii motii ree? ");
INSERT INTO gax_vpl VALUES ("NU20_5","005_20_5","NUM","20","5","5","Biyya Gibxi'ii keessaa nu baattanee addee wonni tokko itti hin lanne maaf nu fiddane? Addee tana midhaan, harruun, woyniin, midhaan muka rumaanii hin jiru; bisaan unanuuyyuu hin jiru» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU20_6","005_20_6","NUM","20","6","6","Achiin duuba Muuse'ee fi Aaron kolbaa irraa hiiqanee gara seensuma Dunkaanii Woldeenna'aa dhaqanee, fuulaan lafatti gad gombifamanee, ulfinni Mootii Waan Maraalle isaanitti mudhate. ");
INSERT INTO gax_vpl VALUES ("NU20_7","005_20_7","NUM","20","7","7","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU20_8","005_20_8","NUM","20","8","8","«Ulee teetii fudhadhuutii atii fi obboleessi keeti Aaron wolde'a wolitti qaba'a; achitti isaan mara duratti rassa'atti dubbadha'a; rassaa san keessaa bisaan hin burqa. Akkanaan ati rassaa keessaa kolba'aaf bisaan baachee, isaanii fi horiille hin unan» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU20_9","005_20_9","NUM","20","9","9","Maarre Muuseen akkuma Mootiin Waan Maraa isa ajaje dhaqee, ulee fuula Mootii Waan Maraa duraa fudhate. ");
INSERT INTO gax_vpl VALUES ("NU20_10","005_20_10","NUM","20","10","10","Muuse'ee fi Aaron rassaa duratti wolde'a wolitti qabanee, Muuseen kolba'aan, «Isin worri jallaameyyiin, dhage'a'a! Nuuti rassaa kana keessaa bisaan isiniif baanyaa ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU20_11","005_20_11","NUM","20","11","11","Achiin duuba Muuseen harka ifii ol kaasee, ulee ifiitiin yennaa lama rassaa san dhowe; bisaan keessaa lola'ee, kolba'aa fi horiin isaaniille unane. ");
INSERT INTO gax_vpl VALUES ("NU20_12","005_20_12","NUM","20","12","12","Mootiin Waan Maraa ammoo Muuse'ee fi Aaroniin, «Israa'eloota duratti ana woyyicha gootanee ulfeessiisaaf, natti waan hin addatiniif, lafa ani isaanii kennetti isaan hin galchitanu» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU20_13","005_20_13","NUM","20","13","13","Addeen Israa'elooti Mootii Waan Maraatiin morminaan, Mootiin Waan Maraa woyyummaa ifii isaanitti mudhise addee bisaan Mariibaa ti. ");
INSERT INTO gax_vpl VALUES ("NU20_14","005_20_14","NUM","20","14","14","Muuseen Qaadeshi irraa gara mootii Edoomii ergantootaa ergee, «Obboleessi keeti Israa'el, ‹Rakkinna nu irra dhaqqabe mara hin beetta; ");
INSERT INTO gax_vpl VALUES ("NU20_15","005_20_15","NUM","20","15","15","abbootiin teenna ta durii gara biyya Gibxi'ii gad bu'anee, nuutille bara hedduu achi leene. Worri biyya Gibxi'ii abbootii teennaa fi nu'ulle cunqursanee, ");
INSERT INTO gax_vpl VALUES ("NU20_16","005_20_16","NUM","20","16","16","yennaa nuuti gara Mootii Waan Maraa iyyine ammoo, inni iyya teenna dhage'ee ergamaa ergee biyya Gibxi'ii keessaa nu baase. Amma tuuti meessaa lafa teetii, qachaa Qaadeshii jirra. ");
INSERT INTO gax_vpl VALUES ("NU20_17","005_20_17","NUM","20","17","17","Maganne'ee lafa teeti keessa akka dabarru nuu eeyyami. Nuuti fichaa nama tokkoo yookiin oorruu woynii nama tokkoolle keessa hin baanu, baleessa tokkolle keessaa bisaan hin unnu; haga lafa teeti keessa dabarrutti karaa guddaa mootichaa irraa asii fi achi middaa fi bitaa adoo hin gorin hin ideenna› jedha'aa itti hima'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU20_18","005_20_18","NUM","20","18","18","Mootiin Edoomii deebisee, «Nuuti akka isin biyya teenna keessa dabartanu hin eeyyannu! Dabariisaaf yoo wodhaantane, shallaaga'aan baanee isin lolla» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU20_19","005_20_19","NUM","20","19","19","Israa'elooti deebisanee, «Nuuti karaa guddaa irraa hin gorru, nuutille yookiin horiin keennalle yoo bisaan keessan une hin kaffalla; nuuti miila qofaan keessa dabarra malee, waan dhibii womaa hin goonu» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU20_20","005_20_20","NUM","20","20","20","Mootiin Edoomii ammalle deebisee, «Isin as keessa hin dabartanu» jedhe; achiin duuba isaan loliisaaf, loltoota baca'aa fi hunnaameyyii woliin baye. ");
INSERT INTO gax_vpl VALUES ("NU20_21","005_20_21","NUM","20","21","21","Mootiin Edoomii worra Israa'elootaa lafa ifii keessa dabariisa waan dhooggeef, Israa'elooti irraa goranee karaa dhibii deemane. ");
INSERT INTO gax_vpl VALUES ("NU20_22","005_20_22","NUM","20","22","22","Kolbaan Israa'elii duudiin Qaadeshii kaatee gara gaara Hoorii dhaxxe. ");
INSERT INTO gax_vpl VALUES ("NU20_23","005_20_23","NUM","20","23","23","Gaara Hoorii ka meessaa lafa Edoomiititti, Mootiin Waan Maraa Muuse'ee fi Aaroniin, ");
INSERT INTO gax_vpl VALUES ("NU20_24","005_20_24","NUM","20","24","24","«Aaron hin du'a; isin lamaanuu bisaan Mariiba'aa biratti diddanee seera kiyya irratti waan kaataneef, inni gara lafa ani Israa'elootaaf kennetti hin galu. ");
INSERT INTO gax_vpl VALUES ("NU20_25","005_20_25","NUM","20","25","25","Aaronii fi ilma isaa Ele'azaar fuudhiitii gaara Hooriititti ol bayi; ");
INSERT INTO gax_vpl VALUES ("NU20_26","005_20_26","NUM","20","26","26","achitti woyaa Aaronii hayyicha gudda'aa ta hayyumma'aa irraa baasiitii ilma isaa Ele'azaaritti uffisi. Aaron achitti hin du'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU20_27","005_20_27","NUM","20","27","27","Muuseen akkuma Mootiin Waan Maraa ajaje godhe; isaan kolbaan duudiin adoo ilaaltuu gara gaara Hoorii ol bayane. ");
INSERT INTO gax_vpl VALUES ("NU20_28","005_20_28","NUM","20","28","28","Muuseen woyaa Aaronii ta hayyumma'aa irraa baasee ilma isaa Ele'azaaritti uffise. Aaron achitti qaccee gaaraa irratti du'e. Achiin duuba Muuse'ee fi Ele'azaar gara irraa gad bu'ane. ");
INSERT INTO gax_vpl VALUES ("NU20_29","005_20_29","NUM","20","29","29","Kolbaan duudiin Aaron akka du'e yennaa dhageette, Israa'elooti martinuu guyyaa soddoma isaaf bowane. ");
INSERT INTO gax_vpl VALUES ("NU21_1","005_21_1","NUM","21","1","1","Mootichi Araadii nami biyya Kana'aanotaa, ka Negeb keessa le'u, Israa'elooti karaa Ataariim geessuun dhufiisatti akka jiranu yennaa dhage'e, isaan lolee, isaan keessaa garii booji'e. ");
INSERT INTO gax_vpl VALUES ("NU21_2","005_21_2","NUM","21","2","2","Achiin duuba Israa'elooti, «Ati yoo kolbaa tana harka keennatti dabarsitee kennite, nuuti qachoota isaanii ijjumaa hin balleessina» jedhanee Mootii Waan maraatiif waadaa galane. ");
INSERT INTO gax_vpl VALUES ("NU21_3","005_21_3","NUM","21","3","3","Mootiin Waan Maraa qoonqoo Israa'elootaa dhage'ee, worra Kana'aanotaa harka isaaniititti dabarsee kenne; Israa'elootille isaanii fi qachoota isaaniille ijjumaa balleessanee, maqaan addee sanii, «Hormaa» jedhamee moggaasane. ");
INSERT INTO gax_vpl VALUES ("NU21_4","005_21_4","NUM","21","4","4","Israa'elooti lafa Edoomii irra maranee dabariisaaf, gaara Hooriitii ka'anee karaa abbaayaa diintuu geessu deemane; kolbaan ammoo karaa irratti ossa fixattee, ");
INSERT INTO gax_vpl VALUES ("NU21_5","005_21_5","NUM","21","5","5","Waaqaa fi Muusee irratti gunguntee, «Goomolee tana keessatti akka duunuuf, isin biyya Gibxi'ii keessaa maaf nu baattane? Sagaleen hin jirtu! Bisaan hin jiru! Nuuti sagalee womaa hin baane tana jibbineera» jette. ");
INSERT INTO gax_vpl VALUES ("NU21_6","005_21_6","NUM","21","6","6","Achiin duuba Mootiin Waan Maraa dhudhuufaa odduu kolba'aatitti ergee, Israa'elooti hedduun dhudhuufa'aan iddamanee dhumatane. ");
INSERT INTO gax_vpl VALUES ("NU21_7","005_21_7","NUM","21","7","7","Kolbaan gara Muuse'ee dhuttee, «Nuuti Mootii Waan Maraatii fi si'i irralle'etti kaanee dubbannee yakkineerra; dhudhuufaa kana akka nu irraa fageessuuf, gara Mootii Waan Maraa nu'uuf daadimadhu» jette. Maarre Muuseen kolba'aaf daadimate. ");
INSERT INTO gax_vpl VALUES ("NU21_8","005_21_8","NUM","21","8","8","Mootiin Waan Maraalle Muuse'een, «Dhudhuufaa sageettu'uu tolchiitii utuba'atti fannis; nami dhudhuufaan idde gara isaa yoo ilaale hin fayya» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU21_9","005_21_9","NUM","21","9","9","Maarre Muuseen dhudhuufaa sageettu'uu hujee dongora'atti fannise; nami dhudhuufaan idde martinuu, gara dhudhuufaa sageettuu irraa hujame sanii yennaa ilaale fayye. ");
INSERT INTO gax_vpl VALUES ("NU21_10","005_21_10","NUM","21","10","10","Israa'elooti addee sanii ka'anee Obooti qubatane. ");
INSERT INTO gax_vpl VALUES ("NU21_11","005_21_11","NUM","21","11","11","Isaan Obootii ka'anee, lafa Mo'aabotaatiin gara aduun baatu, goomolee keessa Iyye-Abaariim qubatane. ");
INSERT INTO gax_vpl VALUES ("NU21_12","005_21_12","NUM","21","12","12","Achii ka'anee dhooqa Zeredii keessa qubatane. ");
INSERT INTO gax_vpl VALUES ("NU21_13","005_21_13","NUM","21","13","13","Achille'ee ka'anee goomolee haga lafa Amoorotaatitti badhattu keessa laga Aarnoniitiin gama qubatane; lagi Aarnonii Mo'aabotaa fi Amoorota odduu meessaa irra jira. ");
INSERT INTO gax_vpl VALUES ("NU21_14","005_21_14","NUM","21","14","14","Tanaaf Kitaaba lolaa ka Mootii Waan Maraa keessatti, «Waahebii Sufaa keessaatitti, dhooqa laga Aarnoniititti, ");
INSERT INTO gax_vpl VALUES ("NU21_15","005_21_15","NUM","21","15","15","goodda gara dhooqa sanii ta haga qachaa Aarii ka meessaa Mo'aabiititti» jedhame. ");
INSERT INTO gax_vpl VALUES ("NU21_16","005_21_16","NUM","21","16","16","Isaan achii ka'anee gara Berii, lafa bisaan boollaa addee Mootiin Waan Maraa Muuse'een, «Kolbaa wolitti qabi; anille bisaan isaanii hin kenna» jedhee, dhaqane. ");
INSERT INTO gax_vpl VALUES ("NU21_17","005_21_17","NUM","21","17","17","Achiin duuba kolbaan Israa'elii, «Ee boolla bisaanii, bisaan burqi! Nuutille faaru'uun nageya si fuuna! ");
INSERT INTO gax_vpl VALUES ("NU21_18","005_21_18","NUM","21","18","18","Boolla bisaanii ta bulchitootii fi qondaaltoti kolba'aa ulee bokku'uutii fi ulee ifiitiin gad qotane» jedhanee faaruu tana faarsane. Achiin duuba goomolee sanii ka'anee gara Maataanaa deemane; ");
INSERT INTO gax_vpl VALUES ("NU21_19","005_21_19","NUM","21","19","19","Maataanaalle'ee ka'anee gara Naahaalii'elii, Naahaalii'elille'ee ka'anee gara Baamotii, ");
INSERT INTO gax_vpl VALUES ("NU21_20","005_21_20","NUM","21","20","20","Baamotille'ee ka'anee gara dhooqa goomolee lafa Mo'aabotaa keessaa, ta qaccee gaara Phiisga'aa irraa gad mudhattuu dhaqane. ");
INSERT INTO gax_vpl VALUES ("NU21_21","005_21_21","NUM","21","21","21","Achiin duuba Israa'elooti mooticha Amoorotaa Sihoonitti nama erganee, ");
INSERT INTO gax_vpl VALUES ("NU21_22","005_21_22","NUM","21","22","22","«Biyya teeti keessa nu dabarsi. Nuuti biyya teeti keessa haga dabarutti karaa guddaa mootichaa irra ideenna malee, gara fichaa tokkoolle yookiin gara oorruu woynii takkaalle hin gorru; baleessa tokkolle keessaa bisaan hin unnu» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU21_23","005_21_23","NUM","21","23","23","Mootichi Sihoon ammoo kolbaan Israa'elii akka lafa isaa keessa dabartu hin eeyyanne. Inni loltoota ifii wolitti qabatee, Israa'eloota loliisaaf gara goomole'ee dhaqee, Yaahazitti Israa'eloota lole. ");
INSERT INTO gax_vpl VALUES ("NU21_24","005_21_24","NUM","21","24","24","Te'uu malee, Israa'elooti isa ijjeesanee, lafa isaa laga Aarnoniitii haga laga Yaaboqiititti, haga meessaa Amoonotaatitti qabatane; meessaan Amoonotaa guddoo waan eegameeruuf laga Yaaboqii hin dabarre. ");
INSERT INTO gax_vpl VALUES ("NU21_25","005_21_25","NUM","21","25","25","Maarre Israa'elooti qachoota Amoorotaa Heshiboonii fi qachoota adaala isaa mara qabatanee, keessatti qubatane. ");
INSERT INTO gax_vpl VALUES ("NU21_26","005_21_26","NUM","21","26","26","Heshiboon qachaa guddicha mootii Amoorotaa Sihoonii ti; inni dur mooticha Mo'aabii ka durii lolee, lafa isaa haga laga Aarnoniititti irraa fudhateera. ");
INSERT INTO gax_vpl VALUES ("NU21_27","005_21_27","NUM","21","27","27","Tanaaf worri weeddisu, «Gara Heshiboonii kowa'a! Qachaan kun deebi'ee ijaaramuu ti; qachaan guddichi Sihoonii adde'etti deebi'uu ti! ");
INSERT INTO gax_vpl VALUES ("NU21_28","005_21_28","NUM","21","28","28","Ibiddi Heshiboon keessaa ka'ee, bobeenni qachaa Sihoonii keessaa bobe'ee, qachaa Aarii ka Mo'aab keessaa luxub godhee, goottolee koobota Aarnonii gube. ");
INSERT INTO gax_vpl VALUES ("NU21_29","005_21_29","NUM","21","29","29","Ee Mo'aab, si'iif aanne'e! Ee kolbaa Kemoshii isin baddane! Kemoshi ilmaan ifii akka baqattu, ijoollee ifii ta durraa akka booji'antu, mooticha Amoorotaa Sihoonitti dabarsee kenneera. ");
INSERT INTO gax_vpl VALUES ("NU21_30","005_21_30","NUM","21","30","30","Nuuti ammoo isaan garagalchine; Heshiboon haga Diiboniititti badde; Heshiboonii haga Diiboniititti, haga Nofaatitti, haga Madabaatitti isaan balleessine» jedhane. ");
INSERT INTO gax_vpl VALUES ("NU21_31","005_21_31","NUM","21","31","31","Maarre Israa'elooti lafa Amoorotaa keessatti qubatane. ");
INSERT INTO gax_vpl VALUES ("NU21_32","005_21_32","NUM","21","32","32","Muuseen qachaa Yaazerii akka dooyanu worra dooyu ergeen duuba, Israa'elooti Yaazerii fi qachoota adaala sanii qabatanee Amoorota achi le'anu ari'anee baasane. ");
INSERT INTO gax_vpl VALUES ("NU21_33","005_21_33","NUM","21","33","33","Achiin duuba Israa'elooti deebi'anee, karaa Baashaan geessu gula ol bayane; mootichi Baashaanii Oog Edraayitti isaan loliisaaf loltoota ifii duudii woliin duula baye. ");
INSERT INTO gax_vpl VALUES ("NU21_34","005_21_34","NUM","21","34","34","Mootiin Waan Maraa Muuse'een, «Ati isa hin sodaatin; ani isaa fi loltoota isaa, lafa isaalle harka keetitti dabarsee hin kenna. Mootii Amoorotaa Sihoon, ka qachaa Heshiboonii keessa tee'ee bulche akkuma goote, Oogille akkasuma godhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU21_35","005_21_35","NUM","21","35","35","Maarre Israa'elooti Oog, ilmaan isaatii fi loltoota isaa duudii nama tokkolle adoo hin hamburin ijjeesanee, lafa isaalle qabatane. ");
INSERT INTO gax_vpl VALUES ("NU22_1","005_22_1","NUM","22","1","1","Achiin duuba Israa'elooti gara dirree Mo'aabii ka'anee deemanee, laga Yordaanosii irraa gara aduun baatuun, fuullee Yeriko'oo qubatane. ");
INSERT INTO gax_vpl VALUES ("NU22_2","005_22_2","NUM","22","2","2","Mootiin Mo'aabii, ilmi Ziphoorii Balaaqi, waan Israa'elooti Amoorota godhane mara dhagge. ");
INSERT INTO gax_vpl VALUES ("NU22_3","005_22_3","NUM","22","3","3","Israa'elooti kolbaa hedduu waan teeteef, Mo'aaboti akka malee sodaatte. Dhugumaan, namooti Mo'aabii Israa'eloota sodaatanee sheephisane. ");
INSERT INTO gax_vpl VALUES ("NU22_4","005_22_4","NUM","22","4","4","Mo'aaboti maanguddoo Miidiyaaniitiin, «Akkuma qotiyyoon marra diida keessaa muxuqqi gootu, gumiin tun waan adaala keenna jiru mara muxuqqi hin gooti» jedhane; tanaaf ilmi Siphoorii Balaaqi, ka yennaa san mootii Mo'aabii te'eeru, ");
INSERT INTO gax_vpl VALUES ("NU22_5","005_22_5","NUM","22","5","5","ilma Be'orii Bala'aam ka qachaa Phetorii qarqara laga Efraaxiisii lafa dhaloota ifii jiru waansisiisaaf nama itti ergee, «Kolbaan takka biyya Gibxi'iitii dhuttee, lafa duudii guutteerti. Isaan dhikoo tiyya qabataneeran. ");
INSERT INTO gax_vpl VALUES ("NU22_6","005_22_6","NUM","22","6","6","Isaan na caalaa hunnaameyyi'i; tanaaf koyiitii isaan naa abaari; akka wotoo ani isaan injifadhee biyya keessaa ari'ee isaan baasuu hin dande'a fa te'a. Nami ati eebbitte eebbifamaa, nami ati arbaartelle abaaramaa akka te'u ani hin beeka» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_7","005_22_7","NUM","22","7","7","Maarre maanguddooti Mo'aabiitii fi Miidiyaanii beesee kaffaltii moru'uu qabatanee, gara Bala'aamii dhaqanee, ergaa Balaaqii itti himane. ");
INSERT INTO gax_vpl VALUES ("NU22_8","005_22_8","NUM","22","8","8","Bala'aam isaaniin, «Edana as bula'a; anille boru waan Mootiin Waan Maraa natti hime isinitti hin hima» jedheen. Maarre maanguddooti Mo'aabotaa Bala'aam bira bulte. ");
INSERT INTO gax_vpl VALUES ("NU22_9","005_22_9","NUM","22","9","9","Waaqi gara Bala'aamii dhufee, «Jarri si woliin jirtu tun eennu fa'a?» jedhee gaafate. ");
INSERT INTO gax_vpl VALUES ("NU22_10","005_22_10","NUM","22","10","10","Bala'aam deebisee, Waaqaan, «Mootiin Mo'aabii, ilmi Ziphoorii Balaaqi ergantoota tana gara kiyya ergee, ");
INSERT INTO gax_vpl VALUES ("NU22_11","005_22_11","NUM","22","11","11","‹Kolbaan takka biyya Gibxi'iitii dhuttee lafa duudii guutteerti; amma koyiitii isaan naaf abaari; achiin duuba ani akka wotoo isaan lolee biyya keessaa ari'ee isaan baasuu hin dande'a fa te'a› anaan jedhe» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_12","005_22_12","NUM","22","12","12","Waaqi ammoo Bala'aamiin, «Isaan woliin hin dhaqin. Kolbaan sun ta eebbifante waan teeteef, ati isaan hin abaarin» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_13","005_22_13","NUM","22","13","13","Bala'aam boruyyaa ganama ka'ee, qondaaltota Balaaqi erge saniin, «Akka ani isin woliin dhaqu, Mootiin Waan Maraa waan na dhooggeef, gara mana keessanii gala'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_14","005_22_14","NUM","22","14","14","Maarre qondaaltoti worra Mo'aabotaa gara Balaaqii dhaqanee, «Bala'aam nu woliin dhufuu dide» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("NU22_15","005_22_15","NUM","22","15","15","Balaaqi ammalle qondaaltota dhibii ka qondaaltota duraa san caalaa heddatanuu fi worra ulfinna qabanu Bala'aamitti erge. ");
INSERT INTO gax_vpl VALUES ("NU22_16","005_22_16","NUM","22","16","16","Isaan gara Bala'aamii dhaqanee, «Ilmi Ziphoorii Balaaqi, ‹Gara kiyya dhufiisa irraa wonni tokkolle si hin dhooggin! ");
INSERT INTO gax_vpl VALUES ("NU22_17","005_22_17","NUM","22","17","17","Sababille ani ulfinna guddaa si'iif hin kenna; waan ati jette maralle hin godha. Koyiitii, kolbaa tana naaf abaari› siin jedheera» jedhaneen. ");
INSERT INTO gax_vpl VALUES ("NU22_18","005_22_18","NUM","22","18","18","Bala'aam ammoo deebisee isaaniin, «Balaaqi mana ifii ka mootumma'aa ka meeti'ii fi worqi'iin guutame san yoo naaf kennelle, ani ajaja Waaqa kiyya Mootii Waan Maraa irra dabaree waan guddoo yookiin waan diqqoo hujuu hin dande'u. ");
INSERT INTO gax_vpl VALUES ("NU22_19","005_22_19","NUM","22","19","19","Ammalle waan Mootiin Waan Maraa dabalee natti dubbatu akka beekuuf, worri duraa sun akkuma as bulane, isinille edana as bula'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_20","005_22_20","NUM","22","20","20","Halkan san, Waaqi gara Bala'aamii dhufee, «Jarri tun si waamiisaaf yoo dhufaneeranu teete, ka'ii isaan woliin deemi; ammoo waan ani sitti himu qofa huji» jedheen. ");
INSERT INTO gax_vpl VALUES ("NU22_21","005_22_21","NUM","22","21","21","Maarre Bala'aam ganama ka'ee, harree ifii fe'atee, qondaaltota worra Mo'aabii woliin deeme. ");
INSERT INTO gax_vpl VALUES ("NU22_22","005_22_22","NUM","22","22","22","Yennaa Bala'aam deeme, Waaqi ammoo guddoo itti aare; ergamaan Mootii Waan Maraa isa mormiisaaf karaa keessa dhaabbate. Yennaa san Bala'aam harree irra tee'eeraayyu; tajaajiltooti isaa lamaan isa woliin jiraniiyyu. ");
INSERT INTO gax_vpl VALUES ("NU22_23","005_22_23","NUM","22","23","23","Harreen sun ergamaan Mootii Waan Maraa shallaagaa buqqifatee, harkatti qabatee, karaa keessa dhaabbatuun yennaa dhaggite, karaa irraa ficha'atti gorte; Bala'aamille kara'atti deebisiisaaf dhowe. ");
INSERT INTO gax_vpl VALUES ("NU22_24","005_22_24","NUM","22","24","24","Achiin duuba ergamaan Mootii Waan Maraa karaa dhiphaa addee oorruu woyni'ii lamaan ka dalleenni dhaka'aa gara lamaaniinuu jiru keessa dhaabbate. ");
INSERT INTO gax_vpl VALUES ("NU22_25","005_22_25","NUM","22","25","25","Harreen sun ergamaa Mootii Waan Maraa yennaa dhaggite, gara dalleya dhaka'aa maxxantee, miila Bala'aamiille dalleya dhaka'aatitti maxxansite. Maarre inni ammalle isii dhowe. ");
INSERT INTO gax_vpl VALUES ("NU22_26","005_22_26","NUM","22","26","26","Ergamaan Mootii Waan Maraa gara duraa deemee, addee dhiphoo, middatti yookiin bita'atti garagaliisaaf karaan hin jirre dhaabbate. ");
INSERT INTO gax_vpl VALUES ("NU22_27","005_22_27","NUM","22","27","27","Harreen sun ergamaa Mootii Waan Maraa yennaa dhaggite, Bala'aam duraa gad ciitte; Bala'aamille guddoo aaree, ulee ifiitiin isii dhowe. ");
INSERT INTO gax_vpl VALUES ("NU22_28","005_22_28","NUM","22","28","28","Achiin duuba Mootiin Waan Maraa afaan harree sanii banee, harreen sun Bala'aamiin, «Ani maan si goonaan, ati yennaa sad na dhootte?» jette. ");
INSERT INTO gax_vpl VALUES ("NU22_29","005_22_29","NUM","22","29","29","Bala'aam harree saniin, «Ati waan naan taphatteef ree! Ani adoo shallaagaa harkaa qabaadhee, ammuma silaa si ijjeesaayyu!» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_30","005_22_30","NUM","22","30","30","Harreen sun deebittee, Bala'aamiin, «Ani harree teeti ta ati yennaa mara, haga guyyaa adhaatitti irra teettuu motii? Ani akkas sitti te'ee beekaa?» jette. Innille, «Waawwo'o» jedheen. ");
INSERT INTO gax_vpl VALUES ("NU22_31","005_22_31","NUM","22","31","31","Achiin duuba Mootii Waan Maraa ila Bala'aamii banee, ergamaan Mootii Waan Maraa shallaagaa buqqifate san harkatti qabatee, karaa keessa dhaabbatuun dhagge; Bala'aam fuula ifiitiin lafatti gad gombifame. ");
INSERT INTO gax_vpl VALUES ("NU22_32","005_22_32","NUM","22","32","32","Ergamaan Mootii Waan Maraa, «Ati maaf harree teeti yennaa sad akkana dhootte? Ati karaa dabaa deemiisatti waan jirtuuf, ani si mormiisaaf dhufeera. ");
INSERT INTO gax_vpl VALUES ("NU22_33","005_22_33","NUM","22","33","33","«Harreen teeti na dhaggitee, yennaa sad na irraa gorte. Adoo isiin na irraa goruu dhaddee, ani silaa dhugumaan, amma si ijjeesee isii lakkiseeraayyu» jedheen. ");
INSERT INTO gax_vpl VALUES ("NU22_34","005_22_34","NUM","22","34","34","Bala'aam, ergamaa Mootii Waan Maraatiin, «Ani cubbuu hujeera; akka ati anaan mormiisaaf, karaa keessa dhaabbatteertu hin beenne. Amma deemiisi kiyya kun yoo si gammachiisin hin deebi'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_35","005_22_35","NUM","22","35","35","Ergamaan Mootii Waan Maraa, Bala'aamiin, «Jara tana woliin deemi; ammoo waan ani sitti himu qofa dubbadhu» jedhe. Maarre Bala'aam qondaaltota Balaaqii woliin deeme. ");
INSERT INTO gax_vpl VALUES ("NU22_36","005_22_36","NUM","22","36","36","Balaaqi akka Bala'aam dhufiisatti jiru yennaa dhage'e, isa fudhatiisaaf gara qachaa Aarii ka Mo'aab keessaa, ka bisaan Aaronii bira irga lafa isaa jiruu dhaqe. ");
INSERT INTO gax_vpl VALUES ("NU22_37","005_22_37","NUM","22","37","37","Balaaqi, Bala'aamiin, «Ani akka ati ariifattee dhuttu gara keeti ergeeraayyuu motii? Ati maaf gara kiyya dhufuu dhadde? Ani ulfinna sii kennuu hin dande'uu?» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_38","005_22_38","NUM","22","38","38","Bala'aam deebisee, «Kunoo, amma gara keeti dhufeera; ammoo waan Waaqi akka dubbadhu natti hime qofa dubbadha malee, waan tokkolle hin dubbadhu» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU22_39","005_22_39","NUM","22","39","39","Achiin duuba Bala'aam Balaaqi woliin gara qachaa Kiriiyat-Huzotii dhaqe. ");
INSERT INTO gax_vpl VALUES ("NU22_40","005_22_40","NUM","22","40","40","Balaaqi loonii fi hoolota ciincaa dhikeessee, foon isaanii irraa garii Bala'aamii fi qondaaltota isa woliin jiranuuf kenne. ");
INSERT INTO gax_vpl VALUES ("NU22_41","005_22_41","NUM","22","41","41","Balaaqi boruyyaa ganama Bala'aam fuudhee gara Baamot-Ba'aaliititti ol baase; inni achi dhaabbatee kolbaa Israa'elii worra cinaa quttumaa jiranu dhagge. ");
INSERT INTO gax_vpl VALUES ("NU23_1","005_23_1","NUM","23","1","1","Bala'aam, Balaaqiin, «Addee ciinca'aa torba asitti naaf ijaari; korommii torbaa fi korbeeyyii hoole'ee torba naaf qopheessi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_2","005_23_2","NUM","23","2","2","Balaaqi akkuma Bala'aam jedhe godhe; Balaaqii fi Bala'aamille addee ciinca'aa tokko tokko irrattuu korma tokkoo fi korbeessa hoole'ee tokko ciinca'aaf dhikeessane. ");
INSERT INTO gax_vpl VALUES ("NU23_3","005_23_3","NUM","23","3","3","Achiin duuba Bala'aam, Balaaqiin, «Ani yennaa achi deemu, ati ciincaa keeti ka gubamu bira as turi; akka wotoo Mootiin Waan Maraa natti mudhatiisaaf hin dhufa fa te'a. Waan inni natti mudhisu mara ani sitti hin hima» jedhe. Maarre inni gara kooba godduu takkaa dhaqe. ");
INSERT INTO gax_vpl VALUES ("NU23_4","005_23_4","NUM","23","4","4","Achiin duuba Waaqille Bala'aamitti mudhate; Bala'aamille isaan, «Ani addee ciinca'aa torba qopheessee, tokko tokkooyyuu irratti korma tokkoo fi korbeessa hoole'ee tokko dhikeesseera» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_5","005_23_5","NUM","23","5","5","Mootiin Waan Maraa waan Bala'aam dubbatu afaan keessa keyeefii, «Gara Balaaqii deebi'iitii ergaa tana itti himi» jedheen. ");
INSERT INTO gax_vpl VALUES ("NU23_6","005_23_6","NUM","23","6","6","Maarre inni gara Balaaqii deebi'ee, inni qondaaltota Mo'aabii mara woliin ciincaa ifii ka gubamu bira dhaabbatuun dhagge. ");
INSERT INTO gax_vpl VALUES ("NU23_7","005_23_7","NUM","23","7","7","Achiin duuba Bala'aam raagee, «Mootiin Mo'aabii Balaaqi gaarota gara aduun baatuu irraa biyya Aaramii na fidee, Balaaqi, ‹Koyiitii, kolbaa Yaaqoobii naa abaari; koyiitii, kolbaa Israa'elii badin!› jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_8","005_23_8","NUM","23","8","8","Ka Waaqi hin abaarin ani attam abaara? Ka Mootiin Waan maraa hin badinin ani attam badina? ");
INSERT INTO gax_vpl VALUES ("NU23_9","005_23_9","NUM","23","9","9","Ani gaara rassa'aa irraa isaan dhagga; kooba irraa isaan ilaala; isaan kolbaa qofuu leetu, ta gosa biyya adda addaalle'etti ifi hin laakkonne dhagga! ");
INSERT INTO gax_vpl VALUES ("NU23_10","005_23_10","NUM","23","10","10","Sanyii Yaaqoobii ta akka biyye'ee eentu laakkowa? Yookiin gamisuma gamisa laakkossa Israa'eliille eentu laakkowuu dande'a? Ani du'a balcha'aa du'uu ti; muummeen tiyyalle akka muummee isaanii teetuu ti!» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_11","005_23_11","NUM","23","11","11","Balaaqi, Bala'aamiin, «Wonni ati na irratti hujje kun maan? Ani diinota kiyya akka naa abaartuuf si fide, ati ammoo isaan eebbitte malee, womaa isaan hin goone» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_12","005_23_12","NUM","23","12","12","Inni deebisee, «Waan Mootiin Waan Maraa akka ani dubbadhuuf natti hime dubbatiisa qabaa motii ree?» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_13","005_23_13","NUM","23","13","13","Achiin duuba Balaaqi, Bala'aamiin, «Gara addee dhibi'ii ta isaan dhagguu dandeettu woliin dhandhaatii koy; isaan keessaa worra diqqaa qofa malee, mara isaanii hin dhaggitu. Achi dhaabbadhuutii isaan naaf abaari» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_14","005_23_14","NUM","23","14","14","Maarre inni mataa gaara Phiisga'aa irra, gara diida Zofiimii isa geesse. Achitti addee ciinca'aa torba ijaaree, tokko tokko irrattuu korma tokkoo fi korbeessa hoole'ee tokko ciincaa dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU23_15","005_23_15","NUM","23","15","15","Bala'aam, Balaaqiin, «Ani achitti Mootii Waan Maraatiin wol dhaggiisaaf yennaa deemu, ati ciincaa keeti ka gubamu bira as turi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_16","005_23_16","NUM","23","16","16","Mootiin Waan Maraa Bala'aamitti mudhatee, ergaa inni dubbatu itti himee, «Gara Balaaqii deebi'iitii ergaa tana itti himi» jedheen. ");
INSERT INTO gax_vpl VALUES ("NU23_17","005_23_17","NUM","23","17","17","Maarre inni deebi'ee, qondaaltota Mo'aabii woliin ciincaa ifii bira dhaabbatuun isa dhagge. Balaaqi, «Mootiin Waan Maraa maan jedhe?» jedhee Bala'aam gaafate. ");
INSERT INTO gax_vpl VALUES ("NU23_18","005_23_18","NUM","23","18","18","Bala'aamille ergaa raagaa, «Balaaqi, ka'iitii caqasi! Ee, ilma Ziphoorii na dhage'i! ");
INSERT INTO gax_vpl VALUES ("NU23_19","005_23_19","NUM","23","19","19","Waaqi ilma namaatii motii, inni hin hollu; yookiin akka namaa yaada ifii hin jijjiiratu. Inni waadaa gale hin muummessa; waan dubbatelle hin guuta. ");
INSERT INTO gax_vpl VALUES ("NU23_20","005_23_20","NUM","23","20","20","Kunoo, ani eebbisiisaaf ajajameera; inni eebbiseera; ani eebba isaa jijjiiree hin dande'u. ");
INSERT INTO gax_vpl VALUES ("NU23_21","005_23_21","NUM","23","21","21","Kolbaa Yaaqoobii keessatti wonni hantuun, Israa'el keessatti rakkoon hin dhagganne. Mootiin Waan Maraa, Waaqi isaan woliin jira; isaan mootii ifii leellisan. ");
INSERT INTO gax_vpl VALUES ("NU23_22","005_23_22","NUM","23","22","22","Waaqi biyya Gibxi'iitii isaan baase; inni isaaniif akka gaafa gafarsaa ti. ");
INSERT INTO gax_vpl VALUES ("NU23_23","005_23_23","NUM","23","23","23","Ilmaan Yaaqoobii irratti xanoon, Israa'el irrattille moruun hin hujju. Amma waan Yaaqoobiitii fi Israa'elii, ‹Waan Waaqi godhe dhagga'a!› hin jedhama. ");
INSERT INTO gax_vpl VALUES ("NU23_24","005_23_24","NUM","23","24","24","Kolbaan Israa'elii akka neenqa dhala'aa ol kaati; isaan akka neenqa waan adansee qabate haga nyaatutti, dhiigalle haga unutti ciisa dhabee ol ka'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_25","005_23_25","NUM","23","25","25","Achiin duuba Balaaqi, Bala'aamiin, «Ati isaan eega hin abaarin hin eebbisinille'e!» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_26","005_23_26","NUM","23","26","26","Bala'aam deebisee Balaaqiin, «Ani waan Mootiin Waan Maraa jedhe qofa akka godhu, sitti himee hin jiruu?» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_27","005_23_27","NUM","23","27","27","Achiin duuba Balaaqi, Bala'aamiin, «Amma addee dhibii si geessaa koy; achi dhaabbattee akka ati isaan naaf abaartu Waaqi hin jaalata fa te'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_28","005_23_28","NUM","23","28","28","Maarre Balaaqi, Bala'aam gara qaccee gaara Phe'orii ka irra dhaabbatanee lafa goomole'ee dhagganu geesse. ");
INSERT INTO gax_vpl VALUES ("NU23_29","005_23_29","NUM","23","29","29","Bala'aam, Balaaqiin, «Asitti addee ciinca'aa torba naaf ijaariitii, korommii torbaa fi korbeeyyii hoole'ee torba naaf qopheessi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU23_30","005_23_30","NUM","23","30","30","Maarre Balaaqi akkuma Bala'aam jedhe godhe; addee ciinca'aa tokko tokko irrattuu korma tokkoo fi korbeessa hoole'ee tokko ciincaa dhikeesse. ");
INSERT INTO gax_vpl VALUES ("NU24_1","005_24_1","NUM","24","1","1","Bala'aam Israa'eloota eebbisuun Mootii Waan Maraa akka gammachiitte yennaa dhagge, inni fuula ifii gara goomole'ee deebifate malee, akka yennaa dhibi'ii waan ittiin moru barbaadatiisa hin dhandhe. ");
INSERT INTO gax_vpl VALUES ("NU24_2","005_24_2","NUM","24","2","2","Bala'aam ol ilaalee, worri Israa'elii gosa gosaan qubataneeranuun yennaa dhagge, Ayyaanni Waaqaa isa irratti bu'ee, ");
INSERT INTO gax_vpl VALUES ("NU24_3","005_24_3","NUM","24","3","3","ergaa dubbattee, «Ergaan Bala'aamii ilma Be'orii, ergaan nama ilti isaa banantee, ");
INSERT INTO gax_vpl VALUES ("NU24_4","005_24_4","NUM","24","4","4","ergaan nama jecha Waaqaa dhage'uu, ka mudhii ka waan mara dande'uu dhagguu, ka isa duratti gad jigeeruun, ilti isaa banantee kana: ");
INSERT INTO gax_vpl VALUES ("NU24_5","005_24_5","NUM","24","5","5","«Ee Yaaqoob, dunkaanoti teeti, ee Israa'el quttumi keeti, attam attam dansa'a! ");
INSERT INTO gax_vpl VALUES ("NU24_6","005_24_6","NUM","24","6","6","«Isaan akka meexxii banqaaxxuu, akka oorruu bisaan biraa ti; isaan akka hargiisa Mootiin Waan Maraa dhaabee ti; isaan akka hindheensa bisaan biraa ti. ");
INSERT INTO gax_vpl VALUES ("NU24_7","005_24_7","NUM","24","7","7","«Sakkeelloo isaanii keessaa bisaan hin yaa'a; sanyiin midhaan isaanii bisaan guddaa hin dhaggatti. «Mootiin isaanii mootii Agaagii hin caala; mootummaan isaaniille hin leellifanti. ");
INSERT INTO gax_vpl VALUES ("NU24_8","005_24_8","NUM","24","8","8","«Waaqi biyya Gibxi'iitii isaan baase, inni isaaniif akka gaafa gafarsaa ti. Inni gosa biyya adda addaa diinota isaanii hin kukkuta; lafee isaaniille hin butucha; daaya ifiitiin woraanee isaan fullaasa. ");
INSERT INTO gax_vpl VALUES ("NU24_9","005_24_9","NUM","24","9","9","«Isaan irkatanee, akka neenqa dhala'aatii fi neenqa kormaa gad ciisane; isaan kaasiisaaf ka itti guulu eennu? «Worri si eebbisu eebbifamuu ti! Worri si abaaru abaaramuu ti!» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU24_10","005_24_10","NUM","24","10","10","Achiin duuba Balaaqi, Bala'aamitti aaree bobe'ee, harka dhowee, «Ani akka ati diinota kiyya abaartuuf si waame; ati ammoo kunoo yennaa sad isaan eebbitte. ");
INSERT INTO gax_vpl VALUES ("NU24_11","005_24_11","NUM","24","11","11","Amma ariifadhuu gara mana keetii deemi! Ani silaa, ‹Gatii dansaa si'iif hin kaffala› jedheeraayyu. Mootiin Waan Maraa ammoo gatii dhaggatiisa si dhoogge» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU24_12","005_24_12","NUM","24","12","12","Bala'aamille deebisee, Balaaqiin, «Ani ergantoota teeti ta ati natti ergitetti himee, ");
INSERT INTO gax_vpl VALUES ("NU24_13","005_24_13","NUM","24","13","13","‹Balaaqi mana ifii ka mootumma'aa ka meeti'ii fi worqi'iin guutame san yoo naaf kennelle, waan Mootiin Waan Maraa natti dubbate qofa dubbadha male, jecha isaa irra dabaree, fedha kiyyaan waan dansaa yookiin waan badduu godhiisaaf hin dande'u› hin jenneeyyuu? ");
INSERT INTO gax_vpl VALUES ("NU24_14","005_24_14","NUM","24","14","14","Maarre amma ani gara kolbaa tiyyaa deebi'ee deemaara; gara duraa ammoo waan kolbaan Israa'elii tun kolbaa teeti irratti godhu'uuf jirtu koy sitti hima» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU24_15","005_24_15","NUM","24","15","15","Achiin duuba ergaa dubbatee, «Ergaan Bala'aamii ilma Be'orii, ergaan nama ilti isaa banantee, ");
INSERT INTO gax_vpl VALUES ("NU24_16","005_24_16","NUM","24","16","16","Ergaan nama jecha Waaqaa dhage'uu, ka beekkumsa Ol Aana'aa qabuu, ka mudhii ka waan mara dande'uu dhagguu, ka isa duratti gad jigeeruun, ilti isaa banantee kana: ");
INSERT INTO gax_vpl VALUES ("NU24_17","005_24_17","NUM","24","17","17","«Ani isa dhagga, ammoo ammaa moti; ani isa ilaala, ammoo dhiko'ottii moti. Bakalchi Yaaqoob keessaa hin baya; Israa'el keessaa uleen bokkuu mootumma'aa hin ka'a. Sooreyyii worra Mo'aabii hin butucha; buqqii mataa ilmaan Sheetii mara hin caccassa. ");
INSERT INTO gax_vpl VALUES ("NU24_18","005_24_18","NUM","24","18","18","Edoom hin qabatanti; Se'iir ta diina isaa teetelle ta isaa hin teeti; Israa'el ammoo jabaataatuma hin ideenti. ");
INSERT INTO gax_vpl VALUES ("NU24_19","005_24_19","NUM","24","19","19","Sanyii Yaaqoobii keessaa bulchaan tokko hin dhufa; worra qachaa guddicha keessatti hafelle hin balleessa» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU24_20","005_24_20","NUM","24","20","20","Achiin duuba Bala'aam gara worra Amaaleqii ilaalee, ergaa ifii dubbatee, «Gosa biyya adda addaa oddu'utti worri Amaaleqii ka qaraa te'ee ture, muummeen isaanii ammoo badii bara baraa ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU24_21","005_24_21","NUM","24","21","21","Achiin duuba inni gara worra Qenootaa ilaalee, ergaa ifii dubbatee, «Addeen quttuma teessanii addachiittu'u; mandheen teessan rassaa keessatti ijaaranteerti. ");
INSERT INTO gax_vpl VALUES ("NU24_22","005_24_22","NUM","24","22","22","Ammoo yennaa worri Asoorii isin booji'e, isin worri Qenootaa hin baddan» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU24_23","005_24_23","NUM","24","23","23","Ammalle inni ergaa ifii dubbatee, «Aanne'e, yennaa Waaqi tana godhu eentu jiraata ree? ");
INSERT INTO gax_vpl VALUES ("NU24_24","005_24_24","NUM","24","24","24","Qarqara Kitiimiitii ammoo hobolooti gugurdoon hin dhufan; isaan Asoorii fi Ebeer hin qabatan; isaanille ifiifuu haga bara baraa hin badan» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU24_25","005_24_25","NUM","24","25","25","Achiin duuba Bala'aam ka'ee gara mana ifii deebi'e; Balaaqille karaa ifii deeme. ");
INSERT INTO gax_vpl VALUES ("NU25_1","005_25_1","NUM","25","1","1","Israa'elooti Shiixiimitti yennaa qubataneeranu, dhiirti isaanii dubartoota Mo'aabotaa woliin sagaagalane. ");
INSERT INTO gax_vpl VALUES ("NU25_2","005_25_2","NUM","25","2","2","Dubartooti sun worra dhiiraa san gara ciincaa waaqota ifiititti waamane; isaanille ciincaa san nyaatanee, waaqota isaaniitiif sagadane. ");
INSERT INTO gax_vpl VALUES ("NU25_3","005_25_3","NUM","25","3","3","Tanaaf Israa'elooti Ba'aal Phe'or waaqonfatiisa jalqaddee, Mootiin Waan Maraa guddoo isaanitti aare. ");
INSERT INTO gax_vpl VALUES ("NU25_4","005_25_4","NUM","25","4","4","Mootiin Waan Maraa Muuse'een, «Aariin tiyya guddoon Israa'eloota irraa akka deebitu, ati sooreyyii kolbaa tanaa mara fuudhiitii, ila guyya'aatiin fuula kiyya duratti fannisi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU25_5","005_25_5","NUM","25","5","5","Maarre Muuseen abbootii mura'aa ta Israa'elootaatiin, «Tokko tokkoon keessan nama keessan ka Ba'aal Phe'or waaqonfatiisa jalqabe ijjeesa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU25_6","005_25_6","NUM","25","6","6","Achiin duuba Muuse'ee fi wolde'i kolbaa Israa'elii duudiin Dunkaanii Woldeenna'aa dura dhaabbatanee adoo isaan bowanuu, Israa'eloota keessaa tokkochi iluma isaanii duratti, dubartii worra miidiyaanii takka fudhatee gara maatii ifii dhufe. ");
INSERT INTO gax_vpl VALUES ("NU25_7","005_25_7","NUM","25","7","7","Akaakoon Aaronii hayyichaa, ilmi Ele'azaarii Fiinehaas yennaa tana dhagge, ka'ee wolde'a keessaa bayee, eboo fudhatee, ");
INSERT INTO gax_vpl VALUES ("NU25_8","005_25_8","NUM","25","8","8","namicha Israa'elicha gula gara dunkaani'ii seenee, eboo darbatee, namichaa fi dubartittiille woraanee isaan lamaanuu wolitti fullaase. Achiin duuba balaan kolbaa Israa'elii irraa dhaabbate. ");
INSERT INTO gax_vpl VALUES ("NU25_9","005_25_9","NUM","25","9","9","Te'uu malee, balaa saniin namoota kuma diddamii afuritti du'e. ");
INSERT INTO gax_vpl VALUES ("NU25_10","005_25_10","NUM","25","10","10","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU25_11","005_25_11","NUM","25","11","11","«Kolbaa Israa'elii keessaa akaakoon Aaronii hayyichaa, ilmi Ele'azaarii Fiinehaas marroo tiyyaaf waan hinaafeef, ani hinaaffaa tiyyaan akka isaan hin fixanneef, mufii tiyya isaan irraa deebiseera. ");
INSERT INTO gax_vpl VALUES ("NU25_12","005_25_12","NUM","25","12","12","Tanaaf, akka ani Gondooroo tiyya ta nageyaa isa woliin gondooradhu, Fiinehaasitti himi. ");
INSERT INTO gax_vpl VALUES ("NU25_13","005_25_13","NUM","25","13","13","Inni ana Waaqa ifiitiif waan hinaafeef, kolbaa Israa'eliitiifille gumaa cubbu'uu waan kenneef, Gondooroon hayyummaa bara baraa isaaf, isaan duuballe sanyii isaatiif hin teeti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU25_14","005_25_14","NUM","25","14","14","Maqaan namicha Israa'elicha ka dubartittii worra Miidiyaanii woliin ijjeefamee Ziimiirii ilma Saaluwa'aa ti; inni sooressa fira Shimi'oonii ti. ");
INSERT INTO gax_vpl VALUES ("NU25_15","005_25_15","NUM","25","15","15","Maqaan dubartittii worra Miidiyaanii ta ijjeefantee Kozbi; isiin intala Zuurii, ka gosa Miidiyaan keessatti sooressa fira tokkoo ti. ");
INSERT INTO gax_vpl VALUES ("NU25_16","005_25_16","NUM","25","16","16","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU25_17","005_25_17","NUM","25","17","17","«Worra Miidiyaanii kana akka diinaatitti laakkowa'aatii fixa'a; ");
INSERT INTO gax_vpl VALUES ("NU25_18","005_25_18","NUM","25","18","18","wonni tana gootanuuf, isaan Phe'oritti, obboleettii isaanii, ta guyyaa balaan Phe'oritti bu'e ijjeefante, intala sooressa isaanii hujii Kozbiitiin sobanee isin miidhaneeran» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU26_1","005_26_1","NUM","26","1","1","Bala'aan duuba Mootiin Waan Maraa Muuse'ee fi Ele'azaarii ilma Aaronii hayyichaatiin, ");
INSERT INTO gax_vpl VALUES ("NU26_2","005_26_2","NUM","26","2","2","«Wolde'a kolbaa Israa'elii duudii keessaa namoota woggaa diddamaatii fi diddamaa olii, ka dhaqanee loluu dande'anu mara, akka maatii maatii isaaniititti laakkowa'a» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU26_3","005_26_3","NUM","26","3","3","Maarre Muuse'ee fi Ele'azaariin hayyichi fuullee Yeriko'ootitti cinaa laga Yordaanosii dirree Mo'aabii keessatti, kolba'atti dubbatanee, ");
INSERT INTO gax_vpl VALUES ("NU26_4","005_26_4","NUM","26","4","4","«Akkuma Mootiin Waan Maraa Muusee ajajetti, dhiira woggaa diddamaatii fi diddamaa olii laakkowama'a» jedhane. Worri Israa'elootaa ka biyya Gibxi'iitii bayane ka asii gad jiranu: ");
INSERT INTO gax_vpl VALUES ("NU26_5","005_26_5","NUM","26","5","5","Sanyii Ruubenii ilma angaficha Israa'elii keessaa: Henok, abbaa fira Henookotaa; Faluun, abbaa fira Faluuwotaa; ");
INSERT INTO gax_vpl VALUES ("NU26_6","005_26_6","NUM","26","6","6","Hezron, abbaa fira Hezronotaa; Karmi, abbaa fira Karmii'otaa; ");
INSERT INTO gax_vpl VALUES ("NU26_7","005_26_7","NUM","26","7","7","laakkossi dhiira firoota Ruubenii kuma afurtamii sadii fi dhibba torbaa fi soddoma. ");
INSERT INTO gax_vpl VALUES ("NU26_8","005_26_8","NUM","26","8","8","Ilmi Faluu Eliiyaab; ");
INSERT INTO gax_vpl VALUES ("NU26_9","005_26_9","NUM","26","9","9","ilmaan Eliiyaabii: Nemu'el, Daataanii fi Abiiram; Daataanii fi Abiiramiin kun qondaaltota kolba'aa worra Muuse'ee fi Aaroniin mormane. Akkasuma yennaa Qoraahii fi goliin isaa Mootii Waan Maraa irratti finqila kaasane isaan woliin jiraniiyyu. ");
INSERT INTO gax_vpl VALUES ("NU26_10","005_26_10","NUM","26","10","10","Latti banantee Qoraahi woliin isaan liqinsite; goliin Qoraahii yennaa ibiddi bu'ee namoota dhibba lamaa fi shantama fixe san dhumatane. Isaan beessisa ifi eeggachiisaa te'ane. ");
INSERT INTO gax_vpl VALUES ("NU26_11","005_26_11","NUM","26","11","11","Te'uu malee ilmaan Qoraahii hin duune. ");
INSERT INTO gax_vpl VALUES ("NU26_12","005_26_12","NUM","26","12","12","Sanyiin Simi'oonii akka fira fira isaaniititti: Nemu'el, abbaa fira Nemu'elootaa ti; Yaamiin, abbaa fira Yaamiinotaa ti; Yaakiin, abbaa fira Yaakiinotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_13","005_26_13","NUM","26","13","13","Zaara, abbaa fira Zerootaa ti; Shaawul, abbaa fira Shaawulootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_14","005_26_14","NUM","26","14","14","firri Simi'oonotaa kun laakkowamanee, dhiirti kuma diddamii lamaa fi dhibba lama teete. ");
INSERT INTO gax_vpl VALUES ("NU26_15","005_26_15","NUM","26","15","15","Sanyiin Gaadii akka fira fira isaaniititti: Zefoon, abbaa fira Zefoonotaa ti; Haag, abbaa fira Haagotaa ti; Shun, abbaa fira Shunootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_16","005_26_16","NUM","26","16","16","Ozni, abbaa fira Oznootaa ti; Eri, abbaa fira Erootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_17","005_26_17","NUM","26","17","17","Aarod, abbaa fira Aarodootaa ti; Arii'el, abbaa fira Arii'elootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_18","005_26_18","NUM","26","18","18","firri Gaadotaa kun laakkowamanee, dhiirti kuma afurtamaa fi dhibba shan teete. ");
INSERT INTO gax_vpl VALUES ("NU26_19","005_26_19","NUM","26","19","19","Ilmaan Yihuda'aa Erii fi Onaan; isaan ammoo lafa Kana'aanii keessatti du'ane. ");
INSERT INTO gax_vpl VALUES ("NU26_20","005_26_20","NUM","26","20","20","Sanyiin Yihuda'aa akka fira fira isaaniititti: Shela, abbaa fira Shelootaa ti; Faares, abbaa fira Faaresootaa ti; Zaara, abbaa fira Zaarotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_21","005_26_21","NUM","26","21","21","Sanyiin Faaresii: Hezron, abbaa fira Hezronotaa ti; Hamul, abbaa fira Humulootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_22","005_26_22","NUM","26","22","22","firri sanyii Yihuda'aa kun laakkowamanee, dhiirti kuma torbaatamii jaa fi dhibba shan teete. ");
INSERT INTO gax_vpl VALUES ("NU26_23","005_26_23","NUM","26","23","23","Sanyiin Yisaakorii akka fira fira isaaniititti: Tola, abbaa fira Tolootaa ti; Fuwa, abbaa fira Fuwootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_24","005_26_24","NUM","26","24","24","Yaashub, abbaa fira Yaashubootaa ti; Shimroon, abbaa fira Shimroonotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_25","005_26_25","NUM","26","25","25","firri sanyii Yisaakorii kun laakkowamanee, dhiirti kuma jaatamii afurii fi dhibba sad teete. ");
INSERT INTO gax_vpl VALUES ("NU26_26","005_26_26","NUM","26","26","26","Sanyiin Zebuloonii akka fira fira isaaniititti: Sered, abbaa fira Seredootaa ti; Eloon, abbaa fira Eloonotaa ti; Yaahile'el, abbaa fira Yaahile'elootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_27","005_26_27","NUM","26","27","27","firri sanyii Zebuloonii kun laakkowamanee, dhiirti kuma jaatamaa fi dhibba shan teete. ");
INSERT INTO gax_vpl VALUES ("NU26_28","005_26_28","NUM","26","28","28","Sanyiin Yoseefii akka fira fira isaaniititti: Minaase'ee fi Efreem. ");
INSERT INTO gax_vpl VALUES ("NU26_29","005_26_29","NUM","26","29","29","Sanyiin Minaase'ee: Maakiir, abbaa fira Maakiirotaa ti; Maakiir abbaa Giil'aadii ti. Giil'aad, abbaa fira Giil'aadotaa ti. ");
INSERT INTO gax_vpl VALUES ("NU26_30","005_26_30","NUM","26","30","30","Sanyiin Giil'aadii: Yi'ezer, abbaa fira Yi'ezerootaa ti; Helek, abbaa fira Helekootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_31","005_26_31","NUM","26","31","31","Asrii'el, abbaa fira Asrii'elootaa ti; Sheekem, abbaa fira Sheekemootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_32","005_26_32","NUM","26","32","32","Shemiida, abbaa fira Shemiidotaa ti; Hefer, abbaa fira Heferootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_33","005_26_33","NUM","26","33","33","Zelofehaad ilmi Heferii ijoollee durraa malee, ilmaan dhiiraa hin qabuuyyu; maqaan ijoollee durraa Zelofehaad, Maahilaa, No'aa, Hoglaa, Miilka'aa fi Tiirza'a. ");
INSERT INTO gax_vpl VALUES ("NU26_34","005_26_34","NUM","26","34","34","Firri sanyii Minaase'ee kun laakkowamanee, dhiirti kuma shantamii lamaa fi dhibba torba teete. ");
INSERT INTO gax_vpl VALUES ("NU26_35","005_26_35","NUM","26","35","35","Sanyiin Efreemii akka fira fira isaaniititti: Shutela, abbaa fira Shutelootaa ti; Beker, abbaa fira Bekerootaa ti; Tahaan, abbaa fira Tahaanotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_36","005_26_36","NUM","26","36","36","Sanyiin Shutelaa: Eraan, abbaa fira Eraanotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_37","005_26_37","NUM","26","37","37","firri sanyii Efreemii kun laakkowamanee, dhiirti kuma soddomii lamaa fi dhibba shan teete. Isaan kun akka fira fira isaaniititti sanyii Yoseefii ti. ");
INSERT INTO gax_vpl VALUES ("NU26_38","005_26_38","NUM","26","38","38","Sanyiin Beniyaaminii akka fira fira isaaniititti: Belaa'i, abbaa fira Belaa'otaa ti; Ashibel, abbaa fira Ashibelootaa ti; Ashiiraam, abbaa fira Ashiiraamotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_39","005_26_39","NUM","26","39","39","Shefufaam, abbaa fira Shefufaamotaa ti; Hufaam, abbaa fira Hufaamotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_40","005_26_40","NUM","26","40","40","Sanyiin Belaa'i Aardii fi Na'amaan; Aardi, abbaa fira Aardotaa ti; Na'amaan, abbaa fira Na'aamaanotaa ti. ");
INSERT INTO gax_vpl VALUES ("NU26_41","005_26_41","NUM","26","41","41","Firri sanyii Beniyaaminii akka fira fira isaaniititti laakkowamanee, dhiirti kuma afurtamii shanii fi dhibba jaa teete. ");
INSERT INTO gax_vpl VALUES ("NU26_42","005_26_42","NUM","26","42","42","Sanyiin Daanii akka fira fira isaaniititti: Shuhaam, abbaa fira Shuhaamotaa ti; firri sanyii Daanii isaan kana. ");
INSERT INTO gax_vpl VALUES ("NU26_43","005_26_43","NUM","26","43","43","Isaan marti sanyii Shuhaamotaa ti; laakkossi isaanii, dhiirti kuma jaatamii afurii fi dhibba afuri. ");
INSERT INTO gax_vpl VALUES ("NU26_44","005_26_44","NUM","26","44","44","Sanyiin Asheerii akka fira fira isaaniititti: Yiimnaa, abbaa fira Yiimnotaa ti; Yiishiwi abbaa fira Yiishiwootaa ti; Berii'a, abbaa fira Beriyootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_45","005_26_45","NUM","26","45","45","sanyiin Berii'aa: Heber, abbaa fira Heberootaa ti; Malkii'el, abbaa fira Malkii'elootaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_46","005_26_46","NUM","26","46","46","Asheer intala, «Seraa» jedhantu qabaayyu. ");
INSERT INTO gax_vpl VALUES ("NU26_47","005_26_47","NUM","26","47","47","Firri sanyiin Asheerii kun laakkowamanee, dhiirti kuma shantamii sadii fi dhibba afur teete. ");
INSERT INTO gax_vpl VALUES ("NU26_48","005_26_48","NUM","26","48","48","Sanyiin Naftaalemii akka fira fira isaaniititti: Yaahize'el, abbaa fira Yaahize'elootaa ti; Guni, abbaa fira Gunotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_49","005_26_49","NUM","26","49","49","Yezer, abbaa fira Yezerootaa ti; Shiilem, abbaa fira Shiilemootaa ti. ");
INSERT INTO gax_vpl VALUES ("NU26_50","005_26_50","NUM","26","50","50","Isaan kun sanyii fira Naftaalemii ti; laakkossi isaanii, dhiirti kuma afurtamii shanii fi dhibba afuri. ");
INSERT INTO gax_vpl VALUES ("NU26_51","005_26_51","NUM","26","51","51","Dhiirti kolbaa Israa'elii laakkowantee wolumatti kuma dhibba jaa fi kuma tokkoo fi dhibba torbaa fi soddoma teete. ");
INSERT INTO gax_vpl VALUES ("NU26_52","005_26_52","NUM","26","52","52","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU26_53","005_26_53","NUM","26","53","53","«Akka laakkossa maqaa isaaniititti latti isaaniif qoodantuu ti. ");
INSERT INTO gax_vpl VALUES ("NU26_54","005_26_54","NUM","26","54","54","Fira gudda'aaf lafa guddoo, fira diqqa'aaf lafa diqqoo kenniif; firri tokko tokkooyyuu akkuma laakkossa ifiititti lafa fudhatuu ti. ");
INSERT INTO gax_vpl VALUES ("NU26_55","005_26_55","NUM","26","55","55","Latti hixaa buufatiisaan qoodantuu ti; isaan akkuma maqaa gosa abbootii isaanii ta duriititti fudhatanuu ti. ");
INSERT INTO gax_vpl VALUES ("NU26_56","005_26_56","NUM","26","56","56","Qoodi lafaa sun fira gugurda'aa fi fira didiqqaa oddu'utti hixaa buufatiisaan te'uu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU26_57","005_26_57","NUM","26","57","57","Laakkossi Lewwootaa akka fira fira isaaniititti: Gershoon, abbaa fira Gershoonotaa ti; Qehaati, abbaa fira Qehaatotaa ti; Meraari, abbaa fira Meraarotaa ti; ");
INSERT INTO gax_vpl VALUES ("NU26_58","005_26_58","NUM","26","58","58","worri asii gad jirulle firuma Lewwootaa ti: fira Liibnaa'otaa, fira Heronootaa, fira Maahilootaa, fira Mushootaa, fira Qoraahotaa ti; Qehaati abbaa Amraamii ti; ");
INSERT INTO gax_vpl VALUES ("NU26_59","005_26_59","NUM","26","59","59","maqaan niitii Amraamii Yokebeed; isiin intala sanyii Lewwi'ii ta biyya Gibxi'iititti dhalatte; isiin Aaron, Muuse'ee fi obboleettii isaanii Miiriyaam Amraamiif deette. ");
INSERT INTO gax_vpl VALUES ("NU26_60","005_26_60","NUM","26","60","60","Aaron ilmaan afur Naadaab, Abiihuu, Ele'azaarii fi Itaamaar uumate. ");
INSERT INTO gax_vpl VALUES ("NU26_61","005_26_61","NUM","26","61","61","Naadaabii fi Abiihuun ammoo ibidda hin ajajaminiin Mootii Waan Maraa duratti ciincaa yennaa dhikeessane du'ane. ");
INSERT INTO gax_vpl VALUES ("NU26_62","005_26_62","NUM","26","62","62","Dhiirti Lewwootaa ka dhalatanee ji'a tokkootii fi ji'a tokkoo olii kuma diddamii sad; odduu Israa'eloota kaaniititti latti waan isaaniif hin kennaminiif, isaan Israa'eloota kaan woliin hin laakkowanne. ");
INSERT INTO gax_vpl VALUES ("NU26_63","005_26_63","NUM","26","63","63","Isaan kun Muuse'ee fi Ele'azaariin hayyichi fuullee Yeriko'oo cinaa laga Yordaanosiititti dirree Mo'aabii keessatti yennaa Israa'eloota laakkowane worra laakkowame. ");
INSERT INTO gax_vpl VALUES ("NU26_64","005_26_64","NUM","26","64","64","Muuse'ee fi Aaroniin hayyichi lafa goomolee Siina'aa keessatti Israa'eloota yennaa laakkowane isaan kana keessaa nami tokkolle Israa'eloota laakkowamane san keessa hin jiru. ");
INSERT INTO gax_vpl VALUES ("NU26_65","005_26_65","NUM","26","65","65","Mootiin Waan Maraa Israa'elooti sun goomolee keessatti akka dhumatanu waan itti himeeruuf, isaan keessaa Kaalebii ilma Yofuneetii fi Iyaasuu ilma nunii malee, nami tokkolle hin hanne. ");
INSERT INTO gax_vpl VALUES ("NU27_1","005_27_1","NUM","27","1","1","Ijoolleen durraa ta Zelofehaadii: Maahilaa, No'aa, Hoglaa, Miilka'aa fi Tiirza'a. Zelofehaad ka Heferii, Hefer ka Giil'aadii, Giil'aad ka Maakiirii, Maakiir ka Minaase'ee, Minaaseen ka Yoseefii ti. ");
INSERT INTO gax_vpl VALUES ("NU27_2","005_27_2","NUM","27","2","2","Ijoolleen durraa sun gara seensuma Dunkaanii Woldeenna'aa dhaxxee fuula Muuse'ee, fuula Ele'azaarii hayyichaa, fuula sooreyyi'iitii fi fuula wolde'a duudi'ii dura dhaabbattee, ");
INSERT INTO gax_vpl VALUES ("NU27_3","005_27_3","NUM","27","3","3","«Abbaan keenna goomolee keessatti du'e. Inni worra Mootii Waan Maraa mormiisaaf wolitti qabame, golii Qoraahii keessa hin jiru; inni ilmaan adoo hin uumatin cubbuma ifiitiin du'e. ");
INSERT INTO gax_vpl VALUES ("NU27_4","005_27_4","NUM","27","4","4","Ilma waan hin uumatiniif, maqaan abbaa keennaa fira isaa keessaa maaf bada ree? Fira abbaa keennaa oddu'utti lafa nuu kenna'a» jette. ");
INSERT INTO gax_vpl VALUES ("NU27_5","005_27_5","NUM","27","5","5","Maarre Muuseen haajaa isaanii Mootii Waan Maraatitti dhikeesse; ");
INSERT INTO gax_vpl VALUES ("NU27_6","005_27_6","NUM","27","6","6","Mootiin Waan Maraalle, isaan, ");
INSERT INTO gax_vpl VALUES ("NU27_7","005_27_7","NUM","27","7","7","«Wonni ijoolleen durraa ta Zelofehaadii gaafatte sirri'i; odduu fira abbaa isaaniititti lafa isaaniif kenni; dhaalli abbaa isaanii gara isaanii akka dabaru godhi. ");
INSERT INTO gax_vpl VALUES ("NU27_8","005_27_8","NUM","27","8","8","Ati kolbaa Israa'eliitiin, ‹Nami tokko ilma adoo hin uumatin yoo du'e, ijoolleen durraa ta isaa karra isaa akka dhaaltu godha'a. ");
INSERT INTO gax_vpl VALUES ("NU27_9","005_27_9","NUM","27","9","9","Inni yoo ijoollee durraalle hin qabaatin, karra isaa obboleeyyan isaatiif kenna'a. ");
INSERT INTO gax_vpl VALUES ("NU27_10","005_27_10","NUM","27","10","10","Inni yoo obboleeyyan hin qabaatin, obboleeyyan abbaa isaatiif kenna'a. ");
INSERT INTO gax_vpl VALUES ("NU27_11","005_27_11","NUM","27","11","11","Abbaan isaa yoo obboleeyyan hin qabaatin, karra isaa fira aantii isaatiif kenna'a; inni dhaaluu ti; akkuma ani Mootiin Waan Maraa si ajaje, kun kolbaa Israa'eliif qajeelfama seeraa te'uu ti› jedhi» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU27_12","005_27_12","NUM","27","12","12","Achiin duuba Mootiin Waan Maraa Muuse'een, «Gaara Abaariimii kana irratti ol bayiitii, lafa ani kolbaa Israa'eliitiif kenne ilaali. ");
INSERT INTO gax_vpl VALUES ("NU27_13","005_27_13","NUM","27","13","13","Ati isii dhaggiteen duuba, akkuma obboleessi keeti Aaron du'e, atille hin duuta; ");
INSERT INTO gax_vpl VALUES ("NU27_14","005_27_14","NUM","27","14","14","sababille yennaa kolbaan bisaan goomolee Ziinii keessaa biratti na finqilte, isin lamaanuu ila isaanii duratti ana woyyoonsuu diddanee ajaja kiyyaaf ajajamuu diddaneertan. Bisaan kun Bisaan Mariiba'aa ka Qaadesh keessaa ka goomolee Ziinii keessaa ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU27_15","005_27_15","NUM","27","15","15","Muuseen Mootii Waan Maraatiin, ");
INSERT INTO gax_vpl VALUES ("NU27_16","005_27_16","NUM","27","16","16","«Ee Mootiin Waan Maraa, Waaqa jiruu nama maraa, kolbaa tana irratti nama tokko fili! ");
INSERT INTO gax_vpl VALUES ("NU27_17","005_27_17","NUM","27","17","17","Innille kolbaan teeti akka hoolee tissee hin qannee akka hin teene, isaaniin dura ka deemu, ka isaaniin dura gad bayuu fi ka isaaniin dura ol seenu, ka gad isaan baasuu fi ka ol isaan galchu» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU27_18","005_27_18","NUM","27","18","18","Maarre Mootiin Waan Maraa Muuse'een, «Iyaasuu ilma Nunii, nama Ayyaanni keessa jiru fuudhiitii, harka keeti isa irra keyi; ");
INSERT INTO gax_vpl VALUES ("NU27_19","005_27_19","NUM","27","19","19","Ele'azaarii hayyichaa fi wolde'a duudii dura dhaabbachiisiitii, hujii inni itti gaafatamu kana isaan duratti itti kenni. ");
INSERT INTO gax_vpl VALUES ("NU27_20","005_27_20","NUM","27","20","20","Wolde'i Israa'elii duudiin akka isaaf ajajamu, baallii teeti irraa garii isaaf kenni. ");
INSERT INTO gax_vpl VALUES ("NU27_21","005_27_21","NUM","27","21","21","Inni fuula Ele'azaarii hayyichaa, ka karaa Uriimiitiin fedhii tiyya beeku dura dhaabbatuu ti; akkuma ajaja hayyichaatitti, Iyaasu'uu fi wolde'i Israa'elii duudiin bayanee galanuu ti» jedhe. ");
INSERT INTO gax_vpl VALUES ("NU27_22","005_27_22","NUM","27","22","22","Muuseen akkuma Mootiin Waan Maraa isa ajaje godhe. Inni Iyaasuu fuudhee fuula Ele'azaarii hayyichaatii fi fuula wolde'a Israa'elii duudii dura dhaabbachiise. ");
INSERT INTO gax_vpl VALUES ("NU27_23","005_27_23","NUM","27","23","23","Achiin duuba harka ifii isa irra keyee, akkuma Mootiin Waan Maraa isa ajaje hujii inni itti gaafatamu itti kenne. ");
INSERT INTO gax_vpl VALUES ("NU28_1","005_28_1","NUM","28","1","1","Mootiin Waan Maraa Muuse'een, ");
INSERT INTO gax_vpl VALUES ("NU28_2","005_28_2","NUM","28","2","2","«Ati Israa'eloota ajajiitii: Kennansa sagale'ee ka ibiddaan gubamee naaf dhikaatu, ka foolee dansaa qabu ka na gammachiisu, yennaa isaatitti akka naaf dhikeessanu itti himi. ");
INSERT INTO gax_vpl VALUES ("NU28_3","005_28_3","NUM","28","3","3","«Kennansi ibiddaan gubamee guyyuma guyya'aan isin naaf dhikeessitanu kana: buruusoo korbeeyyii hoole'ee ta fafa hin qanne, ta woggaa tokko tokkoo lama kennansa gubamu, ");
INSERT INTO gax_vpl VALUES ("NU28_4","005_28_4","NUM","28","4","4","buruusoo korbeeyyii hoole'ee tokkocha ganama, kaan galgala, ");
INSERT INTO gax_vpl VALUES ("NU28_5","005_28_5","NUM","28","5","5","tokko tokkoo isaanii woliin kennansa midhaanii bullaa dansaa gara kiiloogiraama tokkoo, ta zayitii ejersaa litirii tokkoon sukkuumame dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_6","005_28_6","NUM","28","6","6","Kun kennansa guyyuma guyya'aan gubamu, ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu, seera kennansa ibiddaan gubamee naaf dhikaatu ka gaara Siina'aa irratti jalqabame. ");
INSERT INTO gax_vpl VALUES ("NU28_7","005_28_7","NUM","28","7","7","Buruusa korbeessa hoole'ee ka qaraa woliin daadhii woyni'ii ta macheessitu litirii tokko dhikeessa'a. Daadhii woyni'ii san addee Woyyittii irratti ana Mootii Waan Maraatiif dhibaasa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_8","005_28_8","NUM","28","8","8","Buruusa korbeessa hoole'ee ka lammeesso'oolle akkuma ka ganamaa dhikeessitane san kennansa daadhii woyni'iitii fi kennansa midhaanii woliin galgala dhikeessa'a. Kun kennansa ibiddaan gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu. ");
INSERT INTO gax_vpl VALUES ("NU28_9","005_28_9","NUM","28","9","9","«Guyyaa Sanbataa buruusoo korbeeyyii hoole'ee ta woggaa tokko tokkoo ta fafa hin qanne lama, daadhii woyni'iitii fi kennansa midhaanii bullaa dansaa kiiloogiraama lama ta zayitii ejersaatiin sukkuumante woliin dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_10","005_28_10","NUM","28","10","10","Kun kennansa Sanbata mara gubamu, ka kennansa daadhii woyni'iitii fi kennansa guyyuma guyya'aan gubamu irratti dabalamee dhikaatu. ");
INSERT INTO gax_vpl VALUES ("NU28_11","005_28_11","NUM","28","11","11","«Ji'uma ji'aan guyyaa qaraa kennansa gubamu dardaroota fafa hin qanne lama, korbeessa hoole'ee ka fafa hin qanne tokkoo fi buruusoo korbeeyyii hoole'ee ta woggaa tokkoo ta fafa hin qanne torba ana Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_12","005_28_12","NUM","28","12","12","Akkasuma dardara tokko tokkooyyuu woliin kennansa midhaanii bullaa dansaa kiiloogiraama sad ta zayitii ejersaatiin sukkuumante, korbeessa hoole'ee tokko woliin kennansa midhaanii bullaa dansaa kiiloogiraama lama ta zayitii ejersaatiin sukkuumante, ");
INSERT INTO gax_vpl VALUES ("NU28_13","005_28_13","NUM","28","13","13","buruusoo korbeeyyii hoole'ee tokko tokkooyyuu woliin, kennansa midhaanii bullaa dansaa kiiloogiraama tokko ta zayitii ejersaatiin sukkuumante dhikeessa'a; kun kennansa ibiddaan gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu. ");
INSERT INTO gax_vpl VALUES ("NU28_14","005_28_14","NUM","28","14","14","Dardaroota tokko tokkooyyuu woliin kennansa daadhii woyni'ii litirii lama, korbeessa hoole'ee tokko woliin daadhii woyni'ii litirii tokkoo fi wodhakkaa, buruusoo korbeeyyii hoole'ee woliin daadhii woyni'ii litirii tokko dhikeessa'a; kun baatii ji'uma ji'aatitti, kennansa gubamu ka woggaa guutuu dhikaatu. ");
INSERT INTO gax_vpl VALUES ("NU28_15","005_28_15","NUM","28","15","15","Kennansa gubamu ka guyyuma guyya'aan daadhii woyni'ii woliin dhikaatu woliin araaraa cubbu'uutiif korbeessa re'e'ee tokko ana Mootii Waan Maraatiif dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_16","005_28_16","NUM","28","16","16","«Jilti Irra Dabaramaa ta ana Mootii Waan Maraa, ji'a qaraa guyyaa kudhanii arfeesso'ootitti teetuu ti. ");
INSERT INTO gax_vpl VALUES ("NU28_17","005_28_17","NUM","28","17","17","Ji'a kana guyyaa kudhanii shaneesso'ootitti jila jilifadha'a; guyyaa torba daabboo uukoo hin qanne nyaadha'a. ");
INSERT INTO gax_vpl VALUES ("NU28_18","005_28_18","NUM","28","18","18","Guyyaa qaraa yaa'ii woyyittii godhadha'a malee ijjumaa hujii hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("NU28_19","005_28_19","NUM","28","19","19","Dardara lama ka fafa hin qanne, korbeessa hoole'ee tokko ka fafa hin qanne, buruusoo korbeeyyii hoole'ee ta woggaa tokkoo torba ta fafa hin qanne, kennansa gubamu ana Mootii Waan Maraatiif qopheessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_20","005_28_20","NUM","28","20","20","Dardaroota tokko tokkooyyuu woliin kennansa midhaanii bullaa dansaa kiiloogiraama sad ta zayitii ejersaatiin sukkuumante, korbeessa hoole'ee tokko woliin bullaa dansaa kiiloogiraama lama dhikeessa'a; ");
INSERT INTO gax_vpl VALUES ("NU28_21","005_28_21","NUM","28","21","21","buruusoo korbeeyyii hoole'ee torba tokko tokkooyyuu wolille'een bullaa dansaa kiiloogiraama tokko ta zayitii ejersaatiin sukkuumante dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_22","005_28_22","NUM","28","22","22","Itti dabala'aatii kennansa araaraa cubbuu teessaniitiif, korbeessa re'e'ee tokko gumaa dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_23","005_28_23","NUM","28","23","23","Isaan kana kennansa gubamu ka guyyuma guyya'aan ganama ganama dhikaatu irratti dabala'aatii dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_24","005_28_24","NUM","28","24","24","Akka kanaan, kennansa sagale'ee ka ibiddaan gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu, guyyaa torbaaf guyyuma guyya'aan dhikeessa'a. Kun kennansa daadhii woyni'iitii fi kennansa gubamu ka guyyuma guyya'aan dhikaatu irratti dabalamee dhikaata. ");
INSERT INTO gax_vpl VALUES ("NU28_25","005_28_25","NUM","28","25","25","Guyyaa torbeesso'oo yaa'ii woyyittii godha'a malee ijjumaa hujii hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("NU28_26","005_28_26","NUM","28","26","26","«Guyyaa midhaan matoomaa galfatanu, kennansa midhaan haareyaa ana Mootii Waan Maraatiif yennaa dhikeessitanu, jila teessan ta torbaan torbaatitti, yaa'ii woyyittii godha'a malee ijjumaa hujii hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("NU28_27","005_28_27","NUM","28","27","27","Dardara lama, korbeessa hoole'ee tokko, buruusoo korbeeyyii hoole'ee ta woggaa tokko tokkoo torba, kennansa gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_28","005_28_28","NUM","28","28","28","Dardaroota tokko tokkooyyuu woliin kennansa midhaanii bullaa dansaa kiiloogiraama sad ta zayitii ejersaatiin sukkuumante, korbeessa hoole'ee woliin bullaa dansaa kiiloogiraama lama, ");
INSERT INTO gax_vpl VALUES ("NU28_29","005_28_29","NUM","28","29","29","buruusoo korbeeyyii hoole'ee torba tokko tokkooyyuu woliin bullaa dansaa kiiloogiraama tokko ta zayitii ejersaatiin sukkuumante dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_30","005_28_30","NUM","28","30","30","Itti dabala'aatii gumaa cubbuu teessaniitiif, korbeessa re'e'ee tokko dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU28_31","005_28_31","NUM","28","31","31","Kun kennansa daadhii woyni'ii woliin kennansa gubamu ka guyyuma guyya'aan dhikaatuu fi kennansa midhaanii ka isaanii irratti dabalamee dhikaatuu ti. Horiin dhikeeffame kun ka fafa hin qanne akka te'e hubadha'a. ");
INSERT INTO gax_vpl VALUES ("NU29_1","005_29_1","NUM","29","1","1","«Ji'a torbeesso'oo guyyaa qaraa yaa'ii woyyittii godhadha'a malee ijjumaa hujii hin hujina'a. Guyyaan sun guyyaa isin tultullaa afuuttanu. ");
INSERT INTO gax_vpl VALUES ("NU29_2","005_29_2","NUM","29","2","2","Dardara tokko ka fafa hin qanne, korbeessa hoole'ee tokko ka fafa hin qannee fi buruusoo korbeeyyii hoole'ee ta woggaa tokko tokkoo torba ta fafa hin qanne, kennansa gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU29_3","005_29_3","NUM","29","3","3","Dardara san woliin kennansa midhaanii bullaan dansaan kiiloogiraama sad ta zayitii ejersaatiin sukkuumante, korbeessa hoole'ee san woliin bullaa dansaa ta zayitii ejersaatiin sukkuumante kiiloogiraama lama, ");
INSERT INTO gax_vpl VALUES ("NU29_4","005_29_4","NUM","29","4","4","buruusoo korbeeyyii hoole'ee torba san tokko tokkooyyuu woliin bullaa dansaa ta zayitii ejersaatiin sukkuumante kiiloogiraama tokko qopheessa'a. ");
INSERT INTO gax_vpl VALUES ("NU29_5","005_29_5","NUM","29","5","5","Itti dabala'aatii kennansa araaraa cubbuu teessaniitiif, korbeessa re'e'ee tokko gumaa qopheessa'a. ");
INSERT INTO gax_vpl VALUES ("NU29_6","005_29_6","NUM","29","6","6","Kun kennansa midhaaniitii fi kennansa daadhii woyni'ii ka isaan woliin dhikaatu woliin akkuma seera tumameetitti kennansa gubamu ka guyyuma guyya'aa fi ji'uma ji'aan dhikaatutti dabalamanee, kennansa ibiddaan gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu. ");
INSERT INTO gax_vpl VALUES ("NU29_7","005_29_7","NUM","29","7","7","«Ji'a torbeesso'oo kana keessa guyyaa kudhaneesso'oo yaa'ii woyyittii godhadha'a. Guyyaa san ifi gad qaba'a; ijjumaa hujiille hin hujina'a. ");
INSERT INTO gax_vpl VALUES ("NU29_8","005_29_8","NUM","29","8","8","Dardara tokko ka fafa hin qanne, korbeessa hoole'ee tokko ka fafa hin qanne, buruusoo korbeeyyii hoole'ee ta woggaa tokko tokkoo torba ta fafa hin qanne, kennansa gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU29_9","005_29_9","NUM","29","9","9","Dardara san woliin kennansa midhaanii, bullaan dansaan kiiloogiraama sad ta zayitii ejersaatiin sukkuumante, korbeessa hoole'ee woliin bullaa dansaa ta zayitii ejersaatiin sukkuumante kiiloogiraama lama, ");
INSERT INTO gax_vpl VALUES ("NU29_10","005_29_10","NUM","29","10","10","buruusoo korbeeyyii hoole'ee torba tokko tokkooyyuu woliin bullaa dansaa ta zayitiin ejersaatiin sukkuumante kiiloogiraama tokko dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU29_11","005_29_11","NUM","29","11","11","Gumaa kennansa araaraa cubbu'uutiif kennansa guyyuma guyya'aan gubamu kennansa midhaanii ka isaatii fi kennansa daadhii woyni'ii ka isaaniititti dabala'aatii kennansa araaraa cubbu'uutiif korbeessa re'e'ee tokko dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU29_12","005_29_12","NUM","29","12","12","«Ji'a torbeesso'oo keessa guyyaa kudhanii shaneesso'oo yaa'ii woyyittii godhadha'a malee guyyaa san ijjumaa hujii hin hujina'a; jila guyyaa torbaa ana Mootii Waan Maraatiif jilifadha'a. ");
INSERT INTO gax_vpl VALUES ("NU29_13","005_29_13","NUM","29","13","13","Dardaroota kudhanii sad ka fafa hin qanne, korbeeyyii hoole'ee lama ta fafa hin qanne, buruusoo korbeeyyii hoole'ee ta woggaa tokko tokkoo kudhanii afur ta fafa hin qanne kennansa gubamu ka foolee dansaa qabu ka ana Mootii Waan Maraa gammachiisu dhikeessa'a. ");
INSERT INTO gax_vpl VALUES ("NU29_14","005_29_14","NUM","29","14","14","Dardaroota kudhanii sad tokko tokkooyyuu woliin kennansa midhaanii bullaa dansaa kiiloogiraama sad ta zayitii ejersaatiin sukkuumante, korbeeyyii hoole'ee lama tokko tokkooyyuu woliin bullaa dansaa ta zayitii ejersaatiin sukkuumante kiiloogiraama lama, ");
INSERT INTO gax_vpl VALUES ("NU29_15","005_29_15","NUM","29","15","15","buruusoo korbeeyyii hoole'ee kudhanii afur tokko tokkooyyuu woliin bullaa dansaa ta zayitii ejersaatiin sukkuumante kiiloogiraa