﻿USE sofia;
DROP TABLE IF EXISTS sofia.gaw_vpl;
CREATE TABLE gaw_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gaw_vpl WRITE;
INSERT INTO gaw_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","Imu amu Jesus Kristus memetap̱ud buḏulḵad dilag nai. Jesus Nug am Dawit buḏub, Dawit nug Abraham buḏub. ");
INSERT INTO gaw_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","Abraham beḵa Isak. Isak beḵa Jakop. Aria Jakop beḵod Juda awaḵud amaḵud ele. ");
INSERT INTO gaw_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","Juda bekoḏ Peres Sira ele. A anilah amu Tema. Aria Peres beḵa Hesron. Hesron beḵa Aram. ");
INSERT INTO gaw_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","Aram beḵa Aminadap. Aminadap beḵa Nason. Nason beḵa Salmon. ");
INSERT INTO gaw_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","Salmon wau Rahab ele beḵalah Boas. Aria Boas wau Rut ele beḵalah Obet. Obet beḵa Jesi. ");
INSERT INTO gaw_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","Jesi beḵa king Dawit. Amu Dawit wau Batsiba ele beḵalah Solomon. Batsiba nug tatam Uria wau dayom. ");
INSERT INTO gaw_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","Solomon beḵa Riaboam. Riaboam beḵa Abaisa. Abaisa beḵa Esa. ");
INSERT INTO gaw_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","Esa beḵa Jehosapat. Jehosapat beḵa Joram. Aria Joram beḵa Asaia. ");
INSERT INTO gaw_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","Asaia beḵa Jotam. Jotam beḵa Ahas. Ahas beḵa Hesekaia. ");
INSERT INTO gaw_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","Hesekaia beḵa Manase. Manase beḵa Emos. Emos beḵa Josaia. ");
INSERT INTO gaw_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","Josaia beḵod Jekonaia amaḵud ele. Ahilag haenp̱a ahilag tap̱e naknu Israel ag Babilon mani guiṯak oop̱a nona daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","Babilon mani guiṯak oop̱a nona daanna, Jekonaia nug Sailtiel menuom. Sailtiel beḵa Serababel. ");
INSERT INTO gaw_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","Serababel beḵa Abiud. Abiud beḵa Elaiakim. Elaiakim beḵa Esau. ");
INSERT INTO gaw_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","Esau beḵa Sedok. Sedok beḵa Ekim. Ekim beḵa Elaiat. ");
INSERT INTO gaw_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","Elaiat beḵa Eliese. Eliese beḵa Matan. Matan beḵa Jakop. ");
INSERT INTO gaw_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","Jakop beḵa Josep. Josep amu nug Maria gamu. Maria nug Jesus menuom. Jesus Nug am Kristus, Kayak Nug tituanom. ");
INSERT INTO gaw_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","Nai anam aaḵu amunu Abraham buḏub uḏiak Dawit batak amu alag eb qak 14. Aria Dawit uḏiak Babilon mani guiṯak oop̱a nona daap̱ig batak amu ele alag eb qak 14. Aria Babilon mani guiṯak oop̱a nona daap̱ig uḏiak Kristus doum batak amu ele alag eb qak 14. ");
INSERT INTO gaw_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","Anam amunu Jesus Kristus nuhig menuaknu nai am inam. Josep nug Maria aoḵunu baeg aḏaeg daye uḵe, layam daapiḏ amge a nug ii aopiḏp̱a Maria nug Kayak Ouḏip̱a oo ele daye anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","Anṯegeg amu Maria gamu nug am danab tutuḵu, oo doyak ele amunu nug Maria uḏa nak meṯak uua, nug loḵumakp̱a Maria uuḵunu dab meum. ");
INSERT INTO gaw_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","Josep nug amunu dab mak awewe amu tuqan tulp̱a Naḏinu engel nug gumiṯa neum. Na amu nug aum. “Josep, Dawit beḵa, na ah nahip Maria amu aoḵutnu aib baḏame. Doye! Kayak Ouḏi Nug nuḵa nid amu meṯom. ");
INSERT INTO gaw_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","Nug geha nid danab aoḵu amu na Nug onig Jesus ataḏḵut. Aḏinu? Nug geha nuhiḵud danab ah oh amu, ag ahilag hip̱unin waap̱a daamnanu Nug ag eḏua diiḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","Keeke amu oh am propet laa Kayak oḏe awa, nai maṯiom, nai amu elele medaḵunu beum. Propet nug inam aum. ");
INSERT INTO gaw_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","“Doyeg! Ah laa nug danab laa ele ii niipiḏ amge nug oo ele daya, nid danab menueb, ag Nug onig Imanuel aḵulag.” Onig amu diig am Kayak ig ele daaṯem. ");
INSERT INTO gaw_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","Aria Josep nug niiom aha, Naḏinu Engel aum amubia ha, ah nuhig awom. ");
INSERT INTO gaw_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","Awe nug ele nakok laa ii niipiḏ, uḵe uḵe nid danab awom. Awe amu Josep nug nid onig Jesus ataḏom. ");
INSERT INTO gaw_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","Maria nug Juda wanp̱a Betlehem ap̱a dayaya, Jesus menuom. Haen amu Herodes oḵai nug king dayeye, nug menue amu hoḏop̱ai magau danab ag aam bedep̱anu ahan uḏin, Jerusalem bena ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“Nid nakok laa doum, Nug Juda dilag king amu, Nug adep̱a daaṯe? Ig nuhig hoḏop̱ai aam bedep̱a anidta, Nug binag meḵunignu uḏimut,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","Aon aeg amu king Herodes oḵai nug nai amu doya oṯaie, Jerusalem danab ah oh ele oṯaip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","Oṯaieg amu Herodes oḵai nug Israel dilag ḏo mehuqak danab amu mana meṯak danab oḵai ele, amu oh qag maaṯa, ag oḏ maṯa aum. “Kristus Nug ab aṯenp̱a beḵu?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","6","Awa a amu ag ap̱ig. “Kayaknu propet nug amunu nai inam yom. ‘O Betlehem, na Juda wanp̱a ab laala bia iiṯa. Na am onin ele, nahipp̱a geha danab oḵai beḵu amu Nug Israel danab ah dahilad gumadḵu.’ Nug anam yom amunu ig dooṯem, Nug Betlehem, Juda wanp̱a beḵu,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","Ag anam aeg amu Herodes oḵai nug nai amu doya, nug loḵumakp̱a aam bedep̱anu danab, hoḏop̱ai magau, ag oḏelagp̱a hoḏop̱ai amu haen ganebnab ba dayom am nug ag oḏ maṯa doyom. ");
INSERT INTO gaw_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","Doya amu nug he, ag Betlehem goḵulagnu heegeg, nug ag amelagp̱a aum. “Ag gona, nid nakok amu peheṯan maṯin anidna amu uḏin ap̱eg, da ele uḵen, Nug binag meḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","Awa a amu ag Herodes oḵainu nai doyona, ahan gonana amu ag hoḏop̱ai, aam bedep̱a anidp̱ig ele amu, nug anuqa uḵa, lag nid nakok niiom, lag amup̱a bop̱ala dayeye anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","Ag hoḏop̱ai anidna, ag oolag huana gamag ahe, ");
INSERT INTO gaw_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ag lag oop̱a nona, nid nakok Nug anig Maria ele anatp̱ig. Anatna amu ag dup nona, gatelag qaun ona, nid nakok binag mep̱ig. Mewona amu ahilag baṯam hip̱ana, gol amu goḏen aḏit onilah prankensens mir ele, muṯuḏig ahilah piḏe piḏe, amu ele medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","Meṯona ag niiegeg amu tuqan tulp̱a Kayak ag eḏun Herodes oḵai top̱a ii gomananu aum amunu ag eḏun, ib laa aon, ag ap̱alagp̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","Ag uḵaeg dimp̱a Naḏinu engel tulp̱a Josep amegp̱a aum. “Na ahan, nid nakok anig ele diiatna, oolna Igipta wanp̱a gona, ap̱a daap̱e, da na eḏun uḏiḵutnu ap̱i doona amu uḏiḵut. Aḏinu? Herodes oḵai nug nid nakok maṯia anṯa qeḵunu heṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","Awa a amu Josep nug tuqan amup̱a aha, nid nakok anig ele diiate, Igipta gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","Gona Igipta ap̱a daaegeg, Herodes oḵai mauhom. Keeke amuam propet laa nug Kayak oḏe awa, nai maṯiom, nai amu elele medaḵunu beum. Propet nug inam aum. “Nid dahil Nug Igipta dayeye, da Nug onigp̱a ei uḏiom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","Anam aaḵu amge Herodes oḵai nug ii mauhom haenp̱a, magau danab ag eḏun gop̱ig, haen amup̱a nug ag bup̱uidp̱ig doyom amunu nug op̱oḏi huanak be, nuhiḵud daup he gona, Betlehemnu nid naunau amu Betlehem taliliṯak ab naunaup̱anu oh ele, ahilag maḏ aḏit amu laa ag maḏ aḏit ii awom ele, magau danab hoḏop̱ai dig mena anidp̱ig bia doyom, amu oh human aqap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","Aqap̱ig amunu propet Jeremaia nai laa maṯiom amu, nuhig nai amu elele meṯom. Nug inam aum. ");
INSERT INTO gaw_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“Ag baag laa Rama abp̱a doop̱ig. Qanak baag naḏi, ewak baag oo doyak ele doop̱ig. Rahel nug nid nuhiḵudnu gayom amu danab oh ag nug hep̱eg oo meḵunu iiṯanab. Aḏinu? Nid nuhiḵud oh mauhadp̱ig.” ");
INSERT INTO gaw_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","Aria Josep aḏi ag Igipta gona daaegeg, Herodes oḵai nug he, Betlehem dilag nid naunau oh mauhp̱ig, haen amu dimp̱a Herodes oḵai nug mauhe, Kayaknu engel tulp̱a Josep gumiṯa doum. ");
INSERT INTO gaw_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","Nug doa Josep amegp̱a aum. “Danab ag nid nakok qeḵulagnu hep̱ig ele aaḵu mauhp̱ig amunu na ahan, na waat nid nakok ele diiatna, eḏun Israel uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","Anam a amu Josep nug aha, nid nakok anig ele diiate, eḏun Israel gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","Gop̱ig amge Josep nug Herodes oḵai beḵa Akelias, nug mameg abenab awa, Juda dilag king dayeye doya, nug ap̱a uḵaknu oo baḏom. Oo baḏeḏe amu tuqan tulp̱a Kayak Nug Josep Juda wanp̱a gomanu, “Aib,” aum amunu nug aha, Galelia uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","Nug uḵa, ab laa Nasaret ap̱a ta dayom. Amup̱a propet laa nug nai yom amu elele meṯom. Nai amu inam. “Ag nuhignu, Nug am Nasaret danab,” aḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","Haen amup̱a Layaṯak Johanes nug aha, Juda wanp̱a atu taḏakp̱a uḵa, nug danab oh amelagp̱a nai mehuqom. ");
INSERT INTO gaw_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","Nug nai mehuqaqa inam aum. “Kayaknu ḏo maḏoḏnu haen miag daaṯe amunu ag oolag eḏuaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","Anuḵa propet laa onig Jesaia nug Johanesnu inam maṯia aum. “Danab laa atu taḏakp̱a dayaya, danab amelagp̱a nai inam mehuqa ewa aḵu, ‘Ag hip̱unin ahilag di meṯana, ag oolagp̱a Naḏinu ib babaiṯeg!’” awa yom. ");
INSERT INTO gaw_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","Johanes nug lamen kamel uḏigp̱a hak amu ma, nug imuagp̱a maṯagiḏ doḏ gaḏap̱a hak amu ele tagṯom. Nuhig e amu atup̱anu up̱uh lep̱u, tap ele. ");
INSERT INTO gaw_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","Amunu haen amup̱a Jerusalem danab, Juda danab oh amu ab laala, Jodan le guguiṯak daap̱ig ele amu, ap̱an danab oh ele ag Johanes gumidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","Gona, hip̱unin ahilag miag aegeg, Johanes nug Jodan lep̱a layaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","Layaṯeṯe amu ḏo gumak danab-Parasia amu ḏo gumak danab-Sadusi ele ag layaṯak aoglagnu kuḏum uḵaeg, Johanes nug ag anaṯa, nug ag amelagp̱a inam aum. “Ag am danab nau, mat bia. Aun aum amunu ag hip̱uninnu bu aqak, Kayak ep̱egp̱anu uḏiṯe amu, ag amu ii aomnanu hamu uḏip̱ig. Ag oolag ii eḏueb ag aoglag ");
INSERT INTO gaw_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","amge ag oolag eḏueb, kobol ena dim lamidna, ag ahilag eheḏ haknu nob amu ii aomna. ");
INSERT INTO gaw_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","Am laa ele amu ag oolagp̱a dab mak imu aib aop̱ig. ‘Abraham nug am ig mamenig, nug am danab tutuḵu, ig nug buḏub daaṯem amunu nuhig hak enap̱a ig eheḏ ii aomta.’ Da ag amelagp̱a genab aṯem, Kayak Nug men imu ag eḏun, Abraham beḵod daaglagnu heḵunu elele. ");
INSERT INTO gaw_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","Amunu ag anṯeg! Epeḏiak haen am miag. Ad meu ii oṯe amu nug mameg o qiie, ab aḏup̱a maoe te eoṯe, amubia danab nug ena ii heṯe ele amu, nuhigp̱a anamib beḵu. ");
INSERT INTO gaw_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","Ag oolag eḏuomnu ep̱onak keeke amuam da ag lep̱a layadṯem amge danab Nug da dimulp̱a uḏiṯe amu nuhig g̱agaṯag amu dahil eḏidṯe, Nug am danab oḵainab, da am oḵai iiṯa, Nug Kayak Ouḏi amu ab aḏu elep̱a ag layadḵu. ");
INSERT INTO gaw_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","Nug wit aeg amu wit gaḏa piḏe piḏe daaḵunu uḏat amu haknu keeke babaiṯom daaṯe. Nug uḏat amu ha, elelenab mewowa, Nug wit meu amu e mak laḵa meḵu. Mewowa, Nug wit gaḏa amu ab aḏu ii qauhṯe elep̱a maneb eoḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","Johanes nug uḏat anam heehe, haen amup̱a Jesus Nug Galelia uua, Nug Johanes ep̱egp̱a layaṯak aoḵunu Jodan lep̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","amge Johanes nug Jesus am oḵai, nug nuḵa am oḵai iiṯa doyom amunu nug Jesus amegp̱a aum. “Na da laaiḏḵutnu elele, ge aṯem he, na dahilp̱a uḏime?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","A am Jesus oḏep̱a awa aum. “Iiṯa, gemu amu na da ami bia heḵut. I amup̱a kobol tutuḵu oh elele meṯagnih,” awa aum. Awa a amu Johanes nug Jesus oḏe dim lamiṯom. ");
INSERT INTO gaw_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","Jesus layaṯak awa mala, audam teete amu hab obata meṯe, Kayak Ouḏi Nug ai up̱uḏil bia nuhigp̱a daaḵunu neene anṯom. ");
INSERT INTO gaw_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","Ne amu baag laa hab aṯannu ewa aum. “Imu am da Beḵalnab, da nuhignu ool mauhṯe. Nuhig haknu ele amu da ool ena daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","Haen amup̱a Kayak Ouḏi Nug Jesus omala, atu taḏakp̱a, amup̱a Satan nug Jesus eheḏ heḵunu oo eeḏḵunu amu ap̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","Amu Jesus Nug deḏ 40, tuqan amun ele, e ii la, Nug enug qeum. ");
INSERT INTO gaw_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","Enug qeeqe amu eheḏ haknu oo eeḏak danab nuhigp̱a beum. Ba amu nug aum. “Na Kayak beḵa daaṯem dayeb amu na ap̱e, men imu bret baḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","Nug anam aum amge Jesus Nug inam aum. “Kayak naip̱a yak inam daaṯe. ‘Danab ah ep̱aib bau daanna ii oiṯeb. Iiṯa, danab ah ag Kayak nai ohp̱a bau daan oiṯeb,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","Nug anam a amu Satan nug Jesus omala, Jerusalem uḵa, mana meṯak lag aṯan te dayeye amegp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“Na Kayak beḵa daaṯem dayeb amu na oolna no! Aḏinu? Kayak naip̱a yak inam daaṯe. ‘Na baen men yaamanu, Nug engel nuhiḵud amelagp̱a nahipnu ab, ag na ep̱elagp̱a mawidḵulag,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","Anam a amu Jesus Nug aum. “Kayak naip̱a, nai laa ele inam daaṯe. ‘Na Naḏi, nahip Kayak, Nug keeke laa heḵunu aum am genab heḵutai o iiṯatai dooḵutnu amu na Nug aib eeḏme,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","Anam a amu Satan baula Jesus awa uḵa, qauko oḵainab igip̱a meum. Mewowa nug wan oh, ahilag gumak aben aben ele amu ahilḵad keeke ena oh ele ip̱uniṯaṯa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“Na da noolp̱a dup nona, gaten qaun ona, da binal mep̱e amu da keeke imu oh medaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","Awa a amu Jesus Nug Satan amegp̱a aum. “Satan na qe me! Kayak naip̱a yak inam daaṯe, ‘Na Naḏiib binag me! Nug am nahip Kayak amunu na nuhig uḏat aaḵuib heḵut,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","Jesus Nug anam a amu Satan Jesus uuiṯom. Uuiṯe amu engel laala ag nena, Jesus ehanidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","Jesus Nug Johanes mani guiṯakp̱a mep̱ig doya, Nug aha, Galelia uḵa, Nasaret eḏiṯa ab onig Kapenaum ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","Kapenaum amu le ameg Galelia hip̱egp̱a, laih Seblon Naptali buḏulti daadp̱igp̱a daaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","Jesus ap̱a oiyeye, Nug propet Jesaia Kayak oḏe awa, nai maṯiom, nai amu elele meṯom. ");
INSERT INTO gaw_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","Propet Jesaia nug inam aum. “Wan onig Seblon am wan laa onig Naptali ele, ib laa yup̱a uḵak amu a op̱atata goṯe. A Jodan le mataḏa uḵak laihp̱a daaṯep. A am Galelia wan, a oolahp̱a danab laihnu uḏiak kuḏum daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","Danab ah ap̱a daaṯeb ele amu, ag gatatu oop̱a daanna amu ag amahlak naḏi anidp̱ig! Danab ah gatatup̱anab daap̱ig amu amahlak ahilagp̱a ba malom!” ");
INSERT INTO gaw_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","Haen amup̱a Jesus Nug Galelia ap̱a dig ma nai mehuqom. Nug nai mehuqa aum. “Kayaknu ḏo maḏoḏnu haen miag daaṯe amunu ag oolag eḏuaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","Jesus Nug anam nai mehuqaqa, Galelia le ameg ihip̱a oiyaya, Nug Simon, onig laa Petrus, Andreus ele, a am eamag, amu a ahilah uhui eeheh anatom. A am kakai awak danab amunu a uhui epiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","Anata amu Nug aum. “A doya, da dim lamiḏeḏ! A anam hepeḏ amu da a danab diiaknu uḏat ip̱uanatḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","Nug anam a amu a pahanab uhui uuya, Nug dim lamidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","Dim lamiṯeheh amu Jesus Nug nakok laa ele le ihi maṯa wana amu Sebedi bekoḏ Jakobus, Johanes ele anatom. Jakobus Johanes ele a ele am eamag. A amu a mamelah Sebedi ele ag ub aṯan uhui bap̱aidnana daap̱ig. Daaegeg Jesus Nug a onilahp̱a e, ");
INSERT INTO gaw_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","a pahanab ub uuya, mamelah ele uuidya, Jesus dim lamidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","Jesus Nug danab amu onilagp̱a ewowa, Nug Galelia wan ohp̱a oiyaya, Juda dilag nai doyak lag laalap̱a ip̱uanaṯak uḏat heum. Nug Nai Ena, Kayaknu ḏo maḏoḏnu mehuqaqa, oḏe danab bap̱alaṯaṯa, keeke nau kuḏum danab ah beḏulag he nauhom amu ele bap̱alaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","Bap̱alaṯeṯe ag Jesusnu Siria wan ohp̱a maṯieg, danab ah oḏe diigdiig ele diin uḏip̱ig. Laala ag beḏulagp̱a guiṯak doop̱ig amu aria laala ag beḏu mauhak ele amu laala ag ebehilag mauhak ele amu oh bap̱alaṯom. Aria laala ag ouḏi nau beḏulag tagiṯak ele amu Nug ouḏi nau amu lamaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","Jesus Nug anam heehe, danab ameg kuḏum Galelianu, Dekapolisnu, Jerusalemnu, Judanu amu Jodan le laihp̱anu ele oh Nug dim lamidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","Danab ah kuḏum Jesus dim lamiṯegeg, Nug danab ah ameg naḏi anaṯa amu Nug qaukop̱a ta dayeye, nuhig ip̱uniṯak awak danab Nug gumidna uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","Uḏieg Jesus nai maṯa aum. ");
INSERT INTO gaw_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“Danab aun aḏi ag oolagp̱a, ag am elele iiṯa dooṯeb ele amu, ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Ag Kayaknu ḏo maḏoḏ oop̱a daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","Danab aun aḏi ag oolagp̱a hip̱uninnu guiṯak dooṯeb ele amu, ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Ag oo mak aoglag. ");
INSERT INTO gaw_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","Danab aun aḏi ag wagai mak kobol ii heṯeb ele amu, ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Ag wan imu oh aoglag. ");
INSERT INTO gaw_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","Danab aun aḏi ag Kayak noobp̱a tutuḵu daaglagnu oolagp̱a enug qak bia dooṯeb ele amu, ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Ag amu am bak aoglag. ");
INSERT INTO gaw_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","Danab aun aḏi ag danab laa dilagnu oo gai iiṯa dooṯeb ele amu, ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Dimp̱a ag eheḏp̱a daaglag amu laa ahilagnu oo gai iiṯa dooḵu. ");
INSERT INTO gaw_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","Danab aun aḏi ag oolagp̱a op̱ia awak ele amu, ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Ag Kayak anidḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","Danab aun aḏi ag maḏoḏ iḵi daaṯeb ele amu, ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Kayak Nug ahilagnu, “Ag am da beḵalḵad,” awa aḵu. ");
INSERT INTO gaw_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","Danab aun aḏi ag kobol ena heṯeb amge danab laala ag amunu oo aeg bak doonna, ug madaṯeb ele amu, danab ag ena heṯeb ele amu ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Ag Kayaknu ḏo maḏoḏ oop̱a daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","Ag da dim lamiḏṯeb amunu haen danab laala ag ahilagnu nai nau anana, ag lamadnana, nai ham bup̱uak kuḏump̱a ag yaaladna heṯeb ele amu, ag dahilad amu ag itiṯak ena aop̱ig daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","Danab kobol nau amu heṯeb ele amu, anuḵa ag alalḵad ag Kayaknu propet beḏulagp̱a ele anam hep̱ig amunu ag ahilagnu ele anam hep̱eg amu aria ag gamalag ahebeb, ag oolag enaib dayaḏ! Aḏinu? Nob ahilag hab aṯan am oḵainab. ");
INSERT INTO gaw_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","Ag amu wanp̱an yu kalu bia daaṯeb amge yu kalu nug yu ubuhi iiṯa dayeb amu aṯem hep̱ut, nug eḏua ubuhi ele daaḵu? Yu kalu anam amu nug uḏat iiṯa. Danab ag goḵaḏeg uḵe, tap̱an goṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","Ag amu wanp̱anu amahlak. Ab laa nug qaukop̱a daaṯe amu nug loḵumak ii daaṯe. Amahlak nuhig amu honaḏa, danab oh dilagp̱a goṯe. ");
INSERT INTO gaw_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","Danab ag ele amahlak amotna, tap̱iḏp̱a ii tonaṯeb. Iiṯa. Ag balal aṯan meeg, amahlak nuhig danab laḵa daaṯeb amu oh amahlak madaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","Amubia ag dahilad daaṯeb ele amu, laala ag ahilag kobol ena anidna, ag ag Mamelag, hab aṯan daaṯe amu, Nug binag meḵulagnu, ag ahilag amahlak amu danab amelagp̱a amahalaḏ! ");
INSERT INTO gaw_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","Ag oolagp̱a da ḏo nai amu propet dilag nai ele hep̱i iiṯa meḵunu uḏimi aon aib ap̱ig. Da hep̱i, iiṯa meḵunu ii uḏimi. Iiṯa. Da elelenab medaḵulnu uḏimi. ");
INSERT INTO gaw_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","Da genab ag amelagp̱a aṯem. Nai amu keeke oh beḵunu aṯe amu keeke amu beebeb, hab wan ele dayebeb, nai amup̱a yak nakoknab laa am iinab qeṯoḏma. ");
INSERT INTO gaw_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","Amunu danab laip̱u laa nug ḏo nai laa heeb, iiṯa meḵunu haaha, nug amu danab laa ele amu ip̱uanadḵu amu nug onig Kayaknu ḏo maḏoḏp̱a amu nakoknab daaḵu amge danab ḏo dim lamiṯaṯa, danab laa dim lamidḵulagnu ele ip̱uanadḵu amu nug Kayaknu ḏo maḏoḏp̱a onig oḵai ele daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","Da tutuḵu ag amelagp̱a aṯem. Ahilag hak tutuḵu ḏo mehuqak danab amu ḏo gumak danab-Parasia ele ii eḏadḵu amu ag Kayaknu ḏo maḏoḏp̱a noḵulagnu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","Anuḵa ag alalḵad ag nai aop̱ig amu ag dooṯeb. Nai amuam inam. ‘Na danab aib qep̱e mauhom,’ amu, ‘Danab laa nug danab laa qeeb mauhḵu amu nug heṯoḏiakp̱a daaḵu.’ ");
INSERT INTO gaw_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","Amge da ag amelagp̱a aṯem. Danab laa nug layagnu op̱oḏi beeb amu nug heṯoḏiakp̱a daaḵu. Danab laa nug layag amegp̱a, ‘Na am genabnab danab nau,’ aḵu amu nug heṯoḏiak oḵai, onig Sanhidren, ap̱a daaḵu. Amge laa nug layag onig he nauhṯe amu nug mua laa oh eḏaṯak, aben eheḏp̱a goḵunu heṯe. ");
INSERT INTO gaw_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","Amunu na nahip mana meṯaknu keeke aon, qaḏabp̱a gona, na layap nug nahipnu nai ele daaṯe dab meḵut dayeb ");
INSERT INTO gaw_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","amu na nahip mana meṯak qaḏab guguiṯak mep̱e dayebeb, tatam gop̱e, layap ele oolah babaiṯeḏ! Babaiṯoya, aria na eḏun gona, nahip mana meṯaknu keeke main, Kayak meṯe! ");
INSERT INTO gaw_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","Aria haen danab laa nug nahip eheḏ haknu heṯoḏiakp̱a meidḵunu heebeb amu na hep̱e, a oolah paha babaiṯeḏ! A ibp̱a goyaya amu na anam he! Iiṯa amu nug na epeḏiak danab noobp̱a meidḵutai. Meiṯeb, epeḏiak iḵi nug heṯoḏiaknu daup laa ep̱egp̱a meiṯeb, daup amu nug na mani guiṯakp̱a meidḵu. ");
INSERT INTO gaw_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","Meiṯeb amu da genab ag amelagp̱a aṯem. Na mani guiṯakp̱a daanna, nahip eheḏ hak nob ohnab eḏun medap̱e, ag od matulp̱eg, dimiṯim doḵut. ");
INSERT INTO gaw_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","Aria ag anuḵa ag nai laa aop̱ig amu ag dooṯeb. Nai amuam inam. ‘Na gap̱ai kobol aib heme,’ ");
INSERT INTO gaw_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","amge da ag amelagp̱a inam aṯem. Danab laa nug amegp̱aib ah laa anṯa, nug ele oiglahnu dab meṯe amu danab amu nug gap̱ai kobol aaḵu heum. ");
INSERT INTO gaw_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","Amunu na amen naḏiap nug na hip̱unin heḵutnu eeḏidṯe dayeb amu na amen kehan maop̱e uḵaḏ! Na beḏun laih iiṯa ele dayebeb amu na padal mak abenp̱a ii meidp̱eg am ena. Na beḏun oh ena dayebeb, padal mak abenp̱a goḵut am ena iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","O na ep̱en naḏiap nug na hip̱unin heḵutnu eeḏidṯe dayeb amu na oḵulna maop̱e uḵaḏ! Na beḏun laih iiṯa ele dayebeb amu na padal mak abenp̱a ii meidp̱eg am ena. Na beḏun oh ena dayebeb, padal mak abenp̱a goḵut am ena iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","Anuḵa ag nai imu ele aop̱ig. ‘Danab laa nug wau uuidḵunu heṯe amu nug uḏug laa ewau oḵulaknu ya medaḵu,’ ");
INSERT INTO gaw_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","amge da ag amelagp̱a aṯem. Danab aun nug wau gap̱ai kobol ii heum ele amge danab nug ewau ahilah otaḏṯe, amu ah amu nug danab laa aoṯe dayeb amu nug gamu tatamnu aaḵu he, ah nug gap̱ai kobol heṯe. Aria danab nug ah amu dimp̱a aoṯe amu nug ele gap̱ai kobol heṯe. ");
INSERT INTO gaw_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","Aria da baula ele aṯem. Anuḵa ag alalḵad ag nai aop̱ig am ag dooṯeb. Nai amuam inam. ‘Na nai nahip Kayak noobp̱a, keeke laa onigp̱a g̱agaṯag qeṯana, aḏi keeke laa heḵutnu ame amu na aaḵu he! Na nahip nai amu aib tip̱alme,’ ");
INSERT INTO gaw_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","amge da ag amelagp̱a aṯem. Na keeke laa heḵutnu anana amu na nai nahip amu keeke laa onigp̱a g̱agaṯag aib qeṯame. Iiṯanab. Na hab onigp̱a nahip nai aib g̱agaṯag qeṯame. Aḏinu? Amuam Kayaknu aben. ");
INSERT INTO gaw_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","Laa ele na nahip nai wan onigp̱a aib g̱agaṯag qeṯame. Aḏinu? Amu ele am Kayaknu. Aria na nahip nai ab oḵai Jerusalem onigp̱a aib g̱agaṯag qeṯame. Aḏinu? Jerusalem amu King naḏinu aben. ");
INSERT INTO gaw_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","Amu laa ele na nahip nai na iḵin onigp̱a aib g̱agaṯag qeṯame. Aḏinu? Na hep̱e, na iḵin uḏug laa aaḵu haḵab o hin qak beḵunu elele iiṯanab. Kayak nuḵa heḵunu elele. ");
INSERT INTO gaw_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","Ag iiṯa anaknu amu iiṯa tutuḵu aig! Genab anaknu amu genab tutuḵu aig! Anam anak aaḵuib am elele. Am ag nai baula ele tuḏidna madiṯeb amu, amuam Satan he beṯe. ");
INSERT INTO gaw_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","Aria ag anuḵa nai laa aop̱ig amu ag dooṯeb. Nai amuam inam. ‘Danab laa nug na amen heeb nauheb amu na ele nug ameg hep̱e nauhaḏ! Laa nug na aen qiia aweb amu na ele nug aeg qiin awe!’ ");
INSERT INTO gaw_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","Amge da ag amelagp̱a aṯem. Aun nug ahilagp̱a eheḏ anam bia heeb, ag nuhigp̱a nob aib mep̱ig. Am inam bia. Danab nug na hip̱en laih mataḏeb, na nob nau aib eḏun meṯame. Iiṯa. Na hip̱en laih ele eḏun meṯe! ");
INSERT INTO gaw_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","Aria danab nug na heṯoḏiakp̱a meiṯa, lamen nahip aoḵunu heeb am na saket ele meṯe! ");
INSERT INTO gaw_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","Danab laa nug na ele mael laip̱u goḵulahnu g̱agaṯag duṯuniṯa heeb amu na ootp̱a aeg bak ele aib heme. Iiṯa. Na nug ele mael aḏit uḵeḏ! ");
INSERT INTO gaw_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","Aria danab nug keekenu na oḏ meṯeb am na meṯe! Amu aun nug nahip men doḏo awa, dimp̱a nob medaḵunu oḏ meṯeb am na medaḵut. ");
INSERT INTO gaw_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","Amu ag anuḵa nai laa ele aop̱ig amu ag dooṯeb. Nai amuam inam. ‘Na layapnu oot mauhḵu amge na kekeḏ nahipnu amu na ootp̱a nau, ninig ele doye!’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","Amge da ag amelagp̱a aṯem. Ag ahilag kekeḏnu amu ag oolag mauhaḏ! Danab laala ag nob nau aoglagnu ap̱eg amu ag dahilad, ag ahilagnu eḏun aib anam hep̱ig. Iiṯa! Ag itiṯak ena ag maṯeg! Amu aun aḏi ag ahilagnu oolagp̱a nau, ninig ele dooṯeb amu, ag kobol ena ahilagp̱a heig! Amu aun laala ag ahilagnu awa awa qeṯak nai maṯina, eheḏ hadṯeb ele amu, ag ag ehanadna, ahilagnu unuqiṯeg! ");
INSERT INTO gaw_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","Amup̱a ag Mamelag, hab aṯan daaṯe ele amu, ag Nug beḵod daaglag. Nug he, aam danab nau amu danab ena ele oh qaḏelagp̱a neṯe. Neene Nug he, gu ele danab ag tutuḵu amu danab ag tutuḵu iiṯa ele oh dilagp̱a neṯe. ");
INSERT INTO gaw_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","Amunu ag danab ahilagnu oolag mauhṯe ele, amu dilagib oolag mauheb amu ag aḏi nob ena aoglag? Am takis awak danab ag ele anam heṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","Ag lailḵadib humadnana amu ag danab laala amu kobol aḏip̱a ag eḏadḵulag? Iiṯa aḏi ag ele amu heṯeb ");
INSERT INTO gaw_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","amunu ag Mamelag, Nug hab aṯan daaṯe ele amu, Nug tutuḵu elelenab daaṯe, amubia ag tutuḵu dayeg! ");
INSERT INTO gaw_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","Laa ele ag dab meig! Ahilag hak ena am danab anadḵulagnuib aib hep̱ig. Ag anam heḵulag amu ag Mamelag, hab aṯan daaṯe ele amu, nuhigp̱anu nob ena ii aomna. ");
INSERT INTO gaw_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","Aria na ham bup̱uak danab ag nai doyak laḵa o iiṯa ib manp̱a ele danab ah ag binalag meḵulagnu heṯeb amubia ag muṯub ele daḏek danab aib ehanadp̱ig. Ag loḵumakp̱a heig! Da genab ag amelagp̱a aṯem. Ham bup̱uak danab amu ag hep̱ig, amunu nob ena aaḵu aon malap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","Amunu na daḏek ehanadḵutnu amu na ep̱en naneh nug ep̱en naḏiap uḏat heṯe amu aib doyom. ");
INSERT INTO gaw_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","Na anam hep̱e amu nahip oo doyak uḏat loḵumakp̱a dayebeb, na Mamen, Nug keeke loḵumak oh anidṯe ele amu, Nug nob ena eḏua medaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","Ag unuqidḵulagnu amu ag ham bup̱uak danab ag nai doyak lag oop̱a danab anadḵulagnu hip̱aidna daanna unuqidṯeb o iiṯa ib oḵai daugp̱a danab oh ag anadḵulagnu heṯeb amubia aib hep̱ig. Da genab aṯem. Ag hep̱ig, amunu nob ena, ag aaḵu aon malap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","Amge na unuqidḵutnu amu na lag oop̱a nona, od manona, na Mamen, Nug loḵumakp̱a daaṯe amu, Nug unuqidp̱e, Nug keeke loḵumak oh anidṯe ele amu Nug nob ena na medaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","Amunu haen ag unuqidṯeb amu ag iiṯa aḏi danab nai hamu kuḏum maṯinna unuqidṯeb amubia aib hep̱ig. Iiṯa aḏi ag aṯeb. ‘Ig nai kuḏum madip̱ut amu Kayak Nug dooḵu,’ aon aṯeb ");
INSERT INTO gaw_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","amge iiṯa aḏi ag kobol heṯeb amubia, ag aib hep̱ig. Ag ag Mamelag ii unuqiṯeb haenp̱a Nug ag keeke ohnu tutu meṯeb ele amu, Nug dooṯe ");
INSERT INTO gaw_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","amunu ag inam unuqiṯeg! ‘Ig Mamenig, na hab aṯan daaṯem. Na hep̱e, danab oh ag na onin, nug onilag laa oh eḏadṯe doon, aṯannab human, dab menana oiyeg! ");
INSERT INTO gaw_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","Na hep̱e, ḏo maḏoḏ nahip wan imup̱a dayaḏ! Na hep̱e, ig hab daup keeke dab menan heṯeb amubia ig ele dim lamidtu! ");
INSERT INTO gaw_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","Ig e megṯem ele amu gemunu ele meḵe! ");
INSERT INTO gaw_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","Laa hip̱unin megṯeb, ig uhuqta madaṯem, amubia na hip̱unin ihinig uhuqna meḵe! ");
INSERT INTO gaw_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","Na ip̱un ena, ig nau heḵunignu eeḏak iiṯap̱a omaigna, Satan ep̱egp̱anu awiḵe! Ḏo maḏoḏ, g̱agaṯag amu binag oḵai ele am hanhan nahipp̱aib daaṯe, oo mak ena, g̱agaṯag oh ele. Hanhan na binan ele daaḵut! Amen,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","Jesus Nug anam anana, Nug tuḏiṯa aum. “Doyeg! Ag danab ah laa dilag hip̱unin uhuqna madap̱eg amu ag Mamelag, hab aṯannu amu, Nug hip̱unin ahilag ele uhuqa madaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","Amge ag laa dilag hip̱unin uhuqna ii madap̱eg amu ag Mamelag, hab aṯannu, Nug ele ahilag hip̱unin uhuqa ii maṯama. ");
INSERT INTO gaw_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","Ag e oh lanaknu kud men daaṯeb haenp̱a amu ag iḏulag aib tiguguḏom. Ham bup̱uak danab ag e oh lanaknu kud men daaṯeb haenp̱a amu danab laa oh ag anam heṯeb anidḵulagnu amu ag heeg, iḏulag tiguguḏṯe. Da genab ag amelagp̱a aṯem. Ham bup̱uak danab ag hep̱ig amu ag amunu nob ena aaḵu aon malap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","18","Amge danab ag na e oh lanaknu kud men daatem ii doomnanu amu na e oh lanaknu kud men daanna, na iḏun ihan, iḵin qe! Na Mamen, loḵumakp̱a daaṯe ele amu, Nugib dooḵu. Na Mamen, Nug keeke loḵumak oh anidṯe ele amu Nug na nob ena eḏua medaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","Ag wanp̱anu keeke ena oh ahilagnu aib qag mep̱ig. Wan imup̱a amu keeke laala tiig qe, iiṯa meṯe amu keeke laala gauat laeg, iiṯa meṯe amu yabhoi danab ele ag aḏ lop̱aḏna keeke yab aoṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","Amge ag ahilag keeke ena hab aṯan ap̱a qag meig! Hab aṯan ap̱a amu tiig qak iiṯa, gauat iiṯa amu yab danab laa ele ii daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","Genab ag ahilag keeke ena hab aṯan ap̱a qag meig! Aḏinu? Aben nahip keeke ena ena daaṯe ele amu, na oot amup̱a ele daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","Amu na amen amu na beḏun laih laih oh amahlak madaṯe. Na amen am ena dayeb amu na beḏun laih laih oh am amahlak ele daaglag ");
INSERT INTO gaw_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","amge na amen am nau dayeb amu na beḏun laih laih laa oh am gatatu manak oop̱a daaglag. Amunu amubia, na ootp̱a Kayak keekenu dab meḵutnu elele iiṯa daaṯem dayeb amu na gatatu naunab oop̱a daaṯem. ");
INSERT INTO gaw_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","Danab laip̱u nug gumak danab aḏit dilah uḏat heḵunu elele iiṯa. Am nug laanu oo dayebeb, laanu amu nug oop̱a nau, ninig ele dooḵu. Doyaya laaib dim lamiṯaṯa, laa amu di medaḵu. Ag Kayak uḏat amu enub uḏat ele oh heḵulagnu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","Amunu da ag amelagp̱a aṯem. Ag ahilag e lanaknu aib hik aqeb ap̱ig. ‘Ig aḏi laḵunig?’ o ‘Ig le adeḵu laḵunig?’ Amu ele ag beḏulag keekenu aib hik aqeb ap̱ig. ‘Ig aḏi meḵunig?’ Kayak ag wan imup̱a oiglagnu bau maṯom amunu Nug bau dayaknu keeke ele madaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","Ag ai aaḵud anaṯeg! Ag e ii ebaṯeb amu ag qag mena bakalenu ma laḵa ii meṯeb amge ag Mamelag, hab aṯan daaṯe ele amu, Nug ai e madaṯe. Ag Kayak amegp̱a ai iite eḏadṯeb? ");
INSERT INTO gaw_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","Amu ag oolagp̱a aun nug wanp̱a dayaknu hik qeeqe, haen nuhig baula ele tuḏidṯe? Elele iiṯanab. ");
INSERT INTO gaw_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","Am ag aḏinu lamennu dab mak huana aoṯeb? Ag atup̱an bala bena daaṯeb amu anaṯeg! Ag aṯemu beṯeb? Ag uḏat ii heṯeb amu ag lamen ele ii heṯeb ");
INSERT INTO gaw_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","amge da ag amelagp̱a aṯem. Anuḵa Solomon dayeye, nug beḏup̱a lamen nuhig bala enanagnab kuḏum meṯom amge nug nuhig bala amu atup̱an bala eḏiṯak laa iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","Ag anṯeg! Giḵiḏah gemu wanp̱a beṯe amu buṯi laatu amu ag oḵulna maoeg, ab aḏup̱a ta eoṯe ele, amuam keeke hamu amge Kayak Nug bala madaṯe. Nug anam heṯe amunu ag anidna autna aweg! Kayak Nug giḵiḏa amu elele gumadṯe amunu Nug ag elenab gumadḵu. Ag oolagp̱a genab nakokib dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","Amunu ag aib dab mak kuḏum aon, ‘Ig aḏi laḵunig?’ o ‘Ig le adep̱a laḵunig?’ o ‘Ig lamen adeḵu aognig?’ ap̱ig. Iiṯa! ");
INSERT INTO gaw_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","Amuam iiṯa aḏi ag am keeke amu ohnu dab mak kuḏum aoṯeb amge ag dahilad amu ag Mamelag, hab aṯan daaṯe ele amu, Nug ag keeke amu oh aoglagnu dooṯe. ");
INSERT INTO gaw_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","Amge tatam ag Kayaknu ḏo maḏoḏnu amu kobol tutuḵu ele aoglagnu anuqak doop̱eg, dimp̱a Nug ag keeke laala ele madaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","Amunu ag keeke buṯi laatunu ele aoglagnu hik aib aqom. Buṯinu amu nuḵa piḏe nuhig keekenu dab meḵu. Am ug laa deḏ amup̱a beḵu amu deḏ amunu aaḵuib beḵu. ");
INSERT INTO gaw_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","Ag nob nau g̱agaṯagnab aomnanu amu ag laa dilag ag nob nau g̱agaṯag aoglagnu aib dab mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","Aḏinu? Ag hanhan laa ag nob g̱agaṯag aoglagnu dab meḵulag amu ag ele nob g̱agaṯag aoglag. Ag danab melemel madaṯeb amu melemel amup̱aib geha ag maṯaglag. ");
INSERT INTO gaw_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","Aḏinu na layap amegp̱a kinipan hup̱u nakok daaṯe amunu na neegṯem amge na naḵa amenp̱a, ad maha oḵai daaṯe amu ii dab medaṯem? ");
INSERT INTO gaw_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","Am aṯemun na haen oh ad maha amenp̱a dayeye amu na layap amegp̱a kinipan nakok amu aoḵutnu aṯem. ");
INSERT INTO gaw_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","Na am ham bup̱uak danab! Tatam na ad maha oḵai na amenp̱a daaṯe ele amu mautp̱e na uḵeb, peheṯan neegnana amu dimp̱a na layap amegp̱a kinipan amu maute! ");
INSERT INTO gaw_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","Qai ag eḏun emaladmananu amu ag ahilag keeke op̱ia awak ele aib madap̱ig. Amu laa ele bo ag baelagp̱a tap̱amnanu amu ag ahilag kalele ena ena amu aib madap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","8","Ag Kayak keeke enanu unuqiṯeg! Ag anam hep̱eg amu Nug ag madaḵu. Ag keeke ena maṯieg! Ag anam hena amu ag anidḵulag. Ag od qeqaleg! Ag anam hep̱eg amu Kayak Nug matula medaḵu. Amu aun nug Kayak keeke enanu unuqidṯe amu nug aoṯe. Aun nug keeke ena madiṯe amu nug anidṯe. Aun nug od qeqalṯe amu Kayak Nug od matulṯe. ");
INSERT INTO gaw_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","Nid nakok laa nug mameg amegp̱a bret medaḵunu aṯe amu mameg nug mente medaṯe? Iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","Am nid nakok laa nug mameg kakai medaḵunu aṯe amu mameg nug mat naute medaṯe? Amu ele iiṯanab ");
INSERT INTO gaw_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","amunu nau aḏi ag beḵalḵad ḏo keeke ena madaṯeb, amup̱a ig dooṯem, ag Mamelag, hab aṯan daaṯe ele, Nug danab nuhignu unuqidṯeb amu Nug genab keeke ena ḏo madaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","Anam amunu ag dahilad amu ag kobol aṯen danab ah ag ahilagp̱a heḵulagnu oolag daaṯe ele amu, kobol amuib ag danab ah dilagp̱a heig! Ḏo nai amu propet dilag nai ele amuib ip̱unigḵunu daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","Ag od nakokp̱a noig! Ib oḵai padal mak abenp̱a goṯe ele amu, nuhig od am oḵainab am danab ah kuḏum ag ib amu dim lamidṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","Amge ib bauklel abenp̱a uḵak amu nuhig od am nakok amu ib am hogog doak amunu danab ah laip̱u laip̱uib ag ib amu anidna goṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","Ag propet ham bup̱uak dilag dab meig! Propet ham bup̱uak ag, ‘Da Kayak ip̱u ip̱unadṯem,’ aon aṯeb amge amuam nai ham bup̱uak. Propet ham bup̱uak ag qai nau nug sipsip emala laḵunu, sipsip gaḏa awa ma, sipsip oolagp̱a oiṯe amubia oiṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","Ag ahilag hak amup̱a geha meu anidna dooglag. Danab ah ag grep meu amu muḏi qaun elep̱anute aoṯeb? O ag ad pig meu amu ud qaun ele amup̱ate aoṯeb? Iiṯanab. ");
INSERT INTO gaw_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","Ad oh ag nauhak iiṯa, enaib daaṯeb amu ag meulḵad ena oṯeb amge ad laa ag nauhak ele amu, ag meulḵad nau oṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","Amunu ad ena nug ad meu nau ii oṯe, aria ad nau nug ad meu ena ii oṯe. ");
INSERT INTO gaw_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","Am ele ad oh, ag meu ena ii oṯeb ele amu, danab ag wadna, ab aḏup̱a aḵaeg ta eoṯe. ");
INSERT INTO gaw_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","Amunu ag propet ham bup̱uak, meu ahilagp̱a anidḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","Danab ah ag dahilnu, ‘Naḏi, Naḏi,’ aṯeb ele, amu oh ag dahil ḏo maḏoḏ oop̱a ii nomana. Iiṯa. Danab nug da Mamel, hab aṯan daaṯe ele amu, nuhig dab mak dim lamidṯe ele amuib nug dahil ḏo maḏoḏ oop̱a noḵu. ");
INSERT INTO gaw_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","Anam daaṯe amunu heṯoḏiak deḏ naḏip̱a amu danab ah kuḏum ag dahilnu aḵulag. ‘Naḏi, Naḏi, ig na oninp̱a Kayak nai iite mehuqmut? Na oninp̱a ele ouḏi nau iite lamadmut? Ig na oninp̱a uḏat oḵai kuḏum laa iite hemut?’ ");
INSERT INTO gaw_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","Ag anam aḵulag amge da haen amup̱a miag ap̱i dooglag. ‘Da ag nakoknab laa ii doyadṯem. Ag Satan ehaniṯak danab amunu ag uuiḏna uḵeg!’ awe aḵul. ");
INSERT INTO gaw_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","Amunu danab nug nai dahil imu doya dim lamidṯe amu nug danab laa doyak ele, nug men aṯan lag heum bia daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","Nug lag he amu gu na, ui wa, ulah g̱agaṯag ele haaha, lag amu duṯunom amge ii na qeum. Aḏinu? Danab amu nug lag men qaḏep̱a heum. ");
INSERT INTO gaw_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","Amge danab nug nai dahil doya ii dim lamidṯe amu, nug ootot danab, nug danab laa ihi qaḏep̱a lag heum bia daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","Lag he, gu na, ui wa, ulah g̱agaṯag ele haaha, lag duṯune, na qeum. Amu genab nug na qa nauha auta awom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","Jesus Nug nai amu maṯia male, danab ah ameg naḏinab ag Nug nai maṯiom amunu dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","Aḏinu? Nug ḏo mehuqak danab nai ip̱uanadp̱ig bia ag ii ip̱uanaṯom. Iiṯa. Nug danab onig ele bia nai ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","Jesus Nug nai maṯia malowa, Nug qaukop̱anu no amu danab ah ameg naḏinab Nug dim lamidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","Dim lamiṯegeg, danab laa nug gaḏa oḏe ele amu nug Jesus noobp̱a uḵa, gateg qaun wa, Jesus oḏ meṯa aum. “Na oot heeb amu na hep̱e, oḏe dahil am iiṯa meḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","Nug anam oḏ meṯe, Jesus Nug ep̱egp̱a danab beḏu aḏa, amegp̱a aum. “Da ool anam daaṯe, na ena daye!” awa aum. Anam a amu pahanab oḏe amu iiṯa me, danab nug ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","Ena daye, Jesus Nug ḏo nai g̱agaṯag danab amu amegp̱a inam aum. “Na danab laa amegp̱a, da na bap̱aidminu amu aib ame. Iiṯa, na gona, na beḏun mana meṯak danab ip̱unidna, na Mosesnu ḏo ate bia, na doḏ main, Kayak meṯe! Aḏinu? Danab oh ag amup̱a dooglag, na oḏe iiṯa,” awa aum. Jesus Nug ḏo g̱agaṯag anam mewowa he uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","Amu Jesus Nug uḵa Kapenaum te amu daup 100 dilag iḵi laa uḏia, Jesus inam oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“Naḏi, dahil begbeg danab nug baeg ep̱eg mauhe, guiṯak oḵai ele doyaya, laḵa uma niiṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","A amu Jesus Nug amegp̱a aum. “Da uḵen hep̱i, ena daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","Amge ban danab dilag iḵi nug aum. “Naḏi, da am danab enate amu na uḏin, da laul oop̱a neḵut? Amunu na begbeg dahil ena daaḵunu naiib a! Na anam naiib ap̱e amu begbeg dahil eḏua ena daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","Da amu dooṯemnu diig am da ele uḏat imunu danab oḵai waalagp̱a daaiyi, ag da gumiḏegeg amu dahilad daup ag da waalp̱a ele daaṯeb. Amu da laa amegp̱a, ‘Na uḵe!’ aṯem amu nug goṯe. Aria da laa amegp̱a, ‘Na uḏie!’ aṯem amu nug uḏiṯe. Am da dahil begbeg amegp̱a, ‘Na uḏat amu he!’ aṯem amu nug heṯe amunu na naiib ap̱e, keeke amuam beḵu dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","Awa a amu Jesus Nug amu doya, Nug dab mak kuḏum awawa, Nug danab ah ameg naḏi dim lamidp̱ig amu amelagp̱a inam aum. “Da ag amelagp̱a aṯem, da Israel danab oolagp̱a, oop̱a genab doyak imubia am da laa ii anidmi ");
INSERT INTO gaw_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","amunu da ag amelagp̱a aṯem. Geha danab kuḏum aam bedep̱anu amu aam nodep̱anu ele ag Abraham, Isak, Jakop aḏi ele Kayaknu ḏo maḏoḏ haenp̱a qag meḵulag ");
INSERT INTO gaw_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","amge Israel danab ah kuḏum, ag oop̱a genab doyak iiṯa ele, ag gatatup̱a goḵulag. Ap̱a danab ag gaanna, aelag ele kikiḏḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","Awowa Nug daup 100 dilag iḵi amegp̱a aum. “Na enad uḵe! Na da begbeg danab nahip ehanidḵulnu ootp̱a genab doome amu anam aaḵu beḵu,” awa aum. Jesus Nug anam a, haen amup̱aib ban danab 100 dilag iḵinu begbeg danab eḏua ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","Ena daye amu Jesus Nug Simon laugp̱a noa, Simon nome nug oḏe, beḏu gaḵaḏak ele niieye anṯom. ");
INSERT INTO gaw_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","Anṯa Nug gumiṯa wana, ep̱egp̱a aḏa he, beḏu gaḵaḏak iiṯa me, ah amu nug aha, e ahilag babaiṯom. ");
INSERT INTO gaw_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","Aria aam no, uu doowo, danab ag ahan, danab kuḏum ouḏi nau ele omaladna Jesus top̱a gop̱ig. Uḵaeg, Jesus Nug laa ouḏi nau ele amu Nug oḏep̱aib nai anana, ouḏi nau amu Nug ag lamaṯaṯa, oḏe danab oh ele amu bapalaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","Anam heum amunu Kayaknu propet Jesaia, nug Kayak nai laa aum amu nai amu elele meṯom. Nug inam aum. “Nug nuḵa ihinig oḏe amu ug oh ele mawa uḵom.” ");
INSERT INTO gaw_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","Aria Jesus Nug danab ah kuḏum ag Nug oo meṯan talilidp̱ig ele anṯa, Nug ip̱uniṯak awak danab nuhiḵud amelagp̱a aum. “Ig le ameg mataḏta laih up̱a gotu!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","Awa a amu ag goḵulagnu daaegeg, ḏo mehuqak danab laa doa, Jesus amegp̱a aum. “Ip̱uniṯak danab, na adep adep goḵut amu da na dim lamidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","A amu Jesus Nug ḏo mehuqak danab amegp̱a aum. “Doḏ laa onig poks, biun bia, ag wan oḏep̱a niiglagnu aben ele, ai ag ele teḏ ele amge Danab Beḵalag da amu da niiaknu aben laa iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","Anam a amu nuhiḵud ip̱uniṯak awak danab laa nug Jesus amegp̱a aum. “Naḏi, na ap̱e amu da tatam uḵen, mama boomoya, da eḏuen na dim lamidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","Nug anam a amu Jesus Nug aum. “Iiṯa! Na da dim lamiḏe! Mauhak aḏi, ag dahil uḏat haknu dab ii meṯeb ele amu, ag mauhak lailḵad boomḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","Awowa amu Nug aha, ub awe, nuhiḵud ip̱uniṯak awak danab ag ele teeg gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","Uḵaegeg, ulah oḵai heehe, le ameg koḏkoḏ huan qa, ub tona malom. Le anam heum amge Jesus Nug ubp̱a niiom. ");
INSERT INTO gaw_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","Niieye nuhiḵud ip̱uniṯak awak danab ag Nug maḏ eṯan ap̱ig. “Naḏi ig mauhmatanu, na ehaniḵe!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","Ag anam aeg amu Jesus Nug aum. “Ag aḏinu baḏaṯeb? Ag oolagp̱a genab nakokib dooṯeb.” Nug anam anana amu Nug aha, ulah le ele dilahnu, a anam hemayanu amelagp̱a a amu ulah nug iiṯa me, le ele to eṯa, manin niiom. ");
INSERT INTO gaw_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","Nug anam he amu ag dab mak kuḏum aonna, aḵa aḵa ap̱ig. “Ulah le ele amu a ele danab imunu nai dim lamidṯep amunu am aṯemun? Nug am aun?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","Aria ag gona, Galelia le ameg laih Gerasa wanp̱a eeḏp̱ig. Eeḏna Jesus Nug danab aḏit, ouḏi nau qalaṯak ele, a matmatp̱anu Jesus gumidya uḏieh anatom. A daḵuḏ meya autia aopiḏ amunu danab ag ib amup̱a oiyaknu iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","A uḏiya, huanak eya apiḏ. “Kayak Beḵa, na ihinihp̱a aḏi heḵutnu uḏime? Guiṯak haen ihinih ii uḏiom amu na paha guiṯak metaḵutnute uḏime?” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","Anam aeh amu bo ameg naḏi laa nakok uma e lanan daap̱ig ");
INSERT INTO gaw_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","amunu ouḏi nau ag Jesus unuqidna ap̱ig. “Na ig lamigna doona amu lamigp̱e, ig gota, bo oolagp̱a notu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","Aeg amu Jesus Nug aum. “Ag uḵeg!” Anam a amu ag danab aḏit uuatna, ag gona, bo oolagp̱a nop̱ig. Noeg amu bo ameg naḏi amu ag oolna huana gona, aben oola noakp̱a, le amegp̱a nona, le lana mauhadna malap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","Mauhadna malaeg amu bo gumaṯak danab ag oolna gop̱ig. Ag gona, ab oḵaip̱a tena, keeke amu ohnu anana amu danab aḏit ouḏi nau qalaṯak ele dilahp̱a kobol beum amunu ele madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","Maṯieg amu danab ah ab oḵaip̱anu oh uḏin, Jesus anidna, ag Nug ahilag wanp̱anu aha, laih goḵunu unuqidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","Aria Jesus Nug aha, eḏua ubp̱a ta, le ameg laih Nug ap̱agp̱a, Kapenaum uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","Uḵa, ap̱a dayeye, danab laala ag lailag oḏe, nug baeg ep̱eg mauhak ele, qaḏaqaḏp̱a maon, Jesus top̱a uḏip̱ig. Uḏieg, Jesus Nug oop̱a genab doyak ahilag am oḵai ele anṯa, Nug oḏe danab amegp̱a aum. “O nan, na aib baḏame. Nahip hip̱unin oh amu da uhuqe medaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","Nug anam a amu ḏo mehuqak danab ap̱a daana, ag aḵa aḵa dab makp̱a inam ap̱ig. “Danab imu Nug Kayak dabiṯa, awa awa qedaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","Ag dab mak amu aoegeg, Jesus Nug nuhig dab makp̱a amu doya, Nug ag amelagp̱a aum. “Ag aḏinu dab mak nau anam aoṯeb? ");
INSERT INTO gaw_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","Aḏi nai am anaknu ug iiṯa? Hip̱unin uhuqa meṯaknu nai amute am ug iiṯa o iiṯa aha tap̱a uḵaknu nai, amutai am ug iiṯa. Amu oh iiṯa. Aḏit oh am ug ele, danabib heḵunu elele iiṯa ");
INSERT INTO gaw_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","amunu ag Danab Beḵalag da, da wan imup̱a hip̱unin uhuqen madaḵulnu g̱agaṯag ele, ag amu dooglagnu amu da hep̱i aha goḵu,” awa aum. Jesus Nug anam anana amu Nug eḏua oḏe danab amegp̱a aum. “Na ahan, qaḏaqaḏ nahip aon laḵa uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","Nug anam a amu oḏe danab nug aha, qaḏaqaḏ nuhig awa, ag noolagp̱a dimiṯim wana, laḵa uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","Ugeḵe amu danab ah ag Kayaknu ena doon, oolag ele oṯaie, ag Kayak binag mep̱ig. Aḏinu? Kayak Nug danab uḏat amu heḵulagnu g̱agaṯag maṯom. ");
INSERT INTO gaw_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","Aria Jesus Nug ap̱anu aha oiyaya amu takis awak danab laa onig Mateus, nug takis awak laḵa dayeye anṯom. Anṯa Jesus Nug amegp̱a aum. “Na dona, da dim lamiḏe!” awa aum. Anam a amu nug Jesus dim lamiṯom. ");
INSERT INTO gaw_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","Dimp̱a Jesus Nug nuhiḵud ip̱uniṯak awak danab ele ag Mateus laugp̱a e laegeg, takis awak danab kuḏum, hip̱unin danab kuḏum amu danab laa, ag Juda dilag ḏo oh ii dim lamidp̱ig, amu ele kuḏum uḏieg, Jesus amu nuhiḵud ip̱uniṯak awak danab ele e lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","Ag e lanana daaegeg, ḏo gumak danab-Parasia ag anadna, Jesusnu ip̱uniṯak awak danab oḏ madap̱ig. “Aḏinu ahilag ip̱uniṯak danab Nug takis awak danab, hip̱unin danab amu danab ag ihinig ḏo oh ii dim lamidṯeb ele amu, Nug ag ele oh daanna e laṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","Aon aeg amu Jesus Nug doya, amelagp̱a aum. “Danab oḏe iiṯa amu nug dokta top̱a ii goṯe. Iiṯa. Danab nug oḏe ele nug goṯe. ");
INSERT INTO gaw_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","Amunu ag nai imu Kayak Nug maṯiom, nuhig naip̱a daaṯe amu anidna doyeg! Nai am inam. ‘Da ag doḏ main meḏaglagnu ool ii daaṯe. Da ag laanu oolag gai iiṯa dooglagnu ool daaṯe.’” Anana Nug tuḏiṯa aum. “Da hep̱i danab kobol tutuḵu enaib heṯeb ele ag oolag eḏuḵunu ii uḏimi. Iiṯa! Da hep̱i danab kobol tutuḵu ena ii heṯeb ele ag oolag eḏuḵunu uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","Aria Layaṯak Johanesnu ip̱uniṯak awak danab ag Jesus gumidna gona ap̱ig. “Aḏinu ig amu ḏo gumak danab-Parasia ele ig hanhan e oh lanaknu kud meta daaṯem amge nahip ip̱uniṯak awak danab ag anam ii heṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","Ag Jesus anam oḏ meṯaeg amu Jesus Nug aum. “Da am danab nug ah aoṯe bia. Aria dahil ip̱uniṯak awak danab amu ag am da lailad. Amu ig dooṯem, nug awak haen amu oo gamag ahak ele amunu danab nug ah aoṯe amu, nug laiḵud ele ag ug doonna, e oh lanaknu kud mena daaglagnu iiṯa. Ag oolag gamag ahak ele amunu ag e ii uumna, ag laḵulag. Anam aaḵu daaṯe amge deḏ laa dimp̱a ag lailag, ah awom ele amu, nug laih uḵeb, haen amup̱a ag oolag ug ele amunu ag e oh lanaknu kud men daaglag. Amu da ami. Da amu danab ah aoṯe bia. Dahil ip̱uniṯak awak danab ag am da lailad bia. Da gemu ag ele daaṯem amunu ag e oh lanaknu kud mena daaglagnu elele iiṯa. Dimp̱a da gop̱i, ag anam heḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","Nug anam anana amu Nug nai tuḏiṯa ip̱uanaṯa aum. “Danab nug lamen qaṯi bau awa, lamen alagnu giḏo amup̱a tona ii koit-ṯe. Nug anam heḵu amu lamen bau ii ihak ele amu nug iheb, nakok ma amu lamen bau nug lamen alag eḏeb, katiḏa giḏo oḵai ele daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","Laa ele danab nug grep lep̱u bau, le itaknu doḏ gaḏa alagp̱a ii inaṯe. Nug anam helo amu grep lep̱u nug titiḏa heeb, doḏ gaḏa alag nug g̱agaṯag ep̱om, oḵai meḵunu elele iiṯa amunu nug aoḏeb, wain amu doḏ gaḏa ele oh iiṯa meḵulah amunu grep lep̱u bau amu le itaknu doḏ gaḏa baup̱a inaeg, a oh elele daaṯep,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","Jesus Nug anam nai maṯieye, iḵi danab laa Jesus gumiṯa uḏia, gateg qaun wa aum. “Nid ahin dahil nug geha iiḵu mauhḵunu heṯe amge na gona, ep̱enp̱a aḏap̱e, nug eḏua bau daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","Nug anam a amu Jesus nug ele uḵaeheh, nuhiḵud ip̱uniṯak awak danab ele gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","21","Amu ah laa ap̱a dayom ele amu nug kalam qak oḏe maḏ tuelp haen oh anidṯom. Iiṯa ii meṯom. Nug anam dayaya amu nug oop̱a, “Da lamen nuhig nakokib aḏaḵul amu da ena daaḵul,” aum amunu nug Jesus dimugp̱a gumiṯa wana, lamen daug aḏom. ");
INSERT INTO gaw_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","Aḏe amu Jesus Nug eḏua neeḵa anṯa, amegp̱a aum. “O aḏel, na oot gamag ahaḏ! Na ootp̱a genab doome amunu na ena daaṯem. Na oot maḏoḏ ele uḵe!” awa aum. Awa a haen amup̱aib ah nug ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","Ena daye amu Jesus Nug iḵi danab laugp̱a uḵa, Nug mahiṯak kobol diigdiig heegeg anaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","Anaṯa Jesus Nug aum. “Ag aheg! Nid ahin nug ii mauhom. Nug niiṯe,” awa aum. Awa a amu ag Nug imidp̱ig ");
INSERT INTO gaw_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","amge Jesus Nug danab ah oh lamaṯowa, Nug lag oop̱a noa, nid ahin ep̱egp̱a aḏe, nug eḏua ahom. ");
INSERT INTO gaw_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","Ahe, nai amu wan amu ohp̱a oiya malom. ");
INSERT INTO gaw_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","Jesus Nug ab amu uua ugeḵe, danab aḏit amelah gaḏuak ele Nug dim lamidyaya, onigp̱a eya apiḏ. “Dawit beḵa, na ihinihnu oot gai iiṯa doye!” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","Anam aeheh, Jesus Nug laḵa no, gaḏuak aḏit a Jesus top̱a uḏipiḏ. Uḏieh, Nug a oḏ matom. “Da a ehanatḵulnu elele oolahp̱a genab dooṯepte?” awa aum. Awa a amu a, “Yo,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","Anam aeh amu Jesus Nug ep̱eg amelahp̱a maama aum. “A dahilnu oolahp̱a genab doopiḏ, anamnab ahilahp̱a beḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","Anam a amu a amelah op̱atom. Op̱ate amu Jesus Nug ḏo nai g̱agaṯag inam matom. “Dab meiḏ! A keeke amunu danab laa apeḏ aib doyom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","Aum amge a dimiṯim goya, Jesus aḏi heum amu wan amu ohp̱a meeh oiyom. ");
INSERT INTO gaw_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","Aria Jesus amu nuhiḵud ip̱uniṯak awak danab ele ag ahan, dimiṯim goḵulagnu heegeg, danab oḏetup laa, nug ouḏi nau ele amu ag nug omalna doeg, nug Jesus guguiṯa doum. ");
INSERT INTO gaw_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","Do amu Jesus Nug ouḏi nau amu lamiṯe, oḏetup nug nai maṯiom. Nai maṯieye, danab ag dab mak kuḏum aonna ap̱ig. “Anuḵa keeke inam laa Israel oop̱a ii beum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","Ag anam ap̱ig amge ḏo gumak danab-Parasia ag, “Nug ouḏi nau iḵilagnu g̱agaṯagp̱a ouḏi nau lamadṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","Aria Jesus Nug uḵa, ab oḵai laalap̱a amu ab nakok laalap̱a ele oiyaya, danab oh, ahilag nai doyak lag laalap̱a nai ip̱uanaṯaṯa, Kayaknu ḏo maḏoḏnu Nai Ena mehuqaqa amu danab beḏulagp̱a oḏe diigdiig ele amu, Nug ag bap̱alaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","Nug danab ah ameg kuḏum anam anaṯa, Nug oo doyom. Aḏinu? Ag ug kuḏum ele doop̱ig amge ehaniṯak laa iiṯa. Ag am sipsip ag ahilag gumak iiṯa bia oip̱ig ");
INSERT INTO gaw_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","amunu Nug nuhig ip̱uniṯak awak danab amelagp̱a aum. “Daṯa e kuḏumnab oḏup̱ig amge uḏat danab kuḏum iiṯa ");
INSERT INTO gaw_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","amunu ag dad Mameg, Nug uḏat danab maaṯeb, ag gona e nuhig qag meḵulagnu unuqiṯeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","Deḏ laa Jesus Nug nuhiḵud ip̱uniṯak awak danab tuelp onilagp̱a e, ag Nug gumidna uḏip̱ig. Uḏieg, ouḏi nau lamadḵulagnu amu oḏe diigdiig ele bap̱aladḵulagnu g̱agaṯag maṯom. ");
INSERT INTO gaw_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","Nug danab tuelp g̱agaṯag anam maṯom amu ag onilag am inam. Anuqak am Simon amu Jesus Nug onig laa Petrus ataḏom. Laa amu Andreus, nug Petrus ele a am e amag. Aḏit laa amu Sebedi bekoḏ, Jakobus Johanes ele. ");
INSERT INTO gaw_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","Laa oh amu Pilipus, Batolomiu, Tomas, Mateus, nug am takis awak danab. Aria Alpias beḵa Jakobus, Tadius, ");
INSERT INTO gaw_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","Simon, nug am Selot amu Judas, Iskariot ted ele. Nug Jesus kekeḏ ep̱elagp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","Jesus Nug ip̱uniṯak awak danab tuelp maaṯe goḵulagnu daaegeg amu Jesus nai maṯa aum. “Ag gona, iiṯa aḏi dilagp̱a amu Samaria dilagp̱a ele aib gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","Iiṯa. Ag Israel buḏub, ag am sipsip padal mep̱ig oiṯeb bia oiṯeb amu, ahilagp̱a uḵeg! ");
INSERT INTO gaw_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","Ag gona, ‘Kayaknu ḏo maḏoḏ miag doum daaṯe,’ aon aig! ");
INSERT INTO gaw_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","Ag gona, oḏe danab bap̱aladnana, danab mauhp̱ig amu maḏ aṯanna amu danab gaḏalag oḏe nau ele bap̱aladp̱eg, ena daap̱eg amu ouḏi nau ele ag lamaṯeg! Keeke ag aop̱ig amu ag daden mena ii aop̱ig, ag hamu aop̱ig amunu ag hamu, daden iiṯa, ag maṯeg! ");
INSERT INTO gaw_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","Uḏat danab nug uḏat nuhig amup̱a nug e, keeke laala ele aoṯe amunu ag goḵulagnu dab menana amu ag gol, silwa, bras ");
INSERT INTO gaw_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","amu oiyaknu baṯam, lamen aḏit, baelag gaḏa amu hoḵat ele aib aop̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","Nug anam anana amu baula aum. “Ag gona, ab oḵaip̱a o ab nakokp̱a amu ag neegna autna aona, danab ena tutuḵu ab amup̱an anidna amu nug eleib daanna, uḵaknu haen beeb, ag ahan uḵeg! ");
INSERT INTO gaw_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","Ag lag oop̱a nona amu ag lag amunu danab ah humadḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","Ag humadnana amu, ag maḏoḏ dahilp̱anu aop̱ig ele amu, ag lag amup̱an danab, ag elele daaṯeb dayeb amu, ag maḏoḏ amu ag maṯaglag amge ag amu aoglagnu elele iiṯa daaṯeb dayeb amu ag maḏoḏ amu eḏun aon gona, lag laap̱a tena, ag maṯeg! ");
INSERT INTO gaw_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","Amu laa ag diin, laḵa ii maadna, nai ahilag ele ii doop̱eg amu ag lag o ab oḵai amu uuna, ag baelagp̱anu gap̱ud amu qeqalp̱eg, ab amup̱a naḏ! ");
INSERT INTO gaw_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","Da genab ag amelagp̱a aṯem, epeḏiak haen oḵaip̱a, ab amu nug Sodom Gomora ele nob nau aopiḏ, amu eḏiṯak aoḵu. ");
INSERT INTO gaw_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","Doyeg, da ag doḏ sipsip bia qai daḵuḏ oolagp̱a maaṯi goṯeb amunu ag dab mak tutuḵunab aona, keeke heig! Amu ele ag keeke oh qinonob henana, kobol nau laa heḵulagnu aib dab mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","Ag dahilad amu ag wan imup̱an danab dilag dab meig! Danab laa amu ag ag heṯoḏiakp̱a maadna, nai doyak lag oop̱a wipp̱a eheḏ mataḏadḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","Ag dahilad amu ag da dim lamiḏṯeb amunu wan imup̱an danab ag, ag diin, gabman king ele noolagp̱a maadḵulag. Maadp̱eg amu amup̱a ag dahilnu ag amelagp̱a maṯinna, iiṯa aḏi noolagp̱a ele maṯiglag. ");
INSERT INTO gaw_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","Geha wan imup̱an danab ag ag omaladna, heṯoḏiakp̱a maadp̱eg amu ag aib baḏan ap̱ig. ‘Ig aṯemun nai nob eḏugnig?’ Iiṯa. Haen amup̱aib Kayak Nug ag nai aḵulagnu ip̱uanaṯeb, ag nai mehuqḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","Ag aḵa ii mehuqmana. Iiṯa. Ag Mamelagnu Ouḏi amu Nug ag oḏelagp̱a nai mehuqḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","Nug nai amu anana amu Nug nai baula tuḏiṯa aum. “Anam amunu geha danab nug amag heṯoḏiak abenp̱a meeb, qep̱eg mauhḵu. Mameg nug ele beḵanu anamib heḵu. Amu nid ag mamelḵad anilḵad dilag op̱oḏilag beeb hep̱eg, aqap̱eg mauhḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","Anam anana Nug baula ele aum. “Geha danab oh ag oolagp̱a ahilagnu nau, ninig ele dooglag. Aḏinu? Ag am dahilad. Amge laa nug g̱agaṯag dayebeb uḵeb, keeke oh ba maleb, haen amup̱a ele nug g̱agaṯag daaḵu amu, nug padal ii mema. ");
INSERT INTO gaw_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","Amunu danab ag ab oḵai laap̱anu lamadp̱eg amu ag oolna, ab oḵai laap̱a uḵeg! Da genab ag amelagp̱a aṯem, ag Israel oh dilagp̱a uḏat hena ii malap̱eg, Danab Beḵalag da, da eḏue uḏiḵul. ");
INSERT INTO gaw_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","Amu ip̱uniṯak awak nid nug nuhig ip̱uniṯak danab ii eḏidṯe. Aria begbeg danab nug gumak danab nuhig ele ii eḏidṯe. ");
INSERT INTO gaw_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","Amu danab ag ip̱uniṯak danab, nuhigp̱a aḏi heḵulag amu ag nuhiḵud ip̱uniṯak awak nid, amu dilagp̱a ele anamib heḵulag. Aria danab ag gumak danab, nuhigp̱a aḏi heḵulag amu ag nuhiḵud begbeg, amu dilagp̱a ele anamib heḵulag. Danab ag lag mamegnu, ‘Nug am ouḏi nau iḵilag,’ ap̱ig amu geha nuhiḵud lag laip̱u amu, ahilagnu ag onilag nau kuḏumnab aḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","Amge ag amu dilag aib baḏap̱ig. Keeke oh tonak daaṯe am geha miag atiḵu. Nai oh loḵumak daaṯe amu ele danab ag dooglag. ");
INSERT INTO gaw_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","Amu nai da tuqan madiṯem amu ag amunp̱a mehuqnana, nai ag otiptipp̱a dooṯeb amu ag laḵa hip̱aidna daanna mehuqeg! ");
INSERT INTO gaw_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","Laa ag beḏulag aaḵuib qeḵulagnu elele, ag doṯolag qeḵulagnu elele iiṯa amu, ag amu dilag aib baḏap̱ig. Iiṯa. Laa nug beḏulag doṯolag ele oh heeb, padal meḵulahnu elele amu nuhignuib baḏeg! ");
INSERT INTO gaw_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","Ag dooṯeb, danab ag ai naunau aḏit amu toea laip̱up̱a daden meṯeb amge ag Mamelag Nug ii aṯe dayeb amu, ai amunu laa wanp̱a ii na qeṯe ");
INSERT INTO gaw_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","amunu da ag amelagp̱a aṯem. Ag Mamelag, Nug ag iḵilag uḏug oh eb aqa malom ");
INSERT INTO gaw_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","amunu ag aib baḏap̱ig. Ag ai naunau, amu dilag daden oh eḏadna malap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","Amu danab laa nug da onil danab ah noolagp̱a miag meḵu amu da ele danab amu, nug onig, da Mamel, hab aṯan daaṯe amu, Nug noobp̱a miag meḵul. ");
INSERT INTO gaw_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","Amge danab nug danab ah noolagp̱a da di meḏaṯe amu da ele danab amu Mama, Nug hab aṯan daaṯe ele amu, Nug noobp̱a di medaḵul. ");
INSERT INTO gaw_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","35","Da uḏimi amunu wanp̱a maḏoḏib daaḵu amu ag anam aib dab mep̱ig. Da uḏimi amunu maḏoḏib ii daama. Iiṯa, qep aeg ele keeke op̱ate, laih laih daaṯe amubia da uḏimi amunu danab nug beḵa ele a oolahp̱a laa nug da dim lamiḏebeb, laa am iiṯa amunu a maḏoḏ ele ii daamya. Nid ahin amu nug anig ele a maḏoḏ ele ii daamya. Aria ah amu nug ahip̱a ah ele a ele maḏoḏ ele ii daamya. ");
INSERT INTO gaw_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","Danabnu kekeḏ amu, laa ag nug laugp̱a daaṯeb amu, ag nuhig kekeḏ daaglag. ");
INSERT INTO gaw_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","Amu danab nug anig mameg ele dilahib oo mauhṯe amge dahilnu oo huanak ii mauhṯe amu nug da layal iiṯa. Amu ele danab nug beḵa aḏeg ele dilah oo mauhṯe amge dahilnu oo huanak ii mauhṯe amu nug am da layal iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","Laa ele, danab nug nuhig ad emaitak awa, da dim ii lamiḏṯe amu nug da layal iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","Danab nug beḏu bau mak nuhig madiṯe ele amu, nug iiṯa meḵu amge laa nug dahilnu dab ma, nug beḏunu bau mak kakidṯe amu nug genab bauklel anidḵu. ");
INSERT INTO gaw_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","Danab nug ag oo maṯa humadṯe amu nug da oo meḏa humiḏṯe. Nug da oo meḏa humiḏṯe amu nug Mame Kayak, Nug da meiḏe uḏimi ele amu, Nug oo meṯa humidṯe. ");
INSERT INTO gaw_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","Danab nug Kayaknu propet laa anṯa, nug am propet, diig amunu nug oo meṯa humidṯe amu danab amu nug propet dilag nob ena ele aoḵu. Am danab nug danab tutuḵu laa anṯa, nug am danab tutuḵu, diig amunu nug oo meṯa humidṯe amu, nug danab tutuḵu dilag nob ena ele aoḵu. ");
INSERT INTO gaw_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","Amu danab laa nug danab hamu onig iiṯa laa anidṯe amge danab hamu onig iiṯa amu nug da dim lamiḏṯe amunu danab laa nug ehaniṯa, nug le ougib hai goḵoḏp̱a medaṯe amu, da genab ag amelagp̱a aṯem, Kayak Nug danab amu nob ena medaḵu. Nug daug iinab atima,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","Jesus Nug anam nuhiḵud ip̱uniṯak awak danab nai maṯa malowa, Nug aben amu uua aha, ab oḵai laalap̱a danab ah doyak aoglagnu ip̱uanaṯaṯa, nai ele mehuqom. ");
INSERT INTO gaw_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","Mehuqeqe, Johanes nug mani guiṯak oop̱a dayaya, Kristus uḏat oh heum doya amu nug nuhiḵud ip̱uniṯak awak danab aḏit maate, a nuhig oḏ mak aoya, Jesus top̱a gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","Goya Jesus oḏ medapiḏ. “Danab laa uḏiḵunu aeg doomut am na aḵute, o iiṯa ig laate ameg meḵunig?” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","A anam oḏ meṯoya daaeheh, Jesus Nug uḏat he anṯeh amu Nug aum. “A goya, keeke oh anidya doopiḏ amu Johanes amegp̱a apeḏ doyaḏ! ");
INSERT INTO gaw_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","Amelag gaḏuak ag keeke anidṯeb, diḏilag aḏak amu ag ena oiṯeb, gaḏalag oḏe ele amu oḏe amu iiṯa meṯe, daulag ituak amu ag eḏun nai dooṯeb, danab mauhp̱ig ele amu, ag eḏun bau daaṯeb amu daḏek danab ag ele Nai Ena dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","Amunu danab aun nug nuhig oop̱a genab doyak dahilnu ii paḏe neṯe amu Kayak Nug danab amu itiṯak medaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","Jesus nai maṯia male, Johanesnu ip̱uniṯak awak danab a uḵaeh amu Nug danab ah amelagp̱a Johanesnu aum. “Ag anuḵa Johanes gumidna atu taḏakp̱a gop̱ig amu ag aḏi keeke anidḵulagnu gop̱ig? Ag keeke gai iiṯa, qaiṯobṯob bia, ulah he uḏalṯe, amu anidḵulagnu gop̱igte? Iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","Ag aḏi anidḵulagnu gop̱ig? Ag gona, danab laa lamen enanagnab kobol ele taḵom anidḵulagnu gop̱igte? Iiṯa. Danab lamen enanagnab, kobol ele tagaṯeb amu ag king laugp̱a daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","Amge ag aḏi keeke anidḵulagnu gop̱ig? Ag Kayaknu propet laa anidḵulagnu gop̱igte? Da ag amelagp̱a aṯem. Ao, ag propet anidḵulagnu gop̱ig amge nug am propetib iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","Nug am laa, Kayak Nug nuhignu a, propet laa nug Kayak oḏe awa, Kayak naip̱a yom daaṯe. Nai amuam inam. ‘Anṯe! Da hep̱i, dahil nai awa uḵa maṯiaknu danab laa nug na noom awa, nahip ib bap̱aidḵu.’ ");
INSERT INTO gaw_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","Amunu da genab ag amelagp̱a aṯem, Layaṯak Johanes nug danab oh anuḵa propet daap̱ig amu oh eḏaṯom amge danab laa nug Kayaknu ḏo maḏoḏ oop̱a danab nakokib daaṯe amu nuhig itiṯak amu Johanesnu eḏidṯe. ");
INSERT INTO gaw_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","Johanesnu haen uḏie uḏie gemu ele Kayaknu ḏo maḏoḏ nug oḵai meḵunu wagai meṯe amu wagai mak danab ag ele Kayaknu ḏo maḏoḏ aḏaglagnu wagai meṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","Propet oh dilag nai amu ḏo nai ele, a Elias neeb, Kristus neḵunu aeh uḏie Johanes beum batak ");
INSERT INTO gaw_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","amunu ag imu oolagp̱a genab dooglagnu elele amu ag doyeg! Elias uḏiḵun ap̱ig amu Johanes aaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","Laa nug daug ele dayeb amu nug doyaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","Anam anana amu Nug baula aum. “Da danab ah haen geha imunu da ahilagnu aḏi bia aḵul? Ag am nid naunau haḏapp̱a daanna, ameg laa amu ameg laa amelagp̱a enana, ");
INSERT INTO gaw_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","‘Ig ahilagnu dumuṯum iwalmut amge ag ahi ii edap̱ig. Ig ahi oo doyak ele eṯamut amge ag ii gaap̱ig,’ aṯeb amubia heṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","Aḏinu? Johanes nug uḏia amu nug e diigdiig ii laum, wain ele ii laum amunu danab ah ag nuhignu, ‘Nug beḏup̱a ouḏi nau ele,’ ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","Aria Danab Beḵalag da, da uḏien, e lain, le ele lami amunu ag aṯeb. ‘Anṯeg, Nug e huanak lanana, wain ele huanak laṯe. Nug laiḵud am takis awak danab, hip̱unin danab amu danab laa, ag ig Juda, ihinig ḏo oh ii dim lamidṯeb,’ aon aṯeb. Amge Kayaknu doyak am keeke genab amu nuhig hakp̱a ag am genab anidḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","Aria ab laalap̱a Jesus Nug keeke danab heḵunu elele iiṯa kuḏum heum amge danab ag oolag ii eḏuom, diig amunu haen amup̱a Jesus Nug ag alaṯa aum. ");
INSERT INTO gaw_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","“O gadon Korasin, o gadon Betsaida ele. Da ahilah danab oolagp̱a oiyeye, kobol diigdiig danab heḵunu elele iiṯa hemi amu danab laa nug Taia Saidon ele, danab ap̱a daaṯeb ag am iiṯa aḏi danab amu, nug danab amu ahilagp̱a kobol amubia helo amu Taia Saidon ele dilah danab ag anuḵanab lamen nau, heḏiag ele taḵan, uhuḏp̱a daanna, ag oolag eḏulo. ");
INSERT INTO gaw_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","Amunu da ag amelagp̱a aṯem, epeḏiak haenp̱a Taia Saidon ele dilah danab ah amu, ag ug aoglag amge ag danab ah ag Korasin Betsaida ele daaṯeb amu, ag amu dilag ug eḏiṯak, ug oḵainab aoglag. ");
INSERT INTO gaw_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","Aria ab oḵai Kapenaum, na onin oḵai, laa oh eḏiṯak aoḵuṯe? Iiṯa! Na padal meḵut. Danab laa nug Sodom dilagp̱a kobol da ahilagp̱a hemi amubia helo amu Sodom ag gemu daalob. ");
INSERT INTO gaw_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","Am iiṯa amunu da ag amelagp̱a aṯem, epeḏiak haenp̱a Kapenaum ag Sodom dilag ug eḏiṯak, ug oḵainab aoglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","Jesus Nug haen amup̱a nai amu maṯia malowa Nug aum. “O Mame, na hab wan ele dilah Oḵai daaṯem amu, na danab dab mak ele, doyak danab ele, na amu dilagp̱a keeke imu loḵumna, nid naunau ip̱uanadme amunu da na onin humaṯem. ");
INSERT INTO gaw_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","Yo Mama, na nahip dab makp̱a amu nahip doyakp̱a heme,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","Jesus Nug anam anana, Nug baula tuḏiṯa aum. “Da Mamel Nug keeke oh da ep̱elp̱a meum. Amu danab laip̱u laa nug Kayak Beḵa ii dooṯe. Kayak Nug nuḵaib dooṯe. Amu ele danab laip̱u laa nug da Mamel ii dooṯe. Iiṯa. Da am Kayak Beḵa amu da aaḵuib dooṯem. Amge da danab laala Mama ip̱uanadṯem ele aaḵuib am, ag Mama dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","Anam anana Nug baula ele aum. “Danab ag uḏat oḵai henana, keeke ug ele maoṯeb amu ag gumiḏna dop̱eg, da hep̱i, ag hik aoglag. ");
INSERT INTO gaw_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","Ag mawaknu keeke dahil aona, ag dahilp̱a dab mak aweg! Aḏinu? Da am wagai mak danab iiṯa amu da am oo doyak ele. Ag anam henana, ag oolagp̱a ug iiṯa oiglag. ");
INSERT INTO gaw_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","Aḏinu? Dahil mawaknu keeke nug am ug iiṯa amu amup̱a ag keeke laa, ag maoglagnu meḵul amu, amu ele am ug iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","Haen laa Meṯidp̱a Jesus Nug ibp̱a wit dad laa oop̱a ugeḵe, nuhiḵud ip̱uniṯak awak danab ag enug aqe, ag wit aeg aon lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","Aon laegeg, ḏo gumak danab-Parasia ag amu anidna, ag Jesus amegp̱a ap̱ig. “Anṯe, nahipad ip̱uniṯak awak danab ag ḏo nug danab laa Meṯidp̱a e daṯanu ii aomanu ip̱unigṯe amu, ag Juda dilag Meṯidnu ḏo amu tip̱alna, e aon laṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","Aon aeg amu Jesus Nug amelagp̱a aum. “Ag Dawit keeke heum amunu kaya iite eb qep̱ig? Haen amup̱a nug nuhiḵud daup ele ag enug daanna, ");
INSERT INTO gaw_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ag Kayak laugp̱a nona, Kayak laugp̱an bret amu aon lap̱ig. Bret amuam, danab hamu lanaknu gun. Mana meṯak danabib laḵulagnu elele amu, ag amu lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","Laa ele amu mana meṯak dilag uḏatnu yak ḏop̱a niiṯe amu ag Meṯidp̱a mana meṯak laḵa up̱a uḏat amu heṯeb amge hip̱unin iiṯa, ag amu iite eb qep̱ig? ");
INSERT INTO gaw_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","Amu da ag amelagp̱a aṯem. Da am meṯid lag eḏiṯak. ");
INSERT INTO gaw_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","Ag Kayak naip̱a nai laa daaṯe, nai amu doolob amu ena. Nai amuam inam. ‘Mana meṯak nug keeke anuqak iiṯa, oo gai iiṯa doyak kobol amuam keeke anuqak.’ Ag amu diig doolob amu danab imu ag qaḏelagp̱a ug ii melob. ");
INSERT INTO gaw_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","Amu Danab Beḵalag da, da Meṯid deḏ gumaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","Awowa Jesus Nug aben amu uua aha, ahilag nai doyak laḵa uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","Am danab laa nug ap̱a dayom amu nug ep̱eg mauhak ebehiṯak ele amunu danab laala ag Jesus heṯoḏiak abenp̱a meḵulagnu hena, ag Jesus oḏ meṯan ap̱ig. “Ig danab Meṯid deḏp̱a bap̱aidḵunignu am enate?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","Aon aeg Jesus Nug ag amelagp̱a aum. “Ag oolagp̱a danab laip̱u laa nug sipsip laip̱u ele amu sipsip amu nug Meṯid deḏp̱a moḏp̱a no amu danab amu nug iite eḏua aoṯe? ");
INSERT INTO gaw_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","Amu danab nug sipsip eḏiṯak amunu ig Meṯidp̱a danab ehanadḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","Jesus Nug anam anana amu Nug danab ep̱eg nau ele amegp̱a aum. “Ep̱en tai eṯe!” awa aum. A amu danab nug ep̱eg tai eṯe, ep̱eg eḏua, laih bia, ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","Jesus anam heum amunu ḏo gumak danab-Parasia ag gona qag mena, Jesus qeḵulagnu ib madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","Am Jesus Nug nai amu doyom amunu Nug aha, ab amu uua uḵom. Ugeḵe, danab ah kuḏum ag Nug dim lamiṯegeg, Jesus Nug oḏe danab ah bap̱alaṯe, ena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","Ena daaeg amu Jesus, Nug am Kayak Beḵa amu ag amu miag atiak amananu ḏo maṯom. ");
INSERT INTO gaw_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","Amup̱a amu Jesus Nug propet Jesaia Kayak oḏe awa, nai laa maiṯom, nai amu elele meṯom. ");
INSERT INTO gaw_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","Nai amuam inam. “Imu amu uḏat danab dahil, da Nug tituanmi. Da nuhignu ool huanak heṯe, nuhignu ool ena daaṯe. Da geha da Ouḏil hep̱i, Nug qaḏep̱a neḵu. Neeb amu Nug kobol tutuḵunu, nai amu iiṯa aḏi dilagp̱a mehuqḵu. ");
INSERT INTO gaw_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","Nug awa awa qeṯak nai ii maṯima, Nug muṯub ele ii qema. Nug baag oḵaip̱a ib naḏip̱a danab amelagp̱a ii ama. ");
INSERT INTO gaw_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","Danab laa elele iiṯa, qao laa wak ele daaṯe bia amu, Nug heeb, nauha autanab ii aoma. O danab laa elele iiṯa daaṯe, lam qauhḵunu heṯe bia, Nug heeb iiṯa ii mema. Nug uḏat heebeb uḵeb, kobol tutuḵu amu oh elele medaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","Danab ah wan atu ohnu ag Nug ameg meḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","Haen amup̱a danab ag danab laa omalna nuhigp̱a uḏip̱ig. Danab amu nug am ouḏi nau ele, nug oḏetup, ameg gaḏuak ele. Ag aon doeg, Jesus Nug he ena daya, qamutak amu nai maṯiaya, ameg obate, neeḵom. ");
INSERT INTO gaw_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","Danab nug neeḵa, nai maṯieye, danab ah ameg naḏi ag oṯaina Jesusnu ap̱ig. “Danab imu am Dawit beḵatai,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","Amge ḏo gumak danab-Parasia ag am inam ap̱ig. “Umu Nug Belsebub, ouḏi nau iḵilag ele amu, nuhig g̱agaṯagp̱a ouḏi nau lamadṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","Aeg amu Jesus Nug ahilag dab mak oh doya, Nug ag amelagp̱a aum. “Wan laip̱up̱an danab ag ahan op̱atna, ameg aḏit bena, nug qeḵulag amu wan amu nug elele iiṯa, g̱agaṯag ii daama. Amu ele, ab oḵai laip̱up̱an o ab iḵi laip̱up̱anu ag op̱atna, ameg aḏit bena, nug qeḵulag amu ab oḵai o ab iḵi amu nug ena ii daama. ");
INSERT INTO gaw_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","Amubia Satan nug Satan lamidṯe dayeb amu nuhiḵud ag aaḵu op̱atna, ameg aḏit bena, aḵa aḵa nug qeṯeb. Anam dayeb amu Satannu ḏo am aṯem ha g̱agaṯag daaḵu? ");
INSERT INTO gaw_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","Ag da Belsebub g̱agaṯagp̱a ouḏi nau lamadṯemnu aṯeb. Da genab Belsebub g̱agaṯagp̱a ouḏi nau lamadṯem dayeb amu, ag Juda, ag beḵalḵad laala ag uḏat imu ele heṯeb amu, ag ele anamib amge amu oh iiṯa amunu ag beḵalḵad ag epeḏiadp̱eg, ag Juda ag eheḏ hak ahilag miag atiḵu. ");
INSERT INTO gaw_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","Amge da Kayak Ouḏi g̱agaṯagp̱a ouḏi nau lamadṯem dayeb amu ag doyeg, Kayaknu ḏo maḏoḏ aaḵu ahilagp̱a uḏiom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","Jesus Nug anam anana, Nug nai tuḏiṯa aum. “Am danab laa nug aṯemun danab g̱agaṯag ele, nug laugp̱a noa keeke aoḵu? Am elele iiṯa amunu tatam nug danab g̱agaṯag amu muḏip̱a hip̱alowa, nug danab amu laugp̱a noa, keeke yab aoḵu. ");
INSERT INTO gaw_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","Am danab laa nug da ele layam iiṯa amu nug dahil kekeḏ. Danab laa nug da ele uḏat laip̱u ii heṯep amu nug Satan ehanidṯe. ");
INSERT INTO gaw_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","Anam daaṯe amunu da ag amelagp̱a aṯem, Kayak Nug danab ah dilag hip̱unin oh amu nuhignu amu nuhig keekenu dabiṯa, awa awa qeṯak nai ahilag oh ele uhuqa madaḵu amge danab nug Kayak Ouḏi dabiṯa, awa awa qeṯe amu Kayak Nug danab amunu hip̱unin uhuqa ii meṯama. ");
INSERT INTO gaw_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","Am danab nug Danab Beḵalag da, dahilnu nai nau aṯe amu Kayak Nug danab amunu hip̱unin uhuqa medaḵu amge danab nug Kayak Ouḏinu nai nau aṯe amu Kayak Nug hip̱unin amu uhuqa ii meṯama, gemu, dimp̱a ele. ");
INSERT INTO gaw_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","Anam amunu ad nauhak iiṯa, enaib daaṯe amu nug meu ele ena oṯe, amu ad nauhak ele amu nug am meu ele nau oṯe. Danab ag ad meu aon lana, enate o naute amu dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","Ag danab nau, ag am mat nau bia. Ag nau daaṯeb amu aṯemun kobol enanu maṯiglag? Amu ele danab oop̱a aḏi dab mak am bak niiṯe amu oḏep̱a beṯe. ");
INSERT INTO gaw_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","Am danab ena, nug oop̱a dab mak ena huanak niiṯe amunu nug kobol ena he beṯe amge danab nau, nug oop̱a dab mak nau huanak niiṯe amu nug kobol nau he beṯe. ");
INSERT INTO gaw_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","Amge da ag amelagp̱a aṯem. Epeḏiak haenp̱a Kayak Nug danab ah ag nai diig iiṯa madip̱ig ele amu, Nug amunu epeḏiadḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","Anana amu Jesus Nug baula ele aum. “Na nai madiṯem aaḵuib heeb, Kayak Nug na danab ena tutuḵu anidḵu. Na nai madiṯem aaḵuib heeb amu Kayak Nug nahipnu danab nau anidḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","Haen amup̱a ḏo gumak danab-Parasia amu ḏo mehuqak danab ele ag Jesus amegp̱a ap̱ig. “Ip̱uniṯak danab, ig na ep̱onak keeke, danab heḵunu elele iiṯa laa hep̱e anidḵunignu oonig daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","Aeg am Nug nob ma aum. “Ag danab ah naunab, ag Kayak uuna, kobol laala dim lamidṯeb ele. Ag da ep̱onak keeke, danab heḵunu elele iiṯa heḵulnu aṯeb amge da laa ii hepa. Propet Jona, nuhigp̱a aḏi beum aaḵuib ag ip̱uanadḵul. ");
INSERT INTO gaw_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","Anuḵa propet Jona nug deḏ ewam tuqan ewam ele kakai naḏi oop̱a niiom, anamib Danab Beḵalag da, da gemu haen imunu danab ah, amu dilag ep̱onak keeke daaḵulnu, da deḏ ewam, tuqan ewam ele da wan oop̱a niiḵul. ");
INSERT INTO gaw_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","Haen Kayak Nug danab ah epeḏiadḵu amu Niniwe danab ah ag ahan, danab ah haen gemunu dilag eheḏ hak amu miag atiglag. Aḏinu? Niniwe danab ag Kayak nai Jona oḏep̱a doona, ag oolag eḏuom amge gemu laa Jona eḏiṯak ina daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","Amu ele haen Kayak Nug danab ah epeḏiadḵu, haen amup̱a wan laap̱an ah oḵai, wan amuam yau uḏiṯep̱an daaṯe, nug aha, danab ah haen gemunu dilag eheḏ hak amu miag atiḵu. Aḏinu? Nug wan batakp̱anu amge nug Solomonnu doyak ena amu nug amu dooḵunu Solomon gumiṯa uḏiom amge gemu laa nug Solomon eḏiṯak am iiḵu daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","Nug anam maṯiowa amu Nug aum. “Haen ouḏi nau laa nug danab laa uuidṯe, amu nug uḵa atu taḏakp̱a, nug aben laa anṯa, hik awa daaḵunu oiṯe amge nug ii anidṯe dayeb amu nug aṯe. ");
INSERT INTO gaw_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","‘Da eḏuen, anuḵa daamip̱a uḵen daaḵul,’ awa aṯe. Anana amu nug uḵa, tatam dayom amup̱a ta, lag amu oo tatak, bala mak ele amu danab laa amup̱a ii dayeye ele anṯa, ");
INSERT INTO gaw_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","nug eḏua uḵa, ouḏi nau eblaih aḏit laa ele, ag ahilag g̱agaṯag kobol nau heḵulagnu amu nug eḏiṯak ele, nug amu diie, nug ele uḏiṯeb. Uḏin, ag lag amu oop̱a nona daaṯeb. Noeg amu danab amu anuḵa nau dayom amu gemu nug naunab daaṯe. Amubia danab ah haen gemu imunu ahilagp̱a am anam beḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","Jesus Nug danab ah nai anam madeṯe, Nug anig amaḵud ele ag Nug anidp̱eg, Nug ele nai maṯiglagnu uḏin, dimiṯim daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","Dimiṯim daaegeg, danab laa nug Jesus amegp̱a aum. “Na anin amapad, ag na ele nai maṯiglagnu uḏip̱ig, dimiṯim daaṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","Anam a am Jesus Nug oḏep̱a awa aum. “Aun am nug da anil? Aun aḏi am da amalad?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","Anam anana, Nug ep̱eg huma, nuhiḵud ip̱uniṯak awak danab ip̱uanaṯaṯa aum. “Anṯeg! Imu am da anil amu da amalad ele. ");
INSERT INTO gaw_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","Am danab laa nug da Mamel, Nug hab aṯan daaṯe ele amu, nuhig dab mak dim lamidṯe amu nug am da anil, da amal, da ap̱inal,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","Jesus Nug dimp̱a deḏ amup̱aib laḵanu aha noa, Galelia le ameg ihip̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","Dayeye danab ah kuḏumnab uḏin qag mep̱ig amunu Jesus Nug ub aṯan ta dayeye, danab ah oh ag le ihip̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","Ag anam daaegeg, Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, nai amu kuḏump̱a ag amelagp̱a maṯiom. Nug maṯia aum. “Ag doyeg! E ep̱ak danab nug e haḏag ebaḵunu aha, daṯa uḵa oiyaya, e haḏag taoḏom. ");
INSERT INTO gaw_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","Nug taoḏa ugeḵe, haḏag laala amu danab ib oiṯebp̱a nena qena niiegeg, ai ag uḏin haḏag amu lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","E haḏag laala ag wan men duqe uḵak amup̱a nena qep̱ig am wan unuqag iiṯa amunu pahanab bep̱ig ");
INSERT INTO gaw_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","amge aam na qe, ag diḏilag wan oop̱anab ii noum amunu bunaḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","Am haḏag laala ag wan muḏi qaun elep̱a nena qeeg, muḏi qaun ele ba, naḏi ma teguiṯom. ");
INSERT INTO gaw_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","Amge haḏag laala ag wan enap̱a nena qena, ena bena, meu op̱ig. Haḏag laala ag meulḵad wan handat op̱ig. Laala ag meulḵad siksti op̱ig, laala ag tieti op̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","Am danab nug daug ele dayeb amu nug doyaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","Jesus Nug anam a amu ip̱uniṯak awak danab ag dona oḏ medap̱ig. “Aṯemun na keeke danab ag dooṯeb ii dooṯeb ele ou aqatna, ip̱uanadna, amelagp̱a madiṯem?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","Aeg amu Nug inam aum. “Ag dahilad amu ag am Kayaknu ḏo maḏoḏnu keeke diig loḵumak amu dooglagnu maṯom amunu ag dooṯeb amge danab imu amu ag am iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","Danab nug dooḵunu heṯe ele amu Kayak Nug laa ele medaḵu. Meṯeb nug hap̱iak aoḵu amge danab nug doyom, bau dooḵunu ii heṯe amu Kayak Nug nuhig nakok doyom amu oh aḏidḵu. ");
INSERT INTO gaw_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","Amu da keeke danab ag dooṯeb ii dooṯeb ele ou aqatete, ip̱uanaṯe, amelagp̱a madiṯem, amunu diig am inam. Ag neegṯeb amge ii anidṯeb. Ag nai daulagp̱a dooṯeb amge oolagp̱a ele ii dooṯeb, nai diignu ele amu ag oolag ii maidṯe. ");
INSERT INTO gaw_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","Amunu propet Jesaia, nug Kayak oḏe awa, nai maṯiom, nai amu elele medaṯe. Nai amuam inam. ‘Ag nai daulagp̱a dooglag amge nai meu am tutuḵu ii doomna. Ag neegḵulag amge ag diig tutuḵu ii anidmana. ");
INSERT INTO gaw_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","Aḏinu? Danab ah imu ag oolag itua malom. Ag nai meu dooglagnu bahilag yaaṯe, amu ele ag amelag heeg gaḏuom. Amu iiṯa daalo, ag amelagp̱a keeke anidna, daulagp̱a nai doonna, ag nai diig oolagp̱a tutuḵu doona, eḏun dahilp̱a dop̱eg, da hep̱i, ag ena daaglag,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","Aria Jesus nai amu maṯia mala, Nug nai baula tuḏiṯa aum. “Anam amge ag oolag gamag ahaḏ! Ag amelagp̱a keeke anidṯeb, daulagp̱a nai dooṯeb amu ag oolag maidṯe. ");
INSERT INTO gaw_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","Amu ele da genab ag amelagp̱a aṯem. Kayaknu propet kuḏum amu danab tutuḵu aḏi ele ag gemu keeke ag anidṯeb ele imu anidḵulagnu oolag huana heum amge ag laa ii anidp̱ig. Ag nai gemu dooṯeb ele amu, ag amu ele dooglagnu oolag huana heum amge amu ele ag laa ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","Amunu ag danab nug e haḏag daṯa taoḏomnu nai, nai amuam keeke danab ag dooṯeb ii dooṯeb ele ou aqata ip̱uniṯak nai amu, nai amunu diig mehuqak doyeg! ");
INSERT INTO gaw_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","Danab laa nug Kayaknu ḏo maḏoḏnu nai doya, oo ii maidṯe amu Satan nug paha nug oop̱a noa he, Kayak nai iiṯa meṯe. E haḏag ibp̱a nena qep̱ig ele amu, nai amu anam ip̱unigṯe. ");
INSERT INTO gaw_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","Amu e haḏag men duqe uḵakp̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab laa nug nai doya, oo gamag ahehe, pahanab aoṯe. ");
INSERT INTO gaw_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","Nug nai doya aoṯe amge nuhig oop̱a genab doyak am g̱agaṯag iiṯa, haen tutunuib, amunu deḏ laa nug dahil nai dim lamidṯe, diig amunu ug laa beṯe o danab laala ag heeg, qagaiṯak dooṯe amu nug pahanab nuhig oop̱a genab doyak paḏaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","E haḏag wan muḏi qaun elep̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab laa nug nai dooṯe amge wan imup̱an ug laala, enub awak uḏat amu ameg qak kobol ele, keeke amu oh danab amu nug oop̱a Kayak nai he, iiṯa ma, meu ii oṯe. ");
INSERT INTO gaw_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","Aria e haḏag wan enap̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab nug nai daugp̱a doya dab medṯe, nai diig ele oo maidṯe amu nug meu ena oṯe, laa handat, laa siksti, laa tieti anam oṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","Jesus baula ele keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, maṯia aum. “Kayaknu ḏo maḏoḏ amu nug danab laa, nug wit aeg ena dad nuhigp̱a taoḏom amubia daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","Danab amu nug taoḏom amge tuqan, danab ah niiegeg, danab wit aeg taoḏom ele amu, nuhig kekeḏ laa uḏia, gikiḏah nau haḏag amu wit dad amupa taoḏowa uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","Dimp̱a wit amu ba meu o amu ag gikiḏah nau ele dayeye anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","Anṯeg amu begbeg nuhiḵud ag dad mameg top̱a gona ap̱ig. ‘Danab naḏi, na wit aeg enaib dad nahipp̱a taoḏme amunu aṯem he, gikiḏah nau ele beum?’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","Aon aeg amu nug ag amelagp̱a aum. ‘Kekeḏ laa nug anam heum.’ Nug anam a amu begbeg ag ap̱ig. ‘Na ap̱e, ig gota gikiḏah nau amu qaḵaladta qag meḵunigte?’ oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","Ag anam oḏ medap̱ig amge nug ag amelagp̱a aum. ‘Iiṯa. Ag gikiḏah nau hiḏanna amu wit ele hiḏaladmanade! ");
INSERT INTO gaw_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","Uup̱eg, aḏit oh meu awak haen ameg mak beiḏ! Bepeḏ, da meu awak haenp̱a meu awak danab amelagp̱a ap̱i, gikiḏah tatam hiḏaladna, iḵi aḏana, ab aḏup̱a manaknu meḵulag amge ag wit qag mena, dahil ma laḵa meḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","Jesus Nug anam anana amu Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uniṯak nai baula ele inam aum. “Kayaknu ḏo maḏoḏ amu mastet aeg, danab laa nug awa, dad nuhigp̱a ep̱om bia. ");
INSERT INTO gaw_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","Mastet aeg nug am e laa aeg bia iiṯa. Nug aeg nakoknab amge nug ba oḵai ma, dad oop̱anu e laa oh eḏadṯe. Eḏaṯa ba, ad oḵai ma dayeye, ai ag uḏin, nug ep̱egp̱a teḏ hena daaṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","Anana amu Nug baula ele keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, amelagp̱a maṯia inam aum. “Kayaknu ḏo maḏoḏ amu nug yis bia. Ah laa nug 20 kilo plaua keeke awa, yis ele kabolie, dimp̱a plaua oh titiḏa oḵai meum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","Nai imu oh am Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, danab ah amelagp̱a maṯiom. Nug nai diig laap̱a ii maṯiom. ");
INSERT INTO gaw_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","Amu Nug propet laa nai maṯiom, nai amu elele meṯom. Propet nug inam aum. “Da oḏel op̱aten, keeke danab ag dooṯeb ii dooṯeb ele ou aqate ip̱uanaṯen, nai aḵul. Da keeke dig mak haenp̱anu loḵumak daye uḏie gemu batak amunu aḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","Aria Jesus Nug danab ah uuaṯa, laḵa teum. Te amu nuhiḵud ip̱uniṯak awak danab ag gumidna uḏin ap̱ig. “Na gikiḏah nau daṯa beum, nai amuam keeke danab ag dooṯeb ii dooṯeb ele ou aqata ip̱uniṯak nai amu, nai amunu diig mehuqna ip̱unigp̱e dootu!” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","Ag anam aeg, Nug aum. “Danab nug e ena ebaṯe, amuam Danab Beḵalag da. ");
INSERT INTO gaw_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","Aria dad amu wan atu oh ip̱unigṯe. E aeg ena amu Kayaknu ḏo maḏoḏnu danab. Aria gikiḏah nau amu Satannu danab. ");
INSERT INTO gaw_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","Amu danab gikiḏah nau daṯa taoḏom ele amu Satan. Aria e meu awak haen amu wan imunu wan haen malak. E awak uḏat danab am Kayaknu engel. ");
INSERT INTO gaw_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","Am danab ag gikiḏah nau qag mena, ab aḏup̱a maiṯeb amubia Kayaknu engel ag wan haen malak haenp̱a anamib heḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","Danab Beḵalag da, da dahilad engel hep̱i, ag gona, danab Kayaknu ḏo maḏoḏ oop̱a daaṯeb ele amu, ag oolagp̱anu wannu etetuab nau, ig eeḏigṯeb ele, amu oh amu aria danab ag kobol nau heṯeb ele, ag qag maadna diin, ");
INSERT INTO gaw_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ag aḵan, agap̱eg ab aḏup̱a teḵulag. Ab naḏi amu oop̱a danab ag gaanna, ag aelag ele kikiḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","Haen amup̱a amu tutuḵu hak aḏi, ag am Kayak beḵod, ag Mamelagnu ḏo maḏoḏ oop̱a daanna, ag aam amahala miag atiak daaṯe bia miag atiak daaglag. Danab nug daug ele dayeb amu nug nai doyaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","Jesus nai anam maṯiowa, Kayaknu ḏo maḏoḏnu, keeke danab dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, imu maṯiom. Maṯiaya Nug aum. “Kayaknu ḏo maḏoḏ amu nug am enub oḵainab ele daṯa loḵump̱ig bia. Danab laa nug anṯa, baula awa loḵumowa, nug gamag ahak oḵainab doya, nug nuḵa keeke nuhig oh me, daden meeg, men doḏo amu awa uḵa, nug wan amu daden meum. ");
INSERT INTO gaw_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","Aria laa amu Kayaknu ḏo maḏoḏ nug am danab ep̱u ele, nug kalelenu doḏo ena ena maṯiom bia. Nug kalelenu doḏo laip̱u, nuhig nob oḵainab, amu maṯia anṯa, ");
INSERT INTO gaw_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","amu nug nuhig keeke oh me, daden meeg, men doḏo amu awa, kalelenu doḏo amu aaḵuib daden ma awom. ");
INSERT INTO gaw_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","Aria laa amu Kayaknu ḏo maḏoḏ nug am uhui ag le amegp̱a eeg no, kakai diigdiignu noeg am beum amubia. ");
INSERT INTO gaw_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","Aria ag uhui eeḏeg uḏia, audam be amu ag daanna, kakai ena amuib epeḏiadna, tap̱iḏ laalap̱a maadp̱ig amge kakai nau am ag aḵaeg gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","Amubia wan haen malaknu deḏ amu anam aaḵu beḵu. Engel ag nena, danab nau ag danab ena oolagp̱a daaṯeb amu qag maadna, ");
INSERT INTO gaw_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","agap̱eg ab aḏup̱a teḵulag. Aben amup̱a danab ag gaanna, ag aelag ele kakiḏḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","Jesus Nug anam anana Nug oḏ maṯom. “Ag nai maṯimi imu oh diig doop̱igte?” awa aum. Nug anam oḏ maṯe amu ag, “Yo,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","Ag, “Yo,” aon aeg am Nug ag amelagp̱a aum. “Anam amu ḏo mehuqak danab oh, ag Kayaknu ḏo maḏoḏ oop̱a nop̱ig ele amu, ag am lag oḵai mameg bia daaṯeb. Nug en lag nuhigp̱anu keeke alag bau ele aḵe do madaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","Jesus Nug nai keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, oh maṯia malowa Nug ab amu uua uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","Nug ap̱ag digp̱a uḵa, Juda dilag nai doyak laḵa danab ah amelagp̱a Kayak nai mehuqom. Nai mehuqe, ag dab mak kuḏum aona ap̱ig. “Doyak amu, kobol danab heḵunu elele iiṯa haknu g̱agaṯag ele imu oh amu, Nug adep̱anu awom? ");
INSERT INTO gaw_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","Nug am lag hak danab beḵa! Ig dooṯem, Maria amu nug anig. Nug amaḵud amu Jakobus, Josep, Judas, Simon. ");
INSERT INTO gaw_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","Nug ap̱inḵud amu ag oh ig ele iite daaṯem? Amunu Nug keeke imu oh am adep̱anu awom?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","Ag anam anana ag oolagp̱a Jesusnu ena ii doop̱ig amge Jesus Nug ag amelagp̱a aum. “Propet nug ab ohp̱a amu onig ele amge nug ap̱ag diigp̱a amu nug laugp̱a ele amu nug onig iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","Amu ap̱a Nug oḏe danab kuḏum ii bap̱alaṯom. Aḏinu? Ag oolagp̱a genab ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","Haen amup̱a Herodes Antipas nug Jesus onig binag ele doyom. ");
INSERT INTO gaw_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","Doya amu nuhiḵud uḏat danab amelagp̱a aum. “Danab amuam Layaṯak Johanes mauhowa, eḏua hibaiṯom amunu g̱agaṯag oḵai oḵai amu nuhigp̱a beṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","4","Amu diig am Herodes Antipas nug amag Pilipus wau Herodias awe, Johanes nug Herodes amegp̱a, “Na awan wau aome, amup̱a na ḏo tip̱alme, kobol amuam ena iiṯa,” aum amunu Herodes nug Johanes ep̱eg hip̱ala, mani guiṯakp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","Amu nug Johanes qeeb mauhḵunu heum amge nug danab ah dilag baḏom. Aḏinu? Danab ah ag Johanesnu, “Nug am Kayaknu propet,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","Anam dayom amge Herodes Antipas menuak deḏp̱a, Herodias aḏeg amu ḏo danab kuḏum noolagp̱a ahi goḏe, Herodes nug iṯag qeum ");
INSERT INTO gaw_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","amunu nug nai qaḵa, nug nid ahin keeke aḏi laa aoḵunu ab amu medaḵununab aum. ");
INSERT INTO gaw_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","Nid ahin amu anig nug dab mak meṯom amunu nug aum. “Na Layaṯak Johanes baag otaḏna, iḵi tap̱iḏp̱a mena, haen imup̱a meḏaḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","Nid ahin nug anam a amu king Herodes nug oo ug ele dayom amge nug nai nuhig g̱agaṯag qa aawo, ḏo danab ag nug ele e lap̱ig amu ag ele nai amu doop̱ig amunu nug aum. “Layaṯak Johanes iḵi tap̱iḏp̱a mena, aon dona meṯeg!” ");
INSERT INTO gaw_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","anana amu nug he, uḏat danab laa nug uḵa, Johanes baag otaḏom. ");
INSERT INTO gaw_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","Bag otaḏe amu ag nug iḵi tap̱iḏp̱a mena, nid ahin medap̱ig. Nid ahin meṯaeg amu nid ahin nug awa uḵa, anig meṯom. ");
INSERT INTO gaw_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","Layaṯak Johanesnu ip̱uniṯak awak danab ag nai doona uḏin, Johanes gaḏa aon gona boomp̱ig. Ip̱uniṯak awak danab ag Johanes boomona, ag gona, Jesus amegp̱a ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","Jesus nai amu doya, Nug aben amu uua, ub awa, aben danab ii daaṯeb, ap̱a goḵunu uḵom. Nug anam ugeḵe amu danab ah ag nai doona, ag ab ohp̱anu ahan, Jesus ugeḵe, ag baelagp̱a Nug dim lamidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","Ag anam heegeg, Jesus uḵa eeḏa amu danab ah ameg naḏi ag Nug ameg mena daaegeg anaṯom. Nug anam anaṯa amu oo doye, ahilḵad danab ah oḏe ele amu bap̱alaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","Bap̱alaṯeṯe, tueb me, nuhig ip̱uniṯak awak danab ag Jesus gumidna dona amegp̱a ap̱ig. “Laih imu am aben danab ii daaṯeb. Aam ele uḵa noṯe amunu danab ah ameg naḏi imu amelagp̱a ap̱e, ag ab ab gona, e daden mena laig!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","Ip̱uniṯak awak danab ag anam aeg amu Jesus Nug aum. “Aḏinu da ap̱i goḵulagnu aṯeb? Ag e madap̱eg laig!” ");
INSERT INTO gaw_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","Nug anam a amu ag amegp̱a ap̱ig. “Amge ig ip̱a e kuḏum laa iiṯa, bret kunum tanig ele amu kakai aḏit eleib daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","Anam aeg amu Nug aum. “Aḵan dona, da meḏeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","Anana amu Nug danab ah ameg naḏi, ag amelagp̱a, “Ag gikiḏahp̱a dayeg!” anana amu Nug bret tanig ele amu kakai aḏit ele amu diia aḏa, hab aṯan neeḵaḵa unuqiṯom. Unuqiṯowa amu pane ne, nuhiḵud ip̱uniṯak awak danab maṯe, ip̱uniṯak awak danab ag diin panin, danab ah madap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","Maṯaeg amu danab ah ag e amu laeg, oolag diṯie, e big dayom amu ip̱uniṯak awak danab ag aon, kaleg tuelp inaeg, am beum. ");
INSERT INTO gaw_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","Danab e lap̱ig ele amu 5,000 anam. Ah nid naunau ele amu eb qak amu oop̱a ii daaṯeb, danabib eb aqap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","Ag e lana malaeg amu Jesus Nug nuhiḵud ip̱uniṯak awak danab ag amelagp̱a aum. “Da danab ah imu oh qatiglagnu abip̱i, ag ahan ubp̱a tena, Galelia le mataḏna, laih uḵeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","Nug anam a amu ag ahan uḵaegeg, Jesus Nug danab ah amelagp̱a, “Enad uḵe,” awowa, Nug nuḵa amu unuqidḵunu qaukop̱a uḵom. Tueb amup̱a amu Nug nuḵa qauko amup̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","Qaukop̱a dayeye amu ub uḵa, le ameg gamagp̱a wa, ulah naḏi ha, duban ub qe, ulah ub nob awe, eḏua laih goḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","Anam he uḵe, waḵaḏeḏe Jesus le gaḏa tap̱a, nuhiḵud ip̱uniṯak awak danab gumaṯa uḏiom. ");
INSERT INTO gaw_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","Ip̱uniṯak awak danab ag Jesus le gaḏap̱a tap̱a uḏieye anidna, oṯaina, “Umu am doṯog,” anana, oolag baḏe huanak ep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","Huanak eeg amu Jesus Nug pahanab amelagp̱a aum. “Ag g̱agaṯag dayeg! Ag aib baḏap̱ig. Imu daib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","Jesus anam a amu Petrus nug Jesus oḏep̱a awa, inam aum. “Naḏi, genab na daaṯem dayeb amu na ap̱e, da ub uuen, na gumiṯe waḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","Petrus anam a amu Jesus aum. “Na do!”, awa aum. Nug anam a amu Petrus nug ub uua noa, Jesus gumiṯa waum. ");
INSERT INTO gaw_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","Nug anam wanana amu ulah huanak heehe anṯa baḏa, le oop̱a noḵunu ha, Jesus onigp̱a ewa aum. “Naḏi na da ehaniḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","Petrus anam a amu pahanab Jesus ep̱eg bahia, Petrus aḏa amu amegp̱a aum. “Na ootp̱a nakokib genab dooṯem. Aḏinu na dab mak aḏit ele?” ");
INSERT INTO gaw_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","Jesus Nug anam Petrus amegp̱a a, a ub aṯan oolya teeh amu ulah to eṯom. ");
INSERT INTO gaw_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","Ulah to eṯe, ub aṯan daap̱ig ele amu ag Jesus noobp̱a dup nona, binag mena ap̱ig. “Genab na am Kayak beḵa,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","Jesus beḵod ele ag ub aṯan gona, le mataḏna Genesaret ihip̱a eeḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","Eeḏna teeg amu danab ap̱anu ag doop̱ig, am Jesus, amunu ag nai meeg, ab taliliak amu ohp̱a uḵe doona, oḏe danab oh diin, Jesus top̱a uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","Uḏina ag oḏe danab Jesusnu lamen daugib aḏaglagnu unuqidp̱ig. Unuqidna, danab ag anam hep̱ig ele, amu oh ag beḏulag ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","Aria amu dimp̱a ḏo mehuqak danab amu ḏo gumak danab-Parasia ele ag Jerusalemnu ahan, Jesus gumidna uḏin ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“Aḏinu nahipad ip̱uniṯak awak danab ag alai aḏi anuḵa ḏo mep̱ig niiṯe amu ag tip̱alṯeb? Ag e laḵulagnu hena amu ag ep̱elag, ḏo aṯe amubia ag ii ihaṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","Ag anam aeg amu Jesus Nug eḏua amelagp̱a aum. “Aṯemun ag ahilag ḏo dim lamidnana amu Kayaknu ḏo tip̱alṯeb? ");
INSERT INTO gaw_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","Kayak Nug ḏo inam ma aum. ‘Na anin mamen ele binalah mena, nai ahilah dim lamiṯe!’ Amu Nug inam ele aum. ‘Danab laa nug Kayak onig diia, anig mameg ele a nob nau aoglahnu aḵu amu ag qep̱eg mauhaḏ!’ amunu laa nug anig mameg ele ehanataḏ! ");
INSERT INTO gaw_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","Amge ag inam aṯeb. ‘Danab laa nug men doḏo laa, anig mameg ehanatḵunu ele amge nug a amelahp̱a, “Da men doḏo imu Kayaknu tituanmi,” anana amu nug anig mameg ele ii ehanatma.’ ");
INSERT INTO gaw_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","Ag anam henana ag, ag alalḵad aḏi dilag ḏonu anuqak doon dim lamidṯeb, amu amup̱a Kayaknu ḏo am hamu bia daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","Ag ham bup̱uak danab! Propet Jesaia nug ahilagnu tutuḵunab aaḵu anuḵa inam maṯiom. ");
INSERT INTO gaw_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","‘Danab ah imu ag oḏelagp̱aib da binal meṯeb. Ag oolag amu da uuiḏa piḏenab daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","Ag danab ah dilag ḏo aaḵuib mehuqnana amu ag amunu, “Kayaknu ḏo,” aṯeb amunu ag da hamu binal meṯeb,’ awa yom.” Jesus Nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","Jesus anam anana amu danab ah onilagp̱a e, gumidna doeg, amelagp̱a aum. “Ag imu daulagp̱a doon, dab meṯan autna aweg! ");
INSERT INTO gaw_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","Keeke dimiṯimnu danab oop̱a noṯe ele, keeke amu danab oo dubuṯid ii medṯe. Iiṯa! Keeke danab dab makp̱a loḵumak dayaya, oḏep̱anu dimiṯim beṯe ele amu, keeke amu danab oo he, dubuṯid ele daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","Haen amup̱a nuhiḵud ip̱uniṯak awak danab ag Jesus gumidna dona ap̱ig. “Ḏo gumak danab-Parasia ag nai amu doon, oolag nauhom amu na dooṯemte?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","Ag anam aeg amu Jesus Nug nob ma aum. “Da Mamel, Nug hab aṯan daaṯe amu, Nug dad ele. Am keeke oh Nug ii ep̱om am geha Nug diḏi ele oh kakeḏiadḵu. ");
INSERT INTO gaw_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","Amubia amu ḏo gumak danab-Parasia, ahilag ip̱uniṯak am iiṯa meḵu amunu ag ahilagnu aib ug aqom. Ḏo gumak danab-Parasia ag danab ah omaladṯeb amge ag amelag gaḏuom. Am ameg gaḏuak laa, nug laa, nug ele ameg gaḏuak ele, nug ib ip̱uniṯeb amu a oh moḏp̱a neya qeḵulah,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","Jesus anam a amu Petrus nug oḏep̱a awa aum. “Na keeke danab ag dooṯeb ii dooṯeb ele ou aqatna, ip̱uanadnana maṯime, amu diig mehuqp̱e dootu!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","A amu Jesus Nug aum. “Ag am danab laala ag am dab mak iiṯa biate amunu ag nai amunu diig ii dooṯeb? ");
INSERT INTO gaw_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","Dimiṯimnu keeke, danab laṯe ele amu, nug danabnu dab mak abenp̱a ii goṯe. Iiṯa, nug danab biigp̱a uḵe, nug biie goṯe. ");
INSERT INTO gaw_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","Amge keeke nau oh danabnu dab makp̱a dayaya, oḏep̱a dimiṯim beṯe ele amu, amup̱a danab nug oo dubuṯid ele daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","Keeke nau dab makp̱anu beṯe am inam bia. Dab mak nau, danab qe mauhak kobol, gap̱ai kobol diigdiig, yabhok kobol, nug dimug maṯiak kobol, nai genab iiṯa anak kobol ele. ");
INSERT INTO gaw_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","Keeke amu oh amu ag heeg, danab nug oo dubuṯid ele daaṯe amge danab laa nug ep̱eg ii ihowa e laṯe amu nug oo dubuṯid ele ii daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","Jesus Nug anam anana amu ab amu uua aha, Taia Saidon heqop̱a ab nakok laa amup̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","Nug uḵa te, Kanan buḏubp̱anu ah laa nug ap̱a dayom amu nug Jesus onigp̱a ewa aum. “Naḏi, na Dawit beḵa, na dahilnu oot gai iiṯa doye! Ouḏi nau nug nid ahin dahil he nauhom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","Aum amge Jesus Nug oḏep̱a nakok laa ii awom. Oḏep̱a nakok laa ii awe amu nuhiḵud ip̱uniṯak awak danab ag Jesus gumidna dona ap̱ig. “Ah imu nug ewawa, ig dim lamigṯede. Na hep̱e uḵaḏ!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","Anam aeg am Jesus Nug aum. “Israel padal mep̱ig, amu dilagnuib Kayak Nug he uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","Anam aawo amu ah nug uḏia, gateg qaun wa, Jesus baegp̱a dup noa, “Naḏi na da ehaniḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","Jesus Nug oḏep̱a awa aum. “Ig nid naunau dilag bret aot, qai maṯagnignu am kobol ena iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","Nug anam aum amge ah nug aum. “Naḏi na genab aṯem ge qai ag mamelḵad dilag bret hup̱u balalp̱anu na qeṯe am aon laṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","Anam a amu Jesus Nug oḏep̱a awa aum. “Ah, nahip oop̱a genab doyak am oḵainab! Keeke na oot aum, nahipp̱a anam beḵu,” awa aum. Jesus Nug anam a amu aam ameg amup̱aib nid ahin nuhig eḏua ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","Aria Jesus Nug ab amu uua, Galelia le ihi maṯa uḵa, qauko laap̱a ta, heḏep na dayom. ");
INSERT INTO gaw_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","Ap̱a dayeye, danab ah kuḏum ag danab baelag nau, amelag gaḏuak, ebehilag kaliak, oḏetup amu oḏe danab laala kuḏum ele, ag amu oh omaladna uḏin, nug baegp̱a qag meeg, bap̱alaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","Bap̱alaṯe, danab ah ag anam anidna, oṯaina, dab mak kuḏum aop̱ig. Aḏinu? Danab ah baelag nau ele amu ena oip̱ig, amelag gaḏuak ele amu neegp̱ig, ebehilag kaliak tutuḵu dayom amu oḏetup ag ele nai madip̱ig. Ena daap̱ig amunu ag Israel dilag Kayak binag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","Danab ah ag anam heeg amu Jesus Nug nuhiḵud ip̱uniṯak awak danab onilagp̱a e doeg, ag amelagp̱a aum. “Da danab ah imu oh dilag ool dooṯe. Ag dahilp̱a uḏieg, ig deḏ ewam imu aaḵu daamut. Ag e oh laegeg, iiṯa me, gemu ag e iiṯa. Da hep̱i, ag enug goḵulagnu ool ii daaṯe. Aḏinu? Ag enug aqaṯe amunu da hep̱i, ag ibp̱a gobep̱eg, beḏulag gai iiṯa meeb, nena qeḵulagtai,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","Jesus anam a amu ip̱uniṯak awak danab ag Nug amegp̱a ap̱ig. “Laih ip̱a amu danab ag ii daaṯeb, ig adep̱anu bret kuḏum, danab ah ameg naḏi imu dilag elele aop̱ut, ag elele lap̱eg, oolag didiḵu?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","Aeg amu Jesus amelagp̱a aum. “Ag bret gane ap̱a daaṯe?” awa a amu ag ap̱ig. “Ig bret eblaih aḏit ele, amu kakai naunau laip̱u laip̱u ele,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","Ag anam aeg, Jesus Nug danab ah oh amelagp̱a, “Ag heḏep nena dayeg!” a, ag aaḵu daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","Ag anam daaegeg, Jesus Nug bret eblaih aḏit ele amu kakai ele diia, Kayak amegp̱a, “Ena hen meḵame,” awowa, pane ne, nuhiḵud ip̱uniṯak awak danab maṯom. Maṯe, ip̱uniṯak awak danab ag danab ah madap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","Maṯaeg laeg, ag oh oolag diṯiom. Danab ah ag oolag diṯie, e big dayom amu ip̱uniṯak awak danab ag aon inaeg, kaleg eblaih aḏit am beum. ");
INSERT INTO gaw_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","Danab e lap̱ig ele amu ahilag eb qak 4000. Ah nid naunau ele amu eb qak amu oop̱a ii daaṯeb. Danabib eb aqap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","Jesus Nug danab ah ameg naḏi amu he uḵaegeg, Nug ub aṯan ta, Magdan uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","Deḏ laa ḏo gumak danab-Parasia amu ḏo gumak danab-Sadusi ele ag Jesus aḏaglagnu ib anidḵulagnu ag Nug gumidna gona, ag Jesus Nug hab aṯannu ep̱onak keeke, danab heḵunu elele iiṯa, laa heeb anidḵulagnu ap̱ig ");
INSERT INTO gaw_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","amge Jesus Nug nob ma aum. “Tueb amu ag aṯeb, ‘Aam amam eeḏe, hab kokoḏ ep̱om amunu atu ena daaḵu,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","Aria buṯua amu ag aṯeb, ‘Gemu amu lombig hin qak, hab am kokoḏ amunu haen nau, gu ulah ele daaḵu,’ aon aṯeb. Ao, ag gu haen, aam haen daaḵunu lombig, nug hab waap̱a kobol heṯe amu, ag tutuḵu anidna epeḏiṯeb amge ag haen gemu imunu anidna epeḏiglagnu amu ag ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","Ag danab ah naunab. Ag Kayak uuna, kobol laala dim lamidṯeb ele. Ag da kobol danab heḵunu elele iiṯa hep̱i anidḵulagnu aṯeb amge da laa ii hepa. Jona nuhigp̱a aḏi beum aaḵuib ag ip̱uanadḵul.” Jesus anam anana, Nug uuaṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","Uuaṯa uḵe, Jesus Nug nuhiḵud ip̱uniṯak awak danab ele ubp̱a tena, le ameg mataḏna gonana, ip̱uniṯak awak danab ag bret manik laa ele aon goḵulagnu daulag atiom. ");
INSERT INTO gaw_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","Ag anam gona tewona amu Jesus Nug ag amelagp̱a aum. “Ag ḏo gumak danab-Parasia amu ḏo gumak danab-Sadusi ele, ag amu dilag bret titiḏaknu keeke onig yis, amunu dab meig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","Nug anam a amu ip̱uniṯak awak danab ag aḵa aḵa ap̱ig. “Ig bret ii aomut amunu Nug anam aum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","Jesus Nug nai amu doya aum. “O danab, ag oolagp̱a genab nakokib dooṯeb ele, ag aḏinu bret iiṯa amunu nai madiṯeb? ");
INSERT INTO gaw_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","Ag dab mak nakok iitai aoṯeb? Ag bret tanig eleib amu danab 5,000 laeg, kaleg gane inaeg am beum? Amu ag amelagp̱a iite doṯe? ");
INSERT INTO gaw_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","Amu ag bret eblaih aḏit ele amu danab 4,000 laeg, ag kaleg gane inaeg am beum. Amu ag amelagp̱a iite doṯe? ");
INSERT INTO gaw_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","Ag aṯemun keeke imunu ii doop̱ig? Da bretnu ii ami amge da baula aṯem. Ag ḏo gumak danab-Parasia, ḏo gumak danab-Sadusi ele dilag bret titiḏaknu keeke onig yis amunu dab meig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","Jesus anam a amu ip̱uniṯak awak danab ag doop̱ig, Nug bret titiḏaknu keeke onig yis amunu ii aum. Iiṯa. Nug ḏo gumak danab-Parasia amu ḏo gumak danab-Sadusi ele dilag nainu aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","Aria Jesus Nug nuhiḵud ip̱uniṯak awak danab ele ag gonana, ag Sisaria Pilipai guḵuidna wanana amu Jesus Nug ag oḏ maṯom. “Danab ag, Danab Beḵalag da, dahilnu aḏi aṯeb?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","Anam a amu ag ap̱ig. “Laa ag nahipnu, ‘Layaṯak Johanes,’ aṯeb, laa ag, ‘Nug am Elias,’ aṯeb. Laa amu ag, ‘Nug am Jeremaia,’ o ‘Nug am propet laa,’ aon aṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","Ag anam aeg amu Jesus Nug aum. “Anam aaḵu amge ag aḵa amu dahilnu aḏi aṯeb?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","Jesus anam a amu Petrus oḏep̱a awa aum. “Na am Kristus, Kayak Nug na tituaniṯom, na Kayak bauklel ele Beḵa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","A amu Jesus Nug oḏep̱a awa aum. “Simon, Jona beḵa, Kayak Nug na itiṯak medaṯe. Danab wanp̱anu laa nai amu ii ip̱uniṯom. Iiṯa, da Mamel hab aṯan daaṯe, Nug na ip̱uniṯom ");
INSERT INTO gaw_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","amunu da na amenp̱a aṯem, na am Petrus, na am men, nahipp̱a da tamaniak dahil buuḵul. Buup̱i, Satannu g̱agaṯag nug qeeb ii nema. ");
INSERT INTO gaw_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","Da Kayaknu ḏo maḏoḏ odnu ki amu na medaṯem. Keeke na wanp̱a qagaḵut amu Kayak Nug hab aṯan ele qagaḵu. Aria keeke na wanp̱a uhuqḵut amu Kayak Nug ele hab aṯan uhuqḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","Jesus Nug anam anana amu ag laa amelagp̱a nuhignu, “Nug am Kristus,” amananu ḏo g̱agaṯag meum. ");
INSERT INTO gaw_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","Haen amup̱a Jesus Nug dig ma, Nug Jerusalem uḵeb amu nuhigp̱a aḏi beḵunu amu ip̱uanaṯom. Juda iḵi danab amu mana meṯak danab oḵai amu ḏo mehuqak danab ele ag geha Nug guiṯak meṯaglagnu aum. Aria ag qep̱eg mauheb, deḏ ewamp̱a Kayak Nug heeb, Nug eḏua hip̱aidḵunu ele aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","Anam a amu Petrus nug Jesus omala, daugp̱a uḵa, daug bata, amegp̱a aum. “Naḏi na nahipp̱a keeke amu iinab bema, iiṯanab!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","Awa a amu Jesus Nug eḏua Petrus amegp̱a aum. “Satan, na Kayaknu dab mak ii dim lamidṯem, danab dilag aaḵuib dim lamidṯem amunu na dimulp̱a uḵe. Na da nool aib qeṯame,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","Haen amup̱a Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Laa nug da dim lamiḏḵunu oo dayeb amu nug nuhig dab mak dim lamidḵunu dab ii mema, nuhig ug amu mawa, da dim lamiḏaḏ! ");
INSERT INTO gaw_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","Aria danab laa nug wanp̱a bau daaḵunu dab mak anuqak aoṯe amu nug bauklel hanhannu ii aoma amge laa nug dahilnu anuqak dooṯe, wanp̱anu bau dayak amunu anuqak ii dooṯe amu nug am bauklel hanhannu aoḵu. ");
INSERT INTO gaw_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","Danab nug wanp̱anu keeke oh aoṯe amge nug bauklel hanhannu ii aoṯe amu keeke amu nug aṯem ehanidḵu? Nug aḏip̱a bauklel hanhannu daden meḵu? ");
INSERT INTO gaw_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","Danab Beḵalag da amu engel ele, ig Mamanu amahlak, kobol ele uḏignig, haen amup̱a da danab ah dilag hak, amu nob eḏue madaḵul. ");
INSERT INTO gaw_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","Da genab ag amelagp̱a aṯem. Danab laala gemu ip̱a hip̱aidna daaṯeb ele amu, ag paha ii mauhmana. Iiṯa. Tatam ag Danab Beḵalag da, dahil ḏo maḏoḏ ele awen nein daap̱i, ag mauhḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","Deḏ eblaih laip̱u uue, Jesus Nug Petrus, Jakobus Johanes ele, ag omalaṯa, qauko oḵai laap̱a te, ag aḵa daap̱ig. Jakobus Johanes ele amu, a am eamag. ");
INSERT INTO gaw_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","Ap̱a daanna, Jesus Nug beḏu eḏuom. Beḏu eḏue amu Nug iḏu amu aam amahlak bia amahalele, nuhig lamen amu haḵabnab, amahlak bia dayom. ");
INSERT INTO gaw_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","Anam amahalele amu Moses Elias ele a tulai doeh, Jesus ele nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","Maṯiegeg amu Petrus nug Jesus amegp̱a aum. “Naḏi, ig aben imup̱a daagnignu am enanag amunu na ap̱e, da peh ewam buuḵul. Nahip laip̱u, Mosesnu laip̱u amu Eliasnu laip̱u ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","Nug anam maṯieye, lombig haḵabnab tonaṯeṯe, lombig oop̱anu baag laa inam a doop̱ig. “Imu am nid dahil, da nuhignu ool huanak mauhṯe. Nuhig haknu da ool enaib. Ag nuhig nai doyeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","Awa a amu ip̱uniṯak awak danab ag nai amu doona, ag baḏan nena qena, iḏulag wanp̱a loḵumidna niip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","Ag anam baḏan heegeg, Jesus Nug gumaṯa doa, aḏalaṯa amelagp̱a aum. “Ag aheg! Ag aib baḏap̱ig.” ");
INSERT INTO gaw_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","Jesus anam a amu ag iḵilag human, danab laa ii anidp̱ig, Jesus nuḵaib anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","Ag anam hewona, ahan qaukop̱anu nenana, Jesus Nug ip̱uniṯak awak danab, ag keeke anidp̱ig amunu maṯimnanu ḏo g̱agaṯag ma, amelagp̱a inam aum. “Ag danab laip̱u laa amegp̱a kobol anidp̱ig amunu aib madip̱ig! Ag anam daap̱eg uḵeb, Danab Beḵalag da, da eḏue hip̱aidp̱i maṯiglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","Nug anam a amu ip̱uniṯak awak danab ag Jesus oḏ medap̱ig. “Aḏinu ihinig ḏo mehuqak danab ag, ‘Elias nug tatam uḏieb, dimp̱a Kristus uḏiḵu,’ aṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","Aeg amu Jesus Nug aum. “Ag, ‘Elias nug tatam uḏia, keeke oh bap̱aidḵu,’ aṯeb, amuam ag genab aṯeb ");
INSERT INTO gaw_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","amge da ag amelagp̱a aṯem. Elias nug matu uḏiom amu ag nug ii doop̱ig, ag nuhignu eheḏ heḵulagnu oolagp̱a dayom amu ag hep̱ig. Amubia Danab Beḵalag da, da guiṯak doop̱p̱i, geḏilḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","Jesus Nug nai anam maṯieye amu ip̱uniṯak awak danab ag Nug Layaṯak Johanesnu aum doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","Aria ag gona, danab ah kuḏum noolagp̱a tep̱ig. Teeg amu danab laa nug Jesus top̱a uḵa, gateg qaun wa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“Naḏi na nid danab dahilnu oot gai iiṯa doye! Nuhig oḏe am beḏu mauhak amu oḏe amup̱a deḏ laala nug beḏu huan hahaḏeḏe, na qeṯe. Haen oh nug mauha, ab aḏup̱a na qeṯe amu lep̱a ele na qeṯe. ");
INSERT INTO gaw_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","Amunu da nug awe, ip̱uniṯak awak danab nahipad gumaṯe gomi amge ag hep̱eg ena daaḵunu elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","Nug anam a amu Jesus Nug nai eḏua aum. “Ag oolagp̱a genab doyak iiṯa. Ag nai genab amu kobol tutuḵu ele ii heṯeb! Da ag ele haen elab daamut amge ag dahilnu oolagp̱a genab ii doṯeb amunu da ool ug ele. Ag haen ganeb ag dahilnu oolagp̱a genab dooglag? Ag nid amu aon dahilp̱a doig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","Ag omalna doeg amu Jesus Nug ouḏi nau amegp̱a, “Na uḵe!” awa a, nug nid uuiṯe amu geha aaḵu nid beḏup̱a oḏe amu iiṯa meum. ");
INSERT INTO gaw_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","Jesus Nug anam he amu ip̱uniṯak awak danab ag aḵa dona, Jesus oḏ medap̱ig. “Aḏinu ig ouḏi nau amu lamidḵunignu elele iiṯa?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","Aeg amu Jesus Nug ag amelagp̱a aum. “Ahilag oop̱a genab doyak am iiṯa bia amunu ag elele iiṯa. Da genab ag amelagp̱a aṯem, ahilag oop̱a genab doyak nakokib dayeb, ad mastet aeg bia amu, ag keeke oḵai heḵulagnu elele. Ao, oop̱a genab doyak ahilag nakokib anam dayeb amu ag qauko umunu, ‘Na ahan laih up̱a wa!’ ap̱eg amu, geha waḵu. Amunu ag aḏi heḵulagnu daaṯe amu ag heḵulagnu elele. ");
INSERT INTO gaw_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","Amge ib laap̱a laa nug ouḏi nau imubia ii lamidma. Iiṯa. Unuqiṯak amu e oh lanaknu kud ma dayaknu ele amup̱aib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","Jesus Nug anam a, ag oh Galelia gona daanna, Jesus Nug ip̱uniṯak awak danab amelagp̱a baula aum. “Danab Beḵalag da amu, laa nug geha danab ep̱elagp̱a meiḏḵu. ");
INSERT INTO gaw_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","Nug anam meiḏeb, iup̱eg mauhḵul. Mauhp̱i, deḏ ewamp̱a Kayak heeb, da eḏue hip̱aidḵul,” awa aum. Nug anam a, nuhiḵud ip̱uniṯak awak danab ag oolagp̱a ugnab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","Amu dimp̱a ag gona Kapenaum tep̱ig. Teeg amu mana meṯak lagnu men doḏo awak danab ag Petrus top̱a uḏin inam ap̱ig. “Ahilag ip̱uniṯak danab nug mana meṯak laḵanu takis heṯete o iiṯate?” oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","Ag anam oḏ meṯaeg amu Petrus nug, “Yo,” awa aum. Nug anam anana, lag oop̱a no amu Jesus Nug tatam Petrus oḏ meṯom. “Simon, na aṯem dooṯem? Wan imup̱anu gabman oḵai ag aun top̱anu takis aoṯeb? Ag baelḵadp̱a amu dilagp̱a aoṯebte? O iiṯa danab ah gumadṯeb ele, ag amu dilagp̱a aoṯebte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","Nug anam a amu Petrus nug aum. “Ag gumadṯeb dilagp̱a aoṯeb,” awa aum. Nug anam a amu Jesus Nug oḏep̱a awa aum. “Anam amu ag baelḵad dilagp̱a amu ag takis ii aoṯeb. Da am Kayak beḵa amunu da takis imu ii helom, ");
INSERT INTO gaw_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","amge ag oolag nauhmanu, Petrus na gona, le amegp̱a huk ena, kakai tatam aoḵut amu oḏe haqana, na men doḏo anidḵut. Anidna aon, ihinih takis amup̱a heḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","Haen amup̱a Jesusnu ip̱uniṯak awak danab ag Jesus gumidna uḏin ap̱ig. “Aun am Kayaknu ḏo maḏoḏ oop̱a oḵai daaṯe?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","Aeg amu Jesus Nug nid nakok laa onigp̱a e, nug do Jesus me, nug ag oolagp̱a hibaiṯa dayeye, ");
INSERT INTO gaw_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","Nug aum. “Da genab aṯem, ag oolag ii eḏueb, ag nid naunau ag mamelḵad waalagp̱a daaṯeb bia Kayak waap̱a ii daaglag amu ag Kayaknu ḏo maḏoḏ oop̱a ii nomana. ");
INSERT INTO gaw_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","Amunu laa nug onig qeeb neeb oiḵu, nid nakok imubia amu, nug Kayaknu ḏo maḏoḏ oop̱a, laa oh eḏaṯak daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","Amu ele, danab aun nug da onilnu nid nakok imubia laa oo meṯa humidṯe amu nug da aaḵu oo meḏa humiḏṯe. ");
INSERT INTO gaw_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","Amge danab laa nug nid nakok laa, nug dahilnu oop̱a genab dooṯe ele amu, nuhig oop̱a genab doyak aib heeb nauhom. Nug anam heḵu am naunab. Nug ii heum haenp̱a danab ag nug baagp̱a men qaḵan, maop̱eg yup̱a noa mauhlo amuam nakok nau amge nug dayaya, nid nakok laanu oop̱a genab doyak heeb nauhḵu, amuam naunab nau. ");
INSERT INTO gaw_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","Wan imup̱an danab ag laala hip̱unin heḵulagnu eeḏadṯeb amu ahilagnu gadonnab. Kobol amuam genabnab daaṯe amge danab nug anam heṯe amu nuhignu am gadonnab. ");
INSERT INTO gaw_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","Amunu na ep̱en o baen nug he, na hip̱unin heṯem dayeb amu na ep̱en o baen laih amu oḵulna maop̱e uḵaḏ! Na baen o ep̱en laihigib ele daanna, na haen oh bauklel daaḵut amuam ena. Amge na ep̱en o baen aḏit oh ele daaḵut, amu ag na mawidp̱eg, ab aḏu ii qauhṯe ele amup̱a goḵut am ena iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","Amubia na amen nug he, na hip̱unin heṯem dayeb amu na amen laih kehan, maop̱e uḵaḏ! Na amen laihigib ele daanna, na haen oh bauklel daaḵut amuam ena. Amge na amen aḏit ele daaḵut amu na mawidp̱eg, ab aḏu ii qauhṯe ele amup̱a goḵut am ena iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","Jesus Nug anam anana amu Nug aum. “Ag dab mena autna aweg! Da ag amelagp̱a inam aṯem. Nid naunau dilag engel ag haen oh da Mamel, hab aṯan daaṯe ele amu, Nug noobp̱a daanna, ag atog noadṯeb amunu ag nid naunau dilag amu, ag am keeke hamu aib doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","Aḏinu? Danab Beḵalag da amu da danab hip̱uninp̱a padal mep̱ig amu, ag eḏue diiadḵulnu uḏimi. ");
INSERT INTO gaw_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","Am ag aṯem dooṯeb? Danab laa nug sipsip wan handat ele, am laip̱u laa nug nuḵa mataḵa wana oiyaya, padal meeb amu sipsip mamelag nug nainti nain uuaṯeb, qaukop̱a daap̱eg, nug uḵa, laip̱u amu maṯia, wan dugdug qauko ta nana amu geutet oop̱a ele iite maṯima? Genab nug nainti nain amu uuaṯeb daap̱eg, laip̱u amu madiḵu. ");
INSERT INTO gaw_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","Da genab ag amelagp̱a aṯem, nug maṯia anṯa amu oo gamag ahak nainti nain dilag amu eḏiṯak, laip̱u amunu am gamag ahak oḵainab aoḵu. ");
INSERT INTO gaw_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","Anam amu, da Mamel, hab aṯan daaṯe ele amu, Nug nid nakok laa padal meḵunu oo ii daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","Amu laa ele, na layap nug nahipnu eheḏ heeb amu na gop̱e, a aya daaiya, nuhig eheḏ hak amu ip̱unidḵut. Ip̱unidp̱e, nug nahip nai dooḵu amu nug na layap daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","Amge nug nahip nai ii doyeb amu na Kayak naip̱a nai daaṯe, amubia heḵutnu amu na danab laip̱u o aḏit baula ele diiatp̱e, na ele gona nai maṯieg! Kayak naip̱a nai amunu daaṯe am inam. ‘Danab aḏit o iiṯa danab ewam ag danab laa eheḏ heum ap̱eg am nai amunu am genab doyeg! Laip̱uib ab am genab bia aib doop̱ig.’ ");
INSERT INTO gaw_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","Aria ag nai madip̱eg, nug amu dilag nai ele doyak uueb am na Kayaknu tamaniak amelagp̱a aḵut. Ap̱e, amu ele nug ii doyeb amu na nuhignu, nug am Kayaknu tamaniak oop̱a ii daaṯe, nug am dimiṯim danab, anam doye! ");
INSERT INTO gaw_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","Da genab ag amelagp̱a aṯem, keeke ag wanp̱a qaḵaglag amu Kayak Nug hab aṯan ele qagaḵu. Aria keeke ag wanp̱a uhuqḵulag amu Kayak Nug hab aṯan ele uhuqḵu. ");
INSERT INTO gaw_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","Amunu da genab ag amelagp̱a aṯem, ag oh daaṯeb imu, ag oolagp̱anu aḏit laa keeke laanu oolah laip̱u meya, Kayak amegp̱a apeḏ amu Kayak, hab aṯan daaṯe ele, Nug madaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","Ao, danab aḏit o ewam aaḵuib ag da onilnu, aben adeḵup̱a qag meḵulag amu da ele ag oolagp̱a daaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","Nug nai amu maṯia male amu Petrus nug Jesus gumiṯa doa aum. “Naḏi, da layal nug dahilp̱a hip̱unin heeb amu da hip̱unin nuhig gane batak uhuqen medaḵul? Da haen eblaih aḏit ele uhuqen medaḵulte?” awa oḏ meṯa aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","Petrus nug anam a amu Jesus amegp̱a aum. “Eblaih aḏit batak iiṯa. Na amu eḏiṯak haen ohp̱a uhuqna meṯe! ");
INSERT INTO gaw_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","Anam amunu Kayaknu ḏo maḏoḏ nug am king laa bia, nug nuhiḵud uḏat danab ele nuhig daden nob eḏuglagnu dab mak awom. ");
INSERT INTO gaw_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","Dab mak awa, uḏat amu dig meum. Dig me amu nuhig uḏat nid laa nug beḏup̱a 10 milion kina ele daden nob dayom ");
INSERT INTO gaw_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","amge nug nob eḏuḵunu elele iiṯa. Amunu king nug nuhiḵud daup ag danab amu, ah nuhig, nug beḵod amu nuhig keeke oh ele e oḏiak abenp̱a maadp̱eg, danab laala ag daden mep̱eg, king nug amup̱a nob eḏua aoḵun aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","Nug anam aum amunu uḏat danab amu nug danab oḵai noobp̱a gateg qaun wa, amegp̱a aum. ‘Na dahilnu oot doyeb, amel meḵutnu unuqidṯem. Da nahip daden nob oh eḏue medaḵul!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","Awa a amu danab oḵai nug nuhig begbeg danabnu oo doye, nuhig nob oh uhuqa meṯom. Uhuqa meṯowa, nug he uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","Amge uḏat danab amu nug noa ugaḵa, ibp̱a nuhig uḏat laip̱u laa anṯom, layag amu nug nuhig daden nob 100 kina ele aaḵuib. Aria anṯa nug layag baagp̱a aḏa, amegp̱a aum. ‘Na dahil daden nob meḏe,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","Awa a amu nuhig uḏat laip̱u nug gateg qaun wa, layag amegp̱a aum. ‘Na dahilnu oot doyeb, amel meḵutnu unuqidṯem. Da nahip daden nob oh eḏue medaḵul,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","Awa aum amge laa nug uua, omala uḵa, mani guiṯak oop̱a me dayeye, nuhig daden nob oh eḏua meṯowa, nug eḏua dimiṯim doḵunu aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","Nug anam he, laiḵud uḏat laip̱u ag kobol amu anidna, ag oolag nauhom. Nauhe, ag oh gona, ahilag oḵai noobp̱a nai amu oh madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","Ag maṯieg amu danab naḏi nug uḏat danab amu onigp̱a e uḏie, nug aum. ‘Na uḏat danab nau! Tatam na dahilp̱a gaame amu da nahip ug oh da uhuqen meṯami. ");
INSERT INTO gaw_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","Da nahipnu ool doyom am aḏinu na layapnu oot ii doyom?’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","Aria danab naḏi nug op̱oḏi be, nug danab amu mani guiṯak gumak danab ep̱elagp̱a ma, nug anam dayaya, danab oḵainu daden nob oh eḏua meṯowa, nug eḏua dimiṯim doḵunu aum. ");
INSERT INTO gaw_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","Anam amunu ag lailagnu eheḏ hak uhuqna ii medap̱eg amu da Mamel, Nug hab aṯan daaṯe amu, Nug ele ahilagp̱a anamib heḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","Jesus nai maṯia mala, Nug aha Galelia uua, Juda wan laa Jodan le laih dayom ele amu, ap̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","Jesus ugeḵe, danab ah ameg naḏi ag Nug dim lamidna uḵaeg, Nug aben amup̱a oḏe danab bap̱alaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","Nug bap̱alaṯeṯe, ḏo gumak danab-Parasia ag Jesus aḏaglagnu ib anidḵulagnu Nug gumidna uḏin, inam oḏ medap̱ig. “Ihinig ḏop̱a danab nug oo ug ohp̱a ah nuhig lamiṯeb goḵu am enate o ena iiṯate?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","Aeg amu Jesus Nug nob ma aum. “Ag Kayak naip̱a nai iite eb qep̱ig? Nai amuam inam. ‘Anuḵanab Kayak Nug Adam Ewe ele hatom amu Nug laa am ah, laa am danab hatom.’ ");
INSERT INTO gaw_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","Nug anam hatowa amu Nug aum. ‘Da a ah danab ele hatmi amunu danab nug anig mameg ele uuata, nug wau ele ou qeya, aḏit amu a beḏulah laip̱u daaglah.’ ");
INSERT INTO gaw_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","A anam heya, a baula aḏit iiṯa. A amu beḏulah laip̱u. A laip̱u amunu keeke Kayak nuḵa matulatom amu danab laa nug aib otaḏom.” ");
INSERT INTO gaw_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","Jesus Nug anam a amu ḏo gumak danab-Parasia ag amegp̱a ap̱ig. “Na anam aṯem amge aṯemun Moses nug ihinigp̱a ḏo laa meum amu ḏo amup̱a danab nug wau lamidḵunu oo dayeb amu nug nai amu uḏugp̱a ya, wau meṯowa, lamiṯeb goḵu?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","Anam aeg am Jesus Nug aum. “Ag am oo doyak ele ii dooṯeb amunu Moses ag ah ug oḵai maṯamnanu, ag hamu lamadmananu, nug ḏo anam meum. Amge anuḵa dig mak haenp̱a kobol amu ii dayom. ");
INSERT INTO gaw_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","Amunu da ag amelagp̱a inam aṯem. Danab laa, nug wau gap̱ai kobol ii heum amge gamu nug ah amu hamu lamiṯowa, nug ah bau aoṯe amu, danab amu nug aaḵu gap̱ai kobol heṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","Jesus Nug anam maṯie amu nuhiḵud ip̱uniṯak awak danab ag Nug amegp̱a ap̱ig. “Ewau otaḏaknu kobol nug anam daaṯe dayeb amu danab nug ah ii aoḵu am ena,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","Ag anam aeg, Jesus Nug aum. “Danab oh ag amu dim lamidḵulagnu elele iiṯa. Laala ag anam heḵulagnu g̱agaṯag aop̱ig ele amu, ag am heḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","Am genab, danab laala ag beḏulagp̱a kobol laala daaṯe amunu ag ah ii diiṯeb. Laala ag anilḵad oolagp̱a dona maṯoi daaṯeb. Laa danab ag heeg maṯoi daaṯeb. Laa ag Kayak uḏatnu hena, beḏulag hagaḵa aona, ah ii aoṯeb. Anam daaṯe amunu amu laa nug nai amu dim lamidḵunu elele dooṯe am nug dim lamidḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","Haen amup̱a ag nid naunau laa omaladna, Jesus Nug ep̱eg beḏulagp̱a ma unuqidḵunu, Nug gumidna uḵaeg amu ip̱uniṯak awak danab ag nid anilḵad mamelḵad, ag nid diin gop̱ig ele amu, aladp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","Alaṯeg am Jesus Nug aum. Danab ag nid naunau bia daaṯeb, ag am Kayaknu ḏo maḏoḏ oop̱a daaṯeb amunu ag nid naunau uuadp̱eg, dahilp̱a doig! Ag ib ahilag aib oo nep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","Anana amu Nug ep̱eg ag qaḏelagp̱a mewowa, dimp̱a Nug aben amup̱an aha, laih uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","Aria danab laa Jesus gumiṯa uḏia aum. “Ip̱uniṯak danab ena, da bauklel hanhannu aoḵulnu amu da kobol ena aḏinab heḵul?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","A amu Jesus Nug aum. “Na aḏinu da keeke enanu oḏ meḏaṯem? Laip̱u aaḵuib Nug am ena amunu na bauklel aoḵutnu amu na ḏo nuhig dim lamidḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","Anam a amu danab amu nug aum. “Aḏi ḏo dim lamidḵul?” awa aum. A amu Jesus Nug aum. “Na danab aib qep̱e mauhom. Na gap̱ai kobol aib heme. Na yabhoi aib heme. Na danab laanu ham bup̱uak nai aib maṯime. ");
INSERT INTO gaw_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","Na anin mamen ele oḏelah dim lamidna, binalah me! Na naḵa nahipnu oot mauhṯe amubia na laipad laa dilagnu ele oot mauhaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","Awa a amu nid bau aum. “Da nid nakokp̱anu ḏo amu dim lamiṯi uḏie, gemu ele heṯem amge da aḏi laa heḵul?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","A amu Jesus Nug amegp̱a aum. “Na danab tutuḵu elelenab beḵutnu amu na gona, na enun oh mep̱e, danab laala daden mep̱eg, na men doḏo amu oh aon, daḏek danab maṯona amu na hab aṯan enun oḵai ele daaḵut. Anam hewona amu na dona, da dim lamiḏe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","Awa a amu nid bau amu doya, nug oo ugnab ele uḵom. Aḏinu? Nug enub kuḏum ele. ");
INSERT INTO gaw_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","Jesus Nug anam maṯiowa, nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Da genab ag amelagp̱a aṯem, danab nug enub kuḏum ele amu nug Kayaknu ḏo maḏoḏ oop̱a noḵunu ug oḵai ele. ");
INSERT INTO gaw_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","Da baula ag amelagp̱a aṯem, doḏ onig kamel, nug lamen koitaknu tutui giḏop̱a noḵunu amu uḏat oḵai amge danab enub kuḏum ele, nug Kayaknu ḏo maḏoḏ oop̱a goḵunu, amuam uḏat oḵainab ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","Jesus Nug anam a amu nuhiḵud ip̱uniṯak awak danab ag dab mak huanak aop̱ig. Ag anam henana ap̱ig. “Anam dayeb amu aun nug bauklel aoḵunu elele?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","Ag anam aeg amu Jesus Nug ag tutuḵu neeḵaṯaṯa, amelagp̱a aum. “Danab ag aḵa elele iiṯa amge Kayak Nug keeke oh heḵunu elele.” ");
INSERT INTO gaw_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","Jesus Nug anam a amu Petrus nug oḏep̱a awa aum. “Anṯe, ig ihinig keeke oh uuta, na dim lamidṯem amunu ig aḏi ihinignu aognig?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","Nug anam a amu Jesus Nug eḏua, ag oh amelagp̱a aum. “Da genab ag amelagp̱a aṯem, keeke oh bau bak haenp̱a, Danab Beḵalag da, da onil binal naḏi ele dayaknu balal kobol ele dahilp̱a daap̱p̱i, ag da dim lamiḏṯeb ele ag dayaknu balal tuelpp̱a daanna, Israel ameg tuelp amu gumadḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","Aria danab aun nug da onilnu ha, nug anig, mameg, awag, ap̱inag, nug wau, beḵod, aḏeḵud, nug laug amu nuhig dad ele uuaṯa, da dim lamiḏṯe amu, nug hamu ii daama. Iiṯa, nug nob ena wan handat baula ele awa, nug bauklel hanhannu ele aoḵu. ");
INSERT INTO gaw_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","Amge danab kuḏum anuqak daaṯeb amu ag dim daaglag. Am kuḏum laa ag dim daaṯeb amu ag anuqḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","Aria Jesus Nug nai tuḏiṯa aum. “Kayaknu ḏo maḏoḏ am imubia. Danab nug wan oḵai ele, nug buṯuanab aha, e oḏiak abenp̱a uḏat nid ag deḏ amup̱a uḏat aoglagnu daaegeg anaṯa amu nuhig wain dadp̱a uḏat heḵulagnu diiom. ");
INSERT INTO gaw_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","Ag deḏ laip̱unu uḏatnu daden 5 kina aoglagnu oolag laip̱u mena, uḏat heḵulagnu maaṯe gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","Aria 9 kilok keeke nug eḏua uḵa, danab laala ag e oḏiak abenp̱a hamu hip̱aidna daaegeg anaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","Nug anaṯa, ag amelagp̱a aum. ‘Ag ele gona, wain dad dahilp̱a uḏat hep̱eg, da daden tutuḵu madaḵul,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","Nug anam a, ag gop̱ig. Aria aam ameg tutuḵup̱a, aam ameg ewamp̱a ele nug eḏua uḵa, anamib heum. ");
INSERT INTO gaw_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","Amu tueb, aam ameg tanig ele keeke nug eḏua uḵa, uḏat danab baula ele hip̱aidna daaegeg anaṯom. Anaṯa am nug aum. ‘Ag aḏi diignu deḏ laip̱u oh hamu daaeg uḏie, tueb meum?’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","Anam a amu ag nai nob mena ap̱ig. ‘Danab laa nug ig uḏat laa ii meḵom,’ aon ap̱ig. Ag anam aeg, nug ag amelagp̱a aum. ‘Ag ele wain dad dahilp̱a gona, uḏat heig!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","Aria uḏat haen iiṯa me, dad mameg nug uḏat amu gumak danab onigp̱a e uḏie, amegp̱a inam aum. ‘Na uḏat nid onilagp̱a ep̱e uḏip̱eg, ahilag uḏat nob daden maṯe! Madaḵut amge laa dim dop̱ig, amu dilagp̱a dig mena, daden madap̱e uḵeb, tatam dop̱igp̱a bate!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","Dad mameg nug anam a amu uḏat danab ag aam ameg tanig elep̱a uḏat dig mep̱ig ele amu, ag 5 kina aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","Anamib uḵe uḵe, danab ag buṯuanab tatam dig mena hep̱ig ele amu, ag dona amu ag oolagp̱a ap̱ig. ‘Ig am daden oḵai aognig,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","Amge iiṯa. Ag ele 5 kinaib aop̱ig. Ag anam aona amu ag dad mameg aidna, ");
INSERT INTO gaw_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","inam ap̱ig. ‘Danab umu amu ag dimnab dop̱ig, ag aam ameg laip̱uib uḏat hep̱ig am na ahilag uḏat nob daden amu ihinig ele melemel laip̱u maṯame. Amge ig am buṯuanab uḏat dig meta, uḏat huanak heutut, aam ele huanak iqom,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","Aon aeg am dad mameg nug oḏelagp̱a awa, ag oolagp̱anu laip̱u laa amegp̱a nai inam aum. ‘Layal, da nahipnu eheḏ laa ii hemi. Da na ele uḏat nob dadennu oonih laip̱u iite memuḏ? ");
INSERT INTO gaw_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","Nahip daden aon uḵe! Daden da na meṯami anamib da danab dimnunab imu ele madaḵulnu ool daaṯe,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","Nug anam anana amu nug tuḏiṯa aum. ‘Da dahil keekep̱a, keeke laala heḵulnu ool dayeb amu da heḵulnu elele iiṯate? O iiṯa da danab imu laa oh ehanadḵulnu heṯem amu na amunu na oot nauhṯete?’ awa aum.” Jesus Nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","Jesus Nug anam anana amu Nug nai tuḏiṯa aum. “Amubia dim daaṯeb amu ag anuqḵulag. Anuqak daaṯeb amu ag dim daaglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","Jesus nai anam maṯiowa, aha Jerusalem ugeḵe, danab laala ele oh gop̱ig. Ag ibp̱a uḵaegeg Jesus Nug nuhiḵud ip̱uniṯak awak danab tuelp diia, piḏe wana, agib amelagp̱a nai inam maṯia aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“Doyeg, ig gemu iiḵu Jerusalem goṯem. Gop̱ut, laa nug Danab Beḵalag da, mana meṯak danab oḵai amu ḏo mehuqak danab ele ag ep̱elagp̱a meiḏeb, ag da heṯoḏiakp̱a meiḏna, iup̱eg mauhḵulnu nai qaḵaglag. ");
INSERT INTO gaw_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","Nai qaḵana, ag iiṯa aḏi ep̱elagp̱a meiḏḵulag. Meiḏp̱eg, ag aon aon iuna, wipp̱a eheḏ mataḏilna, ad emaitakp̱a atuliḏḵulag. Ag anam atuliḏp̱eg mauhe, deḏ ewamp̱a da eḏuen hip̱aidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","Haen amup̱a Sebedi wau amu nug bekoḏ, Jakobus Johanes ele, ag Jesus gumidna gona, anilah nug Jesus noobp̱a dup noa, keeke laanu oḏ medaḵunu heum ");
INSERT INTO gaw_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","amu Jesus Nug aum. “Na aḏinu oot heṯe?” awa aum. Jesus Nug anam a amu ah nug Jesus amegp̱a aum. “Na ap̱e amu nid dahilaḏ aḏit imu a nahip ḏo maḏoḏp̱a na heqon laih laih daaglah, laip̱u laa na heqon naḏiapp̱a dayebeb, laa nug na heqon nanehp̱a daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","Anilah nug anam a amu Jesus Nug aum. “Ag aṯeb amu ag keeke amunu tutuḵu ii dooṯeb. Keeke laa, keeke amuam le mua bia, a le mua amu da laḵul amubia laḵulahnu elelete?” awa aum. Nug anam a amu a amegp̱a apiḏ. “I am elele,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","Anam aeh, Jesus Nug amelahp̱a aum. “Genab, le mua ele da laḵul bia amu a laḵulah amge aun nug da heqol naḏiapp̱a daaḵu, aun nug da heqol nanehp̱a daaḵu amu da aḵulnu elele iiṯa. Da mamel Nug aben aḏit amu aunnu babaiṯom amu a aaḵuib amup̱a daaglah,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","Ag anam maṯiegeg, ip̱uniṯak awak danab eblaih tanig ele ag nai amu doona, ag eamag dilah oolag nauhe alatp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","Alatp̱ig amge Jesus Nug ag onilagp̱a e doeg, Nug ag amelagp̱a aum. “Ag dooṯeb. Wan imunu danab ah ag danab oḵai waalagp̱a daaṯeb amu oḵai danab ag ḏo aḏi meṯeb amu danab ah ag amuib dim lamidṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","Amge kobol amu ag oolagp̱a aib dayom. Iiṯa, danab nug ag oolagp̱a oḵai daaḵunu oo dayeb amu nug ahilag ehaniṯak danab dayaḏ! ");
INSERT INTO gaw_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","Amu ele danab laa nug ag oolagp̱a anuqak daaḵunu oo dayeb amu nug ahilag begbeg dayaḏ! ");
INSERT INTO gaw_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","Yo, nug Danab Beḵalag da, da heṯem amubia haḏ! Am inam. Danab Beḵalag da amu, da wan imup̱an danab ah ag da ehaniḏḵulagnu ii uḏimi. Iiṯa, da ag ehanadḵulnu uḏimi amu dahil mauhakp̱a danab ah kuḏum ag bauklel hanhannu aoglagnu ele uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","Jesus Nug nai amu maṯia male, ag ahan Jeriko ab daugp̱a uḵaegeg, danab ah kuḏum ag Jesus dim lamidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","Ag anam dim lamiṯegeg, danab aḏit laa, amelah gaḏuak ele, a ib daugp̱a daaiya, a Jesus ib amup̱a uḏiṯe dooya, a huanak eya apiḏ. “Naḏi, na Dawit Beḵa, na ihinihnu oot gai iiṯa doye!” aoya epiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","Anam eeh amu danab ah kuḏum ag a alatna, “A oḏelah qamuteḏ!” ap̱ig amge a baula huanak eya apiḏ. “Naḏi, na Dawit beḵa, na ihinihnu oot gai iiṯa doye!” ");
INSERT INTO gaw_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","A anam eeheh amu Jesus Nug hibaiṯa dayaya, amelahp̱a aum. “Da ahilahp̱a aḏi heḵulnu oolah daaṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","Nug anam a amu a oḏep̱a aoi apiḏ. “Naḏi, na hep̱e i neegḵunihnu oonih daaṯe,” apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","Anam aeh amu Jesus Nug ahilahnu oo doye, Nug ep̱eg a amelahp̱a me, geha aaḵunab a amelah obate, neegya ahaya, Jesus dim lamidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","Aria ag gona, Jerusalem guḵuidna, ag Betpasi, ab amu olipnu qaukop̱a dayom, ag ap̱a tena, Jesus Nug ip̱uniṯak awak danab aḏit laa maate goḵulahnu daaeheh, ");
INSERT INTO gaw_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","Nug amelahp̱a aum. “A goya, ab nakok miag amup̱a teya, neegya amu a pahanab donki laa, muḏip̱a qaḵak, amu nag, nakok oḵai meum, amu ele daap̱eḏ anatḵulah. Anatya amu a uhuqatya, diiatya dahilp̱a uḏieḏ! ");
INSERT INTO gaw_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","A anam hebepeḏ amu danab laa nug anata, nai laa ab amu a inam aiḏ! ‘Naḏi Nug ahilahp̱a uḏat ele!’ Anam apeḏ amu nug pahanab maṯeb, a diiatya uḏiglah,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","Aria keeke amu oh am propet nai laa maṯiom, nai amu elele medaḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","Nai amuam inam. “Ag Sionnu danab ah amelagp̱a inam aig! ‘Anṯeg! King ahilag Nug ahilagp̱a uḏiṯe. Nug danab maḏoḏ ele amu Nug donki aṯan dayaya uḏiṯe. Nug donki nag, nakok oḵai meum, amu qaḏep̱a daaṯe.’” ");
INSERT INTO gaw_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","Aria Jesus Nug a amelahp̱a aum amu, ip̱uniṯak awak danab aḏit a goya, Jesus aum amubia Nug oḏe dim lamidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","A donki anig, nag nakok oḵai meum, amu ele diiatya uḵaeh, ag lamen ulahnu donki qaḏelahp̱a duqap̱ig. Duqaeg amu Jesus Nug donki qaḏep̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","Am danab ah kuḏum ag ele lamen ulahnu ahilḵad ibp̱a duqadp̱ig. Duqaṯegeg, danab ah laala ag ad ep̱eg oḵulna, ibp̱a duqap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","Ag anam duqegeg, Jesus ugeḵe amu danab laala ag anuqna, Jesus noob aon gonana, laala ag dim lamidnana, amu ag oh enan ap̱ig. “Ig Dawit Beḵa onig humatu! Danab imu Nug Kayak onigp̱a uḏiṯe, Kayak Nug itidṯe. Kayak, Nug aṯan daaṯe ele amu, ig Nug onig humatu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","Danab ah ag anam eegeg, Jesus Nug Jerusalem ab oop̱a no, danab ah ab oḵai amu oop̱anu ag huanak oṯaina ap̱ig. “Danab umu am aun?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","Ag anam oḏ meeg amu danab ag Jesus omalp̱ig ele amu ag ap̱ig. “Nug amu Jesus, Nug am propet, Nug ap̱ag diig am Nasaret, Nug Galelia danab,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","Danab ah ag anam maṯiegeg, Jesus Nug mana meṯak lag oop̱a noa, Nug danab lag amu oop̱a mana meṯak keeke dadennu maadp̱ig, laala daden mep̱ig ele, Nug ag lamaṯom. Ap̱an danab laala ag men doḏo baolip̱ig ele amu Nug ahilag balal huma awe, uḵa na qe, am laala ag up̱uḏil meeg, daden madap̱ig ele am ahilag dayak aben ele huma awe, uḵa na qeum. ");
INSERT INTO gaw_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","Jesus Nug anam hewowa, Nug aum. “Kayak naip̱a yak inam daaṯe. ‘Da laul am unuqiṯak lag,’ amge ag heeg, nug yabhok danab dilag loḵumak aben bia daaṯe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","Jesus mana meṯak laḵa dayeye amu danab laala ag amelag gaḏuak amu baelag nau ele ag Nug gumidna uḏieg, Nug bap̱alaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","Amge mana meṯak danab oḵai amu ḏo mehuqak danab ele ag Jesus kobol enanag heum anidna, nid naunau ag oolag gamag ahe, mana meṯak lag oop̱a muṯub qenana, “Ig Dawit beḵa onig humatu!” enan ap̱ig ele anidna amu mana meṯak danab oḵai amu ḏo mehuqak danab ele ag oolag nauhe, ");
INSERT INTO gaw_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","Nug oḏ medap̱ig. “Na nid naunau aḏitai aṯeb umu dooṯemte?” aon ap̱ig. Aeg amu Jesus Nug amelagp̱a aum. “Da dooṯem amge ag nai laa daaṯe ele amu ag iite eb qep̱ig. Nai amuam inam. ‘Na he, nid naunau amu nid yuḏ huhp̱anu ele ag na binan enanag humaṯeb.’” ");
INSERT INTO gaw_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","Nug anam anana, aha uuaṯa, ab oḵaip̱anu dimiṯim uḵom. Nug uḵa, tuqan amup̱a Betani ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","Waḵaḏe buṯua Jesus Nug aha, eḏua ab oḵaip̱a ugeḵe, enug qeum. ");
INSERT INTO gaw_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","Nug enug qe, ad pig laa ib daugp̱a dayeye anṯa, meu laḵunu waum amge meu laa ii anṯom. Iiṯa, uḏugib anṯom. Anṯa amu Nug ad amu amegp̱a inam aum. “Na baula meut ii omana! Iiṯanab iiṯa,” awa aum. Anam a ad pig nug pahanab bunaḏom. ");
INSERT INTO gaw_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","Ad nug bunaḏe amu ip̱uniṯak awak danab ag anam anidna, ag eheḏ oṯaina ap̱ig. “Aṯem he, ad pig nug pahanab bunaḏom?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","Ag anam aeg, Jesus Nug oḏelagp̱a awa aum. “Da genab ag amelagp̱a aṯem, ag oolagp̱a genab doonna, dab mak laip̱u ele daanna amu ag ele da ad pigp̱a hemi amubia heḵulag. Am ag keeke amuib ii hemana. Iiṯa. Ag qauko imu amegp̱a, ‘Na ahan yup̱a no!’ ap̱eg amu nug anam noḵu. ");
INSERT INTO gaw_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","Amu ele ag oolagp̱a genab doonna unuqidḵulag amu ag keeke aḏi aḏi aoglagnu unuqidna amu ag aoglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","Amu dimp̱a Jesus Nug mana meṯak laḵa noa, danab ah amelagp̱a nai maṯieye, mana meṯak danab oḵai amu Juda iḵi danab ele ag Jesus gumidna gona, oḏ meṯan ap̱ig. “Na g̱agaṯag aḏip̱a uḏat imu heṯem? Aun nug g̱agaṯag amu meṯom?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","Ag anam aeg amu Jesus oḏelagp̱a awa aum. “Da ele ag keeke laip̱unu oḏ madaḵulnu heṯem. Da ag oḏ madap̱i, oḏ mak dahil imu nob meḵulag dayeb amu da g̱agaṯag aḏip̱a uḏat heṯem amu ap̱i dooglag. ");
INSERT INTO gaw_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","Oḏ mak dahil am inam. Johanesnu layaṯak am adep̱anu beum? Keeke amuam hab aṯannu keeke o iiṯa amu danabnu keekeib?” awa aum. Jesus Nug anam a, amu ag aḵa aḵa nai maṯin ap̱ig. “Ig, ‘Habnu keeke,’ ap̱ut amu Nug, ‘Anam amunu ag aḏinu oolagp̱a genab ii dop̱ig?’ aḵu. ");
INSERT INTO gaw_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","Amge ig, ‘Danabnu keeke,’ aḵunig amu danab oh, ag Johanesnu, nug am propet dooṯeb amunu ig ahilagnu baḏṯem,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","Ag anam anana amu ag Jesusnu nai nob eḏun, “Ig ii dooṯem,” aon ap̱ig. Aeg amu Jesus Nug aum. “Aaḵu amunu da ele g̱agaṯag aḏip̱a uḏat heṯem amu ap̱i ii doomna,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","Jesus Nug nai anam maṯiowa, nai baula ele tuḏiṯa, mana meṯak danab oḵai amu ab gumak danab ele amelagp̱a aum. “Ag aṯem dooṯeb? Danab laa nug nid aḏit ele amu, nug aha uḵa, nid tatamnu amegp̱a, ‘Na gona grep dad dahilp̱a uḏat he!’ awa a amu nug, ");
INSERT INTO gaw_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","‘Da uumi,’ awa aum amge dimp̱a nuhig dab mak eḏue nug uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","Aria mamelah nug nid gehanu amu gumiṯa uḵa, anamib aum. A amu beḵa gehanu nug, ‘Da uḵen heḵul,’ aum amge ii uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","Am nid aḏit amu oolahp̱a aun nug mameg oḏe dim lamiṯom?” awa aum. A amu ag ap̱ig. “Nid tatamnu,” aon ap̱ig. Ag anam aeg am Jesus amelagp̱a aum. “Da genab ag amelagp̱a aṯem. Takis awak danab amu ib baag ah ele ag tatam Kayaknu ḏo maḏoḏ oop̱a noṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","Aḏinu? Johanes nug uḏia, mana meṯak danab oḵai amu ab gumak danab ele ahilagp̱a kobol tutuḵu ip̱uanaṯom amge ag oolagp̱a genab ii doop̱ig. Takis awak danab amu ib baag ah ele ag amu oolagp̱a genab doop̱ig. Oolagp̱a genab doyeg, mana meṯak danab oḵai amu ab gumak danab ele ag amu anidp̱ig amge ag oolag eḏue, oolagp̱a genab ii doop̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","Jesus baula ele amelagp̱a aum. “Ag keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯak nai imu baula doyeg! Danab laa nug wan ele amu nug grep dad ep̱owa, aḏ ita, dad oop̱a amu nug grep lep̱u awaknu aben laa ha, nug dad gumak danabnu lag elab laa ele heum. Aria nug uḏat amu oh ha mala, nug dad amu uḏat hak danab ep̱elagp̱a mewowa, nug aha, atu laih umanab uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","Dimp̱a grep meu awak haen miag do, nug nuhiḵud begbeg danab laa maaṯe, ag grep meu nuhig aoglagnu uḏat hak danab gumadna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","Ag uḵaeg amu dad uḏat hak danab ag nuhiḵud begbeg danab amu diin, laa maḵuḏna, laa amu qeeg mauhe, laa amu menp̱a maḵuḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","Ag anam heeg amu dad mameg nug nuhiḵud begbeg danab laala baula maaṯe gop̱ig. Nug tatam maaṯe gop̱ig amubia iiṯa, nakok kuḏum maaṯe gop̱ig. Uḵaeg, dad uḏat hak danab ag tatam hep̱ig anamib eḏun hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","Dimp̱a dad mameg nug, ‘Da beḵal amu ag nug oḏe dooglag,’ anana, nug beḵanab me uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","Amge dad uḏat hak danab ag nid amu anidna, aḵa aḵa nai maṯina ap̱ig. ‘Nid imu nug dimp̱a mamegnu keeke oh aoḵu amunu ahap̱eg, ig qep̱ut mauheb, ig dad nuhig imu aotu!’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","Ag anam anana, ag nid amu aḏana, maoeg dad dimiṯim no, ag qeeg mauhom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","Jesus anam anana, Nug nai tuḏiṯa oḏ maṯom. “Aria ag aṯem dooṯeb? Dimp̱a dad mameg nug uḏia, dad uḏat hak danab aṯem hadḵu?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","Jesus Nug anam a amu ag ap̱ig. “Nug uḏat danab nau amu aqeb mauhḵulag. Mauhp̱eg, amu nug grep dad amu eḏua awa, dad gumak danab laa ep̱elagp̱a meeb, dimp̱a ag meu ena aon meṯaglag,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","Aeg am Jesus Nug amelagp̱a aum. “Ag Kayak naip̱a nai laa daaṯe amu ag iite eb qep̱ig? Nai amuam inam. ‘Men laa amu lag hak danab ag men amu uup̱ig amge lag mameg nug men amu awa me, lagnu men anuqak daaṯe. Naḏi Nug keeke amu he beum amu ig amenigp̱a anidta oṯaiṯem.’ ");
INSERT INTO gaw_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","Amunu da ag amelagp̱a aṯem. Kayak Nug nuhig ḏo maḏoḏ ahilagp̱anu amu awa, danab ab iḵi laa ep̱elagp̱a meeb, ag meu ena aon meṯaglag. ");
INSERT INTO gaw_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","Am laa nug men amu aṯan na qeḵu amu nug nakok nauhḵu amge men amu nug laa qaḏep̱a na qeḵu amu nug nauha auta aoḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯak nai laala maṯiom amu mana meṯak danab oḵai amu ḏo gumak danab-Parasia ele ag Nug ahilagnu nai maṯiom doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","Ag anam doona, aḏaglagnu ib madip̱ig amge danab ah ag Jesusnu, Nug am propet laa doop̱ig amunu ag Nug aḏaglagnu baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","Jesus baula keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“Kayaknu ḏo maḏoḏ nug am imubia. King laa nug beḵa ah aoḵunu heehe, danab oḵai amu nug e naḏi heum. ");
INSERT INTO gaw_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","Nug e hewowa, nuhiḵud begbeg danab laala maaṯe, ag danab oḵai nug anuḵa nug awak hobulnu deḏ maaṯom ele amu, ag onilagp̱a ep̱eg, uḏin hobulp̱a daaglagnu gop̱ig. Gona onilagp̱a ep̱ig amge ag uḵaknu uup̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","Danab ii uḵaeg amu danab oḵai nug begbeg danab baula ele maaṯe goḵulagnu daaegeg, nug amelagp̱a aum. ‘Ag gona, danab aun aḏi da hobulnu deḏ maṯami ele amu amelagp̱a inam ap̱eg dooglag. “Da lanaknu keeke oh bap̱aidmi. Da dahil bulmakau dawai ena titiḏak amu doḏ titiḏak laala ele aqadmi, keeke oh babaiṯak daaṯe amunu ag ah awak hobulp̱a uḏieg,” aon aig!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","King nug anam a, begbeg danab ag gona ap̱ig amge hobulp̱a uḵaknu danab ag uup̱ig. Laa nug nuhig dad uḏatp̱a uḵom, laa amu nuhig men doḏo uḏatp̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","Laala ag anam hep̱ig amge laa oh amu danab oḵainu begbeg danab aḏaladna, maḵuḏadna, aqaeg mauhp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","Am king nug nai anam doya, op̱oḏi huanak be, nug he, nuhiḵud ban hak danab ag gona, danab ag nuhiḵud begbeg aqaeg mauhp̱ig ele amu, ag ohnab aqap̱ig, ag ap̱alag ele lop̱aḏna, manaeg ewa, iiṯa meum. ");
INSERT INTO gaw_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","Aria danab oḵai nug baula nuhiḵud begbeg danab amelagp̱a aum. ‘Nug awak hobulnu e oh am babaiṯak daaṯe amge danab hobul imup̱a daaglagnu deḏ maṯami ele amu ag uup̱ig ");
INSERT INTO gaw_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","amunu ag gona, ib oḏe ohp̱a danab ah anadna ap̱eg, nug awak hobul imup̱a uḏieg!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","King nug anam a, begbeg danab ag ib oḏe ohp̱a gona, danab ah ena, nau ele oh anadna qag maadp̱ig. Qag maaṯeg, nug awak hobulp̱a dayak aben amu am beum. ");
INSERT INTO gaw_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","Aria dimp̱a king nug danab ah qag mep̱ig amu anadḵunu noum. Noa amu danab laip̱u laa nug hobulp̱a dayaknu lamen beḏup̱a ii meum anṯom. ");
INSERT INTO gaw_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","King nug danab amu anṯa amu nug amegp̱a aum. ‘Lai, aṯemun na hobulnu lamen meṯami amu ii mena, lag imu oop̱a neme?’ Nug anam a amu danab amu nug nai iiṯa, to eṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","Nug anam dayeye, king nug nuhiḵud nid amelagp̱a aum. ‘Ag aḏan, ep̱eg baeg ele hip̱alna, maop̱eg dimiṯim gatatup̱a noaḏ! Ap̱a danab ag gaanna, aelag ele kikiḏḵulag,’ awa aum.” Jesus Nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","Jesus Nug anam anana amu Nug nai tuḏiṯa aum. “Ao, Kayak Nug danab ah kuḏum onilagp̱a eṯe amge laip̱u laip̱u tituanadṯe.” ");
INSERT INTO gaw_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","Jesus Nug nai amu maṯia male, ḏo gumak danab-Parasia ag ahan, laih gona, Jesus Nug nai laa ab, ib anidna, Jesus heṯoḏiakp̱a meḵulagnu nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","Ag anam henena, ag ahilḵad ip̱uniṯak awak danab am Herodesnu danab laala ele maaṯeg, Jesus gumidna gona ap̱ig. “Ip̱uniṯak danab, ig dooṯem na am danab tutuḵu, na nai genab amup̱aib danab ah Kayaknu kobol ip̱uanadṯem. Na danab oḵai onig ele o danab onig iiṯa amu na amu dab menan, na nai baolin, ag amelagp̱a ii madiṯem. Iiṯa. Na nai genabib madiṯem ");
INSERT INTO gaw_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","amunu na keeke imu ap̱e doognig. Na aṯem dooṯem? Ig takis Kaisa meṯagnig am ena o ena iiṯa?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","Ag anam ap̱ig amge Jesus Nug ag eheḏ heḵulagnu hep̱ig doya, Nug aum. “Ag am ham bup̱uak danab. Aḏinu da aḏailḵulagnu heṯeb? ");
INSERT INTO gaw_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","Men doḏo takisnu laa ip̱uniḏp̱eg anṯei!” awa aum. Awa a, ag men doḏo laa, onig Danarius, amu aon dop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","Ag amu aon doeg amu Jesus ag oḏ maṯom. “Men doḏo imup̱a amu aun onig doṯog ele daaṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","Jesus anam a amu ag, “Kaisanu,” aon ap̱ig. Ag anam aeg amu Jesus amelagp̱a aum. “Aria ag Kaisanu keeke amu ag Kaisa meṯaglag amge Kayaknu keeke amu ag Kayak meṯeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","Ag Jesusnu nai anam doona, ag dab mak kuḏum aonna, ag Nug uuidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","Deḏ amup̱aib ḏo gumak danab-Sadusi ag Jesus top̱a uḏip̱ig. Danab amu ag, “Danab mauhṯeb amu ag eḏun ii hip̱aidmana,” aon adap̱ig amunu ag Jesus oḏ meṯan ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","“Ip̱uniṯak danab, Moses nug aum. ‘Danab laa nug nid iiṯa ele mauheb amu nug amag, nug awag wau aweb, nid menuglah amge a nid menuglah amu nid amuam danab amunu iiṯa, awagnu daaḵu.’ Moses nug anam yom. ");
INSERT INTO gaw_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","Aria e amaḵud eblaih aḏit ele ag ig oonigp̱a daap̱ig. Ag anam daanna, awalag tatamnu nug ah awa, nug nid iiṯa dayaya mauhom. Mauhe nug amag nug awag wau awom. ");
INSERT INTO gaw_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","Am nug amag amu ele anamib heum. A amalti ele oh anamib heeg uḵe, eblaih aḏit batak amu oh anamib hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","Amu oh dimp̱a ah amu ele mauhom. ");
INSERT INTO gaw_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","Aria eamaḵud amu oh ag ah amu aaḵuib aweg, nug ag waalag dayom amunu eḏua hibaiṯak haenp̱a ah amu nug eamaḵud eblaih aḏit amu ag oolagp̱a aunnab wau daaḵu?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","Ag anam aeg am Jesus Nug oḏelagp̱a awa aum. “Ag am Kayak nai ii doonna, Kayaknu g̱agaṯag amu ele ag ii dooṯeb amunu ag nai augigiak, diig iiṯa madiṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","Amu eḏua hibaiṯak haenp̱a danab ag ah ii diimna, ah ele ag danab ii diimna. Iiṯa, ag engel hab aṯannu bia daaglag. ");
INSERT INTO gaw_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","Amge eḏua hibaiṯak amunu amu ag Kayak naip̱a, nai laa Kayak Nug ag dooglagnu Moses amegp̱a maṯie, nug yom amu ag iite eb qep̱ig. Nai amuam inam. ");
INSERT INTO gaw_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","‘Da am Abrahamnu Kayak, Isaknu Kayak amu Jakopnu Kayak ele,’ awa aum. Kayak Nug anam aum amunu ig dooṯem, danab ewam amu ag gemu daaṯeb. Ag mauhp̱ig amge ag iiṯa ii mep̱ig amunu Kayak Nug danab daaṯeb dilag Kayak daaṯe. Nug anam daaṯe amunu Nug ele heeb, ag eḏun hip̱aidḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","Danab oh ag qag mena daap̱ig ele amu, ag Nug nai amu maṯie doona, dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","Aria Jesus Nug nai amup̱a ḏo gumak danab-Sadusi oḏelag qamute, ḏo gumak danab-Parasia ag amu doona, ag Jesus aḏaglagnu ib anidḵulagnu qag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","Amu ag oolagp̱a laip̱u laa, nug ḏo oh doyak danab, nug Jesus oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“Ip̱uniṯak danab, ḏo aṯen amu ḏo oh eḏaṯak, nug oḵainab daaṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","Nug anam a amu Jesus amegp̱a aum. “‘Naḏi amu Nug am nahip Kayak, amu na ootp̱a, na ouḏinp̱a, nahip dab makp̱a amu nahip hak ohp̱a ele nuhignu oot mauhaḏ!’ ");
INSERT INTO gaw_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","Ḏo amu am oḵainab, nug anuqak daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","Aria ḏo laa ele amubia daaṯe am inam. ‘Na naḵa nahipnu oot mauhṯe, amubia na danab laa dilag ele oot mauhaḏ!’ ");
INSERT INTO gaw_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","Ḏo aḏit amu a propet dilag nai amu ḏo laa oh dilag tonaṯak daaṯep,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","Jesus Nug anam a, ḏo gumak danab-Parasia ag qag mena daaegeg, Jesus oḏ maṯom. ");
INSERT INTO gaw_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“Ag laa Kayak tituanom, amuam Kristus, nuhignu amu ag aṯem dooṯeb? Aun beḵa amu Kristus?” awa aum. Nug anam a amu ag, “Dawit beḵa,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","Anam aeg am Nug aum. “Anam dayeb amu aḏinu Dawit nug Kayak Ouḏinu ehaniṯak awa, nug, nug beḵanu, ‘Naḏi,’ awa aum? ");
INSERT INTO gaw_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","Nug inam aum. ‘Naḏi Jehowa Nug dahil Naḏi amegp̱a inam aum. Na da ep̱el naḏiap̱a daap̱e uḵeb, da nahip kekeḏ na waatp̱a maadḵul.’ ");
INSERT INTO gaw_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","Ag iiḵud anṯeg! Danab nug, nug beḵanu, ‘Naḏi,’ ii aṯe amge Dawit nug nuḵa, nug beḵanu, ‘Naḏi,’ aum amunu ig aṯemun Kristusnu, ‘Nug am Dawit beḵaib,’ aḵunig?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","Jesus anam oḏ maṯe amu laip̱u laa ag oolagp̱a nai amu nob meḵunu elele iiṯa doop̱ig amunu haen amup̱a dig mak ag Jesus baula oḏ ii medṯap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","Dimp̱a Jesus Nug danab ah ameg oḵai amu nuhiḵud ip̱uniṯak awak danab ele amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“Ḏo gumak danab-Parasia amu ḏo mehuqak danab ele ag Mosesnu ḏo ag ip̱uanadḵulagnu itiṯak aon daaṯeb ");
INSERT INTO gaw_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","amunu ag nai oh ag amelagp̱a madiṯeb amu ag doon dim lamiṯeg! Amge kobol ag heṯeb ele am ag aib dim lamidp̱ig. Ag nai kuḏum madiṯeb amge ag aḵa amu ii dim lamidṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","Ag keeke ug ele itan, danab ah maṯaeg maoṯeb amge ag nakok laa ii ehanadṯeb, amubia ag nai kuḏum madiṯeb amge ag nai amu ii dim lamidṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","Ag keeke oh am danab amelagnuib heṯeb. Ag Kayak nai inaknu kunup, danab laa oh nakokib heṯeb amge ag am oḵai henan, uḏalagp̱a amu ep̱elagp̱a ele qaḵana, unuqiṯak lamen daugp̱a bala elab elab ele heṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","Amu ele ag hobul haenp̱a e lanaknu dayak aben anuqak amup̱a daaglagnu oolag daaṯe. Amu ele nai doyak lag oop̱a danab oḵai ag daaglagnu aben bap̱aidp̱ig daaṯe amu ḏo gumak danab-Parasia amu ḏo mehuqak danab ele ag amup̱a ele daaglagnu oolag daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","Ag qag mak abenp̱a danab laa oh ag humadḵulagnu amu ahilagnu, ‘Ip̱uniṯak danab,’ aḵulagnu ele oolag huanak mauhṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","Anam anana amu Nug nai tuḏiṯa ip̱uniṯak awak danab nuhiḵud amelagp̱a aum. “Amge ag am danab laala ag ahilagnu, ‘Ip̱uniṯak danab,’ aḵulagnu oolag aib dayom. Laip̱u aaḵuib am ahilag ip̱uniṯak danab, ag oh am awag amag aaḵuib daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","Am wan imup̱a ag laanu, ‘Mama,’ aib ap̱ig. Ag Mamelag laip̱u aaḵuib amu Nug hab aṯan daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","Am laa ele, laa nug ahilagnu, ‘Iḵi danab,’ aib aum. Ahilag iḵi danab laip̱u amu Kristus. ");
INSERT INTO gaw_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","Amunu ag oolagp̱a danab laa nug ahilag oḵai daaḵunu oo dayeb amu nug am ahilag begbegib dayad! ");
INSERT INTO gaw_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","Am danab aun nug onig humaṯe amu Kayak Nug heeb, danab amu nug onig neḵu. Ge danab aun nug onig qe neṯe amu Nug danab amu onig am humaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","O gadon, ḏo gumak danab-Parasia amu ḏo mehuqak danab ele. Ag am danab oḏelag aḏit ele. Ag dab meig! Ag Kayaknu ḏo maḏoḏnu od danab ah amelagp̱a maiṯeb. Ag aḵa amu ag amup̱a ii noṯeb. Am danab ah ag amup̱a noḵulagnu heṯeb amu ag ip̱ulag oo neṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","O gadon, ḏo gumak danab-Parasia amu ḏo mehuqak danab ele. Ag am danab oḏelag aḏit ele. Ag dab meig! Ag ah qab bup̱ualadna, ag laulag yab awona, ahilag hip̱unin amu danab ah amelagp̱a loḵumḵulagnu ag unuqiṯak elab heṯeb amunu epeḏiak haenp̱a geha ag ug oḵainab aoglag. ");
INSERT INTO gaw_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","O gadon, ḏo gumak danab-Parasia amu nai mehuqak danab ele. Ag am danab oḏelag aḏit ele. Ag dab meig! Wan laap̱anu danab nug Juda kobol aoḵunu amu ag uḏat oḵainab, hik aqeqe heṯeb. Heegeg, danab amu nug Juda kobol awa amu nug ahilag kobol nau kuḏum ag heṯeb amu eḏiṯak haaha, ag padal maknu ibp̱a daaṯeb amge nug am padal maknu ibp̱anab daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","O gadon, ag amelag gaḏuak ele amge ag danab ah ele ib ip̱uanadḵulagnu heṯeb. Ag dab meig! Ag aṯeb, ‘Danab nug mana meṯak lag onigp̱a nai nuhig g̱agaṯag qedṯe dayeb amu, nai amuam hamu. Amge laa nug mana meṯak lagnu gol onigp̱a nai nuhig g̱agaṯag qedṯe dayeb amu, nug meu genab heṯe, nug aḏi keeke heḵunu aum amu nug heḵunab,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","Ag am dab mak iiṯa, amelag gaḏuak ele. Aḏi am keeke anuqak? Mana meṯak lagnu gol amutai am anuqak o iiṯa mana meṯak lag, nug he Kayaknu lag oop̱anu gol Kayaknu daaṯe, amutai am anuqak? Iiṯanab! Keeke aḏit amu oh a laip̱u daaṯep. ");
INSERT INTO gaw_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","Am ag laa ele inam aṯeb. ‘Laa nug mana meṯaknu qaḏab, amu onigp̱a nai nuhig g̱agaṯag qedṯe ele amu, nai amuam hamu. Amge nug qaḏabp̱a mana meṯaknu doḏ, amu onigp̱a nai g̱agaṯag qedṯe dayeb amu, nug keeke meu heṯe, nug aḏi keeke heḵunu aum amu nug heḵunab,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","Ag ameg gaḏuak danab! Aḏi am keeke anuqak? Mana meṯaknu doḏ amutai am anuqak o iiṯa mana meṯaknu qaḏab, nug he mana meṯak Kayaknu daaṯe, amutai anuqak? Iiṯanab! Keeke aḏit amu oh a laip̱u daaṯep ");
INSERT INTO gaw_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","amunu aun nug mana meṯaknu qaḏab onigp̱a nai nuhig g̱agaṯag qedṯe amu nug keeke qaḏab qaḏep̱a niiṯeb amu oh elep̱a nai nuhig g̱agaṯag qedṯe. ");
INSERT INTO gaw_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","Am laa nug meṯid lag onigp̱a nai nuhig g̱agaṯag qedṯe amu nug meṯid lag amu Kayak onigp̱a ele nai nuhig g̱agaṯag qedṯe. ");
INSERT INTO gaw_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","Am laa nug hab onigp̱a nai nuhig g̱agaṯag qedṯe amu nug Kayaknu dayak aben, amu aun Nug amup̱a daaṯe ele amu, Nug onigp̱a ele nai nuhig g̱agaṯag qedṯe. ");
INSERT INTO gaw_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","O gadon ḏo gumak danab-Parasia amu ḏo mehuqak danab ele. Ag am danab oḏelag aḏit ele. Ag dab meig! Ag keh naunau amu oh op̱ateg, ameg eblaih tanig ele neeg, ameg laip̱u amu Kayak medaṯeb amge ag ḏo laa oḵai amu uup̱ig. Ḏo ag uup̱ig ele am, danab kobol tutuḵup̱a epeḏiaknu kobol, laa dilagnu oo gai iiṯa doyak kobol amu nai ham bup̱uak maṯiak iiṯa kobol ele. Ag ḏo ii dim lamidṯeb amu laa dim lamidṯeb ele, amu oh dim lamidlob amuam ena. ");
INSERT INTO gaw_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","Ag ip̱uniṯak danab nau, ag amelag gaḏuak ele! Ag peipe, keeke nakok amu, ag lewap̱anu lamadṯeb amge ag kamel, keeke oḵai amu, ag lewa ele lana, top̱a goṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","O gadon, ḏo gumak danab-Parasia amu ḏo mehuqak danab ele. Ag am danab oḏelag aḏit ele. Ag dab meig! Ag am hai goḵoḏ amu tap̱iḏ ele gaḏaib ihaṯeb amge oop̱a ag keeke yab kobolp̱a amu beḏu dim lamiṯak kobolp̱a ele aop̱ig amu ag amu inaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","Ḏo gumak danab-Parasia ag amelag gaḏuak! Tatam ag hai goḵoḏ amu tap̱iḏ ele oo ihap̱eg, op̱ia awak dayeb amu gaḏa ele amu dubuṯid iiṯa op̱ia awak daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","O gadon, ḏo gumak danab-Parasia am ḏo mehuqak danab ele. Ag am danab oḏelag aḏit ele. Ag dab meig! Ag am ag alalḵad boomaknu moḏ bia daaṯeb. Laa ag moḏ amu amelagp̱a gau haḵab laaidṯeb amunu dimiṯim am anṯak nuhig ena amge oop̱a amu danab mauhak beḏulag ebehilag ele. Ag amubia daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","Ag anamnab aaḵu daaṯeb amunu danab laa ag beḏulag anidna ag, ‘Umuam danab tutuḵu,’ aon aṯeb amge ag ḏo gumak danab-Parasia amu ḏo mehuqak danab ele amu ag oolag oop̱a amu ag ham bup̱uak danab amu ḏo he nauhak danab daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","O gadon, ḏo gumak danab-Parasia amu ḏo mehuqak danab ele. Ag am danab oḏelag aḏit ele. Ag dab meig! Ag propet mauhp̱ig dilag boomak lag hena amu ag danab tutuḵu mauhp̱ig dilag moḏ amu bala medaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","Meṯana ag aṯeb. ‘Ig alai aḏi dilag haenp̱a daalom am ig ag ehanadta, propet tiilag ii aḏalom,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","Nai amup̱a ag danab, ag propet heeg mauhp̱ig ele amu, ag buḏulḵad daaṯeb amu ag danab ah ip̱uanadṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","Amu ag alalḵad kobol hedap̱ig amubia ag ele hena gog meṯeg! ");
INSERT INTO gaw_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","Ag danab nau! Kayak Nug ag heṯoḏiakp̱a maaṯeb, ag padal meḵulag. Ag aṯem hena amu ii anidmana? ");
INSERT INTO gaw_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","Amunu ag doyeg! Da propet amu danab dab mak ena, ag Kayak nai tutuḵu dooṯeb ele, amu ip̱uniṯak danab ele ana maadp̱i, ahilagp̱a uḏiglag. Uḏip̱eg amu ag laa aqap̱eg mauhp̱eg, laa ag ad emaitakp̱a atuladna, ag laa ahilḵad nai doyak lag oop̱a wipp̱a eheḏ mataḏadḵulag. Ag mataḏadna lamadp̱eg, ab oḵai laalap̱a goḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","Ag alalḵad aḏi ag dig mena Abel, nug am danab tutuḵu, amu ag nug qeeg mauhe uḏie, danab tutuḵu laala ele aqaeg mauheg uḏie, Berekaia beḵa Sakarias, nug mana meṯak lag oop̱a aben gunnab amu qaḏab ele gamagp̱a, ap̱a nug qeeg mauhom batak. Amunu ag gemu daaṯeb, ag ele eheḏ hak amubia hep̱eg, amu oh dilag guiṯak amu ag qaḏelagp̱a neḵu. ");
INSERT INTO gaw_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","Da genab ag amelagp̱a aṯem. Keeke imu oh am danab ah gemu daaṯeb ele imu dilagp̱a beḵu. ");
INSERT INTO gaw_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","O Jerusalem, Jerusalem, na propet aqe mauhṯeb, uḏat danab Kayak nahipp̱a maaṯe uḏiṯeb ele amu, na ag menp̱a aqae mauhṯeb. Da haen kuḏum na begapad, matuk anig naḵud haugp̱a qag maaṯa tonadṯe, amubia qag maadḵulnu hemi amge ag uup̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","Amunu ag doyeg, ag ap̱alag am geha uḏ ba, ab dakeḏ bia daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","Amunu da ag amelagp̱a inam aṯem. Ag gemu dig ma uḵak da baula ii aniḏmana. Tatam ag, ‘Danab imu Nug Naḏi onigp̱a uḏiṯe. Kayak Nug itidṯe,’ aon anana aniḏḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","Jesus Nug mana meṯak lag uua no, nuhiḵud ip̱uniṯak awak danab ag Nug gumidna dop̱ig. Ag dona, Nug amegp̱a ap̱ig. “Anṯe! Mana meṯak lag imu ag enanag hen autna aop̱ig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","Anam aeg amu Jesus Nug oḏelagp̱a awa aum. “Ag keeke amu oh anidṯeb amge da genab ag amelagp̱a aṯem, men imu ag lop̱aḏp̱eg, nena qena, laa nug laa qaḏep̱a iinab daama. Ohnab lop̱aḏadp̱eg, honap nena qeḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","Jesus Nug Olipnu qaukop̱a ta dayeye amu ip̱uniṯak awak danab ag aḵa gumidna gop̱ig. Ag gona ap̱ig. “Na ig amenigp̱a ame amu kobol amu haen ganeb beḵu? Amu ele ep̱onak keeke aḏi am tatam beeb amu ig na uḏiḵutnu amu gog tak haen miag daaṯe ele doognig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","Ag anam aeg, Jesus oḏelagp̱a awa aum. “Danab laa ag ham bup̱ualadmanu ag dab meig! ");
INSERT INTO gaw_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","Aḏinu? Danab kuḏumnab ag da onilp̱a uḏin, ‘Da am Kristus,’ anana, kuḏum laa bup̱ualadḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","Ag bannu doonna, bannu nai ulah ele dooglag. Keeke amu genab beḵulag amge doyeg, ag aib oṯaip̱ig! Wan haen malak iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","Danab beḏulag laa amu ag danab beḏulag laa ele nug qeḵulag. Wan laa ag wan laa ele nug qeḵulag. Am enug haen oḵai nebep̱eg amu mim ele neḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","Amge keeke amu oh am nid doḵunu ah ag guiṯak tatam dooṯeb amubia aaḵuib. ");
INSERT INTO gaw_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","Anam amu haen amup̱a laala ag ag aḏualadna, guiṯak ug ele maṯanna, ag aqap̱eg mauhḵulag. Am danab ah oh ag ahilagnu oolagp̱a nau, ninig ele dooglag. Aḏinu? Da onil amu ahilagp̱a daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","Am haen amup̱a danab ah kuḏum ag Kayaknu oolagp̱a genab doyak ele, ag amu uun, Nug di meṯan, aḵa aḵa nug dimug meḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","Propet ham bup̱uak kuḏum ele ag ahan, danab ah kuḏum bup̱ualadḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","Kobol nau kuḏum beḵulag amunu danab ah ag nug oo mauhak kobol amu uuglag ");
INSERT INTO gaw_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","amge laa nug g̱agaṯag dayebeb uḵeb, keeke oh ba maleb, haen amup̱a ele nug g̱agaṯag daaḵu amu, nug padal ii mema. ");
INSERT INTO gaw_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","Amu danab ah oh dooglagnu ag Kayaknu ḏo maḏoḏnu Nai Ena wan atu ohp̱a mehuqp̱eg, danab ah doop̱eg, dimp̱a keeke oh gog teḵu. ");
INSERT INTO gaw_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","Aria propet Daniel nug keeke naunab laa, nug ab he nauhṯe ele amu, nug amunu yom. Danab aun nug nai imu eb qeṯe amu nug meu nuhig tutuḵu aoḵunu dab maḏ! Amu keeke oh gog teḵu amunu ag keeke naunab amu aben gun elep̱a mep̱eg dayebeb anidna amu ag ");
INSERT INTO gaw_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","Juda wanp̱a daaṯeb ele amu, ag oolna qaukop̱a uḵeg! ");
INSERT INTO gaw_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","Am danab nug ulah awak abenp̱a, lag aṯan daaṯe amu, agup̱a dayaya, nug oolḵunuib dab maama, nug lag oop̱a noa keeke ii aoma. Iiṯa, oola uḵaḏ! ");
INSERT INTO gaw_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","O laa nug daṯa dayaya amu nug oolḵunuib dab maama, eḏua lamen nuhig aoḵunu laḵa ii goma. ");
INSERT INTO gaw_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","Am haen amup̱a ah oolag ele, ah ag nid yuḏ huh madaṯeb ele amu, ahilagnu amu gadonnab. ");
INSERT INTO gaw_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","Ag oug haenp̱a o meṯid deḏp̱a oolmananu ag unuqiṯeg! ");
INSERT INTO gaw_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","Aḏinu? Haen amup̱a ug oḵainab beḵu. Ug amubia nug dig mak haenp̱a uḏiak gemu ele laa ii beum, dimp̱a ele amubia ii daama. ");
INSERT INTO gaw_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","Anam daaṯe amunu Kayak Nug haen amu tutuib daaḵunu, haen amu ii oḵullo, danab ah oh padal melob amge Kayak nug nuhiḵud tituanaṯom ele, Nug amu dilag dab ma, haen tutu oḵulḵu. ");
INSERT INTO gaw_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","Aria haen amup̱a laa nug ag amelagp̱a, ‘Anṯeg! Laa Kayak Nug epeḏiom ele, Kristus, Nug ip̱a ina daaṯe,’ o iiṯa, ‘Anṯeg! Kristus up̱a uma daaṯe,’ ab amu na ootp̱a genab aib doome. ");
INSERT INTO gaw_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","Geha danab laa ag ham bup̱una, ‘Da am Kristus,’ o ‘Da am propet,’ aḵulag. Ag anam anana, ag ep̱onak keeke, danab heḵunu elele iiṯa diigdiig ele heḵulag. Ag Kayak danab ah, nuhiḵud epeḏiaṯom ele amu, ag kaboliadḵulagnu heḵulag amge elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","Doyeg, keeke amu ii neump̱a da ag dab meḵulagnu nai iiḵu ag amelagp̱a ain malami. ");
INSERT INTO gaw_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","Amunu laa ag, ag amelagp̱a, ‘Nug atu taḏakp̱a daaṯe,’ aon amelagp̱a ap̱eg am ag ap̱a aib gop̱ig. O ag, ‘Nug lag imu oop̱a daaṯe,’ aon amelagp̱a ap̱eg amu ag genab aib doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","Ag aaḵu dooṯeb, amemḏi nug aam bedep̱a dig ma amahala uḵa, aam nodep̱a malaṯe, amubia Danab Beḵalag da, da uḏiḵulnu haen amu da anamib uḏip̱i aniḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","Danab mauhak adep̱a niiṯeb amu ai, kaub bia, ag daaṯeb agup̱aib qag meṯeb amubia. ");
INSERT INTO gaw_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","Aria haen amunu ug iiṯa meebeb amu pahanab aam ii amahalma, kalam ele ii amahalma, hoḏop̱ai laala ag habp̱anu nena qeegeg, laala ag uḏalnana, ag ip̱ulag tutuḵu ii dim lamidmana. ");
INSERT INTO gaw_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","Haen amup̱a amu Danab Beḵalag da, dahil ep̱onak keeke habp̱a beḵu. Beeb amu wanp̱anu danab ah oh gaaglag. Gaap̱eg, Danab Beḵalag da, hab waap̱anu lombigp̱a g̱agaṯag oḵai amu amahlak oḵai ele uḏip̱i aniḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","Uḏien, da dahilad engel hep̱i, biugal gayeb, ag gona, danab ah dahilad tituanadmi amu aben ohp̱anu qag maadna, diin uḏiglag. ");
INSERT INTO gaw_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","Nai amunu amu ag ad pignu kobol dab mena, dab mak aoglag. Ag ad pig nug uḏug bau beḵunu dig ma haulṯe amu ag haen amup̱a, ‘Aam haen nug aaḵu dig meṯe,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","Ag ad pig nug bau beḵunu dig ma haulṯe anidna, ag, ‘Aam haen miag daaṯe,’ dooṯeb amubia ag kobol diigdiig oh da ami ele amu bebep̱eg anidna, ag dahilnu, ‘Nug eḏua uḏiḵunu haen miag, odp̱a daaṯe,’ dooglag. ");
INSERT INTO gaw_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","Da genab ag amelagp̱a aṯem, danab ah haen imunu oh ii mauhadp̱eg, geha keeke imu oh beḵu. ");
INSERT INTO gaw_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","Hab wan ele amu iiṯa meḵulah amge dahil nai nug iiṯa iinab mema. ");
INSERT INTO gaw_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","Anam amge laip̱u laa nug amunu haen deḏ ele ii dooṯe. Engel hab aṯannu ele ii dooṯeb. Da ele ii dooṯem. Mama nuḵa keeke amu dooṯe. ");
INSERT INTO gaw_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","Noanu haenp̱a danab ag kobol aḏi aḏi hep̱ig amubia Danab Beḵalag da eḏue uḏiḵulnu haenp̱a amu, danab ag kobol anamib heḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","Hiḏ naḏi ii beum haenp̱a amu ag e lanana, le lanana, nug aona, ah nug meṯanna, amu heegeg uḵe, Noa ubp̱a teum. ");
INSERT INTO gaw_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","Ag amu henana, hiḏ beḵunu dab ii meṯaegeg, hiḏ ba, diia uḵom amubia Danab Beḵalag da, da uḏiḵul haenp̱a, ag anamib daaglag. ");
INSERT INTO gaw_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","Geha danab aḏit omelahp̱a daap̱eḏ, Kayak Nug laip̱u awawa, laip̱u am uuiṯeb daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","Ah aḏit a bretnu plaua neḵunu hebepeḏ, laa amu awawa, laa am uuiṯeb daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","Amunu ag Danab Beḵalag da, da eḏuen neḵulnu dab menan dayeg! Aḏinu? Haen adeḵup̱a ahilag Naḏi uḏiḵu amu ag ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","Ag doyeg! Lag mameg nug haen adeḵup̱a tuqan yabhok danab uḏiḵu doolo amu nug ib aḏaḏa heeb, yabhok danab nug laug lop̱aḏa, lag oop̱a ii nolo. ");
INSERT INTO gaw_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","Amunu ag ele dab menan dayeg! Danab Beḵalag da, da haen laa aam ameg aṯenp̱a uḏiḵul amu ag ii doop̱eg, da uḏiḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","Jesus Nug anam anana, Nug nai tuḏiṯa aum. “Aun nug am uḏat danab dab mak ena ele, nug nuhig uḏat tutuḵu dooṯe, nuhig danab oḵai nug uḏat danab nuhiḵud amu gumaṯaṯa, haenp̱a e madaḵunu elele daaṯe anṯa, nug amu heḵunu meum amu, da nuhignu madiṯem. ");
INSERT INTO gaw_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","Uḏat danab nug anam dayebeb, dimp̱a nuhig danab oḵai nug eḏua uḏia, nid amu nug danab oḵai nuhig anuḵa amegp̱a aumbia heṯe anidḵu amu nuhignu ena. ");
INSERT INTO gaw_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","Da genab ag amelagp̱a aṯem. Danab oḵai nug uḏat danab amu nuhig keeke ohnu iḵilag meeb daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","Amge uḏat danab amu nug danab ena iiṯa daya, oop̱a, ‘Danab oḵai dahil nug paha ii uḏima,’ dab meḵu dayeb amu ");
INSERT INTO gaw_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","nug dig ma, uḏat nid laa, uḏat ah laa ele ag maḵuḏaṯaṯa, nug le g̱agaṯag laeg, kaaka aqak danab ele e lanana le ele labep̱eg ");
INSERT INTO gaw_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","amu nuhig danab oḵai nug haen deḏ ele, uḏat danab amu nug ii doyom, ii dab meum ele, amup̱a eḏua uḏiḵu. ");
INSERT INTO gaw_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","Uḏia amu danab oḵai nug uḏat danab amu eheḏnab hetowa, awa meeb, ham bup̱uak danab ag ele daaglag. Ap̱a danab ag gaanna, aelag ele kikiḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","Haen amup̱a Kayaknu ḏo maḏoḏ amu ah maḵun eblaih tanig ele, ahilag hak bia daaḵu. Amu ah maḵun amu ag ahilḵad lam aon, danab laa ah aoḵun heum ele amu, nug ameg meegeg, nug ibp̱a uḏieye, ag ahan gona, ibp̱a uḏa tena anidna omalp̱eg, ah nuhig laugp̱a goḵulagnu daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","Ah maḵun tanig ele amu ag dab mak iiṯa, tanig ele laa amu ag dab mak ele. ");
INSERT INTO gaw_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","Ah maḵun dab mak iiṯa amu ahilag lam aop̱ig amge amahlaknu le amu ii aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","Ah maḵun dab mak ele, ag amahlaknu le nip̱udp̱a mewona aḏanna, ahilḵad lam ele aon gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","Am danab ah aoḵun heum ele nug paha ii uḏie, ag oh amelag ne niip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","Niiegeg, tuqan tugmag baag laa ewa aum. ‘Danab nug ah bau aoḵunu heṯe ele, nug aaḵu uḏiṯe. Ag gona, nug anṯeg!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","Baag laa anam doona, ah maḵun eblaih tanig ele amu ag oh ahan, lam ahilag bap̱aidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","Bap̱aidna amu ah maḵun dab mak iiṯa ele ag ah maḵun dab mak ele amelagp̱a ap̱ig. ‘Ag amahlaknu le ahilag amu ig laa meḵeg! Ig ihinig amahlaknu le iiṯa meum,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","Ah maḵun dab mak iiṯa ele ag anam ap̱ig amge ah maḵun dab mak ele ag ap̱ig. ‘Iiṯa, ihinig amahlaknu le imu am ihinignu eleleib bia. Ahilagnu ele elele iiṯatai amunu ag en laḵa gona, aun nug amahlaknu le ele amu ag nuhigp̱a ahilagnu aweg!’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","Ah maḵun dab mak ele ag anam aeg amu ah maḵun dab mak iiṯa ele ag en laḵa amahlaknu le aoglagnu uḵaegeg amu danab ah aoḵun heum ele amu aaḵu uḏiom. Uḏie amu ah maḵun dab mak ele ag nug ele nug awak hobulp̱a nona malaeg, od manom. ");
INSERT INTO gaw_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","Dimp̱a ah maḵun dab mak iiṯa ele amu ag ele uḏip̱ig. Uḏin ap̱ig. ‘Naḏi, Naḏi, od matulna meḵe!’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","Ag anam ap̱ig amge nug aum. ‘Da genab ag amelagp̱a aṯem, da ag ii doyadṯem,’ awa aum.” Jesus Nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","Jesus Nug anam anana amu Nug nai tuḏiṯa aum. “Anam daaḵu amunu ag dab menan dayeg! Aḏinu? Da eḏuen uḏiḵulnu haen amu ag deḏ haen ele ii dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","Aria Jesus Nug nai anam awowa, Nug nai laa ele inam aum. “Kayaknu ḏo maḏoḏ amu danab oḵai laa nug atu laap̱a goḵunu ha, nuhiḵud uḏat danab onilagp̱a e uḏieg, nug enub amu ag ep̱elagp̱a meum amubia. ");
INSERT INTO gaw_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","Laa amu paip tausen kina ep̱egp̱a meum, laa tu tausen kina, laa wan tausen kina meum. Ag uḏat heḵulagnu elelep̱a maṯowa, nug uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","Nug ugeḵe, laa nug men doḏo paip tausen kina awom ele amu nug pahanab awa uḵa, uḏat ha, paip tausen kina baula ele awom. ");
INSERT INTO gaw_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","Amubiaib laa tu tausen kina awom ele amu nug ele anam ha, tu tausen kina baula ele awom. ");
INSERT INTO gaw_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","Amge danab nug men doḏo wan tausen kina awom ele amu, nug awa uḵa, moḏ awa, nuhig oḵainu men doḏo loḵume dayom. ");
INSERT INTO gaw_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","Amu haen elabnab uḵe, dimp̱a uḏat danab dilag oḵai nug eḏua uḏie, men doḏo ag maṯom ele amunu nai maṯin bap̱aidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","Aria danab nug men doḏo paip tausen kina awom ele amu nug aum. ‘Naḏi, anṯe, na da paip tausen kina meḏame ele amu iiḵud anṯe! Da uḏat hein, paip tausen kina baula ele iiḵu aomi,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","Anam a amu nuhig oḵai aum. ‘Na uḏat danab ena, na ham bup̱uak laa ii heme. Na keeke nakok amu dab meṯan autna aome amunu da hep̱i, na keeke kuḏum dilag oḵai daanna gumadḵut. Na dop̱e, da ele oonih gamag ahaḏ!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","Aria danab nug tu tausen kina awom ele nug ele doa aum. ‘Naḏi, na men doḏo tu tausen kina meḏame amu da uḏat heinne, tu tausen kina baula ele aomi,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","Amu nuhig oḵai nug aum. ‘Na uḏat danab ena. Na ham bup̱uak laa ii heme. Na keeke nakok amu dab meṯan autna aome amunu da hep̱i, na keeke kuḏum dilag oḵai daanna gumadḵut. Na dop̱e, da ele oonih gamag ahaḏ!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","Am danab nug wan tausen kina awom ele amu nug ele doa, nuhig oḵai amegp̱a aum. ‘Naḏi, da dooṯem na am danab g̱agaṯag, na ii ep̱amep̱a amu meu aoḵutnu dooṯem. Am na haḏag ii taoḏmep̱a amu ele meu aoḵutnu dooṯem. ");
INSERT INTO gaw_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","Amunu da baḏe, men doḏo nahip meḏame amu awe uḵe, wanp̱a moḏ awe memi. Anṯe, nahip keeke iiḵu,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","Nug anam a amu danab oḵai nuhig aum. ‘Na uḏat danab nau, na bahin iiṯa! Na da ii ep̱amip̱a, haḏag ii taoḏmip̱a ele meu aoṯem genabte doome? ");
INSERT INTO gaw_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","Anam genab daalo amu na men doḏo dahil benk danab maṯalom, ag hep̱eg, da tuḏiṯak baula ele aolom amuam ena. ");
INSERT INTO gaw_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","Amunu ag laip̱u nug ep̱egp̱anu amu aona, laa nug ten tausen kina ele amu meṯeg! ");
INSERT INTO gaw_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","Aḏinu? Danab nug keeke aḏaṯe ele amu, da baula ele medap̱i, kuḏum ele daaḵu amge danab laa nug keeke nakok tatam awom aaḵuib aḏeb amu da aḏidḵul. ");
INSERT INTO gaw_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","Aria uḏat danab nau amu ag buḏip̱eg, dimiṯim gatatup̱a noaḏ! Ap̱a danab ag gaanna, aelag ele kikiḏḵulag,’ awa aum.” Jesus Nug ag amelagp̱a anam maṯiom. ");
INSERT INTO gaw_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","Jesus Nug anam anana Nug nai tuḏiṯa aum. “Dimp̱a Danab Beḵalag da, da binal ele uḏip̱i, engel oh ele uḏignig, haen amup̱a da dayak aben kobol ele dahilp̱a daaḵul. ");
INSERT INTO gaw_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","Da anam daap̱i, danab ah oh da noolp̱a qag meḵulag. Qag mep̱eg, da epeḏaṯen, ameg aḏit meḵul, gumak danab nug sipsip otia ameg piḏe maama amu meme otia ameg piḏe meṯe amubia. ");
INSERT INTO gaw_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","Da sipsip amu naḏiap̱a maaṯeṯe, meme amu nanehp̱a maadḵul. ");
INSERT INTO gaw_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","Anam maaṯoya, da king daaṯem amunu da danab ah naḏiap̱a maadmi ele amu amelagp̱a aḵul. ‘Ag inam doig! Mame Nug ag itiṯak maṯom! Da Mamel Nug ḏo maḏoḏ ahilagnu haen wan bau beebe babaiṯa maṯom. ");
INSERT INTO gaw_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","Aḏinu? Anuḵa da enug iwe, ag e meḏap̱ig. Da le baal diie, ag le meḏap̱ig. Da ab laap̱anu danab bia daami, ag omaiḏna, ag laulagp̱a meiḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","Da lamen iiṯa daami, ag lamen meḏap̱ig. Da oḏe ele daami, ag da atog noiḏp̱ig. Da mani guiṯakp̱a daami, ag uḏin aniḏp̱ig,’ awe aḵul. ");
INSERT INTO gaw_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","Da anam ap̱i amu danab ah tutuḵu ag da oḏelp̱a aon aḵulag. ‘Naḏi, na ganeb enug niṯe, ig e meṯamut? Am na ganeb le baat diie, ig le meṯamut? ");
INSERT INTO gaw_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","Haen adeḵup̱a na ab laa danab bia daame, ig na omaidta, launigp̱a gomut? Am haen adeḵup̱a na lamen iiṯa daame, ig na lamen meṯamut? ");
INSERT INTO gaw_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","Haen adeḵup̱a na oḏe ele daame, ig na atog noidmut o na mani guiṯakp̱a daame, ig gota na anidmut?’ aon aḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","Ag anam ap̱eg amu da ag oḏelagp̱a awe aḵul. ‘Da genab ag amelagp̱a aṯem. Ag keeke aḏi laa da lailad, onilag iiṯa ele, amu dilagp̱a hep̱ig amu ag dahilp̱a hep̱ig.’ awe aḵul. ");
INSERT INTO gaw_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","Aria laa nanehp̱a daaṯeb ele amu amelagp̱a aḵul. ‘Ag nob nau aoglagnu daaṯeb amu ag uuiḏna uḵeg! Ag ab aḏu ii qauhṯe ele, Naḏi Nug Satan amu nuhiḵud engel ele dilag heum amu, ag amup̱a uḵeg! ");
INSERT INTO gaw_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","Aḏinu? Anuḵa da enug iwe am ag e ii meḏap̱ig. Da le baal diie amu ag le ii meḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","Da ab laa danab bia daami amu ag omaiḏna laulagp̱a ii gop̱ig. Da lamen iiṯa daami amu ag da lamen ii meḏap̱ig. Da oḏe ele daami amu ag da ii atog noiḏp̱ig. Da mani guiṯakp̱a daami amu ele ag gona ii aniḏp̱ig,’ awe aḵul. ");
INSERT INTO gaw_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","Anam ap̱i amu ag aḵulag. ‘Naḏi, na ganeb enug daame am ig na anidta ii ehanidmut? O na ganeb le baat diiom, o na ab laa danab bia daame, o na lamen iiṯa daame, o na oḏe daame o iiṯa na mani guiṯakp̱a daame amu ig na anidta ii ehanidmut?’ aon aḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","Ap̱eg amu da ag oḏelagp̱a awe aḵul. ‘Da genab ag amelagp̱a aṯem. Ag keeke aḏi da lailad, onilag iiṯa ele, amu dilagp̱a ii hep̱ig amu ag dahilp̱a ele ii hep̱ig,’ awe aḵul. ");
INSERT INTO gaw_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","Aria danab amu ag gona, guiṯak haen ohnu abenp̱a daaglag amge tutuḵu danab ag bauklel hanhannu aon daaglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","Jesus nai amu oh maṯia malom dimp̱a Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“Ag dooṯeb, deḏ aḏit uueb, Pasowa hobul lanaknu haen ana beḵu amu ag Danab Beḵalag da kekeḏ ep̱elagp̱a meiḏna, ag ad emaitakp̱a atuliḏḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","Haen amup̱a mana meṯak danab oḵai amu Israel dilag gumak danab ele, ag oh mana meṯak danab dilag iḵi onig Kaiapas nug laug enanagp̱a qag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","Qag mena ag ib aṯemup̱a Jesus loḵumakp̱a aḏan, qep̱eg mauhḵunu heṯoḏina, nai qagap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","Ag heṯoḏiak hena amu ag ap̱ig. “Danab ah ag nug qemana, ag muṯub ele qemananu amu ig Pasowa hobul haenp̱a Jesus ii aḏamta,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","Aria Jesus Nug Betani ap̱a danab laa, nug gaḏa oḏe ele, nug onig Simon, nug laugp̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","Anam dayeye, ah laa nug men id enanag, goḏen muṯuḏig enanag, nob oḵainab ele inak amu awa, gumiṯa uḏiom. Awa uḏia, Jesus Nug balalp̱a dayeye, goḏen amu Jesus igip̱a goḵaḏom. ");
INSERT INTO gaw_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","Ip̱uniṯak awak danab ag amu anidna, ag oolag nauhe ap̱ig. “Nug aḏinu goḏen amu hamu kakiṯom? ");
INSERT INTO gaw_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","Goḏen amu, laa ag men doḏo oḵaip̱a daden melob. Ag anam helob amu nug men doḏo amu daḏek danab maṯalo am ena,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","Am Jesus Nug nai ahilag doyom amunu amelagp̱a aum. “Ag aḏinu ah imu oo ug medaṯeb? Nug kobol ena dahilp̱a heum. ");
INSERT INTO gaw_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","Daḏek danab amu, ag ag oolagp̱a hanhan daaglag amge da am ag ele haen oh ii daamta. ");
INSERT INTO gaw_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","Nug da beḏulp̱a goḏen imu goḵaḏom amu nug da mauhe, moḏp̱a niiḵulnu beḏul babaiṯom. ");
INSERT INTO gaw_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","Da genab ag amelagp̱a aṯem. Dimp̱a danab ag dahil Nai Ena wan adep̱a adep̱a mehuqnana, ag ah imu keeke heum amu, nug ag daulagp̱a doḵunu, ag amunu ele maṯiglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","Aria haen amup̱a ip̱uniṯak awak danab tuelp ag oolagp̱anu laip̱u laa, nug onig Judas Iskariot, nug mana meṯak danab oḵai gumaṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","Nug uḵa aum. “Da Jesus ag ep̱elagp̱a mep̱i amu ag aḏi meḏaglag,” awa aum. Nug anam a amu ag men doḏo silwa 30 meṯaglagnu eb qep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","Ag anam heeg, haen amup̱a nug dig ma, haen ena adeḵup̱a nug Jesus aḏa, ag ep̱elagp̱a meḵunu ib maṯiom. ");
INSERT INTO gaw_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","Aria Pasowa meṯid hobulnu babaiṯaknu deḏ ne, Jesusnu ip̱uniṯak awak danab ag dona, Jesus oḏ medap̱ig. “Na Pasowa laḵutnu amu ig amunu adep̱a bap̱aidḵunignu oot daaṯe?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","Ag anam aeg am Nug aum. “Ag ab oḵaip̱a nona, danab laa gumidna gona, amegp̱a inam aig! ‘Ip̱uniṯak danab ihinig Nug inam aum. “Dahil haen aaḵu miag daaṯe amunu da nid dahilad ele na lautp̱a Pasowa e laḵunignu ool daaṯe.” ’ Ag anam aon aig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","Jesus Nug anam a amu nuhiḵud ip̱uniṯak awak danab ag Nug oḏe dim lamidna, Pasowanu e bap̱aidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","Aria tueb me, Jesus amu nuhiḵud ip̱uniṯak awak danab tuelp ele ag balalp̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","Ag anam balalp̱a e lanana, Jesus Nug aum. “Da genab ag amelagp̱a aṯem, ag oolagp̱a laip̱u laa nug da kekeḏ ep̱elagp̱a meiḏḵu.” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","Nug anam a, ag oolagp̱a ugnab doon, ag anen anen Jesus oḏ medap̱ig. “Naḏi, na ame amu date?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","Aeg amu Nug ag oḏelagp̱a awa aum. “Laip̱u laa nug da ele e laṯem amu nug da kekeḏ ep̱elagp̱a meiḏḵu. ");
INSERT INTO gaw_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","Danab Beḵalag da, Kayak nai aṯe amubianab da mauhḵul amge danab nug Danab Beḵalag da, kekeḏ ep̱elagp̱a meiḏḵu ele amu nuhignu gadonnab. Nug anig nug ii menulo am ena,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","Jesus anam a amu Judas nug Jesus kekeḏ ep̱elagp̱a meḵunu heum ele amu, nug aum. “Ip̱uniṯak danab, na ame amu date?” awa aum. A amu Jesus aum. “Na ame,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","Ag anam e lanana daanna, Jesus Nug bret awa, mameg unuqiṯowa, pane ne, pania nuhiḵud ip̱uniṯak awak danab madaṯa, Nug aum. “Ag aon laig! Imu da beḏul.” ");
INSERT INTO gaw_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","Nug baula hai wain ele awa, unuqiṯowa madaṯa Nug aum. “Ag oh aon laig! ");
INSERT INTO gaw_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","Imu da tiil, amup̱a da tituanak bau heṯem. Da danab ah kuḏum dilag hip̱unin uhuqen madaḵulnu goḵaḏṯem. ");
INSERT INTO gaw_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","Amge da ag amelagp̱a aṯem, da grep lep̱u, wain, geha iiḵu laṯem imubia baula paha ii lapa. Iiṯa, dimp̱a Mamanu ḏo maḏoḏ oop̱a da ag ele wain bau laḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","Nug anam a amu ag ahi laa eṯona, ag ahan, dimiṯim wana, ag Olipnu qaukop̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","Ag gona, Olipnu qaukop̱a tena, Jesus Nug ag amelagp̱a aum. “Kayak naip̱a yak laa niiṯe am inam. ‘Da gumak danab qep̱i mauheb, sipsip ag oolna matatun goḵulag,’ amunu yak amubia amu gemu tuqan imu ag oh uuiḏna, oolna goḵulag. ");
INSERT INTO gaw_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","Amge da eḏuen hibaiṯena, da tatam anuqen Galelia gop̱i, ag da dim lamiḏna goḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","Amge Petrus nug oḏep̱a awa, amegp̱a aum. “Imu oh ag nahipnu eheḏ doon, uuidna oolna goḵulagtai amge da am anam ii hepa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","Petrus nug anam a amu Jesus amegp̱a aum. “Da genab na amenp̱a aṯem. Na tuqan imup̱a na dahilnu, ‘Da Nug ii dooṯem,’ aon, haen ewam batak aḵut. Na haen ewam anam ap̱e, dimp̱a matuk dawai nug gaaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","Am Petrus nug aum. “Iiṯa! Da na ele mauhḵunih dayeb amu da amunu ug ii dooṯem amge da nahipnu, ‘Da nug ii dooṯem,’ ii apa!” Nug anam a amu ip̱uniṯak awak danab oh anam ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","Ag anam aeg amu Jesus Nug ag ele oh aben laa onig Getsemani ap̱a gop̱ig. Gona amu Nug ip̱uniṯak awak danab amelagp̱a aum. “Ag inam daap̱eg, da up̱a uḵen unuqidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","Nug anam anana amu Nug Petrus am Sebedi bekoḏ aḏit ele aaḵuib diiaṯe, Nug ele gop̱ig. Gona amu Nug oop̱a ugnab doyom. ");
INSERT INTO gaw_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","Nug anam doya, Nug ag amelagp̱a aum. “Da oolp̱a kahipan toḏe mauhak bianab dooṯem amunu ag inam daap̱eg, da ele dab meṯat daatu!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","Nug anam anana, Nug nakok baula wana uḵa, ap̱a Nug dup noa, gateg qaun wa, iḏu wanp̱a ma, unuqiṯa aum. “O Mama, ug oh da maoḵul ele, amuam lep̱u mua eheḏ hai goḵoḏp̱a daaṯe bia amu, na ib laa anidna ap̱e am da le hai goḵoḏ amup̱anu da ii lapa amge Na da ool daaṯe imu aib dim lamidme. Na oot daaṯe amuib dim lamiṯe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","Nug anam unuqiṯowa eḏua uḵa, nuhiḵud ip̱uniṯak awak danab ewam amu niiegeg anaṯa, Nug Petrus amegp̱a aum. “Ag da ele aam ameg laip̱uib dab meṯat daagnignu elele iiṯate? ");
INSERT INTO gaw_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","Satan ag eeḏaṯeb, eheḏ gomananu ag dab menana daanna, unuqiṯeg! Ag ouḏilag amuam elele amge ag beḏulag am elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","Jesus Nug anam anana, Nug eḏua uḵa, baula unuqiṯa aum. “O Mama, da le hai goḵoḏ imunu ii laḵulnu amu na ib laa anidḵutnu elele iiṯa dayeb am na nahip dab mak aaḵuib dim lamiṯe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","Nug anam unuqiṯowa, Nug eḏua uḵa amu ip̱uniṯak awak danab ag amelag eheḏ neum amunu ag niiegeg anaṯom. ");
INSERT INTO gaw_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","Anam anaṯa amu Nug eḏua uḵa, unuqiṯak aḏit tatam heum amuib baula unuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","Unuqiṯak oh malak dimp̱a Jesus Nug eḏua uḵa, ip̱uniṯak awak danab amelagp̱a aum. “Ag iite ahap̱ig? Ag geha iiḵu ele niin autna aoṯebte? Anṯeg! Laa nug Danab Beḵalag da, hip̱unin danab ep̱elagp̱a meiḏḵunu haen aaḵu doum. ");
INSERT INTO gaw_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","Ahap̱eg gotu! Ag aaḵud anṯeg, danab nug da kekeḏ ep̱elagp̱a meiḏḵu ele amu nug aaḵu uḏiṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","Jesus anam nai maṯieye amu ip̱uniṯak awak danab tuelp amu oolagp̱anu laa onig Judas amu danab kuḏum ele, danab amu ag qep elab amu daḏib maha ele aḏap̱ig amu ag mana meṯak danab oḵai amu Juda iḵi danab ele ap̱ig bia Judas ele uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","Aria tatam Judas nug ag Jesus aḏaglagnu ep̱onak keeke laa heḵunu amelagp̱a inam aum. “Da geha laa ootuqidḵul amu, danab amu aaḵuib. Ag Nug aḏeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","Aria ag uḏina, Judas nug pahanab Jesus gumiṯa uḵa, “Tuqan ena Ip̱uniṯak Danab,” awowa, nug ootuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","Nug anam ootuqiṯe amu Jesus Nug amegp̱a aum. “O lai, na keeke heḵutnu oot daye uḏime amu na he!” awa aum. Jesus anam a, danab oh ag dona, Jesus aḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","Ag anam heegeg, laa Jesus ele daap̱ig amu, ag oolagp̱anu laip̱u laa nug qep elab aoḵunu ep̱eg bahia, eeḏa awa, mana meṯak danab dilag iḵi, nuhig begbeg laa daug hoiyom. ");
INSERT INTO gaw_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","Hoiye amu Jesus aum. “Na nahip qep elab eḏun abenp̱a me. Aḏinu? Aun nug qepp̱a ban heṯe amu nug qepp̱a mauhḵu. ");
INSERT INTO gaw_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","Na iite dooṯem? Da Mama amegp̱a ehaniḏḵunu ap̱i amu pahanab nuhiḵud engel daup kuḏumnab, ban danab ameg tuelp eḏaṯak, meḏaḵu. ");
INSERT INTO gaw_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","Amge da anam hep̱i amu Kayak nai aṯem genab beḵu? Kayak nai nug imu beḵunu aṯe amu nug anamib beḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","Aria haen amup̱a Jesus Nug danab ameg naḏi amu amelagp̱a aum. “Da yabhok danabte daaṯem amunu ag qep elab amu daḏib ele aon, aḏailḵulagnu uḏip̱ig? Haen da deḏ oh meṯid laḵa danab ah ip̱uniṯak madaṯami amu ag da ii aḏailp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","Amge keeke imu oh amu propet nai yaap̱ig amu meu medaṯe,” awa aum. Anam a amu ip̱uniṯak awak danab oh ag oolna malap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","Aria danab ag Jesus aḏap̱ig ele amu ag Nug aon, mana meṯak danab dilag iḵi Kaiapas, nug top̱a gop̱ig. Ap̱a amu ḏo mehuqak danab amu abnu iḵi danab ele qag mena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","Amu Petrus nug dim lamaṯom amge nug nakok piḏe dim lamaṯom. Dim lamaṯaṯa, nug mana meṯak dilag iḵi danab nug laugnu aḏ oop̱a no, lag mamegnu begbeg ele daap̱ig. Nug kobol aḏi hebep̱eg amu dooḵunu dayom. ");
INSERT INTO gaw_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","Aria mana meṯak danab oḵai amu Juda dilag heṯoḏiak oḵai, onig Sanhidren, amunu danab ele ag Jesus aḏi eheḏ heum o ii heum, ag amu dab ii mep̱ig. Iiṯa, ag hamu heṯoḏin, qep̱eg mauhḵunuib hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","Heegeg am laa kuḏum ag ahan ham bup̱unna, Jesus eheḏ heumnu ap̱ig amge ag Jesus keeke eheḏ heumnu, qep̱eg mauhḵunu ele laa ii anidp̱ig. Ag anam heegeg dimp̱a danab aḏit laa ");
INSERT INTO gaw_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","beya apiḏ. “Danab imu nug, ‘Da Kayaknu mana meṯak lag lop̱aḏoya, deḏ ewamp̱aib eḏue buuḵul,’ aum,” aoi apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","A anam aeh amu mana meṯak dilag iḵi danab nug hibaiṯa, Jesus oḏ meṯom. “Nai amunu amu na nob iite memana? Nai anak amuam genab o genab iiṯa?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","Nug anam aum amge Jesus Nug nai nakoknab laa ii maṯiom. Aria baula mana meṯak dilag iḵi danab amu nug amegp̱a aum. “Da Kayak bauklel onigp̱a da na amenp̱a aṯem. Na nai genab tutuḵu a! Na genab Kristus, Kayak beḵate o iiṯa?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","Nug anam a amu Jesus Nug oḏep̱a awa aum. “Na ame. Amge da ag amelagp̱a aṯem. Dimp̱a Danab Beḵalag da, Kayak g̱agaṯag oh ele amu, Nug ep̱eg naḏiapp̱a daap̱p̱i aniḏna amu hab waap̱anu lombigp̱a ele uḏip̱i aniḏḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","Jesus anam a amu mana meṯak danab dilag iḵi nug lamen nuhig aḏa paṯiḏa aum. “Nug Kayak dabiṯa, awa awa qedaṯe! Ig danab laala danab imu eheḏ heumnu maṯiglagnu ii maṯimta. Iiḵu elele. Nug Kayak dabiṯa, awa awa qeṯom aaḵu doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","Ag aḏi aṯeb?” awa aum. A amu ag ap̱ig. “Nug mauhḵun daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","Anam anana, ag Jesus iḏup̱a hununna amu maḵuḏp̱ig. Laa ag ep̱elag oohap tena, mataḏnana ");
INSERT INTO gaw_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","ap̱ig. “Na am Kristusde! Kayak na ehaniṯeb amu na ap̱e dootu! Aun na oiṯom?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","Ag anam heegeg, Petrus nug heṯoḏiak lagnu haḏapp̱a dayom. Dayeye, mana meṯak dilag iḵi, nuhig begbeg nid ahin laa nug doa aum. “Na ele Galelia ted Jesus, Nug ele oipiḏ,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","Amge Petrus nug ag oh noolagp̱a ham bup̱ua, “Na nai aṯem amu da diig ii dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","Nug anana amu aha wana, lagnu aḏ odp̱a uḵa dayeye amu begbeg nid ahin laa na, nug danab ap̱a daap̱ig ele amu amelagp̱a aum. “Nug anuḵa Jesus, Nasaret ted ele oipiḏ.” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","Nug anam a Petrus nug nai nuhig g̱agaṯag qeṯa aum. “Da danab amu ii dooṯem!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","Nakok laa ele amu danab ap̱a hip̱aidna daap̱ig ele amu Petrus gumidna dona ap̱ig. “Na am genab danab umunu layag laa aaḵu. Aḏinu? Nahip nai maṯiak amu he, na miag atime,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","Ag anam aeg, Petrus nug nai g̱agaṯagnab inam aum. “Da nai genab ii ap̱i amu Kayak Nug da nob nau meḏaḏ! Da genab iiḵu aṯem, da danab umu ii dooṯem!” Nug anam a amu matuk paha gayom. ");
INSERT INTO gaw_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","Matuk gaye amu Jesusnu nai, “Tuqan imup̱a na dahilnu, ‘Da Nug ii dooṯem,’ aon, ewam batak aḵut. Na haen ewam anam ap̱e, dimp̱a matuk dawai nug gaaḵu,” nai amu Petrus daugp̱a doum. Nai amu Petrus daugp̱a do, nug dimiṯim uḵa, huanaknab gayom. ");
INSERT INTO gaw_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","Waḵaḏe buṯuanab mana meṯaknu iḵi danab oh amu Juda iḵi danab ele ag Jesus qep̱eg mauhḵunu nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","Maṯiona amu ag Jesus ep̱eg muḏip̱a qaḵona, ahan omalna gona, Rom dilag gabman oḵai Pilatus ep̱egp̱a mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","Aria Judas, nug Jesus kekeḏ ep̱elagp̱a meum ele amu, nug Jesus geḏidna heṯoḏiakp̱a mep̱ig doya, nug oo ug daye, men doḏo silwa 30 amu eḏua awa uḵa, mana meṯak iḵi danab amu danab ah dilag iḵi danab ele madaṯa ");
INSERT INTO gaw_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","nug aum. “Da hip̱unin hemi. Da danab nug eheḏ laa ii heum amu da hamu kekeḏ ep̱elagp̱a mauhḵunu memi,” awa aum. Anam awa a doona ag ap̱ig. “Amu ihinig keeke iiṯa. Am nahip keeke,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","Ag anam aeg amu Judas nug men doḏo amu mana meṯak lag oop̱a mawe uḵe, nug nug uḵa, muḏip̱a aiha mauhom. ");
INSERT INTO gaw_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","Mana meṯak iḵi danab ag men doḏo amu aon ap̱ig. “Imu amu danab mauhḵunu daden maknu men doḏo. Ḏo daaṯe amunu ig tamaniaknu kunupp̱a ii memata,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","Amunu ag nai maṯin, oolag laip̱u mena, ag men doḏo amu aona, wan laa, danab nug wa heṯe ele, nuhig wan amu daden mep̱ig. Ag wan amup̱a danab atu laihnu boomadḵulagnu tituanp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","Amunu ag wan amu onig inam ataḏp̱ig. “Danab Mauhḵunu Daden Awak Wan,” aon ap̱ig. Onig amu gemu ele daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","Amunu anuḵa Kayak Nug nai laa propet Jeremaia oḏep̱a aum amu genab beum. Nug aum. “Israel ag men doḏo silwa 30p̱a nug daden meḵulagnu nai qagap̱ig amu ag men doḏo silwa 30 amu aon, ");
INSERT INTO gaw_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","danab wa heṯe ele nuhig wan daden mep̱ig. Naḏi Nug da amelp̱a aumbia.” ");
INSERT INTO gaw_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","Aria Jesus Pilatus noobp̱a hibaiṯa dayeye, Pilatus Jesus oḏ meṯom. “Na Juda dilag kingte?” awa aum. A amu Jesus, “Na aaḵu aṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","Nug anam a amu mana meṯak danab oḵai amu Juda iḵi danab ele ag nuhignu nai hamu yaan heeg, Nug nai nob laa ii meum. ");
INSERT INTO gaw_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","Nug anam heehe amu Pilatus nug Jesus amegp̱a aum. “Ag na eheḏ kuḏum hemenu aṯeb amu, na amu iite dooṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","A amu Jesus Nug Pilatus oḏep̱a ii awom. Anam he amu Pilatus nug oo ii maiṯe, nug dab mak kuḏum awom. ");
INSERT INTO gaw_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","Aria maḏ ohp̱a Pasowa hobulnu deḏp̱a gabman nug danab ah ag hip̱unin danab aṯen uhuqa madaḵunu ap̱ig amu nug mani guiṯakp̱anu od matule doṯom. ");
INSERT INTO gaw_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","Am haen amup̱a danab laa nug Rom gabman dilag ḏo haen kuḏum tip̱alom ele amu, ag nug aon mani guiṯakp̱a meeg dayom. Danab amu nug onig Barabas. ");
INSERT INTO gaw_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","Am danab ah ag qag meeg amu Pilatus nug ag oḏ maṯom. “Ag mani guiṯak danab aun uhuqe madaḵulnu oolag daaṯe, Barabas o Jesus? Ag nuhignu Kristus aon aṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","Pilatus nug Jesus, nuhig hak ena, hak amup̱a Nug Juda oḵai eḏaṯom amunu ag oolag nauhe, Jesus heṯoḏiakp̱a mep̱ig doyom amunu Nug anam oḏ maṯom. ");
INSERT INTO gaw_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","Pilatus nug anam oḏ maṯa, nug epeḏiaknu dayak abenp̱a dayeye, nug wau nai inam me uḏiom. “Danab tutuḵu amunu, nuhigp̱a na keeke laa aib heme. Tuqan imup̱a da Nug tulp̱a anṯe, ug guiṯak ele huanak doomi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","Aria nug nai amu doya dayeye, mana meṯak dilag iḵi amu Juda iḵi danab ele ag Pilatus nug Barabas uhuqa madaṯa, Jesus qeeb mauhḵunu danab ah oolag yaan heeg ");
INSERT INTO gaw_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","gabman oḵai Pilatus nug baula, “Danab aḏit imu oolahp̱anu da aun uhuqe ag madaḵul?” oḏ maṯe amu ag, “Barabas,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","Ag anam aeg amu Pilatus nug aum. “Amge da Jesus, nuhignu ag Kristus aṯeb ele amu, nuhignu da aṯem heḵul?” awa aum. Nug anam a amu ag oh ap̱ig. “Ad emaitakp̱a atule!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","Ag anam ap̱ig amge Pilatus nug aum. “Aḏinu? Nug aḏi eheḏ heum?” awa aum. Nug anam aum amge ag huanak ena ap̱ig. “Ad emaitakp̱a atule!” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","Aeg amu Pilatus nug doyom, nug heḵunu elele iiṯa. Nug qak ele beḵunu heum amunu nug le awa, danab ah oh amelagp̱a ep̱eg ihaha nug aum. “Danab imu mauhḵu amu dahil hip̱unin iiṯa. Ag ahilag hip̱uninib daaḵu.” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","Nug anam a amu ag ap̱ig. “Am ena, ug amu ig maognig, ihinḵad nid naunau ele ena maoglag,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","Anam aeg amu Pilatus nug Barabas uhuqa madaṯa amu nug a, ag Jesus wipp̱a eheḏ mataḏeg, ag ad emaitakp̱a atulḵulagnu ag ep̱elagp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","Aria gabman oḵainu ban danab ag Jesus aon, gabman dilag oḵai laug oop̱a nop̱ig. Noeg amu ban danab ameg amu laa oh ele uḏin qag mena, Jesus talilidna daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","Anam daanna, ag lamen ena nuhig uḏidna amu gabman dilag lamen kokoḏ laa aḏuiṯeg noum. ");
INSERT INTO gaw_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","Lamen aḏuiṯeg no amu king igip̱an bala bia muḏi qaun elep̱a hewona, igip̱a aḏaeg noum. Aḏaeg no amu ag gumu laa, qaiṯobṯob gumu bia, Nug ep̱eg naḏiapp̱a mep̱ig. Mewona ag gatelag qaun ona, aon aon qeṯan, humidna ap̱ig. “Na am Juda dilag king, na binan ele,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","Ag anam anana, iḏup̱a hununa, gumu Nug medap̱ig amu, ag amu aon, iḵi op̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","Ag aon aon qeṯan malan amu lamen kokoḏ amu uḏidp̱ig. Uḏiṯona, lamen nuhig eḏun aḏuiṯeg no, ag ad emaitakp̱a atulḵulagnu aon gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","Ag aon gonana, wan laa onig Sairini amu ted Simon anidp̱ig. Anidna amu ag nug duṯuna heeg, Jesusnu ad emaitak mawom. ");
INSERT INTO gaw_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","Nug anam mawewe gona, aben laa onig Golgata ap̱a tep̱ig. Golgata diig amu Iḵilag Ebehi. ");
INSERT INTO gaw_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","Ap̱a tena amu ag Jesus wain marasin laa ele koboliak, Nug amu laḵunu meṯaeg, Nug nakok lemaḏup̱a ya anṯa amu Nug baula ii laum. ");
INSERT INTO gaw_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","Aria ag Nug ad emaitakp̱a atulona, ag nuhig lamen aoglagnu amu ag otina, ameg waḏele mewona, aun nug ameg aṯen aoḵu amu ag keeke laa onig dais amup̱a qiḏ hena aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","Amu dimp̱a ag Jesus gumana ap̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","Amu Rom danab ag danab ad emaitakp̱a atulp̱ig ele amu ag aḏi nai ag beḏulagp̱a yaap̱ig ele, danab ag amu anidḵulagnu amu ag ad mahap̱a yaana, ad emaitakp̱a atulp̱ig. Aria Jesus igip̱a ad emaitakp̱a amu nai imu yaan atulp̱ig. “Imu Jesus, Nug Juda Dilag King!” ");
INSERT INTO gaw_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","Ag danab aḏit laa, a am yabhok danab amu, ag a amu Jesus ele oh atuladp̱ig. Ag danab laa ag Jesus ep̱eg naḏiapp̱a atulona, laa amu ep̱eg nanehp̱a atulp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","Aria danab ah ag nug noobp̱a dona wanana, ag iḵilag matuḏna, aon aon qeṯan inam ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“Na am mana meṯak lag lop̱aḏna eḏun deḏ ewamp̱aib heḵutnu ame amunu na anam heḵutnu elele amu na naḵa beḏun uhuqe! Na Kayak beḵa daaṯem dayeb doona amu na ad emaitakp̱anu nep̱e anidtu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","Amubia mana meṯak danab oḵai, ḏo mehuqak danab am Juda iḵi danab oh ele ag Nug aon aon qeṯan ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“Nug danab laa ehanaṯom amge nug nuḵa ehanidḵunu elele iiṯa. Nug am Israel dilag kingde! Nug ad emaitak uua, honap neeb am ig nuhignu oonigp̱a genab doognig. ");
INSERT INTO gaw_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","Nug Kayaknu oop̱a genab dooṯe amunu am Kayak Nug nuhignu oo heeb amu geha iiḵu Nug ehanidḵu. Aḏinu? Nug aum, ‘Da Kayak beḵa,’” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","Am yabhok danab aḏit ele ad emaitakp̱a Jesus guguiṯak atulatp̱ig, a ele awa awa qeṯak nai anamib madipiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","Aria aam ameg tuelpp̱a gatatu wan oh tona male uḵe, tueb aam ameg ewamp̱a batom. ");
INSERT INTO gaw_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","Aria aam ameg ewamp̱a anam amu Jesus Nug bag oḵaip̱a ewa aum. “Eloi, Eloi, lama sabaktani?” Amu diig am inam. “O Mama, o Mama. Aḏinu na da uiḏme?” ");
INSERT INTO gaw_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","Jesus Nug anam e, danab ap̱a Nug guguiṯak daap̱ig ele amu, ag anam doona, ag ap̱ig. “Nug Elias onigp̱a eṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","Ag anam aegeg, laip̱u laa ag oolagp̱anu pahanab aha, qaibaḏ uḵa, yup̱anu keeke laa, nug le huanak eeḏte ele onig span, amu awa, wainp̱a mewowa, awa, gumu laa, qaiṯobṯob gumu bia, amup̱a ita, medaḵunu heum ");
INSERT INTO gaw_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","amge laa ag ap̱ig. “Uup̱e, Elias nug ehanidḵutai o iiṯatai amu anidḵunig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","Ag anam aeg, Jesus baula bag oḵaip̱a ewowa, Nug mauhom. ");
INSERT INTO gaw_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","Nug mauhom haen amup̱a mana meṯak lag oop̱a lamen naḏi aiheg dayom amu gamagp̱anab aṯannu katiḏa uḵa, honap noum. Anam heehe amu wan uḏale, men ele aodp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","Mauhak aben od ele matule, Kayaknu danab tutuḵu laala anuḵa mauhadp̱ig amu eḏun hip̱aidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","Ag moḏp̱anu hip̱aidp̱ig amunu dimp̱a Jesus eḏua hibaiṯe amu ag ahan gona, Jerusalem noeg, danab kuḏum ag anadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","Amu daup 100 dilag iḵi nug amu daup laa ag nug ele daanna, Jesus guman daap̱ig amu ag mim ne, wan uḏalele, keeke laala oh ele beeg anidna, baḏan ap̱ig. “Genab danab imu Nug am Kayak Beḵa!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","Aria ah kuḏum laa ag Jesus ehanidḵulagnu Galelianu dim lamidna gop̱ig ele amu, ag piḏe, keeke aḏi beeb amu anidḵulagnu daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","Ag oolagp̱a laa amu Maria, Magdala ted, laa amu Maria, Jakobus Josep ele anilah, laa amu Sebedi bekoḏ amu anilah. ");
INSERT INTO gaw_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","Aria tueb me, Arimatia ted onig Josep, nug am danab enub ele amu, nug uḏiom. Nug ele am Jesusnu ip̱uniṯak awak danab. ");
INSERT INTO gaw_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","Nug Pilatus gumiṯa uḵa, Jesus gaḏa aoḵunu oḏ meṯom. Oḏ meṯe, Pilatus nug daup amelagp̱a a, ag Jesus gaḏa Josep medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","Ag Josep meṯaeg, nug Jesus gaḏa awa, linen lamen baup̱a itom. ");
INSERT INTO gaw_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","Nug itowa, nuhig men moḏ bau babaiṯom amup̱a meum. Mewowa, men oḵai laa buḏibḏib meṯe uḵa, men moḏnu oḏe tonom. Nug anam hewowa amu nug uḵom. ");
INSERT INTO gaw_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","Aria nug anam heehe amu Maria, Magdala ted amu Maria laa ele a moḏ guguiṯak ap̱a daapiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","Amu Juda dilag Meṯidnu bap̱aidp̱ig ele, deḏ amu uue, mana meṯak iḵi am nai mehuqak danab ele ag gona Pilatus laugp̱a qag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","Qag mena ag ap̱ig. “Naḏi, ig ham bup̱uak danab amu, nuhig nai laa daunigp̱a doum. Nug bau dayaya Nug, ‘Deḏ ewamp̱a da eḏue hip̱aidḵul,’ aum ");
INSERT INTO gaw_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","amunu nuhig ip̱uniṯak awak danab ag gona, gaḏa awona, ag danab amelagp̱a, ‘Nug eḏua hibaiṯom,’ amananu, na ap̱e, ag moḏ amu hag mena, ep̱onak keeke laa hep̱eg dayeb uḵeb, deḏ ewam bataḏ! Nuhiḵud ip̱uniṯak awak danab ag, ‘Nug eḏua hibaiṯom,’ ap̱eg amu nai ham bup̱uak dimp̱anu amu nai ham bup̱uak tatamnu amu eḏidḵu,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","Ag anam aeg am Pilatus nug aum. “Ag gumak danab diina, ag moḏ amu ameg manakib daaḵunu aḏi heḵulagnu elele dooṯeb amu ag gona anamib aaḵu heig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","Nug anam a, ag gona, hag maknu ep̱onak keeke laa menp̱a mewona, ban danab laa maaṯeg, moḏ amu guman daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","Juda dilag Meṯid deḏ Sarere amu uḵa male, Meṯidp̱a buṯua aam beḵunu heehe, Maria, Magdala ted amu Maria laa ele a moḏ anidḵulahnu gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","Uḵeheh am mim oḵai neum. Aḏinu? Kayaknu engel laa hab aṯannu na, moḏ ameg kola, men amu qaḏep̱a heḏep na dayom. ");
INSERT INTO gaw_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","Nug iḏu am amemḏi bia amahlom. Nuhig lamen amu haḵabnab ais bia. ");
INSERT INTO gaw_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","Ban danab ag nuhignu baḏaeg, beḏulag hahaḏeḏe, danab mauhak bia niip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","Am engel nug ah aḏit amelahp̱a aum. “A aib baḏapiḏ! Da dooṯem, a Jesus, ad emaitakp̱a atulp̱ig ele amu, Nug madiṯep. ");
INSERT INTO gaw_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","Nug ip̱a ii daaṯe, nug anuḵa aum bia eḏua hibaiṯom! A doya, Nug niiom aben iiḵud anṯeḏ! ");
INSERT INTO gaw_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","Antoya am pahanab goya, nuhiḵud ip̱uniṯak awak danab amelagp̱a, ‘Nug moḏp̱anu eḏua hibaiṯom!’ aoya aiḏ! Doyeḏ! Nug anuqa Galelia uḵeb, ag Nug ap̱a anidḵulag! Da geha iiḵu a amelahp̱a aṯem!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","Engel anam a amu ah aḏit a oṯaiya baḏaya, oolah gamag ele ahehe, moḏ uuya, nuhiḵud ip̱uniṯak awak danab amelagp̱a aḵulahnu qaiqaḏ gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","A anam uḵaeheh am Jesus ib manp̱a a gumata do, a ele nug uḏa tena amu Nug, “Buṯua ena,” awa aum. Jesus anam a amu a Nug guḵuidya waya, baeg aḏai daaiya, binag mepiḏ. ");
INSERT INTO gaw_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","A anam heeheh amu Jesus Nug a amelahp̱a aum. “A aib baḏapiḏ! Goya, da awalad amalad amelagp̱a apeḏ doona, ag gona, Galelia ap̱a da aniḏeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","Aria ah aḏit uḵaeheh, ban danab laala ag Jerusalem nona, ag keeke aḏi aḏi beum amu oh mana meṯak iḵi danab amelagp̱a ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","Amelagp̱a aeg amu mana meṯak iḵi danab amu Juda iḵi danab ele ag qag mena, nai maṯin amu ban danab men doḏo oḵai maṯana ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“Ag, ‘Ig niiutut, nuhiḵud ip̱uniṯak awak danab tuqan uḏin, Nug gaḏa yab aop̱ig,’ aon aig! ");
INSERT INTO gaw_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","Aria gabman oḵai Pilatus nug nai amu doya heeb amu ig nug amegp̱a imunu aḵunig amunu ag ug laa ii anidmana,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","Anam aeg amu ban danab ag men doḏo aona, ag mana meṯak iḵi danab ag aḏi heḵulagnu ap̱ig amu anamib hep̱ig. Anam heeg amu nai amu Juda danab kuḏum doon malaeg uḏie, gemu ele madiṯeb. ");
INSERT INTO gaw_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","Aria ip̱uniṯak awak danab elewen ag Galelia ap̱a qauko laap̱a, Jesus goḵulagnu aum, amup̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","Gona, ap̱a ag Nug anidna, binag mep̱ig amge laala ag oolagp̱a dab mak aḏit ele dayom. ");
INSERT INTO gaw_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","Anam heegeg, Jesus Nug ag gumaṯa doa, amelagp̱a aum. “Kayak Nug da keeke oh iḵilag daaḵulnu meiḏom ");
INSERT INTO gaw_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","amunu ag gona, wan atu ohp̱anu danab ah hep̱eg, dahilad ip̱uniṯak awak danab ah daap̱eg, ag Mama onigp̱a, Nug Beḵa onigp̱a amu Kayak Ouḏi onigp̱a layaṯeg! ");
INSERT INTO gaw_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","Ag keeke oh da ag heḵulagnu amelagp̱a ami amu, ag amu oh ele ip̱uanaṯeg! Ag doyeg! Da haen oh ag ele daap̱ut uḵeb, gog tak haenp̱a bataḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","Kayak Beḵa Jesus Kristusnu Nai Ena amu inam niiṯe. ");
INSERT INTO gaw_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","Anuḵa Kayak Nug propet laa onig Jesaia amegp̱a aum. Kayak Nug Beḵa Jesus amegp̱a alo amubia Jesaia amegp̱a a, Jesaia nug nai amu inam awa yom. “Anṯe! Da hep̱i dahil nai awa uḵa maṯiaknu danab laa nug na noom awa, nahip ib bap̱aidḵu. ");
INSERT INTO gaw_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","Nug am atu taḏakp̱a dayaya, danab amelagp̱a inam ewa aḵu. ‘Ag oolagp̱a ihinig Naḏinu ib bap̱aidp̱eg, elele dayaḏ!’ awa aḵu.” Jesaia anam awa yom. ");
INSERT INTO gaw_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","Kayak Nug anam aum dimp̱a Nug aum bia, Layaṯak Johanes nug atu taḏakp̱a dayaya, nug danab amelagp̱a, Kayak Nug ahilag hip̱unin uhuqa madaḵunu ag oolag eḏueb, layaṯak aoglagnu nai mehuqom. ");
INSERT INTO gaw_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","Nug nai anam mehuqom amu Juda wanp̱an danab laa oh amu Jerusalemnu danab laa oh ele ag Johanes gumidna gona, hip̱unin ahilag miag aegeg, Johanes nug Jodan lep̱a layaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","Nug lamen kamel uḏigp̱a hak amu ma, nug imuagp̱a maṯagiḏ, doḏ gaḏap̱a hak, amu ele taḵa, nug tap amu up̱uh lep̱u ele laṯom. ");
INSERT INTO gaw_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","Anam dayaya amu nug danab amelagp̱a aum. “Danab laa nug da dimulp̱a uḏiṯe amu danab amu nuhig g̱agaṯag amu dahil eḏidṯe, Nug am danab oḵainab, da am oḵai iiṯa. Dahil hak imu nuhig hak amu ele elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","Da ag lep̱a layadṯem amge Nug Kayak Ouḏip̱a ag layadḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","Nug anam a amu haen amup̱a Jesus Nug Galelia wanp̱a Nasaret abp̱anu aha uḏie, Johanes nug Jodan lep̱a laaiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","Laaiṯa male, Jesus Nug lep̱anu aha, audam teete amu hab obate, Kayak Ouḏi Nug ai up̱uḏil bia nuhigp̱a neene, anṯom. ");
INSERT INTO gaw_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","Kayak Ouḏi Nug ne, baag laa hab aṯannu Nug amegp̱a aum. “Na am da beḵal, da nahipnu ool mauhṯe. Nahip haknu ele amu da ool ena daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","Haen amup̱a pahanab Kayak Ouḏi Nug he, Jesus Nug atu taḏakp̱a uḵa, ");
INSERT INTO gaw_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ap̱a deḏ 40 dayeye, Satan nug Jesus eheḏ heḵunu oo eeḏeḏe, Jesus Nug doḏ daḵuḏ oolagp̱a dayeye, engel ag nug ehanidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","Aria haen amu male amu Herodes nug Layaṯak Johanes mani guiṯakp̱a me dayeye, Jesus Nug aha, Kayaknu Nai Ena mehuqaqa, Galelia uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","Nug nai mehuqa aum. “Haen malom, Kayaknu ḏo maḏoḏ haen aaḵu miag doum amunu ag ahilag hak nau uuna, oolag eḏueb, Nai Enanu oolagp̱a genab doyeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","Deḏ laa Jesus Nug Galelia le ameg ihip̱a oiyaya, Nug Simon amu Andreus ele, a am eamag amu, Nug a ahilah uhui lep̱a eeheh anatom. A am kakai awak danab amunu a uhui epiḏ. ");
INSERT INTO gaw_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","Jesus anata amu Nug amelahp̱a aum. “Doya, da dim lamiḏpeḏ, da a danab diiaknu uḏat ip̱uanatḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","Nug anam a amu a paha ahaya, uhui ahilah uuya, Jesus dim lamidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","Dim lamiṯeheh, Jesus Nug nakok laa ele wana, nug Sebedi bekoḏ Jakobus amu Johanes ele, a ele am eamag amu, Nug a ub ahilahp̱a daaiya, uhui bap̱aiteheh anatom. ");
INSERT INTO gaw_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","Anata amu Nug ahilahnu ele aum. “A da dim lamiḏeḏ!” Nug anam a amu a ahai, a mamelah Sebedi, amu ahilḵad uḏat danab oh ubp̱a daap̱ig ele amu uuadya, Jesus dim lamidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","Aria ag Jesus dim lamiṯeg, ag oh eḏun Kapenaum gop̱ig. Gona daanna, Nug Meṯidp̱a Juda dilag nai doyak laḵa ap̱a ta, Kayaknu nai ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","Ip̱uanaṯe, Juda danab ag dab mak kuḏum aop̱ig. Aḏinu? Nug nuḵa keeke oh ha anṯom bia ip̱uanaṯom. Juda dilag ḏo mehuqak danab laa ag amubia ii hedap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","Ag anam nai doyak laḵa ap̱a daaegeg, danab laa nug ouḏi nau ele ap̱a dayaya ewa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","“Jesus, Nasaret ted, na ig aṯem heigḵutnu uḏime? Na hep̱e, ig nauhḵunignu uḏimete? Da na dooidṯem, na am Kayaknu Laa, Op̱ia Awak Ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","Nug anam a amu Jesus Nug ouḏi nau amegp̱a aum. “Na oḏen qamutna, danab amu uuidna uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","Jesus Nug anam a amu ouḏi nau nug he, danab beḏu huan hahaḏeḏe, ouḏi nau nug baag oḵaip̱a ewawa, danab amu uuiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","Uuiṯa male amu danab laa ag danab amu anidna, dab mak kuḏum aona amu ag aḵa aḵa Jesusnu ap̱ig. “Imu aḏi? Imu doyak laa, ebehi ele. Nug ehah ena ele amu diig amunu Nug ouḏi nau amelagp̱a, ‘Ag uḵeg!’ aṯe amu ag nuhig nai dim lamidṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","Ag anam anidna, nai amu tuḏiṯeg uḵe, Galelia wannu danab oh doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","Jesus Nug danab ehaniṯe, Nug ip̱uniṯak awak danab Simon, Andreus, Jakobus, Johanes ele ag ahan, Juda dilag nai doyak lag amu uuidna, tutuḵu Simon Andreus ele laulahp̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","Ag gona, laḵa teegeg, ag Simon nome nug oḏe, beḏu gaḵaḏak ele niieye, ag Jesus amegp̱a aeg, nug doyom. ");
INSERT INTO gaw_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","Aeg doya amu Jesus Nug gumiṯa wana, ep̱egp̱a aḏa, maḏ eṯe ahe, beḏu gaḵaḏak paha iiṯa me, aaḵu ah amu nug uḵa, e ahilag babaiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","Aria tueb amu aam no, ap̱an danab ag ahan, oḏe danab amu danab ouḏi nau ele oh omaladna, Jesus top̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","Ag gona, Simon Andreus ele a laulah odp̱a qag meeg, ");
INSERT INTO gaw_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","Jesus Nug oḏe danab kuḏum ag oḏe diigdiig ele amu bap̱alaṯaṯa, laa ouḏi nau ele amu Nug ouḏi nau amu lamaṯom. Lamaṯe amu ag Nug doop̱ig amunu Jesus Nug he, ag amunu ii ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","Aria wagḏe buṯuanab Jesus Nug laḵanu aha, ab uua, aben danab haen oh ii daaṯebp̱a uḵa, unuqiṯaṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","Dayeye, nakok dimp̱a Simon laiḵud ele ag Jesus maṯin ");
INSERT INTO gaw_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","anidna, Nug amegp̱a ap̱ig. “Danab oh ag na maṯidṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","Aon aeg amu Jesus Nug aum. “Ip̱an danabib nai dahil dooglagnu amu da ool ii daaṯe amunu ig ahat, ab laala miag daaṯeb ele amup̱a da nai dahil mehuqḵulnu goḵunig. Da amunu uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","Nug anam anana amu Nug aha, Galelia wan oh taliliṯa oiyaya, Nug Juda dilag nai doyak laḵa laalap̱a nai mehuqaqa, ouḏi nau danab ag beḏulagp̱a daap̱ig amu ele lamaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","Dimp̱a deḏ laa danab laa nug gaḏa oḏe ele amu nug Jesus noobp̱a uḵa, gateg qaun wa, nug oḏ meṯa aum. “Na oot heeb amu na hep̱e, da oḏe dahil iiṯa meḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","Nug anam oḏ meṯe amu Jesus Nug oo doye, Nug ep̱egp̱a danab beḏu aḏa, amegp̱a aum. “Da ool anam daaṯe! Na ena daye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","Awa a amu pahanab oḏe amu iiṯa me, danab nug elele dayom. ");
INSERT INTO gaw_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","Elele dayeye, Jesus Nug ḏo g̱agaṯag danab amu amegp̱a inam aum. ");
INSERT INTO gaw_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","“Na danab laa amegp̱a da na bap̱aidminu amu aib ame. Iiṯa, na gona, na beḏun mana meṯak danab ip̱unidna, na Mosesnu ḏo aṯe bia na doḏ main, Kayak meṯe! Aḏinu? Danab oh ag amup̱a dooglag na oḏe iiṯa,” awa aum. Jesus Nug ḏo g̱agaṯag anam mewowa, he uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","Jesus anam aum amge danab amu nug Jesus oḏe bia ii heum. Iiṯa nug uḵa, danab kuḏum amelagp̱a a doop̱ig amunu Jesus Nug abp̱a miag oiḵunu elele iiṯa. Nug aben danab haen oh ii daaṯebp̱a dayom amge ap̱a ele danab kuḏum Nug gumidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","Anam dayaya, deḏ laa dimp̱a Jesus Nug aha, eḏua Kapenaum uḵe, ap̱an danab ag Jesus uḏiom daaṯe amu doona, ");
INSERT INTO gaw_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ag ahan, lag Nug dayom ele amup̱a gona qag mep̱ig. Kuḏum gop̱ig amunu lag oop̱a dimiṯim ele ag aben oh itup̱ig. Itun daaegeg, Nug Kayak nai mehuqom. ");
INSERT INTO gaw_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","Nug nai mehuqeqe, danab waḏele laa ag lailag oḏe ele, nug baeg ep̱eg mauhak ele, qaḏaqaḏp̱a maon, Jesus top̱a uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","Uḏieg, ag lag Jesus dayom ele, amup̱a danab kuḏum ituak daap̱ig amu ag amup̱a tena, Jesus gumidna waḵulagnu ib iiṯa amunu ag lailag amu maon, lag aṯan tena, lag amu koḏoḵo uḏem meṯak ele amunu ag tena, lag koḏoḵo lop̱aḏna, oḏe danab qaḏaqaḏ ele muḏip̱a qaḵan, Jesus noobp̱a paḏaeg noum. ");
INSERT INTO gaw_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","Paḏaeg noum amu Jesus Nug oop̱a genab doyak ahilag am oḵai ele anṯa, Nug oḏe danab amegp̱a aum. “Nahip hip̱unin oh amu da uhuqe medaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","Nug anam a amu ḏo mehuqak danab ap̱a daanna, ag aḵa aḵa dab makp̱a inam ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“Danab imu Nug aḏinu anam aṯe? Nug Kayak dabiṯa, awa awa qeṯe. Kayak Nug nuḵa hip̱unin uhuqa megaḵunu elele,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","Ag dab mak amu aoegeg, Jesus Nug nuhig dab makp̱a amu doya, Nug ag amelagp̱a aum. “Ag aḏinu dab mak nau anam aoṯeb? ");
INSERT INTO gaw_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","10","Aḏi nai am anaknu ug iiṯa? Hip̱unin uhuqa meṯaknu nai amute am ug iiṯa, o iiṯa aha tap̱a uḵaknu nai, amutai am ug iiṯa? Amu oh iiṯa. Aḏit oh am ug ele, danabib heḵunu elele iiṯa amunu ag Danab Beḵalag da, da wan imup̱a hip̱unin uhuqen madaḵulnu g̱agaṯag ele, ag amu dooglagnu amu da hep̱i, aha goḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","Jesus Nug anam anana amu Nug eḏua, oḏe danab amegp̱a aum. “Na ahan, qaḏaqaḏ nahip aon, laḵa uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","Nug anam a amu oḏe danab nug aha, qaḏaqaḏ nuhig awa, ag noolagp̱a dimiṯim uḵom. Ugeḵe amu ag dab mak kuḏum aona, Kayak binag mena ap̱ig. “Ig deḏ laa keeke amubia ii anidmut,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","Aria Jesus baula eḏua, le ameg Galelia ihip̱a oiyeye, danab ah laala ag gumidna uḵaeg, Jesus Nug Nai Ena ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","Ip̱uanaṯowa amu Nug aha, wana oiyaya, Nug Alpias beḵa Lewi, nug takis awak laḵa dayeye anṯom. Anṯa, Jesus Nug amegp̱a aum. “Na dona, da dim lamiḏe!” awa aum. Anam a amu nug Jesus dim lamiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","Dimp̱a Jesus Nug nuhiḵud ip̱uniṯak awak danab ele amu ag Lewi laugp̱a e laegeg, takis awak danab kuḏum, hip̱unin danab kuḏum amu danab laa ag Juda dilag ḏo oh ii dim lamidp̱ig, amu ele kuḏum uḏieg, Jesus amu nuhiḵud ip̱uniṯak awak danab ele e lap̱ig. Aḏinu? Ag kuḏum ag Jesus dim lamidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","Aria ag e lanan daaegeg, ḏo mehuqak danab amu ḏo gumak danab-Parasia ele ag anadna, Jesusnu ip̱uniṯak awak danab oḏ madap̱ig. “Aḏinu Jesus Nug takis awak danab, hip̱unin danab amu danab ag ihinig ḏo oh ii dim lamidṯeb ele amu, Nug ag ele oh daanna, e lanana, le ele laṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","Aon aeg amu Jesus Nug doya, amelagp̱a aum. “Danab oḏe iiṯa, nug dokta top̱a ii goṯe. Iiṯa, danab nug oḏe ele nug goṯe. Amubia amu da hep̱i, danab kobol tutuḵu enaib heṯeb ele, ag oolag eḏuḵunu ii uḏimi. Iiṯa da hep̱i, danab kobol tutuḵu ena ii heṯeb ag oolag eḏuḵunu uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","Aria Layaṯak Johanesnu ip̱uniṯak awak danab amu ḏo gumak danab-Parasia, ahilag ip̱uniṯak awak danab ele ag deḏ kuḏum e oh lanaknu kud mena daadṯap̱ig. Ag anam daaegeg amu deḏ laa danab laala ag Jesus top̱a gona, Nug oḏ medap̱ig. “Aḏinu Johanesnu ip̱uniṯak awak danab amu ḏo gumak danab-Parasia, ahilag ip̱uniṯak awak danab ele ag hanhan e oh lanaknu amu kud men daaṯeb amge nahip ip̱uniṯak awak danab ag anam ii heṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","Ag Jesus oḏ anam medap̱ig amu Jesus Nug aum. “Da am danab nug ah aoṯe bia. Aria dahil ip̱uniṯak awak danab amu ag am da lailad. Amu ig dooṯem, nug awak haen amu oo gamag ahak ele amunu danab nug ah aoṯe amu, nug laiḵud ele ag ug doonna, e oh lanaknu kud mena daaglagnu amu iiṯa. Ag oolag gamag ahak ele amunu ag e ii uumna, ag laḵulag. ");
INSERT INTO gaw_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","Anam aaḵu daaṯe amge deḏ laa dimp̱a ag lailag ah awom ele amu, nug laih uḵeb amu haen amup̱a ag oolag ug ele amunu ag e oh lanaknu kud mena daaglag. Amu da ami. Da am danab ah aoṯe bia. Dahil ip̱uniṯak awak danab ag am da lailad bia. Da gemu ag ele daaṯem amunu ag e oh lanaknu kud mena daaglagnu elele iiṯa. Dimp̱a da gop̱i, ag anam heḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","Nug anam anana amu Nug nai tuḏiṯa aum. “Danab nug lamen qaṯi bau awa, lamen alagnu giḏo amup̱a tona ii koit-ṯe. Iiṯa! Nug anam helo amu dimp̱a nug lamen iheb, lamen bau nug eḏua, nakok ep̱a, lamen alag eeḏeb, paṯiḏeb, giḏo oḵai ele daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","Anam anana amu Nug nai keeke amunu baula inam aum. “Laa ele amu danab nug grep lep̱u bau le itaknu doḏ gaḏa alagp̱a ii inaṯe. Nug anam helo amu grep lep̱u nug eḏua, wain baaba, titiḏa heebeb, doḏ gaḏa alag nug g̱agaṯag ep̱om, oḵai meḵunu elele iiṯa amunu nug aoḏeb, wain amu doḏ gaḏa ele oh iiṯa meḵulah. Ag anam ii heṯeb. Grep lep̱u bau amu le itaknu doḏ gaḏa baup̱a inaglagnuib daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","Aria deḏ laa Meṯidp̱a Jesus nuhiḵud ip̱uniṯak awak danab ele ag ibp̱a wit dad laa oop̱a gonana, danab tuelp ag wit aeg laala aon lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","Anam heegeg amu ḏo gumak danab-Parasia ag Jesus oḏ medap̱ig. “Ḏo nug danab laa Meṯidp̱a e daṯanu ii aoma ip̱unigṯe amunu aḏinu nahipad ip̱uniṯak awak danab ag Juda dilag Meṯidnu ḏo amu tip̱alna, e aon laṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","26","Ag anam oḏ meṯaeg amu Jesus Nug amelagp̱a aum. “Ag Dawitnu nai nakok laa iite eb qep̱ig? Haen amup̱a Abiata nug mana meṯak danab dilag iḵi dayeye, Dawit nug laiḵud ele ibp̱a oiyegeg, enug aqeqe, ag gona, Abiata dayomp̱a tena, Dawit nug Kayak laug oop̱a noa, bret hag ele, mana meṯaknu danab agib laḵulagnu elele, amu awa lanana, nug laiḵud ele maṯe, oh lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","Amunu ag dooglag. Meṯid deḏ nug anuqak ii daaṯe. Iiṯa, danab nug Meṯid deḏ eḏiṯa anuqak daaṯe. Da danab eḏaṯen gumadṯem ");
INSERT INTO gaw_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","amunu da Meṯid deḏ ele gumaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","Deḏ laa Meṯidp̱a Jesus Nug Juda dilag nai doyak laḵa noa, danab laa nug ep̱eg nau, mauha ebehiṯak ele, ap̱a dayeye anṯom. ");
INSERT INTO gaw_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","Ḏo gumak danab-Parasia ag ele ap̱a daanna, Jesus Nug aḏi heeb anidḵulagnu meidp̱ig. Nug Meṯidp̱a danab ep̱eg nau ele ehaniṯeb, elele dayeb amu ag Jesus heṯoḏiak abenp̱a meḵulagnu oolag dayom. ");
INSERT INTO gaw_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","Anam daaegeg, Nug danab ep̱eg nau ele amegp̱a aum. “Na ahan, gamagp̱a hip̱aidna daye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","Nug anam a amu danab nug hibaiṯa dayeye, Jesus Nug ḏo gumak danab-Parasia oḏ maṯom. “Ḏo ihinig aḏi aṯe? Ig Meṯidp̱a ena heḵunig am enatai o iiṯa ig Meṯidp̱a eheḏ heḵunig am enatai? Ig hep̱ut danab mauhḵu amuam enatai o iiṯa ig hep̱ut, danab laa nug mauhḵunu heṯe ele amu nug elele daaḵu amuam enatai?” awa aum. Nug anam oḏ maṯe amu ḏo gumak danab-Parasia ag Jesusnu oḏ mak amunu nob meḵulagnu oolag ii dayom amunu ag to eṯan, hamu daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","Ag to eṯan daaegeg, Jesus Nug neeḵa anaṯowa, ag oo doyak iiṯa, ag danab ehanidḵulagnu oolag ii dayom amunu Nug op̱oḏi be, oop̱a guiṯak doyaya, Nug danab ep̱eg nau ele amegp̱a aum. “Na ep̱en tai eṯe!” awa aum. Jesus Nug anam a amu danab amu nug ep̱eg tai eṯe, ep̱eg eḏua, laih bia, ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","Jesus anam heum amunu ḏo gumak danab-Parasia ag ahan uḵaeg, Herodes laiḵud ele qag mena, Jesus qeḵulagnu ib madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","Jesus Nug anam he amu Nug nuhiḵud ip̱uniṯak awak danab ele ag ahan, ab amu uun, Galelia le amegp̱a uḵaegeg, ");
INSERT INTO gaw_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","Galelianu danab, Judanu danab, Idumianu danab, Jodan le laihp̱an danab, Jerusalemnu danab, Taianu danab amu Saidonnu danab ele, ag oh Jesus kobol heṯom doop̱ig amunu ag Nug anidḵulagnu dim lamidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","Ag kuḏumnab gop̱ig amunu Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Danab kuḏum qataeṯak daana, hautiḏmananu amu ag ub nakok aon dop̱eg, kobol anam beeb amu da ubp̱a teḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","Aḏinu danab ag Jesus hautḵulagnu hep̱ig? Jesus Nug oḏe danab kuḏum bap̱alaṯom amunu deḏ amup̱a ele oḏe danab kuḏum danab ah oolagp̱a daanna, Jesus gumidna wana, Nug beḏu aḏaglagnu wagai mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","Amu danab laala ag ouḏi nau ele ag Nug aniṯeg, ouḏi nau ag heegeg, ag Jesus noobp̱a nena qena, wanp̱a niiegeg, ouḏi nau danab beḏulagp̱a daap̱ig ele amu, ag ep̱ig. “Na Kayak Beḵa,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","Anam aeg amu Jesus Nug am Kayak Beḵa amu ag amunu miag atiak ii amananu, ḏo g̱agaṯag maṯom. ");
INSERT INTO gaw_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","Deḏ laa Jesus Nug qaukop̱a ta, nuhiḵud ip̱uniṯak awak danab diiḵunu oo dayom ele amu, Nug ag onilagp̱a e, ag Nug gumidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","Nug danab tuelp Nug ele daaglagnu tituanaṯa, Nug aum. “Da ag maadp̱i, ag gona, nai ena dahil mehuqḵulagnu tituanadmi. ");
INSERT INTO gaw_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","Laa ele, da ouḏi nau lamadḵulagnu g̱agaṯag ele madaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","Nug danab tuelp tituanaṯom amu ag onilag am inam. Tatam am Simon amu Jesus nug onig laa Petrus ataḏom. ");
INSERT INTO gaw_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","Aḏit laa amu Sebedi bekoḏ Jakobus Johanes ele. Jesus Nug a onilah laa Boanesis ataḏom. Onig amu nuhig meu amu, “Haḵaḏ bekoḏ.” ");
INSERT INTO gaw_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","Laa oh onilag am Andreus, Pilipus, Batolomiu, Mateus, Tomas, Alpias beḵa Jakobus, Taidius, Simon, nug am Selot, ");
INSERT INTO gaw_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","amu Judas Iskariot ele. Nug am Jesus kekeḏ ep̱elagp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","Aaḵu Jesus Nug eḏua laḵa uḵa dayeye, danab ah kuḏumnab ele qag mep̱ig. Qag mena daaegeg amu Jesus Nug uḏat haaha, e nakok laa awa, laḵunu haen elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","Anam dayeye, Nug anig amaḵud ele ag amu doona, ag ahan, Nug omalna goḵulagnu uḏip̱ig. Aḏinu? “Nug kaaka qeum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","Ag anam aegeg amu Juda dilag mehuqak danab ag matu Jerusalemnu nep̱ig amu ag Nug heumnu inam ap̱ig. “Amu Belsebub, nug am ouḏi nau iḵilag, nug danab imu beḏup̱a daaṯe. Daaṯe amunu Nug g̱agaṯag amup̱a ouḏi nau lamadṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","Ag anam aeg amu Jesus Nug he, ag gumidna doeg, Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa nai amup̱a amelagp̱a inam aum. “Satan nug aṯemun Satan lamidḵunu elele? ");
INSERT INTO gaw_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","Wan laip̱up̱an danab ag ahan op̱atna, ameg aḏit bena, nug qeḵulag amu wan amu nug ena ii daama. ");
INSERT INTO gaw_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","O ab iḵi laa ele anam. Ag op̱atna, ameg aḏit bena, nug qeḵulag amu ab iḵi amu nug na qeḵu. ");
INSERT INTO gaw_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","Aria Satan ele anam. Nug laiḵud ele ag op̱atna, laih laih daanna, ban heṯeb dayeb amu ag daaglagnu elele iiṯa. Ag iiṯa meḵulagnu daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","Danab nug danab g̱agaṯag ele, nug laugp̱a hamu noa keeke laa ii aoṯe. Nug tatam danab g̱agaṯag ele muḏip̱a hip̱alowa, nug danab amu laugp̱a noa, keeke yab aoḵu. Amubia da Satan eḏiṯak daaṯem amunu da nuhiḵud daup lamadḵulnu elele daaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","Jesus Nug anam anana amu Nug nai baula tuḏiṯa aum. “Da genab ag amelagp̱a aṯem. Kayak Nug ahilag hip̱unin, amu nuhignu amu nuhig keekenu ele dabiṯa awa awa qeṯak nai ahilag oh ele amu Kayak Nug uhuqa madaḵu ");
INSERT INTO gaw_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","amge laa nug Kayak Ouḏi dabiṯa, awa awa qeṯeb amu Kayak Nug hip̱unin amu uhuqa ii meṯama. Hip̱unin amu iiṯa ii mema, hanhan daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","Ag, “Jesus Nug ouḏi nau ele,” ap̱ig amunu ag Kayak Ouḏinu anam amananu, Jesus Nug anam amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","Jesus Nug anam anan dayeye amu Nug anig amaḵud ele uḏina, dimiṯim daana, Jesus gumaṯa doḵunu danab laa amegp̱a aeg, nug danab daap̱ig ele amu, ag amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","Danab ah kuḏumnab ag Jesus talilidna daanna, nai amu doona, Jesus amegp̱a ap̱ig. “Na anin amapad ele na anidḵulagnu uḏin, dimiṯim daaṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","Aon aeg amu Nug aum. “Da anil amalad ele am aun aḏi?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","Nug anam anana amu Nug neeḵa oiyaya, ag talilidna daap̱ig amu anaṯa, Nug aum. “Anṯeg! Imu amu da anil amalad ele. ");
INSERT INTO gaw_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","Danab laa nug Kayaknu dab mak dim lamidṯe amu nug am da anil, amal, ap̱inal ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","Aria Jesus Nug Galelia le ameg ihip̱a mehuqak uḏat dig meum. Dig me amu danab ah kuḏumnab uḏin qag mep̱ig amunu Jesus Nug ubp̱a teum. Nug te, danab ah ag le ihip̱a daaegeg, ");
INSERT INTO gaw_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, nai amubia kuḏump̱a mehuqaqa, inam maṯiom. ");
INSERT INTO gaw_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“Ag nai imu doona maidḵulag. E ep̱ak danab nug e haḏag ebaḵunu aha, ");
INSERT INTO gaw_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","daṯa uḵa oiyaya, e haḏag taoḏom. Nug taoḏa ugeḵe, haḏag laala amu danab ib oiṯebp̱a nena qena niiegeg, ai ag uḏin, haḏag amu lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","E haḏag laala ag wan men duqe uḵak amup̱a nena qep̱ig amu wan unuqag iiṯa amunu pahanab bep̱ig ");
INSERT INTO gaw_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","amge aam na qe, ag diḏilag wan oop̱anab ii noum amunu bunaḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","Aria e haḏag laala ag wan muḏi qaun elep̱a nena qeeg, muḏi qaun ba, naḏi ma, teguaṯe, bunaḏna, meu ii op̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","E haḏag laala ag wan enap̱a nena qena, ena bena, meu op̱ig. Haḏag laip̱u laa beum amu nug aeg tieti oom, laa am siksti oom amu laa am wan handat oom.” Jesus Nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","Nug anam anana Nug baula ele aum, “Danab nug daug ele dayeb amu nug doyaḏ!” ");
INSERT INTO gaw_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","Jesus Nug anam a amu dimp̱a Nug amu nuhiḵud ip̱uniṯak awak danab tuelp amu nug laiḵud laala ele ag aḵa daanna, ag Jesus nai aum amunu oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","Oḏ meṯaeg amu Jesus Nug aum. “Ag am Kayaknu ḏo maḏoḏnu keeke diig loḵumak amu dooglagnu maṯom amunu ag dooṯeb amge danab laala, ag dahil nai dim ii lamidṯeb, ag nai danab nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanadṯe, nai amup̱aib anidṯeb ");
INSERT INTO gaw_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","amunu Jesaia nai yom, nai amu elele medaṯe. Nai am inam. ‘Ag neegṯeb amu ag diig tutuḵu ii anidṯeb. Ag nai daulagp̱a dooṯeb amu ag diig aṯemun tutuḵu ii dooṯeb. Ag doyaknu uuṯeb. Ag anam ii helob, ag nai dahil doona, ag oolag eḏueb, Kayak Nug ahilag hip̱unin uhuqa maṯalo,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","Jesus Nug anam anana amu Nug Nai baula tuḏiṯa aum. “Da keeke danab ag dooṯeb ii dooṯeb ele ou aqaten ip̱uanaṯen ami amu, nai amuam ug iiṯa amge ag meunab nuhig ii doop̱ig amunu dimp̱a da nai amubia amge g̱agaṯag ele madip̱i, ag aṯem oolag maidḵu? ");
INSERT INTO gaw_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","Danab nug Kayak nai mehuqṯe amu nug am danab e ebṯe bia. ");
INSERT INTO gaw_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","Haḏag laala ibp̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab laala ag nai dooṯeb amge Satan nug paha ag oolagp̱a noa he, Kayak nai iiṯa meṯe. ");
INSERT INTO gaw_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","Amu e haḏag men duqe uḵakp̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab laa ag nai doon, oolag gamag ahehe, pahanab aoṯeb ");
INSERT INTO gaw_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","amge ahilag oop̱a genab doyak am g̱agaṯag iiṯa, haen tutunuib amunu deḏ laa ag dahil nai dim lamidṯeb, diig amunu ug laa beṯe, o danab laala ag heeg, qagaeṯak dooṯeb amu ag pahanab ahilag oop̱a genab doyak paḏaṯeb. ");
INSERT INTO gaw_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","E haḏag wan muḏi qaun elep̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab amu ag nai dooṯeb ");
INSERT INTO gaw_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","amge ag wan imup̱an ug laala, amu enub awak uḏat amu ameg qak kobol ele, keeke amu oh ag oolagp̱a he, Kayak nai iiṯa ma, meu ii oṯe. ");
INSERT INTO gaw_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","Aria e haḏag wan enap̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab laa ag nai doonna, aon oolagp̱a meṯeb amu ag meu ena oṯeb, laa tieti, laa siksti, laa handat, anam oṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","Aria Jesus Nug nai imu ele maṯiom. “Danab laa nug lam amota, tap̱iḏ oḵai waap̱a o iiṯa balal waap̱a meṯete? Iiṯa! Nug amota, aṯan me eoṯe. ");
INSERT INTO gaw_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","Amubia gemu keeke laa loḵumak daaṯeb amge dimp̱a miag atiglag. Keeke oh danab ag loḵump̱ig daaṯeb amu dimp̱a ag miag atip̱eg, danab oh anidḵulag. ");
INSERT INTO gaw_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","Danab nug daug ele dayeb amu nug doyaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","Aria Jesus Nug baula aum. “Ag doyeg! Ag lailḵad dilagnu kobol tutuḵu o kobol eheḏp̱a epeḏiadḵulag amu Kayak Nug ele melemel amup̱a ag heṯoḏiaṯa, baula ele tuḏidḵu. ");
INSERT INTO gaw_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","Danab laa nug Kayak nai aḏaṯe ele amu dimp̱a Kayak Nug baula ele tuḏiṯa, nug medaḵu amge danab laa nug Kayak nai laa ii aḏaṯe aria nug nakok hamu aḏom amu Kayak Nug amu eḏua aḏidḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","Jesus Nug nai amu maṯiowa, Nug Kayaknu ḏo maḏoḏ aṯem daaḵunu amu inam maṯiom. “Kayaknu ḏo maḏoḏ amuam danab nug e wanp̱a ebṯe bia. ");
INSERT INTO gaw_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","Nug ep̱owa amu nug tuqanp̱a niiaya, amunp̱a nug uḏat laala haaha oiyeye amu e nug ba, oḵai meṯe. Oḵai meṯe amge danab nug e amu aṯem ba oḵai meṯe nug ii dooṯe. ");
INSERT INTO gaw_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","Nug uḏat laa heehe, wan nug nuḵa e iṯag medeṯe, e amu beṯe. Tatam am uḏug, dimp̱a haḏag qeṯe amu dimp̱a nug meu oṯe. ");
INSERT INTO gaw_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","Aria meu wa oḏue, meu awak haen aaḵu doum amunu danab nug meu aoṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","Nug anam anana amu Nug nai tuḏiṯa aum. “Ig Kayaknu ḏo maḏoḏ am aḏi bia daaṯe aḵunig. Ig nug am keeke aḏi laa ele ou aqat-ta, nug diig tutuḵu anidḵunig? Am inam. ");
INSERT INTO gaw_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","Kayaknu ḏo maḏoḏ am ad mastet aeg ep̱aeg beṯe amubia. Mastet aeg nug am e laa aeg bia iiṯa. Nug aeg nakoknab amge danab nug wanp̱a ebṯe, nug beṯe. ");
INSERT INTO gaw_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","Nug ba, oḵai ma, dad oop̱anu e laa oh eḏadṯe. Eḏaṯa, ep̱eg ele oḵai daaegeg, ai laala ag nug logop̱a daaṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","Haen oh Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata ip̱uanaṯa, ag amelagp̱a maṯiom. Keeke ag doodp̱ig ele amup̱a Nug nai elele tuḏiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","Nug nai amubia aaḵuib maṯiom amu Nug nuhiḵud ip̱uniṯak awak danab ele ag haen laala aḵaib daanna, Nug nuhig nai oh amu diig mehuqom. ");
INSERT INTO gaw_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","Deḏ amu tueb me, aam noono Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Ig ahat, Galelia le ameg mataḏta, laih goḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","Awa a amu ag ahan, danab ah kuḏum uuadna, ub nakok, Nug ub amup̱a dayom ele amu, ub amup̱a uḵaegeg, ub naunau laala ele oh gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","Ag uḵaegeg, ulah oḵainab heehe, le ameg nug koḏkoḏ huan qa, ub oop̱a noa, am beḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","Le anam heehe amu Jesus Nug ub biṯobp̱a uḏunp̱a niieye, nuhiḵud ip̱uniṯak awak danab ag Nug maḏ eṯan ap̱ig. “Ip̱uniḵak ihinig, ig mauhḵunignu heṯem, amu na amunu dab iite meṯem?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","Ag anam aeg amu Jesus Nug aha, ulah amegp̱a nug anam hemanu anana, le amegp̱a, “Na uuna, to eṯan daye!” awa aum. Nug anam a amu ulah nug iiṯa me, le ele to eṯa, manin niiom. ");
INSERT INTO gaw_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","Nug anam ha amu Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Aḏinu ag baḏaṯeb? Ag oolagp̱a genab iite dooṯeb?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","Nug anam a, nuhiḵud ip̱uniṯak awak danab ag nuhignu enanag doon, oolag ele oṯaie, ag aḵa aḵa ap̱ig. “Ulah le ele amu a ele danab imunu nai dim lamidṯep amunu am aṯemun? Nug am aun?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","Aria ag gona, Galelia le ameg laih Gerasa wanp̱a eeḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","Eeḏna amu ag ub uun, wanp̱a noegeg, danab laa, nug ouḏi nau ele, matmatp̱anu Jesus gumiṯa uḏiom. ");
INSERT INTO gaw_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","Nug hanhan matmatp̱a dayaya oiṯom amu ag danab amu muḏip̱a o senp̱a ele qaḵaglagnu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","Ag haen kuḏum qagap̱ig amge nug haen oh wagai ma, sen paḵua, baegp̱an aḏaknu keeke ele he aoḏṯom. Danab laa nug danab amu aḏaḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","Nug anam haaha, tuqan amun ele nug matmatp̱a oiṯom, qaukop̱a ele oiyaya gaaṯom. Nug nuḵa beḏu menp̱a ele tuqaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","Anam daaṯom amunu haen amup̱a nug nakok uma dayaya, Jesus anṯa, nug Jesus gumiṯa goḵunu qaibaḏ uḵa, Jesus noobp̱a gateg qaun oum. ");
INSERT INTO gaw_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","8","Nug gateg qaun o amu Jesus Nug ouḏi nau, danab amup̱a dayom ele amu, nug amegp̱a, “Danab amu uuidna uḵe!” awa aum. Nug anam aum amunu danab amu nug ewa aum. “Jesus, na Kayak aṯannunab beḵa. Na da aṯem heiḏḵutnu heṯem? Kayak onigp̱a da na amenp̱a g̱agaṯag aṯem. Na da guiṯak aib meḏame!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","Aria Jesus Nug ouḏi nau oḏ meṯom. “Na onin aun?” Oḏ meṯe amu ouḏi nau nug aum. “Ig am kuḏumnab amunu da onil, ‘Daup kuḏum,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","Aum amunu ouḏi nau amu nug Jesus amegp̱a, “Ig wan imu uut goḵunignu aib ame,” ii daye daye unuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","Nug anam aawo, bo kuḏumnab qaukop̱a ameg laip̱u daanna, e laegeg, ");
INSERT INTO gaw_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","amu ouḏi nau ag Jesus unuqidna ap̱ig. “Ig lamigḵutnu dayeb amu lamigp̱e, bo beḏulagp̱a notu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","Ag anam aeg amu Jesus Nug, “Anam heig!’ awa a, ag danab amu uun gona, bo beḏulagp̱a nop̱ig. Noeg amu bo ag oolna, huana gona, aben oola noakp̱a Galelia le amegp̱a nona, le lanana mauhp̱ig. Bo amu, ahilag eb qak am 2000 anam. ");
INSERT INTO gaw_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","Ag mauheg amu bo gumaṯak danab ag ahan gona, ab oḵai amu nuhig wan taliliak ele amup̱a keeke aḏi anidp̱ig amu aeg doop̱ig. Doona amu ag keeke amu anidḵulagnu ahan gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","Ag gona, Jesus gumidna tena, ag danab amu dayeye anidp̱ig. Nug hanhan ouḏi nau ele dayom amge haen amup̱a nug lamen ma, dab mak ena ele to eṯa dayom. Anam dayeye anidna, ag baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","Aria danab ag Jesus Nug danab ouḏi nau ele nuhignu aṯem heum amu anidp̱ig ele amu, ag amunu maṯinna, bonu ele madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","Maṯieg, ag doona amu ag Jesus Nug ahilag wanp̱anu aha, laih goḵunu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","Ag anam ap̱ig amunu Jesus Nug ubp̱a teete, danab ouḏi nau uuidp̱ig ele amu, nug Jesus ele oh goḵulahnu ii daye daye oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","Nug oḏ meṯom amge Jesus Nug aum. “Iiṯa, na eḏun, baenadp̱a gumadna gona, Naḏi nahipnu oo doye amu nahipp̱a aḏi heum ele amunu ap̱e, doyeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","Jesus anam aum amunu danab amu nug eḏua uḵa, Dekapolis ap̱a ta, Jesus aḏi nuhigp̱a heum amu amelagp̱a maṯieye, ag nuhig nai doona, ag dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","Aria Jesus Nug ubp̱a ta, Galelia le ameg mataḏa, le laih waum. Wana, le ihip̱a dayeye, danab ah kuḏumnab gumidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","Ag anam daaegeg amu Juda dilag nai doyak lagnu iḵi danab laa onig Jairas, nug Jesus gumiṯa uḵa, gateg qaun wa, ");
INSERT INTO gaw_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","nug Jesus unuqiṯa aum. “Nid ahin dahil nug mauhḵun heṯe amunu na gona, ep̱enp̱a aḏap̱e, ena daaḵunu oḏ medaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","Nug anam a amu Jesus nug ele oh uḵaeheh, danab ah laala kuḏumnab ag Jesus hap̱utna, qataeṯan daaegeg gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","Amu ah laa ap̱a dayom ele amu nug kalam qak oḏe maḏ tuelp oop̱a haen oh anidṯom. Iiṯa ii meṯom. ");
INSERT INTO gaw_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","Nug dokta kuḏum gumaṯa uḵa, men doḏo oh nuhig hamu maṯom amge dokta ag nug ii ehaniṯeg, oḏe nuhig uḵa uḵa, oḵai meum aaḵuib. ");
INSERT INTO gaw_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","28","Nug anam dayaya amu nug, “Jesus oḏe danab kuḏum bap̱alaṯe, ena daaṯeb,” naip̱ulag amu doya, nug nuhig dab makp̱a, “Da lamen nuhigib nakok aḏaḵul amu da ena daaḵul,” aum amunu nug danab ah Jesus ele gop̱ig amu ag oolagp̱a Jesus dimugp̱a gonana, Jesus gumiṯa wana, lamen nakok aḏom. ");
INSERT INTO gaw_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","Aḏe amu nuhig oḏe laip̱un iiṯa me, nug amu doye, ");
INSERT INTO gaw_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","Jesus Nug nuhig g̱agaṯag laa uḵe doya, Nug eḏua oḏ maṯom. “Aun dahil lamen aḏom?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","Nug anam a amu nuhiḵud ip̱uniṯak awak danab ag Nug amegp̱a ap̱ig. “Danab ah ameg naḏi talilidna daaṯeb amunu aḏinu na, ‘Aun aḏailom?’ aon aṯem,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","Ag anam aeg amge Jesus Nug ahilag nainu dab ii meṯom. Iiṯa, Nug neeḵa, aun heum amu anidḵunu neeḵaṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","Dayeye amu ah nug, “Da nuhig lamen aḏami amunu Nug dahilnu aṯe,” dab makp̱a anana, nug baḏa hahaḏaḏa, Jesus noobp̱a wana, gateg qaun wa, keeke oh nuhigp̱a beum amunu oh miag Jesus amegp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","Nug anam a amu Jesus Nug aum. “O aḏel, na ootp̱a genab doome amunu na ena daaṯem. Oḏe nahip male, na ena daaṯem. Na maḏoḏ ele uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","Jesus Nug anam maṯiaya dayeye, danab laala ag iḵi danab Jairas, amu nug laugp̱anu uḏin, Jairas amegp̱a ap̱ig. “Na aḏen mauhom amunu na ip̱uniṯak danab imu uḏat baula aib meṯame,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","Ag nug amegp̱a aegeg, Jesus Nug nai amu daugp̱a doya, Nug Jairas amegp̱a aum. “Na aib baḏame! Na ootp̱a genab doye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","Nug anam anana amu Nug danab ah laa oh amu nuhiḵud ip̱uniṯak awak danab ele ag dim lamidmananu, “Aib,” aum. Amu oh oolagp̱anu nuhiḵud ip̱uniṯak awak danab ewam, Petrus, Jakobus amu Johanes ele aaḵuib Jesus ele Jairas laugp̱a gop̱ig. Jakobus Johanes ele, a am eamag. ");
INSERT INTO gaw_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","Ag gona, nug laugp̱a tenana, Jesus Nug qanak baag oḵai ahilag doyaya, mahiṯak kobol laala ele heegeg anṯom. ");
INSERT INTO gaw_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","Nug anam anṯa, lag oop̱a noa amu ag amelagp̱a aum. “Aḏinu ag inam henan gaaṯeb? Nid ahin imu nug ii mauhom, nug niiṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","Nug anam aum amunu ag Nug imidp̱ig amge Nug ag oh lamaṯe, dimiṯim noeg, Nug nid ahin mameg, anig ele nuhiḵud ip̱uniṯak awak danab ewam ele ag aaḵuib diiaṯe, nid ahin niiomp̱a nop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","Ag nona, Jesus Nug nid ahin ep̱eg aḏa, ag nailagp̱a aum. “Talita kumi.” Nai amu diig am inam. “Da aṯem, nid ahin, na ahe!” ");
INSERT INTO gaw_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","Jesus Nug anam a amu nid ahin nug pahanab aha oiyeye, danab ah ag nid ahin anidna, ag huanak oṯaina, dab mak kuḏum aop̱ig. Nug am maḏ tuelp ele. ");
INSERT INTO gaw_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","Aria Jesus anam hewowa amu Nug ag danab laala amelagp̱a amananu, “Aib,” anana, ag nid ahin e meṯaglagnu ele aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","Anam hewowa, deḏ laa Jesus Nug ap̱ag diigp̱a goḵunu ahe, nuhiḵud ip̱uniṯak awak danab ele ag oh gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","Ag gona tena daanna, Meṯidp̱a Nug Juda dilag nai doyak laḵa ta, Kayaknu nai ip̱uanaṯom. Ip̱uanaṯe amu danab ag doona, dab mak kuḏum aona ap̱ig. “Danab imu am aṯemun? Aun danab imu doyak imu oh meṯom? Nug aṯem ha uḏat laala danab haknu elele iiṯa ele heṯe? ");
INSERT INTO gaw_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","Nug am lag hak danab! Ig dooṯem, nug am Maria beḵa. Nug amaḵud am Jakobus, Joses, Judas, Simon ele. Amu nug ap̱inḵud amu ag ig ele iite daaṯem?” aon ap̱ig. Ag anam anana amu ag Jesus ele oolag laip̱u ii dayom. ");
INSERT INTO gaw_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","Ag oolag laip̱u ii dayom amunu Jesus Nug ag amelagp̱a aum. “Propet nug ab ohp̱a onig ele amge nug ap̱ag diigp̱a, nug tiilag laip̱u ele oolagp̱a amu nug laugp̱a ele amu nug onig iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","Ag nuhignu oolagp̱a genab ii doop̱ig amunu ap̱a Nug oḏe danab kuḏum ii bap̱alaṯom, laip̱u laip̱uib. ");
INSERT INTO gaw_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","Ag oolagp̱a genab ii doop̱ig amunu Nug dab mak kuḏum awa, Nug ab amup̱anu aha, ab laalap̱a uḵa, Kayak nai mehuqom. ");
INSERT INTO gaw_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","Nug anam oiyaya amu Nug nuhiḵud ip̱uniṯak awak danab tuelp onilagp̱a e uḏieg, Nug aḏit aḏit maaṯe, ag ab laalap̱a goḵulagnu daaegeg amu Jesus Nug ag ouḏi nau lamadḵulagnu g̱agaṯag maṯa, ");
INSERT INTO gaw_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","Nug ag amelagp̱a aum. “Ag hoḵat dud qaknu amu aḏaglagnu elele amge bret, baṯam, men doḏo ele amuam aib aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","Ag baelag gaḏa lamen ele amu meḵulag amge lamen aḏit amu aib mep̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","Nug anam anana amu Nug nai baula tuḏiṯa aum. “Ag gona, ab laap̱a danab laa laugp̱a tena, ag lag amup̱aib daanna, uḵaknu haen beeb, ab amup̱anu ahan uḵeg! ");
INSERT INTO gaw_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","Amge deḏ laa ag ab laap̱a tep̱eg, ab amup̱an danab ag diin, laḵa ii maadna, nai ahilag ele ii doop̱eg amu ag ahan, ab amu uunna, ag ab amup̱an danab ag eheḏ hep̱ig dooglagnu, ag baelagp̱anu gap̱ud qeqalp̱eg naḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","Nug anam aum amunu ag ahan gona, nai mehuqnana, danab ah oh ag hip̱uninnu oolag eḏuḵunu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","Anam henana amu ag ouḏi nau ele lamadnana, oḏe danab ag Kayaknu dab meḵulagnu, ip̱uniṯak awak danab ag olipnu goḏen layadna unuqiṯeg, beḏulag ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","Amu Jesus Nug uḏat heehe, uḏatnu nai wan amu oh tone, king Herodes Antipas doyom. Doyeye, danab laala ag Jesusnu uḏat amu anidna doona ag, “Layaṯak Johanes mauhowa, nug eḏua hibaiṯa oiṯe amunu g̱agaṯag oḵai oḵai nuhigp̱a beṯe,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","Ag anam ap̱ig amge laala ag, “Nug am Elias,” aegeg, laala ag, “Nug am propet, anuḵa propet daap̱ig, amubia,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","Laa ag anam ap̱ig amge Herodes Antipas nug anam doya, nug aum. “Imu am genab Layaṯak Johanes. Da nug baag otaḏmi amge Kayak Nug he, nug eḏua hibaiṯom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","18","Amu Layaṯak Johanes nug mani guiṯakp̱a ii dayom haenp̱a amu Herodes Antipas nug awag Pilip, nug wau Herodias aḏiṯa awom. Awe amu Layaṯak Johanes nug Herodes Antipas amegp̱a, “Na awan wau aome, amup̱a na ḏo tip̱alme, kobol amuam ena iiṯa,” awa aum amunu Herodes Antipas nug a, nuhiḵud daup danab ag gona, Johanes ep̱eg hip̱alna, aon gona, mani guiṯakp̱a mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","Johanes aum, diig amunu ele Herodes Antipas wau Herodias nug oo aeg be, nug Johanes qeeb mauhḵunu heum amge elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","Aḏinu? Herodes Antipas nug doyom, Johanes am Kayak noobp̱a danab tutuḵu, oiyak nuhig am ena amunu Herodes Antipas nug heeb mauhmanu baḏa, atog noum. Amu deḏ laala Herodes Antipas nug Johanes nai madiḵunu onigp̱a e uḏia, nai maṯie amu Herodes Antipas nug Johanesnu nai amunu dab mak kuḏum awom amge nug nai amu dooḵunu oo ele dayom. ");
INSERT INTO gaw_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","Aria ag anam daanna, deḏ laa Herodias nug Johanes qeḵunu ib anṯom. Deḏ amup̱a Herodes Antipas nug nuhig menuak deḏ be, nug gabmannu iḵi danab amu daup iḵi danab amu Galelianu danab oḵai laala ele, ag nuhig menuak deḏ amunu gamag ahak heḵulagnu hobul heum. ");
INSERT INTO gaw_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","Haen amup̱a ag Herodes Antipasnu hobulp̱a daaegeg, Herodias aḏeg, lag oo amu oop̱a noa, ahi goḏeḏe, Herodes Antipas aḏi ag nug anidna, ag iṯag aqe, Herodes Antipas nug aha, nug nid ahin amu amegp̱a nai g̱agaṯag qeṯa, inam aum. “Na aḏin oot heṯe? Na keeke laa aoḵutnu oot dayeb am da na medaḵul. ");
INSERT INTO gaw_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","Na keeke dahil imu oh laih aoḵutnu oot dayeb amu da gamagp̱a opatp̱i, laih na aoḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","Nug anam a amu nid ahin nug aha, dimiṯim uḵa, nug keeke aḏi aoḵunu amu Herodes Antipas amegp̱a aḵunu anig oḏ meṯom. Oḏ meṯe amu anig nug aum. “Na Layaṯak Johanes iḵi medaḵunu ap̱e doyaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","Nug anam a amu nid ahin nug paha eḏua uḵa, Herodes Antipas amegp̱a aum. “Na geha iiḵunab Layaṯak Johanes baag otaḏna, iḵi tap̱iḏp̱a mena, meḏaḵutnu ool daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","Nid ahin nug anam a amu Herodes Antipas nug oo ug oḵainab ele dayom amge nug tatam nai g̱agaṯag qeṯa aawo, ḏo danab ag nug ele daap̱ig amu ag ele nai amu doop̱ig ");
INSERT INTO gaw_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","amunu nug paha nuhig daup laa amegp̱a, “Na gona, Johanes baag otaḏna, na nug iḵi aon do!” awa aum. Nug anam a, nuhig daup danab mani guiṯakp̱a uḵa, Johanes baag otaḏa, ");
INSERT INTO gaw_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","nug iḵi tap̱iḏp̱a ma, awa uḏia, nid ahin meṯe, nug anig meṯom. ");
INSERT INTO gaw_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","Ag anam heeg amu Johanesnu ip̱uniṯak awak danab ag doon gona, Johanes gaḏa aon gona boomp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","Aria Jesusnu ip̱uniṯak awak danab ag eḏun uḏieg, ag Jesus ele qag mena, ag uḏat hep̱ignu amu nai ip̱uanadp̱ignu ele Jesus amegp̱a ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","Ap̱a daaegeg, danab ah kuḏum ag uḵak uḏiak heegeg, Jesus amu nuhiḵud ip̱uniṯak awak danab ele ag e lanaknu haen laa ii anidp̱ig amunu Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Ahap̱eg gota, aben danab ii daaṯebp̱a amu ag ap̱a hik nakok aweg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","Jesus anam a amu ag ubp̱a tena, atu laih danab ii daaṯebp̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","Ag anam gop̱ig amge ap̱an danab ag Jesus nuhiḵud ip̱uniṯak awak danab ele anadna doona, ag ab ohp̱anu ahan, baelagp̱a tatam anuqna gona, aben Jesus aḏi goḵulagnu gop̱ig amup̱a ag tatam tep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","Tena daaegeg amu Jesus Nug nuhiḵud ip̱uniṯak awak danab ele ag gona eeḏna, Jesus Nug danab ah kuḏum gona, aben amup̱a daaegeg anaṯa, Nug ahilagnu oo doyom. Aḏinu? Ag am doḏ sipsip ag gumak danab iiṯa, mauhnoak oiṯeb, amubia daap̱ig. Nug oo doyak awa, Nug ag keeke kuḏum ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","Ip̱uanaṯeṯe aam no, nuhiḵud ip̱uniṯak awak danab ag Jesus gumidna dona, amegp̱a ap̱ig. “Imu am aben danab ii daaṯeb ele. Aam ele noḵun heṯe. ");
INSERT INTO gaw_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","Amu danab ah imu ag e laa iiṯa amunu na ap̱e, ag ahan, danab laulagp̱a amu ab ab ele gona, e aon laig!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","Ag anam aeg amu Jesus Nug aum. “Ag e madap̱eg laig!” awa aum. Awa a amu ip̱uniṯak awak danab ag ap̱ig. “Ehe, Ig gota, bret 1000 kina keeke anamp̱a daden meḵunigte? Ig men doḏo amubia iiṯanab iiṯa,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","Ag anam aeg amu Jesus Nug aum. “Ag ep̱elagp̱a e gane daaṯe. Gona anṯeg!” awa aum. Awa a amu ag gona, maṯin anidna, ag eḏun dona, amegp̱a ap̱ig. “Bret kunum tanig ele amu kakai aḏit ele daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","Ag anam aeg amu Jesus Nug ip̱uniṯak awak danab amelagp̱a aum. “Danab ah oh ap̱eg doona, ag ameg ameg giḵiḏa enap̱a dayeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","Nug anam a amu ip̱uniṯak awak danab ag aeg, danab ah anam daap̱ig. Ameg laala eb qak 100, ameg laala eb qak 50. Ag anam daaeg uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","Ag anam daaegeg amu Jesus Nug bret tanig ele amu kakai aḏit ele diia aḏa, Nug hab aṯan neeḵa dayaya, unuqiṯom. Unuqiṯowa amu Nug bret, kakai ele pane ne, ip̱uniṯak awak danab ag aon panin maṯaglagnu maṯe, ag danab ah maṯaeg, ");
INSERT INTO gaw_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","oh laeg, ag oolag diṯie, ");
INSERT INTO gaw_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","e big dayom amu ip̱uniṯak awak danab ag aon, kaleg tuelp inaeg am beum. ");
INSERT INTO gaw_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","Danab e lap̱ig ele amu ahilag eb qak am 5000. ");
INSERT INTO gaw_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","Ag e lana malaeg amu Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Da danab ah imu oh qatiglagnu abip̱i, ag ahan, ubp̱a tena, Galelia le ameg mataḏna, laih Betsaida uḵeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","Nug anam a amu ag ahan uḵaegeg, Jesus Nug danab ah amelagp̱a, “Enade uḵeg,” awowa, Nug nuḵa amu unuqidḵunu qaukop̱a teum. ");
INSERT INTO gaw_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","Ta dayeye, aam no, ip̱uniṯak awak danab ag ubp̱a, le ameg gamagp̱a uḵaegeg, Jesus Nug nuḵa ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","Anam dayeye amu ulah oḵai ub nob awe, eḏue laih goḵunu heehe amu ip̱uniṯak awak danab ag el qak uḏat oḵai heegeg, Jesus anaṯom. Anaṯe, wagḵaḏeḏe buṯuanab Nug aha, le gaḏa tap̱a, gumaṯa uḵa, qe eḏaṯa goḵunu uḵom amge ip̱uniṯak awak danab ag ");
INSERT INTO gaw_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","Nug anam le gaḏap̱a ugeḵe, ag anidna, “Umuam doṯog,” anana, baḏan, huan ep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","Ag oh anidna, eheḏ baḏaeg, Jesus Nug ag amelagp̱a aum. “Ag g̱agaṯag dayeg! Imu daib, aib baḏap̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","Nug anam anana amu Nug ub aṯan oola te, ulah oḵai to eṯom. To eṯe amu ip̱uniṯak awak danab ag dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","Aḏinu? Ag Jesus bretp̱a kobol heum amu ag oolag ii maiṯom. Ag oolag ituak dayom. Jesus Nug ag atog noadḵunu elele ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","Aria ag le ameg mataḏna, Genesaret eeḏna tep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","Eeḏna teeg, haen amup̱anab amu ap̱an danab ag Jesus anidna amu ag Nug iḏu doona, ");
INSERT INTO gaw_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ag paha ab ohp̱a gona, aeg doona, ag oḏe danab diin, Jesus adep̱a dayom doona amu ag ap̱a gumidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","Amu Jesus Nug ab ab oiyeye, ag oḏe danab diin, ab gamagp̱a maadna, ag Jesusnu lamen daugib aḏaglagnu unuqidna ap̱ig. Unuqidna aeg amu oḏe danab oh ag Jesusnu lamen aḏap̱ig ele amu, ag aḏaeg, ag beḏulag ena dayom. ");
INSERT INTO gaw_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","Aria amu dimp̱a ḏo gumak danab-Parasia amu ḏo mehuqak danab ele ag Jerusalemnu ahan, Jesus gumidna gona, ");
INSERT INTO gaw_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","Jesusnu ip̱uniṯak awak danab laala, ag Juda dilag ḏo amup̱anab ep̱elag ii ihap̱ig, ag ep̱elag hamu ihona, e lanan daaegeg anadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","Juda dilag ḏo gumak danab-Parasia amu Juda danab laala ele ag ep̱elag ii ihana, ag alalḵad ap̱ig amubia, ag e ii laṯeb. ");
INSERT INTO gaw_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","O ag e oḏiak abenp̱anu eḏun, laḵa gona, ag haen amu ele ag ep̱elag ii ihana amu ag e ii laṯeb. Ag ḏo laala kuḏum amubia dim lamidṯeb, hai goḵoḏ ihaknu, wa ihaknu, amu tap̱iḏ ihaknu ele. ");
INSERT INTO gaw_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","Anam hanhan hedap̱ig amunu ag Jesusnu ip̱uniṯak awak danab ep̱elag ii ihap̱ig, e laeg anadna, ag Jesus amegp̱a ap̱ig. “Ip̱uniṯak awak danab nahip̱ad ag ep̱elag ii ihona, e laṯeb. Aḏinu ag alanḵad dilag kobol ii dim lamidṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","Ag anam aeg amu Jesus Nug ag amelagp̱a aum. “Anuḵa amu propet Jesaia nug ag ham bup̱uak danab, ahilagnu tutuḵu yom. Nai amuam inam. ‘Danab imu ag oḏelagp̱aib da binal meṯeb. Ag oolag amu uuiḏa piḏenab daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","Ag danab ah dilag ḏo aaḵuib mehuqnana amu ag amunu, “Kayaknu ḏo,” aon aṯeb amunu ag da hamu binal meṯeb.’ ");
INSERT INTO gaw_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","Ag Kayaknu ḏo uuidna, danab dilag ḏo aaḵuib dim lamidṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","Jesus Nug anam anana amu Nug nai baula tuḏiṯa aum. “Ag ahilag dab mak dim lamidḵulagnu, Kayaknu ḏo tabap̱eg neḵunu doon aotna aoṯeb. ");
INSERT INTO gaw_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","Imu anṯe! Moses nug aum. ‘Na anin mamen ele binalah mena, ahilah nai dim lamiṯe!’ Amu nuhig nai laa ele am, ‘Danab nug Kayak onig diia, anig mameg ele a nob nau aoglahnu aḵu amu ag qep̱eg mauhaḏ!” ");
INSERT INTO gaw_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","Moses nug anam aum amge ag inam aṯeb. ‘Danab laa nug moni laa anig mameg ehanatḵunu ele amge nug a amelahp̱a, “Da moni imu Kayaknu tituanmi,” anana amu ");
INSERT INTO gaw_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","nug anig mameg ele ii ehanatma.’ ");
INSERT INTO gaw_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","Ag ag alalḵad dilag ḏonu anuqak doon dim lamidṯeb amup̱a ag heeg, Kayaknu ḏo amu hamu bia daaṯe. Ag keeke kuḏum amubia heṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","Aria Jesus Nug baula danab ah kuḏum gumidna goḵulagnu e, ag uḵaeg, Nug amelagp̱a aum. “Ag nai dahil tutuḵu doon, dab meṯan aotna aweg! ");
INSERT INTO gaw_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","Keeke dimiṯimnu danab oop̱a noṯe ele, keeke amu danab oo dubuṯid ii medṯe. Iiṯa! Keeke danab dab makp̱a loḵumak dayaya, oḏep̱anu dimiṯim beṯe, amuam danab oo he, dubuṯid medṯe. ");
INSERT INTO gaw_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","Danab nug daug ele dayeb amu nug doyaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","Nug anam anana amu Nug danab ah ele uuaṯa, laḵa uḵe, nuhiḵud ip̱uniṯak awak danab ag nai amu, Nug nai amup̱a keeke danab ag dooṯeb ii dooṯeb ele ou aqata ip̱uanaṯa maṯiom ele, nai amu diignu oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","Oḏ meṯaeg amu Jesus Nug aum. “Ag am danab laala ag dab mak iiṯa biate amunu ag nai amunu diig ii dooṯeb? Ag doyeg! Dimiṯimnu keeke nug danab oop̱a noa heeb, danab amu nug oo dubuṯid ele ii daama. ");
INSERT INTO gaw_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","Aḏinu? Danab nug e laṯe amu e amu nug danab dab mak abenp̱a ii goṯe. Iiṯa, nug danab biigp̱a uḵe, biie goṯe,” awa aum. Jesus Nug anam aum amunu ig dooṯem. E oh lanaknu am enaib. ");
INSERT INTO gaw_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","Aria Jesus Nug anam anana amu Nug nai baula tuḏiṯa aum. “Eheḏ hak nau oh am danabnu dab makp̱a dig meṯe amunu keeke amu nug he, danab oo dubuṯid medṯe. ");
INSERT INTO gaw_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","Genab kobol eheḏ imu oh danabnu dab makp̱anu beṯe, dab mak nau, gap̱ai kobol diigdiig, yabhok kobol, danab qe mauhak kobol, ");
INSERT INTO gaw_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ameg qak kobol, oo nauha amya oiyak kobol, nai genab iiṯa anak kobol, uḏa nak kobol, oo aeg bak kobol, danab laanu nai nau anak kobol, nuḵa binag mak kobol amu ham bup̱uak kobol kuḏum laa ele. ");
INSERT INTO gaw_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","Kobol amu oh danabnu dab makp̱a dig men bena heeg, danab nug hip̱unin he, oo dubuṯid ele daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","Aria dimp̱a Jesus nug aha uḵa, ab onig Taia heqop̱a, lag laap̱a ta, ap̱a loḵuma daaḵunu ha dayom. Amge danab laala ag Jesus uḏiom doop̱ig amunu Jesus Nug loḵuma ii dayom. ");
INSERT INTO gaw_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","Loḵuma ii dayom amunu ah laa, nug aḏeg am ouḏi nau ele, nug Jesus ap̱a dayom doya, nug paha gumiṯa uḵa, Jesus noobp̱a gateg qaun oom. ");
INSERT INTO gaw_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","Ah amu nug am Grik ah. Nug Panisia wan, Siria gumap̱ig ele amup̱a dayom. Nug Jesus gumiṯa uḵa, Jesus Nug heeb, ouḏi nau nug aḏeg beḏup̱a dayom amu uuidḵunu ii daye daye oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","Ah nug anam a amu Jesus Nug aum. “Ig nid naunau dilag bret aot, qai maṯagnig am kobol ena iiṯa amunu nid naunau ag tatam lap̱eg, oolag diṯiaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","Awa a amu ah nug aum. “O Naḏi, ena aṯem ge nid naunau ag bret lanana heeg, bret hup̱u nakok balalp̱anu na qeṯe ele amu qai ag balal waap̱a daana laṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","Nug anam a amunu Jesus Nug ahnu oop̱a genab doyak oḵai ele anṯa, Nug aum. “Na ena ame! Na oot gamag ahebeb, lautp̱a uḵe! Ouḏi nau nug na aḏen uuiṯom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","Jesus anam a amu ah nug eḏua laugp̱a uḵa, nug aḏeg balalp̱a niieye anṯom. Ouḏi nau nug genab uuiṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","Dimp̱a Jesus Nug Taia heqop̱a dayom ap̱anu aha noa, Saidon gamagp̱a noa uḵa, Dekapolis ap̱a wana uḵa, le ameg Galelia ap̱a noum. ");
INSERT INTO gaw_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","Nug no amu danab laala ag danab daug ituak, nai elele ii madiṯe ele Jesus top̱a omalna gona, Jesus ehanidḵunu unuqidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","Unuqiṯeg amu Jesus Nug nuḵa danab amu omala, piḏe wana, ep̱eg doḏo danab daugp̱a me no, hunua, lemaḏu aḏom. ");
INSERT INTO gaw_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","Nug anam ha amu Nug hab aṯan neeḵeḵe, oo hik bop̱ane, danab amegp̱a, “Epata,” aum. “Epata,” eḏuak am “Matulak daye!”. ");
INSERT INTO gaw_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","Jesus Nug anam a amu danab amu nug daug paha matule, lemaḏu ele ug iiṯa me amu nug nai ena maṯiom. ");
INSERT INTO gaw_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","Aria Jesus Nug anam ha amu Nug aaḵu keeke amunu maṯimnanu ḏo g̱agaṯag meum. Meum amge ag amu dim ii lamidp̱ig. Iiṯa. Ag gona, amunu madip̱ig. Nug heum, amunu amananu Nug baubau, “Aib,” aum amge ag amu dim ii lamidp̱ig. Iiṯa. Ag tuḏidna, huana Nug heumnu madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","Ag Jesus heum anidna, ag huanak oṯaina, ag dab mak kuḏum aonna, ag ap̱ig. “Nug aḏi heṯe amu Nug enaib heṯe. Danab daulag ituak ele Nug he, ag nai dooṯeb amu danab oḏetup ele ag nai madiṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","Aria deḏ laa danab ah kuḏumnab ag Jesus gumidna gop̱ig. Ag gona daaegeg, e iiṯa amunu Jesus Nug ip̱uniṯak awak danab onilagp̱a e doeg Nug aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“Da danab ah imu dilag ool dooṯe. Ag dahilp̱a uḏieg, ig deḏ ewam imu aaḵu daamut. Ag e oh laaeg, iiṯa me, gemu amu ag e iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","Laala ag umanu uḏip̱ig amunu da e ii maṯen hep̱i, ag enug aqebeb gonana, ib manp̱a ag amelag qiṯineb, nena qeḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","Nug anam a amu nuhiḵud ip̱uniṯak awak danab ag ap̱ig. “Laih ip̱a amu danab ag ii daaṯeb amunu ig bret adep̱a aognig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","Ag anam aeg amu Jesus Nug oḏ maṯom. “Ag bret gane ap̱a daaṯe?” awa aum. Awa a amu ap̱ig. “Bret eblaih aḏit ele daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","Ag anam aeg amu Jesus Nug danab ah oh ag heḏep nena daaglagnu anana, Nug bret awa, bret amunu Kayak amegp̱a, “Ena hen meḵame,” awowa, Nug pana, nuhiḵud ip̱uniṯak awak danab paniglagnu maṯe, ag panip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","Kakai nakok laip̱u laip̱u ele dayom amunu Jesus Nug amunu ele Mameg amegp̱a unuqiṯowa, paniglagnu ip̱uniṯak awak danab ele maṯom. ");
INSERT INTO gaw_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","Ag panieg, danab ah oh laeg, ag oolag diṯie, e big dayom amu ip̱uniṯak awak danab ag aon inaeg amu kaleg eblaih aḏit am beum. ");
INSERT INTO gaw_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","Danab ah haen amup̱a e lap̱ig ele amu eb qak ahilag 4000 anam. ");
INSERT INTO gaw_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","Ag e laeg, Jesus ag goḵulagnu aum. Ag uḵaegeg, Jesus Nug nuhiḵud ip̱uniṯak awak danab ele ag ub aṯan tena, ab oḵai onig Dalmanuta gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","Jesus Nug uḵa te, ḏo gumak danab-Parasia laala ag Jesus aḏaglagnu ib anidḵulagnu ag Nug gumidna gona, ag Jesus Nug hab aṯannu ep̱onak keeke, danab heḵunu elele iiṯa laa heeb anidḵulagnu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","Ag heḵunu aeg amu Jesus Nug nai amunu nuḵa gaḏa tuqak bia doya, Nug aum. “Aḏinu gemun danab ag da ep̱onak keeke, danab heḵunu elele iiṯa hep̱i anidḵulagnu oḏ meḏaṯeb? Da gemu daaṯeb imu amu ag anidḵulagnu uḏat amubia amu da laa ii hepa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","Nug anam anana amu Nug uuaṯa, ub aṯan ta, le ameg Galelia mataḏa laih ugeḵe, ip̱uniṯak awak danab nuhiḵud ag ele oh gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","Amu nuhiḵud ip̱uniṯak awak danab ag bret laa aon goḵulagnu daulag atiom, laip̱uib am ubp̱a dayom ele amu aon gop̱ig ");
INSERT INTO gaw_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","amu Jesus Nug ag amelagp̱a aum. “Ag ḏo gumak danab-Parasia amu Herodes ele, amu dilag bret titiḏaknu keeke onig yis amunu dab meig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","Nug anam a amunu ip̱uniṯak awak danab ag aḵa aḵa ap̱ig. “Ig bret iiṯa amunu Nug anam aum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","Aon aeg amu Jesus Nug ahilag nai doya, Nug oop̱a guiṯak doyaya, Nug aum. “Da bretnu ii ami. Ag amunu nai kuḏum aib madip̱ig. Ag da keeke hemi iite dooṯeb? Ag dab mak iiṯate? ");
INSERT INTO gaw_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","Ag dahil uḏatnu oolag maidḵunu elele iiṯate? Ag uḏat amu daulag atiomte? ");
INSERT INTO gaw_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","Deḏ laa da bret tanig ele panai, danab 5000 ag lana malaeg amu ag e hup̱u kaleg gane inaeg am beum?” awa aum. Awa a amu ag, “Tuelp” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","Anam aeg amu Nug aum. “Aria, deḏ laa da bret eblaih aḏit ele panai, danab 4000 lana malaeg amu ag e hup̱u kaleg gane inaeg am beum,” awa aum. Awa a amu ag, “Eblaih aḏit ele,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","Ag anam aeg amu Jesus Nug aum. “Anam amu ag doyeg! Da bretnu ii ami. Da ḏo gumak danab-Parasia amu Herodes ele, ahilag kobol eheḏnu ami,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","Aria ag ubp̱a gona, le daugp̱a eeḏna nona, gona Betsaida teeg, ap̱an danab ag danab laa ameg nauhak ele omalna, Jesus gumidna gona, Nug danab amu bap̱aidḵunu unuqidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","Ag unuqiṯeg amu Jesus Nug danab amu ep̱egp̱a aḏa, omala ab dimiṯim uḵa, Nug waḏu hune, danab amegp̱a no, Nug ep̱eg danab beḏup̱a ma oḏ meṯom. “Na keeke laa anidṯemte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","Jesus Nug oḏ meṯe amu danab nug aum. “Ao, da danab anadṯem amge tutuḵunab ii anadṯem. Ag am ad bia anadṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","Nug anam a amu Jesus Nug ep̱eg eḏua amegp̱a me, nug ameg ena daye, nug elele neeḵom. ");
INSERT INTO gaw_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","Elele neeḵe amu Jesus Nug aum. “Na aib eḏun ab oop̱a gome. Na lautp̱a uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","Jesus Nug anam a amu deḏ laa nug nuhiḵud ip̱uniṯak awak danab ele ag ahan, ab nakok laa Sisaria Pilipai taliliak daap̱ig amup̱a gop̱ig. Ag gonana amu Jesus Nug oḏ maṯom. “Danab ag dahilnu aḏi aṯeb?” awa oḏ maṯom. ");
INSERT INTO gaw_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","A amu nuhiḵud ip̱uniṯak awak danab ag ap̱ig. “Laa ag nahipnu, ‘Layaṯak Johanes,’ aṯeb amge laa ag, ‘Nug am Elias,’ aṯeb amu laa ag, ‘Nug am propet laa,’ aon aṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","Anam aeg amu Jesus Nug aum. “Anam amge ag aḵa amu dahilnu aḏi aṯeb?” awa aum. Awa a amu Petrus nug aum. “Na am Kristus, Kayak Nug na tituaniṯom!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","Petrus nug anam a amu Jesus Nug ag nuhignu danab laala amelagp̱a maṯimnanu ḏo g̱agaṯag meum. ");
INSERT INTO gaw_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","Aria haen amup̱a Jesus Nug dig ma nuhigp̱a, Nug am Danab Beḵalag, nuhigp̱a aḏi beḵunu amu ip̱uanaṯom. Nug Juda iḵi danab, mana meṯak danab oḵai amu ḏo mehuqak danab ele, ag Nug di meṯaglagnu, Nug guiṯak dooḵunu, mauhḵunu, deḏ ewam uueb eḏua hip̱aidḵunu, keeke amu ohnu Nug dig ma, ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","Nug miag atiak a amu Petrus nug omala, piḏe wana, dig ma daug batete, ");
INSERT INTO gaw_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","Jesus Nug eḏua, ip̱uniṯak awak danab laa oh neeḵaṯaṯa, Nug Petrus daug bata, amegp̱a aum. “Satan, na da dimulp̱a uḵe! Aḏinu? Na Kayaknu dab mak ii dim lamidṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","Anam anana amu Nug danab ah amu nuhiḵud ip̱uniṯak awak danab ele ag onilagp̱a e uḏieg, Nug amelagp̱a aum. “Laa nug da dim lamiḏḵunu oo dayeb amu nug nuhig dab mak dim lamidḵunu dab ii mema, nuhig ug amu mawa, da dim lamiḏaḏ! ");
INSERT INTO gaw_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","Aria danab laa nug wanp̱an bau daaḵunu dab mak anuqak aoṯe, dimp̱a nug bauklel hanhannu ii aoma amge danab laa nug dahilnu amu Nai Enanu ele anuqak dooṯe, nug wanp̱anu bau dayak amunu anuqak ii dooṯe amu nug am bauklel hanhannu aoḵu. ");
INSERT INTO gaw_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","Danab nug wanp̱an keeke oh aoṯe amge nug bau dayak hanhannu ii aoṯe amu keeke amu nug aṯem ehanidḵu? ");
INSERT INTO gaw_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","Nug aḏi keekep̱a bau dayak hanhannu daden meḵu? ");
INSERT INTO gaw_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","Aria danab laa nug wan imup̱an hip̱unin danab, ag kobol eheḏ laala kuḏum heṯeb ele amu, nug ag oolagp̱a oiyaya, nug dahilnu, dahil nainu ele uḏa neeb amu dimp̱a da Kayaknu g̱agaṯag ele amu nuhiḵud engel ele eḏut uḏit, haen amup̱a danab amunu da ele uḏal neḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","Jesus Nug anam anana amu Nug nai baula tuḏiṯa aum. “Da genab aṯem. Danab laala gemu ip̱a hip̱aidna daaṯeb ele amu ag paha ii mauhmana. Iiṯa. Tatam Kayaknu ḏo maḏoḏ g̱agaṯag ele dig ma beeb anidna mauhḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","Aria deḏ eblaih laip̱u uue amu Jesus Nug Petrus, Jakobus, Johanes ele omalaṯa, qauko oḵai laap̱a te, ag aḵa daap̱ig. Ap̱a daanna amu Jesus Nug beḏu eḏuom. ");
INSERT INTO gaw_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","Beḏu eḏue amu nuhig lamen ele haḵabnab ep̱om. Wan imup̱anu danab laa nug lamen heeb, haḵab amubia beḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","Jesus Nug anam dayeye amu Elias Moses ele a tulai doeh, Jesus ele nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","Anam daaegeg amu Petrus nug Jesus amegp̱a aum. “Ip̱uniṯak danab, ig aben imup̱a daagnignu am enanag amunu na ap̱e, ig peh ewam buugnig. Nahip laip̱u, Mosesnu laip̱u amu Eliasnu laip̱u ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","Aḏinu nug anam aum? Ag baḏan daanna, nai laa anak iiṯa amunu Petrus nug nai amu aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","Ag anam daaegeg amu lombig laa ag tonaṯeṯe, lombig oop̱a baag laa inam a doop̱ig. “Imu am nid dahil, da nuhignu ool huanak mauhṯe. Ag nuhig nai doyeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","Baag anam doona amu ag pahanab neeḵeg ugeḵe amu ag danab laa ii anidp̱ig. Jesus nuḵa ag ele daanna anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","Ag anam anṯeg amu Jesus Nug ag ele ahan, qauko uun nonana, Jesus Nug ag kobol amu anidp̱ig ele, ag amunu danab laa amegp̱a paha amananu ḏo g̱agaṯag meum. Nug, Nug am Danab Beḵalag amu, Nug tatam eḏua hibaiṯeb ag maṯiglagnu aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","Jesus Nug anam a amu ip̱uniṯak awak danab ag nai amu aona, aḵa aḵa ap̱ig. “Eḏua hibaiṯak nai am aḏi nai?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","Ag aḵa aḵa anam anana amu ag Jesus oḏ medap̱ig. “Aḏinu ihinig ḏo mehuqak danab ag, ‘Elias nug tatam uḏieb, dimp̱a Kristus uḏiḵu,’ aṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","Ag anam aeg amu Jesus Nug aum. “Ag, ‘Elias nug tatam uḏia, keeke oh bap̱aidḵu,’ aṯeb amu ag genab aṯeb amge ag Kayak nai laa ele dab meḵulag. Nai amuam inam. ‘Danab Beḵalag da, da guiṯak doop̱i, geḏilḵulag.’ ");
INSERT INTO gaw_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","Elias nug matu uḏiom amu ag nuhignu eheḏ heḵulagnu oolagp̱a dayom, yak niiṯe amubianab ag hep̱ig. Nai amunu niiom bia hep̱ig amunu danab beḵalagnu nai amu ele am anam beḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","Jesus Nug nuhiḵud ip̱uniṯak awak danab ewam ele ag anam anana amu ag nuhiḵud ip̱uniṯak awak danab laa gumadna gona, ag danab ah kuḏum qag mena daaegeg anadp̱ig. Ḏo mehuqak danab laala ag Jesusnu ip̱uniṯak awak danab ele awa awa qeṯak nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","Danab ah kuḏum ag Jesus anidna, ag oṯaina, ag ahan gumidna gona, “Aaḵu uḏime,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","Anam aeg amu Jesus Nug ip̱uniṯak awak danab ap̱a daap̱ig ele amu oḏ maṯom. “Ag keeke aḏinu ḏo mehuqak danab ele nai aeg ona aeg doṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","Nug anam a amu danab ah kuḏum oolagp̱an danab laa nug Jesusnu oḏ mak nob ma aum. “Ip̱uniṯak danab, nid dahil nug ouḏi nau ele, nai maṯiaknu elele iiṯa amunu da awe, na gumiṯe uḏimi. ");
INSERT INTO gaw_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","Haen kuḏum ouḏi nau amu nug he, nid dahil nug wanp̱a na qa, hipaḏu neene, nug aeg ganuḏaḏa, beḏu ele tai edaṯe. Amunu da nahipad ip̱uniṯak awak danab ouḏi nau amu lamidḵulagnu oḏ maṯami amge ag elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","Danab nug anam a amu Jesus Nug aum. “Ag oh oolagp̱a genab doyak iiṯa. Da ag ele haen elab daamut amge ag dahilnu oolagp̱a genab ii dooṯeb amunu da ool ug ele. Ag haen ganeb ag dahilnu oolagp̱a genab dooglag? Ag nid amu omalna dahilp̱a doig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","Nug anam a amu ag nid omalna, Jesus top̱a waeg, ouḏi nau nug Jesus anṯa, nug paha he, nid nug beḏu hahaḏeḏe, na qa wanp̱a niiaya, itoḏieye, hip̱aḏu neum. ");
INSERT INTO gaw_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","Anam heehe amu Jesus Nug nid mameg oḏ meṯom. “Nid imu nug inam heṯe ele amu, haen adeḵup̱anab dig meum?” Awa a amu nid mameg nug aum. “Nug nid nakokp̱a imu dig meum. ");
INSERT INTO gaw_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","Haen kuḏum ouḏi nau nug nid imu heeb mauhḵunu he, ab aḏup̱a o lep̱a na qeṯe amunu na elele dooṯem dayeb amu na ihinihnu oo doyak doona ehaniṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","Nug anam a amu Jesus Nug aum, “Da heḵulnu elele amge na amunu ootp̱a genab dooṯemte? Danab nug oop̱a genab doyak ele amu nug keeke oh heḵunu elele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","Jesus Nug anam a amu nid mameg nug aum. “Da oolp̱a genab nakokib dooṯem amge na hep̱e, oḵai baḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","Nug anam a amu Jesus Nug danab ah kuḏum qag meeg anṯa, Nug ouḏi nau amegp̱a, “Oḏe ituak, daug ituaknu ouḏi nau, na nid imu paḏaidna gona, bau eḏun nug beḏup̱a aib uḏime!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","Jesus Nug anam a amu ouḏi nau nug gayowa, nug nid huan uḏala, uuiṯa uḵom. Ugeḵe amu nid nug mauhak bia niieye, danab laala kuḏum ag, “Nug mauhom,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","Ag anam ap̱ig amge Jesus Nug nid ep̱egp̱a aḏe, aha hibaiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","Aria dimp̱a Jesus Nug laḵa uḵe, nug nuhiḵud ip̱uniṯak awak danab ele daanna, ag Nug oḏ medap̱ig. “Aḏinu ig ouḏi nau amu lamidḵunignu elele iiṯa?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","Aon aeg amu Jesus Nug aum. “Laa nug ouḏi nau imubia ib laap̱a ii lamidma. Iiṯa. Unuqiṯakp̱a aaḵuib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","Ag anam hewona amu ag ahan nona, Galelia wanp̱a Kapenaum goḵulagnu gonana, Jesus Nug danab laala nug anidḵulagnu oo ii dayom. ");
INSERT INTO gaw_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","Aḏinu? Nug nuhiḵud ip̱uniṯak awak danab nuhignu inam ip̱uanaṯaṯa aum. “Danab Beḵalag da amu danab laa nug da danab ep̱elagp̱a meiḏeb, ag hep̱eg, mauhḵul. Mauhoya amu deḏ ewamp̱a da eḏuen hip̱aidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","Nug anam a amu ag nai amunu oolag tutuḵu ii maiṯom amge ag Jesus Nug nai amu mehuqḵunu oḏ meṯaglagnu baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","Ag gona, Kapenaum tena, laḵa daanna amu Jesus Nug oḏ maṯom. “Ig ibp̱a oitta amu ag aḏi keekenu madip̱ig?” ");
INSERT INTO gaw_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","Nug anam oḏ maṯe amu ag ibp̱a, aun ag oolagp̱anu am oḵai dayom amu madip̱ig amunu ag Jesusnu oḏ mak amu nob ii mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","Ag anam heeg amu Jesus Nug ag onilagp̱a e doeg, Nug aum. “Danab laa nug anuqak daaḵunu oo dayeb amu nug danab laala oh waalagp̱anab dayaya, ahilag uḏat nid dayaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","Nug anam anana amu Nug nid nakok laa awa, ag oolagp̱a me, hibaiṯa dayeye, oḏoḵia aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“Danab laa nug da onilnu nid nakok laa imubia oo meṯa humidṯe amu nug da oo meḏa humiḏṯe. Amu laa nug da oo meḏa humiḏṯe amu nug daib ii humiḏṯe. Iiṯa. Nug da Mamel ele oo meṯa humidṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","Jesus Nug anam a amu Johanes nug Jesus amegp̱a aum. “Ip̱uniṯak danab, ig danab laa nug na oninp̱a ouḏi nau lamaṯe anidmut amge nug am ig dim lamiḵe ii oiṯem amunu ig nug ouḏi nau lamadmanu ḏo memut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","Awa a amu Jesus Nug aum. “Danab nug uḏat oḵai amubia da onilp̱a heṯe ele amu nug paha dahilnu nai eheḏ laa aḵunu elele iiṯa amunu ag nuhig uḏat amu aib oḵulp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","Aḏinu? Danab nug ihinig kekeḏ iiṯa amu nug am ig lainig. ");
INSERT INTO gaw_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","Anṯeg! Aun nug ag anaṯa, ag am dahilad amunu nug ag ehanaṯa, le ougib hai goḵoḏp̱a madaṯe amu Kayak Nug danab amu nob ena medaḵu, Nug daug iinab atima. ");
INSERT INTO gaw_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","Amge danab laa nug nid nakok laa, nug dahilnu oop̱a genab dooṯe ele amu, nuhig oop̱a genab doyak heeb aib nauhom. Nug anam heḵu am naunab. Nug ii heum haenp̱a danab ag nug baagp̱a men qaḵan, maop̱eg yup̱a noa mauhlo amuam nakok nau amge nug dayaya, nid nakok laanu oop̱a genab doyak heeb nauhḵu, amuam naunab nau. ");
INSERT INTO gaw_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","Na ep̱en amu nug na hip̱unin heḵutnu eeḏidṯe dayeb amu na ep̱en laih amu oḵule! Na ep̱en laihigib ele daanna, na haen oh bauklel daaḵut, amuam ena. Amge na ep̱en aḏit oh ele daaḵut amu ag na aben eheḏp̱a mawidp̱eg goḵut amuam ena iiṯa. Ap̱anu ab amu nug ii qauhṯe. ");
INSERT INTO gaw_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","Ge! Ap̱a amu gauat ag ii mauhṯeb amu ab ele nug ii qauhṯe. ");
INSERT INTO gaw_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","Amu na baen nug na hip̱unin heḵutnu eeḏidṯe dayeb amu na baen laih amu oḵule! Na baen laihigib ele daanna, na haen oh bauklel daaḵut amuam ena. Amge na baen aḏit oh ele daaḵut amu ag na mawidp̱eg, aben eheḏp̱a goḵut amuam ena iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","Ap̱a amu gauat ag ii mauhṯeb amu ab ele nug ii qauhṯe. ");
INSERT INTO gaw_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","Laa ele amu na amen nug na hip̱unin heḵutnu eeḏidṯe dayeb amu na amen laih amu kehan, maop̱e uḵaḏ! Na amen laip̱uib ele hab abp̱a goḵut amuam ena. Amge na amen aḏit oh ele daanna, aben eheḏp̱a goḵut amuam ena iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","Ap̱a amu gauat ag ii mauhṯeb amu ab ele nug ii qauhṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","Yu ab ele am nakok uḏat laip̱u bia heṯep amu Jesus Nug nai baula tuḏiṯa aum. “Ab nug keeke laala ewe, op̱ia awak daaṯe. Yu kalu amu nug ele anam. Aria ag da dim lamiḏṯeb ele amu deḏ laala ag ug anidḵulag. Ug amuam yu kalu ewak bia. Nug heeb, ag elele oiglag. ");
INSERT INTO gaw_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","Yu kalu am keeke ena amge nug yu ubuhi iiṯa dayeb amu aṯem hep̱ut, nug eḏua ubuhi ele daaḵu? Dahil nai am yu kalu ena, nuhig ubuhi ii iiṯa meum ele, amubia amunu ag dahil nai tutuḵu doonna, ag hanhan maḏoḏ daanna oiyeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","Jesus anam ana mala amu Nug Kapenaumnu aha uḵa, Juda wan laa Jodan le laih dayom ele amu ap̱a uḵom. Uḵa ap̱a dayeye amu danab ah kuḏum ag Nug gumidna uḵaeg, Nug kobol hanhan heṯom amubia ag amelagp̱a Kayak nai ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","Haen amup̱a amu ḏo gumak danab-Parasia ag Jesus gumidna gona, Nug inam oḏ medap̱ig. “Ihinig ḏop̱a amu danab laa nug ah nuhig lamiṯeb goḵu am enate o ena iiṯate?” aon ap̱ig. Ag Jesus aḏaglagnu ib anidḵulagnu anam oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","Ag anam oḏ meṯaeg amu Jesus Nug oḏelagp̱a awa, oḏ maṯom. “Keeke amunu amu Moses nug ḏo aṯem meum?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","Nug anam a amu ag ap̱ig. “Moses nug inam aum. ‘Danab laa nug wau lamidḵunu oo dayeb amu nug nai amu uḏugp̱a ya, wau meṯowa, lamiṯeb goḵu,’” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","Ag anam aeg amu Jesus Nug aum. “Ao, amge ag am oo doyak ele ii dooṯeb amunu ag ah ug oḵai maṯamnanu, ag hamu lamadmananu, Nug ḏo bau, ag geha iiḵu amunu ap̱ig amu meum. ");
INSERT INTO gaw_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","Amge tatam keeke oh heum haenp̱a amu anam iiṯa. Haen amup̱a Kayak Nug aḏi heum amu danab laa nug amunu inam yom. ‘Kayak Nug danab ah ele hatom,’ ");
INSERT INTO gaw_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","amunu diig amunu danab nug anig mameg ele uuata, nug wau ele ou qeya, ");
INSERT INTO gaw_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","aḏit amu a beḏulah laip̱u daaglah. A anam heya, a baula aḏit iiṯa. A am beḏulah laip̱u. ");
INSERT INTO gaw_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","Aria ag doyeg! Danab ah ele a nug aoṯep amu Kayak Nug nuḵa matulatom amunu danab laa nug amu aib otaḏom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","Nug anam a amu Nug nuhiḵud ip̱uniṯak awak danab ele ag ahan, laḵa gona, ag Jesus nai amunu oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","Oḏ meṯaeg amu Nug ag amelagp̱a aum. “Danab laa nug ah nuhig lamiṯowa, nug ah bau aoṯe amu danab amu nug gap̱ai kobol heṯe. ");
INSERT INTO gaw_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","O ah laa nug danab nuhig lamiṯowa, nug danab bau aoṯe amu ah amu nug gap̱ai kobol heṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","Aria danab ah ag nid naunau omaladna, Jesus Nug ep̱eg beḏulagp̱a ma, itiṯak madaḵunu gumidna uḵaeg amu Jesusnu ip̱uniṯak awak danab ag anadna, laa nid omaladna uḏip̱ig ele amu aladp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","Ag alaṯegeg, Jesus Nug anaṯa, kobol hep̱ig ele amunu nug oo nauhe, amelagp̱a aum. “Danab ag nid naunau bia daaṯeb, ag am Kayaknu ḏo maḏoḏ oop̱a daaṯeb amunu ag nid uuadp̱eg, dahilp̱a doig! Ag ib ahilag aib oo nep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","Da genab ag amelagp̱a aṯem. Danab nug Kayaknu ḏo maḏoḏ nid nakok aoṯe amubia ii aoḵu amu nuhignu ib laa iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","Nug anam anana amu nug nid naunau oḏakiaṯa, ep̱eg beḏulagp̱a ma, itiṯak maṯom. ");
INSERT INTO gaw_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","Jesus Nug anam ha mala amu Nug ibp̱a ugeḵe, danab laa nug qaibaḏ Jesus gumiṯa uḵa, Jesus baegp̱a gateg qaun wa aum. “Ip̱uniṯak danab ena, da bauklel hanhannu aoḵulnu amu da aṯem heḵul?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","Nug anam a amu Jesus Nug aum. “Kayak Nug nuḵa am ena amunu na dahilnu, ‘Danab ena,’ ame amu na nai amunu tatam dab mewona ame, o iiṯa na hamute ame? ");
INSERT INTO gaw_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","Amge nahip oḏ maknu amu na ḏo oh dooṯem. Na gap̱ai kobol aib heme. Na danab aib qep̱e mauhom. Na yabhoi aib heme. Na danab laanu ham bup̱uak nai aib maṯime. Na kobol ham bup̱uakp̱a keeke aib aome. Na anin mamen ele oḏelah dim lamidna binalah me!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","Jesus Nug anam a amu danab amu Nug aum. “Ip̱uniṯak danab, da nid nakok dayeye, ḏo amu oh dim lamiṯi uḏie, gemu ele anamib heṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","Awa a amu Jesus Nug danab amunu dab mak awa, nuhignu oo mauhe amu nug amegp̱a aum. “Keeke laip̱unu amup̱aib na elele iiṯa. Na gona, na enun oh mep̱e, danab laala daden mep̱eg, na men doḏo amu oh aon, daḏek danab maṯona, na hab aṯan enun oḵai ele daaḵut. Na anam hewona amu na eḏun da dim lamiḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","Jesus Nug anam a amu danab amu nug nai amunu iḏu tiguguḏe, nug eḏua, oo ug ele uḵom. Aḏinu? Nug enub kuḏum ele. ");
INSERT INTO gaw_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","Nug ugeḵe amu Jesus Nug eḏua, ip̱uniṯak awak danab nuhiḵud ag amelagp̱a aum. “Danab ag enulag kuḏum ele amu ag Kayaknu ḏo maḏoḏ oop̱a goḵulagnu am ug oḵai ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","Jesus Nug anam a amu nuhiḵud ip̱uniṯak awak danab ag nai amu doon, dab mak kuḏum aweg anaṯa amu Nug ag amelagp̱a aum. “O nid naḵud, Kayaknu ḏo maḏoḏ oop̱a goḵunu am ug ele. ");
INSERT INTO gaw_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","Doḏ laa onig kamel nug koitaknu tutui giḏop̱a noḵunu am ug ele amge danab nug enub kuḏum ele amu, nug Kayak ḏo maḏoḏ oop̱a goḵunu am ugnab ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","Jesus anam a amu nuhiḵud ip̱uniṯak awak danab ag oṯainna, aḵa aḵa ap̱ig. “Anam dayeb amu aun nug bauklel aoḵunu elele?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","Aon aeg amu Jesus Nug tutuḵu neeḵaṯa aum. “Danab ag aḵa elele iiṯa amge Kayak Nug anam bia ii daaṯe. Kayak Nug keeke oh heḵunu elele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","Jesus Nug anam a amu Petrus nug aum. “Ig ihinig keeke oh uut, na dim lamidṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","Awa a amu Jesus Nug eḏua ag oh amelagp̱a aum. “Da genab ag amelagp̱a aṯem. Danab laa nug dahilnu amu dahil Nai Enanu ele ha, nug anig, mameg, amag, awag, ap̱inag, nug wau, beḵod, aḏeḵud, nug laug amu nuhig dad ele uuaṯa, da dim lamiḏṯe, ");
INSERT INTO gaw_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","nug geha haen imup̱a hamu ii daama. Iiṯa! Nug awaḵud, amaḵud, ap̱inḵud, aniḵud, nid naunau amu dad ele tuḏiṯa, wan handat baula aoḵu. Laa ele amu danab laala ag qagaiṯak kuḏum meṯaglag amge nug bau hanhan aoḵu. ");
INSERT INTO gaw_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","Amge danab kuḏum anuqak daaṯeb amu ag dim daaglag. Am kuḏum laa ag dim daaṯeb amu ag anuqḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","Amu ag Jerusalem goḵulagnu ibp̱a gonana amu Jesus Nug anuqa ugeḵe, ip̱uniṯak awak danab ag dab mak kuḏum aonna, dim lamidp̱ig. Danab laala Jesus dim lamidp̱ig ele amu, ag ahilagp̱a aḏi beḵunu baḏanna, dim lamidna gop̱ig. Anam gonana amu Jesus Nug nuhiḵud ip̱uniṯak awak danab ag onilagp̱a e, gumidna uḵaeg, Nug diiaṯa, piḏe wana, nuhigp̱a keeke aḏi beḵu amunu amelagp̱a inam aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","“Doyeg! Ig gemu iiḵu Jerusalem goṯem. Gop̱ut, laa nug Danab Beḵalag da, mana meṯak danab oḵai amu ḏo mehuqak danab ele ag ep̱elagp̱a meiḏeb, ag da heṯoḏiakp̱a meiḏna, iup̱eg mauhḵulnu nai qaḵana, ag da iiṯa aḏi ep̱elagp̱a meiḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","Meiḏp̱eg amu iiṯa aḏi ag aon aon iuna, wipp̱a eheḏ mataḏilna, hunu iuna, iup̱eg mauhp̱i, deḏ ewam uueb amu da eḏuen bau ahaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","Amu dimp̱a Sebedi bekoḏ Jakobus, Johanes ele, a Jesus gumidya goya apiḏ. “Ip̱uniṯak danab, na ihinihnu keeke laa heḵutnu oonih daaṯe,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","Anam aeh amu Jesus Nug oḏ matom. “Da ahilahnu aḏi heḵulnu oolah daaṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","Awa a amu a apiḏ. “I oonih inam daaṯe. Dimp̱a na oḵai daanna, wan imu oh gumanna, na ap̱e, i amu na heqon laih laih daagnih. Laa na heqon naḏiap̱a dayebeb, laa na heqon nanehp̱a daaḵu,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","A anam aeh amu Jesus Nug a amelahp̱a aum. “A aṯep amu a keeke amu ii dooṯep. Keeke eheḏ laa da toniḏḵu, keeke amuam le mua bia, a le mua amu, da laḵul amubia laḵulahnu elelete?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","Awa a amu a apiḏ. “I am elele!” A anam aoya aeh amu Jesus Nug aum. “Genab le mua ele, da laḵul amu a ele laḵulah ");
INSERT INTO gaw_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","amge aun nug da heqol naḏiapp̱a daaḵu, aun nug da heqol nanehp̱a daaḵu amu da aḵulnu elele iiṯa. Da Mamel Kayak Nug aben aḏit amu aunnu babaiṯom amu a aaḵuib amup̱a daaglah,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","Jesus, Jakobus, Johanes ele ag anam maṯiegeg amu ip̱uniṯak awak danab eblaih tanig ele laa ag doona, ag Jakobus, Johanes ele ahilahnu oolag nauhom. ");
INSERT INTO gaw_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","Oolag nauhe amu Jesus Nug ag oh onilagp̱a e, gumidna doeg, Nug ag amelagp̱a aum. “Ag dooṯeb, wan imup̱an danab ah oh ag danab oḵai waalagp̱a daaṯeb amu danab oḵai ag ḏo aḏi meṯeb amu danab ah ag amuib dim lamidṯeb. ");
INSERT INTO gaw_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","Amge kobol amu ag oolagp̱a aib dayom. Iiṯa. Danab laa nug ag oolagp̱a oḵai daaḵunu oo dayeb amu nug ahilag ehaniṯak dayaḏ! ");
INSERT INTO gaw_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","Amu ele danab laa nug ag oolagp̱a anuqak daaḵunu oo dayeb amu nug ahilag begbeg dayaḏ! ");
INSERT INTO gaw_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","Ag anam heḵulagnu diig amu Danab Beḵalag da, da wan imup̱anu danab ah ag da ehaniḏḵulagnu ii uḏimi. Iiṯa! Da ag ehanadḵulnu uḏimi amu da dahil mauhakp̱a danab ah kuḏum bauklel hanhannu aoglagnu ele uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","Ag ibp̱a gona, Jeriko ap̱a tena, Jesus Nug nuhiḵud ip̱uniṯak awak danab amu danab ah laala kuḏum ele ag Jeriko eḏidna uḵaegeg, Timon beḵa Batimias, nug ameg gaḏuak amu, nug ap̱a ib daugp̱a dayaya, danab men doḏo keeke, meṯaglagnu unuqadṯom. ");
INSERT INTO gaw_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","Nug unuqaṯa dayaya amu nug, “Nasaret ted Jesus uḏiṯe,” doya, nug huanak ewa aum. “Dawit beḵa Jesus, na dahilnu oot gai iiṯa doye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","Nug anam aawo amu danab laala kuḏum ag aidna ap̱ig. “Na oḏen qamute!” aon ap̱ig amge nug nai amu ii doya, baula huanak ewa aum. “Dawit beḵa, na dahilnu oot gai iiṯa doye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","Nug anam eewo, Jesus Nug doya amu Nug hibaiṯa dayaya, amelagp̱a aum. “Ag onigp̱a ep̱eg doaḏ!” awa aum. Nug anam a amu ag danab ameg gaḏuak ele amegp̱a ap̱ig. “Na oot gamag ahaḏ! Na Nug gumidna goḵutnu aum amunu na ahan wa!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","Ag anam aeg, nug doya, nug lamen ulahnu uḏowa, paha aha, Jesus gumiṯa waum. ");
INSERT INTO gaw_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","Nug gumiṯa wa amu Jesus Nug oḏ meṯom. “Da nahipnu aḏi heḵulnu oot daaṯe?” awa aum. Awa a amu nug aum. “Ip̱uniṯak danab, na hep̱e, da neegḵulnu ool daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","Danab nug anam a amu Jesus Nug aum. “Na dahilnu ootp̱a genab doome amunu na neegḵutnu elele. Enad uḵe!” awa aum. Nug anam a amu pahanab danab amu nug neeḵunu elele dayom amunu nug Jesus ibp̱a dim lamiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","Aria ag gona, Jerusalem guḵuidna, ag Beṯani, Betpasi, Olipnu Qauko ele guguiṯak ap̱a, Jesus Nug ip̱uniṯak awak danab aḏit amelahp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“A goya, ab nakok miag amup̱a teya, ap̱a ab daugp̱a a donki nag laa nakok oḵai meum qaḵak daaṯe ana anidḵulah. Donki amu nug bau, danab laa nug aṯan ta ii oiyom. Anidya amu uhuqya, aoya uḏieḏ! ");
INSERT INTO gaw_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","A anam hebepeḏ amu danab laa nug, ‘Aḏinu a anam heṯep?’ ab amu a inam aiḏ! ‘Naḏi Nug donki imunu uḏat ele. Haen elabnu iiṯa. Nug paha eḏua meeb uḏiḵu.’ A anam aiḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","Jesus Nug anam a amu a goya, donki bau ab oop̱anu ibp̱a lag odp̱a qaḵak dayeye anidpiḏ. Anidya amu a uhuqeheh, ");
INSERT INTO gaw_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","danab laala ag guguiṯak daanna, ag oḏ matap̱ig. “Aḏinu a donki amu uhuqṯep?” ");
INSERT INTO gaw_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","Oḏ mataeg amu a Jesus aum Nug oḏe bia aeh amu ag, “Ena,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","Ag anam aeg, ip̱uniṯak awak danab aḏit a donki amu aoya, Jesus gumidya uḵaeh, ag lamen ulahnu donki gomep̱a duqeg, Jesus Nug donki aṯan teum. ");
INSERT INTO gaw_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","Ta dayeye amu danab kuḏum ag ahilag lamen ulahnu ib manp̱a duqaegeg, laala ag ad ep̱eg oḵulna, ib manp̱a mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","Anam duqegeg, Jesus ugeḵe, amu danab laala ag anuqna, Jesus noobp̱a uḵaegeg, laala ag Jesus dim lamiṯegeg amu ag oh enan ap̱ig. “Ig Kayak onig humatu! Danab imu Nug Kayak onigp̱a uḏiṯe, Kayak Nug itidṯe. ");
INSERT INTO gaw_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","Danab imu Nug ig alanig Dawit dayom amubia daaḵunu uḏiṯe amu Kayak Nug itidṯe. Kayak, Nug aṯan daaṯe ele amu, ig Nug onig humatu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","Ag gona, Jerusalem tena amu Jesus Nug Juda dilag mana meṯak lag oop̱a noa, keeke oh anaṯa malowa, tueb meum amunu Nug nuhiḵud ip̱uniṯak awak danab ele ag eḏun, Beṯani gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","Aria deḏ amu dimp̱a, buṯua amu ag Jerusalem goḵulagnu Beṯaninu ahan uḵaegeg, Jesus Nug enug qeum. ");
INSERT INTO gaw_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","Ag gonana amu Jesus Nug neeḵe, nakok uma uḵe, ad pig anṯom. Ad amu nug uḏug kuḏum amunu Jesus Nug meu aoḵunu guḵuita uḵa, meunu haen iiṯa amu Nug meunu neeḵa, Nug meu laa ii anṯom, uḏugib. ");
INSERT INTO gaw_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","Anam anṯom amunu Nug aum. “Na baula meut iinab omana!” awa aum. Awa a amu nuhiḵud ip̱uniṯak awak danab ag nai amu doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","Doona amu ag gona, Jerusalem tena amu Jesus Nug Juda dilag mana meṯaknu lag oop̱a noa, Nug danab lag amu oop̱a mana meṯaknu keeke dadennu maadp̱ig, laala daden mep̱ig ele amu Nug ag oh lamaṯom. Ap̱an danab laala ag men doḏo baolip̱ig ele amu nug ahilag balal huma awe, uḵa na qe, am laala ag up̱uḏil meeg, daden maadp̱ig ele amu ahilag dayak aben ele huma awe, uḵa na qeum. ");
INSERT INTO gaw_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","Laa ele amu Jesus Nug, “Ag keeke aon laih goḵulagnu amu ag Kayak laug oop̱a nona goḵulagnu am elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","Jesus Nug anam hewowa amu Nug ag amelagp̱a aum. “Kayak naip̱a yak inam daaṯe. ‘Da laul am danab oh dilag unuqiṯak lag,’ amge ag heeg, nug yabhok danab dilag loḵumak aben bia daaṯe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","Jesus Nug anam a amu mana meṯak danab oḵai amu ḏo mehuqak danab ele ag danab ah laala kuḏum Jesusnu nainu oolag dayom anidp̱ig amunu ag Jesusnu baḏan, qep̱eg mauhḵunu ib madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","Jesus Nug anam he amu tueb meeme, Jerusalem oop̱a niiak aben oh am beum amunu Nug nuhiḵud ip̱uniṯak awak danab ele ag ahan, ab laap̱a niiglagnu gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","Ag niip̱ig buṯua amu ag eḏun, Jerusalem goḵulagnu ahan gona, ibp̱a ag ad pig, Jesus ad amunu meu baula ii omanu aum ele amu, nug ep̱eg diḏi oh bunaḏom anidna, ");
INSERT INTO gaw_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","Petrus nug dab mak awowa, Jesus amegp̱a aum. “Ip̱uniṯak danab, anṯe! Tumai na ad pig bunaḏḵunu ame amu aaḵu bunaḏom!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","Petrus nug anam a amu Jesus Nug aum. “Ag unuqiṯakp̱a keeke laa hep̱eg beḵunu oolag dayeb amu ag Kayak Nug heḵunu amu ag oolagp̱a genab doyeg! ");
INSERT INTO gaw_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","Da genab ag amelagp̱a aṯem! Danab laa nug Kayaknu oop̱a genab doyak ele, nuhig dab mak aḏit iiṯa amu nug qauko imu amegp̱a, ‘Na ahan yup̱a uḵe!’ ab amu nug anam heḵu. ");
INSERT INTO gaw_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","Amunu ag keeke laa beḵunu unuqidnana, ag aoglagnu oolagp̱a genab doonna amu ag unuqidp̱ig amubia ag aoglag. ");
INSERT INTO gaw_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","Laa ele amu na unuqidnana, na Mamen, hab aṯan daaṯe, Nug nahip hip̱unin uhuqa medaḵunu amu danab laa nug nahipnu eheḏ heum dayeb amu na hip̱unin amu uhuqna meṯe! ");
INSERT INTO gaw_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","Amge na danab laanu hip̱unin uhuqna ii medap̱e amu na Mamen, Nug hab aṯan daaṯe amu, Nug ele nahip hip̱unin uhuqa ii meṯama.” ");
INSERT INTO gaw_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","Ag nai amu maṯinna gona, Jerusalem tena amu Jesus Nug mana meṯak lag oop̱a noa oiyeye, mana meṯak danab oḵai amu ḏo mehuqak danab amu Israel dilag gumak danab ele ag Jesus gumidna gona, ");
INSERT INTO gaw_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","Nug oḏ medap̱ig. “Na g̱agaṯag aḏip̱a uḏat imu heṯem? Aun g̱agaṯag amu meṯe, na uḏat imu heṯem?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","Ag anam aeg amu Jesus Nug aum. “Da ele ag keeke laip̱unu oḏ madap̱i, ag nob mep̱eg amu da g̱agaṯag aḏip̱a uḏat imu heṯem, diig amu ap̱i dooglag. ");
INSERT INTO gaw_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","Oḏ mak dahil am inam. Johanesnu layaṯak am adep̱anu beum, keeke amuam hab aṯannu keeke o iiṯa amuam danabnu keekeib? Ag amu ap̱eg dooḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","Jesus anam a amu ag aḵa aḵa maṯin ap̱ig. “Ig, ‘Habnu keeke,’ ap̱ut amu Nug, ‘Anam amunu ag aḏinu oolagp̱a genab ii doop̱ig?’ aḵu. ");
INSERT INTO gaw_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","Amge ig, ‘Danabnu keeke,’ ap̱ut amu danab ah oh ag Johanesnu, nug am propet oolagp̱a genab dooṯeb amunu ag iqap̱eg mauhḵunig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","Ag aḵa aḵa anam anana amu ag Jesus amegp̱a ap̱ig. “Ig ii dooṯem,” aon ap̱ig. Aon aeg amu Jesus Nug aum. “Aaḵu amunu da ele g̱agaṯag aḏip̱a uḏat heṯem amu da ap̱i ii doomna,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","Jesus Nug anam awowa amu Nug dig ma, keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, inam aum. “Danab laa nug grep dad ep̱owa, aḏ ita, dad oop̱a grep lep̱u awaknu aben laa ha, nug dad gumak danabnu lag elab laa ele heum. Aria nug uḏat amu oh ha mala, uḏat hak danab ep̱elagp̱a mewowa, nug aha, atu laih umanab uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","Uḵa dayeye amu grep meu awak haen be, nug begbeg danab nuhig me, grep meu laih nuhig aoḵunu uḏat hak danab gumaṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","Uḵe amu dad uḏat hak danab ag aḏanna, maḵuḏna meeg, eḏua hamu uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","Eḏua uḵe amu dad mameg nug begbeg laa me uḵe, dad uḏat hak danab ag danab amu iḵi ona, kobol eheḏ laala ele nuhigp̱a hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","Anam heeg amu nug begbeg laa ele me uḵe, dad uḏat hak danab ag nug qeeg mauhom. Mauhe amu dad mameg nug laala ele maaṯe uḵaeg, dad uḏat hak danab ag laala maḵuḏadna, laala ag aqaeg mauhp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","Dad mameg nug anam ha mala amu nug beḵa, nug beḵa laa iiṯa, laip̱uib, nug nuhignu oo huan mauhṯom ele amu nug me ugeḵe, inam aum. ‘Da beḵal amu ag nug oḏe dooglag,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","Nug anam a, nug beḵa uḵe amu dad uḏat hak danab ag anidna, ag aḵa aḵa ap̱ig. ‘Nid imu nug dimp̱a mamegnu keeke oh aoḵu amunu ahap̱eg, ig qep̱ut mauheb, dad imu amu ihinig daaḵu,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","Ag anam anana amu ag ahan gona, nid amu qeeg mauhe, ag nug gaḏa buḏieg, dad dimiṯim uḵom.” Jesus Nug anam maṯiom. ");
INSERT INTO gaw_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","Jesus Nug anam anana amu Nug nai tuḏiṯa oḏ maṯom. “Ag anam hep̱ig amunu dad mameg nug ahilagnu aḏi heḵu? Da ag amelag̱pa aṯem. Dad mameg nug aha uḵa, nuhig dad uḏat hak danab amu oh aqeb mauhp̱eg amu nug grep dad amu eḏua awa, danab laala ep̱elagp̱a meḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","Nug anam anana amu Jesus Nug tuḏiṯa aum. “Ag nai laa Kayak naip̱a daaṯe ele amu, ag iite eb qep̱ig. Nai amuam inam. ‘Men laa amu lag hak danab ag men amu uup̱ig amge lag mameg nug men amu awa me, lagnu men anuqak daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","Naḏi Nug keeke amu he beum amunu ig amenigp̱a anidta oṯaiṯem,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","Jesus Nug anam a amu Juda danab oḵai ag Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯak nai amu ag eheḏ hak ahilag anidḵulagnu maṯiom doop̱ig amunu ag Jesus aḏaglagnu ib madip̱ig. Madip̱ig amge ag danab ah laala kuḏum ele baḏadp̱ig amunu ag Jesus uuidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","Ag gona amu ag ḏo gumak danab-Parasia amu Herodesnu ehaniṯak danab oolagp̱anu laip̱u laip̱u ele maaṯeg gona, ag Jesus takisnu oḏ medap̱eg, Nug eheḏ ab, ag Nug aḏaglagnu gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","Ag gumidna gona amu ag ap̱ig. “Ip̱uniṯak danab, ig dooṯem, na am danab tutuḵu. Na danab oḵai onig ele o danab onig iiṯa amu na amu ohnu dab ii meṯem. Iiṯa, na nai genabib aṯem. Na nai genab amup̱aib danab ah Kayaknu kobol ip̱uanadṯem amunu keeke imunu ap̱e doognig. Na aṯem dooṯem? Ig takis Kaisa meṯagnig am ena o ena iiṯa? ");
INSERT INTO gaw_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","Ig meṯagnig o iiṯa?” aon ap̱ig. Ag anam ap̱ig amge Jesus Nug ahilag dab mak ham bup̱uak doya, Nug aum. “Aḏinu ag da aḏailḵulagnu heṯeb? Ag men doḏo laa onig danarius aon dop̱eg, da anṯe!” awa aum ");
INSERT INTO gaw_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","Awa a amu ag men doḏo laa aon doeg, Jesus Nug ag oḏ maṯom. “Men doḏo amup̱a am aun onig doṯog ele daaṯe?” awa aum. Awa a amu ag, “Kaisanu,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","Ag anam aeg amu Jesus Nug aum. “Aria ag Kaisanu keeke amu ag Kaisa meṯaglag amge Kayaknu keeke amu ag Kayak meṯeg!” awa aum. Awa a amu ag dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","Aria ḏo gumak danab-Sadusi ag Jesus top̱a uḏip̱ig. Danab amu ag, “Danab mauhṯeb amu ag eḏun ii hip̱aidmana,” aon adap̱ig amunu ag Jesus oḏ meṯan ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“Ip̱uniṯak danab, Moses nug ihinignu nai laa inam yom. ‘Danab ah ele a ewau daaiya, a nid ii aopiḏ haenp̱a danab nug mauheb, ah nug bau dayebeb amu danab amu amag nug ah amu aweb, a nid menuglah amge a nid menuglah amu, nid amuam danab amunu iiṯa. Nid amuam nug awag beḵa daaḵu.’ ");
INSERT INTO gaw_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","Aria haen laa e amaḵud eblaih aḏit daap̱ig. Ag anam daanna, awalag tatamnu nug ah awa, nid iiṯa mauhom. ");
INSERT INTO gaw_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","Mauhe amu nug dimugp̱anu nug ah amu awa, nug ele nid iiṯa mauhom. Mauhe nug dimugp̱anu ele anamib. ");
INSERT INTO gaw_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","Aria laa oh ele anam ah amuib aona mauheg, dimp̱a ah amu nug ele mauhom. ");
INSERT INTO gaw_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","Aria eamaḵud amu oh ag ah amu aaḵuib aweg, nug ag waalag dayom amunu eḏua hibaiṯak haenp̱a amu ah amu nug eamaḵud eblaih aḏit amu ag oolagp̱a aunnab wau daaḵu?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","Ag anam aeg amu Jesus Nug aum. “Ag Kayaknu nai ii doonna, Kayaknu g̱agaṯag amu ele ag ii dooṯeb amunu ag nai augigiak, diig iiṯa madiṯeb. ");
INSERT INTO gaw_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","Eḏua hibaiṯak haenp̱a amu danab ag ah ii diimna, ah ele ag danab ii diimna. Iiṯa, ag engel hab aṯannu bia daaglag. ");
INSERT INTO gaw_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","Amge danab mauhna, eḏun hip̱aidṯeb keeke amunu amu ag Moses nug Kayak naip̱a nai laa yom amu ag iite eb qep̱ig? Haen amu ab ewewe, ad ewa iiṯa ii meeme, Moses nug andeṯe, Kayak Nug Moses amegp̱a a amu nug Kayak oḏe inam yom. ‘Da amu Abrahamnu Kayak, Isaknu Kayak amu Jakopnu Kayak ele,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","Kayak Nug anam aum amunu ig dooṯem, danab ewam amu ag gemu daaṯeb. Ag mauhp̱ig amge ag iiṯa ii mep̱ig amunu Kayak Nug danab daaṯeb dilag Kayak daaṯe. Nug anam daaṯe amunu Nug ele heeb, ag eḏun hipaidḵulag. Ag ḏo gumak danab-Sadusi, ag eḏua hibaiṯak amunu ag ootot oḵai aqe heṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","Jesus Nug anam a amu ḏo gumak danab laa nug ag nai amu maṯin heegeg doya, Jesus Nug nob ena meum ele doya amu nug Jesus inam oḏ meṯom. “Ihinig ḏo aṯen amu nug anuqak daaṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","Nug anam a amu Jesus Nug oḏep̱a awa aum. “Ḏo anuqak am inam. ‘O Israel, ag doyeg! Kayak, Nug ihinig Naḏi amu, Nug nuḵa Kayak daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","Naḏi, Nug am nahip Kayak amu, na ootp̱a, na ouḏinp̱a, nahip dab makp̱a amu nahip keeke ohp̱a ele nuhignu oot mauhaḏ!’ ");
INSERT INTO gaw_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","Aria ḏo amu dimugp̱a amu inam. ‘Na naḵa nahipnu oot mauhṯe, amubia na danab laa dilag ele oot mauhaḏ!’ Ḏo laip̱u laa amu aḏit imu ii eḏat-te,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","Jesus Nug anam a amu ḏo mehuqak danab nug aum. “Ip̱uniṯak danab. Na ena ame! Na ame am genab. Kayak Nug nuḵa Kayak daaṯe, laa iiṯa ");
INSERT INTO gaw_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","amu ig genab ig oonigp̱a, ihinig dab makp̱a, ihinig keeke ohp̱a nuhignu oonig mauhḵu amu ig iḵa ihinignu oonig mauhṯe amubia ig laa dilag oonig mauhḵu, keeke aḏit amu a mana meṯak oh eḏidṯep,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","Danab nug anam a amu Jesus Nug nob nuhig am ena anṯa, nug amegp̱a aum. “Na Kayaknu ḏo maḏoḏ oop goḵutnu amu na ib amu oḏep̱a daaṯem!” awa aum. Awa a amu danab laala ag dab mak eheḏp̱a ele ag Jesus keeke laanu oḏ meṯaglagnu baḏana, ii hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","Aria Jesus Nug mana meṯak lag oop̱a dayaya, danab ah ip̱uanaṯaṯa amu Nug ag oḏ maṯom “Ḏo mehuqak danab ag, ‘Kayak Nug laa tituanom, amuam Kristus, Nug am Dawit beḵa,’ aon aṯeb amge aṯem doona, ag anam aṯeb? ");
INSERT INTO gaw_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","Aḏinu? Kayak Ouḏi Nug he, Dawit nug inam aum. ‘Naḏi Jehowa Nug dahil Naḏi amegp̱a inam aum. “Na da ep̱el naḏiapp̱a daap̱p̱e uḵeb, da nahip kekeḏ na waatp̱a maadḵul.” ’ ");
INSERT INTO gaw_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","Ag iiḵud anṯeg! Danab nug, nug beḵanu, ‘Naḏi,’ ii aṯe amge Dawit nug nuḵa, nug beḵanu, ‘Naḏi,’ aum amunu ig aṯemun Kristusnu, ‘Nug am Dawit beḵaib,’ aḵunig?” awa aum. Awa a amu abp̱an danab ag nuhig nainu oolag gamag ahom. ");
INSERT INTO gaw_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","Jesus Nug anam anana amu Nug nai baula tuḏiṯa, danab ah amelagp̱a aum. “Ḏo mehuqak danab ag lamen enanag elab ele taḵana, danab ah noolagp̱a oiglagnu oolag anuqak dayeye, ag danab laala ag humadḵulagnu oolag oḵai ele daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","Ag nai doyak laḵa amu hobul haenp̱a ele amu ag aben anuqakp̱a daaglagnu iṯag aqaṯe amge ag ahilag kobol amu hemananu dab meig! ");
INSERT INTO gaw_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","Ḏo mehuqak danab ag anam henana amu ag ah qab ham bup̱ualadna, laulḵad yab awona, ahilag hip̱unin amu danab ah amelagp̱a loḵumḵulagnu ag unuqiṯak elab heṯeb amunu epeḏiak haenp̱a geha ag ug oḵainab aoglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","Jesus nai amu maṯiom dimp̱a amu Nug men doḏo mak aben guguiṯak dayaya, Nug danab laala men doḏo kunupp̱a meegeg anaṯom. Laala, ag enulag kuḏum ele amu ag kuḏum mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","Meegeg amu ah qab daḏek ele nug ap̱a uḵa, men doḏo aḏit, wan toea bia, kunupp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","Me amu Jesus Nug nuhiḵud ip̱uniṯak awak danab onilagp̱a e doeg, Nug ag amelagp̱a aum. “Da genab ag amelagp̱a aṯem. Ah qab daḏek ele imu nuhig men doḏo kunupp̱a meum amu danab laala mep̱ig ele amu oh eḏadṯe. ");
INSERT INTO gaw_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","Aḏinu? Laa oh ag men doḏo kuḏum ele amu, ag laih nakok amup̱an aon mep̱ig amge ah imu nug men doḏo nakoknab nuhig, nug ehanidḵunu dayom, amu oh meum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","Jesus Nug anam a amu Nug nuhiḵud ip̱uniṯak awak danab ele ag ahan, mana meṯak lag dimiṯim gonana, nuhig ip̱uniṯak awak danab laa nug Jesus amegp̱a aum. “Ip̱uniṯak danab, anṯe! Ag men enap̱aib lag imu oh ena hep̱ig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","Nug anam a amu Jesus Nug aum. “Ag lag oḵai imu anadṯeb amge dimp̱a ag men imu lop̱aḏp̱eg, nena qena, laa nug laa qaḏep̱a iinab daama. Ohnab lop̱aḏp̱eg, honap nena qeḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","Aria Jesus Nug aaḵu mana meṯak laḵanu aha noa, Olip qaukop̱a ta dayeye amu Petrus, Jakobus, Johanes amu Andreus ele ag aḵa gumidna gona, ");
INSERT INTO gaw_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","Nug oḏ medap̱ig. “Na amenigp̱a ame amu kobol amu haen genab beḵu? Amu ele ep̱onak keeke aḏi tatam beeb, keeke amu oh beḵunu miag daaṯe amu ig doognig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","Ag anam aeg amu Jesus Nug aum. “Danab laa ag bup̱ualadmanu ag dab meig! ");
INSERT INTO gaw_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","Aḏinu? Danab kuḏum ag da onilp̱a uḏin, ‘Da am Kristus’ anana, kuḏum laa bup̱ualadḵulag. ");
INSERT INTO gaw_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","Amu ag bannu doonna, bannu ulah nai ele dooglag. Keeke amu genab beḵulag amge doyeg, ag aib oṯaip̱ig. Wan haen malak iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","Danab beḏulag laa ag danab beḏulag laa ele nug qeḵulag amu wan laa ag wan laa ele nug qeḵulag. Aben laalap̱a amu mim nebep̱eg, enug haen oḵai ele neḵulag. Kobol amu oh am nid doḵunu ah ag guiṯak tatam dooṯeb amubia aaḵuib. ");
INSERT INTO gaw_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","Amu ag ahilag oiyaknu dab meig! Ag laala amu ag aḏualadna, heṯoḏiakp̱a maadḵulag. Ag laala amu ag nai doyak laḵa ap̱a maḵuḏadḵulag. Da onil ahilagp̱a daaṯe amunu ag diiadna, king gabman ele ep̱elagp̱a maadp̱eg, ag heṯoḏiadḵulag. Amu ag haen amup̱a dahilnu nai ena amelagp̱a mehuqḵulag. ");
INSERT INTO gaw_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","Dahilnu Nai Ena amu wan ohp̱anu danab ag doon malap̱eg amu malaknu haen miag daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","Amu ag dahilnu Nai Ena mehuqḵulag amunu ag aḏualadna, heṯoḏiakp̱a maadp̱eg ag haen amup̱a aḏi aḵulag, nai amunu dab huan aib mep̱ig. Iiṯa, haen amup̱aib Kayak Ouḏi Nug nai aḏi ip̱uanaṯeb, ag nai amuib aḵulag. Ag aḵa iiṯa. Kayak Ouḏi Nug nuhig uḏat ahilagp̱a heḵu. ");
INSERT INTO gaw_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","Haen amup̱a danab laa nug awag o nug amag mauhḵunu kekeḏ ep̱elagp̱a meḵu. O danab laa nug beḵa ele anam heḵu. Nid naunau ag ele eḏun anilḵad mamelḵad mauhḵulagnu geḏadna, kekeḏ ep̱elagp̱a maadḵulag. ");
INSERT INTO gaw_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","Da onil ahilagp̱a daaṯe amunu danab oh ag oolagp̱a ahilagnu nau, ninig ele dooglag amge laa nug g̱agaṯag dayebeb uḵeb, keeke oh ba maleb, haen amup̱a ele nug g̱agaṯag daaḵu amu, nug padal ii mema. ");
INSERT INTO gaw_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","Aria propet Daniel nug keeke naunab laa, nug ab he nauhṯe ele, amunu yom. Danab aun nug nai imu eb qeṯe amu nug meu nuhig tutuḵu aoḵunu dab maḏ! Amu ag keeke naunab amu nug aben daaḵunu elele iiṯap̱a dayeb anidna, ag Juda danab ah ag ahan oolna qaukop̱a uḵeg! ");
INSERT INTO gaw_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","Genab, haen amup̱a danab laa nug ulah awak abenp̱a, lag aṯan daaṯe amu agup̱a dayaya, nug oolḵunuib dab maama, nug lag oop̱a noa, keeke ii aoma. Iiṯa. Oola uḵaḏ! ");
INSERT INTO gaw_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","O laa nug daṯa dayaya, nug oolḵunuib dab maama, nug eḏua lamen nuhig aoḵunu laḵa ii goma. ");
INSERT INTO gaw_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","Haen amup̱a ah oolag ele, ah ag nid yuḏ huh madaṯeb ele amu, ahilagnu amu gadonnab. ");
INSERT INTO gaw_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","Ag keeke amu oug haenp̱a bemanu unuqiṯeg! ");
INSERT INTO gaw_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","Aḏinu? Haen amup̱a amu ug naḏinab daaḵu. Ug amubia deḏ laa Kayak dig ma keeke oh heum uḏiak gemu ele, dimp̱a ele amubia ii daama. ");
INSERT INTO gaw_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","Anam daaṯe amunu Kayak Nug haen amu tutuib daaḵunu, haen amu ii oḵullo, danab ah oh padal melob amge Kayak Nug danab ah nuhiḵud tituanaṯom ele, Nug amu dilag dab ma, haen tutu oḵulḵu. ");
INSERT INTO gaw_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","Aria haen amup̱a danab laa nug ag amelagp̱a, ‘Anṯeg! Kristus Nug ip̱a ina daaṯe,’ o iiṯa, ‘Anṯeg! Kristus up̱a uma daaṯe,’ ab amu ag oolagp̱a genab aib doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","Aḏinu? Geha ham bup̱uak danab laa ag ham bup̱una, ‘Da am Kristus,’ o ‘Da am propet,’ aḵulag. Ag amu henana, ag ahan, danab Kayak Nug tituanaṯom ele amu ag amelagp̱a ep̱onak keeke, danab heḵunu elele iiṯa henana, ag ham bup̱ualadḵulagnu wagai meḵulag amge elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","Amunu ag dab meig! Da keeke amu ii neump̱a, keeke amu ohnu ag amelagp̱a ain malami,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","Jesus Nug anam anana amu Nug nai baula aum. “Aria ug amu oh maleb amu aam nug ii amahalma, kalam ele ii amahalma, ");
INSERT INTO gaw_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","habp̱anu hoḏop̱ai laala ag nena qebep̱eg, laa ag uḏalnana, ag ip̱ulag tutuḵu ii dim lamidmana. ");
INSERT INTO gaw_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","Keeke amu oh ba maleb, Danab Beḵalag da, da lombigp̱a g̱agaṯag oḵai amu amahlak oḵai ele uḏip̱i aniḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","Da uḏien amu da dahilad engel hep̱i, ag gona, danab ah da tituanadmi amu, aben ohp̱anu qag maadna, diin uḏiglag. ");
INSERT INTO gaw_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","Nai amunu amu ag ad pignu kobol dab menana, dab mak aoglag. Ag ad pig nug uḏug bau beḵunu dig ma haulṯe anidna amu ag haen amup̱a, ‘Aam haen nug aaḵu dig meṯe,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","Ag ad pig nug bau beḵunu dig ma haulṯe anidna ag, ‘Aam haen miag doṯe,’ dooṯeb amubia ag kobol diigdiig oh da ami ele amu bebep̱eg anidna, ag dahilnu, ‘Nug eḏua uḏiḵunu haen aaḵu miag daaṯe,’ dooglag. ");
INSERT INTO gaw_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","Da genab ag amelagp̱a aṯem. Danab ah haen imunu oh ii mauhadp̱eg, geha keeke amu oh beḵu. ");
INSERT INTO gaw_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","Hab wan ele amu iiṯa meḵulah amge dahil nai amu iiṯa iinab mema,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","Anam amge laip̱u laa nug deḏ amunu haen ii dooṯe. Engel hab aṯannu ele ii dooṯeb. Da ele ii dooṯem, Mama Nug nuḵa keeke amu dooṯe. ");
INSERT INTO gaw_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","Ag haen amu ii dooṯeb amunu ag dab menan dayeg! ");
INSERT INTO gaw_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","Haen amu inam bia beḵu. Danab laa nug atu laih goḵunu aha, nug laugp̱anu uḏat oh otia, nuhiḵud uḏat danab ep̱elagp̱a mewowa, laa nug nuhig oḵai eḏua uḏiḵunu dab maama daaḵunu anana, aha uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","Amunu ag danab, nug nuhig oḵai eḏua uḏiḵunu dab maama daaḵunu aum, amubia amu ag dab menana dayeg! Aḏinu? Ag Nug eḏua uḏiḵunu haen ii dooṯeb, tuebtai o tugmagtai o buṯua wagḏebtai. ");
INSERT INTO gaw_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","Nug pahatai eḏua uḏiḵu amunu ag niimnanu dab meig! ");
INSERT INTO gaw_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","Nai imu amu ahilagib iiṯa. Da danab ah oh dilagnu ele aṯem. “Ag dab meḏanna dayeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","Jesus Nug nai amu oh maṯia male amu dimp̱a Pasowa meṯid hobul deḏ ii nak, neḵunu deḏ aḏit dayeye, hobul amup̱a ag bret hamuib ladap̱ig ele amu, mana meṯak danab oḵai, ḏo mehuqak danab ele amu ag loḵumakp̱a Jesus aḏan, qep̱eg mauhḵunu ib madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","Amu ag keeke amu heḵulagnu inam ap̱ig. “Danab ah nug qemana, muṯub ele qemananu amu ig Pasowa hobul haenp̱a Jesus ii aḏamta,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","Aria Jesus Nug Beṯani ap̱a danab onig Simon, nug gaḏa oḏe ele amu, nug laugp̱a e lanan dayeye, ah laa nug men id enanag, goḏen muṯuḏig enanag, nob oḵainab ele inak, amu awa, gumiṯa uḏiom. Ag goḏen amu bala laa onig nad, amup̱a hedap̱ig. Aria ah amu nug amu awa uḏia, id baag amu qe aoḏe, Jesus igip̱a goḵaḏom. ");
INSERT INTO gaw_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","Nug anam he amu danab laala, ap̱a daap̱ig ele amu, ag oolag nauhe, aḵa aḵa kobol amunu maṯin ap̱ig. “Aḏinu nug goḏen amu hamu kakiṯom? ");
INSERT INTO gaw_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","Nug goḏen amu meeb, danab laa nug maḏ laip̱unu uḏat nob eḏiṯak daden meeb, men doḏo amu daḏek danab maṯalo am ena,” aon ap̱ig. Ag anam anana amu ag ah amu aidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","Ag anam aiṯeg amu Jesus Nug ag amelagp̱a aum. “Ag uueg! Aḏinu ag ah imu oo ug medaṯeb? Nug dahilnu kobol enanag heum. ");
INSERT INTO gaw_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","Daḏek danab amu, ag ag oolagp̱a hanhan daaglag amunu ag ehanadḵulagnu oolag dayeb amu ag ehanadḵulag. Amge da ag ele haen oh ii daamta. ");
INSERT INTO gaw_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","Ah imu nug dahilnu kobol ena heḵunu elele anṯa, nug heum. Nug da beḏul moḏp̱a noḵunu gaḏal babaiṯa, goḏen amu goḵaḏom. ");
INSERT INTO gaw_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","Da genab ag amelagp̱a aṯem. Dimp̱a danab ag dahilnu Nai Ena wan adep̱a adep̱a mehuqnana, ag ah imu keeke heum, nug ag daulagp̱a doḵunu, ag amunu ele maṯiglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","Aria haen amup̱a ip̱uniṯak awak danab tuelp, ag oolagp̱an laip̱u, nug onig Judas Iskariot, nug mana meṯak danab oḵai gumaṯa uḵa, Jesus ag ep̱elagp̱a meḵunu aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","Nug anam a amu ag oolag gamag ahe, nug anam heeb, ag men doḏo meṯaglagnu nai qaḵan ap̱ig. Ag anam aeg amunu Judas nug haen ena adeḵu Jesus ag ep̱elagp̱a meḵunu ib maṯiom. ");
INSERT INTO gaw_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","Aria Pasowa meṯid hobulnu babaiṯaknu deḏ ne, deḏ amu Juda danab ag Pasowa hobulnu doḏ sipsip aqaeg mauhadṯap̱ig ele, deḏ amup̱a Jesusnu ip̱uniṯak awak danab ag Jesus oḏ medap̱ig. “Ig na Pasowa e laḵutnu amu ig amunu adep̱a bap̱aidḵunignu oot daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","Ag anam aeg amu Jesus Nug ip̱uniṯak awak danab aḏit amelahp̱a aum. “A ahaya goya, abp̱a noya, ap̱a amu a danab nug nip̱ud, le am bak ele, amu mawa doa, a uḏalah teeb amu a nug dim lamidya uḵeḏ! ");
INSERT INTO gaw_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","Dim lamidya gopeḏ, nug lag aṯenp̱a teeb amu a lag amu nug mameg amegp̱a inam aiḏ! ‘Ip̱uniṯak danab ihinih Nug inam aum. “Da dahil ip̱uniṯak awak danab ele ig na lautp̱a oo aṯenp̱a Pasowa laḵunig?” ’ aoya aḵulah. ");
INSERT INTO gaw_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","A anam apeḏ, geha nug lag oo oḵai, balal dayak aben ele amu ana ip̱uanaṯeb, a lag oo amup̱a Pasowa babaiṯeḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","Jesus Nug anam a amu a ahaya goya, abp̱a noya amu Jesus Nug aum amubiaib anidpiḏ. Anidya amu a Pasowanu e bap̱aidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","Bap̱aidya malapiḏ amu tueb meeme, Jesus Nug nuhiḵud ip̱uniṯak awak danab tuelp amu ag oh ap̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","Aria ag gona tena, balalp̱a e lanana, Jesus Nug aum. “Da genab ag amelagp̱a aṯem. Ag oolagp̱anu danab laa, nug da ele geha iiḵu e laṯep amu nug da kekeḏ ep̱elagp̱a meiḏḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","Nug anam a amu ip̱uniṯak awak danab ag oolagp̱a ugnab doonna, ag anen anen Jesus oḏ medap̱ig, “Na ame am date?” ");
INSERT INTO gaw_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","Ag anam oḏ meṯaeg amu Jesus Nug nai iiḵuib nob meum. “Ag danab tuelp amu ag oolagp̱anu laa nug da ele geha iiḵu e laṯep amu nug ana heḵu. ");
INSERT INTO gaw_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","Danab Beḵalag da, Kayak nai aṯe amubianab, da mauhḵul amge danab nug da kekeḏ ep̱elagp̱a meiḏḵu amu nuhignu gadonnab, nug anig amu nug ii menulo am ena,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","Jesus Nug anam a, ag oh e lanan daanna amu Jesus Nug bret awa, Kayak unuqiṯa, pane ne, pania madaṯa, inam aum. “Ag aon laig! Imu da beḏul.” ");
INSERT INTO gaw_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","Nug anam anana amu Nug wain hai goḵoḏp̱a awa, unuqiṯa maṯe, ag oh lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","Ag laegeg amu Jesus Nug ag amelagp̱a aum. “Imu da tiil, amup̱a da tituanak bau heṯem. Da danab ah kuḏum dilag hip̱unin uhuqen madaḵulnu goḵaḏṯem. ");
INSERT INTO gaw_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","Da genab ag amelagp̱a aṯem. Da grep lep̱u wain geha iiḵu laṯem imubia baula paha ii lapa. Iiṯa. Dimp̱a da Kayaknu ḏo maḏoḏ oop̱a dayeye am da wain bau laḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","Nug anam a amu ag ahi laa eṯona, ag ahan, dimiṯim wana, Olipnu qaukop̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","Ag gona tena, Jesus Nug aum. “Kayak naip̱a yak laa niiṯe am inam. ‘Da gumak danab qep̱i mauheb, sipsip ag oh oolna matatun goḵulag!’ amunu yak amubia amu gemu tuqan imu ag oh uuiḏna oolna goḵulag. ");
INSERT INTO gaw_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","Amge dimp̱a da eḏuen hibaiṯen, da anuqen, Galelia wanp̱a gop̱i, ag da dim lamiḏna goḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","Nug anam a amu Petrus nug Jesus amegp̱a aum. “Danab laa oh ag nahipnu eheḏ doon, uuidna oolna goḵulagtai amge da am anam ii hepa!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","Petrus nug anam a amu Jesus Nug oḏep̱a awa aum. “Da genab na amenp̱a aṯem. Gemu tuqan imup̱a na dahilnu, ‘Da Nug ii dooṯem,’ aon, haen ewam batak aḵut. Na haen ewam anam ap̱e, dimp̱a matuk dawai nug gaaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","Awa a amu Petrus nug g̱agaṯag aum. “Iiṯa! Da na ele mauhḵunihnu dayeb amu da amunu ug ii dooṯem amge da nahipnu, ‘Da ii dooṯem,’ ii apa! Iiṯanab iiṯa,” awa aum. Awa a amu ip̱uniṯak awak danab laa oh ag anamib ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","Ag gona, aben laa onig Getsemani tena, Jesus Nug ip̱uniṯak awak danab amelagp̱a aum. “Ag igup̱a daap̱eg, da uḵen unuqidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","Nug anam anana amu Nug Petrus, Jakobus, Johanes ele aaḵuib diiaṯe, Nug ele gop̱ig. Gona amu Nug oop̱a ugnab doyom. ");
INSERT INTO gaw_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","Nug anam doya, Nug ag amelagp̱a aum. “Da oolp̱a kahipan toḏe mauhak bia dooṯem amunu ag igup̱a daanna, dab menan dayeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","Nug anam anana amu Nug nakok laa ele wana uḵa, ap̱a Nug dup noa, gateg qaun wa, haen nau amu ii anidḵunu inam unuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","“O Mame, ug oh da maoḵul ele, amuam lep̱u mua eheḏ hai goḵoḏp̱a daaṯe bia, amu na ib laa anidna na ap̱e, da le hai goḵoḏ amup̱anu amu da ii lapa amge na da ool daaṯe aib dim lamidme. Na oot daaṯe amuib dim lamiṯe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","Nug anam anana amu Nug eḏua, ip̱uniṯak awak danab ewam niiegeg anaṯa, Nug Petrus amegp̱a aum. “Simon, na niiṯemte? Na aam ameg laip̱uib dab menan daaḵutnu elele iiṯate? ");
INSERT INTO gaw_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","Satan ag eeḏaṯeb, eheḏp̱a gomananu ag dab menan daanna, unuqiṯeg! Ag ouḏilag am elele amge ag beḏulag am elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","Nug anam anana amu nug eḏua uḵa tatam unuqiṯom anamib baula unuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","Unuqiṯowa amu Nug eḏua uḵa, ip̱uniṯak awak danab ag amelag eheḏ neum amunu ag niiegeg anaṯe, ag Nug amegp̱a nai laa aḵulagnu ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","Aria haen ewamp̱a nug eḏua uḵa, ag niiegeg anaṯa amu Nug ag amelagp̱a aum. “Ag iite ahap̱ig? Ag geha iiḵu elete niin aotna aoṯebte? Aaḵu elele! Danab nug Danab Beḵalag da, hip̱unin danab ep̱elagp̱a meiḏḵunu haen aaḵu doum. ");
INSERT INTO gaw_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","Ahap̱eg gotu! Anṯeg, danab nug da kekeḏ ep̱elagp̱a meiḏḵu ele amu nug aaḵu uḏiṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","Jesus Nug nai amu maṯieye amu ip̱uniṯak awak danab tuelp oolagp̱an laa onig Judas, amu danab kuḏum ele, danab amu ag qep elab amu daḏib maha ele aḏap̱ig amu, ag mana meṯak danab oḵai amu ḏo mehuqak danab amu Juda iḵi danab ele ag ap̱ig bia, Judas ele uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","Tatam Judas nug ag Jesus aḏaglagnu ep̱onak keeke laa heḵunu amelagp̱a inam aum. “Da danab laa ootuqidḵul ele amu, ag Nug aḏan, aon uḵeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","Anam amunu Judas aḏi ag gona, Getsemani tena, Judas nug paha Jesus gumiṯa uḵa, “Ip̱uniṯak danab,” awowa, nug ootuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","Ootuqiṯe amu ag Jesus aḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","Aḏaegeg amu laa ap̱a dayom ele amu nug qep elab nuhig eeḏa awa, mana meṯak iḵi danab, nuhig begbeg laa daug hoiyom. ");
INSERT INTO gaw_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","Anam he amu Jesus Nug amelagp̱a aum. “Da yabhok danabte daaṯem amunu ag qep elab amu daḏib ele aon aḏailḵulagnu uḏip̱ig? ");
INSERT INTO gaw_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","Da deḏ oh mana meṯak laḵa danab ah ip̱uniṯak maadṯami amge ag ii aḏailp̱ig. Amge Kayak nai aṯe amuib baḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","Nug anam a amu nuhiḵud ip̱uniṯak awak danab ag oh uuidna, oolna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","Amu nid bau laip̱u laa nug Jesus Getsemani ugeḵe, haen amu nug ele Jesus dim lamiṯom. Nug lamen linen taḵa uḵom. Uḵa dayeye amu ag Jesus aḏana, ag nug ele aḏaeg, ");
INSERT INTO gaw_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","nug lamen uua, hamu oola uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","Ag Jesus aḏana amu ag Nug aon gona, mana meṯak iḵi danab top̱a gop̱ig. Amu mana meṯak danab oḵai, abnu iḵi danab amu ḏo mehuqak danab ele ag oh ap̱a qag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","Ag Jesus aḏan omalna teegeg amu Petrus nug dim lamaṯom amge nakok piḏe dim lamaṯom. Dim lamaṯaṯa, lagnu aḏ oop̱anab ta, lag mamegnu daup oolagp̱a ab uḏiḵa dayom. ");
INSERT INTO gaw_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","Petrus nug ap̱a dayeye amu lag oop̱a mana meṯak danab oḵai amu Juda dilag heṯoḏiak oḵai, onig Sanhidren, amunu danab ele, ag oh Jesus qep̱eg mauhḵunu danab laa nug Jesus aḏi eheḏ heum amunu aḵunu madip̱ig. Madip̱ig amge ag laa ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","Maṯiegeg amu danab laala ag ahan, ham bupuna, Jesus Nug aḏi eheḏ heum ap̱ig amge ahilag nai am iḏu laip̱u iiṯa, piḏe piḏe. ");
INSERT INTO gaw_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","Anam heegeg amu laala ag ham bup̱una, Jesus geḏidna, inam ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“Danab imu Nug inam a doomut. ‘Da mana meṯak lag imu, danab ep̱elagp̱a hep̱ig ele amu, da hep̱i nauheb, deḏ ewamp̱aib amu da bau heḵul amge da ep̱elp̱a ii hepa.’ Nug anam aum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","Ag anam ap̱ig amge ahilag nai amu ele iḏu laip̱u iiṯa, piḏe piḏe. ");
INSERT INTO gaw_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","Ag anam ham bup̱un maṯieg amu mana meṯak iḵi nug ag noolagp̱a hibaiṯa, Jesus oḏ meṯom. “Nai amunu amu na nob iite memana? Nai anak amuam genab o genab iiṯate?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","Nug anam aum amge Jesus Nug nai nakok laa ii maṯiom. Aria mana meṯak iḵi nug eḏua, bau oḏ meṯom. “Na am Kristus, Kayak beḵate?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","Nug anam oḏ meṯe amu Jesus Nug aum. “Yo, da iiḵu amu dimp̱a ag Danab Beḵalag da, Kayak g̱agaṯag oh ele amu, Nug ep̱eg naḏiapp̱a, amuam anuqak aben, amup̱a daap̱p̱i aniḏna amu hab waap̱anu lombigp̱a ele uḏip̱p̱i aniḏḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","Jesus Nug anam a amu mana meṯak danab dilag iḵi nug nuhig lamen aḏa, paṯiḏa, nug aum. “Ig danab laala danab imu eheḏ heumnu maṯiglagnu ii maṯimta. Iiḵu elele! ");
INSERT INTO gaw_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","Nug nuḵa nuhignu, ‘Da am Kayak,’ aum amunu Nug Kayak dabiṯa awa awa qeṯom. Ag nai amu doop̱ig amu ag nuhignu aḏi aṯeb?” awa aum. Nug anam a amu ag oh, “Nug eheḏ heum, Nug mauhḵu,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","Ag anam anana amu laa ag hunu qeegeg, laa ag lamenp̱a ameg qaḵana, ep̱elagp̱a maḵuḏnana ap̱ig. “Kayak ehaniṯeb, na aun na oiṯom ap̱e dootu!” aon ap̱ig. Aria mana meṯak iḵi, nuhiḵud daup, ag ele nug maḵuḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","Amu Petrus nug lagnu aḏ oop̱a dayeye, mana meṯak iḵi, nuhig begbeg nid ahin laa nug doa, ");
INSERT INTO gaw_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","Petrus nug ab uḏiḵa dayeye anṯa, nug aum. “Na ele am Nasaret ted Jesus, Nug ele oipiḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","Nug anam a amu Petrus nug aum. “Iiṯa! Da nai amuam da ii dooṯem!” awa aum. Anam anana amu nug aha, lagnu aḏ odp̱a uḵa dayom. ");
INSERT INTO gaw_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","Daye, dimp̱a begbeg ah amu nug Petrus baula anṯa amu nug laala daap̱ig ele amu, ag amelagp̱a aum. “Danab imu nug Jesus aḏi lailag!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","Nug anam a amu Petrus nug baula, “Iiṯanab,” awa aum. Nug a amu nakok dimp̱a danab ap̱a daap̱ig ele amu, ag Petrus amegp̱a ap̱ig. “Na am Galelia ted amunu genab na am Jesus layag!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","Ag anam aeg amu Petrus nug nai g̱agaṯagnab inam aum. “Da nai genab ii ap̱i amu Kayak Nug da nob nau meḏaḏ! Da genab iiḵu aṯem! Danab amu ag nuhignu aṯeb ele amu, da Nug iinab dooṯem!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","Petrus nug anam a amu matuk dawai nug paha baula gayom. Gayeye amu Jesusnu nai, “Tuqan imup̱a na dahilnu, ‘Da Nug ii dooṯem,’ ap̱e, haen ewam batak aḵut. Na haen ewam anam ap̱e, dimp̱a matuk dawai nug gaaḵu,” nai amu Petrus daugp̱a doum. Nai amu Petrus daugp̱a do, dab maama gayom. ");
INSERT INTO gaw_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","Aria wagḏe buṯua amu mana meṯak iḵi danab, Juda iḵi danab, ḏo mehuqak danab amu Juda dilag heṯoḏiak oḵai, onig Sanhidren, amunu danab ele ag oh qag mena, Jesus mauhḵunu nai qaḵona, Jesus ep̱eg muḏip̱a qaḵana, aon gona, Pilatus ep̱egp̱a mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","Jesus Nug anam dayeye amu Pilatus nug oḏ meṯom. “Na Juda dilag kingte?” awa aum. Awa a amu Jesus Nug aum. “Na aaḵu aṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","Jesus Nug anam a amu mana meṯak danab oḵai ag nuhignu nai hamu yaan henan, “Jesus eheḏ kuḏum heum,” Pilatus amegp̱a ap̱ig ");
INSERT INTO gaw_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","amunu Pilatus nug Jesus oḏ meṯom. “Ag na eheḏ kuḏum hemenu aṯeb amu na nai amunu eḏuna, nob iitai amana?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","Pilatus anam aum amge Jesus Nug oḏep̱a ii awom amunu Pilatus nug dab mak kuḏum awom. ");
INSERT INTO gaw_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","Aria maḏ ohp̱a Pasowa hobulnu deḏp̱a gabman nug danab ah ag hip̱unin danab aṯen uhuqa madaḵunu ap̱ig amu nug mani guiṯakp̱anu od matule doṯom. ");
INSERT INTO gaw_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","Amu danab laa ag gabman ele ban henana, ag danab aqaeg mauhp̱ig amunu ag mani guiṯakp̱a daap̱ig amu ag oolagp̱anu danab laa onig Barabas, nug ag ele oh haen amup̱a mani guiṯakp̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","Nug mani guiṯakp̱a dayeye, Jesus Nug Pilatus ep̱egp̱a dayeye amu Juda danab kuḏum ag ahan, Pilatus top̱a gona, ag nug hanhan mani guiṯak danab laa uhuqṯom bia heḵunu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","Ag anam aeg amu Pilatus nug aum. “Da Jesuste uhuqḵulnu oolag daaṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","Pilatus nug Jesus nuhig hak ena, hak amup̱a Nug Juda oḵai eḏaṯom amunu ag oolag nauhe, Jesus heṯoḏiakp̱a mep̱ig doyom amunu nug anam oḏ maṯom. ");
INSERT INTO gaw_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","Pilatus nug anam oḏ maṯom amge mana meṯak danab oḵai ag ahan, wagai mena, danab oh gaḏa maṯaeg, ag Barabas uhuqḵunu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","Ag Barabasnu ap̱ig amunu Pilatus nug aum. “Amge ag Juda dilag king imu, da nuhignu aḏi heḵulnu oolag daaṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","Nug anam a amu ag ep̱ig. “Ad emaitakp̱a atule!” aon ep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","Ag anam eeg amu Pilatus nug oḏ maṯom. “Aḏinu? Nug aḏi eheḏ heum?” awa aum. Nug anam aum amge danab kuḏum ag baula huan ep̱ig. “Ad emaitakp̱a atule!” aon ep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","Ag anam eeg amu Pilatus nug danab kuḏum ag oolag ena daaḵunu Barabas uhuqom. Barabas uhuqa amu nug nuhiḵud daup ag Jesus wipp̱a eheḏ mataḏḵulagnu a, ag anam heeg, Pilatus nug Jesus ad emaitakp̱a atulḵulagnu anana, nug Jesus awa, ag ep̱elagp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","Pilatus anam maṯiom amunu nuhiḵud daup ag Jesus aon gona, gabman dilag oḵai laug oop̱a nona, ag daup laa oh onilagp̱a eeg, uḏieg, ");
INSERT INTO gaw_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ag oh lamen kokoḏ enanag Jesus aḏuiṯeg no, ag king igip̱an bala bia muḏi qaun elep̱a hewona, Jesus igip̱a aḏaeg noum. ");
INSERT INTO gaw_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","Aḏaeg no amu ag aon aon qeṯan, Jesus humidna ap̱ig. “Na am Juda dilag king! Na binan ele!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","Ag anam henana amu ag gumu laa, qaiṯobṯob gumu bia, amu aona, Jesus iḵi onana, hunu qenana, Nug noobp̱a ham bup̱uak dup nona, gatelag qaun op̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","Ag aon aon qeṯan malana amu ag lamen kokoḏ enanag uḏidna, nuhig lamen eḏun aḏuiṯeg no, ag ad emaitakp̱a atulḵulagnu aon gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","Ag ibp̱a gonana amu ag Sairini ted, Rupas, Aleksanda ele mamelah, onig Simon, nug ab dimiṯimnu uḏia, ab oḵaip̱a noḵunu doodo, ag nug anidna amu ag duṯunna heeg, nug Jesusnu ad emaitak maoḵunu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","Nug ad emaitak mawewe amu ag gona, Golgata ap̱a tep̱ig. Golgata diig am Iḵilag Ebehi. ");
INSERT INTO gaw_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","Tena, ap̱a amu ag Jesus wain marasin laa onig mir koboliak, Nug amu laḵunu meṯaeg am Nug ii laum. ");
INSERT INTO gaw_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","Jesus Nug anam he, ag Nug ad emaitakp̱a atulona amu ag nuhig lamen aoglagnu amu ag otina, ameg waḏele mewona, aun nug ameg aṯen aoḵu amu ag keeke laa onig dais amup̱a qiḏ hena, aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","Ag buṯua aam ameg eblaih waḏelep̱a ad emaitakp̱a atulp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","Rom danab ag danab ad emaitakp̱a atuladṯap̱ig ele amu, ag aḏi nai ag beḏulagp̱a yaap̱ig ele, danab ag amu anidḵulagnu, ag uḏugp̱a yaana, ad emaitakp̱a atulp̱ig. Aria Jesusnu amu ag, “Nug Juda dilag king,” anam ana yan, ad emaitakp̱a atulp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","Ag danab aḏit laa, a am yabhok danab amu, ag a Jesus ele oh atuladp̱ig. Ag danab laa Jesus ep̱eg naḏiap̱a atulona, laa am ep̱eg nanehp̱a atulp̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","Ag Jesus danab aḏit ele atuladp̱ig amunu Kayak nai laa danab yom amu meu oom. Nai am inam. “Ag nuhignu, ‘Nug am hip̱unin danab lailag,’ aḵulag.” ");
INSERT INTO gaw_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","Jesus Nug ad emaitakp̱a dayeye amu danab ah ag Nug noobp̱a dona wanana, ag iḵilag matuḏna, aon aon qeṯanna, inam ap̱ig. “O! Na mana meṯak lag lop̱aḏna, eḏun deḏ ewamp̱aib heḵutnu ame ");
INSERT INTO gaw_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","amunu na anam heḵutnu elele amu na ad emaitakp̱anu beḏun uhuqna nena, ena daye!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","Ag anam aegeg amu mana meṯak danab oḵai, ḏo mehuqak danab ele ag aon aon qeṯan ap̱ig. “Nug danab laa ehanaṯom amge Nug nuḵa ehanidḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","Nug am Kristus, Juda dilag kingde! Nug ad emaitakp̱anu neeb, ig aniṯa, ig nuhignu oonigp̱a genab doognig,” aon ap̱ig. Ag anam aegeg amu danab aḏit ag a Jesus ele atuladp̱ig amu a ele Jesus amegp̱a awa awa qeṯak nai madipiḏ. ");
INSERT INTO gaw_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","Anam heegeg uḵe, aam ameg tuelpp̱a gatatu wan amu oh na tone uḵe, aam ameg ewamp̱a batom. ");
INSERT INTO gaw_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","Aria aam ameg ewamp̱a Jesus Nug bag oḵaip̱a ewa aum. “Eloi Eloi lama sabaktani,” awa aum. Nai amu eḏuak am, “O Mame O Mame! Aḏinu na da uuiḏme?” ");
INSERT INTO gaw_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","Jesus Nug anam e, danab ap̱a Nug guguiṯak daap̱ig ele ag amu doon ap̱ig. “Doyeg! Nug Elias onigp̱a eṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","Ag anam anana amu ag oolagp̱anu danab laa nug aha, qaiqaḏ uḵa, yup̱an keeke laa, nug le huanak eeḏte ele onig span amu awa, wainp̱a mewowa, nug awa, gumu laa, qaiṯobṯob gumu bia, amup̱a ita, medaḵunu haaha, nug aum. “Daap̱eg, Elias nug na ehaniṯeb, nug ad emaitakp̱anu neḵu o iiṯa amu ig anidḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","Danab nug anam a amu Jesus Nug baag oḵaip̱a ewowa, Nug mauhom. ");
INSERT INTO gaw_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","Jesus mauhom, haen amup̱a mana meṯak lag oop̱a lamen naḏi aiheg dayom ele amu, gamagp̱anab aṯannu katiḏa uḵa, honap noum. ");
INSERT INTO gaw_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","Jesus mauhe amu daup iḵilag nug Jesus aṯem mauhom anṯa, nug aum. “Genab, danab imu Nug am Kayak beḵa!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","Amu Jesus Nug ad emaitakp̱a dayeye amu ah laala ag piḏe daanna anidp̱ig. Ag oolagp̱anu laa amuam Maria, Magdala ted, laa amu Jakobus gehanu Josi ele anilah Maria, laa am Salome. ");
INSERT INTO gaw_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","Ah ewam amu ag Jesus Nug Galelia oiyeye ehaniṯegeg, Nug Jerusalem teete amu ag ele tep̱ig. Ah laala ap̱a daap̱ig amu ag ele Jesus dim lanidna, Jerusalem tep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","Aria Jesus Nug mauhe amu tueb me, deḏ amuam Juda dilag Meṯidnu keeke babaiṯaknu deḏ, deḏ amu dimugp̱a amu ahilag Meṯid ");
INSERT INTO gaw_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","amunu Arimatia ted Josep nug ii baḏa, Pilatus top̱a uḵa, Jesus gaḏa aoḵunu oḏ meṯom. Josep nug Juda dilag heṯoḏiak oḵai onig Sanhidren, amunu nug laa aaḵu. Amu laa ag amunu danab daap̱ig amu nug ag oolagp̱anu am onig ele. Laa ele nug Kayak ḏo maḏoḏ ameg meum. ");
INSERT INTO gaw_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","Josep nug Pilatus oḏ meṯe amu Pilatus nug Jesus paha mauhom amunu nug dab mak kuḏum awom. Awa amu nug daup iḵilag onigp̱a e uḏie, “Jesus Nug matu mauhomte o iiṯate?” awa oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","Anam anana amu Pilatus nug daup iḵilag oḏep̱a Jesus mauhomnu doya, nug Arimatia ted Josep nug Jesus gaḏa aoḵunu elele aum. ");
INSERT INTO gaw_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","Pilatus nug a amu Josep nug lamen linen daden ma, Jesus gaḏa ad emaitakp̱anu awowa, gaḏa lamen amup̱a ita, moḏ menp̱a bap̱aidp̱ig ele, amup̱a mewowa, nug men laa buḏibḏib meṯe uḵa, men moḏnu oḏe tonom. ");
INSERT INTO gaw_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","Nug Jesus gaḏa men moḏp̱a meeme amu Maria, Magdala ted, amu Josi anig Maria ele a aben amu anidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","Jesus Nug moḏp̱a niieye amu Juda dilag Meṯid male, Maria, Magdala ted amu Jakobus anig Maria amu Salome ele ag keeke muṯuḏig enanag ele Jesus gaḏa bap̱aidḵulagnu daden mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","Aria Juda dilag Meṯid male uḵe, wagḏe buṯuanab aam dig ma beebe amu ag ahan, men moḏp̱a, Jesus gaḏa bap̱aidḵulagnu gonana, ");
INSERT INTO gaw_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ag aḵa aḵa ap̱ig. “Aun nug ehaniḵa, men naḏi moḏ oḏep̱an amu, men amu duṯuna megaḵu?” Men amuam naḏinab amunu ag anam ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","Ag anam maṯinna, ag neeḵeg uḵe, men naḏi moḏ oḏep̱anu amu laa nug duṯune uḵom. ");
INSERT INTO gaw_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","Amunu ag gona, men moḏ oop̱a nona, nid bau laa nug lamen haḵab ele nug naḏiapp̱a dayeye anidna, ag baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","Ag anam baḏan heegeg amu nid bau amu nug aum. “Ag aib baḏap̱ig. Ag Nasaret ted Jesus, ad emaitakp̱a atulp̱ig ele madiṯeb amge Nug ip̱a ii daaṯe. Nug eḏua hibaiṯom. Ag Nug mep̱ig aben amu iiḵude anṯeg! ");
INSERT INTO gaw_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","Amunu ag gona, Petrus amu Jesusnu ip̱uniṯak awak danab laa oh ele inam ap̱eg dooglag. ‘Jesus Nug anuqa, Galelia goṯe amunu ag ele gona, Nug anuḵa aum bia ap̱a Nug anidḵulag,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","Nug anam a amu ah ag eḏun, dimiṯim gona, moḏ uuna, ag beḏulag hahaḏeḏe, dab mak kuḏum aop̱ig. Ag huan baḏap̱ig amunu ag danab laa amegp̱a ii ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","Jesus Nug Meṯidp̱a, wagḏe buṯuanab eḏua hibaiṯowa amu Nug tatam Maria, Magdala ted, nug gumiṯa waum. Ah amuam Jesus Nug anuḵa ouḏi nau eblaih aḏit ele beḏup̱anu lamaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","Ah nug Jesus anṯa amu nug uḵa, nuhiḵud ip̱uniṯak awak danab, ag oolag ug ele gaana daaegeg, ag amelagp̱a inam aum. “Jesus Nug eḏua hibaiṯa, bau daaṯe! Da Nug anidmi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","Nug anam a, ag Jesus eḏua hibaiṯom, ah amu Nug ele anṯom doop̱ig amge ag oolagp̱a genab ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","Aria dimp̱a danab aḏit laa a laih goḵulahnu ibp̱a uḵaeheh, Jesus Nug beḏu eḏua gumata waum. ");
INSERT INTO gaw_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","Wana amu Jesus Nug he, a Nug dooiya, a eḏuya goya, nai amu aeh amu laa ag oolagp̱a genab ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","Danab laala ag, “Jesus eḏua aha, bau daaṯe,” aeg, ip̱uniṯak awak danab elewen ag doop̱ig amge ag oolagp̱a genab ii doop̱ig. Ag nai amunu ahilag dab makib dim lamidna, “Elele iiṯa,” ap̱ig amunu dimp̱a Jesus Nug ag e lanana daaegeg, Nug tula gumaṯa wana, Nug ahilag hak aḏit amunu alaṯom. ");
INSERT INTO gaw_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","Alaṯowa amu Nug ag amelagp̱a aum. “Ag ahan, wan atu ohp̱a gona, dahilnu Nai Ena danab oh amelagp̱a aig! ");
INSERT INTO gaw_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","Ag ap̱eg doona amu danab laa nug oop̱a genab doya, layaṯak aweb amu Kayak nug eḏua aoḵu. Laa nug oop̱a genab ii doya amu nug Kayak noobp̱a nai ele daaḵu. ");
INSERT INTO gaw_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","Danab ag dahilnu oolagp̱a genab dooṯeb ele amu, ag da onilp̱a kobol laala danab heḵunu elele iiṯa imubia heḵulag. Ag ouḏi nau lamadḵulag, ag nailag piḏe piḏe maṯiglag. ");
INSERT INTO gaw_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","Ag mat nau aḏaglag o le eheḏ laa laḵulag amu amup̱a ag ii mauhmana. Ag oḏe danab beḏulag aḏap̱eg, ag oḏe uuadḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","Jesus Nug anam a amu Kayak Nug he, Jesus Nug hab aṯan ta, Kayak ep̱eg naḏiapp̱a, amuam anuqak aben, amup̱a heḏep na daaṯe. ");
INSERT INTO gaw_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","Aria ip̱uniṯak awak danab ag wan ohp̱a gona, Jesusnu nai mehuqegeg, Jesus Nug ag ehanaṯeṯe, ag uḏat naḏi g̱agaṯag laala ele heegeg, amup̱a danab ag mehuqak ahilag genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","O danab naḏi Tiopilas, danab kuḏum ag tatam keeke ig oonigp̱a bep̱ig, amunu nai yaap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","Dig makp̱anu uḵe batakp̱a danab ag keeke amu anidp̱ig ele ag aeg doout yaap̱ig. Ag am Nai Ena mehuqak danab daanna, nai amu aeg doomut. ");
INSERT INTO gaw_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","4","O danab Naḏi Tiopilas, na ele keeke amunu aeg doome. Aeg doome amunu da ele na nai doome am genab dooḵutnu nahipnu nai amu baula yaaḵulnu ool dayom amunu da keeke amu dig makp̱anu uḵe batakp̱a ele ohnu oḏ mak tutuḵu elelenab hei, aeg doyen, iiḵu elelep̱a yaaṯem. ");
INSERT INTO gaw_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","Aria haen Herodes oḵai nug Juda dilag king dayeye, mana meṯak danab laa dayom. Nug am ameg laa onig Abaisa ameg, amu oop̱anu, nug onig Sakarias. Nug wau am onig Elisabet. A oh am Aron buḏub. ");
INSERT INTO gaw_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","A oh Kayak noobp̱a tutuḵu oiṯapiḏ. Ḏo nai oh ena dim lamidya, Kayak amegp̱a ele daadṯapiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","Amge a nid iiṯa. Elisabet nug ah maṯoi amunu a hamu oiya, kaino mepiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","Aria haen laa Sakarias laiḵud ele ag uḏat ahilag heḵulagnu haen be, ag henan daanna amu Sakarias nug ele Kayak noobp̱a mana meṯak uḏat nuhig heum. ");
INSERT INTO gaw_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","Nug heehe amu ag nug uḵa, kalu, kahug nuhig muṯuḏig ena ele, amu amotḵunu meeg, nug mana meṯak lag oo gun ele amup̱a noum. ");
INSERT INTO gaw_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","Kalu amotom, haen amup̱a danab ah kuḏum ag dimiṯim qag mena, unuqidnana daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","Daaegeg, Sakarias nug uḏat nuhig heehe, Kayaknu engel nug kalu, kahug muṯuḏig ena ele, amu amotaknu qaḏab heqo laih naḏiap̱anu hibaiṯa dayeye, Sakarias nug anṯom. ");
INSERT INTO gaw_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","Sakarias engel anṯa, nug huan oṯaia, oo ele baḏom. ");
INSERT INTO gaw_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","Oo baḏom amge engel nug Sakarias amegp̱a aum. “Na aib baḏame. Unuqiṯak nahip amu Kayak Nug aaḵu doyom. Na waat Elisabet nug geha nid danab menueb amu na nid onig Johanes ataḏe! ");
INSERT INTO gaw_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","Geha na oot ena dayeb, gaman ele ahebeb amu danab ah kuḏum ele nug doumnu gamalag ahaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","Nug Kayak noobp̱a onig ele daaḵu. Nug wain amu kaaka qaknu le laa oh ele ii lama. Nug anig oop̱a dayebeb amu Kayak Ouḏi am nug oop̱a am beḵu. ");
INSERT INTO gaw_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","Dimp̱a nug heeb, Israel danab kuḏum ag Kayaknu kobol dim lamidḵulagnu dab mebep̱eg, ag oolag eḏuḵu. ");
INSERT INTO gaw_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","Nug Kayaknu propet Eliasnu hak g̱agaṯag amubia awa, Naḏi nob awa, anuqa uḵa heeb, danab ag ahilkad nid naunau ele oo mak daaglag. Nug heeb amu nai tap̱e nak danab ag oolag eḏueb, dab mak ena tutuḵu op̱ia awak ele aon daaglag. Nug heeb, danab ah kuḏum Jesus uḏiḵunu babaiṯak daaglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","Nug anam a, Sakarias nug engel amegp̱a aum. “Da aṯem heina, nai amuam genab daaṯe dooḵul? Da kaino memi amu ah dahil ele kaino meum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","A amu engel nug oḏep̱a awa aum. “Da am Gabriel. Da Kayak noobp̱a daaṯem ele. Kayak nuḵa he, da amenp̱a nai ena imu ap̱i dooḵutnu uḏimi. ");
INSERT INTO gaw_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","Amge na da nai ami amu ootp̱a genab ii doome amunu na oḏen qamuteb, nai ii maṯimna. Iiṯa, na anam daap̱e uḵeb, haen keeke amu oh genab beeb, na eḏun nai madiḵut. Da nai ami amu haen dob, genab meu beḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","Aria engel nug nai amu maṯieye, Sakarias nug lag oop̱a dayeye, danab ah ag nug ameg mena daanna, dab mak kuḏum aona, aḵa aḵa ap̱ig. “Lag oo gunp̱a keeke aṯem be, nug haen elab daaṯe?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","Dimp̱a nug dimiṯim doa, nug oḏep̱a ag amelagp̱a nai aḵunu elele iiṯa amunu ag doop̱ig, Kayak Nug mana meṯak lag oop̱a keeke laa ip̱uniṯom. Ag amu doop̱ig amu nug oḏe qamute, nai ii maṯiaya, ep̱egp̱aib he doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","Aria anam daye dimp̱a Sakarias nug nuhig uḏat haen, mana meṯak laḵanu, amu male, nug eḏua ap̱agp̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","Uḵa dayeye, dimp̱a nug wau Elisabet oo ele daya, nug kalam tanig ele laḵa loḵuma dayaya nug aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","“Naḏi Nug dahilnu oo doye, ehaniḏa, uḏa nak dahil danab oh amelagp̱a op̱iom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","Amu Elisabet nug oo ele dayeye, kalam eblaih laip̱u ele oop̱a Kayak Nug engel Gabriel me, Nug Galelia wanp̱a, ab laa onig Nasaret, ap̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","Nug nai awa, ah maḵun laa danab aoḵunu tituanp̱ig ele gumiṯa uḵom. Danab amu onig Josep, nug Dawit buḏub. Ah maḵun amu onig Maria. ");
INSERT INTO gaw_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","Gabriel gumiṯa noa, humiṯa aum. “O ah maḵun, na maḏoḏ ele daye! Kayak Nug na itiṯom. Nahip itiṯak am ah laa oh dilag itiṯak eḏidṯe. Nug na ele daaṯep,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","Maria nug nai amu doya, nug oṯaia, dab mak kuḏum awa, nug nuḵa nuhig dab makp̱a aum. “Nai amu aṯemunab?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","Anam a amu engel nug amegp̱a aum. “Maria, na aib baḏame. Kayak nahipnu oo ena daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","Doye, geha na oot ele daanna, nid danab menuna, na Nug onig Jesus ataḏḵut. ");
INSERT INTO gaw_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","Nug am dimp̱a danab Naḏi daaḵu. Ag nuhignu, ‘Kayak aṯannunab beḵa,’ aon aḵulag. Kayak Nug heeb, nug king alag Dawit dayom bia daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","Nug haen oh Jakop buḏubnu king daaḵu. Nuhig ḏo maḏoḏ amu ii tuqa aoma,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","Anam a amu Maria engel amegp̱a aum. “Keeke amuam aṯemutai beḵu? Da danab ii aomi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","Anam a amu engel nug oḏep̱a awa aum. “Geha Kayak Ouḏi nahipp̱a uḏieb, Kayak aṯannunab, nuhig g̱agaṯag na tonidḵu amunu na nid amu, Nug am hak tutuḵuib, Nug ham bup̱uak nakok laa iiṯa, am Nug op̱ia awak ele, amu na Nug menup̱e, ag nuhignu, ‘Kayak Beḵa,’ aona aḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","Doye, na gayap Elisabet nug kaino meum amge nug oo ele. Nug nid danab menuḵu. Anuḵa nug nid menuaknu elele iiṯa amge gemu nug oo ele dayeye, nuhig kalam eblaih laip̱u ele daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","Anṯe! Kayak Nug keeke oh heḵunu elele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","Anam a amu Maria nug aum. “Da amu Naḏinu uḏat ah. Na ame bia amu Nug dahilp̱a anam heḵu,” awa aum. Awa a amu engel nug eḏua uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","Engel uḵe haen amup̱a Maria nug aha, paha aben qauko elep̱a, Juda dilag ab laap̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","Uḵa, Sakarias laugp̱a ta, nug Elisabet humiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","Anam he amu Elisabet nug Marianu nai amu doyeye, nid oop̱a niiom amu nug oṯaia, oola te, Kayak Ouḏi Nug Elisabet oop̱a am beum. ");
INSERT INTO gaw_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","Nug oop̱a am be, Elisabet nug Maria amegp̱a ewa aum. “Na am itiṯak ele. Nahip itiṯak amu ah laa oh dilag itiṯak eḏidṯe amu na ootp̱anu nid, Nug ele itiṯak ele. ");
INSERT INTO gaw_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","Naḏi dahil amu, Nug anig da gumiḏa uḏiom amu da amunu ool ena, iṯag qeṯe. ");
INSERT INTO gaw_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","Doye, da daulp̱a nahip humiṯak dooiyi, da oolp̱a nid nug ele gamag ahe, nug oṯaia, oola teum. ");
INSERT INTO gaw_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","Kayak a, na ootp̱a genab doome amunu na Kayaknu itiṯak aome daaṯem. Nug aum amu genab anam beḵu.” Elisabet nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","Elisabet nug anam a amu Maria nug aum. “Da ool nug Naḏi binag humaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","Ehaniṯak dahil am Kayak. Da nuhignu gamal ahaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","49","Aḏinu? Da am nuhig uḏat ah, keeke hamu amge Nug dahilnu oo doyom! Kayak Ebehi Oh Ele Nug keeke naḏinab dahilp̱a heum amunu gemu, buṯi aḏi, dimp̱a ele danab ah buḏub ohp̱a ag aḵulag. ‘Kayak Nug itiṯak oḵai nug meṯom,’ aon aḵulag. Nug onig am inam, Hak Tutuḵuib, Ham bup̱uak Laa Iiṯa, Op̱ia Awak Ele. ");
INSERT INTO gaw_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","Nug danab laala ag nuhignu enanag doon, oolag ele oṯaiṯe amu, Nug amu dilagnu oo gai iiṯa dooṯe. Aun aḏi ag Nug waap̱a daanna oiṯeb ele amu, Nug ahilagnu hanhan anamib dooṯe. ");
INSERT INTO gaw_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","Nug nuhig g̱agaṯagp̱a uḏat haaha, danab ag aḵa binalag humaṯeb ele amu, Nug ag amu ahilag dab mak ele aḵe gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","Nug king ebehilag ele tabaṯe noeg, danab onilag iiṯa amu humaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","Nug danab enug aqak doop̱ig ele amu Nug he, oolag am beum. Danab ag enulag ele amu Nug aḏaṯe, ag keeke laa ii aḏap̱ig, hamu gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","55","Nug uḏat danab nuhiḵud Israel ehanaṯom. Nug ig alanḵad Abraham aḏi amu ag buḏulḵad ele, Nug amu dilagnu hanhan oo gai iiṯa dooḵunu ig alanḵad amelagp̱a aum, amubia Nug nai amu daug ii atiṯe. Iiṯa, Nug anam heṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","Anam a amu Maria nug Elisabet ele kalam ewam anam dayoya, dimp̱a nug eḏua ap̱agp̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","Maria nug eḏua ap̱agp̱a uḵe, Elisabet nug nuhig nid awak haen be, nug nid danab menuom. ");
INSERT INTO gaw_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","Menue amunu Elisabet mudip̱anu amu nuhiḵudp̱a ele ag Naḏi nuhignu oo gai iiṯa doya ehaniṯom amu doona, ag nug ele gamalag ahom. ");
INSERT INTO gaw_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","Amu deḏ eblaih ewamp̱a ag nid gaḏa otaḏḵulagnu gona, ag nid amu nug mameg onig Sakarias oela qeṯaglagnu ap̱ig ");
INSERT INTO gaw_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","amge nid anig nug aum. “Iiṯa! Ig nug onig Johanes ataḏḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","A amu ag nug amegp̱a ap̱ig. “Na buḏunadp̱a ag onilag anam laa ele iiṯa,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","Anana, ag ep̱elagp̱a nid amu nug onig aun aḵulagnu nug mameg oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","Ep̱elagp̱a anam heeg amu Sakarias nug ep̱egp̱a yaknu uḏug nug meṯaglagnu heum. He meṯaeg amu nug, “Nid onig amu Johanes,” yom. Anam ye amu ag dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","Nug nid onig ye anidna, ag dab mak kuḏum aoegeg amu haen amup̱anab Sakarias nug oḏe op̱ate, lemaḏu ug iiṯa me, nug nai maṯiaya, Kayak binag meum. ");
INSERT INTO gaw_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","Anam he, nug mudip̱anu laiḵud ag oh baḏap̱ig. Aria ag ahan, nai amu tuḏiṯeg, Juda ab aben qauko elep̱a daaṯeb amu ohp̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","Danab oh ag nai amu doona oolagp̱a dab mak kuḏum aona ap̱ig. “Dimp̱a nid amu ena ma amu nug aḏi heḵu,” aon ap̱ig. Aḏinu? Naḏinu g̱agaṯag nug ele dayom amu ag anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","Amu Kayak Ouḏi Nug Johanes mameg Sakarias nug oop̱a am be, Sakarias nug Kayak oḏe mehuqa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","69","“Ig Naḏi, Israel dilag Kayak, Nug binag metu. Aḏinu? Nug Israel danab nuhiḵud ehanaṯa uhuqaṯom. Nug ig eheḏ daamtanu eḏua awiḵak danab g̱agaṯag, nuhig uḏat danab Dawit, nug buḏubp̱a me uḏiom. ");
INSERT INTO gaw_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","Nug anuḵa nuhiḵud propet ag oḏelagp̱a anam heḵunu mehuqa maṯiaya aum amu Nug amu aaḵu heum. ");
INSERT INTO gaw_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","Nug ig kekeḏ ihinḵad ep̱elagp̱anu amu danab laa ag ihinignu oolagp̱a nau, ninig ele dooṯeb amu, ag ep̱elagp̱anu ele eḏua awiḵunu aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","Nug ig alanḵad dilagnu oo gai iiṯa dooḵunu, Nug ag tituanaṯa, keeke laa heeb beḵunu nai qaḵa aum ele amu, Nug nai aḏit amu daug ii atimanu aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","75","Nug ig nuhiḵud begbeg, baḏak iiṯa ele daagnignu, ig Nug noobp̱a danab tutuḵu, op̱ia awak, ham bup̱uak iiṯa, ihinig deḏ oh daagnignu nai genab g̱agaṯag ig alanig Abraham amegp̱a nai qaḵa aum amu Nug keeke amu oh aaḵu ha malom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","77","Sakarias nug anam anana, nug nai baula tuḏiṯa aum. “O nid dahil, na Naḏinu ib bap̱aidḵutnu, na Kayak, Nug danab nuhiḵud, hip̱unin uhuqak ibp̱a eḏua diiḵunu ip̱uanadḵutnu amu na Naḏi noob aon, anuqna goḵut amunu ag nahipnu, ‘Nug am Kayak aṯannabnu propet,’ aon aḵulag ");
INSERT INTO gaw_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","Kayak ihinig Nug oo gai iiṯa doyak naḏi ele amunu Nug ig ehanigḵu. Geha Nug heeb, hab aṯannu amahlak uḏia, ig amahaligḵu. ");
INSERT INTO gaw_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","Danab ag gatatup̱a mauhḵulagnu miag daaṯeb amu amahlak madaḵu. Nug ig ib oo mak maḏoḏ ele amu tap̱at goḵunignu ulum daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","Aria dimp̱a nid nug ena meeme, Kayaknu Ouḏi Nug ehaniṯom. Ehaniṯeṯe, nug atu taḏakp̱a dayaya, dimp̱a Israel amelagp̱a Kayak nai dig ma mehuqom. ");
INSERT INTO gaw_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","2","Amu Elisabet nug Layaṯak Johanes menue, haen amu nakok dimp̱a Sarinus nug Siria dilag danab oḵai dayeye amu Kaisa Agastas nug Rom danab ah oh onilag yaaglagnu ḏo meum. Ag onilag awak uḏat amu haen amup̱a dig mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","Kaisa nug ḏo me, onilag yaaglagnu ap̱alag diigp̱a uḵaegeg, ");
INSERT INTO gaw_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","5","Josep nug Dawit buḏub amunu nug Maria ele, a layam daapiḏ amu, a ab oḵai Nasaret, Galelianu ahaya, Juda wanp̱a, ab onig Betlehem, ap̱a onilah meḵulahnu gopiḏ. Maria nug oo ele dayom ");
INSERT INTO gaw_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","amu a ap̱a daaeheh, Marianu nid awak haen do, ");
INSERT INTO gaw_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","nug nid danab tatamnu menuom. Menua, niiak lag am beum amunu nug beḵa lamen elabp̱a ehaḵa, doḏ dilag e lanak taḏaḏ oop̱a me niiom. ");
INSERT INTO gaw_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","Amu tuqan amup̱a Betlehem ab guguiṯak doḏ sipsip gumaṯak danab ag sipsip gumadna daaegeg, ");
INSERT INTO gaw_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","Kayaknu engel gumaṯa ne, Naḏinu amahlak ag taliliaṯa honaḏom. Honaḏe amu ag huanak baḏan heeg, ");
INSERT INTO gaw_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","engel nug amelagp̱a aum. “Ag aib baḏap̱ig. Da oo gamag ahaknu nai ena danab oh dilagnu awe nemi. ");
INSERT INTO gaw_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","Gemu deḏ imup̱a Betlehem abp̱a ah laa nid awom. Nid amu Nug ag eḏua diiadḵu, Nug amu Naḏi, Kristus. ");
INSERT INTO gaw_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","Ag Nug anidḵulagnu ep̱onak keeke amu inam. Nug anig Nug lamen elabp̱a ehaḵa, doḏ dilag e lanak taḏaḏ oop̱a me niiṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","Engel nug amelagp̱a ana male, pahanab Kayaknu engel kuḏum neeg, moitan daanna, ahi eṯana ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","“Kayak Nug aṯannab daaṯe. Ig Nug binag aṯan humaṯem. Wanp̱anu danab, ag nuhignu daaṯeb amu, ag maḏoḏ maṯom,” aon ap̱ig, ");
INSERT INTO gaw_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","Engel ag anam awona, ag eḏun, hab aṯan teeg amu sipsip gumak danab ag ahan, aḵa aḵa nai inam madip̱ig. “Ig Betlehem gota, kobol Naḏi Nug amenigp̱a aum amu anidtu!” ");
INSERT INTO gaw_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","Anam anana amu ag paha gona, Maria Josep amu nid yuḏ ele, nug doḏ dilag taḏaḏp̱a niieye, anaṯona, ");
INSERT INTO gaw_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ag eḏun gonana, danab laala amelagp̱a nid amunu nai doop̱ig amu ag mehuqp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","Mehuqeg doona amu ag oolag oṯaie, ootot ele aqom. ");
INSERT INTO gaw_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","Amge Maria nug nai amu oop̱a me dayeye, dab meṯom. ");
INSERT INTO gaw_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","Anam dayeye amu gumak danab ag oolag gamag ahehe, eḏun gona, ag kobol oh ag amelagp̱a anidna, nai daulagp̱a doop̱ig ele amu, ag amunu Kayak onig binag ele humap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","Dimp̱a, deḏ eblaih ewamp̱a, ag nid nakok gaḏa otaḏna, ag Nug onig Jesus ataḏp̱ig. Nug anig oop̱a ii dayeye, engel nug onig amu aḵulagnu aum. ");
INSERT INTO gaw_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","Aria ah beḏu babaiṯak daaḵunu, Moses ḏop̱a yom amu, haen amu iiṯa me, Josep wau ele a nid Kayak ep̱egp̱a meḵulahnu Jerusalem tepiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","Kayaknu ḏop̱a ag anam heḵulagnu yak daaṯe. Yak am inam. “Nid danab tatamnu, ag anilḵad menuadp̱eg amu ag diin, Naḏi ep̱egp̱a maadḵulag.” ");
INSERT INTO gaw_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","A anam heḵulahnu teya amu a Maria beḏu babaiṯak daaḵunu mana meṯak amu ele heḵulahnu tepiḏ. Ḏop̱a, amu haknu yak inam daaṯe. “Ag up̱uḏil oḵai aḏit Kayak main meṯaglag o iiṯa up̱uḏil nakok aḏit main meṯeg!” ");
INSERT INTO gaw_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","Haen amup̱a danab laa Jerusalem dayom, nug onig Simon. Nug Kayak noobp̱a tutuḵu oiyaya, Kayak binag ena maama, Israel dilag ehanaṯak danab ameg meum. Kayak Ouḏi Nug ele daapiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","Nug Kayak Ouḏi ele daapiḏ amu Kayak Ouḏi Nug danab amu nug paha ii mauhma, tatam nug Naḏi Kristus aniṯowa amu dimp̱a nug mauhḵunu ip̱uniṯom. ");
INSERT INTO gaw_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","Aria Josep wau ele gopiḏ, deḏ amup̱a Kayak Ouḏi Nug he, Simon nug aha uḵa, mana meṯak lag oop̱a no, anig mameg ele a nid nakok omalya, ḏo aṯe bia heḵulahnu tepiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","Teeh, Simon anata, nug nid awa, ep̱egp̱a aḏa, Kayak binag ma aum. ");
INSERT INTO gaw_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","31","“O Naḏi, na anuḵa da amelp̱a da nid imu, ihinig ehaniṯak, na danab ah oh anidna dooglagnu me neum ele amu, da anidḵulnu ame amu da gemu iiḵu amelp̱a anidmi amunu da mauhḵul am nai iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","Nug iiṯa aḏi ag nahip ib anidḵulagnu, Nug Israel ag binalag aoglagnu, amahlak daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","Nug anam a amu Josep Maria ele a Simon Jesusnu anam maṯie doya, a nai amunu dab mak kuḏum aoeheh, ");
INSERT INTO gaw_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","Simon nug itiṯak matowa, nid anig Maria amegp̱a aum. “Doye, nid imu heeb, Israel danab ah kuḏum ag nena qeḵulag amge heeb, kuḏum ag eḏun ahaglag. Nug amu Kayak anidḵunignu ep̱onak keeke daaḵu amge danab kuḏum nuhignu nai nau aḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","Amunu danab kuḏum dilag dab mak aaḵu miag atiak daaḵu. Amu oo doyak oḵai, qep aegp̱a yak bia, na yaaidḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","Aria propet ah laa dayom onig Ana. Nug Asa buḏub, Panuel aḏeg. Anuḵa nug danab awe amu gamu ele maḏ sewenib daapiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","Anam daaiya, nug gamu mauhe, qab ma, hamu maḏ 84 dayaya, nug mana meṯak lag ii uuṯom. Nug Kayak binag meḵunu e laḵunu haen kuḏum kud ma dayaya, unuqiṯaṯa, tuqan amun ele binag maama dayom. ");
INSERT INTO gaw_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","Haen amup̱aib nug ele uḏia, Kayak amegp̱a, “Ena heme,” aum. Anana nug nid amunu nai mehuqa, danab oh Jerusalem daanna, Kayaknu ḏo maḏoḏ ameg mep̱ig ele amu Jesusnu amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","Amu a keeke oh Naḏinu ḏo aṯe bia heya malaeh, ag Galelia, ahilag ab oḵaip̱a, Nasaret gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","Gona daanna, nid ena ma, doyak ena awa, g̱agatag ele awe, Kayak Nug nuhignu ena doya, Nug ehaniṯom. ");
INSERT INTO gaw_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","Amu Jesus anig mameg ele a haen oh maḏ ohp̱a meṯid oḵai Pasowa, amuam bret yis iiṯa lanaknu hobul, amup̱a daaglahnu Jerusalem tedapiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","Haen Jesus Nug maḏ nuhig tuelp aria ag meṯid oḵai amunu kobol dim lamidna, Jerusalem tep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","Dimp̱a Pasowa deḏ amu male, ag eḏun uḵaegeg, Jesus Nug Jerusalem dayom amge Nug mameg anig ele a Nug dayom amu a ii doopiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","A ahilah dab makp̱a, “Nug danab oolagp̱a oiṯe,” ayaya, deḏ laip̱u oiyeh, tueb me, a baeltip̱a mudip̱an lailti oolagp̱a ele nug madipiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","A madip̱iḏ amge a ii anidpiḏ amunu a eḏuya, maṯiya, Jerusalem gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","Goya, a Nug maṯieheh, deḏ aḏit uḵe, dimp̱a deḏ ewamp̱a a Nug mana meṯak lag oop̱a dayeye anidpiḏ. Nug Juda dilag ip̱uniṯak danab oolagp̱a dayeye, ag nai maṯiegeg doya, Nug eḏua oḏ madeṯe daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","Amu danab oh ag nuhig nai doop̱ig ele amu, ag nuhig doyaknu amu oḏ maknu nob meum amunu ele dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","Daaegeg, mameg anig ele a Nug anidya, huanak oṯaiya, anig Nug amegp̱a aum. “O nid dahil, na aḏinu anam he, i inam oiṯep? Na mamen nug da ele i oonih ugnab dayeye, na maṯidmuḏ,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","Anam a amu Nug eḏua amelahp̱a inam aum. “A aḏinu ahaya, da matiḏṯep? Da Mamelnu uḏat heḵulnunab daaṯem amu a iite dooṯep?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","Ge nai Nug amelahp̱a aum amu a diig ii doopiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","Aria Jesus Nug a ele eḏun, Nasaret gona amu Nug a oḏelah dim lamiṯeṯe, anig nug keeke amu ohnu oop̱a me dayeye, dab maama dayom. ");
INSERT INTO gaw_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","Amu Jesus Nug ena meeme, nuhig doyak ele oḵai meeme, Kayak noobp̱a, danab noolagp̱a ele Nug ena oiya, tuḏiṯa he, enaib doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","Amu Kaisa Taibirias nug Rom danab gumadḵunu dig me uḵe uḵe, maḏ 14 uue, nuhig gumak maḏ 15 oop̱a, Romnu wan oḵai laa onig Palastin oop̱a, Pontius Pilatus nug wan obatak laa onig Juda gume, Herodes tetrak nug wan obatak laa onig Galelia gume, amag Pilip nug wan obatak aḏit laa onilah Ituri amu Trokonaitis ele gumate, Laisenias nug wan obatak laa onig Abilini gumom. ");
INSERT INTO gaw_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","Amu Anas Kaiapas ele a mana meṯak dilag iḵi daaeheh, haen amup̱a Sakarias beḵa Johanes, nug atu taḏakp̱a dayeye, Kayak Nug uḏat heḵunu nug amegp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","A amu Johanes nug aha, Jodan atu ohp̱a uḵa, nug danab amelagp̱a Kayak Nug ahilag hip̱unin uhuqa madaḵunu, ag oolag eḏueb, layaṯak aoglagnu aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","Johanes nug Jesaia Kayak oḏe awa, bukp̱a yom bia heum. Nai amuam inam. “Danab laa atu taḏakp̱a dayaya, danab amelagp̱a nai inam mehuqa ewa aḵu. ‘Ag hip̱unin ahilag di meṯana, ag oolagp̱a ihinig Naḏinu ib babaiṯeg! ");
INSERT INTO gaw_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","Aben qe ta qe nak amu ag hepeg, uḏem meeb, qauko oḵai nakok ele amu, ag amu oh buupeg elele dayeb, ib kaliak oh tutuḵu medap̱eg, ib men ele amu oh bap̱aidp̱eg, ena dayaḏ! ");
INSERT INTO gaw_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","Danab oh geha Kayak Nug ig eḏua awigḵunu uḏat heeb anidḵulag,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","Aria Johanes nug nai mehuqeqe, danab ameg ohnu layaṯak aoglagnu Johanes gumidna gop̱ig. Uḵaeg nug ag amelagp̱a aum. “Ag am danab nau, mat nau bia. Aun aum amunu ag hip̱uninnu bu aqak, Kayak ep̱egp̱anu uḏiṯe amu, ag amu ii aomnanu hamu uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","Ag oolag ii eḏueb, ag aoglag amge ag oolag eḏueb, kobol ena dim lamidna, ag ahilag eheḏ haknu nob amu ii aomna. Amu ele ag oolagp̱a inam aib ap̱ig. ‘Abraham nug ig mamenig, nug am danab tutuḵu, ig nug buḏub daaṯem amunu nuhig hak enap̱a ig nob ii aomta.’ Da ag amelagp̱a aṯem, Kayak Nug men imu ag eḏun, Abraham beḵod daaglagnu heḵunu elele. ");
INSERT INTO gaw_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","Epeḏiak haen am miag. Ad meu ii oṯe amu nug mameg o qiie, ab aḏup̱a maoe te eoṯe, amubia danab nug ena ii heṯe ele amu nuhigp̱a anamib beḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","Johanes nug ag amelagp̱a anam a amu danab ag nug oḏ medap̱ig. “Ig amu aṯem heḵunig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","Aon aeg amu nug eḏua ag amelagp̱a aum. “Danab aun laa nug lamen aḏit ele daaṯe, nug lamen laa amu awa, danab lamen iiṯa ele medaḵu. Danab nug e ele amu nug ele anam heḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","Aria gabman dilag takis awak danab laala ele ag layaṯak aoglagnu gumidna uḏin, ag oḏ medap̱ig. “Ip̱uniṯak danab, ig aṯem heḵunig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","Aon aeg amu Nug amelagp̱a aum. “Ag men doḏo, Rom danab oḵai aum bia, elelep̱a aweg! Aib tip̱alna laa ele aop̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","Anam a amu ban danab laala ele ag oḏ medap̱ig. “Ig amu aṯem heḵunig?” aon ap̱ig. Aeg amu nug amelagp̱a aum. “Ag danab ham bup̱ualadnana, ahilag men doḏo yab aib aop̱ig. Ag ham bup̱una, danab eheḏ heum aib ap̱ig amu ag ahilag uḏatnu nob tutuḵu aona, baubau awaknu aib dab mep̱ig. Ag aoṯeb ele amu, ag amunu elele doonna dayeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","Johanes nug anam heehe, danab ah ag oṯaina, oolag ii maiṯe, oolagp̱a dab mak kuḏum daye ap̱ig. “Johanes nug Kristustai,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","Anam aeg amu Johanes nug amelagp̱a aum. “Da ag lep̱a layadṯem, amge danab Nug da dimulp̱a uḏiṯe amu nuhig g̱agaṯag amu dahil eḏidṯe, Nug am danab oḵainab, da am oḵai iiṯa. Dahil hak imu nuhignu ele elele iiṯa. Nug amu ag Kayak Ouḏi, ab aḏu elep̱a ag layadḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","Awa anana amu nug nai baula tuḏiṯa aum. “Nug wit aeg amu wit gaḏa ele piḏe piḏe daaḵunu uḏat amu haknu keeke babaiṯom daaṯe. Nug uḏat amu ha, elelenab mewowa, Nug wit meu amu e mak laḵa meḵu. Mewowa, Nug wit gaḏa amu ab aḏu ii qauhṯe elep̱a maneb eoḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","Johanes nug nai kuḏum laalap̱a ele ag doop̱eg oolag maidḵunu nai ena anam mehuqa, danab ah amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","Anam haaha amu nug Herodes Antipas eheḏ ha, nug amag Pilip wau Herodias aḏiṯa awa, kobol nau kuḏum laala ele heum doya, Johanes nug amunu Herodes daug batom. ");
INSERT INTO gaw_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","Daug bate amu Herodes nug daug batak nai amu doya, nug kobol nau nuhig amu tuḏiṯa, Johanes awa, mani guiṯakp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","Amge Johanes mani guiṯakp̱a ii dayom haenp̱a danab oh ag layaṯak aoegeg, Jesus ele layaṯak awom. Nug layaṯak awa malowa, Nug unuqiṯeṯe, hab obate, ");
INSERT INTO gaw_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","Kayak Ouḏi Nug ai up̱uḏil bia nuhigp̱a ne, baag laa hab aṯannu Nug amegp̱a aum. “Na am da beḵal, da nahipnu ool mauhte. Nahip haknu ele amu da ool ena daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","Jesus Nug layaṯak awom, dimp̱a Nug nuhig maḏ 30 anam dayaya, Nug uḏat dig ma heum. Nug am Kayak Beḵa amge danab ah ag nuhignu, “Nug Josep beḵa,” aon ap̱ig. Josep mameg am Hilai. ");
INSERT INTO gaw_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","Hilai mameg am Matat. Matat mameg am Lewi. Lewi mameg am Melkai, Melkai mameg am Janai, Janai mameg am Josep. ");
INSERT INTO gaw_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","Josep mameg am Matataias, Matataias mameg am Amos, Amos mameg am Neam, Neam mameg am Eslai, Eslai mameg am Nagai. ");
INSERT INTO gaw_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","Nagai mameg am Meat, Meat mameg am Matataias, Matataias mameg am Semen, Semen mameg am Josek, Josek mameg am Joda. ");
INSERT INTO gaw_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","Joda mameg am Joanan, Joanan mameg am Resa, Resa mameg am Serababel, Serababel mameg am Sialtiel, Sialtiel mameg am Nerai. ");
INSERT INTO gaw_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","Nerai mameg am Melkai, Melkai mameg am Edai, Edai mameg am Kosam, Kosam mameg am Elmedam, Elmedam mameg am Er. ");
INSERT INTO gaw_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","Er mameg am Josua, Josua mameg am Eliese, Eliese mameg am Joram, Joram mameg am Matat, Matat mameg am Lewi. ");
INSERT INTO gaw_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","Lewi mameg am Simion, Simion mameg am Juda, Juda mameg am Josep, Josep mameg am Jonam, Jonam mameg am Elaiakim. ");
INSERT INTO gaw_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","Elaiakim mameg am Melia, Melia mameg am Mena, Mena mameg am Matata, Matata mameg am Natan, Natan mameg am Dawit. ");
INSERT INTO gaw_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","Dawit mameg am Jesi, Jesi mameg am Obet, Obet mameg am Boas, Boas mameg am Salmon, Salmon mameg am Nason. ");
INSERT INTO gaw_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","Nason mameg am Aminadap, Aminadap mameg am Atmin, Atmin mameg am Anai, Anai mameg am Hesron, Hesron mameg am Peres, Peres mameg am Juda. ");
INSERT INTO gaw_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","Juda mameg am Jakop, Jakop mameg am Isak, Isak mameg am Abraham, Abraham mameg am Tira, Tira mameg am Naho. ");
INSERT INTO gaw_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","Naho mameg am Serak, Serak mameg am Reu, Reu mameg am Pelek, Pelek mameg am Ebe, Ebe mameg am Sela. ");
INSERT INTO gaw_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","Sela mameg am Kanan, Kanan mameg am Apaksat, Apaksat mameg am Sem, Sem mameg am Noa, Noa mameg am Lamek. ");
INSERT INTO gaw_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","Lamek mameg am Metusala, Metusala mameg am Inok, Inok mameg am Jaret, Jaret mameg am Mahalalil, Mahalalil mameg am Kanan. ");
INSERT INTO gaw_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","Kanan mameg am Inos, Inos mameg am Set, Set mameg am Adam, Adam mameg am Kayak. ");
INSERT INTO gaw_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","Aria Jesus Nug layaṯak awe, Kayak Ouḏi Nug Jesus oop̱a noa am ba, Jesus omala, Jodan lep̱anu awa, atu taḏakp̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","Uḵa deḏ 40 dayeye, Satan nug Jesus eheḏ heḵunu oo eeḏeḏe, haen amu ohp̱a Jesus Nug e laa ii laum amunu haen amu male, Nug enug qeum. ");
INSERT INTO gaw_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","Enug qe, Satan nug Jesus amegp̱a aum. “Na Kayak beḵa daaṯem dayeb amu, na ap̱e, men imu eḏua bret maḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","Awa a amu Jesus Nug Satan oḏep̱a awa aum. “Kayak naip̱a yak inam daaṯe, ‘Danab ah ep̱aib bau daanna ii oiṯeb,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","Awa a amu Satan nug Jesus omala, qaukop̱a ta, pahanab wan oh, ahilag gumak aben aben ele ip̱uniṯowa, ");
INSERT INTO gaw_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","Satan nug aum. “Keeke amu oh gumaknu g̱agaṯag amu onig binag ele da na medaḵulnu heṯem. Keeke umu oh amu laa Nug da meḏom amunu da danab laa medaḵulnu ool dayeb amu da medaḵul. ");
INSERT INTO gaw_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","Amge na da noolp̱a dup nona, gaten qaun ona, da binal mep̱e amu keeke umu oh amu da na medaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","A amu Jesus Nug Satannu nai nob ma aum. “Kayak naip̱a yak daaṯe, ‘Na Naḏiib binag me! Nug am nahip Kayak amunu na nuhig uḏat aaḵuib he!’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","Anam a amu Satan nug Jesus omala, Jerusalem uḵa, mana meṯak lag aṯan te dayeye, amegp̱a aum. “Na Kayak Beḵa daaṯem dayeb, na ip̱anu oolna honap no! ");
INSERT INTO gaw_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","11","Aḏinu? Kayak naip̱a yak inam daaṯe. ‘Na baen men yaamanu, Nug engel amelagp̱a nahipnu ab, ag na ep̱elagp̱a mawidḵulag,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","A amu Jesus Nug Satannu nai nob ma aum. “Kayak naip̱a yak inam daaṯe. ‘Na Naḏi, nahip Kayak, Nug keeke laa heḵunu aum am genab heḵutai o iiṯatai dooḵutnu amu na Nug aib eeḏme,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","Satan nug Jesus ib amu ohp̱a eheḏ heḵunu oo eeḏowa, nug uuiṯa uḵom. Deḏ ena laa baula heḵunu ameg meum. ");
INSERT INTO gaw_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","Aria Satan nug Jesus oo eeḏa male amu Jesus Nug Kayak Ouḏinu g̱agaṯag ele eḏua, Galelia uḵe, nuhignu nai amu uḵe, ap̱anu oh doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","Hanhan Nug ahilag nai doyak laḵa nai mehuqaqa, danab ah ip̱uanaṯeṯe, danab ah oh ag Nug binag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","Anam dayeye, deḏ laa Jesus Nug Nasaret uḵom. Nug ap̱a nid nakok dayeye, anig mameg ele a atog noeheh, ena meum. Nug Nasaret uḵa amu Nug Juda dilag Meṯidp̱a, Juda dilag nai doyak laḵa, Nug haen oh heṯom bia ha noum. Noa amu Nug Kayak nai eb qekunu hibaiṯeṯe, ");
INSERT INTO gaw_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ag Kayaknu propet Jesaianu buk laa medap̱ig. Nug buk awa kola, Nug Kayak naip̱a nai inam daaṯe, amu anṯa eb qeum. ");
INSERT INTO gaw_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“Naḏinu Ouḏi amu dahilp̱a daaṯe, amunu Nug da Nai Ena daḏek danab noolagp̱a mehuqḵulnu, da mani guiṯak danab ag dimiṯim doḵulagnu, danab amelag gaḏuak ele ag ena neegḵulagnu amu danab ag laala waalagp̱a eheḏ nau daaṯeb ele, ag uhuqak aoglagnu amelagp̱a aḵulnu ");
INSERT INTO gaw_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","amu Naḏinu ḏo maḏoḏnu nai mehuqp̱i, nuhiḵud danab ah oh ag amu dooglagnu otiḏe uḏimi.’” ");
INSERT INTO gaw_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","Jesus Nug buk eb qewowa, eḏua gumak danab meṯowa, aaḵu balalp̱a dayom. Dayeye, danab ah oh ahilag nai doyak lag oop̱a daap̱ig amu ag neegna, Jesusib anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","Anṯegeg amu Nug dig ma amelagp̱a aum. “Gemu da nai imu eb qeiyi, Kayaknu yak amu aaḵu meu oum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","Nug a, ag doonna, ag Nug binag menana, ag nai genab iṯag ele Nug maṯiom amu ag amunu dab mak kuḏum ele aop̱ig. Amu ag ap̱ig, “Adeḵutai? Danab umu Nug am Josep beḵa iiṯatai?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","Aon aeg aria Nug ag amelagp̱a aum. “Genabnab genab ag dahilnu inam aḵulag, ‘Dokta, na naḵa na beḏun babaiṯe! Kobol na Kapenaum abp̱a he, ig nai doomut ele amu, amubia ip̱a, imu am na ap̱an diig, ip̱a ele he!’ aon aḵulag.” ");
INSERT INTO gaw_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","Anam awowa amu Nug tuḏiṯa aum. “Da genab ag amelagp̱a aṯem. Propet ap̱ag diigp̱an danab amu ag nug ii aomna. ");
INSERT INTO gaw_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","Ag doyeg! Eliasnu haenp̱a Israel oolagp̱a ah qab kuḏum daaegeg, haen amup̱a maḏ ewam, kalam siks ele gu ii ne, wan ohp̱a enug haen naḏi dayom. ");
INSERT INTO gaw_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","Amge Kayak he, Elias nug Israel dilagp̱a ah qab gumaṯa ii uḵom. Iiṯa, Nug he, Saidonnu ab laa onig Sarpat, ah qab laa ap̱a dayeye, nug gumiṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","Am laa ele, Kayaknu propet Eliesanu haenp̱a, danab kuḏum ag gaḏa oḏe ele Israel oolagp̱a daap̱ig amge ag oolagp̱anu danab laip̱u laa nuhig oḏe amu iiṯa meumte? Iiṯa. Siria ted Neaman nuḵaib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","Jesus Nug anam a amu danab oh, Juda dilag nai doyak laḵa daap̱ig ele, ag am Juda danab amu ag ham bup̱un, “Ig Judaib ig oop̱a genab doyak ena ele,” dab mep̱ig amunu amu ag nai amu doona, op̱oḏilag huana be, ");
INSERT INTO gaw_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ag ahan, Jesus aona, ab oḵai dimiṯim gop̱ig. Ab oḵai ahilag amu qauko aṯan ap̱a dayom amunu ag Jesus aona, qauko amup̱a tena, aon ab giginp̱a wana, buḏip̱eg baip̱a noḵunu hep̱ig ");
INSERT INTO gaw_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","amge Jesus Nug ag oolagp̱anu aha, uuaṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","Amu Jesus Nug eḏua Galelia wanp̱a ab oḵai Kapenaum ap̱a uḵa, amup̱a nug Juda dilag Meṯidp̱a nai ipuanaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","Nug am nai diig tutuḵu g̱agaṯag ipuanaṯe anidna, ag dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","Aria Juda dilag nai doyak laḵa ap̱a amu danab laa dayaya, nug beḏup̱a ouḏi nau ele amu, nug Jesus anṯa, nug baag oḵaip̱a ewa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“Jesus, Nasaret ted, na ig aṯem heigḵutnu uḏime? Na hep̱e, ig nauhḵunignu uḏimete? Da na dooidṯem. Na am Kayaknu Laa, Op̱ia Awak Ele?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","Nug anam aum amge Jesus Nug ouḏi nau amegp̱a aum. “Na oḏen qamutna, danab amu uuidna uḵe!” awa aum. Jesus Nug anam a amu ouḏi nau nug ag oolagp̱anu he, danab amu wanp̱a na qe, nug uuiṯa ugaḵa, danab amu nug beḏup̱a eheḏ laa ii heum. ");
INSERT INTO gaw_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","Amunu danab oh ag dab mak kuḏum aona, aḵa aḵa Jesusnu ap̱ig. “Nai umu amu aṯemunnab? Danab amu Nug ehah ena, g̱agaṯag ena ele amunu Nug ouḏi nau amelagp̱a, ‘Ag uḵeg!’ aṯe amu ag uuadna goṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","Anana, ag Jesus keeke heum, nai amu pahanab tuḏiṯeg, wan amunu ab ohp̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","Aria Jesus Nug Juda dilag nai doyak laḵanu aha, Simon laug oop̱a noum. Simon nome nug oḏe, beḏu g̱akaḏak huanaknab amunu ag Jesus ehanidḵunu amegp̱a ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","Aeg amu Jesus Nug noa, gumiṯa hibaiṯa dayaya he, oḏe uuiṯe, nug paha aha, ahilag e babaiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","Babaiṯe aria deḏ amu aam noono amu danab ab mudip̱an, ag lailḵad oḏe diigdiig ele amu aḵan, Jesus top̱a uḵaeg, Nug danab amu ep̱egp̱a aḏalaṯe, ena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","Ele amu Jesus Nug he, ouḏi nau ag danab ah kuḏum uuadna, “Na amu Kayak Beḵa,” ana enan gop̱ig amge ag doop̱ig, Nug am Kristus amunu Nug ag baula maṯimnanu ag amelagp̱a, “Aib!” a, ag oḏelag qamutp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","Aria waḵaḏeḏe, buṯuanab Nug ab amu uua aha, aben laih danab haen oh ii daaṯebp̱a uḵe, danab ag Nug maṯin oin oin, gumidna uḵan, Nug ag uuaṯa ii gomanu hagaḵa aon hep̱ig ");
INSERT INTO gaw_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","amge Nug ag amelagpa aum. “Da Kayaknu ḏo maḏoḏnu Nai Ena amu ab oḵai laalap̱a ele mehuqḵul. Aḏinu? Kayak Nug da anam heḵulnu meiḏe uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","Nug anam anana amu Juda dilag nai doyak lag laalapa noawa, nai mehuqom. ");
INSERT INTO gaw_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","Deḏ laa Jesus Nug le ameg Genesaret, le amu ihip̱a hibaiṯa dayeye, danab ah kuḏum ag Kayak nai dooglagnu uḏin itun daaegeg, ");
INSERT INTO gaw_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","Nug ub nakok aḏit laa le ameg ihip̱a eeḏya daaeheh anatom. Kakai awak danab ag ub aḏit amu uuatna nena, uhui ihanna daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","Nug ub aḏit daapiḏ amu oolahp̱a laip̱u laa, ub amuam Simonnu, amup̱a oola teum. Nug ta, Simon nug ub le ihip̱anu duṯuneb, nakok waḵunu amegp̱a a, nug anam he amu Nug ub aṯan dayaya, danab ah nai maṯom. ");
INSERT INTO gaw_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","Nug nai maṯa malowa aria dimp̱a nug Simon amegp̱a aum. “Ub el qep̱e, le gamag oḵaip̱a wab, ag uhui kakai aoglagnu eig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","A amu Simon oḏep̱a awa aum. “Danab Naḏi, tuqan imu ohp̱a ig uḏat naḏi hemut amge ig kakai laa ii aomut amge na ame amunu ig uhui eḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","Nug anam a amu ag Jesus aum bia heeg, kakai eb qaknu iiṯa noeg, uhui paguḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","Anam anidna, ag ahilḵad uḏat laip̱u, ub laap̱a daap̱ig amu, ag dona ehanadḵulagnu ep̱elagp̱aib onilagp̱a ep̱ig. Eeg doeg, ub aḏit ohp̱a kakai amu inap̱ig. Inaeg, ub aḏit amu oh tuadiglahnu hepiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","Ag anam anṯegeg, Simon Petrus nug kakai anam aona anṯa, nug Jesus baegp̱a dup noa, iḵi wan ya aum. “Naḏi, na da uuiḏna uḵe! Da hip̱unin danabde,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","Nug kakai huanak aop̱ig amu anṯom amunu nug oṯaia, dab mak kuḏum awom. Danab laa nug ele oh daap̱ig, ag ele anamib doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","Sebedi bekoḏ aḏit, Jakobus Johanes ele, a Simon ele layam batan uḏat laip̱u hep̱ig ele amu, a ele eheḏ baḏaeheh, Jesus Nug Simon amegp̱a aum. “Na aib baḏame, geha dimp̱a uḏat laap̱a na danab ah anam bia diiadḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","Aria ag ub eeḏateg, audam teeh amu ag keeke amu oh uuadna, ag gona, Jesus dim lamidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","Jesus Nug ab oḵai laap̱a nakok dayeye amu danab laa gaḏa oḏe am bak ele, nug Jesus anṯa, nug Jesus noobp̱a dup noa, iḵi wan ya, unuqiṯa aum. “Naḏi, na oot heeb, na hep̱e, oḏe dahil am iiṯa meḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","A amu Jesus Nug ep̱eg bahia, danab amu aḏa aum. “Da ool anam daaṯe, na ena daye!” awa aum. Aria geha aaḵu pahanab gaḏa oḏe amu uuiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","Uuiṯe amu Jesus Nug danab amu amegp̱a aum. “Na danab laa amegp̱a da na bap̱aidminu amu aib ame! Iiṯa, na gona, na beḏun mana meṯak danab ip̱unidna, na Mosesnu ḏo aṯe bia, na doḏ main, Kayak meṯe! Aḏinu? Danab oh ag amup̱a, na oḏe iiṯa, dooglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","Nug anam aum amge Jesus Nug keeke heumnu nai amu uḵe, ag tuḏiṯeg uḵe, oh doona, danab kuḏumnab ag ahan, Jesusnu nai dooglagnu, Nug oḏe ahilag bap̱aladḵunu ele uḏip̱ig ");
INSERT INTO gaw_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","amge Nug hanhan aben laih, danab ii daaṯebp̱a uḵa, Nug unuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","Deḏ laa Jesus Nug danab ah nai ip̱uanaṯaṯa dayeye, ḏo gumak danab-Parasia amu ḏo mehuqak danab ele, ag Galelia ab ohp̱anu, Judanu, amu Jerusalemnu ele uḏin daaegeg, Jesus Nug nai mehuqom. Kayaknu g̱agaṯag amu Jesus Nug oḏe danab heeb ena daaglagnu ele nuhigp̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","Dayeye, danab laala ag danab laa, nug baeg ep̱eg ele mauhak ele amu, ag nug qaḏaqaḏp̱a maon uḏip̱ig. Ag maona, lag oop̱a nona, Jesus gumidna wana meḵulagnu hep̱ig ");
INSERT INTO gaw_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","amge aben oh danab ah kuḏum ituak daaegeg, ag oḏe danab maon noḵulagnu amu ib iiṯa amunu ag lag aṯan tena, lag amu koḏoḵo uḏem meṯak ele amunu ag tena, lag koḏoḵo lop̱aḏna, danab qaḏaqaḏp̱a niieye, ag nug paḏaeg, danab oh oolagp̱a Jesus noobp̱a meeg, noa dayom. ");
INSERT INTO gaw_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","Meeg dayeye, Jesus Nug ahilag oop̱a genab doyak am oḵai ele anṯa, Nug oḏe danab amegp̱a aum. “Layal, nahip hip̱unin oh amu da uhuqe medaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","Nug anam a amu ḏo mehuqak danab amu ḏo gumak danab-Parasia ele ap̱a daana, ag aḵa aḵa dab makp̱a inam ap̱ig. “Danab imu amu Nug am aun? Nug nai umu aṯe amu Nug Kayak dabiṯa, awa awa qedaṯe. Kayak Nug nuḵa hip̱unin uhuqa megaḵunu elele,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","Aeg, Jesus Nug nuhig dab makp̱a ahilag dab mak amu doya, Nug ag amelagp̱a aum. “Aḏinu ag dab mak anam ele? ");
INSERT INTO gaw_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","Aḏi nai am anaknu ug iiṯa? Hip̱unin uhuqa meṯaknu nai amute am ug iiṯa o iiṯa aha tap̱a uḵaknu nai, amutai am ug iiṯa? Amu oh iiṯa. Aḏit amu oh am ug ele, danabib heḵunu elele iiṯa ");
INSERT INTO gaw_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","amunu ag Danab Beḵalag da, da wan imup̱a hip̱unin uhuqen madaḵulnu g̱agaṯag ele, ag amu dooglagnu amu da hep̱i, aha goḵu,” awa aum. Jesus Nug anam anana amu Nug eḏua, oḏe danab amegp̱a aum. “Na ahan, qaḏaqaḏ nahip aon, laḵa uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","Nug anam a amu oḏe danab nug aha, niiak qaḏaqaḏ nuhig awa, ag nolagp̱anu dimiṯim uḵa, laugp̱a taata, Kayak binag meum. ");
INSERT INTO gaw_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","Ugeḵe amu ag dab mak kuḏum aona, Kayak binag menana, ag nuhignu enanag doonna, oolag ele oṯaie, ag ap̱ig. “Gemu ig kobol imu laanab anidmut,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","Aria dimp̱a Jesus Nug aha oiyaya, Nug takis awak danab laa, onig Lewi, nug takis awaknu laḵa dayeye anṯom. Jesus Nug anṯa, amegp̱a aum. “Na dona, da dim lamiḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","Nug anam a amu Lewi nug aha, nuhig keeke oh uuaṯowa, Jesus dim lamiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","Dim lamiṯowa, Lewi nug Jesusnu e naḏi laugp̱a he amu takis awak danab amu laala kuḏum ele ag uḏieg, ag ele daanna, e lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","Laegeg amu ḏo gumak danab-Parasia amu ḏo mehuqak danab laala, ag ḏo gumak danab-Parasia huup̱a daap̱ig ele amu, ag ele Jesusnu ip̱uniṯak awak danab noolagp̱a nai hena, amelagp̱a ap̱ig. “Aḏinu ag takis awak danab, hip̱unin danab amu danab laa, ag ihinig ḏo oh ii dim lamidṯeb ele amu, ag ele oh daanna, e lanana, le ele laṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","Anam aeg amu Jesus Nug ag amelagp̱a aum. “Danab nug oḏe iiṯa amu nug dokta top̱a ii goṯe. Iiṯa, danab oḏe ele nug goṯe. ");
INSERT INTO gaw_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","Amubia amu da hep̱i, danab kobol tutuḵu enaib heṯeb ele ag oolag eḏuḵunu ii uḏimi. Iiṯa. Da hep̱i, danab kobol tutuḵu ena ii heṯeb ele ag oolag eḏuḵunu uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","Amu laala ag Jesus amegp̱a ap̱ig. “Layaṯak Johanesnu ip̱uniṯak awak danab ag am deḏ kuḏum e oh lanaknu kud mena daanna, hanhan unuqidṯeb. Amu ḏo gumak danab-Parasia dilag ip̱uniṯak awak danab ag ele anamib heṯeb amge ip̱uniṯak awak danab nahipad ag amu anam ii heṯeb, ag hamu e le ele laṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","Ag Jesus amegp̱a anam ap̱ig amu Jesus Nug aum. “Da amu danab nug ah aoṯe bia. Aria dahil ip̱uniṯak awak danab amu ag am da lailad. Amu ig dooṯem, nug awak haen am oo gamag ahak ele amunu danab nug ah aoṯe amu, nug laiḵud ele ag e oh lanaknu kud mena daaglagnu am iiṯa. Ag oolag gamag ahak ele amunu ag e ii uumna, ag laḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","Anam aaḵu daaṯe amge deḏ laa dimp̱a ag lailag, ah awom ele amu, nug laih uḵeb, haen amup̱a ag oolag ug ele amunu ag e oh lanaknu kud mena daaglag. Amu da ami. Da amu danab ah aoṯe bia. Dahil ip̱uniṯak awak danab ag am da lailad bia. Da gemu ag ele daaṯem amunu ag e oh lanaknu kud mena daaglagnu elele iiṯa. Dimp̱a da gop̱i am ag anam heḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","Amunu Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele amu ou aqata, ip̱uanaṯa, nai laa inam amelagp̱a aum. “Danab nug lamen qaṯi bau awa, lamen alagnu giḏo amup̱a tona ii koit-ṯe. Iiṯa! Nug anam helo amu dimp̱a nug lamen iheb, lamen bau nug eḏua nakok ep̱a, lamen alag eeḏeb, giḏo oḵai ele daaḵu. Ele amu lamen bau, lamen nau alag ele am nakok laip̱u iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","Anam anana amu Nug nai keeke amunu baula inam aum. “Laa ele amu danab nug grep lep̱u bau le itaknu doḏ gaḏa alagp̱a ii inaṯe. Nug anam helo amu grep lepu nug eḏua, wain baaba, titiḏa heebeb, doḏ gaḏa alag nug g̱agatag ep̱om, oḵai meḵunu elele iiṯa amunu nug aoḏeb, wain, doḏ gaḏa ele oh iiṯa meḵulah. ");
INSERT INTO gaw_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","Ag anam ii heṯeb. Danab nug grep lep̱u bau amu le itaknu doḏ gaḏa baup̱a inaglagnuib daaṯe. Ag anam heḵulag am grep lep̱u amu doḏ gaḏa ele am ena daaglah,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","Jesus Nug anam anana amu Nug nai tuḏiṯa aum. “Amu danab nug grep lep̱u alag lanana amu nug grep lep̱u bau hak amu laḵunu oo uuṯe. Uua nug aṯe. ‘Grep lep̱u alag nug lanak ena,’ awa aṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","Aria Juda dilag Meṯid deḏ laap̱a Jesus Nug nuhiḵud ip̱uniṯak awak danab ele ag ibp̱a wit dad laa oop̱a gonana, ip̱uniṯak awak danab nuhiḵud ag wit aeg laala aon, ep̱elagp̱a oḏoḏna lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","Aon laeg amu ḏo gumak danab-Parasia ag hep̱ig amunu inam ap̱ig. “Ag aḏinu ḏo nug danab laa Meṯidp̱a e daṯanu ii aomanu ip̱unigṯe amu ag Juda dilag Meṯidnu ḏo amu tip̱alna, ag e aon laṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","Anam aeg amu Jesus Nug oḏelagp̱a awa aum. “Ag Kayak naip̱a Dawitnu nai laa daaṯe amu ag nai amu iite eb qep̱ig? Haen amu Dawit nug laiḵud ele oiyegeg, enug aqeqe, ");
INSERT INTO gaw_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ag gona tena, Dawit nug Kayaknu lag oop̱a noa, nug bret dayom amu awom. Bret amu danab oh lanaknu gun ele, mana meṯak danab agib laḵulagnu elele amge Dawit nug awa lanana, laiḵud ele maṯe lap̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","Anam awowa Jesus Nug baula ag amelagp̱a aum. “Danab Beḵalag da amu da Meṯid deḏ gumaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","Deḏ laa, Juda dilag Meṯidp̱a, Jesus Nug Juda dilag nai doyak laḵa noa, danab ah nai ip̱uanaṯeṯe, danab laa ep̱eg naḏiap mauhak ebehiṯak ele ap̱a dayeye anṯom. ");
INSERT INTO gaw_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","Ḏo gumak danab-Parasia amu ḏo mehuqak danab ele ag ap̱a daana, Jesus Nug aḏi heeb anidḵulagnu meidp̱ig. Nug Meṯidp̱a danab ep̱eg nau ele ehaniṯeb, elele dayeb amu ag Jesus heṯoḏiak abenp̱a meḵulagnu oolag dayom. ");
INSERT INTO gaw_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","Anam daaegeg, Jesus Nug ahilag dab mak doyaya, Nug danab ep̱eg nau ele amegp̱a aum. “Na ahan, gamagp̱a hip̱aidna daye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","Nug anam a, danab nug hibaiṯa dayeye, Jesus Nug ḏo gumak danab-Parasia amu nai mehuqak danab ele oḏ maṯom. “Ḏo ihinig aḏi aṯe? Ig danab Meṯidp̱a ehanidp̱ut elele daaḵu amu enatai o iiṯa ig danab hep̱ut nauhḵu amuam enatai? Ig hep̱ut, danab laa nug mauhḵunu heṯe, nug elele daaḵu am enatai o iiṯa ig uup̱ut mauhḵu amu enatai?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","Nug anam awowa, Nug neeḵa, danab oh anaṯowa, Nug danab ep̱eg nau ele amegp̱a aum. “Na ep̱en tai eṯe!” awa aum. Jesus Nug anam a amu danab amu nug ep̱eg tai eṯe, ep̱eg eḏua, laih bia, ena dayom. ");
INSERT INTO gaw_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","Aria danab ag Jesus meidna daap̱ig ele amu ag anam anidna, ag Jesusnu op̱oḏilag be, guaṯak bia doona, aḵa aḵa maṯinna ap̱ig. “Ig Jesus nuhigp̱a aṯem heḵunig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","Haen amup̱a Jesus Nug tuqan Kayak unuqidkunu qaukop̱a teum. Ta, Nug tuqan amu oh unuqiṯeṯe uḵe, wagḏom. ");
INSERT INTO gaw_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","Wagḏe, aam be, nuhiḵud ip̱uniṯak awak danab diiḵunu oo daye, Nug ag onilagp̱a e, gumidna uḏieg, Nug danab tuelp tituanaṯa, ag onilag totol danab ataḏom. ");
INSERT INTO gaw_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","Laa am Simon. Amu Jesus Nug onig laa, Petrus ataḏom. Laa am Andreus, nug Simon ele, a am eamag. Aria, Jakobus Johanes ele amu Pilipus Batolomiu ele. ");
INSERT INTO gaw_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","Mateus Tomas ele amu Jakobus laa nug amu Alpias beḵa. Amu Simon laa, nug am selot. ");
INSERT INTO gaw_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","Laa am Judas, nug Jakobus beḵa amu Judas Iskariot ele, nug amu dimp̱a Jesus awa, kekeḏ ep̱elagp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","Amu Jesus Nug ag ele oh nona gona, Nug wan uḏem enap̱a hibaiṯa dayom. Nuhiḵud ip̱uniṯak awak danab ameg naḏi laa amu danab ah kuḏumnab laa, ag Judanu, Jerusalemnu amu ab oḵai aḏit, onilah Taia Saidon ele, amu dilah wanp̱anu ele oh uḏieg daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","Ag nai nuhig dooglagnu, Nug ag oḏe ahilag bap̱aidḵunu ele uḏip̱ig. Ag uḏin daaegeg, danab laa ag ouḏi nau ele amu Jesus Nug ouḏi nau amu lamaṯe ena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","Danab ah oh ag ep̱elag bahin, Jesus beḏu aḏaglagnu oolag dayom. Aḏinu? Ag aḏaeg, nuhig g̱agaṯag amu beḏulagp̱a uḵa he, danab oh ag ena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","Ag anam heeg amu Jesus Nug ameg huma, nuhiḵud ip̱uniṯak awak danab amu neeḵaṯaṯa, Nug aum. “Ag gemu enulag iiṯa, ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Ag Kayaknu ḏo maḏoḏ aop̱ig daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","Ag gemu enug aqaṯe ele amu ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Kayak Nug heeb, ag oolag didiḵu. Ag gemu oolagp̱a ug doon gaaṯeb ele amu ag itiṯak ena aop̱ig daaṯeb. Aḏinu? Ag oolag gamag ahaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","Ag da dim lamiḏṯeb amunu haen danab laala ag amu anidna, ag ahilagnu oolagp̱a nau, ninig ele doon, ag geḏadna, nai nau ahilagnu anana, ag am danab nau ele aṯeb amu ag dahilad amu ag itiṯak ena aop̱ig daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","Danab kobol nau amu heṯeb ele amu, anuḵa ag alalḵad, ag Kayaknu propet beḏulagp̱a ele anam hep̱ig amunu ag ahilagnu ele anam hep̱eg amu aria ag gamalag ahebeb, oolag enaib dayaḏ! Aḏinu? Nob ahilag hab aṯan amu oḵainab. ");
INSERT INTO gaw_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","Amge o gadon ag danab enulag ele. Ag dab meig! Keeke ahilag, ag oolag ena daaḵunu amu, ag wan imup̱a aaḵu aon malap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","O gadon ag danab ag gemu laeg, oolag didiṯe ele. Ag dab meig! Geha dimp̱a ag enug aqaḵu. O gadon ag danab ag gemu imṯeb ele. Ag dab meig! Geha dimp̱a ag ug doon gaap̱eg, amelag leb neḵu! ");
INSERT INTO gaw_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","Amu haen danab laa oh ag binalag meḵulag amu ahilagnu am gadon. Ag amunu dab meig! Anuḵa amu ag alalḵad ag anamib propet ham bup̱uak dilagp̱a hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","Amge ag dahil nai dooṯeb ele, da ahilagnu aṯem. Ag ahilag kekeḏnu amu ag oolag mauhaḏ! Amu aun aḏi ag ahilagnu oolagp̱a nau, ninig ele dooṯeb amu ag kobol ena ahilagp̱a heig! ");
INSERT INTO gaw_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","Danab laala ag nob nau aoglagnu ap̱eg, ag dahilad amu ag ahilagnu eḏun anam aib hep̱ig. Iiṯa! Ag itiṯak ena maṯeg! Amu aun laala ag ahilagnu awa awa qeṯak nai madiṯeb amu ag ehanadna, ahilagnu unuqiṯeg! ");
INSERT INTO gaw_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","Am danab laa nug na hip̱en laih ob amu na eḏun nob nau aib meṯame. Iiṯa. Na eḏun hip̱en laih amu ele medaḵut. Am danab laa nug lamen nahip aweb amu na elele daaḵutnu ḏo noobp̱a wagai aib meme. Iiṯa! Na lamen laa nahip amu ele medaḵut. ");
INSERT INTO gaw_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","Am danab laa nug keeke medaḵutnu oḏ meṯeb amu na nug meṯe! Aria danab laa nug aḏi keeke nahip aweb amu na aib eḏua medaḵunu wagai meme. ");
INSERT INTO gaw_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","Amu ag dahilad amu ag danab ag kobol aṯemun ahilagp̱a heḵulagnu oolag daaṯe amu ag anamib ahilagp̱a heig! ");
INSERT INTO gaw_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","Amge ag danab ag ahilagnu oolag mauhṯe ele, ag amu dilagib oolag mauhebeb amu kobol amup̱a Kayak Nug ag binalag madaḵute? Iiṯa. Hip̱unin danab ag ele anam heṯeb. Yo, hip̱unin danab ag danab ag ahilagnu oolag mauhṯe ele amu, ag amu dilag oolag mauhṯe. ");
INSERT INTO gaw_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","Amu ag danab laa ag kobol ena ahilagp̱a heṯeb ele, ag amu dilagp̱aib kobol ena hep̱eg amu kobol amup̱a Kayak Nug ag binalag meḵute? Iiṯa. Hip̱unin danab ag ele anam heṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","Amu ag keeke ahilag danab laa nob eḏua madaḵunu maṯona amu ag dimp̱a eḏun nob aoglagnu oolag dayeb amu kobol amup̱a Kayak Nug binalag meḵute! Iiṯa! Hip̱unin danab ag ele anam heṯeb. Yo hip̱unin danab ag hip̱unin danab laa nob eḏua madaḵunu, ag keeke meṯona amu ag eḏun keeke ahilag, nob anamib aoglagnu medaṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","Amge ag kekeḏ ahilḵadnu ag oolag mauhaḏ! Amu ele ag ahilagp̱a kobol ena heig! Danab ag ahilagnu keeke nob eḏua maṯaknu aoglagnu ap̱eg amu maṯeg! Maṯona, dimp̱a ag ahilagp̱a keeke amu eḏun aoglagnu aib dab mep̱ig. Ag anam hep̱eg amu nob ena ahilag amu oḵai daaḵu. Ag Kayak aṯannab daaṯe ele amu, Nug beḵod daaglag. Aḏinu? Nug nuhig oo doyakp̱a danab laala, nuhignu dab ii meṯeb ele, danab ag aḵa ahilagib dab meṯeb ele amu, Nug amu dilag ele keeke ena madaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","Amunu ag Mamelag, Nug danab dilagnu oo gai iiṯa dooṯe, amubia ag laa dilagnu oolag gai iiṯa doyeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","Jesus Nug anam anana amu Nug baula aum. “Ag nob nau g̱agaṯagnab aomnanu amu ag laa dilag ag nob nau g̱agaṯagnab aoglagnu aib dab mep̱ig. Laa ag, ag onilag hep̱eg nauhmanu amu ag laa onilag aib hep̱eg nauhom. Ag laa dilag hip̱unin uhuqna madap̱eg amu laa ag ahilag hip̱unin uhuqna maṯaglag. ");
INSERT INTO gaw_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","Ag danab keeke madap̱eg amu ag eḏun mep̱eg, keeke am beeb, yaap̱eg nob, baubau inap̱eg, am ba goḵaḏebeb, ag maṯaglag. Ag danab melemel madaṯeb amu melemel amup̱aib geha ag maṯaglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","Jesus Nug anam anana amu Nug nai tuḏiṯa keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, nai laa inam ele amelagp̱a maṯia aum. “Danab ameg gaḏuak, nug layag ele ameg gaḏuak amu, laa nug laa ib ip̱unidḵunu elelete? Iiṯa. Nug anam heeb amu a oh goya, moḏp̱a neya qeḵulah. ");
INSERT INTO gaw_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","Ip̱uniṯak awak nid nug ip̱uniṯak danab nuhig ii eḏidṯe. Nug ip̱uniṯak nai oh awa malowa amu nug ip̱uniṯak danab nuhig bia daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","Aḏinu na layap amegp̱a kinipan hup̱u nakok daaṯe amunu na neegṯem amge na amenp̱a, ad maha oḵai daaṯe na amunu dab ii meṯem? ");
INSERT INTO gaw_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","Na dab mak aṯem aona, na layap amegp̱a, ‘Lai, da kinipan hup̱u nakok na amenp̱a daaṯe amu aoḵulnu heṯem,’ aṯem? Na anam aṯem amge na naḵa amenp̱a ad maha oḵai daaṯe amu na ii anidṯem. Na am ham bup̱uak danab! Tatam na ad maha oḵai, na amenp̱a daaṯe ele, amu mautp̱e na uḵeb, aria dimp̱a na peheṯan neegnana amu dimp̱a na layap amegp̱a kinipan amu maute!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","Anana amu Nug baula aum. “Amu ad ena nug meu nau ii oṯe, amubia ad nau nug meu ena ii oṯe. ");
INSERT INTO gaw_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","Danab ag nuhig meup̱a ad anidna dooṯeb. Amu danab ag ad pig meu amu muḏi qaun elep̱anu ii aoṯeb, ag grep meu amu ad nakok qaun elepanu ele ii aoṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","Danab ena nug nuhig dab mak enaib oop̱a daaṯe amunu nug kobol enaib heṯe. Danab nau nug nuhig dab mak nauib oop̱a daaṯe amunu nug kobol nau heṯe. Nug oop̱a am bak daaṯe amuib amu oḏep̱a ele madiṯe. ");
INSERT INTO gaw_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","Aḏinu ag dahilnu, ‘O Naḏi, O Naḏi,’ aon aṯeb amge ag dahil nai dim ii lamidṯeb? ");
INSERT INTO gaw_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","Amu danab laa nug da gumiḏa uḏia, dahil nai doya, nug dim lamidṯe ele, da nuhig kobol amunu ag inam ip̱uanadp̱i anidna oolag maidḵu. ");
INSERT INTO gaw_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","Nug am danab laa amu nug lag buuḵunu ha, nug tatam moḏ awe, uma noa uḵe, wan oop̱a men naḏi qaḏep̱a nug lag mawa daaḵuknu keeke aḏe, men aḏa dayeye aria dimp̱a nug amu aṯan lag heum bia daaṯe. Danab amu nug lag anam heum amunu dimp̱a le ui na duṯune amu lag na qeḵunu elele iiṯa. Aḏinu? Danab nug lag enanag heum. ");
INSERT INTO gaw_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","Amge danab nug dahil nai doya ii dim lamidṯe ele amu, nug am danab laa lag hamu wanp̱aib he dayom bia. Nug wan oop̱a men qaḏep̱a lag mawa daaḵunu keeke ii aḏom amunu dimp̱a le ui na, lag amu duṯune, pahanab na qa, lop̱aḏa, iiṯa meum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","Jesus Nug danab ah keeke amu oh amelagp̱a awowa aria Nug Kapenaum uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","Amu Rom danab laa, nug daup 100 dilag iḵi amu, nuhig begbeg laa, nuhignu oo dooṯe ele amu, nug oḏe ma mauhḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","Nug anam dayom amu daup iḵi nug Jesus ap̱a uḏiom doya, nug Juda dilag iḵi danab laala ag gona, Jesus ap̱eg uḏia, begbeg nuhig amu heeb ena daaḵunu he gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","Ag Jesus gumidna gona, daup iḵinu ii daye daye ap̱ig. “Nug am danab ena, na nug ehanidḵutnu elele. ");
INSERT INTO gaw_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","Nug am ig Juda ihinignu oo mauhṯe. Nug nuḵa ihinig nai doyak lag amu buuom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","Anam aeg amu Jesus ahe, oh gona, guguiṯegeg amu daup iḵi nug laiḵud laa Jesus ap̱eg dooḵunu amelagp̱a a, ag gona, nug aum oḏe Jesus amegp̱a ap̱ig. “Danab Naḏi na hamu uḏie nidṯe. Da am danab enate amu na uḏin da laul oop̱a neḵut? ");
INSERT INTO gaw_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","Am da ele da dooṯem, da danab ena iiṯa amunu da na gumiṯen goḵulnu amu da elele ii doomi amge na begbeg dahil eḏua ena daaḵunu naiib a! Na anam naiib ap̱e amu begbeg dahil nug eḏua ena daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","Da amu dooṯemnu diig am, da ele uḏat imunu danab oḵai waalagp̱a daaiyi, ag da gumiḏegeg amu dahilad daup ag da waalp̱a daaṯeb. Amunu da laa amegp̱a, ‘Na uḵe!’ ai aria nug goṯe. Amu da laa amegp̱a, ‘Na do!’ ai aria nug doṯe. Dahil begbeg ele amegp̱a, ‘Na uḏat imu he,’ ai aria nug heṯe amunu na naiib ap̱e, keeke amuam beḵu dooṯem.” Danab amu ag oḵai ahilag oḏe amu aon, Jesus amegp̱a ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","Ag anam aeg, Jesus Nug doya, Nug dab mak kuḏum awawa, Nug eḏua, danab ah ameg naḏi ag Nug dim lamidp̱ig ele amu, Nug ag amelagp̱a inam aum. “Da ag amelagp̱a aṯem. Da Israel danab oolagp̱a oop̱a genab doyak imubia amu da laa ii anidmi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","Aria danab daup iḵi nug he, ag Jesus top̱a gop̱ig ele amu, danab amu ag eḏun nug laugp̱a gona, begbeg nuhig amu eḏua ena dayeye anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","Amu nakok dimp̱a Jesus Nug ab oḵai laa onig Nen uḵe, nuhig ip̱uniṯak awak danab amu danab ah ameg naḏi ag Nug ele oh gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","Nug uḵa, ab amunu od oḵai amu guguiṯa noono, ag danab mauhak laa maon dop̱ig. Danab mauhom nug anig am ah qab, nug beḵa laip̱u amu aaḵuib. Amu danab ah ameg naḏi ab amup̱anu ag ah amu, nug ele uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","Jesus Nug ah amu anṯa, nuhignu oo doye, Nug ah amu amegp̱a aum. “Na aib gaame,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","Anam anana, Nug qaḏaqaḏ maop̱ig amu gukuiṯa wana, ep̱eg bahia, danab mauhak niiom ele qaḏaqaḏ amu aḏe, danab qaḏaqaḏ maop̱ig ele, ag hip̱aidna daap̱ig. Daaegeg Jesus Nug aum. “Nid bau, da aṯemde, na ahe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","Anam a, danab mauhom amu eḏua aha dayaya, nai maṯie, Jesus Nug eḏua awa, anig meṯom. ");
INSERT INTO gaw_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","Danab ah oh ag amu anidna, Kayaknu ena doona, ag oolag oṯaie, ag Kayak binag mena ap̱ig. “Propet naḏi laa ig oonigp̱a uḏiom. Kayak Nug ig ehanigḵunu uḏiom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","Amu danab ag Jesus keeke heum amunu ag maṯieg uḵe, Juda wan ohp̱a amu wan laala, Juda taliliṯak ele uḵe, ap̱an danab ag doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","Ag Jesus heumnu maṯiegeg amu Johanesnu ip̱uniṯak awak danab ag keeke amu ohnu nug amegp̱a aeg doyom. ");
INSERT INTO gaw_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","Doya amu Johanes nug nuhiḵud ip̱uniṯak awak danab aḏit onilahp̱a e, gumidya doeh, a goya Jesus inam oḏ meṯaglahnu aum. “Danab laa uḏiḵunu aeg doomut am na aaḵute o iiṯa ig laate ameg meḵunig?” Nug anam amelahp̱a anana, nug he gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","Anam a amu danab aḏit amu Jesus gumidya goya, a apiḏ. “Layaṯak Johanes nug he, i na oḏ meṯagnihnu gumidḏa uḏimuḏ. Oḏ mak am inam. Danab laa uḏiḵunu aeg doomut am na aaḵute o iiṯa, ig laate ameg meḵunig?” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","Haen amup̱anab Jesus Nug danab ah kuḏum ag oḏe diigdiig ele amu he ena daaegeg, Nug ouḏi nau kuḏum lamaṯaṯa, ameg gaḏuak kuḏum Nug he, ag amelag op̱ate ag neegp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","Amunu Jesus Nug ahilah nai amu eḏua nob ma amelahp̱a aum. “A goya, keeke oh gemu a anidya doopiḏ, aaḵude Johanes apeḏ doyaḏ! ‘Danab ag amelag gaḏuak amu gemu ag eḏun neegṯeb. Diḏilag aḏak amu ag ena oiṯeb. Amu gaḏalag oḏe ele amu oḏe amu iiṯa meṯe, daulag ituak ele ag eḏun, nai dooṯeb, danab mauhp̱ig ele amu ag eḏun bau daaṯeb, daḏek danab ag ele Nai Ena dooṯeb.’ ");
INSERT INTO gaw_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","Amu danab aun nug nuhig oop̱a genab doyak dahilnu ii paḏe neṯe ele amu, Kayak Nug danab amu itiṯak medaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","Am danab aḏit Johanesnu nai aoya uḏipiḏ ele amu, a eḏuya uḵaeheh, Jesus Nug Johanesnu danab ah amelagp̱a inam aum. “Ag anuḵa ag Johanes gumidna atu taḏakp̱a gop̱ig amu ag aḏi keeke anidḵulagnu gop̱ig? Ag keeke gai iiṯa, qaiṯobṯob bia, ulah he uḏalṯe amu anidḵulagnu gop̱igte? ");
INSERT INTO gaw_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","Iiṯa, ag gop̱ig am aḏi keeke anidḵulagnu gop̱ig? Ag gona danab laa lamen enanagnab, kobol ele taḵom amu anidḵulagnu gop̱igte? Iiṯa. Danab ag lamen enanagnab, kobol ele tagaṯeb amu ag king laugp̱a daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","Amge ag aḏi keeke anidḵulagnu gop̱ig? Ag propet laa anidḵulagnu gop̱igte? Da ag amelagp̱a aṯem, ao, ag am propet anidḵulagnu gop̱ig. Nug am propet amge propetib iiṯa. Nug amu propet laa oh eḏaṯak. ");
INSERT INTO gaw_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","Nug am laa, Kayak Nug nuhignu a, propet laa nug Kayak oḏe awa, Kayak naip̱a yom daaṯe. Nai am inam. ‘Anṯe! Da hep̱i, dahil nai awa uḵa maṯiaknu danab laa nug na noom awa, nahip ib bap̱aidḵu.’” ");
INSERT INTO gaw_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","Jesus Nug anam awowa, Nug nai tuḏiṯa aum. “Da ag amelagp̱a aṯem. Layaṯak Johanes nug danab anuḵa propet daap̱ig amu oh eḏaṯom amge danab laa nug Kayaknu ḏo maḏoḏ oop̱a danab nakokib daaṯe, nug nuhig itiṯak amu Johanesnu eḏidṯe. ");
INSERT INTO gaw_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","Danab ah oh am takis awak danab ele ag Johanesnu nai doop̱ig amunu ag, ‘Kayak Nug tutuḵuib heṯe,’ aon anana, ag Johanes ep̱egp̱a layaṯak aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","Amge Juda dilag ḏo mehuqak danab amu ḏo gumak danab-Parasia ele ag amu ag Kayak Nug ib ena ipuanaṯom amu ag uun, di meṯaeg, Johanes nug ag ii layaṯom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","Jesus Nug anam anana amu Nug nai tuḏiṯa aum. “Da danab ah haen geha imunu da ahilagnu aḏi bia aḵul? Ag am aḏi danab?” ");
INSERT INTO gaw_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","Ag am nid naunau haḏapp̱a daanna, ameg laa amu ameg laa amelagp̱a enana, ‘Ig ahilagnu dumuṯum iwalmut amge ag ahi ii edap̱ig. Ig ahi oo doyak ele eṯamut, amge ag ii gaap̱ig,’ aṯeb amubia heṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","Aḏinu? Layaṯak Johanes nug uḏia amu nug e diigdiig ii laum, wain ele ii laum amunu ag, ‘Nug beḏup̱a ouḏi nau ele,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","Aria Danab Beḵalag da, da uḏien, da e lain, le ele lami amunu ag, ‘Anṯeg, nug e huanak lanana, wain ele huanak laṯe. Nug laiḵud am takis awak danab, hip̱unin danab amu danab laa, ag ig Juda, ihinig ḏo oh ii dim lamidṯeb,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","Amge Kayaknu doyak am keeke genab amu nuhig hakp̱a ag am genab anidḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","Amu ḏo gumak danab-Parasia laa nug Jesus ele e laḵulahnu Jesus onigp̱a e, nug laugp̱a uḵe, a e laḵulahnu daapiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","Daaeheh, ab oḵai amup̱anu hip̱unin ah laa dayom, nug, “Jesus uḏia, ḏo gumak danab-Parasia laugp̱a e laṯe,” amu doya, nug men botol goḏen enanag laa awa uḏia, ");
INSERT INTO gaw_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","Jesus baegp̱a, guguiṯa dimugp̱a hibaiṯa gayaya dayom. Ameg leb goḵaḏa, Jesus baegp̱a ne amu iḵi uḏugp̱a op̱iaya, Jesus baeg ootuqiṯaṯa, goḏen amu Jesus baeg laaiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","Amu ḏo gumak danab-Parasia, Jesus onigp̱a e uḏiom ele, nug keeke amu anṯa, inam dab mak awom. “Danab umu Nug genab propetlob amu ah umu ep̱eg bahia aḏaṯe amu nuhig kobol ele doolo. Ah umu nug hip̱unin ah,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","A amu Jesus Nug danab amu nuhig dab makp̱a anam aawo doya, Nug miag matula oḏ meṯa aum. “Simon, da nai laa madip̱i na dooḵutnu ool daaṯe,” awa aum. Awa a Simon nug aum. “Ip̱uniṯak danab, nahip nai amu mehuqe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","Anam a amu Jesus Nug nai imu maṯia aum. “Danab aḏit laa a beḏulahp̱a danab laanu keekenu nob ele. Danab laa nug nuhig daden nob amu 100 kina amu laa nuhig daden nob amu 10 kina ele. ");
INSERT INTO gaw_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","Amu a keeke nob amu eḏuglahnu amu elele iiṯa amunu danab amu nug ahilah keeke nob amu uua, oo ii daye, uhuqa matom. Aria a oolahp̱a danab aun nug danab men doḏo matom, nuhignu oo oḵainab mauhḵu?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","Awa a amu Simon nug Jesus nai maṯie doya, oḏep̱a awa aum. “Dahil dab makp̱a amu danab nug keeke nob oḵai uua, uhuqa meṯom ele, nug am anam dooḵu,” awa aum. A amu Jesus eḏua amegp̱a aum. “Dab mak amu tutuḵu, na nob ena meme,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","Jesus Nug anam anana amu Nug eḏua, ah neeḵiṯaṯa, Simon amegp̱a aum. “Na ah imu anidṯem. Da na laut oop̱a nemi amu na le aon dona, da bael ii ihame amge ah imu nug ameg lebp̱a da bael ihaha, nug iḵi uḏugp̱a op̱iom. ");
INSERT INTO gaw_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","Na da ii ootuqilme amge da lag oop̱a neiyi, ah imu nug dig ma, da bael ootuqiṯaṯa daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","Amu na da iḵil goḏen ii laaidme amge ah imu nug goḏen awa uḏia, da bael laaidṯe. ");
INSERT INTO gaw_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","Amunu da na amenp̱a aṯem. Nug hip̱unin kuḏum heum amu da aaḵu uhuqa medaṯem. Aḏinu? Nug dahilnu oo huanak mauhṯe. Amge danab nug hip̱unin nakok he, da hip̱unin nuhig uhuqen meṯai, nug dahilnu oo nakokib mauhṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","Nug anam anana amu Nug ah amegp̱a aum. “Da hip̱unin nahip amu uhuqen medaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","Jesus Nug ah amegp̱a nai anam a amu danab nug ele oh balalp̱a daap̱ig ag aḵa aḵa nai maṯin ap̱ig. “Nug am danab aun, Nug hip̱unin uhuqa meṯak danabte?” ");
INSERT INTO gaw_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","Anam aeg amge Jesus Nug baula ah amu amegp̱a aum. “Na ootp̱a genab doome amunu da hei, na ena daaṯem. Na maḏoḏ ele uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","Haen laa dimp̱a Jesus Nug uḵa, ab oḵai ab nakok ele laalap̱a taliliaṯa oiyaya, Kayaknu ḏo maḏoḏnu Nai Ena amu mehuqa, danab ah ip̱uanaṯom. Nuhiḵud ip̱uniṯak awak danab tuelp ag Nug ele oiegeg ");
INSERT INTO gaw_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","amu ah laala ag ele oh gop̱ig. Anuḵa ah amu ag ena ii daap̱ig. Laa am oḏe ele, laa am ouḏi nau ele amu Jesus Nug he, ena daap̱ig. Laa, Magdala ted Maria, nug anuḵa ouḏi nau eblaih aḏit ele beḏup̱a daaegeg Jesus lamaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","Laa Joana, nug amu Herodes laug gumap̱ig ele dilag oḵai onig Susa, nug wau. Amu Susana aria ah laala ele gop̱ig. Ah amu ag ahilag keekep̱a Jesus amu nuhiḵud ip̱uniṯak awak danab ele ehanadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","Jesus Nug anam oiyeye, danab ah ameg naḏi ag uḏin, Jesus top̱a qag meeg amu danab ah ab oḵai ohnu ele uḏieg, Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa inam maṯia aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","“E ep̱ak danab nug e haḏag ebaḵunu aha, daṯa uḵa oiyaya, e haḏag taoḏom. Nug taoḏe ugeḵe, haḏag laala amu danab ib oiṯebp̱a nena qena niiegeg, danab ag tap̱aegeg, ai ag uḏin, haḏag amu lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","E haḏag laala ag wan men duqe uḵak ele amup̱a nena qena bep̱ig amge wan tep̱u iiṯa amunu ag diḏilag bau dayak elele iiṯanu qaḏa eṯe bunaḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","Aria e haḏag laala ag wan muḏi qaun elep̱a nena qeeg, muḏi qaun ele ba, naḏi ma teguaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","E haḏag laala ag wan enap̱a nena qena, ena bena, meulḵad kuḏumnab op̱ig. Wan handat, wan handat anam.” Jesus Nug anam anana Nug ewa, “Danab nug daug ele dayeb amu nug doyaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","Aria dimp̱a nuhiḵud ip̱uniṯak awak danab ag Jesusnu nai amu meu nuhig am aḏi amunu oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","Oḏ meṯaeg amu Jesus Nug aum. “Ag am Kayaknu ḏo maḏoḏnu keeke diig loḵumak amu dooglagnu maṯom amunu ag dooṯeb amge danab laala ag nai, danab nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanadṯe, nai amup̱aib anidṯeb amunu Jesaia nai yom, nai amu elele medaṯe. Nai am inam. ‘Ag neegna amu ag diig tutuḵu ii anidṯeb. Ag nai daulagp̱a dooṯeb amu ag nai meu am tutuḵu ii dooṯeb,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","Jesus Nug anam anana amu Nug nai baula tuḏiṯa aum. “Keeke danab ag dooṯeb ii dooṯeb ele ou aqaṯen, ip̱uanaṯen maṯimi amu, nuhig meu am inam. E haḏag amu Kayaknu nai. ");
INSERT INTO gaw_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","Amu haḏag laala ibp̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab laala ag nai doop̱ig amge dimp̱a Satan nug uḏia, ag oolagp̱a noa he, Kayak nai iiṯa meṯe. Satan nug nuhig dab makp̱a, ‘Ag nai amu oolagp̱a genab doop̱eg, Kayak Nug ag eḏua diima,’ anana heṯe. ");
INSERT INTO gaw_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","Amu e haḏag laala men duqe uḵakp̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab laa ag nai doon, oolag gamalag ahehe, pahanab aoṯeb amge ahilag oop̱a genab doyak am g̱agaṯag iiṯa, haen tutuib daaṯe amunu deḏ laa ahilag oop̱a genab doyak iiṯa meḵunu ug laa be amu ag paha ahilag oop̱a genab doyak amu paḏaṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","Amu e haḏag laa wan muḏi qaun elep̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab amu ag nai dooṯeb amge ag gona oiyegeg, wan imup̱a ug laala amu enub awaknu uḏat amu ameg qak kobol ele, keeke amu oh ag oolagp̱a he, Kayak nai iiṯa ma, danab tutuḵu elelenab daaḵunu meu ii oṯe. ");
INSERT INTO gaw_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","Amge e haḏag wan enap̱a nena qep̱ig ele amu, nai amu inam ip̱unigṯe. Danab laa ag nai doon, ag aona, oolagp̱a meeg, tutuḵu oolagp̱a ena dayeye, ag g̱agaṯag daanna amu ag meu oṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","Aria Jesus Nug nai imu ele maṯiom. “Danab laa nug lam amota, tap̱iḏ waap̱a o balal waap̱a ii meṯe. Iiṯa, nug amota, balal aṯan me ewewe, danab ag lag amu oop̱a nona, ag amahlak anidṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","Amubia gemu keeke laala loḵumak daaṯe amge dimp̱a miag atiglag. Keeke oh danab ag loḵump̱ig daaṯeb amu dimp̱a ag miag atip̱eg, danab oh anidḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","Ag nai dahil dooṯeb ele amu, ag amu dab menan dayeg! Am danab laa nug Kayak Nai aḏaṯe ele amu, dimp̱a Kayak Nug baula ele tuḏiṯa, nug medaḵu amge danab nug Kayak nai laa tutuḵu ii aḏaḏa, nug, ‘Da keeke matu aḏami,’ awa aṯe amu geha Kayak Nug amu eḏua aḏidku,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","Jesus Nug anam anana dayeye amu Nug anig amaḵud ele anidḵulagnu uḏip̱ig amge danab kuḏum ag itun daap̱ig amunu ag Jesus gumidna waḵulagnu ib iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","Ag uḏin daaegeg, danab laala ag Jesus amegp̱a ap̱ig. “Na anin amapad ele ag na anidḵulagnu uḏin, dimiṯim daaṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","Aon aeg amu Jesus Nug amelagp̱a aum. “Danab ah ag Kayaknu nai doon dim lamidṯeb ele, ag amu da anil, amalad ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","Deḏ laa Jesus Nug ub laa aṯan te, nuhiḵud ip̱uniṯak awak danab ele teeg amu Nug ag amelagp̱a aum. “Ig le ameg mataḏta, laih up̱a goḵunig,” awa aum. A amu gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","Ub ugeḵe amu Jesus Nug niiom. Niieye, ulah naḏi laa laip̱un na, le amegp̱a he, le ite, ub oop̱a noa am beḵunu he, ag mauhḵulagnu hena, ");
INSERT INTO gaw_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","nuhiḵud ip̱uniṯak awak danab ag wana, Jesus maḏ eṯan ap̱ig. “Ip̱uniṯak danab, ip̱uniṯak danab, ig mauhḵunignu heṯem!” aon ap̱ig. Aon aeg am Jesus Nug aha, ulah le koḏkoḏ qeum ele amu, Nug a amelahp̱a a anam hemayanu a amu ulah nug iiṯa me, le ele to eṯa, manin dayom, le nug baula ii uḏalom. ");
INSERT INTO gaw_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","Aria Jesus Nug ip̱uniṯak awak danab amelagp̱a aum. “Ag ahilag oop̱a genab doyak amu adep̱a daaṯe?” awa aum. Nug anam heum amu ag nuhignu enanag doon, ag oolag ele oṯaie, ag dab mak kuḏum aona, ag aḵa aḵa maṯin ap̱ig. “Ulah le ele amu danab imu ahilahnu nai aum amu dim lamidpiḏ amunu am aṯemun? Nug am aun?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","Dimp̱a ag el qena gona, laih Gerasa wanp̱a eeḏp̱ig. Wan amuam Galelia le ihi laih daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","Amu Jesus Nug ubp̱anu aha, honap le ihip̱a no amu danab laa ab oḵai amup̱anu Nug gumiṯa doum. Danab amu nug ouḏi nau kuḏum ele. Haen elab nug bam iiṯa oiyaya, laḵa ii daaṯom. Iiṯa, nug matmatp̱a daaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","Danab amu nug Jesus anṯa, ewawa, wanp̱a Jesus baegp̱a na qa, huanaknab ewa aum. “Jesus, na Kayak Aṯannab Beḵa, na da aṯem heiḏḵut heṯem? Da na unuqidṯem. Na da guiṯak aib meḏame,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","Am Jesus Nug matu ouḏi nau nug danab uuidḵunu aum amunu nug anam aum. Haen kuḏum ouḏi nau nug danab amu aḏeḏe, danab ag nug gumanna, senp̱a qaḵan, baegp̱a aḏaḵunu keekep̱a ele qagṯap̱ig amge nug sen keeke amu oh paḵua awe, ouḏi nau nug nug awa aḏe, laih atu taḏakp̱a goṯom. ");
INSERT INTO gaw_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","Aria Jesus Nug oḏ meṯom. “Na onin aun?” Awa a nug aum. “Da onil amu, ‘Daup kuḏum,’” awa aum. Aḏinu? Ouḏi nau kuḏumnab nug oop̱a nona daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","Ouḏi nau ag Jesus amegp̱a, “Na aib ig lamigp̱e, Satan amu nuhiḵud daup daaṯebp̱a eḏut gomut,” aon ii daye daye unuqidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","Amu bo ameg naḏi laa qauko nakok amup̱a e lanana daap̱ig amunu ouḏi nau ag Jesus unuqidna ap̱ig. “Na hep̱e, ig bo umu oolagp̱a gotu!” aon ap̱ig. Aon aeg aaḵu Jesus Nug he gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","Ouḏi nau ag danab amu uuidna, ag gona bo oolagp̱a noeg amu bo ag oolna, huana gona, aben oola noakp̱a nona, le amegp̱a le lana mauhp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","Amu bo gumak danab ag keeke beum, amu anidna, ag oolna gona, ag keeke amunu ab oḵaip̱a amu nuhig wan taliliak ele amup̱a keeke aḏi anidp̱ig amu aeg doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","Maṯieg doona amu danab ah ag keeke amu anidḵulagnu Jesus gumidna gona, ag danab ouḏi nau uuidp̱ig amu anidp̱ig. Nug lamen taḵa, dab mak ena ele Jesus baegp̱a heḏep na dayeye anidp̱ig. Danab ah ag anam anidna, ag baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","Danab ag anidp̱ig ele amu, ag Jesus Nug danab ouḏi nau ele amu he ena dayom, ag keeke amu ohnu madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","Maṯieg, laih Gerasa, ap̱an danab oh ag Jesus uuaṯa gokunu unuqidp̱ig. Aḏinu? Ag huan baḏap̱ig. Aeg aaḵu Jesus Nug ub aṯan ta, Nug eḏua uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","Danab ouḏi nau uuidp̱ig ele nug Jesus ele goḵulahnu ii daye daye oḏ meṯom. Nug anam aum amge Jesus Nug he, eḏua ugeḵe, amegp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","“Na eḏun, na ap̱anp̱a gona, Kayak keeke oh nahip̱a heum amu na mehuqe!” awa aum. A amu danab amu uḵa, ab oḵai nuhigp̱a ta, danab ah oh amelagp̱a nuhigp̱a Jesus keeke oh heum amu mehuqom. ");
INSERT INTO gaw_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","Jesus Nug Galelia le ameg heqo laihnu eḏua uḏieye, danab ah oh ag Nug uḏiom amunu gamalag ahom. Aḏinu? Ag oh Nug ameg mena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","Jesus uḏieye amu danab laa onig Jairas, nug Juda dilag nai doyak lag gumak danab laa, nug uḏia, Jesus noobp̱a dup noa, iḵi wan ye, Jesus Nug laugp̱a goḵununab unuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","Aḏinu? Nug aḏeg laip̱u, maḏ 12 ele, nug mauhḵunu heum. A amu Jesus Nug ugeḵe, danab ah kuḏumnab ag talilidna daaegeg gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","Uḵaegeg, ah laa ele ap̱a dayom amu nug kalam qak oḏe maḏ tuelp haen oh anidṯom. Iiṯa ii meṯom. Nug dokta gumaṯa uḵe babaiṯegeg, nug men doḏo nuhig iiṯa meum amge nug eḏua ena ii dayom. ");
INSERT INTO gaw_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","Aria ah amu nug Jesus dimugp̱a doa, ep̱eg bahia, Jesusnu lamen daug nakok aḏom. Aḏe amu pahanab oḏe amu iiṯa meum. ");
INSERT INTO gaw_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","Iiṯa me amu Jesus Nug dayaya, oḏ meum. “Aun da aḏailom?” awa aum. Oḏ me amu ag ap̱ig. “Da iiṯa, da iiṯa,” aon ap̱ig. Aon aeg, Petrus nug aum. “Ihinig oḵai, danab ah ameg naḏi talilidna daaṯeb amunu aḏinu na, ‘Aun da aḏailom?’ aon aṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","Amge Jesus Nug aum. “Da dooṯem, laip̱u laa ep̱egp̱a da aḏaele, g̱agaṯag laa uuiḏa uḵom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","Aria ah amu nug doya, loḵumḵunu elele iiṯa amunu nug baḏa hahaḏaḏa, danab ah oh noolagp̱a Jesus baegp̱a gateg qaun wa, nug aḏinu ep̱eg bahia Jesus aḏe, laip̱un oḏe nuhig iiṯa meum ele amunu aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","Amu Jesus Nug ah amu amegp̱a aum. “O aḏel, na ootp̱a genab doome amunu na eḏun ena daaṯem. Na maḏoḏ ele uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","Jesus Nug nai amu maṯiaya dayeye, danab laa nug iḵi danab Jarius, amu nug laugp̱anu nai awa uḏia, Jairas amegp̱a aum. “Na aḏen mauhomde amunu na ip̱uniṯak danab imu aib uḏat meṯame,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","A amu Jesus Nug nai amu doya, Nug Jairas amegp̱a aum. “Na aib baḏame. Iiṯa, na ootp̱a genab doye! Na anam hep̱e amu na aḏen nug eḏua bau daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","53","Aria Jesus Nug iḵi danab amu laugp̱a uḵa, Nug Petrus, Johanes, Jakobus, nid mameg anig ele aaḵuib diiaṯe, Nug ele lag oop̱a nop̱ig. Laa oh ag lag oop̱a noḵulagnu aib aum. Nug lag oop̱a noa, Nug danab ah ag nid amunu oolag doye, mahinna, qanak ele henan daaegeg anaṯa, Jesus Nug ag amelagp̱a aum. “Ag aib gaap̱ig! Nug ii mauhom, nug niiṯe,” awa aum. Jesus Nug anam a amu ag imidp̱ig. Aḏinu? Ag doop̱ig, nid ahin nug mauhom. ");
INSERT INTO gaw_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","Ag anam heegeg, Jesus Nug ag lamaṯowa, Nug nid ahin amu ep̱egp̱a aḏa aum. “Nid ahin, na ahe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","Amu nid ahin amu nuhig ouḏi eḏua uḏie, laip̱un bau eḏua ahom. Ahe, Jesus Nug ag e medap̱eg laḵunu amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","Nid ahin mameg anig ele a anam anidya, a oṯaiya, dab mak kuḏumnab aopiḏ amu Jesus Nug g̱agaṯag amelahp̱a aum. “A keeke imunu danab laa amegp̱a aib apiḏ,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","Jesus Nug ip̱uniṯak awak danab tuelp onilagp̱a e uḏieg, Nug ag ouḏi nau lamadnana, oḏe diigdiignu ele hep̱eg ena daaglagnu g̱agaṯag maṯom. ");
INSERT INTO gaw_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","Nug he, ag goḵulagnu daaegeg, amelagp̱a aum. “Ag gona, Kayaknu ḏo maḏoḏnu nai mehuqnana, danab oḏe ele hep̱eg ena dayeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","Nug anam anana, Nug nai tuḏiṯa amelagp̱a aum. “Ag oiyaknu keeke, hoḵat, baṯam, e, men doḏo ele, aon aib oip̱ig. Aria ag lamen aḏit ele aib aon gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","Ag lag laap̱a tena amu agup̱aib daanna, ap̱a uḏat malona aria ahan uḵeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","Nug anam anana amu Nug nai tuḏiṯa aum. “Ge danab ag diiadna laulagp̱a ii maadp̱eg amu ag ab amu uun gonana, ab amup̱an danab ag eheḏ hep̱ig dooglagnu ag gap̱ud baelag gaḏap̱anu qeqalp̱eg neeb, ag ab amu uun uḵeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","Anam a amu ip̱uniṯak awak danab ag ahan, ab ab gona, Nai Ena amu mehuqnana, oḏe danab atu ohp̱anu ele heeg, ena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","Aria, Herodes Antipas nug Galelia wan guma dayeye, Jesus Nug uḏat heehe, Herodes Antipas nug uḏat oḵam oh heum amunu doya, nug dab mak kuḏum awom. Aḏinu? Danab laala ag, “Herodes nug Layaṯak Johanes baag otaḏom amge Layaṯak Johanes nug eḏua hibaiṯa oiṯe,” aegeg doyom. ");
INSERT INTO gaw_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","Ag anam aegeg am laala ag, “Nug am Elias, eḏua hibaiṯom,” aegeg, laala ag, “Nug propet anuḵanu laa eḏua hibaiṯom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","Ag anam aeg am Herodes anam doya, nug aum. “Genab da Layaṯak Johanes baag otaḏmi amge danab umu Nug am aun, ag nuhignu nai amu unam aṯeb?” awa aum. Awa anana nug Jesus anidḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","Aria deḏ laa Jesusnu ip̱uniṯak awak danab tuelp ag eḏun uḏin, Jesus amegp̱a, ag gona keeke oh hep̱ig amunu aeg doya, Nug aha omalaṯe, ab laa Betsaida, amup̱a aḵa gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","Uḵaeg dimp̱a, danab ah ameg naḏi ag amu doon, ag dim lamidna gona, gumidna waeg, Jesus Nug ag uḏip̱ig amunu gamag ahe, Nug Kayaknu ḏo maḏoḏnu nai amelagp̱a mehuqaqa, oḏe danab amu he ena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","Deḏ amu tueb, aam noono, nuhiḵud ip̱uniṯak awak danab tuelp ag Jesus gumidna dona ap̱ig. “Na ap̱e, danab ah ag ab ab gona, danab laulagp̱a ele gona, ag e aon lawona niiglag. Aḏinu? Aben ig daaṯem imup̱a amu danab ag ii daaṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","Aon ap̱ig amge Jesus Nug amelagp̱a aum. “Ag e madap̱eg laig!” awa aum. A amu ag ap̱ig. “Ig e kuḏum iiṯa. Bret kunum tanig ele, kakai aḏit eleib daaṯe. Am na oot aṯem daaṯe? Ig gota, danab ah ameg imu oh dilag e daden meḵunigte?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","Danab ag ele ap̱a daap̱ig amu 5000 anam. Ag anam aeg amu Jesus Nug nuhiḵud ip̱uniṯak awak danab tuelp amelagp̱a aum. “Ag danab ah hep̱eg, ameg laip̱u laip̱u eb qak anen anen pipti keeke, anam dayeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","Amu Jesus aum bia ip̱uniṯak awak danab ag anam heegeg, danab ah ag daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","Daaegeg, Jesus Nug bret tanig ele, kakai aḏit amu ele diia aḏa, hab aṯan neeḵaḵa unuqiṯom. Unuqiṯowa, pane ne, ip̱uniṯak awak danab ag aon panin, danab ah maṯaglagnu maṯe, ag panieg uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","Ag oh e amu laeg, oolag diṯie, e big dayom amu ip̱uniṯak awak danab ag aona, kaleg tuelp inaeg am beum. ");
INSERT INTO gaw_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","Deḏ laa Jesus Nug nuḵa unuqiṯaṯa dayeye, nuhiḵud ip̱uniṯak awak danab ag gumidna uḵaeg, nug oḏ maṯa aum. “Danab ag dahilnu amu aḏi aṯeb?” awa aum? ");
INSERT INTO gaw_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","A amu ag ap̱ig. “Laa ag nahipnu, ‘Layaṯak Johanes,’ aṯeb amge laa ag, ‘Nug am Elias,’ aṯeb. Aria laa ag nahipnu, ‘Nug am Kayaknu propet anuḵanu laa eḏua hibaiṯom,’ aon aṯeb,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","Nuhig ip̱uniṯak awak danab ag anam aeg amu Jesus eḏua ag oḏ maṯom. “Anam aaḵu amge ag aḵa amu dahilnu aḏi aon aṯeb?” awa aum. A amu Petrus nug aum. “Na amu Kristus, Kayak Nug na tituaniṯom. Kayak Nug na Israel ehanadḵutnu aum!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","Petrus nug anam a amu Jesus Nug ag danab laa amelagp̱a nai amu maṯimnanu ḏo g̱agaṯag meum. ");
INSERT INTO gaw_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","Jesus Nug anam anana, Nug nai amu tuḏiṯa aum. “Danab Beḵalag da, geha dimp̱a Juda iḵi danab, mana meṯak danab oḵai amu ḏo mehuqak danab ele ag da di meḏan, guiṯak meḏan, iup̱eg mauhḵul amge dimp̱a deḏ ewamp̱a Kayak heeb, da eḏuen hip̱aidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","Anam anana amu Nug nuhiḵud ip̱uniṯak awak danab oh amelagp̱a aum. “Laa nug da dim lamiḏḵunu oo dayeb amu nug nuhig dab mak dim lamidḵunu dab ii mema, nug nuhig ad emaitak deḏ oh mawa, da dim lamiḏaḏ! ");
INSERT INTO gaw_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","Aria danab laa nug wanp̱anu bau daaḵunu dab mak anuqak aoṯe amu nug bauklel hanhannu ii aoma amge laa nug dahilnu anuqak dooṯe, nug wanp̱an bau dayak amunu anuqak ii dooṯe amu, nug am bauklel hanhannu aoḵu. ");
INSERT INTO gaw_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","Danab nug wanp̱anu keeke oh aoṯe amge nug bau dayak hanhannu ii aoṯe amu keeke amu nug aṯem ehanidḵu? Kayak Nug danab amu di medaḵu amu nuhig keeke am aṯem ehanidḵu? ");
INSERT INTO gaw_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","Amu danab nug dahilnu am dahil nainu ele uḏa neeb amu dimp̱a da dahil g̱agaṯag, Kayaknu g̱agaṯag amu nuhiḵud engel dilag g̱agaṯag elep̱a eḏue uḏiḵul, haen amup̱a danab amunu da ele uḏal neḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","Jesus Nug anam anana, Nug nai baula tuḏiṯa aum. “Da genab aṯem, danab laala gemu ip̱a hip̱aidna daaṯeb ele amu, ag paha ii mauhmana. Iiṯa. Tatam ag Kayaknu ḏo maḏoḏ amu dig ma beeb anidna, mauhḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","Amu Jesus Nug nai amu maṯie, dimp̱a deḏ eblaih ewam keeke anam uue amu Jesus Nug unuqidḵunu, Petrus, Johanes amu Jakobus ele omalaṯe, qaukop̱a tep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","Tena unuqiṯaṯa dayeye amu Nug iḏu eḏuom. Nuhig lamen amu eḏua, haḵabnab diṯiag apinak bia dayom. ");
INSERT INTO gaw_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","Jesus Nug anam dayeye, danab aḏit laa, Moses Elias ele, a tulai doeh, Nug ele nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","Danab aḏit a Kayaknu amahlak ele beeh, Jesus Nug Jerusalem ap̱a Kayak uḏat meṯom amu hewowa, wan imu uua goḵu amunu nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","Jesus Nug Moses Elias ele nai maṯiegeg am Petrus nug laikuḏ ele ag amelag ug meṯe, niiglagnu hep̱ig amge ag niin autna ii aop̱ig. Iiṯa. Ag anam daaeg uḵe, amelag eḏua obate, ag Jesus binag oḵai ele, amu danab aḏit a Jesus ele hip̱aidna daaegeg, am anadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","Moses Elias ele a Jesus uuiṯeheh, Petrus nug Jesus amegp̱a aum. “Ip̱uniṯak danab, ig aben imup̱a daagnignu am enanag amunu na ap̱e, ig peh ewam buugnig, nahip laip̱u, Mosesnu laip̱u, Eliasnu laip̱u ele,” awa aum. Petrus nug nai amu diig tutuḵu ii doyaya, nug nai aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","Petrus nug anam aawo amu lombig laa tonaṯe, ag baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","Baḏaegeg, lombig oop̱anu baag laa inam a doop̱ig. “Imu am nid dahil, da nuhignu ool huanak mauhṯe. Ag nuhig nai doyeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","Baag anam a doyona amu ag Jesus nuḵa dayeye anidna, ag aḵa aḵa dab mep̱ig. Ag keeke anidp̱ig amu ag amunu danab laala amelagp̱a haen amup̱a ii ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","Amu deḏ amu uue, wagḏe deḏ amup̱a ag qaukop̱anu noeg, danab ah ameg naḏi ag uḏin Jesus uḏa tep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","Amu danab ah ameg naḏi amu oolagp̱a danab laa nug ewa aum. “Ip̱uniṯak danab, da na unuqidṯem. Dahil nid imu anṯe, da nid dahil laip̱u iiḵuib, ");
INSERT INTO gaw_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","amu ouḏi nau laa nug haen kuḏumnab aḏeḏe, eheḏ eewo, ouḏi nau nug he, huana hahaḏeḏe, hipaḏu neene, ouḏi nau nug he, beḏu nauha auta awe amu paha ii uuidṯe. ");
INSERT INTO gaw_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","Am da nahipad ip̱uniṯak awak danab ag ouḏi nau lamidḵulagnu unuqadmi amge ag elele iiṯa!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","Anam a amu Jesus oḏep̱a awa aum. “Ag oolagp̱a genab doyak iiṯa. Ag nai genab amu kobol tutuḵu ele ii heṯeb. Da ag ele haen elab daamut amge ag dahilnu oolagp̱a genab ii dooṯeb amunu da ool ug ele. Ag haen ganeb ag dahilnu oolagp̱a genab dooglag? Na nid nahip omalna do!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","Nug anam a amu nug nid amu awa, Jesus top̱a doodo, ouḏi nau am nid buḏie, na qa, wanp̱a hahaḏom. Nug anam heum amge Jesus Nug ouḏi nau amegp̱a, “Na uḵe!” awa a, nid ena daye, awa eḏua, mameg meṯom. ");
INSERT INTO gaw_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","Jesus Nug anam he, danab ah ag Kayaknu g̱agaṯag anidna amu ag oṯaip̱ig. Ag keeke oh heum amunu dab mak kuḏum aoegeg, Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","“Ag nai imu daulagp̱a tutuḵunab doyeg! Dimp̱a haen elab iiṯa, laa ag Danab Beḵalag da, ag da awiḏna, danab ep̱elagp̱a meḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","Nug anam aum amge ag nai amu ii doop̱ig, nai amunu diig am ag oolagp̱a loḵumak dayom amunu ag tutuḵu ii doop̱ig. Ag ii doop̱ig amge ag nai amunu Jesus oḏ meṯaglagnu baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","Am haen laa ip̱uniṯak awak danab ag oolagp̱a aun nug oḵai daaṯe, dab mak amu be, ag amunu aeg ona aeg doum. ");
INSERT INTO gaw_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","Amu Jesus Nug dab mak amu ag oolagp̱a dayeye doyom amunu Nug nid nakok laa awa do, Nug guguiṯa heqo laih me, hip̱aidya daaiya, ");
INSERT INTO gaw_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","Nug ag amelagp̱a aum. “Danab nug da onilnu nid nakok imu oo meṯa humidṯe amu nug da oo meḏa, humiḏṯe. Danab nug da oo meḏa humiḏṯe amu nug Laa, Nug he da uḏimi ele amu, Nug oo meṯa humidṯe. Ag oh oolagp̱anu danab nug nakoknab daaṯe amu nug amu anuqak,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","Jesus Nug anam a amu Johanes nug aum. “Ip̱uniṯak danab, ig danab laa nug am na oninp̱a ouḏi nau lamaṯe anidmut amge nug am ig dim lamiḵe ii oiṯem amunu ig nug ouḏi nau lamadmanu ḏo memut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","Nug anam aum amge Jesus Nug amegp̱a aum. “Aun nug am ahilag kekeḏ iiṯa, nug am ag lailag amunu ag nuhig uḏat amu aib oḵulp̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","Amu Jesus Nug eḏua Mameg top̱a goḵunu haen miag do doyaya, Nug Jerusalem goḵunu dab mak g̱agaṯag awom. ");
INSERT INTO gaw_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","Dab mak amu awom amunu Nug danab laala he, ag nai aon, anuqna gona, ag Samaria dilag ab laap̱a tena, ap̱a ag nuhig keeke bap̱aidḵulagnu hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","Amge danab ab amup̱anu ag Jesus Nug ag laulagp̱a daaḵunu amu uup̱ig. Aḏinu? Ag doop̱ig, Nug Jerusalem teḵunu g̱agaṯag dab meum. ");
INSERT INTO gaw_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","Ag anam heeg, ip̱uniṯak awak danab aḏit, Jakobus Johanes ele, a anam anidya a apiḏ. “Naḏi, i ap̱uḏ hab aṯannu ab aḏu na, danab amu ewadḵunu oot daaṯete?” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","Anam apiḏ amge Jesus Nug eḏua, a daulah batom. ");
INSERT INTO gaw_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","Daulah bate amu ag ahan, ab laap̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","Ag gona ibp̱a uḵaegeg, danab laa Jesus amegp̱a aum. “Na adep adep goḵut amu da na dim lamidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","Anam a amu Jesus Nug amegp̱a aum. “Doḏ laa onig poks, biun bia, ag wan oḏep̱a niiaknu aben ele, ai ag ele teḏ ele amge Danab Beḵalag da amu da niiaknu aben laa iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","Anam anana, Nug danab laa amegp̱a aum. “Na dona, da dim lamiḏe,” awa aum amge danab amu nug aum. “Naḏi na ap̱e, da tatam uḵen, mama boomoya, da eḏuen na dim lamidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","Anam a amu Jesus Nug oḏep̱a awa aum. “Uup̱e! Mauhak aḏi, ag dahil uḏat haknu dab ii meṯeb ele amu, ag mauhak lailḵad boomadḵulag amge na gona, Kayaknu ḏo maḏoḏnu nai mehuqe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","Anam a amu danab laa nug aum. “O Naḏi, da na dim lamidḵul amge na ap̱e, da tatam gop̱i, baeladp̱a ele sigan mewota, da eḏuen dim lamidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","Nug anam aum amge Jesus Nug amegp̱a aum. “Aun nug dahilnu oo aḏit ele amu nug Kayaknu ḏo maḏoḏ oop̱a daaḵunu ele iiṯa.” ");
INSERT INTO gaw_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","Amu dimp̱a Naḏi Nug danab 72 laa, ag aḏit aḏit anuqna, ab oḵai nakok ele ohp̱a, Nug goḵunu dab meum ele, amup̱a gop̱eg, dimp̱a Nug nuḵa ele amup̱a dim lamaṯa goḵunu otiaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","Nug otiaṯa, Nug amelagp̱a aum. “Danab ah kuḏumnab ag dahilnu oolagp̱a genab ii dooṯeb amu, ag am daṯanu e bia. E amu oh oḏua malom amge uḏat danab kuḏum iiṯa amunu ag dad Mameg unuqidp̱eg, nug uḏat danab baula maaṯeb gona, e meu aḵan qag meḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","Nug anam anana amu Nug nai baula tuḏiṯa aum. “Ag aaḵude uḵeg! Da ag maaṯi, ag sipsip naḵud wolp oolagp̱a goṯeb bia goṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","Ag men doḏo inaknu hogot amu baṯam, baelag gaḏa ele amu aib aop̱ig. Ag gonana, dab mak laa aona, uḏat imu aib uup̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","Amu ag lag laa oop̱a nona aria ag tatam inam aḵulag. ‘Danab ah lag imup̱anu ag oolag maḏoḏ ele daaglagnu oonig daaṯe,’ aon aig! ");
INSERT INTO gaw_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","Amu danab laa oo maḏoḏ ele lag amup̱a dayeb amu aria nug nai amu doya gamag ahebeb awa humadḵu. Amge danab laa nug anam ele iiṯa amu aria nug nai amu doya ii humadma. ");
INSERT INTO gaw_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","Ag lag laip̱u humadp̱ig ele, amup̱aib daanna, lanaknu keeke, e le ele madap̱eg laig! Aḏinu? Uḏat danab nug nuhig uḏatnu, nob aaḵu aoṯe. Ag lag laala ohp̱a aib daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","Am ag gona, ab oḵai laap̱a nop̱eg, ag diiadna, laulagp̱a gona, e panin madap̱eg amu ag laig! ");
INSERT INTO gaw_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","Ab amup̱an oḏe danab amu ag hep̱eg, ena daap̱eg, ag amelagp̱a, ‘Kayaknu ḏo maḏoḏ ahilagp̱a miag doum,’ aon aig! ");
INSERT INTO gaw_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","Amge ag gona, ab oḵai laap̱a nop̱eg, ap̱anu danab ag diiadna laulagp̱a ii gop̱eg amu ag gona, ab oḵai amunu ibp̱a daanna ");
INSERT INTO gaw_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ag inam aon aeg! ‘Ahilag abnu gap̱ud, ig baenigp̱a teum daaṯe amu, ag eheḏ hep̱ig amu ip̱uanadḵunignu, ig gap̱ud amu iiḵu op̱iut neṯe amge ag imu dab mena autna aweg! Kayaknu ḏo maḏoḏ miag doum!’ aon aig! ");
INSERT INTO gaw_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","Anam aaḵu amu da ag amelagp̱a aṯem. Wan haen maleb, ab amu nug Sodom nob awom amu eḏiṯak aoḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","“O gadon Korasin, o gadon Betsaida ele! Da ahilah danab oolagp̱a oiyeye, kobol diigdiig danab heḵunu elele iiṯa hemi amu danab laa nug Taia Saidon ele, danab ap̱a daaṯeb ag am iiṯa aḏi danab amu, nug danab amu ahilagp̱a kobol amubia helo amu Taia Saidon ele dilah danab ag anuḵanab lamen nau heḏiag ele taḵan, uhuḏp̱a daanna, ag oolag eḏulo. ");
INSERT INTO gaw_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","Amunu da ag amelagp̱a aṯem, epeḏiak haenp̱a amu Taia Saidon ele dilah danab ah, ag ug aoglag amge ag danab ah ag Korasin Betsaida ele daaṯeb amu, ag amu dilag ug eḏiṯak, ug oḵainab aoglag. ");
INSERT INTO gaw_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","Amu Kapenaum na onin oḵai, laa oh eḏaṯak, aoḵut-te? Iiṯa! Geha na padal meḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","Jesus Nug anam anana, Nug ip̱uniṯak awak danab amelagp̱a aum. “Danab nug ahilag nai dooṯe amu nug dahil nai dooṯe. Am danab nug ag di madaṯe amu nug da di meḏaṯe. Danab nug da di meḏaṯe, nug laa Nug he, da uḏimi ele amu Nug di medṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","Dimp̱a danab 72 ag gamalag huan ahehe, eḏun uḏin ap̱ig. “Naḏi, ig na onin diiutut, ouḏi nau ag ihinig nai dim lamidp̱ig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","Anam aeg am Jesus Nug ag amelagp̱a aum. “Da Satan nug amemḏi bia hab aṯannu na qeeqe anidmi. ");
INSERT INTO gaw_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","Amu doyeg! Da ag g̱agaṯag maṯai, ag mat, apiap ele tap̱adna, kekeḏnu g̱agaṯag amu oh eḏadḵulagnu elele daaṯeb. Keeke laip̱u laa heeb, ag ii nauhmana. ");
INSERT INTO gaw_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","Amge ouḏi nau ag nai ahilag dim lamidṯeb, amunu ag oolag aib gamag ahom! Iiṯa. Kayak Nug ag onilag hab aṯan yom amunu ag gamalag ahaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","Haen amup̱a Kayak Ouḏi Nug he, Jesus oo gamag ahe, Nug aum. “O Mame, na hab wan ele dilah Oḵai daaṯem amu, na danab dab mak ele, doyak danab ele, na amu dilagp̱a keeke imu loḵumna, nid naunau ip̱uanadme amunu da na onin humaṯem. Yo Mame, na nahip dab makp̱a amu nahip doyakp̱a ele heme,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","Jesus Nug anam anana amu Nug nai baula tuḏiṯa aum. “Da Mamel Nug keeke oh da ep̱elp̱a meum. Amu danab laip̱u laa nug Kayak Beḵa ii dooṯe, Kayak Nug nuḵaib dooṯe. Am danab laip̱u laa nug da Mamel ele ii dooṯe. Nug Beḵa daib Nug dooṯem amu danab, da ag da Mamel ip̱uanadṯem ele, ag da Mamel dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","Aria Jesus Nug nai amu oh maṯia mala, Nug eḏua, ip̱uniṯak awak danab aaḵuib amelagp̱a aum. “Ag enanag daaṯeb. Ag itiṯak aop̱ig daaṯeb. Aḏinu? Ag da amu dahil hak amu dahil nai ele iiḵu anidṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","Da ag amelagp̱a aṯem. Anuḵa propet kuḏum, king ele ag keeke gemu ag anidṯeb amu anidḵulagnu oolag dayom amge ag ii anidp̱ig. Amu nai gemu ag dooṯeb amu ag dooglagnu oolag dayom amge ag ii doop̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","Aria deḏ laa ḏo doyak danab laip̱u laa aha, nug Jesus eheḏ ab anidḵunu oḏ ma aum. “Ip̱uniṯak danab, da aṯem hein bauklel hanhan ena dayaknu aoḵul?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","Anam a amu Jesus Nug amegp̱a aum. “Ḏop̱a, nai yak amunu aḏi daaṯe? Na ap̱a aḏi eb qeṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","Jesus anam a, Nug oḏep̱a awa aum. “Naḏi Nug am Kayak nahip amunu na nuhignu oot mauhaḏ! Na ootp̱a, na ouḏinp̱a, nahip g̱agaṯag ohp̱a amu nahip dab mak ohp̱a ele anam he! Amu laa amu na naḵa nahipnu oot mauhṯe, amubia nahip mudip̱anu dilag ele oot mauhaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","Awa a amu Jesus Nug amegp̱a aum. “Na tutuḵu ame, na anam henana, na bauklel hanhannu aoḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","Nug anam aum amge ḏo doyak danab nug nuḵa onig ena daaḵunu ha, nug Jesus oḏ meṯa aum. “Am dahil mudip̱an danab am aun?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","Awa a aria Jesus Nug oḏep̱a awa aum. “Danab laa Jerusalemnu aha, nug Jeriko goḵunu noum. Noono, yab danab ag nug ibp̱a anidna, ag nuhig keeke amu oh aḏidna, ag nug eheḏ maḵuḏp̱ig. Ag maḵuḏeg, ibp̱a anam mauhḵunu ha niieye, ag gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","Haen amup̱a Juda dilag mana meṯak danab laa nug ele goḵunu ib amu noum. Am nug danab amu andaṯa, nug qe eḏiṯa, ib daug aiḏa, wana uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","Ugeḵe, Lewi buḏup̱anu laa ele nug ib amuib dim lamiṯa uḵa, nug danab amu andaṯa, qe eḏiṯa, ib daug aiḏa, wana uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","Amge Samaria danab laa, Samaria Israel ele ag layam ena iiṯa amu, nug ib amup̱a uḏia, danab amu gumiṯa doa, danab amu anṯa, nug oo doyom. ");
INSERT INTO gaw_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","Nug oo doye, gumiṯa wana, nug goḏen wain ele awa goḵaḏe, danab amu ihiudp̱a no, itom. Itowa nug danab amu huma awa, nuhig donki aṯan ma, awa uḵa, ḏo lag amup̱a ma nug gumom. ");
INSERT INTO gaw_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","Gume uḵe, deḏ amu uue, wagḏe, deḏ amup̱a nug men doḏo deḏ aḏitnu uḏatnu nob, 10 kina bia awa, ḏo lag mameg amu medaṯa, amegp̱a aum. “Na men doḏo imup̱a danab imu dab meṯan autna awe! Na danab imu ehanidp̱e, men doḏo imu iiṯa meeb, nug ena daaḵunu, na keeke laa men doḏo nahip̱a daden meḵut dayeb amu aria dimp̱a da eḏue uḏien amu nob na medaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","Jesus Nug anam awowa, Nug eḏua danab tatam nug amunu oḏ meṯom ele amu, nug oḏ meṯa aum. “Nahip dab mak amu aṯem daaṯe? Danab ewam amu oolagp̱a aun nug danab yab danab maḵuḏp̱ig ele amu, nuhig mudip̱an bia heum?” awa oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","Anam a amu ḏonu doyak danab nug aum. “Danab nug oo gai iiṯa doya ehaniṯom ele, amu,” awa aum. A amu Jesus Nug amegp̱a aum. “Na gona amu na ele anam he!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","Jesus Nug nuhiḵud ip̱uniṯak awak danab ele ag gonana amu Nug ab nakok laap̱a no, ah laa onig Mata, nug omalaṯa, laugp̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","Mata nug maḵeg amu onig Maria. Jesus Nug laḵa te amu Maria nug Naḏi gumiṯa doa, baegp̱a heḏep na dayaya, Jesus nai maṯiom ele amu, nug doyom. ");
INSERT INTO gaw_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","Amge Mata nug e hak uḏatib ha, hik qe, dab mak nuhig ib piḏe piḏe dayom amunu Mata nug Jesus gumiṯa wana aum. “Naḏi, da maḵel nug da ii ehaniḏṯe, da daḵaib e hak uḏat heṯem. Na amunu dab iite meṯem? Na amegp̱a ap̱e doa, da ehaniḏaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","Amge Naḏi Nug oḏep̱a awa aum. “Mata, Mata, na dab mak kuḏum ootp̱a dayeye, na keeke kuḏumnu oṯaiṯem ");
INSERT INTO gaw_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","amge keeke laip̱uib am oḵai daaṯe am Maria nug keeke ena amu tituanom. Keeke ena nuhig amu ig aḏidta ii aomta,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","Haen laa Jesus Nug aben laap̱a unuqiṯaṯa dayom. Unuqiṯa male, dimp̱a nuhig ip̱uniṯak awak danab laa amegp̱a aum. “Naḏi, Layaṯak Johanes nug anuḵa nuhiḵud ip̱uniṯak awak danab ip̱uanaṯom bia, na ig unuqidḵunignu ip̱uniḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","A amu Jesus amelagp̱a aum. “Ag unuqidna amu inam aig! Mame, na hep̱e, danab oh ag na onin, nug onilag laa oh eḏadṯe doon, aṯannab human dab menan oiyeg! Na hep̱e, ḏo maḏoḏ nahip wan imup̱a dayaḏ! ");
INSERT INTO gaw_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","Ig e megṯem ele amu gemunu ele meḵe! ");
INSERT INTO gaw_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","Laa hip̱unin megṯeb, ig uhuqta madaṯem amubia na hip̱unin ihinig uhuqna meḵe! Na ip̱un ena, ig nau heḵunignu eeḏak iiṯap̱a omaigp̱e gotu!” ");
INSERT INTO gaw_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","6","Jesus Nug anam anana amu Nug baula ip̱uniṯak awak danab amelagp̱a aum. “Ag oolagp̱anu laa nug tuqan tugmag uḵa, layag amegp̱a, ‘Lai, da layal laa oiya oiya uḏia, da gumiḏa be, da e laa nug medaḵulnu amu iiṯa amunu na bret kunum ewam meḏe!’ awa aḵu dayeb ");
INSERT INTO gaw_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","amu nug layag, nug lag oop̱a daaṯe amu, nug oḏep̱a awa, inam aḵutai. ‘Na da uḏat aib meḏame. Od manak, nid naunau dahilad da ele abenp̱a niiṯem. Da ahe na keeke medaḵulnu amu elele iiṯa,’ awa aḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","Anam aaḵu amu da ag amelagp̱a aṯem. Lag mameg nug danab amu layag, nug amu dab ma aha, keeke ii medaḵutai amge nug layag dimiṯim dayaya, tap̱aḏa, ge iiṯa eeb, bahi yeeb, nug aha, nug keeke oh iiṯanu aum amu medaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","Anam daaḵu amunu da ag amelagp̱a aṯem. Ag Kayak unuqidp̱eg, Nug ag keeke madaḵu. Ag keeke maṯina amu anidḵulag. Ag od qeqalp̱eg, Kayak Nug ahilag od matulḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","Danab nug Kayak unuqidṯe amu nug aoṯe. Danab nug keeke madiṯe amu nug anidṯe. Danab nug od qeqalṯe amu Kayak Nug od matulṯe. ");
INSERT INTO gaw_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","Am ag oolagp̱anu danab laa beḵa nug mameg kakai laa medaḵunu oḏ meṯeb amu mameg nug mat nau laa awa medaḵute? Iiṯa! ");
INSERT INTO gaw_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","Aria nid nug mameg matuk op̱a medaḵunu oḏ meṯeb amu mameg nug apiap awa medaḵute? Iiṯa! ");
INSERT INTO gaw_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","Anam amunu ag danab nau ag keeke ena ag nid ahilḵad madaṯeb amunu ig tutuḵu doognig, ig Mamenig, hab aṯan daaṯe, Nug danab ag Nug unuqidp̱eg amu Nug nuhig Ouḏi ag madaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","Aria haen laa Jesus Nug oḏetup danab laa, ouḏi nau laa nug he, danab amu nug oḏetup dayom amu, Jesus Nug danab amu anṯa, Nug ouḏi nau lamiṯe uḵe, aria danab oḏe op̱ate, nai maṯie, danab ah ag amu anidna, oṯaina, dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","Amge danab laala ag ap̱ig. “Nug Belsebub, ouḏi nau iḵilag ele amu, nuhig g̱agaṯagp̱a ouḏi nau lamadṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","Ag anam aeg amu danab laala ag Jesus aḏaglagnu ib anidḵulagnu, ag henana, ag Nug hab aṯannu ep̱onak keeke, danab haknu elele iiṯa, amu laa heeb anidḵulagnu ap̱ig ");
INSERT INTO gaw_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","amge Nug ahilag dab mak oh doya, Nug ag amelagp̱a aum. “Amu wan laip̱up̱an danab ag ahan, opatna, ameg aḏit bena, nug qeḵulag amu wan amu nug elele iiṯa, g̱agaṯag ii daama. Laa ele, ab iḵi laip̱up̱anu ag opatna, nug qeḵulag amu ab iḵi amu nug na qeḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","Amubia Satannu daup ag opatna, ameg aḏit bena, aḵa aḵa nug qeṯeb amu Satannu ḏo amu aṯem ha g̱agaṯag daaḵu? Ag dahilnu aṯeb. ‘Nug ouḏi lamadṯe amu, Nug Belsebub g̱agaṯagp̱a heṯe,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","Da genab Belsebub g̱agaṯagp̱a ouḏi nau lamadṯem dayeb amu, ag Juda, ag beḵalḵad laala ag uḏat imu ele heṯeb amu, ag ele anamib amge amu oh iiṯa amunu ag beḵalḵad, ag epeḏiadp̱eg, ag Juda ag eheḏ hak ahilag miag atiḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","Amge Kayak Nug da ehaniḏe, da ouḏi nau lamadṯem dayeb amu ag doyeg, Kayaknu ḏo maḏoḏ aaḵu ahilagp̱a uḏiom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","Jesus Nug anam anana amu Nug nai tuḏiṯa aum. “Amu danab g̱agaṯag laa nug ban aeg ele keeke aḏa, nug laug guma g̱agaṯag dayeb amu aria nuhig keeke oh amu ena daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","Amge danab g̱agaṯagnab laa, nug danab amu eḏiṯak, nug uḏieb, a nug qeya, aria nug keeke oh, ban qep elab ehaniṯom, amu aḏiṯa awa, nug keeke oh pania, danab laa madaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","Danab nug da ele layam iiṯa amu nug dahil kekeḏ. Danab laa nug da ele uḏat laip̱u ii heṯep amu nug Satan ehanidṯe. ");
INSERT INTO gaw_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","Haen ouḏi nau laa nug danab laa uuidṯe amu nug uḵa, atu taḏakp̱a nug aben laa anṯa, hik awa daaḵunu oiṯe. Oiya oiya, nuhig dayaknu aben ena laa ii anidṯe dayeb amu nug aṯe. ‘Da eḏuen, anuḵa daamip̱a uḵen daaḵul,’ awa aṯe. ");
INSERT INTO gaw_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","Anana amu nug uḵa, tatam dayom amup̱a ta, lag amu oo tatak, bala mak ele anṯa, ");
INSERT INTO gaw_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","aaḵu nug eḏua uḵa, ouḏi nau eblaih aḏit laa ele, ag ahilag g̱agaṯag, kobol nau heḵulagnu am nug eḏiṯak ele, nug amu diie, nug ele uḏiṯeb. Uḏin, ag lag amu oop̱a nona daaṯeb. Noeg amu danab amu nug anuḵa nau dayom amu gemu nug naunab daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","Jesus Nug nai amu maṯiom am haen amup̱a danab ah ameg naḏi daaegeg, ag oolagp̱anu ah laa ewa aum. “Ah na menuiṯa, nug na huh meṯom ele amu, nuhignu am ena,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","Amge Jesus Nug aum. “Anam iiṯa! Danab ag Kayak nai doon dim lamidṯeb ele amu, ahilagnu am ena,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","Danab ah kuḏum ag uḏin qag meegeg, Jesus Nug ag amelagp̱a inam aum. “Danab ah haen gemu imunu ag danab ah nau. Ag ep̱onak keeke danab heḵunu elele iiṯa laa anidḵulagnu aṯeb amge da laa ii hepa. Propet Jona nuhigp̱a aḏi beum aaḵuib ag ip̱uanadḵul. ");
INSERT INTO gaw_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","Jona nug Niniwe dilag ep̱onak keeke dayom amubia amu da gemu imun danab ah dilag ep̱onak keeke daaḵul. ");
INSERT INTO gaw_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","Am dimp̱a haen Kayak Nug danab ah epeḏiadḵu, haen amup̱a wan laap̱an ah oḵai, wan amuam yau uḏiṯep̱anu daaṯe, nug aha, danab ah haen gemunu dilag eheḏ hak amu miag atiḵu. Aḏinu? Nug wan batakp̱anu amge nug Solomonnu doyak ena amu nug dooḵunu Solomon gumiṯa uḏiom amge gemu laa Solomon eḏiṯak am iiḵu daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","Haen Kayak Nug danab ah epeḏiadḵu amu Niniwe danab ah ag ahan, danab ah haen gemunu dilag eheḏ hak amu miag atiglag. Aḏinu? Niniwe danab ag Kayak nai Jona oḏep̱a doona, ag oolag eḏuom amge gemu laa Jona eḏiṯak am iiḵu daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","Jesus Nug nai amu anana amu Nug nai baula tuḏiṯa aum. “Am danab ag lam amotna ii loḵumṯeb. Ag lag heḏḵud, oḏe amup̱a ii inaṯeb o tap̱iḏ oḵai waap̱a ii meṯeb. Iiṯa. Ag balal aṯan meeg, danab ag oop̱a nonana, amahlak anidṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","Na amen amu na beḏun laih laih oh amahlak madaṯe. Na amen nug ena dayeb amu na beḏun laih laih laa oh amu amahlak ele daaglag amge na amen am nau dayeb amu na beḏun laih laih laa oh amu gatatu manak oop̱a daaglag. ");
INSERT INTO gaw_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","Amunu na Kayak keekenu dab meḵutnu elele iiṯa daamnanu amu na dab me! ");
INSERT INTO gaw_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","Am na beḏun oh amahlak ele dayeb, na beḏun laih laa gatatu iiṯa amu aria na beḏun laih oh ag amahlak ele. Amuam lamnu amahlak amahalidṯe amubia,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","Jesus Nug nai amu maṯia male, ḏo gumak danab-Parasia laa nug laugp̱a e laḵulagnu onigp̱a e, Jesus Nug uḵa, laḵa ta, Nug balalp̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","Dayom amge ḏo gumak danab-Parasia amu nug Jesus tatam ahilag ḏo aṯe, kobol amup̱a Nug ep̱eg ii ihowa e laum amu anṯa, Nug dab mak kuḏum awom. ");
INSERT INTO gaw_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","Anam heum amge Jesus Nug amegp̱a aum. “Ag ḏo gumak danab-Parasia ag tap̱iḏ hai goḵoḏ ele beḏu dimiṯim amuib ihaṯeb. Amubia ag danab noolagp̱a ena bia oiṯeb amge ag oolagp̱a amu yab awak, eheḏ hak laa ohnu ele am am bak. ");
INSERT INTO gaw_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","Ag am dab mak ena iiṯa ele. Kayak keeke heum amu dimiṯimnuib ii heum, oop̱a ele heum ");
INSERT INTO gaw_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","amunu ag danab daḏek ehanadp̱eg, ii nauhp̱eg, ag oolag op̱ia awak ele daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","Amge o gadon ḏo gumak danab-Parasia ag dab meig! Ag qanai, lombu am keh laa oh ag opateg, ameg eblaih tanig ele neeg, ag laip̱u Kayak medaṯeb amge ag danab kobol tutuḵup̱a epeḏiaknu kobol, Kayaknu oo mauhak kobol ele amu ag eḏatp̱ig. Ag kobol amu anam henana, laala ele ii uuadlob amuib am tutuḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","O gadon ḏo gumak danab-Parasia, ag dab meig! Ag nai doyak lag oop̱a danab ah noolagp̱a anuqak daaglagnu amu qag mak abenp̱a danab ah ag humadḵulagnu amunuib heṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","O gadon, ag dab meig! Ag amu matmat wan oop̱a loḵumak dayeye, danab ii doonna, qaḏep̱a oiṯeb amubia daaṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","Jesus Nug anam a amu ḏonu doyak danab laa nug oḏep̱a awa aum. “Ip̱uniṯak danab, na nai ame amu na nai g̱agaṯagp̱a ig ele yaaigṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","A amu Jesus Nug aum. “O gadon ag ḏonu doyak danab, ag dab meig! Ag keeke ug ele danab ah qaḏelagp̱a meegeg, ag maoglagnu uḏat oḵai heṯeb amge ag aḵa amu ag ep̱elag doḏo laa ug amu maoglagnu nakok ii meeg oṯe. ");
INSERT INTO gaw_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","O gadon, ag dab meig! Ag alalḵad amu anuḵa ag Kayaknu propet aqaeg mauhp̱ig amge gemu ag ahilag matmat amu ag bala medṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","Ag kobol amup̱a ag alalḵad anuḵa hep̱ig, ag amunu oolag ena dayeye, ag danab ip̱uanadṯeb. Ag alalḵad ag Kayaknu propet aqaeg mauhp̱ig. Ag gemu daaṯeb amu, ag alalḵad bia, ag ele oolag ena iiṯa amunu ag ahilag uḏat tuḏidna, matmat ahilag bala medṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","Amu Kayak nuhig doyak enap̱a amunu Nug matu aum. ‘Da am dahil totol danab am propet ele maadp̱i, ahilagp̱a gop̱eg, ag danab amu laala lamadḵulag amu ag laala aqap̱eg mauhḵulag!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","Anuḵa ag Kayaknu propet aqaeg mauhegeg uḏie, gemu ele aqaeg mauhṯeb amu danab ah haen geha imunu ag hip̱unin amu ohnu ug anidḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","Amu dig mak Abel mauhe uḏie, Sakarias batak, ag nug qaḏab, lag gun ele gamagp̱a heeg mauhom ele amu, hip̱unin amu oh danab ah haen geha imunu ag qaḏelagp̱a daaḵu. Ao, da ag amelagp̱a aṯem. Hip̱uninnu nob nau amu oh danab ah haen gemu daaṯeb amu qaḏelagp̱a beḵu. ");
INSERT INTO gaw_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","O gadon, ag ḏonu doyak danab, ag dab meig! Ag doyak awaknu ki amu maweg uḵom. Od ag aḵa matulna ii nop̱ig amu ag danab ah ag noḵulagnu heṯeb ele amu, ag nomananu, ag ib oo nep̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","Amu Jesus Nug lag amu uua noa, dimiṯim no, am ḏo gumak danab-Parasia amu ḏo mehuqak danab ele ag gakaḏak bia doonna, ag ib diigdiigp̱a Jesus eheḏ heeb anidna aḏaglagnu hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","Nug nai laa ab, ag Nug dimug meḵulag amunu hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","Danab ah ameg tausen kuḏum ag qag mena, qata eṯan am laala ag aḵa aḵa nug baeg tap̱an daaegeg amu Jesus Nug tatam nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Ag ḏo gumak danab-Parasia dilag hak amunu dab meig! Da ahilag ham bup̱uak kobolnu aṯem. ");
INSERT INTO gaw_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","Amu keeke oh itak daaṯe am geha tula miag beḵu. Loḵumak nai ele geha danab ag dooglag. ");
INSERT INTO gaw_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","Amunu nai oh ag gatatup̱a madip̱ig am geha aam neeb, danab ah dooglag. Amu nai oh ag lag oop̱a otiptipp̱a madip̱ig amu geha lag aṯan hip̱aidna daanna mehuqp̱eg goḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","Jesus Nug nai amu anana amu Nug nai tuḏiṯa aum. “O lailad, da ag amelagp̱a imu aṯem. Ag laa ag beḏulagib hep̱eg nauhḵunu elele daaṯeb amu ag ahilagnu aib baḏadp̱ig. Ag anam henana, ag keeke laa heḵulagnu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","Amge aun ag baḏidḵulagnu amu da ag ip̱uanadḵul. Laa nug danab qeeb mauheb, buḏieb padal mak abenp̱a goḵunu g̱agaṯag ele amu, ag nuhignu baḏeg! Ao, da ag amelagp̱a aṯem, ag nuhignu baḏeg! ");
INSERT INTO gaw_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","Danab ag ai naunau tanig ele toea aḏitp̱a daden meṯeb amge Kayak Nug ai nakok laip̱unu am daug ii atiṯe. ");
INSERT INTO gaw_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","Nug ag iḵilag uḏug ele amu oh eb qeum amunu ag aib baḏap̱ig, ag ai naunau kuḏumnab amu ag eḏadp̱ig amunu Kayak Nug ahilagnu daug ii atima. ");
INSERT INTO gaw_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","Am da ag amelagp̱a aṯem. Danab laa nug da onil danab ah amelagp̱a mehuqḵu amu geha Danab Beḵalag da amu, da ele danab amu onig Kayaknu engel amelagp̱a mehuqḵul. ");
INSERT INTO gaw_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","Amge danab nug danab ah noolagp̱a da di meḏaṯe am geha da ele Kayaknu engel noolagp̱a danab amu di medaḵul. ");
INSERT INTO gaw_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","Am danab nug Danab Beḵalag da, da onilnu hamu doya, qeeb neḵunu heeb amu geha Kayak Nug hip̱unin amu uhuqa medaḵu. Amge danab nug Kayak Ouḏi dabiṯa, awa awa qeṯeb amu Kayak nug hip̱unin amu uhuqa ii meṯama. ");
INSERT INTO gaw_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","Amu laa ag ag diiadna, nai doyak laḵa o gabman noolagp̱a o epeḏiak danab noolagp̱a keeke gop̱eg amu ag aib dab mak inam aop̱ig. ‘Ig nai nob meta aḏi aḵunig?” o iiṯa, “Ig aḏi nai aḵunig?’ ");
INSERT INTO gaw_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","Aḏinu? Am aua amup̱aib geha Kayak Ouḏi Nug ag aḏi aḵulagnu amu ag ip̱uanaṯeb, ag amelagp̱a maṯiglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","Jesus Nug anam a amu danab laa danab ah ameg amu oolagp̱anu, nug amegp̱a aum. “Ip̱uniṯak danab, na da awal amegp̱a ap̱e, nug i mamenihnu keeke amu otia laih da meḏaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","Amge Jesus Nug amegp̱a aum. “Amu aṯemun? Aun nug da a epeḏiatḵulnu meiḏa amu ahilah keeke otiḵulnu ele meiḏom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","Anam anana, Nug amelagp̱a aum. “Ag dab mena, tutuḵu doyeg! Ag keeke kuḏum aoglagnu aib amelag qeum. Aḏinu? Danab nug keeke ohnu elelenab daaṯe amu nug nuhig keekep̱a bau dayak ii aoṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","Anana amu Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, inam amelagp̱a aum. “Enub danab laa nug omep̱a e meu huanak ele anṯa, ");
INSERT INTO gaw_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","Nug oop̱a nuhig dab mak inam dayom. ‘Da e dahil huanak imunu aṯemtai heḵul, da e dahil oh qag meḵulnu amu e maknu lag elele iiṯa,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","Aria nug anam anana, nug baula aum. ‘Da inam heḵul. Da e maknu lag oh lop̱aḏena, e mak lag oḵai oḵai heina amu da wit qag mein, keeke ena dahil oh ele lag amup̱a qag mep̱i dayebeb, ");
INSERT INTO gaw_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","da inam dab meḵul. Da lagnu laa ii bahuhupa, dahil keeke ena ena daaṯe, maḏ kuḏum daaḵunu elele. Aria da hik awe dayeye amu keeke oh lanakib lainne, gamag ahakp̱a daaḵul,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","Nug dab mak nuhigp̱a anam aum amge Kayak Nug amegp̱a aum. ‘Na kaaka danab! Na gemu tuqan imup̱a amu na mauhḵut. Amu na keeke oh bap̱aidme daaṯe amu aun nug aoḵu,’ awa aum?” ");
INSERT INTO gaw_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","Jesus Nug nai amu anana, Nug nai gog ta aum. “Danab ag keeke kuḏum ahilagnu qag meṯeb amge Kayak noobp̱a amu ag danab ena iiṯa daaṯeb, ag am amubia anidḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","Aria Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Anam daaṯe amunu da ag amelagp̱a aṯem, ag beḏulag bauklel dayaknu dab mena, ‘Ig aḏi laḵunig,’ o iiṯa beḏulagnu, ‘Ig aḏi keeke aot, beḏunig taḵidḵunig?’ aib ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","Beḏu bauklel dayak amu e lanakib iiṯa, beḏu nug lamen taḵaknuib ele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","Ag ai aaḵude anadna doyeg! Ag wit ii ebṯeb, e qag meḵulagnu uḏat ele ii heṯeb. Ag ep̱ulag enulag ele meḵulagnu lag laa iiṯa amge Kayak Nug e madaṯe. Am danab ah ag ai iite eḏadṯeb? Yo, ag huana eḏadṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","Am ag oolagp̱anu danab laa hik qeeb, wagai ma, nug nuhig haen nakok tuḏiṯeb, nuhig bau dayak haen elab daaḵunu elelete? Iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","Ag keeke nakok laa anam heḵulagnu elele iiṯa amu aria aḏinu ag keeke laanu dab mak huana aoṯeb? ");
INSERT INTO gaw_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","Ag bala haḏag onig lili umu anṯeg! Ag uḏat ii heṯeb, lamen ele ii heṯeb amge da ag amelagp̱a aṯem. Anuḵa Solomon nug bala nuhig oh meum amge nuhig bala ena, bala haḏag amubia laa iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","Ao ud nug daṯa gemu hip̱aiṯa daaṯe amu buṯi ag oḵulna, ab aḏup̱a maop̱eg teḵu. Ud nug keeke hamu amge Kayak Nug bala medaṯe amunu ag tutuḵu doyeg, Kayak Nug ag ele genabnab dab madaḵu. Ag oolagp̱a genab nakokib dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","Amu ag aḏi laḵulagnu hik aib aqom. Ag baalag qaḏa eṯeb, ag aḏi laḵulagnu amu ag amunu ele aib hik aqom. ");
INSERT INTO gaw_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","Amu wan imup̱anu iiṯa aḏi ag keeke amu oh aoglagnu wagai huan mena, keeke amu ohnu madiṯeb amge ag dahilad amu, ag Mamelag Nug ag keeke amu aoglagnu matu doyom. ");
INSERT INTO gaw_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","Amge ag Kayaknu ḏo maḏoḏ amunu anuqak doop̱eg am geha Nug keeke amu oh ele ag madaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","O lailad, ag aib baḏap̱ig. Da Mamel Nug nuhig ḏo maḏoḏ ag madaḵunu oo daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","Ag ahilag keeke oh maadp̱eg, danab daden mep̱eg, men doḏo aona, daḏek danab ehanadna maṯeg! Ag anam heḵulag amu ag hogot, alag ma nauhḵunu elele iiṯa amu, ahilag en ele, nug ii iiṯa mema, hab aṯan qag meḵulag. Ap̱a amu yab danab laa nug ii daama, gauat ele ag keeke laa ii hep̱eg nauhma. ");
INSERT INTO gaw_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","Am aben adekup̱a ahilag keeke ena ena daaṯe ele amu, ahilag dab mak ele am ap̱aib daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","Jesus Nug nai amu anana, Nug nai imu ele maṯiom. “Ag lamen maṯagiḏ ele taḵan, lam amotna, uḏat heḵulagnu bap̱aidna, ");
INSERT INTO gaw_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ag uḏat danab, ag ahilag danab oḵai, nug danab ah ele dilah nug awak hobulp̱anu eḏua uḏia, od qeqaleb, od paha matulḵulagnu ameg men daaṯeb bia dayeg! ");
INSERT INTO gaw_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","Am danab oḵai nug uḏia, nuhiḵud uḏat danab ag ii niip̱eg anadḵu aria uḏat danab amu, ahilagnu am ena. Da genab ag amelagp̱a aṯem. Geha danab oḵai nug nuḵa lamen tutu maṯagiḏ ele taḵowa, nug ab, uḏat danab amu ag balalp̱a daap̱eg, nug nuḵa ag e madaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","Amu nug tuqan tugmagtai uḏiḵu, iiṯa matuk laip̱u gayebtai uḏia ag ii niip̱eg anadḵu, uḏat danab amu ahilagnu am ena. ");
INSERT INTO gaw_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","Ag keeke imu tutuḵu anṯeg! Lag mameg nug yabhoi danab uḏiḵunu haen doolo amu yabhoi danab nug laug lop̱aḏa noḵunu am elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","Amunu ag ele bap̱aidna dayeg! Aḏinu? Danab Beḵalag da amu da haen laa ag ii dab meḵulag ele, haen amup̱a uḏiḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","Awa a aria Petrus nug aum. “Naḏi, na keeke danab ag dooṯeb ii dooṯeb ele ou aqatna, ip̱uniṯak nai maṯime ele amu, na ihinignuib amete o iiṯa na danab oh dilag amete?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","A amu Naḏi Nug aum. “Aun nug am uḏat gumak danab dab mak ena ele, nug nuhig uḏat tutuḵu dooṯe, nuhig danab oḵai nug uḏat nid nuhiḵud amu gumaṯaṯa, haenp̱a e madaḵunu elele daaṯe anṯa, nug amu heḵunu meum amu, da nuhignu madiṯem. ");
INSERT INTO gaw_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","Uḏat danab nug anam dayebeb, dimp̱a nuhig danab oḵai nug eḏua uḏia, danab amu nug danab oḵai nuhig anuḵa amegp̱a aumbia heṯe anidḵu amu nuhignu am ena. ");
INSERT INTO gaw_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","Da genab ag amelagp̱a aṯem. Danab oḵai nug uḏat danab amu, nuhig keeke ohnu iḵilag meeb daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","46","Amge uḏat danab amu nug oop̱a, ‘Danab oḵai dahil nug paha ii uḏima,’ dab meḵu dayeb amu nug dig ma, uḏat nid laa, uḏat ah laa ele ag maḵuḏaṯaṯa, nug e lanana, le g̱agaṯag ele lana, kaaka qeeb amu nuhig danab oḵai nug haen deḏ ele, uḏat danab amu nug ii doyom, ii dab meum ele, amup̱a eḏua uḏiḵu. Uḏia amu danab oḵai nug uḏat danab amu eheḏnab heṯowa, awa meeb, danab laala ag oolagp̱a genab ii dooṯeb ele amu, ag ele daaglag. ");
INSERT INTO gaw_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","Am uḏat nid nug nuhig danab oḵainu dab mak amu doyom amge nug dig ma ii babaiṯa, nuhig danab oḵainu dab mak amu dim ii lamiṯom, geha danab oḵai nug huana maḵuḏḵu ");
INSERT INTO gaw_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","amge uḏat danab nug nuhig danab oḵainu dab mak ii doyom amge nug bu aoḵunu kobol heum amu geha nuhig danab oḵai nug nakok maḵuḏḵu. Danab ag keeke kuḏum aop̱ig amu ag eḏun keeke kuḏum nob meḵulag. Am danab ah ag keeke kuḏum danab laa ep̱egp̱a meḵulag, geha ag nug keeke huanak eḏua nob madaḵunu onigp̱a eḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","Jesus Nug baula tuḏiṯa aum. “Da hep̱i, hip̱uninnu g̱agaṯag wan imup̱a iiṯa meḵunu uḏimi. Nuhig g̱agaṯag aaḵu iiṯa melo am ena ");
INSERT INTO gaw_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","amge ug laa da maoḵulnunab daaṯe amunu da ool ug ele daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","Da uḏimi amunu wanp̱a maḏoḏib daaḵu amu ag anam aib dab mep̱ig. Da uḏimi amunu maḏoḏib ii daama. Iiṯa, danab ag opatna, ameg ameg daaglag. ");
INSERT INTO gaw_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","Am gemu, dimp̱a ele, geha lag laip̱up̱an tanig ele ag daanna, laa ag da dim lamiḏp̱ep̱eg, laa ag iiṯa amunu ag geha opatna, ameg aḏit daaglag. Ewam amu ameg laa daaglag, aḏit amu a ameg laa daaglah. ");
INSERT INTO gaw_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","Am anamib mameg nug beḵa ele a maḏoḏ ele ii daamya. Geha anig nug aḏeg ele a maḏoḏ ele ii daamya. Amu anig nug geha beḵa wau ele a maḏoḏ ele ii daamya,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","Jesus Nug danab ah ameglagp̱a ele anana aum. “Ag anidna dooṯeb. Lombig nug aam nodep̱a teṯe anidna, paha ag, ‘Gu neḵunu heṯe,’ aon aṯeb amu genab gu nug neṯe. ");
INSERT INTO gaw_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","Am yau uḏiṯe amu ag, ‘Geha aam nug gakaḏḵu,’ aṯeb amu genab, anam aaḵu heṯe. ");
INSERT INTO gaw_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","Ag ham bup̱uak danab, ag wanp̱anu keeke amu hab waap̱anu keeke ele tutuḵu dooṯeb amunu aḏinu ag dahil haknu tutuḵu ii dooṯeb? ");
INSERT INTO gaw_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","Am aḏinu ag aḵa kobol amu tutuḵu ii dab mena, tutuḵu ele ii epeḏiṯeb? ");
INSERT INTO gaw_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","Aria haen na nahip eheḏnu danab laa nug heṯoḏiakp̱a meidḵunu goyaya, ibp̱a a nai amu babaiṯeḏ! Iiṯa amu nug na heṯoḏiakp̱a meidḵutai. Meiṯeb amu epeḏiak danab nug na heṯoḏiaknu daup laa ep̱egp̱a meiṯeb amu daup amu nug na mani guiṯakp̱a meidḵu. ");
INSERT INTO gaw_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","Meiṯeb amu da na amenp̱a aṯem. Na mani guiṯakp̱a daanna, nahip eheḏ hak nob ohnab eḏun medap̱e, ag od matulp̱eg, dimiṯim doḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","Haen amup̱anab amu danab laala ag daanna, Galelia danab laala ag mana meṯak heegeg, Pilatus he, aqaeg mauhp̱ig amunu Jesus amegp̱a ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","Amu aeg amu Jesus Nug amelagp̱a aum. “Ag ahilag dab makp̱a, ‘Galelia danab amu ag hip̱unin danab nau, Galelia laa oh eḏaṯak amunu aqap̱ig,’ aon aṯebte? ");
INSERT INTO gaw_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","Am da tutuḵunab ag amelagp̱a aṯem, amu iiṯa. Amunu ag dab meig! Ag oolag ii eḏueb amu ag ele laa amu mauhp̱ig bia mauhḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","Laa ele, danab 18, anuḵa Siloam ap̱a lag elab na qa, aqe mauhp̱ig amu ag ahilag dab makp̱a ag amu dilagnu amu ag, ‘Danab amu, eheḏ hak ahilag amu danab laala Jerusalem daaṯeb ele amu, ahilag eheḏ hak oh eḏaṯak,’ aon aṯebte? ");
INSERT INTO gaw_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","Am da tutuḵu ag amelagp̱a aṯem, amu iiṯa. Amunu ag dab meig! Ag oolag ii eḏueb amu ag ele laa amu mauhp̱ig bia mauhḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","Jesus Nug nai baula tuḏiṯa, keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, nai laa maṯia aum. “Danab laa nug nuhig wain dadp̱a ad pig laa ep̱om, am dimp̱a nug uḏia meu anidḵunu dab meum amge meu iiṯa anṯom ");
INSERT INTO gaw_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","amunu nug dadnu uḏat danab amegp̱a aum. ‘Doye, maḏ ewam uue iiḵu da ad pig meu anidḵulnu uḏimi amge meu iiṯa amunu na op̱e qiiaḏ! Aḏinu nug wannu iṯag hamu laṯe?’ awa aum? ");
INSERT INTO gaw_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","Amu dadnu uḏat danab nug amegp̱a aum. ‘Danab oḵai, uup̱e! Maḏ imuib dayebeb, da diigp̱a wan buuen, wan iṯag nug diigp̱a meḵul. ");
INSERT INTO gaw_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","Anam hep̱i, maḏ laap̱a geha nug meu oḵutai. Oḵu am ena amge nug meu ii oḵu aria na op̱e qiiḵu,’ awa aum.” Jesus Nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","Aria Juda dilag Meṯidp̱a Jesus Nug ahilag nai doyak lag oop̱a danab ah nai ip̱uanaṯeṯe ");
INSERT INTO gaw_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","amu ah laa ap̱a dayom, nug beḏup̱a ouḏi nau ele. Maḏ 18 ouḏi nau nug beḏup̱a dayaya, beḏu oḏe meṯe, nug gomelmel oiyom. ");
INSERT INTO gaw_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","Jesus Nug ah amu anṯa, onigp̱a e do, amegp̱a aum. “Ah da oḏe nahip amu uhuqṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","Nug anam awowa, Nug ep̱eg ah amu qaḏep̱a me amu pahanab nug tutuḵu hibaiṯa, Kayak binag meum. ");
INSERT INTO gaw_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","Amge Juda dilag nai doyak lagnu iḵi nug Jesus Juda dilag Meṯidp̱a Nug ah amu he ena dayom amunu op̱oḏi be, nug danab ah amelagp̱a aum. “Deḏ eblaih laip̱u ele amu uḏat haknu daaṯeb amunu ag danab nug oḏe ahilag heeb ena daaglagnu dayeb amu aria ag uḏat deḏp̱aib uḏina, ehaniṯak amu aoglag. Amge Meṯidp̱a ag amunu aib uḏip̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","Anam a amu Naḏi Nug eḏua aum. “Ag am ham bup̱uak danab. Juda dilag Meṯidp̱a amu ag oh doḏ laulagp̱a goṯeb. Gona ahilḵad bulmakau donki ele diin gona, le madaṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","Amu ah imu, nug amu Abraham aḏeg laa, am Satan nug maḏ 18 oḏe meṯa aḏa dayom. Amu diig aḏinu da Juda dilag Meṯidp̱a da nug beḏu ii uhuqḵul? Am aḏinu amuam elele iiṯa?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","Nug anam a amu nuhiḵud kekeḏ ag uḏalag eheḏ neum amge danab ah laa oh ag nuhignu gamalag ahom. Aḏinu? Nug keeke oh ena heum. ");
INSERT INTO gaw_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","Am Jesus Nug nai imu ip̱uanaṯa aum. “Kayaknu ḏo maḏoḏ amu nug aḏi keeke bia daaṯe? Da aḏi keeke laa ip̱uanadp̱i, ag Kayaknu ḏo maḏoḏnu oolag maidḵu? ");
INSERT INTO gaw_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","Nug am ad mastet aeg beṯe amubia. Danab laa nug ad mastet aeg amu awa, dad nuhigp̱a ep̱e, dimp̱a nug ba, ad oḵai me, ai ag uḏin ep̱egp̱a daaṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","Nug nai amu anana amu Nug eḏua aum. “Da aḏi keeke laa ip̱uanadp̱i, ag Kayaknu ḏo maḏoḏnu oolag maidḵu? ");
INSERT INTO gaw_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","Nug am yis bia, amu ah laa nug yis nakok awa, plaua ele kabolie dayeye, am dimp̱a plaua oh titiḏṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","Anam anana amu Jesus Nug aha uḵa, ab oḵai nakok elep̱a oiyaya, danab ah nai ip̱uanaṯaṯa, Nug Jerusalem goḵunu uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","Am danab laa nug Jesus oḏ meṯom. “Naḏi, dimp̱a Kayak Nug danab laip̱u laip̱uib eḏua diiadḵute?” oḏ meṯom. Oḏ meṯe amu Jesus Nug amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","“Amu ag od oḏe nakokp̱a noaknu elele daaglagnu amu ebehilag qai eṯaḏ! Da ag amelagp̱a aṯem, danab kuḏum ag od oḏe nakokp̱a noḵulagnu heḵulag amge ag elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","Lag mameg nug aha, lag od maneb amu ag uḏina, dimiṯim daanna, od qeqalnana, inam aḵulag. ‘Naḏi na od ihinignu matule,’ aon aḵulag. Amu geha nug ag amelagp̱a aḵu. ‘Da ag ii doyadṯem, ag adep̱anu uḏip̱ig?’ ");
INSERT INTO gaw_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","Nug anam ab amu ag nug amegp̱a aḵulag. ‘Ig amu na ele e, le ele lamut. Na ig ip̱unigp̱a daanna, amenigp̱a ip̱uniṯak nai ele ame,’ aon aḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","Ag anam aḵulag amge nug ag amelagp̱a aḵu. ‘Da ag ii doyadṯem, ag adep̱anu uḏip̱ig? Ag nauhak danab. Ag oh uuiḏna uḵeg!’ ");
INSERT INTO gaw_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","Amge ag oop̱a ii nop̱ig ele amu, ag Abraham, Isak, Jakop amu propet oh ag Kayaknu ḏo maḏoḏ oop̱a daap̱eg anadnana, ag am geḏaṯak dimiṯim daaṯeb doonna amu ag gaanna, aelag ele kikiḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","Amu geha danab ag laih laih ohnu uḏina, ag Kayaknu ḏo maḏoḏ amu oop̱a nona daaglag. ");
INSERT INTO gaw_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","Ao danab laala gemu dim daaṯeb amu geha ag anuqḵulag amu danab laala gemu ag anuqak daaṯeb amu geha ag dim daaglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","Jesus Nug nai maṯieye, aam ameg amup̱anab Juda dilag ḏo mehuqak danab amu ḏo gumak danab-Parasia laala ele ag dona, nug amegp̱a ap̱ig. “Na ab imu uun, ahan laih uḵe! Herodes Antipas nug na niṯeb mauhḵutnu heṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","Am Jesus Nug amelagp̱a aum. “Ag gona, hip̱eg qaḵak danab amu amegp̱a inam ap̱eg dooḵu. ‘Doye, da gemu, buṯi ele am ouḏi nau lamaṯeṯe, oḏe danab amu ele hep̱i, ena daap̱eg am deḏ ewamp̱a amu da geha uḏat dahil gog teḵul.’ ");
INSERT INTO gaw_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","Amge gemu, buṯi, laatu ele amu da oiḵul. Aḏinu? Ag amu propet danab laa ab laap̱a qep̱eg ii mauhma. Iiṯa. Ag Jerusalem ap̱a nug qep̱eg mauhḵu. ");
INSERT INTO gaw_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","O Jerusalem, O Jerusalem, na propet aqae mauhṯeb, uḏat danab amu Kayak nahipp̱a maaṯe uḏiṯeb ele amu na ag ele menp̱a aqae mauhṯeb. Da haen kuḏum da na begapad, matuk anig nug naḵud haugp̱a qag maaṯa tonadṯe, amubia qag maadḵulnu hemi amge ag uup̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","Amunu da ag oolagp̱a ii daapa, ag hamu daaglag. Da ag amelagp̱a aṯem. Ag da baula paha ii aniḏmana. Iiṯa. Ag, ‘Danab umu Nug Kayak onigp̱a uḏiṯe. Kayak Nug itidṯe,’ anana, ag da eḏun aniḏḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","Am Juda dilag Meṯid laap̱a Jesus Nug ḏo gumak danab-Parasia dilag iḵi laa laugp̱a e laḵunu uḵom. Uḵe amu ḏo gumak danab-Parasia ag nug meidna daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","Amu danab laa nug leele agiṯak ele amu nug ele ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","Am Jesus Nug danab amu anṯa, nug ḏonu doyak danab amu ḏo gumak danab-Parasia ele oḏ maṯa aum. “Ḏop̱a aḏi yak niiṯe? Ig Meṯidp̱a danab oḏe ele bap̱aidḵunignu am elelete o iiṯate?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","Nug anam aum amge ag Nug amegp̱a amunu nai laa ii madip̱ig amunu Nug danab amu awa, oḏe nuhig amu babaiṯowa, he uḵe, ");
INSERT INTO gaw_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","Nug ag amelagp̱a aum. “Ag oolagp̱anu danab laa nug nuhig nidtai o doḏ nuhigtai le moḏp̱a nob amu danab nug Meṯidp̱a paha eeḏeb iite bema?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","Nug nai amu maṯia oḏ maṯom amu ag nob meḵulagnu nai laa ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","Aria Jesus Nug danab ag hobulp̱a uḏip̱ig amu ag balalp̱a daaglagnu, ag balal anuqak tituanaṯegeg anaṯa, Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, nai maṯiaya amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","“Am danab laa nug, nug awaknu hobul naḏip̱a goḵutnu na oninp̱a eeb amu na gona, na balal anuqakp̱a aib daame. Aḏinu? Danab nug hobul amu heṯe ele amu nug danab laa, binag oḵai ele, na binan eḏiṯak, nug ele onigp̱a eeb uḏiḵutai. ");
INSERT INTO gaw_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","Anam dayeb amu a oh hobulp̱a uḏipeḏ aria danab onilahp̱a eum ele nug doa, na balal anuqakp̱a daap̱e aniṯa amu nug na amenp̱a, ‘Na balal amu danab oḵai binag ele imu meṯe!’ aḵu. Anam ab am na geha uḏan eheḏ neebeb, na gona dimulagp̱anab daaḵut. ");
INSERT INTO gaw_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","Amge danab laa nug hobul amup̱a goḵutnu na oninp̱a eeb amu na gona, na laa dimulagp̱a daye! Na anam daap̱e, danab oninp̱a eum ele nug geha amenp̱a, ‘Lai na uḏin balal anuqak imup̱a daye!’ awa aḵu. Nug anam heeb amu na geha e lanakp̱a danab oh noolagp̱a am na binan ele daaḵut. ");
INSERT INTO gaw_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","Am danab aun nug onig humaṯe amu Kayak Nug heeb, danab amu nug onig neḵu amge danab aun nug onig qe neṯe amu Kayak Nug danab amu onig am humaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","Aria Jesus Nug ag amelagp̱a anam anana, Nug danab nug ele e laḵulahnu onigp̱a eum ele amu, nug amegp̱a aum. “Am na hobul heḵutnu oot dayeb, na laipad, na awanad amapad, na buḏunad, nahip mudip̱an, ag enulag kuḏum ele amu, ag dimp̱a na ahilag hobulp̱a eḏun daaḵutnu oninp̱a emananu, na amup̱a nob ena eḏun aomnanu, na ag onilagp̱a aib eme. ");
INSERT INTO gaw_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","Iiṯa. Na e naḏi hewona aria na daḏek danab, beḏulag nauhak, baelḵad nau, amelag gaḏuak ele amu onilagp̱a eḵut. ");
INSERT INTO gaw_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","Am danab amu, ag am nahip e amu nob meṯaglagnu elele iiṯa, am na anam hep̱e amu Kayak na itiṯak medaḵu. Yo dimp̱a Kayak Nug amunu haen danab tutuḵu ag eḏun hip̱aidḵulag amu Nug na nob ena medaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","Nug nai maṯia male, ag daap̱ig ele amu ag oolagp̱anu danab laa nug nai amu doya, Jesus amegp̱a aum. “Danab nug geha Kayaknu ḏo maḏoḏ oop̱a e laḵu amu, nuhignu am ena,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","Amge Jesus Nug amegp̱a aum. “Am danab laa nug hobul oḵai heḵunu ha, nug danab kuḏum ag nuhig hobul oḵai amup̱a uḏin, e laḵulagnu onilagp̱a eum. ");
INSERT INTO gaw_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","Aria e lanak haen amu do amu danab amu nug begbeg nuhig nug uḵa, danab anuḵa uḏiglagnu deḏ maaṯom ele amu, nug ag amelagp̱a inam aḵunu aum. ‘Ag uḏieg! Keeke oh amu babaiṯa malak.’ Nug anam amegp̱a a, nug uḵa anam aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","Nug anam aum amge danab amu ag oh ahilag dab mak anen anen aḏaeg be maṯina, ag hobul amu anuqak iiṯa doona uup̱ig. Anam maṯin, danab laa nug amegp̱a aum. ‘Da amu dad laa daden memi amunu da uḵen anidḵul. Gadon, hobulp̱a goḵulnu am elele iiṯa. Amu na oḵai nahip amunu amegp̱a ap̱e doya, nug oo ug aib qeum,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","Am laa nug amegp̱a aum. ‘Da amu bulmakau uḏat haknu eblaih tanig ele daden maadmi amunu da uḵen uḏat maṯe anidḵul. Gadon, da hobulp̱a goḵulnu am elele iiṯa amu na oḵai nahip amunu amegp̱a ap̱e doya, nug oo ug aib qeum,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","Amu laa nug aum. ‘Ge da amu geha iiḵu ah aomi amunu da am goḵulnu elele iiṯa,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","Aria begbeg amu nug eḏua uḵa, nug nuhig danab oḵai amegp̱a ag ap̱ig amu maṯiom. Aaḵu lag mameg nug op̱oḏi be, nuhig begbeg amu amegp̱a aum. ‘Na paha gona, ab oḵai imunu ib oḵai ohp̱anu, ib nakok ohp̱anu ele daḏek danab amu danab beḏulag nauhaṯak ele, amelag gaḏuak, baelag nauhak ele amu, na amu oh omaladp̱e, ag da laul oop̱a uḏieg!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","Nug anam a am dimp̱a begbeg nug nuhig oḵai amegp̱a aum. ‘Naḏi, da na ame amu dim lamiṯen hein malami amge balal laa oh am ii beum,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","Anam a amu danab oḵai nug begbeg amegp̱a eḏua aum. ‘Na gona, ib oḵai ohp̱a, dad ohnu aḏ ele maṯan gonana amu na danab ah oh eeḏadp̱e uḏin, oop̱a noig! Da laul imu nug am beḵunu da ool daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","Am imu da na amenp̱a ele aṯem. Danab amu oh da ag anuḵa onilagp̱a emi ele amu, ag e dahil iinab aomna,’ awa aum.” Jesus Nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","Aria dimp̱a danab ah ameg naḏi ag Jesus dim lamiṯeg gonana, Nug eḏua ag amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","“Am danab nug dahilp̱a uḏiṯe amge nug am mameg, anig, am nuhig ah, beḵod dilag am awag amag ap̱inḵud dilag, nug nuḵa nuhig bau dayak ele amunu anuqak dooṯe ele, aria nug dahil ip̱uniṯak awak danab daaḵunu am elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","Am danab nug nuḵa nuhig ad emaitak mawa, da dim ii lamiḏṯe, nug am dahil ip̱uniṯak awak danab daaḵunu am elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","Am ag oolagp̱anu danab laa nug lag elab laa heeb, aṯan teḵunu ha am aṯemtai heḵu? Nug tatam dayaya, nug lag amunu nob amun dab ma tutuḵu dooḵu. Nuhig men doḏo, lag amu ha malaḵunu am elelete o elele iiṯate amu dooḵunu anam heḵu. ");
INSERT INTO gaw_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","Amu nug tatam anam ii heḵu amu aria dimp̱a nug lag amunu mawa daaḵunu keeke hewowa, lag malaḵunu amu elele iiṯa dayeb, danab oh ag nug anidna, geha ag nug imidna, ");
INSERT INTO gaw_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","inam aḵulag. ‘Danab umu nug am lag umu heḵunu dig meum amge nug ha malaḵunu elele iiṯa,’ aon aḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","Amu anamib king laa nug king laa ele ban heḵulag aria nug am tatam dayaya, dab mak tutuḵu aoḵu. Aḏinu? Nug am nuhig daup 10 tausenib, am king laa nug nuhig daup am 20 tausen amunu nug tatam dooḵu, nug am king laa amu ele ban heya, nug lamidḵunu elele o elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","Amu nug dab ma, nug elele iiṯa anṯa amu aria haen nuhig kekeḏ amu nug uma dayebeb amu, nug nuhiḵud danab laala heeb, ag gop̱eg, ag ban hep̱eg ii bemanu nai maṯiglag. ");
INSERT INTO gaw_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","Amge amubia ag oolagp̱anu danab nug nuhig keeke oh uuaṯa ii di madaṯe aria nug dahil ip̱uniṯak awak danab daaḵunu am nug elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","Jesus Nug anam anana, Nug nai tuḏiṯa aum. “Yu kalu amuam keeke ena amge yu kalu nug nuhig ubuhi amu iiṯa meeb aria geha danab laa nug heeb, yu amu nug eḏua ena daaḵunu aṯem heḵu? ");
INSERT INTO gaw_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","Am yu kalu anam amu danab ag wanp̱a o iiṯa aben laap̱a uḏat meṯaglagnu elele iiṯa. Ag hamu maop̱eg goḵu. Danab nug daug ele dayeb amu nug doyaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","Amu takis awak danab, hip̱unin danab amu danab ag Juda dilag ḏo oh ii dim lamidp̱ig ele, ag Jesus gumidna uḏina, nuhig nai doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","Amunu ḏo gumak danab-Parasia amu ḏo mehuqak danab ele ag nai hena ap̱ig. “Danab amu Nug hip̱unin danab amu danab laa, ag ihinig ḏo oh ii dim lamidṯeb ele amu, Nug ag ele layam batan, ag ele oh e laṯeb,” aon ap̱ig ");
INSERT INTO gaw_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","amunu Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, imu amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","“Ag oolagp̱anu danab laa nug sipsip 100 ele amge nug nuhig sipsip laip̱u nug am padal meeb, aria geha sipsip mameg nug 99 laa amu uuaṯeb, ag aben laap̱a e lanana daap̱eg, nug am uḵa sipsip laip̱u amu maṯia maṯia nug anidḵu. ");
INSERT INTO gaw_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","Anṯa amu aria nug gamag ahebeb, huma awa, mawa goḵu. ");
INSERT INTO gaw_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","Nug mawa uḵa, laugp̱a ta amu nug laiḵud am nuhig mudip̱an ele ag onilagp̱a eeb, ag uḏin qag mep̱eg amu nug amelagp̱a, ‘Da dahil sipsip laip̱u imu nug padal meum amge da nug maṯien eḏuen aomi amunu da ag ele ig oh gamanig ahaḵu,’ awa aḵu. ");
INSERT INTO gaw_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","Amunu da ag amelagp̱a aṯem, amubia hab aṯan ap̱a ag danab tutuḵu 99, amu dilag gamalag ahaṯe, oo eḏuak uḏat ahilag am malom amge hip̱unin danab laip̱u laa nug oo eḏueb, haen amup̱a am gamag ahak naḏinab hab aṯan daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","Am laa ele inam. Ah laa nug amu silwa men doḏo ten ele amge laip̱u laa qetoḏeb am geha nug lam amota, laugp̱a kinipan tateb uḵeb, maṯia neeḵa auta awa haaha amu nug anṯa aoḵu. ");
INSERT INTO gaw_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","Anṯa awa amu aria geha nug laiḵud am mudip̱an ele onilagp̱a eeb, ag uḏin qag mep̱eg, nug ag amelagp̱a, ‘Men doḏo dahil laip̱u qetoḏom amge da maṯie eḏuen aomi amunu da ag ele ig oh gamanig ahaḵu,’ awa aḵu. ");
INSERT INTO gaw_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","Amunu da ag amelagp̱a aṯem. Amubia am hip̱unin danab laip̱u laa nug oo eḏuṯe amu Kayaknu engel ag gamalag ahaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","Jesus Nug anam awowa, Nug baula maṯiom. “Danab laa bekoḏ aḏit. ");
INSERT INTO gaw_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","Amu nid gehanu nug aha, mameg amegp̱a aum. ‘Mame, keeke oh na geha da awai ele i ihinih aognihnu otiḵut amu otiak dahil aoḵulnu amu na gemu da meḏe!’ awa aum. Aria mamelah nug nuhig keeke oh bekoḏ aoglahnu otia mate aopiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","Nug a mate aoeh, haen elab iiṯa amu beḵa gehanu nug aha, keeke am oh aḵa, qag ma awa, ab laap̱a umanab uḵom. Nug nuḵa ap̱a wan amup̱a dayaya am nuhig men doḏo amu enaen mak kobolp̱a oh aḵe uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","Amu nug nuhig keeke oh aḵe uḵa male, dimp̱a wan amup̱a enug haen naḏi beum, ge nug keeke laa iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","Amunu nug uḵa, wan amup̱anu danab laa nuhig uḏat heḵunu he, danab amu nug he, nid amu uḵa, danab amu nuhig bo gumaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","Amu nug bo dilag e laḵunu baag uḵom amge danab laa nug lanak keeke laa nid amu ii meṯom. ");
INSERT INTO gaw_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","Aria nug qagaiṯak dayaya, nug nuḵa oop̱a be, dab ma, nug nuḵa nuḵa nai maṯia aum. ‘Da mamelnu begbeg oh ag am e kuḏumnab ele amge da ip̱a daaṯem amu enug huanaknab niḏe, mauhḵulnu heṯem. ");
INSERT INTO gaw_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","Amu da aṯem heḵul? Da gemu ahe eḏue, mame top̱a uḵen am da nug amegp̱a inam aḵul. “Mame da Kayak amegp̱a, na noomp̱a ele hip̱unin hemi. ");
INSERT INTO gaw_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","Am gemu na dahilnu, ‘Na am nid dahil,’ aon aḵutnu elele iiṯa amunu na hep̱e, da nahip begbeg laa bia daaḵul,” awe aḵul.’ Nug nuḵa nuhignu anam aum. ");
INSERT INTO gaw_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","Aria nug anam anana, nug aha uḵom amge nug uḵa, uma up̱a piḏe uḏieye, mameg nug anṯa, nuhignu oo huanak doye, qaibaḏ uḵa, beḵa aḏa ootuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","Ootuqiṯe amu beḵa nug mameg amegp̱a aum. ‘Mame, da Kayak amegp̱a, na noomp̱a ele hip̱unin hemi amunu na dahilnu, “Na am nid dahil,” aon aḵutnu elele iiṯa,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","Nug dig ma anam aum amge nug mameg nug begbeg nuhiḵud onilagp̱a e doeg amelagp̱a aum. ‘Lamen ena paha aon dona tagiṯona, enag laa aon dona, ep̱eg doḏop̱a aḏap̱eg nob, baeg gaḏa ele aona, baegp̱a aḏap̱eg taḏ! ");
INSERT INTO gaw_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","Amu makau nag iṯag ele laa aon dona qep̱eg, ig latata gamanig ahaḏ! ");
INSERT INTO gaw_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","Am aḏinu? Dahil nid imu nug mauhom amge nug eḏua bau daaṯe. Nug padal meum amge ig nug eḏut aomut,’ awa aum. Amunu ag hobul laa hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","Heegeg, nid tatamnu nug daṯa dayaya, dimp̱a nug uḏia, nug lag guguiṯa ba amu ag ahi eṯana, goḏana heegeg doya, nug dumuṯum baag ele doya, ");
INSERT INTO gaw_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","nug begbeg laa onigp̱a e do, oḏ meṯom. ‘Umu aḏi henana heṯeb?’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","A amu begbeg nug amegp̱a aum. ‘Na amap nug eḏua uḏie, na mamen nug bulmakau nag iṯag ele qeum. Aḏinu? Nug nid eḏua awe, nug ena daaṯe, ii padal meum,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","A amu nid tatamnu nug anam doya, op̱oḏi be, nug lag oop̱a noak uuom. Uue aria mameg aha dimiṯim doa, nug oo meḵunu oo mak nai amegp̱a aum ");
INSERT INTO gaw_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","amge nug eḏua mameg amegp̱a aum. ‘Da maḏ kuḏum nahip begbeg bia, nahip uḏat hemi. Deḏ laip̱u laa da na oḏen tap̱ai ii neum amge na meme nag laip̱uib laa, da lailad ele gamag ahak heḵunignu, ii meḏame. Amu iiṯanab. ");
INSERT INTO gaw_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","Amge nid nahip amu, nug ib baag ah ele oinna, nahip keeke oh aḵe uḵom ele amu, nug eḏua uḏie, na nuhignu oot doye, na makau nag iṯag ele aḵu qeme,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","Aaḵu mameg nug beḵa amegp̱a aum. ‘Nagpi, haen oh i oh daaṯep amunu dahil keeke oh amu nahip ");
INSERT INTO gaw_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","amge gemu amu ig gamag ahak doop̱ut, ig oonig ele ena daaḵunu elele. Aḏinu? Na amap imu nug mauhom amge gemu nug am bau daaṯe. Nug padal meum amge ig nug anidta aomut,’ awa aum.” Jesus Nug nai amu maṯiom. ");
INSERT INTO gaw_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","Aria Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a maṯia aum. “Enub danab laa nug dayaya, nug uḏat danab laa nuhig keeke oh gumaḵunu tituane dayom. Am danab laa ag enub danab amu gumidna uḏin, uḏat gumak danab nuhig amu dimug mena inam ap̱ig. ‘Nahip uḏat gumak danab nug nahip keeke hamu kakidṯe,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","Anam aeg amu nug uḏat gumak danab nuhig onigp̱a e uḏie, amegp̱a aum. ‘Na keeke heme amu nai amu da doomi amunu na gona, dahil keeke oh na aḏaṯem amu uḏug laap̱a yaaḵut. Aḏinu? Na baula uḏat gumak danab daaḵutnu am elele iiṯa,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","Anam a amu uḏat gumak danab amu nug nuḵa nuḵa nai maṯia aum. ‘Da aṯemtai heḵul? Danab oḵai nug am dahil gumaknu uḏat amu eḏua aoṯe. Da wan opatḵulnu amu da g̱agaṯag elele iiṯa, laa amu da danab laa unuqadp̱i, e meḏaglagnu amu da uḏal neṯe,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","Anam anana am nug baula dab makp̱a aum. ‘Oḵai dahil nug uḏat dahil eḏua aweb, da danab laala ag da ag laulagp̱a daaḵulnu aḵulagnu amu da inam heḵul. Danab amu ag dahil oḵainu keeke nob eḏun meṯaglagnu aop̱ig amu da ag ehanadp̱i, dimp̱a ag da ehaniḏḵulag,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","Anam anana amu nug danab laip̱u laip̱u ag beḏulagp̱a nuhig danab oḵainu keeke nobnu ele amu ag onilagp̱a e, gumidna uḏip̱ig. Aaḵu danab laa nug tatam be, uḏat gumak danab nug oḏ meṯom. ‘Na amu beḏunp̱a dahil danab oḵainu keeke nobnu am gane ele?’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","A am nug, ‘Tri tausen lita olip goḏen,’ awa aum. A am uḏat gumak danab nug amegp̱a aum. ‘Na keeke nobnu yak qaṯi nahip iiḵude aon, na paha daanna, na amunu big laih wan tausen paip handatib ye!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","Nug anam he dimp̱a amu uḏat gumak danab nug danab laa oḏ meṯom. ‘Nahip keeke nobnu amu gane?’ A am nug, ‘Wan tausen bek wit,’ awa aum. A amu nug amegp̱a aum. ‘Na keeke nobnu yak qaṯi nahip iiḵude aona, na amunu big laih eit handatib ye!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","Gumak danab nug anam he, dimp̱a danab oḵai nug danab nau amu binag meum. Aḏinu? Nug am danab dab mak ele bia kobol heum. Wan imup̱an danab ag amu, ag ahilag uḏat heḵulagnu elelenab, ag amup̱a amu ag danab amahlakp̱anu amu ag eḏadṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","Jesus Nug anam anana, Nug baula aum. “Amunu da ag amelagp̱a aṯem. Ag wan imunu enub nau, men doḏo, amup̱a ag hep̱eg, danab ah amu ag lailḵad daaglag. Am dimp̱a men doḏo iiṯa meeb aria ag omaladp̱eg, ag hanhan ena daaglagnu laulagp̱a goḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","Am danab laa nug keeke nakok amu ena elele dab meṯak dooṯe aria geha nug keeke oḵai am ele ena elele dab medaḵu. Amu danab nug keeke nakokp̱a uḏat tutuḵu haknu am ii dooṯe am geha nug am keeke oḵaip̱a uḏat tutuḵu haknu am ii dooma. ");
INSERT INTO gaw_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","Am anamib ag enub nau, men doḏo, wan imunu ag amu ena dab meṯaknu ii dooṯeb am geha aun nug ag keeke genab gumaglagnu madaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","Am ag danab laanu keeke amu ag atog ii nop̱eg am geha aun nug ag keeke aḵa ahilagnab atog noḵulagnu amu ag madaḵu? ");
INSERT INTO gaw_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","Danab laip̱u nug gumak danab aḏit dilahnu uḏat heḵunu elele iiṯa. Am nug laanu oo mauhebeb, laanu amu nug oop̱a nau, ninig ele dooḵu. Doyaya, laaib amu nug dim lamiṯaṯa, laa amu di medaḵu. Amu ag Kayaknu uḏat amu enub uḏat ele oh heḵulagnu elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","Amu ḏo gumak danab-Parasia, ag am men doḏonuib oolag dayom, amunu Jesus Nug nai amu oh maṯie doona amu ag ahan, nuhignu guhuḏiṯak nai madip̱ig ");
INSERT INTO gaw_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","amge Nug ag amelagp̱a aum. “Ag amu danab noolagp̱aib kobol miag atiak tutuḵu heḵulagnu amunuib oolag daaṯe amge Kayak Nug am ag oolag diig amu dooṯe. Danab ag aḏi keekenu enanag dooṯeb ele amu Kayak noobp̱a keeke amuam hamuib. ");
INSERT INTO gaw_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","Ḏo nai amu Kayaknu propet dilag nai ele, anuḵa danab ag amu mehuqegeg uḏie uḏie, Layaṯak Johanesnu haen batak amu Layaṯak Johanesnu haenp̱a uḏie, gemu ele amu ag Kayaknu ḏo maḏoḏnu nai genab ena amu ag mehuqṯeb. Amu danab oh ag Kayaknu ḏo maḏoḏ amu oop̱a noḵulagnu wagai meṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","Geha dimp̱a hab wan ele amu iiṯa meḵulah amge Kayaknu ḏo nai, nuhig hup̱u laip̱u laa amu iinab qetoḏma. ");
INSERT INTO gaw_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","Amu danab oh ag ahilḵad ah am lamadna, ag ah bau laa diiṯeb amu ag gap̱ai kobol heṯeb. Amu danab nug ah laa nug gamu anuḵa uuiṯe oiyeye aoṯe, danab amu nug ele gap̱ai kobol heṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","Jesus Nug ele aum. “Anuḵa enub danab laa dayom am nug hanhan beḏup̱a lamen kokoḏ bala ena ena eleib meṯom. Am nug hanhan e ena enaib laṯom. ");
INSERT INTO gaw_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","Amu nug laug od guguiṯak amu daḏek danab laa hanhan meeg daaṯom. Nug onig amu Lasarus. Nug beḏu ihiud nau am bak ele. ");
INSERT INTO gaw_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","Nug am enub danab amu nug e labob, e hup̱u neeb amu awa lalonu dab ma daaṯom. Nug anam dayeye, qai ag dona, lemaḏulagp̱a nug ihi nau amu hoḏuegeg daaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","Am dimp̱a daḏek danab amu nug mauhom. Mauhe am engel ag nug aon meeg, Abraham ele daapiḏ. Daaeheh amu enub danab nug ele mauhe, ag nug boomeg, ");
INSERT INTO gaw_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","nug uḵa, Hadesp̱a guiṯak naḏi ele dayom. Anam dayaya, nug neeḵe aṯan uḵe, Abraham umanab dayeye, Lasarus nug ele daaeheh anatom. ");
INSERT INTO gaw_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","Anata amu enub danab nug ewa aum. ‘Mame Abraham, na dahilnu oot gai iiṯa doon, na hep̱e, Lasarus nug uḏia, nug ep̱eg hiqal nob nakok lep̱a ma, lemaḏulp̱a meeb, oug nakok maḏ! Aḏinu? Da ab gakaḏak imup̱a guiṯak naunab dooṯemde,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","Awa a amu Abraham nug aum. ‘Nagpi, keeke laip̱u imu na dautp̱a doḵu. Anuḵa haen na bau daanna amu na keeke ena oh aome amu Lasarus nug am keeke oh nau awom. Amge gemu aben imup̱a nug am oo ena dayeye, ge na amu guiṯak nau dooṯem. ");
INSERT INTO gaw_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","Amu keeke laa ele, ig ag ele oh gamagp̱a Kayak Nug bai naḏi umanab noa uḵak laip̱u meum daaṯe amunu danab ip̱a daaṯeb ele amu ag ahan, bai amu nona tena, ag daaṯebp̱a waḵulagnu amu ag elele iiṯa. Am danab ap̱a daaṯeb ag ahan, bai amu nona bena, ig daaṯemp̱a doḵulagnu amu ag elele iiṯa,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","Anam a amu enub danab nug aum. ‘Mame, anam dayeb amu da na oḏ medṯem, na hep̱e, Lasarus nug da mamel laugp̱a uḵa, ");
INSERT INTO gaw_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","da amalad tanig ele amu, ag ele aben guiṯak naḏi imup̱a uḏimnanu, Lasarus nug dab mak awaknu nai ab, ag dooglag,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","Amge Abraham nug aum. ‘Ag amu Mosesnu nai am Kayaknu propet dilag nai ele, ag am nai amu doyeg!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","A am enub danab nug aum. ‘Iiṯa mame Abraham! Ag amu dooṯeb amge laip̱u mauhom ele, nug matmatp̱anu eḏua aha uḵa amelagp̱a ab, ag oolag eḏuḵu,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","Nug anam aum amge Abraham nug amegp̱a aum. ‘Ag Mosesnu nai amu Kayaknu propet dilag nai ele doona ii dim lamidp̱eg amu aria laip̱u laa nug mauhom, matmatp̱anu aha uḵa amelagp̱a ab amu, ag amu ele geha ag oolagp̱a amunu genab ii doomna,’ awa aum.” Jesus Nug nai amu maṯiom. ");
INSERT INTO gaw_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","Amu Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Am keeke diigdiig kuḏum bena hep̱eg, danab ah ag hip̱uninp̱a nena qeḵulag amge danab nug heeb, danab laala ag nena qeḵulag amu nuhignu gadonnab. ");
INSERT INTO gaw_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","Amu laa nug heeb, nid naunau imunu laip̱u laa nug hip̱uninp̱a na qeeb amu danab he na qeum ele, ag nug ii heum haenp̱a ag baagp̱a men oḵai laa qaḵan, buḏip̱eg, yup̱a nolo am nakok nau amge nug dayaya heeb, nid laa hip̱uninp̱a na qelo amuam naunab nau. ");
INSERT INTO gaw_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","Am ag aḵa ahilagnu ele dab meig! Amu ag awalag o amalag laa nug hip̱unin heeb amu na nug daug bate! Amu nug oo eḏueb amu na nuhig hip̱unin uhuqna meṯe! ");
INSERT INTO gaw_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","Amu nug nahipp̱a deḏ laip̱u hip̱unin heeb, uḵa eblaih aḏit teeb, haen eblaih aḏit nug eḏua na gumiṯa uḏia, ‘Gadon da eheḏ hemi,’ awa ab amu na nuhig hip̱unin amu uhuqna meṯe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","A amu ip̱uniṯak awak danab ag Naḏi amegp̱a ap̱ig. “Na hep̱e, ig ihinig oop̱a genab doyak amu oḵainab maḏ!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","Aeg amu Naḏi Nug aum. “Ag ahilag oop̱a genab doyak amu mastet aeg bia anam dayeb am geha ag ad onig Mulber imu, nuhignu, ‘Na diḏin ele oh kakeḏinna, gona yup̱a be!’ aḵulag amu nug geha ahilag nai am dim lamidḵu. ");
INSERT INTO gaw_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","Amu ag oolagp̱an laip̱u laa nug nuhig begbeg, nug daṯa wan opatḵunu ab, o iiṯa nug doḏ sipsiptai gumadḵunu ab, begbeg nug uḵa ha, dimp̱a nug eḏua laḵa uḏieb amu gumak danab nuhig nug nug amegp̱a, ‘Na paha dona daanna e la!’ awa aḵute? ");
INSERT INTO gaw_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","Iiṯa. Nuhig oḵai nug nug amegp̱a inam aḵu. ‘Na dahil e bap̱aidna, maṯagiḏ taḵana, na dahil e yaan aon dop̱e, da tatam lawoya, le ele lap̱i, dimp̱a amu na e lawona, le la!’ awa aḵu. ");
INSERT INTO gaw_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","Begbeg nug anam heeb amu nuhig oḵai amu nug begbeg nug nuhig nai dim lamiṯom amunu nug amegp̱a, ‘Ena heme,’ awa aḵute? Iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","Amubia ag ele keeke oh Kayak aum amu ag hena malona, ag, ‘Ig am begbeg nau, ig keeke hemut ele amu ig ihinig uḏat aaḵuib hemut,’ aon aḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","Amu Jesus Nug Jerusalem uḵaknu ib amu dim lamiṯa, nug Samaria Galelia ele tomp̱a uḵa, ");
INSERT INTO gaw_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ab laap̱a teete amu danab eblaih tanig ele, ag gaḏa oḏe ele, ag ibp̱a anidp̱ig. Ag uma piḏe up̱a hip̱aidna daanna, ");
INSERT INTO gaw_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ag am huana enan ap̱ig. “O danab Naḏi Jesus, na ihinignu oot gai iiṯa doye!” ");
INSERT INTO gaw_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","Ag anam aon eeg, Nug ag anaṯa, Nug amelagp̱a aum. “Ag gona, beḏulag amu mana meṯak danab ip̱uanaṯeg!” awa aum. Nug anam a aria ag wana uḵaegeg, ibp̱a oḏe ahilag amu iiṯa meum. ");
INSERT INTO gaw_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","Amu ag oolagp̱anu danab laip̱u, nug beḏu eḏua ena dayom anṯa, nug eḏua uḵa, huana ewa, Kayak binag meum. ");
INSERT INTO gaw_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","Nug am uḵa, Jesus baegp̱a gomela, gateg qaun wa, iḵi wan ye, “Na ena heme,” anana, Nug humiṯom. Danab amu nug am Samaria danab. Samaria Juda ele ag am layam ena iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","Am Jesus Nug danab amu nug anam he anṯa, Nug aum. “Am da dooṯem, ag danab eblaih tanig ele beḏulag eḏua ena dayom amge danab eblaih waḏele laa amu ag adep̱a daaṯeb? ");
INSERT INTO gaw_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","Danab laa nug eḏua uḏia, Kayak binag meḵunu amu iiṯatai? Danab imu nug am laihnu, nug nuḵa iiḵuibte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","Nug anam anana amu Nug danab amu amegp̱a aum. “Na ahan uḵe! Na ootp̱a genab doome amunu na eḏun ena daaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","Amu haen laa ḏo gumak danab-Parasia ag Jesus oḏ meṯan ap̱ig. “Haen ganeb Kayaknu ḏo maḏoḏ am uḏiḵu?” aon ap̱ig. Aon aeg amu Jesus Nug nai ahilag amu nob ma aum. “Amu Kayaknu ḏo maḏoḏ uḏieb amu danab ah ag amelagp̱a anidḵulagnu am elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","Amu ele danab ah ag, ‘Anṯeg, ip̱a ina daaṯe,’ o iiṯa ‘Anṯeg, laih up̱a uma daaṯe,’ ii amana. Aḏinu? Kayaknu ḏo maḏoḏ amu ag oolagp̱a daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","Awowa Jesus Nug eḏua, nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Geha dimp̱a haen laa uḏiebeb, ag am Danab Beḵalag da ele deḏ laip̱u oignignu oolag huanak daaḵu amge geha anam ii daamna. ");
INSERT INTO gaw_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","Am geha danab laala ag amelagp̱a inam aḵulag. ‘Anṯeg! Nug am laih up̱a uma daaṯe,’ o iiṯa, ‘Anṯeg! Nug am ip̱a ina daaṯe,’ aon aḵulag amge ag am aib dim lamadna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","Amemḏi awa amahalṯe amu ag dooṯeb. Amemḏi awa nuhig amahlak amu atu ohp̱a amahalṯe, loḵumak iiṯa. Am Danab Beḵalag da, geha dahil haenp̱a da ele loḵumak ii uḏipa amunu ag laa amu aib dim lamadna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","Amge tatam amu da guiṯak kuḏum aop̱i, danab haen gemu imunu amu ag da di meḏaglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","Nug anam anana amu Nug baula aum. “Amu danab ag kobol Noanu haenp̱a hep̱ig, anamib geha Danab Beḵalag da, dahil haenp̱a amu ag ele anam heḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","Haen amup̱a amu ag e lanana, le lanana, nug aona, ah ele nug medap̱ig. Ag anam henan daaegeg uḵe, haen Noa nug ub oop̱a noum batak. Ag anam heegeg, le hiḏ naḏi ba, danab ah amu ohnab diie padal mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","Amu Lotnu haenp̱a am ele anamib hep̱ig. Ag e lanana, le lanana, keeke daden menana, keeke danab laa maṯaeg, daden meegeg, e aona, lag buunna daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","Amge Lot nug Sodom uua uḵom, deḏ amup̱a amu ab aḏu hab aṯannu gu bia na, danab ah ewaṯe, padal mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","Amu geha Danab Beḵalag da amu, da dahil deḏp̱a miag beḵul amu danab dilag kobol am anamib daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","Amu deḏ amup̱a danab laa nug hik awak abenp̱a, lag aṯan daaṯe amu, agup̱a dayaya, nug oolḵunuib dab maama, nug nuhig keeke lag oop̱a daaṯe ele amu nug keeke amu aoḵunu lag oop̱a ii noma. Anamib danab laa nug daṯa dayaya amu nug oolḵunuib dab maama, keeke laa aoḵunu eḏua laḵa ii goma. ");
INSERT INTO gaw_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","Ag Lot wau daulagp̱a doaḏ! ");
INSERT INTO gaw_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","Am danab laip̱u laa nug wan imup̱anu bau dayak nuhig amu aḏaḵu, aria geha bauklel nuhig amu iiṯa meḵu amge danab laa nug wan imup̱anu bau dayak amu uuṯe am geha nug bauklel hanhan daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","Am da ag amelagp̱a aṯem, geha tuqan amup̱a danab aḏit laa niak aben laip̱up̱a niiglah am Kayak Nug laip̱u awawa, laa amu uuiṯeb daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","Am ah aḏit laa a aben laip̱up̱ bretnu plaua neḵunu hebep̱eḏ, am Kayak Nug laip̱u awawa, laa amu uuiṯeb daaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","Am geha danab aḏit laa daṯa daap̱eḏ am geha Kayak Nug laip̱u amu aoḵu, laa am uuiṯeb daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","Jesus Nug anam a, ag amu doona, ag ap̱ig. “Naḏi amuam geha adep̱a beḵu?” Ag anam aeg am Jesus Nug amelagp̱a aum. “Mauhak gaḏalag niiṯeb, aben amup̱a ai laa kaub bia uḏin, ap̱a qag meṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","Amu Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, ag haen oh unuqidḵulagnu, ag bahilag yaamanu ele amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","Amu Nug inam aum. “Amu ab oḵai laap̱a epeḏiak danab laa nug Kayaknu am keeke hamu doyaya, danab dilagnu ele dab ii madaṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","Am ah qab laa ab amup̱a ele dayom, nug haen oh uḏia amegp̱a aum. ‘Kekeḏ dahil nug da hip̱el qagaṯe amunu na da ehaniḏna, ug dahil babaiṯe!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","Ah amu nug anam heehe, epeḏiak danab nug laa ehanidḵunu amu kobol amu nug beḏup̱a ii daaṯom amge dimp̱a nug oop̱a aum. ‘Da Kayaknu am keeke hamu bia dooṯem amu danab dilagnu ele am da dab ii meṯem ");
INSERT INTO gaw_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","amge ah qab imu nug da duṯuniḏa heehe, da beḏul bahi ye amunu da nuhig nai amu da bap̱aidḵul. Iiṯa am nug eḏua uḏieb uḏieb, da oolp̱a nokuhkuh oḵai qeḵu amunu nuhig nai amu bap̱aidp̱i, uua goḵu,’ awa aum.” Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, nai amu maṯiom. ");
INSERT INTO gaw_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","Aria Jesus Nug nai amu maṯia mala, Nug nai tuḏiṯa aum. “Ag epeḏiak danab nau amu nuhig nai imu doyeg! ");
INSERT INTO gaw_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","Nug ah amu ehanidḵunu aum amu Kayak Nug danab ah nuhiḵud, Nug ag tituanaṯom ele amu, ag hanhan tuqan amun ele deḏ oh unuqidp̱ep̱eg amu Kayak Nug ag iite ehanadma? Nug am ag amelag maama, paha iite ehanadma? Anam iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","Amu da ag amelagp̱a aṯem. Nug am paha ag ehanadḵu. Amge Danab Beḵalag da, da eḏue uḏien, haen amup̱a geha ag wan danab ah amu ag oop̱a genab doyak ele anidḵultai,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","Am Jesus Nug danab laala ag aḵa ahilagnuib, “Igib danab tutuḵu,” anana amu ag danab laa dilagnu, “Ag nau, hip̱unin ele,” aon ap̱ig ele amu, Jesus Nug ag amelagp̱a keeke danab ag dooṯeb ii dooṯeb ele amu ou aqata, ip̱uanaṯa, nai imu maṯiom. ");
INSERT INTO gaw_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","Nug aum. “Danab aḏit laa a unuqidḵulahnu mana meṯak lag oop̱a teya daapiḏ. Laa amu ḏo gumak danab-Parasia. Laa amu takis awak danab. ");
INSERT INTO gaw_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","Amu ḏo gumak danab-Parasia nug hibaiṯa, aṯan neeḵa dayaya, nuḵa nuhignu unuqiṯa aum. ‘Kayak, da am danab laala oh bia iiṯa. Ag am yab aoṯeb, hak ena iiṯa heṯeb am gap̱ai ele heṯeb. Da am anam iiṯa, takis awak danab imu heṯe bia ele iiṯa amunu da na amenp̱a, “Ena heme,” aṯem. ");
INSERT INTO gaw_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","Am da haen oh meṯid laip̱u oop̱a deḏ aḏit amu e oh lanaknu kud mein dayeye amu da keeke aoṯem oh amu op̱ati, ameg eblaih tanig ele neeg, amu da na ameg laip̱u medaṯem,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","Nug anam aum amge takis awak danab nug am piḏe dayaya, dup noa, hab aṯan ii neeḵom. Iiṯa. Nug eheḏnab doyom amunu nug ep̱egp̱a gamag qeutata, nug aum. ‘Kayak, da am hip̱unin danab amunu na dahilnu oot gai iiṯa dooḵutnu oḏ medaṯem,’ awa aum.” ");
INSERT INTO gaw_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","Am Jesus Nug nai amu maṯiowa, Nug baula amelagp̱a aum. “Da ag amelagp̱a aṯem, Kayak he, takis awak danab nug tutuḵu daye, eḏua laugp̱a uḵom amge danab laa nug am anam iiṯa. Amunu laa nug onig humaṯe amu Kayak Nug heeb, danab amu nug onig neḵu amge danab nug onig qe neṯe amu Kayak Nug danab amu nug onig humaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","Amu danab ah ag nid yuḏ ahilḵad diiadna, Jesus Nug ep̱eg beḏulagp̱a ma, itiṯak madaḵunu gop̱ig amge nuhiḵud ip̱uniṯak awak danab ag amu anidna aladp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","Ag anam ap̱ig amge Jesus Nug nid naunau onilagp̱a e, gumidna doeg, Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Danab ag nid nakok bia daaṯeb, ag am Kayaknu ḏo maḏoḏ oop̱a daaṯeb amunu ag nid naunau uuadp̱eg, ag dahilp̱a doig! Ag ahilag ib aib oo nep̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","Anam anana Nug amelagp̱a aum. “Da genab ag amelagp̱a aṯem. Danab nug Kayaknu ḏo maḏoḏ nid nakok aoṯe amubia ii aoḵu amu nuhugnu ib laa iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","Aria Juda dilag iḵi laa nug Jesus inam oḏ meṯom. “Ip̱uniṯak danab ena, da aṯem heina, da bauklel hanhannu aoḵul?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","Anam a, Jesus Nug eḏua amegp̱a aum. “Kayak Nug nuḵa am ena amunu na dahilnu, ‘Danab ena,’ ame amu na nai amu tatam dab mewonate ame o iiṯa na hamute ame? ");
INSERT INTO gaw_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","Amge nahip oḏ maknu amu na ḏo oh dooṯem. Na gap̱ai aib heme. Na danab aib qep̱e mauhom. Na yabhoi aib heme. Na danab laanu ham bup̱uak nai aib maṯime. Na mamen anin ele oḏelah dim lamidna binalah me!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","Jesus Nug anam a amu Juda iḵi danab nug aum. “Da nid nakokp̱anu ḏo amu dim lamiṯi uḏie, gemu ele anamib heṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","Nug anam a, Jesus Nug nai amu doya, amegp̱a aum. “Keeke laip̱u amup̱aib na elele iiṯa. Na gona, na enun oh mep̱e, danab laala ag daden mep̱eg, na men doḏo amu oh aon, daḏek danab maṯona, na hab aṯan enun oḵai ele daaḵut. Na anam hewona, na uḏin dim lamiḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","Nug anam a amu iḵi danab nug nai anam doya, nug oo ugnab dayom. Aḏinu? Nug enub kuḏum ele. ");
INSERT INTO gaw_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","Amu Jesus Nug danab amu nug oop̱a ug doyom anṯa, Nug aum. “Danab ag enulag kuḏum ele amu ag Kayaknu ḏo maḏoḏ oop̱a goḵulagnu am ug oḵai ele. ");
INSERT INTO gaw_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","Amu kamel nug koitaknu tutui giḏop̱a noḵunu amu ug ele amge danab enub oḵai ele, nug Kayaknu ḏo maḏoḏ oop̱a goḵunu am ug oḵainab,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","Am danab ag nai amu doop̱ig ele ag ap̱ig. “Anam dayeb amu aun nug bauklel aoḵunu elele?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","Aeg amu Jesus Nug aum. “Keeke danab ag aḵa heḵulagnu elele iiṯa daaṯeb amu Kayak Nug heḵunu elele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","A amu Petrus nug aum. “Anṯe, ig ihinig keeke oh uuta, na dim lamidṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","Anam a, Jesus Nug eḏua, ag oh amelagp̱a aum. “Da genab ag amelagp̱a aṯem. Danab aun nug Kayaknu ḏo maḏoḏnu ha amu nug laug, nug anig mameg, nug laiḵud, nug wau, beḵod, aḏeḵud ele uuaṯa, da dim lamiḏṯe amu nug geha haen imup̱a hamu ii daama. Iiṯa, ");
INSERT INTO gaw_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","nug haen imup̱a keeke uua oiyom amu nob huana eḏaṯak awa amu dimp̱a haen uḏieb, nug bauklel hanhannu ele aoḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","Amu Jesus Nug nuhiḵud ip̱uniṯak awak danab tuelp diia, piḏe bia wana, amelagp̱a aum. “Doyeg, ig gemu iiḵu Jerusalem goṯem. Kayaknu propet ag anuḵa Danab Beḵalag da, dahilnu Kayak aum, oḏe madip̱ig, nai amu meu gemu miag beḵu. ");
INSERT INTO gaw_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","Ag geha da aiḏna, iiṯa aḏi ep̱elagp̱a meiḏp̱eg, ag aon aon iuna, guhuḏilna amu hunu iuglag. ");
INSERT INTO gaw_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","Amu ag da wipp̱a eheḏ mataḏilna, ag iup̱eg mauhḵul amge deḏ ewamp̱a da eḏuen hip̱aidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","Am Jesus Nug nai amu maṯiom amge ip̱uniṯak awak danab ag oolag ii maiṯom. Nai amu, diig nuhig amu ag oolagp̱a loḵumak dayom amunu ag Nug nai aum amu ag ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","Aria Jesus Nug uḵa, Jeriko guguiṯeṯe, danab ameg gaḏuak ele laa ib daugp̱a dayaya, danab ah men doḏo meṯaglagnu ewa unuqaṯaṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","Am nug anam haaha dayeye, danab ah ameg naḏi ag uḏiegeg doyaṯa, nug danab laala oḏ maṯa aum. “Umu ag aḏi diignu unam heṯeb?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","A amu ag nug amegp̱a ap̱ig. “Jesus, Nasaret ted, Nug uḏiṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","Ag aeg, nug doya, ewa aum. “Jesus, Dawit Beḵa, na dahilnu oot gai iiṯa doye!” anana eum. ");
INSERT INTO gaw_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","Am danab ameg laa anuqna gop̱ig ele amu ag nug aidna ap̱ig. “Na oḏen qamute!” aon ap̱ig amge nug eḏua, huanaknab ewa aum. “Dawit Beḵa, na dahilnu oot gai iiṯa doye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","Nug anam eewo, Jesus Nug doa hibaiṯa dayaya, amelagp̱a aum. “Ag nug aon, da gumiḏna doig!” awa aum. Nug anam a amu ag nug aon, Jesus gumidna doeg amu Jesus Nug oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","“Da nahipp̱a aḏi heḵulnu oot daaṯe?” awa aum. Awa a amu nug aum. “Naḏi, da neegḵulnu ool daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","Amu Jesus Nug amegp̱a aum. “Na amen eḏua op̱ateb, amahlak anṯe! Na dahilnu ootp̱a genab doome amunu na ena daaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","Anam aawo, pahanab nug ameg amu obata, ena daye, neeḵa amahlak anṯom. Aria nug geha aaḵu Jesus dim lamiṯa uḵa, Kayak binag meum. Danab ah ag amu anidna, ag ele Kayak binag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","Amu Jesus Nug tutuḵu noa, Jeriko oop̱a ugeḵe, ");
INSERT INTO gaw_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","am danab laa ap̱a dayom, nug onig amu Sakeus. Nug am danab takis aoṯeb amu dilag iḵi. Danab amu nug enub oḵai ele. ");
INSERT INTO gaw_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","Amu nug Jesus Nug am danab aṯemunab anṯa dooḵunu oo dayom amge danab ah ameg naḏi Jesus qehaḵeg, Sakeus nug ele am danab tutu amunu nug Jesus anidḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","Elele iiṯa amunu Jesus Nug ib amup̱a uḏiṯe doyom amunu nug qaibaḏ anuqa uḵa, Jesus anidḵunu ha, ad sikimon laa teum. ");
INSERT INTO gaw_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","Amu Jesus Nug uḵa uḵa, Sakeus dayomp̱a ta, baeg ya dayaya, ameg huma aṯan neeḵa, nug amegp̱a aum. “Sakeus na paha ne! Gemu da na lautp̱a daaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","Nug anam aum amunu Sakeus nug oo gamag ahe, paha honap na, Jesus omale nug laugp̱a gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","Am Jesus Nug Sakeus laugp̱a goya daaeheh, danab oh ag amu anidna, ag aḵa naituḏ maṯin Jesusnu ap̱ig. “Nug uḵa, hip̱unin danab umu laugp̱a ḏo danab daaḵunu teum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","Aria Sakeus aha hibaiṯa, Jesus amegp̱a aum. “Naḏi, gemu da dahil keeke oh amu gamagp̱anab op̱aten, laih awe, daḏek danab madaḵul. Amu da danab laa ham bup̱uiṯen, nuhig keeke yab aomi dayeb amu aria da amu eḏuen, nob amu tuḏiṯen, ewam laa ele nug medaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","Anam a, Jesus Nug Sakeus amegp̱a aum. “Gemu Kayak Nug lag imup̱anu danab ah eḏua diiom. Danab imu ele amu nug Abraham beḵa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","Anam anana, Nug nai tuḏiṯa aum. “Danab Beḵalag da amu da danab ag padal mep̱ig daaṯeb ele, da ag eḏuen diiadḵulnu uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","Jesus Nug Sakaeus laugp̱a dayaya, nai amu maṯie doyeg, Nug Jerusalem guguiṯa dayeye, danab ah ag, “Kayaknu ḏo maḏoḏ am geha iiḵu miag atiḵu,” dab menan doop̱ig amunu ag anam dab memananu, Jesus amu Nug nai tuḏiṯa, keeke danab ag dooṯeb ii dooṯeb ele amu ou aqata, ip̱uanaṯa, inam maṯiom. ");
INSERT INTO gaw_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","Nug maṯia aum. “Wan laap̱an gumak danab laa nug aha, wan laap̱a uma uḵeb, geha ag nug ahilag oḵai daaḵunu mep̱eg, dimp̱a amu nug eḏua uḏia, uḏat aḏit amu oh heḵunu dab meum. ");
INSERT INTO gaw_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","Nug anam dab maama aria nug nuhiḵud uḏat danab eblaih tanig ele onilagp̱a ewowa, nug am siks handat kina anen anen anam pania madaṯa, amelagp̱a aum. ‘Ag imu tuḏidna, qag mebep̱eg, da eḏue uḏip̱i, meḏap̱eg aoḵul,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","Amge nug mudip̱an laiḵud ag anuḵa ag oolagp̱a nuhignu nau, ninig ele doop̱ig amunu nug uḵe, am danab laala ag heeg, ag oolagp̱an danab laa ag nug dim lamidnana amu ag inam ap̱ig. ‘Ig am danab imu nug ihinig king daaḵunu amu ig oonig ii daaṯe,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","Ag anam ap̱ig amge wan laap̱a ag nug king meeg, dimp̱a nug eḏua uḏia, nug wanebp̱an danab amelagp̱a aum. ‘Uḏat danab anuḵa da men doḏo maṯami ele amu onilagp̱a ep̱eg, ag oh anen anen men doḏo amu tuḏidna tuḏiṯak gane aop̱ig amu da dooḵul,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","Eeg dona amu danab laa ba nug aum. ‘Naḏi, da siks handat kina nahip imu bau laa tuḏiṯe qag mein, tuḏiṯak siks tausen kina aomi,’ awa a am king nug amegp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","‘Na uḏat danab ena, na uḏat enanag heme, na keeke nakoknab dab meṯan autna aome amunu gemu da na ab oḵai ten gumadḵutnu g̱agaṯag medaṯem,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","Aria laa dim ba aum. ‘Naḏi, da siks handat kina nahip imu bau laa tuḏiṯe qag mein, tuḏiṯak tri tausen kina aomi,’ awa a, king nug amegp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","‘Da na ab oḵai tanig ele gumadḵutnu g̱agaṯag medaṯem,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","Amu uḏat danab laa nug aum. ‘Naḏi, nahip siks handat kina amu ina daaṯe. Da lamen qaṯi laa oop̱a iten mei dayom. ");
INSERT INTO gaw_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","Aḏinu? Da na anidṯem, na danab g̱agaṯag ele, danab laa nug keeke me daaṯe amu na aona, danab laa e ep̱om amu na amunu meu ele aoṯem. Amunu da nahipnu baḏami,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","A amu king nug nid amu amegp̱a aum. ‘Na uḏat danab nau, bodo eṯaknab. Amu da na naḵa nahip nai amup̱a na epeḏidḵul. Amu genabnabte na doome, da am danab g̱agaṯag ele? Amu keeke oh danab laala meeg, da aoṯem amu danab laala e ep̱aeg, da hiḏaṯem, da anam heiyi doomete? ");
INSERT INTO gaw_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","Na genab da am danab g̱agaṯag doolom amu na da baḏilna, na men doḏo dahil amu benkp̱a melom, dimp̱a da eḏue uḏien, men doḏo amu, am nuhig tuḏuiṯak ena ele aolom amge na anam ii heme,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","Nug anam anana amu nug danab guguiṯak hip̱aidna daaegeg amelagp̱a aum. ‘Ag nug ep̱egp̱a siks handat kina daaṯe amu aḏidna aon, danab laa siks tausen kina ele amu meṯeg!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","Nug anam a amu ag ap̱ig. ‘Naḏi nug am siks tausand kina awa aḏate,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","Anam aeg nug aum. ‘Da ag amelagp̱a aṯem, danab nug keeke aḏate ele amu da baula ele medaḵul amge danab laa nug keeke nakok tatam awom aaḵuib aḏeb amu da aḏidḵul,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","Gumak danab amu nug anam anana, nug nai tuḏiṯa aum. ‘Aria laa ag da kekeḏ meḏan, da ahilag king daaḵulnu uup̱ig ele amu ag diin, da noolp̱a ip̱a dona, aqap̱eg mauheg!’ awa aum.” ");
INSERT INTO gaw_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","Amu Jesus Nug nai amu maṯia malowa, Nug aha anuqa, Jerusalem ukaknu ib awa uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","Nug uḵa Betpasi, Beṯani ele guḵuata, ab aḏit amu a qauko Olip ele aṯeb, qauko amu guguiṯak amu, ap̱a nug he, nuhikuḏ ip̱uniṯak awak danab aḏit laa anuqya goḵulahnu aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","Nug a amelahp̱a inam aum. “A goya, ab nakok miag amup̱a teya, ap̱a ab daugp̱a a donki nag laa nakok oḵai meum ele amu, qaḵak daaṯe anidḵulah. Anuḵa danab laa amu aṯan ii oiyom ele. A anidya amu a uhuqya aoya uḏieḏ! ");
INSERT INTO gaw_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","A anam aop̱eḏ amu danab laa, ‘Aḏinu a donki amu uhuqṯep?’ awa oḏ maṯeb amu aria a nug amegp̱a inam aiḏ! ‘Naḏi Nug nuhignu uḏat ele amunu i uhuqṯeb,’ aḵulah,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","Jesus Nug danab aḏit otiatom ele amu a goya, keeke oh a amelahp̱a aum ele amu anidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","Anidya, a donki qaḵak, muḏi amu uhuqeheh, donki mameg ag a oḏ matan ap̱ig. “Aḏinu a donki nag bau amu uhuqṯep?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","Aon aeg amu a apiḏ. “Naḏi Nug nuhignu uḏat ele,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","Aria a donki amu aoya, Jesus gumidya uḵaeh, ag lamen ulahnu ahilag aon, donki gomep̱a duqona amu Jesus ehaniṯeg, donki aṯan ta dayom. ");
INSERT INTO gaw_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","Am Jesus Nug donki aṯan ugeḵe, danab ah ag lamen ulahnu ahilḵad aḵan ibp̱a duqadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","Am Jesus Nug uḵa, ib laih qauko Olip amu eḏiṯa no amu nuhiḵud ip̱uniṯak awak danab kuḏum laa ele ag oh nuhignu gamalag ahom. Aḏinu? Nug uḏat danab heḵunu elele iiṯa kuḏum he anidp̱ig amunu ag baalag oḵaip̱a enan Kayak binag humap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","Ag Kayak binag human, baalag oḵai enan ap̱ig. “Ig king binag metu, Nug Naḏi onigp̱a uḏiṯe! Kayak Nug itidṯe. Nuhigp̱a Kayak Nug ig danab, ihinignu oo ena daaṯe. Ig Kayak Ebehi Ele, Nug binag aṯannab humatu.” ");
INSERT INTO gaw_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","Ag anam heegeg, Juda dilag ḏo gumak danab-Parasia ag danab ah ameg amu oolagp̱a daanna, ag Jesus amegp̱a ap̱ig. “Ip̱uniṯak danab, na nahipad ip̱uniṯak awak danab amelagp̱a ap̱e, ag to eṯeg!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","Aon aeg amu Jesus Nug ag anam ap̱ig amunu amelagp̱a aum. “Da ag amelagp̱a aṯem, imu ag oḏelag qamutp̱eg, aria men amu ag eḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","Anam anana Jesus Nug uḵa, Jerusalem guguiṯa wana, Nug ab oḵai amu anṯa, ameg leb ne, ");
INSERT INTO gaw_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","Nug aum. “O gadon, ag maḏoḏ daaglagnu ib ii dooṯeb. Ug awak haen ahilag am miagnab amge ag aṯemun maḏoḏ daaglagnu ib amu anidlob, ag ug amu ii anidlob amge ib amuam ag amelagp̱a loḵumak daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","Amunu ag doyeg! Geha dimp̱a haen amu uḏieb, ahilag kekeḏ ag aqaglagnu uḏin, talilidna, wan buup̱eg uḵeb amu qalana wana, ag aben ohp̱a ag oo maṯan autanab aoglag. ");
INSERT INTO gaw_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","Amu geha kekeḏ, ag amu ag buḏulḵad ele, ag tap̱aladna oḏoḏadna autna aoglag. Abnu aḏ, lag ele menp̱a hep̱ig amu kekeḏ ag men laip̱u uup̱eg abenp̱a ii daama. Kayak Nug ag Juda ehanadḵunu heum amge ag amu ii doop̱ig amunu kekeḏ ahilagnu ag anam heḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","Amu Jesus Nug mana meṯak lag oop̱a noa, nug danab lag amu oop̱a mana meṯaknu keeke dadennu maadp̱ig amu, Nug dig ma ag lamaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","Nug amelagp̱a inam aum. “Kayak naip̱a yak inam daaṯe. ‘Da laul amu unuqiṯak lag,’ amge ag heeg, yabhok danab dilag loḵumak aben bia daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","Nug anam hewowa amu Nug deḏ oh mana meṯak lag oop̱a noa, danab ah Kayak nai ip̱uanaṯom. Nug anam heehe amu mana meṯak danab oḵai amu ḏo mehuqak danab am danab ah gumaṯak iḵi ele ag ahan, Nug qep̱eg mauhḵunu ib madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","Amge danab ah oh ag nuhig nai dooglagnu wagai mena hep̱ig amunu iḵi danab ag Nug qep̱eg mauhḵunu ib laa ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","Am deḏ laa Jesus Nug mana meṯak lag oop̱a danab ah nai ip̱uanaṯaṯa, Nug Nai Ena amelagp̱a mehuqeqe, mana meṯak iḵi danab amu ḏo mehuqak danab am Juda dilag iḵi danab ele ag Jesus gumidna gona, ");
INSERT INTO gaw_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","Nug amegp̱a inam ap̱ig. “Na ap̱e ig dootu! Na g̱agaṯag aḏip̱a uḏat imu heṯem? Danab aun nug g̱agaṯag amu meṯom?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","Amu Nug ag ap̱ig amu nob ma amelagp̱a inam aum. “Amu da ele keeke laip̱unu ag oḏ madap̱i amu ag ap̱eg dooḵul. ");
INSERT INTO gaw_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","Oḏ mak dahil am inam. Johanesnu layaṯak am adep̱anu beum? Keeke amuam hab aṯannu keeke o iiṯa amuam danabnu keekeib?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","Am Jesus Nug anam oḏ maṯe aria ag aḵa aḵa maṯin ap̱ig. “Ig, ‘Habnu keeke,’ ap̱ut amu Nug, ‘Anam amunu ag aḏinu oolagp̱a genab ii doop̱ig?’ awa aḵu. ");
INSERT INTO gaw_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","Amge ig, ‘Danabnu keeke,’ ap̱ut am geha danab oh ag Layaṯak Johanesnu, nug am propet, oolagp̱a genab dooṯeb amunu ag menp̱a iqaglag,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","Ag aḵa anam anana, ag Jesus aum amu nob mena ap̱ig. “Ig ii dooṯem,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","Aeg am Jesus Nug amelagp̱a aum. “Aaḵu amunu da ele g̱agaṯag aḏip̱a uḏat heṯem amu ap̱i ii doomna,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","Jesus Nug anam awowa, Nug dig ma keeke danab ag dooṯeb, ii dooṯeb ele ou aqata, ip̱uanaṯa, danab ah amelagp̱a maṯia inam aum. “Danab laa nug grep dad ep̱om. Nug grep dad ep̱owa amu awa, uḏat hak danab ep̱elagp̱a mewowa amu nug aha laih umanab uḵa, haen elab dayom. ");
INSERT INTO gaw_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","Am nug ap̱a dayeye, grep meu awak haen be, nug begbeg nuhig me, nug uḏat danab grep meu laih, danab oḵainu aoḵunu gumaṯa uḵom amge danab dad amup̱a uḏat hep̱ig ele ag uḏat nid amu maḵuḏna, geḏidna lamiṯeg, hamu eḏua uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","Am dad mameg nug begbeg laa he, gumaṯa uḵom amge ag nug ele eheḏ maḵuḏna, kobol eheḏ laala nuhigp̱a hewona, ag lamidna geḏiṯeg, hamu eḏua uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","Aria nug begbeg laa me uḵom. Amu ag ahan qena, guiṯak oḵai meṯona, aon dad dimiṯim buḏieg uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","Ag anam heeg, dad mameg nug aum. ‘Geha da aḏitai heḵul,’ awa aum. Nug anam anana amu nug aum. ‘Nid danab dahil, da nuhignu ool mauhṯe ele amu, da nug mep̱i goḵu. Uḵeb geha ag nuhig nai amu dooglagtai,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","Amge danab dad amup̱a uḏat heṯeb ele, ag nug beḵa amu uḏieye anidna, ag aḵa aḵa nai maṯina ap̱ig. ‘Nid umu nug geha dimp̱a mamegnu keeke oh aoḵu amunu ahap̱eg, ig nug qep̱ut mauheb amu ig dad imu aognig,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","Ag anam awona, ag ahan, beḵa amu aḏan buḏieg, grep dad dimiṯim uḵe, ag qeeg mauhom,” awa aum. Jesus Nug anam awowa, Nug nai tuḏiṯa aum. “Aria ag anam hep̱ig amunu grep dad mameg nug ahilagnu aḏi heḵu? ");
INSERT INTO gaw_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","Nug inam heḵu. Nug aha uḵa, nuhig dad hak danab amu oh aqeb mauhp̱eg, nug grep dad amu eḏua awa, danab laala ep̱elagp̱a meḵu,” awa aum. Am Jesus Nug nai amu maṯie, ag doyona ap̱ig. “Keeke anam amu aib beum!” ");
INSERT INTO gaw_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","Ag anam ap̱ig amge Jesus Nug ag neeḵaṯaṯa aum. “Anam amunu Kayak naip̱a yak daaṯe am aḏi ip̱unigṯe? Nai amuam inam. ‘Men laa, uḏat danab ag men amu uup̱ig amge lag mameg nug men amu awa, lagnu men anuqak me daaṯe.’ Nai amu diig am aḏi? ");
INSERT INTO gaw_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","Am laa nug men amu aṯan na qeḵu amu nug nakok nauhḵu amge men amu nug laa qaḏep̱a na qeḵu amu nug nauha auta aoḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","Amu mana meṯak iḵi danab amu ḏo mehuqak danab ele ag Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯak nai amu ag eheḏ hak ahilag anidḵulagnu maṯiom doona, ag haen amup̱anab ahan aḏaglagnu ib madip̱ig amge ag danab ah dilag baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","Aria ag Jesus meidnana daanna heeg, ameg qaḵak danab laala ag ahan gumidna gop̱ig. Ag gona, Nug amegp̱a danab tutuḵu bia daanna, ag nuhig nai maṯiak amup̱a, ag ib laa anidna, aon gabmannu heṯoḏiak ep̱egp̱a meḵulagnu hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","Ag inam oḏ medap̱ig. “Ip̱uniṯak danab, ig dooṯem, nahip nai am genab tutuḵu, na nai genabib danab ah ip̱uanadnana amu na danab oḵai onig ele o danab onig iiṯa amu na amu dab menan, na nai baolin, ag amelagp̱a ii madiṯem. Iiṯa. Na danab ah Kayaknu nai ena tutuḵuib ip̱uanadṯem. ");
INSERT INTO gaw_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","Amunu na keeke imu ap̱e doognig. Na aṯem dooṯem? Ig takis Kaisa meṯagnig am ena o ena iiṯa?” aon oḏ medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","Amge Jesus Nug ahilag ameg qaḵak oḏ mak amu matu doyom amunu nug amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“Ag men doḏo laa onig danarius ip̱uniḏp̱eg anṯei!” awa aum. A amu ag men doḏo ip̱uniṯeg anṯa, Nug oḏ maṯom. “Men doḏo amup̱a amu aun onig doṯog ele daaṯe?” Nug anam awa oḏ maṯe ag ap̱ig. “Amu Kaisanu,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","Anam aeg, Nug ag amelagp̱a aum. “Aria ag Kaisanu keeke amu Kaisa meṯaglag amge ag Kayaknu keeke amu Kayak meṯeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","Ag nuhignu ameg qaḵak hep̱ig amu ag Nug danab ah noolagp̱a amu Nug nai laa ii eṯom. Nuhig nai amu ahilag ameg qaḵak nai eḏiṯom amunu ag dab mak kuḏum aona, nai laa ii madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","Amu dimp̱a amu ḏo gumak danab-Sadusi ag Jesus top̱a uḏip̱ig. Danab amu ag, “Danab mauhṯeb ag eḏun ii hip̱aidmana,” aon adap̱ig amunu ag ");
INSERT INTO gaw_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","Jesus oḏ meṯan ap̱ig. “Ip̱uniṯak danab, Moses nug ihinignu nai laa inam yom. ‘Danab laa nug ah awa, nug nid laa ii awa mauheb, amu aria nug amag nug ah amu aweb, nid menuglah amge a nid menuglah amu nid amuam danab amu nuhig nid iiṯa, awagnu daaḵu.’ Moses nug anam yom. ");
INSERT INTO gaw_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","Aria amu e amaḵud eblaih aḏit ele ag daap̱ig. Ag anam daanna, awalag tatamnu nug ah awa, nug nid iiṯa mauhom. ");
INSERT INTO gaw_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","Mauhe amag nug aha, ah amu awom amu nug ele nid iiṯa mauhom. ");
INSERT INTO gaw_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","Dimp̱a amalah laa eḏua ah amuib awom amge nug ele nid iiṯa mauhom. Anamib e amaḵud eblaih aḏit ele ag oh ah laip̱u amuib aop̱ig. Ag oh ah laip̱u amuib aop̱ig amge ag nid laa ii aop̱ig, hamu mauhadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","Ag mauheg, dimp̱a ah amu ele nug mauhom. ");
INSERT INTO gaw_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","Aria eamaḵud amu oh ag ah amu aaḵuib aweg, nug ag waalag dayom amunu eḏua hibaiṯak haenp̱a ah amu nug eamaḵud eblaih aḏit amu ag oolagp̱a aunnab wau daaḵu? Ah amu nug danab eblaih aḏit amu oh ahilag ah dayom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","Ag anam aeg amu Jesus ag amelagp̱a aum. “Danab ah gemu haen imunu amu ag ewau daaglagnu nug aoṯeb ");
INSERT INTO gaw_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","amge dimp̱a Kayak Nug danab ah haen amu daaglagnu elele anaṯeb, ag eḏun hip̱aidna amu danab ag ah ii diimna, ah ele ag danab ii diimna. Iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","Ag engel bia daaglag amunu ag mauhḵulagnu elele iiṯa. Ag eḏun hip̱aidna daaglag amunu ag am Kayak beḵod. ");
INSERT INTO gaw_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","Amu Moses nug ele danab mauhp̱ig eḏun hip̱aidḵulagnu ad nakok ab ewewe, ii iiṯa meum, kaya amup̱a nug amu ip̱unigṯe. Moses nug haen amup̱a Naḏinu amu, ‘Nug am Abrahamnu Kayak, Isaknu Kayak, Jakopnu Kayak ele,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","Anam aum amunu ig dooṯem, danab ewam amu ag gemu daaṯeb. Ag mauhp̱ig amge ag iiṯa ii mep̱ig amunu Kayak Nug danab daaṯeb dilag Kayak daaṯe amunu Nug ele heeb, ag eḏun hip̱aidḵulag. Amu Kayak Nug nuhig dab makp̱a danab oh bau daaṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","Am Jesus Nug anam a amu ḏo mehuqak danab laala ag, “Ip̱uniṯak danab na ena ame,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","Amu ag Nug baula keeke laanu oḏ meṯaglagnu ib iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","Anam dayeye amu Nug ag amelagp̱a aum. “Laa ag, ‘Kayak Nug laa tituanom, amuam Kristus, Nug am Dawit beḵa?’ aon aṯeb amge ag aṯem doona, anam aṯeb? ");
INSERT INTO gaw_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","Dawit nug nuḵa buk Samp̱a amu inam yom. ‘Kayak Jehowa Nug dahil Naḏi amegp̱a inam aum. “Na da ep̱el naḏiapp̱a daap̱e uḵeb, ");
INSERT INTO gaw_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","da nahip kekeḏ na waatp̱a maadḵul.” ’ ");
INSERT INTO gaw_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","Ag iiḵud anṯeg! Danab nug, nug beḵanu, ‘Naḏi,’ ii aṯe amge Dawit nug, nug beḵanu, ‘Naḏi,’ aum amunu ig aṯemun Kristusnu, ‘Nug am Dawit beḵaib,’ aḵunig?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","Amu danab ah oh ag daanna, Jesusnu nai doyegeg, Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“Ḏo mehuqak danab ag lamen enanag elab ele taḵan, danab ah noolagp̱a oiglagnu oolag anuqak dayeye, e oḏiak abenp̱a danab ah ag humadḵulagnu oolag oḵai ele daaṯe. Ag nai doyak laḵa, amu hobul haenp̱a ele amu ag aben anuqakp̱a daaglagnu iṯag aqaṯe amge ag dahilad amu, ag ahilag kobol amubia hemananu dab meig! ");
INSERT INTO gaw_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","Ḏo mehuqak danab amu ag ah qab ham bup̱ualadna, ag laulḵad yab awona, ahilag hip̱unin amu danab ah amelagp̱a loḵumḵulagnu ag unuqiṯak elab heṯeb amunu epeḏiak haenp̱a geha ag ug oḵainab aoglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","Jesus Nug mana meṯak laḵa dayaya, Nug anam awowa, Nug neeḵa dayeye amu danab ah ag men doḏo, ahilag kolekta, kunupp̱a meegeg anaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","Am nug ah qab daḏek ele, nug men doḏo aḏit, wan toea bia, kunupp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","Nug me, Jesus Nug aum. “Da genab ag amelagp̱a aṯem, ah qab daḏek ele imu, nuhig men doḏo meum amu danab laala mep̱ig ele, amu oh eḏadṯe. ");
INSERT INTO gaw_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","Aḏinu? Laa oh ag men doḏo kuḏum amu ag laih nakok amup̱an aon mep̱ig amge ah imu nug amu men doḏo nakoknab nuhig, nug ehanidḵunu dayom amu oh meum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","Amu dimp̱a ip̱uniṯak awak danab laala ag mana meṯak lagnu nai inam madip̱ig. “Ag mana meṯak lag imu hep̱ig ele amu, ag men enap̱a heegeg, danab ah ag keeke ena Kayak medap̱ig ele, keeke amup̱a bala enanag medap̱ig,” aon ap̱ig. Ag anam aeg, Jesus Nug aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","“Gemu keeke imu oh ag anidṯeb amu haen laa ana beeb, men imu ag lop̱aḏp̱eg, nena qena, laa nug laa qaḏep̱a iinab daama. Ohnab lop̱aḏp̱eg, honap nena qeḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","Nug anam a, ag Nug oḏ medap̱ig. “Ip̱uniṯak danab, na ig amenigp̱a ame amu kobol amu haen ganeb beḵu? Amu ele ep̱onak keeke aḏi tatam beeb, ig doognig, ug aaḵu beḵunu miag daaṯe?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","Ag anam aeg, Jesus Nug aum. “Laa ag ham bup̱ualadmanu, ag dab meig! Aḏinu? Danab kuḏum ag da onilp̱a uḏin, ‘Da amu Kristus,’ anana, ‘Haen miag aaḵu doum,’ ele aon aḵulag amge ag ahan, ag aib dim lamadna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","Am ag bannu doonna amu ag ab iḵi iḵi ag ahan ban heṯebnu nai amu ele dooglag. Keeke amu genab beḵulag amge doyeg, ag aib oṯaip̱ig. Wan haen malak iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","Anam anana Nug amelagp̱a ele aum. “Danab beḏulag laa amu ag danab beḏulag laa ele nug qeḵulag. Wan laa amu wan laa ele nug qeḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","Aben laalap̱a amu mim oḵai nebep̱eg, enug haen oḵai amu oḏe haen naḏi ele beḵulag. Habp̱a amu ep̱onak keeke oḵai oḵai keeke diigdiig ena iiṯa ele beḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","Amge keeke amu oh ii bebep̱eg, geha danab laa ag ahan, ag dahilad amu ag ag aḏualadna, ag eheḏ hadna, nai doyak laḵa ap̱a dimulag mena, diin mani guiṯakp̱a maadḵulag. Da onil ahilagp̱a daaṯe amunu ag diin, king gabman ele noolagp̱a maadp̱eg, epeḏiadḵulag. Da onil ahilagp̱a daaṯe amunu ag kobol amu ahilagp̱a heḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","Ag epeḏiadp̱eg amu haen amup̱a ag dahilnu nai ena ag amelagp̱a mehuqḵulagnu elele daanna, ag anam heḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","Nug anam anana, Nug nai tuḏiṯa aum. “Ag nai amu nob aṯem aḵulagnu aib ug aqeb, dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","Geha da daḵa ag nai aḵulagnu oḏelagp̱a mein, dab mak ena ele madaḵul. Geha kekeḏ ahilḵad ag da nai madaḵul amu otaḏna tabap̱eg noḵunu ele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","Haen amup̱a ag mamelḵad, anilḵad, awalḵad, amalḵad, lailḵad, buḏulḵad ele amu, ag geha ag diin, kekeḏ ep̱elagp̱a maadḵulag. Amu geha ag oolagp̱anu laala aqap̱eg mauhḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","Am geha danab oh ag oolagp̱a ahilagnu nau, ninig ele dooglag. Aḏinu? Da onil ahilagp̱a daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","Ag anam heḵulag amge ag dahilad amu ag iḵilag uḏug laip̱u laa ii qeṯoḏma. ");
INSERT INTO gaw_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","Ag g̱agaṯag daan, bauklel hanhannu aoglag! ");
INSERT INTO gaw_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","Amge dimp̱a haen amunu ami amu laa ag uḏin, Jerusalem talilidp̱ep̱eg, amup̱a ag dooglag, ab oḵai imu he nauhaknu haen aaḵu miag daaṯe. ");
INSERT INTO gaw_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","Am haen amup̱a Juda danab ah ag oolna qaukop̱a uḵeg! Amu danab Jerusalem oop̱a daaṯeb amu ag ab uun laih uḵeg! Danab ab dimiṯim daanna, ag eḏun oop̱a ii nomana. ");
INSERT INTO gaw_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","Aḏinu? Haen amu Kayak Nug ahilag eheḏ hak nob eḏua madaḵu. Kayak naip̱a nai daaṯe amu, nai amunu meu beḵu. ");
INSERT INTO gaw_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","Amu haen amup̱a ah oolag ele, ah ag nid yuḏ huh madaṯeb ele amu, ahilagnu gadonnab. Aḏinu? Haen amu ug oḵainab wan imup̱a beḵu amu Juda danab ah haen amup̱a ag hip̱uninnu bu aqak, Kayak ep̱egp̱anu uḏiṯe amu, ag amu aoglag. ");
INSERT INTO gaw_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","Geha laala ag qep elabp̱a mauhḵulag am laala, ahilḵad kekeḏ, ag ag diin gona, danab ah ameg laa ohnu oolagp̱a maadp̱eg daaglag. Amu iiṯa aḏi ag uḏin, Jerusalem aon daana, Jerusalem nug ag waalagp̱a dayeb, uḵeb uḵeb, ahilag haen, Kayak tituanom, amu maleb amu malaḵu. ");
INSERT INTO gaw_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","Dimp̱a kobol aḏi iḏu iḏu aam, kalam, hoḏop̱ai elep̱a heebeb amu wanp̱a danab ah ameg ohp̱a ag oolag huan oṯaiebeb, yup̱a duban oḵai koḏkoḏ qeebeb amunu baḏaglag. ");
INSERT INTO gaw_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","Geha danab ah kuḏum ag keeke wanp̱a beḵu amunu dab menana, ag oolag huan baḏeb, amelag uu edaḵu. Aḏinu? Habp̱an hoḏop̱ai ag uḏalnana, ag ip̱ulag tutuḵu ii dim lamidmana. ");
INSERT INTO gaw_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","Ag anam hebep̱eg, Danab Beḵalag da, da lombigp̱a g̱agaṯag oḵai amahlak oḵai ele uḏip̱i aniḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","Dimp̱a keeke amu beḵunu dig ma heebeb, haen amup̱a ag ahan goḵulagnu babaiṯeg! Kayak Nug ag eḏua diiḵunu aaḵu miag daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","Jesus Nug nai amu amelagp̱a maṯiowa amu Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqata, ip̱uanaṯa, maṯia aum. “Ag ad pig, ad laala ele dab menan anṯeg! ");
INSERT INTO gaw_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","Ag uḏulag bau haulegeg anadna amu ag, ‘Aam haen ena dig meṯe,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","Ad uḏug bau beḵulagnu dig men haulṯeb anidna, ag, ‘Aam haen ena miag daaṯe,’ dooṯeb amubia ag kobol diigdiig oh, da ami ele, amu bebep̱eg anidna ag, ‘Kayaknu ḏo maḏoḏ aaḵu miag doum daaṯe,’ dooglag. ");
INSERT INTO gaw_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","Da genab ag amelagp̱a aṯem, danab ah haen imunu oh ii mauhadp̱eg, geha keeke amu oh beḵu. ");
INSERT INTO gaw_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","Amu hab wan ele iiṯa meḵulah amge nai dahil amu iiṯa iinab mema,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","Jesus Nug anam anana, Nug nai tuḏiṯa aum. “Keeke amu beḵun daaṯe amunu ag daulag atieb, ag hanhan e lanaknuib hik aqeb, le g̱agaṯag labep̱eg, kaaka aqebeb, beḏu ena dayak amunu guaṯebeb hebep̱eg, kobol amuib aha ag tonadmanu tutuḵu dab meig! Kobol amu ag tonaṯeb, Naḏinu deḏ amu paha eṯak, doḏ pelemp̱a noṯe bia ag anadḵu. ");
INSERT INTO gaw_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","Amu deḏ amu danab ah oh wan ohp̱a daaṯeb ag beeb anidḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","Amunu ag hanhan tutuḵu dab mena daanna, keeke amu oh anidmananu amu ag Danab Beḵalag da, da noolp̱a hip̱aidḵulagnu elele daaglagnu ele unuqiṯeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","Deḏ oh Jesus Nug mana meṯak lag oop̱a ag nai ip̱uanaṯaṯa, tuqan amu Nug uḵa, qauko laa onig Olip amup̱a niiṯom. ");
INSERT INTO gaw_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","Nug anam heehe, danab ah oh ag buṯuanab ahan, ag nai dooglagnu mana meṯak laḵa uḏiṯap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","Aria meṯid hobul laa, hobul amup̱a ag bret yis iiṯa laṯeb, hobul amuam onig Pasowa, amu beḵunu miag dayeye, ");
INSERT INTO gaw_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","mana meṯak danab oḵai, ḏo mehuqak danab ele ag danab ah baḏadna ap̱ig. “Ig aṯem heta, Jesus qep̱ut mauhḵu,” aon madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","Ag anam maṯieg amu Satan nug Judas Iskariot, nug oop̱a noum. Nug amu ip̱uniṯak awak danab tuelp amunu laip̱u. ");
INSERT INTO gaw_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","Satan nug oop̱a no amu Nug uḵe, mana meṯak danab oḵai, mana meṯak lag gumaknu daup iḵi aḏi ele nug ib adeḵup̱a Jesus awa, ag ep̱elagp̱a meḵunu nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","Nug anam he, ag gamalag ahe, men doḏo laa meṯaglagnu nai qagap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","Ag anam aeg, Judas nug men doḏo aoḵu amunu oo ena dayeye, nug deḏ laa danab ah ameg naḏi ag Jesus ele ii daap̱eg, nug Jesus awa, danab nug ele nai madip̱ig amu ag ep̱elagp̱a meḵunu ib maṯiom. ");
INSERT INTO gaw_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","Aria Pasowa meṯid hobulnu babaiṯaknu deḏ beum. Kayak Nug anuḵa ag deḏ amup̱a Pasowanu sipsip naḵud aqaglagnu ḏo meum. ");
INSERT INTO gaw_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","Amu deḏ amu be, Jesus Nug Petrus Johanes ele he uḏieh, amelahp̱a aum. “A goya, Pasowa ihinig bap̱aidpeḏ, ig laḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","Nug anam a amu a Nug amegp̱a apiḏ. “Adep̱a bap̱aidḵunihnu oot daaṯe?” aoya oḏ medapiḏ? ");
INSERT INTO gaw_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","Oḏ meṯaeh, Nug amelahp̱a aum. “Doyeḏ! A goya, ab oḵaip̱a nopeḏ, danab laa nug nip̱ud, le am bak ele, amu mawa doa, a uḏalah teeb amu a nug dim lamidpeḏ, nug lag laa oop̱a nob amu a lag amup̱a ele noiḏ! ");
INSERT INTO gaw_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","Noya lag mameg amegp̱a inam aiḏ! ‘Ip̱uniṯak danab ihinig Nug nahipnu inam aum. “Da dahilad ip̱uniṯak awak danab ele ig na lautp̱a oo aṯenp̱a Pasowa laḵunig?” ’ aoya aḵulah ");
INSERT INTO gaw_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","A anam ap̱eḏ, geha nug lag oo oḵai aṯan, balal dayak aben ele ip̱uanateb, a lag oo amup̱a Pasowanu e babaiṯeḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","Aria a goya, Jesus amelahp̱a aum amubiaib anidya, a amup̱a aaḵu Pasowa bap̱aidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","Pasowa babaiṯeh, haen male, Jesus Nug nuhiḵud ip̱uniṯak awak danab tuelp ele ag balalp̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","Daanna, Nug amelagp̱a aum. “Da ag ele Pasowa e imu tatam laḵunignu ool huanak daaṯe. Aria dimp̱a da guiṯak maoḵul. ");
INSERT INTO gaw_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","Da ag amelagp̱a aṯem. Da ag ele e Pasowa baula paha ii lamata. Dayebeb uḵeb, Kayaknu ḏo maḏoḏp̱a keeke imu gogp̱a teeb amu da baula laḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","Nug anam awowa, Nug hai goḵoḏ laa awa, Nug Kayak unuqiṯowa aum. “Ag imu aon panin aweg! ");
INSERT INTO gaw_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","Da ag amelagp̱a aṯem. Da baula grep lep̱u paha ii lapa. Iiṯa, haen uḵeb, dimp̱a Kayaknu ḏo maḏoḏ beeb, da eḏue laḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","Nug anam awowa, Nug bret awa, Kayak unuqiṯowa, pane ne, pania madaṯa Nug aum. “Imu amu da beḏul, da amup̱a ag ehanadḵulnu madaṯem. Ag dahilnu dab meḵulagnu kobol imu heig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","Ag e lana malona, dimp̱a Nug hai goḵoḏ awa madaṯa aum. “Hai goḵoḏ imup̱a da tituanak bau heṯem. Da tiil ag ehanadḵunu gokaḏṯem. ");
INSERT INTO gaw_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","Amge iiḵud anṯeg! Danab da kekeḏ ep̱elagp̱a meiḏḵu ele amu nug da ele oh iiḵu balalp̱a daaṯem. ");
INSERT INTO gaw_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","Danab Beḵalag da, da Kayak anuḵa aum amubia mauhḵul amge danab nug da kekeḏ ep̱elagp̱a meiḏḵu ele amu, nuhignu am gadonnab,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","Nug anam a amu ag ahan, aḵa aḵa nug oḏ meṯan ap̱ig. “Aun nug kobol amu heḵu?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","Amu hewona, ip̱uniṯak awak danab ag ahilag dab makp̱a, ag oolagp̱anu aun nug am anuqak amunu aḏaeg be, maṯin aeg ona aeg do heegeg ");
INSERT INTO gaw_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","amu Jesus Nug ag amelagp̱a aum. “Iiṯa aḏi danab ag ahilḵad king waalagp̱a daaṯeb amu king ag danab amu dilag aḏi heḵulagnu aṯeb amu ag heṯeb. Ag nai amu uuglagnu ib iiṯa ");
INSERT INTO gaw_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","amge ag dahilad daaṯeb ele amu, ag am anam iiṯa. Ag oolagp̱a danab aun nug anuqak daaṯe amu nug amu danab dimnab daaṯe bia dayaḏ! Aun nug iḵi daaṯe amu nug ahilag uḏat nid dayaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","Nug anam awowa Nug baula aum. “Wannu kobolp̱a amu aun nug am anuqak? Laa nug balalp̱a dayaya e laṯe, nug am anuqakṯe, o iiṯa begbeg nug laa balalp̱a daaṯeb ele, nug ag e madaṯe amu, nug am anuqaktai? Iiṯa. Laa balalp̱a e laṯe, danab amuam anuqak daaṯe amge da amu ag oolagp̱a begbeg bia ag ehanaṯen daaṯem amunu amup̱a ag dooṯeb, danab nug anuqak daaḵu, nug begbeg bia dayaḏ! ");
INSERT INTO gaw_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","Aria haen ug diigdiig dahil beum amu ag da ele daadmut, ag da ii uuiḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","30","Amu da Mamel, Nug ḏo maḏoḏ da meḏom amu, anamib da ag ḏo maḏoḏ dahil, amup̱a ag dahil balalp̱a e le ele lanan daaglagnu, Israel buḏub tuelp amu ele gumadḵulagnu, g̱agaṯag madaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","Jesus Nug nai amu maṯiowa Nug Simon onig diia, baula aum. “Simon, Simon, na doye! Satan nug matu ag ahilag oop̱a genab doyak am g̱agaṯag o g̱agaṯag iiṯa anṯaknu, ug madaḵunu Kayak oḏ meṯom ");
INSERT INTO gaw_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","amge da na ehaniṯen, oop̱a genab doyak nahip amu iiṯa ii memanu Kayak unuqidmi. Amu geha na eḏun g̱agaṯag daanna, na laipad g̱agaṯag daaglagnu ehanaṯe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","Nug anam a, Petrus nug Jesus amegp̱a, “Naḏi da na ele mani guiṯakp̱a goḏa, oh mauhḵunihnu ug ii dooṯem. Heḵulnuib dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","Amge Jesus Nug aum. “Petrus, da na amenp̱a aṯem, tuqan imup̱a na dahilnu, ‘Da Nug ii dooṯem,’ aon, haen ewam batak aḵut. Na haen ewam anam ap̱e, dimp̱a matuk dawai nug gaaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","Jesus Nug Petrus amegp̱a nai amu awowa, Nug nai baula tuḏiṯa ip̱uniṯak awak danab tuelp amelagp̱a aum. “Anuḵa da hei, ag gonana amu men doḏo inaknu hogot, baṯam, baelag gaḏa ele ii aḵan gop̱ig, haen amup̱a amu ag keeke laanu tutu mak doop̱igte o iiṯa?” oḏ maṯom. Oḏ maṯe amu ag, “Iiṯa,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","Ag anam aeg, Nug ag amelagp̱a inam aum. “Amge gemu danab nug men doḏo inak hogot amu baṯam ele aoḵu. Danab nug qep elab iiṯa, nug lamen nuhig awa meeb, danab laa men doḏo medap̱eg, nug qep elab awaḏ! ");
INSERT INTO gaw_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","Aḏinu? Kayak naip̱a nai laa daaṯe. Nai amuam inam. ‘Ag Nug danab nau ele laip̱u qag maadḵulag.’ Nai amu daaṯe amunu da ag amelagp̱a aṯem, keeke amu geha dahilp̱a beḵu. Ao genab, nai oh Kayak naip̱a dahilnu daaṯe amu gemu meu oḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","Nug a amu ag ap̱ig. “Naḏi, na anṯe! Ig amu qep elab aḏit iiḵu,” aon ap̱ig. Aon aeg Nug ag amelagp̱a, “Aaḵu elele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","Nug anam awowa, Nug dimiṯim noa, Nug haen kuḏum heṯom bia Nug Olipnu qaukop̱a uḵom. Nug ugeḵe, nuhiḵud ip̱uniṯak awak danab ag Nug dim lamidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","Uḵa Nug qaukop̱a ta amu ip̱uniṯak awak danab amelagp̱a aum. “Satan ag eeḏaṯeb, ag eheḏ gomananu amu ag unuqiṯeg!” ");
INSERT INTO gaw_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","Nug amelagp̱a anam anana, uuaṯa nakok piḏe waum, danab men doḏo maoe goṯe amubia. Wana gategp̱a wan ya, dup noa, unuqiṯa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","“O Mame, ug oh da maoḵul ele, amuam lep̱u mua eheḏ hai goḵoḏp̱a daaṯe bia amu na ib laa anidna ap̱e, da le hai goḵoḏ amup̱anu amu da ii laap̱a amge na da ool daaṯe imuib aib dim lamidme. Iiṯa na oot niiṯe amuib dim lamidḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","Nug unuqiṯe, engel laa hab aṯannu na, g̱agaṯag meṯa ehaniṯom. ");
INSERT INTO gaw_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","Jesus Nug beḏup̱a ug nau, mauhak bia doyaya, Nug g̱agaṯag unuqiṯeṯe, heḏi tiig bia na, wanp̱a noum. ");
INSERT INTO gaw_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","Nug unuqiṯa mala, aha hibaiṯa, nuhiḵud ip̱uniṯak awak danab gumaṯa wana, ag oolag ug naḏi ele amu ag beḏulag ug meṯe niiegeg anaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","Anaṯa Nug amelagp̱a aum. “Ag aḏinu niiṯeb? Satan ag eeḏaṯeb, ag eheḏ gomananu amu ag ahan unuqiṯeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","Jesus nai amu amelagp̱a anana dayeye, danab ameg naḏi uḏip̱ig. Judas, nug am ip̱uniṯak awak danab tuelp oolagp̱anu, nug anuqa uḏia, Jesus ootuqidḵunu gumiṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","Uḵe amu Jesus aum. “Judas, na Danab Beḵalag da, da ootuqiṯakp̱a awiḏna kekeḏ ep̱elagp̱a meiḏṯemte,” awa aum? ");
INSERT INTO gaw_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","Jesus Nug Judas amegp̱a anam aawo, ip̱uniṯak awak danab ag Jesus ele daanna, laa ag aḏi heḵulagnu heeg anidna, Jesus amegp̱a ap̱ig. “Naḏi ig qep elab imup̱a aqadp̱ut mauhḵulagte?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","Ag anam awona, ag oolagp̱anu laa aha, qep nuhig awa, mana meṯak danab dilag iḵi, nuhig begbeg laa daug naḏiap hoiyom. ");
INSERT INTO gaw_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","Jesus Nug ip̱uniṯak awak danab nug anam he anṯa, Nug aum. “Kobol amu uueg!” awa aum. Anana Nug danab amu nug daug nakok aḏe, daug eḏua dayom bia tuaḏiom. ");
INSERT INTO gaw_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","Jesus Nug amu hewowa, Nug mana meṯak danab oḵai, mana meṯak lag gumaknu iḵi danab, amu Juda iḵi danab, ag Nug aḏaglagnu uḏip̱ig, Nug amu dilag aum. “Da yabhok danabte daaṯem amunu ag qep elab amu daḏib ele aon aḏailḵulagnu uḏip̱ig? ");
INSERT INTO gaw_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","Deḏ oh da ag ele mana meṯak lag oop̱a daamut amge ag ii aḏailp̱ig amge haen imu amu ahilag haen amu Satan nug uḏat nuhig ahilagp̱a heṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","Jesus Nug nai amu amelagp̱a ana male, ag Nug aḏan, aon gop̱ig. Ag Nug aon, mana meṯak danab dilag iḵi laugp̱a uḵaeg, Petrus nug dim lamaṯa uḵom amge nug nakok piḏe dim lamaṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","Amu danab ag lag amunu haḏapp̱a ab ilan uḏigna daaegeg, Petrus ele oh daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","Daaegeg, uḏat hak nid ahin laa Petrus ab uḏiḵa dayeye anṯa, ah amu nug Petrus neeḵiṯaṯa, “Danab imu nug Jesus ele oipiḏ,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","Ah nug aum amge Petrus nug amegp̱a aum. “Iiṯa, da Nug ii dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","Nug anam awowa, nakok dayeye amu danab laa nug Petrus anṯa, nug amegp̱a, “Na ele nuhig danab laa,” awa aum. Amge Petrus nug amegp̱a aum. “Da am iiṯanab,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","Nug anam a, dimp̱a aua laip̱u uḵe, danab laa nug Petrusnu inam aum. “Danab umu nug amu Galelia danab amunu genabnab, nug Jesus ele oh oipiḏ,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","Nug anam aum amge Petrus nug aum. “Danab, da na nai amu ame amu da ii dooṯem!” Nug anam aawo, matuk dawai paha gayom. ");
INSERT INTO gaw_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","Anam he, Naḏi Nug eḏua Petrus neeḵiṯe, nug ameg qewoya, Petrus aaḵu Jesusnu nai, “Tuqan imup̱a na dahilnu, ‘Da Nug ii dooṯem,’ aon, haen ewam batak aḵut. Na haen ewam anam ap̱e, dimp̱a matuk dawai nug gaaḵu,” nai amu Petrus daugp̱a doum. ");
INSERT INTO gaw_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","Nai amu daugp̱a do, aaḵu Petrus dimiṯim uḵa, oo doyak huanak ele gayom. ");
INSERT INTO gaw_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","Amu danab ag Jesus aḏap̱ig ele amu, ag Nug aon aon qeṯan, Nug maḵuḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","Ag ele lamenp̱a ameg qaḵan, ep̱elagp̱a Nug iḏu owona amu ag ap̱ig. “Kayak na ehaniṯeb, aun nug na oiṯom ap̱e dootu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","Ag anam henan, ag Nug aon aon qedap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","Ag anam heegeg, aam be, Israel iḵi danab, mana meṯak danab oḵai amu ḏo mehuqak danab ele ag uḏin qag meeg, ag Jesus aon gona, ag noolagp̱a meeg dayom. ");
INSERT INTO gaw_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","“Nug ap̱a dayeye amu ag Nug oḏ medap̱ig. Na amenigp̱a a! Na amu Kristuste o iiṯa?” aon ap̱ig. Aeg amu Nug ag amelagp̱a aum. “Da ag amelagp̱a ap̱i amu ag genab ii doomna,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","Anana Nug aum. “Da keeke laanu oḏ madaḵul amu ag nai dahil amu nob eḏun ii aḵulag ");
INSERT INTO gaw_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","amge dimp̱a Danab Beḵalag da, da Kayak g̱agaṯag oh ele amu, da Nug ep̱eg naḏiapp̱a, amuam anuqak aben, amup̱a daaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","Jesus anam a amu ag oh ap̱ig. “Aaḵu amunu na amu Kayak beḵate?” aon ap̱ig. Aeg amu Nug amelagp̱a aum, “Ag anam aṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","Anam a amu ag ap̱ig. “Ig danab laala danab imu eheḏ heumnu maṯiglagnu ii maṯimta. Nug nuḵa Nug oḏep̱a aawo, ig nuhig nai aaḵu doomut,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","Ag Jesus aum amu doona, ag oh ahan, omalna Pilatus top̱a gona, nug ep̱egp̱a mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","Ag gona, ap̱a ahan, nug beḏup̱a nai huanak yaan ap̱ig. “Ig danab imu aniṯutut, Nug ihinig kobol kaboliṯe, ig kaisanu takis mematanu gun ma, Nug nuḵa hume, aṯan te aum. ‘Da Kristus, da king laa,’ awa aum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","Ag anam aeg amu Pilatus nug Jesus oḏ meṯom. “Na Juda dilag kingte?” A amu Jesus aum, “Na aaḵu aṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","Aaḵu Pilatus nug mana meṯak iḵi danab amu danab ah ameg naḏi ag amelagp̱a aum. “Da danab imu nuhigp̱a eheḏ hak laa da ii anidmi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","Nug anam aum amge ag huana g̱agaṯagnab enan ap̱ig. “Nug danab ah oh biilagp̱a yak nai madeṯe, laih Judanu ag oh dab mak kuḏum aoṯeb. Nug kobol amu Galelianu dig me uḏia, ip̱a ele beum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","Ag anam aon aeg, Pilatus doya amu nug ag oḏ maṯom. “Danab imu Nug am Galelia danabte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","Aria nug Jesus am Galelianu, Herodes Antipas wan amu gumom ele, ap̱anu uḏiom doya, nug me Herodes Antipas top̱a uḵom. Haen amup̱a Herodes Antipas nug Jerusalem dayom. ");
INSERT INTO gaw_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","Uḵe, Herodes Antipas anṯa, oo gamag ahom. Nug Jesusnu nai doya, haen elab nug Jesus anidḵunu dab meum. Aḏinu? Nug Jesus kobol danab heḵunu elele iiṯa laa heeb anidḵunu oo dayom. ");
INSERT INTO gaw_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","Amunu Herodes Antipas nug keeke kuḏumnu Jesus oḏ meṯom amge Jesus Nug oḏ mak amu oh eḏua nob laa ii meum. ");
INSERT INTO gaw_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","Amu mana meṯak danab oḵai amu ḏo mehuqak danab ele ag uḏin, beḏup̱a nai huana yaap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","Herodes Antipas nug nuhiḵud daup ele ag Nug aon aon qeṯan, di meṯan, lamen kokoḏ laa aon, taḵidna meeg, eḏua Pilatus top̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","Anuḵa Herodes Antipas nug Pilatus ele a kekeḏ daapiḏ amge deḏ amup̱a amu a layam batapiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","Aria Jesus Nug eḏua uḵe, Pilatus nug mana meṯak danab oḵai amu ab gumak iḵilḵad amu danab ah ele ag onilagp̱a e, ag gumidna uḵaeg, ");
INSERT INTO gaw_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","nug ag amelagp̱a aum. “Ag danab imu aon, da gumiḏna uḏin, ‘Nug danab ah ag gabman ele ban heḵulagnu maḏ adaṯe,’ ap̱ig amu da Nug ag amelagp̱a heṯoḏimi amge da nuhig eheḏ hak laa ii anidmi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","Herodes Antipas nug ele eheḏ hak laa ii anṯa, eḏua me, ihinigp̱a uḏiom amunu doyeg! Danab imu ig Nug qep̱ut mauhḵunu eheḏ laa ii heum. ");
INSERT INTO gaw_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","Anam daaṯe amunu da Nug bup̱a guiṯakib meṯoya, hep̱i goḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","18","Aria Pilatus nug anam a, danab ah ameg naḏi ag daanna, ag oh enan ap̱ig. “Danab amu Nug qep̱e mauhaḏ! Barabas eḏun aon meḵe!” aon ep̱ig. Ahilag kobol laa anam daaṯom. Haen oh Pasowa deḏp̱a Pilatus nug mani guiṯak danab laip̱u uhuqe do, madaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","Barabas nug am ab oḵai amup̱a gabman kekeḏ meṯa, ban ha, danab laa aqe mauheg, mani guiṯakp̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","Aria Pilatus nug Jesus uhuqḵunu oo dayom amunu nug danab ah ameg naḏi amelagp̱a Jesus uhuqḵunu baula aum ");
INSERT INTO gaw_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","amge ag enan ap̱ig. “Ad emaitakp̱a atule, ad emaitakp̱a atule!” aon ep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","Aria Pilatus nug baula, amuam haen ewam, amelagp̱a aum. “Aḏinu? Nug aḏi eheḏ heum? Nuhigp̱a eheḏ hak laa, ig Nug qep̱ut mauhḵunu da laa ii anidmi. Anam amunu da nug bup̱a guiṯak meṯoya, hep̱i goḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","Pilatus nug anam aum amge Juda ag wagainab mena, huanak g̱agaṯagnab enana, Pilatus nug Jesus ad emaitakp̱a atulḵunu ep̱ig. Ahilag ewak amu Pilatus nai aum amu eḏiṯom ");
INSERT INTO gaw_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","amunu Pilatus nug ahilag nai dim lamidḵunu dab ma, ");
INSERT INTO gaw_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","nug danab gabman kekeḏ meṯa, ban ha, danab laa aqe mauhp̱ig amunu mani guiṯakp̱a dayom, ag nug aoglagnu ep̱ig ele amu, Pilatus nug danab amu awa maṯa, nug Jesus, ag Nug qep̱eg mauhḵunu, daup danab ep̱elagp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","Pilatus nug Jesus daup ep̱elagp̱a me, daup ag Jesus aon gonana, ibp̱a ag Sairini ted onig Simon anidp̱ig. Nug ab dimiṯimnu uḏia, ab oḵaip̱a noḵunu doodo, ag nug duṯunna hena, ad emaitak aon, nug gugap̱a meeg, nug mawa, Jesus dim lamiṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","Danab ah ameg naḏi ag Jesus dim lamidna gonana, ah kuḏum ag nuhignu oo doyak doonna gaap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","Ag anam hep̱ig amge Jesus Nug eḏua amelagp̱a aum. “Jerusalem ah, ag dahilnu amu aib gaap̱ig! Ag aḵa ahilagnu amu ag beḵalḵad aḏelḵad dilagnu ele gayeg! ");
INSERT INTO gaw_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","Ag doyeg, dimp̱a haen nau laa uḏieb amu danab ag aḵulag. ‘Ah ag nid iiṯa, ah ag nid ii menup̱ig, ah ag deḏ laa nid huh ii madap̱ig ele amu, ahilagnu am ena,’ aon aḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","Geha haen amu uḏieb, ag qaukonu aḵulag. ‘Na nena qaḏenigp̱a qe!’ Amu qauko nakoknu aḵulag. ‘Na nena toniḵe!’ aon aḵulag. ");
INSERT INTO gaw_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","Aḏinu? Ag gemu haen nakok enap̱a kobol nau imu heṯeb amunu dimp̱a haen naup̱a amu mua naunab ag tonadḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","Haen amup̱a ag Jesus aon gonana, ag danab aḏit laa ele diiatna gop̱ig. A kobol nau hepiḏ amunu a Jesus ele aqaglagnu diiadna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","Ag gona, aben laa onig Iḵilag Ebehi, ap̱a tena, ap̱a Jesus ad emaitakp̱a atulp̱ig. Danab nau aḏit a ele oh atuladp̱ig. Ag danab laa Jesus ep̱eg naḏiapp̱a atulona, laa amu ep̱eg nanehp̱a atulp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","Ag anam heeg, Jesus Nug unuqiṯa aum. “Mame, na ahilag hip̱unin imu uhuqna maṯe! Ag heṯeb imu amu, ag ii doona heṯeb,” awa aum. Amu daup amu ag nuhig lamen aoglagnu amu ag otina, ameg waḏele mewona, aun nug ameg aṯen aoḵu amu ag keeke laa onig dais amup̱a qiḏ hena aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","Danab ah ag hip̱aidna daanna anṯegeg amu iḵi danab ag nug aon aon qeṯan ap̱ig. “Nug danab laala ehanaṯom amunu Nug genab Kayak beḵa, Kayak tituanom dayeb amu, Nug nuḵa Nug ehaniṯaḏ!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","Ag anam aegeg, daup danab ag ele aon aon qeṯan, gumidna dona, wain nau mua ele meṯaglagnu hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","Ag anam henan amu inam ap̱ig. “Na Juda dilag king daaṯem dayeb amu na naḵa beḏun uhuqe!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","Amu nuhignu nai laa inam aon yaana, ad emaitak igip̱a atulp̱ig. “Danab imu nug amu Juda dilag king.” ");
INSERT INTO gaw_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","Danab nau aḏit atulatp̱ig amu laa nug ele Jesus awa awa qeṯa aum. “Na am Kristusde! Na naḵa na beḏun uhuqna, i ele uhuqite!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","Am laa nug anam aum amge laa nug laa aum amu doya, daug bata, amegp̱a aum. “Na anam aib ame! Na Kayak iite baḏidna, kobol nau nahip amu tuḏidna heḵutnu heṯem? ");
INSERT INTO gaw_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","I nitaeg mauhṯep imunu am ena, ag kobol elele hep̱ig. I nob imu aognihnu am nai iiṯa. Aḏinu? Ihinih eheḏ hemuḏ nob iiḵu aoṯep amge danab imu Nug eheḏ laa ii heum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","Nug anam anana, nug Jesus amegp̱a aum. “Jesus, na nahip ḏo maḏoḏp̱a daanna amu na dahilnu dab meḵutnu ool daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","Nug anam a amu Jesus Nug amegp̱a aum. “Da genabnab na amenp̱a aṯem. Gemu na da ele Paradisp̱a daagnih,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","45","Ag anam heeg uḵe, aam ameg tuelpp̱a aam gatatu me, gatatu wan oh tona male uḵe, tueb aam ameg ewamp̱a batom. Anam he, lamen oḵai mana meṯak lag oop̱a aiheg dayom amu katiḏa aḏit meum. ");
INSERT INTO gaw_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","Anam he, Jesus Nug baag oḵaip̱a ewa aum. “Mame, da ouḏil na ep̱enp̱a meṯem,” awa aum. Nug anam awowa, Nug mauhom. ");
INSERT INTO gaw_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","Jesus mauhe, daup 100 dilag iḵi nug amu anṯa, nug Kayak binag ma aum. “Genabnab danab imu Nug danab tutuḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","Danab ah oh anidḵulagnu uḏip̱ig, ag kobol beum amu anidna, ag oolag ug ele eḏun gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","Keeke amu oh beum amu Jesus laiḵud amu ah laala Galelianu ahan uḏip̱ig ele, ag piḏe daanna, kobol amu oh anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","51","Aria danab laa, onig Josep, nug Juda dilag ab oḵai Arimatia aṯeb, ap̱anu, nug amu danab ena tutuḵu, nug am Juda dilag heṯoḏiak oḵai onig Sanhidren amup̱a uḏat heum amge nug heṯoḏiak laala ahilag dab mak, ahilag kobol ele Jesusnu hep̱ig amu, nug uuom. Nug Kayaknu ḏo maḏoḏ ameg ma dayom. ");
INSERT INTO gaw_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","Danab amu nug Pilatus gumiṯa uḵa, Jesus gaḏa aoḵunu oḏ meṯe, Pilatus nug aoḵunu elele aum. ");
INSERT INTO gaw_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","Nug anam a, Josep nug Jesus gaḏa awa, linen lamenp̱a ita, nug moḏ laa oop̱a meum. Moḏ amu ag menp̱a bap̱aidp̱ig. Moḏ bap̱aidp̱ig amup̱a mauhak gaḏa laa ii mep̱ig, hamu dayom. ");
INSERT INTO gaw_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","Deḏ amup̱a amu ag Juda dilag Meṯidnu keeke babaiṯaknu deḏ, Meṯid ahilag amu dig meḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","Josep nug anam heehe, ah ag Galelianu ahaeg Jesus ele uḏip̱ig, ag Josep dim lamidna gona, moḏ amu anidna, Josep nug Jesus gaḏa aṯem meum amu ele ag anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","Ag anṯona amu ag eḏun laḵa gona, ag marasin goḏen muṯuḏig ena ele Jesus beḏu laaiṯaknu amu babaiṯona, ag Juda dilag Meṯid amu, ḏo aṯe bia, hik aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","Aria Juda dilag Meṯid uḵa male, buṯuanab amu ah ag ahan moḏp̱a gop̱ig. Ag goḏen muṯuḏig ena ele babaiṯeg dayom, amu ele aḵan gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","Ag gona, men naḏi moḏ ameg tonom amu laa nug duṯune uḵa, moḏ amegp̱a ii daye anidna, ");
INSERT INTO gaw_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ag moḏ oop̱a nop̱ig amge Naḏi Jesus gaḏa amu ag ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","Ii anidna, ag amunu dab mak kuḏum aona, ootot aqe henana amu ag danab aḏit miag hip̱aidya daaeheh anatp̱ig, ahilah lamen amu haḵab diṯiag apinak ele. ");
INSERT INTO gaw_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","Anidna, ah ag baḏan, wanp̱a dup nop̱ig amge danab aḏit a ag amelagp̱a apiḏ. “Aḏinu ag danab bau am ag mauhak gaḏalag maadṯeb abenp̱a maṯin oiṯeb? Nug ip̱a iiṯa. Nug eḏua hibaiṯom,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","A anam ayaya amu amelagp̱a nai tuḏidya apiḏ. “Nai imu haen Nug Galelia dayaya, ag amelagp̱a maṯiom amu, ag daulagp̱a doaḏ! ");
INSERT INTO gaw_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","Nug ag amelagp̱a inam awa aum. ‘Ag amu Danab Beḵalag da, da aḏailna, iiṯa aḏi danab ep̱elagp̱a meiḏp̱eg, ag amu da ad emaitakp̱a atuliḏp̱eg amu geha deḏ ewamp̱a Kayak Nug heeb, da eḏue hip̱aidḵul,’ awa aum,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","Aria ag Jesus Nug nai amu anuḵa amelagp̱a aum amunu dab mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","Aaḵu moḏp̱a daap̱ig amu ag uun, eḏun gona, ip̱uniṯak awak danab elewen amu amelagp̱a awona amu danab laala ele amelagp̱a ag keeke oh anidp̱ig, amunu madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","Maria, Magdala ted, Joana amu Maria, Jakobus anig, aria ah laala ag ele ag nai amu ip̱uniṯak awak danab amelagp̱a madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","Ah ag nai amu amelagp̱a madip̱ig amge ip̱uniṯak awak danab ag ahilag dab makp̱a, “Ah ag nai ulah hamu madiṯeb,” aon anana, ag nai maṯieg doop̱ig amunu oolagp̱a genab ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","Oolagp̱a genab ii doop̱ig amge Petrus nug aha, qaibaḏ moḏp̱a uḵa, gomela, moḏ oop̱a neeḵe no amu linen lamenib dayeye anṯowa amu nug eḏua uḵa, keeke amunu dab mak kuḏum awom. ");
INSERT INTO gaw_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","Amu deḏ amup̱aib ag oolagp̱a danab aḏit a ab nakok onig Emaus ap̱a gopiḏ. Ib Jerusalemnu aha Emaus uḵak amu 11 kilomita anam. ");
INSERT INTO gaw_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","A goyaya amu a keeke oh Jerusalem ap̱a hep̱ig amunu madipiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","A amu maṯiiya, nug oḏ meṯaiya uḵaeheh, Jesus Nug tula do, a ele oh gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","Ag oh gop̱ig amge a Nug am Jesus a ii doopiḏ. Aḏinu? A amelah ii op̱atom. ");
INSERT INTO gaw_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","Amunu Nug a oḏ mata, amelahp̱a aum. “A amu aḏi keekenu nai maṯiya goṯep?” Anam awa a amu danab aḏit amu oolahp̱a elele ii dooya, iḏulah nauhe, hip̱aidya daapiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","Anam daaiya, danab onig Kliopas nug aha amegp̱a aum. “Amu danab ab laih laihnu oh ag gemu Jerusalem daaṯeb amu ag oolagp̱a na naḵa aḵuibtai keeke oh haen imup̱a Jerusalem beum am iite dooṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","Nug anam awa a amu Jesus Nug a oḏ matom. “Aḏi keeke?” Awa a amu aria a Nug amegp̱a kobol oh Jesusnu hep̱ig amu maṯiya inam apiḏ. “Jesus, Nasaret ted, Nug amu Kayaknu propet, Nug Kayak nai diig genab g̱agaṯag ele Kayak noobp̱a danab ah amelagp̱a ele maṯia mehuqaqa, uḏat g̱agaṯag ele haaha oiyom. ");
INSERT INTO gaw_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","Amu mana meṯak danab oḵai, amu ihinḵad iḵi danab ele ag aon, gabman ep̱elagp̱a mena, qep̱eg mauhḵunu aeg, gabman ag nug ad emaitakp̱a atulp̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","Amge ig nuhignu amu genab doomut, Nug amu Israel dilag eḏua awiḵak danab. Ag anam heeg uḏie, gemu am deḏ ewam iiḵu. ");
INSERT INTO gaw_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","Amu laa ele amu gemu ig oonigp̱an ah laala, ag heeg ig oṯaimut. Ag buṯuanab ahan moḏp̱a gop̱ig ");
INSERT INTO gaw_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","amge ag Jesus gaḏa ii anidp̱ig. Ii anidna amu ag eḏun uḏin, ag engel aḏit anategeg, ‘Jesus Nug bau daaṯe,’ apiḏ amu aeg doomut. ");
INSERT INTO gaw_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","Ag anam aeg amu ig oonigp̱an danab laala ag moḏp̱a gona, keeke ah ag ap̱ig ele amuib anidp̱ig amge Nug amu ag ii anidp̱ig,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","Anam aeh, Jesus Nug amelahp̱a aum. “A danab dab mak iiṯa ele. Kayaknu propet dilag nai amu mehuqp̱ig amge a oolahp̱a amu a genab ii doopiḏ,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","Nug anam anana, Nug a amelahp̱a nai tuḏiṯa aum. “Kristus Nug guiṯak awa, amup̱a anuqak abenp̱a daaḵu amu propet laa nug Kayak oḏe awa iite yom?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","Nug anam amelahp̱a awowa, Nug Mosesnu naip̱a dig me uḵe, Kayaknu propet oh dilag nai amu amelahp̱a mehuqom. Nug Kayak nai yak oop̱a nuhignu nai aum niiṯe amu oh diig mehuqom. ");
INSERT INTO gaw_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","Nug mehuqeqe, ag gona, ab a gopiḏ ele amu guḵuidnana, Jesus Nug anam haaha, uuata goḵunu heum ");
INSERT INTO gaw_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","amge a Nug hagaḵa aoya apiḏ. “Na i ele daatu! Aam no, uu doumde!” Anam aeh, amu Nug lag oop̱a no, oh daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","Daanna dimp̱a e laḵulagnu hena, Jesus Nug ele oh daanna, Nug bret awa, Kayak unuqiṯa, pane ne, Nug matete, ");
INSERT INTO gaw_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","a amelah op̱ate, a Nug amu Jesus anidya doyeheh, Nug uḵom. Uḵe, a Nug baula ii anidya ");
INSERT INTO gaw_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","amu aya aya inam apiḏ. “I ibp̱a uḏiuḏuḏ, Nug Kayak nai meu tutuḵu mehuqe doomuḏ amu i oonihp̱a nuhig nai meu elenab iite doomuḏ?” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","A anam ayaya, a deḏ amup̱aib ahaya, eḏuya Jerusalem goya, ip̱uniṯak awak danab elewen ap̱a daap̱ig amu laala ele ag qag mena daaegeg anadpiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","Anaṯeh amu ag a amelahp̱a ap̱ig. “Genabnab, Naḏi Nug eḏua hibaiṯom, Simon nug anṯom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","Ag anam aeg amu danab aḏit a ibp̱a keeke oh be anidpiḏ amunu maṯiya amu tuḏidya apiḏ. “Nug Kayak unuqiṯa, bret pana mete, i nug anidḏa, aaḵu i Nug doomuḏ,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","Ip̱uniṯak awak danab amu danab laala ele ag nuhignu aaḵu maṯinna daaegeg, Jesus Nug nuḵa tula doa, oolagp̱a hibaiṯa, amelagp̱a aum. “Ag oo mak, maḏoḏ ele dayeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","Nug anam a, ag oṯaina, baḏan ag dab makp̱a ap̱ig. “Ig doṯog laa anidṯem,” ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","Amge Nug ag amelagp̱a aum. “Ag aḏinu oṯaina oolagp̱a dab mak laala aoṯeb? ");
INSERT INTO gaw_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","Ag da ep̱el bael ele iiḵud anṯeg! Daib iiḵu daaṯem. Ag ep̱elag bahina aḏailna anṯeg! Doṯog nug beḏu, ebehi ele iiṯa, ag da aniḏṯeb bia,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","Nug anam anana amu Nug ep̱eg baeg ele ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","Ag Nug anidna, ag oolag gamag huan ahom amunu ag oolagp̱a genab ii doop̱ig, ahilag dab mak piḏe piḏe ele anaṯa amu amelagp̱a aum. “Ag e laa ana daaṯete?” awa oḏ maṯom. ");
INSERT INTO gaw_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","A amu ag kakai laih maip̱ig amu aon meṯaeg, ");
INSERT INTO gaw_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","Nug aḏa lanana anṯegeg, ");
INSERT INTO gaw_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","Nug amelagp̱a aum. “Anuḵa da ag ele daatta ag amelagp̱a dahilnu nai oh Mosesnu ḏop̱a amu Kayaknu propet dilag yakp̱a ele nai amu oh beḵununab ami amu aaḵu meu beum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","Nug anam anana, Nug nai yak amu oolagp̱a tutuḵunab genab maiṯeb dooglagnu ip̱uanaṯaṯa, ");
INSERT INTO gaw_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","amelagp̱a aum. “Kayaknu yak inam ip̱unigṯe. Kristus Nug guiṯak awowa amu deḏ ewamp̱a nug eḏua hip̱aidḵu. ");
INSERT INTO gaw_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","Amu danab ag oolag eḏuḵunu amu ag hip̱unin uhuqa meṯak aoglagnu, laala ag Nug onigp̱a nai amu danab buḏub ohnu oolagp̱a mehuqp̱ep̱eg dooglag. Ag uḏat amu Jerusalem dig meḵulag. Kayak nai anam ip̱unigṯe. ");
INSERT INTO gaw_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","Amu ag gemu da ele iiḵu daaṯem amu ag dahilp̱a keeke oh anidp̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","Jesus Nug anam anana, Nug baula tuḏiṯa aum. “Doyeg! Da Mamel Nug keeke amu anuḵa ag madaḵunu nai qaḵa aum amu da hep̱i neḵu amge ag ab oḵaip̱a daap̱eg, hab aṯannu g̱agaṯag amu ahilagp̱a neeb, ag uḏat dig meḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","Nug anam awowa, Nug aha, diie gona, Betani ap̱a Nug ep̱eg huma itaṯom. ");
INSERT INTO gaw_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","Nug itaṯeṯe amu Kayak awe, nug uuaṯe, hab aṯan uḵom. ");
INSERT INTO gaw_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","Nug anam he, ag oolag gamag ahak naḏi ele Nug binag mena, ag eḏun Jerusalem gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","Gona ag hanhan mana meṯak laḵa daanna, ag Kayak binag menan daadṯp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","Kayak Nug keeke oh dig ma heum, haen amu ii nak amu Kristus, Nug onig laa Nai, Nug dayom. Nug Kayak noobp̱a dayom amge anamib iiṯa, Nug ele Kayak dayom. ");
INSERT INTO gaw_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","A oh daapiḏ amu Kayak Nug keeke heḵunu dig ma, ");
INSERT INTO gaw_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","Nug keeke oh Kristus ep̱egp̱a me heum. Keeke laa ib laap̱a ii beum. ");
INSERT INTO gaw_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","Jesus Nug am bauklel hanhannu diig. Bauklel amuam danab oh dilag amahlak. ");
INSERT INTO gaw_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","Amahalak amu Nug gatatup̱a amahalṯe amu gatatu nug amahlak amu eḏidḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","7","Kayak Nug danab laa nug danab ah amelagp̱a nai mehuqḵunu epeḏie doum. Danab amu onig Johanes. Nug amahlaknu nai mehuqebeb, danab ah oh ag nuhig mehuqak amup̱a oolagp̱a genab dooglagnu ahom. ");
INSERT INTO gaw_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","Nug am amahlak amu iiṯa amge nug amahlak amunu mehuqḵunu ahom. ");
INSERT INTO gaw_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","Amahlak amuam amahlak genab. Nug wanp̱a uḏia amu danab ah oh amahlak madaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","Ao, Kristus, onig laa Nai, nug wanp̱a dayom, wan imu amu Nug he beum amge wanp̱anu danab ah ag Nug ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","Nug keeke heump̱a na dayom amge danab ag Nug ḏo ii meṯan ii aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","Amge laala ag Kristus aop̱ig amu ag aaḵu Kayak beḵod daaglagnu g̱agaṯag maṯom. ");
INSERT INTO gaw_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","Ag tiig maḵulakp̱a amu beḏunu kobolp̱a, o danabnu dab makp̱a, ag Kayak beḵod ii bep̱ig. Iiṯa! Kayak Nug he, ag Nug beḵod bep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","Am Kristus, onig laa Nai, Nug danab beḏu awa, ig oonigp̱a dayom. Nug am Kayak beḵa laip̱unab amunu nuhig binag oḵai ele dayeye, ig Nug binag amu oḵai anidmut. Amu genabnu diig amu ehaniṯak oḵai hamu meṯak kobol ele amuam nuhigp̱a am baknab ele daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","Amu Johanes nug nuhignu nai mehuqaqa ewa aum. “Da anuḵa nuhignu maṯimi ele amu aaḵu. Da ami. ‘Nug da dim lamiḏa uḏiṯe, Nug am da eḏilak. Aḏinu? Da ii daami haenp̱a amu, Nug haen amup̱a ele dayom,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","Keeke ena oh amu nuhigp̱a am bak daaṯe amunu ig nuhigp̱a ehaniṯak diigdiig aaḵu aomut. ");
INSERT INTO gaw_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","Yo, ḏo amu ig Moses nuhigp̱a aomut amge ehaniṯak oḵai hamu meṯak kobol am keeke genab ele amu ig Kristus nuhigp̱a aomut. ");
INSERT INTO gaw_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","Danab laip̱u laa nug haen laa Kayak ii anṯom. Iiṯanab. Kayak Beḵa laip̱unab, Nug Kayak ele ou qak daaṯep amu, Nug aaḵuib aniṯa doya, Kayak ip̱uniḵom. ");
INSERT INTO gaw_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","Aria deḏ laa Juda oḵai ag mana meṯak danab amu Lewi buḏub danab laa ele Jerusalem ap̱anu Johanes nuḵa nuhignu oḏ meṯaglagnu maaṯeg gona, “Na am aun?” ana oḏ meṯaeg, ");
INSERT INTO gaw_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","Johanes nug ag amelagp̱a, “Da am Kristus iiṯa,” aḵunu ii uuom. Iiṯa, nug miag nai mehuqaqa, “Da am Kristus iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","Anam a amu ag ap̱ig. “Anam daaṯe dayeb amu na am aun? Na am Eliaste?” aon ap̱ig. Aeg amu nug aum. “Da am nug iiṯa.” Nug anam a amu ag ap̱ig. “Ge na nug iiṯa daaṯem dayeb amu na am propet laa uḏiḵunu, ig nug ameg meṯem ele amute?” aon ap̱ig. Ag anam aeg amu nug, “Iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","Anam a amu ag ap̱ig. “Ehe! Ig danab meiḵeg uḏimut ele amu ahilag oḏ mak nob eḏugnignu am na naḵa nahipnu amu aḏinab aṯem?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","Ag anam aeg amu Johanes nug inam aum. “Da amu, baag laa propet Jesaia aum bia, atu taḏakp̱a, ‘Ag oolagp̱a Naḏinu ib babaiṯeg!’ awa eṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","25","Anam daye amu maaṯeg uḏip̱ig ele amu ag oolagp̱anu laala ag ḏo gumak danab-Parasia daap̱ig amu ag Johanes oḏ meṯan ap̱ig. “Na Kristus iiṯa, Elias iiṯa amu propet ele iiṯa. Anam dayeb amu na aḏinu danab ah layadṯem?” ");
INSERT INTO gaw_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","Ag anam aeg amu Johanes amelagp̱a aum. “Da amu ag lep̱a layadṯem amge ag oolagp̱a ap̱a laa hibaiṯom daaṯe ele amu ag Nug ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","Danab amu Nug da dimulp̱a uḏiṯe amge dahil hak amu nuhig ele, elele iiṯa, Nug am da eḏilak,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","Johanes nug Jodan lep̱a danab layaṯeṯe, keeke imu oh amu Beṯani ap̱a beum. Beṯani amu Jodan le laih ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","Wagḵaḏe deḏ amup̱a Jesus Nug Johanes gumiṯa uḏieye, Johanes Nug anṯa aum. “Anṯeg, Kayaknu Sipsip Nag, Nug wanp̱an danab dilag hip̱unin uhuqṯe ele amu, Nug am uuḵu. ");
INSERT INTO gaw_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","Am danab umu aaḵuib da nuhignu inam ami. ‘Danab Nug da dimulp̱a uḏiṯe ele amu, Nug da eḏilak. Aḏinu? Nug anuḵanab da ii daami haenp̱a ele, Nug dayom.’ ");
INSERT INTO gaw_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","Laa ele, Nug Kayaknu sipsip nag daaḵunu matu ii doomi amge da Israel danab Kayaknu Sipsip Nag ip̱uanadḵulnu uḏien, danab ah lep̱a layadṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","Johanes anam anana amu nug nai tuḏiṯa aum. “Da Kayak Ouḏi Nug hab aṯannu, ai up̱uḏil bia na, Nug qaḏep̱a dayeye anidmi. ");
INSERT INTO gaw_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","Da ele Nug ii doolom amge laa Nug da danab ah lep̱a layadḵulnu meiḏe uḏimi ele amu, Nug a doomi. Nug aum. ‘Kayak Ouḏi Nug na, danab laa qaḏep̱a daaḵu amu danab amu aaḵuib Nug geha Kayak Ouḏip̱a layadḵu,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","Amu da anidmi, nuhignu da madiṯem ele amu, Nug am Kayak beḵa.” Johanes anam aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","Aria deḏ amu uue wagḵaḏe, deḏ amup̱a Johanes nug baula ap̱a dayeye, nuhig ip̱uniṯak awak danab aḏit ele daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","Ag anam daanna, nug Jesus oieye anṯa aum. “Anṯeḏ! Umu am Kayaknu Sipsip Nag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","Nug anam a amu ip̱uniṯak danab aḏit a Johanes nai aum amu a dooya, a Jesus dim lamiṯeheh, ");
INSERT INTO gaw_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","Jesus Nug eḏua anata, Nug aum. “A aḏi madiṯep?” awa aum. Nug anam a amu a apiḏ. “Rabi na adep̱a daaṯem?” aoi apiḏ. Rabi eḏuak am ip̱uniṯak danab. ");
INSERT INTO gaw_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","Aeh amu Nug aum. “A doya, da daaṯem aben anṯeḏ!” Nug anam a amu a Nug dim lamiṯeh gona, Nug daaṯe aben amu anidpiḏ. A Nug ele oh gop̱ig, amuam aam ameg waḏele anam amu deḏ amu, haen amu uḵe tueb batak a Nug ele ap̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","Aria nid aḏit Johanesnu nai dooya, Jesus dim lamidpiḏ ele, amunu oolahp̱a laip̱u laa nug onig Andreus, nug Simon Petrus ele, a am eamag. ");
INSERT INTO gaw_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","Amu nug paha uḵa, Simon anṯa, nug amegp̱a aum. “I Mesias aaḵu anidmuḏ,” awa aum. Mesias diig amu danab laa Kayak Nug Nug wan imu ohnu oḵai daaḵunu epeḏiom. Grik naip̱a Mesias eḏuak amu Kristus. ");
INSERT INTO gaw_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","Anam anana amu Andreus nug Simon omala, Jesus top̱a uḵom. Uḵe Jesus anṯa, amegp̱a aum. “Simon, Johanes beḵa, nahipnu ag geha Sipas aḵulag,” awa aum. Grik naip̱a Sipas eḏuak amu Petrus. Onig aḏit amu oh meu am men. ");
INSERT INTO gaw_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","44","Waḵaḏe, deḏ amup̱a Jesus Nug Galelia goḵunu dab maama, Nug Pilipus, nug am Betsaida ted, nug Andreus Petrus ele, ag oh ap̱alag laip̱u amu, Jesus Nug nug maṯia anṯa amu nug amegp̱a aum. “Na da dim lamiḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","Anam a amu Pilipus nug Nataniel maṯia anṯa, amegp̱a aum. “Danab Moses nug anuḵa ḏo naip̱a nuhignu yom, propet ag ele nuhignu yaap̱ig amu ig aaḵu anidmut. Nug am Josep beḵa Jesus, Nasaret ted,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","Nug anam a amu Nataniel nug aum. “Nasaret up̱anu amu keeke ena anam laa ii uḏima,” awa aum. A amu Pilipus nug aum. “Dona anṯe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","Pilipus nug anam a, Nataniel nug Jesus anidḵunu uḏieye, Jesus Nug anṯa, Nug aum. “Anṯeg! Umu am Israel ted genab. Nug oop̱a am ham bup̱uak laa iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","Anam a amu Nataniel Jesus oḏ meṯom. “Aṯemun na da dooiḏme?” awa oḏ meṯom. Nataniel anam a amu Jesus oḏep̱a awa aum. “Pilipus nug na oninp̱a eum, haen amu ii nak, da na ad onig pig waap̱a dayeye anidmi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","Jesus anam a amu Nataniel oḏep̱a awa aum. “Ip̱uniṯak danab, na am Kayak beḵa, na Israel dilag King,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","Anam a amu Jesus Nug Nataniel oḏep̱a awa aum. “Da na ad pig waap̱a anidmi ami amunute na ootp̱a genab dooṯem? Na keeke amu eḏiṯak, laa ele geha anidḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","Jesus Nug anam anana, Nug nai baula ele tuḏiṯa aum. “Da genabnab genab ag amelagp̱a aṯem, geha hab obaṯeb, Kayaknu engel ag Danab Beḵalag da, da gumiḏna nenan tebep̱eg anadḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","Aria deḏ aḏit uue, deḏ ewamp̱a, ab onig Kana, Galelia wanp̱a, ap̱a danab laa ah aoḵun heum. Jesus anig nug hobul amup̱a danab amu laugp̱a dayom amu ");
INSERT INTO gaw_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ag Jesus Nug nuhiḵud ip̱uniṯak awak danab ele, ag oh ele hobul amup̱a daaglagnu onilagp̱a ep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","Ag anam eeg daaegeg, dimp̱a danab amu ahilag wain iiṯa me, Jesus anig nug Jesus amegp̱a aum. “Wain ahilag iiṯa meum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","Nug anam a amu Jesus Nug amegp̱a aum. “Anai, imu am i ohnu keeke iiṯa. Da keeke danab heḵunu elele iiṯa, amu heḵulnu haen iite doum?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","Jesus anam a amu anig nug begbeg danab amelagp̱a aum. “Nug nai laa amelagp̱a ab amu ag Nug oḏe dim lamiṯeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","Amu le itaknu hanak menp̱a hak eblaih laip̱u ele, Juda ag haen oh ahilag kobolp̱a amup̱a le laaglagnu meeg daap̱ig. Hanak amu anen anen le hai goḵoḏ 100 keeke inaḵunu elele. ");
INSERT INTO gaw_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","Amu Jesus Nug begbeg danab amelagp̱a aum. “Ag le itap̱eg, hanak am beig!” awa aum. Nug anam a amunu ag le itaeg, hanak amu oh am bena, agap bep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","Hanak am beeg, Nug aum. “Laa itap̱eg nob, aon gona, e gumak danab oḵai amu meṯeg!” awa aum. Nug anam a, ag aon gona, ");
INSERT INTO gaw_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","nug meṯaeg amu e gumak danab oḵai nug le geha wain eḏuom amu baag dooḵunu naḵok laum. Nug wain amu adep̱anu amu nug ii doyom amge begbeg danab le itap̱ig ele amu ag doop̱ig. Aria e gumak danab oḵai nug wain amu naḵok lawowa, nug danab ah aoṯe ele, danab amu onigp̱a eum. ");
INSERT INTO gaw_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","Onigp̱a e uḏie amu nug aum. “Danab oh ag wain ena amu tatam maṯaeg laeg, dimp̱a amu ag wain naḵok nau bia amu madaṯeb. Amge na am wain ena amu hagaḵa awe dayom, geha iiḵu wain ena aon dome,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","Aria Jesus Nug amu heum amu amup̱a Nug ep̱onak keeke danab heḵunu elele iiṯa, kobol amu heḵunu dig ma heum. Nug Kana abp̱a, Galelia wanp̱a anam ha, amup̱a Nug nuhig g̱agaṯag ip̱uanaṯe, nuhiḵud ip̱uniṯak awak danab ag nuhignu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","Hobul amu male, Jesus Nug anig, laiḵud amu nuhiḵud ip̱uniṯak awak danab ele ag Kapenaum ap̱a nona, naḵok daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","Ap̱a daaegeg uḵe, Juda dilag Pasowa meṯid hobul guguiṯeṯe, Jesus Nug Jerusalem ap̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","Ap̱a mana meṯak lag oop̱a danab ag bulmakau, sipsip, amu up̱uḏil ele ag daden meegeg anaṯom. Amu danab men doḏo baoliṯeb ele amu, ag ele daaegeg anaṯom. ");
INSERT INTO gaw_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","Jesus Nug anam anaṯa, Nug mataḏaknu keeke muḏip̱a aḵa, danab mana meṯak laḵa daap̱ig ele amu ahilḵad sipsip, bulmakau oh lamaṯaṯa amu Nug danab balalp̱a men doḏo baolina daap̱ig ele amu ahilag men doḏo gokaḏe no, balal ele huma awe, na qeum. ");
INSERT INTO gaw_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","Na qe, danab ai meeg daden mep̱ig ele amu amelagp̱a aum. “Keeke amu aḵan uḵeg! Ag da Mamel laug amu aib hep̱eg, en lag bia dayom!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","Jesus anam a, nuhiḵud ip̱uniṯak awak danab ag Kayak naip̱a, nai daaṯe, amu daulagp̱a doum. Nai amuam inam. “Da na lautnu ool huanak daaṯe amunu da na laut ena daaḵunu wagai meṯem.” ");
INSERT INTO gaw_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","Anam daye amu Juda ag amu anidna, ag Jesus amegp̱a ap̱ig. “Na aḏi ep̱onak keeke, danab heḵunu elele iiṯa laa hep̱e, ig anidta amu na g̱agaṯag amup̱a daaṯem amu ig doognig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","Aeg amu Jesus Nug ag oḏelagp̱a awa aum. “Ag mana meṯak lag imu ag hep̱eg nauheb, da deḏ ewam oop̱a da eḏue bap̱aidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","Jesus anam a amu ag ap̱ig. “Maḏ 46 anam ag mana meṯak lag imu henan daap̱ig, amu na deḏ ewam oop̱a heḵutnu aṯemte?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","Amge Jesus Nug mana meṯak lagnu ii aum. Iiṯa. Nug beḏunu aum. ");
INSERT INTO gaw_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","Amunu dimp̱a Jesus Nug moḏp̱a mauhak oolagp̱anu eḏua hibaiṯe amu ip̱uniṯak awak danab ag Nug anuḵa aum amu daulagp̱a do, ag nai yak, amu nai Jesus Nug aum, amu ele oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","Amu Jesus Nug Pasowanu meṯid hobul amu ap̱a dayaya, ep̱onak keeke, danab heḵunu elele iiṯa kuḏum heehe, danab ag anidna, nuhignu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","Amge Jesus Nug danab ah dilag dab mak, ag Nug ahilag wan imup̱an oḵai daaḵunu meḵulagnu dab mep̱ig, dab mak amu doyom amunu ag anam hemananu Nug nuḵa Nug awaiṯom. ");
INSERT INTO gaw_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","Nug danab diilag oh doyaṯa malom. Danab laip̱u laa nug danab dilag dab mak amu amegp̱a aḵunu elele iiṯa. Nug nuḵa danabnu dab mak oh doya malom. ");
INSERT INTO gaw_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","Aria ḏo gumak danab-Parasia laa onig Nikodemus, nug am Juda dilag iḵi, ");
INSERT INTO gaw_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","danab amu nug tuqan Jesus gumiṯa uḏia, Nug amegp̱a aum. “Ip̱uniṯak danab, ig dooṯem, na am ip̱uniṯak danab Kayak top̱anu uḏime. Anṯe, Kayak Nug danab laa ii ehaniṯeb amu nug ep̱onak keeke, danab heḵunu elele iiṯa, na heṯem ele amu, nug heḵunu elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","A amu Jesus oḏep̱a awa aum. “Da genabnab genab na amenp̱a aṯem. Danab nug bau menuak ii aoḵu amu nug Kayaknu ḏo maḏoḏ ii anidma,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","Jesus anam a amu Nikodemus nug amegp̱a aum. “Danab nug kaino daaṯe amu nug aṯemun eḏua bau menuak aoḵu? Nug baula anig oop̱a nob, anig nug eḏua menuḵunu elelete?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","Nikodemus anam a amu Jesus oḏep̱a awa aum. “Genabnab genab da na amenp̱a aṯem. Danab nug lep̱a, amu Kayak Ouḏip̱a ele menuak ii aoḵu amu nug Kayaknu ḏo maḏoḏ oop̱a goḵunu elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","Danab nug beḏu bau daaḵunu, amuam anig mameg dilahp̱a aoṯe amge danab nug oiyak bau, hanhan dayaknu amu, nug amu Kayak Ouḏi ep̱egp̱anu aoṯe. ");
INSERT INTO gaw_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","Anam daaṯe amu da na bau menuak aoḵutnu ami amu na amunu dab mak kuḏum aib aome. ");
INSERT INTO gaw_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","Am ulah nug adeḵup̱anu uḏia, aṯen goṯe amu na ii dooṯem, nug uḵak nuhigib dim lamidṯe amu na nuhig oqoṯi aaḵuib dooṯem. Amubia danab ah Kayak Ouḏip̱a bau menuak aoṯeb ele amu, danab ag amunu diig oh anidna, oolag maidḵunu elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","Jesus anam a amu Nikodemus oḏep̱a awa aum. “Keeke amu nug aṯemun anam beḵu?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","Nug anam a, Jesus baula Nikodemus oḏep̱a awa aum. “Na amu Israel dilag ip̱uniṯak danab oḵai am aṯemun na keeke imu ii dooṯem? ");
INSERT INTO gaw_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","Genabnab genab da na amenp̱a aṯem. Keeke ig dooṯem ele amu ig amunu mehuqṯem, keeke ig anidṯem ele amu ig amunu madiṯem amge ihinig maṯiak amu ag dab ii medṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","Da wan kobolnu maṯii, ag oolagp̱a genab ii doop̱ig amunu aṯemun da hab aṯan kobolnu madip̱i, ag oolagp̱a genab dooglag? ");
INSERT INTO gaw_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","Laip̱u laa nug hab aṯan ii teum. Iiṯa. Danab Beḵalag da aaḵuib ap̱a dayeye, hab aṯannu uḏimi. ");
INSERT INTO gaw_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","15","Anuḵa atu taḏakp̱a mat nau ag Israel oolagp̱a bena, danab ah emalaṯeg mauheg am Kayak Nugib Moses amegp̱a a, mat doṯog laa brasp̱a ha qap̱e, danab ag amu neegna anidna, ag ii mauhp̱ig, amubia danab aun aḏi ag dahilnu oolagp̱a genab dooglagnu, ag bauklel hanhannu aon, hanhan bau daaglagnu, ag Danab Beḵalag da, ad emaitakp̱a aihiḏḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","Kayak Nug wan imup̱an danab oh dilag oo huana mauhom amunu Nug Beḵa laip̱unab me uḏiom. Nug me uḏiom amunu aun nug nuhignu oop̱a genab dooṯe ele amu, nug padal ii mema. Iiṯa! Nug bauklel daaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","Kayak Nug, Nug beḵa wan imup̱a me uḏiom amge Nug danab ah epeḏiadḵunu me ii uḏiom. Iiṯa. Kayak Nug nuhigp̱a danab ah oh eḏua diiadḵunu me uḏiom. ");
INSERT INTO gaw_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","Am aun nug nuhignu oop̱a genab dooṯe amu nug nob nau awaknu heṯoḏiakp̱a ii daaṯe amge aun nug nuhignu oop̱a genab ii dooṯe amu nug aaḵu nob nau awaknu heṯoḏiakp̱a teum daaṯe. Aḏinu? Nug Kayak beḵa laip̱unab amu nuhignu oop̱a genab ii doyom. ");
INSERT INTO gaw_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","Nob nau awaknu heṯoḏiak diig amu iiḵu, amahlak wanp̱a uḏiom amge danab ag wanp̱anu gatatu amunu oolag heum, ag amahlaknu oolag ii heum. Aḏinu? Ahilag kobol am nau. ");
INSERT INTO gaw_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","Amunu am danab oh ag hak naup̱a daaṯeb amu ag amahlaknu kekeḏ. Ahilag hak nau miag atimanu amu amahlakp̱a daaglagnu oolag ii daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","Amge laa nug kobol genabp̱a daaṯe amu nug nuhig kobol amu Kayak Nug a doya heum amu miag atiak anidḵulagnu amahlakp̱a daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","Anam maṯi malaeh, dimp̱a Jesus Nug nuhiḵud ip̱uniṯak awak danab ele ag Jerusalemnu ahan, Juda wanp̱a aben laih gona, Nug ag ele deḏ laala daanna, danab ah layaṯom. ");
INSERT INTO gaw_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","Johanes nug ele Inon, am Salen guguiṯak, ap̱a le kuḏum ele amunu nug ap̱a danab ah layaṯeṯe, ag uḏin layaṯak aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","Herodes nug Johanes mani guiṯak ii inom, haen amup̱a layaṯak amu dayom. ");
INSERT INTO gaw_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","Anam heegeg, Johanesnu ip̱uniṯak awak danab laala ag Juda danab laa ele, ag danab Juda dilag ḏop̱a op̱ia awak daaḵunu nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","Ag anam maṯina amu Johanesnu ip̱uniṯak awak danab ag gona, Johanes amegp̱a inam ap̱ig. “Ip̱uniṯak danab, danab laa Nug na ele anuḵa Jodan le laihp̱a daaiya, na nuhignu maṯime ele, danab amu Nug danab layaṯeṯe, danab ah oh nuhigp̱aib goṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","Anam aeg amu Johanes oḏelagp̱a awa aum. “Kayak hab aṯannu, Nug keeke laa danab ep̱egp̱a ii meeb amu danab nug nuḵa nuhig dab makp̱a keeke amu aoḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","Ag aḵa ele anuḵa da inam maṯiyi doon malap̱ig. ‘Da am Kristus iiṯa amge Kayak da meiḏe, da nuhig ib bap̱aidḵulnu anuqe uḏimi.’ ");
INSERT INTO gaw_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","Amunu amu da am nid baunu kadoi bia. Nid bau nug ah aoṯe amu ah amuam nuhigib amge kadoi nuhig nug layag ah bau awom doya, oo gamag ahaṯe. Nid baunu kadoi nug oo gamag ahak amu dooṯe amubia da Jesusnu oolp̱a gamag ahak oḵainab dooṯem. ");
INSERT INTO gaw_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","Nug onig amu oḵainab daaḵu, da amu nug waap̱aib daaḵul. ");
INSERT INTO gaw_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","Am laa Nug hab aṯannu neṯe amu Nug keeke oh eḏiṯak daaṯe. Laa nug wanp̱a beṯe amu nug wan imup̱anu keekeib madiṯe. Laa Nug hab abp̱anu neṯe amu Nug keeke oh eḏiṯak. ");
INSERT INTO gaw_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","Laa Nug hab aṯannu neum amu, keeke Nug doya malom amu keeke Nug anṯom ele, Nug amunu madiṯe amge laala ag oolagp̱a genab ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","Amge danab nug nuhig maṯiak doya dab medaṯe ele amu, nug Kayak Nug genabnu diig daaṯe, nug amu oop̱a g̱agaṯag genab dooṯe danab ah ip̱uanadṯe. ");
INSERT INTO gaw_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","Yo, laa Kayak me uḏiom amu Nug Kayak nai madiṯe amu Kayak Nug nuhig Ouḏi am bak medaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","Mame Kayak Nug Beḵanu oo mauhṯe amunu keeke oh Nug ep̱egp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","Am laa nug Kayak beḵanu oop̱a genab dooṯe ele amu, nug bau dayak hanhannu awom daaṯe. Laa nug nuhig nai dim ii lamidṯe amu nug bau dayak hanhannu ii awom. Iiṯa. Op̱oḏi bak, Kayak Nug danab dilag hip̱uninnu dooṯe ele amu, op̱oḏi bak amu nuhigp̱a daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","Haen amup̱a ḏo gumak danab-Parasia ag, “Jesus Nug Johanes eḏiṯa, danab ah kuḏum diia layadṯe,” nai anam doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","Amge Jesus ii layaṯom, nuhig ip̱uniṯak awak danab ag layadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","Ḏo gumak danab-Parasia ag nai amu doyeg, Jesus Nug amu doyom amunu Nug Juda atu uua, eḏua Galelia uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","Nug Galelia goḵunu ib elab uḵak uua, Samaria op̱ata wana, Galelia goḵunu ugaḵa, ");
INSERT INTO gaw_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","Nug Samaria ab oḵai laa onig Saika, ap̱a teum. Ab amuam Jakop nug beḵa Josep wan meṯom, amu guguiṯak. ");
INSERT INTO gaw_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","Anuḵa Jakop nug ap̱a le moḏ nuhig buuom. Amu Jesus Nug uḵa, amup̱a ta, beḏu bahi yom amunu Nug le moḏ amu guguiṯak hik awa, ap̱a dayom. Haen amu aam ameg tutuḵu anam. ");
INSERT INTO gaw_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","8","Jesus Nug dayeye, nuhiḵud ip̱uniṯak danab amu ag e daden meḵulagnu ab oḵai amup̱a gop̱ig. Amu Samaria ah laa le itaḵunu uḏiom. Uḏie Jesus Nug ah amegp̱a aum. “Na le aon dop̱e lai!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","Nug anam a amu Samaria ah nug aum. “Na amu Juda danab, da am Samaria ah. Amu aṯemun na, ‘Le aon dop̱e lai!’ aon aṯem? Da am Samaria ah, Juda ag Samaria ele ou qak ii oiṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","Ah anam a amu Jesus oḏep̱a awa aum. “Na Kayak Nug ḏo medaḵunu heṯe doolom amu na danab aun Nug nahipnu, ‘Na le aon dop̱e lai!’ aum ele amu, na Nug amegp̱a ap̱e, Nug na le bauklel ele amu meṯalo,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","Jesus Nug anam a amu ah nug aum. “Danab Naḏi, na le itaḵutnu tap̱iḏ iiṯa am le moḏ imu ele umanab unuqagnab daaṯe amunu amu na le bauklel ele amu adep̱anu aoḵutnu ame? ");
INSERT INTO gaw_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","Am ig alanig Jakop, nug le moḏ imu meḵom. Nug beḵod amu nuhiḵud bulmakau, sipsip ele ag anuḵa le imu ladap̱ig ele amu, na nug eḏidṯemte? Iiṯa!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","Ah anam a amu Jesus oḏep̱a awa aum. “Danab oh ag le moḏ imup̱anu le laṯeb ele amu, ag le lap̱eg, haen oh le baalag baula diiḵu ");
INSERT INTO gaw_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","amge laa nug le da medaṯem ele imu, nug amu laḵu amu nug baula le baag ii diima. Iiṯa. Le da medaḵul ele imu amu le moḏ bia nug oop̱a baaba daaḵu. Anam haen oh qep̱uḏia baaba, nug bau dayak hanhannu medaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","Jesus anam a amu ah nug Jesus amegp̱a aum. “Naḏi, le amu da meḏe! Meḏap̱e, da baula le baal ii diima, ip̱a haen oh le itaḵulnu ele ii uḏipa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","Anam a amu Jesus Nug amegp̱a aum. “Gona, na gamut ap̱e doyeb, eḏuya uḏieḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","Anam a amu ah nug Jesus oḏep̱a awa aum. “Da danab iiṯa,” awa aum. Anam a amu Jesus amegp̱a aum. “Na danab iiṯa aṯem am na genab aṯem. ");
INSERT INTO gaw_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","Aḏinu? Danab tanig ele ag tatam na gamutad daap̱ig amu danab laa gemu na ele daaṯep amu nug am na gamut iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","Jesus Nug anam a aria ah nug Jesus amegp̱a aum. “Danab Naḏi, da aaḵu na dooidmi, na am propet amunu ");
INSERT INTO gaw_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","na ap̱e doyei! Ig mamenḵad amu ag qauko imup̱a Kayak binag medap̱ig, gemu ig ele heṯem amge ag Juda amu, ag danab ah oh Jerusalem ap̱a binag meḵulagnu aṯeb, amu ig aṯem heḵunig am ena?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","Anam a amu Jesus oḏep̱a awa aum. “Ah, na dahil nai ootp̱a genab doye! Haen elab iiṯa ag baula Mame Kayak Nug binag meḵulagnu amu qauko imup̱aib binag ii memana o Jerusalem ap̱aib ele Mame Kayak Nug binag ii memana. ");
INSERT INTO gaw_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","Samaria ag amu ag Kayak binag meṯeb amu ag nuhig diig peheṯak ii dooṯeb amge eḏua diiaknu uḏat amu ig Juda ihinigp̱a beṯe amunu ig Nug binag meṯem amu ig nuhig diig tutuḵu dooṯem. ");
INSERT INTO gaw_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","Amge haen aaḵu uḏiom, danab ag binag mak genab heḵulagnu amu ag Kayak Nug diig ip̱uniḵom dab menana, ag Kayak Ouḏi ehaniṯakp̱a ele Mame binag meḵulag. Binag mak anam amu Mame Nug oo daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","Kayak Nug am Ouḏi amunu danab ag Nug binag elele meḵulagnu amu ag Nug diig ip̱uniḵom dab menana, ag Ouḏi ehaniṯakp̱a ele binag mep̱eg, elele beḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","Jesus anam a amu ah nug Jesus amegp̱a aum. “Da Mesias uḏiḵunu aeg doomi, Nug am Kristus aṯeb. Nug uḏia, keeke oh danab ah ip̱uanadḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","Ah nug anam maṯie amu Jesus amegp̱a aum. “Da na ele nai madiṯep imu amu daib am Nug aaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","Jesus anam aawo, haen amup̱a nuhiḵud ip̱uniṯak awak danab ag eḏun uḏin, Jesus Nug ah ele nai maṯieheh anatna, ag dab mak kuḏum aop̱ig amge laip̱u laa nug ah amegp̱a, “Na aḏin oot heṯe?” awa oot ii meṯom. O iiṯa, laa nug Jesus amegp̱a, “Na aḏinu nug ele nai madiṯep?” oḏ ii meṯom. ");
INSERT INTO gaw_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","Anam daaegeg, ah nug le itaḵunu hanak nuhig uue dayeye, eḏua abp̱a uḵa, danab amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","“Dona, danab imu anṯeg! Nug keeke oh da anuḵa hemi amu miag amelp̱a aum. Nug am Kristustai?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","Aria danab ag ahan, ab uuna, Jesus gumidna uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","Amge haen gamag amup̱a nuhiḵud ip̱uniṯak awak danab ag Jesus amegp̱a ap̱ig. “Ip̱uniṯak danab na e la!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","Amge Nug aum. “Da e laa ele, ag e amu ii dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","Nug anam a amu ip̱uniṯak awak danab ag aḵa aḵa nug oḏ meṯan ap̱ig. “Danab laa e nuhig awa uḏia meṯomtai,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","Ag anam maṯiegeg amu Jesus Nug aum. “Laa Nug da meiḏe uḏimi ele amu da Nug oḏe dim lamiṯeṯe, nuhig uḏat oh hein malaḵul amuam e dahil. ");
INSERT INTO gaw_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","Ag inam aon aṯeb. ‘Kalam waḏele uueb, e oḏuak haen doḵu,’ aon aṯeb. Amge da ag amelagp̱a aṯem. Ag amelag humana, atu oh italna anṯeg. E oh oḏun malap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","Am laa nug meu aoṯe amu nug nuhig uḏat nob awawa, nug danab laala bauklel hanhannu aoglagnu ehanadṯe. Ehanadṯe amunu e ep̱ak danab amu meu awak danab ele a oh oolah gamag ahaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","Anam daaṯe amunu nai imu am genab, ‘Danab laa nug e ebaṯe amu laa nug meu aoṯe’. ");
INSERT INTO gaw_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","Da danab laa uḏat hep̱igp̱a ag dahilad, gemu daaṯeb amu, ag dad amup̱a meu aoglagnu maaṯi gop̱ig. Laa ag tatam ahilag wagai makp̱a dad oop̱a e ebap̱ig amu ag oop̱a nona meu aoṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","Aria Samaria kuḏum ag ahnu nai doona, ag Jesusnu oolagp̱a genab doop̱ig. Aḏinu? Ah nug, “Da anuḵa keeke oh hemi amu Nug da amelp̱a aum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","Amunu Samaria danab ag Jesus gumidna donana, Nug ag ele daaglagnu unuqidp̱ig. Unuqiṯeg amu Jesus Nug deḏ aḏit ag ele ab amup̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","Anam daanna, danab kuḏumnab ag nuhig nai doona, oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","Oolagp̱a genab doona amu ag ah amu amegp̱a ap̱ig. “Ig na ame amup̱a oonigp̱a genab ii doomut. Iiṯa. Ig iḵa ele Nug oḏep̱a a doomut amup̱a ig aaḵu dooṯem, Nug am genab ig wan imup̱anu danab ah eḏua awiḵak danab,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","Deḏ aḏit amu uue, Jesus aha, Galelia uḵom amge ap̱ag diigp̱anab ii uḵom. Aḏinu? ");
INSERT INTO gaw_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","Jesus Nug nuḵa anuḵa, “Propet nug ap̱ag diigp̱a amu onig iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","Amu Nug uḵa, Galelia te, Galelia danab ag ele Pasowanu meṯid hobul naḏip̱a gona, ag Jesus Jerusalem ap̱a meṯid naḏip̱a uḏat heehe anidp̱ig amunu ag nuhignu oolag gamag ahom. ");
INSERT INTO gaw_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","Aria Jesus Nug Galelia wanp̱a oiyaya, ab onig Kana ap̱a uḵom. Ab amup̱a Nug anuḵa le he, eḏua wain beum. Ap̱a dayeye, Kapenaum abp̱a gabmannu iḵi danab laa amu nug beḵa oḏe ele dayom. ");
INSERT INTO gaw_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","Haen amu danab amu nug Jesus Judanu aha, Galelia teum doya, nug ab, Jesus Kapenaum uḵa heeb, beḵa ena daaḵunu unuqidḵunu uḵom. Aḏinu? Nug beḵa oḏe ele amu nug mauhḵunu miag dayom. Danab amu uḵa, Jesus gumiṯa ta, nug beḵanu Jesus unuqiṯe ");
INSERT INTO gaw_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","amu Jesus Nug nug amegp̱a inam aum. “Da hep̱i, ag ep̱onak keeke, danab heḵunu elele iiṯa diigdiig ii anidḵulag amu ag oolagp̱a genab ii dooglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","Nug anam a amu gabmannu iḵi danab nug aum. “Naḏi, nid dahil mauhmanu paha ne!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","Nug anam a, Jesus Nug amegp̱a aum. “Na oot ug aib dayom. Na uḵe! Na beḵat nug bau ena daaḵu,” awa aum. Danab amu nug Jesusnu nai doya, oop̱a genab doya, nug uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","Nug ugeḵe amu begbeg nuhiḵud ag uḏin, ibp̱a anidna amegp̱a ap̱ig. “Na beḵat nug bau meum daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","Anam aeg amu nug oḏ maṯom. “Aam ameg aṯenp̱a nug ena daaḵunu dig meum?” awa oḏ maṯom. Oḏ maṯe amu ag ap̱ig. “Tumai belo bek, wan kilok amu beḏu gakaḏak oug meum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","Aeg amu nug aam ameg amup̱anab Jesus Nug, nug beḵanu amegp̱a aum doyom amunu nug nuhiḵudp̱a ele ag oh oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","Jesus Nug Judanu Galelia uḏia amu ep̱onak keeke, danab heḵunu elele iiṯa namba tu aaḵu heum. ");
INSERT INTO gaw_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","Keeke amu oh ba male amu dimp̱a Juda dilag Pasowa meṯid hobul laa beum. Be amu Jesus Nug Jerusalem uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","Jerusalem ab aḏubnu od laa onig Sipsip Dilag Od, od amu guguiṯak amu le ameg laa dayom. Arameik naip̱a amu ag, ‘Betsaida,’ aon aṯeb. Le amu agap̱a danab daaglagnu ag ulah lag tanig ele, geḏiak iiṯa hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","Lag amup̱a oḏe danab kuḏumnab, amelag gaḏuak, diḏilag aḏak, beḏulag laih mauhak, ebehilag kaliaṯak ele daap̱ig. Ag le uḏalak ameg mena daadṯap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","Haen laala engel nug le amup̱a na, le amu uḏalṯom. Le uḏala male amu, aria danab aun nug tatam anuqa lep̱a noṯom amu nug oḏe nuhig aṯemutai ele amu haen agup̱a nug ena daaṯom. ");
INSERT INTO gaw_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","Aria danab laa ap̱a dayom amu nug maḏ 38 diḏi aḏak daaṯom. ");
INSERT INTO gaw_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","Jesus Nug danab amu niieye anṯa, Nug oḏe haen elab niiom amu Nug doya, danab amu oḏ meṯom. “Na ena daaḵutnu oot daaṯete?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","Awa a amu oḏe danab oḏep̱a awa aum. “Danab naḏi, haen le imu uḏalṯe amu danab laa da ehaniḏa, le umup̱a meiḏḵunu laa iiṯa. Da daḵa le amu oop̱a noḵulnu heiyi amu laa ag da qe eḏilna, ag tatam anuqna noṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","Danab anam a amu Jesus Nug danab amegp̱a aum. “Na hip̱aidna, niiak keeke nahip aon, maon uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","Jesus anam a amu pahanab danab beḏu ena daye, niiak keeke nuhig mawa, tap̱a uḵom. Jesus Nug amu heum amu Nug Juda dilag Meṯidp̱a heum ");
INSERT INTO gaw_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","amunu Juda oḵai ag danab niiak keeke mawom ele amu amegp̱a ap̱ig. “Gemu am Meṯid, na niiak keeke maomnanu ḏo daaṯe. Na aib tip̱alme,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","Aon aeg amu danab oḏelagp̱a awa aum. “Danab Nug he, da ena daami ele amu, Nug da amelp̱a, ‘Na niiak keeke nahip maon uḵe!’ aum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","Nug anam a amu ag danab oḏ medap̱ig. “Laa Nug na niiak keeke nahip maoḵutnu aum amu, danab amuam aun?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","Ag anam oḏ medap̱ig amge danab beḏu ena dayom ele amu, nug danab aun he, nug ena dayom ele amu nug ii doyom. Aḏinu? Danab, ah, nid naunau ele kuḏumnab amunu Jesus Nug ag oolagp̱a uḵa qeṯoḏom. ");
INSERT INTO gaw_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","Danab amu nug Jesus ii doyom amge dimp̱a Jesus Nug danab amu mana meṯak laḵa ap̱a anṯa, amegp̱a aum. “Anṯe! Gemu na beḏun paha eṯom. Ug naḏinab na tonidmanu amu na baula hip̱unin aib heme,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","Jesus anam a amu danab amu nug uḵa, Juda oḵai amelagp̱a aum. “Danab Nug he, da ena daami ele, Nug am Jesus,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","Nug anam a, Jesus Nug keeke amu Juda dilag Meṯidp̱a heum doop̱ig amunu diig amup̱a Juda oḵai ag Jesus ug meṯaglagnu dig mena ib madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","Ag anam hep̱ig amge Jesus Nug amelagp̱a aum. “Mama Nug hanhan uḏat heehe uḏiom, gemu ele haaha daaṯe amunu da ele uḏat heṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","Amup̱a Juda ag Jesus qep̱eg mauhḵununab oolag dayom. Aḏinu? Nug Meṯidnu ḏoib ii tip̱alom. Iiṯa! Nug, “Kayak Nug am da Mamelnab,” aum amunu nai amup̱a Nug Kayak ele laip̱u ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","Juda oḵai ag amunu eheḏ doop̱ig amunu Jesus Nug amelagp̱a inam aum. “Genabnab genab, da ag amelagp̱a aṯem. Kayak Beḵa da, dahil dab makp̱a keeke laa ii heṯem. Iiṯa. Da Mamel he anidmi amu da ele anamib heṯem. Keeke oh Mama heṯe amu Nug Beḵa da, da ele heṯem. ");
INSERT INTO gaw_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","Mama Nug dahilnu oo mauhṯe amunu keeke oh Nug heṯe ele amu, Nug da ip̱uniḏom. Nug geha uḏat kuḏum oḵainab, keeke amu oh eḏiṯak ele, ag oolag oṯaiḵunu, ip̱uniḏḵu. ");
INSERT INTO gaw_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","Mama Nug laa mauhp̱ig ele amu maḏ aṯe ahaeg, bau dayak madaṯe, amubia Nug Beḵa da, da ele laala bau dayak madaḵulnu ool daaṯe amu da madaṯem. ");
INSERT INTO gaw_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","23","Mama Nug danab laa ii epeḏiṯe. Iiṯa, Nug danab ah oh ag Nug binag meṯeb, amubia da binal meḵulagnu epeḏiak uḏat amu oh Nug Beḵa da, da ep̱elp̱aib meum. Am danab nug Kayak Beḵa da, da binal ii meṯe amu Mama, Nug da meiḏe uḏimi ele amu, Nug binag ele ii meṯe. ");
INSERT INTO gaw_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","Da genabnab genab ag amelagp̱a aṯem. Laa nug nai dahil doya, laa Nug da meiḏe uḏimi amu nuhignu ele oop̱a genab dooṯe amu nug bau dayak hanhannu ele, nug padal maknu epeḏiak ii anidma. Iiṯa. Nug aaḵu mauhaknu ib uua, gemu nug bau dayak hanhannu ibp̱a daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","Da genabnab genab ag amelagp̱a aṯem. Haen laa uḏiḵunu heṯe, gemu iiḵu uḏiom amu, mauhak aḏi ag Kayak Beḵa da, da baal dooglag. Am danab amu oolagp̱anu aun aḏi ag amu doona amu ag bau daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","Mama Nug nuḵa nuhig bauklel ele amubia Nug Beḵa da, da ele da daḵa dahil bauklel ele daaḵulnu meḏom. ");
INSERT INTO gaw_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","Amu ele, da am Danab Beḵalag amunu heṯoḏiakp̱a da danab epeḏiadḵulnu g̱agaṯag ele meḏom. ");
INSERT INTO gaw_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","29","Anam amunu ag dab mak kuḏum aib aop̱ig. Aḏinu? Haen laa uḏieb amu danab oh mauhp̱ig, moḏp̱a niiṯeb ele amu, ag da baal doona, ag mauhak aben uuna, eḏun hip̱aidḵulag. Am danab ag kobol ena hep̱ig ele amu ag eḏun hip̱aidna, bauklel daaglag. Danab ag kobol eheḏ hep̱ig ele amu eḏun hip̱aidna, ag heṯoḏiakp̱a daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","Am da daḵa dahil dab makp̱a keeke laa ii heṯem. Iiṯa, da Mama top̱anu nai aomi amup̱a da danab epeḏiadṯem amunu dahil epeḏiak am ena. Aḏinu? Da daḵa dahil dab mak ii dim lamidṯem. Iiṯa. Laa Nug da meiḏe uḏimi ele amu, Nug oo niiṯe amuib da dim lamidṯem. ");
INSERT INTO gaw_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","Am da daḵanab dahilnu nai imu maṯilom amu dahil nai maṯiak imuam elele iiṯa daalo ");
INSERT INTO gaw_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","amge laa daaṯe, amu Kayak, Nug dahilnu madiṯe. Amu da dooṯem, Nug nai tutuḵuib madiṯe. ");
INSERT INTO gaw_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","Am anuḵa ag danab laala maaṯeg Johanes top̱a uḵaeg, nug dahilnu genab maṯie doop̱ig ");
INSERT INTO gaw_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","amge danab ag dahilnu madiṯeb amunu amu da dab mak oḵai ii aoṯem. Iiṯa, amge ag Johanesnu nai dab mena, dahilnu oolagp̱a genab doop̱eg, Kayak Nug ag eḏua diiḵunu amu da amunu Johanesnu nai amu maṯimi. ");
INSERT INTO gaw_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","Johanes nug amu amahlak amahalṯe bia, nug amahlak ag maṯom. Maṯe, ag haen tutu amunu oolag ena daye, gamag ahak dooglagnu ena doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","Amge keeke laa ele Mame Nug da meiḏe uḏimi amu ip̱uanadṯe. Keeke amuam Johanesnu nai eḏidṯe. Keeke amuam uḏat da heṯem imu. Da Mamel Nug da amu hein malaḵulnu meiḏe uḏien heṯem. ");
INSERT INTO gaw_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","Aria Mama Nug da meiḏe uḏimi ele amu, Nug dahilnu maṯiom amge ag Nug oḏe naḵok laa iinab doop̱ig, ag Nug ele naḵok laa ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","Nug da meiḏe uḏimi ele amu ag dahilnu oolagp̱a genab ii dooṯeb amunu nuhig nai ag oolagp̱a ii daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","Ag Kayak nai yak niiṯe, nai amu eb qena autna aona, ‘Nai amu bau dayak megaṯe,’ aṯeb amge nai amuam dahilnu aaḵu aṯe ");
INSERT INTO gaw_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","amunu, aḏinu ag da gumiḏna uḏina, bauklel aoglagnu ii heṯeb? ");
INSERT INTO gaw_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","Da danab ag da binal meḵulagnu dab mak oḵai ii aoṯem ");
INSERT INTO gaw_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","amge da ag tutuḵu doyadṯem. Kayaknu oo mauhak kobol ahilagp̱a naḵok laa ii daaṯe amunu ag aḵa binalag aoglagnu dab mak oḵai aoṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","Da Mama onigp̱a uḏimi amu ag dahilnu oolagp̱a genab ii dooṯeb. Amge danab laa nug nuḵa nug onigp̱a uḏia, nai maṯieb amu ag nuhignu oolagp̱a genab dooglag. ");
INSERT INTO gaw_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","Ag am lailḵad dilagp̱a binalag oḵai aoglagnu heṯeb amge binalag laa, Kayak top̱anu uḏiṯe ele amu, ag amu aoglagnu ii heṯeb amunu ag aṯem hena, oolagp̱a genab dooglag? ");
INSERT INTO gaw_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","Da amu ag heṯoḏiakp̱a naip̱a yaaladḵulnu aib dab mep̱ig. Danab nug ag heṯoḏiakp̱a naip̱a yaaladḵu ele amu Moses. Danab amunu amu ag, ‘Nug ig ehanigḵu,’ aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","Ag Mosesnu nai oolagp̱a genab doolob amu ag dahilnu ele oolagp̱a genab doolob. Aḏinu? Nug am dahilnu nai yom. ");
INSERT INTO gaw_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","Amge ag nuhig nai yak amu oolagp̱a genab ii doonna amu aṯem hena, ag dahil nainu oolagp̱a genab dooglag?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","5","Imu dimp̱a Juda dilag Pasowa meṯid hobul haen miag do, Jesus Nug le ameg Galelia, laa ag le amunu, “Le ameg Taiberias,” aon aṯeb, le amu heqo laih goḵunu le amu mataḏom. Jesus Nug laih ugeḵe, danab kuḏumnab ag le ihi aiḏna, dim lamidna gop̱ig. Aḏinu? Ag Nug ep̱onak keeke, danab heḵunu elele iiṯa, oḏe danab beḏulagp̱a heehe, ag ena daaegeg anidp̱ig. Jesus Nug ap̱a uḵa, qauko naḵok laap̱a te, nuhiḵud ip̱uniṯak awak danab ele ag heḏep nena daap̱ig. Daanna amu Jesus Nug neeḵe uḵe, danab kuḏumnab ag gumidna uḏiegeg anaṯom. Amunu Nug Pilipus oḏ meṯom. “Ig e elele adep̱anu imu oh maṯagnignu daden meḵunig?” awa oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","Nug nai amu Pilipus oo anidḵunu oḏ meṯom, Nug nuḵa amu aṯem heḵunu amu matu doyom. ");
INSERT INTO gaw_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","Nug anam od meṯe amu Pilipus oḏep̱a awa aum. “Danab oh ag bret hup̱u naḵok naḵok laḵulagnu amu ig bret 1000 kina eḏiṯak daden meḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","Nug anam a amu nuhig ip̱uniṯak awak danab laa Andreus, nug Simon Petrus ele a am eamag amu, nug aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“Nid laa iiḵu daaṯe, nug am bali bret kunum tanig ele amu kakai aḏit ele. Amge amuam keeke nagnag, danab am huanak,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","A amu Jesus amelagp̱a aum. “Danab imu oh hep̱eg, ag heḏep nena dayeg!” awa aum. Ap̱a amu gikiḏah tep̱u ele dayom amunu danab oh ag heḏep nena daap̱ig. Danab amu ag 5,000 keeke anam. ");
INSERT INTO gaw_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","Ag daaegeg, Jesus bret diia aḏa, Kayak amegp̱a, “Ena hen meḵame,” awowa, bret pane ne, pania danab daap̱ig amu oh anen anen maṯom. Nug kakai amu ele anamib heum amu danab oh ag e elele aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","Haen danab ag oh oolag diṯia male, Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “E big niiṯe amu oh qag meig! Ig hup̱u naḵok laa ii kakidmata,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","Nug a amu ag e big qag mena amu kaleg tuelp inaeg am beum. Amuam bali bret tanig ele, danab laeg, oolag diṯe uup̱ig amu inap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","Danab ag Jesus kobol he anidp̱ig ele amu ag ap̱ig. “Genab ig propet laa nug wan imup̱a uḏiḵunu nai amu doomut ele am iiḵu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","Aria Jesus doyom, ag Nug aḏan hep̱eg, ahilag king daaḵunu hep̱ig amunu Nug aha, qauko laap̱a nuḵa uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","17","Aam no uu doowo, Jesusnu ip̱uniṯak awak danab ag le ameg ihip̱a nona, Nug ameg mena daap̱ig amge gatatu neene, Jesus Nug gumaṯa ii uḏiom amunu ag ubp̱a tena, le ameg maṯaḏna Kapenaum goḵulagnu gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","Uḵaegeg, ulah huanak dig meum amunu duban dig ma ahom. ");
INSERT INTO gaw_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","Duban ahehe, ag ub el qena, naḵok 4 o 5 kilomita anam uḵaegeg, Jesus Nug le gaḏap̱a tap̱a, ag guḵuaṯa do anidna, ag huana baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","Amge Nug amelagp̱a aum. “Ag aib baḏap̱ig, imu daib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","Nug anam a amu ag Nug aon, ubp̱a meḵulagnu hep̱ig. Heeg te, ub nug pahanab aben ag goḵulagnu gop̱ig ele amu guguiṯom. ");
INSERT INTO gaw_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","Deḏ Jesus danab kuḏum e maṯom, deḏ amu uue, deḏ amup̱a danab ah kuḏum amuib ag le ihip̱a ap̱a daap̱ig. Daanna amu ag ap̱ig. “Tumai amu ub laa iiṯa, laip̱u ip̱uniṯak awak danab tena gop̱ig ele aaḵuib dayom amu Jesus Nug nuhiḵud ip̱uniṯak awak danab ele oh ii gop̱ig, ag aḵa gop̱ig.” Ag amu maṯinna daanna doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","Aria ag anam doonna daap̱ig amu ub laala Taibiriasnu ag uḏin, Naḏi Nug unuqiṯowa, bret maṯe lap̱ig abenp̱a eeḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","Amunu danab ah ag Jesus, nuhiḵud ip̱uniṯak awak danab ele ap̱a ii daap̱ig doona, ag aḵa ubp̱a tena, Jesus maṯin Kapenaum gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","Ag gona, Jesus laih dayeye anidna, oḏ meṯan ap̱ig. “Ip̱uniṯak danab, Na haen aḏip̱a na ip̱a uḏime?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","Anam aeg amu Jesus oḏelagp̱a awa aum. “Da genabnab genab ag amelagp̱a aṯem. Ag ep̱onak keeke laala, danab heḵunu elele iiṯa hemi amu, ag amu anidp̱ig amge ag diig amunu da maṯiḏna ii uḏip̱ig. Iiṯa. Ag bret laeg, oolag diṯiom amunuib uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","Ag e aon lap̱eg, beḏulag g̱agaṯag qeeb, wan imup̱an uḏatib heḵulagnu amu aib anuqak doop̱ig. Iiṯa. Ag Kayak nai aon dab menan, nuhig uḏat heḵulagnu anuqak doyeg! Mama Kayak Nug da nai amu madaḵulnu g̱agaṯag meḏom amunu amu Danab Beḵalag da, geha ag madaḵul. Ag nai amu aon, uḏat hep̱eg, uḏat amuam iiṯa ii mema, hanhan daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","Nug anam a amu ag ap̱ig. “Ig aṯem heta, Kayaknu uḏat heḵunig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","Aeg am Jesus oḏelagp̱a awa aum. “Kayaknu uḏat amu iiḵu. Kayak Nug laa me uḏiom amu ag nuhignu oolagp̱a genab dooglag. Laa uḏiom amuam da,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","Jesus Nug anam aum amunu ag ap̱ig. “Na aḏi ep̱onak keeke, danab heḵunu elele iiṯa laa hep̱e amu ig anidta, oonigp̱a genab doognig? ");
INSERT INTO gaw_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","Ig mamenḵad ag atu taḏakp̱a bret laa onig mana lap̱ig amu Kayak naip̱a, nai amunu laa daaṯe. Nai amuam inam. ‘Nug hab aṯannu bret maṯe lap̱ig.’ Nai anam daaṯe amu na amubia heḵut-te?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","Aeg amu Jesus Nug amelagp̱a aum. “Da genabnab genab ag amelagp̱a aṯem. Moses nug hab aṯannu bret genab ii maṯom amge da Mamel, Nug amu hab aṯannu bret genab ag madaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","Bret Kayak madaṯe ele, amuam danab laa hab aṯannu neum. Bret amu Nug wanp̱anu danab ah bau hanhan dayak madaṯe,” awa aum ");
INSERT INTO gaw_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","Jesus anam a amu ag ap̱ig. “Naḏi, bret amuam na haen oh meḵe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","Aon aeg amu Jesus Nug aum. “Bau hanhan dayaknu bret am da. Danab nug dahilp̱a doṯe amu nug enug laa ii qema. Am danab nug dahilnu oop̱a genab dooṯe amu nug le baag laa ii diima. ");
INSERT INTO gaw_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","Amge da tatam ag amelagp̱a ami amubia. ‘Ag da aniḏp̱ig amge ag oolagp̱a genab ii dooṯeb.’ ");
INSERT INTO gaw_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","Amu danab ah aun Mame Nug da meḏaṯe ele amu, ag oh dahilp̱a doḵulag am aun nug dahilp̱a doṯe amu da nug ii geḏidpa. ");
INSERT INTO gaw_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","Aḏinu? Da hab aṯannu wanp̱a uḏimi amu da dahil maiṯak o dahil dab mak dim lamidḵulnu ii uḏimi. Iiṯa. Da am laa, Nug da meiḏe uḏimi ele amu, Nug oḏe dim lamidḵulnu uḏimi. ");
INSERT INTO gaw_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","Aria laa Nug da meiḏe uḏimi amu, Nug oo niiṯe ele amu inam. Danab ah oh da meḏom ele amu, ag ohnab dahilib daaglag. Laa ii qetoḏma. Wan haen malakp̱a da ohnab maḏ adap̱i, ag eḏun hip̱aidḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","Ao, da Mamel Nug oo niiṯe ele amu anam aaḵu. Danab aun ag Nug Beḵa da, ag da aniḏna, ag oolagp̱a genab dooṯeb ele amu, ag bau dayak hanhannu aoglag. Da daḵa geha wan haen malakp̱a maḏ adaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","Jesus Nug matu, “Da am hab aṯannu bret wanp̱a uḏimi,” awa aum amunu Juda ag nuhignu oolagp̱a elele ii daye, aḵa aḵa nai kuḏum madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","Ag inam maṯinna ap̱ig. “Danab umu Nug am Jesus, Josep beḵa. Nug anig mameg ele amu ig iite dooṯem? Aṯem he Nug, ‘Da hab aṯannu uḏimi,’ awa aṯe?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","Ag anam maṯiegeg amu Jesus Nug amelagp̱a aum. “Ag aḵa aḵa anam aib madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","Am laa nug nuḵa dahilp̱a doḵunu elele iiṯa, Mame, Nug da meiḏe uḏimi ele amu, Nug ehaniṯeb, aaḵuib am nug dahilp̱a doḵu. Doḵu amu da nug wan haen malakp̱a maḏ edaḵul. ");
INSERT INTO gaw_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","Propet dilag yakp̱a, nai inam niiṯe. ‘Danab ah oh am Kayak nuḵa nuhig kobol ip̱uanadḵu.’ Aria Nug ag ehanaṯa ip̱uanaṯe, ag Mame oḏe doona, nuhig kobol aona amu ag dahilp̱a doṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","Da danab laa Kayak anṯom ii aṯem. Iiṯa, danab ah wanp̱anu laip̱u laa nug amegp̱a Kayak ii anṯom. Iiṯa. Laa nug Kayak top̱anu uḏiom ele amu Nug aaḵuib Kayak anṯom. ");
INSERT INTO gaw_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","Genabnab genab da ag amelagp̱a aṯem, aun nug dahilnu oop̱a genab dooṯe ele amu, nug bau hanhan dayak ele awom daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","Da aaḵuib am bau dayaknu bret. ");
INSERT INTO gaw_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","Ag mamelḵad am atu taḏakp̱a e onig mana lap̱ig ele amu ag mauhp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","Amge bret hab aṯannu neum amu daib amu, laa nug bret imu laḵu amu nug ii mauhma, bau daaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","Da amu hanhan dayaknu bret hab aṯannu uḏimi. Am laa nug bret imu lanana amu nug bau hanhan daaḵu. Amu ele bret da danab ah oh madaḵul ele imu am, da beḏul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","Jesus Nug anam a amu Juda laala ag aḵa aḵa nai maṯin, “Aṯemnab danab imu Nug tep̱u ig meḵeb laḵunig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","Anam aeg amu Jesus amelagp̱a aum. “Genabnab genab da ag amelagp̱a aṯem. Ag Danab Beḵalag da, da tep̱ul tiil ele ii laḵulag amu ag bau ii daamna. ");
INSERT INTO gaw_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","Am laa nug da tep̱ul tiil ele laḵu amu nug bau dayak hanhannu ele, am wan haen malakp̱a da nug maḏ edap̱i, nug eḏua hip̱aidḵu. ");
INSERT INTO gaw_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","Aḏinu? Da tep̱ul tiil ele amu lanaknu e genab. ");
INSERT INTO gaw_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","Aun nug da tep̱ul tiil ele laṯe amu, nug dahilp̱a daaṯe amu da ele nuhigp̱a daaṯem. ");
INSERT INTO gaw_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","Mame, Nug bauklel daaṯe ele, Nug da meiḏe uḏimi amu, da nuhigp̱a bau daaṯem amubia aun nug da laiḏṯe amu, nug dahilp̱a bau daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","Bret imu amu ag mamelḵad bret lawona mauhp̱ig amubia iiṯa. Bret imu amu hab aṯannu neum, am aun nug bret imu laṯe amu nug haen oh bau daaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","Jesus Nug Kapenaumnu nai doyak laḵa ap̱a danab ah ip̱uanaṯaṯa, nai amu maṯiom. ");
INSERT INTO gaw_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","Aria nuhig ip̱uniṯak awak danab kuḏum ag nai maṯiom amu doona amu ag ap̱ig. “Nai umuam ug elenab, aun nug dooḵunu elele?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","Ag anam ap̱ig amge Jesus Nug ip̱uniṯak awak danab, ag aḵa aḵa nuhig nai maṯiak amunu ag oolagp̱a elele ii daye, nai kuḏum madip̱ig amu Nug nuḵa oop̱a matunab doyom amunu Nug ag amelagp̱a aum. “Ag nai amu aoglagnu elele iite dooṯeb? ");
INSERT INTO gaw_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","Anam dayeb amu Danab Beḵalag da, da anuḵa daadmi, aben amup̱a eḏuen tebip̱i am ag aṯem dooglag? ");
INSERT INTO gaw_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","Ag doyeg! Kayak Ouḏi nuḵa, Nug danab bauklel medaṯe, danabnu g̱agaṯag nug ig ehanigḵunu elele iiṯa. Am nai da ag maṯami imu nug Ouḏi amu nug bauklel ele. ");
INSERT INTO gaw_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","Anam daaṯe amge ag oolagp̱a laala ag oolagp̱a genab ii dooṯeb,” awa aum. Jesus Nug dig makp̱an aun aḏi ag oolagp̱a genab ii doop̱ig amu danab aun nug Jesus kekeḏ ep̱elagp̱a meḵu amu Nug amu oh doyom. ");
INSERT INTO gaw_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","Jesus Nug anam anana, Nug nai tuḏiṯa maṯiaya aum. “Diig amunu da ag amelagp̱a ami. Laa nug nuḵa nuhig dab makp̱a amu da gumiḏa ii doma. Iiṯa. Mame Nug laa ehaniṯe amu, nug aaḵuib da gumiḏa doṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","Jesus Nug nai amu maṯiom, haen amup̱a amu nuhig ip̱uniṯak awak danab laala ag Nug di medap̱ig, baula Nug dim ii lamidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","Jesus anam anṯa amu nuhig ip̱uniṯak awak danab tuelp amu ag amelagp̱a aum. “Ag ele da uuiḏna goḵulagnu oolag daaṯete?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","Jesus anam a amu Simon Petrus nug aum. “Naḏi, ig aun top̱a goḵunig? Nai nahip amu bauklel ele, haen oh daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","Ig na dooidta, oonigp̱a genab ele dooṯem, na aaḵuib am Kayak Beḵa op̱ia awak ele,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","A amu Jesus Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Da ag danab tuelp epeḏiadmi amge laip̱u laa ag oolagp̱anu amu nug ouḏi nau,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","Jesus Nug Simon Iskariot beḵa Judasnu aum. Ip̱uniṯak awak danab tuelp amu oolagp̱anu, nug laa aaḵu amge dimp̱a nug Jesus qep̱eg mauhḵunu kekeḏ ep̱elagp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","Keeke amu oh dimp̱a Jesus Nug laih Galelia ap̱a uḵa oiyom. Juda wanp̱anu Juda danab ag Nug qep̱eg mauhḵunu hep̱ig amunu Nug Juda wanp̱a oiḵunu uua, aha uḵa, Galelia ap̱a oiyom. ");
INSERT INTO gaw_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","Aria Juda ag memetalḵad ag Igipta wan uun oip̱ig amu ag amu peh hena, ap̱a meṯid laip̱u bia daanna dab meḵulagnu, ag Kayak ele binag meḵulagnu hobul laa hedap̱ig amu hobul amunu haen guguiṯe, ");
INSERT INTO gaw_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","Jesus amaḵud ag Nug amegp̱a ap̱ig. Na aben imu uuna, Juda wanp̱a uḵe! Gop̱e, nahipad ip̱uniṯak awak danab ag nahip uḏat, na heṯem ele amu, hep̱e anidḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","Danab laa nug danab laa oh nuhig uḏat anidḵulagnu oo daaṯe ele amu, nug loḵuma ii heṯe. Amunu na ep̱onak keeke, danab heḵunu elele iiṯa heṯem amu na danab ah oh noolagp̱a hip̱aidna daana he!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","Aḏinu? Jesus amaḵud ag ele nuhignu oolagp̱a genab ii doop̱ig amunu ag nuhignu anam madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","Jesus amaḵud ag anam maṯieg am Jesus Nug ag amelagp̱a aum. “Gemu da goḵulnu haennab iiṯa, haen imu oh am ahilagib. ");
INSERT INTO gaw_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","Wanp̱anu danab ah ag oolagp̱a ahilagnu nau, ninig ele dooglagnu elele iiṯa amge dahilnu ag anam dooṯeb. Aḏinu? Da haen oh kobol nau, tutuḵu iiṯa, ag heṯeb ele amu, da amunu madiṯem. ");
INSERT INTO gaw_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","Amu ag am hobulp̱a uḵeg! Da geha imu ii gopa. Da dahil haenp̱a goḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","Jesus Nug amaḵud amelagp̱a anam anana, Galelia ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","Aria Jesus amaḵud ag Juda dilag hobul amu anidḵulagnu uḵaeg, dimp̱a Jesus Nug ele uḵom amge Nug miag atiak ii uḵom. Loḵuma uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","Amu Juda ag hobulp̱a tep̱ig amu ag Nug maṯinna, ii anidna ap̱ig. “Danab amuam adep̱a daaṯe?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","Danab ah ag ele Jesusnu nai kuḏum madip̱ig. Laa am ap̱ig. “Nug am danab ena,” amge laa ap̱ig. “Nug am danab nau, nug danab ah kuḏum ham bup̱ualadṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","Anam madip̱ig amge ag Juda oḵai dilag baḏap̱ig amunu laip̱u laa nug ag noolagp̱a nai miag atiak laa ii maṯiom. ");
INSERT INTO gaw_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","Ag anam maṯiegeg, Jesus Nug meṯid hobul gamagp̱anab mana meṯak laḵa noa, danab ah amelagp̱a nai ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","Nug anam nai maṯieye amu ag dab mak kuḏum aonna, aḵa aḵa nug oḏ meṯan ap̱ig. “Danab imuam Nug sul laa ii heum amu Nug aṯem ha, doyak oḵainab awom?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","Ag anam maṯiegeg amu Jesus Nug ag amelagp̱a aum. “Da nai ag amelagp̱a madiṯem ele imuam dahil iiṯa. Kayak, Nug da meiḏe uḏimi ele amu, da nuhig nai madiṯem. ");
INSERT INTO gaw_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","Am danab laip̱u laa nug Kayak nai dim lamidḵu amu nug nai, da madiṯem imu, nai amuam Kayak top̱anu beum o iiṯa da dahil dab makp̱atai madiṯem amu nug dooḵu. ");
INSERT INTO gaw_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","Am danab laa nug nuḵa nuhig dab makp̱a nai madiṯe amu nug am nuḵa onig oḵai aoḵun heṯe. Amge danab laa, nug laa me uḏiom ele amu, nug onig humaṯe amu danab amu nug tutuḵunab, nug nuhigp̱a eheḏ laa ii daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","Anuḵa Moses nug ag ḏo maṯom amge ag oolagp̱a laip̱u laa nug ḏo amu tutuḵunab dim ii lamidṯe amunu aḏinu da iup̱eg mauhḵulnu heṯeb?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","Nug anam a amu danab ah ag ap̱ig. “Ouḏi nau laa na beḏunp̱a daaṯe. Aun nug na niṯebeb mauhḵutnu heṯe?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","Aeg am Jesus Nug aum. “Da Meṯidp̱a danab babaiṯak uḏat hemi amunu ag oṯaina dab mak kuḏum aoṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","Ag alalḵad ag dig mena Kayak oḏe dim lamidna, gaḏa otaḏak heegeg uḏie, Moses nug ḏo naip̱a meum daaṯe. Amunu ag ele Meṯidp̱a uḏat henana, nid naunau gaḏalḵad otaḏṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","Ag Mosesnu ḏo amu tip̱almananu, ag Meṯidp̱a uḏat hemananu ḏo, ag ḏo amu tip̱alna, Meṯidp̱a uḏat henan, nid naunau gaḏalag otaḏṯeb. Aria, ag anam heṯeb amunu da danab laa Meṯidp̱a beḏu babaiṯi, amu ag amunu aḏinu dahilnu op̱oḏilag beum? ");
INSERT INTO gaw_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","Ag amelagp̱aib keeke aib epeḏip̱ig. Dab mak tutuḵu aona, kobol tutuḵup̱a, dahil uḏat imu epeḏin anṯeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","Jesus Nug anam a amu Jerusalem danab laala, ag Juda oḵai ag Jesus qep̱eg mauhḵunu dab mep̱ig amu ag amu doona, ag ap̱ig. “Danab imuam ag qep̱eg mauhḵunu ap̱ig ");
INSERT INTO gaw_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","amge Nug geha iiḵu nai oh miag atiakib madiṯe amu ag nuhignu nai laa ii madiṯeb. Iḵi danab ag ele Nug am Kristus oolagp̱a genab doop̱igtai? ");
INSERT INTO gaw_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","Amge ig Nug ap̱ag diig am doot malamut. Kristus uḏiḵu am danab laip̱u laa nug Kristus ap̱ag diig dooḵunu iiṯa,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","Danab ah ag anam maṯiegeg, Jesus Nug mana meṯak laḵa danab ah noolagp̱a hibaiṯa dayaya, baag oḵaip̱a nai maṯiaya aum. “Ag da dooiḏṯeb, da ap̱al diig ele dooṯeb amge da daḵa dahil dab makp̱a ii uḏimi. Mame Nug da meiḏe uḏimi. Nuhig dig am genabib amge ag Nug ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","Da Nug dooṯem. Da Nug ele daaḏa, Nug da meiḏe uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","Jesus Nug anam a, ag Nug aḏaglagnu hep̱ig amge nuhig haen ii malom amunu laip̱u laa nug Jesus ii aḏom. ");
INSERT INTO gaw_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","Laala ag aḏaglagnu hep̱ig amge danab ah kuḏum nuhignu oolagp̱a genab doona, ag ap̱ig. “Danab imu Nug ep̱onak keeke, danab heḵunu elele iiṯa kuḏum heṯe amu haen Kristus Nug uḏiḵu amu Nug ep̱onak keeke, danab heḵunu elele iiṯa kuḏumnab, danab imu eḏiṯak heḵute? Iiṯa,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","Danab ah ag maṯiegeg, mana meṯak danab oḵai amu ḏo gumak danab-Parasia ele ag danab ah nai kuḏum maṯiegeg doona, ag ahilag daup laa Jesus aḏaglagnu maaṯeg uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","Uḏieg am Jesus Nug aum. “Da haen tutuib ag ele dayota, da eḏuen, laa Nug da meiḏe uḏimi ele amu, nuhigp̱a goḵul. ");
INSERT INTO gaw_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","Gop̱i, ag da aniḏḵulagnu heḵulag amge da ii aniḏmana. Amu ele aben da goṯem ele, amup̱a ag goḵulagnu elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","Anam a amu Juda ag aḵa aḵa nai maṯinna ap̱ig. “Nug adep̱a uḵeb, ig Nug ii anidmata? Nug Juda laala Grik wanp̱a daaṯeb, ahilagp̱a uḵa Grik danab ip̱uanadḵutai. ");
INSERT INTO gaw_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","Nug, ‘Ag da maṯiḏḵulag amge da ii aniḏmana,’ amu ele, ‘Da uḵe daaḵulp̱a amu ele ag goḵulagnu elele iiṯa’ awa aum, am Nug adep̱anab goḵunu aum? Nai amuam diig adeḵunab?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","Meṯid hobul amu malaknu deḏ beum, deḏ amuam hobul amunu naḏinab amu, haen amup̱a Jesus Nug hibaiṯa, baag oḵaip̱a ewa aum. “Danab laa nug le baag diieb amu nug da gumiḏa uḏia, le lanaḏ! ");
INSERT INTO gaw_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","Laa nug dahilnu oop̱a genab dooṯe amu, Kayak naip̱a yak laa daaṯe amubia. ‘Nug oop̱anu bau hanhan dayaknu le, nug ba ugaḵa daaḵu. Iiṯa ii mema.’ ");
INSERT INTO gaw_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","Jesus Nug nai amuam Kayak Ouḏinu aum. Danab ag oolagp̱a genab doona amu ag aoglag. Amge haen amup̱a Jesus Nug Mame top̱a ii uḵom amunu Kayak Ouḏi, Nug danab oolagp̱a ii dayom. ");
INSERT INTO gaw_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","Danab ah laala ag nai amu doona, “Genabnab danab imu am propet,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","Laala ag ap̱ig. “Nug am Kristus,” amge laala ag ap̱ig. “Kristus Nug Galelia ap̱ate beḵu? ");
INSERT INTO gaw_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","Kayak naip̱a yak laa daaṯe. Nai amuam inam. ‘Kristus nug Dawit buḏubp̱a Betlehem, anuḵa amuam Dawit ap̱ag diig amu, ap̱a beḵu,’” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","Danab ah ag anam maṯinna, ag otin, ameg aḏit daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","Daana, laala ag Jesus aḏaglagnu hep̱ig amge laip̱u laa nug ep̱eg bahia, Jesus ii aḏom. ");
INSERT INTO gaw_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","Anam heeg am daup ag eḏun, mana meṯak danab oḵai am ḏo gumak danab-Parasia ele gumadna uḵaeg amu ag ap̱ig. “Aṯem hena, ag Nug aḏan ii aon uḏip̱ig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","Anam aeg am daup amu ag ap̱ig. “Danab laa nug danab imu nai madiṯe bia laa maṯie ii anidmut,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","Daup ag anam aeg amu ḏo gumak danab-Parasia ag ap̱ig. “Jesus Nug ag elete ham bup̱ualaṯom? ");
INSERT INTO gaw_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","Ig iḵi danab, ig oonigp̱anu o iiṯa ḏo gumak danab-Parasia ag oolagp̱anu laip̱u laa Jesusnu oop̱a genab dooṯete? Iiṯanab. ");
INSERT INTO gaw_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","Amge danab ah amu ag ḏo ii dooṯeb, ag nob nau aoglagnu daaṯeb, ag nuhignu oolagp̱a genab dooṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","Anam maṯiegeg amu ag oolagp̱anu laip̱u laa, nug onig Nikodemus, nug anuḵa Jesus gumiṯa uḵom ele amu, nug oḏ maṯom. ");
INSERT INTO gaw_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“Ig ihinig ḏop̱a danab laa heṯoḏiakp̱a ii dayom haenp̱a, nug eheḏ heumnu aḵunignu am elelete? Iiṯanab. Nug keeke heum amu ig tatam doota amu ig nug epeḏignig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","Nug anam a amu ag nuhig nai inam nob mep̱ig. “Na ele am Galelia ted amunu na doyak iiṯatai? Na nai atog nona eb qena am tutuḵu anidna dooḵut. Propet laip̱u laa nug Galelia ap̱anu iinab bema,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","Anam daye amu danab oh aben aben uḵadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","Danab ah ag aben aben uḵadp̱ig amge Jesus Nug amu olipnu qaukop̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","Uḵe waḵaḏe buṯuanab Jesus eḏua uḏia, mana meṯak lag oop̱a no, danab ah kuḏum nug gumidna uḏieg, Nug heḏep na dayaya, nai ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","Nug anam ip̱uniṯak nai madeṯe, Juda dilag ḏo mehuqak danab amu ḏo gumak danab-Parasia ele ag ah laa gap̱ai kobol heehe anidna, aon dona, danab ah kuḏum noolagp̱a meeg, hibaiṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","Anam dayeye ag Jesus amegp̱a ap̱ig. “Ip̱uniṯak danab, ah imu nug gap̱ai kobol he anidmut. ");
INSERT INTO gaw_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","Mosesnu ḏo nug ig ah imubia menp̱a maḵuḏḵunignu ip̱unigṯe. Am na aḏi aṯem?” ");
INSERT INTO gaw_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","Ag nai amup̱a Jesus nai eheḏ laa ab amu ag Nug aḏan aon, heṯoḏiakp̱a mena, nai beḏup̱a yaaglagnu ib madip̱ig. Ag anam ap̱ig amge Jesus Nug gomela, ep̱eg hiqalp̱a dig ma, wanp̱a yaaya dayom. ");
INSERT INTO gaw_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","Anam dayom amge ag eḏunna, oḏ meṯak baubau hep̱ig. Anam heeg amu Nug eḏua tutuḵu dayaya, ag neeḵaṯaṯa aum. “Ag oolagp̱a aun laa nug hip̱unin iiṯa daaṯe amu nug tatam menp̱a ah imu maḵuḏaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","Jesus Nug anam awowa, Nug baula gomela, ep̱eg hiqalp̱a eḏua wanp̱a yaaya dayom. ");
INSERT INTO gaw_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","Aria danab amu ag nai anam doona, ag ohnab laip̱u laip̱u lag oop̱anu dimiṯim gona malap̱ig. Kaino ag tatam anuqna dimiṯim waegeg, laala dim gop̱ig. Uḵaeg Jesus Nugib dayeye am ah, nuhignu ap̱ig ele amu, nug ele Jesus noobp̱a hibaiṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","Nug anam dayeye, Jesus eḏua hibaiṯa oḏ meṯom. ‘Ah, ag adep̱a gop̱ig? Laip̱u laa na heṯoḏiakp̱a iite meiṯom?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","Anam a amu ah nug aum. “Naḏi, laip̱u laa anam ii heum,” awa aum. A amu Jesus aum. “Da ele na heṯoḏiakp̱a ii meidp̱a, na gona hip̱unin baula aib heme,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","Aria Jesus haen laap̱a baula danab ah amelagp̱a nai maṯiaya aum. “Da am wannu amahlak. Aun laa nug da dim lamiḏḵu amu nug gatatup̱a ii oima. Iiṯa, nug bauklelnu amahlak ele daaḵu.” ");
INSERT INTO gaw_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","Jesus anam maṯie amu ḏo gumak danab-Parasia ag ap̱ig. “Na naḵa nahipnu nai mehuqṯem amunu nai nahip am ham bup̱uak,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","Aon aeg am Jesus Nug aum. “Am genab, da dahil nai madiṯem amge dahilnu nai amu genab. Aḏinu? Da adep̱anu uḏimi amu da dooṯem, amu da eḏue goḵulnu amu da ele dooṯem. Amge ag da adep̱anu uḏimi amu adep̱a eḏue goḵul amu ag ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","Ag amu wannu kobolp̱a danabnu hak epeḏiṯeb. Da am epeḏiak uḏat laa ii heṯem. ");
INSERT INTO gaw_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","Amge da danab laa epeḏidlom amu da tutuḵunab epeḏidlom. Aḏinu? Da daḵa ii heṯem, Mame, Nug da meiḏe uḏimi ele amu, Nug da ele oh daaṯep. ");
INSERT INTO gaw_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","Ahilag ḏop̱a amu nai inam yak daaṯe. ‘Danab aḏit a nai diig laip̱u aṯep amu, nai ahilah am genab’. Yak anam niiṯe. ");
INSERT INTO gaw_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","Da daḵa da dahilnu nai madiṯem, Mame, Nug da meiḏe uḏimi ele amu, Nug ele dahilnu nai madiṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","Anam a amu ag Nug oḏ medap̱ig. “Na Mamen amu adep̱a daaṯe,” aon ap̱ig. Aon aeg amu Jesus Nug aum. “Ag am da ii dooiḏṯeb, da Mamel ele ag ii dooṯeb. Ag da dooiḏnalob amu da Mamel ele doolob,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","Nug nai amuam mana meṯak lag oop̱a, men doḏonu kunup guguiṯak dayaya ip̱uanaṯom amge Nug mauhḵunu haen ii malom amunu laa Jesus aḏaḵun ii heum. ");
INSERT INTO gaw_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","Amu Jesus baula ag amelagp̱a aum. “Da goḵulnu heṯem amu ag da geha maṯiḏḵulag amge ag da ii aniḏmana, hip̱unin ahilag amu ag tonaṯeb, mauhḵulag. Aben da goḵulp̱a ag ap̱a goḵulagnu elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","Nug anam a amu Juda ag aḵa aḵa nug oḏ meṯan ap̱ig. “Nug nuḵa Nug beḏu qa mauhḵute? Diig amunu Nug, ‘Ag da goḵulp̱a amu ag goḵulagnu elele iiṯa,’ aṯete?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","Aon aeg am Jesus Nug nai tuḏiṯa aum. “Ag am honapnu, da amu aṯannu. Ag am wan imup̱anu, da amu wan imup̱anu iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","Amunu da ag amelagp̱a tatam ami. ‘Ag hip̱unin ahilag amu ag tonaṯeb mauhḵulag.’ Am genab, ag da am Kayak ag amu oolagp̱a genab ii dooglag amu ahilag hip̱unin genab tonaṯeb mauhḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","Jesus anam a amu ag Nug oḏ medap̱ig. “Na am aun?” ap̱ig. Aeg am Jesus Nug aum. “Da tatam ai doop̱ig ele, da am anamnab aaḵuib. ");
INSERT INTO gaw_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","Da ag amelagp̱a nai kuḏum madiḵulnu elele, da heṯoḏiak danab, Nug danab heṯoḏiakp̱a epeḏiṯe, amubia da ag epeḏiadḵulnu elele amge laa Nug da meiḏe uḏimi ele, Nug am genabnu diig, da nuhigp̱a nai oh aomi amu da wanp̱anu danab amelagp̱a amuib madiṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","Nug anam aum amge ag Jesus Nug Mameg Kayaknu aum amu ag oolag ii maiṯom. ");
INSERT INTO gaw_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","Amunu Jesus Nug ag amelagp̱a aum. “Dimp̱a ag Danab Beḵalag da ad emaitakp̱a atuliḏona amu ag da am danab aun amu dooiḏḵulag. Amu ele, da dahil dab makp̱aib keeke ii heṯem. Iiṯa. Mame Nug da ip̱uniḏom amu da amunu madiṯem amu ele dooglag. ");
INSERT INTO gaw_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","Am aun Nug da meiḏe uḏimi ele, Nug da uuiḏe, daḵa ii daaṯem. Aḏinu? Da haen oh keeke Nug oo niiṯe ele amu, da amu heṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","Jesus anam a amu danab ah kuḏum ag nuhignu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","Juda danab ag Jesusnu oolagp̱a genab doop̱ig ele amu, Nug ag amelagp̱a aum. “Ag ip̱uniṯak nai dahil dim lamidṯeb dayeb amu ag am genab ip̱uniṯak awak danab dahiladnab daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","Ag geha nai genab dooglag amu nai genab amu heeb, ag uhuqak enap̱a daaglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","Jesus anam a amu laala nuhignu oolagp̱a genab ii doop̱ig amu ag ap̱ig. “Ig am Abraham beḵod, am ig haen laa wanp̱anu danab waap̱a laa ii daamut. Am aṯem hena, na ig uhuqak ena aognignu aṯem?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","Anam aeg am Jesus Nug aum. “Da genabnab genab ag amelagp̱a aṯem. Aun laa nug hip̱unin heṯe amu nug am hip̱uninnu begbeg daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","Laa nug danab oḵainu begbeg danab daaṯe ele amu nug oḵai amu nuhig nidnab ii daaṯe, haen oh nug laugp̱a ii daaṯe amge danab oḵai beḵa, nug amu nug mameg ele haen oh daaṯep. ");
INSERT INTO gaw_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","Amunu Danab Beḵalag da, da ag uhuqak madap̱i, ag genab uhuqak enap̱a daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","Da dooṯem, ag Abraham buḏup̱ud amge nai dahil amu ahilagp̱a ii daaṯe amunu ag da iup̱eg mauhḵulnu heṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","Da nai imu madiṯem ele amu, da Mame ele daaḏḏa doyen anidmi amu madiṯem amge ag am ag mamelagnu kobol heṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","Nug anam a amu ag ap̱ig. “Ig mamenig am Abraham,” aon ap̱ig. Aeg amu Jesus amelagp̱a aum. “Ag genab Abraham buḏup̱udlob, ag nug kobol heum bia helob. ");
INSERT INTO gaw_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","Da nai genab oh Mame top̱anu aomi amu maṯiyi doop̱ig amge ag da niḏaglag heṯeb. Abraham nug anam ii heum. ");
INSERT INTO gaw_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","Ag am ag mamelagnu kobol heṯeb,” awa aum. Jesus anam a amu ag ap̱ig. “Ig aninig nug ib imuagp̱a danab kuḏum ele oiyona ii menuiḵom. Ig mamenig laip̱u, Kayak aaḵuib,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","Aeg am Jesus amelagp̱a aum. “Ag mamelag genab Kayaklob, ag dahilnu oolag mauhlo. Aḏinu? Da Kayak ele daaḏa uḏimi. Da dahil maiṯakp̱a ii uḏimi. Iiṯa. Kayak Nug da meiḏe uḏimi. ");
INSERT INTO gaw_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","Am aḏinu ag dahil nai tutuḵu dab ii medaṯeb? Amu diig am ag dahil nai ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","Ag mamelag am Satan, ag nug beḵod daaṯeb amunu ag mamelag oo niiṯe amu ag dim lamidḵulagnu wagai meṯeb. Nug anuḵanu danab aqe mauhṯeb. Ag mamelag nug kobol genab ii dim lamidṯe. Aḏinu? Kobol genab amu nuhigp̱a ii daaṯe. Nug ham bup̱uak nai maṯiaya amu nug nuhig diig aaḵuib dim lamidṯe. Aḏinu? Nug nai ham bup̱uak madiṯe, nug nai ham bup̱uak mamegnab daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","Ag Satan beḵod daaṯeb amunu da nai genab madiṯem amu ag dahil nai ag oolagp̱a genab ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","Da hip̱unin laa ii hemi. Danab laa nug dahilnu, ‘Nug hip̱unin heum,’ aḵunu elele iiṯa amunu da nai genab madiṯem imu amu aḏinu ag oolagp̱a genab ii dooṯeb? ");
INSERT INTO gaw_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","Laa ag Kayak beḵod daaṯeb ele amu, ag Kayak oḏe dim lamidṯeb. Ag amu Kayak beḵod ii daaṯeb amunu ag nai ii dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","Awa a amu Juda danab ag Jesus oḏep̱a aon ap̱ig. “Ig nahipnu genab aṯem. Na Samaria ted, ootp̱a hahail ele,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","Aeg am Jesus oḏelagp̱a awa aum. “Da oolp̱a hahail iiṯa, da amu, da Mamel binag humaṯem amge ag da binal qeeg neṯe. ");
INSERT INTO gaw_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","Da daḵa da binal ele daaḵulnu ii heṯem. Iiṯa! Laa, amuam Kayak, Nug da binal humaṯe. Nug da heṯoḏila, eheḏ laa ii anidṯe. ");
INSERT INTO gaw_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","Da genabnab genab ag amelagp̱a aṯem, laa nug dahil ip̱uniṯak nai awa dim lamidḵu amu nug iinab mauhma,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","Awa a amu ag nug amegp̱a ap̱ig. “Gemu ig genab dooṯem, na ootp̱a hahail ele! Abraham nug mauhom amu propet ele mauhp̱ig, amge na aṯem, ‘Laa nug nahip nai dim lamiṯa amu nug am iinab mauhma.’ ");
INSERT INTO gaw_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","Na nahipnu aḏi dooṯem? Na ig mamenig Abraham eḏiṯakte? Nug amu propet laa oh ele ag oh mauhp̱ig amge danab ag na dim lamidṯeb ele, ag ii mauhmananu aṯem. Na naḵa nahipnu aḏinab dooṯem?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","Aon aeg amu Jesus oḏelagp̱a awa aum. “Da daḵa da binal ele daaḵulnu hep̱i amu da binal am hamu. Amge da Mamel, ag nuhignu, ‘Nug am ihinig Kayak,’ oḏelagib aṯeb amu, Nug da binal ele daaḵulnu heṯe. ");
INSERT INTO gaw_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","Ag Nug ii dooṯeb amge da amu Nug dooṯem. Da nuhignu, ‘Da Nug ii dooṯem, alom amu da ag bia ham bup̱uak danab daalom amge da Nug dooṯem amunu nuhig nai ele dim lamidṯem. ");
INSERT INTO gaw_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","Ag mamelag Abraham nug dahil uḏiak haen anidḵunu oo gamag ahehe, ameg ma dayom. Nug anṯa, nug oo gamag ahom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","Awa a amu ag Nug amegp̱a ap̱ig. “Na maḏ nahip 50 iiṯa dayeye, na Abraham anidmenu aṯem. Na ham bubuṯem,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","Anam aeg, Jesus ag oḏelagp̱a awa aum. “Da genabnab genab ag amelagp̱a aṯem. Abraham ii dayom haenp̱a da daami, gemu daaṯem, buṯi aḏi daaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","Nug anam aum amunu ag Nug maḵuḏḵulagnu men agap̱ig amge Jesus Nug danab kuḏum oolagp̱a beḏu loḵumiṯaṯa, mana meṯak lag oop̱anu aha wana, dimiṯim uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","Jesus Nug dimiṯim uḵa, Nug wana, ib man ugaḵa, danab ameg gaḏuak ele anṯom. Nug anig oop̱anu ameg gaḏuak ele anam doum. ");
INSERT INTO gaw_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","Jesusnu ip̱uniṯak awak danab ag amu anidna ap̱ig. “Ip̱uniṯak danab, aun nug hip̱unin he, anig nug danab amu ameg gaḏuak ele menuom. Nug hip̱unin heumte, o iiṯa anig mameg eletai hip̱unin hepiḏ?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","Anam aeg amu Jesus amelagp̱a aum. “Danab amu nuhig hip̱uninp̱a o anig mameg ele dilah hip̱uninp̱a ameg gaḏuak ii awom amge kobol amu beum amunu Kayaknu uḏat amu danab amup̱a miag atia beḵu. ");
INSERT INTO gaw_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","Amahlak aaḵu daaṯe amunu ig laa, Nug da meiḏe uḏimi ele amu, nuhig uḏat heḵunig. Gatatu neḵunu haen aaḵu malaṯe, gatatu neeb amu aun laa nug uḏat ii hema. ");
INSERT INTO gaw_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","Da wan imup̱a dayeye, da amahlak madaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","Jesus anam anana, Nug hunue, wanp̱a no, wan ele kabolia awa, danab amegp̱a qata qeum. ");
INSERT INTO gaw_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","Qata qewowa, danab amegp̱a aum. “Na gona, Siloam le amegp̱a amen ihe!” awa aum. Siloam diig amu meeg uḵom. Amunu nug uḵa, le layowa, ena daya, neeḵa, nug eḏua uḏiom. ");
INSERT INTO gaw_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","Aria, nuhig lag od laip̱u amu laiḵud ab laip̱u amu laa ag nug anuḵa dayaya, men doḏonu unuqṯom ele amu anidna ap̱ig. “Nug am anuḵa danab laa nug keekenu danab unuqadṯom ele amutai?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","Laa ag ap̱ig. “Nug aaḵuib,” aon ap̱ig. Aeg am laa ap̱ig. “Iiṯa, nug danab ameg gaḏuak ele amubia,” aon ap̱ig. Amge nug nuḵa amu, “Da iiḵuib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","Nug anam a amu ag nug oḏ medap̱ig. “Na amen aṯemnab ha, ena dayom?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","Aeg am nug ag amelagp̱a aum. “Danab laa onig Jesus aṯeb amu Nug wan waḏu ele kabolia, amelp̱a mewowa, Nug da amelp̱a aum. ‘Na gona, Siloam le amegp̱a amen ihe!’ awa aum. Amunu da uḵe, amel ihai amu amel ena daye, da iiḵu neegṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","Nug anam a amu ag nug oḏ medap̱ig. “Danab amuam adep̱a daaṯe?” aon ap̱ig. Aeg amu nug aum. “Da ii dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","Nug anam a amu ag nug omalna, do gumak danab-Parasia, ag gumadna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","Haen amuam Juda dilag meṯid deḏ dayeye, Jesus wan waḏu ele kabolia, danab amu ameg babaiṯom. ");
INSERT INTO gaw_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","Anam amunu do gumak danab-Parasia ag eḏun oḏ medap̱ig. “Na amen amu aṯemnab ha, ena dayom,” aon ap̱ig. Aeg amu nug ag amelagp̱a aum. “Nug wan leḵoh amelp̱a me, da amel ihai amu da amel ena dayom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","Danab nug anam a amu ḏo gumak danab-Parasia laa ag Jesusnu ap̱ig. “Danab amuam Kayak top̱anu ii uḏiom. Aḏinu? Nug ihinig Meṯidnu ḏo ii dim lamidṯe,” aon ap̱ig amge laa ag ap̱ig. “Aṯemun ha, danab hip̱unin ele Nug ep̱onak keeke danab heḵunu elele iiṯa amubia anam heḵu?” aon ap̱ig. Ag anam anana, op̱atna ameg aḏit daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","Ag anam hena amu ag eḏun, danab anuḵa ameg gaḏuom ele amu oḏ medap̱ig. “Danab amu Nug na amen babaiṯom amunu na nuhignu aḏi aṯem?” aon ap̱ig. Anam aeg am nug aum. “Nug am Propet,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","Nug anam aum amge Juda oḵai ag nug anuḵa ameg gaḏuom, gemu nug ameg ena daaṯe amu ag amunu oolagp̱a genab ii doona, danab amu anig mameg ele onilahp̱a eeg uḏieh, ");
INSERT INTO gaw_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","oḏ matan ap̱ig. “Imu a beḵalahte? A nuhignu nug iiḵuib anuḵa anig oop̱anu ameg gaḏuak ele doum aṯepte? Amu aṯem ha, nug eḏua neegṯe?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","Ag anam oḏ mataeg amu a apiḏ. “Imu am nid ihinih amu i dooṯep, nug anig oop̱anu ameg gaḏuak ele doum. ");
INSERT INTO gaw_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","Amge aṯem ha, nug aaḵu neegṯe, o aun nug ameg he, ena dayom amu i ii dooṯep. Ag nug oḏ meṯeg! Nug oḵai meum. Nug nuḵa nuhig nai maṯieb doyeg!” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","Anig mameg ele a Juda oḵai dilag baḏapiḏ amunu a anam apiḏ. Juda oḵai ag tatam nai inam qagap̱ig. “Danab laip̱u laa nug Jesus am Kristus aḵu amu nug lamidp̱ut, Juda dilag nai doyak lag uua, aḏ dimiṯim noḵu,” ap̱ig amunu a baḏapiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","Ag anam ap̱ig amunu danab anig mameg ele a apiḏ. “Nug oḵai meum, ag nug oḏ meṯeg!” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","Juda oḵai ag ahilah nai doon, danab amu genab ameg gaḏuak dayom, gemu ena daaṯe oolagp̱a genab doop̱ig amunu ag baula ameg gaḏuak ena dayom ele amu onigp̱a eeg uḏie, ag nug amegp̱a ap̱ig. “Na Kayakib binag me! Ig dooṯem, danab amuam hip̱unin danab,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","Ag anam aeg amu nug aum. “Nug hip̱unin danabtai o iiṯatai amu da ii dooṯem amge keeke laip̱uib da dooṯem. Da anuḵa amel gaḏuak daami am Nug he, da eḏue neegṯem. Aaḵuib da dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","Nug anam a amu ag nug amegp̱a ap̱ig. “Nug aṯemnab heum? Nug amenp̱a aṯemnab he, na neegṯem?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","Ag anam aeg amu nug aum. “Da tatam amelagp̱a ami amge ag ii dab mep̱ig. Aḏinu ag baula dooglagnu heṯeb? Ag ele nuhig ip̱uniṯak awak danab daaglagnu heṯebte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","Nug anam a amu ag guhuḏidnana ap̱ig. “Na aaḵu nuhig ip̱uniṯak awak danab. Ig am Mosesnu ip̱uniṯak awak danab. ");
INSERT INTO gaw_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","Ig dooṯem Kayak Nug Moses nai meṯom amge danab amuam adebtagnu uḏiom amu, ig ii dooṯem,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","Ag anam aeg amu danab ameg ena dayom ele amu nug aum. “Imu am laanab, ag Nug adep̱anu uḏiom ii dooṯeb amge Nug he, da amel obatom. ");
INSERT INTO gaw_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","Ig dooṯem Kayak Nug hip̱unin danab oḏelag ii dooṯe amge danab aun nug Kayaknu kobol dim lamidṯe, Nug oo aṯem niiṯe amu heṯe ele amu Kayak Nug oḏe dooṯe. ");
INSERT INTO gaw_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","Anuḵa dig makp̱anu uḏiak gemu batak amu danab laa nug anig ameg gaḏuak ele menue, danab laa ameg babaiṯe, ameg ena dayomnu laa ii dooṯem. ");
INSERT INTO gaw_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","Kayak Nug danab imu meeb ii uḏilo amu Nug keeke inam laa ii helo,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","Nug anam a amu ag amegp̱a ap̱ig. “Na anin nug menuiṯe, na hip̱unin danab daame amunu aḏinu na ig ip̱unigḵutnu heṯem?” Ag anam anana, lamiṯeg, dimiṯim uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","Jesus ag danab amu lamidp̱ignu nai doya, Nug danab amu maṯia anṯa, amegp̱a aum. “Na Danab Beḵalagnu ootp̱a genab dooṯemte o iiṯa?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","Jesus anam a amu nug aum. “Naḏi, Danab Beḵalag amu aun? Na ap̱e da nuhignu oolp̱a genab dooḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","Nug anam a amu Jesus aum. “Na Nug anidme amu danab Nug geha iiḵu na ele nai madiṯep am Nug aaḵuib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","Anam a amu danab nug aum. “Naḏi, da oolp̱a genab dooṯem,” awa aum. Nug anam anana, dup noa Jesus binag meum. ");
INSERT INTO gaw_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","Danab nug anam he, Jesus aum. “Da danab epeḏiadḵulnu wan imup̱a uḏimi amunu amu danab ag ameg gaḏuak bia elele ii daanna dooṯeb ele amu, ag oolag eḏueb, ena daaglag. Laa ag danab nug ena neegṯe amubia ag aḵa ahilagnu, ‘Ig am danab ena,’ aṯeb amu, ag oolag ii eḏueb, ag ena ii daamna,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","Ḏo gumak danab-Parasia laa ap̱a nug guḵuidna daap̱ig ele amu, ag amunu ap̱ig. “Ig elete danab ena iiṯa, amenig gaḏuak bia?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","Anam aeg am Jesus Nug ag amelagp̱a aum. “Ag amelag gaḏuak daalo amu ag hip̱unin iiṯa daalob. Amge ag, ‘Ig amenig ii gaḏuom,’ aṯeb amunu am ahilag hip̱unin ana daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","Jesus Nug nai amu maṯia mala, Nug nai imu ele maṯiom. “Da genab ag amelagp̱a aṯem. Danab laa nug sipsipnu aḏ odp̱a ii noṯe, nug aḏ leta noṯe ele, danab amu nug am yabhok danab. ");
INSERT INTO gaw_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","Am danab nug aḏnu odp̱a tutuḵu noṯe ele amu, nug am sipsipnu gumak danab. ");
INSERT INTO gaw_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","Amunu nug uḏie amu sipsipnu od gumak danab nug od matula mete, nug oop̱a no, sipsip nuhiḵud ag nug baag dooṯeb. Ag dooṯeb amu nug nuhiḵud sipsip onilagp̱a ewa diia, dimiṯim goṯe. ");
INSERT INTO gaw_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","Haen nug sipsip nuhig diia dimiṯim uḵa amu nug anuqa ugeḵe, sipsip ag nug baag doon dim lamidṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","Ag danab laa dim ii lamidṯeb. Iiṯa. Ag oolna goṯeb. Aḏinu? Ag danab laa amu nug baag ii dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","Jesus Nug keeke danab ag dooṯeb ii dooṯeb ele ou aqaṯa, amu ip̱uanaṯaṯa mehuqom amge ag aḏinu aum amu ag oolag ii maiṯom ");
INSERT INTO gaw_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","amunu Jesus Nug nai laa maṯiaya aum. “Sipsip ag laulag oop̱a goḵulagnu amu ag ahilag aḏ oḏep̱a goṯeb. Amubia da genabnab genab ag amelagp̱a aṯem. Da daḵa am hab abp̱a uḵaknu od daaṯem. Danab ag hab abp̱a goḵulagnu amu daib ehanadp̱i goḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","Laa oh anuqna uḏina, ‘Da am Kristus,’ ap̱ig ele amu ag am yabhok danab amu keeke laanu mauhnoak eeḏa awak danab. Amge sipsip ag danab amu baalag ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","Da daḵa am od. Laa nug dahilp̱a doa, aḏ oop̱a noa amu haen oh ena daaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","Yabhok danab nug sipsip yab awa, aqeb mauhḵulagnu uḏiṯe amge da uḏimi ele imu amu, ag bau dayak enanag amu madaḵulnu uḏimi. Ag aop̱eg ahilagp̱a am bak daaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","Da daḵa amu sipsip gumak danab ena. Sipsip gumak danab ena nug sipsip ena daaglagnu mauhḵunu dayeb amu mauhḵu. ");
INSERT INTO gaw_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","Danab nug uḏat nob aoḵunu uḏat heṯe amu nug sipsip gumak danab genab iiṯa, nug sipsip mamelag ele iiṯa amunu nug qai daḵuḏ anṯa amu nug sipsip uuaṯa, oola ugeḵe, qai daḵuḏ nug sipsip aqa lamaṯe, mauhnoak oolna, matatun tamtam goṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","Danab amu nug nob aoḵunuib uḏat heṯe amunu nug oolṯe. Nug sipsip peheṯak dab ii madaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","Da daḵa amu sipsip gumak danab ena. Da dahilad sipsip doyadṯem, sipsip ag ele da dooiḏṯeb ");
INSERT INTO gaw_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","amubia Mame Nug da dooiḏeḏe, da Mame dooṯem. Laa ele, da dahilad sipsip, ag ena daaglagnu dab mein dayeye, dahil bau dayak hep̱i iiṯa meḵu. ");
INSERT INTO gaw_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","Da am sipsip laa, aḏ dahil imup̱an iiṯa, amu ele dahilad, da amu ele diiḵul. Diip̱i, ag da baal dooglag amu, ag oh sipsip ameg laip̱uib daap̱eg, ahilag gumak danab ele daib daaḵul. ");
INSERT INTO gaw_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","Da daḵa bau dayak dahil eḏue aoḵulnu da dahil bau dayak hep̱i iiṯa meḵu amunu Mame Nug dahilnu oo mauhṯe. ");
INSERT INTO gaw_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","Laa nug heeb, bau dahil iiṯa meḵunu am iiṯa, da daḵa dahil bau hep̱i, iiṯa meḵu. Da dahil g̱agaṯagp̱a bau dayak dahil hep̱i, iiṯa meḵu amu dahil g̱agaṯagp̱a bau dayak dahil eḏue aoḵulnu dooṯem. Am da Mame top̱anu g̱agaṯag amu aomi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","Jesus anam a, Juda danab ag doona, eḏun op̱atna, ameg aḏit daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","Anam daanna, kuḏum laa ag ap̱ig. “Ouḏi nau nuhigp̱a daaṯe amunu Nug ootot qe heṯede. Ag aḏinu Nug oḏe dooṯeb?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","Ge laa am ap̱ig. “Imu am danab ouḏi nau elenu nai iiṯa. Ouḏi nau nug danab ameg gaḏuak ele heeb, ameg op̱atḵute?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","Am Jerusalem ap̱a meṯid hobul laa, ag anuḵa mana meṯak lag od eḏun matulp̱ig ele, meṯid hobul amu daulagp̱a daaḵunu haen be, danab ah oh ap̱a qag mep̱ig. Haen amuam oug haen. ");
INSERT INTO gaw_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","Jesus Nug haen amup̱a mana meṯaknu lag talilia geḏiak oop̱a noa, Solomonnu aben aṯeb ele amup̱a noa, aben amup̱a oiyom. ");
INSERT INTO gaw_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","Nug anam noa oiyeye, Juda ag dona hip̱aidna, Jesus oo meṯan daanna ap̱ig. “Na haen ganebnab hep̱e, ig dab mak aḏit ele daaṯem amu iiṯa meḵu? Na genab Kristus daaṯem dayeb amu na peh eṯana tutuḵu miag atiak ap̱e dootu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","Anam aeg amu Jesus Nug ag amelagp̱a inam aum. “Da amelagp̱a ami amge ag oolagp̱a genab ii doop̱ig. Uḏat oh da Mame onigp̱a heṯem amu ele, da am Kristus, ipuanadṯe. ");
INSERT INTO gaw_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","Amge ag am dahil aḏp̱anu sipsip iiṯa amunu ag oolagp̱a genab ii dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","Sipsip dahilad amu ag da baal dooṯeb, da ele ag doyadṯem. Doyaṯiṯi ag da dim lamiḏṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","Ag da dim lamiḏegeg, da ag bau dayak hanhannu madaṯem. Ag padal ii memana. Iiṯanab. Laa nug da ep̱elp̱anu mataḵaṯa ele ii diima. ");
INSERT INTO gaw_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","Da Mamel Nug ag da meḏom amu, Nug am keeke oh eḏaṯak. Laa ag Nug ep̱egp̱anu iinab mataḵa aoma. ");
INSERT INTO gaw_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","Da Mamel ele amu i am laip̱u,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","Jesus anam a amu Juda oḵai ag baula men aon, maḵuḏp̱eg mauhḵunu hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","Maḵuḏḵulagnu heeg amu Nug ag amelagp̱a aum. “Da Mamenu g̱agaṯagp̱a uḏat ena ena kuḏumnabp̱a danab ah ehanadmi amu aḏi uḏat amu ena iiṯa anidna, da menp̱a oiḏp̱eg mauhḵulnu heṯeb?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","Jesus anam a amu Juda ag ap̱ig. “Ig uḏat ena laa dab meṯa, na menp̱a oidp̱ut mauhḵutnu ii heṯem. Iiṯa. Na Kayak dap̱idna, aon aon qedaṯem, na danab hamu amge na, ‘Da am Kayak,’ aon ame amunu ig heṯem,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","Aeg amu Jesus aum. “Ahilag ḏop̱a Kayak oḏe inam yak niiṯe. ‘Da ami, ag am Kayak ganiap̱ud.’ ");
INSERT INTO gaw_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","Anuḵa Kayak nai wan imup̱an danab, amu dilagp̱a uḵom amu Nug ahilagnu, ‘Ag am Kayak ganiap̱ud,’ aum. Aria ig dooṯem, Kayak nai keeke laa ham bup̱uak ii ip̱unigṯe? Iiṯa! Tutuḵuib ip̱unigṯe ");
INSERT INTO gaw_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","amunu aḏinu ag dahilnu, ‘Nug Kayak dabiṯa, awa awa qedṯe,’ aṯeb? Kayak Nug da tituaniḏa, meiḏe wanp̱a uḏimi. Nug anam heum amu anuḵa Nug wan imup̱an danab laa dilag, ‘Ag am Kayak ganiap̱ud,’ aum amunu, ‘Da am Kayak beḵa,’ ami am aḏinu ag amunu, ‘Nug Kayak aben aoḵunu heṯe,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","Da Mamenu uḏat ii heṯem dayeb doona amu ag oolagp̱a genab aib doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","Amge da Mamenu uḏat heṯem dayeb, ag amunu dahil nainu oolagp̱a genab dooglagnu elele iiṯa dayeb amu da uḏat laala, danab haknu elele iiṯa heṯem amu, ag amu anidna, oolagp̱a genab doyeg! Amup̱a ag doyak aona amu Mame Nug dahilp̱a dayeye, da nuhigp̱a daaṯem amu tutuḵu dooglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","Jesus Nug anam a, ag nug aḏaglagnu hep̱ig amge Nug ag eḏaṯaṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","Anam daye amu Jesus Nug eḏua, Jodan le mataḏa, anuḵa Johanes nug danab ah dig ma layaṯak maṯomp̱a, ap̱a uḵa dayom. ");
INSERT INTO gaw_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","Nug ap̱a dayeye amu danab ah kuḏum Nug gumidna uḏip̱ig. Uḏin amu ag ap̱ig. “Genab, Johanes nug am kobol danab heḵunu elele iiṯa laa ii heum amge nug nai oh danab imunu maṯiom ele amu oh genabib,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","Ag anam anana, danab ah kuḏum ag Jesusnu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","Aria danab laa onig Lasarus, Beṯani ted, nug am oḏe ele. Amu Maria Mata ele, a ele am ab amup̱anu. ");
INSERT INTO gaw_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","Maria, nug am Jesus baegp̱a goḏen gokaḏowa, iḵi uḏugp̱a op̱iom ele, ah amu aaḵuib, nug ap̱inag Lasarus nug oḏe meum. ");
INSERT INTO gaw_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","Lasarus nug oḏe meum amunu nug ap̱inkuḏ a nai meeh, Jesus top̱a uḵe apiḏ. “Naḏi, na nuhignu oot mauhṯe ele, danab amu aaḵu oḏe meum,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","Jesus Nug amu doya aum. “Oḏe amuam danab nug mauha iiṯa maknu iiṯa. Iiṯa, oḏe amup̱a Kayak Nug binag oḵai aweb, Kayak Beḵa da, da ele amup̱a binal oḵai aoḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","Jesus Nug Maria, Mata amu a ap̱inlah Lasarus ele, Nug amu dilagnu am oo mauhṯom. ");
INSERT INTO gaw_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","Aria Nug Lasarus oḏe me doyowa, Nug deḏ aḏit laa ele ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","Dayaya dimp̱a Nug nuhiḵud ip̱uniṯak awak danab amelagp̱a aum. “Ig eḏut, Juda gotu!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","Nug anam a amu ag ap̱ig. “Naḏi, tumainab iiḵu Juda oḵai ag menp̱a oidḵulagnu hep̱ig am na eḏun goḵutnu aaḵu heṯemte?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","Aeg amu Jesus aum. “Aam laip̱u am aua 12 haen oh iite daaṯe? Am danab nug amunp̱a aam amahlakp̱a oiṯe, nug amahlak anidṯe amunu nug na ii qeṯe. ");
INSERT INTO gaw_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","Amge danab nug tuqan oiṯe dayeb amu nug amahlak laa iiṯa amunu nug na qeṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","Jesus nai amu maṯia mala am Nug aum. “Ig lainig Lasarus nug niiom amge da uḵen maḏ edaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","Anam a amu ip̱uniṯak awak danab ag ap̱ig. “Naḏi, nug niiṯe dayeb amu nug ena daaḵu,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","Jesus Nug Lasarus mauhomnu aum amge ag oolagp̱a amu, “Nug genab niiṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","Ag anam dab meegeg amu Jesus Nug miag atia amelagp̱a aum. “Lasarus mauhom ");
INSERT INTO gaw_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","amge da nug ele ap̱a ii daamuḏ amunu amu da ool gamag ahaṯe. Aḏinu? Da ahilagnu dab meṯem. Da dahil uḏat laa hep̱i, ag kobol amup̱a ag dahilnu oolagp̱a genab dooglag. Ahap̱eg, ig gota anidtu!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","Amu Tomas, nuhignu ag Didimas ele aṯeb amu, nug ip̱uniṯak awak danab laa amelagp̱a aum. “Dop̱eg, ig gop̱ut, Juda hep̱eg, ig Nug ele mauhtu!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","Aria ag ahan gona, Beṯani ap̱a teeg amu ap̱anu danab ag amelagp̱a Lasarus deḏ waḏele moḏp̱a niiomnu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","Jerusalemnu Beṯani ukak amu naḵok kilomita aḏit o laip̱u keeke anam, umanab iiṯa ");
INSERT INTO gaw_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","amunu Juda kuḏum ag Mata Maria ele a lailah mauhom, a amunu a oolah ena daaḵunu ehanatḵulagnu gumatna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","Ag gona daaegeg, Jesus Nug uḏieye, Mata nug Jesus ibp̱a uḏiṯenu nai doya, nug Jesus ib manp̱a anidḵunu uḵom amge Maria nug laḵa dayom. ");
INSERT INTO gaw_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","Mata nug uḵa, Jesus anṯa, amegp̱a aum. “Naḏi, na ip̱a daalom amu da ap̱inal nug ii mauhlo. ");
INSERT INTO gaw_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","Amge da dooṯem, na geha iiḵu ele keeke laanu Kayak unuqidp̱e amu Nug amu medaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","Nug anam a amu Jesus Nug amegp̱a aum. “Na ap̱inam amu eḏua hip̱aidḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","A amu Mata nug aum. “Ao da dooṯem, gogtak haenp̱a danab ah eḏun hip̱aidḵulag, haen amup̱a nug ele eḏua hip̱aidḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","Anam a amu Jesus Nug aum. “Eḏua hibaiṯaknu diig am da, bau dayak hanhannu diig amu ele daib. Laa nug dahilnu oop̱a genab dooṯe ele amu, nug mauhḵu amge nug bauklel aoḵu. ");
INSERT INTO gaw_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","Amu danab oh ag dahilnu oolagp̱a genab dooṯeb ele amu ag bauklelib daaglag. Na nai amu ootp̱a genab dooṯemte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","Jesus anam a amu Mata aum. “Ao Naḏi, na am Kristus. Na Kayak Beḵa wan imup̱a uḏime. Da amu oolp̱a genab dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","Mata anam anana amu nug uḵa, Maria onigp̱a e do, omala, naḵok giginp̱a uḵa, qinonob amegp̱a aum. “Ip̱uniṯak danab uḏiom, up̱a uma ibp̱a dayaya, na oninp̱a eṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","Maria nai amu doya, nug pahanab aha, Jesus gumiṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","Jesus Nug abp̱a paha ii teum, Nug ibp̱a, Mata uḵa anṯom ele, aben amup̱a ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","Aria Juda ag Maria ele laḵa ap̱a nug oo ena daaḵunu daap̱ig ele amu, ag nug pahanab aha, dimiṯim uḵe anidna, ag, “Nug ap̱inag mahidḵunu matmatp̱atai goḵunu goṯe,” anana, ag ahan, Maria dim lamidna gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","Maria nug uḵa, Jesus aben amup̱aib dayeye anṯom. Anṯa amu guguiṯa wana, Jesus baegp̱a dup noa aum. “Naḏi, na ip̱a daalom amu da ap̱inal ii mauhlo,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","Maria anam a amu Jesus Nug Maria gayeye anṯa, Juda ag Maria ele uḏip̱ig amu, ag ele gaaegeg anaṯom. Anam anaṯa amu Nug ele oo hik bop̱ane, gaaḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","Anam haaha amu Nug aum. “Ag adep̱a mep̱ig?” awa aum. A amu ag ap̱ig, “Naḏi na uḏin anṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","Anam aeg amu Jesus gayom. ");
INSERT INTO gaw_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","Juda ag amu anidna ap̱ig. “Anṯeg, Nug danab amunu oo huanak mauhom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","Amge laa amu ap̱ig. “Nug am danab amelag gaḏuak ele amu he ena daaṯeb am nug haen imup̱a daalo amu danab imu ehaniṯeb ena daalotai?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","Aria Jesus aaḵu anam baula oo hik bop̱anene, Nug moḏ guguiṯa waum. Moḏ amuam ag men oḏe laa bap̱aidp̱ig. Bap̱aidna men laap̱a moḏ oḏe amu tonap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","Amu Jesus Nug amelagp̱a aum. “Ag men oḏe amu matuleg!” awa aum. Nug anam aum amge Mata nug aum. “Naḏi, nug deḏ waḏele moḏp̱a niiom amunu uḏig oṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","A am Jesus Nug aum. “Da tatam na amenp̱a ami. ‘Na ootp̱a genab dooḵut amu na Kayak ebehi gemu anidḵut,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","Jesus anam a, ag men moḏ ameg matulp̱ig. Matuleg, Jesus hab aṯan neeḵaḵa aum. “Mame, na unuqiṯak dahil doome amu da amunu, ‘Ena heme,’ awe aṯem. ");
INSERT INTO gaw_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","Da dooṯem, na dahil unuqiṯak haen oh dooṯem amge da danab ah daaṯeb imu dilag heina, nai imu na amenp̱a aṯem. Amup̱a ag na da meiḏe uḏimi amu ag oolagp̱a genab dooglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","Nug anam unuqiṯowa amu Nug huanak ewa aum. “Lasarus, na ahan dimiṯim do!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","Anam a amu danab mauhak amu aha, dimiṯim doum. Ag nug baeg, ep̱eg, iḏu amu oh lamen laa linen amup̱a itap̱ig amunu nug uḏie, Jesus Nug amelagp̱a aum. “Lamen uhuqp̱eg uḵaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","Jesus danab mauhak maḏ eṯe amu Juda kuḏum Maria anidḵulagnu uḏip̱ig ele amu, ag Jesus uḏat amu he anidna, ag nuhignu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","Amge laa ag gona, ḏo gumak danab-Parasia amelagp̱a Jesus aḏi heum amunu madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","Maṯieg amu mana meṯak danab oḵai amu ḏo gumak danab-Parasia ele ag Juda dilag heṯoḏiak oḵai onig Sanhidren, amunu danab oh qag maadna ap̱ig. “Ig aṯem heḵunig? Danab imu Nug ep̱onak keeke, danab heḵunu elele iiṯa kuḏum heṯe. ");
INSERT INTO gaw_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","Ig dootta daap̱p̱ut, Nug inamib heeb amu danab ah oh nuhignu oolagp̱a genab dooglag. Genab doop̱eg amu geha Rom ag, ‘Umuam king laa ahom daaṯe,’ anana, ag uḏin, ihinig mana meṯak lag lop̱aḏna, hep̱eg nauheb, ig ele lamigp̱eg, laih goḵunig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","Amge danab laip̱u laa, ag oolagp̱a dayom ele amu, nug onig Kaiapas, nug maḏ amup̱a mana meṯak danab dilag iḵi dayom ele amu, nug laiḵud amelagp̱a aum. “Ag keeke laip̱u iinab dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","Ag imunu dab mak iitai aop̱ig? Ig oh Rom ep̱egp̱a mauhḵunig am ena iiṯa. Yo, danab ah oh mauhḵulag am ena iiṯa amge danab laip̱u nug danab ah oh abenlag awa mauhḵu, amuam ena amunu danab umu Nug mauhaḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","Nug nuḵa nuhig dab makp̱a Jesus mauhḵunu nai amu ii aum. Iiṯa. Maḏ amup̱a nug mana meṯak danab dilag iḵi dayom amunu Jesus mauha, Juda ehanadḵunu aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","Amu ele nug Jesus Juda dilagib mauhḵunu ii aum. Iiṯa. Nug Jesus mauhḵu amup̱a danab ah atu ohp̱a daaṯeb amu Nug ag oh diia, qag maaṯeb, ag Nug beḵod daaglagnu aum. ");
INSERT INTO gaw_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","Aria Juda oḵai ag deḏ agup̱aib dig mena, Jesus qep̱eg mauhḵunu nai madip̱ig ");
INSERT INTO gaw_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","amunu Jesus Nug baula Juda oolagp̱a miag atiak ii oiyom. Nug ab amu uua, aha ab laa onig Epraim, atu taḏak guguiṯak, ap̱a uḵom. Uḵe, nuhiḵud ip̱uniṯak awak danab ele ag ab amup̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","Ag ap̱a daaegeg, Juda dilag Pasowa meṯid hobul miag doum amunu ab laih laihnu danab ah oh Jerusalem ap̱a, ag aḵa tatam oolag bap̱aidna op̱ia awak daap̱eg, hobul dig meḵunu hena gona amu, ");
INSERT INTO gaw_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ag Jesus madip̱ig. Ag mana meṯak lag oop̱a daanna amu ag aḵa aḵa nug oḏ meṯan ap̱ig, “Ag aṯem dooṯeb? Nug Pasowanu meṯid hobul anidḵunu iitai uḏima,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","Am mana meṯak iḵi danab amu ḏo gumak danab-Parasia ele ag tatam danab amelagp̱a, danab laa nug Jesus adep̱a daaṯe amu doya amu nug ag amelagp̱a ab, Jesus aon mani guiṯakp̱a meḵulagnu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","Aria Pasowa meṯid hobul beḵunu heehe, deḏ eblaih laip̱u anam daye, Jesus Nug tatam danab mauhe maḏ eṯom ele, onig Lasarus, amu ap̱agp̱a, Beṯani uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","Ag Jesusnu lewa nakok ab amup̱a heeg, Mata nug e yeeye, Lasarus nug amu, Jesus, danab laala ele ag balap̱a daanna e lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","E lanana, Maria nug goḏen, bala onig nadp̱a hep̱ig ele, muṯuḏig enanag, ug nuhig amu paun laip̱u, nuhig daden oḵai ele amu, nug amu awa, Jesus baeg laaiṯowa, iḵi uḏugp̱a op̱iom. Anam he, goḏennu muṯuḏig amu lag amu oh tona malom. ");
INSERT INTO gaw_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","Amge nuhiḵud ip̱uniṯak awak danab laa, Judas Iskariot, nug Jesus kekeḏ ep̱elagp̱a meḵu ele amu, nug aum. ");
INSERT INTO gaw_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“Goḏen umu amu nuhig nob am maḏ laip̱unu uḏat nob eḏiṯak amunu aḏinu nug danab laa daden meḵunu ii meum? Nug anam ha, men doḏo aololob amu nug daḏek danab maṯalo,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","Judas nug anam awa aum amge nug daḏek danab dilag dab ma ii aum. Iiṯa. Nug ip̱uniṯak awak dilag men doḏonu kunup gumama yab aoṯom amunu men doḏo amu kunupp̱a melo amu nug yab aolo. ");
INSERT INTO gaw_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","Judas nug anam a amu Jesus Nug aum. “Uue! Ah imu nug da boomiḏḵulagnu beḏul babaiṯom. ");
INSERT INTO gaw_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","Daḏek danab amu, ag ag oolagp̱a hanhan daaglag amge da am ag ele haen oh ii daamta,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","Ag anam henan daaegeg, Juda kuḏum ag Jesus ab amup̱a daaṯe doona, ag gumidna uḏip̱ig amge ag Jesusib anidḵulagnu ii uḏip̱ig. Iiṯa. Jesus Nug Lasarus moḏp̱anu maḏ eṯe ahom amunu ag Lasarus anidḵulagnu ele uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","11","Juda kuḏum ag Lasarus anidḵulagnu gona, ag Jesus he, Lasarus moḏp̱anu eḏua hibaiṯom amu dab menana, ag Jesus oolagp̱a genab doop̱ig amunu mana meṯak danab oḵai ag Lasarus ele qep̱eg mauhḵunu nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","Aria, danab ah ameg naḏi ag meṯid hobul anidḵulagnu uḏin ap̱a daap̱ig. Daaegeg, deḏ naḏi ii nak haenp̱a, buṯi neḵunu dayom amu, danab kuḏum ag Jesus Jerusalem uḏiṯe amu doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","Ag anam doona, ag ad ep̱eg uḏug ele anam qiialadna, Jesus ibp̱a anidḵulagnu gop̱ig. Uḵaeg, Jesus ele nug uḏa tena ap̱ig. “Ig Kayak onig humatu! Danab imu Nug Kayak onigp̱a uḏiṯe. Kayak Nug itidṯe. Nug am Israel dilag King! Kayak Nug itidṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","Jesus Nug donki nag laa naḵok oḵai meum ele amu anṯa, Nug amup̱a ta dayom. Nug Kayak naip̱a, nai laa daaṯe, amubia heum. Nai amuam inam. ");
INSERT INTO gaw_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“O Sion, Na aib baḏame! Anṯe, king nahip aaḵu uḏiṯe, Nug donki nag, nakok oḵai meum ele amu, nug aṯan dayaya uḏiṯe.” ");
INSERT INTO gaw_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","Yak anam niiṯe amge Jesusnu ip̱uniṯak awak danab ag tatam nai amunu diig amu ag oolag ii maiṯom. Dimp̱a Jesus Nug hab abp̱a uḵe, haen amup̱a ag nai yak nuhignu niiṯe amu danab ag Jesusnu hep̱ig amunu ele dab mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","Aria Lasarus nug mauha moḏp̱a niiom, haen amup̱a am danab ah kuḏum ag ele daanna, Jesus Nug Lasarus onigp̱a ewa maḏ eṯe, aha dimiṯim do anidp̱ig amu, ag amunu maṯiegeg, ");
INSERT INTO gaw_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","danab ah laala ag Jesus Nug ep̱onak keeke, danab heḵunu elele iiṯa amu heum, ag nai amu doop̱ig amunu ag Jesus ibp̱a anidḵulagnu gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","Ag gop̱ig amunu ḏo gumak danab-Parasia ag aḵa aḵa nai maṯin ap̱ig. “Ig nuhig ib oo neḵunignu elele iiṯa. Anṯeg! Danab ah oh Nug dim lamidṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","Amu haen amup̱a Grik laala ag ele Jerusalem ap̱a danab ah ag meṯid hobul amu anidḵulagnu uḵaegeg, ag ele oh gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","Grik danab amu ag Betsaida ted Pilipus gumidna gona, amegp̱a ap̱ig. “Danab naḏi, ig Jesus anidḵunignu oonig daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","Aeg am Pilipus uḵa, Andreus amegp̱a aum. A amu Andreus nug Pilipus ele oh goya, Jesus amegp̱a apiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","Aeh amu Jesus Nug amelahp̱a aum. “Danab Beḵalag da, da onil oḵai aoḵulnu haen aaḵu uḏiom. ");
INSERT INTO gaw_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","Genabnab genab da ag amelagp̱a aṯem. Buah aeg nug wanp̱a ii na qeḵu, qaḏu beebeb, aeg nug ele ii beḏaḵu amu aeg nug aaḵuib daaṯe amge nug wanp̱a na qa beḏaḵu dayeb amu nug bau ba, meu huanak oṯe. ");
INSERT INTO gaw_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","Anam amunu aun nug beḏu wan imup̱anuib bau daaḵunu dab mak oḵai aoṯe amu nug padal meḵu. Amge aun laa nug wan imup̱an beḏu bau dayak oo ii qeṯe, amunu dab mak oḵai ii aoṯe amu, nug bau dayak nuhig haen oh nuhigp̱a daaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","Amu laa nug dahil uḏat heḵunu dayeb amu nug da dim lamiḏaḏ! Am da adep̱a daaṯem am dahil uḏat danab nug ele ap̱a daaḵu. Am laa nug da dim lamiḏḵu amu Mame Nug ele nug binag humaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","Jesus Nug nai amu anana, Nug nai tuḏiṯa aum. “Da oolp̱a dab mak kuḏumnab aoṯem. Da, ‘Mame, na haen imunu mua nau imu hep̱e da ii anidpa,’ aḵulte? Iiṯa! Da uḏat imu heḵulnu uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","Jesus Nug anam anana amu Nug nai tuḏiṯa aum. “Mame, na binan humap̱e oḵai dayaḏ!” awa aum. Anam a amu baag laa hab aṯannu na aum. “Da tatam binal oḵai humami amu baula oḵainab humaḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","A amu danab ah laala ap̱a daap̱ig amu ag, “Haḵaḏ qeum,” aon ap̱ig. Laa am ap̱ig, “Engel nug, Nug amegp̱a nai maṯiom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","Ag anam aeg amu Jesus ag amelagp̱a aum. “Baag imu am da ehaniḏḵunu ii neum. Iiṯa! Ag ehanadḵunu neum. ");
INSERT INTO gaw_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","Gemu amu wan imup̱an danab oh dilag epeḏiak haen. Gemu haen imu amu, wan imunu gumak danab nau amu lamiṯeb dimiṯim goḵu. ");
INSERT INTO gaw_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","Amge da ad emaitakp̱a atuliḏḵulag, haen amup̱a amu da danab ah oh eeḏadp̱i, ag dagatolp̱a doḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","Jesus Nug nuhig mauhaknu ib amu miag atiḵunu, Nug nai anam maṯiom. ");
INSERT INTO gaw_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","Nug anam maṯie amu danab ah kuḏum nug oḏep̱a aon ap̱ig. “Ig ḏop̱a nai inam doomut. ‘Kristus Nug hanhan daaḵu!’ Am aṯemun na Danab Beḵalag aihḵulagnu aṯem? Danab Beḵalag Nug am aun?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","Anam aeg am Jesus Nug aum. “Ag haen naḵoknab laa ele amahlak ele daaglag. Haen imup̱a ag amahlak ele amunu gatatu ag tonadmanu ag amahlak ele oiyeg! Laa nug gatatup̱a oiṯe amu nuhig ib ii anidṯe. ");
INSERT INTO gaw_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","Ag amahlak ele daanna amu amahlaknu oolagp̱a genab doyeg! Ag oolagp̱a genab dooglag amu ag amahlak beḵod daaglag,” awa aum. Jesus nai amu awowa, uuaṯa, ag amelagnu loḵumom. ");
INSERT INTO gaw_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","Jesus Nug danab ah kuḏum amelagp̱a ep̱onak keeke, danab heḵunu elele iiṯa heum amge ag nuhignu oolagp̱a genab ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","Ag oolagp̱a genab ii doop̱ig amunu ag heeg, propet Jesaianu nai aaḵu elele meṯom. Propet nug nai inam aum. “Naḏi, danab laa nug ihinig nainu oop̱a genab ii dooṯe. Am danab laa nug Naḏi Nug uḏat g̱agaṯag heum amu uḏat amunu diig ii dooṯe.” ");
INSERT INTO gaw_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","Ag nai ii doop̱ig, Kayaknu uḏat oḵainu diig ele ii doop̱ig amunu ag Jesusnu oolagp̱a genab ii doop̱ig. Keeke amunu am Jesaia nug nai laa inam ele yom. ");
INSERT INTO gaw_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“Nug danab amu ag amelag he gaḏuom, ag oolag ele he, g̱agaṯag ep̱om amunu ag amelagp̱a keeke laa anidna, oolag eḏueb, oolag tutuḵu dab medap̱eg, da ag bap̱aladḵulnu elele iiṯa.” ");
INSERT INTO gaw_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","Jesaia Jesus binag oḵainab anṯom amunu nug Jesusnu aum. ");
INSERT INTO gaw_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","Jesaia anam anṯa yom amubia iḵi danab kuḏum ag oolagp̱a genab ii doop̱ig amge laala, naḵok kuḏum, ag oolagp̱a genab doop̱ig. Ag oolagp̱a genab doop̱ig amge ag ḏo gumak danab-Parasia, amu dilag baḏap̱ig. Ag ag lamadp̱eg, nai doyak lag dimiṯim daamnanu baḏana, oolagp̱a genab doyak amu miag ii atip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","Ag danab ag binalag meḵulagnu dab mak oḵai aop̱ig. Kayak Nug ag binalag meḵunu amu, ag amunu dab mak oḵai ii aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","Amu Jesus huanak ewa nai maṯiaya aum. “Laa nug dahilnu oop̱a genab dooṯe amu nug dahilib oop̱a genab ii dooṯe. Iiṯa. Aun nug da meiḏe uḏimi ele amu, Nug nuhignu ele oop̱a genab dooṯe. ");
INSERT INTO gaw_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","Am laa nug da aniḏṯe amu nug aun da meiḏe uḏimi ele amu Nug ele anidte. ");
INSERT INTO gaw_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","Amu laa nug dahilnu oop̱a genab dooṯe, nug gatatup̱a ii oimanu amu da amahlak awen, wan imup̱a uḏimi. ");
INSERT INTO gaw_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","Am laa nug dahil nai doya dim ii lamidṯe amu da nug ii epeḏipa. Da wan imup̱an danab epeḏiadḵulnu ii uḏimi. Iiṯa. Da ag eḏuen diiḵulnu uḏimi. ");
INSERT INTO gaw_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","Laa nug da di meḏa, dahil nai ii aoḵu amu nuhig epeḏiak, nug aoḵunu ap̱a ana daaṯe. Nai da nug dooḵunu maṯimi ele amu, nai amu geha nug heṯoḏiakp̱a epeḏiḵu. ");
INSERT INTO gaw_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","Da daḵa dahil dab makp̱a nai ii madiṯem. Iiṯa. Mame, Nug da meiḏe uḏimi, Nug da uḏat meḏom ele amu, Nug da aḏi nai aḵulnu, aḏi madiḵulnu ele meḏom. ");
INSERT INTO gaw_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","Am da dooṯem, Mamenu nai amu bau hanhan dayaknu nai amunu da nai amu madiṯem ele amu Mame Nug amelp̱a aum amuib madiṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","Pasowa meṯid hobulnu deḏ ii neump̱a, Jesus Nug doyom, Nug wan imu uua, Mameg top̱a goḵunu haen aaḵu malom. Nug anam doya, Nug danab ah nuhiḵudnu oo mauhe, Nug genab anam huanak doyom amu ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","Nug nuhiḵud ip̱uniṯak awak danab ele e lanan daanna, Satan nug tatam Judas Iskariot, Simon beḵa, nug Jesus kekeḏ ep̱elagp̱a meḵunu dab mak meṯom amu ");
INSERT INTO gaw_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","Jesus Nug Mameg keeke oh Nug ep̱egp̱a meum doya, Nug Kayak top̱anu uḏiom, Nug eḏua Kayak top̱a goḵunu ele doya, ");
INSERT INTO gaw_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","Nug e uua aha, ulahnu lamen nuhig uḏa maama, beḏu op̱iaknu lamen laa awa, imuagp̱a taḵom. ");
INSERT INTO gaw_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","Nug anam hewowa, le tap̱iḏp̱a qe noum. Qe no, aaḵu Nug dig ma, nuhiḵud ip̱uniṯak awak danab baelag ihaha amu lamen imuagp̱a taḵom ele, amup̱a baelag lep̱u op̱iom. ");
INSERT INTO gaw_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","Am Nug baelag lep̱a ihaha uḵa uḵa, Simon Petrus gumiṯa wa, Petrus nug Jesus oḏ meṯom. “Naḏi, na da bael ihaḵutnute heṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","Anam a amu Jesus amegp̱a aum, “Keeke da heṯem imu na geha imu ii dooṯem amge dimp̱a dooḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","Awa a amu Petrus aum. “Naḏi, na da bael iinab ihamna, gemu buṯi aḏi ele iinab ihamna,” awa aum. A am Jesus Nug aum. “Da na baen ii ihaḵul amu na dahil iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","Anam a amu Simon Petrus aum. “Naḏi, anam dayeb amu na da baelib aib ihame. Na ep̱el, iḵil ele oh ihe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","Petrus anam a amu Jesus Nug amegp̱a aum. “Laa nug le layom ele amu, nug beḏu dubuṯid iiṯa amunu nug baegib iheb, nug beḏu oh op̱ia awak daaḵu. Ag am op̱ia awak daaṯeb amge ag ohnab op̱ia awak iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","Jesus Nug laa Nug kekeḏ ep̱elagp̱a meḵunu amu doyom amunu Nug, “Ag oh op̱ia awak iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","Aria, Jesus ag baelag iha malowa amu nuhig ulah lamen eḏua awa, aḏe no, eḏua dayom. Dayaya Nug ip̱uniṯak awak danab amelagp̱a aum. “Da keeke ahilagp̱a hemi imu ag oolag maidṯete? ");
INSERT INTO gaw_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","Ag dahilnu, ‘Ihinig ip̱uniṯak danab amu ihinig Naḏi ele,’ aon aṯeb. Da genab da anam aaḵu daaṯem amunu ag ena anam aṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","Da am ahilag Naḏi amu ahilag ip̱uniṯak danab ele amu da ag baelag ihaladmi amunu ag ele lailḵad baelḵad ihalaṯeg! ");
INSERT INTO gaw_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","Da kobol imu ag ip̱uanadmi, ag ele kobol da gemu ahilagp̱a hemi amubia heig! ");
INSERT INTO gaw_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","Da genabnab genab ag amelagp̱a aṯem, begbeg danab nug gumak danab nuhig ii eḏidṯe. Am danab nug uḏatp̱a goṯe amu nug danab me goṯe ele amu ii eḏidṯe. ");
INSERT INTO gaw_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","Ag amu doona, ag anam heḵulag amu ag oolag gamag ahaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","Da madiṯem imu amu da ag oh ahilagnu ii aṯem. Da danab dahilad, da tituanadmi ele amu, da ag diilag dooṯem. Amge Kayak nai niiṯe amu genab meu beḵu. Nai amu inam aṯe. ‘Danab nug da ele e laṯep ele amu, nug da tap̱iḏḵunu baeg humaḵu!’ ");
INSERT INTO gaw_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","Da imu ii beump̱a iiḵu ag amelagp̱a aṯem amunu dimp̱a beeb amu ag dooglag, da am Kayak beḵa. ");
INSERT INTO gaw_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","Da genab ag amelagp̱a aṯem. Laa nug uḏat danab, da nug mei goṯe ele amu, nug oo meṯa humidṯe amu nug da aaḵu oo meḏa humiḏṯe. Laa nug da oo meḏa humiḏṯe amu nug laa, da meiḏe uḏimi ele amu, Nug oo meṯa, humidṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","Jesus nai anam maṯiowa, Nug oop̱a ugnab doyom. Oop̱a ug doya amu Nug nai maṯia aum. “Da genabnab genab ag amelagp̱a aṯem. Ag oolagp̱anu laip̱u laa nug da kekeḏ ep̱elagp̱a meiḏḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","Nug anam a amu ip̱uniṯak awak danab ag aḵa aḵa nug neeḵidp̱ig. Nug aunnutai aum amu ag ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","Ip̱uniṯak awak danab laa, Jesus nuhignu o huanak mauhṯom ele, nug Jesus guguiṯaknab dayom. ");
INSERT INTO gaw_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","Dayeye amu Simon Petrus nug ep̱egp̱aib amegp̱a aum. “Na oḏ meṯe, Nug aunnu aṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","Anam a amu ip̱uniṯak awak danab Jesus guguiṯaknab dayom ele amu nug aum. “Naḏi, na aunnu aṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","Nug anam a amu Jesus amegp̱a aum. “Da geha bret tap̱iḏ lewa elep̱a mep̱i nob, taulen medaḵul amu danab nug aaḵuib,” awa aum. Aria Jesus Nug bret lewap̱a ma awa, Simon beḵa Judas Iskariot meṯom. ");
INSERT INTO gaw_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","Judas e amu awe amu Satan nug oop̱a noum. No amu Jesus Nug nuhignu aum. “Keeke na heḵutnu heṯem am paha he!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","Anam aum amge balalp̱a daap̱ig ele, amunu laip̱u laa Jesus Judas amegp̱a aum ele, nai amu diig ii doyom. ");
INSERT INTO gaw_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","Laala ag Judas men doḏo kunup gumṯom amunu, “Jesus Nug pasowa hobulnu keeke awaknutai aṯe,” o iiṯa, “Daḏek danab dilag keeke daden ma maṯaknutai aṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","Aria Judas nug bret maha amu awowa, pahanab dimiṯim uḵom. Dimiṯim amu gatatu ele aaḵu neum. ");
INSERT INTO gaw_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","Judas dimiṯim uḵe amu Jesus Nug aum. “Danab Beḵalag da aaḵu binal oḵai aomi. Dahilp̱a Kayak ele binag oḵai aoṯe. ");
INSERT INTO gaw_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","Kayak Nug dahilp̱a binag oḵai aweb da nuhigp̱a binal aoḵul. Yo, Nug pahanab da binal oḵai meḏaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","O nid naunau dahilad, haen naḵoknab da ag ele daagnig amu dimp̱a ag da maṯiḏḵulag. Da tatam Juda amelagp̱a ami, amu gemu ele ag amelagp̱a iiḵu aṯem. Ag aben da goṯem ele, amup̱a ag gemu goḵulagnu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","Amu gemu da ḏo bau ag madaṯem. Ag lailḵad dilag oolag mauhaḏ! Amu da ahilagnu ool mauhṯe, amubia ag ele ag lailḵad dilag oolag mauhaḏ! ");
INSERT INTO gaw_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","Ag lailḵad dilag oolag mauheb amu danab laa ag miagib dooglag, ag amu ip̱uniṯak awak danab dahilad,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","Jesus anam a amu Simon Petrus oḏ meṯom. “Naḏi, na adep̱a goḵut?” Petrus anam a amu Jesus Nug amegp̱a aum. “Aben da goṯem ele, amup̱a amu gemu na da dim lamiḏna goḵutnu elele iiṯa amge dimp̱a amu na dim lamiḏḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","Anam a amu Petrus nug aum. “Naḏi aṯemun? Da geha imu na dim lamidḵulnu elele iiṯate? Da geha na ehaniṯen, da nahip aben awen mauhḵul amunu amu, da ugnab laa ii dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","A amu Jesus oḏep̱a awa aum. “Na dahil aben aona mauhḵut-te? Da genab na amenp̱a aṯem. Na tuqan imup̱a, na dahilnu, ‘Da Nug ii dooṯem,’ aon, haen ewam batak aḵut. Na haen ewam anam ap̱e, dimp̱a matuk dawai nug gaaḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","“Ag oolag ug aib dayom. Ag Kayaknu oolagp̱a genab doona, ag dahilnu ele oolagp̱a genab doyeg! ");
INSERT INTO gaw_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","Da Mamel laug amu oo kuḏum ele amu da laa ahilagnu bap̱aidḵulnu goṯem. Anam laa ii daalo amu da ag amelagp̱a alom. ");
INSERT INTO gaw_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","Da uḵen, ahilag aben babaiṯoya amu da eḏuen uḏien, omalaṯe goḵul. Aḏinu? Da daaḵulp̱a amu, ag da ele daagnig. ");
INSERT INTO gaw_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","Amu da goḵulnu ib amu ag dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","Anam a amu Tomas oḏ meṯom. “Naḏi, na adep̱a goḵut amu ig ii dooṯem amunu ig aṯem heta, ib na goḵut ele amu doognig?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","A amu Jesus Nug nob ma aum. “Ag laih goḵulagnu henana amu ag ibp̱a goṯeb. Amubia da am hab abp̱a uḵaknu ib. Laa ele amu genab diig am da, bau dayaknu diig amu ele daib. Danab nug Kayak gumiṯa goḵunu amu, daib nug ehanidp̱i goḵunu elele daaṯem. ");
INSERT INTO gaw_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","Ag da dooiḏlob amu ag da Mamel ele doolob amge geha iiḵu amu ag Nug dooṯeb amu ag ele anidṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","Anam a amu Pilipus nug aum. “Naḏi, Na Mama ip̱unigpe, amup̱a ig elele doognig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","Pilipus anam a amu Jesus aum. “Pilipus, haen elabnab da ag ele daamut am na iite dooiḏṯem? Danab nug da aniḏṯe amu nug Mama anidṯe. Am aḏinu na Mama anidḵutnu oḏ meḏaṯem? ");
INSERT INTO gaw_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","Da Mame top̱a daaiyi, Mame Nug dahilp̱a daaṯe. Pilip̱us na amu ootp̱a genab iite dooṯem?” awa aum. Jesus Nug anam maṯiowa, Nug nai tuḏiṯa ag oh amelagp̱a aum. “Nai da ag amelagp̱a madiṯem ele imu, amuam da daḵa, dahil dab makp̱anu iiṯa. Mame Nug dahilp̱a daaṯe amu Nug nuhig maṯiak heṯe. ");
INSERT INTO gaw_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","Da Mama top̱a daaiyi, Mame Nug dahilp̱a daaṯe, nai amu ag oolagp̱a genab doyeg! Iiṯa dayeb amu da keeke danab heḵunu elele iiṯa kuḏum heṯem, ag amu anidna, ag oolagp̱a genab doyeg! ");
INSERT INTO gaw_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","Da genabnab genab ag amelagp̱a aṯem. Laa nug dahilnu oop̱a genab dooṯe ele amu nug uḏat da heṯem imu amu nug ele heḵu. Nug uḏat da heṯem ele amu, uḏat dahil amu eḏiṯak, oḵainab ele heḵu. Aḏinu? Da geha Mame top̱a goḵul. ");
INSERT INTO gaw_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","Amu Mama Nug binag oḵai dahilp̱a aoḵunu amu ag keeke laanu da onilp̱a ap̱eg amu da heḵul. ");
INSERT INTO gaw_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","Keeke oh ag da onilp̱a da oḏ meḏap̱eg amu da heḵul. ");
INSERT INTO gaw_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","Am ag dahilnu oolag mauhṯe dayeb amu dahil ḏo ena tutuḵu dim lamidḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","Amu da Mamel oḏ medap̱i, Nug ehaniṯak laa madaḵu. Nug ag ele hanhan daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","Nug am Kayak Ouḏi, Nug nai genab Kayaknu ag ipuanadṯe. Wan imup̱an danab, ag oolagp̱a genab ii dooṯeb ele amu, ag aoglagnu amu elele iiṯa. Aḏinu? Ag Nug ii anidṯeb am ag ele ii dooṯeb. Amge ag da ele geha iiḵu daaṯeb, ag am Nug dooṯeb, Nug ag ele daaṯeb, dimp̱a Nug ag oolagp̱a ele daaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","Da ag nid laa, nug anig mameg ele mauhpiḏ, nuḵanab daaṯe, amubia ii uuadpa. Iiṯa, da gumaṯe uḏiḵul. ");
INSERT INTO gaw_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","Nakok laa ele wan imup̱an danab, ag oolagp̱a genab ii dooṯeb ele amu, ag da ii aniḏmana amge ag dahilad daaṯeb amu ag am da aniḏḵulag. Da haen amup̱a bau daaḵul amunu ag ele bau daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","Haen amup̱a amu, da Mame top̱a daaṯem, ag am dahilp̱a daaṯeb, da ahilagp̱a ele daaṯem amu ag dooglag. ");
INSERT INTO gaw_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","Am aun laa nug dahil ḏo awa, tutuḵu dab medaṯa dim lamidṯe ele amu, nug aaḵuib am dahilnu oo mauhṯe. Am aun nug dahilnu oo mauhṯe amu Mame Nug ele nuhignu oo mauhḵu. Da ele nuhignu ool mauhebeb, da dahil kobol miag atiak nug ip̱unidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","Jesus anam awa a amu Judas laa, Judas Iskariot iiṯa, nug aum. “Aḏinu igib nahip kobol ip̱unigḵut amge iiṯa aḏi dilagp̱a amuam iiṯa?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","Judas laa amu nug anam a amu Jesus Nug aum. “Danab laa nug dahilnu oo mauheb amu nug dahil nai ele dim lamidḵu. Aria danab amunu amu da Mamel Nug nuhignu oo mauhḵu. Amu da Nug ele, i nuhigp̱a nepuḏ, ig oh laip̱u, danab ewam lag laip̱up̱a daaṯeb, amubia haen oh daagnig. ");
INSERT INTO gaw_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","Laa nug dahilnu oo ii mauhṯe ele amu nug nai dahil ele dim ii lamidṯe. Am ag dooṯeb, nai amuam dahil iiṯa. Nai amuam Mame, Nug da meiḏe uḏimi ele amu, nuhig nai. ");
INSERT INTO gaw_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","Keeke imu oh amu da ag ii uuadmi, da ag ele daatta, haen imup̱a iiḵu madiṯem. ");
INSERT INTO gaw_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","Amge ahilag ehaniṯak, Kayak Ouḏi, da Mamel Nug da onilp̱a meeb uḏiḵu amu, Nug uḏia, keeke oh ip̱uanaṯa, da ag amelagp̱a aḏi ami amu Nug heeb, ag daulagp̱a doḵu. ");
INSERT INTO gaw_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","Da maḏoḏ awe ii gopa. Iiṯa! Da dahil maḏoḏ ag madaṯem. Wan imup̱a maḏoḏ amubia ii madaṯem amunu ag oolag ug aib qeum. Ag aib baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","‘Da ag uuaṯe uḵoya, eḏuen ag gumaṯe uḏiḵul,’ ai doop̱ig. Ag genab dahilnu oolag mauhlolob, ag da Mame top̱a goḵulnu amu ag amunu oolag gamag ahalo. Aḏinu? Mame Nug am Naḏi, Nug da eḏilak. ");
INSERT INTO gaw_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","Keeke imu neeb, ag oolagp̱a genab dooglagnu amu da keeke imu ii neump̱a iiḵu da ag amelagp̱a ami. ");
INSERT INTO gaw_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","Wan imup̱an oḵai nug amu nug uḏat nuhig heḵunu haen miag beum daaṯe amunu da ag ele nai kuḏum baula ii maṯimta. Nug dahilp̱a keeke laa heḵunu g̱agaṯag iiṯa ");
INSERT INTO gaw_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","amge danab ah oh ag da Mamenu ool mauhṯe anidḵulagnu, ag da Mame Nug aḏi heḵulnu amelp̱a maṯiom amuib heṯem ele dooglagnu amu da iiḵu heṯem. Ahap̱eg ig gotu. ");
INSERT INTO gaw_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","Da am muḏi laa onig grep amu nug ebeḵud diig. Da anam daaiyi amu da Mamel Nug am gumak danab. ");
INSERT INTO gaw_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","Mame Nug dahilp̱a ep̱eg oh meu ii niiṯeb ele amu oḵulaṯa geḏadṯe. Ep̱eg laa meu niiṯeb ele amu ag meu huana oḵulagnu amu Nug bap̱aladṯe. ");
INSERT INTO gaw_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","Da nai ag maṯami amu he, ag ena bep̱ig daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","Ag dahilp̱a daap̱eg, da ahilagp̱a daaḵul. Muḏi grep ep̱eg nug nuḵa awaiṯak dayaya meu niiḵunu elele iiṯa, nug muḏi grep tuḏiṯak dayaya meu niiḵunu elele amubia ag da ele ii daagnig amu ag ele meu ena ii omana. ");
INSERT INTO gaw_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","Da amu muḏi grep, ag amu muḏi grep ebeḵud. Laa nug dahilp̱a daaṯe, da nuhigp̱a daaṯem amunu nug meu kuḏumnab oṯe. Ag da uuiḏna amu ag keeke laa heḵulagnu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","Laa nug dahilp̱a ii daaṯe ele, nug muḏi grep ebeḵud danab ag oḵulna aḵaeg uḵe bunaḏṯeb amubia daaṯe. Danab ag muḏi grep ebeḵud amu ag qag maadna aḵaeg, ab aḏu naḏip̱a teeg eoṯe. ");
INSERT INTO gaw_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","Ag dahilp̱a daap̱eg amu dahil nai ahilagp̱a dayeb, ag oolag daaṯe amu ag amunu da oḏ meḏanna, ag aoglag. ");
INSERT INTO gaw_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","Ag meulḵad huanak oḵulag amup̱a da Mamel Nug onig oḵai aoḵu. Amup̱a ag dahil ip̱uniṯak awak danab genab ele daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","Mame Nug dahilnu oo mauhṯe amubia da ahilagnu ool mauhṯe. Ag dahil oo mauhak amu oop̱a ag hanhan dayeg! ");
INSERT INTO gaw_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","Da Mamenu ḏo tutuḵu dim lamiṯeṯe, nuhig oo mauhak oop̱a daaṯem amubia ag dahil ḏo tutuḵu dim lamidḵulag amu ag haen oh dahil oo mauhak oop̱a daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","Da oo gamag ahak dahil ahilagp̱a daaḵunu nai imu maṯimi. Amup̱a oo gamag ahak ag oolagp̱a am baknab daaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","Dahil ḏo amu inam. Da ahilagnu ool mauhṯe, amubia ag ele lailḵad dilagnu oolag mauhaḏ! ");
INSERT INTO gaw_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","Laa nug laiḵud dilag dab ma, nuhig bau dayak paḏaṯe amu oo mauhak kobol amuam oo mauhak kobol laa oh eḏidṯe. ");
INSERT INTO gaw_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","Amu ag da ḏo maṯami, ag amubia heḵulag amu ag dahil kadoi daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","Begbeg danab nug danab oḵai nuhig aḏi heṯe amu nug ii dooṯe, nug, ‘Na gona uḏat amu he,’ aṯe amuib aaḵu nug heṯe amunu da baula ahilagnu begbeg ii aṯem. Iiṯa. Da ahilagnu kadoi aṯem. Aḏinu? Da Mamel keeke oh amelp̱a a doomi amu ohnab maṯiyi ag doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","Ag da ii tituaniḏp̱ig. Iiṯa! Ag da onilp̱a aḏi keekenu Mame amegp̱a unuqidp̱eg amu Nug ag madaḵunu, da ag dahilad daaglagnu tutuanaṯen, ag gona oina, meulag oḵulagnu amu meu amu hanhan daaḵunu maadmi. ");
INSERT INTO gaw_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","Da ḏo iiḵu ag madaṯem, ag lailḵad dilagnu oolag mauhaḏ! ");
INSERT INTO gaw_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","Danab ah ag oolagp̱a ahilagnu nau, ninig ele doop̱eg amu ag doyeg, danab ah amu ag tatam dahilnu anam doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","Ag wan imup̱anu danab ele laip̱u daalob, wan imup̱anu danab ag ahilagnu ag lailḵad bia doolob amge ag wan imup̱anu danab ele laip̱u iiṯa. Da ag danab amu oolagp̱anu tituanaṯen, wan imup̱anu kobol imu uuglagnu ag maadmi amunu diig amup̱a ag ahilagnu kekeḏ daaṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","Nai da ag amelagp̱a ami ele amu daulagp̱a doaḏ! Nai amuam inam. ‘Begbeg danab nug gumak danab ii eḏidṯe.’ Amu aun aḏi laa ag da lamiḏna geḏilp̱ig amu ag ag ele lamadna geḏadḵulag. Aun laa ag dahil nai dim lamidp̱ig ele amu ag am ahilag nai ele dim lamidḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","Amge laa ag Mame, Nug da meiḏe uḏimi amu, ag Nug ii dooṯeb amunu ag, ag da onilp̱a oiṯeb doona, ag ahilagp̱a eheḏ heḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","Da uḏien, danab amu ag amelagp̱a nai laa ii maṯilom amu ag hip̱uninnu ab iiṯa daalob amge gemu ag hip̱uninnu ab iiṯa daaglagnu ib laa iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","Am laa nug da guhuḏilte amu nug da Mamel ele guhuḏidṯe. ");
INSERT INTO gaw_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","Da keeke danab heḵunu elele iiṯa, danab laa ii heum ele amu, ahilagp̱a ii helom amu ag hip̱uninnu ab iiṯa daalob amge ag anidna, hamu bia doona, da amu da Mamel ele ag oolagp̱a ihinihnu nau, ninig ele doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","Am ahilag ḏop̱a yak niiṯe amu elele meṯom. Nai amu inam. ‘Ag oolagp̱a, dahilnu diig iiṯap̱a nau, ninig ele doop̱ig.’ ");
INSERT INTO gaw_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","Kayak Ouḏi, Nug onig laa Ehaniṯak, Nug amu keeke ohnu genab diig, Kayak top̱a daaṯe amu da Nug geha mep̱i, ag ehanadḵunu ahilagp̱a uḏiḵu. Nug amu Mame nuhigp̱a dayaya uḏiḵu. Geha Nug uḏia, nai dahilnu ag amelagp̱a maṯieb dooglag. ");
INSERT INTO gaw_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","Amu ag ele dahil nai maṯinna oiyeg! Aḏinu? Ag dig makp̱anu da ele daaut uḏie, gemu ele daaṯem. ");
INSERT INTO gaw_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","Ag ahilag oop̱a genab doyak ii paḏamnanu da nai imu oh amelagp̱a ami. ");
INSERT INTO gaw_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","Danab ag Juda dilag nai doyak lag oop̱anu lamadḵulag. Dimp̱a haen beeb, ag ag aqap̱eg mauhp̱ep̱eg, ‘Ig Kayaknu uḏat ena heṯem,’ aon aḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","Danab amu ag da Mama ele ii dooitp̱ig amunu ag anam heḵulag. ");
INSERT INTO gaw_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","Da nai imu maṯiminu diig am haen amu beebeb, da dab mak awaknu nai imu maṯami amu ag dab meḵulag. Dig makp̱a da ag ele daamut amunu da nai imu ag amelagp̱a ii ami, gemuib madiṯem. ");
INSERT INTO gaw_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","Gemu amu da laa, Nug meiḏe uḏimi ele amu, Nug gumiṯe goṯem. Amu ag oolagp̱a laip̱u laa nug da oḏ meḏa, ‘Na adep̱a goṯem,’ laa ii aṯe. ");
INSERT INTO gaw_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","Da nai maṯimi, diig amunu ag oolagp̱a oo doyak oḵainab aoṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","Da genab ag amelagp̱a aṯem. Da hab abp̱a goḵul am ena. Da ii gop̱i am ena iiṯa. Aḏinu? Da ii gop̱i amu Kayak Ouḏi, ahilag ehaniṯak, Nug ii nema amge da tein dayeye, da hep̱i, Nug ag gumaṯa neḵu. ");
INSERT INTO gaw_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","Nug uḏia, wan imup̱an danab hip̱uninnu, kobol enanu amu epeḏiaknu ele ag ip̱uanadḵu. ");
INSERT INTO gaw_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","Nug danab ag hip̱uninnu ip̱uanaṯeb, ag hip̱unin diignab, am danab ag dahilnu oolagp̱a genab ii dooṯeb amu, dooglag. ");
INSERT INTO gaw_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","Nug kobol enanu ip̱uanaṯeb, ag da Mame top̱a goṯem amunu ag kobol ena heḵulagnu elele daaglag, ag amu dooglag. ");
INSERT INTO gaw_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","Nug epeḏiaknu ele ip̱uanaṯeb, ag wan imup̱an oḵai, Satan, nug aaḵu epeḏiak awa malom amunu ag heṯoḏiakp̱a ii daaglagnu ib aaḵu babaiṯak daaṯe amu ele dooglag. ");
INSERT INTO gaw_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","Da nai kuḏum ag amelagp̱a madiḵulnu heṯem amge geha imu ag aoglagnu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","Amge Kayak Ouḏi, genabnu diig, Nug na, keeke oh genabnuib amu ip̱uanadḵu, Nug nuḵa nuhig dab makp̱a ii maṯima. Iiṯa. Nug aḏi doyom aaḵuib madiḵu. Aḏi aḏi dimp̱a beḵu amu ele ip̱uanadḵu. ");
INSERT INTO gaw_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","Nug amu nai genab dahil awa, ag madaḵu amunu amup̱a Nug da binal oḵai meḏaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","Mamenu keeke oh amu dahil amunu da ami. ‘Kayak Ouḏi Nug keeke dahil amu awa, ag ip̱uanadḵu.’ ");
INSERT INTO gaw_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","Nakok laa ele ag da ii aniḏmana. Nakok laa ele dimp̱a amu ag da baula aniḏḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","Jesus anam a amu ip̱uniṯak awak danab nuhiḵud laala ag aḵa aḵa nug oḏ meṯan ap̱ig. “Nai nuhig imu am diig aṯemu? ‘Nakok laa ele ag da ii anidmana amu naḵok laa ele dimp̱a amu ag da eḏun aniḏḵulag.’ Nug inam ele aum, ‘Da Mama top̱a goḵul.’ ");
INSERT INTO gaw_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","‘Nakok laa ele,’ nai amuam diig aṯemu? Nug aḏitainu nai amu aum amu ig diig ii dooṯem,” aon ap̱ig. Ag anam anana, aḵa aḵa nug oḏ meṯaegeg, ");
INSERT INTO gaw_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","amu Jesus Nug doyom, ag Nug ele oḏ meṯaglagnu hep̱ig amunu Nug ag amelagp̱a aum. “Da nai ami amunute ag aḵa aḵa nug oḏ medṯeb? Da inam ami. ‘Nakok laa ele ag da ii aniḏmana amu nakok laa ele dimp̱a amu ag da eḏun aniḏḵulag!’ awe ami. ");
INSERT INTO gaw_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","Da ag amelagp̱a genabnab genab aṯem. Wanp̱an danab ah ag am oolag gamag ahaḵu amge geha ag dahilad daaṯeb amu, ag naḏi gaaglag, ag oo doyak ele gaaglag. Ag geha oolag ug ele daaglag amge ahilag oo ug dayak am eḏueb, ag oo gamag ahak dooglag. ");
INSERT INTO gaw_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","Ah nug nid menuḵunu haen male doya amu nug oo ug daaṯe amge nug nid menuowa amu nug baula ug ii dooṯe. Aḏinu? Nug nid menue doum amunu nug oo gamag ahaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","Anamnab aaḵu. Gemu amu ag oolag ug ele daaṯeb amge da geha ag eḏue anadḵul. Ag geha haen amup̱a oo gamag ahak oḵai dooglag. Laa amu nug ahilag oo gamag ahak amu qeeb neḵunu amu elele iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","Jesus Nug anam anana, Nug nai tuḏiṯa aum. “Geha deḏ amup̱a ag keeke laanu da iinab oḏ meḏamna. Da genabnab genab ag amelagp̱a aṯem, Mame Nug ag keekenu oolag heeb, da onilp̱a Nug oḏ medap̱eg amu Nug ag madaḵu. ");
INSERT INTO gaw_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","Uḏie uḏie, gemu batak ag keeke laanu da onilp̱a Nug oḏ ii medap̱ig. Ag oolag gamag aheb, oolag meḵunu amu ag oḏ mena amu geha aoglag. ");
INSERT INTO gaw_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","Da keeke danab ag dooṯeb ii dooṯeb ele ou aqate, ip̱uanaṯeṯe, keeke imu ohnu ag amelagp̱a maṯimi amge geha haen amu uḏieb, da baula ag amelagp̱a anam bia ii madipa. Iiṯa! Da nai miag matule, Mamenu madiḵul. ");
INSERT INTO gaw_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","Haen amu uḏieb, ag geha Nug da onilp̱a oḏ meṯaglagnu amu da ag oulag dayeye, Nug unuqidḵulnu ii aṯem. ");
INSERT INTO gaw_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","Iiṯa! Mame Nug nuḵa ahilagnu oo mauhṯe. Aḏinu? Ag dahilnu oolag mauhṯe amu ag ele da am Kayak top̱anu uḏimi oolagp̱a genab dooṯeb amunu Nug ahilagnu oo mauhṯe. ");
INSERT INTO gaw_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","Genab, da Mama top̱anu uḏie, wanp̱a nemi daaṯem. Gemu am da wan imup̱an ahe, eḏue Mama top̱a goḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","Nug anam a amu nuhiḵud ip̱uniṯak awak danab ag Nug amegp̱a ap̱ig. “Gemu na nai miagib matulna madiṯem, na keeke danab ag dooṯeb ii dooṯeb ele ou aqatna, ip̱uniṯak nai ii aṯem. ");
INSERT INTO gaw_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","Gemu amu ig dooṯem, na amu keeke oh dooṯem amunu danab laa nug tatam na oḏ meṯeb, na dimp̱a nug nob medaḵutnu iiṯa. Iiṯa. Na oḏ mak amu matu doon malame. Amup̱a na Mame top̱anu uḏime amu ig oonigp̱a genab dooṯem,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","Anam aeg amu Jesus amelagp̱a aum, “Gemu iiḵute ag oolagp̱a genab doop̱ig? ");
INSERT INTO gaw_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","Anṯeg! Haen aaḵu uḏiṯe, aaḵu miag doum, geha ag lamadp̱eg, da uuiḏna, matatun, ap̱alagp̱a uḵadḵulag. Amge da daḵa ii daapa. Iiṯa. Da Mamel Nug da ele daagnih. ");
INSERT INTO gaw_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","Da nai imu ag maḏoḏ aon daaglagnu amelagp̱a ami. Wan imup̱a amu ag ug anidḵulag amge ag ug aib aqom! Aḏinu? Da wanp̱anu ug oh eḏidmi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","Jesus nai maṯiowa, Nug ameg huma, hab aṯan neeḵa dayaya, unuqiṯa aum. “O Mame, haen aaḵu uḏiom. Da am na beḵat. Da na binan humaḵulnu amu na da binal oḵai hume! ");
INSERT INTO gaw_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","Na da danab ah meḏame ele amu, da ag bau hanhan dayak madaḵulnu, na da danab ah oh dilag iḵilag daaḵulnu g̱agaṯag meḏame amubia na da binal meḏaḵut. ");
INSERT INTO gaw_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","Bau hanhan dayak amuam inam. Danab ag na da ele dooitḵulag. Na amu na naḵa am Kayak genab. Da amu da am na beḵat, na da meiḏe uḏimi. ");
INSERT INTO gaw_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","Uḏat na da meḏame amu da hein malami, amup̱a da wan imup̱a na binan oḵai humami. ");
INSERT INTO gaw_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","O Mame, anuḵa wan ii dayeye, da na ele daaḏḏa, da binal oḵai ele daaiyi uḏiom amu gemu na binal amuib eḏun meḏe! ");
INSERT INTO gaw_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","Ao Mame, da wan imup̱an danab na meḏame amu da ag amelagp̱a na diitnu mehuqi doop̱ig. Ag am nahipad, na da meḏame amu, ag nahip nai dim lamidṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","Ag aaḵu dooṯeb, keeke oh na da meḏame amu nahip̱anu uḏiom. ");
INSERT INTO gaw_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","Nai oh na da meḏame ele amu da ag maṯai aop̱ig. Da nahipp̱anu uḏimi amu ag genab doop̱ig, na da meiḏe uḏimi, ag amu ele oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","Amu da ahilagnu unuqidṯem. Da haen imup̱a wan imup̱an danab, ag oolagp̱a genab ii dooṯeb ele amu, da amu dilagnu ii unuqidṯem. Iiṯa. Da danab na meḏame, amu dilagnu unuqidṯem. Aḏinu? Amu oh am nahipad. ");
INSERT INTO gaw_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","Dahilad imu oh am nahipad. Nahipad oh am dahilad ele. Ag da binal meṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","Gemu da wanp̱a baula ii daapa. Da na gumiṯe goṯem amge dahilad imu ag wan imup̱an danab, ag oolagp̱a genab ii dooṯeb ele amu, ag oolagp̱a daaṯeb. O Mame op̱ia awak, na oninp̱a danab ah da meḏame imu dab madap̱e, da na ele laip̱u daaṯeb amubia ag oolag laip̱u ele dayeg! ");
INSERT INTO gaw_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","Haen da ag ele daamut amu da dab maṯaiyi, ag da onil, na meḏame ele, amup̱a daap̱ig. Laip̱u laa ii padal meum. Laip̱u aaḵuib am nug nuḵa nuhig dab mak dim lamiṯom ele amu, nug aaḵuib padal meum. Amup̱a nai yak nahip genab meu oum. ");
INSERT INTO gaw_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","Da gemu na gumiṯe goḵulnu doyena amu dahilad danab ag oo gamag ahak dahil oh aoglagnu amu da amunu nai imu madiṯem. ");
INSERT INTO gaw_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","Nai nahip amu da ag maṯai, iiṯa aḏi ag dahilad imu dilagnu ag oolagp̱a nau, ninig ele dooṯeb. Aḏinu? Da wan imup̱anu iiṯa amubia ag ele wan imup̱anu iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","Da na ag wan imup̱anu diiadḵutnu oḏ ii medaṯem. Iiṯa. Na hep̱e, Satan nug ag diiadḵunu elele iiṯa daaḵu amunu na oḏ medaṯem. ");
INSERT INTO gaw_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","Ag wan imup̱anu danab iiṯa, da ele wan imup̱anu iiṯa amubia. ");
INSERT INTO gaw_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","Amunu nai nahip am genab amunu amup̱a na hep̱e, ag na noomp̱a elelenab op̱ia awak dayeg! ");
INSERT INTO gaw_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","Na wan imup̱a meiḏe uḏie, danab ah oolagp̱a daami, amubia da ag maadp̱i, ag ele danab ah oolagp̱a daaglag. ");
INSERT INTO gaw_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","Da dahilad imu ag da aniḏna, nahip nai peheṯak dim lamidna, op̱ia awak daaglagnu amu da na oḏen tutuḵunab dim lamidṯem. ");
INSERT INTO gaw_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","Da dahilad ip̱uniṯak awak danab imu ahilagnu aaḵuib ii unuqidṯem. Iiṯa. Imu ag dahilnu madip̱eg, danab laala ele ag dahilnu oolagp̱a genab dooglag, da ahilagnu ele iiḵu unuqidṯem. ");
INSERT INTO gaw_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","O Mame, Na dahilp̱a daaṯem, da nahipp̱a daaṯem, amubia amu ag i ele laip̱u daagnignu unuqidṯem. Danab laala amu ag nid dahilad ag oolag laip̱u daaṯeb anidna amu ag oolagp̱a, na he da uḏimi, genab dooglagnu amu da ag oh oolag laip̱u daaglagnu unuqidṯem. ");
INSERT INTO gaw_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","Na da ele i laip̱u daaṯep, amubia dahilad imu ag laip̱u daaglagnu amu na da binal meḏame ele amu da ag maṯami. ");
INSERT INTO gaw_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","Dahilad amu ag oolag laip̱unab dayebeb, iiṯa aḏi ag na da meiḏe uḏimi, na dahilnu oot huana mauhom amubia na dahilad, ahilagnu ele oot huanak mauhṯe dooglagnu amu da ahilagp̱a daap̱i, na dahilp̱a daaḵut. ");
INSERT INTO gaw_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","Mame, danab ah na da meḏame amu haen da binal ele daaḵul amu ag da ele aben amup̱a daagnignu ool daaṯe. Ag da binal anuḵa wan ii dayomp̱a na dahilnu oot mauhe, na da meḏame amu ag anidḵulagnu ool daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","O Mame tutuḵunab, iiṯa aḏi amu ag na ii dooidṯeb amge da am na dooidṯem amu dahilad imu ag na da meiḏe uḏimi amu dooṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","Da na dit ahilagp̱a miag atimi. Amu na dahilnu oot mauhṯe, oo mauhak amu ag oolagp̱a daaḵunu, da ele ag oolagp̱a daaḵulnu amu, da baula na dit ip̱uanadḵul,” awa unuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","Jesus anam unuqiṯa male, nuhiḵud ip̱uniṯak awak danab ele ag ahan gona, le Kidron mataḏna, olip dad laa ap̱a dayom amu ag dad amu oop̱a nop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","Judas, nug Jesus kekeḏ ep̱elagp̱a meum ele amu, nug ele dad amu doyom. Aḏinu? Haen kuḏum Jesus Nug ip̱uniṯak awak danab ele ag dad amup̱a qag medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","Amunu Judas nug Rom dilag ban danab amu mana meṯak danab oḵai amu ḏo gumak danab-Parasia, ahilag daup laala ele diie, aben amup̱a uḏip̱ig. Ag amahlak, hul amu bannu keeke ele aon gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","Jesus Nug keeke oh nuhigp̱a heḵulag amu oh doya malom amunu ag uḏieg, Nug guguaṯa wana aum. “Ag aun madiṯeb?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","Anam a amu Nug oḏep̱a aon ap̱ig. “Jesus Nasaret ted,” aon ap̱ig. Aeg am Jesus ag amelagp̱a aum. “Da iiḵu,” awa aum. Judas, nug Jesus kekeḏ ep̱elagp̱a meum ele amu Nug ele oh hip̱aidna daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","Hip̱aidna daaegeg, Jesus amelagp̱a, “Da iiḵu,” awa a, ag oṯaina, bitumtum gona, wanp̱a nena qep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","Ag nena qeeg amu Jesus Nug baula oḏ maṯom. “Ag aun madiṯeb?” awa aum. Anam a amu ag ap̱ig, “Jesus Nasaret ted,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","Anam aeg am Jesus aum. “Da am danab amu iiḵuib, da matu amelagp̱a ami. Ag da maṯiḏna dop̱ig dayeb amu ag danab imu uuadp̱eg uḵeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","Nug nai amu aum amu Nug anuḵa nai laa aum, nai amu meu oum. Nai Nug anuḵa aum am inam. “Na da meḏame amu laip̱u laa padal ii meum.” ");
INSERT INTO gaw_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","Aria Simon Petrus nug qep elab ele amunu nug eeḏa awa, mana meṯak danab dilag iḵi, nuhig begbeg laa daug naḏiap amu hoiyom. Nid amu onig Malkus. ");
INSERT INTO gaw_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","Anam he amu Jesus Petrus amegp̱a aum. “Na nahip qep elab eḏun abenp̱a me! Aṯemu? Le mua hai goḵoḏp̱a daaṯe, Mame meḏom ele amu, da iite lapa?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","Nug anam a amu ban danab amu ban danab iḵilag amu Juda iḵilag, ahilag daup ele ag Jesus aḏana, muḏip̱a hip̱alp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","Hip̱alona, ag aon, tatam Kaiapas tanab Anas top̱a gop̱ig. Kaiapas nug maḏ amup̱a mana meṯak danab dilag iḵi dayom. ");
INSERT INTO gaw_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","Kaiapas amu nugib tatam Juda amelagp̱a inam aum. “Danab laip̱u laa geha danab ah abenalag awa mauhḵu amu ena,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","Am Simon Petrus nug ip̱uniṯak awak danab laa ele, a Jesus dim lamidpiḏ. Mana meṯak danab dilag iḵi nug ip̱uniṯak awak danab laa amu doyom amunu nug mana meṯak danab amu laug aḏ oop̱a noum ");
INSERT INTO gaw_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","amge Petrus nug aḏ dimiṯim, od oḏep̱a dayom. Anam dayeye amu ip̱uniṯak awak danab laa, mana meṯak danab dilag iḵi nug doyom ele amu, nug wana, nid ahin od gumom ele amu amegp̱a anana, Petrus omala oop̱a noum. ");
INSERT INTO gaw_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","Ip̱uniṯak awak danab, mana meṯak danab dilag iḵi nug doyom ele amu, nug anam he, nid ahin od gumom ele amu Petrus amegp̱a aum. “Na ele danab imunu ip̱uniṯak awak danab laatai?” awa aum. Nid ahin nug anam a amu Petrus aum, “Da iiṯa!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","Haen amuam oug haen amunu begbeg danab amu daup ele ag oug doona, ag ab laa ilan uḏignana daaegeg, Petrus nug ele ulah qeum amunu nug ele gaḵaḏak aoḵunu ab ilap̱ig amu uḏiḵa dayom. ");
INSERT INTO gaw_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","Anam dayeye amu mana meṯak danab dilag iḵi nug Jesus ip̱uniṯak awak danab nuhiḵudnu amu danab ah amelagp̱a nai mehuqom amunu ele oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","Oḏ meṯe amu Jesus Nug oḏep̱a awa inam aum. “Da am danab ah amelagp̱a aben miag atiakp̱a nai maṯimi. Da nai doyak lag kuḏump̱a am meṯid lag oop̱a ele ip̱uniṯak maadṯami. Da loḵumakp̱a laa ii mehuqṯami. ");
INSERT INTO gaw_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","Amunu aḏinu na da oḏ meḏaṯem? Na danab ag nai dahil doop̱ig ele amu ag oḏ maṯe! Ag am dahil nai doop̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","Anam a amu daup laa hibaiṯa dayom ele amu, ep̱eg oohap ta, hip̱eg mataḏaḏa aum. “Na mana meṯak danab dilag iḵi nai amup̱ate nob medaṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","Anam a amu Jesus amegp̱a aum. “Da nai nau ami dayeb amu na tutuḵu da amelp̱a ap̱e doyei! O iiṯa da nai tutuḵu ami dayeb amu aḏinu na da oiḏme?” ");
INSERT INTO gaw_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","Jesus anam a amu Anas nug Jesus, ep̱eg muḏip̱a qaḵak ele, Kaiapas, nug am mana meṯak danab dilag iḵi, nug top̱a me uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","Simon Petrus nug ab uḏiḵa dayeye, ag nug oḏ medap̱ig. “Na ele nuhig ip̱uniṯak awak danab laatai?” aon ap̱ig. Anam aeg amu nug aum. “Da iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","Mana meṯak danab dilag iḵinu begbeg laa, nug am begbeg danab Petrus daug hoiyom ele, amunu tiig laip̱u amu, nug aum. “Genabnab na ele daṯa ap̱a dayeye, da anidmi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","Anam a amu Petrus eḏua amegp̱a, “Iiṯa,” awa aum. Nug anam a amu matuk paha gayom. ");
INSERT INTO gaw_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","Matuk gaye amu buṯuanab Jesus Kaiapas top̱anu aona, gabman oḵai top gop̱ig. Ag aon gop̱ig amge ag aḵa ag gabman oḵai laug oop̱a ii nop̱ig. Ag oolagp̱a, “Gabman oḵai imu nug Juda iiṯa, ihinig ḏop̱a ig nug lag oop̱a gota, ig oonigp̱a hip̱unin ele daagnig amu ig hip̱unin ele daatta amu ig Pasowa meṯid hobul ii lamata amunu ig lag oop̱a ii gomata,” anana, lag oop̱a ii gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","Anam amunu ag dimiṯim daaegeg, Pilatus nug dimiṯim ag gumaṯa doa, amelagp̱a aum. “Danab imunu nai aṯemu?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","A amu ag nug oḏep̱a aon ap̱ig. “Nug hip̱unin iiṯa dayeb amu ig omalta, nahipp̱a ii uḏilom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","Aeg amu Pilatus nug ag amelagp̱a aum. “Ag aḵa Nug aon gona, ahilag ḏop̱a nuhig nai epeḏieg!” awa aum. Anam a amu Juda ag ap̱ig. “Rom ag ig danab laa qep̱ut mauhḵunu aib ap̱ig amunu ig danab laa qep̱ut mauhḵunu ii dooṯem. Diig amunu amu ig na Rom dilag kobolp̱a danab imu ad emaitakp̱a aihḵutnu oonig daaṯe.” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","Ag nai amu ap̱ig amu Jesus Nug kobol aḏip̱a mauhḵunu aum ele, nuhig nai amu meu oum. ");
INSERT INTO gaw_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","Anam aeg am Pilatus nug eḏua laugp̱a noa, Jesus onigp̱a e do, amegp̱a aum. “Na Juda dilag Kingte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","Pilatus anam a amu Jesus amegp̱a aum. “Na naḵa nai amu aṯemte oo iiṯa laa ag na amenp̱a ap̱igte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","Anam a amu Pilatus nug aum. “Da am Juda tedte? Nahipad danab ah amu mana meṯak danab oḵai ele ag na omaidna uḏin, da ep̱elp̱a meidp̱ig. Na aḏi heme?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","Pilatus anam a amu Jesus aum. “Dahil ḏo maḏoḏ am wan imup̱an iiṯa. Dahil ḏo maḏoḏ wan imup̱anulob amu dahilad danab ag wagai mep̱eg, Juda oḵai ag da ii aḏailob. Amge dahil ḏo maḏoḏ amu ip̱anu iiṯa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","Jesus anam a amu Pilatus amegp̱a aum. “Na anam aṯem amunu na kingte?” awa aum. A amu Jesus Nug aum. “Na dahilnu, ‘Na am king daaṯem,’ maṯina aṯem. Da nai genab mehuqeqe oiḵulnu wanp̱a nei, da anil menuiḏom. Laa oh ag nai genab dim lamidṯeb amu ag dahil nai dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","Nug anam a amu Pilatus amegp̱a aum. “Nai genab amu aḏi?” awa aum. Nug anam anana amu aha, dimiṯim Juda gumaṯa uḵa aum. “Da nuhigp̱a eheḏ laa ii anidmi. ");
INSERT INTO gaw_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","Am ag ahilag kobol laa ele daaṯe amu kobol amup̱a, da Pasowanu meṯid hobul haenp̱a danab laip̱u laa uhuqe madaṯem amunu ag aḏi aṯeb? Da Juda dilag King amute uhuqe madaḵul?” ");
INSERT INTO gaw_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","Nug anam aum amge ag qalan ap̱ig. “Nug iiṯa! Barabas uhuqna meḵe!” aon ap̱ig. Barabas nug am danab aqaqa, danab dilag keeke mauhnoak aoṯom. ");
INSERT INTO gaw_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","Anam aeg amu Pilatus nug a, nuhig daup danab ag Jesus wipp̱a eheḏ mataḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","Mataḏna amu daup ag King igip̱anu bala bia muḏi qaun aeg elep̱a hewona, Jesus igip̱a aḏaeg no, king dilag lamen ele aḏuiṯeg noum. ");
INSERT INTO gaw_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","Ag anam hena, Jesus gumidna uḏin ap̱ig. “Na am Juda dilag king! Na binan ele,” aon ap̱ig. Ag anam anana, ag ep̱elag oohap tena, hip̱eg mataḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","Ag anam heegeg amu Pilatus eḏua dimiṯim doa, amelagp̱a aum. “Anṯeg, da nug beḏup̱a eheḏ hak laa ii anidmi amunu ag amu dooglagnu omalp̱i, dimiṯim doḵunu heṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","Anam a, Jesus muḏi qaun ele igip̱a meeg dayeye, King dilag lamen enanag amu ele beḏup̱a dayeye, Nug dimiṯim doum. Do amu Pilatus nug aum. “Ag danab imu anṯeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","Anam a amu mana meṯak danab oḵai, ahilḵad daup ele ag Jesus anidna, huanak ena ap̱ig. “Ad emaitakp̱a atule! Ad emaitakp̱a atule!” aon ap̱ig. Anam aeg amu Pilatus nug aum, “Ag aḵa aon, ad emaitakp̱a atuleg, da am nuhigp̱a eheḏ laa ii anidmi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","Pilatus anam a amu ag ap̱ig. “Ig ḏo ele amu ihinig ḏop̱a amu Nug mauhḵunu daaṯe. Aḏinu? Nug, ‘Da am Kayak beḵa,’ aum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","Ag anam aeg, Pilatus doya, nug huanak baḏa, ");
INSERT INTO gaw_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","nug eḏua lag op̱a noa, Jesus oḏ meṯom. “Na am ab adep̱anu uḏime?” oḏ meṯa aum amge Jesus oḏep̱a naḵok laa ii awom. ");
INSERT INTO gaw_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","Oḏep̱a ii awe amu Pilatus nug aum. “Aṯemun? Na dahil nai imu nob iite meḵut? Da na ad emaitakp̱a atulidḵulnu ap̱i amu atulidḵulag, o iiṯa da uhuqidḵulnu ap̱i amu uhuqidḵulag. Na amu iite dooṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","Anam a amu Jesus amegp̱a aum. “Aṯannu laa Nug na g̱agaṯag ii meṯalo amu na da ii aḏailom amunu aun nug da na ep̱enp̱a meiḏom ele amu, nuhig hip̱unin am oḵainab, nahip eḏiṯak,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","Pilatus nai amu doya, Nug Jesus uhuqḵunu heum amge Juda ag enan ap̱ig. “Na danab amu uhuqp̱e goḵu amu na Kaisa layag iiṯa! Danab laa nug nuḵa nuhig, ‘Da am king,’ aṯe, nug am Kaisanu kekeḏ,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","Pilatus nug nai anam doya, nug Jesus omala dimiṯim doa, epeḏiak aben onig Men Duqap̱ig, ap̱a epeḏiak oḵainu balalp̱a dayom. Men duqak amunu ag Hibru naip̱a, Gabata, aon adap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","Deḏ amuam Pasowanu meṯid hobul babaiṯaknu deḏ amu aam ameg 12 bia dayom. Anam dayeye, Pilatus Juda amelagp̱a aum. “King ahilag iiḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","Anam a amu Juda ag ap̱ig. “Aon ad emaitakp̱a atuleg! Aon ad emaitakp̱a atuleg!” aon ap̱ig. Anam aeg am Pilatus oḏ maṯom. “Ahilag King amu da ad emaitakp̱a atulḵulnu oolag daaṯete?” awa aum. Pilatus nug anam a amu mana meṯak danab oḵai ag inam ap̱ig. “Ig King laa iiṯa. Kaisa aaḵuib!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","Anam aeg amu Pilatus Jesus ad emaitakp̱a atulḵulagnu ag ep̱elagp̱a meum. ");
INSERT INTO gaw_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","Pilatus Jesus ag ep̱elagp̱a me, ban danab ag aoeg, Jesus nuḵa ad emaitak mawewe, aben laa onig Iḵilag Ebehi, ap̱a gop̱ig. Hibru naip̱a ag aben amunu Golgata aon aṯeb. ");
INSERT INTO gaw_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","Ag aben amup̱a ad emaitakp̱a atulp̱ig. Danab aḏit laa ele nug heqo laih laih atulatp̱ig, ag Jesus gamagp̱a atulp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","Pilatus nug nai iḵi laa ya, ad emaitak igip̱a atulom. Nai am inam. Jesus Nasaret ted, Juda dilag king. ");
INSERT INTO gaw_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","Nug nai amu Hibru naip̱a, Laten naip̱a, Grik naip̱a ele yom. Aria aben ag Jesus ad emaitakp̱a atulp̱ig ele amuam ab oḵai guguiṯak amunu Juda danab kuḏum ag nai amu eb qep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","Ag eb qep̱ig amunu mana meṯak danab oḵai ag Pilatus amegp̱a ap̱ig. “Na, ‘Nug am Juda dilag king,’ aib yaame. Iiṯa na, ‘Nug nuḵa, “Da am Juda dilag king,” awa aum,’ anam ye!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","Anam ap̱ig amge Pilatus nug ag amelagp̱a aum. “Da yaami am aaḵu yaami,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","Aria daup danab ag Jesus ad emaitakp̱a atulp̱ig, haen amup̱a ag nuhig lamen aona, daup danab waḏele ag laih laip̱u laip̱u anam aop̱ig. Ag amu aona amu ag lamen elab nuhig, baagp̱anu uḵa baegp̱a noak amu ele aoglagnu hep̱ig ");
INSERT INTO gaw_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","amge lamen amuam koitak ele iiṯa, kunum anam hep̱ig amunu daup danab ag ap̱ig. “Ig lamen amu ii paṯiḏmata. Ig dais qiḏ heta, ig oonigp̱anu aun ig laa oh eḏiḵa amu nug aoḵu,” aon ap̱ig. Ag anam heeg amu Kayak naip̱a, nai laa daaṯe amu elele meṯom. Nai amuam inam. “Ag lamen dahilad otialadna diip̱ig. Ag dais qiḏ hena, danab laa otieg, lamen elab dahil awom.” Daup danab ag anam hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","Aria ag anam heeg amu Jesus anig amu nug maḵeg amu Kliopas wau Maria amu Maria Magdala ted ele, ah amu oh ag Jesusnu ad emaitak guguiṯak daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","Ag anam daaegeg, Jesus Nug anig amu ip̱uniṯak awak danab laa, Jesus Nug nuhignu oo huanak mauhṯom ele amu, nug ele anata, Nug anig amegp̱a aum. “Ah, nid imu am na beḵat,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","Nug anam anana amu Nug ip̱uniṯak awak danab amegp̱a ele aum. “Imu am na anin,” awa aum. Jesus anam a amu ip̱uniṯak danab nug ah amu omala, nug laugp̱a uḵa, haen amup̱a nug dig ma gumeme, oh daadṯapiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","Keeke amu oh ba male amu Jesus doyom, uḏat nuhig oh aaḵu ha malom amunu Kayak naip̱a yak laa daaṯe, amu elele medaḵunu, Jesus aum. “Da le baal diiṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","Nai amu a, ag wain ena iiṯa, ap̱a dayom amunu ag keeke laa lamen bia, le eeḏṯe ele, amu onig span, keeke amu wainp̱a mewona, aon, ud laa onig hisop, amu gumup̱a itana, meeg te, Jesus lemaḏu yaap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","Ag Jesus wain anam meṯaeg lawowa, Nug aum. “Dahil uḏat aaḵu hein malami,” awa aum. Nug anam ana mala, Nug dug guḏa ne mauhom. ");
INSERT INTO gaw_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","Nug mauhom, deḏ amuam Juda ag ahilag Pasowanu meṯid hobul bap̱aidḵulagnu deḏ aaḵu oqiom. Deḏ amu uueb am meṯid oḵai beḵunu dayom amunu danab gaḏa meṯid amup̱a aihaṯak ii niimanu, Juda ag Pilatus amegp̱a daup ag gona, danab aihadp̱ig ele amu ag baelag qiip̱eg, ag mauhp̱eg, ag diiglagnu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","Amunu daup danab ag gona, danab aḏit Jesus ele atulatp̱ig ele amu baelah qiip̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","Ag anam qiiatp̱ig amge ag Jesus gumidna wana, Nug mauhom anidp̱ig. Nug mauhom anidna, baeg ii qiip̱ig ");
INSERT INTO gaw_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","amge daup danab laip̱u nug Jesus ban palapalp̱a qeṯi atule am pahanab tiig le ele neum. ");
INSERT INTO gaw_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","Laa nug keeke imu oh amegp̱a anṯom ele amu, nug iiḵu miag madiṯe. Nug madiṯe imu am genab, nug doyom amu ag ele oolagp̱a genab dooglagnu madiṯe. ");
INSERT INTO gaw_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","Keeke amu oh am Kayak naip̱a, nai daaṯe amu genab elele meḵunu beum. Nai amunu laa am inam. “Ag ebehi laa ii qiimna.” ");
INSERT INTO gaw_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","Am Kayak naip̱a nai amunu laa ele daaṯe am inam. “Laa ag qeṯi yaap̱ig ele amu, laa ag Nug anidḵulag.” ");
INSERT INTO gaw_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","Keeke imu oh dimp̱a amu Josep, Arimatia ted, nug Juda oḵai dilag baḏa, loḵumakp̱aib Jesusnu ip̱uniṯak danab oiṯom ele amu nug uḵa, Jesus gaḏa aoḵunu Pilatus unuqiṯom. Unuqiṯe, Pilatus nug, “Ena,” awa a amu Josep uḵa, Jesus gaḏa awom. ");
INSERT INTO gaw_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","Nikodemus, danab amu nug anuḵa dig makp̱a Jesus tuqan gumiṯa uḵom ele amu, nug ele uḏiom. Nug ad diig aḏitnu tiilah, muṯuḏilah ena ele, tiilah amu koboliatp̱ig, keeke amunu ug amu naḵok 75 paun anam, nug amu awa uḏiom. Laa onig Mir am laa onig Alos. ");
INSERT INTO gaw_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","Uḏie amu a Jesus gaḏa aoya, Mir Alos ele meya, Jesus gaḏa ele linen lamen elab amup̱a itapiḏ. Juda ag danab gaḏa boomḵulagnu hedap̱ig amubia hepiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","Amu dad laa, ag Jesus Nug ad emaitakp̱a atulp̱ig ele, aben amu guguiṯak ap̱a dayom. Dad amup̱a men moḏ bau, anuḵa danab amup̱a laa ii mep̱ig ele amu ap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","Juda dilag Pasowanu meṯid hobulnu bap̱aidḵulagnu deḏ aaḵu dayeye, amunu meṯid guguiṯeṯe, meṯid amup̱a uḏat hemananu, men moḏ amu miag dayom amunu a ap̱a Jesus gaḏa mepiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","Juda dilag Meṯid amu uḵa male, Maria, Magdala ted, nug buṯuanab gatatu ele moḏp̱a uḵa, men naḏi moḏ ameg tonom amu laa nug duṯune uḵa, moḏ amegp̱a ii dayeye anṯom. ");
INSERT INTO gaw_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","Anam anṯa, nug eḏua qaibaḏ uḵa, Simon Petrus amu ip̱uniṯak awak danab laa, Jesus Nug nuhignu oo huanak mauhṯom ele amu, a amelahp̱a aum. “Ag Naḏi aon, adebtag mep̱ig amu ig ii dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","Nug anam a amu Petrus, ip̱uniṯak awak danab laa ele a ahai, moḏp̱a goḵulahnu ");
INSERT INTO gaw_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","qaibaḏ gopiḏ. Goyaya amu ip̱uniṯak awak danab laa amu nug Petrus eḏiṯa, nug tatam moḏ guguiṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","Nug uḵa ta, gomela neeḵe, moḏ oop̱a uḵe amu nug lamen elab, ag amup̱a Jesus gaḏa itap̱ig ele amu nug amuib niieye anṯom amge nug oop̱a ii noum. ");
INSERT INTO gaw_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","Nug anam neeḵa dayeye, dimp̱a Simon Petrus nug uḵa ta, nug ip̱u meṯa, moḏ oop̱a uḵa, nug ele linen lamen amu anṯa, ");
INSERT INTO gaw_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","nug lamen laa, ag lamen amup̱a Jesus iḵi hautp̱ig ele amu, nug lamen amu ele anṯom. Lamen amu qak dayom bia nuḵa anam dayeye, linen lamen ele amu nug ele nuḵa dayeye anṯom. ");
INSERT INTO gaw_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","Anam anṯe amu ip̱uniṯak awak danab nug tatam men moḏp̱a uḵom ele amu, nug ele oop̱a noa anṯa, nug oop̱a genab doyom. ");
INSERT INTO gaw_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","A amelahp̱anab anam anidya, a Kayak naip̱a, Jesus Nug eḏua hip̱aidḵunu nai amu yak daaṯe amu a amunu oolah ii maiṯom. ");
INSERT INTO gaw_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","A anam anṯoya amu ip̱uniṯak awak danab aḏit a eḏuya laulahp̱a gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","Ip̱uniṯak awak danab aḏit uḵaeheh, Maria nug dimiṯim hibaiṯa, gayaya dayaya, nug gomela neeḵe, men moḏ oop̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","Neeḵe uḵe amu engel aḏit, lamen haḵab ele, Jesus gaḏa niiom aben amup̱a laa igip̱a laa baegp̱a anam daaeheh anatom. ");
INSERT INTO gaw_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","Anate, a nug amegp̱a apiḏ. “Ah na aḏinu gaaṯem?” aoya apiḏ. Anam aeh amu nug aum. “Danab ag dahil Naḏi aon adebtag gop̱ig, adebtag mep̱ig, da ii dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","Nug anam anana, nug eḏua amu Jesus hibaiṯa dayeye anṯom amge Nug am Jesus amu nug ii doyom. ");
INSERT INTO gaw_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","Ah nug eḏua Jesus anṯe amu Jesus ah oḏ meṯom. “Ah, na aḏinu gaaṯem? Aun madiṯem?” oḏ meṯa aum. Oḏ meṯe amu ah nug danab amu nug dad amu mamegtai anana amu amegp̱a aum. “Danab naḏi, natai aon gome? Anam dayeb amu na adep̱a meme amu da amelp̱a ap̱e, da uḵen aoḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","Anam a amu Jesus eḏua ah onig diia, “Maria,” awa aum. Anam a amu ah nug eḏua Hibru naip̱a, “Rabonai,” awa aum. Amu diig am, “Ip̱uniṯak danab.” ");
INSERT INTO gaw_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","Nug anam a amu Jesus aum. “Na da aib aḏailme, da Mame top̱a ii gomi. Amge na da oḏel aona, da lailad gumadna gona, amelagp̱a inam a! ‘Da, da Mamel, Nug am ag Mamelag ele, da dahil Kayak amu ahilag Kayak ele amu, da Nug gumiṯe goṯem,’” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","Jesus anam amegp̱a a amu Maria, Magdala ted, nug uḵa, ip̱uniṯak awak danab amelagp̱a aum. “Da Naḏi anidmi,” awa aum. Anana amu nai Jesus nug amegp̱a aum amu oh amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","Aria deḏ amup̱aib Meṯidp̱a gatatu ne, Jesusnu ip̱uniṯak awak danab ag Juda dilag oḵai baḏadna, lag od manon daaegeg, Jesus uḏia tula, ag gumaṯa doa dayaya, ag amelagp̱a aum. “Ag oo mak maḏoḏ ele aweg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","Nug anam awowa amu Nug ep̱eg, qeṯi ele ip̱uanaṯom. Ag Naḏi anidna amu ag oolag gamag ahak oḵai doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","Ag oolag gamag ahe amu Jesus baula amelagp̱a aum. “Ag oo mak maḏoḏ ele aweg! Mame Nug da meiḏe uḏimi, amubia da ele ag maaṯi goṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","Anam awowa, Nug ouḏi ahilagp̱a iwala, Nug aum. “Ag Kayak Ouḏi aweg! ");
INSERT INTO gaw_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","Ag danab dilag hip̱unin op̱ina maṯaglag amu danab amu dilag hip̱unin iiṯa meḵulag. Ag ii op̱ina maṯaglag amu danab amu dilag hip̱unin iiṯa ii memana,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","Haen amup̱a ip̱uniṯak awak danab laa Tomas, nuhignu ag Didimas ele aṯeb amu, nug ag ele ii daaegeg, Jesus Nug uḏiom ");
INSERT INTO gaw_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","amunu ip̱uniṯak awak danab laiḵud laa ag Naḏi anidp̱ignu amegp̱a aeg, nug aum. “Ag Nug ep̱eg tutuip̱a atulp̱ig amunu duḏup̱a amu da amelp̱a anṯena, da duḏup̱a amu ep̱elp̱a aḏen, Nug qeṯi duḏup̱a ele ep̱elp̱a aḏe doyena amu da oolp̱a genab dooḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","Nug anam a dimp̱a meṯid laip̱u uue, ip̱uniṯak awak danab ag baula Meṯidp̱a laḵa qag mena daanna, haen amup̱a Tomas nug ele oh daap̱ig. Ag daanna, lag od oh amu manaṯon daap̱ig amge Jesus Nug uḏia oolagp̱a dayaya aum. “Ag oo mak maḏoḏ ele aweg!” ");
INSERT INTO gaw_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","Anam awowa, Nug Tomas amegp̱a aum. “Na ep̱en doḏop̱a da ep̱el nakok aḏan, amenp̱a ele da ep̱el anṯe! Na ep̱en bahin, da qeṯil ele nakok aḏe! Na oop̱a genab ii doyak danab bia aib heme. Iiṯa! Na ootp̱a genab doye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","Nug anam a amu Tomas oḏep̱a awa aum. “Na dahil Naḏi. Na dahil Kayak!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","Nug anam a amu Jesus amegp̱a aum. “Na amu amenp̱anab da aniḏna, na ootp̱a genab doome. Laa ag da ii aniḏna, oolagp̱a genab dooṯeb amu, Kayak Nug ag itiṯak madaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","Jesus Nug nuhiḵud ip̱uniṯak awak danab noolagp̱a ep̱onak keeke, danab heḵunu elele iiṯa iḏu iḏu kuḏum laa ele heum amu buk imup̱a oh ii yak. ");
INSERT INTO gaw_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","Amge yak imu daaṯe amu ag eb qenana, ag, Jesus Nug am Kristus, Nug am ele Kayak Beḵa daaṯe, ag amu doona, oolagp̱a genab dooglagnu daaṯe. Ag nuhignu oolagp̱a genab doonna amu ag Nug onigp̱a ag bauklel aoglagnu yak imu amunu ele daaṯe. ");
INSERT INTO gaw_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","Deḏ laa Jesus Nug nuhiḵud ip̱uniṯak awak danab ag Nug baula anidḵulagnu Taibirias le ihip̱a gumaṯa waum. Keeke amuam inam beum. ");
INSERT INTO gaw_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","Ap̱a Simon Petrus, Tomas, nuhignu ag Didimas ele aṯeb amu, aria Nataniel, nug am Galelia wanp̱anu danab, nug ap̱ag diig am Kana amu Sebedi Bekoḏ aḏit amu Jesusnu ip̱uniṯak awak danab aḏit laa ele, ag oh ap̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","Anam daanna amu Simon Petrus nug amelagp̱a aum. “Da kakainu goḵul,” awa aum. Nug anam a amu ag ap̱ig. “Ig na ele oh goḵunig,” aon ap̱ig. Anam ana amu ag oh ahan gona, ub laap̱a tep̱ig amge tuqan amup̱a ag kakai naḵok laa ii aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","Buṯua waḵaḏeḏe amu Jesus uḵa, le ihip̱a hibaiṯa dayom amge ip̱uniṯak awak danab ag danab amu, Nug am Jesus amu, ag ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","Am Jesus Nug ag oḏ maṯom. “O nid, ag kakai laa aop̱igte?” awa aum. Anam a amu ag, “Iiṯa,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","Ag anam aeg amu Jesus aum. “Ag uhui ub heqo laih naḏiap̱a eig! Ag anam hena amu ag kakai aoglag,” awa aum. Jesus anam a amu ag uhui naḏiap̱a ena amu ag kakai huanak aop̱ig. Awona, uhui eeḏp̱eg beḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","Anam daye amu ip̱uniṯak awak danab laa, Jesus nuhignu oo huanak mauhṯom ele amu, nug Simon Petrus amegp̱a aum. “Umu am Naḏi,” awa aum. Anam a, Simon Petrus nug uḏat haaha, ulahnu lamen uḏa dayom ele amu nug, “Umu am Naḏi,” nai amu doya, nug ulah lamen awa ma, oola lep̱a noum. ");
INSERT INTO gaw_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","Nug oola lep̱a no, ip̱uniṯak awak danab laa oh ag ubp̱a daanna, uhui kakai ele eeḏp̱ig. Ag umanab ii daap̱ig, yu ihi guguiṯak, 90 mita keeke daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","Ag ub el qena uḏin, le ihip̱a dona amu ab laa ilak ewawa dayeye anidp̱ig. Kakai laala ab oṯagp̱a anadna amu bret ele dayeye anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","Ag keeke anam anṯeg amu Jesus amelagp̱a aum. “Kakai ag geha aaḵu diip̱ig ele amu, laa akan doig!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","Jesus anam a amu Simon Petrus nug ubp̱a ta, uhui kakai ele amu eeḏe, uḏuaman be, kakai oḵai oḵai amu eb qena, 153 anidp̱ig. Am huanaknab amge uhui naḵok laa ii paḵuom. ");
INSERT INTO gaw_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","Anam daye amu Jesus amelagp̱a aum. “Dona e laig!” awa aum. Ip̱uniṯak awak danab laip̱u laa nug Jesus oḏ meṯa, “Na aun,” anam laa ii aum. Ag doop̱ig, nug am Naḏi. ");
INSERT INTO gaw_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","Ag anam doop̱ig amu Jesus Nug doa, bret awa, pania maṯom. Kakai ele awa, pania maṯom. ");
INSERT INTO gaw_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","Jesus Nug eḏua hibaiṯom amu haen ewam aaḵu nuhiḵud ip̱uniṯak awak danab ag Nug anidḵulagnu gumaṯa waum. ");
INSERT INTO gaw_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","Ag e lana malona, Jesus Nug Petrus oḏ meṯom. “Simon, Johanes beḵa, na laa oh eḏaṯak dahilnu oot mauhṯete?” awa aum. Anam a amu Petrus aum. “Naḏi na dooṯem. Da nahipnu ool mauhṯe,” awa aum. Petrus anam a amu Jesus aum. “Na dahil sipsip naḵud beḵadna meḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","Jesus anam anana amu Nug baula oḏ meṯom. “Simon, Johanes beḵa, na dahilnu oot mauhṯete?” awa aum. Anam a amu Petrus aum. “Ao, Naḏi na dooṯem, da nahipnu ool mauhṯe,” awa aum. Anam a amu Jesus baula aum. “Na dahilad sipsip atog noadna meḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","Jesus baula ewam batak Petrus oḏ meṯom. “Simon, Johanes beḵa, na dahilnu oot mauhṯete?” awa aum. Petrus Jesus haen ewam batak, “Na dahilnu oot mauhṯete?” aum amunu oop̱a guiṯak doyaya, nug Jesus amegp̱a aum. “Naḏi na keeke oh doon malame amu na da nahipnu ool mauhṯe ele dooṯem,” awa aum. Petrus anam a amu Jesus amegp̱a aum. “Dahil sipsip beḵadna meḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","Jesus Nug anam anana, Nug nai baula tuḏiṯa aum. “Da genabnab genab na amenp̱a aṯem, na nid bau daanna amu na naḵa maṯagiḏ imuanp̱a taḵana, aben na naḵa goḵutnu oot dayom amu na amup̱a goṯame. Amge dimp̱a na kaino mena amu na ep̱en humap̱e, laa nug na maṯagiḏ imuanp̱a tagiṯa, aben na goḵutnu oot ii daaṯe, amup̱a omaiṯeb goḵut,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","Jesus nai amu maṯiom amu dimp̱a Petrus nug ib aṯemup̱a mauha, nug Kayak binag amup̱a meḵu amunu aum. Nai amu oh dimp̱a Jesus Nug, “Petrus na da dim lamiḏe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","Petrus Jesus ele goyaya amu Petrus nug eḏua neeḵa, ip̱uniṯak awak danab laa, Jesus nuhignu oo huanak mauhṯom ele, nug anuḵa e lanak haenp̱a Jesus guguiṯa dayaya, “Naḏi, aun nug na kekeḏ ep̱elagp̱a meidḵu?” aum ele amu, nug dim lamatete anṯom. ");
INSERT INTO gaw_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","Petrus nug anṯa amu Jesus amegp̱a aum. “Naḏi, danab imu am aḏi heḵu?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","Anam a amu Jesus Nug Petrus amegp̱a aum. “Da nug anam dayebeb, da eḏue uḏiḵulnu amegp̱a aḵulnu daalo amu, amuam nahip keekete? Na daib dim lamiḏe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","Jesus anam a amu nug laiḵud oolagp̱a ip̱uniṯak awak danab amuam ii mauhmanu nai anam naḏi meum amge Jesus Nug, “Danab amu nug ii mauhma,” ii aum. Iiṯa! Nug, “Da ap̱i, nug ii mauheb, da eḏuen neḵul am nahip keekete?” aaḵuib aum. ");
INSERT INTO gaw_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","Am ip̱uniṯak awak danab amuib nug keeke imu oh amegp̱a anṯa, nai amu madiṯe, nai imu ele iiḵu yom amunu ig dooṯem, nai imu genab. ");
INSERT INTO gaw_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","Amu keeke kuḏum laa ele Jesus Nug heum amu, keeke amu oh danab nug bukp̱a yaalo amu buk huanaknab daalob, buk amu wan imup̱a am belo. ");
INSERT INTO gaw_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","2","O Tiopilas, yak dahil da tatam yaami amu da yak amup̱a Jesus Nug uḏat oh heumnu, Nug danab ah keeke ip̱uanaṯomnu ele yaami. Nug uḏat amu dig me uḏie, deḏ Nug hab aṯan teum batak amu Nug uḏat amu oh heum. Heehe da amunu yaami. Aria da nai yaami anidme ele amu, Nug mauha bau hibaiṯe, deḏ 40 uue Nug hab aṯan teum. Amge ii uḵom haenp̱a Nug goḵunu haaha, tatam Nug nuhiḵud totol danab elewen, Nug tituanaṯom ele amu, ag nai amu tuḏidna heḵulagnu, Nug Kayak Ouḏi g̱agaṯagp̱a nai maṯom. ");
INSERT INTO gaw_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","Aria Nug guiṯak nau amu awa mauhowa, dimp̱a genab eḏua hibaiṯom amu Nug nuhiḵud totol danab elewen haen gamag deḏ 40 amup̱a gumaṯa ona, ib kuḏump̱a keeke amu ip̱uanaṯom. Nug deḏ 40 amup̱a Kayaknu ḏo maḏoḏnu nai ele mehuqe doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","Amu ele deḏ 40 amup̱a Nug ag ele oh haen laa e lanan daanna, Nug amelagp̱a aum. “Ag Jerusalem paha aib uup̱ig. Am ag keeke ena, da Mamel Nug ag keeke amu madaḵunu nai qaḵa aum, keeke amunu ele da ag ai doop̱ig amu, ag Nug ameg meḵulag. ");
INSERT INTO gaw_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","Am genab Johanes nug danab ah lep̱a layaṯom amge haen elab iiṯa amu ag Kayak Ouḏip̱a layaṯak aoglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","Nug anam a, haen laa ag oh qauko onig Olip ap̱a qag mena, Nug aum amunu ag Nug oḏ medap̱ig. “Naḏi, haen imup̱anab na hep̱e, Rom ag ahap̱eg, ig Israel ig eḏut wan ihinig gumagnigte?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","Aeg amu Nug ag amelagp̱a aum. “Amu ahilagte keeke amunu ag da Mamel Nug haen deḏ ele aum amu ag dooglag? Iiṯa. Nug nuḵa keeke amu gumaṯe. ");
INSERT INTO gaw_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","Amge geha dimp̱a Kayak Ouḏi Nug ahilagp̱a neeb, ag g̱agaṯag aon amu geha ag dahil nai Jerusalem mehuqna amu Juda wan ohp̱a amu Samaria amu uḵeb wan atu ohp̱a ele gona mehuqḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","Am Nug nai amu amelagp̱a ana male, ag neegna daaegeg, Kayak he, Nug aṯan teete amu lombig laa haute, ag baula Nug ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","Nug uḵe, ag hab aṯan neegna daaegeg am danab aḏit, a lamen haḵab ele, a tulai doeh, ag ele hip̱aidna daanna, ");
INSERT INTO gaw_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","a apiḏ. “Galelia danab, aḏinu ag hip̱aidna daanna, hab aṯan neegna daaṯeb? Amu gemu Kayak Nug Jesus ahilagp̱anu awe, hab aṯan uḵom. Aria geha Nug hab aṯan ugeḵe anidp̱ig bia eḏua uḏiḵu,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","Aria ag qauko, Olip aṯeb, ap̱anu eḏun Jerusalem wap̱ig. Qauko amup̱anu Jerusalem wanak amu miag, kilomita laip̱u maha ele. Juda dilag ḏop̱a danab nug ahilag Meṯidp̱a tap̱a uḵak elab amubia goḵunu elele. ");
INSERT INTO gaw_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","Ag ab oḵaip̱a tena amu ag gona, ag lag oo aṯan, ag daap̱ig ele amup̱a tep̱ig. Ag onilag amu Petrus, Johanes, Jakobus, Andreus, Pilipus, Tomas, Batolomiu, Mateus, Alpias beḵa Jakobus, Simon, nug am Selot, amu Jakobus beḵa Judas aaḵu. ");
INSERT INTO gaw_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","Danab amu ag oh oolag laip̱u mena, haen kuḏum danab ah laala ele oh qag mena, unuqidnana daap̱ig. Danab ah amuam Jesus anig Maria, Jesus amaḵud amu ah laala ele. ");
INSERT INTO gaw_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","Ag anam daanna, haen amup̱a Petrus nug laiḵud, ag Jesusnu oolagp̱a genab doop̱ig ele, ahilag eb qak 120 anam amu nug ag oolagp̱a aha, hibaiṯa, Judasnu nai maṯiom. ");
INSERT INTO gaw_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","19","Danab amu nug eheḏ ha, uḏat amunu men doḏo awom ele amup̱a ag wan laih nakok laa daden mep̱ig. Aria nug nuḵa wan amup̱a nug beḏu aiha na qe, oo aoḏe, biig oh wanp̱a ne, dimp̱a danab Jerusalem daap̱ig ag oh amu doop̱ig amunu ag ahilag naip̱a, ag aben amunu, Akeldama aṯeb. Amu eḏuak am, Wan Tiig ele. Amu Petrus nug inam aum. “O lailad, Kayak Ouḏi Nug laa oḏep̱a keeke laa Judas nuhigp̱a beḵunu a, beḵununab dayaya aaḵu beum. Danab amu nug ig ele daatta, ig ele oh uḏat laip̱u hemut amge nug ele danab ag Jesus aḏaglagnu ib dayom. ");
INSERT INTO gaw_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","Kayak Ouḏi nug anam heḵunu doya amu Nug he, Judasnu nai imu Dawit oḏep̱a be, buk Samp̱a inam yak daaṯe. ‘Lag nuhig amu hamu dayaḏ! Danab laa ap̱a aib dayom!’ Amu Sam laap̱a yak daaṯe amu, ‘Danab laa nug nuhig uḏat amu aoḵu,’ ");
INSERT INTO gaw_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","amunu gemu ig danab laa, nug ig ele haen oh oidmut amu nug Judas aben aoḵunu tituanḵunig. ");
INSERT INTO gaw_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","Haen Naḏi Jesus Nug Johanesnu layaṯak awe uḏie uḏie, deḏ Kayak Nug awe, hab aṯan teum batak amu danab laala ag ig ele laip̱u oimut, ag oolagp̱anu laa tituanḵunig. Amu nug ig ele, Jesus eḏua hibaiṯom, nai amu mehuqḵunig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","Petrus nug anam a, aria ag danab aḏit otiatp̱ig. Laa amu Sabas beḵa Josep, onig laa Jastus. Am danab laa amu Mataias. ");
INSERT INTO gaw_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","25","Ag danab aḏit otiatona, ag inam unuqidp̱ig. “Naḏi, na danab oh oolag diig dooṯem amunu danab aḏit imu oolahp̱an na aun nug Judas abenp̱a ba, totol uḏat imu aoḵunu tituanme amu na ig ip̱uniḵe! Judas nug nuhig abenp̱a goḵunu uḏat amu uuom,” unuqidna anam ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","Anam unuqiṯona, aria ag Kayaknu dab mak dooglagnu kobol ahilag hena, Mataias anidna aop̱ig. Ag nug aona, totol danab elewen amu ele tuḏidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","Aria Juda dilag deḏ oḵai laa onig Pentikos, deḏ amu uḏie amu ag oh uḏin, aben laip̱u ap̱a qag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","Qag men daaegeg, hab aṯannu oqoṯi paha laip̱un uḏiom. Oqoṯi amu ulah naḏi g̱agaṯag uḏiaya, oqoṯi oṯe bia. Uḏie, ag daap̱ig ele amu, ag lag amu oo ohp̱a oqoṯi huana doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","Ag keeke amu doyeg amu ab ewawa, lemaḏmaḏ qeṯe amubia haaha, pane ne, danab daap̱ig amu oh anen anen dilagp̱a paniom anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","Anam he amu danab oolagp̱a genab doop̱ig ele, danab amu ag oh Kayak Ouḏi ag oolagp̱a am be, ag ahan, nai diigdiigp̱a nai madip̱ig. Amu Kayak Ouḏi Nug he, ag oḏelagp̱a anam nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","Haen amup̱a wan ohp̱anu Juda danab, ag Kayak dab medap̱ig ele amu, ag gona ab ab daap̱ig, ap̱anu uḏin Jerusalem daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","Ag haen amu oqoṯi amu doona, danab ah ameg naḏi uḏin qag mena, danab piḏe piḏenu ag oh totol danab, ag ahilag naip̱a nai mehuqegeg doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","Ag nailagp̱a nai mehuqeg doonna, ag oṯaina, ag dab mak kuḏum aona ap̱ig. “Umu aḏi? Aṯem hena heṯeb? Danab nai madiṯeb ele umu ag amu Galelia danab. ");
INSERT INTO gaw_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","Amu aṯemun ig oh danab ab laalap̱anu amu ig nainigp̱a nai dooṯem? Ig aninḵad mamenḵad maṯiegeg dooṯem amubia dooṯem. ");
INSERT INTO gaw_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","Ig amu Patia, Midia, Ilam, amu Mesopotemia ele daaṯem. Amu Juda, Kapadosia, Pontus Asia ele daaṯem. ");
INSERT INTO gaw_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","Amu Prisia, Pampilia, Igipta amu laih Libianu, Sairini guguiṯaknu ele daaṯem. Amu Rom danab ele ig oh uḏimut daaṯem. ");
INSERT INTO gaw_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","Ig Juda amu laala Juda kobol awak ele, amu ig Krit amu Arabia ap̱anu ele uḏimut. Uḏit, ig oh nainig aben abenp̱a Kayak uḏat enanag heumnu mehuqegeg dooṯem,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","Ag anam anana, ag oh eheḏ oṯaina, dab mak kuḏum aona, ag aḵa aḵa, “Keeke umu amu aṯemunnab?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","Ag anam ap̱ig amge laala ag awa awa qeṯak nai maṯin, inam ap̱ig. “Umu amu ag wain huana laeg, kaaka aqe heṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","Ag anam aon aeg amu Petrus aha hibaiṯe, totol danab elewen amu ele ahaeg, nug g̱agaṯag ewa, danab ah ag tutuḵu doona maidḵulagnu inam aum. “Juda danab ag amu danab uḏip̱ig gemu Jerusalem daaṯeb ele ag oh, da nai madip̱i, ag daulag human dab mebep̱eg, da keeke amunu diig mehuqp̱i doyeg! ");
INSERT INTO gaw_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","Ag, ‘Danab imu wain laegeg, kaaka aqaṯe,’ aṯeb amge danab imu ag anam ii heṯeb. Iiṯa! Geha iiḵu am buṯua 9 kilokib amu ag dooṯeb, ig buṯuanab wain ii laṯem. ");
INSERT INTO gaw_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","Kobol imu am kaaka aqaknu iiṯa. Kobol imu amu anuḵa propet Joel nug Kayak oḏe awa, nai maṯiom amu, nug maṯiomnu iiḵu beṯe. ");
INSERT INTO gaw_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","Kayak Nug inam Joel amegp̱a a doya yom. ‘Dimp̱a haen nug malaḵunu heebeb, haen gamag amup̱a da dahil Ouḏi, danab ah madaḵul. Madap̱i amu ag Kayak Ouḏi aop̱ig ele, ag oolagp̱anu amu laala geha ag propet dahil nai mehuqḵulag. Amu geha da laala keeke diigdiig tuleglegp̱a ip̱uanadḵul am laala ag amu doyak tul niiakp̱a madaḵul. ");
INSERT INTO gaw_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","Amu geha haen amup̱a da uḏat nid, uḏat ah dahilad ele Ouḏi dahil madap̱i, ag dahil nai mehuqḵulag. ");
INSERT INTO gaw_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","20","Da geha kobol diig laa habp̱a hep̱i, aam nug gatatu manebeb, kalam am tiig eḏuḵu. Aria wanp̱a da ep̱onak keeke, tiig, ab aḏu amu kahug naḏi ele hep̱i, geha beḵulag. Amu Naḏinu deḏ am geha dim beḵu. ");
INSERT INTO gaw_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","Amu danab ah oh ag Naḏi eḏua diiḵunu eḵulag amu, ag ehaniṯak amu aoglag.’ Joel anam yom. ");
INSERT INTO gaw_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","Amu Israel danab ag nai imu doyeg! Da ag amelagp̱a Jesus, Nasaret ted, nuhignu ap̱i dooglag. Ag aḵa aaḵu dooṯeb, Kayak Nug ehaniṯe, Nug ag oolagp̱a ep̱onak keeke, danab heḵunu elele iiṯa diigdiig heum. Kayak he, Jesus anam heum, amuam Kayak Nug Jesus me neum ip̱uanadṯe. ");
INSERT INTO gaw_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","Kayak Nug anuḵa nuhig doyakp̱a anam heḵunu nai maṯiom amu Nug Jesus awa, ag ep̱elagp̱a me, ag danab nau, ahilag ehaniṯakp̱a, ad emaitakp̱a atulna qeeg mauhom. ");
INSERT INTO gaw_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","Amge Kayak Nug mauhak oolagp̱anu uhuqa he, eḏua hibaiṯom. Mauhak amu Nug aḏaḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","Amuam Dawit nuhignu yom amubia. Dawit nug inam yom. ‘Naḏi Nug ou iwa daaṯe anidṯem. Nug da ele ou qeḏa, g̱agaṯag meḏeḏe amunu keeke laa nug da ii uḏaliḏma. ");
INSERT INTO gaw_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","Amunu da oo maḏoḏ enanag ele dayeye, oo gamag ahak nai maṯieye, da daḵa dimp̱a keeke ena aoḵul amunu ameg meṯem. ");
INSERT INTO gaw_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","Aḏinu? Na geha da ii uuiḏmana amunu da mauhak daaṯeb abenp̱a ii daapa. Am geha na nahip danab tutuḵu op̱ia awak ele amu, na ii uuidmana amunu mauhak nug heeb, beḏu ii nauhma. ");
INSERT INTO gaw_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","Na bau dayaknu ib da ip̱uniḏme. Na da ele daagnih amunu da oo gamag ahak oḵainab dooḵul,’ awa yom.” Petrus nug anam awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","Nug anam anana, nug nai baula tuḏiṯa aum. “O lailad, Dawit nug nai amu maṯiom amu nug nuhignu dab maama ii maṯiom. Ig amu aṯem doognig am Dawit nug mauhe boomeg, nuhig boomak aben ig oonigp̱a iiḵu daaṯe. ");
INSERT INTO gaw_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","Dawit nug propet dayom amu Kayak Nug nuḵa nuhig nai g̱agaṯag qedaṯa, Dawit amegp̱a inam a doyom. ‘Dimp̱a na buḏunp̱an da king laa otip̱i ba, nahip king uḏat amu Nug heḵu,’ awa aum. Nug anam a, Dawit doyom amge ");
INSERT INTO gaw_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","amu ii nak haenp̱a nug dimp̱a Kayak Nug heeb, Kristus Nug mauhakp̱anu eḏua hip̱aidḵu, mauhak abenp̱a ii daama, Nug beḏu ele ii beḏamanu aum. ");
INSERT INTO gaw_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","Aria anam amunu ag doyeg! Kayak Nug he, Jesus eḏua hibaiṯom. Ig oh Nug anam heum amu anidmut amunu ig iiḵu madiṯem. ");
INSERT INTO gaw_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","Nug hab aṯan teum, Kayak ep̱eg naḏiapp̱a, amuam anuqak aben, amup̱a daaṯe. Mameg Kayak Nug nuhig Ouḏi, anuḵa medaḵunu nai qaḵa aum bia amu, Nug meṯom. Meṯe, Jesus Nug ig ele iiḵu gemu Kayak Ouḏi meḵom amunu ag keeke imu gemu anidna dooṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","35","Amu Petrus nug anam anana, nug nai imu tuḏiṯa amelagp̱a aum. “Dawit nug nai laa ele aum am inam. ‘Naḏi Nug Naḏi dahil amegp̱a inam aum. Na am dahil dayaknu aben anuqak imup̱a daap̱e uḵeb, dimp̱a da geha kekeḏ nahipad oh tap̱aladp̱i, ag na waatp̱a daaglag,’ awa aum. Aria Dawit nai amu maṯiom haenp̱a nug nuḵa nuhignu dab maama ii maṯiom. Iiṯa. Nug mauhe, beḏu hab aṯan ii teum. Iiṯa. Ag nug boomp̱ig amunu nug nai amup̱a Jesus ip̱uniḵa heum. ");
INSERT INTO gaw_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","Amunu Israel beḵod, ag oh tutuḵunab doyeg! Kayak Nug he, Jesus Nug Naḏi, am Kristus ele daaṯe. Ag Nug ad emaitakp̱a atulp̱ig.” Petrus amelagp̱a anam maṯie doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","Ag nai maṯie doona, nai amu ag oolagnab yom amunu ag ahan, Petrus amu totol danab elewen ele ag amelagp̱a inam ap̱ig. “O ig lainḵad, geha ig aṯemtai heḵunig?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","Aon aeg am Petrus nug amelagp̱a aum. “Kayak Nug ahilag hip̱unin uhuqa madaḵunu amu ag oh aḵa anen anen ag oolag eḏueb, Jesus Kristus onigp̱a layaṯak aweg! Ag anam hep̱eg, Kayak Nug nuhig Ouḏi ag hamu madaḵu. ");
INSERT INTO gaw_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","Am Kayak Nug anuḵa Nuhig Ouḏi ag amu ag beḵalḵad amu wan laa adep̱a danab ah daaṯeb ag ele madaḵunu nai qaḵa aum. Yo aun aḏi ag ihinig Naḏi Kayak Nug ag onilagp̱a eḵu amu, ag madaḵunu nai qaḵa aum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","Am Petrus nug nai kuḏum laala ele dab mak awaknu nai mehuqaqa, nug amelagp̱a inam aum. “Ag lailḵad ag Jesusnu oolagp̱a genab ii dooṯeb amubia ag aib hep̱ig. Iiṯa! Ag oolag eḏueb, Kayaknu ehaniṯak aweg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","Am danab Petrus nai maṯiom amu genab doonna, ahilag eb qak 3000 keeke amu ag layaṯak aop̱ig. Aona ag Jesusnu oolagp̱a genab doop̱ig ele amu oolagp̱a uḵaeg, oh laip̱u daanna ");
INSERT INTO gaw_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","amu ag totol danab tuelp nai mehuqegeg doonna, laip̱u dayak ena daanna, nug ehanidnana, e laip̱u lanan, Kayak unuqidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","Ag anam henana, danab ah oh ag Kayaknu enanag doona, ag oolag ele oṯaiom. Amu Kayak Nug totol danab tuelp ep̱elagp̱a ep̱onak keeke, danab heḵunu elele iiṯa amu kuḏum diigdiig ele heum. ");
INSERT INTO gaw_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","Anam heehe, danab oh ag Kristusnu oolagp̱a genab doop̱ig ele amu, ag oolag laip̱u mena, laip̱u qag mak daanna, danab laala ag keeke ele amu aḵa ahilagnuib ii aḏap̱ig. Iiṯa, ag laip̱u qag mak daaṯeb ag oh ahilag dayom. ");
INSERT INTO gaw_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","Am danab laala ag wan ele amu laala ag keeke ele amu ag heeg, danab laa daden meeg, ag men doḏo amu aona, danab laala e aon laḵulagnu elele iiṯa daap̱ig amu otin madap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","Ag anam henan, ag oh oolag laip̱u daanna amu deḏ oh mana meṯak laḵa gonana, Kayak nai doop̱ig. Amge ag laulag anen anen oh oina, ag oo gamag ahak doonna, ag Kayak amegp̱a, “Ena hen meḵame,” anana, e lap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","Anam henana, haen oh Kayak binag meegeg, danab ah laala oh ahilagnu oolag enaib dayom. Haen amu deḏ ohp̱a Kayak Nug danab ah laala eḏua diieye, ag kristen tamaniak oop̱a daap̱ig ele amu, ag ele tuḏidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","Haen amu deḏ laa Petrus Johanes ele a aam ameg ewamp̱a, unuqiṯak haenp̱a, mana meṯak laḵa unuqidḵulahnu gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","Uḵaeh, danab laa dayom, nug baekuḏ baag batak, wan tabṯe ele, a oh mauhpiḏ. Nug anig oop̱anu anam doum. Ag deḏ oh nug aon gona, mana meṯak lagnu aḏ odp̱a, od amunu ag, Anṯaknu Enanag aṯeb, amu guḵuidna meeg dayaya, danab ah ag mana meṯak lag oop̱a noegeg, men doḏo meṯaglagnu unuqaṯaṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","Danab amu nug Petrus Johanes ele a mana meṯak lag oop̱a noeheh anata, nug keeke meṯaglahnu unuqatom. ");
INSERT INTO gaw_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","Unuqata, Petrus Johanes ele a nug g̱agaṯag neeḵidyaya amu Petrus nug aum. “Na i anite!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","Anam a, danab amu eḏua, oo ekuḏe, ahilahp̱a uḵe amu nug oop̱a, “A keeke meḏaglahnu heṯep,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","Amge Petrus nug aum. “Da men doḏo iiṯa amge da dahil keeke daaṯe amu da na medaḵul. Jesus Kristus, Nasaret ted, Nug onigp̱a da na amenp̱a aṯem. Na ahan oiye!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","Petrus nug anam awowa, ep̱eg bahia, ep̱eg naḏiapp̱a aḏa, hume, pahanab baekuḏ oh g̱agaṯag qepiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","Nug baekuḏ g̱agaṯag ep̱aeh, nug paha aha hibaiṯa tap̱a oiyeye, nug Petrus Johanes ele oh mana meṯak lag oop̱a nonana, nug aha oola ta oola nana oiyaya, Kayak binag meum. ");
INSERT INTO gaw_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","Danab amu aha, Kayak binag maama oiyeye, danab ah oh ag nug anidna, ");
INSERT INTO gaw_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ag nug doop̱ig, nug am danab laa iiṯa, nug aaḵu hanhan mana meṯak lagnu aḏ odp̱a, od amunu ag, Anṯaknu Enanag aṯeb, amup̱a meeg dayaya, danab ah lag oop̱a noegeg, nug men doḏo meṯaglagnu unuqaṯaṯa daaṯom ele, nugib aaḵu gemu ena dayom, ag amu anidna, ag oṯaina, dab mak huana aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","Amu ag anam dab mak huana aoegeg, nug aha, Petrus Johanes ele aḏualatete amu danab ah oh ag ahan qaibaḏ dona, mana meṯak lagnu aḏ oop̱a aben laa, Solomonnu Aben aṯeb, amup̱a qag mep̱ig. Aḏinu? Ag huana oṯaina hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","Ag anam heeg, Petrus nug anaṯa, nug amelagp̱a inam aum. “Israel danab, ag aḏinu keeke imunu dab mak kuḏum aonna, ag i neeḵit-teb? Amu aṯemun ag i iya, ihinih g̱agaṯagp̱a o iiṯa i iya ihinih ena hakp̱a i heuḏ, danab imu nug aha oiṯe aṯeb? Anam iiṯanab, iiṯa. ");
INSERT INTO gaw_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","Abrahamnu, Isaknu, Jakop elenu Kayak, Nug am ig alanḵad dilag Kayak, Nug aaḵu nuhig uḏat imup̱a nuhig nid Jesus binag humaṯe. Amge ag Nug aon kekeḏ ep̱elagp̱a meeg, Pilatus nug uhuqḵunu aum amge iiṯa, ag am danab amu di medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","Ag am danab amu, Nug hip̱unin laa ii heum, Nug am op̱ia awak danab amu, ag Nug di meṯan, ag Pilatusnu eeg, nug danab laa, nug danab aqe mauhp̱ig ele amu, nug danab amu uhuqa awa, ag maṯa, heeb goḵunu enan, ");
INSERT INTO gaw_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ag danab ena, Nug ig bau hanhan ena dayaknu ib, ib amup̱a omaigṯe ele amu, ag Nug qeeg mauhom. Ag qeeg mauhom amge Kayak Nug he, eḏua hibaiṯe, i nuhig nai amunu mehuqṯep. ");
INSERT INTO gaw_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","Amu i Jesusnu oonihp̱a genab doomuḏ amup̱a Jesus Nug he, danab imu, ag nug anidna dooṯeb ele amu, nug enanagib daaṯe. Yo, i Jesusnu oonihp̱a genab dooṯep, ib amup̱a Nug he, danab imu nug eḏua, ag anidṯeb bia ena daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","Petrus anam anana, nug nai tuḏiṯa aum. “O lailad, da genab dooṯem, ag Jesus nuhigp̱a eheḏ hep̱ig amu, ag tutuḵu ii doonna, ag kobol amu hep̱ig, ahilḵad iḵi danab ele anamib aaḵu. ");
INSERT INTO gaw_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","Kayak Nug anuḵa nuhiḵud propet oh oḏelagp̱a, nuhig Kristus, Nug guiṯak nau amu aoḵunu ana mehuqa aum. Nai amu niie uḏie, ag amu hep̱ig amu, amup̱a Kayak he, nuhig nai aaḵu meu oum. ");
INSERT INTO gaw_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","20","Amunu Kayak Nug ahilag hip̱unin op̱ieb, ag op̱ia awak daaglagnu, geha Kayak oo gamag ahak haen madaḵunu, Nug heeb, Kristus, Kayak Nug ahilag ehaniṯak daaḵunu tituanom ele amu, Nug uḏiḵunu, ag oolag eḏueg! Kayak Nug anuḵa laa tituanom ele amu, Nug am Jesus. ");
INSERT INTO gaw_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","Amu gemu Nug Kayaknu dayak aben anuqakp̱a daaṯe. Nug ap̱a dayaya, Kayak keeke oh eḏua bau heḵunu anuḵa maṯia, nuhiḵud propet, ag op̱ia awak ele amu, ag oḏelagp̱a Nug mehuqom, haen amu ameg meṯe. ");
INSERT INTO gaw_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","Nuhignu Moses nug inam aum. ‘Kayak, Naḏi ahilag, Nug geha ag lailag laa heeb aha, Nug propet ahilag daaḵu, da bia. Nug aḏi ab amu ag doyeg! ");
INSERT INTO gaw_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","Am danab ag propet amu, nuhig nai ii doonna, ag mauhḵulag. Ag Israel oolagp̱a baula ii daamna,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","Amu propet oh anuḵa nai mehuqp̱ig amu Samuelnup̱a dig mak, propet daaeg uḏiom amu ag oh haen gemu ihinigp̱a doum daaṯe imunu ap̱ig amu iiḵu ig anidṯem. ");
INSERT INTO gaw_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","Kayak Nug propet oḏelagp̱a aḏi beḵunu aum, nug Abraham ele tituana, keeke laa heeb beḵunu nai qaḵom ele amu, ag gemu daaṯeb, ag nai aḏit amu a meulah aoglagnu daaṯeb. Nai Nug Abraham amegp̱a qaḵa aum am inam. ‘Da hep̱i, na buḏunp̱a wan ohp̱an danab ag itiṯak aoglag,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","Amunu Israel danab, Kayak Nug nuhig uḏat danab otia he, Nug tatam ahilagp̱a ag itiṯak madaḵunu uḏiom. Nug heeb, ag oh aḵa anen anen ahilag eheḏ hak naup̱anu eḏun, Nug dim lamidḵulagnu heum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","2","Petrus Johanes ele a danab ah Jesusnu ip̱uanadyaya, nuhig g̱agaṯagp̱a danab mauhp̱ig ele ag eḏun hip̱aidḵulagnu ele mehuqeheh, mana meṯak danab amu mana meṯak lag gumaknu daup iḵilag amu ḏo gumak danab-Sadusi aḏi ele ag a nai madipiḏ amunu ahilahnu oolagp̱a aeg bak nau doyegeg, danab aḏit amu a nai amu maṯieheh, iḵi danab amu ag ahilahp̱a uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","Uḏin, tueb meum amunu ag aḏualatna, mani guiṯak oop̱a maateg, tuqan laip̱u daapiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","Ag anam hep̱ig amge danab ah kuḏum, a nai madipiḏ ele amu, ag nai amu doona, ag oolagp̱a genab doop̱ig. Amu haen amup̱a, oh ag oolagp̱a genab doop̱ig ele amu, ag oolagp̱anu danabnuib eb qak am 5,000 anam. ");
INSERT INTO gaw_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","Aria Petrus Johanes ele a mani guiṯak oop̱a daaeheh, wagḏe amu Juda dilag danab oḵai amu Juda iḵi danab am ḏo mehuqak danab ele amu ag uḏin, Jerusalem qag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","Am mana meṯak danab dilag iḵi Anas, amu Kaiapas, Johanes, Aleksanda amu danab laala ele, ag oh buḏub laip̱unu amu, ag laa qag mep̱ig ele amu, ag oh qag mena, ");
INSERT INTO gaw_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ag totol danab aḏit amu diiatna, ag heṯoḏiakp̱a maatna oḏ matap̱ig. “A g̱agaṯag aḏip̱a o a aun onigp̱a uḏat amu hepiḏ?” aon oḏ matap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","Aria ag anam aon oḏ mataegeg, Kayak Ouḏi Nug Petrus oop̱a am be, nug aha ag amelagp̱a aum. “Israel danab oḵai amu ag iḵi danab ele, ");
INSERT INTO gaw_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ag adeḵu? Gemu ag i danab baeg nau ele amegp̱a auḏ, nug ena dayom, amunutai iiḵu oḏ metaṯeb. ");
INSERT INTO gaw_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","Anam dayeb amu aria gemu ag oh tutuḵu doop̱eg am Israel buḏub oh ag ele amu inamib dooglag. Jesus Kristus, Nasaret ted, ag gemu daaṯeb imu, ag Nug ad emaitakp̱a atulp̱ig amge Kayak Nug he, eḏua hibaiṯom ele amu, Nug he, danab imu eḏua ena daya oiyeye, ag anidṯeb. ");
INSERT INTO gaw_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","Amu lag hak danab ag lagnu men anuqak daaḵunu, amu anidna uup̱ig bia ag gemu daaṯeb, ag Jesus anidna di medap̱ig amge Nug anuqak beum daaṯe. ");
INSERT INTO gaw_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","Wan imup̱an danab aun nug ig eḏua awiḵeb, ig hip̱unin waap̱a ii daamta? Iiṯa! Jesus Nug nuḵaib elele. Wan imu ohp̱a ig laa onigp̱a ehaniṯak amu aognignu iiṯa, Jesus nuḵa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","Juda dilag danab oḵai amu ag Petrus Johanes ele a ii baḏapiḏ anidna, amu a sul oḵai ii hepiḏ ele doona, ag dab mak kuḏum aop̱ig. Anam henana amu ag Petrus Johanes ele a Jesus ele oip̱ig amu dab mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","Ag dab meegeg, danab beḏu ena dayom amu nug Petrus Johanes ele ag oh hip̱aidna daaegeg anadna, ag a nai apiḏ amu eḏun nob meḵulagnu ib laa ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","Ag anam daanna amu ag Petrus Johanes ele, a Juda dilag heṯoḏiak oḵai, onig Sanhidren, lag oo amu a uuya, dimiṯim goḵulahnu aeg uḵaeh, ag aṯem heḵulagnu amu maṯina ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","“Ig danab aḏit umu am aṯemtai hatḵunig? Aḏinu? A kobol danab heḵunu elele iiṯa amu hepiḏ. A heeh, Jerusalem danab ah daaṯeb umu ag oh doon malap̱ig amunu ig a ii hepiḏ aot aḵunignu am elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","Amge danab laih laihnu ag doomnanu, ig danab aḏit imu a baula Jesus onigp̱a nai ii maṯimyanu ap̱ut doyeḏ!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","Ag anam awona, eḏun aeg waeh, ag a amelahp̱a ap̱ig. “A Jesus onigp̱a nai baula eḏui danab ah amelagp̱a iinab mehuqmaya! A baula iinab ip̱uanadmaya.” Ag a amelahp̱a g̱agaṯag anam ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","Ag amelahp̱a anam ap̱ig amge Petrus Johanes ele a apiḏ. “I Kayak nai imu uuḏa, ahilag nai dim lamidḵunih am Kayak Nug keeke amunu am ena awa aḵute? Ag tutuḵu anidna dab mak aweg!” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","A anam awoya am baula tuḏidya apiḏ. “I amu oḏenih qamutḵunihnu ele iiṯa. Aḏinu? I keeke oh amenihp̱a anidḏa, nuhig nai doomuḏ ele amu, ib laa iiṯa, mehuqḵunihnab,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","A anam aeh, aria danab oḵai ag a amelahp̱a nai g̱agaṯag ap̱ig amu, ag nai anam bia laala ele tuḏidna awona, ag danab ah oh ag Kayak keeke he anidna, amunu oolag gamag ahe, ag Nug binag mep̱ig anidna, ag danab ah amu diig amunu baḏap̱ig amunu ag Petrus Johanes ele guiṯak mataglagnu ib ii anidna, heeg gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","A aeh, Jesus he, danab eḏua ena dayom ele amu, nug nuhig maḏ 40 anam amunu danab ah ag Kayak binag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","Aria danab oḵai ag heeg, Petrus Johanes ele a goya, a lailti gumadya goya, mana meṯak danab oḵai amu iḵi danab ele ag heṯoḏiakp̱a nai ap̱ig amu oh aeh doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","Amu ag oh doona, baalag laip̱u mena, Kayak unuqidna inam ap̱ig. “Naḏi, na hab wan yu amu keeke oh agup̱a daaṯeb ele amu, keeke amu oh na hadme. ");
INSERT INTO gaw_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","Amu anuḵa na he, nahip Ouḏi Nug nai nahip imu ig alanig Dawit, nug am uḏat nid nahip amu, nug amegp̱a a doya, nug aum. ‘Amu aḏinu iiṯa aḏi danab ag Kayaknu oolagp̱a aeg bak nau dooṯeb? Aḏinu danab ah buḏub amu ag Nug eḏidḵulagnu qag men, nai hamu madiṯeb? ");
INSERT INTO gaw_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","Wanp̱anu oḵai oḵai ag Kayak amu laa Nug tituanom ele, ag a ele ban heḵulagnu bap̱aidna amu wanp̱anu oḵai laala ag bannu qag mep̱ig.’ ");
INSERT INTO gaw_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","Dawit nug aum bia amu ag genab anam hep̱ig. Herodes Antipas, Pontius Pilatus ele am iiṯa aḏi danab amu ag Israel ele, ag oh ab oḵai imup̱a qag mena, ag Jesus geḏidp̱ig, Nug am uḏat danab nahip, op̱ia awaknab ele. Na Nug anuḵa tituanme. ");
INSERT INTO gaw_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","Ag anam heḵulagnu qag mena anam hep̱ig amu, Kayak na keeke oh anam beḵunu anuḵa ib amunu ame amu ag amuib hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","Naḏi, danab amu, ahilag nai maṯiak ena iiṯa amu anṯe! Anidna amu nai ig, nahipad uḏat danab amu, na ig ehanigp̱e, ig baḏak iiṯap̱a nahip nai mehuqḵunig. ");
INSERT INTO gaw_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","Laa ele amu na Jesus, nahip uḏat danab op̱ia awak ele amu, na Nug onigp̱a ep̱en bahin, oḏe danab aḏaladp̱e, ag eḏun ena dayeg! Kobol danab heḵunu elele iiṯa amu na amu ele Jesus onigp̱a he!” aon unuqidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","Ag unuqidna, baag qeegeg, lag ag daap̱ig ele amu uḏalele, Kayak Ouḏi ag oolagp̱a am be, ag ii baḏana, Kayak nai mehuqp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","Ag anam aaḵu henana, oolagp̱a genab doop̱ig ele ag oh dab mak laip̱up̱a oolag laip̱u dayeye amu danab laa nug keeke ele amu nuhignuib ii aḏom. Iiṯa. Keekep̱a amu ag nug ehaniṯeg ");
INSERT INTO gaw_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","amu totol danab tuelp ag Naḏi Jesus eḏua hibaiṯomnu nai amu g̱agaṯag ele mehuqegeg, Kayaknu ehaniṯak oḵai hamu megṯe ele amu, ahilagp̱a oḵai dayom. ");
INSERT INTO gaw_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","Anam dayeye, ag oolagp̱a danab laa nug keekenu, enu ele tutu mak hamu ii dayom. Iiṯa. Danab laala ag wan o lag ele, ag aeg, danab laa daden meeg, men doḏo amu aon uḏin, ");
INSERT INTO gaw_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","totol danab tuelp maṯaegeg, ag otin, danab laala elele iiṯa amu madap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","Ag anam heegeg, danab laa ap̱a dayom, nug onig Josep, nug am Lewi buḏub, Saipras ted. Nug onig Josep amge danab tuelp ag am nug onig Banabas ataḏp̱ig. Onig amu diig eḏuak amu inam, heeb oolag g̱agaṯag qak danab. ");
INSERT INTO gaw_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","Aria danab amu nug wan laih nuhig he, danab laa awe, nug men doḏo amu awa uḏia, totol danab maṯom. ");
INSERT INTO gaw_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","Amu danab laa onig Ananias, nug wau onig Sapira, nug wan laih me, danab laa awe, nug men doḏo awa, ");
INSERT INTO gaw_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","nug otia laih amu nuhig maama, nug men doḏo laih amu awa uḏia, totol danab tuelp maṯa, “Wan dahilnu nob oh iiḵu,” awa aum. Nug wau ele oh a totol danab anam ham bup̱ualadḵulahnu oolah laip̱u dayom. ");
INSERT INTO gaw_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","Nug anam a amu Petrus nug aum. “Ananias, aḏinu Satan na ootp̱a am be, na Kayak Ouḏi amegp̱a ham bup̱uak nai maṯinna, ‘Da wan mei, laa nug daden me, men doḏo aomi amu oh iiḵu,’ ame amge na laih nahip daaḵunu loḵumna, laihib aon uḏime? ");
INSERT INTO gaw_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","Na tatam wan amu laa aoḵunu ii meeme amu naḵa nahip dayom. Am dimp̱a na ae, daden meeg, men doḏo amu ele nahipib. Amu aḏinu na kobol amu heḵutnu ootp̱a dab meme? Na heme amu danab ii bup̱uidme. Iiṯa. Na Kayak amegp̱a ham bup̱uak nai maṯime,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","Aria Ananias nug Petrus nai aum amu doya, nug na qa mauhe, danab oh ag amunu nai doona amu ag huan baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","Aria nid bau ag ahan dona, lamen laap̱a beḏu hautna, aon gona boomp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","Amu aam ameg ewam uḵe, Ananias wau nug uḏia, lag oop̱a noum. Nug amunu nai laa ii doyom. ");
INSERT INTO gaw_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","Nug no, Petrus oḏ meṯa aum. “Na ap̱e doyei! Aṯemu? A wannu daden nob amu elele iiḵuibte?” awa aum. A am ah nug aum. “Amu aaḵuib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","Ah nug anam a, Petrus nug amegp̱a aum. “Amu aḏinu a oh nai laip̱u maṯiya, a Naḏi Ouḏi, Nug ahilah eheḏ hak amunu nob mataḵu o iiṯa anidḵulahnu heya eeḏpiḏ? Doye, danab ag na gamut boomona dop̱ig, ag odp̱a hip̱aidp̱ig daaṯeb, geha ag na ele boomidḵulagnu mawidḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","Petrus nug anam aawo, ah amu laip̱un nug baegp̱a na qa mauhe, nid bau ag lag oop̱a nona, ah mauhom anidna, ag aon maon gona, gamu boomp̱igp̱a ou qen boomp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","Amu kobol amu be, kristen tamaniak oh amu danab ag keeke amunu nai doop̱ig ele, ag ele huan baḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","14","Aria haen amup̱a totol danab tuelp, kristen tamaniak amu abp̱an danab laala ele ag hanhan mana meṯak lagnu aḏ oop̱a, aben laa Solomonnu aben aṯeb, amup̱a qag medap̱ig. Qag menan oinna, totol danab tuelp ag abp̱an danab oolagp̱a ep̱onak keeke, danab heḵunu elele iiṯa kuḏum diigdiig ele hep̱ig. Ag anam qag mena oip̱ig amge Juda laa ag, ag ele qag meḵulagnu uup̱ig. Ao, Juda laa ag, ag ele oh qag meḵulagnu uup̱ig amge abp̱an danab ag kristen tamaniaknu oolag enaib dayom. Ag oolagp̱a ena dayeye, danab ah ele kuḏumnab ag Jesusnu oolagp̱a genab doona, ag kristen tamaniak oop̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","Aria totol danab tuelp ag uḏat danab heḵunu elele iiṯa heegeg, danab laala ag oḏe danab amu qaḏaqaḏp̱a aḵan uḏin, ib daugp̱a maaṯeg niip̱ig. Amunu diig am Petrus oiyebeb amu nuhig itotog amu oḏe danab qaḏelagp̱a uḵeb, ena daaglagnu oolag dayom. ");
INSERT INTO gaw_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","Ag anam heegeg amu danab ah, ab laala Jerusalem guguiṯak daaṯeb, ap̱an ag ele ahan, danab oḏe ele amu danab ouḏi nau ele aḵan uḏiegeg amu ag oh eḏun ena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","Ag anam heegeg amu mana meṯak danab dilag iḵi amu nuhiḵud ehaniṯak danab laala, ag am ḏo gumak danab-Sadusi oolagp̱anu, ag oolagp̱a aeg bak nau doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","Ag anam hena ahan, totol danab tuelp aḏaladna, mani guiṯak oḵai amup̱a maadp̱ig ");
INSERT INTO gaw_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","amge tuqan amup̱a Naḏinu engel nug mani guiṯak lag od matula he, dimiṯim doeg, nug amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“Ag eḏun gona, mana meṯak lag oop̱a nona, danab ah amelagp̱a kristen bau oiyaknu diig, amunu mehuqp̱eg doyeg!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","Engel anam a amu wagḏe buṯuanab totol danab tuelp ag ahan gona, mana meṯak lag oop̱a nona, danab ah amelagp̱a engel aḵulagnu aum ele amu, ag nai amu danab ah ip̱uanadp̱ig. Amu totol danab tuelp ag mana meṯak lag oop̱a daaegeg, mana meṯak danab dilag iḵi amu nuhiḵud ehaniṯak danab ele ag qag mena, Juda dilag heṯoḏiak oḵai, onig Sanhidren, amunu danab amu Israel dilag iḵi danab oh onilagp̱a eeg, ag uḏieg amu ag ahilag daup ag mani guiṯak laḵa gona, totol danab tuelp diin uḏiglagnu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","Ag aeg, daup ag mani guiṯakp̱a gop̱ig amge totol danab tuelp ag ap̱a ii daap̱ig anidna amu ag eḏun qag mep̱igp̱a gona, ag keeke aṯem aṯem anidp̱ig amu aeg doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","Ag inam ap̱ig. “Ig gota, mani guiṯak lag amu od lok g̱agaṯag aqak daaegeg, daup ag od oh gumap̱ig anidmut. Aria ig od matulmut amu ig lag oop̱a danab laa daaegeg ii anadmut,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","Anam aeg doona aria mana meṯak danab dilag iḵi amu daup iḵi ele ag dab mak kuḏum aonna ap̱ig. “Keeke aṯemtai laa ana daaḵutai,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","Amu ag anam maṯiegeg, danab laa uḏia amelagp̱a aum. “Doyeg! Danab ag mani guiṯakp̱a inadp̱ig ele amu, ag mana meṯak lag oop̱a, Jesusnu nai danab ah ipuanadṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","Danab amu anam a doona, daup iḵi amu daup ele ag gona diip̱ig amge ahilagnu eheḏ laa ii hep̱ig. Aḏinu? Ag baḏan inam ap̱ig. “Ig ag maḵuḏadp̱ut amu danab ah ag ig menp̱a iqaglag,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","Ag anam anana, diin uḏin heeg, heṯoḏiak oḵai, onig Sanhidren, amup̱a hip̱aidna daaegeg, mana meṯak danab dilag iḵi nug amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“Amu ig ag amelagp̱a ag Jesus onigp̱a nai baula danab ah iinab ip̱uanadmananu amut. Aḏinu ag amu anam heegeg, danab ah oh Jerusalem daaṯeb ele aaḵu doop̱ig. Amu ag danab ag ihinignu amu, ‘Jesus Nug danab ena, ag qeeg mauhom,’ aon aḵulagnu heṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","Nug anam a amu Petrus nug totol danab tuelp ele ag oh eḏun ap̱ig. “Ig am Kayaknu nai amu dim lamidḵunig. Danabnu nai amu ig ii dim lamidmata. ");
INSERT INTO gaw_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","Amu ag Jesus ad emaitakp̱a atulna qeeg mauhom amu ig alanignu Kayak Nug he, eḏua hibaiṯom. ");
INSERT INTO gaw_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","Nug am King amu ihinig ehaniṯak daaḵunu, Nug ihinig gamag danab amunu Nug heeb, ig Israel ig oonig eḏueb, Kayak Nug hip̱unin ihinig uhuqa megaḵunu amu Kayak he, Nug eḏua hibaiṯa, aṯan ta, Nug Kayak ep̱eg naḏiapp̱a, amuam anuqak aben, amup̱a daaṯe. ");
INSERT INTO gaw_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","Amu ig keeke amu ohnu nai mehuqak danab daaṯem. Kayak Ouḏi ele nai amunu mehuqa aṯe. Kayak Nug danab ah ag nai nuhig dim lamidṯeb amu nuhig Ouḏi madaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","Ag nai amu aeg doonna, ag oolagp̱a aeg naunab be, totol danab tuelp aqap̱eg mauhḵulagnu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","Ag anam heḵulagnu ap̱ig amge Juda dilag heṯoḏiak oḵai, onig Sanhidren, amunu danab laa aha hibaiṯom. Nug am ḏo gumak danab-Parasia onig Gamaliel. Nug danab ah ḏo ip̱uananadṯom amu ag nug binag humap̱ig. Nug aha, ag amelagp̱a totol danab tuelp ap̱eg, nakok dimiṯim goḵulagnu aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","Nug a, ag heeg, dimiṯim uḵaeg, nug heṯoḏiak oḵainu danab laa daap̱ig amu amelagp̱a aum. “Ag Israel danab, ag kobol aḏi danab imu dilag heḵulagnu heṯeb amu ag dab meig! ");
INSERT INTO gaw_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","Aḏinu? Ag imu dooṯeb. Matu haen Tiudas nug aha, ‘Da danab oḵai,’ anana nug nuḵa binag ma, ham bup̱ualaṯa he, danab 400 ag ahan dim lamidp̱ig. Amge gabman nug Tiudas qe mauhe amu danab ag nuhignu oolagp̱a genab doop̱ig ele amu, ag ele gona qeṯoḏeg, nuhig uḏat aaḵu iiṯa meum. ");
INSERT INTO gaw_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","Amu Tiudas onig iiṯa me, nug heum bia haen gabman nug danab ah onilag awewe, Galelia ted Judas nug aha, danab ah laala biilagp̱a ya he, ag nug dim lamiṯeg gona, Rom dilag gabman lamidḵulagnu ban hep̱ig. Amge nug ele qe mauhe amu danab oh nug diie oip̱ig ele amu ag matatun gona, hamu oip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","Ig amu anam anidmut amunu da ag amelagp̱a aṯem. Ag danab umu amu, ag uuadp̱eg dayeg! Uup̱eg, ag daanna hebep̱eg, keeke amu diig am danabnu dayeb amu, geha na qeeb, iiṯa meḵu. ");
INSERT INTO gaw_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","Amge genab Kayak Nug keeke amu he beṯe amu ag Nug ip̱u oo neḵulagnu am elele iiṯa. Ag anam hena amu ag aaḵu Kayak ele ban heḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","Gamaliel nug anam a, ag nuhig nai dim lamidna, totol danab tuelp ii aqap̱ig amge ag diin, bup̱a eheḏ mataḏaṯona, nai Jesus onignu amu ii maṯimnanu g̱agaṯag amelagp̱a awona, heeg gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","Ag anam heeg, totol danab tuelp ag Juda dilag heṯoḏiak oḵai, onig Sanhidren, amup̱anu dimiṯim gona, ag oolag gamag ahehe, ena doona, inam dab mep̱ig. “Ig Jesus onignu uḏanak guiṯak ele aomut amuam ena,” Ag anam dab mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","Ag anam awona, deḏ oh ag mana meṯak laḵa amu danab ah laulagp̱a ele oina, Jesus Nug am Kristus, amu mehuqnana ip̱uanadp̱ig. Ag Nai Ena amu mehuqḵulagnu ii uup̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","Ag Jesus Kristusnu Nai Ena amu mehuqegeg, haen amup̱a danab kuḏum Jesusnu oolagp̱a genab doyegeg, ameg amu tuḏiṯegeg, oḵai meum. Anam beebe, ag oolagp̱a ameg laa, ag Grik nai dooṯeb ele amu, ag ahan, ameg laa Hibru nai dooṯeb ele amu, ag ele aeg ona aeg do amelagp̱a ap̱ig. “Ag deḏ oh uḏat imu tip̱alṯeb. Ag ah qab ahilḵad, ag e iiṯa ele amu, ag e madaṯeb amge ag ihinḵad ah, qab daaṯeb amu, ag ii ehanadṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","Anam daye, totol danab tuelp ag aeg, danab Jesusnu oolagp̱a genab doop̱ig ele amu ag oh uḏin, qag meeg, amelagp̱a ap̱ig. Ig Kayak nai maṯiak uḏat ii uumta. Ig anam heḵunig am Kayak noobp̱a ena iiṯa ");
INSERT INTO gaw_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","amunu o lainḵad, ig inam, heḵunig. Ag oh oolagp̱anu ag danab eblaih aḏit laa, danab ah ag danab amunu eheḏ laa ii aṯeb, ag Kayak Ouḏi aop̱ig, ahilag doyak ele am ena amu, ag danab eblaih aḏit amubia anaṯeg! Danab amu ig uḏat amu madap̱ut, ag heḵulag. ");
INSERT INTO gaw_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","Amge ig totol danab amu, ig hanhan unuqidtata, Kayak nai amu danab ah ip̱uanadḵunig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","Ag anam aeg, danab ah oh ag nai amunu oolag laip̱u daye, ag danab otiadp̱ig. Ag otiadp̱ig ele amu ag onilag am Stepanus, nug oop̱a genab doyak nuhig am g̱agaṯag, Kayak Ouḏi nug oop̱a am bak ele. Aria laa am Pilip amu laa am Prikoras, laa Naikena, laa am Timon, laa Pemenas, amu laa am Nikolas. Nikolas nug am Antiok ted amu nug Juda dilag meṯid dim lamiṯom. ");
INSERT INTO gaw_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","Ag danab amu otiadna heeg, totol danab tuelp noolagp̱a hibaiṯeg, ag ep̱elag qaḏelagp̱a mena, ahilagnu unuqidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","Ag Kayak nai mehuqegeg, danab ah kuḏum ag oolagp̱a genab doop̱ig. Jerusalem ap̱a danab kuḏum ag oolagp̱a genab doona, kristen tamaniak oop̱a uḵaeg, nuhig eb qak oḵai meeme, mana meṯak danab kuḏum ele oolag eḏuom. ");
INSERT INTO gaw_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","Amu Kayak Nug Stepanus ehaniṯak oḵai ele meṯe, nug ep̱onak keeke danab heḵunu elele iiṯa amu danab ah oolagp̱a heum ");
INSERT INTO gaw_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","amge danab laala ag ahan, Stepanusnu nai nau ham bup̱uak beḏup̱a yaan aegeg, nug ag ele nai aeg ona aeg doum. Danab amu ag am Juda dilag nai doyak laḵa, ag lag amunu, Danab Begbeg Iiṯa aṯeb ele amu, amup̱a ag Kayak nai doodp̱ig. Danab amu ag am Sairini, Aleksandria, Silisia, Asia elenu uḏiak. ");
INSERT INTO gaw_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","Am Kayak Ouḏi Nug doyak ena Stepanus meṯa he, ag nuhig nai eḏidna, tabap̱eg noḵunu elele iiṯa. ");
INSERT INTO gaw_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","Ag anam anidp̱ig amunu ag kobol ham bup̱uakp̱a hena, danab laala eeḏaṯeg, ahan ap̱ig. “Ig nug, Moses Kayak ele dabata, awa awa aqatete doomut,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","Ag anam ham bup̱ueg, danab ah amu, Juda iḵi danab amu ḏo mehuqak danab ele ag oṯaina, Stepanusnu eheḏ doop̱ig. Eheḏ doyeg, danab ag Stepanus ele nai aeg ona aeg doum ele amu, ag gona, nug aḏan, aon Juda dilag heṯoḏiak oḵai, onig Sanhidren, ap̱a gona, ");
INSERT INTO gaw_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ag qag mak amup̱a heeg, danab laala ag oolagp̱anu ahan, Stepanusnu nai ham bup̱uak inam aon ap̱ig. “Danab imu nug hanhan lag imunu, ḏo nai elenu nai eheḏ madiṯe. ");
INSERT INTO gaw_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","Amu nug maṯiaya, inam aawo ig doomut. ‘Jesus, Nasaret ted, geha nug ab imu heeb nauheb, anuḵa Moses nug kobol ig meḵom amu ele Nug eḏuḵu,’ awa aum,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","Ag anam ham bup̱ueg, danab heṯoḏiak oḵai, onig Sanhidren, ap̱a daap̱ig, ag oh Stepanus neeḵidna, ag nug iḏu engel bia anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","Anam anidna amu mana meṯak danab dilag iḵi nug Stepanus amegp̱a aum. “Nai ap̱ig umu am genabte?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","Amu Stepanus nug mehuqa amelagp̱a aum. “Da lailad mamelad ele ag doyeg! Anuḵa ig alanig Abraham nug Mesopotemia dayaya, nug Haran ii uḵom, haen amup̱a Kayak, nuhig amahlak enanag ele, nug gumiṯa noa, amegp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘Na ahan, wan nahip imu uuna, laipad ele uuadna amu, wan laa da na ip̱unidḵul amup̱a uḵe!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","Kayak aum amu Abraham nug Kaldia wan uua, aha uḵa, Haran dayom. Ap̱a dayeye, dimp̱a mameg mauhe amu Kayak Nug he, aha Kanan wan, gemu ag daaṯeb ele imu, igup̱a uḏiom. ");
INSERT INTO gaw_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","Amu Kayak Nug wan imup̱a laih nakok laa Abraham ep̱egp̱anab daaḵunu ii meṯom amge Kayak Nug dimp̱a wan amu Abraham amu nug buḏub ele madaḵunu nai qaḵa aum. Amu haen Abraham nug nid iiṯa oiyeye, Kayak Nug nai amu amegp̱a qaḵa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","Amu Kayak Nug inam amegp̱a aum. ‘Na buḏunad ag geha danab buḏub laa dilag wanp̱a daap̱eg amu buḏub laap̱an amu ag geha hep̱eg, na buḏunad ag ahilag begbeg maḏ 400 daap̱eg, ag eheḏ hadḵulag,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","Nug anam anana am Kayak Nug tuḏiṯa ele aum. ‘Geha dimp̱a da danab ah amu, ag na buḏunad, ag ahilag begbeg uḏat heḵulagnu aḏaladḵulag amu, da ag kobol nau amunu nob madaḵul. Aria da anam hep̱i, dimp̱a amu na buḏunad ag wan amu uun uḏin, wan imup̱a amu geha ag da unuqilnana, binal meḵulag.’ Kayak Nug anam awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","Amu Kayak Nug Abraham tituana, amegp̱a nai qaḵa anam awowa, dimp̱a Nug tituanak amunu ḏo laa Abraham meṯa, Abraham amu nug buḏub ele ag oh gaḏalag otaḏadḵulagnu aum. Kayak aum amunu dimp̱a Abraham nug beḵa Isak menua, deḏ eblaih ewamp̱a gaḏa otaḏom. Aria Isak nug Jakop menua, gaḏa otaḏe, Jakop nug dimp̱a beḵod tuelp menuaṯa, gaḏalag otaḏom. ");
INSERT INTO gaw_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","Aria ig alanḵad ag Josepnu oolag aeg be, ag nug aon, danab laa maṯaeg, men doḏo maṯanna, ag aon, Igipta gop̱ig amge Kayak Nug Josep dab medeṯe ");
INSERT INTO gaw_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","Josep nug ug diigdiigp̱a dayeye amup̱a ele Kayakib ehaniṯom amunu haen nug Igipta dilag king ele nai maṯieheh, Kayak Nug doyak ena Josep meṯom amunu king nug Josepnu oo daye, awa me, Igipta dilag gabman anuqak dayaya, king laugp̱anu keeke oh amu gumama, nug kingib waap̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","Anam dayeye, dimp̱a Igipta wanp̱a amu Kanan wanp̱a ele enug haen be, ag ug oḵai anidna amu ig alanḵad aḏi ag e laa aon laḵulagnu iiṯa ");
INSERT INTO gaw_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","amge ag aeg, Jakop nug, ‘Igipta ap̱a e daaṯe,’ doyom. Aria nug he, alai aḏi ag e daden meḵulagnu Igipta gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","Amu dimp̱a ag eḏun uḵaeg, Josep nug awaḵud amag ele noolagp̱a nuḵa miag, ‘Da am Josep,’ aum. Nug anam he amu haen amup̱a Paro nug ag am Josep awaḵud doyom. ");
INSERT INTO gaw_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","Paro anam doye, Josep nug mameg Jakop, Jakop baeḵudp̱a ele oh, danab ah amu eb qak ahilag amu 75, ag nug gumidna goḵulagnu aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","Aria Jakop nug noa, Igipta dayeye amu dimp̱a nug amu nug beḵod ele ag oh mauhadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","Ag mauhaṯeg, gaḏalag amu eḏun aḵan gona, Sikem matmatp̱a boomadp̱ig. Anuḵa Abraham nug silwa men doḏop̱a wan amu Hamo buḏub, danab amu ag ep̱elagp̱anu awom. ");
INSERT INTO gaw_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","Amu Kayak Nug anuḵa nai Abraham amegp̱a keeke laa heḵunu nai qaḵa aum amu haen amu aaḵu beḵunu miag doodo, Israel ag ap̱ategeg, agib Igipta wan am beḵunu heum. ");
INSERT INTO gaw_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","Amge amu ii nak haenp̱a Igipta dilag king ag benana, Josep nug Igipta wan ena gumom, kaya amu ag doop̱ig. Anam daye uḵe, Kayak keeke heḵunu aum, haen amu miag do amu danab laa ba, king dayom. Nug am Josep uḏat ena heum, kaya amu ii doyom ");
INSERT INTO gaw_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","amunu nug ig lainḵad ag nuhig uḏat hena, nugib ehanidḵulagnu ha, uḏatp̱a ug maṯom. Nug ig alanḵad dilagp̱a kobol nau eheḏ g̱agaṯagnab he, ahilḵad nid naunau bau amu uuadp̱eg, dimiṯim daana mauhḵulagnu wagai ma aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","Ag ug nau amup̱a daanna, haen amup̱a Moses anig nug menuom. Nug Kayak noobp̱a nid ena daye amu nug anig mameg ele a kalam ewam anam laḵa loḵumeh dayom. ");
INSERT INTO gaw_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","Anam loḵumeh daye, dimp̱a nug nakok oḵai me, a ub nakok itai, aoya lep̱a meeh dayeye amu King aḏeg nug anṯa awa, nuhig nid bia gumom. ");
INSERT INTO gaw_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","Anam he, Moses nug oḵai ma amu Igipta dilag doyak amu oh doya malowa, nug danab, nuhig nai maṯiak amu nuhig uḏat ele am g̱agaṯag, anam dayom. ");
INSERT INTO gaw_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","Dimp̱a Moses nug maḏ nuhig 40 dayeye amu nug laiḵud Israel anadḵunu dab mak awa, aha oiyaya, ");
INSERT INTO gaw_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","amu Igipta ted laa aha, Israel laa eheḏ hedeṯe anṯa, nug Israel ted amu ehaniṯa, Igipta ted heum amu Moses nug nob ma, Igipta ted amu maḵuḏe mauhom. ");
INSERT INTO gaw_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","Am nuhig dab mak am inam dayom. ‘Da hep̱i, da lailad ag da aniḏna ag, “Kayak heeb, Moses nug geha ig ehaniḵeb, ig baula nau ii daamta,” aon aḵulag.’ Nug dab mak amu awom amge Israel ag dab mak anam ii aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","Nug anam he, wagḏe deḏ amup̱a Moses nug eḏua oiyaya amu Israel danab aḏit laa a nug qeeheh anata, uuglahnu amelahp̱a inam aum. ‘A diig laip̱u amu aḏinu a anam nug guiṯak meṯaya heṯep?’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","Moses nug uuglahnu aum amge danab aha layag maḵuḏom ele amu, nug aha, Mosesnu nai otaḏa aum. ‘Aun na ig gumignana, ihinig ug bap̱aidḵutnu meiṯe, na uḏin aṯem? ");
INSERT INTO gaw_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","Na tumai Igipta ted maḵuḏe mauhom bia da oiḏp̱e mauhḵulnu heṯemte?’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","Nug nai amu a amu Moses aaḵu oola uḵa, Midian dilag wanp̱a ḏo danab dayaya, dimp̱a ah awa, nid danab aḏit menuatom. ");
INSERT INTO gaw_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","Ap̱a dayeye, maḏ 40 uḵe, atu taḏakp̱a engel laa qauko Sinai guguiṯak ap̱a gumiṯa neum. Ab aḏu amu ad nakok laap̱a ewewe, engel nug ab ewom amu oop̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","Moses nug ab ewak amu anṯa, nug oo ii maiṯe, dab mak kuḏum awa, nug peheṯa anidḵunu gumiṯa waawo, Naḏi Nug aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","‘Da am na alanad dilag Kayak. Da amu Abrahamnu Kayak, Isaknu Kayak, Jakopnu Kayak,’ awa aum. Awa a, Moses nug oṯaiya baḏa, Kayak anidmanu ii neeḵom. ");
INSERT INTO gaw_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","Anam dayeye, Naḏi Nug amegp̱a aum. ‘Na hip̱aidna daaṯem, wan amuam gun ele amunu na baen gaḏa amu uḏe! ");
INSERT INTO gaw_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","Da Igipta danab, ag dahilad danab Igipta daaṯeb ele amu, ahilagp̱a kobol eheḏ huanak heegeg anaṯe, danab dahilad dilag qanak ele dooṯem amunu da ag ehanaṯena, ahilag ug amu aotḵulnu nemi. Amu na ahan eḏun Igipta uḵe!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","Moses nugib aaḵu, anuḵa ag nug guhuḏidna, ‘Aun nug na ig gumignana, ihinig ug bap̱aidḵutnu meiṯe uḏime?’ aon ap̱ig, danab amuib aaḵu Kayak awa, gumak danab mewowa he, Israel diiḵunu uḵom. Kayak he, engel nug ad nakokp̱a, ab ewak oop̱a ba, Moses anam heḵunu aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","Amu Moses nug danab amu ag Igiptanu omalaṯa goḵunu haaha, nug kobol danab heḵunu elele iiṯa diigdiig heum. Nug omalaṯa ugaḵa, nug le kokoḏp̱a amu atu taḏakp̱a ele, maḏ 40 batak anamib heum. ");
INSERT INTO gaw_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","Amu Moses nugib nai imu Israel amelagp̱a aum. ‘Kayak Nug geha ag oolagp̱anu lailag laa heeb, nug propet, da bia, beḵu,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","Moses nugib dimp̱a Israel ele oh ag atu taḏakp̱a, Sinai qaukop̱a qag mena amu nug engel amu, ig alanḵad ele dilag gamag danab dayeye, Engel nug Kayak nai bau dayaknu amu meṯe, nug awa, ag maṯom. ");
INSERT INTO gaw_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","Amge ig alanḵad ag Moses nug nai aum amu doyaknu uup̱ig. Ag nug guhuḏidnana, ag eḏun Igipta goḵulagnu amu oolag guaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","Ag anam henana, ag Aron amegp̱a ap̱ig. ‘Na ihinig kayak laala doṯolag hena megap̱e, ig omaigḵulag. Moses nug Igiptanu aiḵa omaiḵe uḏimut amu adebtag uḵom, ig ii dooṯem?’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","Aria ag anam anana, haen amup̱a ag makau nag doṯog laa hena, ag doḏ main kayak ham bup̱uak amu meṯanna, ag ep̱elagp̱a keeke hep̱ig ele amunu ag gamalag ahe, nuhig hobul oḵai hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","Ag anam heeg, Kayak Nug heqo maṯa, ‘Ag eheḏ heḵulagnu oolag dayeb amu uuadp̱ut heig!’ awa aum amu ag kalam hoḏop̱ai ele amu unuqidnana, propet dilag naip̱a, nai daaṯe bia hep̱ig. Nai amuam inam. ‘Israel ag anuḵa atu taḏakp̱a maḏ 40 daanna, ag bulmakau, sipsip ele aqan mana meṯak hep̱ig amu dahil mana meṯak hep̱igte? Iiṯa! Ag dahil ii hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","Ag kayak ham bup̱uak Molok, nuhig sel lag am kayak ham bup̱uak Repannu hoḏop̱ai ele aon oip̱ig. Ag keeke amu doṯolah hena, binalah mep̱ig. Ag anam hep̱ig amunu geha da ag diien, maadp̱i gona, laih Babilon eḏiṯak up̱a mani guiṯak daaglag,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","Aria amu ig alanḵad anuḵa ag atu taḏakp̱a daap̱ig amu haen amup̱a ag meṯid lag doḏ gaḏap̱a hena, oop̱a amu men tapel ḏo nai yak ele amu meeg dayeye, Kayak nug amahlak oḵai ele noa amup̱a dayaya, nai maṯom. Ag lag hep̱ig, amu heḵulagnu doṯog amu, Kayak Nug Moses ip̱uniṯom, amubia hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","Dimp̱a Josua nug ig alanḵad ag diie, Kanan wan imup̱a uḏiegeg, Kayak Nug danab wan imup̱a daap̱ig ele amu lamaṯe, haen amup̱a doḏ gaḏa meṯid lag amu ag maon, uḏieg dayeye uḵe, dimp̱a Dawitnu haen batak. ");
INSERT INTO gaw_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","Amu Kayak, Nug Dawitnu oo daye, Dawit nug Kayak, Nug am Israel dilag Kayak, Nug laug heḵunu unuqiṯom. ");
INSERT INTO gaw_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","Amge nug ii heum. Iiṯa, nug beḵa Solomon nug amu heum. ");
INSERT INTO gaw_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","Amge Kayak aṯannab, onig ele, Nug lag danab heṯeb amup̱a ii daaṯe. Amu propet laa nug nai amunu maṯiom am inam. ");
INSERT INTO gaw_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","‘Naḏi Nug inam aṯe. Hab amu dahil dayak aben, wan amu bael meḵulnu balal nakok. Ag lag aṯemnab laa dahil hep̱eg daaḵul? Aben aṯenp̱a geha da daye hik aoḵul? ");
INSERT INTO gaw_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","Keeke amu oh da ep̱elp̱a hein malami.’ Kayak Nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","Aria Israel ag am tap̱e nak danab, ag oolag daulag ele amu iiṯa aḏi danab bia amunu ag alalḵad hep̱ig amubia ag hanhan Kayak Ouḏi di medṯeb. ");
INSERT INTO gaw_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","Amu propet aun laa dayom, ag alalḵad ag nuhigp̱a kobol eheḏ laa iite hep̱ig? Laa iiṯa. Anuḵa propet ag Danab Tutuḵu uḏiḵunu nai amu mehuqegeg, ag alalḵad ag aqaeg mauhp̱ig. Aria Danab Tutuḵu Nug uḏie, ag gemu daaṯeb amu ag Nug aon, kekeḏ ep̱elagp̱a mena, heeg mauhom. ");
INSERT INTO gaw_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","Kayaknu ḏo nai amu engel nug ag maṯom amge ag amu dim ii lamidṯeb.” Stepanus anam aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","Am Stepanus nug nai amu aum amunu ag oolag ye, guaṯe, oolag nauhe, op̱oḏilag huan be, amelag kokoḏ ep̱e, Stepanusnu aelag kikidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","Ag anam hep̱ig amge Kayak Ouḏi amu Stepanus oop̱a am be, tutuḵunab hab aṯan neeḵa, Kayaknu amahlak enanag kobol kobol ele hab abp̱a andaṯa, Jesus Nug Kayak ep̱eg naḏiapp̱a, amuam anuqak aben, amup̱a Nug hibaiṯa dayeye anṯom. ");
INSERT INTO gaw_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","Anṯa Stepanus nug aum. “Anṯeg! Da hab obate, Danab Beḵalag Nug Kayak ep̱eg naḏiapp̱a, amuam anuqak aben, amup̱a hibaiṯa dayeye anidṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","Nug anam a, ag doona, ag huanaknab enana, daulag itun, ag oh ahan qaibaḏ wana Stepanus aḏap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","Ag aḏan aon, ab oḵai amu dimiṯim gona, ag menp̱a nug maḵuḏp̱ig. Tatam danab ag nug beḏup̱a nai yaap̱ig ele amu ag ahilag ulahnu lamen amu uḏan, nid bau laa gumaḵunu medap̱ig. Nid amu onig Saul. ");
INSERT INTO gaw_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","Ag men aon, Stepanus maḵuḏegeg, Stepanus nug unuqiṯa aum. “Naḏi Jesus, da ouḏil na ep̱enp̱a awe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","Nug unuqiṯa anam awowa, nug gateg qaun wa, nug huana ewa aum. “Naḏi na ahilag hip̱unin imu aib nob meme.” Stepanus nug anam ewowa, nug mauhom. ");
INSERT INTO gaw_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","2","Stepanus menp̱a maḵuḏeg mauhe, Saul nug amunu oo ena dayeye amu danab laala Kayaknu oolagp̱a genab doop̱ig ele ag Stepanusnu oolagp̱a ug naḏi doona, gaḏa amu aon gona boomp̱ig. Ag Stepanus boomeg, haen amup̱a Juda dilag oḵai ag ahan dig mena, kristen tamaniak Jerusalem dayom amu heeg, nauha auta awom amunu kristen ag ahan, matatun gona, Juda Samaria ele oop̱a daap̱ig. Amu kristen ag amu ahan gop̱ig amge totol danab tuelp ag am Jerusalem ii uup̱ig, ag daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","Amu Saul nug aha, kristen tamaniak heeb iiṯa meḵunu ug madaṯa, nug uḵa lag lag oiyaya, kristen danab amu ah ele diia uḵa, mani guiṯakp̱a inaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","Anam heehe, kristen ag oolna, matatun ab laalap̱a gona daanna, ag Nai Ena amu mehuqp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","Amu kristen ag anam heegeg, uḏat danab laa onig Pilip nug ab oḵai laa onig Samaria, ap̱a noa, ap̱a nug Kristusnu Nai Ena amu mehuqom. ");
INSERT INTO gaw_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","Nug Kristusnu Nai Ena mehuqeqe, danab ah kuḏumnab ag nai amu doonna, nug kobol danab heḵunu elele iiṯa amu ele haṯeṯe anidna, ag Pilip nai mehuqom amu elele aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","Ap̱an danab ah kuḏumnab ag ouḏi nau ele daap̱ig amu, ouḏi nau ag huan enana, ag uuadna dona uḵaegeg amu danab kuḏumnab beḏulag mauhak, amu baelḵad nau ele ag eḏun ena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","Amunu ab oḵai amup̱anu danab ah ag anam anidna, ag oolag gamag huana ahom. ");
INSERT INTO gaw_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","Ag oolag anam gamag ahehe amu danab laa ab oḵai amup̱a dayom, nug onig Saimon. Anuḵa nug am onig awak, baḏ mak kobol heehe, Samaria danab ah oh ag nuhignu dab mak kuḏum aoegeg, nug nuḵa binag ma, “Da am danab oḵai,” aṯom. ");
INSERT INTO gaw_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","Nug anam aawo, danab ah laala onilag ele, laala onilag iiṯa ele, ag oh Saimonnu nai dooglagnu ii daye daye, wagai mena ap̱ig. “Ig g̱agaṯag laa, g̱agaṯag amunu amu ig, ‘G̱agatag oḵai,’ aot aṯem, g̱agaṯag amu Kayaknu uḏiṯe ele amu, danab umu nug g̱agaṯag amu aaḵu awom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","Ag anam anana, nuhig nai amu dim lamidḵulagnu am hik aqom. Aḏinu? Haen elabnab nug nuḵa nuhig ham bup̱uak kobol laap̱a, nug keeke danab heḵunu elele iiṯa he anidnana, ag dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","Amge Pilip nug Jesus Kristusnu amu Kayaknu ḏo maḏoḏnu Nai Ena mehuqe, ag doonna, haen amup̱a danab ah ele ag oolagp̱a genab doyeg layaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","Ag layaṯak aoegeg, Saimon ele oop̱a genab doya, layaṯak awe, Pilip ele daaya, nug kobol danab heḵunu elele iiṯa diigdiig oḵai be anṯa, nug dab mak kuḏum awom. ");
INSERT INTO gaw_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","Pilip nug layaṯe, totol danab tuelp Jerusalem daap̱ig ele amu, ag Samaria danab ah Kayak nai doop̱ig amu doona, ag heeg, Petrus Johanes ele noya anadpiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","A gumadya noya, ag Kayak Ouḏi aoglagnu unuqidpiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","Aḏinu? Kayak Ouḏi Nug ahilagp̱a ii neum. Ag Jesus onigp̱aib layaṯak aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","Amunu a unuqiṯoya, a ep̱elah qaḏelagp̱a meeh, ag aaḵu Kayak Ouḏi aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","Amu Saimon nug Petrus Johanes ele a ep̱elah danab ah qaḏelagp̱a meeheh, ag Kayak Ouḏi aoegeg anata, Nug men doḏo awa doa, ahilah g̱agaṯag amu daden meḵunu amelahp̱a inam aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“Danab aḏit, a uḏat heṯep ele, g̱agaṯag amu da laa meḏapeḏ amu, da ele danab laa qaḏep̱a ep̱el mep̱i, nug Kayak Ouḏi aoḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","Saimon nug aum amge Petrus nug amegp̱a aum. “Na Kayaknu keeke ena ena, nuhig oo meṯakp̱a hamu megṯe amu na men doḏop̱a aoḵutnu heṯem. Men doḏo nahip amu na ele oh iiṯa memayanu na dab me! ");
INSERT INTO gaw_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","Na uḏat imu, ig heṯem ele amu, na amu oop̱a daaḵutnu elele iiṯanab. Kayak anidṯe, na oot am tutuḵu iiṯa. ");
INSERT INTO gaw_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","Am na kobol nau nahip amunu oot eḏueb, dab mak nau nahip dab makp̱a beum amu, Kayak Nug amu uhuqa medaḵunu, na Kayak unuqiṯe! ");
INSERT INTO gaw_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","Aḏinu? Da anidṯem, na hip̱uninnu nob nau mua ele aoḵutnu oiṯem,” awa aum! ");
INSERT INTO gaw_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","Petrus anam awa a, Saimon nug inam aum. “A Kayak unuqidpeḏ, Nug da ehaniḏeb, keeke a aṯep amu dahilp̱a aib beum,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","Amu Petrus Johanes ele a danab ah amelagp̱a Kayaknu mehuqeh doyeg, aria dimp̱a a eḏuya Jerusalem gopiḏ. A ibp̱a goyaya, Samerianu ab kuḏump̱a a Nai Ena mehuqpiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","Petrus Johanes ele a anam heyaya uḵaeheh, aria Kayaknu engel nug Pilip amegp̱a aum. “Na ahan, laih yau uḏiṯep̱a gona, ib laa Jerusalemnu Gasa uḵakp̱a daaṯe amu ap̱a te! Ib amuam atu taḏakp̱anu ib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","A amu aria Pilip nug aha uḵom. Amu ibp̱a nug Itiopia danab laa anṯom. Danab amu nug am Itiopia dilag Kuin Kandesi amu nuhig uḏat gumak danab laa. Nug am danab maṯoi. Nug Kandesinu keeke ena oh gumṯom. Danab amu nug meṯid heḵunu Jerusalem uḏiom. ");
INSERT INTO gaw_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","Amu deḏ Pilip uḵom, deḏ amup̱a nug eḏua ugaḵa, nuhig karisp̱a dayaya, nug propet Jesaianu yak amu eb qaaqa uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","Nug amu eb qaaqa ugeḵe, Kayak Ouḏi Nug Pilip amegp̱a aum. “Na karis umu guḵuidna uḵe!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","Aria Pilip nug paha gumiṯa wana, danab amu nug propet Jesaianu yak amu eb qeeqe doya, oḏ meṯa aum. “Na nai eb qeṯem ele amu diig nuhignu amu na oot maidṯete, o iiṯa?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","Am danab amu nug aum. “Danab laa da dooḵulnu ii ip̱uniḏebeb amu da aṯem hein doop̱i, ool maidḵu?” awa aum. Awa anana, nug Pilip amegp̱a aum. “Na bep̱e, da ele daaḏu!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","Amu nug Kayak nai laih laa eb qeum amu iiḵu. “Ag doḏ sipsip qep̱eg mauhḵunu aon, qak abenp̱a goṯeb bia aon gop̱ig. Ag doḏ sipsip nag uḏig otaḏeg nug ii gaate, amubia Nug ele oḏe qamuta, toi eṯa dayom. ");
INSERT INTO gaw_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","Ag Nug onig qeeg ne dayeye, nuhig heṯoḏiak amu, elele ii hep̱ig. Ag Nug qeeg mauhom amunu Nug wanp̱a buḏub iiṯa.” Laa nug Kayak naip̱a anam yom. ");
INSERT INTO gaw_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","Aria gumak danab amu Pilip amegp̱a aum. “Da oḏ meṯem. Propet nug nai imu danab aunnunab aum? Nug nuḵa nuhignute aum o iiṯa danab laanute aum?” Nug anam oḏ meṯom. ");
INSERT INTO gaw_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","Oḏ meṯe aria Pilip nug danab amu amegp̱a Kayak nai, nug eb qeum, amup̱a dig ma, nai laala ele awa, Jesusnu nai ena amu mehuqom. ");
INSERT INTO gaw_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","A anam heyaya goya goya, le laa anidya, gumak danab nug aum. “Anṯe! Le iiḵu. Aḏi keeke laa da layaṯak ii aop̱anu da qaḵiḏṯe?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","Aria Pilip nug aum. “Na ootp̱a genab doona am na aoḵut.” Awa a, nug oḏep̱a awa aum. “Da Jesus Kristusnu oolp̱a genab dooṯem, Nug am Kayak Beḵa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","Aria Kandesinu gumak danab nug a, karis dayeye, aaḵu Pilip, gumak danab amu ele, a le amup̱a noya amu Pilip nug danab amu layaṯak meṯom. ");
INSERT INTO gaw_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","Nug laaiṯe, a le uuya teeh amu pahanab Kayak Ouḏi Nug Pilip awa uḵe, gumak danab nug baula ii anṯom amge nug oo gamag ahehe, ap̱agp̱a uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","Anam uḵom amge Pilip nug Asdot ap̱a tula ba, ab oḵai laalap̱a uḵa oiyaya, nug Nai Ena mehuqom. Nug anam haaha uḵa, Sisaria waum. ");
INSERT INTO gaw_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","Amu haen gamag amup̱a ele Saul nug danab ah Jesusnu oolagp̱a genab doop̱ig ele amu, ag aqeb mauhḵulagnu, nug g̱agaṯag anana, wagai ma haaha, nug mana meṯak danab dilag iḵi gumiṯa uḵa ");
INSERT INTO gaw_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","amegp̱a a, nug Juda dilag nai doyak lag Damaskus daaṯeb amunu iḵi danab dilag pas amu nug Saul meṯom. Pas amup̱a nug inam yom. “Saul nug danabte, iiṯa ahte ag Jesusnu oolagp̱a genab dooṯeb ele amu, ap̱a anadḵu, nug hip̱alaṯa diia, Jerusalem uḏiḵu,” ana yom. ");
INSERT INTO gaw_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","Aria nug ya, Saul meṯe, nug uḵom. Uḵa Damaskus guguiṯeṯe amu laip̱un pahanab hab aṯannu amahlak laa na, huan amahaliṯom. ");
INSERT INTO gaw_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","Amahaliṯe, Saul nug wanp̱a na qa, wanp̱a niieye, nai baag laa na, inam amegp̱a a doyom. “Saul Saul, na aḏinu da eheḏ heiḏṯem?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","Anam awa a, Saul nug aum. “Naḏi na amu aun?” awa oḏ meṯom. Oḏ meṯe amu Naḏi Nug eḏua aum. “Da am Jesus amu na da eheḏ heiḏṯem. ");
INSERT INTO gaw_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","Amge na ahan, ab oḵai oop̱a nona daap̱p̱e, geha na keeke aḏi heḵutnu amu danab laa nug na amenp̱a aḵu,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","Nug amegp̱a amu aawo, danab Saul ele oip̱ig amu, ag nai iiṯa hip̱aidna daanna, baag aaḵuib doop̱ig, danab laa ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","Nug nai maṯia male, aria Saul nug aha goḵunu neeḵom amge nug ameg gatatu mane, ag nug ep̱eg aḏan, omalna Damaskus abp̱a nop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","Ag aon noeg, nug deḏ ewam ii neeḵom, ameg gatatuib dayeye, nug e le ele laa ii laum. ");
INSERT INTO gaw_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","Nug anam dayeye, danab laa nug Jesusnu oop̱a genab doyom ele amu, nug Damaskus ap̱a dayom, nug onig Ananias. Nug dayeye, Naḏi nug onig diia, “Ananias,” awa aum. Awa a aaḵu nug oḏep̱a awa aum. “Naḏi, da ina daaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","12","A amu Naḏi Nug amegp̱a aum. “Na ahan, ib onig Tutuḵu, amup̱a gona, Judas laugp̱a tena, na Tasus danab laa anidḵut, nug onig Saul. Nug unuqidṯe. Amu da hei, nug tuleglegp̱a, nug eḏua neegḵunu elele daaḵuknu amu nug danab onig Ananias nug uḵa, nug aḏe anṯom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","Naḏi Nug Ananias amegp̱a anam aum amu Ananias nug eḏua inam aum. “Naḏi, danab kuḏum ag danab amunu aeg doomi. Nug kobol ena iiṯa haaha, nahipad danab ah Jerusalem daaṯeb ele amu eheḏ haṯom. ");
INSERT INTO gaw_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","Nug ip̱a ele anam heḵunu mana meṯak danab oḵai ep̱elagp̱anu pas awom. Nug danab ah ab imup̱anu ag nahipnu oolagp̱a genab doonna, na unuqidṯeb ele amu, ahilagnu ele nug anam heḵunu uḏiom,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","Amge Naḏi Nug amegp̱a aum. “Na uḵe! Danab amu nug dahil uḏat danab, da nug tituanmi. Nug da onil awa uḵa, iiṯa aḏi amu king aḏi am Israel ele amelagp̱a ab dooglag. ");
INSERT INTO gaw_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","Geha nug da onil ag ip̱uanaṯaṯa, amup̱a nug ug diigdiig maoḵunu daaṯe amu da nug ip̱unidḵul,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","Amunu Ananias nug uḵa, Saul dayom ele, lag amu oop̱a noa, ep̱eg qaḏep̱a ma, nug amegp̱a aum. “Lai Saul, Naḏi Jesus Nug na ibp̱a gumiṯa neum ele amu, Nug aaḵu he, da na gumiṯen uḏimi. Aḏinu? Da hep̱i, na eḏun bau neegḵutnu, Kayak Ouḏi na ootp̱a am beḵu amunu ele uḏimi,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","Anam awa a, Saul ameg laih laihp̱a keeke kakai gonelag bia aḏaya daapiḏ amu, nug ameg doḏop̱anu tolai neya qeeh, ameg ena daye, aha layaṯak awom. ");
INSERT INTO gaw_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","Nug layaṯak awowa, dimp̱a nug e laawo, beḏu g̱agaṯag qeum. G̱agatag qe, Saul nug Damaskus ap̱a deḏ laala danab Jesusnu oolagp̱a genab doop̱ig ele amu, nug ag ele oh daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","Saul ag ele, ag ap̱a daanna nug ameg mak ii heum. Iiṯa, nug uḵa, Juda dilag nai doyak lag laalap̱a noa, nug Jesusnu nai mehuqa, amelagp̱a inam aum. “Jesus Nug Kayak Beḵa,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","Nug Jesusnu nai amelagp̱a mehuqeqe doonna, danab oh ag nuhignu dab mak kuḏum aonna, ag ap̱ig. “Danab amu nug aaḵuib danab ah ag Jesusnu oolagp̱a genab doon unuqidṯeb ele amu, nug ag aqaṯe. Nug Jerusalem up̱a amu anam haaha, ip̱a ele nug ag hip̱alaṯa diia, mana meṯak danab oḵai ep̱elagp̱a meḵunu uḏiom,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","Ag anam aegeg amu Saul nug Jesusnu, Kayak Nug Nug tituanom, Kristus daaṯe, amu tutuḵunab, nai ebehi elep̱a ip̱uanaṯe, Juda ag nuhig nai tabap̱eg noḵunu ib laa ii anidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","Nug anam heehe, deḏ kuḏum uḵe, Juda ag qag mena, Saul qep̱eg mauhḵunu nai qagap̱ig ");
INSERT INTO gaw_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","amge laa nug a, Saul nug nai amu aaḵu doyom. Juda ag nug qep̱eg mauhḵunu amun tuqan ele meidna, ib aḏan, abnu aḏ odp̱a daap̱ig ");
INSERT INTO gaw_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","amge danab ag Saulnu nai dim lamidp̱ig ele, ag tuqan Saul aon, kalegp̱a inan, abnu aḏ oḏe laap̱a paḏeg, dimiṯim noa uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","Aria Saul nug oiyaya, Jerusalem uḵa, nug danab Jesusnu oolagp̱a genab doop̱ig amu, nug ag ele oh daaglagnu heum amge ag oh nug baḏidp̱ig. Aḏinu? Ag nug oo eḏue, Jesusnu oop̱a genab doyom amu, ag amu oolagp̱a genab ii doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","Ag nug baḏidp̱ig amge Banabas nug Saul omala, totol danab tuelp gumaṯa uḵa, ibp̱a Saul nug Naḏi Jesus anṯe, amegp̱a nai aum amu Banabas nug amunu amelagp̱a maṯiaya, nug Saul Damaskus dayaya nug Jesus onigp̱a nai mehuqḵunu wagai meum, nug ii baḏom amunu ele amelagp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","Ag Saul oo eḏuom amu doyeg, nug ag ele Jerusalem daanna, nug ag oolagp̱a oiyaya, nug Naḏi Jesus onigp̱a nai mehuqḵunu wagai meum, nug ii baḏom. ");
INSERT INTO gaw_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","Nug Juda laa, ag Grik nai dooṯeb amu ag ele nai maṯin, aeg ona aeg doum amu ag nug qep̱eg mauhḵunu ib madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","Anam heeg dimp̱a nug kristen tamaniakp̱anu laiḵud ag amu doona, ag Saul omalna, Sisaria nona, meeg Tasus uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","Saul nug oo eḏuom amu laih Juda oop̱a, Galelia ap̱a amu Samaria ele, aben amu ohp̱a kristen tamaniak nug ena dayeye, kekeḏ laa ii daye amu kristen tamaniak g̱agaṯag ba, Naḏinu enanag doon, oolag ele oṯaie, Kayak Ouḏi oolagp̱a uḏat ena heehe, danab ah kuḏum ag kristen tamaniak oop̱a nop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","Petrus nug danab ag matatun ab ab gona daap̱ig ele amu ag anadḵunu oiyaya, ab oḵai onig Lida noa, ap̱a danab ah Kayaknu oolagp̱a genab doop̱ig ele amu anaṯe daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","Daanna ab amup̱a Petrus nug danab laa anṯom, nug onig Inias. Nug beḏu oh mauhak ele, nug maḏ 8 anam abenp̱a niiakib niiom. ");
INSERT INTO gaw_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","Petrus nug anṯa amegp̱a aum. “Inias, Jesus Kristus Nug na beḏun ehanidṯe amunu na ahan nahip niiak aben babaiṯe!” awa aum. Awa a aria Inias nug paha ahom. ");
INSERT INTO gaw_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","Nug ahe, Lidanu danab ah oh amu Saron danab ah ele ag amu anidna, ag oolag eḏue, Jesusnu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","Aria ab laa onig Jopa, ap̱a amu ah laa Jesusnu oop̱a genab doyaya dayom, nug onig Tabita, Grik naip̱a amu ag Dokas aṯeb. Nug hanhan kobol ena haaha, nug danab ah keeke iiṯa ele amu ehanaṯaṯa, keeke madaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","Amu Petrus nug Lida dayeye, haen amup̱a ah amu nug oḏe awa mauhe, danab ah ag mauhom gaḏa amu le laaidna, lag oo aṯan laa amup̱a meeg dayom. ");
INSERT INTO gaw_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","Lida Jopa ele ou qak daapiḏ amunu danab Jesusnu oolagp̱a genab doop̱ig ele ag, “Petrus Lida daaṯe,” amu doop̱ig amunu ag danab aḏit, a Petrus amegp̱a, “Na paha ihinigp̱a uḏie! Na ap̱a aib daame!” aḵulahnu heeg gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","Aria Petrus nug ahe, danab amu ele oh gop̱ig. Nug uḵa te, ag nug omaleg lag oo aṯan amup̱a te amu ah qab ap̱anu ag oh uḏin, Petrus talilidna daanna, gaanna, ag lamen diigdiig Dokas ha maṯom amu ip̱unidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","Ag anam heeg amu Petrus nug he, danab ah oh dimiṯim uḵaeg amu nug dup noa, gateg qaun wa unuqiṯowa, eḏua ah gaḏa amu neeḵiṯa, nug aum. “Tabita na ahe!” awa aum. Awa a, aaḵu ah ameg op̱ate neeḵa, nug Petrus neeḵiṯaṯa, aha heḏep na dayeye, ");
INSERT INTO gaw_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","Petrus ep̱eg aḏa, hume hibaiṯom. Nug eḏua ahe, Petrus nug danab ah, Kayaknu oolagp̱a genab doop̱ig, ah qab ele, ag onilagp̱a e uḏieg, Tabita awa maṯom. ");
INSERT INTO gaw_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","Petrus nug amu he, nai amu Jopa ab oḵaip̱a uḵe, danab ah oh doop̱ig. Doona amu kuḏum ag Naḏinu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","Ag anam heeg, Petrus nug deḏ kuḏum Jopa dayom. Nug danab laa, makau gaḏa beḏamanu babaiṯaknu dooṯom amu, nug ele daapiḏ, nug onig Saimon. ");
INSERT INTO gaw_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","Aria iiṯa aḏi danab laa Sisaria dayom, onig Konilias. Nug daup 100, onig Itali daup, amu dilag iḵi. ");
INSERT INTO gaw_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","Danab amu nug baeḵudp̱a ele ag oh Kayaknu enanag doonna, oolag ele oṯaiom. Amu nug men doḏo kuḏum, Juda danab men doḏo iiṯa ele amu, nug ag ehanaṯa madaṯa, haen oh nug Kayak unuqidṯom. ");
INSERT INTO gaw_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","Nug anam heehe amu deḏ laa aam ameg ewamp̱a nug tuleglegp̱a Kayaknu engel miag atiak nug laug oop̱a no anṯom. Engel nug noa, onig diia, “Konilias” aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","A, Konilias nug engel neeḵiṯaṯa, huanak baḏaḏa nug aum. “Danab naḏi, amu aḏitai,” awa aum. A aria engel nug amegp̱a aum. “Kayak Nug nahip unuqiṯak amu daḏek ehaniṯak kobol nahip ele anṯa, nahipnu dab meṯe. ");
INSERT INTO gaw_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","Amunu na gemu danab laala hep̱e, Jopa gona, ag danab laa, nug onig Simon, onig laa Petrus, amu anidna ap̱eg uḏiaḏ! ");
INSERT INTO gaw_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","Simon Petrus nug Saimon, nug am makau gaḏa beḏamanu babaiṯak danab, nug laugp̱a daaṯe. Lag amu yu ihip̱a daaṯe. Ag nug ap̱a anidḵulag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","Engel nug Konilias amegp̱a anam awowa ugeḵe, aria Konilias nug nuhikuḏ uḏat hak danab aḏit laa amu daup laip̱u ele onilagp̱a e dop̱ig. Daup amu nug Kayaknu oop̱a genab doya, nug Konilias ehaniṯom. ");
INSERT INTO gaw_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","Aria Konilias nug nai amu oh tutuḵu diig ihuhua, danab ewam amu amelagp̱a awowa he, ag gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","Amu danab ewam ag uḵaegeg, uu do, ibp̱a niiona, ahan uḵaegeg, aam ameg tutuḵu aoḵunu heehe Jopa guguiṯegeg, Petrus nug lag aṯan unuqidḵunu teum. ");
INSERT INTO gaw_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","Petrus nug enug qak doya, e laḵunu dab meum. Dab meeme, lag amup̱a daap̱ig ag e lanaknu babaiṯegeg amu Petrus nug tuleglegp̱a ");
INSERT INTO gaw_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","hab obate, keeke laa ne anṯom. Keeke amu lamen oḵai laa bia, muḏi waḏele daug waḏelep̱a qaḵak dayeye, paḏaeg wanp̱a neum. ");
INSERT INTO gaw_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","Keeke amu oop̱a amu doḏ diigdiig oh daap̱ig, mat iḏu iḏu amu ai iḏu iḏu ele. ");
INSERT INTO gaw_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","Nug amu anṯa dayeye am baag laa Petrus amegp̱a inam aum. “Petrus na ahan, doḏ imu aqan la!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","Nug anam aum amge Petrus nug aum. “Naḏi, da Juda dilag ḏop̱a keeke nau dubuṯid ele daaṯe amu da ii laṯem amunu da uumi, ii lapa. Da anuḵa ele da laa lain ii anidmi!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","Petrus nug anam awa a, baag amu eḏua Petrus amegp̱a inam aum. “Kayak keeke heum amu nau laa iiṯa, enaib daaṯe amunu na keeke amunu, ‘Am nau, ena iiṯa,’ aib ame,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","Lamen oḵai amu nug ne, haen ewam bate, Petrus nug anṯa doyom amuib anṯe amu aria paha keeke amu eḏua, hab aṯan teum. ");
INSERT INTO gaw_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","Am Petrus nug Kayak keeke amu ip̱uniṯe anṯowa, nug oo ii maiṯe, keeke amu diignu dab mak kuḏum awom. Nug anam dab mak awewe, aria danab Konilias he uḏip̱ig amu ag uḏin bena, ag Saimon laugnu oḏ meeg, ip̱uanaṯeg dona, lag odp̱a hip̱aidna daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","Ag lag odp̱a daanna, enan inam oḏ mep̱ig. “Danab Simon, nug onig laa Petrus amu, nug ip̱ate daaṯe o iiṯa?” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","Aon oḏ meegeg, amu Petrus nug keeke anṯom, amunu dab meeme, Kayak Ouḏi amegp̱a aum. “Doye! Danab ewam ag na maṯidṯeb ");
INSERT INTO gaw_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","amunu na ahan nop̱e, ag ele uḵeg! Ootp̱a ug aib doome. Da hei, ag uḏip̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","Nug anam Petrus amegp̱a a, Petrus noa, danab amu anaṯa nug aum. “Ag date maṯiḏṯeb? Da iiḵu. Ag aḏinu uḏip̱ig?” awa aum. Nug anam awa oḏ maṯe, ");
INSERT INTO gaw_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ag nug amegp̱a ap̱ig. “Konilias, nug daup 100 dilag iḵi daaṯe, nug he ig uḏimut! Nug am danab ena. Nug am danab Kayaknu enanag doyaya, oo ele oṯaiṯe. Juda oh ag nuhignu amu, ‘Nug am danab ena,’ aon aṯeb. Amu Kayaknu engel laa na, Konilias amegp̱a nahipnu, na Konilias laugp̱a gona, na nai laala ap̱e nug dooḵunu aum amunu nug he, ig uḏimut,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","Ag Petrus amegp̱a nai amu ana malaeg, nug omalaṯe, lag oop̱a noeg, tuqan amup̱a nug dab madeṯe, wagḏe nug ele oh uḵaegeg amu Jopan danab, Jesusnu oolagp̱a genab doop̱ig ele, ag oolagp̱an laala ele ahaeg, oh gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","Aria ag gona, tuqan laip̱u ibp̱a niiona, ahan gona Sisaria tep̱ig. Konilias nug amelag ma dayeye, nug baeḵudp̱a amu nug laiḵudnab ele, nug ag onilagp̱a e uḏieg, ag ele qag mena daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","Ag qag men daaegeg, gona tena, Petrus nug Konilias laug oop̱a no, Konilias nug doa, Petrus baegp̱a dup noa binag meum. ");
INSERT INTO gaw_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","Nug anam heum amge Petrus nug Konilias hume ahehe, amegp̱a aum. “Na ahe! Da ele am danabib,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","Am Petrus nug Konilias ele nai maṯiiya, lag oop̱a noya, danab ah kuḏum qag mena daaegeg anaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","Petrus nug kuḏum daaegeg anaṯa, nug amelagp̱a aum. “Ig Juda amu ihinig ḏo g̱agaṯag laa am Juda danab laa nug iiṯa aḏi laa ele oh ou qak laip̱u ii daamya, o Juda laa amu nug iiṯa aḏi laa ele gumiṯa ii wama amge Kayak Nug da ip̱uniḏom, da danab laanu inam laa ii apa. ‘Da am Juda danab amunu Kayak amegp̱a da iiṯa aḏi amu da nug eḏidṯem!’ Da anam awe ii apa. ");
INSERT INTO gaw_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","Amunu ag da gumaṯe uḏiḵulnu onilp̱a ep̱ig amu da ahilag ewak amu tap̱ai ii neum. Iiṯa! Ag da uḏiḵulnu ap̱ig am da iiḵu uḏimi. Aria ag da onilp̱a ep̱ig amunu diig nakok ap̱eg dooḵulnu ool daaṯe,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","Awa a aria Konilias aha, nug keeke nuhigp̱a be anṯom amunu maṯia aum. “Keeke anidmi amu gemu deḏ waḏele iiḵu uḵom am inam. Da laulp̱a dayeye, da aam ameg ewamp̱a haen gemu inam iiḵu bia aaḵu da unuqiṯiṯi, danab laa, nuhig lamen amu amahlaknab ele, nug da noolp̱a hibaiṯa ");
INSERT INTO gaw_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","nug aum. ‘Konilias, Kayak Nug nahip unuqiṯak doya amu na daḏek danab ehanadṯem amu ele anṯom. ");
INSERT INTO gaw_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","Amunu na hep̱e, danab laala Jopa gona, danab Simon, nug onig laa Petrus, ap̱eg uḏiaḏ! Danab amu nug Saimon, makau gaḏa beḏamanu babaiṯak danab, nug laug amu yu ihip̱a daaṯe ele amu, nug danab amu ele daaṯep,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","Nug anam a amu da paha hei, danab laala na omaidḵulagnu uḵaeg, am na ena hena uḏime. Aria ig oh Kayak noobp̱a inam daatta amu Naḏi nuhig nai oh Nug na ap̱e doognignu a doome ele amu, na ap̱e doognignu daaṯem.” Konilias nug Petrus amegp̱a anam aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","Konilias nug nai maṯia male amu Petrus nug inam awa aum. “Amu genabnab gemu da dooṯem, Kayak Nug danab buḏubnu dab maama, laa oo medaṯa, laa geḏiṯaṯa ii heṯe. ");
INSERT INTO gaw_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","Iiṯa, Kayak Nug danab buḏub ohp̱anu laa ag nuhignu enanag doonna, oolag ele oṯaiṯe, ag kobol ena heṯeb ele amu, Kayak Nug ahilagnu amu oo mauhṯe. ");
INSERT INTO gaw_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","Kayak Nug Jesus, Nug am wan ohp̱an dilag oḵai daaṯe amu, Nug ep̱egp̱a Israel danab ag maḏoḏnu Nai Ena madaṯa, Nug nai geha iiḵu ami ele amu, Nug nai amu ele ag maṯom. ");
INSERT INTO gaw_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","Ag Juda wanp̱a keeke laa tumaiib beum amu ag dooṯeb. Layaṯak Johanes nug layaṯaknu nai mehuqe ");
INSERT INTO gaw_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","dimp̱a Kayak he, nuhig Ouḏi Jesus, Nasaret ted, Nug oop̱a am be g̱agaṯag oḵai ele meṯom amunu Nug Galelia ap̱a dig ma, ab ab oiyaya, danab ah ehanaṯom. Kayak Nug ele daaiya, danab oh Satan he, ena ii daap̱ig ele amu, Nug bap̱alaṯe, ag eḏun ena daap̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","Petrus nug anam anana, nug nai amu tuḏiṯa aum. “Amu Jesus Nug Juda wanp̱a amu Jerusalem abp̱a ele, Nug aḏi heum amu ig totol danab ig anidmut. Jerusalem ap̱a amu ag Nug ad emaitakp̱a atuleg mauhom ");
INSERT INTO gaw_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","amge deḏ ewamp̱a Kayak he, Nug eḏua hibaiṯe, ");
INSERT INTO gaw_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","danab kuḏum laa ag Nug anidp̱ig. Danab oh ii anidp̱ig. Iiṯa! Ig laala, ig Nug anidḵunignu, Kayak Nug ig tituaniḵom ele amu, Nug ig gumiḵa uḏie anidmut. Nug hibaiṯe, dimp̱a ig Nug ele e, le ele lamut. ");
INSERT INTO gaw_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","Amu Nug ig nai mehuqḵunignu amu ig danab ah amelagp̱a Nug dimp̱a mauhak aḏi, bau dayak aḏi ele epeḏiadḵu, nai amu mehuqḵunignu ḏo meḵom. ");
INSERT INTO gaw_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","Nuhignuib propet ag inam yaap̱ig. ‘Aun aḏi ag Jesusnu oolagp̱a genab dooṯeb ele amu Kayak Nug, Nug onigp̱a, hip̱unin ahilag uhuqa maḏaḵu.’” Petrus nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","Petrus nug nai mehuqeqe, Kayak Ouḏi Nug danab oh, ag Kayak nai doop̱ig ele, ahilagp̱a neum. ");
INSERT INTO gaw_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","46","Am Juda danab, ag Jesusnu oolagp̱a genab doop̱ig, ag Petrus dim lamidna uḏip̱ig ele amu, ag Konilias aḏi ag Kayak Ouḏi ne awona, ag nailag diigdiigp̱a nai maṯinna, ag Kayak binag meegeg anadna, ag Kayak Ouḏi Juda danab maṯom bianab, Nug iiṯa aḏi ag ele maṯom anidna, ag dab mak kuḏum aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","Ag dab mak kuḏum aoegeg, Petrus nug aum. “Amu laa nug danab imu ag layaṯak aoglagnu gun meḵunu elelete? Ag Kayak Ouḏi ig aomut amubiaib aop̱ig,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","Nug anam awowa, danab haen amup̱a Kayak Ouḏi aop̱ig amu dilag aum. “Ag Jesus Kristus onigp̱a layaṯak aweg!” awa aum. Nug anam a, ag aona amu ag nug amegp̱a ap̱ig. “Na ig ele deḏ laala ele daagnig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","Aria totol danab laa amu ag lailḵad Juda daap̱ig ele ag oh iiṯa aḏi ag ele Kayak nai aaḵu aop̱ig amu ag doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","Doyeg, Petrus nug eḏua Jerusalem uḵe amu laa ag gaḏa otaḏaknu wagai meṯeb ele, danab amu ag Petrusnu oolag aeg beum. ");
INSERT INTO gaw_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","Ag anam henana, ag Petrus aidna ap̱ig. “Na gona, danab gaḏalag ii otaḏak amu laulagp̱a tena, ag ele daanna, e laap̱ig,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","Ag anam ap̱ig amge Petrus nug keeke oh be, nug heum ele amunu mehuqa, amelagp̱a inam aum. ");
INSERT INTO gaw_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“Da Jopa ab oḵai amup̱a unuqiṯeṯe dayeye, da tuleglegp̱a keeke laa anidmi. Hab aṯannu keeke laa lamen oḵai bia muḏi waḏele daug waḏelep̱a qaḵak dayeye, paḏaeg gumiḏa ne anidmi. ");
INSERT INTO gaw_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","Keeke amu ne, da anṯena, da keeke aḏi amu tutuḵu anṯe dooḵulnu, lamen amu oop̱a neeḵe amu wanp̱an doḏ, doḏ daḵuḏ iḏu iḏu, mat diigdiig, ai diigdiig ele anam anadmi. ");
INSERT INTO gaw_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","Anam aniṯiṯi amu baag laa nug amelp̱a aum. ‘Petrus na ahan, doḏ imu aqana la!’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","Nug anam aum amge da ami. ‘Naḏi, da Juda dilag ḏop̱a keeke nau dubuṯid ele daaṯe amu da ii laṯem amunu da uumi, ii lapa. Da anuḵa ele da nakoknab laa lain ii anidmi,’ awe ami. ");
INSERT INTO gaw_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","Ami amge baag hab aṯannu nug eḏua amelp̱a aum. ‘Kayak Nug keeke oh oolagp̱anu amu nau laa ii heum amunu na keeke enanu, “Nau,” aon aib ame,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","Lamen oḵai amu nug ne, haen ewam bate da anṯen doomi, anamib aniṯi amu keeke amu oh eḏua hab aṯan teum. ");
INSERT INTO gaw_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","Da keeke amu anam aniṯi, eḏua teete amu danab ewam ag uḏin lag da daami ele amup̱a dop̱ig. Danab laa Sisaria daaṯe amu, nug he, da omaiḏḵulagnu uḏip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","Ag uḏieg amu Kayak Ouḏi Nug da amelp̱a aum. ‘Na ahap̱e ag ele uḵeg! Dab mak kuḏum aib aome!’ awa aum. Aaḵu da uḵaiyi, lailad danab eblaih laip̱u ele imu, ag Jopa danab, ag da ele oh gota, ig danab amu laugp̱a temut. ");
INSERT INTO gaw_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","Laḵa teut, danab amu nug engel, nug laug oop̱a noa hibaiṯa dayaya, nai amegp̱a aum amu nug amunu ig amenigp̱a maṯiom. Konilias nug engel inam aumnu ig amenigp̱a aum. ‘Na danab hep̱e, Jopa gona, ag Simon, nug onig laa Petrus, nug ap̱eg uḏia, ");
INSERT INTO gaw_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","nug geha na amenp̱a nai laala mehuqeb doop̱e, Kayak Nug na eḏua awidḵu. Nug na amu na baenadp̱a ag ele oh diiḵu.’ ");
INSERT INTO gaw_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","Nug anam maṯie aria da ahen, nai dig mein maṯiyi, Kayak Ouḏi ahilagp̱a neum, Nug tatam dig makp̱a ihinigp̱a ne, ig aomut amubia aaḵu. ");
INSERT INTO gaw_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","Am da amu anṯena amu Jesus nai aum amu, nai amu aaḵu daulp̱a doum. Nai amuam inam. ‘Layaṯak Johanes nug lep̱a danab ah layaṯom amge geha ag amu Kayak Ouḏip̱a layaṯak aoglag,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","Amu anuḵa tatam ig Naḏi Jesus Kristusnu oonigp̱a genab doomut, Kayak Nug Nuhig Ouḏi ig meḵom, anamib gemu ag ele Kayak Nug ag maṯom. Kayak heṯe amunu da nuhig ib oo ii nepa.” Petrus anam awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","Petrus nug anam awa a, ag nai amu doona, ag nai ahilag madip̱ig amu uuna, ag Kayak binag mena ap̱ig. “Kayak heehe, iiṯa aḏi danab ele ag oolag eḏuṯe, bau dayak aoṯeb,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","Amu ag Stepanus qeeg mauhe, amu dimp̱a ag tamaniak hep̱eg nauhḵunu hep̱ig, diig amunu danab ag oolagp̱a genab doop̱ig ele amu, ag oolna matatun gop̱ig amu ag Pinisia, Saipras amu Antiok ele batak gona daap̱ig. Daanna, ag danab oh amelagp̱a Nai Ena amu ag ii mehuqp̱ig. Iiṯa, ag Juda danabib amelagp̱a Nai Ena amu mehuqp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","Aria ag anam hep̱ig amge ag oolagp̱anu danab laip̱u laip̱u, ag am Saipras amu Sairini danab ele, ag gona, Grik danab Antiok daap̱ig ele amu ag amelagp̱a Naḏi Jesusnu Nai Ena mehuqp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","Ag anam heegeg, Naḏinu g̱agaṯag ag ehanaṯeṯe, danab ah kuḏum ag oolag eḏue, oolagp̱a genab doon, ag Naḏi oolag medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","Ag Naḏinu oolagp̱a genab doyeg, kristen tamaniak Jerusalemnu ag nai amu doona heeg, Banabas Antiok uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","Nug Antiok uḵa, danab ah ag Kayaknu ehaniṯak oḵai hamu megṯe ele amu, ehaniṯak amu ag aweg, ag oolagp̱a uḏat heehe, ag Kayak dim lamidp̱ig anṯa amu nug oo gamag ahe, dab mak aoglagnu, ag hanhan ag oolag Naḏiib meṯan oiglagnu ib ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","Banabas nug danab ena, Kayak Ouḏi nug oop̱a am bak daye, nuhig oop̱a genab doyak am ele g̱agaṯag amunu nug danab ah ehanaṯeṯe, danab ah ameg naḏi ag Naḏinu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","Aria Banabas nug Saul anidḵunu Tasus uḵa ");
INSERT INTO gaw_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","anṯa, nug omale Antiok uḵaeh, maḏ laip̱u kristen tamaniak ap̱anu ele daanna, a danab ah ameg naḏi Kayak nai ip̱uanadpiḏ. Antiok ap̱a danab ag tatam dig mena, danab ag Jesusnu oolagp̱a genab doop̱ig ele amu ahilagnu, Kristen ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","Aria haen amup̱a propet laala ag Jerusalemnu ahan Antiok nop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","Ag noeg, Kayak Ouḏi Nug propet laa onig Agabas amu ip̱uniṯe aha, geha enug haen naḏi Rom wan ohp̱a beḵu amunu nai maṯiom. Amu dimp̱a Klodias nug king dayeye, haen amup̱a enug haen amu beum. ");
INSERT INTO gaw_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","Amu be, kristen ag nai laip̱u anana, ag men doḏo ag lailḵad Juda ehanadḵulagnu mep̱eg goḵunu dab mep̱ig. Kristen oh ag beḏulagp̱a men doḏo gane daaṯe amu doona, ag laih uḏat amunu otip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","Ag men doḏo amu qag mena, Banabas Saul ele mataeg, a men doḏo amu aoi goya, tamaniak iḵi danab ep̱elagp̱a mepiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","Haen amup̱a King Herodes Agripa nug kristen tamaniaknu toliak laala ug madaḵunu aḏalaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","Aḏalaṯa amu nug Jakobus qep elabp̱a dug o mauhom. Jakobus Johanes ele a am eamag. ");
INSERT INTO gaw_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","Nug kobol am he, Juda danab ag Jesusnu oolagp̱a genab ii doop̱ig ele amu, ag oolag ena daye anṯa, nug Petrus ele aḏom. Kobol amu Pasowa meṯid hobul haenp̱a beum. ");
INSERT INTO gaw_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","Nug aḏa amu nug Petrus mani guiṯak oop̱a meum. Nug amu mani guiṯak gumak danab ameg waḏele, ameg ohp̱a danab waḏele waḏele anam daap̱ig, ag guman daaglagnu ep̱elagp̱a meum. Herodes Agripa nug Pasowa meṯid hobul uueb, Juda noolagp̱a Petrus epeḏia, heeb mauhḵunu dab meum. ");
INSERT INTO gaw_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","Amu Petrus nug mani guiṯak oop̱a dayeye, kristen tamaniakp̱anu danab ah ag nuhignu oolagp̱a genab g̱agaṯag ele Kayak unuqidp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","Unuqiṯegeg, deḏ Herodes Agripa Petrus danab noolagp̱a meḵunu ii wagḵaḏom, tuqan amup̱a gumak danab aḏit laih laih daaeheh, Petrus nug gamagp̱a niiom. Ag sen aḏitp̱a nug hip̱alp̱ig. Nug anam niieye, gumak danab aḏit laa a odp̱a daaiya, od gumapiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","Ag anam daaegeg, laip̱un Naḏinu engel laa ap̱a hibaiṯa dayeye, amahlak lag amu oop̱a amahlom. Amahlele, engel nug Petrus qeṯi laih qeqala, maḏ eṯa aum. “Pahanab ahe!” awa aum. Awa a amu laip̱un sen Petrus ep̱egp̱anu amu uhuqya nepiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","Neeh, engel aum. “Imuanp̱a maṯagiḏ taḵan, baen gaḏa ele maate!” awa aum. Petrus nug anam he amu engel aum. “Ulahnu lamen amu aon mena, dop̱e goḏu!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","Awa a amu Petrus anam heum amge nug oo ii maiṯom. Nug, “Da tuleglegtai niiṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","Goyaya, gumak danab anuqakp̱anu amu a aben amu eḏidya waya, laa amu ele eḏidya wapiḏ. A danab amu oh eḏadyaya, uḏi uḏi, batakp̱a od aen elep̱a, ag matulna ab oḵaip̱a noṯeb ele, amup̱a wapiḏ. Waeh od g̱agaṯag amu nug nuḵa matule, a dimiṯim goya, ibp̱a noyaya, laip̱un engel nug Petrus uuiṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","Aaḵu Petrus nug aḏi kobol beum amu doya aum. “Herodes Agripa nug da aḏailele, Juda danab ag da eheḏ heiḏḵulagnu dab mep̱ig amge gemu da genab dooṯem, Kayak Nug he, engel nuhig uḏia, da ag ep̱elagp̱anu awiḏom.” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","Nug anam anana, kobol beum amunu dab maama, Jon Mak anig Maria, nug laugp̱a uḵom. Ap̱a danab kuḏum ag qag mena, unuqidnana daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","Daaegeg, Petrus nug dimiṯim od qeqale, uḏat ah Roda, nug od matulḵunu doa, ");
INSERT INTO gaw_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","Petrus baag doya, oo gamag ahe, od ii matulom. Iiṯa. Nug eḏua lag oop̱a qai eṯa uḵa, amegp̱a aum. “Petrus dimiṯim hibaiṯom daaṯe!” awa aum. Awa a amu ag qag mena daap̱ig ele ag ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","“Na kaaka!” aon ap̱ig. Amge nug, “Iiṯa! da ham ii bubuṯem,” anana, wagai meum amunu ag ap̱ig. “Amu nuhig engel,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","Anam maṯiegeg, Petrus nug od qeqalala dayeye, daaeg wana uḵe, ag od matulna, nug anidna oṯaip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","Oṯaieg, nug ep̱egp̱aib to eṯaglagnu awowa, Naḏi aṯem he nug mani guiṯak oop̱anu dimiṯim doum amunu amelagp̱a maṯiom. Nug amunu maṯia mala nug, “Ag Jakobus amu ig lainḵad laala ele imunu ap̱eg doyeg!” awa aum. Anam awowa, nug laih uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","Aria waḵaḏe gumak danab ag ootot oḵai aqe, aḵa aḵa nai huan madip̱ig. Ag ap̱ig. “Petrus nug aṯem heum?” ");
INSERT INTO gaw_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","Amu Herodes Agripa nug Petrus ii daaṯe amu doya, ag maṯiglagnu a madip̱ig amge nug ii anidp̱ig amunu nug he, gumak danab ag naip̱a daap̱ig. Daaegeg, nuhig dab makp̱a ag elele iiṯa anṯa amu ag aqap̱eg mauhḵulagnu aum. Imu dimp̱a Herodes Agripa nug Judanu aha, Sisaria uḵa ap̱a nakok dayom. ");
INSERT INTO gaw_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","Aria Herodes Agripa nug Taia Saidon ele dilah danab ah dilagnu oo aeg beum. Anam dayeye, wan amun danab ag e Judanu hanhan daden mep̱ig amunu ag enug aqamanu, danab ah amu ag qag mena gumidna uḏin, ag Herodes ele nai bap̱aidḵulagnu hena, ag nuhig niiak lag oo gumak iḵi danab Blastas amegp̱a Herodes Agripa nug oo aeg bak amu uuḵunu gaaeg, nug ehanadḵunu aum. ");
INSERT INTO gaw_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","Ag anam heeg aria Herodes Agripa nug doya, amu heḵunu deḏ laa mewowa, nug deḏ amup̱a king bala ma, kingnu balalp̱a dayaya, ag amelagp̱a nai maṯiom. ");
INSERT INTO gaw_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","Nug nai maṯie, danab ah ag amu doona inam aon ep̱ig. “Nai maṯiom umu am kayak laa baag. Danab baag iiṯa,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","Ag anam aegeg, Herodes Agripa nug nuḵa binag ma, Kayak binag ii meum amunu Naḏinu engel paha maḵuḏe, beḏu gauat qe, aaḵu mauhom. ");
INSERT INTO gaw_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","Amge Naḏinu nai amu g̱agaṯag aha, ab kuḏum laa ohp̱a tuala uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","Naḏinu nai amu anam aha ugeḵe, Banabas Saul ele a Jerusalem daaiya, uḏat ahilah maloya, eḏui Antiok goḵulahnu heya, a Jon Mak aoeh, nug ele oh gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","Aria Antiok kristen tamaniakp̱a propet amu ip̱uniṯak danab laala ele ap̱a daap̱ig. Ag onilag am Banabas, Simion, nug onig laa Naisa, Lusias, nug am Sairini ted, Maneyen, nug Herodes Antipas ele buḏub laip̱u, amu Saul aaḵu. ");
INSERT INTO gaw_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","Ag am Naḏi binag mena, e oh lanaknu kud mena daaegeg, Kayak Ouḏi Nug ag amelagp̱a aum. “Da Banabas Saul ele a uḏat laa heḵulahnu otiaṯe onilahp̱a emi amunu ag diiatp̱eg, uḏat amu heḵulah,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","Aria ag e oh lanaknu kud mena daanna, ag unuqidnana, ep̱elag qaḏelahp̱a mena heeg, a ahai gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","Kayak Ouḏi Nug he, a ahai goya, Selusia noya, Selusia ap̱a a ub laa anidya teya, Saipras nudp̱a gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","Saipras goya, a Salamis teya, ap̱a Juda dilag nai doyak lag laalap̱a teya, a Kayak nai mehuqeheh, Jon Mak nug ele oh daanna, nug ehanatom. ");
INSERT INTO gaw_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","A nud Saipras ap̱a oii oii, nud amup̱a aben laih goya, Pepos teya, Pepos ap̱a a Juda danab laa anidpiḏ. Nug am baḏ nau mak danab, propet ham bup̱uak ele, Nug onig Ba-Jesus. ");
INSERT INTO gaw_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","Nug gabman oḵai Sesias Polasnu ehaniṯak danab laa. Aria Sesias Polas nug nuhig dab mak ena ele amunu nug Banabas, Saul ele a uḏiglahnu onilahp̱a eum. Nug Kayaknu nai dooḵunu oo dayom. ");
INSERT INTO gaw_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","A nai mehuqeh amu baḏ nau mak danab Ba-Jesus, Grik naip̱a nug onig am Elimas, nug awa awa aqata, a nai madipiḏ ele, amu tap̱eb noḵunu heum. Nug gabman oḵai amu nuhig dab mak heeb eḏueb, Kayaknu oop̱a genab ii doomanu heum. ");
INSERT INTO gaw_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","Heum amu Saul, nug onig laa Paulus, nug Kayak Ouḏip̱a g̱agaṯag oḵai ele amunu nug Elimas g̱agaṯag neeḵiṯaṯa, amegp̱a aum. ");
INSERT INTO gaw_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“Na Satan beḵa. Na kobol ena oh dilag kekeḏ. Ham bup̱uak kobol oh amu kobol naunab oh ele na beḏunp̱a am baknab. Na Naḏinu ib tutuḵu oh he nauhṯe amu na kobol amu iite uumna? ");
INSERT INTO gaw_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","Aria da ap̱i doye! Gemu Naḏi ep̱eg amu na oiṯeb, amen gaḏueb, na ib ii anidna, amunnu amahlak ii anidnana, nakok haen elab anam daaḵut,” awa aum. Paulus nug anam aawo, pahanab keeke bud bia Elimas ameg haute, ameg gatatu mane, ib ii anṯa dayaya, oiyaknu elele iiṯa amunu danab laa ehaniṯa, ib ip̱unidḵunu aum. ");
INSERT INTO gaw_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","Am gabman oḵai nug keeke amu anṯa, nug oop̱a genab doyom. Amu Naḏinu nai ip̱unidpiḏ ele amunu nug dab mak kuḏum awom. ");
INSERT INTO gaw_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","Am Paulus nug danab nug ele oh oip̱ig ele ag Pepos ap̱anu ub aon gona, Pampilianu ab laa Pega ap̱a gop̱ig. Teeg amu Jon Mak nug uuata, eḏua Jerusalem uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","Uḵe amu a Peganu ahaya goya, ab onig Antiok, Pisidia wanp̱a dayom ele, amup̱a teya, Juda dilag Metidp̱a a Juda dilag nai doyak lag oop̱a noya daapiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","Juda dilag nai doyak lag amunu iḵi danab ag ḏo nai yak amu propet dilag yak ele eb qewona, dimp̱a ag Paulus Banabas ele dilah nai meeg uḵe oḏ matan ap̱ig. “O lainti, nai laa danab ah g̱agaṯag aqaglahnu dayeb amu aria mehuqpeḏ dooglag,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","Aon aeg aria Paulus nug aha, ep̱eg huma, nug aum. “Ag Israel danab amu danab laa ag Kayaknu enanag doon, oolag ele oṯaiṯe amu, ag doyeg! ");
INSERT INTO gaw_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","Ig Israel buḏub ele daaṯem amu ihinig Kayak, Nug ig alanḵad tituanaṯa he, ag ap̱ateg, dimp̱a Nug nuhig g̱agaṯagp̱a Igiptanu eḏua diia uḏiom. ");
INSERT INTO gaw_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","Nug eḏua diia uḏieye amu atu taḏakp̱a nug ahilag hak nau amu maḏ 40 Nug mawom. ");
INSERT INTO gaw_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","20","Nug diia uḏia, Kanan wanp̱a amu danab buḏub eblaih aḏitnu Nug aqa lamaṯowa, wan ahilag awa, Israel maṯe, ag wan amu maḏ 450 anam daaegeg, ahilḵad gumak danab, ag am epeḏiak danab, ag benan gumaegeg, uḵe uḵe, propet Samuel haenp̱a batak. ");
INSERT INTO gaw_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","Samuel dayeye, nuhig haenp̱a ag king aoglagnu aeg amu Kayak nug Kis beḵa Saul awa me, ahilag king maḏ 40 dayom. Nug am Benyamin buḏubp̱an danab. ");
INSERT INTO gaw_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","Saul nug dayom amge Kayak Nug nug geḏiṯowa, Dawit awa, Israel dilag king daaḵunu tituanowa amu nug Dawitnu inam aum. ‘Da Jesi beḵa Dawit anidmi, da nuhignu ool mauhṯe, nug am geha dahil nai oh dim lamidḵu,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","Amu Kayak Nug anuḵa nai maṯia qaḵa, Nug heeb, Dawit buḏubp̱an danab laa nug uḏia, ig eḏua awiḵak danab daaḵunu aum. Eḏua awiḵak danab amuam Jesus aaḵuib. Kayak he uḏiom. ");
INSERT INTO gaw_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","Amu Jesus ii nak haenp̱a Layaṯak Johanes nug Israel, ag oolag eḏueb layaṯak aoglagnu nai mehuqom. ");
INSERT INTO gaw_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","Layaṯak Johanes nug a, uḏat malaḵunu miag dayeye, nug Juda danab amelagp̱a aum. ‘Ag dahilnu, “Nug am Kristus,” dab meṯebte? Anam iiṯa. Da am Nug iiṯa. Amge laa Nug da dimulp̱a uḏiṯe amu, danab amu nuhig g̱agaṯag amu dahil eḏidṯe. Nug am danab oḵainab, da am oḵai iiṯa. Dahil hak imu nuhig hak amu ele elele iiṯa,’ awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","O lailad, ag laala Abraham buḏubp̱an danab, amu ag laala iiṯa aḏi danab ag Kayaknu enanag doon, oolag ele oṯaiṯe amu, ag doyeg! Kayak Nug Johanes oḏep̱a danab ehanadḵunu aum am ihinig ohnu aum. ");
INSERT INTO gaw_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","Aria danab Jerusalem daaṯeb amu ahilḵad iḵi danab ele, ag am ehaniṯak danab amu anidna ii doop̱ig, ag propet dilag yak, haen oh Meṯidp̱a eb qeṯeb ele amu, ag amu diig tutuḵu ii anidna, ag Nug heṯoḏiakp̱a mena, qeeg mauhom amunu propet ag anuḵa nuhignu ap̱ig amubia hena, ag nai amu elele medap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","Ag nuhig eheḏ hakp̱a Nug qep̱eg mauhḵunu laa ii anidp̱ig amge ag Pilatus nug hamu qeeb mauhḵunu ep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","Ag keeke oh propet ag nuhigp̱a heḵulagnu yaap̱ig amu ag hena malaeg, ag ad emaitakp̱anu aona, moḏ laap̱a boomp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","Ag anam hep̱ig amge Kayak he, Nug eḏua hibaiṯom. ");
INSERT INTO gaw_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","Nug eḏua hibaiṯowa amu Nug deḏ laala danab ag Galelianu ahaeg, nug ele Jerusalem gop̱ig ele amu, Nug ahilagp̱a tula be anidp̱ig. Danab amu ag am gemu Juda oolagp̱a nai amu mehuqṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","Aria Paulus nug anam aum amu nug nai baula ele tuḏiṯa aum. “Ig nai ena mehuqṯem am inam. Kayak Nug anuḵa ehaniḵak danabnu ig alanḵad amelagp̱a nai qaḵa aum ");
INSERT INTO gaw_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","amu Nug he, Jesus eḏua hibaiṯom amup̱a nai amu aaḵu meu oum. Amuam nai Sam tup̱a daaṯe bia. Nai amuam inam. ‘Na am dahil nid, da gemu na danab beḏu aon daaḵutnu awiṯen meidṯem.’ ");
INSERT INTO gaw_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","Aria Kayak Nug he, Jesus Nug eḏua hibaiṯom, Nug baula ii mauhma amuam Kayak Nug anuḵa anam heḵunu Jesaia amegp̱a inam a, Israel dilagp̱a yom. ‘Da Dawit amegp̱a keeke laa heḵulnu ami, nai amuam dahilnu, beḵununab daaṯe, amu da hein madaḵul.’ ");
INSERT INTO gaw_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","Nai amunu mehuqak diig am Sam laap̱a inam daaṯe. ‘Na geha nahip danab, op̱ia awak ele amu, Nug uup̱e ii beḏama,’ awa yom. ");
INSERT INTO gaw_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","Amunu ig dooṯem nai amuam Dawitnu iiṯa. Aḏinu? Dawit nug danab ah nug ele daap̱ig, ag oolagp̱a Kayak oḏe dim lamiṯaṯa oiyaya, dimp̱a nug mauhe, alaḵud boomadp̱igp̱a boomeg, beḏu wan meum. ");
INSERT INTO gaw_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","Amge danab imu, Kayak Nug me uḏia, danab beḏu awa beum amu, Nug beḏu ii beḏom. ");
INSERT INTO gaw_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","Amunu, o lailad, ag doyeg! Ig Jesusnu uḏat oḵai, amup̱a ig hip̱uninnu uhuqa meṯaknu nai ag amelagp̱a mehuqṯem. ");
INSERT INTO gaw_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","Ḏo Moses ep̱egp̱a uḏiom amu ag ahilag hip̱uninnu uhuqa meṯak amup̱a aoglagnu elele iiṯa. Amge danab imu, Jesus, aun aḏi ag nuhignu oolagp̱a genab dooṯeb, ag nuhigp̱a hip̱uninnu uhuqa meṯak aona, op̱ia awak danab daaglag. ");
INSERT INTO gaw_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","Ib laa iiṯa amunu ag kobol laa, propet ag amunu anuḵa ap̱ig ele, ag amu hemananu dab meig! Propet ag inam ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘O ag awa awa qeṯak danab, ag anṯeg! Da ahilag haenp̱a uḏat laa heḵul. Da hep̱i, danab laa nug ag amelagp̱a uḏat amunu mehuqeb amu ag oolagp̱a genab ii doomna amunu ag amelagp̱a anidnana, dab mak kuḏum aonna, mauhḵulag.’” Paulus nug anam aum. ");
INSERT INTO gaw_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","Aria Paulus Banabas ele a dimiṯim uḵaeheh amu danab ah ag ii daye daye inam ap̱ig. “Dimp̱a, meṯid laap̱a, a eḏuya nai amu baula mehuqpeḏ dootu!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","Ag anam anana qatina, Juda kuḏum amu iiṯa aḏi danab ele, ag Juda dilag meṯid amu dim lamidp̱ig ele, ag ahan, Paulus Banabas ele dim lamatp̱ig. Amu a danab amu ag Kayaknu ehaniṯak oḵai hamu megaṯe ele amu ag amunu oolagp̱a genab doon oiglagnu apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","Anam aoya aeh, Juda dilag Meṯid laap̱a amu ab amup̱an danab ah oh bia ag Kayak nai dooglagnu uḏin qag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","Amge Juda oḵai ag danab ah oh qag meeg anadna, ag oolag aeg be, ahan, Paulus nai maṯiom amu, laa ag amu doomnanu, nai amu tabap̱eg noḵunu henana, nai iḏu iḏu maṯin, dap̱idna, aon aon qedap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","Ag anam hep̱ig amu Paulus Banabas ele a amunu ii baḏapiḏ. Iiṯa! A nai g̱agaṯag ele maṯiya amelagp̱a apiḏ. “Imu genab, i Kayak nai tatam ag amelagp̱a apuḏ dooglagnunab ib dayom amge ag nai imu dooglagnu uun, miag atiak heeg beṯe amunu ag imu doyeg! Gemu i ag uuadḏa, iiṯa aḏi gumadḏa goḵunih. ");
INSERT INTO gaw_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","Aḏinu? Naḏi Nug i anam heḵunihnu ḏo inam metom. ‘Da na iiṯa aḏi, ag gatatup̱a daaṯeb, ag ib anidḵulagnu amahlak madaḵutnu otidmi. Na iiṯa aḏi ehanadp̱e, ag oolag eḏueb Kayak danab ah wan atu ohp̱anu amu eḏua diiadḵu.’ Naḏi anam awa aum.” ");
INSERT INTO gaw_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","Am iiṯa aḏi ag nai amu doona, ag oolag gamag ahehe, ag Kayaknu nai amu humidnana amu danab ah laala, ag Kayaknu bau hanhan dayak aoglagnu daap̱ig ele amu, ag oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","Aria Naḏinu nai amu laih ap̱a amu aben ohp̱a tuala uḵe doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","Ap̱anu ag Naḏinu nai doop̱ig amge Juda oḵai ag ahan, ab amup̱an iḵi danab amu ah laala onilag ele, ag Juda dilag meṯid ele dim lamidp̱ig amu, ag oolag yaaeg, ag ahan, Paulus Banabas ele amu a ab amup̱a daaeheh, eheḏ hatna geḏatp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","Ag anam heeg amu a baelahp̱anu wan gap̱ud amu ap̱an danab laala ag kobol eheḏ hep̱ig amunu ep̱onak keeke daaḵunu, a ab amu uuya goḵulahnu heyaya, a gap̱ud amu qeqaleh neene, a ahai, Aikoniam gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","Amu kristen ag oolagp̱a gamag ahak ena doyegeg, Kayak Ouḏi Nug ag oolagp̱a am qak dayom. ");
INSERT INTO gaw_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","Paulus Banabas ele a Antiok uuya, ahai Aikoniam goya, uḏat hanhan hepiḏ amu, ap̱a ele anam hepiḏ. A Juda dilag nai doyak lag oop̱a noya, nai mehuqpiḏ. A nai diig ena elele mehuqeheh, danab ah ameg naḏi, Juda Grik ele, ag oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","Amge Juda laala, ag oolagp̱a genab doyaknu uup̱ig ele amu, ag ahan, iiṯa aḏi amu ag oolag yaaeg, ag kristen dilag oolagp̱a aeg beum. ");
INSERT INTO gaw_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","Amunu Paulus Banabas ele a haen elab Aikoniam ap̱a a Naḏinu nai mehuqeheh, Naḏi Nug g̱agaṯag mate, a ep̱onak keeke, danab heḵunu elele iiṯa kuḏum diigdiig ele hepiḏ. Anam heeheh, amup̱a Naḏi Nug nuhig nai, amuam genab, danab ah ip̱uanaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","Ip̱uanaṯom amge danab ah ab amup̱an ag op̱atna, ameg aḏit daan, ameg laa ag Juda dilag nai amu doon, ag ele oolag laip̱u daap̱ig amge laa ag Paulus Banabas ele nai mehuqpiḏ amunu oolagp̱a genab doon, ag a ele oolag laip̱u daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","Anam daaegeg, dimp̱a iiṯa aḏi laala amu Juda laala amu ahilḵad iḵi danab ele ahan, Paulus Banabas ele eheḏ hatna, men aon maḵuḏatp̱eg mauhḵulahnu dab mep̱ig ");
INSERT INTO gaw_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","amge a amu dooya, a ahai oolya Likionia ab aḏit, Listra Debi ele, amu ab aḏit amu dilah wan taliliatak ele amu, a ap̱a goya oiya, ");
INSERT INTO gaw_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","aria ap̱a a Nai Ena danab ah amelagp̱a mehuqpiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","Am Listra ap̱a danab laa dayeye anidpiḏ. Nug baekuḏ nau amunu ii oiyom, dayakib dayom. Nug anig oop̱an baekuḏ amu anam ele doa, laa ii oiyom. ");
INSERT INTO gaw_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","Nug Paulus nai maṯieye doyeye, Paulus nug tutuḵu danab amu neeḵiṯa, nug nuhig oop̱a genab doyakp̱a eḏua ena daaḵunu elele anṯom ");
INSERT INTO gaw_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","amunu Paulus nug baag oḵaip̱a amegp̱a inam aum. “Na ahan hibaiṯe!” awa aum. Awa a amu danab amu laip̱un qa oṯaiya, aha hibaiṯa oiyom. ");
INSERT INTO gaw_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","Paulus nug anam heum amu ap̱an danab anidp̱ig ele, ag Likionia nailagp̱a inam ap̱ig. “Kayak aḏit aaḵu danab bia wanp̱a neya uḏiya, ihinigp̱a bepiḏ,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","Ag anam anana, Banabasnu amu ahilag kayak ham bup̱uak onig Sus amu aḏatona, Paulus, nug am nai maṯiom amunu nuhignu amu ag ahilag kayak ham bup̱uak onig Hemis ataḏp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","Amu ahilag kayak ham bup̱uak Susnu mana meṯak lag amu ab daugp̱a heeg dayom. Amu lag amunu mana meṯak danab nug bulmakau dawai diiaṯa amu bala muḏip̱a giaṯak ele diiaṯa, ab amunu aḏ odp̱a uḏie, nug danab ah ele ag doḏ main, Paulus Banabas ele mataglagnu hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","Amge totol danab aḏit, Banabas Paulus ele, a ag anam heḵulagnu heegeg, a nai amu dooya, ahilah lamen paṯiḏya, qaibaḏ danab ah oolagp̱a goya, eya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“Danab, ag aḏinu anam heṯeb? I ele am danab, ag biaib. I Nai Ena amu ag amelagp̱a mehuqṯep amu ag doon, ag keeke nau hamu meu iiṯa amu uuadna, ag Kayak bau daaṯe amu Nug dim lamidḵulagnu amelagp̱a aṯep. Nug am hab, wan, yu ele, amu keeke oh amup̱a daaṯeb ele, amu oh Nug haṯom. ");
INSERT INTO gaw_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","Haen anuḵa, Kayak Nug danab ah buḏub ohnu ag ib diigdiig goḵulagnu aib ii aum ");
INSERT INTO gaw_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","amge Nug daaṯe, Nug amunu haen amup̱a ele ag ip̱uanaṯaṯa, Nug hab aṯan dayaya he, gu ahilagp̱a neum, ahilag e ena beum, ag e elele aop̱ig amu ag gamalag ele ahom,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","Paulus Banabas ele a nai amu amelagp̱a madipiḏ amunu danab ah amu ag main ii matap̱ig amge Paulus Banabas ele wagainab ii melop am main matalob. ");
INSERT INTO gaw_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","Aria a Listra daaeheh, Juda laala Antioknu Aikoniamnu ele uḏiadp̱ig. Ag danab ah amu eeḏadna, Paulus qep̱eg mauhḵunu oolagp̱a noeg, ag menp̱a Paulus maḵuḏeg, mauhak bia niieye, ag eeḏna, ab giginp̱a gona mep̱ig. Ag, “Nug mauhom,” anana, anam hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","Ag anam hep̱ig amge laala Jesusnu oolagp̱a genab doop̱ig ele, ag uḏin, Paulus niieye, talilidna daaegeg, nug eḏua aha, ab amup̱a noum. Aria deḏ amu uue wagḏe, nug Banabas ele a eḏui Debi gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","Paulus Banabas ele a ab amup̱a Nai Ena amu mehuqya, ip̱uanadya heeh, danab ah kuḏum ag oolagp̱a genab doyegeg, dimp̱a a eḏui Listra, Aikoniam, Antiok ele gopiḏ. Antiok amuam Pisidia wanp̱a dayom. ");
INSERT INTO gaw_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","A goya, kristen g̱agaṯag aqai, ahilag oop̱a genab doyak na qemanu, ag g̱agaṯag daanna oiglagnu ayaya, inam ele apiḏ. “Tatam ig ug kuḏum aot oit, ig Kayaknu ḏo maḏoḏ oop̱a nota, bau hanhan dayak aognig,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","Anam heyaya amu a kristen tamaniak amu ohp̱a iḵi danab laala otiadya maadpiḏ. A e oh lanaknu kud meya daaiya, unuqidyaya, a kristen tamaniak amu oh diiya, Naḏi, ag nuhignu oolagp̱a genab doop̱ig ele amu, Nug ep̱egp̱a maadpiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","Amu dimp̱a a goya, Pisidia gamag tiḵui goya goya, Pampilia tepiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","A teya amu Pega abp̱a Nai Ena mehuqoya, dimp̱a amu a noya, Atelia gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","A Atelia noya amu ub laa anidya teeh, ub amu a diiata Antiok uḵom. Ab amup̱a anuḵa kristen tamaniak danab ag a Kayak ep̱egp̱a maateg, nuhig oo meṯak amu ahilagp̱a dayeyeb, a nuhig uḏat heḵulahnu ap̱ig. A uḏat amu heyaya, gemu a eḏui ap̱a uḏipiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","A uḏiya Antiok beya, a kristen tamaniak qag maaṯaya, a amelagp̱a Kayak ahilahp̱a aḏi heum amunu oh maṯiya, a inam ele apiḏ. “Kayak Nug he, iiṯa aḏi ag ele oolagp̱a genab doop̱ig,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","A kristen tamaniak amelagp̱a goya uḏat hepiḏ amunu awoya, a deḏ kuḏum ag ele ap̱a daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","Haen Paulus Banabas ele a Antiok ap̱a kristen tamaniak ele daaegeg amu danab laala ag Juda wanp̱anu uḏina, kristen amelagp̱a ap̱ig. “Laa nug Jesusnu oop̱a genab dooṯe amu nug gaḏa ele otaḏaḏ! Laa ag Mosesnu ḏo amu ii dim lamidna, gaḏalag ii otaḏḵulag amu aria geha Kayak Nug ag eḏua ii diiadma,” aon ip̱uanadna ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","Ag anam aon aeg, Paulus Banabas ele nai amu dooya, amunu ena ii dooya ahaeh, Juda ele huanak aeg ona aeg doum amunu kristen ag Paulus Banabas amu danab laala ele ag ahan, Jerusalem gop̱eg, totol danab amu iḵi danab ele ag nai amu bap̱aidḵulagnu otiadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","Amu kristen tamaniak ag heeg, ag ahan Pinisia Samaria ele gamalah tiḵun gonana, ag ap̱an kristen amelagp̱a, Kayak Nug he, iiṯa aḏi ag oolag eḏuom amunu amelagp̱a ap̱ig. Ag anam heegeg, kristen amu ag oolag gamag huana ahom. ");
INSERT INTO gaw_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","Ag anam henana gona, Jerusalem teeg, kristen tamaniak danab ah amu totol danab am iḵi danab ele ag ena humaṯeg, Paulus Banabas ele a keeke oh Kayak he hepiḏ ele, amunu amelagp̱a madipiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","A amu maṯieheh amu ḏo gumak danab-Parasia dilag huup̱an, ag Jesusnu oolagp̱a genab doop̱ig ele amu, ag ahan ap̱ig. “Kayak anuḵa gaḏa otaḏaknu ḏo meum niiṯe amunu iiṯa aḏi danab ag kristen daaglagnu oolag dayeb amu ag ele gaḏalḵad otaḏḵulagnab. Ele amu ig ap̱ut, ag Mosesnu ḏo oh ele dim lamidḵulag,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","Aeg amunu totol danab amu kristen tamaniak iḵi danab ele ag nai amu bap̱aidḵulagnu qag mep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","Qag mena ag amunu nai kuḏum maṯin hena, Petrus nug aha amelagp̱a aum. “O lailad, ag imu dooṯeb. Anuḵa Kayak Nug uḏat ig meḵowa, Nug da iiṯa aḏi amelagp̱a Nai Ena amu ap̱i, ag doon oolagp̱a genab dooglagnu, otiḏom. ");
INSERT INTO gaw_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","Amu Kayak, Nug danab ah oh oolag diig dooṯe ele amu, Nug iiṯa aḏi, ahilagnu oo ena dayom amu ig ip̱uniḵaḵa, Nug nuhig Ouḏi ig meḵom bia ag maṯom. ");
INSERT INTO gaw_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","Nug ihinigp̱a kobol laa haaha, ahilagp̱a kobol laa ii heum. Iiṯa, ag nuhignu oolagp̱a genab doyeg, ahilag oop̱a genab doyak amup̱a he, ag oolag op̱ia awak dayom. ");
INSERT INTO gaw_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","Ig anam anidṯem amge ag iiṯa aḏi ag Juda dilag ḏo oh dim lamidḵulagnu aṯeb, amup̱a ag keeke ug ele aon, kristen qaḏelagp̱a mena heṯeb. Anuḵa ig alanḵad amu ig ele ug amu mawaknu amu elele iiṯa. Ag aḏinu anam hep̱eg, Kayak Nug amunu op̱oḏi beḵunu heṯeb. ");
INSERT INTO gaw_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","Doyeg! Ig Kayak, Nug ehaniṯak oḵai, Jesus Kristus Nug hamu megṯe ele, amup̱a Nug ig eḏua awiḵom amubiaib Nug iiṯa aḏi ag ele amup̱a eḏua diiṯe, oonigp̱a genab dooṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","Am Petrus nug nai amu anam maṯie, ag qag mak amup̱a daap̱ig ele, ag nai laa ii madip̱ig. Ag nai ii maṯieg amu Paulus Banabas ele a nai maṯieheh, amuib dab meṯaegeg, a Kayak Nug a ep̱elahp̱a ep̱onak keeke, danab heḵunu elele iiṯa kuḏum, diigdiig ele, iiṯa aḏi oolagp̱a heum amunu madipiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","Paulus Banabas ele a nai amu maṯiya malaeh amu Jakobus nug aum. “O lailad, da nai imu ap̱i ag doyeg! ");
INSERT INTO gaw_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","Simon nug ag amelagp̱a a, ag aaḵu doop̱ig. Dig makp̱a Kayak Nug iiṯa aḏi dilagp̱a neum, nug nuhiḵud danab ah ag oolagp̱an amu diiaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","Amuam propet ag Kayak oḏe aon yaap̱ig amubia. Kayak naip̱a, nai amunu daaṯe am inam. ");
INSERT INTO gaw_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","17","‘Naḏi Nug aum. Da geha danab buḏub laa oh ag Naḏi maṯin anidḵulagnu, iiṯa aḏi oh, da ag dahilad tituanadmi amu, ag Naḏi maṯin anidḵulagnu, geha dimp̱a da eḏue uḏien, Dawit laug imu na qeeb, da geha eḏue hume qabaḵul. Lag imunu keeke oh nauheb, geha da bau eḏue hein qabaḵul. ");
INSERT INTO gaw_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","Anuḵa Kayak Nug nai amu maṯia aum amu gemu ele Nug anamib aṯe.’ ");
INSERT INTO gaw_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","Anam amu dahil dab mak amu inam, iiṯa aḏi ag oolag eḏueb, Kayak doop̱eg amu ig ag ug ii maṯamta. ");
INSERT INTO gaw_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","Iiṯa. Ig imuib uḏugp̱a yaat ap̱ut dooglag. ‘Ag doḏ laa main kayak ham bup̱uak medap̱ig ele amu, ag ii lamana. Ag gap̱ai kobol ii hemana. Amu danab ag doḏ muḏip̱a o ep̱elagp̱a baag aḏaeg mauhom amu ag tep̱u amu ii lamana. Aria ag doḏ tiig amu ele ii lamana.’ Ig amuib ap̱ut dooglag. ");
INSERT INTO gaw_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","Aḏinu? Ig dooṯem, anuḵan uḏie gemu ele, ab oḵai ohp̱a danab ag Mosesnu ḏo nai mehuqna, ag ele Juda dilag nai doyak lag ohp̱a nai amu eb qeṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","Jakobus nug nai amu a amu totol danab amu iḵi danab amu kristen tamaniak oh ele ag nai amu bap̱aidna, ag danab aḏit otiatp̱eg, a Paulus Banabas ele oh Antiok goḵulagnu dab mep̱ig. Ag anam dab mewona, ag Judas, onig laa Ba-Sabas amu Silas ele, danab aḏit amu a tamaniak oop̱a anuqak daapiḏ ele amu, a otiatona, ");
INSERT INTO gaw_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ag uḏug yak ele aoya goḵulahnu ep̱elahp̱a mep̱ig. Uḏugp̱a yaap̱ig am inam. “O lainḵad, ag Antiok, Siria amu Silisia ele daaṯeb, ag am iiṯa aḏi danab amu ig kristen tamaniaknu totol danab amu kristen tamaniaknu iḵi danab ele, ig ag lailḵad daaṯem amu ig pas imu ag eb qena dooglagnu iiḵu yaaṯem. O lainḵad ig ag humadṯem. ");
INSERT INTO gaw_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","Amu ig aaḵu anidmut. Ihinigp̱an danab laala ag gona, ag nai mehuqegeg, ag ap̱anu ag nai amu doon oṯaip̱ig. Amu ihinigp̱anu ag gona, nai maṯinna, ag ahilag dab mak kabolip̱ig ele amu, ag gona, ap̱a anam heḵulagnu amu ig laa ii amut. ");
INSERT INTO gaw_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","Ag gona anam heeg, nai amu uḏie ig doota, ig nai maṯit, oonig laip̱u meta, ig lainti aḏit goḵulahnu otiatmut. Amu ig lainti aḏit laa ele ig ahilahnu oonigp̱a huanak daaṯe ele, amuam Banabas Paulus ele, a ele aaḵu goḵulagnu amut. ");
INSERT INTO gaw_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","A amu ihinig Naḏi Jesus Kristus onignu a ug maoya mauhḵulahnu amu a ii baḏaṯep. ");
INSERT INTO gaw_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","Ig Judas Silas ele aaḵu heut, a oḏelahp̱a nai ig yaamut ele amu, a madipeḏ amu ag dooglag. ");
INSERT INTO gaw_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","Kayak Ouḏi Nug ig ele daata, ig nai imu maṯit inam amut. ‘Ig ḏo laa aot, ag qaḏelagp̱a ii memata. Ig ag imu iiḵuib dim lamidḵulagnu maidmut. ");
INSERT INTO gaw_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","Amu ag doḏ, laa ag main kayak ham bup̱uak medap̱ig ele amu, ag doḏ amu ii lamana. Ag doḏ tiig ele ii lamana. Amu danab ag doḏ muḏip̱a o ep̱elagp̱a baag aḏaeg mauhom amu, ag tep̱u amu ii lamana. Aria ag gap̱ai kobol ele ii hemana.’ Ag keeke amu oh tutuḵu dab meṯan, ii hemana am ena. Aaḵuib. Ag ena daaglagnu oonig daaṯe.” Ag anam yaap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","Aria kristen tamaniak ag otiadna, maaṯeg gona, Antiok nona amu ag kristen tamaniak qag maaṯan, ag uḏug yak amu madap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","Amu kristen tamaniak ag uḏug yak amu eb qena, ag g̱agaṯag aqak nai amunu ena doon, gamalag ahom. ");
INSERT INTO gaw_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","Amu Judas Silas ele, a am propet amunu a nai meu ele kristen ip̱uanadya, g̱agaṯag aqapiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","A anam heyaya, nakok haen elab Antiok daaeheh amu kristen ag ahilahnu oolag ena dayeye, a eḏuya Jerusalem tamaniakp̱a goḵulahnu heeh, “Enad uḵeḏ,” ap̱ig ");
INSERT INTO gaw_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","amge Silas nug Antiok daaḵunu dab meum. ");
INSERT INTO gaw_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","Aria Paulus Banabas ele a Antiok daaiya, Kayak nai danab ah ip̱uanaṯeheh, danab kuḏum laala ele oh uḏat amu henana, ag Jesusnu Nai Ena amu mehuqna ip̱uanadp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","Dimp̱a deḏ laala uḵe amu Paulus nug Banabas amegp̱a aum. “I ahaḏ eḏuḏ goḏa, ab ohp̱a anuḵa i Naḏinu Nai Ena amelagp̱a auḏ doop̱ig ele amu i laintad amu anadḵunih. Amu ag nai amu aḏan ena daaṯebtai o iiṯatai amu anadḵunih,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","Paulus nug anam awa a amu Banabas nug Jon Mak ele aweb oh goḵulagnu aum. ");
INSERT INTO gaw_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","Nug aum amge Paulus nug aum. “Jon Mak nug anuḵa Pampilia i uuite, nug ele oh uḏatp̱a ii gomut amunu i nug aopuḏ ii gomata,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","Paulus anam awa a amu a amunu nai oḵai maṯiya hepiḏ amunu a uḏatp̱a laip̱u baula ii oidpiḏ. Iiṯa. Banabas nug Jon Mak awe goḵulahnu a, ub laap̱a teya, Saipras gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","Uḵaeheh, Paulus nug Silas tituana awe amu kristen ag ap̱ig. “Naḏinu ehaniṯak oḵai hamu megṯe amu a ele uḵeḏ!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","Paulus nug Silas otiowa, nug uḵa, Siria Silisia ele gamagp̱a oiyaya, kristen tamaniak g̱agaṯag aqom. ");
INSERT INTO gaw_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","Nug anam haaha uḵa, Debi ta amu uḵa, Listra teum. Ab amup̱a kristen danab laip̱u laa dayom, nug onig Timotius. Nug Juda ah laa beḵa, mameg amu Grik danab. ");
INSERT INTO gaw_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","Listranu kristen am Aikoniamnu kristen ele ag hak nuhig amu anidna, “Timotius nug danab ena,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","Amu Paulus nug Timotius anṯa, oh goḵulahnu oo dayom amge Juda ag ap̱a daap̱ig ele amu ag doop̱ig, Timotius mameg nug am Grik danab amu Grik danab ag gaḏa otaḏak ii heṯeb, amunu Juda ag oolag nauhmanu Paulus nug aha, Timotius gaḏa otaḏom. ");
INSERT INTO gaw_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","Paulus nug anam he amu ag gona, ab abp̱a oina, totol danab, kristen tamaniak iḵi danab ele ag tatam Jerusalem qag mena nai ap̱ig amu ag kristen amelagp̱a ag ḏo waḏele amu dim lamidḵulagnu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","Kristen tamaniak ag nai doyegeg, Jesusnu oop̱a genab doyak ahilag am oḵai meeme, deḏ oh kristen dilag eb qak amu tuḏiṯeg oḵai meum. ");
INSERT INTO gaw_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","Aria Paulus Silas amu Timotius ele ag oiyegeg, Kayak Ouḏi Nug ag Nai Ena amu Asia ap̱a mehuqmananu ib oo neum amu Paulus aḏit laa ele amu ag ahan wan obatak aḏit onilah Prisia Galata ele amu gamagp̱a gonana amu ");
INSERT INTO gaw_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ag gona, Misia tomp̱a ap̱anu ag ahan Bitinia goḵulagnu heeg amu Jesus Ouḏi Nug ap̱a ele gomananu ib oo neum. ");
INSERT INTO gaw_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","Nug anam he amu ag Misia eḏidna nona, Troas gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","Aria Troas ap̱a tena, tuqanp̱a Kayak he, Paulus nug tuleglegp̱a Makedonia danab laa hibaiṯa dayaya, Paulus onigp̱a ewa, “Na ahan, yu mataḏna uḏin, ig ehaniḵe!” awa onigp̱a eewo anṯom. ");
INSERT INTO gaw_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","Paulus nug keeke amu anam anṯe aria wagḏe, ig ahat paha Makedonia goḵunignu ib maṯimut. Ig amut. “Ig doomut, Kayak Nug ig oninigp̱a eum, ig gota Nai Ena amu ag amelagp̱a mehuqp̱ut dooglagnu aum,” aot amut. ");
INSERT INTO gaw_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","Ig anam atata amu Troas ap̱anu ub laa aot teut, ub amu tutuḵu awiḵa, Samatres uḵe, wagḏe deḏ laa ap̱anu ahat, Niapolis gomut. ");
INSERT INTO gaw_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","Amu Niapolis ap̱a ub nug ig meiḵe, ig ahat baenigp̱a gota, Pilipai temut. Ab amuam Rom dilag ab oḵai laa, Makedonia wanp̱a anuqak dayom. Ig deḏ laala ab oḵai amup̱a daamut. ");
INSERT INTO gaw_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","Ap̱a daatta amu Juda dilag Meṯidp̱a ig, “Unuqiṯak aben le ihip̱a daaṯetai” atata, ig abnu aḏ odp̱a dimiṯim gota amu ig le ihip̱a gomut. Ig le amup̱a gota amu ah laala ag qag mena daaegeg anadta, ig daatta, ag amelagp̱a nai maṯimut. ");
INSERT INTO gaw_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","Amu ah laa onig Lidia, nug amu Kayak Jehowa doya unuqidṯom ele amu, nug nai amu doyom. Nug am ab oḵai Tiatiranu ah amu nug lamen ed haaha, amup̱a men doḏo aoṯom. Naḏi he, nug oo eḏue, Paulus Nai Ena mehuqeqe doya, dooḵunu nug daug humom. ");
INSERT INTO gaw_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","Nug nai doya, oo eḏue, layaṯak awe, nug baeḵudp̱a ele ag aop̱ig. Lidia layaṯak awowa, nug ig amenigp̱a aum. “Ag da Naḏinu oolp̱a genab dooṯem elele anidṯeb dayeb amu, aria ag uḏin, da laulp̱a dayeg!” awa aum. Nug anam anana, wagai ma he, ig nug oḏe dim lamidta, gota nug laugp̱a daamut. ");
INSERT INTO gaw_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","Deḏ laa ig unuqiṯak abenp̱a uḵaut, begbeg ah laa, nug oop̱a ouḏi nau ele, nug ibp̱a uḏanig teum. Ouḏi nau amu nug he, ah amu nug buṯi aḏi keeke aḏi beḵunu amu miag atiom. Amunu ah amunu gumak danab ag men doḏo kuḏumnab aodp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","Nug Paulus ig ele dim lamiḵaḵa amu nug inam ewa aum. “Danab imu amu, ag am Kayak aṯannabnu uḏat danab! Kayak Nug aṯem ha, ig eḏua diiḵunu ib babaiṯom ip̱unigṯeb,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","Nug kobol amu deḏ kuḏum he uḵe uḵe, Paulus nug oop̱a guiṯak doya, nug eḏua ouḏi nau amegp̱a aum. “Jesus Kristus onigp̱a na nug uuidḵutnu aṯem!” awa aum. Anam a amu ouḏi nau geha aaḵu ah amu uuiṯa uḵom. ");
INSERT INTO gaw_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","Aaḵu ah amunu gumak danab ag ahilag men doḏo awaknu diig amu iiṯa meum anidna, ag Paulus Silas ele aḏualatna, diiatna, qag mak abenp̱a gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","Ag Rom dilag heṯoḏiak danab noolagp̱a diiatna wana ap̱ig. “Danab aḏit imu, a am Juda danab amu, a kobol nau ig ap̱anigp̱a heṯep. ");
INSERT INTO gaw_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","Heyaya, a kobol nau, ig Rom danab amunu gun dooṯem, ig amu aognignu elele iiṯa amu, ig amu dim lamidḵunignu aṯep,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","Ag anam aegeg, ab amunu danab kuḏum laala ele anam aegeg, epeḏiak danab ag Paulus Silas ele beḏulahp̱anu lamen paṯiḏna, eheḏ mataḏatḵulagnu ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","Aria eheḏ mataḏateg, mani guiṯakp̱a maatna, gumak danab nug gumata auta aoḵunu amegp̱a ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","Aria mani guiṯak gumak danab nug nai g̱agaṯag amu doyowa, nug maate, mani guiṯak oop̱anab, aḏ nakok laap̱a noeh, adp̱a baelah qaḵom. ");
INSERT INTO gaw_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","Qaḵe anam daaiya, tuqan tugmag Paulus Silas ele Kayak unuqidyaya ahi edapiḏ. Anam heeheh, mani guiṯak danab laa ag doyatp̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","Ag anam daaegeg amu mim oḵai laa laip̱un na he, mani guiṯak lag amu oh uḏalele, od paha matulaṯe, muḏi g̱agaṯag hip̱aladp̱ig ele amu oh uhuqaṯom. ");
INSERT INTO gaw_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","Anam heehe, gumak danab nug aha, mani guiṯak lag od matulak anaṯowa, nug mani guiṯak danab oh oolna gop̱ig anana, nug qep oḵai awa, nug nugaḵa dug wa mauhḵunu heum ");
INSERT INTO gaw_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","amge Paulus nug huana ewa aum. “Na naḵa aib duut ome! Ig oh am iiḵu daaṯem,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","A amu mani guiṯak gumak danab nug doya, amahlaknu ewa, lag oop̱a noa, nug oṯaia baḏaḏa, nug Paulus Silas ele baelahp̱a na qeum. ");
INSERT INTO gaw_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","Na qa, eḏua aha, nug diiata dimiṯim wana, oḏ matom. “O danab aḏit, da aṯem hep̱i Kayak Nug da eḏua awiḏḵu?” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","Anam a amu a apiḏ. “Na Naḏi Jesusnu ootp̱a genab doop̱e, Kayak Nug na eḏua awidḵu, na amu na baenadp̱a ele oh eḏua diiadḵu,” aoya apiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","Anam awoya a Kayak nai, nug amu nug baeḵudp̱a ele, ag oh amelagp̱a madipiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","Amunu tuqan geha aaḵu nug a diiata, ihilah babaiṯe amu nug baeḵudp̱a ele oh ag layaṯak aop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","Aona amu nug diiata, laugp̱a uḵa, e matom. Nug, nug baeḵudp̱a ele oh ag oo gamag ahak aop̱ig. Aḏinu? Ag Kayaknu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","Daaeheh wagḏe buṯua amu epeḏiak danab ag heeg, daup danab laala uḏin mani guiṯak lag gumak danab amegp̱a ap̱ig. “Na danab aḏit amu uuatp̱e uḵeḏ!” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","Amu gumak danab nug doya, Paulus amegp̱a aum. “Epeḏiak danab ag nai meeg uḏiom am da a uhuqatp̱i, a dimiṯim doya goḵulahnu ap̱ig amunu a oolah ena dayebeb uḵeḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","Ag ap̱ig amu nug Paulus amegp̱a a doya, nug aum. “I amu Rom danab, amge ag i heṯoḏiakp̱a meitna, i eheḏ hemuḏtai o iiṯatai amu ag ii doop̱ig. Iiṯa, ag i danab ah noolagp̱a hamu aḏaitna, maḵuḏitnana, mani guiṯakp̱a hamu meitp̱ig. Ag anam hewona amu aḏinu ag gemu loḵumakp̱a henana, i dimiṯim goḵunihnu heṯeb? Ag anam ii hemana. Iiṯanab! Ag aḵa uḏin, i omaitp̱eg dimiṯim goḵunih,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","Paulus anam awa a aria daup ag nai amu aon eḏun gona, epeḏiak danab amelagp̱a aeg, epeḏiak danab ag Paulus Silas ele a am Rom danab doona, ag baḏap̱ig. Ag inam dab mep̱ig. “Ig Romnu ḏo tip̱almut amunu Paulus Silas ele apeḏ, Rom oḵai ag ig eheḏ laa heigḵulagtai,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","Ag anam doona, ag gona, oo mak nai amelahp̱a anana, omalateg dimiṯim doeh amu ag a ab amup̱a ii daamya, a ahai laih goḵulahnu oḏ matap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","Ag anam aeg amu a mani guiṯak laḵanu doya, a Lidia laugp̱a goya, a kristen anadya, g̱agaṯag aqaknu nai laala amelagp̱a ayaya amu gopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","Paulus Silas ele a Pilipainu ahai goya, Ampiolis teya, ap̱anu amu goya, Apolonia teya, ap̱a ele ii daapiḏ, a ab amu eḏidya goya, Tesalonika tepiḏ. Ab amup̱a amu Juda dilag nai doyak lag laa dayom. ");
INSERT INTO gaw_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","Amunu Paulus nug heṯom amubia ha, nug Juda dilag nai doyak lag oop̱a noa, Juda dilag Meṯid ewam amu oh nug anam heehe, nug ag ele Kayaknu yak amunu madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","Nug Kayak nai amu diig mehuqaqa amelagp̱a aum. “Kristus Nug nuhig uḏat ha malaḵunu amu Nug guiṯak naup̱a mauha, eḏua hip̱aidḵunu dayom,” awa aum. Nug nai mehuqe doyegeg, nug aum. “Jesus, da nuhignu ag amelagp̱a aṯem ele amu, Nug amu Kristus,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","Paulus nug Jesus Kristusnu nai mehuqe doona, Juda danab ah laala ag Jesusnu oolagp̱a genab doon, Paulus Silas ele dim lamatp̱ig. Grik danab kuḏum, ag Kayak doonna binag medap̱ig ele amu, ag ele Jesusnu oolagp̱a genab doop̱ig. Amu danab oḵai waalḵad kuḏum ele ag ele anam hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","Ag anam hep̱ig amge Juda oḵai ag amunu oolag nauhom amunu ag ahan, daḏek danab nau, danab amu ag keeke he nauhak danab, ag qag mak abenp̱a hamu daap̱ig ele amu, ag danab amunu kuḏumnab diin, qag maadna heeg, ag ahan heeg, ab amup̱an danab ag ahan muṯub qenan heegeg, danab nau ag Jeson laug amu oo meṯan, Paulus Silas ele aḏalatna diiatna dimiṯim gona, danab ah maṯaglagnu hep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","Ag anam hep̱ig amge ap̱a ii anatna, ag Jeson amu kristen laala ele eeḏaṯeg neeg, diin ab amup̱anu iḵi danab gumadna gona, ag inam aon ep̱ig. “Danab nau amu kobol nau wan ohp̱a heeg beṯe ele amu gemu ag uḏin, ip̱a heṯeb. ");
INSERT INTO gaw_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","Ag uḏieg, Jeson nug diiata, laugp̱a uḵom. Ele amu danab amu oh ag Kaisanu ḏo amu tap̱aeg ne henana, ag inam aṯeb. ‘King laa daaṯe, nug onig Jesus,’ aon aṯeb.” Ag anam ep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","Ab amup̱an danab oh, iḵi danab ele ag nai amu doona, ag oṯaina eheḏ doonna ");
INSERT INTO gaw_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","amu iḵi danab ag heeg, Jeson nug laala ele ag dimp̱a genab heṯoḏiakp̱a eḏun beḵulagnu amu ag daden meeg, heeg gop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","Anam heeg, kristen ag tuqan amup̱aib Paulus Silas ele maateg, ab amu uuya Beria gopiḏ. A Beria teya amu Juda dilag nai doyak lag oop̱a nopiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","Am Juda danab Beria daap̱ig ele amu, ag dab mak ena ele, ag Juda danab Tesalonika daap̱ig amu eḏadna, ag oolag gamag ahak ena ele nai aon dab makp̱a mep̱ig. Ag Paulus nug nai aṯom amu genabte o iiṯa genab iiṯate amu dooglagnu deḏ ohp̱a Kayak nai eb qep̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","Amu Paulus nai mehuqeqe, Juda danab ah ab amup̱an kuḏum laala ag Jesusnu oolagp̱a genab doop̱ig. Am Grik danab ah binalag ele kuḏum ele ag Jesusnu oolagp̱a genab doop̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","Genab doyegeg, dimp̱a Juda Tesalonikanu ag Paulus nug Beria ap̱a nai mehuqṯe amu doonna amu ag ahan, Beria gona, ahilag hak nau amu aon, danab ah ap̱anu amu oolagp̱a noeg amu doon oṯaina, ahan heegeg, ");
INSERT INTO gaw_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","amu kristen ag paha ahan, Paulus aon meeg noa, yu ihip̱a goḵunu ugeḵe, Silas Timotius ele a amu Beria daapiḏ. ");
INSERT INTO gaw_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","Danab Paulus omaleg gop̱ig ele ag omalna gona, Atens tena, uuidna eḏun goḵulagnu heegeg, Paulus nug Silas Timotius ele dilah nai amu ag aon gona ap̱eg dooglahnu inam aum. “A paha uḏiya, da aniḏeḏ!” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","Amu Paulus nug Atens ap̱a Silas Timotius ele amelah maama, nug ab amup̱a kayak ham bup̱uak doṯolag amu kuḏumnab anaṯa, nug keeke amunu oo huanak nauhom. ");
INSERT INTO gaw_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","Paulus nug oop̱a anam doyaya, nug Juda dilag nai doyak laḵa uḵe, Juda danab amu iiṯa aḏi danab ag Kayaknu doonna, binag mep̱ig ele amu, ag ele nai madip̱ig. Amu nug deḏ oh e oḏiak abenp̱a uḵe, danab ah uḏinna daaṯeb amu, ag ele nai madip̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","Amu nug anam heehe, aria doyak danab ameg aḏit daap̱ig ag nug ele aeg ona aeg doum. Doyak danab ameg laa amu ag Epikuriannu nai aḏap̱ig, laa amu Stoiknu nai aḏap̱ig. Ag oolagp̱a laala Paulusnu inam ap̱ig. “Danab umu nug aḏi nai mauhnoak madiṯe?” Aegeg, Paulus nug Jesusnu amu mauha eḏua hibaiṯaknu nai ele maṯiom amunu laa ag ap̱ig. “Nug ab laap̱an dilag Kayak, ig ii dooṯem ele, amunutai nai mehuqṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","Ag anam maṯina, Paulus aon, ag qag ma nai maṯiak lag oḵai, ag amunu Ariopagas aṯeb amu, ag ap̱a gona, “Ig na nai bau danab ah ip̱uanadṯem amu doognignu oonig daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","Ag anam anana, ag tuḏidna ap̱ig. “Nai na maṯie doomut am nai baunab amunu ig nai amu diig doognignu oonig daaṯe,” aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","Amu Atens danab oh amu danab laihnu uḏiak Atens daap̱ig ele oh, ag uḏat laanu amu dab ii mep̱ig. Iiṯa, ag nai baunu maṯin, diig anidna, nai bau amu dooglagnu amuib henan daap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","Aria ag Paulus aon uḵaeg, heṯoḏiak aben onig Ariopagas amup̱a tena, nug amegp̱a anam aeg amu nug aha amelagp̱a maṯia aum. “Atens danab, da ag anadmi, ag kayak diigdiig binalag maknu amu ag bahilag ii yaaṯe. ");
INSERT INTO gaw_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","Da uḏien, da tatam ab maṯe oiyeye, ag ahilḵad kayak diigdiig amu binalag menan daaṯeb abenlag anadmi. Amu da qaḏab laa ele nuhigp̱a ag, ‘Imu nug am kayak laanu, ig nug ii dooṯem ele,’ anam yaap̱ig dayeye anidmi. Aria Kayak amu ag ii dooṯeb, ag Nug binag hamu meṯeb ele amu, gemu da nuhig nai amu mehuqp̱i, ag dooglag,” awa aum. ");
INSERT INTO gaw_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","Paulus nug anam anana, nug tuḏiṯa aum. “Amu Kayak Nug wan imu hewowa, keeke oh wanp̱a daaṯeb, laa ig anadṯem, laa ig ii anadṯem ele amu, Nug heum. Kayak amu Nug habnu, wannu ele Naḏi daaṯe amunu Nug meṯid lag, danab ep̱elagp̱a heṯeb, amu oop̱a, Nug ii daaṯe. ");
INSERT INTO gaw_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","Amu Kayak Nug keeke laanu tutu meṯete amunu ig danab ig Nug ehanidḵunig? Iiṯa. Nug nuḵa eleleib daaṯe. Nug nuḵaib bau dayaknu ouḏi, bau dayak amu keeke laa oh ele ig danab oh ig megaṯe. ");
INSERT INTO gaw_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","Amu danab ah buḏub oh amu Nug ag alalag laip̱u heum amu nuhigp̱anuib ag bena ap̱atp̱ig. Ap̱ateg, Nug he, ag gona, wan ohp̱a daaegeg, Nug nuḵa haen ahilag maṯa, ap̱alag ele maṯom. ");
INSERT INTO gaw_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","Amu Kayak Nug danab oh Nug dooglagnu oo daaṯe amunu ag wagai mena bahi qenana, Nug daaṯe tutuḵu anidḵulagnu keeke amu oh heum. Amge Nug ig laib laib ohp̱a uma ii daaṯe. ");
INSERT INTO gaw_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","Aḏinu? Nuhigp̱a ig bau ena dayak aotut, Nug ig g̱agaṯag megeḵe, ig oiṯem. Amu ig nuhigp̱aib aaḵu ena daaṯem. Ahilḵad doyak danab laala ag ele amunu inam ap̱ig. ‘Ig ele Nug beḵod daaṯem,’ aon ap̱ig. ");
INSERT INTO gaw_vpl VALUES ("AC17_29","07