﻿USE sofia;
DROP TABLE IF EXISTS sofia.gaq_vpl;
CREATE TABLE gaq_vpl (
  verseID VARCHAR(16) NOT NULL PRIMARY KEY,
  canon_order VARCHAR(12) NOT NULL,
  book VARCHAR(3) NOT NULL,
  chapter VARCHAR(3) NOT NULL,
  startVerse VARCHAR(3) NOT NULL,
  endVerse VARCHAR(3) NOT NULL,
  verseText TEXT CHARACTER SET UTF8 NOT NULL) ENGINE=MyISAM;
LOCK TABLES gaq_vpl WRITE;
INSERT INTO gaq_vpl VALUES ("MT1_1","070_1_1","MAT","1","1","1","ଅବ୍ରାହାମ୍‍ନେ ଉଂଡେ ଆରି ଦାଉଦନେ ଉଂଡେ ଜିସୁ କିସ୍‌ଟନେ ବଁସ୍‌କୁଲ୍ଇଂ । ");
INSERT INTO gaq_vpl VALUES ("MT1_2","070_1_2","MAT","1","2","2","ଅବ୍ରାହାମ୍‍ନେ ଉଂଡେ ଯିସହାକ; ଇସ୍‌ହାକ୍‌ନେ ଉଂଡେ ଜାକୁବ୍‌; ଜାକୁବ୍‌ନେ ଉଂଡେ ଜିଉଦା ଆରି ମେଁନେ ବୟାଁଣ୍ଡେଇଂକେ ଜନମ୍ ବିକେ ");
INSERT INTO gaq_vpl VALUES ("MT1_3","070_1_3","MAT","1","3","3","ଜିଉଦା ଆରି ତାମରନେ ଉଂଡେ ଫେରସ ଆରି ଜେରହ; ଫେରସନେ ଉଂଡେ ହେସ୍ରୋଣ; ହେସ୍ରୋଣନେ ଉଂଡେ ଆରାମ; ");
INSERT INTO gaq_vpl VALUES ("MT1_4","070_1_4","MAT","1","4","4","ଆରାମ୍‌ନେ ଉଂଡେ ଅମିନାଦାବ; ଅମିନାଦାବନେ ଉଂଡେ ନହଶୋନ; ନହଶୋନନେ ଉଂଡେ ସଲ୍ମୋନ; ");
INSERT INTO gaq_vpl VALUES ("MT1_5","070_1_5","MAT","1","5","5","ସଲମନ୍‌ ଆରି ରାହାବନେ ଉଂଡେ ବୋୟଜ୍; ବୋୟଜ୍ ଆରି ଋତନେ ଉଂଡେ ଓବେଦ୍; ଓବେଦନେ ଉଂଡେ ଯେଶି । ");
INSERT INTO gaq_vpl VALUES ("MT1_6","070_1_6","MAT","1","6","6","ଯିଶୀନେ ଉଂଡେ ଦାଉଦ ଇଃସାଙ୍ଗ୍‌ । ଦାଉଦ ଉରିୟନେ କୁନୁଏଃଡ଼େନେ ଗର୍‌ବେବାନ୍‌ ଶଲୋମନ୍‌କେ ଜନମ୍‌ ବିଃକେ; ");
INSERT INTO gaq_vpl VALUES ("MT1_7","070_1_7","MAT","1","7","7","ଶଲୋମନ୍‌ନେ ଉଂଡେ ରହବୟାମ; ରହବୟାମନେ ଉଂଡେ ଅବିୟ; ଅବିୟନେ ଉଂଡେ ଆସା । ");
INSERT INTO gaq_vpl VALUES ("MT1_8","070_1_8","MAT","1","8","8","ଅବିୟନେ ଉଂଡେ ଆସା; ଆସାନେ ଉଂଡେ ଯିହୋଶାଫଟ୍; ଯିହୋଶାଫାଟ୍‌ନେ ଉଂଡେ ଯୋରାମ; ଯୋରାମନେ ଉଂଡେ ଉଜ୍ଜିୟ; ");
INSERT INTO gaq_vpl VALUES ("MT1_9","070_1_9","MAT","1","9","9","ଉଜ୍ଜିୟନେ ଉଂଡେ ଯୋଥାମ୍; ଯୋଥାମ୍‌ନେ ଉଂଡେ ଆହାଜ; ଆହାଜନେ ଉଂଡେ ହିଜକିୟ; ");
INSERT INTO gaq_vpl VALUES ("MT1_10","070_1_10","MAT","1","10","10","ହିଜକିୟନେ ଉଂଡେ ମନଶେହ; ମନଶେହନେ ଉଂଡେ ଆମୋନ; ଆମୋନ ଯୋଶିୟକେ ଜନମ୍ ବିକେ ");
INSERT INTO gaq_vpl VALUES ("MT1_11","070_1_11","MAT","1","11","11","ବାବିଲୋନ୍‍ ଦେସ୍‌ନ୍ନିଆ ଗାଗ୍‌ଚେ ଡୁଙ୍ଗ୍‌ୱେନେ ବେଲା ଆମୋନନେ ଗଡ଼େଅ ଯୋଶିୟ; ଯୋଶିୟନେ ଉଂଡେ ଯିଖନିୟ ଆରି ମେଁନେ ବୟାଁଇଂ ଜନମ୍ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT1_12","070_1_12","MAT","1","12","12","ଯିଖନିୟନେ ଉଂଡେ ଶ‍ଅଲ୍‌ଥୀୟେଲ ବାବିଲୋନ୍‍ନ୍ନିଆ ଜନମ୍ ଡିଂକେ । ଶ‍ଅଲ୍‌ଥୀୟେଲନେ ଉଂଡେ ଜିରୁବାବେଲ; ");
INSERT INTO gaq_vpl VALUES ("MT1_13","070_1_13","MAT","1","13","13","ଜିରୁବାବେଲନେ ଉଂଡେ ଅବୀହୁଦ୍; ଅବୀହୁଦ୍‌ନେ ଉଂଡେ ଏଲିୟାକିମ; ଏଲିୟାକିମନେ ଉଂଡେ ଅଜ୍‌ଜୂର; ");
INSERT INTO gaq_vpl VALUES ("MT1_14","070_1_14","MAT","1","14","14","ଅଜ୍‌ଜୂରନେ ଉଂଡେ ସାଦୋକ; ସାଦୋକନେ ଉଂଡେ ଯାଖୀନ; ଯାଖୀନନେ ଉଂଡେ ଏଲୀହୁଦ; ଏଲୀହୁଦନେ ଉଂଡେ ଏଲାଜାର; ଏଲାଜାରନେ ଉଂଡେ ମତ୍‌ଥାନ; ");
INSERT INTO gaq_vpl VALUES ("MT1_15","070_1_15","MAT","1","15","15","ଏଲୀହୁଦ ଏଲୀୟାଜର୍‌କେ ଜନମ୍ ବିକେ ଏଲୀୟାଜରନେ ଉଂଡେ ମତ୍‌ଥାନ; ମତ୍‌ଥାନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌; ଜାକୁବ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଯୋସେଫ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("MT1_16","070_1_16","MAT","1","16","16","ମତ୍ତାନ ଜାକୁବ୍‌କେ ଜନମ୍ ବିକେ ଜାକୁବ୍‌ ମରିୟମ୍‌ନେ ଆଣ୍ଡା ଯୋସେଫ୍‌କେ ଜନମ୍ ବିକେ ଏନ୍ ଯୋସେଫ୍‌ ମରିୟମ୍‌କେ ବିହେ ଡିଙ୍ଗ୍‌ଲେଃଗେ । ମରିୟମ୍‌ନେ ସୁଲୁଏ ବାନ୍‌ ଜିସୁ ଜନମ୍‌ ଡିଙ୍ଗ୍‌କେ । ଜିସୁ କିସ୍‌ଟ ମସୀହ ମ୍ନିରେ ଡିଗ୍‌ ସ୍ନାମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("MT1_17","070_1_17","MAT","1","17","17","ଦେକ୍‌ରକମ୍ ଅବ୍ରାହାମ୍‌ନେ ବାନ୍‌ ଦାଉଦନେ ଜାକ ଚଉଦ ପୁରୁସ୍‌; ଦାଉଦନେ ବାନ୍‌ ବାବିଲୋନ୍‍କେ ଗାଗ୍‌ଚେ ଡୁଙ୍ଗ୍‌ୱେନେ ଜାକ ଚଉଦ ପୁରୁସ୍‌ ବାରି ବାବିଲୋନ୍‍ ବାସାନେ ଜାକ କିସ୍‌ଟନେ ଜନମ୍‌ ଜାକ ଚଉଦ ପୁରୁସ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("MT1_18","070_1_18","MAT","1","18","18","ଏନ୍ ଡିଂକେ ଜିସୁ କିସ୍‌ଟନେ ଜନମ୍‌ ବିସୟ୍ । ମେଁନେ ଇୟାଙ୍ଗ୍ ମରିୟମ୍‌ନେ ଯୋସେଫ୍‌ନେ ଏତେ ମାଗ୍‌ନି ଡିଙ୍ଗ୍‌ଲେଃଗେ । ମାତର୍‌‌ ମେଁଇଂନେ ବିହେ ମାଡାନେ ସେନୁଗ୍‌ ମରିୟମ୍ ମ୍ୟାକେ ଜେ ପବିତ୍ର ଆତ୍ମାନେ ବାନ୍‌ ମେଁ ଗାଗ୍‌ଡ଼େ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT1_19","070_1_19","MAT","1","19","19","ଯୋସେଫ୍‌ ଦରମ୍‌ ରେମୁଆଁ ଲେଃଗେସାଃ କାଲାଆଃ ନିମାଣ୍ଡା କାମ୍ ଡିଂଡିଙ୍ଗେ । ଏଲେଡିଗ୍ ମରିୟମ୍‌କେ ରେମୁଆଁନେ ନିନ୍ଦା ବାନ୍‌ ରକ୍ୟା ଡିଙ୍ଗ୍‌ନ୍‌ସା କଲେନା ମାଗ୍‌ନିକେ ମନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଉପାୟ୍ ତୁର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT1_20","070_1_20","MAT","1","20","20","ମେଁ ଏନ୍ ବାବେକେଲା ମୁଇଂ କିତଂ ଦୁତ୍‌ ଆମେକେ ମୁସୁଡ଼ିଙ୍ଗ୍‌ନ୍ନିଆ ଆତ୍ନାଚେ ବାସଙ୍ଗ୍‌କେ “ଅ ଦାଉଦ କୁଲ୍‌ନେ ଯୋସେଫ୍‌ । ମରିୟମ୍‌କେ ସେଲାମ୍ବୁଏ ଡାଗ୍‌ଚେ ଗ୍ର‍ଅନ୍‌‌ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆବ୍‌ଟଗେ ନାମଃ, ଡାଗ୍ଲା ପବିତ୍ର ଆତ୍ମା ବାନ୍‌ ମରିୟମ୍ ଗାଗ୍‌ଡ଼େ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT1_21","070_1_21","MAT","1","21","21","ମେଁନେ ମୁଇଂ ଗଡ଼େଅ ଜନମ୍‌ ଡିଙ୍ଗ୍‌ଏ । ମେଁନେ ମ୍ନି ଜିସୁ ନାବିଏ, ଡାଗ୍ଲା ମେଁ ନିଜର୍‌ ରେମୁଆଁଇଂକେ ପାପ୍‌ବାନ୍‌ ରକ୍ୟା ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT1_22","070_1_22","MAT","1","22","22","ଇସ୍‌ପର୍ ମୁଇଂ ବାବବାଦିନେ ବାନ୍‌ ମୁଡ଼ିନେ ବବିସତ୍‌ ସାମୁଆଁ ଆଃଅଁ ବକେ ଆତାନ୍‌ ସତ୍‌ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଏନ୍ ସାପା ଗଟେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT1_23","070_1_23","MAT","1","23","23","ଆତେନ୍‌‌ ବବିସତ୍‌ ସାମୁଆଁ ଡିଂଡିଂକେ, “ମୁଇଂ ସେଲା ଗାଗ୍‌ଡ଼େଚେ ଗଡ଼େଅ ମୁଇଂ ଜନମ୍‌ ବିଃଏ । ଆତେନ୍‌‌ ଗଡ଼େଅ ଇମ୍ମାନୁୟେଲ” ମ୍ନିରେ ୱାଆର୍‌ଏ । ଇମ୍ମାନୁୟେଲ ଅର୍‌ତ “ଇସ୍‌ପର୍ ନେଁ ଏତେ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT1_24","070_1_24","MAT","1","24","24","ଯୋସେଫ୍‌ ଡୁଲେଗ୍‌ଚେ ତଡ଼ିଆକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମେଁ କିତଂ ଦୁତ୍‌ନେ ଆଦେସ୍‌ ଅନୁସାରେ ସ୍ଲେ ଡିଙ୍ଗ୍‌କେ । ମେଁ ମରିୟମ୍‌କେ ବିହେ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT1_25","070_1_25","MAT","1","25","25","ମାତର୍‌‌ ମେଁନେ ଆତାନ୍‌ ଉଙ୍ଗ୍‌ଡେ ଜନମ୍‌ ଡିଙ୍ଗ୍‌ ଜାକ ମରିୟମ୍ ଏତେ ଆକୁଡ଼େଃ ଆମାଡ଼େଃକେ ଣ୍ତୁ । ଯୋସେଫ୍‌ ଆତେନ୍‌‌ ଉଙ୍ଗ୍‌ଡେକେ ଜିସୁ ମ୍ନି ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_1","070_2_1","MAT","2","1","1","ହେରୋଦ ଇଃସାଙ୍ଗ୍‌ନେ ସାସନ୍‍ ବେଲା ଜିଉଦା ପ୍ରଦେସ୍‌ନେ ବେଥ୍‌ଲେହିମ ଇନିନ୍ନିଆ ଜିସୁ ଜନମ୍ ଡିଙ୍ଗ୍‌କେ । କ୍ମେନେ ଇକୁଡ଼ା ବେଲା ଇଡ଼ିଙ୍ଗ୍ ପୁର୍ବ ଦେସ୍‌ନେ ଉଡ଼ିରୁଆ ପଣ୍ତିତ୍‌ ଯିରୂଶାଲମନ୍ନିଆ ପାଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାକୁଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT2_2","070_2_2","MAT","2","2","2","“ଆଣ୍ତିନେ ଗଡ଼େଅ ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ଡିଙ୍ଗ୍ ନ୍‌ସା ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେକେ ମେଁ ଆଣ୍ତିକା ? ପୁର୍ବ କିତଂନ୍ନିଆ ମେଁନେ ଚାଙ୍କୁଆ କେଚେ ଆମେକେ ସାର୍ଲ ନ୍‌ସା ପାଙ୍ଗ୍‍ନେଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT2_3","070_2_3","MAT","2","3","3","ମେଁଇଂନେ ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ ଇଃସାଙ୍ଗ୍‌ ହେରୋଦ ଆରି ଯିରୂଶାଲମନ୍ନିଆ ବାସା ଲେଃଗ୍ନେ ରେମୁଆଁଇଂ ତେରେପେତେ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_4","070_2_4","MAT","2","4","4","ହେରୋଦ ସାପା ମ୍ନା ଜାଜକ ଆରି ଦରମ୍ ଗୁରୁଇଂକେ ୱାଚେ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ “ମସିହ ବା କିସ୍‌ଟ ଆଣ୍ଡିଅରିଆ ଜନମ୍ ଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ମେଇଂନେବାନ୍‌ ବିଜେନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT2_5","070_2_5","MAT","2","5","5","ମେଇଂ ଉତର୍ ବିକେ “ଜିଉଦା ପ୍ରଦେସ୍‌ନେ ବେଥ୍‌ଲେହିମ ଡାଗ୍ରା । ଏନ୍‌ ବିସୟ୍‌ରେ ମୁଇଙ୍ଗ୍ ବାବବାଦି ଗୁଆର୍ ବକେ ");
INSERT INTO gaq_vpl VALUES ("MT2_6","070_2_6","MAT","2","6","6","ଅ ଜିଉଦା ପ୍ରଦେସ୍‌ନେ ବେଥ୍‌ଲେହିମ ନାନେ ଜିଉଦାନେ ମ୍ନା ଇନି‍ଇଂନେ ବିତ୍ରେ ଡିରକମ୍ ଡିଗ୍ ଡାଆଁ ଣ୍ତୁ ଡାଗ୍ଲା ଜା ନେନେ ଇଶ୍ରାୟେଲୀୟ ରେମୁଆଁଇଂକେ ଲାଲନ୍‍ ପାଲନ୍‍ ଡିଙ୍ଗ୍‌ଏ ଦେକ୍‌ରକମ୍ ମୁଇଂଜା ସାସନ୍‍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ନେତା ନାନେ ବାନ୍ ପୁଏତାର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT2_7","070_2_7","MAT","2","7","7","ଏନ୍‌ ଅଁଚେ ହେରୋଦ ମାମ୍ୟାଚେ ପୁରୁବ୍‌ ଦେସ୍‌ନେ ଆତେନ୍‌ ପଣ୍ତିତ୍‌ଇଂକେ ରେମୁଆଁ ଗଣ୍ଡ୍ ଣ୍ଡୁନ୍ନିଆ ୱାଚେ ଆତେନ୍‌ ଚାଙ୍କୁଆ ଉଡ଼ି ବେଲା ତ୍ନାକେ ଏନ୍‌ ମେଁଇଂନେ ବାନ୍ ବୁଜେ ଡୁଂଡ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_8","070_2_8","MAT","2","8","8","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଆମେଇଂକେ ବେଥ୍‌ଲେହିମ ଇନିନ୍ନିଆ ବେବିଚେ ବାସଙ୍ଗ୍‌କେ “ୱେଲାପା ଆତେନ୍‌ ଗଡ଼େଅକେ ନିମାଣ୍ତା ବାବ୍‌ରେ ତୁର୍‌ପା ବାରି ଆମେକେ ଅବାଲା ଆନେଙ୍ଗ୍‌କେ ଆମ୍ୟାପା ନେଙ୍ଗ୍ ଡିଙ୍ଗ୍ ୱେଚେ ଆମେକେ ନ୍‌ସାର୍‌ଲଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT2_9","070_2_9","MAT","2","9","9","ଆତ୍‌ବାନ୍ ମେଇଂ ଇଃସାଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁଚେ ତାର୍‌ୱେଆର୍ଗେ; ବାରି ମେଇଂ ପୁର୍ବ ଦେସ୍‍ନ୍ନିଆ ଆଣ୍ଡିନେ ଚାଙ୍କୁଆ କେଲେଃଆର୍କେ ଆତେନ୍‌ ମେଁଇଂନେ ସେନୁଗ୍‌ ସେନୁଗ୍‌ ୱେକେ ଆଣ୍ଡିଅରିଆ ଗଡ଼େଅ ଲେଃକେ ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ଜାଗା ଆଡ଼ାତ୍ରା ଅଟ୍‌କେ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_10","070_2_10","MAT","2","10","10","ପଣ୍ଡିତ୍ଇଂ ଚାଙ୍କୁଆକେ କେଚେ ଜବର୍ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଆର୍କେ । ମେଇଂ ସାର୍ଦାରେ ବର୍ତି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_11","070_2_11","MAT","2","11","11","ବାରି ଡୁଆ ବିତ୍ରେ ୱେଚେ ଗଡ଼େଅକେ ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ମରିୟମ୍ ଏତେ ଲେଃକ୍ନେ କେଆର୍‌କେ ଆରି ଆମେକେ ସାର୍ଲ ଆର୍‌କେ ବାରି ନିଜର୍ ନିଜର୍ ପିଡ଼ି ତଚେ ସୁନା ଜାବର୍‌ ଦାମ୍‍ନେ ଦୁପ୍‌ ଆରି ବାସ୍ନାଚୁ ଆଃତାର୍‌ଚେ ଆମେକେ ପୁରୁସ୍କାର୍‌ ବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_12","070_2_12","MAT","2","12","12","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ମେଇଂ ବିନ୍ ମୁଇଙ୍ଗ୍ ଗାଲି ବିଚେ ନିଜର୍ ଦେସ୍‌ନ୍ନିଆ ଆଣ୍ତେ ୱିଗ୍‌ଆର୍‌କେ । ଡାଗ୍ଲା ହେରୋଦନେ ଡାଗ୍ରା ଆଣ୍ତେ ଆୱିଗ୍ ନ୍‌ସା ଇସ୍‌ପର୍ ଆମେଇଂକେ ମୁସୁଡ଼ିଙ୍ଗ୍‌ନ୍ନିଆ ବାଲିର୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_13","070_2_13","MAT","2","13","13","ମେଇଂ ୱିଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଇସ୍‌ପର୍‌ନେ ଦୁତ୍ ଯୋସେଫ୍‌କେ ମୁସୁଡ଼ିଙ୍ଗ୍‌ନ୍ନିଆ ଦର୍‌ସନ୍‌ ବିଃଚେ ବାସଙ୍ଗ୍‌କେ, “ହେରୋଦ ଗଡ଼େଅକେ ବାଗୁଏ ନ୍‌ସା ତୁର୍ ଅଲେଙ୍ଗ୍‌ଡିଂକେ । ତେସା ତଡ଼୍ୟା ଗଡ଼େଅକେ ଆରି ମେଁ ଇୟାଙ୍ଗ୍‌ଡେକେ ସାଚେ ମିସର୍ ଦେସ୍‌ନ୍ନିଆ ଲାଗ୍‍ଡଲାପା । ବାରି ଆତେନ୍‌ ଜାଗା ଆନ୍ତାର୍ ନ୍‍ସା ମାବାଲିର୍ ଜାକ ଆତ୍‌ତେ ଲାଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT2_14","070_2_14","MAT","2","14","14","ଯୋସେଫ୍‌ ତଡ଼୍ୟାଚେ ଗଡ଼େଅକେ ଆରି ମେଁନେ ଇୟାଙ୍ଗ୍‌କେ ସାଚେ ମିଡିଗ୍‌ବ ମିସର୍ ଦେସ୍ ଲାଗ୍‌ଡ‍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_15","070_2_15","MAT","2","15","15","ହେରୋଦ ଗୁଏ ଜାକ ମେଇଂ ଆତ୍‌ଅରିଆ ଲେଃଆର୍‌କେ । ଏନ୍‌ ସାପା ଗଟେକ୍ନେ ବାନ୍ ବାବବାଦିଇଂନେ ବବିଷ୍ୟତ୍ ମାପ୍‌ରୁନେ ଏନ୍‌ ସାମୁଆଁ ପୁରନ୍ ଡିଙ୍ଗ୍‌କେ । ମେଁ ବାସଙ୍ଗ୍ ବଗେ “ନେଙ୍ଗ୍ ନେଉଂକେ ନେଙ୍ଗ୍ ମିସର୍ ଦେସ୍‌ବାନ୍ ୱା ଡୁଂମ୍ପାଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT2_16","070_2_16","MAT","2","16","16","ପୁର୍ବ ଦେସ୍‌ବାନ୍ ପାଙ୍ଗ୍‌ଲେଃକ୍ନେ ପଣ୍ଡିତ୍ଇଂ ଆମେକେ ବକୁଆ ଆଡିଙ୍ଗ୍‌ଚେ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ମ୍ୟାଚେ ହେରୋଦ ଜାବର୍ ଗିସେ ଡିଙ୍ଗ୍‌କେ ବାରି ଚାଙ୍କୁଆ ତାର୍‌କ୍ନେ ବେଲା ବିସୟ୍‌ରେ ପଣ୍ତିତ୍‌ଇଂନେ ବାନ୍ ମେଁ ମେଁନେ ଅଁଲେକେ ଦେତ୍ ରକମ୍ ମେଁ ଗଡ଼େଅଇଂନେ ବୟସ୍‌ ବେଲା ମ୍ୟାଲେକେ । ବେଥ୍‌ଲେହିମ ଆରି ମେଁନେ ପାକାପାକି ଅଞ୍ଚଲ୍‌ନ୍ନିଆ ଲେଃକ୍ନେ ମ୍ବାର୍‌ ମୁଆଁ ଆରି ଆତେନ୍‌‌ବାନ୍ କମ୍‌ ବୟସ୍‌ନେ ସାପା ଗଡ଼େଇଂକେ ବାଗୁଏଃଏ ନ୍‌ସା ବାଲିର୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_17","070_2_17","MAT","2","17","17","ଦେକ୍ ରକମ୍ ବାବବାଦି ଯିରିମିୟନେ ମୁଇଙ୍ଗ୍ ବବିଷ୍ୟତ୍ ସାମୁଆଁ ପୁରନ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_18","070_2_18","MAT","2","18","18","“ରାମା ଇନିବାନ୍ କିରନେ ଅଁନେଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ କାକର୍‌ତିରେ ଅଃନେ ସବ୍‌ଦ ରାହେଲ ମେଁନେ ଉଙ୍ଗ୍‌ଡେଇଂ ନ୍‌ସା ଅଃଡିଙ୍ଗ୍‌କେ; ଆମେକେ ଡିରକମ୍‍ଡିଗ୍ ଆବୁଜେଲା ବୁଜେ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ ଡାଗ୍ଲା ମେଇଂ ସାପାରେ ଗ୍ୱେଲେଃଆର୍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT2_19","070_2_19","MAT","2","19","19","ହେରୋଦ ଗୁଏକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମାପ୍ରୁନେ ଦୁତ୍ ମିସର୍‌ନ୍ନିଆ ଯୋସେଫ୍‌କେ ମୁସୁଡ଼ିଙ୍ଗ୍‌ନ୍ନିଆ ଆତ୍ନାଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT2_20","070_2_20","MAT","2","20","20","“ତଡ଼୍ୟା ଗଡ଼େଅକେ ଆରି ମେଁନେ ଇୟାଙ୍ଗ୍‌କେ ଡୁଂୱେଚେ ଇଶ୍ରାଏଲ୍ ଦେସ୍‌ନ୍ନିଆ ଆଣ୍ତେଏଲାପା । ଡାଗ୍ଲା ଜାଣ୍ଡେଇଂ ଆମେକେ ବାଗୁଏ ନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ଲେଆର୍‌କେ ମେଇଂ ଗୁଏଃଆର୍ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT2_21","070_2_21","MAT","2","21","21","ତେସା ଯୋସେଫ୍‌ ତଡ଼ିଆଚେ ଗଡ଼େଅକେ ଆରି ମରିୟମ୍‌କେ ସାଚେ ଇଶ୍ରାଏଲ୍ ଦେସ୍‌ପାକା ଆଣ୍ତେ ୱିଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_22","070_2_22","MAT","2","22","22","ମାତର୍ ଆର୍ଖିଲାୟ ନିଜର୍ ଆବା ହେରୋଦନେ ଟାନ୍‌ନ୍ନିଆ ଜିଉଦା ଦେସ୍‌ନେ ଇଃସାଙ୍ଗ୍‌ ଡିଂଲେଃକେ ଆକେନ୍ ଅଁଚେ ଆତ୍‌ତେ ୱେନ୍‌ସା ମେଁ ବୁଟମେଗ୍‌କେ; ମାତର୍ ମୁସୁଡ଼ିଂନ୍ନିଆ କେଚେ ଗାଲିଲୀ ପାକା ଲାଗ୍‌ଡକେ । ");
INSERT INTO gaq_vpl VALUES ("MT2_23","070_2_23","MAT","2","23","23","ମାତର୍‌ ଆରି ବିନ୍ ମୁସୁଡ଼ିଙ୍ଗ୍ କେଚେ ବିନ୍ ଦେସ୍‍ନ୍‍ସା ମେଁ ଗାଲିଲୀ ପ୍ରଦେସ୍‌ନେ ନାଜରିତ ଇନିନ୍ନିଆ ଡୁଆ ଆଃରେଚେ ଲେଃଗେ । ଏନ୍‌ ବିତ୍ରେ ବାବବାଦି‍ଇଂନେ ଗୁଆର୍‌ବକ୍ନେ ମୁଇଙ୍ଗ୍ ସାମୁଆଁ ପୁରନ୍‌ ଡିଙ୍ଗ୍‌କେ । “ମେଁ ନାଜରିତିୟ ଡାଗ୍‌ଚେ ସ୍ନାମୁଁଆଃ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT3_1","070_3_1","MAT","3","1","1","ଆତେନ୍‌ ବେଲା ଡୁବନ୍ ବିଃଣ୍ଡ୍ରେ ଜହନ୍‌ ଜିଉଦା ଦେସ୍‌ନେ ବାଲିଲନ୍ନିଆ ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ନେ ଅଲେଙ୍ଗ୍ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT3_2","070_3_2","MAT","3","2","2","ମେଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ “ପାପ୍ ଗାଲିବାନ୍ ଆଣ୍ତେପା ଡାଗ୍ଲା କିତଂଇନି ତେପାଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT3_3","070_3_3","MAT","3","3","3","ବାବବାଦି ଯିଶାଇୟ ମୁଡ଼ି ରେମୁଆଁ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ ବକେ । ଜହନ୍‌ ଆଃ ଆତେନ୍‌ ରେମୁଆଁ: “ବାଲିଲନ୍ନିଆ ଜାଣ୍ଡେ ମୁଇଂଜା କିରଚେ ବାସଙ୍ଗ୍‌ଡିଂକେ; ମାପ୍ରୁ ନ୍‌ସା ଗାଲି ତିଆର୍ ଡିଙ୍ଗ୍‌ପା; ମେଁ ପାଙ୍ଗ୍‌ନେ ଗାଲି ସିଦା ଆଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT3_4","070_3_4","MAT","3","4","4","ଜହନ୍‌ନେ ସକା ଉଟ୍‍ ଉକ୍‌ସା ଏତେ ତିଆର୍ ଡିଙ୍ଗ୍‌ଲେଃଗେ । ମେଁ ମେଁନେ ନ୍‌ସାନ୍ନିଆ ମୁଇଙ୍ଗ୍ ଉକ୍‌ସାନେ ଗ୍ନାଗ୍‌ସେ ଗାଗ୍ ଡିଙ୍ଗେ । ପଙ୍ଗପାଳ ବା କ୍ୟାରବ ସ୍ଲାଃନେ ଚୁଚୁ ଆରି କଣ୍ତା ଞ୍ଜୁଙ୍ଗ୍‌ ମେଁନେ କାଦି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT3_5","070_3_5","MAT","3","5","5","ଯିରୂଶାଲମ୍‌ ଇନିବାନ୍ ଜିଉଦା ପ୍ରଦେସ୍‌ ଆରି ଜର୍ଦନ୍‌ ଲଣ୍ତିଆ ପାକାପାକି ସାପା ଅଞ୍ଚଲବାନ୍‌ ରେମୁଆଁଇଂ ମେଁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ଡିଂଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT3_6","070_3_6","MAT","3","6","6","ମେଇଂ ନିଜର୍ ନିଜର୍‌ନେ ପାପ୍ ସିକାର୍ ଡିଙ୍ଗ୍‌ଚେ ଜହନ୍‌ନେବାନ୍ ଜର୍ଦନ୍‌ କେଣ୍ଡିଆନ୍ନିଆ ଡୁବନ୍ ଡୁଂଡ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT3_7","070_3_7","MAT","3","7","7","ଉଡ଼ି ବେଲା ଜହନ୍‌ କେକେ ଗୁଲେ ଫାରୁଶୀ ଆରି ସାଦୁକୀ ଡୁବନ୍ ଡୁଂଡ ନ୍‌ସା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌ଆର୍କେ; ଆମେଇଂକେ ଜହନ୍‌ ବାସଙ୍ଗ୍‌କେ “ଏ ବୁବଃନେ କୁଲ୍‌ବଂସ ! କାଲାଆଃ ରିସା ଡିଙ୍ଗ୍‍ଚେ ଲାଗ୍‍ଡନ୍‍ସା ଆପେକେ ଜାଣ୍ଡେ ଚେତ୍‍ନା ବିକେ ? ");
INSERT INTO gaq_vpl VALUES ("MT3_8","070_3_8","MAT","3","8","8","ଜଦି ସତେଆ ପାପ୍ କାମ୍‌ବାନ୍‌ ମନ୍ ଆବଦ୍‌ଲେ ପେବଏ ଏନ୍‌ ପେନେ ସ୍ଲେବାନ୍‍ ଆସୁଏପା । ");
INSERT INTO gaq_vpl VALUES ("MT3_9","070_3_9","MAT","3","9","9","ଆବାବେଗ୍‌ପା ଜେ ଅବ୍ରାହାମ୍ ପେନେ ନ୍ତା ଞ୍ଜା ଡାଗ୍‌ଚେ ବାଲିର୍‌କ୍ନେ ବାନ୍ ପେ ଡଣ୍ଡ୍‍ ବାନ୍ ରକ୍ୟା ପେବାଏ । ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଣ୍ଡିଂକେ ଜେ ଇସ୍‌ପର୍ ଆକେନ୍ ବ୍ରିଇଂ ଡୁଂୱେଚେ ଅବ୍ରାହାମ୍‌ନେ କୁଲ୍‌ ଇଂ ତିଆର୍ ଡିଙ୍ଗ୍ ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT3_10","070_3_10","MAT","3","10","10","ସ୍ଲା ସାପା ବୁନ୍ଦେ ସିତଗ୍ ବିନ୍‌ସା ମାଲୁଏଃ ବଆର୍‌କେ । ଆଣ୍ଡିନେ ସ୍ଲାଃନ୍ନିଆ ନିମାଣ୍ତା ଚୁଚୁ ଆଚୁ ଣ୍ତୁ, ଆତେନ୍‌ ସିତଗ୍‌ଚେ ସୁଆନ୍ନିଆ ତ୍ଲାଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT3_11","070_3_11","MAT","3","11","11","ନେଙ୍ଗ୍ ସିନା ଆପେକେ ମନ୍ ବଦ୍‌ଲେ ନ୍‌ସା ଣ୍ତିଆନ୍ନିଆ ଡୁବନ୍ ବିଣ୍ଡିଂକେ । ମାତର୍‌‌ ନେଙ୍ଗ୍ ଇଡ଼ିଙ୍ଗ୍ ଜା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ, ମେଁ ନେଙ୍ଗ୍‌ବାନ୍ ଜାବର୍ ମ୍ନା । ମେଁ ଞ୍ଚନେ ଜୁତା ତୁତଃ ନ୍‌ସା ନେଙ୍ଗ୍‌ନେ ସକତ୍‌ ଣ୍ଡୁ; ମେଁ ଆପେକେ ପବିତ୍ର ଆତ୍ମା ଆରି ସୁଆନ୍ନିଆ ଡୁବନ୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT3_12","070_3_12","MAT","3","12","12","ଗହମ୍‌ବାନ୍ ଚପା ସାପା ଆୱାଲେ ବିନ୍‌ସା ମେଁନେ ନ୍ତିନ୍ନିଆ କିସଃ ଲେଃକେ । ମେଁ ଗହମ୍ଇଂକେ ମେଁନେ ଆଣ୍ଡ୍ରାଃନ୍ନିଆ ବଏ ଆରି ଗାବୁଜା ସାପାକେ କାଲାଆଃ ଡୁଆକ୍ନେ ସୁଆନ୍ନିଆ ବା ଜଗ୍‌ତ୍ଲିଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT3_13","070_3_13","MAT","3","13","13","ଆତେନ୍‌ ବେଲା ଜିସୁ ଜହନ୍‌ବାନ୍ ଡୁବନ୍ ଡୁଂଡ ନ୍‌ସା ଗାଲିଲୀ ଦେସ୍‌ବାନ୍ ଜର୍ଦନ୍‌ ଲଣ୍ଡିଆଃନ୍ନିଆ ପାଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT3_14","070_3_14","MAT","3","14","14","ମାତର୍‌ ଜହନ୍‌ ଆମେକେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍‍ ସିନା ନାନେ ବାନ୍ ଡୁବନ୍ ଡିଙ୍ଗ୍‌ନେ ସିନା ଲେଃଗେ ଆରି ନାନେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ନାଲେକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT3_15","070_3_15","MAT","3","15","15","ମାତର୍‌ ଜିସୁ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ସାମୁଆଁରେ ରାଜି ଡିଙ୍ଗ୍ । ଡାଗ୍ଲା ଆକ୍‌ମେଁ ବାନ୍ ନେନେ ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌କ୍ନେ କାମ୍ ଡିଙ୍ଗ୍‌ନେୟାଏ ।” ତେସା ଜହନ୍‌ ଆମେକେ ଡୁବନ୍ ବିନ୍‌ସା ରାଜି ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT3_16","070_3_16","MAT","3","16","16","ଜିସୁ ଡୁବନ୍ ଡୁଂଡଚେ ଣ୍ତିଆବାନ୍‌ ତଡ଼୍ୟା ତାର୍‌କ୍ନେ ଦାପ୍‌ଡ଼େ ମେଁ କେକେ କିତଂ ମେଲା ଡିଙ୍ଗ୍‌ଲେକେ ବାରି ଇସ୍‌ପର୍‌ନେ ଆତ୍ମା କୁକୁର୍‌ୟାଃ ରକମ୍ ମେଁ ଆଡ଼ାତ୍ରା ଜାର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT3_17","070_3_17","MAT","3","17","17","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ କିତଂବାନ୍ ମୁଇଂ ସାମୁଆଁ ପାଙ୍ଗ୍‌କେ । “ଏ ନେଙ୍ଗ୍‌ନେ ନିଜର୍ ଉଙ୍ଗ୍‌ଡେ ମେଁନେ ଡାଗ୍ରା ନେଙ୍ଗ୍ ଜାବର୍‌ ସାର୍ଦା ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_1","070_4_1","MAT","4","1","1","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ପବିତ୍ର ଆତ୍ମା ଜିସୁକେ କଣ୍ଡାନ୍ନିଆ ୱା ଡୁଂୱେକେ । ଆତ୍‌ଅରିଆ ମେଁ ସ‍ଏତାନ୍‌ବାନ୍ ପରିକିତ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_2","070_4_2","MAT","4","2","2","ବାରି ମ୍ବାର୍‌କୁଡ଼ି ସ୍ମି ମ୍ବାର୍‌କୁଡ଼ି ମିଡିଗ୍ ଉପାସ୍ ଡିଙ୍ଗ୍‌ଚେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁକେ କେଡ଼େସଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_3","070_4_3","MAT","4","3","3","ଆତେନ୍‌ ବେଲା ସ‍ଏତାନ୍ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ନା ଜଦି ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ତେଲା ଆକେନ୍ ବ୍ରିଇଂକେ ରୁଟି ଡିଙ୍ଗ୍ ନ୍‌ସା ଆଦେସ୍‍ ବିଃ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_4","070_4_4","MAT","4","4","4","ମାତର୍‌ ଜିସୁ ଉତର୍ ବିକେ “ସାସ୍ତର୍‌ନ୍ନିଆ ଗ୍ନୁଆର୍ ଲେଃକେ; ରେମୁଆଁ ମାତର୍‌ ରୁଟି ଏତେ ଆମ୍ବ୍ର ଣ୍ଡୁ । ମାତର୍ ଇସ୍‌ପର୍‌ନେ ସାର୍ମୁଆଁବାନ୍ ତାର୍‌କ୍ନେ ସାପା ବ୍ନାଇର୍‌ବାନ୍ ମ୍ବ୍ରେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_5","070_4_5","MAT","4","5","5","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ସ‍ଏତାନ୍ ଜିସୁକେ ପବିତ୍ର ନଗର ଯିରୁଶାଲାମ୍‌ନ୍ନିଆ ଡୁଂୱେକେ । ଆତ୍‌ଅରିଆ ଆମେକେ ମନ୍ଦିର୍‌ନେ ବ୍ଲେସାଂ ଆଡ଼ାତ୍ରା ଆଃତୁଆଁଚେ ବାସଙ୍ଗ୍‌କେ, ");
INSERT INTO gaq_vpl VALUES ("MT4_6","070_4_6","MAT","4","6","6","“ନା ଜଦି ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଆକ୍‌ବାନ୍ ବୁନ୍ଦେ ପୁଏଃ ଲଃଲା । ଦର୍ମସାସ୍ତର୍‌ନ୍ନିଆ ଗ୍ନୁଆର୍ ଲେଃକେ, ମେଁ ନିଜର୍‌ ଦୁତ୍ଇଂକେ ନାନେ ବିସୟ୍‌ରେ ଆଦେସ୍ ବିଃଏ, ଆରି ମାରିଆଃ ନାନେ ଞ୍ଚ ବ୍ରିନ୍ନିଆ ବାଏ, ଆକେନ୍ ନ୍‌ସା ମେଇଂ ଆନାକେ ନ୍ତିନ୍ନିଆ ଲିଙ୍ଗ୍‌ଚେ ସାଃଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_7","070_4_7","MAT","4","7","7","ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ, “ସାସ୍ତର୍‌ନ୍ନିଆ ଗ୍ନୁଆର୍ ଲେଃକେ, ନାନେ ମାପ୍ରୁ ନିଜର୍‌ ଇସ୍‌ପର୍‍କେ ପରିକ୍ୟା ଆଡିଂଗେ ନାମଃ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_8","070_4_8","MAT","4","8","8","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ସ‍ଏତାନ୍ ମୁଇଙ୍ଗ୍ ଜବର୍ ତିଆର୍ ଟାନ୍‌ନିଆ ୱା ଡୁଂୱେଚେ ବାରି ଆମେକେ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସାପା ରାଇଜ୍ଇଂନେ ସୁନ୍ଦର୍‌କେ ଆସୁଏଚେ ବାସଙ୍ଗ୍‌କେ, ");
INSERT INTO gaq_vpl VALUES ("MT4_9","070_4_9","MAT","4","9","9","“ନା ଜଦି ବ୍ରିଂଚେ ଆନେଂକେ ନାଁ ମୁଣ୍ଡିଆ ନାବଗ୍‌ଏ, ଏନ୍‌ ସାପା ନେଙ୍ଗ୍ ଆନାକେ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_10","070_4_10","MAT","4","10","10","ଜିସୁ ଉତର୍ ବିକେ, “ନେଂବାନ୍ ସ୍ଲ ୱେଲା ସ‍ଏତାନ୍ ! ଦର୍ମସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍ ବକେ, ମାତର୍‌‌ ନା ମାପ୍ରୁ ଇସ୍‌ପର୍‌କେ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ଆରି ମେଁନେ ସେବାଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_11","070_4_11","MAT","4","11","11","ଇଡ଼ିଙ୍ଗ୍ ସ‍ଏତାନ୍ ଆମେକେ ଆନ୍ତାର୍‌ଚେ ଲାଗ୍‌ଡକେ ଆରି କିତଂନେ ଦୁତ୍‌ଇଂ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ଜତନ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_12","070_4_12","MAT","4","12","12","ଜହନ୍‌କେ ବନ୍ଦି ଆଡିଙ୍ଗ୍ ବକେ ଡାଗ୍‌ଚେ ଜିସୁ ଅଁଚେ ଗାଲିଲୀ ଆଃଡ଼ା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_13","070_4_13","MAT","4","13","13","ଡାଗ୍ଲା ନାଜରିତନ୍ନିଆ ମାଲେଚେ ଜବୂଲୂନ ଆରି ନପ୍ତାଲୀ ଏରିଆନ୍ନିଆ ଲେଃକ୍ନେ ଗାଲିଲୀ କେଣ୍ଡିଆ ପାକାପାକି କପୁର୍ନାହୁମ୍‌ନ୍ନିଆ ବାସାଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_14","070_4_14","MAT","4","14","14","ଏନ୍‌ ବାନ୍ ବାବବାଦି ଯିଶାଇୟନେ ବ୍ନାଲିର୍ ପୁରନ୍‌ ଡିଙ୍ଗ୍‌କେ । ମେଁ ବାସଙ୍ଗ୍‌ ବଗେ: ");
INSERT INTO gaq_vpl VALUES ("MT4_15","070_4_15","MAT","4","15","15","“ଜବୂଲୂନ ଦେସ୍ ଆରି ନପ୍ତାଲୀ ଦେସ୍ କେଣ୍ତିଆ ପାକାପାକି ଆରି ଜର୍ଦ୍ଦନନେ ଇନୁମେତା ବିଜାତିଇଂନେ ଗାଲିଲୀ ! ");
INSERT INTO gaq_vpl VALUES ("MT4_16","070_4_16","MAT","4","16","16","ତାଙ୍ଗ୍‌କିଗ୍‌ନ୍ନିଆ ବାସାଲେକ୍ନେ ରେମୁଆଁଇଂ ମୁଇଙ୍ଗ୍ ତାର୍‌କିଗ୍ କେଆର୍‌ଏ ଗୁଏଃକ୍ନେ ଲ୍‌ଲୁଡ଼୍ୟା ଡାବକ୍ନେ ଅଞ୍ଚଲ୍‌ନ୍ନିଆ ଲେଃକ୍ନେ ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଆତେନ୍‌ ତାର୍‌କିଗ୍ ତ୍ନାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_17","070_4_17","MAT","4","17","17","ଆତେନ୍‌ ବେଲା ବାନ୍ ଜିସୁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ପାପ୍‌ବାନ୍‌ ଆଣ୍ତେପା, ଡାଗ୍ଲା କିତଂଇନି ଡାଗ୍ରା ତେପାଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_18","070_4_18","MAT","4","18","18","ଜିସୁ ଗାଲିଲୀ କେଣ୍ତିଆଃ ଆଃଡ଼ାଃ ବିଃଚେ ଅଲେଙ୍ଗ୍‌ନେ ବେଲା ଶିମୋନ ଆଜାକେ ପିତର୍‌ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ମ୍ୟାକେ ବାରି ମେଁନେ ବୟାଁ ଆନ୍ଦ୍ରିୟ ଏନ୍‌ ବମୟାଁକେ କେଣ୍ଡିଆନ୍ନିଆ ବମୟାଁ ଜାଲ୍ ତ୍ଲାଗ୍‌ଚେ ଆଃଡ଼ ସାଃଡିଂକ୍ନେ କେକେ । ଡାଗ୍‍ଲା ମେଇଂ ଆଃଡ଼ ସାଃଣ୍ଡ୍ରେ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_19","070_4_19","MAT","4","19","19","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେ ସାପାରେ ନେଙ୍ଗ୍‍ ଏତେ ପାଙ୍ଗ୍‌ଲାପା, ନେଙ୍ଗ୍ ଆପେକେ ମାପ୍ରୁନେ ଗାଲିପାକା ରେମୁଆଁଇଂକେ ଡୁଂପାଙ୍ଗ୍‌ନେ ଣ୍ଡ୍ରାସିକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT4_20","070_4_20","MAT","4","20","20","ଆତ୍‌ବାନ୍‌ ମେଇଂ ଆତେନ୍‌ ଦାପ୍ରେ ଜାଲ୍ ଆନ୍ତାର୍‌ଚେ ଜିସୁନେ ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_21","070_4_21","MAT","4","21","21","ଆରି ମେଁ ଆତ୍‌ବା ସେନୁଗ୍‌ ୱେଚେ ଜେବଦୀନେ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌ ଆରି ମେଁନେ ବୟାଁ ଜହନ୍‌ ମ୍ନିକ୍ନେ ବାରି ମ୍ବାୟା ବୟାଁକେ ମେଁଇଂନେ ଆବା ଜେବଦୀନେ ଏତେ ତରାନ୍ନିଆ ଜାଲ୍ ପାଗ୍‌ଲୁଗ୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ଆମେଇଂକେ ୱାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_22","070_4_22","MAT","4","22","22","ଆତ୍‌ବାନ୍ ମେଇଂ ଆତେନ୍‌ ଦାପ୍ରେ ଡଙ୍ଗାକେ ଆରି ଆବାକେ ଆନ୍ତାର୍‌ଚେ ଜିସୁନେ ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_23","070_4_23","MAT","4","23","23","ଜିସୁ ସାପା ଗାଲିଲୀ ଅଲେଙ୍ଗ୍‌ଚେ ପାର୍‍ତନା ଡୁଆନ୍ନିଆ ସିକ୍ୟା ବିଃକେ । ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ନିମାଣ୍ତା ସାମୁଆଁ ପର୍‌ଚାର୍‌ ଡିଙ୍ଗ୍‌କେ ବାରି ସାପା ରକମ୍ ରଗ୍ ଆରି ଆଃସିଲେକ୍ନେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ତା ଆଃଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_24","070_4_24","MAT","4","24","24","ସିରିଆ ଦେସ୍‌ନେ ସାପାପାକା ମେଁନେ ନିମାଣ୍ତା ସାମୁଆଁ ଉଡ୍ରା ଡିଙ୍ଗ୍‌କେ ବାରି ରେମୁଆଁଇଂ ଗଲିଆ ସାକ୍ନେ ଗୁଏଲୁଗ୍‌ ଗୁଏକ୍ନେ ପକ୍ଷାଗାତି ଡିଙ୍ଗ୍‌କ୍ନେ ସାପା ରକମ୍ ରଗ୍ ଦୁକା ସାଲେଃକ୍ନେ ରେମୁଆଁ ଜିସୁନେ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଆର୍‌କେ ବାରି ମେଁ ଆମେଇଂକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT4_25","070_4_25","MAT","4","25","25","ବାରି ଗାଲିଲୀ, ଦେକାପଲୀ ଆରି ଗୁଆକ୍ଲିଗ୍‍ ଇନି ଯିରୂଶାଲମ୍‌, ଜିଉଦା ପ୍ରଦେସ୍ ଆରି ଜର୍ଦ୍ଦନନେ ଇନୁମେତାବାନ୍‌ ଗୁଲେ ମାନ୍ଦାରେ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_1","070_5_1","MAT","5","1","1","ଜିସୁ ରେମୁଆଁ ରିସିଙ୍ଗ୍‍ ଲେଃକ୍ନେ କେଚେ ମୁଇଙ୍ଗ୍ କାଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେଚେ କକେ । ସିସ୍ଇଂ ଆମେକେ ପିତୁର୍‍ପାକା ଗେରେ ଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_2","070_5_2","MAT","5","2","2","ଆମେଇଂକେ ଜିସୁ ସିକ୍ୟା ବିଃଚେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_3","070_5_3","MAT","5","3","3","“ଆତ୍ମାନ୍ନିଆ ଗରିବ୍‌ ମନ୍‌ ବାବେଣ୍ଡ୍ରେ ନିମାଣ୍ଡାଃ; ଡାଗ୍ଲା କିତଂ ରାଇଜ୍ ମେଇଂନେ !” ");
INSERT INTO gaq_vpl VALUES ("MT5_4","070_5_4","MAT","5","4","4","ଅଃଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂ ଦନ୍ୟ; ଡାଗ୍ଲା ଇସ୍‌ପର୍ ଆମେଇଂକେ ସାନ୍ତି ବିଏ ! ");
INSERT INTO gaq_vpl VALUES ("MT5_5","070_5_5","MAT","5","5","5","ଦରମ୍ ରେମୁଆଁଇଂ ଦନ୍ୟ; ଡାଗ୍ଲା ମେଇଂ ଦର୍‌ତନିନେ ଅଦିକାରି ଡିଂଆର୍‌ଏ ! ");
INSERT INTO gaq_vpl VALUES ("MT5_6","070_5_6","MAT","5","6","6","ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚାରେ ଜାଣ୍ଡେଇଂ କାମ୍‌ ଡିଙ୍ଗ୍‌ନେ ଜବର୍ ଆସା ରେମୁଆଁ ମେଇଂ ନିମାଣ୍ଡା, ଡାଗ୍ଲା ଆମେଇଂକେ ଇସ୍‌ପର୍ ସାର୍ଦା ଆଃଡିଙ୍ଗ୍ଏ । ଡାଗ୍ଲା ଇସ୍‌ପର୍ ଆମେଇଂକେ ସାର୍ଦା ଆଃଡିଙ୍ଗ୍ଏ ! ");
INSERT INTO gaq_vpl VALUES ("MT5_7","070_5_7","MAT","5","7","7","ଜାଣ୍ଡେଇଂ ବିନ୍‌ଣ୍ଡ୍ରେନେ ଆଡ଼ାତ୍ରା ଲିବିସ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ମେଇଂ ଦନ୍ୟ; ଡାଗ୍ଲା ଇସ୍‌ପର୍ ଆମେଇଂକେ ଲିବିସ ଡିଙ୍ଗ୍‌ଏ ! ");
INSERT INTO gaq_vpl VALUES ("MT5_8","070_5_8","MAT","5","8","8","ଜାଣ୍ଡେଇଂନେ ଗାଗ୍‌ଡ଼େ ପର୍‌ଚଲ୍‌ ମେଇଂ ନିମାଣ୍ଡାଃ; ଡାଗ୍ଲା ମେଇଂ ଇସ୍‌ପର୍‌କେ କେଆର୍‌ଏ ! ");
INSERT INTO gaq_vpl VALUES ("MT5_9","070_5_9","MAT","5","9","9","ଜାଣ୍ଡେଇଂ ସାନ୍ତିରେ ଲେନ୍‍ସା ଇକ୍‌ଚା ଆଡିଙ୍ଗ୍ ଆର୍‌ଏ ମେଇଂ ଦନ୍ୟ; ଡାଗ୍ଲା ମେଇଂ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଡାଗ୍‌ଚେ ସ୍ନାମୁଁଆଃ ଡିଂଆର୍‌ଏ ! ");
INSERT INTO gaq_vpl VALUES ("MT5_10","070_5_10","MAT","5","10","10","ଜାଣ୍ଡେଇଂ ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚା ମେଁନେ ଆତେନ୍‌ କାମ୍ ଡିଙ୍ଗ୍‌ଚେ ଜାଣ୍ଡେଇଂ ତାଡ଼ନା ବାଆର୍‌ଏ ମେଇଂ ଦନ୍ୟ; ଡାଗ୍ଲା କିତଂଇନି ମେଇଂନେ ! ");
INSERT INTO gaq_vpl VALUES ("MT5_11","070_5_11","MAT","5","11","11","ରେମୁଆଁ ଅଃନା ଆପେକେ ନେଙ୍ଗ୍ ନ୍‌ସା ନିନ୍ଦା ଆରି କୁଟ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ, ବାରି ମିଚ୍‌ରେ ପେନେ ବିରଦ୍‌ରେ ସାପା ରକମ୍ ଦଦ୍ୟା ସାମୁଆଁ ବାସଙ୍ଗ୍ଏ, ତେଲା ପେ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("MT5_12","070_5_12","MAT","5","12","12","ପେ ନିଜେକେ ନିମାଣ୍ଡା ଡାଗ୍‌ଚେ ମନେ ଡିଙ୍ଗ୍‌ପା । ସାର୍ଦା ଡିଙ୍ଗ୍‌ଚେ ଉଲାସ୍‌ ଡିଙ୍ଗ୍‌ପା, ଡାଗ୍ଲା କିତଂନ୍ନିଆ ପେ ନ୍‌ସା ମ୍ନା ପୁରସ୍‌କାର୍ ବକେ । ପେନେ ନ୍ତା ଞ୍ଜା ଆରି ବାବବାଦିଇଂ ଡିଗ୍ ଦେକ୍‌ରକମ୍ ନିନ୍ଦା ବାଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_13","070_5_13","MAT","5","13","13","ପେଇଂ ସାପାରେ ଦର୍‌ତନିନେ ବିତିଗ୍ ରକମ୍ । ମାତର୍‌ ବିତିଗ୍ ଜଦି ସା ଆଲେଃ, ତେଲା ଆମେକେ ବାରି ବିତିଗ୍ ଆଃଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ଆତେନ୍‌ ବେଲା ଆମେକେ କାଲାଆଃ ନ୍‌ସା ଦର୍‌କାର୍‌ ଣ୍ତୁ ଡାଗ୍‌ଚେ ପାଦା ଜଗ୍‌ତ୍ଲିଗ୍ ବିଃଆର୍‌ଏ । ରେମୁଆଁ ଆମେକେ ଟେଚାଚେ ୱେଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT5_14","070_5_14","MAT","5","14","14","ପେଇଂ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ତାର୍‌କିଗ୍ । ଆଣ୍ଡିନେ ଇନିଲେ କଣ୍ଡା ଆଡ଼ାତ୍ରା ଆରେବକେ ଆତେନ୍‌ ଅଃନା ବୁଡ଼ିଚେ ଆଲେଃ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT5_15","070_5_15","MAT","5","15","15","କୁପିସ ଆଃଡ୍ୱାଚେ ଜାଣ୍ଡେ ଙ୍କୁଇ ବୁନ୍ଦେ ଆବ ଣ୍ତୁ ଆମେକେ କୁପିସ ବମ୍ୟାକ୍ନେ ଜାଗାନ୍ନିଆ ବଏ ବାରି ଆତେନ୍‌ ଡୁଆ ଲେଃକ୍ନେ ସାପାରେକେ ତାର୍‌କିଗ୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT5_16","070_5_16","MAT","5","16","16","ଦେକ୍‌ରକମ୍ ପେନେ ତାର୍‌କିଗ୍ ରେମୁଆଁଇଂନେ ଡାଗ୍ରା ତ୍ନାଲେଃ । ତେଲା ପେନେ ସତ୍ କାମ୍ ସାପା କେଚେ ପେଇଂନେ କିତଂନେ ଆବାନେ ମ‍ଇମା କିର୍ତ୍ତନ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT5_17","070_5_17","MAT","5","17","17","“ଆବାବେଗ୍‌ପା ଜେ ନେଙ୍ଗ୍ ମୋଶାନେ ଆରେକ୍ନେ ନିଅମ୍ ଆରି ବାବବାଦିଇଂନେ ସିକ୍ୟା ସାପା ବିନାସ୍‌ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ପାଙ୍ଗ୍ ନ୍‌ଲେଃକେ । ଆତେନ୍‌ ଇଂ ବିନାସ୍‌ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ଣ୍ତୁ ମାତର୍‌ ପୁରନ୍ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ପାଙ୍ଗ୍ ନ୍‌ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_18","070_5_18","MAT","5","18","18","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଅଃନା ଜାକ କିତଂଇନି ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ ଦଂସ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ ଆତେନ୍‌ ସାପା ମାଗଟେ ଜାକ ଦର୍ମ ସାସ୍ତର୍‌ ନିୟମ୍‌ ବାନ୍ ମୁଇଙ୍ଗ୍ ମାତ୍ରା କି ମୁଇଙ୍ଗ୍ ଟପା ଡିରକମ୍ ଡିଙ୍ଗ୍‌ଲା ଡିଗ୍ ଦଂସ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT5_19","070_5_19","MAT","5","19","19","ତେଲା ଜାଣ୍ଡେ ଡିଗ୍ ଆକେନ୍ ସାପାବାନ୍‍ ଡାଆଁନେ ଆଦେସ୍‌ ବାନ୍ ଆଣ୍ତିନେଡିଗ୍ ମୁଇଙ୍ଗ୍ ଆଦେସ୍‌ ଅମାନି ଡିଙ୍ଗ୍‌ଏ ଆରି ରେମୁଆଁଇଂକେ ଦେତ୍‌ରକମ୍ ସିକ୍ୟା ବିଏ, ମେଁ କିତଂଇନିନ୍ନିଆ ଡାଆଁ ଡାଗ୍‌ଚେ ସ୍ନାମୁଆଃ ଡିଙ୍ଗ୍‌ଏ; ମାତର୍‌ ଜାଣ୍ଡେ କି ଆତେନ୍‌ ସାପା ପାଲନ୍ ଡିଙ୍ଗ୍‌ଏ ଆରି ସିକ୍ୟା ବିଏ ମେଁ କିତଂଇନିନ୍ନିଆ ମ୍ନା ଡାଗ୍‌ଚେ ସ୍ନାମୁଆଃ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT5_20","070_5_20","MAT","5","20","20","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍ ବ ଣ୍ଡିଂକେ ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂନେ ବାନ୍ ଗ୍ଲୁଏ ବିସ୍‌ବାସ୍ ରକମ୍ ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚା ଇସାବ୍‌ରେ କାମ୍ ଡିଙ୍ଗ୍‌ଲେଏ ପେଇଂ କିତଂଇନିନ୍ନିଆ ଗା ପେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT5_21","070_5_21","MAT","5","21","21","ପେ ଅଁପେଲେକେ ଜେ ଅଃସେ କାଲ୍‌ନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌ବଗେ, ରେମୁଆଁ ଆବାଗୁଏଃଗ୍‌ପା, ଆରି ଜାଣ୍ଡେ କି ରେମୁଆଁ ବାଗୁଏଃଏ ମେଁ ବିଚାର୍ ଜାଗାନ୍ନିଆ ଡଣ୍ଡ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT5_22","070_5_22","MAT","5","22","22","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଜାଣ୍ଡେ କି ନିଜର୍ ବୟାଁ ଆଡ଼ାତ୍ରା ଗିସେ ଡିଙ୍ଗ୍‌ଏ ମେଁ ବିଚାର୍ ଡିଙ୍ଗ୍ ଆଡାଚେ ଡଣ୍ଡ୍ ବାଏ ବାରି ଜାଣ୍ଡେ କି ନିଜର୍ ବୟାଁକେ ମୁର୍କ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍ଏ ମେଁ ମ୍ନା କୁକପାର୍‌ନ୍ନିଆ ଡଣ୍ଡ୍ ବାଏ; ବାରି ଜାଣ୍ଡେ କି ପାସଣ୍ଡ ଡାଗ୍‌ଚେ ବାଲିର୍‌ଏ ମେଁ ଡୁଆଲେକ୍ନେ ନର୍କ ସୁଆନ୍ନିଆ ଡଣ୍ଡ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT5_23","070_5_23","MAT","5","23","23","ଜଦି ଇସ୍‌ପର୍ ମଣ୍ଡପ୍ ଆଡ଼ାତ୍ରା ପୁଜା ଜିନିସ୍ ବିଃନେ ୱେନେବେଲା ଜଦି ପେନେ ଏତୁ ପଡ଼େଏ ଜେ ପେ ଆତ୍‍ଲା ମୁଡ଼ି ବୟାଁନେ ମନ୍‌ନ୍ନିଆ ମେଃଡିଗ୍ ଅସାନ୍ତି ଲେଃଏ ");
INSERT INTO gaq_vpl VALUES ("MT5_24","070_5_24","MAT","5","24","24","ବେଦି ସାମ୍‌ନେ ଆତେନ୍‌ ପୁଜା ଜିନିସ୍ ଆନ୍‌ତାର୍‌ ବିଚେ ସାଙ୍ଗେ ସାଙ୍ଗେ ୱେଚେ ବୟାଁ ଏତେ ଆର୍‌ମୁଇଂତର୍‌ କୁଡ଼େକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଆଣ୍ତେପାଙ୍ଗ୍‌ଚେ ଇସ୍‌ପର୍‌କେ ଆତେନ୍‌ ଅପେଃ । ");
INSERT INTO gaq_vpl VALUES ("MT5_25","070_5_25","MAT","5","25","25","ଜଦି ପେନେ ସତ୍ରୁ ଆନାକେ ବିଚାର୍ ଡୁଆନ୍ନିଆ ଡୁଂୱେଡିଂକେ, ତେଲା ବିଚାର୍ ଡୁଆନ୍ନିଆ ୱେନେ ସେନୁଗ୍‌ ମେଁନେ ଏତେ ଟାପ୍‍ନା କୁଡ଼େପା । ଣ୍ତୁଲା ପେନେ ସତ୍ରୁ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେନେ ନ୍ତିନ୍ନିଆ ବିଜଗ୍‌ତ୍ଲିଗ୍‌ଏ ଆରି ଇଡ଼ିଙ୍ଗ୍ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଆନାକେ ବିଚାର୍ ଡିଂନେ ନେତାନେ ନ୍ତିନ୍ନିଆ ଅପେଃ ବିଏ, ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ପେ ଜେଲ୍‌ ଡୁଆନ୍ନିଆ ବନ୍ଦି ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT5_26","070_5_26","MAT","5","26","26","ନେଙ୍ଗ୍ ଆନାକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ନା ବାକି ଡାବୁ ମାସୁଜେ ଜାକ ଆତେନ୍‌ ଜାଗାବାନ୍ ଡିଲାଡିଗ୍ ତାର୍‌ ପେୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT5_27","070_5_27","MAT","5","27","27","ଆକେନ୍‌ ସାମୁଆଁ ପେ ଅଁପେଲେକେ, ଗ୍ନୁଆର୍ ଲେଃକେ, “ଅଡ଼ାରେଗ୍‌ ଆଡିଙ୍ଗେପା । ");
INSERT INTO gaq_vpl VALUES ("MT5_28","070_5_28","MAT","5","28","28","ମାତର୍‌ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ଣ୍ତିଙ୍ଗ୍‌କେ, ଜାଣ୍ଡେ ଡିଗ୍ ବିନ୍‌ଣ୍ଡ୍ରେନେ ସେଲାମ୍ବୁଏଃକେ କେଚେ ମେଁନେ ଏତେ ପାପ୍‌ ଡିଙ୍ଗ୍‌ନେ ନ୍‌ସା ଚାଏଁଏ, ମେଁ ମେଁନେ ଏତେ ନିଜର୍ ମନ୍ ବିତ୍ରେ ଅଡ଼ାରେଗ୍‌ ଅପରାଦ୍ ଡିଙ୍ଗ୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_29","070_5_29","MAT","5","29","29","ଜଦି ପେନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକାନେ ମୁଆଃ ନ୍‌ସା ପେ ପାପ୍ ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ, ଆତେନ୍‌ ମୁଆଃକେ ତଃଚେ ଜଗ୍‌ତ୍ଲିଗ୍‌ବିପା । ପେନେ ସାପା ଗାଗ୍‌ଡ଼େ ନରକ୍‌ନ୍ନିଆ ଲଃନେ ବାଟା ମୁଇଂ ମ୍ମୁଆଃ ନସ୍‌ଟ ଡିଙ୍ଗ୍‌ନେ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("MT5_30","070_5_30","MAT","5","30","30","ଜଦି ପେନେ ଞ୍ଚଂତିନେ ନ୍ତି ଆପେକେ ପାପ୍ କାମ୍ ଆଃଡିଂଡିଙ୍ଗ୍‌କେ, ଆମେକେ ଡିଗ୍ ସିତଗ୍ ଜଗ୍‌ତ୍ଲିଗ୍‌ପା । ପେନେ ସାପା ଗାଗ୍‌ଡ଼େ ନରକ୍‌ନ୍ନିଆ ଲଃନେ ବାଦୁଲ୍ ମୁଇଂ ନ୍ତି ନଷ୍ଟ ଡିଙ୍ଗ୍‌ନେ ନିମାଣ୍ଡା ।” ");
INSERT INTO gaq_vpl VALUES ("MT5_31","070_5_31","MAT","5","31","31","ଜଦି ଜାଣ୍ଡେ ନିଜର୍ ସେଲାମ୍ବୁଏଃକେ ଆନ୍ତାର୍ ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ, ମେଁ ଆମେକେ ଆନ୍ତାର୍‌ନେ ଉଲିଆଃ ଗୁଆର୍ ବିଃଲେ, ଏନ୍‌ ସିକ୍ୟା ପେଇଂ ଅଃସେବାନ୍‌ ମ୍ୟାପେଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_32","070_5_32","MAT","5","32","32","ମାତର୍ ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଜାଣ୍ଡେ କି ନିଜର୍ ସେଲାମ୍ବୁଏଃକେ ଅଡ଼ାରେଗ୍ ଦସ୍ ଆନ୍‌ତାର୍‌ଚେ ବିନ୍ କାରନ୍‌ରେ ଆନ୍‌ତାର୍‌ ବିଏ, ମେଁ ଆମେକେ ଅଡ଼ାରେଗ୍ ଆଃଡିଙ୍ଗ୍ଏ ଆରି ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃକେ ଜାଣ୍ଡେ ବିହେ ଡିଙ୍ଗ୍‌ଏ, ମେଁ ଡିଗ୍ ଅଡ଼ାରେଗ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT5_33","070_5_33","MAT","5","33","33","ଅଃସେବାନ୍‌ ଏନ୍‌ ସିକ୍ୟା ଅଁଚେ ପାଙ୍ଗ୍ ପେଲେକେ ଜେ ପେ ମିଚ୍ ପାର୍‌ମାନ୍ ଆଡିଙ୍ଗ୍‌ପା ଇସ୍‌ପର୍ ସାମ୍‌ନାନ୍ନିଆ ଆଣ୍ଡିନେ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ପେଲେଃଏ ଆତେନ୍‌ ପୁରନ୍‍ ଆଃଡିଂପା । ");
INSERT INTO gaq_vpl VALUES ("MT5_34","070_5_34","MAT","5","34","34","ମାତର୍‌ ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଅଃନା ଡିଙ୍ଗ୍ ପାର୍‌ମାନ୍ ଆଡିଙ୍ଗେପା । କିତଂ ମ୍ନିରେ ପାର୍‌ମାନ୍ ଆତ୍ଲାଗ୍‌ପା ଡାଗ୍ଲା ଆତେନ୍‌ ଇସ୍‌ପର୍‌ନେ ସିଂଆଁସନ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("MT5_35","070_5_35","MAT","5","35","35","ମଞ୍ଚ୍‌ପୁର୍‌ ମ୍ନିରେ ପାର୍‌ମାନ୍ ଆତ୍ଲାଗ୍‌ପା ଡାଗ୍ଲା ଆତେନ୍‌ ଇସ୍‌ପର୍‌ନେ ଞ୍ଚ ବନେ ଜାଗା । ଯିରୂଶାଲମ୍‌ ମ୍ନିରେ ଡିଗ୍ ପାର୍‌ମାନ୍ ଆତ୍ଲାଗ୍‌ପା ଡାଗ୍ଲା ଆତେନ୍‌ ଇଃସାଙ୍ଗ୍‌ଇଂନେ ଇଃସାଙ୍ଗ୍‌ନେ ନଗର୍ । ");
INSERT INTO gaq_vpl VALUES ("MT5_36","070_5_36","MAT","5","36","36","ପେ ବାଆଃନେ ପାର୍‌ମାନ୍ ଆତ୍ଲାଗ୍‌ପା ଡାଗ୍ଲା ମୁଇଙ୍ଗ୍ ଉଗ୍‌ବ ଏଡ଼େ ଆରି ତୁଲୁଏ ଆଡିଙ୍ଗ୍‌ନେ ପେନେ ବପୁ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT5_37","070_5_37","MAT","5","37","37","“ପେ ପାର୍‌ମାନ୍ ନିଅମ୍ ମାତ୍ଲାଗ୍‌ଚେ ମାତର୍‌ ଅଃଅଁ ସାମୁଆଁ ଅଃଅଁ ବାସଙ୍ଗ୍‌ପା, ଣ୍ଡୁ ସାମୁଆଁ ଣ୍ଡୁ ବାସଙ୍ଗ୍‌ପା । ଏନ୍‌ବାନ୍‌ ଜାବର୍ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ଚେ ପାର୍‌ମାନ୍ ତ୍ଲାଗ୍‍ନେ ସ‍ଏତାନ୍‌ନେ ପାପ୍ ଆତ୍ମାବାନ୍‌ ପାଙ୍ଗ୍‌ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT5_38","070_5_38","MAT","5","38","38","“ଏନ୍ ପ୍ରତିଇଂସା ନିଅମ୍ ପେଇଂ ଦ୍ରିଗ୍ ପେଲେକେ; ମ୍‌ମୁଆଃ ବାଦୁଲ୍‌ରେ ମ୍‌ମୁଆଃ ଗ୍ନି ବାଦୁଲ୍‌ରେ ଗ୍ନି । ");
INSERT INTO gaq_vpl VALUES ("MT5_39","070_5_39","MAT","5","39","39","ମାତର୍‌ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଜାଣ୍ଡେ ନାନେ ଦଦ୍ୟା‌ ଡିଂଏ, ଆମେକେ ଆସିର୍‍ଜେଗେପା । ଜଦି ପେନେ ଞ୍ଚଙ୍ଗ୍‌ତିନେ ମୁଇଙ୍ଗ୍‌ ଗିଙ୍ଗିଙ୍ଗ୍ ଚାପ୍‌ଡ଼ା ବଗ୍ଏ, ଆମେକେ ଆରି ମୁଇଙ୍ଗ୍ ଗିଙ୍ଗିଙ୍ଗ୍ ଆଃସୁଏ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("MT5_40","070_5_40","MAT","5","40","40","ଜଦି ଜାଣ୍ଡେ ପେନେ ସକା ଡୁଂଡ ନ୍‌ସା ପେନେ ବିରଦ୍‌ରେ କିରଜାଟି ଡିଙ୍ଗ୍‌ଚେ ବିଚାର୍ ଡୁଆନ୍ନିଆ ଡୁଂୱେଏ ଆମେକେ ତଗ୍‌ରିଆଃ ଡିଗ୍ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("MT5_41","070_5_41","MAT","5","41","41","ଜଦି ସନ୍ୟ ଆପେକେ ମେଁ ଏତେ ମୁଇଙ୍ଗ୍ କିଲମିଟର୍ ୱେନ୍‌ସା ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍‌ଏ ତେଲା ମେଁନେ ଏତେ ମ୍ବାର୍ କିଲମିଟର୍ ୱେଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT5_42","070_5_42","MAT","5","42","42","ଜାଣ୍ଡେ ଜଦି ଆପେକେ ମେଃଡିଗ୍ ଜିନିସ୍ ସାଲ୍ୟାଏ, ମନା ମାଡିଙ୍ଗ୍‌ଚେ ଆମେକେ ବିଃପା, ଜାଣ୍ଡେ ଡିଗ୍ ଉଦାର୍ ସାଲ୍ୟାଲା ଆମେକେ ଆତେନ୍‌ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("MT5_43","070_5_43","MAT","5","43","43","ଏନ୍‌ ସିକ୍ୟା ଅଃସେଆଃ ଅଁପେଲେକେ ସାଙ୍ଗ‍ଇଂକେ ଆଲାଦ୍ ଡିଂପା ସତ୍ରୁକେ ଗୁର୍‌ନା ଡିଂପା । ");
INSERT INTO gaq_vpl VALUES ("MT5_44","070_5_44","MAT","5","44","44","ମାତର୍‌ ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ସତ୍ରୁକେ ଆଲାଦ୍ ଡିଂପା । ଜାଣ୍ଡେଇଂ ଆପେକେ ନିନ୍ଦା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ମେଇଂ ନ୍‌ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT5_45","070_5_45","MAT","5","45","45","ଏନ୍‌ ଡିଙ୍ଗ୍‌ଲା ପେନେ କିତଂନେ ଆବାନେ ଉଙ୍ଗ୍‌ଡେ ଡାଗ୍‌ଚେ ସ୍ନାମୁଁଆଃ ପେଡିଙ୍ଗ୍‌ଏ । ଡାଗ୍ଲା ଇସ୍‌ପର୍ ନିମାଣ୍ଡା ଆରି ଦଦ୍ୟା ମ୍ବାର୍ ପ୍ରକାର୍‌ ରେମୁଆଁଇଂକେ ସ୍ନି ତାରାସ୍‌ ବିଏ ବାରି ନିମାଣ୍ଡା କାମ୍ ଆରି ଦଦ୍ୟା କାମ୍ ଡିଙ୍ଗ୍‍ମ୍ୟାକ୍ନେ ସାପାରେ ନ୍‍ସା ଣ୍ଡିଆ ଆଗୁର୍‌ ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_46","070_5_46","MAT","5","46","46","ଜାଣ୍ଡେଇଂ ଆପେକେ ଆଲାଦ୍ ଡିଂମ୍ୟାକେ ପେ ଜଦି ଆମେଇଂକେ ଆଲାଦ୍ ପେଡିଂଏ ତେଲା ପେଇଂ ମେଃ ପୁରସ୍‌କାର୍ ପେବାଏ ? ଦେକ୍ ରକମ୍ ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେ ଡିଗ୍ ଆତେନ୍‌ ଡିଙ୍ଗ୍‍ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_47","070_5_47","MAT","5","47","47","ଆରି ପେ ଜଦି ନିଜର୍ ନିଜର୍ ବୟାଁ ସାଙ୍ଗଇଂକେ ପେସାର୍‌ଲଏ ତେଲା ପେ ଡିରକମ୍‍ନେ ସ୍ଲେ ଡିଂପେଡିଙ୍ଗ୍‌କେ ? ଅବିସ୍‌ବାସି‍ଇଂ ଡିଗ୍ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ମ୍ୟାଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT5_48","070_5_48","MAT","5","48","48","ପେଇଂନେ କିତଂନେ ଆବା ଡିରକମ୍ ନିମାଣ୍ଡା ପେ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT6_1","070_6_1","MAT","6","1","1","“ରେମୁଆଁଇଂକେ ଆସୁଏ ନ୍‌ସା ମେଁଇଂନେ ସାମ୍‌ନାରେ ଦରମ୍ କରମ୍‌ ଆଡିଙ୍ଗ୍‌ପା ଆତେନ୍‌‍ସା ପେଇଂ ତରକ୍ ଲାଲାପା ଣ୍ତୁଲା ପେନେ କିତଂନେ ଆବା ଡାଗ୍ରା ପୁରୁସ୍‌କାର୍ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT6_2","070_6_2","MAT","6","2","2","“ମୁଇଙ୍ଗ୍ ମେଃଡିଗ୍‌ ଆଲେଃକ୍ନେ ରେମୁଆଁକେ ମେଃଡିଗ୍ ଦାନ୍ ବିକେଲା କୁଟ୍‌ ରେମୁଆଁଇଂ ରକମ୍ ନିଜର୍‌ ଡାଗ୍ରା ପ୍ନିଃ ଆପିଃଗେପା । ମେଇଂ ପାର୍‍ତନା ଡୁଆ ଆଣ୍ତେଙ୍ଗ୍ ଆରି ସାଇ ମଜେ ନିଜର୍ ଦାନ୍‌ ଦରମ୍ ବସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ମ୍ୟାଆର୍‌କେ । ରେମୁଆଁଇଂନେ ବାନ୍ ପ୍ରସଂସା ବାନ୍‌ସା ମେଇଂ ଏନ୍‌ ଡିଙ୍ଗ୍‌ମ୍ୟାଆର୍କେ ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ମେଇଂ ନିଜର୍ ନିଜର୍ ପୁରସ୍‌କାର୍ ବାଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT6_3","070_6_3","MAT","6","3","3","ମାତର୍‌ ପେ ଦାନ୍ ବିଃନେ ବେଲା ପେନେ ଞ୍ଚଙ୍ଗ୍‌ତି ମେଃନେ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ପେନେ ବେସ୍ୟାତି ଆମ୍ୟାଲେଃ । ");
INSERT INTO gaq_vpl VALUES ("MT6_4","070_6_4","MAT","6","4","4","ପେନେ ଆକେନ୍ ଦାନ୍ ବୁଡ଼ିଚେ ବିପେବଲା ଡିଗ୍ ପେନେ ଆବା ଇସ୍‌ପର୍ ଆତେନ୍‌ କେଚେ ଆପେକେ ପୁରସ୍‌କାର୍ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT6_5","070_6_5","MAT","6","5","5","ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ନେ ବେଲା କୁଟ୍ ଦାର୍‍ମିକ୍‍ ରକମ୍ ଆଡିଙ୍ଗ୍‌ପା । ସାପାରେ ଡିରକମ୍ କେୟାଆର୍‌ଏ ଆତେନ୍‌‌ସା ପାର୍‌ତନା ଡୁଆ ଆରି ଗାଲି ଚକ୍‌ଇଂନ୍ନିଆ ତୁଆଁଚେ ମେଇଂ ପାର୍‍ତନା ଡିଙ୍ଗ୍ ନ୍‌ସା ବଲ୍ ବାମ୍ୟାଃଆର୍‌କେ । ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ମେଇଂ ନିଜର୍ ନିଜର୍ ସାପା ସ୍ଲେକ୍ନେ ପୁରସ୍‌କାର୍ ବା ଡାଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT6_6","070_6_6","MAT","6","6","6","ଡାଗ୍ଲା ପେ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ନ୍‌ସା ବୁଡ଼ିଚେ ଲେଃକ୍ନେ ଆଲସାଂ ୱେଲାପା କାପାଟ୍ ଆନ୍ତବିପା ଆରି ପେନେ ଆତ୍ନାକ୍ନେ ଆବାକେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ପା । ବାରି ପେ ଚିମ୍‌ଚିମ୍‌ରା ଚିମ୍‍ରା ଜାଗାନ୍ନିଆ ମେଁନେ ପେଡିଙ୍ଗ୍‌ଏ ପେନେ ଆବା ଆତେନ୍‌ କେଚେ ଆପେକେ ପୁରସ୍‌କାର୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_7","070_6_7","MAT","6","7","7","ପେନେ ପାର୍‍ତନାନ୍ନିଆ ଅବିସ୍‌ବାସି ରେମୁଆଁଇଂ ସୁଗୁଆ ଗୁଲେ ଅର୍‌ତ ଆଲେଃକ୍ନେ ସବ୍‌ଦ ବେବ‍ଆର୍ ଆଡିଙ୍ଗ୍‌ପା । ମେଇଂ ବାବେ ଆର୍‌ଏ ଜେ ମେଁଇଂନେ ପାର୍‍ତନା ଚ୍ଲେଡିଙ୍ଗ୍‍ଲା ଇସ୍‌ପର୍ ଅଁଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_8","070_6_8","MAT","6","8","8","ମେଇଂ ରକମ୍ ଆଡିଙ୍ଗ୍‌ପା । ପେ ସାଲ୍ୟାନେ ସେନୁଗ୍‌ ପେନେ ମେଃମେଃନେ ଦର୍‌କାର୍ ପେନେ ଆବା ଇସ୍‌ପର୍ ଆତେନ୍‌ ସାପା ମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_9","070_6_9","MAT","6","9","9","ତେସା ପେଇଂ ଦେକ୍‌ରକମ୍ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍: ଏ ନେନେ କିତଂନେ ଆବା ନାନେ ମ୍ନି ପବିତ୍ର ଡାଗ୍‌ଚେ ମାନେଃ ଆର୍‍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT6_10","070_6_10","MAT","6","10","10","ନାନେ ରାଜି ପାଙ୍ଗ୍‌ଲେ ନାନେ ଇକ୍‌ଚା କିତଂନ୍ନିଆ ଡିରକମ୍ ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ପୁରନ୍ ଡିଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT6_11","070_6_11","MAT","6","11","11","ଏଃକେ ଆନେକେ ଦର୍‌କାର୍‌ ଲେଃକ୍ନେ କାଦି ବିଃଲା । ");
INSERT INTO gaq_vpl VALUES ("MT6_12","070_6_12","MAT","6","12","12","ନେନେ ବିରଦ୍‌ରେ ଦସ୍ ଡିଙ୍ଗ୍‌ବକ୍ନେ ରେମୁଆଁଇଂକେ ନେ ଡିରକମ୍ କେମା ନେବିଃଏ ଦେତ୍‌ରକମ୍ ନେନେ ଦସ୍ ସାପା କେମା ଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("MT6_13","070_6_13","MAT","6","13","13","ଆନେକେ କଷ୍ଟନ୍ନିଆ ଲଃନ୍‌ସା ଆବିଃଗେ । ଦଦ୍ୟା ସ‍ଏତାନ୍‌ ବାନ୍ ଆନେକେ ରକ୍ୟା ଡିଙ୍ଗ୍ । ମାତର୍‌ ନାନେ ସାସନ୍ ପରାକ୍ରମ ଆରି ଗୌରବ୍ ଜୁଗ୍‌ ଜୁଗ୍‌ ନାନେ ଡିଙ୍ଗ୍‌ଲେ । ଆମେନ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("MT6_14","070_6_14","MAT","6","14","14","“ନାନେ ବିରଦ୍‌ରେ ଦସ୍ ଡିଙ୍ଗ୍‌ବକ୍ନେ ବିନ୍‌ଣ୍ଡ୍ରେକେ ଜଦି ପେ କେମା ପେବିଏ, କିତଂନେ ଆବା ଡିଗ୍ ଆପେକେ କେମା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_15","070_6_15","MAT","6","15","15","ମାତର୍‌ ପେ ଜଦି ବିନ୍‌ଣ୍ଡ୍ରେକେ କେମା ପେବି, ପେନେ ଆବା ଡିଗ୍ ପେ ଡିଙ୍ଗ୍‌ପେବକ୍ନେ ପାପ୍ ସାପା କେମା ଆବି ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT6_16","070_6_16","MAT","6","16","16","ଉପାସ୍ ଡିଙ୍ଗ୍‌କେଲା କୁଟ୍ ଦାର୍‍ମିକ୍‍ ରକମ୍ ସାର୍ମୁଆଁ ଆରାନ୍‌ସୁଆର୍‌ଗେପା । ମେଇଂ ଉପାସ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂକେ ଡାଗ୍‌ଚେ ରେମୁଆଁଇଂନେ ସାମ୍‌ନାନ୍ନିଆ ଆସୁଏ ନ୍‌ସା ନିଜର୍ ନିଜର୍ ସାର୍ମୁଆଁ ଆନ୍‌ସୁଆର୍ ବଆର୍‌ଏ; ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଣ୍ତିଙ୍ଗ୍‌କେ ମେଇଂ ନିଜର୍ ନିଜର୍ ପୁରସ୍‌କାର୍ ବାଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT6_17","070_6_17","MAT","6","17","17","ମାତର୍‌ ପେ ଉପାସ୍ ଡିଙ୍ଗ୍‌କେଲା ସାର୍ମୁଆଁ ଗ୍ୱେମୁଆଁଚେ ବାଆଃନ୍ନିଆ ଞ୍ଚୁ ଲିଗ୍‌ଚେ ପର୍‌ଚଲ୍‌ ଡିଙ୍ଗ୍‌ଚେ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT6_18","070_6_18","MAT","6","18","18","ଡିରକମ୍‌କି ଉପାସ୍ ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ବିନ୍‌ଣ୍ଡ୍ରେଇଂ ମ୍ୟା ଆୟା ଆର୍‌ଏ ଣ୍ତୁ ମାତର୍‌ ପେନେ ଆବା ଜା ଆତ୍ନାକ୍ନେ ଇସ୍‌ପର୍ ସାପା ସାମୁଆଁ ମ୍ୟାଏ ପେ ଚିମ୍‌ଚିମ୍‌ରା ଜାଗାନ୍ନିଆ ମେଁ ମେଁନେ ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ; ଆତେନ୍‌ କେଚେ ମେଁ ପୁରସ୍‌କାର୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_19","070_6_19","MAT","6","19","19","ଆକେନ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ନିଜେ ଆତ୍‍ଲା ଦନ୍‌ସମ୍ପତି ଆର୍ଜେ ଆବଗ୍‍ପା । ଆକ୍‌ନ୍ନିଆ ବନ୍‌ସା ସିଲିମ୍‌ ସାଚେ ଆର୍ଜେକ୍ନେ ଦନ୍‌ସମ୍ପତି ନସ୍‌ଟ ଡିଙ୍ଗ୍‌ୱେଏ ଣ୍ତୁଲା ଡଙ୍ଗାରେଇଂ କୁଗ୍‌ଡାସା ଗଃଚେ ଡଙ୍ଗା ମ୍ୟାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_20","070_6_20","MAT","6","20","20","ମାତର୍‌‌ କିତଂନ୍ନିଆ ପେନ୍‌ସା ଦନ୍‌ସମ୍ପତି ରାଃସିଙ୍ଗ୍‌ପା । ଆତ୍‌ଅରିଆ ତାଃଡିର୍‍ କି ସିଲିମ୍‌ ମେଃଡିଗ୍ ନସ୍‌ଟ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ଣ୍ତୁଲା ଡଙ୍ଗାରେଇଂ ଗାଚେ ଡଙ୍ଗା ଡୁଂଡ ଆୟାଆର୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT6_21","070_6_21","MAT","6","21","21","ଡାଗ୍ଲା ଆଣ୍ଡିଅରିଆ ପେନେ ଦନ୍ ଆତ୍‌ଅରିଆ ପେନେ ମନ୍ । ");
INSERT INTO gaq_vpl VALUES ("MT6_22","070_6_22","MAT","6","22","22","ମୁଆଃ ଗାଗ୍‌ଡ଼େନେ କୁପିସ । ତେସା ପେନେ ମୁଆଃ ଅଃନା ପର୍‌ଚଲ୍‌ ଲେଃଏ, ତେଲା ପେନେ ସାପା ଗାଗ୍‌ଡ଼େ ତାର୍‌କିଗ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_23","070_6_23","MAT","6","23","23","ମାତର୍‌ ପେନେ ମୁଆଃ ଅଃନା ଦଦ୍ୟା ଲେଃଏ ତେଲା ପେନେ ସାପା ଗାଗ୍‌ଡ଼େ ତାଙ୍ଗ୍‌କିଗ୍ ଡିଙ୍ଗ୍‌ଏ ପେନେ ବିତ୍ରେନେ ତାର୍‌କିଗ୍ ଜଦି ତାଙ୍ଗ୍‌କିଗ୍ ଡିଙ୍ଗ୍‌ୱେଏ ତେଲା ଆତେନ୍‌ ତାର୍‌କିଗ୍ ଉଡ଼ି ବୟଙ୍କାର୍ ଆଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("MT6_24","070_6_24","MAT","6","24","24","“ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ମ୍ୱାୟା ମାଲିକ୍‌ନେ ଗତିରେ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ଡାଗ୍ଲା ମେଁ ମୁଇଂଜାକେ ଇଙ୍ଗ୍‌ଚେଏ ଆରି ବିନ୍ ମୁଇଂଜାକେ ଆଲାଦ୍ ଡିଂଏ ମୁଇଂଜା ଆଡ଼ାତ୍ରା ଲିବିସଲା ବିନ୍ ମୁଇଂଜାକେ ଆମାନେ ଣ୍ଡୁ । ପେଇଂ ଇସ୍‌ପର୍ ଆରି ଦନ୍‌ସମ୍ପତିକେ ମ୍ୱାୟାନେ ଗତିରେ ଡିଙ୍ଗ୍‌ଚେ ଲେଃ ପେୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT6_25","070_6_25","MAT","6","25","25","ଆତେନ୍‌‍ସା ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍ ଣ୍ଡିଙ୍ଗ୍ ପାରାନ୍ ଆମ୍ବ୍ରନ୍‌ସା ଦର୍‌କାର୍ ଲେଃକ୍ନେ ବଲେ ଆରି ଣ୍ଡିଆ ଆରି ୱାଡ଼େଗ୍‌ ନ୍‌ସା ଦର୍‌କାର୍ ଲେଃକ୍ନେ ପାଟାଇ ନ୍‌ସା ତେରେପେତେ ଆଡିଙ୍ଗ୍‌ପା । ଚଙ୍ଗ୍‌ନେବାନ୍‌ ପାରାନ୍ ମେଃନେ ଜବର୍ ମୁଲ୍ୟବାନ୍ ଣ୍ତୁ ? ପାଟାଇବାନ୍‌ ଗାଗ୍‌ଡ଼େ ମେଁନେ ଜବର୍‌ ମୁଲ୍ୟବାନ୍ ଣ୍ତୁ ? ");
INSERT INTO gaq_vpl VALUES ("MT6_26","070_6_26","MAT","6","26","26","ତ୍ରିଗ୍‌ଡ୍ୟାନେ ପ୍ଲିଗ୍‌ଇଂକେ କେଲାପା ମେଇଂ ଆବିଗ୍‌ଆର୍‌ ଣ୍ତୁ କି ଆୱେଆର୍‌ ଣ୍ତୁ ବା ଆଣ୍ଡ୍ରାଃନ୍ନିଆ ଚାଞ୍ଚେ ଆବଆର୍ ଣ୍ଡୁ ବାରି ପେନେ କିତଂନେ ଆବା ଆମେଇଂକେ ବଲେ ବିମ୍ୟାକେ । ପେଇଂ ମେଃନେ ମେଁଇଂନେ ବାନ୍ ମ୍ନା ଣ୍ତୁ ? ");
INSERT INTO gaq_vpl VALUES ("MT6_27","070_6_27","MAT","6","27","27","ଆରି, ପେନେ ବାନ୍ ଜା ଏତେ ଏତେଚେ ନିଜେନେ ଆୟୁଷ୍‌ ଦାପ୍ରେ ଆମ୍ନା ବିପେୟାଏ ? ");
INSERT INTO gaq_vpl VALUES ("MT6_28","070_6_28","MAT","6","28","28","ଆରି ପାଟାଇନ୍‌ସା ମେନ୍‌ସା ଚିନ୍ତା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ? କଣ୍ଡାନେ ସାରି ଇଂନେ ବିସୟ୍‌ରେ ବାବେଚେ ଗ୍ୟାନ୍ ଅର୍‌ଜେ କେଲାପା ଆତେନ୍‌ ଇଂ ଡିରକମ୍ ମ୍ନାଆର୍‍ ଡିଙ୍ଗ୍‌କେ । ମେଇଂ କଷ୍ଟ ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ତୁ ବାରି ମେଁ ନିଜର୍ ନ୍‌ସା ପାଟାଇ ଆରାଃରେ ଆର୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT6_29","070_6_29","MAT","6","29","29","ମାତର୍‌ ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଇଃସାଙ୍ଗ୍‌ ଶଲୋମନ୍ ମେଁନେ ସାପା ସୁନ୍ଦର୍‌ ସତେଆ ଏନ୍‌ ସାରି ରକମ୍ ଆରି ଦେକ୍ ସାରି ସୁଗୁଆ ସୁନ୍ଦର୍‌ ପାଟାଇ ଡିଗ୍ ଅଃନା ସଃଆଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT6_30","070_6_30","MAT","6","30","30","ଏକେ ଟିକ୍‌ରାନ୍ନିଆ ଲେଃକ୍ନେ ଚେଃମୁଆଁ ଆରି ଞ୍ଜଡ଼େ ଆଲେଃ ଣ୍ତୁ, ଗୁଆଃଚେ ସୁଆନ୍ନିଆ ତ୍ଲାଗ୍ଆର୍‌ଏ । ଡାଗ୍ଲା ଆତେନ୍‌ ଆଣ୍ଡେଙ୍ଗ୍ ଡିଗ୍ ଇସ୍‌ପର୍ ଉଡ଼ି ସୁନ୍ଦର୍ ପାଟାଇ ଏତେ ଆସଜେ । ଆପେକେ ପାଟାଇଟୁଟାଇ ଆର୍ମେ ବିଃ ନ୍‌ସା ମେଁ ମେଃନେ ଜବର୍ ମନ୍‌ଦ୍ୟାନ୍‌ ଆବି ଣ୍ତୁ ? ପେନେ ବିସ୍‌ବାସ୍ ସତ୍‍ରେ ଉଡ଼ି ଇକୁଡ଼ା ! ");
INSERT INTO gaq_vpl VALUES ("MT6_31","070_6_31","MAT","6","31","31","ତେସା ମେଃନେ ପେଚଙ୍ଗ୍‌ଏ ? ଆରି ମେଃନେ ପେଉଗ୍‌ଏ ? କି ମେଃନେ ନେୱାଡ଼େଗ୍‌ଏ ? ଏନ୍‌ ବାସଙ୍ଗ୍‌ଚେ ଚିନ୍ତା ଆଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT6_32","070_6_32","MAT","6","32","32","ଡାଗ୍ଲା ବିଜାତିଇଂ ଏନ୍‌ ସାପା ବିସୟ୍ ତୁର୍ ଅଲେଙ୍ଗ୍‌ଆର୍‌ଏ । ବାରି ଏନ୍‌ ସାପା ବିସୟ୍ ଜେ ପେଇଂନେ ଦର୍‌କାର୍ ଆତେନ୍‌ ପେଇଂନେ କିତଂନେ ଆବା ମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_33","070_6_33","MAT","6","33","33","ଡାଗ୍ଲା ଇସ୍‌ପର୍‌ନେ ରାଜି ବିସୟ୍‌ରେ ବାରି ଇସ୍‌ପର୍ ପେନେ ବାନ୍ ମେଃମେଃନେ ଚାଏଁଡିଙ୍ଗ୍‌କେ, ଏନ୍‌ ସାମୁଆଁ ପେନେ ମନ୍‌ନ୍ନିଆ ସେନୁଗ୍ ଜାଗା ବିଃପା । ତେଲା ମେଁ ଆପେକେ ବିନ୍ ସାପା ବିସୟ୍ ଆର୍ମେ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT6_34","070_6_34","MAT","6","34","34","ଞ୍ଜ ନ୍‌ସା ତେରେପେତେ ଆଡିଙ୍ଗ୍‌ପା ଞ୍ଜଡ଼େନେ ଚିନ୍ତା ଞ୍ଜଡ଼େ ପେଡିଙ୍ଗ୍‌ଏ ଞ୍ଜଡ଼େନେ ବିସୟ୍ ନ୍‌ସା ଚିନ୍ତା ଡିଙ୍ଗ୍‌ଚେ ଅଃକେନ୍ ତେରେପେତେକେ ଆମ୍ନା ନ୍‌ସା ଚେସ୍‌ଟା ଆଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT7_1","070_7_1","MAT","7","1","1","ବିନ୍‌ଣ୍ଡ୍ରେଇଂନେ ଦସ୍ ତୁର୍ ଆଅଲେଙ୍ଗ୍‌ପା । ତେଲା ଇସ୍‌ପର୍ ଡିଗ୍ ପେନେ ଦସ୍ ଆସା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT7_2","070_7_2","MAT","7","2","2","ବିନ୍‌ଣ୍ଡ୍ରେଇଂନେ ଦସ୍ ବିସୟ୍‌ରେ ପେ ଡିରକମ୍ ବାବ୍‌ରେ ବିଚାର୍ ଡିଙ୍ଗ୍ ପେବ‍ଏ ଇସ୍‌ପର୍ ଦେତ୍‌ରକମ୍ ପେନେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଏ । ପେ ବିନ୍‌ଣ୍ଡ୍ରେଇଂନେ ଆଡ଼ାତ୍ରା ଆଣ୍ତିନେ ନିଅମ୍ ବେବ‍ଆର୍ ପେଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ନିୟମ୍‍ରେ ଇସ୍‌ପର୍ ପେନେ ଆଡ଼ାତ୍ରା ଡିଗ୍ ବେବ‍ଆର୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT7_3","070_7_3","MAT","7","3","3","ପେ ମୁଆଃନ୍ନିଆ କାଚ୍‌ରା ଲେଃକ୍ନେ ବେଲା ନାବୟାଁ ମୁଆଃନେ କାଚ୍‌ରା ଆଡ଼ାତ୍ରା ପେ ମେନ୍‌ସା ଦ୍ୟାନ୍‌ ବିପେଡିଙ୍ଗ୍ ? ");
INSERT INTO gaq_vpl VALUES ("MT7_4","070_7_4","MAT","7","4","4","ନିଜର୍ ମୁଆଃନ୍ନିଆ କାଚ୍‌ରା ମୁଇଂ ଲେଃଲେ, ପେ ଆଣ୍ଡିନେ ସାଆସ୍‌ରେ ପେନେ ବୟାଁ ମୁଆଃବାନ୍ କାଚ୍‌ରା ଆଃତାର୍ ମ୍ୱିଏ ଡାଗ୍‌ଚେ ବାସଂପେଡିଙ୍ଗ୍ ? ");
INSERT INTO gaq_vpl VALUES ("MT7_5","070_7_5","MAT","7","5","5","ରେ କୁଟ୍‌ଣ୍ଡ୍ରେ ସେନୁଗ୍‌ ନିଜର୍ ମୁଆଃବାନ୍ କାଚ୍ରା ଆନ୍ତାର୍ ଜଗ୍‌ତ୍ଲିଗ୍‌ପା ତେନ୍‌ ଇଡ଼ିଂ ନିଜର୍ ବୟାଁନେ ମୁଆଃବାନ୍ କାଚ୍ରା ଆନ୍ତାର୍ ବିନ୍‌ସା ନିମାଣ୍ତା ବାବ୍‌ରେ କିକେ ନାୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT7_6","070_7_6","MAT","7","6","6","ଗୁସୁଃକେ ପବିତ୍ର ଜିନିସ୍‍ ଆବିଗ୍‌ପା । ଡାଗ୍ଲା ମେଁ ପ୍ଲେଗ୍‌ଚେ ଆପେକେ ଆଃଏ । ଗୁବୁଗ୍ ସେନୁଗ୍‌ ମୁକ୍ତା ଆଜଗ୍‌ତ୍ଲିଗ୍‌ପା । ମେଁନେ ମୁଲ୍ୟ ମାବୁଜେଚେ ଆମେକେ ମେଁ ଞ୍ଚଏତେ ଲେଃଚାର୍‌ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT7_7","070_7_7","MAT","7","7","7","“ସାଲ୍ୟାପା ତେଲା ଆପେକେ ବିଏ; ତୁର୍‌ପା ଡିଲାଡିଗ୍ ମିଲେଏ; କାପାଟ୍‌ନ୍ନିଆ ବଗ୍‌ପା କାପାଟ୍ ରଃ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT7_8","070_7_8","MAT","7","8","8","ଜାଣ୍ଡେ କି ସାଲ୍ୟାଏ ଆମେକେ ବିଏ; ଜାଣ୍ଡେ ତୁର୍‌ଏ ମେଁ ଅବାଏ; ଜାଣ୍ଡେ କାପାଟ୍‌ନ୍ନିଆ ବଗ୍‌ଏ ମେନ୍‌ସା କାପାଟ୍ ରଃ ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT7_9","070_7_9","MAT","7","9","9","ନେନେ ମୁଡ଼ି ଆବା ଲେଃକେ ଜେ ମେଁନେ ଉଙ୍ଗ୍‌ଡେ ରୁଟି ସାଲ୍ୟାଲା ଆମେକେ ବ୍ରି ବିଏ ? ");
INSERT INTO gaq_vpl VALUES ("MT7_10","070_7_10","MAT","7","10","10","ଣ୍ତୁଲା ମେଁ ଆଃଡ଼ ସାଲ୍ୟାଲା ଆମେକେ ମେଃନେ ବୁବଃ ବିଏ ? ");
INSERT INTO gaq_vpl VALUES ("MT7_11","070_7_11","MAT","7","11","11","ଏନ୍‌ସା ପେଇଂ ଦୁଷ୍ଟ ଡିଙ୍ଗ୍‌ଲା ଡିଗ୍ ପେ ନିଜର୍ ନିଜର୍ ଗଡ଼େଇଂକେ ନିମାଣ୍ତା ଜିନିସ୍ ବିପେଡିଙ୍ଗ୍‌କେ । ତେଲା ପେଇଂନେ କିତଂନେ ଆବା ଡାଗ୍ରା ଜାଣ୍ଡେଇଂ ସାଲ୍ୟାଏ ମେଁ ଆମେଇଂକେ ଆରି ଉଡ଼ି ନିମାଣ୍ତା ଜିନିସ୍ ଜବର୍ ବାବ୍‌ରେ ଆବି ଣ୍ତୁ !” ");
INSERT INTO gaq_vpl VALUES ("MT7_12","070_7_12","MAT","7","12","12","ପେନ୍‌ସା ବିନ୍‌ଣ୍ଡ୍ରେଇଂ ମେଁନେ ଡିଙ୍ଗ୍‌ଆର୍‌ଲେଃ ଡାଗ୍‌ଚେ ପେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ପେ ବିନ୍‌ଣ୍ଡ୍ରେଇଂ ନ୍‌ସା ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ପା । ମୋଶା ବିବକ୍ନେ ନିଅମ୍ ଆରି ବାବବାଦିଇଂନେ ଦର୍ମ ସାସ୍ତର୍‌ନ୍ନିଆ ସିକ୍ୟା ଗୁଆର୍‍ବକ୍ନେ ବ୍ନାଲିର୍ । ");
INSERT INTO gaq_vpl VALUES ("MT7_13","070_7_13","MAT","7","13","13","ଚିପାକ୍ନେ ଗାଲି ବିଚେ ୱେଲାପା । ଡାଗ୍ଲା ସାପା ଦଂସ ଆଡିଙ୍ଗ୍‍ନେସା ଡୁଂୱେନେ ନର୍କନେ ଗାଲି ସିଦା ଆରି ଅସାର୍‌ । ଗୁଲେରୁଆ ଆତେନ୍‌ ଗାଲିପାକା ୱେଆର୍‌ ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT7_14","070_7_14","MAT","7","14","14","ଡାଗ୍ଲା ମାଡାନେ ପାରାନ୍‍କେ ଡୁଂୱେନେ ଗାଲି ସିଦା ଆରି ମେଁନେ ର୍ଣ୍ଣସାଙ୍ଗ୍ ଚିପା ବାରି ଗଣ୍ଡା ରେମୁଆଁ ଆକେନ୍ ଗାଲି ତୁର୍ ଅଲେଙ୍ଗ୍ ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT7_15","070_7_15","MAT","7","15","15","“ବଣ୍ତ ବାବବାଦି ବକ୍ତାଇଂନେ ବାନ୍ ତରକ୍ ଡିଙ୍ଗ୍‌ଚେ ଲାଲାପା; ମେଇଂ ମେଣ୍ଡା ରକମ୍ ଡିଙ୍ଗ୍‌ଚେ ପେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌ଏ ମାତର୍‌ ଜିବନ୍ ବିତ୍ରେ ମେଇଂ ଗଦବାଗ୍ ! ");
INSERT INTO gaq_vpl VALUES ("MT7_16","070_7_16","MAT","7","16","16","ମେଁଇଂନେ କାମ୍ ଆଣ୍ଡେଙ୍ଗ୍‌ନେ ବାନ୍ ପେ ଆମେଇଂକେ ସାମୁଆଁ ପେୟାଏ । ଗ୍ରେଃ ବୁଟାନ୍ନିଆ ଅଙ୍ଗୁର୍ ଆଚୁ ଣ୍ତୁ ଣ୍ଡୁଲା କାଟାକଲି ସ୍ଲାନ୍ନିଆ ଲିୱା ଚୁ ଆଚୁ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT7_17","070_7_17","MAT","7","17","17","ଦେତ୍‌ରକମ୍ ସାପା ନିମାଣ୍ତା ସ୍ଲାନ୍ନିଆ ନିମାଣ୍ତା ଚୁ ଚୁଏ ଦଦ୍ୟା ସ୍ଲାଃନ୍ନିଆ ଦଦ୍ୟା ଚୁ ଚୁଏ । ");
INSERT INTO gaq_vpl VALUES ("MT7_18","070_7_18","MAT","7","18","18","ନିମାଣ୍ତା ସ୍ଲାଃନ୍ନିଆ ଦଦ୍ୟା ଚୁ ଆଚୁ ଣ୍ତୁ ଲେଃ ଦଦ୍ୟା ସ୍ଲାନ୍ନିଆ ନିମାଣ୍ତା ଚୁ ଆଚୁ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT7_19","070_7_19","MAT","7","19","19","ଆଣ୍ଡିନେଡିଗ୍‌ ସ୍ଲାଃ ନିମାଣ୍ତା ଚୁ ଆସାଃଲା ଆତେନ୍‌ ସ୍ଲାକେ ସିତଗ୍‌ଚେ ସୁଆନ୍ନିଆ ତ୍ଲାଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT7_20","070_7_20","MAT","7","20","20","ଦେତ୍‌ରକମ୍ ବଣ୍ତ ବବିଷ୍ୟତ୍ ବକ୍ତାଇଂନେ କାମ୍ ଆଣ୍ତେଙ୍ଗ୍‍ବାନ୍‌ ଆମେଇଂକେ ପେ ସାମୁଆଁ ପେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT7_21","070_7_21","MAT","7","21","21","ଜାଣ୍ଡେଇଂ ଆନେଙ୍ଗ୍ ମାପ୍ରୁ, ମାପ୍ରୁ ଡାଗ୍‌ଚେ ୱାଆର୍‌ଡିଂକେ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ସାପାରେ କିତଂଇନିନ୍ନିଆ ଗା ଆୟାଆର୍‌ ଣ୍ତୁ । ଜାଣ୍ଡେଇଂ ଆବା ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚା ଅନୁସାରେ କାମ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ମାତର୍‌‌ ମେଇଂ କିତଂଇନିନ୍ନିଆ ଗା ଆରେ । ");
INSERT INTO gaq_vpl VALUES ("MT7_22","070_7_22","MAT","7","22","22","ଇସ୍‌ପର୍‌ନେ ବିଚାର୍ ଦିନା ପିଙ୍ଗ୍‌ଚାଲା ଗୁଲେରୁଆ ଆନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଆର୍‌ଏ “ଏ ମାପ୍ରୁ ନାନେ ମ୍ନିରେ ନେନେ ଇସ୍‌ପର୍‌ନେ ନିମାଣ୍ଡା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ନେବକେ ମାପ୍ରୁ ନାନେ ମ୍ନିରେ ଗଲିଆ ନୁଆଁ ନେବକେ ବାରି ଗୁଲୁଏ ବପୁନେ କାମ୍ ଡିଙ୍ଗ୍‌ନେବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT7_23","070_7_23","MAT","7","23","23","ଆତେନ୍‌ ବେଲା ନେଙ୍ଗ୍ ଆମେଇଂକେ ମ୍ବାସଙ୍ଗ୍‌ଏ, ଆପେକେ ନେଙ୍ଗ୍ ନାମ୍ୟାକେ ଣ୍ତୁ । ଦୁରାଚାରିଇଂ ନେଙ୍ଗ୍ ଡାଗ୍ରାବାନ୍‌ ସୁଲ ୱେଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT7_24","070_7_24","MAT","7","24","24","“ଜାଣ୍ଡେ ନେଙ୍ଗ୍ ସାମୁଆଁ ଅଁଚେ ପାଲନ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ମ୍ନା ତାଲେବିର୍ ଆଡ଼ାତ୍ରା ଡୁଆ ଆଃରେ ବକ୍ନେ ବୁଦିଲେକ୍ନେ ରେମୁଆଁ ରକମ୍ । ");
INSERT INTO gaq_vpl VALUES ("MT7_25","070_7_25","MAT","7","25","25","ଜାବର୍ ଣ୍ତିଆ ଗୁର୍‌କେ ବୁରାଣ୍ଡିଆ ପାଙ୍ଗ୍‌କେ ବାରି ୱେଡ଼ିଆ ପାଙ୍ଗ୍‌କେ ଆରି ଆତେନ୍‌ ଡୁଆକେ ଜଟ୍‌କା ବଗ୍‌କେ ବାରି ଆତେନ୍‌ ଆଲଃକେ ଣ୍ତୁ ଡାଗ୍ଲା ଆତେନ୍‌ ବ୍ରି ଆଡ଼ାତ୍ରା ଆଃରେ ବଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT7_26","070_7_26","MAT","7","26","26","“ଡାଗ୍ଲା ଜାଣ୍ଡେଇଂ ନେଙ୍ଗ୍ ସାମୁଆଁ ଅଁଚେ ପାଲନ୍ ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ତୁ ମେଇଂ ବାଲିଲ ଆଡ଼ାତ୍ରା ଡୁଆ ଆଃରେ ବକ୍ନେ ନିର୍ବୁଦି ରକମ୍ । ");
INSERT INTO gaq_vpl VALUES ("MT7_27","070_7_27","MAT","7","27","27","ଜାବର୍ ଣ୍ଡିଆ ଗୁର୍‌ଚେ ବୁରାଣ୍ଡିଆ ପାଙ୍ଗ୍‌କେ ବାରି ୱେଡ଼ିଆ ପାଙ୍ଗ୍‌କେ ଆରି ଆତେନ୍‌ ଡୁଆକେ ଜଟ୍‌କା ବଗ୍‌କେ ବାରି ଆତେନ୍‌ ପାକ୍‌ଚି ଲଃକେ ବାରି ଆତେନ୍‌‌ ଲଃନେ ମ୍ନା ବୟଙ୍କାର୍ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT7_28","070_7_28","MAT","7","28","28","ଡାନେ ଜାକ ଜିସୁନେ ଆକେନ୍ ସାପା ସାମୁଆଁ ଅଁଚେ ରେମୁଆଁଇଂ ମେଁନେ ସିକ୍ୟା ଇରିଆତୁଗ୍ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT7_29","070_7_29","MAT","7","29","29","ଜିସୁ ବିନ୍‌ବିନ୍‌ନେ ଦର୍ମ ଗୁରୁ ସୁଗୁଆ ଗ୍ୟାନ୍ ମାବିଚେ ଅଦିକାର୍ ବାଲେଃକ୍ନେ ରେମୁଆଁଇଂନେ ରକମ୍ ଆମେଇଂକେ ସିକ୍ୟା ବିଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_1","070_8_1","MAT","8","1","1","ଜିସୁ କଣ୍ଡା ଆଡ଼ାତ୍ରାବାନ୍ ଜାର୍‌ଚେ ପାଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଗୁଲୁଏ ରେମୁଆଁ ମେଁନେ ପ୍ଲା ଅଲେଙ୍ଗ୍ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_2","070_8_2","MAT","8","2","2","ତେନ୍‌ ଇଡ଼ିଂ ମୁଇଂଜା କୁଷ୍ଟରଗି ମେଁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ସାର୍ଲଚେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍ରୁ ନାଁ ଚାଏଁଲା ଆନେଙ୍ଗ୍ ନିମାଣ୍ଡା ନାରାଡିଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_3","070_8_3","MAT","8","3","3","ଜିସୁ ନ୍ତି ଚ୍ଲେଚେ ଆମେକେ ଲିଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଚାଏଁଣ୍ତିଂକେ ନାଁ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ୱେଲା ।” ଆତ୍‌ବା ଆତେନ୍‌ ରେମୁଆଁ କୁଷ୍ଟରଗ୍‌ବାନ୍‌ ନିମାଣ୍ଡା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_4","070_8_4","MAT","8","4","4","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଦ୍ରିଗ୍ ମେଁ ଡାଗ୍ରା ନାଁ ଡିରକମ୍ ନିମାଣ୍ତା ନାଡିଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ନାଁ ଆଜା ଡିଗ୍ ଆବାସଙ୍ଗ୍‌ଗେ ନାମଃ; ଏବେ ୱେଲା ପୁଜାରି ଡାଗ୍ରା ୱେଚେ ନିଜେକେ ପରିକ୍ୟା ଆଡିଙ୍ଗ୍ ଡୁଂଡଲା ବାରି ନାଁ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‍ନାଲେଃକେ ଡାଗ୍‌ଚେ ଆମେଇଂକେ ସାକି ବିଃ ଆତେନ୍‌ ସାପାରେକେ ଆମ୍ୟାନ୍‌ସା ମୋଶା ଆଃରେ ବକ୍ନେ ବେଦିନ୍ନିଆ ଦାନ୍ ବିଃ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_5","070_8_5","MAT","8","5","5","ଜିସୁ କପୁର୍ନାହୁମ ଇନିନ୍ନିଆ ୱେଚାକ୍ନେ ଦାପ୍ରେ ମୁଇଙ୍ଗ୍ ମୁଇଂସ ସନ୍ୟ‍ଇଂନେ ନେତା ଆମେକେ ଅବାଚେ କୁସାମୁତି ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT8_6","070_8_6","MAT","8","6","6","“ଅ ମାପ୍ରୁ ନେଙ୍ଗ୍‌ନେ ମୁଇଙ୍ଗ୍ ଚାକର୍‌ ପକ୍ଷାଘାତ ରଗ୍ ଆସାଚେ ଡୁଆ ଡୁଲେଗ୍‌ ଲେଃକେ । ମେଁ ପିଗ୍‌ ଆୟାକେ ଣ୍ତୁ ଜାବର୍ କଷ୍ଟ ବାଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_7","070_8_7","MAT","8","7","7","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଚେ ଆମେକେ ନିମାଣ୍ତା ଣ୍ଡ୍ରାଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_8","070_8_8","MAT","8","8","8","ସେନାପତି ବାସଙ୍ଗ୍‌କେ, “ଣ୍ତୁ ମାପ୍ରୁ, ନା ନେଙ୍ଗ୍ ଡୁଆ ନାପାଙ୍ଗ୍‌ଏ, ନେଙ୍ଗ୍ ଏନ୍‌ ଇକ୍‌ଚା ଣ୍ତୁ । ନାନେ ମାତର୍‌‌ ମେତ୍‌ମୁଆଃ ବାସଙ୍ଗ୍‌ବି, ନେଙ୍ଗ୍ ଚାକର୍‌ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT8_9","070_8_9","MAT","8","9","9","ନେଙ୍ଗ୍ ଆଡ଼ାତ୍ରା କାମ୍‌ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେନେ ଅଦିନ୍‍ରେ ନେଙ୍ଗ୍ କାମ୍ ଣ୍ତିଙ୍ଗ୍‌ଲା ଡିଗ୍‌ ନେଙ୍ଗ୍ ନ୍ତିନ୍ନିଆ ଗୁଲୁଏ ସୈନିକ୍‌ ଲେଃଆର୍‌କେ । ମେଁଇଂନେ ବିତ୍ରେ ମୁଇଂଜାକେ ଜଦି ନେଙ୍ଗ୍ ୱେଲା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଲା ମେଁ ୱେଏ । ବିନ୍ ମୁଇଂଜାକେ ପାଙ୍ଗ୍‌ଲା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଲା ମେଁ ପାଙ୍ଗ୍‌ଏ । ନେଙ୍ଗ୍‌ନେ ଚାକର୍‌କେ ଆକେନ୍ ଡିଙ୍ଗ୍ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କ୍ନେ ଦାପ୍ରେ ମେଁ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_10","070_8_10","MAT","8","10","10","ଜିସୁ ଏନ୍‌ ଅଁଚେ ଇରିଆତୁଗ୍ ଡିଙ୍ଗ୍‍ୱେକେ ଆରି ମେଁନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଇଶ୍ରାଏଲ୍‌ନେ ଆଣ୍ଡିନେ ରେମୁଆଁନ୍ନିଆ ଆକେନ୍‍ ରେମୁଆଁ ରକମ୍ ବିସ୍‌ବାସ୍ ନେଙ୍ଗ୍ ନାକେକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT8_11","070_8_11","MAT","8","11","11","ମନେ ବପା ପୁର୍ବ ଦେସ୍‌ବାନ୍ ଆରି ପଶ୍ଚିମ୍ ଦେସ୍‌ବାନ୍ ଗୁଲେରୁଆ ପାଙ୍ଗ୍‌ଚେ ଅବ୍ରାହାମ୍ ଇସାକ୍ ଆରି ଜାକୁବ୍‌ ଏତେ କିତଂ ରାଜିନ୍ନିଆ ବଜି ଚଙ୍ଗ୍‌ନ୍‌ସା କଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT8_12","070_8_12","MAT","8","12","12","ଡାଗ୍ଲା ଜାଣ୍ଡେଇଂ ଏନ୍‌ ରାଜିନ୍ନିଆ ଲେଃନେ ଆମେଇଂକେ ବାଏରେ ତାଂକିଗ୍‌ନ୍ନିଆ ଜଗ୍‌ତ୍ଲିଗ୍ ବିଃଆର୍‌ଏ । ଆତ୍‌ଅରିଆ ମେଇଂ ଅଃଚେ ଗ୍ନି ଆଃଚାର୍ ଆଃଲିୟା କେଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_13","070_8_13","MAT","8","13","13","ଜିସୁ ସେନାପତିକେ ବାସଙ୍ଗ୍‌କେ “ଡୁଆ ୱେଲା । ନାନେ ଆଣ୍ଡିନେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍‍ ଆତେନ୍‌‌ଆ ଗଟେଲେ ।” ସମାନ୍ ଆତେନ୍‌ ବେଲା ମୁଇଂସ ସନ୍ୟ‍ଇଂନେ ନେତାନେ ଚାକର୍‌ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_14","070_8_14","MAT","8","14","14","ଜିସୁ ପିତର୍‌ନେ ଡୁଆ ୱେଚେ ମେଁନେ ଆତାଡ଼େକେ ସାଃବା ଆଃସାଚେ ସିଙ୍ଗ୍‌ଲାନ୍ନିଆ ଡୁଲେଗ୍‌ଲେଃକ୍ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_15","070_8_15","MAT","8","15","15","ଜିସୁ ମେଁନେ ନ୍ତି ଲିଗ୍‌କ୍ନେ ଦାପ୍ରେ ସାଃବା ଆନ୍ତାର୍‌ ୱେଗେ ଆରି ମେଁ ତଡ଼ିଆଚେ ଜିସୁନେ ସେବା ଡିଙ୍ଗ୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_16","070_8_16","MAT","8","16","16","ଲମ୍‌ଡିଗ୍ ଡିଙ୍ଗ୍‌ଲା ରେମୁଆଁଇଂ ଗୁଲୁଏ ବୁତ୍‌ଆତ୍‌ମା ସାଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଜିସୁ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଆର୍‌କେ । ମେତ୍‌ମୁଆଃ ମାତର୍‌‌ ସାମୁଆଁରେ ମେଁ ବୁତ୍‌ ଆତ୍‌ମାଇଂକେ ନୁଆଁ ବିକେ ଆରି ଆଃସି ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_17","070_8_17","MAT","8","17","17","ଏନ୍‌ବାନ୍‌ ମେଁ ଯିଶାଇୟ ବାବବାଦି ବାସଙ୍ଗ୍‍ବକ୍ନେ ପୁରନ୍‍ ଡିଙ୍ଗ୍‌କେ । ଯିଶାଇୟ ବାସଙ୍ଗ୍‌ ବକେ “ମେଁ ନେନେ ଦୁକାସୁକା ସାପା ଡୁଙ୍ଗ୍‍ରାଙ୍ଗ୍‍ଡକେ ଆରି ଆନେକେ ରଗ୍‌ବାନ୍‌ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_18","070_8_18","MAT","8","18","18","ମେଁନେ ପିତୁର୍ ପାକା ରେମୁଆଁ ରିସିଙ୍ଗ୍‍ନେ କେଚେ କେଣ୍ଡିଆ ଇନୁମେତା ୱେନେ ନ୍‍ସା ଜିସୁ ସିସ୍‍ଇଂକେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_19","070_8_19","MAT","8","19","19","ମୁଇଂଜା ଦର୍ମ ଗୁରୁ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ “ଗୁରୁ ନାଁ ଆଣ୍ଡିପାକା ନାୱେଏ ଆତ୍‌ଅରିଆ ୱେନ୍‌ସା ନେଙ୍ଗ୍ ତିଆର୍ ଡିଙ୍ଗ୍ ନ୍‌ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_20","070_8_20","MAT","8","20","20","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ନାକାଇଂନେ ପ୍ଲଗ୍‌ ଲେଃକେ, କିତଂ ପ୍ଲିଗ୍‌ଇଂନେ ଉଂଚ୍ୟା ଲେଃକେ, ଡାଗ୍ଲା ପୁଣ୍ଡେନ୍‌ସା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେନେ ବାଆଃ ବନେ ଟାନ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_21","070_8_21","MAT","8","21","21","ଜିସୁନେ ଆରି ମୁଇଙ୍ଗ୍ ସିସ୍ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ସେନୁଗ୍‌ ୱେଚେ ନେଙ୍ଗ୍ ଆବାକେ ଆତି ବିଃନ୍‌ସା ଆନେଙ୍ଗ୍ ଆଦେସ୍ ବିଃଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_22","070_8_22","MAT","8","22","22","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା ଗୁଏଃକ୍ନେ ରେମୁଆଁ ଗୁଏଃକ୍ନେ ରେମୁଆଁଇଂକେ ଆତି ବିଃଆର୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_23","070_8_23","MAT","8","23","23","ମେଃସୁଆ ଜିସୁ ସିସ୍ଇଂ ଆଃତେ ତରାନ୍ନିଆ ୱେଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_24","070_8_24","MAT","8","24","24","ଉଲୁସ୍‌ତେ କେଣ୍ଡିଆନ୍ନିଆ ମୁଇଙ୍ଗ୍ ମ୍ନାନେ ଲଉଡ଼ି ତଡ଼୍ୟାକେ ବାରି ଡଙ୍ଗାଲେଃ ଣ୍ତିଆନ୍ନିଆ ଲଗ୍‌ଡିଆ ରକମ୍ ଡିଙ୍ଗ୍‌କେ । ଡାଗ୍ଲା ଆତେନ୍‌ ବେଲା ଜିସୁ ଡୁଲେଗ୍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_25","070_8_25","MAT","8","25","25","ସିସ୍‌ଇଂ ଜିସୁକେ ଆତଡ଼୍ୟାଚେ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ଆନେକେ ରକ୍ୟା ଡିଙ୍ଗ୍ । ଣ୍ତୁଲା ନେ ଲଗ୍‌ଡ୍ୟା ନେଗୁଏଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_26","070_8_26","MAT","8","26","26","ଜିସୁ ଉତର୍ ବିକେ, “ମେଃନ୍‌ସା ଅଃକେନ୍ ବୁଟ ଇରିଆଃ ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ? ପେନେ ବିସ୍‌ବାସ୍ ମେଃନେ ଅଃକେନ୍‍ ଇକୁଡ଼ା ?” ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ତଡ଼୍ୟାଚେ ୱେଡ଼ିଆ ଆରି ଲଉଡ଼ିକେ ଦାକା ବିକେ । ଦାପେ ଦାପେ ଚିମ୍‌ଚିମ୍‌ରା ଡିଙ୍ଗ୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_27","070_8_27","MAT","8","27","27","ଆକ୍‌ବାନ୍ ସାପାରେ ଇରିଆତୁଗ୍ ଡିଙ୍ଗ୍‌ୱେଆର୍ଗେ । ମେଇଂ ନିଜେ ନିଜେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ଆର୍କେ “କ୍ମେ ଡିରକମ୍ ରେମୁଆଁ ? ୱେଡ଼ିଆ ଆରି ଲଉଡ଼ି ଡିଗ୍ ମେଁନେ ସାମୁଆଁ ମାନେଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_28","070_8_28","MAT","8","28","28","ଜିସୁ କେଣ୍ତିଆ ଆଡ଼ା ପାକାପାକି ଗାଦରୀୟ ଏରିଆ ୱେଚାକ୍ନେ ଦାପ୍ରେ ମ୍ବାୟା ବୁତ୍‌ ସାଲେଃକ୍ନେ ରେମୁଆଁ ରାଚ୍ୟାବାନ୍‌ ତାର୍‌ଚେ ଜିସୁକେ ଅବାଆର୍‌କେ । ମେଇଂ ଦେକ୍ ରକମ୍ ବୟଙ୍କାର୍ ଲେଃଆର୍‌ଗେ ଜେ ଆତେନ୍‌ ଗାଲି ବିଚେ ଜାଣ୍ଡେ ଡିଗ୍ ୱେ ୱିଗ୍‌ଡିଙ୍ଗ୍ ଆୟା ଆର୍‌ଗେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT8_29","070_8_29","MAT","8","29","29","ମେଇଂ ଜିସୁକେ କେକ୍ନେ ଦାପ୍ରେ କିରଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ଏ ଇସ୍‌ପର୍ ଉଙ୍ଗ୍‌ଡେ ! ନେଂବାନ୍ ନାନେ ମେଃନେ ଚାଏଁନାଡିଙ୍ଗ୍‌କେ ? ନେନେ ବେଲା ଙ୍କାରେ ଡିଙ୍ଗ୍‌ଲା ଆନେକେ ମେଃନେ ଡଣ୍ଡ୍ ବିଃନେ ପାଙ୍ଗ୍‌ନାଲେଃକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT8_30","070_8_30","MAT","8","30","30","ଆରି ଆତ୍‌ବାନ୍ ଉଡ଼ି ସ୍ଲ ଡାଗ୍ରା ମାନ୍ଦା ଗୁବୁଗ୍ ଚଙ୍ଗ୍ ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_31","070_8_31","MAT","8","31","31","ଆତେନ୍‌ ରେମୁଆଁଇଂନେ ବିତ୍ରେ ଲେଃକ୍ନେ ଗଲିଆଇଂ ଜିସୁକେ କୁସାମୁତି ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ଆନେକେ ଜଦି ନୁଆଁ ବିନ୍‌ସା ଚାଏଁନାଡିଙ୍ଗ୍‌ ଆତେନ୍‌ ଗୁବୁଗ୍ ମାନ୍ଦା ବିତ୍ରେ ଆନେକେ ବେବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT8_32","070_8_32","MAT","8","32","32","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ୱେଲାପା ।” ଗଲିଆଇଂ ଦାପେ ଦାପେ ରେମୁଆଁକେ ଆନ୍ତାର୍ ବିଚେ ଗୁବୁଗ୍‌ ମାନ୍ଦା ବିତ୍ରେ ଗାଆର୍‌କେ । ଗୁବୁଗ୍ ମାନ୍ଦା ୱିର୍ ଡୁଂୱେଚେ କଣ୍ଡା ଆଡ଼ାତ୍ରା ବାନ୍ ବୁନ୍ଦେ ରେଃସଚେ କେଣ୍ଡିଆନ୍ନିଆ ଲଡ଼େଚେ ଗୁଏଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_33","070_8_33","MAT","8","33","33","ଗୁବୁଗ୍ ତୁର୍‌ତ୍ୟାରେଇଂ ଡାଗ୍ରାନେ ଇନିନ୍ନିଆ ୱିର୍ ଡୁଂୱେଚେ ଗଲିଆ ସାଲେଃକ୍ନେ ରେମୁଆଁ ଆଡ଼ାତ୍ରା ମେଃନେ ଗଟେଲେଃଗେ ଆରି ବିନ୍‌ବିନ୍ ସାପା ସାମୁଆଁ ଆତ୍‌ଅରିଆ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT8_34","070_8_34","MAT","8","34","34","ତେସା ଆତେନ୍‌ ଇନିନେ ସାପାରେ ଜିସୁକେ କୁଡ଼େଃ ନ୍‌ସା ତାର୍‌ଆର୍କେ ବାରି ଆମେକେ ଅବାଚେ ଆତେନ୍‌ ଏରିଆ ଆନ୍ତାର୍ ୱିଗ୍‌ନ୍‌ସା ଜିସୁକେ ଗୁଆରି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_1","070_9_1","MAT","9","1","1","ଜିସୁ ତରାନ୍ନିଆ କଚେ କେଣ୍ତିଆ ଇନୁମେତା ଲେଃକ୍ନେ ନିଜର୍ ଇନିନ୍ନିଆ ଆଣ୍ଡେ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_2","070_9_2","MAT","9","2","2","ଆତ୍‌ଅରିଆ ମୁଇଙ୍ଗ୍ ପକ୍ଷାଘାତ ରଗିକେ ରେମୁଆଁଇଂ ମେଁନେ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌କେ । ମେଁ ମେଁନେ ସିଂଲାନ୍ନିଆ ଡୁଲେଗ୍ ଲେଃଗେ । ମେଁଇଂନେ ଅଃକେନ୍ ବିସ୍‌ବାସ୍ କେଚେ ଜିସୁ ପକ୍ଷାଗାତିକେ ବାସଙ୍ଗ୍‌କେ “ଗଡ଼େଅ ସାଆସ୍ ସା । ନାନେ ପାପ୍ ସାପା କେମା ଡିଙ୍ଗ୍ ୱେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_3","070_9_3","MAT","9","3","3","ଉଡ଼ି ଦର୍ମ ଗୁରୁ ଏନ୍‌ ସାମୁଆଁ ଅଁଚେ ମନେ ମନେ ବାବେ ଆର୍‌କେ, “ଏନ୍‌ ରେମୁଆଁ ଇସ୍‌ପର୍‌କେ ନିନ୍ଦା ଡିଂଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_4","070_9_4","MAT","9","4","4","ମେଁଇଙ୍ଗ୍‌ନେ ମନ୍‌ ବିତ୍‍ରେନେ ସାମୁଆଁ ମ୍ୟାଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ପେ ମେନ୍‌ସା ଦେକ୍‌ରକମ୍ ଦଦ୍ୟା ଚିନ୍ତା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MT9_5","070_9_5","MAT","9","5","5","ନାନେ ପାପ୍ କେମା ଡିଙ୍ଗ୍‌ୱେଗେ ? ଏନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ସ‍ଅଜ୍ ଲେଃ ତଡ଼୍ୟା ଅଲେଙ୍ଗ୍ ୱେଲା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ନେ ଜାବର୍ ସ‍ଅଜ୍ ? ");
INSERT INTO gaq_vpl VALUES ("MT9_6","070_9_6","MAT","9","6","6","ମାତର୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ପାପ୍ ଲିବିସ ଡିଙ୍ଗ୍‌ନ୍‌ସା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ଅଦିକାର୍ ଲେଃକେ ଏନ୍‌ ସାମୁଆଁ ପେ ସେନୁଗ୍‌ ପର୍‌ମାନ୍‌ ଆଃଡିଙ୍ଗ୍ ମ୍ବିଏ ।” ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ପକ୍ଷାଗାତି ରଗିକେ ବାସଙ୍ଗ୍‌କେ “ତଡ଼ିଆ ସିଙ୍ଗ୍‌ଲା ଆତଡ଼ିଆଚେ ଡୁଆ ୱିଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_7","070_9_7","MAT","9","7","7","ରଗ୍ ସାଲେଃକ୍ନେ ରେମୁଆଁ ତଡ଼ିଆଚେ ଡୁଆ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_8","070_9_8","MAT","9","8","8","ରେମୁଆଁ ଏନ୍‌ କେଚେ କାବା ଡିଙ୍ଗ୍‌ୱେଆର୍ଗେ । ଡାଗ୍ଲା ରେମୁଆଁକେ ଦେକ୍ ରକମ୍ ଅଦିକାର୍ ବିବଲା ମେଇଂ ଇସ୍‌ପର୍‌କେ ମ‍ଇମା କିର୍ତ୍ତନ୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_9","070_9_9","MAT","9","9","9","ଜିସୁ ଆତ୍‌ବାନ୍ ୱେନେ ବେଲା ମାତିଉ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ସିସ୍ତୁ ସାଲିଆଣ୍ଡ୍ରେକେ ମେଁନେ ଡାବୁ ସାଲ୍ୟାନେ ଜାଗାନ୍ନିଆ ସାଲ୍ୟାଡିଙ୍ଗ୍‌ନେ କେକେ ଆରି ଆମେକେ ୱାଚେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା ।” ମାତିଉ ତଡ଼୍ୟାଚେ ମେଁନେ ପ୍ଲା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_10","070_9_10","MAT","9","10","10","ଜିସୁ ମାତିଉନେ ଡୁଆ ଚଙ୍ଗ୍‌ନେ ବେଲା ଗୁଲୁଏ ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେ ଆରି ପାପି ରେମୁଆଁଇଂ ଜିସୁ ଏତେ ଆରି ମେଁନେ ସିସ୍‌ଇଂ ଏତେ ଚଙ୍ଗ୍ ନ୍‌ସା କଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_11","070_9_11","MAT","9","11","11","ଉଡ଼ିରୁଆ ଫାରୁଶୀଇଂ ଆତେନ୍‌ କେଚେ ଜିସୁନେ ସିସ୍ଇଂକେ ସାଲ୍ୟାକୁକେ “ପେନେ ଗୁରୁ ମେଃନ୍‌ସା ସିସ୍ତୁ ସାଲିଆଣ୍ଡ୍ରେ ଆରି ପାପିଇଂ ଏତେ ମୁଇଙ୍ଗ୍ ଅରିଆ କଚେ ଚଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT9_12","070_9_12","MAT","9","12","12","ଜିସୁ ଆତେନ୍‌ ଦ୍ରିଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ନିମାଣ୍ତା ରେମୁଆଁ ନ୍‌ସା ଗଦାର୍ ଦର୍‌କାର୍ ଣ୍ତୁ । ମାତର୍‌‌ ସାଃବା ସାଃଲେକ୍ନେ ରେମୁଆଁ ଆତ୍‍ଲା ଗଦାର୍ ଦର୍‌କାର୍ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_13","070_9_13","MAT","9","13","13","ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍ ବକେ ନେଙ୍ଗ୍ ଲିବିସ ବଲ୍ ବାମ୍ୟାଃକେ, ବଲିଦାନ୍‌କେ ଣ୍ତୁ ଏନ୍‌ ସାମୁଆଁନେ ଅର୍‌ତ ମେଁନେ ୱେଚେ ବୁଜେ ନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ପା । ନେଙ୍ଗ୍ ଦରମ୍‌ଣ୍ଡ୍ରେକେ ୱାନ୍‌ସା ପାଙ୍ଗ୍ ନାଲେଃକେ ଣ୍ତୁ; ନେଙ୍ଗ୍ ପାପିଇଂକେ ୱାନ୍‌ସା ପାଙ୍ଗ୍ ନ୍‌ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_14","070_9_14","MAT","9","14","14","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ମେଃସୁଆ ଡୁବନ୍ ବିଃନେ ଜହନ୍‌ନେ ସିସ୍ଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାକୁଆର୍‌କେ, “ନେ ଆରି ଫାରୁଶୀଇଂ ଉପାସ୍ ଡିଙ୍ଗ୍ ନେଡିଙ୍ଗ୍‌କେ ନାନେ ସିସ୍ଇଂ ମେଃନ୍‌ସା ଅଃନା ଡିଗ୍ ଉପାସ୍ ଆଡିଙ୍ଗ୍ ଆର୍‌କେ ଣ୍ତୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MT9_15","070_9_15","MAT","9","15","15","ଜିସୁ ଉତର୍ ବିକେ, “ବିଏ ଟିକାନ୍ନିଆ ଙ୍ଗିରେ ମେଇଂ ଏତେ ଲେଃ ଜାକ ଙ୍ଗିରେନେ ପାର୍ତିଇଂ ଦୁକ୍ ଆଡିଙ୍ଗ୍ ଆର୍‌ ଣ୍ତୁ ? ମାତର୍‌ ଦିନ୍ ପାଙ୍ଗ୍‌ଏ ଉଡ଼ି ବେଲା ଙ୍ଗିରେ ତାର୍‌ୱେଏ; ଆତେନ୍‌ ବେଲା ମେଇଂ ଉପାସ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_16","070_9_16","MAT","9","16","16","“ଜାଣ୍ଡେ ବାୱିର୍ ସକାନ୍ନିଆ ତ୍ମି ସକାନେ ଗର୍‌ଣ୍ଡା ଆତଗ୍‍ଆର୍‌ ଣ୍ତୁ । ଡାଗ୍ଲା ତ୍ମି ଗର୍‍ଣ୍ଡାନେ କନାନେ ସିଲାଇ ମୁନ୍ଦା ଡିଙ୍ଗ୍‌ଚେ ତେଗ୍‌ପ୍ୟାକ୍ନେ ଜାଗାନ୍ନିଆ ଜାବର୍ ସେଃଗାର୍‌ ଜଗ୍‌ତ୍ଲିଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT9_17","070_9_17","MAT","9","17","17","ଜାଣ୍ଡେ ବାୱିର୍ ଉକ୍‌ସା ମୁନାନ୍ନିଆ ତ୍ମି ଦ୍ରାକ୍ଷାରସ୍ ଆବଆର୍‌ ଣ୍ତୁ । ଡାଗ୍ଲା ମେଁନେ ବାନ୍ ଉକ୍‌ସା ମୁନା ତେକ୍‌ପ୍ୟାଚେ ନଷ୍ଟ ଡିଙ୍ଗ୍‌ଏ, ବାରି ଦ୍ରାକ୍ଷାରସ୍ ତାର୍‌ଚେ ବୁନ୍ଦେ ଲେଃଏ । ତ୍ମି ଦ୍ରାକ୍ଷାରସ୍‌କେ ତ୍ମି ଉକ୍‌ସା ମୁନାନ୍ନିଆ ବଲା ମ୍ବାୟା ଦ୍ରାକ୍ଷାରସ୍ ଆରି ମୁନା ରକ୍ୟା ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_18","070_9_18","MAT","9","18","18","ଜିସୁ ଏନ୍‌ ସାପା ଗ୍ୟାନ୍ ବିକ୍ଲା ମୁଇଙ୍ଗ୍ ଜିଉଦି ନେତା ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ସାର୍ଲଚେ ବାସଙ୍ଗ୍‌କେ “ଏକ୍ରେଆଃ ନେଙ୍ଗ୍ ଗଡ଼େଅ ଗୁଏଃ ୱେଗେ । ଡାଗ୍ଲା ନା ପାଙ୍ଗ୍‌ଚେ ମେଁନେ ଆଡ଼ାତ୍ରା ନ୍ତି ବଲା ମେଁ ଡିଲାଡିଗ୍ ମ୍ବ୍ରଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_19","070_9_19","MAT","9","19","19","ଜିଆ ଜିଆ ଜିସୁ ତଡ଼୍ୟାକେ ବାରି ମେଁ ଆରି ମେଁନେ ସିସ୍ଇଂ ଆତେନ୍‌ ନେତାନେ ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_20","070_9_20","MAT","9","20","20","ଜିସୁ ଗାଲିନ୍ନିଆ ୱେନେ ବେଲା ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୁଏଃ ରେମୁଆଁ ଜିସୁନେ ପ୍ଲା ପାକା ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ପାଟାଇ ଜାଲିପୁଆଃକେ ଲିଗ୍‌କେ । ମେଁ ଗମ୍ବାର୍ ମୁଆଃ ସାଚେ ଆବୁଲେଃ ଡିଙ୍ଗ୍‌ନେ ରଗ୍ ଡିଙ୍ଗ୍‌ଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_21","070_9_21","MAT","9","21","21","ମେଁ ମନେ ମନେ ବାସଙ୍ଗ୍‌ଡିଂଗେ, “ମାତର୍‌ ମେଁନେ ପାଟାଇ ଲିଗ୍ ମ୍ବିଲା ନେଙ୍ଗ୍ ନିମାଣ୍ତା ଣ୍ତିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_22","070_9_22","MAT","9","22","22","ଜିସୁ ପ୍ଲେଗ୍‌ଚେ ଆମେକେ କେଚେ ବାସଙ୍ଗ୍‌କେ “ଏ ଗଡ଼େଅ ସାଆସ୍ ସା ନାନେ ବିସ୍‌ବାସ୍ ଆନାକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍ ବକେ ।” ଆତେନ୍‌ ଦାପ୍ରେ ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ନିମାଣ୍ତା ଡିଙ୍ଗ୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_23","070_9_23","MAT","9","23","23","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆତେନ୍‌ ଜିଉଦି ନେତାନେ ଡୁଆ ୱେଚାକେ । ଆତ୍‌ଅରିଆ ବଗ୍‌ଡେଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ଆରି କିରମର ଡିଙ୍ଗ୍‌ଆର୍‍ଡିଂକ୍ନେ ରେମୁଆଁ ସାପାରେକେ କେଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT9_24","070_9_24","MAT","9","24","24","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ସାପାରେ ଆକ୍‌ବାନ୍ ତାର୍ ୱେଲାପା ଗଡ଼େଅ ଆଗୁଏକେ ଣ୍ତୁ । ମାତର୍‌‌ ଡୁଲେଗ୍‌ ଲେଃକେ ।” ମେଁନେ ସାମୁଆଁ ଅଁଚେ ମେଇଂ ଏଃଲ୍ୟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_25","070_9_25","MAT","9","25","25","ମାତର୍‌ ମେଇଂ ତାର୍ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଗଡ଼େଅନେ ବାକ୍ରାନ୍ନିଆ ୱେଚେ ମେଁନେ ନ୍ତି ସାଚେ ଆତଡ଼ିଆକେ ଆରି ମେଁ ଦାପେ ଦାପେ ତଡ଼ିଆ କକେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_26","070_9_26","MAT","9","26","26","ଏନ୍‌ ଗଟ୍‌ନା କବର୍ ଆତେନ୍‌ ଏରିଆ ସାପା ପାକା ଉଡ୍ରା ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_27","070_9_27","MAT","9","27","27","ଜିସୁ ଆତ୍‌ବାନ୍ ୱେନେ ବେଲା ମ୍ବାୟା କାନା ଜିସୁନେ ପ୍ଲା ପ୍ଲା ୱେଆର୍‌କେ । ମେଇଂ ୱାସାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଏ ଦାଉଦ୍ ଉଙ୍ଗ୍‌ଡେ ଆନେକେ ଦୟା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_28","070_9_28","MAT","9","28","28","ମେଇଂ ଜିସୁନେ ପ୍ଲା ୱେଚେ ମୁଇଙ୍ଗ୍ ଡୁଆ ୱେଚା ଆର୍‌କେ । ଆତ୍‌ଅରିଆ ଜିସୁ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ, “ଆପେକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍ ୟାଏ ଡାଗ୍‌ଚେ ପେଇଂ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ ପେଡିଂକେ କି ?” ମେଇଂ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ, “ଅ ମାପ୍ରୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_29","070_9_29","MAT","9","29","29","ଆତେନ୍‌ ବେଲା ଜିସୁ ମେଁଇଂନେ ମୁଆଃନ୍ନିଆ ଲିଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ପେନେ ବିସ୍‌ବାସ୍ ଇସାବ୍‌ରେ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_30","070_9_30","MAT","9","30","30","ଆତେନ୍‌ ଦାପ୍ରେ ମେଇଂ ମୁଆଃ କିକେନେ ବପୁ ବାଆର୍‌କେ; ଜିସୁ ଆମେଇଂକେ ଡାଟ୍ ରକମ୍ ଆଦେସ୍‌ ବିଚେ ବାସଙ୍ଗ୍‌କେ “ତରକ୍‌ ଲାଃଲା ! ଜାଣ୍ଡେ ଡିରକମ୍ ଏନ୍‌ ସାମୁଆଁ ଆମ୍ୟା ଆର୍‍ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_31","070_9_31","MAT","9","31","31","ମାତର୍‌ ମେଇଂ ଆତ୍‌ବାନ୍ ୱେଚେ ଜିସୁନେ ସାମୁଆଁ ସାପା ଦେସ୍ ପାକା ବାସଙ୍ଗ୍ ଅଲେଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_32","070_9_32","MAT","9","32","32","ମେଇଂ ୱେନେ ବେଲା ଉଡ଼ି ରେମୁଆଁ କନ୍ଦାକେ ମେଁ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଆର୍‌କେ । ଆମେକେ ଗଲିଆ ସାଲେଃଗେସା ମେଁ କନ୍ଦା ଡିଙ୍ଗ୍‌ୱେଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_33","070_9_33","MAT","9","33","33","ଜିସୁ ମେଁନେ ଗାଗ୍ଡ଼େବାନ୍‌ ଗଲିଆକେ ଆଃଆନ୍ତାର୍ ବିଃକ୍ନେ ଦାପ୍ରେ ମେଁ ରେମୁଆଁ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ । ସାପାରେ ଇରିଆତୁଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଇଶ୍ରାଏଲ୍ ଦେସ୍‌ନ୍ନିଆ ନେନେ ଦେକ୍ ରକମ୍ କାମ୍ ଅଃନା କେନେଲେଃଗେ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_34","070_9_34","MAT","9","34","34","ମାତର୍‌ ଫାରୁଶୀଇଂ ବାସଙ୍ଗ୍‌କେ “ଏନ୍‌ ରେମୁଆଁ ଗଲିଆଇଂନେ ଇଃସାଙ୍ଗ୍‌ନେ ବପୁରେ ଗଲିଆ ଆଃଆନ୍ତାର୍‌ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT9_35","070_9_35","MAT","9","35","35","ଜିସୁ ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ଗୁଲୁଏ ଇନି ୱେକେ । ସାପା ଜାଗାନ୍ନିଆ ମେଁ ପାର୍‍ତନା ଡୁଆଇଂନ୍ନିଆ ସିକ୍ୟା ବିକେ । କିତଂ ରାଜିନେ ନିମାଣ୍ତା ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌କେ, ବାରି ଗୁଲୁଏ ଆଃସିଲେକ୍ନେ ଆରି ରଗ୍ ସାଃଲେକ୍ନେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ତା ଆଃଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_36","070_9_36","MAT","9","36","36","ବାରି ରେମୁଆଁଇଂ କେଚେ ମେଁଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ମେଁ ଦୟାରେ ତର୍‌ବର୍‌ ଡିଙ୍ଗ୍‌କେ, ଡାଗ୍ଲା ଆମେଇଂକେ ରକ୍ୟା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଜା ଡିଗ୍ ମାଡୁଲେଗ୍‌ନେ ମେଣ୍ଡା ରକମ୍ ଦୁର୍ଦ୍ଦଶାଗ୍ରସ୍ତ ଡିଙ୍ଗ୍‌ଚେ ଚିନ୍‌ଚତର୍‌ ଡିଙ୍ଗ୍‌ଲେ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT9_37","070_9_37","MAT","9","37","37","ଆତେନ୍‌ ବେଲା ଜିସୁ ମେଁନେ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଗହମ୍ ସିନା ଜବର୍ ମାତର୍‌‌ କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଇକୁଡ଼ା । ");
INSERT INTO gaq_vpl VALUES ("MT9_38","070_9_38","MAT","9","38","38","ଜବର୍ ରେମୁଆଁ କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ବେଚେ ଗହମ୍ ୱାଡୁଂୱିଗ୍ ନ୍‌ସା ଲିଜ ମାଲିକ୍‌କେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT10_1","070_10_1","MAT","10","1","1","ଜିସୁ ମେଁନେ ଗମ୍ବାର୍ କ୍ଲିଗ୍ ସିସ୍ଇଂକେ ୱାଚେ ଗଲିଆ ଆଃଆନ୍ତାର୍ ନ୍‌ସା ଆରି ସାପା ରକମ୍ ରଗ୍ ଦୁକ୍ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍ ନ୍‌ସା ଆମେଇଂକେ ଅଦିକାର୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT10_2","070_10_2","MAT","10","2","2","ଆତେନ୍‌ ଗମ୍ବାର୍ କ୍ଲିଗ୍ ସିସ୍‌‌ଇଂନେ ମ୍ନି ଦେକ୍‌ରକମ୍ ଶିମୋନ ଜାଣ୍ଡେକି ପିତର୍ ଡାଗ୍‌ଚେ ଡିଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ଆଃରେ ଆରି ମେଁନେ ବୟାଁ ଆନ୍ଦ୍ରିୟ; ଜେବଦୀନେ ମ୍ବାକ୍ଲିଗ୍ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌ ଆରି ମେଁନେ ବୟାଁ ଜହନ୍‌; ");
INSERT INTO gaq_vpl VALUES ("MT10_3","070_10_3","MAT","10","3","3","ଫିଲିପ୍‌ ବାର୍ଥଲମି ଥୋମା ଆରି ସିସ୍ତୁ ସାଲିଆଣ୍ଡ୍ରେ ମାତିଉ ଆଲଫିନେ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌ ଆରି ଥଦ୍ଦୀୟ ");
INSERT INTO gaq_vpl VALUES ("MT10_4","070_10_4","MAT","10","4","4","କିଣାନୀୟ ଶିମୋନ ଆରି ଜିସୁନେ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍ ଗାତକତା ଡିଙ୍ଗ୍‌କ୍ନେ ଇଷ୍କରିୟଥ୍ ଜିଉଦା । ");
INSERT INTO gaq_vpl VALUES ("MT10_5","070_10_5","MAT","10","5","5","ଜିସୁ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସିସ୍‌ଇଂକେ ବେନେ ବେଲା ଆଦେସ୍‌ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ପେ ଅଣଜିଉଦି ଦେସ୍‌ନ୍ନିଆ ଆୱେଗେପା । ଆରି ଶମିରୋଣୀୟ ଇନିଡିଗ୍ ଆୱେଗେପା । ");
INSERT INTO gaq_vpl VALUES ("MT10_6","070_10_6","MAT","10","6","6","ବାରି ବଃୱେଲେଃକ୍ନେ ମେଣ୍ଡା ରକମ୍ ଇଶ୍ରାଏଲ୍‍ଇଂ ଡାଗ୍ରା ୱେଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT10_7","070_10_7","MAT","10","7","7","ମେଁଇଂନେ ଡାଗ୍ରା ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ପା କିତଂଇନି ତେପିଙ୍ଗ୍‌ଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT10_8","070_10_8","MAT","10","8","8","ଆଃସି ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌ପା ଗୁଏଃକ୍ନେ ରେମୁଆଁଇଂକେ ଆର୍‌ମୁଇଂତର୍‌ ଜିବନ୍‌ ଆଡିଙ୍ଗ୍‌ପା କୁଷ୍ଟରଗିଇଂକେ ରଗ୍ ବଲ୍ ଆଡିଙ୍ଗ୍‌ପା ଗଲିଆ ଆଆଁନ୍ତାର୍‌ପା ପେ ଆଣ୍ଡିନେ ସରାଃସ୍ରି ବାପେଲେକେ ଆତେନ୍‌ ବିନ୍‌ଣ୍ଡ୍ରେଇଂକେ ସରାଃସ୍ରି ଦାନ୍ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT10_9","070_10_9","MAT","10","9","9","ପେ ଏତେ ସୁନା ରୁପା ବା ଡାବୁ ଡୁଙ୍ଗ୍‌ଆୱେଗେପା ");
INSERT INTO gaq_vpl VALUES ("MT10_10","070_10_10","MAT","10","10","10","ୱେନେ ବେଲା ମୁନା ଡୁଂଆୱେଗେପା । ମ୍ବାକ୍ଲିଗ୍ ସକା ଆରି ଜୁତା ଆନ୍‌ତାର୍‌ଚେ ଆରି ଅଦିକା ସକା ପାଣ୍ଡୁଏ କି ଡୁଡୁ ଣ୍ଡିଗ୍ ଡୁଙ୍ଗ୍‍ ଆୱେଗେପା । ମୁଇଙ୍ଗ୍ କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ମେଁନେ ଦର୍‌କାର୍ ଲେଃକ୍ନେ ଜିନିସ୍ ଡୁଂୱେନେ ଦର୍‌କାର୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT10_11","070_10_11","MAT","10","11","11","ଆରି ପେ ମୁଃଡ଼ିନେ ନଗର୍ ବା ଇନି ଗାନେ ବେଲା ଆତ୍‌ଅରିଆ ଜା ଆପେକେ ଜତନ୍‍ ଡିଙ୍ଗ୍‌ଏ । ଆତେନ୍‌ ତୁର୍‌ପା ଆରି ବିନ୍ ଏରିଆ ୱେ ଜାକ ଆତେନ୍‌ ଡୁଆ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT10_12","070_10_12","MAT","10","12","12","ମୁଇଙ୍ଗ୍ ଡୁଆ ଗିଃଗାଃନେ ବେଲା ଆତ୍‌ଅରିଆ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଆସିର୍ବାଦ୍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ପା ପେଇଂନେ ସାନ୍ତି ଡିଙ୍ଗ୍‌ଲେ; ");
INSERT INTO gaq_vpl VALUES ("MT10_13","070_10_13","MAT","10","13","13","ଜଦି ଆତେନ୍‌ ପରିବାର୍ ରେମୁଆଁ ଜତନ୍‍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ତେଲା ଆତେନ୍‌ ପରିବାର୍ ଆଡ଼ାତ୍ରା ପେନେ ସାନ୍ତି ଡିଙ୍ଗ୍‌ଲେ ଜଦି ଆତେନ୍‌ ପରିବାର୍ ରେମୁଆଁ ଜତନ୍‍ ଆଡିଙ୍ଗ୍ ତେଲା ପେନେ ସାନ୍ତି ପେ ଡାଗ୍ରା ଆଣ୍ତେ ପାଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_14","070_10_14","MAT","10","14","14","ଜଦି ଆଣ୍ଡିନେ ଡୁଆ ଣ୍ତୁଲା ଇନିନ୍ନିଆ ଆପେକେ ରେମୁଆଁଇଂ ଗ୍ର‍ଅନ୍‌ ଆଡିଙ୍ଗ୍ ଆର୍‌ଏ ଣ୍ତୁ ଆତେନ୍‌ ଡୁଆ ଣ୍ତୁଲା ଇନିକେ ପାଦ୍‌ ଞ୍ଚନେ ଦୁଲି ତାଣ୍ତି ବିଚେ ଆତେନ୍‌ ଜାଗା ଆନ୍ତାର୍ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("MT10_15","070_10_15","MAT","10","15","15","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍, ବିଚାର୍ ଦିନାକେଲା ଆକ୍‌ମେଇଂ ବାନ୍ ସଦୋମ ଆରି ଗମୋରା ଦେସ୍‌ନେ ରେମୁଆଁଇଂ ଆଡ଼ାତ୍ରା ଇସ୍‌ପର୍ ଜବର୍ ଲିବିସ ଆଃସୁଏଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_16","070_10_16","MAT","10","16","16","“କେଲାପା, ଙ୍କୁଇଂନେ ବିତ୍ରେ ମେଣ୍ଡାଇଂନେ ରକମ୍ ସୁଗୁଆ ନେଙ୍ଗ୍‍ ଆପେକେ ବେଣ୍ଡିଂକେ । ପେ ବୁବଃ ରକମ୍ ଚାଲାକି ଡିଙ୍ଗ୍‌ଚେ ଲାଲାପା ମାତର୍‌ କୁକୁର୍ୟାଃ ରକମ୍ ଦରମ୍‌ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT10_17","070_10_17","MAT","10","17","17","ଡାଗ୍ଲା ରେମୁଆଁଇଂନେ ବାନ୍ ଚାଲାକି ଡିଙ୍ଗ୍‌ଚେ ଲାଲାପା ମାତର୍‌ ରେମୁଆଁ ଆପେକେ ସାଚେ ବିଚାର୍ କୁକପାର୍‌ନ୍ନିଆ ଡୁଂୱେଆର୍‌ଏ । ପାର୍‍ତନା ଡୁଆଇଂନ୍ନିଆ ମେଇଂ ଆମେକେ ଚାବୁକ୍ ବଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_18","070_10_18","MAT","10","18","18","ନେଙ୍ଗ୍‌ସା ପେ ଇଃସାଙ୍ଗ୍‌ ଆରି ସାସନ୍ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେନେ ସେନୁଗ୍ ଡୁଂପାଙ୍ଗ୍‍ଚେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ଆତେନ୍‌ ମେଇଂନେ ଆରି ବିଜାତିଇଂନେ ସେନୁଗ୍‌ ପେ ନେଙ୍ଗ୍ ବିସୟ୍‌ରେ ସାକି ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_19","070_10_19","MAT","10","19","19","ପେଇଂ ବିଚାର୍ ଡିଙ୍ଗ୍‌ନେ ବେଲା ମେଁନେ ପେବାସଙ୍ଗ୍‌ଏ ଆରି ଡିରକମ୍ ପେବାସଙ୍ଗ୍‌ଏ ଏନ୍‌ ବିସୟ୍‌ରେ ଅଃନା ଚିନ୍ତା ଆଡିଙ୍ଗ୍‌ପା । ଟିକ୍ ବେଲା ଆତେନ୍‌ ଆପେକେ ଆମ୍ୟା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_20","070_10_20","MAT","10","20","20","ମାତର୍‌‌ ପେ ନିଜେ ମେଁନେ ବାସଙ୍ଗ୍ ନ୍‌ସା ଆପଡ଼େ ଣ୍ତୁ । ଆବା ଇସ୍‌ପର୍‌ନେ ପବିତ୍ର ଆତ୍ମା ପେ ସାର୍ମୁଆଁ ବିଚେ ସାମୁଆଁ ବାସଙ୍ଗ୍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT10_21","070_10_21","MAT","10","21","21","ବୟାଁ ମେଃନେ ନିଜର୍ ବୟାଁକେ ଆବା ନିଜର୍ ଉଙ୍ଗ୍‌ଡେକେ ଗୁଏଃ ନ୍‌ସା ଆସା ବିଏ । ଉଙ୍ଗ୍‌ଡେଇଂ ନିଜର୍ ଆବା ଇୟାଙ୍ଗ୍ ବିରଦ୍‌ରେ ତଡ଼ିଆ ଆର୍‌ଏ ଆରି ଆମେଇଂକେ ବାଗୁଏ ଜଗ୍‌ତ୍ଲାଗ୍‌ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_22","070_10_22","MAT","10","22","22","ନେଙ୍ଗ୍‌ନ୍‌ସା ସାପାରେ ଆପେକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌ଏ; ମାତର୍‌‌ ଜାଣ୍ଡେ କି ସାରାସାରି ଜାକ ଡାଟ୍‍ରେ ଲେଃଏ, ମେଁ ଉଦାର୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_23","070_10_23","MAT","10","23","23","ମୁଇଙ୍ଗ୍ ଇନିନ୍ନିଆ ମେଇଂ ଆପେକେ କଷ୍ଟ ବିଲା ପେ ବିନ୍ ଇନିନ୍ନିଆ ଲାଗ୍‍ଡଲାପା । ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ପେଇଂ ଇଶ୍ରାଏଲ୍‌ନେ ସାପା ଇନିନ୍ନିଆ କାମ୍ ମାଡାନେ ସେନୁଗ୍‌ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଆଣ୍ତେ ପାଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_24","070_10_24","MAT","10","24","24","“ମୁଡ଼ି ସିସ୍ ଡିଗ୍ ମେଁନେ ଗୁରୁ ବାନ୍ ମ୍ନା ଣ୍ତୁ; ମାଲିକ୍‌ବାନ୍ ଚାକର୍ ମ୍ନା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT10_25","070_10_25","MAT","10","25","25","ସିସ୍ ଗୁରୁ ରକମ୍ ଆରି ଚାକର୍ ମାଲିକ୍ ରକମ୍ ଡିଙ୍ଗ୍‌ଲା ମେଇଂ ଅଃତେନ୍‌ରେ ସାର୍ଦା ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ । ମୁଇଙ୍ଗ୍ ଡୁଆଣ୍ଡ୍ରେ ମାଲିକ୍‌କେ ଜଦି ରେମୁଆଁ ବାଆଲ୍‌ଜିବୂଲ ଡାଗ୍‌ଚେ ୱାଆର୍‌ଏ ଡୁଆନେ ବିନ୍‌ଣ୍ଡ୍ରେଇଂକେ ଆରି ଅଦିକ୍‍ ଦଦ୍ୟା ମ୍ନି ଆୱା !” ");
INSERT INTO gaq_vpl VALUES ("MT10_26","070_10_26","MAT","10","26","26","“ଆତେନ୍‌‌ସା ରେମୁଆଁଇଂକେ ଆବ୍‌ଟଗେପା । ଆଣ୍ତିନେ ବୁଡ଼ିଚେ ଲେଃକେ, ଆତେନ୍‌ ମେସୁଆ ଣ୍ଡୁଲା ମେସୁଆ ପାଦା ତାର୍‌ଏ ବାରି ସାପା ବୁଡ଼ିକ୍ନେ ସାମୁଆଁ ପାଦା ତାର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_27","070_10_27","MAT","10","27","27","ନେଙ୍ଗ୍ ଆପେକେ ମେଃନେ ତାଂକିଗ୍‌ନିଆ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଅଃତେନ୍‍ ତାର୍‌କିଗ୍‌ନ୍ନିଆ ବାସଙ୍ଗ୍‌ପା ବାରି ଆଣ୍ତିନେ ବୁଙ୍ଗ୍‌ନା ଅଁପେଲେକେ ଆତେନ୍‌ ଡୁଆନେ ବ୍ଲେସାଂ ଆଡ଼ାତ୍ରା କିରଚେ ବାସଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT10_28","070_10_28","MAT","10","28","28","ଜାଣ୍ଡେଇଂ ଗାଗ୍‌ଡ଼େକେ ବାଗୁଏଃଆର୍‌ଏ, ମାତର୍‌‌ ଆତ୍ମାନେ ମେଃଡିଗ୍ ନଷ୍ଟ ଆଡିଙ୍ଗ୍ ଆୟାଆର୍‌ ଣ୍ତୁ ଆମେଇଂକେ ଆବ୍ଟଗ୍‌ପା ନାମଃ । ଆତେନ୍‌‌ସା ଆଣ୍ତିନେ ଇସ୍‌ପର୍ ପେନେ ଗାଗ୍‌ଡ଼େ ଆରି ଆତ୍ମା ମ୍ବାୟାକେ ନର୍କେନ୍ନିଆ ନଷ୍ଟ ଆଡିଙ୍ଗ୍‌ଏ ଆମେକେ ବୁଟପା । ");
INSERT INTO gaq_vpl VALUES ("MT10_29","070_10_29","MAT","10","29","29","ମ୍ବାକ୍ଲିଗ୍ କିଆପିଗ୍‌କେ ମ୍ବାର୍‌ଟାଆଁ ଡାବୁରେ ଆସ ଣ୍ଡୁ ? ମାତର୍‌‌ ଆବା ଇସ୍‌ପର୍‌ନେ ବିନା ଅନୁମତିରେ ମୁଇଙ୍ଗ୍ କିଆପିଗ୍ ଡିଗ୍ ବୁନ୍ଦେ ଆଲ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT10_30","070_10_30","MAT","10","30","30","ମାତର୍‌ ପେନେ ବାଆଃନେ ସର୍‌ତେ ଉଗ୍‌ବ ଡିଗ୍ ଏଜା ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT10_31","070_10_31","MAT","10","31","31","ଆବ୍‌ଟଗେପା; ପେ ଗୁଲୁଏ କିଆପିଗ୍ ବାନ୍ ମ୍ନା ।” ");
INSERT INTO gaq_vpl VALUES ("MT10_32","070_10_32","MAT","10","32","32","ଜାଣ୍ଡେକି କୁଲାକୁଲି ବାବ୍‌ରେ ଆନେଙ୍ଗ୍ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ବାଲିର୍‍ ଆର୍‍ଏ, ନେଙ୍ଗ୍‌ନେ କିତଂ ଆବା ଡାଗ୍ରା ଆମେକେ ନେଙ୍ଗ୍‌ନେ ସିସ୍‌‌ ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍ ମ୍ବାସଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_33","070_10_33","MAT","10","33","33","ଡାଗ୍ଲା ଜାଣ୍ଡେକି ରେମୁଆଁନେ ସାମ୍‌ନାନ୍ନିଆ ଆନେଙ୍ଗ୍ ଅବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଏ ନେଙ୍ଗ୍ ଆମେ ଡିଗ୍ ନେଙ୍ଗ୍‌ନେ କିତଂନେ ଆବାନେ ସାମ୍‌ନାନ୍ନିଆ ଅବିସ୍‌ବାସ୍‌ ଣ୍ତିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_34","070_10_34","MAT","10","34","34","“ନେଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ସାନ୍ତି ବିଃନ୍‌ସା ପାଙ୍ଗ୍‌ନ୍ଲେକେ, ଡାଗ୍‌ଚେ ମନେ ଆଡିଙ୍ଗ୍‌ପା । ନେଙ୍ଗ୍ ସାନ୍ତି ବିଃନ୍‌ସା ପାଙ୍ଗ୍ ନାଲେଃକେ ଣ୍ତୁ କାଣ୍ଡା ବିଃନ୍‌ସା ପାଙ୍ଗ୍ ନ୍‌ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT10_35","070_10_35","MAT","10","35","35","ନେଙ୍ଗ୍‌ନ୍‌ସା ଉଙ୍ଗ୍‌ଡେ ଆବାକେ ବିରଦ୍ ଡିଙ୍ଗ୍‌ଏ ଗଡ଼େଅ ଇୟାଙ୍ଗ୍‌କେ ବିରଦ୍ ଡିଙ୍ଗ୍‌ଏ ବାରି ଆତାଡ଼େ ବିରଦ୍‌ରେ ମାଚୁଆ ତାର୍‌ଏ ");
INSERT INTO gaq_vpl VALUES ("MT10_36","070_10_36","MAT","10","36","36","ନିଜର୍ ପରିବାର୍‌ନେ ରେମୁଆଁ ମୁଇଂଜାନେ ସତ୍ରୁ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT10_37","070_10_37","MAT","10","37","37","“ଜାଣ୍ଡେକି ନିଜର୍ ଆବା କି ଇୟାଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ବାନ୍ ଜାବର୍ ବଲ୍ ବାଏ ମେଁ ନେଙ୍ଗ୍‌ନେ ସିସ୍‌‌ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ଜାଣ୍ଡେକି ନିଜର୍ ଉଙ୍ଗ୍‌ଡେ କି ଗଡ଼େଅ ଆଡ଼ାତ୍ରା ଜାବର୍ ବଲ୍ ବାଏ । ମେଁ ନେଙ୍ଗ୍‌ନେ ସିସ୍‌‌ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT10_38","070_10_38","MAT","10","38","38","ଜାଣ୍ଡେକି ନିଜର୍ କୁରୁସ୍‍ ଡୁଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍ ପ୍ଲା ଆପାଙ୍ଗ୍‌ ଣ୍ତୁ ମେଁ ନେଙ୍ଗ୍‌ନେ ସିସ୍‌‌ ଡିଙ୍ଗ୍‌ନେ ଜଗ୍ୟ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MT10_39","070_10_39","MAT","10","39","39","ଜାଣ୍ଡେକି ନିଜର୍ ଜିବନ୍‌ ରକ୍ୟା ଆଡିଙ୍ଗ୍ ନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ଏ, ମେଁ ଆତେନ୍‌ ଆନ୍ତାର୍‌ଏ; ବାରି ଜାଣ୍ଡେ ନେଙ୍ଗ୍‌ନ୍‌ସା ନିଜର୍ ପାରାନ୍ ଆନ୍ତାର୍‌ଏ ମେଁ ଆତେନ୍‌ ଆମ୍ବ୍ର‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT10_40","070_10_40","MAT","10","40","40","“ଜାଣ୍ଡେ ଆପେକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଆନେଙ୍ଗ୍ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ଜାଣ୍ଡେ ଆନେଙ୍ଗ୍ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଆନେଙ୍ଗ୍ ବେବକ୍ନେ କର୍ତ୍ତାକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_41","070_10_41","MAT","10","41","41","ଜାଣ୍ଡେକି ମୁଇଙ୍ଗ୍ ବାବବାଦିକେ ଇସ୍‌ପର୍‌ନେ ଦୁତ୍ ଡାଗ୍‌ଚେ ସାର୍ଲ‍ଏ ମେଁ ଆତେନ୍‌ ବାବବାଦିନେ ପୁରସ୍‌କାର୍‌ନ୍ନିଆ ବାଗ୍ ଡିଂଏ; ଆରି ଜାଣ୍ଡେକି ମୁଇଙ୍ଗ୍ ସାଦୁ ରେମୁଆଁ ମେଁନେ ସାଦୁ କେଚେ ଗୁର୍‌ନା ଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ରେମୁଆଁନେ ପୁରସ୍‌କାର୍‌ରେ ମେଁ ବାଗ୍‌ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT10_42","070_10_42","MAT","10","42","42","ଜାଣ୍ଡେକି ନେଙ୍ଗ୍‌ନେ ସାପାବାନ୍‍ ଡାଆଁ ସିସ୍‍କେ ମୁଇଙ୍ଗ୍ ଗିନାନ୍ନିଆ ଚୁଇଡ଼ିଆକ୍ନେ ଣ୍ଡିଆ ଉଗ୍‍ନେ ବିଏ, ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍, ମେଁ ଡି ବାବ୍‌ରେ ଡିଗ୍ ପୁରସ୍‌କାର୍ ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT11_1","070_11_1","MAT","11","1","1","ଜିସୁ ମେଁନେ ଗମ୍ବାର୍ କ୍ଲିଗ୍ ସିସ୍ଇଂକେ ଆକେନ୍ ସାପା ଆଦେସ୍‍ ବିଃଡାଲା ଆତେନ୍‌ ଜାଗା ଆନ୍‌ତାର୍‌ଚେ ଇନିନ୍ନିଆ ୱେକେ ଆରି ସିକ୍ୟା ବିନେସା ବାରି ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‍ନେସା ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_2","070_11_2","MAT","11","2","2","ଆତେନ୍‌ ବେଲା ଣ୍ଡିଆନ୍ନିଆ ଦିକ୍ୟା ବିଣ୍ଡ୍ରେ ଜହନ୍ ବନ୍ଦି ସାଲ୍‍ନ୍ନିଆ ଲେଃଗେ । କ୍ରିସ୍ଟ ମେଁନେ ସାପା କାମ୍ ଡିଙ୍ଗ୍‍ବଗେ ମେଁନେ ସାମୁଆଁ ଅଁ ମେଁ ନିଜେନେ ମ୍ବାୟା ସିସ୍‍କେ କିସ୍‌ଟ ଡାଗ୍ରା ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_3","070_11_3","MAT","11","3","3","ମେଇଂ ୱେଚେ ଜିସୁକେ ସାଲ୍ୟାକୁକେ “ମୁଡ଼ି ରେମୁଆଁ ପାଙ୍ଗ୍‌ଏ ଡାଗ୍‌ଚେ ଜହନ୍ ବାସଙ୍ଗ୍‌ ବଗେ ନା ମେଃନେ ମେଁ ? ଲେଃନେ ବିନ୍ ଆଜାକେ ଉର୍‍ନେଲେଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MT11_4","070_11_4","MAT","11","4","4","ଜିସୁ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ “ପେ ଆଣ୍ଡେ ୱିଗ୍‍ଚେ ମେଁନେ କେପେଡିଙ୍ଗ୍ ଆରି ଅଁପେଡିଙ୍ଗ୍‍ ଆତେନ୍‌ ୱେଚେ ଜହନ୍‍କେ ଆମ୍ୟାପା । ");
INSERT INTO gaq_vpl VALUES ("MT11_5","070_11_5","MAT","11","5","5","କାନାଇଂ କେୟା ଡିଂଆର୍‌କେ, ଚଟାଇଂ ଅଲେଙ୍ଗ୍ ଡିଂଆର୍‌କେ, କୁଷ୍ଟରଗି‍ଇଂ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂକେ, ବଇରାଇଂ ଅଁଆର୍‌ଡିଂକେ, ଗୁଏଃକ୍ନେ ରେମୁଆଁଇଂ ବାର୍‌ ମୁଇଂତର୍ ଜିବନ୍ ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଂକେ ବାରି ଦରିଦ୍ର ରେମୁଆଁଇଂନ୍ନିଆ ଡିଗ୍ ନିମାଣ୍ଡାନେ ସାମୁଆଁ ସାଲ୍ୟାକୁ ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_6","070_11_6","MAT","11","6","6","ନେଙ୍ଗ୍‌ନେ ବିସୟ୍‌ରେ ଜାଣ୍ଡେନେ ମେଃଡିଗ୍ ସନ୍ଦେଅ ଆଲେଃ । ମେଁ ନିମାଣ୍ଡା ?” ");
INSERT INTO gaq_vpl VALUES ("MT11_7","070_11_7","MAT","11","7","7","ଜହନ୍‍ନେ ସିସ୍‍ଇଂ ଆଣ୍ଡେନେ ବେଲା । ଜିସୁ ରେମୁଆଁଇଂକେ ଜହନ୍ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌କେ, “ପେ ଜହନ୍‍କେ କେନ୍‍ସା ଉଡ଼ି ବେଲା ବାଲିଲନ୍ନିଆ ୱେପେଲେ ମେଁନେ କେନ୍‍ସା ଆସା ଡିଙ୍ଗ୍‍ପେଲେ ? ୱେଡ଼ିଆରେ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ଗାଆଁ ନାଲେଃକେ ? ");
INSERT INTO gaq_vpl VALUES ("MT11_8","070_11_8","MAT","11","8","8","ଆଜାକେ କେନ୍‍ସା ତାର୍ ୱେପେଲେକେ ? ମେଃନେ ଜବର୍‍ ଦାମ୍‍ନେ ସକା ସଲେଃକ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁକେ ? ଦେତ୍‌ରକମ୍ ସକା ସଲେଃକ୍ନେ ରେମୁଆଁଇଂ ଇଃସାଙ୍ଗ୍‌ ପ୍ରାସାଦ୍‍ନିଆ ଲେଃମ୍ୟାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_9","070_11_9","MAT","11","9","9","ଆନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ମେଁନେ କେନ୍‍ସା ୱେପେଲେଗେ । ମୁଇଙ୍ଗ୍ ବାବବାଦିକେ ? ଆତେନ୍‌ ତ ଡିଲାଡିଗ୍ ସତ୍ ମାତର୍‌ ବାବବାଦି ବାନ୍ ମୁଇଙ୍ଗ୍ ଜାବର୍ ମ୍ନା ରେମୁଆଁଇଂକେ ଅବା ପେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_10","070_11_10","MAT","11","10","10","ମେଁନ୍‌ସା ଡାଗ୍ଲା ଏନ୍‌ ଜହନ୍ ବିସୟ୍‌ରେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ ବଆର୍‌କେ ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‌କେ, ପେ ନ୍‌ସା ଗାଲି ଆରେନ୍‍ସା ନେଙ୍ଗ୍ ସେନୁଗ୍‍ ନେଙ୍ଗ୍‌ନେ ଦୁତ୍‍କେ ମ୍ବେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT11_11","070_11_11","MAT","11","11","11","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଏଃକେ ଜାକ ଏନ୍‌ ଦର୍‌ତନିନ୍ନିଆ ଉଡ଼ିରୁଆ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେ ଆର୍‌କେ ମେଁଇଙ୍ଗ୍‌ନେ ସାପାରେବାନ୍‍ ଜହନ୍ ମ୍ନା ମାତର୍‌ କିତଂ ରାଜିନ୍ନିଆ ଜା ସାପାରେବାନ୍‍ ଡାଆଁ ମେଁ ଜହନ୍ ବାନ୍ ମ୍ନା । ");
INSERT INTO gaq_vpl VALUES ("MT11_12","070_11_12","MAT","11","12","12","ଜହନ୍ ମେଁନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌‌ ଡିଙ୍ଗ୍‌କ୍ନେ ବାନ୍ ଏଃକେ ଜାକ କିତଂ ରାଜିନ୍ନିଆ ଜାବର୍ କିରମର ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂକେ । ଦଦ୍ୟା ବୁଦିନେ ରେମୁଆଁଇଂ ଆତ୍‍ନିୟା ବପୁ ଆସୁଏଚେ ଅଦିକାର୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_13","070_11_13","MAT","11","13","13","ଜହନ୍ ପାଙ୍ଗ୍‌ ଜାକ ମୋଶାନେ ନିଅମ୍ ବାରି ବାବବାଦି‍ଇଂନେ ସାମୁଆଁ କିତଂ ରାଇଜ୍ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_14","070_11_14","MAT","11","14","14","ଜଦି ମେଁଇଂନେ ସାମୁଆଁ ସତ୍ ପେମାନେଏ ତେଲା ଜହନ୍ ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ ଏଲୀୟ ଜାଣ୍ଡେ ସେନୁଗ୍‍ ପାଙ୍ଗ୍‌ନେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_15","070_11_15","MAT","11","15","15","ଜାଣ୍ତେନେ ଦ୍ରିଗ୍ ନ୍‌ସା ନ୍‌ଲୁଗ୍ ଲେଃକେ ମେଁ ଦ୍ରିଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT11_16","070_11_16","MAT","11","16","16","“ଏନ୍‌ ଜୁଗ୍‍ନେ ରେମୁଆଁଇଂ ଜା ଏତେ ସମାନ୍ ଣ୍ଡ୍ରାଡିଙ୍ଗ୍‌ଏ ? ମେଇଂ ସାନ୍ତା ମଜେ କଚେ ବ୍ଲୁଡିଙ୍ଗ୍‍କ୍ନେ ଗଡ଼େଇଂ ସୁଗୁଆ ମୁଇଂପାକାନେ ଗଡ଼େଇଂ ବିନ୍ ପାକାଣ୍ଡ୍ରେକେ ବାସଙ୍ଗ୍ଏ ");
INSERT INTO gaq_vpl VALUES ("MT11_17","070_11_17","MAT","11","17","17","ସାମୁଆଁନେ ବିହେ ଡୁଆ କାଣ୍ଡେଙ୍ଗ୍‍ ନେବଗ୍‌କେ, ମାତର୍‌ ପେ ପେୱାକେ ଣ୍ଡୁ । ନେ ଦୁକ୍‍ନେ ଅସ୍‌ମାର୍ ନେସାର୍‍କେ ମାତର୍‌ ପେ ପେଅଁକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT11_18","070_11_18","MAT","11","18","18","ଜହନ୍‌ ପାଙ୍ଗ୍‌ଚେ ଉପାସ୍ ଡିଙ୍ଗ୍ ଡିଙ୍ଗେ ମାତର୍‌ ଦ୍ରାକ୍ଷାରସ୍ ଉଗ୍ ଆଡିଙ୍ଗ୍‌ଗେ ଣ୍ଡୁ, ଆରି ରେମୁଆଁଇଂ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, ଆମେକେ ବୁତ୍‌ ସାଃଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_19","070_11_19","MAT","11","19","19","ଉଡ଼ିବେଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ଚେ ଚଙ୍ଗ୍ ଉଗ୍‍କେ ସାପାରେ ବାସଙ୍ଗ୍‌କେ, ଏନ୍‌ ରେମୁଆଁକେ କେଲାପା । ମୁଇଙ୍ଗ୍ କାଉରା ଗିଃଗାଃ ବାରି ମଦୁଆ ସିସ୍ତୁ ସାଲିଆଣ୍ଡ୍ରେ ଆରି ପାପିଇଂନେ ସାଙ୍ଗ; ମାତର୍‌ ଇସପର୍‍ନେ ଜ୍ଞାନ୍‍ ନିଜର୍‌ନେ କାମ୍ ବାନ୍ ଆତେନ୍‌ ସତ୍ ଡାଗ୍‌ଚେ ଆମ୍ୟା ପେବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT11_20","070_11_20","MAT","11","20","20","ଆଣ୍ଡିନେ ଇନିନ୍ନିଆ ଜିସୁ ମେଁନେ କାବା ସୁଗୁଆ ଜାବର୍ କାମ୍ ଡିଙ୍ଗ୍‍ବଗେ ଆତେନ୍‌ ଏରିଆନେ ରେମୁଆଁ ମେଁଇଙ୍ଗ୍‌ନେ ପାପ୍‍ ଆତ୍‍ଲା ମନେ ମାଏତେନେ କେଚେ ଜିସୁ ଆତେନ୍‌ ଇନି‍ଇଂକେ ତିରସ୍କାର୍‍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT11_21","070_11_21","MAT","11","21","21","ଅ କୋରାଜିନ ଉଡ଼ି ବୟାଙ୍କାର୍‌ ଡଣ୍ଡ୍‍ ପେବାଏ ! ବେଥ୍‍ସାଇଦା ପେନେ ଡଣ୍ଡ୍ ଡିଗ୍ ବୟ୍‍ଙ୍କାର୍‍ । ପେ ବିତ୍ରେ ମୁଡ଼ିନେ ଇରିଆତୁଗ୍ କାମ୍‌ଇଂ ଡିଙ୍ଗ୍‌ବଆର୍‌କେ ଆତେନ୍‌‌ ସାପା ଜଦି ସୋର ଆରି ସୀଦୋନନ୍ନିଆ ଡିଙ୍ଗ୍‌ ପାବଆର୍‌ ଆତ୍‌ଅରିଆନେ ରେମୁଆଁଇଂ ଗାଗ୍‌ଡ଼େ ଉଗ୍‌ସ ଲିଗ୍‌ବୁର୍‌ଚେ ବାସ୍ତା ୱାଡ଼େଗ୍‌ଚେ ଦୁକ୍‌ ପାଡିଙ୍ଗ୍‌ଆର୍‌ । ");
INSERT INTO gaq_vpl VALUES ("MT11_22","070_11_22","MAT","11","22","22","ନେଙ୍ଗ୍ ନିମାନ୍‍ ସୁଗୁଆ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଇସ୍‌ପର୍ ବିଚାର୍ ଡିଙ୍ଗ୍‌କେଲା ପେନେ ଡଣ୍ଡ୍ ବାନ୍‌ ସୋର ଆରି ସୀଦୋନନେ ରେମୁଆଁଇଂକେ ଜାବର୍ ଲିବିସ ଆଃସୁଏ । ");
INSERT INTO gaq_vpl VALUES ("MT11_23","070_11_23","MAT","11","23","23","“ରେ କୁପର୍ନହୁମ୍‍ ବାସା ଲେଃକ୍ନେଣ୍ଡ୍ରେ ! ନାଁ ମେଃନେ ନିଜେ କିତଂ ୱେନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ ? ନାଁ ନର୍କେ ନାଲଃଏ । ନାଁ ଡାଗ୍ରା ମୁଡ଼ି କାବା ଡିଂନେ କାମ୍‌ ଡିଙ୍ଗ୍‍ବକେ ଆତେନ୍‌ ଜଦି ସଦୋମନ୍ନିଆ ଡିଙ୍ଗ୍‍ପାବ ଆତେନ୍‌ ନଗର୍ ଏଜାକ ଡାଟ୍ ଡିଙ୍ଗ୍‌ଚେ ପାଲେଃ । ");
INSERT INTO gaq_vpl VALUES ("MT11_24","070_11_24","MAT","11","24","24","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ ଇସ୍‌ପର୍ ବିଚାର୍ ଡିଙ୍ଗ୍ ଦିନା ପେବାନ୍ ସଦୋମ ଦେସ୍‌ନେ ରେମୁଆଁଇଂ ଆଡ଼ାତ୍ରା ଜାବର୍ ଦୟା ଆଃସୁଏଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT11_25","070_11_25","MAT","11","25","25","ଆତେନ୍‌ ବେଲା ଜିସୁ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଅ ଆବା କିତଙ୍ଗ୍‌ଇନି ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ନେ ମାପ୍ରୁ ପେ ଜ୍ଞାନି ଆରି ସିକିତ୍‍ ରେମୁଆଁଇଂନ୍ନିଆ ବୁଡ଼ିଚେ ଅସିକିତ୍‍ ରେମୁଆଁଇଂନ୍ନିଆ ଆତ୍ନା ନାବଗେସା ନେଙ୍ଗ୍ ଆନାକେ ଦନ୍ୟବାଦ୍‍ ବିଃଣ୍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT11_26","070_11_26","MAT","11","26","26","ଅ ଆବା ନାନେ ଇକ୍‌ଚାରେ ଏନ୍‌ ସାପା ଗଟେ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT11_27","070_11_27","MAT","11","27","27","“ନେମ୍ବା ଆବା ଆନେଙ୍ଗ୍‌କେ ସାପା କିଚି ଦାନ୍ ଡିଙ୍ଗ୍ ବକେ । ଆବାକେ ଆନ୍ତାର୍‍ଚେ ଉଙ୍ଗ୍‌ଡେ ଆରି ଜା ଆମ୍ୟାକେ ଣ୍ଡୁ । ଉଙ୍ଗ୍‌ଡେ ଜାଣ୍ଡେଇଂ ଡାଗ୍ରା ଆବାକେ ଆତ୍ନାଏ ମାତର୍‌ ମେଇଂଆ ଆବାକେ ମ୍ୟାଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT11_28","070_11_28","MAT","11","28","28","ଏ ଆଲିଆରେ ଲେଃକ୍ନେ ରେମୁଆଁ ଆରି ଆଃସି ଲେଃକ୍ନେ ରେମୁଆଁଇଂ ସାପାରେ ନେଙ୍ଗ୍‍ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଲାପା ନେଙ୍ଗ୍ ଆପେକେ ପୁଣ୍ଡେନ୍‌ସା ମ୍ୱିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT11_29","070_11_29","MAT","11","29","29","ନେଙ୍ଗ୍‌ନେ ରିଗ୍‍ନ ଡୁଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍ ବାନ୍ ସିକେପା । ଡାଗ୍ଲା ନେଙ୍ଗ୍ ନିଜେ ଦରମ୍‌ ବାରି ସିଦା ଡିଙ୍ଗ୍‍ଲେଲା ପେ ଆତ୍ମାନ୍ନିଆ ପେପୁଣ୍ଡେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT11_30","070_11_30","MAT","11","30","30","ନେଙ୍ଗ୍ ପେନେ ଆଡ଼ାତ୍ରା ଆଣ୍ଡିନେ ରିଗ୍‍ନ ମ୍ବ‍ଏ ଆତେନ୍‌ ଡୁଙ୍ଗ୍‍ନେସା ସ‍ଅଜ୍ । ବାରି ଆନାକେ ଆଣ୍ଡିନେ ଲିଗିଙ୍ଗ୍‍ ମ୍ୱିଏ ଆତେନ୍‌ ଡିଗ୍ ଜାବର୍‌ ଉସାସ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("MT12_1","070_12_1","MAT","12","1","1","ଏନ୍‌ ଉଡ଼ିସି ଇଡ଼ିଙ୍ଗ୍ ମୁଇଂତର୍ ପୁଣ୍ଡେନେ ଦିନା ଜିସୁ ଲିଜ ପାକା ବିଚେ ୱେଡିଂଗେ । ମେଁନେ ସିସ୍ଇଂ କେଡ଼େସଲା ମେଇଂ କେଡ଼୍‌ବାନ୍ ଗହମ୍ ଟିକ୍‌ଚିଚେ ଚଙ୍ଗ୍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_2","070_12_2","MAT","12","2","2","ଫାରୁଶୀଇଂ ଏନ୍‌ କେଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “କେଲା ପୁଣ୍ଡେନେ ଦିନା ମେଃଡିଗ୍ ଡିଙ୍ଗ୍‌ନେ ନିୟମ୍‌ ଣ୍ଡୁ, ପେନେ ସିସ୍‍ଇଂ ଡିରକମ୍ ସାସ୍ତର୍‌ନେ ବିରଦ୍‍ କାମ୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_3","070_12_3","MAT","12","3","3","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ, “ମେସୁଆ ଦାଉଦ୍ ବାରି ମେଁନେ ସାଙ୍ଗଡ଼େଇଂ କେଡ଼େସ ଲେଃ କେଲା ଦାଉଦ୍ ମେଁ ଡିଙ୍ଗ୍‌କେ ପେ ସାସ୍ତର୍‌ନ୍ନିଆ ପେପଡ଼େକେ ? ");
INSERT INTO gaq_vpl VALUES ("MT12_4","070_12_4","MAT","12","4","4","ମେଇଂ ଆତେନ୍‌ ଦିନା ମନ୍ଦିର୍‍ ବିତ୍ରେ ୱେଚେ ଇସ୍‌ପର୍‌ନେ ଉଦେସ୍‍ରେ ବିବକ୍ନେ ରୁଟି ଚଙ୍ଗ୍‌ଆର୍‌ଗେ । ସାସ୍ତର୍‌ ଇସାବ୍‌ରେ ଜାଜକ୍‍କେ ଆନ୍ତାର୍ଚେ ଆତେନ୍‌ ରୁଟି ଚଙ୍ଗ୍‌ନେସା ବିନ୍‌ଣ୍ଡ୍ରେନେ ଜାନେ ଅଦିକାର୍ ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_5","070_12_5","MAT","12","5","5","ପେ ମେଃନେ ପେପଡ଼େକେ ? ମୋଶାନେ ନିଅମ୍ ଅନୁସାରେ ଜାଜକ୍‍ଇଂ ପୁଣ୍ଡେନେ ବାର୍‍ ଦିନା ମନ୍ଦିର୍‍ ବିତ୍ରେ ଗିଗେନେବାନ୍ ପୁଣ୍ଡେନେ ଦିନ୍‌କେ ନିଅମ୍‌କେ ଆମାନେଲା ଡିଗ୍ ଆତେନ୍‌‍ସା ମେଁଇଂ ଦସି ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("MT12_6","070_12_6","MAT","12","6","6","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ମନ୍ଦିର୍‍ ବାନ୍ ମ୍ନା ରେମୁଆଁ ଏଃକେ ଆକ୍‌ଅରିଆ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_7","070_12_7","MAT","12","7","7","ସାସ୍ତର୍‌ ବାସଙ୍ଗ୍‌ଏ ନେଙ୍ଗ୍ ଚାଏଁ ଣ୍ଡିଙ୍ଗ୍‍କେ ଲିବିସ ପୁଜା ବିଃନେ ଣ୍ଡୁ; ଏନ୍ ସାମୁଆଁନେ ଅର୍‌ତ ଜଦି ସତ୍‍ରେ ବୁଜେପେୟା ଏନ୍ ଦସ୍‌ ଣ୍ତୁନେ ରେମୁଆଁଇଂକେ ପେଇଂ ଦସ୍‌ ପେପାଡିଙ୍ଗ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_8","070_12_8","MAT","12","8","8","ବୁଜେବପା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପୁଣ୍ଡେନେ ଦିନା ନିଜେ ମାପ୍ରୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_9","070_12_9","MAT","12","9","9","ଜିସୁ ଆତେନ୍‌ ଜାଗା ବାନ୍ ୱେଚେ ପାର୍‍ତନା ଡୁଆ ବିତ୍ରେ ଗାଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_10","070_12_10","MAT","12","10","10","ମୁଇଙ୍ଗ୍ ନ୍ତି ଆତୁକ୍‍କ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଆତ୍‍ ଅରିଆ ଲେଃଗେ । ଜିସୁକେ ଦସି ସାଃନ୍‌ସା ମାନ୍ଦା ରେମୁଆଁ ଆତ୍‍ ଅରିଆ ଉର୍‍ଲେଃଗେ । ଆତେନ୍‌‍ସା ମେଇଂ ଜିସୁକେ ସାଲ୍ୟାଆର୍‌କେ “ପୁଣ୍ଡେନେ ଦିନା ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌ନେ ନେନେ ନିୟମ୍‌ ବିରଦ୍ ଣ୍ଡୁ କି ?” ");
INSERT INTO gaq_vpl VALUES ("MT12_11","070_12_11","MAT","12","11","11","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପୁଣ୍ଡେନେ ଦିନା ଜଦି ପେନେ ବିତ୍ରେବାନ୍ ଜାନେ ମେଣ୍ଡାଡିଗ୍ ମୁଇଙ୍ଗ୍ କୁଇଁସାଲ୍‌ନ୍ନିଆ ଲଃୱେଏ ପେ ଆମେକେ ମେଁନେ ପେରାତଡ଼ିଆ ? ");
INSERT INTO gaq_vpl VALUES ("MT12_12","070_12_12","MAT","12","12","12","ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ନେନେ ମୁଲ୍ୟ ମୁଇଙ୍ଗ୍ ମେଣ୍ଡାନେ ମୁଲ୍ୟ ଜାବର୍‌ ଜବର୍ । ତେଲାଡିଗ୍‍ ପୁଣ୍ଡେନେ ଦିନା ଡିଗ୍ ବିନ୍‌ଣ୍ଡ୍ରେକେ ସାଇଜ ଡିଙ୍ଗ୍‌ନ୍‌ସା ନେନେ ସାସ୍ତର୍‌ନେ ନିଅମ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_13","070_12_13","MAT","12","13","13","ଏନ୍‌ ବାସଙ୍ଗ୍‌ଚେ ଆତେନ୍‌ ନ୍ତି ଆତୁକ୍‍କ୍ନେ ରେମୁଆଁକେ ବାସଙ୍ଗ୍‌କେ “ନ୍ତି ସିଦା ଆଡିଙ୍ଗ୍ ।” ଆତେନ୍‌ ରେମୁଆଁ ନ୍ତି ସିଦା ଆଃଡିଙ୍ଗ୍‌କ୍ନେ ଦାପ୍ରେ ଆତେନ୍‌ ନ୍ତି ବାରି ମୁଇଙ୍ଗ୍ ନ୍ତି ସୁଗୁଆ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_14","070_12_14","MAT","12","14","14","ମାତର୍‌ ଫାରୁଶୀଇଂ ଆତେନ୍‌ ଜାଗା ବାନ୍ ଲାଗ୍‌ଡଚେ ଜିସୁନେ ବିରଦ୍‌ରେ ବାଗୁଏ ନ୍‌ସା ଜଜନା ତୁର୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_15","070_12_15","MAT","12","15","15","ମେଁ ବିରଦ୍‌ରେ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ଜଜନା ଅଁଚେ ଜିସୁ ଆତେନ୍‌ ଜାଗା ଆନ୍‌ତାର୍‌ଚେ ବିନ୍ ଏରିଆ ଲାଗ୍‌ଡକେ ମାତର୍‌ ଗୁଲୁଏ ରେମୁଆଁ ପ୍ଲା ୱେଆର୍‌ଗେ । ଆରି ଜିସୁ ରଗି‍ଇଂକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_16","070_12_16","MAT","12","16","16","ମାତର୍‌ ମେଁନେ ବିସୟ୍‌ରେ ବିନ୍‌ଣ୍ଡ୍ରେକେ ମେଃଡିଗ୍ ମାବାସଙ୍ଗ୍‍ ନ୍‌ସା ଆମେଇଂକେ ଆଦେସ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_17","070_12_17","MAT","12","17","17","ଏନ୍‌‍ସା ବାବବାଦି ଯିଶାଇୟବାନ୍‍ ଇସ୍‌ପର୍ ଆଣ୍ଡିନେ ସାମୁଆଁ ଆଅଁବଗେ ଆତେନ୍‌ ପୁରନ୍ ଆଡିଙ୍ଗ୍‍ନେସା ମେଁ ଆକେନ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_18","070_12_18","MAT","12","18","18","“ଏ ନେଙ୍ଗ୍‌ନେ ସ୍ରିମ୍ୱକ୍ନେ ଚାକର୍‌, ଆମେକେ ନେଙ୍ଗ୍ ଉଡ଼ି ବଲ୍‍ବା ଣ୍ଡିଙ୍ଗ୍‍କେ, ମେଁନେ ଆଡ଼ାତ୍ରା ନେଙ୍ଗ୍ ଜାବର୍‌ ସାର୍ଦା । ନେଙ୍ଗ୍ ଆତ୍ମା ମେଁ ଆଡ଼ାତ୍ରା ଜାର୍‌ଏ; ସାପା ଦେସ୍‌ନେ ବିଜାତି ରେମୁଆଁଇଂ ଆଡ଼ାତ୍ରା ମେଁ ନେଙ୍ଗ୍‌ନେ ନ୍ନିଆ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_19","070_12_19","MAT","12","19","19","ମେଁ ୱିଙ୍ଗ୍‌ଆ ରିଙ୍ଗ୍‌ଆ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ, ଗାଲି ମଜେ ତୁଆଁଚେ କିରଚେ ଆବାସଙ୍ଗ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_20","070_12_20","MAT","12","20","20","ଦରିଦ୍ର ଆରି ଦୁର୍‍ବଲ୍‍ ରେମୁଆଁଇଂନେ ନ୍ୟାୟ୍ ବିଚାର୍ ମାଡିଙ୍ଗ୍‍ ଜାକ, ମେଁ କାମ୍‌ବାନ୍‍ ବିନେ ଆରାଃଡିଙ୍ଗ୍ ଣ୍ଡୁ, ଆରି କୁପିସନେ ସାଲ୍‌ତା ଆରାଃଲିଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_21","070_12_21","MAT","12","21","21","ମେଁ ଆଡ଼ାତ୍ରା ସାପା ଦେସ୍‌ନେ ବିଜାତି ରେମୁଆଁଇଂ ଆସା ବଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_22","070_12_22","MAT","12","22","22","ବାରି ମୁଇଂଦିନା ରେମୁଆଁ ମୁଇଙ୍ଗ୍ କାନା ଆରି ଗୁଲାକେ ମେଁ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍ଆର୍‌କେ । ଆମେକେ ଗଲିଆ ସା ଲେଲା ବାସଙ୍ଗ୍‌ ୟାଆଡିଙ୍ଗ୍‌ଗେ ଣ୍ଡୁ । ଜିସୁ ଆମେକେ ନିମାଣ୍ଡା ଆଡିଙ୍କେ । ମେଁ କେୟାକେ ବାରି ସାମୁଆଁ ବାସଙ୍ଗ୍‍ ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_23","070_12_23","MAT","12","23","23","ଜିସୁନେ ଏନ୍‌ କାମ୍ କେଚେ ସର୍‌ତେ ରେମୁଆଁଇଂ ବକୁଆ ଡିଙ୍ଗ୍‍ଚେ ପ୍ରସ୍‌ନ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଏନ୍‌ ମେଃନେ ଆତେନ୍‌ ଦାଉଦ୍‍ କୁଲ୍‌ନେ ରେମୁଆଁ ଣ୍ଡୁ କି ?” ");
INSERT INTO gaq_vpl VALUES ("MT12_24","070_12_24","MAT","12","24","24","ଫାରୁଶୀଇଂ ଏନ୍‌ ଅଁଚେ ବାସଙ୍ଗ୍‌କେ “ମେଁ ମ୍ନାଗଲିଆନେ ବାଆଲ୍‌ଜିବୂଲଇଂନେ ଇଃସାଙ୍ଗ୍‌ନେ ବପୁରେ ଗଲିଆକେ ଆଃଆନ୍ତାର୍‌ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_25","070_12_25","MAT","12","25","25","ମାତର୍‌ ମେଁ ମେଁନେ ଚିନ୍ତା ମ୍ୟାଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ମୁଇଙ୍ଗ୍ ଦେସ୍‌ନେ ରେମୁଆଁ ବିନ୍ ବିନ୍ ବାଗ୍ ଡିଙ୍ଗ୍‌ଚେ ମେଇଂମେଇଂ ବିତ୍ରେ ରିଙ୍ଗ୍‌ଆଲା ଆତେନ୍‌ ଆଙ୍କ୍ ଆନ୍ତ୍ ଡିଙ୍ଗ୍‌ୱେଏ; ବାରି ମେଃଡିଗ୍ ଇନି ଣ୍ଡୁଲା ଡୁଆ ବିତ୍ରେ ବିନ୍ ବିନ୍ ଦଲ୍‍ ତିଆର୍ ଡିଙ୍ଗ୍‌ଚେ ୱିଙ୍ଗ୍‌ଆ ରିଙ୍ଗ୍‌ଆ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ମେଁଇଂ ଜିଆଃ ଚିନ୍‍ ଚତର୍‍ ଡିଙ୍ଗ୍‌ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_26","070_12_26","MAT","12","26","26","ଆରି ସ‍ଏତାନ୍ ଜଦି ସ‍ଏତାନ୍‌କେ ଆଃଆନ୍ତାର୍ ତେଲା ମେଁ ବାଗ୍ ବାଗ୍ ଡିଙ୍ଗ୍‌ଚେ ନିଜେନେ ବିରଦ୍‌ରେ ତଃଡ଼ିଆଏ; ତେଲା ମେଁନେ ରାଇଜ୍ ଡିରକମ୍ ଚୁପ୍‍ ଡିଙ୍ଗ୍‌ଚେ ଲେଃଏ ? ");
INSERT INTO gaq_vpl VALUES ("MT12_27","070_12_27","MAT","12","27","27","ନେଙ୍ଗ୍ ଜଦି ବାଆଲ୍‌ଜିବୂଲନେ ବପୁରେ ସେଆଁରେ ଆଃଆନ୍ତାର୍ ଣ୍ଡିଂକେ ତେଲା ପେନେ ଉଙ୍ଗ୍‌ଡେଇଂ ଜାନେ ବପୁରେ ଆମେଇଂକେ ଆଃଆନ୍ତାର୍ ଡିଙ୍ଗ୍‌କେ । ତେସା ମେଇଂଆ ପେନେ ବିଚାର୍ କର୍ତା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_28","070_12_28","MAT","12","28","28","ସେଆଁରେ ଆଃଆନ୍ତାର୍‌ନେ ବପୁ ନେଙ୍ଗ୍ ବାଆଲ୍‍ଜିବୁଲ୍‍ବାନ୍ ନ୍ନାବାକେ ଣ୍ଡୁ ଇସ୍‌ପର୍‌ନେ ଆତ୍ମା ବାନ୍ ଆତେନ୍‌ ନେଙ୍ଗ୍ ବା ନ୍ଲେ । ଏନ୍‌‍ସା ବାରି ମୁଇଙ୍ଗ୍ ବିସୟ୍ ପାରାମାନ୍‍ ଡିଙ୍ଗ୍‍ଡିଂକେ କିତଂ ରାଇଜ୍ ପେ ଡାଗ୍ରା ପାଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_29","070_12_29","MAT","12","29","29","ମୁଇଙ୍ଗ୍ ବପୁ ରେମୁଆଁକେ ସେନୁଗ୍‍ ଆଗାଗ୍‍ଲା ଜାଣ୍ଡେ ମେଁନେ ଡୁଆ ଜବର୍‌ଜସ୍ତି ଗାଚେ ମେଁନେ ଦନ୍‌ସମ୍ପତି ଡୁଂଡ ଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_30","070_12_30","MAT","12","30","30","ଜା ନେଙ୍ଗ୍ ପାକା ଣ୍ଡୁ ମେଁ ସତ୍‍ରେ ନେଙ୍ଗ୍ ବିରଦ୍‌ରେ ଲେଃକେ । ଜା ନେଙ୍ଗ୍‍ ଏତେ କୁଡ଼େଚେ ଆରାଃସିଂ ମେଁ ସତ୍ ଜଗ୍‌ତ୍ଲାଗ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_31","070_12_31","MAT","12","31","31","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ରେମୁଆଁ ଜା ମେଃଡିଗ୍ ପାପ୍ ଡିଙ୍ଗ୍‌ଲେ ମିଚ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଲେ ଆତେନ୍‌‍ସା ଆମେକେ କେମା ଲେଃକେ । ମାତର୍‌ ଜା ଜଦି ପବିତ୍ର ଆତ୍ମାନେ ବିରଦ୍‌ରେ ମେଃଡିଗ୍ ବାସଙ୍ଗ୍ଏ ମେଁନେ କେମା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_32","070_12_32","MAT","12","32","32","ଜାଣ୍ଡେକି ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ବିରଦ୍‌ରେ ମେଃଡିଗ୍ ବାସଙ୍ଗ୍‌ଲା ମେଁ କେମା ବା ୟାଏ । ମାତର୍‌ ଜାଡିଗ୍‍ ପବିତ୍ର ଆତ୍ମାନେ ବିରଦ୍‌ରେ ବାସଙ୍ଗ୍ଏ ମେଁ ଏକେ ଣ୍ଡୁଲା ବବିସତ୍ କେଲା ଡିଗ୍ ଅଃନା କେମା ଆବା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_33","070_12_33","MAT","12","33","33","ନିମାଣ୍ଡା ଚୁ ଚୁନ୍‍ସା ସ୍ଲାଃକେ ଆମ୍ନାନେ ଦର୍‌କାର୍ । ବଃଉଂକ୍ନେ ସ୍ଲା ନିମାଣ୍ଡା ଚୁଚୁ ସାଃଏ । ସ୍ଲା ଡିରକମ୍ ମେଁ ଚୁକ୍ନେ କେଚେ ମ୍ୟା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_34","070_12_34","MAT","12","34","34","ଏ ବୁବଃ ସୁଗୁଆନେ କାଳ ରେମୁଆଁ ! ନିଜେ କାଳ ଡିଙ୍ଗ୍‌ଚେ ପେ ମେଃନେ ନିମାଣ୍ଡା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ପେୟାଏ ? ମନ୍‌ନ୍ନିଆ ଚିନ୍ତା ତୁମୁଆଃ ବିଚେ ପ୍ରକାସ୍‍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_35","070_12_35","MAT","12","35","35","ମୁଇଙ୍ଗ୍ ନିମାଣ୍ଡା ରେମୁଆଁ ମେଁନେ ତ୍ମିକ୍ନେ ଗାଗ୍‌ଡ଼େ ବାନ୍ ତ୍ମିନେ ଜିନିସ୍‍ଇଂ ତାର୍‌ଏ ବାରି ଦଦ୍ୟା ରେମୁଆଁ ଦଦ୍ୟା ଗାଗ୍‌ଡ଼େ ବାନ୍ ଦଦ୍ୟା ଜିନିସ୍‍ ତାର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_36","070_12_36","MAT","12","36","36","ମାତର୍‌ ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ରେମୁଆଁଇଂ ଜା ଡିଗ୍ ମୁଲ୍ୟଣ୍ଡୁକ୍ନେ ସାମୁଆଁ ବାସଙ୍ଗ୍ଏ ବିଚାର୍ ଦିନ୍ କେଲା ମେଁଇଂ ଆତ୍‌ଅରିଆ ଉତର୍ ବିଏ; ");
INSERT INTO gaq_vpl VALUES ("MT12_37","070_12_37","MAT","12","37","37","“ନାନେ ସାମୁଆଁବାନ୍‍ ନାନେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଚେ ନିର୍ଦସ୍ ଣ୍ଡୁଲା ଦସ୍‍ ସାଃଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_38","070_12_38","MAT","12","38","38","ମେସୁଆ ଉଡ଼ିରୁଆ ଫାରୁଶୀ ବାରି ଦରମ୍ ଗୁରୁ ଜିସୁକେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଗୁରୁ ନାନେ ମୁଇଙ୍ଗ୍ ଇରିଆତୁଗ୍‌କ୍ନେ କାମ୍ କେନ୍‍ସା ଚାଏଁ ନେଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_39","070_12_39","MAT","12","39","39","ମାତର୍‌ ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ “ଏନ୍‌ ଜୁଗ୍‍ନେ ରେମୁଆଁଇଂ ଉଡ଼ି ଦୁସ୍ଟ ବାରି ଇସ୍‌ପର୍‌କେ ସତ୍ ମାନେଃ ଆମ୍ୟାକେ । ପେ ଆନେଙ୍ଗ୍‌କେ ମୁଇଙ୍ଗ୍ କାବା ଡିଙ୍ଗ୍‌କ୍ନେ କାମ୍ ଆସୁଏ ନ୍‌ସା ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ? ମାତର୍‌ ବାବବାଦି ଜୁନସ୍‍ନେ ଜିବନ୍‍ନ୍ନିଆ ଗଟେ ଲେଃକ୍ନେ କାବା ସୁଗୁଆ କାମ୍ ଆପେକେ ଆକେ ମ୍ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_40","070_12_40","MAT","12","40","40","ଜୁନସ୍‍ ଡିରକମ୍ ଆଡ଼ନେ ସୁଲୁଏଃ ବିତ୍ରେ ଜିର୍ସି ଦିନ୍ ବାରି ଜିର୍ସି ମିଡିଗ୍ ଲେଃଗେ ଦେତ୍ ରକମ୍ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଡିଗ୍ ଜିର୍ସି ଦିନ୍ ବାରି ଜିର୍ସି ମିଡିଗ୍ ତୁବନ୍ନିଆ ଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_41","070_12_41","MAT","12","41","41","ମୁଡ଼ି ଦିନା ଇସପର୍‍ ନିନୀବିନେ ରେମୁଆଁଇଂକେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ତୁଆଁ ଆର୍‌ଏ, ମାତର୍‌ ଯୁନସ୍‍ ବାସଙ୍ଗ୍‌କ୍ନେ ଅଁଚେ ମେଇଂ ପାପ୍ ଗାଲିବାନ୍ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ଆର୍‌କେ । ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଯୁନସ୍‍ନେ ବାନ୍ ମ୍ନାନେ ରେମୁଆଁ ଆକ୍‌ଅରିଆ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_42","070_12_42","MAT","12","42","42","ବିଚାର୍ ଦିନ୍‍କେଲା ଶିବାନେ ରାନି ପେନେ ଦସ୍‍ ଆକେନ୍‍ସା ତୁଆଁ ଆର୍‌ଏ ମେଁନ୍‌ସା ଡାଗ୍ଲା ଶଲୋମନ୍ ବୁଦି ଗ୍ୟାନ୍‍ନେ ସାମୁଆଁ ଅଁନ୍‌ସା ସ୍ଲ ଦେସ୍‌ବାନ୍ ପାଙ୍ଗ୍‌ଲେଗେ; ମାତର୍‌ ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଶଲୋମନ୍ ବାନ୍ ବପୁ ରେମୁଆଁ ଆକ୍ ଅରିଆ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_43","070_12_43","MAT","12","43","43","ଦଦ୍ୟା ଆତ୍ମା ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ବାନ୍ ତାର୍ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଣ୍ଡିଆ ଆଲେଃକ୍ନେ ଜାଗା ସାପା ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ପୁଣ୍ଡେନ୍‌ସା ଜାଗା ତୁର୍‌ଏ ବାରି ଆତେନ୍‌ ଆଅବା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_44","070_12_44","MAT","12","44","44","ଆତ୍‌ବା ମେଁ ବାସଙ୍ଗ୍ଏ “ନେଙ୍ଗ୍ ଆଣ୍ଡିନେ ଡୁଆ ବାନ୍ ପାଙ୍ଗ୍ ନ୍ଲେଗେ ନେଙ୍ଗ୍ ଆତେନ୍‌ ଡୁଆନ୍ନିଆ ଆଣ୍ଡେ ଙ୍ଗୁଇଗ୍‍ଏ; ବାରି ମେଁ ପାଙ୍ଗ୍‌ଚେ କାଲି ସଜେବକ୍ନେ ସୁନ୍ଦର୍‍ କେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT12_45","070_12_45","MAT","12","45","45","ମେଁ ବାନ୍ ବାରି ଦୁଷ୍ଟ ଡିଙ୍ଗ୍‌କ୍ନେ ଗୁକ୍ଲିଗ୍‍ ପ୍ରେତଆତ୍ମାକେ ୱାଡୁଂ ପାଙ୍ଗ୍‌ଏ ବାରି ମେଇଂ ସାପାରେ ଆତେନ୍‌ ଡୁଆନ୍ନିଆ ବାସା ଆର୍‌ଏ ଆକ୍‍ମେନ୍‍ସା ଆତେନ୍‌ ସେଆଁରେ ସାଲେଃକ୍ନେ ରେମୁଆଁଇଂନେ ସାରାସାରି ଡଣ୍ଡ୍‍ ବାଦୁଲ୍ ଜବର୍ ଅବସ୍ତା ବାଆର୍‌ଏ ଏନ୍‌ ଜୁଗ୍‍ନେ ରେମୁଆଁଇଂ ଦେକ୍ ରକମ୍ ଅବସ୍ତା ଡଣ୍ଡ୍ ବାଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_46","070_12_46","MAT","12","46","46","ଜିସୁ ରେମୁଆଁଇଂ ଏତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌କ୍ନେ ବେଲା ମେଁନେ ଡିଆଣ୍ଡେ ବାରି ବୟାଁଣ୍ଡେ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ପାଙ୍ଗ୍‌ଚେ ଆମେକେ ମେଃଡିଗ୍ ବାସଙ୍ଗ୍‍ନେସା ବାଏରେ ଉର୍‍ଚେ ଆମେ ୱାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT12_47","070_12_47","MAT","12","47","47","ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ “କେଲା ପିୟାଙ୍ଗ୍‍ ବାରି ପେବୟାଁଇଂ ନାଁ ନ୍‌ସା ବାଏରେ ଉର୍ଲେ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT12_48","070_12_48","MAT","12","48","48","ଜିସୁ ଉତର୍ ବିକେ “ଜାଣ୍ଡେ ନେଙ୍ଗ୍‌ନେ ନିୟାଁଙ୍ଗ୍‍ ବାରି ଜାଣ୍ଡେଇଂ ନେଙ୍ଗ୍‌ନେ ବୟାଁ ?” ");
INSERT INTO gaq_vpl VALUES ("MT12_49","070_12_49","MAT","12","49","49","ସିସ୍‍ଇଂ ପାକା ନ୍ତି ଆସୁଏଚେ ବାସଙ୍ଗ୍‌କେ “ଆକ୍‌ମେଇଂ ଡିଙ୍ଗ୍ ଡିଂକେ ନିୟାଁଙ୍ଗ୍‍ ବାରି ନେବୟାଁ । ");
INSERT INTO gaq_vpl VALUES ("MT12_50","070_12_50","MAT","12","50","50","ଜା ନେଙ୍ଗ୍‌ନେ କିତଂନ୍ନିଆ ଲେଃକ୍ନେ ଆବାନେ ଇକ୍‌ଚା କାମ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ନେଙ୍ଗ୍‌ନେ ବୟାଁ ନେଙ୍ଗ୍‌ନେ ତନା ଆରି ନେଙ୍ଗ୍‌ନେ ଇୟାଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_1","070_13_1","MAT","13","1","1","ଆତେନ୍‌ ଦିନା ଜିସୁ ଡୁଆ ବାନ୍ ତାର୍‌ଚେ କେଣ୍ଡିଆନ୍ନିଆ ୱେଗେ । ଆତ୍‍ ଅରିଆ ମେଁ ସିକ୍ୟା ବିଃନ୍‍ସା କକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_2","070_13_2","MAT","13","2","2","ମେଁନେ ଅଁପାକା ଗୁଲୁଏ ରେମୁଆଁ ରିସିଙ୍ଗ୍ ଆର୍‌କେ ଜେ ମେଁ ମୁଇଂ ତରାନ୍ନିଆ ୱେଚେ କକେ । ରେମୁଆଁଇଂ କେଣ୍ଡିଆ ଆଃଡ଼ା ତୁଆଁଚେ ମେଁନେ ସାମୁଆଁ ଅଁକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_3","070_13_3","MAT","13","3","3","ମେଁ ଉସ୍ରା ରକମ୍ ଆମେଇଂକେ ଗୁଲୁଏ ସାମୁଆଁ ସିକ୍ୟା ବିକେ ମେଁ ବାସଙ୍ଗ୍‌କେ । “ମେଃସୁଆ ମୁଇଂ ରେମୁଆଁ ବିଗ୍‌ଜା ତାର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_4","070_13_4","MAT","13","4","4","ମେଁ ଲିଜନ୍ନିଆ ଚୁମୁଜା ବିଗ୍‍ନେ ବେଲା ଉଡ଼ି କିଆ ଗାଲି ଲଃଲା ପ୍ଲିଗ୍‍ଇଂ ପାଙ୍ଗ୍‌ଚେ ଆତେନ୍‌ ସାପା ଚଙ୍ଗ୍‌ବିଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_5","070_13_5","MAT","13","5","5","ଆରି ଉଡ଼ିକ୍ଲିଗ୍ ମଞ୍ଜି ଇକୁଡ଼ା ତୁବଃ ଲେଃନେ କିଡ଼ିଲ ତୁବଃନ୍ନିଆ ଲଃକେ । ଆତେନ୍‌ ତୁବଃ କୁବାଂ ଆଲେଃଲା ମୁଞ୍ଜି ଜିଆ ଜିଆ ପଃଡ଼୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_6","070_13_6","MAT","13","6","6","ମାତର୍‌ ମେଁନେ ଚେର୍ ଆଲେଃଗେସା ନାଃସେଙ୍ଗ୍‍ଲା ନ୍‌ସୁଆର୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_7","070_13_7","MAT","13","7","7","ଆରି ଉଡ଼ିକ୍ଲିଗ୍‌ ଗ୍ରେଃ ସ୍ଲାଃଇଂନେ ମଜେ ଲଃକେ ବାରି, ଗ୍ରେଃ ସ୍ଲାଃଇଂ ତଡ଼ିଆଚେ ମ୍ନା ଡିଂଚେ ଆତେନ୍‌‌ଇଂକେ ଚାପେ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_8","070_13_8","MAT","13","8","8","ମାତର୍‌ ବାରି ଉଡ଼ି ଚୁମୁଜା ନିମାଣ୍ଡା ଲିଜନ୍ନିଆ ଲଃଚେ ସ୍ଲା ଡିଙ୍ଗ୍‌ଚେ ଚୁ ଗ୍ଲିକେ । ଉଡ଼ି ଗ୍ୱାକୁଡ଼ି ଗୁନ୍ ଉଡ଼ି ଞ୍ଜିକୁଡ଼ି ଗୁନ୍ ଆରି ଉଡ଼ି ତିରିସ୍‌ ଗୁନ୍‌ ଚୁ ଗ୍ଲିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_9","070_13_9","MAT","13","9","9","ଜାନେ ନ୍ଲୁଗ୍‌ ଲେଃକେ, ମେଁ ଅଁଲେଃ । ");
INSERT INTO gaq_vpl VALUES ("MT13_10","070_13_10","MAT","13","10","10","ଆକେନ୍ ଇଡ଼ିଂ ସିସ୍ଇଂ ମେଁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାକୁଆର୍‌କେ, ନାଁ ମେଃନ୍‌ସା ଆମେଇଂକେ ଉଃସ୍ରା ବାନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନାଡିଂକେ ? ");
INSERT INTO gaq_vpl VALUES ("MT13_11","070_13_11","MAT","13","11","11","ଜିସୁ ଉତର୍ ବିକେ “କିତଂ ରାଜିନେ ଗୁନ୍‌ ବୁଜେନ୍‍ସା ପେ ବୁଦି ବା ପେଲେକେ ମେଁଇଂ ଆବା ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT13_12","070_13_12","MAT","13","12","12","ଜାନେ ଲେଃକେ ଆମେକେ ଅଦିକ୍‍ ବିଏ ଅଃତେନ୍‌ରେ ସାର୍ଦା ଲାବ୍‍ ଡିଙ୍ଗ୍‌ଏ । ମାତର୍‌ ଜାନେ ଣ୍ଡୁ ମେଁନେ ଜା ସାପା ଲେଃକେ ଆତେନ୍‌ ସାପା ଡିଗ୍ ଜଗ୍‍ଚେ ଡୁଂଡଏ । ");
INSERT INTO gaq_vpl VALUES ("MT13_13","070_13_13","MAT","13","13","13","ଆମେଇଂକେ ନେଙ୍ଗ୍ ଉସ୍ରା ରକମ୍ ସିକ୍ୟା ବିଣ୍ଡିଙ୍ଗ୍‍ । ମାତର୍‌ ମେଇଂ କିକେ ଲେଃଆର୍‌ଏ ମାତର୍‌ ମେଃଡିଗ୍ କିକେ ଆୟା ଆର୍‌ଏ ଣ୍ଡୁ; ୱେ ଲେଃଆର୍‌ଏ ମାତର୍‌ ବୁଜେ ଆୟା ଆର୍‌ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_14","070_13_14","MAT","13","14","14","ବାବବାଦି ଯିଶାଇୟନେ ବବିସତ୍ ସାମୁଆଁ ମେଇଂ ନ୍‌ସା ଦର୍‌କାର୍ । ଏନ୍‌ ରେମୁଆଁଇଂ ଅଁ ଅଁଚେ ମେଃଡିଗ୍ ଆଦ୍ରିଗ୍ ଆର୍‌ଏ ଣ୍ଡୁ । କେମ୍ୟା ଆର୍‌କେ ମାତର୍‌ କିକେ ଆୟାଆର୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT13_15","070_13_15","MAT","13","15","15","ଡାଗ୍ଲା ମେଇଂନେ ଗଣ୍ଡା ବୁଦି । ମେଁଇଙ୍ଗ୍‌ନେ ନ୍ଲୁଗ୍‍ ତାଙ୍ଗ୍‍ଡା ବିବଆର୍‌କେ ଆରି ମୁଆଃ ଲେମୁଆଃଚେ ଲେଃଆର୍‌କେ । ଦେତ୍ ଡିଙ୍ଗ୍ ଆଲେଃଲା ମେଇଂ ମୁଆଃ ଏତେ କିକେ ପାୟାଆର୍‌ ଆରି ମେଇଂ ନେଙ୍ଗ୍‍ତୁଗ୍‍ ଆଣ୍ଡେ ପାପାଙ୍ଗ୍‌ଆର୍ ଆରି ଆମେଇଂକେ ନେଙ୍ଗ୍ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ମ୍ପାବି । ଏନ୍‌ ସାମୁଆଁ ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‍ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_16","070_13_16","MAT","13","16","16","“ପେ ସାପାରେ ଉଡ଼ି ନିମାଣ୍ଡା ! ପେ ମୁଆଃ ଏତେ କିକେ ୟାପେଡିଙ୍ଗ୍‌କେ ଆରି ନ୍ଲୁଗ୍‍ ଏତେ ଅଁ ୟାପେଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_17","070_13_17","MAT","13","17","17","ଏନ୍‌ ସାମୁଆଁ ସତ୍ ବାବ୍‌ରେ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ ଗୁଲୁଏ ବାବବାଦି ବାରି ଇସ୍‌ପର୍ ରକମ୍‌ ଜିବନ୍‌ କାଟେନେ ରେମୁଆଁ, ପେ ମେଃନେ କିକେପେଡିଙ୍ଗ୍‌କେ; ଆତେନ୍‌ କେନ୍‍ସା ବାରି ମେଃନେ ଅଁପେଡିଙ୍ଗ୍‍କେ; ଆତେନ୍‌ ଅଁନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍ଗେ ମାତର୍‌ ଅଁ ଆୟା ଆର୍‌କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_18","070_13_18","MAT","13","18","18","“ତେଲା ଅଁପା ଚୁମୁଜା ବିଗ୍‍ ଡିଙ୍ଗ୍‌କ୍ନେ ଉସ୍ରା ଡାଗ୍ଲା ମେଁନେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ । ବୁଜେନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT13_19","070_13_19","MAT","13","19","19","ଜାଣ୍ଡେଇଂ କିତଂ ରାଜିନେ ବ୍ନାଲିର୍ ଅଁଏ, ଆତେନ୍‌ ଆବୁଜେ, ମେଁ ଗାଲି ଆଃଡ଼ା ଲଲେଃକ୍ନେ ଚୁମୁଜା ରକମ୍ । ସ‍ଏତାନ୍‌ ପାଙ୍ଗ୍‌ଚେ ମେଁ ରୁଦୟ୍‍ବାନ୍‍ ଆତେନ୍‌ ସାଚେ ଡୁଂଡଏ । ଗାଲିଆଡ଼ା ଲଲେଃକ୍ନେ ଚୁମୁଜାନେ ଅର୍‌ତ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଏନ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("MT13_20","070_13_20","MAT","13","20","20","ଜାଣ୍ଡେଇଂ ବ୍ନାଇର୍‌କେ ଅଁକ୍ନେ ଦାପ୍‍ରେ ରାଜି ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଆତେନ୍‌ କିଡ଼ିଲ ଜାଗାନ୍ନିଆ ଲଃଲେକ୍ନେ ଚୁମୁଜା ରକମ୍ । ");
INSERT INTO gaq_vpl VALUES ("MT13_21","070_13_21","MAT","13","21","21","ମେଁଇଂନେ ମନ୍ ବିତ୍ରେ ସ୍ରି ୱେଆଲେଲା ମେଇଂ ଆମେକେ ଜାବର୍ ପର୍‍ ସାଃଆଲେଃଆର୍‌ ଣ୍ଡୁ । ଏନ୍‌ ବ୍ନାଇର୍‍ନ୍‍ସା ଉଡ଼ି ବେଲା କସ୍ଟ ବାରି ଦୁକ୍ ପାଙ୍ଗ୍‌ଲା ମେଇଂ ଟାପ୍‌ନା ଆମେକେ ଆନ୍ତାର୍‍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT13_22","070_13_22","MAT","13","22","22","ଜାଣ୍ଡେ ବ୍ନାଲିର୍ ଅଁଏ, ମାତର୍‌ ସଂସାର୍‌ନେ ଚିନ୍ତା ଆରି ଦନ୍‍ନେ ଲବ୍ ଆମେକେ ଚାପେ ବିଏ । ମେଁ ଆରି ଆଚୁ ଣ୍ଡୁ । ଆତେନ୍‌ ଗ୍ରେଃ ଲାଟାନ୍ନିଆ ଲଲେଃକ୍ନେ ଲିଜ ସୁଗୁଆ । ");
INSERT INTO gaq_vpl VALUES ("MT13_23","070_13_23","MAT","13","23","23","ଜାଣ୍ଡେଇଂ ବ୍ନାଇର୍‌କେ ଅଁଚେ ବୁଜେଏ ମେଇଂ ନିମାନ୍‍ ଲିଜନ୍ନିଆ ଲଃଲେକ୍ନେ ଚୁମୁଜା ରକମ୍ ମେଁଇଙ୍ଗ୍‌ନେ ନିମାଣ୍ଡା ଗ୍ଲିଚେ ପିଲ୍‍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ଜା ବାଏ ମାଲ୍‍କୁଡ଼ି ଗୁନ୍ ଜା ମ୍ବାର୍‌କୁଡ଼ି ଗୁଆ ଗୁନ୍ ବାରି ଜା ମୁଇଂକୁଡ଼ି ଗୁଆ ଗୁନ୍ ପିଲ୍‍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_24","070_13_24","MAT","13","24","24","ଜିସୁ ବାରି ମୁଇଙ୍ଗ୍ ଉଃସ୍ରାନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ “କିତଂ ରାଇଜ୍ ଦେକ୍ ରକମ୍ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ମେଁନେ ଲିଜନ୍ନିଆ ନିମାନ୍‍ ଗ‍ଅମ୍ ଚୁମୁଜା ବିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_25","070_13_25","MAT","13","25","25","ମେସୁଆ ମିଡିଗ୍ ବେଲା ମେଇଂ ଡୁଲେଗ୍‍କ୍ନେ ବେଲା ମୁଇଙ୍ଗ୍ ସତ୍ରୁ ପାଙ୍ଗ୍‌ଚେ ଗହମ୍ ମୁଞ୍ଜି ବିଗ୍‍ ବକ୍ନେ ଲିଜନ୍ନିଆ ଜାବର୍ ଚେମୁଆଁ ମୁଞ୍ଜି ବିଗ୍‌ବିଚେ ଲାଗ୍‌ଡକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_26","070_13_26","MAT","13","26","26","ଉଡ଼ି ବେଲା ସ୍ଲା ମ୍ନାଚେ କେନ୍ଦା ତାର୍‌କେ, ମଜେ ମଜେ ଚେଃମୁଆଁ ତ୍ନାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_27","070_13_27","MAT","13","27","27","ଆତେନ୍‌ ସାକାର୍‌ନେ ଗତିରେଇଂ ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ନାଁ ତ ଲିଜନ୍ନିଆ ନିମାଣ୍ଡା ମୁଞ୍ଜି ଉଂନାବଗେ, ଚେଃମୁଆଁଇଂ ଆଣ୍ଡି ବାନ୍ ପାଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MT13_28","070_13_28","MAT","13","28","28","ଲିଜନେ ସାଉକାର୍ ବାସଙ୍ଗ୍‌କେ, ମୁଇଙ୍ଗ୍ ସତ୍ରୁ ଏନ୍‌ ଡିଙ୍ଗ୍‍ବକେ । ବାରି ଚାକର୍‌ଇଂ ଆମେକେ ସାଲିଆକୁଆର୍‌କେ, ତେଲା ନେ ୱେଚେ ଆତେନ୍‌ଇଂ ଗୁଃ ନେବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MT13_29","070_13_29","MAT","13","29","29","ସାଉକାର୍ ବାସଙ୍ଗ୍‌କେ, ଣ୍ଡୁ ଚେଃମୁଆଁ ତାଗ୍‌ନେ ବେଲା ତ ଗହମ୍‌ ସ୍ଲା ତାର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT13_30","070_13_30","MAT","13","30","30","ବ୍ଲେ ଜାକ ଗ‍ଅମ୍ ବାରି ଚେଃମୁଆଁ ମୁଇଙ୍ଗ୍ ସମାନ୍ ତଡ଼ିଆଲେ । ଆତେନ୍‌ ବେଲା ୱେ ଣ୍ଡ୍ରେକେ ନେବାସଙ୍ଗ୍‍ ମେଇଂ ସେନୁଗ୍‍ ଚେଃମୁଆଁଇଂକେ ୱେଚେ ଗାଗ୍‌ଚେ ଜଗ୍‍ତ୍ଲାଗ୍‍ ବିଏ । ଇଡ଼ିଙ୍ଗ୍ ଗ‍ଅମ୍ ବ୍ଲେଚେ ଆଣ୍ଡ୍ରାଃନ୍ନିଆ ବଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_31","070_13_31","MAT","13","31","31","ଜିସୁ ଆର୍‌ମୁଇଂ ଉଃସ୍ରା ବାସଙ୍ଗ୍‌କେ, “ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ମେଁନେ ଲିଜନ୍ନିଆ ସରିସ ରକମ୍ ଡାଆଁନେ ମୁଞ୍ଜି ମୁଇଙ୍ଗ୍ ଆତି ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_32","070_13_32","MAT","13","32","32","ଆତେନ୍‌ ମୁଞ୍ଜି ସାପା ବାନ୍ ଡାଆଁ ଡିଙ୍ଗ୍‌ଲା ଡିଗ୍ ଆତ୍‍ ବାନ୍ ମୁଡ଼ି ସ୍ଲାଃ ଡିଙ୍ଗେ ଲିଜନ୍ନିଆ ବିନ୍ ସାପା ସ୍ଲାଃ ବାଦୁଲ୍ ଜାବର୍ ତିଆର୍ ବାରି ଗୁଲ୍‍ଟ ଡିଙ୍ଗେ ଆରି ମେଁ କେନ୍ଦା ଅରିଆ ପ୍ଲିଗ୍‍ଇଂ ଉଙ୍ଗ୍‌ଚ୍ୟା ଗାଗ୍ ଆର୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_33","070_13_33","MAT","13","33","33","ବାରି ମୁଇଂତର୍ ଜିସୁ ଉଃସ୍ରା ବାସଙ୍ଗ୍‌କେ “ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୁଏଃ ଇକୁଡ଼ା କମିର ଡୁଂୱିଗ୍‌ଚେ ତେପ୍ୟାଃ ବାସ୍ତା ମଇଦା ଡାଗ୍ରା ଡାଚେ ସୁଃ ବିଃକେ । ଆତେନ୍‌‌ ସାପା ଖମୀର ରକମ୍ ଡିଙ୍ଗ୍‌ୱେଗେ । କିତଂରାଜ୍ୟ ଦେକ୍‌ରକମ୍‌ ମ୍ନାଃ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_34","070_13_34","MAT","13","34","34","ଜିସୁ ଉଃସ୍ରା ରକମ୍ ରେମୁଆଁଇଂକେ ଗିଆନ୍‍ ବିଃଡିଂଗେ । ମାବୁଜେଚେ ମେଁ ମେଃଡିଗ୍ ସିକ୍ୟା ବିଆଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_35","070_13_35","MAT","13","35","35","ଏନ୍‌‍ସା ବାବବାଦି‍ଇଂନେ ଏନ୍‌ ବବିସତ୍ ସାମୁଆଁ ପୁରନ୍ ଡିଙ୍ଗେ । “ନେଙ୍ଗ୍ ଉଃସ୍ରା ରକମ୍ ମେଇଂ ଏତେ ସାମୁଆଁ ନେବାସଙ୍ଗ୍‍ଏ । ମଞ୍ଚ୍‌ପୁର୍‌ ଆରେକ୍ନେ ମୁଲେବାନ୍‍ ଆମ୍ୟାକ୍ନେ ସାପା ସାମୁଆଁ ଦେକ୍ ରକମ୍ ନେଙ୍ଗ୍ ଆମେଇଂକେ ମ୍ବୁଜେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_36","070_13_36","MAT","13","36","36","ରେମୁଆଁ କିର ଲେଃକ୍ନେ ବାନ୍ ତାର୍‌ଚେ ଜିସୁ ଉଡ଼ିବେଲା ଡୁଆ ବିତ୍ରେ ୱେଗେ ମେଁନେ ସିସ୍‍ଇଂ ମେଁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ଚେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଚେଃମୁଆଁନେ ଉଃସ୍ରା ଅର୍‌ତ ଆନେକେ ବୁଜେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_37","070_13_37","MAT","13","37","37","ଜିସୁ ଉତର୍ ବିକେ “ମୁଡ଼ି ରେମୁଆଁ ନିମାନ୍‍ନେ ଚୁମୁଜା ବିକେ ମେଁ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_38","070_13_38","MAT","13","38","38","ଏନ୍‌ ଦର୍‌ତନି ଡିଙ୍ଗ୍‌ଡିଂକେ ଲିଜ । ଜାଣ୍ଡେଇଂ କିତଂ ରାଜିନେ ଆଦିବାସି ମେଇଂ ନିମାନ୍‍ ଚୁମୁଜା ରକମ୍ ଆରି ଚେଃମୁଆଁଇଂ ମେଇଂ ସ‍ଏତାନ୍‌ ଗାଲିପାକା ୱେନେ ରେମୁଆଁଇଂ । ");
INSERT INTO gaq_vpl VALUES ("MT13_39","070_13_39","MAT","13","39","39","ମୁଡ଼ି ସତ୍ରୁ ଚେଃମୁଆଁ ବିଗ୍‌କେ ମେଁ ସ‍ଏତାନ୍ । ବ୍ଲେନେ ବେଲା ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ଜୁଗ୍‍ ଡାନେ ବେଲା । ୱେଃ ଣ୍ଡ୍ରେଇଂ ଡିଂଡିଂକେ କିତଂନେ ଦୁତ୍‍ଇଂ । ");
INSERT INTO gaq_vpl VALUES ("MT13_40","070_13_40","MAT","13","40","40","ଚେଃମୁଆଁ ଆନେଙ୍ଗ୍ ଡିରକମ୍ ମୁଇଂତୁଗ୍ ରାସିଙ୍ଗ୍‌ଚେ ସୁଆନ୍ନିଆ ତ୍ଲାଗ୍‍ଆର୍ଗେ ଜୁଗ୍ ଡାନେ ବେଲା ଦେତ୍ ରକମ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT13_41","070_13_41","MAT","13","41","41","ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ମେଁନେ ରାଇଜ୍ ବାନ୍ ସାପା ଦଦ୍ୟା କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ବାରି ଜାଣ୍ଡେଇଂ ବିନ୍‌ଣ୍ଡ୍ରେକେ ଦଦ୍ୟା କାମ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବାସଙ୍ଗ୍‌ଆର୍‌ଏ ଆମେଇଂକେ ମୁଇଂନ୍ନିଆ ଆଡିଙ୍ଗ୍ ନ୍‌ସା କିତଂ ଦୁତ୍ ବେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT13_42","070_13_42","MAT","13","42","42","ମେଇଂ ଏନ୍‌ ସାପାରେକେ ଡୁଆ ଲେଃକ୍ନେ ସୁଆନ୍ନିଆ ତ୍ଲାଗ୍‍ଏ । ଆତ୍‍ଅରିଆ ଏନ୍‌ ରେମୁଆଁଇଂ ଅଃଆର୍‌ଏ ବାରି କସ୍‍ଟେରେ ଗ୍ନି ଆଃଚିଆଃଲ୍ୟା ଲେଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT13_43","070_13_43","MAT","13","43","43","ଆତେନ୍‌ ବେଲା ଇସ୍‌ପର୍‌ନେ ଦୁତ୍‍ଇଂ କିତଂ ରାଜିନ୍ନିଆ ସ୍ନିସୁଗା ଡୁଆ ଆର୍‌ଏ । ଜାଣ୍ତେନେ ଦ୍ରିଗ୍ ନ୍‌ସା ନ୍‌ଲୁଗ୍ ଲେଃକେ ମେଁ ଦ୍ରିଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT13_44","070_13_44","MAT","13","44","44","ମେସୁଆ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଲିଜନ୍ନିଆ ଗଃ ଗଃଚେ ଆତିଲେଃକ୍ନେ ଦନ୍ ଅବାକେ ମେଁ ଆମେକେ କଣ୍ଡଚେ ସାର୍ଦାରେ ନିଜେନେ ସାପା ସମ୍ପତି ସବିଚେ ଆତେନ୍‌ ଲିଜକେ ବିଆର୍‌କେ । କିତଂ ରାଜିନ୍ନିଆ ଏନ୍‌ ଆତି ବକ୍ନେ ଦନ୍ ସୁଗା । ");
INSERT INTO gaq_vpl VALUES ("MT13_45","070_13_45","MAT","13","45","45","ମୁଇଙ୍ଗ୍ ସାଃପିଗ୍‌ରେ ମାଣ୍ଡାଃ ମାଣ୍ଡାଃ ମୁକ୍ତାକେ ତୁର୍‌ ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_46","070_13_46","MAT","13","46","46","କିତଂ ରାଇଜ୍ ମୁଇଂ ମୁକ୍ତା ରକମ୍‌ । ମୁଇଂ ଜାବର୍ ଦାମ୍‍ନେ ମୁକ୍ତା ଅବାଚେ ମେଁ ମେଁନେ ସାପା ସମ୍ପତି ସ ବିଚେ ଆମେକେ ବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_47","070_13_47","MAT","13","47","47","କିତଂ ରାଜିନେ ମୁଇଙ୍ଗ୍ ଆଃଡ଼ ସାଃମ୍ୟାକ୍ନେ ଜାଲ୍ ସୁଗା କେଣ୍ଡିଆନ୍ନିଆ ଜାଲ୍ ତ୍ଲାଗ୍‌ଚେ ବିନ୍ ରକମ୍ ଜାତିନେ ଆଡ଼ ସାଃମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_48","070_13_48","MAT","13","48","48","ଜାଲ୍‍ନ୍ନିଆ ବର୍ତି ଡିଙ୍ଗ୍‌ଲା ଆଃଡ଼ାପାକା ଗୁଚେ ନିମାଣ୍ଡା ନିମାଣ୍ଡାନେ ସାପା ସ୍ରିଚେ ଚାଟ୍‌ନାନ୍ନିଆ ବମ୍ୟା ବାରି ବିନ୍ ଆଡ଼କେ ଜଗ୍‌ତ୍ଲିଗ୍ ମ୍ୟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_49","070_13_49","MAT","13","49","49","ଜୁଗ୍ ଡାନେ ବେଲା ଦେକ୍ ରକମ୍ ଡିଙ୍ଗ୍‌ଏ । କିତଂ ଦୁତ୍‍ଇଂ ନିମାଣ୍ଡା କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେବାନ୍‌ ପାପି‍ଇଂନେବାନ୍‌ ପାପି‍ଇଂକେ ବିନେ ଆଡିଙ୍ଗ୍ ବିଚେ ଆମେଇଂକେ ଡୁଆଲେଃକ୍ନେ ସୁଆନ୍ନିଆ ଜଗ୍‌ତ୍ଲାଗ୍ ବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MT13_50","070_13_50","MAT","13","50","50","ଆତ୍‍ ଅରିଆ ମେଇଂ ଅଁଚେ ଗ୍ନି ଆଃଚିଆଃଲ୍ୟା ଲେଃଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_51","070_13_51","MAT","13","51","51","ଜିସୁ ସିସ୍‍ଇଂକେ ସାଲିଆକୁକେ “ଏନ୍‌ ସାପା ବିସୟ୍‌ରେ ବୁଜେ ୟାପେଡିଙ୍ଗ୍‍ ?” ମେଇଂ ଉତର୍ ବିକେ । “ଅଃଅଁ ମାପ୍ରୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_52","070_13_52","MAT","13","52","52","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଡିରକମ୍ ମୁଇଙ୍ଗ୍ ଡୁଆ ରେମୁଆଁ ମେଁନେ ଦନ୍‌ସମ୍ପତି ବୁବନେ ଡୁଆବାନ୍‍ ଦର୍‌କାର୍ ଅନୁସାରେ ତ୍ମି ବାରି ବାୱିର୍‌ନେ ଜିନିସ୍‌ ଆଃତାର୍‌ଏ, କିତଂ ରାଇଜ୍ ନ୍‌ସା ତାଲିମ୍‍ ବାଲେଃକ୍ନେ ମୁଇଙ୍ଗ୍ ଦରମ୍ ଗୁରୁ ଜାଣ୍ଡେ କିତଂଇନିନ୍ନିଆ ସିସ୍‍ ଡିଂଲେଃକେ ମେଁ ଦେତ୍‌ରକମ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_53","070_13_53","MAT","13","53","53","ଏନ୍‌ ସାପା ଉଃସ୍ରା ବାସଙ୍ଗ୍‌ ଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆତେନ୍‌ ଜାଗା ଆନ୍ତାର୍‌ଚେ ସିସ୍‌ଇଂ ଏତେ ନିଜର୍‌ ଇନି ନାଜରିତନ୍ନିଆ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT13_54","070_13_54","MAT","13","54","54","ଆତେନ୍‌ ଇନି ପାର୍‍ତନା ଡୁଆନ୍ନିଆ ମେଁନେ ସିକ୍ୟା ଅଁଚେ ରେମୁଆଁଇଂ ଇରିଆତୁଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ବୁଦି ଆଣ୍ଡି ବାନ୍ ବାକେ ?” ଏନ୍‌ ସାପା କାବା ଡିଙ୍ଗ୍‌ନେ କାମ୍ ଆମେକେ ଜା ବପୁ ବିକେ ? ");
INSERT INTO gaq_vpl VALUES ("MT13_55","070_13_55","MAT","13","55","55","ଆକେନ୍ ମେଁନେ ଆତେନ୍‌ ବାଡ଼େନେ ଉଙ୍ଗ୍‌ଡେ ଣ୍ଡୁ ? ମରିୟମ୍ ମେଃନେ ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ଣ୍ଡୁ ? ଜାକୁବ୍‌ ଯୋଷେଫ ଶିମୋନ୍ ବାରି ଜିଉଦା ମେଃନେ ମେଁନେ ବୟାଁଣ୍ଡେ ଣ୍ଡୁକି ? ");
INSERT INTO gaq_vpl VALUES ("MT13_56","070_13_56","MAT","13","56","56","ମେଁନେ ତନାଣ୍ଡେଇଂ ମେଃନି ଆକ୍ ଣ୍ଡୁ ? ତେଲା ଏନ୍‌ ସାପା ବୁଦି ଆରି ବପୁ ମେଁ ଆଣ୍ଡିବାନ୍ ବାକେ ? ");
INSERT INTO gaq_vpl VALUES ("MT13_57","070_13_57","MAT","13","57","57","ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ମେଇଂ ଜିସୁକେ ଉର୍‍ଆର୍କେ । ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ମୁଇଙ୍ଗ୍ ବାବବାଦି ନିଜେନେ କୁଟୁମ୍‍ ଅରିଆ ବାରି ଇନିନ୍ନିଆ ଅପ୍‍ମାନ୍‍ ବାଏ ମାତର୍‌ ବିନ୍ ଇନି ସାପା ପାକା ଅପମାନ୍ ଆବା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT13_58","070_13_58","MAT","13","58","58","ମେଇଂ ଆମେକେ ସତ୍ ଆମାନେଲା ମେଁ ଆତ୍‍ ଅରିଆ ମେଁ କାବା ଡିଙ୍ଗ୍‌ନେ କାମ୍ ବାରି ଜାବର୍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT14_1","070_14_1","MAT","14","1","1","ଆତେନ୍‌ ବେଲା ହେରୋଦ ଗାଲିଲିନେ ସାସନ୍‍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଲେଃଗେ ମେଁ ଜିସୁନେ ବିସୟ୍‌ରେ ଅଁକେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_2","070_14_2","MAT","14","2","2","ମେଁନେ ଚାକର୍‌ଇଂକେ ବାସଙ୍ଗ୍‌କେ “କିମେ ସତେଆ ଡୁବନ୍ ବିଣ୍ଡ୍ରେ ଜହନ୍ ମେଁ ଗୁଏଃଚେ ଆରି ମୁଇଂତର୍ ଜିବନ୍ ଣ୍ଡିଙ୍ଗ୍ ଲେଃକେ ଆତେନ୍‌‍ସା ମେଁ କାବାକାମ୍ ଡିଙ୍ଗ୍‌ୟାଡିଙ୍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_3","070_14_3","MAT","14","3","3","ତେସା ହେରୋଦ ଜହନ୍‍କେ ଗିରପ୍‍ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ଆଦେସ୍‍ ବିବଗେ ବାରି ଆମେକେ ସିକ୍‌ଲି ଏତେ ଗାଗ୍‌ଚେ ବନ୍ଦିସାଲ୍‍ନ୍ନିଆ ଆଃଗାବଗେ । ମେଁନେ ବୟାଁଣ୍ଡେ ପିଲିପ୍‍ନେ କୁନେଣ୍ଡେ ହେରୋଦିଆ ନ୍‌ସା ମେଁ ଏନ୍‌ ଡିଙ୍ଗ୍‍ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_4","070_14_4","MAT","14","4","4","ଡୁବନ୍ ବିଣ୍ଡ୍ରେ ଜହନ୍ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ହେରୋଦିଆକେ ବିହେ ଡିଙ୍ଗ୍‍ନେ ନାନେ ଟିକ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_5","070_14_5","MAT","14","5","5","ଆତେନ୍‌‍ସାଃ ହେରୋଦ ଜହନ୍‍କେ ବାଗୁଏନେସା ଚାଏଁ ଡିଙ୍ଗେ ମାତର୍‌ ଜିହୁଦିନେ ରେମୁଆଁଇଂକେ ମେଁ ବୁଟ ଡିଙ୍ଗେ ମେଁନ୍‌ସା ଡାଗ୍ଲା ମେଇଂ ଜହନ୍‍କେ ମୁଇଙ୍ଗ୍ ବାବବାଦି ଡାଗ୍‌ଚେ ବାବେ ଡିଙ୍ଗ୍ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_6","070_14_6","MAT","14","6","6","ହେରୋଦନେ ଜନମ୍ ଦିନ୍‍କେଲା ହେରୋଦିଆନେ ସେଲା କୁଲାରେ ଡାଗ୍ରା ୱାଡ଼େଙ୍ଗ୍‍ ୱାଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_7","070_14_7","MAT","14","7","7","ମେଁ ଆଡ଼ାତ୍ରା ସାର୍ଦା ଡିଙ୍ଗ୍‌ଚେ ହେରୋଦ ପାର୍‌ମାନ୍ ସାଚେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ପାର୍‌ମାନ୍ ସାଚେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ନାଁ ମେଃନେ ନାସାଲ୍ୟାଏ ନେଙ୍ଗ୍ ଆନାକେ ଆତେନ୍‌ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_8","070_14_8","MAT","14","8","8","ମେଁ ଇୟାଙ୍ଗ୍‌ଡେ ବାସଙ୍ଗ୍‌ନେ ଇସାବ୍‌ରେ ଗଡ଼େଅ ବାସଙ୍ଗ୍‌କେ, “ଡୁବନ୍ ବିଣ୍ଡ୍ରେ ଜହନ୍‍ନେ ବାଆଃ ଆକ୍ ଅରିଆ ଏବେଆ ମୁଇଙ୍ଗ୍ ତାଲିନିଆ ଦାପ୍ରେ ଡୁଂପାଙ୍ଗ୍ ବିଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_9","070_14_9","MAT","14","9","9","ଏନ୍‌ ଅଁଚେ ଇଃସାଙ୍ଗ୍‌ ଦୁକ୍ ଡିଙ୍ଗେ । ମାତର୍‌ ସାପାରେନେ ସେନୁଗ୍‍ ପାର୍‌ମାନ୍ ସାଃବଲା ସେଲାନେ ଇକ୍‌ଚା ପୁରନ୍ ଆଡିଙ୍ଗ୍‍ସା ଆଦେସ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_10","070_14_10","MAT","14","10","10","ତେସା ବନ୍ଦି ଡୁଆନ୍ନିଆ ଜହନ୍‍ନେ ବାଆଃ ସିତଗ୍ ଡୁଂପାଙ୍ଗ୍‌ଆର୍‌କେ ବାରି ");
INSERT INTO gaq_vpl VALUES ("MT14_11","070_14_11","MAT","14","11","11","ତାଲିନ୍ନିଆ ମେଁନେ ବାଆଃକେ ବଚେ ଆତେନ୍‌ ଗଡ଼େଅକେ ବିଆର୍‌ଗେ । ମେଁ ଆତେନ୍‌ ଡୁଂୱେଚେ ମେଁ ଇୟାଙ୍ଗ୍‌ଡେକେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_12","070_14_12","MAT","14","12","12","ଇଡ଼ିଙ୍ଗ୍ ଜହନ୍‍ନେ ସିସ୍‍ଇଂ ପାଙ୍ଗ୍‌ଚେ ଆତି ବିଃନ୍‍ସା ଗୁଏକ୍ନେ ଗାଗ୍‌ଡ଼େକେ ଡୁଙ୍ଗ୍‍ୱେଆର୍ଗେ । ମେଇଂ ୱେଚେ ଜିସୁକେ ଏନ୍‌ ଦୁକ୍ କବର୍ ଆଅଁ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_13","070_14_13","MAT","14","13","13","ଜହନ୍‍ନେ କବର୍ ଅଁକ୍ନେ ଦାପ୍ରେ ଜିସୁ ତରାନ୍ନିଆ ଡେଃଚେ ମୁଇଂ ରେମୁଆଁଗଣ୍ଡ୍ ଣ୍ଡୁନେ ଜାଗାନ୍ନିଆ ୱେଆର୍‌କେ । ଜିସୁ ଆତ୍‍ଅରିଆ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ମ୍ୟାଚେ ଡାଗ୍ରା ଇନି‍ଇଂ ବାନ୍ ଗୁଲୁଏ ରେମୁଆଁ କେଣ୍ତିଆ ଆଃଡ଼ା ଆଃଡ଼ା ଅଲେଙ୍ଗ୍‌ଚେ ଜିସୁନେ ପ୍ଲା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_14","070_14_14","MAT","14","14","14","ଜିସୁ ଅନାବେଲା ତରାବାନ୍‍ ତାର୍‌ଚେଃ ଗୁଲୁଏ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ମେଁ ମେଁଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ମେଁ ଦୟାରେ ତର୍‌ବର୍‌ ଡିଙ୍ଗ୍‌କେ ଗୁଲୁଏ ରଗ୍‌ଣ୍ତ୍ରେକେ ମେଁ ଆତ୍‍ ଅରିଆ ନିମାଣ୍ଡା ଆଡିଙ୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_15","070_14_15","MAT","14","15","15","ଆତେନ୍‌‍ ଦିନା ଲମ୍‍ଡିଗ୍‍ ସିସ୍ଇଂ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍ଆର୍‌କେ “ଜାବର୍‌ ଜିଲମ୍‍ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ, ବାରି ରେମୁଆଁଇଙ୍ଗ୍‌ ଡାଗ୍ରା ଡିରକମ୍‌ ଇନି ଇନି ୱେଚେ ନିଜର୍‌ ନିଜର୍‌ ନ୍‌ସା କାଦି ବିଆର୍‌ ଆର୍‌ଏ ।” ଆତେନ୍‌‌ସା ଆମେଇଂକେ ବେବିଃ । ");
INSERT INTO gaq_vpl VALUES ("MT14_16","070_14_16","MAT","14","16","16","ଜିସୁ ମାତର୍‌‌ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ମେଇଂ ଆକ୍‌ବାନ୍ ୱିଗ୍‌ନେ ଦର୍‌କାର୍ ଣ୍ଡୁ । ପେ ଆମେଇଂକେ ମେଃଡିଗ୍ ଚଙ୍ଗ୍‌ନେ ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_17","070_14_17","MAT","14","17","17","ସିସ୍‍ଇଂ ଉତର୍ ବିକେ “ଆକ୍ଅରିଆ ନେଁ ଡାଗ୍ରା ମାତର୍‌ ମାଲିକ୍ଲିଗ୍ ରୁଟି ମ୍ବାକ୍ଲିଗ୍ ଆଃଡ଼ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_18","070_14_18","MAT","14","18","18","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଆତେନ୍‌ ନେଙ୍ଗ୍ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ ପାଙ୍ଗ୍‌ଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_19","070_14_19","MAT","14","19","19","ରେମୁଆଁଇଂକେ ଚେଃମୁଆଁ ଆଡ଼ାତ୍ରା କନେ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁ ମାଲିକ୍ଲିଗ୍ ରୁଟି ଆରି ମ୍ୱାର୍‌କ୍ଲିଙ୍ଗ୍ ଆଡ଼କେ ଲିଙ୍ଗ୍‌ଚେ କିତଙ୍ଗ୍ ଇନି ତାଣ୍ଡେଚେ ପର୍‌ମେସର୍‌‌କେ ଦନ୍ୟବାଦ୍ ବିକେ । ଆରି ଆତେନ୍‌ ରୁଟିକେ ମେତଗ୍‌ ମେତଗ୍‌ ଆଡିଙ୍ଗ୍‌ଚେ ସିସ୍‍ଇଂକେ ନ୍ତି ଆସା ବିକେ । ସିସ୍‍ଇଂ ଆତେନ୍‌ ସାପା ଡୁଂୱେଚେ ରେମୁଆଁଇଂକେ ବାଟା ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_20","070_14_20","MAT","14","20","20","ସାପାରେ ସୁଲୁଏ ପୁରୁନ୍ ଚଙ୍ଗ୍‌ଚେ ସାନ୍ତି ବାଆର୍‌କେ । ଇଡ଼ିଙ୍ଗ୍ ସିସ୍‍ଇଂ ଲୁଆଁ ଲେଃକ୍ନେ ରୁଟି ବାରି ଆଃଡ଼ଆଣ୍ଡେଙ୍ଗ୍‍ ଜଗ୍‍ଚେ ଗୁକ୍ଲିଗ୍‍ ଆଣ୍ଡ୍ରାନ୍ନିଆ ତାଃନ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_21","070_14_21","MAT","14","21","21","ସେଲାମ୍ବୁଏଃ ବାରି ଙ୍ଗିର୍‍ବଏଇଂକେ ଆନ୍ତାର୍ଚେ ମାଲ୍ ଅଜାର୍ ରେମୁଆଁ ଏନ୍‌ ରୁଟି ଚଙ୍ଗ୍‌ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_22","070_14_22","MAT","14","22","22","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍‍ଇଂକେ ତରାନ୍ନିଆ ଡେଃଚେ କେଣ୍ଡିଆ ଇନୁମେତା ୱେନେସା ବାସଙ୍ଗ୍‌କେ । ମେଁ ନିଜେ ପ୍ଲା ପାକା ଲେଃଚେ ରେମୁଆଁଇଂକେ ବେବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_23","070_14_23","MAT","14","23","23","ମେଁ ମୁଇଂଜାଆ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନ୍‌ସା କଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେକେ । ଲମ୍‍ଡିଗ୍‍ନେ ବେଲା ଜିସୁ ଆତ୍‍ ଅରିଆ ମୁଇଂଜାଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_24","070_14_24","MAT","14","24","24","। ଆତେନ୍‌ ବେଲା ତରା କେଣ୍ଡିଆ ଆଃଡ଼ାଃବାନ୍ ଗୁଲୁଏ ସ୍ଲ ୱେଲେଗେ ବାରି ଜାବର୍ ୱେଡ଼ିଆ ଡିଙ୍ଗ୍‍ଲେଲା ଆଲ୍‍କା ବଗ୍‍ଚେ ଆଙ୍କ୍ ଆନ୍ତ୍‍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_25","070_14_25","MAT","14","25","25","ଗିସେଙ୍ଗ୍ ତେଃସନେ ବେଲା ଜିସୁ କେଣ୍ଡିଆ ଆଃଡ଼ା ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ସିସ୍‌ଇଙ୍ଗ୍‌ନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_26","070_14_26","MAT","14","26","26","ସିସ୍ଇଂ ଆମେକେ କେଣ୍ଡିଆ ଆଡ଼ାତ୍ରା ଅଲେଙ୍ଗ୍‌ନେ କେଚେ ବୁଟମେଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, ଆକେନ୍‌ ତ ବୁତ୍‌; ଆରି ମେଇଙ୍ଗ୍ ବୁଟଚେଃ କିରଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_27","070_14_27","MAT","14","27","27","ଜିଆ ଜିଆ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ସାଆସ୍ ସାଃପା “ଆକେନ୍ ତ ନେଙ୍ଗ୍ ! ଆବ୍‍ଟଗ୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_28","070_14_28","MAT","14","28","28","ଏନ୍‌ ଅଁଚେ ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ, ଜଦି ସତ୍‍ରେ ନାଁ ଡିଙ୍ଗ୍ ନାଲେଏ; ତେଲା ଣ୍ଡିଆ ଆଡ଼ାତ୍ରା ଅଲେଙ୍ଗ୍‌ଚେ ନାଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ନ୍‍ସା ଆନେଙ୍ଗ୍‌କେ ଆଦେସ୍‍ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_29","070_14_29","MAT","14","29","29","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଅଲେଙ୍ଗ୍‌ଚେ ପାଙ୍ଗ୍‌ଲା ।” ପିତର୍ ତରାବାନ୍‍ ଜାର୍‌ଚେ ଜିସୁ ପାକା ଣ୍ଡିଆ ଆଡ଼ାତ୍ରା ଅଲେଙ୍ଗ୍‍ନ୍‍ସା ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_30","070_14_30","MAT","14","30","30","ମାତର୍‌ ୱେଡ଼ିଆ ଜାବର୍ ପାଙ୍ଗ୍‌ନେ କେଚେ ବୁଟକେ ଆରି ଣ୍ଡିଆନ୍ନିଆ ଲଗ୍‍ଡ୍ୟାନେ ମୁଲେକେ । ତେସା ମେଁ କିରଚେ ୱାକେ “ମାପ୍ରୁ ଆନେଙ୍ଗ୍‌କେ ରକ୍ୟା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_31","070_14_31","MAT","14","31","31","ଟାପ୍‍ନା ଜିସୁ ନ୍ତି ଆଚ୍ଲେଚେ ପିତର୍‌କେ ସାଚେ ବାସଙ୍ଗ୍‌କେ “ନାନେ ଉଡ଼ି ଗଣ୍ଡା ବିସ୍‌ବାସ୍ ! ଡାଉଟ୍‍ ମେସା ନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT14_32","070_14_32","MAT","14","32","32","ବାରି ମେଇଂ ମ୍ବାୟା ତରାନ୍ନିଆ ଡେଆର୍କେ ଆତେନ୍‌ ବେଲା ୱେଡ଼ିଆ ବୁଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_33","070_14_33","MAT","14","33","33","ତରାନ୍ନିଆ ଲେଃକ୍ନେ ସିସ୍‍ଇଂ ଜିସୁକେ ଅସ୍‌ମାର୍ ସାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ନାଁ ସତ୍‍ରେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT14_34","070_14_34","MAT","14","34","34","ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌‌ଇଙ୍ଗ୍‌ କେଣ୍ତିଆ ପୁଆଃଚେ ଗିନେସରତ୍ ଏରିଆ ୱେଚାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_35","070_14_35","MAT","14","35","35","ଆତେନ୍‌ ଇନିନେ ରେମୁଆଁଇଂ ଜିସୁକେ ସାମୁଆଃଚେ ଡାଗ୍ରା ଲେଃକ୍ନେ ଇନିନେ ରଗି‍ଇଂକେ ଜିସୁନେ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ ପାଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT14_36","070_14_36","MAT","14","36","36","ଆଃସିଣ୍ଡ୍ରେକେ ମେଁନେ ସକାନେ ଜାଲିପୁଆଃ ଲିଗ୍‍ନ୍‍ସା ବାସଙ୍ଗ୍ ବିଃଲେ ଡାଗ୍‌ଚେ ମେଇଂ ଜିସୁକେ ଗୁଆରେ ଡିଙ୍ଗ୍ଆର୍‌କେ । ଜାଣ୍ଡେଇଂ ଆତେନ୍‌ ଡିଙ୍ଗ୍ ଆର୍‌କେ ମେଇଂ ସାପାରେ ନିମାନ୍‍ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_1","070_15_1","MAT","15","1","1","ମେସୁଆ ଉଡ଼ିରୁଆ ଫାରୁଶୀ ବାରି ଦରମ୍ ଗୁରୁ ଯିରୂଶାଲମ୍‌ ବାନ୍ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ସାଲ୍ୟାକୁକେ ");
INSERT INTO gaq_vpl VALUES ("MT15_2","070_15_2","MAT","15","2","2","“ନେନେ ଅସେନେ ନ୍ତାଞ୍ଜାଇଂ ଆଣ୍ଡିନେ ସାପା ନିଅମ୍ କାନୁନ୍‍ ବିଚେ ୱେଲେ ନାନେ ସିସ୍‍ଇଂ ମେଁନ୍‌ସା ଆତେନ୍‌ ଆମାନେଆର୍କେ ? ଚଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ମେଇଂ ନିୟମ୍‌ ଇସାବ୍‌ରେ ନ୍ତି ଆଗୁଇତିଆର୍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_3","070_15_3","MAT","15","3","3","ଜିସୁ ଉତର୍ ବିକେ “ପେ ସାପାରେ ମେଁନ୍‌ସା ଇସ୍‌ପର୍‌ନେ ଆଦେସ୍‌ ମାମାନେଃଚେ ନିଜେ ବୁଦିରେ କାମ୍ ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ?” ");
INSERT INTO gaq_vpl VALUES ("MT15_4","070_15_4","MAT","15","4","4","ଇସ୍‌ପର୍ ଆଦେସ୍‌ ଡିଙ୍ଗ୍‌କେ, ଆବା ଇୟାଙ୍ଗ୍‌ନେ ସାମୁଆଁ ମାନେଃପା । ଜା ମେଁନେ ଆବାଡ଼େ କି ଇୟାଙ୍ଗ୍‌ଡେକେ ଦଦ୍ୟା ସାମୁଆଁ ବାସଙ୍ଗ୍ଏ, ମେଁ ଗୁଏଃନେ ଡଣ୍ଡ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT15_5","070_15_5","MAT","15","5","5","“ମାତର୍‌ ପେ ସିକ୍ୟା ବିପେଡିଙ୍କେ ଜେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଆଣ୍ଡିନେ ଡାବୁ ଏତେ ନିଜେନେ ଆବା ଇୟାଙ୍ଗ୍‌କେ ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‍ପାୟା ଆତେନ୍‌ ଇସ୍‌ପର୍‌କେ ଦାନ୍ ବିମ୍ବକେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ବିଲା ");
INSERT INTO gaq_vpl VALUES ("MT15_6","070_15_6","MAT","15","6","6","ମେଁ ବାରି ମେଁନେ ଇୟାଙ୍ଗ୍ ଆବାକେ ଦାଇତ୍‍ ଡୁଙ୍ଗ୍‍ ଡନେ ଦର୍‌କାର୍ ଣ୍ଡୁ । ପେ ଦେକ୍‌ରକମ୍ ବାବ୍‌ରେ ଇସ୍‌ପର୍‌ନେ ଆଦେସ୍‌ ଆମାନେଚେ ନିଜେନେ ବୁଦିରେ ଅଲେଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("MT15_7","070_15_7","MAT","15","7","7","ରେ କୁଟ୍‌ଣ୍ଡ୍ରେଇଂ, ଯିଶାଇୟ ପେଇଂନେ ବିସୟ୍‌ରେ ସତ୍ ବାବ୍‌ରେ ବବିସତ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍ ବକେ, ଡିରକମ୍ ଗୁଆର୍‍ ବକେ ");
INSERT INTO gaq_vpl VALUES ("MT15_8","070_15_8","MAT","15","8","8","ଆକେନ୍ ଜାତିନେ ସାର୍ମୁଆରେ ଆନେକେ ସମାନ୍ ଆଃଡିଙ୍ଗ୍ଏ, ଡାଗ୍ଲା ମେଁଇଙ୍ଗ୍‌ନେ ଗାଗ୍‌ଡ଼େ ନେନେ ବାନ୍ ସ୍ଲ ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_9","070_15_9","MAT","15","9","9","ଆନେଙ୍ଗ୍‌କେ ମେଇଂ ଆରାଦନା ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ ଣ୍ଡୁ ମେଁନ୍‌ସା ଡାଗ୍ଲା ମେଇଂ ରେମୁଆଁ ଆରେ ବକ୍ନେ ନିୟମ୍‍କେ ନେଙ୍ଗ୍‌ନେ ନିଅମ୍ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_10","070_15_10","MAT","15","10","10","ଜିସୁ ରେମୁଆଁଇଂକେ ଡାଗ୍ରା ୱାଚେ ବାସଙ୍ଗ୍‌କେ “ଅଁପା ବାରି ବୁଜେନ୍‍ସା ଚେସ୍‍ଟା ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT15_11","070_15_11","MAT","15","11","11","ରେମୁଆଁନେ ତୁମୁଆଃ ପାକା ମେଃନେ ତୁମୁଆଃ ବିତ୍ରେ ଗାଏ, ମେଁ ଆମେକେ ଅପବିତ୍ର ଆରାଡିଙ୍ଗ୍‍ ଣ୍ଡୁ; ମେଃନେ ତୁମୁଆଁଃବାନ୍ ତାର୍‌ଏ ଆତେନ୍‌ ଆମେକେ ଅପବିତ୍ର ଆଃଡିଙ୍ଗ୍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_12","070_15_12","MAT","15","12","12","ସିସ୍‍ଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ନାନେ ବ୍ନାଲିର୍ ଅଁଚେ ଫାରୁଶୀଇଂ ଗିସେଃ ଲେଃଆର୍‌କେ ଏନ୍‌ ମେଁନେ ନାମ୍ୟାଃକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT15_13","070_15_13","MAT","15","13","13","ଜିସୁ ଉତର୍ ବିକେ “ମୁଡ଼ି ସ୍ଲାଇଂକେ କିତଂନେ ନେମ୍ବା ଇସ୍‌ପର୍ ଆଉଙ୍କେ ଣ୍ଡୁ ଆତେନ୍‌ ସାପା ଗୁଏଃ ଜଗ୍‍ତ୍ଲାଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT15_14","070_15_14","MAT","15","14","14","ମେଇଂ ବିସୟ୍‌ରେ ତାନ୍ଦ୍ରା ଆଡିଙ୍ଗ୍‌ପା । ମେଇଂ କାନାଣ୍ଡ୍ରେ । ମୁଇଙ୍ଗ୍ କାନା ବାରି ମୁଇଙ୍ଗ୍ କାନାକେ ଗାଲି ଆସୁଏଲା ମ୍ବାୟା ଜାକ କୁରୁନ୍ନିଆ ଜଗାଚେ ଲଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_15","070_15_15","MAT","15","15","15","ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ବ୍ନାଇର୍‌କେ ନିମାଣ୍ଡା ସୁଗୁଆ ଆଃବୁଜେ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_16","070_15_16","MAT","15","16","16","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଏଜାକ ବିନ୍‍ଣ୍ଡ୍ରେ ବାନ୍ ପେନେ ଦ୍ରିଗ୍‍ନେ ବପୁ ମେଃଡିଗ୍ ଗୁଲୁଏ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT15_17","070_15_17","MAT","15","17","17","ଅଃକେନ୍ ଦ୍ରିଗ୍ ନାୟାକେ ଣ୍ଡୁ ? ମୁଡ଼ି ଦଦିଆ ସାମୁଆଁ ରେମୁଆଁନେ ତୁମୁଆଃ ପାକା ଗାଏ ଆତେନ୍‌ ସୁଲୁଏ ବିତ୍ରେ ୱେଏ ବାରି ସୁଲୁଏ ବାନ୍ ତାର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT15_18","070_15_18","MAT","15","18","18","ମାତର୍‌ ମେଁନେ ସାପା ସାମୁଆଁ ମେଁନେ ତୁମୁଆଃ ପାକା ତାର୍‌ଏ, ଆତେନ୍‌ ଗାଗ୍‌ଡ଼େବାନ୍‌ ତାର୍‌ଏ ଆରି ଆତେନ୍‌ ଆଃ ଆମେକେ ଅପବିତ୍ର ଆଃଡିଙ୍ଗ୍ଏ ");
INSERT INTO gaq_vpl VALUES ("MT15_19","070_15_19","MAT","15","19","19","ଡାଗ୍ଲା ବିତ୍‌ରେବାନ୍‌, ରେମୁଆଁନେ ମନ୍‌ବାନ୍‌, ଦଦ୍ୟା‌ ଚିନ୍ତା ତାର୍‌ଏ । ବେସ୍ୟା ୱେନେ, ଡଙ୍ଗାନେ, ମିଚ୍‌ସାକି ଆରି ନିନ୍ଦା ତାର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT15_20","070_15_20","MAT","15","20","20","ଏନ୍‌ ସାପା କାମ୍ ରେମୁଆଁକେ ଦଦିଆ ଆଃଡିଙ୍ଗ୍ଏ । ମାତର୍‌ ମେଇଂ ମାବାସଙ୍ଗ୍‍ ଜାକ ମାଗୁଇତିଚେ ଚଙ୍ଗ୍‌ନେ ରେମୁଆଁକେ ଦଦ୍ୟା ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_21","070_15_21","MAT","15","21","21","ଜିସୁ ଆତେନ୍‌ ଜାଗା ଆନ୍ତାର୍ଚେ ସୋର ଆରି ସୀଦୋନ ଇନି ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_22","070_15_22","MAT","15","22","22","ଆତ୍‌ଅରିଆ ବାସା ଲେଃକ୍ନେ ମୁଇଂଜା କିଣାନୀୟ ସେଲାମ୍ବୁଏ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍ ବାସଙ୍ଗ୍‌କେ “ଅ ମାପ୍ରୁ ଦାଉଦ୍‍ କୁଲ୍‌ନେ ଆନେଙ୍ଗ୍‌କେ ଦୟା ଡିଙ୍ଗ୍ । ନେଉଂକେ ସେଆଁରେ ସାଃଲେଃକେ ବାରି ମେଁ ଗୁଲୁଏ କସ୍ଟ ବାଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_23","070_15_23","MAT","15","23","23","ମାତର୍‌ ଜିସୁ ଆମେକେ ମୁଇଂପଦ୍‌ ଡିଗ୍ ଉତର୍ ଆବିକେ ଣ୍ଡୁ । ସିସ୍‍ ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଗୁଆରେ ଡିଙ୍ଗ୍ଆର୍‌ଡିଂକେ, ଆମେକେ ଜିଆ ନୁଆଁ ବିଃପା । କେଲା ମେଁ ଡିରକମ୍ କିରଚେ ନେନେ ପ୍ଲା ପାଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_24","070_15_24","MAT","15","24","24","ଜିସୁ ଉତର୍ ବିକେ “ବକ୍ନେ ମେଣ୍ଡା ସୁଗା ଗାଲି ଗୁତିଆ ଇଶ୍ରାୟେଲନେ ରେମୁଆଁଇଂ ଡାଗ୍ରା ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‍ନ୍ଲେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_25","070_15_25","MAT","15","25","25","ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ଞ୍ଚବୁନ୍ଦେ ଲଃଚେ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ଆନେଙ୍ଗ୍‌କେ ଦୟା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_26","070_15_26","MAT","15","26","26","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଗଡ଼େଇଂନେ କାଦି ଡୁଙ୍ଗ୍‍ ୱେଚେ ଗୁସୁଃନେ ସେନୁଗ୍ ଜଗ୍‌ତ୍ଲାଗ୍‌ନେ ବଲ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_27","070_15_27","MAT","15","27","27","ସେଲାମ୍ବୁଏ ଉତର୍ ବିକେ, “ଅ ମାପ୍ରୁ ଆତେନ୍‌ ସତ୍ ମାତର୍‌ ଗୁସୁଃଇଂ ଡିଗ୍ କଟ୍ ଆଲ ଲଃଲେଃକ୍ନେ ସାଉକାର୍‌ନେ ମୁଆଃସିଆ ଚଙ୍ଗ୍‌ନେ ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_28","070_15_28","MAT","15","28","28","ଜିସୁ ମେଁନେ ବ୍ନାଇର୍‌ନ୍ନିଆ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ନାନେ ମ୍ନାଃ ବିସ୍‌ବାସ୍‌, ନାନେ ଇକ୍‌ଚାରେ ସମାନ୍ ଡିଙ୍ଗ୍‌ଏ । ଆତୁଆଃଆ ମେଁନେ ସେଲାଅ ନିମାଣ୍ଡା ଡିଙ୍ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_29","070_15_29","MAT","15","29","29","ଆତ୍‍ ବାନ୍ ତାର୍‌ଚେ ଜିସୁ ଗାଲିଲୀନେ କେଣ୍ଡିଆ ଆଃଡ଼ା ଆଃଡ଼ା ୱେଚେ ମୁଇଙ୍ଗ୍ କଣ୍ଡା ଆଡ଼ାତ୍ରା କକେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_30","070_15_30","MAT","15","30","30","ଗୁଲେମାନ୍ଦା ରେମୁଆଁଇଂ ପାଙ୍ଗ୍‌ଚେ ମେଁ ଡାଗ୍ରା ରିସିଙ୍ଗ୍ ଆର୍‌କେ । ମେଇଂ ଚଟା କାନା ଅଲେଙ୍ଗ୍ ଆୟାଣ୍ଡ୍ରେ ବାରି ଗୁଲେ ଆଃସିଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଡୁଙ୍ଗ୍‍ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ଞ୍ଚବୁନ୍ଦେ ବଆର୍‌କେ ବାରି ଜିସୁ ମେଁ ସାପାରେକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_31","070_15_31","MAT","15","31","31","କନ୍ଦାଗୁଲା ବାସଙ୍ଗ୍‌ ୟାଏ, ଅଲେଙ୍ଗ୍ ଆୟାଣ୍ଡ୍ରେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ଏ, ଚଟାଣ୍ଡ୍ରେ ଅଲେଙ୍ଗ୍‍ଏ ବାରି କାନାଣ୍ଡ୍ରେ ମ୍ମୁଆଃ କେୟାନେ କେଚେ ରେମୁଆଁଇଂ କାବା ଡିଂୱେଆର୍‌କେ ବାରି ଇଶ୍ରାୟେଲନେ ରେମୁଆଁଇଂ ଇସ୍‌ପର୍‌କେ ପ୍ରସଂସା ଡିଂଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_32","070_15_32","MAT","15","32","32","ଜିସୁ ସିସ୍ଇଂକେ ଡାଗ୍ରା ୱାଚେ ବାସଙ୍ଗ୍‌କେ, “ଏନ୍‌ ରେମୁଆଁଇଙ୍ଗ୍ ନ୍‌ସା ଆନେଙ୍ଗ୍‌କେ ଜାବର୍‌ ଲିବିସଃ ଲାଗେ ଡିଙ୍ଗ୍‌କେ । ମେଇଙ୍ଗ୍ ନେଙ୍ଗ୍ ଏତେ ଜିର୍‌ସି ଦିନା ଡିଙ୍ଗ୍‌ଗେ ନେଙ୍ଗ୍ ଏତେ ଲେଃଆର୍‌ଡିଙ୍କେ ମାତର୍‌ ଚଙ୍ଗ୍‌ନେସା ମେଃଡିଗ୍ ଣ୍ଡୁ । ମେଇଂ ମାଚଙ୍ଗ୍‍ଚେ ଆକ୍‌ବାନ୍ ୱିଗ୍‍ଲେ, ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT15_33","070_15_33","MAT","15","33","33","ସିସ୍ଇଂ ବାସଙ୍ଗ୍ଆର୍‌କେ, “ଏନ୍‌ ବାଲିଲନ୍ନିଆ ଇନିନେ ଅଃକେନ୍ ରେମୁଆଁଇଂକେ ଆଃଚଙ୍ଗ୍ ନ୍‌ସା ନେ ଆଣ୍ଡିବାନ୍ ଚଙ୍ଗ୍‌ନେ ନେଅବାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MT15_34","070_15_34","MAT","15","34","34","ଜିସୁ ଆମେଇଂକେ ସାଲିଆକୁକେ “ପେନ୍ନିଆ ଉଡ଼ିକ୍ଲିଗ୍ ରୁଟି ଲେଃକେ ?” ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌କେ । “ନେଅରିଆ ଗୁକ୍ଲିଗ୍ ରୁଟି ଲେଃକେ ।” ବାରି ଇକୁଡ଼ା ସୁଗୁଆ ଡାଆଁ ଆଃଡ଼ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_35","070_15_35","MAT","15","35","35","ଜିସୁ ରେମୁଆଁଇଂକେ ତୁବଃ ଆଡ଼ାତ୍ରା କୁକ ନ୍‍ସା ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_36","070_15_36","MAT","15","36","36","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଆତେନ୍‌ ଗୁକ୍ଲିଗ୍ ରୁଟି ବାରି ଆଡ଼ ଡୁଙ୍ଗ୍‍ ୱେଚେ ଇସ୍‌ପର୍‌କେ ଦନ୍ୟବାଦ୍‍ ବିକେ ବାରି ଆତେନ୍‌ ରୁଟିକେ ମେତାଃ ମେତାଃ ପାକ୍‌ଚିଚେ ସିସ୍ଇଂକେ ବିକେ । ସିସ୍‍ଇଂ ଆତେନ୍‌ ରେମୁଆଁଇଂକେ ବାଟା ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_37","070_15_37","MAT","15","37","37","ସାପା ରେମୁଆଁ ଚଙ୍ଗ୍‌ଚେ ସାନ୍ତି ଡିଙ୍ଗ୍ଆର୍‌କେ ବାରି ସିସ୍ଇଂ ଲୁଆଁ ଲେଃକ୍ନେ କାଦି ଗୁକ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାନ୍ନିଆ ବର୍ତି ଆଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_38","070_15_38","MAT","15","38","38","ସେଲାମ୍ବୁଏ ବାରି ଗଡ଼େଇଂକେ ଆନ୍ତାର୍ଚେ ଅଁ ଅଜାର୍ ରେମୁଆଁ ଏନ୍‌ କାଦି ଚଙ୍ଗ୍‌ଲେଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT15_39","070_15_39","MAT","15","39","39","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ରେମୁଆଁଇଂକେ ନୁଆଁ ବିଚେ ତରାନ୍ନିଆ ଡେଃଚେ ମଗଦାନ ଇନି ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT16_1","070_16_1","MAT","16","1","1","ମେଃସୁଆ ଉଡ଼ିକ୍ଲିଗ୍ ଫାରୁଶୀ ବାରି ସାଦୁକୀଇଂ ଜିସୁକେ ପରିକ୍ୟା ଡିଙ୍ଗ୍‌ନେସା ମେଇଂ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ମେଇଂ ଜିସୁକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଇସ୍‌ପର୍ ଆମେକେ ସ୍ରିବକେ ଡାଗ୍‌ଚେ ପାର୍‌ମାନ୍ ବିଃନ୍‍ସା ମେଁ ମୁଇଙ୍ଗ୍ କାବା ଡିଙ୍ଗ୍‌କ୍ନେ କାମ୍ ଡିଙ୍ଗ୍‌ଚେ ଆସୁଏଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_2","070_16_2","MAT","16","2","2","ମାତର୍‌ ଜିସୁ ଉତର୍ ବିକେ “ଲମ୍‍ଡିଗ୍‍ ବେଲା ତ୍ରିଗ୍‍ଡ୍ୟା ଚିରା ତ୍ନାଲା ପାଗ୍‍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ଏ ଡାଗ୍‌ଚେ ପେ ବାସଙ୍ଗ୍‌ ପେମ୍ୟା ");
INSERT INTO gaq_vpl VALUES ("MT16_3","070_16_3","MAT","16","3","3","ଆରି ଞ୍ଜିର୍‍ ତ୍ରିଗ୍‍ଡ୍ୟା ଚିରା ବାରି ତାଙ୍ଗ୍‌କିଗ୍ ତ୍ନାଲା ଣ୍ଡିଆ ପାଙ୍ଗ୍‌ନେ ଜାବର୍ ବା ପେମ୍ୟାଃ । ତ୍ରିଗ୍‍ଡ୍ୟାକେ କେଚେ ପାଗ୍‍ ସାମୁଆଁ ବୁଜେ ପେଡିଙ୍ଗ୍ । ମାତର୍‌ ଏନ୍‍ ଜୁଗ୍‍ନ୍ନିଆ ମେଃନେ ଗଟେଡିଂକେ ଆତେନ୍‌‌ ସାପା ପେ ଡିରକମ୍ ମ୍ୟାପେୟାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_4","070_16_4","MAT","16","4","4","ଏନ୍‌ ଜୁଗ୍‍ନେ ରେମୁଆଁଇଂ ଉଡ଼ି ଦୁସ୍ଟ ବାରି ଇସ୍‌ପର୍‌କେ ସତ୍ ଆମାନେକ୍ନେ ! ପେ ମୁଇଙ୍ଗ୍ କାବା ଡିଙ୍ଗ୍‌କ୍ନେ କାମ୍ ଆସୁଏ ନ୍‌ସା ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ? ମାତର୍‌ ଜୁନସ୍‍ନେ ଜିବନ୍‍ନିଆ ଗଟେଲେ କାବା ଡିଙ୍ଗ୍‌କ୍ନେ କାମ୍ ଆନ୍ତାର୍ଚେ ବିନ୍ ମେଃଡିଗ୍ କାବା ଡିଙ୍ଗ୍‌ନେ କାମ୍ ପେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପେକେ ଣ୍ଡୁ । ଦେତ୍ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁ ଆମେଇଂକେ ଆନ୍ତାର୍ଚେ ଲାଗ୍‍ଡଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT16_5","070_16_5","MAT","16","5","5","ସିସ୍‍ଇଂ କେଣ୍ଡିଆ ଇନୁମେତା ୱେନେ ବେଲା ରୁଟି ଡୁଙ୍ଗ୍‍ୱିଗ୍‌ ନ୍‌ସା ଆବଃ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT16_6","070_16_6","MAT","16","6","6","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ତରକ୍ ଲାଲାପା ଫାରୁଶୀ ବାରି ସାଦୁକୀଇଂନେ କମିର୍‍ ଆଡ଼ାତ୍ରା ତରକ୍ ଲାଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_7","070_16_7","MAT","16","7","7","ମେଇଂ ନିଜେ ନିଜେ ବିତ୍ରେ ବାଲିର୍‌ବାତାଚେ ବାସଙ୍ଗ୍‌କେ “ନେନେ ରୁଟି ଡୁଙ୍ଗ୍‍ ନେପାଙ୍ଗ୍‌ଲା ମେଁ ଏନ୍‌ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_8","070_16_8","MAT","16","8","8","ମେଇଂ ମେଃନେ ବାସଙ୍ଗ୍‌ଆର୍‌ଡିଙ୍ଗେ ମ୍ୟାଃୟାଚେ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେ ଡାଗ୍ରା ରୁଟି ଣ୍ଡୁ ଡାଗ୍‌ଚେ ମେଁନ୍‌ସା ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ?” ପେନେ ସତ୍ ପେମାନେକ୍ନେ ଉଡ଼ି ଇକୁଡ଼ା । ");
INSERT INTO gaq_vpl VALUES ("MT16_9","070_16_9","MAT","16","9","9","ଏ ଜାକ ମେଃନେ ବୁଜେ ପେୟାକେ ? ମାଲ୍ ଅଜାର୍ ରେମୁଆଁଇଂକେ ନେଙ୍ଗ୍ ମାଲିକ୍ଲିଗ୍ ରୁଟି ବାଟା ବକ୍ନେ ସାମୁଆଁ ମେଃନେ ପେନେ ମନେ ଣ୍ଡୁ ? ଅଃତେନ୍‍ ବେଲା ଉଡ଼ିକ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାନ୍ନିଆ ଆତ୍ନ ପେବଗେ ? ");
INSERT INTO gaq_vpl VALUES ("MT16_10","070_16_10","MAT","16","10","10","ଆରି ଅଁ ଅଜାର୍ ରେମୁଆଁଇଂନେ ନ୍‌ସା ଗୁକ୍ଲିଗ୍ ରୁଟିନେ ସାମୁଆଁ ମନେ ଣ୍ଡୁ ? ଅଃତେନ୍‍ ବେଲା ଉଡ଼ିକ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାନ୍ନିଆ ଆତ୍ନ ପେବଗେ ? ");
INSERT INTO gaq_vpl VALUES ("MT16_11","070_16_11","MAT","16","11","11","“ନେଙ୍ଗ୍ ରୁଟିନେ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‍ଗେ ଣ୍ଡୁ ପେ ଡିରକମ୍ ବୁଜେ ପେୟାକେ ଣ୍ଡୁ ? ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଫାରୁଶୀ ବାରି ସାଦୁକୀଇଂନେ କମିର୍‍ ଆଡ଼ାତ୍ରା ତରକ୍ ଲାଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_12","070_16_12","MAT","16","12","12","ଅଃତେନ୍‍ ବେଲା ସିସ୍‍ଇଂ ବୁଜେ ୟାଆର୍‌କେ ଜେ ଜିସୁ ରୁଟିନେ କମିର୍‍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଆବଗେ ଣ୍ଡୁ ମାତର୍‌ ଫାରୁଶୀ ବାରି ସାଦୁକୀଇଂନେ ସିକ୍ୟା ଆଡ଼ାତ୍ରା ତରକ୍ ଆଡିଙ୍ଗ୍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT16_13","070_16_13","MAT","16","13","13","କାଇସରିଆ ଫିଲିପ୍‌ପି ଇନି ଡାଗ୍ରା ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍‍ଇଂକେ ସାଲ୍ୟାକୁକେ “ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଜାଣ୍ଡେ ଏନ୍‌ ବିସୟ୍‌ରେ ରେମୁଆଁ ମେଁନେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍ ?” ");
INSERT INTO gaq_vpl VALUES ("MT16_14","070_16_14","MAT","16","14","14","ମେଇଂ ଉତର୍ ବିକେ, “ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌ଡିଂକେ ମେଁ ଣ୍ଡିଆନ୍ନିଆ ଦିକ୍ୟା ବିଣ୍ଡ୍ରେ ଜହନ୍‌ । ବାରି ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌ଡିଂ ଏଲୀୟ ବାରି ଜା ଜା ଯିରିମିୟ ବାରି ଜା ବାବବାଦିଇଂନେ ବାନ୍‌ ମୁଇଂଜା ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_15","070_16_15","MAT","16","15","15","ଜିସୁ ସାଲ୍ୟାକୁକେ “ନେଙ୍ଗ୍ ଜାଣ୍ଡେ ଏନ୍‌ ବିସୟ୍‌ରେ ପେ ମେଁନେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ?” ");
INSERT INTO gaq_vpl VALUES ("MT16_16","070_16_16","MAT","16","16","16","ଶିମୋନ୍ ପିତର୍ ଉତର୍ ବିକେ “ନାଁ କିସ୍‌ଟ ମସିହ, ଜିବନ୍ ଲେଃକ୍ନେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_17","070_16_17","MAT","16","17","17","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଦନ୍ୟ ନାଁ ଯୁନସ୍ ଉଙ୍ଗ୍‌ଡେ ଶିମୋନ୍ ! ଏନ୍ ସତ୍ ନେ ମୁଃଡ଼ି ରେମୁଆଁବାନ୍ ନେବାକେ ଣ୍ଡୁ । ନେଙ୍ଗ୍‌ନେ କିତଂଇନିନେ ଆବା ଲେଃକ୍ନେ ନିଜେ ଏନ୍ ନା ଡାଗ୍ରା ବାସଙ୍ଗ୍‌ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT16_18","070_16_18","MAT","16","18","18","ଆତେନ୍‌‍ସା ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ପିତର୍‌ନେ ଅର୍‌ତ ବ୍ରି । ଏନ୍‌ ବ୍ରି ଆଡ଼ାତ୍ରା ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ମଣ୍ଡଲି ପ୍ରତିସ୍ଟା ଡିଙ୍ଗ୍‌ଏ । ଦେତ୍‌ରକମ୍ କି ନର୍କନେ ବପୁ ଆମେକେ ଆନାସେ ଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT16_19","070_16_19","MAT","16","19","19","ନେଙ୍ଗ୍ ଆପେକେ କିତଂନେ କୁଚିକାଡ଼ି ମ୍ବିଏ । ପେ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ମେଃନେ ବନ୍ଦ୍ ପେଡିଙ୍ଗ୍‌ଏ କିତଂନ୍ନିଆ ଡିଗ୍ ଆତେନ୍‌ ବନ୍ଦ୍ ଡିଙ୍ଗ୍‌ଏ । ପେ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ମେଃନେ ଇକ୍‌ଚା ପେଡିଙ୍ଗ୍‌ଏ କିତଂନ୍ନିଆ ଡିଗ୍ ଆତେନ୍‌ ବାସଙ୍ଗ୍‌ନେ ସେନୁଗ୍‌ ମିଲେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_20","070_16_20","MAT","16","20","20","ଜିସୁକେ କିସ୍‌ଟ ଡାଗ୍‌ଚେ ଆଜାଡିଗ୍ ଆରା ଅଁନ୍‌ସା ମେଁ ସିସ୍‍ଇଂକେ ଆଦେସ୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT16_21","070_16_21","MAT","16","21","21","ଆତେନ୍‌ ବେଲା ବାନ୍ ଜିସୁ ସିସ୍‍ଇଂକେ କୁଲାକୁଲି ବାବ୍‌ରେ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ, “ନେଙ୍ଗ୍ ଯିରୂଶାଲମ୍‌ନ୍ନିଆ ୱେଚେ ଦର୍ମ ଜାଜକ୍‍, ଦର୍ମ ଗୁରୁ ବାରି ଦର୍ମ ନେତାଇଂ ନ୍‌ସା ଗୁଲେ କସ୍ଟ ମ୍ବାଏ । ଇଡ଼ିଙ୍ଗ୍ ଗୁଏ ଉଁୱେଏ, ମାତର୍‌ ଜିର୍ସିଦିନା ବିତ୍ରେ ବାର୍‌ମୁଇଂତର୍‍ ନେଙ୍ଗ୍ ନ୍ତଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_22","070_16_22","MAT","16","22","22","ପିତର୍ ଜିସୁକେ ବିନେ ୱାଡୁଂୱେଚେ ଗୁଆରେଚେ ବାସଙ୍ଗ୍‌କେ, “ଇସ୍‌ପର୍ ଆରାଃଡିଙ୍ଗ୍‌ଲେ, ମାପ୍ରୁ ନାନେ ଆଡ଼ାତ୍ରା ଏନ୍‌ ସାପା ଅଃନା ଆଗଟେଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_23","070_16_23","MAT","16","23","23","ଜିସୁ ପ୍ଲେଗ୍‌ଚେ ପିତରକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‌ନେ ବାନ୍ ସ୍ଲ ୱେଲା ସ‍ଏତାନ୍ ନେଙ୍ଗ୍‍ନେସା କସ୍ଟ ଆଡିଙ୍ଗେ ନାମ । ମେଃନ୍‌ସା ଡାଗ୍ଲା ନାନେ ଏନ୍‌ ଚିନ୍ତା ରେମୁଆଁଇଂନେ, ମାତର୍‌ ଇସ୍‌ପର୍‌ନେ ଚିନ୍ତା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT16_24","070_16_24","MAT","16","24","24","ଅଃତେନ୍‍ ବେଲା ଜିସୁ ସିସ୍‍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଜା ନେଙ୍ଗ୍ ଏତେ ପାଙ୍ଗ୍‌ନେ ଚାଏଁଏ, ଆମେକେ ଆତ୍ମା ଆନ୍ତାର୍‌ଚେ ନିଜେନେ କୁରୁସ୍‍ ଡୁଙ୍ଗ୍‍ନେ ପଡ଼େଏ ବାରି ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ନେ ପଡ଼େଏ । ");
INSERT INTO gaq_vpl VALUES ("MT16_25","070_16_25","MAT","16","25","25","ମେଁନ୍‌ସା ଡାଗ୍ଲା ଜା ନିଜେନେ ଜିବନ୍ ଆମ୍ବ୍ରନ୍‌ସା ଚାଏଁଏ ମେଁ ଆତେନ୍‌ ଆରେଏ ମାତର୍‌ ନେଙ୍ଗ୍‍ସା ଜା ନିଜେନେ ଜିବନ୍‍କେ ଦାନ୍ ବିଏ ମେଁ ସତେଆ ମେଁନେ ସାଆ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT16_26","070_16_26","MAT","16","26","26","ବାରି ରେମୁଆଁ ଜଦି ସାପା ଦର୍ତନିକେ ଲାବ୍‌ ଡିଂଚେ ନିଜର୍‌ ଜିବନ୍‌କେ ବିଏ ତେଲା ମେଃନେ ମେଁ ଲାବ୍‌ ଡିଂଏ ? ବାରି, ରେମୁଆଁ ମେଁ ଜିବନ୍‌ ବାଦୁଲ୍‌ ମେଁ ବିଃଏ ? ");
INSERT INTO gaq_vpl VALUES ("MT16_27","070_16_27","MAT","16","27","27","ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଆବା ଇସ୍‌ପର୍‌ନେ ଏତେ ଗୌରବାନିତ ଡିଙ୍ଗ୍‌ଚେ କିତଂ ଦୁତ୍‍ଇଂ ଏତେ ବାର୍‌ମୁଇଂତର୍‍ ପାଙ୍ଗ୍‌ଏ । ଆତେନ୍‌ ବେଲା ମେଁ ସାପାରେକେ ମେଁଇଂନେ ମେଃ କାମ୍ ଡିଙ୍ଗ୍‍ବ ଆତେନ୍‌ ଇସାବ୍‌ରେ ପଲ୍‍ ମିଲେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT16_28","070_16_28","MAT","16","28","28","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ରେମୁଆଁ ଉଂଡେନେ ରାଇଜନ୍ନିଆ ମାପାଂନେ ମାକେ ଜାକ ଆକ୍‌ଅରିଆ ତୁଆଁକ୍ନେ ରେମୁଆଁଇଂନେବାନ୍‌ ଉଡ଼ିରୁଆ ମେଃଡିଗ୍‌ ରକମ୍‌ ପେଗୁଏଃ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT17_1","070_17_1","MAT","17","1","1","ଜିସୁ ଏନ୍‌ ତୁର୍‍କ୍ଲିଗ୍‍ ଦିନା ଇଡ଼ିଙ୍ଗ୍ ପିତର୍ ବାରି ଜାକୁବ୍‌ ଜହନ୍ ବମୟାଁକେ ଡୁଙ୍ଗ୍‍ ୱେଚେ ମୁଇଙ୍ଗ୍ ତିଆର୍‌କ୍ନେ କଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେଗେ । ଆତ୍‍ ଜା ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT17_2","070_17_2","MAT","17","2","2","ସିସ୍‍ଇଂ କିକେନେ ବେଲା ଜିସୁନେ ରୁପ୍‌ ବଦ୍‌ଲେକେ । ମେଁନେ ସାର୍ମୁଆଁ ସ୍ନିସୁଗା ତାର୍କିଗ୍‍ଗେ ବାରି ମେଁନେ ସକା ତାର୍କିଗ୍‍ ସୁଗା ତୁଲୁଏ ତ୍ନାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT17_3","070_17_3","MAT","17","3","3","ବାରି, ମୋଶା ବାରି ଏଲୀୟ ଜିସୁ ଏତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌କ୍ନେ ସିସ୍‌ଇଂ କେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT17_4","070_17_4","MAT","17","4","4","ପିତର୍ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, ଅ ମାପ୍‌ରୁ, ନେ ଜେ ଆକ୍‌ଅରିଆ ନେଲେଃକେ, ଆକେନ୍‌ ନିମାଣ୍ଡା; ନାନେ ଜଦି ଇକ୍‌ଚା ଡିଂଲା ନେଙ୍ଗ୍‌ ଆକ୍‌ଅରିଆ ଞ୍ଜିକ୍ଲିଗ୍‌ କୁଡ଼ିଆ ଣ୍ଡ୍ରାରେଏ, ନା ଆତ୍‌ଲା ମୁଇଂ, ମଶା ଆତ୍‌ଲା ମୁଇଂ ବାରି ଏଲିୟ ଆତ୍‌ଲା ମୁଇଂ । ");
INSERT INTO gaq_vpl VALUES ("MT17_5","070_17_5","MAT","17","5","5","ପିତର୍ ଆକେନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ବେଲା ଇକୁଡ଼ା ତ୍ରିଗ୍‌ଡିଆ ଆମେଇଂକେ ଡା ବିକେ, ବାରି କେଲାପା, ଆତେନ୍‌‌ ତ୍ରିଗ୍‌ଡିଆବାନ୍ ଆକେନ୍‌ ସାମୁଆଁ ଡିଂକେ, “ଏ ନେଙ୍ଗ୍‌ନେ ନିଜର୍‌ ଉଂଡେ ଆକ୍ମେଅରିଆ ନେଂନେ ଜାବର୍‌ ସାନ୍ତି ନ୍ଲେଃକେ” ଆକ୍ମେନେ ବ୍ନାଲିର୍‌ ଅଁପା । ");
INSERT INTO gaq_vpl VALUES ("MT17_6","070_17_6","MAT","17","6","6","ସିସ୍‍ଇଂ ଆତେନ୍‌ ବ୍ନାଲିର୍ ଅଁଚେ ବୁଟ ୱେଗେ ଜେ ମେଇଂ ତୁବନ୍ନିଆ ତାମୁଚେ ଲଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT17_7","070_17_7","MAT","17","7","7","ଜିସୁ ମେଁଇଂନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ଲିଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ତଡ଼ିଆ ଆବ୍‍ଟଗ୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT17_8","070_17_8","MAT","17","8","8","ତେଲା ମେଇଂ ଆଡ଼ାତ୍ରା କେଚେ ଜିସୁକେ ଆନ୍ତାର୍ଚେ ଆତ୍‌ଅରିଆ ବାରି ଆଜାକେ ଡିଗ୍ ଆକେଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT17_9","070_17_9","MAT","17","9","9","ମେଇଂ କଣ୍ଡାବାନ୍‍ ଜାର୍‌ନେ ବେଲା ଜିସୁ ଆମେଇଂକେ ଆଦେସ୍‍ ବିଚେ ବାସଙ୍ଗ୍‌କେ “ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଗୁଏଚେ ମାତଡ଼ିଆ ଜାକ ମେଃନେ କେପେଲେ ଏନ୍‌ ଦର୍ସନ୍ ବିଃକ୍ନେ ସାମୁଆଁ ପେ ଆଜାଡିଗ୍ ଆବାସଙ୍ଗ୍‍ଗ୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT17_10","070_17_10","MAT","17","10","10","ସିସ୍‍ଇଂ ଜିସୁକେ ସାଲ୍ୟାକୁଆର୍‌କେ, “ଏଲୀୟ ସେନୁଗ୍‍ ପାଙ୍ଗ୍ ଡାଗ୍‌ଚେ ନେନେ ଦରମ୍ ଗୁରୁଇଂ ମେଃନ୍‌ସା ବାସଙ୍ଗ୍‌ବକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT17_11","070_17_11","MAT","17","11","11","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ “ଅଁଃ ଅଁ ଏଲୀୟ ସେନୁଗ୍‍ ପାଙ୍ଗ୍‌ଚେ ସାପା ବିସୟ୍ ଆଃର୍ମେଚେ ବନେ ସାମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("MT17_12","070_17_12","MAT","17","12","12","ମାତର୍ ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଏଲୀୟ ପାଙ୍ଗ୍ ଡାଲେକେ ବାରି ଆମେକେ ମାସାମୁଆଁଚେ ରେମୁଆଁଇଂ ମେଁ ଆଡ଼ାତ୍ରା ମେଃନେ ଇକ୍‌ଚା ଆତେନ୍‌ ଡିଂଆର୍‌ଏ । ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଆଡ଼ାତ୍ରା ଡିଗ୍ ମେଇଂ ଦେତ୍‌ରକମ୍ ବେବ‍ଆର୍ ଡିଂଚେ କଷ୍ଟ ବିଃଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT17_13","070_17_13","MAT","17","13","13","ଆତେନ୍‌‌ ବେଲା ସିସ୍‍ଇଂ ବୁଜେ ୟାଆର୍‍କେ ଜେ ଜିସୁ ଡୁବନ୍ ବିଃନେ ଜହନ୍ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT17_14","070_17_14","MAT","17","14","14","ଜିସୁ ବାରି ମେଁନେ ସିସ୍‍ଇଂ ରେମୁଆଁ କିରଲେକ୍ନେ ବିତ୍ରେ ଆଣ୍ଡେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଡେଙ୍ଗାଚେ ବାସଙ୍ଗ୍‌କେ, ");
INSERT INTO gaq_vpl VALUES ("MT17_15","070_17_15","MAT","17","15","15","“ମାପ୍ରୁ ନେଉଂକେ ଦୟା ଡିଙ୍ଗ୍ । ମେଁ ମୁର୍ଚା ରଗ୍‍ରେ ଉଡ଼ି କସ୍ଟ ବାଡିଂକେ ବାରି ଉଡ଼ିତର୍ ସୁଆନ୍ନିଆ ଆରି ଣ୍ଡିଆନ୍ନିଆ ଲଃୱେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT17_16","070_17_16","MAT","17","16","16","ଆମେକେ ନେଙ୍ଗ୍ ନାନେ ସିସ୍‍ଇଂ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ମ୍ବଗେ; ମାତର୍‌ ମେଇଂ ଆମେକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ଆୟାଆର୍କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT17_17","070_17_17","MAT","17","17","17","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଆରେ ଅବିସ୍‌ବାସି ଆରି ଦଦ୍ୟା ଗାଲି ୱେଣ୍ଡ୍ରେ ବଂସ, ଉଃଡ଼ି ମୁଆଁ ନିଂ ପେନେ ଏତେ ନ୍ଲେଃଏ ? ଉଃଡ଼ି ମୁଆଁ ପେନେ ବେବ‍ଆର୍ ନ୍‌ସମ୍ବାଲେଏ ? ଆକ୍‌ଅରିଆ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଲା । ଆମେକେ ଆକ୍‌ଅରିଆ ନିଂ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଲା । ");
INSERT INTO gaq_vpl VALUES ("MT17_18","070_17_18","MAT","17","18","18","ଗଡ଼େଅନେ ବିତ୍ରେ ଲେଃକ୍ନେ ଗଲିଆକେ ଜିସୁ ଦାକା ବିକେ । ଗଲିଆ ଆମେକେ ଆନ୍ତାର୍‌ଚେ ଲାଗ୍‍ଡଗେ ଆରି ଆତୁଆଃଆ ଗଡ଼େଅ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ ୱେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT17_19","070_17_19","MAT","17","19","19","ଇଡ଼ିଙ୍ଗ୍ ସିସ୍‍ଇଂ ଜିସୁକେ ଜା ଆଲେଃକ୍ନେ ବେଲା ପାଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାକୁଆର୍‌କେ “ନେ ମେଃନ୍‌ସା ଆତେନ୍‌ ବୁତ୍‌କେ ଆଃଆନ୍ତାର୍ ନେୟାକେ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MT17_20","070_17_20","MAT","17","20","20","ଜିସୁ ଉତର୍ ବିକେ “ପେନେ ବିସ୍‌ବାସ୍ ଇକୁଡ଼ା । ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଜଦି ମୁଇଙ୍ଗ୍ ସରିସ୍‍ ମୁଞ୍ଜି ରକମ୍ ବିସ୍‌ବାସ୍ ଲେଃଏ, ତେଲା ଆକେନ୍ କଣ୍ଡାକେ ଆକ୍‌ବାନ୍ ଆତ୍‍ ୱେଲା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଲା ଆତେନ୍‌ ଗୁଚେଏ । ବିସ୍‌ବାସ୍‌ରେ ପେ ସାପା ଡିଙ୍ଗ୍ ପେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT17_21","070_17_21","MAT","17","21","21","ମାତର୍‌ ପାର୍‌ତନା ଉପାସ୍ ମାଡିଙ୍ଗ୍‌ଚେ ବିନ୍ ମେଃଣ୍ଡିଗ୍ ଉପାୟ୍‍ରେ ସେଆଁରେ ତାର୍ ଆୱେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT17_22","070_17_22","MAT","17","22","22","ସିସ୍‍ଇଂ ସାପାରେ ଗାଲିଲୀନ୍ନିଆ ମୁଇଂନ୍ନିଆ ଡିଙ୍ଗ୍‌ଲା ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ରେମୁଆଁଇଙ୍ଗ୍‌ନେ ନ୍ତିନ୍ନିଆ ଆଃସାଃ ବିଃନ୍‌ସାଃ ମେଁ ଏଃକେ ୱେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT17_23","070_17_23","MAT","17","23","23","ଆତେନ୍‌ ରେମୁଆଁଇଂ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ବାଗୁଏ ଆର୍‌ଏ ମାତର୍‌ ଜିର୍ସି ବିତ୍ରେ ମେଁ ବାରି ମୁଇଂତର୍ ତଡ଼ିଆଏ ।” ଆତ୍‌ବାନ୍ ସିସ୍‌‍ଇଂ ଦୁକ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT17_24","070_17_24","MAT","17","24","24","ଜିସୁ ବାରି ମେଁନେ ସିସ୍‍ଇଂ କପର୍ନାହୁମ୍‍ନ୍ନିଆ ପାଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମନ୍ଦିର୍‌ନେ ଡାବୁ ରାସିଙ୍ଗ୍‍ଣ୍ଡ୍ରେଇଂ ପିତର୍‌କେ ସାଲ୍ୟାକୁଆର୍‌କେ “ପେନେ ଗୁରୁ ମନ୍ଦିର୍‌ନେ ଡାବୁ ବିମ୍ୟା କ୍ଲେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT17_25","070_17_25","MAT","17","25","25","ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ସତେଆ ।” ପିତର୍ ଡୁଆ ବିତ୍ରେ ଗାକ୍ନେ ଦାପ୍ରେ ଜିସୁ ଆମେକେ ସାଲ୍ୟାଃକୁକେ, “ସିମୋନ୍‍ ନା ମେଁନେ ବାବେ ନାଡିଙ୍ଗ୍‍ ? ଏନ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଇଃସାଙ୍ଗ୍‌ଇଂକେ ଜା ଡାବୁ ବିଏ ମେଇଂନେ ରାଜିନେ ପର୍‍ଜାଇଂ ଣ୍ତୁଲା ବିଦେସିଇଂ ?” ");
INSERT INTO gaq_vpl VALUES ("MT17_26","070_17_26","MAT","17","26","26","ପିତର୍ ବାସଙ୍ଗ୍‌କେ, “ବିଦେସିଇଂ ।” ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ତେଲା ରାଜିନେ ପର୍‍ଜାଇଂ ଡାବୁ ସାଲ୍ୟାଃନେ ବାନ୍ ମୁକ୍ତି ଡିଙ୍ଗ୍ଆର୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MT17_27","070_17_27","MAT","17","27","27","ମାତର୍‌ ନେ ଏକେ ଆମେଇଂକେ ଅପ୍‍ମାନ୍‍ ଡିଙ୍ଗ୍‌ନେ ନେଚାଏଁକେ । ନାନେ କେଣ୍ଡିଆଃନ୍ନିଆ ୱେଚେ ଚ୍ନାଗ୍ ତ୍ଲାଗ୍ । ସେନୁଗ୍‍ ମୁଡ଼ିନେ ଆଡ଼ ଲାଃଏ ମେଁନେ ତୁମୁଆଃବାନ୍ ମୁଇଂ ଡାବୁ ପେବାଏ । ଆତେନ୍‌ ଡୁଙ୍ଗ୍‍ୱେଚେ ନେଙ୍ଗ୍‌ନେସା ବାରି ନାଁ ନ୍‌ସା ମନ୍ଦିର୍‌ନେ ରୁନ୍‌ ଡାବୁ ବିଃଜଗ୍‌ତ୍ଲାଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_1","070_18_1","MAT","18","1","1","ଆତେନ୍‌‍ବେଲା ସିସ୍‍ଇଂ ଜିସୁକେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “କିତଂଇନିନ୍ନିଆ ସାପାବାନ୍‍ ମ୍ନା ଜାଣ୍ଡେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT18_2","070_18_2","MAT","18","2","2","ଜିସୁ ମୁଇଂ ଡାଆଁନେ ଗଡ଼େଅକେ ମେଁଇଂନେ ସେନୁଗ୍‍ ଆତୁଆଁଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT18_3","070_18_3","MAT","18","3","3","“ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ପେଇଂ ମନ୍ ବଦ୍ଲେଲେଃଚେ ଏନ୍‌ ଡାଆଁ ଗଡ଼େଅ ସୁଗା ଆଡିଙ୍ଗ୍‌ଲା କିତଂଇନିନ୍ନିଆ ୱେଚା ପେୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT18_4","070_18_4","MAT","18","4","4","ଜା ନିଜେକେ ଡାଆଁ ଆଡିଙ୍ଗ୍‌ଚେ ଏନ୍‌ ଡାଆଁ ଗଡ଼େଅ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଏ ମେଁ କିତଂଇନିନ୍ନିଆ ସାପାବାନ୍‍ ମ୍ନା ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_5","070_18_5","MAT","18","5","5","ବାରି ଜାଡିଗ୍‍ ନେଙ୍ଗ୍ ମ୍ନିରେ ଦେକ୍‌ରକମ୍ ମୁଇଙ୍ଗ୍ ଡାଆଁ ଗଡ଼େଅକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଆନେଙ୍ଗ୍ ଡିଗ୍ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT18_6","070_18_6","MAT","18","6","6","ଆନେଙ୍ଗ୍‌କେ ସତ୍ ମାନେଡିଙ୍ଗ୍‌କ୍ନେ ଏନ୍‌ ଡାଆଁ ଗଡ଼େଅଇଂନେ ବାନ୍ ମୁଇଂଜା ସତ୍ ମାନେକ୍ନେ ଜା କି କସ୍ଟ ବିଏ ମେଁନେ ଲୁଗଃନ୍ନିଆ ମୁଇଙ୍ଗ୍ ପିନିଡିର୍‍ ବ୍ରି ଗାଗ୍‌ଚେ ଆମେକେ କେଣ୍ଡିଆନ୍ନିଆ ଜଗ୍‍ତ୍ଲାଗ୍‍ନେ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("MT18_7","070_18_7","MAT","18","7","7","ରେମୁଆଁଇଂନେ ବିସ୍‌ବାସ୍‌ରେ କସ୍ଟ ବିଃନ୍‌ସା ଗୁଲୁଏ ବିସୟ୍ ଲେଃକେ । ଆତେନ୍‌‍ସା ଏନ୍‌ ଦର୍‌ତନିନ୍ନିଆ ଉଡ଼ି ବୟଙ୍କାର୍ । କାଲାଆଃ ଦେକ୍ ସୁଗୁଆ କସ୍ଟ ପାଙ୍ଗ୍‌ଏ, ମାତର୍‌ ଜା କସ୍ଟ ବିଏ, ମେଁ ଡଣ୍ଡ୍ ବାଏ ! ");
INSERT INTO gaq_vpl VALUES ("MT18_8","070_18_8","MAT","18","8","8","ଜଦି ପେନେ ନ୍ତି ଣ୍ଡୁଲା ଞ୍ଚନ୍‌ସା ପେନେ ସତ୍ ମାନେକ୍ନେ ପେଆରେଏ ତେଲା ଆମେକେ ସିତଗ୍ ଜଗ୍‌ତ୍ଲାଗ୍‍ ବିଃପା । ମ୍ବାକ୍ଲିଗ୍ ନ୍ତି ଣ୍ଡୁଲା ମ୍ବାକ୍ଲିଗ୍ ଞ୍ଚ ଲେଃଚେ ଡୁଆଲେକ୍ନେ ନର୍କେ ଗାଲେକ୍ନେ ବାନ୍ ମୁଇଙ୍ଗ୍ ନ୍ତି ଣ୍ଡୁଲା ଚଟା ଡିଙ୍ଗ୍‌ଚେ ମାଡାନେ ପାରାନ୍‌ ବାନେ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("MT18_9","070_18_9","MAT","18","9","9","“ପେନେ ମୁଆଃ ନ୍‌ସା ଜଦି କସ୍ଟ ଲାଗେଡିଂକେ, ଆମେକେ ତଚେ ଜଗ୍‍ତ୍ଲାଗ୍‍ ବିଃପା । ମ୍ବାକ୍ଲିଗ୍ ମୁଆଃ ଲେଃଚେ ନର୍କନ୍ନିଆ ଲଃନେ ବାଟା ମୁଇଙ୍ଗ୍ ମୁଆଃ ଡୁଙ୍ଗ୍‍ୱେଚେ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ୱେନେ ନିମାଣ୍ତା ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_10","070_18_10","MAT","18","10","10","“ଏନ୍‌ ଡାଆଁ ଗଡ଼େଇଂ ବାନ୍ ମୁଇଂଜା ଡିଗ୍ ଆଇଙ୍ଗ୍‌ଚେଗ୍‌ପା । ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଆକ୍‌ମେଇଂକେ ଜତନ୍ ଡିଙ୍ଗ୍‌କ୍ନେ କିତଂ ଦୁତ୍‍ଇଂ କାଲାଆଃ କିତଂ ଲେଃକ୍ନେ ନେମ୍ବା ଇସ୍‌ପର୍ ଡାଗ୍ରା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT18_11","070_18_11","MAT","18","11","11","ମେଁନ୍‌ସା ଡାଗ୍ଲା ଗାଲି ଗୁତ୍ୟା ରେମୁଆଁଇଂକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ନେସା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_12","070_18_12","MAT","18","12","12","“ନାଁ ମେଃନେ ଏତେ ନାଡିଙ୍ଗ୍‍କେ, ଜଦି ମୁଇଂ ରେମୁଆଁନେ ମାଲ୍‍କୁଡ଼ି ମେଣ୍ଡା ଲେଃଏ ବାରି ଆତ୍‌ବାନ୍ ମୁଇଙ୍ଗ୍ ବଃୱେଏ, ତେଲା ମେଁ ମେଃଡିଙ୍ଗ୍‌ଏ ? ଅନେସ୍‌ପତ୍‌ ମେଣ୍ଡାଇଂକେ କଣ୍ଡା ଆଡ଼ାତ୍ରା ତୁର୍‍ତ୍ୟାନେ ଆନ୍ତାର୍ଚେ ଆତେନ୍‌ ବଃଲେକ୍ନେ ମେଣ୍ଡା ଆତୁର୍ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("MT18_13","070_18_13","MAT","18","13","13","ଅଃତେନ୍‍ ବେଲା ମେଁ ଆମେକେ ଆତେନ୍‌ ମେଣ୍ଡା ଅବାଏ, ତେଲା ନିଂ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ, ବଃଲେକ୍ନେ ଅନେସ୍‌ପତ୍‌ ମେଣ୍ଡାନ୍‌ସା ମେଁନେ ଉଡ଼ି ସାର୍ଦା ଏନ୍‌ ମୁଇଙ୍ଗ୍ ମେଣ୍ଡାନ୍‌ସା ମେଁ ବାନ୍ ଜାବର୍ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT18_14","070_18_14","MAT","18","14","14","ସମାନ୍ ଦେତୁଆ ଏନ୍‌ ଡାଆଁ ରେମୁଆଁଇଂନେ ବାନ୍ ମୁଇଂଜା ଡିଗ୍ ବଃୱେଏ ଏନ୍‌ ପେନେ କିତଂ ଲେଃକ୍ନେ ଆବା ଇସ୍‌ପର୍ ଆଚାଏଁ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_15","070_18_15","MAT","18","15","15","“ମୁଇଙ୍ଗ୍ ବୟାଁ ଜଦି ପେନେ ବିରଦ୍‌ରେ ଦସ୍‍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଡାଗ୍ରା ୱେଚେ ଦସ୍‍ ଆମେକେ ଆକେ ବିଃପା । ମାତର୍‌ ପେମ୍ବାୟା ମୁଇଂନ୍ନିଆ ଲେଃକ୍ନେ ବେଲା ଏନ୍‌ ବୁଡ଼ିଚେ ଡିଙ୍ଗ୍‌ପା । ଡାଗ୍ଲା ମେଁ ପେନେ ବ୍ନାଲିର୍ ଅଁଏ ତେଲା ନାବୟାଁକେ ନାଅବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT18_16","070_18_16","MAT","18","16","16","ଡାଗ୍ଲା ମେଁ ଆଅଁଣ୍ଡୁ ମୁଇଂଜା ଣ୍ଡୁଲା ମ୍ବାୟା ରେମୁଆଁ ଡୁଙ୍ଗ୍‌ୱେଚେ ମେଁ ଡାଗ୍ରା ୱେଲାପା । ନେନେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‌ ବକେ, ମ୍ବାୟା ଣ୍ଡୁଲା ଞ୍ଜିରୁଆ ସାକିନେ ସାମ୍‌ନା ପେନେ ସାପା ଦାବି ଡିଙ୍ଗ୍‍ଲା ସତ୍ ଡାଗ୍‌ଚେ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT18_17","070_18_17","MAT","18","17","17","ତେଲା ଡିଗ୍ ଜଦି ମେଁ ପେନେ ସାମୁଆଁ ଆଅଁ ଣ୍ଡୁ ଏନ୍‌ ବିସୟ୍ ପାର୍‍ତନା ମଣ୍ଡଲିନ୍ନିଆ ଆଅଁ ବିଃପା । ସାରାସାରି ବେଲା ମେଁ ଜଦି ମଣ୍ଡଲି ସାମୁଆଁ ଆଅଁ ଣ୍ଡୁ ତେଲା ଆମେକେ ମୁଇଙ୍ଗ୍ ଦର୍‌କାର୍ ଣ୍ଡୁନେ ମୁଇଙ୍ଗ୍ ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ତ୍ରେ ଡାଗ୍‌ଚେ ଏତେଚେ ମେଁ ଏତେ କୁଡ଼େନେ ଆନ୍ତାର୍‍ ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_18","070_18_18","MAT","18","18","18","“ଆପେକେ ଏନ୍‌ ସାମୁଆଁ ସତ୍‌ ବାସଙ୍ଗ୍‌ଚେ ବଣ୍ଡିଙ୍ଗ୍‍କେ, ପେ ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ମେଃନେ ମନା ପେଡିଙ୍ଗ୍‌ଏ କିତଂନ୍ନିଆ ଡିଗ୍ ଆତେନ୍‌ ମନା ଡିଙ୍ଗ୍‌ଏ ଆରି ଜା ସାପା ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ଆଦେସ୍‍ ପେବିଏ କିତଂନ୍ନିଆ ଡିଗ୍ ଆତେନ୍‌ ଆଦେସ୍‍ ମିଲେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT18_19","070_18_19","MAT","18","19","19","ମାତର୍‌ ଅଃତେନ୍‍ ଆଃ ଣ୍ଡୁ, ନିଂ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଦର୍‌ତନିନ୍ନିଆ ପେବାନ୍‍ ମ୍ବାୟା ମେଁ ବିସୟ୍‌ରେ ମୁଇଂ ମନ୍‍ ଡିଗ୍‍ଚେ ଆତେନ୍‌‍ସା ପାର୍‌ତନା ପେଡିଙ୍ଗ୍‌ଏ ନେଙ୍ଗ୍‌ନେ କିତଂନେ ଆବା ନାନେ ଆତେନ୍‌ ଇକ୍‌ଚା ପୁରନ୍‍ ଆଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT18_20","070_18_20","MAT","18","20","20","ଆଣ୍ଡି ଅରିଆ ମ୍ବାୟା ଣ୍ଡୁଲା ମ୍ୱାୟାବାନ୍‍ ଜବର୍ ରେମୁଆଁ ନେଙ୍ଗ୍ ମ୍ନିରେ ମୁଇଂନ୍ନିଆ ରିସିଙ୍ଗ୍‍ଲେ ଆର୍‌ଏ ନେଙ୍ଗ୍ ଆତ୍‍ ଅରିଆ ପାଙ୍ଗ୍‍ନ୍ଲେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_21","070_18_21","MAT","18","21","21","ମେସୁଆ ପିତର୍ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ସାଲିଆଁକୁକେ “ମାପ୍ରୁ ମୁଇଙ୍ଗ୍ ବୟାଁ ନେଙ୍ଗ୍ ବିରଦ୍‌ରେ ପ୍ରେଗ୍‍ ପ୍ରେଗ୍‍ ଦସ୍‍ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗେ ଆମେକେ ନିଙ୍ଗ୍‌ ଉଡ଼ିତର୍‍ କେମା ମ୍ବିଏ ? ମେଁନେ ଗୁ ତର୍‍ ଜାକ ?” ");
INSERT INTO gaq_vpl VALUES ("MT18_22","070_18_22","MAT","18","22","22","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ ଗୁ ତର୍‍ ଜାକ ଣ୍ଡୁ । ଗୁ ତର୍‌ନେ ଞ୍ଜିକୁଡ଼ି ଗୁଆ ଗୁନ୍ ଜାକ ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_23","070_18_23","MAT","18","23","23","କିତଂ ରାଜିନେ ବାରି ମୁଇଙ୍ଗ୍ ଉସ୍ରା ଅଁପା । ମେସୁଆ ମୁଇଙ୍ଗ୍ ଇଃସାଙ୍ଗ୍‌ ସ୍ଲେରେଇଂନେ ଇସାବ୍‍ପତର୍‍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ରାଜି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT18_24","070_18_24","MAT","18","24","24","ମେଁ ଏନ୍ କାମ୍ ଡିଙ୍ଗ୍‌ନେ ବେଲା ମୁଇଙ୍ଗ୍ ସ୍ଲେରେ ଇସାବ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ଇଃସାଙ୍ଗ୍‌ ଡାଗ୍ରା ଡୁଂୱେକେ । ମେଁ ମେଁବାନ୍‍ ଲାକ୍‍ ଲାକ୍‍ ଡାବୁ ରୁନ୍‍ ଡିଙ୍ଗ୍‌ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT18_25","070_18_25","MAT","18","25","25","ରୁନ୍‍ ସୁଜେନ୍‍ସା ଏନ୍‌ ରେମୁଆଁନେ ଜାବର୍ ଡାବୁ ଆଲେଗେ ଣ୍ଡୁ । ତେସା ମେଁନେ ରୁନ୍‍ ସୁଜେନ୍‍ସା ମେଁନେ ସାପା ସମ୍ପତି ସଚେଃ ଆମେକେ ମେଁନେ କୁନେଣ୍ଡେକେ ବାରି ଗଡ଼େଇଂକେ ମୁଇଂରେନ୍ନିଆ ଗତିରେ ରକମ୍ ଲେଃନ୍‌ସା ସବିଃନ୍‍ସା ଇଃସାଙ୍ଗ୍‌ ଆଦେସ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT18_26","070_18_26","MAT","18","26","26","ସ୍ଲେରେ ଇଃସାଙ୍ଗ୍‌ନେ ଞ୍ଚ ବୁନ୍ଦେ ଲଃଚେ କାକୁର୍ତି ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଆରି ଇକୁଡ଼ା ସାଆସ୍ ସାଃ ମାଲିକ୍ ନେଙ୍ଗ୍ ଆନାକେ ସାପା ରୁନ୍‍ ସୁଜେ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_27","070_18_27","MAT","18","27","27","ଇଡ଼ିଂ ଆତେନ୍‌ ଚାକର୍‌ନେ ଇଃସାଙ୍ଗ୍‌ନେ ମନ୍‌ନ୍ନିଆ ଦୟା ପାଙ୍କେ, ତେଲା ରୁନ୍‍ ବାନ୍ ନ୍‍ସୁଜେଏ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ଆରି ଆମେକେ ଆନ୍ତାର୍‌ଚେ ଲାଗ୍‌ଡକେ । ");
INSERT INTO gaq_vpl VALUES ("MT18_28","070_18_28","MAT","18","28","28","“ଏନ୍‌ ରେମୁଆଁ ଅଲେଙ୍ଗ୍ ୱେନେବେଲା ମେଁବାନ୍‍ ଇକୁଡ଼ା ଡାବୁ ରୁନ୍‍ ଡୁଙ୍ଗ୍‍ୱେବକ୍ନେ ମେଁନେ ଏତେ ସ୍ଲେରେକେ ଅବାକେ । ମେଁ ମେଁନେ ଲୁଗଃନ୍ନିଆ ସାଚେ ମେଁନେ ତୁମୁଆଃ ତାଙ୍ଗ୍‍ଡାଚେ ବାସଙ୍ଗ୍‌କେ, ନେଙ୍ଗ୍‍ବାନ୍‍ ରୁନ୍‍ ଡୁଙ୍ଗ୍‌ୱେ ନାବକ୍ନେ ଡାବୁ ଆଃଆଣ୍ଡେ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_29","070_18_29","MAT","18","29","29","ବାର୍‌ମୁଇଂ ରେମୁଆଁ ମେଁନେ ଞ୍ଚବୁନ୍ଦେ ଲଃଚେ କାକୁର୍ତି ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ସାହାସ୍ ସାଃ ସାପା ଡାବୁ ସୁଜେ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_30","070_18_30","MAT","18","30","30","ମାତର୍‌ ସିସେନେ ରେମୁଆଁ ମେଁ ସାମୁଆଁ ଆଅଁକେ ଣ୍ଡୁ ଣ୍ଡୁଲା ରୁନ୍‍ ସୁଜେନେ ଜାକ ଆମେକେ କ‍ଏଦ୍ ଡୁଆନ୍ନିଆ ବଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT18_31","070_18_31","MAT","18","31","31","ଏନ୍‌ ଗଟେକ୍ନେ କେଚେ ବିନ୍ ଚାକ୍‌ରି ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେ ଜାବର୍ ବାୟାବିକଲ୍‍ ଡିଂକେ । ମେଇଂ ଇଃସାଙ୍ଗ୍‌ନେ ଡାଗ୍ରା ୱେଚେ ମେଁ ମେଁନେ ଗଟେ ଲେଃଗେ ଆତେନ୍‌ ସାପା ଆଅଁ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT18_32","070_18_32","MAT","18","32","32","ଇଃସାଙ୍ଗ୍‌ ସେନୁଗ୍‍ ଚାକ୍‌ରି ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ୱାଚେ ବାସଙ୍ଗ୍‌କେ, “ଆରେ ଅସକ୍‌ତିଆ ଗତିରେ ନାଁ ଆନେଙ୍ଗ୍ ଗୁଆରେ ଡିଙ୍ଗ୍‍ନାବଲା ନାନେ ସାପା ରୁନ୍‍ ଡାବୁ ଆନ୍ତାର୍‍ ମ୍ବିଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT18_33","070_18_33","MAT","18","33","33","ନେଙ୍ଗ୍ ଡିରକମ୍ ନାନେ ଆଡ଼ାତ୍ରା ଲିବିସ ଣ୍ଡିଙ୍ଗ୍‍କେ ନାନେ କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ଡିଗ୍ ଦେତ୍ ରକମ୍ ଲିବିସ ଡିଙ୍ଗ୍‍ନେ ନାନେ ଦର୍‌କାର୍ । ");
INSERT INTO gaq_vpl VALUES ("MT18_34","070_18_34","MAT","18","34","34","ଇଃସାଙ୍ଗ୍‌ ଜାବର୍ ଗିସେ ଡିଙ୍ଗ୍‍ୱେଗେ ବାରି ସାପା ରୁନ୍‍ ମାସୁଜେ ଜାକ ଡଣ୍ଡ୍ ବାନ୍‌ସା ଆମେକେ କ‍ଏଦ୍ ଡୁଆନ୍ନିଆ ବେବିଆର୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT18_35","070_18_35","MAT","18","35","35","ଜିସୁ ଉଃସ୍ରା ଆଃଡାଚେ ବାସଙ୍ଗ୍‌କେ, “ପେନେ ବିରଦ୍‌ରେ ଦସ୍‍ ଡିଙ୍ଗ୍‍ବକ୍ନେ ରେମୁଆଁଇଂକେ ରୁଦୟ୍‍ନ୍ନିଆ ଜଦି କେମା ପେବି, ତେଲା ନେଙ୍ଗ୍‌ନେ କିତଂ ଲେକ୍ନେ ଆବା ଡିଗ୍ ନାନେ ଆଡ଼ାତ୍ରା ଦେକ୍‌ରକମ୍ ବେବ‍ଆର୍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_1","070_19_1","MAT","19","1","1","ଜିସୁ ଏନ୍‌ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଆଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଗାଲିଲୀ ଆନ୍ତାର୍ଚେ ଜର୍ଦନ୍‍ ଲଣ୍ଡିଆନେ ଇନୁମେତା ଲେଃକ୍ନେ ଜିଉଦା ଏରିଆ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT19_2","070_19_2","MAT","19","2","2","ଗୁଲୁଏ ମାନ୍ଦାରେ ମେଁନେ ପ୍ଲା ୱେଗେ ଆରି ମେଁ ଗୁଲୁଏ ରଗିକେ ନିମାଣ୍ଡା ଆଡିଙ୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT19_3","070_19_3","MAT","19","3","3","ଉଡ଼ିକ୍ଲିଗ୍ ଫାରୁଶୀ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ପରିକ୍ୟା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆମେକେ ସାଲ୍ୟାଃକୁଆର୍‌କେ, “ମେଃଡିଗ୍‌ କାରନ୍‌ବାନ୍‌ ନିଜର୍‌ କୁନୁଏଃକେ ଆନ୍ତାର୍‌ନେ ମେଃନେ ଟିକ୍‌ କି ?” ");
INSERT INTO gaq_vpl VALUES ("MT19_4","070_19_4","MAT","19","4","4","ଜିସୁ ଉତର୍ ବିକେ, “ସାସ୍ତର୍‌ନ୍ନିଆ ପେପଡ଼େକେ ଲେଃ ଣ୍ଡୁ, ସେନୁଗ୍‌ ତିଆର୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁକେ ଙ୍ଗିର୍‌ବଏ ବାରି ସେଲା ଆଡିଂଚେ ଆରେ ବଗେ ? ");
INSERT INTO gaq_vpl VALUES ("MT19_5","070_19_5","MAT","19","5","5","ଅଃତେନ୍‍ ବେଲା ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‍ବଗେ, ଆତେନ୍‌‍ସା ଙ୍ଗିର୍‍ବଏ ମେଁନେ ବା ଡିୟାବାନ୍ ବିନେ ଡିଙ୍ଗ୍‌ଚେ ମେଁନେ କୁନେଣ୍ଡେ ଏତେ କୁଡ଼େଏ ଆରି ମେଇଂ ମ୍ବାୟା ମୁଇଂ ଡିଙ୍ଗ୍ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT19_6","070_19_6","MAT","19","6","6","ତେସା ମେଇଙ୍ଗ୍ ଆରି ମ୍ୱାୟା ଣ୍ତୁ ମୁଇଙ୍ଗ୍‌ ଡିଙ୍ଗ୍ଆର୍‌ଏ । ଇସ୍‌ପର୍ ଜଦି ଆକେନ୍ ମ୍ୱାୟାକେ ମୁଇଙ୍ଗ୍‌ନ୍ନିଆ ଆଃଡିଙ୍ଗ୍ ବକେ, ରେମୁଆଁ ଆମେଇଂକେ ବିନେ ଆରାଡିଙ୍ଗ୍‍ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_7","070_19_7","MAT","19","7","7","ଫାରୁଶୀଇଂ ଆରି ସାଲ୍ୟାଃକୁକେ “ତେଲା ସେଲାମ୍ବୁଏକେ ଆନ୍ତାର୍‌ନେ ଉଲିଆଃ ବିଃଚେ ଆନ୍ତାର୍‍ ନ୍‍ସା ମୋଶା ମେଃନ୍‌ସା ନିୟମ୍‌ ଡିଂବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_8","070_19_8","MAT","19","8","8","ଜିସୁ ଉତର୍ ବିକେ “ପେନେ ରୁଦୟ୍‍ନେ ଗରବ୍‌ କେଚେ ମୋଶା ଦେତ୍‌ରକମ୍ ଡିଙ୍ଗ୍‍ବଗେ । ମାତର୍‌ ସିସେ ଆରେକ୍ନେ ବେଲା ଦେକ୍‌ରକମ୍ ନିୟମ୍‌ ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT19_9","070_19_9","MAT","19","9","9","ନେଙ୍ଗ୍ ଆନାକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଜେ ଜାଣ୍ଡେ ମେଁନେ କୁନେଣ୍ଡେକେ ଦଦ୍ୟା କାମ୍ ଆନ୍ତାର୍ଚେ ବିନ୍ ମେଃଡିଗ୍ ଆନ୍ତାର୍‍ବିଚେ ବିନ୍ ସେଲାମ୍ବୁଏଃକେ ବିହେ ଡିଙ୍ଗ୍‌ଏ, ମେଁ ନିଜେ ଅଡ଼ାରେଗ୍‌ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_10","070_19_10","MAT","19","10","10","ଜିସୁନେ ସିସ୍‍ଇଂ ବାସଙ୍ଗ୍‌କେ, “ଜଦି କୁନେ ଆଣ୍ଡା ବିତ୍ରେ ଜଦି ଦେକ୍‌ରକମ୍ ଗୁନ୍‍ ଲେଃଏ ତେଲା ବିହେ ଆଡିଙ୍ଗ୍‌ନେ ବଲ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_11","070_19_11","MAT","19","11","11","ଜିସୁ ଉତର୍ ବିକେ, “ଏନ୍‌ ସିକ୍ୟା ସାପାରେ ନ୍‍ସା ଣ୍ଡୁ । ଇସ୍‌ପର୍‌ବାନ୍ ଜାନ୍‍ସା ଏନ୍‌ ସାପା ଆର୍ମେ ଆଡିଙ୍ଗ୍‍ବକେ ମାତର୍‌ ମେଇଂଆ ଏନ୍‌ ବାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT19_12","070_19_12","MAT","19","12","12","ମେଁ ମେଃନ୍‌ସା ରେମୁଆଁ ବିହେ ଆଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେ ଲେଃଏ । ଉଡ଼ିରୁଆ ଜନମ୍‌ବାନ୍ ଆଃ ବିହେ ଡିଙ୍ଗ୍‍ନେସା ରାଜି ଲେଃଏ ଉଡ଼ିରୁଆକେ ରେମୁଆଁଇଂ ଦେତ୍‌ରକମ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଆରି ଉଡ଼ିରୁଆ କିତଂଇନି ନ୍‌ସା ସ୍ଲେନ୍‍ସା ବିହେ ମାଡିଙ୍ଗ୍‌ଚେ ଲେଃଆର୍‍ଏ । ଜାଣ୍ଡେଇଂ ଏନ୍‌ ସିକ୍ୟା ସାମୁଆଁ ବୁଜେ ୟାଡିଙ୍ଗ୍‍ ମେଇଂ ଆତେନ୍‌ ସାଃଆର୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_13","070_19_13","MAT","19","13","13","ଗଡ଼େଇଂନେ ଆଡ଼ାତ୍ରା ନ୍ତି ବଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଉଡ଼ି ରେମୁଆଁ ଆମେଇଂକେ ଜିସୁନେ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍ଆର୍‌କେ । ଆତେନ୍‌ ରେମୁଆଁଇଂକେ ସିସ୍‍ଇଂ ୱିଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT19_14","070_19_14","MAT","19","14","14","ମାତର୍‌ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଗଡ଼େଇଙ୍କେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ନେ ବିଃପା । ଆମେଇଂକେ ମନା ଆଡିଙ୍ଗ୍‌ପା । ଡାଗ୍ଲା କିତଂ ରାଇଜ୍ ମେଁଇଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_15","070_19_15","MAT","19","15","15","ଡାଗ୍ଲା ଜିସୁ ମେଁଇଂନେ ଆଡ଼ାତ୍ରା ନ୍ତି ବଚେ ଆସିର୍ବାଦ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଆତ୍‍ ବାନ୍ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT19_16","070_19_16","MAT","19","16","16","ମେସୁଆ ମୁଇଙ୍ଗ୍ ଙ୍ଗିରେ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାକୁକେ “ଗୁରୁ ! ମାଡାନେ ଜିବନ୍ ବାନ୍‌ସା ମେଃନେ ନିମାଣ୍ଡା କାମ୍ ଡିଙ୍ଗ୍‌ଲା ଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MT19_17","070_19_17","MAT","19","17","17","ଜିସୁ ଉତର୍ ବିକେ, “ନିମାଣ୍ଡା କାମ୍ ବିସୟ୍‌ରେ ଆନେଙ୍ଗ୍‌କେ ମେଁନ୍‌ସା ସାଲ୍ୟାକୁ ନାଡିଙ୍ଗ୍‍ ? ଇସ୍‌ପର୍ ଆଃ ସତ୍ । ତେଲା ଇସ୍‌ପର୍‌ନେ ଆଦେସ୍‌ ସାପା ପାଲେଲା ଅଃନା ଆଡାକ୍ନେ ଜିବନ୍ ନାବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_18","070_19_18","MAT","19","18","18","ମେଁ ସାଲ୍ୟାକୁକେ “ମେଃନେ ସାପା ଆଦେସ୍ ?” ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ରେମୁଆଁକେ ଆବାଗୁଏଃଗେ, ଅଡ଼ାରେଗ୍‌ ଆଡିଂଗେ । ଆଡଙ୍ଗାଗେ, ମୁଇଂଜାନେ ବିରଦ୍‌ରେ ମିଚ୍ ଆବାସଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT19_19","070_19_19","MAT","19","19","19","ଆବା ଇୟାଙ୍ଗ୍‌କେ ସନ୍‍ମାନ୍‍ ବିଃ ବାରି ପେନେ ଆଃଡ଼ାଃ ଡୁଆଣ୍ଡ୍ରେକେ ପାରାନ୍ ସୁଗା ଆଲାଦ୍ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_20","070_19_20","MAT","19","20","20","ଙ୍ଗିରେ ଜିସୁକେ ଉତର୍ ବିକେ “ଏନ୍‌ ସାପା ଆଦେସ୍‌ ନେଙ୍ଗ୍ ପାଲେଣ୍ଡିଂକେ । ଆରି ନେଙ୍ଗ୍‌ନେ ମେଃନେ ଗଣ୍ଡାଃ ଲେଃକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT19_21","070_19_21","MAT","19","21","21","ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ “ଜଦି ନାଁ ନିର୍ମଲ୍‍ ଡିଙ୍ଗ୍‌ନେ ଚାଏଁ ନାଡିଙ୍ଗ୍‍କେ, ୱେଲା, ନାନେ ସାପା ସମ୍ପତି ସ ବିଚେ ଆତେନ୍‌ ଡାବୁ ଗରିବ୍‍ ରେମୁଆଁଇଂକେ ବାଟାବି । ତେଲା ନାନେ କିତଂନ୍ନିଆ ଦନ୍ ନାବାଏ । ଏନ୍‌ ସାପା ଡିଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_22","070_19_22","MAT","19","22","22","ଙ୍ଗିରେ ଏନ୍‌ ସାମୁଆଁ ଅଁଚେ ଗିସେଚେ ୱିଗ୍‌ଗେ, ମେଁନ୍‌ସା ଡାଗ୍ଲା ମେଁନେ ମାଲେ ସମ୍ପତି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT19_23","070_19_23","MAT","19","23","23","ଜିସୁ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାବ୍‌ରେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ସାଉକାର୍‌ ରେମୁଆଁଇଂ କିତଂ ରାଜିନ୍ନିଆ ୱେନେସା ଉଡ଼ି କସ୍ଟ । ");
INSERT INTO gaq_vpl VALUES ("MT19_24","070_19_24","MAT","19","24","24","ବାରି ମୁଇଂତର୍ ବାସଙ୍ଗ୍‌ବଣ୍ଡିଂ, ସୁଜି ପ୍ଲଗ୍‌ବିଚେ ଉଟ୍‌ ଗାନେ ବାଟା ସାଉକାର୍‌ ରେମୁଆଁ କିତଂ ରାଇଜ୍ ଗିଃଗାଃନେ ଜାବର୍‌ କଷ୍ଟ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_25","070_19_25","MAT","19","25","25","ସିସ୍‍ଇଂ ଏନ୍‌ ଅଁଚେ ବୁଟଚେ ସାଲିଆକୁକେ “ତେଲା ଜା ତେଲା ଜାଣ୍ଡେ ଉଦାର୍ ବା ୟାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MT19_26","070_19_26","MAT","19","26","26","ଜିସୁ ଆମେଇଂକେ ମୁଇଂ ମୁଆଃରେ କେଚେ ବାସଙ୍ଗ୍‌କେ “ରେମୁଆଁଇଂ ନ୍‌ସା ଆକେନ୍ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ଡୁ ମାତର୍‌ ଇସ୍‌ପର୍‌ବାନ୍ ଆକେନ୍ ସାପା ଡିଙ୍ଗ୍‍ୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT19_27","070_19_27","MAT","19","27","27","ଏନ୍‌ ଅଁଚେ ପିତର୍ ବାସଙ୍ଗ୍‌କେ, “କେଲାପା ନେ ସାପା ଆନ୍ତାର୍ଚେ ନାଁ ପ୍ଲା ପାଙ୍ଗ୍‍ନେଡିଙ୍ଗ୍‍କେ । ତେଲା ନେଁ ମେଃନେ ନେବାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MT19_28","070_19_28","MAT","19","28","28","ଜିସୁ ଉତର୍ ବିକେ “ଏନ୍‌ ସାମୁଆଁ ସତ୍ ଡାଗ୍‌ଚେ ପେମ୍ୟାଏ ତ୍ମି ଜୁଗ୍‍ନ୍ନିଆ ଉଡ଼ିବେଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ମେଁନେ ଗୌରବ୍ ତାର୍କିଗ୍‌ ସିଂଆସନନ୍ନିଆ କ‍ଏ ଅଃତେନ୍‍ ବେଲା ନେଙ୍ଗ୍‌ନେ ଏନ୍‌ ଗମ୍ବାର୍ ସିସ୍‍ ଡିଗ୍ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସିଂଆସନନ୍ନିଆ କଚେ ଇଶ୍ରାୟେଲନେ ଗମ୍ବାର୍‌ କ୍ଲିଗ୍ ଜାତି ଆଡ଼ାତ୍ରା ସାସନ୍‌ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT19_29","070_19_29","MAT","19","29","29","ଜାଣ୍ଡେଇଂ ନେଙ୍ଗ୍‍ନେ ମ୍ନି ନ୍‌ସା ନିଜେନେ ଡୁଆ, ବୟାଁଣ୍ଡେ, ତନାଣ୍ଡେ, ଆବା, ଇୟାଙ୍ଗ୍, ଗୋ ଗିସିଆ ଆରି ଲିଜ ବ୍ରି ଆନ୍ତାର୍‍ ବଆର୍‌କେ ମେଇଂ ମେଁନେ ମାଲ୍‍କୁଡ଼ି ଗୁନ୍ ବାଏ; ବାରି ଅଃନା ଆଡାକ୍ନେ ଜିବନ୍ ଡିଗ୍ ବାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT19_30","070_19_30","MAT","19","30","30","ଏବେ ଜାଣ୍ଡେଇଂ ସେନୁଗ୍ ଲେଃଆର୍‌କେ ମେଇଂନେବାନ୍‍ ଗୁଲେରୁଆ ପ୍ଲା ଲେଃଆର୍‌ଏ ଆରି ଜାଣ୍ଡେଇଂ ପ୍ଲା ଲେଃଆର୍‌କେ ମେଇଂବାନ୍‍ ଗୁଲେରୁଆ ସିସେ ୱେଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_1","070_20_1","MAT","20","1","1","“କିତଂଇନି ଦେକ୍ ରକମ୍ ମେସୁଆ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଞ୍ଜିର୍‌ନୁଗ୍ ତଡ଼ିଆଚେ ମେଁନେ ଅଙ୍ଗୁର୍ ଲିଜନ୍ନିଆ ସ୍ଲେନ୍‍ସା ସ୍ଲେରେକେ ତୁର୍‍ନେ ତାର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_2","070_20_2","MAT","20","2","2","ଆଜାକେ ଅବାକେ ସାପାରେକେ ମେଃସୁଆ ନ୍‍ସା ମୁଇଂ ଲାଃକା ରୁପା ଡାବୁ ଆଜ୍‌ରି ମ୍ବିଏ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ମେଁ ଲିଜନ୍ନିଆ ବେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_3","070_20_3","MAT","20","3","3","ତେନ୍‌ ଇଡ଼ିଂ ସ୍ମି ନଟା ବେଲା ସାନ୍ତା ୱେଚେ କେକେ ମାନ୍ଦାରେ ମେଃଡିଗ୍ କାମ୍ ମାଡିଙ୍ଗ୍‌ଚେ ତୁଆଁ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_4","070_20_4","MAT","20","4","4","ଆମେଇଂକେ ମେଁ ବାସଙ୍ଗ୍‌କେ, ପେଡିଗ୍ ନେଙ୍ଗ୍ ଅଙ୍ଗୁର୍ ଲିଜନ୍ନିଆ ୱେଚେ ସ୍ଲେପା, ବାରି ମେଃନେ ନିମାଣ୍ଡାଃ, ଆତେନ୍‌ ଆପେକେ ମେଃନେ ଇକ୍‌ଚା ଆତେନ୍‌ ଆଜ୍‌ରି ନେଙ୍ଗ୍ ମ୍ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT20_5","070_20_5","MAT","20","5","5","ମେଇଂ ୱେଚେ ସ୍ଲେ ଆର୍‌କେ । ବାରି ସ୍ମି ବାର୍‍ଟା ଆରି ତିନ୍‌ଟା ବେଲା ଟିକ୍ ଦେତ୍‌ରକମ୍ ଆଃ ଆରି ଉଡ଼ି ସ୍ଲେରେକେ ଡୁଂପାଙ୍ଗ୍‍ଚେ ଆସ୍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_6","070_20_6","MAT","20","6","6","ସ୍ମି ପାଞ୍ଚ୍‍ଟା ବେଲା ବାର୍‌ମୁଇଂତର୍‍ ସାନ୍ତା ୱେଚେ କେକେ ଆରି ଉଡ଼ିରୁଆ ତୁଆଁଲେ ଆର୍‌ଗେ । ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ ସ୍ମିଜାକ ମାସ୍ଲେଚେ ମେଁନ୍‌ସା ଆକ୍‌ଅରିଆ ସରା ଗଣ୍ଟା ବେକାର୍‍ ଆଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ? ");
INSERT INTO gaq_vpl VALUES ("MT20_7","070_20_7","MAT","20","7","7","ମେଇଂ ଉତର୍ ବିକେ, ଜା ଡିଗ୍ ଆନେକେ ସ୍ଲେନ୍ନିଆ ଆରାଃକୁଡ଼େ ଆର୍‌କେ ଣ୍ଡୁ । ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ତେଲା ପେ ସାପାରେ ନେଙ୍ଗ୍‌ନେ ଅଙ୍ଗୁର୍ ଲିଜନ୍ନିଆ ୱେଚେ ସ୍ଲେପା । ");
INSERT INTO gaq_vpl VALUES ("MT20_8","070_20_8","MAT","20","8","8","“ଆତେନ୍‌ ଦିନା ଲମ୍‌ଡିଗ୍‍ କେଲା ଲିଜ ସାଉକାର୍ ଗୁମୁସ୍ତାକେ ବାସଙ୍ଗ୍‌କେ ସ୍ଲେରେକେ ୱା । ଜାଣ୍ଡେଇଂ ସାପାରେ ବାନ୍‍ ଇଡ଼ିଙ୍ଗ୍ ସ୍ଲେ ମୁଲେବଆର୍‌କେ ସେନୁଗ୍‍ ମେଇଂନେ ଆଜ୍‌ରି ଡାବୁ ବିଃ । ଜାଣ୍ଡେଇଂ ସ୍ଲେନ୍ନିଆ ପର୍‍ତୁମ୍‍ ୱେଲେଆର୍‌ଗେ ମେଁଇଙ୍ଗ୍‌ନେ ଆଜ୍‌ରି ଇଡ଼ିଙ୍ଗ୍ ବାଟା ବିଃ । ");
INSERT INTO gaq_vpl VALUES ("MT20_9","070_20_9","MAT","20","9","9","ସ୍ମି ପାଞ୍ଚ୍‍ଟା ବେଲା ଜାଣ୍ଡେଇଂ ସ୍ଲେନ୍ନିଆ ୱେଲେ ଆର୍‌ଗେ ମେଇଂ ସାପାରେ ମୁଇଂ ମୁଇଂ ରୁପା ଡାବୁ ବାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_10","070_20_10","MAT","20","10","10","ଜାଣ୍ଡେଇଂ ସେନୁଗ୍‍ ସ୍ଲେ ମୁଲେ ବଆର୍‌ଗେ ମେଇଂ ବାବେକେ ଜେ ଆମେଇଂକେ ଜବର୍ ଆଜ୍‌ରି ମିଲେଏ । ମାତର୍‌ ମେଁଇଙ୍ଗ୍‌ ଡିଗ୍ ମୁଇଙ୍ଗ୍ ମୁଇଂ ଆଃ ରୁପା ଡାବୁ ବାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_11","070_20_11","MAT","20","11","11","ମେଇଂ ଆକେନ୍ ସାପା ସାମୁଆଁ ଡୁଂୱେଚେ ସାଉକାର୍ ବିରଦ୍‌ରେ ଦାବି ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT20_12","070_20_12","MAT","20","12","12","ଲମ୍‌ଡିଗ୍‌ ପାଞ୍ଚ୍‍ଟା ବେଲା ସ୍ଲେ ଆରାମ୍‍ ଡିଙ୍ଗ୍ ବକ୍ନେ ସ୍ଲେରେଇଂ ମାତର୍‌ ମୁଇଙ୍ଗ୍ ଗଣ୍ଟା ଆଃ ସ୍ଲେ ବଆର୍‌ଗେ । ମାତର୍‌ ନେନେ ଅଃତେନ୍‍ ନାସେଙ୍ଗ୍‍ ଡାଗ୍ରା ଞ୍ଜିର୍‍ବାନ୍‍ ଲମ୍‍ଡିଗ୍‍ ଜାକ ନେସ୍ଲେକେ ତେଲାଡିଗ୍‍ ଆଜ୍‌ରି ବିଃ କେଲା ଆମେଇଂକେ ନେନେ ଏତେ ସମାନ୍ ଆଃଡିଙ୍ଗ୍‌ଚେ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_13","070_20_13","MAT","20","13","13","ସାଉକାର୍ ମେଁଇଙ୍ଗ୍‌ନେ ବିତ୍ରେବାନ୍ ମୁଇଂଜାକେ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ ବୟାଁ ! ନେଙ୍ଗ୍ ଆନାକେ ନ୍ନାଜଟେକେ ଣ୍ଡୁ ମେସୁଆ ସ୍ଲେକ୍ନେ ଆଜ୍‌ରି ନ୍‌ସା ମୁଇଙ୍ଗ୍ ଡାବୁ ଡୁଂୱେଚେ ସ୍ଲେନ୍‍ସା ପେ ସାପାରେ ତ ରାଜି ଡିଙ୍ଗ୍‍ପେଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_14","070_20_14","MAT","20","14","14","ପେନେ ଆତେନ୍‌ ଆଜ୍‌ରି ସାଚେ ଡୁଆ ୱିଗ୍‌ଲାପା । ଆପେକେ ଉଡ଼ି ବିମ୍ୱକେ ମୁଇଂଗଣ୍ଟା ସ୍ଲେ ଡିଙ୍ଗ୍‍ବକ୍ନେ ରେମୁଆଁ ଡିଗ୍ ଅଃତେନ୍‍ ଆଃ ବିଃନ୍‍ସା ନେଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା । ");
INSERT INTO gaq_vpl VALUES ("MT20_15","070_20_15","MAT","20","15","15","ନେଙ୍ଗ୍ ନିଜେନେ ଦନ୍ ଡିରକମ୍ ଇକ୍‌ଚା ଦେତ୍‌ରକମ୍ କର୍ଚ ଡିଙ୍ଗ୍‌ନେ ମେଃନେ ନେଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଣ୍ଡୁ ? ଲେଃ ନେଙ୍ଗ୍ ସରା ଦାନ୍ ବିଣ୍ଡିଂକେ ଡାଗ୍‌ଚେ ନାଁ କୁଟ୍ କେନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT20_16","070_20_16","MAT","20","16","16","ଆକେନ୍ ଉଃସ୍ରା ସାମୁଆଁ ଆଃଡାଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଜାଣ୍ଡେଇଂ ଏବେ ପ୍ଲା ଲେଃଆର୍‌କେ ମେଇଂ ସେନୁଗ୍‍ ପାଙ୍ଗ୍‌ଆର୍‌ଏ ଆରି ଜାଣ୍ଡେଇଂ ସେନୁଗ୍‍ ଲେଃଆର୍‌କେ ମେଇଂ ପ୍ଲା ଲେଃୱେଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_17","070_20_17","MAT","20","17","17","ଜିସୁ ଯିରୂଶାଲମ୍‌ ଡାଗ୍ରା ୱେନେ ଗାଲିନିୟା ଗମ୍ବାର୍ ସିସ୍‍କେ ମୁଇଂତୁଗ୍ ୱା ଡୁଂୱେଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT20_18","070_20_18","MAT","20","18","18","“ଅଁପା ନେନେ ଯିରୂଶାଲାମ୍‌ପାକା ୱେନେଡିଙ୍ଗ୍‌କେ । ଆତ୍‌ଅରିଆ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ମ୍ନା ପୁଜାରି ଆରି ଦରମ୍ ଗୁରୁନେ ନ୍ତିନିଆ ଅପେଃ ବିଆର୍‌ଏ । ମେଇଂ ଆମେକେ ଗୁଏନେ ଡଣ୍ଡ୍‍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT20_19","070_20_19","MAT","20","19","19","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ ଅଣଜିଉଦି‍ଇଂନେ ନ୍ତିନିଆ ଆନ୍ତାର୍‍ ବିଏ । ଅଣଜିଉଦିଇଂ ଆମେକେ ଆଃଗିଆସଃ ଆର୍‌ଏ ଆରି ଚାବୁକ୍‍ ଏତେ ଆଃବଗ୍‍ ଆର୍‌ଏ ଆରି କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ଆଡେ ଆର୍‌ଏ ମାତର୍‌ ଜିର୍‌ସି ବିତ୍ରେ ମେଁ ମ୍ବ୍ରଚେ ତଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_20","070_20_20","MAT","20","20","20","ଆତେନ୍‌‌ ବେଲା ଜେବଦୀ କୁନେଡ଼େନେ ମ୍ୱାୟା ଉଙ୍ଗ୍‌ଡେ ଏତେ ମେଁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଆମେକେ ସାର୍ଲଚେ ମେଁନେ ଦୟା ବିକ୍ୟା ସାଲ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_21","070_20_21","MAT","20","21","21","ଜିସୁ ଆମେକେ ସାଲ୍ୟାକୁକେ, “ମେଁନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ?” ମେଁ ବାସଙ୍ଗ୍‌କେ “ନାଁ ଅଃନା ବେଲା ଇଃସାଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌‌ ବେଲା ଆକେନ୍ ନେଙ୍ଗ୍‌ନେ ମ୍ୱାକ୍ଲିଗ୍‍ ନେଉଂକେ ମୁଇଙ୍ଗ୍‌ଜା ନାଁନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା ଆରି ମୁଇଂଜା ବେସ୍ୟା ନ୍ତି ପାକା ନାରାକଏ ଡାଗ୍‌ଚେ ସାମୁଆଁ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_22","070_20_22","MAT","20","22","22","ଜିସୁ ଜେବଦିନେ ମ୍ୱାୟା ଉଙ୍ଗ୍‌ଡେଇଂକେ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ନାଁ ମେଃନେ ସାଲ୍ୟାନାଡିଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ବୁଜେ ନାଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ନେଙ୍ଗ୍ ଆଣ୍ଡିନେ ଦୁକ୍ ବଗେନେ ଙ୍କୁଇବାନ୍‍ ଉଗ୍‍ନେ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ପେ ମେଁନେ ଆତ୍‌ବାନ୍ ଉଗ୍ ପେୟାଏ ? ମେଇଂ ଉତର୍ ବିଃଆର୍‌କେ, ଆଁ, ନେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_23","070_20_23","MAT","20","23","23","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ସତେଆ ପେ ନେଙ୍ଗ୍‌ନେ ଆତେନ୍‌ ଉଗ୍‍ନେ ଙ୍କୁଇବାନ୍‍ ପେଉଗ୍‌ଏ । ମାତର୍‌ ନେଙ୍ଗ୍‌ନେ ଞ୍ଚଙ୍ଗ୍‌ତି ଆରି ବେସ୍ୟାତି କୁକ ନ୍‍ସା ଆଜାକେ ଡିଗ୍ ସ୍ରିନେ ନେଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଣ୍ଡୁ । ଜା ଆତ୍‍ଲା ନେଙ୍ଗ୍‌ନେ ଆବା ଆତେନ୍‌ ଜାଗା ଆରେବକେ ଆତେନ୍‌ ମାତର୍‌ ମେଇଂନେଆ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_24","070_20_24","MAT","20","24","24","ବିନ୍ ଗୁଆ ରେମୁଆଁ ସିସ୍ ଆକେନ୍‌ ଅଁଚେ ଆତେନ୍‌‌ ବମୟାଁନେ ଆଡ଼ାତ୍ରା ରିସା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_25","070_20_25","MAT","20","25","25","ଜିସୁ ସିସ୍ଇଂକେ ମୁଇଂତୁଗ୍ ୱାଚେ ବାସଙ୍ଗ୍‌କେ “ପେ ମ୍ୟା ପେଲେକେ ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଇଃସାଙ୍ଗ୍‌ଇଂ ବିଜାତି ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ମାପ୍ରୁ ରକମ୍ ବଡ଼୍‌ପନ୍ ଆଃସୁଏଃଏ ଆରି ମ୍ନା ମ୍ନା ନେତାଇଂ ଡିଗ୍‍ ବିନ୍ ରେମୁଆଁ ଆଡ଼ାତ୍ରା ସାସନ୍‍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT20_26","070_20_26","MAT","20","26","26","ମାତର୍‌ ପେ ଏନ୍‌ ନିୟମ୍‌ ତୁର୍ ପେଅଲେଙ୍ଗ୍ ଣ୍ଡୁ । ପେ ବିତ୍ରେବାନ୍ ଜାଣ୍ଡେ ମ୍ନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ରାଜି ଡିଙ୍ଗ୍‌ଏ; ମେଁ ବିନ୍‍ରେନେ ସେବାକାମ୍‍ ଡିଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_27","070_20_27","MAT","20","27","27","ପେ ବିତ୍ରେ ବାନ୍ ଜାଣ୍ଡେ ସାପାବାନ୍‍ ମ୍ନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ, ମେଁ ପେନେ ଚାକର୍ ଡିଙ୍ଗ୍‌ଲେ ");
INSERT INTO gaq_vpl VALUES ("MT20_28","070_20_28","MAT","20","28","28","ଡିରକମ୍ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ସେବା ବାନ୍‌ସା ଆପାଙ୍ଗ୍‍କେ ଣ୍ଡୁ, ସେବା ଡିଙ୍ଗ୍‌ଚେ ବିନ୍‍ରେ ମୁକ୍ତି ବାନ୍‌ସା ନିଜର୍‌ ଜିବନ୍‍ ବିଃନ୍‍ସା ପାଙ୍ଗ୍‌ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_29","070_20_29","MAT","20","29","29","ମୁଇଙ୍ଗ୍ ଦିନା ଜିସୁ ସିସ୍‍ଇଂ ଏତେ ଯିରୀହୋ ଇନି ଆନ୍‌ତାର୍‌ ୱେନେ ବେଲା ଗୁଲୁଏ ରେମୁଆଁ ମେଁନେ ପ୍ଲା ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT20_30","070_20_30","MAT","20","30","30","ଗାଲି ଆଡ଼ା କଲେଃକ୍ନେ ମ୍ୱାୟା କାନା ଜିସୁ ଆତେନ୍‌ ଗାଲି ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ଅଁଚେ ୱାସାର୍‌ଚେ ୱାକେ, “ଏ ମାପ୍‌ରୁ, ଦାଉଦ୍ ଉଙ୍ଗ୍‌ଡେ, ଆନେକେ ଦୟା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_31","070_20_31","MAT","20","31","31","ରେମୁଆଁଗଣ୍ଡ୍ ଆମେଇଂକେ ଦମକ୍‍ ବିଚେ ବୁଙ୍ଗ୍‍ଲେଃ ନ୍‍ସା ବାସଙ୍ଗ୍‌କେ । ମାତର୍‌ ମେଇଂ ଆରି ଅଃଗିଆଚେ ବାସଙ୍ଗ୍‌କେ ଏ ମାପ୍‍ରୁ “ଦାଉଦ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ! ଆନେକେ ଦୟା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_32","070_20_32","MAT","20","32","32","ଜିସୁ ଆତ୍‌ଅରିଆ ତୁଆଁଚେ ଆମେଇଂକେ ୱାଚେ ସାଲ୍ୟାକୁକେ “ନେଙ୍ଗ୍ ପେନ୍‌ସା ମେଁ ଣ୍ଡିଙ୍ଗ୍‍ଏ ଡାଗ୍‌ଚେ ରାଜି ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT20_33","070_20_33","MAT","20","33","33","ମେଇଂ ବାସଙ୍ଗ୍‌କେ “ଏ ମାପ୍ରୁ ଆନେକେ ମୁଆଃ କିକେନେ ବପୁ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT20_34","070_20_34","MAT","20","34","34","ଜିସୁ ଦୟା ଆସୁଏଚେ ମେଁଇଙ୍ଗ୍‌ନେ ମୁଆଃକେ ଲିଗ୍‌କ୍ନେ ଦାପ୍ରେ ଦାପ୍ରେ ମେଁଇଙ୍ଗ୍‌ନେ ମୁଆଃ କିକେନେ ବପୁ ବାଆର୍‌କେ ବାରି ଜିସୁନେ ପ୍ଲା ଅଲେଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_1","070_21_1","MAT","21","1","1","ଜିସୁ ଆରି ମେଁନେ ସିସ୍‍ଇଂ ଯିରୂଶାଲମ୍‌ନେ ବେଥ୍‌ଫାଗୀ ଇନିବାନ୍ ଇତୁଡ଼ା ସ୍ଲ ଲେଃକ୍ନେ ଜିତ କଣ୍ଡା ଡାଗ୍ରା ୱେଚା ଆର୍‌କେ । ଜିସୁ ମ୍ୱାୟା ସିସ୍‍କେ ଆଦେସ୍‍ ବିଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT21_2","070_21_2","MAT","21","2","2","“ତ୍ନା ଡିଙ୍ଗ୍‌କ୍ନେ ଆତେନ୍‌ ଇନିନିଆ ୱେଲାପା । ଆତ୍‌ଅରିଆ ୱେଚାକ୍ନେ ଦାପ୍ରେ ମୁଇଙ୍ଗ୍ ଗଦକେ ଗାଗ୍‍ବକ୍ନେ ପେକେଏ ଆରି ମେଁ ଏତେ ମେଁନେ ଉଙ୍ଗ୍‌ଡେ ଡିଗ୍ ଲେଃଏ ଆମେକେ ତୁପିଗ୍‍ଚେ ନେଙ୍ଗ୍‍ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT21_3","070_21_3","MAT","21","3","3","ଜା ମେଁ ଡିଗ୍ ସାଲ୍ୟାକୁଲା ପେବାସଙ୍ଗ୍‌ଏ, ଆକ୍‌ମେନ୍ନିଆ ମାପ୍ରୁନେ ଦର୍‌କାର୍ ଲେଃକେ । ତେଲା ଦାପ୍ରେ ଦାପ୍ରେ ମେଁ ଆମେଇଂକେ ଆନ୍‍ତାର୍‍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_4","070_21_4","MAT","21","4","4","ଆକେନ୍ ଗଟ୍‍ନାବାନ୍‍ ବାବବାଦି ଗୁଆର୍‍କ୍ନେ ସାମୁଆଁ ପୁରନ୍‌ ଡିଙ୍ଗ୍‌କେ; ");
INSERT INTO gaq_vpl VALUES ("MT21_5","070_21_5","MAT","21","5","5","“ସିୟନ ଟାଉନ୍‍କେ ବାସଙ୍ଗ୍‌ ! କେଲା, ପେନେ ଇଃସାଙ୍ଗ୍‌ ପେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ; ମେଁ ଦରମ୍ ଗଦ ଉଙ୍ଗ୍‌ଡେନେ ଗୁଗ୍‍ଡିଆନ୍ନିଆ କଲେଃକେ; କେଲା ମେଁ ଗଦ ଆଡ଼ାତ୍ରା କଚେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_6","070_21_6","MAT","21","6","6","ସିସ୍‍ଇଂ ୱେଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କ୍ନେ ଇସାବ୍‌ରେ କାମ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_7","070_21_7","MAT","21","7","7","ଗଦ ଆରି ମେଁନେ ଡାଗ୍ରା ଉଙ୍ଗ୍‌ଡେକେ ଡୁଂପାଙ୍ଗ୍‍ଚେ ମେଁଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ନିଜର୍ ନିଜର୍‌ନେ ସଃଲେକ୍ନେ ସକା ତ୍ଲାଗ୍‍ ବିଃଆର୍‌କେ ବାରି ଜିସୁ ମେଁ ଆଡ଼ାତ୍ରା କକେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_8","070_21_8","MAT","21","8","8","ଆତ୍‌ଅରିଆ ତୁଆଁଲେଃକ୍ନେ ରେମୁଆଁଇଂ ଜିସୁ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ଗାଲି ଆଡ଼ାତ୍ରା ନିଜର୍ ନିଜର୍‌ନେ ପାଟାଇ ବେବିଃଆର୍‌କେ ଆରି ଲିଜ ଡାଗ୍ରାନେ ପାଡ଼ୁ ସିଃ ଡୁଂପାଙ୍ଗ୍‌ଚେ ଜିସୁ ୱେନେ ଗାଲି ଆଡ଼ାତ୍ରା ତ୍ଲାଗ୍‍ ବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_9","070_21_9","MAT","21","9","9","ଜିସୁନେ ସିସେ ଆରି ଇଡ଼ିଙ୍ଗ୍ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂ ୱାସାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଦାଉଦ୍‍ ଉଙ୍ଗ୍‌ଡେନେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‌ପା ଜାଣ୍ଡେଇଂ ମାପ୍ରୁନେ ମ୍ନିରେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଇସ୍‌ପର୍ ଆମେଇଂକେ ଆସିର୍ବାଦ୍ ଡିଙ୍ଗ୍‌ଲେ । ଇସ୍‌ପର୍‌ନେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_10","070_21_10","MAT","21","10","10","ଜିସୁ ଯିରୂଶାଲମନ୍ନିଆ ୱେଚାକ୍ନେ ଦାପ୍ରେ ଆତ୍‌ଅରିଆ ଉଡ୍ରା ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_11","070_21_11","MAT","21","11","11","ରେମୁଆଁଇଂ ସାଲ୍ୟାକୁକେ “ମେଁ ଜାଣ୍ଡେ ?” ବିନ୍‍ରେ ଉତର୍ ବିକେ “ମେଁ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଗାଲିଲୀ ଡାଗ୍ରାନେ ନାଜରିତିୟ ବାବବାଦି ଜିସୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_12","070_21_12","MAT","21","12","12","ଜିସୁ ମନ୍ଦିର୍‍ ବିତ୍ରେ ଗାଚେ ଆତ୍‌ଅରିଆ ଡାବୁ ବିଆର୍ ସ ଡିଙ୍ଗ୍‍ମ୍ୟାକ୍ନେ ରେମୁଆଁଇଂନେ ଟିବୁଲ୍ ଆରି କୁକୁର୍‌ୟାଃ ବେପାର୍‍ ଡିଙ୍ଗ୍‍ମ୍ୟାକ୍ନେ ରେମୁଆଁଇଂନେ କୁର୍‌ଚି ଆପ୍ଲେଗ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_13","070_21_13","MAT","21","13","13","ଆମେଇଂକେ ମେଁ ବାସଙ୍ଗ୍‌କେ “ଦରମ୍ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ ବକେ ସାମୁଆଁ ନେଙ୍ଗ୍‌ନେ ମନ୍ଦିର୍‍ ପାର୍‍ତନା ଡୁଆ ଡାଗ୍‌ଚେ ସାପାରେ ମ୍ୟା ଆର୍‌ଏ ମାତର୍‌ ପେ ଆମେକେ ଡଙ୍ଗାରେ ଲେଃକ୍ନେ ଡୁଆ ସୁଗା ଆଡିଙ୍ଗ୍ ପେବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_14","070_21_14","MAT","21","14","14","ଜିସୁ ମନ୍ଦିର୍‌ନ୍ନିଆ ଲେଃକେଲା କାନା ଆରି ଚଟାମେଟାଇଂ ମେଁଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌କେ ଆରି ଜିସୁ ଆମେଇଂକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_15","070_21_15","MAT","21","15","15","ମ୍ନା ଜାଜକ୍‍ ଆରି ଦରମ୍ ଗୁରୁଇଂ ମେଁନେ କାବା ରକମ୍ କାମ୍ କେଚେ ବାରି ମନ୍ଦିର୍ ବିତ୍ରେ ଗଡ଼େଅଇଂ ଦାଉଦ୍‍ ଉଙ୍ଗ୍‌ଡେନେ ଜୟ୍‍ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ଅଁଚେ ଗିସେ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_16","070_21_16","MAT","21","16","16","ମେଇଂ ଜିସୁକେ ସାଲ୍ୟାକୁକେ “କିମେଇଂ ମେଃନେ ବାସଙ୍ଗ୍‌ଡିଂଆର୍‌କେ, ଆତେନ୍‌‌ ସାମୁଆଁ ନାଁ ଅଁନାଡିଙ୍ଗ୍‌କେ ?” ଜିସୁ ଉତର୍ ବିକେ “ଡିଲାଡିଗ୍‌ ନେଙ୍ଗ୍ ଅଁ ନ୍ଲେକେ । ଦରମ୍ ସାସ୍ତର୍‌ନ୍ନିଆ ଆକେନ୍ ସାମୁଆଁ ମେଁନେ ପେପଡ଼େକେ ସାମୁଆଁ ନାନେ ଗଡ଼େଇଂକେ ବାରି ଚିର୍‍ଲାଅଇଂକେ ପୁରାପୁରି ବାବ୍‌ରେ ପ୍ରସଂସା ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ବୁଦି ବିନାବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_17","070_21_17","MAT","21","17","17","ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁ ଆମେଇଂକେ ଆନ୍‌ତାର୍‌ଚେ ଜିରୁସାଲାମ୍‍ବାନ୍‍ ବେଥନୀନ୍ନିଆ ୱେକେ । ଆତ୍‍ ଅରିଆ ମେଁ ମେସୁଆ ମିଡିଗ୍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_18","070_21_18","MAT","21","18","18","ମାର୍‌ତଡ଼େ ବର୍‍ ଞ୍ଜିର୍‍ ଞ୍ଜିର୍‍ନୁଗ୍‍ଆ ଜିସୁ ଜିରୁସାଲାମ୍‍ ବାନ୍ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ନେ ବେଲା ଆମେକେ କିଡ଼େସକେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_19","070_21_19","MAT","21","19","19","ଗାଲି ଆଃଡ଼ା ମୁଇଂ ଲିୱା ‍ସ୍ଲା ଲେଃଗେ । ଜିସୁ ମେଁ ଡାଗ୍ରା ୱେଚେ କେକେ ଆତ୍‌ଅରିଆ ଉଲିଆ ଆନ୍‌ତାର୍‌ଚେ ବାରି ମେଃଡିଗ୍ ଆକେକେ ଣ୍ଡୁ । ତେସା ମେଁ ସ୍ଲାକେ ବାସଙ୍ଗ୍‌କେ “ନାନେ ଆରି ଅଃନା ଚୁ ନାଚୁ ଣ୍ଡୁ ।” ସାଙ୍ଗେ ସାଙ୍ଗେ ଲିୱା ସ୍ଲା ନ୍‌ସୁଆର୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_20","070_21_20","MAT","21","20","20","ସିସ୍‍ଇଂ ଆକେନ୍ କେଚେ ବକୁଆ ଡିଗ୍‍ଚେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଲିୱା ସ୍ଲା ମୁଇଙ୍ଗ୍ ଅଃତେନ୍‍ ଦାପ୍ରେ ଡିରକମ୍ ନ୍‌ସୁଆର୍ ୱେକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT21_21","070_21_21","MAT","21","21","21","ଜିସୁ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାବ୍‌ରେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ମନ୍ ଅରିଆ ଲେଲାଡିଗ୍‍ ମ୍ୱାର୍‍ ମନ୍ ମାଡିଙ୍ଗ୍‌ଚେ ପେ ଜଦି ପୁରାପୁରି ବାବ୍‌ରେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌ଏ, ନେଙ୍ଗ୍ ଆକେନ୍ ଲିୱା ସ୍ଲା ବାନ୍ ମେଃନେ ଡିଙ୍ଗ୍‍ମ୍ୱକେ, ପେଡିଗ୍ ଆତେନ୍‌ ଡିଙ୍ଗ୍‍ପେୟାଏ । ମାତର୍‌ ଅଃତେନ୍‍ ଆଃ ଣ୍ଡୁ ଆକେନ୍ କଣ୍ଡାକେ ଡବେଗ୍‍ଚେ କେଣ୍ତିଆ ଅରିଆ ୱେଚେ ଲଃଲା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍ଏ, ଆତେନ୍‌ ଡିଗ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT21_22","070_21_22","MAT","21","22","22","ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଚେ ପାର୍‍ତନା ଅରିଆ ମେଁନେ ପେସାଲ୍ୟାଏ ଆତେନ୍‌ ସାପା ପେବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_23","070_21_23","MAT","21","23","23","ଜିସୁ ମନ୍ଦିର୍‌ନ୍ନିଆ ଆଣ୍ଡେଚେ ଆତ୍‌ଅରିଆ ବୁଦି ବିକେଲା ମ୍ନା ଜାଜକ୍‍ଇଂ ଆରି ଜିହୁଦି ନେତାଇଂ ଆମେକେ ସାଲ୍ୟାକୁକେ “ଆଣ୍ଡିନେ ଅଦିକାର୍‌ରେ ନାଁ ଆକେନ୍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍‌କେ ? ଆନାକେ ଆକେନ୍ ଅଦିକାର୍ ଜା ବିକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT21_24","070_21_24","MAT","21","24","24","ଜିସୁ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ଆପେକେ ମାତର୍‌ ମୁଇଙ୍ଗ୍ ପ୍ରସ୍‌ନ ନ୍‌ସେଲ୍ୟାକୁଏ । ମେଁନେ ଉତର୍ ବାସଙ୍ଗ୍‍ ପେୟାଲା ନେଙ୍ଗ୍ ଆଣ୍ଡିନେ ଅଦିକାର୍‌ରେ ଆକେନ୍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଆପେକେ ମ୍ବାସଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT21_25","070_21_25","MAT","21","25","25","ଣ୍ଡିଆ ଅରିଆ ଦିକ୍ୟା ବିଃନେ ଅଦିକାର୍ ଜହନ୍ ଜା ଅରିଆବାନ୍‍ ବାଲେଗେ ? ଇସ୍‌ପର୍‌ବାନ୍ ଲେଃ ରେମୁଆଁ ବାନ୍ ?” ମେଇଂ ନିଜର୍‌ ନିଜର୍ ବିତ୍ରେ ବାଲିର୍‍ବାତାନେ ଡିଙ୍ଗ୍‌ଆର୍କେ “ଆକେନ୍ ବିସୟ୍‌ରେ ମେଃନେ ନେଃବାସଙ୍ଗ୍‌ଏ ? ଜଦି ନେବାସଙ୍ଗ୍‍ଏ ଇସ୍‌ପର୍‌ବାନ୍ ଜହନ୍‍କେ ମେଁନ୍‌ସା ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ମେଁ ଆନେକେ ସାଲ୍ୟାକୁଏ । ");
INSERT INTO gaq_vpl VALUES ("MT21_26","070_21_26","MAT","21","26","26","ରେମୁଆଁବାନ୍ ଡାଗ୍‌ଚେ ଜଦି ନେବାସଙ୍ଗ୍‍ଏ ତେଲା ରେମୁଆଁଇଂକେ ନେଁ ବୁଟ ନେଡିଙ୍ଗ୍‌କେ ଡାଗ୍ଲା ଜହନ୍ ମୁଇଙ୍ଗ୍ ବାବବାଦି ଡାଗ୍‌ଚେ ମେଇଂ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_27","070_21_27","MAT","21","27","27","ଆତେନ୍‌‍ସା ମେଇଂ ଜିସୁକେ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ନେ ନେମ୍ୟାକେ ଣ୍ଡୁ ।” ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଆଣ୍ଡିନେ ଅଦିକାର୍‌ରେ ଆକେନ୍ ସାପା ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ, ନେଙ୍ଗ୍ ଡିଗ୍ ଆପେକେ ନାବାସଙ୍ଗ୍‌ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_28","070_21_28","MAT","21","28","28","“ଟିକ୍‍ଲେକେ ଆକେନ୍ ସାମୁଆଁରେ ପେ ମେଃନେ ବାସଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍କେ ବାସଙ୍ଗ୍‌ । ମୁଇଙ୍ଗ୍ ରେମୁଆଁନେ ମ୍ୱାକ୍ଲିଗ୍‍ ଉଙ୍ଗ୍‌ଡେ ଲେଃଗେ । ମେସୁଆ ମେଁ ମ୍ନା ଉଙ୍ଗ୍‌ଡେକେ ବାସଙ୍ଗ୍‌କେ, ଅ ଗଡ଼େଅ, ଏକେ ନେନେ ଅଙ୍ଗୁର୍ ଲିଜ ୱେଚେ ସ୍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_29","070_21_29","MAT","21","29","29","ଣ୍ଡୁ, ନେଙ୍ଗ୍ ନ୍ନାଡିଙ୍ଗ୍ ଣ୍ଡୁ ଡାଗ୍‌ଚେ ମ୍ନା ଉଙ୍ଗ୍‌ଡେ ବାସଙ୍ଗ୍‌କେ ! ମାତର୍‌ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଚିନ୍ତା ଡିଙ୍ଗ୍‌ଚେ ସ୍ଲେନ୍‍ସା ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_30","070_21_30","MAT","21","30","30","ବାରି ଡାଆଁ ଉଙ୍ଗ୍‌ଡେକେ ଡିଗ୍ ଆତେନ୍‌ କାମ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବାସଙ୍ଗ୍‌କେ । ‘ଅଁ ମାପ୍‌ରୁ, ୱେଣ୍ଡିଙ୍ଗ୍‍କେ’ ଡାଗ୍‌ଚେ ଡାଆଁ ଉଙ୍ଗ୍‌ଡେ ଉତର୍ ବିକେ । ମାତର୍‌ ମେଁ ସ୍ଲେନ୍‍ସା ବିଲ୍‍କୁଲ୍‍ ଆୱେକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT21_31","070_21_31","MAT","21","31","31","ବାସଙ୍ଗ୍‌ପା ଏନ୍‌ ମ୍ୱାୟା ଉଙ୍ଗ୍‌ଡେ ବିତ୍ରେ ଜାଣ୍ଡେ ମେଁ ଆବାଡ଼େନେ ସାମୁଆଁ ସାକେ ।” ମେଇଂ ବାସଙ୍ଗ୍‌କେ “ମ୍ନା ଉଙ୍ଗ୍‌ଡେ ।” ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, ନେଙ୍ଗ୍ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‍ଣ୍ଡିଂକେ, ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ତ୍ରେ ଆରି ଚାଡ୍‌ରିଇଂ ପେବାନ୍ ସେନୁଗ୍‍ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ଗାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT21_32","070_21_32","MAT","21","32","32","“ଦିକ୍ୟାଣ୍ଡ୍ରେ ଜହନ୍ ପେଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଟିକ୍ ଗାଲି ଆଃସୁଏ ବିବଗେ ମାତର୍‌ ପେ ଆମେକେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌କେ । ଏଲେଡିଗ୍‍ ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେ ଆରି ଚାଡ୍‌ରିଇଂ ମେଁନେ ସାମୁଆଁରେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ଆକେନ୍ କେଚେ ଡିଗ୍ ପେ ମନ୍‍କେ ଆଃବଦ୍ଲେଚେ ଆମେକେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_33","070_21_33","MAT","21","33","33","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ବାରି ମୁଇଙ୍ଗ୍ ଉଃସ୍ରା ଅଁପା । ମୁଇଙ୍ଗ୍ ଲିଜ ସାଉକାର୍ ମେଁନେ ଲିଜନ୍ନିଆ ଅଙ୍ଗୁର୍ ଉଂଚେ ପିତୁର୍‌ ପାକା ତୁରାଃ ତେକେ ଆରି ଅଙ୍ଗୁର୍ ପେସେନେ କୁଣ୍ଡ୍ ଆରି ଉର୍‍ଣ୍ଡ୍ରେ ନ୍‍ସା ମୁଇଙ୍ଗ୍ ତାନା ଡିଗ୍‍ ଆଃରେକେ । ତେନ୍‌ ଇଡ଼ିଂ ଲିଜକେ ସ୍ଲେରେକେ ବାଟା ବିଚେ ବିଦେସ୍‍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_34","070_21_34","MAT","21","34","34","ଅଙ୍ଗୁର୍ ବ୍ଲେଚେ ରୁଏନେ ବେଲା ପିଙ୍ଗ୍‌ଚାଲା ମେଁ ରୁଏଣ୍ଡ୍ରେ ଡାଗ୍ରା ନିଜେନେ ବାଗ୍ ରାସିଙ୍ଗ୍‍ ନ୍‌ସା ନିଜେନେ ଚାକର୍‍ଇଂକେ ବେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_35","070_21_35","MAT","21","35","35","ସ୍ଲେରେଇଂ ଆତେନ୍‌ ଚାକର୍‍ଇଂକେ ସାଚେ ମୁଇଂଜାକେ ବଗ୍‌ ଆର୍‌କେ ବାର୍‌ମୁଇଂଜାକେ ତାଡ଼୍‍ତେ ବାଗୁଏଃ ବିଃଆର୍‌କେ ଆରି ବାର୍‌ମୁଇଂଜା ଆଡ଼ାତ୍ରା ବ୍ରି ଟୁଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_36","070_21_36","MAT","21","36","36","ବାରି ଲିଜ ସାଉକାର୍ ଗୁଲେରୁଆକେ ବିନ୍ ଚାକର୍‍ଇଂକେ ବାରି ମୁଇଂତର୍ ବେକେ । ମେଁଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ଡିଗ୍ ସ୍ଲେରେଇଂ ଦେତ୍‌ରକମ୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_37","070_21_37","MAT","21","37","37","ସାରାସାରିକେଲା ଲିଜ ସାଉକାର୍ ନିଜେନେ ଉଙ୍ଗ୍‌ଡେକେ ସ୍ଲେରେଇଂ ଡାଗ୍ରା ବେକେ । ମେଁ ବାବେକେ ଜେ ଡିଲାଡିଗ୍ ମେଇଂ ନେଙ୍ଗ୍‌ନେ ନେଉଂକେ ମାନେଃ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT21_38","070_21_38","MAT","21","38","38","“ମାତର୍‌ ସ୍ଲେରେଇଂ ସାଉକାର୍‍ନେ ଉଙ୍ଗ୍‌ଡେକେ କେଚେ ମେଇଂମେଇଂ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଆର୍‌କେ ଆକେନ୍ କେଲାପା ସାଉକାର୍‍ନେ ଉଙ୍ଗ୍‌ଡେ । ଗେଲାପା ଆକ୍‌ମେକେ ଡିଗ୍ ବାଗୁଏ ନେଃବିପା । ତେଲା ଲିଜ ବ୍ରି ନେନେ ଡିଙ୍ଗ୍‌ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT21_39","070_21_39","MAT","21","39","39","ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ମେଇଂ ଆମେକେ ଡୁଗ୍‌ଡି ବାନ୍‍ ପାଦା ଡୁଂୱେଚେ ବାଗୁଏ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_40","070_21_40","MAT","21","40","40","ଜିସୁ ସାଲ୍ୟାକୁକେ “ବାସଙ୍ଗ୍‍ ତ ଲିଜ ସାଉକାର୍ ଉଡ଼ିବେଲା ପାଙ୍ଗ୍‌ଏ ମେଁ ସ୍ଲେରେକେ ମେଁନେ ଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MT21_41","070_21_41","MAT","21","41","41","ମେଇଂ ଉତର୍ ବିକେ “ଆତେନ୍‌ ମୁର୍କଇଂକେ ମେଁ ଇୟାଙ୍ଗ୍‍ଚିନା ବାଗୁଏ ବିଏ ଆରି ମୁଡ଼ି ସ୍ଲେରେଇଂ ଟିକ୍ ବେଲା ଆମେକେ ବାଟା ଚୁ ବିଏ ଲିଜ ବ୍ରି ମେଁଇଙ୍ଗ୍‌ନ୍ନିଆ ଆନ୍‌ତାର୍‌ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_42","070_21_42","MAT","21","42","42","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍ ସାସ୍ତର୍‌ନେ ସାମୁଆଁ ମେଃନେ ପେପଡ଼େକେ ?” “ଆଣ୍ତିନେ ବ୍ରିକେ ବାଡ଼ାଇଇଂ ଦର୍‌କାର୍‌ ଣ୍ଡୁ । ଡାଗ୍‌ଚେ ଆନ୍ତାର୍ ବିବଆର୍‌କେ । ଆତାନ୍‌ ବ୍ରି ମାତର୍‌ ଡୁଆନେ ମୁଲ୍‌ ବ୍ରି ଡିଙ୍ଗ୍‌କେ । ନିଜେ ମାପ୍ରୁ ଆତେନ୍‌ ବାସଙ୍ଗ୍‌ ବକେ, ଉଡ଼ି ବୟାଙ୍କାର୍‌ ଏନ୍ ସ୍ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_43","070_21_43","MAT","21","43","43","ଜିସୁ ଆରି ବାସଙ୍ଗ୍‌କେ “ତେସା ଆପେକେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ଗିଃଗାଃନେ ଅଦିକାର୍ ପେବାନ୍ ତଡୁଂଡଏ ଆରି ମୁଡ଼ି କୁଲ୍‍ ଆକେନ୍ ରାଇଜ୍‍ନେସା ନିମାଣ୍ଡା ଚୁଚେ ଆଃସୁଏଃଏ ଆମେଇଂକେ ଆତେନ୍‌ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT21_44","070_21_44","MAT","21","44","44","ଆରି ଜା ଆକେନ୍ ବ୍ରି ଆଡ଼ାତ୍ରା ଲଃଏ ମେଁ ଗନ୍ଦା ଗନ୍ଦା ଡିଙ୍ଗ୍‌ୱେଏ ବାରି ଏନ୍‌ ବ୍ରି ଜା ଆଡ଼ାତ୍ରା ଲଃଏ ଆମେକେ ଆତେନ୍‌ ଗୁଣ୍ଡ୍‍ଗୁଣ୍ଡା ଆଡିଙ୍ଗ୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT21_45","070_21_45","MAT","21","45","45","ମ୍ନା ଜାଜକ୍‍ ଆରି ଫାରୁଶୀଇଂ ଆକେନ୍ ଉଃସ୍ରାଇଂ ଅଁଚେ ଜିସୁ ଆମେଇଂକେ କେଡିଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ବୁଜେ ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT21_46","070_21_46","MAT","21","46","46","ଆତେନ୍‌‍ସା ମେଇଂ ଆମେକେ ସାନ୍ତି ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ଆର୍କେ ମାତର୍‌ ରେମୁଆଁଇଂକେ ବୁଟଚେ ମେଇଂ ଆତେନ୍‌ ଡିଙ୍ଗ୍ ଆୟା ଆର୍‌କେ ଣ୍ଡୁ ଡାଗ୍ଲା ରେମୁଆଁଇଂ ଜିସୁକେ ବାବବାଦି ଡାଗ୍‌ଚେ ବାବେ ଡିଙ୍ଗ୍‌ଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_1","070_22_1","MAT","22","1","1","ଜିସୁ ବାର୍‌ମୁଇଂତର୍‍ ଉଃସ୍ରାରେ ରେମୁଆଁଇଂକେ ସିକ୍ୟା ବିକେ ");
INSERT INTO gaq_vpl VALUES ("MT22_2","070_22_2","MAT","22","2","2","“ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ଦେକ୍ ରକମ୍ ଆକେନ୍ ସାମୁଆଁ ମୁଇଙ୍ଗ୍ ଇଃସାଙ୍ଗ୍‌ ଉଙ୍ଗ୍‌ଡେନେ ବିହେ ବଜି ଆର୍ମେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_3","070_22_3","MAT","22","3","3","କବର୍ ବିଃକ୍ନେ ରେମୁଆଁଇଂକେ ବଜିନ୍ନିଆ ୱାଡୁଂପାଙ୍ଗ୍‍ ନ୍‌ସା ମେଁନେ ଚାକର୍‍ଇଂକେ ବେକେ । ମାତର୍‌ ଆତେନ୍‌ ରେମୁଆଁଇଂ ପାଙ୍ଗ୍‍ନ୍‍ସା ରାଜି ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_4","070_22_4","MAT","22","4","4","ଇଃସାଙ୍ଗ୍‌ ବାର୍‌ମୁଇଂତର୍‍ ବିନ୍ ଚାକର୍‍ଇଂନେ ବାନ୍ ଆକେନ୍ କବର୍ ବେକେ, ବିହେ ବଜି ଆର୍ମେ ଆର୍ଗେବେ, ଗାଗ୍‍ଡ଼େକ୍ନେ ଅରେଃ ଆରି ମେଣ୍ଡାଚି ଗୁଆଃଚେ ସାପା ଆର୍ମେବ ଆର୍‌କେ, ବଜିନ୍ନିଆ ଜିଆଃ ପାଙ୍ଗ୍‌ଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT22_5","070_22_5","MAT","22","5","5","ମାତର୍‌ କବର୍ ବିବକ୍ନେ ରେମୁଆଁଇଂ ଆକେନ୍ ସାମୁଆଁକେ ଆମାନେଚେ ନିଜେ ନିଜେନେ କାମ୍‍ନ୍ନିଆ ଲାଗେ ପଡ଼େଆର୍କେ ମୁଇଂଜା ମେଁନେ ଲିଜନ୍ନିଆ ୱେକେ ବାରି ମୁଇଂଜା ଦୁକାନ୍‍ ୱେକେ ଆରି ");
INSERT INTO gaq_vpl VALUES ("MT22_6","070_22_6","MAT","22","6","6","ବାରି ଉଡ଼ିରୁଆ ଇଃସାଙ୍ଗ୍‌ନେ ଚାକର୍‍ଇଙ୍କେ ସାଚେ ବଗ୍ ବଗ୍‍ଚେ ବାଗୁଏଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_7","070_22_7","MAT","22","7","7","ଇଃସାଙ୍ଗ୍‌ ରିସା ଡିଙ୍ଗ୍‌ଚେ ସନ୍ୟ‍ଇଂକେ ବେକେ । ବାରି ମେଇଂ ଆତେନ୍‌ ରେମୁଆଁ ବାଗୁଏରେକେ ବାଗୁଏଚେ ମେଁଇଙ୍ଗ୍‌ନେ ଇନିକେ ସୁଆ ଆଡୁଆ ବିଃ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_8","070_22_8","MAT","22","8","8","ତେନ୍‌ ଇଡ଼ିଂ ଇଃସାଙ୍ଗ୍‌ ଚାକର୍‍ଇଂକେ ୱାଚେ ବାସଙ୍ଗ୍‌କେ “ବିହେ ବଜି ଆର୍ମେବ ଆର୍‌କେ ମାତର୍‌ ନେଙ୍ଗ୍ ୱାମ୍ୱକ୍ନେ ରେମୁଆଁଇଂ ଆକ୍ ଅରିଆ ପାଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT22_9","070_22_9","MAT","22","9","9","ଏବେ ମ୍ନା ମ୍ନା ସାଇକେ ୱେଚେ ଉଡ଼ିରୁଆକେ ପେଅବାଏ ସାପାରେକେ ନେନେ ବିହେ ବଜି ଅରିଆ ୱାଡୁଂ ପାଙ୍ଗ୍‌ଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT22_10","070_22_10","MAT","22","10","10","ତେଲା ଚାକର୍‍ଇଂ ସାଇ ସାଇ ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ଲେ କି; ଦଦିଆ ଡିଙ୍ଗ୍‌ଲେ; ଉଡ଼ିରୁଆକେ ଅବାଆର୍‌କେ ସାପାରେକେ ୱା ଡୁଂପାଙ୍ଗ୍‍ଆର୍‌କେ ଆରି ବିଏ ଡୁଆ ରେମୁଆଁଇଂ ରିସିଙ୍ଗ୍ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_11","070_22_11","MAT","22","11","11","“ଇଃସାଙ୍ଗ୍‌ କୁଲାରେକେ କେନ୍‍ସା ପାଙ୍ଗ୍‌କେ । ମେଁ କେକେ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ମୁଇଂଜା ବିଏ ସକା ଆସଃକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT22_12","070_22_12","MAT","22","12","12","ଇଃସାଙ୍ଗ୍‌ ଆମେକେ ସାଲ୍ୟାକୁକେ, ବୟାଁ, ବିଏ ଡୁଆ ସକା ମାସଚେ ଆକ୍‌ଅରିଆ ଡିଡି ନାପାଙ୍ଗ୍‍କେ ? ଆତେନ୍‌ ରେମୁଆଁ ମେଃଡିଗ୍ ଆବାସଙ୍ଗ୍‍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT22_13","070_22_13","MAT","22","13","13","ଇଃସାଙ୍ଗ୍‌ ଗତିରେଇଂକେ ବାସଙ୍ଗ୍‌କେ ମେଁନେ ନ୍ତି ଞ୍ଚ ଗାଗ୍‌ଚେ ବାଏରେ ଜଗ୍‌ତ୍ଲିଗ୍‌ପା । ଆତ୍‌ଅରିଆ ମେଁ ଅଁଚେ ଗ୍ନି ଗେରିଚିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_14","070_22_14","MAT","22","14","14","ଉସ୍ରା ଆଃଡାଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଗୁଲେରୁଆକେ କବର୍ ବିମ୍ୱଗେ ମାତର୍‌ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ଗଣ୍ଡାଃ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଲେଃଆର୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_15","070_22_15","MAT","22","15","15","ଉଡ଼ିରୁଆ ଫାରୁଶୀ ଜିସୁକେ ପ୍ରସ୍‌ନ ସାଲ୍ୟାକୁଚେ ଆମେକେ ପାନ୍ଦ୍‍ ଅରିଆ ତ୍ଲାଗ୍‍ନ୍‍ସା ଉପାୟ୍‍ ତୁର୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_16","070_22_16","MAT","22","16","16","ମେଇଂ ମେଁଇଙ୍ଗ୍‌ନେ ଉଡ଼ିରୁଆ ସିସ୍‍କେ ଆରି ହେରୋଦ ପାକାନେ ଉଡ଼ିରୁଆକେ ଜିସୁ ଡାଗ୍ରା ବେଆର୍‌କେ । କିମେଇଂ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଏ ଗୁରୁ ନେଁ ମ୍ୟାନେଲେଃକେ ଜେ ପେ ମେଁନେ ବାସଙ୍ଗ୍‌ପେଡିଂ ଆରି ବ୍ନାଲିର୍ ବିଃ ନାଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ସାପା ଟିକ୍ । ନାନେ ଜା ଆଡ଼ାତ୍ରା ଡିଗ୍ ନାବୁଟ ଣ୍ଡୁ । ମାତର୍‌ ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚା ବିସୟ୍‌ରେ ସତ୍ ବୁଦି ବିଃ ନାମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_17","070_22_17","MAT","22","17","17","ଆନେକେ ବାସଙ୍ଗ୍ । ତେଲା ବାସଙ୍ଗ୍‌ ଆକେନ୍ ସାମୁଆଁରେ ନାନେ ମନ୍ ମେଁନେ ? କାଇସର୍‍କେ ସିସ୍ତୁ ବିନେ ନିଅମ୍ ଲେଃ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MT22_18","070_22_18","MAT","22","18","18","ମାତର୍‌ ଜିସୁ ମେଁଇଙ୍ଗ୍‌ନେ ଦୁସ୍ଟବୁଦି ମ୍ୟାଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ରେ କପଟି ରେମୁଆଁଇଂ ଆନେଙ୍ଗ୍ ପାନ୍ଦ୍‌ନ୍ନିଆ ତ୍ଲାଗ୍‍ନ୍‍ସା ମେଁନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MT22_19","070_22_19","MAT","22","19","19","ଆଣ୍ଡିନେ ଡାବୁରେ ସିସ୍ତୁ ବିଃ ପେଡିଙ୍ଗ୍‌କେ ଆତ୍‌ବା ମୁଇଙ୍ଗ୍ ଡୁଂପାଙ୍ଗ୍‍ଚେ ଆନେଙ୍ଗ୍ ଆସୁଏପା ।” ମେଇଂ ମୁଇଙ୍ଗ୍ କାସୁ ଡୁଂପାଙ୍ଗ୍‍ଚେ ଆମେକେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_20","070_22_20","MAT","22","20","20","ମେଁ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ, “ଆକେନ୍ କାସୁ ଆଡ଼ାତ୍ରା ଜାନେ ମ୍ନି ଆରି ଜାନେ ମୁର୍ତି ଆରେ ବଆର୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT22_21","070_22_21","MAT","22","21","21","ମେଇଂ ଉତର୍ ବିକେ “ରୋମ୍ ଇଃସାଙ୍ଗ୍‌ନେ ।” ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ତେଲା ଆଣ୍ଡିନେ ରୋମ୍ ଇଃସାଙ୍ଗ୍‌ନେ ଆତେନ୍‌ ରୋମ୍ ଇଃସାଙ୍ଗ୍‌କେ ବିଃପା ଆରି ଆଣ୍ଡିନେ ଇସ୍‌ପର୍‌ନେ ଆତେନ୍‌ ଇସ୍‌ପର୍‌କେ ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_22","070_22_22","MAT","22","22","22","ଆକେନ୍ ଅଁଚେ ମେଇଂ ଆଅଁକେ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଚେ ଲାଗ୍‍ଡଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_23","070_22_23","MAT","22","23","23","ଆତେନ୍‌ ଦିନା ସାଦୁକୀ ଦଲ୍‍ନେ ଉଡ଼ିରୁଆ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ସାଦୁକୀଇଂ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ଆର୍‌ଡିଂକେ ଜେ ଆରି ଗୁଏଚେ ବ୍ରୁଆନେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT22_24","070_22_24","MAT","22","24","24","ମେଇଂ ଜିସୁକେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଗୁରୁ ମୋଶା ନିଅମ୍ ଆଡିଙ୍ଗ୍‍ବକେ ଜେ ଜଦି ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଗୋ ଗିସିଆ ମାକେଚେ ଗୁଏୱେଏ ତେଲା ମେଁ ବୟାଁଣ୍ଡେ ମେଁନେ ଗଏସାଙ୍ଗ୍‍କୁଏକେ ବିହେ ଡିଙ୍ଗ୍‌ଏ ଆରି ମେଁଇଙ୍ଗ୍‌ନେ ଗଡ଼େଇଂ ଆତେନ୍‌ ଗୁଏକ୍ନେ ରେମୁଆଁନେ ଗୋ ଗିସିଆ ଡାଗ୍‌ଚେ ମ୍ୟା ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT22_25","070_22_25","MAT","22","25","25","ମୁଇଙ୍ଗ୍ ସାମୁଆଁ ଦ୍ରିଗ୍‍ପା । ନେନେ ଆକ୍ ଅରିଆ ଗୁ ରୁଆ ବୟାଁ ଲେଆର୍‌ଗେ । ମ୍ନା ବୟାଁ ଗୋ ଗିସିଆ ମାକେଚେ ଗୁଏୱେଲା ମେଁନେ ବାରି ମୁଇଙ୍ଗ୍ ବୟାଁ ଡିଗ୍ ମ୍ନା ବୟାଁନେ କୁନେଡେକେ ବିହେ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_26","070_22_26","MAT","22","26","26","ମାତର୍‌ ଆକେନ୍ ମଜିଆ ବୟାଁ ଡାଆଁ ବୟାଁ ସାରାସାରି ସାପାବାନ୍‍ ପ୍ଲାନେ ବୟାଁନେ ଡିଗ୍ ଦେତ୍ ରକମ୍ ଗଟେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_27","070_22_27","MAT","22","27","27","ସାରାସାରିକେଲା ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ଡିଗ୍ ଗୁଏୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_28","070_22_28","MAT","22","28","28","ମୁଡ଼ିଦିନା ଗୁଏଲେକ୍ନେ ରେମୁଆଁଇଂ ତଡ଼ିଆ ଆର୍‌ଏ ଆକେନ୍ ସେଲାମ୍ବୁଏ ଜାନେ କୁନେଡେ ଡାଗ୍‌ଚେ ମ୍ୟା ଆର୍‌ଏ ? ସାପାରେ ତ ଆମେକେ ବିହେ ଡିଙ୍ଗ୍‍ଲେ ଆର୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_29","070_22_29","MAT","22","29","29","ଜିସୁ ଉତର୍ ବିକେ “ପେ ବୁଲ୍‍ ବୁଜେ ପେଡିଙ୍ଗ୍‌କେ ! ସାସ୍ତର୍‌ ବାରି ଇସ୍‌ପର୍‌ନେ ବପୁ ସାମୁଆଁରେ ପେନେ ସମାନ୍ ବାବ୍‌ନା ଆଲେଃଗେସା ଆକେନ୍ ସାମୁଆଁ ସାଲ୍ୟାକୁ ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_30","070_22_30","MAT","22","30","30","ଗୁଏଚେ ତଡ଼ିଆକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଗୁଏକ୍ନେ ରେମୁଆଁଇଂ କିତଂ ଦୁତ୍ ରକମ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ମେଇଂ ବିହେ ଆଡିଙ୍ଗ୍ ଆର୍‌ଏ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT22_31","070_22_31","MAT","22","31","31","ଗୁଏକ୍ନେ ରେମୁଆଁଇଂ ତଡ଼ିଆନେ ସାମୁଆଁ ଇସ୍‌ପର୍ ମେଁନେ ବାସଙ୍ଗ୍‍ବକେ ପେ ମେଁନେ ସାସ୍ତର୍‌ନ୍ନିଆ ଅଃନା ପେପଡ଼େକେ ? ");
INSERT INTO gaq_vpl VALUES ("MT22_32","070_22_32","MAT","22","32","32","ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‍ବକେ ନେ ଅବ୍ରାହାମ୍‌ନେ ପର୍‌ମେସର୍‌ ଇସାକ୍‌ନେ ପର୍‌ମେସର୍‌ ଜାକୁବ୍‌ନେ ପର୍‌ମେସର୍‌ । ଇସ୍‌ପର୍ ତ ମ୍ବ୍ରକ୍ନେ ରେମୁଆଁଇଂନେ ଇସ୍‌ପର୍, ଗୁଏଲେଃକ୍ନେ ରେମୁଆଁଇଂନେ ଇସ୍‌ପର୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_33","070_22_33","MAT","22","33","33","ରେମୁଆଁଇଂ ଜିସୁନେ ସାମୁଆଁ ଅଁଚେ ବକୁଆ ଡିଙ୍ଗ୍‌ୱେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_34","070_22_34","MAT","22","34","34","ଉଡ଼ିବେଲା ଫାରୁଶୀଇଂ ଅଁଆର୍କେ ଜେ ଜିସୁ ସାଦୁକୀଇଂକେ ଚୁପ୍‍ଚାପ୍‍ ଆଡିଙ୍ଗ୍‍ବକେ ମେଇଂ ମୁଇଂ ମାନ୍ଦା ଡିଙ୍ଗ୍‌ଚେ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT22_35","070_22_35","MAT","22","35","35","ବାରି ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ମୁଇଂଜା ଦର୍ମ ଗୁରୁ ଜିସୁକେ ପାନ୍ଦ୍‍ ଅରିଆ ତ୍ଲାଗ୍‍ନ୍‍ସା ମୁଇଙ୍ଗ୍ ପ୍ରସ୍ନ ସାଲ୍ୟାକୁଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT22_36","070_22_36","MAT","22","36","36","“ଏ ଗୁରୁ ନେଁ ମୋଶାନେ ନିଅମ୍‌ନ୍ନିଆ ମୁଡ଼ି ଆଦେସ୍‍ ସାପାବାନ୍‍ ମ୍ନା ?” ");
INSERT INTO gaq_vpl VALUES ("MT22_37","070_22_37","MAT","22","37","37","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ପେନେ ମାପ୍ରୁ ଇସ୍‌ପର୍‌କେ ସାପା ରୁଦୟ୍‍ ସାପା ଆତ୍ମା ଆରି ସାପା ମନ୍ ବିଃଚେ ଆଲାଦ୍ ଡିଂପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_38","070_22_38","MAT","22","38","38","ଆକେନ୍ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ସାପାବାନ୍‍ ମ୍ନା ଆରି ମ୍ନା ଆଦେସ୍‍ ");
INSERT INTO gaq_vpl VALUES ("MT22_39","070_22_39","MAT","22","39","39","“ବାରି ମୁଇଙ୍ଗ୍ ମ୍ନା ଆଦେସ୍‍ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ପେନେ ଡୁଆ ଡାଗ୍ରାନେ ରେମୁଆଁକେ ଆତ୍ମା ଏତେ ଆଲାଦ୍ ଡିଂପା । ");
INSERT INTO gaq_vpl VALUES ("MT22_40","070_22_40","MAT","22","40","40","ଆକେନ୍ ମ୍ୱାକ୍ଲିଗ୍‍ ଆଦେସ୍‍ ମୋଶାନେ ସାପା ନିୟମ୍ ଆରି ବାବବାଦି‍ଇଂନେ ସାପା ସିକ୍ୟା ଆଦ୍ରିଗ୍ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_41","070_22_41","MAT","22","41","41","ଉଡ଼ିରୁଆ ଫାରୁଶୀ ଜିସୁ ଡାଗ୍ରା ଲେଃକେଲା ଜିସୁ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ, ");
INSERT INTO gaq_vpl VALUES ("MT22_42","070_22_42","MAT","22","42","42","“କିସ୍‌ଟ ମସିହନେ ମେଁନେ ସାମୁଆଁରେ ପେ ମେଃନେ ବାବେ ପେଡିଙ୍ଗ୍‌କେ ? ମେଁ ଜାନେ କୁଲ୍‍ ?” ମେଇଂ ଉତର୍ ବିଃଆର୍‌କେ, “ମେଁ ଦାଉଦ୍‍ନେ କୁଲ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT22_43","070_22_43","MAT","22","43","43","ଜିସୁ ସାଲ୍ୟାକୁକେ, “ତେଲା ଦାଉଦ୍‍ ମସିହକେ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ? ଡାଗ୍ଲା ପବିତ୍ର ଆତ୍ମାନେ ଆଦେସ୍‌ରେ ମେଁ ଗୁଆର୍‍ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT22_44","070_22_44","MAT","22","44","44","ଇସ୍‌ପର୍‌ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁକେ ମ୍ୱାସଙ୍ଗ୍‍କେ, ନେଁ ପେନେ ସତ୍ରୁଇଂକେ ନାନେ ଞ୍ଚ ବୁନ୍ଦେ ଡୁଂମାପାଙ୍ଗ୍‍ ଜାକ ନାଁ ନେଙ୍ଗ୍‌ନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା କଲାଲା । ");
INSERT INTO gaq_vpl VALUES ("MT22_45","070_22_45","MAT","22","45","45","ଜଦି ଦାଉଦ୍‍ ମସିହକେ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ତେଲା ମସିହ ଡିରକମ୍ ଦାଉଦ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ଡିଙ୍ଗ୍‍ୟାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MT22_46","070_22_46","MAT","22","46","46","ଜିସୁକେ ଜାଡିଗ୍ ଆକେନ୍ ଉତର୍ ବିଃ ଆୟାକେ ଣ୍ଡୁ । ଆତେନ୍‌ ଦିନା ବାନ୍ ଆମେକେ ଆରି ମେଃଡିଗ୍ ପ୍ରସ୍‌ନ ସାଲ୍ୟାକୁ ଜାଡିଗ୍ ସାହାସ୍ ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_1","070_23_1","MAT","23","1","1","ଜିସୁ ସିସ୍ଇଂକେ ଆରି ରିସିଙ୍ଗ୍‍ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT23_2","070_23_2","MAT","23","2","2","“ଦରମ୍ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂ ମୋଶାନେ ନିୟମ୍‌ ବୁଦି ବିଃନେ କେମତା ବା ଲେଃକ୍ନେ ବାସଙ୍ଗ୍‌ ରେମୁଆଁଇଂ କଲେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_3","070_23_3","MAT","23","3","3","ତେସା ମେଇଂ ମେଃ ଡିଙ୍ଗ୍‌ନେ ବାସଙ୍ଗ୍‌ଡିଂକେ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ପା । ମାତର୍‌ ମେଁଇଙ୍ଗ୍‌ନେ କାମ୍ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ଆକେଗେପା । ଡାଗ୍ଲା ମେଇଂ ନିଜେ ବିଡିଙ୍ଗ୍‌କ୍ନେ ବୁଦି ଇସାବ୍‌ରେ କାମ୍ ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT23_4","070_23_4","MAT","23","4","4","ମେଇଂ ବୁଦି ସାପା ରେମୁଆଁନେ ଗୁଗ୍‍ଡିଆ ଆଡ଼ାତ୍ରା ଜାବର୍‌ ଲିଗିଙ୍ଗ୍‍ ଆନିଗ୍ ବିଃମ୍ୟାକେ ମାତର୍‌ ଆତେନ୍‌ ସାପା ଲିଗିଙ୍ଗ୍‍ ଡୁଙ୍ଗ୍‍ନେସା ନିଜେନେ ଆରୁଏତି ଏତେ ଣ୍ଡିଗ୍ ଇତୁଡ଼ା ଡିଗ୍ ସଙ୍ଗ୍‍ତୁଡ଼୍ ଡିଙ୍ଗ୍ ଆବିଆର୍‍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT23_5","070_23_5","MAT","23","5","5","ମେଇଂ ରେମୁଆଁଇଂକେ ଆକେନ୍‌ସା ସାପା ସ୍ଲେ ଡିଙ୍ଗ୍‌ମ୍ୟାଆର୍‌କେ । କେଲା ମେଇଂ ସାସ୍ତର୍‌ନେ ସାମୁଆଁ ଗୁଆର୍‍ ବକ୍ନେ ଉଡ଼ି ଉଡ଼ି ବିଦ୍‌ କାପାଲ୍‍ ଆରି ନ୍ତିନିଆ ଗାଗ୍‍ ବଆର୍‌କେ । ବାରି କେଲାପା ମେଁଇଙ୍ଗ୍‌ନେ ସକାନେ ଜାଲିପୁଆ ଉଡ଼ି ଚ୍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_6","070_23_6","MAT","23","6","6","ମେଇଂ ବଜିନ୍ନିଆ ମ୍ନାରେନେ ସିଟ୍‍ଡାଗ୍ରା କନେ ଆରି ପାର୍‍ତନା ଡୁଆନ୍ନିଆ ନିମାଣ୍ଡା ଜାଗା ଅରିଆ କୁକ ନ୍‍ସା ବଲ୍‍ ବାମ୍ୟାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_7","070_23_7","MAT","23","7","7","ସାନ୍ତା ଚକ୍‍ଇଂ ଡାଗ୍ରା ରେମୁଆଁଇଂ ଆମେଇଂକେ ସନ୍‍ମାନ୍‍ ବିଚେ ନିମାଣ୍ଡା ଡାଗ୍‍ଚେ ଆରି ସାମୁଁଆଃଏ ଗୁରୁ ଡାଗ୍‌ଚେ ସାପା ରେମୁଆଁ ମ୍ୟା ଡାଗ୍‌ଚେ ଆକେନ୍ ମେଇଂ ଚାଏଁଡିଙ୍ଗ୍‍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_8","070_23_8","MAT","23","8","8","ମାତର୍‌ ଆନାକେ ଜାଡିଗ୍‍ ଗୁରୁ ଡାଗ୍‌ଚେ ୱାନେ ଦର୍‌କାର୍ ଣ୍ଡୁ । ଡାଗ୍ଲା ପେ ସାପାରେ ପେ ବିତ୍ରେ ବୟାଁ ଆରି ପେନେ ଗୁରୁ ମୁଇଂଜାଆ । ");
INSERT INTO gaq_vpl VALUES ("MT23_9","070_23_9","MAT","23","9","9","ବାରି ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ପେ ଆଜାକେ ଆବା ଡାଗ୍‌ଚେ ୱାନେ ଆରି ପେନେ ଦର୍‌କାର୍ ଣ୍ଡୁ । ଡାଗ୍ଲା ପେନେ ମାତର୍‌ ମୁଇଂ ଆଃ ଆବା ମେଁ କିତଂ ଆଡ଼ାତ୍ରା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_10","070_23_10","MAT","23","10","10","ଆପେକେ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ଡିଗ୍ ଜା ଆୱାଲେ ଡାଗ୍ଲା ମୁଇଂ ଆଃ ମାତର୍‌ ମାପ୍ରୁ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ କିସ୍‌ଟ ମସିହ । ");
INSERT INTO gaq_vpl VALUES ("MT23_11","070_23_11","MAT","23","11","11","ପେ ବିତ୍ରେ ଜା ସାପାବାନ୍‍ ମ୍ନା ମେଁ ପେନେ ଜତନ୍‌ ଡିଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_12","070_23_12","MAT","23","12","12","ଜାଣ୍ଡେ ନିଜେକେ ମ୍ନା ଡାଗ୍‍ଏ ଆମେକେ ଡାଆଁ ଆଡିଙ୍ଗ୍‌ଏ ଆରି ଜାଣ୍ଡେ ନିଜେକେ ଡାଆଁ ଆଃସୁଏ ଆମେକେ ମ୍ନା ଆଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_13","070_23_13","MAT","23","13","13","“ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂ ପେନେ ସାରାସାରି ଗଟ୍‌ନା ବଡ଼େ ବୟ୍‍ଙ୍କାର୍‍ ! ଏ ଚାଲାକି ଦାର୍ମିକ୍‍ ମାନ୍ଦା କିତଂ ରାଜିନେ ଗିଃଗାଃନେ ର୍ଣ୍ଣସାଙ୍ଗ୍ ଡାଚେ ପେବକେ । ମାତର୍‌ ନିଜେ ଆତ୍‌ଅରିଆ ଗା ପେଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ଆରି ଜାଣ୍ଡେଇଂ ଗିଃଗାଃନେ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କେ ଆମେଇଂକେ ଗାଲି ଆନ୍‌ତାର୍‌ ପେଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT23_14","070_23_14","MAT","23","14","14","ଏ କପଟି ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂ ପେନେ ଗଟ୍‌ନା ବଡ଼େ ବୟ୍‍ଙ୍କାର୍‍ ଡିଙ୍ଗ୍‌ଏ ! ଡାଗ୍ଲା ପେଇଂ ଚାଲାକିରେ ଚ୍ଲେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେ ସାଙ୍ଗେ ସାଙ୍ଗେ ଗୁଏସାଙ୍ଗ୍‍କୁଏ ସେଲାମ୍ବୁଏଇଂ ଡୁଆ ସାପା ଡୁଂଡ ପେଡିଙ୍ଗ୍‌କେ ତେଲା ପେଇଂ ମାଲେ ଡଣ୍ଡ୍‍ ପେବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT23_15","070_23_15","MAT","23","15","15","ରେ କପଟି ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂ ପେନେ ଗଟ୍‌ନା ଉଡ଼ି ବୟ୍‍ଙ୍କାର୍‍ ଡିଙ୍ଗ୍‌ଏ । ପେ କେଣ୍ଡିଆ ପୁଆଚେ ଦେସ୍‍ଦେସ୍‍ ଅଲେଙ୍ଗ୍‌ଚେ ମୁଇଂଜାକେ ପେ ଦର୍ମନ୍ନିଆ ଦିକ୍ୟା ବିଃନ୍‍ସା ତୁର୍ ପେଡିଙ୍ଗ୍‌କେ । ମାତର୍‌ ଦେତ୍‌ରକମ୍ ରେମୁଆଁ ପେଅବାଲା ଆମେକେ ନର୍କେନ୍ନିଆ ଡଣ୍ଡ୍‍ ବାନ୍‌ସା ପେବାନ୍ ମ୍ୱାର୍‍ ଗୁନ୍‌ ଅଦିକା ଆର୍ମେ ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_16","070_23_16","MAT","23","16","16","“ରେ ତାଙ୍ଗ୍‍କିକ୍‍ ଗାଲି ୱେନେ ରେମୁଆଁଇଂ ପେନେ ଗଟ୍‌ନା ବଡ଼େ ବୟଙ୍କାର୍ ଡିଙ୍ଗ୍‌ଏ ! ପେ ସିକ୍ୟା ବିଃପେମ୍ୟାକେ, ଜାଣ୍ଡେ ମନ୍ଦିର୍‍ ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଏ, ଆତେନ୍‌ ମେଁ ପାଲେନ୍‍ସା ଜବର୍ ଦସ୍ତି ଣ୍ଡୁ; ମାତର୍‌ ମନ୍ଦିର୍‍ନ୍ନିଆ ଲେଃକ୍ନେ ସୁନା ମ୍ନିରେ ଜାଣ୍ଡେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଏ, ଆମେକେ ମେଁ ଆତେନ୍‌ ପାଲେ ପଡ଼େଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_17","070_23_17","MAT","23","17","17","ରେ କାନା ଆଲାଜୁଇଂ ସୁନା ମ୍ନାଲେ ସୁନାକେ ପବିତ୍ର ଆଃଡିଂମ୍ୟାକ୍ନେ ମନ୍ଦିର୍‍ ମ୍ନା ?” ");
INSERT INTO gaq_vpl VALUES ("MT23_18","070_23_18","MAT","23","18","18","ପେ ସିକ୍ୟା ବିପେମ୍ୟାକେ ଜେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ପୁଜାବେଦି ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଲା ମେଁ ଆତେନ୍‌ ପାଲେନ୍‍ସା ବାଦ୍ୟ ଣ୍ଡୁ । ମାତର୍‌ ପୁଜାବେଦି ଆଡ଼ାତ୍ରା ବକ୍ନେ ନୈବେଦ୍ୟ ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଲା ଆତେନ୍‌ ଡିଲାଡିଗ୍ ମାନେଃ ପଡ଼େଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_19","070_23_19","MAT","23","19","19","ରେ କାନାଇଂ । ଆଣ୍ଡିନେ ମ୍ନା । ନୈବେଦ୍ୟ ଲେଃ ନୈବେଦ୍ୟକେ ପବିତ୍ର ଆଃଡିଂମ୍ୟାକ୍ନେ ବେଦି ? ");
INSERT INTO gaq_vpl VALUES ("MT23_20","070_23_20","MAT","23","20","20","ତେସା ଜାଣ୍ଡେ ବେଦି ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଲା ମେଁ ବେଦି ଆରି ମେଁ ଆଡ଼ାତ୍ରା ଲେଃକ୍ନେ ସାପା ନୈବେଦ୍ୟ ଜିନିସ୍‍ଇଂନେ ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_21","070_23_21","MAT","23","21","21","ଜା ମନ୍ଦିର୍‍ ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଲା ମେଁ ମନ୍ଦିର୍‌ନେ ଆରି ଆତ୍‌ଅରିଆ ବାସା ମ୍ୟାଃକ୍ନେ ଇସ୍‌ପର୍ ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_22","070_23_22","MAT","23","22","22","“ଜା କିତଂ ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଲା ମେଁ ଇସ୍‌ପର୍‌ନେ ସିଂଆଁସନ୍‍ ଆରି ଆତ୍‍ ଅରିଆ କଲେଃକ୍ନେ ଇସ୍‌ପର୍‌ନେ ମ୍ନିରେ ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT23_23","070_23_23","MAT","23","23","23","“ଅ ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂ ପେନେ ଗଟ୍‌ନା ଉଡ଼ି ବୟ୍‍ଙ୍କାର୍‍ ! ପେ ଇସ୍‌ପର୍‌ନେ ଉଦେସ୍‍ରେ ପୋଦିନା ଉଲିଆଃ ପାନ ମହୁରୀ ଆରି ଜିରାକେ ଡିଗ୍ ଗୁଆବାଗ୍ ବାନ୍ ମୁଇଙ୍ଗ୍ ବାଗ୍ ବିଃଲାଲାପା; ମାତର୍‌ ନ୍ୟାୟ୍ ଦୟା ବିସ୍‌ବାସ୍‌ରେ ଆକେନ୍ ସାପା ନିୟମ୍‌ନେ ମ୍ନା ମ୍ନା ସାମୁଆଁଇଂ ଆନ୍‌ତାର୍‌ ବିପେଡିଙ୍ଗ୍‌କେ । ନିୟମ୍‌ନେ ଆକେନ୍ ସାମୁଆଁ ସାପା ପର୍‍ତୁମ୍‍ ଅବ୍ୟାସ୍ ଡିଙ୍ଗ୍‌ନେ ପଡ଼େଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_24","070_23_24","MAT","23","24","24","ରେ ତାଙ୍ଗ୍‍କିକ୍‍ ଗାଲି ୱେନେ ରେମୁଆଁଇଂ ପେ ମେଃଡିଗ୍ ଉଗ୍‍କେଲା ମାରିଆଃ ଆତ୍‌ଅରିଆ ବଃଉଂ ଲଃଲେଏ ଡାଗ୍‌ଚେ ଆମେକେ ଚିଗ୍‍ଡିଆଚେ ପେବଏ । ମାତର୍‌ ପେ ମୁଇଂ ମୁଇଂ ଉଟ୍‍କେ କ୍ଲିଗ୍‌ଡା କୁଲୁଗ୍‍ଚେ ଚଙ୍ଗ୍‍ବି ପେମ୍ୟାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT23_25","070_23_25","MAT","23","25","25","“ଉଡ଼ି ବୟ୍‍ଙ୍କାର୍‍ ପେନେ ଗଟ୍‌ନା, ରେ କପଟି ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂ ! ପେ ଉଃସ୍ନିଆଃ ଏତେ ତାଲିନେ ଆଡ଼ାତ୍ରା ପାକା ସ୍ୟା ପେମ୍ୟାକେ, ମାତର୍‌ ଆତେନ୍‌ ବିତ୍ରେ ଇଙ୍ଗ୍‌ସା ଆରି ପୁଲେଡ଼େଗ୍‍ ତ୍ନଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_26","070_23_26","MAT","23","26","26","କାନା ଫାରୁଶୀଇଂ ! ଙ୍କୁଇନେ ବିତ୍ରେ ସେନୁଗ୍ ସ୍ୟାଃପା, ତେଲା ଆଡ଼ାତ୍ରାନେ ଡିଗ୍ ପର୍‌ଚଲ୍‌ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT23_27","070_23_27","MAT","23","27","27","“ରେ କପଟି ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂ ! ପେ ବଡ଼େ ବୟ୍‍ଙ୍କାର୍‍ କସ୍ଟ ପେବାଏ । ପେ ସାପାରେ ଙ୍କୁଇ ଆଡ଼ାତ୍ରା ପାକା ସ୍ୟାଃ ପେମ୍ୟାକେ, ମାତର୍‌ ବିତ୍ରେ ଗୁଏଃରେଇଂନେ ଞ୍ଚିୟା ଆରି ରୁବୁଗ୍‌କ୍ନେ ଗାଗ୍‌ଡ଼େ ବର୍ତି ଡିଙ୍ଗ୍‌ଲେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_28","070_23_28","MAT","23","28","28","ଆଡ଼ାତ୍ରାପାକା ଆକେନ୍‍ଇଂ ସବା ତ୍ନାଏ, ମାତର୍‌ ବିତ୍ରେ ଞ୍ଚିଆ ଆରି ରୁବୁଗ୍‌କ୍ନେ ମଡ଼ା ସୁଗୁଆ ବର୍ତି ଡିଙ୍ଗ୍‌ଲେଏ । ଦେତ୍‌ରକମ୍ ପେ ପାଦାପାକା ସାପାରେନେ ସେନୁଗ୍‍ ଦରମ୍‌ ପେରାସୁଏଃଏ, ମାତର୍‌ ପେ ବିତ୍ରେ କୁଟ୍ ଆରି ପାପ୍‍ରେ ତ୍ନ ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT23_29","070_23_29","MAT","23","29","29","“ରେ ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀଇଂ ! ରେ ଚାଲାକି ଦାର୍‍ମିକ୍‍ ବୟାଁଇଂ ! ପେ ଆତ୍‍ଲା ଆକେନ୍ ଉଡ଼ି ବୟାଙ୍କାର୍‌ । ବାବବାଦି‍ଇଂ ନ୍‌ସା ପେ ସବାକ୍ନେ ରାଚ୍ୟା ଆରେ ପେଡିଙ୍ଗ୍‌କେ ଆରି ଦାର୍‍ମିକ୍‍ଇଂକେ ମନେ ତ୍ଲାଗ୍‍ନ୍‍ସା ଗୁଡ଼ୁମ୍‍ ନ୍ନିଆ ଗୁଆର୍‍ ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_30","070_23_30","MAT","23","30","30","ବାରି ପେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍‌କେ, ଜଦି ପେନେ ନ୍ତା ଞ୍ଜାଇଂନେ ବେଲା ପେ ପେପାଲେଃ, ତେଲା ମେଁଇଂନେ ସୁଗୁଆ ବେବ‍ଆର୍ ପେପାଡିଙ୍ଗ୍‌ ଣ୍ଡୁ ଣ୍ତୁଲା ବାବବାଦି‍ଇଂକେ ପେବାଗୁଏଃ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT23_31","070_23_31","MAT","23","31","31","ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କ୍ନେ ବାନ୍ ପେ ମେଁ ସୁଗୁଆ ବାସଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍କେ ଜେ ପେ ବାବବାଦି‍ଇଂକେ ବାଗୁଏଣ୍ଡ୍ରେଇଂନେ କୁଲ୍‍ଇଂ । ତେନ୍‌ ବିସୟ୍‌ରେ ପେ ଆଃ ନିଜର୍‌ ନିଜର୍‌ ବିସୟ୍‌ରେ ସାକି ବିଃପେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT23_32","070_23_32","MAT","23","32","32","ତେଲା ପେ ସେନୁଗ୍‍ ଅଲେଙ୍ଗ୍‌ପା ପେନେ ପେନ୍ତା ପେଞ୍ଜାଇଂନେ ମାରାଡାକ୍ନେ କାମ୍‍କେ ଆଡା ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT23_33","070_23_33","MAT","23","33","33","“ରେ ବୁବଃଇଂ ! ବିସ୍‌ ଲେଃକ୍ନେ କୁଲ୍‍ଇଂ ! ନର୍କେନେ ଡଣ୍ଡ୍‍ବାନ୍‍ ରକ୍ୟା ନେବାଏ ଡାଗ୍‌ଚେ ଡିରକମ୍ ଆସା ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MT23_34","070_23_34","MAT","23","34","34","ଆତେନ୍‌‌ସା ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ; ପେ ଡାଗ୍ରା ବାବବାଦି‍ଇଂ ବୁଦି ବିନେ ଗୁରୁ ଆରି ଜ୍ଞାନି ରେମୁଆଁଇଂକେ ମ୍ୱେଏ । ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ଉଡ଼ିରୁଆକେ ପେ ପେବାଗୁଏଃଏ ଆରି ଉଡ଼ିରୁଆକେ କୁରୁସ୍‍ଡାଗ୍ରା ପେରାଡେଏ ଆରି ବିନ୍‍ରେକେ ପାର୍‍ତନା ଡୁଆଇଂକେ ଜାଟି ଏତେ ବଗ୍‍ଚେ ମୁଇଙ୍ଗ୍ ଇନି ବାନ୍ ବାରି ମୁଇଙ୍ଗ୍ ଇନିପାକା ପେନୁଆଁଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_35","070_23_35","MAT","23","35","35","ସାରାସାରି କେଲା ଦାର୍ମିକ୍‌ ହେବଲ ବାନ୍ ମୁଲେଚେ ମନ୍ଦିର୍‍ ବାରି ପୁଜାବେଦି ମଜେ ଗୁଏଃ ଲେଃକ୍ନେ ବରଖିଅନେ ଉଙ୍ଗ୍‌ଡେ ଯିଖରିୟ ଜାକ ସାପା ଦସ୍‍ ଣ୍ଡୁନେ ରେମୁଆଁଇଂନେ ବାଗୁଏଃକ୍ନେ ନ୍‌ସା ପେଇଂ ଡଣ୍ଡ୍‍ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_36","070_23_36","MAT","23","36","36","ନେଙ୍ଗ୍ ସତ୍ ବାବ୍‌ରେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଏନ୍ ସାପା ବାଗୁଏକ୍ନେ ସା ଏନ୍ ଜୁଗ୍‍ନେ ରେମୁଆଁଇଂ ଡଣ୍ଡ୍‍ ବଗେ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT23_37","070_23_37","MAT","23","37","37","ଏ ଯିରୂଶାଲାମ୍ ଏ ଯିରୂଶାଲାମ୍ । ନାଁ ବାବବାଦି‍ଇଂକେ ବାଗୁଏ ନାଡିଙ୍ଗ୍‌କେ ଆରି ଇସ୍‌ପର୍ ବେବକ୍ନେ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍‌ନେ ରେମୁଆଁଇଂକେ ବ୍ରି ଏତେ ଟୁ ପେଡିଙ୍ଗ୍‌କେ । ଗିସେଙ୍ଗ୍‌ ମେଁନେ ଉଙ୍ଗ୍‌ଡେଇଂକେ ଡେନାବୁନ୍ଦେ ସାଚେ ବଗେ ସୁଗୁଆ ପେ ରେମୁଆଁଇଂକେ ନେଙ୍ଗ୍ ଜେବା ଲ୍‌ଲୁଡ଼୍ୟାଃ ଆଲ ରକ୍ୟା ଡିଙ୍ଗ୍‌ନ୍‌ସା ନେଙ୍ଗ୍ ଉଡ଼ିତର୍ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍ମ୍ୱକେ । ମାତର୍‌ ନାଁ ଆନେଙ୍ଗ୍‌କେ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ନ୍‌ସା ନାବିଃକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT23_38","070_23_38","MAT","23","38","38","ତେସା ନାନେ ମନ୍ଦିର୍‍କେ ଆନ୍‌ତାର୍‌ ବିଆର୍‌ଏ ଆରି ଆତ୍‌ଅରିଆ ମେଃଡିଗ୍ ଆଲେଃ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT23_39","070_23_39","MAT","23","39","39","ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଚେ ବ ଣ୍ଡିଙ୍ଗ୍‍କେ, ମାପ୍ରୁନେ ମ୍ନିରେ ଜା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ, ମେଁ ଦନ୍ୟ, ଆକେନ୍ ଅଃନା ଜାକ ପେବାସଙ୍ଗ୍‍କେ, ଆତ୍‌ବାନ୍ ନାଁ ଆନେଙ୍ଗ୍‌କେ ଆରି ଅଃନା କିକେ ନାୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_1","070_24_1","MAT","24","1","1","ଜିସୁ ମନ୍ଦିର୍‌ବାନ୍‌ ତାର୍‌ଚେ ୱେନେ ବେଲା ସିସ୍‍ଇଂ ମନ୍ଦିର୍‍ ଆଡ଼ାତ୍ରା ଲେଃକ୍ନେ ମ୍ନା ମ୍ନା ବ୍ରିପାକା ଜିସୁନେ ମୁଆଃ ଟାନେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT24_2","070_24_2","MAT","24","2","2","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଏବେ ସିନା ଆକେନ୍ ସାପା କେପେଡିଙ୍ଗ୍‌କେ । ନେଙ୍ଗ୍ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ, ଆକେନ୍ ମନ୍ଦିର୍‌ନେ ମୁଇଂଡିଗ୍‍ ବ୍ରି ମେଁ ଆଡ଼ାତ୍ରା ଆଲେଃ ଣ୍ଡୁ । ସାପା ତୁବଃନ୍ନିଆ ମିସେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_3","070_24_3","MAT","24","3","3","ଜିସୁ ଜିତକଣ୍ଡା ଆଡ଼ାତ୍ରା କଲେଃକ୍ନେ ବେଲା ସିସ୍‍ଇଂ ମୁଇଂଜା ଲେଃକେଲା ପାଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାକୁକେ “ଆକେନ୍ ସାପା ଅଃନା ଗଟେଏ ଆନେକେ ବାସଙ୍ଗ୍‌ । ମେଃନେ ଗଟେଲା ନେଁ ନେମ୍ୟାଃଏ ଜେ ନାନେ ପାଙ୍ଗ୍‌ନେ ବେଲା ପିଙ୍ଗ୍‍ଚା ଡିଙ୍ଗ୍‌କେ ଆରି ଆକେନ୍ ଜୁଗ୍‍ ଡାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_4","070_24_4","MAT","24","4","4","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ତରକ୍‍ଚେ ଲାଲାପା । ଜା ଡିଗ୍‌ ଡିରକମ୍ ଆପେକେ ଗାଲିବାନ୍ ଆନୁଆଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT24_5","070_24_5","MAT","24","5","5","ନେଙ୍ଗ୍ ମ୍ନି ସାଚେ ଗୁଲେରେ ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍ଆର୍‌ଏ, ନେଙ୍ଗ୍ କିସ୍‌ଟ । ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ମେଇଂ ଗୁଲେରେକେ ଗାଲିବାନ୍ ଜତ୍‍କତ୍‍ ଆଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_6","070_24_6","MAT","24","6","6","ପେଇଂ ଡାଗ୍ରା ୱିଙ୍ଗ୍‌ଆ ରିଙ୍ଗ୍‍ଆନେ କିରମର ପେଅଁଏ ଆରି ସ୍ଲପାକା ଡିଙ୍ଗ୍‌ଡିଂକ୍ନେ କିରମରନେ କବର୍ ପେଅଁଏ । ମାତର୍‌ ତାନ୍ଦ୍ରା ଆଡିଙ୍ଗ୍‌ପା । ଡେକ୍‌ରକମ୍ ସାପା ପାକା ଗଟେଏ । ମାତର୍‌ ଆକ୍‌ମେନେ ଅର୍‌ତ ଦେକ୍ ଣ୍ଡୁ ଜେ ଜୁଗ୍‌ ଡାନେ ବେଲା ପିଙ୍ଗ୍‍ଚା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT24_7","070_24_7","MAT","24","7","7","ଦେସ୍ ଦେସ୍ ବିତ୍ରେ ଜୁଦ୍‌ ଡିଙ୍ଗ୍‌ଏ ମୁଇଙ୍ଗ୍ ରାଇଜ୍ ବାରି ମୁଇଙ୍ଗ୍ ରାଇଜ୍ ଆଡ଼ାତ୍ରା ଆକ୍ରମନ୍‍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ସାପାପାକା ମୁର୍‍ଡି ଆରି ବୁମିକମ୍ପ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_8","070_24_8","MAT","24","8","8","ମାତର୍‌ ଆକେନ୍ ସାପା ସେଲାମ୍ବୁଏନେ ଣ୍ଡିଆ କୁମାନେ ବେଲା ଦୁକା ସୁକା ଆରାମ୍‍ ଡିଙ୍ଗ୍‌ନେ ମାତର୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_9","070_24_9","MAT","24","9","9","“ପେଇଂ ଦାରା ପଡ଼େଚେ କସ୍ଟ ପେବାଏ ଆରି ପେଗୁଏଃଏ ବାରି ନେଙ୍ଗ୍‍ନେ ମ୍ନି ନ୍‌ସା ପେ ସାପାରେନେ ଆଂକାର୍ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_10","070_24_10","MAT","24","10","10","ଆତେନ୍‌‌ ବେଲା ଗୁଲେରୁଆ ମେଁଇଙ୍ଗ୍‌ନେ ବିସ୍‌ବାସ୍ ଆଅଁ ଆର୍‌ଏ ମେଇଂମେଇଂ ବିତ୍ରେ ଆଂକାର୍ ଡିଙ୍ଗ୍‌ଚେ ମେଇଂମେଇଂ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍‌ଗାତ୍‍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_11","070_24_11","MAT","24","11","11","ଆତେନ୍‌‌ ବେଲା ଗୁଲୁଏ ବଣ୍ଡ ବାବବାଦି ତାର୍‌ଚେ ରେମୁଆଁଇଂକେ କେଚେପେଚେ ଆଡିଙ୍ଗ୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_12","070_24_12","MAT","24","12","12","ଦେକ୍ ରକମ୍ ବାବ୍‌ରେ ଅଦରମ୍ ବଡ଼େ ଡୁଂୱେଏ ଆରି ରେମୁଆଁଇଂନେ ଆଲାଦ୍ ଡିଂନେ ସିତ୍‍ଲି ଡିଙ୍ଗ୍‌ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_13","070_24_13","MAT","24","13","13","ମାତର୍‌ ଜାଣ୍ଡେ ସାରାସାରି ଜାକ ସାହାସ୍ ସାଚେ ଲେଃଏ ମେଁ ପରିତ୍ରାନ୍‍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_14","070_24_14","MAT","24","14","14","ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ସାମୁଆଁରେ ନିମାଣ୍ଡା କବର୍ ସାପା ବାସାବାଦିନେ ରେମୁଆଁ ସତ୍ ସାକି ବିଃନ୍‍ସା ସାପା ମଞ୍ଚ୍‌ପୁର୍‌ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ଆର୍‌ଏ । ଇଡ଼ିଙ୍ଗ୍ ଜୁଗ୍‌ ଡାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_15","070_24_15","MAT","24","15","15","“ବାବବାଦି ଦାନିୟେଲ ବର୍ଣ୍ଣନା ଡିଙ୍ଗ୍‍ବକ୍ନେ ଆତେନ୍‌ ଚରମ ବିବିସିକା ବାରି ମୁଇଂତର୍‌ ପେ ପେକେଏ । ପବିତ୍ର ଜାଗାକେ ଆତାନ୍‌ ଅପବିତ୍ର ଆଡିଙ୍ଗ୍‌ଏ । ଏନ୍ ଅର୍‌ତ ମେଃନେ, ପଡ଼େଣ୍ଡ୍ରେ ବୁଜେପା । ");
INSERT INTO gaq_vpl VALUES ("MT24_16","070_24_16","MAT","24","16","16","ଆତେନ୍‌‌ ବେଲା ଜାଣ୍ଡେଇଂ ଜିଉଦା ପ୍ରଦେସ୍‌ନ୍ନିଆ ଲେଆର୍‌ଗେ ମେଇଂ କଣ୍ଡା ଆଡ଼ାତ୍ରା ଲାଗ୍‍ଡଆର୍‍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT24_17","070_24_17","MAT","24","17","17","ଜାଣ୍ଡେଇଂ ବ୍ଲେସାଂ ଆଡ଼ାତ୍ରା ଲେଃଏ ମେଇଂ ଡୁଆ ବିତ୍ରେ ବାନ୍ ଜିନିସ୍‍ ପତର୍‍ ଡୁଂୱେ ନ୍‍ସା ବୁନ୍ଦେ ଜାର୍‌ଚେ ବେଲା ନସ୍ଟ ଆରାଡିଙ୍ଗ୍‍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MT24_18","070_24_18","MAT","24","18","18","ଜାଣ୍ଡେଇଂ ଲିଜ ୱେଲେ ଆର୍‌ଏ, ନିଜେନେ ସକା ଜଗ୍‍ନ୍‍ସା ଡୁଆ ଆଆଁଣ୍ଡେଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_19","070_24_19","MAT","24","19","19","ଆତେନ୍‌‌ ବେଲା ଗାଗ୍‌ଡ଼େ ଆଃବାଲେଃକ୍ନେ ସେଲାମ୍ବୁଏ ଆରି ବିନ୍‌ ଡାଆଁନେ ଗଡ଼େଅ ଲେଃନେ ସେଲାମ୍ବୁଏଇଙ୍ଗ୍‌ନେ ମାଲେ କଷ୍ଟ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_20","070_24_20","MAT","24","20","20","ଇସ୍‌ପର୍‌କେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ଲାଲାପା ରାସକେଲା ଣ୍ଡୁଲା ପୁଣ୍ଡେନେ ଦିନା ଆପେକେ ଜେନ୍ତିକି ଲାଗ୍‍ଡନେ ଆପଡ଼େ । ");
INSERT INTO gaq_vpl VALUES ("MT24_21","070_24_21","MAT","24","21","21","ଆତେନ୍‌‌ ବେଲା ଦେକ୍‌ରକମ୍ ମ୍ନା କ୍ଲେସ ଗଟେଏ ଜେ ମଞ୍ଚ୍‌ପୁର୍‌ ତିଆର୍ ଡିଙ୍ଗ୍‌କ୍ନେ ବାନ୍ ଏଜାକ ଙ୍କାରେ ଗଟେ ବାରି ଅଃନା ଆଗଟେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT24_22","070_24_22","MAT","24","22","22","ମାତର୍‌ ଏନ୍ ଦୁକ୍‍ନେ ବେଲା ଇସ୍‌ପର୍ ଗଣ୍ତା ଆଡିଙ୍ଗ୍‌ ବିବକେ । ଦେତ୍‌ ଡିଙ୍ଗ୍‌ ଆଲେଃଲା ବାରି ଜାଣ୍ଡେ ମ୍ବ୍ର ଆଲେଃଆର୍ ଣ୍ତୁ । ମାତର୍‌‌ ମେଁନେ ମନ୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂକେ ଆମ୍ୱ୍ର ନ୍‌ସା ଇସ୍‌ପର୍ ଆତାନ୍‌ ବେଲା ଗଣ୍ତା ଆଡିଙ୍ଗ୍‌ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT24_23","070_24_23","MAT","24","23","23","“ଆତେନ୍‌ ବେଲା ଜଦି ଜାଣ୍ଡେ ଆପେକେ ବାସଙ୍ଗ୍ଏ, ଆକ୍‌ଅରିଆ କିସ୍‌ଟ ଲେଃକେ ଆରି ଆତ୍‌ଅରିଆ ମେଁ ଲେଃକେ, ଆମେକେ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT24_24","070_24_24","MAT","24","24","24","ଡାଗ୍ଲା ନିଜ୍‍କେ କିସ୍‌ଟ ଆରି ବାବବାଦି ଡାଗ୍‌ଚେ ବାଲିର୍ ଡିଙ୍ଗ୍‌କ୍ନେ ମିଚୁଆଇଂ ଅଃତେନ୍‌ ବେଲା ତ୍ନା ଆର୍‌ଏ । ମେଇଂ ମ୍ନା ମ୍ନା କାମ୍ ଆରି ଇରିଆତୁଗ୍ ୱେନେ ସୁଗୁଆ କାମ୍ ଆସୁଏଚେ ଇସ୍‌ପର୍‌ନେ ସ୍ରିକ୍ନେ ରେମୁଆଁଇଂକେ ଡିଗ୍ ଜଟେ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_25","070_24_25","MAT","24","25","25","ଅଁପା ଆତେନ୍‌‍ବେଲା ପାଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ନେଙ୍ଗ୍ ଆପେକେ ଆକେନ୍ ସାପା ସାମୁଆଁ ଆମ୍ୟାବି ମ୍ୱକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_26","070_24_26","MAT","24","26","26","“କେଲାପା ମେଁ ବାଲିଲ ଅରିଆ ଲେଃକେ ଡାଗ୍‌ଚେ ଜଦି ରେମୁଆଁ ବାସଙ୍ଗ୍ଏ ଆତ୍‍ ଅରିଆ ଆୱେଗେପା ନାମଃ । ବାରି ଜଦି ମେଇଂ ବାସଙ୍ଗ୍ଏ କେଲାପା ଆକ୍ ଅରିଆ ମେଁ ବୁଃଡ଼ି ଲେଃକେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ଆମେଇଂକେ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MT24_27","070_24_27","MAT","24","27","27","ବିଜ୍‌ଲି ଡିରକମ୍ ପୁର୍ବ ଦିଗ୍‍ବାନ୍‍ ପଶ୍ଚିମ୍ ଦିଗ୍‍ଜାକ କିତଙ୍ଗ୍‍ ଇନିକେ ଆତାର୍‍କିଗ୍‍ ବିଏ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ପାଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_28","070_24_28","MAT","24","28","28","“ଆଣ୍ଡିଅରିଆ ମଡ଼ା ଲଃଲେଏ ଆତ୍‌ଅରିଆ ଚାଃଟିଆଁ ପିଗ୍ଇଂ ରିସିଙ୍ଗ୍‍ ଲେଃଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_29","070_24_29","MAT","24","29","29","“ଆତେନ୍‌ ଦୁକ୍‍ ବାନେ ବେଲା ଡାଡିଂକ୍ନେ ବେଲା ମାରିଆଃତୁଗ୍‌ ସ୍ନି ତାଙ୍ଗ୍‌କିଗ୍ଏ, ଆର୍କେ ବାରି ତାର୍‌କିଗ୍ ଆବି ଣ୍ଡୁ, ଚାଙ୍କୁଆଇଂ କିତଙ୍ଗ୍‍ଇନିବାନ୍‍ ରେଃସ ଲଃଏ ଆରି କିତଙ୍ଗ୍‍ନେ ବପୁଇଂ ଆଙ୍କ୍ ଆନ୍ତ୍ ଡିଙ୍ଗ୍‌ୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_30","070_24_30","MAT","24","30","30","ତେନ୍‌ ଇଡ଼ିଂ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେନେ ଚିନା କିତଙ୍ଗ୍‍ନ୍ନିଆ ତ୍ନାଏ ଆରି ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ତ୍ରିଗ୍‍ଡ୍ୟା ଆଡ଼ାତ୍ରା ବାନ୍ ମ୍ନା ପରାକ୍ରମେ ଆରି ଗୌରବ୍ ଏତେ ପାଙ୍ଗ୍‌ନେ କେଚେ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସାପା ଜାତିନେ ବାସାବାଦିନେ ରେମୁଆଁଇଂ ଅଃ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_31","070_24_31","MAT","24","31","31","ପ୍ନିଇଂ ପିଆର୍‌ଏ ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ନେ ମୁଇଙ୍ଗ୍ କନେ ବାନ୍ ବାର୍‌ମୁଇଂ କନ୍‍ ଜାକ ମେଁନେ ସ୍ରିକ୍ନେ ରେମୁଆଁଇଂକେ ରାସିଙ୍ଗ୍‌ଚେ ଡୁଂପାଙ୍ଗ୍‍ନ୍‍ସା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ମେଁନେ ଦୁତ୍‍ଇଂକେ ବେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_32","070_24_32","MAT","24","32","32","“ଲିୱା ସ୍ଲାଃବାନ୍ ବୁଦି ସିକେପା । ଅନାବେଲା ମେଁନେ କାଚାପତ୍‍ରାଲି କଅଁଲ୍‍ କେନ୍ଦାବାନ୍ ତ୍ମି ଉଲିଆ ପିଲ୍‌କା ଡିଙ୍ଗ୍‌ଏ ବ୍ନଗିସେଙ୍ଗ୍‍ ପାଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ପେଇଂ ମ୍ୟା ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT24_33","070_24_33","MAT","24","33","33","ଟିକ୍ ଦେତ୍‌ରକମ୍ ଆକେନ୍ ସାପା ଗଟ୍‌ନା କେଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ବାଜାର୍‌ନ୍ନିଆ ପିଙ୍ଗ୍‌ଚାକେ ଡାଗ୍‌ଚେ ପେଇଂ ପେମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_34","070_24_34","MAT","24","34","34","ମନେ ବପା, ନିଂ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଏବେ ମ୍ବ୍ରଲେଃକ୍ନେ ରେମୁଆଁଇଂନେ ବାନ୍ ସାପାରେ ଗୁଏନେ ସେନୁଗ୍‍ ଆକେନ୍ ସାପା ବିସୟ୍ ଗଟେୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_35","070_24_35","MAT","24","35","35","କିତଂ ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ ଲପ୍‍ ଡିଙ୍ଗ୍‌ଏ; ମାତର୍‌ ନେଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ଅଃନା ଲପ୍‍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_36","070_24_36","MAT","24","36","36","“ଆତେନ୍‌ ଦିନା ଆତେନ୍‌ ଗଟେନେ ବେଲା ଅଃନା ପାଙ୍ଗ୍‌ଏ ଜାଡିଗ୍ ମ୍ୟାଃ ଆୟା ଣ୍ତୁ । ନିଜେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ବାରି କିତଂନେ ଦୁତ୍‍ଇଂ ଡିଗ୍ ଆତେନ୍‌ ସାମୁଆଁ ଆମ୍ୟାଃଆର୍‌ ଣ୍ଡୁ ମାତର୍‌ ଆବା ଇସ୍‌ପର୍ ମ୍ୟାଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_37","070_24_37","MAT","24","37","37","ନୋହନେ ଦିନାକେଲା ଡିରକମ୍ ଗଟେଲେଗେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ନେ ଦିନା ଡିଗ୍ ଦେତ୍‌ରକମ୍ ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_38","070_24_38","MAT","24","38","38","ବନ୍ୟା ଡିଙ୍ଗ୍‍ନେ ସେନୁଗ୍‍ ନୋହ ଜା‍ଆଜ୍‌ନ୍ନିଆ ୱେଚା ଜାକ ରେମୁଆଁଇଂ ଚଙ୍ଗ୍ ଉଗ୍ ଆରି ବିଏ ଉଡ଼ି କାମ୍‍ରେ ବେମର୍‍ ଡିଙ୍ଗ୍‌ଲେ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT24_39","070_24_39","MAT","24","39","39","ବନ୍ନିଆ ପାଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ଡୁଙ୍ଗ୍‍ଡିୟା ଡୁଂୱେ ଜାକ ମେଁନେ ଗଟେଡିଙ୍ଗ୍‍କେ ମ୍ୟାଲେ ଆର୍‌ଗେ ଣ୍ଡୁ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ନେ ଦିନା ଟିକ୍ ଦେତ୍‌ରକମ୍ ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_40","070_24_40","MAT","24","40","40","ଆତେନ୍‌ ବେଲା ଲିଜ ଡାଗ୍ରା ସ୍ଲେ ମ୍ୟାକ୍ନେ ସେଲାମ୍ବୁଏଇଂବାନ୍ ମୁଇଂଜାକେ ସ୍ରିଚେ ଡୁଂଡଏ । ବାରି ବିନ୍‌ରେକେ ଆନ୍‌ତାର୍‌ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_41","070_24_41","MAT","24","41","41","ମ୍ୱାୟା ସେଲାମ୍ବୁଏ ପ୍ନିଡିର୍‌ ଉଃଡିର୍ ଡିଂଲେଃଆର୍‌ଏ ମେଁଇଂନେ ବିତ୍ରେ ମୁଇଂଜାକେ ସ୍ରିଚେ ଡୁଂଡଆର୍‌ଏ ଆରି ବାରି ମୁଇଂଜାକେ ଆନ୍ତାର୍ ବିଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_42","070_24_42","MAT","24","42","42","“ଏବେ ପେ ଜାଗ୍ରତ୍‍ରେ ଲାଲାପା ଡାଗ୍ଲା ପେନେ ମାପ୍ରୁ ଅଃନା ପାଙ୍ଗ୍‌ଏ ପେ ପେମ୍ୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT24_43","070_24_43","MAT","24","43","43","ଅଃନା ଡଙ୍ଗାରେ ଗାଏ ଆତେନ୍‌ ମ୍ୟା ଲାଃଲେ ଡୁଆନେ ମାଲିକ୍‌ ତରକ୍‌ ଲେଃଚେ ଡଙ୍ଗାରେକେ ଡୁଆ ଆରାଃଗା ଆର୍‌ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT24_44","070_24_44","MAT","24","44","44","ପେଡିଗ୍ କାଲାଆଃ ଜାଗ୍ରତ୍‍ ଡିଙ୍ଗ୍‌ଚେ ଲାଲାପା । ଡାଗ୍ଲା ପେ ଆମେକେ ଉର୍‍ ପେଲେଃକ୍ନେ ବେଲା ମେଁ ପାଙ୍ଗ୍‍ପିଙ୍ଗ୍‍ ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_45","070_24_45","MAT","24","45","45","“ତେଲା ଜାଣ୍ଡେ ବିସ୍‌ବାସ୍ ଆରି ବୁଦିମାନ୍ ଗତିରେ ? ଜା ଆଡ଼ାତ୍ରା ସାଉକାର୍ ବିନ୍ ଗତିରେଇଂକେ ଟିକ୍‍ବେଲା ବଲେ ବାଟାବିଃନେ ଦାଇତ୍‍ ଅଦିକାର୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT24_46","070_24_46","MAT","24","46","46","ମାପ୍ରୁ ପାଙ୍ଗ୍‌ଚେ ମୁଡ଼ି ଗତିରେକେ ଦେତ୍ ରକମ୍ ଡିଙ୍ଗ୍‌କ୍ନେ କେଏ ମେଁ ଦନ୍ୟ । ");
INSERT INTO gaq_vpl VALUES ("MT24_47","070_24_47","MAT","24","47","47","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଦେତ୍‌ରକମ୍ ଗତିରେକେ ସାଉକାର୍ ମୁଇଂଦିନା ଡିଗ୍ ମେଁନେ ସାପା ଦନ୍‌ସମ୍ପତି ମେଁ ଦାଇତ୍‍ରେ ବଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT24_48","070_24_48","MAT","24","48","48","ମାତର୍‌ ଆତେନ୍‌ ଗତିରେ ଜଦି ଅବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଚେ ସାଉକାର୍ ଜିଆଃ ଆୱିଗ୍ ଣ୍ଡୁ ଡାଗ୍‌ଚେ ବାବେଏ ଆରି ");
INSERT INTO gaq_vpl VALUES ("MT24_49","070_24_49","MAT","24","49","49","ବିନ୍ ଗତିରେଇଂକେ ବଗ୍‍ଟୁଚେ ଉଗ୍‍ସାରେ ଏତେ ଚଙ୍ଗ୍‍ଉଗ୍‍ କଆର୍‌ଏ ");
INSERT INTO gaq_vpl VALUES ("MT24_50","070_24_50","MAT","24","50","50","ତେସାଃ ଆତେନ୍‌ ଚାକର୍‌ ଉର୍‍ ଆଲେଃକ୍ନେ ବେଲା ଆରି ମେଁ ଆମ୍ୟାକ୍ନେ ବେଲା ଉଡ଼ିବେଲା ସାଉକାର୍ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ଏ ");
INSERT INTO gaq_vpl VALUES ("MT24_51","070_24_51","MAT","24","51","51","ଆମେକେ ମେଁ ଜାବର୍‌ ସାସ୍ତି ବିଏ । ମେଁ କପଟି ରେମୁଆଁଇଂନେ ଡଣ୍ଡ୍‍ ବଗେଏ ଆରି ସାରାସାରିକେଲା ଅଁ ଅଁଚେ ଗିନିକେ ଗେରିଚିଆଚେ ମେଁନେ ଦିନ୍ ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT25_1","070_25_1","MAT","25","1","1","“ଆତେନ୍‌ ବେଲା କିତଂଇନି ଆଗମନ୍‍ ଦେକ୍‍ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଏ । ଗୁକ୍ଲିଗ୍ ସେଲା ସାପାରେ ମୁଇଂ ମୁଇଂ କୁପିସ ସାଚେ ଙ୍ଗିରେ ପାର୍ତିକେ ଅବାନ୍‌ସା ତାର୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_2","070_25_2","MAT","25","2","2","ମେଁଇଙ୍ଗ୍‌ନେ ବିତ୍ରେ ମାଲ୍‌ରୁଆ ବୁଦି ମାଲେଃଣ୍ଡ୍ରେ ଆରି ମାଲ୍ ରୁଆ ବୁଦିଲେଣ୍ଡ୍ରେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_3","070_25_3","MAT","25","3","3","ବୁଦି ଆଲେଃକ୍ନେ ସେଲାଇଂ କୁପିସ ଡୁଂୱେକେ ମେଁ ଏତେ ଜାବର୍ ଞ୍ଚୁ ଡୁଂଆୱେ ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT25_4","070_25_4","MAT","25","4","4","ବୁଦିଲେକ୍ନେ ସେଲାଇଂ ନିଜର୍ ନିଜର୍ କୁପିସ ଏତେ ଡାବାନ୍ନିଆ ଜବର୍ ଞ୍ଚୁ ଡୁଂୱେ ବଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_5","070_25_5","MAT","25","5","5","ଙ୍ଗିରେ ପାଙ୍ଗ୍‌ନେ ଜିଲମ୍‍ ଡିଙ୍ଗ୍‌ଲା ସେଲାଇଂ ଜୁଗ୍‌ଡିମୁଆଁ ଜୁଗ୍‌ଡିମୁଆଃଚେ ସାପାରେ ଡୁଲେଗ୍‍ ବିଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_6","070_25_6","MAT","25","6","6","“ମଜେ ମିଡିଗ୍‌ବ କିରମରନେ ଅଁଆର୍କେ, ଗିତେ ଙ୍ଗିରେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ, ଏଲାପା ଆମେଇଂକେ ୱା ଡୁଂନେପାଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_7","070_25_7","MAT","25","7","7","ସେଲାଇଂ ତଡ଼ିଆଚେ ନିଜେ ନିଜେନେ କୁପିସକେ ଆର୍ମେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_8","070_25_8","MAT","25","8","8","ଆତେନ୍‌‍ବେଲା ବୁଦି ଆଲେଃକ୍ନେ ସେଲାଇଂ ବୁଦିଲେକ୍ନେ ସେଲାଇଂକେ ବାସଙ୍ଗ୍‌କେ ଆନେକେ ଇତୁଡ଼ା ଞ୍ଚୁ ବିଲାପା । ନେନେ କୁପିସ ଲିଗ୍ ୱେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_9","070_25_9","MAT","25","9","9","“ବୁଦିଲେକ୍ନେ ସେଲାଇଂ ବାସଙ୍ଗ୍‌କେ, ପେ ଆତ୍‍ଲା ଆରି ନେ ଆତ୍‍ଲା ଞ୍ଚୁ ଆଚା ଣ୍ଡୁ । ପେ ଦୁକାନ୍‍ ୱେଚେ ନିଜେ ନିଜେ ଆତ୍‍ଲା ଉଡ଼ିସୁଗୁଆ ଞ୍ଚୁ ବିଆର୍ ଡୁଂପାଙ୍ଗ୍‌ଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_10","070_25_10","MAT","25","10","10","ତେଲା ବୁଦି ଆଲେଃକ୍ନେ ସେଲାଇଂ ଞ୍ଚୁ ବିଆର୍ ନ୍‌ସା ତାର୍‌ଆର୍କେ । ମେଇଂ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଙ୍ଗିରେ ପିଙ୍ଗ୍‌ଚାକେ । ଜାଗ୍ରତ୍‍ରେ ଲେଃକ୍ନେ ମାଲ୍‌ରୁଆ ସେଲାଇଂ ମେଁ ଏତେ ବିହେ ବଜିନ୍ନିଆ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ କାପାଟ୍ ବନ୍ଦ୍ ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_11","070_25_11","MAT","25","11","11","“ଇଡ଼ିଙ୍ଗ୍ ବିନ୍ ସେଲାଇଂ ଆତ୍‌ଅରିଆ ପାଙ୍ଗ୍‌ଆର୍‌କେ । ଏ ମାପ୍ରୁ, ଏ ମାପ୍ରୁ କାପାଟ୍ ରଃବି; ନେ ବିତ୍ରେ ନେୱେଏ ଡାଗ୍‌ଚେ ମେଇଂ କିର ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_12","070_25_12","MAT","25","12","12","ଙ୍ଗିରେ ଉତର୍ ବିକେ, ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ପେ ଜାଣ୍ଡେ ନେଙ୍ଗ୍ ନାମ୍ୟାକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_13","070_25_13","MAT","25","13","13","ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଆଡାଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଜାଗ୍ରତ୍‍ ଡିଙ୍ଗ୍ ଲାଲାପା । ଆତେନ୍‌ ଦିନା ବା ଆତେନ୍‌ ଗଣ୍ଟା ଜାଡିଗ୍‍ ମ୍ୟା ପେୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_14","070_25_14","MAT","25","14","14","“କିତଂଇନି ଡିରକମ୍, ମେଁନେ ଆର୍‌ମୁଇଂ ଉଃସ୍ରା ଅଁପା । ଏନ୍ ସାମୁଆଁ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଗତିରେନେ ନ୍ତିନ୍ନିଆ ମେଁନେ ଦନ୍ ସମ୍ପତି ଆତାର୍‌ଚେ ବିଦେସ୍‍ ୱେନ୍‌ସା ତାର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_15","070_25_15","MAT","25","15","15","ମେଇଙ୍ଗ୍‌ନେ ସ୍ଲେ ଚଙ୍ଗ୍‌ୟାନେ ଇସାବ୍‌ରେ ଆମେଇଂକେ ଉଡ଼ି ଉଡ଼ି ଡାବୁ ରାସିଙ୍ଗ୍‌ଚେ ବିକେ ମୁଇଂଜାକେ ବିକେ ମାଲ୍ ଅଜାର୍ ରୁପା ଡାବୁ ବାର୍‌ମୁଇଂଜାକେ ମ୍ବାର୍ ଅଜାର୍ ଆରି ବାର୍‌ମୁଇଂଜାକେ ମୁଇଂ ଅଜାର୍‍ ଆରି ବିଦେସ୍‍ ତାର୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_16","070_25_16","MAT","25","16","16","ମାଲ୍‍ ଅଜାର୍‍ ଡାବୁ ବାଲେଃକ୍ନେ ଗତିରେ ଆତେନ୍‌ ଦନ୍‍କେ ବେପାର୍‍ ଗାଲି ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ଆରି ମାଲ୍ ଅଜାର୍ ଲାବ୍‍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_17","070_25_17","MAT","25","17","17","ଦେତ୍‌ରକମ୍ ମ୍ବାର୍ ଅଜାର୍ ଡାବୁ ବାଲେଃକ୍ନେ ଗତିରେ ବାରି ମ୍ବାର୍‍ ଅଜାର୍‍ ଡାବୁ ଲାବ୍‍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_18","070_25_18","MAT","25","18","18","ମାତର୍‌ ମୁଡ଼ି ଗତିରେ ମୁଇଙ୍ଗ୍ ଅଜାର୍ ବାଲେଗେ ମେଁ ମୁଇଙ୍ଗ୍ କୁରୁ ଗଃଚେ ସାଉକାର୍‍ନେ ଆତେନ୍‌ ଡାବୁକେ ବୁଡ଼ିଚେ ବଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_19","070_25_19","MAT","25","19","19","“ଜାବର୍‌ ଆର୍‌କେ ଇଡ଼ିଙ୍ଗ୍ ସାଉକାର୍ ପାଙ୍ଗ୍‌କେ ଆରି ଗତିରେଇଂ ଏତେ ଇସାବ୍ କିତାବ୍‍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_20","070_25_20","MAT","25","20","20","ମାଲ୍‍ ଅଜାର୍‍ ରୁପା ଡାବୁ ଡୁଂୱେ ବକ୍ନେ ଗତିରେ ସାଉକାର୍‍କେ ବାରି ମାଲ୍‍ ଅଜାର୍‍ ଡାବୁ ଡୁଙ୍ଗ୍‌ୱେଚେ ବାସଙ୍ଗ୍‌କେ, ସାଉକାର୍ ନାଁ ଆନେଙ୍ଗ୍‌କେ ମାଲ୍‍ ଅଜାର୍‍ ରୁପା ଡାବୁ ବିଃନାବଗେ, ଆକେନ୍ କେଲା, ନେଙ୍ଗ୍ ଆରି ମାଲ୍‍ ଅଜାର୍‍ ଲାବ୍‍ ଡିଙ୍ଗ୍‍ମ୍ୱକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_21","070_25_21","MAT","25","21","21","ମେଁନେ ମାପ୍‌ରୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, ମ୍‌ଣ୍ଡା ଚାକର୍‌ ବାରି ବିସ୍‌ବାସ୍‌ ଚାକର୍‌, ନା ଇକୁଡ଼ା ବିସ୍‌ରେ ବିସ୍‌ବାସ୍‌‌ ନାଡିଂକେସାଃ ନେଙ୍ଗ୍‌ ଆନାକେ ଜାବର୍‌ ବିସୟ୍‌ ଆଡ଼ାତ୍ରା ଦାଇତ୍‌ ମ୍ୱିଏ, ନା ମାପ୍‌ରୁକେ ସାର୍‌ଦାରେ ଗ୍ର‍ଅନ୍‌‌ ଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("MT25_22","070_25_22","MAT","25","22","22","“ମ୍ବାର୍ ଅଜାର୍ ରୁପା ଡାବୁ ଡୁଂୱେବକ୍ନେ ଗତିରେ ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, ଏ ସାଉକାର୍ ନାଁ ଆନେଙ୍ଗ୍ ମ୍ୱାର୍‍ ଅଜାର୍ ବିଃନାବଗେ ନେଙ୍ଗ୍ ଆରି ମ୍ୱାର୍‍ ଅଜାର୍ ଲାବ୍‍ ଡିଙ୍ଗ୍‍ମ୍ୱକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_23","070_25_23","MAT","25","23","23","ସାଉକାର୍ ବାସଙ୍ଗ୍‌କେ ଟିକ୍ ଡିଙ୍ଗ୍ ନାବକେ । ନା ଡିଗ୍ ନେଙ୍ଗ୍‌ନେ ନିମାଣ୍ଡା ଚାକର୍ । ଇକୁଡ଼ା ଦନ୍‍କେ ବିସ୍‌ବାସ୍‌ରେ କାମ୍ ଆଃସୁଏ ନାବ । ଜବର୍ ଦନ୍ ଆନାକେ ନେଙ୍ଗ୍ ରାସିଙ୍ଗ୍‌ଚେ ମ୍ୱିଏ । ଗେଃଲା ନାନେ ସାଉକାର୍ ଏତେ କୁଡ଼େଚେ ସାର୍ଦା ଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("MT25_24","070_25_24","MAT","25","24","24","“ସାରାସାରିକେଲା ମୁଇଂ ଅଜାର୍‍ ରୁପା ଡାବୁ ଡୁଂୱେ ବକ୍ନେ ଗତିରେ ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, ଏ ସାଉକାର୍ ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ ନା ମୁଇଙ୍ଗ୍ ଡାଟ୍ ରେମୁଆଁ । ବିଗ୍‍ ଆବକ୍ନେ ଲିଜନ୍ନିଆ ନା ୱେଃ ନାମ୍ୟାକେ । ଚୁମୁଜା ମାବିଗ୍‍ଚେ କିଆ ରାସିଙ୍ଗ୍‍ ନାମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_25","070_25_25","MAT","25","25","25","ଆତେନ୍‌‍ସା ନେଙ୍ଗ୍ ବୁଟଚେ ନାନେ ରୁପା ଡାବୁକେ ଡୁଂୱେଚେ ତୁବଃନ୍ନିଆ ଆତିଚେ ମ୍ବଗେ । କେଲା ନାଁ ନାବିଃକ୍ନେ ଆତେନ୍‌ ରୁପା ଡାବୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_26","070_25_26","MAT","25","26","26","“ସାଉକାର୍ ବାସଙ୍ଗ୍‌କେ, ପଟ୍‍କାର୍‍ ଆରି ଦୁସ୍‌ଟ ଗତିରେ ! ନା ଡି ମ୍ୟାନାଲେକେ ନେଙ୍ଗ୍ ଆଣ୍ଡି ବିଗ୍‍ନ୍ନାବ, ଆତ୍‌ଅରିଆ ନେଙ୍ଗ୍ ଉଁୱେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MT25_27","070_25_27","MAT","25","27","27","ତେଲା ନେଙ୍ଗ୍ ରୁପା ଡାବୁ ଡୁଂୱେଚେ ନାନେ କଲନ୍ତର୍ ନ୍‌ସା ରାସିଙ୍ଗ୍‌ଚେ ନାପାବ । ତେଲା ନେଙ୍ଗ୍ ଆମେକେ ପିଲ୍‍ ଏତେ ମ୍ପାବା ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_28","070_25_28","MAT","25","28","28","ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ସାଉକାର୍ ଆଦେସ୍‍ ବିକେ, ଆକେନ୍ ଗତିରେନେ ନ୍ତିବାନ୍‍ ଆକେନ୍ ରୁପା ଡାବୁ ଡୁଂୱେଚେ ଜା ଅରିଆ ମାଲ୍‍ ଅଜାର୍‍ ଲେଃକେ, ଆମେକେ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("MT25_29","070_25_29","MAT","25","29","29","ଡାଗ୍ଲା ଜାନେ ଲେଃକେ ଆମେକେ ଅଦିକା ବିଏ ଆରି ମେଁନେ ଅଗ୍ଲେ ଚଗ୍ଲେ ଡିଙ୍ଗ୍‌ୱେଏ । ମାତର୍‌ ଜାନେ ଣ୍ଡୁ ମେଁନେ ଜା ସାପା ଲେଃକେ ଆତେନ୍‌ ସାପା ଡିଗ୍ ଜଗ୍‍ ଡୁଂଡଏ । ");
INSERT INTO gaq_vpl VALUES ("MT25_30","070_25_30","MAT","25","30","30","ଆକେନ୍ ଦର୍‌କାର୍ ଣ୍ଡୁନେ ଚାକର୍‌କେ ତାଙ୍ଗ୍‌କିଗ୍ ପାଦାପାକା ଡୁଂୱେଲାପା । ଆତ୍‌ଅରିଆ ମେଁ ଅଁ ଅଁଚେ ଗିନିକେ ଗେରିଚିଆ । ");
INSERT INTO gaq_vpl VALUES ("MT25_31","070_25_31","MAT","25","31","31","“ଉଡ଼ିବେଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଇଃସାଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ଚେ ମେଁନେ କିତଂ ଦୁତ୍‍ଇଂ ଏତେ ପାଙ୍ଗ୍‌ଏ ମେଁ ଗୌରବ୍‍ ତାର୍‍କିଗ୍‌କ୍ନେ ସିଂଆଁସନ୍‍ ଅରିଆ କଏ ");
INSERT INTO gaq_vpl VALUES ("MT25_32","070_25_32","MAT","25","32","32","ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସାପା ବାସାନେ ରେମୁଆଁଇଂ ମେଁନେ ଡାଗ୍ରା ରିସିଙ୍ଗ୍ ଆର୍‌ଏ । ଆତେନ୍‌‍ବେଲା ମେଣ୍ଡା ତୁର୍‍ତିଆରେ ଡିରକମ୍ ଗିମିଃ ଆରି ମେଣ୍ଡାଇଂକେ ବିନେ ଆଡିଙ୍ଗ୍ ବିଏ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଦେତ୍‌ରକମ୍ ରେମୁଆଁଇଂକେ ମ୍ୱାର୍‍ ଦଲ୍‍ ଆଡିଙ୍ଗ୍‌ଚେ ବାଟାଏ । ");
INSERT INTO gaq_vpl VALUES ("MT25_33","070_25_33","MAT","25","33","33","ଦାର୍‍ମିକ୍‍ ରେମୁଆଁଇଂକେ ମେଁ ଇଂଚଙ୍ଗ୍‌ତି ପାକା ଆରି ବିନ୍‍ରେକେ ମେଁନେ ବେସ୍ୟାତି ପାକା ବଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_34","070_25_34","MAT","25","34","34","ତେନ୍‌ ଇଡ଼ିଂ ମେଁନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଇଃସାଙ୍ଗ୍‌ ବାସଙ୍ଗ୍ଏ ଗେଲାପା ଆପେକେ ନେଙ୍ଗ୍‌ନେ ଆବା ଆସିର୍ବାଦ୍ ଡିଙ୍ଗ୍‍ବକେ । ମଞ୍ଚ୍‌ପୁର୍‌ ତିଆର୍ ଡିଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ଆଣ୍ଡିନେ ରାଇଜ୍ ପେନ୍‌ସା ଆର୍ମେଚେ ବକେ ଆତ୍‌ଅରିଆ ପେ ଗାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT25_35","070_25_35","MAT","25","35","35","ନେଙ୍ଗ୍ କେଡ଼େସ ନ୍ଲେଗେ ପେ ଆନେଙ୍ଗ୍‌କେ ପେରାଃଚଙ୍ଗ୍‍କେ; ଆନେଙ୍ଗ୍ ଉଗ୍‍ଡିଆ ଡଡିଙ୍ଗ୍‌ଗେ ପେ ଆନେଙ୍ଗ୍‌କେ ଣ୍ଡିଆ ପେରାଃଉଗ୍‍କେ । ଆନେଙ୍ଗ୍ ଜା ସ୍ନାମୁଆଁ ଆଲେଃଗେ ପେ ଆନେଙ୍ଗ୍‌କେ ଡୁଆ ୱାଚେ ଲେନ୍‍ସା ଜାଗା ପେବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_36","070_25_36","MAT","25","36","36","ନେଙ୍ଗ୍ ଡିକ୍‍ଚା ନ୍ଲେଗେ ଆନେଙ୍ଗ୍ ସକା ପେରାସକେ । ନେଙ୍ଗ୍ ଆଃସି ନ୍ଲେଗେ ନେଙ୍ଗ୍‌ନେ ଜତନ୍ ଡୁଂପେଡକେ । ନେଙ୍ଗ୍ ଜେଲ୍‍କାନା ନ୍ଲେଗେ ଆନେଙ୍ଗ୍ କେନ୍‍ସା ପେପାଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_37","070_25_37","MAT","25","37","37","“ଦାର୍‍ମିକ୍‍ଇଂ ଉତର୍ ବିଏ, ମାପ୍ରୁ ! ଅଃନା ଆନାକେ କିଡ଼େସରେ ଲେଃକ୍ନେ କେଚେ ଚଙ୍ଗ୍‌ନେ ନେବିଃକେ ? ଅଃନା ଆନାକେ ଉଗ୍‍ଡିଆ ଡନେ କେଚେ ଣ୍ଡିଆ ଉଗ୍‍ନେ ନେବିଃକେ ? ");
INSERT INTO gaq_vpl VALUES ("MT25_38","070_25_38","MAT","25","38","38","ଅଃନା ନାନେ ସ୍ନାମୁଆଁ ମାଡିଙ୍ଗ୍‌ଚେ ପାଙ୍ଗ୍‌ନେ ବେଲା ଆନାକେ ନେନେ ଡୁଆ ଡୁଂୱେଚେ ଲେନ୍‍ସା ଜାଗା ନେବିଃକେ ? ଆରି ଅଃନା ନାଙ୍ଗ୍‍ଲା ଲେଃ କେଲା ଆନାକେ ସକା ନେରାଃସକେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_39","070_25_39","MAT","25","39","39","ଅଃନା ଆନାକେ ଆଃସି ଆରି ବନ୍ଦି ଡିଙ୍ଗ୍ ନାଲେକ୍ନେ କେଚେ ଆନାକେ ଜତନ୍‌ ନେଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT25_40","070_25_40","MAT","25","40","40","ଇଃସାଙ୍ଗ୍‌ ଉତର୍ ବିଏ ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଏନ୍‌ ନେଙ୍ଗ୍‌ନେ ବୟାଁଇଂବାନ୍‍ ମୁଇଙ୍ଗ୍ ଡାଆଁ ରେମୁଆଁବାନ୍ ଜା ଡିଙ୍ଗ୍ ପେବକେ ଆତେନ୍‌ ନେଙ୍ଗ୍ ଆତ୍‍ଲା ଡିଗ୍ ଡିଙ୍ଗ୍ ପେବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_41","070_25_41","MAT","25","41","41","“ତେନ୍‌ ଇଡ଼ିଂ ବେସ୍ୟାତି ପାକା ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ମେଁ ବାସଙ୍ଗ୍ଏ, ଇସ୍‌ପର୍‌ବାନ୍ ଅବିସାପ୍ ବାଲେଃକ୍ନେ ରେମୁଆଁଇଂ ! ନେଙ୍ଗ୍ ସାର୍ମୁଆଁବାନ୍ ଲାଗ୍‍ଡଲାପା । ସ‍ଏତାନ୍ ଆରି ମେଁନେ ଦୁତ୍‍ଇଂ ଆତ୍‍ଲା ଅଃନା ମାଲିଗ୍‍ନେ ତ୍ଲଃକ୍ନେ ସୁଆ ଆର୍ମେଚେ ବକେ, ଆତ୍‌ଅରିଆ ପେ ୱେଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MT25_42","070_25_42","MAT","25","42","42","ନେଙ୍ଗ୍ କିଡ଼େସ ନ୍ଲେଗେ ପେ ଆନେଙ୍ଗ୍ ଚଙ୍ଗ୍‌ନ୍‌ସା ପେବିକେ । ଆନେଙ୍ଗ୍ ଉଗ୍‍ଡିଆ ଡକେଲା ପେ ଆନେଙ୍ଗ୍ ଣ୍ଡିଆ ପେରାଉଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_43","070_25_43","MAT","25","43","43","ନେଙ୍ଗ୍ ସ୍ନାମୁଆଁ ନାଲେଃଲା ପେ ଡୁଆ ଆନେଙ୍ଗ୍‌କେ ଜାଗା ପେବିକେ ଣ୍ଡୁ । ନେଙ୍ଗ୍ ଡିକ୍‍ଚା ଲେଃକେଲା ଆନେଙ୍ଗ୍‌କେ ପାଟାଏ ପେରାଃଅଡ଼େକ୍‍କେ ଣ୍ଡୁ । ଆଃସି ନ୍ଲେଗେ ଆରି ଜେଲ୍‍କାନା ଲେଃକେଲା ନେଙ୍ଗ୍‌ନେ ଜତନ୍ ଡୁଂପେଡକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT25_44","070_25_44","MAT","25","44","44","ଆତେନ୍‌‍ବେଲା ମେଇଂ ଉତର୍ ବିଆର୍‌ଏ ମାପ୍ରୁ ଅଃନା ଆନାକେ କିଡ଼େସ କେଲା, ଉଗ୍‍ଡିଆ ଡକେଲା ଆରି ସ୍ନାମୁଆଁ ଆଲେ କେଲା, ଡିକ୍‍ଚା ଲେଃକେଲା, ଆଃସି ଆରି ଜେଲ୍‍କାନା ଲେଃକ୍ନେ କେଚେ ନେ ଆନାକେ ଜତନ୍‍ ନେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MT25_45","070_25_45","MAT","25","45","45","“ଇଃସାଙ୍ଗ୍‌ ଉତର୍ ବିଏ, ନେଙ୍ଗ୍ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଆକେନ୍ ଡାଆଁ ରେମୁଆଁଇଂବାନ୍‍ ମୁଇଂଜାକେ ସାଇଜ ଡିଙ୍ଗ୍‍ନେସା ମନା ଡିଙ୍ଗ୍‌କେଲା ପେ ଆନେଙ୍ଗ୍‌କେ ସାଇଜ ଡିଙ୍ଗ୍‌ନ୍‌ସା ରାଜି ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT25_46","070_25_46","MAT","25","46","46","ଏନ୍‌ ରେମୁଆଁଇଂ ସାପାଦିନା ନ୍‍ସା ଡଣ୍ଡ୍‍ ବଗେ ଆର୍‌ଏ ଆରି ଦାର୍‍ମିକ୍‍ଇଂ ମାଡାନେ ଜିବନ୍ ଲାବ୍‍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_1","070_26_1","MAT","26","1","1","ଆକେନ୍ ସାପା ବୁଦି ବିଃ ଆଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍‍ଇଂକେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT26_2","070_26_2","MAT","26","2","2","“ପେ ମ୍ୟା ପେଲେକେ ଉଦାର୍ ପାଣ୍ଡୁଏ ଡିଙ୍ଗ୍‌ନେ ଆରି ବାର୍‍ସି ଲେଃକେ । ଆତେନ୍‌‍ବେଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ଗୁଏନ୍‍ସା ଅପେଃ ବିଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_3","070_26_3","MAT","26","3","3","ଆକେନ୍ ବେଲା ମ୍ନା ଜାଜକ୍‍ ଆରି ବିନ୍‌ବିନ୍ ଜିହୁଦି ନେତାଇଂ ମ୍ନା ଜାଜକ୍‍ କୟାଫାନେ ଡୁଆ ନ୍ନିଆ ରିସିଙ୍ଗ୍‍ଚେ ");
INSERT INTO gaq_vpl VALUES ("MT26_4","070_26_4","MAT","26","4","4","ଜିସୁକେ ଚାଲାକିରେ ସାଚେ ବାଗୁଏ ବିଃନ୍‍ସା ଉପାୟ୍‍ ତୁର୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_5","070_26_5","MAT","26","5","5","ମାତର୍‌ ମେଇଂ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ କାମ୍ ନେନେ ପାଣ୍ଡୁଏ କେଲା ଡିଙ୍ଗ୍‌ନେ ବଲ୍ ଣ୍ଡୁ । ଆତେନ୍‌ କେଲା ରେମୁଆଁଇଂ ବିତ୍ରେ କିରମର ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_6","070_26_6","MAT","26","6","6","ମେସୁଆ ଜିସୁ ବେଥନୀନ୍ନିଆ ଅଃସେବାନ୍‌ ଆଃ କୁଷ୍ଟରଗ୍ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ଶିମୋନ୍ ଡୁଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_7","070_26_7","MAT","26","7","7","ଶିମୋନ ଡୁଆ ଜିସୁ ଚଙ୍ଗ୍‍ଉଗ୍‍ କଲେ କେଲା ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୁଏ ମୁଇଙ୍ଗ୍ ତୁଲୁଏ ବିର୍‌ ଏତେ ଆରେକ୍ନେ ମୁତାନ୍ନିଆ ଜାବର୍‌ ଦାମ୍‍ନେ ବାସ୍ନାଚୁ ଆତ୍ନଚେ ଜିସୁନେ ବାଆ ଆଡ଼ାତ୍ରା କିଗ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_8","070_26_8","MAT","26","8","8","ସିସ୍‍ଇଂ ଆକେନ୍ କେଚେ ଗିସେଆର୍‌କେ । ମେଇଂ ଆମେକେ ସାଲ୍ୟାକୁକେ “ଅଃକେନ୍ ଞ୍ଚୁ ମେଁନ୍‌ସା ନସ୍ଟ ନାରାଡିଙ୍ଗ୍‍କେ ? ");
INSERT INTO gaq_vpl VALUES ("MT26_9","070_26_9","MAT","26","9","9","ଏନ୍ ବାସ୍ନାଚୁ ଜାବର୍ ଡାବୁରେ ସ ପାଡିଙ୍ଗ୍‌ ବାରି ଆତେନ୍‌‌ ଡାବୁ ଗରିବ୍ ରେମୁଆଁଇଂକେ ବାଟା ବିଃ ପାଡିଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_10","070_26_10","MAT","26","10","10","ମେଇଂ ମେଁନେ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଜିସୁ ମ୍ୟାଚେ ବାସଙ୍ଗ୍‌କେ, “ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃକେ ମେଁନ୍‌ସା ଅଇରାନ୍ ଆଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ? ନେଙ୍ଗ୍ଆତ୍‍ଲା ମେଁ ମୁଇଙ୍ଗ୍ ନିମାଣ୍ଡା ଆରି ସବାକ୍ନେ କାମ୍ ଡିଙ୍ଗ୍‍ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_11","070_26_11","MAT","26","11","11","ଅର୍‍କିତ୍‍ ରେମୁଆଁଇଂକେ ପେ କାଲାଆଃ ପେଅବାଏ । ମାତର୍‌ ଆନେଙ୍ଗ୍ କାଲାଆଃ ପେଅବା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT26_12","070_26_12","MAT","26","12","12","ନେଙ୍ଗ୍ ଗାଗ୍‌ଡ଼େ ଆଡ଼ାତ୍ରା ବାସ୍ନାଚୁ କିଗ୍‍ଚେ ମେଁ ଆନେଙ୍ଗ୍‌କେ ଗେଃସୁଏଃ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆର୍ମେ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_13","070_26_13","MAT","26","13","13","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଣ୍ତିଙ୍ଗ୍‌କେ, ସାପା ମଞ୍ଚ୍‌ପୁର୍‌ ନ୍ନିଆ ଆଣ୍ଡି ଅରିଆ ଡିଗ୍ ଆକେନ୍ ନିମାଣ୍ଡା କବର୍ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ଆର୍‌ଏ ଆକେନ୍ ସେଲାମ୍ବୁଏଃଅ ମେଃ ଡିଙ୍ଗ୍‍ବକେ, ଆମେକେ ମନେ ତ୍ଲାଗ୍‍ଚେ ମେଁ କାମ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ଡିଗ୍ ବାସଙ୍ଗ୍‌ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_14","070_26_14","MAT","26","14","14","ଜିସୁନେ ଗମ୍ବାର୍ ସିସ୍‍ଇଂବାନ୍‍ ଇଷ୍କରିୟଥ୍ ଜିହୁଦା ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ସିସ୍ ମ୍ନା ଜାଜକ୍‍ଇଂଡାଗ୍ରା ୱେଚେ ସାଲ୍ୟାକୁକେ ");
INSERT INTO gaq_vpl VALUES ("MT26_15","070_26_15","MAT","26","15","15","“ଜିସୁକେ ଆଃସାଃମ୍ବିଲା ଆନେଙ୍ଗ୍ ମେଃନେ ପେବିଏ ?” ମେଇଂ ଆମେକେ ମୁଇଂକୁଡ଼ି ଗୁଆ ରୁପାନେ ଚିର୍‍ଲା ଡାବୁ ଇସାବ୍ ଡିଙ୍ଗ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_16","070_26_16","MAT","26","16","16","ଆତେନ୍‌‍ ଦିନା ବାନ୍ ଜିସୁକେ ମେଁଇଙ୍ଗ୍‌ନେ ନ୍ତିନିଆ ଆସା ବିଃନ୍‍ସା ଜିହୁଦା ଉପାୟ୍‍ ତୁର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_17","070_26_17","MAT","26","17","17","“ଖମିର ସୁନ୍ୟ ରୁଟି” ପାଣ୍ଡୁଏନେ ପର୍‍ତୁମ୍‍ ଦିନା ସିସ୍‍ଇଂ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ସାଲ୍ୟାକୁକେ “ନେ ଆଣ୍ଡିଅରିଆ ନାଁ ଆତ୍‍ଲା ଉଦାର୍ ପାଣ୍ଡୁଏ ବଜି ନେରାଃରେଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MT26_18","070_26_18","MAT","26","18","18","ଜିସୁ ଉତର୍ ବିକେ “ଇନି ୱେଚେ ଆତେନ୍‌ ଆୟାକ୍ନେ ରେମୁଆଁକେ ପେବାସଙ୍ଗ୍‌ଏ ଗୁରୁ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ମେଁନେ ଗୁଏନେ ଦିନା ଡାଗ୍ରା ପିଙ୍ଗ୍‍ଚା ଡିଙ୍ଗ୍‌କେ । ମେଁନେ ସିସ୍‍ଇଂ ଏତେ ପେ ଡୁଆ ମେଁ ଉଦାର୍ ପାଣ୍ଡୁଏଃ ପାଲନ୍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_19","070_26_19","MAT","26","19","19","ଜିସୁ ବାସଙ୍ଗ୍‌କ୍ନେ ଇସାବ୍‌ରେ ସିସ୍‍ଇଂ ଉଦାର୍ ପାଣ୍ଡୁଏନେ ବଜି ତିଆର୍ ଡିଙ୍ଗ୍‍ନେସା ୱେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_20","070_26_20","MAT","26","20","20","ଲମ୍‍ଡିଗ୍‍ଲା ଜିସୁ ଆରି ଗମ୍ବାର୍ ସିସ୍‍ଇଂ ଚଙ୍ଗ୍‍ନେସା କଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_21","070_26_21","MAT","26","21","21","ଚଙ୍ଗ୍ ଉଗ୍ କେଲା ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ପେ ବିତ୍ରେ ବାନ୍ ମୁଇଂଜା ଆନେଙ୍ଗ୍ ବିରଦ୍ ରେମୁଆଁଇଂନେ ନ୍ତିନିଆ ଆସା ବିଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_22","070_26_22","MAT","26","22","22","ସିସ୍‍ଇଂ ବିମକ୍‍ ଡିଙ୍ଗ୍‌ଚେ ମୁଇଂଜା ଇଡ଼ିଙ୍ଗ୍ ମୁଇଂଜା ଡିଙ୍ଗ୍‌ଚେ ଜିସୁକେ ସାଲ୍ୟାକୁଆର୍‌କେ “ମାପ୍ରୁ ନେଙ୍ଗ୍ କି ଆତେନ୍‌ ରେମୁଆଁ !” ");
INSERT INTO gaq_vpl VALUES ("MT26_23","070_26_23","MAT","26","23","23","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଜା ନେଙ୍ଗ୍ ଏତେ ମୁତାନ୍ନିଆ ରୁଟି ଜଣ୍ଡିଆଏ ମେଁ ଆନେଙ୍ଗ୍‌କେ ବିରଦ୍ ରେମୁଆଁଇଂ ଡାଗ୍ରା ଆସା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MT26_24","070_26_24","MAT","26","24","24","ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍କ୍ନେ ଇସାବ୍‌ରେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଗୁଏଃଏ ମାତର୍‌ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ଜା ଆସା ବିଏ ମେଁନେ ଗଟ୍‌ନା ବଡ଼େ ବୟ୍‍ଙ୍କାର୍‍ ଡିଙ୍ଗ୍‌ଏ ! ଅଃନାଡିଗ୍ ଜନମ୍ ଡିଙ୍ଗ୍ ଆଲେଃଲା ମେଁ ଆତ୍‍ଲା ବଲ୍ ପାଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_25","070_26_25","MAT","26","25","25","ମୁଡ଼ି ଜିହୁଦା ଜିସୁକେ ବିରଦ୍ ରେମୁଆଁଇଂ ଡାଗ୍ରା ଆସା ବିବଗେ ମେଁ ତଡ଼ିଆଚେ ସାଲ୍ୟାକୁକେ “ଗୁରୁ ଆନେଙ୍ଗ୍‌କେ କେଚେ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ ତ !” ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ “ନା ତ ଆତେନ୍‌ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_26","070_26_26","MAT","26","26","26","ମେଇଙ୍ଗ୍ ଚଙ୍ଗ୍ ବେଲା ଜିସୁ ଇକୁଡ଼ା ରୁଟି ଡୁଂୱେଚେ । ଆତେନ୍‌ ରୁଟି ନ୍‍ସା ପର୍‌ମେସର୍‌ କିକେ ଦନ୍ୟବାଦ୍ ବିକେ । ରୁଟି ଟିକ୍‌ଚିଚେ ସିସ୍‌ଇଂକେ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍ ରୁଟି ଡୁଙ୍ଗ୍‍ ୱେଲା ଏନ୍‌ ନେଙ୍ଗ୍‌ନେ ଗାଗ୍‌ଡ଼େ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_27","070_26_27","MAT","26","27","27","ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ଆତେନ୍‌ ଉଗ୍‍ନେ ମୁତାକେ ଡୁଂୱେଚେ ଇସ୍‌ପର୍‌କେ ଦନ୍ୟବାଦ୍‍ ବିକେ ଆରି ଆତେନ୍‌ ସିସ୍ଇଂକେ ବିଚେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ସାପାରେ ଆକ୍‌ବାନ୍ ଉଗ୍‍ପା । ");
INSERT INTO gaq_vpl VALUES ("MT26_28","070_26_28","MAT","26","28","28","ଆକେନ୍ ନେଙ୍ଗ୍‌ନେ ମ୍ୟା । ରେମୁଆଁନେ ପାପ୍ କେମା ଡିଙ୍ଗ୍‍ନେସା ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ମ୍ୟାକେ କିଗ୍‍ନେ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ଆତେନ୍‌ ଇସ୍‌ପର୍‌ନେ ତ୍ମି ନିଅମ୍ ଆରାମ୍‍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT26_29","070_26_29","MAT","26","29","29","ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ, ନେଙ୍ଗ୍ ଆବାନେ ରାଜିନ୍ନିଆ ପେଇଂ ଏତେ ତ୍ମିକ୍ନେ ଅଙ୍ଗୁର୍ ରସ୍ ଉଗ୍ ଜାକ ନେଙ୍ଗ୍ ଆରି ଅଃନା ଅଙ୍ଗୁର୍ ରସ୍ ନ୍ନାଉଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_30","070_26_30","MAT","26","30","30","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ମେଇଂ ମୁଇଙ୍ଗ୍ ଦନ୍ୟବାଦ୍ ଅସ୍‌ମାର୍ ସାର୍‌ଚେ ଜିତକଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_31","070_26_31","MAT","26","31","31","ଆତେନ୍‌ ବେଲା ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଏ ମିଡିଗ୍ ପେ ସାପାରେ ଆନେଙ୍ଗ୍‌କେ ଆନ୍‌ତାର୍‌ଚେ ଲାଗ୍‍ପେଡଏ । ସାସ୍ତର୍‌ ନ୍ନିଆ ଗୁଆର୍‍ବକେ, ନେଙ୍ଗ୍ ମେଣ୍ଡା ତୁର୍ତିଆରେକେ ମ୍ୱାଗୁଏଃଏ ଆରି ମେଣ୍ଡାଇଂ ଚିନ୍‍ ଚତର୍‍ ଡିଙ୍ଗ୍‌ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MT26_32","070_26_32","MAT","26","32","32","ମାତର୍‌ ନେଙ୍ଗ୍ ତଡ଼ିଆକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ପେନେ ସେନୁଗ୍‍ ଗାଲିଲୀ ପ୍ରଦେସ୍ ୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_33","070_26_33","MAT","26","33","33","ମାତର୍‌ ପିତର୍ ବାସଙ୍ଗ୍‌କେ, “ବିନ୍ ସାପାରେ ଆନାକେ ଆନ୍‌ତାର୍‌ ୱେଲା ଡିଗ୍‍ ନେଙ୍ଗ୍ ଆନାକେ ଅଃନା ଆନ୍‌ତାର୍‌ଚେ ନ୍ନାୱେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_34","070_26_34","MAT","26","34","34","ଜିସୁ ବାସଙ୍ଗ୍ ବିକେ “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଣ୍ଡିଙ୍ଗ୍‌କେ ଏଃ ମିଡିଗ୍ ଗିସେଙ୍ଗ୍ ଞ୍ଜିତର୍ ସନେ ସେନୁଗ୍‌ ପେ ଆନେଙ୍ଗ୍ ନ୍ନାସାମୁଆଁକେ ଡାଗ୍‌ଚେ ଞ୍ଜିତର୍ ନାବାସଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_35","070_26_35","MAT","26","35","35","ପିତର୍ ଉତର୍ ବିକେ “ଆନେଙ୍ଗ୍ ନାଁ ଏତେ ଗୁଏନେ ପଡ଼େଲା ଡିଗ୍ ନେଙ୍ଗ୍ ଆପେକେ ନ୍ନାସାମୁଆଁକେ ଡାଗ୍‌ଚେ ଅଃନାଡିଗ୍ ନ୍ନାବାସଙ୍ଗ୍ ଣ୍ଡୁ ।” ବିନ୍‍ ସିସ୍‍ଇଂ ସାପାରେ ଦେତୁଆ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_36","070_26_36","MAT","26","36","36","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ସିସ୍‍ଇଂ ଏତେ ଗେଥସିମନୀ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ଜାଗାନ୍ନିଆ ୱେଚେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ଆକ୍‌ଅରିଆ ଇକୁଡ଼ା କଲାଲାପା । ନେଙ୍ଗ୍ ଆତ୍‌ଅରିଆ ଉଲୁପ୍‍ ୱେଚେ ପାର୍‍ତନା ଣ୍ଡିଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_37","070_26_37","MAT","26","37","37","ମେଁ ପିତର୍ ଆରି ଜେବଦୀନେ ମ୍ୱାୟା ଉଙ୍ଗ୍‌ଡେକେ ମେଁ ଏତେ ଡୁଂୱେକେ । ଆତେନ୍‌‍ବେଲା ଜିସୁ ଜାବର୍‌ ଦୁକ୍ କସ୍ଟରେ ଲେଃଚେ ଡିଗ୍, ");
INSERT INTO gaq_vpl VALUES ("MT26_38","070_26_38","MAT","26","38","38","ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‌ନେ ଜିବନ୍ ତାର୍‌ୱେଗେ ସୁଗୁଆ ଲାଗେଡିଙ୍ଗ୍‍କେ । ଆକ୍‌ଅରିଆ ପେ ନେଙ୍ଗ୍ ଏତେ ଉର୍‍ ଲାଃଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_39","070_26_39","MAT","26","39","39","ଜିସୁ ଉଲୁପ୍‍ ସ୍ଲ ୱେଚେ ତୁବଃନ୍ନିଆ ବ୍ରିଙ୍ଗ୍‍ଚେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌କେ “ଏ ଆବା ! ଜଦି ଡିଙ୍ଗ୍‌ଏ ଆକେନ୍ ଦୁକ୍ କସ୍ଟନେ ଉଗ୍‍ନେ ମୁତାକେ ନେଙ୍ଗ୍‌ବାନ୍ ସ୍ଲ ଡୁଂୱେଲା । ମାତର୍‌ ନେଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଣ୍ଡୁ ନାନେ ଇକ୍‌ଚା ପୁରନ୍‍ ଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_40","070_26_40","MAT","26","40","40","ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ଞ୍ଜିରୁଆ ସିସ୍‍ଇଂ ଡାଗ୍ରା ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ଚେ କେକେ ମେଇଂ ଡୁଲେଗ୍‍ଲେଆର୍‌ଗେ । ଜିସୁ ପିତର୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେ ନେଙ୍ଗ୍‍ ଏତେ ମୁଇଂଗଣ୍ଟା ଡିଗ୍ ଉର୍‍ ପେୟାକେ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("MT26_41","070_26_41","MAT","26","41","41","ପରିକ୍ୟାନ୍ନିଆ ଡିରକମ୍ ପେଲଃ ଆତେନ୍‌‍ସା ଉର୍‍ଲେଚେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ପା । ଡାଗ୍ଲା ପେନେ ଆତ୍ମା ରାଜି ମାତର୍‌ ଗାଗ୍‍ଡେ ବଲ୍ ଆଲେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_42","070_26_42","MAT","26","42","42","ଜିସୁ ବାରି ମୁଇଂତର୍ ୱେଚେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍‌ନେ ଆବା ! ଜଦି ଆକେନ୍ ଦୁକ୍ ବଗନେ ଉଗ୍‍ନେ ଙ୍କୁଇ ନେଙ୍ଗ୍‍ ଡାଗ୍ରାବାନ୍‍ ସ୍ଲ ନାରାଡିଙ୍ଗ୍‍ଲା ଆରି ନେଙ୍ଗ୍ ଆତେନ୍‌ ଉଗ୍‍ନେ ବାଦ୍ୟ ନାନେ ଇକ୍‌ଚା ପୁରନ୍‍ ଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_43","070_26_43","MAT","26","43","43","ମେଁ ବାର୍‌ମୁଇଂତର୍‍ ଆଣ୍ଡେ ୱେଚେ ସିସ୍ଇଂକେ ଡୁଲେଗ୍‍ ଲେଃକ୍ନେ କେକେ । ମେଇଂ ମୁଆଃ କିକେନେ ୟା ଆଡିଂଆର୍‌ଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT26_44","070_26_44","MAT","26","44","44","ଜିସୁ ଆମେଇଂକେ ଆନ୍‌ତାର୍‌ଚେ ଉଲୁପ୍‍ ସ୍ଲ ୱେଚେ ଞ୍ଜିତର୍‍ନ୍‍ସା ଦେତ୍‌ରକମ୍ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_45","070_26_45","MAT","26","45","45","ତେନ୍‌ ଇଡ଼ିଂ ସିସ୍‍ଇଂ ଡାଗ୍ରା ୱେଚେ ବାସଙ୍ଗ୍‌କେ “ପେ ଏଜାକ ଡୁଲେଗ୍‍ଚେ ପୁଣ୍ଡେ ପେଡିଙ୍ଗ୍‌କେ ? କେଲାପା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ବିରଦ୍ ରେମୁଆଁଇଂନେ ନ୍ତିନିଆ ଅପେଃବିନେ ବେଲା ପାଙ୍ଗ୍‌ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_46","070_26_46","MAT","26","46","46","ତଡ଼ିଆ ନେୱେପା । ଆକେନ୍ କେଲାପା ଆନେଙ୍ଗ୍ ଆଃସାଃ ବିଃନେ ରେମୁଆଁଇଂ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌ଆର୍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_47","070_26_47","MAT","26","47","47","ଜିସୁ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ବେଲା ମେଁନେ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସିସ୍‍ଇଂ ବିତ୍ରେ ଜିହୁଦା ମ୍ନିକ୍ନେ ସିସ୍‍ ମୁଇଙ୍ଗ୍ ପିଙ୍ଗ୍‌ଚାକେ । ମେଁ ଏତେ କାଣ୍ଡା ଆରି ଟେଙ୍ଗ୍‍ ସାଚେ ଗୁଲେରୁଆ ଆତ୍‍ ଅରିଆ ରିସିଙ୍ଗ୍ ଆର୍‌କେ । ଆମେଇଂକେ ମ୍ନା ଜାଜକ୍‍ ଆରି ଦର୍ମ ନେତାଇଂ ବେବଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_48","070_26_48","MAT","26","48","48","ବିରଦ୍ ରେମୁଆଁଇଂକେ ଆସା ବିଃନେ ଜିହୁଦା ଆମେଇଂକେ ମୁଇଙ୍ଗ୍ ଚିନା ବିଃନ୍‍ସା ଟିକ୍ ଆଡିଙ୍ଗ୍ ବଗେ । ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‍ବଗେ, “ମୁଡ଼ି ରେମୁଆଁକେ ନେଙ୍ଗ୍ ମ୍ୱୟ୍‍ନ୍ତାଏ ଆମେକେ ଆଃ ପେ ତୁର୍ ପେଡିଙ୍ଗ୍‌କେ । ଆମେକେ ପେ ସାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_49","070_26_49","MAT","26","49","49","ଜିହୁଦା ସିଦା ଜିସୁ ଡାଗ୍ରା ୱେଚେ ଆମେକେ ଅ ଗୁରୁ, ନମସ୍କାର୍‌ ଡାଗ୍‌ଚେ ବ‍ଏନ୍ତାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_50","070_26_50","MAT","26","50","50","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ବୟାଁ ନାନେ କାମ୍ ଜିଆଃ ଆଡା ।” ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ମେଇଂ ଜିସୁକେ ସାଚେ ବନ୍ଦି ଆଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_51","070_26_51","MAT","26","51","51","ଜିସୁ ପାକାନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ମେଁ ନିଜେନେ କାଣ୍ଡା ଜଗ୍‍ ଆତାର୍‌ଚେ ମ୍ନା ଜାଜକ୍‍ନେ ଗତିରେନେ ନ୍ଲୁଗ୍‍କେ ସିତଗ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_52","070_26_52","MAT","26","52","52","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନାନେ କାଣ୍ଡାକେ କାଣ୍ଡା ବନେ ଜାଗାନ୍ନିଆ ବ । ଜାଣ୍ଡେଇଂ କାଣ୍ଡା ଏତେ ବ୍ଲୁ ଆର୍‌ଏ ମେଇଂ କାଣ୍ଡା ଏତେ ଆଃ ଗୁଏ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT26_53","070_26_53","MAT","26","53","53","ନାଁ ମେଃନେ ନାମ୍ୟାକେ, ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଆବାକେ ସାଇଜ୍ୟ ନ୍‌ସାଲ୍ୟାଲା ମେଁ ନେଙ୍ଗ୍ ଆତ୍‍ଲା ସାଙ୍ଗେ ସାଙ୍ଗେ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସନ୍ୟଇଂବାନ୍ ଜବର୍ କିତଂ ଦୁତ୍‍କେ ବେୟାଏ ? ");
INSERT INTO gaq_vpl VALUES ("MT26_54","070_26_54","MAT","26","54","54","ତେଲା ଆକେନ୍ ସାପା ଗଟେଏ ଡାଗ୍‌ଚେ ସାସ୍ତର୍‌ନ୍ନିଆ ଆଣ୍ଡିନେ ସାପା ଗୁଆର୍‍ ବକେ ଆତେନ୍‌ ସତ୍ ଡିଙ୍ଗ୍‌ଏ ଡିରକମ୍ ?” ");
INSERT INTO gaq_vpl VALUES ("MT26_55","070_26_55","MAT","26","55","55","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ରିସିଙ୍ଗ୍‍ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ମେଃନେ ମୁଇଂ ଲାଗ୍‍ଡରେ ଦସି ରେମୁଆଁ କାଣ୍ଡା ଟେଙ୍ଗ୍‍ ସାଃଚେ ଆନେଙ୍ଗ୍ ସାଃନ୍‌ସା ପାଙ୍ଗ୍‍ପେଲେକେ ? କାଲାଆଃ ନେଙ୍ଗ୍ ମନ୍ଦିର୍‌ନ୍ନିଆ କଚେ ବୁଦି ବିଃଣ୍ଡିଂଗେ ଆତେନ୍‌ ବେଲା ତ ଆନେଙ୍ଗ୍ ପେସାକେ ଣ୍ଡୁ ! ");
INSERT INTO gaq_vpl VALUES ("MT26_56","070_26_56","MAT","26","56","56","ଆତେନ୍‌ ଆନ୍‍ତାର୍‍ପା ବାବବାଦି‍ଇଂ ସାସ୍ତର୍‌ନ୍ନିଆ ଜା ସାପା ଗୁଆର୍‍ ବକେ ଆତେନ୍‌ ସାପା ପୁରା ଡିଙ୍ଗ୍‍ନେସା ଦେକ୍ ଗଟେଲେକେ ।” ଆତେନ୍‌‍ବେଲା ସିସ୍‍ଇଂ ସାପାରେ ଜିସୁକେ ଆନ୍‌ତାର୍‌ଚେ ଲାଗ୍‍ଡଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_57","070_26_57","MAT","26","57","57","ଜିସୁକେ ଗିରପ୍‍ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେଇଂ ଆମେକେ ମ୍ନା ଜାଜକ୍‍ କୟାଫାନେ ଡୁଆନ୍ନିଆ ଡୁଂୱେ ଆର୍‌କେ । ଆତ୍‌ଅରିଆ ଦର୍ମ ଗୁରୁ ଆରି ଦର୍ମ ନେତାଇଂ ରିସିଙ୍ଗ୍ ଲେଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_58","070_26_58","MAT","26","58","58","ପିତର୍ ଇତୁଡ଼ା ସ୍ଲ ଲେଃଚେ ଜିସୁକେ କିକେଡିଂଗେ ଆରି ମେଁ ମ୍ନାପୁଜାରି କୟାପାନେ ଡୁଆ ବାଜାର୍‍ ଜାକ ୱେକେ । ଆକେନ୍ ସାପା ଗଟ୍‌ନା ମେଃ ଡିଙ୍ଗ୍‌ଏ, ଆତେନ୍‌ କେନ୍‍ସା ପିତର୍ ଆତ୍‌ଅରିଆ ଉର୍‍ଣ୍ଡ୍ରେଇଂ ଏତେ କକେ ! ");
INSERT INTO gaq_vpl VALUES ("MT26_59","070_26_59","MAT","26","59","59","ମ୍ନା ଜାଜକ୍‍ ଆରି ମ୍ନା କୁକପାର୍‌ନେ ରେମୁଆଁଇଂ ଜିସୁକେ ଗୁଏନେ ଡଣ୍ଡ୍‍ ବିଃନ୍‍ସା ମେଁ ବିରଦ୍‌ରେ ମିଚ୍ ପାରାମାନ୍‍ ବାସଙ୍ଗ୍‍ ନ୍‌ସା ଜଜନା ଡିଙ୍ଗ୍‌ଆର୍କେ । ଗୁଲେରୁଆ ଜିସୁନେ ବିରଦ୍‌ରେ ମିଚ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_60","070_26_60","MAT","26","60","60","ମାତର୍‌ ଦେତ୍ ସୁଗୁଆ ମେଃଡିଗ୍ ପାରାମାନ୍‍ ଆମିଲେକେ ଣ୍ଡୁ । ଇଡ଼ିଙ୍ଗ୍ ମ୍ବାୟା ତୁଆଁ ଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT26_61","070_26_61","MAT","26","61","61","ମେଇଂ ବାସଙ୍ଗ୍‌କେ “ଏନ୍‌ ରେମୁଆଁ ବାସଙ୍ଗ୍‌ ବଗେ, ନେଙ୍ଗ୍ ଇସ୍‌ପର୍‌ନେ ମନ୍ଦିର୍‍କେ ପାକ୍‌ଚିଚେ ଜିର୍‍ସି ଇଡ଼ିଙ୍ଗ୍ ଆମେକେ ବାରି ମୁଇଂତର୍ ଆରେ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_62","070_26_62","MAT","26","62","62","ମ୍ନା ଜାଜକ୍‍ ତୁଆଁଚେ ଜିସୁକେ ସାଲ୍ୟାକୁକେ ନା ମେନ୍‌ସାଃ ମେଃଡିଗ୍ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ ? “ଆକେନ୍ ଦାବିକେ ପାକ୍‍ଚିନ୍‍ସା ନାନେ ଆରି ମେଁନେ ବାସଙ୍ଗ୍‌ନେ ଲେଃକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT26_63","070_26_63","MAT","26","63","63","ମାତର୍‌ ଜିସୁ ବୁଙ୍ଗ୍‍ ଲେଃଗେ । ମ୍ନା ଜାଜକ୍‍ ବାସଙ୍ଗ୍‌କେ, “ଜିବନ୍ ଇସ୍‌ପର୍‌ନେ ମ୍ନିରେ ପର୍‍ମାନ୍‍ ଡିଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍ ଆନାକେ ସାଲ୍ୟାକୁ ଣ୍ଡିଙ୍ଗ୍‍କେ, ସତ୍ ବାସଙ୍ଗ୍‌, ନାଁ ମେଃନେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ କିସ୍‌ଟ ବା ମସିହ ?” ");
INSERT INTO gaq_vpl VALUES ("MT26_64","070_26_64","MAT","26","64","64","ଜିସୁ ଉତର୍ ବିକେ “ନାଁ ଟିକ୍ ନାବାସଙ୍ଗ୍‍କେ । ମାତର୍‌ ନେଙ୍ଗ୍ ପେ ସାପାରେକେ ବାସଙ୍ଗ୍‍ମ୍ବକେ ଜିଆଃ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ସାପାଟୁ ବପୁରେ ଇସ୍‌ପର୍‌ନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା କୁକ ନ୍‌ସା ୱେଡିଙ୍କେ ବାରି ଆମେକେ କିତଂବାନ୍ ତ୍ରିଗ୍‍ଡ୍ୟା ଏତେ ଜାର୍‌ନେ ପେ ପେକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_65","070_26_65","MAT","26","65","65","ଆକେନ୍ ଅଁଚେ ମ୍ନା ଜାଜକ୍‍ ନିଜେନେ ସକାକେ ସେଗାର୍‍ଚେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ତ ଇସ୍‌ପର୍‌କେ ନିନ୍ଦା ଆଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ । ଆରି ବିନ୍ ସାକି ଦର୍‌କାର୍ ଣ୍ଡୁ । ଏବେତ ପେ ଇସ୍‌ପର୍‌ନେ ନିନ୍ଦା ପେଅଁକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_66","070_26_66","MAT","26","66","66","ଆକେନ୍ ବିସୟ୍‌ରେ ପେନେ ମନ୍ ମେଃନେ ?” ମେଇଂ ଉତର୍ ବିଃଆର୍‌କେ, “ମେଁ ଦସ୍‍ ଡିଙ୍ଗ୍‍ବକେ ମେଁ ଗୁଏନେ ଡଣ୍ଡ୍‍ ବାନେ ଦର୍‌କାର୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_67","070_26_67","MAT","26","67","67","ଇଡ଼ିଙ୍ଗ୍ ମେଇଂ ଜିସୁକେ ସାର୍ମୁଆଁନ୍ନିଆ ବିତୁର୍‍ଚେ ଆମେକେ ବଗ୍ ଆର୍‌କେ । ଉଡ଼ିରୁଆ ଆମେକେ ଚାପ୍‍ଡ଼ା ବଗ୍‍ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT26_68","070_26_68","MAT","26","68","68","“କିମେ କିସ୍‌ଟ ବା ମସିହ ! ନା ଡିଏଃ ବାବବାଦି । ବାସଙ୍ଗ୍‍ ତ ଜା ଆନାକେ ବଗ୍‌କେ !” ");
INSERT INTO gaq_vpl VALUES ("MT26_69","070_26_69","MAT","26","69","69","ମ୍ନା ଜାଜକ୍‍ନେ ବାଜାର୍‍ ଡାଗ୍ରା ପିତର୍ କଲେ କେଲା ମୁଇଙ୍ଗ୍ ଚାକର୍‌ବ‍ଏଃ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ନାଁ ଡିଗ୍ ଗାଲିଲୀୟ ଜିସୁ ଏତେ ନାଲେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_70","070_26_70","MAT","26","70","70","ମାତର୍‌ ପିତର୍ ସାପାରେନେ ସାମ୍‌ନେ ଆକେନ୍ ସାମୁଆଁ ଅବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ନାଁ ମେଃନେ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ, ନେଙ୍ଗ୍ ମେଃଡିଗ୍ ବୁଜେ ନ୍ନାୟାକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_71","070_26_71","MAT","26","71","71","ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ମେଁ ଆତେନ୍‌ ବାଜାର୍‍ନେ ର୍ଣ୍ଣସାଙ୍ଗ୍ ଡାଗ୍ରା ୱେକେ । ବାରି ମୁଇଙ୍ଗ୍ ଚାକର୍ ରାନି ଆମେକେ କେଚେ ଆତ୍‍ ଅରିଆ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ “କିମେ ନାଜରିତିୟ ଜିସୁ ଏତେ ଲେଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_72","070_26_72","MAT","26","72","72","ପିତର୍ ବାର୍‌ମୁଇଂତର୍‍ ଅବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଚେ ପର୍‌ମାନ୍ ତ୍ଲାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ “ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଆତେନ୍‌ ରେମୁଆଁ ନେଙ୍ଗ୍ ନାମ୍ୟାକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_73","070_26_73","MAT","26","73","73","ଉଡ଼ି ବେଲା ଇଡ଼ିଙ୍ଗ୍ ଆତ୍‌ଅରିଆ ଲେଃକ୍ନେ ରେମୁଆଁଇଂ ପିତର୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ନାଁ ସତେଆ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ମୁଇଂଜା । ନାଁ ବାସଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ଅଁଲା ମ୍ୟାନେଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT26_74","070_26_74","MAT","26","74","74","ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ପର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ନେଙ୍ଗ୍ ବ୍ନାଲିର୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଣ୍ଡୁଲା ଇସ୍‌ପର୍ ଆନେଙ୍ଗ୍‌କେ ଡଣ୍ଡ୍‍ ବିଲେ । ଆତେନ୍‌ ରେମୁଆଁକେ ନେଙ୍ଗ୍ ନ୍ନାମ୍ୟାକେ ଣ୍ଡୁ ।” ଅଃତେନ୍‍ ବେଲା ଗିସେଙ୍ଗ୍‍ ସକେ । ");
INSERT INTO gaq_vpl VALUES ("MT26_75","070_26_75","MAT","26","75","75","ଆରି ଜିସୁ ମେଃନେ ବାସଙ୍ଗ୍‌ବଗେ, ପିତର୍‌କେ ମନେ ପଡ଼େକେ: “ଗିସେଙ୍ଗ୍‍ ସନେ ସେନୁଗ୍‍ ଆନେଙ୍ଗ୍‌କେ ନାମ୍ୟାକେ ଡାଗ୍‌ଚେ ନାଁ ଞ୍ଜିତର୍‍ ନାବାସଙ୍ଗ୍‍ଏ ।” ମେଁ ବାଏରେ ୱେଚେ ମନେ ତ୍ଲାଗ୍ ତ୍ଲାଗ୍‌ଚେ ଅଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_1","070_27_1","MAT","27","1","1","ଆମାର୍‍ତଡ଼େ ଞ୍ଜିର୍‍ ଞ୍ଜିର୍‌ନୁଗ୍ ଜିସୁକେ ବାଗୁଏ ବିଃନ୍‍ସା ମ୍ନା ଜାଜକ୍‍ ଆରି ଦର୍ମ ନେତାଇଂ ରାଜି ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_2","070_27_2","MAT","27","2","2","ମେଇଂ ଆମେକେ ସିକ୍‌ଲି ଏତେ ଗାଗ୍‌ଚେ ରୋମ୍ ରାଜ୍ୟକେ ସାସନ୍ ଡିଂଣ୍ଡ୍ରେ ପିଲାତଡାଗ୍ରା ଡୁଂୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_3","070_27_3","MAT","27","3","3","ଉଡ଼ିବେଲା ବିସ୍‌ବାସ୍‌ଗାତ୍ ଜିହୁଦା ଅଁକେ ଜେ ଜିସୁକେ ଡଣ୍ଡ୍‍ବାନେ ଆଦେସ୍‍ ବିବକେ ମେଁ ମନେ ଏତେକେ ଆରି ମ୍ନା ଜାଜକ୍‍ ଆରି ମ୍ନାଃରେକେ ମୁଇଂକୁଡ଼ି ଗୁଆ ରୁପା ଡାବୁ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ବାସଙ୍ଗ୍‌କେ, ");
INSERT INTO gaq_vpl VALUES ("MT27_4","070_27_4","MAT","27","4","4","“ମୁଇଙ୍ଗ୍ ଦସ୍‍ ଣ୍ଡୁନେ ରେମୁଆଁନେ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍ ଗାତ୍‍ ଡିଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍ ଜାବର୍‌ ମ୍ନା ପାପ୍ ଡିଙ୍ଗ୍‍ମ୍ୱକେ ।” ମେଇଂ ଉତର୍ ବିକେ “ନେନେ ଆତ୍‌ଅରିଆ ମେଃନେ ଲେଃକେ ? ଆତେନ୍‌ ନା ନିଜେନେ ସାମୁଆଁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_5","070_27_5","MAT","27","5","5","ଜିହୁଦା ରୁପା ଡାବୁକେ ମନ୍ଦିର୍‍ ବିତ୍‍ରେ ଜଗ୍‍ତ୍ଲାଗ୍‍ଚେ ଲାଗ୍‌ଡକେ ଆରି ଲୁଗଃନ୍ନିଆ ଗେଏଃ ଗାଗ୍‌ଚେ ପାସି ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_6","070_27_6","MAT","27","6","6","ମ୍ନା ଜାଜକ୍‍ଇଂ ରୁପା ଡାବୁକେ ଜଗ୍‍ଚେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ମ୍ୟାନେ ମୁଲ୍ୟ । ଆକେନ୍ ମନ୍ଦିର୍‌ନେ ଡାବୁ ରାସିଙ୍ଗ୍‍ନେ ଉଣ୍ଡିନିଆ ବନେ ନିଅମ୍ ବିରଦ୍ କାମ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_7","070_27_7","MAT","27","7","7","ଆତେନ୍‌ ରୁପା ଡାବୁକେ ଡିରକମ୍ ରାସିଙ୍ଗ୍‌ଚେ ବଆର୍‌ଏ । ଆକେନ୍ ବିସୟ୍‌ରେ ମୁଇଙ୍ଗ୍ ନିସ୍ପତି ଡିଙ୍ଗ୍‌ଚେ କୁମ୍ୱାର୍‌ ଲିଜ ମ୍ନିକ୍ନେ ଇତୁଡ଼ା ଲିଜ ବିଆର୍ ଆର୍‌କେ । ଆକେନ୍ ବିଦେସି ରେମୁଆଁଇଂନେ ରାଚ୍ୟାମ୍ବକେ ଡାଗ୍‌ଚେ ବେବ‍ଆର୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_8","070_27_8","MAT","27","8","8","ଏଃ ଜାକ ଆତେନ୍‌ ଲିଜକେ ମିଆଁ ଲିଜ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_9","070_27_9","MAT","27","9","9","ଆକେନ୍ ବିସୟ୍‌ରେ ବାବବାଦି ଯିରିମିୟ ମେଁନେ ବାସଙ୍ଗ୍‍ବଗେ ଆତେନ୍‌ ସତ୍ ଡିଙ୍ଗ୍‌କେ: “ଜା ମୁଇଂକୁଡ଼ି ଗୁଆ ରୁପା ଡାବୁ ଏତେ ସନ୍‌ସା ଇଶ୍ରାୟେଲନେ ଗୋଗିସିଆଇଂ ରାଜି ଡିଙ୍ଗ୍‌ଲେ ଆର୍‌ଗେ ଆତେନ୍‌ ଡୁଂଡ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_10","070_27_10","MAT","27","10","10","ଆରି ମୁଇଂକୁଡ଼ି ଗୁଆ ରୁପା ଡାବୁରେ ମେଇଂ କୁମ୍ୱାର୍‌ ଲିଜ ବିଆର୍ ଆର୍‌କେ ।” ଆକେନ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ମାପ୍ରୁ ଆନେଙ୍ଗ୍‌କେ ଆଦେସ୍‍ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_11","070_27_11","MAT","27","11","11","ଜିସୁକେ ସାମ୍‌ନେ କେଚେ ରମିୟ ରାଜ୍ୟନେତା ପିଲାତ ଆମେକେ ସାଲ୍ୟାକୁକେ; “ନାଁ ମେଃନେ ଜିହୁଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ?” ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ “ଅଁ ଆତେନ୍‌ ନାଁ ବାସଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_12","070_27_12","MAT","27","12","12","ମାତର୍‌ ମ୍ନା ଜାଜକ୍‍ ଆରି ଦର୍ମ ନେତାଇଂ ଜିସୁ ବିରଦ୍‌ରେ ଦାବି ଡିଙ୍ଗ୍‍ବଲା ମେଁ ମେଃଡିଗ୍ ଆବାସଙ୍ଗ୍‍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT27_13","070_27_13","MAT","27","13","13","ତେସା ପିଲାତ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନାନେ ବିରଦ୍‌ରେ ମେଇଙ୍ଗ୍‌ନେ ଦସ୍‍ ଦାବି ସାପା ନାଁ ମେଃନେ ଅଁ ନାଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MT27_14","070_27_14","MAT","27","14","14","ମାତର୍‌ ଜିସୁ ମେଃଡିଗ୍ ଉତର୍ ଆବିଲା ପିଲାତ ଇରିଆତୁଗ୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_15","070_27_15","MAT","27","15","15","ଉଦାର୍ ପାଣ୍ଡୁଏ କେଲା ରେମୁଆଁଇଂନେ ଇକ୍‌ଚା ଇସାବ୍‌ରେ ରୋମୀୟ ଇଃସାଙ୍ଗ୍‌ ଆଜାକେ ଡିଗ୍ ମୁଇଙ୍ଗ୍ ବନ୍ଦିଆକେ କୁଲାସ୍‍ ଆଡିଙ୍ଗ୍‌ନେ ନିୟମ୍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_16","070_27_16","MAT","27","16","16","ଆତେନ୍‌‍ବେଲା ଜିସୁ ବାରବ୍‍ବା ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ବାଗୁଏଣ୍ଡ୍ରେ ବନ୍ଦି ଡିଙ୍ଗ୍‌ଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_17","070_27_17","MAT","27","17","17","ରିସିଙ୍ଗ୍ ଲେଗ୍ନେ ରେମୁଆଁଇଂକେ ପିଲାତ ସାଲ୍ୟାକୁକେ “ନେଙ୍ଗ୍ ଆଜାକେ କୁଲାସ୍‍ ଆଡିଙ୍ଗ୍‍ବିଏ ଡାଗ୍‌ଚେ ପେନେ ଇକ୍‌ଚା ?” ବାରବ୍‍ବା କିକେ ଲେଃ ଆଜାକେ କିସ୍‌ଟ ଡାଗ୍‍ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌ଏ ଆତେନ୍‌ ଜିସୁକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_18","070_27_18","MAT","27","18","18","ପିଲାତ ନିମାଣ୍ଡା ବାବ୍‌ରେ ମ୍ୟାଲେଃଗେ ଜେ ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷଇଂ ଗିସେ ଡିଙ୍ଗ୍‌ଚେ ଜିସୁକେ ମେଁଇଙ୍ଗ୍‌ନେ ନ୍ତିଡାଗ୍ରା ଅପେଃ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_19","070_27_19","MAT","27","19","19","ପିଲାତ ବିଚାର୍ ଡୁଆ ଡାଗ୍ରା କଲେକ୍ନେକେଲା ମେଁନେ କୁନେଡ଼େ ମୁଇଙ୍ଗ୍ କବର୍ ବେକେ: “ଆତେନ୍‌ ନିର୍ଦସ୍‍ ରେମୁଆଁକେ ମେଃ ଆଡିଙ୍ଗ୍‌ପା । ତୁଗୁଆ ମିଡିଗ୍ ମୁଇଙ୍ଗ୍ ମୁସୁଡ଼ିଙ୍ଗ୍‌ନ୍ନିଆ ମେଁ ଆତ୍‍ଲା ନେଙ୍ଗ୍ ଜାବର୍‌ ଦୁକ୍ ମ୍ୱାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_20","070_27_20","MAT","27","20","20","ମ୍ନା ଜାଜକ୍‍ ଆରି ଦର୍ମ ନେତାଇଂ ବାରବ୍‍ବା କିକେ କୁଲାସ୍‍ ଆଡିଙ୍ଗ୍‌ଚେ ଜିସୁକେ ଗୁଏନେ ଡଣ୍ଡ୍‍ ବିଃନ୍‍ସା ପିଲାତଡାଗ୍ରା ଦାବି ଡିଙ୍ଗ୍‌ନ୍‌ସା ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_21","070_27_21","MAT","27","21","21","ପିଲାତ ବାରି ମୁଇଂତର୍ ରେମୁଆଁଇଂକେ ସାଲ୍ୟାକୁକେ “ଆକେନ୍ ମ୍ୱାୟା ବିତ୍ରେ ନେଙ୍ଗ୍ ଆଜାକେ କୁଲାସ୍‍ ନେଡିଙ୍ଗ୍‌ଏ ଡାଗ୍‌ଚେ ପେନେ ଇକ୍‌ଚା ?” ମେଇଂ ଉତର୍ ବିକେ “ବାରବ୍‍ବା କିକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_22","070_27_22","MAT","27","22","22","ପିଲାତ ସାଲ୍ୟାକୁକେ “ତେଲା ଜିସୁ ଆଜାକେ କିସ୍‌ଟ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ମେଁ ଆଡ଼ାତ୍ରା ନେଙ୍ଗ୍ ମେଃଣ୍ଡିଂଏ ? ଆମେକେ କୁରୁସ୍‍ନ୍ନିଆ ଆଡେପା” ଡାଗ୍‌ଚେ ମେଇଂ ସାପାରେ ୱାସାର୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_23","070_27_23","MAT","27","23","23","ପିଲାତ ସାଲ୍ୟାକୁକେ “ତେଲା ମେଁ ମେଃ ଦସ୍‍ ଡିଙ୍ଗ୍‍ବକେ ?” ମାତର୍‌ ମେଇଂ ବାରି ୱାସାର୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଆମେକେ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ଆଡେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_24","070_27_24","MAT","27","24","24","ଉଡ଼ିବେଲା ପିଲାତ କେକେ ଜେ ଆମେଇଂକେ ବାରି ବାସଙ୍ଗ୍‌ଚେ ମେଁ ଲାବ୍‍ ଆମିଲେ ଣ୍ଡୁ, ମେଁ ବାଦୁଲ୍ ବାରି କିରମର ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂକେ, ଆତେନ୍‌‍ବେଲା ମେଁ ଇତୁଡ଼ା ଣ୍ଡିଆ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ରେମୁଆଁଇଂନେ ସାମ୍‌ନେ ନ୍ତି ଗୁଇତିଚେ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍ ରେମୁଆଁ ଆଗୁଏନ୍‍ସା ନେଙ୍ଗ୍‌ନେ ଦାଇ ଣ୍ଡୁ । ଆକେନ୍ ପେନେ କାମ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_25","070_27_25","MAT","27","25","25","ଆତେନ୍‌‍ସା ସାପା ରେମୁଆଁଇଂ ଉତର୍ ବିକେ “ଜିସୁ ଗୁଏନ୍‍ସା ଦସ୍‍ ବଗେନେ ଲେଲା ଆନେକେ ଆରି ନେନେ ଗଡ଼େଇଂ ଆଡ଼ାତ୍ରା ଆତେନ୍‌ ଦସ୍‍ ବଗେନେ ପଡ଼େଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_26","070_27_26","MAT","27","26","26","ସାରାସାରି ପିଲାତ ବାରବ୍‍ବା କିକେ ଆନ୍‌ତାର୍‌ ବିଚେ ଜିସୁକେ ଚାବୁକ୍‍ ଏତେ ବଗ୍‍ନ୍‍ସା ଆଦେସ୍‍ ବିକେ ତେନ୍‌ ଇଡ଼ିଂ କୁରୁସ୍‍ନ୍ନିଆ ଆଡେନ୍‍ସା ସନ୍ୟଇଂନେ ନ୍ତିନିଆ ଆନ୍‌ତାର୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_27","070_27_27","MAT","27","27","27","ପିଲାତନେ ସନ୍ୟଇଂ ଜିସୁକେ ରମିୟ ଇଃସାଙ୍ଗ୍‌ନେ ପ୍ରାସାଦ୍‍ ବିତ୍ରେ ଡୁଙ୍ଗ୍‌ୱେ ଆର୍‌କେ ଆରି ସାପାରେ ଆମେକେ ଗେରେଚେ ତୁଆଁଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_28","070_27_28","MAT","27","28","28","ମେଁନେ ସକା ତଡୁଂଡଚେ ଆମେକେ ମୁଇଙ୍ଗ୍ ମିଆଁ ବାନାନେ ସକା ଆଃସଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_29","070_27_29","MAT","27","29","29","ଗ୍ରେ ସ୍ଲା ପାଡ଼ୁନେ ମୁଇଙ୍ଗ୍ ମୁକୁଟ୍‍ ଆଃରେଚେ ମେଁନେ ବାଆ ଆଡ଼ାତ୍ରା ଆଃସଃ ବିଃଆର୍‌କେ ଆର୍‌କେ ଆରି ମେଁନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା ମୁଇଙ୍ଗ୍ ଡୁଡୁ ଆସା ବିଃଆର୍‌କେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ସେନୁଗ୍‍ ଆଣ୍ଟୁ ମାଡ଼େଚେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଏ ଜିହୁଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ନମସ୍କାର୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_30","070_27_30","MAT","27","30","30","ମେଇଂ ମେଁ ଆଡ଼ାତ୍ରା ବିଃତୁର୍‌ ଆର୍‌କେ ଆତେନ୍‌ ଡୁଡୁ ଡୁଂୱେଚେ ମେଁନେ ବାଆଃକେ ବଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_31","070_27_31","MAT","27","31","31","ଡେକ୍‌ରକମ୍ ଆମେକେ ପରିହାସ୍‍ ଡିଙ୍ଗ୍‌ଚେ ଆତେନ୍‌ ଇଃସାଙ୍ଗ୍‌ ସଃଲେକ୍ନେ ସକା ତଡୁଂଡଚେ ମେଁନେ ନିଜେନେ ସକା ଆଃସଃଆର୍‌କେ ଆରି ଆମେକେ କୁରୁସ୍‍ଡାଗ୍ରା ଆଣ୍ଡେନ୍‍ସା ଡୁଙ୍ଗ୍‌ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_32","070_27_32","MAT","27","32","32","ମେଇଂ ୱେନେବେଲା ଗାଲିବ କୁରୁଣୀ ଇନିନେ ଶିମୋନ୍ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଅବାକେ ଆରି ସୈନିକ୍‍ଇଂ ଆମେକେ ଜିସୁନେ କୁରୁସ୍‍ ଡୁଙ୍ଗ୍‌ନ୍‌ସା ବାଦ୍ୟ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_33","070_27_33","MAT","27","33","33","ମେଇଂ ଗଲ୍‍ଗଥା ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ଜାଗାଡାଗ୍ରା ୱେଚା ଆର୍‌କେ । ଗଲ୍‍ଗଥାନେ ଅର୍‌ତ କିପ୍‍ରି ରକମ୍‍ନେ ଜାଗା । ");
INSERT INTO gaq_vpl VALUES ("MT27_34","070_27_34","MAT","27","34","34","ଆତ୍‌ଅରିଆ ମେଇଂ ଜିସୁକେ ବୁଚୁଏଃକ୍ନେ ଅଙ୍ଗୁର୍ ରସ୍ ଉଗ୍‌ନ୍‌ସା ବିଃକେ । ଜିସୁ ଆମେକେ ଇତୁଡ଼ା ଚାଲିଃଚେ ବାରି ଆଉଗ୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MT27_35","070_27_35","MAT","27","35","35","ମେଇଂ ଜିସୁକେ କୁରୁସ୍‍ଡାଗ୍ରା ଆଡେଚେ ଲେଟ୍‍ରିକ୍‍ ତ୍ଲାଗ୍‌ଚେ ମେଁନେ ସକାକେ ନିଜର୍ ନିଜର୍ ବିତ୍ରେ ବାଟା ତ୍ଲାଗ୍‌ଚେ ଡୁଂଡ ଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT27_36","070_27_36","MAT","27","36","36","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ ଆତ୍‌ଅରିଆ କଚେ କୁରୁସ୍‍ଡାଗ୍ରା ଆଡେବକ୍ନେ ଜିସୁକେ ଉର୍‍ଲେ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_37","070_27_37","MAT","27","37","37","ମେଁନେ ବିରଦ୍‌ରେ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ଦାବି ଉଲିଆ ମୁଇଙ୍ଗ୍ ଗୁଆର୍‍ଚେ ମେଁନେ ବାଆ ଆଡ଼ାତ୍ରା ବାନ୍ ଇତୁଡ଼ା ସ୍ଲ ଆୱେଜଙ୍ଗ୍‍ ବିଃଆର୍‌କେ: “କିମେ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଜିହୁଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ଜିସୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_38","070_27_38","MAT","27","38","38","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ ମ୍ୱାୟା ଡଙ୍ଗାରେକେ ମୁଇଂଜାକେ ଜିସୁନେ ବେସ୍ୟାତି ପାକା ବାରି ମୁଇଂଜାକେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା କୁରୁସ୍‌ନ୍ନିଆ ଆଃଡେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_39","070_27_39","MAT","27","39","39","ଆତେନ୍‌ ଗାଲି ୱେଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂ ବାଆ ମାୱେଚେ ଜିସୁକେ ଅପମାନ୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT27_40","070_27_40","MAT","27","40","40","“ନା ଡିଏଃ ମନ୍ଦିର୍‍କେ ପାକ୍‌ଚିଚେ ଜିର୍‍ସି ବିତ୍ରେ ଆମେକେ ଆରେ ନାବଗେ । ନାଁ ଜଦି ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ନିଜେକେ ରକ୍ୟା ଡିଙ୍ଗ୍ । କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ବାନ୍ ଜାର୍‌ଚେ ପାଙ୍ଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_41","070_27_41","MAT","27","41","41","ମ୍ନା ଜାଜକ୍‍ ଆରି ଦର୍ମ ଗୁରୁ ଆରି ସାପା ଜାତିନେ ମ୍ନାଃରେଇଂ ଡିଗ୍ ଜିସୁକେ ପରିହାସ୍‍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT27_42","070_27_42","MAT","27","42","42","“ମେଁ ବିନ୍‍ ରେମୁଆଁକେ ରକ୍ୟା ଆଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ ମାତର୍‌ ନିଜେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ଆୟାକେ ଣ୍ଡୁ । ମେଁ ଡିଏଃ ଇଶ୍ରାୟେଲନେ ଇଃସାଙ୍ଗ୍‌ । ଏବେ ଜଦି ମେଁ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରାବାନ୍ ଜାର୍‌ଚେ ପାଙ୍ଗ୍‌ଏ ତେଲା ନେନେ ଆମେକେ ବିସ୍‌ବାସ୍ ନେଡିଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("MT27_43","070_27_43","MAT","27","43","43","ମେଁ ନିଜେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଡିଙ୍ଗ୍‌ଚେ ଇସ୍‌ପର୍ ଆଡ଼ାତ୍ରା ଆସା ଡିଂମ୍ବକେ । ତେଲା ନେଃକେପା, ଇସ୍‌ପର୍‌ ଆମେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ନେସା ରାଜି ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ଲେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_44","070_27_44","MAT","27","44","44","ମେଁ ଏତେ କୁରୁସ୍‍ନ୍ନିଆ ଆଡେ ବକ୍ନେ ଡଙ୍ଗାରେ ଡିଗ୍ ଆମେକେ ଦେତ୍‌ରକମ୍ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_45","070_27_45","MAT","27","45","45","ତୁଗୁଆ ଣ୍ଡୁ ଣ୍ଡିଗ୍ ସ୍ମିକେଲା ସାପା ଦେସ୍‍ପାକା ତାଙ୍ଗ୍‌କିଗ୍ ଡିଙ୍ଗ୍‌ୱେଗେ ଆରି ଆତେନ୍‌ ଞ୍ଜି ଗଣ୍ଟା ଜାକ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_46","070_27_46","MAT","27","46","46","ଲମ୍‍ଡିଗ୍‍ ତିନ୍‍ଟାବେଲା ଜିସୁ କିରଚେ ବାସଙ୍ଗ୍‌କେ “ଏଲି ଏଲି ଲାମା ସବକ୍‌ଥାନୀ ।” ବା “ଏ ନେଙ୍ଗ୍‌ନେ ଇସ୍‌ପର୍, ଏ ନେଙ୍ଗ୍‌ନେ ଇସ୍‌ପର୍, ଆନେଙ୍ଗ୍ ମେଃନ୍‌ସା ନାଆଁନ୍ତାର୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MT27_47","070_27_47","MAT","27","47","47","ଡାଗ୍ରା ତୁଆଁଲେକ୍ନେଣ୍ଡ୍ରେ ଉଡ଼ିରୁଆ ଆକେନ୍ ଅଁଚେ ବାସଙ୍ଗ୍‌କେ “ମେଁ ଏଲୀୟକେ ୱା ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_48","070_27_48","MAT","27","48","48","ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ୱିର୍ ଡୁଂୱେଚେ ବୁଚେଲେକ୍ନେ ରସ୍ ମୁଇଂ ପପ୍‌ସା ରକମ୍‍ନେ ଜଣ୍ଡିଆଚେ ଆମେକେ ଡୁଡୁ ଟିପେ ଗାଗ୍‌ଚେ ଜିସୁକେ ଉଗ୍‌ନ୍‌ସା ଆଚ୍ଲେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_49","070_27_49","MAT","27","49","49","ବିନ୍‍ରେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଲାଃଲାପା,ଏଲୀୟ ଆମେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ନେସା ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ କ୍ଲେ ଣ୍ଡୁ, ନେଃକେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_50","070_27_50","MAT","27","50","50","ଜିସୁ ଆରି ମୁଇଂତର୍ କିରଚେ ଜିବନ୍‌ ଆନ୍ତାର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_51","070_27_51","MAT","27","51","51","ଆତେନ୍‌‍ବେଲା ମନ୍ଦିର୍‌ନ୍ନିଆ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ପର୍ଦା ଆଡ଼ାତ୍ରାବାନ୍ ବୁନ୍ଦେଜାକ ମ୍ୱାର୍‍ ବାଗ୍ ଡିଙ୍ଗ୍‌ଚେ ସେଗାର୍‍ ୱେଗେ । ଆରି ତୁବଃ ପିଡ଼ାର୍‌କେ, କଣ୍ଡାଇଂ ମ୍ବାର୍‌ ବାଗ୍‌ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_52","070_27_52","MAT","27","52","52","ଆରି ଉଡ଼ି ରାଚ୍ୟା ରଃ ୱେଚେ ଗୁଲୁଏ ଗୁଏଲେଃଆର୍‌କ୍ନେ ଦରମ୍ ରେମୁଆଁନେ ଗାଗ୍‌ଡ଼େ ବାର୍‌ମୁଇଂତର୍ ମ୍ୱ୍ରଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_53","070_27_53","MAT","27","53","53","କିମେଇଂ ରାଚ୍ୟାମ୍ବବାନ୍ ତଡ଼ିଆ ପାଙ୍ଗ୍‌ଆର୍‌କେ ଆରି ଜିସୁ ଗୁଏଚେ ମ୍ୱ୍ରକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଆକ୍‌ମେଇଂ ପବିତ୍ର ନଗରି ଜିରୁସାଲାମ୍‍ ପାକା ୱେନେ ଗୁଲେରୁଆ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_54","070_27_54","MAT","27","54","54","ଜିସୁକେ ଉର୍‍ଲେଣ୍ଡ୍ରେ ସେନାପତି ଆରି ସନ୍ୟଇଂ ବୁମିକମ୍ପ୍ ଆରି ବିନ୍‌ବିନ୍ ଗଟ୍‌ନା କେଚେ ବୁଟଆର୍ଗେ । ମେଇଂ ବାସଙ୍ଗ୍‌କେ “କିମେ ସତେଆ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_55","070_27_55","MAT","27","55","55","ଗାଲିଲୀବାନ୍‍ ଜିସୁକେ ତୁର୍ ତୁର୍‍ଚେ ପାଙ୍ଗ୍‌ଲେ ଆର୍‌ଗେ ଆରି ଆମେକେ ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‍ବକ୍ନେ ଗୁଲୁଏ ସେଲାମ୍ବୁଏଃଇଂ ସ୍ଲ ତୁଆଁଚେ ଆକେନ୍ ସାପା କେଡିଂଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_56","070_27_56","MAT","27","56","56","କିମେଇଂ ବିତ୍ରେ ଲେଃଗେ ମଗ୍‌ଦଲୀନି ମରିୟମ୍ ଜାକୁବ୍‌ ଆରି ଯୋସେଫ୍‌ନେ ଇୟାଙ୍ଗ୍‌ଡେ ମରିୟମ୍ ଆରି ଜେବଦୀନେ କୁନେଡ଼େ । ");
INSERT INTO gaq_vpl VALUES ("MT27_57","070_27_57","MAT","27","57","57","ଲମ୍‍ଡିଗ୍‍ କେଲା ଆରମାଥିଆ ଇନିନେ ଯୋସେଫ୍‌ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ଦନି ରେମୁଆଁ ପିଙ୍ଗ୍‌ଚାକେ । ମେଁ ଜିସୁନେ ମୁଇଙ୍ଗ୍ ସିସ୍‍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_58","070_27_58","MAT","27","58","58","ମେଁ ପିଲାତକେ ଅବାଚେ ଜିସୁନେ ଗୁଏକ୍ନେ ଗାଗ୍‌ଡ଼େକେ ଡୁଙ୍ଗ୍‌ୱେନ୍‌ସା ଆଦେସ୍‍ ସାଲ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_59","070_27_59","MAT","27","59","59","ପିଲାତ ଆଦେସ୍‌ ବିଃକେସାଃ ଯୋସେଫ୍‌ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ଡୁଙ୍ଗ୍‌ୱେଚେ ମୁଇଙ୍ଗ୍ ପର୍‌ଚଲ୍‌ ତୁଲୁଏ ପାଟାଏ ଏତେ ଆଃକୁଇ ବିଃକେ ଆରି ");
INSERT INTO gaq_vpl VALUES ("MT27_60","070_27_60","MAT","27","60","60","ମେଁ ନିଜେ ଆତ୍‍ଲା ବ୍ରିକେ ଆପ୍‍ଲଗ୍‍ଚେ କଣ୍ଡା ଆଃଡ଼ା ଗଃବକ୍ନେ ମୁଇଙ୍ଗ୍ ତ୍ମିକ୍ନେ ରାଚ୍ୟାନ୍ନିଆ ଆମେକେ ବଆର୍‌କେ ଆରି ରାଚ୍ୟା ସାମ୍‌ନା ମୁଇଙ୍ଗ୍ ମ୍ନା ବ୍ରି ଡାଚେ ୱିଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_61","070_27_61","MAT","27","61","61","ମଗ୍‌ଦଲୀନି ମରିୟମ୍ ଆରି ବିନ୍ ମରିୟମ୍ ଆତେନ୍‌ ରାଚ୍ୟା ପାକା ତାମୁଚେ କଲେ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT27_62","070_27_62","MAT","27","62","62","ତୁଗୁଆ ଣ୍ଡୁ ମାର୍‌ତଡ଼େ ପୁଣ୍ଡେନେ ଦିନ୍‌କେଲା ମ୍ନା ଜାଜକ୍‍ ଆରି ଫାରୁଶୀଇଂ ପିଲାତକେ ଅବାଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT27_63","070_27_63","MAT","27","63","63","“ମାପ୍‌ରୁ, ନେନେ ମନେ ଲେଃକେ ଆତେନ୍‌ ନାଲେଣ୍ଡ୍ରେ ବ୍ରୁଆ ଲେଃକେଲା ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ ଜିର୍‍ସି ଇଡ଼ିଙ୍ଗ୍ ନେଙ୍ଗ୍ ମ୍ୱ୍ରଚେ ତଡ଼ିଆଏ । ");
INSERT INTO gaq_vpl VALUES ("MT27_64","070_27_64","MAT","27","64","64","ତେସା ଜିର୍‌ସି ଦିନା ଜାକ ଆତେନ୍‌ ରାଚ୍ୟାମ୍ବକେ ଉର୍‍ ଲେଃନ୍‍ସା ସନ୍ୟଇଂକେ ଆଦେସ୍‍ ବିଃ । ତେଲା ମେଁନେ ସିସ୍‍ଇଂ ମେଁନେ ଗାଗ୍‌ଡ଼େକେ ଡଙ୍ଗା ଡୁଙ୍ଗ୍‍ଡଚେ ମେଁ ମ୍ୱ୍ରଚେ ତଡ଼ିଆ ଲେଃକେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆୟା ଆର୍‌ଏ ଣ୍ଡୁ । ମେଁଇଙ୍ଗ୍‌ନେ ଆକେନ୍‍ ମିଚ୍ ବ୍ନାଲିର୍ ସାପାବାନ୍‍ ଜବର୍ ଦଦ୍ୟା ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_65","070_27_65","MAT","27","65","65","ପିଲାତ ଉତର୍ ବିକେ “ମୁଇଂ ରାସି ଜାଗୁଆଲ୍‍ଇଂକେ ଡୁଂୱେଲାପା ଆରି ଆତେନ୍‌ ରାଚ୍ୟାମ୍ବକେ ଜିଆଃ ୱେଚେ ଉର୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT27_66","070_27_66","MAT","27","66","66","ମେଇଂ ୱେଚେ ରାଚ୍ୟାମ୍ବକେ ଉର୍‍ନ୍‍ସା ନିୟମ୍‌ ଆଡିଙ୍ଗ୍‌କେ । ମେଁ ସାର୍ମୁଆଁକେ ଡାବକ୍ନେ ବ୍ରି ଆଡ଼ାତ୍ରା ସିଲ୍‌ ବଗ୍‌ଚେ ଉର୍‍ନେସା ଜାଗୁଆଲ୍‍ଇଂକେ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_1","070_28_1","MAT","28","1","1","ପୁଣ୍ଡେନେ ଦିନା ମାର୍‌ତଡ଼େ ସାନ୍ତାନେ ଞ୍ଜିର୍‍ ଞ୍ଜିର୍‌ନୁଗ୍ ମଗ୍‌ଦଲୀନି ମରିୟମ୍ ଆରି ବିନ୍ ମରିୟମ୍ ରାଚ୍ୟା କେନ୍‍ସା ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_2","070_28_2","MAT","28","2","2","ଆତେନ୍‌‍ବେଲା ଉଲୁସ୍ତେ ମୁଇଙ୍ଗ୍ ବୁମିକମ୍ପ୍ ଡିଙ୍ଗ୍‌କେ । ମାପ୍ରୁନେ ମୁଇଙ୍ଗ୍ କିତଂ ଦୁତ୍ ଆଡ଼ାତ୍ରାବାନ୍ ଜାର୍‌ଚେ ରାଚ୍ୟା ଡାବକ୍ନେ ବ୍ରିକେ ଆଗୁଣ୍ଡ୍‍ଲେଚେ ମେଁ ଆଡ଼ାତ୍ରା କକେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_3","070_28_3","MAT","28","3","3","ମେଁନେ ସାର୍ମୁଆଃ ଗଡ଼୍‍ଗଡ଼ି ରକମ୍ ତ୍ନା ଡିଙ୍ଗ୍‌ଗେ ଆରି ମେଁନେ ସକା ବରପ୍‍ ରକମ୍ ତୁଲୁଏ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_4","070_28_4","MAT","28","4","4","ଉର୍‍ଣ୍ଡ୍ରେଇଂ ଆମେକେ କେଚେ ବୁଟଚେ ଜାର୍‌କେ ଆରି ମୁର୍ଚା ଡିଙ୍ଗ୍‌ଚେ ଲଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_5","070_28_5","MAT","28","5","5","କିତଂ ଦୁତ୍ ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଆବ୍‌ଟଗ୍‍ପା ନାମଃ । ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ ପେ କୁରୁସ୍‍ଡାଗ୍ରା ବାଗୁଏବକ୍ନେ ଜିସୁକେ କେନ୍‍ସା ପାଙ୍ଗ୍‍ପେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_6","070_28_6","MAT","28","6","6","ମେଁ ଆକ୍ ଅରିଆ ଣ୍ଡୁ । ମେଁ ବାସଙ୍ଗ୍‌କ୍ନେ ଇସାବ୍‍ରେ ମେଁ ତଡ଼ିଆ ଲେଃକେ । ଗେଲାପା ଆକ୍‌ଅରିଆ ପାଙ୍ଗ୍‌ଚେ କିକେ କେଲାପା ଆକ୍‍ଡାଗ୍ରା ଆମେକେ ଗୁଏକ୍ନେ ଗାଗ୍‌ଡ଼େକେ ଆଡୁଲେଗ୍ ପେବଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_7","070_28_7","MAT","28","7","7","ଜିଆଃ ୱେଚେ ମେଁନେ ସିସ୍‍ଇଂକେ ବାସଙ୍ଗ୍‌ପା ମେଁ ବାରି ଗୁଏକ୍ନେ ବାନ୍ ତଡ଼ିଆ ଲେଃକେ ଆରି ପେନେ ସେନୁଗ୍‍ ସେନୁଗ୍‍ ମେଁ ଗାଲିଲୀ ୱେଡିଙ୍ଗ୍‌କେ । ଆତ୍‌ଅରିଆ ପେ ଆମେକେ ପେକେଏ । ନେଙ୍ଗ୍ ମେଁ ମ୍ୱାସଙ୍ଗ୍‍କେ ମନେ ବପା ।” ");
INSERT INTO gaq_vpl VALUES ("MT28_8","070_28_8","MAT","28","8","8","ଆକେନ୍ ଅଁଚେ ମେଇଂ ଜିଆଃ ରାଚ୍ୟା ଆନ୍‌ତାର୍‌ଚେ ସିସ୍‍ଇଂ ଡାଗ୍ରା କବର୍ ବିଃନ୍‍ସା ୱିର୍‌ଆର୍‌କେ । ବୁଟ ୱେଲେଃଆର୍‌ଲା ଡିଗ୍‍ ମେଇଂ ମନ୍ ବିତ୍ରେ ଗୁଲୁଏ ସାର୍‌ଦା ବାଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_9","070_28_9","MAT","28","9","9","ଉଲୁସ୍ତେ ଜିସୁ ଆମେଇଂକେ ଅବାଚେ ବାସଙ୍ଗ୍‌କେ “ପେନେ ସାନ୍ତି ଡିଙ୍ଗ୍‌ଲେ ! ମେଇଂ ମେଁ ଡାଗ୍ରା ୱେଚେ ମେଁନେ ଞ୍ଚ ସାଚେ ମୁଣ୍ଡିଆ ବଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_10","070_28_10","MAT","28","10","10","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ଆପ୍‍ଟଗ୍‍ପା । ନେଙ୍ଗ୍ ବୟାଁଇଂକେ ବାସଙ୍ଗ୍‌ପା ମେଇଂ ଗାଲିଲୀ ୱେ ଆର୍‌ଏ । ଆତ୍‌ଅରିଆ ମେଇଂ ଆନେଙ୍ଗ୍‌କେ କେଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MT28_11","070_28_11","MAT","28","11","11","ସେଲାମ୍ବୁଏଃଇଂ ଆତ୍‌ବା ୱିଗ୍‌ନେ ବେଲା ରାଚ୍ୟା ଉର୍‍ଲେ ଆର୍‍କ୍ନେ ସନ୍ୟଇଂ ଇନି ୱେଚେ ମ୍ନା ପୁଜାରି‍ଇଂକେ ଆକେନ୍ ସାପା ଗଟ୍‌ନା ଆମ୍ୟାବିଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_12","070_28_12","MAT","28","12","12","ମ୍ନା ପୁଜାରି‍ଇଂ ଦର୍ମ ନେତାଇଂ ଏତେ ବାଲିର୍‌ବାତାଚେ ଆତେନ୍‌ ସନ୍ୟଇଂକେ ଗୁଲୁଏ ଡାବୁ ଜାଲାରି ବିଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MT28_13","070_28_13","MAT","28","13","13","“ପେଇଂ ବାସଙ୍ଗ୍‌ପା ଜେ ମିଡିଗ୍‍ ବେଲା ପେ ଡୁଲେଗ୍‌ଲେକ୍ନେ ବେଲା ମେଁନେ ସିସ୍‍ଇଂ ପାଙ୍ଗ୍‌ଚେ ମେଁନେ ମଡ଼ାକେ ଡଙ୍ଗାଚେ ଡୁଂଡ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_14","070_28_14","MAT","28","14","14","ଜଦି ସାସନ୍‍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଆକେନ୍ ସାମୁଆଁ ଅଁଲା ନେ ଆମେକେ ଆଦ୍ରିଗ୍ ନେବିଃଏ ଜେ ନାଁ ଦସି ଣ୍ଡୁ । ଆକେନ୍ ସାମୁଆଁରେ ନାନେ ତାନ୍ଦ୍ରା ଆଡିଙ୍ଗ୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MT28_15","070_28_15","MAT","28","15","15","ସନ୍ୟଇଂ ଡାବୁ ଡୁଂଡଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କ୍ନେ ସାମୁଆଁ ଇସାବ୍‌ରେ କାମ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ମେଇଂ ଆତେନ୍‌ ବେଲା ମେଁନେ ବାସଙ୍ଗ୍‌ ବଗେ ଜିହୁଦିଇଂ ଏ ଜାକ ଆତେନ୍‌ ସାମୁଆଁକେ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ଆର୍‌ଡିଙ୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_16","070_28_16","MAT","28","16","16","ଜିସୁ ବାସଙ୍ଗ୍‍ବକ୍ନେ ଇସାବ୍‌ରେ ମେଁନେ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସିସ୍‍ଇଂ ଅଃସେ ୱେଲେଃକ୍ନେ ଗାଲିଲୀନ୍ନିଆ ୱେଚେ ଜିସୁ ଅଃସେ ଆଣ୍ଡିନେ କଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେଲେଗେ ଆତେନ୍‌ କଣ୍ଡା ଡାଗ୍ରା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_17","070_28_17","MAT","28","17","17","ଆତ୍‌ଅରିଆ ଜିସୁକେ କେଚେ ମେଇଂ ଆମେକେ ଆରାଦନା ଡିଙ୍ଗ୍‌ଆର୍କେ । ମାତର୍‌ ଜାଣ୍ଡେ ଜାଣ୍ଡେ ସନ୍ଦେଅ ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_18","070_28_18","MAT","28","18","18","ଜିସୁ ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “କିତଂନେ ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସାପା ଅଦିକାର୍ ଆନେଙ୍ଗ୍ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("MT28_19","070_28_19","MAT","28","19","19","ସାପା ଦେସ୍‌ନେ ସାପା ବାସାନେ ରେମୁଆଁଇଂ ଡାଗ୍ରା ୱେଚେ ଆମେଇଂକେ ନେଙ୍ଗ୍‌ନେ ସିସ୍‍ ଆଡିଙ୍ଗ୍‌ପା । ଆବା ଉଙ୍ଗ୍‌ଡେ ଆରି ପବିତ୍ର ଆତ୍ମାନେ ମ୍ନିରେ ଆମେଇଂକେ ଦିକ୍ୟା ବିଃପା ");
INSERT INTO gaq_vpl VALUES ("MT28_20","070_28_20","MAT","28","20","20","ଆରି ନେଙ୍ଗ୍ ଆପେକେ ଆଣ୍ଡିନେ ଜ୍ଞାନ୍‍ ବିମ୍ୱକେ, ଆତେନ୍‌ ପାଲନ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆମେଇଂକେ ଜ୍ଞାନ୍‍ ବିଃପା । ଆରି ମନେ ବପା ସାରାସାରି ଜୁଗ୍ ଜାକ ନେଙ୍ଗ୍ କାଲାଆଃ ପେ ଏଃତେ ନ୍ଲେଃଏ ।”");
INSERT INTO gaq_vpl VALUES ("MK1_1","071_1_1","MRK","1","1","1","ଆକେନ୍ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଜିସୁ କିସ୍‌ଟନେ ନିମାଣ୍ଡା ସାମୁଆଁ ଆରାମ୍ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_2","071_1_2","MRK","1","2","2","ବାବବାଦି ଯିଶାଇୟନେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ ବକେ । ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‌କେ, “ପେ ଆତ୍‌ଲା ଗାଲି ତିଆର୍‌ ଡିଙ୍ଗ୍‌ନ୍‌ସା ନେଙ୍ଗ୍‌ନେ ଦୁତ୍‌କେ ସେନୁଗ୍‌ ମ୍ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MK1_3","071_1_3","MRK","1","3","3","ବାଲିଲନ୍ନିଆ ମୁଇଂଜା କିରଚେ ବାସଙ୍ଗ୍‌ଡିଂକେ; ମାପ୍ରୁ ନ୍‍ସା ଗାଲି ତିଆର୍ ଡିଙ୍ଗ୍‌ପା; ମେଁ ପାଙ୍ଗ୍‌ନେ ଗାଲି ସିଦା ଆଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_4","071_1_4","MRK","1","4","4","ଆତେନ୍‌ ଅନୁସାରେ ଡୁବନ୍ ବିଃଣ୍ଡ୍ରେ ଜହନ୍‌ ଲଣ୍ଡିଆଃପାକା ପାଙ୍ଗ୍‌ଚେ ପର୍‌ଚାର୍ ଡିଂକେ ବାରି ଡୁବନ୍‌ ବିଃନେ ମୁଲେକେ । ମେଁ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌ଡିଂଗେ, “ନିଜର୍ ନିଜର୍ ପାପ୍‌ବାନ୍ ଆଣ୍ଡେପା ବାରି ଡୁବନ୍ ଡୁଂଡଲାପା । ତେଲା ଇସ୍‌ପର୍ ପେନେ ପାପ୍ କେମା ଡିଂଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_5","071_1_5","MRK","1","5","5","ଜିଉଦା ପ୍ରଦେସ୍‌ ଆରି ଯିରୂଶାଲମ୍‌ ସହର୍‌ବାନ୍‌ ଜାବର୍‌ ରେମୁଆଁ ଜହନ୍‌ ବାସଙ୍ଗ୍‌କ୍ନେ ସାମୁଆଁ ଅଁନ୍‌ସା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ମେଇଂ ନିଜର୍‌ ନିଜର୍‌ ପାପ୍ ସିକାର୍ ଡିଙ୍ଗ୍‌ଚେ ବାରି ଜହନ୍‌ ଆମେଇଂକେ ଜର୍ଦନ୍‌ କେଣ୍ଡିଆନ୍ନିଆ ଡୁବନ୍ ଡୁଂଡ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_6","071_1_6","MRK","1","6","6","ଜହନ୍‌ ଉଟ୍‌ ଉକ୍‌ସାନେ ସକା ସଃଡିଂଗେ ଆରି ନ୍‌ସାନ୍ନିଆ ଉକ୍‌ସାନେ ଗ୍ନେଗ୍‌ସାଃ ଗାଗ୍ ଡିଙ୍ଗେ । କ୍ୟାରବ ସ୍ଲାଃନେ ଚୁଚୁ ଆରି କଣ୍ତା ଞ୍ଜୁଙ୍ଗ୍‌ ମେଁନେ କାଦି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_7","071_1_7","MRK","1","7","7","ଜହନ୍‌ ୱାସାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‍ବାନ୍ ଜାଣ୍ଡେ ଜାବର୍‌ ବପୁ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଡିଂକେ, ନେଙ୍ଗ୍ ମେଁନେ ଜୁତା ତୁତଃନେ ଆନେଙ୍ଗ୍ ଯଗ୍ୟ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_8","071_1_8","MRK","1","8","8","ନେଙ୍ଗ୍ ଆପେକେ ଣ୍ଡିଆନ୍ନିଆ ଦିକ୍ୟା ବିଃଡିଂକେ ମାତର୍‌ ମେଁ ଆପେକେ ପବିତ୍ର ଆତ୍ମା ବାନ୍ ଦିକ୍ୟା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MK1_9","071_1_9","MRK","1","9","9","ଆତେନ୍‌ ବେଲା ଜିସୁ ଗାଲିଲୀନେ ନାଜରିତବାନ୍ ପାଙ୍ଗ୍‌ଚେ ଜର୍ଦନ୍‌ ଲଣ୍ଡିଆଃନ୍ନିଆ ଜହନ୍‌ବାନ୍‍ ଡୁବନ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_10","071_1_10","MRK","1","10","10","ଜିସୁ ଲଣ୍ତିଆଃବାନ୍ ତାର୍‌କ୍ନେ ବେଲା କିତଙ୍ଗ୍ଇନି ମେଲା ଡିଂକେ । ମେଁ କେକେ ଜେ ପବିତ୍ର ଆତ୍ମା ମେଁନେ ଆଡ଼ାତ୍ରା କୁକୁର୍‌ୟାଃ ରକମ୍ ଜାର୍‌କ୍ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_11","071_1_11","MRK","1","11","11","କିତଙ୍ଗ୍‍ ଇନି ବାନ୍ ଆକେନ୍ ସାମୁଆଁ ନାଙ୍ଗ୍‌କେ “ନା ନେଙ୍ଗ୍‌ନେ ନିଜର୍ ଗଡ଼େଅ ନା ଅରିଆ ନେଙ୍ଗ୍‌ନେ ଜବର୍ ସାର୍ଦା ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_12","071_1_12","MRK","1","12","12","ଆତ୍‌ବାନ୍ ପବିତ୍ର ଆତ୍ମା ଜିସୁକେ କଣ୍ଡାନ୍ନିଆ ଡୁଂୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_13","071_1_13","MRK","1","13","13","ଜିସୁ ଆତ୍ଅରିଆ ମ୍ବାର୍‌କୁଡ଼ି ସ୍ମି ଜାକ କଣ୍ଡାନେ ପସୁ ଏଃତେ ଲେଃଗେ । ଆତ୍ଅରିଆ ମେଁ ସ‍ଏତାନ୍‌ବାନ୍ ପରିକିତ ଡିଙ୍ଗ୍‌କେ । ଇଡ଼ିଙ୍ଗ୍ କିତଂଇନିନେ ଦୁତ୍ଇଂ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ଜତନ୍‍ ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_14","071_1_14","MRK","1","14","14","ଏନ୍ ଇଡ଼ିଂ ଜହନ୍‌କେ କଏଦ୍ ଡୁଆ ଆଃଗାକ୍ନେ ଇଡ଼ିଂ । ଜିସୁ ଗାଲିଲୀ ଏରିୟାବାନ୍ ପାଙ୍ଗ୍‌ଚେ ଆରି ମେଁ ଇସ୍‌ପର୍‌ନେ ନିମାଣ୍ତା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_15","071_1_15","MRK","1","15","15","ଜିସୁ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ “ବେଲା ଡା ଡିଙ୍ଗ୍‌କେ, ଇସ୍‌ପର୍‌ନେ ରାଜି ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାଡିଂକେ ପାପ୍‌ବାନ୍‌ ମନ୍‍କେ ଆବଦ୍‌ଲେ ବିଃପା ନିମାଣ୍ଡା ସାମୁଆଁକେ ବିସ୍‌ବାସ୍‍ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_16","071_1_16","MRK","1","16","16","ଜିସୁ ଗାଲିଲୀନେ କେଣ୍ଡିଆଃ ଆଃଡ଼ାଃ ବିଃଚେ ୱେକ୍ନେ ବେଲା ଶିମୋନ ଆରି ମେଁନେ ବୟାଁଣ୍ଡେ ଆନ୍ଦ୍ରିୟକେ କେଣ୍ଡିଆଃ ଡାଗ୍ରା ଜାଲ୍ ତାଲାଗ୍‍ଡିଂକ୍ନେ କେକେ । ଡାଗ୍‍ଲା ମେଇଂ ଆଃଡ଼ ସାଃଣ୍ଡ୍ରେ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_17","071_1_17","MRK","1","17","17","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେ ନେଙ୍ଗ୍‍ ଏତେ ପାଙ୍ଗ୍‌ଲାପା, ନେଙ୍ଗ୍ ଆପେକେ ମାପ୍ରୁନେ ଗାଲିପାକା ରେମୁଆଁଇଂକେ ଡୁଂପାଙ୍ଗ୍‌ନେ ଣ୍ଡ୍ରାସିକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_18","071_1_18","MRK","1","18","18","ତେଲା ଶିମୋନ୍ ଆରି ଆନ୍ଦ୍ରିୟ ମେଇଂନେ ଜାଲ୍ ଆନ୍ତାର୍‌ଚେ ଜିସୁନେ ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_19","071_1_19","MRK","1","19","19","ଆରି ମେଁ ଉଡ଼ି ସ୍ଲ ରକମ୍‌ ୱେଚେ ଜେବଦୀନେ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌ ଆରି ମେଁନେ ବୟାଁ ଜହନ୍‌କେ ତରା ଅରିଆନେ ଜାଲ୍ ପାଗ୍‌ଲୁଗ୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_20","071_1_20","MRK","1","20","20","ଜିଆ ଜିଆ ମେଁ ଆମେଇଂକେ ୱାକେ । ମେଇଙ୍ଗ୍‌ନେ ଆବାଡ଼େ ଜେବଦୀକେ କୁଲିରେ ଏଃତେ ତରାନ୍ନିଆ ଆନ୍ତାର୍‌ଚେ ଜିସୁନେ ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_21","071_1_21","MRK","1","21","21","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆରି ସିସ୍‌ଇଂ କପର୍ନାହୂମ ଅରିଆ ୱେଆର୍‌କେ । ଜିଉଦିଇଙ୍ଗ୍‌ନେ ପୁଣ୍ତେନେ ଦିନା ଜିସୁ ଜିଉଦିଇଙ୍ଗ୍‌ନେ ପାର୍‍ତନା ଡୁଆ ୱେଆର୍‌କେ ଆତ୍ ଅରିଆ ରେମୁଆଁଇଂକେ ସିକ୍ୟା ବିଃନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_22","071_1_22","MRK","1","22","22","ଜିସୁନେ ଗିଆନ୍‍ ଅଁଚେ ଆତେନ୍‌ ରେମୁଆଁଇଂ ବକୁଆ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ଜିସୁ ଆମେଇଂକେ ଦର୍ମ ଗୁରୁଇଂ ରକମ୍ ଗିଆନ୍ ମାବିଚେ ମୁଇଂ ନେତା ବାଲେଃକ୍ନେ ରେମୁଆଁ ରକମ୍ ଗିଆନ୍‍ ବିଃ କି । ");
INSERT INTO gaq_vpl VALUES ("MK1_23","071_1_23","MRK","1","23","23","ଜିସୁ ଜିଉଦିଇଙ୍ଗ୍‌ନେ ପାର୍‍ତନା ଡୁଆ ନ୍ନିଆ ଲେଃକ୍ନେ ବେଲା ଆତ୍ ଅରିଆ ଦେତ୍‌ରକମ୍ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଲେଃଗେ । ଜାଣ୍ଡେନେ ଗାଗ୍‌ଡ଼େ ଗଲିଆ ଗାଲେଃକେ । ଆତେନ୍‌ ରେମୁଆଁ କିରଚେ ବାଲିର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_24","071_1_24","MRK","1","24","24","ଏ ନାଜରିତୀୟ ଜିସୁ “ନାଁ ଏଃତେ ନେଙ୍ଗ୍‌ନେ ମେଃ କାମ୍ ଲେଃକେ ? ପେ ମେଁନେ ଆନେକେ ଦଂସ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ପାଙ୍ଗ୍ ପେଲେକେ ? ନାଁ ଜାଣ୍ଡେ ନେଙ୍ଗ୍ ଆତେନ୍‌ ମ୍ୟା ନ୍ଲେକେ । ନାଁ ଇସ୍‌ପର୍‌ନେ ପବିତ୍ର ରେମୁଆଁ !” ");
INSERT INTO gaq_vpl VALUES ("MK1_25","071_1_25","MRK","1","25","25","ଜିସୁ ଆମେକେ ଦମ୍‌କେଚେ ବାସଙ୍ଗ୍‌କେ, “ବୁଙ୍ଗ୍ ଲାଃଲା ଆକେନ୍ ରେମୁଆଁ ବିତ୍ରେବାନ୍ ତାର୍ ୱେଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_26","071_1_26","MRK","1","26","26","ଗଲିଆ ରେମୁଆଁକେ ଲାଃଜୁର୍ ବିକେ । ଇଡ଼ିଙ୍ଗ୍ ମେଁ ମାଲେ କିରଚେ ଆତେନ୍‌ ରେମୁଆଁ ବିତ୍ରେ ବାନ୍ ତାର୍‌ଡକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_27","071_1_27","MRK","1","27","27","ଆକେନ୍ କେଚେ ରେମୁଆଁଇଙ୍ଗ୍‌ ବକୁଆ ଡିଙ୍ଗ୍ ୱେ ଆର୍‌ଗେ । ମେଇଙ୍ଗ୍‌ କୁଡ଼େଚେ ବାଲିର୍‌ବାତାନେ ଲାଗେକେ, “ଏନ୍‌ ମେଁନେ ? ଆକେନ୍ ରେମୁଆଁ ଆନେକେ ତ୍ମିନେ ଗିଆନ୍ ବିଃ ଡିଙ୍ଗ୍‌କେ ? ମେଁ ଗଲିଆଇଂକେ ଡିଗ୍ ଆଦେସ୍ ବିଡିଙ୍ଗ୍‌କେ ଆରି ଗଲିଆଇଂ ମେଁନେ ସାମୁଆଁ ମାନେଃ ଡିଙ୍ଗ୍‌କେ !” ");
INSERT INTO gaq_vpl VALUES ("MK1_28","071_1_28","MRK","1","28","28","ତେଲା ଜିସୁନେ ସାମୁଆଁ ଗାଲିଲୀ ଏରିଆ ସାପାପାକା ଟାପ୍‌ନା କବର୍ ୱେଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_29","071_1_29","MRK","1","29","29","ଜିସୁ ଆରି ସିସ୍‌‌ଇଙ୍ଗ୍‌ ପାର୍‍ତନା ଡୁଆବାନ୍‌ ତାର୍‌ଚେ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ଏଃତେ ଶିମୋନ୍ ଆରି ଆନ୍ଦ୍ରିୟନେ ଡୁଆ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_30","071_1_30","MRK","1","30","30","ଶିମୋନ୍‍ନେ ଆତାଡ଼େ ଆଃସାବାଚେ ସିଙ୍ଗ୍‌ଲାନ୍ନିଆ ଡୁଲେଗ୍‌ଲେଃଗେ । ତେଲା ଆତ୍ ଅରିଆ ଲେଃକ୍ନେ ରେମୁଆଁଇଂ ଜିସୁକେ ମେଁନେ ସାମୁଆଁରେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_31","071_1_31","MRK","1","31","31","ଜିସୁ ମେଁନେ ସିଙ୍ଗ୍‌ଲା ଅରିଆ ୱେକେ । ଆକେନ୍ ଦାପ୍ରେ ଜିସୁ ମେଁନେ ନ୍ତି ସାଚେ ଆତଡ୍ୟାକେ । ଆମେକେ ସାଃବା ଆନ୍ତାର୍‌କେ ଆରି ମେଁ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ୱେଗେ । ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଆମେଇଂକେ ସେବା ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_32","071_1_32","MRK","1","32","32","ସ୍ନି ଲଗ୍‍ନେ ଇଡ଼ିଙ୍ଗ୍ ରେମୁଆଁଇଙ୍ଗ୍‌ ଜବର୍ ଆଃସିଲେକ୍ନେ ରେମୁଆଁକେ ଆରି ଗଲିଆ ସାଃଲେକ୍ନେ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ଜିସୁନେ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_33","071_1_33","MRK","1","33","33","ଇନିନେ ସାପା ରେମୁଆଁ ଆତେନ୍‌ ଡୁଆନେ ବାଜାର୍‌ ଡାଗ୍ରା ରିସିଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_34","071_1_34","MRK","1","34","34","ବିନ୍‌ବିନ୍ ରକମ୍‌ ରଗ୍ ସାଃଲେକ୍ନେ ଗୁଲେ ରେମୁଆଁକେ ଜିସୁ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌କେ । ମେଁ ଗୁଲେ ଗଲିଆଇଂକେ ଆଃନ୍ତାର୍‌କେ ଆରି ମେଁ ଗଲିଆଇଂକେ ବାଲିର୍ ନ୍‌ସା ଆବିଃକେ ଣ୍ଡୁ ମାତର୍‌ ମେଇଂ ଆମେକେ ସାମୁଆଃ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_35","071_1_35","MRK","1","35","35","ଆରି ମୁଇଙ୍ଗ୍ ଦିନା ତାଂକିଗ୍ ଲେଃକେଲା ଜିସୁ ତଡ଼ିଆଚେ ରେମୁଆ ଗଣ୍ଡ୍‌ ଣ୍ଡୁନେ ଜାଗାନ୍ନିଆ ୱେକେ । ଆତ୍ ଅରିଆ ମେଁ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_36","071_1_36","MRK","1","36","36","ଇଡ଼ିଙ୍ଗ୍ ଶିମନ ଆରି ମେଇଙ୍ଗ୍ ସାଙ୍ଗଡ଼େଇଙ୍ଗ୍ ଜିସୁକେ ତୁତୁର୍‌ନେ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_37","071_1_37","MRK","1","37","37","ମେଇଙ୍ଗ୍ ଜିସୁକେ ଅବାଚେ ଆରି ଆମେକେ ବାସଙ୍ଗ୍ଆର୍‌କେ, “ସାପାରେ ଆନାକେ ତୁତୁର୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_38","071_1_38","MRK","1","38","38","ଡାଗ୍‍ଲା ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଏଲାପା ନେଙ୍ଗ୍‍ ବିନ୍ ଜାଗାନ୍ନିଆ ଲେଃକ୍ନେ ଇନି ଆନେଃକେ ୱେନେ ପଡ଼େଏ । ଆତ୍ଅରିଆ ଡିଗ୍ ନେଙ୍ଗ୍ ମ୍ବାସଙ୍ଗ୍ଏ, ନେଙ୍ଗ୍ ଆତେନ୍‌ ଉଦେସ୍‌ରେ ତାର୍‌ନ୍ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_39","071_1_39","MRK","1","39","39","ଆରି ମେଁ ଗାଲିଲୀନେ ସାପା ଏରିଆ ଅଲେଙ୍ଗ୍‌ଚେ ମେଇଂନେ ସାପା ପାର୍‍ତନା ଡୁଆନ୍ନିଆ ବାସଙ୍ଗ୍‌ଆର୍‌କେ ଆରି ଗଲିଆଇଂକେ ଆଃଆନ୍ତାର୍‍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_40","071_1_40","MRK","1","40","40","ମୁଇଂ କୁଷ୍ଟରଗି ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ନ୍ତିକେ ଜଡ଼େଚେ ଆମେକେ ବିକ୍ୟା ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ନା ଜଦି ଇକ୍‌ଚା ନାଡିଙ୍ଗ୍‌ଏ” ତେଲା ଆନେଙ୍ଗ୍‌କେ ନିମାଣ୍ଡା ନାରାଡିଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK1_41","071_1_41","MRK","1","41","41","ଆତେନ୍‌‌ ରେମୁଆଁ ଆଡ଼ାତ୍ରା ଜିସୁ ଲିବିସଃ ଡିଂଚେ ମେଁ ନ୍ତି ଲିଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଣ୍ଡିଂକେ ନାଁ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ୱେଲା !” ");
INSERT INTO gaq_vpl VALUES ("MK1_42","071_1_42","MRK","1","42","42","ଏହେନ୍‌ ଦାପ୍ରେ ମେଁନେ କୁଷ୍ଟରଗ୍ ବ’ୱେଗେ ଆରି ମେଁ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_43","071_1_43","MRK","1","43","43","ଜିସୁ ରେମୁଆଁଇଂକେ ଡାଟାମ୍ ବାବ୍‌ରେ ଆଦେସ୍ ବିଚେ ଟାପ୍‍ନା ବେ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK1_44","071_1_44","MRK","1","44","44","ତରକ୍‌ ଲାଲା, “ଆଜାଡିଗ୍ ମେଁନେ ଆବାସଙ୍ଗ୍‍ଗେ ଡାଗ୍‌ଲା ୱେଲା ପୁଜାରି ଡାଗ୍ରା ୱେଚେ ନିଜର୍ ଗାଗ୍‌ଡ଼େ ଆଃସୁଏ ଆରି ମୋଶା ମେଃମେଃନେ ଆଦେସ୍ ବିଃବକେ, ଆତେନ୍‌ ସାପା ନାନେ ଇକ୍‌ଚାରେ ମେଇଂନେ ଡାଗ୍ରା ସାକି ବିନେସା ବେଦିନ୍ନିଆ ଦାନ୍ ବିଃ ।” ");
INSERT INTO gaq_vpl VALUES ("MK1_45","071_1_45","MRK","1","45","45","ରେମୁଆଁ ଆତେନ୍‌ ଜାଗା ଆନ୍ତାର୍ଚେ ତାର୍ ୱେଗେ ଆରି ଆଜାକେ କେକେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଜିସୁ ଆନେଙ୍ଗ୍‌କେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ବିଃବକେ । ତେଲା ଜିସୁନେ ସାମୁଆଁ ସାପା ପାକା ବେପ୍ରେ ୱେଗେ । ମାତର୍‌ ରେମୁଆଁ ମାରିଆଃ କେଚେ ଲାଗ୍‍ଡଆର୍‌ଏ, ମାତର୍‌ ଜିସୁ ଆଣ୍ଡିନେ ଏରିଆ ୱେ ଆୟାକେ ଣ୍ଡୁ । ତେନ୍‌ସା ମେଁ ରେମୁଆଁଗଣ୍ଡ୍‌ ଣ୍ଡୁନେ ଟାନ୍‌ଇଂନ୍ନିଆ ଲେଃଗେ । ମାତର୍‌ ସାପା ରେମୁଆଁଇଙ୍ଗ୍ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_1","071_2_1","MRK","2","1","1","ଉଡ଼ିସି ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ କପର୍ନାହୂମ ଅରିଆ ଆଣ୍ତେ ୱିଗ୍‌କେ । ଜିସୁ ଡୁଆ ୱିଗ୍‌ଗେ ଡାଗ୍‌ଚେ ଉଡ୍ରା ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_2","071_2_2","MRK","2","2","2","ଗୁଲେ ରେମୁଆଁ ଜିସୁନେ ସାମୁଆଁ ଦ୍ରିଗ୍‌ନ୍‌ସା ରିସିଙ୍ଗ୍‌ ଆର୍‌କେ । ଡୁଆ ଲେଃ ବାଜାର୍‌ ଆଣ୍ଡିଅରିଆ ଡିଗ୍ ତୁଆଁନ୍‌ସା ଟାନ୍‌ ଆଲେଃକେ ଣ୍ଡୁ । ଜିସୁ ରେମୁଆଁଇଙ୍ଗ୍‌ନେ ଅରିଆ ବାଇର୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_3","071_2_3","MRK","2","3","3","ଆତେନ୍‌ ବେଲା ଉଡ଼ି ରେମୁଆଁ ମେଁ ଡାଗ୍ରା ମୁଇଙ୍ଗ୍‌ ପକ୍ଷାଗାତ୍‌ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ରେମୁଆଁକେ ଡୁଂପାଙ୍ଗ୍‌ଆର୍କେ । ରଗିକେ ଅଁଣ୍ଡ୍ରୁଆ ରେମୁଆଁ ଡୁଂ ରାଙ୍ଗ୍‍ପାଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_4","071_2_4","MRK","2","4","4","ରେମୁଆଁ ଜାବର୍ ଗହଲି ଡିଙ୍ଗ୍‌ୱେଲେଃଲା ମେଁଇଙ୍ଗ୍‌ ରଗିକେ ଜିସୁନେ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍ ଆୟାଆର୍‌କେ ଣ୍ତୁ । ତେସା ମେଁଇଙ୍ଗ୍‌ ଜିସୁ ଲେକ୍ନେ ଡୁଆନେ ବ୍ଲେସାଂ ଆପ୍ଲଗ୍‌ଚେ ଆରି କଟ୍‌ନ୍ନିଆ ଡୁଲେଗ୍‌ଲେଃକ୍ନେ ପକ୍ଷାଘାତ ରଗିକେ ଆତେନ୍‌‌ ପ୍ଲଗ୍‌ ପାକା ଜିସୁ ଲେଃକ୍ନେ ଟାନ୍ଅରିଆ ବୁନ୍ଦେ ଆଃଜାର୍‍ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_5","071_2_5","MRK","2","5","5","ଜିସୁ କେକେ ଜେ, ଆତେନ୍‌ ରେମୁଆଁଇଂନେ ଜାବର୍‌ ବିସ୍‌ବାସ୍‌ ଲେଃକେ । ତେଲା ଜିସୁ ପକ୍ଷାଗାତ୍‌ ରେମୁଆଁକେ ବାସଙ୍ଗ୍‌କେ, “ଅ ଗଡ଼େଅ, ନାଁନେ ପାପ୍ଇଂ କେମା ଆଃଡିଙ୍ଗ୍ ମ୍ବିଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_6","071_2_6","MRK","2","6","6","ଆତ୍‌ଅରିଆ କଲେଃଆର୍‌କ୍ନେ ଉଃଡ଼ିରୁଆ ଦର୍ମ ଗୁରୁ ଆକେନ୍‌ ଅଁଚେ ମନେ ମନେ ବାଇର୍‌ ବାତା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_7","071_2_7","MRK","2","7","7","“ଆକେନ୍ ରେମୁଆଁ ଦେକ୍‌ରକମ୍ ବାଲିର୍‌ବାତା ମେଃନ୍‌ସା ଡିଙ୍ଗ୍‌କେ ? ମେଁ ଇସ୍‌ପର୍‌ନେ ବିରଦ୍‌ରେ ଦସ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ ! ଇସ୍‌ପର୍‌କେ ଆନ୍ତାର୍‌ଲା ପାପ୍ କେମା ଡିଂନେ ବିନ୍‌ ଜାଡିଗ୍‌ ଆୟାଆର୍ ଣ୍ତୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MK2_8","071_2_8","MRK","2","8","8","ଦର୍ମ ଗୁରୁଇଂ ମେଁନେ ସାମୁଆଁରେ ବାବେଡିଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ଜିସୁ ଆତ୍ମାବାନ୍ ମ୍ୟା ଜଗ୍‌ତ୍ଲାଗ୍‌କେ । ତେଲା ଜିସୁ ଆମେଇଂକେ ବାଲିର୍‌କେ, “ପେ ସାପାରେ ବିତ୍ରେ ଏନ୍‌ ସାପା ସାମୁଆଁ ମେଃନ୍‌ସା ବାଲିର୍‌ବାତା ଡିଂପେଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_9","071_2_9","MRK","2","9","9","ଏନ୍ ପକ୍ଷାଗାତ୍‌ ରଗ୍‍କେ ନାନେ ପାପ୍ ସାପା କେମା ଡିଂମ୍ୱିଗେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ନେ ସଅଜ୍‌ ଲେଃ ତଡ଼ିଆ ନାନେ କଟ୍‌ ସାଚେ ୱେଲା ଡାଗ୍‌ନେ ସଅଜ୍‌ ? ");
INSERT INTO gaq_vpl VALUES ("MK2_10","071_2_10","MRK","2","10","10","ଡାଗ୍‌ଲା ମଞ୍ଚ୍‌ପୁର୍‌ନେ ପାପ୍ ଲିବିସଃ ଡିଙ୍ଗ୍‌ନେସା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଜେ ନେଙ୍ଗ୍ ଆକେନ୍ ନେଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଲେଃକେ । “ଆକେନ୍ ନେଙ୍ଗ୍ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍ଇଁୟାଏ ।” ଆତ୍‌ବାନ୍ ଜିସୁ ପକ୍ଷାଘାତ ରଗ୍ ରେମୁଆଁକେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_11","071_2_11","MRK","2","11","11","“ନେଙ୍ଗ୍ ଆନାକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍କେ ତଡ଼ିଆ ସିଙ୍ଗ୍‌ଲା ସାଚେ ଆରି ଡୁଆ ୱିଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_12","071_2_12","MRK","2","12","12","ଆତେନ୍‌ ଦାପ୍ରେ ପକ୍ଷାଘାତ ରେମୁଆଁ ତୁଆଁକେ । ସିଙ୍ଗ୍‌ଲା ସାଚେ ଆରି ଡୁଆ ବିତ୍ରେବାନ୍‌ ବାଜାର୍‌ ତାର୍‌ଗେ । ସାପା ରେମୁଆଁ ଆମେକେ କେ ଆର୍‌କେ । ମେଁଇଙ୍ଗ୍‌ ଇରିଆଃତୁଗ୍ ୱେଆର୍‌ଗେ ଆରି ଇସ୍‌ପର୍‌ନେ ଅସ୍‌ମାର୍ ସାର୍‌ଆର୍‌କେ । ମେଁଇଙ୍ଗ୍‌ ବାଲିର୍‌ଆର୍‌କେ, “ନେ ସାପାରେ ଦେଃକେନ୍ ଇରିଆଃତୁଗ୍‍ ଗଟ୍‌ନା ଅଃନାଡିଗ୍ କେ ନେଲେଃଗେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_13","071_2_13","MRK","2","13","13","ଆରି ମୁଇଙ୍ଗ୍‌ ତର୍ ଜିସୁ ଗାଲିଲୀ କେଣ୍ତିଆ ପାକା ବିଚେ ୱେଗେ । ଗୁଲେ ରେମୁଆଁ ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ଜିସୁ ଆମେଇଂକେ ଗ୍ୟାନ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_14","071_2_14","MRK","2","14","14","ଜିସୁ ଉଇଗ୍‌ନେ ବେଲା ସିସ୍ତୁ ସାଲ୍ୟାଃନେ ଜାଗାନ୍ନିଆ କ ଲେଃକ୍ନେ ଆଲଫିନେ ଉଙ୍ଗ୍‌ଡେ ଲେବୀକେ କେଚେ ମେଁ ବାଲିର୍‌କେ, “ନେଙ୍ଗ୍ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା ।” ଇଡ଼ିଙ୍ଗ୍ ଲେବୀ ତୁଆଁକେ ଆରି ଜିସୁନେ ପ୍ଲା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_15","071_2_15","MRK","2","15","15","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌ଇଙ୍ଗ୍‌ ଲେବୀନେ ଡୁଆ ଚୁଚଙ୍ଗ୍‌ନେ ବେଲା ମେଁଇଙ୍ଗ୍‌ ଏଃତେ ଗୁଲେ ସିସ୍ତୁ ସାଲିଆଣ୍ଡ୍ରେ ଆରି ବିନ୍ ପାପିଇଙ୍ଗ୍‌ ଡିଗ୍ ଚଙ୍ଗ୍‌ ଆର୍‌ଡିଂକେ । ଜିସୁନେ ପ୍ଲା ପାଙ୍ଗ୍‌କ୍ନେ ଗୁଲେ ରେମୁଆଁ ଡିଗ୍ ଆତ୍‌ଅରିଆ ଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_16","071_2_16","MRK","2","16","16","ଜିସୁ ସିସ୍ତୁ ସାଲିଆଣ୍ଡ୍ରେ ଆରି ବିନ୍‌ ପାପ୍ ରେମୁଆଁଇଙ୍ଗ୍‌ ଏଃତେ କଚେ ଚଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କେକେ । ପାରୁସିଇଂନେ ଦଲ୍‌ବାନ୍ ଉଃଡ଼ିରୁଆ ସାସ୍ତ୍ରିଇଂ ଜିସୁନେ ସିସ୍‌‍ଇଙ୍ଗ୍‌କେ ସାଲ୍ୟାକୁଆର୍‌କେ, “ଜିସୁ ସିସ୍ତୁ ସାଲିଆଣ୍ଡ୍ରେ ଆରି ବିନ୍‌ ପାପିଇଂ ଏଃତେ ମେଃନ୍‌ସା ଚୁଚଙ୍ଗ୍‌ଡିଂକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK2_17","071_2_17","MRK","2","17","17","ଜିସୁ ଆକେନ୍ ଅଁଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନିମାଣ୍ତା ରେମୁଆଁକେ ଗଦାର୍ ଦରକାର୍‌ ଣ୍ତୁ ମାତର୍‌‌ ରଗ୍ ସାଃଲେକ୍ନେ ରେମୁଆଁକେ ଗଦାର୍ ଦରକାର୍‌ । ନେଙ୍ଗ୍ ଦରମ୍ କରମ୍‌ ରେମୁଆଁକେ ବାସଙ୍ଗ୍‌ ନ୍‌ସା ପାଙ୍ଗ୍ ନ୍ନାଲେଃକେ ଣ୍ଡୁ । ନେଙ୍ଗ୍ ସରାଃ ପାପ୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ ରେମଆଁଇଂକେ ବାସଙ୍ଗ୍‌ ନ୍‌ସା ପାଙ୍ଗ୍‌ନ୍ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_18","071_2_18","MRK","2","18","18","ଜହନ୍‌ନେ ସିସ୍ଇଂ ଆରି ଫାରୁଶୀଇଂ ଉପାସ୍‌ ଡିଙ୍ଗ୍ଆର୍‌ଡିଂନେ ବେଲା, ଉଡ଼ିରୁଆ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ଜହନ୍‌ନେ ଆରି ପାରୁସି‍ଇଂନେ ସିସ୍ଇଂ ଉପାସ୍‌ ଡିଙ୍ଗ୍ଆର୍‌ଡିଂକେ, ମାତର୍‌‌ ପେନେ ସିସ୍ଇଂ ମେଃନ୍‌ସା ଉପାସ୍‌ ଆଡିଙ୍ଗ୍ଆର୍‌ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MK2_19","071_2_19","MRK","2","19","19","ଜିସୁ ଉତର୍ ବିକେ, “ବିଏ ଟିକା ଡିଙ୍ଗ୍‌କ୍ନେ ବେଲା ଙ୍ଗିରେ ମାନ୍ଦାନେ ରେମୁଆଁଇଙ୍ଗ୍‌ ଉପାସ୍‌ ଆଲେଃଆର୍ ଣ୍ଡୁ, ଡାଗ୍‌ଲା ଙ୍ଗିରେ ମେଇଙ୍ଗ୍‌ ଏତେ ଲେଃଏ । ତେସା ଙ୍ଗିରେ ଆତ୍ ଲେଃଜାକ ମେଇଙ୍ଗ୍‌ କେଡ଼େସ ଆଲେଃଆର୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_20","071_2_20","MRK","2","20","20","ମାତର୍‌‌ ବେଲା ପାଙ୍ଗ୍‌ଏ, ଙ୍ଗିରେକେ ମେଇଂନେ ବାନ୍ ସ୍ଲ ଡୁଂୱେଆର୍‌ଏ । ଆତେନ୍‌ ବେଲା ମେଇଙ୍ଗ୍‌ ଉପାସ୍‌ ଲେଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK2_21","071_2_21","MRK","2","21","21","“ଜାଣ୍ଡେ ବାୱିର୍ ପୁଆଃ ଅରିଆ ତ୍ମି ପୁଆଃ ବିଚେ ଆତଗ୍ଆର୍‌ ଣ୍ଡୁ । ଡାଗ୍‌ଲା ତ୍ମି ପୁଆଃନେ କନା କ୍ଲିଙ୍ଗ୍‌ଚେ ସକାକେ ଜାବର୍‌ ଆଃସ୍ୟାଃ ବିଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_22","071_2_22","MRK","2","22","22","ଦେତ୍ ରକମ୍ ଜାଣ୍ଡେ ଅଃନା ଡିଗ୍ ତ୍ମି ଅଙ୍ଗୁର୍ ରସ୍‌କେ ବାୱିର୍ ଉକ୍‌ସା ମୁନାଅରିଆ ଆବ ଣ୍ଡୁ । ତେଲା ଦେତ୍ ଡିଙ୍ଗ୍ଏ ତ୍ମି ଅଙ୍ଗୁର୍ ରସ୍ ବାୱିର୍‍ ଉକ୍‌ସା ମୁନାକେ ଆଃତେକ୍‌ପ୍ୟା ବିଃଏ ଆରି ଉକ୍‌ସାନେ ମୁନା ଏତେ ଅଙ୍ଗୁର୍ ରସ୍ ନାସେ ୱେଏ । ଆତେନ୍‌‌ସା ତ୍ମି ଅଙ୍ଗୁର୍ ରସ୍ ତ୍ମି ଉକ୍‌ସା ମୁନା ଅରିଆ ବ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK2_23","071_2_23","MRK","2","23","23","ପୁଣ୍ଡେନେ କେଲା ଜିସୁ ଗହମ୍ ଲିଜପାକା ୱେଡିଂଗେ । ମେଁନେ ସିସ୍ଇଂ ଡିଗ୍‌ ମେଁ ଏତେ ଆତେନ୍‌ ଗାଲି ୱେନେ ବେଲା ଜିସୁନେ ସିସ୍ଇଂ ଚୁଚଙ୍ଗ୍‌ସା ଗହମ୍‌ ଲିଜବାନ୍ ଗହମ୍ କେଡ଼୍‌କେ ଟିକ୍‌ଚିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK2_24","071_2_24","MRK","2","24","24","ଫାରୁଶୀଇଂ ଆତେନ୍‌‌ କେଚେ ଜିସୁକେ ବାଲିର୍‌ ଆର୍‌କେ, “କେଲାପା ପୁଣ୍ଡେନେ ଦିନା ମେଃଡିଗ୍ ଡିଙ୍ଗ୍‌ନେ ନିୟମ୍‌ ଣ୍ଡୁ, କୁକପାର୍ କେଲା ଦେଃକେନ୍ ସ୍ଲେ ଜିଉଦିନେ ନିୟମ୍‌ନ୍ନିଆ ଆବୁଲେ ଡିଙ୍ଗ୍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_25","071_2_25","MRK","2","25","25","ଜିସୁ ବାଲିର୍‌କେ, “ପେ ସାପାରେ ଦାଉଦ୍‌ନେ ସାମୁଆଁ ପଡ଼େ ପେଲେକେ ଜେ’ ମେଁ ଆରି ମେଁନେ ଏତେ ଲେଃକ୍ନେ ରେମଆଁ କେଡ଼େସଃ ଲେଃକ୍ନେ ବେଲା ଆରି ଚୁଚଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ ଲେକ୍ନେ ବେଲା ମେଁ ମେଃ ଡିଂବଗେ, ଆତେନ୍‌ ସାମୁଆଁ ପେ ଅଃନାଡିଗ୍ ପେ ପଡ଼େକେ ? ");
INSERT INTO gaq_vpl VALUES ("MK2_26","071_2_26","MRK","2","26","26","ମ୍ନାପୁଜାରି ଅବିୟାଥା ଆରି ମେଁନେ ରେମୁଆଁ ଆଣ୍ଡେଇଂ କିଡ଼େସଃଲା, ଦାଉଦ୍ ଇସ୍‌ପର୍‌ନେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଗାଚେ ଇସ୍‌ପର୍‌କେ ବିଃବକ୍ନେ ବଲେ ଚଙ୍ଗ୍‌ଲେଃଗେ ? ମୋଶାନେ ନିଅମ୍ ରକମ୍‍ ପୁଜାରିଇଂ ମାତର୍‌ ଆତେନ୍‌ ବଲେ ଆଃ ଚଙ୍ଗ୍ ୟାଆର୍‍ଏ । ଆମେଇଂକେ ଆନ୍ତାର୍ଚେ ଆରି ଆଜା ଡିଗ୍ ଆତେନ୍‌ ବଲେ ଚଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଣ୍ଡୁ । ଡାଗ୍ଲା ଦାଉଦ୍ ଆତେନ୍‌ ବଲେ ବାନ୍ ଇକୁଡ଼ା ଡିଗ୍ ମେଇଙ୍ଗ୍ ଏଃତେ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଚଙ୍ଗ୍‌ନେ ବିଃ ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK2_27","071_2_27","MRK","2","27","27","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଫାରୁଶୀଇଂକେ ବାଲିର୍‌କେ, “ରେମୁଆଁଇଂକେ ସାଇଜ ଡିଙ୍ଗ୍‌ନେସା ପୁଣ୍ଡେନେ ଦିନା ଆଃରେ ବ ଆର୍‌କେ । ରେମୁଆଁ ପୁଣ୍ଡେନେନ୍‌ସା ତିଆର୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK2_28","071_2_28","MRK","2","28","28","ଡେକ୍‌ରକମ୍‌ କି ଇସ୍‌ପର୍‌ ଉଙ୍ଗ୍‌ଡେ ସାନ୍ତା କାଲାନେ ମାପ୍ରୁ ଡିଂଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_1","071_3_1","MRK","3","1","1","ଆରି ମୁଇଙ୍ଗ୍‌ ତର୍ ଜିସୁ ଜିଉଦିଇଙ୍ଗ୍‌ନେ ପାର୍‌ତନା ଡୁଆ ୱେଲେଃକେ । ଆତ୍ଅରିଆ ମୁଇଙ୍ଗ୍‌ ଚାକ୍‌କୁଆଃତି ରେମଆଁ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_2","071_3_2","MRK","3","2","2","ଆତ୍ ଅରିଆ ଉଡ଼ି ରେମଆଁ ଉର୍‌ ଲେଃଆର୍‌କେ ଜେ ମାତର୍‌‌ ଜିସୁ ଆତେନ୍‌ ରେମୁଆଁକେ ପୁଣ୍ତେନେ ଦିନ୍ ନିମାଣ୍ଡା ଆଃଡିଙ୍ଗ୍ ବିଏ ତେଲା ମେଇଙ୍ଗ୍‌ ଜିସୁକେ ଦସ୍ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ନିମାନ୍‍ ବାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK3_3","071_3_3","MRK","3","3","3","ଜିସୁ ଆତ୍ ଲେଃକ୍ନେ ଚାକ୍‌କୁଆଃତି ରେମୁଆଁକେ ବେବିଃକେ “ଆକ୍‌ଅରିଆ ତୁଆଁ ଲାଃଲା ଡିରକମ୍ ଆନାକେ ସାପାରେ କେଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_4","071_3_4","MRK","3","4","4","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପୁଣ୍ତେନେ ଦିନା ଆଣ୍ତିନେ ସାସ୍ତର୍‌ନେ ନିଅମ୍ ? ନିମାଣ୍ଡା ଣ୍ଡ୍ରାଃଡିଂଏ ଲେଃ ଦଦିଆ ଣ୍ଡ୍ରାଃଡିଂଏ ? ମୁଇଙ୍ଗ୍‌ଜାନେ ପାରାନ୍ ଆମ୍ବ୍ରନେ ଟିକ୍ ଲେଃ ପାରାନ୍ ଦଦ୍ୟା ଆଡିଙ୍ଗ୍‌ନେ ଟିକ୍ ?” ମାତର୍‌‌ ମେଇଙ୍ଗ୍ ବୁଙ୍ଗ୍‌ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_5","071_3_5","MRK","3","5","5","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ରେମୁଆଁଇଂ ପାକା ରିସା ଡିଂଚେ କେକେ; ମାତର୍‌‌ ମେଇଙ୍ଗ୍‌ନେ ଗାଗ୍‌ଡ଼େ ଡାଟ୍‌ ଲେଃକେ ରକମ୍ କେଚେ ଜାବର୍‌ ଲିବିସ ଆର୍‌କେ । ଜିସୁ ଆତେନ୍‌ ରେମୁଆଁକେ ବାସଙ୍ଗ୍‌କେ “ପେନେ ନ୍ତି ଆନେଙ୍ଗ୍‌କେ ଆଃସୁଏ ।” ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ଜିସୁ ପାକା ନ୍ତି ଆଃଚ୍ଲେବିଃକେ ଆରି ମେଁନେ ନ୍ତି ନିମାନ୍‍ ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_6","071_3_6","MRK","3","6","6","ଇଡ଼ିଙ୍ଗ୍ ପାରୁସିଇଙ୍ଗ୍ ଆତ୍‌ବାନ୍ ୱିଗ୍ ଆର୍‌ଗେ ଆରି ହେରୋଦିୟଇଂ ଏତେ କୁଡ଼େଚେ ଜିସୁକେ ବାଗୁଏ ନ୍‌ସା କୁଟ୍ ଡିଂଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_7","071_3_7","MRK","3","7","7","ଜିସୁ ମେଁନେ ସିସ୍ଇଂ ଏଃତେ ଗାଲିଲୀ କେଣ୍ତିଆ ଆଃଡ଼ା ୱେଆର୍ଗେ । ମେଇଙ୍ଗ୍‌ନେ ପ୍ଲା ଗାଲିଲୀନେ ଗୁଲେ ରେମୁଆଁଇଂ ଡିଗ୍ ୱେଆର୍ଗେ ଆରି ଜିଉଦା ପ୍ରଦେସ୍, ");
INSERT INTO gaq_vpl VALUES ("MK3_8","071_3_8","MRK","3","8","8","ଯିରୂଶାଲାମ୍, ଏଦୋମ, ଯର୍ଦ୍ଦନ୍‌ କେଣ୍ତିଆ ଇନୁମେତା ସୋର ଆରି ସୀଦୋନନ୍ନିଆ ଲେଃକ୍ନେ ସହର ଡାଗ୍ରାବାନ୍‌ ପାଙ୍ଗ୍‌ଲେଃଆର୍‌ଗେ । ଆକେନ୍ ରେମୁଆଁଇଙ୍ଗ୍‌ ପାଙ୍ଗ୍‌ନେ ଡାଗ୍ରା ଡିଂଡିଂକେ ଜିସୁ ଆଣ୍ଡିନେ ସାପା ଡିଙ୍ଗ୍‌ବକେ ଆତେନ୍‌ ସାପା ଗଟ୍‌ନା ମେଇଙ୍ଗ୍ ଅଁ ଆଃଡା ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_9","071_3_9","MRK","3","9","9","ଜିସୁ ଗୁଲେ ରେମୁଆଁଇଂକେ କେକେ ଗହଲି ଡିଙ୍ଗ୍‌ଲେଃଲା ରେମୁଆଁଇଙ୍ଗ୍‌ ଡିରକମ୍ ମେଁଇଙ୍ଗ୍‌ନେ ପାକା ଟେଚା ଆପାଙ୍ଗ୍‌ ଆର୍‌ଲେ ଆତେନ୍‌‌ସା ମେଁ ନିଜେ ସିସ୍ଇଂକେ ମୁଇଙ୍ଗ୍‌ ଡାଆଁନେ ତରା ମେଁନ୍‌ସା ତିଆର୍ ଆଡିଙ୍ଗ୍‌ନେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_10","071_3_10","MRK","3","10","10","ଜିସୁ ଗୁଲେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌କେ । ତେଲା ସାପା ରଗ୍ ରେମୁଆଁଇଙ୍ଗ୍‌ ଆମେକେ ଲିଗ୍‍ନେ ସା ମେଁ ପାକା ଟେଚା ଟେଣ୍ତୁର୍‌ ରାଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_11","071_3_11","MRK","3","11","11","ଉଡ଼ି ରେମୁଆଁନେ ଗାଗ୍‌ଡ଼େ ଗଲିଆଇଂ ଗା ଲେଃଆର୍‌କେ । ଉଡ଼ିବେଲା ଆତେନ୍‌ ଗଲିଆଇଂ ଜିସୁକେ କେଆର୍‌କ୍ନେ ଦାପ୍ରେ ମେଇଙ୍ଗ୍‌ ମେଁନେ ବୁନ୍ଦେ ଲଃଚେ ୱାସାର୍‌ଚେ ବାଲିର୍‌ଆର୍‌କେ, “ନାଁ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_12","071_3_12","MRK","3","12","12","ମାତର୍‌‌ ଜିସୁ ଗଲିଆଇଂକେ ନିମାଣ୍ଡା ବାବ୍‌ରେ ଆଦେସ୍‍ ବିକେ ଜେ ମେଁ ଜାଣ୍ଡେ ଆକେନ୍ ମେଇଙ୍ଗ୍ ରେମୁଆଁଇଂକେ ଡିରକମ୍ ଆବାସଙ୍ଗ୍‍ ଆର୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_13","071_3_13","MRK","3","13","13","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମୁଇଙ୍ଗ୍‌ କଣ୍ତା ଆଡ଼ାତ୍ରା ୱେକେ । ମେଁ ଆଣ୍ଡିନେ ରେମୁଆଁଇଂକେ ଚାଏଁକେ ଆମେଇଂକେ ମେଁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଲାପା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ । ମେଇଙ୍ଗ୍‌ ଜିସୁନେ ଡାଗ୍ରା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_14","071_3_14","MRK","3","14","14","ଜିସୁ ମେଇଙ୍ଗ୍‌ନେ ବିତ୍ରେ ଗମ୍ବାର୍‍କ୍ଲିଗ୍ ସିସ୍‌କେ ବାଚେଚେ ପ୍ରେରିତ୍‌ ଡାଗ୍‌ଚେ ମ୍ନି ବିଃକେ । ଜିସୁ ଚାଏଁଲେଃଗେ ଜେ “ମେଇଙ୍ଗ୍ ମେଁନେ ଏଃତେ ଲେଃଏ ।” ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌ ନ୍‌ସା ବିନ୍‌ ଜାଗାଅରିଆ ବେବିଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_15","071_3_15","MRK","3","15","15","ରେମୁଆଁଇଙ୍ଗ୍‌ନେ ଗାଗ୍‌ଡ଼େ ବାନ୍ ଗଲିଆ‍ଇଂକେ ନୁଆଁନ୍‌ସା ଆମେଇଂକେ ଅଦିକାର୍‌ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MK3_16","071_3_16","MRK","3","16","16","ଜିସୁ ସ୍ରିବକ୍ନେ ଗମ୍ବାର୍‌କ୍ଲିଗ୍‌ନେ ମ୍ନି ଦେକ୍‌ରକମ୍; ଶିମୋନ୍‌ ଆଜାକେ ମେଁ ପିତର୍‌ ଡାଗ୍‌ଚେ ମ୍ନି ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_17","071_3_17","MRK","3","17","17","ଜେବଦୀ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌ ଆରି ମେଁନେ ବୟାଁଣ୍ଡେ ଜହନ୍‌ ଜାଣ୍ତେକେ ମେଁ ବିନେରିଗୋଷ ଡାଗ୍‌ଲା “ମେଘନାଦନେ ଉଙ୍ଗ୍‌ଡେ” ଡାଗ୍‌ଚେ ମ୍ନି ବିକେ; ");
INSERT INTO gaq_vpl VALUES ("MK3_18","071_3_18","MRK","3","18","18","ଆନ୍ଦ୍ରିୟ ଫିଲିପ୍‌ପ ବାର୍ଥଲମି ମାତିଉ ଥୋମା ଆଲଫିନେ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌ ଥଦ୍ଦୀୟ କିଣାନୀୟ ଶିମୋନ୍‌ ଜାଣ୍ଡେ ଇଶ୍ରାୟେଲକେ ଆନ୍ତାର୍ ନ୍‌ସା ଚାଏଁଡିଂକ୍ନେ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ମୁଇଂଜା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_19","071_3_19","MRK","3","19","19","ଆରି ଇଷ୍କରିୟଥ୍ ଜିଉଦା । ଆକେନ୍ ଜିଉଦା ଇଡ଼ିଙ୍ଗ୍ ଜିସୁକେ ସତ୍ରୁନେ ନ୍ତିନ୍ନିଆ ଅପେଃ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_20","071_3_20","MRK","3","20","20","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଡୁଆ ୱିଗ୍‌କେ । ଆତ୍ ଅରିଆ ଡିଗ୍ ଗୁଲେ ରେମୁଆଁ ରିସିଙ୍ଗ୍‌ ଆର୍‌କେ । ଆତ୍ ଅରିଆ ଅଃକେନ୍ ରେମୁଆଁ ଲେଃଆର୍‌କେ ଜେ ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌ଇଂ ଚଙ୍ଗ୍ଉଗ୍ ଆୟା ଆର୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK3_21","071_3_21","MRK","3","21","21","ଜିସୁନେ ଡୁଆଣ୍ଡ୍ରେଇଂ ଆକେନ୍ ସାପା ଅଁଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ୱାଉଙ୍ଗ୍‌ ୱେଆର୍‌ଗେ । ମେଇଂ ବାସଙ୍ଗ୍‌କେ ଜେ “ଜିସୁକେ ବାଆଲ୍‌ଜିବୁଲ୍‌ ସାଃଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_22","071_3_22","MRK","3","22","22","ଯିରୂଶାଲମବାନ୍ ପାଙ୍ଗ୍‌ଲେଃକ୍ନେ ଦରମ୍ କରମ୍‌ ଣ୍ଡ୍ରେଇଂ ବାସଙ୍ଗ୍‌କେ, “ଜିସୁନେ ଗାଗ୍‌ଡ଼େ ବାଆଲ୍‌ଜିବୂଲ ଗାଲେଃକେ । ଆତେନ୍‌‌ସା ଜିସୁ ଗଲିଆଇଂକେ ବାଆଲ୍‌ଜିବୁଲ୍‌ ସାଇଜରେ ଗଲିଆକେ ଆଃଆନ୍ତାର୍‌ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_23","071_3_23","MRK","3","23","23","ତେସା ଜିସୁ ମେଇଂ ଡାଗ୍ରା ୱେଚେ ଆରି ଆଦେସ୍ ରକମ୍‌ ଆମେଇଂକେ ଆଃବୁଜେଚେ ବାସଙ୍ଗ୍‌କେ, “ଗଲିଆ ଡିରକମ୍ ଗଲିଆକେ ନୁଆଁ ଜଗ୍‌ତ୍ଲାଗ୍‌ଏ ? ");
INSERT INTO gaq_vpl VALUES ("MK3_24","071_3_24","MRK","3","24","24","ଡାଗ୍‌ଲା ଆଣ୍ତିନେ ଦେସ୍ ନିଜର୍‌ ବିତ୍ରେ ଜୁଜ୍ ଡିଙ୍ଗ୍ଏ, ତେଲା ଆତେନ୍‌‌ ଆରି ନିମାଣ୍ତା ଆଲେଃ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK3_25","071_3_25","MRK","3","25","25","ବାରି, ଜଦି ମୁଡ଼ି ଡୁଆ ବାଗ୍‌ ବାଗ୍‌ ଡିଂଚେ ମେଇଂନେ ବିରୁଦ୍‌ରେ ତଃଡ଼୍ୟାଏ, ତେଲା ଆତେନ୍‌‌ ଡୁଆ ବୁଂ ଆଲେଃ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK3_26","071_3_26","MRK","3","26","26","ଦେତ୍‌ରକମ୍ ମୁଇଙ୍ଗ୍‌ ସୟ୍‌ତାନ୍‌ନେ ରାଜି ବିଗ୍‌ଡ଼େ ୱେଚେ ନିଜର୍ ବିତ୍ରେ ରିଙ୍ଗ୍‌ଆଃ ପାଙ୍ଗ୍‌ଏ, ତେଲା ମେଁ ଡିଗ୍ ନିମାଣ୍ତା ଆଲେଃ ଣ୍ତୁ । ଆରି ମେଁନେ ଦଂସ ଡିଂୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_27","071_3_27","MRK","3","27","27","“ଜଦି ମୁଇଙ୍ଗ୍‌ ରେମୁଆଁ ମୁଇଙ୍ଗ୍‌ ବପୁ ଲେଃକ୍ନେ ରେମୁଆଁ ଡୁଆ ଗାଚେ ମେଁନେ ଦନ୍‌ସମ୍ପତି ଡଙ୍ଗା ଡୁଂୱିଗ୍‌ନେ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ଏ, ତେଲା ସେନୁଗ୍‌ ମେଁ ବପୁ ଲେଃକ୍ନେ ରେମୁଆଁକେ ଗାଗ୍‌ଏ; ଇଡ଼ିଙ୍ଗ୍ ମେଁ ବପୁ ଲେଃକ୍ନେ ରେମୁଆଁନେ ଡୁଆ ଡଙ୍ଗାଚେ ସାପା ମେଁ ମେଁନେ ଡୁଂୱିଗ୍ ୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_28","071_3_28","MRK","3","28","28","“ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ । ରେମୁଆଁ ଡିଡିରକମ୍ ପାପ୍ ଡିଙ୍ଗ୍ଆର୍‌ଡିଂକେ, ଆତେନ୍‌ ସାପା ଲିବିସଃ ଡିଙ୍ଗ୍‌ ବିଃଆର୍‌ଏ । ରେମୁଆଁ ପର୍‌ମେସର୍‌ନେ ବିରଦ୍‌ରେ ଉଡ଼ି ସାପା ଦଦ୍ୟା ସାମୁଆଁଇଙ୍ଗ୍‌ ବାସଂଡିଙ୍ଗ୍‌ଆର୍‌କେ, ଆତେନ୍‌ ସାପା ଡିଗ୍ କେମା ଡିଙ୍ଗ୍‌ବିଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK3_29","071_3_29","MRK","3","29","29","ମାତର୍‌‌ ପବିତ୍ର ଆତ୍ମା ବିରଦ୍‌ରେ ଆଣ୍ତିନେ ରେମୁଆଁ ମେଃଡିଗ୍ ବାସଙ୍ଗ୍ଏ, ଆମେକେ ଅଃନା ଡିଗ୍ କେମା ଆମିଲେ ଣ୍ତୁ । ମେଁ ମାଡାନେ କାଲ୍‌ କାଲ୍‌ ଜାକ ପାପ୍‌ନେ ଦସ୍ ଡିଙ୍ଗ୍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_30","071_3_30","MRK","3","30","30","ଦରମ୍ କରମ୍‌ ଡିଣ୍ଡ୍ରେଇଂ ଜିସୁ ଡାଗ୍ରା ଗଲିଆ ଲେଃକେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ବଲା ଜିସୁ ଆକେନ୍ ସାପା ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_31","071_3_31","MRK","3","31","31","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆରି ବୟାଁଣ୍ତେଇଂ ଆତ୍ ଅରିଆ ପାଙ୍ଗ୍ ଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ବାଜାର୍‌ ତୁଆଁ ଆର୍‌କେ ଆରି ମୁଇଙ୍ଗ୍‌ ରେମୁଆଁକେ ଜିସୁକେ ବାଜାର୍‌ ପାଙ୍ଗ୍‌ ନ୍‌ସା ୱା ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ ନ୍‌ସା ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK3_32","071_3_32","MRK","3","32","32","ଆତେନ୍‌ ବେଲା ଜିସୁନେ ପିତୁର୍ ପାକା ରେମୁଆଁଇଂ ଗେରେଚେଃ କ ଲେଃଆର୍‌ଗେ । ମେଇଙ୍ଗ୍‌ ଆମେକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “କେଲା ପିୟାଙ୍ଗ୍‍ ଆରି ବୟାଁଇଂ ଆରି ତନାଇଂ ଆନାକେ ବାଜାର୍‌ ଉର୍ ଲେଃଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK3_33","071_3_33","MRK","3","33","33","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଜାଣ୍ଡେ ନେଙ୍ଗ୍ ଇୟାଙ୍ଗ୍ ? ଜାଣ୍ଡେଃଇଂ ନେଙ୍ଗ୍‌ନେ ବୟାଁ ?” ");
INSERT INTO gaq_vpl VALUES ("MK3_34","071_3_34","MRK","3","34","34","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମେଁନେ ପିତୁର୍ କ ଲେଃକ୍ନେ ରେମଆଁଇଂ ପାକା କେକେ । ମେଁ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍‌ ରେମୁଆଁଇଂ ନେଙ୍ଗ୍‌ନେ ଇୟାଙ୍ଗ୍ ଆରି ବୟାଁ । ");
INSERT INTO gaq_vpl VALUES ("MK3_35","071_3_35","MRK","3","35","35","ଜାଣ୍ଡେଇଂ ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚାକେ ପୁରନ୍‌ ଡିଂଆର୍‌ଏ, ମେଇଙ୍ଗ୍‌ ଆଃ ନେଙ୍ଗ୍‌ନେ ବୟାଁ ତନା ଆରି ଇୟାଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_1","071_4_1","MRK","4","1","1","ଜିସୁ ଆରି ଗାଲିଲୀ କେଣ୍ତିଆ ଆଃଡ଼ାପାକା ଆଃଦ୍ରିଗ୍‌ ନ୍‌ସା ମୁଲେକେ । ଆତ୍ଅରିଆ ମେଁନେ ପିତୁର୍ ପାକା ଗୁଲୁଏ ରେମୁଆଁ ରିସିଂ ଆର୍‌କେ । ତେସା ମେଁ କେଣ୍ତିଆ ଅରିଆ ଲେଃକ୍ନେ ମୁଇଂ ତରାନ୍ନିଆ ୱେଚେ କକେ । ବିନ୍‌ ସାପା ରେମଆଁଇଂ କେଣ୍ଡିଆନେ ଆଃଡ଼ା ତୁଆଁଲେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_2","071_4_2","MRK","4","2","2","ଜିସୁ ଆମେଇଂକେ ଉଃସ୍ରା ଆଃଦ୍ରିଗ୍‌ଚେ ଗୁଲୁଏ ସାମୁଆଁ ବାଲିର୍‌କେ । ମେଁ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_3","071_4_3","MRK","4","3","3","“ଅଁପା; ମୁଇଂ ରେମୁଆଁ ବିଗ୍‌ଜା ତାର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_4","071_4_4","MRK","4","4","4","ଉଡ଼ିବେଲା ଲିଜ ସ୍ଲେଣ୍ଡ୍ରେ କିଆ ବିଗ୍‌ ଡିଙ୍ଗ୍‌କେ ଆତ୍ ବାନ୍ ମେଁ ଲିଜନ୍ନିଆ ଚୁମୁଜା ବିଗ୍‍ନେ ବେଲା ଉଡ଼ି କିଆ ଗାଲି ଲଃଲା ପ୍ଲିଗ୍‍ଇଂ ପାଙ୍ଗ୍‌ଚେ ଆତେନ୍‌ ସାପା ଚଙ୍ଗ୍‌ବିଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_5","071_4_5","MRK","4","5","5","ଆରି ଉଡ଼ିକ୍ଲିଗ୍ ମଞ୍ଜି ଇକୁଡ଼ା ତୁବଃ ଲେଃନେ କିଡ଼ିଲ ତୁବଃନ୍ନିଆ ଲଃକେ । ଆତେନ୍‌ ତୁବଃ କୁବାଂ ଆଲେଃଲା ମୁଞ୍ଜି ଜିଆ ଜିଆ ପଃଡ଼୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_6","071_4_6","MRK","4","6","6","ମାତର୍‌ ମେଁନେ ଚେର୍ ଆଲେଃଗେସା ନ୍ନାଃସେଙ୍ଗ୍‍ଲା ନ୍‌ସୁଆର୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_7","071_4_7","MRK","4","7","7","ଆରି ଉଡ଼ିକ୍ଲିଗ୍‌ ଗ୍ରେଃ ସ୍ଲାଃଇଂନେ ମଜେ ଲଃକେ ବାରି, ଗ୍ରେଃ ସ୍ଲାଃଇଂ ତଃଡ଼୍ୟାଚେ ମ୍ନା ଡିଂଚେ ଆତେନ୍‌‌ଇଂକେ ଚାପେ ବିଃକେ । ବାରି ମେଃଡିଗ୍‌ ଚୁ ଆଚୁକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK4_8","071_4_8","MRK","4","8","8","ବାରି ଉଡ଼ି ଚୁମୁଜା ନିମାଣ୍ଡା ଲିଜନ୍ନିଆ ଲଃଚେ । ଆତେନ୍‌‌ ସ୍ଲା ଡିଙ୍ଗ୍‌କେ । ସ୍ଲା ନିମାଣ୍ତା ତଡ଼ିଆକେ ଆରି କିଆ ଗ୍ଲିକେ । ଉଡ଼ି ସ୍ଲାନ୍ନିଆ ତିରିସ୍‌ ଗୁନ୍ ବା ଞ୍ଜିକୁଡ଼ି ଗୁନ୍ ବା ଦେକ୍‌ରକମ୍ ଉଡ଼ି ସ୍ଲା ନ୍ନିଆ ମାଲ୍‍କୁଡ଼ି ଜାକ ମୁଞ୍ଜି ସାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_9","071_4_9","MRK","4","9","9","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେନେ ବିତ୍ରେ ଜାନେ ଦ୍ରିଗ୍ ନ୍‌ସା ନ୍‌ଲୁଗ୍ ଲେଃକେ, ମେଁ ଦ୍ରିଗ୍‌ଲେଃ ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_10","071_4_10","MRK","4","10","10","ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିବେଲା ଜିସୁ ମୁଇଙ୍ଗ୍‌ଜା ଲେଃଗେ, ଆତେନ୍‌‍ ବେଲା ମେଇଂନେ ତ୍ମାକ୍ଲିଗ୍ ଜାକ ପ୍ରେରିତ୍‌ ଆରି ମେଁ ଏତେ ଲେଃକ୍ନେ ସିସ୍‌ଇଙ୍ଗ୍‌ ଆମେକେ ଉଃସ୍ରା ବିସୟ୍‌ରେ ସାଲ୍ୟାଃକୁଆର୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MK4_11","071_4_11","MRK","4","11","11","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଇସ୍‌ପର୍‌ନେ ରାଜିନେ ଗୁନ୍‌ ବୁଜେନ୍‌ସା ଆପେକେ ବପୁ ବିଃବକେ, ମାତର୍‌‌ ବିନ୍‌ଣ୍ଡ୍ରେନ୍‌ସା ଏନ୍ ସାପା ଉଃସ୍ରା ବାସଙ୍ଗ୍‌ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_12","071_4_12","MRK","4","12","12","ମେଇଂ କିକେ ଲେଃଆର୍‌ଏ, ମାତର୍ ମେଃଡିଗ୍ ବୁଜେ ଆୟା ଆର୍‌ ଣ୍ତୁ; ସାପା ସାମୁଆଁ ଅଁ ଲେଃଆର୍‌ଏ, ମାତର୍ ମେଃଡିଗ୍ ବୁଜେ ଆୟାଆର୍‌ ଣ୍ଡୁ । ମେଇଂ ଜଦି ସତ୍‌ରେ ପାକେଆର୍ ଆରି ପାବୁଜେଆର୍, ମେଇଂ ଇସ୍‌ପର୍‌ନେ ଡାଗ୍ରା ଆଣ୍ଡେ ପାପାଙ୍ଗ୍‌ଆର୍ ବାରି ଇସ୍‌ପର୍ ଆମେଇଂକେ କେମା ପାବିଃ ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_13","071_4_13","MRK","4","13","13","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେ ଆକେନ୍ ବୁଜେନେ ସାମୁଆଁ ମ୍ୟା ପେଡିଙ୍ଗ୍‌କେ ଲେଃ ଣ୍ଡୁ ? ତେଲା ବିନ୍ ସାମୁଆଁଇଙ୍ଗ୍ ଡିରକମ୍ ପେବୁଜେଏ ? ");
INSERT INTO gaq_vpl VALUES ("MK4_14","071_4_14","MRK","4","14","14","ସ୍ଲେନେ ରେମୁଆଁଇଂ ମନ୍‌ ବିତ୍‌ରେ ପର୍‌ମେସର୍‌ନେ ସାମୁଆଁ ବିଗ୍‌କ୍ନେ ରେମୁଆଁ ରକମ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("MK4_15","071_4_15","MRK","4","15","15","ଜାଣ୍ଡେଇଂ ଅଁଆର୍‌ଏ ଉଡ଼ି ରେମୁଆଁ ଆକେନ୍ ଗାଲି ରକମ୍‌ ଆତେନ୍‌ ରେମୁଆଁଇଂ ପର୍‌ମେସର୍‌ନେ ସାମୁଆଁ ଅଁ ଆର୍‌ଏ, ମାତର୍‌‌ ସୟ୍‌ତାନ୍‌ ଟାପ୍‌ନା ପାଙ୍ଗ୍‌ଚେ ମେଇଙ୍ଗ୍‌ନେ ବିତ୍ରେ ବାସଙ୍ଗ୍‌କ୍ନେ ସାମୁଆଁକେ ଡୁଂଡଏ । ");
INSERT INTO gaq_vpl VALUES ("MK4_16","071_4_16","MRK","4","16","16","ଆରି ଉଡ଼ି ରେମୁଆଁ ବାଟା ଟିକ୍ରା ବିଗ୍‌କ୍ନେ କିଆ ରକମ୍ ମେଇଙ୍ଗ୍ ସାମୁଆଁ ଦ୍ରିଗ୍ଆର୍‌ଏ ଆରି ଦାପ୍‌ରେ ସାର୍ଦାରେ ଆତେନ୍‌‌ ସାଚେ ଡୁଂୱିଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK4_17","071_4_17","MRK","4","17","17","ତେଲା ମେଁନେ ଚେର୍‌ ମେଇଂନେ ଜିବନ୍ ବିତ୍ରେ ଆଃଗା ଆୟାଆର୍‌ ଣ୍ତୁ । ମାତର୍‌‌ ପ୍ରେଗ୍‌ନ୍‌ସା ମେଇଙ୍ଗ୍‌ ସାମୁଆଁକେ ସାଃ ମ୍ୟାଃଆର୍‌କେ । ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିବେଲା ଦୁକ୍‌ କସ୍ଟ ଆରି ତାଡ଼ନା ପାଙ୍ଗ୍‌ଏ, ମେଇଙ୍ଗ୍ ପ୍ଲାଃ ଗୁଚେ ୱେଆର୍‍ଏ, ଆତେନ୍‌‌ ବେଲା ମେଇଂ ଟାପ୍‌ନା ବିସ୍‌ବାସ୍‌ ଆନ୍ତାର୍‌ ବିଃ ଆର୍‌ଏ । ଆରି ମେଇଙ୍ଗ୍ ବିଗ୍‌କ୍ନେ ଟିକ୍ରା ଲିଜ ଏଃତେ ସମାନ୍ । ");
INSERT INTO gaq_vpl VALUES ("MK4_18","071_4_18","MRK","4","18","18","ଆରି ଉଡ଼ି ରେମୁଆଁ ଗ୍ରେଃ ଲାଟା ଅରିଆ ଲଃଲେକ୍ନେ କିଆ ରକମ୍ । ମେଇଙ୍ଗ୍ ସାମୁଆଁ ଦ୍ରିଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK4_19","071_4_19","MRK","4","19","19","ମାତର୍‌‌ ମେଁଇଙ୍ଗ୍‌ ସଂସାର୍‌ନେ ଚିନ୍ତା ଆରି ଦନ୍‍ନେ ଲବ୍ ଆରି ବିନ୍ ଜିନିସ୍ ଲାବ୍‌ ଆଡିଙ୍ଗ୍‌ନେ ଲାଲ୍‌ସା ପାଙ୍ଗ୍‌ଏ ଆରି ଆତେନ୍‌ଇଂ ସାମୁଆଁକେ ମିଗ୍ ଜଗ୍‌ତ୍ଲିଗ୍‌ଏ । ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌‌ ପାରାନ୍‌ନ୍ନିଆ ଚୁଚୁ ଆଚୁ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK4_20","071_4_20","MRK","4","20","20","ଉଡ଼ି ରେମୁଆଁ ନିମାଣ୍ତା ତୁବଃଅରିଆ ବିଗ୍‌କ୍ନେ କିଆ ରକମ୍‌ ମେଇଙ୍ଗ୍ ସାମୁଆଁ ଆଣ୍ଡେଙ୍ଗ୍ ଅଁ ଆର୍‌ଏ ଆରି ଆତେନ୍‌ ସାଃଆର୍‌ଏ । ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍ ମ୍ନାଃ ଡିଙ୍ଗ୍‌ଚେ ସାକାର୍‌ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ଆତେନ୍‌‌ ଉଡ଼ି ଉଡ଼ିବେଲା ତିରିସ୍‌ ଗୁନ୍ ଞ୍ଜିକୁଡ଼ି ଗୁନ୍ ବା ମାଲ୍‍କୁଡ଼ି ଗୁନ୍ ଜାକ ମୁଞ୍ଜି ବିଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_21","071_4_21","MRK","4","21","21","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେଇଂକେ ବାଲିର୍‌କେ “ଜାଣ୍ଡେ ଅଃନା ମେଁନେ ଙ୍କୁଇ ବୁନ୍ଦେ ଲେଃ କଟ୍ ଆଲ କୁପିସ ବ ପେମ୍ୟାଃକ୍ଲେ ? ପେ କୁପିସ ବ ପେମ୍ୟାକ୍ନେ ଆଡ଼ାତ୍ରା କୁପିସ ବନ୍‌ସା ଡୁଂପେପାଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_22","071_4_22","MRK","4","22","22","ମେଃନେ ସାପା ବୁଃଡ଼ି ଲେଃକେ, ଆତେନ୍‌‌ ତ୍ନାଏ, ମେଃନେ ସାପା ଡିଡାଚେ ଲେଃକେ, ଆତେନ୍‌‌ ଆଡା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK4_23","071_4_23","MRK","4","23","23","ଜଦି ଜାଣ୍ଡେନେ ଅଁନେ ନ୍ଲୁଗ୍‍ ଲେଃକେ ମେଁ ଅଁପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_24","071_4_24","MRK","4","24","24","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ମେଃନେ ଦ୍ରିଗ୍‌ପେଡିଙ୍ଗ୍‌କେ, ଆତେନ୍‌‌ ଆଡ଼ାତ୍ରା ମନ୍‌ଦ୍ୟାନ୍‌ ବିଃପା । ଡିରକମ୍ ବାବ୍‌ରେ ପେ ବିନ୍‌ ରେମୁଆଁକେ ବିଚାର୍‌ ପେଡିଙ୍ଗ୍‌ଏ ଦେତ୍‌ରକମ୍ ମାଲେ ଡାଟାମ୍ ବାବ୍‌ରେ ଇସ୍‌ପର୍‌ ପେନେ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK4_25","071_4_25","MRK","4","25","25","ଜାନେ ଲେଃକେ, ଆମେକେ ଜବର୍ ବିଃଏ । ମାତର୍‌ ଜାନେ ଡାଗ୍ରା ଣ୍ତୁ, ମେଁ ଡାଗ୍ରା ମେଃନେ ସାପା ଲେଃକେ, ଆତେନ୍‌ ସାପା ଡୁଂଡଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_26","071_4_26","MRK","4","26","26","ଜିସୁ ଆରି ବାସଙ୍ଗ୍‌କେ, “ପର୍‌ମେସର୍‌ନେ ରାଜି ଲିଜ ଅରିଆ କିଆ ବିଗ୍‌କ୍ନେ ରେମୁଆଁ ରକମ୍ । ");
INSERT INTO gaq_vpl VALUES ("MK4_27","071_4_27","MRK","4","27","27","ମିଡିଗ୍‌ବଃ ଡୁଲେଗ୍‌ଏ ଆରି ସ୍ମି ଉର୍‌ଏ, ମାତର୍‌ ଚ୍ମୁଜା ପଃଡ଼୍ୟାଚେ ଡିରକମ୍‌ ମ୍ନାଃଏ, ଆତେନ୍‌‌ ମେଁ ଆମ୍ୟାଃ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK4_28","071_4_28","MRK","4","28","28","ସ୍ଲା ମ୍ନାଚେ ଚୁଚୁ ସାଃନ୍‌ସା ତୁବଃ ଆଃ ସାପା କିଚି ଡିଙ୍ଗ୍‌ଏ । ସେନୁଗ୍ ଉଲିଆ, ଇଡ଼ିଙ୍ଗ୍ କେଡ଼୍‌, ଇଡ଼ିଙ୍ଗ୍ ସ୍ଲା ବାନ୍ ବର୍‌ତି କିଆ ଡିଙ୍ଗ୍‌ଏ; ");
INSERT INTO gaq_vpl VALUES ("MK4_29","071_4_29","MRK","4","29","29","ଉଡ଼ିବେଲା କିଆ ବ୍ଲେଏ, ଆତେନ୍‌‍ବେଲା ଆତେନ୍‌ ରେମୁଆଁ ନ୍‌ସଗ୍ ଡୁଂୱେଚେ ଆମେକେ ୱେଃଏ । ଡାଗ୍ଲା ଆକେନ୍ ଆଃ ୱେଃନେ ସମାନ୍ ବେଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_30","071_4_30","MRK","4","30","30","ଜିସୁ ଆରି ବାସଙ୍ଗ୍‌କେ, “ପର୍‌ମେସର୍‌ ରାଜି ଜା ଏତେ ତୁଲେଚେ ନେଙ୍ଗ୍ ଆପେକେ ମ୍ବୁଜେଏ ? ନେଙ୍ଗ୍ ଆଣ୍ତିନେ ସାମୁଆଁ ରକମ୍‌ ଆକେନ୍ ମ୍ୱୁଜେଏ ? ");
INSERT INTO gaq_vpl VALUES ("MK4_31","071_4_31","MRK","4","31","31","ପର୍‌ମେସର୍‌ନେ ରାଜି ମୁଇଙ୍ଗ୍‌ ସୋରିଷ ମୁଞ୍ଜି ସୁଗୁଆ । ଆକେନ୍ ସୋରିଷ ମୁଞ୍ଜି ପେ ଲିଜ ନ୍ନିଆ ବିଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ ବୁନୁଜା ବିତ୍ରେ ସାପାବାନ୍‍ ଡାଆଁ । ");
INSERT INTO gaq_vpl VALUES ("MK4_32","071_4_32","MRK","4","32","32","ମାତର୍‌ ପେ ବିଗ୍‍ନେ ଡାଲା ଆତେନ୍‌ ମୁଞ୍ଜି ତଡ଼ିଆଚେ ପେ ଲିଜନେ ବିନ୍ ସ୍ଲା ବିତ୍ରେ ସାପା ବାନ୍ ମ୍ନା ଡିଙ୍ଗ୍‌ୱେଏ । ମେଁନେ କେନ୍ଦା ଆଣ୍ଡେଙ୍ଗ୍ ମ୍ନା ଡିଙ୍ଗ୍‌ୱେଏ । ପ୍ଲିଗ୍‌ଇଂ ପାଙ୍ଗ୍‌ଚେ ମେଁନେ ନ୍‌ଲୁଡ଼ିଆଃ ଅରିଆ ଉଙ୍ଗ୍‌ଚ୍ୟା ଗାଗ୍‌ଚେ ଲେଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK4_33","071_4_33","MRK","4","33","33","ଦେକ୍‌ରକମ୍ ଗୁଲୁଏ ଉଃସ୍ରା ରକମ୍ ବାସଙ୍ଗ୍‌ଚେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌‌ ଡିଙ୍ଗ୍‌କେ; ମେଇଂ ଉଡ଼ି ବୁଜେ ୟାଆର୍‌ଏ ମେଁ ଅଃତେନ୍‍ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_34","071_4_34","MRK","4","34","34","ଜିସୁ ରେମଆଁଇଂକେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ କେଲା କାଲାଆଃ ଆଃବୁଜେଚେ ବାଲିର୍‌ମ୍ୟାକେ । ମାତର୍‌‌ ଜିସୁ ଏତେ ମେଁନେ ସିସ୍ଇଂ ମୁଇଂଜା ଲେଃକ୍ନେ ବେଲା ଆତେନ୍‌‌ ବେଲା ଜିସୁ ଆମେଇଂକେ ସାପା ନିମାଣ୍ତା ବାବ୍‌ରେ ଆଃବୁଜେ ବିଃମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_35","071_4_35","MRK","4","35","35","ଆତେନ୍‌‌ ସ୍ମି ଲମ୍‍ଡିଗ୍‍ ବେଲା ଜିସୁ ମେଁନେ ସିସ୍‌ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଏଲାପା କେଣ୍ଡିଆ ଇନୁମେତା ନେୱେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK4_36","071_4_36","MRK","4","36","36","ତେସା ମେଇଙ୍ଗ୍‌ ସାପା ରେମୁଆଁକେ ଆତ୍ ଅରିଆ ଆନ୍ତାର୍‌ବିକେ । ଆଣ୍ତିନେ ତରା ଅରିଆ ଜିସୁ ସିସେନୁଗ୍ କଲେଃଗେ । ସିସ୍‌ଇଂ ଡିଗ୍ ୱେଚେ ଆତ୍ ଅରିଆ କଆର୍‌କେ । ଆତ୍ଅରିଆ ବିନ୍‌ ତରା ଡିଗ୍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_37","071_4_37","MRK","4","37","37","ଇଡ଼ିଙ୍ଗ୍ କେଣ୍ତିଆ ଅରିଆ ମୁଇଙ୍ଗ୍‌ ମ୍ନାଃନେ ୱେଡ଼ିଆ ତାର୍‌କେ । ତରା ପାକା ଲଉଡ଼ି ଡା ଡୁଂପାଙ୍ଗ୍‌କେ; ତରାନ୍ନିଆ ଣ୍ଡିଆ ତ୍ନ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_38","071_4_38","MRK","4","38","38","ଜିସୁ ତରା ବିତ୍ରେ ପ୍ଲା ପାକାନେ ମୁଇଙ୍ଗ୍‌ କନେ ନିଗ୍‌ବଡିଙ୍ଗ୍ ଅରିଆ ବାଆଃ ବଚେ ଡୁଲେଗ୍‌ ଲେଃକେ । ମେଁନେ ସିସ୍‌ଇଙ୍ଗ୍‌ ମେଁ ଡାଗ୍ରା ୱେଚେ ଆମେକେ ଆଃତଡ଼୍ୟା ଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଏ ଗୁରୁ, ନେଁ ଲଗ୍‌ଡ୍ୟାଚେ ନେଗୁଏଃଏବେ, ଆନାକେ ମେଃନେ ଚିନ୍ତା ଣ୍ତୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MK4_39","071_4_39","MRK","4","39","39","ଜିସୁ ତଡ଼୍ୟାକେ ମେଁ ୱେଡ଼ିଆକେ ବାଃଟକେ ଆରି ଲଅଡ଼ିକେ ବାସଙ୍ଗ୍‌କେ, “ବୁଂଲାଃଲା ।” ଇଡ଼ିଙ୍ଗ୍ ୱେଡ଼ିଆ ବନ୍ଦ୍ ଡିଙ୍ଗ୍ ୱେଗେ । କେଣ୍ତିଆ ବୁଂ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK4_40","071_4_40","MRK","4","40","40","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍‌ଇଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌କେ “ପେ ସାପାରେ ମେଁନ୍‌ସା ବୁଟମେଗ୍‌ ପେଡିଙ୍ଗ୍‌କେ ? ଏଃଜାକ ମେଃନେ ପେ ସାପାରେନେ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MK4_41","071_4_41","MRK","4","41","41","ମେଇଙ୍ଗ୍‌ ମାତର୍‌‌ ଜବର୍‌ ବୁଟ ୱେଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ନିଜେ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଆର୍‌କେ “ଏନ୍ ଡିରକମ୍‌ନେ ରେମୁଆଁ ? ଦେକ୍‌ରକମ୍ କି ୱେଡ଼ିଆ ଆରି ଲଉଡ଼ି ଡିଗ୍ ଆମେକେ ମାନେଃ ଡିଂଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_1","071_5_1","MRK","5","1","1","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଗାଲିଲୀ କେଣ୍ତିଆନେ ଇନୁମେତା ଗରାଶୀୟ‍ଇଂନେ ଇନିଅରିଆ ୱେଚା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_2","071_5_2","MRK","5","2","2","ଜିସୁ ତରାବାନ୍ ଜାର୍‌କ୍ନେ ଦାପ୍‌ରେ ମୁଇଙ୍ଗ୍‌ ରେମୁଆଁ ରାଃଚ୍ୟା ବାନ୍ ତାର୍‌ଚେ ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ । ମେଁନେ ଗାଗ୍‌ଡ଼େ ଗଲିଆ ବାସା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_3","071_5_3","MRK","5","3","3","ଆତେନ୍‌ ରେମୁଆଁ ରାଃଚ୍ୟା ଅରିଆ ଲେଃମ୍ୟାକେ ଆମେକେ ଜାଣ୍ଡେ ଡିଗ୍ ଗାଗ୍ ଆୟା ଆର୍‌କେ । ଦେକ୍‌ରକମ୍‌କି ସିକ୍ଲି ଏତେ ଡିଗ୍ ଆମେକେ ଗାଗ୍ ଆୟା ଆର୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK5_4","071_5_4","MRK","5","4","4","ଡାଗ୍‌ଲା ଆମେକେ ଜାବର୍‌ ତର୍ ନ୍ତିକାଡ଼ୁ ଆରି ସିକ୍ଲି ଏତେ ଗାଗ୍ ବିଃବମ୍ୟାକେ, ମାତର୍‌ ମେଁ ନ୍ତିକାଡ଼ୁ ଟେକ୍‌ଚାର୍ ଜଗ୍‌ତ୍ଲାଗ୍ ମ୍ୟାକେ ଆରି ସିକ୍ଲିକେ ଟିକ୍‌ଚିଚେ ଜଗ୍‌ତ୍ଲାଗ୍‌ଡିଂଗେ । ଜାଣ୍ଡେ ଡିଗ୍‌ ଆମେକେ ଗାଗ୍‍ଚେ ବ ଆୟାଆର୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK5_5","071_5_5","MRK","5","5","5","ମେଁ ସ୍ମି ମିଡିଗ୍‌ କାଲାଆଃ ରାଃଚ୍ୟା ଆରି କଣ୍ତା ଅରିଆ ଲେଃଚେ ସାର ସାଗା ମ୍ୟାକେ ଆରି ନିଜେ ମେଁ ବ୍ରି ଏତେ ଟୁଚାର୍‌ଚେ ଆଃଚିନା ଆଃବାନା ଡିଙ୍ଗ୍‌ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_6","071_5_6","MRK","5","6","6","ରେମୁଆଁ ମୁଇଙ୍ଗ୍‌ ଜିସୁକେ ସ୍ଲବାନ୍‌ କେଚେ ମେଁ ଡାଗ୍ରା ୱିର୍‌ ଡୁଂପାଙ୍ଗ୍‌ଚେ ମେଁନେ ସେନୁଗ୍ ଲଃୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_7","071_5_7","MRK","5","7","7","ଆରି କିରଚେ ବାସଙ୍ଗ୍‌କେ, ଏ ସାପାବାନ୍ ମ୍ନା ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଜିସୁ ! ନା ଏତେ ନେଙ୍ଗ୍‌ନେ ମେଃ କାମ୍ ଲେଃକେ ? ଆନାକେ ଇସ୍‌ପର୍‌ନେ ମ୍ନିରେ ମୁଣ୍ଡିଆ ବଗ୍‌ଣ୍ଡିଂକେ ଆନେଙ୍ଗ୍ ଡଣ୍ତ୍‌ ଆବିଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_8","071_5_8","MRK","5","8","8","ଡାଗ୍‌ଲା ଜିସୁ ଆମେକେ ବାଲିର୍‌ ନ୍‌ସା ୱେଡିଙ୍ଗ୍‍ଗେ “ଏ ବୁତ୍‌ ଆତ୍ମା; ଆକେନ୍ ରେମୁଆଁବାନ୍‌ ତାର୍‌ୱେଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_9","071_5_9","MRK","5","9","9","ଜିସୁ ଆମେକେ ସାଲିଆକୁକେ, “ନାଁ ମ୍ନି ମେଃନେ ?” ଆତେନ୍‌ ରେମୁଆଁ ବାଲିର୍‌କେ, “ନେଙ୍ଗ୍‌ନେ ମ୍ନି ‘ବାହିନୀ’, ଡାଗ୍ଲା ନେ ଜାବର୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_10","071_5_10","MRK","5","10","10","ଆତେନ୍‌ ଗଲିଆଇଂ କାକୁର୍‌ତି ଡିଂଚେ ବିକ୍‌ ସାଲିଆକେ ଜେ ମେଁ ଗଲିଆଇଂକେ ଆତେନ୍‌ ଏରିଆବାନ୍ ପାଦା ବେଆବିଗେ ନାମଃ । ");
INSERT INTO gaq_vpl VALUES ("MK5_11","071_5_11","MRK","5","11","11","ଆତେନ୍‌‌ କଣ୍ଡା ଆଡ଼ାପାକା ଆତେନ୍‌ ବେଲା ଗୁବୁଗ୍ଇଂ ଗୁଲେ ମାନ୍ଦା ଚୁଚଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ ଡିଂଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_12","071_5_12","MRK","5","12","12","ବୁତ୍‌ଇଂ ଜିସୁକେ କୁସାମୁତି ଡିଂଚେ ବାଲିର୍‌ଆର୍‌କେ, “ଆନେକେ ଗୁବୁଗ୍ଇଂ ଡାଗ୍ରା ବେବିଃ ତେଲା ନେଁ ମେଁଇଂନେ ଗାଗ୍‌ଡ଼େ ବିତ୍ରେ ଗାନେୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_13","071_5_13","MRK","5","13","13","ଜିସୁ ଆମେଇଂକେ ଦେକ୍‌ରକମ୍‌ ଡିଙ୍ଗ୍‌ନେସା ଆଦେସ୍‌ ବିକେ । ଇଡ଼ିଙ୍ଗ୍ ବୁତ୍‌ଇଂ ଆତେନ୍‌‌ ରେମୁଆଁ ଗାଗ୍‌ଡ଼େବାନ୍ ତାର୍‌ଚେ ଗୁବୁଗ୍ଇଂ ଗାଗ୍‌ଡ଼େ ଗାୱେଆର୍‌ଗେ, ଆତେନ୍‌‌ ଗୁବୁଗ୍ ମାନ୍ଦାଇଙ୍ଗ୍‌ ଗୁଲେ ମ୍ବାର୍‌ ଅଜାର୍ ଲେଃଆର୍‌ଗେ । ଆତେନ୍‌‌ ସାପାଜାକ ଗୁବୁଗ୍ କଣ୍ଡା ଆଃଡ଼ାବାନ୍ ଦାପ୍ରେ ୱିର୍‌ ଡୁଂପାଙ୍ଗ୍‌ଚେ କେଣ୍ତିଆ ବିତ୍ରେ ଲଗ୍‌ଡ୍ୟା ଗୁଏଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_14","071_5_14","MRK","5","14","14","ଗୁବୁଗ୍ ମାନ୍ଦାକେ ତୁର୍‌ତ୍ୟାରେ ୱିର୍ ଡୁଂୱେଚେ ଇନି‍ଇଂକେ ଆକେନ୍ ସାପା ଗଟ୍‌ନା ଆମ୍ୟା ବିଃଆର୍‌କେ । ରେମୁଆଁ ମେଁନେ ଗଟେଲେଃକେ ଡାଗ୍‌ଚେ କିକେନ୍‌ସା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_15","071_5_15","MRK","5","15","15","ମେଇଙ୍ଗ୍‌ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ କେଆର୍‌କେ ଜାଣ୍ତେନେ ଗାଗ୍‌ଡ଼େ ଅଲେଙ୍ଗ୍‌ନେ ଗଲିଆ ଗାଲେଃକେ ଆତେନ୍‌‌ ରେମୁଆଁ ପାଟାଇପୁଟାଇ ସଚେଃ ନିମାଣ୍ତା ଡିଂଚେ କଲେଃଗେ । ମେଁନେ ମନ୍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ୱେଲେଃଗେ । ଆକେନ୍ କେଚେ ମେଇଙ୍ଗ୍ ବୁଟ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_16","071_5_16","MRK","5","16","16","ଆତ୍ଅରିଆ ଉଡ଼ି ରେମୁଆଁ ଲେଃଆର୍‌ଗେ ଜାଣ୍ଡେଇଂ ଜିସୁ କାମ୍‌ ଡିଂବକ୍ନେ କେଲେଃଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ବିନ୍ ରେମଆଁଇଂନେ ସେନୁଗ୍ ଗଲିଆ ସାକ୍ନେ ରେମୁଆଁନେ ଆରି ଗୁବୁଗ୍‌ଇଂନେ ବିତ୍‌ରେ ମେଃ ଡିଙ୍ଗ୍‌ଲେଃଗେ, ଆତେନ୍‌‌ ସାପା ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_17","071_5_17","MRK","5","17","17","ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌‌ ରେମୁଆଁଇଙ୍ଗ୍‌ ଜିସୁକେ ଆତେନ୍‌‌ ଇନି ଆନ୍ତାର୍‌ଚେ ୱିଗ୍‌ନେସା ଗୁଆରେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_18","071_5_18","MRK","5","18","18","ଜିସୁ ତରା ଡାଗ୍ରା କଚେ ୱିଗ୍‌ନେସା ତିଆର୍ ଡିଂକେ । ଜାଣ୍ଡେ ସେନୁଗ୍‌ ଗଲିଆ ଆସାଃଚେ ବାୟା ଡିଙ୍ଗ୍‌ଲେଃଗେ, ମେଁ ଜିସୁଏତେ ୱିଗ୍‌ନ୍‌ସା ଆମେକେ ଗୁଆରେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_19","071_5_19","MRK","5","19","19","ମାତର୍‌‌ ଜିସୁ ଆମେକେ ୱିଗ୍‌ନ୍‌ସା ଆଦେସ୍‌ ଆବିଃକେ ଣ୍ତୁ । ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ନାଁ ନାଁନେ ନିଜର୍ ଡୁଆ ରେମୁଆଁଇଂ ଡାଗ୍ରା ୱିଗ୍‌ଲା । ମାପ୍ରୁ ନାଁନ୍‌ସା ମେଃ ଡିଙ୍ଗ୍‌ବ‍କେ, ଆତେନ୍‌‌ ସାପା ସାମୁଆଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌ ଜେ ମାପ୍ରୁ ଆନାକେ ଦୟା ଡିଙ୍ଗ୍‌ବ‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_20","071_5_20","MRK","5","20","20","ତେସା ମେଁ ୱିଗ୍‌କେ ଆରି ଦେକାପଲୀ ଡାଗ୍ଲା ଗୁଆକ୍ଲିଗ୍‍ ଇନିନେ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌ନେ ଲାଗେକେ ଜେ ଜିସୁ ଡିରକମ୍ ମେଁ ନ୍‌ସା ଉଡ଼ି ମ୍ନାନେ କାମ୍‌ ଡିଙ୍ଗ୍‌ବ‍କେ । ସାପା ରେମୁଆଁ ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ କାବା ଡିଙ୍ଗ୍ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_21","071_5_21","MRK","5","21","21","ଜିସୁ ତରାଅରିଆ କଚେ କେଣ୍ତିଆ ଇନୁମେତା ୱେକେ । ଆରି କେଣ୍ତିଆ ଆଡ଼ା ମେଁନେ ପିତୁର୍‌ପାକା ଗୁଲେ ରେମୁଆଁ ରିସିଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_22","071_5_22","MRK","5","22","22","ଜିଉଦି ପାର୍‌ତନା ଡୁଆନେ ମୁଇଙ୍ଗ୍‌ ନେତା ଆତ୍ଅରିଆ ପାଙ୍ଗ୍‌କେ । ମେଁନେ ମ୍ନି ଜାଇରସ୍ ଲେଃଗେ । ଜାଇରସ୍ ଜିସୁକେ କେକ୍ନେ ଦାପ୍ରେ ମେଁ ଞ୍ଚ ବୁନ୍ଦେ ଲଃୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_23","071_5_23","MRK","5","23","23","ମେଁ କାକୁର୍‌ତି ଡିଂଚେ ଜିସୁକେ ବିକ୍‌ ସାଲ୍ୟାକେ, “ନେଙ୍ଗ୍‌ନେ ଡାଆଁ ଗଡ଼େଅ ଗୁଏନେ ଆଡ଼ାତ୍ରା । ଲିବିସଃ ଡିଙ୍ଗ୍‌ଚେ ନାଁ ପାଙ୍ଗ୍‌ଲା ମେଁନେ ଆଡ଼ାତ୍ରା ନ୍ତି ବ ତେଲା ମେଁ ନିମାଣ୍ତା ଡିଙ୍ଗ୍ ୱେଏ ଆରି ଜିବନ୍‌ ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_24","071_5_24","MRK","5","24","24","ଜିସୁ ଜାଇରସ୍ ଏତେ ତାର୍‌କେ । ଜବର୍ ରେମୁଆଁ ଜିସୁନେ ପ୍ଲା ୱେ ଆର୍‌କେ । ଗଉଲି ଡିଙ୍ଗ୍‌ଲା ରେମୁଆଁଇଙ୍ଗ୍‌ ଜିସୁନେ ପାକା ଟେଚା ଡୁଂପାଙ୍ଗ୍‌ ଡିଂଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_25","071_5_25","MRK","5","25","25","ଆତ୍ ଅରିଆ ରେମୁଆଁଇଙ୍ଗ୍‌ ବିତ୍ରେ ମୁଇଙ୍ଗ୍‌ ସେଲାମ୍ବୁଏ ଲେଃଗେ । ୱେକ୍ନେ ଗମ୍ବାର୍‌ ମୁଆଁ ସାଚେ ମେଁନେ ଆବୁଲେଃ ଡିଙ୍ଗ୍‌ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_26","071_5_26","MRK","5","26","26","ଗୁଲୁଏ ଗଦାର୍ କାନାଇଙ୍ଗ୍ ଅଲେଙ୍ଗ୍ ଆଃଡାଚେ ମେଁ ଲାକାଃ ୱେଲେଗେ । ମେଁ ଜବର୍ ଦୁକ୍ ବାଡିଂଗେ, ମେଁନେ ସାପା ଡାବୁ କର୍ଚ ଡିଙ୍ଗ୍ ୱେଲେଃଗେ । ଏଲେଡିଗ୍ ମେଁନେ ଗାଗ୍‌ଡ଼େ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ତେଲା ମେଁନେ ଗାଗ୍‌ଡ଼େ ଜବର୍ ଜବର୍ ଆଃ ଦଦିଆ ଡିଙ୍ଗ୍ ୱେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_27","071_5_27","MRK","5","27","27","ଆତେନ୍‌‌ ସେଲାମ୍ବୁଏ ଜିସୁନେ ସାମୁଆଁ ଅଁଚେ ଇଡ଼ିଙ୍ଗ୍ ରେମୁଆଁଇଙ୍ଗ୍‌ ଏତେ ମେଇଙ୍ଗ୍‌ନେ ପ୍ଲା ୱେକେ । ମେଁ ପ୍ଲା ପାକାବାନ୍ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ପାଟାଇ ଜାଲିପୁଆଃକେ ଲିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_28","071_5_28","MRK","5","28","28","ମେଁ ମନେ ମନେ ବାସଙ୍ଗ୍‌ଡିଂଗେ, ନିଂ ମେଁନେ ପାଟାଇ ନ୍‌ଲିଗ୍‌ଲା ନେଙ୍ଗ୍ ନିମାଣ୍ତା ଣ୍ତିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK5_29","071_5_29","MRK","5","29","29","ମେଁ ଜିସୁନେ ପାଟାଇ ଲିଗ୍‌କ୍ନେ ଦାପ୍ରେ ମେଁନେ ଆବୁଲେଃ ଡିଙ୍ଗ୍‌କ୍ନେ ମ୍ୟା ବନ୍ଦ୍‌ ଡିଙ୍ଗ୍‌ୱେଗେ ଆରି ମେଁନେ ଗାଗ୍‌ଡ଼େନେ ରଗ୍‌ବିଆଦି ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ ୱେଗେ ଡାଗ୍‌ଚେ ମେଁ ବାବେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_30","071_5_30","MRK","5","30","30","ଆତେନ୍‌‌ ବେଲା ଜିସୁ ମନେ ବାବେକେ ଜେ ମେଁନେ ବାନ୍ ବପୁ ତାର୍ ୱେଲେଃକେ । ମେଁ ତୁଆଁ ବିଃକେ ଆରି ପ୍ଲା ପାକା ପୁଏଚେ ସାଲିଆକୁକେ, “ନେଙ୍ଗ୍‌ନେ ପାଟାଇ ଜାଣ୍ତେ ଲିଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK5_31","071_5_31","MRK","5","31","31","ସିସ୍ଇଂ ଜିସୁକେ ବାଲିର୍‌ ଆର୍‌କେ, “ଆକ୍‌ଅରିଆ ତ ଗୁଲୁଏ ରେମୁଆଁ ନାଁନେ ପାକା ଟମେଗ୍‌ଚେ ୱେଡିଂଆର୍‌କେ । ଆରି ନାଁ ସାଲ୍ୟାକୁ ନାଡିଙ୍ଗ୍‌କେ, ଆନେଙ୍ଗ୍ ଜାଣ୍ତେ ଲିଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK5_32","071_5_32","MRK","5","32","32","ଡାଗ୍ଲା ଜିସୁ ଆନିଂକେ ଜାଣ୍ଡେ ଲିଗ୍‌କେ ଡାଗ୍‌ଚେ ପିତୁର୍‍ପାକା ମୁଆଃ କିକେନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_33","071_5_33","MRK","5","33","33","ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃ ମ୍ୟାଲେଃକେ ଜେ ମେଁ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ ୱେଲେଗେ । ତେସା ମେଁ ଜୁର୍‌ ଜୁର୍‌ଚେ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ଞ୍ଚ ବୁନ୍ଦେ ଲଃୱେଗେ । ମେଁ ବୁଟଚେ ଜୁର୍ ଡିଙ୍ଗ୍‌କେ । ମେଁ ଜିସୁକେ ସାପା ସତ୍‌ ସାମୁଆଁ ଆଃମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_34","071_5_34","MRK","5","34","34","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଏ ଗଡ଼େଅ; ନାନେ ବିସ୍‌ବାସ୍ ଆନାକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍ ବକେ । ସାନ୍ତିରେ ୱିଗ୍‌ଲା ଆରି ନାଁନେ ରଗ୍‌ବାନ୍‌ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_35","071_5_35","MRK","5","35","35","ଜିସୁ ଆତ୍‌ଅରିଆ ଆକେନ୍ ସାପା ସାମୁଆଁ ବାଲିର୍‌କ୍ନେ ବେଲା ଜିଉଦିଇଂନେ ପାର୍‌ତନା ଡୁଆନେ ନେତା ଜାଇରସ୍ ଡୁଆବାନ୍‌ ଉଡ଼ିରୁଆ ପାଙ୍ଗ୍‌ଚେ ଆମେକେ ବାଲିର୍‌କେ, “ନାନେ ସେଲାମ୍ବୁଏଅ ଗୁଏଗେ । ପ୍ରେକ୍‍ ନ୍‌ସା ନାଁ ଗୁରୁ, ଜିସୁକେ ସରାଃ ମେଃନ୍‌ସା ତେରେପେତେ ନାରାଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK5_36","071_5_36","MRK","5","36","36","ମାତର୍‌‌ ଜିସୁ ମେଁଇଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁ ଆଃଡାଚେ ଜିଉଦି ପାର୍‌ତନା ଡୁଆନେ ନେତାକେ ବାସଙ୍ଗ୍‌କେ, “ଆବ୍‌ଟଗେପା ନାମଃ; ମାତର୍‌ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_37","071_5_37","MRK","5","37","37","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ସାପା ରେମୁଆଁକେ ଆନ୍ତାର୍‌ଚେ ପିତର ଜାକୁବ ଆରି ମେଁନେ ବୟାଁଣ୍ତେ ଜହନ ଏତେ ୱା ଡୁଙ୍ଗ୍‌ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_38","071_5_38","MRK","5","38","38","ମେଁଇଙ୍ଗ୍‌ ଜିଉଦି ପାର୍‌ତନା ଡୁଆନେ ନେତାନେ ଡୁଆନ୍ନିଆ ୱେଆର୍‌କେ । ମେଁ ଆତ୍ଅରିଆ ରେମୁଆଁଇଂକେ ଜାବର୍ ୱାସାର୍‍ଚେ ହ ଡିଙ୍ଗ୍‌ଆର୍‌କ୍ନେ ଆରି ଆତ୍ ଅରିଆ ଜବର୍‌ ସାର ସାଗା ଡିଙ୍ଗ୍ଆର୍‌କ୍ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_39","071_5_39","MRK","5","39","39","ଜିସୁ ଡୁଆ ବିତ୍ରେ ଗାଚେ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେ ମେଁନ୍‌ସା ଅଃକେନ୍ ସାରସାଗାଃଚେ ହ ପେଡିଙ୍ଗ୍ ? ଆକେନ୍ ଗଡ଼େଅ ଆଗୁଏକେ ଣ୍ତୁ ମେଁ ମାତର୍‌‌ ଡୁଲେଃଗ୍ ଲେଃକେ ।” ଆକେନ୍ ଅଁଚେ ସାପା ରେମୁଆଁ ଜିସୁକେ ଏଃଲ୍ୟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_40","071_5_40","MRK","5","40","40","ମାତର୍‌‌ ମେଁ ସାପା ରେମୁଆଁକେ ଡୁଆବାନ୍‌ ବାଜାର୍‌ ବେ ବିକେ । ମାତର୍‌‌ ଗଡ଼େଅନେ ଇୟାଙ୍ଗ୍ ଆବା ଆରି ମେଁ ଏତେ ପାଙ୍ଗ୍‌ଲେଃକ୍ନେ ସିସ୍‌‌ଇଙ୍ଗ୍‌କେ ସଙ୍ଗେ ଡୁଙ୍ଗ୍‌ୱେଚେ ଗଡ଼େଅ ଆଣ୍ତିନେ ବାକ୍ରା ଡୁଲେଗ୍‌ ଲେଃକେ ଆତେନ୍‌‌ ବାକ୍ରା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_41","071_5_41","MRK","5","41","41","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଗଡ଼େଅନେ ନ୍ତି ସାଚେ ଆମେକେ ବାଲିର୍‌କେ, “ଟାଲିଥା କୁମ୍‍” ଡାଗ୍‌ଲା “ଏ ଗଡ଼େଅ, ନେଙ୍ଗ୍ ଆନାକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ ତଃଡ଼ିଆ ।” ");
INSERT INTO gaq_vpl VALUES ("MK5_42","071_5_42","MRK","5","42","42","ଗଡ଼େଅ ଜିଆ ଜିଆ ତଡ଼ିଆଚେ ତୁଆଁକେ ଆରି ଅଲେଙ୍ଗ୍‌ନେ ମୁଲେକେ । ଗଡ଼େଅନେ ବଏସ୍‌ ଗମ୍ୱାର୍‌ ମୁହା ଡିଙ୍ଗ୍‌ଲେକେ । ସାପାରେ କେଚେ ଜବର୍ ଇରିଆତୁଗ୍ ଡିଙ୍ଗ୍‌ୱେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK5_43","071_5_43","MRK","5","43","43","ଜିସୁ ଆକେନ୍ ସାପା ସାମୁଆଁ ରେମୁଆଁଇଂକେ ଆରାଃମ୍ୟାଃଗ୍‌ପା ଡାଗ୍‌ଚେ ଗଡ଼େଅନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆବାଡ଼େକେ ଡାଟାମ୍ ବାବ୍‌ରେ ବୁଦି ବିକେ । ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଗଡ଼େଅନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆବାଡ଼େକେ ବାଲିର୍‍କେ, ଗଡ଼େଅକେ ମେଃଡିଗ୍ ଚୁଚଙ୍ଗ୍‌ ନ୍‌ସା ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("MK6_1","071_6_1","MRK","6","1","1","ଜିସୁ ଆତେନ୍‌ ଜାଗା ଆନ୍ତାର୍‌ଚେ ସିସ୍‌ଇଂ ଏତେ ନିଜର୍‌ ଇନି ନାଜରିତନ୍ନିଆ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_2","071_6_2","MRK","6","2","2","ଆତ୍‌ଅରିଆ ପୁଣ୍ଡେନେ ଦିନା ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ମେଁ ବାସଙ୍ଗ୍‌ନେ ବେଲା ଗୁଲୁଏ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଲେ ଆର୍‌କେ । ଜିସୁନେ ସାମୁଆଁ ଅଁଚେ ମେଇଂ ଇରିଆତୁଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ଅଃକେନ୍ ସାମୁଆଁ ମେଁ ଆଣ୍ଡବା ମ୍ୟାଃକେ ? ଅଃକେନ୍ ଗିଆନ୍ ମେଁ ଆଣ୍ଡିବା ମ୍ୟାଃକେ ? ଏନ୍ ସାପା ଇରିୟାତୁଗ୍‌ନେ କାମ୍ ମେଁ ଡିରକମ୍ ଡିଂକେ ? ");
INSERT INTO gaq_vpl VALUES ("MK6_3","071_6_3","MRK","6","3","3","ଆକେନ୍ ମେଁନେ ଆତେନ୍‌ ବାଡ଼ୟ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଣ୍ଡୁ ? ଆକେନ୍ ମେଁନେ ମରିୟମ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ଣ୍ଡୁ ଆରି ଜାକୁବ୍‌ ଯୋସି ଜିଉଦା ଆରି ଶିମୋନ୍‌ନେ ବୟାଁଣ୍ତେ ଣ୍ଡୁ ତ ? ମେଁନେ ତନାଣ୍ଡେଇଂ ମେଃନେ ନେଁ ଏତେ ଣ୍ଡୁ କି ?” ଆକେନ୍‌ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁକେ ଏଃଲ୍ୟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_4","071_6_4","MRK","6","4","4","ମାତର୍‌ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ବିନ୍ ରେମୁଆଁଇଙ୍ଗ୍‌ ମୁଇଙ୍ଗ୍‌ ବାବବାଦିକେ ସନ୍‍ମାନ୍‍ ବିଃ ମ୍ୟା ଆର୍‌କେ । ମାତର୍‌ ମେଁଇଙ୍ଗ୍‌ ନିଜର୍ ନିଜର୍ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ଆରି ମେଁଇଙ୍ଗ୍‌ନେ ଡୁଆନେ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ସନ୍‍ମାନ୍‍ ଆବିଆର୍ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_5","071_6_5","MRK","6","5","5","ଆତେନ୍‌‌ ଜାଗାଅରିଆ ଉଡ଼ିକ୍ଲିଗ୍ ରଗିଇଂନେ ଆଡ଼ାତ୍ରା ନ୍ତି ବଚେ ମେଁ ଆମେଇଂକେ ନିମାଣ୍ଡା ଆଃଡିଙ୍ଗ୍‌କ୍ନେ ବାନ୍ । ଆତ୍‌ଅରିଆ ଜିସୁ ମେଃଡିଗ୍ କାବା ଡିଙ୍ଗ୍‌ନେ କାମ୍ ଆରାଃସୁଏକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK6_6","071_6_6","MRK","6","6","6","ମେଇଂନେ ଅବିସ୍‌ବାସ୍‌ କେଚେ ଜିସୁ କାବା ଡିଙ୍ଗ୍‌ୱେଗେ । ଏନ୍ ଇଡ଼ିଙ୍ଗ୍‌ ଜିସୁ ଡାଗ୍ରା ଲେଃକ୍ନେ ଇନିଇଂ ୱେଚେ ରେମୁଆଁଇଂକେ ଗିଆନ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_7","071_6_7","MRK","6","7","7","ମେଁ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସିସ୍‌ଇଂକେ ୱାଚେ ମ୍ୱାୟା ମ୍ୱାୟା ଆଡିଙ୍ଗ୍‌ଚେ ବେକେ । ଦୁସ୍ଟ ଆତ୍ମାଇଂକେ ସାମ୍‌ନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆମେଇଂକେ ଅଦିକାର୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_8","071_6_8","MRK","6","8","8","“ପେ ୱେନେସା ମୁଇଂ ଡୁଡୁକେ ଆନ୍ତାର୍‌ଚେ ରୁଟି କି ମୁନା କି ତୁଆଲ୍‌ନ୍ତୁଗ୍‌ ଡାବୁ ଡୁଙ୍ଗ୍‌ମାୱେନ୍‌ସା ଆମେଇଂକେ ଆଦେସ୍‌ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_9","071_6_9","MRK","6","9","9","ଜୁତାକେ ଆନ୍ତାର୍‌ଚେ ବାରି ମେଃଡିଗ୍‌ ଡୁଂଆୱେଗ୍‌ପା । ରୁଟି ଲେଃ ଡାବୁ ଲେଃ ଆୱେଜଙ୍ଗ୍‌ନେ ମୁନା ଲେଃ ଇତୁଡ଼ା ଡିଗ୍‌ ଜବର୍‌ ସକା ଡୁଙ୍ଗ୍‍ଆୱେଗେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_10","071_6_10","MRK","6","10","10","ବାରି ମେଁ ବାସଙ୍ଗ୍‌କେ, “ପେ ମୁଃଡ଼ିନେ ଡୁଆନ୍ନିଆ ପେଗାଏ, ଆତେନ୍‌ ଜାଗାବାନ୍ ମାତାର୍ ଜାକ ଆତେନ୍‌ ଡୁଆ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MK6_11","071_6_11","MRK","6","11","11","ଜଦି ଆଡିନେ ଜାଗାନ୍ନିଆ ରେମୁଆଁ ଆପେକେ ଜାଗା ଆବଆର୍‌ ଣ୍ତୁ ବାରି ପେନେ ସାମୁଆଁ ଆଅଁ ଆର୍‌ ଣ୍ତୁ ପେନେ ଞ୍ଚନେ ଦୁଲି ତାଣ୍ତି ବିଚେ ଆତେନ୍‌‌ ଜାଗା ଆନ୍ତାର୍‌ ବିଃପା । ଏନ୍‌ ମେଇଂନେ ବିରଦ୍‌ରେ ସାକି ରକମ୍‌ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_12","071_6_12","MRK","6","12","12","ସିସ୍‌ଇଙ୍ଗ୍‌ ଆତ୍‌ବାନ୍ ବିନ୍ ଜାଗାନ୍ନିଆ ୱେଗେ ମେଇଙ୍ଗ୍ ଆତ୍‍ ଅରିଆ ୱାସାର୍‍ନେ ଲାଗେକେ ଜେ ମନ୍ ଆଃବଦ୍ଲେନେ ମେଁନେ ଅଦିକାର୍ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_13","071_6_13","MRK","6","13","13","ମେଇଙ୍ଗ୍‌ ଗୁଲୁଏ ବୁତ୍‌ଇଂକେ ନୁଆଁ ଆର୍‌କେ ବାରି ଆଃସି ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଞ୍ଚୁ ଲିଗ୍‌ଚେ ନିମାଣ୍ତା ଆଃଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_14","071_6_14","MRK","6","14","14","ଇଃସାଙ୍ଗ୍‌ ହେରୋଦ ଜିସୁନେ ସାମୁଆଁ ଅଁକେ । ଡାଗ୍ଲା ଜିସୁନେ ମ୍ନି ପିତୁର୍‍ପାକା ବେପ୍ରେ ୱେଗେ । ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଜିସୁ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଡୁବନ୍ ବିଣ୍ଡ୍ରେ ଜହନ୍ । ମେଁ ଗୁଏଃଚେ ଆରି ମୁଇଂତର୍ ଜିବନ୍ ଡିଙ୍ଗ୍‌ଲେଃକେ । ଆତେନ୍‌‍ସା ମେଁ କାବାକାମ୍ ଡିଙ୍ଗ୍‌ୟାଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_15","071_6_15","MRK","6","15","15","ବିନ୍‍ଣ୍ଡ୍ରେ ବାସଙ୍ଗ୍ ଡିଂଆର୍‌କେ, “ମେଁ ଡିଙ୍ଗ୍‌ଡିଂକେ ଏଲୀୟ ।” ଆରି ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‍ଡିଂଆର୍‌କେ, “ଜିସୁ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ବାବବାଦି ଅଃସେ କାଲ୍‍ନେ ବାବବାଦି ବକ୍ତାଇଂ ସୁଗୁଆ ମେଁ ମୁଇଙ୍ଗ୍‌ ବାବବାଦି ବକ୍ତା ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_16","071_6_16","MRK","6","16","16","ହେରୋଦ ଜିସୁନେ ବିସୟ୍‌ରେ ଆକେନ୍ ସାପା ଅଁଚେ ବାସଙ୍ଗ୍‌କେ, “ନିଂ ଜହନ୍‌ନେ ବାଆଃ ସିତଗ୍ ବିମ୍ବକେ । ଆରି ଜହନ୍‌ ଗୁଏକ୍ନେ ବାନ୍ ତଡ଼ିଆ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_17","071_6_17","MRK","6","17","17","ନିଜେ ହେରୋଦ ଜହନ୍‌କେ କ‍ଏଦ୍ ଆଡିଙ୍ଗ୍‍ନେସା ମେଁଇଙ୍ଗ୍‌ନେ ସନ୍ୟଇଂକେ ଆଦେସ୍ ବିକେ । ଜହନ୍‌କେ କ‍ଏଦ୍‌ ଡୁଆନିଆ ଆଃଗାବଗେ । ହେରୋଦ ନିଜର୍‌ ବୟାଁ କୁନେଣ୍ତେକେ ହେରୋଦିଆ ଏତେ ସାର୍ଦା ଆଡିଙ୍ଗ୍‌ନେ ନ୍‌ସା ଆକେନ୍ ଡିଙ୍ଗ୍‌ବକେ । ସିସେ ହେରୋଦିଆ ହେରୋଦ ବୟାଁଣ୍ତେ ଫିଲିପୀନେ କୁନେଣ୍ଡେ ଲେଃଗେ । ଇଡ଼ିଙ୍ଗ୍ ହେରୋଦ ଆମେକେ ବିହେ ଡିଙ୍ଗ୍‌ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_18","071_6_18","MRK","6","18","18","ଜହନ୍‌ ହେରୋଦକେ ବାସଙ୍ଗ୍‌କେ, “ନାବୟାଁନେ ସେଲାମ୍ବୁଏଃକେ ଡୁଂୱିଗ୍‌ନେ ନିୟମ୍‌ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_19","071_6_19","MRK","6","19","19","ଆତେନ୍‌‌ସା ହେରୋଦିଆ ଜହନ୍‌କେ ଇର୍ସାରେ କିକେ ଡିଂଗେ । ମେଁ ଜହନ୍‌କେ ବାଗୁଏଃ ନ୍‌ସା ଇକ୍‌ଚା ଡିଂକେ । ମାତର୍‌ ମେଁ ଜହନ୍‌କେ ବାଗୁଏଃ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK6_20","071_6_20","MRK","6","20","20","ଡାଗ୍ଲା ଜହନ୍‌ ମୁଇଂ ସାଦୁ ଆରି ଦରମ୍ ରେମୁଆଁ ଡାଗ୍‌ଚେ ମ୍ୟାଚେ ହେରୋଦ ଆମେକେ ବୁଟମେଗ୍ ଡିଂଗେ ବାରି ଆମେକେ ନିମାଣ୍ଡା ବ‍ଗେ । ଜହନ୍‌ନେ ସିକ୍ୟା ଅଁଚେ ପ୍ରେଗ୍‌ପ୍ରେଗ୍ ବୁଟମେଗ୍ ଡିଂଲେଃଲା ଡିଗ୍ ମେଁନେ ସାମୁଆଁ ଅଁନ୍‌ସା ମେଁ ଚାଏଁଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_21","071_6_21","MRK","6","21","21","ଉଡ଼ିସି ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ହେରୋଦନେ ଜନମ୍ ଦିନା ଜହନ୍‌କେ ବାଗୁଏଃନ୍‌ସା ହେରୋଦିକେ ମୁଇଙ୍ଗ୍‌ ସୁବିଦା ମିଲେକେ । ମେଁନେ ମ୍ନା ଅଦିକାର୍ ସେନାପତି‍ଇଂ ଆରି ଗାଲିଲୀନେ ସାପା ମ୍ନାଃ ରେମୁଆଁକେ ହେରୋଦ ମିଡିଗ୍‌ ବେଲା ବଜି ବିଃଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_22","071_6_22","MRK","6","22","22","ହେରୋଦିଆନେ ଗଡ଼େଅ ଏନ୍ ପାଣ୍ଡୁଏଦିନା ୱାଡ଼େଙ୍ଗ୍‍ ୱାଚେ ହେରୋଦ ବାରି କୁଲାରେଇଂକେ ସାର୍ଦା ଆଡିଙ୍ଗ୍‌କେ । ତେସା ଇଃସାଙ୍ଗ୍‌ ଗଡ଼େଅକେ ସାଲିଆକୁକେ, “ନାଁ ମେଃନେ ଚାଏଁନାଡିଂ, ମେଃନେ ନାସାଲ୍ୟାଏ ଆତେନ୍‌ ମ୍ୱିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_23","071_6_23","MRK","6","23","23","ହେରୋଦ ପାର୍‌ମାନ୍ ଡିଂଚେ ବାସଙ୍ଗ୍‌କେ, “ନାଁ ମେଃନେ ନାସାଲ୍ୟାଏ, ନେଙ୍ଗ୍ ଆନାକେ ଆତେନ୍‌ ମ୍ବିଏ । ଦେକ୍‌ରକମ୍ ନେଙ୍ଗ୍ ରାଜିନେ ମେତା ବାଗ୍ ଆନାକେ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_24","071_6_24","MRK","6","24","24","ଆତେନ୍‌ ସେଲାମ୍ୱଅ ମେଁ ଇୟାଙ୍ଗ୍‌ଡେନ୍ନିଆ ୱେକେ ଆରି ସାଲିଆକୁକେ, “ଇଃସାଙ୍ଗ୍‌ ହେରୋଦକେ ନେଙ୍ଗ୍ ମେଃନେ ନ୍‌ସାଲ୍ୟାଏ ?” ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ବାସଙ୍ଗ୍‌କେ, “ଡୁବନ୍ ବିଣ୍ଡ୍ରେ ଜହନ୍‍ନେ ବାଆଃ ସାଲିଆ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_25","071_6_25","MRK","6","25","25","ସେଲାମ୍ବଅ ଟାପ୍‌ନା ଇଃସାଙ୍ଗ୍‌ନ୍ନିଆ ୱେଗେ । ମେଁ ଇଃସାଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ଆନେଙ୍ଗ୍‌କେ ଦିକ୍ୟାବି’ନେ ଜହନ୍‌ନେ ବାଆ ମୁଇଙ୍ଗ୍ ତାଲିନିଆ ଦାପ୍ରେ ଡୁଂପାଙ୍ଗ୍ ବିଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_26","071_6_26","MRK","6","26","26","ଏନ୍‌ ଅଁଚେ ଇଃସାଙ୍ଗ୍‌ ଦୁକ୍ ଡିଙ୍ଗେ । ମାତର୍‌ ମେଁ ସେଲାମ୍ବଅନେ ସାମୁଆ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍ ଆଃଡାବଗେ । ଆତେନ୍‌ ହେରୋଦ ଏତେ ଚଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କୁଲାରେଇଂ ଡିଗ୍‌ ହେରୋଦନେ ପାର୍‌ମାନ୍ ସାପା ଅଁ ଆଃଡା ବଆର୍‌କେ । ଆତେନ୍‌‌ ବିଃନ୍‌ସା ହେରୋଦ ମନା ଡିଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଆଡିଂକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK6_27","071_6_27","MRK","6","27","27","ତେଲା ଇଃସାଙ୍ଗ୍‌ ଜହନ୍‌ନେ ବାଆ ଡୁଂପାଙ୍ଗ୍ ନ୍‌ସା ଆଦେସ୍ ବିକେ ମୁଇଂ ସନ୍ୟକେ ବେକେ ମେଁ ୱେଚେ କ‍ଏଦ୍ ଡୁଆବାନ୍ ଜହନ୍‌ନେ ବାଆଃ ସିତଗ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_28","071_6_28","MRK","6","28","28","ଜହନ୍‌ନେ ଆତେନ୍‌ ବାଆଃ ମେଁ ମୁଇଂ ତାଲିନ୍ନିଆ ଡୁଂପାଙ୍ଗ୍‌ଚେ ସେଲାମ୍ବଅକେ ବିଃକେ । ଆତେନ୍‌ ସେଲାମ୍ବଅ ଆତେନ୍‌ ବାଆଃକେ ଡୁଂୱେଚେ ମେଁ ଇୟାଙ୍ଗ୍‌ଡେକେ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_29","071_6_29","MRK","6","29","29","ଆକେନ୍ ସାପା ଗଟ୍‌ନା ଜହନ୍‍ନେ ସିସ୍‍ଇଂ ଅଁ ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଚେ ଜହନ୍‌ ଗୁଏଃକ୍ନେ ମଡ଼ାକେ ଡୁଙ୍ଗ୍‌ୱେଚେ ଆତି ବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_30","071_6_30","MRK","6","30","30","ଆଣ୍ଡିନେ ପ୍ରେରିତ୍‌ଇଂକେ ଜିସୁ ବେବଗେ, ମେଇଙ୍ଗ୍‌ ଆଣ୍ଡେ ଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ଜିସୁନେ ପିତୁର୍‌ ପାକା ଗେରେ ଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ମେଃନେ ଡିଙ୍ଗ୍‌ବଗେ ଆରି ରେମୁଆଁଇଂକେ ମେଃନେ ସାପା ଗ୍ୟାନ୍ ବିଃବକେ, ଆତେନ୍‌ ସାପା ଆମେକେ ବାସଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_31","071_6_31","MRK","6","31","31","ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌ଇଂ ଜାବର୍‌ ଗଅଲି ଜାଗାନ୍ନିଆ ଲେଃକେ । ଆତ୍ ଡାଗ୍ରା ମାଲେ ରେମୁଆଁ ଲେଃଗେ । ତେଲା ଜିସୁ ଆରି ମେଇଙ୍ଗ୍‌ନେ ସିସ୍‌ଇଙ୍ଗ୍ ଏତେ ଚଙ୍ଗ୍‌ନେ ଇକୁଡ଼ା ବେଲା ଡିଗ୍‍ ଆମିଲେକେ । ଜିସୁ ସିସ୍‌ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପେ ନେଙ୍ଗ୍ ଏତେ ମୁଇଂ ରେମୁଆଁଗଣ୍ଡ୍ ଣ୍ଡୁନେ ଜାଗାନ୍ନିଆ ନେଃୱେପା ଆରି ଆତ୍ ଡାଗ୍ରା ଇକୁଡ଼ା ନେଃପୁଣ୍ଡେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_32","071_6_32","MRK","6","32","32","ତେଲା ମେଇଙ୍ଗ୍‌ ମୁଇଂ ତରାନ୍ନିଆ କଚେ ମୁଇଂ ରେମୁଆଁଗଣ୍ଡ୍ ଣ୍ଡୁନେ ଜାଗାନ୍ନିଆ ୱେଏ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_33","071_6_33","MRK","6","33","33","ଡାଗ୍ଲା ଜବର୍‌ ରେମୁଆଁ ମେଇଙ୍ଗ୍ ଏତେ ଅଲେଙ୍ଗ୍ ୱେଆର୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ସାମୁଆଃ ୟାକେ । ତେଲା ସାପା ସଅର୍‌ନେ ରେମୁଆଁ ଅଲେଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍‌ଚେ ଜିସୁ ଲେଃକ୍ନେ ଟାନ୍‌ନ୍ନିଆ ୱିର୍ ଡୁଂୱେଚେ ସେନୁଗ୍ ୱେଚାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_34","071_6_34","MRK","6","34","34","ଜିସୁ ଉଡ଼ିବେଲା ଆତ୍ ୱେଚାକେ । ଗୁଲୁଏ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ମେଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ମେଁ ଦୟାରେ ତର୍‌ବର୍‌ ଡିଙ୍ଗ୍‌କେ । ଡାଗ୍ଲା ଆମେଇଂକେ ରକ୍ୟା ଡିଙ୍ଗ୍‌ ଆମ୍ୟାଃକ୍ନେ ମେଣ୍ଡା ରାସି ରକମ୍ ଲେଃଆର୍‌ଗେ । ଜିସୁ ଆମେଇଂକେ ଗୁଲେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_35","071_6_35","MRK","6","35","35","ଆତେନ୍‌ ବେଲା ତଙ୍ଗାର୍‌ ୱେଗେ । ଆତେନ୍‌‌ ବେଲା ସିସ୍ଇଂ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍ଆର୍‌କେ, “ଆକେନ୍ ମୁଇଂ ରେମୁଆଁଗଣ୍ଡ୍ ଣ୍ଡୁନେ ଟାନ୍ ଲମ୍‌ଡିଗ୍‌ ଡିଙ୍ଗ୍‌ ୱେଡିଙ୍ଗ୍‌କେ ।” ଆତେନ୍‌‌ସା ଆମେଇଂକେ ନୁଆଁ ବିଃପା ");
INSERT INTO gaq_vpl VALUES ("MK6_36","071_6_36","MRK","6","36","36","ତେଲା ରେମୁଆଁଇଙ୍ଗ୍‌କେ ଡାଗ୍ରା ସ୍ଲ ସାଇ ଇନି ଆଣ୍ଡେଙ୍ଗ୍ ବେପା । ତେଲା ଆତ୍ ୱେଚେ ମେଇଙ୍ଗ୍ ମେଇଙ୍ଗ୍‌ନ୍‌ସା ଚଙ୍ଗ୍‌ନ୍‌ସା ମେଃଡିଗ୍ ବିଆର୍‌ ଡୁଂପାଙ୍ଗ୍ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK6_37","071_6_37","MRK","6","37","37","ମାତର୍‌‌ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପେଇଙ୍ଗ୍ ଆମେଇଂକେ ଚଙ୍ଗ୍‌ନେ ବିଃପା ।” ସିସ୍‌ଇଙ୍ଗ୍ ସାଲ୍ୟାକୁଆର୍‌କେ, “ନେ ମେଃନେ ୱେଚେ ତ୍ମା ଆର୍କେନେ କୁଲି ଡାବୁ ରୁଟି ବିଆର୍ ଡୁଂପାଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ଚଙ୍ଗ୍‌ନେ ନେବିଏ ? ରୁଟି ବିଆର୍ ନ୍‌ସା ଦର୍‌କାର୍‌ ଡିଂଲା ଆନେଃ ସାପାରେକେ ମୁଇଙ୍ଗ୍ ଆର୍କେ ସ୍ଲେ ପଡ଼େଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_38","071_6_38","MRK","6","38","38","ଜିସୁ ସିସ୍‌ଇଂକେ ସାଲିଆକୁକେ, “ୱେ କେଲା, ନାଁନ୍ନିଆ ଉଡ଼ିକ୍ଲିଗ୍ ରୁଟି ଲେଃକେ ?” ସିସ୍‌ଇଂ ରୁଟି ଏଜା ଆଃଡାଚେ ବାସଙ୍ଗ୍‌କେ । “ନେଙ୍ଗ୍ ନ୍ନିଆ ମାଲିକ୍ଲିଗ୍ ରୁଟି ମ୍ବାକ୍ଲିଗ୍ ଆଡ଼ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_39","071_6_39","MRK","6","39","39","ଜିସୁ ଆଦେସ୍‌ ବିକେ, ରେମୁଆଁଇଙ୍ଗ୍‌ ଟିକ୍ରାନେ କ‍ଅଁଲ୍‌ନେ ଚେଃମୁଆଁ ଆଡ଼ାତ୍ରା ମାନ୍ଦା ମାନ୍ଦା ଆଡିଙ୍ଗ୍‌ଚେ ଆଃକବିପା । ");
INSERT INTO gaq_vpl VALUES ("MK6_40","071_6_40","MRK","6","40","40","ରେମୁଆଁଇଙ୍ଗ୍‌ ସାପା କୁଦାନିଆ ଶହେ ଶହେ ଆରି ପଚାସ୍‌ ପଚାସ୍‌ ଡିଙ୍ଗ୍‌ଚେ କଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_41","071_6_41","MRK","6","41","41","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମାଲିକ୍ଲିଗ୍ ରୁଟି ଆରି ମ୍ୱାକ୍ଲିଙ୍ଗ୍ ଆଡ଼କେ ଲିଙ୍ଗ୍‌ଚେ କିତଙ୍ଗ୍ ଇନି ତାଣ୍ଡେଚେ ପର୍‌ମେସର୍‌‌କେ ଦନ୍ୟବାଦ୍ ବିକେ । ଆତେନ୍‌ ରୁଟି ଇଂକେ ଟିକ୍‌ଚିଚେ ରେମୁଆଁଇଙ୍ଗ୍ ବିତ୍ରେ ବାଟା ବିଃନ୍‌ସା ସିସ୍ଇଂକେ ବିଃକେ । ଇଡ଼ିଙ୍ଗ୍ ଆଡ଼କେ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ପାଗ୍‌ଚିଚେ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ବାଟା ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_42","071_6_42","MRK","6","42","42","ସାପାରେ ସୁଲୁଏ ପୁରୁନ୍ ଚଙ୍ଗ୍‌ଚେ ସାନ୍ତି ବାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_43","071_6_43","MRK","6","43","43","ସାପାରେ ଚଙ୍ଗ୍ ଆଃଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ସିସ୍‌ଇଂ ଲୁଆଁକ୍ନେ ରୁଟି ମେତଗ୍‌ ଆରି ଆଃଡ଼ ମେତଗ୍‌ଇଙ୍ଗ୍ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ଆଣ୍ତ୍ରା ଅରିଆ ବର୍‌ତି ଆଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_44","071_6_44","MRK","6","44","44","ଜାଣ୍ଡେଇ ରୁଟି ଚଙ୍ଗ୍‌ଲେଃ ଆର୍‌ଗେ, ମେଇଙ୍ଗ୍‌ ବାନ୍ ମାତର୍‌‌ ଙ୍ଗିର୍‌ବ‍ଏଃନେ ସଂକ୍ୟା ମାଲ୍ ଅଜାର୍ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_45","071_6_45","MRK","6","45","45","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍ଇଂକେ ତରା ବିତ୍ରେ ୱେନେ ବାସଙ୍ଗ୍ କିକେ । ଜିସୁ ତରାନ୍ନିଆ ଡେଃଚେ ସିସ୍ଇଂକେ କେଣ୍ଡିଆନେ ଇନୁମେତା ପାକା ଲେଃକ୍ନେ ବେଥ୍‍ସାଇଦାନ୍ନିଆ ସେନୁଗ୍ ୱେନେ ବାସଙ୍ଗ୍‌କେ ଆରି ମେଁ ନିଜେ ଇଡ଼ିଙ୍ଗ୍ ମ୍ପାଙ୍ଗ୍ଏ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, ଆତେନ୍‌ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ଡୁଆ ୱିଗ୍‌ଲାପା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ । ମାତର୍‌ ମେଁ ଲେଃୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_46","071_6_46","MRK","6","46","46","ଜିସୁ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ବେବିଃକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ନ୍‌ସା କଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_47","071_6_47","MRK","6","47","47","ଲମ୍‌ଡିଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ତରା ମଜେ ଲଣ୍ଡିଆଃ ଲେଃଗେ ଆରି ଜିସୁ ଆଃଡ଼ା କେଣ୍ଡିଆ ତୁବନ୍ନିଆ ମୁଇଂଜା ଆଃ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_48","071_6_48","MRK","6","48","48","ଜିସୁ କେକେ ଜେ ସିସ୍‌ଇଙ୍ଗ୍‌କେ ତରାନେ ଚାଟୁ ଗାଟେ ନ୍‌ସା ଅର୍‌ବର୍ ବାଡିଂଆର୍‌ଗେ । ଡାଗ୍ଲା ଆତେନ୍‌ ବେଲା ୱେଡ଼ିଆ ଉଲ୍‌ଟା ପାଲ୍‌ଟା ବଗ୍‌ଡିଂକେ । ଗିସେଙ୍ଗ୍ ତେଃସନେ ବେଲା ଞ୍ଜି ରୁ ତୁର୍‌ ଗଣ୍ଟା ବିତ୍ରେ ଜିସୁ କେଣ୍ଡିଆ ଆଃଡ଼ା ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ସିସ୍‌ଇଙ୍ଗ୍‌ନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ । ମେଁ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଡାଗ୍ରା ସେନୁଗ୍‌ ୱେନ୍‌ସା ରାଜି ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_49","071_6_49","MRK","6","49","49","ଡାଗ୍‌ଲା ମେଇଙ୍ଗ୍ ଆମେକେ କେଣ୍ଡିଆ ଆଡ଼ାତ୍ରା ଅଲେଙ୍ଗ୍‌ନେ କେଚେ ଆମେକେ ବୁତ୍‌ ଡାଗ୍‌ଚେ ବାବେଆର୍‌କେ । ମେଇଙ୍ଗ୍ କିରନେ ମୁଲେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_50","071_6_50","MRK","6","50","50","ସାପା ସିସ୍‌ଇଙ୍ଗ୍ ଡିରକମ୍ ଆମେକେ କେଆର୍‌କେ, ଆତେନ୍‌‌ ବେଲା ମେଇଙ୍ଗ୍ ବୁଟମେଗ୍‌ ଆର୍‌କେ । ଜିସୁ ଟାପ୍‌ନା ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ସାଆସ୍ ସାଃପା । ଆକେନ୍‌ ତ ନେଙ୍ଗ୍, ଆବ୍‌ଟଗେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK6_51","071_6_51","MRK","6","51","51","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ସିସ୍‌ଇଙ୍ଗ୍ ଏତେ ତରାନ୍ନିଆ ଡେଃକେ । ୱେଡ଼ିଆ ବନ୍ଦ୍‌ ଡିଂୱେକେ । ଆତ୍‌ବାନ୍ ମେଇଙ୍ଗ୍ କାବା ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_52","071_6_52","MRK","6","52","52","ମେଇଙ୍ଗ୍ ରୁଟି ବିସୟ୍‌ରେ କାବା ଡିଂକ୍ନେ କାମ୍ ବୁଜେ ଆୟାଆର୍କେ ଣ୍ତୁ । ମେଇଙ୍ଗ୍‌ନେ ବୁଦି କାନାବାନା ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_53","071_6_53","MRK","6","53","53","ଜିସୁ ଆରି ମେଇଙ୍ଗ୍‌ନେ ସିସ୍‌‌ଇଙ୍ଗ୍‌ କେଣ୍ତିଆ ପୁଆଃଚେ ଗିନେସରତ୍ ଏରିଆ ୱେଚାଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ତରାକେ ଆତ୍ ଅରିଆ ଗାଗ୍‌ବି ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_54","071_6_54","MRK","6","54","54","ତରାବାନ୍ ଜାର୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ରେମୁଆଁଇଙ୍ଗ୍ ଜିସୁକେ କେଚେ ସାମୁଆଃ ୟାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_55","071_6_55","MRK","6","55","55","ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍‌ ଜିସୁ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କବର୍ ବିଃନ୍‌ସା ଆତେନ୍‌‌ ଇନି ପାକାନେ ସାପା ପାକା ୱିର୍ ଡୁଂୱେଆର୍‌କେ । ଜିସୁ ଆଣ୍ତିନେ ଟାନ୍‌ନ୍ନିଆ ୱେକେ, ଆତ୍‌ନେ ସାପା ପାକା କବର୍‌ ଉଡ୍ରା ଡିଙ୍ଗ୍‌ୱେଗେ ଆରି ଆତ୍ଅରିଆ ରେମୁଆଁଇଙ୍ଗ୍‌ ରଗି‍ଇଂକେ କଟ୍‌ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK6_56","071_6_56","MRK","6","56","56","ଜିସୁ ଆଣ୍ଡିନେ ଇନି ସହର୍‌ ବାରି ପଲୀ ଇନିପାକା ୱେଚାକେ, ଆତ୍‌ଅରିଆନେ ସାନ୍ତାନିଆ ରେମୁଆଁ ଆଃସିରେଇଂକେ ବଚେ ଇଃତୁଡ଼ା ମେଁନେ ପାଟାଇ ଲିଗ୍‌ନ୍‌ସା ଗୁଆରେ ଆର୍‌କେ ବାରି ମେଁନେ ସକାନେ ଜାଲିପୁଆଃ ଲିଗ୍‌କ୍ନେ ଦାପ୍ରେ ରଗିଇଂ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_1","071_7_1","MRK","7","1","1","ଉଡ଼ିକ୍ଲିଗ୍ ଫାରୁଶୀଇଂ ଆରି ଉଡ଼ିକ୍ଲିଗ୍ ଦର୍ମ ସାସ୍ତ୍ରି ଯିରୂଶାଲମବାନ୍ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ପିତୁର୍‍ପାକା ରିସିଙ୍ଗ୍ ୱେ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_2","071_7_2","MRK","7","2","2","ମେଁଇଙ୍ଗ୍‌ ଜିସୁନେ ଉଡ଼ିରୁଆ ସିସ୍ଇଂକେ ଅସୁଚି ବା ନ୍ତି ମାଗୁଇତିଚେ ଚଙ୍ଗ୍‌ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_3","071_7_3","MRK","7","3","3","ଫାରୁଶୀ ଆରି ସାପା ଜିଉଦିଇଂ ଗୁଇତି ଗୁଏଚଚେ ଅଃନା ଡିଗ୍ ଆଚଙ୍ଗ୍ ଆର୍‌ଏ ଣ୍ଡୁ । ମେଁଇଙ୍ଗ୍‌ ମେଇଂନେ ଅଃସେନେ ମ୍ନା ନ୍ତା ଞ୍ଜାଃଇଂବାନ୍ ଡିଂଡିଂକ୍ନେ ନିୟମ୍‌ ପାଲନ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆକେନ୍ ଡିଙ୍ଗ୍‌ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_4","071_7_4","MRK","7","4","4","ସାନ୍ତା ଆଣ୍ତେଙ୍ଗ୍ ବାନ୍‌ ଅଲେଙ୍ଗ୍‌ ପାଙ୍ଗ୍‌ଚେ ସେନୁଗ୍‌ ନିୟମ୍‌ ଅନୁସାରେ ନ୍ତି ଞ୍ଚ ମାଗୁଏଚ କୁଟା ମେଃଡିଗ୍‌ ଆଚଙ୍ଗ୍‌ ଆର୍‌ ଣ୍ତୁ । ଗାରିଆ, ଗିନା, କଁସ୍ ମୁତାଇଙ୍ଗ୍‌ ବାରି ସିଙ୍ଗ୍‌ଲାଇଙ୍ଗ୍‌ ଗଃଡ଼୍ୟାଃ ନ୍‌ସା ବିନ୍‌ ବିନ୍‌ ରକମ୍‌ ନିୟମ୍‌ ପାଲନ୍‌ ଡିଙ୍ଗ୍‌ମ୍ୟାଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_5","071_7_5","MRK","7","5","5","ତେଲା ଫାରୁଶୀଇଂ ଆରି ସାସ୍ତ୍ରିଇଂ ଜିସୁକେ ସାଲ୍ୟାକୁଆର୍‌କେ, “ନାଁନେ ସିସ୍ଇଂ ପାରୁସିଇଂନେ ନିଅମ୍ ସାଚେ ମେଁନ୍‌ସା ମାଗୁଏଃଚ ମାଗୁଇତିଚେ ଚଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍, ମେଇଙ୍ଗ୍‌ ଦେକ୍‌ରକମ୍ ମେଁନ୍‌ସା ଡିଙ୍ଗ୍ଆର୍‌ଡିଂକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK7_6","071_7_6","MRK","7","6","6","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ରେ କୁଟ୍‌ଣ୍ଡ୍ରେଇଂ ଯିଶାଇୟ ପେନେ ବିସୟ୍‌ରେ ସତ୍ ବାବ୍‌ରେ ବବିସତ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ବକେ, ଡିରକମ୍ ଗୁଆର୍‍ବକେ, ଆକେନ୍ ରେମୁଆଁଇଂ ସାର୍ମୁଆଃନ୍ନିଆ ଆନିଂକେ ସନ୍‌ମାନ୍ ବିଃମ୍ୟାଆର୍‌କେ । ମାତର୍‌ ଗାଗ୍‌ଡ଼େ ନିଂବାନ୍ ସ୍ଲ ଲେଃକେ ।” “ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‌କେ, ଡିରକମ୍ ଗୁଆର୍‌ବକେ ଆକେନ୍ ଜାତିନେ ସାର୍ମୁଆଃନ୍ନିଆ ଆନିଙ୍ଗ୍‌କେ ସନ୍‌ମାନ୍ ବିଏ । ଡାଗ୍‌ଲା ମେଇଙ୍ଗ୍‌ନେ ଗାଗ୍‌ଡ଼େ ନେଁ ବାନ୍ ସ୍ଲ ଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MK7_7","071_7_7","MRK","7","7","7","ମେଇଙ୍ଗ୍ ରେମୁଆଁଇଂକେ ନିଅମ୍‌ଇଙ୍ଗ୍‌କେ ଦର୍ମନେ ଆଦେସ୍ ସାମୁଆଁ ଡାଗ୍‌ଚେ ଗ୍ୟାନ୍ ବିଚେ ସରାଃସ୍ରିଃ ନେନେ ପାର୍‌ତନା ଡିଂମ୍ୟାଃଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_8","071_7_8","MRK","7","8","8","“ପେଇଂ ଇସ୍‌ପର୍‌ନେ ଆଦେସ୍ ଆନ୍ତାର୍ ବିଚେ । ଏବେ ପେଇଂ ରେମୁଆଁନେ ନିଅମ୍ ସାଚେ କପେଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_9","071_7_9","MRK","7","9","9","ଜିସୁ ଆରି ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନିଜେନେ ନିୟମ୍‌ ପାଲେନେନ୍‌ସା ପେଇଙ୍ଗ୍ ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ ଆନ୍ତାର୍‌ଚେ ନିଜେକେ ଚାଲାକି ଡାଗ୍‌ଚେ ବାବେ ପେଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("MK7_10","071_7_10","MRK","7","10","10","ମୋଶା ନିଅମ୍ ବାସଙ୍ଗ୍‌ବକେ, ଆବା ଇୟାଙ୍ଗ୍‌ନେ ସାମୁଆଁ ମାନେଃପା । ଜା ମେଁନେ ଆବାଡ଼େ କି ଇୟାଙ୍ଗ୍‌ଡେକେ ଦଦ୍ୟା ସାମୁଆଁ ବାସଙ୍ଗ୍ଏ, ମେଁ ଗୁଏଃନେ ଡଣ୍ଡ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MK7_11","071_7_11","MRK","7","11","11","ମାତର୍‌ ପେ ବାସଙ୍ଗ୍‌ପା, ଜାଣ୍ଡେ ଜଦି ଆବା କି ଇୟାଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌ଏ, ନିଂ ବାନ୍‌, ଜା ବାନ୍‌ ପେ ନିମାଣ୍ଡା ଡିଂପେଲେଃ, ତେଲା ‘କର୍ବାନ୍‌’ ବା ଇସ୍‌ପର୍‌କେ ମାନତ୍‌ ଡିଂଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_12","071_7_12","MRK","7","12","12","ତେଲା ପେ ଇୟାଙ୍ଗ୍‌ ଆବାକେ ସାଇଜ ଡିଂନେ ଦାଇତ୍‌ବାନ୍‌ ପେତାର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK7_13","071_7_13","MRK","7","13","13","ଡେକ୍‌ରକମ୍‌ ବାବ୍‌ରେ ବିନ୍‌ରେକେ ବିଃପେବକ୍ନେ ପେନେ ସିକ୍ୟା ଇସ୍‌ପର୍‌ନେ ଆଦେସ୍‌କେ ଅମାନି ଡିଂପେଡିଂକେ । ଦେକ୍‌ରକମ୍‌ ବାରି ଗୁଲେ କାମ୍ ପେ ଡିଂପେଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_14","071_7_14","MRK","7","14","14","ଜିସୁ ରେମୁଆଁଇଂକେ ଡାଗ୍ରା ୱାଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ସାପା ରେମୁଆଁ ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଦ୍ରିଗ୍‌ପା ଆରି ବୁଜେପା । ");
INSERT INTO gaq_vpl VALUES ("MK7_15","071_7_15","MRK","7","15","15","ଦେକ୍‌ରକମ୍ ମେଃଣ୍ଡିଗ୍ ଜିନିସ୍ ଣ୍ଡୁ ଆଣ୍ଡିନେ ବାଏରେ ରେମୁଆଁ ବିତ୍ରେବାନ୍ ବାଏରେ ପାଙ୍ଗ୍‌ଏ ଆରି ଆଣ୍ଡିନେ ଜିନିସ୍ ରେମୁଆଁ ବିତ୍ରେବାନ୍ ତାର୍‌ମ୍ୟାକେ ଆତେନ୍‌ ଆଃ ଆମେକେ ଦଦ୍ୟା ଆଃଡିଙ୍ଗ୍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_16","071_7_16","MRK","7","16","16","“ଜଦି ଜାନେ ଅଁନେ ନ୍‌ଲୁଗ୍‌ ଲେଃକେ ମେଁ ଅଁଲେଃ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_17","071_7_17","MRK","7","17","17","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ରେମୁଆଁଇଙ୍ଗ୍‌କେ ଆନ୍ତାର୍‌ଚେ ଡୁଆ ବିତ୍ରେ ଗାୱେଗେ । ସିସ୍ଇଂ ଆମେକେ ଆକେନ୍ ଉଦା‍ଅରନ୍ ସାମୁଆଁ ବିସୟ୍‌ରେ ସାଲ୍ୟାକୁଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_18","071_7_18","MRK","7","18","18","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ବିନ୍‌ଣ୍ଡ୍ରେ ସୁଗା ପେନେ ଡିଗ୍‌ ବୁଜେନେ ବପୁ ମେଃନେ ଅଃକେନ୍‌ ଗଣ୍ଡାଃ ? ଅଃକେନ୍‌ ବୁଜେ ପେୟାକେ ? ଆଣ୍ଡିନେ ରେମୁଆଁନେ ବିତ୍ରେ ବାଏରେବାନ୍‌ ଗାଏ, ଆତେନ୍‌ ଆମେକେ ଅପବିତ୍ର ଆଃଡିଙ୍ଗ୍ ଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK7_19","071_7_19","MRK","7","19","19","ଡାଗ୍ଲା ଚଙ୍ଗ୍‌କ୍ନେ ମେଃନେ ପାରାନ୍ ବିତ୍ରେ ମାୱେଚେ ସୁଲୁଏ ବିତ୍ରେ ୱେଏ ଆରି ଡିଡିଆପାର୍ ଡାଗ୍ରା ତାର୍‌ଏ ।” ଦେକ୍‌ରକମ୍‌ ସାପା କାଦି ପର୍‌ଚଲ୍‌ ଡିଂଲେଃଏ, ଆକେନ୍‌ ମେଃନେ ବୁଜେ ପେୟାକେ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("MK7_20","071_7_20","MRK","7","20","20","ମେଁ ବାରି ବାସଙ୍ଗ୍‌କେ, “ମେଁନେ ସାପା ରେମୁଆଁନେ ବିତ୍ରେବାନ୍ ତାର୍‌ଏ ଆତେନ୍‌ ଆମେକେ ଅପବିତ୍ର ଆଃଡିଙ୍ଗ୍ଏ ");
INSERT INTO gaq_vpl VALUES ("MK7_21","071_7_21","MRK","7","21","21","ଡାଗ୍ଲା ବିତ୍‌ରେବାନ୍‌, ରେମୁଆଁନେ ମନ୍‌ବାନ୍‌, ଦଦ୍ୟା‌ ଚିନ୍ତା ତାର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK7_22","071_7_22","MRK","7","22","22","ଦାରି ୱେନେ, ଡଙ୍ଗାନେ, ରେମୁଆଁ ବାଗୁଏନେ, ଅଡ଼ାରେଗ୍‌‌ ଡିଙ୍ଗ୍‌ନେ, ଲବ୍‌ଡିଙ୍ଗ୍‌ନେ, ଦୁସ୍‌ଟ ଡିଙ୍ଗ୍‌ନେ, ନାଲେନେ, ଦଦ୍ୟା‌ କାମ୍ ଡିଙ୍ଗ୍‌ନେ, ଇର୍ସାରେ କେନେ, ନିନ୍ଦା, ଆଂକାର୍‌, ମୁର୍କ । ");
INSERT INTO gaq_vpl VALUES ("MK7_23","071_7_23","MRK","7","23","23","ଏନ୍ ସାପା ସତ୍‌ ଣ୍ତୁନେ ବିସୟ୍ ରେମୁଆଁନେ ଗାଗ୍‌ଡ଼େ ବିତ୍ରେ ବାନ୍‌ ତାର୍‌ଚେ ରେମୁଆଁକେ ଦଦ୍ୟା ଆଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_24","071_7_24","MRK","7","24","24","ଆତେନ୍‌ ବେଲା ମେଁ ଆତ୍‌ବାନ୍ ତଡ଼ିଆଚେ ସୋର ପାକା ୱେକେ ଆରି ମୁଇଂ ଡୁଆନିଆ ଗାଚେ ଜାଣ୍ଡେ ଡିରକମ୍ ଆତେନ୍‌ ଆମ୍ୟାଃଲେ ଡାଗ୍‌ଚେ ମେଁ ଆକେନ୍ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଡିଂଗେ । ମାତର୍‌‌ ମେଁ ବୁଙ୍ଗ୍‌ଲେଃ ଆୟାକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK7_25","071_7_25","MRK","7","25","25","ଆତେନ୍‌ ଦାପ୍ରେ ମୁଇଂ ସେଲାମ୍ବୁଏ ରେମୁଆଁ ଜିସୁ ପାଙ୍ଗ୍‌ଲେଃକ୍ନେ କବର୍ ଅଁଚେ ମେଁ ଉଙ୍ଗ୍‌ଡେନେ ଗାଗ୍‌ଡ଼େ ବିତ୍ରେ ଦଦ୍ୟା ଆତ୍ମା ଗାଲେଃଗେ । ତେଲା ମେଁ ଟାପ୍‌ନା ଜିସୁ ଡାଗ୍ରା ୱେଚେ ମେଁନେ ପାଦ୍‌ଚନ୍ନିଆ ଲଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_26","071_7_26","MRK","7","26","26","ଆତେନ୍‌ ମୁଇଂ ଗ୍ରୀକ୍ ସେଲାମ୍ବୁଏ ଲେଃଗେ । ମେଁ ସିରିଆନେ ଫୈନିକୀୟା ଅରିଆ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେଃଗେ । ମେଁ ମେଁନେ ଉଙ୍ଗ୍‌ଡେବାନ୍ ଗଲିଆ ଆଆଁନ୍ତାର୍ ବିଃନ୍‌ସା ଜିସୁକେ ପାର୍‌ତନା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_27","071_7_27","MRK","7","27","27","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ସେନୁଗ୍ ଗଡ଼େଇଙ୍ଗ୍‌କେ ସାନ୍ତି ଡିଙ୍ଗ୍‌ନେ ବିଃପା ଡାଗ୍ଲା ଗଡ଼େଇଂନେ କାଦି ଡୁଙ୍ଗ୍‍ ୱେଚେ ଗୁସୁଃନେ ସେନୁଗ୍ ଜଗ୍‌ତ୍ଲାଗ୍‌ନେ ବଲ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_28","071_7_28","MRK","7","28","28","ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ଉତର୍ ବିକେ, “ଅଁ ମାପ୍ରୁ ଆତେନ୍‌ ସତ୍ ମାତର୍‌‌ ଗଡ଼େଇଂ ଚଙ୍ଗ୍‌ନେ ବେଲା ତୁବଃ ଲଃକ୍ନେ ଜୁଟା ଟିବୁଲ୍‌ ଆଲ ଲେଃକ୍ନେ ଗୁସୁଃଇଂ ଣ୍ଡିଙ୍ଗ୍ ଚଙ୍ଗ୍ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_29","071_7_29","MRK","7","29","29","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃକେ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍ ଆଃ ନିମାଣ୍ତା ଉତର୍ । ଏବେ ନାଁ ଡୁଆ ୱିଗ୍‌ନାୟାଏ ଗଲିଆ ନାଉଙ୍ଗ୍‌କେ ଆନ୍ତାର୍‌ଚେ ଡଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_30","071_7_30","MRK","7","30","30","ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ରେମୁଆଁ ଡୁଆ ୱିଗ୍‌ଚେ କେକେ ଜେ ମେଁ ଉଙ୍ଗ୍‌ଡେ କଟ୍‌ନିଆ ଡୁଲେଗ୍ ଲେଃକେ । ଦଦ୍ୟା ଆତ୍ମା ମେଁ ଗାଗ୍‍ଡ଼େବାନ୍ ତାର୍‌ଚେ ଡଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_31","071_7_31","MRK","7","31","31","ତେନ୍‌ଇଡ଼ିଂ ଜିସୁ ଇନିନେ ଡାଗ୍ରା ଏରିଆ ଆନ୍ତାର୍‌ଚେ ଦେକାପଲୀ ଗାଲିନ୍ନିଆ ସୀଦନ ବିଚେ ଗାଲିଲୀ କେଣ୍ଡିଆ ଡାଗ୍ରା ପିଙ୍ଗ୍‍ଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_32","071_7_32","MRK","7","32","32","ଆତ୍ଅରିଆ ଉଡ଼ି ରେମୁଆଁ ଜିସୁ ଡାଗ୍ରା ମୁଇଂ ରେମୁଆଁକେ ଡୁଂପାଙ୍ଗ୍‌କେ । ଆତେନ୍‌ ରେମୁଆଁ କନ୍ଦା ଆରି ବ‍ଇରା ଲେଃକେ । ରେମୁଆଁଇଂ ଜିସୁକେ କୁସାମୁତି ଡିଙ୍ଗ୍ଆର୍‌କେ ଜେ ମେଁନେ ନ୍ତି ରେମୁଆଁନେ ଆଡ଼ାତ୍ରା ବଚେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌ବିଃଲେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_33","071_7_33","MRK","7","33","33","ଜିସୁ ଆତେନ୍‌ ରେମୁଆଁକେ ଗହଲି ବାନ୍ ଇକୁଡ଼ା ସ୍ଲପାକା ଡୁଂୱେଗେ । ମେଁ ଆତେନ୍‌ ରେମୁଆଁକେ ନ୍ଲୁଗ୍‍ ବିତ୍ରେ ନିଜେନେ ଆର୍‌ୱେତି ବକେ । ତେନ୍‌ଇଡ଼ିଂ ମେଁ ବିଃତୁର୍‌ ବିକେ ଆରି ରେମୁଆଁନେ ନ୍ଲିୟାକେ ଲିଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_34","071_7_34","MRK","7","34","34","ଜିସୁ ଆରି କିତଙ୍ଗ୍ଇନି କେଚେ ଜବର୍‌ ପୁଣ୍ଡା ଗୁଃଚେ ମେଁ ରେମୁଆଁକେ ବାସଙ୍ଗ୍‌କେ, “ଇପ୍ପଥାଃ” ଡାଗ୍‌ଲା ତର୍ସା ୱେଲା । ");
INSERT INTO gaq_vpl VALUES ("MK7_35","071_7_35","MRK","7","35","35","“ଆତାନ୍‌ ଦାପ୍ରେ ରେମୁଆଁ ଦ୍ରିଗ୍‌ନେ ବପୁ ବାକେ ମେଁ କନ୍ଦା ଡିଂଲେଃକ୍ନେବାନ୍‌ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ୱେଗେ ବାରି ମେଁ ନିମାଣ୍ତା ବାବ୍‌ରେ ସାମୁଆଁ ବାଲିର୍‌ ୟାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK7_36","071_7_36","MRK","7","36","36","ଆରି ଆକେନ୍ ସାମୁଆଁ ଆଜାଡିଗ୍ ଆବାସଙ୍ଗ୍‍ପା ଡାଗ୍‌ଚେ ଆମେଇଂକେ ବାଲିର୍‍କେ । ଡାଗ୍ଲା ମେଁ ଆମେଇଂକେ ଉଡ଼ି ମନା ଡିଙ୍ଗ୍‍କେ ମେଇଙ୍ଗ୍ ଅଦିକ୍‌ ବାଲିର୍‍ ଅଲେଙ୍ଗ୍‍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK7_37","071_7_37","MRK","7","37","37","ରେମୁଆଁଇଂ ସିସେବାନ୍ କାବା ଡିଙ୍ଗ୍‍ ୱେଲେଃଆର୍‌ଗେ । ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଡିଂଆର୍‌ଗେ, “ଜିସୁ ସାପା କିଚି ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ । ଦେକ୍‌ରକମ୍‍ କି ମେଁ ବଇରାକେ ଦ୍ରିଗ୍‌ନେ ବପୁ ଆରି କନ୍ଦାକେ ବାଲିର୍‌ନେ ବପୁ ବିଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_1","071_8_1","MRK","8","1","1","ଆତେନ୍‌ ବେଲା ଜିସୁ ଏତେ ଜବର୍‌ ରେମୁଆଁ ଲେଃଗେ । ଆମେଇଂକେ ମେଃଡିଗ୍ ଚଙ୍ଗ୍‌ନେ ଣ୍ଡୁ । ଏନ୍ ଜିସୁ ସିସ୍ଇଂକେ ଡାଗ୍ରା ୱାଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("MK8_2","071_8_2","MRK","8","2","2","“ଏନ୍‌ ରେମୁଆଁଇଙ୍ଗ୍‌ନ୍‌ସା ଆନେଙ୍ଗ୍‌କେ ଜାବର୍‌ ଲିବିସଃ ଲାଗେ ଡିଙ୍ଗ୍‌କେ । ମେଇଙ୍ଗ୍ ନେଙ୍ଗ୍ଏତେ ଜିର୍‌ସି ଡିଙ୍ଗ୍‌ଗେ ନେଙ୍ଗ୍ ଏତେ ଲେଃଆର୍‌ଡିଂକେ । ମାତର୍‌ ଚଙ୍ଗ୍‌ନ୍‌ସା ମେଃଡିଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK8_3","071_8_3","MRK","8","3","3","ମେଇଂ ମାଚଙ୍ଗ୍‍ଚେ ଆକ୍‌ବାନ୍ ୱିଗ୍‍ଲେ ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଣ୍ଡୁ । ମେଇଂନେ ବିତ୍ରେ ଉଡ଼ି ରୁଆ ଜାବର୍ ସ୍ଲବାନ୍‌ ପାଙ୍ଗ୍‌ଲେ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_4","071_8_4","MRK","8","4","4","ଜିସୁନେ ସିସ୍ଇଂ ବାସଙ୍ଗ୍ଆର୍‌କେ, “ନେ ଆକ୍ ରେମଆଁଗଣ୍ଡ୍ ଣ୍ଡୁନେ ଇନି ଅରିଆ ଆକ୍‌ମେଇଂକେ ଆଃଚଙ୍ଗ୍‌ ନ୍‌ସା ଜବର୍‌ କାଦି ଆଣ୍ଡିବାନ୍ ନେବାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK8_5","071_8_5","MRK","8","5","5","ଜିସୁ ଆମେଇଂକେ ସାଲିଆକୁକେ, “ପେନ୍ନିଆ ଉଡ଼ିକ୍ଲିଗ୍ ରୁଟି ଲେଃକେ ?” ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌କେ । “ନେଅରିଆ ଗୁକ୍ଲିଗ୍ ରୁଟି ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_6","071_8_6","MRK","8","6","6","ତେନ୍‌ଇଡ଼ିଂ ଜିସୁ ରେମୁଆଁଇଂକେ ତୁବଃ ଆଡ଼ାତ୍ରା କୁକନ୍‍ସା ବାସଙ୍ଗ୍‌କେ, ମେଁ ଗୁକ୍ଲିଗ୍ ରୁଟି ଡୁଂୱେକେ ଆରି ଆତେନ୍‌‍ସା ପରମେସର୍‍କେ ଦନ୍ୟବାଦ୍ ବିକେ । ରୁଟି ସାପା ପାଗ୍‌ଚିଚେ ସିସ୍ଇଂକେ ବାଟା ବିନେସା ବିକେ । ମେଇଙ୍ଗ୍ ଦେଃତୁଆ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_7","071_8_7","MRK","8","7","7","ସିସ୍‌ଇଙ୍ଗ୍ ଡାଗ୍ରା ଉଡ଼ିକିଲିଗ୍‌ ଡାଆଁ ଆଃଡ଼ ଲେଃଗେ । ଜିସୁ ଆଡ଼ ନ୍‌ସା ଦନ୍ୟବାଦ୍ ବିଚେ ସିସ୍‌ଇଙ୍ଗ୍ କିକେ ଆତେନ୍‌ ସାପା ବାଟା ବିନେ ବାସଙ୍ଗ୍ କିକେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_8","071_8_8","MRK","8","8","8","ସାପା ରେମୁଆଁ ଚଙ୍ଗ୍‌ଚେ ସାନ୍ତି ଡିଙ୍ଗ୍ଆର୍‌କେ । ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍ ଲୁଆଁକ୍ନେ ପାକ୍‌ଚିଃକ୍ନେ ଉଡ଼ିକ୍ଲିଗ୍ ରୁଟି ଗୁକ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାନିଆ ତାଃନ‍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_9","071_8_9","MRK","8","9","9","ଆତ୍ଅରିଆ ପ୍ରାୟ୍‍ ଅଁ ଅଜାର୍ ରେମୁଆଁଇଂ ଚଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_10","071_8_10","MRK","8","10","10","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ରେମୁଆଁଇଂକେ ବେବିଚେ ସିସ୍‌ଇଂ ଏତେ ତରାନ୍ନିଆ ଡେଃଚେ ଦଲ୍‌ମନୁଥା ପ୍ରଦେସ୍‌ନ୍ନିଆ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_11","071_8_11","MRK","8","11","11","ଫାରୁଶୀଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ପରିକ୍ୟା ଡିଙ୍ଗ୍‌ନେସା ପ୍ରସ୍‌ନ ସାଲିଆକୁଆର୍‌କେ, ମେଇଙ୍ଗ୍ ଜିସୁକେ ପାନ୍ଦ୍‍ ଅରିଆ ତ୍ଲାଗ୍‌ନେସା ଚାଏଁଆର୍‌କେ । ତେସା ମେଇଙ୍ଗ୍ ଜିସୁକେ ମେଁ ପର୍‌ମେସର୍‌ନିଆ ବାନ୍ ପାଙ୍ଗ୍ ଲେଃକେ ଡାଗ୍‌ଚେ ପାର୍‍ମାନ୍‍ ଡିଙ୍ଗ୍‌ନେସା କାବା ସୁଗୁଆ କାମ୍ ଡିଙ୍ଗ୍‌ନେ ବାଲିର୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_12","071_8_12","MRK","8","12","12","ଜିସୁ ପୁଣ୍ଡାକେ ବିତ୍ରେ ଗୁଃଚେ ଦୁକ୍‌କେ ବାଏରେ ଆଃତାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ପେଇଂ ମେଃନ୍‌ସା ପାର୍‍ମାନ୍‍ ସୁଗୁଆ କାବାନେ କାମ୍ କିକେନେ ଚାଏଁପେଡିଙ୍ଗ୍‌କେ ? ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ ରେମୁଆଁଇଂକେ ଦେତ୍‌ରକମ୍ ପାର୍‍ମାନ୍‍ ଆବିଃ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_13","071_8_13","MRK","8","13","13","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଫାରୁଶୀଇଂକେ ଆନ୍ତାର୍‌ଚେ ଆରି ମୁଇଙ୍ଗ୍ ତର୍ ତରା ବିତ୍ରେ ଅଲେଙ୍ଗ୍ ଡୁଂପାଙ୍ଗ୍‌କେ । ମେଁ ତରାଅରିଆ କଚେ କେଣ୍ଡିଆନେ ଇନୁମେତା ତାର୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_14","071_8_14","MRK","8","14","14","ମେଇଙ୍ଗ୍ ଚୁଚଙ୍ଗ୍‌ନ୍‌ସା ଜବର୍ କାଦି ଡୁଂପାଙ୍ଗ୍‌ନେ ଆବବିଲେଆର୍ଗେ । ତରାନ୍ନିଆ ସିସ୍‌ଇଙ୍ଗ୍ ଡାଗ୍ରା ମୁଇଂ ଆଃ ରୁଟି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_15","071_8_15","MRK","8","15","15","ଜିସୁ ଆମେଇଂକେ ଚେତ୍‌ନା ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ତରକ୍ ଲାଃଲାପା, ଫାରୁଶୀ ଆରି ହେରୋଦନେ ମିଚ୍‌ ସିକ୍ୟାବାନ୍ ଖମୀର ଚଙ୍ଗ୍‌ନେ ବାନ୍ ଜବର୍‌ ସ୍ଲ ଲାଃଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_16","071_8_16","MRK","8","16","16","ସିସ୍‌ଇଙ୍ଗ୍ ଆକେନ୍‌ ଡାବୁ ବିସୟ୍‌ରେ ଅବାଃଲିର୍ ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ନେ ଡାଗ୍ରା ରୁଟି ଣ୍ଡୁ ଡାଗ୍‌ଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_17","071_8_17","MRK","8","17","17","ମେଇଙ୍ଗ୍ ମେଃନେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ଆର୍‌ଡିଂକେ, ଆତେନ୍‌ ଜିସୁ ମ୍ୟାଃଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ରୁଟି ଣ୍ଡୁ ଡାଗ୍‌ଚେ ପେ ମେଃନ୍‌ସା ବାଲିର୍‌ବାତା ଡିଂପେଡିଙ୍ଗ୍‌କେ ? ଏଃ ଜାକ ପେ କେ’ପେୟାକେ କି ବୁଜେ ପେୟାକେ ? ପେନେ ଗାଗ୍‌ଡ଼େ ବ୍ରି ଡିଂୱେଲେଃକେ ? ");
INSERT INTO gaq_vpl VALUES ("MK8_18","071_8_18","MRK","8","18","18","ପେନେ ମ୍ମୁଆଃ ଲେଃକେ, ତେଲାଡିଗ୍ କିକେ ପେୟାକେ ? ପେନେ ନ୍ଲୁଗ୍ ଲେଃକେ, ତେଲାଡିଗ୍ ଅଁ ପେୟାକେ ? ");
INSERT INTO gaq_vpl VALUES ("MK8_19","071_8_19","MRK","8","19","19","ନେଙ୍ଗ୍ ଉଃଡ଼ିବେଲା ମାଲ୍ ଅଜାର୍ ରେମୁଆଁଇଙ୍ଗ୍ ଆତ୍‌ଲା ମାଲିକ୍ଲିଗ୍ ରୁଟି ପାଗ୍‌ଚିଚେ ଆପେକେ ବିମ୍ୱଗେ । ମନେ ତ୍ଲାଗ୍ କେଲାପା, ପେ ଉଡ଼ିକ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାଅରିଆ ରୁଟି ପେରାଃତ୍ନକେ ?” ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଗମ୍ୱାର୍ କ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାନ୍ନିଆ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_20","071_8_20","MRK","8","20","20","“ଆରି ନେଙ୍ଗ୍ ଉଡ଼ିବେଲା ଅଁ ଅଜାର୍ ରେମୁଆଁଇଙ୍ଗ୍ ନ୍‌ସା ଗୁକ୍ଲିଗ୍ ରୁଟି ପାଗ୍‌ଚିଚେ ବିମ୍ଵଗେ । ଏତେ କେଲାପା, ପେଇଙ୍ଗ୍ ଉଡ଼ିକ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାନ୍ନିଆ ଲୁଆଁକ୍ନେ ରୁଟି ସାପା ଆତ୍ନ ପେବଗେ ?” “ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, ଗୁକ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାନ୍ନିଆ ନେରାଃତ୍ନକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_21","071_8_21","MRK","8","21","21","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ମେଃ ଡିଙ୍ଗ୍ ମ୍ୱକେ । ଆତେନ୍‌ ସାପା ପେ ମନେ ପେବକେ । ଏଃକେ ଜାକ ପେ ଇକୁଡ଼ା ଡିଗ୍ ବୁଜେ ପେୟାକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK8_22","071_8_22","MRK","8","22","22","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍ ବେଥ୍‍ସାଇଦାନ୍ନିଆ ଅଲେଙ୍ଗ୍ ଡୁଂପାଙ୍ଗ୍‌କେ ଆତ୍‌ଅରିଆ ଉଡ଼ିକ୍ଲିଗ୍ ରେମୁଆଁ ଜିସୁନେ ଡାଗ୍ରା ମୁଇଙ୍ଗ୍ କାନାକେ ଡୁଂପାଙ୍ଗ୍‌କେ ମେଇଙ୍ଗ୍ ଜିସୁକେ ପାର୍‍ତନା ଡିଙ୍ଗ୍ଆର୍‌କେ ଜେ ମେଁ କାନାକେ ଲିଗ୍ ବିଃଲେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_23","071_8_23","MRK","8","23","23","ଜିସୁ କାନା ରେମୁଆଁକେ ନ୍ତି ସାଃଚେ ମେଁନେ ଇନି ପାଦା ପାକା ୱା ଡୁଂୱେକେ । ମେଁ କାନାକେ ମୁଆଃନ୍ନିଆ ବିଃତୁର୍‌ ବିକେ । ଆରି ମେଁ ଆଡ଼ାତ୍ରା ନ୍ତି ବଚେ ଆମେକେ ସାଲିଆକୁକେ, “ନା ମେଃଡିଗ୍ କିକେୟା ନାଡିଂକ୍ଲେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK8_24","071_8_24","MRK","8","24","24","ଆତେନ୍‌ ରେମୁଆଁ ଆଡ଼ାତ୍ରା କେଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ରେମୁଆଁଇଂକେ ସାମୁଆଃ ୟାଣ୍ଡିଂକେ । ମେଇଙ୍ଗ୍ ପିତୁର୍ ପାକା ଅଲେଙ୍ଗ୍‌ନେ ସ୍ଲାଃ ସୁଗୁଆ ତ୍ନାଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_25","071_8_25","MRK","8","25","25","ଜିସୁ ଆରି ମୁଇଙ୍ଗ୍‌ ତର୍‍ କାନାନେ ମୁଆଃ ଆଡ଼ାତ୍ରା ନ୍ତି ବକେ । ମେଁନେ ମ୍ମୁଆଃ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ ୱେଲେଃଗେ ଆରି ମେଁ ସାପା ନିମାଣ୍ଡା ବାବ୍‌ରେ କିକେ ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_26","071_8_26","MRK","8","26","26","ଜିସୁ ଆମେକେ ଡୁଆ ବେ ବିଃଚେ ବାସଙ୍ଗ୍‌କେ, “ଇନି ବିତ୍ରେ ନା ଆରି ଅଃନା ଆୱେଗେ । ମାତର୍‌ ନାଁ ଡୁଆ ୱିଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_27","071_8_27","MRK","8","27","27","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆରି ମେଇଂନେ ସିସ୍ଇଂ କାଇସରିଆ ଫିଲିପ୍‌ପି ଏରିଆନେ ଇନି ପାକା ୱେଆର୍‌ଗେ । ଗାଲିନ୍ନିଆ ମେଁ ମେଁନେ ସିସ୍ଇଂକେ ସାଲିଆକୁକେ, “ନେଙ୍ଗ୍ ଜାଣ୍ଡେ ଡାଗ୍‌ଚେ ରେମୁଆଁଇଙ୍ଗ୍ ମେଃନେ ବାସଙ୍ଗ୍‌ଡିଂଆର୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK8_28","071_8_28","MRK","8","28","28","ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌କେ, “ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌ଡିଂକେ ମେଁ ଣ୍ଡିଆନ୍ନିଆ ଦିକ୍ୟା ବିଣ୍ଡ୍ରେ ଜହନ୍‌ । ବାରି ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌ଡିଂ ଏଲୀୟ ବାରି ଜା ଜା ବାସଙ୍ଗ୍‌ଡିଂକେ, ବାବବାଦିଇଂନେ ବାନ୍‌ ମୁଇଂଜା ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_29","071_8_29","MRK","8","29","29","ଜିସୁ ଆମେଇଂକେ ସାଲିଆକୁକେ, “ନେଙ୍ଗ୍ ଜାଣ୍ଡେ ଡାଗ୍‌ଚେ ପେ ମେଃନେ ବାସଙ୍ଗ୍‍ପେଡିଂକେ ?” ପିତର୍ ଉତର୍ ବିକେ, “ନାଁ ଡିଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ କିସ୍‌ଟ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_30","071_8_30","MRK","8","30","30","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେଇଂକେ ଡାଟାମ୍ ବାବ୍‌ରେ ଚେତ୍‌ନା ବିଃଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଜାଣ୍ଡେଃ ଡାଗ୍‌ଚେ ପେ ଆଜାକେ ମେଃଡିଗ୍ ଆବାସଙ୍ଗ୍‌ଗେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_31","071_8_31","MRK","8","31","31","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଆମେଇଂକେ ଗିଆନ୍ ବିଃନେ ଆରାମ୍‍ ଡିଙ୍ଗ୍‌କେ, “ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ଜବର୍‌ ଡଣ୍ଡ୍‌ କଷ୍ଟ ବାନେ ପଡ଼େଏ । ଦର୍ମ ନେତା ଆରି ଜିଉଦି ନେତା, ମ୍ନା ପୁଜାରି ଆରି ଦର୍ମସାସ୍ତ୍ରିଇଂ ଆମେକେ ବିସ୍‌ବାସ୍‌ ଆଡିଙ୍ଗ୍‌ଆର୍‌ ଣ୍ଡୁ । ଡିଲାଡିଗ୍ ଆମେକେ ବାଗୁଏ ବିଆର୍‌ଏ ଆରି ମେଁ ଗୁଏକ୍ନେ ଜିର୍‌ସି ଦିନା ବିତ୍‌ରେ ଆରି ତଃଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_32","071_8_32","MRK","8","32","32","ଆକେନ୍‌ ସାପା ସାମୁଆଁ ଜିସୁ ନିମାଣ୍ଡା ବାବ୍‌ରେ ସିସ୍‌‍ଇଂକେ ଆଃଦ୍ରିଗ୍‌ ବିଃକେ । ତେସାଃ ପିତର୍‌ ଆମେକେ ବିନ୍‌ ପାକା ୱାଡୁଙ୍ଗ୍‌ୱେଚେ ଗୁଆରେଚେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_33","071_8_33","MRK","8","33","33","ଜିସୁ ପ୍ଲା ପାକା ପୁଏଚେ ସିସ୍ଇଂ ଆଡ଼ାତ୍ରା କେଚେଃ ପିତର୍‌କେ ଆଃଦର୍ସେଚେ ବାସଙ୍ଗ୍‌କେ, “ସ‍ଏତାନ୍‌ ନେଙ୍ଗ୍ ବାନ୍ ସ୍ଲ ୱେଲା । ପେ ଇସ୍‌ପର୍‌ନେ ବିଚାର୍ ରକମ୍‌ ବିଚାର୍ ପେଡିଙ୍ଗ୍‍କେ ଣ୍ତୁ । ରେମୁଆଁଇଙ୍ଗ୍ ଡିରକମ୍ ବିଚାର୍ ଡିଙ୍ଗ୍ଆର୍‌ଡିଂକେ, ନାଁ ଦେତ୍‌ରକମ୍ ବାବେନାଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK8_34","071_8_34","MRK","8","34","34","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସାପା ରେମୁଆଁକେ ଡାଗ୍ରା ୱାକେ । ମେଁନେ ସିସ୍ଇଂ ଡିଗ୍ ଆତ୍ଅରିଆ ଲେଃଗେ । ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଜାଣ୍ଡେଃ ରେମୁଆଁ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ନେ ଚାଏଁଡିଂକେ ଆତେନ୍‌ ସାପା ଆନ୍ତାର୍‍ଚେ ନେଙ୍ଗ୍‍ସା ଦୁକ୍ ଆରି ଗୁଏଃନେ ସାଃଚେ ନେଙ୍ଗ୍ ପ୍ଲା ପାଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MK8_35","071_8_35","MRK","8","35","35","ଡାଗ୍ଲା ଜାଣ୍ଡେଃ ରେମୁଆଁ ନିଜର୍ ଜିବନ୍‍କେ ଆମ୍ବ୍ରନେ ଚାଏଁଏ, ମେଁ ଆତେନ୍‌ ଡିଂ ଆୟା ଣ୍ଡୁ । ଜାଣ୍ଡେ ରେମୁଆଁ ନେଙ୍ଗ୍‌ନ୍‌ସା ଆରି ନିମାଣ୍ଡା ସାମୁଆଁ ନ୍‍ସା ନିଜର୍‌ ଜିବନ୍‌କେ ବିଃଜଗ୍‍ତ୍ଲାଗ୍ଏ, ମେଁ ମେଁନେ ଜିବନ୍‌କେ କାଲାଆଃନ୍‍ସା ରକ୍ୟା ଆଃଡିଙ୍ଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK8_36","071_8_36","MRK","8","36","36","ବାରି ରେମୁଆଁ ଜଦି ସାପା ଦର୍ତନିକେ ଲାବ୍‌ ଡିଂଚେ ନିଜର୍‌ ଜିବନ୍‌କେ ବିଃଏ, ତେଲା ମେଃନେ ମେଁ ଲାବ୍‌ ଡିଂଏ ? ବାରି, ରେମୁଆଁ ମେଁ ଜିବନ୍‌ ବାଦୁଲ୍‌ ମେଃ ବିଃୟାଏ ? ");
INSERT INTO gaq_vpl VALUES ("MK8_37","071_8_37","MRK","8","37","37","ଡାଗ୍ଲା ଜାଣ୍ଡେ ରେମୁଆଁ ଉଡ଼ି ଡାବୁ ବିଲା ଡିଗ୍ ଆତେନ୍‌ ବାଦୁଲ୍‌ ନିଜେନେ ଜିବନ୍‌କେ ଆରି ମୁଇଂତର୍ ବା ପେୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK8_38","071_8_38","MRK","8","38","38","ଏନ୍‌ ଜାଣ୍ଡେ ଡିଗ୍ ଆକେନ୍ ଜୁଗ୍‌ନ୍ନିଆ ଅଡ଼ାରେଗ୍‌‍ ଆରି ପାପିଷ୍ଟ ରେମୁଆଁଇଂନେ ବାନ୍ ନେଙ୍ଗ୍‌ନେ ଆରି ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ବିସୟ୍‌ରେ ଗିଆସଃଏ, ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଉଡ଼ିବେଲା ପବିତ୍ର ଦୁତ୍‌ଇଂ ଏତେ ନିଜେନେ ଆବା ମ‍ଇମା ଏତେ ପାଙ୍ଗ୍‌ଏ, ଅଃତେନ୍‍ ବେଲା ମେଁ ଡିଗ୍ ଆତେନ୍‌ ବିସୟ୍‌ରେ ଗିଆସଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_1","071_9_1","MRK","9","1","1","ତେନ୍‌ଇଡ଼ିଂ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଇସ୍‌ପର୍‌ନେ ରାଜି ପରାକ୍ରମ ଡିଂଚେ ପାଂନେ ମାକେ ଜାକ ଆକ୍‌ଅରିଆ ତୁଆଁକ୍ନେ ରେମୁଆଁଇଂନେବାନ୍‌ ଉଡ଼ିରୁଆ ମେଃଡିଗ୍‌ ରକମ୍‌ ଗୁଏନେ ସାମୁଆଁ ପେବା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_2","071_9_2","MRK","9","2","2","ତୁର୍ ଦିନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ପିତର୍ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ଏଃତେ କୁଡ଼େଃଚେ ମୁଇଙ୍ଗ୍ ତିଆର୍ କଣ୍ଡା ଆଡ଼ାତ୍ରା ଡେଃଆର୍‌କେ । ଆତ୍‌ଡାଗ୍ରା ମେଁଇଙ୍ଗ୍‌ ଆଃ ଲେଃଆର୍‌ଗେ । ଆତ୍ ଅରିଆ ସିସ୍‌ଇଙ୍ଗ୍ ଜିସୁକେ କେକ୍ନେ ବେଲା ଜିସୁନେ ସାର୍ମୁଆଃ ବଦ୍ଲେ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK9_3","071_9_3","MRK","9","3","3","ଜିସୁନେ ପାଟାଇ ତୁଲୁଏ ରକମ୍‌ ତାର୍‌କିଗ୍ ତ୍ନାକେ । ଆତେନ୍‌ ତାର୍‌କିଗ୍ ଆରି ତୁଲୁଏ ଲେଃଗେ ଜେ ‍ଦର୍‌ତନିନେ ଜାଣ୍ଡେ ଡିଗ୍ ତୁଲୁଏ ଆଃଡିଙ୍ଗ୍ ଆୟାଆର୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK9_4","071_9_4","MRK","9","4","4","ବାରି, ମୋଶା ଆରି ଏଲୀୟ ଜିସୁ ଏତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌କ୍ନେ ସିସ୍‌ଇଂ କେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK9_5","071_9_5","MRK","9","5","5","ପିତର୍‍ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, “ଅ ମାପ୍‌ରୁ, ନେ ଜେ ଆକ୍‌ଅରିଆ ନେଲେଃକେ, ଆକେନ୍‌ ନିମାଣ୍ଡା; ନାନେ ଜଦି ଇକ୍‌ଚା ଡିଂଲା ନେଙ୍ଗ୍‌ ଆକ୍‌ଅରିଆ ଞ୍ଜିକ୍ଲିଗ୍‌ କୁଡ଼ିଆ ଣ୍ଡ୍ରାରେଏ, ନା ଆତ୍‌ଲା ମୁଇଂ, ମଶା ଆତ୍‌ଲା ମୁଇଂ ବାରି ଏଲିୟ ଆତ୍‌ଲା ମୁଇଂ । ");
INSERT INTO gaq_vpl VALUES ("MK9_6","071_9_6","MRK","9","6","6","ପିତର୍ ମ୍ୟାଃ ଆୟାକେ ଜେ ମେଁ ମେଃ ଉତର୍ ବିଃଏ ଡାଗ୍‌ଚେ ମ୍ୟାଃଆୟାକେ ଣ୍ଡୁ । ଡାଗ୍ଲା ମେଇଂ ମ୍ୱାୟା ସିସ୍‌ ଜବର୍ ବୁଟଲେଆର୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_7","071_9_7","MRK","9","7","7","ଇକୁଡ଼ା ତ୍ରିଗ୍‌ଡିଆ ଆମେଇଂକେ ଡା ବିକେ, ବାରି କେଲାପା, ଆତେନ୍‌‌ ତ୍ରିଗ୍‌ଡିଆବାନ୍ ଆକେନ୍‌ ସାମୁଆଁ ନାଂକେ, “ଏ ନେଙ୍ଗ୍‌ନେ ନିଜର୍‌ ଉଂଡେ ଆକ୍ମେଅରିଆ ନେଂନେ ଜାବର୍‌ ସାନ୍ତି ଲେକେ” ଆକ୍ମେନେ ବ୍ନାଲିର୍‌ ଅଁପା । ");
INSERT INTO gaq_vpl VALUES ("MK9_8","071_9_8","MRK","9","8","8","ଆରି ଆତେନ୍‌ ବେଲା ପିତର୍, ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ପିତୁର୍‌ କେଆର୍‌କେ ଡାଗ୍ଲା ଆତ୍‌ନିଆ ମେଇଂ ମେଙ୍ଗ୍‌ଏତେ ଜିସୁକେ ଆନ୍ତାର୍ଚେ ଆତ୍‌ଅରିଆ ବାରି ଆଜାକେ ଡିଗ୍ ଆକେଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK9_9","071_9_9","MRK","9","9","9","ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌ଇଂ କଣ୍ଡାବାନ୍‍ ଜାର୍‌ନେ ବେଲା ଆମେଇଂକେ ଆଦେସ୍‍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, ଜେ ମେଇଙ୍ଗ୍ କଣ୍ଡା ଆଡ଼ାତ୍ରା ମେଃ ମେଃନେ କେଆର୍‌କେ । ଆତ୍‌ତେ ଆଜାଡିଗ୍ ଆବାସଙ୍ଗ୍‌ପା ଡାଗ୍‌ଚେ ଆରି ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ଗୁଏଚେ ମ୍ବ୍ର ଜାକ ଉର୍‌ ଲାଃଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MK9_10","071_9_10","MRK","9","10","10","ଏନ୍‌ ସିସ୍‌‍ଇଂ ଜିସୁନେ ସାମୁଆଁ ମାନେଃଆର୍‌କେ ଆରି ମେଇଙ୍ଗ୍ ମେଃନେ କେଲେଃଆର୍‌ଗେ, ଆତେନ୍‌ ଆଜାଡିଗ୍ ଆବାସଙ୍ଗ୍ଆର୍‌କେ । ତେଲା ମେଇଙ୍ଗ୍ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ଆର୍‌କେ ଜେ ଗୁଏଚେ ମ୍ବ୍ରନେ ଅର୍‌ତ ମେଃନେ ? ");
INSERT INTO gaq_vpl VALUES ("MK9_11","071_9_11","MRK","9","11","11","ମେଇଙ୍ଗ୍ ଜିସୁକେ ସାଲ୍ୟାକୁଆର୍‌କେ, “ଦର୍ମସାସ୍ତ୍ରିଇଂ ମେଃ ନ୍‌ସା ବାସଙ୍ଗ୍‌ଡିଂକେ ଜେ ଏଲୀୟ ଡିଲାଡିଗ୍ ସେନୁଗ୍‍ ପାଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK9_12","071_9_12","MRK","9","12","12","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଅଁ; ମେଇଂ ସତ୍‌ ବାସଙ୍ଗ୍‌ଡିଂଆର୍‌କେ । ସାପା ସାମୁଆଁ ଆର୍ମେ ନ୍‍ସା ଡିଲାଡିଗ୍ ଏଲୀୟ ଆଃ ସେନୁଗ୍ ପାଙ୍ଗ୍ଏ । ମାତର୍‌ ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ବିସୟ୍‌ନେ ସାସ୍ତର୍‌ନ୍ନିଆ ମେଃ ନ୍‌ସା ଗୁଆର୍‌ବକେ ଜେ ମେଁ ମାଲେ କସ୍‌ଟ ବାଏ ଆରି ରେମୁଆଁଇଂ ଆମେକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK9_13","071_9_13","MRK","9","13","13","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ ଜେ ଏଲୀୟ ଏକ୍ରେ ପାଙ୍ଗ୍‌ଲେଃଗେ ଆରି ରେମୁଆଁଇଂ ମେଃନେ ଚାଏଁ ଡିଂଆର୍‌କେ, ମେଁ ଆଡ଼ାତ୍ରା ଦେତ୍‌ରକମ୍ ଦଦ୍ୟା‌ ବେବଆର୍‍ ଡିଂଆର୍‍ଏ । ମେଇଂ ଆଡ଼ାତ୍ରା ଦେକ୍‌ରକମ୍ ବେବ‍ଆର୍‌ ଡିଙ୍ଗ୍ଆର୍‌ଏ ଡାଗ୍‌ଚେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‌ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_14","071_9_14","MRK","9","14","14","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ପିତର୍, ଜାକୁବ୍‌, ଜହନ୍‌, ବିନ୍‌ନେ ସିସ୍ଇଂ ଡାଗ୍ରା ୱେକେ । ମେଇଂ କେଆର୍‌କେ ଜେ ଜବର୍ ରେମୁଆଁ ଆମେକେ ପିତୁର୍‌ ପୁଏକୁର୍‌ ଲେଃଆର୍‌କେ । ମେଁ ଏତେ ଦର୍ମ ଗୁରୁଇଂ ଅଡ଼୍‌କା‍ ଅଡ଼୍‌କି ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK9_15","071_9_15","MRK","9","15","15","ଅନାବେଲା ରେମୁଆଁଇଂ ଜିସୁକେ କେକେ ମେଇଙ୍ଗ୍ ଚମ୍‌କେ ୱେଏ ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଆମେକେ ସାର୍ଦା ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ମେଁ ପାକା ୱିର୍‌ ଡୁଂୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK9_16","071_9_16","MRK","9","16","16","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ନିଜର୍ ସିସ୍‌‌ଇଙ୍ଗ୍‌କେ ସାଲ୍ୟାକୁକେ, “ପେ ଦର୍ମ ସାସ୍ତର୍‌ଇଙ୍ଗ୍ ଏତେ ଆଣ୍ଡିନେ ସାମୁଆଁନ୍‌ସା ଅଡ଼୍‌କା ଅଡ଼୍‌କି ଡିଙ୍ଗ୍‌ପେଡିଂକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK9_17","071_9_17","MRK","9","17","17","ଗହଲି ବିତ୍ରେବାନ୍‌ ମୁଇଂ ରେମୁଆଁ ଉତର୍ ବିଃକେ, “ଏ ଗୁରୁ ନେଙ୍ଗ୍ ନେଉଙ୍ଗ୍‌କେ ନାଁ ଡାଗ୍ରା ଡୁଂପାଂନେବକେ । ମେଁନେ ଜିବନ୍‌ନ୍ନିଆ କନ୍ଦା ଗଲିଆ ଗା ଲେଃକେ,ଆତେନ୍‌‌ସା ବାଃଲିର୍‌ନେ ଆବିଃକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK9_18","071_9_18","MRK","9","18","18","ନେଉଂକେ ସାଃନେ ବେଲା ଗଡ଼େଅକେ ବୁନ୍ଦେ ଜଗ୍‍ତ୍ଲାଗ୍‍ ବିଃ ଡିଙ୍ଗ୍‌କେ । ଗଡ଼େଅ ତୁମୁଆବାନ୍ ଲିଡ଼ିଆଃ ଆଃତାର୍‌ଡିଂକେ ଆରି ମେଁ ଗିନି ଆଃଚାର୍ ଆଃଲେ ଡିଂକେ ଆରି ନ୍‌ସ୍ୱାରିଆଃ ୱେଡିଂକେ । ନେଙ୍ଗ୍‍ ନାନେ ସିସ୍ଇଂକେ ଆତେନ୍‌ ବୁତ୍‌ନେ ଆତ୍ମା ଆଃଆନ୍ତାର୍ ବିଃନ୍‌ସା କୁସାମୁତି ଣ୍ଡିଂକେ । ମାତର୍‌ ମେଇଙ୍ଗ୍ ଆମେକେ ଆଃଆନ୍ତାର୍ ଆୟାଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_19","071_9_19","MRK","9","19","19","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଆରେ ଅବିସ୍‌ବାସି ଆରି ଦଦ୍ୟା ଗାଲି ୱେଣ୍ଡ୍ରେ ବଂସଇଙ୍ଗ୍‌, ଉଃଡ଼ି ମୁଆଁ ନିଂ ପେ ଏତେ ନ୍ଲେଃଏ ? ଉଃଡ଼ି ମୁଆଁ ପେନେ ବେବ‍ଆର୍ ନ୍‌ସମ୍ବାଲେଏ ? ଆମେକେ ନିଂ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_20","071_9_20","MRK","9","20","20","ତେଲା ସିସ୍‌ଇଂ ଗଡ଼େଅକେ ଜିସୁ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଆର୍‌କେ । ବୁତ୍‌ ଆତ୍ମା ଜିସୁକେ କେକ୍ନେ ଦାପ୍ରେ ଗଡ଼େଅକେ ଅଚେତା ଆଃଡିଂଚେ ଆଲ ଜଗ୍‌ତ୍ଲାଗ୍‌ ବିଃକେ । ମେଁ ତୁମୁଆଃ ବାନ୍ ଲ୍‌ଲିଡ଼ିଆଃ ତାର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK9_21","071_9_21","MRK","9","21","21","ଜିସୁ ଗଡ଼େଅନେ ଆବାଡ଼େକେ ସାଲ୍ୟାକୁକେ, “ଉଃଡ଼ିସି ଡିଙ୍ଗ୍‌ଗେ ଗଡ଼େଅକେ ଦେକ୍‌ ଡିଙ୍ଗ୍‌ଲେଃଗେ ?” ମେଁ ବାଡ଼େ ବାସଙ୍ଗ୍‌କେ, “ଗଡ଼େଅକେଲା ବାନ୍ ଦେକ୍‌ ଡିଙ୍ଗ୍‌ଲାଃଏକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_22","071_9_22","MRK","9","22","22","“ବୁତ୍‌ ଆତ୍ମା ଆମେକେ ବାଗୁଏଃ ନ୍‌ସା ଉଡ଼ିତର୍ ଣ୍ଡିଆନ୍ନିଆ ଆରି ଉଡ଼ିତର୍ ସୁଆନ୍ନିଆ ଜଗ୍‌ତ୍ଲାଗ୍ ଡିଂଗେ । ନା ଜଦି ମେନ୍‌ସା ମେଁ ଡିଙ୍ଗ୍‌ ନାୟାଏ ତେଲା ନେ ଆଡ଼ାତ୍ରା ଲିବିସ ଡିଙ୍ଗ୍‌ଚେ ସାଃଆ ନାଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_23","071_9_23","MRK","9","23","23","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ମେଁ ନାବାସଙ୍ଗ୍‌କେ ! ପେ ଜଦି ପେୟାଏ ତେଲା ସାହା ଣ୍ଡିଙ୍ଗ୍‌ଏ । ବିସ୍‌ବାସ୍‌ ରେମୁଆଁନ୍‌ସା ସାପା କିଚି ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_24","071_9_24","MRK","9","24","24","ଗଡ଼େଅନେ ଆବାଡ଼େ କିରଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‌ନେ ବିସ୍‌ବାସ୍ ଲେଃକେ । ମାତର୍‌‌ ମାଲେ ଣ୍ତୁ । ନେଙ୍ଗ୍‌ନେ ବିସ୍‌ବାସ୍‌ ଆମ୍ନାନ୍‌ସା ଆନେଙ୍ଗ୍‌ ସାଇଜ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_25","071_9_25","MRK","9","25","25","ଜିସୁ କେକେ ଜେ ଆକେନ୍‌ ଗଟ୍‌ନାନ୍‌ସା ରେମୁଆଁ ମେଁଇଙ୍ଗ୍‌ ଡାଗ୍ରା ୱିର୍ ଡୁଂପାଙ୍ଗ୍‌ଡିଂକେ । ତେଲା ମେଁ ବୁତ୍‌କେ ଦାକା ବିଃଚେ ବାସଙ୍ଗ୍‌କେ “ଏ ବୁତ୍‌ ନା ଗଡ଼େଅକେ କନ୍ଦା ଆରି ବ‍ଏରା ଆଡିଙ୍ଗ୍ ନାବକେ । ନେଙ୍ଗ୍ ଆନାକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଂକେ ଗଡ଼େଅନେ ଜିବନ୍‌ବାନ୍ ତାର୍‌ଚେ ଡଲା । କ୍ମେନେ ଜିବନ୍ ବିତ୍ରେ ଅଃନାଡିଗ୍ ଆରି ନ୍ନାଗା ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_26","071_9_26","MRK","9","26","26","ବୁତ୍‌ଆତ୍ମା କିରଚେ ଗଡ଼େଅକେ ସାଃଚେ ତୁବନ୍ନିଆ ଜଗ୍‌ତ୍ଲିଗ୍‌ ବିଃକେ । ଆରି ମୁଇଙ୍ଗ୍‌ତର୍ ଗଡ଼େଅକେ ତୁବନ୍ନିଆ ୱାଃଲଃ ବିଃଚେ ବୁତ୍‌ ଆତ୍ମା ମେଁ ଗାଗ୍‌ଡ଼େବାନ୍ ତାର୍‌ ଡକେ । ଆକେନ୍ ଗଡ଼େଅ ଗୁଏଃକେ ରକମ୍ ଡିଂୱେକେ । ଜବର୍‌ ରେମୁଆଁ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ମେଁ ଗୁଏଃୱେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_27","071_9_27","MRK","9","27","27","ଡାଗ୍‌ଲା ଜିସୁ ଗଡ଼େଅନେ ନ୍ତି ସାଃଚେ ଆମେକେ ଆତଡ଼ିଆଚେ ଆଃତୁଆଁ ବିଃକେ । ଆତେନ୍‌ ଗଡ଼େଅ ତୁଆଁକେ । ");
INSERT INTO gaq_vpl VALUES ("MK9_28","071_9_28","MRK","9","28","28","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଡୁଆ ବିତ୍ରେ ୱେକେ । ମାତର୍‌‌ ମେଇଂନେ ସିସ୍ଇଂ ମେଁ ଏତେ ଆତ୍ଅରିଆ ଲେଃଆର୍‌ଗେ । ମେଇଙ୍ଗ୍ ଆମେଇଂକେ ସାଲ୍ୟାକୁଆର୍‌କେ, “ନେ ମେଃନ୍‌ସା ଆତେନ୍‌ ବୁତ୍‌କେ ଆଃଆନ୍ତାର୍ ନେୟାକେ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MK9_29","071_9_29","MRK","9","29","29","ଆକେନ୍ ଅଁଚେ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଦେକ୍‌ରକମ୍‌ ବୁତ୍‌ ଆତ୍ମାକେ ପାର୍‌ତନା ବାନ୍ ଆଃଆନ୍ତାର୍ ନେଃୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_30","071_9_30","MRK","9","30","30","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଆତେନ୍‌ ଜାଗା ଆନ୍ତାର୍‌ଚେ ଡଆର୍‌କେ । ମେଁଇଙ୍ଗ୍‌ ଗାଲିଲୀ ବିଃଚେ ୱେଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଆଣ୍ଡି ଲେଃଆର୍‌କେ ଆତେନ୍‌ ସାମୁଆଁ ରେମୁଆଁ ମ୍ୟାଲେ ଡାଗ୍‌ଚେ ଜିସୁ ଚାଏଁ ଆଡିଙ୍ଗ୍‌ଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK9_31","071_9_31","MRK","9","31","31","ତେସା ମେଁ ନିଜର୍‌ ସିସ୍ଇଂକେ ମୁଇଂ ବିନ୍ ସାମୁଆଁ ବିଃନ୍‌ସା ଏତେଡିଂଗେ । ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ରେମୁଆଁଇଙ୍ଗ୍‌ନେ ନ୍ତିନ୍ନିଆ ସର୍‍ପେ ବିଃଡିଂକେ । ମେଇଂ ଆମେକେ ବାଗୁଏଃ ବିଏ । ଡାଗ୍ଲା ଗୁଏନେ ଜିର୍‌ସି ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଗୁଏଃଚେ ଆରି ମୁଇଂତର୍ ମ୍ୱ୍ରଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_32","071_9_32","MRK","9","32","32","ଜିସୁ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କ୍ନେ ଅର୍‌ତ ସିସ୍‌ଇଂ ବୁଜେ ଆୟାଆର୍‌କେ ଣ୍ତୁ । ମେଇଙ୍ଗ୍ ଆମେକେ ଆକେନ୍ ଅର୍‌ତ ସାଲିଆକୁଚେ ବୁଜେନ୍‍ସା ବୁଟଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK9_33","071_9_33","MRK","9","33","33","ତେନ୍ଇଡ଼ିଂ ଜିସୁ ଆରି ମେଇଙ୍ଗ୍‌ନେ ସିସ୍‌ଇଂ କର୍ପନାହୁମନ୍ନିଆ ପାଙ୍ଗ୍ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ମୁଇଂ ଡୁଆ ବିତ୍ରେ ୱେଆର୍‌ଗେ । ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍‌‌ଇଂକେ ସାଲ୍ୟାକୁକେ, “ଏଃକେ ଗାଲିନ୍ନିଆ ପାଙ୍ଗ୍‌ନେ ବେଲା ମେଃ ସାମୁଆଁକେ ପେଇଙ୍ଗ୍ ଅଡ଼୍‌କା‍ ଅଡ଼୍‌କି ଡିଙ୍ଗ୍‌ପେଡିଂଗେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK9_34","071_9_34","MRK","9","34","34","ମାତର୍‌ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ବୁଙ୍ଗ୍‌ ଲେଃଆର୍‌ଗେ । ଡାଗ୍ଲା ମେଇଙ୍ଗ୍ ଗାଲିନ୍ନିଆ ଅଡ଼୍‌କା‍ ଅଡ଼୍‌କି ଡିଙ୍ଗ୍‌ଡିଂଆର୍‌ଗେ ଜେ ମେଇଂନେ ବିତ୍ରେ ସାପା ବାନ୍ ମ୍ନା ଜାଣ୍ଡେ ? ");
INSERT INTO gaq_vpl VALUES ("MK9_35","071_9_35","MRK","9","35","35","ଜିସୁ କଚେଃ ଆରି ଗମ୍ୱାର୍ ରେମୁଆଁ ପ୍ରେରିତ୍‌କେ ଡାଗ୍ରା ୱାକେ । ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ସାପା ବାନ୍ ଜାଣ୍ଡେ ମ୍ନା ଡିଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଡିଂଏ, ତେଲା ମେଁ ସାପାରେବାନ୍‍ ମ୍ନା ମନେ ଡିଙ୍ଗ୍‌ଚେ ଆରି ସାପା ମାନ୍ଦାକେ ସେବା ଡିଙ୍ଗ୍‌ଲେଃ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_36","071_9_36","MRK","9","36","36","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମୁଇଂ ଡାଆଁନେ ଗଡ଼େଅକେ ଡୁଂୱେକେ । ମେଁଇଙ୍ଗ୍‌ନେ ସେନୁଗ୍ ଆଃତୁଆଁ ବିଃକେ । ଆତେନ୍‌ ଗଡ଼େଅକେ ବୁଲୁନ୍ନିଆ ଡୁଂପାଙ୍ଗ୍‌ଚେ ମେଁ ବାଃଲିର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK9_37","071_9_37","MRK","9","37","37","“ନେଙ୍ଗ୍ ମ୍ନିରେ ଆଣ୍ଡିନେ ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ଗଡ଼େଅକେ ଦେକ୍‌ରକମ୍ କଃଏ, ମେଁ ନେଙ୍ଗ୍‌ନେ ଆବାକେ କଃଏ । ଆରି ଜାଣ୍ଡେ ଆନେଙ୍ଗ୍‌କେ ଆକଃ ଣ୍ଡୁ, ମେଁ ବେବକ୍ନେ ଆବାକେ ଡିଗ୍‌ ଆକଃ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_38","071_9_38","MRK","9","38","38","ଜହନ୍‌ ଜିସୁକେ ବାଲିର୍‌କେ, “ଅ ଗୁରୁ ନାଁ ମ୍ନି ସାଃଚେ ମୁଇଂ ରେମୁଆଁ ଗଡ଼େଅବାନ୍ ବୁତ୍‌ଆତ୍ମାଇଙ୍ଗ୍ ଆଃଆନ୍ତାର୍ ଡିଂକ୍ନେ ମୁଇଂ ରେମୁଆଁକେ ନେ ସାପାରେ ନେକେକେ । ନେ ଆମେକେ ମନା ନେଡିଂକେ, ଡାଗ୍ଲା ମେଁ ନେ ବିତ୍ରେନେ ରେମୁଆଁ ଆଲେଃଗେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_39","071_9_39","MRK","9","39","39","ମାତର୍‌ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଆମେକେ ମନା ଆଡିଙ୍ଗେପା । ଡାଗ୍ଲା ଆଣ୍ଡିନେ ରେମୁଆଁ ନେଙ୍ଗ୍ ମ୍ନିରେ ବପୁରେ ଏତେ କାମ୍ ଡିଙ୍ଗ୍ ୟାଏ ମେଁ ନେଙ୍ଗ୍ ମ୍ନିରେ ଆରି ଦଦ୍ୟା ସାମୁଆଁ ବାଲିର୍ ଆୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_40","071_9_40","MRK","9","40","40","ଜା ନେନେ ସତ୍ରୁ ଣ୍ଡୁ, ମେଁ ନେନେ ରେମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("MK9_41","071_9_41","MRK","9","41","41","ନେଙ୍ଗ୍‌ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, “ପେଇଙ୍ଗ୍ କିସ୍‌ଟନେ ରେମୁଆଁ ଡାଗ୍‌ଚେ ଜଦି ଜାଣ୍ଡେ ଆପେକେ ଗିନାନ୍ନିଆ ଣ୍ଡିଆଃ ଉଗ୍‍ନେ ବିଏ । ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ମେଁ ଡି ବାବ୍‌ରେ ଡିଗ୍ ନିଜର୍ ପୁରୁସ୍‌କାର୍ ଆଆରେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK9_42","071_9_42","MRK","9","42","42","ଜିସୁ ଆରି ବାସଙ୍ଗ୍‌କେ, “ଆରି ଜାଣ୍ଡେ ଜା ଡିଙ୍ଗ୍‌ଲେଃ ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍ ବେଲା ଆକେନ୍ ଗଡ଼େଅଇଂନେ ବିତ୍ରେ ମୁଇଙ୍ଗ୍‌ଜାକେ ପାପ୍ ଆଃଡିଙ୍ଗ୍‌ଏ, ମେଁନେ ଲୁଗଃନ୍ନିଆ ମୁଇଙ୍ଗ୍‌ ମ୍ନା ବ୍ରି ଗାଗ୍‌ଚେ ଆମେକେ କେଣ୍ଡିଆନ୍ନିଆ ଜଗ୍‌ତ୍ଲାଗ୍ ବିଃଲା ମେଁନ୍‌ସା ନିମାଣ୍ତା ପାଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("MK9_43","071_9_43","MRK","9","43","43","ଜଦି ନାଁନେ ନ୍ତି ଆନାକେ ପାପ୍ ଆଃଡିଙ୍ଗ୍‌ଏ, ତେଲା ତେନ୍‌ ନ୍ତିକେ ସିଃତଗ୍ ବିଃପା । ମ୍ୱାର୍‌ ନ୍ତି ସାଃଚେ ନର୍‍କେ ଆରି କାଲାନେ ଜୁଗ୍‌ ସାଃଚେ ଡୁଆମ୍ୟାକ୍ନେ ସୁଆ ଡାଗ୍ରା ୱେନେ ବାଟା ଣ୍ଡୁଲା ଟୁଟା ଡିଙ୍ଗ୍‌ଚେ ମାଡାନେ ଜିବନ୍‌ ବାନେ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("MK9_44","071_9_44","MRK","9","44","44","ରେମୁଆଁକେ ଚଙ୍ଗ୍‌ମ୍ୟାକ୍ନେ ନର୍କେନେ ବଃଉଂ ଅଃନାଡିଗ୍ ଆଗୁଏ ଣ୍ଡୁ ଆରି ସୁଆ ଡିଗ୍ ଅଃନା ଆଲିଗ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK9_45","071_9_45","MRK","9","45","45","ଜଦି ନାଁନେ ଞ୍ଚ ଆନାକେ ପାପ୍‌ ଆଃଡିଙ୍ଗ୍‌ଏ, ତେଲା ଆତେନ୍‌‌ ଞ୍ଚକେ ସିଃତଗ୍ ବିଃପା । ମ୍ୱାର୍‌ ଞ୍ଚ ଲେଃଚେ ନରକ୍‌ନ୍ନିଆ ପେ ଲଃନେ ବାଟା ଚଟା ଡିଙ୍ଗ୍‌ଚେ ମାଡାନେ ଜିବନ୍‌ ବାନେ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("MK9_46","071_9_46","MRK","9","46","46","ରେମୁଆଁକେ ଚଙ୍ଗ୍‌ମ୍ୟାକ୍ନେ ନର୍କେନେ ବୁବଃ ଅଃନା ଆଗୁଏଃ ଣ୍ଡୁ ଆରି ନର୍କେନେ ସୁଆ ଅଃନା ଆଲିଗ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK9_47","071_9_47","MRK","9","47","47","ଜଦି ନାନେ ମୁଆଃ ଆନାକେ ପାପ୍ ଆଃଡିଙ୍ଗ୍ଏ, ତେଲା ଆତେନ୍‌‌କେ ତଃ ଜଗ୍‌ତ୍ଲାଗ୍ ବିଃ । ମ୍ବାକ୍ଲିଗ୍ ମୁଆଃ ଲେଃଚେ ନର୍କେନ୍ନିଆ ନାଁ ଲଃନେ ବାଟା ନାଁନେ ମୁଇଂ ମ୍ମୁଆଃ ଲେଃଚେ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ୱେନେ ନିମାଣ୍ତା । ");
INSERT INTO gaq_vpl VALUES ("MK9_48","071_9_48","MRK","9","48","48","ରେମୁଆଁକେ ଚଙ୍ଗ୍‌ମ୍ୟାକ୍ନେ ନର୍କେନେ ବଃଉଂଇଂ ଅଃନା ଆଗୁଏ ଣ୍ତୁ ଆରି ନର୍କେନେ ସୁଆ ଅଃନାଡିଗ୍ ଆଲିଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK9_49","071_9_49","MRK","9","49","49","ତେସାଃ ସାପା ରେମୁଆଁ ସୁଆନ୍ନିଆ ଡଣ୍ଡ୍‌ ବା’ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK9_50","071_9_50","MRK","9","50","50","ବିତିଗ୍ ନିମାଣ୍ଡା ଜିନିସ୍, ମାତର୍‌ ବିତିଗ୍ ଜଦି ମେଁନେ ବିସେଃବିଗ୍ ଆନ୍ତାର୍‌ଏ, ଆମେକେ ଆରି ମୁଇଂତର୍ ଡିରକମ୍ ବିସେଃବିଗ୍‌ ଆଃଡିଙ୍ଗ୍‌ଡିଂଏ ? ପେ ବିତିଗ୍ ସୁଗା ନିମାଣ୍ତା ଗୁନ୍‌ରେ ବର୍‌ତି ଡିଙ୍ଗ୍‌ପା । ସାପା ମାନ୍ଦା କୁଡ଼େଚେ ନିମାଣ୍ତା ଲାଃଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_1","071_10_1","MRK","10","1","1","ଜିସୁ ଆତେନ୍‌ ଜାଗାକେ ଆନ୍ତାର୍ ବିଃଚେ ମେଁ ଜିଉଦା ପାକାନେ ଜର୍ଦନ୍‌ ଲଣ୍ଡିଆଃ ଇନୁମେତା ୱେଆର୍‌କେ । ଆରି ଜବର୍‌ ରେମୁଆଁ ମେଁ ଡାଗ୍ରା ରିସିଙ୍ଗ୍ ଆର୍‌କେ । କାଲାଆଃ ରକମ୍ ଗିଆନ୍‍ ବିଃନେ ସୁଗୁଆ ଜିସୁ ରେମୁଆଁଇଂକେ ଗ୍ୟାନ୍ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_2","071_10_2","MRK","10","2","2","ଉଡ଼ିକ୍ଲିଗ୍ ଫାରୁଶୀ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ପରିକ୍ୟା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆମେକେ ସାଲ୍ୟାଃକୁଆର୍‌କେ, “ନିଜେନେ ସେଲାମ୍ବୁଏଃକେ ଆନ୍ତାର୍‌ବିଃନେ ମେଁନେ ଆଣ୍ଡାଣ୍ଡେ ଇସାବ୍‌ରେ ଟିକ୍‌ କି ?” ");
INSERT INTO gaq_vpl VALUES ("MK10_3","071_10_3","MRK","10","3","3","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ମୋଶା ଆପେକେ ମେଃନେ ଆଦେସ୍‌ ବିଃବକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK10_4","071_10_4","MRK","10","4","4","ମେଇଂ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଆନ୍ତାର୍‌ନେ ଉଲିଆଃ ଗୁଆର୍‌ଚେ ସେଲାମ୍ବୁଏଃକେ ଆନ୍ତାର୍ ବିଃନେ ମୋଶା ବାସଙ୍ଗ୍‌ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_5","071_10_5","MRK","10","5","5","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେନେ ଜିବନ୍‌ନେ ଦୁକ୍ କେଚେ ମୋଶା ପେଇଙ୍ଗ୍‌ନ୍‌ସା ଆକେନ୍‌ ଆଦେସ୍‌ ଗୁଆର୍‌ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_6","071_10_6","MRK","10","6","6","ଡାଗ୍ଲା ସାସ୍ତ୍ରନିଆ ଡିରକମ୍ ବାସଙ୍ଗ୍‌ବକେ ପର୍‌ମେସର୍‌ ଉଡ଼ିବେଲା ଦର୍‌ତନିକେ ଆଃରେକେ ମେଁ ରେମୁଆଁକେ ଙ୍ଗିର୍‌ବଏ ଆରି ସେଲାମ୍ବୁଏ ଆଡିଂଚେ ଆଃରେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_7","071_10_7","MRK","10","7","7","ଆତେନ୍‌ ନ୍‌ସା ମୁଇଙ୍ଗ୍ ଙ୍ଗିର୍‌ବ‍ଏଃ ନିଜେନେ ଇୟାଙ୍ଗ୍ ଆବାକେ ଆନ୍ତାର୍‌ଚେ ନିଜେନେ ସେଲାମ୍ବୁଏ ଏତେ କୁଡ଼େଃଚେ ଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MK10_8","071_10_8","MRK","10","8","8","ତେସା ମେଇଙ୍ଗ୍ ଆରି ମ୍ୱାୟା ଣ୍ତୁ, ମାତର୍‌ ମୁଇଂ ଗାଗ୍‌ଡ଼େ ଡିଙ୍ଗ୍ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK10_9","071_10_9","MRK","10","9","9","ଇସ୍‌ପର୍ ଜଦି ଆକେନ୍ ମ୍ୱାୟାକେ ମୁଇଙ୍ଗ୍‌ନ୍ନିଆ ଆଃଡିଙ୍ଗ୍ ବକେ ଆମେଇଂକେ ଜାଣ୍ଡେ ଡିଗ୍ ବିନ୍ ଆରାଡିଙ୍ଗ୍‍ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_10","071_10_10","MRK","10","10","10","ଇଡ଼ିଙ୍ଗ୍ ସିସ୍ଇଂ ଡୁଆ ଅରିଆ ଜିସୁକେ ଆରି ମୁଇଙ୍ଗ୍ ତର୍ ଆନ୍ତାର୍‌ନେ ବିସୟ୍ ସାଲ୍ୟାକୁ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_11","071_10_11","MRK","10","11","11","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଆଣ୍ତିନେ ଙ୍ଗିର୍‌ବଏ ନିଜର୍ ସେଲାମ୍ବୁଏଃକେ ଆନ୍ତାର୍‌ଚେ ବିନ୍ ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୁଏଃକେ ବିଏ ଡିଙ୍ଗ୍‌ଏ, ଆତେନ୍‌ ଙ୍ଗିର୍‌ବଏ ମେଁନେ ସେଲାମ୍ବୁଏ ଆଡ଼ାତ୍ରା ଅଡ଼ାରେଗ୍‌ ପାପ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK10_12","071_10_12","MRK","10","12","12","ଡାଗ୍‌ଲା ମୁଇଙ୍ଗ୍‌ ସେଲାମ୍ବୁଏ ନିଜର୍‌ ଆଣ୍ଡାଣ୍ତେକେ ଆନ୍ତାର୍‌ଚେ ଆରି ବିନ୍ ଙ୍ଗିର୍‌ବଏଃକେ ବିଏ ଡିଙ୍ଗ୍‌ଏ, ତେଲା ମେଁ ଡିଗ୍ ଅଡ଼ାରେଗ୍‌ ପାପ୍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_13","071_10_13","MRK","10","13","13","ଆରି ରେମୁଆଁଇଂ ଜିସୁ ଡାଗ୍ରା ମେଇଙ୍ଗ୍‌ନେ ଡାଆଁ ଗଡ଼େଇଂକେ ଡୁଂପାଂଆର୍‌କେ ଡିରକମ୍ କି ଜିସୁ ଗଡ଼େଇଂକେ ନ୍ତିବଚେ ଆସିର୍ବାଦ୍ ଡିଙ୍ଗ୍‌ଏ । ମାତର୍‌‌ ଜିସୁନେ ସିସ୍ଇଂ ରେମୁଆଁଇଂକେ ଦମକ୍‌ ବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_14","071_10_14","MRK","10","14","14","ଆକେନ୍ କେଚେ ଜିସୁ ଜବର୍ ରିସାଡିଂକେ । ଜିସୁ ସିସ୍‌‌ଇଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ଡାଆଁ ଗଡ଼େଇଂକେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍ ଆର୍‌ଲେ ଆମେଇଂକେ ମନା ଆଡିଙ୍ଗ୍‌ପା । ଡାଗ୍ଲା ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ଏନ୍ ଗଡ଼େଇଂ ରକମ୍ ଦରମ୍‌ ରେମୁଆଁଇଙ୍ଗ୍ ରକମ୍‌ କିତଂଇନି ଗାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK10_15","071_10_15","MRK","10","15","15","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ ଜାଣ୍ଡେ ଡିଗ୍ ଡାଆଁନେ ଗଡ଼େଅ ରକମ୍ ଇସ୍‌ପର୍‌ନେ ରାଜିକେ ଇକ୍‌ଚା ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ମେଁ ଡିରକମ୍ ଡିଂଚେ ଡିଗ୍ ୱେଚା ଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK10_16","071_10_16","MRK","10","16","16","ତେନ୍ଇଡ଼ିଂ ଜିସୁ ଗଡ଼େଇଂକେ ଜେବାନ୍ନିଆ କଃଚେ । ମେଁ ମେଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ନ୍ତି ବଚେ ଆସିର୍ବାଦ୍ ବିଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_17","071_10_17","MRK","10","17","17","ଜିସୁ ୱେଡିଂକ୍ନେ ବେଲା ମୁଇଙ୍ଗ୍‌ ରେମୁଆଁ ୱିର୍ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଚେ ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ ଆରି ଜିସୁନେ ସେନୁଗ୍ ଡେଙ୍ଗାଚେ କକେ । ମେଁ ସାଲ୍ୟାକୁକେ, “ଅ ସତ୍‌ ଗୁରୁ ମାଡାନେ ଜିବନ୍ ବାନ୍‌ସା ନେଙ୍ଗ୍ ମେଃ ଣ୍ଡିଂଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK10_18","071_10_18","MRK","10","18","18","ଜିସୁ ଉତର୍ ବିକେ, “ଆନେଙ୍ଗ୍ ନିମାନ୍‍ ଡାଗ୍‌ଚେ ମେସା ବାସଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ? ଇସ୍‌ପର୍‌କେ ଆନ୍ତାର୍ ବିଃଲା ବିନ୍‌ ଜାଣ୍ଡେ ସତ୍ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_19","071_10_19","MRK","10","19","19","ପେ ନିଅମ୍ଇଂ ମ୍ୟାଃପେଲେଃକେ । ରେମୁଆଁ ଆବାଗୁଏଃଗ୍‌ପା, ମିଚ୍‌ ସାକି ଆବିଃଗ୍‌ପା, ଆନାଲେଗେପା, ନିଜର୍ ଆବା ଇୟାଙ୍ଗ୍‌କେ ସନ୍‌ମାନ୍ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("MK10_20","071_10_20","MRK","10","20","20","ମେଁ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, “ଅ ଗୁରୁ ନେଙ୍ଗ୍ ଚିର୍ଲାଃଅବାନ୍ ଆକେନ୍ ସାପା ସାମୁଆଁ ମାନେଃଚେ ପାଙ୍ଗ୍‌ଣ୍ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_21","071_10_21","MRK","10","21","21","ଜିସୁ ଆମେକେ ଆଲାଦ୍ ଡିଂକେ । ଆରି ମେଁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ନାଁନେ ମୁଇଙ୍ଗ୍ ସାମୁଆଁ ଗଣ୍ତା ଲେଃକେ । ନାଁ ୱେଲା ମେଃନେ ନାଁନ୍ନିଆ ଲେଃକେ । ଆତେନ୍‌ ସାପା ସ ବିଃଚେ ଗରିବ୍‌ଇଂକେ ଦାନ୍ ବିଃ । ନାଁ କିତଂଇନିନେ ଦନ୍ ନାବାଏ । ଇଡ଼ିଙ୍ଗ୍ ନେଙ୍ଗ୍ ପ୍ଲା ନାଁ ପାଙ୍ଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_22","071_10_22","MRK","10","22","22","ଜିସୁନେ ସାମୁଆଁ ଅଁଚେ ଆତେନ୍‌‌ ରେମୁଆଁନେ ମନ୍‌ ଦୁକ୍ ଡିଙ୍ଗ୍ ୱେକେ । ମେଁ ମନ୍‌ ଦୁକ୍ ଡିଂଚେ ୱିଗ୍‌କେ, ଡାଗ୍ଲା ମେଁନେ ଜବର୍‌ ସମ୍ପତି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_23","071_10_23","MRK","10","23","23","ଜିସୁ ପିତୁର୍‌ ପାକା କେଚେ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଜାନେ ଦନ୍ ଲେଃକେ, ମେଇଙ୍ଗ୍‌ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ୱେଚାନେ ଜବର୍‌ କଷ୍ଟ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_24","071_10_24","MRK","10","24","24","ଜିସୁନେ ସାମୁଆଁ ଅଁଚେ ସିସ୍ଇଂ କାବା ଡିଙ୍ଗ୍‌ୱେଆର୍‌ଗେ ଡାଗ୍‌ଲା ଜିସୁ ଆମେଇଂକେ ଆରି ବାସଙ୍ଗ୍‌କେ, “ଏ ନେଙ୍ଗ୍‌ନେ ଗଡ଼େଇଂ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ଗାନ୍‍ସା ସତେଆ ଉଡ଼ି କଷ୍ଟ । ");
INSERT INTO gaq_vpl VALUES ("MK10_25","071_10_25","MRK","10","25","25","ମୁଇଂ ସାଉକାର୍ ରେମୁଆଁ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ କସ୍ଟରେ ୱେଚାନେ ବାଟା ଉଟ୍‌ ମୁଇଂ ସୁଜି ପ୍ଲଗ୍‌ନ୍ନିଆ ଚିଙ୍ଗ୍ଲେ ୱେନେ ସ‍ଅଜ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_26","071_10_26","MRK","10","26","26","ମେଇଙ୍ଗ୍‌ ଆରି କାବା ଡିଙ୍ଗ୍‌ୱେଆର୍‌କେ । ମେଇଙ୍ଗ୍ ମେଇଙ୍ଗ୍‌ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ଆର୍‌କେ “ତେଲା ଜାଣ୍ଡେ ଉଦାର୍ ବା ୟାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK10_27","071_10_27","MRK","10","27","27","ଜିସୁ ଆମେଇଂକେ କେଚେ ବାସଙ୍ଗ୍‌କେ, “ଏନ୍ ରେମୁଆଁଇଂବାନ୍‌ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ଡାଗ୍‌ଲା ଇସ୍‌ପର୍‌ନେ ବାନ୍ ସାପା କିଚି ଡିଙ୍ଗ୍ ୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_28","071_10_28","MRK","10","28","28","ପିତର୍ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, “ନାଁ ପ୍ଲା ପାଙ୍ଗ୍‌ନ୍‍ସା ନେଁ ସାପାରେ ସାପା ଆନ୍ତାର୍ ନେବିଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_29","071_10_29","MRK","10","29","29","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‌ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଆଣ୍ତିନେ ରେମୁଆଁ ନେଙ୍ଗ୍‍ସା ଆରି ନିମାଣ୍ତା କବର୍ ବାଲିର୍‍ନ୍‌ସା ଡୁଆସାରା ବୟାଁ ତନା ଆବା ଇୟାଙ୍ଗ୍ ଗୋ ଗିସିଆ ଆରି ଲିଜ ବ୍ରି ଆନ୍ତାର୍ ବିୟାଏ ");
INSERT INTO gaq_vpl VALUES ("MK10_30","071_10_30","MRK","10","30","30","ମେଁ ଡିଲାଡିଗ୍ ନିଜେ ଆନ୍ତାର୍‌ବକ୍ନେ ଜିନିସ୍ ବାନ୍ ମାଲ୍‌କୁଡ଼ି ଗୁନ୍‌ ଜବର୍‌ ଆକେନ୍ କାଲେ ବାଏ । ମେଁ ଜବର୍‌ ଡୁଆ, ବୟାଁ, ତନା, ଇୟାଙ୍ଗ୍, ଗୋ ଗିସିଆଃ ଆରି ଲିଜବ୍ରି ବଏ । ମାତର୍‌‌ ମେଁ କଷ୍ଟ, ନିନ୍ଦା, ଅପମାନ୍ ଆକେନ୍ ସାପା ବାଏ । ଡାଗ୍ଲା ଇଡ଼ିଙ୍ଗ୍ ଜୁଗ୍‌ରେ ମେଁ ମାଡାନେ ଜିବନ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MK10_31","071_10_31","MRK","10","31","31","ଏବେ ଜାଣ୍ଡେ ସିସେ ଲେଃଆର୍‌କେ, ମେଁଇଙ୍ଗ୍‌ ଇଡ଼ିଙ୍ଗ୍‌ରେ ପ୍ଲାଃ ଡିଂଆର୍‌ଏ ଆରି ଜାଣ୍ଡେଇଂ ପ୍ଲାଃ ଲେଃଆର୍‌କେ; ମେଇଙ୍ଗ୍‌ ଇଡ଼ିଙ୍ଗ୍‌ରେ ସିସେ ଡିଂଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_32","071_10_32","MRK","10","32","32","ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌ଇଂ ଯିରୂଶାଲମ୍‌ ଗାଲି ପାକା ୱେଆର୍‌କେ । ଜିସୁ ମେଁଇଙ୍ଗ୍‌ନେ ସେନୁଗ୍ ସେନୁଗ୍ ୱେଡିଙ୍ଗ୍‍ଗେ । ମେଁନେ ସିସ୍‌ଇଂ କାବା ଡିଙ୍ଗ୍‍ୱେଆର୍‌କେ । ଡାଗ୍‌ଲା ମେଁନେ ପ୍ଲା ୱେଡିଂକ୍ନେ ରେମୁଆଁଇଂ ସାପାରେ ବୁଟମେଗ୍‌ ଆର୍‌କେ । ଜିସୁ ମେଁନେ ଗମ୍ବାର୍ କ୍ଲିଗ୍‍ ପ୍ରେରିତ୍‌ଇଂକେ ବିନେ ୱାଚେ ଯିରୁଶାଲାମନ୍ନିଆ ମେଃନେ ସାପା ଗଟେନେ ୱେଡିଙ୍ଗ୍‌କେ, ଆତେନ୍‌ ସାପା ଆମେଇଂକେ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_33","071_10_33","MRK","10","33","33","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “କେଲାପା, ନେଁ ସାପାରେ ଯିରୂଶାଲାମ୍‌ନ୍ନିଆ ୱେନେଡିଙ୍ଗ୍‌କେ । ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ମ୍ନା ପୁଜାରି ଆରି ଦର୍ମସାସ୍ତ୍ରିଇଂନେ ନ୍ତିନ୍ନିଆ ବିଜଗ୍‌ତ୍ଲିଗ୍‌ଏ । ଆରି ମେଇଙ୍ଗ୍‌ ଆମେକେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଚେ ବାଗୁଏନେ ଡଣ୍ଡ୍ ବିନ୍‌ସା ଅଣଜିଉଦିଇଂନେ ନ୍ତିଅରିଆ ଅପେଃ ବିଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK10_34","071_10_34","MRK","10","34","34","ମେଇଙ୍ଗ୍‌ ଆମେକେ ଏଃଲ୍ୟା ଆର୍‌ଏ ଆରି ମେଁ ଆଡ଼ାତ୍ରା ବିଃତୁର୍‌ ବିଆର୍‌ଏ । ଆମେକେ ଚାବୁକ୍‌ ଏତେ ବଗ୍ଆର୍‌ଏ ଆରି ସାରା ସାରି କାଲା ବାଗୁଏଃ ବିଃଆର୍‌ଏ । ଗୁଏକ୍ନେବାନ୍ ଜିର୍‌ସି ବିତ୍ରେ ଆର୍‌ମୁଇଂତର୍ ମ୍ବ୍ରଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_35","071_10_35","MRK","10","35","35","ଇଡ଼ିଙ୍ଗ୍ ଜେବଦୀନେ ଉଙ୍ଗ୍‌ଡେଇଂ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଏ ଗୁରୁ ନେ ସାପାରେନେ ଇକ୍‌ଚା ଜେ ନେ ସାପାରେ ନାଁ ଡାଗ୍ରା ମେଃଡିଗ୍ ନେସାଲ୍ୟାଏ, ଆତେନ୍‌ ନେ ସାପାରେ ନ୍‍ସା ବିଃଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_36","071_10_36","MRK","10","36","36","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ, “ନେଙ୍ଗ୍ ପେନ୍‌ସା ମେଃନେ ଣ୍ଡିଂଏ ଡାଗ୍‌ଚେ ପେ ସାପାରେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK10_37","071_10_37","MRK","10","37","37","ମେଁଇଙ୍ଗ୍‌ ବାସଙ୍ଗ୍ଆର୍‌କେ, “ନାଁନେ ମ‍ଇମା ତ୍ନାଲା ସିଂଆସନ ଅରିଆ ନାକଏ, ଡିରକମ୍ ନେ ସାପାରେନେ ବିତ୍ରେ ମୁଇଙ୍ଗ୍‌ଜାକେ ନାଁନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା ଆରି ମୁଇଂଜାକେ ବେସ୍ୟାଃତି ପାକା କୁକନ୍‌ସା ଆନେକେ ଆକେନ୍‌ ଆସିର୍ବାଦ୍‌ ବିଃଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_38","071_10_38","MRK","10","38","38","ଡାଗ୍ଲା ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେ ମେଃନେ ସାଲ୍ୟାଃପେଡିଙ୍ଗ୍‌କେ, ଆତେନ୍‌ ପେ ପେମ୍ୟାଃକେ ଣ୍ଡୁ । ନେଙ୍ଗ୍ ଆଣ୍ଡିନେ ମୁତାଅରିଆ ଉଗ୍‌ଣ୍ଡିଂ ଣ୍ଡୁଲା ଆଣ୍ତିନେ ଦିକ୍ୟା‍ଅରିଆ ଦିକ୍ୟା ଡୁଂଡଣ୍ଡିଂକେ, ଆତ୍ଅରିଆ ପେ ସାପାରେ ଦିକ୍ୟା ଡୁଂପେଡଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK10_39","071_10_39","MRK","10","39","39","ମେଇଙ୍ଗ୍‌ ଆମେକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଅଁ ନେୟାଏ ।” ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆଣ୍ଡିନେ ମୁତାଅରିଆ ଉଗ୍ ଣ୍ତିଂକେ, ପେ ସାପାରେ ଆତ୍ଅରିଆ ପେଉଗ୍‌ଏ । ନେଙ୍ଗ୍ ଆଣ୍ତିଡାଗ୍ରା ଦିକ୍ୟା ଣ୍ଡିଂଏ, ପେ ଡିଗ୍ ଆତ୍‌ତେ ଦିକ୍ୟା ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK10_40","071_10_40","MRK","10","40","40","ମାତର୍‌ ନେଙ୍ଗ୍‌ନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା ଆରି ବେସ୍ୟାଃତି ପାକା ଜାଣ୍ଡେ କଏ, ଆକେନ୍‌ ବାସଙ୍ଗ୍‌ନ୍‌ସା ନିଂନେ ଅଦିକାର୍‌ ଣ୍ଡୁ । ଜାଣ୍ଡେନ୍‌ସା ଇସପର୍‌ ଆତେନ୍‌‌ ଜାଗା ଆଃରେ ବକେ, ଆତେନ୍‌‌ ମେଁ ଆମେଇଂକେ ବିଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_41","071_10_41","MRK","10","41","41","ବିନ୍ ଗୁଆ ରେମୁଆଁ ଆକେନ୍ ଅଁଚେ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ନେ ଆଡ଼ାତ୍ରା ରିସା ଡିଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_42","071_10_42","MRK","10","42","42","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେଇଂକେ ଡାଗ୍ରା ୱାଚେ ବାସଙ୍ଗ୍‌କେ, “ଜାଣ୍ଡେଇଂ ବିଜାତିଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ସାସନ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ରକମ୍ ଲେଃଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ମେଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ସାସନ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ଆକେନ୍ ପେ ମ୍ୟାଃପେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_43","071_10_43","MRK","10","43","43","ମାତର୍‌ ପେ ବିତ୍ରେ ଦେକ୍‌ରକମ୍ ଣ୍ଡୁ । ମାତର୍‌‌ ପେ ସାପାରେ ବିତ୍ରେ ଜାଣ୍ଡେ ମ୍ନା ଡିଙ୍ଗ୍‌ନେ ଚାଏଁ ଡିଙ୍ଗ୍‌କେ, ମେଁ ବିନ୍ ରେମୁଆଁନେ ଗତିରେ ଡିଙ୍ଗ୍‌ଲେଃ । ");
INSERT INTO gaq_vpl VALUES ("MK10_44","071_10_44","MRK","10","44","44","ଆରି ପେ ବିତ୍ରେବାନ୍ ଜାଣ୍ଡେ ସାପାବାନ୍‍ ମ୍ନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ, ମେଁ ସାପାରେନେ ଗତିରେ ଡିଙ୍ଗ୍‌ଲେଃ । ");
INSERT INTO gaq_vpl VALUES ("MK10_45","071_10_45","MRK","10","45","45","ଡାଗ୍ଲା ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ଡିଗ୍ ସେବା ବାନ୍‌ସା ପାଙ୍ଗ୍ ଆଲେଃକେ ଣ୍ଡୁ । ଆରି ସେବା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆରି ଗୁଲେ ରେମୁଆଁଇଂ ଆତ୍‌ଲା ଉଦାର୍ ଡିଂନେନ୍‌ସା ନିଜର୍‌ ପାରାନ୍ ବିଃନେ ପାଙ୍ଗ୍‌ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_46","071_10_46","MRK","10","46","46","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍‌ ଯିରୀହୋନ୍ନିଆ ପାଙ୍ଗ୍‌କେ । ଜିସୁ ମେଇଙ୍ଗ୍‌ନେ ସିସ୍ ଆରି ବିନ୍ ଉଡ଼ି ରେମୁଆଁଇଂ ଏତେ ଯୀରିହୋବାନ୍ ଆନ୍ତାର୍ ଡନେ ବେଲା ଟିମୟର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ବାର୍ଟିମୟ ମ୍ନିକ୍ନେ ମୁଇଂ କାନା ବିକାରି ଗାଲି ଆଃଡ଼ାଃ କଚେ ବିକ୍‌ ସାଲ୍ୟାଃଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_47","071_10_47","MRK","10","47","47","ମେଁ ଜେ ନାଜରିତୀୟ ଜିସୁ, ଆତେନ୍‌ ଅଁଚେ ମେଁ କିରଚେ ବାସଙ୍ଗ୍‌କେ, “ଏ ଦାଉଦ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଜିସୁ, ଆନେକେ ଦୟା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_48","071_10_48","MRK","10","48","48","ଆତ୍‌ବାନ୍ ଜବର୍ ରେମୁଆଁ ଆମେକେ ବୁଙ୍ଗ୍‌ଲେଃ ନ୍‌ସା ଦାକା ବିକେ । ମାତର୍‌ ମେଁ ଜାବର୍‌ କିରଚେ ବାସଙ୍ଗ୍‌କେ, “ଏ ଦାଉଦନେ ଉଙ୍ଗ୍‌ଡେ ଜିସୁ ଆନେଙ୍ଗ୍‌କେ ଦୟା ଡିଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_49","071_10_49","MRK","10","49","49","ଆତ୍‌ବାନ୍ ଜିସୁ ତୁଆଁଚେ ବାସଙ୍ଗ୍‌କେ, “ଆମେକେ ୱାପା ।” ମେଇଙ୍ଗ୍ ଆତେନ୍‌‌ କାନା ରେମୁଆଁକେ ୱାଚେ ବାସଙ୍ଗ୍‌କେ, “ସାଆସ୍ ସାଃ, ତଡ଼ିଆ, ମେଁ ଆନାକେ ୱାଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_50","071_10_50","MRK","10","50","50","ଆତ୍‌ବାନ୍ ମେଁ ଜିଆ ଜିଆ ନିଜର୍‌ନେ ତଗ୍‌ରିଆଃ ଜଗ୍‌ତ୍ଲାଗ୍‌ଚେ ତଡ଼ିଆଚେ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK10_51","071_10_51","MRK","10","51","51","ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ, “ନେଙ୍ଗ୍ ନାଁନ୍‌ସା ମେଃ ଣ୍ତିଙ୍ଗ୍‌ଏ ଡାଗ୍‌ଚେ ନାଁ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍‌କେ ?” ଆତେନ୍‌‌ କାନା ରେମୁଆଁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଅ ଗୁରୁ ଡିରକମ୍ କି ନେଙ୍ଗ୍ କିକେ ଇଁୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK10_52","071_10_52","MRK","10","52","52","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ୱେଲା, ନାଁନେ ବିସ୍‌ବାସ୍‌ ଆନାକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ବିବକେ । ଆତ୍‌ବାନ୍ ମେଁ କେୟାକେ ଆରି ମେଇଙ୍ଗ୍‌ଏତେ ଗାଲିନ୍ନିଆ ଜିସୁନେ ପ୍ଲା ପ୍ଲା ଅଲେଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK11_1","071_11_1","MRK","11","1","1","ଜିସୁ ଆରି ମେଁନେ ସିସ୍ଇଂ ଯିରୂଶାଲାମ୍ ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଜିତକଣ୍ତା ଡାଗ୍ରା ବେଥ୍‌ଫାଗୀ ଆରି ବେଥନୀ ଡାଗ୍ରା ପିଙ୍ଗ୍‍ଚାଆର୍‌କେ । ଜିସୁ ନିଜର୍‌ ସିସ୍ଇଂ ବିତ୍ରେବାନ୍‌ ମ୍ବାୟାକେ ଆକେନ୍‌ ସାମୁଆଁ ବାଲିର୍‌ଚେ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_2","071_11_2","MRK","11","2","2","“ସିସେ ତ୍ନାକ୍ନେ ଇନି ୱେଲାପା । ଆତ୍ଅରିଆ ଗାକ୍ନେ ଦାପ୍ରେ ପେ ସାପାରେ ମୁଇଂ ଗଦ ଉଙ୍ଗ୍‌ଡେ ଗାଗ୍‌ବକ୍ନେ ପେକେଏ । ଆତେନ୍‌ ଗଦ ଉଙ୍ଗ୍‌ଡେ ଆଡ଼ାତ୍ରା ଜାଡିଗ୍ ଏଜାକ ଡିଡେଃ ଙ୍କାରେ । ଆମେକେ ତୁପିଗ୍‌ଚେ ନେଙ୍ଗ୍‍ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‍ଲାପା । ");
INSERT INTO gaq_vpl VALUES ("MK11_3","071_11_3","MRK","11","3","3","ଆରି ମୁଃଡ଼ି ରେମୁଆଁ ଆପେକେ ଗଦ ଉଙ୍ଗ୍‌ଡେକେ ମେଃନ୍‌ସା ଡୁଂୱେ ପେଡିଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ସାଲିଆକୁଏ, ତେଲା ପେ ଆମେକେ ପେବାସଙ୍ଗ୍‌ଏ, ମାପ୍ରୁ ନ୍‌ସା ଆକେନ୍ ଦର୍‌କାର୍‌ ଲେଃକେ । ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଆମେକେ ଟାପ୍‌ନା ଆଃଆଣ୍ଡେ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK11_4","071_11_4","MRK","11","4","4","ମେଇଙ୍ଗ୍ ଆତେନ୍‌‌ ଇନି ୱେଆର୍‌କେ । ମେଇଙ୍ଗ୍ ବାଜାର୍‌ ଡାଗ୍ରା ମୁଇଂ ଗଦ ଉଙ୍ଗ୍‌ଡେକେ ଗାଗ୍‌ବକ୍ନେ କେଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଆମେକେ ତୁଃପିଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_5","071_11_5","MRK","11","5","5","ଉଡ଼ି ରେମୁଆଁ ଆତ୍‌ଅରିଆ ତୁଆଁ ଲେଃଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଆକେନ୍ କେଚେ ସାଲ୍ୟାକୁଆର୍‌କେ, “ପେ ଆକେନ୍ ଗଦ ଉଙ୍ଗ୍‌ଡେକେ ମେଁନ୍‌ସା ତୁପିଗ୍ ପେଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK11_6","071_11_6","MRK","11","6","6","ସିସ୍‌‍ଇଂକେ ଜିସୁ ମେଃନେ ବାସଙ୍ଗ୍‌ ନ୍‌ସା ବାଲିର୍‌ବଗେ, ସିସ୍‌ଇଂ ରେମୁଆଁଇଂକେ ଦେତୁଆ ବାସଙ୍ଗ୍‌କେ । ଇଡ଼ିଙ୍ଗ୍ ରେମୁଆଁଇଂ ଗଦ ଉଙ୍ଗ୍‌ଡେ ଏତେ ଆମେଇଂକେ ଆନ୍ତାର୍‌ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_7","071_11_7","MRK","11","7","7","ସିସ୍‌ଇଂ ଗଦ ଉଙ୍ଗ୍‌ଡେକେ ଜିସୁ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଆର୍‌କେ ଆରି ଗଦ ଆଡ଼ାତ୍ରା ନିଜର୍‌ ପାଟାଇ ପୁଟାଇ ବେଃବିଃଆର୍‌କେ । ଜିସୁ ମେଁ ଆଡ଼ାତ୍ରା କକେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_8","071_11_8","MRK","11","8","8","ଗୁଲୁଏ ରେମୁଆଁ ଜିସୁ ନ୍‍ସା ମେଇଂ ନିଜର୍ ନିଜର୍‌ନେ ପାଟାଇ ଗାଲି ଅରିଆ ବେଃପାଃ ବିଃଆର୍‌କେ ଆରି ବିନ୍ ରେମୁଆଁଇଂ ପାଃଡ଼ୁ ପାକ୍‌ଚିଃ ଡୁଂପାଙ୍ଗ୍‌ଚେ ଗାଲି ଅରିଆ ବେଃପାଃ ବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_9","071_11_9","MRK","11","9","9","ଉଡ଼ି ରେମୁଆଁ ଜିସୁନେ ସିସେ ୱେଆର୍‌କେ ଆରି ବିନ୍ ଉଡ଼ି ରେମୁଆଁ ମେଁନେ ପ୍ଲାପ୍ଲା ୱେ ଡିଙ୍ଗ୍‌ଆର୍‌ଗେ । ସାପାରେ କିରଚେ ବାସଂଆର୍କେ “ହୋଶାନ୍ନା; ମାପ୍ରୁ ମ୍ନିରେ ଜାଣ୍ଡେ ରେମୁଆଁ ପାଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ମେଁ ଆସିର୍ବାଦ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MK11_10","071_11_10","MRK","11","10","10","ନେଁନେ ଆବା ଦାଉଦ୍ ପାଙ୍ଗ୍‌ ଡିଂକ୍ନେ ରାଜ୍ୟ ଦନ୍ୟ ଆଡ଼ାତ୍ରା ଲେଃକ୍ନେ ମ୍ନାଃଆବା ଡିଗ୍ ଦନ୍ୟ ହୋଶାନ୍ନା ।” ");
INSERT INTO gaq_vpl VALUES ("MK11_11","071_11_11","MRK","11","11","11","ଜିସୁ ଯିରୂଶାଲାମ୍ ପାଙ୍ଗ୍‍ଚେ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଗାକେ ଆରି ସାପା ବିସୟ୍‌ କେକେ । ଆତେନ୍‌‌ ବେଲା ଜବର୍‌ ବେଲା ଡିଙ୍ଗ୍‌ ୱେଲେଃଗେ । ଗମ୍ବାର୍ କ୍ଲିଗ୍‍ ପ୍ରେରିତ୍‌‍ଇଂ ଏତେ ବେଥନୀନ୍ନିଆ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_12","071_11_12","MRK","11","12","12","ଏନ୍ ମେସୁଆ ମେଇଙ୍ଗ୍ ବେଥନୀବାନ୍ ଯିରୁଶାଲାମ୍ ଆଣ୍ଡେନେ ବେଲା ଆମେକେ ଜବର୍‌ କିଡ଼େସଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_13","071_11_13","MRK","11","13","13","ଜିସୁ ଉଲିଆ ବର୍‌ତି ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ମୁଇଂ ଲିୱା ‍ସ୍ଲାକେ କେକେ । ସ୍ଲା ଅରିଆ ମୁଇଂ ଡିଗ୍ ଲିୱା ଚୁ ଲେଃଏ ଡାଗ୍‌ଚେ ମେଁ ସ୍ଲା ବୁନ୍ଦେ ୱେକେ । ମାତର୍‌‌ ଆତ୍‌ଅରିଆ ପାଙ୍ଗ୍‌ଚେ କେକେ ଜେ ମୁଇଂ ଡିଗ୍ ଲିୱା ଆତ୍ନାକେ ଣ୍ଡୁ । ସ୍ଲା ଅରିଆ ଉଲିଆ ଆନ୍ତାର୍‌ଚେ ଆରି ମେଃ ଡିଗ୍ ଣ୍ତୁ । ଆକେନ୍ ଲିୱା ଚୁନେ ବେଲା ଡିଂଆଲେଃଗେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK11_14","071_11_14","MRK","11","14","14","ତେଲା ଜିସୁ ସ୍ଲାକେ ବାସଙ୍ଗ୍‌କେ, “ଆରି ଅଃନା ଡିଗ୍ ନାଁବାନ୍ ଚୁ ଚଙ୍ଗ୍‌ନ୍‌ସା ଆବାଆର୍‌ ଣ୍ତୁ ।” ସିସ୍ଇଂ ଜିସୁନେ ଆକେନ୍ ସାମୁଆଁ ଦ୍ରିଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_15","071_11_15","MRK","11","15","15","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଯିରୂଶାଲାମ୍‌ନ୍ନିଆ ୱେକେ । ଜିସୁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ୱେଚାକ୍ନେ ଦାପ୍ରେ ଆତ୍ଅରିଆ ବିୟାର୍‌ ସ ଡିଂମ୍ୟାକ୍ନେ ରେମୁଆଁଇଂକେ ପାଦା ନୁଆଁ ଆଃତାର୍‌କେ । ମେଁ ବିନ୍ ରକମ୍ ଡାବୁ ବେପାର୍‌ ଡିଂକ୍ନେ ରେମୁଆଁନେ ଟିବୁଲ୍ ଉଲ୍‌ଟା ପାଲ୍‌ଟା ଆଃଡିଂବିକେ । ଜାଣ୍ଡେଇଂ କୁକୁର୍‌ୟାଃ ସ ଡିଂଆର୍‌ଗେ, ମେଇଂନେ ଡିଗ୍ ଟିବୁଲ୍ ଉଲ୍‌ଟା ପାଲ୍‌ଟା ଆଃଡିଂବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_16","071_11_16","MRK","11","16","16","ମେଁ ଆଜାକେ ଡିଗ୍ ମନ୍ଦିର୍‍ନେ ବାଜାର୍‍ନ୍ନିଆ ଜିନିସ୍ ପତର୍ ଡୁଂୱେନେ ଆବିକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK11_17","071_11_17","MRK","11","17","17","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଆମେଇଂକେ ଗିଆନ୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ସାସ୍ତ୍ରର୍‌ଅରିଆ ଆକେନ୍ ସାମୁଆଁ ଗୁଆର୍‌ ବକେ ଜେ ନେଙ୍ଗ୍‌ନେ ଡୁଆ ମଞ୍ଚ୍‌ପୁର୍‍ନେ ସାପା ଜାତିନେ ରେମୁଆଁ ନ୍‍ସା ପାର୍‌ତନା ଡୁଆ ଡାଗ୍‌ଚେ ବାଲିର୍‌ ଆର୍‌ଏ । ମାତର୍‌‌ ସାପାରେ ତ ଆମେକେ ଡଙ୍ଗାରେନେ ଡୁଆ ରକମ୍‌ ଆଡିଙ୍ଗ୍ ପେବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK11_18","071_11_18","MRK","11","18","18","ମ୍ନା ପୁଜାରି ଆରି ଦରମ୍‌ ପୁଜାରି‍ଇଂ ଏନ୍‌ ସାମୁଆଁ ଅଁଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ବାଗୁଏଃ ନ୍‍ସା ଗାଲି ତୁର୍‌ଆର୍‌କେ । ମାତର୍‌ ଆତ୍‌ଅରିଆ ରିସିଙ୍ଗ୍ ଲେଃକ୍ନେ ସାପା ରେମୁଆଁ ଜିସୁନେ ସାମୁଆଁ ଅଁଆର୍‌ଚେ ଇରିଆତୁଗ୍‌ ଆର୍‌କେ ଆରି ଦରମ୍ ପୁଜାରିଇଂ ଜିସୁକେ ବୁଟ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_19","071_11_19","MRK","11","19","19","ଆତେନ୍‌ ଦିନା ଲମ୍‍ଡିଗ୍‍ ୱେକେ । ଲମ୍‌ଡିଗ୍‍ଲା ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ନଗରବାନ୍ ତାର୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_20","071_11_20","MRK","11","20","20","ଜିସୁ ଞ୍ଜିର୍‍ ଆନ୍ତ୍‍ପାକା ବିଃଚେ ୱେନେ ବେଲା ମେଇଂ ଲିୱା ସ୍ଲା ମୁଲ୍‌ବାନ୍‌ ନ୍‌ସୁଆର୍ ଲେଃକ୍ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_21","071_11_21","MRK","11","21","21","ସିସେ ବାସଙ୍ଗ୍‌କ୍ନେ ସାମୁଆଁ ବାବେଚେ ପିତର ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, “ଗୁରୁ କେଲାନି ନାନେ ଅବିସାପ୍‌ ବାନ୍‌ ଲିୱା ସ୍ଲା ଗୁଏଃଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK11_22","071_11_22","MRK","11","22","22","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଇସ୍‌ପର୍‌ନ୍ନିଆ ବିସ୍‌ବାସ୍ ବପା । ");
INSERT INTO gaq_vpl VALUES ("MK11_23","071_11_23","MRK","11","23","23","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଣ୍ଡିଂକେ, ମୁଡ଼ି ରେମୁଆଁ ଆକେନ୍ କଣ୍ତାକେ ଡବେଗ୍‍ଚେ କେଣ୍ତିଆ ଅରିଆ ୱେଚେ ଲଃଲା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍ଏ । ମାତର୍‌‌ ରେମୁଆଁନେ ଜିବନ୍ ବିତ୍ରେ ସନ୍ଦେଅ ମାଡିଙ୍ଗ୍‌ଚେ ମେଃ ଡିଗ୍ ବାସଙ୍ଗ୍‌ଏ, ଆତେନ୍‌ ଡିଂଏ ଡାଗ୍‌ଚେ ବିସ୍‌ବାସ୍‍ ଡିଙ୍ଗ୍ଏ, ତେଲା ଆତେନ୍‌‌ ଡିଲାଡିଗ୍‌ ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("MK11_24","071_11_24","MRK","11","24","24","ଆକେନ୍‌ସା ନେଙ୍ଗ୍ ଆପେ ସାପାରେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ ଜେ ପେ ସାପାରେ ପାର୍‌ତନା ଡିଂବେଲା ମେଃନେ ସାଲ୍ୟାଃପେଡିଂକେ, ଆତେନ୍‌‌ ବାପେଲେଃକେ ଡାଗ୍‌ଚେ ବିସ୍‌ବାସ୍‌ ପେଡିଂଏ, ତେଲା ଆତେନ୍‌‌ ଡିଲାଡିଗ୍‌ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MK11_25","071_11_25","MRK","11","25","25","ପେ ସାପାରେ ଉଡ଼ିବେଲା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ନେସା ପେତଡ଼ିଆଏ, ଡାଗ୍ଲା ଜାନେ ବିରଦ୍‌ରେ ପେ ସାପାରେନେ ମେଁ ଡିଗ୍ ସାମୁଆଁ ଲେଃଏ, ତେଲା କେମା ଡିଙ୍ଗ୍‍ପା । ଡିରକମ୍‍ ଆପେ ସାପାରେକେ ଆଡ଼ାତ୍ରାନେ ମାପ୍ରୁ ଡିଗ୍ ପେନେ ସାପାପାପ୍ କେମା ଡିଙ୍ଗ୍‍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK11_26","071_11_26","MRK","11","26","26","“ମାତର୍‌ ପେ ଯଦି ସାପାରେକେ କେମା ପେଡିଙ୍ଗ୍, ତେଲା କିତଂନେ ମାପ୍ରୁ ଡିଗ୍ ଆପେ ସାପାରେକେ ପାପ୍‌ବାନ୍ କେମା ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK11_27","071_11_27","MRK","11","27","27","ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌ଇଙ୍ଗ୍ ଆରି ମୁଇଙ୍ଗ୍‌ତର୍‌ ଯିରୂଶାଲାମ୍ ପାଙ୍ଗ୍ଆର୍‌କେ । ଜିସୁ ମନ୍ଦିର୍ ବିତ୍ରେ ଅଲେଙ୍ଗ୍‌ନେ ବେଲା ମ୍ନା ପୁଜାରି, ଦର୍ମ ଗୁରୁ ଆରି ଜିଉଦି ନେତାଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_28","071_11_28","MRK","11","28","28","ଜିସୁକେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ, “ପେ ଜାନେ ଅଦିକାର୍‌ରେ ସାପା କାମ୍ ଡିଂପେଡିଂକେ ? ଆକେନ୍ ସାପା ଡିଙ୍ଗ୍‌ନେସା ଆପେକେ ଜାଣ୍ଡେ ଅଦିକାର୍ ବିଃକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK11_29","071_11_29","MRK","11","29","29","ଜିସୁ ଉତର୍ ବିକେ, “ନେଙ୍ଗ୍ ଆପେ ସାପାରେକେ ମୁଇଙ୍ଗ୍ ପ୍ରସ୍‌ନ ନ୍‍ସାଲ୍ୟାଃକୁଏ । ନେଙ୍ଗ୍‌ନେ ପ୍ରସ୍‌ନନେ ଉତର୍ ବିଃଲାପା ତେଲା ପେ ସାପାରେକେ ବାସଙ୍ଗ୍‌ମ୍ବିଏ ଜେ ଜାଣ୍ତେନେ ଅଦିକାର୍‌ରେ ନେଙ୍ଗ୍ ଆକେନ୍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MK11_30","071_11_30","MRK","11","30","30","ଜହନ୍‌ନେ ଦିକ୍ୟା କିତଙ୍ଗ୍‍ଇନିବାନ୍‍ ଲେଃ ରେମୁଆଁବାନ୍ ଡିଂଲେଃଗେ ? ଆତେନ୍‌ ଆନେଙ୍ଗ୍‌କେ ଉତର୍ ବିଃଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK11_31","071_11_31","MRK","11","31","31","ଜିଉଦି ନେତାଇଙ୍ଗ୍ ଜିସୁନେ ପ୍ରସ୍‌ନ ଆଡ଼ାତ୍ରା ବାଲିର୍‌ବାତାଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, ନେଁ ସାପାରେ ଜଦି ଆଡ଼ାତ୍ରା ବାନ୍‌ ଡାଗ୍‌ଚେ ନେବାସଙ୍ଗ୍‍ଏ ତେଲା ଜହନ୍‌କେ ପେ ସାପାରେ ମେଃନ୍‌ସା ବିସ୍‌ବାସ୍‌ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MK11_32","071_11_32","MRK","11","32","32","ଜଦି ନେ ସାପାରେ ନେବାସଙ୍ଗ୍‍ଏ ଜେ ଜହନ୍‌ନେ ଦିକ୍ୟା ରେମୁଆଁବାନ୍ ପାଙ୍ଗ୍‌ଲେଃକେ ଡାଗ୍‌ଚେ ନେବାସଙ୍ଗ୍‌ଏ । ତେଲା ରେମୁଆଁଇଂ ନେ ଆଡ଼ାତ୍ରା ରିସା ଡିଙ୍ଗ୍ଆର୍‌ଏ । ମେଇଙ୍ଗ୍ ରେମୁଆଁଇଂକେ ଜବର୍ ବୁଟ ଡିଂଆର୍‌ଗେ । ଡାଗ୍ଲା ସାପା ରେମୁଆଁ ଇକ୍‌ଚା ଡିଂଆର୍‌କେ ଜେ ଜହନ୍‌ ସତେଆ ମୁଇଂ ବାବବାଦି । ");
INSERT INTO gaq_vpl VALUES ("MK11_33","071_11_33","MRK","11","33","33","ତେସାଃ ମେଇଙ୍ଗ୍ ଜିସୁକେ ଉତର୍ ବିଆର୍‌କେ, “ନେ ସାପାରେ ନେମ୍ୟାକେ ଣ୍ତୁ ।” ତେସାଃ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ତେଲା ନେଙ୍ଗ୍‌ ଡିଗ୍ ଆପେ ସାପାରେକେ ନ୍ନାବାସଙ୍ଗ୍‌ ଣ୍ତୁ ଜେ ଆଣ୍ତିନେ ଅଦିକାର୍‌ରେ ନେଙ୍ଗ୍ ଏନ୍ ସାପା କାମ୍‌ ଡିଂ ଣ୍ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_1","071_12_1","MRK","12","1","1","ଜିସୁ ଉଦା‍ଅରନ୍ ବିଚେ ରେମୁଆଁଇଂକେ ଗିଆନ୍ ବିକେ; ମେଁ ବାସଙ୍ଗ୍‌କେ, “ମୁଇଂ ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ଅଙ୍ଗୁର୍ ବଗିଚା ଆରେକେ । ମେଁନେ ପିତୁର୍‌ପାକା ତୁରାଃ ତେ ବିଃକେ । ଅଙ୍ଗୁର୍‌ ରାଃସିଙ୍ଗ୍‌ ନ୍‌ସା ମୁଇଂ କୁରୁ ଗଃକେ ଆରି ଉର୍‌ନ୍‌ସା ତାନାଃ ମୁଇଙ୍ଗ୍ ଆଃରେକେ । ମେଁ ଉଡ଼ିକ୍ଲିଗ୍‌ ସ୍ଲେରେକେ ଆତେନ୍‌ ଡୁଗ୍‌ଡିକେ ବାଟା ବିଃଚେ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଅଲେଙ୍ଗ୍‌ସାର୍ ସୁଗୁଆ ବିଦେସ୍ ତାର୍‌ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_2","071_12_2","MRK","12","2","2","ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିବେଲା ଅଙ୍ଗୁର୍ ରୁଏଃନେ ବେଲା ପିଙ୍ଗ୍‌ଚାକେ, ଆତେନ୍‌‌ ବେଲା ମେଁ ମେଁନେ ମୁଇଙ୍ଗ୍ ଗତିରେକେ ଅଙ୍ଗୁର୍‌ବଗିଚା ବାନ୍ ମେଁନେ ନିଜର୍‌ ବାଟା ଡୁଂପାଙ୍ଗ୍‌ନ୍‌ସା ସ୍ଲେ ରେମୁଆଁ ଡାଗ୍ରା ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_3","071_12_3","MRK","12","3","3","ମାତର୍‌ ସ୍ଲେରେଇଙ୍ଗ୍ ଗତିରେକେ ସାଚେ ବଗ୍‌ ଆର୍କେ ଆରି ଆମେକେ ମେଃଡିଗ୍ ମାବିଃଚେ ବେବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_4","071_12_4","MRK","12","4","4","ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ରେମୁଆଁ ଆରି ମୁଇଙ୍ଗ୍ ଗତିରେକେ ମେଇଙ୍ଗ୍ ଅରିଆ ବେବିଃକେ । ମେଇଙ୍ଗ୍ ଆତେନ୍‌‌ ଗତିରେକେ ବାଆଃନ୍ନିଆ ବଗ୍‌ଚେ ଆରି ଆଗ୍ୟାସ ବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_5","071_12_5","MRK","12","5","5","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଆର୍‌ମୁଇଙ୍ଗ୍ ଗତିରେକେ ବେକେ । ସ୍ଲେରେଇଂ ଆତେନ୍‌ ଗତିରେକେ ବାଗୁଏଃ ବିଃଆର୍‌କେ । ଆତେନ୍‌ ରେମୁଆଁ ଆରି ଜବର୍‌ ଗତିରେକେ ବେବିଃକେ । ମାତର୍‌ ସ୍ଲେରେଇଙ୍ଗ୍ ଉଡ଼ିରେକେ ବଗ୍‌ଆର୍‌କେ ଆରି ଉଡ଼ିରେକେ ବାଗୁଏଃ ବିଃଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_6","071_12_6","MRK","12","6","6","ସ୍ଲେରେ ଡାଗ୍ରା ବେନ୍‍ସା ଆରି ମୁଇଂଜା ମାତର୍‌‌ ବାକି ଲେଃଗେ । ଆତେନ୍‌ ରେମୁଆଁ ମେଁନେ ଉଙ୍ଗ୍‌ଡେ । ଆତେନ୍‌‌ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ମେଁ ଜବର୍‌ ବଲ୍‌ ବାଡିଂଗେ । ମାତର୍‌‌ ମେଁ ସ୍ଲେରେ ଡାଗ୍ରା ବେନ୍‍ସା ଉଙ୍ଗ୍‌ଡେ ଆଃ ଲେଃଗେ । ମେଁ ବାବେକେ ଜେ ଡିଲାଡିଗ୍ ମେଇଂ ନେଉଂକେ ମାନେଃଆର୍‌ଏ । ଆକେନ୍ ଏତେଚେ ଇଡ଼ିଂ ସ୍ଲେରେଇଂ ଡାଗ୍ରା ନିଜର୍ ଗଡ଼େଅକେ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_7","071_12_7","MRK","12","7","7","“ମାତର୍‌ ସ୍ଲେରେଇଙ୍ଗ୍ ବାଲିର୍‌ବାତା ଆର୍‌କେ, ଆକେନ୍ ରେମୁଆଁ ଡୁଗ୍‌ଡି ମାଲିକ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ । ଡୁଗ୍‌ଡି ମେଁନେ ଅଦିକାର୍ ଲେଃକେ । ନେଃ ସାପାରେ ଆମେକେ ବାଗୁଏଃ ନେଃବିଲା, ଡୁଗ୍‌ଡି ନେଃନେ ଡିଙ୍ଗ୍‌ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MK12_8","071_12_8","MRK","12","8","8","ଆତେନ୍‌‍ସା ସ୍ଲେରେଇଙ୍ଗ୍ ମାଲିକ୍‌ନେ ଉଙ୍ଗ୍‌ଡେକେ ସାଃଡୁଂୱେଚେ ବାଗୁଏଃ ବିଃଆର୍‌କେ ଆରି ଅଙ୍ଗୁର୍ ଡୁଗ୍‌ଡି ବାଏରେ ଜଗ୍‌ତ୍ଲାଗ୍‌ ବିଃଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_9","071_12_9","MRK","12","9","9","ଏବେ ଅଙ୍ଗୁର୍ ଡୁଗ୍‌ଡି ମାଲିକ୍ ମେଃ ଡିଙ୍ଗ୍‌ଏ ? ମେଁ ପାଙ୍ଗ୍‌ଚେ ସ୍ଲେରେଇଂକେ ବାଗୁଏଃ ଜଗ୍‌ତ୍ଲାଗ୍‌ଚେ ଆରି ଅଙ୍ଗୁର୍ ଡୁଗ୍‌ଡି ବିନ୍‌ ସ୍ଲେରେକେ ବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MK12_10","071_12_10","MRK","12","10","10","ସାସ୍ତ୍ରର୍‌ନ୍ନିଆ ଏନ୍‌ ସାମୁଆଁ ପଡ଼େ ପେଲେକେ । “ଆଣ୍ତିନେ ବ୍ରିକେ ବାଡ଼େଇଂ ଦର୍‌କାର୍‌ ଣ୍ଡୁ ଡାଗ୍‌ଚେ ଆନ୍ତାର୍ ବିଃବଆର୍‌କେ ଆତାନ୍‌ ବ୍ରି ଡୁଆନେ ମୁଲ୍‌ ବ୍ରି ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_11","071_12_11","MRK","12","11","11","ମାପ୍ରୁ ନିଜେ ଆକେନ୍‌ ସାମୁଆ ବାସଙ୍ଗ୍‌ବକେ, ଉଡ଼ି ବୟାଙ୍କାର୍‌ ଏନ୍ କାମ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_12","071_12_12","MRK","12","12","12","ଆକେନ୍ ଦର୍ମ ସାସ୍ତ୍ରି ଆରି ମ୍ନା ପୁଜାରିଇଂ ଜିସୁବାନ୍ ଏନ୍‌ ଉଃସ୍ରା ଅଁଆର୍କେ । ମେଇଙ୍ଗ୍ ମ୍ୟାଃଆର୍‌କେ ଜେ ଆକେନ୍ ଉଃସ୍ରା ମେଇଙ୍ଗ୍‌ନେ ବିସ‍ୟରେ ବାଲିର୍‍ବକେ । ତେସା ମେଇଙ୍ଗ୍ ଜିସୁକେ ସମାନ୍ ବେଲା ବନ୍ଦି ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ଚାଏଁଆର୍‌କେ । ମାତର୍‌ ରେମୁଆଁଇଂ ମାରିୟାଃ ମେଃନେ ଡିଙ୍ଗ୍‌ବିଃଆର୍‌ଏ ଡାଗ୍‌ଚେ ମେଇଂ ବୁଟ ଡିଂଆର୍‌ଗେ, ତେସାଃ ମେଇଙ୍ଗ୍ ଜିସୁକେ ଆନ୍ତାର୍‍ଚେ ଡଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_13","071_12_13","MRK","12","13","13","ଇଡ଼ିଙ୍ଗ୍ ଜିଉଦି ନେତାଇଙ୍ଗ୍ ଉଡ଼ି ଫାରୁଶୀ ଆରି ହେରୋଦରାଜାନେ ରେମୁଆଁଇଂକେ ଜିସୁ ଡାଗ୍ରା ବେଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ବୁଲ୍ ସାଚେ ପାନ୍ଦ୍‍ଅରିଆ ତ୍ଲାଗ୍‌ନ୍‍ସା ଉପାୟ୍‌ ତୁର୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_14","071_12_14","MRK","12","14","14","ଫାରୁଶୀ ଆରି ହେରୋଦିଆଇଂ ଜିସୁ ଡାଗ୍ରା ୱେଚେ ବାଲିର୍‌ଆର୍‌କେ, “ଗୁରୁ ନେ ମ୍ୟାଃନେଲେକେ ଜେ ପେ ମେଃନେ ବାସଙ୍ଗ୍‌ପେଡିଂ ଆରି ବ୍ନାଲିର୍ ବିଃନାଡିଙ୍ଗ୍‌କେ । ଆତେନ୍‌ ସାପା ଟିକ୍ । ନାଁ ଜା ଆଡ଼ାତ୍ରା ଡିଗ୍ ନାବୁଟ ଣ୍ଡୁ । ମାତର୍‌ ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚା ବିସୟ୍‌ରେ ସତ୍ ବୁଦି ବିଃନାମ୍ୟାଃକେ । ଆନେକେ ବାସଙ୍ଗ୍, କାଇସର୍‍କେ ସିସ୍ତୁ ବିଃନେ ନିଅମ୍ ଲେଃ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("MK12_15","071_12_15","MRK","12","15","15","ମାତର୍‌ ଜିସୁ ମେଇଙ୍ଗ୍‌ନେ କୁଟ୍‌ ମ୍ୟାଃଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେ ଆନେଙ୍ଗ୍ ନିମାଣ୍ଡା ସାମୁଆଁ ବାଲିର୍‌ଚେ ମେଃନ୍‌ସା ପାନ୍ଦ୍‍ନ୍ନିଆ ତ୍ଲାଗ୍‍ନେ ଚେସ୍‌ଟା ଡିଂପେଡିଙ୍ଗ୍‌କେ ? ନେଙ୍ଗ୍ ଡାଗ୍ରା ମୁଇଙ୍ଗ୍ କାସୁ ଡୁଂପାଙ୍ଗ୍‍ଲାପା, ନେଙ୍ଗ୍ ଆତେନ୍‌ ଙ୍କେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_16","071_12_16","MRK","12","16","16","ମେଇଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ କାସୁ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍ଆର୍‌କେ । ଜିସୁ ଆମେଇଂକେ ସାଲିଆକୁକେ କାସୁ ଆଡ଼ାତ୍ରା ଜାନେ ପଟ୍‌ ଲେଃକେ ? ମେଁ ଆଡ଼ାତ୍ରା ଜାନେ ମ୍ନି ଗୁଆର୍‍ବକେ ? ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ଆକେନ୍ ତ କାଇସର୍‍ନେ ପଟ୍‌ ବାରି ରୋମ୍ ଇଃସାଙ୍ଗ୍‌ନେ ମ୍ନି ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_17","071_12_17","MRK","12","17","17","ଆରି ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଆଣ୍ତିନେ ରୋମ୍ ଇଃସାଙ୍ଗ୍‌ନେ ଆତେନ୍‌ ରୋମ୍ ଇଃସାଙ୍ଗ୍‌କେ ବିଃପା; ଆରି ଆଣ୍ତିନେ ପର୍‌ମେସର୍‌ନେ ଆତେନ୍‌ ପର୍‌ମେସର୍‌କେ ବିଃପା ।” ଆକେନ୍ ଅଁଚେ ସାପାରେ କାବା ଡିଙ୍ଗ୍ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_18","071_12_18","MRK","12","18","18","ଆରି ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିରୁଆ ସାଦୁକୀ ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ । ଜାଣ୍ଡେ ରେମୁଆଁ ଗୁଏଚେ ଆର୍‌ମୁଇଂତର୍ ଜନମ୍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ସାଦୁକୀ ଦଲ୍‌ନେ ଉଃଡ଼ିରୁଆ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ସାଲ୍ୟାକୁଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_19","071_12_19","MRK","12","19","19","“ଗୁରୁ, ମୋଶା ନେ ସାପାରେନ୍‍ସା ଏନ୍‌ ନିୟମ୍‌ ଗୁଆର୍‌ବକେ । ମୁଇଂଜା ଗଗିସିଆ ମାକେଚେ ଗୁଏୱେଲା ଆତାନ୍‌ ରେମୁଆଁନେ ସେଲାମ୍ବ‍ଏକେ ବୟାଁଣ୍ତେ ବିହେ ଡିଙ୍ଗ୍‌ନେ ଦରକାର୍‌ ବାରି ମେଇଂନେ ଗଗିସିଆ ଜନମ୍‌ ଡିଙ୍ଗ୍‌ଲା ମେଇଂ ଗୁଏକ୍ନେ ରେମୁଆଁନେ ଗଡ଼େଇଂ ଡାଗ୍‌ଚେ ସ୍ନାମୁଆଁ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK12_20","071_12_20","MRK","12","20","20","ମୁଇଙ୍ଗ୍ ତର୍ ଗୁକ୍ଲିଗ୍ ବୟାଁଣ୍ଡେ ଲେଃଗେ । ସାପାବାନ୍ ମ୍ନା ନାଙ୍ଗ୍‍ଣ୍ଡେ ବିହେ ଡିଙ୍ଗ୍‌କେ । ମାତର୍‌ ମେଁ ଡିଗ୍ ଗଗିସିଆ ମାଲେଃଚେ ଗୁଏ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_21","071_12_21","MRK","12","21","21","ତେଲା ଆରି ମୁଇଙ୍ଗ୍ ବୟାଁଣ୍ଡେ ଆତେନ୍‌ ସେଲାମ୍ବୁଏକେ ବିହେ ଡିଙ୍ଗ୍‍କେ । ମେଁ ଡିଗ୍ ଗଗିସିଆ ମାଲେଃଚେ ଗୁଏ ୱେଗେ । ଞ୍ଜି ବୟାଁ ଆଡ଼ାତ୍ରା ଡିଗ୍ ଦେତୁଆ ଗଟେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_22","071_12_22","MRK","12","22","22","ଗୁକ୍ଲିଗ୍‍ ବୟାଁଣ୍ଡେ ଆତେନ୍‌ ସେଲାମ୍ବୁଏକେ ମୁଇଙ୍ଗ୍‌ଜା ଇଡ଼ିଂ ମୁଇଙ୍ଗ୍ ଜା ବିହେ ଡିଙ୍ଗ୍‍କେ ଆରି ଇଡ଼ିଙ୍ଗ୍ ଗୁଏ ୱେଗେ । ମେଇଙ୍ଗ୍ ବିତ୍ରେ ଆଜାଡିଗ୍ ମୁଇଙ୍ଗ୍ ଡିଗ୍ ଗଗିସିଆ ଆଲେଃକେ ଣ୍ତୁ । ସାରାସାରି ଆତେନ୍‌‌ ସେଲାମ୍ବୁଏ ଡିଗ୍ ଗୁଏୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_23","071_12_23","MRK","12","23","23","ମାତର୍‌ ଗୁକ୍ଲିଗ୍‍ ବୟାଁଣ୍ଡେ ଜାକ ଆମେକେ ବିହେ ଡିଂଲେଃଆର୍‌ଗେ । ଉଃଡ଼ିବେଲା ଗୁଏଃରେଇଂ ଆର୍‌ମୁଇଂତର୍ ତଃଡ଼୍ୟାଆର୍‌ଏ, ତେଲା ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃ ଜାନେ କୁନେଃଣ୍ତେ ଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK12_24","071_12_24","MRK","12","24","24","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଦର୍ମ ସାସ୍ତ୍ରର୍‌ ଆରି ପର୍‌ମେସର୍‌‌ନେ ବପୁ ମାମ୍ୟାଚେ ପେ ସାପାରେ ବାୟାଚେ ଲଃପେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_25","071_12_25","MRK","12","25","25","ରେମୁଆଁଇଙ୍ଗ୍ ଉଃଡ଼ିବେଲା ଗୁଏଚେ ଆର୍‌ମୁଇଂତର୍ ତଡ଼୍ୟାଃଆର୍‌ଏ, ଆତେନ୍‌‌ ବେଲା ଜା ଡିଗ୍ ବିହେ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ମେଇଂ ଆଜାକେ ଡିଗ୍ ବିହେ ଆଡିଙ୍ଗ୍ଆର୍‌ ଣ୍ଡୁ, ମାତର୍‌ ସାପାରେ କିତଂନେ ଦୁତ୍‍ଇଂ ସୁଗା ଡିଙ୍ଗ୍‌ୱେଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK12_26","071_12_26","MRK","12","26","26","ଗୁଏଚେ ତଡ଼ିଆ ପାଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂନେ ବିସୟ୍‌ରେ ପେ ସାପାରେ ମୋଶାନେ ପୁସ୍‌ତକ୍‍ନ୍ନିଆ ଗୁଆର୍‍ବକେ ଜେ ସୁଆ ଡୁଆ ଡିଙ୍ଗ୍‌କ୍ନେ ଲାଟା ବୁଟାନ୍ନିଆ ଲେଃକ୍ନେ ପରମେସର୍ ମୋଶାକେ ବାଲିର୍‌ବକେ, ନେ ଅବ୍ରାହାମ୍‌ନେ ପର୍‌ମେସର୍‌, ଇସାକ୍‌ନେ ପର୍‌ମେସର୍‌ ଆରି ଜାକୁବ୍‌ନେ ପର୍‌ମେସର୍‌ ? ");
INSERT INTO gaq_vpl VALUES ("MK12_27","071_12_27","MRK","12","27","27","ମେଁ ଗୁଏଃରେଇଂନେ ପର୍‌ମେସର୍‌ ଣ୍ଡୁ, ମାତର୍‌ ଜିବନ୍ ଲେଃକ୍ନେ ରେମୁଆଁଇଂନେ ପର୍‌ମେସର୍‌‌, ପେ ସାପାରେ ନାଲେ ପେଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_28","071_12_28","MRK","12","28","28","ଅଃତେନ୍‍ ବେଲା ଗୁରୁଇଂନ୍ନିଆ ବାନ୍ ମୁଇଂଜା ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ମେଇଂନେ ୱିଙ୍ଗ୍‌ଆ ରିଙ୍ଗ୍‍ଆଃ ଅଁଚେ ଆରି ଜିସୁ ସାଦୁକୀଇଂକେ ଜ୍ଞାନ୍‍ନେ ଉତର୍ ବିଃଡିଙ୍ଗ୍‌କେ ଏନ୍ ମ୍ୟାଚେ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ ଆଣ୍ଡିନେ ଆଦେସ୍‌ ସାପାବାନ୍‍ ମ୍ନା ? ");
INSERT INTO gaq_vpl VALUES ("MK12_29","071_12_29","MRK","12","29","29","ଜିସୁ ଉତର୍ ବିକେ, “ସାପାବାନ୍‌ ମ୍ନା ସାମୁଆଁ ଡିଂକେ ଦେକ୍‌ରକମ୍; ଏ ଇଶ୍ରାୟେଲ ଅଁପା । ନେନେ ମାପ୍ରୁ ପର୍‌ମେସର୍‌ ମୁଇଙ୍ଗ୍ ମାତର୍‌ ମାପ୍ରୁ । ");
INSERT INTO gaq_vpl VALUES ("MK12_30","071_12_30","MRK","12","30","30","ଆରି ପେ ନିଜର୍‌ନେ ସାପା ଆତ୍ମାନ୍ନିଆ ସାପା ଜିବନ୍ ଆରି ମନ୍ ଆରି ସାପା ବପୁ ବିଚେ ପେ ନିଜର୍‌ ମାପ୍ରୁ ପର୍‌ମେସର୍‌କେ ଆଲାଦ୍ ଡିଂପା । ");
INSERT INTO gaq_vpl VALUES ("MK12_31","071_12_31","MRK","12","31","31","ଦୁତିୟ ମ୍ନା ସାମୁଆଁ ଡିଂଡିଂକେ, ପେ ନିଜେକେ ଡିରକମ୍ ଆଲାଦ୍ ଡିଂପେମ୍ୟାକେ । ପେ ଡୁଆ ଡାଗ୍ରା ଣ୍ଡ୍ରେକେ ଦେତ୍‌ରକମ୍ ଆଲାଦ୍ ଡିଂପା । ଆକେନ୍ ମ୍ବାକ୍ଲିଗ୍ ସାମୁଆଁ ଆନ୍ତାର୍ଚେ ଆରି ମ୍ନା ସାମୁଆଁ ମେଃ ଡିଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_32","071_12_32","MRK","12","32","32","ଆକେନ୍ ଅଁଚେ ଦର୍ମସାସ୍ତ୍ରି ମୁଇଂଜା ବାସଙ୍ଗ୍‌କେ, “ଗୁରୁ ମାପ୍ରୁ ପର୍‌ମେସର୍‌ ଜେ ମୁଇଙ୍ଗ୍ ଆରି ଆମେକେ ଆନ୍ତାର୍‌ଚେ ଆରି ବିନ୍ ଜା ଡିଗ୍ ଣ୍ଡୁ ଆକେନ୍ ନାଁ ସତ୍ ବାଲିର୍‌ ନାବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_33","071_12_33","MRK","12","33","33","ନେଙ୍ଗ୍ ମ୍ୟା ନ୍ଲେକେ ମୁଇଂଜା ରେମୁଆଁ ସାପା ଗାଗ୍‌ଡ଼େ ସାପା ମନ୍‍ ଆରି ସାପା ସକତ୍‌ ବିଚେ ପର୍‌ମେସର୍‌କେ ଆଲାଦ୍ ଡିଂନେ ପଡ଼େଏ । ମେଁ ଡିରକମ୍ ନିଜେକେ ଆଲାଦ୍ ଡିଂଏ, ଆମେକେ ବିନ୍‌ଣ୍ଡ୍ରେକେ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ଆଲାଦ୍ ଡିଂନେନ୍‌ସା ପଡ଼େଏ । ନେଁ ପର୍‌ମେସର୍‌କେ ଉଡ଼ି ପସୁ ଡାଗ୍‌ଚେ ସାର୍ଦାରେ ଦାନ୍ ବିନେଃଡିଂକେ, ଆତେନ୍‌ ସାପାବାନ୍ ଆକେନ୍ ମ୍ୱାକ୍ଲିଗ୍‍ ସାମୁଆଁ ଜାବର୍ ମ୍ନା ସାମୁଆଁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_34","071_12_34","MRK","12","34","34","ଜିସୁ କେକେ ଜେ ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ଦ୍ରିଗ୍‍ଚେ ଏତେଚେ ଉତର୍ ବିଃବକେ । ମେଁ ଆମେକେ ବାଲିର୍‌କେ, “ପେ ସାପାରେ ପର୍‌ମେସର୍‌ନେ ରାଜିବାନ୍ ସ୍ଲ ଣ୍ତୁ ।” ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ଆରି ଜାଣ୍ତେ ଡିଗ୍‌ ଜିସୁକେ ମେଃଡିଗ୍‌ ପ୍ରସ୍‌ନ ସାଲିଆକୁନ୍‌ସା ସାଆସ୍ ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK12_35","071_12_35","MRK","12","35","35","ଜିସୁ ମନ୍ଦିର୍‌ଅରିଆ ମାପ୍ରୁନେ ସାମୁଆଁ ବିଃନେ ବେଲା ସାଲିଆକୁକେ, “କିସ୍‌ଟ ଜେ ଦାଉଦନେ ଉଙ୍ଗ୍‌ଡେ ଆକେନ୍ ଦର୍ମ ସାସ୍ତ୍ରିଇଂ ଡିରକମ୍ ବାସଙ୍ଗ୍‌ ମ୍ୟାଆର୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("MK12_36","071_12_36","MRK","12","36","36","ନିଜେ ଦାଉଦ୍ ପବିତ୍ର ଆତ୍ମା ଏତେ ବାଲିର୍‌ବକେ; ମାପ୍ରୁ ପର୍‌ମେସର୍‌ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁକେ ବାଲିର୍‌ମ୍ୱକେ: ନେଙ୍ଗ୍ ନାନେ ସତ୍ରୁଇଂକେ ନାନେ ଞ୍ଚ ଆଲ ଡୁଂମାପାଙ୍ଗ୍‍ ଜାକ ନା ନେଙ୍ଗ୍‌ନେ ବେସ୍ୟାଃ ପାକା କ ଲାଃଲା ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_37","071_12_37","MRK","12","37","37","“ନିଜେ ଦାଉଦ୍‍ ମସିହକେ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ, ତେଲା ମସିହ ଡିରକମ୍ ଦାଉଦ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ଡିଙ୍ଗ୍‍ୟାଏ ? ରିସିଙ୍ଗ୍‌ ଲେଃକ୍ନେ ରେମୁଆଁଇଙ୍ଗ୍ ଜିସୁନେ ସାମୁଆଁକେ ସାର୍ଦା ମନ୍‌ରେ ଅଁଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_38","071_12_38","MRK","12","38","38","ଜିସୁ ସିକ୍ୟା ବିଃ ଅଲେଙ୍ଗ୍‌ନେ ବେଲା । ମେଁ ବାସଙ୍ଗ୍‌କେ, “ଦର୍ମସାସ୍ତ୍ରିଇଂବାନ୍ ତରକ୍ ଲାଃଲାପା । ମେଇଙ୍ଗ୍ ଚ୍ଲେ ଚ୍ଲେକ୍ନେ ପାଟାଇ ସଚେ ଆଙ୍କ୍‌ଆନ୍ତ୍‌ ଅଲେଙ୍ଗ୍‌ନେ ବଲ୍‌ ବା ମ୍ୟାଃଆର୍‌କେ ଜେ’ ରେମୁଆଁ ଆମେଇଂକେ ସାନ୍ତା ଗାଲି କେଲା ସନ୍‍ମାନ୍‌ କେଆର୍‌ଲେ ଡାଗ୍‌ଚେ; ");
INSERT INTO gaq_vpl VALUES ("MK12_39","071_12_39","MRK","12","39","39","ପାର୍‌ତନା ଡୁଆ ଅରିଆ ମେଇଙ୍ଗ୍ ମ୍ନା ସିଂଆଁସନ୍‌ନ୍ନିଆ କୁକନ୍‌ସା ବଲ୍‌ ବା ମ୍ୟାଆର୍‌କେ । ବଜି ଅରିଆ ମେଇଙ୍ଗ୍ ସାପାରେବାନ୍ ମ୍ନା ଟାନ୍ ବା ନ୍‌ସାଃ ବଲ୍‌ବା ମ୍ୟାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_40","071_12_40","MRK","12","40","40","ମେଇଂ ଗୁଏସାଙ୍ଗ୍‌କୁଏଇଂନେ ଡୁଆ ବାଜାର୍ ନାଲେଚେ ଡୁଂଡ ମ୍ୟାଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଗୁଏସାଙ୍ଗ୍‌କୁଏନେ ଦନ୍ ସମ୍ପତି ନାଲେ ମ୍ୟାଆର୍‌କେ । ନିମାଣ୍ତା ଆସୁଏ ନ୍‌ସା ମେଇଙ୍ଗ୍ ଚ୍ଲେକ୍ନେ ପାର୍‌ତନା ଡିଂମ୍ୟାଆର୍‌କେ । ଦେଃକେନ୍ ରେମୁଆଁଇଂକେ ପର୍‌ମେସର୍‌ ମ୍ନାନେ ଡଣ୍ଡ୍‌ ବିଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK12_41","071_12_41","MRK","12","41","41","ଜିସୁ ମନ୍ଦିର୍‌ ଅରିଆନେ ଦାନ୍ ବିଃନେ ପିଡ଼ି ଡାଗ୍ରା କ ଲେଃଗେ । ରେମୁଆଁଇଙ୍ଗ୍ ଡିରକମ୍ ଦାନ୍‌ ଡିଙ୍ଗ୍‌ନେ ପିଡ଼ି ଅରିଆ ଡାବୁ ବର୍ତି ଆଡିଙ୍ଗ୍ ମ୍ୟାଃଆର୍‌କେ, ଆତେନ୍‌ କିକେଡିଂଗେ । ଜବର୍‌ ସାଉକାର୍‌ ରେମୁଆଁ ଦାନ୍ ବିଃନେ ପିଡ଼ି ଅରିଆ ଜବର୍‌ ଡାବୁ ତ୍ଲାଗ୍ ଆର୍‌ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_42","071_12_42","MRK","12","42","42","ଇଡ଼ିଙ୍ଗ୍ ଗରିବ୍‌ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ମୁଇଙ୍ଗ୍ ଆତ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ ଆରି ଆତ୍ଅରିଆ ମେଁ ମାତର୍‌‌ ମାଲେ ଡାବୁ ତ୍ଲାକ୍‌କେ । ଆତେନ୍‌ ମ୍ୱାକ୍ଲିଗ୍‌ ଡାବୁନେ ମୁଲ୍ୟ ମୁଇଙ୍ଗ୍ ଟାଆଁ ଏତେ ଡିଗ୍ ସମାନ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK12_43","071_12_43","MRK","12","43","43","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମେଁନେ ସିସ୍ଇଂକେ ଡାଗ୍ରା ୱାଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍, ଆକେନ୍ ସାପା ସାଉକାର୍‌ ରେମୁଆଁ ବିଃକ୍ନେ ଦାନ୍‌ବାନ୍‌ ଆକେନ୍ ଗରିବ୍ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ସାପାବାନ୍ ଜବର୍‌ ଡାବୁ ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK12_44","071_12_44","MRK","12","44","44","ମାତର୍‌ ସାଉକାର୍‌ ରେମୁଆଁଇଙ୍ଗ୍ ଡାଗ୍ରା ଜବର୍‌ ଲେଃକେ । ମେଇଙ୍ଗ୍‌ ମେଇଙ୍ଗ୍‌ନେ ଦରକାର୍‌ ଣ୍ତୁନେ ଲୁଆଁକ୍ନେ ଡାବୁବାନ୍‌ ଦାନ୍ ବିଃବଆର୍‌କେ । ମାତର୍‌‌ ଏନ୍ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ଜାବର୍‌ ଗରିବ୍‌ । ଆକେନ୍ ଗରିବ୍‌ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ଡାଗ୍ରା ଉଡ଼ି ଲେଃଗେ; ଆତେନ୍‌‌ ସାପା ଦାନ୍ ବାବ୍‌ରେ ବିଃବକେ । ମେଁ ବ୍ରୁଆ ନ୍‍ସା ଅଃତେନ୍‍ ଆଃ ମାତର୍‌‌ ଲେଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK13_1","071_13_1","MRK","13","1","1","ଜିସୁ ମନ୍ଦିର୍‌ବାନ୍‌ ତାର୍‌ଚେ ୱିଗ୍‌ନେ ବେଲା ମେଁନେ ମୁଇଙ୍ଗ୍‌ ସିସ୍ ଆମେକେ ବାଲିର୍‌କେ, “ଗୁରୁ କେଲାନି ଆକେନ୍ ମନ୍ଦିର୍‌ନେ ସୁନ୍ଦର୍‌ ଡୁଆ ଆଣ୍ଡେଙ୍ଗ୍ ଆରି ମ୍ନାନେ ବ୍ରି ଆଣ୍ଡେଙ୍ଗ୍ ଉଡ଼ି ସୁନ୍ଦର୍‌ ଡିଙ୍ଗ୍‌ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK13_2","071_13_2","MRK","13","2","2","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ପେ ଆକେନ୍ ମ୍ନାନେ ଡୁଆ ଆଣ୍ଡେଙ୍ଗ୍ କେପେଡିଙ୍ଗ୍ ? ଆକେନ୍ ସାପା ମ୍ନା ଡୁଆ ଦଂସ ଡିଙ୍ଗ୍‌ୱେଏ । ସାପା ଜାକ ବ୍ରି ତୁବଃ ଆଡ଼ାତ୍ରା ଡଃବେଗ୍‌ ଲଃଏ । ମୁଇଙ୍ଗ୍ ଡିଗ୍‌ ବ୍ରି ବାରି ମୁଇଂ ବ୍ରି ଆଡ଼ାତ୍ରା ଆଲେଃ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK13_3","071_13_3","MRK","13","3","3","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମନ୍ଦିର୍‌ ସାମ୍‌ନେ ଲେଃକ୍ନେ ଜିତକଣ୍ଡା ଆଡ଼ାତ୍ରା କ ଲେଃକେ । ମେଁନେ ଏତେ ପିତର୍ ଜାକୁବ୍‌ ଜହନ୍‌ ଆରି ଆନ୍ଦ୍ରିୟ ଲେଃଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ଜାଣ୍ଡେ ଆଅଁକେ ସୁଗା ସାଲିଆକୁ ଆର୍‌କେ ଏନ୍ ସାପା ଅଃନା ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_4","071_13_4","MRK","13","4","4","“ଏନ୍ ସାପା ଗଟେନେ ବେଲା ଡିଙ୍ଗ୍ ୱେଗେ ଡାଗ୍‌ଚେ ମେ ଚିନ୍‌ଇଂ ତ୍ନା ମ୍ୟାକେ ଆତେନ୍‌‌ ଆନେକେ ବାସଙ୍ଗ୍‌ପା ?” ");
INSERT INTO gaq_vpl VALUES ("MK13_5","071_13_5","MRK","13","5","5","ଜିସୁ ସିସ୍‌ଇଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ତରକ୍‌ ଲାଲାପା ଜାଣ୍ଡେ ଡିରକମ୍ ଆପେକେ ଜଟେ ଆୟାଆର୍‌ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK13_6","071_13_6","MRK","13","6","6","ଗୁଲୁଏ ନେଙ୍ଗ୍‌ ମ୍ନି ସାଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ମେଇଙ୍ଗ୍‌ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ନେଙ୍ଗ୍ କିସ୍‌ଟ ଡାଗ୍‌ଚେ ମେଇଙ୍ଗ୍ ଗୁଲୁଏ ରେମୁଆଁକେ ଜଟେ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_7","071_13_7","MRK","13","7","7","ଡାଗ୍ରା ଜୁଦ୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ ବାରି ସ୍ଲ ଜୁଦ୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ ଅଁଚେ ପେଇଂ ଇରିୟାଃ ଆୱେଗ୍‌ପା । ଦେକ୍‌ ରକମ୍‌ ଗଟ୍‌ନା ସତେଆ ଗଟେଏ । ମାତର୍‌‌ ଏନ୍ ଅରତ୍‌ ଣ୍ତୁ ଜେ ଜୁଗ୍‌ ଡାନେ ଦିନ୍‌ ପିଙ୍ଗ୍‌ଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK13_8","071_13_8","MRK","13","8","8","ଦେସ୍‌ ଦେସ୍‌ ବିତ୍ରେ ଜୁଦ୍‌ ଡିଙ୍ଗ୍‌ଏ । ମୁଇଂ ରାଜି ବାରି ମୁଇଂ ରାଜିକେ ଅଦିକାର୍‌ ଡିଙ୍ଗ୍‌ ଆରେ । ସାପା ପାକା ବୁମିକମ୍ପ ଡିଙ୍ଗ୍‌ଏ ବାରି ମୁର୍‍ଡି ଡିଙ୍ଗ୍‌ଏ । ଆକେନ୍ ସାପା ସେଲାମ୍ୱଏଇଂ ଗଗିସିଆ ଣ୍ଡିଆ କୁମାନେ ଦୁକାସୁକା ରକମ୍ ସେନୁଗ୍‌ ତରକ୍‌ ଆଡିଙ୍ଗ୍‌ନେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK13_9","071_13_9","MRK","13","9","9","ପେ ସାପାରେ ତରକ୍ ଲାଃଲାପା । ରେମୁଆଁଇଙ୍ଗ୍ ଆପେକେ ବିଚାର୍‌ ଡିଂନେ କୁକୁପାର୍‌ ଡାଗ୍‌ଲା ଡୁଙ୍ଗ୍‌ୱେ ଆର୍‌ଏ । ଆପେ ସାପାରେକେ ମେଇଙ୍ଗ୍ ନେନେ କ‍ଏଦ୍ ଡୁଆ ଆଃଗାଚେ ବଗ୍‌ଆର୍‍ଏ । ନେଙ୍ଗ୍‌ନେ ସିସ୍‌‍ଇଂ ଡିଙ୍ଗ୍‌ପେଲେଃଗେସା ଆପେ ସାପାରେକେ ସାସନ୍‌ ଆରି ଇଃସାଙ୍ଗ୍‌ ଡାଗ୍ରା ସେନୁଗ୍ ଆଃତୁଆଁ ନ୍‌ସା ଜାବର୍‌ ଦସ୍ତି ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ପେ ସାପାରେ ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("MK13_10","071_13_10","MRK","13","10","10","ମାତର୍‌ ଆକେନ୍ ସାପା ଗଟ୍‌ନା ଗଟେନେ ସେ ସାପା ଜାତିନେ ରେମୁଆଁଇଙ୍ଗ୍ ଅରିଆ ବଲ୍‌ ସାମୁଆଁଇଙ୍ଗ୍ ବାଲିର୍‌ଚେ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_11","071_13_11","MRK","13","11","11","ପେଇଂ ବନ୍ଦି ଡିଙ୍ଗ୍‌ଚେ କ‍ଇଦ୍‌ ଡୁଆନ୍ନିଆ ଡୁଂୱେନେ ବେଲା ଆତ୍‌ଅରିଆ ମେଁନେ ପେବାସଙ୍ଗ୍‌ଏ ଏନ୍ ବିସୟ୍‌ରେ ତେରେପେତେ ଆଡିଙ୍ଗ୍‌ଗ୍‌ପା । ଟିକ୍‌ ବେଲା ମେଁନେ ଡିଙ୍ଗ୍‌ନେ ଡିଙ୍ଗ୍‌ଏ ଆତାନ୍‌ ଆପେକେ ଆମ୍ୟାମ୍ୱିଏ । ଆତେନ୍‌‌ ବେଲା ଆପେକେ ନିଜର୍‌ ମନ୍‌ବାନ୍‌ ମେଃଡିଗ୍‌ ବାସଙ୍ଗ୍‌ ଆପଡ଼େ ଣ୍ତୁ । ପେ ମେଁନେ ପେବାସଙ୍ଗ୍‌ଏ ଆତେନ୍‌‌ ପବିତ୍ର ଆତ୍ମା ଆମ୍ୟାବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_12","071_13_12","MRK","13","12","12","ବୟାଁ ବୟାଁକେ ଆରି ଆବା ମେଁନେ ଉଙ୍ଗ୍‌ଡେକେ ବାଗୁଏଃନେସା ନ୍ତି ନା ସର୍‌ପେ ବି'ଆର୍‌ଏ । ଗଡ଼େଇଂ ଆବା ଇୟାଙ୍ଗ୍‍ନେ ବିରଦ୍‌ରେ ତୁଆଁଆର୍‌ଏ ଆରି ଆମେଇଂକେ ବାଗୁଏଃ ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_13","071_13_13","MRK","13","13","13","ପେ ସାପାରେ ନେଙ୍ଗ୍‌ନେ ସିସ୍‌ ଡିଙ୍ଗ୍ ପେଲେକେ ସା ସାପାରେ ଆପେକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌ଏ । ମାତର୍‌ ଜାଣ୍ଡେ ସାରାସାରି ଜାକ ସାହାସ୍ ସାଚେ ଲେଃଏ, ମେଁ ପରିତ୍ରାନ୍‍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_14","071_13_14","MRK","13","14","14","ମାତର୍‌ ପେ ସାପାରେ ଉଡ଼ିବେଲା ଆତେନ୍‌ ଦର୍‌କାର୍ ଣ୍ଡୁନେ ବାଗୁଏନେ ଆବୁଲେ ଜିନିସ୍ ଆଣ୍ଡି ଅରିଆ ମାଲେଃନେ ଦର୍‌କାର୍ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଲେଃନେ ପେକେଏ ଅଃତେନ୍‌ ବେଲା ଜାଣ୍ଡେଇଂ ଜିଉଦା ଇନିନ୍ନିଆ ଲେଃଆର୍‍ଏ ମେଇଂ କଣ୍ଡା ଆଡ଼ାତ୍ରା ୱିର୍ ଡୁଂୱେଲେ; ");
INSERT INTO gaq_vpl VALUES ("MK13_15","071_13_15","MRK","13","15","15","ମୁଡ଼ି ରେମୁଆଁ ଡୁଆନେ ବ୍ଲେସାଂ ଆଡ଼ାତ୍ରା ଲେଏ ମେ ଡୁଆ ବିତ୍ରେ ୱେଚେ ମେଁ ଡିଗ୍ ଡୁଙ୍ଗ୍‍ ୱେନ୍‌ସା ଆଲଃ ଆପାଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MK13_16","071_13_16","MRK","13","16","16","ଡାଗ୍ଲା ଜାଣ୍ଡେ ଲିଜ ଅରିଆ ଲେଃଏ ମେଁ ମେଁନେ ତଗ୍‌ରିଆ ଡୁଂପାଙ୍ଗ୍‌ନେସା ଡୁଆ ଆଣ୍ତେ ଆ‍ୱେଲେ । ");
INSERT INTO gaq_vpl VALUES ("MK13_17","071_13_17","MRK","13","17","17","ଆତେନ୍‌‌ ବେଲା ଆ’ବାଲେ ଲେଃକ୍ନେ ସେଲାମ୍ବୁଏ ଆରି ବିନ୍‌ ଡାଆଁନେ ଗଡ଼େଅ ଲେଃକ୍ନେ ସେଲାମ୍ବୁଏଇଙ୍ଗ୍‌ନେ ମାଲେ କଷ୍ଟ ବା’ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_18","071_13_18","MRK","13","18","18","ଇସ୍‌ପର୍‌ନ୍ନିଆ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ପା ଡିରକମ୍ ଆକେନ୍ ସାପା ରାସଃକ୍ନେ ବେଲା ଆଡିଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("MK13_19","071_13_19","MRK","13","19","19","ମାତର୍‌‌ ଆତେନ୍‌‌ ଦିନାଆଣ୍ଡେଙ୍ଗ୍‌ ଏନ୍ତି କସ୍‌ଟ ପାଂଏ ଜେ’ ଦେତ୍‌ରକମ୍ ମ୍ନା ବିପଦ୍ ପର୍‌ମେସର୍‌ନେ ଆରେବକ୍ନେ ବାନ୍ ଏବେ ଜାକ ଙ୍କାରେ ଗଟେ ଆରି ଅଃନାଡିଗ୍ ଆଗଟେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK13_20","071_13_20","MRK","13","20","20","ଆତେନ୍‌‌ ଚଙ୍ଗ୍‌ନେ ବେଲା ଆଃଗଣ୍ତା ନ୍‌ସା ପର୍‌ମେସର୍‌ ଆବୁଙ୍ଗ୍‌ ବିବକେ । ଡାଗ୍ଲା ଆତେନ୍‌‌ ବେଲା ଆଗଣ୍ଡା ବିବକେ ତେଲା ଜାଣ୍ଡେ ରକ୍ୟା ଆବାଆର୍ ଣ୍ତୁ । ମାତର୍‌‌ ପର୍‌ମେସର୍‌ ଆଜାକେ ସ୍ରିବକେ ମେଇଂନ୍‍ସା ଆତେନ୍‌‌ ବେଲା ଆଗଣ୍ତା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_21","071_13_21","MRK","13","21","21","ଆତେନ୍‌‌ ଦିନା ଆଣ୍ଡେଙ୍ଗ୍ ଉଡ଼ି ରେମୁଆଁ ଆପେ ସାପାରେକେ ବାଲିର୍‌ଏ ଜେ କେଲାପା, ଆକ୍‌ଅରିଆ କିସ୍‌ଟ ଲେଃକେ ମାତର୍‌‌ ସାମୁଁଆଃ କେଲାପା ଆତ୍ ଅରିଆ ମେଁ ଲେଃକେ । ପେ ମାତର୍‌‌ ଆମେଇଂକେ ବିସ୍‌ବାସ୍‌ ଆଡିଙ୍ଗେପା । ");
INSERT INTO gaq_vpl VALUES ("MK13_22","071_13_22","MRK","13","22","22","ବଣ୍ଡ କିସ୍‌ଟ ଆରି ବଣ୍ଡ ବାବବାଦିଇଂ ତ୍ନା ଆର୍‌ଏ । ମେଇଙ୍ଗ୍ ଇରିୟାତୁଗ୍‌ନେ ସୁଗୁଆ କାମ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ଦର୍‌କାର୍ ଡିଙ୍ଗ୍‌ଲା ପର୍‌ମେସର୍‌ ସ୍ରିକ୍ନେ ରେମୁଆଁଇଂକେ ମେଇଙ୍ଗ୍ ନାଲେନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_23","071_13_23","MRK","13","23","23","ତେଲା ତରକ୍ ପେଲେଃଏ । ଏନ୍‌ ସାପା ମାଗଟେନେ ବେଲା ନେଙ୍ଗ୍‌ ଆପେ ସାପାରେକେ ସାମୁଆଁ ଆମ୍ୟା ବଣ୍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MK13_24","071_13_24","MRK","13","24","24","“ଆତେନ୍‌ ଦିନା ଆକେନ୍ ମ୍ନା ବିପଦ୍‌ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ସ୍ନି ସାପା ପାକା ତାଂକିଗ୍ ୱେଏ ଚାଙ୍କୁଆ ଆରି ଆର୍କେ ଆତାର୍‌କିଗ୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK13_25","071_13_25","MRK","13","25","25","କିତଂଇନିବାନ୍‌‌ ଚାଙ୍କୁଆଇଂ ବୁନ୍ଦେ ଲଃଆର୍‌ଏ ଆରି କିତଙ୍ଗ୍ଇନିବାନ୍ ଚାଙ୍କୁଆଇଙ୍ଗ୍ ଜୁଜୁର୍‌ ୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK13_26","071_13_26","MRK","13","26","26","ଆତେନ୍‌ ବେଲା ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେକେ ଜବର୍ ବପୁ ଆରି ମ୍ନା ମ‍ଇମା ଏତେ ତ୍ରିଗ୍‌ଡିଆ ଡାଗ୍ରାବାନ୍ ପାଙ୍ଗ୍‌ନେ ପେକେଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_27","071_13_27","MRK","13","27","27","ନେଙ୍ଗ୍ ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେକେ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଆରାମ୍ ବାନ୍ ଡାକ୍ନେ ଜାକ ପିତୁର୍ ପାକା ମେନେ କିତଗ୍ଇନି ଦୁତ୍ଇଂକେ ବେବିଏ । ମେଇଙ୍ଗ୍ ବାଚେ ବକ୍ନେ ରେମୁଆଁକେ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଆଡ଼ାତ୍ରା ବାନ୍ ସାପା ଜାଗାନ୍ନିଆ ଡୁଂପାଙ୍ଗ୍‌ଚେ ମୁଇଙ୍ଗ୍ ଅରିଆ ରାଃସିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_28","071_13_28","MRK","13","28","28","“ଲିୱା ସ୍ଲାଃ ଆନେକେ ଗିଆନ୍ ବିମ୍ୟା । ଉଡ଼ିବେଲା ମେଁନେ କେନ୍ଦାଇଂନ୍ନିଆ ତ୍ମି ଉଲିଆ ତାର୍‌ଏ ଆତେନ୍‌ ବେଲା ପେ ସାପାରେ ପେମ୍ୟାଏ ଜେ ନ୍ନାଃସେଙ୍ଗ୍ କିଗ୍ ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK13_29","071_13_29","MRK","13","29","29","ନେଙ୍ଗ୍ ଆପେକେ ମେଁନେ ମ୍ୱାସଙ୍ଗ୍‌କେ ଟିକ୍ ଦେତୁଆ ଗଟେଏ । ପେ ସାପାରେ ଉଡ଼ିବେଲା ଦେକ୍‌ରକମ୍ ସାପା ଗଟେନେ ପେକେଏ ଆତେନ୍‌ ବେଲା ବୁଜେପା ଜେ ଆତେନ୍‌ ଜୁଗ୍‍ ପାଙ୍ଗ୍‍ନେ ବେଲା ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MK13_30","071_13_30","MRK","13","30","30","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌ । ଆକେନ୍ ସାପା ମାଗଟେନେ ଜାକ ଆକେନ୍ ରେମୁଆଁଇଙ୍ଗ୍ ମେଃଡିଗ୍ ଲପ୍‍ ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK13_31","071_13_31","MRK","13","31","31","ମଞ୍ଚ୍‌ପୁର୍‌ ଆରି ତ୍ରିଗ୍‌ଡିଆ ଲପ୍ ଡିଙ୍ଗ୍‌ୱେଏ ମାତର୍‌‌ ନେଙ୍ଗ୍‌ ବାସଙ୍ଗ୍‌ମ୍ଵକ୍ନେ ନିମାଣ୍ଡା ସାମୁଆଁ ଅଃନାଡିଗ୍ ଲପ୍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK13_32","071_13_32","MRK","13","32","32","ଆତେନ୍‌ ଦିନା ଆରି ଆତେନ୍‌‌ ବେଲା ଜାଡିଗ୍ ମ୍ୟାଃ ଆୟା ଣ୍ତୁ । କିତଙ୍ଗ୍‍ ଦୁତ୍ ଆରି ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ଜାଣ୍ଡେ ମେଃଡିଗ୍ ଆମ୍ୟାଆର୍ ଣ୍ତୁ । ମାତର୍‌‌ ଆକେନ୍ ସାମୁଆଁ ମ୍ନା ଆବା ପର୍‌ମେସର୍‌ ମ୍ୟାଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK13_33","071_13_33","MRK","13","33","33","ପେ ସାପାରେ କାଲାଆଃ ତରକ୍ ଲାଲାପା କାଲାଆଃ ଉର୍‍ ଲାଲାପା । ମେଃନ୍‌ସା ଡାଗ୍ଲା ଆତେନ୍‌ ବେଲା ଉଡ଼ିବେଲା ପିଙ୍ଗ୍‌ଚାଏ ଆତେନ୍‌‌ ପେ ସାପାରେ ମ୍ୟା ପେୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK13_34","071_13_34","MRK","13","34","34","ଆକେନ୍ ଡେକ୍‌ରକମ୍ ଗଟ୍‌ନା ଡିରକମ୍ ମୁଇଙ୍ଗ୍‌ ରେମୁଆଁ ନିଜେନେ ଡୁଆ ଆନ୍ତାର୍‌ଚେ ବିଦେସ୍‌ ତାର୍ ୱେଏ ଆରି ଚାକର୍‌ଇଂକେ ନିଜର୍ ଡୁଆ ଆଃଉର୍‌ଚେ ଆନ୍ତାର୍‍ଏ ଆରି ଗତିରେଇଂନେ ଆଡ଼ାତ୍ରା ନିଜେନେ ଡୁଆ ଦାଇତ୍‍ ବିଃଚେ ୱେଏ ଆରି ସାପା ଗତିରେଇଂକେ ମେଁନେ ମୁଇଂ ମୁଇଂ ସ୍ଲେ ବିଃଏ ଆରି ର୍ନସାଙ୍ଗ୍‍ ଉର୍‌ଣ୍ଡ୍ରେକେ କାଲାଆଃ ତରକ୍ ଲେଃନ୍‍ସା ଆଦେସ୍ ବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_35","071_13_35","MRK","13","35","35","ତେସା ପେ ସାପାରେ କାଲାଆଃ ତରକ୍ ଡିଂ ଲାଲାପା । ମେଃନ୍‌ସା ଡାଗ୍ଲା ପେ ପେମ୍ୟାକେ ଣ୍ତୁ ଡୁଆନେ ମାଲିକ୍ ଉଡ଼ିବେଲା ଜେ’ ପିଙ୍ଗ୍‌ଚାଏ । ଲମ୍‍ଡିଗ୍‌ ବେଲା ଣ୍ଡୁଲା ମଜେ ମିଡିଗ୍‌ ଣ୍ଡୁଲା ଞ୍ଜିର୍‌ ବେଲା ଡିଗ୍ ମେଁ ପାଙ୍ଗ୍ ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("MK13_36","071_13_36","MRK","13","36","36","ମେଁ ଦାପ୍ରେ ଡିଗ୍ ପାଙ୍ଗ୍ଏ । ପେ ସାପାରେ ଜଦି କାଲାଆଃ ତରକ୍ ପେଲେଏ ତେଲା ମେଁ ଆପେକେ ମେଁ ଅଃନାଡିଗ୍ ଡୁଲେଗ୍‌ଲେଃକ୍ନେ ବେଲା କେଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK13_37","071_13_37","MRK","13","37","37","ନେଙ୍ଗ୍ ଆପେକେ ମେଁ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ, ସାପାରେକେ ଆତେନ୍‌‌ ମୁଇଙ୍ଗ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ଣ୍ଡିଙ୍ଗ୍‌ ଜେ' କାଲାଆଃ ତରକ୍ ଲାଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_1","071_14_1","MRK","14","1","1","ଉଦାର୍‌ ପାଣ୍ଡୁଏ ଆରି ଖମିର ଶୂନ୍ୟ ରୁଟି ପାଣ୍ଡୁଏ ଆରି ବାର୍‌ସି ବାକି ଲେଃକେ । ମ୍ନା ପୁଜାରି ଆରି ଜିଉଦି ଦର୍ମ ଗୁରୁଇଂ ଜିସୁକେ ଚାଲାକିରେ କ‍ଏଦ୍ ଡିଂଚେ ଇଡ଼ିଙ୍ଗ୍ ବାଗୁଏଃ ନ୍‍ସା ଉପାୟ୍‌ ତୁର୍ ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_2","071_14_2","MRK","14","2","2","ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଆର୍‌କେକେ, “ନେ ସାପାରେ ପାଣ୍ଡୁଏନେ ବେଲା ଜିସୁକେ କ‍ଏଦ୍ ଆଡିଙ୍ଗ୍ ନେୟା ଣ୍ଡୁ । ଦେତ୍ ଡିଙ୍ଗ୍‌ଲା ରେମୁଆଁଇଙ୍ଗ୍‌ ରିସା ଡିଂଚେ ୱିଙ୍ଗ୍‌ଆଃରିଂଆଃନ୍‌ସା ପାଂଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_3","071_14_3","MRK","14","3","3","ଜିସୁ ବେଥନୀନ୍ନିଆ କୁଷ୍ଟରଗି ଶିମୋନନେ ଡୁଆ ଚଙ୍ଗ୍‌ନେ କ’ଲେଃନେ ବେଲା ମୁଇଂ ସେଲାମ୍ବୁଏ ରେମୁଆଁ ମେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ । ମେଁ ମୁଇଂ ତୁଲୁଏକ୍ନେ ସବାକ୍ନେ କଁସ୍‌ମୁତା ମାଲେ ଦାମ୍‍ନେ ଞ୍ଚୁ ବର୍‌ତି ଆଡିଙ୍ଗ୍‌ଚେ ଡୁଂପାଙ୍ଗ୍‌କେ । ଆତେନ୍‌ ବାସ୍ନା ଞ୍ଚୁ ନିମାଣ୍ଡାନେ ଜଟା ଚିଲି ଏତେ ଆରେବକେ । ସେଲାମ୍ବୁଏନେ ମୁତା ଡାବ୍‍ନା ତ’ଚେ ସାପା ବାସ୍ନା ଞ୍ଚୁ ଜିସୁନେ ବାଆଃନ୍ନିଆ କିଗ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_4","071_14_4","MRK","14","4","4","ଆତ୍‌ ଅରିଆ ଲେଃକ୍ନେ ଉଡ଼ି ରେମୁଆଁ ମେଁନେ ଏନ୍ କାମ୍ କେଚେ ରିସା ଡିଂଆର୍‌କେ ବାରି ନିଜର୍‌ ନିଜର୍‌ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଆର୍‌କେ “ଏନ୍ ବାସ୍‌ନା ଞ୍ଚୁକେ ଦେକ୍‌ରକମ୍ ବାବ୍‌ରେ ନସ୍ଟ ଆଡିଙ୍ଗ୍‌ନେ ବଲ୍‌ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("MK14_5","071_14_5","MRK","14","5","5","ଆତେନ୍‌ ଞ୍ଚୁକେ ସ ବିଲା ଞ୍ଜି ସ ବାନ୍‌ ମାଲେ ରୁପା ଡାବୁ ପାମିଲେ ବାରି ଆତେନ୍‌‌ ଡାବୁ ଗରିବ୍‌ ରେମୁଆଁକେ ବିପାଡିଙ୍ଗ୍‌ ।” ସେଲାମ୍ବୁଏଃକେ ମେଇଙ୍ଗ୍‌ ବେସି ଅର୍‌ବର୍‌ ଆ'ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_6","071_14_6","MRK","14","6","6","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ରେମୁଆଁକେ ତେରେପେତେ ଆରାଡିଙ୍ଗ୍‌ପା । ମେଁ ନେଙ୍ଗ୍‌ନ୍‌ସା ମୁଇଙ୍ଗ୍ ମାଲେ ନିମାଣ୍ଡା କାମ୍ ଡିଙ୍ଗ୍‌ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_7","071_14_7","MRK","14","7","7","ମେଁନ୍‍ସା ଡାଗ୍ଲା ଗରିବ୍‍ଣ୍ଡ୍ରେଇଂ କାଲାଆଃ ତ ନାଁଡାଗ୍ରା ଲେଃଆର୍‍ଏ । ପେ ଉଡ଼ିବେଲା ପେକେଏ ଆମେଇଂକେ ସାହା ଡିଙ୍ଗ୍‌ପେୟାଏ । ମାତର୍‌ ପେଇଙ୍ଗ୍‌ ଆନେଙ୍ଗ୍ କାଲାଆଃ ପେ ପେଅବା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK14_8","071_14_8","MRK","14","8","8","ଆକେନ୍ ସେଲାମ୍ବୁଏ ନେଙ୍ଗ୍ ସା ମେଁନେ ଡିଙ୍ଗ୍‍ନେସା ବପୁଲେଃକେ ମେଁ ଆତେନ୍‌ ଡିଙ୍ଗ୍ ବକେ । ରାଃଚ୍ୟାନିଆ ନେଙ୍ଗ୍ ପାରାନ୍‌କେ ଆ’ରେଡିଙ୍ଗ୍‍ନ୍‌ସା ମେଁ ନେଙ୍ଗ୍ ଗାଗ୍‌ଡ଼େନ୍ନିଆ ଗୁଏନେ ସେନୁଗ୍‍ ବାସ୍‌ନା ଞ୍ଚୁ କିଗ୍‍ବି ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_9","071_14_9","MRK","14","9","9","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଣ୍ତିଙ୍ଗ୍‌କେ, ସାପା ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ନେଙ୍ଗ୍‌ନେ ନିମାଣ୍ତାସାମୁଆଁ ଆଣ୍ତିଡାଗ୍ରା ବାସଙ୍ଗ୍‌‌ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ଏନ୍ ସେଲାମ୍ବୁଏଃ ମେ ଡିଙ୍ଗ୍‌ବକେ ଆତାନ୍‌ ମନେ ତ୍ଲାଗ୍‌ନ୍‌ସା ଏନ୍ ସାପା ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_10","071_14_10","MRK","14","10","10","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଗମ୍ୱାର୍ ସିସ୍‍ ପ୍ରେରିତ୍‌‍ଇଂବାନ୍ ମୁଇଂଜା ପ୍ରେରିତ୍‌ ମ୍ନା ପୁଜାରିଇଂ ଏତେ ବାଲିର୍ ମାବା ଡିଙ୍ଗ୍‍ନ୍‍ସା ୱେକେ । ଆକେନ୍ ପ୍ରେରିତ୍‌ନେ ମ୍ନିଲେଃକେ ଇଷ୍କରିୟଥ୍ ଜିଉଦା । ମେଁ ଜିସୁକେ ମ୍ନା ପୁଜାରିଇଂନେ ନ୍ତି ନ୍ନିଆ ଆସା ବିନେସା ଚାଏଁଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_11","071_14_11","MRK","14","11","11","ମ୍ନା ପୁଜାରିଇଂ ଜିଉଦାନେ ଆକେନ୍ ସାମୁଆଁ ୱେଚେ ଜବର୍ ସାର୍ଦା ଡିଙ୍ଗ୍‌କେ । ଆରି ଆମେଇଂକେ ଡାବୁ ବିନ୍‍ସା ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍ ବକେ । ଆତ୍‌ଅରିଆ ଜିଉଦା ଜିସୁକେ ମ୍ନାନେ ପୁଜାରିଇଂନେ ନ୍ତି ନ୍ନିଆ ଆଃସା ବିଃନ୍‌ସା ଉପାୟ୍‍ ତୁର୍ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_12","071_14_12","MRK","14","12","12","ଉଦାର୍‍ନେ ପାଣ୍ଡୁଏଃ ଆରି ଖମିର ଶୂନ୍ୟ ରୁଟି ପାଣ୍ଡୁଏଃନେ ସେନୁଗ୍ ଦିନ୍ ଜିଉଦିଇଙ୍ଗ୍ ଉଦାର୍ ପାଣ୍ଡୁଏଃ ନ୍‌ସା ମେଣ୍ଡା ଉଙ୍ଗ୍‌ଡେକେ ସିଃଆର୍‌ଏ । ଆତେନ୍‌ ସ୍ମି ଜିସୁନେ ଡାଗ୍ରା ମେଁଇଙ୍ଗ୍‌ନେ ସିସ୍ଇଂ ପାଙ୍ଗ୍‌ଚେ ସାଲିଆଃକୁକେ, “ଉଦାର୍ ପାଣ୍ଡୁଏ ବଜିନ୍ନିଆ ନାଁ ନ୍‌ସା ସାପା କିଚି ଆରେନ୍‍ସା ଆଣ୍ଡିନେୱେ ଡାଗ୍‌ଚେ ନାଁ ଚାଏଁନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK14_13","071_14_13","MRK","14","13","13","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମ୍ବାୟା ସିସ୍‌କେ ସହର୍‌ନ୍ନିଆ ବେକେ । ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ସହର୍‍ନିଆ ୱେଲାପା । ମୁଇଂ ରେମୁଆଁ ଣ୍ଡିଆକୁଇ ଡୁଂୱେ ଡିଙ୍ଗ୍‌କ୍ନେ ପେକେଏ । ଆତେନ୍‌ ରେମୁଆଁ ପେ ଡାଗ୍ରା ପାଙ୍ଗ୍ଏ । ପେ ମେଁ ପ୍ଲା ପେୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("MK14_14","071_14_14","MRK","14","14","14","ଆତେନ୍‌ ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ଡୁଆ ଗାଏ ପେଡିଗ୍ ୱେଚେ ଆତେନ୍‌ ଡୁଆନେ ମାଲିକ୍‌କେ ପେବାସଙ୍ଗ୍ ଜେ’ ଗୁରୁ ବେ’ବକେ ନେଙ୍ଗ୍‌ନେ ସିସ୍ଇଂଏତେ ଉଦାର୍ ପାଣ୍ଡୁଏ ବଜି ଆଣ୍ଡିନେ ବାକ୍‌ରାନ୍ନିଆ ମ୍ପାଲେଏ, ଆତେନ୍‌ ବାକ୍‍ରା ଆନେଙ୍ଗ୍ ଆସୁଏ ବିଲା ? ଆମେକେ ବାସଙ୍ଗ୍ ଜେ’ ଗୁରୁ ଆକେନ୍ ମ୍ୟାନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_15","071_14_15","MRK","14","15","15","ଡୁଆ ମାଲିକ୍‌ ପେଇଙ୍ଗ୍‌ନେସା ଆଡ଼ାତ୍ରା ମହଲାନେ ସାପା କିଚି ସଜେବକେ ମୁଇଙ୍ଗ୍ ମ୍ନା ଡୁଆ ଆଃସୁଏ ବିଏ । ପେ ସାପାରେ ଆ‍ତ୍‍ ଅରିଆ ଚଙ୍ଗ୍‌ନେ ଆର୍ମେ ବପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_16","071_14_16","MRK","14","16","16","ଇଡ଼ିଙ୍ଗ୍ ସିସ୍ଇଂ ଆତ୍‌ବାନ୍ ସହର୍‍ନ୍ନିଆ ୱେଆର୍କେ । ଜିସୁ ଆମେଇଂକେ ମେଁନେ ବାସଙ୍ଗ୍ ବକେ ସାପା ସାମୁଆଁ ଦେତୁଆ ଡିଙ୍ଗ୍‌କେ । ଆତ୍‍ ଡାଗ୍ରା ମେଇଂ ଉଦାର୍ ପାଣ୍ଡୁଏ ଚଙ୍ଗ୍‌ନେ ତିଆର୍ ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_17","071_14_17","MRK","14","17","17","ଲମ୍‍ଡିଗ୍ ବେଲା ଜିସୁ ଗମ୍ୱାର୍ ରେମୁଆଁ ସିସ୍‌‍ଇଂକେ ସଙ୍ଗେ ସାଃଚେ ଆତ୍ ଅରିଆ ୱେଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_18","071_14_18","MRK","14","18","18","ମେଇଂ ଚଙ୍ଗ୍‌ନେ ବେଲା ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‍ଣ୍ଡିଂକେ ମାତର୍‌ ନେଙ୍ଗ୍ଏତେ ଚଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ପେନେ ବାନ୍ ମୁଇଂଜା ନେଙ୍ଗ୍ ଆତ୍‍ଲା ବିରଦ୍‍ଣ୍ଡ୍ରେନେ ନ୍ତି ଅରିଆ ସର୍‍ପେ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_19","071_14_19","MRK","14","19","19","ଆକେନ୍ ଅଁଚେ ସିସ୍‌ଇଙ୍ଗ୍‌ ଜବର୍ ମନ୍‌ ଦୁକ୍ ଡିଙ୍ଗ୍ କିକେ । ସାପାରେ ଜିସୁକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ସତେଆଃ ନେଙ୍ଗ୍ ଆତେନ୍‌ ରେମୁଆଁ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_20","071_14_20","MRK","14","20","20","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଆତେନ୍‌ ରେମୁଆଁ ପେ ଗୋମ୍ୱାର୍ ରେମୁଆଁ ବାନ୍ ମୁଇଂଜା ଜାଣ୍ଡେ କି ନେଙ୍ଗ୍ ଏତେ ମୁଇଙ୍ଗ୍ ଗିନାନ୍ନିଆ ରୁଟି ଜଣ୍ଡିଆ ଞ୍ଚଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_21","071_14_21","MRK","14","21","21","ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ୱେଚେ ଗୁଏଃଏ । ଆକେନ୍ ଗଟେଏ ଡାଗ୍‌ଚେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍ ବକେ । ମାତର୍‌ ମୁଃଡ଼ି ରେମୁଆଁବାନ୍‌ ମାପ୍‌ରୁ ଉଂଡେକେ ବିରଦ୍‍ଣ୍ଡ୍ରେନେ ନ୍ତି ଡାଗ୍‌ରା ଆସା ବିଏ, ମେଁ ଜନମ୍ ଆଡିଙ୍ଗ୍‌ଲା ନିମାଣ୍ଡା ପାଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_22","071_14_22","MRK","14","22","22","ମେଇଙ୍ଗ୍ ଚଙ୍ଗ୍ ବେଲା ଜିସୁ ଇକୁଡ଼ା ରୁଟି ଡୁଂୱେଚେ । ଆତେନ୍‌ ରୁଟିନ୍‍ସା ପର୍‌ମେସର୍‌କେ ଦନ୍ୟବାଦ୍ ବିକେ । ରୁଟି ଟିକ୍‌ଚିଚେ ସିସ୍‌ଇଂକେ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍ ରୁଟି ଡିଂଡିଂକେ ନେଙ୍ଗ୍‌ନେ ଗାଗ୍‌ଡ଼େ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_23","071_14_23","MRK","14","23","23","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଅଙ୍ଗୁର୍ ରସ୍‌ନେ ମୁତା ଡୁଂୱେଗେ । ମେଁନ୍‌ସା ପର୍‌ମେସର୍‌କେ ଦନ୍ୟବାଦ୍ ବିକେ । ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ସିସ୍‌ଇଂକେ ବିକେ । ମାନ୍ଦାରେ ଆତେନ୍‌ ମୁତାନେ ଅଙ୍ଗୁର୍ ରସ୍ ଉଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_24","071_14_24","MRK","14","24","24","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍ ନେଙ୍ଗ୍‌ନେ ମ୍ୟା । ନେଙ୍ଗ୍‌ନେ ମ୍ୟା ମୁଇଙ୍ଗ୍‌ ତ୍ମିନେ ନିଅମ୍ ଆରାମ୍ ଆଃଡିଙ୍ଗ୍ଏ । ଏନ୍ ନିଅମ୍‌ଲେ ପର୍‌ମେସର୍‌‌ବାନ୍ ମେଇଙ୍ଗ୍ ରେମୁଆଁନ୍‌ସା ଡିଙ୍ଗ୍ଏ । ଏନ୍‌ ମ୍‌ମ୍ୟାଁ ସାପା ରେମୁଆଁନ୍‌ସା ବି’ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_25","071_14_25","MRK","14","25","25","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଡିଙ୍ଗ୍ । ନେଙ୍ଗ୍ ଅନା ଜାକ ପର୍‌ମେସର୍‌ନେ ରାଇଜ୍‍ନ୍ନିଆ ତ୍ମି ଅଙ୍ଗୁର୍ ରସ୍ ଉଁଗ୍‌ଏ ଆତେନ୍‌ ଦିନା ଜାକ ଏନ୍‌ ଅଙ୍ଗୁର୍ ରସ୍ ନେଙ୍ଗ୍ ଅଃନା ଡିଗ୍ ନାଉଗ୍‌ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_26","071_14_26","MRK","14","26","26","ସାପା ସିସ୍‌ଇଙ୍ଗ୍‌ କୁଡ଼େଃଚେ ମୁଇଙ୍ଗ୍ ଦନ୍ୟବାଦ୍ ଅସ୍‌ମାର୍ ସାର୍‌ଚେ ଆରି ଇଡ଼ିଙ୍ଗ୍ ଜିତକଣ୍ଡା ଆଡ଼ାତ୍ରା ତାର୍ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_27","071_14_27","MRK","14","27","27","ଜିସୁ ସିସ୍‌ଇଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ପେ ସାପାରେ ବିସ୍‌ବାସ୍ ମାବଚେ ପେକେଏ, ଆକେନ୍ ସାସ୍ତର୍‌ନିଆ ଗୁଆର୍‍ବକେ, ନେଙ୍ଗ୍ ମେଣ୍ଡା ତୁର୍‌ତ୍ୟାରେକେ ବାଗୁଏ ମ୍ବିଏ ଆରି ମେଣ୍ଡାଇଂ ଆଙ୍କ୍ ଆନ୍ତ୍‍ ଡଣ୍ଡିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK14_28","071_14_28","MRK","14","28","28","ମାତର୍‌ ନେଙ୍ଗ୍ ଗୁଏଚେ ମ୍ୱ୍ରକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ପେନେ ସେନୁଗ୍‍ ଗାଲିଲୀ ପ୍ରଦେସ୍ ୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_29","071_14_29","MRK","14","29","29","ମାତର୍‌ ପିତର୍ ବାସଙ୍ଗ୍‌କେ, “ବିନ୍‌ ସାପା ସିସ୍‌ଇଂ ଆନାକେ ଆନ୍ତାର୍‍ ୱେଆର୍‌ଲା ଡିଗ୍ ନେଙ୍ଗ୍ ମୁଲ୍‌କେ ନ୍ନାୱେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_30","071_14_30","MRK","14","30","30","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଣ୍ଡିଙ୍ଗ୍‌କେ ଏଃ ମିଡିଗ୍ ଗିସେଙ୍ଗ୍ ମ୍ୱାର୍‌ତର୍ ସନେ ସେନୁଗ୍‌ ନା ଆନେଙ୍ଗ୍ ନ୍ନାସାମୁଆଁକେ ଡାଗ୍‌ଚେ ଞ୍ଜିତର୍ ନାବାସଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_31","071_14_31","MRK","14","31","31","ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ ପିତର୍ ଆରି ମାଲେ କିରଚେ ବାସଙ୍ଗ୍‌କେ, “ଆନେଙ୍ଗ୍ ନାଁ ଏତେ ଗୁଏନେ ପଡ଼େଲା ଡିଗ୍ ନେଙ୍ଗ୍ ଆନାକେ ନ୍ନାସାମୁଆଁକେ ଡାଗ୍‌ଚେ ଅଃନାଡିଗ୍ ନ୍ନାବାସଙ୍ଗ୍ ଣ୍ଡୁ ।” ବିନ୍‌ ସାପାରେ ସିସ୍‌ଇଂ ଡିଗ୍ ଦେତୁଆ ବାଲିର୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_32","071_14_32","MRK","14","32","32","ଜିସୁ ଆରି ମେନେ ସିସ୍ଇଂ ଗେଥସିମନୀ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ଡୁଗ୍‌ଡିନ୍ନିଆ ପାଙ୍ଗ୍ ଆର୍‌କେ । ଜିସୁ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ଜାକ ପେ ସାପାରେ ଆକ୍‌ଅରିଆ କଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_33","071_14_33","MRK","14","33","33","ମେଁ ପିତର୍ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌କେ ମେଙ୍ଗ୍‌ ଏତେ ପାଙ୍ଗ୍‌ନେ ବାସଙ୍ଗ୍‌କେ । ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମାଲେ ତାନ୍ଦ୍ରା ଡିଙ୍ଗ୍‌ଚେ ଆରି ଦୁକ୍ ଡିଙ୍ଗ୍‌ନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_34","071_14_34","MRK","14","34","34","ଜିସୁ ପିତର୍ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‌ନେ ଜିବନ୍ ତାର୍‌ୱେଗେ ସୁଗୁଆ ଲାଗେଡିଙ୍ଗ୍‍କେ । ଆକ୍‌ଅରିଆ ପେ ନେଙ୍ଗ୍‌ସା ଉର୍‍ ଲାଃଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_35","071_14_35","MRK","14","35","35","ଜିସୁ ମେଇଂନେ ବାନ୍ ଇକୁଡ଼ା ଉଡ଼ି ସ୍ଲ ଅଲେଙ୍ଗ୍ ୱେଚେ । ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ତୁବନ୍ନିଆ ଲଃଚେ ଆରି ପାର୍‌ତନା ଡିଙ୍ଗ୍‍କେ ଜେ’ “ଜଦି ଡିଙ୍ଗ୍‌ଏ ତେଲା ନେଙ୍ଗ୍ ବାନ୍ ସ୍ଲ ୱେଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_36","071_14_36","MRK","14","36","36","ଅ ନେଙ୍ଗ୍‌ନେ “ଆବା ନା ଆଡ଼ାତ୍ରା ସାପା ଡିଙ୍ଗ୍‌ଏ । ଏନ୍ ଦୁକାନେ ଉଗ୍‌ଡିଆଃନେ ମୁତାକେ ନେଙ୍ଗ୍‌ ବାନ୍‌ ସ୍ଲ ଡୁଂୱେଲା । ଏଲେଡିଗ୍ ନେଙ୍ଗ୍‌ନେ ଇଚା ଣ୍ତୁ ନାନେ ଇକ୍‌ଚା ପୁରନ୍‌ ଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_37","071_14_37","MRK","14","37","37","ତେନ୍‌ଇଡ଼ିଂ ଜିସୁ ଆମେଇଂକେ କେକେ ବାରି ସିସ୍‌‍ଇଂନେ ଡାଗ୍ରା ଆଣ୍ଡେ ୱିଗ୍‌କେ । ମେଁ ମେଇଂକେ ଡୁଲେଗ୍ ଲେଃକ୍ନେ କେକେ । ମେଁ ପିତର୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ଶିମୋନ ପେ ଡୁଲେଗ୍ ପେବିଗେ ? ପେ ମୁଇଙ୍ଗ୍ ଗଣ୍ଟା ନ୍‌ସା ଉର୍‌ଲେଃ ପେୟାକେ ? ");
INSERT INTO gaq_vpl VALUES ("MK14_38","071_14_38","MRK","14","38","38","ଉର୍‌ଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ଜେ’ ପେ ଡିଃଡି କି ପରିକ୍ୟାନ୍ନିଆ ପେଲ । ଆଣ୍ଡିନେ ଟିକ୍ ପେନେ ଆତ୍ମା ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ନେ ଚାଏଁଡିଂକେ ମାତର୍‌ ପେନେ ଗାଗ୍‌ଡ଼େ ପର୍‌ଚଲ୍‌ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_39","071_14_39","MRK","14","39","39","ଜିସୁ ଆରି ମୁଇଂ ତର୍ ୱେଚେ ସେ ସୁଗା ପାର୍‌ତନା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_40","071_14_40","MRK","14","40","40","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ସିସ୍‌‍ଇଂନେ ଡାଗ୍ରା ଆଣ୍ଡେ ପାଙ୍ଗ୍‌କେ ଆରି କେକେ ଜେ ମେଇଙ୍ଗ୍ ଆରି ଡୁଲେଗ୍ ଲେଃଆର୍‌କେ । ମେଁଙ୍ଗ୍‌ନେ ମୁଆଃ ଲେମୁଆଃ ଡା ଡୁଂପାଂଡିଂ । ସିସ୍‌ଇଂ ମ୍ୟା ଆୟା ଆର୍‌କେ ଣ୍ଡୁ ଜେ ମେଇଙ୍ଗ୍‌ ଜିସୁକେ ମେଁନେ ଉତର୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MK14_41","071_14_41","MRK","14","41","41","ଜିସୁ ଞ୍ଜିତର୍ ପାର୍‌ତନା ଆଃଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ସିସ୍‌ଇଂ ଡାଗ୍ରା ଆରି ପାଙ୍ଗ୍‌ଆର୍‌କେ ଆରି ବାସଙ୍ଗ୍ କିକେ “ଏବେ ଡିଗ୍ ପେ ଡୁଲେଗ୍‌ଚେ ପୁଣ୍ଡେ ପେଡିଙ୍ଗ୍‍କେ ? ଜବର୍ ବେଲା ଡିଙ୍ଗ୍‌କେ । ଡାଗ୍ଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପାପିଇଂ ନ୍ତି ନ୍ନିଆ ଆଃସାଃ ବିଃନେ ବେଲା ଡାଗ୍ରା ପାଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_42","071_14_42","MRK","14","42","42","ତଡ଼ିଆପା । ନେ ଏଃତର୍ ନେୱେପା । ଆନେଙ୍ଗ୍ ସତ୍ରୁ ନ୍ତିନିଆ ଆଃସା ବିନେ ରେମୁଆଁ ଏବେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_43","071_14_43","MRK","14","43","43","ଜିସୁ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ନେ ବେଲା ଜିଉଦା ପିଙ୍ଗ୍‍ଚାକେ । ମେଁ ଗମ୍ୱାର୍ ରେମୁଆଁ ପ୍ରେରିତ୍ଇଂ ବାନ୍ ମୁଇଂଜା ଲେଃକେ । ମେଁ ଏତେ ମାଲେ ରେମୁଆଁ ଲେଃକେ । ଆତେନ୍‌ ରେମୁଆଁଇଂକେ ମ୍ନାଃ ପୁଜାରି, ଦର୍ମସାସ୍ତ୍ରି ଆରି ଡକ୍ରା ଜିଉଦି ନେତାଇଂ ବେବଆର୍ଗେ । ଜିଉଦା ଆରି ଆତେନ୍‌ ରେମୁଆଁଇଂ ନ୍ତିନ୍ନିଆ କାଣ୍ଡା ଆରି ଟେଙ୍ଗ୍ ସାଃ ଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_44","071_14_44","MRK","14","44","44","ବିରଦ୍ ରେମୁଆଁଇଂକେ ଆସା ବିଃନ୍‌ସା ଜିହୁଦା ଆମେଇଂକେ ମୁଇଙ୍ଗ୍ ଚିନା ବିଃନ୍‍ସା ଟିକ୍ ଆଡିଙ୍ଗ୍ ବଗେ । ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‍ବଗେ, “ମୁଡ଼ି ରେମୁଆଁକେ ନେଙ୍ଗ୍ ମ୍ୱୟ୍‍ନ୍ତାଏ ଆମେକେ ଆଃ ପେ ତୁର୍ ପେଡିଙ୍ଗ୍‌କେ । ଆମେକେ ପେ ପେସାଃଏ । ପେ ଆମେକେ କ‍ଏଦ୍ ପେରାଡିଙ୍ଗ୍‍ଏ ଆରି ଜାଗ୍ରତ୍ ରେ ସ୍ଲ ଡୁଙ୍ଗ୍‍ ପେୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_45","071_14_45","MRK","14","45","45","ଦାପ୍ରେ ଜିଉଦା ଜିସୁନେ ଡାଗ୍ରା ୱେଚେ ବାସଙ୍ଗ୍‌କେ, “ଗୁରୁ ।” ଇଡ଼ିଙ୍ଗ୍ ଜିଉଦା ଜିସୁକେ ବୈନ୍ତା ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_46","071_14_46","MRK","14","46","46","ଆକେନ୍ ବେଲା ରେମୁଆଁଇଙ୍ଗ୍ ଜିସୁକେ ସାଚେ ଗାଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_47","071_14_47","MRK","14","47","47","ଜିସୁ ଡାଗ୍ରା ତୁଆଁ ଲେଃକ୍ନେ ମୁଇଂଜା ସିସ୍‌ ମେଁନେ କାଣ୍ଡା ଆତାର୍‌ଚେ ମ୍ନା ପୁଜାରିନେ ମୁଇଂ ଗତିରେକେ ସି । ଆତେନ୍‌ ଗତିରେନେ ନ୍‍ଲୁଗ୍ ଟିକ୍‌ଚିୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_48","071_14_48","MRK","14","48","48","ଜିସୁ ଆତେନ୍‌ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ମେଁନେ ମୁଇଙ୍ଗ୍ ଦସିଣ୍ଡ୍ରେ ଜେ ପେଇଙ୍ଗ୍ କାଣ୍ଡା ଆରି ଟେଙ୍ଗ୍ ଡୁଂପାଙ୍ଗ୍‍ଚେ ଆନେଙ୍ଗ୍ ସାହାନ୍‌ସା ପାଙ୍ଗ୍ ପେଲେ ? ");
INSERT INTO gaq_vpl VALUES ("MK14_49","071_14_49","MRK","14","49","49","ଦିନ୍‍କେ ମନ୍ଦିର୍‍ନ୍ନିଆ ସିକ୍ୟା ବିଃନେ ବେଲା ନେଙ୍ଗ୍ ପେଏଃତେ ଲେଃଣ୍ଡିଂଗେ । ମାତର୍ ଆତେନ୍‌ ବେଲା ପେ ଆନେଙ୍ଗ୍‌କେ ପେଗାଗ୍‌କେ । ମାତର୍‌ ସାସ୍ତର୍ ଡିରକମ୍‌ ଗୁଆର୍‌ବକେ ଆତେନ୍‌ ଦେତ୍ ରକମ୍ ଗଟେଡିଙ୍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_50","071_14_50","MRK","14","50","50","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁକେ ସିସ୍‌ଇଂ ଆନ୍ତାର୍‌ଚେ ଡ‍ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_51","071_14_51","MRK","14","51","51","ମୁଇଂ ଙ୍ଗିରେ ଜିସୁନେ ପ୍ଲା ୱେଡିଙ୍ଗ୍‍ଗେ । ମେଁ ଡିଲାଡିଗ୍ ଇକୁଡ଼ା ଡାଆଁନେ ସୁତା ପାଟାଇ ଗ୍ୱାଲେଗ୍ ଲେଃକେ । ଆତେନ୍‌ ରେମୁଆଁଇଂ ଙ୍ଗିର୍‍ବ‍ଏକେ ସାଃନ୍‌ସା ଉପାୟ୍‌ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_52","071_14_52","MRK","14","52","52","ମେଁ ପାଟାଇ ତବିଚେ ଆରି ଲାଙ୍ଗ୍‍ଲା ଡିଙ୍ଗ୍‌ଚେ ଡଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_53","071_14_53","MRK","14","53","53","ଆତେନ୍‌ ରେମୁଆଁଇଂ ଜିସୁକେ ମ୍ନା ପୁଜାରିନେ ଡାଗ୍ରା ଡୁଂୱେଆର୍‌କେ । ସାପାରେ ମ୍ନାଃ ପୁଜାରି ଦର୍ମ ନେତାଇଂ‍ ଦର୍ମସାସ୍ତ୍ରିଇଂ ସାପାରେ ପାଙ୍ଗ୍‌ଚେ ମୁଇଂନ୍ନିଆ ରିସିଙ୍ଗ୍‍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_54","071_14_54","MRK","14","54","54","ପିତର୍ ଜିସୁନେ ବାନ୍ ସ୍ଲ ଲେଃଚେ ମେଁନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଚେ ମ୍ନା ପୁଜାରିନେ ଡୁଆନେ ବାଜାର୍‍ ଅରିଆ ପିଙ୍ଗ୍‍ଚାକେ । ମେଁ ଆତ୍‍ ଅରିଆ ଉର୍‌ଣ୍ଡ୍ରେଏତେ କ ଲେଃଚେ ସୁଆନ୍ନିଆ ର୍ନିଃ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_55","071_14_55","MRK","14","55","55","ମ୍ନା ପୁଜାରି ଆରି ଜିଉଦିଇଂ ସାପାରେ ମ୍ନା କୁକପାର୍ ନିଆ ଜିସୁକେ ଗୁଏନେଦଣ୍ଡ୍‌ ବିଃନ୍‌ସା ମେଇଂନେ ବିରଦ୍‌ରେ ମେଃଡିଗ୍ ବୁଲ୍ ପର୍‌ମାନ୍ ବାନ୍‌ସା ଚେସ୍‌ଟା ଡିଂଆର୍‌କେ ତେଲା ମେଇଙ୍ଗ୍ ଗୁଏନେ ଡଣ୍ଡ୍ ବିନ୍‌ସା ମେଃଡିଗ୍ ସାକି ଆବା ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK14_56","071_14_56","MRK","14","56","56","ଜାବର୍ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ବିରଦ୍‌ରେ ମିଚ୍ ସାକି ବିଃଆର୍‌କେ । ମାତର୍‌ ମେଙ୍ଗ୍ ସାପାରେ ବାନ୍ ସାକି ଆମିଲେକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK14_57","071_14_57","MRK","14","57","57","ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିରୁଆ ରେମୁଆଁ ତୁଆଁ ଆର୍‌କେ ଆରି ଜିସୁନେ ବିରଦ୍‌ରେ ଆକେନ୍ ମିଚ୍‌ ସାକି ବିଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, ");
INSERT INTO gaq_vpl VALUES ("MK14_58","071_14_58","MRK","14","58","58","“ନେ ଜିସୁକେ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଡିଂକ୍ନେ ନେଅଁକେ ରେମୁଆଁ ଆଃରେବକ୍ନେ ଆକେନ୍ ମନ୍ଦିର୍‌କେ ନେଙ୍ଗ୍ ପାକ୍‍ଚି ମ୍ୱିଏ ଆରି ଜିର୍ସି ବିତ୍ରେ ଆରି ମୁଇଙ୍ଗ୍ ମନ୍ଦିର୍‍ ଆରେ ମ୍ବିଏ ଆଣ୍ଡିନେ କି ରେମୁଆଁ ନ୍ତିରେ ଆରେ ଆବଆର୍‌ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_59","071_14_59","MRK","14","59","59","ଡିଲାଡିଗ୍ ଆକେନ୍ ରେମୁଆଁଇଙ୍ଗ୍ ମେଃ ସାପା ବାସଙ୍ଗ୍‌ଡିଂକେ, ଆତେନ୍‌ ସାମୁଆଁ ଜା ଏତେ ଡିଗ୍‌ କୁଡ଼େ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK14_60","071_14_60","MRK","14","60","60","ଇଡ଼ିଙ୍ଗ୍ ସାପାରେନେ ବାନ୍ ସେନୁଗ୍ ମ୍ନା ପୁଜାରି ତୁଆଁକେ । ମେଁ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍ ରେମୁଆଁଇଂ ନାନେ ବିରଦ୍‌ରେ ଆକ୍‌ମେଇଂ ଗୁଲେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ । ନାଁନେ ବିରଦ୍‌ରେ ଉଡ଼ିକ୍ଲିଗ୍ ଦସ୍ ଡୁଂପାଙ୍ଗ୍‌କେ ଆତେନ୍‌ ବିସୟ୍‌ରେ ନାଁନେ ମେଁ ଡିଗ୍ ବାସଙ୍ଗ୍‌ନେ ଲେକ୍ଲେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK14_61","071_14_61","MRK","14","61","61","ମାତର୍‌ ଜିସୁ ବୁଙ୍ଗ୍‍ ଲେଃଗେ । ମେଁ ମେଃଡିଗ୍ ଉତର୍ ଆବିକେ ଣ୍ଡୁ । ମ୍ନା ପୁଜାରି ଜିସୁକେ ଆରି ମୁଇଙ୍ଗ୍ ପ୍ରସ୍‌ନ ସାଲିଆକୁକେ, “ନା ମେଃନେ ପ୍ରସଂସା ବାଡିଂକ୍ନେ ପର୍‌ମେସର୍‌‌ନେ ଉଙ୍ଗ୍‌ଡେ କିସ୍‌ଟ ?” ");
INSERT INTO gaq_vpl VALUES ("MK14_62","071_14_62","MRK","14","62","62","ଜିସୁ ଉତର୍ ବିକେ, “ଅଃଅଁ ନେଙ୍ଗ୍ ପର୍‌ମେସର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଆରି ପେ ନେଙ୍ଗ୍ ଜେ’ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ଆତେନ୍‌ ଜବର୍‌ ବପୁ ଆଡିଙ୍ଗ୍‌ଚେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା କଲେଃକ୍ନେ ପେକେଏ ଆରି କିତଙ୍ଗ୍ ଇନିନେ ତ୍ରିଗ୍‍ଡ୍ୟା ଅରିଆ ପାଙ୍ଗ୍‍ଡିଂକ୍ନେ ପେକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_63","071_14_63","MRK","14","63","63","ମ୍ନାଯାଜକ ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ ଜାବର୍ ରିସାଡିଙ୍ଗେ । ମେଁ ରିସାରେ ନିଜେନେ ସକା ସ୍ୟା ବିଚେ ସାପାରେକେ ବାସଙ୍ଗ୍‌କେ, “ନେଁନେ ସାକି ଆରି ମେଁ ଦର୍‍କାର୍ ? ");
INSERT INTO gaq_vpl VALUES ("MK14_64","071_14_64","MRK","14","64","64","ମେଁ ଇସ୍‌ପର୍‌କେ ନିନ୍ଦା ଆଡିଂଡିକେ ପେଇଂ ଅଁପେଲେକେ । ପେଇଂନେ ଇକ୍‌ଚା ମେଁନେ ?” ମେଇଂ ମେଁନେ ବିରଦ୍‌ରେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ ଜେ’ ମେଁ ଦସି ଆରି ଗୁଏନେ ଡଣ୍ଡ୍‍ ବିନେ ଦର୍‌କାର୍‌ । ");
INSERT INTO gaq_vpl VALUES ("MK14_65","071_14_65","MRK","14","65","65","ଆତ୍‍ ଅରିଆ ଲେଃକ୍ନେ ଉଡ଼ି ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ଆଡ଼ାତ୍ରା ବିଃତୁର୍‌ ବିକେ । ଉଡ଼ିରୁଆ ଜିସୁକେ ସାର୍‌ମୁଆଁ ଡାଚେ ବଗ୍‍ଆର୍‌କେ ଆରି ଉଡ଼ିରୁଆ ଇଙ୍ଗ୍‌ଚେଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଏକ୍ରେ ନା ଆନେକେ ଆଃସୁଏବି ନାବଗେ ନା ମୁଇଙ୍ଗ୍ ବାବବାଦି ରେମୁଆଁ ।” ଇଡ଼ିଙ୍ଗ୍ ଉର୍‌ଣ୍ଡ୍ରେ ଆମେକେ ଡୁଂୱେଚେ ବଗ୍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_66","071_14_66","MRK","14","66","66","ଆତେନ୍‌ ବେଲା ପିତର୍ ବାଜାର୍‍ ଲେଃଗେ । ପିତର୍ ଡାଗ୍ରା ମ୍ନା ପୁଜାରିଇଂନେ ମୁଇଙ୍ଗ୍ ଚାକର୍‌ବ‍ଏଃ ପାଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_67","071_14_67","MRK","14","67","67","ମେଁ ପିତର୍‌କେ ସୁଆଡାଗ୍ରା ର୍ନିଃ ଡିଙ୍ଗ୍‌କ୍ନେ କେକେ । ମେଁ ପିତର୍‌କେ ନିମାଣ୍ଡା କେକେ ଇଡ଼ିଙ୍ଗ୍ ଆମେକେ ସାମୁଆଁଚେ ବାସଙ୍ଗ୍‌କେ, “ନାଁ ଡିଗ୍ ନାଜରିତୀୟ ଜିସୁ ଏତେ ନାଲେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_68","071_14_68","MRK","14","68","68","ପିତର୍ ମାତର୍‌ ବାଃଲିର୍‍କେ, ଜେ ନେଙ୍ଗ୍‌ ଅଃନାଡିଗ୍ ଜିସୁ ଏତେ ନାଲେଗେ ଣ୍ଡୁ । ମେଁ ବାସଙ୍ଗ୍‌କେ, ଜେ’ “ପେ ଜାନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ପେଡିଂକେ ଆତେନ୍‌ ନା ମ୍ୟାକେ ଣ୍ଡୁ ଲେଃ ବୁଜେ ନାୟାକେ ।” ଇଡ଼ିଙ୍ଗ୍ ପିତର୍ ଆତେନ୍‌ ଜାଗା ଆନ୍ତାର୍‌ଚେ ବାଜାର୍ ବାଏରେ ପାକା ତାର୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK14_69","071_14_69","MRK","14","69","69","ଚାକର୍‌ବ‍ଏଃ ମୁଇଙ୍ଗ୍ ଆରି ପିତର୍‌କେ କେଚେ ଆତ୍‌ଡାଗ୍ରା ତୁଆଁଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌ନେ ଲାଗେକେ ଜେ “ଆକେନ୍ ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ମେଇଂନେ ବିତ୍ରେବାନ୍ ମୁଇଂଜା ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_70","071_14_70","MRK","14","70","70","ଆରି ମୁଇଙ୍ଗ୍ ତର୍ ପିତର୍ ବାଲିର୍‍କେ ଜେ “ଆକେନ୍ ସାମୁଆଁ ସତ୍ ଣ୍ଡୁ । ଉଡ଼ିବେଲା ଆତ୍‌ଡାଗ୍ରା ତୁଆଁଲେଃକ୍ନେ ରେମୁଆଁଇଙ୍ଗ୍ ପିତର୍‌କେ ସାଲିଆକୁ ଆର୍‌କେ ଡିଲାଡିଗ୍ ନା ମେଇଙ୍ଗ୍ ବାନ୍ ମୁଇଂଜା । ମାତର୍‌ ନା ଡିଗ୍ ଗାଲିଲୀବାନ୍‍ ପାଙ୍ଗ୍‍ନାଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_71","071_14_71","MRK","14","71","71","ଇଡ଼ିଙ୍ଗ୍ ପିତର୍ ଅବିସାପ୍ ବିନେ ଲାଗେକେ । ମେଁ ବୁଟଚେ ବାଲିର୍‍କେ, “ନେଙ୍ଗ୍ ପର୍‌ମେସର୍‌ନେ ମ୍ନିରେ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ ଜେ’ ପେ ସାପାରେ ମୁଡ଼ି ରେମୁଆଁ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ପେଡିଂକେ, ନେଙ୍ଗ୍ ଆମେକେ ବିଲ୍‍କୁଲ୍ ନ୍ନାମ୍ୟାକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK14_72","071_14_72","MRK","14","72","72","ଆତେନ୍‌‌ ଦାପ୍ରେ ମ୍ୱାର୍‌ତର୍‌ ଗିସେଙ୍ଗ୍ ସକେ ବାରି ପିତରକେ ମନେ ପଡ଼େକେ; ଜିସୁ ବାସଙ୍ଗ୍‌ବଗେ, “ଗିସେଙ୍ଗ୍ ମ୍ୱାର୍‌ତର୍‌ ସକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ନାଁ ଆନେଙ୍ଗ୍‌ ଞ୍ଜିତର୍ ନାମ୍ୟାକେ ଡାଗ୍‌ଚେ ନାବାସଙ୍ଗ୍‌ଏ ।” ବାରି ମେଁ ଦୁକ୍‌ଡିଂଚେ ଗିଆସଚେ ଅଃକେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_1","071_15_1","MRK","15","1","1","ତାରାଃକ୍ନେ ଦାପ୍‌ଡ଼େ ମ୍ନା ପୁଜାରି ଦର୍ମ ନେତାଇଂ ଜିଉଦି ନେତାଇଙ୍ଗ୍ ଆରି ଦରମ୍‌ଣ୍ଡ୍ରେ ସାପାରେ ଜିଉଦି ମ୍ନା କୁକପାର୍‌ନ୍ନିଆ ଜିସୁନେ ଆଡ଼ାତ୍ରା ମେଁ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ଆର୍‌କେ ଆତେନ୍‌ ଏତେକେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ଗାଗ୍‌ଚେ ସାସନ୍‍ ଡିଂଣ୍ଡ୍ରେ ପିଲାତ ଡାଗ୍ରା ଡୁଂୱେଗେ ଆରି ମେଁନେ ନ୍ତିନ୍ନିଆ ଆସା ବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_2","071_15_2","MRK","15","2","2","ପିଲାତ ଜିସୁକେ ସାଲିଆକୁକେ, “ନା ମେଁନେ ଯୀହୂଦୀଇଂନେ ଇଃସାଙ୍ଗ୍‌ ?” ଜିସୁ ଉତର୍ ବିକେ, “ନା ମେଁ ନାବାସଙ୍ଗ୍‍କେ ଆତେନ୍‌ ସତ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_3","071_15_3","MRK","15","3","3","ମ୍ନା ପୁଜାରିଇଂ ଗୁଲୁଏ ସାମୁଆଁନ୍ନିଆ ଜିସୁକେ ଦସ୍ ସାଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_4","071_15_4","MRK","15","4","4","ପିଲାତ ଆରି ମୁଇଙ୍ଗ୍‌ତର୍‌ ଜିସୁକେ ସାଲ୍ୟାଃକୁକେ, “ନାଁନେ ମେଁ ଡିଗ୍ ଦସ୍‌ ଣ୍ଡୁ ? କେଲା ମେଇଙ୍ଗ୍ ଆଁନାକେ ଗୁଲେ ସାମୁଆଁନ୍ନିଆ ଦସିଆଡିଙ୍ଗ୍‌ ଆର୍‌ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_5","071_15_5","MRK","15","5","5","ତେଲାଡିଗ୍ ଜିସୁ ମେଃଡିଗ୍‌ ଉତର୍ ଆବିକେ ଣ୍ଡୁ । ତେଲା ପିଲାତ ଜବର୍ ଇରିଆଃତୁଗ୍ ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_6","071_15_6","MRK","15","6","6","ସାପା ମୁଆଁ ନିସ୍ତାର୍ ପାଣ୍ଡୁଏ ବେଲା ସାସନ୍‍ ଡିଂଣ୍ଡ୍ରେ ମୁଇଂଜା ବନ୍ଦିକେ ବନ୍ଦି ଡୁଆବାନ୍‌ ଆନ୍ତାର୍ ମ୍ୟାଆର୍‌କେ ଆଣ୍ଡିନେ ବନ୍ଦିକେ ଆନ୍ତାର୍‌ନେସା ରେମୁଆଁଇଂ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ ତେଲା ଆତେନ୍‌‌ ବନ୍ଦିରେକେ ସାସନ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଆନ୍ତାର୍‌ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MK15_7","071_15_7","MRK","15","7","7","ଆତେନ୍‌‍ବେଲା ବନ୍ଦି ଡୁଆବାନ୍ ବାରବ୍‍ବା ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁ ବିରଦି‍ଇଂଏତେ ବନ୍ଦି ଡିଂଲାଏଗେ । ଆକେନ୍ ବିରଦି‍ଇଂ ମୁଇଙ୍ଗ୍ ସର୍‍କାର୍‍ନେ ବିରଦ୍‌ରେ ମୁଇଙ୍ଗ୍ ଦସ୍‌ଡିଂଚେ ବନ୍ଦି ଡିଙ୍ଗ୍‌ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_8","071_15_8","MRK","15","8","8","ରେମୁଆଁଇଂ ପିଲାତ ଡାଗ୍ରା ପାଙ୍ଗ୍ ଆର୍‌କେ ଆରି ଆମେକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ ଜେ କାଲାଆଃ ସାପା ବରସ୍‌ ରକମ୍ ଏନ୍‍ପାରେ ଡିଗ୍ ମେଇଂନ୍‌ସା ମୁଇଂ ବନ୍ଦିକେ ଆତାର୍‍ବିଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_9","071_15_9","MRK","15","9","9","ପିଲାତ ରେମୁଆଁଇଂକେ ସାଲିଆକୁକେ, “ପେ ସାପାରେ ମେଁ କେ ପେଡିଂକେ ଜେ ନେଙ୍ଗ୍ ପେ ସାପାରେନ୍‍ସା ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌କେ ଆନ୍ତାର୍‌ମ୍ୱିଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK15_10","071_15_10","MRK","15","10","10","ପିଲାତ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଁ ମ୍ୟାଲେକେ ଜେ ମ୍ନାନେ ପୁଜାରି‍ଇଂ ଆଂକାର୍ ଡିଙ୍ଗ୍‌ଚେ ଜିସୁକେ ମେଁନେ ନ୍ତି ନ୍ନିଆ ସର୍‍ପେବିଃ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_11","071_15_11","MRK","15","11","11","ମାତର୍‌ ମ୍ନା ପୁଜାରି‍ଇଂ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌ ଜେ ମେଇଙ୍ଗ୍‌ ପୀଲାତକେ ବାସଙ୍ଗ୍‍ଲେ ବାରବ୍‍ବାକେ ଆନ୍ତାର୍‌ବି’ଲେ ମାତର୍‌ ଜିସୁକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK15_12","071_15_12","MRK","15","12","12","ପିଲାତ ରେମୁଆଁଇଂକେ ଆରି ମୁଇଂତର୍ ସାଲ୍ୟାଃକୁକେ, “ପେ ଆଜାକେ ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ପେଡିଂ ନେଙ୍ଗ୍ ମେଁ ଆଡ଼ାତ୍ରା ମେଁ ଡିଙ୍ଗ୍‌ନ୍‌ସା ପେ ଚାଏଁପେଡିଂକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK15_13","071_15_13","MRK","15","13","13","ରେମୁଆଁଇଂ କିରଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଜିସୁକେ କୁରୁସ୍‌ନ୍ନିଆ ଆଡେଚେ ବାଗୁଏପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_14","071_15_14","MRK","15","14","14","ପିଲାତ ସାଲ୍ୟାଃକୁକେ ମେଃନ୍‍ସା ? ମେଁ ଦେକ୍‌ରକମ୍ ମେଁନେ ଦସ୍ ଡିଂବକେ ? ମାତର୍‌ ରେମୁଆଁଇଙ୍ଗ୍‌ ମାଲେ କିରଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଆମେକେ କୁରୁସ୍‌ନ୍ନିଆ ଆଡେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_15","071_15_15","MRK","15","15","15","ପିଲାତ ରେମୁଆଁଇଂକେ ସାର୍ଦା ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌କେ ତେଲା ମେଁ ମେଇଂନ୍‌ସା ବାରବ୍‍ବାକେ ଆନ୍ତାର୍‌ବିକେ ଆରି ଜିସୁକେ କର୍‌ଡା ଏତେ ବଗ୍‌ନ୍‌ସା ସନ୍ୟ‍ଇଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‍ବିକେ । ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଜିସୁକେ କୁରୁସ୍‌ନ୍ନିଆ ଆଡେଚେ ବାଗୁଏଃ ବିଃନ୍‍ସା ଆମେକେ ସନ୍ୟ‍ଇଙ୍ଗ୍ ନ୍ତିନିଆ ବିଃ ଜଗ୍‌ତ୍ଲାଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_16","071_15_16","MRK","15","16","16","ସନ୍ୟ‍ଇଙ୍ଗ୍ ଜିସୁକେ ପିଲାତନେ ଡୁଆ ବିତ୍ରେ ଡୁଂୱେଗେ । ମେଇଙ୍ଗ୍‌ ବିନ୍‌ ସନ୍ୟ‍ଇଂକେ ମୁଇଂନ୍ନିଆ ୱାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_17","071_15_17","MRK","15","17","17","ସନ୍ୟଇଙ୍ଗ୍‌ ଜିସୁକେ କଡ଼େଆଁ ରକମ୍‍ ତ୍ନାକ୍ନେ ପାଟାଇ ଆସାଃଆର୍‌କେ ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ମୁଇଂ ଗ୍ରେଃନେ ସାଜ ଆଃରେଚେ ମେଁନେ ବାଆଃନ୍ନିଆ ଆସଃବି ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_18","071_15_18","MRK","15","18","18","ଏ ଯିହୁଦିଇଂନେ ଇସାଙ୍ଗ୍‌ ଆନାକେ “ନମସ୍କାର୍‌, ଡେକ୍‌ ରକମ୍‌ ବାସଙ୍ଗ୍‌ଚେ ମେଇଙ୍ଗ୍‌ ଲୁଆ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_19","071_15_19","MRK","15","19","19","ସନ୍ୟଇଙ୍ଗ୍‌ ଜିସୁନେ ବାଆଃନ୍ନିଆ ଡୁଡୁ ଏତେ ବଗ୍‌ଆର୍କେ । ମେଁ ଆଡ଼ାତ୍ରା ବିଃତୁର୍‌ ବିଆର୍‌କେ । ଏଃଲ୍ୟାଚେ ଆରି ଡେଙ୍ଗଚେ ଆମେକେ ସାର୍ଲ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_20","071_15_20","MRK","15","20","20","ଇଙ୍ଗ୍‌ଚେ ଆଃଡାଚେ ମେଇଙ୍ଗ୍ ଜିସୁନେ ଗାଗ୍‌ଡ଼େବାନ୍ କଃଡ଼େଆଁ ରକମ୍ ପାଟାଇ ତବିଚେ ଆରି ଆମେକେ ମେଁନେ ନିଜର୍ ସକା ଆସଃଆର୍‌କେ । ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍ ଜିସୁକେ କୁରୁସ୍‌ନ୍ନିଆ ଆଡେଚେ ବାଗୁଏଃ ନ୍‍ସା ଡୁଆ ବାଏରେ ଡୁଂୱେଏ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_21","071_15_21","MRK","15","21","21","ଆତେନ୍‌‌ ବେଲା ମୁଇଂଜା କୁରୁଣୀ ରେମୁଆଁ ଶିମୋନ୍ ଡାଆଁ ଇନିବାନ୍ ପାଙ୍ଗ୍‌ଚେ ଆନ୍ତ୍‍ପାକା ୱେଡିଙ୍ଗ୍‍ଗେ । ମେଁ ଆଲେକ୍‍ଜାଣ୍ଡାର୍‌ ନେ ଆରି ରୁଫସ୍‌ନେ ଆବାଡ଼େ ଲେଃଗେ । ସନ୍ୟଇଙ୍ଗ୍‌ ଜିସୁନ୍‍ସା କୁରୁସ୍‍ ଡୁଙ୍ଗ୍‌ୱେନ୍‍ସା ଆମେକେ ଜବର୍‍ଜସ୍ତି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_22","071_15_22","MRK","15","22","22","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁକେ ଗଲ୍‍ଗଥା ମ୍ନିକ୍ନେ ଟାନ୍‌ଅରିଆ ଡୁଂୱେଆର୍‌କେ । ଗଲ୍‍ଗଥା ଅର୍‌ତ ଡିଙ୍ଗ୍‌ଡିଙ୍କେ କାପାଲ୍‌ ଜାଗା ");
INSERT INTO gaq_vpl VALUES ("MK15_23","071_15_23","MRK","15","23","23","ଆତ୍‌ଅରିଆ ମେଇଂ ଜିସୁକେ ବାସ୍ନାରସ୍‍ ମିସେକ୍ନେ ଅଙ୍ଗୁର୍ ରସ୍ ଉଗ୍‌ନେସା ବିଆର୍‌କେ । ମାତର୍‌‌ ଜିସୁ ଆତେନ୍‌ ଆଉଗ୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK15_24","071_15_24","MRK","15","24","24","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ମେଇଂ ଜିସୁକେ କୁରୁସ୍ ଅରିଆ କୁଟି ଡାଚେ ଆଃଗୁଏଃଆର୍‌କେ ବାରି ଲେଟ୍‍ରିକ୍‍ ତ୍ଲାଗ୍‌ଚେ ମେଁନେ ପାଟାଇ ସାପା ନିଜର୍‌ ନିଜର୍‌ ବିତ୍ରେ ବାଟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_25","071_15_25","MRK","15","25","25","ଜିସୁକେ କୁରୁସ୍‌ନ୍ନିଆ କୁଟି ଡାଃନେ ବେଲା ଞ୍ଜିର୍ ନ’ଟା ଡିଙ୍ଗ୍‌ଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_26","071_15_26","MRK","15","26","26","ଜିସୁକେ ଆଂକାର୍‌ଡିଂଣ୍ଡ୍ରେରେ ମୁଇଙ୍ଗ୍‌ ଦାବି ଉଲିଆଃ ଆଡ଼ାତ୍ରା ଗୁଆର୍ ବ‍ଆର୍‌ଗେ, “ଏ ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ଜିସୁ ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_27","071_15_27","MRK","15","27","27","ଜିସୁ ଏତେ ଆରି ମ୍ୱାୟା ଡଙ୍ଗାରେକେ ଡିଗ୍ ମେଇଙ୍ଗ୍ କୁରୁସ୍ ଆଡ଼ାତ୍ରା ଆଡ଼େଆର୍‌କେ । ମୁଇଙ୍ଗ୍‌ଜାକେ ମେଁଇଙ୍ଗ୍‌ନେ ବେସ୍ୟାଃ ପାକା ଆରି ମୁଇଙ୍ଗ୍‌ଜାକେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା କୁରୁସ୍ ଅରିଆ ଆଗୁଏଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_28","071_15_28","MRK","15","28","28","ଆତ୍‌ଅରିଆ ଦରମ୍ ସାସ୍ତର୍‌ନେ ଆକେନ୍ ସାମୁଆଁ ସମାନ୍ ଡିଙ୍ଗ୍‌କେ ମେଁ ଅଧର୍ମଇଂନେଏତେ ଇସାବ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_29","071_15_29","MRK","15","29","29","ଆନ୍ତ୍‌ ପାକା ୱେଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂ ବାଆଃ ଆୱେଚେ ଅପ୍‌ମାନ୍‌ ବିଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଅଁ, ମନ୍ଦିର୍‌କେ ପାକ୍‌ଚିଚେ ଜିରିସି ଦିନା ବିତ୍ରେ ବାରି ଆରେଣ୍ତ୍ରେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_30","071_15_30","MRK","15","30","30","ଏବେ କୁରୁସ୍‌ବାନ୍ ଜାର୍‌ଚେ ନିଜେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_31","071_15_31","MRK","15","31","31","ମ୍ନା ପୁଜାରି ଆରି ଦରମ୍‌ଣ୍ଡ୍ରେଇଂ ଡିଗ୍ ଆତ୍‌ଅରିଆ ରିସିଙ୍ଗ୍ ଲେଃଆର୍‌ଗେ । ବିନ୍ ରେମୁଆଁଇଂ ଜିସୁକେ ଡିରକମ୍ ଇଙ୍ଗ୍‌ଚେ ଡିଙ୍ଗ୍ଆର୍‌ଗେ ମେଇଙ୍ଗ୍‌ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ଜିସୁକେ ଇଙ୍ଗ୍‌ଚେ ଡିଙ୍ଗ୍ଆର୍‌ଗେ । ମେଇଙ୍ଗ୍‌ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ ଆର୍‌ଗେ, “ମେଁ ବିନ୍‌ରେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ ମାତର୍‌ ଏବେ ମେଁ ନିଜକେ ରକ୍ୟା ଡିଙ୍ଗ୍ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("MK15_32","071_15_32","MRK","15","32","32","ଡାଗ୍ଲା ସତେଆ ମେଁ କିସ୍‌ଟ ଇଶ୍ରାୟେଲନେ ଇଃସାଙ୍ଗ୍‌ ତେଲା ଜିଆ ଆତେନ୍‌ କୁରୁସ୍ ଆଡ଼ାତ୍ରା ବାନ୍ ବୁନ୍ଦେ ଜାର୍‍ ପାଙ୍ଗ୍‌ଲେଃ । ନିଜେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‌ ଲେଃ । ତେଲା ନେ ସାପାରେ ଆତେନ୍‌ ନେକେଏ ଆରି ଆମେକେ ସତ୍ ନେମାନେଃଏ । ମୁଃଡ଼ି ରେମୁଆଁଇଂକେ ଜିସୁଏତେ କୁରୁସ୍ ଅରିଆ ବାଗୁଏଃ ଆର୍‌କେ ମେଇଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ ଜିସୁକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_33","071_15_33","MRK","15","33","33","ସ୍ମି ମୁଣ୍ଡେବେଲା ସାପା ଇନି ଆଡ଼ାତ୍ରା ତାଂକିଗ୍ ଡୁଂପାଙ୍ଗ୍‌କେ । ଆକେନ୍ ତାଂକିଗ୍ ଞ୍ଜି ଗଣ୍ଟା ଜାକ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_34","071_15_34","MRK","15","34","34","ଆତେନ୍‌ ବେଲା ଜିସୁ ଜବର୍ କିରଚେ ବାସଙ୍ଗ୍‌କେ, “ଏଲୋହୀ, ଏଲୋହୀ, ଲାମା ଶବକ୍‌ଥାନୀ ।” ଏଲେଡିଗ୍‌ “ଏ ନେଙ୍ଗ୍‌ନେ ଇସ୍‌ପର୍ ଏ ନେଙ୍ଗ୍‌ନେ ଇସ୍‌ପର୍ ପେ ଆନେଙ୍ଗ୍‌କେ ମେଁନ୍‌ସା ଆନ୍ତାର୍‌ ପେବିକେ ?” ");
INSERT INTO gaq_vpl VALUES ("MK15_35","071_15_35","MRK","15","35","35","ଆତ୍‌ଅରିଆ ତୁଆଁଲେଃକ୍ନେ ଉଡ଼ିରୁଆ ଆକେନ୍ ସାମୁଆଁ ଅଁକେ । ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌କେ “ଅଁପା ମେଁ ଏଲୀୟକେ ୱାଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_36","071_15_36","MRK","15","36","36","ଆତ୍‌ଅରିଆ ମୁଇଙ୍ଗ୍‌ ରେମୁଆଁ ୱିର୍ ଡୁଂୱେଚେ ବିସେକ୍ନେ ରସ୍ ଲାଃବଙ୍ଗ୍‌କ୍ନେ ମୁଇଙ୍ଗ୍‌ ପସ୍‌କା ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌କେ । ପସ୍‌କାକେ ମୁଇଙ୍ଗ୍‌ ଡୁଡୁନିଆ ଗାଗ୍‌କେ । ଜିସୁ ପସ୍‌କାବାନ୍‌ ବିସେଃକ୍ନେ ରସ୍ ଉଗ୍ ଡାଗ୍‌ଚେ ଆତେନ୍‌ ଡୁଡୁନିଆ ପସ୍‌କା ଗାଗ୍‌ବକ୍ନେ ଡୁଡୁକେ ମେଁନ୍ନିଆ ଆଚ୍ଲେ ବିକେ । ରେମୁଆଁ ବାସଙ୍ଗ୍‌କେ, “ଲାଃଲା ନେକେପା ଏଲୀୟ ଆକ୍‌ମେକେ କୁରୁସ୍ ଆଡ଼ାତ୍ରା ବାନ୍ ବୁନ୍ଦେ ଆଃଜାର୍‌ନ୍‌ସା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ଲେ ଣ୍ତୁ ନେ’କେପା ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_37","071_15_37","MRK","15","37","37","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଜବର୍ ସାରଚେ ଗୁଏୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_38","071_15_38","MRK","15","38","38","ଜିସୁ ଉଡ଼ିବେଲା ଗୁଏୱେଗେ ଆତେନ୍‍ ବେଲା ମନ୍ଦିର୍‌ନେ ପବିତ୍ର ଟାନ୍‌ନିଆ ଲେଃକ୍ନେ ପାଟାଇ ଆଡ଼ାତ୍ରାବାନ୍ ବୁନ୍ଦେଜାକ ବାର୍‌ବାଗ୍‌ ଡିଙ୍ଗ୍‌ଚେ ସ୍ୟାଃ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_39","071_15_39","MRK","15","39","39","କୁରୁସ୍ ସେନୁଗ୍‌ ତୁଆଁ ଲେଃକ୍ନେ ମାଲ୍‌କୁଡ଼ି ସେନାପତିନେ ଆଡ଼ାତ୍ରାଲେକ୍ନେ ସେନାପତି ଜିସୁ ଡିରକମ୍ ଗୁଏକେ ଆତେନ୍‌ କେକେ । ମେଁ ବାଲିର୍‌କେ, “ସତେଆ ଆକେନ୍ ରେମୁଆଁ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("MK15_40","071_15_40","MRK","15","40","40","ଉଡ଼ି ସେଲାମ୍ବୁଏଇଂ କୁରୁସ୍‌ବାନ୍ ଉଡ଼ି ସ୍ଲ ତୁଆଁଚେ କିକେଡିଙ୍କେ । ମେଇଙ୍ଗ୍ ବିତ୍ରେ ମଗ୍‌ଦଲୀନି ଇନିବାନ୍ ପାଙ୍ଗ୍‌ଲେକ୍ନେ ମରିୟମ୍‌ ଶଲୋମୀ ଜାକୁବ୍‌ ଆରି ଯୋସିନେ ଇୟାଙ୍ଗ୍‌ଡେ ମରିୟମ୍‌ ଲେଃଗେ । ଜାକୁବ୍‌ ମରିୟମ୍‌ନେ ଡାଆଁ ଗଡ଼େଅ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_41","071_15_41","MRK","15","41","41","ଆକେନ୍ ସେଲାମ୍ୱୁଏଇଙ୍ଗ୍‌ ଜିସୁ ଗାଲିଲୀନ୍ନିଆ ଲେଃକ୍ନେବେଲା ମେଁଏତେ ଲେଃଆର୍‌ଗେ । ମେଇଙ୍ଗ୍‌ ମେଁନେ ସେବା ଡିଙ୍ଗ୍ଆର୍‌କେ । ବିନ୍‌ନେ ଉଡ଼ି ସେଲାମ୍ବୁଏ ଡିଗ୍ ଆତ୍‌ଅରିଆ ଲେଃଆର୍‌ଗେ । ମେଇଙ୍ଗ୍ ଜିସୁଏତେ ଯିରୂଶାଲାମ୍ ପାଙ୍ଗ୍‌ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_42","071_15_42","MRK","15","42","42","ଲମ୍‍ଡିଗ୍‍ ଡିଙ୍ଗ୍‌ୱେଲେଃଗେ । ଆକେନ୍‌ ଞ୍ଜି ଦିନାନେ ଆର୍ମେ ଦିନ୍ ଆରି ପୁଣ୍ତେନେ ଦିନାନେ ସେନୁଗ୍‌ ଦିନ୍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_43","071_15_43","MRK","15","43","43","ଆରମାଥିଆନେ ଜିଉଦି ଯୋସେଫ୍‌ ମ୍ନା ସବାନେ ମୁଇଂ ସନ୍‍ମାନ୍ ବିଣ୍ଡ୍ରେ ଲେଃଗେ । ଆରି ମେଁ ପରମେସର୍‌ନେ ରାଜି ପାଙ୍ଗ୍‌ଲେ ଡାଗ୍‌ଚେ ଚାଏଁ ଡିଙ୍ଗେ । ମେଁ ସାହାସ୍‌ ସାଚେ ପିଲାତ ଡାଗ୍ରା ୱେଚେ ଜିସୁନେ ମଡ଼ା ସାଲିଆକେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_44","071_15_44","MRK","15","44","44","ଜିସୁ ଆତେନ୍‌‌ ଦାପ୍ରେ ଗୁଏୱେଗେ ଡାଗ୍‌ଚେ ଅଁଚେ ପୀଲାତ କାବା ଡିଙ୍ଗ୍‌ୱେଗେ । ମେଁ ଜିସୁକେ ଉର୍‌ଲେଃକ୍ନେ ସତ୍ ସେନାପତିକେ ୱାକେ । ପିଲାତ ଆମେକେ ଜିସୁ ଗୁଏଗେ ଲେଃ ଙ୍କାରେ ଡାଗ୍‌ଚେ ସାଲିଆକୁକେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_45","071_15_45","MRK","15","45","45","ସେନାପତି ମୁଇଂଜା ଜିସୁ ଗୁଏଗେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ । ଇଡ଼ିଙ୍ଗ୍ ପୀଲାତ ଯୋସେଫ୍‌କେ ବାସଙ୍ଗ୍‌କେ, ଜେ ମେଁ ଜିସୁନେ ମଡ଼ା ଡୁଙ୍ଗ୍‍ ୱେୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("MK15_46","071_15_46","MRK","15","46","46","ଯୋସେଫ୍‌ ଇକୁଡ଼ା ପାଟାଇ ବିଆର୍‌କେ । ଆତେନ୍‌ ମଡ଼ାକେ କୁରୁସ୍ ଆଡ଼ାତ୍ରାବାନ୍ ବୁନ୍ଦେ ଆଜାର୍‌କେ । ଆତେନ୍‌ ମଡ଼ାକେ ପାଟାଇ ଏତେ ନିମାଣ୍ଡା ଆକୁଇ ବିଃକେ ଆରି କଣ୍ତାନେ କୁରୁ ଗଃବକ୍ନେ ମୁଇଙ୍ଗ୍‌ କୁରୁନ୍ନିଆ ଆମେକେ ବଆର୍‌ଗେ । ମୁଇଙ୍ଗ୍‌ ମ୍ନା ବ୍ରି ଆଗୁଣ୍ଡ୍‌ଲେ ଡୁଂପାଙ୍ଗ୍‍ଚେ କୁରୁନେ ସାର୍ମୁଆଁ ଡାବିଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK15_47","071_15_47","MRK","15","47","47","ମଗ୍‌ଦଲୀନି ମରିୟମ୍‌ ଆରି ଯୋସିନେ ଇୟାଙ୍ଗ୍‌ଡେ ଜିସୁକେ ଆଣ୍ତି ଅରିଆ ବଆର୍‌କେ ଆତେନ୍‌ ଜାଗା କେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_1","071_16_1","MRK","16","1","1","ପୁଣ୍ତେନେ ଆରି ମୁଇଙ୍ଗ୍ ଦିନା ମଗ୍‌ଦଲୀନି ମରିୟମ୍ ଜାକୁବ୍‌ ଇୟାଙ୍ଗ୍‌ଡେ ମରିୟମ୍ ଆରି ଶଲୋମି ଜିସୁନେ ଗାଗ୍‌ଡ଼େ ଚୁଚୁନ୍‌ସା ଉଡ଼ି ବାସ୍‌ନାଚୁ ଡୁଂପାଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_2","071_16_2","MRK","16","2","2","ମୁଇଂ ସାନ୍ତାନେ ପର୍‌ତୁମ୍‌ ଦିନା ସ୍ନି ତେତାର୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍ ଆତି ବକ୍ନେ ଅରିଆ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_3","071_16_3","MRK","16","3","3","ମେଇଙ୍ଗ୍ ନିଜର୍ ନିଜର୍ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଆର୍‌କେ, “ଆତି ବକ୍ନେ ସାର୍ମୁଆଁ ନ୍ନିଆ ମୁଇଙ୍ଗ୍‌ ମୁନା ବ୍ରି ଏତେ ଡାବିଃବଆର୍‌କେ । ବ୍ରିକେ ନେନ୍‌ସା ଜା ଆତ୍‌ବାନ୍‍ ଗୁଚେବିଏ ?” ");
INSERT INTO gaq_vpl VALUES ("MK16_4","071_16_4","MRK","16","4","4","ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍‌ ଆନ୍ତ୍ ପାକା କେଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ କେ ଆର୍‌କେ ଜେ ଆତେନ୍‌ ମ୍ନାବ୍ରିକେ ଆତ୍ ବାନ୍ ଗୁଚେ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_5","071_16_5","MRK","16","5","5","ମେଇଙ୍ଗ୍ ଆତି ବକ୍ନେ ବିତ୍ରେ ଗାଆର୍‌କେ । ଆତ୍ ଅରିଆ ମେଇଙ୍ଗ୍ ତୁଲୁଏକ୍ନେ ପାଟାଇ ସଃଲେକ୍ନେ ମୁଇଂ ଙ୍ଗିରେକେ କେଆର୍‌କେ । ମେଁ ଆତି ବକ୍ନେ ବେସ୍ୟା ପାକା କ ଲେଃଗେ । ମେଇଙ୍ଗ୍ ବୁଟ ୱେଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_6","071_16_6","MRK","16","6","6","ମାତର୍‌ ଙ୍ଗିର୍‌ବଏ ବାସଙ୍ଗ୍‌କେ, “ଆବ୍‌ଟଗେପା । ପେ ସାପାରେ କୁରୁସ୍ ଅରିଆ ଗୁଏକ୍ନେ ନାଜରିତୀୟ ଜିସୁକେ ତୁର୍‌ପେଡିଙ୍ଗ୍‌କେ । ମେଁ ଗୁଏଚେ ଆରି ମୁଇଙ୍ଗ୍ ତର୍ ମ୍ବ୍ରଲେଃକେ । ମେଁ ଆକ୍‌ଅରିଆ ଣ୍ତୁ । କେଲାପା ମେଇଙ୍ଗ୍ ଆମେକେ ଆକେନ୍ ଜାଗାନ୍ନିଆ ବଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_7","071_16_7","MRK","16","7","7","ପ୍ରେଗ୍‌ ୱେଚେ ମେଁନେ ସିସ୍ଇଂକେ ଆରି ପିତର୍‌କେ ବାସଙ୍ଗ୍‌ପା ଜେ ପେ ସାପାରେନେ ସେନୁଗ୍ ଜିସୁ ଗାଲିଲୀପାକା ୱେ ଡିଂକେ । ମେଁ ଆପେକେ ସେନୁଗ୍ ଡିରକମ୍ ବାସଙ୍ଗ୍‌ବଗେ ପେ ସାପାରେ ଆମେକେ ଦେକ୍‌ରକମ୍ ଆତ୍‌ଅରିଆ ପେକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK16_8","071_16_8","MRK","16","8","8","ଆତେନ୍‌ ସେଲାମ୍ବୁଏଇଂ ବୁଟ ୱେଆର୍‌ଗେ ଆରି ଇରିଆତୁଗ୍‌ଚେ କାବା ଡିଙ୍ଗ୍‌ ୱେଆର୍‌କେ । ମେଇଙ୍ଗ୍‌ ଜିସୁକେ ଆତିବକ୍ନେ ବାନ୍ ତାର୍‌ଚେ ୱିର୍‌ ଲାଗ୍‌ଡଆର୍‌କେ, ମାତର୍‌‌ ବୁଟ ଇରିଆଃ ୱେ ଲେଃଲା, ଆକେନ୍ ସାପା ଗଟେକ୍ନେ ସତ୍‌ ସାମୁଆଁ ଆଜାକେ ଡିଗ୍ ଆବାସଙ୍ଗ୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK16_9","071_16_9","MRK","16","9","9","ମୁଇଙ୍ଗ୍‌ ସାନ୍ତାନେ ସାନ୍ତା କେଲା ଞ୍ଜିର୍‍ ଜିସୁ ଗୁଏକ୍ନେ ବାନ୍ ବାର୍‌ମୁଇଂତର୍ ଜିବନ୍‌ ଡିଂକେ । ସେନୁଗ୍‌ ମେଁ ମଗ୍‌ଦଲୀନି ମରିୟମ୍‌ନେ ଡାଗ୍ରା ନିଜେନେ ସାର୍ମୁଆଁ ଆକେକେ । ମୁଇଙ୍ଗ୍‌ ତର୍ ଜିସୁ ଆକେନ୍ ମରିୟମ୍‌ବାନ୍‌ ଗୁକ୍ଲିଗ୍ ଗଲିଆକେ ନୁଆଁବଗେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_10","071_16_10","MRK","16","10","10","ମରିୟମ୍‌ ଜିସୁକେ କେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍‌ନେ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଡାଗ୍ରା ୱେଚେ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ । ଆତେନ୍‌ ବେଲା ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଦୁକ୍ ଚିନ୍ତା ଡିଂଚେ ଅଁ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_11","071_16_11","MRK","16","11","11","ମରିୟମ୍‌ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, ଜେ ଜିସୁ ମ୍ୱ୍ରଲେଃକେ ଆରି ମେଁ ନିଜେ ଜିସୁକେ କେଲେଃକେ । ମାତର୍‌‌ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ମେଇଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅବିସ୍‌ବାସ୍ ଡିଂଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_12","071_16_12","MRK","16","12","12","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ମ୍ୱାୟା ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଯିରୁଶାଲମ ୱେନେ ବେଲା ଜିସୁ ମେଙ୍ଗ୍ ଡାଗ୍ରା ବିନ୍‌ନେ ସାର୍ମୁଆଁ ଆସୁଏକେ । ");
INSERT INTO gaq_vpl VALUES ("MK16_13","071_16_13","MRK","16","13","13","ଆକେନ୍ ସିସ୍‌‌ ମ୍ୱାୟା ଆଣ୍ଡେଚେ ଆରି ବିନ୍ ସିସ୍‌‌ଇଙ୍ଗ୍‌କେ ଆକେନ୍ ସାମୁଆଁ ବାଲିର୍‌କେ । ତେଲା ଡିଗ୍ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ମେଙ୍ଗ୍ ସାମୁଆଁକେ ସତ୍ ଆମାନେ ଆର୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK16_14","071_16_14","MRK","16","14","14","ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିବେଲା ଗମୁଇଂ ପ୍ରେରିତ୍‌ ଉଗ୍‌ଚଙ୍ଗ୍ ଆର୍‌ଡିଂକେ, ଅଃତେନ୍‍ ବେଲା ଜିସୁ ଆମେଇଂକେ ଦର୍ସନ୍‌ ବିଃକେ । ମେଁ ଆମେଇଂକେ ମେଇଂନେ ସତ୍‌ ଆମାନେଃକ୍ନେ ଆରି ମନ୍‌ନ୍ନିଆ ବୁଟ ନ୍‌ସା ବିସୟରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂଗେ । ଡାଗ୍‌ଲା ଜାଣ୍ଡେଇଂ ଜିସୁକେ ଗୁଏଚେ ଆର୍‌ମୁଇଂତର୍ ମ୍ୱ୍ର ଲେଃକେ ଡାଗ୍‌ଚେ କେଲେଃଆର୍‌ଗେ, ଆମେଇଂକେ ଆକେନ୍ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ ଆଲେଃ ଆର୍‌ଗେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("MK16_15","071_16_15","MRK","16","15","15","ବାରି ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ସାପା ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ୱେଚେ ନେଙ୍ଗ୍‌ନେ ଏନ୍ ନିମାଣ୍ତାସାମୁଆଁ ସାପାରେନେ ଡାଗ୍ରା ବାସଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("MK16_16","071_16_16","MRK","16","16","16","ମୁଡ଼ି ରେମୁଆଁଇଙ୍ଗ୍‌ ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଚେ ଦିକ୍ୟା ରାଙ୍ଗ୍‌ଡଆର୍‌ଏ, ମେଁଇଂ ରକ୍ୟା ବାଆର୍‌ଏ । ମାତର୍‌‌ ମୁଡ଼ି ରେମୁଆଁ ଅବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ, ଆମେକେ ଇସ୍‌ପର୍ ମାଲେ କସ୍‌ଟ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("MK16_17","071_16_17","MRK","16","17","17","ଆରି ବିସ୍‌ବାସିଇଙ୍ଗ୍‌କେ ଆକେନ୍ ସାପା ଚିନା ତ୍ନାଏ ମେଇଙ୍ଗ୍‌ ନେଙ୍ଗ୍ ମ୍ନିରେ ଗଲିଆ ଆନ୍ତାର୍‌ ବିଆର୍‌ଏ ତ୍ମି ତ୍ମିନେ ବାସାରେ ବାଲିର୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("MK16_18","071_16_18","MRK","16","18","18","ମେଇଙ୍ଗ୍ ନିଜେନେ ନ୍ତି ଅରିଆ ବୁବଃ ସାଃଆର୍‌ଏ ମାତର୍‌‌ ଆମେଇଂକେ ମେଃଡିଗ୍‌ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ । ମେଇଙ୍ଗ୍ ବିସ୍‌ ଡିଗ୍ ଉଗ୍‌ଆର୍‌ଏ ମାତର୍‌‌ ଆମେଇଂକେ ମେଃଡିଗ୍‌ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ । ଆକେନ୍ ରେମୁଆଁଇଂ ରଗ୍ ଆଡ଼ାତ୍ରା ନ୍ତି ବଆର୍‌ଏ ଆରି ରଗ୍‌ ସାଃଲେଃକ୍ନେ ରେମୁଆଁଇଂ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("MK16_19","071_16_19","MRK","16","19","19","ମାପ୍‌ରୁ ଜିସୁ ଆକେନ୍ ସାପା ସାମୁଆଁ ପ୍ରେରିତ୍‌ଇଂକେ ବାସଙ୍ଗ୍‌ ଆଃଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଆମେକେ କିତଙ୍ଗ୍‍ ଇନି ଡୁଂୱେଆର୍‌କେ ଆରି ପର୍‌ମେସର୍‌ନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା କଏ । ");
INSERT INTO gaq_vpl VALUES ("MK16_20","071_16_20","MRK","16","20","20","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ପ୍ରେରିତ୍‌ଇଂ ମଞ୍ଚ୍‍ପୁର୍‌ନେ ସାପାଜାଗାନ୍ନିଆ ୱେଚେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ତା ସାମୁଆଁ ବାସଙ୍ଗ୍ ବିଆର୍‌କେ ଆରି ମାପ୍ରୁ ଆମେଇଂକେ ସାଇଜ ଡିଂକେ । ମାପ୍ରୁ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‍କେ ଜେ ପ୍ରେରିତ୍‌ଇଂ ଆଣ୍ତିନେ ନିମାଣ୍ତା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ବକେ ଆତେନ୍‌ ସତ୍ । ମାପ୍ରୁ ଆମେଇଂକେ ଇରିଆତୁଗ୍ କାମ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବପୁ ବିଚେ ଆକେନ୍ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_1","072_1_1","LUK","1","1","1","ମ୍ନାରେ ଥିୟୋଫିଲସ୍ । ନେନେ ବାନ୍ ମେଃନେ ମେଃନେ ଗଟେ ଲେଃକେ ମେଁନେ ଗଟ୍‌ନାଇଂ ଗୁଆର୍‍ନ୍‍ସା ଗ୍ଲୁଏ ଜିଆ ଜିଆ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_2","072_1_2","LUK","1","2","2","ଆରାମ୍‍ ବାନ୍ ଆକେନ୍ ସାପା ଗଟ୍‌ନା କେଲେଃକ୍ନେ ରେମୁଆଁଇଂ ଡିରକମ୍ ନିମାଣ୍ଡା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ଆର୍‌ଗେ ଆତେନ୍‌ ଇସାବ୍‌ରେ ଗୁଆର୍‍ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_3","072_1_3","LUK","1","3","3","ତେସା ଅ ମାପ୍ରୁ ଥିୟୋଫିଲସ୍‌, ନେଙ୍ଗ୍ ଜତନ୍ ବାବ୍‌ରେ ପର୍‌ତୁମ୍‌ ବାନ୍‌ ଏନ୍ ସାପା ବିସୟ୍ ଦ୍ୟାନ୍‌ ଡିଂମ୍ୱଲା ପେନେ ଡାଗ୍ରା ଏନ୍ ମୁଇଂ ନିୟମ୍‌ ବାବ୍‌ରେ ଗୁଆର୍‌ ନ୍‌ସା ଟିକ୍‌ ମନେ ଣ୍ତିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_4","072_1_4","LUK","1","4","4","ଆକେନ୍ ସମ୍ପର୍କରେ ନାନେ ଆଣ୍ଡିନେ ସାପା ସାମୁଆଁ ଗିଆନ୍‍ ବାଚେ । ମେଁନେ ସର୍‌ତେ ସତ୍ ଡିରକମ୍ ବାୟାଏ ଆତେନ୍‌‌ସା ନେଙ୍ଗ୍ ଆକେନ୍ ଗୁଆର୍‍ ଣ୍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_5","072_1_5","LUK","1","5","5","ଜିଉଦା ଦେସ୍‌ନେ ଇଃସାଙ୍ଗ୍‌ ହେରୋଦ ଲେଃକ୍ନେ ବେଲା ଅବିୟ ଦଲ୍‍ନେ ଜିଖରୀୟ ମ୍ନିକ୍ନେ ମୁଇଂ ପୁଜାରି ଲେଃଗେ ମେଁନେ କୁନେଣ୍ଡେ ହାରୋଣ କୁଲ୍‌ନେ ସେଲାମ୍ୱୁଏ ମେଁନେ ମ୍ନି ଏଲିଶାବେଥ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK1_6","072_1_6","LUK","1","6","6","ମେଇଂ ମ୍ୱାୟା ପର୍‍ମେସର୍‍ ଡାଗ୍ରା ନିମାଣ୍ଡା ରେମୁଆଁ ଲେଃଗେ ମେଇଂ ମ୍ୱାୟା ମାପ୍ରୁନେ ସାପା ଆଦେସ୍‌ ପାଲନ୍ ଡିଙ୍ଗ୍ଆର୍‌ଡିଂଗେ । ମାପ୍ରୁ ରେମୁଆଁଇଂକେ ପାଲେନ୍‍ସା ବାସଙ୍ଗ୍‍ବକ୍ନେ ସାପା ସାମୁଆଁ ମେଇଂ ମ୍ୱାୟା ପାଲେଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_7","072_1_7","LUK","1","7","7","ମାତର୍‌ ମେଁଇଙ୍ଗ୍‌ନେ ମେଃଡିଗ୍ ଗୋ ଗିସିଆ ଆଲେଃଗେ ଣ୍ଡୁ । ଏଲିଶାବେଥ୍ ବାଞ୍ଜିବ‍ଏଃ ଲେଃଗେ ମ୍ୱାୟାନେ ବୟସ୍ ଜବର୍ ଡିଙ୍ଗ୍‌ୱେଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_8","072_1_8","LUK","1","8","8","ମେସୁଆ ଜିଖରିୟ ମନ୍ଦିର୍‌ନ୍ନିଆ ଇସ୍‌ପର୍‌ନେ ଡାଗ୍ରା ପାର୍‍ତନା କାମ୍ ଡିଂଡିଂଗେ, ଡାଗ୍ଲା ଆତାନ୍‌ ଦିନା ପୁଜାରି କାମ୍ ନ୍‌ସା ମେଁନେ ପାଲି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_9","072_1_9","LUK","1","9","9","ଦୁପ୍ ଆଃମଃ ନ୍‍ସା ପୁଜାରିଇଂ ସାପାବେଲା ମୁଇଙ୍ଗ୍ ପୁଜାରିକେ ବାଚେ ଡିଙ୍ଗ୍‌ଗେ । ଆତେନ୍‌‌ସା ଜିଖରୀୟକେ ବାଚେ ଆର୍‌କେ । ତେଲା ଜିଖରିୟ ମାପ୍ରୁନେ ମନ୍ଦିର୍‍ ବିତ୍ରେ ଦୁପ୍ ଆଃମଃ ନ୍‍ସା ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_10","072_1_10","LUK","1","10","10","ଆତେନ୍‌‌ ଦିନା ମେଁ ମନ୍ଦିର୍‌ ବିତ୍ରେ ଗାଚେ ଦୁପ୍‌ ବିନେ ବେଲା ବାଏରେ ମୁଇଂ ମାଲେ ରେମୁଆଁ ରିସିଂଚେ ମେଇଂ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_11","072_1_11","LUK","1","11","11","ଆତେନ୍‌ ବେଲା ଜିଖରିୟନେ ସେନୁଗ୍ ମାପ୍ରୁନେ ମୁଇଙ୍ଗ୍ କିତଂ ଦୁତ୍ ଦର୍ସନ୍ ବିକେ । ମେଁ ଦୁପ୍ ବେଦିନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା ତୁଆଁ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_12","072_1_12","LUK","1","12","12","ଜିଖରୀୟ କିତଙ୍ଗ୍‍ ଇନି ଦୁତ୍‌କେ କେକ୍ନେ ଦାପ୍ରେ ତେରେପେତେ ଆରି ଜବର୍ ବୁଟକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_13","072_1_13","LUK","1","13","13","ମାତର୍‌ କିତଂ ଦୁତ୍ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଜିଖରୀୟ ! ଆବ୍‌ଟଗେ ନାମଃ ନାନେ ପାର୍‍ତନା ପର୍‍ମେସର୍‍ ଅଁ ଲେଃକେ । ନାନେ ନାକୁନେ ଏଲିଶାବେଥ୍ ମୁଇଙ୍ଗ୍ ଙ୍ଗିର୍‍ବଏଅ ଣ୍ଡିଆ କୁମାଏ । ପେଇଂ ମେଁନେ ମ୍ନି ଜହନ୍‌ ପେବଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_14","072_1_14","LUK","1","14","14","ନାନେ ଜାବର୍‌ ସାର୍ଦା ନାଡିଙ୍ଗ୍‌ଏ । ମେଁନେ ଜନମ୍‍ ନ୍‌ସା ଗୁଲେ ରେମୁଆଁ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_15","072_1_15","LUK","1","15","15","ମାପ୍ରୁନ୍‌ସା ଜହନ୍‌ ମ୍ନା ଡିଗ୍ ଏ । ମେଁ ଅଃନା ଡିଙ୍ଗ୍ ଅଙ୍ଗୁର୍ ରସ୍ ଆରି ସାଗ୍ରା ଆଉଗ୍ ଣ୍ଡୁ ଦେକ୍‌ରକମ୍‍ କି ଜନମ୍ ବେଲା ମେଁ ପବିତ୍ର ଆତ୍ମାରେ ବର୍‌ତି ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_16","072_1_16","LUK","1","16","16","ଜହନ୍‌ ଗୁଲେ ଇଶ୍ରାୟେଲ ରେମୁଆଁଇଂକେ ମାପ୍ରୁନେ ଡାଗ୍ରା ଆଣ୍ଡେ ପାଙ୍ଗ୍‍ନ୍‍ସା ସାଇଜ ଡିଙ୍ଗ୍‌ଏ । ମାପ୍ରୁ ମେଁଇଙ୍ଗ୍‌ନେ ପର୍‌ମେସର୍‌ । ");
INSERT INTO gaq_vpl VALUES ("LK1_17","072_1_17","LUK","1","17","17","ଜହନ୍‌ ନିଜେ ମାପ୍ରୁନେ ସେନୁଗ୍ ୱେଏ । ମେଁ ଏଲୀୟ ରକମ୍ ବପୁ ଡିଙ୍ଗ୍ଏ । ମେଁ ଏଲୀୟନେ ଆତ୍ମା ବାଏ । ମେଁ ଆବାଡ଼େଇଂ ଆରି ଗଡ଼େଇଂନ୍ନିଆବାନ୍ ସାନ୍ତି ଆଃଡିଙ୍ଗ୍‍ । ପର୍‌ମେସର୍‌କେ ଆମାନେ ମ୍ୟାକ୍ନେ ଗୁଲେ ରେମୁଆଁଇଂକେ ଦର୍ମ ରେମୁଆଁଇଂନେ ମୁଆଃ ଟିକ୍ ଗାଲିପାକା ମେଁ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଏ । ଆରି ମାପ୍ରୁନେ ପାଙ୍ଗ୍‌ନ୍‌ସା ମେଁ ରେମୁଆଁଇଂକେ ତିଆର୍ ଆଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_18","072_1_18","LUK","1","18","18","ଜିଖରୀୟ କିତଙ୍ଗ୍‍ଇନିନେ ଦୁତ୍‍କେ ବାଲିର୍‌କେ “ନାନେ ମେଃମେଃ ବାସଙ୍ଗ୍‌ନାଡିଂକେ, ଆତେନ୍‌ ସତ୍ ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍ ଡିରକମ୍ ମ୍ୟାଏ ? ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ଡକ୍ରା ରେମୁଆଁ ଆରି ନେଙ୍ଗ୍‌ନେ ନେକୁନେଃ ଡିଗ୍ ଡକ୍ରି ଡିଙ୍ଗ୍ ୱେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_19","072_1_19","LUK","1","19","19","କିତଙ୍ଗ୍‍ଇନିନେ ଦୁତ୍ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ଗାବ୍ରିଏଲ୍ । ନେଙ୍ଗ୍ ପର୍‌ମେସର୍‌ନେ ସାମ୍‌ନେ ତୁଆଁ ଲେଃମ୍ୟାକେ । ନାନେ ଏତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‍ସା ଆରି ଏନ୍‌ ନିମାଣ୍ଡା ସାମୁଆଁ ବିଃନ୍‍ସା ପର୍‍ମେସର୍‍ ଆନେଙ୍ଗ୍‌କେ ବେବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_20","072_1_20","LUK","1","20","20","ଏବେ ଅଁପା ! ନାନେ ନେଙ୍ଗ୍ ସାମୁଆଁରେ ବିସ୍‌ବାସ୍‌ ପେଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ମାତର୍‌ ଡିଲାଡିଗ୍ ବେଲା ପାଙ୍ଗ୍‌ଲା ଏନ୍‌ ସତ୍ ଡାଗ୍‌ଚେ ପାର୍‍ମାନ୍‌ ଡିଙ୍ଗ୍‍ଏ । ଏବେ ପେଇଂ କନ୍ଦା ଡିଙ୍ଗ୍‍ପେୱେଏ । ଉଡ଼ି ଜାକ ଏନ୍‌ ନ୍‍ସା ଆଗଟେକେ ଆତେନ୍‌ ଜାକ ପେଇଂ ବାସଙ୍ଗ୍‌ନେ ବପୁ ଆଃରେଚେ ପେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_21","072_1_21","LUK","1","21","21","ଆତେନ୍‌ ବେଲା ରେମୁଆଁଇଙ୍ଗ୍ ଜିଖରୀୟକେ ବାଏରେ ଉର୍‍ଲେ ଆର୍‌ଗେ । ମେଇଂ ଇରିଆତୁଗ୍ ଆର୍‌ଗେ ଜେ ଅଃକେନ୍ ବେଲା ଜାକ ଜିଖରିୟ ମନ୍ଦିର୍‍ ବିତ୍ରେ ମେଁନ୍‌ସା ଅଟ୍‌କେ ୱେଲେଗେ ! ");
INSERT INTO gaq_vpl VALUES ("LK1_22","072_1_22","LUK","1","22","22","ଉଡ଼ିବେଲା ଜିଖରିୟ ବାଏରେ ପାଙ୍ଗ୍‌କେ ଆତେନ୍‌ ବେଲା ମେଁ ମେଃଡିଗ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ ୟାଆଡିଂଗେ ଣ୍ଡୁ । ଆତେନ୍‌‌ସା ମେଇଂ ବୁଜେ ୟାଆର୍‌କେ ଜେ ମେଁ ମନ୍ଦିର୍‍ ବିତ୍ରେ ମେଃଡିଗ୍ ଦର୍ସନ୍ ବାଲେକେ । ମେଁ କନ୍ଦାଗୁଲା ଡିଗ୍ ୱେଲେଃଗେ ଆରି ମେଁ ବାଆଃ ମାୱେଚେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_23","072_1_23","LUK","1","23","23","ଜିଖରୀୟନେ ଜତନ୍‌ ସ୍ଲେନେ ବେଲା ଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଡୁଆ ଆଣ୍ଡେ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_24","072_1_24","LUK","1","24","24","ତେନ୍‌ ଇଡ଼ିଂ ଜିଖରୀୟନେ କୁନେଡେ ଏଲିଶାବେଥ୍ ସର୍‌ତେ ଉଂକେ ତେସା ଏଲିଶାବେଥ୍ ଡୁଆ ବାଏରେ ମାଲ୍ ଆର୍କେ ଜାକ ଆତାର୍‍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK1_25","072_1_25","LUK","1","25","25","ଏଲିଶାବେଥ୍ ବାସଙ୍ଗ୍‌କେ “କେଲା ସାରାସାରିବେଲା ପର୍‍ମେସର୍‍ ଆନେଙ୍ଗ୍‌କେ ସାଇଜ ଡିଙ୍ଗ୍‍ବକେ । ରେମୁଆଁଇଂନେ ବାନ୍ ନେଙ୍ଗ୍‌ନେ ଗିଆସ ଆଃଡିଙ୍ଗ୍ ନ୍‌ସା ମାପ୍ରୁ ନେଙ୍ଗ୍ ଆଡ଼ାତ୍ରା ସାଃଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_26","072_1_26","LUK","1","26","26","ଏଲିଶାବେଥ୍‌କେ ଗାଗ୍‌ଡ଼େନେ ତୁର୍ ଆର୍‌କେ କେଲା ଗାବ୍ରିଏଲ୍ ଦୁତ୍ ଇସ୍‌ପର୍‌ନେ ବାନ୍ ଗାଲିଲୀନେ ନାଜରିତ ମ୍ନିକ୍ନେ ଇନିନ୍ନିଆ ମୁଇଙ୍ଗ୍ ସେଲା ଡାଗ୍ରା ବେକେ; ");
INSERT INTO gaq_vpl VALUES ("LK1_27","072_1_27","LUK","1","27","27","ଦାଉଦ୍‍ ବଂସନେ ଯୋସେଫ୍‌ ମ୍ନିକ୍ନେ ମୁଇଂ ଙ୍ଗିରେ ଏତେ ମେଁନେ ବିଏ ଡିଙ୍ଗ୍‌ନେ ସାଲିଆ ବଗେ ! ଆତେନ୍‌ ସେଲାନେ ମ୍ନି ମରିୟମ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK1_28","072_1_28","LUK","1","28","28","କିତଂ ଦୁତ୍ ଆତେନ୍‌ ସେଲା ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ନାନେ ସାନ୍ତି ଡିଂଲେଃ । ମାପ୍ରୁ ଆନାକେ ଲିବିସଃ ଡିଂବକେ । ମେଁ ନାଁ ଏତେ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_29","072_1_29","LUK","1","29","29","ମରିୟମ୍ କିତଂ ଦୁତ୍‌ନେ ସାମୁଆଁ ଅଁଚେ ଚମ୍‍କେ ୱେକେ । ମେଁନେ ଅର୍‌ତ ମେଁନେ ଡିଙ୍ଗ୍‍ୟାଏ ଆତେନ୍‌ ସାମୁଆଁ ବାବେଚେ ମେଁ ଚିନ୍ତାଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_30","072_1_30","LUK","1","30","30","କିତଂ ଦୁତ୍ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ମରିୟମ୍ ! ଆବ୍‌ଟଗେ ନାମଃ । ଡାଗ୍ଲା ପର୍‌ମେସର୍‌ ନାନେ ଆଡ଼ାତ୍ରା ଲିବିସ ଡିଙ୍ଗ୍‍ବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_31","072_1_31","LUK","1","31","31","ଆରି କେଲା ନା ଗାଗ୍‌ଡ଼େ ସାଚେ ମୁଇଙ୍ଗ୍ ଗଡ଼େଅ ଜନମ୍ ନାଡିଙ୍ଗ୍‌ଏ ଆରି ମେଁନେ ମ୍ନି ଜିସୁ ନାବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_32","072_1_32","LUK","1","32","32","ମେଁ ମ୍ନାରେ ଡିଙ୍ଗ୍‌ଏ ଆରି ପର୍‌ମେସର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଡାଗ୍‌ଚେ ଉଡ୍ରା ଡିଙ୍ଗ୍‌ଏ; ମାପ୍ରୁ ଇସ୍‌ପର୍ ଆମେକେ ମେଁଇଙ୍ଗ୍‌ନେ ନ୍ତା ଞ୍ଜାନେ ଦାଉଦ୍‍ନେ ସିଂଆସନ ବିଏ ");
INSERT INTO gaq_vpl VALUES ("LK1_33","072_1_33","LUK","1","33","33","ମେଁ ଜାକୁବ୍‌ନେ କୁଲ୍‌ ଆଡ଼ାତ୍ରା ମାଡାନେ ଜୁଗ୍‌ ଜାକ ସାସନ୍‍ ଡିଙ୍ଗ୍‌ଏ ଆରି ମେଁନେ ରାଇଜ୍ ଆଃଡା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK1_34","072_1_34","LUK","1","34","34","ତେଲା ମରିୟମ୍ ଦୁତ୍‌କେ ବାସଙ୍ଗ୍‌କେ ଏନ୍ ଡିରକମ୍ ଡିଙ୍ଗ୍‌ଏ ? ନେଙ୍ଗ୍‍ ତ ଙ୍ଗିର୍‌ବ‍ଏ ଏତେ ନ୍ନାମିସୁକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK1_35","072_1_35","LUK","1","35","35","ଦୁତ୍ ଆମେକେ ଉତର୍ ବିକେ ପବିତ୍ର ଆତ୍ମା ନାଁ ଆଡ଼ାତ୍ରା ପାଙ୍ଗ୍‌ଏ ଆରି ପର୍‌ମେସର୍‌ନେ ବପୁ ଆନାକେ ଡାଡୁଂପାଙ୍ଗ୍‍ଏ ଆତେନ୍‌‌ସା ଜାଣ୍ଡେ ଜନମ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ପବିତ୍ର ଆରି ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଡାଗ୍‌ଚେ ଉଡ୍ରା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_36","072_1_36","LUK","1","36","36","ଆରି କେଲା ନାନେ ନିଜର୍ ରେମୁଆଁ ଏଲିଶାବେଥ୍ ଡିଗ୍ ଡକ୍ରିବେଲା ମୁଇଙ୍ଗ୍ ଗଡ଼େଅ ସୁଲୁଏ ବିତ୍ରେ ସାଃଲେଃକେ । ଜେ ବାଞ୍ଜିବ‍ଏଃ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ ମ୍ୟାଃଆର୍‌କେ ମେଁନେ ଏକ୍ରେ ତୁର୍ ଆର୍‌କେ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ; ");
INSERT INTO gaq_vpl VALUES ("LK1_37","072_1_37","LUK","1","37","37","ଡାଗ୍ଲା ଇସ୍‌ପର୍‌ନେ ବାନ୍ ତାର୍‍କ୍ନେ ମେଃଡିଗ୍ ସାମୁଆଁ ବପୁଇନ୍‍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_38","072_1_38","LUK","1","38","38","ମରିୟମ୍ ବାସଙ୍ଗ୍‌କେ “କେଲାପା ନେଙ୍ଗ୍ ମାପ୍ରୁନେ ଦାସୀ ନାନେ ଆନେଙ୍ଗ୍‌କେ ମେଁନେ ନାବାସଙ୍ଗ୍‍କେ ନେଙ୍ଗ୍‍ସା ଆତେନ୍‌ ଅଁ ଡିଙ୍ଗ୍‌ଲେ ।” ତେନ୍‌ ଇଡ଼ିଂ କିତଂ ଦୁତ୍ ମେବାନ୍‍ ତାର୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_39","072_1_39","LUK","1","39","39","ଏନ୍‌ ବେଲା ମରିୟମ୍ ତଡ଼ିଆଚେ କଣ୍ଡା ରାଜିନେ ଏରିଆ ଜିଉଦା ଦେସ୍‌ନେ ମୁଇଙ୍ଗ୍ ଇନିନ୍ନିଆ ଟାପ୍‌ନା ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_40","072_1_40","LUK","1","40","40","ଆରି ଜିଖରୀୟନେ ଡୁଆ ଗାଚେ ଏଲିଶାବେଥ୍‌କେ ସାର୍ଲ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_41","072_1_41","LUK","1","41","41","ଆରି ଏଲିଶାବେଥ୍ ନମସ୍କାର୍‍ ଅଁ ନେନେ ଦାପ୍ରେ ଆତେନ୍‌ ଡାଆଁ ଗଡ଼େଅ ମରିୟମ୍‍ନେ ସୁଲୁଏ ବିତ୍ରେ ୱାଡ଼େଙ୍ଗ୍‍ ୱାଚେ ତଡ଼ିଆକେ ଆରି ଏଲିଶାବେଥ୍ ପବିତ୍ର ଆତ୍ମା ବାଚେ ତଡ଼ିଆକେ ");
INSERT INTO gaq_vpl VALUES ("LK1_42","072_1_42","LUK","1","42","42","ଆରି ଏଲିଶାବେଥ୍ କିରଚେ ବାସଙ୍ଗ୍‌କେ “ନାନେ ସାପା ସେଲାମ୍ବୁଏବାନ୍ ଜବର୍ ଦନ୍ୟ । ଦନ୍ୟ ନାନେ ଗର୍ବେନେ ଗଡ଼େଅ । ");
INSERT INTO gaq_vpl VALUES ("LK1_43","072_1_43","LUK","1","43","43","ଆରି ନେଙ୍ଗ୍ ମାପ୍ରୁନେ ଇୟାଙ୍ଗ୍ ଜେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଏ ନେଙ୍ଗ୍‌ନେ ଏନ୍‌ ନିମାଣ୍ଡା ବେଲା ଆଣ୍ଡିବାନ୍ ପାଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("LK1_44","072_1_44","LUK","1","44","44","ନେଙ୍ଗ୍ ନାନେ ବାଲିର୍‌ବାତାନେ ସାମୁଆଁ ଅଁନେ ଦାପ୍ରେ ନେଙ୍ଗ୍‌ନେ ଗର୍ବେନେ ଗଡ଼େଅ ସାର୍ଦାରେ ୱାଡ଼େଙ୍ଗ୍‍ ୱାଚେ ତଡ଼ିଆକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_45","072_1_45","LUK","1","45","45","ନାନେ ଦନ୍ୟ । ଡାଗ୍ଲା ମାପ୍ରୁ ଆନାକେ ମେଁନେ ବାସଙ୍ଗ୍‍ବଗେ ନାନେ ଆତେନ୍‌‌ ବିସ୍‌ବାସ୍‍ ଡିଙ୍ଗ୍‍ନାବ । ଏନ୍‌ ସାମୁଆଁ ସତେଆ ଗଟେଏ ଡାଗ୍‌ଚେ ନାନେ ବିସ୍‌ବାସ୍‍ ନାଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_46","072_1_46","LUK","1","46","46","ଆତ୍‌ବା ମରିୟମ୍ ବାସଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍‌ନେ ପାରାନ୍‌ ମାପ୍ରୁକେ ପ୍ରସଂସା ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_47","072_1_47","LUK","1","47","47","ଆରି ନେଙ୍ଗ୍‌ନେ ଆତ୍ମା ନେଙ୍ଗ୍‌ନେ ଉଦାର୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଇସ୍‌ପର୍‌ନ୍ନିଆ ସାର୍ଦା ଆଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_48","072_1_48","LUK","1","48","48","ନେଙ୍ଗ୍‌ନେ ମେଁନେ ଜଗ୍ୟ ଣ୍ଡୁ ମାତର୍‌ ପର୍‍ମେସର୍‍ ନେଙ୍ଗ୍ ସୁଗୁଆ ଅର୍‍କିତ୍‍ ରେମୁଆଁ ଆଡ଼ାତ୍ରା ଦୟା ଆସୁଏକେ । ଏକେବାନ୍‍ ସାପାରେ ଆନେଙ୍ଗ୍‌କେ ସୁକ୍ ରେମୁଆଁ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_49","072_1_49","LUK","1","49","49","ଡାଗ୍ଲା ସାପାଟୁ ବପୁରେ ପର୍‍ମେସର୍‍ ନେଙ୍ଗ୍‍ସା ମ୍ନା କାମ୍ ସାପା ଡିଙ୍ଗ୍ ବକେ । ମେଁଇଙ୍ଗ୍‌ନେ ମ୍ନି ପବିତ୍ର । ");
INSERT INTO gaq_vpl VALUES ("LK1_50","072_1_50","LUK","1","50","50","ଜାଣ୍ଡେଇଂ ଆମେକେ ବୁଟ ଆର୍‌ଏ । ମେଁ ଆମେଇଂକେ କାଲାଆଃ ଲିବିସ ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_51","072_1_51","LUK","1","51","51","ମେଁ ମେଁନେ ନ୍ତିନେ ବପୁ ଆଃସୁଏ ବକେ । ମେଁ ଆଂକାର୍ ରେମୁଆଁଇଂକେ ଚିନ୍‍ଚତର୍‍ ଆଡିଙ୍ଗ୍‌ଚେ ମେଁଇଙ୍ଗ୍‌ନେ ସାପା ଉପାୟ୍‌ ଦଂସ ଆଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_52","072_1_52","LUK","1","52","52","ପର୍‍ମେସର୍‍ ଇଃସାଙ୍ଗ୍‌ଇଂକେ ସିଂଆସନ ବୁନ୍ଦେ ଆଜର୍‍କେ । ଆରି ଗରିବ୍ ରେମୁଆଁଇଂକେ ଆମ୍ନାଏ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_53","072_1_53","LUK","1","53","53","ମେଁ କେଡ଼େସ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଚଙ୍ଗ୍‌ନେ ବିବକେ । ବାରି ସାଉକାର୍‌ ରେମୁଆଁଇଂକେ ସରା ନ୍ତିନ୍ନିଆ ଆଣ୍ତେ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_54","072_1_54","LUK","1","54","54","ନେନେ ଅଃସେଣ୍ଡ୍ରେଇଂ ଆଡ଼ାତ୍ରା ମେଁନେ ପାର୍‌ମାନ୍ ମେଁ ରକ୍ୟା ଡିଂବକେ ବାରି ମେଁନେ ଚାକର୍‌ ଇଶ୍ରାୟେଲ୍‌କେ ସାଇଜ ଡିଂବକେ । ମେଁ ଆନେକେ ମେଁନେ ଦୟା ବିବକେ ");
INSERT INTO gaq_vpl VALUES ("LK1_55","072_1_55","LUK","1","55","55","ମେଁ ଆନେକେ ନ୍ତା ଞ୍ଜାଇଂକେ ଅବ୍ରାହାମ୍ ଆରି ମେଁନେ ଗୋ ଗିସିଆକେ ଜୁଗ୍ ଜୁଗ୍ ଦୟା ଆଃସୁଏନ୍‌ସା ବିବକ୍ନେ ଅସେନେ ସାମୁଆଁ ପାଲେ ବଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_56","072_1_56","LUK","1","56","56","ଆରି ମରିୟମ୍ ଞ୍ଜି ଆର୍‌କେ ଜାକ ଏଲିଶାବେଥ୍ ଡାଗ୍ରା ଲେଃଚେ ଇଡ଼ିଙ୍ଗ୍ ନିଜେନେ ଡୁଆ ଆଣ୍ଡେ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_57","072_1_57","LUK","1","57","57","ଇଡ଼ିଙ୍ଗ୍ ଏଲିଶାବେଥ୍‌ନେ ଣ୍ଡିଆ କୁମାନେ ଦିନା ଡିଙ୍ଗ୍ ୱେଗେ ମେଁ ମୁଇଙ୍ଗ୍ ଗଡ଼େଅ ଣ୍ଡିଆ କୁମାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_58","072_1_58","LUK","1","58","58","ଆରି ମେଁନେ ଡୁଆ ଡାଗ୍ରାଣ୍ଡ୍ରେଇଂ ଆରି ଡୁଆଣ୍ଡ୍ରେଇଂ ଅଁକେ ଜେ ମାପ୍ରୁ ମେଁ ଆଡ଼ାତ୍ରା ଜବର୍ ଦୟା ଆସୁଏବକେ । ମେଇଂ ଏଲିଶାବେଥ୍ ସାର୍ଦା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_59","072_1_59","LUK","1","59","59","ଗଡ଼େଅନେ ଜନମ୍ ଡିଙ୍ଗ୍‌ନେ ତ୍ମା ଦିନା ମେଇଙ୍ଗ୍ ଗଡ଼େଅକେ ପବିତ୍ର ଆଃଡିଂନେ ପାଙ୍ଗ୍‌ଆର୍‌କେ ଆରି ମେଇଂ ଗଡ଼େଅନେ ମ୍ନି ମେଁନେ ଆବାଡ଼େନେ ମ୍ନି ଇସାବ୍‌ରେ ଜିଖରୀୟ ବିଃନେ ଚାଏଁଆର୍‍ଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_60","072_1_60","LUK","1","60","60","ମାତର୍‌ ମେଁ ଇୟାଙ୍ଗ୍‌ଡେ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ ମେଁ ମ୍ନି ଜହନ୍ ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_61","072_1_61","LUK","1","61","61","ରେମୁଆଁଇଂ ଏଲିଶାବେଥ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ପେନେ ନିଜର୍‌ନେ ରେମୁଆଁଇଂନ୍ନିଆ ଦେକ୍ ସୁଗୁଆ ମ୍ନି ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_62","072_1_62","LUK","1","62","62","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ ମେଁନେ ବାଡ଼େକେ ସାଲିଆକୁକେ “ନାନେ ଏନ୍‌ ଗଡ଼େଅନେ ମ୍ନି ମେଁନେ ବିଃନେ ଚାଏଁ ନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK1_63","072_1_63","LUK","1","63","63","ଆକେନ୍ ଅଁଚେ ଜିଖରିୟ ଗୁଆର୍‍ନ୍‍ସା ଆମେଇଂକେ ମୁଇଙ୍ଗ୍ ଗୁଆର୍‍ନେ ବାଲା ସାଲିଆଚେ ଆତ୍‌ଅରିଆ ଗୁଆର୍‍ ଆର୍‌କେ ମେଁନେ “ମ୍ନି ଯହନ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_64","072_1_64","LUK","1","64","64","ସାପା ରେମୁଆଁ ଇରିଆତୁଗ୍ ୱେ ଆର୍‌ଗେ । ତେନ୍‌ ଇଡ଼ିଂ ଜିଆଃଜିଆଃ ଜିଖରୀୟନେ ତୁମୁଆଃ ରଃୱେଗେ । ମେଁ ବାଲିର୍ ୟାକେ । ମେଁ ପର୍‍ମେସର୍‍ନେ ପୁଜା ଡିଙ୍ଗ୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_65","072_1_65","LUK","1","65","65","ମେଁଇଙ୍ଗ୍‌ନେ ଡୁଆ ଡାଗ୍ରାନେ ସାପା ରେମୁଆଁ ବୁଟ ଆର୍‌କେ । ଜିଉଦାନେ ସାପା କଣ୍ଡାରାଜିନେ ରେମୁଆଁ ଏନ୍‌ ସାପା ଗଟ୍‌ନା ବିସୟ୍‌ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_66","072_1_66","LUK","1","66","66","ଏନ୍‌ ସାମୁଆଁ ଜାଣ୍ଡେଇଂ ଅଁଆର୍କେ ମେଇଂ ଇରିଆତୁଗ୍ ୱେଆର୍‌କେ । ରେମୁଆଁଇଂ ବାବେ ଆର୍‌କେ ଜେ “ଏନ୍‌ ଗଡ଼େଅ ମେଁନେ ଡିଙ୍ଗ୍‌ଏ ?” ମାପ୍ରୁନେ ନ୍ତି ଏନ୍‌ ଗଡ଼େଅ ଏତେ ଲେଃକେ ମେଇଂ ଦେକ୍‍ସୁଗୁଆ ବାବେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_67","072_1_67","LUK","1","67","67","ଆରି ମେଁନେ ଆବାଡ଼େ ଜିଖରୀୟ ପବିତ୍ର ଆତ୍ମାରେ ପୁର୍ତି ଡିଙ୍ଗ୍‌ଚେ ତଡ଼ିଆକେ । ଆରି ମେଁ ବବିସତ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ; ");
INSERT INTO gaq_vpl VALUES ("LK1_68","072_1_68","LUK","1","68","68","“ଇଶ୍ରାୟେଲନେ ମାପ୍ରୁ ପର୍‍ମେସର୍‍ନେ ପ୍ରସଂସା ଅସ୍‌ମାର୍ ସାର୍‍ପା । ମେଁ ନିଜେନେ ରେମୁଆଁଇଂକେ ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‍ସା ପାଙ୍ଗ୍‌ଲେକେ ଆରି ଆମେଇଂକେ ମୁକ୍‌ତି ବିଃନ୍‍ସା ପାଙ୍ଗ୍‌ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_69","072_1_69","LUK","1","69","69","ମେଁ ନେନ୍‍ସା ମେଁଇଙ୍ଗ୍‌ନେ ଚାକର୍‌ ଦାଉଦ୍‍ନେ ବଂସବାନ୍‍ ମୁଇଙ୍ଗ୍ ବପୁ ଲେଃକ୍ନେ ଉଦାର୍ କର୍ତ୍ତାକେ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_70","072_1_70","LUK","1","70","70","ଅସେବାନ୍ ବାସାଚେ ଲେଃମ୍ୟାକ୍ନେ ନିଜେ ପବିତ୍ର ବାବବାଦିଇଂବାନ୍‍ ପର୍‍ମେସର୍‍ ଏନ୍‍ ଡିଙ୍ଗ୍ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_71","072_1_71","LUK","1","71","71","ମେଁ ଆନେକେ ନେନେ ସତ୍ରୁଇଂନେବାନ୍ ବା ଆନେକେ ଇଙ୍ଗ୍‌ଚେ ଡିଙ୍ଗ୍‌ମ୍ୟାଣ୍ଡ୍ରେକେ ସାପାନେ ନ୍ତିବାନ୍‍ ଉଦାର୍ ଡିଙ୍ଗ୍ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_72","072_1_72","LUK","1","72","72","ମେଁ ନେନେ ନ୍ତା ଞ୍ଜାଇଂକେ ଦୟା ଆଃସୁଏଃଏ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ବଗେ ଆରି ମେଁ ମେଁନେ ପବିତ୍ର ନିୟମ୍‌ ମନେ ଡିଙ୍ଗ୍‍ବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_73","072_1_73","LUK","1","73","73","ନେଇଂନେ ଆବା ଅବ୍ରାହାମ୍‍ନେ ଡାଗ୍ରା ମେଃନେ ପାର୍‌ମାନ୍ ଡିଂବଗେ ନିଜର୍ ଆତେନ୍‌ ପବିତ୍ର ନିୟମ୍ ମନେ ତ୍ଲାଗ୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK1_74","072_1_74","LUK","1","74","74","ଜେ ମେଁ ଆନେକେ ନେନେ ସତ୍ରୁନେ ବପୁବାନ୍‍ ଆନ୍ତାର୍‌ଏ । ତେଲା ନେ ମାବ୍‌ଟଚେ ପର୍‍ମେସର୍‍ନେ ସେବା ଡିଙ୍ଗ୍‍ନେୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_75","072_1_75","LUK","1","75","75","ନେ ଡିରକମ୍ ନିମାଣ୍ତା ଜିବନ୍‌ ମେଁନେ ସାମ୍ନାନ୍ନିଆ ପବିତ୍ର ବାରି ଦରମ୍‌ ଡିଙ୍ଗ୍‌ନେୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_76","072_1_76","LUK","1","76","76","ଏ ନେଙ୍ଗ୍‌ନେ ଗଡ଼େଅ ନାନେ ସାପାବାନ୍‍ ମ୍ନା ଇସ୍‌ପର୍‌ନେ ମୁଇଙ୍ଗ୍ ବାବବାଦି ରକମ୍ ମ୍ନି ନାରାକଏ ମାପ୍ରୁନେ ପାଙ୍ଗ୍‌ନ୍‌ସା ରେମୁଆଁଇଂକେ ଆର୍ମେ ଆଡିଙ୍ଗ୍‍ସା ମାପ୍ରୁନେ ସେନୁଗ୍‍ ନା ପର୍‍ତୁମ୍‍ ନାୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_77","072_1_77","LUK","1","77","77","ପର୍‍ମେସର୍‍ନେ ରେମୁଆଁଇଂକେ ନାନେ ଆଃମ୍ୟାଃନାବିଏ ଜେ ମେଁଇଙ୍ଗ୍‌ନେ ପାପ୍‍କେ କେମା ଡିଙ୍ଗ୍‌ନାବିଏ । ଆମେଇଂକେ ଉଦାର୍ ନେଡିଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_78","072_1_78","LUK","1","78","78","ଆରି ନେନେ ପଦ୍‍ ସାନ୍ତି ଗାଲିପାକା ଡୁଂପାଙ୍ଗ୍‍ ନ୍‍ସା । ନେନେ ଇସ୍‌ପର୍‌ନେ ଆଣ୍ଡିନେ ଆଲାଦ୍ ଲିବିସଃ ନ୍‌ସା ପରିତ୍ରାନ୍‍ନେ ସ୍ନି ନେନେ ଆଡ଼ାତ୍ରା ଆତାର୍ କିଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK1_79","072_1_79","LUK","1","79","79","ଗୁଏଚେ ବୁଟଚେ ତାଙ୍ଗ୍‍କିକ୍‍ ବିତ୍ରେ ବାସା ଲେଃକ୍ନେ ରେମୁଆଁ ପର୍‍ମେସର୍‍ କିତଂନେ ତାର୍‌କିଗ୍ ଏତେ ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‌ଏ । ମେଁ ଆନେକେ ସାନ୍ତି ଗାଲିପାକା ୱାଡୁଂୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK1_80","072_1_80","LUK","1","80","80","ଆରି ଗଡ଼େଅ ମ୍ନାଚେ ଆତ୍ମାରେ ବପୁ ଡିଙ୍ଗ୍‌ନେ ଲାଗେକେ ଆରି ଇସ୍ରାଏଲ୍‍ ଡାଗ୍ରା ଉଡ୍ରା ଆଡିଙ୍ଗ୍ ଜାକ ରେମୁଆଁ ଣ୍ଡୁନେ ଜାଗାନ୍ନିଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_1","072_2_1","LUK","2","1","1","ଆତେନ୍‌ ବେଲା ରୋମ୍ ରାଜ୍ୟନେ ମ୍ନାଇଃସାଙ୍ଗ୍‌ ଅଗଷ୍ଟସ୍ କାଇସର ବାନ୍ ଦେସ୍‌ନେ ସାପା ରେମୁଆଁଇଂନେ ମ୍ନି ଆଗୁଆର୍‌ ନ୍‌ସା ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_2","072_2_2","LUK","2","2","2","ସିରିଆନେ ସାସନ୍‌ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେ କ୍ୱିରୀଣୀୟନେ ବେଲା ସେନୁଗ୍ ଏନ୍ ମ୍ନି ଆଗୁଆର୍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_3","072_2_3","LUK","2","3","3","ଆତେନ୍‌‍ସା ସାପାରେ ମ୍ନି ଆଗୁଆର୍‌ ନ୍‌ସା ନିଜର୍ ନିଜର୍ ସହର ନ୍ନିଆ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_4","072_2_4","LUK","2","4","4","ଆରି ଯୋସେଫ୍‌ ଡିଗ୍ ମ୍ନି ଆଗୁଆର୍‌ ନ୍‌ସା ମରିୟମ୍ ଏତେ ଗାଲିଲୀନେ ନାଜରିତ ସହର୍‌ବାନ୍ ଜିଉଦା ପ୍ରଦେସ୍‌ନେ ବେଥ୍‌ଲେହିମ ମ୍ନିକ୍ନେ ଦାଉଦନେ ସହର୍‌ନ୍ନିଆ ୱେକେ ଡାଗ୍ଲା ମେଁ ଦାଉଦନେ କୁଲ୍‍ ଆରି କୁଲ୍‌ନେ ରେମୁଆଁ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_5","072_2_5","LUK","2","5","5","ଯସେପ୍‍ ଏତେ ମରିୟମ୍‌ନେ ବିଏନେ ସାଲିଆ ବଗେ ଆରି ମେଁ ସର୍‌ତେ ଉଂ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_6","072_2_6","LUK","2","6","6","ମେଇଙ୍ଗ୍ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଲେଃକ୍ନେ ବେଲା ମେଁନେ ଣ୍ଡିଆକୁମାନେ ବେଲା ଡିଙ୍ଗ୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_7","072_2_7","LUK","2","7","7","ଆରି ମେଁ ଙ୍ଗିର୍‌ବଃଅ ଜନମ୍‌ ବିଃକେ ଆରି ଆମେକେ ପାଟାଏ ଏଃତେ ଆଃକୁଇଚେ ସାଲାତ୍ୟା କୁଣ୍ଡ୍‌ଅରିଆ ଆଃଡୁଲେଗ୍ ଆର୍‌କେ ଡାଗ୍ଲା ବାସା ନ୍‍ସା ମେଇଂ ନ୍‌ସା ଜାଗା ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK2_8","072_2_8","LUK","2","8","8","ଆତେନ୍‌ ଟାନ୍‌ନିଆ ଉଡ଼ିରୁଆ ମେଣ୍ଡା ତୁର୍‌ତ୍ୟାରେ ପାଦା ଲେଃଚେ ମିଡିଗ୍‌ବଃ ମେଇଂନେ ରାସି ଗିମିମେଣ୍ଡା ଉର୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_9","072_2_9","LUK","2","9","9","ମାପ୍ରୁନେ ମୁଇଂ ଦୁତ୍ ମେଇଂ ଡାଗ୍ରା ପାଙ୍କେ ଆରି ମାପ୍ରୁନେ ଗୌରବ୍‍ନେ ତାରାସ୍ ମେଇଂ ପିତୁର୍‍ପାକା ଜାକ ତାର୍‌କିଗ୍ ୱେଗେ ଆରି ମେଇଂ ତାରାସ୍ କେଚେ ବୁଟ ୱେଏ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_10","072_2_10","LUK","2","10","10","ଆତେନ୍‌ ଦୁତ୍ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଆବ୍‌ଟଗେ ନାମଃ; କେଲା ନେଙ୍ଗ୍ ସାପା ରେମୁଆଁକେ ମାଲେ ସାର୍ଦା ଡିଙ୍ଗ୍‌ନ୍‌ସା ନିମାଣ୍ଡାନେ କବର୍ ଆଃଅଁ ଣ୍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_11","072_2_11","LUK","2","11","11","ଡାଗ୍ଲା ଏକେ ଦାଉଦନେ ସହର୍‌ନ୍ନିଆ ପେନ୍‌ସା ପାରାନ୍‍ ଆମ୍ବ୍ରଣ୍ଡ୍ରେ ଜନମ୍ ଡିଙ୍ଗ୍ ଲେଃ ମେଁ କିସ୍‌ଟ ମାପ୍ରୁ । ");
INSERT INTO gaq_vpl VALUES ("LK2_12","072_2_12","LUK","2","12","12","ଆରି ପେନ୍‌ସା ଆକେନ୍‍ ଚିନା ରକମ୍ ଡିଙ୍ଗ୍‌ଏ ପେ ସାପାରେ ମୁଇଂ ଗଡ଼େଅକେ ପାଟାଇନ୍ନିଆ କୁଇଚେ ସାଲାତ୍ୟା କୁଣ୍ଡ୍‌ଅରିଆ ଡୁଲେଗ୍‍ ଲେକ୍ନେ ପେକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK2_13","072_2_13","LUK","2","13","13","ଆରି ଉଲୁସ୍ତେ ଦୁତ୍ଇଂ ଏତେ କିତଂନେ ଗୁଲେ ଦୁତ୍ ମାନ୍ଦାଇଂ ବୁନ୍ଦେ ଜାର୍‌ଚେ ଇସ୍‌ପର୍‌ନେ ଅସ୍‌ମାର୍ ସାର୍‍ଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK2_14","072_2_14","LUK","2","14","14","ସାପାଟୁ କିତଂନ୍ନିଆ ଇସ୍‌ପର୍‌ନେ ମ‍ଇମା, ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ ମେଁନେ ସାର୍ଦା ଆରି ରେମୁଆଁଇଂ ଡାଗ୍ରା ସାନ୍ତି ଡିଂଲେଃ । ");
INSERT INTO gaq_vpl VALUES ("LK2_15","072_2_15","LUK","2","15","15","ଦୁତ୍‍ଇଂ ମେଇଙ୍ଗ୍‌ନେ ବାନ୍ କିତଙ୍ଗ୍ଇନି ନ୍ନିଆ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମେଣ୍ଡା ତୁର୍‌ତ୍ୟାରେଇଂ ମେଇଂମେଇଂ ବିତ୍ରେ ଅବାଲିର୍‌ଅବାତା ଡିଙ୍ଗ୍ଆର୍‌କେ ଏଃଲାପା ନେ ବେଥ୍‌ଲେହିମ ଜାକ ୱେଚେ ମାପ୍ରୁ ଆନେକେ ଆଣ୍ଡିନେ ଗଟେକ୍ନେ ଆଃଅଁକେ ଆତେନ୍‌ ନେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_16","072_2_16","LUK","2","16","16","ଆତ୍‌ଅରିଆ ମେଇଂ ଟାପ୍‌ନା ୱେଚେ ତୁର୍‌ଚେ ମରିୟମ୍ ଆରି ଯୋସେଫ୍‌ କିକେ ଅବାଆର୍‌କେ ଆରି ସାଲାତ୍ୟା କୁଣ୍ଡ୍‌ଅରିଆ ଗଡ଼େଅକେ ଆଃଡୁଲେଗ୍ ବକ୍ନେ କେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_17","072_2_17","LUK","2","17","17","ମେଇଂ ଆକେନ୍ କେଚେ ଆତେନ୍‌ ଗଡ଼େଅକେ ବିସୟ୍‌ରେ ଆମେଇଂକେ ଦୁତ୍ ମେଁନେ ସାମୁଆଁ ବାଲିର୍‌ ବଗେ ଆତେନ୍‌ ମେଁ ବିନ୍ ରେମୁଆଁ ଆମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_18","072_2_18","LUK","2","18","18","ଆରି ଉଡ଼ି ରେମୁଆଁ ମେଣ୍ଡାତୁର୍ତ୍ୟାରେ ବାନ୍ ଆତେନ୍‌ ସାପା ସାମୁଆଁ ଅଁ ଆର୍‌ଏ କିକେ ମେଇଂ ସାପାମାନ୍ଦା ଆତ୍‌ଅରିଆ କାବା ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_19","072_2_19","LUK","2","19","19","ଏନ୍ ସାପା ଗଟ୍‌ନା ମରିୟମ୍‌ନେ ମନ୍‌ନ୍ନିଆ କାଲାଆଃ ନ୍‌ସା ଲେଃୱେଗେ ବାରି ଏନ୍ ସମ୍ପର୍କନ୍ନିଆ ମେଁ ମାଲେ ଚିନ୍ତା ଡିଙ୍ଗ୍‌ଚେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_20","072_2_20","LUK","2","20","20","ମେଣ୍ଡା ବିଃଚଙ୍ଗ୍‌ରେଇଂ ମେଃନେ ସାପା ଅଁଲେଃଆର୍‌କେ ବାରି କେ ଲେଃଆର୍‌କେ, ଆତେନ୍‌‌ ସାପା ବିସୟ୍ ନ୍‌ସା ଇସ୍‌ପର୍‌କେ ଦନ୍ୟବାଦ୍‌ ଡିଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ ଆଣ୍ତେ ଆର୍‌କେ । ଦୁତ୍‌ଇଂ ବାସଙ୍ଗ୍‌ନେ ଅନୁସାରେ ଟିକ୍‌ ସାପା ଗଟେ ଲେଃକେ ଡାଗ୍‌ଚେ ମେଇଂ ମ୍ୟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_21","072_2_21","LUK","2","21","21","ମୁଇଂ ସାନ୍ତା ଇଡ଼ିଙ୍ଗ୍ ଗଡ଼େଅନେ ପବିତ୍ର ଡିଙ୍ଗ୍‌ନେ ବେଲା ମେଁନେ ମ୍ନି ଜିସୁ ବିଃଆର୍‌କେ । ମେଁ ଗାଗ୍‌ଡ଼େ ଡିଙ୍ଗ୍‌କ୍ନେ ସେନୁଗ୍‌ କିତଂ ଦୁତ୍‌ନେବାନ୍‌ ମେଁନେ ଏନ୍ ମ୍ନି ବିବ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_22","072_2_22","LUK","2","22","22","ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିବେଲା ମୋଶାନେ ସାମୁଆଁ ସୁଗୁଆ ମେଇଂ ପର୍‍ଚଲ୍ ମାଡିଙ୍ଗ୍‌ନେ ବେଲା ସମାନ୍ । ମେଇଂ ମାପ୍‌ରୁନେ ଉଦେସ୍‌ରେ ଗଡ଼େଅକେ ଅପେଃନ୍‌ସା ଜିରୁସାଲାମ୍‌ ପାକା ଡୁଂୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_23","072_2_23","LUK","2","23","23","ଆରି ଡିଗ୍ ମାପ୍ରୁନେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‌ବକେ, ଡୁଆ ବିତ୍ରେନେ ପର୍‍ତୁମ୍‍ ଗଡ଼େଅ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲା ମେଁ ମାପ୍ରୁନ୍ନିଆ ପବିତ୍ର ବଲି ବିଃ ପଡ଼େଏ ");
INSERT INTO gaq_vpl VALUES ("LK2_24","072_2_24","LUK","2","24","24","ମାପ୍ରୁନେ ନିୟମ୍‍ରେ ଆରି ଗୁଆର୍‍ ବକେ; “ଆନାକେ ମ୍ବାକ୍ଲିଗ୍‍ କୁକୁର୍‍ପିଗ୍‍ ଆରି ମ୍ବାକ୍ଲିଗ୍‍ ପରୁଆ ବଲି ବିଃନେ ପଡ଼େଏ ।” ଆତେନ୍‌‌ସା ଆକେନ୍ ନିଅମ୍ ଇସାବ୍‌ରେ ବଲିପୁଜା ବିଃନ୍‍ସା ଯୋସେଫ୍‌ ଆରି ମରିୟମ୍ ଯିରୂଶାଲାମ୍ ୱେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_25","072_2_25","LUK","2","25","25","ଆରି କେଲା ଯିରୁଶାଲାମ୍‌ନ୍ନିଆ ଶିମିୟୋନ୍ ମ୍ନିକ୍ନେ ମୁଇଂଜା ଦର୍ମ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେ ଆରି ବକ୍ତ ରେମୁଆଁ ଲେଃକେ ମେଁ ଇଶ୍ରାୟେଲ ଉଦାର୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ଉର୍‍ ଲେଃଆର୍‌ଗେ ବାରି ପବିତ୍ର ଆତ୍ମା ମେଁ ଡାଗ୍ରା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_26","072_2_26","LUK","2","26","26","ମାପ୍ରୁନେ ଆଦେସ୍ ଅନୁସାରେ ମସୀହାନେ ତ୍ନାନେ ଜାକ ମେଁ ଆଗୁଏଃ ଣ୍ଡୁ ଡାଗ୍‌ଚେ ପବିତ୍ର ଆତ୍ମାନେବାନ୍ ଡିଲାଡିଗ୍ ବିସ୍‌ବାସ୍‌ ବାଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_27","072_2_27","LUK","2","27","27","ଆରି ମେଁ ପବିତ୍ର ଆତ୍ମାରେ ପୁର୍ତି ଡିଙ୍ଗ୍‌ଚେ ମନ୍ଦିର୍‌ନ୍ନିଆ ପାଙ୍ଗ୍‌କେ ଆରି ଗଡ଼େଅ ଜିସୁନେ ବା ଡିୟାଇଂ ଉଡ଼ିବେଲା ମେଁନେ ବିସୟ୍‌ରେ ନିୟମ୍‌ ଇସାବ୍‌ରେ ସ୍ଲେନ୍‍ସା ଆମେକେ ବିତ୍ରେ ଡୁଂପାଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_28","072_2_28","LUK","2","28","28","ଉଡ଼ିବେଲା ଶିମିୟୋନ୍ ଆମେକେ ବୁଲୁନ୍ନିଆ ୱାଚେ ଇସ୍‌ପର୍‌ନେ ଦନ୍ୟବାଦ୍‍ ବିଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK2_29","072_2_29","LUK","2","29","29","“ଏ ମାପ୍ରୁ ନାନେ ବ୍ନାଲିର୍ ନିୟମ୍‍ରେ ନିଜେନେ ଚାକର୍‌କେ ସାନ୍ତିରେ ଗୁଏନ୍‍ସା ବେନାଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_30","072_2_30","LUK","2","30","30","ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ମୁଆଃ ନା ଉଦାର୍ ବାନେ କିକେ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_31","072_2_31","LUK","2","31","31","ନାନେ ଜା ସାପା ରେମୁଆଁଇଂନେ ସାର୍ମୁଆଁନ୍ନିଆ ଆରେ ନାବକେ ");
INSERT INTO gaq_vpl VALUES ("LK2_32","072_2_32","LUK","2","32","32","ବିନ୍ ଜାତି ରେମୁଆଁଇଂ ଆଡ଼ାତ୍ରା ସତ୍ ସାମୁଆଁ ଆସୁଏନେ ତାର୍‌କିଗ୍ ଆରି ପେ ରେମୁଆଁ ଇଶ୍ରାୟେଲନେ ଗୌରବ୍‍ ସୁଗୁଆ ଆଡିଙ୍ଗ୍‍ନାବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK2_33","072_2_33","LUK","2","33","33","ଡାଆଁ ଗଡ଼େଅ ଜିସୁନେ ସାମୁଆଁରେ ଶିମୋନ୍ ମେଃନେ ବାସଙ୍ଗ୍‌କେ ଆତେନ୍‌ ଅଁଚେ ଗଡ଼େଅନେ ଇୟାଙ୍ଗ୍ ଆବା ବକୁଆ ଡିଙ୍ଗ୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_34","072_2_34","LUK","2","34","34","ଆରି ଶିମିୟୋନ୍ ଆମେଇଂକେ ଆସିର୍ବାଦ୍ ବିଚେ ମେଁନେ ଇୟାଙ୍ଗ୍‍ଡେ ମରିୟମ୍‌କେ ବାସଙ୍ଗ୍‌କେ କେଲା ଇଶ୍ରାୟେଲନେ ରେମୁଆଁଇଂ ବାନ୍ ଏନ୍‌ ଗଡ଼େଅ ନ୍‌ସା ଗୁଲେ ରେମୁଆଁ ଦସି ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଆରି ଗୁଲେ ରେମୁଆଁ ରକ୍ୟା ବା ଆର୍‌ଏ ଆତେନ୍‌‌ସା ଏନ୍‌ ଗଡ଼େଅକେ ଇସ୍‌ପର୍ ଆମେକେ ବାଚେ ବକେ । ଆରି ଜାନେ ବିରଦ୍‌ରେ ଗୁଲେ ରେମୁଆଁ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ଆତ୍‌ନେ ମେଁ ଚିନ୍‍ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK2_35","072_2_35","LUK","2","35","35","ଆରି ମେଁ ମେଁଇଙ୍ଗ୍‌ନେ ବୁଡ଼ିଲେକ୍ନେ ଚିନ୍ତା ବାସଙ୍ଗ୍ଏ । ଆରି ଆକ୍‌ମେଁନ୍‌ସା ମୁଇଙ୍ଗ୍ ଡିଗ୍ ଲେଃକ୍ନେ କାଣ୍ଡା ସୁଗୁଆ ଦୁକ୍ ଆନାକେ ପଃଏ । ଆରି ନାନେ ଜିବନ୍ ଉନା ଡିଙ୍ଗ୍‌ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK2_36","072_2_36","LUK","2","36","36","ଆଶେର୍ ବଂସନ୍ନିଆ ଜନମ୍‌ ଫିନୂଏଲ୍‌ନେ ସେଲାମ୍ବୁଏ ହାନ୍ନା ମ୍ନିକ୍ନେ ଅଁକୁଡ଼ି ଅଁମୁଆଁ ବୟସ୍‌ ଡୁକ୍ରି ଲେଃଗେ । ମେଁ ମୁଇଂ ବାବବାଦିନୀ ଲେଃକେ । ବିଏଚେ ମାତର୍‌ ତ୍ମାମୁଆଁ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_37","072_2_37","LUK","2","37","37","ମେଁ ମନ୍ଦିର୍‌ ଆନ୍ତାର୍ଚେ ପାଦା ଆୱେକେ ଣ୍ଡୁ ମେଁ କେଡ଼େସ ଆରି ଉପାସ୍ ଲେଃଚେ ମାପ୍ରୁକେ ସ୍ମି ମିଡିଗ୍‌ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_38","072_2_38","LUK","2","38","38","ଆତେନ୍‌ ବେଲା ମେଁ ଗଡ଼େଅ ଆରି ମେଁନେ ବା ଡିଆ ବଲି ବିଃନ୍‍ସା ଡାଗ୍ରା ୱେକେ ଆନା ଆତ୍‍ଅରିଆ ପାଙ୍ଗ୍‌ଚେ ଇସ୍‌ପର୍‌କେ ଦନ୍ୟବାଦ୍ ବିକେ । ଜାଣ୍ଡେଇଂ ବିସ୍‌ବାସ୍‍ ଡିଙ୍ଗ୍‌ଚେ ଯିରୂଶାଲମ୍‌ନେ ମୁକ୍ତି ବାନେ ନ୍‍ସା ଉର୍‍ଲେ ଆର୍‌ଗେ ଆତେନ୍‌ ସାପା ରେମୁଆଁକେ ମେଁ ଜିସୁ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_39","072_2_39","LUK","2","39","39","ଯସେପ୍‍ ଆରି ମରିୟମ୍ ମାପ୍ରୁନେ ନିୟମ୍‍ରେ ସାପା କାମ୍ ଆଡାଚେ ମେଇଂ ଗାଲିଲୀନେ ନିଜେନେ ଇନି ନାଜରିତ୍‍ନ୍ନିଆ ଆଣ୍ଡେ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_40","072_2_40","LUK","2","40","40","ଆରି ଗଡ଼େଅ ମ୍ନାନେ ଲାଗେକେ ଆରି ବୁଦିରେ ବର୍‌ତି ଡିଙ୍ଗ୍‌ଚେ ବପୁ ଡିଙ୍ଗ୍‌କେ ଆରି ଇସ୍‌ପର୍‌ନେ ଦୟା ମେଇଂ ଆଡ଼ାତ୍ରା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_41","072_2_41","LUK","2","41","41","ଜିସୁନେ ବା ଡିଆ ଉଦାର୍ ପାଣ୍ଡୁଏ ମାନେଃ ନ୍‍ସା କାଲା ମୁଆଁ ଯିରୂଶାଲମ୍‌ନ୍ନିଆ ୱେଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_42","072_2_42","LUK","2","42","42","ଜିସୁନେ ଗମ୍ବାର୍ ମୁଆଁ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ବେଲା ମେଁଇଙ୍ଗ୍‌ନେ ନିୟମ୍‌ରେ ପାଲେନ୍‍ସା ଯିରୁସାଲାମ୍‍ ୱେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_43","072_2_43","LUK","2","43","43","ମେଁଇଙ୍ଗ୍‌ନେ ପାଣ୍ଡୁଏ ଆଡାଚେ ଉଡ଼ିବେଲା ମେଇଂ ଆଣ୍ଡେ ୱିଗ୍‌ଡିଙ୍ଗେ ଆତେନ୍‌‌ ବେଲା ଗଡ଼େଅ ଜିସୁ ଯିରୁସାଲାମ୍‍ନ୍ନିଆ ଲେଃୱେଗେ ଆରି ମେଁନେ ବା ଡିଆ ମ୍ୟା ଆୟା ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK2_44","072_2_44","LUK","2","44","44","ମାତ୍‍ରମ୍‍ ମେଁ ସାଙ୍ଗ୍‍ସାତିଇଂ ତ୍ରଙ୍ଗ୍‍ ଲେଃକେ ଡାଗ୍‌ଚେ ଏତେଚେ ମେଇଂ ମସିଆନେ ଗାଲି ଅଲେଙ୍ଗ୍ ୱେଆର୍ଗେ ଆରି ନିଜର୍‌ନେ ଆରି ସ୍ନାମୁଆଁ ରେମୁଆଁଇଂ ବାନ୍ ମେଁ ଏତେ ତୁର୍‍ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_45","072_2_45","LUK","2","45","45","ଆରି ମେଇଂ ଆମେକେ ମାଅବାଚେ ତୁର୍ ତୁର୍‌ଚେ ଯିରୁଶାଲାମ୍‌ନ୍ନିଆ ୱେଏ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_46","072_2_46","LUK","2","46","46","ଜିର୍‌ସି ଦିନା ଇଡ଼ିଙ୍ଗ୍ ଆମେକେ ମନ୍ଦିର୍‌ନ୍ନିଆ ଅବାକେ; ମେଁ ପଣ୍ଡିତ୍‍ଇଂନେ ମଜେ କଚେ ମେଁଇଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁ ଡିଙ୍ଗ୍‌ଗେ ଆରି ଆମେଇଂକେ ପ୍ରସ୍‌ନ ସାଲିଆକୁ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_47","072_2_47","LUK","2","47","47","ଆରି ଉଡ଼ି ରେମୁଆଁ ମେଁନେ ସାମୁଆଁ ଅଁ ଡିଙ୍ଗ୍‌ଗେ ସାପାରେ ମେଁନେ ଜ୍ଞାନ୍‍ ଆରି ଉତର୍ ଅଁଚେ ବକୁଆ ଡିଙ୍ଗ୍ ୱେ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_48","072_2_48","LUK","2","48","48","ମେଇଙ୍ଗ୍ ଆମେକେ କେଚେ କାବା ଡିଙ୍ଗ୍ ୱେଗେ ଆରି ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ବାବୁରେ ନେନେ ଆଡ଼ାତ୍ରା ମେଃନ୍‌ସା ଦେକ୍ ରକମ୍ ନାଡିଂକେ ? କେଲା ନାନେ ପେମ୍ବା ଆରି ନେଙ୍ଗ୍ ତେରେପେତେ ଡିଙ୍ଗ୍‌ଚେ ଆନାକେ ତୁର୍‍ନେଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK2_49","072_2_49","LUK","2","49","49","ଆତ୍‌ବା ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ମେଃନ୍‌ସା ପେ ଆନେଙ୍ଗ୍‌କେ ତୁର୍ ପେଡିଙ୍ଗ୍ ? ନେଙ୍ଗ୍‌ନେ ଆବାନେ ଡୁଆନିଆ ଲେଃନେ ଜେ ନେଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଲେଃକେ ଏନ୍‌ ମେଁନେ ପେ ପେମ୍ୟାକେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK2_50","072_2_50","LUK","2","50","50","ମାତର୍‌ ମେଁ ଆମେଇଂକେ ଆଣ୍ଡିନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ, “ଆତେନ୍‌ ମେଇଂ ଆବୁଜେକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK2_51","072_2_51","LUK","2","51","51","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ମେଇଙ୍ଗ୍ ଏତେ ଆଣ୍ଡେଚେ ନାଜରିତନ୍ନିଆ ପାଙ୍ଗ୍‌କେ ଆରି ମେଁ ଏତେ ସାମୁଆଁ ସାଚେ ଲେଃଆର୍‌କେ; ଆରି ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ମେଁନେ ସାପା ସାମୁଆଁ ରାଃସିଙ୍ଗ୍‌ଚେ ନିଜେନେ ଜିବନ୍‌ନିଆ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK2_52","072_2_52","LUK","2","52","52","ଆରି ଜିସୁ ଗିଆନ୍‌ରେ ଆରି ଗାଗ୍‌ଡ଼େନ୍ନିଆ ବୁଦି ବାନେ ଲାଗେକେ । ଆରି ଇସ୍‌ପର୍‌ନେ ଆରି ରେମୁଆଁଇଂନେ ଦୟା ମେଁ ଆଡ଼ାତ୍ରା ସାଃଡିଂଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_1","072_3_1","LUK","3","1","1","ମ୍ନାଇଃସାଙ୍ଗ୍‌ ତିବିରିଆ କାଇସରନେ ସାସନ୍‍ ବେଲା ୧୫ ମୁଆଁରେ ଉଡ଼ିବେଲା ପନ୍ତିୟ ପିଲାତ ଜିଉଦା ଦେସ୍‌ନେ ସାସନ୍‍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଲେଃଗେ ଆରି ହେରୋଦ ଗାଲିଲୀନେ ସାମନ୍ତ ଇଃସାଙ୍ଗ୍‌ ଆରି ମେଁନେ ବୟାଁଣ୍ଡେ ପିଲିପ୍‍ପ ଇଟୁରିଆ ଆରି ଟ୍ରାକୋନିଟିସ୍‌ନେ ବାରି ଲିସାନିଆସ୍ ଆବିଲିନ୍‌ନେ ସାମନ୍ତ ଇଃସାଙ୍ଗ୍‌ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_2","072_3_2","LUK","3","2","2","ଆରି ହାନାନ୍ ଆରି କୟାଫା ମ୍ନା ପୁଜାରି ଲେଃଗେ ଆତେନ୍‌ ବେଲା ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ ବାଲିଲଃଅରିଆ ଲେଃକ୍ନେ ଜିଖରୀୟନେ ଉଙ୍ଗ୍‌ଡେ ଜହନ୍‌ ଡାଗ୍ରା ପାଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_3","072_3_3","LUK","3","3","3","ଆତ୍‌ବା ଯୋହନ୍‌ ଯର୍ଦ୍ଦନ୍‌ ଲଣ୍ଡିଆଃନେ ଡୁବନ୍ ବିଃଣ୍ଡ୍ରେ ଜହନ୍‌ ସାପା ଇନି ୱେଚେ ପାପ୍‌ ବାନ୍ କେମା ବାନ୍‌ସା ମନ୍‌କେ ଆଃବଦ୍ଲେନେ ଡୁବନ୍ ଡୁଂଡନ୍‍ସା ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_4","072_3_4","LUK","3","4","4","ଡିରକମ୍ ଯିଶାଇୟ ବାବବାଦିନେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍ ବକେ, “ବାଲିଲନ୍ନିଆ କିରଚେ ବାସଙ୍ଗ୍‍ଡିଂକ୍ନେ ମୁଇଂଜାନେ ସାମୁଆଁ; ମାପ୍ରୁନ୍‍ସା ଗାଲି ତିଆର୍ ଡିଙ୍ଗ୍‌ପା ମେଁ ପାଙ୍ଗ୍‌ନେ ଗାଲି ସିଦା ଆଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK3_5","072_3_5","LUK","3","5","5","ସାପା କୁରୁଟାନ୍ ତୁବଃ ବର୍‌ତି ଆଡିଙ୍ଗ୍‌ଏ ଆରି ସାପା କଣ୍ଡା ଆରି ମ୍ନାକଣ୍ଡାକେ ବୁନ୍ଦେ ଆଡିଙ୍ଗ୍ ବିଏ । ବାଙ୍ଗ୍‍ଟି ଗାଲି ସ୍ୱେଡ଼ାଃ ଡିଙ୍ଗ୍‌ଏ ଆରି ତିଆର୍ କୁରୁ ତୁବଃ ସିଦା ଗାଲିରେ ତିଆର୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK3_6","072_3_6","LUK","3","6","6","ଆରି ସାପା ଜାତି ରେମୁଆଁ ଇସ୍‌ପର୍‌ନେ ଉଦାର୍ କେଚେ ସାମୁଆଁ ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK3_7","072_3_7","LUK","3","7","7","ଆତେନ୍‌‌ସା ମେଁ ଯହନ୍‍ ବାନ୍ ଡୁବନ୍ ଡୁଂଡନ୍‍ସା ତାର୍‌ଚେ ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଏ ବୁବଃନେ କୁଲ୍‌ବଂସ ! କାଲାଆଃ ରିସା ଡିଙ୍ଗ୍‍ଚେ ଲାଗ୍‍ଡନ୍‍ସା ଆପେକେ ଜାଣ୍ଡେ ଚେତ୍‍ନା ବିକେ ? ");
INSERT INTO gaq_vpl VALUES ("LK3_8","072_3_8","LUK","3","8","8","ତେସା ମନ୍‍ ଆବଦ୍‍ଲେକ୍ନେ ସମାନ୍ ପଲ୍‍ ତିଆର୍ ଡିଙ୍ଗ୍‌ପା ଆରି ଅବ୍ରାହାମ୍ ପେନେ ନ୍ତା ଞ୍ଜା ଡାଗ୍‌ଚେ ମନେ ମନେ ଡିଗ୍ ଦେକ୍‍ସୁଗୁଆ ଆବାସଙ୍ଗ୍‍ପା; ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ ଇସ୍‌ପର୍ ଆକେନ୍ ବ୍ରିଇଂବାନ୍ ଅବ୍ରାହାମ୍ ନ୍‌ସା ଗଡ଼େଅ ଜନମ୍ ଆଃଡିଙ୍ଗ୍ ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK3_9","072_3_9","LUK","3","9","9","ସ୍ଲା ସାପା ବୁନ୍ଦେ ସିତଗ୍ ବିନ୍‌ସା ମାଲୁଏଃ ବଆର୍‌କେ । ଆଣ୍ଡିନେ ସ୍ଲାଃନ୍ନିଆ ନିମାଣ୍ତା ଚୁଚୁ ଆଚୁ ଣ୍ତୁ, ଆତେନ୍‌ ସିତଗ୍‌ଚେ ସୁଆନ୍ନିଆ ତ୍ଲାଗ୍ ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK3_10","072_3_10","LUK","3","10","10","ଆତ୍‌ବା ରେମୁଆଁଇଙ୍ଗ୍ ଆମେକେ ସାଲିଆକୁକେ ତେଲା ନେନେ ମେଁ ନେଣ୍ଡିଙ୍ଗ୍‍ପା ? ");
INSERT INTO gaq_vpl VALUES ("LK3_11","072_3_11","LUK","3","11","11","ମେଁ ଉତର୍ ବିକେ ଜାଣ୍ତେନେ ମ୍ୱାକ୍ଲିଗ୍ ସକା ଲେଃକେ ମେଁ ଜାଣ୍ତେନେ ମେଃଡିଗ୍‌ ଣ୍ଡୁ ଆମେକେ ମୁଇଙ୍ଗ୍ ବିଃଲେ ବାରି ଜାଣ୍ତେନେ ଚଙ୍ଗ୍‌ନେ ଣ୍ତୁ ମେଁ ବିନ୍‌ରେକେ ଆତ୍‌ ବାନ୍‌ ବାଟା ବିଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_12","072_3_12","LUK","3","12","12","ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେ ଡିଗ୍ ଡୁବନ୍ ବାନ୍‌ସା ପାଙ୍ଗ୍‌ଚେ ଆମେକେ ସାଲ୍ୟାକୁକେ ଏ ଗୁରୁ ନେଇଙ୍ଗ୍ ମେଁ ନେଡିଙ୍ଗ୍‌ଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK3_13","072_3_13","LUK","3","13","13","ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଆପେକେ ଉଡ଼ି ଡୁଂଡ ନ୍‍ସା ଆଦେସ୍‌ ବିଃମ୍ୟାକେ ମେଁ ବାନ୍ ଜବର୍ ଆଚ୍ୱାଗେପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK3_14","072_3_14","LUK","3","14","14","ଉଡ଼ି ସନ୍ୟଇଂ ଡିଗ୍ ଆମେକେ ସାଲିଆକୁ ଆର୍‌କେ “ନେନେ ମେଃନେ ଡିଙ୍ଗ୍ଏ ? ନେ ମେଃନେ ନେଡିଙ୍ଗ୍‍ପା ?” ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଜବର୍‌ଜସ୍ତି ଜାଣ୍ତେବାନ୍‌ ଡାବୁ ଡୁଙ୍ଗ୍‌ଆଡଗ୍‌ପା ଣ୍ତୁଲା ଜାଣ୍ତେ ଆଡ଼ାତ୍ରା ମିଚ୍‌ରେ ଦସ୍‌ ଡାଗ୍‌ଚେ ଆବାଲିର୍‌ଗେପା । ନିଜର୍‌ ନିଜର୍‌ ଦର୍‌ମାରେ ସାର୍ଦା ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK3_15","072_3_15","LUK","3","15","15","ରେମୁଆଁଇଂ ଉର୍ ଲେଃଗେସା ଆରି ଜହନ୍‌ ଇଙ୍ଗ୍‌ଚା କିସ୍‌ଟ ଡିଙ୍ଗ୍‌ଏ ଡାଗ୍‌ଚେ ଆକେନ୍ ମେଁଇଙ୍ଗ୍‌ନେ ବିସୟ୍‌ରେ ସାପାରେ ନିଜେ ନିଜେ ମନ୍‍ନ୍ନିଆ ବାବେଡିଙ୍ଗ୍‍ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_16","072_3_16","LUK","3","16","16","ଜହନ୍‌ ସାପାରେକେ ଉତର୍ ବିକେ, “ନେଙ୍ଗ୍‍ ସିନା ଆପେକେ ଣ୍ଡିଆନ୍ନିଆ ଡୁବନ୍ ବିଣ୍ଡିଂକେ । ମାତର୍‌ ନେଙ୍ଗ୍‍ବାନ୍ ଜାଣ୍ଡେ ମାଲେ ବପୁଣ୍ଡ୍ରେ ମେଁ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ମେଁନେ ଞ୍ଚନେ ଜୁତା ତୁତଃ ନ୍‌ସା ସକତ୍‌ ଣ୍ଡୁ; ମେଁ ଆପେକେ ପବିତ୍ର ଆତ୍ମା ଆରି ସୁଆନ୍ନିଆ ଡୁବନ୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK3_17","072_3_17","LUK","3","17","17","ମେଁନେ ନ୍ତିନିଆ କିସଃ ଲେଃକେ, ପର୍‍ଚଲ୍ ଆଃଡିଂନ୍‌ସା ମେଁନ୍ନିଆ ବପୁ ଲେଃକେ । ଆତ୍‍ ଅରିଆ ମେଁ କିଆକେ ଚପାବାନ୍‍ ବିନେ ଆଃଡିଂଏ । ମେଁ ନିମାଣ୍ଡା କିଆ ସାପାକେ ମୁଇଂନୁଗ୍‍ ରାଃସିଙ୍ଗ୍‌ଚେ ଆଣ୍ଡ୍ରାଃନ୍ନିଆ ଡୁଂୱେଚେ ବଏ । ଇଡ଼ିଙ୍ଗ୍ ଚପା ଆରି ଦର୍‌କାର୍ ଣ୍ଡୁନେ ଗାବୁଜା ମାଲିଗ୍‌ନେ ସୁଆ ଡାଗ୍ରା ଜଗ୍‌ତ୍ଲାଗ୍‌ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK3_18","072_3_18","LUK","3","18","18","ମେଁ ଦେକ୍‍ରକମ୍ ଗୁଲେ ଉସ୍ରା ବାସଙ୍ଗ୍‌ଚେ ଆରି ବିନ୍‌ବିନ୍ ରକମ୍ ସାର୍ଦା ଆଡିଙ୍ଗ୍ ସୁଗୁଆ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ଚେ ରେମୁଆଁଇଂନେ ବେବ‍ଆର୍ ଆଃବଦ୍ଲେ ନ୍‍ସା ବାଲିର୍‍ ଅଲେଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_19","072_3_19","LUK","3","19","19","ମାତର୍‌ ସାମନ୍ତ ଇଃସାଙ୍ଗ୍‌ ହେରୋଦ ନିଜେ ବୟାଁଣ୍ଡେନେ କୁନେଣ୍ଡେକେ ହେରୋଦିଆ ଏତେ ବିହେ ଡିଙ୍ଗ୍ ବଗେ ବାରି ଜବର୍ ଦଦ୍ୟା ଡିଙ୍ଗ୍‌ବଗେସା ଜହନ୍‌ ଆମେକେ ଆଃକପାର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_20","072_3_20","LUK","3","20","20","ଦେତ୍‌ସୁଗୁଆ ହେରୋଦ ଆରି ମୁଇଙ୍ଗ୍ ଦଦିଆ କାମ୍ ଡିଙ୍ଗ୍‌କେ ମେଁ ଯହନ୍‍କେ କ‍ଏଦ୍‌ ଡୁଆନିଆ ବଗେ । ମେଁ ଉଡ଼ି ଦଦିଆ କାମ୍ ଡିଙ୍ଗ୍‍ବଗେ ଆତ୍‍ ଅରିଆ ଏନ୍‌ ଦଦିଆ କାମ୍ ଡିଗ୍ ଆମିସୁକେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_21","072_3_21","LUK","3","21","21","ସାପା ରେମୁଆଁ ଡୁବନ୍ ଡୁଂଡକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଡିଗ୍ ଡୁବନ୍ ଡିଙ୍ଗ୍‌କେ । ଆରି ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେ ବେଲା କିତଙ୍ଗ୍ଇନି ମେଲା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK3_22","072_3_22","LUK","3","22","22","ଆରି ପବିତ୍ର ଆତ୍ମା ମେଁ ଆଡ଼ାତ୍ରା ଜାର୍‌ଚେ କୁକୁର୍ୟାଃ ରକମ୍‌ ଜିସୁ ଆଡ଼ାତ୍ରା କକେ ଆରି କିତଂଇନିବାନ୍ ଏନ୍ ସାମୁଆଁ ନ୍ନାଂକେ; “ନା ନେଙ୍ଗ୍‌ନେ ନିଜର୍ ଗଡ଼େଅ । ନା ଆଡ଼ାତ୍ରା ନେଂ ଜାବର୍‌ ସାର୍ଦା ।” ");
INSERT INTO gaq_vpl VALUES ("LK3_23","072_3_23","LUK","3","23","23","ଜିସୁ ସ୍ଲେ ମୁଲେକ୍ନେ ବେଲା ଆମେକେ ପାକା ପାକି ତିରିସ୍‌ ମେମୁଆଁ ଡିଙ୍ଗ୍‌ଲେଗେ; ରେମୁଆଁଇଂ ମ୍ୟାନେ ଇସାବ୍‌ରେ ମେଁ ଯୋସେଫ୍‌ ନେ ଉଙ୍ଗ୍‌ଡେ; ଯସେପ୍‍ ଏଲିନେ ଉଙ୍ଗ୍‌ଡେ; ");
INSERT INTO gaq_vpl VALUES ("LK3_24","072_3_24","LUK","3","24","24","ଏଲି ମାଥାଥ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ମାଥାଥ୍ ଲେବୀନେ ଉଙ୍ଗ୍‌ଡେ, ଲେବୀ ମଲ୍‌ଖୀନେ ଉଙ୍ଗ୍‌ଡେ, ମଲ୍‌ଖୀ ଯନ୍ନୟନେ ଉଙ୍ଗ୍‌ଡେ, ଯନ୍ନୟ ଯୋଷେଫ ନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_25","072_3_25","LUK","3","25","25","ଯୋସେଫ୍‌ ମତ୍‌ଥିୟସ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ମତ୍‌ଥିୟସ୍ ଆମୋସ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ, ଆମୋସ୍ ନାହୁମନେ ଉଙ୍ଗ୍‌ଡେ, ନାହୁମ ଏସ୍‌ଲିନେ ଉଙ୍ଗ୍‌ଡେ, ଏସ୍‌ଲି ନାଗାୟନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_26","072_3_26","LUK","3","26","26","ନଗୟ ମାଥ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ମାଥ୍‌ ମତଥିୟସ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ମତଥିୟସ୍‌ ଶିମୟୀନେ ଉଙ୍ଗ୍‌ଡେ, ଶିମୟୀ ଯୋସେଖନେ ଉଙ୍ଗ୍‌ଡେ, ଯୋସେଖ ଯୋଦାନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_27","072_3_27","LUK","3","27","27","ଯୋଦା ଯୋଆନାନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଜହନ୍‌ ରେଷାନେ ଉଙ୍ଗ୍‌ଡେ, ରେଷା ଜିରୁବାବେଲ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଜିରୁବାବେଲ୍ ଶ‍ଅଲ୍‌ଥୀୟେଲନେ ଉଙ୍ଗ୍‌ଡେ, ଶ‍ଅଲ୍‌ଥୀୟେଲ ନେରିନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_28","072_3_28","LUK","3","28","28","ନେରି ମଲ୍‌ଖୀନେ ଉଙ୍ଗ୍‌ଡେ, ମଲ୍‌ଖୀ ଆଡ୍‌ଡ଼ିନେ ଉଙ୍ଗ୍‌ଡେ, ଆଡ୍‌ଡ଼ି କୋସାମ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ, କୋସାମ୍ ଏଲ୍‌ମାଦାମ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଏଲଦାନ୍ ଏର୍ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_29","072_3_29","LUK","3","29","29","ଏର୍ ଯିହୋଶୂୟନେ ଉଙ୍ଗ୍‌ଡେ, ଯିହୋଶୂୟ ଏଲିୟେଜର୍‍ନେ ଉଙ୍ଗ୍‌ଡେ, ଏଲିୟେଜର୍ ଯୋରିମନେ ଉଙ୍ଗ୍‌ଡେ, ଯୋରିମ ମାଥାଥ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ମାଥାଥ୍ ଲେବୀନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_30","072_3_30","LUK","3","30","30","ଲେବୀ ଶିମିୟୋନ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ, ଶିମିୟୋନ୍ ଜିଉଦାନେ ଉଙ୍ଗ୍‌ଡେ, ଜିଉଦା ଯୋସେଫ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଯୋଷେଫ ଯୋନାମ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ, ଯୋନାମ ଏଲିୟାକିମ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_31","072_3_31","LUK","3","31","31","ଏଲିୟାକିମ୍ ମଲାହନେ ଉଙ୍ଗ୍‌ଡେ, ମଲାହ ମେନ୍ନାନେ ଉଙ୍ଗ୍‌ଡେ, ମେନ୍ନା ମତ୍ତଥାନେ ଉଙ୍ଗ୍‌ଡେ, ମତ୍ତଥା ନାଥନ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ, ନାଥନ ଦାଉଦ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_32","072_3_32","LUK","3","32","32","ଦାଉଦ୍‍ ଯିଶୀନେ ଉଙ୍ଗ୍‌ଡେ, ଯିଶୟ ଓବେଦ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଓବେଦ୍ ବୋୟଜନେ ଉଙ୍ଗ୍‌ଡେ, ବୋୟଜ୍ ସାଲ୍‌ମୋନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ସାଲ୍‌ମୋନ୍ ନହଶୋନ୍‍ନେ ଉଂଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_33","072_3_33","LUK","3","33","33","ନହଶୋନ ଅମିନାଦାବନେ ଉଂଡେ, ଅମିନାଦାବ ଆଦ୍‌ମିନ୍‌ନେ ଉଂଡେ, ଆଦ୍‌ମିନ୍ ଆର୍‌ନିନେ ଉଂଡେ, ଆର୍‌ନି ହେସ୍ରୋଣନେ ଉଂଡେ, ହେସ୍ରୋଣ ପେରେଜ୍‌ନେ ଉଂଡେ, ଫେରସ ଜିଉଦାନେ ଉଂଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_34","072_3_34","LUK","3","34","34","ଜିଉଦା ଜାକୁବ୍‌ନେ ଉଂଡେ, ଜାକୁବ୍‌ ଇସାକ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଇସାକ୍ ଅବ୍ରାହାମ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଅବ୍ରାହାମ୍ ଥେରହନେ ଉଙ୍ଗ୍‌ଡେ, ଥେରହ ନାହୋରନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_35","072_3_35","LUK","3","35","35","ନାହୋର ସେରଗ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ସେରଗ୍ ରେଉନେ ଉଙ୍ଗ୍‌ଡେ, ରେଉ ପେଲଗ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ପେଲେଗ୍ ଏବରନେ ଉଙ୍ଗ୍‌ଡେ, ଏବର ଶେଲାନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_36","072_3_36","LUK","3","36","36","ଶେଲା କ‍ଇନାନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, କ‍ଇନାନ୍ ଆର୍‌ଫାକ୍‌ସଡ଼ନେ ଉଙ୍ଗ୍‌ଡେ, ଆର୍‌ଫାକ୍‌ସଡ଼ ଶେମ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଶେମ୍ ନୋହନେ ଉଙ୍ଗ୍‌ଡେ, ନୋହ ଲାମେକ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_37","072_3_37","LUK","3","37","37","ଲାମେକ୍ ମେଥୁଶେଲାନେ ଉଙ୍ଗ୍‌ଡେ, ମେଥୁଶେଲା ହନୋକନେ ଉଙ୍ଗ୍‌ଡେ, ହନୋକ ଯାରେଦନେ ଉଙ୍ଗ୍‌ଡେ, ଯାରେଦ ମହାଲାଲୀଲ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ମହାଲାଲୀଲ୍ କେନାନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ");
INSERT INTO gaq_vpl VALUES ("LK3_38","072_3_38","LUK","3","38","38","କେନାନ୍ ଏନୋଶନେ ଉଙ୍ଗ୍‌ଡେ, ଏନୋଶ ଶେଥ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ଶେଥ୍‌ ଆଦମନେ ଉଙ୍ଗ୍‌ଡେ, ଆଦମ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_1","072_4_1","LUK","4","1","1","ଜିସୁ ପବିତ୍ର ଆତ୍ମା ବାଚେ ଜର୍ଦ୍ଦନ୍‍ବାନ୍ ଆଣ୍ଡେ ୱିଗ୍‌କେ । ଆରି ପବିତ୍ର ଆତ୍ମା ଆମେକେ ଚାଲେନ୍‍ସା କଣ୍ଡା ଅରିଆ ଡୁଙ୍ଗ୍‍ୱେଗେ । ଆତ୍‌ଅରିଆ ମେଁ ମ୍ବାର୍‌କୁଡ଼ି ସ୍ମି ଜାକ ସ‍ଏତାନ୍‌ବାନ୍ ପରିକିତ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_2","072_4_2","LUK","4","2","2","ଆତ୍‌ଅରିଆ ମେଁ ସ‍ଏତାନ୍‌ବାନ୍‌ ଚାଲିସ୍‌ ଦିନ୍‌ ଜାକ କସ୍‌ଟ ବାକେ । ଆତେନ୍‌ ସାପାଦିନ୍‍ ଜାକ ମେଁ ମେଃଡିଗ୍ ଆଚଙ୍ଗ୍ ଆଉଗ୍‌କେ ଣ୍ଡୁ । ପରିକ୍ୟା ଡିଙ୍ଗ୍ ଆଃଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଆମେକେ ଜାବର୍‌ କେଡ଼େସଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_3","072_4_3","LUK","4","3","3","ଆତ୍‌ବାନ୍ ସ‍ଏତାନ୍ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନା ଜଦି ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ତେଲା ଆକେନ୍ ବ୍ରିକେ ରୁଟି ଡିଙ୍ଗ୍ ନ୍‌ସା ଆଦେସ୍‍ ବିଃ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_4","072_4_4","LUK","4","4","4","ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ “ସାସ୍ତର୍‌ନ୍ନିଆ ଗ୍ନୁଆର୍ ଲେଃକେ; ରେମୁଆଁ ମାତର୍‌ ରୁଟି ଏତେ ଆମ୍ବ୍ର ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_5","072_4_5","LUK","4","5","5","ଆରି ସ‍ଏତାନ୍ ଆମେକେ ତିଆର୍ ଟାନ୍‌ନିଆ ୱା ଡୁଂୱେଚେ ଇତୁଡ଼ା ବେଲା ନ୍‍ସା ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସାପା ରାଇଜ୍ ଆମେକେ ଆକେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_6","072_4_6","LUK","4","6","6","ଆରି ସ‍ଏତାନ୍‍ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ନେଂ ଆନାକେ ଏନ୍ ସାପା ଅଦିକାର୍ ଆରି ଏନ୍ ସାପା ସମ୍ପତି ମ୍ୱିଏ, ଡାଗ୍ଲା ଆତେନ୍‌ ସାପା ଆନେଙ୍ଗ୍‌କେ ବିବକେ ଆରି ନେଂ ଆଜାକେ ଇକ୍‌ଚା ଆମେକେ ଆତେନ୍‌ ମ୍ୱିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK4_7","072_4_7","LUK","4","7","7","ଆରି ନା ଜଦି ଆନେଙ୍ଗ୍‌କେ ମୁଣ୍ଡିଆ ନାବଗ୍‌ଏ ତେଲା ନେଙ୍ଗ୍ ଏନ୍‌ ସାପା ଆନାକେ ବିଃ ଞ୍ଜଗ୍‍ତ୍ଲିଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_8","072_4_8","LUK","4","8","8","ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ, “ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍ ବକେ; ନା ମାତର୍‌ ମାପ୍ରୁ ନିଜେ ଇସ୍‌ପର୍‌କେ ମୁଣ୍ଡିଆ ନାବଗ୍‌ଏ, ଆରି ମେଁନେ ପାର୍‌ତନା ନାଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_9","072_4_9","LUK","4","9","9","ଇଡ଼ିଙ୍ଗ୍ ସ‍ଏତାନ୍ ଜିସୁକେ ଯିରୁଶାଲାମ୍‌ନ୍ନିଆ ୱା ଡୁଂୱେଚେ ମନ୍ଦିର୍‌ନେ ବ୍ଲେସାଙ୍ଗ ଆଡ଼ାତ୍ରା ଆଃତୁଆଁଚେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, ନା ଜଦି ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ତେଲା ଆକେନ୍ ବ୍ଲେସାଙ୍ଗ୍‍ବାନ୍‌ ବୁନ୍ଦେ ପୁଏଃ ଲଃଲା; ");
INSERT INTO gaq_vpl VALUES ("LK4_10","072_4_10","LUK","4","10","10","ଡାଗ୍ଲା ଦର୍ମସାସ୍ତର୍‌ନ୍ନିଆ ଗ୍ନୁଆର୍ ଲେଃକେ, ମେଁ ନିଜର୍‌ ଦୁତ୍ଇଂକେ ନାନେ ବିସୟ୍‌ରେ ଆଦେସ୍ ବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("LK4_11","072_4_11","LUK","4","11","11","ଆରି ମାରିଆଃ ନାନେ ଞ୍ଚ ବ୍ରିନ୍ନିଆ ବାଏ, ଆକେନ୍ ନ୍‌ସା ମେଇଂ ଆନାକେ ନ୍ତିନ୍ନିଆ ଲିଙ୍ଗ୍‌ଚେ ସାଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK4_12","072_4_12","LUK","4","12","12","ଆରି ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ, “ସାସ୍ତର୍‌ନ୍ନିଆ ଡିଗ୍ ଏନ୍ ଗ୍ନୁଆର୍‌ ଲେଃକେ; ନା ମାପ୍ରୁ ନିଜର୍‌ ଇସ୍‌ପର୍‍କେ ପରିକ୍ୟା ଆଡିଂଗେ ନାମଃ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_13","072_4_13","LUK","4","13","13","ସ‍ଏତାନ୍ ଜିସୁନେ ସାପା ରକମ୍ ପରିକ୍ୟା ଆଡାଚେ ଆରି ନିମାଣ୍ଡା ବେଲା ପାଙ୍ଗ୍ ଜାକ ଆମେକେ ଆନ୍ତାର୍‌ଚେ ଲାଗ୍‌ଡକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_14","072_4_14","LUK","4","14","14","ଆତେନ୍‌ ବାନ୍ ଜିସୁ ଆତ୍ମାନେ ବପୁରେ ଗାଲିଲୀନ୍ନିଆ ଆଣ୍ଡେୱେକେ ଆରି ପିତୁର୍‍ପାକା ଜାକ ସାପା ଏରିୟା ମେଁନେ ସାମୁଆଁ ଉଡ୍ରା ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_15","072_4_15","LUK","4","15","15","ଆରି ଜିସୁ ଜିଉଦିଇଂନେ ପାର୍‌ତନା ଡୁଆଇଂନିଆ ସିକ୍ୟା ବିନେ ମୁଲେକେ, ଆରି ସାପା ରେମୁଆଁବାନ୍ ମେଁ ଆଲାଦ୍ ବାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_16","072_4_16","LUK","4","16","16","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ନାଜରିତ ନ୍ନିଆ ପାଙ୍ଗ୍‌କେ ନାଜରୀତ୍ ନ୍ନିଆ ମେଁ ସାପାଦିନ୍‌ ପାଲେନେ ନିଅମ୍ ସୁଗୁଆ ମେଁ ପୁଣ୍ଡେନେ ଦିନା ଯିଉଦି ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ୱେକେ ଆରି ମେଁ ତଡ଼ିଆଚେ ସାସ୍ତର୍‌ ପଡ଼େକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_17","072_4_17","LUK","4","17","17","ଆତେନ୍‌ ବେଲା ଆମେକେ ଯିଶାଇୟ ବାବବାଦିନେ ବଇ ଆମେକେ ବିବଗେ । ଜିସୁ ଆତେନ୍‌ ବଇ ତଚେ ଆଣ୍ଡିନେ ଜାଗାନ୍ନିଆ ଏନ୍‌ ସାମୁଆଁ ଗୁଆର୍‍ ବଗେ ଆତେନ୍‌ ବାକେ; ");
INSERT INTO gaq_vpl VALUES ("LK4_18","072_4_18","LUK","4","18","18","“ମାପ୍ରୁନେ ଆତ୍ମା ନେଙ୍ଗ୍‍ନ୍ନିଆ ଲେଃକେ ଅର୍‍କିତ୍‍ ରେମୁଆଁଇଂନ୍ନିଆ ନିମାଣ୍ଡା ସାମୁଆଁ ବାଲିର୍ ନ୍‌ସା ପର୍‍ମେସର୍‍ ଆନେଙ୍ଗ୍ ସ୍ରିବକେ ବନ୍ଦିଇଂ ମୁକ୍‍ଲେନ୍‍ସା ଆକେନ୍ ଆପେକେ ଆଃଅଁନ୍‌ସା ଆରି କାନାଇଂକେ ଆରି ମୁଇଙ୍ଗ୍‌ତର୍ କେୟା ଆର୍‌ଏ ଡାଗ୍‌ଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‍ ନ୍‌ସା ଦୁକ୍‍ରେ ଲେଃକ୍ନେ ରେମୁଆଁ ଆରି ରଗ୍‍ରେ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଦୁକ୍ ବାନ୍ ଆଃତାର୍ ନ୍‌ସା, ");
INSERT INTO gaq_vpl VALUES ("LK4_19","072_4_19","LUK","4","19","19","ଆରି ମାପ୍ରୁନେ ଦୟାନେ ବେଲା ବାଲିର୍‍ ଅଲେଙ୍ଗ୍‍ନ୍‍ସା ମାପ୍ରୁ ଆନେଙ୍ଗ୍ ବେବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_20","072_4_20","LUK","4","20","20","ଜିସୁ ଉଲିଆଃ ବନ୍ଦ୍ ଆଡିଙ୍ଗ୍‌ଚେ ଗତିରେକେ ବେ ବିକେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଁ କକେ । ଆରି ଜିଉଦି ପାର୍‌ତନା ଡୁଆନିଆ ଲେଃକ୍ନେ ସାପା ରେମୁଆଁନେ ମନ୍ ଦିଆନ୍‍ ମେଁ ଆଡ଼ାତ୍ରା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_21","072_4_21","LUK","4","21","21","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ବଇବାନ୍‍ ଆଣ୍ଡିନେ ସାମୁଆଁ ଏକ୍ରେ ମ୍ପଡ଼େକେ ଆତେନ୍‌ ପେଇଂ ଅଁନେ ବେଲା ସାସ୍ତର୍‌ନେ ଏନ୍‌ ସାମୁଆଁ ଏବେ ପୁରନ୍‌ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_22","072_4_22","LUK","4","22","22","ଆରି ସାପାରେ ମେଁନେ ବିସ‍ଏରେ ସାକି ବିଃନେ ମୁଲେଆର୍କେ ଆରି ମେଁନେ ସାର୍ମୁଆଁବାନ୍ ତାର୍‌ଡିଂକ୍ନେ ଅନୁଗ୍ର‍ଅନେ ସାମୁଆଁରେ ଇରିଆଃତୁଗ୍‌ ଆର୍‌କେ; ବାରି ମେଇଂ ବାଲିର୍‌ନେ ମୁଲେଆର୍କେ, “ଆକ୍‌ମେ ମେଃନେ ଯୋସେଫ୍‌ନେ ଉଂଡେ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("LK4_23","072_4_23","LUK","4","23","23","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ ଜେ ପେଇଂ ଆନେଙ୍ଗ୍‌କେ ଆତେନ୍‌ ବାୱିର୍‌କ୍ନେ ସାମୁଆଁ ପେବାସଙ୍ଗ୍‍ଏ, ଏ ଗଦାର୍ ନାନେ ନିଜେକେ ସେନୁଗ୍‍ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ । ପେ ବାସଙ୍ଗ୍‌ନେ ଚାଏଁ ପେଡିଙ୍ଗ୍‌କେ ଜେ କପର୍ନାହୁମନ୍ନିଆ ପେ ଜା ସାପା ଡିଙ୍ଗ୍ ପେବକେ ଡାଗ୍‌ଚେ ନେ ଅଁ ନେଲେକେ ଆତେନ୍‌ ସାପା ଏବେ ନା ନିଜେ ଜନମ୍ ଇନିଡିଗ୍ ଆତେନ୍‌ ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_24","072_4_24","LUK","4","24","24","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନିଂ ଆପେକେ ସତ୍‌ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ, ମେଃଡିଗ୍ ବାବବାଦି ନିଜେନେ ଇନିନିଆ ଡିଗ୍ ଗ୍ର‍ଅନ୍‌ ଆଡିଙ୍ଗ୍ ଆର୍‌ଏ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_25","072_4_25","LUK","4","25","25","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ ଏଲୀୟନେ ବେଲା ଇଶ୍ରାୟେଲନ୍ନିଆ ଉଡ଼ିବେଲା ଜିର୍‌ସି ମେମୁଆଁ ତୁର୍ ଆର୍କେ ଜାକ କିତଂଇନି ବନ୍ଦ୍‌ ଡିଂକେସାଃ ଣ୍ଡିଆଃ ଆଗୁର୍‍କେ ଣ୍ଡୁ ଆରି ସାପା ଦେସ୍‌ନ୍ନିଆ ମ୍ନାଃ ମୁର୍‍ଡି ଡିଂକେ, ଆତେନ୍‌ ବେଲା ଇଶ୍ରାୟେଲନେ ଗ୍ଲୁଏ ଗୁଏସାଙ୍ଗ୍‍କୁଏ ରେମୁଆଁ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_26","072_4_26","LUK","4","26","26","ମାତର୍‌ ଏଲୀୟକେ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ମୁଡ଼ି ଗୁଏସାଙ୍ଗ୍‍କୁଏକେ ଡିଗ୍ ଡାଗ୍‍ରା ଆବେକେ ଣ୍ଡୁ ଡାଗ୍‌ଲା ଏଲିୟ ସିଦନ ଏରିଆନେ ସାରିପତନ୍ନିଆ ବାସା ଲେଃକ୍ନେ ମୁଇଂ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ଡାଗ୍‍ରା ୱେ ଲେଃକେ । ବିନ୍‌ନେ ଜାଣ୍ତେ ଡାଗ୍ରା ମେଁ ୱେ ଆଲେକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK4_27","072_4_27","LUK","4","27","27","ଆରି ବାବବାଦି ଏଲିଶାୟନେ ବେଲା ଇଶ୍ରାୟେଲନେ ଗୁଲୁଏ କୁଷ୍ଟରଗି‍ଇଂ ଲେଃଆର୍‌ଗେ । ତେଲାଡିଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ଆଜା ଡିଗ୍ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ଆବଗେ ଣ୍ଡୁ । ମାତର୍‌ ସିରିଆ ଦେସ୍‌ନେ ନାମାନ୍‍କେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_28","072_4_28","LUK","4","28","28","ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ଲେଃକ୍ନେ ସାପା ରେମୁଆଁ ଜିସୁନେ ଏନ୍‌ ସାପା ସାମୁଆଁ ଅଁଚେ ଜାବର୍‌ ଗିସେ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_29","072_4_29","LUK","4","29","29","ରେମୁଆଁଇଂ ଜିସୁକେ ଇନିବାନ୍ ପାଦା ନୁଆଁ ବିକେ । ମେଁଇଙ୍ଗ୍‌ନେ ଇନି ମୁଇଙ୍ଗ୍ କଣ୍ଡା ଆଡ଼ାତ୍ରା ତିଆର୍ ଡିଙ୍ଗ୍ ବଆର୍‌ଗେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ କଣ୍ଡା ଆଡ଼ାତ୍ରା ଡୁଙ୍ଗ୍‍ୱେଚେ ଆମେକେ ଆତ୍‌ବା ବୁନ୍ଦେ ଟମେଗ୍‍ ବିଃନ୍‍ସା ଚାଏଁ ଡିଙ୍ଗ୍ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_30","072_4_30","LUK","4","30","30","ମାତର୍‌ ଜିସୁ ରେମୁଆଁଇଂନେ ବାନ୍ ତାର୍‌ଚେ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_31","072_4_31","LUK","4","31","31","ଜିସୁ ଗାଲିଲୀନେ କପର୍ନାହୁମ ମ୍ନିକ୍ନେ ଇନିନିଆ ପାଙ୍ଗ୍‌କେ ମେଁ ପୁଣ୍ଡେନେ ବାର୍‍ ଦିନା ରେମୁଆଁଇଂକେ ସିକ୍ୟା ବିଃନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_32","072_4_32","LUK","4","32","32","ରେମୁଆଁଇଂ ମେଁନେ ବୁଦି ଅଁଚେ ଇରିଆତୁଗ୍ ୱେଆର୍‌ଗେ । ଡାଗ୍ଲା ମେଁ ଅଦିକାର୍ ଏତେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_33","072_4_33","LUK","4","33","33","ଆତେନ୍‌ ପାର୍‍ତନା ଡୁଆନ୍ନିଆ ଲେଃମ୍ୟାକ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଗାଗ୍‌ଡ଼େ ନ୍ନିଆ ଅସୁଚି ଆତ୍ମା ବାସା ଲେଃଗେ । ମେଁ ୱାସାର୍‌ଚେ ମାଲେ ୱାସାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK4_34","072_4_34","LUK","4","34","34","“ଅ ନାଜରିତୀୟ ଜିସୁ ନାନେ ଏତେ ନେଙ୍ଗ୍‌ନେ ମେଁ ଲେଃକେ ? ନାନେ କି ଆନେକେ ଆଗୁଏନ୍‍ସା ନାପାଙ୍ଗ୍‍କେ ? ନାନେ ଜାଣ୍ଡେ ଆତେନ୍‌ ନେଙ୍ଗ୍ ମ୍ୟା ନ୍ଲେକେ; ନାନେ ଇସ୍‌ପର୍‌ନେ ପବିତ୍ର ରେମୁଆଁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_35","072_4_35","LUK","4","35","35","ଜିସୁ ଆମେକେ ଦମ୍‍କେଚେ ବାସଙ୍ଗ୍‌କେ, “ଚୁପ୍‍ ଡିଂ ଆକ୍‌ମେଁ ବାନ୍ ତାର୍‌ଚେ ଲାଗ୍‍ଡଲା । ଆତ୍‌ବା ଆତେନ୍‌ ସେଆଁରେ ଆମେକେ ବୁନ୍ଦେ ଆଲଚେ ଆମେକେ ମେଃଡିଗ୍ ଚିନା ମାରାଡିଙ୍ଗ୍‌ଚେ ମେଁ ବାନ୍ ଲାଗ୍‍ଡକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_36","072_4_36","LUK","4","36","36","ଆତ୍‌ବା ରେମୁଆଁଇଂ ଇରିଆତୁଗ୍ ୱେଆର୍‌ଗେ । ଆରି ମେଇଂ ବିତ୍ରେ ବିତ୍ରେ ବାଲିର୍‍ ବାତା ଆର୍‌କେ, “ଏନ୍‌ ଡିରକମ୍ ସାମୁଆଁ ? ଅଦିକାର୍ ଆରି ବପୁ ଏତେ ମେଁ ସେଆଁରେଇଂକେ ଆଦେସ୍‍ ବିଡିଙ୍ଗ୍‌କେ । ଆରି ସେଆଁରେଇଂ ମେଁନେ ସାମୁଆଁ ଅଁଚେ ତାର୍‌ଚେ ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK4_37","072_4_37","LUK","4","37","37","ଆତେନ୍‌ ଏରିଆନେ ସାପା ଜାଗାନ୍ନିଆ ଜିସୁ ବିସୟ୍‌ରେ ଏନ୍‌ କବର୍ ଉଡ୍ରା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_38","072_4_38","LUK","4","38","38","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ପାର୍‌ତନା ଡୁଆ ଆନ୍‌ତାର୍‌ଚେ ଶିମୋନ ଡୁଆ ୱେକେ । ଶିମୋନ ଆତାଡ଼େକେ ଜାବର୍‌ ସାଃବା ଡିଙ୍ଗ୍‌ଲେକେ ମେଇଂ ଜିସୁକେ ମେଁ ଆତ୍‍ଲା ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ନ୍‌ସା ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_39","072_4_39","LUK","4","39","39","ଆତେନ୍‌ ବେଲା ମେଁ ଡାଗ୍ରା ତୁଆଁଚେ ସାଃବାକେ ଦାକା ବିଲା ସାଃବା ଆନ୍ତାର୍ ୱେକେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ତଡ଼ିଆଚେ ମେଁଇଙ୍ଗ୍‌ନେ ସେବା ଡିଙ୍ଗ୍‍ ନ୍‌ସା ଲାଗେ ପଡ଼େକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_40","072_4_40","LUK","4","40","40","ସ୍ନି ଲଗ୍‍ନେ ବେଲା ରେମୁଆଁଇଂ ମେଁଇଙ୍ଗ୍‌ନେ ରଗ୍‍ ସାଃଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଜିସୁନିଆ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଆର୍‌କେ । ମେଁଇଙ୍ଗ୍‌ନ୍ନିଆ ବିନ୍‌ବିନ୍ ରକମ୍ ରଗ୍ ଲେଃଗେ । ଜିସୁ ନିଜେନେ ନ୍ତି ମେଇଂ ଆଡ଼ାତ୍ରା ବଚେ ଆମେଇଂକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_41","072_4_41","LUK","4","41","41","ଆରି ଡିଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ଲେଃକ୍ନେ ଉଡ଼ିରୁଆ ବୁତ୍‌ ଆତ୍‌ମାଇଂ ତାର୍‌ଚେ ପାଙ୍ଗ୍ ଆର୍‌କେ । ଆରି ବୁତ୍‌ ଆତ୍‌ମାଇଂ କିରଚେ ବାସଙ୍ଗ୍‌ ଆର୍‍ଡିଙ୍ଗେ, “ନାନେ ପର୍‍ମେସର୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ।” ମାତର୍‌ ଜିସୁ ବୁତ୍‌ ଆତ୍‌ମାଇଂ ବୁଙ୍ଗ୍‍ ଲେଃନ୍‌ସା ଆଦେସ୍‍ ବିକେ । ଡାଗ୍ଲା ଆତେନ୍‌ ବୁତ୍‌ ଆତ୍‌ମାଇଂ ମ୍ୟାଲେଃଆର୍‌ଗେ ଜେ ଜିସୁ ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ ନିଜେ କିସ୍‌ଟ । ");
INSERT INTO gaq_vpl VALUES ("LK4_42","072_4_42","LUK","4","42","42","ମାର୍‌ତଡ଼େ ଞ୍ଜିର୍‌ନୁଗ୍ ମେଁ ଇନିବାନ୍ ତାର୍‌ଚେ ମୁଇଙ୍ଗ୍ ଚିମ୍‌ରା ଜାଗାନ୍ନିଆ ୱେକେ ଆରି ରେମୁଆଁଇଂ ଆମେକେ ତୁର୍ ତୁର୍‍ଚେ ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍ ଆର୍‌କେ ଆରି ମେଁ ଜେନ୍ତିକି ମେଁଇଙ୍ଗ୍‌ନେ ଡାଗ୍ରା ଆୱେ ଣ୍ଡୁ ଆତେନ୍‌‌ସା ଆମେକେ ଆତ୍‌ଅରିଆ ଲେନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_43","072_4_43","LUK","4","43","43","ତେଲା ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, ବିନ୍‌ବିନ୍ ଇନିଡିଗ୍ ଆନେଙ୍ଗ୍‌କେ ଡିଲାଡିଗ୍ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍‍ରେ ନିମାଣ୍ଡା ବ୍ନାଲିର୍ ବାଲିର୍‍ନ୍‍ସା ଡିଙ୍ଗ୍‌ଏ ଡାଗ୍ଲା ଆତେନ୍‌‌ସା ନେଙ୍ଗ୍ ପାଙ୍ଗ୍ ନ୍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK4_44","072_4_44","LUK","4","44","44","ତେସା ଆତେନ୍‌ ଜିଉଦା ଦେସ୍‌ନେ ବିନ୍‌ବିନ୍‌ ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ପର୍‌ଚାର୍ ଡିଙ୍ଗ୍ ନ୍‌ସା ଆରାମ୍‌ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_1","072_5_1","LUK","5","1","1","ମେସୁଆ ଜିସୁ ଗିନେସରତ୍‍ ଲଣ୍ଡିଆ ଆଃଡ଼ା ତୁଆଁ ଲେଃଗେ । ଆରି ରେମୁଆଁଇଂ ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ ଅଁନ୍‌ସା ଟେଚାଟେଣ୍ଡୁର୍‍ ଡିଙ୍ଗ୍ଆର୍‌ଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_2","072_5_2","LUK","5","2","2","ଆରି ମେଁ କେଣ୍ଡିଆ ଆଃଡ଼ା ମ୍ୱାକ୍ଲିଗ୍ ତରା ଲେଃକ୍ନେ କେକେ । ସାଃହାଃରେଇଂ ଆତେନ୍‌ ତରାବାନ୍ ଜାର୍‌ଚେ ମେଁଇଙ୍ଗ୍‌ନେ ଜାଲ୍ ଗଡ଼ିଆ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_3","072_5_3","LUK","5","3","3","ଆତେନ୍‌ ତରାଇଂ ବାନ୍ ଆଣ୍ଡିନେ ଶିମୋନନେ ତରା ଲେଃଗେ । ଆତ୍‍ ଅରିଆ ମେଁ ଡେଃଚେ କେଣ୍ଡିଆ ଆଡ଼ାବାନ୍ ସ୍ଲ ୱେନ୍‌ସା ଆମେକେ ବାସଙ୍ଗ୍‌କେ; ଆରି ମେଁ ତରାଅରିଆ କଚେ ରେମୁଆଁଇଂନ୍ନିଆ ବୁଦି ବିଃନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_4","072_5_4","LUK","5","4","4","ମେଁ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଆଃଡାଚେ ଶିମୋନ୍‍କେ ବାସଙ୍ଗ୍‌କେ, “ସ୍ରିଣ୍ଡିଆ ବିତ୍ରେ ୱେଚେ ଆଃଡ଼ ସାନ୍ତି ପେନେ ଜାଲ୍ ତ୍ଲାଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK5_5","072_5_5","LUK","5","5","5","ଆତ୍‌ବା ଶିମୋନ ଉତର୍ ବିକେ, ଏ ଗୁରୁ, ଆଃଡ଼ ସାନ୍ତି ନେ ମିଡିଗ୍‍ ଜାକ କଷ୍ଟ ଡିଙ୍ଗ୍‌ଚେ ମେଁ ଡିଗ୍ ନେବାକେ ଣ୍ଡୁ; ମାତର୍‌ ନାନେ ସାମୁଆଁରେ ନେଙ୍ଗ୍ ଜାଲ୍ ତ୍ଲାଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK5_6","072_5_6","LUK","5","6","6","ଆରି ମେଇଂ ଜାଲ୍ ତ୍ଲାଗ୍‌ଚେ ଜବର୍ ଆଃଡ଼ ସାଃଆର୍‌କେ ଆରି ମେଁଇଙ୍ଗ୍‌ନେ ଜାଲ୍ ଟିକ୍‍ଚିନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_7","072_5_7","LUK","5","7","7","ଆତ୍‌ଅରିଆ ମେଁଇଙ୍ଗ୍‌ନେ ଜାଣ୍ଡିଗ୍ କୁଡ଼େଚେ ସାଣ୍ଡ୍ରେଇଙ୍ଗ୍ ଆରି ବିନ୍ ତରାନିଆ ଲେଃଆର୍‌ଗେ ମେଇଂ ଡିରକମ୍ ପାଙ୍ଗ୍‌ଚେ ସାଇଜ୍ୟ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଆତେନ୍‌‌ସା ମେଇଂ ଆମେଇଂକେ ୱାକେ । ଆତ୍‌ବା ମେଇଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଚେ ମ୍ୱାକ୍ଲିଗ୍ ତରାକେ ଆଃଡ଼ରେ ଡେକ୍‌ରକମ୍ ତାଃନ‍ଆର୍‌କେ ଜେ ତରାଇଂ ଲଗ୍‌ଡିଆ ୱେନେ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_8","072_5_8","LUK","5","8","8","ଡାଗ୍ଲା ଶିମୋନ୍ ପିତର୍ ଆକେନ୍ କେଚେ ଜିସୁନେ ଞ୍ଚ ବୁନ୍ଦେ ଲଃଚେ ବାସଙ୍ଗ୍‌କେ ଏ ମାପ୍ରୁ ନାନେ ନେଙ୍ଗ୍ ଡାଗ୍ରାବାନ୍‍ ଲାଗ୍‍ଡଲା ଡାଗ୍ଲା ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ପାପି ରେମୁଆଁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK5_9","072_5_9","LUK","5","9","9","ଡାଗ୍ଲା ମେଇଙ୍ଗ୍ ଆତେନ୍‌ ବାନ୍‍ ଆଃ ଅଃକେନ୍ ଆଡ଼ ସାଃବଆର୍‌ଗେ ଜେ ଆତେନ୍‌ କେଚେ ମେଁ ଆରି ମେଁନେ ସାଙ୍ଗଇଂ ସାପାରେ ଇରିଆତୁଗ୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ; ");
INSERT INTO gaq_vpl VALUES ("LK5_10","072_5_10","LUK","5","10","10","ଆରି ଜେବଦୀନେ ମ୍ୱାକ୍ଲିଗ୍‍ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌, ଜାଣ୍ଡେଇଂ ଶିମୋନ ଏଃତେ ଲେଃଗେ, ମେଇଂ ଡିଗ୍ ଦେତୁଆ ଇରିଆଃତୁଗ୍ ୱେଆର୍‌କେ । ଆରି ଜିସୁ ଶିମନ୍‍କେ ବାସଙ୍ଗ୍‌କେ, ଆବ୍‌ଟଗେ ନାମଃ, ଏଃବାନ୍ ନା ଆଃଡ଼ ସାଃନେ ବାଦୁଲ୍ ରେମୁଆଁଇଂକେ ମାପ୍ରୁନେ ଗାଲିନ୍ନିଆ ଡୁଂନାପାଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK5_11","072_5_11","LUK","5","11","11","ଆତ୍‌ବା ମେଇଂ ତରାଇଂ କେଣ୍ଡିଆଃ ଆଃଡ଼ାଃ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ସାପା ଆନ୍ତାର୍‌ଚେ ମେଁନେ ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_12","072_5_12","LUK","5","12","12","ମେଁ ମୁଇଙ୍ଗ୍ ଇନିନିଆ ଲେଃନେ ବେଲା କେଲା ଆତ୍‌ଅରିଆ ମୁଇଙ୍ଗ୍ ଗାଗ୍‌ଡ଼େ ଜାକ କୁଷ୍ଟରଗ୍‍ ସାଲେଃକ୍ନେ ରେମୁଆଁ ଲେଃଡିଙ୍ଗେ; ମେଁ ଜିସୁକେ କେଚେ ମୁଗ୍‌ଗାଃ ଲଃଚେ ଆମେକେ କୁସାମୁତି ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ଏ ମାପ୍ରୁ “ନାନେ ଜଦି ରାଜି ନାଡିଙ୍ଗ୍‌ଏ ଦେତ୍‍ଲା ନାନେ ଆନେଙ୍ଗ୍ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ନାୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK5_13","072_5_13","LUK","5","13","13","ଆତ୍‌ବା ମେଁ ନ୍ତି ଆଚ୍‍ଲେଚେ ଆମେକେ ଲିଗ୍‍ଚେ ବାସଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ରାଜି ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ । ଆତ୍‌ବା ଆତେନ୍‌ ରେମୁଆଁ କୁଷ୍ଟରଗ୍‌ବାନ୍‌ ନିମାଣ୍ଡା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_14","072_5_14","LUK","5","14","14","ଜିସୁ ଆମେକେ ଆଦେସ୍‍ ବିଚେ ବାସଙ୍ଗ୍‌କେ ଆଜାକେ ଆବାସଙ୍ଗ୍‍ ନାମଃ ମାତର୍‌ ସିଦା ପୁଜାରିନ୍ନିଆ ୱେଲା ଆରି ମେଁ ଆନାକେ ପରିକ୍ୟା ଡିଙ୍ଗ୍‌ଚେ କେଲେ ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ନାନେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ ନାଲେଃକେ ଡାଗ୍‌ଚେ ବିନ୍‍ନ୍ନିଆ ପାର୍‍ମାନ୍‍ ବିଃନ୍‍ସା ମୋଶାନେ ଆଦେସ୍‍ ଅନୁସାରେ ବେଦିନ୍ନିଆ ଦାନ୍ ବିଃ । ");
INSERT INTO gaq_vpl VALUES ("LK5_15","072_5_15","LUK","5","15","15","ଡାଗ୍ଲା ଜିସୁନେ ବିସୟ୍‌ରେ ସାମୁଆଁ ଆରି ଅଦିକ୍‍ ଉଡ୍ରା ଡିଙ୍ଗ୍‌କେ ଆରି ଜବର୍ ରେମୁଆଁ ଅଁନ୍‌ସା ଆରି ନିଜେ ନିଜେ ରଗ୍ ବାନ୍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍ନେସା ମୁଇଂନ୍ନିଆ ରିସିଙ୍ଗ୍‍ନେ ଲାଗେକେ; ");
INSERT INTO gaq_vpl VALUES ("LK5_16","072_5_16","LUK","5","16","16","ମାତର୍ ମେଁ ରେମୁଆଁ ଣ୍ଡୁନେ ଟାନ୍‌ନିଆ ଲେଃଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_17","072_5_17","LUK","5","17","17","ମେସୁଆ ଜିସୁ ବୁଦି ବିଡିଙ୍ଗ୍‌ଗେ ଆରି ଗାଲିଲୀନେ ସାପା ଇନି ଆରି ଜିଉଦା ପ୍ରଦେସ୍‌ନେ ଆରି ଯିରୁସାଲାମ୍‍ ବାନ୍ ପାଙ୍ଗ୍‌ଲେକ୍ନେ ଫାରୁଶୀ ଆରି ନିଅମ୍‌କାରି‍ଇଂ ଡାଗ୍ରା କଲେ ଆର୍‌ଗେ । ଆରି ମେଁ ଜେନ୍ତିକି ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌‌ସା ମାପ୍ରୁନେ ବପୁ ମେଁନ୍ନିଆ ପାଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_18","072_5_18","LUK","5","18","18","ଆରି କେଲା ଉଡ଼ିରୁଆ ମୁଇଙ୍ଗ୍ ନ୍ତି ଞ୍ଚ ନ୍‍ସୁଆର୍‍ଲେଃକ୍ନେ ରେମୁଆଁକେ କଟ୍‌ନିଆ ଡୁଙ୍ଗ୍‍ ଡୁଂପାଙ୍ଗ୍‌ଚେ ଆମେକେ ବିତ୍ରେ ଡୁଂୱେଚେ ଆରି ମେଁ ଡାଗ୍ରା ବନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_19","072_5_19","LUK","5","19","19","ଡାଗ୍ଲା ଜାବର୍‌ ରେମୁଆଁ ରିସିଙ୍ଗ୍ ଲେଃଗେ ଆତେନ୍‌‌ସା ଆମେକେ ବିତ୍ରେ ଡୁଂୱେନ୍‍ସା ଗାଲି ଆବାଲା ମେଇଂ ଡୁଆ ଆଡ଼ାତ୍ରା ଡୁଙ୍ଗ୍‍ୱେଚେ ବ୍ଲେସାଂ ଆପ୍ଲଗ୍‍ଚେ କଟ୍ ଡାଣ୍ଡି ଏତେ ଆମେକେ ମଜେ ଜାଗାନ୍ନିଆ ଜିସୁଡାଗ୍ରା ଆଜାର୍ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_20","072_5_20","LUK","5","20","20","ମେଁ ମେଁଇଙ୍ଗ୍‌ନେ ବିସ୍‌ବାସ୍‍ କେଚେ ବାସଙ୍ଗ୍‌କେ, “ଅ ଗଡ଼େଅ ନାନେ ପାପ୍ ସାପା କେମା ଡିଙ୍ଗ୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK5_21","072_5_21","LUK","5","21","21","ଆତ୍‌ଅରିଆ ଦର୍ମ ଗୁରୁ ଆରି ଫାରୁଶୀ‍ଇଂ ନିଜେ ନିଜେ ବାଲିର୍‌ବାତାଚେ ବାସଙ୍ଗ୍‍ନେ ଲାଗେଆର୍‌କେ, “ଇସ୍‌ପର୍‌କେ ନିନ୍ଦା ଆଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ, ଏନ୍‌ ଜାଣ୍ଡେ ? କେବଲ୍‍ ଇସ୍‌ପର୍‌ବାନ୍ ଆରି ଜାଣ୍ଡେ ପାପ୍ କେମା ଡିଙ୍ଗ୍ଇଁୟାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK5_22","072_5_22","LUK","5","22","22","ଡାଗ୍ଲା ଜିସୁ ମେଁଇଙ୍ଗ୍‌ନେ ବାଲିର୍‌ବାତାନେ ମ୍ୟା ୟାଚେ ଆମେଇଂକେ ଉତର୍ ବିକେ ପେଇଂ ନିଜେ ନିଜେ ମନ୍‍ନ୍ନିଆ ମେଁନ୍‌ସା ବାଲିର୍‌ବାତା ଡିଂପେଡିଂକେ ? ");
INSERT INTO gaq_vpl VALUES ("LK5_23","072_5_23","LUK","5","23","23","ମେଃନେ ବାସଙ୍ଗ୍‌ନେ ସଅଜ୍‌ ? ନାନେ ପାପ୍ କେମା ଡିଙ୍ଗ୍‌ଗେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ନେ ବା ତଡ଼ିଆ ୱେଲା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ନେ ? ");
INSERT INTO gaq_vpl VALUES ("LK5_24","072_5_24","LUK","5","24","24","ଡାଗ୍ଲା ମଞ୍ଚ୍‌ପୁର୍‌ନେ ପାପ୍ କେମା ଡିଙ୍ଗ୍‍ନେସା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ଜେ ଅଦିକାର୍ ଲେଃକେ ଆକେନ୍ ଜେନ୍ତିକି ପେଇଂ ମ୍ୟା ପେୟାଏ ଆତେନ୍‌‌ସା ନ୍ତି ଞ୍ଚ ନ୍‍ସୁଆର୍‍ଲେଃକ୍ନେ ରେମୁଆଁ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆନାକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ତଡ଼ିଆ ନିଜେନେ ସିଙ୍ଗ୍‌ଲା ସାଚେ ନାନେ ଡୁଆ ୱିଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK5_25","072_5_25","LUK","5","25","25","ଆତ୍‌ବା ମେଁ ଦାପ୍ରେ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ତଡ଼ିଆଚେ ଆଣ୍ଡିନେ ସିଙ୍ଗ୍‌ଲା ଆଡ଼ାତ୍ରା ମେଁ ଡୁଲେଗ୍‍ ଲେଃଗେ ଆତେନ୍‌ ସାଚେ ଇସ୍‌ପର୍‌ନେ ମ‍ଇମା ଅସ୍‌ମାର୍ ସାର୍‍ଚେ ନିଜେନେ ଡୁଆ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_26","072_5_26","LUK","5","26","26","ଆତ୍‌ଅରିଆ ସାପାରେ ବୁଟଚେ ଇସ୍‌ପର୍‌ନେ ମ‍ଇମା ଅସ୍‌ମାର୍ ସାର୍‍ନେ ଲାଗେକେ ଆରି ଜାବର୍‌ ତାନ୍ଦ୍ରା ଡିଙ୍ଗ୍‍ଚେ ବାସଙ୍ଗ୍‌କେ ଏଃକେ ନେ ବଡ଼େ ବୟ୍‍ଙ୍କାର୍‍ ଗଟ୍‌ନା ନେକେକେ ! ");
INSERT INTO gaq_vpl VALUES ("LK5_27","072_5_27","LUK","5","27","27","ଆତ୍‌ବା ଜିସୁ ପାଦା ୱେଚେ ଲେବୀ ମ୍ନିନେ ମୁଇଂଜା ସିସ୍ତୁ ସାଲ୍ୟାନେ ଜାଗାନ୍ନିଆ କଲେଃକ୍ନେ କେଚେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK5_28","072_5_28","LUK","5","28","28","ଆତ୍‌ବା ଲେବୀ ସାପା ଆନ୍ତାର୍‌ଚେ ମେଁନେ ପ୍ଲା ୱେନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_29","072_5_29","LUK","5","29","29","ଆରି ଲେବୀ ନିଜେ ଡୁଆ ମେଁ ଆତ୍ଲା ମୁଇଙ୍ଗ୍ ମ୍ନା ବଜି ଡିଙ୍ଗ୍‌କେ ଆରି ଗୁଲୁଏ ରେମୁଆଁ ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ତ୍ରେ ଆରି ବିନ୍‌ବିନ୍ ରେମୁଆଁ ମେଇଂ ଏତେ ଚଙ୍ଗ୍‍ନ୍‍ସା କଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_30","072_5_30","LUK","5","30","30","ଆତ୍‌ବା ପାରୁସିଇଂ ଆରି ମେଁଇଙ୍ଗ୍‌ନେ କୁଦାନେ ସାସ୍ତ୍ରିଇଂ ମେଁଇଙ୍ଗ୍‌ନେ ସିସ୍ଇଂନେ ବିରଦ୍‌ରେ ବିତ୍ରେ ବିତ୍ରେ ବାସଙ୍ଗ୍‌ନେ ଲାଗେକେ । ପେଇଂ ମେସା ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେକେ ଆରି ପାପିଇଂ ଏତେ ଚଙ୍ଗ୍ ଉଗ୍ ଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("LK5_31","072_5_31","LUK","5","31","31","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ ନିମାଣ୍ଡା ରେମୁଆଁଇଂନେ ଗଦାର୍‌ନିଆ ଦର୍‌କାର୍ ଣ୍ଡୁ ମାତର୍‌ ନିମାଣ୍ଡା ଣ୍ଡୁନେ ରେମୁଆଁଇଂନ୍ନିଆ ଦର୍‌କାର୍ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_32","072_5_32","LUK","5","32","32","ନେଙ୍ଗ୍ ଦାର୍‍ମିକ୍‍ ରେମୁଆଁଇଂକେ ୱା ନ୍‌ସା ନେପାଙ୍ଗ୍‌କେ ଣ୍ଡୁ ମାତର୍‌ ମନ୍‍ ଆଃବଦ୍‌ଲେ ନ୍‍ସା ପାପିଇଂକେ ୱା ନ୍‌ସା ପାଙ୍ଗ୍‍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_33","072_5_33","LUK","5","33","33","ମେଇଂ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ ଜହନ୍‌ନେ ସିସ୍ଇଂ ପ୍ରେକ୍ ପ୍ରେକ୍‍ ଉପାସ୍ ଆରି ପାର୍‍ତନା ଡିଙ୍ଗ୍ ମ୍ୟାକେ ପାରୁସିଇଂନେ ସିସ୍ଇଂ ଡିଗ୍ ଦେତ୍ ସୁଗୁଆ ଡିଙ୍ଗ୍ ମ୍ୟାକେ ମାତର୍‌ ନାନେ ସିସ୍ଇଂ ଉଗ୍ ଚଙ୍ଗ୍ ଡିଙ୍ଗ୍ ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK5_34","072_5_34","LUK","5","34","34","ଆତ୍‌ବା ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ତ୍ମି ଙ୍ଗିରେନେ ରେମୁଆଁଇଂ ଏତେ ଙ୍ଗିରେ ଲେଃକେଲା ପେଇଂ ମେଁନେ ଆମେଇଂକେ ଉପାସ୍‍ରେ ପେବଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK5_35","072_5_35","LUK","5","35","35","ମାତର୍‌ ବେଲା ପାଙ୍ଗ୍‌ଏ; ଆରି ଉଡ଼ିବେଲା ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ତ୍ମି ଙ୍ଗିରେକେ ଡୁଂଡ ଆର୍‌ଏ ଆତେନ୍‌ ବେଲା ମେଇଂ ଉପାସ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଅଃନା ଡିଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK5_36","072_5_36","LUK","5","36","36","ଆରି ଜିସୁ ଆମେଇଂକେ ମୁଇଙ୍ଗ୍ ଉଦା‍ଅରନ୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ ଜା ଡିଗ୍ ତ୍ମି ପାଟାଇନେ ଜାଲି ଗୁଆତଗ୍‌ଚେ ବାୱିର୍‍ ପାଟାଇନ୍ନିଆ ଆତଗ୍‍ ଣ୍ଡୁ; ତଗ୍‍ଲା ଆତେନ୍‌ ତ୍ମିକ୍ନେ ପାଟାଇକେ ଗୁଆଃଏ ଆରି ତ୍ମି ପାଟାଇନେ ଜାଲି ଡିଗ୍ ବାୱିର୍‍ ଏତେ ଆମିସେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK5_37","072_5_37","LUK","5","37","37","ଆରି ଜାଣ୍ଡେ ତ୍ମି ଅଙ୍ଗୁର୍ ରସ୍ ବାୱିର୍ ଙ୍କୁଇନିଆ ଆବ ଣ୍ଡୁ; ବଲା ତ୍ମି ଅଙ୍ଗୁର୍ ରସ୍‌ନେ ଙ୍କୁଇକେ ଆପ୍‍ଡାର୍‍ଚେ ଲଃଏ ଆରି ଙ୍କୁଇ ନାସେ ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK5_38","072_5_38","LUK","5","38","38","ମାତର୍‌ ତ୍ମି ଅଙ୍ଗୁର୍ ରସ୍ ତ୍ମି ଙ୍କୁଇନିଆ ବନେ ଦର୍‌କାର୍ । ");
INSERT INTO gaq_vpl VALUES ("LK5_39","072_5_39","LUK","5","39","39","ଆରି ଜାଣ୍ଡେ ଡିଗ୍ ବାୱିର୍‍ ଅଙ୍ଗୁର୍ ରସ୍ ଉଗ୍‌ଚେ ତ୍ମି ଅଙ୍ଗୁର୍ ରସ୍ ଉଗ୍‌ନ୍‌ସା ଇକ୍‌ଚା ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ଡୁ ଡାଗ୍ଲା ମେଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ବାୱିର୍‍ ତ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("LK6_1","072_6_1","LUK","6","1","1","ମେଃସୁଆ ଜିସୁ ପୁଣ୍ଡେନେ ଦିନା ଲିଜ ପାକା ବିଚେ ୱେନେ ବେଲା ମେଁନେ ସିସ୍ଇଂ ଗହମ୍ ଟିକ୍‌ଚିଚେ ନ୍ତି ଏତେ ରମ୍‍ଦେଚେ ଚଙ୍ଗ୍‍ଆର୍‍ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_2","072_6_2","LUK","6","2","2","ମାତର୍‌ ଫାରୁଶୀ‍ଇଂନେ ବାନ୍ ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌କେ ପୁଣ୍ଡେନେ ଦିନା ମେଃଡିଗ୍ ଡିଙ୍ଗ୍‌ନେ ନିଅମ୍ ଣ୍ଡୁ ଆତେନ୍‌ ପେଇଂ ମେଁନ୍‌ସା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("LK6_3","072_6_3","LUK","6","3","3","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ, ଦାଉଦ୍‍ ଆରି ମେଁନେ ସାଙ୍ଗଇଂକେ କେଡ଼େସଃକ୍ନେ ବେଲା ମେଁ ମେଃନେ ଡିଙ୍ଗ୍ ବଗେ ଆତେନ୍‌ ଡିଗ୍ କି ପେ ପେପଡ଼େକେ ? ");
INSERT INTO gaq_vpl VALUES ("LK6_4","072_6_4","LUK","6","4","4","ଦାଉଦ୍‍ ଇସ୍‌ପର୍‌ନେ ଡୁଆ ବିତ୍ରେ ଗାଚେ ଆଣ୍ଡିନେ ଦର୍ଶନି ରୁଟି ମାତର୍ ପୁଜାରିଇଂକେ ଆନ୍‌ତାର୍‌ଚେ ଆରି ଆଜାଡିଗ୍ ଚଙ୍ଗ୍‍ନେ ନିଅମ୍ ଣ୍ଡୁ ଆତେନ୍‌ ଡୁଙ୍ଗ୍‍ୱେଚେ ଚଙ୍ଗ୍‍ଲେଃଆର୍‌ଗେ ଆରି ମେଁନେ ସାଙ୍ଗଇଂକେ ଡିଗ୍ ଚଙ୍ଗ୍‍ନେସା ବିବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_5","072_6_5","LUK","6","5","5","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ପାରୁସିଇଂକେ ବାସଙ୍ଗ୍‌କେ “ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପୁଣ୍ଡେନେ ଦିନାନେ ଡିଗ୍ ମାପ୍ରୁ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK6_6","072_6_6","LUK","6","6","6","ଜିସୁ ଆରି ମୁଇଂ ପୁଣ୍ଡେନେ ଦିନା ଜିଉଦି ପାର୍‍ତନା ଡୁଆନ୍ନିଆ ୱେକେ ଆତ୍‌ଅରିଆ ମେଁ ରେମୁଆଁଇଂକେ ନିମାଣ୍ଡାନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ ଆତ୍‌ଅରିଆ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଲେଃଗେ ମେଁନେ ଞ୍ଚଙ୍ଗ୍‌ତି ନ୍‍ସୁଆର୍‍ ୱେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_7","072_6_7","LUK","6","7","7","ଆରି ମେଁ ଇଙ୍ଗ୍‌ଚା ପୁଣ୍ଡେନେ ଦିନା ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌ଲେ ଆକେନ୍ କେନ୍‍ସା ଦର୍ମ ଗୁରୁଇଂ ଆରି ଫାରୁଶୀଇଂ ଆମେକେ ମୁଇଙ୍ଗ୍ ମୁଆଃରେ କିକେ ଲେଃଆର୍‌ଗେ ଡିରକମ୍ ମେଇଙ୍ଗ୍ ମେଁନେ ବିରଦ୍‌ରେ ଦସ୍ ସାଃନ୍‌ସା ଉପାୟ୍ ବାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK6_8","072_6_8","LUK","6","8","8","ମାତର୍‌ ମେଁ ମେଁଇଙ୍ଗ୍‌ନେ ମନ୍‍ନେ ବାବ୍‍ନା ମ୍ୟାଚେ ମୁଡ଼ି ରେମୁଆଁନେ ନ୍ତି ନ୍‍ସୁଆର୍‍ ୱେ ଲେଃଗେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ ତଡ଼ିଆ ସାପାରେନେ ମଜେ ତୁଆଁ । ଆରି ମେଁ ତଡ଼ିଆ ତୁଆଁକେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_9","072_6_9","LUK","6","9","9","ଆତ୍‌ବା ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, ନେଙ୍ଗ୍ ଆପେକେ ସାଲିଆକୁ ଣ୍ଡିଙ୍ଗ୍‍କେ ପୁଣ୍ଡେନେ ଦିନା ମେଃନେ ସାସ୍ତର୍‌ନେ ନିଅମ୍ ଲେଃକେ ? ନିମାଣ୍ଡା ଆଃଡିଂନେ ଲେଃ ଦଦ୍ୟା ଆଡିଙ୍ଗ୍‌ନେ ? ଜିବନ୍ ଆମ୍ବ୍ର ନ୍ଲେ ଆଗୁଏଚେ ? ");
INSERT INTO gaq_vpl VALUES ("LK6_10","072_6_10","LUK","6","10","10","ଆରି ମେଁ ଅଁପାକା ସାପା ରେମୁଆଁ ଡାଗ୍ରା କେଚେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ ନାନେ ନ୍ତି ଆଃଚ୍ଲେବିଃ । ଆତ୍‌ବା ମେଁ ନ୍ତି ଆଃଚ୍ଲେକେ ଆରି ମେଁନେ ନ୍ତି ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ୱେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK6_11","072_6_11","LUK","6","11","11","ମାତର୍‌ ମେଇଙ୍ଗ୍ ଗିସେ ଡିଙ୍ଗ୍‌କେ ଆରି ଜିସୁ ଆଡ଼ାତ୍ରା ମେଃନେ ଡିଙ୍ଗ୍ ୟାଏ ଆତେନ୍‌ ବିସୟ୍‌ରେ ମେଇଂମେଇଂ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_12","072_6_12","LUK","6","12","12","ଆତେନ୍‌ ବେଲା ମେଁ ମେସୁଆ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ନ୍‌ସା କଣ୍ଡାପାକା ତାର୍‍ୱେଚେ ଇସ୍‌ପର୍ ଡାଗ୍ରା ପ୍ରାଃ ମିଡିଗ୍‌ ପାର୍‍ତନା ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_13","072_6_13","LUK","6","13","13","ମାର୍‌ତଡ଼େ ଞ୍ଜିର୍‌ନୁଗ୍ ମେଁ ନିଜେନେ ସିସ୍ଇଂକେ ଡାଗ୍ରା ୱାଚେ ମେଇଙ୍ଗ୍‌ନେ ବିତ୍ରେବାନ୍ ଗମ୍ୱାର୍ ରେମୁଆଁକେ ବାଚେକେ; ମେଁ ଆମେଇଂକେ ଡିଗ୍ ପ୍ରେରିତ୍‌ ମ୍ନି ବିକେ; ");
INSERT INTO gaq_vpl VALUES ("LK6_14","072_6_14","LUK","6","14","14","ମେଇଂ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଶିମୋନ ଆଜାକେ ମେଁ ଡିଗ୍ ପିତର୍ ମ୍ନି ବିକେ ଆରି ମେଁନେ ବୟାଁଣ୍ଡେ ଆନ୍ଦ୍ରିୟ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ଫିଲିପ୍‌ପ ଆରି ବାର୍ଥଲମି ");
INSERT INTO gaq_vpl VALUES ("LK6_15","072_6_15","LUK","6","15","15","ମାତିଉ ଆରି ଥୋମା, ଆଲଫିନେ ଉଙ୍ଗ୍‌ଡେ ଜାକୁବ୍‌ ଆରି ଶିମୋନ ଆଜାକେ ଦେସ୍‌ପ୍ରେମି ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ମ୍ୟାଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK6_16","072_6_16","LUK","6","16","16","ଜାକୁବ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଜିଉଦା ଆରି ଇଷ୍କାରିୟୋଥ୍ ଜିଉଦା ଜାଣ୍ଡେ ଆମେକେ ସତ୍ରୁ ନ୍ତି ନ୍ନିଆ ଆଃସାଃ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_17","072_6_17","LUK","6","17","17","ଆରି ମେଁ ମେଁଇଙ୍ଗ୍‌ ଏତେ କଣ୍ଡାବାନ୍‍ ଜାର୍‌ଚେ ମୁଇଙ୍ଗ୍ ସମ୍‌ ଜାଗାନ୍ନିଆ ତୁଆଁ ଆର୍‌କେ ଆରି ମେଁନେ ଗୁଲେ ସିସ୍ଇଂ ଆରି ସାପା ଜିଉଦା ପ୍ରଦେସ୍ ଯିରୁଶାଲାମ୍‍ ଆରି କେଣ୍ଡିଆ ଆଃଡ଼ା ଲେଃକ୍ନେ ସୋର ଆରି ସୀଦୋନ ଇନିନେ ଗୁଲେ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଆର୍‌କେ; ");
INSERT INTO gaq_vpl VALUES ("LK6_18","072_6_18","LUK","6","18","18","ମେଇଙ୍ଗ୍ ମେଁନେ ସାମୁଆଁ ଅଁନ୍‌ସା ଆରି ନିଜର୍ ନିଜେ ନିଜେନେ ରଗ୍‍ବାନ୍‍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ନ୍‌ସା ପାଙ୍ଗ୍‌ଲେ ଆର୍‌କେ ଆରି ଜାଣ୍ଡେକେ ଦଦ୍ୟା ଆତ୍ମାଇଂବାନ୍‍ ଦୁକ୍ ବାଆର୍‌ଏ ଡିଙ୍ଗ୍‌ଗେ ମେଇଙ୍ଗ୍ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌କେ; ");
INSERT INTO gaq_vpl VALUES ("LK6_19","072_6_19","LUK","6","19","19","ଆରି ରେମୁଆଁଇଂ ଆମେକେ ଲିଗ୍‍ନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍ଗେ ଡାଗ୍ଲା ମେଁନେ ଗାଗ୍‌ଡ଼େବାନ୍ ବପୁ ତାର୍‌ଚେ ସାପାରେକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_20","072_6_20","LUK","6","20","20","ଆତେନ୍‌ ବେଲା ସିସ୍ଇଂକେ କେଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଏ ଗରିବ୍ ରେମୁଆଁଇଂ ପେଇଂ ନିମାଣ୍ଡା, ଡାଗ୍ଲା ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ପେନେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_21","072_6_21","LUK","6","21","21","ପେ ଏବେ କେଡ଼େସଃ ପେଲେକେ ପେ ନିମାଣ୍ଡା, ଡାଗ୍ଲା ପେନେ ସୁଲୁଏଃ ବର୍ତି ଡିଙ୍ଗ୍‌ଏ । ପେ ଏବେ ଅଁ ପେଡିଙ୍ଗ୍‌କେ ଜେ ପେଇଂ ନିମାଣ୍ଡା, ଡାଗ୍ଲା ପେଇଂ ପେଲୁଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK6_22","072_6_22","LUK","6","22","22","ରେମୁଆଁ ଅଃନା ଆପେକେ କୁଟ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ, ବାରି ରେମୁଆଁ ଉଂଡେ ନ୍‌ସା ବିନେ ଆଃଡିଂଆର୍‌ଏ, ବାରି ନିନ୍ଦା ଡିଂଆର୍‌ଏ ଆରି ପେନେ ମ୍ନିକେ ଦଦ୍ୟା ଡାଗ୍‌ଚେ ଗୁର୍‌ନା ଡିଂଆର୍‌ଏ, ତେଲା ପେ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("LK6_23","072_6_23","LUK","6","23","23","ଆତେନ୍‌ ବେଲା ସାର୍‍ଦା ଡିଙ୍ଗ୍‌ଚେ ୱାଡ଼େଙ୍ଗ୍‍ ୱାପା ଡାଗ୍ଲା କିତଂଇନିନ୍ନିଆ ପେ ନ୍‌ସା ମ୍ନା ପୁରସ୍‌କାର୍ ବକେ । ମେଇଙ୍ଗ୍‌ନେ ନ୍ତା ଞ୍ଜାଇଂ ବାବବାଦିଇଂନେ ଆଡ଼ାତ୍ରା ଟିକ୍‌ ଦେକ୍‌ରକମ୍ ଡିଙ୍ଗ୍‌ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_24","072_6_24","LUK","6","24","24","ଅ ସାଉକାର୍‌ ରେମୁଆଁଇଂ ! ଏବେ ପେଇଂ ସୁକ୍‌ରେ ପେଲେକେ ! ଡାଗ୍ଲା ପେଇଙ୍ଗ୍‌ ସାରା ସାରି ଜିବନ୍ ଉଡ଼ି ବୟାଙ୍କାର୍‌ ! ");
INSERT INTO gaq_vpl VALUES ("LK6_25","072_6_25","LUK","6","25","25","“ଅ ଚଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂ ପେଇଂନେ ସାରାସାରି କସ୍ଟ ଉଡ଼ି ବୟାଙ୍କାର୍‌ ! ପେଇଂ କେଡ଼େସ ପେଲେଃଏ । ଏବେ ଜାଣ୍ତେଇଂ ଲୁୱା ପେଡିଙ୍ଗ୍‌କେ ପେଇଂ ଲୁୱାନେ ଅଃନେ ବାରି କେଡ଼େସ ପେଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK6_26","072_6_26","LUK","6","26","26","ଉଡ଼ିବେଲା ରେମୁଆଁ ଆପେକେ ନିମାଣ୍ତା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍ଆର୍‌ଏ, ଆତେନ୍‌‌ ବେଲା ଚିଃ ପେଇଂ ଡଣ୍ଡ୍‍ନେ ପାତ୍ର; ଦେତ୍‌ସୁଗୁଆ ତ ମେଁଇଙ୍ଗ୍‌ନେ ନ୍ତା ଞ୍ଜାଇଂ ମିଚ୍ ବାବବାଦିଇଂ ଆଡ଼ାତ୍ରା ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_27","072_6_27","LUK","6","27","27","“ପେଇଂ ଉଡ଼ିରୁଆ ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁ ପେ ଣ୍ଡିଗ୍ ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍କେ ପେଇଂ ସତ୍ରୁକେ ଆଲାଦ୍ ଡିଂପା । ଜାଣ୍ଡେଇଂ ଆପେକେ ନିନ୍ଦା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ମେଇଂ ନ୍‌ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK6_28","072_6_28","LUK","6","28","28","ଜାଣ୍ଡେଇଂ ଆପେକେ ଅବିସାପ୍ ବିଆର୍‌ଏ ଆମେଇଂକେ ଆସିର୍ବାଦ୍ ଡିଙ୍ଗ୍‌ପା; ଜାଣ୍ଡେଇଂ ଆପେକେ ଅପମାନ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ମେଇଙ୍ଗ୍ ଆତ୍‍ଲା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK6_29","072_6_29","LUK","6","29","29","ଜାଣ୍ଡେ ଆପେକେ ମୁଇଙ୍ଗ୍‌ ଗିଙ୍ଗିଙ୍ଗ୍ ଚାପ୍‌ଡ଼ା ବଗ୍ଏ ଆମେକେ ଆରି ମୁଇଙ୍ଗ୍ ଗିଙ୍ଗିଙ୍ଗ୍ ଆଃସୁଏ ବିଃପା; ଆରି ଜାଣ୍ଡେ ନାନେ ତଗ୍‌ରିଆ ଡୁଙ୍ଗ୍‌ଡଏ ଆମେକେ ନାନେ ସକା ଡିଗ୍ ଡୁଙ୍ଗ୍‍ଡନ୍‍ସା ମନା ଆଡିଂଗେପା । ");
INSERT INTO gaq_vpl VALUES ("LK6_30","072_6_30","LUK","6","30","30","ଜାଣ୍ଡେ ଆପେକେ ସାଲିଆଏ, ଆମେକେ ବିଃପା, ବାରି ଜାଣ୍ତେ ପେନେ ମେଃଡିଗ୍‌ ଜିନିସ୍‌ ଡୁଙ୍ଗ୍‌ଡଏ, ତେଲା ଆତେନ୍‌‌ ବାରି ମୁଇଂତର୍‌ ଆସାଲ୍ୟାଗେପା । ");
INSERT INTO gaq_vpl VALUES ("LK6_31","072_6_31","LUK","6","31","31","ପେଇଂ ବିନ୍‌ଣ୍ଡ୍ରେଇଂନେ ବାନ୍‌ ଡିରକମ୍ ବେପାର୍‌ ବାନ୍‌ସା ଇକ୍‌ଚା ପେଡିଙ୍ଗ୍‌ଏ ମେଇଂନେ ଆଡ଼ାତ୍ରା ଦେତ୍‌ରକମ୍ ବେବଆର୍‌ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK6_32","072_6_32","LUK","6","32","32","ଜାଣ୍ଡେଇଂ ଆପେକେ ଆଲାଦ୍ ଡିଂମ୍ୟାକେ ପେ ଜଦି ଆମେଇଂକେ ଆଲାଦ୍ ପେଡିଂଏ ତେଲା ପେଇଂ ମେଃ ଆସିର୍ବାଦ୍ ପେବାଏ ? ଡାଗ୍ଲା ପାପିଇଂ ଡିଗ୍ ଆମେଇଂକେ ଆଲାଦ୍ ଡିଂମ୍ୟାଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK6_33","072_6_33","LUK","6","33","33","ଆରି ଜାଣ୍ଡେଇଂ ପେନେ ମଙ୍ଗଲ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ତେଲା ପେଇଂ ଡିଗ୍ ମେଇଂନେ ମଙ୍ଗ୍‍ଲ୍‌ ଡିଙ୍ଗ୍ ତେଲା ପେ ଡିରକମ୍‍ନେ ଆସିର୍ବାଦ୍ ପେବାଏ ? ଡାଗ୍ଲା ପାପିଇଂ ଦେତ୍ ରକମ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK6_34","072_6_34","LUK","6","34","34","ଆରି ଜାଣ୍ଡେଇଂନେ ବାନ୍ ପେଇଂନେ ବାନେ ଆସା ଲେଃଏ ଆମେଇଂକେ ରୁନ୍‍ ବିଲା ପେଇଂ ଡିରକମ୍‍ନେ ଆସିର୍ବାଦ୍ ପେବାଏ ? ପାପିଇଂ ଡିଗ୍ ସମାନ୍ ବାଟାରେ ସୁଜେନ୍‍ସା ପାପିଇଂକେ ରୁନ୍‍ ବିମ୍ୟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_35","072_6_35","LUK","6","35","35","ମାତର୍‌ ପେଇଙ୍ଗ୍‌ନେ ସତ୍ରୁଇଂକେ ଆଲାଦ୍ ଡିଂପା ଆରି ମେଁଇଙ୍ଗ୍‌ନେ ମଙ୍ଗଲ୍‍ ଡିଙ୍ଗ୍‌ପା ଆରି ସୁଜେନ୍‍ସା ଆସା ଆବଚେ ରୁନ୍‍ ବିଃପା; ତେଲା ପେଇଂ ପୁରୁସ୍‌କାର୍‌ ମ୍ନା ଡିଙ୍ଗ୍‌ଏ ଆରି ପେଇଂ ସାପାବାନ୍‍ କିତଂନେ ଆବାନେ ଉଙ୍ଗ୍‌ଡେ ପେଡିଙ୍ଗ୍‌ଏ ଡାଗ୍ଲା ମେଁ ବାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଡିଗ୍ ଉପ୍‍କାର୍ ଆବୁଜେ ଣ୍ଡୁ ଦେତ୍‍ରକମ୍‍ ରେମୁଆଁ ଆରି ଦୁଷ୍ଟ ରେମୁଆଁଇଂ ନ୍ନିଆ ଆଡ଼ାତ୍ରା ଡିଗ୍ ଦୟା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK6_36","072_6_36","LUK","6","36","36","ପେଇଂନେ ଆବା ଡିରକମ୍ ଲିବିସ ପେଇଙ୍ଗ୍‌ ଡିଗ୍ ଦେତ୍‌ସୁଗୁଆ ଲିବିସ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK6_37","072_6_37","LUK","6","37","37","ଆରି ବିଚାର୍ ଆଡିଙ୍ଗ୍‌ପା ନାମଃ ତେଲା ଇସ୍‌ପର୍ ପେଇଂନେ ବିଚାର୍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ; ଦସ୍‍ ଆରାଡିଙ୍ଗ୍‌ପା ତେଲା ଇସ୍‌ପର୍ ଆପେକେ ଦସି ଆରାଡିଙ୍ଗ୍‍ ଣ୍ଡୁ । କେମା ଡିଙ୍ଗ୍‌ପା ତେଲା ଇସ୍‌ପର୍ ଆପେକେ କେମା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK6_38","072_6_38","LUK","6","38","38","ଦାନ୍ ବିଃପା ତେଲା ଇସ୍‌ପର୍ ଆପେକେ ଦାନ୍ ବିଏ; ରେମୁଆଁ ବଃଡ଼େକେ ବର୍‌ତି ଆଡିଙ୍ଗ୍‌ଚେ ଆମେକେ ଚାପେଚେ ଆତ୍ନଚେ ଲାଡ଼୍ୟା ଆପେକେ ଜାଚେଚେ ବିଆର୍‌ଏ; ଡାଗ୍ଲା ଆଣ୍ଡିନେ ମାପ୍‍ରେ ମାପେ ନାଡିଂକେ ଆତେନ୍‌ ମାପ୍‍ରେ ଇସ୍‌ପର୍ ଆପେକେ ମାପେଚେ ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK6_39","072_6_39","LUK","6","39","39","ମେଁ ଆମେଇଂକେ ମୁଇଙ୍ଗ୍ ଉସ୍ରା ଡିଗ୍ ବାସଙ୍ଗ୍‌କେ କାନା ମେଃନେ କାନାକେ ଗାଲି ଆଃଅଲେଙ୍ଗ୍ ଡୁଙ୍ଗ୍‌ୱେଏ ? ଜଦି ମେଁ ଦେତ୍‌ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଏ ତେଲା ମେଇଂ ମେଃନେ ମ୍ୱାୟା କୁରୁନିଆ ଆଲ ଆର୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK6_40","072_6_40","LUK","6","40","40","ଗୁରୁବାନ୍‌ ସିସ୍ ମ୍ନା ଣ୍ତୁ; ମାତର୍‌ ସାପା ସିସ୍ଇଂ ବୁଦି ଆଡାଚେ ମେଁଇଙ୍ଗ୍‌ନେ ଗୁରୁ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_41","072_6_41","LUK","6","41","41","“ଆରି ମେଃନ୍‌ସା ନାବୟାଁନେ ମୁଆଃନ୍ନିଆ ଲେଃନେ କାଡ଼ିକେ କିକେ ନାଡିଙ୍ଗ୍‌କେ, ମାତର୍‌ ନାନେ ନିଜେନେ ମୁଆଃନ୍ନିଆ କାଡ଼ି ଲେଃକେ, ଆତେନ୍‌ ମେଃନେ କେୟା ନାଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("LK6_42","072_6_42","LUK","6","42","42","ପେ ଉଡ଼ିବେଲା ନିଜେନେ ମୁଆଃନ୍ନିଆ ଲେଃକ୍ନେ ମ୍ନା କାଡ଼ିକେ କିକେ ନାୟାକେ ଣ୍ଡୁ, ଆତେନ୍‌ ବେଲା ନାବୟାଁକେ ଡିରକମ୍ ବାସଙ୍ଗ୍‌ ନାୟାଏ; ନ୍ନାଙ୍ଗ୍‍ ଗେଃଲା ନାନେ ମୁଆଃନ୍ନିଆ ଲେଃକ୍ନେ କାଚ୍‍ରା ଆଃତାର୍ ମ୍ୱିଏ । ଏ କପଟିଇଂ ! ସେନୁଗ୍‍ ନିଜେ ମୁଆଃନ୍ନିଆ ଲେଃକ୍ନେ କାଚ୍‌ରା ଆଃତାର୍‌, ତେଲା ନା ନିମାଣ୍ଡା ବାବ୍‌ରେ କିକେ ନାୟାଏ ଆରି ବୟାଁନେ ମୁଆଃନ୍ନିଆ ଲେଃକ୍ନେ କାଚ୍‍ରା ଆଃତାର୍ ନାୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK6_43","072_6_43","LUK","6","43","43","ମୁଇଙ୍ଗ୍‌ ନିମାଣ୍ଡା ସ୍ଲାଃନ୍ନିଆ ରୁବୁଗ୍‌କ୍ନେ ଚୁଚୁ ଆଚୁ ଣ୍ଡୁ । ଟିକ୍ ଦେତ୍‌ସୁଗୁଆ ମୁଇଙ୍ଗ୍ ଦଦିଆ ସ୍ଲାଃନ୍ନିଆ ନିମାଣ୍ଡା ଚୁ ଆଚୁ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK6_44","072_6_44","LUK","6","44","44","ଡାଗ୍ଲା ସାପା ସ୍ଲାଃ ମେଁନେ ଚୁଚୁ ଏତେ ସାମୁଆଁ ଡିଙ୍ଗ୍ଏ । ରେମୁଆଁଇଙ୍ଗ୍‌ ଗ୍ରେଃ ସ୍ଲାବାନ୍ ତ ଲିୱା ଆରୁଏଆର୍ ଣ୍ଡୁ । ବା ଗ୍ରେ ଲାଟାବାନ୍‍ ଅଙ୍ଗୁର୍ ଚୁଚୁ ଆରୁଏଆର୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK6_45","072_6_45","LUK","6","45","45","ନିମାଣ୍ଡା ରେମୁଆଁ ମନ୍ ବିତ୍ରେ ନିମାଣ୍ତା ସାମୁଆଁ ଆର୍ମେଚେ ବଏ ଆତେନ୍‌‌ସା ମେଁ ମନ୍ ବିତ୍ରେବାନ୍‍ ନିମାଣ୍ଡାନେ ସାମୁଆଁ ତାର୍‌ଏ ମାତର୍‌ ମୁଇଙ୍ଗ୍‌ ଦଦିଆ ରେମୁଆଁନେ ମନ୍ ବିତ୍ରେ ଦଦ୍ୟା ସାମୁଆଁ ଆର୍ମେଚେ ବଏ ଆତେନ୍‌‌ସା ମେଁ ମନ୍ ବିତ୍ରେବାନ୍‌ ଦଦ୍ୟା ସାମୁଆଁ ତାର୍‌ଏ । ମୁଇଙ୍ଗ୍‌ ରେମୁଆଁନେ ମନ୍ ବିତ୍ରେ ମେଁନେ ଲେଃଏ ମେଁ ଆତେନ୍‌‌ ବାସଙ୍ଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK6_46","072_6_46","LUK","6","46","46","ପେଇଙ୍ଗ୍‌ ଆନେଙ୍ଗ୍ ମେଁନ୍‌ସା ସାମୁଆଁ ମାପ୍ରୁ, ମାପ୍ରୁ ଡାଗ୍‌ଚେ ୱା ପେଡିଙ୍ଗ୍‌କେ ? ମାତର୍‌ ନେଙ୍ଗ୍ ମେଁନେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ପେଇଙ୍ଗ୍‌ ତ ନେଙ୍ଗ୍‌ନେ ନିଅମ୍ ପାଲେ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("LK6_47","072_6_47","LUK","6","47","47","ଜାଣ୍ଡେ କି ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଏ ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁଚେ ପାଲେ ମେଁ ଜା ରକମ୍ ଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ନେଙ୍ଗ୍ ଆପେକେ ଆମ୍ୟା ମ୍ୱିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK6_48","072_6_48","LUK","6","48","48","ଆତେନ୍‌ ରେମୁଆଁ ଡୁଆ ଆରେଡିଙ୍ଗ୍‍କ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ସୁଗୁଆ । ମେଁ ସ୍ରି କୁରୁ ଗଃଚେ ଆରି ଡାଟ୍ ବ୍ରି ଆଡ଼ାତ୍ରା ପାଣ୍ଡୁସନ୍ ତ୍ଲାଗ୍‍ଏ ! ଉଡ଼ିବେଲା ବ୍ରୁଆଣ୍ଡିଆ ପାଙ୍ଗ୍‌ଏ ଣ୍ଡିଆ ଆତେନ୍‌ ଡୁଆକେ ଆଃଡୁଙ୍ଗ୍‌ଡ୍ୟା ଡୁଙ୍ଗ୍‍ୱେନ୍‍ସା ଦକା ବଗ୍‍ଏ ମାତର୍‌ ବିଲ୍‍କୁଲ୍‍ ଆଲ୍‌ତୁଗ୍ ଆୟାଆର୍ ଣ୍ଡୁ । ଡାଗ୍ଲା ଆତେନ୍‌ ଡୁଆ ମଜ୍‍ବୁତ୍‍ରେ ଆରେ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK6_49","072_6_49","LUK","6","49","49","ମାତର୍‌ ମୁଡ଼ି ରେମୁଆଁ ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁଚେ ସାମୁଆଁ ଆମାନେ ଆର୍‌ଏ ଣ୍ଡୁ ଆତେନ୍‌ ରେମୁଆଁ ପାଣ୍ଡୁସନ୍ ମାତ୍‍ଲାଗ୍‍ଚେ ବାଲି ଆଡ଼ାତ୍ରା ଆରେକ୍ନେ ରେମୁଆଁ ସୁଗୁଆ । ଉଡ଼ିବେଲା ବ୍ରୁଆଣ୍ଡିଆ ପାଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ଡୁଆ ପାକ୍‌ଚିଚେ ଲଃଏ ଆରି କ୍ଲିଗ୍‌ଡା ଦଦ୍ୟା ଆଡିଙ୍ଗ୍‍ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK7_1","072_7_1","LUK","7","1","1","ଜିସୁ ରେମୁଆଁଇଂକେ ମେଁନେ ସାପା ଆଅଁନ୍‌ସା ଚାଏଁ ଡିଙ୍ଗ୍‌ଗେ ମେଁ ସାପା ବାସଙ୍ଗ୍‌ ଡାଲା ଇଡ଼ିଙ୍ଗ୍ ମେଁ କପୁର୍ନାହୁମ ଅଲେଙ୍ଗ୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_2","072_7_2","LUK","7","2","2","ଆତେନ୍‌ ବେଲା କପୁର୍ନାହୁମନ୍ନିଆ ମୁଇଙ୍ଗ୍ ମୁଇଂସ ସନ୍ୟ‍ଇଂନେ ନେତା ଲେଃଗେ । ମେଁନେ ମୁଇଙ୍ଗ୍ ଗତିରେ ଜାବର୍ ବେମାର୍‍ ଲେଃଗେ ଜେ ମେଁ ଗୁଏନେ ଅବସ୍ତାରେ ଲେଃଗେ । ମୁଇଂସ ସନ୍ୟ‍ଇଂନେ ନେତା ଗତିରେକେ ଜବର୍ ବଲ୍‍ବା ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_3","072_7_3","LUK","7","3","3","ମୁଇଂସ ସନ୍ୟ‍ଇଂନେ ନେତା ମୁଇଂଜାକେ ଜିସୁନେ ବିସୟ୍‌ରେ ଅଁଚେ ମେଁନେ ଡାଗ୍ରା ଉଡ଼ିକ୍ଲିଗ୍ ଦର୍ମ ଜିଉଦି ନେତାଇଂକେ ବେକେ । ମେଁ ବାବେଲେକେ ଜେ ରେମୁଆଁଇଂ ୱେଚେ ଜିସୁକେ ପାଙ୍ଗ୍‍ନ୍‍ସା ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍‌ଲେ ବାରି ଜିସୁ ପାଙ୍ଗ୍‌ଚେ ଗତିରେନେ ପାରାନ୍‍ ରକ୍ୟା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK7_4","072_7_4","LUK","7","4","4","ମେଇଙ୍ଗ୍ ଜିସୁନେ ଡାଗ୍ରା ୱେଚେ ଆମେକେ ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ “ମୁଇଂସ ସନ୍ୟ‍ଇଂନେ ନେତା ମୁଇଂଜା ନାଁନେ ସାଆ ବାନ୍‌ସା ରାଜି । ");
INSERT INTO gaq_vpl VALUES ("LK7_5","072_7_5","LUK","7","5","5","ଜିସୁ ନେଃ ରେମୁଆଁଇଂକେ ଆଲାଦ୍ ଡିଂଡିଂକେ ବାରି ନେ ନ୍‌ସା ପାର୍‌ତନା ଡୁଆ ଆରେ ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_6","072_7_6","LUK","7","6","6","ଆତ୍ ଅରିଆ ଜିସୁ ମେଇଙ୍ଗ୍ ଏତେ ୱେଗେ । ଜିସୁ ଡୁଆ ତେପିଙ୍ଗ୍‌ଚାକେ ବେଲା ମୁଇଂସ ସନ୍ୟ‍ଇଂନେ ନେତା ରେମୁଆଁଣ୍ଡେଇଂକେ ବେକେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ମାପ୍ରୁ କଷ୍ଟ ଆଡିଙ୍ଗ୍‌ଗେ ନାମଃ; ମେଃନ୍‌ସା ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଅଃତେନ୍‍ ଆଃ ନିମାଣ୍ଡା ଣ୍ଡୁ ଜେ ନା ନେଙ୍ଗ୍ ଡୁଆ ନାପାଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK7_7","072_7_7","LUK","7","7","7","ଣ୍ତୁଲା ନେଙ୍ଗ୍‌ ନିଜେ ନାଁନ୍ନିଆ ପାଙ୍ଗ୍‌ନ୍‌ସା ନିଜେକେ ଇକ୍‌ଚା ମନେ ନାଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ମାତର୍‌ ଆଦେସ୍‍ ବିଲା ନେଙ୍ଗ୍‌ନେ ଚାକର୍‌ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_8","072_7_8","LUK","7","8","8","ନେଙ୍ଗ୍ ନାନେ ଅଦିକାର୍ ବିସୟ୍‌ରେ ବୁଜେ ୟା ଣ୍ଡିଙ୍ଗ୍‍ ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ସାଉକାର୍‌ନେ ସାମୁଆଁ ସାଚେ ସ୍ଲେ ଣ୍ଡିଙ୍ଗ୍‍ ଆରି ନେଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଡିଗ୍ ଉଡ଼ିକ୍ଲିଗ୍ ସନ୍ୟ‍ଇଙ୍ଗ୍ ଲେଃକେ । ନେଙ୍ଗ୍ ଜଦି ମୁଇଙ୍ଗ୍ ସନ୍ୟକେ ମ୍ବାସଙ୍ଗ୍‍ଏ “ୱେଲା ଡାଗ୍ଲା ତେଲା ମେଁ ୱେଏ । ନେଙ୍ଗ୍ ଜଦି ବାରି ମୁଇଂଜାକେ ମ୍ବାସଙ୍ଗ୍‍ଏ ଏଃଲା ଡାଗ୍ଲା ତେଲା ମେଁ ପାଙ୍ଗ୍‌ଏ । ନେଙ୍ଗ୍ ଜଦି ନେଙ୍ଗ୍ ଗତିରେକେ ମ୍ବାସଙ୍ଗ୍‍ଏ; ତେଲା ମେଁ ଦେକ୍‌କେ ଡିଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_9","072_7_9","LUK","7","9","9","ଜିସୁ ଆକେନ୍ ଅଁ ଆଃଡାଚେ ଜାବର୍ ବକୁଆ ଡିଙ୍ଗ୍‍ୱଗେ ମେଁ ଆମେଇଂକେ ପ୍ଲାପ୍ଲା ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂ ସାର୍ମୁଆଁ ପାକା ପୁଏଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‍ ଆପେକେ ବାସଙ୍ଗ୍‌ ବ ଡିଙ୍ଗ୍ ଜେ ଦେକ୍‌ରକମ୍ ସତ୍‍ ମାନେଃକେଣ୍ଡ୍ରେ ଆନେଙ୍ଗ୍‌କେ ଇଶ୍ରାୟେଲନ୍ନିଆ ଡିଗ୍ ଆମିଲେକେ ଣ୍ଡୁ !” ");
INSERT INTO gaq_vpl VALUES ("LK7_10","072_7_10","LUK","7","10","10","ଜିସୁନେ ଡାଗ୍ରା ମୁଡ଼ି ରେମୁଆଁଇଂକେ ୱେଲେଆର୍‌ଗେ ମେଇଂ ଡୁଆ ଆଣ୍ଡେ ୱିଗ୍‌ଲା ଇଡ଼ିଙ୍ଗ୍ କେକେ ଜେ ଗତିରେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍ ୱେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_11","072_7_11","LUK","7","11","11","ନାଇନ ମ୍ନିକ୍ନେ ଇନି ନ୍ନିଆ ୱେଗେ ଆରି ମେଁଇଙ୍ଗ୍‌ନେ ସିସ୍ଇଂ ବାରି ଗୁଲୁଏ ରେମୁଆଁ ମେଇଙ୍ଗ୍ ଏତେ ୱେଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_12","072_7_12","LUK","7","12","12","ଜିସୁ ଇନି ଡାଗ୍ରା ପାଙ୍ଗ୍‌ନେ କେଲା ରେମୁଆଁଇଂ ଗୁଏଲେଃକ୍ନେ ରେମୁଆଁକେ ପାଦା ଡୁଙ୍ଗ୍‍ ଡୁଂପାଙ୍ଗ୍‍ଡିଂଗେ ଆତେନ୍‌ ଗୁଏସାଙ୍ଗ୍‌କୁଏନେ ମୁଇଂ ଆଃ ଗଡ଼େଅ ଆରି ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ଗୁଏସାଙ୍ଗ୍‌କୁଏ; ବାରି ଇନିନେ ଗୁଲେ ରେମୁଆଁ ମେଁ ଏତେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_13","072_7_13","LUK","7","13","13","ଆମେକେ କେଚେ ଜିସୁ ମାପ୍ରୁ ମେଁ ଆଡ଼ାତ୍ରା ଲିବିସଃଚେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଆ‍ଅଃଗେ ନାମଃ ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_14","072_7_14","LUK","7","14","14","ଆରି ଜିସୁ ଡାଗ୍ରା ୱେଚେ କଟ୍ ଡାଣ୍ଡିକେ ଲିଗ୍‌କେ ତେନ୍‌ ଇଡ଼ିଂ ଡୁଙ୍ଗ୍‍ଲେଃଆର୍‍କ୍ନେ ରେମୁଆଁଇଂ ତୁଆଁଆର୍‌କେ ମେଁ ବାସଙ୍ଗ୍‌କେ ଙ୍ଗିରେ ନେଙ୍ଗ୍ ଆନାକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ ତଡ଼ିଆ । ");
INSERT INTO gaq_vpl VALUES ("LK7_15","072_7_15","LUK","7","15","15","ଆତ୍‍ ଅରିଆ ଗୁଏଲେଃକ୍ନେ ଗଡ଼େଅ ତଡ଼ିଆ କକେ ବାରି ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ ଆରି ଜିସୁ ଆମେକେ ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେନେ ନ୍ତି ଅରିଆ ଆଃସାଃ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_16","072_7_16","LUK","7","16","16","ଆତ୍‍ ଅରିଆ ସାପାରେ ଇରିଆତୁଗ୍‌ ୱେଗେ ବାରି ଇସ୍‌ପର୍ ମାପ୍ରୁନେ ଅସ୍‌ମାର୍ ସାର୍‍ଚେ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ । “ନେନେ ଡାଗ୍ରା ମୁଇଙ୍ଗ୍ ମ୍ନାନେ ବାବବାଦି ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ଆରି ଇସ୍‌ପର୍ ନିଜେନେ ରେମୁଆଁଇଂକେ ଆମ୍ବ୍ର ନ୍‌ସା ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_17","072_7_17","LUK","7","17","17","ଆରି ଜିସୁନେ ବିସୟ୍‌ରେ ଆକେନ୍ ସାମୁଆଁ ସାପାରେ ଜିଉଦା ଦେସ୍ ଆରି ସାପାପାକା ସାପା ଇନି ନ୍ନିଆ ବେପ୍ରେ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_18","072_7_18","LUK","7","18","18","ଇଡ଼ିଙ୍ଗ୍ ଜହନ୍‌ନେ ସିସ୍ଇଂ ଆକେନ୍ ସାପା ବିସୟ୍ ଆମେକେ ଆମ୍ୟା ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_19","072_7_19","LUK","7","19","19","ଆତ୍‍ ଅରିଆ ଜହନ୍‌ ନିଜେନେ ସିସ୍‌‍ଇଂ ବାନ୍ ମ୍ବାୟାକେ ଡାଗ୍ରା ୱାଚେ ମାପ୍ରୁନେ ଡାଗ୍ରା ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ବେକେ ଜାଣ୍ଡେ ପାଙ୍ଗ୍‌ନେ ଲେଃକେ ଆତେନ୍‌ ରେମୁଆଁ ନିଜର୍‌ନେ ବାରି ନେ ବିନ୍‌ଣ୍ଡ୍ରେକେ ଉର୍ ନେଲେଃଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK7_20","072_7_20","LUK","7","20","20","ଅଃତେନ୍‍ ରେମୁଆଁଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଡୁବନ୍‌ ବିଃଣ୍ଡ୍ରେ ଜହନ୍‌ ଆନେକେ ନାନେ ଡାଗ୍ରା ଏନ୍ ସାମୁଆଁ ସାଲିଆକୁ ନ୍‌ସା ବେକେ ଜାଣ୍ଡେ ପାଙ୍ଗ୍‌ନେ ଲେଃଗେ ନାନେ ମେଁନେ ଆତେନ୍‌ ରେମୁଆଁ ଲେଃ ନେନେ ଆରି ବିନ୍‌ଣ୍ଡ୍ରେକେ ନେଉର୍‍ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK7_21","072_7_21","LUK","7","21","21","ଆତେନ୍‌ ବେଲା ଜିସୁ ଜାବର୍ ରେମୁଆଁଇଂକେ ରଗ୍‌ ଆରି ଦୁଷ୍ଟ ଆତ୍ମାଇଂନ୍ନିଆ ବାନ୍ ନିମାଣ୍ଡା ଆଡିଙ୍କେ ଆରି ଉଡ଼ି କାନାକେ ମୁଆଃ ଆକେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_22","072_7_22","LUK","7","22","22","ଜିସୁ ସିସ୍ଇଂକେ ଉତର୍ ବିକେ ପେଇଂ ୱେଚେ ମେଁ ମେଁନେ ପେକେକେ ଆରି ପେଅଁକେ ଆତେନ୍‌ ସାପା ଜହନ୍‌କେ ଆଃଅଁପା; କାନାଣ୍ଡ୍ରେଇଂ ଉମୁଁଆ ଆର୍‌କେ ଚଟାଇଂ ଅଲେଙ୍ଗ୍‍ ଡିଙ୍ଗ୍‌ଆର୍କେ; କୁଷ୍ଟରଗି‍ଇଂ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ଆର୍କେ ବ‍ଇରା ରେମୁଆଁଇଂ ଅଁ ଡିଙ୍ଗ୍ ଆର୍‌କେ ଗୁଏକ୍ନେ ରେମୁଆଁଇଂ ଆରି ମୁଇଂତର୍ ଜିବନ୍‍ ବିକେ ଗରିବ୍‍ ରେମୁଆଁଇଂକେ ନିମାଣ୍ଡା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_23","072_7_23","LUK","7","23","23","ମୁଡ଼ି ରେମୁଆଁ ନେଙ୍ଗ୍‌ନେ ବିସୟ୍‌ରେ ସନ୍ଦେଅ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ମେଁ ଦନ୍ୟ । ");
INSERT INTO gaq_vpl VALUES ("LK7_24","072_7_24","LUK","7","24","24","ଜହନ୍‌ନେ ସିସ୍ଇଂ ୱିଗ୍ ଡାଲା ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ରେମୁଆଁଇଂକେ ଜହନ୍‌ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‍ ନ୍‍ସା ମୁଲେକେ ପେଇଂ ବାଲିଲନ୍ନିଆ ମେଁନେ କେନ୍‍ସା ୱେପେଲେକେ ? ମେଁନେ ୱେଡ଼ିଆନେ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ମୁଇଂ ଗାଆଁ ସ୍ଲା ? ");
INSERT INTO gaq_vpl VALUES ("LK7_25","072_7_25","LUK","7","25","25","ଆତେନ୍‌ ଣ୍ଡୁଲା ପେଇଂ ଆଜାକେ କେନ୍‍ସା ତାର୍ ୱେପେଲେକେ ? ମେଃନେ ଦାମିକା ସକା ସଲେଃକ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁକେ ? କେଲାପା ଜାଣ୍ଡେଇଂ ଦାମିକା ସକା ସଃଲେକ୍ନେ ପେକେଏ ଆରି ଦୁକ୍ କଷ୍ଟ ଡିଙ୍ଗ୍‌ଚେ ପାରାନ୍‌ କାଟେଆର୍‍ଏ ମେଇଂ ମେଁନେ କିକେ ନ୍‌ସା ମେଇଂ ଇଃସାଙ୍ଗ୍‌ଇଂନେ ଡୁଆ ଅରିଆ ଲେଃଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK7_26","072_7_26","LUK","7","26","26","ଆନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ଆତେନ୍‌ ଣ୍ଡୁଲା ମେଁନେ କିକେ ନ୍‌ସା ତାର୍‌ଚେ ୱେପେଲେଗେ ? ମେଁନେ ମୁଇଙ୍ଗ୍ ବାବବାଦିକେ ? ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଂକେ ବାବବାଦୀ ବାନ୍ ଜାବର୍ ମ୍ନାଲେ ରେମୁଆଁକେ ? ");
INSERT INTO gaq_vpl VALUES ("LK7_27","072_7_27","LUK","7","27","27","ଯହନ୍‍ ବିସୟ୍‌ରେ ଆକେନ୍ ଦର୍ମ ସାସ୍ତର୍‌ନିଆ ଗୁଆର୍‍ ବକେ ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‌କେ, “କେଲାପା ନେଙ୍ଗ୍‍ ପେନେ ସେନୁଗ୍‍ ନେଙ୍ଗ୍‌ନେ ଦୁତ୍‍କେ ବେନେଡିଙ୍ଗ୍‍କେ ମେଁ ପେ ନ୍‍ସା ଗାଲି ଆରେଏ ଆକେନ୍ ଆତେନ୍‌ ରେମୁଆଁ ଜହନ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("LK7_28","072_7_28","LUK","7","28","28","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ସେଲାମ୍ବୟ୍‍ ଣ୍ଡିଆ କୁମାଲା ଡିଗ୍ ଜହନ୍‌ ବାନ୍ ମ୍ନା ଜାଣ୍ଡେ ଣ୍ଡୁ ତେଲା ଜାଣ୍ଡେ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ସାପାବାନ୍‍ ଡାଆଁ ମେଁ ଡିଗ୍ ଜହନ୍‌ବାନ୍ ମ୍ନା ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_29","072_7_29","LUK","7","29","29","ଜାଣ୍ଡେଇଂ ଆକେନ୍ ସାପା ସାମୁଆଁ ଅଁଡିଙ୍ଗ୍‌ ଆର୍‌କେ ମେଇଂ ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେଇଂ ଇସ୍‌ପର୍‌ନେ ଗୁଲୁଏ ଦାବି ସାପା ବର୍‌ତି ଆଃଡିଙ୍ଗ୍‌ଚେ ଜହନ୍‌ବାନ୍‍ ଡୁବନ୍ ଡୁଂୱେ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_30","072_7_30","LUK","7","30","30","ଡାଗ୍ଲା ପାରୁସି ଆରି ଦର୍ମ ଗୁରୁଇଂ ମେଁଇଂନେ ପାରାନ୍‌ ନ୍‌ସା ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ ମାନେଚେ ଜହନ୍‌ନେବାନ୍ ଡୁବନ୍ ଡୁଂଆଡଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_31","072_7_31","LUK","7","31","31","ଜିସୁ ଆରି ବାସଙ୍ଗ୍‌କେ ତେଲା ନେଙ୍ଗ୍ ଜା ଏତେ ଏଃକେନେ ଙ୍ଗିର୍‍ବଏନେ ଏତେ ସମାନ୍ ଡିଙ୍ଗ୍‌ଏ ଆରି ମେଇଂ ଜାନେ ସମାନ୍ ଣ୍ତିଙ୍ଗ୍‌ଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK7_32","072_7_32","LUK","7","32","32","ମୁଃଡ଼ି ଗଡ଼େଅଇଂ ସାନ୍ତାନ୍ନିଆ କଚେ ନିଜେ ନିଜେକେ ୱାଚେ ବାସଙ୍ଗ୍ଏ ନେ ପେଇଂନେ ଡାଗ୍ରା ବାଉଁସି ନେପିଃକେ ପେ ପେୱାକେ ଣ୍ଡୁ; ନେଁ ଦୁକ୍‌ନେ ଅସ୍‌ମାର୍ ନେସାର୍‌କେ ପେଇଂ ପେଅଁକେ ଣ୍ଡୁ ମେଇଂ ଆତେନ୍‌‌ ଗଡ଼େଇଙ୍ଗ୍ ସୁଗା । ");
INSERT INTO gaq_vpl VALUES ("LK7_33","072_7_33","LUK","7","33","33","ଡୁବନ୍‌ ବିଃଣ୍ଡ୍ରେ ଜହନ୍‌ ପାଙ୍ଗ୍‌ଚେ ରୁଟି ଆଚଙ୍ଗ୍‌କେ ଣ୍ଡୁ ଆରି ଅଙ୍ଗୁର୍ ରସ୍ ଆଉଗ୍‌କେ ଣ୍ଡୁ ଆରି ନାନେ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ ଜହନ୍‌କେ ବୁତ୍‌ ସାଃଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_34","072_7_34","LUK","7","34","34","ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ଚେ ଚଙ୍ଗ୍‌କେ ବାରି ପେଇଂ ବାସଙ୍ଗ୍‌ ପେଡିଂକେ କେଲାପା କ୍ମେ ମୁଇଂ ମ୍ନା ସୁଲୁଏଃ ବାରି ଉଗ୍‌ସାଣ୍ଡ୍ରେ । ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେ ବାରି ପାପିଇଂନେ ରେମୁଆଁଣ୍ଡେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_35","072_7_35","LUK","7","35","35","ଜାଣ୍ଡେଇଂ ଇସ୍‌ପର୍‌ନେ ଜ୍ଞାନ୍‍କେ ସାଃଆର୍‌ଏ ମେଁଇଂନେ ଜିବନ୍‍ନ୍ନିଆ ମେଁନେ ସତ୍ ଆକେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK7_36","072_7_36","LUK","7","36","36","ଆରି ପାରୁସିଇଂ ବାନ୍ ମୁଇଂଜା ଜିସୁକେ ଚଙ୍ଗ୍‌ନେସା ୱାଆର୍କେ । ଆତ୍ ଅରିଆ ପାରୁସି‍ଇଂନେ ଡୁଆନ୍ନିଆ ଗାଚେ ଚୁଚଙ୍ଗ୍‍ନିଆ କ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_37","072_7_37","LUK","7","37","37","ଆରି କେଲାପା ଆତେନ୍‌ ଇନିନ୍ନିଆ ମୁଇଙ୍ଗ୍ ପାପିଷ୍ଟ ସେଲାମ୍ବୁଏ ଲେଃଗେ ଜିସୁ ଆତେନ୍‌ ପାରୁସିଇଂନେ ଡୁଆନ୍ନିଆ ଚଙ୍ଗ୍‍ନ୍ନିଆ କଲେକେ ଆକେନ୍ ମ୍ୟାଚେ ମେଁ ମୁଇଙ୍ଗ୍ ମୁତାନ୍ନିଆ ବାସ୍ନା ଚୁ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK7_38","072_7_38","LUK","7","38","38","ପ୍ଲା ପାକା ମେଁନେ ଞ୍ଚ ବୁନ୍ଦେ ତୁଆଁଚେ ଅଃନେ ବେଲା ମେଁନେ ଡେମୁଆଁ ଏତେ ମେଁନେ ଞ୍ଚ ଗ୍ୱେଡ଼ିଆ ବିଃକେ ମେଁନେ ବାଆଃନେ ଉଗ୍‌ବ ଏତେ ଜିସୁନେ ଞ୍ଚ ଚୁଃବିଗେ ଆରି ଜିସୁନେ ଞ୍ଚ ବୈନ୍ତାକେ ଆରି ଆତେନ୍‌ ବାସ୍ନା ଚୁ ଆବଗ୍‍ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_39","072_7_39","LUK","7","39","39","ଆତେନ୍‌ କେଚେ ମୁଡ଼ି ପାରୁସିଇଂ ଜିସୁକେ ୱାବଗେ ମେଁ ମନେ ମନେ ବାସଙ୍ଗ୍‌କେ “ଏନ୍‍ ରେମୁଆଁ ଜଦି ବାବବାଦି ଡିଙ୍ଗ୍ ପାଲେ ତେଲା ଆକ୍‌ମେକେ ଜା ଲିଗ୍‍ଡିଙ୍ଗ୍‍କେ ମେଁ ଜାଣ୍ଡେ ଆରି ଡିରକମ୍‍ନେ ସେଲାମ୍ବୟ୍‍ ମେଁ ଜେ ପାପିସ୍ଟ ଏନ୍‍ ପାମ୍ୟାଃ ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_40","072_7_40","LUK","7","40","40","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ “ଶିମୋନ ଆନାକେ ନେଙ୍ଗ୍‍ନେ ମେଃନେ ଡିଗ୍ ବାସଙ୍ଗ୍‌ ଲେଃକେ ।” ଶିମୋନ୍ ବାସଙ୍ଗ୍‌କେ “ବାସଙ୍ଗ୍‌ ଗୁରୁ !” ");
INSERT INTO gaq_vpl VALUES ("LK7_41","072_7_41","LUK","7","41","41","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ମୁଇଙ୍ଗ୍ ମ୍ନା ସାଉକାର୍ ନ୍ନିଆ ମ୍ବାୟା ଉଦାର୍ ଲେଃଗେ ମୁଇଂଜା ମାଲ୍‍ସ ଟାଆଁ ଡାବୁ ବାରି ମୁଇଂଜା ମ୍ବାର୍‍କୁଡ଼ି ଗୁଆଟାଆଁ ଉଦାର୍ ଡିଙ୍ଗ୍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_42","072_7_42","LUK","7","42","42","ଉଦାର୍ ସୁଜେନେସା ମେଁଇଂନେ ମେଃଡିଗ୍ ଣ୍ଡୁଲା ଆତେନ୍‌ ମ୍ବାୟାନେ ଉଦାର୍ ସାକାର୍‌ ଆନ୍ତାର୍ ବିଃକେ । ତେଲା ମେଁଇଂନେ ମ୍ବାୟା ବିତ୍ରେ ଜାଣ୍ଡେ ସାକାର୍‌କେ ଜାବର୍ ଆଲାଦ୍ ଆଃସୁଏଃଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK7_43","072_7_43","LUK","7","43","43","ଶିମୋନ୍‍ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଏତେ ଣ୍ଡିଙ୍ଗ୍‍କେ ସାକାର୍‍ ଆଜାକେ ଜାବର୍ ରୁନ୍‌ ଆନ୍ତାର୍‍ ବିଃକେ ଆତେନ୍‌ ରେମୁଆଁକେ ଜାବର୍ ସାହା ଡିଙ୍ଗ୍‌ଏ ।” ଜିସୁ ଶିମୋନ୍‍କେ ବାସଙ୍ଗ୍‌କେ “ନାଁ ସମାନ୍ ବାସଙ୍ଗ୍‍ନାବ ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_44","072_7_44","LUK","7","44","44","ଆରି ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ପାକା ତାମୁଚେ ଶିମୋନ୍‍କେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ସେଲାମ୍ବୁଏକେ କିକେନାଡିଙ୍ଗ୍‍ ? ନେଙ୍ଗ୍ ନାଁନେ ଡୁଆ ମ୍ପାକେ ପେ ନେଙ୍ଗ୍ ଞ୍ଚ ଗ୍ୱେଡ଼ିଆ ନ୍‌ସା ଣ୍ଡିଆ ନାବିକେ ଣ୍ଡୁ ମାତର୍‌ ଆକ୍‌ମେଁ ଡେମୁଆଁ ଏତେ ନେଙ୍ଗ୍‌ନେ ଞ୍ଚ ଗ୍ୱେଡ଼ିଆଚେ ମେଁନେ ଉଗ୍‌ବ ଏତେ ଚୁଃବିଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_45","072_7_45","LUK","7","45","45","ନାଁ ଆନେଙ୍ଗ୍ ବୈନ୍ତାଚେ ନାୱାକେ ଣ୍ଡୁ ମାତର୍‌ ଉଡ଼ି ବେଲା ବାନ୍ ନେଙ୍ଗ୍‍ ବିତ୍ରେ ଙ୍ଗାକେ ଆତେନ୍‌ ବେଲା ବାନ୍ ଏ ଜାକ ମେଁ ନେଙ୍ଗ୍‍ନେ ଞ୍ଚନିଆ ବୈନ୍ତା ବିଃନେ ଙ୍କାରେ ଡିଡା । ");
INSERT INTO gaq_vpl VALUES ("LK7_46","072_7_46","LUK","7","46","46","ନା ନେଙ୍ଗ୍‌ନେ ବାଆଃନ୍ନିଆ ଞ୍ଚୁ ନାଲାଗେକେ ଣ୍ଡୁ ମାତର୍‌ କିମେ ନିଙ୍ଗ୍‍ନେ ଞ୍ଚନିଆ ବାସ୍‍ନା ଞ୍ଚୁ ଲିଗ୍‌ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK7_47","072_7_47","LUK","7","47","47","ନେଙ୍ଗ୍‍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ କ୍ମେନେ ଜାବର୍ ପାପ୍ କେମା ଡିଙ୍ଗ୍ ଲେଃକେ ଡାଗ୍ଲା ମେଁ ଜାବର୍ ଆଲାଦ୍ ଡିଂଡିଂକେ; ମାତର୍‌ ଆଜାକେ ଇକୁଡ଼ା କେମା ବିଏ ମେଁ ଇକୁଡ଼ା ଆଲାଦ୍ ଡିଂଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_48","072_7_48","LUK","7","48","48","ଆରି ଜିସୁ ଆତେନ୍‌ ସେଲାମ୍ବୟ୍‍କେ ବାସଙ୍ଗ୍‌କେ “ନାଁନେ ସାପା ପାପ୍ କେମା ଡିଙ୍ଗ୍ ୱେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK7_49","072_7_49","LUK","7","49","49","ଆତ୍‍ ଅରିଆ ଜିସୁ ଏତେ ଚୁଚଙ୍ଗ୍‌ନିଆ କ ଲେଃକ୍ନେ ରେମୁଆଁଇଂ ମେଇଂମେଇଂ ଅବାଃଲିର୍‌ଆର୍‌କେ, “ଏନ୍ ଜାଣ୍ଡେ ? ଜେ ପାପ୍ ସାପା କେମା ଡିଗ୍ ଡିଂୟାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK7_50","072_7_50","LUK","7","50","50","ଡାଗ୍ଲା ଜିସୁ ଆତେନ୍‌ ସେଲାମ୍ବୟ୍‍କେ ବାସଙ୍ଗ୍‌କେ “ନାଁନେ ସତ୍ ନାମାନେକ୍ନେ ଆନା ରକ୍ୟା ଡିଙ୍ଗ୍‌ଣ୍ଡିଂ; ସାନ୍ତିରେ ୱିଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_1","072_8_1","LUK","8","1","1","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଇନି ଇନି ଅଲେଙ୍ଗ୍‌ଚେ ଇସ୍‌ପର୍ ରାଜିନେ ନିମାଣ୍ତା ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌କେ ବାରି ଗମ୍ବାର୍ ସିସ୍‌‍ଇଂ ମେଁନେ ଏତେ ଲେଃଗେ ");
INSERT INTO gaq_vpl VALUES ("LK8_2","072_8_2","LUK","8","2","2","ଆରି ମୁଡ଼ି ସେଲାମ୍ବୁଏଃଇଂ ବାନ୍ ଦଦ୍ୟା‌ ଆତ୍ମା ଆନ୍ତାର୍ ବିଃବକେ ମେଇଂ ଡିଗ୍ ମେଁଇଂନେ ଏତେ ଲେଃକେ । ଆରି ଆଣ୍ତିନେ ସେଲାମ୍ବୁଏଇଂ ରଗ୍‌ବାନ୍‍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ଲେ ଆର୍‌କେ ମେଇଂ ଡିଗ୍ ମେଇଂ ଏତେ ଲେଃଆର୍‌କେ, ମରିୟମ୍ ଜାଣ୍ତେନେ ମ୍ନି ମଗ୍‌ଦଲୀନି ମରିୟମ୍‌ ଡାଗ୍‌ମ୍ୟାଃକେ ଜାଣ୍ଡେ ବାନ୍ ତ୍ମାକ୍ଲିଗ୍ ଗଲିଆ ଆନ୍ତାର୍ ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_3","072_8_3","LUK","8","3","3","ହେରୋଦନେ ଗୁମୁସ୍ତା ଖୂଜାନେ କୁନେଣ୍ଡେ ଯୋହାନା, ଶୋଶନ୍ନା ଆରି ଉଡ଼ି ସେଲାମ୍ବୁଏଇଂ ମେଇଂ ଏତେ ଲେଃଚେ ନିଜେ ନିଜେନେ ଦନ୍ ବିଚେ ମେଁଇଂନେ ସେବା ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_4","072_8_4","LUK","8","4","4","ଗୁଲୁଏ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ରିସିଙ୍ଗ୍‍ ଆର୍କେ ଆରି ସାପା ଇନିନେ ରେମୁଆଁ ଜିସୁନ୍ନିଆ ପାଙ୍ଗ୍‌କେ ଜିସୁ ଆମେଇଂକେ ଏନ୍ ଉସ୍ରା ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_5","072_8_5","LUK","8","5","5","ମୁଇଂ ରେମୁଆଁ ବିଗ୍‌ଣ୍ଡ୍ରେ ନିଜେନେ ଚ୍ମୁଜା ବିଗ୍‍ନେ ତାର୍‌କେ । ମେଁ ଲିଜନ୍ନିଆ ଚୁମୁଜା ବିଗ୍‌ନେ ବେଲା ଉଡ଼ି ଚୁମୁଜା ଗାଲିନ୍ନିଆ ଲଃକେ ଆରି ଞ୍ଚବୁନ୍ଦେ ମୁଲିୱେଗେ ବାରି ଆଡ଼ାତ୍ରାନେ ପ୍ଲିଗ୍‍ଇଂ ଆତେନ୍‌ ଚ୍ମୁଜାକେ ଚଙ୍ଗ୍‌ବିଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_6","072_8_6","LUK","8","6","6","ଆରି ଉଡ଼ିକ୍ଲିଗ୍ ବ୍ରି ଆଡ଼ାତ୍ରା ଲଃକେ ବାରି ପଡ଼୍ୟାଚେ ଣ୍ଡିଆଃ ଆବାକେସାଃ ନ୍‌ସୁଆର୍‌ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_7","072_8_7","LUK","8","7","7","ଆରି ଉଡ଼ିକ୍ଲିଗ୍‌ ଗ୍ରେଃ ସ୍ଲାଃଇଂନେ ମଜେ ଲଃକେ ବାରି, ଗ୍ରେଃ ସ୍ଲାଃଇଂ ତଡ଼ିଆଚେ ଜିଆ ଜିଆ ମ୍ନା ଡିଂଚେ ଆତେନ୍‌‌ଇଂକେ ଚାପେ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_8","072_8_8","LUK","8","8","8","ଆରି ଉଡ଼ି ନିମାଣ୍ଡା ତୁବନ୍ନିଆ ଲଃକେ ବାରି ମ୍ନାଚେ ମାଲ୍‌କୁଡ଼ି ଚୁଏ । ଜିସୁ ଏନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ “ଜାଣ୍ତେନେ ଦ୍ରିଗ୍ ନ୍‌ସା ନ୍‌ଲୁଗ୍ ଲେଃକେ ମେଁ ଦ୍ରିଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_9","072_8_9","LUK","8","9","9","ମେଁନେ ସିସ୍‌ଇଂ ଜିସୁକେ ଉଃସ୍ରାନେ ଅର୍‌ତ ମେଁନେ ଡାଗ୍‌ଚେ ସାଲିଆକୁ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_10","072_8_10","LUK","8","10","10","ମେଁ ଉତର୍ ବିକେ “ଇସ୍‌ପର୍‌ନେ ରାଜିନେ ଗୁନ୍‌ ବୁଜେନ୍‌ସା ଆପେକେ ବପୁ ବିଃବକେ, ମାତର୍‌‌ ବିନ୍‌ନେ ସାପାରେ ନ୍‌ସା ଆତାନ୍‌ ମାତର୍‌‌ ଉଦା‍ଅରନ୍ ଡିଙ୍ଗ୍‌ଚେ ଲେଃୱେଏ । ଇଡ଼ିଙ୍ଗ୍‌ ମେଇଂ କିକେ ଲେଃଆର୍‌ଏ ମାତର୍‌ କିକେ ଆୟା ଆର୍‌ ଣ୍ତୁ ଅଁଚେ ବୁଜେ ଆୟା ଆର୍‌ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_11","072_8_11","LUK","8","11","11","ଏନ୍ ଉସ୍ରା ଡାଗ୍ଲା ଚ୍ମୁଜା, ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("LK8_12","072_8_12","LUK","8","12","12","ଆରି ଗାଲିବ ବିଗ୍‌କ୍ନେ ଚ୍ମୁଜା ରକମ୍ ଦେକ୍ ରକମ୍ ରେମୁଆଁଇଂକେ ବୁଜେଏ ଆକ୍‌ମେଇଂ ସାମୁଆଁ ଅଁ ଆର୍‌ଏ, ଇଡ଼ିଙ୍ଗ୍ ସ‍ଏତାନ୍‌ ପାଙ୍ଗ୍‌ଚେ ଡିରକମ୍ ମେଇଂ ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଚେ ରକ୍ୟା ଆବାଆର୍‌ ଣ୍ତୁ, ଆକେନ୍‌ସା ମେଇଂ ମନେବାନ୍ ସାମୁଆଁ ଡୁଙ୍ଗ୍‌ଡ‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK8_13","072_8_13","LUK","8","13","13","ବାରି ନିମାଣ୍ଡାଃ ତୁବଃନ୍ନିଆ ବିଗ୍‌କ୍ନେ ଚ୍ମୁଜା ରକମ୍ ଆକ୍‌ମେଇଂ ସାମୁଆଁ ଅଁ ଆର୍‌ଏ ସାର୍ଦାରେ ସାଃଆର୍‌ଏ ଡାଗ୍ଲା ମେଁଇଂନେ ଚେର୍‌ ବିତ୍ରେ ଜାକ ୱେ ଆଲେଃଲା ମେଇଂ ଇକୁଡ଼ା ବେଲା ଜାକ ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍ ଆରେ ବାରି ପରିକ୍ୟା ପାଙ୍ଗ୍‌ଲା ମେଇଂ ବିସ୍‌ବାସ୍ ଆନ୍ତାର୍‍ ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK8_14","072_8_14","LUK","8","14","14","ଗ୍ରେ ସ୍ଲା ଆଣ୍ଡେଙ୍ଗ୍ ଅରିଆ ଲଃଲେଃକ୍ନେ ଚ୍ମୁ ଦେକ୍ ରକମ୍ ରେମୁଆଁଇଂକେ ବୁଜେଏ ଜାଣ୍ଡେଇଂ ସାମୁଆଁ ଅଁ ଆରେ ମାତର୍‌‌ ସଂସାର୍‌ନେ ଚିନ୍ତା ଦନ୍ ଆରି ସୁକ୍‌ରେ ଲେଃଚେ ଜିବନ୍‌ କାଟେ କାଟେ ମିଗ୍‌ ୱେଆର୍‌ଏ ବାରି ନିମାଣ୍ତା ଚୁଚୁ ଆବାଆର୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK8_15","072_8_15","LUK","8","15","15","ଆଣ୍ଡିନେ ଲିଜ ନିମାଣ୍ଡାନେ ତୁବନ୍ନିଆ ଲଃକେ ଆରି ନିମାଣ୍ଡା ତୁବନିଆ ଉଡ଼ି ଲଃକେ ଦେକ୍‌ରକମ୍ ରେମୁଆଁଇଂ ବୁଜେଏ ଜାଣ୍ଡେଇଂ ପର୍‍ମେସର୍‍ନେ ସାମୁଆଁ ପର୍‌ଚଲ୍‌ ଆରି ପବିତ୍ର ମନ୍ ବିତ୍ରେ ଅଁ ଆର୍‌ଏ କାମ୍ ପଡ଼େଲା ପାଲେଆର୍‍ଏ ଆରି ତ୍ମିନେ ଚୁଏ । ");
INSERT INTO gaq_vpl VALUES ("LK8_16","072_8_16","LUK","8","16","16","ଜା କୁପିସ ଆଃଡୁଆଚେ ଆମେକେ ମୁତା ଆଲ ଡିଡାଚେ ଆବ ଣ୍ଡୁ ଣ୍ଡୁଲା କଟ୍ ଆଲ ଆବ ଣ୍ଡୁ ମାତର୍‌ ମେଁ ଆତେନ୍‌‌କେ କୁପିସ ବନେ ନ୍ତୁଗ୍‌ ଆଡ଼ାତ୍ରା ବଆର୍‌ଏ ଡେତ୍‌ଲା ଡୁଆ ବିତ୍ରେ ଗାଣ୍ଡ୍ରେ ତାର୍‌କିଗ୍ କେୟାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK8_17","072_8_17","LUK","8","17","17","“ମେଁନେ ସାପା ବୁଃଡ଼ି ବଆର୍‌କେ ଆତେନ୍‌‌ ସାପାରେନେ ଡାଗ୍ରା ଡାଗ୍ଲା ମେଃନେ ସାପା ଆବାସଙ୍ଗ୍‍ ଣ୍ଡୁ ଦେକ୍‌ରକମ୍ ବିସୟ୍ ମେଃ ଣ୍ଡୁ ଣ୍ଡୁଲା ମେଃନେ ସାପା ମା‍ଅଁଚେ ବାସଙ୍ଗ୍‌କ୍ନେ ଆଅବା ଣ୍ଡୁ ଦେକ୍‌ରକମ୍ ବୁଡ଼ିଲେଃକ୍ନେ ସାମୁଆଁ ମେଁ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_18","072_8_18","LUK","8","18","18","“ପେଇଂ ଡିରକମ୍ ଅଁପେଡିଂ ଆତେନ୍‌‍ସା ବିସୟ୍‌ରେ ତରକ୍ ଲାଲାପା ମେଃନ୍‌ସା ଡାଗ୍ଲା ଜାନେ ଲେଃକେ ଆମେକେ ଜାବର୍ ମ୍ବିଏ ଆରି ଜାନେ ଣ୍ଡୁ ମେଁ ନିଜେନେ ଲେଃକେ ଡାଗ୍‌ଚେ ଏତେ ଲେଃଏ ମେଁବାନ୍‍ ଡୁଙ୍ଗ୍‍ ୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_19","072_8_19","LUK","8","19","19","ଜିସୁନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆରି ବୟାଁଣ୍ଡେଇଂ ଆମେକେ କେନ୍‌ସା ପାଙ୍ଗ୍ ଆର୍‌କେ ମାତର୍‌ ରେମୁଆଁଇଂ ଜାବର୍ ଗହଲି ଲେଃଲା ମେଁ ଏତେ ଡାଗ୍ରା ୱେଏ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK8_20","072_8_20","LUK","8","20","20","ଜାଣ୍ଡେ ମୁଇଙ୍ଗ୍ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ “କେଲା ପିୟାଙ୍ଗ୍‍ ବାରି ପେନାଙ୍ଗ୍‍ ନାନେ ଏତେ ଆସୁଏ ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଚେ ବାଏରେ ତୁଆଁ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_21","072_8_21","LUK","8","21","21","ମାତର୍‌ ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ “ଜାଣ୍ଡେ ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ ଅଁଏ ଆରି ସତ୍‍ ମାନେଃଆର୍‍ଏ ମେଇଂ ନେଙ୍ଗ୍‌ନେ ଇୟାଙ୍ଗ୍ ବାରି ବୟାଁଇଂ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_22","072_8_22","LUK","8","22","22","ଆତେନ୍‌ ବେଲା ମେଃସୁଆ ଜିସୁ ଆରି ମେଁନେ ସିସ୍ଇଂ ମୁଇଙ୍ଗ୍ ତରାଅରିଆ କକେ ଆରି ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଏଲାପା କେଣ୍ଡିଆ ଇନୁ ମେତାଃ ନେୱେପା । ଆତ୍‍ ଅରିଆ ସିସ୍ଇଂ ତରା ତଃ ବିଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_23","072_8_23","LUK","8","23","23","ମାତର୍‌ ମେଇଂ ତରା ୱେନେ ବେଲା ଜିସୁ ଡୁଲେଗ୍‍ ଲେଃଗେ । ଆତେନ୍‌ ବେଲା କେଣ୍ଡିଆନ୍ନିଆ ୱେଡ଼ିଆ ଗୁରିୟା ପାଙ୍କେ ଆରି ମେଁଇଂନେ ତରାନିଆ ଣ୍ଡିଆ ଗିଃଗାଃନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_24","072_8_24","LUK","8","24","24","ଅଃତେନ୍‍ ବେଲା ସିସ୍‌ଇଂ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଆମେକେ ଆତଡ଼ିଆଚେ ବାସଙ୍ଗ୍‌କେ “ଏ ଗୁରୁ ଏ ଗୁରୁ ନେ ନେଗୁଏଃଗେ ।” ଅଃତେନ୍‍ ବେଲା ଜିସୁ ତଡ଼ିଆଚେ ୱେଡ଼ିଆ ଗୁରିୟାକେ ଦମ୍‌କା ବିକେ ଆରି ଆତେନ୍‌ ସାପା ୱେଡ଼ିଆ ଗୁରିୟା ବନ୍ଦ୍ ଆଡିଙ୍ଗ୍ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_25","072_8_25","LUK","8","25","25","ଆରି ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂନେ ସତ୍ ମାନେକ୍ନେ ଆଣ୍ଡିକା ? ମାତର୍‌ ମେଇଂ ବୁଟ ଡିଙ୍ଗ୍ ଆର୍‌ଗେ ଆରି ଇରିଆଃତୁଗ୍‍ ଲେଃଆର୍‌ଗେ ମେଁ ଆମେଇଂକେ ଆଃ ବାଲିର୍‌ବାତା ଆର୍କେ ।” ଆକେନ୍ ରେମୁଆଁ ଜାଣ୍ଡେ ଚେଃ ମେଁ ୱେଡ଼ିୟା ଆରି ଣ୍ଡିଆକେ ଡିଗ୍ ଆଦେସ୍ ବିଏ ମେଇଂ ମେଁନେ ସାମୁଆଁ ସାଃଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK8_26","072_8_26","LUK","8","26","26","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆରି ମେଁନେ ସିସ୍‌ଇଂ ଗାଲିଲୀନେ କେଣ୍ଡିଆ ଇନୁ ମେତାଃ ୱେଗେ । ମେଇଂ ଗରାଶୀୟ ଏରିଆ ନ୍ନିଆ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_27","072_8_27","LUK","8","27","27","ଜିସୁ ତରାବାନ୍ ତାର୍‍ଚେ କେଣ୍ଡିଆ ଆଡ଼ା ଜାର୍‌ନେ ବେଲା ଆତେନ୍‌ ଇନିନେ ମୁଇଙ୍ଗ୍ ଗଲିଆ ସାଲେଃକ୍ନେ ରେମୁଆଁ ଆମେକେ ଅବାକେ; ମେଁ ଅସେବାନ୍ ପାଟାଇ ମାସଚେ ଆରି ଡୁଆ ମାଲେଚେ ରାଃଚ୍ୟା ଲେଃଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_28","072_8_28","LUK","8","28","28","ମେଁ ଜିସୁକେ କେଚେ କିରଚେ ମେଁନେ ଞ୍ଚ ବୁନ୍ଦେ ଲଃଚେ ଜବର୍ ସାରଚେ ବାସଙ୍ଗ୍‌କେ “ଏ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଜିସୁ ନା ଏତେ ନେଙ୍ଗ୍‌ନେ ମେଁନେ ଲେଃକେ ? ନେଙ୍ଗ୍ ଆନାକେ ସାର୍‌ଲଣ୍ଡିଂକେ । ଆନିଂକେ କଷ୍ଟ ଆବିଗେ ନାମଃ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_29","072_8_29","LUK","8","29","29","ଡାଗ୍ଲା ଜିସୁ ଆତେନ୍‌ ଗଲିଆକେ ଆତେନ୍‌ ରେମୁଆଁ ବାନ୍ ତାର୍ ୱେନ୍‌ସା ଆଦେସ୍ ବିବଗେ । ଆତେନ୍‌ ଗଲିଆ ଉଡ଼ିତର୍ ଆମେକେ ସାଲେଗେ ଆରି ରେମୁଆଁ ଆମେକେ ନ୍ତିନିଆ ଞ୍ଚନିଆ ଗାଗ୍‌ଚେ ବଆର୍‌ଗେ ମାତର୍‌ ମେଁ ଗାଗ୍‌କ୍ନେ ଚିକ୍ଲି ଆଃତେଗ୍‌ଚିଚେ ରେମୁଆଁ ଆଲେଃକ୍ନେ ଟାନ୍‌ନିଆ ସେଆଁରେ ଆମେକେ ଆଃଅଲେଙ୍ଗ୍ ଡୁଙ୍ଗ୍‍ ୱେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_30","072_8_30","LUK","8","30","30","ଜିସୁ ଆମେକେ ସାଲିଆକୁକେ, “ନାନେ ମ୍ନି ମେଃନେ ?” ମେଁ ବାସଙ୍ଗ୍‌କେ, “ନିଂନେ ମ୍ନି ‘ବାହିନୀ,’” ଡାଗ୍ଲା ମେଁ ଡାଗ୍ରା ଗୁଲେ ସେଆଁରେ ଗାଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_31","072_8_31","LUK","8","31","31","ଆରି ମେଁ ଡିରକମ୍ ଆମେଇଂକେ ପାତାଲ୍‌ପୁର୍ ୱେନ୍‌ସା ଆବିଲେ ଆତେନ୍‌‍ସା ମେଇଂ ଆମେକେ ଜବର୍‍ଜସ୍ତି ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_32","072_8_32","LUK","8","32","32","ଆତେନ୍‌ କଣ୍ଡା ଡାଗ୍ରା ମୁଇଙ୍ଗ୍ ମ୍ନା ଗୁବୁଗ୍‍ଇଂ ତୁର୍‍ତ୍ୟା ଡିଙ୍ଗେ ଆରି ମେଁ ଡିରକମ୍ ଆମେଇଂକେ ଆତେନ୍‌ ଗୁବୁଗ୍‍ନେ ଗାଗ୍‍ଡେ ଗାନ୍‍ସା ଆଦେସ୍ ବିକେ ଆକେନ୍‌ସା ମେଇଂ ଆମେକେ ଜବର୍‍ଜସ୍ତି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_33","072_8_33","LUK","8","33","33","ଜିସୁ ଆମେକେ ଆଦେସ୍ ବିଲା ସେଆଁରେ ଆତେନ୍‌ ରେମୁଆଁ ବାନ୍ ତାର୍‌ଚେ ଗୁବୁଗ୍‍ନେ ଗାଗ୍‌ଡ଼େ ଗାକେ; ଆତ୍‍ ଅରିଆ ଗୁବୁଗ୍‍ ଆତେନ୍‌ କଣ୍ଡା ବାନ୍ ୱିର୍‌ ଡୁଂୱେଚେ କେଣ୍ଡିଆନ୍ନିଆ ତେଗ୍‍ଡ୍ୟା ଗୁଏଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_34","072_8_34","LUK","8","34","34","ତୁର୍‍ତ୍ୟା ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁ ଆତେନ୍‌ ଗଟେକ୍ନେ କେଚେ ୱିର୍‌ ଡୁଂୱେଚେ ଇନି ଆରି ବାଏରେ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ଆୱାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_35","072_8_35","LUK","8","35","35","ଆତେନ୍‌ ଅରିଆ ରେମୁଆଁଇଂ ଆତେନ୍‌ ଗଟେକ୍ନେ କେନ୍‍ସା ପାଙ୍ଗ୍ ଆର୍‌କେ ଆରି ମେଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ମୁଡ଼ି ରେମୁଆଁ ବାନ୍ ଗଲିଆଇଂ ତାର୍ ଲେଃଗେ ଆମେକେ ପାଟାଇ ସଚେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌ଚେ ଜିସୁନେ ଞ୍ଚ ବୁନ୍ଦେ କଲେଃକ୍ନେ କେଚେ ବୁଟ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_36","072_8_36","LUK","8","36","36","ଆରି ଜାଣ୍ଡେଇଂ ଏନ୍ ଗଟ୍‌ନା କେଲେଗେ ମେଇଂ ଆତେନ୍‌ ଗଲିଆ ସାଲେଃକ୍ନେ ରେମୁଆଁ ଡିରକମ୍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ସାପା ଆମେଇଂକେ ଆମ୍ୟାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_37","072_8_37","LUK","8","37","37","ଆତ୍‍ ଅରିଆ ଗରାଶୀୟଇଂ ଇନିନେ ସାପା ରେମୁଆଁ ମେଇଂବାନ୍‍ ଆଣ୍ଡେ ୱିଗ୍‌ନ୍‌ସା ଆମେକେ ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍‌ଆର୍କେ ଡାଗ୍ଲା ମେଇଂ ଜାବର୍‌ ବୁଟ ୱେଲେଗେ ଆରି ମୁଇଙ୍ଗ୍ ତରାନ୍ନିଆ ଡେଃଚେ ଜିସୁ ଆଣ୍ଡେ ୱିଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_38","072_8_38","LUK","8","38","38","ମାତର୍‌ ମୁଡ଼ି ରେମୁଆଁ ବାନ୍ ଗଲିଆ ନୁଆଁ ଆନ୍ତାର୍ ବଗେ ମେଁ ଜିସୁ ଏତେ ଲେନେସା ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK8_39","072_8_39","LUK","8","39","39","ମାତର୍‌ ଜିସୁ ଆମେକେ ବେବିଚେ ବାସଙ୍ଗ୍‌କେ, “ନାନେ ଡୁଆ ଆଣ୍ଡେ ୱିଗ୍‌ଲା ଆରି ଇସ୍‌ପର୍ ନାଁ ନ୍‌ସା ମେଁନେ ଡିଙ୍ଗ୍ ବକେ ଆତେନ୍‌ ସାପା ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍ ।” ତେଲା ମେଁ ୱେଚେ ଜିସୁ ମେଃନ୍‌ସା ମେଃନେ ଡିଙ୍ଗ୍ ବଗେ ଆତେନ୍‌ ସାପା ଇନି ଜାକ ବାସଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_40","072_8_40","LUK","8","40","40","ଉଡ଼ିବେଲା ଜିସୁ ଇନୁମେତା ପାଙ୍ଗ୍‌କେ ରେମୁଆଁଇଂ ଆମେକେ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଚେ ସାଃଆର୍‌କେ ଡାଗ୍ଲା ଆମେକେ ସାପାରେ ଉର୍‍ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_41","072_8_41","LUK","8","41","41","ଆରି କେଲା ଜାଇରସ୍ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ପାଙ୍ଗ୍‌କେ ମେଁ ପାର୍‍ତନା ଡୁଆନେ ନେତା ଲେଃଗେ । ମେଁ ଜିସୁନେ ଞ୍ଚ ବୁନ୍ଦେ ଲଃଚେ ମେଁନେ ଡୁଆ ୱେନେସା ଆମେକେ ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_42","072_8_42","LUK","8","42","42","ଡାଗ୍ଲା ଗମ୍ବାର୍ ବୟସ୍‍ନେ ମୁଇଙ୍ଗ୍ ମାତର୍‌ ସେଲା ଲେଃଗେ ଆରି ମେଁ ତେଗୁଏନେ ରକମ୍ ଡିଙ୍ଗ୍‌ଲେଃଗେ । ମାତର୍‌ ଜିସୁ ୱେଡିଙ୍ଗ୍‌ନେ ବେଲା ରେମୁଆଁଇଂ ମେଁ ଆଡ଼ାତ୍ରା ଟେଚା ଡୁଂପାଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_43","072_8_43","LUK","8","43","43","ଆତେନ୍‌ ଗମ୍ବାର୍ ମୁଆଁ ଜାକ ଆବୁଲେ ଡିଙ୍ଗ୍ ଲେଃକ୍ନେ ସେଲାମ୍ବୁଏ ଲେଃଗେ । ଜାଣ୍ଡେ କି ନିଜର୍ ଡାବୁ ଆଃଡାଚେ ଡିଗ୍ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK8_44","072_8_44","LUK","8","44","44","ମେଁ ପ୍ଲା ପାକା ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ପାଟାଇ ଜାଲିପୁଆଃକେ ଲିଗ୍‌କେ ଆରି ମେଁ ଆବୁଲେଃ ଡିଙ୍ଗ୍‌କ୍ନେ ମ୍ୟା ବନ୍ଦ୍‌ ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_45","072_8_45","LUK","8","45","45","ଆତେନ୍‌ ବେଲା ଜିସୁ ସାଲିଆକୁକେ ଜାଣ୍ଡେ ଆନେଙ୍ଗ୍‌କେ ଲିଗ୍‌କେ ? ମାତର୍‌ ସାପାରେ ବାସଙ୍ଗ୍‌କେ ଜେ ମେଇଂ ଆମେକେ ଆଲିଗ୍‍କେ ଣ୍ଡୁ ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ଅଁ ଗୁରୁ ସାପା ରେମୁଆଁ ଟେଚା ଟେଣ୍ଡୁର୍ ଡିଙ୍ଗ୍ ପାଙ୍ଗ୍ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_46","072_8_46","LUK","8","46","46","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଜାଣ୍ଡେ ମୁଇଂଜା ଆନେଙ୍ଗ୍‌କେ ଲିଗ୍‌କେ ଡାଗ୍ଲା ନେଙ୍ଗ୍‍ ବାନ୍ ସକତ୍‌ ତାର୍ ୱେଗେ ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍ ମ୍ୟାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_47","072_8_47","LUK","8","47","47","ଉଡ଼ି ବେଲା ସେଲାମ୍ବୟ୍‍ ରେମୁଆଁ କେକେ ଜେ ମେଁ ବୁଡ଼ି ଲେଃଆୟାକେ ଣ୍ଡୁ ଆତେନ୍‌ ବେଲା ମେଁ ଜୁର୍‍ ଜୁର୍‍ ପାଙ୍ଗ୍‌ଚେ ମେଁନେ ଞ୍ଚ ବୁନ୍ଦେ ଲଃଚେ ଜାଣ୍ଡେ ନାଁ ଆମେକେ ନାଲିଗ୍‍କେ ଆରି ଡିରକମ୍ ପ୍ରେକ୍‌ ଆଃ ନିମାଣ୍ଡା ନାଡିଙ୍ଗ୍‍ ଆତେନ୍‌ ସାପାରେନେ ସାର୍ମୁଆଁ ବାସଙ୍ଗ୍‌ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_48","072_8_48","LUK","8","48","48","ଆତ୍‍ ଅରିଆ ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଅ ସେଲାମ୍ବଃଅ ନାନେ ବିସ୍‌ବାସ୍ ଆନାକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍ ବକେ, ସାନ୍ତିରେ ୱିଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_49","072_8_49","LUK","8","49","49","ମେଁ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ନେ ବେଲା ପାର୍‍ତନା ଡୁଆନେ ନେତା ଜାଇରସ୍ ଡୁଆବାନ୍‍ ମୁଇଂଜା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ନାଁଉଙ୍ଗ୍ ଗୁଏଃ ୱେଗେ ଗୁରୁକେ ଆରି କଷ୍ଟ ଆବିଗେ ନାମଃ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_50","072_8_50","LUK","8","50","50","ମାତର୍‌ ଜିସୁ ଆକେନ୍ ଅଁଚେ ଜାଇରସ୍‌କେ ବାସଙ୍ଗ୍‌କେ ଆବ୍‌ଟଗେ ନାମଃ ମାତର୍‌‌ ବିସ୍‌ବାସ୍‌ ଡିଂପା ମେଁ ଜିବନ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK8_51","072_8_51","LUK","8","51","51","ଆରି ଜିସୁ ଆତ୍‍ ଅରିଆ ୱେଗେ ପିତର୍ ଯହନ୍‍ ଆରି ଜାକୁବ୍‌ ଆରି ଗଡ଼େଅନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆବାଡ଼େ ଆନ୍ତାର୍‌ଚେ ଆରି ଆଜାଡିଗ୍ ମେଇଂ ଏତେ ବିତ୍ରେ ୱେନେସା ଆବିକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK8_52","072_8_52","LUK","8","52","52","ମାତର୍‌ ସାପାରେ ମେଃନ୍‌ସା ଡାଗ୍‌ଚେ ଅଁ ଅଁଚେ ଗ୍ରିନିଆ ବଗ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଗେ । ଆତ୍ ଅରିଆ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଆ‍ଅଃଗେପା; ଗଡ଼େଅ ଆଗୁଏକେ ଣ୍ତୁ ମାତର୍‌ ଡୁଲେଗ୍‌ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_53","072_8_53","LUK","8","53","53","ମେଁନେ ସାମୁଆଁକେ ମେଇଂ ସାପା ରେମୁଆଁ ଏଃଲ୍ୟା ଆର୍‌କେ । ଡାଗ୍ଲା ଗଡ଼େଅ ଗୁଏଲେକେ ଡାଗ୍‌ଚେ ମେଇଂ ମ୍ୟାଃ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_54","072_8_54","LUK","8","54","54","ମାତର୍‌ ଜିସୁ ସେଲାମ୍ବୁଏଃକେ ନ୍ତି ସାଚେ ବାସଙ୍ଗ୍‌କେ ଅଁ ଗଡ଼େଅ ତଡ଼ିଆ ।” ");
INSERT INTO gaq_vpl VALUES ("LK8_55","072_8_55","LUK","8","55","55","ତେଲା ମେଁନେ ଜିବନ୍ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌କେ ବାରି ଉଲୁସ୍ତେ ତଡ଼ିଆଗେ ଆରି ମେଁ ଆମେକେ ମେଃଣ୍ଡିଗ୍‍ ଚଙ୍ଗ୍‌ନ୍‌ସା ଆଦେସ୍ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK8_56","072_8_56","LUK","8","56","56","ଆତ୍‍ ଅରିଆ ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆବାଡ଼େ ବକୁଆ ଡିଙ୍ଗ୍‌ୱେଗେ ମାତର୍‌ ଏନ୍ ଗଟେକ୍ନେ ସାମୁଆଁ ଆଜା ଡିଗ୍ ଆବାସଙ୍ଗ୍‍ ନ୍‍ସା ଆମେଇଂକେ ଆଦେସ୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_1","072_9_1","LUK","9","1","1","ଜିସୁ ଗମ୍ବାର୍ କ୍ଲିଗ୍‍ ରେମୁଆଁଇଂ ୱାଚେ ମୁଇଂନ୍ନିଆ ଆଡିଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ସାପାରେକେ ଗଲିଆ ଆଃଆନ୍ତାର୍ ଆରି ବେମାର୍‍ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ନ୍‌ସା ବପୁ ଆରି ଅଦିକାର୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_2","072_9_2","LUK","9","2","2","ଆରି ମେଁ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସିସ୍‌ଇଂକେ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ବାସଙ୍ଗ୍‍ ନ୍‍ସା ବାରି ରଗି ରେମୁଆଁକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ନ୍‌ସା ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_3","072_9_3","LUK","9","3","3","ଆରି ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେ ସାପାରେ ୱେନେବେଲା ଟେଙ୍ଗ୍ ଲେଃ ମୁନା ସକା ଲେଃ ରୁଟି ଲେଃ ଡାବୁ ମେଁନେ ଡିଗ୍ ଡୁଙ୍ଗ୍‍ଆୱେଗ୍‌ପା । ଣ୍ଡୁଲା ମ୍ବାକ୍ଲିଗ୍ ସକା ଡୁଙ୍ଗ୍‍ ଆୱେଗେପା । ");
INSERT INTO gaq_vpl VALUES ("LK9_4","072_9_4","LUK","9","4","4","ଆରି ପେ ମୁଃଡ଼ିନେ ଡୁଆନ୍ନିଆ ପେଗାଏ, ଆତେନ୍‌ ଟାନ୍‌ବାନ୍ ମାତାର୍‌ନେ ଜାକ ଆତେନ୍‌ ଡୁଆ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("LK9_5","072_9_5","LUK","9","5","5","ଆରି ଉଡ଼ି ରେମୁଆଁ ଆପେକେ ଆସାର୍ଲ ଆର୍‌ଏ ଆତେନ୍‌ ଇନି ତାର୍‍ନେ ବେଲା ମେଁଇଂନେ ବିରଦ୍‌ରେ ସାକି ବିଃନ୍‍ସା ପେନେ ଞ୍ଚନେ ଦୁଲି ତାଣ୍ଡିଃ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("LK9_6","072_9_6","LUK","9","6","6","ଆତ୍‍ ଅରିଆ ପ୍ରେରିତ୍‌ଇଂ ୱେଆର୍‌ଗେ ଆରି ପବିତ୍ରନେ ନିମାଣ୍ଡା ସାମୁଆଁ ଆ‍ଅଁ ଆର୍‌କେ ଆରି ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ଆଡିଙ୍ଗ୍ ସାପା ଇନିନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_7","072_9_7","LUK","9","7","7","ଆକ୍ ଅରିଆ ସାମନ୍ତ ଇଃସାଙ୍ଗ୍‌ ହେରୋଦ ଆକେନ୍ ସାପା ଗଟେକ୍ନେ ସାମୁଆଁ ୱେଚେ ଜାବର୍ ଏତେଚେ ଲେଃଗେ ଡାଗ୍ଲା ଡୁବନ୍ ବିଣ୍ଡ୍ରେ ଜହନ୍ ମେଁ ଗୁଏଃଚେ ଆରି ମୁଇଂତର୍ ଜିବନ୍ ଣ୍ଡିଙ୍ଗ୍ ଲେଃକେ ଡାଗ୍‌ଚେ ଉଃଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌ଡିଂଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_8","072_9_8","LUK","9","8","8","ଆରି ଜାଣ୍ଡେ ଜାଣ୍ଡେ ଏଲୀୟ ଦର୍ସନ୍ ବିଃଡିଂକେ ଡାଗ୍‌ଚେ ବାସଂଡିଙ୍ଗେ ଆରି ଉଡ଼ିକ୍ଲିଗ୍ ଅସେନେ ବାବବାଦିଇଂ ବାନ୍ ମୁଇଜା ଗୁଏଚେ ଜିବନ୍ ଡିଙ୍ଗ୍‌ଲେ ଡାଗ୍‌ଚେ ବାସଂଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_9","072_9_9","LUK","9","9","9","ହେରୋଦ ବାବେକେ ନେଙ୍ଗ୍ ଜହନ୍‌ନେ ବାଆଃ ଆଃଗୁଆତଗ୍‌ ମ୍ୱକେ ମାତର୍‌ ଏନ୍‌ ରେମୁଆଁ ଜାଣ୍ଡେ ଜାନେ ସାମୁଆଁରେ ନେଙ୍ଗ୍ ଆକେନ୍ ସାପା ଅଁ ନ୍ଲେକେ ?” ତେସା ମେଁ ଜିସୁକେ କେନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_10","072_9_10","LUK","9","10","10","ଇଡ଼ିଙ୍ଗ୍ ପ୍ରେରିତ୍‌ଇଂ ଆଣ୍ଡେଚେ ମେଃନେ ମେଃନେ ଡିଂବଆର୍‌ଗେ ଆତେନ୍‌ ସାପା ଜିସୁନେ ଡାଗ୍ରା ବାସଙ୍ଗ୍‌ ବିଃକେ । ଆରି ଜିସୁ ପ୍ରେରିତ୍‌ଇଂ ଏତେ ୱେଚେ ବିନେ ଡିଙ୍ଗ୍‌ଚେ ବେଥ୍‍ସାଇଦା ମ୍ନିକ୍ନେ ଇନି ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_11","072_9_11","LUK","9","11","11","ମାତର୍‌ ରେମୁଆଁ ଆତେନ୍‌ ଅଁଚେ ମେଁନେ ଡାଗ୍ରା ୱେକେ ଆରି ମେଁ ଆମେଇଂକେ ସାଃଆର୍‌କେ ଆରି ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ, “ଆରି ଜାଣ୍ଡେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ନେ ଲେଃକେ ଆମେଇଂକେ ନିମାଣ୍ଡା ଆଃଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_12","072_9_12","LUK","9","12","12","ଆକ୍ ଅରିଆ ଲମ୍‍ଡିଗ୍‍ ଡିଙ୍ଗ୍‌ନେ ମୁଲେକେ ଆତ୍‍ ଅରିଆ ଗମ୍ବାର୍ ସିସ୍ଇଂ ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍ଆର୍‌କେ “ରେମୁଆଁଇଂ ଡିରକ୍‍ମ୍‍କି ସାପା ପାକାନେ ଇନି ଆରି ଇନିନେ ଜାକ ଚଙ୍ଗ୍‌ନେ ବାଆର୍‌ଲେ ଆତେନ୍‌‍ସା ଆମେଇଂକେ ନୁଆଁ ବିଃପା ମେଃନ୍‌ସା ଡାଗ୍ଲା ନେଁ ଆକ୍ଅରିଆ ସୁନ୍‌ସାନ୍ ଟାନ୍‌ନିଆ ନେଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_13","072_9_13","LUK","9","13","13","ମାତର୍ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେ ଆକ୍‌ମେଇଂକେ ଆଚଙ୍ଗେପା ।” ସିସ୍‌ଇଂ ବାସଙ୍ଗ୍‌କେ “ନେଁ ଡାଗ୍ରା ମାଲିକ୍ଲିଗ୍ ରୁଟି ମ୍ବାକ୍ଲିଗ୍ ଆଃଡ଼ ଆନ୍ତାର୍ଚେ ଜାବର୍ ଣ୍ଡୁ ତେଲା ନେ ମେଃନେ ୱେଚେ ଆକେନ୍ ସାପାରେ ନ୍‍ସା ଚଙ୍ଗ୍‌ନେ ବଲେ ନେବ୍ୟାର୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK9_14","072_9_14","LUK","9","14","14","ଡାଗ୍ଲା ମେଇଂ ପାକା ପାକି ମାଲ୍ ଅଜାର୍ ଙ୍ଗିର୍‍ବଏ ଲେଃଗେ । ଆରି ଜିସୁ ମେଁନେ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଉଡ଼ି ମ୍ବାର୍‍କୁଡ଼ି ଗୁଆ ମ୍ବାର୍‍କୁଡ଼ି ଗୁଆ ଆଡିଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ମାନ୍ଦା ମାନ୍ଦା ଆଡିଙ୍ଗ୍‌ଚେ ଆଃକପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_15","072_9_15","LUK","9","15","15","ସିସ୍ଇଂ ଦେତ୍‌ରକମ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK9_16","072_9_16","LUK","9","16","16","ଆରି ଜିସୁ ମାଲିକ୍ଲିଗ୍ ରୁଟି ଆରି ମ୍ୱାର୍‌କ୍ଲିଙ୍ଗ୍ ଆଡ଼କେ ଲିଙ୍ଗ୍‌ଚେ କିତଙ୍ଗ୍ ଇନି ତାଣ୍ଡେଚେ ପର୍‌ମେସର୍‌‌କେ ଦନ୍ୟବାଦ୍ ବିକେ । ଆକେନ୍ ପାକ୍‍ଚିଚେ ରେମୁଆଁଇଂକେ ବାଟା ବିଃନ୍‌ସା ସିସ୍ଇଂକେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_17","072_9_17","LUK","9","17","17","ଆତ୍‍ ଅରିଆ ସୁଲୁଏ ପୁରୁନ୍ ଚଙ୍ଗ୍‌ଚେ ସାନ୍ତି ବାଆର୍‌କେ । ଆରି ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ଆଣ୍ଡ୍ରାନ୍ନିଆ ଲୁଆଁକ୍ନେ ଡୁଙ୍ଗ୍‌ୱିଗ୍‌ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_18","072_9_18","LUK","9","18","18","ମୁଇଂତର୍ ଜିସୁ ଚିମିକ୍‌ଚାମାକ୍ ଲେଃକ୍ନେ ଜାଗାନ୍ନିଆ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ନେ ବେଲା ସିସ୍ଇଂ ଜିସୁ ଡାଗ୍ରା ପାଙ୍କେ ଆରି ଜିସୁ ଆମେଇଂକେ ସାଲିଆକୁକେ ନେଙ୍ଗ୍ ଜାଣ୍ଡେ ଡାଗ୍‌ଚେ ରେମୁଆଁ ସାପାରେ ମେଁନେ ବାସଙ୍ଗ୍‍ଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK9_19","072_9_19","LUK","9","19","19","ତେଲା ମେଇଂ ଉତର୍ ବିକେ, “ଣ୍ଡିଆନ୍ନିଆ ଦିକ୍ୟା ବିଣ୍ଡ୍ରେ ଜହନ୍‌ । ବାରି ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌ଡିଂ ଏଲୀୟ ବାରି ଜା ଜା ବାସଙ୍ଗ୍‌କେ, ପୁଆ କାଲ୍‌ନେ ବାବବାଦିଇଂନେ ବାନ୍‌ ମୁଇଂଜା ଆରି ମୁଇଂତର୍ ଜିବନ୍ ଡିଙ୍ଗ୍‌ଲେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_20","072_9_20","LUK","9","20","20","ଜିସୁ ଆମେଇଂକେ ସାଲିଆକୁକେ ମାତର୍‌ ନେଙ୍ଗ୍ ଜାଣ୍ଡେ ଡାଗ୍‌ଚେ ପେ ମେଁନେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ? ପିତର୍ ଉତର୍ ବିକେ ନାନେ ଇସ୍‌ପର୍‌ନେ କିସ୍‌ଟ । ");
INSERT INTO gaq_vpl VALUES ("LK9_21","072_9_21","LUK","9","21","21","ଆତ୍‍ ଅରିଆ ଜିସୁ ଆକେନ୍ ସାମୁଆଁ ଆଜାଡିଗ୍ ଆବାସଙ୍ଗ୍‍ ନ୍‍ସା ଆମେଇଂକେ ଚେତ୍‌ନା ବିଚେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_22","072_9_22","LUK","9","22","22","ଆରି ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ମାଲେ ଡଣ୍ଡ୍‌ କଷ୍ଟ ବାନେ ପଡ଼େଏ । ଦର୍ମ ନେତା ଆରି ଜିଉଦି ନେତା ମ୍ନା ପୁଜାରି ଆରି ଦର୍ମସାସ୍ତ୍ରିଇଂ ଆମେକେ ବିସ୍‌ବାସ୍‌ ଆଡିଙ୍ଗ୍‌ଆର୍‌ ଣ୍ଡୁ । ଡିଲାଡିଗ୍ ଆମେକେ ବାଗୁଏ ବିଆର୍‌ଏ ଆରି ମେଁ ଗୁଏକ୍ନେ ଜିର୍‌ସି ଦିନା ବିତ୍‌ରେ ଆରି ତଃଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_23","072_9_23","LUK","9","23","23","ଜିସୁ ସାପାରେକେ ବାସଙ୍ଗ୍‌କେ, “ଅଃନା ଜା ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ ତେଲା ଆମେକେ ନିଜେନେ ନିଜେକେ ଆନ୍ତାର୍‍ ପଡ଼େଏ । କାଲାଆଃ ଆମେକେ ବିବକ୍ନେ କୁରୁସ୍ ଡୁଙ୍ଗ୍‌ଚେ ଆରି ମେଁ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_24","072_9_24","LUK","9","24","24","ମୁଡ଼ି ରେମୁଆଁ ନିଜେନେ ଜିବନ୍ ଆମ୍ବ୍ରନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ ମେଁ ଆତେନ୍‌ ଆଃରେଚେ କଏ । ଆରି ମୁଡ଼ି ରେମୁଆଁ ନେଙ୍ଗ୍‍ନେସା ମେଁନେ ଜିବନ୍ ବିଏ । ମେଁ ଆମେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK9_25","072_9_25","LUK","9","25","25","ବାରି ରେମୁଆଁ ଜଦି ସାପା ଦର୍ତନିକେ ଲାବ୍‌ ଡିଂଚେ ନିଜ୍‌କେ ବିନାସ୍‌ ଆଃଡିଂଏ ବାରି ଜିବନ୍‌ ଆରେଏ, ତେଲା ମେଁନେ ମେଁ ଲାବ୍‌ ? ");
INSERT INTO gaq_vpl VALUES ("LK9_26","072_9_26","LUK","9","26","26","ଜଦି ମୁଡ଼ି ରେମୁଆଁ ନେଙ୍ଗ୍ ସାମୁଆଁରେ ଆରି ନେଙ୍ଗ୍‌ନେ ଜ୍ଞାନ୍‍ ସାମୁଆଁରେ ଗିଆସଏ ତେଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଉଡ଼ିବେଲା ମ‍ଇମା ଡିଙ୍ଗ୍‌ଚେ ଆବା ଆରି ପବିତ୍ର କିତଂ ଦୁତ୍‍ଇଂନେ ମ‍ଇମାରେ ଜାର୍‌ଆର୍‌ଏ । ଅଃତେନ୍‍ ବେଲା ମେଃଡିଗ୍ ମେଁନେ ବିସ‍ଏରେ ଗିଆସ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK9_27","072_9_27","LUK","9","27","27","ମାତର୍‌ ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଇସ୍‌ପର୍‌ନେ ରାଜି ମାକେ ଜାକ ଆକ୍‌ଅରିଆ ତୁଆଁକ୍ନେ ରେମୁଆଁଇଂନେବାନ୍‌ ଉଡ଼ିରୁଆ ମେଃଡିଗ୍‌ ରକମ୍‌ ଗୁଏନେ ସାମୁଆଁ ପେବାଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_28","072_9_28","LUK","9","28","28","ଆକେନ୍ ଗଟେକ୍ନେ ପାକା ପାକି ମୁଇଙ୍ଗ୍ ସାନ୍ତା ମେସୁଆ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ପିତର୍ ଜହନ୍‌ ଆରି ଜାକୁବ୍‌କେ ସଙ୍ଗେ ଡୁଙ୍ଗ୍‍ ୱେଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ନେସା କଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_29","072_9_29","LUK","9","29","29","ଆରି ଜିସୁ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେ ବେଲା ମେଁନେ ସାର୍ମୁଆଁ ବଦ୍ଲେୱେଗେ ଆରି ମେଁନେ ପାଟାଇ ତାର୍କିଗ୍‍ ଡିଙ୍ଗ୍‌ଚେ ତୁଲୁଏ ତ୍ନାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_30","072_9_30","LUK","9","30","30","ଉଲୁସ୍ତେ ମୋଶା ବାରି ଏଲୀୟ, ଆକେନ୍ ମ୍ବାୟା ରେମୁଆଁ ମେଇଂ ଏତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_31","072_9_31","LUK","9","31","31","ମେଇଂ କିତଂ ଆସିର୍ବାଦ୍‌ରେ ସାର୍ଦା ଲେଃଆର୍‌ଗେ ଯିରୁଶାଲାମ୍‍ନ୍ନିଆ ଗୁଏନେ ଗଟେଡିଙ୍ଗ୍‌କ୍ନେ ଆତେନ୍‌ ସାମୁଆଁ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_32","072_9_32","LUK","9","32","32","ଆତେନ୍‌ ବେଲା ପିତର୍ ଆରି ମେଁନେ ସାଙ୍ଗ୍‍ଡ଼େଇଂ ଡୁଲେଗ୍‍ ଲେଃଗେ; ଉଡ଼ିବେଲା ମେଇଂ ତଡ଼ିଆ ଆର୍‌କେ ଜିସୁନେ ମ‍ଇମା କେଚେ ଜିସୁନେ ଏତେ ତୁଆଁଲେଃଗ୍ନେ ମ୍ବାୟା ରେମୁଆଁକେ କେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_33","072_9_33","LUK","9","33","33","ଆରି ମେଇଂ ମେଇଂବାନ୍‍ ୱେଡିଙ୍ଗ୍‌ନେ ବେଲା ପିତର୍ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ “ଅ ମାପ୍‌ରୁ, ନେ ଜେ ଆକ୍‌ଅରିଆ ନେଲେଃକେ, ଆକେନ୍‌ ନିମାଣ୍ଡା; ନାନେ ଜଦି ଇକ୍‌ଚା ଡିଂଲା ନେଙ୍ଗ୍‌ ଆକ୍‌ଅରିଆ ଞ୍ଜିକ୍ଲିଗ୍‌ କୁଡ଼ିଆ ଣ୍ଡ୍ରାରେଏ, ନା ଆତ୍‌ଲା ମୁଇଂ, ମଶା ଆତ୍‌ଲା ମୁଇଂ ବାରି ଏଲିୟ ଆତ୍‌ଲା ମୁଇଂ ।” ମାତର୍‌ ପିତର୍ ମେଁନେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍ ଆତେନ୍‌ ଆମ୍ୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK9_34","072_9_34","LUK","9","34","34","ପିତର୍ ଆକେନ୍ ବାସଙ୍ଗ୍‌ନେ ବେଲା, “ଇକୁଡ଼ା ତ୍ରିଗ୍‌ଡିଆ ଆମେଇଂକେ ଡା ବିଲା ମେଇଂ ବୁଟୱେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_35","072_9_35","LUK","9","35","35","ଆତେନ୍‌‌ ତ୍ରିଗ୍‌ଡିଆବାନ୍ ଆକେନ୍‌ ସାମୁଆଁ ଡିଂକେ, “ଏ ନେଙ୍ଗ୍‌ନେ ଉଂଡେ, ନେଂ ସ୍ରିବକ୍ନେ,” ଆକ୍ମେନେ ବ୍ନାଲିର୍‌ ଅଁପା । ");
INSERT INTO gaq_vpl VALUES ("LK9_36","072_9_36","LUK","9","36","36","ଆରି ଆତେନ୍‌ ସାମୁଆଁ ନ୍ନାଂକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମୁଇଂଜା ଆଃ ତ୍ନାକେ । ଆରି ମେଇଂ ବୁଙ୍ଗ୍‍ ଲେଃଗେ ଆରି ମେଃନେ କେଆର୍‌କେ ଆତ୍‍ଅରିଆ ମେଁନେ ଡିଗ୍ ସାମୁଆଁ ଆତେନ୍‌ ବେଲା ଆଜା ଡିଗ୍ ଆବାସଙ୍ଗ୍‍ ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK9_37","072_9_37","LUK","9","37","37","ତେନ୍‌ ଞ୍ଜିର୍‌ ଜିସୁ ଆରି ଞ୍ଜିରୁଆ ସିସ୍‌‍ଇଂ କଣ୍ଡାବାନ୍ ଜାର୍‌ଚେ ପାଙ୍ଗ୍‌କେ ଜବର୍ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ଅବାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_38","072_9_38","LUK","9","38","38","ଆରି କେଲା ରେମୁଆଁ ମଜେ ବାନ୍ ମୁଇଂଜା ଜାବର୍ କିରଚେ ବାସଙ୍ଗ୍‌କେ “ଅ ଗୁରୁ ନେଙ୍ଗ୍ ଆନାକେ ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍ ଣ୍ଡିଙ୍ଗ୍‍ ନେଙ୍ଗ୍‌ନେ ଗଡ଼େଅକେ କେଲା ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଁ ନେଙ୍ଗ୍‌ନେ ମୁଇଂ ଆଃ ଙ୍ଗିର୍‍ବଏ ଅ । ");
INSERT INTO gaq_vpl VALUES ("LK9_39","072_9_39","LUK","9","39","39","କେଲାପା ଆମେକେ ମୁଇଙ୍ଗ୍ ସେଆଁରେ ସାଏ ଆରି ମେଁ ଉଲୁସ୍ତେ କିରଚେ ତଡ଼ିଆଏ ଆରି ମେଁ ଆମେକେ ଦେକ୍‌ରକମ୍ ମଡ଼େଏ ଜେ ମେଁନେ ସାର୍ମୁଆଁ ବାନ୍ ବୁନେଃତୁର୍‍ ତାର୍‌ଡିଂକେ ଆରି ମେଁ ବାନ୍ କଷ୍ଟ ତାର୍ ୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_40","072_9_40","LUK","9","40","40","ଆମେକେ ସେଆଁରେ ଆଆନ୍ତାର୍‍ ନ୍‌ସା ନେଙ୍ଗ୍ ନାନେ ସିସ୍ଇଂକେ ଜବର୍‌ଜସ୍ତି ଣ୍ଡିଙ୍ଗ୍‍କେ ମାତର୍‌ ମେଇଂ ଆୟାଆର୍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK9_41","072_9_41","LUK","9","41","41","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଆରେ ଅବିସ୍‌ବାସି ଆରି ଦଦ୍ୟା ଗାଲି ୱେଣ୍ଡ୍ରେ ବଂସ, ଉଃଡ଼ି ମୁଆଁ ନିଂ ପେନେ ଏତେ ଲେଃଚେ ପେନେ ବେବ‍ଆର୍ ନ୍‌ସମ୍ବାଲେଏ ? ନାଉଙ୍ଗ୍‌କେ ଆକ୍‌ଅରିଆ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_42","072_9_42","LUK","9","42","42","ଗଡ଼େଅ ପାଙ୍ଗ୍‌ଡିଂକ୍ନେ ବେଲା ସେଆଁରେ ଆମେକେ ବୁନ୍ଦେ ଆଲବିଗେ ଜାବର୍ ମଡ଼େବିଚେ ତୁବନ୍ନିଆ ଜଗ୍‌ତ୍ଲାଗ୍‍ ବିଃକେ ମାତର୍‌ ଜିସୁ ବୁତ୍‌କେ ଦାକା ବିକେ । ଆରି ଗଡ଼େଅକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌ଚେ ଆମେକେ ମେଁନେ ଆବାଡ଼େନେ ନ୍ତିନ୍ନିଆ ଆସା ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_43","072_9_43","LUK","9","43","43","ଆତ୍‍ ଅରିଆ ସାପାରେ ପର୍‌ମେସର୍‌ନେ ବପୁ କେଚେ କାବା ଡିଙ୍ଗ୍ ଲେଃଗେ । ମାତର୍‌ ଆମେକେ ସାପାରେ କାମ୍ କେଚେ ସାପାରେ କାବା ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ବେଲା ଜିସୁ ନିଜେନେ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_44","072_9_44","LUK","9","44","44","ଜିସୁ ମେଁନେ ସିସ୍‌‍ଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ମେଁନେ ଆପେକେ ବାସଙ୍ଗ୍‍ମ୍ବକେ ଆତେନ୍‌ ଆବଗ୍‌ପା । ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ରେମୁଆଁଇଙ୍ଗ୍‌ନେ ନ୍ତି ନ୍ନିଆ ସମର୍ପିତ ଡିଂନ୍‌ସାଃ ୱେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_45","072_9_45","LUK","9","45","45","ମାତର୍‌ ସିସ୍‌‍ଇଂ ଜିସୁନେ ସାମୁଆଁ ଆବୁଜେଆର୍‌କେ ଣ୍ଡୁ ଆରି ଆତେନ୍‌ ମେଇଂବାନ୍‍ ବୁଡ଼ିଚେ ଲେଃଗେ ମେଁଇଂନେ ଆତେନ୍‌ ସାମୁଆଁ ବୁଜେ ଆୟାଲା ଡିଗ୍ ଆରି ମେଇଂ ଆତେନ୍‌ ସାମୁଆଁ ବିସ‍ଏରେ ଜିସୁକେ ସାଲିଆକୁ ନ୍‌ସା ବୁଟ ଡିଙ୍ଗ୍ ଆର୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_46","072_9_46","LUK","9","46","46","ମେଇଂନେ ବାନ୍ ଜାଣ୍ଡେ ମ୍ନା ଆତେନ୍‌ ବିସୟ୍‌ରେ ମେଇଂନେ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ନେ ଲାଗେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_47","072_9_47","LUK","9","47","47","ମାତର୍‌ ଜିସୁ ମେଁଇଂନେ ମନ୍‍ନେ ବାଲିର୍‌ବାତାକ୍ନେ ମ୍ୟାଃଗେ ଆତେନ୍‌‍ସା ମୁଇଂ ଡାଆଁନେ ଗଡ଼େଅକେ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଚେ ମେଁନେଡାଗ୍ରା ଆଃତୁଆଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK9_48","072_9_48","LUK","9","48","48","ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଜଦି ମୁଡ଼ି ରେମୁଆଁ ନେଙ୍ଗ୍ ମ୍ନିରେ ଆକେନ୍ ଗଡ଼େଅଇଂକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ । ମେଁ ଆନେଙ୍ଗ୍ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ଆରି ଜା ଆନେଙ୍ଗ୍‌କେ ବେବକେ, ଆମେ ଡିଗ୍ ମେଁ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ । ଡାଗ୍ଲା ନାନେ ସାପାରେବାନ୍‍ ନିଜ୍‍କେ ଡାଆଁ ଆଃସୁଏ, ମେଁ ଆଃ ସାପାବାନ୍‍ ମ୍ନା ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_49","072_9_49","LUK","9","49","49","ଆତ୍‍ ଅରିଆ ଜହନ୍‌ ବାସଙ୍ଗ୍‌କେ “ଅ ଗୁରୁ ନେଁ ମୁଇଂଜାକେ ନାନେ ମ୍ନିରେ ସେଆଁରେକେ ଆଆନ୍ତାର୍‌କ୍ନେ ନେକେକେ ଆରି ମେଁ ନେଁନେ କୁଦାନିଆ ଆଲେଃଲା ଆମେକେ ମନା ନେଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_50","072_9_50","LUK","9","50","50","ମାତର୍‌ ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ମନା ଆଡିଙ୍ଗେପା ମେଃନ୍‌ସା ଡାଗ୍ଲା ଜା ପେନେ ସାହା ଣ୍ଡୁ ମେଁ ପେନେ ସାହା ଡିଙ୍ଗ୍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_51","072_9_51","LUK","9","51","51","ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିବେଲା ଜିସୁ କିତଂ ୱେନେସା ବେଲା ପାଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଗେ ଅଃତେନ୍‍ ବେଲା ଜିସୁ ଯିରୁଶାଲାମ୍‍ନ୍ନିଆ ୱେନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_52","072_9_52","LUK","9","52","52","ନିଜେନେ ସେନୁଗ୍‍ ଦୁତ୍‍ଇଂକେ ବେକେ । ମେଇଂ ୱେଚେ ମେଁ ନ୍‌ସା ଆର୍ମେ ନ୍‌ସା ସମରିଆଇଂନେ ମୁଇଙ୍ଗ୍ ଇନି ଗାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_53","072_9_53","LUK","9","53","53","ମାତର୍‌ ଜିସୁ ଯିରୁଶାଲାମ୍‍ନ୍ନିଆ ୱେଡିଙ୍ଗ୍ ଡାଗ୍‌ଚେ ମ୍ୟାଚେ ଆତେନ୍‌ ଇନିନେ ରେମୁଆଁ ଆମେକେ ସାର୍ଲ ଆଡିଙ୍ଗ୍ ଆର୍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK9_54","072_9_54","LUK","9","54","54","ଆକେନ୍‍ କେଚେ ଜାକୁବ୍‌ ଆରି ଜହନ୍‌ ଏନ୍ ମ୍ବାୟା ସିସ୍ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ଦେତ୍‌ରକମ୍ କିତଂଇନିବାନ୍ ସୁଆ ଆଲଚେ ଆମେଇଂକେ ଦଂସ ନେରାଡିଙ୍ଗ୍‍ ଡାଗ୍‌ଚେ ମେଃନେ ନା ଚାଏଁ ନାଡିଂକେ କି ?” ");
INSERT INTO gaq_vpl VALUES ("LK9_55","072_9_55","LUK","9","55","55","ମାତର୍‌ ଜିସୁ ପୁଏଚେଃ ଆମେଇଂକେ କେକେ ଆରି ଆଃଦର୍ସେଚେ ବାସଙ୍ଗ୍‌କେ, “ପେ ଡିରକମ୍ ଆତ୍ମାନେ ରେମୁଆଁ ନେଁ ନେମ୍ୟାକେ ଣ୍ଡୁ । ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ରେମୁଆଁଇଂନେ ଜିବନ୍ ବାଗୁଏଃ ନ୍‍ସା ନାପାଙ୍ଗ୍‍କେ ଆରି ୱେନ୍‌ସା ପାଙ୍ଗ୍‌ଲେ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_56","072_9_56","LUK","9","56","56","ଇଡ଼ିଙ୍ଗ୍ ମେଇଂ ଆରି ମୁଇଂଜାଗା ଇନି ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK9_57","072_9_57","LUK","9","57","57","ମେଇଂ ଗାଲିବ ୱେଡିଙ୍ଗ୍‌ନେ ବେଲା ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ “ନା ଆଣ୍ଡି ପାକା ନାୱେଏ ନେଙ୍ଗ୍‍ ନା ପ୍ଲା ମ୍ପାଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_58","072_9_58","LUK","9","58","58","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନାକାଇଂନେ ପ୍ଲଗ୍‍ ଲେଃକେ; ପ୍ଲିଗ୍‍ଇଂନେ ଉଙ୍ଗ୍‌ଚ୍ୟା ଲେଃକେ ମାତର୍‌ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେନେ ବାଆଃ ବନେ ଟାନ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_59","072_9_59","LUK","9","59","59","ଆରି ଜିସୁ ବାରି ମୁଇଂଜାକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‍ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଲାପା ।” ମେଁ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍‌ରୁ ! ସେନୁଗ୍‍ ୱେଚେ ନେଙ୍ଗ୍‍ନେସା ନେମ୍ବାକେ ଆତି ବିଃନ୍‌ସା ଆନେଙ୍ଗ୍‌କେ ଆଦେସ୍ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_60","072_9_60","LUK","9","60","60","ମାତର୍‌ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଗ୍ୱେରେଇଂକେ ମେଇଂ ମେଇଂନେ ଗୁଏଃକ୍ନେ ରେମୁଆଁଇଂକେ ଆତି ନ୍‌ସା ଆନ୍ତାର୍‌ବିପା । ମାତର୍‌ ପେ ୱେଚେ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍‍ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_61","072_9_61","LUK","9","61","61","ବାରି ମୁଇଂଜାକେ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ନେଙ୍ଗ୍ ନାଁନେ ପ୍ଲା ମ୍ପାଙ୍ଗ୍‍ଏ ମାତର୍‌ ସେନୁଗ୍‍ ନେଙ୍ଗ୍‌ନେ ଡୁଆ ଲେଃକ୍ନେ ରେମୁଆଁଇଂନେ ବାନ୍ ନୁଆଁ ବିନ୍‌ସା ଆନେଙ୍ଗ୍‌କେ ବେବିଃଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK9_62","072_9_62","LUK","9","62","62","ମାତର୍‌ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଜା ସ୍ନି ସାଚେ ପ୍ଲା ପାଟା କେଏ ମେଁ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍‍ ନ୍‍ସା ମେଃଡିଗ୍ ସ୍ଲେ ନ୍‌ସା ଦର୍‌କାର୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_1","072_10_1","LUK","10","1","1","ଇଡ଼ିଙ୍ଗ୍ ମାପ୍ରୁ ଆରି ଞ୍ଜିକୁଡ଼ି ଗୁଆ ସ୍ରି ଆର୍‌କେ ଆରି ନିଜେ ନିଜେ ଆଣ୍ଡିନେ ଇନି ଆରି ଜାଗାନ୍ନିଆ ୱେନ୍‌ସା ବାଦ୍ୟ ଲେଃଗେ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ମ୍ବାୟା ମ୍ବାୟା ଆଡିଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ଆତ୍‌ଅରିଆ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_2","072_10_2","LUK","10","2","2","ଆରି ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଗହମ୍ ସିନା ଜବର୍ ମାତର୍‌‌ କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଇକୁଡ଼ା; ନିଜେନେ ଲିଜ ବ୍ରିନ୍ନିଆ ସ୍ଲେଣ୍ଡ୍ରେକେ ବେବିଃନ୍‍ସା ଲିଜ ବ୍ରିନେ ସାକାର୍‌କେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK10_3","072_10_3","LUK","10","3","3","ପେ ୱେଲାପା; କେଲାପା, ଙ୍କୁଇଂନେ ବିତ୍ରେ ମେଣ୍ଡାଇଂ ସୁଗୁଆ ନେଙ୍ଗ୍‍ ଆପେକେ ବେଣ୍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_4","072_10_4","LUK","10","4","4","ଡାବୁ ମୁନା ଆରି ପାଣ୍ଡୁଏ ଡୁଙ୍ଗ୍‍ ଆୱେଗେପା । ଗାଲିନ୍ନିଆ ଆଜାଡିଗ୍ ଆସାର୍ଲଗ୍‍ପା । ");
INSERT INTO gaq_vpl VALUES ("LK10_5","072_10_5","LUK","10","5","5","ଆରି ମୁଃଡ଼ିନେ ଡୁଆନ୍ନିଆ ପେ ପେଗାଏ, ସେନୁଗ୍‍ ବାସଙ୍ଗ୍‌ ଆକେନ୍ ଡୁଆ ସାନ୍ତି ଡିଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_6","072_10_6","LUK","10","6","6","ଆତ୍‍ ଅରିଆ ଜାଣ୍ଡେ ନିମାଣ୍ଡା ରେମୁଆଁ ଲେଃଏ ତେଲା ପେନେ ସାନ୍ତି ଆମେକେ ମିଲେଏ । ଡାଗ୍ଲା ଜାଣ୍ଡେ ଆତ୍‍ ଅରିଆ ସାନ୍ତି ରେମୁଆଁ ଆଲେଃ ତେଲା ପେନେ ସାନ୍ତି ସାହା ପେନେ ଡାଗ୍ରା ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK10_7","072_10_7","LUK","10","7","7","ଆରି ମେଇଂ ଡାଗ୍ରା ମେଁନେ ଲେଃଏ ଆତେନ୍‌ ଚଙ୍ଗ୍ ଆଣ୍ଡେଙ୍ଗ୍‌ଚେ ଆତେନ୍‌ ଡୁଆନିଆ ଲାଃଲାପା ମେଃନ୍‌ସା ଡାଗ୍ଲା କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ମେଁନେ ଦର୍ମା ବାନେ ଅଦିକାର୍ ଲେଃକେ । ଡୁଆକେ ଡୁଆ ଆୱେଗେପା । ");
INSERT INTO gaq_vpl VALUES ("LK10_8","072_10_8","LUK","10","8","8","ଆରି ଆଣ୍ଡିନେ ଇନି ଡିଗ୍ ପେୱେଚାଏ ଆରି ରେମୁଆଁଇଂ ଆପେକେ ସାର୍ଲ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଆତ୍‍ଅରିଆ ଆନାକେ ମେଃନେ ଚଙ୍ଗ୍‌ନେ ବିଏ ଆତେନ୍‌ ଚଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK10_9","072_10_9","LUK","10","9","9","ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଲେଃକ୍ନେ ରଗ୍‍ ସାଃକ୍ନେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌ପା ଆରି ଆମେଇଂକେ ବାସଙ୍ଗ୍‌ପା ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ପେନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_10","072_10_10","LUK","10","10","10","ମାତର୍‌ ମୁଡ଼ି ଇନି ପେଇଂ ପେୱେଚାଏ ଆରି ରେମୁଆଁ ଆପେକେ ଆୱାଆର୍‌ ଣ୍ଡୁ ଆତ୍‌ନେ ବାଜାର୍‍ ବାଏରେ ୱେଚେ ବାସଙ୍ଗ୍‌ପା ");
INSERT INTO gaq_vpl VALUES ("LK10_11","072_10_11","LUK","10","11","11","ସାମୁଆଁ ପେଇଂ ଇନିନେ ଆଣ୍ଡିନେ ଦୁଲି ନେନେ ଞ୍ଚନିଆ ଗିଗ୍‍ଲା ଲେଃକ୍ନେ ଆତେନ୍‌ ପେନେସା ତାଣ୍ଡି ବିନେଡିଙ୍ଗ୍‍; ଡାଗ୍ଲା ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ଜେ ଡାଗ୍ରା ପାଙ୍କେ ଆକେନ୍ ମ୍ୟା ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("LK10_12","072_10_12","LUK","10","12","12","ନେଙ୍ଗ୍‍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ ଆତେନ୍‌ ଦିନା ଆତେନ୍‌ ଇନିନେ ଡଣ୍ଡ୍‍ବାନ୍‍ ସଦୋମନେ ଡଣ୍ଡ୍ ଡେଃୟାଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_13","072_10_13","LUK","10","13","13","ଏ କୋରାଜିନ୍‌ ନାନେ କସ୍ଟ କି ବୟାଙ୍କାର୍‌ ଡିଙ୍ଗ୍‌ଏ ଏ ବେଥ୍‍ସାଇଦା ନାନେ କସ୍ଟ କି ବୟାଙ୍କାର୍‌ ଡିଙ୍ଗ୍‌ଏ ଡାଗ୍ଲା ପେଇଂନେ ବିତ୍ରେ ପେନେ ବାନ୍ ମୁଃଡ଼ି ବପୁକାମ୍ ଆଡିଙ୍ଗ୍ ଣ୍ଡିଙ୍ଗ୍‍ ଆତେନ୍‌ ସାପା ଆନା ସୋର ଆରି ସୀଦୋନନ୍ନିଆ ଆଡିଙ୍ଗ୍ ପାଡିଙ୍ଗ୍ ତେଲା ମେଇଂ ଗୁଲୁଏ ଜୁଗ୍‍ନେ ସେନୁଗ୍‍ ବାସ୍ତା ସଚେ ଉଗ୍‍ସନ୍ନିଆ କଚେ ମନ୍‍କେ ଆବଦ୍‌ଲେ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK10_14","072_10_14","LUK","10","14","14","ବିଚାର୍ ବେଲା ପେନେ ଡଣ୍ଡ୍ ସୋର ଆରି ସୀଦୋନକେ ମାଲେ ଦୟା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK10_15","072_10_15","LUK","10","15","15","ଆରି ଅ କପର୍ନାହୁମ୍‍ ଆଡ଼ାତ୍ରା ଦେକ୍ ରକମ୍ ଗଟେଏ ନାନେ ଆଡ଼ାତ୍ରା ଦେତ୍ ରକମ୍ ଗଟେଏ ? ନାନେ କିତଂ ଜାକ ନିଜ୍‍କେ ମ୍ନାନ୍‍ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ନାଲେଃକେ ଆନାକେ ନର୍କେ ଜଗ୍‌ତ୍ଲାଗ୍‌ ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK10_16","072_10_16","LUK","10","16","16","ଜିସୁ ନିଜେନେ ସିସ୍‌ଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଜାଣ୍ଡେ କି ପେନେ ସାମୁଆଁ ଅଁଏ ମେଁ ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁଏ ଆରି ଜାଣ୍ଡେ ଆପେକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌ଏ ମେଁ ଆନେଙ୍ଗ୍‍ ଡିଗ୍‍ ଇଙ୍ଗ୍‌ଚେଏ ଆରି ଜାଣ୍ଡେ ଆନେଙ୍ଗ୍‌କେ ଇଙ୍ଗ୍‌ଚେଏ ମେଁ ନେଙ୍ଗ୍‌ନେ ବେବକ୍ନେ ଆବାକେ ଡିଗ୍ ଇଙ୍ଗ୍‌ଚେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_17","072_10_17","LUK","10","17","17","ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ଞ୍ଜିକୁଡ଼ି ଗୁଆ ସିସ୍‌‍ଇଂ ସାର୍ଦାରେ ଆଣ୍ଡେଚେ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ସେଆଁରେଇଂ ଣ୍ଡିଗ୍‍ ନାଁନେ ମ୍ନିରେ ଆନେଁକେ ମାନେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_18","072_10_18","LUK","10","18","18","ମାତର୍‌ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଲ୍‌ଲାଂତାର୍ ସୁଗା କିତଂବାନ୍ ସ‍ଏତାନ୍ ଲଃଡିଙ୍ଗ୍‌କ୍ନେ ନେଙ୍ଗ୍ ନେକେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_19","072_10_19","LUK","10","19","19","କେଲାପା ନେଙ୍ଗ୍ ଆପେକେ ବୁବଃ ଆରି ଙ୍ଗୁଆରେଗ୍‍ ଆଡ଼ାତ୍ରା ଅଲେଙ୍ଗ୍‍ ନ୍‍ସା ସକତ୍‌ ବିଣ୍ଡିଙ୍ଗ୍‍ ବାରି ସତ୍ରୁନେ ସାପା ସକତ୍‌ ଆଡ଼ାତ୍ରା ଡିଗ୍ ସକତ୍‌ ବିଣ୍ଡିଙ୍ଗ୍‍ ଆରି ଡିରକମ୍ ଡିଗ୍ ପେଇଂନେ ମେଃନେ ଣ୍ଡିଗ୍‍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK10_20","072_10_20","LUK","10","20","20","ତେଲାଡିଗ୍‍ ଦଦ୍ୟା ଆତ୍ମାଇଂ ଜେ ପେଇଂନେ ସାମୁଆଁ ମାନେଃ ଡିଙ୍ଗ୍‌କେ ଆକ୍ ଅରିଆ ସାର୍ଦା ଆଡିଙ୍ଗ୍‌ପା ମାତର୍‌ ପେନେ ମ୍ନି ଜେ କିତଂନ୍ନିଆ ଗୁଆର୍‍ବକେ ଆକ୍ ଅରିଆ ସାର୍ଦା ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_21","072_10_21","LUK","10","21","21","ଆତେନ୍‌ ବେଲା ଜିସୁ ପବିତ୍ର ଆତ୍ମାନେ ବାନ୍ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଆବା କିତଂ ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ନେ ମାପ୍ରୁ ନାଁ ଗୁନ୍ ଆରି ଜ୍ଞାନ୍‍ ରେମୁଆଁଇଂନେ ବାନ୍ ଆକେନ୍ ସାପା ସାମୁଆଁ ବୁଡ଼ି ବଚେ ଡାଆଁ ଗଡ଼େଇଂ ଡାଗ୍ରା ବାସଙ୍ଗ୍‌ନେବ ଆତେନ୍‌‍ସା ଆନାକେ ଦନ୍ୟବାଦ୍ ଡିଙ୍ଗ୍‌ନେଡିଂ; ଅଁ ଆବା ମେଃନ୍‌ସା ଡାଗ୍ଲା ଆକେନ୍ ନାଁନେ ମ୍ନାନେ ଇକ୍‌ଚା । ");
INSERT INTO gaq_vpl VALUES ("LK10_22","072_10_22","LUK","10","22","22","ନେଙ୍ଗ୍‌ନେ ନେମ୍ବାନେ ସାପା ସାମୁଆଁ ନେଙ୍ଗ୍‍ନ୍ନିଆ ଅପେଃ ବିଃକେ; ଆରି ଗଡ଼େଅ ଜାଣ୍ଡେ ଆକେନ୍ ଆବା ଆନ୍ତାର୍ଚେ ଜା ଆମ୍ୟାଃକେ ଣ୍ଡୁ ଆରି ଆବା ଜାଣ୍ଡେ ଆକେନ୍ ଗଡ଼େଅ ଆନ୍ତାର୍ଚେ ଜା ଆମ୍ୟାଃକେ ଣ୍ଡୁ ଆରି ଗଡ଼େଅ ଜା ଡାଗ୍ରା ଆମେକେ ଉଡ୍ରା ଆଃଡିଙ୍ଗ୍ ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌କେ ମେଁ ଆମେକେ ମ୍ୟାଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_23","072_10_23","LUK","10","23","23","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍ଇଂକେ ବୁଙ୍ଗ୍‌ନା ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ଏନ୍‌ସାପା ବିସୟ୍ କେପେଲେକେସା ଉଡ଼ି ବାଗ୍ୟବାନ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_24","072_10_24","LUK","10","24","24","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ “ପେ ମେଁନେ ମେଁନେ କିକେପେଡିଙ୍ଗ୍ ଆତେନ୍‌ ସାପା ଗୁଲେ ବାବବାଦି ଆରି ଇଃସାଙ୍ଗ୍‌ କେନ୍‍ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍ ଆର୍‌କେ ମାତର୍‌ ଆକେଆର୍‌କେ ଣ୍ଡୁ; ଆରି ପେ ମେଃନେ ଅଁପେଡିଂକେ ଆତେନ୍‌ ସାପା ମେଇଂ ଅଁନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍ ଆର୍‌କେ ମାତର୍‌ ଆ‍ଅଁ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_25","072_10_25","LUK","10","25","25","ଆରି କେଲାପା ମୁଇଂଜା ନିୟମ୍‌ ସାସ୍ତର୍‌ ଲଃଣ୍ଡ୍ରେ ତଡ଼ିଆଚେ ଆମେକେ ପରିକ୍ୟା ଡିଙ୍ଗ୍‌ଚେ ସାଲିଆକୁକେ, “ଅ ଗୁରୁ ମାଡାନେ ଜିବନ୍ ବାନ୍‌ସା ନେଙ୍ଗ୍ ମେଁନେ ଣ୍ଡିଙ୍ଗ୍‍ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK10_26","072_10_26","LUK","10","26","26","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ସାସ୍ତର୍‌ନ୍ନିଆ ମେଃନେ ଗୁଆର୍‍ବକେ ? ନାଁ ଡିରକମ୍ ପଡ଼େ ନାଡିଙ୍ଗ୍‍ ?” ");
INSERT INTO gaq_vpl VALUES ("LK10_27","072_10_27","LUK","10","27","27","ଜିସୁ ଉତର୍ ବିକେ “ନାଁନେ ନିଜେନେ ମନ୍‌ ସାପା ଆତ୍ମା ସାପା ବପୁ ଆରି ସାପା ମନ୍ ବିଚେ ପର୍‌ମେସର୍‌କେ ଆଲାଦ୍ ଡିଂପା । ଆରି ପେଇଂ ନିଜେକେ ଆଲାଦ୍ ପେଡିଂକେ ସୁଗୁଆ ବିନ୍‌ଣ୍ଡ୍ରେକେ ଡିଗ୍ ଆଲାଦ୍ ଡିଂପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_28","072_10_28","LUK","10","28","28","ଆତ୍‍ ଅରିଆ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନାନେ ସମାନ୍ ଉତର୍ ନାବିକେ ଦେକ୍‌କେ ଡିଙ୍ଗ୍ ତେଲା ନାନେ ଜିବନ୍ ନାବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_29","072_10_29","LUK","10","29","29","ମାତର୍‌ ଦର୍ମ ଗୁରୁ ନିଜେକେ ନିମାଣ୍ଡା ସୁଗୁଆ ଆକେନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଚେ ଜିସୁକେ ସାଲିଆକୁକେ, “ତେଲା ନେଙ୍ଗ୍‌ନେ ନିଜର୍‌ ରେମୁଆଁ ଜାଣ୍ଡେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK10_30","072_10_30","LUK","10","30","30","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଯିରୁଶାଲାମ୍‍ ବାନ୍‌ ଯିରୀହୋନ୍ନିଆ ୱେନେ ବେଲା ଡଙ୍ଗାରେଇଂ ଆମେକେ ସା ଆର୍‌କେ ମେଇଂ ମେଁନେ ପାଟାଇପୁଟାଇ ଡୁଂଡଚେ ବଗ୍ ଆର୍‌କେ ଆରି ଗୁଏୱେଗେ ସୁଗା ବଗ୍‍ଚେ ଆମେକେ ଆନ୍ତାର୍‌ଚେ ଲାଗ୍‍ଡଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_31","072_10_31","LUK","10","31","31","ଗଟେକ୍ନେ ସୁଗୁଆ ମୁଇଙ୍ଗ୍ ପୁଜାରି ଆନ୍ତ୍‍ପାକା ୱେଡିଂଗେ ଆରି ମେଁ ଆମେକେ କେଚେ ବିନ୍‌ ଗାଲି ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_32","072_10_32","LUK","10","32","32","ଦେତ୍ ରକମ୍ ମୁଇଂଜା ଲେବୀୟ ଡିଗ୍ ଆତେନ୍‌ ଜାଗା ପାଙ୍ଗ୍‌ଚେ ଆମେକେ କେଚେ ବିନ୍‍ ଗାଲି ବିଚେ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_33","072_10_33","LUK","10","33","33","ମାତର୍‌ ମୁଇଙ୍ଗ୍ ଶମିରୋଣୀୟ ରେମୁଆଁ ଆମେକେ କେଚେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଆମେକେ କେଚେ ଲିବିସଃଚେ, ");
INSERT INTO gaq_vpl VALUES ("LK10_34","072_10_34","LUK","10","34","34","ଆରି ଡାଗ୍ରା ୱେଚେ ମେଁନେ ଚିନାନିଆ ଞ୍ଚୁ ଆରି ଅଙ୍ଗୁର୍ ରସ୍ କିଗ୍‍ଚେ ଆତେନ୍‌ ସାପା ଗାଗ୍‌ବିଗେ ଆରି ଆମେକେ ଗଡ଼ାନ୍ନିଆ ଆଃକଚେ ଆମେକେ ଗଦାର୍‌ କାନାନ୍ନିଆ ଡୁଙ୍ଗ୍‍ ୱେଚେ ଆମେକେ ସେବା ଜତନ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_35","072_10_35","LUK","10","35","35","ପାଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ଦିନା ଶମିରୋଣୀୟ ମେଁ ମ୍ବାକ୍ଲିଗ୍‍ ରୁପା ଡାବୁ ଆଃତାର୍‌ଚେ ଆତେନ୍‌ ଡୁଆନେ ମାଲିକ୍‌କେ ବିଚେ ବାସଙ୍ଗ୍‌କେ ଆକ୍‌ମେନେ ସେବା ଜତନ୍ ଡିଙ୍ଗ୍ ଆରି ଜାବର୍ ଡାବୁ କର୍ଚ ନାଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ନେଙ୍ଗ୍ ଆଣ୍ଡେନେ ବେଲା ଆନାକେ ସୁଜେ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_36","072_10_36","LUK","10","36","36","ଏନ୍ ଞ୍ଜିରୁଆ ବିତ୍ରେ ଜା ଡଙ୍ଗାରେଇଂନେ ସେନୁଗ୍‍ ଲଲେଃକ୍ନେ ରେମୁଆଁନେ ଡୁଆଣ୍ଡ୍ରେ ଡାଗ୍‌ଚେ ଏତେ ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_37","072_10_37","LUK","10","37","37","ଦର୍ମ ଗୁରୁ ବାସଙ୍ଗ୍‌କେ, “ଜା ମେଁ ଆଡ଼ାତ୍ରା ଦୟା ଆକେକେ ।” ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ୱେଲାପା ପେ ଡିଗ୍ ଦେତୁଆ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_38","072_10_38","LUK","10","38","38","ଜିସୁ ଆରି ମେଇଂ ନେନେ ସିସ୍‌‍ଇଂ ୱେଡିଙ୍ଗ୍‌ନେ ବେଲା ଜିସୁ ମୁଇଙ୍ଗ୍ ଇନି ୱେଚା ଆର୍‌କେ ଆରି ମାର୍ଥା ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୁଏ ମେଁନେ ଡୁଆନ୍ନିଆ ୱାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_39","072_10_39","LUK","10","39","39","ମରିୟମ୍ ମ୍ନିକ୍ନେ ମେଁନେ ମୁଇଙ୍ଗ୍ ତନାଣ୍ଡେ ଲେଃଗେ, ମେଁ ମାପ୍‌ରୁନେ ଞ୍ଚବୁନ୍ଦେ କଚେ ମେଁନେ ସାମୁଆଁ ଅଁ ଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_40","072_10_40","LUK","10","40","40","ମାତର୍‌ ମାର୍ଥା ସେବା ଡିଙ୍ଗ୍‌କ୍ନେ ବିସୟ୍‌ରେ ଜାବର୍ ତାନ୍ଦ୍ରା ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଗେ; ତେସା ମେଁ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଅ ମାପ୍ରୁ ନେ ତନା ଜେ ମୁଇଂ ଆଃ ନେଙ୍ଗ୍ ଆଡ଼ତ୍ରା କାମ୍ ଆନେଙ୍ଗ୍ ଆନ୍ତାର୍‍ ବିଃଡିଂକେ ଏନ୍ ବିସୟ୍‌ରେ ମେଁନେ ନାନେ ମନ୍ ଣ୍ଡୁ ? ଆନେଙ୍ଗ୍‌କେ ସାଇଜ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆମେକେ ବାସଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("LK10_41","072_10_41","LUK","10","41","41","ମାତର୍‌ ମାପ୍‌ରୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ମାର୍ଥା, ମାର୍ଥା, ନାନେ ଜାବର୍ ସାମୁଆଁ ଏତେ ନାଡିଙ୍ଗ୍‍କେ ଆରି ତେରେପେତେ ଡିଂନାଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK10_42","072_10_42","LUK","10","42","42","ମାତର୍‌ ମୁଇଙ୍ଗ୍ ବିସୟ୍ ସାପା ବାନ୍ ଦର୍‌କାର୍; ମରିୟମ୍ ଆତେନ୍‌ ନିମାଣ୍ଡା ବିସୟ୍‌କେ ବାଚେବକେ ଆରି ଆତେନ୍‌ ମେଁ ବାନ୍ ଡୁଂଡ ଆୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_1","072_11_1","LUK","11","1","1","ମୁଇଂତର୍ ଜିସୁ ମୁଇଂଜାଗା ନ୍ନିଆ ପାର୍‍ତନା ଡିଙ୍ଗ୍ ଆଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍; ମେଁନେ ସିସ୍ଇଂବାନ୍ ମୁଇଂଜା ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଅ ମାପ୍ରୁ ଡୁବନ୍ ବିଣ୍ଡ୍ରେ ଜହନ୍‌ ଡିଡିକି ନିଜର୍‌ନେ ସିସ୍ଇଂକେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ନାମ୍ୟାକେ ନାନେ ଡିଗ୍ ଆନେକେ ଦେତୁଆ ଆଃ ସିକ୍ୟା ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_2","072_11_2","LUK","11","2","2","ଆତ୍‍ ଅରିଆ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଉଡ଼ିବେଲା ପେ ପାର୍‍ତନା ପେଡିଂଏ ଆତେନ୍‌ ବେଲା ବାସଙ୍ଗ୍‌ପା ଆବା ନାନେ ମ୍ନି ପବିତ୍ର ଡାଗ୍‌ଚେ ମାନେଃ ଆର୍‍ଲେ । ନାନେ ରାଇଜ୍ ପାଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_3","072_11_3","LUK","11","3","3","କାଲାଆଃ ଆନେକେ ଦର୍‌କାର୍ ଲେଃକ୍ନେ କାଦି ବିଃଲା । ");
INSERT INTO gaq_vpl VALUES ("LK11_4","072_11_4","LUK","11","4","4","ନେନେ ପାପ୍‍ ସାପା କେମା ଡିଙ୍ଗ୍, ଡାଗ୍ଲା ନେ ଡିଗ୍ ନେନେ ବିରଦ୍‌ରେ ଦସ୍ ଡିଙ୍ଗ୍‌ବକ୍ନେ ରେମୁଆଁଇଂକେ ସାପା କେମା ନେଡିଙ୍ଗ୍‍ଏ, ପରିକ୍ୟାନ୍ନିଆ ଆନେକେ ଡୁଂଆପାଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_5","072_11_5","LUK","11","5","5","ଆରି ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେନେ ଜାନେ ଦେକ୍‌ରକମ୍ ସାଙ୍ଗ ଲେଃକେ ଜା ଡାଗ୍ରା ମଜେ ମିଡିଗ୍ ୱେଚେ ବାସଙ୍ଗ୍ଏ ଏ ସାଙ୍ଗ ଆନେଙ୍ଗ୍‌କେ ଞ୍ଜିକ୍ଲିଗ୍‍ ରୁଟି ଉଦାର୍ ବିଲା । ");
INSERT INTO gaq_vpl VALUES ("LK11_6","072_11_6","LUK","11","6","6","ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ମୁଇଂଜା ସାଙ୍ଗ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ଲେଃକେ ଆମେକେ ଚଙ୍ଗ୍‌ନେ ବିଃନ୍‍ସା ନେଙ୍ଗ୍ ଡାଗ୍ରା ମେଃ ଣ୍ଡୁ ");
INSERT INTO gaq_vpl VALUES ("LK11_7","072_11_7","LUK","11","7","7","ଆରି ଆତେନ୍‌ ଡୁଆ ବିତ୍ରେବାନ୍‍ ଦେକ୍‍ରକମ୍‍ ଉତର୍ ବିଏ ଆନେଙ୍ଗ୍‌କେ କଷ୍ଟ ଆବିଗେ ନାମଃ; ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ବନ୍ଦ୍ ଡିଙ୍ଗେ ଆରି ନେଙ୍ଗ୍‌ନେ ଗଡ଼େଅ ନେଙ୍ଗ୍ ଏତେ ଡୁଲେଗ୍‍ ଲେଃକେ; ନେଙ୍ଗ୍ ତଡ଼ିଆଚେ ଆନାକେ ବିଃନାୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_8","072_11_8","LUK","11","8","8","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ମେଁ ସତେଆ ମେଁନେ ସାଙ୍ଗ ଣ୍ଡୁଲା ଆବି ଣ୍ଡୁ ତେଲା ଡିଗ୍ ମେଁ ମାଗୁଏଚଚେ ପ୍ରେଗ୍‍ ପ୍ରେଗ୍‍ ସାଲିଆ ଲେଲା ମେଁ ତଡ଼ିଆଚେ ମେଁନେ ଉଡ଼ି ଦର୍‌କାର୍ ଆମେକେ ଅଃତେନ୍‍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_9","072_11_9","LUK","11","9","9","“ନେଙ୍ଗ୍ ଡିଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ସାଲିଆପା ତେଲା ଆପେକେ ବିଏ; ତୁର୍‌ପା ତେଲା ପେବାଏ; ର୍ଣ୍ଣସାଙ୍ଗ୍‍ନ୍ନିଆ ବଗ୍‌ପା ତେଲା ପେଇଂନ୍‍ସା ରଃବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_10","072_11_10","LUK","11","10","10","ଡାଗ୍ଲା ଜା ସାଲିଆଏ ମେଁ ବାଏ; ଜା ତୁର୍‌ଏ ମେଁ ଅବାଏ; ଆରି ଜା ର୍ଣ୍ଣସାଙ୍ଗ୍‍ନ୍ନିଆ ବଗ୍‍ଏ ମେଁ ନ୍‍ସା ରଃ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_11","072_11_11","LUK","11","11","11","ଆରି ପେନେ ବିତ୍ରେ ଦେକ୍‌ରକମ୍ ଆବା ଜା ଲେଃକେ ଆଜାକେ ମେଁନେ ଉଙ୍ଗ୍‌ଡେ ଆଃଡ଼ ସାଲ୍ୟାଲା, ମେଁ ଆମେକେ ଆଃଡ଼ ମାବିଚେ ବୁବଃ ବିଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK11_12","072_11_12","LUK","11","12","12","ଣ୍ଡୁଲା ନ୍ତାସେଙ୍ଗ୍‍ ସାଲିଆ ମେଁ ଆମେକେ ଙ୍ଗୁଆରେଗ୍‍ ବିଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK11_13","072_11_13","LUK","11","13","13","ଏନ୍‌ସା ପେଇଂ ଦୁଷ୍ଟ ଡିଙ୍ଗ୍‌ଲା ଡିଗ୍ ପେ ନିଜର୍ ନିଜର୍ ଗଡ଼େଇଂକେ ନିମାଣ୍ତା ଜିନିସ୍ ବିପେଡିଙ୍ଗ୍‌କେ । ତେଲା ପେଇଂନେ କିତଂନେ ଆବା ଡାଗ୍ରା ଜାଣ୍ଡେଇଂ ସାଲ୍ୟାଏ ମେଁ ଆମେଇଂକେ ଆରି ଉଡ଼ି ନିମାଣ୍ତା ଜିନିସ୍ ଜବର୍ ବାବ୍‌ରେ ପବିତ୍ର ଆତ୍ମା ବିଏ ! ");
INSERT INTO gaq_vpl VALUES ("LK11_14","072_11_14","LUK","11","14","14","ମୁଇଂତର୍ ଜିସୁ ମୁଇଙ୍ଗ୍ ବୁତ୍‌ ସାଃକ୍ନେ କନ୍ଦା ରେମୁଆଁକେ ନିମାଣ୍ଡାଃ ଆଃଡିଂକେ । ଆତେନ୍‌ ବୁତ୍‌ କନ୍ଦା । ସେଆଁରେ ତାର୍ ୱେନେ ଇଡ଼ିଙ୍ଗ୍ କନ୍ଦା ରେମୁଆଁ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ ଆରି “ଆତ୍‍ ଅରିଆ ଲେଃକ୍ନେ ରେମୁଆଁ ଇରିଆଃତୁଗ୍‍ ଲେଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_15","072_11_15","LUK","11","15","15","ମାତର୍‌ ମେଇଂ ବାନ୍ ଜାଣ୍ଡେ ଜାଣ୍ଡେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ସେଆଁରେନେ ନେତା ବାଆଲ୍‌ଜିବୂଲନେ ବପୁ ଏତେ ଜିସୁ ଗଲିଆକେ ଆଃଆନ୍ତାର୍‌ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_16","072_11_16","LUK","11","16","16","ବିଃଣ୍ଡ୍ରେଇଂ ଜିସୁକେ ପାନ୍ଦ୍‌ନ୍ନିଆ ତ୍ଲାଗ୍ ନ୍‌ସା ଚାଏଁଡିଙ୍ଗେ । ତେଲା ଇସ୍‌ପର୍ ଜେ ମେଁନେ ଏତେ ଲେଃଗେ ଆକେନ୍ ଚିନ୍ ରକମ୍ ଇରିଆତୁଗ୍ କାମ୍ ମୁଇଙ୍ଗ୍ ଆସୁଏନେ ପଡ଼େଏ କିତଂବାନ୍ ମୁଇଙ୍ଗ୍ ଚିନ୍ ଆଃସୁଏ ନ୍‌ସା ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_17","072_11_17","LUK","11","17","17","ମାତର୍‌ ଜିସୁ ମେଇଙ୍ଗ୍‌ନେ ମନ୍‌ ଚିନ୍ତା ମ୍ୟାଲେଃକେ “ତେସା ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ମେଃଡିଗ୍‌ ରାଜିନ୍ନିଆ ଡାଆଁ ଜୁଦ୍‌ ଲାଗେଲା ଆତାନ୍‌ ରାଜିନ୍ନିଆ ନସ୍ଟ ଡିଙ୍ଗ୍‌ଏ ଆଡିନେ ଡୁଆ ୱିଙ୍ଗ୍‌ଆ ରିଙ୍ଗ୍‌ଆ ଡିଙ୍ଗ୍‌ଲା ଆତାନ୍‌ ଡୁଆ ପାକ୍‌ଚି ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_18","072_11_18","LUK","11","18","18","ଆରି ସ‍ଏତାନ୍‌ ଡିଗ୍ ବିନେ ଡିଙ୍ଗ୍‌ଚେ ନିଜେନେ ବିରଦ୍‌ରେ ନିଜେ ତଡ଼ିଆଡିଙ୍ଗ୍‍କେ ତେଲା ମେଁନେ ରାଇଜ୍ ଡିରକମ୍ ବୁଙ୍ଗ୍‍ ଲେଃଏ ? ନେଙ୍ଗ୍ ବାଆଲ୍‌ଜିବୂଲନେ ସାଇଜରେ ସେଆଁରେଇଂକେ ଆଆନ୍ତାର୍‍ ଡାଗ୍‌ଚେ ପେ ତ ବାସଙ୍ଗ୍‌ପେଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("LK11_19","072_11_19","LUK","11","19","19","ମାତର୍‌ ନେଙ୍ଗ୍ ଅଃନା ବାଆଲ୍‌ଜିବୂଲ ସାଇଜରେ ସେଆଁରେ ଆଆନ୍ତାର୍‍ ଣ୍ଡିଂକେ ତେଲା ପେନେ ଉଙ୍ଗ୍‌ଡେଇଂ ଜାନେ ସାଇଜରେ ଆମେଇଂକେ ଆଃଆନ୍ତାର୍‍ଏ ? ତେଲା ମେଇଂ ପେନେ ନିଜର୍‌ନେ ଗଡ଼େଅଇଂ ପାର୍‍ମାନ୍ ଡିଙ୍ଗ୍ ଆର୍‍ଏ ଜେ ପେଇଂ ବୁଲ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("LK11_20","072_11_20","LUK","11","20","20","ଣ୍ଡୁ ତେଲା ଇସ୍‌ପର୍‌ନେ ବପୁ ଏତେ ନେଙ୍ଗ୍ ସେଆଁରେଇଂକେ ଆଃଆନ୍ତାର୍‍ଣ୍ଡିଂକେ ଆରି ଏନ୍‌ ପାର୍‍ମାନ୍‍ ଡିଙ୍ଗ୍‍ଏ ଜେ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ପେନେ ଡାଗ୍ରା ପାଙ୍ଗ୍ ଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK11_21","072_11_21","LUK","11","21","21","ଡାଟ୍ ରେମୁଆଁ ଉଡ଼ିଜାକ ଅସ୍ତ୍ରସସ୍ତ୍ର ସାଚେ ଆର୍ମେଚେ ନିଜେନେ ଞ୍ଚ ରକ୍ୟା ଆଡିଙ୍ଗ୍‌ଏ, ଆତେନ୍‌ ଜାକ ମେଁନେ ଦନ୍ ସମ୍ପତି ଆରାମ୍‍ସେ ଲେଃଏ; ");
INSERT INTO gaq_vpl VALUES ("LK11_22","072_11_22","LUK","11","22","22","ମାତର୍‌ ଉଡ଼ିବେଲା ମେଁବାନ୍‍ ଜାବର୍ ବପୁ ରେମୁଆଁ ଆମେକେ ବାଗୁଏଃଚେ ମେଁ ଜିତେଏ ଆତେନ୍‌‌ ବେଲା ଆଣ୍ଡିନେ କାଣ୍ଡା ମେଁ ଆଡ଼ାତ୍ରା ଆସା ଡିଙ୍ଗ୍‍ବଏ, ଆତେନ୍‌‍ ସାପା ମେଁ ରାଃ ଡୁଂଡଏ ଆରି ମେଁନେ ଜିନିସ୍ ବାଟାଚେ ଡୁଂଡଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_23","072_11_23","LUK","11","23","23","ଜା ନେଙ୍ଗ୍ ଏତେ ଆମିସେ ଣ୍ଡୁ ମେଁ ସତେଆ ନେଙ୍ଗ୍‌ନେ ସାହା ମୁଡ଼ି ରେମୁଆଁ ରାଃସିଙ୍ଗ୍‌ନେ ନ୍‌ସା ଆନେଙ୍ଗ୍‌କେ ସାଆଜ୍ୟ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ, ମେଁ ଗୁଏଃଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_24","072_11_24","LUK","11","24","24","“ସେଆଁରେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁବାନ୍‍ ତାର୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଣ୍ଡିଆଃ ଣ୍ଡୁନେ ଜାଗା ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ପୁଣ୍ଡେନ୍‌ସା ତୁର୍ ଡିଙ୍ଗ୍ ଆରି ଆତେନ୍‌ ମାଅବାଚେ ବାସଙ୍ଗ୍ଏ ନେଙ୍ଗ୍ ଆଣ୍ଡିନେ ଡୁଆ ବାନ୍ ତାର୍‌ଚେ ପାଙ୍ଗ୍ ନ୍ଲେଗେ ନେଙ୍ଗ୍ ଆତେନ୍‌ ଡୁଆ ଆଣ୍ଡେ ୱିଗ୍‌ଏ; ");
INSERT INTO gaq_vpl VALUES ("LK11_25","072_11_25","LUK","11","25","25","ଆରି ମେଁ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ଚେ ପର୍‍ଚଲ୍‍ ଆରି ସଜେଚେ ବକ୍ନେ କେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_26","072_11_26","LUK","11","26","26","ଆତେନ୍‌ ବେଲା ବାଏରେ ୱେଚେ ମେଁନେ ବାନ୍ ମାଲେ ଦୁଷ୍ଟ ଆରି ଗୁକ୍ଲିଗ୍‍ ଆତ୍ମା ଏତେ ଡୁଙ୍ଗ୍‍ ପାଙ୍ଗ୍‌ଏ ଆରି ମେଇଂ ଗାଚେ ଆତ୍‍ ଅରିଆ ବାସା ଆର୍‌ଏ ବାରି ଆତେନ୍‌ ରେମୁଆଁନେ ପର୍‍ତୁମ୍ କସ୍ଟ ବାଦୁଲ୍ ଇଡ଼ିଙ୍ଗ୍ କସ୍ଟ ଜାବର୍ ଦଦ୍ୟା ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_27","072_11_27","LUK","11","27","27","ଜିସୁ ଆକେନ୍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ନେ ବେଲା ରେମୁଆଁଇଂନେ ବାନ୍ ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୟ୍‍ ଜାବର୍ କିରଚେ ବାସଙ୍ଗ୍‌କେ “ଦନ୍ୟ ନାନେ ସୁଲୁଏ ଜାଣ୍ଡେ ଆନାକେ ଜନମ୍ ବିବ ଆରି ଆତେନ୍‌ ତ୍ରାଡ଼ିଆ ଆଉଗ୍ ବକେ ଆତ୍‌ବା ନାନେ ନାବୁଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_28","072_11_28","LUK","11","28","28","ମାତର୍‌ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ନାନେ ଜାଣ୍ଡେଇଂ ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ ଅଁଆର୍‌ଏ ଆରି ପାଲେ ଆର୍‌ଏ ମେଇଙ୍ଗ୍ ଆଃ ଦନ୍ୟ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_29","072_11_29","LUK","11","29","29","ରେମୁଆଁଇଂ ମାନ୍ଦା ମାନ୍ଦା ଡିଙ୍ଗ୍‌ଚେ ମେଁନେ ଡାଗ୍ରା ମୁଇଂନ୍ନିଆ ଡିଙ୍ଗ୍‌ନେ ବେଲା ଜିସୁ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ ଏନ୍ ଆକେନ୍ ରେମୁଆଁଇଂ ଉଡ଼ି ଦୁଷ୍ଟ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଡିଙ୍ଗ୍‌କେ; ଆକ୍‌ମେଇଂ ଚିନା ତୁର୍‍ଆର୍‍ଏ ମାତର୍‌ ଯୁନସ୍‍ନେ ଚିନା ଆନ୍ତାର୍ଚେ ବିନେ ମେଃଡିଗ୍ ଚିନା ଆମେଇଂକେ ଆବି ଆର୍‌ଏ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK11_30","072_11_30","LUK","11","30","30","ଡାଗ୍ଲା ଯୁନସ୍ ଡିଡିକି ନିନୀବିନେ ନ୍‌ସା ଚିନା ରକମ୍ ଡିଙ୍ଗ୍‌କେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଡିଗ୍ ଦେତୁଆଆ ଏନ୍ ଆକେନ୍ ରେମୁଆଁନେ ସୁଗୁଆ ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_31","072_11_31","LUK","11","31","31","ଦକିନ୍‌ ଦେସ୍‌ନେ ରାନି ବିଚାର୍‍ନ୍ନିଆ ଏନ୍ ରେମୁଆଁ ଏତେ ତଡ଼ିଆଚେ ଆକ୍‌ମେଇଂକେ ଦସ୍ ଆଡିଙ୍ଗ୍ ଆର୍‌ଏ ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଁ ଶଲୋମନ୍‌ନେ ବୁଦିନେ ସାମୁଆଁ ଅଁନ୍‌ସା ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଆଃଡ଼ାବାନ୍ ପାଙ୍ଗ୍‌ଲେ ଆର୍‌ଗେ; ଆରି କେଲାପା ଶଲୋମନ୍‍ ବାଦୁଲ୍ ମ୍ନା ସାମୁଆଁ ଏନ୍ ଜାଗାନ୍ନିଆ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_32","072_11_32","LUK","11","32","32","ନିନୀବିନେ ରେମୁଆଁଇଂ ବିଚାର୍ ଦିନ୍ ଏନ୍ ଆକେନ୍ ରେମୁଆଁଇଂ ଏତେ ତଡ଼ିଆଚେ ଆକ୍‌ମେଇଂକେ ଦସ୍ ଆଡିଙ୍ଗ୍ ଆର୍‌ଏ, ଡାଗ୍ଲା ମେଇଂ ଯୁନସ୍‍ନେ ବାସଙ୍ଗ୍‌କ୍ନେ ବାନ୍ ମନ୍‍କେ ଆବଦ୍ଲେ ବଆର୍‌ଗେ; ଆରି କେଲାପା ଯୁନସ୍‍ ବାନ୍ ମ୍ନା ବିସୟ୍ ଏନ୍ ଜାଗାନ୍ନିଆ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_33","072_11_33","LUK","11","33","33","ଜା କୁପିସ ଆଃଡୁଆଚେ ବୁଡ଼ିଚେ ଆବଣ୍ଡୁ ଣ୍ଡୁଲା ଙ୍କୁଇ ବୁନ୍ଦେ ଆବ ଣ୍ଡୁ ମାତର୍‌ କୁପିସ ବମ୍ୟାକ୍ନେ ଆଡ଼ାତ୍ରା ବଏ ଡିଡିକି ବିତ୍ରେ ଗାକ୍ନେ ରେମୁଆଁଇଂ ତାର୍‌କିଗ୍‌କ୍ନେ କେୟାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_34","072_11_34","LUK","11","34","34","ପେନେ ମୁଆଃ ଗାଗ୍‌ଡ଼େନେ କୁପିସ । ଉଡ଼ିବେଲା ପେନେ ମୁଆଃ ଅଃନା ପର୍‌ଚଲ୍‌ ଲେଃଏ, ଅଃତେନ୍‍ ବେଲା ପେନେ ସାପା ଗାଗ୍‌ଡ଼େ ତାର୍କିଗ୍‍ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଏ; ମାତର୍‌ ଉଡ଼ିବେଲା ଆତେନ୍‌ ଆର୍ଲା ଲେଃଏ ଅଃତେନ୍‍ ବେଲା ପେନେ ଗାଗ୍‌ଡ଼େ ଡିଗ୍ ସାପା ଆତାଙ୍ଗ୍‌କିଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_35","072_11_35","LUK","11","35","35","ତରକ୍ ଲାଲାପା ଡିଡିକି ପେନେ ଜିବନ୍‍ରେ ତାର୍କିଗ୍‍ ଆତାଙ୍ଗ୍‌କିଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_36","072_11_36","LUK","11","36","36","ତେଲା ପେନେ ସାପା ଗାଗ୍‌ଡ଼େ ତାର୍କିଗ୍‍ଏ ଆରି ଆତ୍‍ ଅରିଆ ମେଃଣ୍ଡିଗ୍ ସିର୍‍ ଆତାଙ୍ଗ୍‌କିଗ୍‌ଲେ ତେଲା କୁପିସ ଡିଡି ତାର୍କିଗ୍‍ ତାରାସ୍ ଆପେକେ ତାର୍କିଗ୍‍ ବିଏ ଦେତୁଆଆ ପେନେ ତାର୍କିଗ୍‍ ଜିବନ୍ ତାର୍କିଗ୍‍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_37","072_11_37","LUK","11","37","37","ଜିସୁ ବାସଙ୍ଗ୍‌ନେ ବେଲା ମୁଇଙ୍ଗ୍ ଫାରୁଶୀ ଜିସୁକେ ନିଜେନେ ଡୁଆନ୍ନିଆ ଚଙ୍ଗ୍‍ନେସା ୱାକେ ଆରି ଆତେନ୍‌ ଡୁଆନ୍ନିଆ ଗାଚେ ଚୁଚଙ୍ଗ୍‍ନିଆ କକେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_38","072_11_38","LUK","11","38","38","ମାତର୍‌ ଚଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ମାଗୁଏତି ମାଗୁଏଚ ଲେଃଗେ ଆତେନ୍‌ କେଚେ ପାରୁସି କାବା ଡିଙ୍ଗ୍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_39","072_11_39","LUK","11","39","39","ଆତ୍‍ ଅରିଆ ମାପ୍ରୁ ବାସଙ୍ଗ୍‌କେ “ପେ ପାରୁସିଇଂ ତାଲି ଗିନା ବାଏରେ ପର୍‌ଚଲ୍‌ ଡିଙ୍ଗ୍‌ପା । ମାତର୍‌ ପେନେ ବିତ୍ରେ ଡଙ୍ଗା ଚଙ୍ଗ୍‍ନେ ଦୁଷ୍ଟ ଡିଂପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_40","072_11_40","LUK","11","40","40","ଅ ନିର୍ବୁଦି ଜା ବାଏରେ ତିଆର୍ ଆଡିଙ୍ଗ୍‌କେ ମେଁ କି ବିତ୍ରେ ଡିଗ୍ ତିଆର୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("LK11_41","072_11_41","LUK","11","41","41","ପେନେ ମେଁନେ ସାପା ଲେଃକେ; ଆତେନ୍‌ ଦାନ୍ ବିଃପା ତେଲା ପେ ନିମାଣ୍ଡା ପେଲେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_42","072_11_42","LUK","11","42","42","“ଅ ପାରୁସିଇଂ ପେନେ ସାରାସାରି ଡଣ୍ଡ୍‍ ବଡ଼େ ବୟଙ୍କାର୍ ଡିଙ୍ଗ୍‌ଏ ! ପେ ପୋଦିନା, ଆମାଃ ସାପାନେ ଗୁଆ ବାଗ୍ ବାନ୍‌ ମୁଇଂ ବାଗ୍‌ ଇସ୍‌ପର୍‌କେ ବିବପା । ଡାଗ୍ଲା ନ୍ୟାୟ୍ ବିଚାର୍ ବାରି ଇସ୍‌ପର୍‌ନେ ଆଡ଼ାତ୍ରା ଆଲାଦ୍ ଅବଏଲା ଡିଙ୍ଗ୍‌ପେବଏ; ଏନ୍‌କେ ମ୍ନାଃ ଜାଗା ବିଃପା; ବିନ୍‌ ଇଂ ବିସୟ୍ ସାପା ଡିଗ୍‌ ଅବଏଲା ଆଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_43","072_11_43","LUK","11","43","43","“ଅ ଫାରୁଶୀ‍ଇଂ ପେନେ ଡଣ୍ଡ୍‍ ମ୍ନା ବୟଙ୍କାର୍‌ । ଡାଗ୍ଲା ପେଇଂ ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ମ୍ନା ଆସନ୍‌ ବାରି ସାନ୍ତାନ୍ନିଆ ନମସ୍କାର୍ ବାନ୍‍ସା ଆଲାଦ୍ ନାଡିଂଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_44","072_11_44","LUK","11","44","44","ଆୟ ପେଇଂ ଡଣ୍ଡ୍‍ ପେବାଏ ମେନ୍‌ସା ଡାଗ୍ଲା ପେ ବୁଡ଼ି ପେଲେକ୍ନେ ଆତେନ୍‌ ରାଃଚ୍ୟା ଡୁଆ ସୁଗା ଜା ଆଡ଼ାତ୍ରା ରେମୁଆଁଇଂ ମାମ୍ୟାଚେ ଅଲେଙ୍ଗ୍‍ ୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_45","072_11_45","LUK","11","45","45","ଆତ୍‍ ଅରିଆ ଦର୍ମ ସାସ୍ତ୍ରିନେ ମୁଇଂଜା ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଅ ଗୁରୁ ଏନ୍‍ ବାସଙ୍ଗ୍‌ଚେ ନାନେ ଆନେକେ ଡିଗ୍ ଅପ୍‍ମାନ୍‍ ଡିଙ୍ଗ୍ ନାଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_46","072_11_46","LUK","11","46","46","ଜିସୁ ଉତର୍ ବିକେ “ଏ ଦର୍ମ ସାସ୍ତ୍ରିଇଂ ମେଃନ୍‌ସା ଡାଗ୍ଲା ପେ ରେମୁଆଁଇଂ ଆଡ଼ାତ୍ରା ଡାଟ୍‍ନେ ନିଅମ୍‌ନେ ଅଜନ୍‌ ଜାବର୍ ଲାଦେ ପେଡିଙ୍ଗ୍ ଜେ ଆତେନ୍‌ ମାନେନ୍‍ସା କଷ୍ଟ ଲାଗେ ଡିଙ୍ଗ୍ । ଏନ୍ ନିୟମ୍‌ ମାନେନ୍‍ସା ଆପେକେ ରେମୁଆଁଇଂକେ ଡିଗ୍ ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ମାତର୍‌ ନିଜେ ଅଃନାଡିଗ୍ ଆକ୍‌ବାନ୍ ମେଃଣ୍ଡିଗ୍‌ ମୁଇଙ୍ଗ୍ ଡିଗ୍ ନିୟମ୍‌ ପାଲେନ୍‍ସା ସାହା ପେଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK11_47","072_11_47","LUK","11","47","47","ଆୟ ପେଇଂ ଡଣ୍ଡ୍ ପେବାଏ ଡାଗ୍ଲା ପେଇଂ ବାବବାଦିଇଂନେ ସବାକ୍ନେ ରାଃଚ୍ୟା ଆର୍ମେ ବପା ଜାଣ୍ଡେଇଂକେ ପେନେ ନ୍ତାଞ୍ଜା ଆଃ ଆମେଇଂକେ ବାଗୁଏଃ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK11_48","072_11_48","LUK","11","48","48","ନାନେ ତେଲା ଆତେନ୍‌‍ସା ପେଇଂନେ ପେନ୍ତା ପେଞ୍ଜାଃ କାମ୍ ବିସୟ୍‌ରେ ପେଇଂ ସାକି ପେଲେକେ ଆରି ଆତେନ୍‌ ଏତେ ପେଡିଙ୍ଗ୍‌କେ ଡାଗ୍ଲା ମେଇଂ ସିନା ଆମେଇଂକେ ବାଗୁଏଃ ବଗେ ମାତର୍‌ ପେଇଂ ମେଇଂନେ ଗୁଡ଼ୁମ୍‍ ଆରେ ବପା । ");
INSERT INTO gaq_vpl VALUES ("LK11_49","072_11_49","LUK","11","49","49","ଆତେନ୍‌‍ସା ଇସ୍‌ପର୍ ଡିଗ୍ ନିଜେ ବୁଦିନେସା ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ନେଙ୍ଗ୍‌ ମେଇଙ୍ଗ୍‌ନେ ବାବବାଦି ଆରି କବର୍ ଆଃୱେଚାଣ୍ଡ୍ରେକେ ମେଇଂ ଡାଗ୍ରା ବେନେଡିଙ୍ଗ୍‍; ମେଁଇଂନେ ଆଜା ଆଜାକେ ମେଇଂ ବାଗୁଏଃ ଆର୍‌ଏ ଆରି ଆଜା ଆଜାକେ ତାଡ଼୍‍ନା ଡିଙ୍ଗ୍ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_50","072_11_50","LUK","11","50","50","ଏନ୍ ଜୁଗ୍‌ନେ ରେମୁଆଁଇଂ ମଞ୍ଚ୍‌ପୁର୍‌ ତିଆର୍‌ ଡିଙ୍ଗ୍‌ନେ ସେନୁଗ୍‌ ସାପା ବାବବାଦି ଇଂନେ ବାଗୁଏଃକ୍ନେସା ଡଣ୍ଡ୍ ବାଆର୍‌ଏ ");
INSERT INTO gaq_vpl VALUES ("LK11_51","072_11_51","LUK","11","51","51","ହେବଲନେ ମରନ୍‌ବାନ୍ ଆରାମ୍ ଡିଂଚେ ଯିଖରିୟନେ ଜାକ ଆଜାକେ ବେଦି ଆରି ପବିତ୍ର ଟାନ୍ ବିତ୍ରେ ବାଗୁଏ ବ‍ଆର୍‌ଗେ । ନିଂ ଆପେକେ ବାସଙ୍ଗ୍‌ଡିଂକେ ଆକେନ୍ ଜୁଗ୍‌ନେ ରେମୁଆଁଇଂ ଆତେନ୍‌ ସାପା ନ୍‌ସା ଡଣ୍ଡ୍ ବାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK11_52","072_11_52","LUK","11","52","52","ଅ ଦର୍ମ ସାସ୍ତ୍ରି ! ପେ ଡଣ୍ଡ୍ ପେବାଏ ମେଃନ୍‌ସା ଡାଗ୍ଲା ପେ ଇସ୍‌ପର୍‌ନେ ନିୟମ୍‌ କୁଚିକାଡ଼ି ବୁଃଡ଼ି ପେବିଗେ । ନିଜେ ଇସ୍‌ପର୍‌ନେ ନିମାନ୍‍ ବୁଦି ପେସିକେକେ ଣ୍ଡୁ ଲେଃ ଜାଣ୍ଡେଇଂ ସିକେ ନ୍‍ସା ଇକ୍‌ଚା ଲେଃଗେ ଆମେଇଂକେ ଡିଗ୍ ସିକେ ନ୍‍ସା ପେବିକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK11_53","072_11_53","LUK","11","53","53","ଆରି ଜିସୁ ଆତ୍‌ବାନ୍ ତାର୍‍ୱେଗେ ଇଡ଼ିଙ୍ଗ୍ ଦର୍ମ ଗୁରୁ ଆରି ପାରୁସିଇଂ ଗିସେ ଡିଙ୍ଗ୍‌ଚେ ");
INSERT INTO gaq_vpl VALUES ("LK11_54","072_11_54","LUK","11","54","54","ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଇଙ୍ଗ୍ ଜିସୁକେ ମେଃଣ୍ଡିଗ୍ ଦଦ୍ୟା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ଲା ନେନେ ପାନ୍ଦ୍‌ନ୍ନିଆ ନେତ୍ଲାଗ୍‍ ଡାଗ୍‌ଚେ ଗାଲି ପ୍ରସ୍‌ନ ସାଲ୍ୟାକୁ ଆର୍‌ଡିଙ୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK12_1","072_12_1","LUK","12","1","1","ଅଜାର୍ ଅଜାର୍ ରେମୁଆଁ ପାଙ୍ଗ୍‌ ରିସିଂଚେ ମେଇଂମେଇଂ ଆଡ଼ାତ୍ରା ଟେଚା ଡୁଂପାଂଡିଂଆର୍‌ଗେ; ଆତେନ୍‌ ବେଲା ଜିସୁ ସେନୁଗ୍‍ ମେଁନେ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ, ଫାରୁଶୀଇଂନେ ଖମୀରବାନ୍‍ ସ୍ଲ ଲାଲାପା, ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ନେ ମେଃନେ ଡାଗ୍ଲା ମେଇଂ କୁଟ୍ ଜଗ୍‍ଣ୍ଡ୍ରେ ତରକ୍ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("LK12_2","072_12_2","LUK","12","2","2","ବୁଡ଼ି ଲେଃକ୍ନେ ସପା ଜିନିସ୍‌କେ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ବୁଡ଼ି ଲେଃକ୍ନେ ସାପା ବିସ‍ଏକେ ତ୍ନାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_3","072_12_3","LUK","12","3","3","ପେଇଂ ମେଃନେ ତାଂକିଗ୍‌ନିଆ ବାସଙ୍ଗ୍‌ ପେବଏ ଆତେନ୍‌ ସାପା ସ୍ମିବେଲା ଆ‍ଃଅଁଏ ଆରି ମେଁନେ ଡୁଆ ବିତ୍ରେ ବୁଃଡ଼ି ଲେଃକେ ଆତେନ୍‌ ସାପା ରେମୁଆଁ ଣ୍ଡୁ ନେନେ ଜାଗାନ୍ନିଆ ବାସଙ୍ଗ୍‌ ପେବକେ । ଆତେନ୍‌ ବ୍ଲେସାଂ ଆଡ଼ାତ୍ରା ବାଲିର୍‍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_4","072_12_4","LUK","12","4","4","ଏ ନେଙ୍ଗ୍‍ନେ ସାଙ୍ଗଇଂ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଜାଣ୍ଡେଇଂ ଗାଗ୍‌ଡ଼େକେ ବାଗୁଏଃଆର୍‌ଏ, ମାତର୍‌ ଇଡ଼ିଙ୍ଗ୍ ମେଃଡିଗ୍ ଡିଙ୍ଗ୍ ଆୟାଆର୍‍ ଣ୍ଡୁ ଆମେଇଂକେ ଆପ୍‍ଟଗ୍‍ପା । ");
INSERT INTO gaq_vpl VALUES ("LK12_5","072_12_5","LUK","12","5","5","ମାତର୍‌ ଆଜାକେ ପେବ୍‌ଟଏ, ଆତେନ୍‌ ନେଙ୍ଗ୍ ଆପେକେ ଣ୍ଡ୍ରାମ୍ୟାଏ; ବାଗୁଏଃକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ନର୍କନ୍ନିଆ ତ୍ଲାଗ୍‍ନ୍‍ସା ମୁଡ଼ି ଇସ୍‌ପର୍‌ନେ ଅଦିକାର୍ ଲେଃକେ ଆମେକେ ବୁଟପା; ସତେଆ ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଆମେକେ ବୁଟପା । ");
INSERT INTO gaq_vpl VALUES ("LK12_6","072_12_6","LUK","12","6","6","“ମ୍ବାକ୍ଲିଗ୍ କିଆପିଗ୍‌କେ ମେଃନେ ମ୍ବାକ୍ଲିଗ୍ ଡାବୁରେ ଆସ ଣ୍ଡୁ ? ତେଲାଡିଗ୍ ଇସ୍‌ପର୍ ମୁଇଙ୍ଗ୍ କିଆପିଗ୍‌କେ ଣ୍ଡିଗ୍ ଆଆବ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK12_7","072_12_7","LUK","12","7","7","ମାତର୍‌ ପେନେ ବାଆଃନେ ସର୍‌ତେ ଉଗ୍‌ବ ଇସାବ୍ ଡିଙ୍ଗ୍‌ବକେ । ଆବ୍‌ଟଗେପା; ପେ ଗୁଲୁଏ କିଆପିଗ୍ ବାନ୍ ମ୍ନା ।” ");
INSERT INTO gaq_vpl VALUES ("LK12_8","072_12_8","LUK","12","8","8","ଆରି ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଙ୍ଗ୍‍, ଜାଣ୍ଡେକି ରେମୁଆଁଇଂ ଡାଗ୍ରା ଆନେଙ୍ଗ୍ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ବାଲିର୍‍ ଆର୍‍ଏ, ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଡିଗ୍ ଇସ୍‌ପର୍‌କେ ଦୁତ୍‍ଇଂ ସାର୍ମୁଆଁ ଡାଗ୍ରା ମ୍ୟାନ୍ଲେକେ ଡାଗ୍‌ଚେ ଆମେକେ ବାସଙ୍ଗ୍‍ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_9","072_12_9","LUK","12","9","9","ମାତର୍‌ ମୁଡ଼ି ରେମୁଆଁଇଂନେ ସାକ୍ୟନ୍ନିଆ ଆନେଙ୍ଗ୍ ଅବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଏ, ମେଁ ଇସ୍‌ପର୍‌ନେ ଦୁତ୍ଇଂନେ ସାକ୍ୟନ୍ନିଆ ଆମେକେ ନ୍ନାମ୍ୟାକେ ଣ୍ଡୁ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_10","072_12_10","LUK","12","10","10","ଆରି ମୁଡ଼ି ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେନେ ବିରଦ୍‌ରେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଏ ଆମେକେ କେମା ଡିଙ୍ଗ୍ ବିଆର୍‌ଏ; ମାତର୍‌ ଜା ପବିତ୍ର ଆତ୍ମାନେ ବିରଦ୍‌ରେ ନିନ୍ଦା ସାମୁଆଁ ବାସଙ୍ଗ୍ଏ ଆମେକେ କେମା ଆବିଆର୍‍ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK12_11","072_12_11","LUK","12","11","11","ଆରି ଉଡ଼ିବେଲା ଜିଉଦିଇଂ ଆପେକେ ପାର୍‌ତନା ଡୁଆନିଆ ଆରି ସାସନ୍‍ ଆରି କେମା ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେନିଆ ଡୁଂପାଙ୍ଗ୍‌ଏ, ଆତେନ୍‌ ବେଲା ପେ ନିଜେନେସା ଡିରକମ୍ ଉତର୍ ପେବିଏ କି ମେଃନେ ପେବାସଙ୍ଗ୍‌ଏ, ଆତେନ୍‌ ବିସୟ୍‌ରେ ଚିନ୍ତା ଆଡିଙ୍ଗ୍‌ପା ନାମଃ; ");
INSERT INTO gaq_vpl VALUES ("LK12_12","072_12_12","LUK","12","12","12","ଡାଗ୍ଲା ମେଁନେ ବାସଙ୍ଗ୍‌ଲା ଡିଙ୍ଗ୍‌ଏ ଏନ୍ ପବିତ୍ର ଆତ୍ମା ଆତେନ୍‌‍ବେଲା ଆପେକେ ଆମ୍ୟା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_13","072_12_13","LUK","12","13","13","ରେମୁଆଁଇଂବାନ୍‍ ମୁଇଂଜା ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଅ ଗୁରୁ ନେଙ୍ଗ୍ ନେନାଙ୍ଗ୍‍କେ ନେଙ୍ଗ୍ ଏତେ ନେବାନେ ସମ୍ପତ୍ତି ବାଟା ବିଃନ୍‍ସା ବାସଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("LK12_14","072_12_14","LUK","12","14","14","ମାତର୍‌ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଏ ସାଙ୍ଗ ଜାଣ୍ଡେ ଆନେଙ୍ଗ୍‌କେ ପେନେ ଆଡ଼ାତ୍ରା ବିଚାର୍‍ ଡିଙ୍ଗ୍‍ନେ ଆରି ବାଟା ବିଃନ୍‍ସା ଜା ଆନେଙ୍ଗ୍‌କେ ଅଦିକାର୍ ବିବକେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK12_15","072_12_15","LUK","12","15","15","ଆରି ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ତରକ୍ ସାପା ରକମ୍‍ନେ ଲବ୍‌ବାନ୍‍ ନିଜେ ନିଜେକେ ସ୍ଲ ବପା ମେଃନ୍‌ସା ଡାଗ୍ଲା ମୁଇଙ୍ଗ୍ ରେମୁଆଁନେ ଜିବନ୍ ମେଁନେ ସମ୍ପତ୍ତି ଆଡ଼ାତ୍ରା ଆସା ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK12_16","072_12_16","LUK","12","16","16","ଆରି ଜିସୁ ଆମେଇଂକେ ଏନ୍ ଉଃସ୍ରା ବାସଙ୍ଗ୍‌କେ “ମୁଇଙ୍ଗ୍ ସାକାର୍‍ ରେମୁଆଁନେ ଲିଜନ୍ନିଆ ଜାବର୍ ଚୁକେ । ");
INSERT INTO gaq_vpl VALUES ("LK12_17","072_12_17","LUK","12","17","17","ଆତ୍‌ଅରିଆ ମେଁ ଏତେଚେ ବାସଙ୍ଗ୍‌କେ ମେଁ ଣ୍ଡିଙ୍ଗ୍‍ଏ ? ମେଃନ୍‌ସା ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ କିଆଉଁଆଃ ଗୁଆଚେ ବୁବନେ ଜାଗା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK12_18","072_12_18","LUK","12","18","18","ବାରି, ମେଁ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଦେକ୍‌ ଣ୍ଡିଂଏ; ନେଙ୍ଗ୍‌ନେ ଆଣ୍ଡ୍ରାଃ ସାପା ପାକ୍‍ଚିଚେ କିଆ ବାରି ବିନ୍‌ବିନ୍‌ ଜିନିସ୍ ସାପା ବୁବନ୍‌ସା ବାରି ମ୍ନା ମ୍ନା ଆଣ୍ତ୍ରା ତିଆର୍‌ ଣ୍ତିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_19","072_12_19","LUK","12","19","19","ଆରି ନେଙ୍ଗ୍‌ନେ ପାରାନ୍‌କେ ମ୍ବାସଙ୍ଗ୍‍ଏ ଏ ପାରାନ୍‍ ଉଡ଼ି ମୁଆଁ ନ୍‍ସା ନାନେ ଜାବର୍ କିଆ ଜତ୍ନେଚେ ମ୍ବକେ ପୁଣ୍ଡେପା ଚଙ୍ଗ୍‌ପା ଉଗ୍‍ପା ସାର୍ଦା ଲାଃଲା !” ");
INSERT INTO gaq_vpl VALUES ("LK12_20","072_12_20","LUK","12","20","20","ମାତର୍‌ ଇସ୍‌ପର୍ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଅ ବୁଦି ଣ୍ଡୁଣ୍ଡ୍ରେ ଏନ୍ ମିଡିଗ୍ ନାନେ ଜିବନ୍ ନାନେବାନ୍ ଡୁଙ୍ଗ୍‌ୱେଏ; ଆତ୍‍ ଅରିଆ ନା ମେଃନେ ନିଜେ ନ୍‍ସା ରାଃସିଙ୍ଗ୍‍ ନାବକେ, ଆତେନ୍‌ ସାପା ଜାନେ ଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK12_21","072_12_21","LUK","12","21","21","ଜିସୁ ଆରି ବାସଙ୍ଗ୍‌କେ “ଜା ନିଜେ ନ୍‍ସା ଦନ୍ ସମ୍ପତ୍ତି ରାଃସିଙ୍ଗ୍‍ ବଏ ମାତର୍‌ ଇସ୍‌ପର୍‌ନେ ମୁଆଃନ୍ନିଆ ସାକାର୍‍ ଣ୍ଡୁ ମେଁନେ ଆଡ଼ାତ୍ରା ଦେକ୍‌ରକମ୍ ଗଟେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK12_22","072_12_22","LUK","12","22","22","ଜିସୁ ନିଜେନେ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଆତେନ୍‌‍ସା ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ, ମେଃନେ ପେଚଙ୍ଗ୍‍ଏ ଦେକ୍‌ରକମ୍ ବାସଙ୍ଗ୍‌ଚେ ପେନେ ଜିବନ୍‍ସା ମେଁନେ ପେସଃଏ ଦେକ୍‌ରକମ୍ ବାସଙ୍ଗ୍‌ଚେ ପେନେ ଗାଗ୍‌ଡ଼େ ନ୍‌ସା ଡିଗ୍ ଚିନ୍ତା ଆଡିଙ୍ଗେପା । ");
INSERT INTO gaq_vpl VALUES ("LK12_23","072_12_23","LUK","12","23","23","ମେଃନ୍‌ସା ଡାଗ୍ଲା ଚଙ୍ଗ୍‍ନେ ବାଦୁଲ୍ ପାରାନ୍‌ ବାରି ପାଟାଇ ବାଦୁଲ୍ ଗାଗ୍‌ଡ଼େ ମ୍ନା । ");
INSERT INTO gaq_vpl VALUES ("LK12_24","072_12_24","LUK","12","24","24","ଗିଗ୍ୟାଃ ପିଗ୍ଇଂନେ ବିସୟ୍‌ରେ ଏତେ କେଲାପା ମେଇଂ ଆବିଗ୍‌ଆର୍‌ ଣ୍ତୁ କି ଆୱେଆର୍‌ ଣ୍ତୁ, ଆରି ମେଁଇଂନେ କିଆ ଉଁଆଃ ବନେ ଡୁଆ ଣ୍ଡୁ ଆରି ଇସ୍‌ପର୍ ଆମେଇଂକେ ଚଙ୍ଗ୍‌ନ୍‌ସା ବିଏ; ପେ ପ୍ଲିଗ୍‍ଇଂ ବାନ୍ ପେ ଉଡ଼ି ମ୍ନା ! ");
INSERT INTO gaq_vpl VALUES ("LK12_25","072_12_25","LUK","12","25","25","ଆରି, ପେନେ ବାନ୍ ଜା ଏତେ ଏତେଚେ ନିଜେନେ ଆୟୁସ୍‍କେ ଆମ୍ନା ପେୟାଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK12_26","072_12_26","LUK","12","26","26","ତେଲା ପେ ଜଦି ସାପାବାନ୍‍ ଡାଆଁ ବିସୟ୍‌ରେ ଡିଙ୍ଗ୍ ପେୟାଣ୍ଡୁ ତେଲା ବିନ୍ ସାପା ବିସୟ୍‌ରେ ମ୍ନାମ୍ନା କାମ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ମେଃନ୍‌ସା ତାନ୍ଦ୍ରା ଡିଙ୍ଗ୍ ନାଡିଙ୍ଗ୍‍ ? ");
INSERT INTO gaq_vpl VALUES ("LK12_27","072_12_27","LUK","12","27","27","କଣ୍ଡାନେ ସାରି ବିସୟ୍‌ରେ ଏତେ କେଲାପା ମେଇଂ ଡିରକମ୍ ସୁତା ଆଗୁଆର୍‌ ଣ୍ତୁ କି ଏତେ ଆର୍‌ଏ ଣ୍ତୁ ଏଲେଡିଗ୍ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଜେ ଶଲୋମନ୍ ଡିଗ୍ ନିଜେନେ ଦନ୍ ସମ୍ପତି ଲେଃଚେ ଏନ୍ ସାପା ବିତ୍ରେ ମୁଇଂଡିଗ୍‌ ସବା ଆଲେଃକେ ଣ୍ତୁ ? ");
INSERT INTO gaq_vpl VALUES ("LK12_28","072_12_28","LUK","12","28","28","ମାତର୍‌ ଆଣ୍ଡିନେ ଚେଃମୁଆଁ ଏକେ ଲିଜନ୍ନିଆ ଲେଃକେ ଆରି ଞ୍ଜଡ଼େ ତୃଗ୍‍ସନିଆ ତ୍ଲାଗ୍ ବିଃଆର୍‌ଏ ଆମେକେ ଅଃନା ଇସ୍‌ପର୍ ଦେକ୍‌ରକମ୍ ସବା ବିଏ ତେଲା ଏ ଇକୁଡ଼ା ସତ୍‍ ମାନେଃକେଣ୍ଡ୍ରେ ମେଁ ଆପେକେ ଉଡ଼ି ଜାବର୍ ସବା ଆବି ଣ୍ଡୁ !” ");
INSERT INTO gaq_vpl VALUES ("LK12_29","072_12_29","LUK","12","29","29","ଆରି ମେଃନେ ନେଚଙ୍ଗ୍‍ଏ ଆରି ମେଁନେ ନେଉଗ୍‍ଏ, ଆତେନ୍‌ ପେ ଆତୁର୍‌ଗେପା କି ଚିନ୍ତା ଆଡିଙ୍ଗେପା, ");
INSERT INTO gaq_vpl VALUES ("LK12_30","072_12_30","LUK","12","30","30","ମାତର୍‌‌ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ବିଜାତି ରେମୁଆଁଇଂ ଇସ୍‌ପର୍‌କେ ମାମ୍ୟାଚେ ଏନ୍ ସାପା ବିସୟ୍‌ରେ ତେରେପେତେ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ଏନ୍ ସାପା ବିସୟ୍ ଦର୍‌କାର୍‌ ପେଇଂନେ ଆବା ମ୍ୟାଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK12_31","072_12_31","LUK","12","31","31","ପେ ଆଣ୍ଡିନେ ବିସୟ୍‌ରେ କିକେନେ ଦର୍‌କାର୍ ଆତେନ୍‌ ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ କିତଂନେ ରାଇଜ୍ । ତେଲା ଆପେକେ ଦର୍‌କାର୍ ଡିଂକ୍ନେ ଏନ୍ ସାପା ବିସୟ୍ ଆପେକେ ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_32","072_12_32","LUK","12","32","32","ଅ ଡାଆଁନେ ମେଣ୍ଡାଇଂ ଆପ୍‍ଟଗ୍‍ପା ଡାଗ୍ଲା ପେଇଂନେ ଆତେନ୍‌ ରାଇଜ୍‍ ବିନ୍‍ସା ଆପେକେ ପର୍‌ମେସର୍‌ ଚାଏଁଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK12_33","072_12_33","LUK","12","33","33","ପେନେ ଦନ୍ ସମ୍ପତ୍ତି ଲେଃକେ ଆତେନ୍‌ ସ ବିଃଚେ ଆତେନ୍‌ ଡାବୁକେ ଗରିବ୍‍ ରେମୁଆଁଇଂକେ ବାଟା ବିଃପା । ଏନ୍ ସଂସାର୍‍ନେ ଦନ୍ ସମ୍ପତ୍ତି କାଲାଆଃ ଆଲେଃଣ୍ଡୁ । ତେଲା କାଲାଆଃ ଲେଃଡିଙ୍ଗ୍‌କ୍ନେ ଦନ୍ ସମ୍ପତ୍ତି ରାଃସିଙ୍ଗ୍‍ପା । ନିଜେ ନ୍‍ସା କିତଂନ୍ନିଆ ପେନ୍‌ସା ଦନ୍‌ସମ୍ପତି ରାଃସିଙ୍ଗ୍‌ପା, ଡାଗ୍‍ଲା ଆତ୍‍ ଅରିଆ ମେଃଡିଗ୍ ଡଙ୍ଗାରେ ଆଗା ଣ୍ଡୁ ଆରି ମେଃଡିଗ୍ ବୁକେଉଙ୍ଗ୍‍ ଆଚଙ୍ଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK12_34","072_12_34","LUK","12","34","34","ଡାଗ୍ଲା ଆଣ୍ଡି ଅରିଆ ପେନେ ଦନ୍, ଆତ୍‍ଅରିଆ ଡିଗ୍ ପେନେ ମନ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK12_35","072_12_35","LUK","12","35","35","ପେଇଂନେ ନ୍‌ସା ଗାଗ୍ ବପା ଆରି ପେନେ କୁପିସ ଡୁଆ ଲେଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK12_36","072_12_36","LUK","12","36","36","ଆରି ମାପ୍ରୁ ବିହେ ବଜିବାନ୍‍ ଆଣ୍ଡେ ୱିଗ୍‌ଚେ କାପାଟ୍‍ନ୍ନିଆ ବଗ୍‌ନେ ଦାପ୍ରେ ମୁଡ଼ି ରେମୁଆଁ ୱେଚେ କାପାଟ୍ ରଃନ୍‍ସା ଲେଃଏ ପେ ମେଇଂ ସୁଗା ଡିଙ୍ଗ୍‌ଚେ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("LK12_37","072_12_37","LUK","12","37","37","ମାପ୍ରୁ ପାଙ୍ଗ୍‌ଚେ ମୁଡ଼ି ଚାକର୍‌ଇଂକେ ଜାଗ୍ରତ୍ ଲେଃକ୍ନେ କେଏ ମେଇଂ ଦନ୍ୟ; ନେଙ୍ଗ୍ ଆପେ ସାପାରେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ମେଁ ନିଜେନେ ନ୍‌ସା ଗାଗ୍‌ଚେ ଆମେଇଂକେ ଚଙ୍ଗ୍‌ନ୍ନିଆ ଆକଚେ ଡାଗ୍ରା ୱେଚେ ସେବା ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_38","072_12_38","LUK","12","38","38","ଆରି ମାପ୍ରୁ ଜଦି ମ୍ବାର୍‌ତର୍‍ ଲେଃ ଞ୍ଜିତର୍ ମଜେ ମିଡିଗ୍ ପାଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ଦେତ୍ ରକମ୍ କେଏ ତେଲା ଆତେନ୍‌ ଚାକର୍‍ଇଂ ଦନ୍ୟ । ");
INSERT INTO gaq_vpl VALUES ("LK12_39","072_12_39","LUK","12","39","39","ମାତର୍‌ ଏନ୍ ମ୍ୟା ଲାଲାପା ଉଡ଼ିବେଲା ଡଙ୍ଗାରେ ପାଙ୍ଗ୍‌ଏ ଏନ୍ ଡୁଆନେ ମାଲିକ୍‍ ସେନୁଗ୍‍ ମ୍ୟାଏ ତେଲା ମେଁ ନିଜେ ଡୁଆନେ କୁଗ୍‌ଡାସା ଗୁଆତଗ୍‍ ନ୍‍ସା ଆବି ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK12_40","072_12_40","LUK","12","40","40","ପେ ସାପାରେ ଡିଗ୍ ତରକ୍ ଲାଲାପା ମେଃନ୍‌ସା ଡାଗ୍ଲା ଉଡ଼ି ପ୍ଲେଡ଼ିଆ ପେଇଂ ଏତେ ପେଲେ ଣ୍ଡୁ ଆତେନ୍‌ ବେଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_41","072_12_41","LUK","12","41","41","ଆତ୍‍ ଅରିଆ ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ଅ ମାପ୍ରୁ ନାନେ ନେନ୍‌ସା ଲେଃ ସାପାରେ ନ୍‌ସା ଏନ୍ ଉଦା‍ଅରନ୍ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‍ ?” ");
INSERT INTO gaq_vpl VALUES ("LK12_42","072_12_42","LUK","12","42","42","ମାପ୍ରୁ ଉତର୍ ବିକେ, “ବିସ୍‌ବାସ୍‌ ଆରି ବୁଦିମାନ୍‍ ସେବାଣ୍ତ୍ରେ ଜାଣ୍ଡେ ? ଆଜାକେ ମାଲିକ୍ ଡୁଆ ଚଲେନ୍‌ସା ଦାଇତ୍‌ରେ ବେ; ମେଁ ସମାନ୍ ବେଲା ବିନ୍‍ନେ ଗତିରେକେ ଚଙ୍ଗ୍‍ନ୍‍ସା ବିଃଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK12_43","072_12_43","LUK","12","43","43","ମାପ୍ରୁ ପାଙ୍ଗ୍‌ଚେ ମୁଡ଼ି ଗତିରେକେ ଦେତ୍ ରକମ୍ ଡିଙ୍ଗ୍‌କ୍ନେ କେଏ ମେଁ ଦନ୍ୟ । ");
INSERT INTO gaq_vpl VALUES ("LK12_44","072_12_44","LUK","12","44","44","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ମେଁ ଆମେକେ ନିଜେନେ ଦନ୍ ସମ୍ପତ୍ତିନେ ଦାଇତ୍‍ରେ ବଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_45","072_12_45","LUK","12","45","45","ମାତର୍‌ ଜଦି ଆତେନ୍‌ ଚାକର୍‌ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁ ପାଙ୍ଗ୍‌ନେ ତଙ୍ଗାର୍‌ଏ ଡାଗ୍‌ଚେ ମନେ ମନେ ବାସଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ବଗ୍‌ଟୁ ଡିଙ୍ଗ୍‌ଏ ଆରି ଚଙ୍ଗ୍‌ଉଗ୍‌ଚେ ଉଗ୍‌ସା ଅଲେଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_46","072_12_46","LUK","12","46","46","ତେଲା ଆତେନ୍‌ ଚାକର୍‌ ମେଃ ଦିନା ଉର୍‍ଆଲେଃ ଣ୍ଡୁ ଆରି ଆଣ୍ଡେନେ ପ୍ଲେଡ଼ିଆ ମେଁ ମ୍ୟାଃଆଲେ ଆତେନ୍‌ ଦିନା ଆରି ଆତେନ୍‌ ବେଲା ମେଁନେ ମାପ୍ରୁ ପାଙ୍ଗ୍‌ଏ ଆରି ଆମେକେ ଆନ୍ତାର୍ ବିଚେ ଜାବର୍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK12_47","072_12_47","LUK","12","47","47","ମୁଡ଼ିନେ ଗତିରେ ନିଜେ ମାଲିକ୍‌ନେ ଇକ୍‌ଚା ମ୍ୟାଚେ ତରକ୍ ଡିଙ୍ଗ୍ ଆଲେ ଣ୍ତୁ ବାରି ମେଁନେ ଇକ୍‌ଚା ଅନୁସାରେ କାମ୍ ଡିଙ୍ଗ୍‌ ଆବଣ୍ତୁ ମେଁ ସାସ୍ତି ବାଚେ ଜାବର୍ ମାଡ୍‍ ଚଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_48","072_12_48","LUK","12","48","48","ମାତର୍‌ ମୁଡ଼ି ଗତିରେ ମାଲିକ୍‌ନେ ଇକ୍‌ଚା ମାମ୍ୟାଚେ ଡଣ୍ଡ୍‌ ବାନେ କାମ୍ ଡିଙ୍ଗ୍‌ଏ ଲେଃଏ ମେଁ ଇକୁଡ଼ା ସାସ୍ତି ବାଏ; ଆଜାକେ ଜାବର୍ ବିବ ମେଁବାନ୍‍ ଆରି ଜାବର୍ ବିବ ମେଁବାନ୍‍ ଆରି ଜାବର୍ ଆସା ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_49","072_12_49","LUK","12","49","49","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ସୁଆ ଆଃଡୁଆ ନ୍‌ସା ପାଙ୍ଗ୍‍ନ୍ଲେଃକେ ଆରି ନେଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଜିଆ ସୁଆ ଡୁଆଲେ ! ");
INSERT INTO gaq_vpl VALUES ("LK12_50","072_12_50","LUK","12","50","50","ମାତର୍‌ ଆନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ଦିକ୍ୟାନ୍ନିଆ ଦିକ୍ୟା ଡିଙ୍ଗ୍‌ନେ ପଡ଼େଏ ଆରି ସାପାମାନ୍ଦା ମାଡିଙ୍ଗ୍‍ ଜାକ ନେଙ୍ଗ୍ ଡିରକମ୍ ଚିନ୍ତା ଣ୍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK12_51","072_12_51","LUK","12","51","51","ନେଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ସାନ୍ତି ବିଃନ୍‌ସା ପାଙ୍ଗ୍‌ନ୍ଲେକେ ଡାଗ୍‌ଚେ ମେଃନେ ପେଇଂ ଏତେ ପେଡିଙ୍ଗ୍‌କେ ? ଲେଃ, ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ ଲେଃ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ନେଙ୍ଗ୍ ବାଗ୍‍ ବାଗ୍‍ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ପାଙ୍ଗ୍‍ନେ । ");
INSERT INTO gaq_vpl VALUES ("LK12_52","072_12_52","LUK","12","52","52","ମୁଇଙ୍ଗ୍ ଡୁଆନ୍ନିଆ ମାଲିକ୍ଲିଗ୍‍ ଲେଃଗେ ମ୍ବାୟାନେ ବିରଦ୍‌ରେ ଞ୍ଜିରୁଆ ଆରି ଞ୍ଜିରୁଆନେ ବିରଦ୍‌ରେ ମ୍ବାୟା ବିନେ ଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK12_53","072_12_53","LUK","12","53","53","ଆବା ବିରଦ୍‌ରେ ଉଙ୍ଗ୍‌ଡେ, ଉଙ୍ଗ୍‌ଡେ ବିରଦ୍‌ରେ ଆବା, ଇୟାଙ୍ଗ୍‍ ବିରଦ୍‌ରେ ସେଲାଅ ଆରି ସେଲାଅ ବିରଦ୍‌ରେ ଇୟାଙ୍ଗ୍‍; ଆତା ବିରଦ୍‌ରେ ମାଚୁଆ ଆରି ମାଚୁଆ ବିରଦ୍‌ରେ ଆତା ତଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK12_54","072_12_54","LUK","12","54","54","ଜିସୁ ରେମୁଆଁଇଂକେ ନ୍ନିଆ ଡିଗ୍ ବାସଙ୍ଗ୍‌କେ, “ପଶ୍ଚିମ୍ ଦିଗ୍‍ ପାକା ତ୍ରିଗ୍‌ଡିଆ ତଡ଼ିଆ ଡିଙ୍ଗ୍‌କ୍ନେ କେଆର୍‌କେ, ଆତ୍‍ଅରିଆ ପେ ବାସଙ୍ଗ୍‌ପା, ଣ୍ଡିଆ ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ଆରି ଦେତ୍ ରକମ୍ ଗଟେଏ; ");
INSERT INTO gaq_vpl VALUES ("LK12_55","072_12_55","LUK","12","55","55","ଦକିନ୍‌ ଦିଗ୍‍ ପାକା ୱେଡ଼ିଆ ପାଙ୍ଗ୍ ଡିଂକ୍ନେ ପେକେକେ ପେ ବାସଙ୍ଗ୍‌ପା ଜାବର୍ ନ୍ନାଃସେଙ୍ଗ୍‍ଏ ଆରି ଦେତୁଆଆ ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_56","072_12_56","LUK","12","56","56","ଆ‍ଅଁକେଣ୍ଡ୍ରେଇଂ ପେ ସାପାରେ ମଞ୍ଚ୍‌ପୁର୍‌ ଆରି କିତଂନେ ଚିନ୍ କେଚେ ମେଁନେ ବୁଜେ ପେଡିଙ୍ଗ୍ ମାତର୍‌ ଏନ୍‍ ଜୁଗ୍‍ନେ ମେଁନେ ଗଟେଡିଙ୍କେ ସାପା ଡିରକମ୍ ମ୍ୟାପେୟାକେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK12_57","072_12_57","LUK","12","57","57","ପେ ଆଡିନେ କାମ୍ ନିମାଣ୍ଡାଃ ଆତାନ୍‌ ମେନ୍‌ସା ନିଜେ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ ପେୟାକେ ଣ୍ତୁ ? ");
INSERT INTO gaq_vpl VALUES ("LK12_58","072_12_58","LUK","12","58","58","ଜଦି ଜାଣ୍ତେ ପେନେ ବିରଦ୍‌ରେ ଦାବି ଡିଙ୍ଗ୍‌ଚେ ଆପେକେ ବିଚାର୍‌ ଡୁଆନ୍ନିଆ ଡୁଙ୍ଗ୍‌ୱେଏ, ତେଲା ବିଚାର୍‌ ଡୁଆନ୍ନିଆ ୱେନେ ସେନୁଗ୍‌ ମେଁନେ ଏତେ ସମାଦାନ୍‌ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଜିବନ୍‌ ବିଚେ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ପା । ଜଦି ଦେତ୍‌ରକମ୍ ପେଡିଙ୍ଗ୍‌, ତେଲା ମେଁ ଆପେକେ କ‍ଏଦ୍ ଡୁଆନିଆ ଆନ୍ତବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("LK12_59","072_12_59","LUK","12","59","59","ନେଙ୍ଗ୍ ଆନାକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ନା ବାକି ଡାବୁ ମାସୁଜେ ଜାକ ଆତେନ୍‌ ଜାଗାବାନ୍ ଡିଲାଡିଗ୍ ତାର୍‌ ପେୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK13_1","072_13_1","LUK","13","1","1","ଆତେନ୍‌‌ ବେଲା ଉଡ଼ି ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ପିଲାତ ଆଣ୍ତିନେ ଗାଲିଲୀୟଇଂନେ ମ୍ୟା ମେଁଇଂନେ ପୁଜା ମ୍ୟା ଆଃତେ ଆଃମିସେବକେ, ମେଇଙ୍ଗ୍‌ନେ ବିସୟ୍‌ରେ ଆମେଇଂକେ ଆଃମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_2","072_13_2","LUK","13","2","2","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ ଆକେନ୍ ସାପା କସ୍ଟ ବା ପେଡିଙ୍ଗ୍‌କେସା ଆକେନ୍ ଗାଲିଲୀୟଇଂ ବିନ୍ ସାପା ଗାଲିଲୀୟଇଂନେ ବାନ୍ ଜବର୍ ପାପି ଡାଗ୍‌ଚେ ପେ ସାପାରେ ବାବେ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("LK13_3","072_13_3","LUK","13","3","3","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ନାନେ ଜଦି ପାପ୍‌ବାନ୍‌ ମନ୍‌କେ ପେବଦ୍‌ଲେଲା ପେଇଂ ସାପାରେ ଦେତ୍‌ରକମ୍ ନଷ୍ଟ ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK13_4","072_13_4","LUK","13","4","4","ଶୀଲୋହନେ ଆତେନ୍‌ ଆଣ୍ତିନେ ଗୁଆତ୍ମା ରେମୁଆଁ ଆଡ଼ାତ୍ରା ଉର୍‌ନେ ଡୁଆ ଲଃଚେ ମେଁଇଂନେ ପାରାନ୍ ନଷ୍ଟ ଡିଙ୍ଗ୍‌ଗେ ମେଇଂ ସାପାରେ ଯୀରୂଶାଲମ୍ ରେମୁଆଁଇଂନେ ବାନ୍ ଜବର୍ ପାପିଇଂ ଡାଗ୍‌ଚେ କି ପେ ସାପାରେ ବାବେପେଡିଂ ? ");
INSERT INTO gaq_vpl VALUES ("LK13_5","072_13_5","LUK","13","5","5","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଡାଗ୍‌ଲା ମନ୍‌କେ ପେରାଃବଦ୍‌ଲେଲା ପେ ଡିଗ୍‌ ସାପାରେ ଦେତ୍‌ରକମ୍ ପେଗୁଏଃଏ । ");
INSERT INTO gaq_vpl VALUES ("LK13_6","072_13_6","LUK","13","6","6","ଆରି ଜିସୁ ଆକେନ୍ ଉସ୍ରା ବାସଙ୍ଗ୍‌କେ ମୁଇଂଜାନେ ଅଙ୍ଗୁର୍ ଡୁଗ୍‌ଡିନ୍ନିଆ ମୁଇଙ୍ଗ୍‌ ଲିୱା ସ୍ଲା ଉଙ୍ଗ୍‌ବକେ । ମାଲିକ୍ ପାଙ୍ଗ୍‌ଚେ ଆତ୍‌ଅରିଆ ଚୁଚୁ ତୁର୍‌କେ ତେଲା ଆ‍ଅବାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_7","072_13_7","LUK","13","7","7","ତେସା ମେଁ ନେତା ଡୁଗ୍‌ଡି ଉର୍‌ଣ୍ଡ୍ରେକେ ବାସଙ୍ଗ୍‌କେ ଆକେନ୍ ଜିର୍‌ମୁଆଁ ଡିଙ୍ଗ୍‌ଗେ ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଚେ ଆକେନ୍ ଲିୱା ସ୍ଲାଅରିଆ ଲିୱା ଚୁଚୁ ତୁର୍‌ଣ୍ଡିଂକେ ମାତର୍ ନ୍ନାବାକେ ଣ୍ତୁ ଆକ୍‌ମେଁ ସି ଜଗ୍‌ତ୍ଲାଗ୍‌ପା ଆକେନ୍ ମେଁନ୍‌ସା ତୁବକେ ଡିଗ୍ ମାଡ଼େ କଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_8","072_13_8","LUK","13","8","8","ମାତର୍‌‌ ଗୁତିରେ ସାକାର୍‌କେ ଉତର୍ ବିଃକେ ମାପ୍ରୁ ଆକ୍‌ମେଁ ଏଃମୁଆଁ ଆନ୍ତାର୍‌ବି ନେଙ୍ଗ୍ କ୍ମେନେ ପିତୁର୍ ଗଃଚେ କତ୍‌ ମ୍ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK13_9","072_13_9","LUK","13","9","9","ବାରି ଇଡ଼ିଙ୍ଗ୍ ଲିୱା ଚୁଲା ତ ନିମାଣ୍ତା ଣ୍ତୁଲା ଆକ୍‌ମେକେ ସିଃତଗ୍ ତ୍ଲାଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK13_10","072_13_10","LUK","13","10","10","ମୁଇଂତର୍‌ ଜିସୁ ପୁଣ୍ତେନେ ଦିନା ମୁଇଙ୍ଗ୍ ଜିଉଦି ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ଜିସୁ ଗିଆନ୍‌ ବିଃଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_11","072_13_11","LUK","13","11","11","ଗୋତ୍ମା ଜାକ ମୁଇଙ୍ଗ୍ ଗଲିଆ ବାନ୍ ଦଦିଆ ଆତ୍ମା ସେଲାମ୍ବୁଏ ମୁଇଙ୍ଗ୍ ଆତ୍‌ଅରିଆ ଲେଃକେ । ମେଁ କୁପ୍‌ଡ଼ ଡିଙ୍ଗ୍‌ଚେ ଲେଃକେ ଡିଡିରକମ୍‌ ଡିଗ୍ ନିଜେ ମେଁ ସ୍ୱେଡ଼ାଃ ଡିଙ୍ଗ୍ ଆୟାକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK13_12","072_13_12","LUK","13","12","12","ଜିସୁ ଆମେକେ କେଚେ ଡାଗ୍ରା ୱେଚେ ବାସଙ୍ଗ୍‌କେ ଏ ସେଲାମ୍ବୁଏ ନାଁନେ ଆଃସିଲେଃକ୍ନେ ବାନ୍ ନିମାଣ୍ତା ନାଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_13","072_13_13","LUK","13","13","13","ଜିସୁ ନିଜର୍ ନ୍ତି ସେଲାମ୍ବୁଏ ଆଡ଼ାତ୍ରା ବକେ ଆତ୍‌ବାନ୍ ମେଁ ଦାପ୍‌ରେ ଆଃ ସ୍ୱେଡ଼ାଃ ତୁଆଁଚେ ଇସ୍‌ପର୍‌ନେ ମ‍ଇମା ଡିଙ୍ଗ୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_14","072_13_14","LUK","13","14","14","“ଡାଗ୍‌ଲା ଜିସୁ ପୁଣ୍ତେନେ ଦିନା ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌ଲା ଜିଉଦି ପାର୍‌ତନା ଡୁଆନେ ଦାଇତ୍‌ରେ ଲେଃକ୍ନେ ରେମୁଆଁ ରିସା ଡିଂଚେ ରେମୁଆଁଇଂକେ ବାଲିର୍‌କେ କାମ୍ ଡିଙ୍ଗ୍ ନ୍‌ସା ତୁର୍‌କ୍ଲିଗ୍ ସ୍ମି ଲେଃକେ ତେସା ଆତେନ୍‌ ସାପା ସ୍ମି ପାଙ୍ଗ୍‌ଚେ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ପା ପୁଣ୍ତେନେ ସ୍ମି ଆପାଙ୍ଗ୍‌ଗେପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK13_15","072_13_15","LUK","13","15","15","ଡାଗ୍‌ଲା ମାପ୍ରୁ ଆମେଇଂକେ ଉତର୍ ବିକେ, “ଅ କୁଟ୍ ରେମୁଆଁଇଂ ପେ ସାପାରେ ମେଁନେ ପୁଣ୍ତେନେ ଦିନା ନିଜେ ନିଜେନେ ଅରେଃ ଣ୍ତୁଲା ଗଦ ସାଲାତ୍ୟାବାନ୍ ତୁପିଗ୍‌ଚେ ଡୁଂୱେଚେ ଣ୍ଡିଆ ପେରାଃଉଗ୍‌ ଣ୍ତୁ ? ");
INSERT INTO gaq_vpl VALUES ("LK13_16","072_13_16","LUK","13","16","16","ତେଲା କେଲାପା ଗୋତ୍ମା ମୁଆଃ ସାଚେ ଗଲିଆ ବାନ୍ ଆଃସିଲେଃକ୍ନେ ଅବ୍ରାହାମ୍ ସେଲା ଆକେନ୍ ସେଲାମ୍ବୁଏ ରେମୁଆଁ ମେଁନେ ପୁଣ୍ତେନେ ଦିନା ନିଜେନେ ବନ୍ଦନ୍‌ବାନ୍‌ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ ଆଲେଃକେ କି ?” ");
INSERT INTO gaq_vpl VALUES ("LK13_17","072_13_17","LUK","13","17","17","ଜିସୁ ଆକେନ୍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ବେଲା ମେଁନେ ବିରଦ୍‌ ରେମୁଆଁ ସାପାରେ ଗିଆସ ୱେଆର୍‌କେ ମାତର୍‌‌ ରେମୁଆଁଇଂ ସାପାରେ ମେଁନେ ମୁନା କାମ୍ ଡିଙ୍ଗ୍‌କ୍ନେସା ସାର୍ଦା ଡିଙ୍ଗ୍‌ନେ ମୁଲେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_18","072_13_18","LUK","13","18","18","ଆତ୍‌ବାନ୍ ଜିସୁ ସାଲ୍ୟାକୁକେ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ଡିରକମ୍ ? ବାରି ଜାଣ୍ଡେ ଆଃତେ ନେଙ୍ଗ୍ ସମାନ୍ ନ୍ନାଡିଙ୍ଗ୍‌ଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK13_19","072_13_19","LUK","13","19","19","ଆତେନ୍‌ ଦେକ୍‌ରକମ୍ ମୁଇଙ୍ଗ୍ ସୋରିଷ ମଞ୍ଜି ରକମ୍‌ ଆତେନ୍‌ ଡୁଂୱେଚେ ମୁଇଙ୍ଗ୍‌ ରେମୁଆଁ ନିଜେନେ ଡୁଗ୍‌ଡିନ୍ତୁଗ୍‌ ବିଗ୍‌କେ ଆରି ଆତେନ୍‌‌ ମ୍ନାଚେ ସ୍ଲାଃ ଡିଙ୍ଗ୍‌କେ ଆରି କିତଂନେ ପ୍ଲିଗ୍‌ଇଂ ପାଙ୍ଗ୍‌ଚେ ମେଁନେ କେନ୍ଦାନିଆ ଉଙ୍ଗ୍‌ଚ୍ୟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_20","072_13_20","LUK","13","20","20","ଜିସୁ ଆରି ବାସଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ଜାଣ୍ଡେ ଏତେ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ସମାନ୍ ଣ୍ତିଙ୍ଗ୍‌ଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK13_21","072_13_21","LUK","13","21","21","ଆତେନ୍‌‌ ମୁଇଙ୍ଗ୍‌ ଖମୀର ରକମ୍‌ ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୁଏଃ ଆତେନ୍‌‌ ଡୁଂୱିଗ୍‌ଚେ ମହଣେ ମଇଦା ଡାଗ୍ରା ଡାଚେ ବକେ ଆରି ଇଡ଼ିଙ୍ଗ୍ ସାପା ଖମୀର ରକମ୍ ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_22","072_13_22","LUK","13","22","22","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ନଗର ନଗର ଆରି ଇନି ଇନି ଅଲେଙ୍ଗ୍‌ଚେ ଗିଆନ୍‌ ବିଃ ବିଃଚେ ଯିରୂଶାଲାମ୍ ପାକା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_23","072_13_23","LUK","13","23","23","ଆରି ମୁଇଂଜା ଆମେକେ ବାସଙ୍ଗ୍‌କେ ମାପ୍ରୁ ଉଦାର୍‌ ବାନେ ରେମୁଆଁଇଂନେ ସଂକ୍ୟା ମେଁନେ ଗଣ୍ଡା ? ଆତ୍‌ବାନ୍ ମେଁ ମେଇଙ୍ଗ୍‌କେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK13_24","072_13_24","LUK","13","24","24","ଚିପାକ୍ନେ ଗାଲି ବିଚେ ୱେନ୍‌ସା ୟା ଜାକ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ପା ଡାଗ୍‌ଲା ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍ ଣ୍ତିଙ୍ଗ୍‌କେ ଗୁଲେ ୱେନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ଡାଗ୍‌ଲା ୱେ ଆୟାଆର୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK13_25","072_13_25","LUK","13","25","25","ଡୁଆନେ ମ୍ନାଃରେ ତଡ଼୍ୟାଚେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ଆନ୍ତଃ ବିଃକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଉଡ଼ିବେଲା ପେ ସାପାରେ ବାଜାର୍ ତୁଆଁ ପେଲେଃକେ ଆରି ଅ ମାପ୍ରୁ ନେ ନ୍‌ସା ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ରଃବିଲାପା ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ବଗ୍‌ନେ ପେମୁଲେଏ ଆତେନ୍‌‌ ବେଲା ମେଁ ଆପେକେ ବାସଙ୍ଗ୍ଏ ପେ ଆଣ୍ତିନେ ଜାଗାନେ ରେମୁଆଁ ଆତେନ୍‌‌ ନେଙ୍ଗ୍‌ ନ୍ନାମ୍ୟାକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK13_26","072_13_26","LUK","13","26","26","ଆତେନ୍‌‌ ବେଲା ପେଇଙ୍ଗ୍‌ ବାଲିର୍ ପେମୁଲେଏ ନେଁ ସାପାରେ ନାଁ ଏତେ କୁଡ଼େଚେ ନେଚଙ୍ଗ୍‌ ନେଉଗ୍‌କେ ଆରି ନାଁ ଆନେକେ ବାଜାର୍‌ଅରିଆ ଗ୍ୟାନ୍ ନାବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_27","072_13_27","LUK","13","27","27","ଆରି ମେଁ ପେ ସାପାରେକେ ବାଲିର୍‌ଏ ପେ ଆଣ୍ତିନେ ଜାଗାନେ ରେମୁଆଁ ଆତେନ୍‌‌ ନେଙ୍ଗ୍ ନ୍ନାମ୍ୟାକେ ଣ୍ତୁ ଏ ଅଦର୍ମ ଡିଂଣ୍ଡ୍ରେ ସାପାରେ ନେଙ୍ଗ୍ ଡାଗ୍ରାବାନ୍ ସ୍ଲ ୱେଲା ");
INSERT INTO gaq_vpl VALUES ("LK13_28","072_13_28","LUK","13","28","28","ଉଡ଼ିବେଲା ପେଇଂ ଅବ୍ରାହାମ୍ ଇସାକ୍ ଜାକୁବ୍‌ ଆରି ସାପାରେ ବାବବାଦିକେ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ଲେଃନେ ଆରି ନିଜେ ନିଜେକେ ବାଜାର୍‌ ଜଗ୍‌ତ୍ଲିଗ୍‌ନେ ପେକେଏ ଆତେନ୍‌ ବେଲା ଆତ୍ଅରିଆ ପେଅଁଏ ଆରି ଗ୍ନି ଆଃଚାର୍ ଆଃଲ୍ୟା ପେକେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK13_29","072_13_29","LUK","13","29","29","ଆରି ପୁର୍ବ ଆରି ପଶ୍ଚିମ୍ ଉତର୍ ଆରି ଦକିନ୍‌ବାନ୍‌ ରେମୁଆଁଇଂ ପାଙ୍ଗ୍‌ଚେ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ଚଙ୍ଗ୍‌ନ୍‌ସା କ‍ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK13_30","072_13_30","LUK","13","30","30","ଆରି କେଲାପା ଇଡ଼ିଙ୍ଗ୍ ଲେଃକ୍ନେ ଉଡ଼ି ରେମୁଆଁଇଂ ସେନୁଗ୍‌ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ଆରି ସେନୁଗ୍‌ ଲେଃକ୍ନେ ଉଡ଼ି ରେମୁଆଁ ଇଡ଼ିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK13_31","072_13_31","LUK","13","31","31","ଆତେନ୍‌‌ ବେଲା ଉଡ଼ି ପାରୁସି ଜିସୁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଡିଂକେ ଆକେନ୍ ଜାଗା ଆନ୍ତାର୍‌ଚେ ତାର୍ ୱେଲା ଡାଗ୍‌ଲା ହେରୋଦ ଆନାକେ ବାଗୁଏଃ ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK13_32","072_13_32","LUK","13","32","32","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ପେଇଂ‍ ୱେଚେ ଆତେନ୍‌ ନାକାକେ ବାସଙ୍ଗ୍‌ପା କେଲାପା ନେଙ୍ଗ୍ ଏକେ ଆରି ଞ୍ଜ ଗଲିଆ ନୁଆଁ ଣ୍ଡିଂ ଆରି ରଗି‍ଇଂକେ ନିମାଣ୍ତା ଆଃଡିଙ୍ଗ୍‌ଣ୍ଡିଙ୍ଗ୍ ବାରି ଜିର୍‌ସି ବିତ୍ରେ ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ କାମ୍ ଣ୍ଡ୍ରାଡାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK13_33","072_13_33","LUK","13","33","33","ବଲ୍‌ଡ଼ିଙ୍ଗ୍‌ଗେ ଏକେ ଞ୍ଜଡ଼େ ଆରି ଇଡ଼ିଙ୍ଗ୍ ଦିନା ଆନେଙ୍ଗ୍ ୱିଗ୍‌ନେ ଡିଙ୍ଗ୍‌ଏ ଡାଗ୍‌ଲା ଯିରୂଶାଲମ୍‌ନେ ବାଏରେ ବାବବାଦି ନସ୍ଟ ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK13_34","072_13_34","LUK","13","34","34","ଗୋ ଯିରୂଶାଲମ୍‌ ଗୋ ଯିରୂଶାଲମ୍‌ ବାବବାଦିଇଂକେ ବାଗୁଏ ପେଡିଙ୍ଗ୍‌କେ ଆରି ନିଜର୍ ଡାଗ୍ରାନେ ପ୍ରେରିତ୍‌ଇଂକେ ବ୍ରି ଟୁଚେ ବାଗୁଏ ପେଡିଙ୍ଗ୍‌କେ ଗିସେଙ୍ଗ୍‌ ଡିରକମ୍ ଡେନା ବୁନ୍ଦେ ନିଜର୍ ଉଙ୍ଗ୍‌ଡେକେ ମୁଇଙ୍ଗ୍ ଡାଗ୍ରା ରାଃସିଙ୍ଗ୍‌ଏ ଦେତ୍‌ରକମ୍ ନେଙ୍ଗ୍‌ ଉଡ଼ିତର୍ ନାଉଂକେ ମୁଇଙ୍ଗ୍‌ ଡାଗ୍ରା ରାଃସିଙ୍ଗ୍‌ ନ୍‌ସା ମନ୍‌ ଣ୍ତିଂକେ ଡାଗ୍ଲା ପେଇଂ ଇକ୍‌ଚା ପେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK13_35","072_13_35","LUK","13","35","35","କେଲାପା ପେ ସାପାରେନେ ମନ୍ଦିର୍‌ ଆନ୍ତାର୍ ବିନେଙ୍ଗ୍‌କେ; ଆରି ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ମାପ୍ରୁନେ ମ୍ନିରେ ଜାଣ୍ତେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ମେଁ ଦନ୍ୟ ପେଇଙ୍ଗ୍‌ ଆଣ୍ତିନେ ସ୍ମି ଆକେନ୍ ସାମୁଆଁ ପେବାଲିର୍‌ଏ ଆତେନ୍‌‌ ସ୍ମି ଆପାଙ୍ଗ୍‌ ଜାକ ଆନେଙ୍ଗ୍ ସତେଆ ଆରି ପେକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK14_1","072_14_1","LUK","14","1","1","ମୁଇଂତର୍‌ ଜିସୁ ପୁଣ୍ତେନେ ଦିନା ଚଙ୍ଗ୍ ନ୍‌ସା ପାରୁସିଇଂନେ ମୁଇଙ୍ଗ୍ ମ୍ନାରେନେ ଡୁଆ‍ ୱେଗେ ମେଇଂ ଜିସୁକେ କେଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK14_2","072_14_2","LUK","14","2","2","ବାରି କେଲାପା ମେଁଇଂନେ ସାମ୍‌ନାରେ ମୁଇଂଜା ପାରାଲିସ୍ ରଗ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK14_3","072_14_3","LUK","14","3","3","ଆତ୍‌ବାନ୍ ଜିସୁ ଦର୍ମସାସ୍ତ୍ରି ଆରି ପାରୁସି‍ଇଂକେ ବାଲିର୍‌କେ ପୁଣ୍ତେ ବେଲା ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌ନେ ନିୟମ୍‌ ଲେଃ ଣ୍ତୁ ? ଡାଗ୍ଲା ମେଇଙ୍ଗ୍ ବୁଙ୍ଗ୍‌ଲେଃ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK14_4","072_14_4","LUK","14","4","4","ବାରି ଜିସୁ ଆମେକେ ସାଚେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌କେ ଆରି ବେ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK14_5","072_14_5","LUK","14","5","5","ଆରି ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, ପେଇଂନେ ବିତ୍ରେ ଜାଣ୍ଡେ ନିଜର୍ ଉଙ୍ଗ୍‌ଡେ ବା ଅରେଃ କୁଇଁସାଲ୍‌ ଲଃଲା ମେଁନେ ଆମେକେ ପୁଣ୍ତେନେ ଦିନା ଟାପ୍‌ନା ୱେଚେ ପେରାତଃଡ଼ିଆ ଣ୍ତୁ ? ");
INSERT INTO gaq_vpl VALUES ("LK14_6","072_14_6","LUK","14","6","6","ଦର୍ମସାସ୍ତ୍ରି ଆରି ପାରୁସିଇଙ୍ଗ୍ ଆକେନ୍ ସାପା ସାମୁଆଁନେ ମେଃଡିଗ୍‌ ବାଲିର୍ ଆୟାଆର୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK14_7","072_14_7","LUK","14","7","7","ଆରି ବାଲିର୍‌ବକ୍ନେ ରେମୁଆଁଇଙ୍ଗ୍‌ ଡିରକମ୍ ମ୍ନା ଟାନ୍ ତୁର୍ ଡିଂଆର୍‌କ୍ନେ ଆକେନ୍ କେଚେ ଜିସୁ ଆମେଇଂକେ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK14_8","072_14_8","LUK","14","8","8","ଉଡ଼ି ବେଲା ପେ ଆଣ୍ଡିନେ ରେମୁଆଁ ବାନ୍ ବିଏବ ଚଙ୍ଗ୍‌ନେ ୱା ବଏ ଆତେନ୍‌ ବେଲା ମୁନାନେ କୁକନେ ଟାନ୍‌ନିଆ ଆକଗେପା ଡାଗ୍ଲା ପେବାନ୍ ଜବର୍ ମ୍ନା ରେମୁଆଁକେ ମେଁନେ ବାନ୍ ୱା ବଏ । ");
INSERT INTO gaq_vpl VALUES ("LK14_9","072_14_9","LUK","14","9","9","ଆରି ଜେ ଆନାକେ ଆରି ଆମେକେ ୱାବଏ ମେଁ ପାଙ୍ଗ୍‌ଚେ ଆନାକେ ବାସଙ୍ଗ୍ଏ ଆକ୍‌ମେକେ କୁକନେ ଟାନ୍ ବିଃ; ବାରି ଆତେନ୍‌ ବେଲା ନାନେ ଗିଆସଚେ ଡାଆଁନେ ଜାଗାନ୍ନିଆ କୁକ ନ୍‌ସା ପେୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK14_10","072_14_10","LUK","14","10","10","ଡାଗ୍‌ଲା ଉଡ଼ିବେଲା ଆପେକେ ବଜିନ୍ନିଆ ମୁଇଂଜା ୱାଏ, ଆତେନ୍‌‌ ବେଲା ୱେଚେ ଡାଆଁନେ ଜାଗାନ୍ନିଆ କଲାପା; ଡିରକମ୍ ୱାବକ୍ନେ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ଆପେକେ ବାସଙ୍ଗ୍ଏ, ଅ ବନ୍ଦୁ, ମ୍ନାନେ ଜାଗାନ୍ନିଆ ପାଙ୍ଗ୍‍ଲା; ଅଃତେନ୍‌ ବେଲା ପେନେ ଏଃତେ ଚଙ୍ଗ୍ କଲେଃକ୍ନେ ସାପା ରେମୁଆଁନେ ସାମ୍‌ନାରେ ଆନାକେ ସନ୍‌ମାନ୍‌ ମିଲେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK14_11","072_14_11","LUK","14","11","11","ଡାଗ୍‌ଲା ଜାଣ୍ତେ କି ନିଜେକେ ମ୍ନା ଡାଗ୍‌ଚେ ଆଃସୁଏଃଏ ଆମେକେ ଗୁର୍‌ନା ଆଡିଙ୍ଗ୍‌ଆର୍ ବାରି ଜାଣ୍ଡେ ନିଜେକେ ହିନ୍‌ ଆଃଡିଙ୍ଗ୍ଏ ଆମେକେ ମ୍ନାରେ ଆଃଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK14_12","072_14_12","LUK","14","12","12","ଜିସୁ ଆମେକେ ୱାବକ୍ନେ ପାରୁସିଇଂକେ ବାସଙ୍ଗ୍‌କେ ସ୍ମି ବା ମିଡିଗ୍‍ ବଜି ବିଲା ପେନେ ବୟାଁ ବନ୍ଦୁ କୁଟୁମ୍‌ ଆରି ସାଉକାର୍‌ ଡାଗ୍ରା ଡୁଆଣ୍ଡ୍ରେକେ ଆୱାଗେପା ଡାଗ୍ଲା ବିନେ ବେଲା ମେଇଙ୍ଗ୍‌ ଡିଗ୍ ଆନାକେ ମେଇଙ୍ଗ୍‌ ଏତେ ଚଙ୍ଗ୍‌ନ୍‌ସା ୱାଆର୍‌ଏ ଆତେନ୍‌‌ ବେଲା ନା ନାନେ ପ୍ରତିଦାନ୍‌ ନାବାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK14_13","072_14_13","LUK","14","13","13","ଡାଗ୍ଲା ବଜି ବିଃକ୍ଲା ଗରିବ୍‌, କ୍ଲିଙ୍ଗ୍‌ଚ କ୍ଲିଙ୍ଗ୍‌ତି, ଚଟା, ଆରି କାନା ଆଣ୍ଡେଙ୍ଗ୍‌କେ ୱାପା । ");
INSERT INTO gaq_vpl VALUES ("LK14_14","072_14_14","LUK","14","14","14","ତେଲା ଆନାକେ ମଙ୍ଗଲ୍ ଡିଙ୍ଗ୍‌ଏ, ଡାଗ୍ଲା ଆପେକେ ପ୍ରତିଦାନ୍‌ ବିଃନ୍‌ସା ମେଁଇଂନେ ମେଃଡିଗ୍‌ ଣ୍ତୁ ଆରି ଦରମ୍ ରେମୁଆଁଇଂ ଗୁଏଃକ୍ନେ ବିତ୍ରେ ମ୍ୱ୍ର ଆର୍‌ଏ, ଆତେନ୍‌‌ ବେଲା ପେଇଂ ପେନେ ପ୍ରତିଦାନ୍‌ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK14_15","072_14_15","LUK","14","15","15","ଆତେନ୍‌‌ ଅଁଚେ ଜିସୁନେ ଏତେ ଚୁଚଙ୍ଗ୍ କଲେଃକ୍ନେ ରେମୁଆଁଇଂ ବିତ୍ରେ ମୁଇଂଜା ଜିସୁକେ ବାଲିର୍‌କେ ଆଣ୍ତିନେ ରେମୁଆଁ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ଚଙ୍ଗ୍‌ନେ କ‍ଏ ମେଁ ଦନ୍ୟ । ");
INSERT INTO gaq_vpl VALUES ("LK14_16","072_14_16","LUK","14","16","16","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ ମୁଇଂଜା ରେମୁଆଁ ମିଡିଗ୍‌ ବେଲା ମୁନା ବଜି ବିନ୍‌ସା ଇକ୍‌ଚା ଡିଂଚେ ଗୁଲେ ରେମୁଆଁକେ ୱାବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK14_17","072_14_17","LUK","14","17","17","ବାରି ଚଙ୍ଗ୍‌ନେ ବେଲା ଡିଙ୍ଗ୍ ୱେଲା ମେଁ ୱା ବକ୍ନେ ରେମୁଆଁଇଂ ଡାଗ୍ରା ନିଜେନେ ଚାକର୍‌କେ ୱାଉଙ୍ଗ୍‌ ବେକେ ପେ ସାପାରେ ପାଙ୍ଗ୍‌ଲାପା ଡାଗ୍ଲା ସାପା ଚଙ୍ଗ୍‌ନେ ଡିଙ୍ଗ୍ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK14_18","072_14_18","LUK","14","18","18","ଡାଗ୍ଲା ସାପାରେ କେମା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେ ମୁଲେଆର୍‌କେ ସେନୁଗ୍‌ ରେମୁଆଁ ଆମେକେ ବାଃଲିର୍‌କେ ନେଙ୍ଗ୍ ଇକୁଡ଼ା ଲିଜ ବିଆର୍‌ ମ୍ୱକେ ଆନେଙ୍ଗ୍ ଆତେନ୍‌ କେନେ ପଡ଼େଏ; ଦୟା ଣ୍ଡିଂକେ ଆନେଙ୍ଗ୍ କେମା ଡିଙ୍ଗ୍ ବିଃଲାପା ");
INSERT INTO gaq_vpl VALUES ("LK14_19","072_14_19","LUK","14","19","19","ବାରି ମୁଇଂଜା ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ମାଲ୍‌ ତ୍ନୁ ଅରେଃ ବିଆର୍‌ ମ୍ୱକେ ବାରି ନେଙ୍ଗ୍ ଆମେଇଂକେ ପରିକ୍ୟା ଡିଙ୍ଗ୍‌ନ୍‌ସା ୱେଣ୍ତିଙ୍ଗ୍‌କେ ଦୟା ଡିଂଚେ ଆନେଙ୍ଗ୍‌କେ କେମା ଡିଙ୍ଗ୍ ବିଃଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK14_20","072_14_20","LUK","14","20","20","ବିନ୍ ମୁଇଂଜା ବାସଙ୍ଗ୍‍କେ, “ନେଙ୍ଗ୍ ତ୍ମି ବିଃଏ ନ୍ଲେଃକେ, ତେସା ନେଙ୍ଗ୍ ୱେ ନାୟା ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK14_21","072_14_21","LUK","14","21","21","ବାରି ଆତେନ୍‌ ଚାକର୍ ପାଙ୍ଗ୍‌ଚେ ମେଁନେ ମାଲିକ୍‌କେ ସାପା ସାମୁଆଁ ବାଲିର୍‌କେ ଆତ୍‌ବାନ୍ ଡୁଆ ମାଲିକ୍ ରିସା ଡିଙ୍ଗ୍‌ଚେ ନିଜେନେ ଚାକର୍‌କେ ବାସଙ୍ଗ୍‌କେ ଦାପ୍ରେ ୱେଚେ ଇନିନେ ଗୁଲି ଆରି କୁନ୍ଦିଇଂ ୱେଚେ ଦରିଦ୍ର କନ୍ଦା ଚଟା ଆରି କାନା ଇଂକେ ଆକ୍‌ଅରିଆ ୱା ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଲା । ");
INSERT INTO gaq_vpl VALUES ("LK14_22","072_14_22","LUK","14","22","22","ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ଚାକର୍ ଆଣ୍ତେ ୱିଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ଏ ମାପ୍ରୁ ନାନେ ବାଲିର୍‌କେ ରକମ୍ ଡିଙ୍ଗ୍‌ମ୍ବକେ ଏଲେଡିଗ୍ ବାରି ଜାଗା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK14_23","072_14_23","LUK","14","23","23","ଆତ୍‌ବାନ୍ ମାଲିକ୍ ଆତେନ୍‌‌ ଚାକର୍‌କେ ବାଲିର୍‌କେ ରାଜଦାଣ୍ତ୍‌ ଆରି ଗଲି କନ୍ଦି ୱେଲା ନେଙ୍ଗ୍ ଡୁଆ ଡିରକମ୍ ବର୍ତି ଡିଙ୍ଗ୍‌ୱେଏ ଆତେନ୍‌‌ସା ରେମୁଆଁଇଂକେ ପାଙ୍ଗ୍‌ନେ ସା ବାସଙ୍ଗ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("LK14_24","072_14_24","LUK","14","24","24","ତେସା ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଆତେନ୍‌‌ ୱା ବକ୍ନେ ରେମୁଆଁ ବିତ୍ରେ ଜାଣ୍ଡେ ନେଙ୍ଗ୍‌ନେ ବଜି ଚଙ୍ଗ୍ ଆୟାଆର୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK14_25","072_14_25","LUK","14","25","25","ଜାବର୍‌ ସଂକ୍ୟା ରେମୁଆଁ ଜିସୁ ଏତେ ଡିଙ୍ଗ୍ଆର୍‌କେ ବାରି ଜିସୁ ପୁଏଚେଃ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK14_26","072_14_26","LUK","14","26","26","ଜାଣ୍ଡେ ଅଃନା ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ନିଜେନେ ଆବା ଇୟାଙ୍ଗ୍ କୁନେଡ଼େ ଉଙ୍ଗ୍‌ଡେ ବୟାଁଣ୍ତେ ଆରି ତନାଣ୍ଡେ ଇଂକେ ଡେକ୍‌ରକମ୍‌ କି ନିଜର୍ ପାରାନ୍‌କେ ଡିଗ୍ ଜାବର୍‌ ବଲ୍‌ ଆବା ଣ୍ଡୁ ତେଲା ମେଁ ନେଙ୍ଗ୍‌ନେ ସିସ୍ ଡିଙ୍ଗ୍‌ଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK14_27","072_14_27","LUK","14","27","27","ଜାଣ୍ତେ କି ନେଙ୍ଗ୍‌ନେ କୁରୁସ୍ ଡୁଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ଆପାଙ୍ଗ୍‌ ଣ୍ତୁ ମେଁ ନେଙ୍ଗ୍‌ନେ ସିସ୍ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK14_28","072_14_28","LUK","14","28","28","ଡାଗ୍ଲା ପେ ସାପାରେନେ ବାନ୍ ଜାଣ୍ଡେ ଉର୍‌ନେ ଡୁଆ ଆଃରେନ୍‌ସା ଇକ୍‌ଚା ପେଡିଙ୍ଗ୍‌କେ ତେଲା ଆତେନ୍‌‌ ଡିଡା ଜାକ ମେଁନେ ଡାବୁ ସମାନ୍ ଲେଃକେ ଲେଃ ଣ୍ତୁ ଆକେନ୍ ସେନୁଗ୍‌ କଚେ କର୍ଚ ଇସାବ୍ ପେଡିଙ୍ଗ୍‌ଏ ");
INSERT INTO gaq_vpl VALUES ("LK14_29","072_14_29","LUK","14","29","29","ମାରିଆଃ ମେଁ ପାଣ୍ଡୁସନ୍ ଆଃକଚେ ଆଃଡା ଆୟା ଣ୍ଡୁ ଉଃଡ଼ିରୁଆ ଆତେନ୍‌ କେଆର୍‌ଏ ସାପାରେ ଆମେକେ ଲୁଆଃଚେ ବାସଙ୍ଗ୍‌ନେ ଆରାମ୍‌ ଡିଂଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK14_30","072_14_30","LUK","14","30","30","ଆକେନ୍ ରେମୁଆଁ ତିଆର୍ ଡିଙ୍ଗ୍‌ନେ ମୁଲେଚେ ଆଃଡ଼ା ଆୟାକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK14_31","072_14_31","LUK","14","31","31","ଡାଗ୍ଲା ମୁଇଙ୍ଗ୍ ଇଃସାଙ୍ଗ୍‌ ବିନ୍ ମୁଇଂଜା ଇଃସାଙ୍ଗ୍‌ନେ ଏତେ ଜୁଦ୍‌ ଡିଙ୍ଗ୍‌ନ୍‌ସା ୱେନେ ବେଲା ମୁଇଂକୁଡ଼ି ଅଜାର୍‌ ସନ୍ୟ ଡୁଂୱେଚେ ମେଁନେ ବିରଦ୍‌ରେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ ଇଃସାଙ୍ଗ୍‌ନେ ଆଃତେ ଗୁଆକ୍ଲିଗ୍ ଅଜାର୍‌ ସନ୍ୟ ଡୁଂୱେଚେ ଜୁଦ୍‌ ଡିଙ୍ଗ୍‌ନେ ଡିଙ୍ଗ୍‌ଏ ଲେଃ ଣ୍ତୁ ଆତେନ୍‌ ସେନୁଗ୍‌ କଚେ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ । ");
INSERT INTO gaq_vpl VALUES ("LK14_32","072_14_32","LUK","14","32","32","ଜଦି ଆୟା ଣ୍ତୁ ତେଲା ବିନ୍ ଇଃସାଙ୍ଗ୍‌ ସ୍ଲ ଲେଃକ୍ନେ ବେଲା ମେଁ ଦୁତ୍ ବେଚେ ସାନ୍ତିରେ ଲେଃନ୍‌ସା କବର୍ ବିଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK14_33","072_14_33","LUK","14","33","33","ଦେତ୍‌ରକମ୍ ପେ ସାପାରେ ବାନ୍ ଜାଣ୍ତେ ଡିଗ୍‌ ନିଜେନେ ସାପାକେ ଆଃଆନ୍ତାର୍ ପେୟା ଣ୍ତୁ ମେଁ ନେଙ୍ଗ୍‌ନେ ସିସ୍ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK14_34","072_14_34","LUK","14","34","34","ବିତିଗ୍ ନିମାଣ୍ଡା; ଡାଗ୍ଲା ବିତିଗ୍ ବାନ୍ ଜଦି ସ୍‌ବ ଆଲେଃଲା ଣ୍ତୁ ତେଲା ଆତେନ୍‌ ମେଃଡିଗ୍‌ ମୁଲ୍ୟ ଣ୍ତୁ ପେ ସାପାରେ ମେଁନେ ଆରି ମୁଇଙ୍ଗ୍‌ ତର୍ ସ୍‌ବ ଆଣ୍ତେ ବିପେୟାଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK14_35","072_14_35","LUK","14","35","35","ଆତେନ୍‌‌ ତୁବଃ ଣ୍ତୁଲା କତ୍‌କୁଡ଼ା ନ୍‌ସା ଦର୍‌କାର୍ ଣ୍ତୁ; ରେମୁଆଁ ଆତେନ୍‌ ବାଏରେ ଜଗ୍‌ତ୍ଲାଗ୍‌ ବିଃଆରେ । ଜାଣ୍ତେନେ ଦ୍ରିଗ୍ ନ୍‌ସା ନ୍‌ଲୁଗ୍ ଲେଃକେ ମେଁ ଦ୍ରିଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK15_1","072_15_1","LUK","15","1","1","ବାରି ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ତ୍ରେ ଆରି ପାପି ରେମୁଆଁ ସାପାରେ ଜିସୁନେ ସାମୁଆଁ ଅଁନ୍‌ସା ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌ଡିଙ୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_2","072_15_2","LUK","15","2","2","ଆତ୍‌ବାନ୍ ପାରୁସିଇଂ ବାରି ଦର୍ମସାସ୍ତ୍ରିଇଂ ନିନ୍ଦା ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଆକେନ୍ ରେମୁଆଁ ପାପିଇଂକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ମ୍ୟାକେ ବାରି ମେଁଇଂନେ ଆଃତେ ଚୁଚଙ୍ଗ୍‌ମ୍ୟାକେ !” ");
INSERT INTO gaq_vpl VALUES ("LK15_3","072_15_3","LUK","15","3","3","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେଇଂକେ ଆକେନ୍ ସାମୁଆଁ ବାଲିର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_4","072_15_4","LUK","15","4","4","ପେନେ ବିତ୍ରେ ଜଦି ମୁଇଂ ରେମୁଆଁନେ ମାଲ୍‍କୁଡ଼ି ମେଣ୍ଡା ଲେଃଏ ବାରି ଆତ୍‌ବାନ୍ ମୁଇଙ୍ଗ୍ ବଃୱେଏ, ତେଲା ମେଃନେ ଡିଙ୍ଗ୍‌ଏ ? ମେଁ ବିନ୍ ଅନେସ୍‌ପତ୍ ମେଣ୍ତାକେ ଆନ୍ତାର୍‌ଚେ ବକ୍ନେ ମେଣ୍ତାକେ ଅବା ଜାକ ଆତୁର୍ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("LK15_5","072_15_5","LUK","15","5","5","ବାରି ମେଁ ଆମେକେ ଅବାଲା ମେଣ୍ତାକେ ସାର୍ଦାରେ ଜେବାନିଆ ଡୁଙ୍ଗ୍‌ଚେ ଡୁଆନ୍ନିଆ ଡୁଂୱିଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK15_6","072_15_6","LUK","15","6","6","ବାରି ନିଜେନେ ବନ୍ଦୁ ଆରି ଡାଗ୍ରା ଡୁଆଣ୍ଡ୍ରେକେ ୱାଚେ ମୁଇଂଅରିଆ ରାଃସିଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ବାଲିର୍‌ଏ ନେଙ୍ଗ୍ ଏତେ ସାର୍ଦା ଡିଙ୍ଗ୍‌ପା ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ବକ୍ନେ ମେଣ୍ଡା ଙବାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_7","072_15_7","LUK","15","7","7","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ । ଆଣ୍ତିନେ ରେମୁଆଁଇଂନେ ମନ୍ ବଦ୍‌ଲେଃନେ ଇକ୍‌ଚା ଣ୍ତୁ ଦେକ୍ ରକମ୍ ଅନେସ୍‌ପତ୍ ଦରମ୍ ରେମୁଆଁ ବିତ୍ରେ ମୁଇଙ୍ଗ୍‌ ପାପିନେ ମନ୍ ବଦ୍ଲେ ୱେଲା ଆମେକେ କିତଙ୍ଗ୍‌ଇନି ଜବର୍ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK15_8","072_15_8","LUK","15","8","8","“ବାବେପା ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୟ୍‍ନେ ଗୁଆକ୍ଲିଗ୍‍ ରୁପା ଡାବୁ ଲେଃକେ । ଆତ୍‌ବାନ୍ ମୁଇଙ୍ଗ୍ ବୱେଗେ । ତେଲା ମେଁ ମେଃଡିଙ୍ଗ୍‌ଏ ? କୁପିସ ଆଃଡୁଆଚେ ଡୁଆ ଆୱେଜଙ୍ଗ୍‍ଏ ଡାବୁ ଅବା ଜାକ ପିତୁର୍ ପାକା ଜତ୍ନେଚେ ତୁର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK15_9","072_15_9","LUK","15","9","9","ବାରି ଆତେନ୍‌‌ ଅବାଲା ମେଁ ନିଜର୍ ବନ୍ଦୁ ଆରି ଡାଗ୍ରା ଡୁଆଣ୍ଡ୍ରେଇଂକେ ୱାଚେ ମୁଇଂଅରିଆ ରାଃସିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍ଏ ନେଙ୍ଗ୍ ଆଃତେ ସାର୍ଦା ଡିଙ୍ଗ୍‌ପା ଡାଗ୍ଲା ଆଣ୍ତିନେ ଡାବୁ ବାଲେଃକେ ଆତେନ୍‌‌ ମ୍ୱାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_10","072_15_10","LUK","15","10","10","ନେଙ୍ଗ୍‌ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଦେତ୍‌ରକମ୍ ଜା ମନ୍ ବଦ୍‌ଲେଏ ଦେକ୍ ରକମ୍ ମୁଇଙ୍ଗ୍‌ ପାପି ନ୍‌ସା ଇସ୍‌ପର୍‌ନେ ଦୁତ୍ଇଂନେ ସାମ୍‌ନାରେ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK15_11","072_15_11","LUK","15","11","11","ଜିସୁ ବାସଙ୍ଗ୍‌କେ ମୁଇଙ୍ଗ୍‌ଜା ରେମୁଆଁନେ ମ୍ୱାକ୍ଲିଗ୍‌ ଉଙ୍ଗ୍‌ଡେ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_12","072_15_12","LUK","15","12","12","ମେଇଙ୍ଗ୍‌ନେ ବିତ୍ରେ ଡାଆଁନେ ଉଙ୍ଗ୍‌ଡେ ଆବାଡ଼େକେ ବାସଙ୍ଗ୍‌କେ ଆବା ସମ୍ପତ୍ତିନେ ବିତ୍ରେ ଆଣ୍ତିନେ ବାଗ୍‌ ନେଙ୍ଗ୍‌ନେ ଆତେନ୍‌‌ ଆନେଙ୍ଗ୍ ବିଃଲା । ଆତ୍‌ବାନ୍ ମେଁ ନିଜର୍‌ନେ ସମ୍ପତିକେ ମ୍ୱାୟାକେ ବାଟାବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_13","072_15_13","LUK","15","13","13","ଗଣ୍ତାଃସି ଇଡ଼ିଙ୍ଗ୍ ଡାଆଁ ଉଙ୍ଗ୍‌ଡେ ସାପା ମୁଇଙ୍ଗ୍‌ ଡାଗ୍ରା ରାଃସିଙ୍ଗ୍‌ଚେ ସ୍ଲ ଦେସ୍ ପାକା ତାର୍‌ୱେଗେ ବାରି ଆତ୍‌ଅରିଆ ମେଁ ନିଜର୍‌ନେ ସମ୍ପତ୍ତି କର୍ଚ ଡିଙ୍ଗ୍‌ଚେ ଉଙ୍ଗ୍‌ଡେକେ ବିକେ ");
INSERT INTO gaq_vpl VALUES ("LK15_14","072_15_14","LUK","15","14","14","ମାତର୍‌ ସାପା ଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ଦେସ୍‌ନ୍ନିଆ ମୁର୍‍ଡି ଡିଙ୍ଗ୍‌ଲା ମେଁନେ ଅସ୍‌ବିଦା ଡିଙ୍ଗ୍‌ନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_15","072_15_15","LUK","15","15","15","ଆତ୍‌ବାନ୍ ମେଁ ୱେଚେ ଆତେନ୍‌‌ ଦେସ୍‌ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁନ୍ନିଆ ଗୁତି ଲେଃକେ ଆତେନ୍‌‌ ରେମୁଆଁ ଆମେକେ ଗୁବୁଗ୍ ତୁର୍‌ତ୍ୟାନ୍‌ସା ମେଁନେ ଲିଜନ୍ନିଆ ବେକେ; ");
INSERT INTO gaq_vpl VALUES ("LK15_16","072_15_16","LUK","15","16","16","ବାରି ଗୁବୁଗ୍ଇଂ ଆଣ୍ତିନେ ଆମ୍ବୁଗ୍‌ ଚଙ୍ଗ୍‌ଡିଂକେ ଆତ୍‌ବାନ୍ ମେଁ ନିଜର୍ ସୁଲୁଏ ଆବ୍‍ସେ ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ଡାଗ୍ଲା ଆମେକେ ମେଃଡିଗ୍ ଆବିଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK15_17","072_15_17","LUK","15","17","17","ଆରି ମେଁ ଚେତ୍‍ନା ବାଚେ ବାଲିର୍‌କେ ନେଙ୍ଗ୍ ଆବାନେ ଉଡ଼ି ଚାକର୍‍ଇଂନେ କାଦି ଅଗ୍ଲେ ଡିଙ୍ଗ୍‌କେ ମାତର୍‌ ନେଙ୍ଗ୍ ଆକ୍‌ଅରିଆ କେଡ଼େସଃ ଗୁଏଣ୍ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_18","072_15_18","LUK","15","18","18","ନେଙ୍ଗ୍ ଆକେନ୍ ଜାଗା ଆନ୍‌ତାର୍‌ଚେ ନେଙ୍ଗ୍‌ନେ ଆବାନେ ଡାଗ୍ରା ଙ୍ଗୁଏଃଏ ଆରି ଆବାକେ ମ୍ବାସଙ୍ଗ୍‌ଏ ଆବା ଇସ୍‌ପର୍‌ନେ ବିରଦ୍‌ରେ ଆରି ନାନେ ବିରଦ୍‌ରେ ନେଙ୍ଗ୍ ପାପ୍ ଡିଙ୍ଗ୍‍ମ୍ୱକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_19","072_15_19","LUK","15","19","19","ନାଁନେ ଉଙ୍ଗ୍‌ଡେ ଡାଗ୍‌ଚେ ୱାନେ ନେଙ୍ଗ୍ ଦର୍‌କାର୍ ଣ୍ତୁ ଆନେଙ୍ଗ୍ ନାଁନେ ମୁଇଙ୍ଗ୍‌ ଗୁତିରେ ରକମ୍ ବ । ");
INSERT INTO gaq_vpl VALUES ("LK15_20","072_15_20","LUK","15","20","20","ଆତ୍‌ବାନ୍ ମେଁ ଆତେନ୍‌‌ ଜାଗା ଆନ୍ତର୍‌ଚେ ନିଜର୍ ଆବାନ୍ନିଆ ୱେଗେ । ଡାଗ୍ଲା ଉଙ୍ଗ୍‌ଡେ ସ୍ଲ ଲେଃନେ ବେଲା ମେଁନେ ଆବାଡ଼େ ଆମେକେ କେଚେ ଲିବିସଃଚେ ତର୍‌ତର୍‌ ଡିଙ୍ଗ୍‌କେ ଆରି ୱିର୍‌ ଡୁଂୱେଚେ ୱେଚେ ଆମେକେ କଣ୍ଡଚେ ବୈନ୍ତାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_21","072_15_21","LUK","15","21","21","ଉଙ୍ଗ୍‌ଡେ ଆମେକେ ବାଲିର୍‍କେ ଆବା ଇସ୍‌ପର୍‌ନେ ବିରଦ୍‌ରେ ଆରି ନାନେ ବିରଦ୍‌ରେ ନେଙ୍ଗ୍ ପାପ୍ ଡିଙ୍ଗ୍‍ମ୍ୱକେ ନାନେ ଉଂ ଡାଗ୍‌ଚେ ୱାନେ ନେଙ୍ଗ୍ ଆରି ଦର୍‌କାର୍‌ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK15_22","072_15_22","LUK","15","22","22","ମାତର୍‌ ଆବାଡ଼େ ମେଁନେ ଚାକର୍‍ଇଂକେ ବାସଙ୍ଗ୍‌କେ ସାପାବାନ୍‍ ନିମାଣ୍ଡା ପାଟାଇ ଟାପ୍‌ନା ଡୁଂପାଙ୍ଗ୍‌ଚେ ଆକ୍‌ମେକେ ଆସଗ୍‌ପା ଆକ୍‌ମେନେ ନ୍ତି ୱାର୍ତି ଆରି ଞ୍ଚନିଆ ଜୁତା ଆତାଙ୍ଗେପା । ");
INSERT INTO gaq_vpl VALUES ("LK15_23","072_15_23","LUK","15","23","23","ବାରି ଗାଗ୍‌ଡ଼େକ୍ନେ ପଶୁ ଡୁଂପାଙ୍ଗ୍‌ଚେ ବାଗୁଏଃପା; ପାଙ୍ଗ୍‌ଲାପା ନେ ସାପାରେ ଚଙ୍ଗ୍‌ଚେ ସାର୍ଦା ନେଃଡିଂପା । ");
INSERT INTO gaq_vpl VALUES ("LK15_24","072_15_24","LUK","15","24","24","ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ଆକେନ୍ ଉଙ୍ଗ୍‌ଡେ ଗୁଏଲେଃକେ ବାରି ମୁଇଙ୍ଗ୍ ତର୍ ମ୍ୱ୍ରକେ ମେଁ ବଃଲେକେ ବାରି ମିଲେକେ । ଆତ୍‌ବାନ୍ ମେଇଙ୍ଗ୍‌ ସାର୍ଦା ଆଡିଙ୍ଗ୍‌ନେ ମୁଲେଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK15_25","072_15_25","LUK","15","25","25","“ଆତେନ୍‌‌ ବେଲା ମେଁନେ ମ୍ନା ଉଙ୍ଗ୍‌ଡେ ଲିଜ ଲେଃଗେ । ମେଁ ଉଡ଼ିବେଲା ପାଙ୍ଗ୍‌ଚେ ଡୁଆ ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାକେ, ଆତେନ୍‌‌ ବେଲା କାଣ୍ତେଙ୍ଗ୍‌ ଆରି ୱାଡ଼େଙ୍ଗ୍‌ ନ୍ନାଂକ୍ନେ ଦ୍ରିଗ୍‌ ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_26","072_15_26","LUK","15","26","26","ଆରି ଚାକର୍‌ଇଂନେ ବାନ୍ ମୁଇଂଜାକେ ଡାଗ୍ରା ୱାଚେ ଆତେନ୍‌ ସାପା ମେଁନେ ଡାଗ୍‌ଚେ ସାଲିଆକୁନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_27","072_15_27","LUK","15","27","27","ଗୁତିରେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ ନାଁନେ ବୟାଁ ଡୁଆ ଆଣ୍ତେ ପାଙ୍ଗ୍‌ଲେଃକେ ବାରି ନାଁନେ ଆବା ଆମେକେ ନିମାଣ୍ତା ଗାଗ୍‌ଡ଼େ ଅବାଚେ ଗାଗ୍‌ଡ଼େକ୍ନେ ପୁସୁ ମୁଇଙ୍ଗ୍ ବାଗୁଏଃବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK15_28","072_15_28","LUK","15","28","28","ଆତ୍‌ବାନ୍ ମେଁ ରିସା ଡିଙ୍ଗ୍‌ଚେ ବିତ୍ରେ ୱେନ୍‌ସା ମନ୍ ଆଡିଙ୍ଗ୍‍କେ ଣ୍ତୁ; ଡାଗ୍ଲା ମେଁନେ ଆବାଡ଼େ ବାଜାର୍‌ ପାଙ୍ଗ୍‌ଚେ ଆମେକେ ଜବର୍ ଆଃବୁଜେନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK15_29","072_15_29","LUK","15","29","29","ମ୍ନାଃ ଉଙ୍ଗ୍‌ଡେ ଆବାଡ଼େକେ ବାସଙ୍ଗ୍‌କେ, ଅଃକେନ୍ ମୁଆଁ ଡିଙ୍ଗ୍‌ଗେ ନେଙ୍ଗ୍‌ ନାଁନେ ଗତିରେ ରକମ୍ କଟେନ୍‌ଲେକେ ବାରି ଅଃନାଡିଗ୍ ନାଁନେ ଆଦେସ୍‌ ଅମାନି ନାଡିଂକେ ଣ୍ତୁ, ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ସାଙ୍ଗଇଂ ଏଃତେ ସାର୍ଦା ଡିଙ୍ଗ୍‌ନ୍‌ସା ନାଁ ଆନେଙ୍ଗ୍ ଅଃନାଡିଗ୍ ଗିମିଃ ଉଙ୍ଗ୍‌ଡେ ଡିଗ୍ ନାବିଃକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK15_30","072_15_30","LUK","15","30","30","ମାତର୍‌‌ ଆଡିନେ ଉଙ୍ଗ୍‌ଡେ ନାଁନେ ସାପା ସମ୍ପତି ଦଦ୍ୟା‌ ରେମୁଆଁଇଂ ଏତେ ଚଙ୍ଗ୍‌ ଆଡାକେ ମେଁ ଡୁଆ ଆଣ୍ତେ ପାଙ୍ଗ୍‌ଲା ନାଁ ମେନ୍‌ସା ଗାଗ୍‌ଡ଼େକ୍ନେ ଅରେଃ ନାବାଗୁଏକେ । ଆବାଡ଼େ ବୁଜେଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK15_31","072_15_31","LUK","15","31","31","ଅ ଗଡ଼େଅ, ନା ତ କାଲାଆଃ ନେଙ୍ଗ୍‌ ଏତେ ଆକ୍‌ଅରିଆ ଲେଃନାଡିଙ୍ଗ୍‌କେ ବାରି ନେଙ୍ଗ୍‌ନେ ମେଃନେ ଲେଃକେ ଆତେନ୍‌‌ ସାପା ନାଁନେ ");
INSERT INTO gaq_vpl VALUES ("LK15_32","072_15_32","LUK","15","32","32","ନାବୟାଁ ଗୁଏଃ ଲେଃଗେ ମାତର୍‌‌ ଏବେ ମ୍ୱ୍ରଲେଃକେ । ମେଁ ବଃୱେଲେଃଗେ ଏବେ ମିଲେକେ । ଏନ୍‌ସା ନେ ମ୍ଲେଡ଼୍ୟାଚେ ବଜି ଡିଙ୍ଗ୍‌ନେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK16_1","072_16_1","LUK","16","1","1","ଜିସୁ ମେଁନେ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ ମୁଇଙ୍ଗ୍‌ ସାଉକାର୍‌ ରେମୁଆଁ ଲେଃକେ; ମେଁନେ ମୁଇଙ୍ଗ୍‌ ଗୁମୁସ୍ତା ଲେଃକେ ବାରି ମେଁ ମେଁନେ ସମ୍ପତ୍ତି ଜଟେ ଡିଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ମେଁନେ ବିସୟ୍‌ରେ ବଦ୍‌ଲାମ୍‌ ଅଁଚେ ସାଉକାର୍‌ ଗୁମୁସ୍ତାକେ ୱାଚେ ବାସଙ୍ଗ୍‌ଡିଂକେ ");
INSERT INTO gaq_vpl VALUES ("LK16_2","072_16_2","LUK","16","2","2","ନେଙ୍ଗ୍ ନାନେ ବିସୟ୍‌ରେ ଡିରକମ୍ ସାମୁଆଁ ଅଁନ୍ଲେକେ ? ନାନେ ଗୁମୁସ୍ତା କାମ୍‍ରେ ଇସାବ୍ ବିଃଲା ଡାଗ୍ଲା ନାନେ ଆରି ଗୁମୁସ୍ତା ଡିଙ୍ଗ୍‌ଚେ ଲେଃ ନାୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK16_3","072_16_3","LUK","16","3","3","ଆତ୍‌ବା ଆତେନ୍‌ ଗୁମୁସ୍ତା ମନେ ମନେ ବାସଙ୍ଗ୍‌କେ ମେଃଣ୍ଡିଂଏ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁ ତ ନେଙ୍ଗ୍‍ବାନ୍‍ ଗୁମୁସ୍ତା ପଦ୍‍ ଆଆନ୍ତାର୍ ବିଃବକେ । ତୁବଃ ଗଃନ୍‌ସା ନେଙ୍ଗ୍‌ନେ ବପୁ ଣ୍ଡୁ ବିକ୍‍ ସାଲିଆ ନ୍‌ସା ଆନେଙ୍ଗ୍ ଗିଆସଃ ଡଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK16_4","072_16_4","LUK","16","4","4","ନେଙ୍ଗ୍ ଗୁମୁସ୍ତା ପଦ୍‌ବାନ୍‌ ଆନ୍ତାର୍ ବିଃକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ରେମୁଆଁଇଂ ଡିରକମ୍ ଆନେଙ୍ଗ୍ ନିଜେ ନିଜେନେ ଡୁଆ ଟାନ୍ ବିଆର୍‌ଏ ଆକେନ୍‌ସା ମେଃନେ ଣ୍ଡିଂଏ ଆତେନ୍‌‌ ମ୍ୟାନେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK16_5","072_16_5","LUK","16","5","5","ବାରି ଗୁମୁସ୍ତା ନିଜେନେ ମାପ୍ରୁନେ ସାପା ରୁନ୍‌ ଡୁଂୱିଗ୍‌ଣ୍ଡ୍ରେକେ ଡାଗ୍ରା ୱେଚେ ସେନୁଗ୍‌ ମୁଇଙ୍ଗ୍‌ଜାକେ ବାଲିର୍‌କେ ନାଁନେ ଆଡ଼ାତ୍ରା ନେଙ୍ଗ୍ ମାପ୍ରୁନେ ଉଡ଼ି ରୁନ୍‌ ବାକି ଲେଃକେ, ମେଁ ବାସଙ୍ଗ୍‌କେ ମାଲ୍‌କୁଡ଼ି ଡାବା ଞ୍ଚୁ । ");
INSERT INTO gaq_vpl VALUES ("LK16_6","072_16_6","LUK","16","6","6","ମେଁ ବାସଙ୍ଗ୍‌କେ, ମୁଇଂ ସହ ପିପା ଞ୍ଚୁ । ଗୁମୁସ୍ତା ଆମେକେ, ନାନେ ନିଅମ୍ ଉଲିଆ ଡୁଂପାଙ୍ଗ୍‍ଚେ ଜିଆଃ କଚେ ୫୦ ଡାଗ୍‌ଚେ ଗୁଆର୍‍ । ");
INSERT INTO gaq_vpl VALUES ("LK16_7","072_16_7","LUK","16","7","7","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଗୁମୁସ୍ତା ବାରି ମୁଇଂଜାକେ ବାଲିର୍‌କେ ନାଁନେ ଆଡ଼ାତ୍ରା ଉଡ଼ି ରୁନ୍‌ ଲେଃକେ ମେଁ ବାସଙ୍ଗ୍‌କେ ମାଲ୍‌କୁଡ଼ି ବାସ୍ତା ଗହମ୍ ଗୁମୁସ୍ତା ଆମେକେ ବାସଙ୍ଗ୍‌କେ ନାନେ ଇସାବ୍ ଡୁଂୱେଚେ ଅଁକୁଡ଼ି ଡାଗ୍‌ଚେ ଗୁଆର୍‌ । ");
INSERT INTO gaq_vpl VALUES ("LK16_8","072_16_8","LUK","16","8","8","“ଆତେନ୍‌‌ ଅଦର୍ମ ଗୁମୁସ୍ତା ବୁଦି ଏଃତେ କାମ୍ ଡିଙ୍ଗ୍‌ବଲା ମେଁନେ ମାପ୍ରୁ ଆମେକେ ସାର୍ଦା ଡିଙ୍ଗ୍‌କେ, ଡିଲାଡିଗ୍‌ ଆକେନ୍ ଜୁଗ୍‌ନେ ଗଡ଼େଇଙ୍ଗ୍ ମେଁଇଂନେ ଜାତିନେ ଆଡ଼ାତ୍ରା ତାରାସ୍‌ନେ ଗଡ଼େଇଂନେ ବାନ୍ ଜାବର୍ ଚାଲାକି ଲେଃଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK16_9","072_16_9","LUK","16","9","9","ନେଙ୍ଗ୍ ଡିଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଅଦର୍ମ ଦନ୍‌କେ ନିଜେ ନିଜେ ନ୍‌ସା ରେମୁଆଁ ଲାବ୍‌ ଆଡିଙ୍ଗେପା, ଡିରକମ୍ ଆତେନ୍‌ ଡାୱେଲା ଆପେକେ ମାଡାନେ ଡୁଆନ୍ନିଆ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ");
INSERT INTO gaq_vpl VALUES ("LK16_10","072_16_10","LUK","16","10","10","ଜାଣ୍ଡେ ଇତୁଡ଼ା ବିସୟ୍‌ରେ ବିସ୍‌ବାସ୍‌‍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଗୁଲୁଏ ବିସୟ୍‌ରେ ଡିଗ୍ ବିସ୍‌ବାସ୍‌‍ ଡିଙ୍ଗ୍‌ଏ । ଆରି ଜାଣ୍ଡେ ଇତୁଡ଼ା ବିସୟ୍‌ରେ ଅବିସ୍‌ବାସ୍‌‍ ଡିଂଏ ମେଁ ଗୁଲୁଏ ବିସୟ୍‌ରେ ଡିଗ୍ ଅବିସ୍‌ବାସ୍‌‍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK16_11","072_16_11","LUK","16","11","11","ଜଦି ପେଇଙ୍ଗ୍‌ ଦର୍‌ତନିନେ ଦନ୍‌କେ ଅବିସ୍‌ବାସ୍‌‍ ପେଡିଙ୍ଗ୍ଏ ତେଲା ଜାଣ୍ଡେ ଆପେକେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଚେ ସତ୍‌ନେ ଦନ୍ ଆପେକେ ନ୍ତି ସର୍ପେବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK16_12","072_16_12","LUK","16","12","12","ବାରି ଆଡିନେ ବିନ୍‌ଣ୍ଡ୍ରେନେ ଆତ୍‌ ଅରିଆ ଜଦି ପେ ବିସ୍‌ବାସ୍‌ ପେଡିଙ୍ଗ୍‌କେ ତେଲା ଆଡିନେ ପେନେ ନିଜର୍‌ନେ ଆତାନ୍‌ ଜାଣ୍ତେ ଆପେକେ ବିଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK16_13","072_16_13","LUK","16","13","13","“ଆଣ୍ତିନେ ସେବାଣ୍ତ୍ରେ ମ୍ୱାକ୍ଲିଗ୍‌ ମାପ୍ରୁନେ ସେବା ଡିଙ୍ଗ୍‌ ଆୟା ଣ୍ତୁ, ଡାଗ୍‌ଲା ମେଁ ମୁଇଙ୍ଗ୍‌ଜାକେ ଇଙ୍ଗ୍‌ଚେ ଡିଙ୍ଗ୍‌ଏ ଆରି ବିନ୍ ମୁଇଙ୍ଗ୍‌ଜାକେ ଆଲାଦ୍ ନାଡିଂଏ ଣ୍ତୁଲା ମୁଇଙ୍ଗ୍‌ଜାନେ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ଆରି ବିନ୍ ମୁଇଂଜାକେ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ । ପେଇଙ୍ଗ୍‌ ଇସ୍‌ପର୍ ଆରି ଦନ୍ ମ୍ୱାୟାନେ ଜତନ୍‌ ଡିଙ୍ଗ୍ ପେୟା ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK16_14","072_16_14","LUK","16","14","14","“ଆକେନ୍ ସାପା ସାମୁଆଁ ଅଁଚେ ପାରୁସିଇଙ୍ଗ୍ ଜିସୁନେ ଆଡ଼ାତ୍ରା ରିସା ଡିଙ୍ଗ୍‌ଆର୍କେ ଡାଗ୍ଲା ମେଇଂ ଡାବୁକେ ବଲ୍‌ବା ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK16_15","072_16_15","LUK","16","15","15","ଆତ୍‌ବା ଜିସୁ ଫାରୁଶୀଇଂକେ ବାସଙ୍ଗ୍‌କେ ଜାଣ୍ଡେଇଂ ନିଜେ ନିଜେକେ ରେମୁଆଁଇଂ ମୁଆଃନ୍ନିଆ ଦାର୍ମିକ୍ ଡାଗ୍‌ଚେ ଆସୁଏ ପେଇଂ ଦେତ୍‌ସୁଗୁଆ ରେମୁଆଁ ମାତର୍‌ ଇସ୍‌ପର୍ ପେନେ ଜିବନ୍‍କେ ମ୍ୟାଲେଃକେ । ଡାଗ୍ଲା ଆଣ୍ଡିନେ ରେମୁଆଁଇଂନେ ବିତ୍ରେ ମ୍ନାଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ଇସ୍‌ପର୍‌ନେ ମୁଆଃନ୍ନିଆ ଗୁର୍‌ନା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK16_16","072_16_16","LUK","16","16","16","ମୋଶାନେ ନିୟମ୍‌ ଆରି ବାବବାଦିଇଂନେ ଦର୍ମସାସ୍ତ୍ରି ବାପ୍ତିଜକ ଜହନ୍‌ନେ ଜାକ ବାସଙ୍ଗ୍‌‌ ଲେଃକେ ଆତେନ୍‌ ବେଲାବାନ୍‌ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ନିମାଣ୍ତାବାର୍ତ୍ତା ବାସଙ୍ଗ୍‌‌ ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ଆରି ଗୁଲେ ରେମୁଆଁ ବପୁ ଏତେ ଆତ୍‌ଅରିଆ ୱେଚା ଆର୍‌ଡିଙ୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK16_17","072_16_17","LUK","16","17","17","ଡାଗ୍ଲା ନିୟମ୍‌ ମୁଇଙ୍ଗ୍‌ ଡାଆଁନେ ମୁଇଙ୍ଗ୍ ଟପା ଡିଗ୍‌ ଦଂସ ଆଡିଙ୍ଗ୍‌ ଣ୍ଡୁ ଆତେନ୍‌‌ସା କିତଂଇନି ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ ଦଂସ ଡିଂଏ ତ ସଅଜ୍‌ରେ ଦଂସ ଡିଂଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK16_18","072_16_18","LUK","16","18","18","“ଜାଣ୍ତେ କି ନିଜର୍ ସେଲାମ୍ବୁଏଃକେ ଆନ୍ତାର୍‌ଚେ ବିନିନେ ବିହେ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଅଡ଼ାରେଗ୍‌‌ ଡିଙ୍ଗ୍‌ଏ; ଆରି ଆଣ୍ତିନେ ଙ୍ଗିର୍‌ବଏ ମୁଇଙ୍ଗ୍ ଆନ୍ତାର୍‌କ୍ନେ ସେଲାମ୍ବୁଏଃକେ ବିହେ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଡିଙ୍ଗ୍ ଅଡ଼ାରେଗ୍‌‌ ପାପ୍‌ରେ ଦସ୍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK16_19","072_16_19","LUK","16","19","19","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ମୁଇଙ୍ଗ୍‌ ସାଉକାର୍‌ ରେମୁଆଁ ଲେଃକେ ମେଁ କାଲାଆଃ ନିମାଣ୍ତା ପାଟାଇ ଅଡ଼େଗ୍‌ଚେ ମ୍ନା ସାର୍ଦାରେ କାଲାଆଃ ଡୁଂୱିଗ୍‌ ଡୁଂପାଙ୍ଗ୍‌ଡିଂକେ ");
INSERT INTO gaq_vpl VALUES ("LK16_20","072_16_20","LUK","16","20","20","ମାତର୍‌ ମେଁନେ ପ୍ଲେଡ଼ିଆନେ ଡାଗ୍ରା ଲାଜାର୍‍ ଡାଗ୍‌ଚେ ମୁଇଙ୍ଗ୍ ବିକାରି ଲଃଲେକେ । ମେଁନେ ଗାଗ୍‌ଡ଼େ ସାପା ଇରିଃ ବର୍ତି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK16_21","072_16_21","LUK","16","21","21","ଲାଜାର୍ ଆତେନ୍‌‌ ସାଉକାର୍‌ ରେମୁଆଁନେ ଚଙ୍ଗ୍‌ଚେ ଆଣ୍ତିନେ ଆନ୍ତାର୍‍ ବିଏ ଆତେନ୍‌‌ ଜୁଟାବାନ୍‌ ଉଡ଼ି ଚଙ୍ଗ୍‌ଚେ ସୁଲୁଏ ଆବ୍‌ସେ ନ୍‌ସା ଆସା ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ବାରି ଗୁସୁଃଇଂ ପାଙ୍ଗ୍‌ଚେ ମେଁନେ ଇରିଃ ସାପା ଚାଲିଃ ଡିଙ୍ଗ୍ଆର୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK16_22","072_16_22","LUK","16","22","22","ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ଲାଜାର୍‍ ଗୁଏ ୱେକେ ଆରି କିତଂନେ ଦୁତ୍‍ଇଂ ପାଙ୍ଗ୍‌ଚେ ଅବ୍ରାହାମ୍‌ନେ ବୁଲୁନ୍ନିଆ ଡୁଙ୍ଗ୍‍ ୱେକେ ତେନ୍‌ ଇଡ଼ିଂ ଆତେନ୍‌ ସାଉକାର୍‌ ରେମୁଆଁ ଡିଗ୍ ଗୁଏ ୱେକେ ଆରି ଆମେକେ ରାଃଚ୍ୟାନ୍ନିଆ ଆତିବିଃ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK16_23","072_16_23","LUK","16","23","23","ଆରି ସାଉକାର୍‌ ରେମୁଆଁ ନର୍କ କୁଣ୍ଡ୍‌ନ୍ନିଆ ତେରେପେତେ ଡିଙ୍ଗ୍‌ଚେ ଆଡ଼ାତ୍ରା ତାଣ୍ଡେଚେ ଅବ୍ରାହାମ୍‌ନେ ବୁଲୁନ୍ନିଆ ଲାଜାର୍‍କେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK16_24","072_16_24","LUK","16","24","24","ଆତ୍‌ବାନ୍ ସାଉକାର୍‌ ରେମୁଆଁ ୱାଚେ ବାସଙ୍ଗ୍‌କେ ଅ ଆବା ଅବ୍ରାହାମ୍ ଆନେଙ୍ଗ୍ ଦୟା ଡିଂଚେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ଲାଜାର୍‌କେ ବେବିଃଲାପା ଡିରକମ୍ ମେଁ ଣ୍ତିଆନ୍ନିଆ ନିଜେନେ ଞ୍ଚୁଏତିନ୍ନିଆ ଟିପ୍ ଆଲଗ୍‌ଚେ ନେଙ୍ଗ୍ ନ୍ଲ୍ୟାନ୍ନିଆ ଚୁଇଡ଼ିଆ ଆଃଡିଙ୍ଗ୍ଏ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆକେନ୍ ସୁଆନ୍ନିଆ ତେରେପେତେ ଡିଙ୍ଗ୍‌ଣ୍ଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("LK16_25","072_16_25","LUK","16","25","25","ଡାଗ୍ଲା ଅବ୍ରାହାମ୍ ବାସଙ୍ଗ୍‌କେ, “ଗଡ଼େଅରେ ନାଁ ଜେ ମ୍ୱ୍ରଲେକ୍ନେ ବେଲା ନାଁନେ ନିମାଣ୍ତା ବିସୟ୍ ସାପା ନାବାକେ ବାରି ଲାଜାର୍ ଦେକ୍‌ରକମ୍ ଦଦ୍ୟା ବିସୟ୍ ସାପା ବାକେ ଆକେନ୍ ଏତେ ବେଲା; ଡାଗ୍ଲା ଏକ୍ରେ ମେଁ ଆକେନ୍ ଜାଗାନ୍ନିଆ ସାନ୍ତି ବାଡିଂକେ ବାରି ନାଁ ତେରେପେତେ ଡିଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK16_26","072_16_26","LUK","16","26","26","ଆତେନ୍‌ ଆନ୍ତାର୍‌ଚେ ନାନେ ନେଙ୍ଗ୍ ବିତ୍ରେ ଜବର୍ ମ୍ନାନେ ନିୟମ୍‌ ଲେଃକେ ଜେନ୍ତିକି ଜାଣ୍ଡେଇଂ ଆକେନ୍ ଜାଗାବାନ୍‍ ପେଇଂନେ ଡାଗ୍ରା ୱେନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ମେଇଂ ୱେ ଆୟାଆର୍‍ ଣ୍ଡୁ ଆରି ଆତେନ୍‌ ଜାଗାବାନ୍‍ ଜାଣ୍ଡେ ନେଁଇଂନେ ଡାଗ୍ରା ପୁଆଚେ ପାଙ୍ଗ୍ ଆୟାଆର୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK16_27","072_16_27","LUK","16","27","27","ଆତ୍‌ବାନ୍ ସାଉକାର୍‌ ରେମୁଆଁ ବାସଙ୍ଗ୍‌କେ ଅ ଆବା ଅବ୍ରାହାମ୍ ତେଲା ନେଙ୍ଗ୍ ଆନାକେ କୁସାମୁତି ଡିଙ୍ଗ୍‌ଣ୍ଡିଂ ଲାଜର୍‌କେ ନେଙ୍ଗ୍‌ନେ ଆବା ଡୁଆ ବେ ବିଃଲା । ");
INSERT INTO gaq_vpl VALUES ("LK16_28","072_16_28","LUK","16","28","28","ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ମାଲିକ୍ଲିଗ୍‌ ବୟାଁ ଲେଃଆର୍‌କେ; ମେଇଙ୍ଗ୍ ଡିଙ୍ଗ୍ ଡିରକମ୍ ଆକେନ୍ କସ୍ଟ ଡିଙ୍ଗ୍‌ନେ ଜାଗାନ୍ନିଆ ଆପାଙ୍ଗ୍‌ଆର୍‌ଲେ ତେସା ଲାଜାର୍ ମେଇଙ୍ଗ୍‌ନେ ଡାଗ୍ରା ସାକି ବିଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK16_29","072_16_29","LUK","16","29","29","ମାତର୍‌ ଅବ୍ରାହାମ୍ ବାସଙ୍ଗ୍‌କେ, “ମେଇଂ ଡାଗ୍ରା ମୋଶା ଆରି ବାବବାଦି‍ଇଂନେ ଦରମ୍‌ ସାସ୍ତର୍‌ ଲେଃକେ ମେଇଂ ମେଁଇଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁନେ ଦର୍‌କାର୍ । ");
INSERT INTO gaq_vpl VALUES ("LK16_30","072_16_30","LUK","16","30","30","ଆତ୍‌ବା ମେଁ ବାସଙ୍ଗ୍‌କେ ଏ ଆବା ଅବ୍ରାହାମ୍ ଅଃତେନ୍‍ ଆଃ ଜବର୍ ଣ୍ଡୁ ମାତର୍‌ ଗୁଏକ୍ନେ ଡାଗ୍ରା ମୁଇଂଜା ମେଇଂ ଡାଗ୍ରା ୱେଏ ତେଲା ମେଇଂ ମନ୍ ଆବଦ୍‌ଲେ ଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK16_31","072_16_31","LUK","16","31","31","ଡାଗ୍ଲା ଅବ୍ରାହାମ୍ ସାଉକାର୍‌ ରେମୁଆଁକେ ବାସଙ୍ଗ୍‌କେ ଜଦି ନାଁନେ ବୟାଁଇଂ ମୋଶା ବାରି ବାବବାଦିଇଂନେ ସାମୁଆଁ ଆ‍ଅଁଆର୍ ଣ୍ତୁ ଦେତ୍‌ଲା ମେଇଙ୍ଗ୍ ଗୁଏକ୍ନେଣ୍ତ୍ରେ ରେମୁଆଁ ବାନ୍ ମୁଇଙ୍ଗ୍‌ଜା ୱେଚେ ବାସଙ୍ଗ୍‌ଲା ଡିଗ୍ ଆ‍ଅଁଆର୍ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK17_1","072_17_1","LUK","17","1","1","ଜିସୁ ମେଁନେ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ ଡିଲାଡିଗ୍‌ ଆକେନ୍ ଗଟ୍‌ନା ଗଟେନେ ଗଟେଏ । ଆଣ୍ତିନେ କାରନ୍‌ରେ ରେମୁଆଁଇଂ ପାପ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ମାତର୍‌‌ ଆଣ୍ତିନେ ରେମୁଆଁ ବାନ୍‌ ଦେକ୍‌ରକମ୍ ଗଟ୍‌ନାଇଂ ଗଟେଏ । ଆତେନ୍‌‌ ରେମୁଆଁ ନ୍‌ସା ଆକେନ୍ ଜବର୍ ଦଦ୍ୟା ଡିଙ୍ଗ୍‌ଏ । ଆତେନ୍‌ ରେମୁଆଁନେ କସ୍ଟ ବ ");
INSERT INTO gaq_vpl VALUES ("LK17_2","072_17_2","LUK","17","2","2","ଜାଣ୍ଡେ ରେମୁଆଁ ଆକେନ୍ ଡାଆଁରେ ଗଡ଼େଅଇଂନେ ବାନ୍ ମୁଇଂଜାକେ ପାପ୍ ଆଃଡିଙ୍ଗ୍ଏ ମେଁନ୍‌ସା ଆତେନ୍‌‌ସା ଲୁଗଃନ୍ନିଆ ମୁଇଙ୍ଗ୍‌ ବ୍ରି ଗାଗ୍‌ଚେ ମେଁ କେଣ୍ଡିଆନ୍ନିଆ ଲଗ୍‌ଡ୍ୟାଃ ଗୁଏନେ ମେଁନ୍‌ସା ନିମାଣ୍ତା ଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("LK17_3","072_17_3","LUK","17","3","3","ତେଲା ପେ ସାପାରେ ନିଜେ ନିଜେ ବିସ‍ଏରେ ନିମାଣ୍ଡା ଲାଲାପା । ଜଦି ନାନେ ବୟାଁ ପାପ୍ ଡିଙ୍ଗ୍‌ଏ, ତେଲା ଆମେକେ ଆଃମିସୁଃପା ବୁଲ୍‌ ଡିଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍ ବାରି ମେଁ ମନ୍ ବଦ୍‌ଲେଏ ତେଲା ଆମେକେ ଲିବିସ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("LK17_4","072_17_4","LUK","17","4","4","ଆରି ଜଦି ମେସୁଆ ବିତ୍ରେ ଗୁକ୍ଲିଗ୍ ତର୍ ପେନେ ବିରଦ୍‌ରେ ପାପ୍ ଡିଙ୍ଗ୍‌ଏ ଆରି ଗୁକ୍ଲିଗ୍ ତର୍ ପେନେ ଡାଗ୍ରା ଆଣ୍ତେ ପାଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍‌ ମନ୍‌ ବଦ୍ଲେ ମ୍ୱକେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍ଏ ତେଲା ଆମେକେ ଲିବିସ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK17_5","072_17_5","LUK","17","5","5","ଆତ୍‌ବାନ୍ ପ୍ରେରିତ୍‌ଇଂ ମାପ୍ରୁକେ ବାସଙ୍ଗ୍‌କେ, “ନେନେ ବିସ୍‌ବାସ୍ ଆମ୍ନାବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK17_6","072_17_6","LUK","17","6","6","ମାପ୍ରୁ ବାସଙ୍ଗ୍‌କେ ଜଦି ମୁଇଙ୍ଗ୍ ସରିସ୍‍ ମୁଞ୍ଜି ରକମ୍ ବିସ୍‌ବାସ୍ ଲେଃଏ, ତେଲା ଆକେନ୍ ତୁତ୍‌କୁଲି ସ୍ଲାକେ ନାଁ ବୁନ୍ଦେବାନ୍‌ ଡବେଗ୍‌ଚେ କେଣ୍ଡିଆନ୍ନିଆ ଉଂକେ ରକମ୍ ଲାଃଲା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଲା ଆତେନ୍‌ ପେ ସାପାରେନେ ସାମୁଆଁ ମାନେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK17_7","072_17_7","LUK","17","7","7","ତେଲା ପେ ସାପାରେନେ ବିତ୍ରେ ଦେକ୍‌ରକମ୍ ରେମୁଆଁ ଜାଣ୍ଡେ ଲେଃକେ, ଜାନେ ଚାକର୍‌ ଗିମି‍ଃଇଂ ତୁର୍‌ତ୍ୟାଚେ ବା ଲିଜ ସିଚେ ଲିଜବାନ୍ ପାଙ୍ଗ୍‌ଏ, ମାଲିକ୍ ଆମେକେ ବାସଙ୍ଗ୍ଏ, ଟାପ୍‌ନା ପାଙ୍ଗ୍‌ଚେ ଚଙ୍ଗ୍‌ଉଗ୍‌ କଲା । ");
INSERT INTO gaq_vpl VALUES ("LK17_8","072_17_8","LUK","17","8","8","ନାନେ ପେ ପେନେ ଚାକର୍‌କେ ପେବାସଙ୍ଗ୍‌ଏ, ନେଙ୍ଗ୍ ନ୍‌ସା ଚଙ୍ଗ୍‌ନେ ଆର୍ମେଚେ ବାରି ନେଙ୍ଗ୍ ଚଙ୍ଗ୍‌ଉଗ୍ ଡାଲା ପେଇଂ ପେଚଙ୍ଗ୍‌ଏ ଆରି ପେଉଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK17_9","072_17_9","LUK","17","9","9","ଚାକର୍‌ ସାମୁଆଁ ମାନେଚେ କାମ୍ ଡିଙ୍ଗ୍‌ବଲା ମେଁ ମେଁନେ ଆମେକେ ଆସିର୍ବାଦ୍ ବିଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK17_10","072_17_10","LUK","17","10","10","ଦେତ୍‌ରକମ୍ ପେ ସାପାରେ ଡିଙ୍ଗ୍ ସାମୁଆଁ ମାସାଚେ ସାପା କାମ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ପା ନେ ସାପାରେ ଅଦରମ୍ ଗତିରେ ଆଣ୍ତିନେ ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ ଆତେନ୍‌‌ ମାତର୍‌‌ ନେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_11","072_17_11","LUK","17","11","11","ଜିସୁ ଯିରୂଶାଲମନ୍ନିଆ ୱେନେ ବେଲା ସମରିଆ ବାରି ଗାଲିଲୀନେ ଗାଲି ବିଚେ ୱେଏ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_12","072_17_12","LUK","17","12","12","ଆରି ଜିସୁ ମୁଇଙ୍ଗ୍ ଇନିନିଆ ୱେଚାକ୍ନେ ଦାପ୍ରେ ଗୁଆ ରେମୁଆଁ କୁଷ୍ଟରଗିଇଂ ଜିସୁ ଏତେ ଅବାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_13","072_17_13","LUK","17","13","13","ମେଇଙ୍ଗ୍ ସ୍ଲବାନ୍ ତୁଆଁଚେ ମ୍ନା କଣ୍ଟରେ ବାଃଲିର୍‌ଆର୍‌କେ ଏ ଜିସୁ ! ଅ ଗୁରୁ ! ଆନେ ସାପାରେକେ ଲିବିସ ଡିଙ୍ଗ୍‌ବିଲା । ");
INSERT INTO gaq_vpl VALUES ("LK17_14","072_17_14","LUK","17","14","14","ଆରି ମେଁ ଆମେଇଂକେ କେଚେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ୱେଚେ ନିଜେ ନିଜ୍‍କେ ପୁଜାରି‍ଇଂକେ ଆସୁଏପା । ଆରି ମେଇଂ ପୁଜାରିଇଂନିଆ ୱେନେ ବେଲା ନିମାନ୍‍ ଡିଙ୍ଗ୍ ୱେଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK17_15","072_17_15","LUK","17","15","15","ଡାଗ୍ଲା ମେଇଙ୍ଗ୍‌ନେ ବିତ୍ରେ ମୁଇଙ୍ଗ୍‌ଜା ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ କେଚେ ମ୍ନା କଣ୍ଟରେ ଇସ୍‌ପର୍‌ନେ ମ‍ଇମା ଅସ୍‌ମାର୍ ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଚେ ଆଣ୍ତେ ୱିଗ୍‌ଚେ ");
INSERT INTO gaq_vpl VALUES ("LK17_16","072_17_16","LUK","17","16","16","ଆରି ଜିସୁନେ ପାଦ୍‌ଚ ବୁନ୍ଦେ ଡେଙ୍ଗଚେ ସାର୍ଲକେ ବାରି ଆମେକେ ଦନ୍ୟବାଦ୍ ବିକେ । ମେଁ ମୁଇଙ୍ଗ୍‌ଜା ଶମିରୋଣୀୟ ରେମୁଆଁ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_17","072_17_17","LUK","17","17","17","ଆତ୍‌ବାନ୍ ଜିସୁ ଉତର୍ ବିକେ ଗୁଆକ୍ଲିଗ୍ ରେମୁଆଁ ମେଁନେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ ଣ୍ତୁ । ତେଲା ଆରି ଗୋତ୍ମା ରେମୁଆଁ ଆଣ୍ତି ୱେଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_18","072_17_18","LUK","17","18","18","ଇସ୍‌ପର୍‌ନେ ଗୌରବ୍ ବିଃନ୍‌ସା ଆକେନ୍ ଶମିରୋଣୀୟ ରେମୁଆଁ ଆନ୍ତାର୍‌ଚେ ମେଁନେ ଆରି ଜାଣ୍ଡେ ଜାଣ୍ତେ ଆଉଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_19","072_17_19","LUK","17","19","19","ବାରି ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ ତଡ଼୍ୟା ବାରି ୱିଗ୍‌ଲା ନାଁନେ ବିସ୍‌ବାସ୍ ଆନାକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍ ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_20","072_17_20","LUK","17","20","20","ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ଅଃନା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଏନ୍‌ ବିସୟ୍‌ରେ ପାରୁସିଇଂ ଜିସୁକେ ସାଲିଆକୁ ଆର୍‌କେ ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ମୁଆଃନ୍ନିଆ ତ୍ନାକେ ସୁଗୁଆ ଆପାଙ୍ଗ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK17_21","072_17_21","LUK","17","21","21","କେଲାପା ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ଆତ୍‌ଅରିଆ କି ଆକ୍‌ଅରିଆ ଡାଗ୍‌ଚେ ରେମୁଆଁ ଆବାଲିର୍‌ଆର୍ ଣ୍ତୁ ଡାଗ୍ଲା କେଲାପା ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ପେ ସାପାରେନେ ବିତ୍ରେ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_22","072_17_22","LUK","17","22","22","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ ଦେକ୍ ରକମ୍ ବେଲା ପାଙ୍ଗ୍‌ଏ ଉଡ଼ିବେଲା ପେଇଙ୍ଗ୍‌ ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ସ୍ମି ଆଣ୍ଡେଙ୍ଗ୍ ବିତ୍ରେ ମୁଇଙ୍ଗ୍‌ ସ୍ମି କେନ୍‌ସା ଇକ୍‌ଚା ପେଡିଙ୍ଗ୍‌ଏ ଡାଗ୍ଲା ପେକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK17_23","072_17_23","LUK","17","23","23","କେଲାପା ଆତ୍‌ଅରିଆ କେଲାପା ଆକ୍‌ଅରିଆ ଡାଗ୍‌ଚେ ରେମୁଆଁଇଂ ଆପେକେ ବାସଙ୍ଗ୍ଏ; ଡାଗ୍ଲା ପେଇଙ୍ଗ୍‌ ଆୱେଗେପା । ");
INSERT INTO gaq_vpl VALUES ("LK17_24","072_17_24","LUK","17","24","24","ଡାଗ୍ଲା ବିଜ୍‌ଲି ବଗ୍‌ଚେ ଡିରକମ୍ କିତଂଅରିଆ ମୁଇଙ୍ଗ୍‌ ଡାଗ୍ରାବାନ୍‌ ଆରି ମୁଇଙ୍ଗ୍‌ ପାକା ଜାକ ତାର୍‌କିଗ୍ ବିଃଏ, ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ନେ ସ୍ମି ଦେତ୍ ରକମ୍ ତ୍ନା ଆଃରେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_25","072_17_25","LUK","17","25","25","ଡାଗ୍ଲା ସେନୁଗ୍ ଆମେକେ ଗୁଲେ ଦୁକ୍‌କସ୍ଟ ଡିଙ୍ଗ୍‌ଏ ବାରି ଆକେନ୍ ଟାପ୍‌ନା ଙ୍ଗିର୍‌ବ‍ଏଇଂ ବାନ୍ ଅମାନ୍ୟ ଡିଙ୍ଗ୍‌ନେ ପଡ଼େଏ । ");
INSERT INTO gaq_vpl VALUES ("LK17_26","072_17_26","LUK","17","26","26","ଆରି ନୋହଙ୍କ ବେଲା ଡିରକମ୍ ଗଟେ ଲେଃକେ ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ନେ ବେଲା ଡିଗ୍‌ ଦେତ୍‌ରକମ୍ ଗଟେଏ ");
INSERT INTO gaq_vpl VALUES ("LK17_27","072_17_27","LUK","17","27","27","ତରାନିଆ ନୋହଙ୍କ ଗିଃଗାଃନେ ସ୍ମି ଜାକ ରେମୁଆଁ ଚଙ୍ଗ୍ ଉଗ୍ ଆରି ବିହେ ଡିଙ୍ଗ୍‌ନେ ବାରି ବିହେ ବିନ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ ଇଡ଼ିଙ୍ଗ୍ ବୁରାଣ୍ଡ୍ୟାଃ ପାଙ୍ଗ୍‌ଚେ ସାପାରେକେ ବାଗୁଏଃଏ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_28","072_17_28","LUK","17","28","28","ପର୍‌ମେସର୍‌ ଲୋଟନେ ବେଲା ଡିଗ୍ ସଦୋମ ନଗର ଦଂସ ଡିଙ୍ଗ୍‌ନେ ବେଲା ରେମୁଆଁଇଂ ଚଙ୍ଗ୍ଉଗ୍ ବିଆର୍‌ ସହାଃ ସ୍ଲ ଉଙ୍ଗ୍‌ନେ ବାରି ଡୁଆ ଆଃରେ ଡିଙ୍ଗ୍ଆର୍‌ଏ ");
INSERT INTO gaq_vpl VALUES ("LK17_29","072_17_29","LUK","17","29","29","ଡାଗ୍ଲା ଲୋଟ ସଦୋମବାନ୍ ତାର୍‌ୱେନେ ସ୍ମି କିତଂବାନ୍ ସୁଆ ବାରି ବାସ୍ନା ଗୁର୍‌ଚେ ସାପାରେକେ ବାଗୁଏଃ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_30","072_17_30","LUK","17","30","30","ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ନେ ସ୍ମି ଦେତ୍‌ରକମ୍ ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK17_31","072_17_31","LUK","17","31","31","ଆତେନ୍‌ ସ୍ମି ଜାଣ୍ଡେ ନିଜର୍ ଡୁଆନେ ବ୍ଲେସାଂ ଆଡ଼ାତ୍ରା ଲେଃଏ ମେଁ ଡୁଆ ବିତ୍ରେ ଲେଃକ୍ନେ ନିଜେନେ ଜିନିସ୍‌ପତର୍‌ ଡୁଂୱିଗ୍ ନ୍‌ସା ଆପାଙ୍ଗ୍‍ଲେ । ଦେତ୍‌ରକମ୍ ଜାଣ୍ଡେ ନିଜର୍ ଲିଜନ୍ନିଆ ଲେଃଏ ମେଁ ଡୁଆ ଆପାଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_32","072_17_32","LUK","17","32","32","ଲୋଟନେ କୁନେଡ଼େନେ ସାମୁଆଁ ମନେତ୍ଲାକ୍‍ କେଲାପା । ");
INSERT INTO gaq_vpl VALUES ("LK17_33","072_17_33","LUK","17","33","33","ଜାଣ୍ତେ କି ନିଜର୍ ପାରାନ୍‌କେ ଆମ୍ବ୍ର ନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ଏ ମେଁ ଆତେନ୍‌‌ ଆନ୍ତାର୍‌ଏ ଆରି ଜାଣ୍ତେ କି ନିଜର୍ ପାରାନ୍‌କେ ଆନ୍ତାର୍‌ଏ ମେଁ ଆତେନ୍‌‌ ଆଃମ୍ବ୍ର‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK17_34","072_17_34","LUK","17","34","34","ନେଙ୍ଗ୍ ଆପେ ସାପାରେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଆତେନ୍‌‌ ମିଡିଗ୍ ମ୍ୱାୟା ମୁଇଙ୍ଗ୍‌ ଅରିଆ ଡୁଲେଗ୍ ଲେଃଆର୍‌ଏ, ମୁଇଙ୍ଗ୍‌ଜାକେ ଡୁଂୱିଗ୍ଆର୍‌ଏ ବାରି ବିନ୍‌ରେକେ ଆନ୍ତାର୍ ବିଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK17_35","072_17_35","LUK","17","35","35","ମ୍ୱାୟା ସେଲାମ୍ବୁଏ ମୁଇଂଅରିଆ ପ୍ନିଡିର୍‌ ଉଃଡିର୍ ଡିଂଲେଃଆର୍‌ଏ ମୁଇଙ୍ଗ୍‌ଜାକେ ଡୁଂୱେଆର୍‌ଏ ବାରି ଆର୍‌ମୁଇଂଜାକେ ଆନ୍ତାର୍‌ ବିଃଆରେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_36","072_17_36","LUK","17","36","36","ମ୍ୱାୟା ଲିଜ ଅରିଆ ଲେଃଆର୍‌ଏ ମୁଇଙ୍ଗ୍‌ଜାକେ ଡୁଂୱିଗ୍‌ଆର୍‌ଏ ବାରି ବିନ୍‌ନେ ମୁଇଙ୍ଗ୍‌ଜାକେ ଆନ୍ତାର୍ ବିଃ ଆରେ । ");
INSERT INTO gaq_vpl VALUES ("LK17_37","072_17_37","LUK","17","37","37","ଆତ୍‌ବାନ୍ ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଜିସୁକେ ସାଲିଆକୁ ଆର୍‌କେ ଅ ମାପ୍ରୁ ଆଣ୍ଡିଅରିଆ ଆତେନ୍‌ ଗଟେଏ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ଆଣ୍ତି ଅରିଆ ମଡ଼ା ଆତ୍‌ଅରିଆ ରାବନ୍ ପିଗ୍ଇଂ ଡିଗ୍ ମୁଇଂଅରିଆ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK18_1","072_18_1","LUK","18","1","1","ନିରାସ୍‌ ମାଡିଙ୍ଗ୍‌ଚେ କାଲାଆଃ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ ଆକେନ୍ ବିସୟ୍‌ରେ ଜିସୁ ସିସ୍‌ଇଂକେ ଉସ୍ରା ରକମ୍‌ ବୁଜେଚେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_2","072_18_2","LUK","18","2","2","“ମୁଇଙ୍ଗ୍ ଇନିନିଆ ମୁଇଙ୍ଗ୍ ସାସନ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଲେଃଗେ ମେଁ ଇସ୍‌ପର୍‌କେ ବୁଟ ଆଡିଙ୍ଗ୍‌ଗେ ରେମୁଆଁଇଂକେ ଡିଗ୍ ମାନେଃ ଆଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_3","072_18_3","LUK","18","3","3","ଆତେନ୍‌ ଇନିଅରିଆ ମୁଇଙ୍ଗ୍‌ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ଲେଃକେ ଆତେନ୍‌‌ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ପ୍ରେଗ୍‌ ପ୍ରେଗ୍‌ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ନେ ରେମୁଆଁକେ ୱେଚେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ମୁଇଙ୍ଗ୍‌ଜା ଆନେଙ୍ଗ୍ ଅନ୍ୟାୟ୍ ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ଆତେନ୍‌‌ ଅନ୍ୟାୟ୍‌ନେ ବିଚାର୍ ଡିଙ୍ଗ୍ ବିଃଲା । ");
INSERT INTO gaq_vpl VALUES ("LK18_4","072_18_4","LUK","18","4","4","ଡାଗ୍ଲା ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ନେ ରେମୁଆଁ ଆତେନ୍‌‌ ସେଲାମ୍ବୁଏକେ ସାଇଜ ଡିଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଆଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ ଡାଗ୍ଲା ଇଡ଼ିଙ୍ଗ୍ ମେଁ ମନେ ମନେ ବାସଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ଇସ୍‌ପର୍‌କେ ନ୍ନାବୁଟ ଣ୍ତୁ କି ରେମୁଆଁଇଂକେ ନାମାନେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK18_5","072_18_5","LUK","18","5","5","ଡାଗ୍ଲା ଆକେନ୍ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ସେଲାମ୍ବୁଏ ଆନେଙ୍ଗ୍ କସ୍ଟ ବିଡିଙ୍କେ, ନେଙ୍ଗ୍‌ ମେଁନେ ଆଡ଼ାତ୍ରା ଅନ୍ୟାୟ୍‌ନେ ନ୍ୟାୟ୍ ଅଦିକାର୍ ବିଃଜଗ୍‌ନ୍‌ତ୍ଲିଗ୍‌ଲା, ମେଁ ବାରି ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ଆନ୍ତାର୍ ବିଃଏ ଣ୍ତୁଲା ଆନେଙ୍ଗ୍ କାଲାଆଃ ପାଙ୍ଗ୍‌ଚେ ଅର୍‌ବର୍ ଆଃଡିଙ୍ଗ୍‌ବ‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK18_6","072_18_6","LUK","18","6","6","ଆତ୍‌ବା ମାପ୍ରୁ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ଅଦାର୍‌ମିକ୍ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ମେଁନେ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ ଆତେନ୍‌ ଅଁପା । ");
INSERT INTO gaq_vpl VALUES ("LK18_7","072_18_7","LUK","18","7","7","ତେଲା ଇସ୍‌ପର୍ ଆଣ୍ତିନେ ମନ୍‌ ରେମୁଆଁଇଂ ସ୍ମି ମିଡିଗ୍‍ ଆମେକେ ୱାଡିଂଆର୍‌କେ, ମେଁଇଂନେ ଆଡ଼ାତ୍ରା ଅନ୍ୟାୟ୍‌ନେ ବିଚାର୍‌ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ ? ନିଜର୍ ରେମୁଆଁଇଂକେ ଉତର୍ ବିଃନ୍‌ସା ପର୍‌ମେସର୍‌ ବିଲ୍‍କୁଲ୍‌ ନିୱାଲ୍ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK18_8","072_18_8","LUK","18","8","8","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ମେଁ ମେଁଇଂନେ ଆଡ଼ାତ୍ରା ଅନ୍ୟାୟ୍ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ଦାପ୍ରେ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ଏ । ଡାଗ୍ଲା ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‌ଚେ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ମେଁ ବିସ୍‌ବାସ୍‌ କେଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK18_9","072_18_9","LUK","18","9","9","ଉଡ଼ି ରେମୁଆଁ ବାବେ ଡିଙ୍ଗ୍‌ଆର୍କେ ଜେ ମେଇଂ ଦରମ୍‌ ଲେଃଆର୍‌କେ । ମେଇଂ ନିଜେ ବିନ୍‌ଣ୍ତ୍ରେଇଂ ଆଡ଼ାତ୍ରା ଜାବର୍‌ ନିମାଣ୍ତା ଡିଙ୍ଗ୍ ନ୍‌ଲେଃକେ ରକମ୍ ବେବ‍ଆର୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂକେ । ଜିସୁ ଆମେଇଂକେ ନିମାଣ୍ଡା ସାମୁଆଁ ବାସଙ୍ଗ୍ ବେଲା ବିଃକେଲା ଆକେନ୍ ଉଃସ୍ରା ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_10","072_18_10","LUK","18","10","10","ମୁଇଂଦିନା ମ୍ୱାୟା ରେମୁଆଁ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ନ୍‌ସା ମନ୍ଦିର୍‌ନ୍ନିଆ ୱେଆର୍‌ଗେ ମୁଇଂଜା ପାରୁସି ଆରି ବିନ୍ ମୁଇଂଜା ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_11","072_18_11","LUK","18","11","11","ଫାରୁଶୀ ସାର୍ଲ ଡିଙ୍ଗ୍‌ଚେ ନିଜେନେ ଡାଗ୍ରା ଦେକ୍ ରକମ୍ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେ ମୁଲେକେ ଏ ଇସ୍‌ପର୍ ନେଙ୍ଗ୍ ଆନାକେ ଦନ୍ୟବାଦ୍ ବିଃ ଣ୍ଡିଙ୍ଗ୍ ଜେ ନେଙ୍ଗ୍ ବିନ୍‌ନେ ସାପା ରେମୁଆଁ ରକମ୍ ବାଗୁଏଃଣ୍ତ୍ରେ ଅଦାର୍‌ମିକ୍ ଅଡ଼ାରେଗ୍ ଣ୍ତୁଲା ଆକେନ୍ ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେ ରକମ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK18_12","072_18_12","LUK","18","12","12","ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍‌ ସାନ୍ତାକେ ମ୍ୱାର୍‌ତର୍ କେଡ଼େସଃ ଡିଂମ୍ୟାକେ ଆରି ନେଙ୍ଗ୍‌ନେ ସାପା ଆର୍ଜେକ୍ନେ ଗୁଆକ୍ଲିଗ୍‌ ବାଟାବାନ୍ ମୁଇଙ୍ଗ୍‌ ବାଗ୍‌ ଦାନ୍ ଡିଂମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_13","072_18_13","LUK","18","13","13","ମାତର୍‌ ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ତ୍ରେ ସ୍ଲ ତୁଆଁଚେ କିତଂ ପାକା ଡିଗ୍ ଆକେକେ ଣ୍ତୁ ମାତର୍‌ ମେଁନେ ଗ୍ରିନିଆ ବଗ୍‍ଚେ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ ଏ ଇସ୍‌ପର୍ ନେଙ୍ଗ୍ ପାପି ଆନେଙ୍ଗ୍ ଲିବିସ ଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK18_14","072_18_14","LUK","18","14","14","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ଡାବୁ ସାଲିଆଣ୍ଡ୍ରେ ଇସ୍‌ପର୍‌ନେ ମୁଆଃନ୍ନିଆ ଦରମ୍ ବାବେଚେ ଡୁଆ ଆଣ୍ତେକେ ଡାଗ୍ଲା ଫାରୁଶୀ ଣ୍ତୁ । ଡାଗ୍ଲା ଜାଣ୍ତେ କି ନିଜେକେ ମ୍ନାଃରେ ଡାଗ୍‌ଚେ ଆସୁଏ ଆମେକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌ଏ ଡାଗ୍ଲା ଜାଣ୍ଡେ ନିଜେକେ ଡାଆଁ ଆଃଡିଙ୍ଗ୍ଏ ଆମେକେ ମ୍ନା ଆଃଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK18_15","072_18_15","LUK","18","15","15","ଜିସୁ ଡିରକମ୍ ଡାଆଁ ଗଡ଼େଇଙ୍ଗ୍‌କେ ଲିଗ୍‌ଏ ଆତେନ୍‌‌ସା ରେମୁଆଁଇଂ ଡାଆଁ ଗଡ଼େଇଙ୍ଗ୍‌କେ ଜିସୁନେ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଆର୍‌କେ ମାତର୍‌‌ ସିସ୍ଇଂ ଆତେନ୍‌‌ କେଚେ ରେମୁଆଁଇଂକେ ୱିଙ୍ଗ୍‌ନେ ମୁଲେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_16","072_18_16","LUK","18","16","16","ଡାଗ୍ଲା ଜିସୁ ଆମେଇଂକେ ନିଜେନେ ଡାଗ୍ରା ୱାଚେ ବାସଙ୍ଗ୍‌କେ ଡାଆଁ ଗଡ଼େଇଂକେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ନ୍‌ସା ବିଃପା ଆରି ଆମେଇଂକେ ମନା ଆଡିଙ୍ଗେପା ଡାଗ୍ଲା ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ଦେକ୍‌ରକମ୍ ଗଡ଼େଅଇଂନେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_17","072_18_17","LUK","18","17","17","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଜାଣ୍ତେ କି ଡାଆଁ ଗଡ଼େଅ ରକମ୍ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ବଲ୍‌ ଆବା ଣ୍ତୁ ମେଁ ଡିରକମ୍ ଡିଙ୍ଗ୍‌ଲା ଡିଗ୍ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ୱେଚା ଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK18_18","072_18_18","LUK","18","18","18","ମୁଇଙ୍ଗ୍‌ଜା ଜିଉଦି ନେତା ଜିସୁକେ ସାଲ୍ୟାକୁକେ, “ଏ ସତ୍ ଗୁରୁ ମାଡାନେ ଜିବନ୍‌ନେ ଅଦିକାର୍ ଡିଙ୍ଗ୍ ନ୍‌ସା ନେଙ୍ଗ୍ ମେଃନେ ଣ୍ତିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK18_19","072_18_19","LUK","18","19","19","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ ଆନେଙ୍ଗ୍ ସତ୍ ଡାଗ୍‌ଚେ ମେସା ବାସଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ? ଇସ୍‌ପର୍‌କେ ଆନ୍ତାର୍ ବିଃଲା ବିନ୍‌ ଜାଣ୍ଡେ ସତ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK18_20","072_18_20","LUK","18","20","20","ଇସ୍‌ପର୍‌ନେ ଆଦେସ୍ଇଂ ତ ପେ ମ୍ୟାଃପେଲେକେ । ଅଡ଼ାରେଗ୍‌ ଆଡିଙ୍ଗେପା, ରେମୁଆଁ ଆବାଗୁଏଃଗ୍‌ପା, ଆଡଙ୍ଗାଗେପା, ନାଲେ ସାକି ଆବିଃଗ୍‌ପା, ନିଜେନେ ଆବା ଇୟାଙ୍ଗ୍‌କେ ସନ୍‌ମାନ୍ ବିଃପା । ");
INSERT INTO gaq_vpl VALUES ("LK18_21","072_18_21","LUK","18","21","21","ଜିଉଦି ନେତା ବାସଙ୍ଗ୍‌କେ ଆକେନ୍ ସାପା ନେଙ୍ଗ୍ ଙ୍ଗିରେ ବାନ୍ ମାନେଚେ ପାଙ୍ଗ୍ ନ୍‌ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_22","072_18_22","LUK","18","22","22","ଜିସୁ ଆକେନ୍ ଅଁଚେ ଜିଉଦି ନେତାକେ ବାସଙ୍ଗ୍‌କେ ନାଁନେ ବାରି ମୁଇଙ୍ଗ୍‌ ବିସୟ୍ ଗଣ୍ଡା ଲେଃକେ ନାଁ ନିଜର୍‌ନେ ଦନ୍ ସାପା ସ ବିଚେ ଗରିବ୍ ରେମୁଆଁକେ ବାଟାବି ଆରି ନାଁ କିତଂଙ୍ଗ୍‌ଇନି ଦନ୍ ନାବାଏ ବାରି ପାଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା । ");
INSERT INTO gaq_vpl VALUES ("LK18_23","072_18_23","LUK","18","23","23","ଡାଗ୍ଲା ଜିଉଦି ନେତା ଆକେନ୍ ସାପା ସାମୁଆଁ ଅଁଚେ ଜବର୍ ମୁର୍‌ମୁରା ଡିଙ୍ଗ୍‌କେ ଡାଗ୍ଲା ମେଁ ଜବର୍ ସାଉକାର୍‌ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_24","072_18_24","LUK","18","24","24","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେକେ ଦୁକ୍ ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ବାସଙ୍ଗ୍‌କେ, ଜାଣ୍ଡେଇଂନେ ଦନ୍ ଲେଃକେ, ମେଇଙ୍ଗ୍ ଉଡ଼ି ଡଣ୍ଡ୍‍‌ନ୍ନିଆ ଇସ୍‌ପର୍‌ନେ ରାଇଜନ୍ନିଆ ୱେଚାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK18_25","072_18_25","LUK","18","25","25","ଇସ୍‌ପର୍‌ନେ ରାଇଜନ୍ନିଆ ସାଉକାର୍ ରେମୁଆଁ ୱେନେ ବାଟା ମୁଇଙ୍ଗ୍‌ ସୁଜି ପ୍ଲଗ୍‌ ବିଃଚେ ଉଟ୍‌ନେ ୱେଚାନେ ସଅଜ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("LK18_26","072_18_26","LUK","18","26","26","ଜାଣ୍ଡେଇଂ ଆକେନ୍ ସାମୁଆଁ ଅଁଆର୍କେ ମେଇଙ୍ଗ୍‌ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ତେଲା ଜାଣ୍ଡେ ଉଦାର୍ ବା ୟାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK18_27","072_18_27","LUK","18","27","27","ଡାଗ୍ଲା ଜିସୁ ବାସଙ୍ଗ୍‌କେ ଆଣ୍ତିନେ କାମ୍ ରେମୁଆଁ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ ଆତେନ୍‌‌ ଇସ୍‌ପର୍ ଡିଙ୍ଗ୍ ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK18_28","072_18_28","LUK","18","28","28","ଆତ୍‌ବାନ୍ ପିତର୍ ବାସଙ୍ଗ୍‌କେ କେଲାପା ନେ ସାପାରେ ନିଜେ ନିଜେନେ ଦନ୍ ସାପା ଆନ୍ତାର୍‌ଚେ ନାଁନେ ପ୍ଲା ପାଙ୍ଗ୍ ନେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_29","072_18_29","LUK","18","29","29","ଜିସୁ ଆମେଇଂକେ ବାଲିର୍‍କେ, “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍କେ ମୁଡ଼ି ରେମୁଆଁ ପର୍‌ମେସର୍‌ନେ ରାଇଜ୍ ନ୍‌ସା ଡୁଆ କି କୁନେଡ଼େ କି ବୟାଁ କି ଆବା ଇୟାଙ୍ଗ୍ କି ଗଡ଼େଇଂକେ ଆନ୍ତାର୍‌ଚେ ");
INSERT INTO gaq_vpl VALUES ("LK18_30","072_18_30","LUK","18","30","30","ଆକେନ୍ କାଲେ ଜବର୍ ଗୁନ୍ ବାଏ ଆରି ଗୁଏଃକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମାଡାନେ ପାରାନ୍ ବାଏ ଦେକ୍ ସୁଗୁଆ ରେମୁଆଁ ଜାଡିଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK18_31","072_18_31","LUK","18","31","31","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଗୋମ୍ୱାର୍‌କ୍ଲିଗ୍‌ ସିସ୍‌‌ଇଂକେ ବିନେ ଆଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ କେଲାପା ନେ ସାପାରେ ଯିରୂଶାଲମ୍‌ ଡାଗ୍ରା ୱେ ନେଡିଙ୍ଗ୍‌କେ ପର୍‌ମେସର୍‌ ବାବବାଦିଇଂକେ ମାପ୍‌ରୁ ଉଙ୍ଗ୍‌ଡେନେ ବିସୟ୍‌ରେ ଆଣ୍ତିନେ ସାପା ଗୁଆର୍ ନ୍‌ସା ବାସଙ୍ଗ୍‌ ବକେ ଆତେନ୍‌ ସାପା ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK18_32","072_18_32","LUK","18","32","32","ଡାଗ୍ଲା ମେଁ ବିଜାତି‍ଇଂନେ ନ୍ତିନ୍ନିଆ ବିଃଜଗ୍‌ତ୍ଲିଗ୍‌ଏ ବାରି ମେଇଙ୍ଗ୍ ଆମେକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌ଏ, ମେଇଂନେ ଆଡ଼ାତ୍ରା ଅନ୍ୟାୟ୍ ଡିଙ୍ଗ୍‌ଚେ ମେଁନେ ଆଡ଼ାତ୍ରା ବିଃତୁର୍‌ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK18_33","072_18_33","LUK","18","33","33","ଆମେକେ କର୍‌ଡା ଆଃତେ ବଗ୍‌ଚେ ଆଗୁଏବି ଆଃରେ ମାତର୍‌ ଜିର୍‌ସି ସ୍ମି ମେଁ ଆରି ମୁଇଙ୍ଗ୍‌ ତର୍ ତଡ଼ିଆଏ । ");
INSERT INTO gaq_vpl VALUES ("LK18_34","072_18_34","LUK","18","34","34","ଡାଗ୍ଲା ସିସ୍‌ଇଂ ଆତେନ୍‌ ସାପା ସାମୁଆଁ ବୁଜେ ଆୟାଆର୍‌କେ ଣ୍ତୁ ଆକେନ୍ ସାମୁଆଁ ମେଇଙ୍ଗ୍ ଅରିଆ ବୁଂନା ଡିଂଚେ ଲେଃକେ ବାରି ଆଣ୍ଡିନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ଡିଂଗେ, ଆତେନ୍‌‌ ସାପା ମେଇଙ୍ଗ୍‌ ବୁଜେ ଆୟା ଆର୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("LK18_35","072_18_35","LUK","18","35","35","ଜିସୁ ଯିରୀହୋନେ ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାନେ ବେଲା ମୁଇଂ କାନା ଗାଲି ଆଃଡ଼ା କଚେ ବିକ୍‌ ସାଲିଆ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_36","072_18_36","LUK","18","36","36","କାନା ଗୁଲୁଏ ରେମୁଆଁ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ସବ୍‌ଦ ଅଁଚେ ସାମୁଆଁ ମେଃନେ ଡାଗ୍‌ଚେ ସାଲ୍ୟାକୁକେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_37","072_18_37","LUK","18","37","37","ରେମୁଆଁଇଙ୍ଗ୍‌ କାନାକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ ନାଜରିତିୟ ଜିସୁ ଆକେନ୍ ଗାଲି ବିଚେ ୱେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_38","072_18_38","LUK","18","38","38","ଆତ୍‌ବାନ୍ କାନା ଜବର୍ କିରଚେ ବାଲିର୍‌କେ, “ଏ ଦାଉଦ୍ ଉଙ୍ଗ୍‌ଡେ ଜିସୁ ଆନେକେ ଦୟା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK18_39","072_18_39","LUK","18","39","39","ମାତର୍‌‌ ସେନୁଗ୍ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଙ୍ଗ୍‌ କାନା ବିକାରିକେ ବୁଙ୍ଗ୍‌ ଲେଃନ୍‌ସା ବାଃଟ ଡିଂଆର୍‌କେ ମେଃନ୍‌ସା ଡାଗ୍‌ଲା କାନା ବିକାରି ଆରି ଜବର୍ ୱାସାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ଏ ଦାଉଦ୍ ଉଙ୍ଗ୍‌ଡେ ଆନେଙ୍ଗ୍ ଦୟା ଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("LK18_40","072_18_40","LUK","18","40","40","ଜିସୁ ଆତ୍‌ବାନ୍ ତୁଆଁଚେ କାନା ବିକାରିକେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌ଲାପା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ ବାରି କାନା ବିକାରିକେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ କାନା ବିକାରିକେ ସାଲ୍ୟାକୁକେ ");
INSERT INTO gaq_vpl VALUES ("LK18_41","072_18_41","LUK","18","41","41","ନେଙ୍ଗ୍‌ ନାଁ ନ୍‌ସା ମେଁନେ ଣ୍ଡିଂଏ ଡାଗ୍‌ଚେ ନାଁ ଇକ୍‌ଚା ଡିଙ୍ଗ୍ ନାଡିଙ୍ଗ୍‍କେ ? କାନା ବିକାରି ବାସଙ୍ଗ୍‌କେ ଅ ମାପ୍ରୁ ନେଙ୍ଗ୍ ଡିରକମ୍ କିକେ ଇଁୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK18_42","072_18_42","LUK","18","42","42","ଜିସୁ କାନା ବିକାରିକେ ବାସଙ୍ଗ୍‌କେ ତେଲା ନାଁନେ ମୁଆଃ ତ୍ନାଲେ ନାଁନେ ବିସ୍‌ବାସ୍‌ ଆନାକେ ନିମାଣ୍ତା ଆଃଡିଙ୍ଗ୍ ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK18_43","072_18_43","LUK","18","43","43","ଆତେନ୍‌‌ ଦାପ୍ରେ କାନା ବିକାରିନେ ମୁଆଃ ତ୍ନାକେ ବାରି ଇସ୍‌ପର୍‌ନେ ମ‍ଇମା କୀର୍ତ୍ତନ୍‌ ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଚେ ମେଇଙ୍ଗ୍‌ନେ ପ୍ଲା ଅଲେଙ୍ଗ୍‌ନେ ମୁଲେକେ ଆରି ରେମୁଆଁ ସାପାରେ ଆତେନ୍‌‌ କେଚେ ଇସ୍‌ପର୍‌କେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_1","072_19_1","LUK","19","1","1","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଯିରୀହୋନ୍ନିଆ ଗାଚେ ଆତେନ୍‌ ଗାଲି ବିଚେ ୱେଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_2","072_19_2","LUK","19","2","2","ଆରି କେଲା ଜଖିୟ ମ୍ନିରେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଲେଃଗେ ମେଁ ମୁଇଙ୍ଗ୍ ମ୍ନା ସିସ୍ତୁ ସାଲ୍ୟାଣ୍ଡ୍ରେ ଆରି ସାଉକାର୍ ରେମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("LK19_3","072_19_3","LUK","19","3","3","ଜିସୁ ଜାଣ୍ଡେ ଆତେନ୍‌ କେନ୍‍ସା ମେଁ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଗେ ମାତର୍‌ ରେମୁଆଁଇଂନେ ଜବର୍ ଗ‍ଅଲି ନ୍‌ସା କିକେ ଆୟାକେ ଣ୍ଡୁ ଡାଗ୍ଲା ମେଁ ଡ୍ଲେଃ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_4","072_19_4","LUK","19","4","4","ଦେକ୍‌କେ ମେଁ ରେମୁଆଁଇଂନେ ସେନୁଗ୍ ୱିର୍‌ ଡୁଂୱେଚେ ଆମେକେ କେନ୍‍ସା ମୁଇଙ୍ଗ୍ ଲିୱା ସ୍ଲା ଡେଃକେ ଡାଗ୍‍ଲା ଆତେନ୍‌ ଗାଲି ବିଚେ ଜିସୁ ୱେନେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_5","072_19_5","LUK","19","5","5","ଜିସୁ ଆତ୍ ଜାଗାନ୍ନିଆ ପାଙ୍ଗ୍‌ଚେ ଆଡ଼ାତ୍ରା କେଚେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଜଖିୟ ଦାପ୍‍ରେ ଜାର୍‌ଚେ ପାଙ୍ଗ୍‌ଲା ଡାଗ୍‍ଲା ଏଃକେ ଆନେଙ୍ଗ୍ ଡିଲାଡିଗ୍ ପେ ଡୁଆ ଲେଃପଡ଼େଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_6","072_19_6","LUK","19","6","6","ଆତ୍‌ବା ମେଁ ଦାପ୍‍ରେ ଜାର୍‌ଚେ ସାର୍ଦାରେ ଜିସୁନେ ଜତନ୍‌ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_7","072_19_7","LUK","19","7","7","ଆତେନ୍‌ କେଚେ ସାପାରେ କୁଟ୍‌ ଡିଙ୍ଗ୍‍ନେସା ଲାଗେକେ, “ମେଁ ମୁଇଙ୍ଗ୍ ପାପି ରେମୁଆଁନେ ଡୁଆ ଲେଃନ୍‍ସା ୱେଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_8","072_19_8","LUK","19","8","8","ଜଖିୟ ମାପ୍ରୁକେ ବାସଙ୍ଗ୍‌କେ “ଏ ମାପ୍ରୁ ଅଁ ନେଙ୍ଗ୍‌ ନେଙ୍ଗ୍‌ନେ ଦନ୍‍ସମ୍ପତିନେ ମେତାଃ ଗରିବ୍‌ଇଂକେ ଦାନ୍ ଣ୍ତିଙ୍ଗ୍ଏ ବାରି ଜଦି ନେଙ୍ଗ୍‌ ଜାଣ୍ତେବାନ୍‌ ମେଃଡିଗ୍‌ ଜଟେମ୍ୱଏ ତେଲା ଅଁ ବାଗ୍‌ରେ ଆମେ ଆଆଣ୍ତେ ମ୍ୱିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_9","072_19_9","LUK","19","9","9","ଆତ୍‌ବା ଜିସୁ ମେଁନେ ସାମୁଆଁ ବାଲିର୍‌କେ, “ଏକେ ଆକେନ୍ ଡୁଆ ଅରିଆ ଉଦାର୍ ପିଙ୍ଗ୍‍ଚା ଲେଃକେ ତେସା କିମେଡିଗ୍ ଅବ୍ରାହାମ୍‌ନେ ମୁଇଙ୍ଗ୍ ଉଙ୍ଗ୍‌ଡେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_10","072_19_10","LUK","19","10","10","ମେଃନେ ବଃ ଲେଃକେ ଆତେନ୍‌ ତୁର୍‌ଚେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ସା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପାଙ୍ଗ୍‍ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_11","072_19_11","LUK","19","11","11","ରେମୁଆଁଇଂ ଆକେନ୍ ସାମୁଆଁ ସାପା ଅଁନେ ବେଲା ମେଁ ଆର୍‌ମୁଇଂ ଉସ୍ରା ବାସଙ୍ଗ୍‌କେ ମେଁ ଯିରୁସାଲାମ୍‍ନେ ଡାଗ୍ରା ଡିଙ୍ଗ୍ ଲେଃଗେ ଆରି ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ ଦାପ୍ରେ ଉଡ୍ରା ଡିଙ୍ଗ୍ ଡାଗ୍‌ଚେ ମେଇଂ ମନେ ବାବେ ଡିଙ୍ଗ୍ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_12","072_19_12","LUK","19","12","12","ଆତେନ୍‌‌ସା ମେଁ ବାସଙ୍ଗ୍‌କେ “ମୁଇଙ୍ଗ୍ ମ୍ନା ପଦବିନ୍ନିଆ ଲେଃକ୍ନେ ରେମୁଆଁ ମେଁ ନିଜେ ନ୍‍ସା ରାଇଜ୍‍ ପଦ୍‍ ବାନ୍ ବା ଆଡାଚେ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌କେ ଆରି ମେଁ ସ୍ଲ ଦେସ୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_13","072_19_13","LUK","19","13","13","ମେଁ ନିଜେନେ ଗୁଆ ରେମୁଆଁ ଗତିରେଇଂକେ ୱାଚେ ମେଇଂକେ ମୁଇଂ ମୁଇଂ ସୁନା ଡାବୁ ତାଲି ବିଚେ । ମେଁ ବାସଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ଆଣ୍ଡେ ଜାକ ଆକେନ୍ ଡାବୁ ଏତେ ବେପାର୍‍ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK19_14","072_19_14","LUK","19","14","14","ମାତର୍‌ ମେଁଇଙ୍ଗ୍‌ନେ ଦେସ୍ ଆମେଇଂକେ କୁଟ୍ ଡିଙ୍ଗ୍‌କେ ଆରି ମେଇଙ୍ଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ପ୍ଲା ଦୁତ୍ ବେଚେ ବାଃଲିର୍‍କେ ଏନ୍‌ ରେମୁଆଁ ଜେ ନେନେ ଆଡ଼ାତ୍ରା ଇଃସାଙ୍ଗ୍‌ ସାସନ୍ ଡିଙ୍ଗ୍‌ଏ ଆକେନ୍ ନେନେ ଇକ୍‌ଚା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_15","072_19_15","LUK","19","15","15","ଆତାନ୍‌ ରେମୁଆଁ ଇଃସାଙ୍ଗ୍‌ ପଦ୍ ବାଚେ ନିଜର୍‌ ଦେସ୍‌ ପାଙ୍ଗ୍‌କେ । ମେଁନେ ଚାକର୍‌ଇଂ ଉଡ଼ି ଆର୍‌ଜେ ବଆର୍‌କେ ଆତାନ୍‌ ମ୍ୟାଃ ନ୍‌ସା ମେଁ ଆମେଇଂକେ ମେଁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ ନ୍‌ସା ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_16","072_19_16","LUK","19","16","16","ଆତ୍‌ବା ପର୍‍ତୁମ୍‍ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍ରୁ ନାନେ ବିନାବକ୍ନେ ସୁନା ଡାବୁରେ ନାଆତ୍‍ଲା ଆରି ନେଙ୍ଗ୍ ଆତ୍‍ଲା ଗୁଆକ୍ଲିଗ୍ ଲାବ୍‍ ଡିଙ୍ଗ୍ ମ୍ୱକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_17","072_19_17","LUK","19","17","17","ମେଁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ବାସ୍‍ ନିମାଣ୍ଡା ଚାକର୍ ନାନେ ଇତୁଡ଼ା ସାମୁଆଁ ନ୍‍ସା ବିସ୍‌ବାସ୍‍ ଡିଙ୍ଗ୍ ନାଲେଃଗେସା ଗୁଆକ୍ଲିଗ୍ ମ୍ନାଇନି ଆଡ଼ାତ୍ରା ଅଦିକାର୍ ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_18","072_19_18","LUK","19","18","18","ଆରି ବାର୍‌ମୁଇଂଜା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍ରୁ ନାନେ ନେଙ୍ଗ୍‌ନେ ମାଲିକ୍ଲିଗ୍‍ ଡାବୁ ଲାବ୍‍ ଡିଙ୍ଗ୍ ମ୍ୱକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_19","072_19_19","LUK","19","19","19","ମେଁ ଆମେକେ ଡିଗ୍ ବାସଙ୍ଗ୍‌କେ “ନାଡିଗ୍ ମାଲିକ୍ଲିଗ୍ ମ୍ନାଇନି ଆଡ଼ାତ୍ରା ଅଦିକାର୍ ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_20","072_19_20","LUK","19","20","20","ବାର୍‌ମୁଇଂଜା ପାଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍ରୁ, କେଲା ନାଁନେ ସୁନା ଡାବୁ ଆକ୍‌କେ ଲେଃକେ; ଆକେନ୍ ନାନେ ନେଙ୍ଗ୍‌ନେ ନେଙ୍ଗ୍ ଆକେନ୍‍କେ ଲୁଙ୍ଗିନ୍ନିଆ ଗାଗ୍‌ଚେ ମ୍ୱକେ; ");
INSERT INTO gaq_vpl VALUES ("LK19_21","072_19_21","LUK","19","21","21","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆନାକେ ମ୍ବୁଟକେ ନା ମୁଇଂ ନିଷ୍ଟୁର୍‍ ରେମୁଆଁ ଆଣ୍ଡିନେ ନାବ ଆତେନ୍‌ ଆତଡ଼ିଆ ଡୁଂନାଡଏ ଆରି ଆଣ୍ଡିନେ ବିଗ୍‍ ନାବ ଆତେନ୍‌‌କେ ନାଗୁଆଏ । ");
INSERT INTO gaq_vpl VALUES ("LK19_22","072_19_22","LUK","19","22","22","ଆମେକେ ମେଁ ବାଃଲିର୍‍କେ ଏ ଦୁସ୍‌ଟ ଚାକର୍ ନାଁନେ ସାର୍ମୁଆଁ ସାମୁଆଁରେ ନାନେ ବିଚାର୍ ଣ୍ଡିଂଏ । ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ନିଷ୍ଟୁର୍‍ ରେମୁଆଁ ଆଣ୍ଡିନେ ଆବ ଣ୍ଡୁ, ଆତେନ୍‌ ଆତଡ଼ିଆ ଡୁଂଡଏ ଆରି ଆଣ୍ଡିନେ ବିଗ୍ ନାବ ଆତେନ୍‌ ଙ୍ଗୁଆଃଏ ଆକେନ୍ ନାନେ ମେଁନେ ମ୍ୟା ନାଲେଃକେ ");
INSERT INTO gaq_vpl VALUES ("LK19_23","072_19_23","LUK","19","23","23","ତେଲା ନା ନେଙ୍ଗ୍‌ନେ ଡାବୁକେ ମେନ୍‌ସା ବେଙ୍କ୍‌ନ୍ନିଆ ନ୍ନାବକେ ଣ୍ତୁ ? ତେଲା ନେଙ୍ଗ୍‌ ଆଣ୍ତେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ସୁଦ୍‌ ଏତେ ଆତାନ୍‌ ମ୍ପାବା ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_24","072_19_24","LUK","19","24","24","“ଏନ୍ ଇଡ଼ିଙ୍ଗ୍‌ ଇଃସାଙ୍ଗ୍‌ ଆତ୍‌ଅରିଆ ତୁଆଁଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ ମେଁବାନ୍‌ ସୁନା ଡାବୁ ଡୁଂୱିଗ୍‌ଲାପା ବାରି ଆଣ୍ତିନେ ଚାକର୍‌ନେ ଗୁଆଟାଆଁ ଲେଃକେ ଆମେକେ ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_25","072_19_25","LUK","19","25","25","ମାତର୍ ମେଇଂ ଆମେକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ମାପ୍‌ରୁ, ମେଁନେ ତ ଗୁଆ ଟାଆଁ ଲେଃକେ !” ");
INSERT INTO gaq_vpl VALUES ("LK19_26","072_19_26","LUK","19","26","26","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ “ମୁଡ଼ି ରେମୁଆଁନେ ଲେଃକେ ଆମେକେ ବିଏ ମାତର୍‌ ଜାନେ ଣ୍ଡୁ ମେଁ ନ୍ନିଆ ମେଁନେ ଲଃକେ ଆତେନ୍‌ ଆଃ ମେବାନ୍‍ ଡୁଙ୍ଗ୍‍ ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK19_27","072_19_27","LUK","19","27","27","ମାତର୍‌ ଏବେ ନେଙ୍ଗ୍‌ନେ ସତ୍ରୁଇଂ ନେଙ୍ଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ଇଃସାଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍ ଡାଗ୍‌ଚେ ଜାଣ୍ଡେଇଂ ଚାଏଁ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଆଣ୍ଡିକା ? ନେଙ୍ଗ୍ ସତ୍ରୁଇଂ ଆକ୍‌ଅରିଆ ଡୁଂପାଙ୍ଗ୍‍ଲା । ଆମେଇଂକେ ନେଙ୍ଗ୍ ମୁଆଃ ସାମ୍‌ନେ ବାଗୁଏଃ ବିଃ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_28","072_19_28","LUK","19","28","28","ଏନ୍‌ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଆଡାଚେ ଯିରୁସାଲାମ୍‍ ପାକା ୱେନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_29","072_19_29","LUK","19","29","29","ଆରି ଉଡ଼ିବେଲା ମେଁ ଜିତକଣ୍ଡା ଡାଗ୍‍ରା ବେଥ୍‌ଫାଗୀ ଆରି ବେଥନୀ ଡାଗ୍‍ରା ୱେଚାଆର୍‍ଗେ ଆତେନ୍‌ ବେଲା ମେଁ ନିଜେ ସିସ୍ଇଂବାନ୍ ମ୍ୱାୟାକେ ଆକେନ୍ ସାମୁଆଁ ବାଲିର୍‌ଚେ ବେବିଗେ ");
INSERT INTO gaq_vpl VALUES ("LK19_30","072_19_30","LUK","19","30","30","“ସେନୁଗ୍ ଆଣ୍ଡିନେ ଇନି ତ୍ନାଡିଂକେ ଆତ୍‌ଅରିଆ ୱେଲା । ପେଇଙ୍ଗ୍ ଇନିଅରିଆ ଗାକ୍ନେ ଦାପ୍‍ରେ ଆତ୍‌ଅରିଆ ମୁଇଙ୍ଗ୍ ଉଂଗଦକେ ଗାଗ୍‍ବକ୍ନେ ପେକେଏ । ଆତେନ୍‌ ଗଦ ଆଡ଼ାତ୍ରା ଅଃନା ଜାଣ୍ଡେ ଡିଗ୍ ଏଃଜାକ ଙ୍କାରେ ଡେଃ ଆମେକେ ତୁପିଗ୍‍ଚେ ନେଙ୍ଗ୍‍ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ପେପାଙ୍ଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK19_31","072_19_31","LUK","19","31","31","ଆରି ଜାଣ୍ଡେ ଡିଗ୍ ଆପେକେ ମେଁନ୍‌ସା ତୁପିଗ୍‍ ପେଡିଙ୍ଗ୍‍କେ ଡାଗ୍‌ଚେ ସାଲିଆକୁଏ ତେଲା ଦେକ୍‌ରକମ୍ ପେବାଲିର୍‌ଏ ଡାଗ୍‌ଲା ଆକ୍‌ମେନ୍ନିଆ ମାପ୍ରୁନେ ଦର୍‌କାର୍ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_32","072_19_32","LUK","19","32","32","ମ୍ୱାୟା ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଆତେନ୍‌‍ ଇନି ୱେଚେ ମେଁ ଆମେଇଂକେ ଡିରକମ୍ ବାସଙ୍ଗ୍‍ବକେ ଦେତ୍‍ରକମ୍‍ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_33","072_19_33","LUK","19","33","33","ଆରି ସିସ୍‌‍ଇଂ ଗଦ ଉଙ୍ଗ୍‌ଡେକେ ତୁପିଗ୍‍ନେ ବେଲା ଗଦ ଉଂଡେନେ ମାଲିକ୍ ତାର୍‌ଚେ ପାଙ୍ଗ୍‌କେ । ମେଇଂ ସିସ୍‌‍ଇଂକେ ସାଲିଆକୁକେ “ପେଇଂ ଗଦ ଉଂଡେକେ ମେସା ତୁପିଗ୍‍ ପେଡିଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK19_34","072_19_34","LUK","19","34","34","ସିସ୍‌‌ଇଙ୍ଗ୍‌ ବାସଙ୍ଗ୍‌କେ “ଆକ୍‌ମେଁ ଅରିଆ ମାପ୍ରୁନେ ଦର୍‍କାର୍‍ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_35","072_19_35","LUK","19","35","35","ମେଇଂ ଗଦ ଉଙ୍ଗ୍‌ଡେକେ ଜିସୁନେ ଡାଗ୍ରା ଡୁଂୱେ ଆର୍‌କେ । ଏନ୍ ଇଡ଼ିଙ୍ଗ୍‌ ନିଜର୍‌ ନିଜର୍‌ ପାଟାଇ ବେଚେ ଜିସୁକେ ଆଃକ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_36","072_19_36","LUK","19","36","36","ଆରି ମେଁ ଗଦ ଆଡ଼ାତ୍ରା କଚେ ଯିରୁସାଲାମ୍‍ ପାକା ୱେନେ ବେଲା ରେମୁଆଁଇଂ ଗାଲିନିୟା ନିଜର୍ ନିଜର୍‌ନେ ପାଟାଇ ବେପା ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_37","072_19_37","LUK","19","37","37","ଆରି ମେଁ ଯିରୁଶାଲାମ୍‍ନେ ଡାଗ୍‍ରା ବିଃଚେ ପିଙ୍ଗ୍‍ଚାନେ ବେଲା ଜିତକଣ୍ଡାନେ ଡାଗ୍‍ରା ଦେସ୍ ଅରିଆ ପିଙ୍ଗ୍‍ଚାଆର୍‍କେ । ଆତେନ୍‌ ବେଲା ଜିସୁନେ ସାପା ସିସ୍ ଦଲ୍‍ଇଂ ସାର୍ଦା ଲେଃଆର୍‍ଗେ । ମେଇଙ୍ଗ୍ ମାଲେ ୱାସାର୍‌ଚେ ପର୍‍ମେସର୍‍ନେ ମ୍ନିରେ ପ୍ରସଂସା ଅସ୍‌ମାର୍ ସାର୍‍ନେ ଆରାମ୍‍ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ଆତେନ୍‌‌ସା ମେଇଂ ପର୍‍ମେସର୍‍ନେ ମ୍ନିରେ ଅସ୍‌ମାର୍ ସାର୍‌ଆର୍‌କେ । ମେଇଂ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ: ");
INSERT INTO gaq_vpl VALUES ("LK19_38","072_19_38","LUK","19","38","38","“ମାପ୍ରୁନେ ମ୍ନିରେ ମୁଡ଼ି ଇଃସାଙ୍ଗ୍‌ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ମେଁ ଦନ୍ୟ । କିତଙ୍ଗ୍ଇନି ସାନ୍ତି ଆରି ପର୍‍ମେସର୍‍ନେ ମ‍ଇମା ଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_39","072_19_39","LUK","19","39","39","ଆତ୍‌ବା ରେମୁଆଁଇଂନେ ଗହଲିବାନ୍ ଉଡ଼ିରୁଆ ପାରୁସିଇଂ ଜିସୁକେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଏ ଗୁରୁ ନାନେ ସିସ୍ଇଂକେ ଏନ୍‌ ସାପା ସାମୁଆଁ ମାବାଲିର୍ ନ୍‌ସା ଦମକ୍‍ ବିଃ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_40","072_19_40","LUK","19","40","40","ମେଁ ଉତର୍ ବିକେ, “ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଜଦି ନେଙ୍ଗ୍‌ନେ ସିସ୍‌‍ଇଂ ବୁଙ୍ଗ୍‍ଲେଲା ବ୍ରିଙ୍ଗ୍‍ ଜାକ କିରଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_41","072_19_41","LUK","19","41","41","ଜିସୁ ଯିରୁଶାଲାମ୍ ଡାଗ୍‍ରା ପିଙ୍ଗ୍‌ଚାକେ । ଜିସୁ ଯିରୁଶାଲାମ୍‍ ଟାଉନ୍‍କେ କେଚେ ମେସା ଅଁ ଜଗ୍‌ତ୍ଲିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_42","072_19_42","LUK","19","42","42","ଯିରୁଶାଲାମ୍‍କେ ବାଲିର୍‍କେ “ଆନାକେ ଡିରକମ୍ ସାନ୍ତି ମିଲେୟାଏ ଆତେନ୍‌ ଜଦି ପେଇଂ ମ୍ୟା ପେପାଲେ ! ମାତର୍‌ ଆତେନ୍‌ ପେ ମ୍ୟା ପେୟା ଣ୍ଡୁ । ଡାଗ୍ଲା ଆତେନ୍‌ ପେ ବାନ୍ ବୁଡ଼ିଚେ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_43","072_19_43","LUK","19","43","43","ନାନେ ଆତ୍‍ଲା ଦେକ୍‌ରକମ୍ ବେଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ, ଉଡ଼ିବେଲା କି ନାନେ ସତ୍ରୁଇଂ ନାନେ ପିତୁର୍‍ ପାକା ଗେରେ ବିଏ । ନାନେ ବିରଦ୍‌ ରେମୁଆଁଇଂ ଆଣ୍ଡେଚେ ଆନାକେ ବାଗୁଏଃ ବିଃ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK19_44","072_19_44","LUK","19","44","44","ମେଇଂ ଆପେକେ ଆରି ପେ ରେମୁଆଁଇଂକେ ସାପା ଦଂସ ଆଡିଙ୍ଗ୍ ବିଏ । ମୁଇଂଡିଗ୍‍ ବ୍ରି ଆର୍‌ମୁଇଂ ବ୍ରି ଆଡ଼ାତ୍ରା ମେଇଂ ଲେନ୍‍ସା ଆବି ଣ୍ଡୁ । ଦେକ୍‍ସୁଗୁଆ ବେଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ଡାଗ୍ଲା ଆପେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ସା ପର୍‍ମେସର୍‍ ଉଡ଼ିବେଲା ପାଙ୍ଗ୍‍ଲେଗେ ଆତେନ୍‌‌ ବେଲା ପେ ସାମୁଆଁ ପେୟାକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_45","072_19_45","LUK","19","45","45","ଜିସୁ ମନ୍ଦିର୍‍ ବିତ୍ରେ ୱେକେ । ମେଁ ମନ୍ଦିର୍‌ନେ ପ୍ଲେଡ଼ିଆ ନ୍ନିଆ ବିଆର୍ ସମ୍ୟାକ୍ନେ ରେମୁଆଁଇଂକେ ପାଦା ନୁଆଁ ଆଃତାର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_46","072_19_46","LUK","19","46","46","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଦରମ୍ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ବକେ: ସାମୁଆଁ ନେଙ୍ଗ୍ ଡୁଆ ପାର୍‍ତନା ଡୁଆ ଡିଙ୍ଗ୍‌ଏ । ମାତର୍‌ ପେଇଂ ଆକ୍‌ମେକେ ଡଙ୍ଗାରେ ବାସାନେ ଡୁଆ ସୁଗୁଆ ଆଡିଙ୍ଗ୍ ପେବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK19_47","072_19_47","LUK","19","47","47","ଜିସୁ ସାପାଦିନା ମନ୍ଦିର୍‍ ନ୍ନିଆ ବୁଦି ବିଃ ଡିଙ୍ଗ୍‌ଗେ । ମ୍ନା ପୁଜାରି ଦରମ୍ ସାସ୍ତ୍ରିଇଂ ଆରି ଜିଉଦି ନେତାଇଂ ଜିସୁକେ ତାଡ଼୍‍ତେ ବାଗୁଏଃ ବିଃନ୍‍ସା ଚାଏଁ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK19_48","072_19_48","LUK","19","48","48","ମାତର୍‌ ସାପା ରେମୁଆଁ ଜିସୁନେ ବୁଦି ମନ୍ ଦିଆନ୍‍ ବିଚେ ଅଁ ଡିଙ୍ଗ୍ ଆର୍‌ଗେ । ଆତେନ୍‌‌ସା ମ୍ନା ପୁଜାରି ଦରମ୍ ସାସ୍ତ୍ରିଇଂ ଆରି ଜିଉଦି ନେତାଇଂ ମେଁ ଡିଙ୍ଗ୍ ଆରେ ଡାଗ୍‌ଚେ ମେଃଡିଗ୍ ଉପାୟ୍‍ ତୁର୍ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK20_1","072_20_1","LUK","20","1","1","ମୁଇଂଦିନା ଜିସୁ ମନ୍ଦିର୍‍ ବିତ୍ରେ ଲେଃଗେ । ଆରି ପର୍‍ମେସର୍‍ନେ ରାଇଜ୍ ବିସୟ୍‌ରେ ମାପ୍ରୁନେ ନିମାଣ୍ଡା ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ମ୍ନାଯାଜକ ଦରମ୍ କରମ୍‍ ରେମୁଆଁଇଂ ଆରି ଜିଉଦି ନେତାଇଂ ଜିସୁକେ ପ୍ରସ୍‍ନ ସାଲ୍ୟାକୁ ପାଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_2","072_20_2","LUK","20","2","2","ମେଇଙ୍ଗ୍ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଆନେକେ ବାସଙ୍ଗ୍‌ ଆଣ୍ଡିନେ ଅଦିକାର୍‌ରେ ନାନେ ଆକେନ୍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍ ? ଆନାକେ ଆକେନ୍ ସାପା ଅଦିକାର୍ ଜାଣ୍ଡେ ବିକେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK20_3","072_20_3","LUK","20","3","3","ଜିସୁ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍‍ ଡିଗ୍‍ ଆପେକେ ମୁଇଙ୍ଗ୍ ପ୍ରସ୍‍ନ ନ୍‌ସେଲ୍ୟାକୁଏ । ଆନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌, ");
INSERT INTO gaq_vpl VALUES ("LK20_4","072_20_4","LUK","20","4","4","ଉଡ଼ିବେଲା ଜହନ୍‌ ରେମୁଆଁଇଂକେ ଦିକ୍ୟା ବିକେ ଆତେନ୍‌ ପର୍‍ମେସର୍‍ବାନ୍‍ ପାଙ୍ଗ୍‍ଲେକେଲେ ରେମୁଆଁବାନ୍‍ ପାଙ୍ଗ୍‍ଲେକେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK20_5","072_20_5","LUK","20","5","5","ମ୍ନାଯାଜକ ଦରମ୍ କରମ୍‌ଣ୍ଡ୍ରେ ଆରି ଜିଉଦି ନେତାଇଂ ନିଜେ ନିଜେ ବିତ୍ରେ ୱିଙ୍ଗ୍‌ଆ ରିଙ୍ଗ୍‌ଆ ଡିଙ୍ଗ୍ ଆର୍‌କେ । “ନେନେ ଜଦି ନେବାସଙ୍ଗ୍‍ଏ ଜେ ଜହନ୍‌ନେ ଡୁବନ୍ ପର୍‍ମେସର୍‍ବାନ୍‍ ପାଙ୍ଗ୍‍ଲେଗେ ତେଲା ମେଁ ସାଲିଆକୁଏ ପେଇଂ ଜହନ୍‌କେ ମେଁନ୍‌ସା ବିସ୍‌ବାସ୍‍ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("LK20_6","072_20_6","LUK","20","6","6","ମାତର୍‌ ନେନେ ଜଦି ନେବାଲିର୍‌ଏ ଜହନ୍‌ନେ ଡୁବନ୍ ରେମୁଆଁବାନ୍‍ ପାଙ୍ଗ୍‍ଲେଗେ ତେଲା ସାପା ରେମୁଆଁ ନେନେ ଆଡ଼ାତ୍ରା ବ୍ରି ଟୁଚେ ଆନେକେ ସର୍‌ତେ ବାଗୁଏଃ ବିଃ ଆର୍‌ଏ । ଡାଗ୍‍ଲା ମେଇଙ୍ଗ୍ ଜହନ୍‌କେ ବାବବାଦି ଡାଗ୍‌ଚେ ବିସ୍‌ବାସ୍‍ ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_7","072_20_7","LUK","20","7","7","ଆତେନ୍‌‌ସା ମେଇଂ ବାଲିର୍‍କେ, “ନେ ନେମ୍ୟାକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_8","072_20_8","LUK","20","8","8","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଡିଗ୍ ଆପେକେ ନାନେ ବାସଙ୍ଗ୍‌ ଣ୍ଡୁ ଜେ ନେଙ୍ଗ୍‍ ଡିଗ୍ ଆଣ୍ଡିନେ ଅଦିକାର୍‌ରେ ଏନ୍‌ ସାପା କାମ୍ ଡିଙ୍ଗ୍ ଣ୍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_9","072_20_9","LUK","20","9","9","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ରେମୁଆଁଇଂକେ ଏନ୍‌ ଉସ୍ରା ବାଲିର୍‍କେ: ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଉଡ଼ି ଲିଜ ଅରିଆ ଅଙ୍ଗୁର୍ ଚାସ୍‌ ଡିଙ୍ଗ୍‌କେ । ମେଁ ଆକେନ୍ ଲିଜକେ ସ୍ଲେଣ୍ଡ୍ରେକେ ବାଟା ବିକେ । ତେନ୍ଇଡ଼ିଂ ମେଁ ଉଡ଼ି ଆର୍କେ ସୁଗୁଆ ଆନ୍ତାର୍‌ଚେ ବିଦେସ୍‍ ଲାଗ୍‌ଡକେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_10","072_20_10","LUK","20","10","10","ଇଡ଼ିଙ୍ଗ୍ ଅଙ୍ଗୁର୍ ରୁଏନେ ବେଲା ପାଙ୍ଗ୍‌କେ । ତେଲା ଆତେନ୍‌ ରେମୁଆଁ ମେଁନେ ମୁଇଙ୍ଗ୍ ଗତିରେକେ ଆତେନ୍‌ ସ୍ଲେରେ ଡାଗ୍‍ରା ବେକେ ଡିରକମ୍‍ ଡିଗ୍ ସ୍ଲେରେଇଙ୍ଗ୍ ମେଁନେ ବାଟା ଅଙ୍ଗୁର୍ ଗତିରେନେ ନ୍ତି ଅରିଆ ଆସା ବିଆର୍‌ଏ । ମାତର୍‌ ସ୍ଲେରେଇଙ୍ଗ୍ ଗତିରେକେ ବଗ୍‍ଚେ ସରାଃନ୍ତି ବେଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_11","072_20_11","LUK","20","11","11","ତେଲା ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ଆରି ମୁଇଙ୍ଗ୍‌ଜା ଗତିରେକେ ବେକେ । ସ୍ଲେରେଇଙ୍ଗ୍ ଏନ୍‌ ରେମୁଆଁ ବଗ୍‍ଆର୍‍କେ ଆରି ମେଁ ଆଡ଼ାତ୍ରା ଅସନ୍‍ମାନ୍‍ ବେବ‍ଆର୍ ଡିଙ୍ଗ୍ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଆମେକେ ମେଃଡିଗ୍ ମାବିଚେ ବେବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_12","072_20_12","LUK","20","12","12","ତେଲା ଲିଜ ସାକାର୍‍ ଆରି ମୁଇଙ୍ଗ୍ ଗତିରେକେ ବେକେ । ସ୍ଲେରେଇଙ୍ଗ୍ ଆମେକେ ଡିଗ୍ ବୟ୍‍ଙ୍କାର୍‍ ଆଚିନା ଆବାନାଚେ ଲିଜ ପାଦାପାକା ଜଗ୍‍ତିଲିଗ୍‍ ବିଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_13","072_20_13","LUK","20","13","13","ଲିଜନେ ସାକାର୍‍ ବାସଙ୍ଗ୍‌କେ “ଏବେ ନେଙ୍ଗ୍ ମେଁ ଣ୍ଡିଙ୍ଗ୍‍ଏ ? ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ନିଜର୍ ଗଡ଼େଅକେ ମ୍ବେଏ । ଡିଲାଡିଗ୍ ନେଙ୍ଗ୍ ଗଡ଼େଅକେ ସ୍ଲେରେଇଙ୍ଗ୍ ମାନେଃ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK20_14","072_20_14","LUK","20","14","14","ସ୍ଲେରେଇଂ ସାଉକାର୍ ଉଙ୍ଗ୍‌ଡେକେ ସାମୁଆଁଚେ ବାଲିର୍‌ବାତା ଆର୍‌କେ, ‘କିମେ ତ ଲିଜ ସାକାର୍‍ ଉଙ୍ଗ୍‌ଡେ । ନେନେ ଆମେକେ ବାଗୁଏଃ ବିଃଲା ଲିଜ ବ୍ରି ସାପା ନେନେ ଡିଙ୍ଗ୍‌ୱେଏ’ । ");
INSERT INTO gaq_vpl VALUES ("LK20_15","072_20_15","LUK","20","15","15","ତେଲା ସ୍ଲେରେଇଂ ସାକାର୍‍ନେ ଉଙ୍ଗ୍‌ଡେକେ ତାଡ଼୍‍ତେ ବାଗୁଏଃ ବିଃ ଆର୍‌କେ ଆରି ଡୁଗ୍‌ଡି ପାଦାପାକା ଜଗ୍‌ତ୍ଲାଗ୍ ବିଆର୍‌ଗେ । ଜିସୁ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ ଏବେ ଲିଜ ସାଉକାର୍ ମେଁନେ ଡିଙ୍ଗ୍‌ଏ ? ");
INSERT INTO gaq_vpl VALUES ("LK20_16","072_20_16","LUK","20","16","16","ମେଁ ପାଙ୍ଗ୍‌ଚେ ଆତେନ୍‌ ସ୍ଲେଲେଇଂକେ ତାଡ଼୍‍ତେ ବାଗୁଏଃ ବିଃଆରେ । ତେନ୍‌ ଇଡ଼ିଂ ଆତେନ୍‌ ଲିଜକେ ଆରି ଉଡ଼ି ସ୍ଲେରେକେ ବାଟା ବିଏ ।” ରେମୁଆଁଇଂ ଆକେନ୍ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ଜେ “ଏନ୍‌ ସାମୁଆଁ ଅଃନା ଡିଗ୍ ଆଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_17","072_20_17","LUK","20","17","17","ଜିସୁ ଆମେଇଂକେ କେଚେ ବାସଙ୍ଗ୍‌କେ “ତେଲା ଦରମ୍‌ ପୁରାନ୍‌ନିଆ ଏନ୍‌ ପଦ୍‍ନେ ଅର୍‌ତ ମେଁନେ ଡିଙ୍ଗ୍‌ଏ: ସାମୁଆଁ ମିସ୍‍ତିରିଇଂ ଆଣ୍ଡିନେ ବ୍ରିକେ ମନ୍‍ ଆଡିଂଆର୍‌କେ ଏକେ କନ୍‍ନେ ମୁଲ୍‌ ବ୍ରି ଡିଙ୍ଗ୍‍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_18","072_20_18","LUK","20","18","18","ମୁଡ଼ି ରେମୁଆଁ ଆତେନ୍‌ ବ୍ରି ଆଡ଼ାତ୍ରା କସ୍ରେଚେ ଲଃଏ ମେଁନେ ନ୍ତି ଞ୍ଚ ପାକ୍‍ଚି ୱେଏ । ମାତର୍‌ ଆତେନ୍‌ ବ୍ରି ଜା ଆଡ଼ାତ୍ରା ଲଃଏ ଆତେନ୍‌ ଆମେକେ ବାଲି ସୁଗୁଆ ଗୁଣ୍ଡ୍ ଆଡିଙ୍ଗ୍ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_19","072_20_19","LUK","20","19","19","“ଦର୍ମ ସାସ୍ତ୍ରି ଆରି ମ୍ନା ପୁଜାରିଇଂ ଜିସୁବାନ୍ ଏନ୍‌ ଉସ୍ରା ଅଁଆର୍କେ । ମେଇଙ୍ଗ୍ ମ୍ୟା ଆର୍‌କେ ଜେ ଆକେନ୍ ଉସ୍ରା ମେଁଇଙ୍ଗ୍‌ନେ ବିସ‍ଏରେ ବାଲିର୍‍ବକେ । ତେସା ମେଇଙ୍ଗ୍ ଜିସୁକେ ସମାନ୍ ବେଲା ବନ୍ଦି ଆଡିଙ୍ଗ୍‌ନେ ଚାଏଁଆର୍‌କେ । ମାତର୍‌ ରେମୁଆଁଇଂ ମାରିୟାଃ ମେଃନେ ଡିଙ୍ଗ୍‌ବିଆର୍‌ଏ ଆତେନ୍‌‌ସା ମେଇଂ ବୁଟ ଡିଙ୍ଗ୍‍ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_20","072_20_20","LUK","20","20","20","ତେସା ମେଇଂ ସୁଜଗ୍‌ ତୁର୍‌ଆର୍‌କେ । ଜିସୁକେ ରୋମୀୟ ସାସନ୍‌ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଡାଗ୍ରା ଆସା ବିନ୍‌ସା ନିଜେକେ ଦରମ୍ ଆଃସୁଏମ୍ୟାକ୍ନେ ଉଡ଼ିକ୍ଲିଗ୍‌ ଗୁପ୍ତଡଙ୍ଗାରେକେ ମେଇଂ ବେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_21","072_20_21","LUK","20","21","21","ଆତେନ୍‌ ରେମୁଆଁଇଂ ଜିସୁକେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଗୁରୁ ନେନେ ମ୍ୟା ନେଲେକେ ଜେ ପେ ମେଁନେ ବାସଙ୍ଗ୍‌ପେଡିଂ ଆରି ବ୍ନାଲିର୍ ବିଃ ନାଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ସାପା ଟିକ୍ । ନାନେ ଜା ଆଡ଼ାତ୍ରା ଡିଗ୍ ନାବୁଟ ଣ୍ଡୁ । ମାତର୍‌ ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚା ବିସୟ୍‌ରେ ସତ୍ ବୁଦି ବିଃ ନାମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_22","072_20_22","LUK","20","22","22","ଆନେକେ ବାସଙ୍ଗ୍ । କାଇସର୍‍କେ ସିସ୍ତୁ ବିନେ ନିଅମ୍ ଲେଃ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("LK20_23","072_20_23","LUK","20","23","23","ମାତର୍‌ ଜିସୁ ମେଁଇଙ୍ଗ୍‌ନେ ଚାଲାକି ମ୍ୟାଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK20_24","072_20_24","LUK","20","24","24","“ମୁଇଙ୍ଗ୍ ରୁପା ଡାବୁ ଆଃକେଲା । ଆକେନ୍ ଆଡ଼ାତ୍ରା ଜାନେ ଚିତ୍ର ଆରି ମ୍ନି ଲେଃକେ ?” ମେଇଙ୍ଗ୍ ଉତର୍ ବିଃଆର୍‌କେ “କାଇସରନେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_25","072_20_25","LUK","20","25","25","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ତେଲା ଆଣ୍ଡିନେ କାଇସର୍‍ନେ ଆତେନ୍‌ କାଇସର୍‍କେ ବିଃପା ଆଣ୍ଡିନେ ପର୍‍ମେସର୍‍ନେ ଆତେନ୍‌ ପର୍‍ମେସର୍‍କେ ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_26","072_20_26","LUK","20","26","26","ଆତ୍‌ବା ମେଇଂ ଜିସୁନେ ବୁଲ୍‍ ସାମୁଆଁ ସା ମାୟାଚେ । ଆରି ରେମୁଆଁଇଂ ଜିସୁନେ ଏନ୍‌ ବୁଦି ସୁଗୁଆ ଉତର୍ ଅଁଚେ କାବା ଡିଙ୍ଗ୍ ୱେ ଆର୍‌ଗେ । ମେଇଂ ମେଃଡିଗ୍ ବାସଙ୍ଗ୍‌ ଆୟାଆର୍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK20_27","072_20_27","LUK","20","27","27","ତେନ୍ଇଡ଼ିଂ ରେମୁଆଁଇଂନେ ଗୁଏଚେ ମ୍ବ୍ରନେଲେଃକେ ଡାଗ୍‌ଚେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ ଆଃମ୍ୟାଃକ୍ନେ ଉଡ଼ି ସାଦୁକୀଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ସାଲିଆକୁ ସାମୁଆଁକେ ");
INSERT INTO gaq_vpl VALUES ("LK20_28","072_20_28","LUK","20","28","28","“ଗୁରୁ ମୋଶା ନେନେ ସା ଗୁଆର୍‍ ବଗେ ଜେ ଜଦି ମୁଇଂ ବିହେ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ଙ୍ଗିରେ ମେଁ ଡିଗ୍ ଗୋ ଗିସିଆ ମାକେଚେ ଗୁଏ ୱେଏ ତେଲା ମେଁ ବୟାଁ ଡିଲାଡିଗ୍ ଆତେନ୍‌ ଗୁଏକ୍ନେ ବୟାଁନେ କୁନେଡ଼େକେ ବିହେ ଡିଙ୍ଗ୍‌ଏ । ତେଲା ସିନା ମେଁ ଆତେନ୍‌ ଗୁଏ ୱେକ୍ନେ ବୟାଁ ନ୍‌ସା ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ବାନ୍ ଗୋ ଗିସିଆ ବଁସ୍‌କୁଲ୍ ଆମ୍ନା ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK20_29","072_20_29","LUK","20","29","29","ମୁଇଂ ଜାଗାନ୍ନିଆ ଗୁ ବୟାଁ ଲେଃଆର୍‌କେ । ମ୍ନା ବୟାଁ ବିହେ ଡିଙ୍ଗ୍‌ଲେଃଗେ । ମୁଇଂ ଡିଗ୍‌ ଗଗିସିଆ ମାକେଚେ ଗୁଏୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_30","072_20_30","LUK","20","30","30","ତେନ୍‌ ଇଡ଼ିଂ ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃକେ ଆରି ମୁଇଂଜା ବିହେ ଡିଙ୍ଗ୍‌କେ । ମାତର୍‌ ମେଁ ଡିଗ୍ ଗୁଏ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_31","072_20_31","LUK","20","31","31","ତେନ୍‌ ଇଡ଼ିଂ ବାରି ମୁଇଂଜା ବୟାଁ ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃକେ ବିହେ ଡିଙ୍ଗ୍‌କେ ଆରି ଗୁଏ ୱେକେ । ବିନ୍ ବୟାଁଇଂନ୍ନିଆ ଡିଗ୍ ଡେତ୍‌ରକମ୍ ଗଟେକେ । ମେଇଂ ସାପାରେ ଗୁଏ ୱେକେ ଆରି ଜାନେ ଡିଗ୍ ଗଗିସିଆ ଜନମ୍ ଡିଙ୍ଗ୍ ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK20_32","072_20_32","LUK","20","32","32","ସାରାସାରି ବେଲା ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ଡିଗ୍ ଗୁଏ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_33","072_20_33","LUK","20","33","33","ଗୁକ୍ଲିଗ୍‍ ବୟାଁ ଜାକ ଆମେକେ ବିହେ ଡିଙ୍ଗ୍ ଲେଃଗେ । ତେଲା ଉଡ଼ିବେଲା ରେମୁଆଁ ଗୁଏଚେ ଜିବନ୍ ଆବାଚେ ତଡ଼ିଆଏ ଆତେନ୍‌‌ ବେଲା ଏନ୍‌ ସେଲାମ୍ବୁଏ ଜାନେ କୁନୁଏଡ଼େ ଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK20_34","072_20_34","LUK","20","34","34","ଜିସୁ ସାଦୁକୀଇଂକେ ବାଲିର୍‍କେ, “ସଂସାର୍‍ନେ ରେମୁଆଁଇଂ ନିଜେ ନିଜେ ବିତ୍ରେ ବିହେ ଡିଙ୍ଗ୍‌ମ୍ୟାଆର୍‌କେ, ବିହେ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବିଃମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_35","072_20_35","LUK","20","35","35","ମାତର୍‌ ଉଡ଼ିରୁଆ ଗୁଏଚେ ଆରି ତଡ଼ିଆନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଆରି ମେଇଂ ଏନ୍‌ ଜିବନ୍ ଇଡ଼ିଙ୍ଗ୍ ଡିଗ୍ ଆରି ମୁଇଂତର୍ ଜିବନ୍ ଲେଃ ଆର୍‌ଏ । ଆତେନ୍‌ ଜିବନ୍‍ରେ ମେଇଂ ବିହେ ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ଡୁ ଲେଃ ବିହେ ଆବିଆର୍‍ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("LK20_36","072_20_36","LUK","20","36","36","କିତଂନ୍ନିଆ ରେମୁଆଁଇଂ କିତଂନେ ଦୁତ୍‍ଇଂ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ଆରି ମେଇଙ୍ଗ୍ ଅଃନାଡିଗ୍ ଆଗୁଏଆର୍‍ ଣ୍ଡୁ । ମେଇଙ୍ଗ୍ ପର୍‍ମେସର୍‍ନେ ଗଗିସିଆ ଡାଗ୍‍ଲା ଗୁଏକ୍ନେବାନ୍ ଆରି ମୁଇଙ୍ଗ୍‌ତର୍ ମ୍ବ୍ରଚେ ମେଇଂ ତଡ଼ିଆ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK20_37","072_20_37","LUK","20","37","37","ମୋଶା ନିମାଣ୍ଡା ବାବ୍‌ରେ ଆକେ ବଗେ ଜେ ରେମୁଆଁଇଙ୍ଗ୍ ଗୁଏଚେ ଆର୍‌ମୁଇଂତର୍ ମ୍ବ୍ରଆର୍‌ଏ । ଡୁଆନେ ଲାଟା ବିସୟ୍‌ରେ ଗୁଆର୍‍ବକ୍ନେ ସାସ୍ତର୍‌ନ୍ନିଆ ମୋଶା ମାପ୍ରୁକେ ବାସଂବକେ, ନେ ଅବ୍ରାହାମ୍‌ନେ ପର୍‌ମେସର୍‌ ଇସାକ୍‌ନେ ପର୍‌ମେସର୍‌ ଜାକୁବ୍‌ନେ ପର୍‌ମେସର୍‌ ଡାଗ୍‌ଚେ ଗୁଆର୍ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_38","072_20_38","LUK","20","38","38","ଜଦି ପର୍‍ମେସର୍‍ ବାସଙ୍ଗ୍‍ବକେ ଜେ ମେଁ ମେଁଇଙ୍ଗ୍‌ନେ ପର୍‍ମେସର୍‍ ତେଲା ଏନ୍‌ ରେମୁଆଁଇଂ ସତ୍‍ରେ ଆଗୁଏ ଆର୍‌କେ ଣ୍ଡୁ । ମେଁ ମାତର୍‌ ଜିବନ୍ ରେମୁଆଁଇଂନେ ପର୍‍ମେସର୍‍ । ଜାଣ୍ଡେଇଂ ପର୍‍ମେସର୍‍ନେ ରେମୁଆଁଇଂ ମେଇଂ ସାପାରେ ଜିବନ୍ ଲେଃ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_39","072_20_39","LUK","20","39","39","ଦର୍ମସାସ୍ତ୍ରିଇଂ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଗୁରୁ ନାନେ ଉତର୍ ନିମାଣ୍ଡା ଲେଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK20_40","072_20_40","LUK","20","40","40","ଜିସୁକେ ଆରି ମାଲେ ପ୍ରସ୍‌ନ ସାଲ୍ୟାକୁନେ ଜା ଡିଗ୍ ସାହାସ୍ ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK20_41","072_20_41","LUK","20","41","41","ତେନ୍ଇଡ଼ିଂ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ରେମୁଆଁ ମେସା ବାଲିର୍‌ଆର୍‌ଡିଂକେ ଜେ କିସ୍‌ଟ ଦାଉଦ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ? ");
INSERT INTO gaq_vpl VALUES ("LK20_42","072_20_42","LUK","20","42","42","ଗୀତସଂହିତାନ୍ନିଆ ଦାଉଦ୍ ମେଁ ନିଜେ ବାଲିର୍ ବକେ: ସାମୁଆଁ ମାପ୍ରୁ ପର୍‍ମେସର୍‍ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁ କ୍ରିସ୍ଟକେ ବାସଙ୍ଗ୍‌କେ: ନେଙ୍ଗ୍‌ନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା ନେଙ୍ଗ୍‍ ଡାଗ୍ରା କଲା । ");
INSERT INTO gaq_vpl VALUES ("LK20_43","072_20_43","LUK","20","43","43","ନେନେ ଉଡ଼ିବେଲା ଜାକ ପେନେ ସତ୍ରୁଇଂକେ ନାଁନେ ଞ୍ଚ ବୁନ୍ଦେ ଡୁଂପାଙ୍ଗ୍‍ ଜାକ ଆତେନ୍‌ ବେଲା ଜାକ ନେଁନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା କଲାଃଲା । ");
INSERT INTO gaq_vpl VALUES ("LK20_44","072_20_44","LUK","20","44","44","ଦାଉଦ୍‍ ମସିହକେ ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ତେଲା ମସିହ ଡିରକମ୍ ଦାଉଦ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ଡିଙ୍ଗ୍‍ୟାଏ ? ଏନ୍‌ ମ୍ୱାୟାନେ ସାମୁଆଁ ଡିରକମ୍ ସତ୍ ଡିଙ୍ଗ୍ଇଁୟାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK20_45","072_20_45","LUK","20","45","45","ସାପା ରେମୁଆଁ ଜିସୁନେ ସାମୁଆଁ ଅଁ ଆର୍‍ଡିଙ୍ଗେ । ଜିସୁ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK20_46","072_20_46","LUK","20","46","46","“ଦର୍ମ ସାସ୍ତ୍ରିଇଂବାନ୍‌ ତରକ୍ ଲାଃଲାପା ! ଚ୍ଲେ ପାଟାଇ ସଃଚେ ଅଲେଙ୍ଗ୍‌ନ୍‌ସାଃ, ବାରି ସାନ୍ତାନ୍ନିଆ ସାର୍ଲ, କୁକପାର୍‌ ଡୁଆନ୍ନିଆ ମ୍ନାଃ କୁର୍ଚି ଆରି ବଜିନ୍ନିଆ ମ୍ନାଃ ଜାଗା ବଲ୍‌ ବାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK20_47","072_20_47","LUK","20","47","47","ମେଇଂ ଗୁଏସାଙ୍ଗ୍‌କୁଏଇଂନେ ଡୁଆ ବାଜାର୍ ନାଲେଚେ ଡୁଂଡ ମ୍ୟାକେ । ମେଇଂ ଚ୍ଲେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ଚେ ନିଜ୍‍କେ ନିମାଣ୍ଡା ଆସୁଏ ନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ମ୍ୟା ଆର୍‌କେ । ପର୍‍ମେସର୍‍ ଦେଃକେନ୍ ରେମୁଆଁଇଂକେ ବୟ୍‍ଙ୍କାର୍‍ ଡଣ୍ଡ୍‍ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK21_1","072_21_1","LUK","21","1","1","ଜିସୁ ପିତୁର୍ ପାକା କେକେ ଜେ ଉଡ଼ି ସାଉକାର୍‌ ରେମୁଆଁ ମନ୍ଦିର୍‌ନେ ଦାନ୍ ବିଃକ୍ନେ ବୁବନେ ପିଡ଼ିନିଆ ପର୍‍ମେସର୍‍ ନ୍‌ସା ଦାନ୍‍ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK21_2","072_21_2","LUK","21","2","2","ଜିସୁ ମୁଇଙ୍ଗ୍ ଗରିବ୍‍ ଗ‍ଏସାଙ୍ଗ୍‌କୁଏକେ କେକେ । ଆତେନ୍‌ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ଦାନ୍ ବିଃକ୍ନେ ଡାବୁ ବୁବନେ ପିଡ଼ିନିଆ ମ୍ୱାକିଲିଗ୍‍ କଁସ୍‌ନେ ଡାବୁ ତାଲାଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK21_3","072_21_3","LUK","21","3","3","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍, ଆକେନ୍ ଗରିବ୍‍ ଗୁଏସାଙ୍ଗ୍‌କୁଏ ମୁଇଙ୍ଗ୍ ଆକେନ୍ ଦନି ରେମୁଆଁଇଂନେବାନ୍‍ ଜାବର୍‌ ଅଦିକା ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK21_4","072_21_4","LUK","21","4","4","ଡାଗ୍ଲା ବିନ୍‍ରେଇଂ ମେଁଇଂନେ ଦନ୍‍ନେ ଉଡ଼ି ଦାନ୍‌ ବିଃବକେ, ମାତର୍‌ ଗୁଏସାଙ୍ଗ୍‍କୁଏ ମୁଇଂ ଗରିବ୍‍ ଡିଙ୍ଗ୍‌ଲା ଡିଗ୍ ମେଁନେ ବ୍ରୁଆନ୍‍ସା ଉଡ଼ି ଲେଃଗେ ସାପା ମେଁ ବିଃବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK21_5","072_21_5","LUK","21","5","5","ଉଡ଼ିକ୍ଲିଗ୍ ସିସ୍‌ ମନ୍ଦିର୍‍ ବିସୟ୍‌ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଂଗେ । ମେଇଂ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ମୁଇଙ୍ଗ୍ ସୁନ୍ଦର୍‌ ମନ୍ଦିର୍‍ । ଆକେନ୍ ସାପାବାନ୍‍ ନିମାଣ୍ଡା ବ୍ରି ଏତେ ଆରେ ବକେ । କେଲା ପର୍‍ମେସର୍‍କେ ଡିରକମ୍ ନିମାଣ୍ଡା ନିମାଣ୍ଡା ଦାନ୍ ବିବ ଆର୍‌କେ !” ");
INSERT INTO gaq_vpl VALUES ("LK21_6","072_21_6","LUK","21","6","6","ମାତର୍‌ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଏବେ ପେଇଂ ଆକ୍‌ଅରିଆ ମେଃନେ ସାପା କେପେଡିଙ୍ଗ୍‌କେ ବେଲା ପାଙ୍ଗ୍‌କେ ଉଡ଼ିବେଲା ଆକେନ୍ ସାପା ଦଂସ ଡିଙ୍ଗ୍‌ୱେଏ । ଆକେନ୍ ଦର୍‌ତନିନେ ସାପା ବ୍ରି ତୁବଃ ଅରିଆ କୁଡ଼େଃଚେ ଲଃଏ । ମୁଇଂଡିଗ୍‍ ବ୍ରି ବିନ୍‍ମୁଇଙ୍ଗ୍ ବ୍ରି ଆଡ଼ାତ୍ରା ଲେଃ ଆୟାଆର୍‍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK21_7","072_21_7","LUK","21","7","7","ଉଡ଼ିକ୍ଲିଗ୍ ସିସ୍‌ ଜିସୁକେ ସାଲିଆକୁକେ “ଗୁରୁ ! ଆକେନ୍ ସାପା ଗଟ୍‌ନା ଅଃନା ଗଟେଏ ? ଡିରକମ୍‍ନେ ଚିନା ଡିଙ୍ଗ୍‌ନେ ସୁଗୁଆ ଡିଙ୍ଗ୍‍ଏ ଜେ ଆକେନ୍ ସାପା ଗଟ୍‌ନା ଗଟେନେ ବେଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK21_8","072_21_8","LUK","21","8","8","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଜାଗ୍ରତ୍‍ ! ତାନ୍ଦ୍ରା ଆଡିଙ୍ଗେପା । ନେଙ୍ଗ୍ ମ୍ନି ସାଚେ ଗୁଲେ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଆର୍‌ଏ । ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍ଏ ସାମୁଆଁ ନେଙ୍ଗ୍ କିସ୍‌ଟ ଆରି ସାମୁଆଁ ଟିକ୍ ବେଲା ପିଙ୍ଗ୍‍ଚା ଲେଃକେ । ମାତର୍‌ ପେଇଂ ମେଁଇଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଦ୍ରିଗ୍‌ଚେ ପ୍ଲାପ୍ଲା ଆୱେଗେପା । ");
INSERT INTO gaq_vpl VALUES ("LK21_9","072_21_9","LUK","21","9","9","ପେଇଂ ଉଡ଼ିବେଲା ଜୁଦ୍‌ ଆରି ରିଙ୍ଗ୍‍ଆଃ ଡିଙ୍ଗ୍‍ନେ ରେମୁଆଁଇଂନେ ପେଅଁଏ ତେଲା ପେ ପେବୁଟ ଣ୍ଡୁ । ଏନ୍‌ ସାପା ଗଟ୍‌ନା ସତେଆ ପର୍‍ତୁମ୍‍ ଗଟେଏ । ମାତର୍‌ ସଂସାର୍‍ ଡାନେ ବେଲା ପାଙ୍ଗ୍‌ନେ ତଙ୍ଗାର୍‌ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK21_10","072_21_10","LUK","21","10","10","ଜିସୁ ଆମେଇଂକେ ଆରି ବାସଙ୍ଗ୍‌କେ “ଦେସ୍ ଦେସ୍ ବିତ୍ରେ ରିଙ୍ଗ୍‍ଆଃ ଆର୍‌ଏ । ରାଇଜ୍ ରାଇଜ୍ ବିରଦ୍‌ରେ ରିଙ୍ଗ୍‍ଆଃ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_11","072_21_11","LUK","21","11","11","ବୁଟମେଗ୍‍ନେ ବୁମିକମ୍ପ ରଗ୍ ଆରି ଅସାନ୍ତିନେ ସାମୁଆଁ ସାପା ଜାଗାନ୍ନିଆ ଗଟେଏ । ଉଡ଼ି ଜାଗାନ୍ନିଆ ମୁର୍‍ଡି ଡିଙ୍ଗ୍‌ଏ ରେମୁଆଁଇଂକେ ଚଙ୍ଗ୍‍ନେ ଆମିଲେ ଣ୍ଡୁ । ବୟଙ୍କାର୍ ଗଟ୍‌ନାଇଂ ଗଟେଏ । ରେମୁଆଁଇଂକେ ଆଚେତାନ୍‍ସା କିତଙ୍ଗ୍ଇନି ଅରିଆ ଗୁଲେ ପାରାନ୍‍ ଦାଡ଼୍‍କେକେ ସୁଗୁଆ ସାମୁଆଁ ଆତ୍ନାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_12","072_21_12","LUK","21","12","12","ମାତର୍‌ ଆକେନ୍ ସାପା ଗଟ୍‌ନା ଗଟେନେ ସେନୁଗ୍‍ ରେମୁଆଁ ଆପେକେ ବନ୍ଦି ଆଡିଙ୍ଗ୍‌ଚେ ଡୁଂୱେଏ ଆର୍‌ଏ ଆରି ଆପେକେ କଷ୍ଟ ବିଏ । ରେମୁଆଁଇଂ ମେଁଇଙ୍ଗ୍‌ନେ ପାର୍‌ତନା ଡୁଆ ଅରିଆ ଆପେକେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଏ ଆରି ଆପେକେ କ‍ଏଦ୍ ଡୁଆ ଅରିଆ ବନ୍ଦି ଆଡିଙ୍ଗ୍ ଆର୍‌ଏ । ଇଃସାଙ୍ଗ୍‌ ଆରି ସାସନ୍‍ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେ ସାମ୍‍ନାରେ ଆପେକେ ଆତୁଆଁଏ । ପେଇଂ ନେଙ୍ଗ୍‌ନେ ପ୍ଲାଃ ପାଙ୍ଗ୍ ପେଲେକେସା ରେମୁଆଁଇଙ୍ଗ୍ ପେ ଆଡ଼ାତ୍ରା ଦେକ୍ ରକମ୍ ବେବଆର୍ ଆଃସୁଏ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_13","072_21_13","LUK","21","13","13","ମାତର୍‌ ଏନ୍ ଆପେକେ ନେଙ୍ଗ୍ ବିସୟ୍‌ରେ ବାଲିର୍ ନ୍‍ସା ବେଲା ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_14","072_21_14","LUK","21","14","14","ପେଇଙ୍ଗ୍ ନିଜ୍‍କେ ଆଃମ୍ବ୍ର ନ୍‍ସା ମେଁନେ ପେବାସଙ୍ଗ୍‌ଏ ଆତେନ୍‌‌ସା ଅଃନା ଚିନ୍ତା ଆଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("LK21_15","072_21_15","LUK","21","15","15","ନେଙ୍ଗ୍ ଆପେକେ ଦେକ୍ ସୁଗା ବାଲିର୍ ନ୍‌ସା ଗିଆନ୍ ମ୍ୱିଏ । ପେଇଂ ମେଁନେ ପେବାସଙ୍ଗ୍‌ଏ ପେନେ ଜା ଡିଗ୍ ବିରଦ୍ ରେମୁଆଁ ଆତେନ୍‌ ଉତର୍ ବିଃଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK21_16","072_21_16","LUK","21","16","16","ଦେକ୍‍ରକମ୍‍କି ପେନେ ଆବା ଇୟାଙ୍ଗ୍ ବୟାଁ ସାଙ୍ଗ ଆରି କୁଟୁମ୍‌ଣ୍ଡ୍ରେଇଂ ପେନେ ବିରଦ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ମେଇଙ୍ଗ୍ ପେନେବାନ୍ ଉଡ଼ି ରୁଆକେ ବାଗୁଏଃ ବିଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_17","072_21_17","LUK","21","17","17","ପେଇଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ପ୍ଲାପ୍ଲା ପାଙ୍ଗ୍‍ପେଲେକେସା ସାପାରେ ଆପେକେ ଗୁର୍ନା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_18","072_21_18","LUK","21","18","18","ମାତର୍‌ ସତେଆ ଅଃକେନ୍ ବିତ୍ରେବାନ୍ ଜା ବାନ୍ ଡିଗ୍ ଆପେକେ ମୁଇଙ୍ଗ୍ ଡିଙ୍ଗ୍ ବାଆଃନେ ଉଗ୍‌ବ ନଷ୍ଟ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK21_19","072_21_19","LUK","21","19","19","ସାହାସ୍ ବାନ୍ ପେଇଂ ନିଜର୍ ନିଜର୍ ଜିବନ୍ ଆମ୍ବ୍ର ପେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK21_20","072_21_20","LUK","21","20","20","ପେଇଙ୍ଗ୍ ଯିରୁଶାଲାମ୍‍ ପିତୁର୍‍ପାକା ସନ୍ୟ‍ଇଙ୍ଗ୍ ଗେରେଚେ ଲେଃକ୍ନେ ପେକେଏ । ତେଲା ପେଇଂ ମ୍ୟାପେୟାଏ ଜେ ଯିରୁଶାଲାମ୍‍ ଦଂସ ଡିଙ୍ଗ୍‌ନେ ବେଲା ପିଙ୍ଗ୍‍ଚା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK21_21","072_21_21","LUK","21","21","21","ଆତେନ୍‌ ବେଲା ଜିଉଦାନେ ରେମୁଆଁଇଙ୍ଗ୍ କଣ୍ଡା ଆଃଡ଼ାପାକା ଲେଃଆର୍‌ଏ ମେଇଂ କଣ୍ଡା ପାକା ୱିର୍‌ ଡୁଂୱେଲେ ଜାଣ୍ଡେ ଇନି ଆର୍‌ଏ ମେଇଂ ବିନ୍ ପାକା ୱେଆର୍‌ଲେ ଆରି ଜାଣ୍ଡେଇଂ ପଲି ଇନିନ୍ନିଆ ଲେଃଆର୍‌ଏ ବାରି ଦେସ୍‌ନିଆ ଆଣ୍ଡେ ଆପାଙ୍ଗ୍‍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK21_22","072_21_22","LUK","21","22","22","ପର୍‍ମେସର୍‍ ଉଡ଼ିବେଲା ମେଁନେ ରେମୁଆଁଇଂକେ ଦନ୍‍ ବିଏ ଆତେନ୍‌ ବିସୟ୍‌ରେ ଅସେନେ ବକ୍ତାଇଂ ଗୁଲୁଏ ସାମୁଆଁ ଗୁଆର୍‍ ବଆର୍‌କେ । ନେଙ୍ଗ୍ ଆପେକେ ଆତେନ୍‌ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଉଡ଼ିବେଲା ସାପା ଗଟ୍‌ନା ସତ୍‌ ବାବ୍‌ରେ ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_23","072_21_23","LUK","21","23","23","ଆତେନ୍‌‌ ବେଲା ଗାଗ୍‌ଡ଼େ ଲେଃକ୍ନେ ସେଲାମ୍ବୁଏ ଆରି ବିନ୍‌ ଡାଆଁନେ ଗଡ଼େଅ ଲେଃନେ ସେଲାମ୍ବୁଏଇଙ୍ଗ୍‌ନେ ମାଲେ କଷ୍ଟ ଡିଙ୍ଗ୍‌ଏ । ଡାଗ୍‍ଲା ଆତେନ୍‌ ଦିନାଇଂକେ ଆକେନ୍ ଦେସ୍ ଆଡ଼ାତ୍ରା ମାଲେ କଷ୍ଟ ଲିଗ୍ ଡୁଂପାଙ୍ଗ୍ଏ । ଆରି ଏନ୍‌ ରେମୁଆଁ ଆଡ଼ାତ୍ରା ପର୍‌ମେସର୍‌ନେ ଡଣ୍ଡ୍‍ ପାଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_24","072_21_24","LUK","21","24","24","ଉଡ଼ିରୁଆକେ ସନ୍ୟଇଙ୍ଗ୍ ବାଗୁଏ ଆର୍‌ଏ । ବିନେ ଉଡ଼ିରେକେ ଗାଗ୍‌ଚେ ବିନ୍ ସାପା ଦେସ୍‌ପାକା ବେବିଃଆର୍‌ଏ । ଅବିସ୍‌ବାସି ଜିଉଦି ରେମୁଆଁଇଂନେ ମେଁଇଙ୍ଗ୍‌ନେ ବେଲା ମାଡାନେ ଜାକ ପବିତ୍ର ମ୍ନାଇନି ଯିରୁଶାଲାମ୍‍କେ ଞ୍ଚ ଆଲନେ ଦୁଲି ଡିଂଚେ ଲେଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_25","072_21_25","LUK","21","25","25","“ସ୍ନି ଆର୍କେ ବାରି ଚାଙ୍କୁଆଇଂ ଡାଗ୍ରା ଇରିୟାତୁଗ୍‌ନେ ଚିନା ତ୍ନାଏ । ସାପା ଦେସ୍‌ନେ ରେମୁଆଁଇଂ ନିରାସ୍‌ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ବାରି କେଣ୍ତିଆନେ ଗର୍‌ଜନ୍‌ ବାରି ବୟାଙ୍କାର୍‌ ଲଅଡ଼ି ସାପାରେକେ ବାଃଟ‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_26","072_21_26","LUK","21","26","26","ସଂସାର୍‍କେ ଚାପେ ପାଙ୍ଗ୍‌ନେ ବିପଦ୍‍କେ ଚିନ୍ତା ଡିଙ୍ଗ୍‌ଚେ ରେମୁଆଁଇଙ୍ଗ୍ ବୁଟଚେ ମୁର୍‍ଚା ଡିଙ୍ଗ୍‍ୱେଆର୍‍ଏ । କିତଙ୍ଗ୍ଇନିନେ ସାପା ଗ୍ରଅ ବଦ୍‌ଲେ ୱେ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_27","072_21_27","LUK","21","27","27","ଆତେନ୍‌‌ ବେଲା ରେମୁଆଁଇଙ୍ଗ୍ ରେମୁଆଁ ଉଂଡେକେ ବପୁ ଆରି ମ୍ନା ଗୌରବ୍ ଏତେ ତ୍ରିଗ୍‌ଡିଆ ଆଡ଼ାତ୍ରା ବାନ୍ ପାଙ୍ଗ୍‌ନେ ପେକେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_28","072_21_28","LUK","21","28","28","ଉଡ଼ିବେଲା ଆକେନ୍ ଗଟ୍‌ନା ଗଟେନେ ଆରାମ୍‍ ଡିଙ୍ଗ୍ ୱେଏ ଆଡ଼ାତ୍ରା ତାଣ୍ଡେଚେ ସାର୍ଦା ପେଡିଙ୍ଗ୍‌ଏ ଡାଗ୍ଲା ପେଇଂନେ ମୁକ୍ତିନେ ବେଲା ଡାଗ୍ରା ଡିଙ୍ଗ୍‌ୱେଡିଙ୍ଗେ ଡାଗ୍‌ଚେ ଆକ୍‌ବାନ୍ ପେମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_29","072_21_29","LUK","21","29","29","ତେନ୍ଇଡ଼ିଂ ଜିସୁ ମୁଇଙ୍ଗ୍ ଉସ୍ରା ବାସଙ୍ଗ୍‌କେ ଲିୱା ସ୍ଲାଃ ଆରି ବିନ୍ ସ୍ଲାଃଇଂନେ ସାମୁଆଁ ଏତେ କେଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK21_30","072_21_30","LUK","21","30","30","ଲିଉଆଁ ସ୍ଲାଃନେ କେନ୍ଦା ଅରିଆ ଉଡ଼ିବେଲା ତ୍ମି ଉଲିଆଃ ପଃଏ ପେଇଙ୍ଗ୍ ମ୍ୟାପେୟାଏ ଜେ ବୁନସେଙ୍ଗ୍ ପିଙ୍ଗ୍‍ଚା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK21_31","072_21_31","LUK","21","31","31","ଦେତ୍ ରକମ୍ ନେଙ୍ଗ୍ ଆପେକେ ମେଁନେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଆତେନ୍‌ ସାପା ଗଟେଏ । ଏନ୍‌ ସାପା ଗଟ୍‌ନା ଗଟେନେ କେଲା ପେଇଂ ମ୍ୟାପେୟାଏ ଜେ ପର୍‍ମେସର୍‍ନେ ରାଇଜ୍ ଡାଗ୍ରା ପିଙ୍ଗ୍‍ଚା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK21_32","072_21_32","LUK","21","32","32","“ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଏଃକେନେ ରେମୁଆଁଇଂ ଗୁଏନେ ସେନୁଗ୍‍ ଏନ୍‌ ସାପା ଗଟେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_33","072_21_33","LUK","21","33","33","ମଞ୍ଚ୍‌ପୁର୍‌ ଆରି କିତଙ୍ଗ୍ଇନି ଲପ୍ ଡିଙ୍ଗ୍‌ଏ । ମାତର୍‌ ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଃନାଡିଗ୍ ଲପ୍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK21_34","072_21_34","LUK","21","34","34","“ସାବ୍‍ଦାନ୍ ଲାଲାପା ! ପେଇଙ୍ଗ୍ ସାଗ୍ରା ଉଗ୍‌ଚେ ବୁସାଃଚେ ନିଜେନେ ବେଲା ନଷ୍ଟ ଆରାଡିଙ୍ଗ୍‌ପା । ସାଂସାରିକ୍ ଜିନିସ୍ଇଂ ବିସୟ୍‌ରେ ଜାବର୍‌ ଚିନ୍ତା ଆଡିଙ୍ଗ୍‌ପା । ଆରି ପେଇଂ ତିଆର୍ ଡିଙ୍ଗ୍‍ପେଲେଃକ୍ନେ ବେଲା ଉଲୁସ୍ତେ ସାରାସାରି ବେଲା ପାଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_35","072_21_35","LUK","21","35","35","ମଞ୍ଚ୍‌ପୁର୍‌ ଲେଃମ୍ୟାକ୍ନେ ସାପା ରେମୁଆଁଇଂ ଡାଗ୍‍ରା ଆକେନ୍ ମୁଇଙ୍ଗ୍ ପାନ୍ଦ୍‍ ସୁଗୁଆ ପାଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK21_36","072_21_36","LUK","21","36","36","ତେସା ସାପାବେଲା ତରକ୍‍ଚେ ଲାଲାପା । ଜା ସାପା ଗଟ୍‌ନା ଗଟେନେ ୱେଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ବିତ୍ରେ ବିଚେ ଟିକ୍‍ ଗାଲି ୱେନ୍‌ସା ବପୁ ବାନ୍‍ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ପା । ପେଇଂ ଆତ୍ମାରେ ବିସ୍‌ବାସ୍‍ରେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେନେ ସେନୁଗ୍ ତୁଆଁ ନ୍‍ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK21_37","072_21_37","LUK","21","37","37","ଆତେନ୍‌ ଦିନାଇଂ ଜିସୁ ରେମୁଆଁଇଂକେ ମନ୍ଦିର୍‌ନ୍ନିଆ ସାମୁଆଁ ବିଡିଙ୍ଗ୍‌ଗେ । ମିଡିଗ୍‍ ବେଲା ମେଁ ମ୍ନାଇନି ପାଦାପାକା ତାର୍‍ୱେଗେ ଆରି ପ୍ରାମିଡିଗ୍‍ ଜିତକଣ୍ଡା ଆଡ଼ାତ୍ରା କଟେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK21_38","072_21_38","LUK","21","38","38","ରେମୁଆଁଇଂ ମନ୍ଦିର୍‌ନ୍ନିଆ ୱେଚେ ଜିସୁନେ ବ୍ନାଲିର୍ ଅଁନ୍‌ସା ସାପା ଦିନା ଞ୍ଜିର୍‍ ତଡ଼ିଆଚେ ୱେଆର୍‍ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_1","072_22_1","LUK","22","1","1","ଖମୀର ଶୂନ୍ୟ ରୁଟି ପାଣ୍ଡୁଏ ଆଜା କି ଉଦାର୍ ପାଣ୍ଡୁଏ ଡିଗ୍ ବାସଙ୍ଗ୍‍ମ୍ୟାଃକେ ଆତେନ୍‌ ବେଲା ଡାଗ୍‍ରା ପିଙ୍ଗ୍‍ଚାଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_2","072_22_2","LUK","22","2","2","ମ୍ନା ପୁଜାରି ଆରି ଦରମ୍ ସାସ୍ତ୍ରିଇଂ ରେମୁଆଁଇଂକେ ବୁଟ ଡିଙ୍ଗ୍‍ଆର୍‌ଗେ । ମାତର୍‌ ମେଇଂ ଜିସୁକେ ତାଡ଼୍‍ତେ ବାଗୁଏଃ ନ୍‍ସା ଉପାୟ୍‌ ତୁର୍‌ଡିଙ୍ଗ୍ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_3","072_22_3","LUK","22","3","3","ଜିସୁନେ ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସିସ୍‌ଇଂବାନ୍‍ ମୁଇଂଜାନେ ମ୍ନି ଲେଃଗେ ଇଷ୍କରିୟଥ୍ ଜିଉଦାନ୍ନିଆ ସ‍ଏତାନ୍‌ ଗାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_4","072_22_4","LUK","22","4","4","ଆରି ଜିଉଦା ୱେଚେ ମ୍ନା ପୁଜାରି ଆରି ମନ୍ଦିର୍‌ନେ ସେନାପତି‍ଇଂ ଏତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌କେ । ଜିସୁକେ ମେଁଇଙ୍ଗ୍‌ନେ ନ୍ତିନିଆ ଆସା ବିନ୍‌ସା ଜିଉଦା ମେଇଂ ଏତେ ମୁଇଙ୍ଗ୍ ଉପାୟ୍‌ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_5","072_22_5","LUK","22","5","5","ଆତ୍‌ବା ପୁଜାରି‍ଇଂ ସାର୍ଦାଡିଙ୍ଗ୍ ଆର୍‌କେ । ଜିସୁକେ ମେଁଇଙ୍ଗ୍‌ନେ ନ୍ତିନିଆ ବିଃ ବିଃକେ ମେଇଂ ଜିଉଦାକେ ଡାବୁ ବିଃନ୍‍ସା ବାସଙ୍ଗ୍‌ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_6","072_22_6","LUK","22","6","6","ଜିଉଦା ରାଜି ଡିଙ୍ଗ୍‌କେ । ମେଁ ଜିସୁକେ ପୁଜାରି‍ଇଂନେ ନ୍ତିନିଆ ଆସା ବିଃନ୍‍ସା ମୁଇଙ୍ଗ୍ ଉପାୟ୍‍ରେ ଲେଃ ଆର୍‌ଗେ । ଜିଉଦା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଡିଙ୍ଗେ ଜେ ଉଡ଼ିବେଲା ମେଃଡିଗ୍ ରେମୁଆଁ ଆତ୍‌ଅରିଆ ପାଙ୍ଗ୍‍ଆଲେ ମେଁ ଆତେନ୍‌‌ ବେଲା ଏନ୍‌ କାମ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK22_7","072_22_7","LUK","22","7","7","କମିର ଶୂନ୍ୟ ରୁଟି ପାଣ୍ଡୁଏ ଦିନ୍ ପିଙ୍ଗ୍‍ଚାଗେ । ଆକେନ୍ ଦିନା ଜିଉଦିଇଙ୍ଗ୍ ଉଦାର୍ ପାଣ୍ଡୁଏନ୍ନିଆ ଡାଆଁ ମେଣ୍ଡାଇଂକେ ପୁଜା ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK22_8","072_22_8","LUK","22","8","8","ଜିସୁ ପିତର୍‌କେ ଆରି ଜହନ୍‌କେ ବାଲିର୍‍କେ “ପେଇଂ ୱେଚେ ନ୍‌ସା ଚଙ୍ଗ୍‍ନ୍‍ସା ଉଦାର୍ ପାଣ୍ଡୁଏନେ କାଦି ତିଆର୍ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_9","072_22_9","LUK","22","9","9","ପିତର୍ ଆରି ଜହନ୍‌ ଜିସୁକେ ସାଲିଆକୁକେ “ଏନ୍‌ କାଦି ଆଣ୍ଡିନ୍ନିଆ ନେନେ ତିଆର୍ ନେଡିଙ୍ଗ୍‍ଏ ଡାଗ୍‌ଚେ ନାନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍ ନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK22_10","072_22_10","LUK","22","10","10","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଅଁପା ! ପେଇଂ ସହର୍‌ ବିତ୍ରେ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଙ୍କୁଇନିଆ ଣ୍ଡିଆ ଡୁଂୱିଗ୍‍ନେ ପେକେଏ । ପେଇଂ ମେଁ ପ୍ଲା ପେୱେଏ । ମେଁ ମୁଇଙ୍ଗ୍ ଡୁଆ ବିତ୍ରେ ଗାଏ । ପେଇଂ ମେଁ ଏତେ ପେୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("LK22_11","072_22_11","LUK","22","11","11","ପେଇଂ ଡୁଆନେ ସାକାର୍‍କେ ପେସାଲ୍ୟାକୁଏ ଗୁରୁ ସାଲ୍ୟାକୁଡିଂକେ ଜେ ମେଁ ଆରି ମେଁନେ ସିସ୍ଇଂ ଉଦାର୍ ପାଣ୍ଡୁଏନେ ବଲେ ଆଣ୍ଡିଅରିଆ ଚଙ୍ଗ୍‍ଆର୍‍ଏ ଆତେନ୍‌ ଆନେକେ ଆଃସୁଏ ବିଲା । ");
INSERT INTO gaq_vpl VALUES ("LK22_12","072_22_12","LUK","22","12","12","ତେନ୍‌ ଇଡ଼ିଂ ଡୁଆ ସାଉକାର୍ ଆଡ଼ାତ୍ରା ମହଲାନେ ମ୍ନାନେ ବାକ୍‍ରା ଆସୁଏ ବିଏ । ଆତେନ୍‌ ବାକ୍‍ରା ନ୍ନିଆ ପେଇଂନ୍‌ସା ଆର୍ମେଚେ ବକେ । ଆତ୍‌ଅରିଆ ପେଇଂ ଉଦାର୍ ପାଣ୍ଡୁଏନେ କାଦି ପେରାରେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_13","072_22_13","LUK","22","13","13","ପିତର୍ ଆରି ଜହନ୍‌ ୱେଆର୍‌କେ । ଜିସୁ ଡିରକମ୍ ବାସଙ୍ଗ୍‍ବଗେ ସାପା ଗଟ୍‌ନା ଦେତ୍‌ରକମ୍ ଗଟେକେ । ମେଇଂ ଆତ୍‌ଅରିଆ ଉଦାର୍ ପାଣ୍ଡୁଏନେ କାଦି ଆଃରେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_14","072_22_14","LUK","22","14","14","ମେଇଂ ଉଦାର୍ ପାଣ୍ଡୁଏନେ ବଲେ ଚଙ୍ଗ୍‍ନେ ବେଲା ଡିଙ୍ଗ୍‌ଗେ । ଜିସୁ ଆରି ସିସ୍‌ଇଂ ଚଙ୍ଗ୍‍ନେ କଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_15","072_22_15","LUK","22","15","15","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଗୁଏନେ ସେନୁଗ୍ ପେଇଂ ଏତେ ଆକେନ୍ ଉଦାର୍ ପାଣ୍ଡୁଏନେ ବଲେ ଚଙ୍ଗ୍‍ନେସା ନେଙ୍ଗ୍ ଜାବର୍‌ ଇକ୍‌ଚା ଣ୍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_16","072_22_16","LUK","22","16","16","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ପର୍‍ମେସର୍‍ନେ ରାଇଜ୍ ନ୍ନିଆ ଏନ୍‌ ଅର୍‌ତ ମାତ୍ନା ଜାକ ନେଙ୍ଗ୍ ଅଃନାଡିଗ୍ ଉଦାର୍ ପାଣ୍ଡୁଏନେ କାଦି ନାଚଙ୍ଗ୍‍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_17","072_22_17","LUK","22","17","17","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ମୁଇଙ୍ଗ୍ ଗିନାନ୍ନିଆ ଅଙ୍ଗୁର୍ ରସ୍ ଡୁଂୱେକେ । ଆକେନ୍‌ସା ମେଁ ପର୍‍ମେସର୍‍କେ ଦନ୍ୟବାଦ୍ ବିକେ । ମେଁ ବାସଙ୍ଗ୍‌କେ, “ଆକେନ୍ ଗିନା ଡୁଂୱେଲା ଆକ୍‌ଅରିଆ ଲେଃକ୍ନେ ଅଙ୍ଗୁର୍ ରସ୍ ସାପାରେ ବାଟା ଉଗ୍‍ପା । ");
INSERT INTO gaq_vpl VALUES ("LK22_18","072_22_18","LUK","22","18","18","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ପର୍‍ମେସର୍‍ନେ ରାଇଜ୍ ଆପାଙ୍ଗ୍‍ ଜାକ ନେଙ୍ଗ୍ ଆରି ଅଙ୍ଗୁର୍ ରସ୍ ନ୍ନାଉଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_19","072_22_19","LUK","22","19","19","ବାରି, ମେଁ ରୁଟି ସାଃଚେ ଦନ୍ୟବାଦ୍‌ ବିଃକେ ବାରି ଆତେନ୍‌‌ ପାକ୍‌ଚିଚେ ଆମେଇଂକେ ବିଃଚେ ବାସଙ୍ଗ୍‌କେ, ପେ ଆତ୍‌ଲା ବିଃବକ୍ନେ ଆକେନ୍‌ ଗାଗ୍‌ଡ଼େ ଇଏଁ, ଆନେଂ ମନେ ତ୍ଲାଗ୍‌ସାଃ ଆକେନ୍‌ ଡିଂପା । ");
INSERT INTO gaq_vpl VALUES ("LK22_20","072_22_20","LUK","22","20","20","ଦେତ୍‌ରକମ୍ ମିଡିଗ୍ ବଜିନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଅଙ୍ଗୁର୍ ରସ୍‍ନେ ଗିନାକେ ସାଚେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ଅଙ୍ଗୁର୍ ରସ୍ ଆଦ୍ରିଗ୍‌କେ ଜେ ପର୍‍ମେସର୍‍ ମେଁନେ ରେମୁଆଁଇଂ ଏତେ ମୁଇଙ୍ଗ୍ ତ୍ମିକ୍ନେ ନିଅମ୍ ଡିଙ୍ଗ୍‍ବକେ । ନେଙ୍ଗ୍ ଆପେକେ ବିଃଣ୍ଡିଂକ୍ନେ ନେଙ୍ଗ୍ ମ୍ୟାନେ ଆକେନ୍ ତ୍ମି ନିଅମ୍ ଆରାମ୍‍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_21","072_22_21","LUK","22","21","21","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ପେଇଂ ବିତ୍ରେ ମୁଇଂଜା ନେଙ୍ଗ୍ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍‌ ଗାତ୍‍ ଡିଙ୍ଗ୍‌ଏ । ମେଁନେ ନ୍ତି ନେଙ୍ଗ୍ ନ୍ତି ଡାଗ୍‍ରା ଆକେନ୍ ଟିବୁଲ୍ ଆଡ଼ାତ୍ରା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_22","072_22_22","LUK","22","22","22","ପର୍‍ମେସର୍‍ ଡିରକମ୍ ଆଃରେ ବକେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଦେତ୍‌ରକମ୍ ଡିଙ୍ଗ୍‌ଚେ ଗୁଏଃଏ । ମାତର୍‌ ରେମୁଆଁ ଉଂଡେକେ ମୁଡ଼ି ରେମୁଆଁ କୁରୁସ୍‍ ନ୍ନିଆ ଗୁଏନ୍‌ସା ବିରଦ୍‌ ରେମୁଆଁଇଂନେ ନ୍ତିନିଆ ବିଃଏ ଆତେନ୍‌ ରେମୁଆଁ ଜାବର୍‌ ଡଣ୍ଡ୍‍ ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_23","072_22_23","LUK","22","23","23","ତେନ୍‌ ଇଡ଼ିଂ ସିସ୍‌ଇଂ ମେଇଂମେଇଂ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ଆର୍‌କେ “ନେ ବିତ୍‍ରେ ଜାଣ୍ଡେ ଜିସୁ ଆଡ଼ାତ୍ରା ଦେକ୍‌ରକମ୍ ବେବ‍ଆର୍ ଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK22_24","072_22_24","LUK","22","24","24","ମେଇଙ୍ଗ୍‌ନେ ବିତ୍ରେବାନ୍ ସାପାବାନ୍ ଜାଣ୍ଡେ ମ୍ନା ସିସ୍ଇଂ ଆତେନ୍‌ ବିସୟ୍‌ରେ ମେଇଂନେ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ନେ ଲାଗେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_25","072_22_25","LUK","22","25","25","ଆତ୍‌ବାନ୍ ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, ଅବିସ୍‌ବାସି ରେମୁଆଁଇଂନେ ଇଃସାଙ୍ଗ୍‌ଇଂ ନିଜେନେ ରେମୁଆଁ ଆଡ଼ାତ୍ରା‍ ସାସନ୍‍ ଡିଙ୍ଗ୍‌ଏ ଆରି ଜାଣ୍ଡେ ମେଁଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ସାସନ୍‍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ମେଇଂ ଦେସ୍‌ନେ କୁଟୁମ୍‍ ଡାଗ୍‌ଚେ ଦାବି ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK22_26","072_22_26","LUK","22","26","26","ମାତର୍‌ ପେଇଂ ଦେତ୍‌ରକମ୍ ଆଡିଙ୍ଗ୍‌ପା ମାତର୍‌ ପେଇଂ ବାନ୍ ଜାଣ୍ଡେ ମ୍ନା ମେଁ ଡାଆଁ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଲେ । ଆରି ଜାଣ୍ଡେ ନେତା ମେଁ ସେବା ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_27","072_22_27","LUK","22","27","27","ସାପାବାନ୍‍ ମ୍ନା ରେମୁଆଁ ଜାଣ୍ଡେ ? ଟିବୁଲ୍ ନ୍ନିଆ ଚଙ୍ଗ୍‌ନ୍‌ସା କଲେଃକ୍ନେ ରେମୁଆଁ ଆମେକେ ସେବା ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ରେମୁଆଁ ଚଙ୍ଗ୍‌ନେ କଲେଃକ୍ନେ ରେମୁଆଁ ସାପାବାନ୍‍ ମ୍ନା । ମାତର୍‌ ପେଇଂବାନ୍ ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ସେବା ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ସୁଗୁଆ ନ୍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_28","072_22_28","LUK","22","28","28","ମାତର୍‌ ପେଇଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ସାପା ପରିକ୍ୟାନ୍ନିଆ ନେଙ୍ଗ୍ ଏତେ ଲେଃଚେ ପାଙ୍ଗ୍ ପେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_29","072_22_29","LUK","22","29","29","ନେଙ୍ଗ୍‌ନେ ଆବା ଆନେଙ୍ଗ୍‌କେ ଡିରକମ୍ ସାସନ୍‍ ଡିଙ୍ଗ୍‍ନେ ଅଦିକାର୍ ବିବକେ ଦେତ୍‌ସୁଗୁଆ ନେଙ୍ଗ୍ ଡିଗ୍ ସାସନ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଆପେକେ ଅଦିକାର୍ ମ୍ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK22_30","072_22_30","LUK","22","30","30","ଡିରକମ୍ ପେଇଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ରାଇଜ୍ ନ୍ନିଆ ନେଙ୍ଗ୍ ଟିବୁଲ୍ ଆଡ଼ାତ୍ରା ପେଇଂ ପେଚଙ୍ଗ୍‍ ଉଗ୍‌ଏ । ପେଇଂ ସିଂଆସନ ଆଡ଼ାତ୍ରା କଚେ ଇଶ୍ରାୟେଲନେ ଗମ୍ୱାର୍ ଜାକ କୁଲ୍‍କେ ବିଚାର୍ ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK22_31","072_22_31","LUK","22","31","31","“ଶିମୋନ୍‍ ! ଅ ଶିମୋନ୍‍ ସ୍ଲେରେଇଂ ମେଁଇଙ୍ଗ୍‌ନେ ଗହମ୍‍ବାନ୍‍ ଗୁଡ଼ି‍ଇଂକେ ବିନେ ଆଡିଙ୍ଗ୍‍ସା ଗ୍ନେଞ୍ଜାନିଆ ଡିରକମ୍ ଗେଞ୍ଜାଏ ଦେତ୍‌ରକମ୍ ସୟତାନ୍‍ ଡିଗ୍ ଆପେକେ ତେରେପେତେ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବାସା ମ୍ୟାଃଲେକେ ! ");
INSERT INTO gaq_vpl VALUES ("LK22_32","072_22_32","LUK","22","32","32","ନେଙ୍ଗ୍ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଜେ ପେନେ ବିସ୍‌ବାସ୍‍ ଜେନ୍ତିକି ଆଆନ୍ତାର୍‌ଗେପା ନାମଃ । ପେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ନେ ବେଲା ପେନେ ବୟାଁଇଂକେ ବିସ୍‌ବାସ୍‌ରେ ଡାଟ୍ ଲେନ୍‍ସା ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_33","072_22_33","LUK","22","33","33","ମାତର୍‌ ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ନେଙ୍ଗ୍ ନାନେ ଏତେ ଜେଲ୍‍କାନା ଗିଗାନ୍‌ସା ଆର୍ମେ ନ୍ଲେକେ । ଦେକ୍‍ରକମ୍‍କି ନେଙ୍ଗ୍ ନାନେ ଏତେ ଗୁଏନ୍‌ସା ଡିଗ୍ ଆର୍ମେ ନ୍ଲେ କିକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_34","072_22_34","LUK","22","34","34","ତେଲା ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ପିତର୍ ଏ ମିଡିଗ୍ ଗିସେଙ୍ଗ୍‍ ସନେ ସେନୁଗ୍ ନାନେ ଆନେଙ୍ଗ୍ ନ୍ନାମ୍ୟାକେ ଡାଗ୍‌ଚେ ଞ୍ଜିତର୍ ନାବାଃଲିର୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_35","072_22_35","LUK","22","35","35","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍‌ଇଂକେ ବାଲିର୍‍କେ, “ନେଙ୍ଗ୍ ଆପେକେ ଡାବୁ, ମୁନା ଆରି ଜୁତା ମାବିଚେ ବେମ୍ଵଗେ । ପେଇଂନେ ମେଃଡିଗ୍ ଅବାବ୍ ଲେଃଗେ ଲେଃ ?” ସିସ୍‌ଇଂ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_36","072_22_36","LUK","22","36","36","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ମାତର୍‌ ଏବେ ଜଦି ପେଇଂନ୍ନିଆ ଡାବୁ କି ମୁନା ଲେଃଏ ତେଲା ଆତେନ୍‌ ପେଇଂ ଏତେ ଡୁଂୱେଲାପା । ଦେତ୍‌ରକମ୍ ଜଲି ଡିଗ୍ ଡୁଂୱେଲାପା ଜାନେ କାଣ୍ଡା ଣ୍ଡୁ ମେଁ ନିଜେନେ ସାଲ୍‍ ସଚେ କାଣ୍ଡା ବିଆର୍‍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_37","072_22_37","LUK","22","37","37","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ ସାସ୍ତର୍‌ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ” ଜେ “ମେଁ ଅପରାଦି ରେମୁଆଁଇଂ ଏତେ ଡଣ୍ଡ୍‍ ବଗ୍ ଡିଙ୍ଗ୍‌କେ । ଏନ୍‌ ସାସ୍ତର୍‌ନେ ବ୍ନାଲିର୍ ସତେଆ ଗଟେଏ ଆକେନ୍ ନେଙ୍ଗ୍ ବିସୟ୍‌ରେ ଗୁଆର୍‍ ବଗେ ଆରି ଏନ୍‌ ଏବେ ଗଟେ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_38","072_22_38","LUK","22","38","38","ସିସ୍‌‍ଇଂ ବାସଙ୍ଗ୍‌କେ କେଲା ମାପ୍ରୁ ଆକ୍‌ଅରିଆ ମ୍ବାକ୍ଲିଗ୍ କାଣ୍ଡା ଲେଃକେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ମ୍ୱାକ୍ଲିଗ୍ କାଣ୍ଡା ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_39","072_22_39","LUK","22","39","39","ଜିସୁ ଯିରୁଶାଲାମ୍ ମ୍ନାଇନି ବାନ୍ ତାର୍‌ଚେ ନିଜର୍ ନିଅମ୍‌ରେ ଜିତକଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେକେ । ଆରି ସିସ୍ଇଂ ଡିଗ୍ ମେଁନେ ପ୍ଲା ୱେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_40","072_22_40","LUK","22","40","40","ଆତ୍‌ଅରିଆ ପାଙ୍ଗ୍‌ଚେ ଜିସୁ ସିସ୍‌‍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ପେଇଂ ଜେନ୍ତିକି ପରିକ୍ୟାନ୍ନିଆ ପେଲଃ ଆତେନ୍‌‌ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_41","072_22_41","LUK","22","41","41","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମେଇଂନେବାନ୍‍ ଉଲୁପ୍‍ ସ୍ଲ ୱେଗେ । ମେଁ ଡେଙ୍ଗଚେ କଚେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK22_42","072_22_42","LUK","22","42","42","ଏ ମ୍ନାଃ ଆବା ଜଦି ଡିଙ୍ଗ୍‌ଏ ତେଲା ନାନେ ଇକ୍‌ଚା ତେଲା ଦୁକ୍ ସୁକ୍‍ ବେଲା ଏନ୍ ଉଗ୍‌ଡିଆଃ ମୁତା ନେଙ୍ଗ୍‍ବାନ୍‍ ସ୍ଲ ଆଡିଙ୍ଗ୍ । ନେଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଣ୍ଡୁ ମାତର୍‌ ନାନେ ଇକ୍‌ଚା ପୁରନ୍‌ ଡିଙ୍ଗ୍‌ଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_43","072_22_43","LUK","22","43","43","ଇଡ଼ିଙ୍ଗ୍ କିତଂବାନ୍ ମୁଇଙ୍ଗ୍ ଦୁତ୍ ଜାର୍‌ଚେ ଦର୍ସନ୍ ବିକେ । ଆତେନ୍‌ କିତଂ ଦୁତ୍ ଜିସୁକେ ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବେ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_44","072_22_44","LUK","22","44","44","ଜିସୁ ଜାବର୍‌ ଦୁକ୍‍ରେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ନେ ମୁଲେକେ ମେଁନେ ସାର୍ମୁଆଁବାନ୍ ମିଆଁ ଟୁପା ସୁଗୁଆ ସଲେ ତାର୍‌ଚେ ତୁବନ୍ନିଆ ଲଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_45","072_22_45","LUK","22","45","45","ଜିସୁ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ଆଃଡାଚେ ସିସ୍ଇଂ ଡାଗ୍‍ରା ଆଣ୍ଡେ ୱେକେ । ଆତେନ୍‌ ବେଲା ମେଇଂ ସାପାରେ ଡୁଲେଗ୍‍ ୱେଲେଃଆର୍‌ଗେ ମେଁନେ ଦୁକ୍ ସିସ୍ଇଂକେ ଜାବର୍‌ ଆଲିଆ ଆଡିଙ୍ଗ୍‍ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_46","072_22_46","LUK","22","46","46","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ମେଁନ୍‌ସା ଡୁଲେଗ୍‍ ପେଲେକେ ? ତଡ଼ିଆ ଆରି ପରିକ୍ୟାନ୍ନିଆ ଡିରକମ୍ କି ପେଲଃ ଆତେନ୍‌‌ସା ଉର୍‍ଲେଚେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_47","072_22_47","LUK","22","47","47","ମେଁ ସାମୁଆଁ ବାଲିର୍‍ନେ ବେଲା କେଲା ମୁଇଙ୍ଗ୍ ମାନ୍ଦା ରେମୁଆଁ ଆତ୍‍ନିୟା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ଗମ୍ବାର୍‌କ୍ଲିଗ୍ ସିସ୍‌‍ଇଂବାନ୍ ଜିଉଦା ମ୍ନିନେ ମୁଇଙ୍ଗ୍ ସିସ୍‍ ମେଁଇଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ବୈନ୍ତା ନ୍‍ସା ମେଁନେ ଡାଗ୍ରା ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_48","072_22_48","LUK","22","48","48","ତେସା ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଏ ଜିଉଦା ବୈନ୍ତାଚେ ନାଁ କି ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ବିରଦ୍‌ ରେମୁଆଁଇଂନେ ନ୍ତିନିଆ ଆସା ବନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK22_49","072_22_49","LUK","22","49","49","ଜିସୁନେ ସିସ୍‌‍ଇଂ ଆତ୍‌ଅରିଆ ତୁଆଁ ଲେଃଆର୍‌ଗେ । ମେଃନେ ଗଟେ ଡିଙ୍ଗ୍‌କେ ମେଇଂ ଆତେନ୍‌ ସାପା କିକେ ଲେଃଆର୍‌ଗେ ମେଇଂ ଜିସୁକେ ବାଲିର୍‍କେ “ମାପ୍ରୁ ନେ ମେଃନେ କାଣ୍ଡା ନେରାତାର୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("LK22_50","072_22_50","LUK","22","50","50","ତେସା ମୁଇଙ୍ଗ୍ ସିସ୍‍ କାଣ୍ଡା ଆଃତାର୍‌ଚେ ମ୍ନା ପୁଜାରିନେ ଚାକର୍‌କେ ଞ୍ଚଙ୍ଗ୍‍ତି ପାକାନେ ନ୍ଲୁଗ୍‌କେ ସିତଗ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_51","072_22_51","LUK","22","51","51","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଜାବର୍‌ ଡିଙ୍ଗ୍‌ଗେ !” ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆତେନ୍‌ ଗତିରେନେ ନ୍ଲୁଗ୍‍କେ ଲିଗ୍‌ଚେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_52","072_22_52","LUK","22","52","52","ତେଲା ଜିସୁ ମେଁନେ ବିରଦ୍‌ରେ ପାଙ୍ଗ୍ ଲେଃକ୍ନେ ମ୍ନା ପୁଜାରି ମନ୍ଦିର୍‌ନେ ସେନାପତି ଆରି ମ୍ନାଃ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଡଙ୍ଗାରେକେ ସାଃନେ ସୁଗୁଆ କାଣ୍ଡା ଆରି ଟେଙ୍ଗ୍ ସାଃଚେ ପେଇଂ ମେଃନ୍‌ସା ଆନେଙ୍ଗ୍‌କେ ସାଃନ୍‌ସା ପାଙ୍ଗ୍ ପେଲେକେ ? ");
INSERT INTO gaq_vpl VALUES ("LK22_53","072_22_53","LUK","22","53","53","ନେଙ୍ଗ୍ କାଲାଆଃ ପେଇଂ ଏତେ ମନ୍ଦିର୍‌ନ୍ନିଆ ନ୍ଲେଗେ ମାତର୍‌ ପେଇଂ ଅଃତେନ୍‍ ବେଲା ଆନେଙ୍ଗ୍‌କେ ପେସାକେ ଣ୍ଡୁ ଏକ୍ରେ ପେଇଂନେ ବେଲା ପାଙ୍ଗ୍ ଲେଃକେ ଡାଗ୍ଲା ଏକ୍ରେ ତାଂକିଗ୍‌ନେ ବେଲା ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_54","072_22_54","LUK","22","54","54","ମେଇଙ୍ଗ୍ ଜିସୁକେ ବନ୍ଦି ଆଡିଙ୍ଗ୍‌ଚେ ମ୍ନା ପୁଜାରିନେ ଡୁଆ ବିତ୍ରେ ଡୁଂୱେ ଆର୍‌କେ । ପିତର୍ ଇକୁଡ଼ା ସ୍ଲଲେଚେ ମେଁଇଙ୍ଗ୍‌ନେ ପ୍ଲା ୱେଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_55","072_22_55","LUK","22","55","55","ମେଇଂ ବାଜାର୍‌ନ୍ନିଆ ମଜେ ସୁଆ ଆଃଡୁଆଚେ ମୁଇଂତୁଗ୍ କ ଆର୍‌କେ । ପିତର୍‍ ଡିଗ୍ ମେଁ ଏତେ କକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_56","072_22_56","LUK","22","56","56","ମୁଇଙ୍ଗ୍ ଚାକର୍‌ବ‍ଏଃ ପିତର୍‌କେ ଆତ୍‌ଅରିଆ କଲେଃକ୍ନେ କେକେ । ଚାକର୍‌ବ‍ଏଃ ମୁଇଙ୍ଗ୍ ମନ୍‍ ଦିଆନ୍ ବିଚେ ପିତର୍‌ନେ ସାର୍ମୁଆଁନ୍ନିଆ କେକେ । ଇଡ଼ିଙ୍ଗ୍ ମେଁ ବାସଙ୍ଗ୍‌କେ “ଏନ୍‌ ରେମୁଆଁ ଡିଗ୍‍ ମେଇଂ ଏତେ ଲେଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_57","072_22_57","LUK","22","57","57","ମାତର୍‌ ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ ନେଙ୍ଗ୍ ଆମେକେ ନ୍ନାମ୍ୟାକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_58","072_22_58","LUK","22","58","58","ଇତୁଡ଼ା ବେଲା ଇଡ଼ିଙ୍ଗ୍ ଆରି ମୁଇଂଜା ପିତର୍‌କେ କେଚେ ବାସଙ୍ଗ୍‌କେ “ଜିସୁନେ ପ୍ଲା ୱେଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂବାନ୍‍ ନାଡିଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ମୁଇଂଜା ।” ମାତର୍‌ ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ ନେଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_59","072_22_59","LUK","22","59","59","ଇଡ଼ିଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ଗଣ୍ଟା ଇଡ଼ିଂ ଆର୍‌ଏ ମୁଇଂଜା ରେମୁଆଁ ଡାଟାମ୍ ବାବ୍‍ରେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ସତ୍ । ଏନ୍‌ ରେମୁଆଁ ସତେଆ ମେଇଂ ଏତେ ଲେଃଗେ । ଡାଗ୍‍ଲା ମେଁ ତ ଗାଲିଲୀୟ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_60","072_22_60","LUK","22","60","60","ମାତର୍‌ ପିତର୍ ବାସଙ୍ଗ୍‌କେ “ପେ ମେଁନେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ମେଃଡିଗ୍‌ ବୁଜେ ନାୟା ଣ୍ଡୁ ।” ସମାନ୍‌ ଆତେନ୍‌ ବେଲା ଗିସେଙ୍ଗ୍ ସକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_61","072_22_61","LUK","22","61","61","ମାପ୍ରୁ ପ୍ଲେଗ୍‌ଚେ ମୁଇଙ୍ଗ୍ ଲୟରେ କେକେ ବାରି ପିତରକେ ମେଁନେ ବାସଙ୍ଗ୍‌ବକେ, ଆତାନ୍‌ ପିତ୍‌ରକେ ମେଁନେ ପଡ଼େକେ । “ଏ ମିଡିଗ୍‌ ଗିସେଙ୍ଗ୍‌ ସନେ ସେନୁଗ୍‌ ନା ଆନେଙ୍ଗ୍‌ ଞ୍ଜି ତର୍ ନ୍ନାମ୍ୟାକେ ଡାଗ୍‌ଚେ ନାବାସଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_62","072_22_62","LUK","22","62","62","ପିତର ବାଏରେ ୱେଚେ କାକୁର୍‌ତି ଡିଙ୍ଗ୍‌ଚେ ଅଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_63","072_22_63","LUK","22","63","63","ଉଡ଼ିରୁଆ ଜିସୁକେ ଉର୍‍ ଲେଃଆର୍‌ଗେ । ମେଇଂ ଜିସୁକେ ବଗ୍ ବଗ୍‍ଚେ ପରିହାସ୍‍ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_64","072_22_64","LUK","22","64","64","ବାରି ମେଁନେ ସାର୍ମୁଆଁନ୍ନିଆ ଡାଚେ ଆମେକେ ସାଲିଆକୁ ଆର୍‌କେ । ନା ଡିଏଃ ବାବବାଦି ବକ୍ତା ବାସଙ୍ଗ୍‌ କେଲା ଜାଣ୍ତେ ଆନାକେ ବଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("LK22_65","072_22_65","LUK","22","65","65","ଆରି ମେଇଂ ଗୁଲୁଏ ସାମୁଆଁ ମେଁନେ ବିରଦ୍‌ରେ ବାସଙ୍ଗ୍‌ଚେ ମେଁନେ ନିନ୍ଦା ଆଡିଙ୍ଗ୍‌ନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK22_66","072_22_66","LUK","22","66","66","ଆର୍‌ଏ ମୁଇଂଦିନା ଞ୍ଜିର୍ ଦର୍ମ ନେତା ଜିଉଦି ନେତାଇଂ ମ୍ନା ପୁଜାରି‍ଇଂ ଆରି ଦରମ୍ ଗୁରୁଇଂ ମୁଇଂତୁଗ୍ ରିସିଙ୍ଗ୍‍ ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ମେଁଇଙ୍ଗ୍‌ନେ ସାପାବାନ୍ ମ୍ନା ସବା ଅରିଆ ଡୁଂୱେ ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍ ଆର୍‌କେ “ନାନେ ଜଦି କିସ୍‌ଟ ତେଲା ଆନେ ସାପାରେକେ ବାସଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_67","072_22_67","LUK","22","67","67","ମେଇଂ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ଆନେକେ ବାସଙ୍ଗ୍ ନାଁ ମେଃନେ କିସ୍‌ଟ ?” ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ଜଦି ମ୍ବାସଙ୍ଗ୍‍ଏ ପେଇଂ ଆନେଙ୍ଗ୍‍କେ ବିସ୍‌ବାସ୍‍ ପେଡିଙ୍ଗ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK22_68","072_22_68","LUK","22","68","68","ଆରି ନେଙ୍ଗ୍ ଜଦି ଆପେକେ ପ୍ରସ୍‌ନ ନ୍‌ସାଲ୍ୟାକୁଏ ତେଲା ପେଇଂ ମେଁନେ ଉତର୍ ପେବି ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK22_69","072_22_69","LUK","22","69","69","ଏଃକେବାନ୍ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ପର୍‍ମେସର୍‍ନେ ସିଂଆସନନେ ଞ୍ଚଙ୍ଗ୍‍ତି ପାକା କ‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_70","072_22_70","LUK","22","70","70","ମେଇଂ ସାପାରେ ବାସଙ୍ଗ୍‌କେ “ତେଲା ମେଁନେ ପେ ପର୍‍ମେସର୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ?” ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେ ମେଁନେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ଆତେନ୍‌‌ଆ ।” ");
INSERT INTO gaq_vpl VALUES ("LK22_71","072_22_71","LUK","22","71","71","ମେଇଂ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ତେଲା ନେଁନେ ଏବେ ସାକି ମେଁନେ ଦର୍‌କାର୍ ? ନେନେ ତ ନିଜେ ମେଁନେ ସାର୍ମୁଆଃବାନ୍‍ ଆକେନ୍ ନେଅଁକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_1","072_23_1","LUK","23","1","1","ଇଡ଼ିଙ୍ଗ୍ କୁକପାର୍‌ନେ ସାପାରେ ତଡ଼ିଆଚେ ତୁଆଁଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଜିସୁକେ ପିଲାତ ଡାଗ୍‍ରା ଡୁଂୱେଆର୍‍କେ ");
INSERT INTO gaq_vpl VALUES ("LK23_2","072_23_2","LUK","23","2","2","ମେଇଂ ଜିସୁକେ ଦସ୍ ବିଃନେ ଲାଗେକେ । ମେଇଂ ପିଲାତକେ ବାସଙ୍ଗ୍‌କେ “ନେନେ ରେମୁଆଁଇଂକେ ରାଇଜ୍ ବିରଦ୍‌ରେ ବାସଙ୍ଗ୍‌ନେ ବେଲା ନେ ଆକ୍‌ମେକେ ସାଃନେବକେ । ମେଁ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଜେ କାଇସର୍‍କେ ସିସ୍ତୁ ବିଃନ୍‍ସା ଦର୍‌କାର୍ ଣ୍ଡୁ । ମେଁ ନିଜ୍‍କେ କିସ୍‌ଟ ଆରି ଇଃସାଙ୍ଗ୍‌ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_3","072_23_3","LUK","23","3","3","ପିଲାତ ଜିସୁକେ ସାଲ୍ୟାକୁକେ “ନାନେ ମେଁନେ ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ?” ଜିସୁ ଉତର୍ ବିକେ “ନାନେ ତ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_4","072_23_4","LUK","23","4","4","ପିଲାତ ମ୍ନା ପୁଜାରି ଆରି ରେମୁଆଁଇଂକେ ବାଲିର୍‍କେ “ଏନ୍‌ ରେମୁଆଁନେ ନେଙ୍ଗ୍ ମେଃଡିଗ୍ ଦସ୍ ନାକେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_5","072_23_5","LUK","23","5","5","ମେଇଂ ମାତର୍‌ ପ୍ରେଗ୍‍ପ୍ରେଗ୍‍ ବାଲିର୍‍କେ “ମେଁନେ ଗିଆନ୍‍ ବାନ୍ ମେଁ ଜିଉଦାନେ ଅଁପାକା ମେଁ ରେମୁଆଁଇଂକେ ଆୱିଗ୍‌ଡିଙ୍ଗ୍‌କେ । ସାମୁଆଁ ବିଡିଙ୍ଗ୍‌କେ । ମେଁ ଆକେନ୍ ଗାଲିଲୀନ୍ନିଆ ପାକା ମୁଲେ ବକେ । ଏବେ ମେଁ ଆକ୍‍ଅରିଆ ପାଙ୍ଗ୍ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_6","072_23_6","LUK","23","6","6","ପିଲାତ ଏନ୍‌ ଅଁଚେ ସାଲ୍ୟାକୁକେ ଏନ୍‌ ରେମୁଆଁ ମେଁନେ ଗାଲିଲୀନେ ? ");
INSERT INTO gaq_vpl VALUES ("LK23_7","072_23_7","LUK","23","7","7","ପିଲାତ ମ୍ୟାକେ ଜେ ଜିସୁ ହେରୋଦନେ ଅଦିକାର୍ ଜାଗାନେ ରେମୁଆଁ । ତେସା ପିଲାତ ଜିସୁକେ ମେଁନେ ଡାଗ୍‍ରା ବେବିକେ । ହେରୋଦ ଡିଗ୍‌ ଆତେନ୍‌ ବେଲା ଜିରୁସାଲାମ୍‌ନ୍ନିଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_8","072_23_8","LUK","23","8","8","ହେରୋଦ ଜିସୁକେ କେଚେ ଜବର୍ ସାର୍ଦା ଡିଙ୍ଗ୍‌କେ । ହେରୋଦ ଜିସୁନେ ବିସୟ୍‌ରେ ସାପା ସାମୁଆଁ ଅଁ ଆଡା ବଗେ । ଅସେବାନ୍ ଜିସୁକେ କେନ୍‍ସା ମେଁ ଇକ୍‌ଚା ଡିଙ୍ଗ୍ ଲେଃଗେ । ହେରୋଦ ଜିସୁନେ ମୁଇଙ୍ଗ୍ କାବା ସୁଗୁଆ କାମ୍ ମୁଆଃ କିକେନେ ଚାଏଁ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_9","072_23_9","LUK","23","9","9","ହେରୋଦ ଜିସୁକେ ଗୁଲେ ପ୍ରସ୍‍ନ ସାଲ୍ୟାକୁକେ । ମାତର୍‌ ଜିସୁ ଆମେଇଂକେ ମେଃଡିଗ୍ ଉତର୍ ଆବିକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK23_10","072_23_10","LUK","23","10","10","ବାରି ମ୍ନା ପୁଜାରି ବାରି ଦରମ୍ ଗୁରୁଇଂ ସେନୁଗ୍‍ ପାଙ୍ଗ୍‌ଚେ ଜିସୁନେ ବିରଦ୍‌ରେ ଗୁଲୁଏ ସାମୁଆଁରେ ନିନ୍ଦା ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_11","072_23_11","LUK","23","11","11","ତେନ୍‌ ଇଡ଼ିଂ ହେରୋଦ ଆରି ମେଁଇଙ୍ଗ୍‌ନେ ସନ୍ୟଇଂ ଜିସୁକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌କେ । ଆମେକେ ଇଃସାଙ୍ଗ୍‌ନେ ସକା ଆସ ଆର୍‌କେ ମେଇଙ୍ଗ୍ ଜିସୁକେ ଆଗିଆସ ଆର୍‌କେ । ତେନ୍‌ ଇଡ଼ିଂ ହେରୋଦ ପିଲାତ ଡାଗ୍‍ରା ଜିସୁକେ ବେବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_12","072_23_12","LUK","23","12","12","ଅସେବାନ୍ ପିଲାତ ଆରି ହେରୋଦ ଏତେ ପୁରାପୁରି ସତ୍ରୁ ଲାଗେ ଲେଃଗେ ମାତ୍‍ରମ୍‍ ଆତେନ୍‌ ଦିନ୍‍ବାନ୍‍ ମେଁ ମ୍ୱାୟା ସାଙ୍ଗ ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_13","072_23_13","LUK","23","13","13","ପିଲାତ ମ୍ନା ପୁଜାରି ଆରି ଜିଉଦି ନେତାଇଂ ଏତେ ସାପା ରେମୁଆଁକେ ମୁଇଂନୁଗ୍ ୱାଚେ ସେଲିଆକୁକେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_14","072_23_14","LUK","23","14","14","ପିଲାତ ଆମେଇଂକେ ବାଲିର୍‍କେ “ପେଇଂ ଜିସୁକେ ନେଙ୍ଗ୍‍ଅରିଆ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ପେବକେ । ପେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ଜେ ମେଁ ରେମୁଆଁ ଏତେ ରିଙ୍ଗ୍‍ୟା ଡିଙ୍ଗ୍‌କେ । ମାତ୍‍ରମ୍‍ ନେଙ୍ଗ୍ ପେନେ ସାପା ରେମୁଆଁ ତୁଆଁଲେଃକ୍ନେ ଡାଗ୍‍ରା ଆମେକେ ପ୍ରସ୍‌ନ ମ୍ପଚାରେକେ । ମେଁନ୍ନିଆ ମେଃଡିଗ୍ ଦସ୍ ନେବାକେ । ପେଇଂ ଜା ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ଜିସୁ ଦସି ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK23_15","072_23_15","LUK","23","15","15","ଆମେ ଆନ୍‌ତାର୍‌ଚେ ହେରୋଦ ଡିଗ୍ ମେଁନ୍ନିଆ ମେଃଡିଗ୍ ଦସ୍ ନାବାକେ । ହେରୋଦ ନେନ୍ନିଆ ଜିସୁକେ ବେବକେ । କେଲା ଜିସୁ ମେଃଡିଗ୍‍ ବୁଲ୍‍ କାମ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ତେସା ଆମେକେ ବାଗୁଏଃନେ ଟିକ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK23_16","072_23_16","LUK","23","16","16","ତେସା ଆମେକେ ଡଣ୍ଡ୍‍ ବିଚେ ଆନ୍‌ତାର୍‌ଚେ ୱେନେ ଆଦେସ୍ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_17","072_23_17","LUK","23","17","17","ପାଣ୍ଡୁଏ ବେଲା ମେଇଂ ଆତ୍‍ଲା ମୁଇଂଜା ବନ୍ଦିକେ ଆତାର୍ ବିଃନ୍‍ସା ନିଅମ୍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_18","072_23_18","LUK","23","18","18","ମାତ୍‍ରମ୍‍ ସାପାରେ ଅଃଗିଆଚେ ତଡ଼ିଆ ଆର୍‌କେ “ଆମେକେ ବାଗୁଏ ବିଃ । ବାରବ୍‍ବା କିକେ ଆନ୍‌ତାର୍‌ ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_19","072_23_19","LUK","23","19","19","ବାରବା ମ୍ନାଇନିନିଆ ଗଟେଲେଃକ୍ନେ ମେଃଡିଗ୍ କିରମର ନ୍‍ସା ଆରି ରେମୁଆଁ ବାଗୁଏଃ ବଗେସାଃ ଆମେକେ କ‍ଏଦ୍‌ ଡୁଆନିଆ ଗାଗ୍‌ଚେ ବ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_20","072_23_20","LUK","23","20","20","ପିଲାତ ଜିସୁକେ ଆନ୍‌ତାର୍‌ ବିଃନ୍‍ସା ଚାଏଁଡିଙ୍ଗେ । ତେସା ଆରି ମୁଇଙ୍ଗ୍ ତର୍‍ ଆମେଇଂକେ ବାଲିର୍‍କେ ଜେ ମେଁ ଜିସୁକେ ଆନ୍‌ତାର୍‌ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("LK23_21","072_23_21","LUK","23","21","21","ମାତ୍‍ରମ୍‍ ରେମୁଆଁଇଂ କିରଚେ ବାସଙ୍ଗ୍‌କେ “ଆମେକେ ବାଗୁଏ ବିଃ । ଆମେକେ କୁରୁସ୍‌ନ୍ନିଆ ଆଡେପା କୁରୁସ୍‌ନ୍ନିଆ ଆଡେପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_22","072_23_22","LUK","23","22","22","ଞ୍ଜିତର୍ ନ୍‌ସା ପିଲାତ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ମେଁନ୍‌ସା ମେଁ ମନେ ଦସ୍ କାମ୍ ଡିଙ୍ଗ୍‍ବକେ ? ମେଁ ଦସି ଣ୍ଡୁ । ଆମେକେ ଗୁଏନେ ସାସ୍ତି ବିଃନ୍‍ସା ନେଙ୍ଗ୍ ମେଃଡିଗ୍ ଦସ୍ ବାନାଡିଙ୍ଗ୍‌କେ । ତେସା ନେନେ ଆମେ କିକେ ସାସ୍ତି ବିଚେ ନେଙ୍ଗ୍ ଆମେକେ ଆନ୍‌ତାର୍‌ ମ୍ୱିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_23","072_23_23","LUK","23","23","23","ମାତ୍‍ରମ୍‍ ରେମୁଆଁଇଂ ୱାସାର୍‌ଚେ ବାଲିର୍‍କେ ମୁଲେକେ । ଜେ ଜିସୁକେ କୁରୁସ୍‌ନ୍ନିଆ ଆଡେଚେ ବାଗୁଏ ବିଃପା । ମେଁଇଙ୍ଗ୍‌ନେ ଦାବି ଜିତେ ଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("LK23_24","072_23_24","LUK","23","24","24","ପିଲାତ ରେମୁଆଁଇଂନେ ଇକ୍‌ଚାରେ ଆଦେସ୍‍ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_25","072_23_25","LUK","23","25","25","ରେମୁଆଁଇଂ ବାର୍‍ବାକେ ବନ୍ଦି କ‍ଏଦ୍‌ ଡୁଆବାନ୍ ଆତାର୍‍ନ୍‍ସା ରାଜି ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍ଗେ । ବାର୍‍ବା ରେମୁଆଁ ବାଗୁଏବଗେ ଆରି ୱିଙ୍ଗ୍‌ଆ ରିଙ୍ଗ୍‍ଆ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଲା ଆମେକେ ଦସି ଆଡିଙ୍ଗ୍‍ଚେ କ‍ଏଦ୍‌ ଡୁଆନିଆ ବାଆର୍‌ଗେ । ପିଲାତ ବାର୍‍ବାକେ ଆନ୍ତାର୍‌ବିକେ । ଆରି ପିଲାତ ଜିସୁକେ ବାଗୁଏ ବିଃନ୍‍ସା ରେମୁଆଁଇଂନେ ନ୍ତିନିଆ ଅପେଃ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_26","072_23_26","LUK","23","26","26","ସନ୍ୟଇଙ୍ଗ୍ ଜିସୁକେ ବାଗୁଏଃ ନ୍‌ସା ନ୍‍ସା ଡୁଂୱେଆର୍‍ଗେ । ମେଇଂ ୱେନେ ବେଲା ଇନିବାନ୍ ପାଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ କୁରୁଣୀନେ ଶିମୋନକେ ଅବାଆର୍‌କେ । ମେଇଂ ଆମେକେ ତାୱାଁଚେ ମେଁନେ ଆଡ଼ାତ୍ରା କୁରୁସ୍ ଆଡୁଙ୍ଗ୍‌ ଆର୍‌କେ ବାରି ଜିସୁନେ ପ୍ଲା ୱେନ୍‌ସା ଜବଡ଼୍‌ଜସ୍ତି ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_27","072_23_27","LUK","23","27","27","ଆରି ଜାବର୍‌ ରେମୁଆଁ ଗ୍ରିନିଆ ବଗ୍‌ଚେ ଅଃଡିଙ୍ଗ୍‌କ୍ନେ ସେଲାମ୍ବୁଏ ରେମୁଆଁଇଂ ମେଁନେ ପ୍ଲା ୱେଏ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_28","072_23_28","LUK","23","28","28","ମାତ୍‍ରମ୍‍ ଜିସୁ ପୁଏଚେଃ ଆତେନ୍‌ ସେଲାମ୍ବୁଏଃ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‍କେ “ଏ ଜିରୁସାଲାମ୍‍ନେ ସେଲାମ୍ବୁଏଇଂ ! ନେଙ୍ଗ୍‍ ନ୍‌ସା ଆ‍ଅଃଗେପା । ପେଇଂ ନିଜେ ନ୍‍ସା ଆରି ନିଜେନେ ଗଡ଼େଇଙ୍ଗ୍ ନ୍‌ସା ଅଁପା । ");
INSERT INTO gaq_vpl VALUES ("LK23_29","072_23_29","LUK","23","29","29","ଏବେ ବେଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଉଡ଼ିବେଲା ରେମୁଆଁଇଂ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ସାମୁଆଁ ମୁଡ଼ି ସେଲାମ୍ବୁଏଇଙ୍ଗ୍‌ନେ ଗୋ ଗିସିଆ ଣ୍ଡୁ, ମୁଡ଼ି ସେଲାମ୍ବୁଏଃଇଂ ଆଗାଗ୍‌ଡ଼େ ଆର୍‌କେ, ମେଇଂ ଦନ୍ୟ । ମୁଡ଼ି ସେଲାମ୍ବୁଏଃଇଂନେ ଗୋ ଗିସିଆ ଜନମ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ଆରି ମେଇଂନେ ଜତନ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ମେଇଂ ଦନ୍ୟ । ");
INSERT INTO gaq_vpl VALUES ("LK23_30","072_23_30","LUK","23","30","30","ତେନ୍‌ ଇଡ଼ିଂ ରେମୁଆଁଇଂ କାଣ୍ଡାକେ ବାସଙ୍ଗ୍ଏ ନେନେ ଆଡ଼ାତ୍ରା ରେଃସ ଲଃ ରେମୁଆଁ ଡାଆଁ କାଣ୍ଡାକେ ବାସଙ୍ଗ୍ଏ ଆନେକେ ଡା ବିଃ । ");
INSERT INTO gaq_vpl VALUES ("LK23_31","072_23_31","LUK","23","31","31","ଡାଗ୍ଲା ସ୍ଲା ସୁନ୍ଦର୍‍ ତ୍ନାକ୍ନେ ବେଲା ଜଦି ମୁଇଙ୍ଗ୍ ଦେକ୍‌ରକମ୍ ଗଟେନେ ସାପା ଗଟେଏ ଆତେନ୍‌ ନ୍‍ସୁଆର୍‍ ୱେଲା ମେଁନେ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_32","072_23_32","LUK","23","32","32","ଜିସୁ ଏତେ ଗୁଏଚେ ଡଣ୍ଡ୍‌ ବିଃନ୍‍ସା ଆରି ମ୍ୱାୟା ଡଙ୍ଗାରେକେ ଡିଗ୍ ଡୁଙ୍ଗ୍‍ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_33","072_23_33","LUK","23","33","33","ସାମୁଆଁ କପାଲ ମ୍ନିକ୍ନେ ଜାଗାନ୍ନିଆ ଜିସୁକେ ଆରି ମ୍ୱାୟା ଡଙ୍ଗାରେକେ ଡିଗ୍ ଡୁଂୱେ ଆର୍‌କେ । ଆତ୍‍ନିୟା ସନ୍ୟଇଂ ଜିସୁକେ କୁରୁସ୍‍ ନ୍ନିଆ ବାଗୁଏଃ ଆର୍‌କେ । ମେଇଂ ଆତେନ୍‌ ଡଙ୍ଗାରେ ମ୍ବାୟାବାନ୍ ମୁଇଂଜାକେ ଞ୍ଚଙ୍ଗ୍‍ତି ପାକା ବାରି ମୁଇଂଜାକେ ବେସ୍ୟାଃତି ପାକା ଆଃଡେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_34","072_23_34","LUK","23","34","34","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଏ ମ୍ନାଃ ଆବା ଜାଣ୍ଡେ ରେମୁଆଁଇଂ ଆନେଙ୍ଗ୍ ବାଗୁଏ ଆର୍‌ଏ ଡିଙ୍ଗ୍‌କେ ଆମେଇଂକେ କେମା ଡିଗ୍ । ମାତ୍‍ରମ୍‍ ମେଇଂ ମେଁନେ ଡିଙ୍ଗ୍ଆର୍‌ଡିଙ୍କେ ଆତେନ୍‌ ମେଇଂ ଆମ୍ୟାକେ ଣ୍ଡୁ ।” ସନ୍ୟ‍ଇଙ୍ଗ୍ ଲେଟ୍‍ରିକ୍‍ ତ୍ଲାଗ୍‌ଚେ ଜିସୁନେ ସକା ବାଟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_35","072_23_35","LUK","23","35","35","ରେମୁଆଁଇଂ ଆତ୍‌ଅରିଆ ତଡ଼ିଆଚେ ଜିସୁକେ କେଡିଂଆର୍‌ଗେ । ଜିଉଦି ନେତାଇଙ୍ଗ୍ ଜିସୁକେ ଆଃଗ୍ୟାସ ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂଗେ । ମେଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ “ଜଦି ମେଁ ପର୍‍ମେସର୍‍ନେବାନ୍ ଜାର୍‌ଲେଃକ୍ନେ କିସ୍‌ଟ ତେଲା ମେଁ ନିଜ୍‍କେ ରକ୍ୟା ଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_36","072_23_36","LUK","23","36","36","ସନ୍ୟଇଙ୍ଗ୍ ଜିସୁ ଆଡ଼ାତ୍ରା ଆଃଗ୍ୟାସ ଡିଙ୍ଗ୍ଆର୍‌କେ ଆରି ଆମେକେ ଇଙ୍ଗ୍‌ଚେ ଆର୍‌କେ । ମେଇଂ ଜିସୁ ଡାଗ୍‍ରା ପାଙ୍ଗ୍‌କେ ଆରି ଆମେକେ ବୁଚେଲେକ୍ନେ ରସ୍ ଆଜାଚେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_37","072_23_37","LUK","23","37","37","ସନ୍ୟଇଂ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ନାନେ ଜଦି ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ତେଲା ନାନେ ନିଜେନେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_38","072_23_38","LUK","23","38","38","ମେଁନେ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ଗୁଆର୍‍ ବ ଆର୍‌ଗେ: “ଏ ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_39","072_23_39","LUK","23","39","39","ୱେଡିଂକ୍ନେ ଦସି ମ୍ୱାୟା ବିତ୍ରେ ମୁଇଜା ଜିସୁକେ ନିନ୍ଦା ଆଡିଙ୍ଗ୍‌ଚେ ବାଲିର୍‌ଚେ ଲାଗେକେ “ନାନେ ମେଁନେ କିସ୍‌ଟ ଣ୍ଡୁ ? ତେଲା ନାନେ ନିଜ୍‍କେ ରକ୍ୟା ଡିଙ୍ଗ୍ ଆରି ଆନେକେ ଡିଗ୍ ରକ୍ୟା ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_40","072_23_40","LUK","23","40","40","ମାତ୍‍ରମ୍‍ ବିନ୍ ଦସି ମୁଇଂ ଆମେକେ ୱିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ନାନେ ମେଁନେ ପର୍‍ମେସର୍‍କେ ଡିଗ୍ ନାବୁଟକେ ଣ୍ଡୁ ? ନାଁ ତ ସମାନ୍ ଡଣ୍ଡ୍‍ ବାନାଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_41","072_23_41","LUK","23","41","41","ନାନେ ଆରି ନେଙ୍ଗ୍ ମ୍ୱାୟା ଡଙ୍ଗାରେ । ନେନେ ଦସ୍ ଡିଙ୍ଗ୍ ନେବଗେ । ତେସା ନେନେ ଜା ବାନେ ଡଣ୍ଡ୍‍ ନେନେ ଆତେନ୍‌ ବା ନେଲେକେ । ମାତର୍‌ ଏନ୍‌ ରେମୁଆଁ ତ ମେଃଡିଗ୍ ଦସ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_42","072_23_42","LUK","23","42","42","ତେନ୍‌ ଇଡ଼ିଂ ଆତେନ୍‌ ଦସି ମୁଇଙ୍ଗ୍ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ “ଜିସୁ ନାଁ ଉଡ଼ିବେଲା ଇଃସାଙ୍ଗ୍‌ ବାବ୍‌ରେ ଆଣ୍ତେ ପାଙ୍ଗ୍‌ଲା ଆତେନ୍‌‌ ବେଲା ଆନେଙ୍ଗ୍ ମନେ ନାତ୍ଲାଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_43","072_23_43","LUK","23","43","43","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଅଁପା ନେଙ୍ଗ୍ ମେଁନେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଆତାନ୍ ସତ୍ । ଏଃକୁଆ ପେ ନେଙ୍ଗ୍‌ ଏତେ କିତଂ ଡୁଗ୍‌ଡିନିଆ ନ୍ନିଆ ପେୱେଚାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK23_44","072_23_44","LUK","23","44","44","ଆତେନ୍‌‌ ବେଲା ମୁଣ୍ଡେବେଲା ଡିଙ୍ଗ୍‌ଲେଗେ । ଆରି ସ୍ନି ଆତାର୍‌କିଗ୍‌କେ ଣ୍ତୁ ମାତ୍‍ରମ୍‍ ସ୍ମି ଞ୍ଜି ଗଣ୍ଟା ଜାକ ସାପା ଏରିଆ ତାଂକିଗ୍ ଡିଙ୍ଗ୍‌ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_45","072_23_45","LUK","23","45","45","ଆରି ମନ୍ଦିର୍‌ନେ ପର୍‍ଦା ଆଡ଼ାତ୍ରା ବାନ୍ ବୁନ୍ଦେ ଜାକ ମ୍ୱାର୍‍ବାଗ୍‍ ଡିଙ୍ଗ୍‌ଚେ ସ୍ୟାଃ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_46","072_23_46","LUK","23","46","46","ଜିସୁ କିରଚେ ବାସଙ୍ଗ୍‌କେ “ଅ ମ୍ନାଃ ଆବା ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଆତ୍ମା ଆନାକେ ବିଣ୍ଡିଂକେ । ଏନ୍‌ ବାସଙ୍ଗ୍‌ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଗୁଏ ୱେଗେ !” ");
INSERT INTO gaq_vpl VALUES ("LK23_47","072_23_47","LUK","23","47","47","ସେନା ନେତା ଆତ୍‍ନିୟା ମେଁନେ ଗଟେକେ ଆତେନ୍‌ କେକେ ସିସେ ଏନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ଚେ ପର୍‍ମେସର୍‍କେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‌କେ “ସତେଆ ଏନ୍‌ ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ନିମାଣ୍ଡା ରେମୁଆଁ ଲେଃଗେ !” ");
INSERT INTO gaq_vpl VALUES ("LK23_48","072_23_48","LUK","23","48","48","ଗୁଲେ ରେମୁଆଁ ଆକେନ୍‍ ଗଟ୍‌ନା କେନ୍‍ସା ଦେସ୍‌ବାନ୍ ତାର୍ ପାଙ୍ଗ୍‌ଲେ ଆର୍‌ଗେ । ଆକେନ୍ ସାପା କେଚେ ମେଇଂ ଜାବର୍‌ ଦୁକ୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ ଆରି ଇଡ଼ିଙ୍ଗ୍ ମେଇଙ୍ଗ୍ ଗ୍ରିନିଆ ବଗ୍ ବଗ୍‍ଚେ ଡୁଆ ୱିଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_49","072_23_49","LUK","23","49","49","ଜିସୁନେ ମ୍ୟାଲେକ୍ନେ ରେମୁଆଁଇଂ ଆରି ଆମେକେ ଗାଲିଲୀବାନ୍ ତୁର୍ ପାଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ଗୁଲେ ସେଲାମ୍ବୁଏଇଂ ଆତ୍‌ଅରିଆ ଲେଃଗେ । ମେଇଂ କୁରୁସ୍‌ବାନ୍ ସ୍ଲ ତୁଆଁଚେ ଆକେନ୍ ସାପା କେଆର୍‍ଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_50","072_23_50","LUK","23","50","50","ଜିଉଦିଇଂନେ ଆରାମାତିଆନେ ମ୍ନାଇନିବାନ୍ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଆତ୍‌ଅରିଆ ଲେଃଗେ । ମେଁନେ ମ୍ନି ଯୋସେଫ୍‌ । ମେଁ ଦରମ୍ ଆରି ଜିଉଦି ମ୍ନା ସବାନେ ମୁଇଙ୍ଗ୍ ମ୍ନାଃ ଲେଃଗେ । ମେଁ ପର୍‍ମେସର୍‍ନେ ରାଇଜ୍‍କେ ଉର୍‍ ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_51","072_23_51","LUK","23","51","51","ଯିହୂଦାନେ ଆରମାଥିଆ ମ୍ନିକ୍ନେ ଇନିନେ ଯୋଷେଫ ଡାଗ୍‌ଚେ ମୁଇଂ ରେମୁଆଁ ଲେଃଗେ । ମେଁ ମୁଇଂ ଦରମ୍‌ ଆରି ସନ୍‌ମାନ୍‌ ବ୍‌ବାଣ୍ଡ୍ରେ ଲେଃଗେ ଆରି ଇସ୍‌ପର୍‌ନେ ରାଜ୍ୟ ପାଙ୍ଗ୍‌ନେକେ ଉର୍‌ ଡିଂଗେ । ମ୍ନାଃ କୁକପାର୍‌ନେ ମୁଇଂ ନେତା ଲେଃଲା ଡିଗ୍‌, ମେଁ ମେଇଂନେ ନିସ୍ପତି ଆରି କାମ୍‌ ଏଃତେ ରାଜି ଡିଂ ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK23_52","072_23_52","LUK","23","52","52","ଯୋସେଫ୍‌ ପିଲାତ ଡାଗ୍‍ରା ୱେଚେ ଜିସୁନେ ଗାଗ୍‌ଡ଼େ ସାଲ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_53","072_23_53","LUK","23","53","53","ତେସା ଯୋସେଫ୍‌ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ କୁରୁସ୍ ଆଡ଼ାତ୍ରା ବାନ୍ ବୁନ୍ଦେ ଆଜାର୍‌କେ । ଆତେନ୍‌ ମୁଇଙ୍ଗ୍ ପାଟାଇ ଏତେ ଆକୁଇ ବିଃକେ । ମେଁ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ଡୁଂୱେଚେ କଣ୍ଡାନେ ବ୍ରି ଏତେ ଗଃବକ୍ନେ ଅସେବାନ୍ ବେବ‍ଆର୍ ଆଃଡିଙ୍ଗ୍‌କ୍ନେ ଗୁଡ଼ୁମ୍‌ନିଆ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_54","072_23_54","LUK","23","54","54","ଆତେନ୍‌ ଦିନ୍‌ ସୁକ୍ରା ଦିନ୍‌ ଲେଃଗେ, ପୁଣ୍ଡେନେ ଦିନା ଡାଗ୍ରା ପିଙ୍ଗ୍‍ଚା ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_55","072_23_55","LUK","23","55","55","ମୁଡ଼ି ସେଲାମ୍ବୁଏ ରେମୁଆଁଇଂ ଜିସୁକେ ତୁର୍‍ଚେ ମେଇଂ ଏତେ ଗାଲିଲୀବାନ୍ ପାଙ୍ଗ୍‌ଲେଗେ ମେଇଂ ଯୋସେଫ୍‌ନେ ପ୍ଲାପ୍ଲା ୱେଗେ । ମେଇଂ ୱେଚେ ଗୁଡ଼ୁମ୍‍ କେଆର୍‌କେ । ବିତ୍ରେ ଆଣ୍ଡିନେ ଜାଗାନ୍ନିଆ ଗାଗ୍‌ଡ଼େ ବଆର୍‌କେ ଆତେନ୍‌ ଜାଗା ଡିଗ୍‍ ମେଇଂ କେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK23_56","072_23_56","LUK","23","56","56","ତେନ୍‌ ଇଡ଼ିଂ ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ରେମୁଆଁଇଂ ଜିସୁନେ ଗାଗ୍‌ଡ଼େନ୍ନିଆ ଲାଗେ ବିଃନ୍‍ସା ବାସ୍‌ନାଚୁ ଆର୍ମେ ନ୍‌ସା ଆତ୍‌ବାନ୍ ତାର୍ ୱେଗେ । ଆରି ମେଇଂ ନିୟମ୍‌ ଇସାବ୍‍ରେ ପୁଣ୍ଡେନେ ଦିନା ମେଇଂ ପୁଣ୍ଡେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_1","072_24_1","LUK","24","1","1","ସାନ୍ତାନେ ପର୍‍ତୁମ୍‍ ଦିନ୍ ଞ୍ଜିର୍‌ନୁଗ୍ ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ରେମୁଆଁଇଙ୍ଗ୍ ଆଣ୍ଡିଅରିଆ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ବଆର୍‌ଗେ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ପାଙ୍ଗ୍‌ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ନିଜେ ଆରେ ବକ୍ନେ ବାସ୍‌ନାଚୁ ସାଙ୍ଗେ ଆଃ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ ବଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_2","072_24_2","LUK","24","2","2","ଗୁଡ଼ୁମ୍‌ନିଆ ଡାନେସା ମେଁନେ ଗିଃଗାଃନେ ଗାଲିଅରିଆ ମୁଇଙ୍ଗ୍ ମ୍ନାନେ ବ୍ରି ଡା ବ ଆର୍‌ଗେ । ସେଲାମ୍ବୁଏ ରେମୁଆଁଇଂ କେକେ ଜେ ବ୍ରି ଗୁଣ୍ଡ୍‌ଲେ ୱେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_3","072_24_3","LUK","24","3","3","ତେସା ମେଇଙ୍ଗ୍ ବିତ୍ରେ ୱେକେ । ମାତର୍‌ ମେଇଙ୍ଗ୍ ଆତ୍‌ଅରିଆ ମାପ୍ରୁ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ଆଅବାଆର୍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK24_4","072_24_4","LUK","24","4","4","ସେଲାମ୍ବୁଏଃ ରେମୁଆଁଇଙ୍ଗ୍ ଆକେନ୍ ଗଟ୍‌ନା ବିସୟ୍‌ରେ ମେଃଡିଗ୍ ବୁଜେ ଆୟା ଆର୍‌କେ ଣ୍ଡୁ । ଏନ୍‌ ଗଟ୍‍ନାରେ ମେଇଙ୍ଗ୍ କାବା ଡିଙ୍ଗ୍‌ୱେଲେଃଆର୍‌କ୍ନେ ବେଲା ତାର୍‍କିଗ୍‌କ୍ନେ ସକା ସଚେ ମ୍ୱାୟା କିତଂ ଦୁତ୍‍ ମେଇଂ ଡାଗ୍‍ରା ତୁଆଁକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_5","072_24_5","LUK","24","5","5","ସେଲାମ୍ବୁଏଃ ରେମୁଆଁଇଂ ଜାବର୍‌ ବୁଟ ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ବାଆଃ ଆବ୍ରିଙ୍ଗ୍ ଲେଃଗେ । ଆତେନ୍‌ ମ୍ୱାୟା ଦୁତ୍‍ ଆମେଇଂକେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ପେଇଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ମ୍ବ୍ରଲେଃକ୍ନେ ରେମୁଆଁକେ ଆକ୍‌ଅରିଆ ମେଁନ୍‌ସା ତୁର୍‌ପେଡିଙ୍ଗ୍‌କେ ? ଆକେନ୍ ତ ଗୁଏକ୍ନେ ରେମୁଆଁଇଂନେ ଜାଗା । ");
INSERT INTO gaq_vpl VALUES ("LK24_6","072_24_6","LUK","24","6","6","ଜିସୁ ଆକ୍‌ଅରିଆ ଣ୍ଡୁ ମେଁ ଗୁଏଚେ ଆରି ମୁଇଙ୍ଗ୍ ତର୍‍ ଜିବନ୍ ଡିଙ୍ଗ୍‌ଚେ ତଡ଼ିଆଲେକେ । ମେଁ ଗାଲିଲୀଅରିଆ ଲେଃକ୍ନେ ବେଲା ଆପେକେ ମେଁନେ ବାସଙ୍ଗ୍‌ ବକେ ଆତେନ୍‌ ପେଇଂନେ ମନେ ତ୍ଲାଗ୍ କେଲାପା ? ");
INSERT INTO gaq_vpl VALUES ("LK24_7","072_24_7","LUK","24","7","7","ଜିସୁ ବାସଙ୍ଗ୍‍ବକେ ଜେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ଦଦ୍ୟା ରେମୁଆଁଇଂନେ ନ୍ତିବାନ୍‍ କୁରୁସ୍‌ନ୍ନିଆ ବାଗୁଏଃ ନ୍‍ସା ସତେଆ ଆଃସାଃ ବିଃଆର୍‌ଏ । ମାତର୍‌ ଆରି ଗୁଏଚେ ଜିର୍‌ସି ଦିନା ଇଡ଼ିଙ୍ଗ୍ ମ୍ବ୍ରଚେ ତଃଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("LK24_8","072_24_8","LUK","24","8","8","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ମେଁନେ ବାସଙ୍ଗ୍‌ ବକେ ଆତେନ୍‌ ସାମୁଆଁ ସେଲାମ୍ବୁଏ ରେମୁଆଁଇଂ ଏତେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_9","072_24_9","LUK","24","9","9","ଆତେନ୍‌ ସେଲାମ୍ବୁଏଇଂ ରାଃଚ୍ୟା ଜାଗା ଆନ୍ତାର୍‌ଚେ ଗୋମୁଇଂରୁଆ ସିସ୍‍ ଆରି ସାପାରେ ବିନ୍ ସାପାରେକେ ରାଃଚ୍ୟା ଡାଗ୍ରା ମେଃନେ ଗଟେଲେକେ, ଆତେନ୍‌ ସାପା ମୁଇଂ ମୁଇଙ୍ଗ୍ ଇସାବ୍ ଡିଙ୍ଗ୍‌ଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_10","072_24_10","LUK","24","10","10","ଆତେନ୍‌ ସେଲାମ୍ବୁଏଇଂବାନ୍ ମଗ୍‌ଦଲୀନି ମରିୟମ୍, ଯୋହାନା, ଜାକୁବ୍‌ନେ ଇୟାଙ୍ଗ୍‌ଡେ ମରିୟମ୍ ଆରି ବିନ୍‍ରେ ଲେଃଗେ । ଆକ୍ମେଇଂ ଡାଗ୍‍ରା ୱେକେ । ସିସ୍‌‍ଇଂକେ ସାପା ବିସୟ୍ ଆମ୍ୟା ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_11","072_24_11","LUK","24","11","11","ମାତର୍‌ ବେବକ୍ନେ ସିସ୍‌ଇଂ ବାବେକେ ଜେ ଏନ୍ ସାପା ସେଲାମ୍ବୁଏ ରେମୁଆଁଇଂନେ ମନେ ବାବେକ୍ନେ ସାମୁଆଁ ତେସା ମେଇଂ ଅବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_12","072_24_12","LUK","24","12","12","ମାତର୍‌ ପିତର୍ ତଡ଼ିଆକେ । ଏନ୍‌ ସାମୁଆଁ ସତ୍‍ ଲେଃ ଣ୍ଡୁ ଆତେନ୍‌ କେନ୍‍ସା ମେଁ ଗୁଡ଼ୁମ୍‍ ଡାଗ୍‍ରା ୱିର୍‌ ଡୁଂୱେକେ । ମେଁ ବିତ୍ରେ କେକେ । ମାତର୍‌ ମେଁ କେବଲ୍‍ ଜିସୁ ଆଡ଼ାତ୍ରା ଆଃକୁଇ ବିବକ୍ନେ ସକା ସେକ୍‌ପୁଆଃ ଆତ୍‍ ଅରିଆ କେକେ । ଜିସୁନେ ଗାଗ୍‌ଡ଼େ ଆତ୍‌ଅରିଆ ଆଲେଃକେ । ଜା ଗଟେ ୱେଲେକେ ଆତ୍‌ବାନ୍ ମେଁ କାବା ଡିଙ୍ଗ୍‌ଚେ ନିଜେନେ ଡୁଆ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_13","072_24_13","LUK","24","13","13","ଆତେନ୍‌ ଦିନା ଜିସୁନେ ମ୍ୱାୟା ସିସ୍ ଇମ୍ମାୟୁ ମ୍ନିନେ ଇନି ୱେଡିଙ୍ଗ୍ ଆର୍‌ଗେ । ଏନ୍‌ ଜାଗା ଯିରୁସାଲାମ୍‍ ବାନ୍ ପ୍ରାୟ୍‌ ଗୋମୁଇଂ କିଲମିଟର୍ ସ୍ଲ । ");
INSERT INTO gaq_vpl VALUES ("LK24_14","072_24_14","LUK","24","14","14","ଜା ସାପା ଗଟେଲେଃଗେ ମେଇଂ ଆତେନ୍‌ ବିସୟ୍‌ରେ ବାଲିର୍‌ବାତା ଡିଂଆର୍‍ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_15","072_24_15","LUK","24","15","15","ଆତେନ୍‌ ସାପା ବିସୟ୍ ମେଇଂ ବାଲିର୍ ବାତାକ୍ନେ ବେଲା ନିଜେ ଜିସୁ ମେଁଇଙ୍ଗ୍‌ନେ ଡାଗ୍‍ରା ପାଙ୍ଗ୍‌କେ ଆରି ମେଁ ଏତେ ଅଲେଙ୍ଗ୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_16","072_24_16","LUK","24","16","16","ମାତର୍‌ ଆତେନ୍‌ ମ୍ୱାୟାକେ ଆତେନ୍‌‌ ବେଲା ଜିସୁକେ ମେଁ ସାମୁଆଁ ରକମ୍‍ ଡିଗ୍‍ ସାମୁଆଃ ଆୟା ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("LK24_17","072_24_17","LUK","24","17","17","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁକେ ସାଲ୍ୟାକୁକେ “ପେଇଙ୍ଗ୍ ୱେନେ ବେଲା ଜା ବିସୟ୍‌ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ?” ମ୍ୱାୟା ଜାକ ଅଟ୍‌କେ ୱେ ଆର୍‌ଗେ । ମେଁଇଙ୍ଗ୍‌ନେ ସାର୍ମୁଆଁ ଜାବର୍‌ ଦୁକ୍ ତ୍ନାଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_18","072_24_18","LUK","24","18","18","ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ କ୍ଲିୟପା ମ୍ନିକ୍ନେ ରେମୁଆଁ ମୁଇଙ୍ଗ୍ ଉତର୍ ବିକେ, “ପେ ଯିରୁଶାଲାମ୍‍ ନ୍ନିଆ ଲେଃମ୍ୟାକ୍ନେ ମୁଇଙ୍ଗ୍ ମାତର୍‌ ରେମୁଆଁ ଜାଣ୍ଡେ କି ଜିର୍‌ସି ଦିନା ବିତ୍ରେ ଗଟେ ୱେଲେଃକ୍ନେ ଗଟ୍‍ନାଇଂ ବିସୟ୍‌ରେ ମେଃଡିଗ୍ ଆମ୍ୟାକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK24_19","072_24_19","LUK","24","19","19","ଜିସୁ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ “ପେଇଙ୍ଗ୍ ଆଣ୍ଡିନେ ଗଟ୍‌ନା ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ ?” ରେମୁଆଁଇଙ୍ଗ୍ ଜିସୁକେ ବାଲିର୍‍କେ “ନାଜରିତୀୟ ଜିସୁନେ ବିସୟ୍‌ରେ । ମେଁ ପର୍‍ମେସର୍‍ ଆରି ରେମୁଆଁଇଂ ନ୍‍ସା ମୁଇଙ୍ଗ୍ ମ୍ନାନେ ବାବବାଦି ଲେଃଗେ । ମେଁ ଗୁଲୁଏନେ ବପୁ କାମ୍ ଡିଙ୍ଗ୍ ବଗେ ଆରି ବାସଙ୍ଗ୍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_20","072_24_20","LUK","24","20","20","ମାତର୍‌ ନେଁନେ ମ୍ନାନେ ପୁଜାରି ଆରି ସାସନ୍‍ ଡିଂଣ୍ଡ୍ରେ ଆମେକେ ଗୁଏନେ ଡଣ୍ଡ୍‍ ବିନ୍‍ସା ସର୍‍ପେ ବିଆର୍‌ଗେ ଆରି ଆମେକେ କୁରୁସ୍‌ନ୍ନିଆ ବାଗୁଏ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_21","072_24_21","LUK","24","21","21","ମେଁ ଜାଣ୍ଡେ ଇଶ୍ରାୟେଲକେ ଆନ୍‌ତାର୍‌ ବିଏ ଡାଗ୍‌ଚେ ନେଇଙ୍ଗ୍ ଆସା ଡିଙ୍ଗ୍‍ନେବଗେ । ମାତର୍‌ ଆତେନ୍‌‌ ବେଲା ଆକେନ୍ ସାପା ଗଟ୍‌ନା ଗଟେ ୱେଗେ । ଆକେନ୍ ସାପା ଆନ୍‌ତାର୍‌ଚେ ଏବେ ଜିସୁକେ ବାଗୁଏଚେ ଜିର୍‌ସି ଦିନ୍ ବିତେ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_22","072_24_22","LUK","24","22","22","ମାତର୍‌ ଏଃକେ ନେନେ ଦଲ୍‍ନେ ଉଡ଼ିରୁଆ ସେଲାମ୍ବୁଏଃଅ ଆନେକେ ମୁଇଙ୍ଗ୍ କାବା ସୁଗୁଆ ସାମୁଆଁ ବାଲିର୍‍କେ । ଆଣ୍ଡିନେ ଗୁଡ଼ୁମ୍‌ନିଆ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ବ ଆର୍‌ଗେ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ମେଇଙ୍ଗ୍ ଏଃକେ ବର୍‍ ଞ୍ଜିର୍‌ନୁଗ୍ ୱେଲେ ଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_23","072_24_23","LUK","24","23","23","ମାତର୍‌ ମେଇଙ୍ଗ୍ ଆତ୍‌ଅରିଆ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ଆ‍ଅବା ଆର୍‌କେ । ମେଇଙ୍ଗ୍ ଆତ୍‌ଅରିଆ କିତଂ ଦୁତ୍‍କେ ଦର୍ସନ୍ ଡିଙ୍ଗ୍ ବକ୍ନେ ସାମୁଆଁ ଡିଗ୍ ଆନେକେ ଆଣ୍ଡେଆର୍‍ଚେ ବାସଙ୍ଗ୍‌କେ । କିତଂ ଦୁତ୍‍ଇଂ ଆମେଇଂକେ ଜିସୁ ଜିବନ୍ ଲେଃକ୍ନେ ସାମୁଆଁ ଡିଗ୍ ବାଲିର୍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_24","072_24_24","LUK","24","24","24","ତେନ୍‌ ଇଡ଼ିଂ ନେନେ ଦଲ୍ ବିତ୍ରେ ବାନ୍ ଉଡ଼ିରୁଆ ଡିଗ୍ ଗୁଡ଼ୁମ୍‍ ଡାଗ୍‍ରା ୱେକେ । ସେଲାମ୍ବୁଏ ରେମୁଆଁଇଂ ବାଲିର୍ ସାମୁଆଁରେ ଗୁଡ଼ୁମ୍‍ ଡିଗ୍ ମେଲା ଲେଃଗେ ମେଇଙ୍ଗ୍ ବିତ୍ରେ କେକେ ମାତର୍‌ ମେଇଙ୍ଗ୍ ଜିସୁକେ ଆତ୍‌ଅରିଆ ଆଃଅଁ ବ‍ଆର୍‌କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK24_25","072_24_25","LUK","24","25","25","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ଆତେନ୍‌ ମ୍ୱାୟାକେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ଉଡ଼ି ବକୁଆ । ବାବବାଦିଇଂ ଜା ସାପା ବାସଙ୍ଗ୍‍ବଗେ ଆତେନ୍‌ ସତ୍‍କେ ବିସ୍‌ବାସ୍‍ ଡିଙ୍ଗ୍‍ପା ପେଇଂ ଉଡ଼ି ଅବିସ୍‌ବାସି । ");
INSERT INTO gaq_vpl VALUES ("LK24_26","072_24_26","LUK","24","26","26","ଆକେନ୍‌ ସାପା ଦୁକ୍ ବାକ୍ନେ ଇଡ଼ିଂ ମେଁନେ ଗୌରବ୍‌ନ୍ନିଆ ଗିଃଗାଃନେ ମେଃନେ ମସୀହାନେ ଦର୍‌କାର୍ ଲେଃଗେ ? ");
INSERT INTO gaq_vpl VALUES ("LK24_27","072_24_27","LUK","24","27","27","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ସାସ୍ତର୍‌ଇଂନ୍ନିଆ ମେଁନେ ବିସୟ୍‌ରେ ମେଃନେ ସାପା ଗୁଆର୍‍ ବ ଆର୍‌କେ ଆତେନ୍‌ଇଂ ସାପା ମୁଇଂ ମୁଇଂ ଆଡିଙ୍ଗ୍‌ଚେ ବୁଜେନେ ଲାଗେକେ । ଜିସୁ ମୋଶାନେ ପୁସ୍‍ତକ୍‍ବାନ୍‍ ମୁଲେଚେ ବିନ୍ ବାବବାଦିଇଂ ଜାକ ସାପାରେ ମେଁନେ ବିସୟ୍‌ରେ ମେଃନେ ସାପା ବାଲିର୍ ବଗେ ଆତେନ୍‌ ସାପା ବୁଜେ ବିକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK24_28","072_24_28","LUK","24","28","28","ଆଣ୍ଡିନେ ଇନି ମେଇଂ ୱେନେ ଲେଃଗେ ମେଇଙ୍ଗ୍ ଆତେନ୍‌ ଇନି ଡାଗ୍‍ରା ୱେଚାଆର୍‍କେ । ଜିସୁ ମେଇଂ ଏତେ ଦେକ୍‌ରକମ୍ ବେବ‍ଆର୍ ଡିଙ୍ଗ୍‌କେ ପକ୍‍ରୁତ୍‍ରେ ଡିରକମ୍ ମେଁନେ ସେନୁଗ୍‍ ୱେନେ ସୁଗୁଆ ବଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_29","072_24_29","LUK","24","29","29","ମାତର୍‌ ମେଇଂ ଜାବର୍‌ ଇକ୍‌ଚାରେ ଜିସୁକେ ବିକ୍ୟା ସାଲିଆ ଆର୍‌କେ “ନେନେ ଏତେ ଲେଃୱେଲା । ସ୍ମି ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଦିନ୍ ଇଁଏଁ ଡାନେ ବେଲା ଡିଂୱେଡିଂକେ ।” ତେସା ଜିସୁ ମେଇଂ ଏତେ ଲେନେସା ଡୁଆ ବିତ୍ରେ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_30","072_24_30","LUK","24","30","30","ଜିସୁ ମେଁ ଏତେ ଚଙ୍ଗ୍‍ନ୍‍ସା କକେ । ମେଁ ନ୍ତିନିଆ ରୁଟି ସାକେ । ମେଁ ରୁଟି ଆତ୍‍ଲା ଦନ୍ୟବାଦ୍ ବିକେ ଆରି ରୁଟିକେ ଟିକ୍‌ଚି ଟିକ୍‌ଚିଚେ ଆମେଇଂକେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_31","072_24_31","LUK","24","31","31","ଆତେନ୍‌ ବେଲା ଆତେନ୍‌ ମ୍ୱାୟାନେ ମ୍‌ମୁଆଃ ରଃୱେକେ ଆରି ମେଇଂ ଜିସୁକେ ସାମୁଆଁ ଆର୍‌କେ । ମାତର୍‌ ଜିସୁ ମେଇଙ୍ଗ୍‌ନେ ସାମ୍‍ନାବାନ୍‍ଆ ମାୟା ଡିଙ୍ଗ୍‍ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_32","072_24_32","LUK","24","32","32","ତେନ୍ଇଡ଼ିଂ ମେଇଂ ମେଇଂମେଇଂ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ଆର୍‌କେ, “ଉଡ଼ିବେଲା ଜିସୁ ନେନେ ଏତେ ଗାଲିନିୟା ବାଲିର୍‌ବାତା ଡିଂଡିଙ୍ଗ୍‌ଗେ ଆରି ସାସ୍ତର୍‌ନେ ସଂସାର୍‍ନେ ନିମାଣ୍ଡା ଅର୍‌ତ ଆବୁଜେ ଡିଙ୍ଗ୍‌ଗେ ଆତେନ୍‌ ବେଲା ନେନେ ମନ୍‌ ବିତ୍ରେ ସୁଆ ଡୁଆଚେ ତଡ଼ିଆକେ ସୁଗୁଆ ମନେ ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‍ଆଡିଙ୍ଗେ ?” ");
INSERT INTO gaq_vpl VALUES ("LK24_33","072_24_33","LUK","24","33","33","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଙ୍ଗ୍ ତଡ଼ିଆ ଆର୍‌କେ ଆରି ଯିରୁଶାଲାମ୍‍ ପାକା ଆଣ୍ଡେ ୱେକେ । ଯିରୁଶାଲାମ୍‍ନ୍ନିଆ ମେଇଙ୍ଗ୍ ଜିସୁନେ ଗୋମୁଇଂ ରୁଆ ସିସ୍‌‍ଇଂକେ ଆରି ବିନ୍ ସିସ୍ଇଂକେ ମୁଇଂନୁଗ୍‌ ରିସିଙ୍ଗ୍ ଲେଃନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_34","072_24_34","LUK","24","34","34","ସିସ୍‌‍ଇଂ ଆରି ବିନ୍ ସିସ୍‌‍ଇଂ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ “ପକୃତ୍‍ରେ ମାପ୍ରୁ ଗୁଏଚେ ତଡ଼ିଆ ଲେଃକେ । ମେଁ ଶିମୋନକେ ଆଃସୁଏ ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK24_35","072_24_35","LUK","24","35","35","ତେନ୍‌ ଇଡ଼ିଂ ଏନ୍‌ ମ୍ୱାୟା ରେମୁଆଁ ଗାଲିନିୟା ଜା ସାପା ଗଟେ ଲେଃଗେ ଆତେନ୍‌ ସାପା ମେଁ ସେନୁଗ୍‍ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ । ମେଇଂ ବାସଙ୍ଗ୍‍ଆର୍‌କେ, ଜିସୁ ରୁଟି ବୁଟନେ ବେଲା ମେଇଂ ଡିରକମ୍ ଜିସୁକେ ସାମୁଆଁ ୟାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_36","072_24_36","LUK","24","36","36","ଏନ୍‌ ମ୍ୱାୟା ଏନ୍‌ ସାପା ସାମୁଆଁକେ ବାସଙ୍ଗ୍‌ନେ ବେଲା ନିଜେ ଜିସୁ ସିସ୍‌ଦଲ୍ଇଂ ମଜେ ତୁଆଁ ଲେଃଗେ । ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ଆଡ଼ାତ୍ରା ସାନ୍ତି ଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("LK24_37","072_24_37","LUK","24","37","37","ଆତ୍‌ବାନ୍ ସିସ୍‌‍ଇଂ ଇରିଆତୁଗ୍ ୱେଆର୍‍ଗେ । ମେଇଂ ବୁଟଆର୍‍କେ । ମେଇଙ୍ଗ୍ ବାବେଆର୍‍କେ ଜେ ମେଇଂ ମୁଇଙ୍ଗ୍ ସେଆଁରେ କେଆର୍‌ଡିଙ୍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_38","072_24_38","LUK","24","38","38","ମାତର୍‌ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ମେଁନ୍‌ସା ତାନ୍ଦ୍ରା ଡିଙ୍ଗ୍‌ଚେ ଲଃପେଲେ ? ଜା କେପେଡିଙ୍ଗ୍ ଆତ୍‌ବା ମେଁନ୍‌ସା ସନ୍ଦେଅ ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍ ? ");
INSERT INTO gaq_vpl VALUES ("LK24_39","072_24_39","LUK","24","39","39","ନେଙ୍ଗ୍ ନ୍ତିନିଆ କେଲା । ନେଙ୍ଗ୍ ଞ୍ଚନିଆ କେଲା । ଏନ୍‌ ନେଙ୍ଗ୍ ! ଆନେଙ୍ଗ୍ ଲିଗ୍ ପେଇଂ କେଲାପା ଜେ ନେଙ୍ଗ୍‌ନେ ଏନ୍‌ ଜିବନ୍‍ନେ ଗାଗ୍‌ଡ଼େ । ପେଇଙ୍ଗ୍ ଆନେଙ୍ଗ୍‌କେ ଡିରକମ୍ କେପେଡିଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ବୁତ୍‍ନେ ଚିଲି ଆରି ଞ୍ଚିୟା ଦେତ୍ ରକମ୍ ଗାଗ୍‌ଡ଼େ ଆତେନ୍‌ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("LK24_40","072_24_40","LUK","24","40","40","ଜିସୁ ଆମେଇଂକେ ଏନ୍‌ ସାମୁଆଁ ବାଲିର୍ ମେଁନେ ନ୍ତି ଆରି ଞ୍ଚନେ ଚିନା ସାପା ଆସୁଏକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_41","072_24_41","LUK","24","41","41","ସିସ୍‌ଇଂ ବକୁଆ ଡିଙ୍ଗ୍‌ୱେଗେ । ମେଇଂ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ କେଚେ ଜାବର୍‌ ସାର୍ଦା ଡିଙ୍ଗ୍ଆର୍‌ଗେ । ତେଲାଡିଗ୍ ମେଇଂ ଜା କେଆର୍‌କେ ଆତେନ୍‌ ଅବିସ୍‌ବାସ୍ ଡିଂଆର୍‌କେ । ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେଇଙ୍ଗ୍ ଡାଗ୍‍ରା ମେଃଡିଗ୍ ଚଙ୍ଗ୍‍ନେ କାଦି ଲେଃକେ କି ?” ");
INSERT INTO gaq_vpl VALUES ("LK24_42","072_24_42","LUK","24","42","42","ମେଇଂ ଜିସୁକେ ଡୁଏକ୍ନେ ଆଡ଼ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_43","072_24_43","LUK","24","43","43","ସିସ୍‌‍ଇଂ କିକେନେ ବେଲା ଜିସୁ ଆଡ଼ ଡୁଂୱେଚେ ଚଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_44","072_24_44","LUK","24","44","44","ବାରି ମୋଶା ଆରି ସର୍‌ତେ ବାବବାଦିଇଂନେବାନ୍ ଆରାମ୍ ଡିଂଚେ ସାପା ସାସ୍ତର୍‌ନେ ବିସୟ୍‌ରେ ବୁଜେ ବିକେ । ମେଁନେ ବିସୟ୍‌ରେ ଜା ସାପା ଗୁଆର୍‍ ବକେ ଜିସୁ ଆମେଇଂକେ ସାପା ବୁଜେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_45","072_24_45","LUK","24","45","45","ତେନ୍ଇଡ଼ିଂ ଜିସୁ ସିସ୍‌‍ଇଂକେ ସାପା ଦରମ୍ ସାସ୍ତର୍‌ନେ ସାମୁଆଁ ବୁଜେ ୟାଆର୍‍ଏ ଆତେନ୍‌‌ସା ମେଁଇଙ୍ଗ୍‌ନେ ବୁଦି ସୁଗୁଆ କାପାଟ୍ ରଃବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_46","072_24_46","LUK","24","46","46","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “କିସ୍‌ଟକେ ବାଗୁଏଃ ବିଆର୍‌ଏ ଆରି ଗୁଏକ୍ନେ ଜିର୍‌ସି ଦିନା ଇଡ଼ିଙ୍ଗ୍ ଆରି ମେଁ ଜିବନ୍ ଡିଙ୍ଗ୍‌ଚେ ତଡ଼ିଆନେ ସାମୁଆଁ ଗୁଆର୍‍ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_47","072_24_47","LUK","24","47","47","ଆରି ଯୀରୂଶାଲାମ୍‍ବାନ୍‍ ଆରାମ୍‍ ଡିଙ୍ଗ୍‌ଚେ ସାପା ଜାତି ଡାଗ୍ରା ମେଁନେ ମ୍ନି ସାଚେ ପାପ୍‍ବାନ୍‍ ଉଦାର୍‍ ବାନ୍‍ସା ମନ୍‍କେ ଆଃବଦ୍ଲେ ନ୍‍ସା ମାପ୍ରୁନେ ସାମୁଆଁ ବାଲିର୍‍ ଅଲେଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("LK24_48","072_24_48","LUK","24","48","48","ପେଇଂ ଏନ୍‌ ସାପା ବିସୟ୍‌ରେ ସାକି ପେଲେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_49","072_24_49","LUK","24","49","49","ଅଁପା ନେଙ୍ଗ୍‌ନେ ଆବା ଆପେକେ ମେଁନେ ବିଃନ୍‍ସା ପାର୍‌ମାନ୍‌ ଡିଂବକେ, ସାପା ଗଟେକ୍ନେ ଗଟ୍‌ନାଇଂ ମନେ ଆତ୍ଲାଗ୍ ବିଃନ୍‍ସା ବିଃକେ, ନେଙ୍ଗ୍ ଆତେନ୍‌ ପେନ୍ନିଆ ମ୍ୱେଏ । ମାତର୍‌ କିତଂବାନ୍‍ ଆତେନ୍‌ ବପୁ ଆପାଙ୍ଗ୍ ଜାକ ଆକେନ୍ ଇନିନ୍ନିଆ ପେ ଉର୍‌ଚେ ଲାଃଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("LK24_50","072_24_50","LUK","24","50","50","ଜିସୁ ମେଁନେ ସିସ୍‌‍ଇଂକେ ଯିରୁଶାଲାମ୍‍ବାନ୍‍ ବେଥନୀନ୍ନିଆ ୱେନେ ଗାଲି ଜାକ ଆଃଅଲେଙ୍ଗ୍ ଡୁଙ୍ଗ୍‍ୱେକେ । ଜିସୁ ମେଁନେ ନ୍ତି ଟେକେଚେ ସିସ୍‌‌ଇଂକେ ଆସିର୍ବାଦ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_51","072_24_51","LUK","24","51","51","ଜିସୁ ଆମେଇଂକେ ଆସିର୍ବାଦ୍ ବିଃନେ ବେଲା ମେଁ ସିସ୍‌‍ଇଂନେ ଡାଗ୍ରାବାନ୍ ବିନେ ଡିଙ୍ଗ୍‌ୱେଗେ ଆରି ଆମେକେ କିତଂ ଡୁଂୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_52","072_24_52","LUK","24","52","52","ସିସ୍‌‌ଇଙ୍ଗ୍‌ ଆତ୍‌ଅରିଆ ଆମେକେ ପୁଜା ଡିଙ୍ଗ୍ଆର୍‌କେ ଆରି ମେଇଂ ଜାବର୍‌ ସାର୍ଦାରେ ଯିରୁଶାଲାମ୍‍ନ୍ନିଆ ଆଣ୍ଡେ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("LK24_53","072_24_53","LUK","24","53","53","ମେଇଂ କାଲାଆଃ ମନ୍ଦିର୍‌ନ୍ନିଆ ଲେଃଚେ ପର୍‍ମେସର୍‍ନେ ପ୍ରସଂସା ଡିଙ୍ଗ୍ଆର୍‌କେ ।");
INSERT INTO gaq_vpl VALUES ("JN1_1","073_1_1","JHN","1","1","1","ଅଃସେବାନ୍ ବ୍ନାଲିର୍ ଲେଃଗେ ବ୍ନାଲିର୍ ଇସ୍‌ପର୍ ଏତେ ଲେଃଗେ ବ୍ନାଲିର୍ ଆରି ଇସ୍‌ପର୍ ମୁଇଙ୍ଗ୍ ଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_2","073_1_2","JHN","1","2","2","ବ୍ନାଲିର୍ ଅଃସେବାନ୍ ଇସ୍‌ପର୍ ଏତେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_3","073_1_3","JHN","1","3","3","ଆକେନ୍ ବ୍ନାଲିର୍ ବାନ୍ ଇସ୍‌ପର୍‌ନେ ସାପା ଆରେ ବକେ । ମେଁ ବାନ୍ ମେଃଡିଗ୍ ଆରେ ଆବକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN1_4","073_1_4","JHN","1","4","4","ମେଁନ୍ନିଆ ପାରାନ୍ ଲେଃଗେ ଆରି ଆତେନ୍‌ ଜିବନ୍ ରେମୁଆଁଇଂନେ ତାରାସ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN1_5","073_1_5","JHN","1","5","5","ଆତେନ୍‌ ତାରାସ୍ ତାଙ୍ଗ୍‍କିଗ୍‍ନ୍ନିଆ ତାର୍‌କିଗ୍ ଡିଙ୍ଗ୍‌ଚେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଆରି ତାଙ୍ଗ୍‌କିଗ୍ ଆମେ ଗ୍ର‍ଅନ୍‌ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN1_6","073_1_6","JHN","1","6","6","ଏନ୍‍ ତାରାସ୍ ସାମୁଆଁରେ ସାକି ବିଃନ୍‍ସା ଜହନ୍ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଇସ୍‌ପର୍ ବେବଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_7","073_1_7","JHN","1","7","7","ସାପା ଜାତିନେ ରେମୁଆଁଇଂ ଏନ୍ ସାମୁଆଁ ଅଁଚେ ଡିରକମ୍ ସତ୍‍ ମାନେଃଆର୍‍ଏ ଆତେନ୍‌‍ସା ଜହନ୍ ପାଙ୍ଗ୍‍ଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_8","073_1_8","JHN","1","8","8","ଜହନ୍ ନିଜେ ଆତେନ୍‌ ତାରାସ୍ ଆଲେଃଗେ ମାତର୍‌ ତାରାସ୍ ସାମୁଆଁରେ ସାକି ବିଃନ୍‍ସା ପାଙ୍ଗ୍‌ଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_9","073_1_9","JHN","1","9","9","ଆଣ୍ତିନେ ସତ୍ ତାରାସ୍ ସାପା ରେମୁଆଁଇଂକେ ତାର୍‌କିଗ୍ ବିଏ ମେଁ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_10","073_1_10","JHN","1","10","10","ଆତେନ୍‌ ବ୍ନାଲିର୍ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ଲେଃଗେ ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ ମେଁନେ ବାନ୍ ତିଆର୍ ଡିଙ୍ଗ୍‌କେ ତେଲାଡିଗ୍‍ ମଞ୍ଚ୍‌ପୁର୍‌ ଆମେକେ ଆସାମୁଆଁକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN1_11","073_1_11","JHN","1","11","11","ମେଁ ମେଁନେ ନିଜେନେ ରାଜିନ୍ନିଆ ପାଙ୍ଗ୍‌କେ ତେଲାଡିଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ନିଜେନେ ରେମୁଆଁଇଂ ଆମେକେ ଗ୍ର‍ଅନ୍‌ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN1_12","073_1_12","JHN","1","12","12","ମାତର୍‌ ଉଡ଼ି ରେମୁଆଁ ଆମେକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଚେ ମେଁନେ ଡାଗ୍ରା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌କେ ଆମେଇଂକେ ମେଁ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଡିଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_13","073_1_13","JHN","1","13","13","ମେଇଂ ମିଆଁ ବାନ୍‌ ଗାଗ୍‌ଡ଼େନେ ଇକ୍‌ଚାବାନ୍ ବାରି ରେମୁଆଁନେ ଇକ୍‌ଚାବାନ୍ ଜନମ୍ ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ ଣ୍ତୁ ମାତର୍‌ ନିଜେ ଇସ୍‌ପର୍‌ନେ ବାନ୍ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_14","073_1_14","JHN","1","14","14","ଆତେନ୍‌ ବ୍ନାଲିର୍ ରେମୁଆଁ ଗାଗ୍‌ଡ଼େ ସାଚେ ନେନେ ଏତେ ବ୍ରୁଆ ଡିଙ୍ଗ୍‌କେ । ମେଁ ଲିବିସ ଆରି ସତ୍‍ ବାବ୍‌ରେ ଲେଃକେ । ଇସ୍‌ପର୍‌ନେ ମୁଇଙ୍ଗ୍‌ ଆଃ ଗଡ଼େଅ ସୁଗୁଆ ମେଁ ଆଣ୍ଡିନେ ଇରିଆତୁଗ୍ ମ‍ଇମା ବାଲେଃକେ ଆତେନ୍‌ ନେ ନେକେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_15","073_1_15","JHN","1","15","15","ଜହନ୍ ମେଁନେ ସାମୁଆଁରେ ସାକି ବିଚେ କିରଚେ ବାଲିର୍‍କେ “ଜା ନେଙ୍ଗ୍‌ନେ ଇଡ଼ିଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ମେଁ ନେଙ୍ଗ୍‌ନେ ବାନ୍ ମ୍ନା ଡାଗ୍ଲା ମେଁ ନେଙ୍ଗ୍‌ନେ ଜନମ୍ ସେନୁଗ୍‍ ଲେଃଗେ ଜାଣ୍ତେନେ ସାମୁଆଁରେ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ମ୍ବଗେ ଆକେନ୍ କ୍ମେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_16","073_1_16","JHN","1","16","16","ମେଁନେ ଲିବିସଃ ବାନ୍ ନେ ସାପାରେ ଆସିର୍ବାଦ୍ ବାନେଲେଃକେ ଆରି ନେ ଆସିର୍ବାଦ୍ ଆଡ଼ାତ୍ରା ଆସିର୍ବାଦ୍ ବାନେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_17","073_1_17","JHN","1","17","17","ଇସ୍‌ପର୍ ମୋଶାନେ ବାନ୍ ନିୟମ୍‌ ବିଃକେ । ମାତର୍‌ ଜିସୁ କିସ୍‌ଟନେ ବାନ୍ ଲିବିସ ଆରି ସତ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ପାଙ୍ଗ୍‌ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_18","073_1_18","JHN","1","18","18","ଜା ଅଃନା ଇସ୍‌ପର୍‌କେ ଆକେକେ ଣ୍ଡୁ । ଆବାନେ ବୁଲୁନ୍ନିଆ ଲେଃକ୍ନେ ମେଁନେ ମୁଇଙ୍ଗ୍‌ ଆଃ ଉଙ୍ଗ୍‌ଡେ ଆମେକେ ଆଃତ୍ନା ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_19","073_1_19","JHN","1","19","19","ଯିରୂଶାଲାମ୍‌ବାନ୍‌ ଜିଉଦିଇଂ ଉଡ଼ି ଦରମ୍ ପୁଜାରି ଆରି ଲେବୀୟଇଂକେ ଜହନ୍‌ନେ ଡାଗ୍ରା ବେଆର୍‌କେ “ନାଁ ଜାଣ୍ଡେ ?” ଡାଗ୍‌ଚେ ସାଲିଆକୁ ନ୍‌ସା ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_20","073_1_20","JHN","1","20","20","ଏନ୍‌ ସାମୁଆଁନେ ଉତର୍ ବିଃନ୍‍ସା ମେଁନେ ମାବୁଡ଼ିଚେ ଜହନ୍‌ କୁଲାକୁଲି ବାବ୍‌ରେ ଆମ୍ୟାବିକେ “ନେଙ୍ଗ୍ କିସ୍‌ଟ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("JN1_21","073_1_21","JHN","1","21","21","ଜିହୁଦିଇଂ ଆରି ଜହନ୍‍କେ ସାଲିଆକୁଆର୍କେ “ତେଲା ନାଁ ଜାଣ୍ଡେ ? ନାଁ ମେଃନେ ଏଲୀୟ ?” ଜହନ୍ ବାଲିର୍‌କେ “ଣ୍ତୁ ନେଙ୍ଗ୍ ଏଲିୟ ଣ୍ତୁ ।” “ନାଁ ମେଃନେ ଆତେନ୍‌‌ ବାବବାଦି ।” ଜହନ୍ ବାଲିର୍‌କେ । ଣ୍ତୁ ନେଙ୍ଗ୍ ଆତେନ୍‌‌ ବବିସତ୍‍ ବକ୍ତା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN1_22","073_1_22","JHN","1","22","22","ଆତ୍‌ବାନ୍ ଜିଉଦୀଇଂ ଜହନ୍‍କେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଆନେକେ ବେବକ୍ନେ ରେମୁଆଁକେ ଡିରକମ୍ ଉତର୍ ବିଃନେୟାଏ ଆକେନ୍‌ସା ନା ଜାଣ୍ଡେ ? ନାନେ ନିଜର୍ ବିସୟ୍‌ରେ ମେଁନେ ବାସଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍‌ ?” ");
INSERT INTO gaq_vpl VALUES ("JN1_23","073_1_23","JHN","1","23","23","ଜହନ୍ ବାସଙ୍ଗ୍‌ଡିଂକେ ଯିଶାଇୟ ବାବବାଦି ଡିରକମ୍ ବାଲିର୍‌ବକେ “ନେଙ୍ଗ୍ ଦେତ୍‌ରକମ୍ ବାଲିଲନ୍ନିଆ ୱାସାର୍‌ ଡିଙ୍ଗ୍‌କ୍ନେ ମୁଇଂଜାନେ ସାମୁଆଁ ମାପ୍ରୁ ନ୍‌ସା ଗାଲି ତିଆର୍ ଡିଙ୍ଗ୍‌ପା; ମେଁ ପାଙ୍ଗ୍‌ନେ ଗାଲି ସିଦା ଆଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_24","073_1_24","JHN","1","24","24","ଆରି ଫାରୁଶୀଇଂ ବେବକ୍ନେ ବ୍ନାଲିର୍ ପାଙ୍ଗ୍‌ଲେକ୍ନେ ରେମୁଆଁଇଂ ଜହନ୍‌କେ ବାଲିର୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_25","073_1_25","JHN","1","25","25","ମେଇଂ ଆମେକେ ସାଲ୍ୟାକୁ ଆର୍‌କେ, ନା ଜଦି କିସ୍‌ଟ ବା ଏଲୀୟ ବା ଆତେନ୍‌‌ ବାବବାଦି ଣ୍ତୁ, ତେଲା ମେଁନ୍‌ସା ନା ଦିକ୍ୟା ବିନାଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("JN1_26","073_1_26","JHN","1","26","26","ଜହନ୍‌ ଆମେଇଂକେ ଉତର୍ ବିକେ, ନେଙ୍ଗ୍ ଣ୍ତିଆନ୍ନିଆ ଡୁବନ୍‌ ବିଣ୍ଡିଂକେ । ଜାଣ୍ଡେକେ ପେ ପେମ୍ୟାକେ ଣ୍ଡୁ; ମେଁ ପେଇଂନେ ବିତ୍ରେ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_27","073_1_27","JHN","1","27","27","ମେଁ ନେଙ୍ଗ୍ ଇଡ଼ିଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ମେଁନେ ଜୁତା ତୁତଃନ୍‌ସା ନେଙ୍ଗ୍‌ନେ ସକତ୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN1_28","073_1_28","JHN","1","28","28","ଜହନ୍ ଣ୍ଡିଆଃଦିକ୍ୟା ବିଃଡିଂକ୍ନେ ଜର୍ଦନ୍‌ ଲଣ୍ଡିଆନେ ଇନୁମେତା ନେ ବେଥନୀ ନ୍ନିଆ ଏନ୍ ସାପା ଗଟ୍‌ନା ଗଟେୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_29","073_1_29","JHN","1","29","29","ତେନ୍ ଞ୍ଜଡ଼େ ଜିସୁକେ ମେଁ ପାକା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ଜହନ୍‌ ବାସଙ୍ଗ୍‌କେ “ଏ କେଲା ଇସ୍‌ପର୍‌ନେ ଉଂମେଣ୍ଡା ଜା ମଞ୍ଚ୍‌ପୁର୍‌ନେ ପାପ୍ ଡୁଙ୍ଗ୍‌ଚେ ଡୁଂୱେ ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_30","073_1_30","JHN","1","30","30","ମାତର୍‌ ଆକ୍‌ମେକେ କେଚେ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ମ୍ବକେ ମେଁ ନେଙ୍ଗ୍ ବାନ୍ ମ୍ନା ଡାଗ୍ଲା ମେଁନେ ସାମୁଆଁ ନେଙ୍ଗ୍‌ ଜନମ୍ ଡିଙ୍ଗ୍‌ନେ ସେନୁଗ୍‌ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_31","073_1_31","JHN","1","31","31","ନେଙ୍ଗ୍ ଆମେକେ ଅଃସେ ଆଃ ନ୍ନାମ୍ୟାକେ ଣ୍ଡୁ ଡାଗ୍ଲା ମେଁ ଡିରକମ୍ ଇଶ୍ରାୟେଲ ରେମୁଆଁଇଂନେ ଡାଗ୍ରା ମ୍ୟା ଆଃରେ ଆତେନ୍‌‌ସା ନେଙ୍ଗ୍ ଣ୍ତିଆଃନ୍ନିଆ ଦିକ୍ୟା ବିଃନ୍‌ସା ପାଙ୍ଗ୍ ନ୍ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_32","073_1_32","JHN","1","32","32","ଜହନ୍‌ ସାକି ବିଚେ ବାସଙ୍ଗ୍‌କେ, “କୁକୁର୍‌ୟାଃ ରକମ୍‌ ପବିତ୍ର ଆତ୍ମା କିତଂବାନ୍ ଜାର୍‌ଚେ ମେଁନେ ଆଡ଼ାତ୍ରା କକ୍ନେ ନେଙ୍ଗ୍ ଙ୍କେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_33","073_1_33","JHN","1","33","33","ତେଲାଡିଗ୍ ଏନ୍ ଆତେନ୍‌ ରେମୁଆଁ ଡାଗ୍‌ଚେ ଆତେନ୍‌‌ ବେଲା ନେଙ୍ଗ୍ ମ୍ୟା ନ୍ନାଲେଃଗେ ଣ୍ଡୁ, ମାତର୍‌ ଣ୍ଡିଆଃ ଦିକ୍ୟା ବିଃନ୍‍ସା ମୁଃଡ଼ି ଇସ୍‌ପର୍ ଆନେଙ୍ଗ୍‌କେ ବେବକେ, ମେଁ ଆନେଙ୍ଗ୍ ଆମ୍ୟାଆର୍‌କେ ସାମୁଆଁ ନେଙ୍ଗ୍‌ନେ ଆତ୍ମା ମୁଇଙ୍ଗ୍ ରେମୁଆଁନେ ଆଡ଼ାତ୍ରା ଜାର୍‌ଚେ କନେ ପେ ପେକେଏ, ପବିତ୍ର ଆତ୍ମାରେ ଜା ଦିକ୍ୟା ବିଃଏ, ମେଁ ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ଆତେନ୍‌ ରେମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("JN1_34","073_1_34","JHN","1","34","34","ଏନ୍ ଗଟ୍‌ନା ନେଙ୍ଗ୍ କେନ୍ଲେକେ ତେସା ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ, ମେଁ ଡିଂଡିଙ୍କେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_35","073_1_35","JHN","1","35","35","ତେଲା ଆର୍‌ମୁଇଂ ଦିନା ଆର୍‌ମୁଇଂତର୍‌ ଜହନ୍‌ ଆରି ମେଁନେ ସିସ୍‍ଇଂ ବାନ୍ ମ୍ୱାୟା ଆଃତେ ତୁଆଁ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_36","073_1_36","JHN","1","36","36","ଆତେନ୍‌ ଗାଲି ଜିସୁ ଅଲେଙ୍ଗ୍ ୱେଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ଜହନ୍‌ ବାସଙ୍ଗ୍‌କେ, “କେଲାପା ଇସ୍‌ପର୍‌ନେ ଉଂମେଣ୍ଡା ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_37","073_1_37","JHN","1","37","37","ଆତେନ୍‌ ମ୍ୱାୟା ସିସ୍‍ ଜହନ୍‌ନେ ସାମୁଆଁ ଅଁଚେ ଜିସୁନେ ପ୍ଲା ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_38","073_1_38","JHN","1","38","38","ଜିସୁ ପ୍ଲେଗ୍‌ କେଚେ ସାଲ୍ୟାକୁକେ, “ପେଇଂ ମେଁନେ ତୁର୍ ପେଡିଙ୍ଗ୍‌କେ ?” ମେଇଂ ଜିସୁକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ରାବି ଅର୍ତାତ୍ ଗୁରୁ ନା ଆଣ୍ତିଅରିଆ ଲେଃନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN1_39","073_1_39","JHN","1","39","39","ଜିସୁ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‍ଡିଂକେ ପାଙ୍ଗ୍‌ଲାପା ପେକେଏ ଆତ୍‌ବା ସିସ୍‍ଇଂ ୱେଚେ ଜିସୁନେ ବାସା ମ୍ୟାଃକ୍ନେ ଡୁଆ କେଆର୍‌କେ ଆରି ଆତେନ୍‌ ସ୍ମି ଜିସୁନେ ସଙ୍ଗେ ଲେଃଆର୍‌କେ; ଆତେନ୍‌ ବେଲା ମିଡିଗ୍‍ ଅଁକ୍ଲିଗ୍ ଡିଙ୍ଗ୍‌ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_40","073_1_40","JHN","1","40","40","ଆକେନ୍ ମ୍ୱାୟା ଜହନ୍‍ନେ ସାମୁଆଁ ଅଁଚେ ଜିସୁନେ ପ୍ଲା ୱେଡିଙ୍ଗ୍‌ ଆର୍‌ଗେ ମେଁଇଂନେ ବିତ୍ରେ ମୁଇଙ୍ଗ୍ ଶିମୋନ ପିତର୍‌ନେ ବୟାଁ ଆନ୍ଦ୍ରିୟ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_41","073_1_41","JHN","1","41","41","ଆଦ୍ରିୟ ସେନୁଗ୍‌ ମେଁନେ ବୟାଁଣ୍ତେ ଶିମୋନ୍‍ନେ ଡାଗ୍ରା ୱେଗେ ଆଦ୍ରିୟ ଶିମୋନକେ ବାଲିର୍‌କେ ନେ ସାପାରେ ମସୀହାକେ ନେକେକେ । ମସୀହାନେ ଅର୍ତ କିସ୍‌ଟ । ");
INSERT INTO gaq_vpl VALUES ("JN1_42","073_1_42","JHN","1","42","42","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ଆଦ୍ରିୟ ଶିମୋନକେ ଜିସୁନେ ଡାଗ୍ରା ଡୁଂପାଙ୍ଗ୍‌କେ ଜିସୁ ଆମେକେ କେଚେ ବାସଙ୍ଗ୍‌କେ, “ନା ଜହନ୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ଶିମୋନ ଆନାକେ କେମ୍ପା ଡାଗ୍‌ଚେ ମ୍ନିରେ ୱା ଆର୍‌ଏ ।” କେମ୍ପା ସବ୍‌ଦନେ ଅର୍‌ତ ପିତର ବା “ବ୍ରି ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_43","073_1_43","JHN","1","43","43","ଆରି ମୁଇଂଦିନା ଜିସୁ ଗାଲିଲୀନ୍ନିଆ ୱିଗ୍ ନ୍‌ସା ରାଜି ଡିଙ୍ଗ୍‌କେ ଆରି ଜିସୁ ପିଲିପ୍‌ପକେ କେଚେ ବାସଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା । ");
INSERT INTO gaq_vpl VALUES ("JN1_44","073_1_44","JHN","1","44","44","ପିଲିପ୍‌ପ ବେଥ୍‍ସାଇଦାନେ ରେମୁଆଁ ଲେଃଗେ ଆତେନ୍‌ ଆନ୍ଦ୍ରିୟ ଆରି ପିତର୍‌ନେ ଇନି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN1_45","073_1_45","JHN","1","45","45","ପିଲିପ୍‌ପ ନିଥନିୟେଲ୍‌କେ କେଚେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, ଜାନେ ସାମୁଆଁରେ ମୋଶା ନିୟମ୍‌ ପୁସ୍‌ତକ୍‌ନ୍ନିଆ ଗୁଆର୍‌ ବକେ ବାରି ବାବବାଦିଇଂ ଡିଗ୍ ଗୁଆର୍ ବକେ ନେ ସାପାରେ ଆମେକେ କେନେଲେକେ ମେଁ ଯୋସେଫ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ନାଜରିତିୟ ଜିସୁ । ");
INSERT INTO gaq_vpl VALUES ("JN1_46","073_1_46","JHN","1","46","46","ନିଥନିୟେଲ ପିଲିପ୍‌ପକେ ସାଲିଆକୁକେ, “ନାଜରିତବାନ୍ ମେଁନେ ମେଃଡିଗ୍ ନିମାଣ୍ଡା ବିସୟ୍ ତାର୍ ୟାଏ କି ?” ପିଲିପ୍‍ପ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ପାଙ୍ଗ୍‌ଚେ କେଲା ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_47","073_1_47","JHN","1","47","47","ଜିସୁ ନିଥନିୟେଲ୍‌କେ ମେଁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ବାସଙ୍ଗ୍‌କେ “କ୍ମେ ମୁଇଙ୍ଗ୍ ସତେଆ ଇଶ୍ରାଏଲ୍‌ନେ ରେମୁଆଁ । କ୍ମେନ୍ନିଆ ମେଃଡିଗ୍ କୁଟ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_48","073_1_48","JHN","1","48","48","ନିଥନିୟେଲ ଜିସୁକେ ସାଲିଆକୁକେ, “ନା ଆନେଙ୍ଗ୍ ଡିରକମ୍ ନ୍ନାସାମୁଆଃକେ ?” ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ: “ପିଲିପ୍‌ପ ଆନାକେ ୱାକ୍ନେ ସେନୁଗ୍‌ ନାନେ ଉଡ଼ିବେଲା ଲିୱା ସ୍ଲା ବୁନ୍ଦେ ନାଲେଗେ ଆତେନ୍‌ ବେଲା ନେଙ୍ଗ୍ ଆନାକେ କେନ୍ଲେଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_49","073_1_49","JHN","1","49","49","ନିଥନିୟେଲ ଜିସୁକେ ବାଲିର୍‌କେ, “ଗୁରୁ ନା ସତେଆ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ନା ଇଶ୍ରାୟେଲନେ ଇଃସାଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_50","073_1_50","JHN","1","50","50","ଜିସୁ ନିଥନିୟେଲ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆନାକେ ଲିୱା ସ୍ଲା ବୁନ୍ଦେ କେନ୍ଲେଗେ ଡାଗ୍‌ଚେ ବାଲିର୍‌ଲା ଜେ ନା ମେଃନେ ବିସ୍‌ବାସ୍ ନାଡିଙ୍ଗ୍‌କେ ? ଆକେନ୍ ବାନ୍ ଜାବର୍ କାବା ବିସୟ୍ ସାପା ନାକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN1_51","073_1_51","JHN","1","51","51","ଆରି ଜିସୁ ନିଥନିୟେଲ୍‌କେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ, ପେଇଂ କିତଂଇନିନ୍ନିଆ ମେଲା ଡିଙ୍ଗ୍‌ନେ ପେକେଏ ଆରି ଇସ୍‌ପର୍‌ନେ ଦୁତ୍ଇଂକେ ଇସ୍‌ପର୍ ଉଙ୍ଗ୍‌ଡେନେ ଆଡ଼ାତ୍ରା ପାଙ୍ଗ୍‌ନେ ଆରି ୱେଡିଂକ୍ନେ ପେକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN2_1","073_2_1","JHN","2","1","1","ମ୍ୱାର୍‌ ଦିନ୍ ଇଡ଼ିଙ୍ଗ୍ ଗାଲିଲୀ ନଗର୍‍ନେ କାନା ଇନିନ୍ନିଆ ମୁଇଙ୍ଗ୍ ବିଏ ଡିଙ୍ଗ୍‌କେ । ଜିସୁନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆତ୍‌ଅରିଆ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_2","073_2_2","JHN","2","2","2","ଜିସୁ ଆରି ମେଁନେ ସିସ୍‍ଇଂ ଡିଗ୍ ଆତେନ୍‌ ବିଃଏ ଟିକାନ୍ନିଆ ୱା ବ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_3","073_2_3","JHN","2","3","3","ଇଡ଼ିଙ୍ଗ୍ ଅଙ୍ଗୁର୍ ରସ୍‌ ଡାୱେଲା ଜିସୁନେ ଇୟାଙ୍ଗ୍ ଆମେକେ ବାଲିର୍‌କେ ମେଁଇଙ୍ଗ୍‌ନେ ଅଙ୍ଗୁର୍ ରସ୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN2_4","073_2_4","JHN","2","4","4","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେକେ ବାଲିର୍‌କେ, ନା ଆଃତେ ନେଙ୍ଗ୍‌ନେ ମେଃ ସମ୍ପର୍‌କ ? ନେଙ୍ଗ୍‌ନେ ବେଲା ଏଜାକ ଆପାଙ୍ଗ୍‍କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN2_5","073_2_5","JHN","2","5","5","ଜିସୁନେ ଇୟାଙ୍ଗ୍ ଗତିରେଇଂକେ ବାଲିର୍‌କେ, “ଜିସୁ ଆପେକେ ମେଃନେ ବାସଙ୍ଗ୍ଏ, ଆତେନ୍‌‌ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN2_6","073_2_6","JHN","2","6","6","ଜିଉଦିଇଂନେ ପର୍‌ଚଲ୍‌ ଡିଙ୍ଗ୍ ନ୍‌ସା ଆତ୍ଅରିଆ ବ୍ରି ଏଃତେ ଆଃରେକ୍ନେ ତୁର୍‌କ୍ଲିଗ୍ ମ୍ନା ମ୍ନା ବ୍ରି ଏଃତେ ଆଃରେକ୍ନେ ଣ୍ତିଆଃକୁଣ୍ତ୍‌ ଲେଃକେ ସାପା ଣ୍ଡିଆ କୁଣ୍ତ୍‌ ଅରିଆ ମାଲ୍‌କୁଡ଼ି ଲିଟର୍‌ ଣ୍ଡିଆ ସାଃମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_7","073_2_7","JHN","2","7","7","ଜିସୁ ଗୁତିରେଇଂକେ ବାଲିର୍‌କେ, ଣ୍ତିଆଃ କୁଣ୍ତ୍‌ନ୍ନିଆ ଣ୍ଡିଆ ବର୍‌ତି ଡିଙ୍ଗ୍‌ପା ଆତ୍‌ବାନ୍ ଗୁତିରେଇଂକେ ବାଲିର୍‌କେ କୁଣ୍ତ୍‌ନ୍ନିଆ ଣ୍ଡିଆ ବର୍‌ତି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_8","073_2_8","JHN","2","8","8","ବାରି ଜିସୁ ଗୁତିରେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଏକ୍ରେ ଆତ୍‌ବାନ୍ ଇକୁଡ଼ା ଣ୍ଡିଆ ଡୁଂୱେଚେ ବଜିନେ ଦାଇତ୍‌ରେ ଲେଃକ୍ନେ ରେମୁଆଁକେ ବିଃପା ।” ମେଇଂ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_9","073_2_9","JHN","2","9","9","ବଜି ବନେ ରେମୁଆଁ ଅଙ୍ଗୁର୍ ରସ୍‌ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ଣ୍ଡିଆ ଚାଲିଃକେ, ଡାଗ୍ଲା ଆକେନ୍ ଆଣ୍ଡିବାନ୍ ଡୁଂପାଙ୍ଗ୍‌ଆର୍କେ, ଆତେନ୍‌ ଆମ୍ୟାକେ ଣ୍ତୁ, ଡାଗ୍ଲା ଆକେନ୍ ଆଣ୍ଡିବାନ୍ ଡୁଂପାଙ୍ଗ୍‌ଆର୍କେ, ଆତେନ୍‌ ଗତିରେଇଂ ମ୍ୟାଲେଃଆର୍କେ । ଆକ୍‌ବାନ୍ ଙ୍ଗିରେକେ ୱାଚେ ବାଲିର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_10","073_2_10","JHN","2","10","10","ସାପାରେ ସେନୁଗ୍‌ ନିମାଣ୍ତା ଅଙ୍ଗୁର୍ ରସ୍‌ ଉଗ୍‌ନ୍‌ସା ବିଃମ୍ୟାକେ ଆରି ରେମୁଆଁ ବୁସାଃକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ସାଦାରନ୍ ଅଙ୍ଗୁର୍ ରସ୍‌ ବିଃଆର୍‌ଏ; “ନାଁ ଏଃଜାକ ନିମାଣ୍ତା ଅଙ୍ଗୁର୍ ରସ୍‌ ନାବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN2_11","073_2_11","JHN","2","11","11","ଜିସୁ ମେଁନେ ଆକେନ୍ ସେନୁଗ୍‌ ଇରିଆତୁଗ୍ କାମ୍ ଗାଲିଲୀନେ କାନା ଇନିନ୍ନିଆ ଡିଙ୍ଗ୍‌ବ‍କେ ଦେକ୍‌ରକମ୍ ଜିସୁ ମେଁନେ ମ‍ଇମା ଆସୁଏକେ ଆରି ସିସ୍ଇଂ ମେଁନେଡାଗ୍ରା ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_12","073_2_12","JHN","2","12","12","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମେଁନେ ଇୟାଙ୍ଗ୍ ବୟାଁଣ୍ଡେଇଂ ଆରି ସିସ୍ଇଂ କପର୍ନାହୂମନ୍ନିଆ ୱେଚେ ଆତ୍‌ଅରିଆ ଉଡ଼ିସି ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_13","073_2_13","JHN","2","13","13","ଆତେନ୍‌ ବେଲା ଜିଉଦିଇଂନେ ଉଦାର୍‌ ପାଣ୍ଡୁଏ ଡାଗ୍ରା ପିଙ୍ଗ୍‍ଚା ଡିଙ୍ଗ୍‌କେ ଆରି ଜିସୁ ଯିରୂଶାଲମନ୍ନିଆ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_14","073_2_14","JHN","2","14","14","ଆରି ଜିସୁ ମନ୍ଦିର୍‌ନ୍ନିଆ ଅରେଃ ମେଣ୍ଡା ଆରି କୁକୁର୍ୟାଃ ବେପାର୍‌ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ କଲେଃକ୍ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_15","073_2_15","JHN","2","15","15","ଆତ୍‌ବାନ୍ ମେଁ ଗେଏଃନେ ମୁଇଙ୍ଗ୍ ଚାବୁକ୍ ଆଃରେଚେ ଅରେଃ ମେଣ୍ଡାଇଂକେ ମନ୍ଦିର୍‌ବାନ୍‌ ଆନ୍ତାର୍‌ବିକେ । ଡାବୁ ବେପାର୍‌ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେଇଂନେ ଚାମ୍‌ଡା ସାପା ପାଲେଗ୍‌ଜଗ୍‌ତ୍ଲିଗ୍‌ଚେ ଡାବୁ ଆଣ୍ଡେଙ୍ଗ୍ ବୁନ୍ଦେ ପିର୍‌ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_16","073_2_16","JHN","2","16","16","ଆରି ଜିସୁ କୁକୁର୍ୟାଃ ବେପାର୍‌ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେଇଂକେ ବାସଙ୍ଗ୍‌କେ ଆକେନ୍ ଆଣ୍ଡେଙ୍ଗ୍ ଆକ୍‌ବାନ୍ ଡୁଂୱେଲାପା ନେଙ୍ଗ୍ ଆବାନେ ଡୁଆକେ ବେପାର୍‌ନେ ଡୁଆ ଆରାଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("JN2_17","073_2_17","JHN","2","17","17","ଆକେନ୍ କେଚେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍ ବକ୍ନେ ମୁଇଙ୍ଗ୍ ବ୍ନାଲିର୍ ସିସ୍ଇଂନେ ମନେ ପଡ଼େକେ “ନାଁନେ ଡୁଆ ଆଡ଼ାତ୍ରା ନେଙ୍ଗ୍‌ନେ ଜତନ୍‌ ନେଙ୍ଗ୍ ବିତ୍ରେ ସୁଆରକମ୍‌ ଡୁଆଡିଙ୍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN2_18","073_2_18","JHN","2","18","18","ଆତ୍‌ବାନ୍ ଜିଉଦିଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଆକେନ୍ ପ୍ରସ୍‌ନ ସାଲିଆକୁ ଆର୍‌କେ ନାଁ ଆକେନ୍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଅଦିକାର୍ ବାନାଲେଃକେ ଡାଗ୍‌ଚେ ନେ ଡିରକମ୍ ନେମ୍ୟାଏ ? ଆରି ଆଣ୍ତିନେ ଚିନାବାନ୍ ଆନେକେ ଆତେନ୍‌ ଆସୁଏ ନାଡିଙ୍ଗ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("JN2_19","073_2_19","JHN","2","19","19","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ ପେଇଂ ଆକେନ୍ ମନ୍ଦିର୍‌କେ ପାକ୍‍ଚି ବିଃପା ଆରି ନେଙ୍ଗ୍ ଞ୍ଜିଦିନା ବିତ୍ରେ ଆତେନ୍‌ ମନ୍ଦିର୍‌କେ ଆରେମ୍ୱିଏ । ");
INSERT INTO gaq_vpl VALUES ("JN2_20","073_2_20","JHN","2","20","20","ଆତ୍‌ବାନ୍ ଜିଉଦିଇଂ ବାଲିର୍‌କେ ଆକେନ୍ ମନ୍ଦିର୍‌କେ ଆରେନ୍‌ସା ଚୟାଲିସ୍‌ ମେମୁଆଁ ଲାଗେଲେଃକେ; ଆରି ନାଁ ମେଃନେ ଆମେକେ ଞ୍ଜିଦିନା ବିତ୍ରେ ଆରେନାବିଏ ? ");
INSERT INTO gaq_vpl VALUES ("JN2_21","073_2_21","JHN","2","21","21","ଡାଗ୍ଲା ଜିସୁ ମେଁନେ ନିଜର୍ ଗାଗ୍‌ଡ଼େନେ ରୁପ୍‌ ମନ୍ଦିର୍‌କେ ଆସୁଏଚେ ଆକେନ୍ ସାମୁଆଁ ବାଲିର୍‌ବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_22","073_2_22","JHN","2","22","22","ଜିସୁ ଗୁଏଚ ତଡ଼ିଆକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ସିସ୍ଇଂନେ ମନେ ପଡ଼େକେ ଜେ ମେଁ ଆକେନ୍ ବାସଙ୍ଗ୍‌ ବକେ । ତେସା ମେଇଂ ଦର୍ମ ସାସ୍ତର୍‌ ଆରି ଜିସୁନେ ସାମୁଆଁକେ ବିସ୍‍ବାସ୍‌ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_23","073_2_23","JHN","2","23","23","ଉଦାର୍ ପାଣ୍ତୁଏ ବେଲା ଯିରୂଶାଲମନ୍ନିଆ ଜିସୁ ଲେଃକ୍ନେବେଲା ଗୁଲେ ଜିସୁନେ ଇରିଆତୁଗ୍ କାମ୍ ସାପା କେଚେ ଜିସୁନେ ଡାଗ୍ରା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_24","073_2_24","JHN","2","24","24","ଡାଗ୍ଲା ଜିସୁ ମେଇଂନେ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ ଡାଗ୍ଲା ଜିସୁ ଆମେଇଂକେ ବଲ୍‌ ବାବ୍‌ରେ ମ୍ୟାଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN2_25","073_2_25","JHN","2","25","25","ମେଁଇଂନେ ବିସୟ୍‌ରେ ଆମେଇଂକେ ଜାଣ୍ଡେ ମେଃଡିଗ୍‌ ବାଲିର୍‌ନେ ଦର୍‌କାର୍ ଆଲେଃକେ ଣ୍ତୁ ଡାଗ୍ଲା ଜିସୁ ମେଁଇଂନେ ବିତ୍ରେନେ ସାମୁଆଁ ମ୍ୟାଃଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_1","073_3_1","JHN","3","1","1","ପାରୁସିଇଂନେ ବିତ୍ରେ ନୀକଦୀମ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ଜିଉଦି ନେତା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_2","073_3_2","JHN","3","2","2","ମେଁ ମିଡିଗ୍ ବେଲା ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, ଏ ଗୁରୁ ନାଁ ଜେ ଇସ୍‌ପର୍‌ବାନ୍ ପାଙ୍ଗ୍‍ଲେଃକ୍ନେ ଆରି ମୁଇଙ୍ଗ୍ ଗୁରୁ ଆକେନ୍ ନେ ସାପାରେ ମ୍ୟାନେଲେକେ, ଡାଗ୍ଲା ନାଁ ଆକେନ୍ ସାପା ଇରିଆତୁଗ୍ କାମ୍ ଡିଙ୍ଗ୍‌ନାବକେ, ଇସ୍‌ପର୍ ଏତେ ଆଲେଃଲା ଆତେନ୍‌ ସାପା ଜାଣ୍ଡେ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_3","073_3_3","JHN","3","3","3","ଜିସୁ ଆମେକେ ଉତର୍ ବିଃକେ ନେଙ୍ଗ୍ ଆନାକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ରେମୁଆଁ ଆରି ମୁଇଂତର୍‌ ଜନମ୍ ଆପାଙ୍ଗ୍ଲା ଜାଣ୍ଡେ ଇସ୍‌ପର୍‌ନେ ରାଇଜ୍ କିକେ ଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_4","073_3_4","JHN","3","4","4","ନୀକଦୀମ ଜିସୁକେ ସାଲିଆକୁକେ, ଡକ୍ରା ଡିଙ୍ଗ୍‌ଲା ରେମୁଆଁ ଡିରକମ୍ ଜନମ୍ ଡିଙ୍ଗ୍ ୟାଏ ? ମେଁ ମେଁନେ ମ୍ବାର୍‌ତର୍‌ ନିଜର୍ ଇୟାଙ୍ଗ୍ ସୁଲୁଏ ବିତ୍ରେ ଗାଚେ ଆରି ମୁଇଂତର୍‌ ଜନମ୍ ଡିଙ୍ଗ୍ ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN3_5","073_3_5","JHN","3","5","5","ଜିସୁ ଉତର୍ ବିଃକେ, “ସତ୍ ସତ୍ ନେଙ୍ଗ୍ ଆପେକେ ବାଲିର୍‌ଣ୍ଡିଂ, ଣ୍ଡିଆ ବାରି ଆତ୍ମାବାନ୍ ଆରି ମୁଇଂତର୍‌ ଜନମ୍ ଆଡିଙ୍ଗ୍‌ଲା ଜାଣ୍ଡେ ଇସ୍‌ପର୍‌ନେ ରାଜିନ୍ନିଆ ୱେଚା ଆୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_6","073_3_6","JHN","3","6","6","ଗାଗ୍‌ଡ଼େବାନ୍ ଆଣ୍ତିନେ ଜନମ୍ ଆତେନ୍‌ ଗାଗ୍‌ଡ଼େ; ଆତ୍ମାବାନ୍‌ ଆଣ୍ତିନେ ଜନମ୍ ଆତେନ୍‌ ଆତ୍ମା । ");
INSERT INTO gaq_vpl VALUES ("JN3_7","073_3_7","JHN","3","7","7","ସାପାରେକେ ଆରି ମୁଇଂତର୍‌ ଜନମ୍ ଡିଙ୍ଗ୍‌ନେ ପଡ଼େଏ ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍ ଆଣ୍ଡିନେ ବାଃଲିର୍‌ଣ୍ଡିଂ ଆତେନ୍‌‌ ଇରିଆତୁଗ୍ ଆଡିଙ୍ଗେପା । ");
INSERT INTO gaq_vpl VALUES ("JN3_8","073_3_8","JHN","3","8","8","ୱେଡ଼ିୟା ଆଣ୍ଡିପାକା ଇକ୍‌ଚା ଆତେନ୍‌ ପାକା ୱେଏ । ପେ ମାତର୍‌‌ ମେଁନେ ସାମୁଆଁ ଅଁପେୟାଏ ଡାଗ୍ଲା ଆତେନ୍‌ ଆଣ୍ଡିବାନ୍ ପାଙ୍ଗ୍‌ଏ ଆରି ଆଣ୍ଡିପାକା ୱେଡିଙ୍କେ ବାଲିର୍ ପେୟା ଣ୍ତୁ । ଆତ୍ମାବାନ୍‌ ଜନମ୍ ସାପା ରେମୁଆଁ ଦେତ୍‌ରକମ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN3_9","073_3_9","JHN","3","9","9","ନୀକଦୀମ ଜିସୁକେ ସାଲିଆକୁକେ “ଆତେନ୍‌ ଡିରକମ୍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN3_10","073_3_10","JHN","3","10","10","ଜିସୁ ନୀକଦୀମକେ ବାଲିର୍‌କେ “ନାଁ ଇଶ୍ରାୟେଲନେ ମୁଇଙ୍ଗ୍ ଗୁରୁ ଡିଂଚେ ଆକେନ୍ ସାମୁଆଁ ନାମ୍ୟାକେ ଣ୍ତୁ କି ? ");
INSERT INTO gaq_vpl VALUES ("JN3_11","073_3_11","JHN","3","11","11","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍ ଣ୍ଡିଙ୍ଗ୍ ନେ ମେଁନେ ମ୍ୟାନେଲେକେ ଆତେନ୍‌ ବାଲିର୍‌ନେଡିଙ୍ଗ୍‌ ମେଁନେ କେନେଲେଃକେ ଅଃତେନ୍‍ ବିସୟ୍‌ରେ ସାକି ନେବିଏ ଏଲେଡିଗ୍ ପେଇଂ ଜାଣ୍ଡେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_12","073_3_12","JHN","3","12","12","ନେଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌ ବିସୟ୍ ବାସଙ୍ଗ୍‌ଲା ପେଇଂ ବିସ୍‌ବାସ୍‌ ପେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ; କିତଙ୍ଗ୍ଇନିନେ ବିସୟ୍ ବାସଙ୍ଗ୍‌ଲା ଡିରକମ୍ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌ଏ ? ");
INSERT INTO gaq_vpl VALUES ("JN3_13","073_3_13","JHN","3","13","13","ଆଣ୍ତିନେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ କିତଙ୍ଗ୍‌ଇନିବାନ୍‌ ପାଙ୍ଗ୍ ଲେଃକେ ଆମେକେ ଆନ୍ତାର୍‌ଚେ ଆରି ଜାଣ୍ଡେ କିତଙ୍ଗ୍‌ଇନିନ୍ନିଆ ଆୱେଆର୍‌କେ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN3_14","073_3_14","JHN","3","14","14","ମୋଶା କଣ୍ଡାନ୍ନିଆ କଁସ୍ ଏତେ ଆଃରେବକ୍ନେ ବୁବଃକେ ଆଡ଼ାତ୍ରା ଆତଡ୍ୟାବକେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ଡିଙ୍ଗ୍ ଦେତ୍‌ରକମ୍ ଆଡ଼ାତ୍ରା ଆଃତଡ଼୍ୟା ଆଃରେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_15","073_3_15","JHN","3","15","15","ଡିରକମ୍ ଜାଣ୍ତେ ଡିଗ୍‌ ମେଁନେ ଅରିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ମାଡାନେ ପାରାନ୍‌ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN3_16","073_3_16","JHN","3","16","16","ଡାଗ୍ଲା ଇସ୍‌ପର୍ ମଞ୍ଚ୍‌ପୁର୍‌କେ ଅଃକେନ୍ ଆଲାଦ୍ ଡିଂକେ ଜେ ମେଁ ନିଜର୍ ମୁଇଂ ଆଃ ମାତର୍‌‌ ଉଙ୍ଗ୍‌ଡେକେ ଦାନ୍ ଡିଙ୍ଗ୍‌କେ ଡିରକମ୍ ଜାଣ୍ତେ ଡିଗ୍‌ ମେଁଅରିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ନସ୍ଟ ମାଡିଙ୍ଗ୍‌ଚେ ମାଡାନେ ପାରାନ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN3_17","073_3_17","JHN","3","17","17","ଇସ୍‌ପର୍ ମେଁନେ ଉଙ୍ଗ୍‌ଡେକେ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବେ ଆବକେ ଡାଗ୍ଲା ମଞ୍ଚ୍‌ପୁର୍‌ ଡିରକମ୍ ମେଁନେବାନ୍‌ ଉଦାର୍‌ ବାଏ ଆତେନ୍‌‌ସା ବେବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_18","073_3_18","JHN","3","18","18","ଜାଣ୍ତେକି ଉଙ୍ଗ୍‌ଡେନେ ଅରିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଆରି ବିଚାର୍‌ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ ଡାଗ୍ଲା ଜା ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ ମେଁନେ ବିଚାର୍‌ ଡିଙ୍ଗ୍ ଆଃଡାବକେ ଡାଗ୍ଲା ମେଁ ପର୍‌ମେସର୍‌‌ନେ ମୁଇଂ ଆଃ ଉଙ୍ଗ୍‌ଡେକେ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_19","073_3_19","JHN","3","19","19","ଆତେନ୍‌ ବିଚାର୍ ଦେକ୍‌ରକମ୍ ଡିଙ୍ଗ୍‌ଏ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ତାର୍‌କିଗ୍ ପାଙ୍ଗ୍ ଲେଃକେ ଡାଗ୍ଲା ରେମୁଆଁଇଂ ତାର୍‌କିଗ୍ ବାଟା ତାଂକିଗ୍‌କେ ଆଲାଦ୍ ଡିଂଆର୍‌କେ; ଡାଗ୍ଲା ମେଁଇଂନେ କାମ୍ ସାପା ଦଦିଆ । ");
INSERT INTO gaq_vpl VALUES ("JN3_20","073_3_20","JHN","3","20","20","ଦଦିଆଣ୍ଡ୍ରେ ତାର୍‌କିଗ୍‌କେ ଇଙ୍ଗ୍‌ଚେଏ । ମେଁନେ ଦଦ୍ୟା ଗୁନ୍ ଆଣ୍ଡେଙ୍ଗ୍ ତାର୍ ଆଣ୍ଡେଙ୍ଗ୍ ଡାଗ୍‌ଚେ ବୁଟଚେ ମେଁ ତାର୍‌କିଗ୍‌ନ୍ନିଆ ଆପାଙ୍ଗ୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_21","073_3_21","JHN","3","21","21","ଡାଗ୍ଲା ଜାଣ୍ଡେ ସତ୍‌ ବେବ‍ଆର୍‌ ଡିଂଏ, ମେଁ ତାର୍‌କିଗ୍‌ନ୍ନିଆ ପାଙ୍ଗ୍‌ ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ; ଡାଗ୍ଲା ମେଁନେ ସ୍ଲେନ୍ନିଆ ମେଁ ଜେ ଇସ୍‌ପର୍‌ନେ ଅଦିକାର୍‌ ଏନ୍ ସାମୁଆଁ ମେଁ ତାର୍‌କିଗ୍‌ନ୍ନିଆ ଆତ୍ନା ନ୍‌ସା ଇକ୍‌ଚା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_22","073_3_22","JHN","3","22","22","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆରି ମେଁନେ ସିସ୍ଇଂ ଜିଉଦା ପ୍ରଦେସ୍‌ନ୍ନିଆ ୱେଆର୍ଗେ ଆରି ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ମେଁଇଂନେ ଆଃତେ ଲେଃଚେ ଦିକ୍ୟା ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_23","073_3_23","JHN","3","23","23","ଜହନ୍‌ ଡିଗ୍ ଶାଲମ ଡାଗ୍ରା ଏନୋନନ୍ନିଆ ରେମୁଆଁଇଂକେ ଦିକ୍ୟା ବିଃଡିଂକେ ଡାଗ୍ଲା ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଜାବର୍ ଣ୍ଡିଆ ଲେଃକେ ବାରି ରେମୁଆଁ ପାଙ୍ଗ୍‌ଚେ ଦିକ୍ୟା ଡୁଂଡ ଆର୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_24","073_3_24","JHN","3","24","24","ଜହନ୍‌ ଆତେନ୍‌ ଜାକ କ‍ଏଦ୍‌ ଡୁଆନ୍ନିଆ ବନ୍ଦି ଡିଙ୍ଗ୍‌ ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_25","073_3_25","JHN","3","25","25","ମେଃସୁଆ ସାସ୍ତ୍ରିଇଂ ନିୟମ୍‌ ଅନୁସାରେ ପବିତ୍ର ଡିଙ୍ଗ୍‌ନେ ବିସୟ୍‌ରେ ଜହନ୍‌ନେ ସିସ୍ଇଂ ମୁଇଙ୍ଗ୍ ଜିଉଦି ରେମୁଆଁ ଆଃତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_26","073_3_26","JHN","3","26","26","ବାରି ସିସ୍‌ଇଂ ଜହନ୍‌ନେ ଡାଗ୍ରା ୱେଚେ ଜହନ୍‌କେ ବାସଙ୍ଗ୍‌କେ “ଏ ଗୁରୁ ଜା ଯର୍ଦ୍ଦନନେ ଇନୁମେତା ନାଁ ଆଃତେ ଲେଃକେ ଜାଣ୍ତେନେ ବିସୟ୍‌ରେ ନାଁ ବ୍ନାଲିର୍ ବାଲିର୍ ନାବକେ କେଲାନି ମେଁ ଦିକ୍ୟା ବିଃଡିଂକେ ଆରି ସାପାରେ ମେଁନେ ଡାଗ୍ରା ୱେଡିଙ୍ଗ୍ ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN3_27","073_3_27","JHN","3","27","27","ଜହନ୍‌ ଉତର୍ ବିଃକେ, “ଇସ୍‌ପର୍ ଆବିଲା, ରେମୁଆଁ ମେଃଡିଗ୍‌ ଆବା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_28","073_3_28","JHN","3","28","28","ନେଙ୍ଗ୍ ବାଲିର୍ ମ୍ୱକେ ସାମୁଆଁ ନେଙ୍ଗ୍ କିସ୍‌ଟ ଣ୍ତୁ ନେଙ୍ଗ୍ ମାତର୍‌‌ ମେଁଇଂନେ ସିସେନେ ଦୁତ୍ ରକମ୍ ପାଙ୍ଗ୍ ନ୍‌ଲେଃକେ । ଆକେନ୍ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ମ୍ୱକେ ଡାଗ୍‌ଚେ ପେଇଂ ନିଜେ ନିଜେ ସାକି । ");
INSERT INTO gaq_vpl VALUES ("JN3_29","073_3_29","JHN","3","29","29","ଜାଣ୍ଡେ ସେଲା ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଙ୍ଗିରେ ଡାଗ୍‌ଲା ଡାଗ୍ରା ତୁଆଁ ଲେଃକ୍ନେ ଙ୍ଗିରେନେ ରେମୁଆଁ ମେଁ ସାମୁଆଁ ଅଁଚେ ସାର୍ଦା ଡିଙ୍ଗ୍ଏ ଆକେନ୍ ଜାବର୍‌ ସାର୍ଦା ନେଙ୍ଗ୍ ଏବେ ବାଣ୍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_30","073_3_30","JHN","3","30","30","ଆମେକେ ଡିଲାଡିଗ୍ ମ୍ନା ଡିଙ୍ଗ୍‌ଲେ ଡାଗ୍ଲା ଆନେଙ୍ଗ୍ ଗଣ୍ଡା ଡିଙ୍ଗ୍‌ନେ ପଡ଼େଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN3_31","073_3_31","JHN","3","31","31","ଜାଣ୍ଡେ କିତଂବାନ୍‌ ପାଙ୍ଗ୍‌ଲେଃକେ ମେଁ ସାପାରେ ବାନ୍ ମ୍ନା; ଜାଣ୍ଡେ ମଞ୍ଚ୍‌ପୁର୍‌ବାନ୍‌ ଜନମ୍ ମେଁ ମଞ୍ଚ୍‌ପୁର୍‌; ଆରି ମେଁ ମଞ୍ଚ୍‌ପୁର୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍ଏ; ଡାଗ୍ଲା ଜାଣ୍ଡେ କିତଂବାନ୍‌ ପାଙ୍ଗ୍‌ଲେଃକେ ମେଁ ସପାରେନେ ବାନ୍ ମ୍ନା । ");
INSERT INTO gaq_vpl VALUES ("JN3_32","073_3_32","JHN","3","32","32","ମେଁ ଆଣ୍ତିନେ କେଲେଃକେ ଆରି ଦ୍ରିଗ୍‌ଲେଃକେ ଆତେନ୍‌ ବିସୟ୍‌ରେ ବାଲିର୍‌ଏ ଡାଗ୍ଲା ମେଁ ବାଲିର୍‌କ୍ନେ ସାମୁଆଁ ଜାଣ୍ଡେ ଆସାଃଆର୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN3_33","073_3_33","JHN","3","33","33","ଜାଣ୍ଡେ କି ମେଁନେ ସାମୁଆଁ ସାଃଏ, ମେଁ ଇସ୍‌ପର୍‌କେ ସତ୍ ଡାଗ୍‌ଚେ ମାନେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN3_34","073_3_34","JHN","3","34","34","ଡାଗ୍ଲା ଇସ୍‌ପର୍ ଆଜାକେ ବେବକେ ମେଁ ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ ବାଃଲିର୍‌ଏ, ଡାଗ୍‌ଲା ଇସ୍‌ପର୍ ଆମେକେ ଜାବର୍‌ ଆଃତେ ଆମେକେ ଆତ୍ମା ବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN3_35","073_3_35","JHN","3","35","35","ଆବା ଉଙ୍ଗ୍‌ଡେକେ ଆଲାଦ୍ ଡିଂଆର୍‌ଏ ବାରି ସାପା ବିସୟ୍ ମେଁନେ ନ୍ତି ବିଃ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN3_36","073_3_36","JHN","3","36","36","ଉଙ୍ଗ୍‌ଡେକେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁ ମାଡାନେ ପାରାନ୍ ବାଏ, ଡାଗ୍ଲା ଉଙ୍ଗ୍‌ଡେକେ ଅମାନି ଡିଙ୍ଗ୍ ମ୍ୟାୟାକ୍ନେ ରେମୁଆଁ ମାଡାନେ ପାରାନ୍ ଆବା ଣ୍ତୁ, ଆତେନ୍‌ ରେମୁଆଁଇଂକେ ଇସ୍‌ପର୍‌ନେ ରିସା ଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN4_1","073_4_1","JHN","4","1","1","ବାପ୍ତିଜକ ଜହନ୍‌ନେ ବାନ୍ ଜିସୁ ଜବର୍ ରେମୁଆଁଇଂକେ ସିସ୍ ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ଆରି ଆମେଇଂକେ ଦିକ୍ୟା ବିଃ ଡିଙ୍ଗ୍‌କ୍ନେ କବର୍ ଫାରୁଶୀଇଂ ଅଁଆର୍କେ ");
INSERT INTO gaq_vpl VALUES ("JN4_2","073_4_2","JHN","4","2","2","ଡାଗ୍ଲା ଜିସୁ ସତେଆ ରେମୁଆଁଇଂକେ ଦିକ୍ୟା ବିଃ ଆଡିଙ୍ଗ୍‌କେ ମେଁନେ ସିସ୍ଇଂ ରେମୁଆଁଇଂକେ ଦିକ୍ୟା ବିଃ ଡିଙ୍ଗ୍‌ଗେ ");
INSERT INTO gaq_vpl VALUES ("JN4_3","073_4_3","JHN","4","3","3","ଜିସୁ ମ୍ୟାୟାଲେଃକେ ଜେ ଫାରୁଶୀଇଂ ମେଁନେ ବିସୟ୍‌ରେ ଅଁଲେଃଆର୍‌କେ । ତେସା ଜିସୁ ଆତେନ୍‌ ବେଲା ଜିଉଦାପ୍ରଦେଶ୍‌ ଆନ୍‌ତାର୍‌ଚେ ବାରି ମୁଇଂତର୍‌ ଗାଲିଲୀନ୍ନିଆ ଆଣ୍ଡେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_4","073_4_4","JHN","4","4","4","ଜିସୁ ୱିଗ୍‌ନେ ବେଲା ମେଁ ସମରିଆ ଗାଲି ବିଚେ ୱେନେ ପଡ଼େକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_5","073_4_5","JHN","4","5","5","ତେଲା ମେଁ ୱେଚେ ଜାକୁବ୍‌ ନିଜର୍ ଉଙ୍ଗ୍‌ଡେ ଯୋଷେଫ କିକେ ଆଣ୍ତିନେ ମେତାଃଲିଜ ଦାନ୍ ବିବକେ । ଆତ୍‌ଡାଗ୍ରା ସମରିଆନେ ସୁଖାର ମ୍ନିକ୍ନେ ମୁଇଂ ଇନିନ୍ନିଆ ୱେଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_6","073_4_6","JHN","4","6","6","ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଜାକୁବ୍‌ନେ କୁଇଁସାଲ୍‌ ଲେଃକେ ଜିସୁ ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ଲାକାଃ ୱେଲେଃକେ ତେସା ମେଁ କୁଇଁସାଲ୍‌ ଡାଗ୍ରା କକେ ଆତେନ୍‌ ବେଲା ବାର୍‌ଗଣ୍ଟା ଡିଙ୍ଗ୍ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_7","073_4_7","JHN","4","7","7","ମୁଇଙ୍ଗ୍ ଶମିରୋଣୀୟ ସେଲାମ୍ବୁଏ ଣ୍ଡିଆ ଡୁଂୱିଗ୍‌ ନ୍‌ସା ପାଙ୍ଗ୍‌କେ ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଆନେଙ୍ଗ୍ ଣ୍ଡିଆ ଇକୁଡ଼ା ବିଃଲା ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_8","073_4_8","JHN","4","8","8","ଆତେନ୍‌ ବେଲା ଜିସୁନେ ସିସ୍ଇଂ ଚଙ୍ଗ୍‌ନେ ବିଆର୍‌ ନ୍‌ସା ଇନିନ୍ନିଆ ୱେଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_9","073_4_9","JHN","4","9","9","ଆତେନ୍‌ ଶମିରୋଣୀୟ ସେଲାମ୍ବୁଏ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ “ନାନେ ମୁଇଙ୍ଗ୍ ଜିଉଦି ବାରି ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ଶମିରୋଣୀୟ ସେଲାମ୍ବୁଏ ନାଁ ଡିରକମ୍ ନେଙ୍ଗ୍ ନ୍ତିବାନ୍‌ ଣ୍ଡିଆ ଉଗ୍ ନ୍‌ସା ସାଲିଆ ନାଡିଙ୍ଗ୍‌ ?” ଡାଗ୍ଲା ଜିଉଦିଇଂ ଶମିରୋଣୀୟଇଂନେ ଆଃତେ ବେବ‍ଆର୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN4_10","073_4_10","JHN","4","10","10","ଜିସୁ ଉତର୍ ବିଃକେ “ଇସ୍‌ପର୍ ମେଁନେ ବିଃ ୟାଏ ପେ ଜଦି ପେପାମ୍ୟା ଆରି ଜାଣ୍ଡେ ନାଁ ନ୍ତିବାନ୍‌ ଉଗ୍ ନ୍‌ସା ଚାଏଁଡିଙ୍ଗ୍‌କେ ଆମେକେ ଜଦି ନାପାମ୍ୟା ନାଁ ଆମେକେ ନାପାସାଲ୍ୟା ଆରି ମେଁ ପାରାନ୍ ଣ୍ଡିଆ ମ୍ପାବି ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_11","073_4_11","JHN","4","11","11","ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍‌ରୁ ଣ୍ଡିଆ ବାଗ୍ ନ୍‌ସା ନାଁନେ ଡାଗ୍ରା ମେଃଡିଗ୍‌ ବାଲ୍‌ଟି ଣ୍ତୁ ବାରି କୁଇଁସାଲ୍‌ ଲେଃ ସ୍ରିଲେଃକେ । ତେଲା ନାଁ ଆଣ୍ଡିବାନ୍ ଆତେନ୍‌ ପାରାନ୍ ଣ୍ଡିଆ ବା ନାଲେଃକେ ? ");
INSERT INTO gaq_vpl VALUES ("JN4_12","073_4_12","JHN","4","12","12","ନେଁନେ ନ୍ତା ଞ୍ଜା ଜାକୁବ୍‌ ଆକେନ୍ କୁଇଁସାଲ୍‌ ଆଗବକେ । ମେଁ ମେଁନେ ଉଙ୍ଗ୍‌ଡେଇଂ ଆରି ମେଁନେ ପସୁଇଂ ଆକେନ୍ କୁଇଁସାଲ୍‌ବାନ୍‌ ଣ୍ଡିଆ ଉଗ୍‌ଡିଙ୍ଗ୍‌ ଆର୍‌କେ ନାଁ ମେଁନେ ଜାକୁବ୍‌ନେବାନ୍‌ ମ୍ନା ?” ");
INSERT INTO gaq_vpl VALUES ("JN4_13","073_4_13","JHN","4","13","13","ଜିସୁ ଉତର୍ ବିଃକେ; “ଆକେନ୍ କୁଇଁସାଲ୍‌ନେ ଣ୍ଡିଆ ଜାଣ୍ତେ ଉଗ୍‌ଏ ଆମେକେ ଆରି ମୁଇଂତର୍ ଉଗ୍‌ଡ୍ୟା ଡଏ ");
INSERT INTO gaq_vpl VALUES ("JN4_14","073_4_14","JHN","4","14","14","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆଣ୍ତିନେ ଣ୍ଡିଆ ମ୍ବିଏ ଆତେନ୍‌ ଜାଣ୍ଡେ ଉଗ୍‌ଏ ଆମେ ଆରି ଅଃନା ଉଗ୍‌ଡ୍ୟା ଆଡ ଣ୍ତୁ ଆରି ନେଙ୍ଗ୍ ବିଣ୍ତିଂକ୍ନେ ଣ୍ଡିଆ ମେଁ ଗାଗ୍‌ଡ଼େ ମୁଇଙ୍ଗ୍ ପାରାନ୍ ସୁଗୁଆ ଜର୍‌ନାଡ଼ିଆ ରକମ୍ ଡିଙ୍ଗ୍‌ଏ । ଆତ୍‌ବାନ୍ ଉଗ୍‌ଲା ମେଁ ମାଡାନେ ପାରାନ୍ ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_15","073_4_15","JHN","4","15","15","ସେଲାମ୍ବୁଏ ଜିସୁକେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍‌ରୁ, ଆତେନ୍‌ ଣ୍ଡିଆ ଆନେଙ୍ଗ୍ ବିଃଲା ! ତେଲା ଆରି ଅଃନା ଆନେଙ୍ଗ୍ ଉଗ୍‌ଡ୍ୟା ଆଡ ଣ୍ତୁ; ଣ୍ଡିଆ ବାଗ୍ ନ୍‌ସା ଅଃକେନ୍ କୁଇଁସାଲ୍‌ନ୍ନିଆ ବାରି ପାଙ୍ଗ୍‌ନେ ଆପଡ଼େ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_16","073_4_16","JHN","4","16","16","ଜିସୁ ସେଲାମ୍ବୁଏକେ ବାସଙ୍ଗ୍‌କେ ୱେଲା ନାଁନେ ଆଣ୍ତାକେ ୱାଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଲା । ");
INSERT INTO gaq_vpl VALUES ("JN4_17","073_4_17","JHN","4","17","17","ସେଲାମ୍ବୁଏ ଜିସୁକେ ଉତର୍ ବିଃକେ ନେଙ୍ଗ୍‌ନେ ଆଣ୍ତା ଣ୍ତୁ । ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ ନାଁନେ ଆଣ୍ତା ଣ୍ତୁ ଆକେନ୍ ତ ଟିକ୍ ନାବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("JN4_18","073_4_18","JHN","4","18","18","ଡାଗ୍ଲା ନାନେ ମାଲିକ୍ଲିଗ୍‌ ଆଣ୍ତା ଲେଃକେ ଆରି ଏକ୍ରେ ନାନେ ଡାଗ୍ରା ଜା ଲେଃକେ ମେଁ ନାନେ ଆଣ୍ତା ଣ୍ତୁ; ଆକେନ୍ ସତ୍ ବାସଙ୍ଗ୍‌ ନାବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_19","073_4_19","JHN","4","19","19","ସେଲାମ୍ବୁଏ ଜିସୁକେ ବାଲିର୍‌କେ, “ଗୁରୁ, ନାଁ ଜେ ମୁଇଙ୍ଗ୍ ବାବବାଦି ଆକେନ୍ ନେଙ୍ଗ୍ କିକେଣ୍ଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN4_20","073_4_20","JHN","4","20","20","ନେଁନେ ଶମିରୋଣୀୟ ନ୍ତାଞ୍ଜାଇଂ ଆକେନ୍ କଣ୍ଡା ଆଡ଼ାତ୍ରା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ଆର୍କେ; ଡାଗ୍ଲା ପେଇଂନେ ଜିଉଦିଇଂ ବାଲିର୍ ଡିଙ୍ଗ୍‌ଆର୍କେ ଇସ୍‌ପର୍‌କେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେ ସମାନ୍ ଜାଗା ଡିଙ୍ଗ୍‌ଡିଂକେ ଯିରୁଶାଲମ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_21","073_4_21","JHN","4","21","21","ଜିସୁ ବାଲିର୍‌କେ “ଅ ସେଲାମ୍ବୁଏ ଆନେଙ୍ଗ୍ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ପା; ବେଲା ପିଙ୍ଗ୍‍ଚାଡିଂକେ ଉଡ଼ି ବେଲା ରେମୁଆଁ ନେଙ୍ଗ୍ ଆବା ଇସ୍‌ପର୍‌କେ ଆକେନ୍ କଣ୍ଡା ଆଡ଼ାତ୍ରା ଆରି ଯିରୁଶାଲମ୍‌ନ୍ନିଆ ବାରି ପାର୍‌ତନା ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN4_22","073_4_22","JHN","4","22","22","ପେ ଶମିରୋଣୀୟଇଂ ଜାଣ୍ତେନେ ଉପାସ୍ ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ସତେଆ ପେମ୍ୟାକେ ଣ୍ତୁ; ଡାଗ୍ଲା ନେନେ ଜିଉଦିଇଂ ମ୍ୟାନେଲେକେ ନେନେ ଜାଣ୍ତେନେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେଡିଙ୍ଗ୍‌କେ ଡାଗ୍ଲା ଜିଉଦିଇଂନେ ବାନ୍ ଉଦାର୍‌ ବାନେ ପାଙ୍ଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN4_23","073_4_23","JHN","4","23","23","ବେଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଆରି ଆତେନ୍‌ ବେଲା ପାଙ୍ଗ୍‌ଲେଃକେ ଉଡ଼ିବେଲା ନିଜେ ପବିତ୍ର ଆତ୍ମାନେ ବପୁରେ ରେମୁଆଁ ଆବା ଇସ୍‌ପର୍‌ନେ ଟିକ୍‌ନା ପର୍‌ମାନ୍‌ ବାଆର୍‌ଏ । ଆତେନ୍‌ ବେଲା ମେଇଂ ଆମେକେ ନିମାଣ୍ଡା ବାବ୍‌ରେ ବିତ୍ରେନେ ଆତ୍ମା ଆଃତେ ଆରାଦନା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ଦେକ୍‌ରକମ୍ ପାର୍‌ତନା ମେଁ ଚାଏଁଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_24","073_4_24","JHN","4","24","24","ଇସ୍‌ପର୍ ଆଃ ପରମାତ୍ମା । ସତ୍ ଆରି ଆତ୍ମାନ୍ନିଆ ବର୍‌ତି ଡିଙ୍ଗ୍‌ଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ମେଁନେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେ ଦର୍‌କାର୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_25","073_4_25","JHN","4","25","25","ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ଲେଃ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ । ମସୀହ ପାଙ୍ଗ୍‌ଏ । ଆତେନ୍‌ ବେଲା ମେଁ ଆନେକେ ସାପା ବିସୟ୍ ବୁଜେ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_26","073_4_26","JHN","4","26","26","ଜିସୁ ଆମେକେ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ: “ନେଙ୍ଗ୍ ମେଁ ଆଃ ଆତେନ୍‌ ରେମୁଆଁ ଆଃ ଏଃକେ ପେ ଏତେ ବାଲିର୍ ଡିଙ୍ଗ୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_27","073_4_27","JHN","4","27","27","ଦେକ୍ ରକମ୍ ବେଲା ମେଁନେ ସିସ୍ଇଂ ପାଙ୍ଗ୍‌ଚେ ଜିସୁ ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୁଏ ଆଃତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ଇରିଆତୁଗ୍ ଆର୍‌କେ, ଏଲେଡିଗ୍‌ ନାଁ ମେଁନେ ଚାଏଁନାଡିଙ୍ଗ୍‌, ଣ୍ତୁଲା ମେଃନ୍‌ସା ମେଁ ଏତେ ବାଲିର୍‌ନାଡିଙ୍ଗ୍‌, ଆକେନ୍ ଜାଣ୍ଡେ ଆମେକେ ସାଲିଆକୁ ନ୍‌ସା ଜା ଡିଗ୍ ସାହାସ୍ ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN4_28","073_4_28","JHN","4","28","28","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ସେଲାମ୍ବୁଏ ଆତ୍‌ଅରିଆ ମେଁନେ ଣ୍ଡିଆ ଗାରିଆ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଆନ୍ତାର୍ ବିଃଚେ ଇନି ବିତ୍ରେ ୱେଚେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁକେ ପେକେଏ ପାଙ୍ଗ୍‌ଲାପା । ");
INSERT INTO gaq_vpl VALUES ("JN4_29","073_4_29","JHN","4","29","29","ନେଙ୍ଗ୍ ପାରାନ୍‌ରେ ମେଁନେ ଡିଙ୍ଗ୍‌ମ୍ୱକେ ମେଁ ଆନେଙ୍ଗ୍ ସାପା ବାଲିର୍ ବିଃବକେ । ଆକ୍‌ମେଁ ଇଙ୍ଗ୍‌ଚା କିସ୍‌ଟ ଡିଙ୍ଗ୍‌ଲେଏ ? ");
INSERT INTO gaq_vpl VALUES ("JN4_30","073_4_30","JHN","4","30","30","ଆକ୍‌ବାନ୍ ରେମୁଆଁ ସହର୍‌ବାନ୍ ତାର୍‌ଚେ ଜିସୁନେ ଡାଗ୍ରା ୱେନେ ମୁଲେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_31","073_4_31","JHN","4","31","31","ଆକେନ୍ ବିତ୍ରେ ସିସ୍ଇଂ ଜିସୁକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, ଅ ଗୁରୁ, ମେଃନେଡିଗ୍‌ ଚଙ୍ଗ୍ ନ୍‌ସା କୁସାମୁତି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_32","073_4_32","JHN","4","32","32","ଡାଗ୍ଲା ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଡାଗ୍ରା ଆଣ୍ଡିନେ ବଲେ ଲେଃକେ ଆତେନ୍‌ ବିସୟ୍‌ରେ ପେଇଂ ମେଃଡିଗ୍‌ ପେମ୍ୟା ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_33","073_4_33","JHN","4","33","33","ସିସ୍ଇଂ ନିଜର୍ ନିଜର୍ ବିତ୍ରେ ସାଲ୍ୟାକୁ ଆର୍‌କେ ? “ଜାଣ୍ଡେ ଆମେକେ ମେଃଡିଗ୍‌ ବଲେ ଡୁଂପାଙ୍ଗ୍‌ ବିଃବକେ କି ?” ");
INSERT INTO gaq_vpl VALUES ("JN4_34","073_4_34","JHN","4","34","34","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଆନେଙ୍ଗ୍ ବେବକ୍ନେ ଣ୍ଡ୍ରେନେ ଇକ୍‌ଚା ପୁରନ୍‌ ଡିଙ୍ଗ୍‌ନେ ଆରି ଆମେକେ ବିଃବକ୍ନେ କାମ୍ ଆଃଡାନେ ଆକେନ୍ ଆଃ ନେଙ୍ଗ୍‌ନେ ବଲେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_35","073_4_35","JHN","4","35","35","ପେଇଂ ବାସଙ୍ଗ୍‌ ପେବକେ ଆରି ଅଁଆର୍କେ ଇଡ଼ିଙ୍ଗ୍ କିଆ ୱେନେ ବେଲା ପାଙ୍ଗ୍‌ଏ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଲିଜ ଆଣ୍ଡେଙ୍ଗ୍ ନିମାଣ୍ତା କିକେ କେଲାପା । ଏକ୍ରେ କିଆ ସାପା ବ୍ଲେ ଲେଃକେ ଆରି ୱେନ୍‌ସା ସମାନ୍ ଡିଙ୍ଗ୍ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_36","073_4_36","JHN","4","36","36","କିଆ ୱେଣ୍ଡ୍ରେକେ ଆଜ୍‌ରି ବିଡିଂକେ । ମେଁ ମାଡାନେ ପାରାନ୍ ନ୍‌ସା କିଆ ରାଃସିଙ୍ଗ୍‌ ଡିଂକେ । ଆତାନ୍‌ ବାନ୍‌ ବିଗ୍‌ଜାରେ ଆରି କିଆ ୱେଣ୍ଡ୍ରେ ମ୍ୱାୟା ସାର୍ଦା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN4_37","073_4_37","JHN","4","37","37","ଡାଗ୍ଲା ମୁଇଂଜା କିଆ ବିଗ୍‌ଏ ବାରି ବିନ୍‌ନେ ମୁଇଂଜା କିଆ ୱେଏ ଆକେନ୍ ସାମୁଆଁ ସତ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN4_38","073_4_38","JHN","4","38","38","ପେ ଆଣ୍ତିନେ ଲିଜନ୍ନିଆ କାମ୍ ଡିଙ୍ଗ୍ ପେବକେ ଣ୍ତୁ ଆତେନ୍‌ ୱେନ୍‌ସା ଆପେକେ ନେଙ୍ଗ୍ ବେମ୍ୱକେ । ବିନ୍ନେଡ୍ରେଇଂ ଆତ୍ ସ୍ଲେ ବଆର୍‌କେ ଡାଗ୍ଲା ପେଇଂ ଲାବ୍‌ ବାପେଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_39","073_4_39","JHN","4","39","39","ଆତେନ୍‌ ଇନିନେ ଗୁଲେ ଶମିରୋଣୀୟ ଜିସୁକେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ ଡାଗ୍ଲା ସେଲାମ୍ବୁଏ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌ ବକେ “ଅଃସେ ନେଙ୍ଗ୍ ମେଃନେ ସାପା ଡିଙ୍ଗ୍‌ମ୍ୱକେ ଆତେନ୍‌ ସାପା ସାମୁଆଁ ଜିସୁ ଆନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ବିକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_40","073_4_40","JHN","4","40","40","ଶମିରୋଣୀୟଇଂ ଜିସୁନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ମେଁଇଂନେ ଏତେ ଆରି ଉଡ଼ିସି ଲେଃନ୍‌ସା ଜିସୁକେ କୁସାମୁତି ଡିଙ୍ଗ୍‌କେ । ଜିସୁ ମେଁଇଂନେ ଆଃତେ ଆରି ବାର୍‌ସି ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_41","073_4_41","JHN","4","41","41","ଜିସୁନେ ବ୍ନାଲିର୍ ଅଁଚେ ଆରି ଗୁଲୁଏ ରେମୁଆଁ ଜିସୁକେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_42","073_4_42","JHN","4","42","42","ମେଇଂ ଆତେନ୍‌ ସେଲାମ୍ବୁଏକେ ବାସଙ୍ଗ୍‌କେ “ମାତର୍‌‌ ନାଁ ନାବାଲିର୍‌କ୍ନେ ଆନେକେ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ; ଜିସୁନେ ସାମୁଆଁ ନିଜେ ଅଁଚେ ମେଁ ଜେ ସତେଆ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଆମ୍ବ୍ରଣ୍ଡ୍ରେ ଆକେନ୍ ବିସ୍‌ବାସ୍ ଆନେକେ ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_43","073_4_43","JHN","4","43","43","ଆତ୍‌ଅରିଆ ବାର୍‌ସି ଲେଃଚେ ଜିସୁ ଗାଲିଲୀନ୍ନିଆ‍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_44","073_4_44","JHN","4","44","44","ଡାଗ୍ଲା ଜିସୁ ସେନୁଗ୍ ବାସଙ୍ଗ୍‌ବକେ “ମୁଇଂଜା ବାବବାଦି ନିଜର୍ ଦେସ୍‌ନ୍ନିଆ ମାନ୍ୟ ଆଡିଙ୍ଗ୍‌ଆର୍ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_45","073_4_45","JHN","4","45","45","ଗାଲିଲୀନେ ରେମୁଆଁଇଂ ଜିସୁକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଆର୍କେ ଡାଗ୍ଲା ନିସ୍ତାର୍ ପାଣ୍ତୁଏ ବେଲା ଯିରୁଶାଲାମ୍‌ନ୍ନିଆ ଜିସୁ ଡିଙ୍ଗ୍‌ବକ୍ନେ କାମ୍ ସାପା ମେଇଂ କେଲେଃଆର୍କେ । ଡାଗ୍ଲା ମେଇଂ ଡିଗ୍ ପାଣ୍ତୁଏ କ୍ଲା ୱେଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_46","073_4_46","JHN","4","46","46","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଗାଲିଲୀନେ କାନା ଇନିନ୍ନିଆ ଆଣ୍ତେ ୱିଗ୍‌କେ । ଆତ୍‌ଅରିଆ ମେଁ ଣ୍ତିଆଃକେ ଅଙ୍ଗୁର୍ ରସ୍‌ ଏତେ ଆଃରେବକେ । ଆତ୍‌ଅରିଆ ଲେଃକେ ମୁଇଂଜା ଇଃସାଙ୍ଗ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ କପୁର୍ନାହୁମନ୍ନିଆ ଆଃସି ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_47","073_4_47","JHN","4","47","47","ଜିସୁ ଜିଉଦାବାନ୍‌ ଗାଲିଲୀନ୍ନିଆ ପାଙ୍ଗ୍‌ଲେଃକେ ଡାଗ୍‌ଚେ ଅଁଚେ ଆତେନ୍‌ ଇଃସାଙ୍ଗ୍‌ ଜିସୁନେ ଡାଗ୍ରା ୱେକେ । ଗୁଏନେ ଆଡ଼ାତ୍ରା ଲେଃକ୍ନେ ମେଁନେ ଉଙ୍ଗ୍‌ଡେକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍ ନ୍‌ସା କପୁର୍ନାହୁମ ୱେନ୍‌ସା ମେଁ ଜିସୁକେ କୁସାମୁତି ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_48","073_4_48","JHN","4","48","48","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ; “ଚିନା ଆରି ଇରିଆତୁଗ୍ ସ୍ଲେ ସାପା ପେକେଲା ପେଇଂ ଅଃନା ଡିଙ୍ଗ୍ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_49","073_4_49","JHN","4","49","49","ଆତେନ୍‌ ସାସନ୍‌ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ବାସଙ୍ଗ୍‌କେ, “ଅ ମାପ୍ରୁ, ନେଙ୍ଗ୍ ଉଙ୍ଗ୍‌ଡେ ଗୁଏନେ ସେନୁଗ୍‌ ନେଙ୍ଗ୍ ଏତେ ପାଙ୍ଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("JN4_50","073_4_50","JHN","4","50","50","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ୱେଲା ନାଁନେ ଉଙ୍ଗ୍‌ଡେ ମ୍ବ୍ରଗେ ।” ଆତେନ୍‌ ରେମୁଆଁ ଜିସୁ ବାସଙ୍ଗ୍‌କ୍ନେ ସାମୁଆଁକେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଚେ ଆଣ୍ଡେ ୱିଗ୍‌ଗେ ");
INSERT INTO gaq_vpl VALUES ("JN4_51","073_4_51","JHN","4","51","51","ବାରି ମେଁ‍ ୱେ‍ନେ ବେଲା ମେଁନେ ଚାକର୍‌ଇଂ ଆମେକେ ଅବାଚେ ନାଁନେ ଗଡ଼େଅ ମ୍ବ୍ରଗେ ଡାଗ୍‌ଚେ ବାଲିର୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_52","073_4_52","JHN","4","52","52","ତେଲା ଆଣ୍ଡିନେ ବେଲା ମେଁ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ମେଁ ଗତିରେଇଂକେ ସାଲିଆକୁକେ । ଆତ୍‌ବାନ୍ ମେଇଂ ଆମେକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ ତୁଗୁଆ ଗଣ୍ଟେବେଲା ଆମେକେ ସାଃବା ଆନ୍ତାର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_53","073_4_53","JHN","4","53","53","ଆକ୍‌ବାନ୍ ମେଁନେ ବାଡ଼େ ବୁଜେକେ ଜେ ଆଣ୍ତିନେ ବେଲା “ନାଁନେ ଗଡ଼େଅ ମ୍ୱ୍ରଲେଃକେ” ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ବଗେ ଟିକ୍ ଆତେନ୍‌ ବେଲା ମ୍ୱ୍ରକେ । ଆକେନ୍ ଗଟ୍‌ନା ଇଡ଼ିଙ୍ଗ୍ ମେଁ ଆରି ମେଁନେ ପରିବାର୍‌ନେ ସାପାରେ ଜିସୁକେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN4_54","073_4_54","JHN","4","54","54","ଜିସୁ ଜିଉଦାବାନ୍‌ ଆର୍‌ମୁଇଂତର୍‌ ଗାଲିଲୀନ୍ନିଆ ପାଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଆକେନ୍ ଜିସୁନେ ମ୍ବାର୍‌ତର୍‌ ଇରିଆତୁଗ୍ କାମ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN5_1","073_5_1","JHN","5","1","1","ଏନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିଉଦିଇଂନେ ପାଣ୍ତୁଏଃନ୍ନିଆ କୁଡ଼େ ନ୍‌ସା ଜିସୁ ଯିରୁଶାଲାମ୍‌ନ୍ନିଆ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_2","073_5_2","JHN","5","2","2","ଯିରୂଶାଲମ୍‍ନେ “ମେଣ୍ଡା ର୍ଣ୍ଣସାଙ୍ଗ୍” ଡାଗ୍ରା ଏବ୍ରୀ ବ୍ନାସାରେ ବେଥ୍‌ଜାଥା ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ବନ୍ଦ୍‌ ଲେଃକେ । ବନ୍ଦ୍‌ନ୍ନିଆ ମାଲିକ୍ଲିଗ୍‌ ପାଉଚ୍‌ ଲେଃକେ ");
INSERT INTO gaq_vpl VALUES ("JN5_3","073_5_3","JHN","5","3","3","ଆରି ଆକେନ୍ ପାଉଚ୍‌ ଆଣ୍ଡେଙ୍ଗ୍ ଆଡ଼ାତ୍ରା ଗୁଲୁଏ ରଗ୍‌ଣ୍ଡ୍ରେ କାନା ଚଟା ଆରି ପକ୍ଷାଗାତିଇଂ ଲେଃମ୍ୟାକେ । ମେଇଂ ଣ୍ଡିଆ ୱେନେ ଉର୍‌ ଲେଃଆର୍‌କେ; ");
INSERT INTO gaq_vpl VALUES ("JN5_4","073_5_4","JHN","5","4","4","ଡାଗ୍ଲା ଉଡ଼ି ଉଡ଼ି ବେଲା ମାପ୍ରୁନେ ମୁଇଂ ଦୁତ୍ ବନ୍ଦ୍‌ନ୍ନିଆ ପାଙ୍ଗ୍‌ଚେ ଣ୍ଡିଆ ଆୱେ ମ୍ୟାକେ ଆରି ଣ୍ଡିଆ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜାଣ୍ଡେ ସେନୁଗ୍‌ ଆତ୍‌ଅରିଆ ୱେଚା ଡିଙ୍ଗ୍‌କେ ମେଁ ଡିଡିରକମ୍ ରଗ୍‌ ଡିଙ୍ଗ୍‌ଲେଃଲା ଡିଗ୍ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_5","073_5_5","JHN","5","5","5","ଆତ୍‌ଅରିଆ ୭୮ ମୁଆଁ ଜାକ ରଗ୍ ସାଃଲେକ୍ନେ ରେମୁଆଁ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_6","073_5_6","JHN","5","6","6","ଜିସୁ ଆତ୍‌ଅରିଆ ଆମେକେ ଡୁଲେଗ୍ ଲେଃକ୍ନେ କେ ମ୍ୟାଚେ ସାଲ୍ୟାକୁକେ, ରେମୁଆଁ ଜବର୍ ମୁଆଁ ସାଚେ ଆଃସି ଲେଃକେ । ତେସା ଜିସୁ ଆମେକେ ସାଲ୍ୟାକୁକେ; “ନାନେ ମେଁନେ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ନେ ଚାଏଁ ନାଡିଙ୍ଗ୍‌ ?” ");
INSERT INTO gaq_vpl VALUES ("JN5_7","073_5_7","JHN","5","7","7","ରଗ୍ ରେମୁଆଁ ଉତର୍ ବିଃକେ, “ଗୁରୁ, ଣ୍ଡିଆ ୱେନେବେଲା ବନ୍ଦ୍‌ ଡାଗ୍ରା ୱା ଡୁଂୱେ ନ୍‌ସା ନେଙ୍ଗ୍‌ନେ ଜାଣ୍ଡେ ଡିଙ୍ଗ୍ ଣ୍ତୁ । ନେଙ୍ଗ୍ ୱେନେ ଚାଏଁ ଡିଙ୍ଗ୍‌କ୍ନେ ବେଲା ଆରି ମୁଇଂଜା ଆତ୍‌ଅରିଆ ସେନୁଗ୍‌ ୱେଚାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN5_8","073_5_8","JHN","5","8","8","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ତଡ଼ିଆ ଆରି ନାନେ ସିଙ୍ଗ୍‌ଲା ଜଗ୍‌ଚେ ଅଲେଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN5_9","073_5_9","JHN","5","9","9","ଆତେନ୍‌ ଦାପ୍ରେ ରଗ୍‌ଣ୍ତ୍ରେ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌କେ ଆରି ମେଁନେ ସିଙ୍ଗ୍‌ଲା ଜଗ୍‌ଚେ ଅଲେଙ୍ଗ୍‌ନେ ମୁଲେକେ । ଆତେନ୍‌ ଦିନା ପୁଣ୍ତେନେ ଦିନା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_10","073_5_10","JHN","5","10","10","ତେସା ଜିଉଦିଇଂ ନିମାଣ୍ତା ଡିଙ୍ଗ୍ ଲେଃକ୍ନେ ରେମୁଆଁକେ ବାଲିର୍‌ଆର୍‌କେ ଏକେ ପୁଣ୍ତେନେ ଦିନା ସିଙ୍ଗ୍‌ଲା ଡୁଙ୍ଗ୍‍ଚେ ୱିଗ୍‌ନେ ନାନେ ନିଅମ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN5_11","073_5_11","JHN","5","11","11","ଡାଗ୍ଲା ମେଁ ଆମେଇଂକେ ଉତର୍ ବିଃକେ “ଜାଣ୍ଡେ ଆନେଙ୍ଗ୍ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌କେ ମେଁ ଆନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌କେ ନିଜର୍ ସିଙ୍ଗ୍‌ଲା ସାଃଚେ ଅଲେଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN5_12","073_5_12","JHN","5","12","12","ଜିଉଦିଇଂ ଆମେକେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଜାଣ୍ଡେ ଆନାକେ ଆକେନ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବାସଙ୍ଗ୍‌କେ ଆତେନ୍‌ ରେମୁଆଁ ଜାଣ୍ଡେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN5_13","073_5_13","JHN","5","13","13","ଡାଗ୍ଲା ମେଁ ଜାଣ୍ଡେ ଆତେନ୍‌ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁ ମ୍ୟା ଆଲେଃଗେ ଣ୍ତୁ ଡାଗ୍ଲା ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଗୁଲେ ରେମୁଆଁ ଗହଲି ଲେଃଆର୍‌ଲା ଜିସୁ ଆତ୍‌ବାନ୍ ବିନେ ୱେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_14","073_5_14","JHN","5","14","14","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁକେ ମନ୍ଦିର୍ ବିତ୍ରେ କେଚେ ବାସଙ୍ଗ୍‌କେ; “ଦ୍ରିଗ୍ ନା ଏକେ ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌ନାଲେଃକେ ଆରି ପାପ୍ ଆଡିଙ୍ଗ୍‌ଗେ ନାମଃ; ଣ୍ତୁଲା ନାନେ ଜାବର୍ ଅନିଷ୍ଟ ଡିଙ୍ଗ୍‌ୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN5_15","073_5_15","JHN","5","15","15","ନିମାଣ୍ତା ଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁ ଦାପ୍ରେ ଦାପ୍ରେ ୱେଚେ ଜିଉଦିଇଂକେ ବାସଙ୍ଗ୍‌କେ ଜେ ଜାଣ୍ଡେ ଆମେକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍ ବକେ ମେଁ ଜିସୁ । ");
INSERT INTO gaq_vpl VALUES ("JN5_16","073_5_16","JHN","5","16","16","ଜିସୁ ପୁଣ୍ତେନେ ଦିନାଲେ ଦେକ୍ ରକମ୍ କାମ୍ ଡିଙ୍ଗ୍‌ଡିଂକ୍ନେସା ଜିଉଦିଇଂ ଜିସୁନେ ଆଡ଼ାତ୍ରା ନିନ୍ଦା ଆଡିଙ୍ଗ୍‌ନେ ଆରାମ୍ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_17","073_5_17","JHN","5","17","17","ମାତର୍‌‌ ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ; “ନେଙ୍ଗ୍‌ନେ ଆବା ଇସ୍‌ପର୍ କାଲାଆଃ କାମ୍ ଡିଙ୍ଗ୍‌ଡିଙ୍କେ; ଆନେଙ୍ଗ୍ ଡିଙ୍ଗ୍ ଦେତ୍‌ରକମ୍ କାମ୍ ଡିଙ୍ଗ୍‌ନେ ପଡ଼େଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN5_18","073_5_18","JHN","5","18","18","ଆକେନ୍ ସାମୁଆଁ ନ୍‌ସା ଜିଉଦିଇଂ ଜିସୁକେ ବାଗୁଏଃ ନ୍‌ସା ଆରି ଜାବର୍ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ନେ ମୁଲେଆର୍‌କେ ଡାଗ୍ଲା ମେଁ ପୁଣ୍ତେନେ ଦିନା ନିଅମ୍ ମାନେଃ ଆଡିଙ୍ଗ୍‌କେ ମାତର୍‌‌ ଆତେନ୍‌ ଣ୍ତୁ ଡାଗ୍ଲା ଇସ୍‌ପର୍‌କେ ନେଙ୍ଗ୍ ଆବା ଡାଗ୍‌ଚେ ବାଲିର୍‌ଚେ ମେଁ ନିଜେ ନିଜେକେ ଇସ୍‌ପର୍‌ନେ ଆଃତେ ସମାନ୍ ଆଡିଙ୍ଗ୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_19","073_5_19","JHN","5","19","19","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଉଙ୍ଗ୍‌ଡେ ମେଁ ନିଜେ ମେଃଡିଗ୍ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ମେଁନେ ଆବା ମେଁନେ ଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌‌ଆ କେଚେ ଡିଙ୍ଗ୍‌ଏ ଡାଗ୍ଲା ଆବା ଆଣ୍ତିନେ ଡିଙ୍ଗ୍‌ମ୍ୟାକ୍ନେ କେଚେ ଉଙ୍ଗ୍‌ଡେ ଆତେନ୍‌ ଆଃ ଡିଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_20","073_5_20","JHN","5","20","20","ଡାଗ୍ଲା ଆବା ଉଙ୍ଗ୍‌ଡେକେ ଆଲାଦ୍‌ ଡିଙ୍ଗ୍‌ଏ ଆରି ନିଜେ ମେଁ ମେଃନେ ଗଟେଏ, ଆତେନ୍‌ ସାପା ଉଙ୍ଗ୍‌ଡେକେ ଆସୁଏ ଆରି କ୍ମେବାନ୍‌ ମ୍ନାନେ କାମ୍ ଆଣ୍ତେଙ୍ଗ୍ ଡିଙ୍ଗ୍ ନ୍‌ସା ମେଁ ଆମେକେ ଆସୁଏ ଆରି ପେଇଂ ସାପାରେ ଇରିଆତୁଗ୍ ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_21","073_5_21","JHN","5","21","21","ଆବା ଡିରକମ୍ ଗ୍ୱେରେଇଂକେ ଆଃତଡ଼୍ୟାଏ ଆରି ଜିବନ୍‌ ବିଃନେ ଦେତ୍‌ରକମ୍ ଉଙ୍ଗ୍‌ଡେ ଡିଙ୍ଗ୍ ଆଜାକେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ ଆମେକେ ଜିବନ୍‌ ବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_22","073_5_22","JHN","5","22","22","ଆବା ନିଜେ ଆରି ଜାଣ୍ତେନେ ବିଚାର୍ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ । ବିଚାର୍ ଡିଙ୍ଗ୍ ନ୍‌ସା ମେଁ ସାପାଜାକ ମେଁନେ ଉଙ୍ଗ୍‌ଡେ ଆଡ଼ାତ୍ରା ଅଦିକାର୍ ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_23","073_5_23","JHN","5","23","23","ଆବାକେ ଡିରକମ୍ ମାନେଃ ଆଃରେ ଉଙ୍ଗ୍‌ଡେକେ ଡିଙ୍ଗ୍ ଦେତ୍‌ରକମ୍ ସାପାରେ ମାନେଃ ଆର୍‌ଏ, ଜାଣ୍ଡେ ଉଙ୍ଗ୍‌ଡେକେ ଆମାନେ ଆର୍‌ ଣ୍ତୁ ଆମେକେ ବେବକ୍ନେଣ୍ଡ୍ରେ ଆବାକେ ଡିଗ୍ ଆମାନେ ଆର୍‌ଏ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN5_24","073_5_24","JHN","5","24","24","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଜାଣ୍ତେ କି ନେଙ୍ଗ୍ ସାମୁଆଁକେ ଦ୍ରିଗ୍ଏ ଆରି ନେଙ୍ଗ୍‌ ବେଣ୍ଡିଂକ୍ନେ ରେମୁଆଁକେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ, ମେଁ ମାଡାନେ ପାରାନ୍ ଲାବ୍‌ ଡିଙ୍ଗ୍ଏ । ମେଁ ବିଚାର୍‌ନେ ସାମ୍‌ନାନ୍ନିଆ ଆପାଙ୍ଗ୍ ଣ୍ତୁ, ଡାଗ୍ଲା ମେଁ ଗୁଏନ୍ନିଆ ପୁଆଃଚେ ପାରାନ୍‌ନ୍ନିଆ ୱେଚା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_25","073_5_25","JHN","5","25","25","ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂକେ, ବେଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ, ଆତେନ୍‌ ବେଲା ପିଙ୍ଗ୍‌ଚାକେ ଉଡ଼ିବେଲା ଗୁଏକ୍ନେ ରେମୁଆଁଇଂ ଇସ୍‌ପର୍ ଉଙ୍ଗ୍‌ଡେନେ ସାମୁଆଁ ଦ୍ରିଗ୍ଆର୍‌ଏ ଆରି ଜାଣ୍ଡେଇଂ ଆତେନ୍‌ ଅଁଆର୍‌ଏ ମେଇଂ ମ୍ୱ୍ର ଆଃରେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_26","073_5_26","JHN","5","26","26","ଡାଗ୍ଲା ଆବା ଡିରକମ୍ ପାରାନ୍‌ ମ୍ବ୍ରକେ, ଦେତ୍‌ରକମ୍ ମେଁ ଉଙ୍ଗ୍‌ଡେକେ ଡିଗ୍ ପାରାନ୍‌ ମ୍ବ୍ରନେ ବିଃବକେ; ");
INSERT INTO gaq_vpl VALUES ("JN5_27","073_5_27","JHN","5","27","27","ବାରି ମେଁ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଡିଂଲା ଆମେକେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_28","073_5_28","JHN","5","28","28","ଆକ୍‌ଅରିଆ ଇରିଆତୁଗ୍ ଆଡିଙ୍ଗେପା ନାମଃ । ବେଲା ପାଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ ଉଡ଼ି ବେଲା ଗୁଏକ୍ନେ ରେମୁଆଁଇଂ ସାପାରେ ମେଁନେ ସାମୁଆଁ ଅଁଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_29","073_5_29","JHN","5","29","29","ଆରି ରାଚ୍ୟାବାନ୍‌ ତଡ଼୍ୟା ପାଙ୍ଗ୍ଆର୍‌ଏ । ଜାଣ୍ଡେଇଂ ସତ୍ ଦରମ୍‌ ଡିଙ୍ଗ୍ ବକେ ମେଇଂ ତଡ଼୍ୟାଚେ ମ୍ୱ୍ରଆର୍‌ଏ । ଦଦ୍ୟା ରେମୁଆଁଇଂ ତଡ଼ିଆଆର୍‌ଏ ବାରି ଡଣ୍ଡ୍‍ ବାଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_30","073_5_30","JHN","5","30","30","ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ନିଜର୍ ଇକ୍‌ଚାରେ ମେଁନେ ଡିଙ୍ଗ୍ ନାୟା ଣ୍ତୁ । ମାତର୍‌‌ ଇସ୍‌ପର୍‌ନେ ଆଦେସ୍ ଏତେ ନେଙ୍ଗ୍ ବିଚାର୍ ଣ୍ଡିଂଏ । ନେଙ୍ଗ୍‌ନେ ବିଚାର୍ ସତ୍‌, ଡାଗ୍ଲା ନେଙ୍ଗ୍ ନିଜର୍ ଇକ୍‌ଚାରେ ପୁରନ୍‌ ଡିଙ୍ଗ୍ ନ୍‌ସା ନେଙ୍ଗ୍ ଚେସ୍‌ଟା ନାଡିଙ୍ଗ୍ ଣ୍ତୁ; ଡାଗ୍ଲା ମାତର୍‌ ନେଙ୍ଗ୍‌ନେ ବେବକ୍ନେ ରେମୁଆଁନେ ଇକ୍‌ଚା ପୁରନ୍‌ ଣ୍ଡିଂଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_31","073_5_31","JHN","5","31","31","ଜଦି ନେଙ୍ଗ୍ ନିଜର୍ ବିସୟ୍‌ରେ ନିଜେ ସାକି ମ୍ୱିଏ ତେଲା ନେଙ୍ଗ୍‌ନେ ସାକି ଗୁଲୁଏ ଡାଗ୍‌ଚେ ପର୍‌ମାନ୍‌ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN5_32","073_5_32","JHN","5","32","32","ଡାଗ୍‌ଲା ବିନ୍‍ଣ୍ଡ୍ରେ ମୁଇଂଜା ନେଙ୍ଗ୍ ନ୍‌ସା ସାକି ବିଃଡିଙ୍ଗ୍‍କେ ଆରି ନେଙ୍ଗ୍ ମ୍ୟାୟାଏ ନେଙ୍ଗ୍‌ନେ ବିସୟ୍‌ରେ ମେଁ ଆଣ୍ତିନେ ବାଲିର୍ ଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ସତ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN5_33","073_5_33","JHN","5","33","33","ପେଇଂ ଜହନ୍‌ନେ ଡାଗ୍ରା ଦୁତ୍ ବେପେବକେ ଆରି ମେଁ ସତ୍ ବିସୟ୍‌ରେ ସାକି ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_34","073_5_34","JHN","5","34","34","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ରେମୁଆଁ ବାନ୍ ସାକ୍ୟ ଗ୍ର‍ଅନ୍‌ ନାଡିଙ୍ଗ୍ ଣ୍ତୁ ମାତର୍ ପେଇଂ ଡିରକମ୍ ପରିତ୍ରାନ୍‍ ପେବାଏ, ଆତେନ୍‌‌ସା ଆକେନ୍ ସାପା ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("JN5_35","073_5_35","JHN","5","35","35","ଜହନ୍‌ ଲେଃକେ ମୁଇଙ୍ଗ୍ ଡୁଆକ୍ନେ ତାର୍‌କିଗ୍ କୁପିସ ଲେଃକେ । ଉଡ଼ିସି ନ୍‌ସା ଜହନ୍‌ନେ ତାର୍‌କିଗ୍‌ନ୍ନିଆ ତାର୍‌କିଗ୍ ଡିଙ୍ଗ୍ ନ୍‌ସା ପେଇଂ ଇକ୍‌ଚା ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_36","073_5_36","JHN","5","36","36","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ବିସୟ୍‌ରେ ଜହନ୍‌ନେ ବାନ୍ ଜାବର୍ ବପୁସାଲି ମୁଇଙ୍ଗ୍ ସାକି ଲେଃକେ । ଆବା ଇସ୍‌ପର୍‌ନେ ଆଦେସ୍ ଇସାବ୍‌ରେ ନେଙ୍ଗ୍ ଆଣ୍ଡିନେ ସାପା କାମ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡିଂକେ, ଆତେନ୍‌ ସାପା ନେଙ୍ଗ୍ ନ୍‌ସା ଗୁଲେ ସାକି । ଆତେନ୍‌ ସାପା ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡିଂକେ ଜେ ଆନେଙ୍ଗ୍ ଇସ୍‌ପର୍ ବେବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN5_37","073_5_37","JHN","5","37","37","ଆନେଙ୍ଗ୍ ବେବକ୍ନେ ଆବା ଇସ୍‌ପର୍ ଡିଙ୍ଗ୍ ନେଙ୍ଗ୍ ନ୍‌ସା ସାକ୍ୟ ବିଡିଙ୍ଗ୍‌କେ । ପେଇଂ ମେଁନେ ସାମୁଆଁ ପେଦ୍ରିଗ୍‌କେ ଣ୍ତୁ ମାତର୍‌ ଆମେକେ ପେକେକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN5_38","073_5_38","JHN","5","38","38","ବାରି ପେ ମେଁନେ ବ୍ନାଲିର୍ ପେ ଜିବନ୍‌ନ୍ନିଆ ପେବକେ ଣ୍ତୁ । ଡାଗ୍ଲା ମେଁ ଆଜାକେ ବେବକେ ଆମେକେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ ");
INSERT INTO gaq_vpl VALUES ("JN5_39","073_5_39","JHN","5","39","39","ସାସ୍ତର୍‌ଇଂଅରିଆ ମାଡାନେ ଜିବନ୍‌ ମିଲେଏ ଡାଗ୍‌ଚେ ମେଁନେ ଡିଙ୍ଗ୍‌ଚେ ଆତେନ୍‌ ସାପା ପେ ପଡ଼େ ପେଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ସାପା ସାସ୍ତର୍‌ ନେଙ୍ଗ୍ ବିସୟ୍‌ରେ ସାକି ବିଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_40","073_5_40","JHN","5","40","40","ଡାଗ୍ଲା ଜିବନ୍ ବାନ୍‌ସା ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍ ନ୍‌ସା ପେଇଂ ଇକ୍‌ଚା ପେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN5_41","073_5_41","JHN","5","41","41","ନେଙ୍ଗ୍ ରେମୁଆଁଇଂନେ ପ୍ରସଂସା ନାତୁର୍କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN5_42","073_5_42","JHN","5","42","42","ଡାଗ୍ଲା ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ; ପେଇଂ ଡିରକମ୍ ରେମୁଆଁ ବାରି ପେଇଂନେ ବିତ୍ରେ ଇସ୍‌ପର୍‌ନେ ଆଡ଼ାତ୍ରା ଆଲାଦ୍ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN5_43","073_5_43","JHN","5","43","43","ଆବା ଇସ୍‌ପର୍‌ନେ ମ୍ନିରେ ଅଦିକାର୍ ବାଚେ ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‍ନ୍ଲେଃକେ ଡାଗ୍ଲା ପେଇଂ ଆନେଙ୍ଗ୍ ଗ୍ର‍ଅନ୍‌ ପେଡିଙ୍ଗ୍‍କେ ଣ୍ତୁ । ଡାଗ୍ଲା ମୁଇଂଜା ବିନ୍ ମେଁ ନିଜର୍ ଇକ୍‌ଚାରେ ପାଙ୍ଗ୍‌ଲା । ଆମେକେ ପେ ଗ୍ର‍ଅନ୍‌ ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_44","073_5_44","JHN","5","44","44","ପେଇଂ ପେନେ ବାନ୍ ପ୍ରସଂସା ବାନ୍‌ସା ବଲ୍‌ ପେବାଏ । ଡାଗ୍ଲା ନିଜେ ପର୍‌ମେସର୍‌ନେ ଡାଗ୍ରା ବାନ୍ ଆଣ୍ଡିନେ ପ୍ରସଂସା ପାଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ବାନ୍‌ସା ପେ ବିଲ୍‌କୁଲ୍‌ ଚେସ୍‌ଟା ପେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ତେଲା ପେ ଆନେଙ୍ଗ୍ ଡିରକମ୍ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ ପେୟାଏ ? ");
INSERT INTO gaq_vpl VALUES ("JN5_45","073_5_45","JHN","5","45","45","ଆତେନ୍‌ ମେଃଡିଙ୍ଗ୍‌ଲେଃ ମେଁନେ ଆଡିଙ୍ଗ୍‌ପା ଣ୍ତୁ, ଜାଣ୍ଡେ ପେଇଂନେ ବିରଦ୍‌ରେ ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଆବାନେ ଡାଗ୍ରା ମ୍ବାସଙ୍ଗ୍‌ଏ । ବାରି ଆଣ୍ତିନେ ମୋଶାନେ ଆଡ଼ାତ୍ରା ପେଇଂ ବିସ୍‌ବାସ୍‌ ପେବକେ, ମେଁ ମାତର୍‌‌ ପେନେ ଆଡ଼ାତ୍ରା ଦସ୍ ଆଃଡିଙ୍ଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN5_46","073_5_46","JHN","5","46","46","ପେଇଂ ଜଦି ସତେଆଃ ମୋଶାକେ ବିସ୍‌ବାସ୍ ପେପାଡିଙ୍ଗ୍‌ ଆନେଙ୍ଗ୍ ଡିଗ୍ ବିସ୍‌ବାସ୍ ପେପାଡିଙ୍ଗ୍‌ ଡାଗ୍ଲା ମୋଶା ନେଙ୍ଗ୍ ବିସୟ୍‌ରେ ଗୁଆର୍ ବକେ ");
INSERT INTO gaq_vpl VALUES ("JN5_47","073_5_47","JHN","5","47","47","ଡାଗ୍ଲା ମୋଶା ଆଣ୍ତିନେ ଗୁଆର୍‌ବକେ, ଆତ୍‌ଅରିଆ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ, ନେଙ୍ଗ୍ ମେଁନେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଆତେନ୍‌ ଡିରକମ୍ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN6_1","073_6_1","JHN","6","1","1","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଗାଲିଲୀ ବା ତିବିରିଆ କେଣ୍ତିଆନେ ଇନୁମେତା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_2","073_6_2","JHN","6","2","2","ଗୁଲେ ରେମୁଆଁ ଜିସୁନେ ପ୍ଲା ୱେ ଡିଂଆର୍‌କେ ଡାଗ୍ଲା ଜିସୁ ମେଁନେ ଇରିଆତୁଗ୍ ବପୁ ଏତେ ଆଃସିଲେକ୍ନେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ତା ଆଡିଙ୍ଗ୍‌ନେ ମେଇଂ କିକେ ଡିଂଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_3","073_6_3","JHN","6","3","3","ଜିସୁ ମୁଇଙ୍ଗ୍ କାଣ୍ଡା ଆଡ଼ାତ୍ରା ୱେଚେ ସିସ୍ଇଂ ଆଃତେ କକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_4","073_6_4","JHN","6","4","4","ଆତେନ୍‌ ବେଲା ଜିଉଦିଇଂନେ ଉଦାର୍ ପାଣ୍ତୁଏ ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_5","073_6_5","JHN","6","5","5","ମେଁନେ ଡାଗ୍ରା ଗୁଲୁଏ ରେମୁଆଁ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ଜିସୁ ପିଲିପ୍‌କେ ସାଲ୍ୟାକୁକେ: “ଅଃକେନ୍ ରେମୁଆଁଇଂ ନ୍‌ସା ଆଣ୍ଡିବାନ୍ ଗୁଲୁଏ ରୁଟି ନେବ୍ୟାର୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN6_6","073_6_6","JHN","6","6","6","ପିଲିପ୍‌କେ ପରିକ୍ୟା ଡିଙ୍ଗ୍ ନ୍‌ସା ଜିସୁ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ବକେ । ଡାଗ୍ଲା ମେଁ ନିଜେ ମେଁନେ ଡିଙ୍ଗ୍‌ଏ ମ୍ୟାଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_7","073_6_7","JHN","6","7","7","ପିଲିପ୍‌ ଉତର୍ ବିକେ “ସାପାରେକେ ଇତୁଡ଼ା ମେଃଡିଗ୍ ଆଚଙ୍ଗ୍ ନ୍‌ସା ମ୍ୱାର୍‌ସବାନ୍‌ ଜବର୍ ରୁପା ଡାବୁନେ ରୁଟି ବ୍ୟାଆର୍‌ଲା ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_8","073_6_8","JHN","6","8","8","ଜିସୁନେ ବିନ୍ ମୁଇଂଜା ସିସ୍ ପିତର୍‌ନେ ବୟାଁ ଆନ୍ଦ୍ରିୟ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("JN6_9","073_6_9","JHN","6","9","9","“ଆକ୍‌ଅରିଆ ମୁଇଙ୍ଗ୍ ଗଡ଼େଅ ଲେଃକେ ମେଁନେ ଡାଗ୍ରା ମାଲିକ୍ଲିଗ୍ ରୁଟି ମ୍ବାକ୍ଲିଗ୍ ଆଡ଼ ଲେଃକେ, ଡାଗ୍ଲା ଅଃକେନ୍ ରେମୁଆଁ ନ୍‌ସା ଆତେନ୍‌ ଆଅଣ୍ଟେ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_10","073_6_10","JHN","6","10","10","ଜିସୁ ସିସ୍‌ଇଂକେ ବାସଙ୍ଗ୍‌କେ: “ରେମୁଆଁଇଂକେ ଆଃକବିପା ।” ଆତେନ୍‌ ଟାନ୍‌ନ୍ନିଆ ଜାବର୍ ଚେଃମୁଆଁ ଲେଃକେ । ଆତେନ୍‌ ଚେଃମୁଆଁ ଆଡ଼ାତ୍ରା ସାପାରେ କ‍ଆର୍‌କେ । ଆତ୍‌ଅରିଆ ମାଲ୍‌ ଅଜାର୍‌ ଙ୍ଗିର୍‌ବଏ ରେମୁଆଁ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_11","073_6_11","JHN","6","11","11","ଜିସୁ ରୁଟି ଡୁଙ୍ଗ୍‌ୱେଚେ ଇସ୍‌ପର୍‌କେ ଦନ୍ୟବାଦ୍ ବିଃଚେ ଆତ୍‌ଅରିଆ କଲେଃକ୍ନେ ରେମୁଆଁଇଂ ବିତ୍ରେ ବାଟାବିଃକେ । ମ୍ୱାକ୍ଲିଗ୍‌ ଆଃଡ଼ ଡିଙ୍ଗ୍ ଦେତ୍‌ରକମ୍ ମେଁ ବାଟାକେ । ମେଇଂ ଗୁଲେ ଚଙ୍ଗ୍‌ନେ ବାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_12","073_6_12","JHN","6","12","12","ମେଇଂ ସାପାରେ ଚଙ୍ଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍ଇଂକେ ବାସଙ୍ଗ୍‌କେ: “ମେଁନେ ସାପା ଲୁଆଁ ଲେଃକେ ଆତେନ୍‌ ସାପା ରାସିଂଚେ ବପା ଡିରକମ୍ ମେଃଡିଗ୍ ଦଦ୍ୟା ଆଡିଙ୍ଗ୍ ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_13","073_6_13","JHN","6","13","13","ରେମୁଆଁ ମାଲିକ୍ଲିଗ୍ ରୁଟି ଚଙ୍ଗ୍‍ଚେ ଉଡ଼ି ଲୁଆଁ ଲେଃକେ ସିସ୍‌ଇଂ ଆତେନ୍‌ ସାପା ରାସିଂଚେ ତ୍ମାକ୍ଲିଗ୍ ଆଣ୍ତ୍ରା ବର୍ତି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_14","073_6_14","JHN","6","14","14","ଜିସୁନେ ଆକେନ୍ ଇରିଆତୁଗ୍ କାମ୍ କେଚେ ରେମୁଆଁ ବାସଙ୍ଗ୍‌କେ “ଆଣ୍ଡିନେ ବାବବାଦି ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ପାଙ୍ଗ୍‌ନେ ଲେଃକେ କ୍ମେ ସତେଆଃ ମେଁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_15","073_6_15","JHN","6","15","15","ରେମୁଆଁଇଂ ଜିସୁକେ ଜବର୍‌ଜସ୍ତି ଇଃସାଙ୍ଗ୍‌ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ସାଃନ୍‌ସା ୱେଡିଙ୍ଗ୍ ଆର୍‌କେ ଡାଗ୍‌ଚେ ମ୍ୟାଚେ ଜିସୁ ମୁଇଂଜାଆ ଡାଗ୍ରାନେ କଣ୍ତାପାକା ଅଲେଙ୍ଗ୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_16","073_6_16","JHN","6","16","16","ମିଡିଗ୍ ୱେଲା ଜିସୁନେ ସିସ୍ଇଂ କେଣ୍ତିଆ ଆଃଡା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_17","073_6_17","JHN","6","17","17","ଆରି ତରାନ୍ନିଆ ଡେଃଚେ କେଣ୍ତିଆ ଇନୁମେତା କପର୍ନାହୂମ ପାକା ୱେନେ ମୁଲେଆର୍‌କେ । ମିଡିଗ୍ ଡିଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଡିଙ୍କେ ବାରି ଜିସୁ ଆତେନ୍‌ ଜାକ ମେଁଇଂନେ ଡାଗ୍ରା ପାଙ୍ଗ୍ ଆଲେଃକେ ଣ୍ତୁ ");
INSERT INTO gaq_vpl VALUES ("JN6_18","073_6_18","JHN","6","18","18","ଆରି ଜବର୍ ୱେଡ଼ିଆ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌ଲା ଣ୍ତିଆଃନ୍ନିଆ ଲଅଡ଼ି ତଡ଼ିଆଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_19","073_6_19","JHN","6","19","19","ଏନ୍‌ ବିତ୍ରେ ସିସ୍‌ଇଂ କେଣ୍ତିଆ ବିତ୍ରେ ମାଲ୍ ବା ତୁର୍ କିଲମିଟର୍ ତରା ଡୁଙ୍ଗ୍‌ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ କେଆର୍‌କେ ଜିସୁ ଣ୍ଡିଆ ଆଡ଼ାତ୍ରା ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ତରା ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ଆକ୍‌ଅରିଆ ମେଇଂ ଇରିୟାଃତୁଗ୍ ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_20","073_6_20","JHN","6","20","20","ଜିସୁ ବାସଙ୍ଗ୍‌କେ: “ଆବ୍‌ଟଗେପା ନାମଃ । ଆକେନ୍ ତ ନେଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_21","073_6_21","JHN","6","21","21","ତେସା ମେଇଂ ଜିସୁକେ ତରାନ୍ନିଆ ଡୁଂୱିଗ୍‌ନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଆର୍କେ ବାରି ମେଇଂ ଆଣ୍ତିନେ ଜାଗାନ୍ନିଆ ୱେଡିଙ୍ଗ୍ ଆର୍‌କେ, ତରାଲେ ଟାପ୍‌ନା ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ୱେଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_22","073_6_22","JHN","6","22","22","ଆର୍‌ମୁଇଂ ଦିନା କେଣ୍ତିଆନେ ବିନ୍ ପାକା ଲେଃକ୍ନେ ରେମୁଆଁଇଂ ମ୍ୟାଆର୍‌କେ ଜେ ଆତ୍‌ଅରିଆ ମାତର୍‌‌ ମୁଇଂ ଆଃ ତରା ଲେଃକେ ଆରି ସିସ୍ଇଂ ଜିସୁକେ ସଙ୍ଗେ ଡୁଂମାୱେଚେ ଆତେନ୍‌ ତରାନ୍ନିଆ କେଣ୍ତିଆ ବିତ୍ରେ ଅଲେଙ୍ଗ୍ ୱେଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_23","073_6_23","JHN","6","23","23","ଆଣ୍ଡିଅରିଆ ମାପ୍‌ରୁ ପାର୍‌ତନା ଡିଂଚେ ରେମୁଆଁଇଂକେ ରୁଟି ଚଙ୍ଗ୍‌ନେସା ବିଃବଗେ, ତିବିରିଆବାନ୍‌ ଆରି ଉଡ଼ିକ୍ଲିଗ୍ ତରା ଆତେନ୍‌ ଜାଗା ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_24","073_6_24","JHN","6","24","24","ଜିସୁ ଣ୍ତୁଲା ମେଁନେ ସିସ୍ଇଂକେ ଆତ୍‌ଅରିଆ ମା‍ଅବାଚେ ରେମୁଆଁଇଂ ଜିସୁକେ ତୁର୍‌ନ୍‌ସା ତରାନ୍ନିଆ ଡେଃଚେ କପର୍ନାହୂମନ୍ନିଆ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_25","073_6_25","JHN","6","25","25","ଜିସୁକେ କେଣ୍ତିଆ ଇନୁମେତା କେଚେ ରେମୁଆଁଇଂ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଗୁରୁ ନାଁ ଉଡ଼ିବେଲା ପାଙ୍ଗ୍‌ଚେ ଆକ୍‌ଅରିଆ ନାପିଙ୍ଗ୍‍ଚାକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN6_26","073_6_26","JHN","6","26","26","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିଃକେ “ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ନେଙ୍ଗ୍‌ନେ ଇରିଆତୁଗ୍ କାମ୍ କେପେଲେକେସା ଜେ ଆନେଙ୍ଗ୍ ତୁର୍ ନ୍‌ସା ପାଙ୍ଗ୍‌ପେଲେଃକେ ଣ୍ତୁ । ଡାଗ୍ଲା ରୁଟି ଚଙ୍ଗ୍‌ଚେ ସୁଲୁଏ ଆବ୍‌ସେ ପେବକେସା ପାଙ୍ଗ୍‌ପେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_27","073_6_27","JHN","6","27","27","ଆଣ୍ଡିନେ ବଲେ ନଷ୍ଟ ଡିଙ୍ଗ୍‌ଏ ମେଁ ନ୍‌ସା ଅଃକେନ୍ କଷ୍ଟ ଆଡିଙ୍ଗ୍‌ପା ନାମଃ । ଣ୍ତୁଲା ଆଣ୍ଡିନେ ନସ୍ଟ ଆଡିଂନେ ବଲେ ମାଡାନେ ଜିବନ୍‌ ବିଃଏ ଆତେନ୍‌‌ସା କଷ୍ଟ ଡିଙ୍ଗ୍‌ପା । ଆକେନ୍ ବଲେ ଇସ୍‌ପର୍ ଉଙ୍ଗ୍‌ଡେ ବିଃଏ ଡାଗ୍ଲା ଆବା ଇସ୍‌ପର୍ ଆତେନ୍‌‌ସା ଆମେକେ ଅଦିକାର୍ ବିଃବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_28","073_6_28","JHN","6","28","28","ଆତ୍‌ବାନ୍ ମେଇଂ ଆମେକେ ସାଲ୍ୟାକୁ ଆର୍‌କେ, “ଇସ୍‌ପର୍‌ ମେଃନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଡିଙ୍କେ, ଆତେନ୍‌ ଡିଙ୍ଗ୍ ନ୍‌ସା ଆନେକେ ମେଃନେ ଡିଙ୍ଗ୍‌ ପଡ଼େଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN6_29","073_6_29","JHN","6","29","29","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିଃକେ: “ଆଜାକେ ଇସ୍‌ପର୍ ବେ ବକେ, ମେଁନେ ଡାଗ୍ରା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ନେ ବାନ୍ ପେଇଂ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ପେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_30","073_6_30","JHN","6","30","30","ଆତ୍‌ବାନ୍ ମେଇଂ ଆମେକେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ନାଁନେ ଡାଗ୍ରା ନେଁ ଡିରକମ୍ ବିସ୍‌ବାସ୍ ନେଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌‌ସା ଆନେକେ ଡିଡି ଇରିୟାତୁଗ୍ କାମ୍ ଆସୁଏ ନାୟାଏ ? ବାସଙ୍ଗ୍‌ ମେଁନେ ଡିଙ୍ଗ୍ ନାୟାଏ ? ");
INSERT INTO gaq_vpl VALUES ("JN6_31","073_6_31","JHN","6","31","31","ନେଁନେ ଅସେଣ୍ଡ୍ରେଇଂ ବାଲିଲନ୍ନିଆ ମାନ୍ନା ଚଙ୍ଗ୍‍ଲେ ଆର୍‌କେ । ନେଁନେ ଦର୍ମ ସାସ୍ତର୍‌ ରକମ୍ ମେଁ ଆକେନ୍ ବଲେ କିତଂଇନିବାନ୍ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଚେ ବିକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_32","073_6_32","JHN","6","32","32","ଆତ୍‌ବାନ୍ ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‍ଡିଂକେ “ସତ୍ ସତ୍ ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ମେଁନେ ମୋଶା ଆପେକେ ବିଃବକେ ଆତେନ୍‌ କିତଂବାନ୍‌ ପାଙ୍ଗ୍‌କ୍ନେ କାଦି ଣ୍ତୁ ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ଆବା ଆପେକେ କିତଂବାନ୍‌ ସତେଆଃ କାଦି ବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN6_33","073_6_33","JHN","6","33","33","ଡାଗ୍ଲା ଆଣ୍ତିନେ କାଦି ଆଡ଼ାତ୍ରାବାନ୍ ଜାର୍‌ଚେ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ପାରାନ୍ ଦାନ୍ ଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌ ଇସ୍‌ପର୍ ବିଃକ୍ନେ ବଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_34","073_6_34","JHN","6","34","34","ମେଇଂ ଜିସୁକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ମାପ୍‌ରୁ, ଆନେକେ କାଲାଆଃ ଆକେନ୍ କାଦି ବିଃଲା ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_35","073_6_35","JHN","6","35","35","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଆତେନ୍‌ ପାରନ୍‌ ବିଃନେ ବଲେ । ଜାଣ୍ତେ ନେଙ୍ଗ୍‌ନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଏ ମେଁ ଅଃନାଡିଗ୍ କେଡ଼େସ ଆଡିଙ୍ଗ୍ ଣ୍ତୁ ଆରି ଜାଣ୍ଡେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଅଃନାଡିଗ୍ ଉଗ୍‌ଡ୍ୟା ଆଡ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN6_36","073_6_36","JHN","6","36","36","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ଆନେଙ୍ଗ୍ କେଚେ ଡିଗ୍ ପେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN6_37","073_6_37","JHN","6","37","37","ଜାଣ୍ତେକେ ନେଙ୍ଗ୍ ଆବା ଆନେଙ୍ଗ୍ ବିଃବକେ ମେଇଂ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଆର୍‌ଏ । ଜାଣ୍ଡେ କି ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଏ ନେଙ୍ଗ୍ ଅଃନା ଆମେକେ ଆଣ୍ତେ ନ୍ନାବି ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN6_38","073_6_38","JHN","6","38","38","ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ନିଜର୍ ଇକ୍‌ଚା ବର୍ତି ଆଡିଙ୍ଗ୍‌ନେ ଣ୍ତୁ ଡାଗ୍ଲା ଆନେଙ୍ଗ୍ ବେବକ୍ନେ ଇକ୍‌ଚା ବର୍ତି ଆଡିଙ୍ଗ୍‌ନେ ନେଙ୍ଗ୍ କିତଂଇନିବାନ୍ ପାଙ୍ଗ୍ ନ୍‌ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_39","073_6_39","JHN","6","39","39","ଜାଣ୍ତେକେ ମେଁ ନେଙ୍ଗ୍ ଡାଗ୍ରା ବେବକେ ମେଇଂନେ ବିତ୍ରେ ନେଙ୍ଗ୍ ମୁଇଂଜାକେ ଡିଗ୍ ନାଁ ଆନ୍ତାର୍ ଡାଗ୍ଲା ଡାକ୍ନେ ଦିନା ଆତେନ୍‌ ସାପାରେକେ ଆର୍‌ମୁଇଂତର୍‌ ପାରାନ୍ ମ୍ୱିଏ ଆକେନ୍ ମେଁନେ ଇକ୍‌ଚା । ");
INSERT INTO gaq_vpl VALUES ("JN6_40","073_6_40","JHN","6","40","40","ଡାଗ୍ଲା ଆବା ଚାଏଁଡିଂକେ ଜାଣ୍ଡେଇଂ ମେଁନେ ଉଙ୍ଗ୍‌ଡେକେ କେଚେ ମେଁନେ ଡାଗ୍ରା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ମେଇଂ ମାଡାନେ ପାରାନ୍ ବାଆର୍‌ଲେଃ । ଇଡ଼ିଙ୍ଗ୍ ଡାକ୍ନେ ଦିନା ନେଙ୍ଗ୍ ଆତେନ୍‌ ସାପାରେକେ ଆରି ମୁଇଂତର୍ ଣ୍ଡ୍ରାମ୍ୱ୍ରଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_41","073_6_41","JHN","6","41","41","ଜିସୁ ନିଜେକେ କିତଂଇନିବାନ୍ ପାଙ୍ଗ୍‌ଲେଃକ୍ନେ ବଲେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଲା ଜିଉଦିଇଂ ଆକେନ୍ ସାମୁଆଁକେ ନିନ୍ଦା ଡିଙ୍ଗ୍‌ନେ ମୁଲେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_42","073_6_42","JHN","6","42","42","ଆରି ବାସଙ୍ଗ୍ଆର୍କେ “ଆକେନ୍ ରେମୁଆଁ ଯୋସେଫ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଜିସୁ ଣ୍ତୁ ଲେଃ ? ମେଁନେ ଆବା ଇୟାଙ୍ଗ୍‌କେ ନେଁ ମ୍ୟାନେଲେକେ । ତେଲା ମେଁ କିତଂଇନିବାନ୍ ଜାର୍‌ନ୍ଲେଃକେ ଡାଗ୍‌ଚେ ଡିରକମ୍ ବାସଙ୍ଗ୍‌ଡିଂକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN6_43","073_6_43","JHN","6","43","43","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ: “ଆକେନ୍ ସାପା ନିନ୍ଦା ବନ୍ଦ୍ ଆଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("JN6_44","073_6_44","JHN","6","44","44","ନେଙ୍ଗ୍ ଆବା ଆନେଙ୍ଗ୍ ବେବକେ ମେଁ ନେଙ୍ଗ୍ ଡାଗ୍ରା ଉର୍‌ଗୁ ଡୁଂଆପାଙ୍ଗ୍‌ଲା ଜାଣ୍ଡେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ଜାଣ୍ଡେଇଂ ପାଙ୍ଗ୍‌ଆର୍‌ଏ ଆମେଇଂକେ ନେଙ୍ଗ୍ ଡାକ୍ନେ ଦିନା ଆରି ମୁଇଂତର୍ ଣ୍ଡ୍ରାମ୍ୱ୍ରଏ । ");
INSERT INTO gaq_vpl VALUES ("JN6_45","073_6_45","JHN","6","45","45","ବାବବାଦିଇଂ ଦର୍ମ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍ ବକେ: ଡିଲାଡିଗ୍‌ ଇସ୍‌ପର୍‌ନେ ବାନ୍ ସାପାରେ ଗ୍ୟାନ୍ ବାଆର୍‌ଏ । ଜାଣ୍ଡେ କି ଆବାନେ ସାମୁଆଁ ଅଁଚେ ମେଁନେ ବାନ୍ ଗ୍ୟାନ୍ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ମେଁ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN6_46","073_6_46","JHN","6","46","46","ଆକେନ୍ ଅର୍‌ତ ଣ୍ତୁ ଜେ ଜାଣ୍ଡେ ଆବାକେ କେଲେଃକେ । ଜାଣ୍ତେ ଇସ୍‌ପର୍‌ନେବାନ୍ ପାଙ୍ଗ୍‌ଲେଃକେ ମେଁ ମାତର୍‌‌ ଆମେକେ କେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_47","073_6_47","JHN","6","47","47","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଜାଣ୍ଡେ କି ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ମାଡାନେ ପାରାନ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN6_48","073_6_48","JHN","6","48","48","ନେଙ୍ଗ୍ ପାରାନ୍ ବିଃନେ ବଲେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_49","073_6_49","JHN","6","49","49","ପେନେ ଅସେଣ୍ଡ୍ରେଇଂ ବାଲିଲନ୍ନିଆ ମାନ୍ନା ଚଙ୍ଗ୍‍ଲେଃଆର୍କେ ଏଲେଡିଗ୍ ମେଇଂ ଗୁଏଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_50","073_6_50","JHN","6","50","50","ଡାଗ୍ଲା ଆଣ୍ତିନେ ବଲେ କିତଂଇନିବାନ୍ ପାଙ୍ଗ୍‌ଏ ଆମେକେ ଜାଣ୍ଡେ ଚଙ୍ଗ୍ଏ ମେଁ ମାଡାନେ ପାରାନ୍ ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN6_51","073_6_51","JHN","6","51","51","ନେଙ୍ଗ୍ ଆଡ଼ାତ୍ରାବାନ୍ ପାଙ୍ଗ୍‌ନ୍ଲେଃକ୍ନେ ଆତେନ୍‌ ପାରାନ୍ ବିଃନେ ବଲେ । ଆକେନ୍ ବଲେ ଜାଣ୍ଡେ ଚଙ୍ଗ୍‌ଏ ମେଁ ମାଡାନେ ପାରାନ୍ ବାଏ । ନେଙ୍ଗ୍ ଆଣ୍ତିନେ ବଲେ ମ୍ୱିଏ ଆତେନ୍‌ ନେଙ୍ଗ୍‌ନେ ଚିଲି । ମଞ୍ଚ୍‌ପୁର୍‌କେ ଆମ୍ୱ୍ର ନ୍‌ସା ନେଙ୍ଗ୍ ଆତେନ୍‌ ଦାନ୍ ଣ୍ତିଙ୍ଗ୍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_52","073_6_52","JHN","6","52","52","ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ ଜିଉଦିଇଂ ରିସାଡିଙ୍ଗ୍‍ଚେ କିର‍ଆର୍‌କେ: “ଆକେନ୍ ରେମୁଆଁ ମେଁନେ ଚିଲି ଡିରକମ୍ ଆନେକେ ଚଙ୍ଗ୍ ନ୍‌ସା ବିଃଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN6_53","073_6_53","JHN","6","53","53","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ: “ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ, ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେନେ ଚିଲି ପେଚଙ୍ଗ୍‌ଲା ଆରି ମେଁନେ ମ୍ୟା ପେଉଗ୍‌ଲା ପେଇଂ ପାରାନ୍ ବା ପେୟା ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN6_54","073_6_54","JHN","6","54","54","ଜାଣ୍ଡେ କି ନେଙ୍ଗ୍‌ନେ ଚିଲି ପେଚଙ୍ଗ୍ଏ ଆରି ନେଙ୍ଗ୍‌ନେ ମ୍ୟା ପେଉଙ୍ଗ୍‌ଏ ମେଁ ମାଡାନେ ପାରାନ୍ ଲାବ୍‌ ପେଡିଂଏ ଆରି ନେଙ୍ଗ୍ ଆମେକେ ଡାକ୍ନେ ଦିନା ଆର୍‌ମୁଇଂତର୍‌ ଣ୍ଡ୍ରାମ୍ୱ୍ରଏ । ");
INSERT INTO gaq_vpl VALUES ("JN6_55","073_6_55","JHN","6","55","55","ଡାଗ୍ଲା ନେଙ୍ଗ୍‌ନେ ଚିଲି ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ସତେଆ ବଲେ ଆରି ନେଙ୍ଗ୍‌ନେ ମ୍‌ମ୍ୟାଁ ସତେଆ ଣ୍ଡିଆ । ");
INSERT INTO gaq_vpl VALUES ("JN6_56","073_6_56","JHN","6","56","56","ଜାଣ୍ଡେ ନେଙ୍ଗ୍‌ନେ ଚିଲି ଚଙ୍ଗ୍‌ଏ ଆରି ନେଙ୍ଗ୍ ମ୍‌ମ୍ୟାଁ ଉଗ୍‌ଏ, ମେଁ ନେଙ୍ଗ୍ ଡାଗ୍ରା ଲେଃଏ ଆରି ନେଙ୍ଗ୍ ମେଁଡାଗ୍ରା ନ୍ଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN6_57","073_6_57","JHN","6","57","57","ମ୍ୱ୍ରକ୍ନେ ଆବା ଆନେଙ୍ଗ୍ ବେବକେ; ମେଃନ୍‌ସା ନେଙ୍ଗ୍ ଡିଙ୍ଗ୍ ମ୍ୱ୍ରନ୍ଲେଃକେ । ଦେତ୍‌ରକମ୍ ଜା ନେଙ୍ଗ୍‌ନେ ଚିଲି ଚଙ୍ଗ୍ଏ ନେଙ୍ଗ୍ ନ୍‌ସା ମେଁ ଡିଙ୍ଗ୍ ମ୍ୱ୍ରଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN6_58","073_6_58","JHN","6","58","58","ଆକେନ୍ ଆଃ କିତଂବାନ୍‌ ଜାର୍‌କ୍ନେ ବଲେ । ଆଣ୍ତିନେ ବଲେ ଚଙ୍ଗ୍‍ଚେ ପେନେ ଅସେଣ୍ଡ୍ରେଇଂ ଗୁଏଆର୍‌କେ ଦେତ୍‌ରକମ୍ ଣ୍ତୁ ଆକେନ୍ ବଲେ ଜା ଚଙ୍ଗ୍‌ଏ ମେଁ ମାଡାନେ ଜୁଗ୍ ଜାକ ମ୍ୱ୍ର ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_59","073_6_59","JHN","6","59","59","ଜିସୁ କପର୍ନାହୁମ୍‍ ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ଗ୍ୟାନ୍ ବିଃକେଲା ଆକେନ୍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_60","073_6_60","JHN","6","60","60","ଜିସୁନେ ସିସ୍ଇଂନେ ବିତ୍ରେ ଗୁଲୁଏ ମେଁନେ ଆକେନ୍ ସାପା ସାମୁଆଁ ଅଁଚେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ଗ୍ୟାନ୍ ବୁଜେନେ ଜାବର୍ କଷ୍ଟ ଜାଣ୍ଡେ ଆକେନ୍ ସାପା ଅଁଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN6_61","073_6_61","JHN","6","61","61","ଆକେନ୍ ବିସୟ୍‌ରେ ଜିସୁକେ ଜାଣ୍ଡେ ମେଃଡିଗ୍‌ ବାସଙ୍ଗ୍ ଆବଲା ଡିଗ୍ ମେଁନେ ସିସ୍ଇଂ ନିନ୍ଦା ଡିଙ୍ଗ୍‌ଡିଙ୍କେ ଡାଗ୍‌ଚେ ଜିସୁ ମ୍ୟାଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ: “ଆକେନ୍ ସାମୁଆଁକେ ମୁର୍ମୁରା ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("JN6_62","073_6_62","JHN","6","62","62","ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଆଣ୍ତିବାନ୍ ପାଙ୍ଗ୍‍ଲେଃକେ ଆତ୍‌ଅରିଆ ଆମେକେ ଆଣ୍ଡେ ୱିଗ୍‌ନେ ପେକେଲା ମେଁନେ ପେଡିଙ୍ଗ୍‌ଏ ? ");
INSERT INTO gaq_vpl VALUES ("JN6_63","073_6_63","JHN","6","63","63","ମାତର୍‌‌ ଇସ୍‌ପର୍‌ନେ ଆତ୍ମା ପାରାନ୍ ବିୟାଏ । ରେମୁଆଁନେ ବପୁ ମେଃଡିଗ୍‌ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ତୁ । ଇସ୍‌ପର୍‌ନେ ଆତେନ୍‌ ପାରାନ୍ ବିନେ ଆତ୍ମାକେ ପେଇଂ ଡିରକମ୍ ମ୍ୟାପେୟାଏ ଆତେନ୍‌‌ସା ନେଙ୍ଗ୍ ଆକେନ୍ ସାପା ସାମୁଆଁ ମ୍ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_64","073_6_64","JHN","6","64","64","ଡାଗ୍ଲା ପେଇଂନେ ବିତ୍ରେ ଜାଣ୍ଡେ ଜାଣ୍ଡେ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‌ଆର୍‌କେ ଣ୍ତୁ ।” ଡାଗ୍ଲା ଜାଣ୍ଡେଇଂ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ ଆରି ଜାଣ୍ଡେ ଆମେକେ ବିରଦ୍‌ଣ୍ତ୍ରେନ୍ନିଆ ଆଃସାଃ ବିଃଏ, ଆତେନ୍‌ ଜିସୁ ଅଃସେବାନ୍ ମ୍ୟାଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_65","073_6_65","JHN","6","65","65","ଜିସୁ ବାରି ବାସଙ୍ଗ୍‍କେ: “ଆକେନ୍‌ସା ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍ ଆବାନେ ବାନ୍ ଲିବିସ ପେ ବାଲା ଜାଣ୍ଡେ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍ ପେୟା ଣ୍ତୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_66","073_6_66","JHN","6","66","66","ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ ଜିସୁନେ ପ୍ଲା ୱେଣ୍ଡ୍ରେଇଂନେ ବିତ୍ରେବାନ୍ ଗୁଲେ ରେମୁଆଁ ମେଁନେ ଆଃତେ ୱେ ନ୍‌ସା ଇକ୍‌ଚା ମାଡିଙ୍ଗ୍‌ଚେ ଆଣ୍ତେ ୱିଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN6_67","073_6_67","JHN","6","67","67","ଆକେନ୍ କେଚେ ଜିସୁ ମେଁନେ ତ୍ମାକ୍ଲିଗ୍ ସିସ୍‌‌କେ ସାଲ୍ୟାକୁକେ “ପେଇଂ ଡିଙ୍ଗ୍ ମେଁନେ ଆନେଙ୍ଗ୍ ଆଃତାର୍‌ଚେ ୱିଗ୍ ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍ ?” ");
INSERT INTO gaq_vpl VALUES ("JN6_68","073_6_68","JHN","6","68","68","ଶିମୋନ ପିତର୍ ଜିସୁକେ ଉତର୍ ବିଃଆର୍‌କେ “ମାପ୍ରୁ ଜାଣ୍ଡେ ଡାଗ୍ରା ନେୱେଏ ? ମାଡାନେ ପାରାନ୍‌ନେ ସାମୁଆଁ ନାଁ ଡାଗ୍ରା ଲେଃକେ; ");
INSERT INTO gaq_vpl VALUES ("JN6_69","073_6_69","JHN","6","69","69","ନାଁ ଜେ ଇସ୍‌ପର୍‌ନେ ବାନ୍ ପାଙ୍ଗ୍‌ଲେଃକ୍ନେ ଆତେନ୍‌ ପବିତ୍ର ରେମୁଆଁ ଆକେନ୍ ସାମୁଆଁ ନେଁ ଏକ୍ରେ ବିସ୍‌ବାସ୍ ନେଡିଙ୍ଗ୍‌କେ ଆରି ନେମ୍ୟାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_70","073_6_70","JHN","6","70","70","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିଃକେ, “ନେଙ୍ଗ୍ ମେଁନେ ପେ ତ୍ମାକ୍ଲିଗ୍ ନ୍ନାସ୍ରିକେ କି ? ଆରି ପେଇଂନେ ବିତ୍ରେ ମୁଇଂଜା ସ‍ଏତାନ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("JN6_71","073_6_71","JHN","6","71","71","ଜିସୁ ଇଷ୍କରିୟଥ୍ ଶିମୋନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଜିଉଦାକେ କେଚେ ଆକେନ୍ ବାସଙ୍ଗ୍‌କେ ଡାଗ୍ଲା ମେଁ ତ୍ମାକ୍ଲିଗ୍ ସିସ୍‌‌ ବିତ୍ରେ ମୁଇଂଜା ଡିଙ୍ଗ୍‌ଲା ଡିଗ୍ ଆରି ମେଁ ଜିସୁକେ ସତ୍ରୁନେ ନ୍ତିନ୍ନିଆ ଆଃସାଃ ବିଃନେ‍ ୱେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_1","073_7_1","JHN","7","1","1","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଗାଲିଲୀନ୍ନିଆ ଅଲେଙ୍ଗ୍‌ସାର୍ ୱେଗେ । ମେଁ ଆରି ଜିହୁଦା ଦେସ୍‌ନ୍ନିଆ ୱେନ୍‌ସା ଇକ୍‌ଚା ଆଡିଙ୍କେ ଣ୍ଡୁ ମେଃନ୍‌ସା ଡାଗ୍ଲା ଆତେନ୍‌ ଇନିନେ ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷଇଂ ଆମେକେ ଜିବନ୍‌ରେ ବାଗୁଏ ବିଃନ୍‍ସା ଚାଏଁ ଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_2","073_7_2","JHN","7","2","2","ଇହୁଦୀଇଂନେ କୁଟିରବାସ ପାଣ୍ଡୁଏନେ ବେଲା ଡାଗ୍ରା ପାଙ୍ଗ୍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_3","073_7_3","JHN","7","3","3","ତେଲା ମେଁନେ ବୟାଁଣ୍ଡେଇଂ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଏନ୍‌ ଜାଗା ଆନ୍ତାର୍‍ଚେ ଜିହୁଦା ଇନି ଆଣ୍ଡେ ୱିଗ୍‍ଲା । ନାନେ ଡିଙ୍ଗ୍‍ନାବକ୍ନେ କାମ୍ ସାପା ଆତ୍‍ ଅରିଆ ନାନେ ପ୍ଲା ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ରେମୁଆଁଇଂ କେଲେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_4","073_7_4","JHN","7","4","4","ଜା ଆଃସାମୁଆଁନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ ମେଁ ନିଜେନେ କାମ୍ ବୁଡ଼ିଚେ ଆବ ଣ୍ଡୁ । ନାଁ ଉଡ଼ି ବେଲା ଆକେନ୍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‌ନାୟାଏ ଦର୍‌ତନିନେ ସାପାରେ ଆନାକେ ସାମୁଆଁ ଆର୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_5","073_7_5","JHN","7","5","5","ମେଁନେ ବୟାଁଣ୍ଡେଇଂ ଡିଗ୍ ଆମେକେ ସତ୍‍ ଆମାନେଃକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN7_6","073_7_6","JHN","7","6","6","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍‌ନେ ନିମାଣ୍ଡାନେ ବେଲା ଏଜାକ ଆପାଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ମାତର୍‌ ଉଡ଼ିବେଲା ଡିଗ୍ ପେନ୍‌ସା ଟିକ୍‌ ଡିଙ୍ଗ୍‍ୟାଏ ");
INSERT INTO gaq_vpl VALUES ("JN7_7","073_7_7","JHN","7","7","7","ଡାଗ୍ଲା ଦର୍‌ତନି ଆପେକେ ଆଇଙ୍ଗ୍‌ଚେ ଣ୍ଡୁ । ମାତର୍‌ ଦର୍‌ତନି ଆନେଙ୍ଗ୍‌କେ ଇଙ୍ଗ୍‌ଚେଏ ଡାଗ୍ଲା ମେଁନେ କାମ୍ ଦଦ୍ୟା ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ ପାଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("JN7_8","073_7_8","JHN","7","8","8","ପେଇଂ ଏନ୍‌ ବଜିନ୍ନିଆ ୱେଲାପା; ନେଙ୍ଗ୍ ୱେନାୟା ଣ୍ଡୁ । ମେଃନ୍‌ସା ଡାଗ୍ଲା ଏ ଜାକ ନେଙ୍ଗ୍‍ସା ସମାନ୍ ବେଲା ଙ୍କାରେ ପାଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN7_9","073_7_9","JHN","7","9","9","ଜିସୁ ଆକେନ୍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ଚେ ଗାଲିଲୀନ୍ନିଆ ଲେଃୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_10","073_7_10","JHN","7","10","10","ମାତର୍‌ ଜିସୁନେ ବୟାଁଣ୍ଡେଇଂ ଆତେନ୍‌ ବଜିନ୍ନିଆବାନ୍ ଡକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ପାଣ୍ଡୁଏନ୍ନିଆ ମାୱେଚେ ସୁନ୍‌ସାନ୍ ଜାଗାନ୍ନିଆ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_11","073_7_11","JHN","7","11","11","ପାଣ୍ଡୁନେ ବେଲା ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷଇଂ ଆମେକେ ତୁର୍ ତୁର୍‌ଚେ ସାଲିଆକୁକେ, ମେଁ ଆଣ୍ଡିକା ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_12","073_7_12","JHN","7","12","12","ରେମୁଆଁଇଂ ଜିସୁନେ ବିସୟ୍‌ରେ ଅଲେଙ୍ଗ୍ ଅଲେଙ୍ଗ୍‌ଚେ ଲେଃଗା ଲେଃଗା ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ଆର୍‌ଡିଙ୍କେ । ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌କେ “ମେଁ ମୁଇଙ୍ଗ୍ ନିମାଣ୍ଡା ରେମୁଆଁ ।” ବିନ୍‌ଣ୍ଡ୍ରେଇଂ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ ଆତେନ୍‌ ରେମୁଆଁକେ ଦଦିଆ ଗାଲିନୁଗ୍ ୱେଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_13","073_7_13","JHN","7","13","13","ମାତର୍‌ ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷ‍ଇଂକେ ବୁଟଚେ ଜାଡିଗ୍‍ ମେଁନେ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‍ମ୍ୟାକ୍ନେ ଅରିଆ ବାସଙ୍ଗ୍‌ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN7_14","073_7_14","JHN","7","14","14","ପାଣ୍ଡୁଏଃ ଇକୁଡ଼ା ତେଡାକ୍ନେ ବେଲା ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମନ୍ଦିର୍‍ନ୍ନିଆ ୱେଚେ ସିକ୍ୟା ବିଃନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_15","073_7_15","JHN","7","15","15","ଆତ୍‍ ଅରିଆ ଇହୁଦୀଇଂ ଇରିଆତୁଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ମେଁ ପାଟ୍‍ ମାଲଚେ ଆକେନ୍ ବିସୟ୍‌ରେ ଡିରକମ୍ ମ୍ୟାକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_16","073_7_16","JHN","7","16","16","ତେଲା ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍‌ନେ ସିକ୍ୟା ନେଙ୍ଗ୍ ନିଜର୍‌ନେ ଣ୍ଡୁ ମାତର୍‌ ଆନେଙ୍ଗ୍‌କେ ବେବକ୍ନ ଇସ୍‌ପର୍‌ନେ ବାନ୍ ପାଙ୍ଗ୍‍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_17","073_7_17","JHN","7","17","17","ଜାଣ୍ଡେ ଜଦି ଇସ୍‌ପର୍‌ନେ ଇକ୍‌ଚାରେ କାମ୍ ଡିଙ୍ଗ୍‌ନେ ରାଜି ତେଲା ନେଙ୍ଗ୍‌ନେ ସିକ୍ୟା ଇସ୍‌ପର୍‌ନେ ବାନ୍ ତାର୍‌ଲେଃକ୍ଲେ ନେଙ୍ଗ୍ ନିଜେ ନେଙ୍ଗ୍‌ନେ ଅଦିକାର୍‌ରେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଂକେ ଆତେନ୍‌ ମେଁ ମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN7_18","073_7_18","JHN","7","18","18","ଜାଣ୍ଡେ ନିଜର୍ ଅଦିକାର୍‌ରେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଏ ନିଜେନେ ମ‍ଇମା ଡିଙ୍ଗ୍‌ନେ ମେଁନେ କାମ୍ ମାତର୍‌ ଜା ନିଜେ ବେବକ୍ନେ ମାପ୍ରୁନେ ଗୌରବ୍ ବାନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ ମେଁ ଅରିଆ ମେଃଡିଗ୍ ଅଦର୍ମ ଆଲେଃ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN7_19","073_7_19","JHN","7","19","19","ମୋଶା ପେନ୍‌ସା ନିଅମ୍ ଆର୍ମେଚେ ସାପା ବେକେ । ମାତର୍‌ ପେନେବାନ୍ ଜା ଡିଗ୍ ଆତେନ୍‌ ନିଅମ୍ ପେପାଲେକେ । ପେ ଆନେଙ୍ଗ୍‌କେ ବାଗୁଏଃ ନ୍‌ସା ମେସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_20","073_7_20","JHN","7","20","20","ରେମୁଆଁଇଂ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଆନାକେ ସେଆଁରେ ସାଃଲେଃକେ । ଆନାକେ ଜା ବାଗୁଏଃନେସା ଚେସ୍‌ଟା ଡିଂକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_21","073_7_21","JHN","7","21","21","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ମ୍ନାନେ କାମ୍ ଡିଂକ୍ନେ କେଚେ ପେଇଂ କାବା ପେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_22","073_7_22","JHN","7","22","22","ପେଉଙ୍ଗ୍‍କେ ପବିତ୍ର ଆଡିଙ୍ଗ୍ ନ୍‌ସା ମୋଶା ଆଦେସ୍‍ ବିବଗେ । ମୋଶା ଏନ୍ ନିୟମ୍‌ ମୁଲେ ଆବଗେ ଣ୍ଡୁ; ଅସେନେ ନ୍ତାଞ୍ଜାଇଂନେ ବାନ୍ ଆକେନ୍ ଚଲେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗେ । ପୁଣ୍ଡେନେ ଦିନା ଡିଗ୍ ପେ ଆତେନ୍‌ ପବିତ୍ର କାମ୍ ଆଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ମାତର୍‌ ଆତେନ୍‌ ନ୍‌ସା ଜା ପୁଣ୍ଡେନେ ଦିନା ନିଅମ୍ ଅମାନି ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ପେଏତେକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN7_23","073_7_23","JHN","7","23","23","ମୋଶାନେ ନିଅମ୍ ମାଡିଙ୍ଗ୍‍ ନ୍‍ସା ଜଦି ପୁଣ୍ଡେନେ ଦିନା ରେମୁଆଁନେ ପବିତ୍ର ଡିଙ୍ଗ୍ ଆର୍‌ଏ ତେଲା ନେଙ୍ଗ୍ ପୁଣ୍ଡେନେ ଦିନା ମୁଇଙ୍ଗ୍ ଗଡ଼େଅକେ ସାପାରେକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‌ଲା ପେଇଂ ମେସା ନେଙ୍ଗ୍ ଆଡ଼ାତ୍ରା ଗିସେ ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍ ? ");
INSERT INTO gaq_vpl VALUES ("JN7_24","073_7_24","JHN","7","24","24","ବାଏରେନେ ବିସୟ୍ କେଚେ ବିଚାର୍ ଆଡିଙ୍ଗ୍‌ପା ମାତର୍‌ ସତ୍ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_25","073_7_25","JHN","7","25","25","ଯିରୂଶାଲମ୍‌ନେ ଉଡ଼ି ରେମୁଆଁ ବାସଙ୍ଗ୍‌କେ “ମୁଡ଼ି ରେମୁଆଁ ବାଗୁଏଃ ନ୍‌ସା ଜିଉଦି କର୍ତ୍ତୁପକ୍ଷଇଂ ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଗେ ମେଁ ଏନ୍ ରେମୁଆଁ ଣ୍ଡୁ ତ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_26","073_7_26","JHN","7","26","26","ଆରି କେଲାପା, ମେଁ ବାସଙ୍ଗ୍‌ ଅଲେଙ୍ଗ୍‌ଡିଂକେ ଆରି ମେଇଂ ଆମେକେ ମେଃଡିଗ୍ ଆଡିଙ୍ଗ୍ ଆର୍‌କେ । ଏନ୍ କିସ୍‌ଟ ଏନ୍ ମେଃନେ ନେତାଇଂ ସତେଆ ମ୍ୟାଃଆର୍‌ଗେ ? ");
INSERT INTO gaq_vpl VALUES ("JN7_27","073_7_27","JHN","7","27","27","ଉଡ଼ିବେଲା କିସ୍‌ଟ ପାଙ୍ଗ୍‌ଏ ମେଁ ଆଣ୍ଡିବାନ୍ ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ଜା ମ୍ୟା ଆୟାକେ ଣ୍ଡୁ; ମାତର୍‌ ଏନ୍ ରେମୁଆଁ ଆଣ୍ଡିବାନ୍ ପାଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍, ନେ ସାପାରେ ଆତେନ୍‌ ମ୍ୟାନେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_28","073_7_28","JHN","7","28","28","ଜିସୁ ମନ୍ଦିର୍‍ନ୍ନିଆ ସିକ୍ୟା ବିଃନେ ବେଲା କିରଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଜାଣ୍ଡେ ଆରି ଆଣ୍ଡିବାନ୍ ପାଙ୍ଗ୍‍ନେ ପେ ମେଁନେ ସତେଆ ମ୍ୟାପେଲେ ? ନେଙ୍ଗ୍ ନିଜେନେ ଅଦିକାର୍‌ରେ ନାପାଙ୍ଗ୍‍କେ ଣ୍ଡୁ । ଆନେଙ୍ଗ୍‌କେ ଜା ବେବକେ ମେଁ ସତ୍ । ପେଇଂ ଆମେକେ ପେମ୍ୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN7_29","073_7_29","JHN","7","29","29","ନେଙ୍ଗ୍ ଆମେକେ ମ୍ୟାନ୍ଲେକେ ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଁ ଆନେଙ୍ଗ୍‌କେ ବେବକେ ନେଙ୍ଗ୍ ମେଁ ବାନ୍ ପାଙ୍ଗ୍ ନ୍ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_30","073_7_30","JHN","7","30","30","ଏନ୍ ଅଁଚେ ମେଇଂ ଆମେକେ ସାଃନ୍‌ସା ଚେସ୍‌ଟା ଡିଂକେ । ମାତର୍‌ ଜା ଡିଗ୍ ମେଁ ଆଡ଼ାତ୍ରା ନ୍ତି ଆଲିଗ୍‍ଆର୍‌କେ ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଁନେ ବେଲା ପାଙ୍ଗ୍ ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN7_31","073_7_31","JHN","7","31","31","ମାତର୍‌ ରେମୁଆଁ ବିତ୍ରେବାନ୍‍ ଉଡ଼ିରୁଆ ଜିସୁନ୍ନିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “କିସ୍‌ଟ ପାଙ୍ଗ୍‌ଲା ଏନ୍ ରେମୁଆଁ ବାନ୍ ମେଁ ମେଁନେ ଆରି ଜାବର୍ ଇରିଆଃତୁଗ୍‍ ସୁଗୁଆ କାମ୍ ଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_32","073_7_32","JHN","7","32","32","ଜିସୁନେ ବିସୟ୍‌ରେ ରେମୁଆଁଇଂ ଦେକ୍‌ରକମ୍ ବାଲିର୍ ସାମୁଆଁ ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କ୍ନେ ଫାରୁଶୀଇଂ ଅଁଆର୍କେ । ତେସା ମେଇଂ ଆରି ମ୍ନା ପୁଜାରି‍ଇଂ ଜିସୁକେ ବନ୍ଦି ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ମୁଇଂ ମାନ୍ଦା ଉର୍‌ଣ୍ଡ୍ରେକେ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_33","073_7_33","JHN","7","33","33","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଆନେଙ୍ଗ୍ ପେଏତେଏ ଆରି ଇକୁଡ଼ା ବେଲା ନ୍‍ସା ନ୍ଲେଏ ଆରି ଆନେଙ୍ଗ୍‌କେ ବେବକ୍ନେ ମାପ୍ରୁନ୍ନିଆ ଆଣ୍ଡେ ଉଁୱିଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN7_34","073_7_34","JHN","7","34","34","ପେଇଂ ଆନେଙ୍ଗ୍‌କେ ପେତୁର୍‍ଏ ମାତର୍‌ ପେଅବା ଣ୍ଡୁ ମେଃନ୍‌ସା ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆଣ୍ଡି ନ୍ଲେଏ ପେ ଆତେନ୍‌ ଅରିଆ ୱେପେୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_35","073_7_35","JHN","7","35","35","ଜିହୁଦି କର୍ତ୍ତୁପକ୍ଷଇଂ ମେଇଂମେଇଂ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଆର୍‌କେ “ମେଁ ଦେକ୍‌ରକମ୍ ଆଣ୍ଡିନେ ଜାଗାନ୍ନିଆ ୱେଏ ଜେ ନେ ଆମେକେ ତୁର୍ ଅବା ନେୟା ଣ୍ଡୁ ? ମୁଡ଼ି ଗ୍ରୀକ୍‍ ନଗର୍‍ଇଂନ୍ନିଆ ନେନେ ରେମୁଆଁଇଂ ଲେଃକେ, ମେଁ ମେଁନେ ଆତ୍‍ ଅରିଆ ୱେଚେ ଗ୍ରିକ୍‍ଇଂକେ ସିକ୍ୟା ବିଏ ? ");
INSERT INTO gaq_vpl VALUES ("JN7_36","073_7_36","JHN","7","36","36","ମେଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍, ନେ ଆମେକେ ତୁର୍‌ଚେ ଅବା ନେୟା ଣ୍ଡୁ ଆଣ୍ଡି ଅରିଆ ମେଁ ୱେଏ ଆତ୍‍ ଅରିଆ ନେ ୱେନେୟା ଣ୍ଡୁ ଡାଗ୍ଲା ମେଃନେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_37","073_7_37","JHN","7","37","37","ପାଣ୍ଡୁଏନେ ସାରାସାରି ବା ମ୍ନା ଦିନ୍ କେଲା ଜିସୁ ତୁଆଁଚେ ୱାସାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଆଜାକେ ଉଗ୍‍ଡିଆ ଡଡିଂକେ ମେଁ ନେଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଉଗ୍‍ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_38","073_7_38","JHN","7","38","38","ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ ବକେ, “ଜାଣ୍ଡେ ନେଙ୍ଗ୍‍ନ୍ନିଆ ସତ୍‍ ମାନେଃଏ ମେଁ ରୁଦୟ୍‍ ବାନ୍ ଜିବନ୍‍ନେ ଣ୍ଡିଆ ଲାଃଡ୍ୟାଚେ ତାର୍ ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_39","073_7_39","JHN","7","39","39","ଜିସୁ ପବିତ୍ର ଆତ୍ମା ବିସୟ୍‌ରେ ଏନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ, “ଜାଣ୍ଡେଇଂ ଜିସୁକେ ସତ୍‍ ମାନେଃଡିଂଆର୍‌ଗେ, ମେଇଂ ଇଡ଼ିଙ୍ଗ୍ ଏନ୍ ପବିତ୍ର ଆତ୍ମାକେ ଅବା ଆର୍‌କେ । ଅଃତେନ୍‍ ବେଲା ଜାକ ଜିସୁ ଆଲାଦ୍‌ ଡିଙ୍ଗ୍ ଆଲେଃଲା ପବିତ୍ର ଆତ୍ମା ବିଃ ଆବଗେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_40","073_7_40","JHN","7","40","40","ଉଡ଼ିବେଲା ରେମୁଆଁଇଂ ଜିସୁନେ ଏନ୍ ସାମୁଆଁ ଅଁଆର୍କେ ମେଁଇଂନେ ବାନ୍ ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌କେ “ଏନ୍ ରେମୁଆଁ ଡିଲାଡିଗ୍ ବାବବାଦି ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_41","073_7_41","JHN","7","41","41","ଜାଣ୍ଡେ ଜାଣ୍ଡେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଏ କିସ୍‌ଟ ।” ମାତର୍‌ ବିନ୍‌ଣ୍ଡ୍ରେଇଂ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ, “ମସିହ ମେଁନେ ଗାଲିଲୀବାନ୍‍ ଆପାଙ୍ଗ୍‍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_42","073_7_42","JHN","7","42","42","ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ ବକେ, “କିସ୍‌ଟ ଦାଉଦ୍‍ନେ କୁଲ୍‌ ଇଂ ଆରି ମେଁ ଦାଉଦ୍‍ ବାସାକ୍ନେ ଇନି ବେଥ୍‌ଲେହିମ ଇନିନ୍ନିଆ ଜନମ୍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_43","073_7_43","JHN","7","43","43","ତେଲା ଜିସୁନେ ବିସୟ୍‌ରେ ରେମୁଆଁଇଂ ବିତ୍ରେ ବିନ୍‌ବିନ୍‌ ସାମୁଆଁ ତାର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_44","073_7_44","JHN","7","44","44","ମେଁଇଂନେ ବାନ୍ ଉଡ଼ିରୁଆ ଜିସୁକେ ଆସାଲେ ଡାଗ୍‌ଚେ ଆମେକେ ସାଃନ୍‌ସା ଚେସ୍‌ଟା ଡିଂକେ ମାତର୍‌ ଜାଣ୍ଡେ ମେଁନେ ଆଡ଼ାତ୍ରା ନ୍ତି ବିଃ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN7_45","073_7_45","JHN","7","45","45","ଆକ୍ ଅରିଆ ବାନ୍ ଉର୍‍ଣ୍ଡ୍ରେଇଂ ଫାରୁଶୀଇଂ ଆଣ୍ଡେଲା ମ୍ନାଃ ପୁଜାରି ବାରି ଫାରୁଶୀଇଂ ଆମେଇଂକେ ସାଲିଆକୁକେ, “ଆମେକେ ମେଃନ୍‌ସା ସାଚେ ଡୁଙ୍ଗ୍‍ ପେପାଙ୍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_46","073_7_46","JHN","7","46","46","ଉର୍‍ଣ୍ଡ୍ରେଇଂ ଉତର୍ ବିକେ, “ମେଁ ଅଃକେନ୍ ବକୁଆ ଡିଙ୍ଗ୍ ସୁଗୁଆ ଅଃନା ଜା ବ୍ନାଲିର୍ ଆବାସଙ୍ଗ୍‌କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_47","073_7_47","JHN","7","47","47","ପାରୁସୀଇଂ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ମେଁ ମେଁନେ ଆପେକେ ଡିଗ୍ କାବା ଆଡିଙ୍ଗ୍ ବ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_48","073_7_48","JHN","7","48","48","ପାରୁସିଇଂ ଣ୍ଡୁଲା ନେନେ ଅଦିକାରି‍ଇଂନେ ବାନ୍ ଜାଡିଗ୍ ମୁଇଂଜା ମେଁନେ ସାମୁଆଁନ୍ନିଆ ସତ୍ ମାନେଃ ପେଡିଂକେ ଡାଗ୍‌ଚେ ମେଁନେ ପେ ମ୍ୟାପେଲେକେ ? ");
INSERT INTO gaq_vpl VALUES ("JN7_49","073_7_49","JHN","7","49","49","ମାତର୍‌ ଆକେନ୍ ରେମୁଆଁଇଂ ମୋଶାନେ ନିୟମ୍‌ ଆମ୍ୟାକେ ଣ୍ଡୁ ଆତେନ୍‌ ଆକ୍‌ମେଇଂ ସାପା ଅବିସାପ୍ ବାଲେଃକ୍ନେ । ");
INSERT INTO gaq_vpl VALUES ("JN7_50","073_7_50","JHN","7","50","50","ଅଃତେନ୍‍ ବେଲା ଆତ୍‍ ଅରିଆ ନୀକଦୀମ ମ୍ନିକ୍ନେ ମୁଇଂଜା ଫାରୁଶୀ ଆତ୍‍ ଅରିଆ ଲେଃଗେ । ମେଁ ସେନୁଗ୍‍ ବାନ୍‍ ଆଃ ମୁଇଂତର୍ ଜିସୁକେ କିକେ ନ୍‌ସା ୱେଡିଙ୍ଗେ । ମେଁ ବାସଙ୍ଗ୍‌କେ, ");
INSERT INTO gaq_vpl VALUES ("JN7_51","073_7_51","JHN","7","51","51","“ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ବାନ୍ ସେନୁଗ୍‍ ମାଅଁଚେ ଆରି ନେନେ ବେବ‍ଆର୍ ବିସୟ୍‌ରେ ମାମ୍ୟାଚେ ନେନେ ନିଅମ୍ ମେଃନେ ଆମେକେ ଦସ୍ ବିଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN7_52","073_7_52","JHN","7","52","52","ମେଇଂ ଆମେକେ ଉତର୍ ବିକେ, “ନା ଡିଗ୍ ମେଃନେ ମୁଇଙ୍ଗ୍ ଗାଲିଲିନେ ରେମୁଆଁ ? ଗାଲିଲୀନ୍ନିଆ ମେଃଡିଗ୍ ବାବବାଦି ଜନମ୍ ଆଡିଙ୍କେ ଣ୍ଡୁ, ଆକେନ୍ ନିମାଣ୍ଡା ସୁଗୁଆ ସାସ୍ତର୍‌ନ୍ନିଆ ପଡ଼େ କେଲା ।” ");
INSERT INTO gaq_vpl VALUES ("JN7_53","073_7_53","JHN","7","53","53","ଆରି ମେଇଂ ସାପାରେ ନିଜେ ନିଜେନେ ଡୁଆ ୱିଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_1","073_8_1","JHN","8","1","1","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଜିତ କଣ୍ଡାନ୍ନିଆ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_2","073_8_2","JHN","8","2","2","ବାରି ମୁଇଂଦିନା ଞ୍ଜିର୍‍ ମେଁ ମନ୍ଦିର୍‍ନ୍ନିଆ ଆଣ୍ଡେ ୱିଗ୍‍କେ ଆତ୍ ଅରିଆ ସାପାରେ ରେମୁଆଁ ରିସିଙ୍ଗ୍ ଲେଲା ମେଁ କଚେ ଗିଆନ୍‍ ବିନେସା ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_3","073_8_3","JHN","8","3","3","ମୁଇଂ ମାନ୍ଦା ଦରମ୍ ଗୁରୁ ଆରି ଫାରୁଶୀ ଆନ୍ତାର୍‌ବୁଏଃଚେ ଦାରା ପଡ଼େଲେଃକ୍ନେ ମୁଇଙ୍ଗ୍ ସେଲାମ୍ବୁଏଃକେ ଗୁଃ ଡୁଂପାଙ୍ଗ୍‌କେ । ସାପାରେନେ ସେନୁଗ୍‍ ଆତୁଆଁଚେ ଜିସୁ ସାଲିଆକୁକେ ");
INSERT INTO gaq_vpl VALUES ("JN8_4","073_8_4","JHN","8","4","4","“ଗୁରୁ, ଏନ୍‌ ସେଲାମ୍ବୁଏ ମୁଇଙ୍ଗ୍ ଅଡ଼ାରେଗ୍‌‌ ଡିଙ୍ଗ୍‌ନେ ବେଲା ଦାରା ପଡ଼େଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_5","073_8_5","JHN","8","5","5","ଦେକ୍ ରକମ୍ ସେଲାମ୍ବୟ୍‍କେ ବ୍ରି ଏତେ ଟୁ ଆଗୁଏନେସା ମୋଶା ନେନେ ନିୟମ୍‌ନ୍ନିଆ ଆଦେସ୍‍ ବିବକେ । ଏନ୍ ବିସୟ୍‌ରେ ନାଁ ମେଃନେ ବାସଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍‍ ?” ");
INSERT INTO gaq_vpl VALUES ("JN8_6","073_8_6","JHN","8","6","6","ମେଇଂ ଜିସୁକେ ପାନ୍ଦ୍‌ନ୍ନିଆ ତ୍ଲାଗ୍‍ନେ ମେଁନେ ଆଡ଼ାତ୍ରା ବୁଲ୍ ସାନ୍‍ସା ଏନ୍ ସାମୁଆଁ ସାଲିଆକୁ ଡିଙ୍ଗେ ମାତର୍‌ ଜିସୁ ବ୍ରିଙ୍ଗ୍‍ଚେ ନ୍ତିଏତେ ତୁବନ୍ନିଆ ଗୁଆର୍‌ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_7","073_8_7","JHN","8","7","7","ମେଇଂ ଆତ୍ ଅରିଆ ତୁଆଁଚେ ବାରି ସାଲିଆକୁଲା, ଜିସୁ ବାଆଃ ତାଣ୍ଡେଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେନେ ବିତ୍ରେ ଜା ଅଃନା ମେଃଡିଗ୍ ପାପ୍ ପେଡିଂକେ ଣ୍ତୁ, ମେଁ ସେନୁଗ୍‍ ପାଙ୍ଗ୍‌ଚେ ବ୍ରି ଏତେ ଟୁଲେଃ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_8","073_8_8","JHN","8","8","8","ଏନ୍ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁ ବାର୍‌ମୁଇଂତର୍‍ ତୁବଃନ୍ନିଆ ଗୁଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_9","073_8_9","JHN","8","9","9","ଜିସୁନେ ସାମୁଆଁ ଅଁଚେ ମେଇଂ ସାପାରେ ମୁଇଂଜା ଇଡ଼ିଙ୍ଗ୍ ମୁଇଂଜା ୱିଗ୍ ଆର୍‌ଗେ । ମ୍ନାଃରେଇଂ ସେନୁଗ୍‍ ଲାଗ୍‍ଡଆର୍‌ଗେ । ଇଡ଼ିଙ୍ଗ୍ ଆତ୍‍ ଅରିଆ ଲେଃୱେଗେ ମାତର୍‌ ଜିସୁ ଆରି ମେଁନେ ସେନୁଗ୍‍ ତୁଆଁଲେଗେ ଆତେନ୍‌ ସେଲାମ୍ବୟ୍‍ ଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_10","073_8_10","JHN","8","10","10","ଜିସୁ ବାଆଃ ଆଡ଼ାତ୍ରା ଆଡିଙ୍ଗ୍‌ଚେ ଆମେକେ ସାଲିଆକୁକେ, “ମେଇଂ ଆଣ୍ଡିକା ? ଆନାକେ ଡଣ୍ଡ୍ ବିନ୍‌ସା ଜାଡିଗ୍ ଆଲେଃକେ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("JN8_11","073_8_11","JHN","8","11","11","“ଣ୍ଡୁ ମାପ୍ରୁ ଜାଡିଗ୍ ଣ୍ଡୁ” ମେଁ ଉତର୍ ବିକେ । ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଡିଗ୍ ଆନାକେ ଡଣ୍ଡ୍‍ ନାବିଣ୍ଡୁ । ୱେଲା ମାତର୍‌ ଆରି ମୁଇଂତର୍ ପାପ୍ ଆଡିଙ୍ଗେ ନାମଃ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_12","073_8_12","JHN","8","12","12","ଜିସୁ ବାରି ମୁଇଂତର୍ ପାରୁସିଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଦର୍‌ତନିନେ ତାର୍କିଗ୍‍ ଜାଣ୍ଡେ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଏ ମେଁ ଜିବନ୍‍ନେ ତାର୍କିଗ୍‍ ବାଏ ଆରି ଅଃନା ଡିଗ୍ ତାଙ୍ଗ୍‍କିଗ୍‍ନ୍ନିଆ ଆୱେଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_13","073_8_13","JHN","8","13","13","ଆତ୍‍ ଅରିଆ ଫାରୁଶୀ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଏକେ ନିଜେ ନ୍‍ସା ସାକି ବିଃନାଡିଙ୍ଗ୍‍କେ । ତେଲା ନା ମେଃନେ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‍, ଆତେନ୍‌ ସତ୍‌ ପାର୍‌ମାନ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_14","073_8_14","JHN","8","14","14","ଜିସୁ ଉତର୍ ବିକେ “ଣ୍ଡୁ ନେଙ୍ଗ୍ ନିଜର୍‌ନେ ନ୍‌ସା ସାକି ମ୍ବିଲା ଡିଗ୍‍ ନେଙ୍ଗ୍ ମେଁନେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଆତେନ୍‌ ସତ୍ ମେଃନ୍‌ସା ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆଣ୍ଡି ବାନ୍ ପାଙ୍ଗ୍‍ନେ ଆରି ଆଣ୍ଡି ଙ୍ଗୁଏଃଏ ଆତେନ୍‌ ନେଙ୍ଗ୍ । ମାତର୍‌ ଆଣ୍ଡି ବାନ୍ ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‌ନେ ଆଣ୍ଡିବାନ୍ ନେଙ୍ଗ୍ ତାର୍‌ନ୍ଲେଃକେ ଆତେନ୍‌ ପେ ପେମ୍ୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN8_15","073_8_15","JHN","8","15","15","ପେ ରେମୁଆଁଇଂ ସୁଗୁଆ ବିଚାର୍ ଡିଙ୍ଗ୍ ଲାଲାପା, ନେଙ୍ଗ୍ ଆଜା ଡିଗ୍ ବିଚାର୍ ନାଡିଙ୍ଗ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN8_16","073_8_16","JHN","8","16","16","ମାତର୍‌ ନେଙ୍ଗ୍ ଜଦି ବିଚାର୍ ମ୍ପାଡିଙ୍ଗ୍‍ ନେଙ୍ଗ୍ ବିଚାର୍ ଜାବର୍ ପାଡିଙ୍ଗ୍‍ ମେଃନ୍‌ସା ଡାଗ୍ଲା ନେଙ୍ଗ୍ ମୁଇଂଜା ଏନ୍‌ କାମ୍ ନାଡିଙ୍ଗ୍‍ ଣ୍ଡୁ ମାତର୍‌ ଆନେକେ ବେବକ୍ନେ ମ୍ନାଃ ଆବା ନେଙ୍ଗ୍ ଏତେ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_17","073_8_17","JHN","8","17","17","ପେନେ ଦରମ୍ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ ବକେ ମ୍ବାୟାନେ ସାକି ସାମୁଆଁ ସମାନ୍ ଡିଙ୍ଗ୍‌ଲା ମେଇଂ ମେଁନେ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ଆତେନ୍‌ ସତ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN8_18","073_8_18","JHN","8","18","18","ନେଙ୍ଗ୍ ନିଜେ ନ୍‌ସା ନେଙ୍ଗ୍ ସାକି ବିଣ୍ଡିଂ ଆରି ଆନେକେ ବେବକ୍ନେ ମ୍ନାଃ ଆବା ଡିଗ୍ ନେଙ୍ଗ୍ ନ୍‌ସା ସାକି ବିଃଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_19","073_8_19","JHN","8","19","19","ଆତ୍‌ଅରିଆ ମେଇଂ ଆମେକେ ପ୍ରସ୍‌ନ ସାଲିଆକୁକେ, “ପେମ୍ବା ଆଣ୍ଡିକା ?” ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଆନେଙ୍ଗ୍‌କେ ଣ୍ଡୁଲା ନେମ୍ବାକେ ପେ ପେମ୍ୟାକେ ଣ୍ଡୁ । ଆନେଙ୍ଗ୍‌କେ ମ୍ୟାପେଲେଃଲା ନେମ୍ବାକେ ଡିଗ୍ ମ୍ୟାପେପାଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_20","073_8_20","JHN","8","20","20","ମନ୍ଦିର୍‌ନେ ଦାନ୍ ସାଲ୍ୟାନେ ପିଡ଼ିନ୍ନିଆ ବମ୍ୟାକ୍ନେ ବାକ୍ରାନ୍ନିଆ ଜିସୁ ଏନ୍ ସାପା ବିସୟ୍‌ରେ ସିକ୍ୟା ବିଃଡିଂଗେ ଆରି ଜା ଡିଗ୍ ଆମେକେ ବନ୍ଦି ଆଡିଙ୍ଗ୍ ଆର୍‌କେ ଣ୍ଡୁ । ଡାଗ୍ଲା ମେଁନେ ବେଲା ପାଙ୍ଗ୍ ଆଲେଃକେ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN8_21","073_8_21","JHN","8","21","21","ଜିସୁ ବାରି ମୁଇଂତର୍ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ୱେଣ୍ଡିଂ ପେଇଂ ଆନେଙ୍ଗ୍‌କେ ପେତୁର୍‍ଏ; ମାତର୍‌ ପେଇଂ ନିଜେନେ ପାପ୍‍ରେ ପେଗୁଏଃଏ । ନେଙ୍ଗ୍ ଆଣ୍ଡି ଅରିଆ ୱେଣ୍ଡିଂ ପେଇଂ ଆତ୍‍ ଅରିଆ ୱେପେୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_22","073_8_22","JHN","8","22","22","ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷଇଂ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ଆର୍‌ଡିଙ୍କେ ମେଁ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍; “ମେଁ ଆଣ୍ଡିଅରିଆ ୱେଏ ନେ ଆତ୍‍ଅରିଆ ୱେ ନେୟା ଣ୍ଡୁ । ମେଁ ଡେଗ୍‌ଗଃଚେ ଗୁଏନେସା ଏତେଲେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN8_23","073_8_23","JHN","8","23","23","ଜିସୁ ଏନ୍ ସାମୁଆଁନେ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ ବାନ୍ ଜନମ୍; ମାତର୍‌ ନେଙ୍ଗ୍ କିତଂବାନ୍ ପାଙ୍ଗ୍‍ନେ । ପେଇଂ ଏ ଦର୍‌ତନିନେ ନେଙ୍ଗ୍ ଆକେନ୍ ମଞ୍ଚ୍‌ପୁର୍‌ ବାନ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN8_24","073_8_24","JHN","8","24","24","ନେଙ୍ଗ୍ ଆପେକେ ବାସଙ୍ଗ୍‍ମ୍ବଗେ ପେ ପେନେ ପାପ୍‍ରେ ପେଗୁଏଃଏ ନେଙ୍ଗ୍ ଜେ ଆତେନ୍‌ ରେମୁଆଁ ପେଇଂ ସତ୍ ପେମାନେଲା ନିଜେନେ ପାପ୍‍ନ୍ନିଆ ପେଗୁଏଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_25","073_8_25","JHN","8","25","25","ମେଇଂ ସାଲିଆକୁକେ “ନା ଜାଣ୍ଡେ ?” ଜିସୁ ଉତର୍ ବିକେ “ଆତେନ୍‌ ସାମୁଆଁ ନେଙ୍ଗ୍ ମୁଲେବାନ୍‍ ବାସଙ୍ଗ୍‌ଚେ ପାଙ୍ଗ୍ ନ୍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_26","073_8_26","JHN","8","26","26","ପେନେ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‍ନେସା ଆରି ପେନେ ବିଚାର୍ ଡିଙ୍ଗ୍‍ନେସା ନେଙ୍ଗ୍‌ନେ ଗୁଲେ ସାମୁଆଁ ଲେଃକେ । ମାତର୍‌ ଜା ଆନେଙ୍ଗ୍ ବେବକେ ମେଁ ସତ୍ । ବାରି ମେଁବାନ୍ ନେଙ୍ଗ୍ ମେଁନେ ଅଁନ୍ଲେକେ; ଆତେନ୍‌‌ଆ ଦର୍‌ତନିନ୍ନିଆ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_27","073_8_27","JHN","8","27","27","ଜିସୁ ମେଁନେ ଆବା ବିସୟ୍‌ରେ କେଚେ ଏନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗେ ଡାଗ୍‌ଚେ ମେଇଂ ଦ୍ରିଗ୍ ଆୟା ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN8_28","073_8_28","JHN","8","28","28","ତେଲା ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଉଡ଼ିବେଲା ପେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ କିତଂ ପେୱେଏ ଅଃତେନ୍‍ ବେଲା ବୁଜେ ପେୟାଏ ସତେଆ ନେଙ୍ଗ୍ ଆତେନ୍‌ । ଅଃତେନ୍‍ ବେଲା ପେଇଂ ପେମ୍ୟାଏ ନେଙ୍ଗ୍ ନିଜେ ଅଦିକାର୍‌ରେ ମେଃଡିଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ମ୍ନାଃ ଆବା ବାନ୍ ମେଁନେ ସିକେନ୍ଲେକେ, ଆତେନ୍‌ ମ୍ବାସଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN8_29","073_8_29","JHN","8","29","29","ଜା ଆନେଙ୍ଗ୍‌କେ ବେବକେ ମେଁ ନେଙ୍ଗ୍ ଏତେ ଲେଃକେ । ମେଁ ଆନେଙ୍ଗ୍‌କେ ମୁଇଂଜାକେ ଆଆନ୍ତାର୍‍ ଣ୍ଡୁ ମେଃନ୍‌ସା ଡାଗ୍ଲା ଜା ମେଁନେ ଇକ୍‌ଚା ମାତର୍‌ ଆତେନ୍‌ ନେଙ୍ଗ୍ କାଲାଆଃ ଡିଙ୍ଗ୍‌ନ୍ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_30","073_8_30","JHN","8","30","30","ଜିସୁନେ ଏନ୍‌ ସାପା ସାମୁଆଁ ଅଁଚେ ଉଡ଼ିରୁଆ ଆମେକେ ସତ୍ ମାନେଃ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_31","073_8_31","JHN","8","31","31","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ମେଁନେଡାଗ୍ରା ସତ୍‍ ମାନେଃଡିଂକ୍ନେ ଇହୁଦୀଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଜଦି ନେଙ୍ଗ୍‌ନେ ବ୍ନାଇର୍‌କେ ପାଲନ୍ ପେଡିଙ୍ଗ୍‌ଏ ତେଲା ପେ ସତେଆ ନେଙ୍ଗ୍‌ନେ ସିସ୍‍ ପେଡିଙ୍ଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN8_32","073_8_32","JHN","8","32","32","ପେଇଂ ସତ୍ ପେମ୍ୟାଏ ଆରି ସତ୍ ଆପେକେ ମୁକ୍ତି ଆଃଡିଙ୍ଗ୍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_33","073_8_33","JHN","8","33","33","ଇହୁଦୀଇଂ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଅବ୍ରାହାମ୍‌ନେ କୁଲ୍‍; ଆରି ଅଃନା ଜାନେ ଗତି ଡିଙ୍ଗ୍ ନେଲେଗେ ଣ୍ଡୁ । ନାଁ ମେଃନ୍‌ସା ବାସଙ୍ଗ୍‌ନାଣ୍ଡିଂ ନେ ମୁକ୍ତି ନେଡିଙ୍ଗ୍‌ଏ, ଏନ୍‌ ସାମୁଆଁନେ ଅର୍‌ତ ମେଃନେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN8_34","073_8_34","JHN","8","34","34","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଜାଣ୍ଡେଇଂ ପାପ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ମେଇଂ ସାପାରେ ପାପ୍‍ନେ ଗତିରେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_35","073_8_35","JHN","8","35","35","ଗତିରେ କାଲାଆଃ ଡୁଆଣ୍ଡ୍ରେ ଏତେ ମୁଇଂଜା ଡିଗ୍ ଲେଃଆୟା ଣ୍ଡୁ । ମାତର୍‌ ଗଡ଼େଅ ଡୁଆଣ୍ଡ୍ରେନେ କାଲାଆଃ ଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN8_36","073_8_36","JHN","8","36","36","ଗଡ଼େଅ ଜଦି ଆପେକେ କୁଲାସ୍‍ ଆଡିଙ୍କେ ପେ ସତେଆଃ ମୁକ୍ତି ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN8_37","073_8_37","JHN","8","37","37","ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ ପେଇଂ ଅବ୍ରାହାମ୍ କୁଲ୍‍ନେ ରେମୁଆଁ । ତେଲା ଡିଗ୍ ପେ ଆନେକେ ବାଗୁଏଃ ନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍‌କେ ମେଃନ୍‌ସା ଡାଗ୍ଲା ପେ ନେଙ୍ଗ୍‌ନେ ଗିଆନ୍‍ ମାନେନ୍‌ସା ରାଜି ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN8_38","073_8_38","JHN","8","38","38","ନେମ୍ବାନ୍ନିଆ ନେଙ୍ଗ୍ ମେଁନେ କେନ୍ଲେକେ ଆତେନ୍‌ ନେଙ୍ଗ୍ ମ୍ବାସଙ୍ଗ୍‍ଏ । ମାତର୍‌ ପେମ୍ବା ବାସଙ୍ଗ୍‌ଲା ପେ କାମ୍ ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_39","073_8_39","JHN","8","39","39","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେମ୍ବା ଜା ଅବ୍ରାହାମ୍ ।” ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ପେ ଜଦି ସତେଆ ଅବ୍ରାହାମ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ, ମେଁ ମେଃ ଡିଂବଗେ, ପେ ଦେତ୍ ପେପାଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN8_40","073_8_40","JHN","8","40","40","ଇସ୍‌ପର୍‌ନେ ବାନ୍ ଅଁନ୍ଲେକେ ସତ୍‍କେ ବାସଙ୍ଗ୍‌ନେ ଆନ୍ତାର୍ଚେ ନେଙ୍ଗ୍ ଆରି ମେଁନେ ନାବାସଙ୍ଗ୍‌କେ ଣ୍ଡୁ; ତେଲାଡିଗ୍‍ ପେ ଆନେଙ୍ଗ୍‌କେ ଜିବନ୍‌ରେ ବାଗୁଏ ବିନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ । ଅବ୍ରାହାମ୍ ଦେକ୍‌ରକମ୍ କାମ୍ ଡିଙ୍ଗ୍ ଆବଗେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_41","073_8_41","JHN","8","41","41","“ପେମ୍ବାଇଂ ମେଁ ଡିଙ୍ଗ୍‍ବଗେ ପେ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍ ।” ମେଇଂ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ “ମାତର୍‌ ଇସ୍‌ପର୍ ନେନେ ମ୍ନାଃ ଆବା ନେ ମେଃନେ ସତେଆ ଉଙ୍ଗ୍‌ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_42","073_8_42","JHN","8","42","42","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଇସ୍‌ପର୍ ଜଦି ସତେଆ ପେନେ ମ୍ନାଃ ଆବା ଡିଙ୍ଗ୍ ପାଲେ ତେଲା ପେ ଆନେଙ୍ଗ୍‌କେ ଆଲାଦ୍ ପେପାଡିଙ୍ଗ୍‍ ମେଃନ୍‌ସା ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଇସ୍‌ପର୍‌ନେ ବାନ୍ ପାଙ୍ଗ୍‌ଚେ ଏକେ ଆକ୍‌କେ ନ୍ଲେକେ । ନେଙ୍ଗ୍ ନିଜେ ଅଦିକାର୍‌ରେ ନେପାଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ମାତର୍‌ ମେଁ ଆନେଙ୍ଗ୍‌କେ ବେବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_43","073_8_43","JHN","8","43","43","ନେଙ୍ଗ୍ ମେଁନେ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ମେଃନ୍‌ସା ପେବୁଜେକେ ? ଏନ୍‌ ମେଁନେ ଡାଗ୍ଲା ପେ ନେଙ୍ଗ୍‌ନେ ଗିଆନ୍‍ ଅଁଚେ ସାମ୍ବାଲେ ପେୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_44","073_8_44","JHN","8","44","44","ପେଇଂ ପେମ୍ବାଇଂ ସ‍ଏତାନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ; ମେଁନେ ଇକ୍‌ଚାରେ କାମ୍ ଡିଙ୍ଗ୍‍ନେସା ରାଜି । ଆରେକ୍ନେ ମୁଲେ ବାନ୍‍ ଆଃ ମେଁ ଲେଃଗେ ରେମୁଆଁ ବାଗୁଏଃନେ । ମେଁ ଅଃନା ସତ୍‍ନେ ପାକା ଆଲେଃଗେ ଣ୍ଡୁ ଡାଗ୍ଲା ମେଁନେ ଡାଗ୍ରା ଇଡ଼ିଙ୍ଗ୍ ଡିଗ୍ ସତ୍ ଣ୍ଡୁ । ମିଚ୍‌ ବାସଙ୍ଗ୍‌ନେ ମେଁନେ ଅବ୍ୟାସ୍ । ଡାଗ୍ଲା ମେଁ ନିଜେ ମିଚ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡ୍ରେ ଆରି ସାପା ମିଚ୍‌ନେ ରେମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("JN8_45","073_8_45","JHN","8","45","45","ମାତର୍‌ ନେଙ୍ଗ୍ ସତ୍ ମ୍ବାସଙ୍ଗ୍‍ଏ ଆତେନ୍‌‍ସା ପେ ଆନେଙ୍ଗ୍‌କେ ସତ୍ ପେମାନେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_46","073_8_46","JHN","8","46","46","ନେଙ୍ଗ୍ ପାପି ଡାଗ୍‌ଚେ ପେ ବିତ୍ରେ ଜା ପାର୍‍ମାନ୍‍ ଡିଙ୍ଗ୍‍ପେୟା ? ନେଙ୍ଗ୍ ଜଦି ସତ୍ ମ୍ବାସଙ୍ଗ୍‍ଏ ଆନେଙ୍ଗ୍‌କେ ପେ ମେସା ସତ୍ ପେମାନେକେ ? ");
INSERT INTO gaq_vpl VALUES ("JN8_47","073_8_47","JHN","8","47","47","ଜା ଇସ୍‌ପର୍‌ନେ ବାନ୍ ଜନମ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଇସ୍‌ପର୍‌ନେ ବ୍ନାଲିର୍ ଅଁଏ । ପେ ଇସ୍‌ପର୍‌ନେ ବାନ୍ ଜନମ୍ ଣ୍ଡୁ; ତେସା ନେଙ୍ଗ୍ ସାମୁଆଁନ୍ନିଆ ଦିଆନ୍ ପେବିକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_48","073_8_48","JHN","8","48","48","ମେଇଂ ଜିସୁକେ ସାଲିଆକୁକେ, “ନାଁ ମୁଇଙ୍ଗ୍ ସମିରଣୀୟ ଆରି ସେଆଁରେ ଏନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ନେ ପାକା ସମାନ୍ ଆଡିଂକେ ଣ୍ଡୁ କି ?” ");
INSERT INTO gaq_vpl VALUES ("JN8_49","073_8_49","JHN","8","49","49","ଜିସୁ ଉତର୍ ବିକେ “ଣ୍ଡୁ ନେଙ୍ଗ୍ ସେଆଁରେ ଣ୍ଡୁ । ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଆବା ଇସ୍‌ପର୍‌କେ ସନମାନ୍ ବିଃଡିଂକେ ମାତର୍‌ ପେ ଆନେକେ ଅପ୍‍ମାନ୍‍ ବିପେଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN8_50","073_8_50","JHN","8","50","50","ନେଙ୍ଗ୍ ନିଜେ ନିଜେକେ ମ୍ନାଃ ଡିଙ୍ଗ୍‍ନେସା ଇକ୍‌ଚା ନାଡିଙ୍କେ ଣ୍ଡୁ । ମାତର୍‌ ଏନ୍‌ ସାମୁଆଁ ନେଙ୍ଗ୍‍ନେସା ବାରି ମୁଇଂଜା ଚାଏଁ ଡିଙ୍ଗ୍ ବାରି ମେଁ ନେଙ୍ଗ୍ ପାକା ବିଚାର୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN8_51","073_8_51","JHN","8","51","51","ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଜା ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ପାଲନ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ମେଁ ଅଃନା ଆଗୁଏ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_52","073_8_52","JHN","8","52","52","ମେଇଂ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ଏକେ ନେ ମ୍ୟାନେଲେକେ ଜେ ଆନାକେ ସେଆଁରେ ସାଃଲେଃକେ । ଅବ୍ରାହାମ୍ ବାରି ବାବବାଦି ସାପାରେ ଗୁଏ ଲେଃଆର୍‌କେ; ଆରି ନାଁ ବାସଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍‍ ଜା ନାନେ ସାମୁଆଁ ପାଲନ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଅଃନା ଆଗୁଏଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN8_53","073_8_53","JHN","8","53","53","ନେନେ ଅସେନେ ନ୍ତାଞ୍ଜା ଅବ୍ରାହାମ୍ ଗୁଏଲେଃକେ । ନାଁ ମେଃନେ ଅବ୍ରାହାମ୍ ବାନ୍ ମ୍ନା ଡାଗ୍‌ଚେ ଏତେ ନାଡିଙ୍ଗ୍‍ ?” ବାବବାଦିଇଂ ଡିଗ୍ ଗୁଏଃ ଆର୍‌କେ । “ନାଁ ନିଜେକେ ଜାଣ୍ଡେ ଡାଗ୍‌ଚେ ବାବେ ନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN8_54","073_8_54","JHN","8","54","54","ଜିସୁ ଉତର୍ ବିକେ, “ନେଙ୍ଗ୍ ଜଦି ନିଜେକେ ମ୍ନାଃ ଡିଙ୍ଗ୍‍ନେସା ଚେସ୍‌ଟା ମ୍ପାଡିଙ୍ଗ୍‍, ଆକ୍‌ମେନେ ମେଃ ଡିଗ୍ ମୁଲ୍ୟ ଆପାଲେଃ । ଜା ଆନେଙ୍ଗ୍ ଗୌରବ୍‌ ଡିଙ୍ଗ୍‌ଏ, ମେଁ ନେଙ୍ଗ୍‌ନେ ଆବା ଆଜାକେ ପେ ପେନେ ଇସ୍‌ପର୍ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("JN8_55","073_8_55","JHN","8","55","55","ପେ ଆମେକେ ଅଃନା ପେମ୍ୟାକେ ନେଙ୍ଗ୍ ଆମେକେ ମ୍ୟାନ୍ଲେକେ । ଆମେକେ ନାମ୍ୟାକେ ଣ୍ଡୁ ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍ ଜଦି ମ୍ବାସଙ୍ଗ୍‍ଏ, ପେ ସୁଗୁଆ ନେଙ୍ଗ୍ ଡିଗ୍ ମୁଇଙ୍ଗ୍ ପଙ୍ଗାଲ୍‌ ଣ୍ଡିଂଏ । ମାତର୍‌ ନେଙ୍ଗ୍ ଆମେକେ ମ୍ୟାନ୍ଲେକେ ଆରି ମେଁନେ ସାମୁଆଁ ମାନେଃ ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN8_56","073_8_56","JHN","8","56","56","ନେଙ୍ଗ୍‌ ପାଙ୍ଗ୍‌ନେ କେପେୟାଏ ଡାଗ୍‌ଚେ ଆସା ଡିଙ୍ଗ୍‌ଚେ ପେମ୍ବା ଅବ୍ରାହାମ୍ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଲେଗେ, ନିମାଣ୍ଡା ଆନେଙ୍ଗ୍‌କେ କେଚେ ମେଁନେ ଉଡ଼ି ସାର୍ଦା ଡିଙ୍ଗ୍‌ଲେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_57","073_8_57","JHN","8","57","57","ମେଇଂ ସାଲିଆକୁକେ, “ମେଁନେ ଆନାକେ ମ୍ବାର୍‍କୁଡ଼ି ଗୁଆ ମୁଆଁ ଡିଗ୍ ଆଡିଙ୍କେ ଣ୍ଡୁ; ନାନେ ଅବ୍ରାହାମ୍‍କେ କେନାଲେଃକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN8_58","073_8_58","JHN","8","58","58","ଜିସୁ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଅବ୍ରାହାମ୍‌ନେ ଜନମ୍ ଡିଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ନେଙ୍ଗ୍ ନ୍ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN8_59","073_8_59","JHN","8","59","59","ଆକେନ୍ ଅଁଚେ ମେଇଂ ଆମେକେ ବଗ୍‍ନ୍‍ସା ବ୍ରି ଜଗ୍‍ଆର୍‌କେ । ମାତର୍‌ ଜିସୁ ସାପାରେବାନ୍‍ ସେନୁଗ୍‍ ମନ୍ଦିର୍‍ ଆନ୍ତାର୍ଚେ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_1","073_9_1","JHN","9","1","1","ମେସୁଆ ଜିସୁ ଗାଲି ୱେନେ ବେଲା ମୁଇଙ୍ଗ୍ କାନାକେ ଅବାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_2","073_9_2","JHN","9","2","2","ସିସ୍‍ଇଂ ସାଲିଆକୁକେ, “ଗୁରୁ ଜାନେ ପାପ୍‌ ନ୍‌ସା ଏନ୍‌ ରେମୁଆଁ କାନା ଡିଙ୍ଗ୍‌ଚେ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେ ମେଁ ନିଜେନେ ଲେଃ ମେଁନେ ବା ଡିଆନେ ପାପ୍‌ ନ୍‌ସା ?” ");
INSERT INTO gaq_vpl VALUES ("JN9_3","073_9_3","JHN","9","3","3","ଜିସୁ ଉତର୍ ବିକେ “ମେଁନେ ଲେଃ ମେଁ ବାଡ୍ୟାନେ ପାପ୍‌- ମେଃନେଡିଗ୍ କ୍ମେନେ କାରନ୍‌ ଣ୍ଡୁ ଇସ୍‌ପର୍‌ନେ ବପୁ ଡିରକମ୍ ମେଁନ୍ନିଆ ତାର୍‌ଏ ଡାଗ୍‌ଚେ ମେଁ ଏଃକେ କାନା ଡିଙ୍ଗ୍‌ଚେ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_4","073_9_4","JHN","9","4","4","ସ୍ମିନେ ତାର୍କିଗ୍ ଲେଃ ବିତ୍ରେ, ଆନିଂକେ ବେବକ୍ନେ ମାପ୍ରୁନେ କାମ୍ ନିଂ ଡିଙ୍ଗ୍‌ନେ ପଡ଼େଏ । ମିଡିଗ୍ ଡିଂକେ ଆତେନ୍‌ ବେଲା ଜା କାମ୍ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN9_5","073_9_5","JHN","9","5","5","ଏନ୍‌ ଦର୍‌ତନିନ୍ନିଆ ଲେଃଜାକ ନେଙ୍ଗ୍ ଦର୍ତନିନେ ତାର୍କିଗ୍‍ସ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_6","073_9_6","JHN","9","6","6","ଦେକ୍ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁ ତୁବନ୍ନିଆ ବିତୁର୍‌ଚେ ଇକୁଡ଼ା ବୁର୍ଦା ଆଡିଙ୍କେ; ଆତେନ୍‌ ଇକୁଡ଼ା ଡୁଙ୍ଗ୍‍ ୱେଚେ ରେମୁଆଁନେ ମ୍ମୁଆଃନ୍ନିଆ ଲିଗ୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("JN9_7","073_9_7","JHN","9","7","7","“ୱେଲା ଶିଲୋହ ବନ୍ଦ୍‍ନ୍ନିଆ ଗେମୁଆଁଚେ ପାଙ୍ଗ୍‌ଲା ।” ଶିଲୋହ ଡାଗ୍ଲା ପ୍ରେରିତ୍‌ ଆତେନ୍‌ ରେମୁଆଁ ୱେଚେ ଗେମୁଆଁଚେ ମୁଆଃ କିକେନେ ବପୁ ବାଚେ ଆଣ୍ଡେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_8","073_9_8","JHN","9","8","8","ମେଁନେ ଡାଗ୍ରା ଡୁଆଣ୍ଡ୍ରେଇଂ ଆରି ଜାଣ୍ଡେଇଂ ଆମେକେ ସିସେବାନ୍ ବିକ୍‍ ସାଲିଆକ୍ନେ ବେଲା କେଲେଗେ ମେଇଂ ସାଲିଆକୁଆର୍‌କେ “ଏନ୍‌ ରେମୁଆଁ କଚେ ବିକ୍‍ ସାଲିଆ ଆଡିଙ୍ଗେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN9_9","073_9_9","JHN","9","9","9","ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌କେ, “ଅଃଅଁ ଏନ୍‌ ରେମୁଆଁ ଆଃ ।” ବିନ୍‌ଣ୍ଡ୍ରେଇଂ ବାସଙ୍ଗ୍‌କେ, “ଣ୍ଡୁ ମେଁ ଣ୍ଡୁ ମାତର୍‌ ମେଁ ସୁଗୁଆ ତ୍ନାଡିଙ୍ଗ୍‍ ।” ମାତର୍‌ ମେଁ ନିଜେ ବାସଙ୍ଗ୍‌ “ନେଙ୍ଗ୍ଆଃ ଆତେନ୍‌ ରେମୁଆଁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_10","073_9_10","JHN","9","10","10","ରେମୁଆଁଇଂ ଆମେକେ ସାଲିଆକୁକେ, “ତେଲା ନାଁ ଡିରକମ୍ କେୟା ନାଡିଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN9_11","073_9_11","JHN","9","11","11","ଆତେନ୍‌ ରେମୁଆଁ ବାସଙ୍ଗ୍‌କେ, “ଜିସୁ ଡାଗ୍‌ଚେ ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ତୁବନ୍ନିଆ ଇକୁଡ଼ା ତୁବଃ ଆନ୍‍ସିଂଚେ ନେଙ୍ଗ୍ ମ୍ମୁଆଃନ୍ନିଆ ଲିଗ୍ ବିଚେ ଆରି ଶିଲୋହନ୍ନିଆ ଗେମୁଆଚେ ପାଙ୍ଗ୍‌ନେ ବାସଙ୍ଗ୍‌କେ ଦେତୁଆ ୱେଚେ ଗେମୁଆକ୍ନେ ଦାପ୍ରେ ନେଙ୍ଗ୍ କିକେ ଇଁୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_12","073_9_12","JHN","9","12","12","“ମେଁ ଆଣ୍ଡିକା” ଡାଗ୍‌ଚେ ରେମୁଆଁ ଆମେକେ ସାଲିଆକୁକେ । ଆତେନ୍‌ ରେମୁଆଁ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ନାମ୍ୟାଃକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_13","073_9_13","JHN","9","13","13","ମ୍ମୁଆଃ କିକେନେ ବପୁ ବାଲେକ୍ନେ ଆତେନ୍‌ କାନା ରେମୁଆଁକେ ପାରୁସିଇଂନେ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ ୱେଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_14","073_9_14","JHN","9","14","14","ଜିସୁ ଆଣ୍ଡିନେ ଦିନା ତୁବଃ ଆବୁର୍ଦାଚେ ଆମେକେ ମ୍ମୁଆଃ କିକେନେ ବପୁ ବିବଗେ ଆତେନ୍‌ ଦିନା ଲେଃଗେ ପୁଣ୍ଡେନେ ଦିନା । ");
INSERT INTO gaq_vpl VALUES ("JN9_15","073_9_15","JHN","9","15","15","ପାରୁସୀଇଂ ଆମେକେ ସାଲିଆକୁଆର୍‌କେ, “ଡିରକମ୍ ମେଁ ମେଁନେ ମ୍ମୁଆଃ କେୟାକେ ?” ମେଁ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ମ୍ମୁଆଃନ୍ନିଆ ମେଁ ଇକୁଡ଼ା ତୁବଃ ଇକୁଡ଼ା ଲିଗ୍ ବିକେ, ନେଙ୍ଗ୍ ୱେଚେ ମ୍ମୁଆଃ ଗେମୁଆଁଚେ ମ୍ପାକେ । ଏକେ କେୟା ଣ୍ଡିଂ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_16","073_9_16","JHN","9","16","16","ପାରୁସିଇଂନେ ବାନ୍ ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌କେ “ଜା ଏନ୍‌ କାମ୍ ଡିଙ୍ଗ୍‍ବ ମେଁ ଇସ୍‌ପର୍ ବାନ୍ ଆପାଙ୍ଗ୍‌କେ ଣ୍ଡୁ ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଁ ପୁଣ୍ଡେନେ ନିୟମ୍‌ ଆପାଲେକେ ଣ୍ଡୁ ।” ବିନ୍‌ଣ୍ଡ୍ରେଇଂ ବାସଙ୍ଗ୍‌କେ “ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ପାପି ଡିଙ୍ଗ୍‌ଚେ ଦେକ୍ ରକମ୍ କାବା ଡିଙ୍ଗ୍‌କ୍ନେ କାମ୍ ଡିରକମ୍ ଡିଙ୍ଗ୍‍ୟାଏ ?” ଆକେନ୍ ବିସୟ୍‌ରେ ମେଇଂନେ ବିତ୍ରେ ୱିଙ୍ଗ୍‌ଆରିଙ୍ଗ୍‍ଆ ଡିଙ୍ଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_17","073_9_17","JHN","9","17","17","ଫାରୁଶୀଇଂ ଆତେନ୍‌ ରେମୁଆଁକେ ବାରି ମୁଇଂତର୍ ସାଲିଆକୁକେ, “ନା ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‍, ମେଁ ଆନାକେ ମ୍ମୁଆଃ ଆକେବକେ, ମେଁନେ ବିସୟ୍‌ରେ ନା ମେଃନେ ବାସଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍‍କେ ?” ଆତେନ୍‌ ରେମୁଆଁ ବାସଙ୍ଗ୍‌କେ । “ମେଁ ମୁଇଙ୍ଗ୍ ବାବବାଦି ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_18","073_9_18","JHN","9","18","18","ମାତର୍‌ ମେଁ ଜନମ୍ ବାନ୍‍ ଆଃ କାନା ଲେଃଗେ ଆରି ଏକେ ମୁଆଃ ବପୁ ବାଲେଃ । ଏନ୍‌ ସାମୁଆଁ ମେଁନେ ବାଡିଆକେ ସାଲିଆକୁଚେ ମାବୁଜେ ଜାକ ଜିଉଦି କର୍ତ୍ତୁପକ୍ଷଇଂ ସତ୍ ମାନେନ୍‍ସା ଚାଏଁ ଆଡିଙ୍ଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN9_19","073_9_19","JHN","9","19","19","ତେଲା ମେଇଂ ମେଁନେ ବାଡିଆକେ ସାଲିଆକୁକେ “ଏନ୍‌ ନାଉଂ ? ମେଁ କାନା ଡିଙ୍ଗ୍‌ଚେ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେଗେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍ । ତେଲା ମେଁ ଏକେ ଡିରକମ୍ କେୟାଡିଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN9_20","073_9_20","JHN","9","20","20","ମେଁନେ ବାଡିଆ ଉତର୍ ବିକେ “ଅଃଅଁ ଆତେନ୍‌ ନେଙ୍ଗ୍‌ନେ ଗଡ଼େଅ ମେଁ କାନା ଡିଙ୍ଗ୍‌ଚେ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେଗେ ଆକେନ୍ ନେ ମ୍ୟାନେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_21","073_9_21","JHN","9","21","21","ମାତର୍‌ ମେଁ ଏକେ ଡିରକମ୍ କେଡିଂକେ ଆରି ଜା ଆମେକେ କିକେନେ ବପୁ ବିବ ନେ ଆମେକେ ନେମ୍ୟାକେ ଣ୍ଡୁ । ମେଁନେ ବଏସ୍‍ ଡିଙ୍ଗ୍‌ଲେ ଆମେକେ ସାଲିଆକୁପା ମେଁ ନିଜେ ନିଜେନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_22","073_9_22","JHN","9","22","22","ରେମୁଆଁନେ ବାଡିଆ ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷଇଂକେ ବୁଟଚେ ଏନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ବଗେ । ମେଃନ୍‌ସା ଡାଗ୍ଲା ଆତେନ୍‌ କର୍ତ୍ତୁପକ୍ଷଇଂ ଚାଏଁ ଲେଃଗେ ଜେ ଜାଣ୍ଡେଇଂ ଜିସୁକେ କିସ୍‌ଟ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌ଏ ଆମେଇଂକେ କୁକପାର୍‌ ଡୁଆ ବାନ୍ ଆନ୍ତାର୍ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("JN9_23","073_9_23","JHN","9","23","23","ଆତେନ୍‌‍ସା ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ବାଡ଼େ ବାସଙ୍ଗ୍‌କେ “ମେଁନେ ବୟସ୍‍ ଡିଙ୍ଗ୍‌ଲେକେ ଆମେକେ ସାଲ୍ୟାକୁପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_24","073_9_24","JHN","9","24","24","ଫାରୁଶୀଇଂ ଆତେନ୍‌ କାନା ରେମୁଆଁକେ ବାରି ମୁଇଂତର୍ ୱାଚେ ବାସଙ୍ଗ୍‌କେ, “ଇସ୍‍ପର୍‌ନେ ସାମ୍‌ନେ ପାର୍‍ମାନ୍‍ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍ ନାଁ ସତ୍ ନାବାସଙ୍ଗ୍‍ଏ । ନେ ମ୍ୟାନେଲେଃକେ, ମୁଡ଼ି ରେମୁଆଁ ଆନାକେ ମ୍ମୁଆଃ କିକେନେ ବପୁ ବିବକେ, ମେଁ ମୁଇଙ୍ଗ୍ ପାପି ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_25","073_9_25","JHN","9","25","25","ଆତେନ୍‌ ରେମୁଆଁ ଉତର୍ ବିକେ “ମେଁ ପାପି ଲେଃ ଣ୍ଡୁ ନେଙ୍ଗ୍ ନ୍ନାମ୍ୟାକେ ଣ୍ଡୁ । ମାତର୍‌ ମୁଇଙ୍ଗ୍ ସାମୁଆଁ ମ୍ୟାନ୍ଲେକେ ନେଙ୍ଗ୍ କାନା ନ୍ଲେଗେ ଏକେ କେୟାଣ୍ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_26","073_9_26","JHN","9","26","26","ମେଇଂ ସାଲିଆକୁକେ, “ଆନାକେ ମେଁ ମେଃ ଡିଂକେ ? ଡିରକମ୍ ମେଁ ନାନେ ମ୍ମୁଆଃ ଆକେ ବିକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN9_27","073_9_27","JHN","9","27","27","ଆତେନ୍‌ ରେମୁଆଁ ଉତର୍ ବିକେ “ସେନୁଗ୍‍ ତ ବାସଙ୍ଗ୍‌ ଆଡା ମ୍ବକେ ମାତର୍‌ ପେ ଆତେନ୍‌ ସାମୁଆଁକେ ଦ୍ରିଗ୍‌ନ୍‌ସା ଇକ୍‌ଚା ପେଡିଂକେ ଣ୍ଡୁ । ବାରି ମୁଇଂତର୍ ଦ୍ରିଗ୍‌ନ୍‌ସା ମେସା ଚାଏଁ ପେଡିଙ୍ଗ୍ ? ନ୍ନାମ୍ୟାକେ ଣ୍ଡୁ ପେଡିଗ୍ ମେଃନେ ସିସ୍‍ ଡିଙ୍ଗ୍‍ନେସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍ ପେଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_28","073_9_28","JHN","9","28","28","ମେଇଂ ଆମେକେ ସାଇବ୍‍ ବିଚେ ବାସଙ୍ଗ୍‌କେ “ନା ସିନା ମେଁନେ ସିସ୍‍ । ମାତର୍‌ ନେ ମୋଶାନେ ସିସ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("JN9_29","073_9_29","JHN","9","29","29","ନେ ମ୍ୟାନେଲେଃକେ, ଇସ୍‌ପର୍ ମୋଶା ଏତେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ଆର୍‌ଗେ । ମାତର୍‌ ଆତେନ୍‌ ରେମୁଆଁ ଆଣ୍ଡିବାନ୍ ପାଙ୍ଗ୍‌ଲେ ଆତେନ୍‌ ଡିଗ୍ ନେମ୍ୟାଃକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_30","073_9_30","JHN","9","30","30","ରେମୁଆଁ ଉତର୍ ବିକେ “ଏନ୍‌ ଉଡ଼ି ବକୁଆ ଡିଙ୍ଗ୍‌କ୍ନେ ସୁଗୁଆ ସାମୁଆଁ ମେଁ ଆଣ୍ଡିବାନ୍ ପାଙ୍ଗ୍‌ଲେକେ ପେ ପେମ୍ୟାକେ ଣ୍ଡୁ; ମାତର୍‌ ମେଁ ଆନେଙ୍ଗ୍‌କେ ମ୍ମୁଆଃ କିକେନେ ବପୁ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_31","073_9_31","JHN","9","31","31","ନେ ସାପାରେ ମ୍ୟାଃନେଲେଃକେ, ଇସ୍‌ପର୍ ପାପିଇଂନେ ସାମୁଆଁ ଆଅଁ ଣ୍ଡୁ । ଜାଣ୍ଡେଇଂ ଇସ୍‍ପର୍‌କେ ପାଲେ ଆର୍‌ଏ ଆରି ମେଁଇଂନେ ଇକ୍‌ଚାରେ କାମ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଇସ୍‌ପର୍ ମାତର୍‌ ମେଁଇଂନେ ସାମୁଆଁ ଅଁଏ । ");
INSERT INTO gaq_vpl VALUES ("JN9_32","073_9_32","JHN","9","32","32","ଅସେବାନ୍‍ ଜା କାନାକେ ମ୍ମୁଆଃ କିକେନେ ବପୁ ବିଃକ୍ନେ ସାମୁଆଁ ଅଃନା ଅଁ ନେଲେଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN9_33","073_9_33","JHN","9","33","33","ଇସ୍‌ପର୍ ବାନ୍ ଆକେନ୍ ରେମୁଆଁ ପାଙ୍ଗ୍ ଆଲେଃଲା ମେଁ ଅଃନା ଏନ୍‌ କାମ୍ ଡିଙ୍ଗ୍ ଆୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_34","073_9_34","JHN","9","34","34","ମେଇଂ ବାସଙ୍ଗ୍‌କେ “ପାପ୍‍ନ୍ନିଆ ଜନମ୍ ଡିଙ୍ଗ୍‌ଚେ ପାପ୍‍ନ୍ନିଆ ମ୍ନା ନେଲେଃକେ । ନା ବାରି ମେଃନେ ଆନେକେ ଆଃସିକେ ନାଡିଙ୍ଗ୍‍କେ ?” ଦେକ୍ ବାସଙ୍ଗ୍‌ଚେ ମେଇଂ ଆମେକେ ଗୁଲିସାଙ୍ଗ୍‌ ବାନ୍ ଆନ୍ତାର୍ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_35","073_9_35","JHN","9","35","35","ଜିସୁ ଏନ୍‌ ସାପା କଟେକ୍ନେ ବିସୟ୍ ଅଁଚେ ବାରି ମୁଇଂତର୍ ଆତେନ୍‌ ରେମୁଆଁକେ ଅବାଚେ ଆମେକେ ସାଲିଆକୁକେ, “ନାଁ ମେଃନେ ରେମୁଆଁ ଉଙ୍ଗ୍‍ଡେନ୍ନିଆ ସତ୍‍ ମାନେଃ ନାଡିଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN9_36","073_9_36","JHN","9","36","36","ମେଁ ଉତର୍ ବିକେ “ଅ ମାପ୍ରୁ, ମେଁ ଜାଣ୍ଡେଃ ବାସଙ୍ଗ୍‌, ଆମେକେ ନେଙ୍ଗ୍ ସତ୍ ମ୍‍ମାନେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_37","073_9_37","JHN","9","37","37","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ନାଁ ଆମେକେ କେନାଲେକେ ! ନାଁ ଏତେ ଜା ଏକ୍ରେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗେ ମେଁ ଆତେନ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_38","073_9_38","JHN","9","38","38","“ନେଙ୍ଗ୍ ସତ୍ ମାନେଃ ଣ୍ଡିଙ୍ଗ୍‍ ମାପ୍ରୁ !” ଦେକ୍ ବାସଙ୍ଗ୍‌ଚେ ଆତେନ୍‌ ରେମୁଆଁ ଜିସୁନେ ସେନୁଗ୍‍ ଡେଙ୍ଗଚେ ସାର୍ଲକେ । ");
INSERT INTO gaq_vpl VALUES ("JN9_39","073_9_39","JHN","9","39","39","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ରେମୁଆଁନେ ବିଚାର୍ ନ୍‌ସା ନେଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌ ପାଙ୍ଗ୍‍ଲେକେ । କାନାଇଂ ମ୍ମୁଆଃ କିକେନେ ବପୁ ବାଆର୍‌ଏ ମାତର୍‌ ଗୁଲେରୁଆ ମୁଆଃ ଲେଃଚେ ଡିଗ୍ କାନା ଡିଙ୍ଗ୍ଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_40","073_9_40","JHN","9","40","40","ଆତ୍‍ ଅରିଆ ଲେଃକ୍ନେ ଉଡ଼ି ଫାରୁଶୀଇଂ ଏନ୍‌ ସାମୁଆଁ ଅଁଚେ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନେ କାନା ଡାଗ୍‌ଚେ ମେଃନେ ନାଁ ବାବେ ନାଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN9_41","073_9_41","JHN","9","41","41","ଜିସୁ ଉତର୍ ବିକେ “କାନା ଡିଙ୍ଗ୍ ପେଲେଲା ପେଇଂ ଦସ୍ ଡିଙ୍ଗ୍ ପେପାଲେ । ମାତର୍‌ କେୟାନାଡିଙ୍ଗ୍‍କେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍‌ଲା ପେ ଜାବର୍ ଦସି ।” ");
INSERT INTO gaq_vpl VALUES ("JN10_1","073_10_1","JHN","10","1","1","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ମୁଡ଼ି ରେମୁଆଁ ସାଲାମିଃ ଗାଲି ପାକା ମାଗାଚେ ମାତର୍‌ ବିନ୍‌ ପାକା ଡେଃସା ଗାଏ ମେଁ ଡଙ୍ଗାରେ ଣ୍ଡୁଲା କାଙ୍ଗାର୍ । ");
INSERT INTO gaq_vpl VALUES ("JN10_2","073_10_2","JHN","10","2","2","ଜା ଗାଲି ପାକା ଗାଏ ମେଁ ଡିଙ୍ଗ୍ ଡିଂକେ ମେଣ୍ଡା ତୁର୍ତ୍ୟାରେ । ");
INSERT INTO gaq_vpl VALUES ("JN10_3","073_10_3","JHN","10","3","3","ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ଉର୍‌ଣ୍ଡ୍ରେ ମେଁ ଆତ୍ଲା କାପାଟ୍ ରଃବିଏ ଆରି ମେଁ ନିଜେ ମେଣ୍ଡାଇଂକେ ମ୍ନି ସାଃଚେ ୱାଲା ମେଇଂ ମେଁନେ ୱାକ୍ନେ ଅଁଆର୍‌ଏ ଆରି ମେଁ ଆତେନ୍‌ ଗିମିଃ ମାନ୍ଦାଇଂକେ ପାଦା ପାକା ଡୁଙ୍ଗ୍‌ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("JN10_4","073_10_4","JHN","10","4","4","ଆମେଇଂକେ ପାଦା ପାକା ଡୁଙ୍ଗ୍‌ୱେନେ ବେଲା ସେନୁଗ୍‌ ସେନୁଗ୍‌ ତୁର୍‍ତ୍ୟାରେଇଂ ଅଲେଙ୍ଗ୍‍ଏ ଆରି ମେଣ୍ଡାଇଂ ମେଁଇଂନେ ଇଡ଼ିଙ୍ଗ୍ ଇଡ଼ିଙ୍ଗ୍ ଅଲେଙ୍ଗ୍ ଆର୍‌ଏ ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଇଂ ମେଁନେ ବାସଙ୍ଗ୍‌କ୍ନେ ଅଁଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN10_5","073_10_5","JHN","10","5","5","ମେଇଂ ମାସାମୁଆଁ ରେମୁଆଁନେ ପ୍ଲା ଆୱେଆର୍‌ ଣ୍ଡୁ ଆରି ମେଁନେବାନ୍‍ ଲାଗ୍‍ଡଆର୍‌ଏ ମେଃନ୍‌ସା ଡାଗ୍ଲା ମେଇଂ ମେଁନେ ବାସଙ୍ଗ୍‌କ୍ନେ ସାମୁଆଁ ମ୍ୟାଃଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN10_6","073_10_6","JHN","10","6","6","ଜିସୁ ଉଃସ୍ରା ରକମ୍ ଏନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ବଗେ ମାତର୍‌ ମେଁନେ ସାମୁଆଁକେ ରେମୁଆଁଇଂ ବୁଜେ ଆୟା ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN10_7","073_10_7","JHN","10","7","7","ତେସା ଜିସୁ ବାର୍‌ମୁଇଂତର୍‍ ବାସଙ୍ଗ୍‌କେ “ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଂ ନେଙ୍ଗ୍ ମେଣ୍ଡାଇଂନେ ର୍ଣ୍ଣସାଙ୍ଗ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("JN10_8","073_10_8","JHN","10","8","8","ଜାଣ୍ଡେଇଂ ସାପାରେ ନେଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ପାଙ୍ଗ୍‌ଲେ ମେଇଂ ଡଙ୍ଗାରେ ଆରି ବାଗୁଏରେ । ମାତର୍‌ ମେଣ୍ଡାଇଂ ମେଁଇଂନେ ସାମୁଆଁ ଆ‍ଅଁଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN10_9","073_10_9","JHN","10","9","9","ନେଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡିଂକେ ର୍ଣ୍ଣସାଙ୍ଗ୍‍ । ଜା ନେଙ୍ଗ୍ ପାକା ୱେଚେ ଗାଏ ମେଁ ରକ୍ୟା ବାଏ ଆରି ବିତ୍ରେ ଆରି ପାଦା ପାକା ୱେଚେ ଚେଃମୁଆଁ ଚଙ୍ଗାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN10_10","073_10_10","JHN","10","10","10","ଡଙ୍ଗାରେ ପାଙ୍ଗ୍‌ଏ, ଡଙ୍ଗାଏ, ବାଗୁଏଃଏ ଆରି ଦଂସ ଆଡିଙ୍ଗ୍‍ନେସା ପାଙ୍ଗ୍‌ଏ । ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‍ନେ ଆପେକେ ଜିବନ୍ ବିନେସା, ପେ ଡିରକମ୍ ଜିବନ୍‍ନ୍ନିଆ ଜବର୍ ସାର୍ଦା ଡିଙ୍ଗ୍ ପେୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN10_11","073_10_11","JHN","10","11","11","ନେଙ୍ଗ୍ ନିମାଣ୍ଡା ମେଣ୍ଡା ତୁର୍‌ତ୍ୟାରେ । ଗିମିଃଇଂନେସା ନେଙ୍ଗ୍ ଜିବନ୍ ବିଃନେ ରାଜି । ");
INSERT INTO gaq_vpl VALUES ("JN10_12","073_10_12","JHN","10","12","12","ଜା ସେନୁଗ୍‍ ବାନ୍ ସାଲାମିଃ ଉର୍‍ଲେଃଏ ମେଁ ଗିମିଃ ତୁର୍‌ତ୍ୟାରେ ଣ୍ଡୁ ଲେଃ ସାଲାମିଃନେ ସାକାର୍‍ ଣ୍ଡୁ; ଗଦବାଗ୍ ପାଙ୍ଗ୍‌ନେ କେଲା ମେଁ ଗିମିଇଂକେ ଆନ୍ତାର୍ଚେ ଲାଗ୍‍ଡଏ । ଗଦବାଗ୍ ପାଙ୍ଗ୍‌ଚେ ଗିମିଇଂକେ ଡୁଂଡଏ ଆରି ସାଲାମିଃ ନାସେ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("JN10_13","073_10_13","JHN","10","13","13","ଜା ଗତିରେ ଡିଙ୍ଗ୍‌ଚେ ମେଣ୍ଡା ଉର୍‍ଲେଃଏ ମେଁ ଲାଗ୍‍ଡଏ ମେସା ଡାଗ୍ଲା ମେଇଂ ସ୍ଲେଣ୍ଡ୍ରେ ମାତର୍‌ ମେଣ୍ଡାଇଂ ନ୍‌ସା ମେଁ ଆଏତେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN10_14","073_10_14","JHN","10","14","14","ନେଙ୍ଗ୍ ନିମାଣ୍ଡା ଗିମିଃ ତୁର୍‌ତ୍ୟାରେ । ଆବା ଇସ୍‌ପର୍ ଆନେଙ୍ଗ୍‌କେ ଡିରକମ୍ ମ୍ୟାଲେ ଆରି ନେଙ୍ଗ୍ ଡିରକମ୍ ଆବା ଇସ୍‌ପର୍‌କେ ମ୍ୟାନ୍ଲେକେ ");
INSERT INTO gaq_vpl VALUES ("JN10_15","073_10_15","JHN","10","15","15","ନେଙ୍ଗ୍ ଡିରକମ୍ ଆବାକେ ମ୍ୟାନ୍ଲେକେ ନେଙ୍ଗ୍‌ନେ ମେଣ୍ଡାଇଂକେ ଡିଗ୍ ମ୍ୟାନ୍ଲେକେ ଆରି ମେଇଂ ଡିଗ୍ ଆନେଙ୍ଗ୍‌କେ ମ୍ୟାଲେକେ । ନେଙ୍ଗ୍ ମେଇଂନେସା ନେଙ୍ଗ୍‌ନେ ଜିବନ୍ ବିଃ ନ୍‌ସା ରାଜି । ");
INSERT INTO gaq_vpl VALUES ("JN10_16","073_10_16","JHN","10","16","16","ନେଙ୍ଗ୍‌ନେ ବାରି ବିନ୍‌ ଗିମିଇଂକେ ଲେଃକେ ଜାଣ୍ଡେଇଂ ଏନ୍‌ ସାଲାମିଃ ବିତ୍ରେ ଣ୍ଡୁ । ଆମେଇଂକେ ଡିଗ୍ ଆନେଙ୍ଗ୍‌କେ ଡୁଂପାଙ୍ଗ୍‍ନେ ପଡ଼େଏ । ମେଇଂ ନେଙ୍ଗ୍ ୱାକ୍ନେ ଅଁଆର୍‌ଏ ଆରି ସାପାରେ ମୁଇଙ୍ଗ୍ ସାକାର୍‌ନେ ମୁଇଙ୍ଗ୍ ସାଲାମିଃନ୍ନିଆ ଲେଃଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN10_17","073_10_17","JHN","10","17","17","ନେଙ୍ଗ୍‌ନେ ଜିବନ୍ ବଲିଦାନ୍‍ ବିଃନ୍‍ସା ଇକ୍‌ଚା ଡିଂମ୍ବକ୍ନେସା ଆବା ଆନିଂକେ ଆଲାଦ୍ ଡିଙ୍ଗ୍‌ଡିଂକେ । ଜଦି ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଜିବନ୍‍କେ ଦାନ୍ ମ୍ବିଏ ତେଲା ଆତେନ୍‌ ବାରି ମୁଇଂତର୍ ମ୍ବାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN10_18","073_10_18","JHN","10","18","18","ନେଙ୍ଗ୍ ଜିବନ୍‍କେ ବିନ୍‍ଣ୍ଡ୍ରେ ଡୁଂୱେ ଆୟା ଣ୍ଡୁ । ଆତେନ୍‌ ନେଙ୍ଗ୍ ଇକ୍‌ଚାରେ ଦାନ୍ ମ୍ବିଏ । ନିଜେନେ ଜିବନ୍ ଦାନ୍ ଡିଙ୍ଗ୍‍ନେସା ଆରି ଆମେକେ ଆଃଆଣ୍ଡେ ନ୍‌ସା ନେଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଲେଃକେ । ଆକେନ୍ ଡିଙ୍ଗ୍‍ନେସା ଆବା ଆନେଙ୍ଗ୍‌କେ ଆଦେସ୍‍ ବିବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN10_19","073_10_19","JHN","10","19","19","ଏନ୍‌ ସାପା ସାମୁଆଁନେସା ବାରି ମୁଇଂତର୍ ରେମୁଆଁଇଂନେ ବାନ୍ ବିନ୍‍ ରକମ୍ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN10_20","073_10_20","JHN","10","20","20","ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌କେ “ଆମେକେ ସେଆଁରେ ସାଃଲେଃକେ । ମେଁ ମୁଇଙ୍ଗ୍ ବାୟାକ୍ନେ ମେଁନେ ସାମୁଆଁ ମେଁନ୍‌ସା ଅଁପେଡିଂକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN10_21","073_10_21","JHN","10","21","21","ବିନ୍‌ଣ୍ଡ୍ରେଇଂ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ସେଆଁରେ ସାଲେଃକ୍ନେ ରେମୁଆଁ ଦେକ୍‌ରକମ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ପାୟା ଣ୍ଡୁ । ଆରି ସେଆଁରେ ମେଃନେ କାନାକେ ମ୍ମୁଆଃ ଆକେ ପାୟା ?” ");
INSERT INTO gaq_vpl VALUES ("JN10_22","073_10_22","JHN","10","22","22","ଅଃତେନ୍‍ ବେଲା ରାସଃକିଗ୍‍ ଜିରୁସାଲାମ୍‍ନ୍ନିଆ ମନ୍ଦିର୍‌ ଆରାମ୍‌ ଡିଂନେ ପାଣ୍ଡୁଏ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN10_23","073_10_23","JHN","10","23","23","ଜିସୁ ମନ୍ଦିର୍‌ନେ ଶଲୋମନ୍ ମଣ୍ଡପ୍‌ ଆଡ଼ାତ୍ରା ଅଲେଙ୍ଗ୍ ଡିଙ୍ଗେ ");
INSERT INTO gaq_vpl VALUES ("JN10_24","073_10_24","JHN","10","24","24","ଆତ୍‍ ଅରିଆ ରେମୁଆଁଇଂ ଆମେକେ ଗେରେଚେ ସାଲିଆକୁକେ “ଆରି ଉଡ଼ିସି ଆନେକେ ଏନ୍‌ ସନ୍ଦେଅରେ ନାବଏ ? ସତ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ବିଃଲା ନା ମେଃନେ କିସ୍‌ଟ ?” ");
INSERT INTO gaq_vpl VALUES ("JN10_25","073_10_25","JHN","10","25","25","ଜିସୁ ଉତର୍ ବିକେ, “ନେଙ୍ଗ୍ ସେନୁଗ୍‍ ଆଃ ବାସଙ୍ଗ୍‌ ଆଃଡା ମ୍ବକେ । ପେ ତ ଆନେଙ୍ଗ୍‌କେ ସତ୍ ପେମାନେକେ ଣ୍ଡୁ । ଆବା ଇସ୍‌ପର୍‌ନେ ମ୍ନିରେ କେମତା ବାଚେ ନେଙ୍ଗ୍ ଆତେନ୍‌ ସାପା କାମ୍ ଡିଂଣ୍ଡିଂକେ, ଆତେନ୍‌ ମେଃନେ ନେଙ୍ଗ୍ ପାକା ପାର୍‌ମାନ୍ ପେବିକେ ଣ୍ଡୁ ? ");
INSERT INTO gaq_vpl VALUES ("JN10_26","073_10_26","JHN","10","26","26","ମାତର୍‌ ପେ ସତ୍ ପେମାନେକେ ଣ୍ଡୁ ମେସା ଡାଗ୍ଲା ପେଇଂ ନେଙ୍ଗ୍‌ନେ ମେଣ୍ଡା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN10_27","073_10_27","JHN","10","27","27","ନେଙ୍ଗ୍‌ନେ ମେଣ୍ଡାଇଂ ନେଙ୍ଗ୍ ୱାକ୍ନେ ଅଁଆର୍‌ଏ । ନେଙ୍ଗ୍ ଆପେକେ ମ୍ୟାଃନ୍ଲେକେ ଆରି ମେଇଂ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN10_28","073_10_28","JHN","10","28","28","ନେଙ୍ଗ୍ ଆମେଇଂକେ ଅଃନା ଆଡାକ୍ନେ ଜିବନ୍ ଦାନ୍ ମ୍ବିଏ ମେଇଂ ଅଃନା ଡିଗ୍ ଦଦ୍ୟା ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ । ମେଇଂ ନେଙ୍ଗ୍‌ନେ ବାନ୍ ଜା ଡୁଂଡ ଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN10_29","073_10_29","JHN","10","29","29","ନେଙ୍ଗ୍‌ନେ ଆବା ଆନେଙ୍ଗ୍‌କେ ମେଁନେ ସାପା ବିବକେ ଆତେନ୍‌ ସାପାବାନ୍‍ ମାଲେ ଦାମ୍ ଆବାନେ ଜତନ୍‍ ବକ୍ନେବାନ୍ ଜା ଆମେଇଂକେ ଡୁଂଡ ଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN10_30","073_10_30","JHN","10","30","30","ଆବା ଆରି ନେଙ୍ଗ୍ ମୁଇଂ ଆଃ ।” ");
INSERT INTO gaq_vpl VALUES ("JN10_31","073_10_31","JHN","10","31","31","ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ ରେମୁଆଁଇଂ ଆମେକେ ବଗ୍‍ନେସା ବ୍ରି ଜଗ୍‍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN10_32","073_10_32","JHN","10","32","32","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ନେମ୍ବାନେ ଆଦେସ୍‍ରେ ନେଙ୍ଗ୍ ପେନ୍ନିଆ ଉଡ଼ି ସତ୍‌ କାମ୍ ଡିଂମ୍ବକେ । ଏକେ ବାଗୁଏଃନେସା ପାଙ୍ଗ୍ ପେଲେକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN10_33","073_10_33","JHN","10","33","33","ମେଇଂ ଉତର୍ ବିକେ “ପେନେ ସତ୍ ସ୍ଲେ ନ୍‌ସା ଣ୍ଡୁ ମାତର୍‌ ଇସ୍‌ପର୍ ନିନ୍ଦାନେସା । ନାନେ ସାମାନ୍ୟ ରେମୁଆଁ ମାତର୍‌ ନିଜ୍‌କେ ଇସ୍‌ପର୍ ଏତେ ସମାନ୍ ଆଡିଙ୍ଗ୍ ନାଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN10_34","073_10_34","JHN","10","34","34","ଜିସୁ ଉତର୍ ବିକେ, “ପେନେ ନିଜେନେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍ ବକେ ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‍ମ୍ୟାକେ ପେ ଇସ୍‌ପର୍‌ନେ । ");
INSERT INTO gaq_vpl VALUES ("JN10_35","073_10_35","JHN","10","35","35","ନେ ମ୍ୟାନେଲେଃକେ, ସାସ୍ତର୍‌ ସାମୁଆଁ ଜୁଗ୍‍ ଜୁଗ୍‍ନ୍‍ସା ସତ୍ । ଇସ୍‌ପର୍‌ନେ ସାମୁଆଁ ଜା ଡାଗ୍ରା ବାସଙ୍ଗ୍‍ଏ ଆମେଇଂକେ ଆକ୍ ଅରିଆ ଇସ୍‌ପର୍ ବାସଙ୍ଗ୍‌ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN10_36","073_10_36","JHN","10","36","36","ଆବା ଆନେକେ ସ୍ରିଚେ ଏନ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ବେବକେ ତେଲା ନେଙ୍ଗ୍ ନିଜେକେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ବାସଙ୍ଗ୍‌ନେ ବାନ୍ ଇସ୍‌ପର୍ ନିନ୍ଦା ଡିଙ୍ଗ୍ ଡିଂକେ ଡାଗ୍‌ଚେ ଡିରକମ୍ ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("JN10_37","073_10_37","JHN","10","37","37","ଜଦି ନେଙ୍ଗ୍‌ନେ ଆବାନେ ଇକ୍‌ଚାରେ ନେଙ୍ଗ୍ କାମ୍ ଡିଙ୍ଗ୍ ନ୍ନାଲେଃ ତେଲା ଆନେଙ୍ଗ୍‌କେ ସତ୍ ଆମାନେଗେପା । ");
INSERT INTO gaq_vpl VALUES ("JN10_38","073_10_38","JHN","10","38","38","ମାତର୍‌ ଜଦି ନେଙ୍ଗ୍ ମେଁଇଂନେ ଇକ୍‌ଚାରେ କାମ୍ ଡିଙ୍ଗ୍‌ନ୍ଲେଃଏ ତେଲା ଆନେଙ୍ଗ୍‌କେ ସତ୍ ପେମାନେଲା ଡିଗ୍ ନେଙ୍ଗ୍‌ନେ କାମ୍ କେଚେ ସତ୍‍ ମାନେଃପା । ତେଲା ପେ ଡିଲାଡିଗ୍ ପେମ୍ୟାଏ ନେମ୍ବା ଇସ୍‌ପର୍ ନେଙ୍ଗ୍‍ନ୍ନିଆ ଲେଃକେ ଆରି ନେଙ୍ଗ୍ ମେଁ ଅରିଆ ନ୍ଲେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN10_39","073_10_39","JHN","10","39","39","ମେଇଂ ବାରି ମୁଇଂତର୍ ଜିସୁକେ ସାଚେ ଡୁଙ୍ଗ୍‌ୱେନେସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ଡିଂକେ । ମାତର୍‌ ଜିସୁ ଆତ୍‍ ଅରିଆ ଆଃଆନ୍ତାର୍‌ଚେ ଲାଗ୍‍ଡଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN10_40","073_10_40","JHN","10","40","40","ଜିସୁ ଜର୍ଦ୍ଦନ୍‍ନେ ଇନୁମେତା ପିଙ୍ଗ୍‍ଚାକେ ଜହନ୍ ଆଣ୍ଡି ଅରିଆ ଦିକ୍ୟା ବିଃଡିଂଗେ ମେଁ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ପାଙ୍କେ ଆତ୍‍ ଅରିଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN10_41","073_10_41","JHN","10","41","41","ମେଁ ଡାଗ୍ରା ଉଡ଼ିରୁଆ ପାଙ୍ଗ୍‌କେ । ମେଇଂ ବାଲିର୍‌ବାତା ଡିଂଡିଙ୍ଗେ “ଜହନ୍ ନିଜେ ମେଃଣ୍ଡିଗ୍‍ କାବା ଡିଂକ୍ନେ ସୁଗୁଆ ଡିଙ୍ଗ୍ ଆବଗେ ଣ୍ଡୁ ମାତର୍‌ ଆକ୍‌ମେନେ ବିସୟ୍‌ରେ ମେଁ ମେଁନେ ବାସଙ୍ଗ୍‌ ବଗେ ଆତେନ୍‌ ଜାବର୍ ।” ଆତେନ୍‌ ସାପା ସତ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("JN10_42","073_10_42","JHN","10","42","42","ଆରି ଆତ୍‍ ଅରିଆ ଉଡ଼ିରୁଆ ଜିସୁନ୍ନିଆ ସତ୍ ମାନେଃ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_1","073_11_1","JHN","11","1","1","ବେଥନୀ ଇନିନେ ଲାଜାର୍‍ ମ୍ନିକ୍ନେ ଆଃସି ଲେଃଗେ । ମେଁନେ ମ୍ୱାକ୍ଲିଗ୍‍ ତନାଣ୍ଡେଇଂ ମରିୟମ୍ ଆରି ମାର୍ଥା ଆତେନ୍‌ ଇନି ଲେଃଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_2","073_11_2","JHN","11","2","2","ଏନ୍‌ ମରିୟମ୍ ମୁଇଂତର୍ ମାପ୍ରୁନେ ବାସ୍ନାଚୁ କିଗ୍‍ଚେ ନିଜର୍‌ନେ ଉଗ୍‌ବ ଏତେ ମେଁନେ ଞ୍ଚ ଚୁଃବଗେ । ମେଁନେ ବୟାଁଣ୍ଡେ ଲାଜାର୍‌ ଆଃସି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_3","073_11_3","JHN","11","3","3","ତନାଣ୍ଡେ ବୟାଁଣ୍ଡେ ଲାଜାର୍‍ ଆଃସି ଲେଃଲା ମେଇଂ ଜିସୁନେ ଡାଗ୍ରା କବର୍ ବେକେ “ମାପ୍ରୁ, କେଲା, ଆଜାକେ ନା ଆଲାଦ୍‌ ଡିଂନାମ୍ୟାଃକେ, ମେଁ ଆଃସି ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_4","073_11_4","JHN","11","4","4","ଏନ୍‌ କବର୍ ଅଁଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଏନ୍‌ ରଗ୍‍ନ୍ନିଆ ଲାଜାର୍‍ ଆଗୁଏ ଣ୍ଡୁ । ମାତର୍‌ ଆକେନ୍ ଏତେ ଇସ୍‌ପର୍ ମ୍ନାଃ ଡିଙ୍ଗ୍‌ଏ ଆରି ଆତେନ୍‍ ଏତେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଡିଗ୍ ଗୌରବ୍‍ ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_5","073_11_5","JHN","11","5","5","ଜିସୁ ମାର୍ଥା ମେଁନେ ତନାଣ୍ଡେ ମରିୟମ୍ ଆରି ଲାଜାର୍‌କେ ଆଲାଦ୍ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_6","073_11_6","JHN","11","6","6","ମାତର୍‌ ଜିସୁ ଲାଜାର୍‌କେ ଆଃସିଲେଃକ୍ନେ କବର୍ ବାଲା ଡିଗ୍‍ ଜିସୁ ଆଣ୍ଡି ଅରିଆ ଲେଃଗେ ଆତ୍‍ ଅରିଆ ବାରି ବାର୍‌ସି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_7","073_11_7","JHN","11","7","7","ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍‍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଦୁବାପା ନେ ଜିହୁଦା ଦେସ୍‌ନ୍ନିଆ ଆଣ୍ଡେ ନେୱିଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_8","073_11_8","JHN","11","8","8","ସିସ୍‍ଇଂ ବାସଙ୍ଗ୍‌କେ, “ଗୁରୁ ! ଉଡ଼ିସି ଇଡ଼ିଙ୍ଗ୍ ଆତେନ୍‌ ଇନିନେ ରେମୁଆଁଇଂ ଆନାକେ ବ୍ରି ଏତେ ଟୁଚେ ବାଗୁଏଃ ନ୍‌ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ଇନି ବାରି ମୁଇଂତର୍ ଆଣ୍ଡେନ୍‍ସା ଚାଏଁ ନାଡିଙ୍ଗ୍‍ ?” ");
INSERT INTO gaq_vpl VALUES ("JN11_9","073_11_9","JHN","11","9","9","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ସ୍ମିନେ ଗମ୍ବାର୍‌ ଗଣ୍ଟା ଣ୍ଡୁ । ଜାଣ୍ଡେ ମିଡିଗ୍ ବେଲା ଅଲେଙ୍ଗ୍‍ଲା ଆଟେପ୍ଲ ଣ୍ଡୁ ମେଁନ୍‌ସା ଡାଗ୍ଲା ଦର୍ତନି ତାର୍‌କିଗ୍ ଲେଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN11_10","073_11_10","JHN","11","10","10","ମାତର୍‌ ମିଡିଗ୍‍ବ ଅଲେଙ୍ଗ୍‍ଲା ମେଁ ଟେପ୍‌ଲଃଚେ ଲଃଏ । ମେସା ଡାଗ୍‌ଲା ମେଁନେ ଗାଗ୍‌ଡ଼େନ୍ନିଆ ତାର୍କିଗ୍‍ ଆଲେଃଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_11","073_11_11","JHN","11","11","11","ଏନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଆଃଡାଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେନେ ରେମୁଆଁ ଲାଜାର୍‍ ଏକେ ଡୁଲେଗ୍‍ ଲେଃକେ । ନେଙ୍ଗ୍ ୱେଚେ ଆମେକେ ଣ୍ଡ୍ରାତଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_12","073_11_12","JHN","11","12","12","ସିସ୍‍ଇଂ ଜିସୁକେ ବାସଙ୍ଗ୍‌ଡିଂକେ “ମାପ୍ରୁ ! ମେଁ ଜଦି ଡୁଲେଗ୍‍ ଲେଃକେ ତେଲା ଡିଲାଡିଗ୍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ଚେ ତଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_13","073_11_13","JHN","11","13","13","ଲାଜାର୍‍ ଗୁଏଗେ ଡାଗ୍‌ଚେ ଜିସୁ ବାସଙ୍ଗ୍‍ବଗେ ମାତର୍‌ ମେଁ ଲେମୁଆଃ ଲେଃଲା ଡୁଲେଗ୍‍ ଲେଃକେ ଡାଗ୍‌ଚେ ମେଇଂ ଜିସୁନେ ସାମୁଆଁ ବାବେଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_14","073_11_14","JHN","11","14","14","ତେଲା ଜିସୁ ସଅଜ୍‍ରେ ବାସଙ୍ଗ୍‌କେ “ଲାଜାର୍‍ ଗୁଏ ଲେଃକେ ");
INSERT INTO gaq_vpl VALUES ("JN11_15","073_11_15","JHN","11","15","15","ମାତର୍‌ ନେଙ୍ଗ୍ ସାର୍ଦା ନ୍ଲେକେ ଜେ ନେଙ୍ଗ୍ ଆତ୍‍ ଅରିଆ ମେଁ ଏତେ ଅଃତେନ୍‍ ବେଲା ନାଲେଗେ ଣ୍ଡୁ । ଆକେନ୍ ପେପାକା ମଙ୍ଗ୍‍ଲ୍‍ ଡିଙ୍ଗ୍‌ଲେ । ମେସା ଡାଗ୍ଲା ତେନ୍‌ବାନ୍‌ ପେନେ ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଏ । ଦାପା ମେଁନେ ଡାଗ୍ରା କିକେନ୍‌ସା ନେୱେପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_16","073_11_16","JHN","11","16","16","ଆତ୍‍ ଅରିଆ ଥୋମା ଆଜାକେ ଦିଦୁମ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ମ୍ୟାଃକେ, ମେଁ ନିଜେନେ ଏଃତେ ଲେଃକ୍ନେ ସିସ୍‍ଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ଦାପା, ନେ ଡିଗ୍ ୱେଚେ ମେଁ ଏତେ ନେଗୁଏଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_17","073_11_17","JHN","11","17","17","ଜିସୁ ବେତନିଆନ୍ନିଆ ୱେଚେ ଅଁକେ ଅଁସି ଡିଙ୍ଗ୍‌ଗେ ଲାଜାର୍‍କେ ରାଃଚ୍ୟାନ୍ନିଆ ଆତିବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_18","073_11_18","JHN","11","18","18","ବେଥନୀବାନ୍ ଯିରୁଶାଲାମ୍ ସ୍ଲ ଞ୍ଜି କିଲମିଟର୍ ବାନ୍ ଇକୁଡ଼ା ");
INSERT INTO gaq_vpl VALUES ("JN11_19","073_11_19","JHN","11","19","19","ବାରି ଜିହୁଦା ଦେସ୍‌ନେ ଗୁଲୁଏ ରେମୁଆଁ ମାର୍ଥା ବାରି ମରିୟମ୍‍କେ ମେଇଂନେ ବୟାଁଣ୍ଡେନେ ଗୁଏଃକ୍ନେ କବର୍ ଅଁଚେ ବଲ୍ ମନ୍ଦ୍‍ ବାଲିର୍‍ନେସା ପାଙ୍ଗ୍‌ଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_20","073_11_20","JHN","11","20","20","ଜିସୁ ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ଡାଗ୍‌ଚେ ଅଁକ୍ନେ ଦାପ୍ରେ ମାର୍ଥା ଆମେକେ ଅବାନ୍‌ସା ୱେଗେ । ମାତର୍‌ ମରିୟମ୍ ଡୁଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_21","073_11_21","JHN","11","21","21","ମାର୍ଥା ଜିସୁକେ ବାସଙ୍ଗ୍‌ଡିଂକେ “ମାପ୍ରୁ ନା ଆକ୍ ନାଲେଲା; ନେବୟାଁ ଆଗୁଏଃ ପାଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("JN11_22","073_11_22","JHN","11","22","22","ମାତର୍‌ ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ ଏକେ ଡିଗ୍ ନାନେ ଇସ୍‌ପର୍‌କେ ମେଁନେ ନାସେଲ୍ୟାଏ ମେଁ ଆତେନ୍‌ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_23","073_11_23","JHN","11","23","23","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ନାବୟାଁ ପାରାନ୍‍ ବାଚେ ତଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_24","073_11_24","JHN","11","24","24","ମାର୍ଥା ଉତର୍ ବିକେ “ଆତେନ୍‌ ତ ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ ଜୁଗ୍‍ ଡାନେ ଦିନା ବାରି ମୁଇଂତର୍‍ ମେଁ ତଃଡ଼ିଆଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_25","073_11_25","JHN","11","25","25","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଗୁଏଚେ ବାରି ମୁଇଂତର୍ ମ୍ୱ୍ରଏ ଆରି ଜିବନ୍ ଣ୍ଡିଙ୍ଗ୍‍ଏ । ଜା ନେଙ୍ଗ୍ ଡାଗ୍ରା ସତ୍ ମାନେଏ ମେଁ ଗୁଏଲା ଡିଗ୍‍ ମ୍ବ୍ରଏ । ");
INSERT INTO gaq_vpl VALUES ("JN11_26","073_11_26","JHN","11","26","26","ଜା ଆନେଙ୍ଗ୍ ଜିବନ୍ ଲେଃକେ ଡାଗ୍‌ଚେ ସତ୍‍ ମାନେଃଏ ମେଁ ଅଃନା ଡିଗ୍ ଆଗୁଏଣ୍ଡୁ ଏନ୍‌ ସାମୁଆଁନିଆ ମେଃନେ ସତ୍ ମାନେଃ ପେଡିଙ୍ଗ୍ ?” ");
INSERT INTO gaq_vpl VALUES ("JN11_27","073_11_27","JHN","11","27","27","ମାର୍ଥା ଉତର୍ ବିକେ, “ଅ ମାପ୍ରୁ ନେଙ୍ଗ୍ ବିସ୍‌ବାସ୍‌‌ ଡିଂଣ୍ଡିଂ, ନା ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ । ଜା ମସିହ ଦର୍‌ତନିନ୍ନିଆ ପାଙ୍ଗ୍‌ନେ ଲେଃଗେ ନା ମେଃନେ ଆତେନ୍‌ କିସ୍‌ଟ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_28","073_11_28","JHN","11","28","28","ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ମାର୍ଥା ଆଣ୍ଡେ ୱିଗ୍‌ଚେ ନିଜର୍ ତନାଣ୍ଡେ ମରିୟମ୍‍କେ ବାସଙ୍ଗ୍‌ଡିଂକେ “ଗୁରୁ ପାଙ୍ଗ୍‌ଲେ ଆନା ୱାଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_29","073_11_29","JHN","11","29","29","ଆକେନ୍ ଅଁଚେ ମରିୟମ୍ ଜିଆ ତଡ଼ିଆଚେ ଆମେକେ ଅବାନେସା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_30","073_11_30","JHN","11","30","30","ଅଃତେନ୍‍ ବେଲା ଜାକ ଜିସୁ ଇନି ବିତ୍ରେ ଗାଆଲେଃଗେ ଣ୍ଡୁ । ମାର୍ଥା ଆମେକେ ଅବାକ୍ନେ ଜାଗାନ୍ନିଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_31","073_11_31","JHN","11","31","31","ମରିୟମ୍‌କେ ବଲ୍ ମନ୍ଦ୍‍ ବାଲିର୍‌ ନ୍‌ସା ଡୁଆ ପାଙ୍ଗ୍‌ଲେକ୍ନେ ରେମୁଆଁଇଂ ଉଡ଼ିବେଲା କେକେ ଜେ ମେଁ ତଡ଼୍ୟାଚେ ତେରେପେତେ ଡିଙ୍ଗ୍‌ଚେ ବାଏରେ ୱେଡିଙ୍ଗ୍ ମେଇଂ ଡିଗ୍ ମେଁନେ ପ୍ଲା ୱେଗେ । ମେଇଂ ବାବେକେ ମେଁ ରାଃଚ୍ୟାନ୍ନିଆ ଅଃନ୍‌ସା ୱେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_32","073_11_32","JHN","11","32","32","ଜିସୁନେ ଡାଗ୍ରା ପିଙ୍ଗ୍‌ଚାକ୍ନେ ଦାପ୍ରେ ମରିୟମ୍ ପାଙ୍ଗ୍‌ଚେ ମେଁନେ ଞ୍ଚବୁନ୍ଦେ ଲଃଚେ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ନା ନାଲେଲା ନେବୟାଁ ଆଗୁଏଃପାଡିଂ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_33","073_11_33","JHN","11","33","33","ମରିୟମ୍ ଆରି ମେଁ ଏତେ ଲେଃକ୍ନେ ରେମୁଆଁଇଂ ଅଁଆର୍‌ଡିଙ୍ଗ୍‌କ୍ନେ କେଚେ ଆତ୍ମାନ୍ନିଆ ଲିବିସଃଚେ ଜିସୁ ଦୁକ୍ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_34","073_11_34","JHN","11","34","34","ମେଁ ସାଲିଆକୁକେ “ଆଣ୍ଡି ଅରିଆ ଆତି ପେବକେ ?” ମେଇଂ ଉତର୍ ବିକେ । “ଏଃଲା ମାପ୍ରୁ ନାକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_35","073_11_35","JHN","11","35","35","ଜିସୁ ଅଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_36","073_11_36","JHN","11","36","36","ଆତ୍‍ ଅରିଆ ଜିଉଦିଇଂ ବାସଙ୍ଗ୍‌କେ “କେଲାପା ମେଁ ଆମେକେ ଉଡ଼ି ବଲ୍‍ ବାଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_37","073_11_37","JHN","11","37","37","ମାତର୍‌ ଆରି ଉଡ଼ିରୁଆ ବାସଙ୍ଗ୍‌କେ “ଆତ୍‍ ଅରିଆ କାନାକେ ମ୍ମୁଆଃ କିକେନେ ବପୁ ବିବକେ ? ଇକ୍‌ଚା ପାଡିଙ୍ଗ୍‍ଲା ମେଁ ମେଁନେ ଲାଜାର୍‍କେ ଗୁଏକ୍ନେ ବାନ୍ ରକ୍ୟା ପାଡିଙ୍ଗ୍‍ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("JN11_38","073_11_38","JHN","11","38","38","ଆତ୍‌ଅରିଆ ଜିସୁ ବାରି ମୁଇଂତର୍‍ ପାରାନ୍‌ ବିତ୍ରେ ଗିସେ ଡିଙ୍ଗ୍‌ଚେ ରାଃଚ୍ୟା ଡାଗ୍ରା ୱେଗେ; ଆତେନ୍‌ ମୁଇଙ୍ଗ୍ ପାର୍‍ ଆରି ମେଁନେ ସାର୍ମୁଆଁନ୍ନିଆ ମୁଇଙ୍ଗ୍ ବ୍ରି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_39","073_11_39","JHN","11","39","39","ଜିସୁ ଆଦେସ୍‍ ବିକେ “ଆକେନ୍ ବ୍ରିକେ ଗୁଚେ ବିଃପା ।” ଗୁଏଲେଃକ୍ନେ ରେମୁଆଁନେ ତନାଣ୍ଡେ ମାର୍ଥା ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍ରୁ ମେଁ ରୁବୁଗ୍‍ଚେ ବାସ୍ନା ବିଡିଂକେ, ମେଁନ୍‌ସା ଡାଗ୍ଲା ଆମେକେ ଆତିଚେ ଅଁସି ଡିଙ୍ଗେ ଗୁଏଚେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_40","073_11_40","JHN","11","40","40","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଜଦି ପେ ସତ୍ ପେମାନେଏ ତେଲା ଇସ୍‌ପର୍‌ନେ ମ‍ଇମା ପେକେଏ ଏନ୍‌ ମେଁନେ ନେଙ୍ଗ୍ ଆପେକେ ନାବାସଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN11_41","073_11_41","JHN","11","41","41","ଆତ୍‍ ଅରିଆ ମେଇଂ ବ୍ରିକେ ଗୁଚେ ବିଃକେ ଆରି ଜିସୁ କିତଂପାକା ତାମୁଚେ ବାସଙ୍ଗ୍‌କେ “ଆବା ନା ନେଙ୍ଗ୍‌ନେ ପାର୍‌ତନା ନାଅଁକେ ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍ ଆନାକେ ଦନ୍ୟବାଦ୍ ବିଣ୍ଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("JN11_42","073_11_42","JHN","11","42","42","ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେଃକେ ନାଁ କାଲାଆଃ ନେଙ୍ଗ୍‌ନେ ସାମୁଆଁ ଅଁ ନାମ୍ୟାକେ । ମାତର୍‌ ନାଁ ଜେ ଆନେଙ୍ଗ୍‌କେ ବେନାବକ୍ନେ ଆକ୍‌ଅରିଆ ମେଁଇଂନେ ସତ୍ ଡିଙ୍ଗ୍‌ନେସା ନେଙ୍ଗ୍ ଆକେନ୍ ଡିଙ୍ଗ୍ ଣ୍ତିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_43","073_11_43","JHN","11","43","43","ଅଃକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁ ଜାବର୍ କିରଚେ ୱାକେ, “ଲାଜାର୍ ତାର୍‌ଲା” ");
INSERT INTO gaq_vpl VALUES ("JN11_44","073_11_44","JHN","11","44","44","ଦାପେ ଦାପେ ଲାଜାର୍‍ ପାଙ୍କେ ! ମେଁନେ ଞ୍ଚ ନ୍ତି ରାଃଚ୍ୟାନେ ପାଟାଇ ଏତେ ଆଃଗାଗ୍‌ ବଗେ ବାରି ସାର୍‌ମୁଆଁ ଡିଙ୍ଗ୍ ପାଟାଏ ଏତେ ଆଃକୁଇ ବିଃବଗେ । ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଆମେକେ ତ ବିଚେ ୱେନ୍‌ସା ବାସଙ୍ଗ୍‌ପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN11_45","073_11_45","JHN","11","45","45","ମରିୟମ୍‍କେ କେନେସା ପାଙ୍ଗ୍‌ଲେକ୍ନେ ରେମୁଆଁଇଂନେ ବାନ୍ ଉଡ଼ିରୁଆ ଜିସୁନେ ଏନ୍‌ କାମ୍ କେଚେ ଜିସୁନ୍ନିଆ ସତ୍‍ ମାନେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_46","073_11_46","JHN","11","46","46","ମାତର୍‌ ମେଇଂନେବାନ୍‍ ଉଡ଼ିରୁଆ ଫାରୁଶୀଇଂ ଡାଗ୍ରା ୱେଚେ ଜିସୁ ଡିଙ୍ଗ୍ ବକ୍ନେ ଏନ୍‌ କାମ୍ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_47","073_11_47","JHN","11","47","47","ଆକେନ୍ ଅଁଚେ ପାରୁସି ଆରି ମ୍ନା ଜାଜକ୍‍ଇଂ ଗୁଲିସାଙ୍ଗ୍‍ ଡୁଆ ମ୍ନାରେକେ ଅବାଚେ ବାସଙ୍ଗ୍‌କେ “ନେଃ ମେଃ ନେଡିଙ୍ଗ୍‍ପା ?” କେଲାପା ଏନ୍‌ ରେମୁଆଁ ଉଡ଼ି ଉଡ଼ି କାବା ଡିଙ୍ଗ୍ ସୁଗୁଆ କାମ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_48","073_11_48","JHN","11","48","48","ଦେକ୍ ରକମ୍ କାମ୍ ଡିଙ୍ଗ୍‍ନେସା ଆମେକେ ଜଦି ଆନ୍ତାର୍‍ ନେବିଏ ସାପାରେ ମେଁ ଡାଗ୍ରା ସତ୍ ମାନେଃ ଆର୍‌ଏ । ତେଲା ରୋମୀୟଇଂ ପାଙ୍ଗ୍‌ଚେ ନେନେ ମନ୍ଦିର୍‍ ଆରି ନେନେ ଜାତିକେ ଦଂସ ଆଡିଙ୍ଗ୍ ବିଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN11_49","073_11_49","JHN","11","49","49","ମେଇଂନେବାନ୍‍ ଆତେନ୍‌ ମୁଆଁ ନ୍‌ସା ସ୍ରି ବକ୍ନେ ମ୍ନା ଜାଜକ୍‍ କୟାଫା ବାସଙ୍ଗ୍‌କେ “ପେ ଉଃଡ଼ି ମୁର୍କ ! ");
INSERT INTO gaq_vpl VALUES ("JN11_50","073_11_50","JHN","11","50","50","ପେ ମେଁନେ ବୁଜେ ପେୟାକେ ସାପା ଜାତି ନଷ୍ଟ ଡିଙ୍ଗ୍‌ନେ ବାଟା ମୁଇଙ୍ଗ୍ ରେମୁଆଁ ଗୁଏନେ ନିମାଣ୍ଡା । ");
INSERT INTO gaq_vpl VALUES ("JN11_51","073_11_51","JHN","11","51","51","କୟାଫା ନିଜେ ମନ୍‍ବାନ୍‍ ଆକେନ୍ ବାସଙ୍ଗ୍‌ ଆବଗେ ଣ୍ଡୁ । ମାତର୍‌ ମେଁ ଆତେନ୍‌ ମୁଆଁନେ ମ୍ନା ସାମୁଆଁ ପୁଜାରି ଡିଙ୍ଗ୍‌ଲେଲା ଆକେନ୍ ବବିସତ୍‌ ସାମୁଆଁ ମେଁନେ ତୁମୁଆଃ ବାନ୍ ବାସଙ୍ଗ୍‌ ବେଗେ । ଜିସୁ ଆଅଁ ବଗେ ଜେ ସାପା ଜିଉଦି ଜାତିକେ ଆରି ");
INSERT INTO gaq_vpl VALUES ("JN11_52","073_11_52","JHN","11","52","52","ଚିନ୍‌ବିନ୍ ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ଇସ୍‌ପର୍‌ନେ ରେମୁଆଁଇଂକେ ମୁଇଙ୍ଗ୍ ଜାତିନେ ମୁଇଂନ୍ନିଆ ଆଡିଙ୍ଗ୍‍ନେସା ଜିସୁ ଗୁଏଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN11_53","073_11_53","JHN","11","53","53","ଆତେନ୍‌ ଦିନ୍‍ବାନ୍‍ ଜିଉଦି କର୍ତ୍ତୁପକ୍ଷଇଂ ଜିସୁକେ ବାଗୁଏଃନେସା ଜଜ୍‌ନା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_54","073_11_54","JHN","11","54","54","ଆତେନ୍‌‍ସା ଜିସୁ ଜିହୁଦିଇଂନେ ବାନ୍ ଆରି ୱେ ୱିଗ୍ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ବାରି ବାଲିଲ ଜାଗା ଡାଗ୍ରା ଲେଃକ୍ନେ ଇନିନେ ଇଫ୍ରୟିମ ମ୍ନିକ୍ନେ ମୁଇଙ୍ଗ୍ ଇନିନ୍ନିଆ ୱେଚେ ଆତ୍‌ଅରିଆ ସିସ୍‍ଇଂ ଏତେ ବାସାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_55","073_11_55","JHN","11","55","55","ଅଃତେନ୍‍ ବେଲା ଜିଉଦିଇଂନେ ଉଦାର୍ ବାନେ ପାଣ୍ଡୁଏ ତେପିଙ୍ଗ୍‍ଚାକେ ଆରି ଆତେନ୍‌ ମାପାଣ୍ଡୁଏଃନେ ସେନୁଗ୍‍ ନିଜେ ନିଜେନେ ପର୍‌ଚଲ୍‌ ଆଡିଙ୍ଗ୍‍ନେସା ରାଇଜ୍ ଇନିନେ ଉଡ଼ିରୁଆ ରେମୁଆଁ ଯିରୁଶାଲାମ୍‌ନିଆ ମୁଇଂନ୍ନିଆ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN11_56","073_11_56","JHN","11","56","56","ମେଇଂ ଜିସୁକେ ତୁର୍‌ନେ ବେଲା ମନ୍ଦିର୍‌ନ୍ନିଆ ତୁଆଁ ଲେଃବେଲା ନିଜେ ନିଜେ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଆର୍‌କେ ମେଁ ଏନ୍‌ ପାଣ୍ଡୁଏନ୍ନିଆ ଆପାଙ୍ଗ୍‍ଲେ ? ମେଁନେ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‍ ?” ");
INSERT INTO gaq_vpl VALUES ("JN11_57","073_11_57","JHN","11","57","57","ମ୍ନା ଜାଜକ ଆରି ଫାରୁଶୀଇଂ ଆମେକେ ସାଃନ୍‌ସା ମେଁ ଆଣ୍ଡି ଅରିଆ ଲେଃଡିଂକେ ଏନ୍‌ ଜଦି ଜା ମ୍ୟାଏ ଆକେନ୍ ବାସଙ୍ଗ୍‌ ନ୍‌ସା ଆଦେସ୍‌ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_1","073_12_1","JHN","12","1","1","ଜିସୁ ଉଦାର୍ ପାଣ୍ଡୁଏନେ ତୁର୍‍ଦିନା ସେନୁଗ୍ଆ ବେଥନୀ ପାଙ୍ଗ୍‌କେ; ମୁଡ଼ି ଲାଜାର୍‍କେ ଜିସୁ ଗୁଏଲେକ୍ନେବାନ୍‍ ଆଃତଡ଼୍ୟା ବଗେ ମେଁ ଆତ୍‌ଅରିଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_2","073_12_2","JHN","12","2","2","ତେସା ମେଇଙ୍ଗ୍ ଜିସୁ ଆତ୍‍ଲା ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ମୁଇଙ୍ଗ୍ ମିଡିଗ୍‍ ବଜି ଆର୍ମେ ଆର୍‌କେ; ମାର୍ଥା ବାଟାନେ ଦାଇତ୍‍ରେ ଲେଃଗେ ଆରି ଜାଣ୍ଡେଇଂ ମେଇଂ ଏତେ ଚଙ୍ଗ୍‍ନ୍‍ସା କଆର୍‌କେ ଲାଜାର୍‍ ମେଇଂବାନ୍‍ ମୁଇଂଜା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_3","073_12_3","JHN","12","3","3","ଆତେନ୍‌‌ ବେଲା ମରିୟମ୍ ତେପ୍ୟା ଲିଟର୍‍ ଜବର୍ ଦାମ୍‍ନେ ବାସ୍‌ନାକ୍ନେ ଜଟାଚି ଞ୍ଚୁ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ଜିସୁନେ ଞ୍ଚନ୍ନିଆ ଆତେନ୍‌ ଲାଗେଚେ ନିଜେନେ ଉଗ୍‌ବ ଏତେ ମେଁନେ ଞ୍ଚ ଚୁ ବିକେ ଆରି ଞ୍ଚୁନେ ବାସ୍‍ନାରେ ଡୁଆ ଗମ୍‍କେ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_4","073_12_4","JHN","12","4","4","ଜିସୁନେ ସିସ୍‍ଇଂବାନ୍‍ ଇଷ୍କରିୟଥ୍ ଜିହୁଦା ମ୍ନିକ୍ନେ ମୁଡ଼ି ସିସ୍‍ ଆମେକେ ବିରଦ୍ ରେମୁଆଁଇଂନେ ନ୍ତିନ୍ନିଆ ଆଃସାଃ ବିଃନ୍‍ସା ୱେଡିଙ୍ଗ୍‍ଗେ ମେଁ ବାସଙ୍ଗ୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("JN12_5","073_12_5","JHN","12","5","5","“ଆକେନ୍ ଞ୍ଚୁ ଞ୍ଜିସ ରୁପା ଡାବୁରେ ସଚେ ମେଁନ୍‌ସା ଦରିଦ୍ର ରେମୁଆଁଇଂକେ ଆବିକେ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("JN12_6","073_12_6","JHN","12","6","6","ମେଁ ଦରିଦ୍ର ରେମୁଆଁଇଂ ଆଡ଼ାତ୍ରା ଜିହୁଦା ଚିନ୍ତା ଡିଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଗେ ଡାଗ୍‌ଚେ ଦେକ୍ ବାସଙ୍ଗ୍‌କେ ଆତେନ୍‌ ଣ୍ଡୁ । ମେଁ ଲେଃଗେ ମୁଇଙ୍ଗ୍ ଡଙ୍ଗାରେ । ମେଁ ଦାଇତ୍‍ରେ ଲେଃକ୍ନେ ଡାବୁ ପିଡ଼ିନ୍ନିଆ ଉଡ଼ି ବଆର୍‌ଗେ ଆତ୍‌ବାନ୍ ମେଁ ଡଙ୍ଗାଚେ ଡୁଂଡ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_7","073_12_7","JHN","12","7","7","ମାତର୍‌ ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ଆମେକେ ଆନ୍‌ତାର୍‌ ବିଃପା ଡିରକମ୍ ନେଙ୍ଗ୍‌ନେ ଗୁଏନେ ଦିନାକେଲା ମେଁ ଆକେନ୍ ବୁବନେ ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN12_8","073_12_8","JHN","12","8","8","ଦରିଦ୍ର ରେମୁଆଁଇଂ ତ କାଲାଆଃ ପେନ୍ନିଆ ଲେଃକେ ମାତର୍‌ ନେଙ୍ଗ୍ କାଲାଆଃ ପେଇଂ ଡାଗ୍ରା ନ୍ନାଲେଃ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_9","073_12_9","JHN","12","9","9","ଜିସୁ ବେତନିଆନ୍ନିଆ ଲେଃକ୍ନେ ଅଁଚେ ଗୁଲେ ରେମୁଆଁ ଆତ୍‌ଅରିଆ ୱେଆର୍‌କେ ମାତର୍‌ ଆମେକେ କେନ୍‍ସା ଣ୍ଡୁ; ଜିସୁ ଗୁଏକ୍ନେ ବାନ୍ ଆଃତଡ଼୍ୟା ବକ୍ନେ ଲାଜାର୍‍କେ କେନ୍‍ସା ପାଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_10","073_12_10","JHN","12","10","10","ତେସା ମ୍ନା ପୁଜାରି‍ଇଂ ଲାଜାର୍‍କେ ବାଗୁଏ ବିଃନ୍‍ସା ଉପାୟ୍‍ ତୁର୍‌ଡିଙ୍ଗ୍ ଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("JN12_11","073_12_11","JHN","12","11","11","ଡାଗ୍ଲା ମେଁ ନ୍‍ସା ଜିଉଦିଇଂବାନ୍ ଗୁଲୁଏ ୱେଚେ ଜିସୁନ୍ନିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_12","073_12_12","JHN","12","12","12","ଆରି ମୁଇଙ୍ଗ୍‌ଦିନା ଉଦାର୍ ପାଣ୍ଡୁଏଃନ୍ନିଆ ପାଙ୍ଗ୍‌ଲେକ୍ନେ ଗୁଲେ ରେମୁଆଁ ଜିସୁ ଜିରୁସାଲାମ୍‍ନ୍ନିଆ ପାଙ୍ଗ୍‌ନେ ଅଁଚେ ");
INSERT INTO gaq_vpl VALUES ("JN12_13","073_12_13","JHN","12","13","13","କଜ୍‍ରି କେନ୍ଦା ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ଆମେକେ ଅବାନ୍‌ସା ତାର୍‌ୱେକେ ଆରି କିରଚେ ବାସଙ୍ଗ୍‌ନେ ମୁଲେକେ “ହୋଶାନ୍ନା । ମାପ୍ରୁନେ ମ୍ନିରେ ଜା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ମେଁ ଦନ୍ୟ; ଦନ୍ୟ ଇଶ୍ରାୟେଲନେ ଇଃସାଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_14","073_12_14","JHN","12","14","14","ଆରି ଜିସୁ ମୁଇଙ୍ଗ୍ ଗଦ ଗୁଗ୍‍ଡ୍ୟାନ୍ନିଆ କଚେ ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ଏନ୍‌‍ସା ସାସ୍ତର୍‌ ଗୁଆର୍‍କ୍ନେ ମୁଇଙ୍ଗ୍ ବାସଙ୍ଗ୍‌କ୍ନେ ସାମୁଆଁ ସମାନ୍ ଡିଙ୍ଗ୍‌କେ: ");
INSERT INTO gaq_vpl VALUES ("JN12_15","073_12_15","JHN","12","15","15","“ସିୟୋନ ସେଲାଇଂ ! ଆପ୍‍ଟଗ୍‍ପା ନାମଃ; କେଲା ନାନେ ଇଃସାଙ୍ଗ୍‌ ଗଦ ଉଙ୍ଗ୍‌ଡେନେ ଗୁଗ୍‍ଡ୍ୟା ଆଡ଼ାତ୍ରା କଚେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_16","073_12_16","JHN","12","16","16","ଆତେନ୍‌‌ ବେଲା ସିସ୍ଇଂ ଏନ୍‌ ବିସୟ୍‌ରେ ବୁଜେ ଆଲେଃ ଆର୍‌ଗେ । ଡାଗ୍ଲା ଜିସୁନେ ଆଲାଦ୍‌ ଗୁଏକ୍ନେବାନ୍ ତଃଡ଼୍ୟାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ମନେ ପଡ଼େକେ ଜେ ମେଁନେ ସାମୁଆଁରେ ଏନ୍‌ ସାପା ବ୍ନାଲିର୍ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ ବଗେ ଆରି ଆତେନ୍‌ ଇସାବ୍‌ରେ ମେଇଂ କାମ୍ ଡିଙ୍ଗ୍ ବଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_17","073_12_17","JHN","12","17","17","ଜିସୁ ଗୁଏ ଲେଃକ୍ନେ ଲାଜାର୍‍କେ ରାଃଚ୍ୟାବାନ୍‍ ୱାଚେ ଆରି ମୁଇଙ୍ଗ୍‌ତର୍ ଜିବନ୍ ଆଡିଙ୍ଗ୍‌ନେ ବେଲା ଜାଣ୍ଡେ ମେଁ ଏତେ ଲେଃଗେ ମେଇଂ ଆକେନ୍ ସାପା ସାମୁଆଁ ପିତୁର୍‍ପାକା ବାସଙ୍ଗ୍‌ ବଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_18","073_12_18","JHN","12","18","18","ଆତେନ୍‌‌ସା ଜିସୁନେ ଏନ୍‌ ଇରିଆତୁଗ୍ ସୁଗୁଆ ସ୍ଲେନେ କବର୍ ଅଁଚେ ରେମୁଆଁଇଂ ଜିସୁକେ ଅବାନ୍‌ସା ୱେଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_19","073_12_19","JHN","12","19","19","ଆକେନ୍ କେଚେ ପାରୁସିଇଙ୍ଗ୍ ମେଇଂମେଇଂ ବିତ୍ରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ ଆର୍‌କେ “କିକେ ପେଡିଂକେ ତ ନେନେ ମେଃଡିଗ୍ ଡିଙ୍ଗ୍‍ ନେୟା ଣ୍ଡୁ । ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସାପା ରେମୁଆଁଇଂ ମେଁ ପ୍ଲା ୱେଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_20","073_12_20","JHN","12","20","20","ପାଣ୍ଡୁଏ କେଲା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନ୍‌ସା ଜିରୁସାଲାମ୍‍ନ୍ନିଆ ପାଙ୍ଗ୍‌ଲେଗ୍ନେ ୱେଣ୍ଡ୍ରେଇଂବାନ୍ ଉଡ଼ିରୁଆ ଗ୍ରୀକ୍ ରେମୁଆଁ ଲେଃଗେ ");
INSERT INTO gaq_vpl VALUES ("JN12_21","073_12_21","JHN","12","21","21","ମେଇଂ ଗାଲିଲୀନେ ବେଥ୍‍ସାଇଦା ବାସାଲେକ୍ନେ ପିଲିପ୍‍ଡାଗ୍ରା ୱେଚେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍‌ରୁ, ନେ ଜିସୁକେ କେନ୍‍ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‍ନେଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_22","073_12_22","JHN","12","22","22","ପିଲିପ୍‍ ୱେଚେ ଆନ୍ଦ୍ରିୟକେ ଏନ୍‌ କବର୍ ବିକେ ଆରି ମ୍ୱାୟା ୱେଚେ ଜିସୁକେ ଆମ୍ୟାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_23","073_12_23","JHN","12","23","23","ଜିସୁ ଉତର୍ ବିକେ, “ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ମ୍ନାଃ ଡିଙ୍ଗ୍‌ନେ ବେଲା ପାଙ୍ଗ୍‌ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_24","073_12_24","JHN","12","24","24","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଗହମ୍‍ ମୁଞ୍ଜି ମୁଇଂ ତୁବଃନ୍ନିଆ ଲଃଚେ ଆଗୁଏ ତେଲା ଆତେନ୍‌ ମୁଇଙ୍ଗ୍ ଗେଡ଼ା ଡିଙ୍ଗ୍‌ଚେ ଲେଃଏ ମାତର୍‌ ମେଁ ଗୁଏଲା ଆତ୍‌ବା ଗୁଲୁଏ ମୁଞ୍ଜି ପଃଏ । ");
INSERT INTO gaq_vpl VALUES ("JN12_25","073_12_25","JHN","12","25","25","ଜାଣ୍ଡେ ନିଜେନେ ଜିବନ୍‍କେ ଜାବର୍‌ ବଲ୍ ବାଲେଃଏ, ମେଁ ଆତେନ୍‌ ଆରେଏ; ଜାଣ୍ଡେ ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌‍କେ ନିଜେନେ ଜିବନ୍‍କେ କୁଟ୍ ଡିଙ୍ଗ୍‌ଏ, ମେଁ ଆମେକେ ମାଡାନେ ଜୁଗ୍ ଜାକ ରକ୍ୟା ଆଃଡିଙ୍ଗ୍ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN12_26","073_12_26","JHN","12","26","26","ଜାଣ୍ଡେ ନେଙ୍ଗ୍‌ନେ ସେବକ୍ ଡିଙ୍ଗ୍‌ନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଏ, ମେଁ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଲେ, ତେଲା ନେଙ୍ଗ୍ ଆଣ୍ଡିଅରିଆ ନ୍ଲେଏ, ନେଙ୍ଗ୍‌ନେ ସେବକ୍ ଡିଗ୍ ଆତ୍‌ଅରିଆ ଲେଃଏ ଆରି ମେଁ ନେଙ୍ଗ୍‌ନେ ଆବାଡାଗ୍ରା ସନ୍‍ମାନ୍‍ ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_27","073_12_27","JHN","12","27","27","“ଏବେ ନେଙ୍ଗ୍‌ନେ ଜିବନ୍ ବୁଟ ଲେଃକେ ନେଙ୍ଗ୍ ମେଁ ଣ୍ଡିଙ୍ଗ୍‍ଏ ? ଆବା ଆନେଙ୍ଗ୍ ଏନ୍‌ ଦୁକ୍ ବେଲାବାନ୍‍ ରକ୍ୟା ଡିଙ୍ଗ୍ ଡାଗ୍‌ଚେ ମେଁନେ ନେଙ୍ଗ୍ ପାର୍‍ତନା ଣ୍ଡିଙ୍ଗ୍‍ଏ ? ଆତେନ୍‌‌ସା ତ ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‍ଲେକେ । ଦୁକ୍ ବଗେନେ ବେଲା ସାମ୍ବାଲେ ନ୍‍ସା ନେଙ୍ଗ୍ ଜାର୍‌ନ୍ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_28","073_12_28","JHN","12","28","28","ଆବା ନାନେ ମ୍ନି ମ୍ନାଃ ଡିଙ୍ଗ୍‌ଲେ ।” ଆକେନ୍ ବେଲା କିତଂଇନିବାନ୍ ମୁଇଙ୍ଗ୍ ସାମୁଆଁ ପାଙ୍ଗ୍‌କେ । “ନେ ଆମେକେ ମ୍ନାଃ ଆଃଡିଙ୍ଗ୍ ନେବକେ ଆରି ବାରି ମୁଇଂତର୍‍ ମ୍ନାଃ ନେରାଃଡିଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_29","073_12_29","JHN","12","29","29","ଆତ୍‍ଅରିଆ ତୁଆଁଲେଃକ୍ନେ ରେମୁଆଁଇଂ ଆକେନ୍‍ ଅଁଚେ ତ୍ରିଗ୍‌ଡ଼ିଆଃ ଗର୍‍ଜେକେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ; ବିନ୍‍ରେ ବାଲିର୍‍ଆର୍‌କେ “ମୁଇଙ୍ଗ୍ କିତଂ ଦୁତ୍‍ ଆକ୍‌ମେଁ ଏତେ ବାଲିର୍‍ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_30","073_12_30","JHN","12","30","30","ମାତର୍‌ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଆତ୍‍ଲା ଏନ୍‌ ସାମୁଆଁ ଆଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ମାତର୍‌ ପେଇଂ ଆତ୍‍ଲା ଡିଙ୍ଗ୍‌ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_31","073_12_31","JHN","12","31","31","ମଞ୍ଚ୍‌ପୁର୍‌କେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ନେ ଦିନା ଏବେ ପାଙ୍ଗ୍‌ଲେକେ । ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ ସାସନ୍ ଡିଂଣ୍ଡ୍ରେକେ କୁର୍‍ଚିବାନ୍‍ ଆଜାର୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN12_32","073_12_32","JHN","12","32","32","ଆରି ନେଙ୍ଗ୍ ଜଦି ମଞ୍ଚ୍‌ପୁର୍‌ବାନ୍‍ ଆଡ଼ାତ୍ରା ଣ୍ଡେଏ ଆତେନ୍‌ ବେଲା ସାପାରେକେ ନେଙ୍ଗ୍‍ଡାଗ୍ରା ଙ୍ଗୁଏ । ");
INSERT INTO gaq_vpl VALUES ("JN12_33","073_12_33","JHN","12","33","33","ମେଁ ଡିରକମ୍ ଡିଙ୍ଗ୍‌ଚେ ଗୁଏନେ ୱେଡିଙ୍କେ ଆକେନ୍‍ ସାମୁଆଁବାନ୍ ମେଁ ଆମ୍ୟା ବିବଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_34","073_12_34","JHN","12","34","34","ଆତ୍‌ବାନ୍ ରେମୁଆଁଇଂ ଆମେକେ ଉତର୍ ବିକେ “ମସୀହ କାଲାଆଃ ନ୍‍ସା ଲେଃଏ ଡାଗ୍‌ଚେ ନେ ନିୟମ୍‌ବାନ୍‍ ଅଁ ନେଲେଃକେ, ତେଲା ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ସତେଆଃ ଆଡ଼ାତ୍ରା ୱେଏ ଡାଗ୍‌ଚେ ନା ଡିରକମ୍ ବାସଙ୍ଗ୍‌ନାଡିଂକେ ? ଏନ୍ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ଜାଣ୍ଡେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN12_35","073_12_35","JHN","12","35","35","ଜିସୁ ଉତର୍ ବିକେ, “ଆଣ୍ଡିନେ ତାର୍‌କିଗ୍ ଏଃକେ ପେ ଡାଗ୍ରା ଲେଃକେ ଆତେନ୍‌ ଆରି ଇତୁଡ଼ା ବେଲା ନ୍‍ସା ଲେଃଏ । ତାର୍‌କିଗ୍ ଲେଃଜାକ ଅଲେଙ୍ଗ୍‍ ଲାଲାପା; ତେଲା ଆପେକେ ତାଙ୍ଗ୍‌କିଗ୍ ଆରାଡିଙ୍ଗ୍‍ ଣ୍ଡୁ । ତାଙ୍ଗ୍‌କିଗ୍‌ନ୍ନିଆ ୱେଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁ ଆଣ୍ଡିପାକା ୱେଡିଙ୍କେ ମ୍ୟା ଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN12_36","073_12_36","JHN","12","36","36","ପେ ଡାଗ୍ରା ତାର୍‌କିଗ୍ ଲେଃଜାକ ମେଁ ଆଡ଼ାତ୍ରା ଆସା ବପା, ତେଲା ପେଇଂ ପେଡିଙ୍ଗ୍‍ଏ ତାର୍‍କିଗ୍‍ନେ ଉଙ୍ଗ୍‌ଡେଇଂ ।” ଆକେନ୍ ବାଲିର୍‍ଚେ ଜିସୁ ମେଇଂବାନ୍‍ ୱେଚେ ଆମ୍ୟାକେ ସୁଗୁଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_37","073_12_37","JHN","12","37","37","ତେଲାଡିଗ୍‍ ମେଁ ମେଁଇଙ୍ଗ୍‌ନେ ସାମ୍‌ନେ ଆଃ ଗୁଲୁଏ କାବା ସୁଗୁଆ କାମ୍ ଡିଙ୍ଗ୍‍ବଗେ ତେଲାଡିଗ୍‍ ମେଇଂ ମେଁ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ ଆଡିଙ୍ଗ୍ ଆର୍‌ଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN12_38","073_12_38","JHN","12","38","38","ଆକ୍‌ବାନ୍ ବାବବାଦି ଯିଶାଇୟନେ ବବିସତ୍ ସାମୁଆଁ ପୁରନ୍‌ ଡିଙ୍ଗ୍‌କେ: ଏ ମାପ୍ରୁ ଜାଣ୍ଡେ ନେନେ ବ୍ନାଲିର୍ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‍ବକେ ? ଆରି ମାପ୍ରୁନେ ବପୁ ଜାଣ୍ଡେନ୍ନିଆ ପାଙ୍ଗ୍‌ଲେକେ ? ");
INSERT INTO gaq_vpl VALUES ("JN12_39","073_12_39","JHN","12","39","39","ମେଁଇଙ୍ଗ୍‌ନେ ଅବିସ୍‌ବାସି ସାମୁଆଁରେ ଯିଶାଇୟ ମେଃନେ ଗୁଆର୍‍ ବଗେ, ଆତେନ୍‌‌ଆ ଗଟେକେ: ");
INSERT INTO gaq_vpl VALUES ("JN12_40","073_12_40","JHN","12","40","40","“ସତ୍‌ରେ ଡିରକମ୍ ଇସ୍‌ପର୍‌ ଆମେଇଂକେ କାନା ଆଡିଙ୍ଗ୍‌ ବିବକେ ବାରି ମେଇଂନେ ବୁଜେନେ ବପୁକେ ନସ୍ଟ ଆଡିଙ୍ଗ୍ ବିବକେ । ଆତେନ୍‌‌ସା ମେଇଂ ମେଃଡିଗ୍ କିକେ ଆୟାଆର୍‍ ଣ୍ଡୁ ବା ମେଃଡିଗ୍ ବୁଜେ ଆୟାଆର୍‍ ଣ୍ଡୁ । ଇସ୍‌ପର୍ ବାଲିର୍‍ ଡିଙ୍ଗ୍‌କେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‌ନ୍‌ସା ମେଇଂ ନେଙ୍ଗ୍ ଡାଗ୍ରା ଆଣ୍ଡେ ଆପାଙ୍ଗ୍‍ ଆର୍‌କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN12_41","073_12_41","JHN","12","41","41","ଯିଶାଇୟ ମେଁନେ ନିଜେ ମ୍ମୁଆଃବାନ୍‍ ଜିସୁନେ ମ‍ଇମା ସାମୁଆଁ ସେନୁଗ୍‍ଆ ମ୍ୟାଚେ ଦେକ୍ ସୁଗୁଆ ଗୁଆର୍‍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_42","073_12_42","JHN","12","42","42","ଏଲେଡିଗ୍ ଇହୁଦୀ ନେତାଇଂବାନ୍‍ ଗୁଲେରୁଆ ଜିସୁନ୍ନିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ଆର୍‌କେ ମାତର୍‌ ପାରୁସିଇଂସା ସମାଜ୍‍କେ ଆନ୍ତାର୍ ଡିଙ୍ଗ୍‌ଏ ଡାଗ୍‌ଚେ ବୁଟଚେ ରେମୁଆଁଇଂନ୍ନିଆ ଆତେନ୍‌ ସାମୁଆଁରେ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍ ଆଡିଙ୍ଗ୍‌ଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN12_43","073_12_43","JHN","12","43","43","ମେଇଂ ଇସ୍‌ପର୍‌ବାନ୍ ଗଉରବ୍‍ ବାନେ ବାଦୁଲ୍ ରେମୁଆଁବାନ୍ ଗଉରବ୍‍ ବଲ୍ ବାଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_44","073_12_44","JHN","12","44","44","ଜିସୁ ମାଲେ ୱାସାର୍‌ଚେ ବାଲିର୍‍କେ “ଜା ନେଙ୍ଗ୍‍ନ୍ନିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ମାତର୍‌ ଆନେଙ୍ଗ୍‌କେ ଣ୍ଡୁ; ଆନେଙ୍ଗ୍‌କେ ବେବକ୍ନେ ଆବାକେ ଡିଗ୍ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN12_45","073_12_45","JHN","12","45","45","ଜା ଆନେଙ୍ଗ୍ କିକେ ଲେଃକେ ମେଁ ଆନେଙ୍ଗ୍ ବେବକ୍ନେ ଆବାକେ ଡିଗ୍ କିକେ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_46","073_12_46","JHN","12","46","46","ନେଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ତାର୍‌କିଗ୍ ଡିଙ୍ଗ୍‌ଚେ ପାଙ୍ଗ୍‍ନ୍ଲେଃକେ । ଜା ନେଙ୍ଗ୍‍ନ୍ନିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଆରି ତାଂକିଗ୍‌ନ୍ନିଆ ଆଲେଃ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN12_47","073_12_47","JHN","12","47","47","ଜା ନେଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ଅଁଚେ ପାଲନ୍ ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ନେଙ୍ଗ୍ ମେଁନେ ବିଚାର୍ ନେଡିଙ୍ଗ୍ ଣ୍ଡୁ । ନେଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌କେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ନେପାଙ୍ଗ୍‌କେ ଣ୍ଡୁ ପାଙ୍ଗ୍‍ଲେକେ ଆମେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‌ନ୍‌ସା । ");
INSERT INTO gaq_vpl VALUES ("JN12_48","073_12_48","JHN","12","48","48","ଜା ଆନେଙ୍ଗ୍‌କେ ଆମାନେଚେ ନେଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ଆସା ଣ୍ଡୁ ନେଙ୍ଗ୍‌ନେ ତୁମୁଆଃନେ ବ୍ନାଲିର୍ ମେଁନେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଡିଙ୍ଗ୍‌ଏ । ଆତେନ୍‌ ବ୍ନାଲିର୍ ଜୁଗ୍‍ ଡାନେ କେଲା ମେଁନେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN12_49","073_12_49","JHN","12","49","49","ଏନ୍ ସାମୁଆଁ ସତ୍ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ନିଜେ ମନ୍‍ ବିତ୍‍ରେ ବାନ୍‍ ମେଃଡିଗ୍‌ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ମେଃନେ ନେଙ୍ଗ୍‌ ବାସଙ୍ଗ୍‌ ଣ୍ଡିଙ୍ଗ୍‍ ଆତାନ୍ ବାସଙ୍ଗ୍‌ନେ ଆରି ଆମ୍ୟା ନ୍‍ସା ନେଙ୍ଗ୍‌ ଆମ୍ବ୍ରଣ୍ଡ୍ରେ ଆବା ଇସ୍‌ପର୍ ଆନେଙ୍ଗ୍‌କେ ଆଦେସ୍‍ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN12_50","073_12_50","JHN","12","50","50","ଆରି ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ ମେଁନେ ଆଦେସ୍‍ ମାଡାନେ ଜିବନ୍ ଜାକ ବିଏ । ନେଙ୍ଗ୍‌ନେ ଆବା ଆନେଙ୍ଗ୍‌କେ ଜା ସାପା ବାଲିର୍‍ ନ୍‍ସା ଆଦେସ୍‍ ବିଃ ବକେ ଅଃତେନ୍‍ ଆଃ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_1","073_13_1","JHN","13","1","1","ଆତେନ୍‌‌ ବେଲା ଜିଉଦିଇଂନେ ଉଦାର୍ ପାଣ୍ଡୁଏନେ ବେଲା ଡିଙ୍ଗ୍‍ୱେଲେଃଗେ ଜିସୁ ମ୍ୟାଲେଃଗେ ଜେ ମେଁନେ ମଞ୍ଚ୍‌ପୁର୍‌ବାନ୍‍ ଆନ୍ତାର୍‍ଚେ ୱେନେ ବେଲା ପିଙ୍ଗ୍‍ଚା ଡିଙ୍ଗ୍‌କେ । ଏବେ ମେଁ ମେଁନେ ମ୍ନାଃ ଆବା ଡାଗ୍ରା ଆଣ୍ଡେ ୱେଏ । ମେଁ ସାପାବେଲା ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ଲେଃଡିଙ୍ଗ୍‌କ୍ନେ ମେଁନେ ନିଜର୍ ରେମୁଆଁଇଂକେ ବଲ୍ ବାଡିଙ୍ଗ୍‌ଗେ । ମେଁ ମେଁଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ଗୁଲେ ଆଲାଦ୍ ଆଃସୁଏ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_2","073_13_2","JHN","13","2","2","ଆତେନ୍‌ ଦିନା ଜିସୁ ଆରି ମେଁନେ ସିସ୍‍ଇଂ ମିଡିଗ୍‌ବ ଚଙ୍ଗ୍ ଉଗ୍ ନ୍ନିଆ କ ଲେଃଗେ । ଜିସୁ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍ ଗାତକ୍‍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ଶିମୋନ ଉଙ୍ଗ୍‌ଡେ ଇଷ୍କରିୟଥ୍ ଜିଉଦାକେ ସ‍ଏତାନ୍ ବାସଙ୍ଗ୍‌ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_3","073_13_3","JHN","13","3","3","ଜିସୁ ମ୍ୟାଲେଃଗେ ଆବା ଇସ୍‌ପର୍ ମେଁନେ ନ୍ତିନ୍ନିଆ ସାପା ଅଦିକାର୍ ବିଃ ବକେ ଆରି ମେଁ ଇସ୍‌ପର୍ ବାନ୍ ପାଙ୍ଗ୍‍ଲେକେ ବାରି ମେଁ ଇସ୍‌ପର୍ ଡାଗ୍ରା ଆଣ୍ଡେ ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("JN13_4","073_13_4","JHN","13","4","4","ତେସା ଜିସୁ କଲେଃକ୍ନେ ବାନ୍ ତଡ଼ିଆଚେ ମେଁ ନିଜେନେ ସକା ତ ବିଚେ ମୁଇଙ୍ଗ୍ ତୁଆଲ୍ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ନ୍‌ସାନ୍ନିଆ ଗାଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_5","073_13_5","JHN","13","5","5","ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ମୁତାନ୍ନିଆ ଣ୍ଡିଆ କିଗ୍‌କେ ଆରି ସିସ୍ଇଂନେ ଞ୍ଚ ଗଡ଼ିଆ ବିକେ । ଆରି ମେଁ ନ୍‌ସାଃନ୍ନିଆ ଗାଗ୍‍ବକ୍ନେ ତୁଆଲ୍ ଏତେ ମେଇଙ୍ଗ୍‌ନେ ଞ୍ଚ ଚୁ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_6","073_13_6","JHN","13","6","6","ଉଡ଼ିବେଲା ଜିସୁ ଶିମୋନ୍ ପିତର୍‍ନ୍ନିଆ ପାଙ୍ଗ୍‌କେ; ପିତର୍ ସାଲ୍ୟାକୁକେ “ମାପ୍ରୁ ନା ମେଃନେ ନେଙ୍ଗ୍‌ନେ ଞ୍ଚ ଗଃଡ଼ିଆ ନାବିଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN13_7","073_13_7","JHN","13","7","7","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ମେଁନେ ଡିଙ୍ଗ୍ ଣ୍ଡିଙ୍ଗ୍‍କେ ଏବେ ପେ ବୁଜେ ପେୟା ଣ୍ଡୁ ଇଡ଼ିଙ୍ଗ୍ ପେବୁଜେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_8","073_13_8","JHN","13","8","8","ପିତର୍ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନାଁ ଅଃନାଡିଗ୍ ନେଙ୍ଗ୍‌ନେ ଞ୍ଚ ଗଡ଼ିଆ ନେବି ଣ୍ଡୁ ।” ମାତର୍‌ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଜଦି ନେଙ୍ଗ୍ ପେନେ ଞ୍ଚ ଗଡ଼୍ୟାଃ ନ୍ନାବିଃ, ତେଲା ପେ ଆରି ନେଙ୍ଗ୍‌ନେ ସିସ୍‍ ଡିଙ୍ଗ୍‌ଚେ ଲେଃ ପେୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_9","073_13_9","JHN","13","9","9","ସିମୋନ୍‌ ପିତର୍ ଉତର୍ ବିକେ “ମାପ୍ରୁ ତେଲା ନେଙ୍ଗ୍‌ନେ ଞ୍ଚ ମେଁନ୍‌ସା ନେଙ୍ଗ୍‌ନେ ନ୍ତି ଆରି ବାଆ ଡିଗ୍ ଗଡ଼୍ୟାଃ ବିଃ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_10","073_13_10","JHN","13","10","10","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଜାଣ୍ଡେଇଂ ଣ୍ଡିଆ କୁମା ଲେଃଆର୍‌କେ ମେଁଇଙ୍ଗ୍‌ନେ ଞ୍ଚ ଆନ୍‌ତାର୍‌ଚେ ବିନେ ସାପା ଗଡ଼୍ୟାଃନେ ଦର୍‌କାର୍ ଣ୍ଡୁ । ମେଁଇଙ୍ଗ୍‌ନେ ସାପା ଗାଗ୍‌ଡ଼େ ପର୍‍ଚଲ୍‍ । ମୁଇଂଜା ନ୍‍ସା ପେ ସାପାରେ ପବିତ୍ର ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_11","073_13_11","JHN","13","11","11","ଜିସୁ ମ୍ୟା ଲେଃଗେ ଜାଣ୍ଡେ ମେଁ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍‌ଗାତ୍ ଡିଙ୍ଗ୍‌ଏ । ତେସା ମେଁ ବାସଙ୍ଗ୍‌ ବଗେ “ମୁଇଂଜାକେ ଆନ୍‌ତାର୍‌ଚେ ପେ ସାପାରେ ପବିତ୍ର ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_12","073_13_12","JHN","13","12","12","ସିସ୍ଇଂନେ ଞ୍ଚ ଗଡ଼ିଆ ଆଡାଚେ ଜିସୁ ମେଁନେ ସକା ସଚେ ନିଜେନେ ସିଟ୍‍ନ୍ନିଆ ଆଣ୍ଡେୱେକେ । ମେଁ ସାଲ୍ୟାକୁକେ “ନେଙ୍ଗ୍ ପେନେ ମେଃନେ ଡିଙ୍ଗ୍ ମ୍ୱକେ ବୁଜେ ପେୟାକେ କି ?” ");
INSERT INTO gaq_vpl VALUES ("JN13_13","073_13_13","JHN","13","13","13","ପେ ଆନେଙ୍ଗ୍‌କେ ଗୁରୁ ଆରି ମାପ୍ରୁ ଡାଗ୍‌ଚେ ୱା ପେଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ସତ୍ ଡାଗ୍ଲା ସତେଆ ନେଙ୍ଗ୍ ଆତେନ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("JN13_14","073_13_14","JHN","13","14","14","ପେନେ ଗୁରୁ ଆରି ମାପ୍ରୁ ଡିଙ୍ଗ୍‌ଚେ ନେଙ୍ଗ୍ ଜଦି ପେନେ ଞ୍ଚ ଗଡ଼୍ୟାଃ ମ୍ୱିକେ, ତେଲା ପେଇଂ ଡିଗ୍ ପେନେ ଞ୍ଚ ଗଃଡ଼ିଆନେ ଦର୍‍କାର୍ । ");
INSERT INTO gaq_vpl VALUES ("JN13_15","073_13_15","JHN","13","15","15","ଡାଗ୍ଲା ପେ ଆଡ଼ାତ୍ରା ନେଙ୍ଗ୍ ଡିରକମ୍ ଡିଙ୍ଗ୍‍ମ୍ୱକେ ପେଡିଗ୍ ଦେତ୍ ସୁଗୁଆ ଡିଙ୍ଗ୍‌ପା ଆତେନ୍‌‌ସା ନେଙ୍ଗ୍ ଆପେକେ ମୁଇଙ୍ଗ୍ ଗାଲି ଆକେ ମ୍ୱକେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_16","073_13_16","JHN","13","16","16","ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ମୁଡ଼ି ଗତିରେ ଡିଗ୍ ମେଁନେ ମାଲିକ୍ ବାନ୍ ମ୍ନା ଣ୍ଡୁ ବା ଜା ପାଙ୍ଗ୍‌ଲେକେ ମେଁ ଆମେକେ ବେବକ୍ନେ ଆବା ବାନ୍ ମ୍ନା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN13_17","073_13_17","JHN","13","17","17","ଜଦି ପେଇଂ ଆକେନ୍ ସାପା ମ୍ୟାପେଲେକେ ତେଲା ଦେତ୍‌ସୁଗୁଆ ପେଡିଙ୍ଗ୍‍ଲା ପେଇଂ ଦନ୍ୟ । ");
INSERT INTO gaq_vpl VALUES ("JN13_18","073_13_18","JHN","13","18","18","“ପେ ସାପାରେନେ ସାମୁଆଁରେ ନେଙ୍ଗ୍ ଏନ୍‌ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ ନେଡିଙ୍ଗ୍‌କେ । ନେଙ୍ଗ୍ ଜାଣ୍ଡେଇଂକେ ସ୍ରି ମ୍ବକେ ଆମେଇଂକେ ନେଙ୍ଗ୍ ମ୍ୟାନ୍ଲେକେ । ମାତର୍‌ ସାସ୍ତର୍‌ନେ ଏନ୍‌ ସାମୁଆଁ ସତେଆ ଗଟେଏ ସାମୁଆଁ ଜା ନେଙ୍ଗ୍‌ନେ ବଲେ ଚଙ୍ଗ୍‍ଚେ ମ୍ନା ଲେଃଗେ ମେଁ ନେଙ୍ଗ୍‌ନେ ବିରଦ୍‌ରେ ଲାତ୍‍ ଆତଡ଼ିଆକେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_19","073_13_19","JHN","13","19","19","ଆକେନ୍ ଗଟେନେ ସେନୁଗ୍‍ ନେଙ୍ଗ୍ ଆପେକେ ଆଃମ୍ୟା ବିଣ୍ଡିଂକେ । ଉଡ଼ିବେଲା ଆତେନ୍‌ ଗଟେଏ ପେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌ଏ ଜେ ସାମୁଆଁ ନେଙ୍ଗ୍ ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଆତେନ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("JN13_20","073_13_20","JHN","13","20","20","ନେଙ୍ଗ୍ ଆପେକେ ସତ୍‍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଂକେ, ଜା ନେଙ୍ଗ୍‌ବାନ୍‌ ପାଙ୍ଗ୍‍ଲେକ୍ନେ ରେମୁଆଁକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ, ମେଁ ଆନେଙ୍ଗ୍ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ବାରି ଜା ଆନେଙ୍ଗ୍ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ମେଁ ନେଙ୍ଗ୍‌ନେ ବେବକ୍ନେ ମାଲିକ୍‌କେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_21","073_13_21","JHN","13","21","21","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଆତ୍ମାନ୍ନିଆ ଲିବିସଃଚେ ଜିସୁ ଦୁକ୍‍ରେ ସମ୍ୱାଲେ ମାୟାଚେ କୁଲାକୁଲି ବାବ୍‌ରେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ପେ ବିତ୍ରେ ବାନ୍ ମୁଇଂଜା ନେଙ୍ଗ୍ ଆଡ଼ାତ୍ରା ବିସ୍‌ବାସ୍‌ଗାତ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ୱେଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_22","073_13_22","JHN","13","22","22","ଆଜାକେ କେଚେ ଜିସୁ ଏନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କେ ଆତେନ୍‌ ବୁଜେ ମାୟାଚେ ସିସ୍‍ଇଂ ମେଇଂମେଇଂ ବିତ୍ରେ କିକେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_23","073_13_23","JHN","13","23","23","ମେଇଂ ବିତ୍ରେ ମୁଡ଼ି ସିସ୍‍କେ ଜିସୁ ଜାବର୍‌ ବଲ୍ ବାଡିଙ୍ଗ୍‌ଗେ ମେଁ ଜିସୁନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା କଚେ ଚଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_24","073_13_24","JHN","13","24","24","ଶିମୋନ୍ ପିତର୍ ଆମେକେ ନ୍ତି ମାୱେଚେ ବାସଙ୍ଗ୍‌କେ “ଜା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ ଆମେକେ ସାଲ୍ୟାକୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_25","073_13_25","JHN","13","25","25","ଆତେନ୍‌ ସିସ୍‍ ଜିସୁ ଡାଗ୍ରା ଡେରେଚେ ସାଲିଆକୁକେ “ମେଁ ଜା ମାପ୍ରୁ ?” ");
INSERT INTO gaq_vpl VALUES ("JN13_26","073_13_26","JHN","13","26","26","ଜିସୁ ଉତର୍ ବିକେ, “ରୁଟିକେ ମୁତାନ୍ନିଆ ଜଣ୍ଡିଆଚେ ଆଜାକେ ମ୍ୱିଏ ମେଁ ଆତେନ୍‌ ।” ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁ ରୁଟିକେ ମୁତାନ୍ନିଆ ଜଣ୍ଡିଆଚେ ସିମୋନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଇଷ୍କରିୟଥ୍ ଜିଉଦାକେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_27","073_13_27","JHN","13","27","27","ଜିହୁଦା ରୁଟିକେ ସାଃନେ ବେଲା ମେଁନେ ବିତ୍ରେ ସ‍ଏତାନ୍ ଗାକେ ଆରି ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ମେଁ ଡିଙ୍ଗ୍‌ନେ ଚାଏଁନାଡିଙ୍ଗ୍‌କେ ଜିଆଃ ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_28","073_13_28","JHN","13","28","28","ଜିସୁ ଆମେକେ ଏନ୍‌ ସାମୁଆଁ ମେଁନ୍‌ସା ବାସଙ୍ଗ୍‌କେ ଚଙ୍ଗ୍ କଲେଃକ୍ନେ ରେମୁଆଁ ବିତ୍ରେବାନ୍ ଜା ଡିଗ୍ ବୁଜେ ଆୟାଆର୍‍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN13_29","073_13_29","JHN","13","29","29","ଜିଉଦାନେ ନ୍ତିନ୍ନିଆ ଡାବୁ ପିଡ଼ି ଲେଃଗେସା ଉଡ଼ି ସିସ୍‍ ସାଲ୍ୟାକୁ ଆର୍‌କେ ପାଣ୍ଡୁଏନ୍‍ସା ମେଁନେ ଦର୍‌କାର୍ ଆତେନ୍‌ ଜିନିସ୍ ବିଆର୍ ନ୍‌ସା ଣ୍ଡୁଲା ଗରିବ୍ ରେମୁଆଁଇଂକେ ଦାନ୍ ଦକିନା ବିଃନ୍‍ସା ଜିସୁ ଆମେକେ ଆଦେସ୍‍ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_30","073_13_30","JHN","13","30","30","ରୁଟିକେ ସାଚେ ଜିହୁଦା ଆତେନ୍‌ ଦାପ୍ରେ ପାଦା ତାର୍‍ୱେକେ । ଆତେନ୍‌‌ ବେଲା ମିଡିଗ୍‌ବ । ");
INSERT INTO gaq_vpl VALUES ("JN13_31","073_13_31","JHN","13","31","31","ଜିହୁଦା ତାର୍‍ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଏବେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେ ମ୍ନାଃ ଡିଙ୍ଗ୍‌ନେ ବେଲା ପିଙ୍ଗ୍‍ଚାଲେକେ । ଆରି ମେଁ ଆତ୍‍ଲା ଇସ୍‌ପର୍ ଡିଗ୍ ମ୍ନାଃ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN13_32","073_13_32","JHN","13","32","32","ଜଦି ଇସ୍‌ପର୍ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେବାନ୍ ମ୍ନାଃ ଡିଙ୍ଗ୍‌ଏ ଇସ୍‌ପର୍ ନିଜେନେ ମ‍ଇମାରେ ରେମୁଆଁ ଉଙ୍ଗ୍‌ଡେକେ ମ୍ନାଃ ଆଡିଙ୍ଗ୍‌ଏ । ଜିଆଃ ମେଁ ଆକେନ୍ ଡିଙ୍ଗ୍‌ନେ ୱେଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN13_33","073_13_33","JHN","13","33","33","ଏ ଗଡ଼େଇଂ ! ନେଙ୍ଗ୍ ପେ ଏତେ ଆରି ଜାବର୍‌ ଗଣ୍ଟା ନ୍ନାଲେଃ ଣ୍ଡୁ । ପେ ଆନେଙ୍ଗ୍ ପେତୁର୍‍ଏ ମାତର୍‌ ନେଙ୍ଗ୍ ଆଣ୍ଡିନ୍ନିଆ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ପେ ଆତ୍‌ଅରିଆ ୱେପେୟା ଣ୍ଡୁ ଏନ୍‌ ସାମୁଆଁ ନେଙ୍ଗ୍ ଡିରକମ୍ ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷ‍ଇଂକେ ମ୍ୱାସଙ୍ଗ୍‍କେ ଦେତ୍‍ରକମ୍‍ ଏବେ ଆପେକେ ଡିଗ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("JN13_34","073_13_34","JHN","13","34","34","ଏବେ ଆପେକେ ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ତ୍ମିନେ ନିଅମ୍ ବିଣ୍ଡିଂକେ: ପେପେ ବିତ୍ରେ ଆଲାଦ୍ ଡିଂପା । ନେଙ୍ଗ୍ ଆପେକେ ଡିରକମ୍ ବଲ୍ ବାଣ୍ଡିଂକେ ପେଡିଗ୍ ଦେତ୍‌ରକମ୍ ପେପେ ବିତ୍ରେ ଆଲାଦ୍ ଡିଂନେ ଦର୍‌କାର୍ । ");
INSERT INTO gaq_vpl VALUES ("JN13_35","073_13_35","JHN","13","35","35","ଜଦି ପେପେ ଡାଗ୍ରା ପେନେ ଆଲାଦ୍ ଲେଃଏ, ତେଲା ସାପାରେ ମ୍ୟାଃଆର୍‍ଏ ଜେ ପେ ନେଙ୍ଗ୍‌ନେ ସିସ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_36","073_13_36","JHN","13","36","36","ଶିମୋନ୍ ପିତର୍ ସାଲ୍ୟାକୁକେ: “ନାଁ ଆଣ୍ଡିନ୍ନିଆ ନାୱେଏ ମାପ୍ରୁ ?” ଜିସୁ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ଆଣ୍ଡିନ୍ନିଆ ଙ୍ଗୁଏଃଏ ଆତ୍‍ଅରିଆ ପେ ଏବେ ୱେପେୟା ଣ୍ଡୁ ମାତର୍‌ ଇଡ଼ିଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପେପାଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_37","073_13_37","JHN","13","37","37","ମାତର୍‌ ପିତର୍ ବାସଙ୍ଗ୍‌କେ, “ମେନ୍‌ସା ଏବେ ନାନେ ପ୍ଲା ପାଙ୍ଗ୍‍ନାୟା ମାପ୍ରୁ ? ନାନେ ଆତ୍‍ଲା ନେଙ୍ଗ୍ ନିଜର୍ ପାରାନ୍ ମ୍ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN13_38","073_13_38","JHN","13","38","38","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନାଁ ମେଃନେ ସତେଆ ନେଙ୍ଗ୍‍ସା ନିଜର୍ ପାରାନ୍ ନାବିଏ ? ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ଏ ମିଡିଗ୍ ଗିସେଙ୍ଗ୍‍ ସନେ ସେନୁଗ୍‍ ନାଁ ଆନେଙ୍ଗ୍ ନ୍ନାମ୍ୟାଃକେ ଡାଗ୍‌ଚେ ଞ୍ଜିତର୍‍ ନାବାସଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_1","073_14_1","JHN","14","1","1","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ପେଇଂ କାବା ଆଡିଙ୍ଗ୍‌ପା । ପେଇଂ ଇସ୍‌ପର୍‌ନ୍ନିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍ । ନେଙ୍ଗ୍‍ନ୍ନିଆ ଡିଗ୍ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("JN14_2","073_14_2","JHN","14","2","2","ନେଙ୍ଗ୍ ଆବାନେ ଡୁଆନ୍ନିଆ ଗୁଲୁଏ ବାକ୍‍ରା ଲେଃକେ । ଆତ୍‍ଅରିଆ ପେ ଆତ୍‍ଲା ଜାଗା ଆଃରେନ୍‍ସା ନେଙ୍ଗ୍ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ । ସତ୍ ଡିଙ୍ଗ୍ ଆଲେଃଲା ନେଙ୍ଗ୍ ଆପେକେ ଏନ୍‌ ସାମୁଆଁ ନ୍ନାବାସଙ୍ଗ୍‌ ପାଡିଙ୍ଗ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("JN14_3","073_14_3","JHN","14","3","3","ନେଙ୍ଗ୍ ୱେଚେ ପେ ଆତ୍‍ଲା ଜାଗା ତିଆର୍ ଡିଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଆଣ୍ଡେପାଙ୍ଗ୍‍ଚେ ଆପେକେ ନେଙ୍ଗ୍‍ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‌ୱେଏ । ତେଲା ନେଙ୍ଗ୍ ଲେଃକ୍ନେ ଜାଗାନ୍ନିଆ ପେଇଂ ଡିଗ୍‍ ପେଲେଏ । ");
INSERT INTO gaq_vpl VALUES ("JN14_4","073_14_4","JHN","14","4","4","ନେଙ୍ଗ୍ ଆଣ୍ଡିନ୍ନିଆ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ଆତ୍‍ଅରିଆ ୱେନେ ଗାଲି ପେ ମ୍ୟାଃ ପେଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_5","073_14_5","JHN","14","5","5","ଥୋମା ବାସଙ୍ଗ୍‌କେ, “ମାପ୍ରୁ ନା ଆଣ୍ଡିନ୍ନିଆ ୱେନାଡିଙ୍ଗ୍‍କେ ନେ ନେମ୍ୟାଃକେ ଣ୍ଡୁ; ଆତ୍‍ଅରିଆ ୱେନେ ଗାଲି ଡିରକମ୍ ନେମ୍ୟାଃଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN14_6","073_14_6","JHN","14","6","6","ଜିସୁ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ଗାଲି ସତ୍ ଆରି ଜିବନ୍ । ଆନେଙ୍ଗ୍ ବିଚେ ଆୱେଲା ଜା ଆବାଡାଗ୍ରା ଡିଗ୍ ୱେଆୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN14_7","073_14_7","JHN","14","7","7","ଆନେଙ୍ଗ୍ ମ୍ୟାଃଲା ନେଙ୍ଗ୍‌ନେ ଆବାକେ ଡିଗ୍ ପେମ୍ୟାଏ । ଏନ୍‌ ବେଲା ବାନ୍ ପେଇଂ ଆମେକେ ମ୍ୟାପେଡିଙ୍ଗ୍‌କେ ବାରି କେୟା ପେଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_8","073_14_8","JHN","14","8","8","ପିଲିପ୍ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ଆବାକେ ଆକେ ବିଲା । ଅଃତେନ୍‍ ଆଃ ନେନେ ଆତ୍‍ଲା ରାଜି ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_9","073_14_9","JHN","14","9","9","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ପିଲିପ୍‍ ଆତେନ୍‌‍ ଦିନା ସାଚେ ନେଙ୍ଗ୍ ପେନ୍ନିଆ ଲେଃଣ୍ଡିଂକେ ଏ ଜାକ ନା ଆନେଙ୍ଗ୍ ନ୍ନାସାମୁଆଃକେ ଣ୍ଡୁ । ଜା ଆନେଙ୍ଗ୍‌କେ କିକେ ଲେଃକେ ମେଁ ନେଙ୍ଗ୍‌ନେ ଆବାକେ କିକେ ଲେଃକେ । ତେଲା ଆବାକେ ଆକେନ୍‍ସା ମେଁନ୍‌ସା ବାସଙ୍ଗ୍‌ ପେଡିଙ୍ଗ୍‌କେ ? ");
INSERT INTO gaq_vpl VALUES ("JN14_10","073_14_10","JHN","14","10","10","ନେଙ୍ଗ୍ ଆବାନ୍ନିଆ ଆରି ଆବା ନେଙ୍ଗ୍‍ନ୍ନିଆ ଲେଃଏ ଏନ୍‌ ସାମୁଆଁ ନାଁ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ ନାଡିଙ୍ଗ୍‌କେ ପିଲିପ୍ ? ଜା ସାପା ସାମୁଆଁ ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଆତେନ୍‌ ନେଙ୍ଗ୍ ନିଜେନେ ଣ୍ଡୁ । ମାତର୍‌ ଆବା ନେଙ୍ଗ୍‍ନ୍ନିଆ ଲେଃଚେ ମେଁନେ କାମ୍ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN14_11","073_14_11","JHN","14","11","11","ନେଙ୍ଗ୍ ଜେ ଆବାନ୍ନିଆ ନ୍ଲେକେ ଆରି ଆବା ନେଙ୍ଗ୍‍ନ୍ନିଆ ଲେଃକେ ନେଙ୍ଗ୍‌ନେ ଏନ୍‌ ସାମୁଆଁରେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ପା । ନେଙ୍ଗ୍‌ନେ ଏନ୍‌ ସାମୁଆଁରେ ଜଦି ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍ ତେଲା ନେଙ୍ଗ୍‌ନେ କାମ୍‍କେ କେଚେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("JN14_12","073_14_12","JHN","14","12","12","ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ନେଙ୍ଗ୍‍ନ୍ନିଆ ଜା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଏ ନେଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଣ୍ଡିଂକ୍ନେ କାମ୍ ସାପା ମେଁ ଡିଙ୍ଗ୍ଇଁୟାଏ । ଆକ୍‌ମେଁବାନ୍ ଆରି ମ୍ନା କାମ୍ ଡିଗ୍ ମେଁ ଡିଙ୍ଗ୍ଇଁୟାଏ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଆବାଡାଗ୍ରା ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ");
INSERT INTO gaq_vpl VALUES ("JN14_13","073_14_13","JHN","14","13","13","ଜଦି ନେଙ୍ଗ୍ ମ୍ନିରେ ପେ ଜା ସାପା ପେସାଲିଆଏ ଆତେନ୍‌ ନେଙ୍ଗ୍ ମ୍ୱିଏ । ଆକ୍‌ମେ ସାଚେ ଉଙ୍ଗ୍‌ଡେନ୍ନିଆ ଆବା ଇସ୍‌ପର୍‌ନେ ମ‍ଇମା ତ୍ନାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN14_14","073_14_14","JHN","14","14","14","ନେଙ୍ଗ୍ ମ୍ନି ସାଚେ ଆନେଙ୍ଗ୍‌କେ ଜା ସାପା ପେସାଲ୍ୟାଃଏ ନେଙ୍ଗ୍ ଆପେକେ ଆତେନ୍‌ ମ୍ୱିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_15","073_14_15","JHN","14","15","15","“ଆନେଙ୍ଗ୍ ଜଦି ଆଲାଦ୍ ନାଡିଂଏ ତେଲା ନେଙ୍ଗ୍‌ନେ ଆଦେସ୍‍ ସାପା ପାଲନ୍ ଡିଙ୍ଗ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("JN14_16","073_14_16","JHN","14","16","16","ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଆବାକେ ପାର୍‌ତନା ଣ୍ଡିଙ୍ଗ୍‍ଏ ଆରି ପେଇଂ ଏତେ କାଲାଆଃ ଲେଃନ୍‌ସା ମେଁ ବାର୍‌ମୁଇଂ ସାଇଜ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେକେ ବେଏ । ");
INSERT INTO gaq_vpl VALUES ("JN14_17","073_14_17","JHN","14","17","17","ମେଁ ଡିଂକେ ସତ୍ୟମୟ ଆତ୍ମା । ଏନ୍ ମଞ୍ଚ୍‌ପୁର୍‌ ଆମେକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ଆୟା ଣ୍ଡୁ ଡାଗ୍ଲା ମଞ୍ଚ୍‌ପୁର୍‌ ଆମେକେ କେଆୟା ଣ୍ଡୁ କି ସାମୁଆଁ ଆୟା ଣ୍ଡୁ । ମାତର୍‌ ପେଇଂ ଆମେକେ ପେମ୍ୟାଏ । ଡାଗ୍ଲା ପେଏତେଏ ମେଁ ବାସା ଲେଃଏ । ପେନେ ଡାଗ୍ରା ମେଁ ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_18","073_14_18","JHN","14","18","18","“ନେଙ୍ଗ୍ ଆପେକେ ଅରେଃ ଉଙ୍ଗ୍‌ଡେ ସୁଗୁଆ ଆନ୍ତାର୍‍ଚେ ନ୍ନାୱେ ଣ୍ଡୁ । ନେଙ୍ଗ୍ ପେଡାଗ୍ରା ଆଣ୍ଡେ ମ୍ପାଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN14_19","073_14_19","JHN","14","19","19","ଇତୁଡ଼ା ବେଲା ଇଡ଼ିଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌ ଆନେଙ୍ଗ୍‌କେ ବାରି ଆକେ ଣ୍ଡୁ ମାତର୍‌ ପେଇଂ ଆନେଙ୍ଗ୍ ପେକେଏ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ସାପାଦିନା ନ୍‍ସା ଜିବନ୍ ଡିଙ୍ଗ୍‌ଚେ ନ୍ଲେଏ ପେ ଡିଗ୍ ନେଙ୍ଗ୍‍ ଏତେ ଜିବନ୍ ଡିଙ୍ଗ୍‌ଚେ ପେଲେଏ । ");
INSERT INTO gaq_vpl VALUES ("JN14_20","073_14_20","JHN","14","20","20","ଆତେନ୍‌ ଦିନା ପାଙ୍ଗ୍‌ଲା ପେ ପେମ୍ୟାଏ; ନେଙ୍ଗ୍ ଆବାନ୍ନିଆ ପେ ନେଙ୍ଗ୍‍ନ୍ନିଆ ଆରି ନେଙ୍ଗ୍ ପେ ବିତ୍ରେ ନ୍ଲେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_21","073_14_21","JHN","14","21","21","“ଜା ନେଙ୍ଗ୍‌ନେ ଆଦେସ୍‍ ସାଚେ ପାଲନ୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ଆଃ ଆନେଙ୍ଗ୍ ବଲ୍‍ ବାଏ । ଜାଣ୍ଡେ ଜଦି ଆନେଙ୍ଗ୍‌କେ ବଲ୍ ବାଏ ନେଙ୍ଗ୍‌ନେ ଆବା ଆମେକେ ବଲ୍ ବାଏ । ନେଙ୍ଗ୍‍ ଡିଗ୍‍ ଆମେକେ ବଲ୍ ବାଚେ ମେଁନ୍ନିଆ ନେଙ୍ଗ୍ ନିଜ୍‍କେ ନ୍ନାତ୍ନାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_22","073_14_22","JHN","14","22","22","ଇଷ୍କରିୟଥ୍ ଜିଉଦା ଣ୍ଡୁ ବିନ୍ ଜିଉଦା ସାଲ୍ୟାକୁକେ, “ମାପ୍‌ରୁ, ଆକେନ୍ ଡିରକମ୍ ଡିଙ୍ଗ୍‌ଏ ? ନିଜ୍‍କେ ମଞ୍ଚ୍‌ପୁର୍‌ ନ୍ନିଆ ମାରାତ୍ନାଚେ ନେନେ ଡାଗ୍ରା ଡିରକମ୍ ନାରାତ୍ନାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN14_23","073_14_23","JHN","14","23","23","ଜିସୁ ଉତର୍ ବିକେ “ଜା ଆନେଙ୍ଗ୍ ବଲ୍ ବାଏ ମେଁ ନେଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ପାଲେଏ । ତେଲା ନେଙ୍ଗ୍ ଆବା ଆମେକେ ବଲ୍ ବାଏ ଆରି ନେଙ୍ଗ୍ ଆବା ଆରି ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଚେ ମେଁ ଏତେ ନେବାସାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN14_24","073_14_24","JHN","14","24","24","ଜା ଆନେଙ୍ଗ୍ ବଲ୍ ଆବା ଣ୍ଡୁ ମେଁ ନେଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ପାଲନ୍ ଆଡିଙ୍ଗ୍‍ଣ୍ଡୁ । ନେଙ୍ଗ୍ ବିମ୍ୱକ୍ନେ ବୁଦି ନେଙ୍ଗ୍‌ନେ ଣ୍ଡୁ ଆତେନ୍‌ ଆନେଙ୍ଗ୍‌କେ ବେବକ୍ନେ ମ୍ନାଃଆବା ଇସ୍‌ପର୍‌ନେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_25","073_14_25","JHN","14","25","25","“ନେଙ୍ଗ୍ ପେ ଏତେ ଲେଃ କେଲା ଆପେକେ ଏନ୍‌ ସାପା ସାମୁଆଁ ମ୍ୱାସଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN14_26","073_14_26","JHN","14","26","26","ମୁଡ଼ି ସାଆଜ୍ୟ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେ ପବିତ୍ର ଆତ୍ମାକେ ଇସ୍‌ପର୍ ନେଙ୍ଗ୍ ମ୍ନିରେ ବେଏ, ମେଁ ସାପାନେ ସାମୁଆଁରେ ଆପେକେ ବୁଦି ବିଏ ବାରି ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ମ୍ୱକ୍ନେ ସାପା ସାମୁଆଁ ଆଏତେ ବିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN14_27","073_14_27","JHN","14","27","27","“ପେ ଡାଗ୍ରା ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ସାମୁଆଁ ଆନ୍ତାର୍‍ଚେ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ । ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ସାନ୍ତି । ନେଙ୍ଗ୍ ନିଜେନେ ସାନ୍ତି ନେଙ୍ଗ୍ ଆପେକେ ଦାନ୍ ବିଚେ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ । ମଞ୍ଚ୍‌ପୁର୍‌ ଦାନ୍ ବିଡିଙ୍ଗ୍‌କ୍ନେ ସାନ୍ତି ସୁଗୁଆ ଆକେନ୍ ଣ୍ଡୁ । ଚିନ୍ତା କି ତାନ୍ଦ୍ରା ଆଡିଙ୍ଗେପା କି ଆବ୍‌ଟଗେପା । ");
INSERT INTO gaq_vpl VALUES ("JN14_28","073_14_28","JHN","14","28","28","ନେଙ୍ଗ୍ ମେଃନେ ବାସଙ୍ଗ୍‍ମ୍ୱଗେ, ଅଁ ପେଲେକେ, ନେଙ୍ଗ୍ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ମାତର୍‌ ବାର୍‌ମୁଇଂତର୍‍ ଆଣ୍ଡେ ମ୍ପାଙ୍ଗ୍‍ଏ । ଆନେଙ୍ଗ୍ ଜଦି ସତ୍‍ରେ ବଲ୍ ବାପେଲେଏ, ନେଙ୍ଗ୍ ଆବାଡାଗ୍ରା ୱେଡିଙ୍ଗ୍‌କ୍ନେ ଅଁଚେ ସାର୍ଦା ପେଡିଙ୍ଗ୍‌ଏ; ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆବା ନେଙ୍ଗ୍‍ବାନ୍ ମ୍ନା । ");
INSERT INTO gaq_vpl VALUES ("JN14_29","073_14_29","JHN","14","29","29","ଜା ସାପା ଗଟେନେ ଲେଃକେ ଆତେନ୍‌ ସେନୁଗ୍‍ଆ ନେଙ୍ଗ୍ ଆପେକେ ଆମ୍ୟାମ୍ୱିକେ । ଆତେନ୍‌ ସାପା ଗଟେଲା ପେ ଆନେଙ୍ଗ୍‌କେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN14_30","073_14_30","JHN","14","30","30","ନେଙ୍ଗ୍ ପେ ଏତେ ବାରି ଗ୍ଲୁଏପର୍‍ ବାଲିର୍‌ବାତା ଡିଙ୍ଗ୍‍ନ୍ନାୟା ଣ୍ଡୁ ଡାଗ୍ଲା ଆକେନ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସାସନ୍ ଡିଂଣ୍ଡ୍ରେ ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ତେଲାଡିଗ୍‍ ନେଙ୍ଗ୍ ଆଡ଼ାତ୍ରା ମେଁନେ ମେଃଡିଗ୍ ଅଦିକାର୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN14_31","073_14_31","JHN","14","31","31","ଆବା ଆନେଙ୍ଗ୍ ଡିରକମ୍ ଆଦେସ୍‍ ବିବକେ ଆତେନ୍‌ ଇସାବ୍‌ରେ ନେଙ୍ଗ୍ କାମ୍ ଣ୍ଡିଙ୍ଗ୍‍ଏ ତେଲା ନେଙ୍ଗ୍ ନେଙ୍ଗ୍‌ନେ ଆବାକେ ବଲ୍ ବାଣ୍ଡିଂକେ ଡାଗ୍‌ଚେ ମଞ୍ଚ୍‌ପୁର୍‌ ମ୍ୟାଏ ।” “ଏଲାପା ନେଃ ଆକ୍‌ବାନ୍ ଲାଗ୍‍ନେଡପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN15_1","073_15_1","JHN","15","1","1","“ନେଙ୍ଗ୍ ସତେଆ ଅଙ୍ଗୁର୍ ସ୍ଲା ବାରି ନେଙ୍ଗ୍‌ନେ ଆବା ସ୍ଲେରେ । ");
INSERT INTO gaq_vpl VALUES ("JN15_2","073_15_2","JHN","15","2","2","ମୁଡ଼ି କେନ୍ଦାନିଆ ଚୁଚୁ ଆଚୁଣ୍ଡୁ ଆମେକେ ମେଁ ସିତଗ୍ ଜଗ୍‌ତ୍ଲାଗ୍‌ଏ ଆରି ମୁଡ଼ି କେନ୍ଦାନ୍ନିଆ ଚୁ ଚୁଏ ଜବର୍ ଚୁଚୁନ୍‍ସା ଆମେକେ ସିତଗ୍‍ଚେ ପର୍‍ଚଲ୍‍ ଆଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_3","073_15_3","JHN","15","3","3","ନେଙ୍ଗ୍‍ବାନ୍‍ ବାପେଲେକ୍ନେ ବୁଦିବାନ୍‍ ପେଇଂ ପର୍‍ଚଲ୍‍ ଡିଙ୍ଗ୍‍ପେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN15_4","073_15_4","JHN","15","4","4","ନେଙ୍ଗ୍‍ ଏତେ କୁଡ଼େଚେ ଲାଲାପା । ତେଲା ନେଙ୍ଗ୍ ଡିଗ୍ ପେ ଏତେ ନ୍ଲେଏ । କେନ୍ଦା ବୁନ୍ଦ୍‍ ସ୍ଲା ଏତେ କୁଡ଼େଚେ ଆଲେଃଲା ମେଁ ନିଜେ ଚୁ ଚୁଚୁ ଆୟା ଣ୍ଡୁ ଦେତ୍‌ରକମ୍ ପେ ନେଙ୍ଗ୍‍ଡାଗ୍ରା ପେଲେଲା ମ୍ନା ପେୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN15_5","073_15_5","JHN","15","5","5","“ନେଙ୍ଗ୍ ଅଙ୍ଗୁର୍ ସ୍ଲା ପେଇଂ କେନ୍ଦା । ଜାଣ୍ଡେ ନେଙ୍ଗ୍‍ନ୍ନିଆ ଲେଃଏ ଆରି ନେଙ୍ଗ୍ ଜା ନ୍ନିଆ ନ୍ଲେଏ ମେଁ ଜବର୍ ଚୁଚୁ ଚୁଏ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଣ୍ଡୁଲା ପେ ମେଃଡିଗ୍ ଡିଙ୍ଗ୍‍ପେୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN15_6","073_15_6","JHN","15","6","6","ଜା ନେଙ୍ଗ୍‍ନ୍ନିଆ ଆଲେଃ ଣ୍ଡୁ ଆମେକେ ମୁଇଙ୍ଗ୍ ଗ୍ୱାତଗ୍‍ବକ୍ନେ କେନ୍ଦା ରକମ୍ ପାଦାପାକା ଜଗ୍‍ତ୍ଲାଗ୍‍ ବିଏ ଆରି ଆତେନ୍‌ ନ୍‍ସୁଆର୍‍ୱେଏ । ଦେକ୍‌ରକମ୍ କେନ୍ଦାଇଂ ରେମୁଆଁ ମୁଇଂତୁଗ୍ ରାଃସିଙ୍ଗ୍‌ଚେ ସୁଆନ୍ନିଆ ତ୍ଲାଗ୍ ବିଆର୍‌ଏ ଆରି ଆତେନ୍‌ଇଂ ଗିଃୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_7","073_15_7","JHN","15","7","7","ପେ ଜଦି ନେଙ୍ଗ୍‍ ଏତେ କୁଡ଼େଚେ ପେଲେଏ ବାରି ନେଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ପେନେ ରୁଦୟ୍‌ନ୍ନିଆ ଲେଃଏ ତେଲା ପେ ମେଁନେ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ଚେ ପେସାଲ୍ୟାଃଏ ଆତେନ୍‌ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_8","073_15_8","JHN","15","8","8","ପେଇଂ ଜବର୍ ଚୁ ପେଚୁଲା ନେଙ୍ଗ୍ ଆବାନେ ମ‍ଇମା ପ୍ରକାସ୍‍ ଡିଙ୍ଗ୍‌ଏ ବାରି ଆକେନ୍‌ବାନ୍ ପେ ନେଙ୍ଗ୍‌ନେ ସିସ୍‍ ପେଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_9","073_15_9","JHN","15","9","9","ଆନେଙ୍ଗ୍‌କେ ଆବା ଡିରକମ୍ ଆଲାଦ୍ ଡିଂଡିଂକେ ଆପେକେ ନେଙ୍ଗ୍ ଦେତ୍‌ରକମ୍ ବଲ୍ ମ୍ୱାଏ । ନେଙ୍ଗ୍ ବଲ୍ ବାଏରେ ପେଇଂ ଏବେ ବଲ୍‍ରେ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("JN15_10","073_15_10","JHN","15","10","10","ନେଙ୍ଗ୍ ଡିରକମ୍ ନେଙ୍ଗ୍ ଆବାନେ ଆଦେସ୍‍ ପାଲେଚେ ମେଁନେ ଆଲାଦ୍‌ନ୍ନିଆ ନେଙ୍ଗ୍ ତାନ୍ଦ୍ରା ଡିଙ୍ଗ୍‍ନାଲେଃକେ ପେ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ନେଙ୍ଗ୍‌ନେ ଆଦେସ୍‍ ପାଲେଲା ନେଙ୍ଗ୍ ଆଲାଦ୍‌ରେ ସାନ୍ତି ଡିଙ୍ଗ୍‌ଚେ ପେଲେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN15_11","073_15_11","JHN","15","11","11","“ନେଙ୍ଗ୍ ଆପେକେ ଏନ୍‌ ବୁଦି ବିଣ୍ଡିଂକେ ପେ ଡିରକମ୍ କି ନେଙ୍ଗ୍‌ନେ ସାର୍ଦା ବାଚେ ସାର୍ଦାରେ ପୁର୍ତି ଡିଙ୍ଗ୍‌ଚେ ମ୍ୟା ପେୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_12","073_15_12","JHN","15","12","12","ନେଙ୍ଗ୍ ଆପେକେ ଡିରକମ୍ ବଲ୍ ବାଣ୍ଡିଂକେ ପେଇଂ ଦେତ୍‌ରକମ୍ ନିଜର୍ ନିଜର୍ ରେମୁଆଁଇଂକେ ବଲ୍ ବାପା ଏନ୍‌ ନେଙ୍ଗ୍‌ନେ ଆଦେସ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("JN15_13","073_15_13","JHN","15","13","13","ପେନେ ସାଙ୍ଗ‍ଇଂ ନ୍‍ସା ନିଜର୍ ଜିବନ୍ ଦାନ୍ ବିଃନେ ବାଦୁଲ୍ ଜାନେ ଆରି ଜବର୍ ମ୍ନା ଆଲାଦ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN15_14","073_15_14","JHN","15","14","14","ନେଙ୍ଗ୍ ଆପେକେ ଆଣ୍ଡିନେ ଆଦେସ୍‍ ବିମ୍ୱକେ, ଆତେନ୍‌ ଜଦି ପେପାଲେଏ, ତେଲା ପେ ନେଙ୍ଗ୍‌ନେ ରେମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("JN15_15","073_15_15","JHN","15","15","15","ନେଙ୍ଗ୍ ଆପେକେ ବାରି ଚାକର୍ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ନେଡିଙ୍ଗ୍‌କେ; ଡାଗ୍ଲା ସାଉକାର୍ ମେଁନେ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଚାକର୍ ଆମ୍ୟା ଣ୍ଡୁ । ନେଙ୍ଗ୍ ଆପେକେ ସାଙ୍ଗ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଆବାବାନ୍‍ ମେଁ ମେଁନେ ଅଁନ୍ଲେକେ ଆତେନ୍‌ ସାପା ଆପେକେ ଆମ୍ୟା ବିଃ ଣ୍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN15_16","073_15_16","JHN","15","16","16","ନାଁ ଆନେଙ୍ଗ୍‌କେ ସ୍ରି ନାବକେ ନେଙ୍ଗ୍ ଆନାକେ ବାଚେ ମ୍ୱକେ । ପେ ଜେନ୍ତିକି ଜବର୍ ଚୁ ପେଚୁଏ ଆରି ଆତେନ୍‌ ଜେନ୍ତିକି ସାନ୍ତିରେ ଲେଃଏ ଆତେନ୍‌‌ସା ଆପେକେ ନେଙ୍ଗ୍ ବାଚେ ମ୍ୱକେ । ତେସା ନେଙ୍ଗ୍ ମ୍ନିରେ ଜା ପେସାଲ୍ୟାଃଏ ନେଙ୍ଗ୍ ଆବା ଆତେନ୍‌ ଆପେକେ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_17","073_15_17","JHN","15","17","17","ଆତେନ୍‌‌ସା ପେଇଂ ଆଡ଼ାତ୍ରା ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ଆଦେସ୍‍ ବିଣ୍ଡିଂକେ ପେପେ ବିତ୍ରେ ବଲ୍ ବାପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN15_18","073_15_18","JHN","15","18","18","ଜଦି ମଞ୍ଚ୍‌ପୁର୍‌ ଆପେକେ କୁଟ୍ ଡିଙ୍ଗ୍‌ଏ ତେଲା ଆପେକେ କୁଟ୍ ଡିଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ମେଁ ଜେ ଆନେଙ୍ଗ୍ କୁଟ୍ ଡିଙ୍ଗ୍‍ବକେ ଆତେନ୍‌ ପେ ମ୍ୟାପା । ");
INSERT INTO gaq_vpl VALUES ("JN15_19","073_15_19","JHN","15","19","19","ଜଦି ପେଇଂ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଡିଙ୍ଗ୍ ପେପାଲେ ତେଲା ମଞ୍ଚ୍‌ପୁର୍‌ ଆପେକେ ନିଜର୍ ରେମୁଆଁ ମ୍ୟାଚେ ଆଲାଦ୍ ପାଡିଙ୍ଗ୍‍ ଆର୍‌ଏ ମାତର୍‌ ପେଇଂ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଣ୍ଡୁ ମାତର୍‌ ନେଙ୍ଗ୍ ଆପେକେ ମଞ୍ଚ୍‌ପୁର୍‌ ବାନ୍ ବାଚେ ମ୍ୱକେ । ଆତେନ୍‌‌ସା ମଞ୍ଚ୍‌ପୁର୍‌ ଆପେକେ କୁଟ୍ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN15_20","073_15_20","JHN","15","20","20","ଚାକର୍ ମେଁନେ ସାଉକାର୍ ବାନ୍ ମ୍ନା ଣ୍ଡୁ ନେଙ୍ଗ୍ ଆପେକେ ଏନ୍‌ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‍ମ୍ୱକେ ଆତେନ୍‌ ମନେ ତ୍ଲାଗ୍‌ପା । ଜଦି ମେଇଂ ଆନେଙ୍ଗ୍ ନିନ୍ଦା ଡିଙ୍ଗ୍ ବଆର୍‌କେ ତେଲା ଆପେକେ ଡିଗ୍ ନିନ୍ଦା ଡିଙ୍ଗ୍ ଆର୍‌ଏ ଜଦି ମେଇଂ ନେଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ପାଲନ୍ ଡିଙ୍ଗ୍ ବଆର୍‌କେ ତେଲା ପେନେ ବ୍ନାଲିର୍ ଡିଗ୍ ପାଲେ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_21","073_15_21","JHN","15","21","21","ଡାଗ୍ଲା ମେଇଂ ଆନେଙ୍ଗ୍‌କେ ବେବକ୍ନେ ଆବାକେ ମ୍ୟା ଆଲେଃଗେସା ନେଙ୍ଗ୍‌ନେ ମ୍ନି ସାଚେ ପେଇଂ ଆଡ଼ାତ୍ରା ଏନ୍‌ ସାପା ଡିଙ୍ଗ୍ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_22","073_15_22","JHN","15","22","22","ଜଦି ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‌ଚେ ଏନ୍ ସାପା ବିସୟ୍ ଆମେଇଂକେ ବୁଜେ ମ୍ପାବ ଣ୍ତୁ ତେଲା ମେଇଂ ଦସ୍‌ ଡିଙ୍ଗ୍‌ଚେ ଆପାଲେଃଆର୍‌; ମାତର୍‌‌ ଏକ୍ରେ ଏନ୍ ପାପ୍‌ ଇଂ ନ୍‌ସା ମେଇଂ ମେଃଡିଗ୍‌ ନାକ୍ରା ଆଃସୁଏଃ ଆୟାଆର୍‌ ଣ୍ତୁ । ");
INSERT INTO gaq_vpl VALUES ("JN15_23","073_15_23","JHN","15","23","23","ଜା ଆନେଙ୍ଗ୍ ଆଂକାର୍ ଡିଙ୍ଗ୍‌ଏ ମେଁ ନେଙ୍ଗ୍‌ନେ ଆବାକେ ଡିଗ୍ ଆଂକାର୍ ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN15_24","073_15_24","JHN","15","24","24","ଆଣ୍ଡିନେ ସ୍ଲେ ସାପା ଜା ଡିଗ୍ ଆଡିଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ଜଦି ଆତେନ୍‌ ସାପା ମେଁଇଙ୍ଗ୍‌ନ୍ନିଆ ଡିଙ୍ଗ୍‍ ନ୍ନାବପାଡିଙ୍ଗ୍‍ ତେଲା ମେଁଇଙ୍ଗ୍‌ନେ ପାପ୍ ଡିଙ୍ଗ୍ ପେପାଲେ ଣ୍ଡୁ; ମାତର୍‌ ଏବେ ମେଇଙ୍ଗ୍ କେଲେ ଆର୍‌କେ ଆରି ଆନେଙ୍ଗ୍‌କେ ବାରି ନେଙ୍ଗ୍‌ନେ ଆବାକେ ମ୍ୱାୟାକେ ଆଂକାର୍ ଡିଙ୍ଗ୍ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN15_25","073_15_25","JHN","15","25","25","ମାତର୍‌ ମେଇଂ ବିନା ଦସ୍‍ରେ ଆନେଙ୍ଗ୍‌କେ କୁଟ୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ ମେଁଇଙ୍ଗ୍‌ନେ ସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ ବକେ ଏନ୍‌ ବ୍ନାଲିର୍ ଜେନ୍ତିକି ପୁରନ୍ ଡିଙ୍ଗ୍‌ଏ ଆତେନ୍‌‌ସା ଦେତ୍‌ରକମ୍ ଗଟେଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN15_26","073_15_26","JHN","15","26","26","“ଆବାବାନ୍‍ ନେଙ୍ଗ୍ ପେଡାଗ୍ରା ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ମ୍ୱେଏ ଆବାବାନ୍‍ ଆତେନ୍‌ ସତ୍ୟମୟ୍‌ ଆତ୍ମା ତାର୍‌ଚେ ପାଙ୍ଗ୍‌ଲା ନେଙ୍ଗ୍ ସାମୁଆଁରେ ସାକି ବିଏ; ");
INSERT INTO gaq_vpl VALUES ("JN15_27","073_15_27","JHN","15","27","27","ଆରି ପେଡିଗ୍ ସାକି ପେଲେକେ ଡାଗ୍ଲା ପେ ଆରାମ୍‍ ବାନ୍ ନେଙ୍ଗ୍ ଏତେ ଲେଃଚେ ପାଙ୍ଗ୍ ପେଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_1","073_16_1","JHN","16","1","1","“ପେଇଂ ଜେନ୍ତିକି ନିଜେନେ ବିସ୍‍ବାସ୍‍କେ ପେଆରେଏ, ଆତେନ୍‌‌ସା ନେଙ୍ଗ୍ ଆକେନ୍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‍ମ୍ୱକେ । ");
INSERT INTO gaq_vpl VALUES ("JN16_2","073_16_2","JHN","16","2","2","ମେଇଙ୍ଗ୍ ଆପେକେ ସମାଜ୍‍ବାନ୍‍ ନୁଆଁ ଆତାର୍‌ଏ ବାରି ଦେକ୍ ରକମ୍ ଦିନା ପାଙ୍ଗ୍‌ଏ ଉଡ଼ିବେଲା ରେମୁଆଁଇଂ ଆପେକେ ବାଗୁଏଃଏ ମେଁ ଇସ୍‌ପର୍‌ନ୍ନିଆ ସେବା ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଡାଗ୍‌ଚେ ବାବେ ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_3","073_16_3","JHN","16","3","3","ରେମୁଆଁଇଂ ପେ ଆଡ଼ାତ୍ରା ଆକେନ୍‍ ସାପା ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ଡାଗ୍ଲା ମେଇଂ ଆନେଙ୍ଗ୍‌କେ ବାରି ଆବାକେ ଆମ୍ୟାଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN16_4","073_16_4","JHN","16","4","4","ଆପେକେ ନେଙ୍ଗ୍ ଆକେନ୍‍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ଉଦେସ୍‍ ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଆକେନ୍‍ ସାପା ଗଟେଲା ପେଇଂ ପେଏତେଏ ଜେ ନେଙ୍ଗ୍ ସେନୁଗ୍‍ଆ ଆକେନ୍ ସାମୁଆଁରେ ବାଲିର୍‍ମ୍ୱଗେ ।” “ମୁଲେବାନ୍‍ ନେଙ୍ଗ୍ ଆପେକେ ଆକେନ୍‍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ନେବଗେ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ପେ ଏଃତେ ନ୍ଲେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_5","073_16_5","JHN","16","5","5","ଏବେ ନେଙ୍ଗ୍ ଆନେଙ୍ଗ୍ ବେବକ୍ନେ ମାଲିକ୍ ନ୍ନିଆ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ । ତେଲାଡିଗ୍‍ ନେଙ୍ଗ୍ ଆଣ୍ଡି ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ଡାଗ୍‌ଚେ ପେ ବିତ୍ରେ ବାନ୍ ଜା ଆନେଙ୍ଗ୍ ପେସାଲିଆକୁକେ । ");
INSERT INTO gaq_vpl VALUES ("JN16_6","073_16_6","JHN","16","6","6","ଏବେ ନେଙ୍ଗ୍‌ନେ ଆକେନ୍‍ ସାପା ବ୍ନାଲିର୍ ଅଁଚେ ପେ ଦୁକ୍‍ରେ ପେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN16_7","073_16_7","JHN","16","7","7","ମାତର୍‌ ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ନେଙ୍ଗ୍ ୱେଲାଆ ପେ ଆତ୍‍ଲା ମଙ୍ଗଲ୍‍ ଣ୍ଡିଙ୍ଗ୍‍ଏ । ଡାଗ୍ଲା ନେଙ୍ଗ୍ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ନେଙ୍ଗ୍ ପେଡାଗ୍ରା ମୁଇଙ୍ଗ୍ ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେକେ ବେମ୍ୱିଏ । ଜଦି ନେଙ୍ଗ୍ ନ୍ନାୱେ ତେଲା ସାଇଜ୍ୟ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଆପାଙ୍ଗ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN16_8","073_16_8","JHN","16","8","8","ମେଁ ପାଙ୍ଗ୍‌ଚେ ପାପ୍ ଦାର୍‍ମିକ୍‍ ସାମୁଆଁ ବାରି ଇସ୍‌ପର୍‌ନେ ନ୍ୟାୟ୍ ବିଚାର୍ ସାମୁଆଁରେ ଆକେନ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ରେମୁଆଁଇଂକେ ଆମ୍ୟା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_9","073_16_9","JHN","16","9","9","ମେଁ ଆତର୍‍ସା ବିଃ ଜେ ନେଙ୍ଗ୍‍ନ୍ନିଆ ବିସ୍‌ବାସ୍ ଆଡିଙ୍ଗ୍‍ନେ ଆଃ ପାପ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN16_10","073_16_10","JHN","16","10","10","ନେଙ୍ଗ୍ ଆବାଡାଗ୍ରା ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ପେଇଂ ଆନେଙ୍ଗ୍ ବାରି ପେକେ ଣ୍ଡୁ; ଆକେନ୍‍ ନେଙ୍ଗ୍‌ନେ ଦରମ୍ ସାମୁଆଁରେ ଆମ୍ୟା ବିଃ ଣ୍ଡିଙ୍ଗ୍‍କେ; ");
INSERT INTO gaq_vpl VALUES ("JN16_11","073_16_11","JHN","16","11","11","ଆକେନ୍‍ ମଞ୍ଚ୍‌ପୁର୍‌କେ ସାସନ୍‍ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଦସି ଡିଙ୍ଗ୍‌ଲେକେ ଆକ୍‌ବାନ୍ ଇସ୍‌ପର୍ ନ୍ୟାୟ୍‍ ବିଚାର୍ ପ୍ରକାସ୍‍ ବାଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN16_12","073_16_12","JHN","16","12","12","“ଆପେକେ ନେଙ୍ଗ୍‌ନେ ବାରି ଗ୍ଲୁଏ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ଲେଃକେ ମାତର୍‌ ଏବେ ଆତେନ୍‌ ସାପା ପେଇଂ ସାମ୍ୱାଲେ ପେୟାଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN16_13","073_16_13","JHN","16","13","13","ମାତର୍‌ ସତ୍ୟମୟ ଆତ୍ମା ପାଙ୍ଗ୍‌ଲା ମେଁ ସାପା ସତ୍‍ ସାମୁଆଁରେ ଦ୍ରିଗ୍‌ନ୍‌ସା ବପୁ ବିଏ । ମେଁ ନିଜେନେ ଅଦିକାର୍ ବପୁରେ ମେଃଡିଗ୍ ଆବାସଙ୍ଗ୍‍ ଣ୍ଡୁ । ଇସ୍‌ପର୍‌ବାନ୍ ମେଁ ମେଁନେ ଅଁଲେଃକେ ଅଃତେନ୍‍ ଆଃ ମେଁ ଆତ୍ନାଏ । ଜା ସାପା ଗଟେନେ ୱେଡିଙ୍ଗ୍‍କେ ମେଁ ଆପେକେ ଆମ୍ୟା ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_14","073_16_14","JHN","16","14","14","ମେଁ ଆନେଙ୍ଗ୍ ଗୌରବ୍‍ ଆଡିଙ୍ଗ୍‌ଏ ଡାଗ୍ଲା ନେଙ୍ଗ୍‍ବାନ୍‍ ସାପା ସାମୁଆଁ ମ୍ୟାଚେ ମେଁ ଆତେନ୍‌ ପେଡାଗ୍ରା ଆମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_15","073_16_15","JHN","16","15","15","ଜା ସାପା ନେଙ୍ଗ୍ ଆବାନେ ଆତେନ୍‌ ସାପା ନେଙ୍ଗ୍‌ନେ ତେସା ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‍ମ୍ୱକେ ନେଙ୍ଗ୍‍ବାନ୍‍ ସାପା ସାମୁଆଁ ଡୁଙ୍ଗ୍‍ୱେଚେ ମେଁ ଆମ୍ୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_16","073_16_16","JHN","16","16","16","“ଇତୁଡ଼ା ବେଲା ଇଡ଼ିଙ୍ଗ୍ ପେଇଂ ଆନେଙ୍ଗ୍‌କେ ବାରି କିକେ ପେୟା ଣ୍ଡୁ ମାତର୍‌ ବାରି ଉଡ଼ି ଦିନା ଇଡ଼ିଙ୍ଗ୍ ଆନେଙ୍ଗ୍ ପେକେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_17","073_16_17","JHN","16","17","17","ସିସ୍‍ଇଂବାନ୍‍ ଉଡ଼ିରୁଆ ମେଇଂମେଇଂ ବିତ୍ରେ ସାଲ୍ୟାକୁ ଆର୍‌କେ “ଆକେନ୍‍ ଅର୍‌ତ ମେଁନେ ? ମେଁ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଇତୁଡ଼ା ବେଲା ଇଡ଼ିଙ୍ଗ୍ ନେ ଆମେକେ କେନେୟା ଣ୍ଡୁ ବାରି ଉଡ଼ି ଦିନା ଇଡ଼ିଙ୍ଗ୍ ନେଃ ଆମେକେ କେୟା ଡିଙ୍ଗ୍‌ଏ । ବାରି ମେଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ମେଁ ମେଁନେ ଆବାନ୍ନିଆ ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_18","073_16_18","JHN","16","18","18","ଇଃତୁଡ଼ା ବେଲା ଆକେନ୍‍ ଅର୍‌ତ ମେଁନେ ? ମେଁ ମେଁନେ ବାଲିର୍‍ଡିଙ୍ଗ୍‌କେ ବୁଜେ ୟାଆଡିଂକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_19","073_16_19","JHN","16","19","19","ସିସ୍‍ଇଂ ଆମେକେ ସାଲ୍ୟାକୁ ଇକ୍‌ଚା ଡିଙ୍ଗ୍‌ନେ ମ୍ୟାଚେ ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ମ୍ୱାସଙ୍ଗ୍‍କେ ଇତୁଡ଼ା ବେଲା ଇଡ଼ିଙ୍ଗ୍ ପେଇଂ ଆନେଙ୍ଗ୍‌କେ କେପେୟା ଣ୍ଡୁ ମାତର୍‌ ଉଡ଼ି ଦିନା ଇଡ଼ିଙ୍ଗ୍ ଆନେଙ୍ଗ୍ ବାରି ପେକେଏ । ଆକେନ୍‍ ସାମୁଆଁରେ ପେଇଂ ବାଲିର୍‌ବାତା ଡିଂପେଡିଂଗେ ଣ୍ଡୁ କି ? ");
INSERT INTO gaq_vpl VALUES ("JN16_20","073_16_20","JHN","16","20","20","ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ, ପେଇଂ ପେଅଃଏ ବାରି ଏତେ ଏତେଚେ ପେଅଃଏ ମାତର୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଏ । ପେ ଦୁକ୍ ପେଡିଙ୍ଗ୍ ମାତର୍‌ ପେନେ ଦୁକ୍ ସାର୍ଦାରେ ବଦ୍‌ଲେ ୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_21","073_16_21","JHN","16","21","21","ମୁଇଙ୍ଗ୍ ସାପା ଉଂ ସେଲାମ୍ବୁଏଅ ମେଁନେ ଣ୍ଡିଆ କୁମାନେ ବେଲା ପିଙ୍ଗ୍‍ଚାକ୍ନେ ମ୍ୟାଚେ ତାନ୍ଦ୍ରା ଡିଙ୍ଗ୍‍ମ୍ୟାକେ; ମାତର୍‌ ଚିର୍‍ଲାଅ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲା ମେଁ ମେଁନେ କସ୍‌ଟ ଆବ ବିଏ । ବାରି ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ଚିର୍‍ଲାଅ ଜନମ୍ ପାଙ୍ଗ୍‌ନେ କେଚେ ମେଁ ଜାବର୍‌ ସାର୍ଦା ଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_22","073_16_22","JHN","16","22","22","ପେନେ ଅବସ୍ତା ଦେତ୍‌ରକମ୍ ଗଟେଏ । ଏବେ ପେ ଦୁକ୍‍ରେ ପେଲେକେ ମାତର୍‌ ଜିଆଃ ବାରି ମୁଇଂତର୍ ଆପେକେ ନେଙ୍ଗ୍ ଙ୍କେଏ ଆରି ଆତେନ୍‌‌ ବେଲା ପେନେ ଜିବନ୍ ସାର୍ଦାରେ ବର୍ତି ଡିଙ୍ଗ୍‌ୱେଏ । ଆତେନ୍‌ ସାର୍ଦା ପେବାନ୍ ଜାଡିଗ୍ ରାଃଚେ ଡୁଂଡ ଆୟା ଆର୍‌ଏ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_23","073_16_23","JHN","16","23","23","“ଆତେନ୍‌ ଦିନା ପାଙ୍ଗ୍‌ଲା ନେଙ୍ଗ୍‍ବାନ୍‍ ଆପେକେ ବାରି ମେଃଡିଗ୍ ସାଲିଆ ନ୍‌ସା ଆପଡ଼େ ଣ୍ଡୁ । ସତ୍ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ ନେଙ୍ଗ୍ ମ୍ନିରେ ଆବାକେ ଜା ସାପା ପେସାଲ୍ୟାଃଏ ମେଁ ଆତେନ୍‌ ବିଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_24","073_16_24","JHN","16","24","24","ଏଃଜାକ ପେଇଂ ନେଙ୍ଗ୍ ମ୍ନିରେ ମେଃଡିଗ୍ ପେସାଲ୍ୟାକେ ଣ୍ଡୁ । ଏଃକେବାନ୍ ସାଲ୍ୟାପା ଡିଲା ଡିଗ୍ ପେବାଏ ବାରି ପେଇଂ କ୍ଲିଗ୍‌ଡା ବାବ୍‌ରେ ସାର୍ଦା ପେଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_25","073_16_25","JHN","16","25","25","“ନେଙ୍ଗ୍ ଆପେକେ ଆକେନ୍‍ ସାପା ସାମୁଆଁ ଅର୍‌ତ ଆଦ୍ରିଗ୍‍ଚେ ବାଲିର୍‍ଣ୍ଡିଂକେ । ମାତର୍‌ ଦେକ୍ ରକମ୍ ବେଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଉଡ଼ିବେଲା ବାରି ଅର୍‌ତରେ ବେବ‍ଆର୍ ମାଡିଙ୍ଗ୍‌ଚେ ଇସ୍‌ପର୍‌ନେ ସାପା ସାମୁଆଁ ନେଙ୍ଗ୍ ଡିରକମ୍ ମେଇଂ ବୁଜେ ୟାଆର୍‌ଏ ଦେତ୍ ରକମ୍ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ଚେ ନ୍ନାମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN16_26","073_16_26","JHN","16","26","26","ଆତେନ୍‌ ଦିନା ପାଙ୍ଗ୍‌ଲା ପେ ନେଙ୍ଗ୍ ମ୍ନିରେ ଇସ୍‌ପର୍‌କେ ପେସାଲ୍ୟାଃଏ । ଆତେନ୍‌ ବେଲା ପେବାନ୍ ଆନେଙ୍ଗ୍‌କେ ଆମେକେ ବାରି ମେଃଡିଗ୍ ବାଲିର୍‍ ନ୍‍ସା ଆପଡ଼େ ଣ୍ଡୁ ");
INSERT INTO gaq_vpl VALUES ("JN16_27","073_16_27","JHN","16","27","27","ଡାଗ୍ଲା ଆବା ନିଜେ ଆପେକେ ବଲ୍ ବାମ୍ୟାକେ । ମେଁ ଆପେକେ ବଲ୍ ବାଡିଙ୍ଗ୍‌କେ ମାତର୍‌ ପେଇଂ ଆନେଙ୍ଗ୍‌କେ ବଲ୍ ବାପେଡିଙ୍ଗ୍‌କେ ବାରି ନେଙ୍ଗ୍ ଇସ୍‌ପର୍ ଡାଗ୍ରାବାନ୍‍ ପାଙ୍ଗ୍‍ଲେକେ ଡାଗ୍‌ଚେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN16_28","073_16_28","JHN","16","28","28","ନେଙ୍ଗ୍ ଇସ୍‌ପର୍‌ନ୍ନିଆବାନ୍‍ ମଞ୍ଚ୍‌ପୁର୍‌ ପାଙ୍ଗ୍‍ନ୍ଲେକେ; ବାରି ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌କେ ଜିଆଃ ଆନ୍ତାର୍‍ଚେ ଆବାଡାଗ୍ରା ଆଣ୍ଡେ ନେୱେପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_29","073_16_29","JHN","16","29","29","ଆକେନ୍ ବ୍ନାଲିର୍ ଅଁଚେ ସିସ୍‍ଇଂ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନାଁ ତ ଏବେ ଅର୍‌ତ ମାରାଦ୍ରିଗ୍‍ଚେ ବୁଜେ ୟାକ୍ନେ ରକମ୍ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN16_30","073_16_30","JHN","16","30","30","ଏବେ ନେ ନେମ୍ୟାଃକେ ଜେ ନାନେ ସାପା ବ୍ନାଲିର୍ ମ୍ୟା ନାଲେଃକେ । ଆନାକେ ବାରି ଜା ଜାଣ୍ଡେ ପ୍ରସ୍‌ନ ସାଲ୍ୟାକୁ ଦର୍‌କାର୍ ଣ୍ଡୁ । ଆକ୍‌ବାନ୍ ନେନେ କ୍ଲିଗ୍‌ଡା ବିସ୍‌ବାସ୍ ଲାଗେଡିଙ୍ଗ୍‍କେ ନାଁ ଇସ୍‌ପର୍‌ନ୍ନିଆ ବାନ୍ ପାଙ୍ଗ୍‍ନାଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN16_31","073_16_31","JHN","16","31","31","ଜିସୁ ଆମେଇଂକେ ଉତର୍ ବିକେ “ଏକେ ପେଇଂନେ ବିସ୍‌ବାସ୍ ଡିଂକ୍ଲେ ? ");
INSERT INTO gaq_vpl VALUES ("JN16_32","073_16_32","JHN","16","32","32","ବେଲା ପାଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ, ଏବେ ଆତେନ୍‌ ବେଲା ପିଙ୍ଗ୍‌ଚାକେ ଉଡ଼ିବେଲା ପେ ସାପାରେ ଚିନ୍‍ ଚତର୍‍ ଡିଙ୍ଗ୍‌ଚେ ସାପାରେ ନିଜର୍ ନିଜର୍ ଡୁଆ ଲାଗ୍‍ପେଡଏ ବାରି ନେଙ୍ଗ୍ ମୁଇଂଜା ଡିଙ୍ଗ୍‌ଚେ ନ୍ଲେଏ । ମାତର୍‌ ସତ୍‍ରେ ନେଙ୍ଗ୍ ମୁଇଂଜା ଣ୍ଡୁ, ଡାଗ୍ଲା ଆବା ନେଙ୍ଗ୍ ଏତେ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN16_33","073_16_33","JHN","16","33","33","ଆକେନ୍ ସାମୁଆଁ ଆପେକେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ଡିରକମ୍‍ କି ନେଙ୍ଗ୍ ଏତେ କୁଡ଼େ ଲେଃଚେ ପେ ମନ୍‍ଅରିଆ ସାନ୍ତି ମନେ ପେଡିଙ୍ଗ୍‌ଏ । ମଞ୍ଚ୍‌ପୁର୍‌ ଆପେକେ କସ୍‌ଟ ବିଏ; ତେଲାଡିଗ୍‍ ସାଆସ୍ ସାଃପା ଡାଗ୍ଲା ନେଙ୍ଗ୍ ମଞ୍ଚ୍‌ପୁର୍‌କେ ଜିତେ ନ୍ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN17_1","073_17_1","JHN","17","1","1","ଆକେନ୍‍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଆଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ କିତଂଇନି ପାକା ତାଣ୍ଡେଚେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌କେ; “ଆବା ନେଙ୍ଗ୍‌ନେ ବେଲା ପିଙ୍ଗ୍‌ଚାକେ । ନାନେ ନାଉଂକେ ମ୍ନାଃ ଆଡିଙ୍ଗ୍ । ତେଲା ନାଉଂ ଡିଗ୍ ଆନାକେ ମ୍ନାଃ ଆଡିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("JN17_2","073_17_2","JHN","17","2","2","ନାଁ ଆମେକେ ସାପା ନର୍‍ ଜାତି ଆଡ଼ାତ୍ରା ଅଦିକାର୍ ବିନାବକେ । ଆରି ଜାଣ୍ଡେଇଂ ମେଁନେ ନ୍ତିନ୍ନିଆ ଅପେଃ ବିନାବକେ ଆମେଇଂକେ ମାଡାନେ ଜିବନ୍ ଦାନ୍ ବିନ୍‌ସା ଆମେକେ ବପୁ ବିନାବକେ ");
INSERT INTO gaq_vpl VALUES ("JN17_3","073_17_3","JHN","17","3","3","ଆରି ମୁଇଙ୍ଗ୍ ମାତର୍‌ ସତ୍ ଇସ୍‌ପର୍ ଜେ ନା, ଆନାକେ ବାରି ନାନେ ପ୍ରେରିତ୍‌ ଜିସୁ କିସ୍‌ଟକେ ମ୍ୟାନେ ଆଃ ମାଡାନେ ଜିବନ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN17_4","073_17_4","JHN","17","4","4","ନାନେ ଆନେଙ୍ଗ୍‌କେ ଆଣ୍ଡିନେ କାମ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ବିନାବକେ ଆତେନ୍‌ ନେଙ୍ଗ୍ ଆଡାଚେ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ଆନାକେ ମ୍ନାଃ ଆଡିଙ୍ଗ୍‍ମ୍ୱକେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_5","073_17_5","JHN","17","5","5","ଆବା ମଞ୍ଚ୍‌ପୁର୍‌କେ ତିଆର୍ ଡିଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ ନାନେ ଏତେ ନେଙ୍ଗ୍‌ନେ ଆଣ୍ଡିନେ ଗୌରବ୍‍ ଲେଃଗେ ଏବେ ନାଁ ନାଲେକ୍ନେ ବେଲା ଆତେନ୍‌ ଗୌରବ୍‍ ଆନେଙ୍ଗ୍‌କେ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("JN17_6","073_17_6","JHN","17","6","6","ଆକେନ୍‍ ମଞ୍ଚ୍‌ପୁର୍‌ ଡାଗ୍ରା ଜାଣ୍ଡେଇଂକେ ନାଁ ନେଙ୍ଗ୍ ନ୍ତିନ୍ନିଆ ସର୍‍ପେ ନାବିକେ, ନେଙ୍ଗ୍ ମେଁଇଙ୍ଗ୍‌ନେ ଡାଗ୍ରା ନାଁନେ ମ୍ନି ଆମ୍ୟାମ୍ୱକେ । ମେଇଂ ନାଅରିଆ ଲେଃଗେ ବାରି ନାଁ ଆମେଇଂକେ ଆନେଙ୍ଗ୍‌କେ ଦାନ୍ ନାବିକେ ବାରି ମେଇଙ୍ଗ୍ ନାନେ ବ୍ନାଲିର୍ ପାଲେ ବଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_7","073_17_7","JHN","17","7","7","ନାଁ ଆନେଙ୍ଗ୍‌କେ ମେଃ ମେଃନେ ଦାନ୍‌ ବିଃନାବକେ, ଆତେନ୍‌ ସାପା ନାଁ ବାନ୍ ପାଙ୍ଗ୍‌ଲେକେ ଆକେନ୍ ମେଇଂ ଏବେ ଦ୍ରିଗ୍ ଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_8","073_17_8","JHN","17","8","8","ନାଁ ଆନେଙ୍ଗ୍‌କେ ବିନାବକ୍ନେ ସାମୁଆଁ ନେଙ୍ଗ୍ ଆମେଇଂକେ ବିଃମ୍ୱକେ ଆରି ମେଇଂ ଆମେକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ନେଙ୍ଗ୍ ଜେ ନାନେବାନ୍ ପାଙ୍ଗ୍‍ଲେକେ ଆରି ନାଲେ ଆନେଙ୍ଗ୍‌କେ ବେନାବକେ ଆକେନ୍‍ ସାମୁଆଁ ମେଇଙ୍ଗ୍ ନିମାଣ୍ଡା ବାବ୍‌ରେ ମ୍ୟାଚେ ଆତ୍‌ବାନ୍ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_9","073_17_9","JHN","17","9","9","“ନେଙ୍ଗ୍ ମେଇଂ ନ୍‍ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍‍ସା ନେଙ୍ଗ୍ ପାର୍‌ତନା ଡିଙ୍ଗ୍ ନେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ମାତର୍‌ ଜାଣ୍ଡେଇଂ ନାନେ ଆରି ଜାଣ୍ଡେଇଂକେ ନେଙ୍ଗ୍ ନ୍ତିନିଆ ବିନାବକେ ମେଇଂ ନ୍‌ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_10","073_17_10","JHN","17","10","10","ନେଙ୍ଗ୍‌ନେ ଜା ସାପା ଲେଃକେ ସାପା ନାନେ ଆରି ନାନେ ଜା ସାପା ଲେଃକେ ସାପା ନେଙ୍ଗ୍‌ନେ ଆରି କିମେଇଂବାନ୍‍ ନେଙ୍ଗ୍ ମ୍ନାଃ । ");
INSERT INTO gaq_vpl VALUES ("JN17_11","073_17_11","JHN","17","11","11","ଏବେ ନେଙ୍ଗ୍ ପେଡାଗ୍ରା ପାଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ନେଙ୍ଗ୍ ଆରି ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ଲେଃ ନେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ । ମାତର୍‌ କିମେଇଂ ଲେଃଡିଂକେ । ପବିତ୍ର ଆବା ! ଆଜାକେ ନାଁ ନ୍ତିନ୍ନିଆ ଅପେଃ ବିନାବକେ, ନାଁ ଆନେଙ୍ଗ୍‌କେ ବିନାବକ୍ନେ ମ୍ନିନେ ବପୁରେ ଆମେଇଂକେ ରକ୍ୟା ଡିଙ୍ଗ୍ । ନାଁ ଆରି ନେଙ୍ଗ୍ ଡିରକମ୍ ମୁଇଙ୍ଗ୍ ଆମେଇଂକେ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ମୁଇଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ନ୍‌ସା ସାଇଜ୍ୟ ଡିଙ୍ଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN17_12","073_17_12","JHN","17","12","12","ମେଇଂ ଏତେ ଲେଃନେବେଲା ନାନେ ମ୍ନିନେ ବପୁରେ ନେଙ୍ଗ୍ ଆମେଇଂକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ମ୍ୱଗେ । ସାସ୍ତର୍‌ନେ ବ୍ନାଲିର୍ ଇସାବ୍‌ରେ ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ଜାନେ ବୁଡ଼େ ୱେନେଲେଗେ ଆମେ ଆନ୍‌ତାର୍‌ଚେ ବାରି ଆଜାକେ ଡିଗ୍ ନେଙ୍ଗ୍ ନ୍ନାରାଃଗୁଏକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN17_13","073_17_13","JHN","17","13","13","ଏବେ ନାନେଡାଗ୍ରା ପାଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ମାତର୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ ନ୍ନିଆ ଲେଃଜାକ ନେଙ୍ଗ୍‌ନେ ସାର୍ଦାରେ ମେଁଇଙ୍ଗ୍‌ନେ ଜିବନ୍‍କେ ପୁର୍ତି ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ନେଙ୍ଗ୍ ଏକେ ଆକେନ୍‍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‌ଣ୍ଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("JN17_14","073_17_14","JHN","17","14","14","ନେଙ୍ଗ୍ ଆମେଇଂକେ ନାନେ ବ୍ନାଲିର୍ ଆଃଅଁମ୍ୱକେ । ଆତେନ୍‌‌ସା ଆମେଇଂକେ ମଞ୍ଚ୍‌ପୁର୍‌ ଆଂକାର୍ ଡିଙ୍ଗ୍‍ମ୍ୱକେ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଡିରକମ୍ ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଣ୍ଡୁ ମେଇଂ ଡିଗ୍‍ ଣ୍ଡୁ ");
INSERT INTO gaq_vpl VALUES ("JN17_15","073_17_15","JHN","17","15","15","ଆମେଇଂକେ ମଞ୍ଚ୍‌ପୁର୍‌ ବାନ୍ ଆତାର୍‌ଚେ ଡୁଙ୍ଗ୍‍ୱେନ୍‍ସା ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ନେଡିଙ୍ଗ୍‌କେ ଣ୍ତୁ ମାତର୍‌ ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ସ‍ଏତାନ୍‌ନେ ପାନ୍ଦ୍‍ବାନ୍‍ ଆମେଇଂକେ ରକ୍ୟା ଡିଗ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN17_16","073_17_16","JHN","17","16","16","ନେଙ୍ଗ୍ ଡିରକମ୍ ଏନ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଣ୍ଡୁ ମେଇଙ୍ଗ୍ ଡିଗ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN17_17","073_17_17","JHN","17","17","17","ଆତେନ୍‌ ସତ୍‍ବାନ୍‍ ଆମେଇଂକେ ପବିତ୍ର ଆଃଡିଂ । ଡାଗ୍ଲା ନାନେ ବ୍ନାଲିର୍‍ ଆଃ ସତ୍ । ");
INSERT INTO gaq_vpl VALUES ("JN17_18","073_17_18","JHN","17","18","18","ନାଁ ଆନେଙ୍ଗ୍‌କେ ଡିରକମ୍ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ବେନାବକେ ନେଙ୍ଗ୍‍ ଡିଗ୍‍ ଆମେଇଂକେ ମଞ୍ଚ୍‌ପୁର୍‌ଡାଗ୍ରା ବେମ୍ୱକେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_19","073_17_19","JHN","17","19","19","ମେଇଙ୍ଗ୍ ଡିଃଡି କି ଆତେନ୍‌ ସତ୍‍ବାନ୍‍ ପବିତ୍ର ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ଆତେନ୍‌‌ସା ନେଙ୍ଗ୍ ନିଜେନେ ଜିବନ୍‍କେ ବଲି ବିଃଣ୍ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN17_20","073_17_20","JHN","17","20","20","“ନେଙ୍ଗ୍ ମାତର୍‌ ମେଇଂ ନ୍‍ସା ଏନ୍‌ ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ ଣ୍ଡୁ । ଜାଣ୍ଡେଇଂ ମେଁଇଙ୍ଗ୍‌ନେ ବ୍ନାଲିର୍ ଅଁଚେ ନେଙ୍ଗ୍‍ନ୍ନିଆ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_21","073_17_21","JHN","17","21","21","ମେଁ ସାପାରେ ନ୍‍ସା ଡିଗ୍ ପାର୍‍ତନା ଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ । ମେଇଂ ସାପାରେ ମୁଇଙ୍ଗ୍ ଡିଙ୍ଗ୍‌ଲେ ଏନ୍‌ ନେଙ୍ଗ୍‌ନେ ପାର୍‍ତନା । ଆବା ନାଁ ଡିରକମ୍ ନେଙ୍ଗ୍‍ନ୍ନିଆ ଆରି ନେଙ୍ଗ୍ ନାଁନ୍ନିଆ ନ୍ଲେକେ ଦେତ୍‌ରକମ୍ ମେଇଂ ନେନ୍ନିଆ ଲେଃଲେ । ଆକ୍‌ମେଁ ନ୍‌ସା ମଞ୍ଚ୍‌ପୁର୍‌ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‍ଏ ଜେ ନାଁ ଆନେଙ୍ଗ୍‌କେ ବେନାବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_22","073_17_22","JHN","17","22","22","ଆମେଇଂକେ ନେନେ ସୁଗୁଆ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ନାଁ ଆନେଙ୍ଗ୍‌କେ ଆଣ୍ଡିନେ ଗୌରବ୍‍ ବିନାବକେ ଆତେନ୍‌ ନେଙ୍ଗ୍ ଆମେଇଂକେ ବିମ୍ବକେ ! ");
INSERT INTO gaq_vpl VALUES ("JN17_23","073_17_23","JHN","17","23","23","ନାଁ ଡିରକମ୍ ନେଙ୍ଗ୍‍ନ୍ନିଆ ନେଙ୍ଗ୍‍ ଦେତ୍‍ରକମ୍‍ ମେଁଇଙ୍ଗ୍‌ନ୍ନିଆ ନ୍ଲେଏ । ତେଲା ମେଇଂ କ୍ଲିଗ୍‌ଡା ବାବ୍‌ରେ ମୁଇଙ୍ଗ୍ ଡିଙ୍ଗ୍ ଆର୍‌ଏ ବାରି ମଞ୍ଚ୍‌ପୁର୍‌ ମ୍ୟାଏ ଜେ ନାଁ ଆନେଙ୍ଗ୍‌କେ ବେନାବକେ ଆରି ଆନେଙ୍ଗ୍‌କେ ଡିରକମ୍ ଆଲାଦ୍ ଡିଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ ଆମେଇଂକେ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ଆଲାଦ୍ ଡିଙ୍ଗ୍‌ନାବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN17_24","073_17_24","JHN","17","24","24","“ଆବା ! ନାଁ ଆମେଇଂକେ ନେଙ୍ଗ୍ ନ୍ତିନ୍ନିଆ ବିନାବକେ ନେ ଚାଏଁ ନେଡିଙ୍ଗ୍‌କେ; ଆଣ୍ଡିନ୍ନିଆ ନେଙ୍ଗ୍ ନ୍ଲେଏ, ମେଇଂ ଆତ୍‌ଅରିଆ ନେଙ୍ଗ୍ ଏତେ ଲେଃଚେ ନା ଆନେଙ୍ଗ୍‌କେ ବିନାବକ୍ନେ ଗୌରବ୍‍ କେଲେ, ଡାଗ୍ଲା ମଞ୍ଚ୍‌ପୁର୍‌ ତିଆର୍ ଡିଙ୍ଗ୍‌ନେ ସେନୁଗ୍‍ଆ ନାଁ ଆନିଂକେ ଆଲାଦ୍ ଡିଙ୍ଗ୍ ନାବକେ । ");
INSERT INTO gaq_vpl VALUES ("JN17_25","073_17_25","JHN","17","25","25","ଏ ଦାର୍‍ମିକ୍‍ ଆବା ମଞ୍ଚ୍‌ପୁର୍‌ ଆନାକେ ଆମ୍ୟାକେ ଣ୍ଡୁ ମାତର୍‌ ନେଙ୍ଗ୍ ଆନାକେ ମ୍ୟାନ୍ଲେକେ; ଆରି ନାଁ ଜେ ଆନେଙ୍ଗ୍‌କେ ବେନାବକେ ଆତେନ୍‌ କିମେଇଂ ମ୍ୟାଲେକେ; ");
INSERT INTO gaq_vpl VALUES ("JN17_26","073_17_26","JHN","17","26","26","ଆରି ନା ଆନିଂକେ ଆଣ୍ଡିନେ ଆଲାଦ୍‌ରେ ଆଲାଦ୍ ନାଡିଙ୍ଗ୍‍ ଆତେନ୍‌ ଡିରକମ୍ ମେଇଂ ଡାଗ୍ରା ଲେଃଏ ଆରି ନେଙ୍ଗ୍ ମେଁଇଙ୍ଗ୍‌ନ୍ନିଆ ନ୍ଲେଏ ଆକେନ୍‌ସା ନେଙ୍ଗ୍ ଆମେଇଂକେ ନାନେ ମ୍ନି ଆମ୍ୟା ମ୍ୱକେ ବାରି ନ୍ନାଃମ୍ୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_1","073_18_1","JHN","18","1","1","ଆକେନ୍ ପାର୍‍ତନା ଆଡାଚେ ଜିସୁ ମେଁନେ ସିସ୍‍ଇଂ ଏତେ କିଦ୍ରୋଣ ଜଲା ଇନୁମେତା ତାର୍ ୱେଆର୍‌କେ । ଆତ୍‌ଅରିଆ ମୁଇଙ୍ଗ୍ ଡୁଗ୍‌ଡି ଲେଃଗେ ବାରି ମେଁ ଆରି ମେଁନେ ସିସ୍‍ଇଂ ଆତ୍‍ଅରିଆ ଗାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_2","073_18_2","JHN","18","2","2","ମୁଡ଼ି ଜିଉଦା ଆମେକେ ବିରଦ୍ ରେମୁଆଁଇଂନେ ନ୍ତିନ୍ନିଆ ଅପେଃ ବଗେ ମେଁ ଡିଗ୍ ଆତେନ୍‌ ଜାଗା ମ୍ୟାଲେଃଗେ ଡାଗ୍ଲା ଜିସୁ ଗ୍ଲୁଏତର୍‍ ମେଁନେ ସିସ୍‍ଇଂ ଏତେ ଆତେନ୍‌ ଜାଗା ଡାଗ୍ରା ୱେଆର୍‍ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_3","073_18_3","JHN","18","3","3","ତେସା, ଜିଉଦା ମୁଇଙ୍ଗ୍ ମାନ୍ଦା ରମିୟ ସନ୍ୟ ବାରି ମ୍ନା ପୁଜାରି ବାରି ଫାରୁଶୀଇଂ ବେବଗ୍ନେ ମନ୍ଦିର୍‌ନ୍ନିଆ ଉର୍‌ଣ୍ଡ୍ରେଇଂକେ ସାଚେ ଆତ୍‌ଅରିଆ ପିଙ୍ଗ୍‍ଚାଆର୍କେ । ମେଇଂ ଅସ୍ତ୍ରସସ୍ତ୍ର ଆଃବାଲେଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_4","073_18_4","JHN","18","4","4","ମେଁ ଆଡ଼ାତ୍ରା ମେଁନେ ଗଟେଏ ଜିସୁ ସାପା ମ୍ୟାଲେଃଗେ । ତେସା ମେଁ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାକୁକେ “ପେଇଂ ଆଜାକେ ତୁର୍‌ପେଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_5","073_18_5","JHN","18","5","5","ମେଇଂ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ନାଜରିତିୟ ଜିସୁକେ ।” ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍‍ଆ ଆତେନ୍‌ ରେମୁଆଁ ।” ବିସ୍‌ବାସ୍‌ଗାତ୍ ଜିଉଦା ମେଁ ଏତେ ତୁଆଁ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_6","073_18_6","JHN","18","6","6","“ନେଙ୍ଗ୍ ଆତେନ୍‌ ରେମୁଆଁ” ଡାଗ୍‌ଚେ ଜିସୁ ବାଲିର୍‍ନେ ଦାପ୍ରେ ମେଇଂ ପ୍ଲାପାକା ଗୁଚେଚେ ତୁବଃନ୍ନିଆ ଲଃ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_7","073_18_7","JHN","18","7","7","ଜିସୁ ବାର୍‌ମୁଇଂତର୍‍ ସାଲ୍ୟାକୁକେ “ପେଇଂ ଆଜାକେ ତୁର୍‌ପେଡିଙ୍ଗ୍‌କେ ?” ମେଇଂ ଉତର୍ ବିକେ । “ନାଜରିତିୟ ଜିସୁକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_8","073_18_8","JHN","18","8","8","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌ ଆଡାମ୍ୱକେ ନେଙ୍ଗ୍ ଆତେନ୍‌ ରେମୁଆଁ । ଜଦି ପେଇଂ ଆନେଙ୍ଗ୍‌କେ ତୁର୍‌ପେଡିଙ୍ଗ୍‌କେ ତେଲା ଆକ୍‌ମେଇଂ ଆନ୍‍ତାର୍‍ବି । ");
INSERT INTO gaq_vpl VALUES ("JN18_9","073_18_9","JHN","18","9","9","ମୁଡ଼ି ରେମୁଆଁଇଂକେ ନାଁ ଆନେଙ୍ଗ୍ ବିନାବକେ ମେଁଇଙ୍ଗ୍‌ନେ ବିତ୍ରେ ମୁଇଂଜାକେ ଡିଗ୍ ନେଙ୍ଗ୍ ନ୍ନାଆରେକେ ଣ୍ଡୁ” ମେଁନେ ଆକେନ୍ ବ୍ନାଲିର୍ ପୁରନ୍‌ ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ମେଁ ଦେକ୍ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_10","073_18_10","JHN","18","10","10","ଶିମୋନ୍ ପିତର୍ ଡାଗ୍ରା ମୁଇଙ୍ଗ୍ କାଣ୍ଡା ଲେଃଗେ । ମେଁ ଆତେନ୍‌ ଜଗ୍‍ ଆତାର୍‌ଚେ ମ୍ନା ପୁଜାରିନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକାନେ ନ୍ଲୁଗ୍‍କେ ଗୁଆ ବିକେ । ଆତେନ୍‌ ଦାସ୍‌ନେ ମ୍ନି ମାଲ୍‌ଖ । ");
INSERT INTO gaq_vpl VALUES ("JN18_11","073_18_11","JHN","18","11","11","ଜିସୁ ପିତର୍‌କେ ବାସଙ୍ଗ୍‌କେ “କାଣ୍ଡା ବନେ କଲ୍‌ପାନିଆ କାଣ୍ଡା ବ । ନାଁ ମେଃନେ ବାବେ ନାଡିଙ୍ଗ୍‌କେ ଆବା ଇସ୍‌ପର୍ ଆନେଙ୍ଗ୍ ବିବକ୍ନେ ଆକେନ୍ ଦୁକ୍ ବଗେନେ ଙ୍କୁଇବାନ୍‍ ନେଙ୍ଗ୍ ନେଉଗ୍ ଣ୍ଡୁ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_12","073_18_12","JHN","18","12","12","ଆତ୍‍ ଅରିଆ ରୋମୀୟ ସନ୍ୟଇଂନେ ଦଲ୍‍ ମ୍ନା ସେନାପତି ଆରି ଇହୁଦୀ ଜାଗୁଆଲ୍‍ଇଂ ଜିସୁକେ ସାଚେ ଗାଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_13","073_18_13","JHN","18","13","13","ବାରି ପର୍‍ତୁମ୍‍ ଆମେକେ କୟାଫାନେ ମାମାଡ଼େ ହାନାନ୍ ଡାଗ୍ରା ଡୁଂୱେ ଆର୍‌କେ । ଡାଗ୍ଲା ଆତେନ୍‌ ମୁଆଁନେ ମ୍ନା ପୁଜାରି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_14","073_18_14","JHN","18","14","14","ରେମୁଆଁଇଂ ଆତ୍‍ଲା ମୁଇଂଜା ଗୁଏଚେ ମଙ୍ଗଲ୍‍ ଡାଗ୍‌ଚେ ଜିଉଦିଇଂକେ ଜେ ବାସଙ୍ଗ୍‌ ବଗେ କିମେ ଆତେନ୍‌ କୟାଫା । ");
INSERT INTO gaq_vpl VALUES ("JN18_15","073_18_15","JHN","18","15","15","ଶିମୋନ ପିତର୍ ଆରି ବାର୍‌ମୁଇଂଜା ସିସ୍‍ ଜିସୁନେ ପ୍ଲାପ୍ଲା ୱେଡିଙ୍ଗ୍‍ଗେ । ଆତେନ୍‌ ସିସ୍‍ ମ୍ନାଃ ପୁଜାରି ଏତେ ସ୍ନାମୁଆଁ ଲେଃଗେ ବାରି ଜିସୁ ଏତେ ମ୍ନା ପୁଜାରି ଡୁଆନେ ପ୍ଲେଡ଼ିଆ ବିତ୍ରେ ଗାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_16","073_18_16","JHN","18","16","16","ପିତର୍ ବାଜାର୍‍ନେ ର୍ଣ୍ଣସାଙ୍ଗ୍‍ନ୍ନିଆ ଲେଃୱେଗେ । ବାରି ମୁଇଙ୍ଗ୍ ସିସ୍‍ ମ୍ନାପୁଜାରିନେ ସ୍ନାମୁଁଆଃ ରେମୁଆଁ ଲେଃଗେ, ମେଁ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ଚେ ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ଡାଗ୍ରା ଲେଃକ୍ନେ ମୁଇଙ୍ଗ୍ ଚାକର୍‍ ରାନିକେ ବାସଙ୍ଗ୍‌ଚେ ପିତର୍‌କେ ପ୍ଲେଡ଼ିଆ ବିତ୍ରେ ଡୁଂପାଂଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_17","073_18_17","JHN","18","17","17","ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ଡାଗ୍ରା ଲେଃକ୍ନେ ଆତେନ୍‌ ଚାକର୍‌ବ‍ଏଃ ପିତର୍‌କେ ବାସଙ୍ଗ୍‌କେ “ନାଁ ମେଃନେ ଆତେନ୍‌ ରେମୁଆଁନେ ସିସ୍‍ଇଂ ବିତ୍ରେବାନ୍ ନାଁ ମୁଇଂଜା ଣ୍ଡୁ ?” ପିତର୍ ଅବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ ନେଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_18","073_18_18","JHN","18","18","18","ଆତେନ୍‌ ବେଲା ରାସଃ ଡିଂଡିଂଗେ ତେସା ଚାକର୍‌ ବାରି ଜାଗୁଆଲ୍‍ଇଂ ଏଲେଃସନ୍ନିଆ ସୁଆ ଆଡୁଆଚେ ମେଁନେ ପିତୁର୍‍ପାକା ତୁଆଁଚେ ନିଜ୍‍କେ ଉସୁମ୍‍ ଆଡିଂଆର୍‌ଡିଙ୍ଗ୍‌ଗେ । ପିତର୍ ଡିଗ୍ ମେଁ ଡାଗ୍ରା ତୁଆଁ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_19","073_18_19","JHN","18","19","19","ମ୍ନା ପୁଜାରି ଜିସୁକେ ମେଁନେ ସିକ୍ୟା ଆରି ସିସ୍ଇଂନେ ସାମୁଆଁରେ ପ୍ରସ୍‌ନ ସାଲ୍ୟାକୁକେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_20","073_18_20","JHN","18","20","20","ଜିସୁ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ କାଲାଆଃ ଦର୍‌ତନିନ୍ନିଆ ସାପାରେ ଡାଗ୍ରା କୁଲାକୁଲି ବାବ୍‌ରେ ସିକ୍ୟା ବିଃ ମ୍ୱକେ ମନ୍ଦିର୍‍ ଆରି ପାର୍‌ତନା ଡୁଆଇଂନ୍ନିଆ ରେମୁଆଁଇଂ ମୁଇଂତୁଗ୍ ରିସିଙ୍ଗ୍ ଲେଃକେଲା ନେଙ୍ଗ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ମ୍ୱକେ । ମେଃଡିଗ୍ ସାମୁଆଁ ନେଙ୍ଗ୍ ବୁଃଡିଚେ ନାବାସଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN18_21","073_18_21","JHN","18","21","21","ଆନେଙ୍ଗ୍ ମେସା ସାଲ୍ୟାକୁ ପେଡିଙ୍ଗ୍‌କେ ? ଜାଣ୍ଡେଇଂ ନେଙ୍ଗ୍ ସିକ୍ୟା ଅଁ ଲେଃଆର୍‌କେ; ଆମେଇଂକେ ସାଲ୍ୟାକୁ ନେଙ୍ଗ୍ ମେଃନେ ବାସଙ୍ଗ୍‍ମ୍ୱକେ, ମେଁଇଙ୍ଗ୍‌ନେ ବାନ୍ ପେଦ୍ରିଗ୍ଏ ମେଇଂ ମ୍ୟା ଲେଃଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_22","073_18_22","JHN","18","22","22","ଜିସୁ ଆକେନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ନେ ବେଲା ଜାଗୁଆଲ୍‍ଇଂବାନ୍‍ ବିତ୍ରେ ମୁଇଂଜା ଆମେକେ ଚାପ୍‍ଡ଼ା ବଗ୍‍ଚେ ବାସଙ୍ଗ୍‌କେ, “ନାନେ ଅଃତେନ୍‍ ସାହାସ୍ ! ମ୍ନା ପୁଜାରିକେ ଦେକ୍ ନାବାସଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_23","073_18_23","JHN","18","23","23","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍ ଜଦି ମେଃଡିଗ୍ ଦଦିଆ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ମ୍ୱଏ ଆତେନ୍‌ ସାପାରେନେ ସେନୁଗ୍‍ ବାସଙ୍ଗ୍‌ । ଜଦି ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗମ୍ୱଏ ତେଲା ଆନେଙ୍ଗ୍ ମେଁନ୍‌ସା ବଗ୍‍ପେଡିଙ୍ଗ୍‍ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_24","073_18_24","JHN","18","24","24","ଆକେନ୍ ଇଡ଼ିଙ୍ଗ୍ ହାନାନ୍ ଜିସୁକେ ଗାଗ୍‍ବକ୍ନେ ଅବସ୍ତାରେ ମ୍ନା ପୁଜାରି କୟାଫା ଡାଗ୍ରା ବେବିକେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_25","073_18_25","JHN","18","25","25","ପିତର୍ ସୁଆ ଡାଗ୍ରା ତୁଆଁଲେଃକ୍ନେ ବେଲା ଆତ୍‌ଅରିଆ ରିସିଙ୍ଗ୍‌ ଲେକ୍ନେ ରେମୁଆଁଇଂ ଆମେକେ ସାଲ୍ୟାକୁକେ “ନା ମେଃନେ ମେଁନେ ମୁଇଙ୍ଗ୍ ସିସ୍‍ ଣ୍ଡୁ ?” ପିତର୍ ଅବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ ନେଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_26","073_18_26","JHN","18","26","26","ପିତର୍ ମ୍ନା ପୁଜାରିନେ ମୁଡ଼ି ଚାକର୍‌ନେ ନ୍ଲୁଗ୍‍ ସିତଗ୍‍ ବଗେ ମେଁନେ ମୁଇଙ୍ଗ୍ ନିଜର୍‍ ରେମୁଆଁ ବାସଙ୍ଗ୍‍କେ “ଆତେନ୍‌ ଡୁଗ୍‌ଡି ଡାଗ୍ରା ନେଙ୍ଗ୍ ଆନାକେ ମେଁ ଏତେ ନେକେକେ ଡାଗ୍‌ଚେ ବାବେ ନାଡିଙ୍ଗ୍‌କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_27","073_18_27","JHN","18","27","27","ପିତର୍ ବାରି ମୁଇଂତର୍ ଅବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଣ୍ଡୁ” ନେଙ୍ଗ୍ ଣ୍ଡୁ । ଆତେନ୍‌ ଦାପ୍ରେ ଗିସେଙ୍ଗ୍‍ ସକେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_28","073_18_28","JHN","18","28","28","ମାର୍ତଡ଼େ ଗିସେଙ୍ଗ୍‍ ତେଃସବେଲା ମେଇଙ୍ଗ୍ ଜିସୁକେ କୟାଫାନେ ଡୁଆବାନ୍‍ ଡୁଂୱେଚେ ରୋମୀୟ ରାଜ୍ୟପାଲ୍‍ନେ ବିଚାର୍ ଡୁଆନ୍ନିଆ ଆପିଙ୍ଗ୍‍ଚା ଆର୍‌କେ । ଇହୁଦୀଇଂ ବିଚାର୍ ଡୁଆ ବିତ୍ରେ ଆୱେଆର୍‌କେ ଡାଗ୍ଲା ମେଇଂ ଜେନ୍ତିକି ଆବୁଲେ ମାଡିଙ୍ଗ୍‌ଚେ ଉଦାର୍ ପାଣ୍ଡୁଏନେ ବଜି ପାଲେ ୟାଆର୍‌ଏ ଆତେନ୍‌‌ସା ନିଜେନେ ବିଚାର୍ ଡୁଆନ୍ନିଆ ଆରା ଗାଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN18_29","073_18_29","JHN","18","29","29","ତେସା ରାଜ୍ୟପାଲ୍‍ ପିଲାତ ତାର୍‌ଚେ ଆମେଇଂକେ ସାଲ୍ୟାକୁକେ “ଏନ୍‌ ରେମୁଆଁନେ ବିରଦ୍‌ରେ ପେନେ ପର୍‌ମାନ୍‌ ମେଃନେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_30","073_18_30","JHN","18","30","30","ମେଇଂ ଆମେକେ ଉତର୍ ବିକେ “ଆକେନ୍‍ ରେମୁଆଁ ଜଦି ଅପରାଦି ଡିଙ୍ଗ୍ ଆଲେଃଲା ତେଲା ନେ ଆକ୍‌ମେକେ ନାନେ ନ୍ତିନିଆ ଅପେଃ ନେପାବି ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_31","073_18_31","JHN","18","31","31","ଆତ୍‌ବା ପିଲାତ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ତେଲା ଆକ୍‌ମେକେ ଡୁଙ୍ଗ୍‍ୱେଚେ ପେନେ ନିଅମ୍ ଇସାବ୍‌ରେ ବିଚାର୍ ଡିଙ୍ଗ୍‌ପା ।” ମେଇଙ୍ଗ୍ ଉତର୍ ବିକେ “ଆଜାକେ ଡିଗ୍ ଗୁଏଚେ ଡଣ୍ଡ୍ ବିଃନ୍‍ସା ନେନେ ଅଦିକାର୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_32","073_18_32","JHN","18","32","32","ମେଁ ଡିରକମ୍ ଗୁଏଃଏ ଆକେନ୍‍ ବିସୟ୍‌ରେ ଜିସୁ ମେଁନେ ବାସଙ୍ଗ୍‌ ବଗେ, ଆତେନ୍‌ ପୁରନ୍‌ ଡିଂ ନ୍‌ସାଃ ଆକେନ୍‌ ଗଟେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN18_33","073_18_33","JHN","18","33","33","ପିଲାତ ବିଚାର୍ ଡୁଆ ବିତ୍ରେ ୱେଚେ ଜିସୁକେ ୱାଚେ ସାଲ୍ୟାକୁକେ “ନା ମେଃନେ ଯିହୁଦୀଇଂନେ ଇଃସାଙ୍ଗ୍‌ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_34","073_18_34","JHN","18","34","34","ଜିସୁ ଉତର୍ ବିକେ “ଆକେନ୍‍ ପ୍ରସ୍‌ନ ନାଁ ନିଜେ ମନ୍ ବିତ୍ରେବାନ୍ ସାଲ୍ୟାକୁ ନାଡିଙ୍ଗ୍‍କେ ଲେଃ ବିନ୍‍ରେ ନେଙ୍ଗ୍ ସମ୍ପର୍କରେ ଆନାକେ ମେଃନେ ବାସଙ୍ଗ୍‌ବକେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_35","073_18_35","JHN","18","35","35","ପିଲାତ ବାଲିର୍‍କେ “ନାଁ ମେଃନେ ନାବାବେକେ ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ଇହୁଦୀ ? ନାନେ ନିଜର୍ ଜାତି ରେମୁଆଁ ବାରି ମ୍ନାଃପୁଜାରି‍ଇଂ ଆନାକେ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ନେଙ୍ଗ୍ ନ୍ତିଡାଗ୍ରା ଅପେଃ ବଆର୍‌କେ । ବାସଙ୍ଗ୍‌, ନାଁ ମେଃନେ ଡିଙ୍ଗ୍‌ନାବ ?” ");
INSERT INTO gaq_vpl VALUES ("JN18_36","073_18_36","JHN","18","36","36","ଜିସୁ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ରାଇଜ୍ ଆକେନ୍‍ ଜାଗତିକ ଇସାବ୍‌ରେ ଣ୍ଡୁ । ଜଦି ନେଙ୍ଗ୍‌ନେ ରାଇଜ୍ ଜାଗତିକ ଡିଙ୍ଗ୍‌ପାଲେଃ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ନେ ରେମୁଆଁଇଂ ନେଙ୍ଗ୍ ପାକା କୁଡ଼େଚେ ଜୁଦ୍‌ ପାଡିଙ୍ଗ୍‍ ଆର୍‌ଏ । ତେଲା ମେଇଂ ଅଃନାଡିଗ୍ ଆନେଙ୍ଗ୍‌କେ ଇହୁଦୀଇଂନେ ନ୍ତିନ୍ନିଆ ଆନ୍ତାର୍ ଆବି ପାଡିଙ୍ଗ୍‍ । ଣ୍ଡୁ ନେଙ୍ଗ୍‌ନେ ରାଇଜ୍ ଆକେନ୍‍ ମଞ୍ଚ୍‌ପୁର୍‌ ଇସାବ୍‌ରେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_37","073_18_37","JHN","18","37","37","ପିଲାତ ବାରି ସାଲ୍ୟାକୁକେ “ନାଁ ମେଃନେ ସତ୍‍ରେ ମୁଇଙ୍ଗ୍ ଇଃସାଙ୍ଗ୍‌ ?” ଜିସୁ ଉତର୍ ବିକେ “ନାଁ ବାସଙ୍ଗ୍‌ ନାଡିଙ୍ଗ୍‌କେ ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ଇଃସାଙ୍ଗ୍‌ । ମାତ୍‍ରମ୍‍ ନେଙ୍ଗ୍ ସତ୍ ସାମୁଆଁ ବାଲିର୍ ନ୍‌ସା ପାଙ୍ଗ୍ ନ୍ଲେକେ ଆକେନ୍ ସାମୁଆଁ ସାଚେ ନେଙ୍ଗ୍ ଆକେନ୍ ମଞ୍ଚ୍‌ପୁର୍‌ ଜନମ୍ ଡିଙ୍ଗ୍ ନ୍ଲେକେ । ଜାଣ୍ଡେଇଂ ସତ୍‍ନେ ଗଡ଼େଇଂ ମେଁ ଆଃ ନେଙ୍ଗ୍ ସାମୁଆଁ ଅଁଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_38","073_18_38","JHN","18","38","38","ପିଲାତ ଆମେକେ ସାଲ୍ୟାକୁକେ, “ସତ୍ ମେଁନେ ।” ପିଲାତ ବାଜାର୍‍ ତାର୍‌ଚେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଆମେକେ ଗୁଏଃନେ ଡଣ୍ଡ୍‍ ବିଃନ୍‍ସା ନେଙ୍ଗ୍ ମେଃଡିଗ୍ ଦସ୍‍ ନେବାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN18_39","073_18_39","JHN","18","39","39","ମାତର୍‌ ପେନେ ନିୟମ୍‌ ଇସାବ୍‌ରେ ଉଦାର୍ ପାଣ୍ଡୁଏ କେଲା ନେଙ୍ଗ୍ ମୁଇଙ୍ଗ୍ ବନ୍ଦିଆକେ କୁଲାସ୍‍ ଆଡିଙ୍ଗ୍ ମ୍ୟାକେ । ଏବେ ଇହୁଦୀଇଂନେ ଇଃସାଙ୍ଗ୍‌କେ ପେନ୍‌ସା ଆନ୍‌ତାର୍‌ ବିଃପା ଏନ୍‌ ମେଁନେ ପେଇଂ ଚାଏଁ ପେଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN18_40","073_18_40","JHN","18","40","40","ରେମୁଆଁଇଂ ଅଃଗିଆଚେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ, “ଣ୍ଡୁ ଆମେକେ ଣ୍ଡୁ । ବାରବ୍‍ବାକେ କୁଲାସ୍‍ ଆଡିଙ୍ଗ୍‌ବି । ଆନେକେ ବାର୍‍ବା ଦର୍‌କାର୍ !” ମୁଇଙ୍ଗ୍ ଡଙ୍ଗାରେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_1","073_19_1","JHN","19","1","1","ଇଡ଼ିଙ୍ଗ୍ ପିଲାତ ଜିସୁକେ ଡୁଂୱେଚେ ଜାଟି ଏତେ ଆଃବଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_2","073_19_2","JHN","19","2","2","ସନ୍ୟଇଂ ଗ୍ରେଃ ପାଡ଼ୁନେ ସାଜ ଆରେଚେ ଜିସୁକେ ବାଆଃନ୍ନିଆ ଆତାଙ୍ଗ୍‍ ବିଆର୍‌କେ ଆମେକେ ମୁଇଙ୍ଗ୍ କଡ଼େଆଁ ବାନାନେ ସକା ଆସା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_3","073_19_3","JHN","19","3","3","ଆରି “ଏ ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌, ନମସ୍କାର୍‌” ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଚେ ଆମେକେ ଚାପ୍‌ଡ଼ା ବଗ୍ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_4","073_19_4","JHN","19","4","4","ପିଲାତ ଆରି ବାଜାର୍‍ ତାର୍‌ଚେ ଗ୍ଲୁଏରୁଆ ତୁଆଁ ଲେଃଗ୍ନେ ନ୍ତୁଗ୍ ବାସଙ୍ଗ୍‌ “କେଲା ଆମେକେ ପେନେ ସାମ୍‌ନା ଡୁଂପାଂନେଡିଂକେ । ଆମେକେ ଦସ୍‍ ସାଃନ୍‌ସା ନେଙ୍ଗ୍ ମେଃଡିଗ୍ ବୁଲ୍‍ ବା ନେଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ । ଆକେନ୍ ପେ ନିଜେ ବୁଜେପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_5","073_19_5","JHN","19","5","5","ଆତ୍‌ବା କଃଡ଼େଆଁ ବାନାନେ ସକା ଆରି ଗ୍ରେଃନେ ସାଜ ସଃଚେ ଜିସୁ ବାଜାର୍‍ ତାର୍‍କେ ଆରି ପିଲାତ ରିସିଙ୍ଗ୍‍ ଲେଃକ୍ନେ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ “କେଲା ଆକେନ୍ ଆତେନ୍‌ ରେମୁଆଁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_6","073_19_6","JHN","19","6","6","ଆମେକେ କେକ୍ନେ ଦାପ୍ରେ ମ୍ନା ପୁଜାରି ଆରି ମନ୍ଦିର୍‌ନେ ଜାଗୁଆଲ୍‍ଇଂ କିର ଆର୍‌କେ “ଆମେକେ କୁରୁସ୍‍ନ୍ନିଆ ଆଡେପା କୁରୁସ୍‍ନ୍ନିଆ ଆଡେପା ।” ପିଲାତ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେ ଆମେକେ ଡୁଙ୍ଗ୍‍ୱେଲାପା ବାରି କୁରୁସ୍‍ନ୍ନିଆ ଆଡେପା । ଆମେକେ ଡଣ୍ଡ୍‍ ବିଃନ୍‍ସା ନେଙ୍ଗ୍ ମେଃଡିଗ୍ ବୁଲ୍‍ କେନାଡିଙ୍ଗ୍‌କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_7","073_19_7","JHN","19","7","7","ରେମୁଆଁଇଂ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ନେନେ ସାସ୍ତର୍‌ ନିୟମ୍‌ ଇସାବ୍‌ରେ ମେଁ ଗୁଏନେ ଦର୍‌କାର୍, ଡାଗ୍‌ଲା ମେଁ ନିଜ୍‍କେ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଡାଗ୍‌ଚେ ଦାବି ଡିଙ୍ଗ୍‍ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_8","073_19_8","JHN","19","8","8","ଆତ୍‌ଅରିଆ ପିଲାତ ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ ବୁଟ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_9","073_19_9","JHN","19","9","9","ବିଚାର୍ ସବା ଡୁଆ ବିତ୍ରେ ଗାଚେ ଜିସୁକେ ୱାଚେ ସାଲ୍ୟାକୁକେ “ନାଁ ଆଣ୍ଡିବାନ୍ ପାଙ୍ଗ୍‍ନାଲେକେ ।” ମାତ୍‍ରମ୍‍ ଜିସୁ ମେଃଡିଗ୍ ଉତର୍ ଆବିକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN19_10","073_19_10","JHN","19","10","10","ପିଲାତ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଏତେ ଆବାଲିର୍‌ ଆବାତାକେ ଣ୍ଡୁ ? ମନେ ତ୍ଲାଗ୍‌ ବ ଜେ, ଆନାକେ କୁଲାସ୍‍ ଆଡିଙ୍ଗ୍ ନ୍‌ସା ବାରି କୁରୁସ୍‍ନ୍ନିଆ ଆଡେନ୍‍ସା ନେଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଲେଃକେ ।” ଆକେନ୍ ମେଁନେ ନା ନାମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_11","073_19_11","JHN","19","11","11","ଜିସୁ ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆଡ଼ାତ୍ରା ନାନେ ଆତେନ୍‌ ଡିଙ୍ଗ୍‌ନେ ଅଦିକାର୍ ଲେଃକେ ଡାଗ୍ଲା ଇସ୍‌ପର୍ ଆନାକେ ଆତେନ୍‌ ଅଦିକାର୍ ବିବକେ । ମାତର୍‌ ଜା ଆନେଙ୍ଗ୍ ନାଁ ନ୍ତିନ୍ନିଆ ଅପେଃ ବକେ, ମେଁନେ ପାପ୍ ବୟ୍‍ଙ୍କାର୍‍ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_12","073_19_12","JHN","19","12","12","ଆକେନ୍ ଅଁଚେ ପିଲାତ ଜିସୁକେ ଆନ୍‌ତାର୍‌ ବିଃନ୍‍ସା ଉପାୟ୍‍ ଚିନ୍ତା ଡିଙ୍ଗ୍‌ଆର୍କେ । ମାତର୍‌ ରେମୁଆଁଇଂ ଅଃଗିଆଚେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଜଦି ନାଁ ଆମେକେ ଆନ୍‌ତାର୍‌ ନାବିଏ, ତେଲା ନାଁ ଇଃସାଙ୍ଗ୍‌ନେ ରେମୁଆଁ ଣ୍ଡୁ ଜା ନିଜ୍‍କେ ଇଃସାଙ୍ଗ୍‌ ଡାଗ୍‌ଚେ ଦାବି ଡିଙ୍ଗ୍‌ଏ, ମେଁ କାଇସରନେ ବିରଦ୍‌ରେ ବାସଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_13","073_19_13","JHN","19","13","13","ପିଲାତ ଆକେନ୍ ଅଁଚେ ଜିସୁକେ ପାଦା ଡୁଂପାଙ୍ଗ୍‍ଆର୍କେ ବାରି “ବ୍ରିନେ ମଣ୍ଡପ୍” ଆତେନ୍‌ ଏବ୍ରୀ ବ୍ନାସାରେ ଗବ୍‌ବାଥା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ମ୍ୟାକେ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଲେଃକ୍ନେ ବିଚାର୍ ଡୁଆନ୍ନିଆ କକେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_14","073_19_14","JHN","19","14","14","ଆତେନ୍‌ ବେଲା ସ୍ମି ମୁଣ୍ଡେବେଲା ଡିଙ୍ଗ୍‌ଲେଗେ । ଆତେନ୍‌ ଦିନା ଉଦାର୍ ପାଣ୍ଡୁଏନେ ଆର୍ମେନେ ଦିନା ଲେଃଗେ ପିଲାତ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଗିତେ କେଲାପା ପେନେ ଇଃସାଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_15","073_19_15","JHN","19","15","15","ମାତର୍‌ ମେଇଂ କିର ଆର୍‌କେ “ଆମେକେ ବାଗୁଏଃ ବିଃପା ଆମେକେ କୁରୁସ୍‍ନ୍ନିଆ ଆଃଡେ ବିଃପା ।” ପିଲାତ ସାଲ୍ୟାକୁକେ, “ନେଙ୍ଗ୍ ପେନେ ଇଃସାଙ୍ଗ୍‌କେ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ଣ୍ଡ୍ରାଃଡେଏ ଆକେନ୍ ମେଃନେ ପେ ଚାଏଁ ପେଡିଙ୍ଗ୍‌କେ ?” ମ୍ନାଃ ପୁଜାରି‍ଇଂ ଉତର୍ ବିକେ, “କାଇସରକେ ଆନ୍‌ତାର୍‌ଚେ ବାରି ନେନେ ଜା ଇଃସାଙ୍ଗ୍‌ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_16","073_19_16","JHN","19","16","16","ସାରାସାରି କେଲା ପିଲାତ ଜିସୁକେ କୁରୁସ୍‍ନ୍ନିଆ ବାଗୁଏଃ ନ୍‍ସା ମେଁଇଙ୍ଗ୍‌ନେ ନ୍ତିନ୍ନିଆ ଆନ୍‌ତାର୍‌ ବିକେ । ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁକେ ମେଇଂ ଡୁଂୱେ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_17","073_19_17","JHN","19","17","17","ଜିସୁ ନିଜେନେ କୁରୁସ୍‍ ଡୁଙ୍ଗ୍‍ଚେ ବା “କାପାଲେ ମ୍ନିକ୍ନେ ଜାଗା ଆଜାକେ ଏବ୍ରୀ ବ୍ନାସାରେ ଗଲ୍‍ଗଥା” ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ମ୍ୟାକେ ଆତେନ୍‌ ଜାଗାନ୍ନିଆ ଡୁଂୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_18","073_19_18","JHN","19","18","18","ଆତ୍‍ ଅରିଆ ମେଇଂ ଜିସୁକେ କୁରୁସ୍‍ନ୍ନିଆ ବାଗୁଏଃଆର୍‌କେ । ଆମେକେ ମଜେ ଆଡିଙ୍ଗ୍‌ଚେ ବାରି ମେଁନେ ମ୍ୱାର୍‍ପାକା ବିନ୍ ମ୍ୱାୟା ରେମୁଆଁ କୁରୁସ୍‍ନ୍ନିଆ ଆଡେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_19","073_19_19","JHN","19","19","19","ପିଲାତ ମୁଇଙ୍ଗ୍ ଦାବି ଉଲିଆ ଗୁଆର୍‍ଚେ ଜିସୁନେ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ଆୱେଜଙ୍ଗ୍‍ ବିକେ । ଆତ୍‌ଡାଗ୍ରା ଗୁଆର୍‍ ବଗେ “ନାଜରିତିୟ ଜିସୁ ଜିଉଦିଇଂନେ ଇଃସାଙ୍ଗ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_20","073_19_20","JHN","19","20","20","ଗୁଲେ ରେମୁଆଁ ଆତେନ୍‌ ଉଲିଆଃକେ ପଡ଼େ ଆର୍‌କେ ଡାଗ୍ଲା ଜିସୁକେ ଆଣ୍ଡି ଅରିଆ କୁରୁସ୍‍ ଡାଗ୍ରା ବାଗୁଏଃ ବଆର୍‌ଗେ ଆତେନ୍‌ ଇନି ଡାଗ୍ରା ଲେଃଗେ ବାରି ଦାବି ଉଲିଆ ଏବ୍ରୀ ଲାଟିନ୍‍ ବାରି ଗ୍ରୀକ୍ ବ୍ନାସାରେ ଗୁଆର୍‍ ବଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_21","073_19_21","JHN","19","21","21","ମ୍ନା ପୁଜାରିଇଂ ଜବର୍‌ଜସ୍ତି ଡିଙ୍ଗ୍‌ଚେ ପିଲାତକେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ମେଁ ଇହୁଦୀଇଂନେ ଇଃସାଙ୍ଗ୍‌ ଡାଗ୍‌ଚେ ମାଗୁଆର୍‍ଚେ ମେଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ଗେ ନେଙ୍ଗ୍ ଇହୁଦୀଇଂନେ ଇଃସାଙ୍ଗ୍‌ ଏନ୍ ସାମୁଆଁ ଗୁଆର୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_22","073_19_22","JHN","19","22","22","ମାତର୍‌ ପିଲାତ ଉତର୍ ବିକେ “ନେଙ୍ଗ୍ ଡିରକମ୍ ଗୁଆର୍‍ ମ୍ୱକେ ଆତେନ୍‌ ଦେତ୍‌ରକମ୍ ଗୁଆର୍‍ ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_23","073_19_23","JHN","19","23","23","ଜିସୁକେ କୁରୁସ୍‍ନ୍ନିଆ ଆଃଗୁଏକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଅଁଣ୍ଡ୍ରୁଆ ସନ୍ୟ‍ଇଙ୍ଗ୍ ମେଁନେ ସକା ଅଁ ବାଟା ଆଡିଙ୍ଗ୍‌ଚେ ଡୁଂଡ ଆର୍‌କେ । ମାତର୍‌ ଜିସୁନେ ସକା ତଗ୍‍ ଆବଗେ ଣ୍ଡୁ । ମାତର୍‌ ଆଡ଼ାତ୍ରା ବାନ୍ ବୁନ୍ଦେ ଜାକ ସାପା ପାକା ତେ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_24","073_19_24","JHN","19","24","24","ସନ୍ୟ‍ଇଙ୍ଗ୍ ମେଇଂମେଇଂ ବିତ୍ରେ ବାସଙ୍ଗ୍‌ ଆର୍‌କେ “ଆକ୍‌ମେକେ ନେଃସ୍ୟାଃଗ୍‌ପା । ଲେଟ୍‍ରିକ୍‍ ତ୍ଲାଗ୍‌ନ୍ନିଆ ଜା ପେଅବାଏ, ମେଁ ଆତେନ୍‌ ଡୁଂଡଏ ।” ଆକେନ୍‍ ଗଟ୍‍ନାରେ ସାସ୍ତର୍‌ ଗୁଆର୍‍କ୍ନେ ମୁଇଙ୍ଗ୍ ବ୍ନାଲିର୍ ପୁରନ୍‌ ଡିଙ୍ଗ୍‌କେ; “ମେଇଂ ନେଙ୍ଗ୍‌ନେ ସକା ସାପା ବାଟା ତ୍ଲାଗ୍‍ଚେ ଡୁଂଡ ଆର୍‌କେ । ନେଙ୍ଗ୍‌ନେ ସକା ନ୍‌ସା ଲେଟ୍‍ରିକ୍‍ ତ୍ଲାଗ୍ ଆର୍‌କେ ।” ସନ୍ୟ‍ଇଙ୍ଗ୍ ଟିକ୍ ଦେତ୍ ରକମ୍ ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_25","073_19_25","JHN","19","25","25","ଜିସୁନେ କୁରୁସ୍‍ ଡାଗ୍ରା ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେନେ ତନାଡ଼େ ଆରି କ୍ଲିଅପାନେ ସେଲାମ୍ବୁଏ ମରିୟମ୍ ଆରି ମଗ୍‌ଦଲୀନି ମରିୟମ୍ ତୁଆଁ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_26","073_19_26","JHN","19","26","26","ଜିସୁ ମେଁନେ ଇୟାଙ୍ଗ୍‌ଡେ ଆରି ମୁଡ଼ି ସିସ୍‍କେ ବଲ୍ ବାଡିଙ୍ଗ୍‌ଗେ ମେଇଂ ଡାଗ୍ରା ତୁଆଁଲେନେ କେଚେ ଇୟାଙ୍ଗ୍‌ଡେକେ ବାସଙ୍ଗ୍‌କେ “କେଲା ଆକେନ୍ ନାନେ ନାଉଂ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_27","073_19_27","JHN","19","27","27","ତେନ୍‌ ଇଡ଼ିଂ ଜିସୁ ଆତେନ୍‌ ସିସ୍‍କେ ବାସଙ୍ଗ୍‌କେ କେଲା “ଆକେନ୍ ପିୟାଙ୍ଗ୍‍ ।” ଆତେନ୍‌ ଦିନାବାନ୍‍ ଆତେନ୍‌ ସିସ୍‍ ଜିସୁନେ ଇୟାଙ୍ଗ୍‌ଡେକେ ନିଜର୍ ଡୁଆ ୱା ଡୁଂୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_28","073_19_28","JHN","19","28","28","ଜିସୁ ମ୍ୟାକେ ଜେ ସାପା ସାମୁଆଁ ଡା ଲେଃକେ । ମାତର୍‌ ସାସ୍ତର୍‌ନେ ବବିସତ୍‍ ବାନିକେ ସାଉକାର୍ ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ମେଁ ବାସଙ୍ଗ୍‌କେ; “ଆନେଙ୍ଗ୍ ଉଗ୍‍ଡ୍ୟା ଡ ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_29","073_19_29","JHN","19","29","29","ଆତ୍‍ ଅରିଆ ମୁଇଙ୍ଗ୍ ବୁଚେଲେକ୍ନେ ରସ୍ ତ୍ନଲେଃକ୍ନେ ମୁଇଂ ଙ୍କୁଇ ଲେଃଗେ । ମେଇଂ ଆତ୍‌ ଅରିଆ ମେତଗ୍‌ ପପ୍‌ସା ଜଣ୍ଡିଆଚେ ଆମେକେ ଚ୍ଲେକ୍ନେ ଡୁଡୁନ୍ନିଆ ଗାଗ୍‌ଚେ ବାରି ଜିସୁନେ ସାର୍‌ମୁଆଁ ଡାଗ୍ରା ଲମ୍ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_30","073_19_30","JHN","19","30","30","ଜିସୁ ବୁଚେଲେକ୍ନେ ରସ୍ ଉଗ୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ଡା ୱେଗେ ।” ଆକେନ୍ ବାସଙ୍ଗ୍‌ଚେ ମେଁ ବାଆ ଆବ୍ରିଙ୍ଗ୍‍ଚେ ଜିବନ୍ ସାଚେ ଆଡ଼ାତ୍ରା ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_31","073_19_31","JHN","19","31","31","କୁରୁସ୍‍ନ୍ନିଆ ଆଡେବକ୍ନେ ରେମୁଆଁଇଂନେ ଞ୍ଚ ପାକ୍‍ଚିଚେ ମେଁଇଙ୍ଗ୍‌ନେ ଗୁଏକ୍ନେ ଗାଗ୍‌ଡ଼େକେ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ବାନ୍ ବୁନ୍ଦେ ଆଜାର୍‌ଚେ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍ ନ୍‌ସା ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷଇଂ ପିଲାତକେ ବାସଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାଃଆର୍‌କେ । ଡାଗ୍ଲା ଆତେନ୍‌ ଦିନା ଲେଃଗେ ସୁକ୍ରାକେଲା ବାରି ମାର୍‌ତଡ଼େ ଲେଃଗେ ପବିତ୍ର ପୁଣ୍ଡେନେ ଦିନା । ଗୁଏକ୍ନେ ଗାଗ୍‌ଡ଼େକେ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ଆନ୍‌ତାର୍‌ ବିଃନ୍‍ସା ମେଇଂ ଚାଏଁ ଆଡିଙ୍ଗ୍ ଆର୍‌ଗେ ଣ୍ଡୁ । ଡାଗ୍ଲା ଆତେନ୍‌ ଦିନା ମ୍ନା ପବିତ୍ର ପୁଣ୍ଡେନେ ଦିନା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_32","073_19_32","JHN","19","32","32","ତେସା ସନ୍ୟ‍ଇଙ୍ଗ୍ ୱେଚେ ଜିସୁ ଏତେ ଗୁଏ ଲେଃକ୍ନେ ବିନ୍ ମ୍ୱାୟାନେ ଞ୍ଚକେ ପାକ୍‍ଚି ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_33","073_19_33","JHN","19","33","33","ବାରି ମେଇଂ ଜିସୁନେ ଡାଗ୍ରା ୱେଚେ କେଆର୍‌କେ ମେଁ ଗୁଏଃ ୱେ ଲେଃଗେ । ଆତେନ୍‌‌ସା ମେଇଂ ମେଁନେ ଞ୍ଚକେ ଆପାଗ୍‌ଚି ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_34","073_19_34","JHN","19","34","34","ତେଲାଡିଗ୍‍ ମୁଇଙ୍ଗ୍ ସୈନିକ୍‌ ଜିସୁନେ ବେସ୍ୟା ଗ୍ରିପାକା ବର୍ଚା ଏତେ ପଃକେ ଆରି ଆତ୍‌ବାନ୍ ଣ୍ଡିଆ ବାରି ମ୍ୟା ତାର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_35","073_19_35","JHN","19","35","35","ଜା କେଲେକେ ମେଁ ସାକି ବିବକେ ଡିରକମ୍ କି ପେଇଂ ଡିଗ୍‍ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌ଏ; ବାରି ମେଁନେ ସାକି ସତ୍ ଆରି ମେଁ ଜେ ସତ୍ ବାସଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌କେ ଆକେନ୍ ମେଁ ମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN19_36","073_19_36","JHN","19","36","36","ଆକେନ୍ ଗଟ୍‍ନାବାନ୍‍ ସାସ୍ତର୍‌ନେ ବବିସତ୍‍ ବାନି ପୁରନ୍ ଡିଙ୍ଗ୍‌କେ “ମେଁନେ ମୁଇଂଡିଗ୍‍ ଞ୍ଚ୍ୟା ଆପାକ୍‍ଚିକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_37","073_19_37","JHN","19","37","37","ସାସ୍ତର୍‌ନ୍ନିଆ ଆକେନ୍ ଡିଗ୍ ଗୁଆର୍‍ ବକେ; “ଆଜାକେ ମେଇଂ ବାଗୁଏଃ ବଆର୍‌କେ ମେଁଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ରେମୁଆଁଇଂନେ ମ୍ମୁଆଃ ଲେଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN19_38","073_19_38","JHN","19","38","38","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଆରମାଥିଆ ଇନିନେ ଯୋସେଫ୍‌ ପିଲାତ ଡାଗ୍ରା ୱେଚେ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ଡୁଂୱେନ୍‍ସା ବାସଙ୍ଗ୍‌ଚେ ସାଲ୍ୟାଆର୍‌କେ । ଆକେନ୍ ଯୋସେପ୍ ଜିସୁନେ ମୁଇଙ୍ଗ୍ ସିସ୍‍ ଲେଃଗେ ମାତର୍‌ ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷଇଂକେ ବୁଟଚେ ମେଁ ଆକେନ୍ ସାମୁଆଁ ବୁଡ଼ିଚେ ବଗେ । ପିଲାତ ଆମେକେ ମାବାସଙ୍ଗ୍ ବିକେ ବାରି ଯୋସେଫ୍‌ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ଆତି ବିଃନ୍‍ସା ଡୁଂୱିଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_39","073_19_39","JHN","19","39","39","ମେଁ ଏତେ ଲେଃଗେ ନୀକଦୀମ । ଆକେନ୍ ନୀକଦୀମ ମୁଇଙ୍ଗ୍ ଦିନା ମିଡିଗ୍ କେଲା ଜିସୁକେ ଅବାନ୍‌ସା ୱେଡିଂଗେ । ଆତେନ୍‌ ନୀକଦୀମ ପ୍ରାୟ୍‍ ୭୦ କିଜି ବାସ୍ନାରସ୍‍ ମିସେକ୍ନେ ଅଗୁରୁ ଏତେ ଡୁଂପାଙ୍ଗ୍‍ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_40","073_19_40","JHN","19","40","40","ମଡ଼ାକେ ଆତିନେ ସେନୁଗ୍‍ ଆର୍ମେ ନ୍‌ସା ଇହୁଦୀଇଂନେ ନିଅମ୍ ଇସାବ୍‌ରେ ଯୋସେଫ୍‌ ଆରି ନୀକଦୀମ ଜିସୁନେ ଗାଗ୍‌ଡ଼େ ଆଡ଼ାତ୍ରା ବାସ୍‌ନାଚୁ ଏତେ ଲାଗେଚେ ଆମେକେ ପାତଲ୍‍କ୍ନେ ପାଟାଏ ଡାବିକେ । ");
INSERT INTO gaq_vpl VALUES ("JN19_41","073_19_41","JHN","19","41","41","ଜିସୁ ଆଣ୍ଡିନେ ଜାଗାନ୍ନିଆ ଗୁଏଲେଃଗେ ଆତ୍‍ ଅରିଆ ମୁଇଙ୍ଗ୍ ଡୁଗ୍‌ଡି ଲେଃଗେ ଆତ୍‍ ବିତ୍ରେ ମୁଇଙ୍ଗ୍ ତ୍ମିକ୍ନେ ରାଃଚ୍ୟା ଲେଃଗେ । ଆତ୍‌ଅରିଆ ଅଃସେବାନ୍ ଆଜାକେ ଡିଗ୍‍ ଆତି ଆବ ଆର୍‌ଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN19_42","073_19_42","JHN","19","42","42","ଆତେନ୍‌ ଦିନା ଜିଉଦିଇଂନେ ଆର୍ମେନେ ଦିନା ଲେଃଗେସା ଜାବର୍‌ ସ୍ଲ ମାୱେଚେ ମେଇଂ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ଡୁଂୱେଚେ ଆତେନ୍‌ ରାଃଚ୍ୟାନ୍ନିଆ ଆତିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_1","073_20_1","JHN","20","1","1","ସାନ୍ତାକାଲା ଞ୍ଜିର୍‍ନୁଗ୍ ମଗ୍‌ଦଲୀନି ମରିୟମ୍ ଜିସୁକେ ଆତିବକ୍ନେ ଡାଗ୍ରା ୱେଚେ କେକେ ରାଃଚ୍ୟାନ୍ନିଆ ଡାବକ୍ନେ ବ୍ରି ଗୁଚେ ୱେଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_2","073_20_2","JHN","20","2","2","ମେଁ ୱିର୍ ଡୁଂୱେଚେ ଶିମୋନ୍ ପିତର୍ ଆରି ଜିସୁ ଆଜାକେ ଜବର୍‌ ଆଲାଦ୍‌ ଡିଂଡିଂଗେ, ଆତେନ୍‌ ସିସ୍‍କେ କବର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍ରୁକେ ମେଇଂ ରାଃଚ୍ୟା ବିତ୍ରେ ବାନ୍ ଡୁଂଡ ବ ଆର୍‌କେ; ଆଣ୍ଡିନ୍ନିଆ ଆମେକେ ଡୁଂୱେ ବଆର୍‌କେ, ନେ ନେମ୍ୟାଃକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_3","073_20_3","JHN","20","3","3","ଆକେନ୍‍ ଅଁଚେ ପିତର୍ ଆରି ଆତେନ୍‌ ସିସ୍‍ ମ୍ୱାୟା ରାଃଚ୍ୟା ପାକା ୱିର୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_4","073_20_4","JHN","20","4","4","ମେଇଂ ମ୍ୱାୟା କୁଡ଼େଚେ ୱିର୍‌ନେ ମୁଲେକେ । ଆରି ଆତେନ୍‌ ବିନ୍ ସିସ୍‍ ପିତର୍‌କେ ରାଃସେଚେ ପର୍‍ତୁମ୍‍ ରାଃଚ୍ୟା ଡାଗ୍ରା ୱେଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_5","073_20_5","JHN","20","5","5","ମେଁ ବ୍ରିଙ୍ଗ୍‍ଚେ କେକେ ଆଣ୍ଡିନେ ତଗ୍‍ରିଆ ଏତେ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ୱାର୍‍ମୁଲି ବଆର୍‌ଗେ ଆତେନ୍‌ ଆତ୍‌ଅରିଆ ଲଃଲେଗେ ମାତର୍‌ ମେଁ ରାଃଚ୍ୟା ବିତ୍ରେ ଆୱେକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN20_6","073_20_6","JHN","20","6","6","ମେଁନେ ପ୍ଲା ଶିମୋନ୍ ପିତର୍ ପାଙ୍ଗ୍‌ଚେ ସିଦା ରାଃଚ୍ୟା ବିତ୍ରେ ଗାୱେଆର୍‌କେ । ମେଁ କେକେ ଜିସୁନେ ଗାଗ୍‍ଡ଼େନ୍ନିଆ ୱାର୍‍ମୁଲି ବକ୍ନେ ପାଟାଏ ଦେତ୍‌ରକମ୍ ମୁଇଙ୍ଗ୍ ଟାନ୍ ନ୍ତୁଗ୍ ଲଃଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_7","073_20_7","JHN","20","7","7","ଆରି ମେଁନେ ବାଆଃନ୍ନିଆ ଗାଗ୍‌ବକ୍ନେ ଗର୍‍ଣ୍ଡାଇଂ ଡିଗ୍ ଦେତ୍‌ରକମ୍ ଆଃ ବିନ୍ ଜାଗାନ୍ନିଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_8","073_20_8","JHN","20","8","8","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ବିନ୍ ସିସ୍‍ ମୁଇଙ୍ଗ୍ ରାଃଚ୍ୟା ବିତ୍ରେ ୱେଚେ ଆକେନ୍ ସାପା କେଚେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_9","073_20_9","JHN","20","9","9","ମାତର୍‌ ଆତେନ୍‌ ବେଲା ଏନ୍‌ ମ୍ୱାୟା ବୁଜେ ଆଲେଃଆର୍‌ଗେ ଣ୍ଡୁ ଜେ ସାସ୍ତର୍‌ନେ ସାମୁଆଁ ଇସାବ୍‌ରେ ଜିସୁ ଗୁଏଚେ ଆରି ମୁଇଂତର୍ ତଃଡ଼ିଆଏ । ");
INSERT INTO gaq_vpl VALUES ("JN20_10","073_20_10","JHN","20","10","10","ରାଃଚ୍ୟାକେ କିକେ ଆଃଡାଚେ ସିସ୍‍ଇଂ ଡୁଆ ୱିଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_11","073_20_11","JHN","20","11","11","ପାଦା ତୁଆଁଚେ ମରିୟମ୍ ଅଃନେ ମୁଲେକେ । ଅଃ ଅଃଚେ ରାଃଚ୍ୟା ବିତ୍ରେ ବ୍ରିଙ୍ଗ୍‍ଚେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_12","073_20_12","JHN","20","12","12","ତୁଲୁଏକ୍ନେ ସକା ସଃଲେକ୍ନେ ମ୍ୱାୟା କିତଂ ଦୁତ୍ ଜିସୁନେ ଗାଗ୍‌ଡ଼େକେ ଆଣ୍ଡିଡାଗ୍ରା ବଆର୍‌ଗେ ଆତ୍‌ଡାଗ୍ରା କଲେ ଆର୍‌ଗେ ମୁଇଂଜା ବାଆ ପାକା ବାରି ମୁଇଂଜା ଞ୍ଚ ପାକା । ");
INSERT INTO gaq_vpl VALUES ("JN20_13","073_20_13","JHN","20","13","13","ମେଇଂ ସାଲ୍ୟାକୁକେ “ମେଃନ୍‌ସା ଅଃ ନାଡିଙ୍ଗ୍‌କେ ଇୟାଙ୍ଗ୍ ?” ମରିୟମ୍ ଉତର୍ ବିକେ “ମେଇଂ ନେଙ୍ଗ୍ ମାପ୍ରୁକେ ଡୁଂୱେ ବଆର୍‌କେ । ନେଙ୍ଗ୍ ନ୍ନାମ୍ୟାକେ ଣ୍ଡୁ ଆମେକେ ଆଣ୍ଡିନ୍ନିଆ ବଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_14","073_20_14","JHN","20","14","14","ଏନ୍‌ ବାସଙ୍ଗ୍‌ଚେ ମରିୟମ୍ ପ୍ଲେଗ୍‍ଚେ କେକେ ମେଁନେ ପ୍ଲାପାକା ଜିସୁ ତୁଆଁ ଲେଃଗେ । ମାତର୍‌ ଆତେନ୍‌‌ ବେଲା ମେଁ ଆମେକେ ସାମୁଆଁ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN20_15","073_20_15","JHN","20","15","15","ଜିସୁ ସାଲ୍ୟାକୁକେ, “ନାଁ ମେଁନ୍‌ସା ଅଃ ନାଡିଙ୍ଗ୍‌କେ ? ଆଜାକେ ତୁର୍ ନାଡିଙ୍ଗ୍‌କେ ?” ମେଁ ଆମେକେ ଡୁଗ୍‌ଡିନେ ମାଲି ଡାଗ୍‌ଚେଃ ମରିୟମ୍ ବାସଙ୍ଗ୍‌କେ, “ମାପ୍‌ରୁ, ନାଁ ଜଦି ଆମେକେ ଡୁଂୱେ ନାବକେ, ତେଲା ଆଣ୍ଡି ଡାଗ୍ରା ନାବକେ, ଆନେଙ୍ଗ୍ ବାସଙ୍ଗ୍‌, ନେଙ୍ଗ୍‍ ୱେଚେ ଆମେକେ ଡୁଂମ୍ପାଂଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_16","073_20_16","JHN","20","16","16","ଜିସୁ ଆମେକେ ୱାକେ “ମରିୟମ୍ !” ମରିୟମ୍ ମେଁ ପାକା ତାମୁଚେ ବାସଙ୍ଗ୍‌କେ “ରାବ୍‌ବୂନୀ” ଏବ୍ରୀ ବ୍ନାସାରେ ଆକେନ୍ ଅର୍‌ତ ଗୁରୁ । ");
INSERT INTO gaq_vpl VALUES ("JN20_17","073_20_17","JHN","20","17","17","ଜିସୁ ବାସଙ୍ଗ୍‌କେ “ଆନେଙ୍ଗ୍‌କେ ସାଚେ ଆବଗେ ଡାଗ୍ଲା ନେଙ୍ଗ୍ ଏଃଜାକ ନେଙ୍ଗ୍‌ନେ ଆବା ଡାଗ୍ରା ନ୍ନାୱେକେ ଣ୍ଡୁ । ନେଙ୍ଗ୍‌ନେ ବୟାଁଇଂ ଡାଗ୍ରା ୱେଚେ ବାସଙ୍ଗ୍‌ ନେଙ୍ଗ୍‌ନେ ଆବା ଆରି ପେନେ ଆବା ନେଙ୍ଗ୍‌ନେ ଇସ୍‌ପର୍ ଆରି ପେନେ ଇସ୍‌ପର୍ ଡାଗ୍ରା ନେଙ୍ଗ୍ ୱେଣ୍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_18","073_20_18","JHN","20","18","18","ଜିସୁ ଡିରକମ୍ ଆମେକେ ଦର୍ସନ୍ ବିବଗେ ଆରି ମେଃ ମେଃନେ ବାସଙ୍ଗ୍‌ ବଗେ, ନିଂ ମାପ୍‌ରୁକେ ଙ୍କେକେ ଡାଗ୍‌ଚେଃ ମଗ୍‌ଦଲୀନି ମରିୟମ୍ ୱେଚେ ସାପା ସାମୁଆଁ ସିସ୍‍ଇଂକେ ଆମ୍ୟାଃବିକେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_19","073_20_19","JHN","20","19","19","ଆତେନ୍‌ ସାନ୍ତା କାଲା ଲମ୍‍ଡିଗ୍‍ ବେଲା ସିସ୍‍ଇଂ ଇହୁଦୀ କର୍ତ୍ତୁପକ୍ଷ‍ଇଂକେ ବୁଟଚେ ମୁଇଙ୍ଗ୍ ଆନ୍ତଃ ବକ୍ନେ ଡୁଆ ବି‍ତ୍ରେ ରିସିଙ୍ଗ୍‍ ଲେଃଆର୍‌ଗେ । ଉଲୁସ୍ତେ ଜିସୁ ମେଁଇଙ୍ଗ୍‌ନେ ବିତ୍ରେ ପାଙ୍ଗ୍‌ଚେ ତୁଆଁକେ । “ପେଇଂନେ ସାନ୍ତି ଡିଙ୍ଗ୍‌ଲେ” ");
INSERT INTO gaq_vpl VALUES ("JN20_20","073_20_20","JHN","20","20","20","ଆତେନ୍‌ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ଚେ ଜିସୁ ମେଁନେ ନ୍ତି ଆରି ଞ୍ଚ ଆଃ କେକେ । ମାପ୍ରୁକେ କେଚେ ସିସ୍‍ଇଂ ସାର୍ଦା ଡିଙ୍ଗ୍ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN20_21","073_20_21","JHN","20","21","21","ଜିସୁ ଆମେଇଂକେ ବାର୍‌ମୁଇଂତର୍‍ ବାସଙ୍ଗ୍‌କେ “ପେଇଂନେ ସାନ୍ତି ଡିଙ୍ଗ୍‌ଲେ ଆବା ଆନେଙ୍ଗ୍‌କେ ଡିରକମ୍ ବେ ବଗେ ନେଙ୍ଗ୍ ଡିଗ୍ ଆପେକେ ଦେତ୍‌ରକମ୍ ବେ ଣ୍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_22","073_20_22","JHN","20","22","22","ଇଡ଼ିଙ୍ଗ୍ ମେଁ ମେଁଇଙ୍ଗ୍‌ନେ ଆଡ଼ାତ୍ରା ନିଜେନେ ପୁଣ୍ଡା ଆନ୍‌ତାର୍‌ଚେ ବାସଙ୍ଗ୍‌କେ “ପବିତ୍ର ଆତ୍ମାକେ ଗ୍ର‍ଅନ୍‌ ଡିଙ୍ଗ୍‌ପା । ");
INSERT INTO gaq_vpl VALUES ("JN20_23","073_20_23","JHN","20","23","23","ପେଇଂ ଜଦି ଆଜାକେ ପାପ୍‍ବାନ୍‍ କେମା ପେଡିଙ୍ଗ୍‌ଏ; ମେଁନେ ପାପ୍ କେମା ଡିଙ୍ଗ୍‌ଏ; ଜଦି ଜାନେ ପାପ୍ କେମା ପେଡିଙ୍ଗ୍ ମେଁନେ ପାପ୍ କେମା ଆଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_24","073_20_24","JHN","20","24","24","ଜିସୁ ସିସ୍ଇଂକେ ଦର୍ସନ୍ ବିକେଲା ଗମ୍ବାର୍ ସିସ୍‍ଇଂବାନ୍‍ ଥୋମା ଜାନେ ବିନ୍ ମ୍ନି “ଦିଦୁମ” ମେଁ ଆତ୍‍ଅରିଆ ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN20_25","073_20_25","JHN","20","25","25","ତେସା ବିନ୍ ସିସ୍‍ଇଂ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌ଆର୍‌କେ “ନେନେ ମାପ୍ରୁକେ କିକେ ନେଲେକେ ।” ଥୋମା ବାସଙ୍ଗ୍‌କେ “ମେଁନେ ନ୍ତିନ୍ନିଆ ଗ୍ରେଃ ଚିନା ନେକେଲା ଆରି ମେଁନେ ଚିନା ଡିଙ୍ଗ୍‌ଲେଃକ୍ନେ ଜାଗାନ୍ନିଆ ନାଲିଗ୍‍ଲା ଏନ୍‌ ସାମୁଆଁ ନେଙ୍ଗ୍ ବିସ୍‌ବାସ୍ ନ୍ନାଡିଙ୍ଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_26","073_20_26","JHN","20","26","26","ମୁଇଙ୍ଗ୍ ସାନ୍ତା ଇଡ଼ିଙ୍ଗ୍ ସିସ୍‍ଇଂ ଡୁଆ ବିତ୍ରେ ମୁଇଂତୁଗ୍ ରିସିଙ୍ଗ୍‍ ଲେଃଆର୍‌ଗେ ଆରି ଥୋମା ମେଁ ଏତେ ଲେଃଗେ । ବାରି କାପାଟ୍‍ଇଂ ବନ୍ଦ୍ ଲେଃଗେ । ମାତର୍‌ ଜିସୁ ପାଙ୍ଗ୍‌ଚେ ମେଁଇଙ୍ଗ୍‌ନେ ମଜେ ତୁଆଁଚେ ବାସଙ୍ଗ୍‌କେ “ପେଇଂନେ ସାନ୍ତି ଡିଙ୍ଗ୍‌ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_27","073_20_27","JHN","20","27","27","ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ଥୋମାକେ ବାସଙ୍ଗ୍‌କେ “ଆକ୍ ଅରିଆ ଆର୍‌ୱେତି ବଚେ । ନେଙ୍ଗ୍‌ନେ ନ୍ତି କେଲା । ନାନେ ନ୍ତି ଆଚ୍ଲେଚେ ନେଙ୍ଗ୍‌ନେ ମୁଇଙ୍ଗ୍ ଗ୍ରିପାକା ଲିଗ୍ । ଆରି ଅବିସ୍‌ବାସ୍ ମାଡିଙ୍ଗ୍‌ଚେ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍ ।” ");
INSERT INTO gaq_vpl VALUES ("JN20_28","073_20_28","JHN","20","28","28","ଥୋମା ଉତର୍ ବିଚେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍‌ନେ ମାପ୍ରୁ ନେଙ୍ଗ୍‌ନେ ଇସ୍‌ପର୍ !” ");
INSERT INTO gaq_vpl VALUES ("JN20_29","073_20_29","JHN","20","29","29","ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ଆନେଙ୍ଗ୍ କେଚେ ନାଁ ଆନେଙ୍ଗ୍ ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ, ମାତର୍‌ ଜାଣ୍ଡେଇଂ ଆନେଙ୍ଗ୍‌କେ ମାକେକୁଟା ବିସ୍‌ବାସ୍ ଡିଙ୍ଗ୍‌ଆର୍‌ଏ ମେଇଂ ଦନ୍ୟ !” ");
INSERT INTO gaq_vpl VALUES ("JN20_30","073_20_30","JHN","20","30","30","ସିସ୍ଇଂନେ ସାମ୍‌ନେ ଜିସୁ ବାରି ଗୁଲୁଏ କାବା ସୁଗୁଆ କାମ୍ ଡିଙ୍ଗ୍‍ବକେ । ଆତେନ୍‌ ଏନ୍‌ ବଇଅରିଆ ଗୁଆର୍‍ ଆବକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN20_31","073_20_31","JHN","20","31","31","ମାତର୍‌ ଆକେନ୍ ସାପା ଗୁଆର୍‍ ବକେ, ପେ ଡିରକମ୍ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍ଏ ଜେ, ଜିସୁ ଆଃ ଇସ୍‌ପର୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ମସୀହ ଆରି ମେଁନେ ମ୍ନିରେ ବିସ୍‌ବାସ୍ ପେଡିଙ୍ଗ୍‌ଲା, ପେ ଜିବନ୍ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("JN21_1","073_21_1","JHN","21","1","1","ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ତିବିରିଆ କେଣ୍ଡିଆ ଆଃଡ଼ାନ୍ନିଆ ଜିସୁ ଗମ୍ବାର୍ ସିସ୍‍କେ ଆରି ମୁଇଂତର୍ ଦର୍ସନ୍ ବିକେ । ମେଁ ");
INSERT INTO gaq_vpl VALUES ("JN21_2","073_21_2","JHN","21","2","2","ଆତେନ୍‌‍ବେଲା ଆତ୍‌ଅରିଆ ଶିମୋନ୍ ପିତର୍ ଥୋମା ଜାନେ ବିନ୍ ମ୍ନି ଦିଦୁମ ଗାଲିଲୀନେ କାନା ଇନିନ୍ନିଆ ବାସାଲେକ୍ନେ ରେମୁଆଁ ନିଥନିୟେଲ ଜେବଦୀନେ ମ୍ୱାୟା ଉଙ୍ଗ୍‌ଡେ ଆରି ବିନ୍ ମ୍ୱାୟା ସିସ୍‍ ଡିଗ୍‍ ଆତ୍‌ଅରିଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN21_3","073_21_3","JHN","21","3","3","ସିମୋନ୍‌ ପିତର୍ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍ ଆଡ଼ ସା ନ୍ତାର୍‍କେ ।” ବିନ୍ ସିସ୍‍ଇଂ ବାସଙ୍ଗ୍‌କେ “ନେ ନାଁ ଏତେ ନେପାଙ୍ଗ୍‍ଏ ।” ସାପାରେ ଡଙ୍ଗାଅରିଆ ଡେଃଚେ ଆତେନ୍‌ ମିଡିଗ୍‍ବଃ ଜାକ କେଣ୍ଡିଆନ୍ନିଆ ଜାଲ୍ ତ୍ଲାଗ୍‌ଆର୍‌କେ, ମାତର୍‌ ମେଃଡିଗ୍ ସାଃ ଆୟାଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN21_4","073_21_4","JHN","21","4","4","ଆରି ମେସୁଆ ଞ୍ଜିର୍‍ ସ୍ନି ତାର୍‍କ୍ନେ ବେଲା ଜିସୁ କେଣ୍ଡିଆ ଆଡ଼ା ତୁଆଁକେ ତେଲାଡିଗ୍‍ ସିସ୍‍ଇଂ ଆମେକେ ସାମୁଆଁ ଆୟା ଆର୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN21_5","073_21_5","JHN","21","5","5","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ଗଡ଼େଇଂ ପେ ଡାଗ୍ରା ମେଃନେ ଡିଗ୍ ଚଙ୍ଗ୍‌ନେ ଲେଃକେ ?” ମେଁଇଂ ଆମେକେ ଉତର୍ ବିକେ “ମେଃ ଡିଗ୍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_6","073_21_6","JHN","21","6","6","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ତରାନେ ଞ୍ଚଙ୍ଗ୍‌ତି ପାକା ଜାଲ୍ ତ୍ଲାଗ୍ ତେଲା ପେଇଂ ପେବାଏ ।” ତେଲା ମେଇଂ ଜାଲ୍ ତ୍ଲାଗ୍ ଆର୍‌କେ ଆରି ଏନ୍ତି ଆଡ଼ ବାକେ ଜେ ମେଇଂ ଉସାସ୍‍ରେ ଜାଲ୍‍କେ ଗୁ ଆୟା ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("JN21_7","073_21_7","JHN","21","7","7","ଆତ୍‍ଅରିଆ ଜିସୁ ମୁଃଡ଼ି ସିସ୍‍କେ ବଲ୍ ବାଡିଙ୍ଗ୍‌ଗେ ମେଁ ପିତର୍‌କେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍ ତ ମାପ୍ରୁ ।” ଶିମୋନ୍ ପିତର୍ ଆକେନ୍ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ଅଁଚେ ଡୁଙ୍ଗ୍‍ଡା ଡିଙ୍ଗ୍‌ଲେଗ୍ନେ କେଚେ ଜିଆଃ ମେଁ ନିଜେନେ ସକା ସଃଚେ କେଣ୍ଡିଆନ୍ନିଆ ପୁଏଃକେ । ");
INSERT INTO gaq_vpl VALUES ("JN21_8","073_21_8","JHN","21","8","8","ମାତର୍‌ ବିନ୍ ସିସ୍‍ଇଂ ଜାଲ୍‌ନ୍ନିଆ ତ୍ନଲେଃକ୍ନେ ଆଡ଼କେ ଗୁ ଗୁଚେ ଡାଆଁ ତରାନ୍ନିଆ ପାଙ୍ଗ୍‍ଆର୍କେ, ଡାଗ୍ଲା ମେଇଂ କେଣ୍ଡିଆ ଆଡ଼ାବାନ୍‍ ଜବର୍ ସ୍ଲ ଆଲେଃଗେ ଆର୍‌ଗେ ଣ୍ଡୁ । ମାତର୍‌ ଗୁଆକୁଡ଼ି ନ୍ତି ମଜେ ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN21_9","073_21_9","JHN","21","9","9","କେଣ୍ଡିଆ ଆଃଡ଼ା ୱେଚାଚେ ମେଇଂ କେଆର୍‌କେ ଜେ ଡୁଆଲେଃକ୍ନେ ସୁଆ ବୁରିୟାଃ ଆଡ଼ାତ୍ରା ଉଡ଼ି ଗେବକ୍ନେ ଆଡ଼ ଆରି ଉଡ଼ି ସୁଗୁଆ ରୁଟି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN21_10","073_21_10","JHN","21","10","10","ଜିସୁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ “ପେ ଏକ୍ରେ ଆଣ୍ଡିନେ ଆଃଡ଼ ପେସାକେ ଆତ୍‌ବାନ୍ ଉଡ଼ି ଡୁଂପାଙ୍ଗ୍‌ଲାପା ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_11","073_21_11","JHN","21","11","11","ଶିମୋନ୍ ପିତର୍ ୱେଚେ ଆଡ଼ ତ୍ନଲେଃକ୍ନେ ଜାଲ୍‍କେ କେଣ୍ଡିଆଃ ଆଃଡ଼ାଃ ଉର୍‌ଗୁ ଡୁଂପାଙ୍ଗ୍‌କେ । ଆତ୍‍ ଅରିଆ ଲେଃଗେ ମାଲ୍‍କୁଡ଼ି ପଚାସ୍‍ ଞ୍ଜିକ୍ଲିଗ୍ ମ୍ନା ଆଡ଼ । ଅଃତେନ୍‍ ଆଡ଼ନେ ଲିଗିଙ୍ଗ୍‍ ମାଡ୍‍ରେ ଡିଗ୍ ଜାଲ୍ ଟିକ୍‌ଚି ଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("JN21_12","073_21_12","JHN","21","12","12","ଜିସୁ ସିସ୍ଇଂକେ ୱାଚେ ବାସଙ୍ଗ୍‌କେ “ଗେଲାପା ପେଚଙ୍ଗ୍‍ଏ । ନାଁ ଜାଣ୍ଡେ” ଡାଗ୍‌ଚେ ଆମେକେ ସାଲ୍ୟାକୁ ଜା ସାହାସ୍ ଆଡିଙ୍ଗ୍ ଆର୍‌କେ ଣ୍ଡୁ । ଡାଗ୍ଲା ମେଁ ମାପ୍ରୁ ଡାଗ୍‌ଚେ ମେଇଂ ମ୍ୟାଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("JN21_13","073_21_13","JHN","21","13","13","ଜିସୁ ମେଇଂ ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ରୁଟି ଆରି ଆଃଡ଼ ବାଟା ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("JN21_14","073_21_14","JHN","21","14","14","ଗୁଏଚେ ତଡ଼ିଆଃକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ସିସ୍‍ଇଂକେ ଦର୍ସନ୍ ବିଃକ୍ନେ ଆକେନ୍‍ ଏତେ ଞ୍ଜିତର୍‍ । ");
INSERT INTO gaq_vpl VALUES ("JN21_15","073_21_15","JHN","21","15","15","ସାପାରେ ଚଙ୍ଗ୍‍ଆଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଶିମୋନ୍ ପିତର୍‌କେ ସାଲ୍ୟାକୁକେ “ଜହନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଶିମୋନ୍ ନାଁ ମେଃନେ ଆକ୍‌ମେଇଂବାନ୍ ଆନେଙ୍ଗ୍‌କେ ଜବର୍ ବଲ୍ ବାନାଡିଙ୍ଗ୍‌କେ ?” ଶିମୋନ୍ ବାସଙ୍ଗ୍‌କେ “ଅ ମାପ୍ରୁ ନାଁ ମ୍ୟାଃନାଲେଃକେ ନେଙ୍ଗ୍ ଆନାକେ ବଲ୍ ବାଣ୍ଡିଂକେ ।” ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ତେଲା ନେଙ୍ଗ୍‌ନେ ଉଂମେଣ୍ଡାଇଂକେ ତୁର୍‍ତିଆ ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_16","073_21_16","JHN","21","16","16","ଜିସୁ ମ୍ୱାର୍‍ତର୍‍ ସାଲ୍ୟାକୁକେ “ଜହନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଶିମୋନ୍ ନାଁ ମେଃନେ ଆନେଙ୍ଗ୍‌କେ ବଲ୍ ବାନାଡିଙ୍ଗ୍‌କେ ?” ଶିମୋନ୍ ପିତର୍ ଉତର୍ ବିକେ “ଅ ମାପ୍ରୁ ନାଁ ମ୍ୟାନାଲେକେ ନେଙ୍ଗ୍ ଆନାକେ ବଲ୍‍ ବାଣ୍ଡିଂକେ ।” ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ “ନେଙ୍ଗ୍‌ନେ ମେଣ୍ଡାଇଂକେ ଜତନ୍‍ ଡୁଂଡଲା ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_17","073_21_17","JHN","21","17","17","ଜିସୁ ଶିମୋନ୍ ପିତର୍‌କେ ଞ୍ଜିଦାପା ସାଲ୍ୟାକୁକେ “ଜହନ୍‌ନେ ଉଙ୍ଗ୍‌ଡେ ଶିମୋନ୍ ନାଁ ମେଃନେ ଆନେଙ୍ଗ୍‌କେ ବଲ୍‍ ବାନାଡିଂକେ ?” ଆକ୍ଅରିଆ ପିତର୍ ଦୁକ୍ ଡିଙ୍ଗ୍‌କେ । ଡାଗ୍ଲା ଜିସୁ ଆମେକେ ଞ୍ଜିଦାପା ସାଲ୍ୟାକୁକେ “ନାଁ ଆନେଙ୍ଗ୍‌କେ ବଲ୍‍ ବାନାଡିଂକେ ?” ମେଁ ବାସଙ୍ଗ୍‌କେ “ମାପ୍ରୁ ନାଁ ସାପା ମ୍ୟାନାଲେକେ ନେଙ୍ଗ୍ ଜେ ଆନାକେ ବଲ୍‍ ବାଣ୍ଡିଂକେ,” ତେଲାଲେ ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‌ନେ ମେଣ୍ଡାଇଂକେ ତୁର୍‍ତିଆ ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_18","073_21_18","JHN","21","18","18","ନେଙ୍ଗ୍ ସତ୍ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ, “ନାଁ ଙ୍ଗିରେ ଲେଃନେ କାଲା ନାଁ ଇକ୍‌ଚାରେ ଆଣ୍ଡିନେ ଜାଗାନୁଗ୍‍ ଡିଙ୍ଗ୍‌ ନ୍‌ସା ଗାଗ୍‌ଚେ ୱେନାଡିଂଗେ । ମାତର୍‌ ନାନେ ଡକ୍ରା ନାଡିଙ୍ଗ୍‍ଲା ନ୍ତିକେ ନାରାଲମ୍ୱେଏ ଆରି ବାରି ମୁଇଂଜା ଆନାକେ ଆଣ୍ଡିପାକା ନାନେ ୱେନେ ମନ୍ ଆଲେଃ ଆତ୍‌ବାନ୍ ବିନ୍ ଜାଗାପାକା ଆନାକେ ଡୁଂୱେଆର୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_19","073_21_19","JHN","21","19","19","ପର୍‍ମେସର୍‍ନେ ଗୌରବ୍‍ ନ୍‍ସା ପିତର୍ ଡିରକମ୍ ଡିଙ୍ଗ୍‌ଚେ ଗୁଏଃଏ, ଆକେନ୍ ଆମ୍ୟାନେ ଉଦେସ୍‍ରେ ଜିସୁ ଦେତ୍‌ରକମ୍ ବାସଙ୍ଗ୍‍ବଗେ । ଏନ୍‌ ଇଡ଼ିଙ୍ଗ୍ ଜିସୁ ଆମେକେ ବାସଙ୍ଗ୍‌କେ, “ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_20","073_21_20","JHN","21","20","20","ପିତର୍ ପ୍ଲେଗ୍‍ଚେ ପ୍ଲାପାକା ଜିସୁନେ ନିଜର୍ ସିସ୍‍କେ କେକେ । ଆଜାକେ ଜିସୁ ଆଲାଦ୍ ଡିଂଡିଙ୍ଗେ ଆକେନ୍ ସିସ୍‍ ମିଡିଗ୍‌ବ ଚଙ୍ଗ୍‍ଉଗ୍‍ କେଲା ଜିସୁନେ ଆଡ଼ାତ୍ରା ନିଗ୍‍ଡେଚେ ସାଲ୍ୟାକୁବଗେ “ମାପ୍ରୁ ନାଁ ଆଡ଼ାତ୍ରା ଜାଣ୍ଡେ ବିସ୍‌ବାସ୍‌ଗାତ୍ ଡିଙ୍ଗ୍‌ଏ ?” ");
INSERT INTO gaq_vpl VALUES ("JN21_21","073_21_21","JHN","21","21","21","ପିତର୍ ଆତେନ୍‌ ସିସ୍‍କେ କେଚେ ଜିସୁକେ ସାଲ୍ୟାକୁକେ “ମାପ୍ରୁ ଆକ୍‌ମେନେ ବିସୟ୍‌ରେ ନାନେ ମେଁନେ ବାସଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("JN21_22","073_21_22","JHN","21","22","22","ଜିସୁ ଆମେକେ ଉତର୍ ବିକେ “ଜଦି ନେଙ୍ଗ୍ ରାଜି ଣ୍ଡିଙ୍ଗ୍‍ଏ; ନେଙ୍ଗ୍‌ନେ ବାର୍‌ମୁଇଂତର୍‍ ପାଙ୍ଗ୍‌ନେ ଦିନା ଜାକ ମେଁ ବ୍ରୁଆ ଲେଲେ । ଆତ୍‌ଅରିଆ ନାନେ ମେଁନେ ଲେଃକେ ? ନାନେ ନେଙ୍ଗ୍‌ନେ ପ୍ଲା ପାଙ୍ଗ୍‌ଲା କିନା ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_23","073_21_23","JHN","21","23","23","ଆତ୍‌ବା ଜିସୁନେ ପ୍ଲା ୱେଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂ ବିତ୍ରେ ଉଡ୍ରା ଡିଙ୍ଗ୍‌କେ ଆତେନ୍‌ ସିସ୍‍ ଅଃନା ଆଗୁଏ ଣ୍ଡୁ । ମାତର୍‌ ମେଁ ଆଗୁଏ ଡାଗ୍‌ଚେ ଜିସୁ ବାସଙ୍ଗ୍‌ ଆବଗେ । ମେଁ ମାତର୍‌ ବାସଙ୍ଗ୍‍ବଗେ “ନେଙ୍ଗ୍ ପାଙ୍ଗ୍‍ ଦିନା ଜାକ ମେଁ ବ୍ରୁଆଲେ ଡାଗ୍‌ଚେ ଜଦି ନେଙ୍ଗ୍ ରାଜିଣ୍ଡିଂଏ ତେଲା ଆତ୍‌ଅରିଆ ନାନେ ମେଁନେ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("JN21_24","073_21_24","JHN","21","24","24","ଜା ଆକେନ୍ ସାପା ସାମୁଆଁ ସାକି ବିଃବକେ ଆରି ଆକେନ୍‍ ସାପା ଗୁଆର୍‍ ବକେ ମେଁ ଆତେନ୍‌ ସିସ୍‍; ଆରି ମେଁନେ ସାକି ଜେ ସତ୍ ଆତେନ୍‌ ନେ ମ୍ୟାନେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("JN21_25","073_21_25","JHN","21","25","25","ଜିସୁ ଆରି ଉଡ଼ି ଉଡ଼ି କାମ୍ ଡିଙ୍ଗ୍‍ବଗେ; ଆତେନ୍‌ ସାପା ଜଦି ମୁଇଂ ମୁଇଂ ଡିଙ୍ଗ୍‌ଚେ ଗୁଆର୍‍ ପାବ ତେଲା ଏନ୍ତି ବଇ ପାବାଆର୍‌ ଜେ ନେଙ୍ଗ୍‌ନେ କୁକପାର୍‍ନ୍ନିଆ ବାରି ସାପା ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ଡିଗ୍ ଆତେନ୍‌ ସାପା ବନ୍‍ସା ଜାଗା ଆଡିଙ୍ଗ୍ ପାଡିଙ୍ଗ୍ ।");
INSERT INTO gaq_vpl VALUES ("AC1_1","074_1_1","ACT","1","1","1","ଅ ଥିୟୋଫିଲସ୍‌ ନେଙ୍ଗ୍‍ନେ ପରତୁମ୍‍ ବଇନ୍ନିଆ ଜିସୁ ମେଁନେ କାମ୍ ମୁଲେକ୍ନେ ଦିନ୍‌ବାନ୍‍ ");
INSERT INTO gaq_vpl VALUES ("AC1_2","074_1_2","ACT","1","2","2","ସର୍‍ଗେ ୱେକ୍ନେ ବାନ୍‍ ଆଣ୍ଡିନ୍‍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‍ବଗେ ଆରି ବୁଦି ବିବଗେ ଆତେନ୍‌‍ ସାପା ବିସୟ୍‌ରେ ଗୁଆର୍‍ ମ୍ୱକେ । ସର୍‍ଗେ ୱେନେ ସେନୁଗ୍‍ ଜାଣ୍ଡେକେ ମେଁ ନିଜର୍‌ନେ ସିସ୍‌ ରକମ୍‍ ସ୍ରିବଗେ ଆମେଇଂକେ ମେଁ ପବିତ୍ର ଆତ୍ମାନେ ବପୁରେ ବୁଦି ବିବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC1_3","074_1_3","ACT","1","3","3","ଆତେନ୍‌‍ ବେଲା ମେଁ ମ୍ୱ୍ରଲେଃଗେ, ଏନ୍ ପାର୍‍ମାନ୍‍ ଆଡିଙ୍ଗ୍‍ନ୍‍ସା ଆରି ସିସ୍‍ଇଂନେ ଡାଉଟ୍‍ ସ୍ଲ ଆଡିଙ୍ଗ୍‍ନ୍‍ସା ମେଁ ମେଁନେ ଗୁଏକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଚାଲିସ୍‍ ଦିନା ଜାକ ଗୁଲେତର୍‍ ଆମେଇଂକେ ଦର୍‍ସନ୍‍ ବିଃବଗେ । ମେଇଂ ଜିସୁକେ କେଲେଃଆର୍ଗେ ଆରି ଜିସୁ ଆମେଇଂକେ ଇସ୍‍ପର୍‍ନେ ରାଜି ବିସୟ୍‌ରେ ଆଦ୍ରିଗ୍‍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC1_4","074_1_4","ACT","1","4","4","ମେଇଂ ମୁଇଂନୁଗ୍‍ ରିସିଙ୍ଗ୍‍ଲେ କେଲା ଜିସୁ ଆମେଇଂକେ ଆକେନ୍‍ ଆଦେସ୍‌ ବିକେ: “ଯିରୁସାଲାମ୍‌କେ ଆଆଁନ୍ତାର୍‍ଗେପା । ଆବା ଆପେକେ ମେଃନେ ମ୍ୱିଃଏ ଡାଗ୍‌ଚେ ସପତ୍‍ ଡିଙ୍ଗ୍‍ବକେ ଆରି ଆଣ୍ଡିନେ ଦାନ୍‍ ବିସୟ୍‌ରେ ନେଙ୍ଗ୍‍ ଆପେକେ ବାସଙ୍ଗ୍‍ମ୍ୱଗେ ଆତାନ୍‍ ବା ଜାକ ଉର୍‍ପା । ");
INSERT INTO gaq_vpl VALUES ("AC1_5","074_1_5","ACT","1","5","5","ଜହନ୍‌ ଣ୍ଡିଆନ୍ନିଆ ଡୁବନ୍‌ ବିକେ ମାତର୍‍ ପେଇଂ ଉଡ଼ିଦିନା ବିତ୍‍ରେ ପବିତ୍ର ଆତ୍ମାରେ ଡୁବନ୍‌ ପେବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC1_6","074_1_6","ACT","1","6","6","ମେଁସୁଆ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂ ମୁଇଂନୁଗ୍‍ ଲେଃକେଲା ଜିସୁକେ ସାଲିଆକୁକେ “ମାପ୍‌ରୁ ନା ମେଁନେ ଏବେଆ ଇଶ୍ରାୟେଲୀୟନେ ରେମୁଆଁଇଂକେ ମେଇଂନେ ରାଜି ଆଆଁଣ୍ଡେ ନାବିଏ ?” ");
INSERT INTO gaq_vpl VALUES ("AC1_7","074_1_7","ACT","1","7","7","ଜିସୁ ବାସଙ୍ଗ୍‍କେ, “ବେଲା ଆରି ସେଃମଁ ନେଙ୍ଗ୍‍ ଆବା ମେଁ ସାସନ୍‍ରେ ବକେ । ଆକେନ୍‍ ସାପା ଅଃନା ଗଟେଏ, ପେ ମ୍ୟାଃନେ ଦରକାର୍‌ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC1_8","074_1_8","ACT","1","8","8","ମାତର୍‍ ପେ ଆଡ଼ାତ୍ରା ପବିତ୍ର ଆତ୍ମା ଜାର୍‍ଲା ପେ ବପୁ ପେଡିଙ୍ଗ୍‍ଏ ଆରି ଯିରୁସାଲାମ୍‌ ସାପା ଜିଉଦା ପ୍ରଦେସ୍ ଆରି ଶମିରୋଣୀୟ ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ନେ ଲିଙ୍ଗ୍‍ଡିଆଃକିଗ୍‍ ଜାକ ନେଙ୍ଗ୍‍ ନ୍‌ସା ପେ ସାକି ପେଡିଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC1_9","074_1_9","ACT","1","9","9","ଆକେନ୍‍ ସାପା ସାମୁଆଁ ବାସଙ୍ଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଜିସୁକେ ସର୍‍ଗେ ୱେକ୍ନେ ମେଇଂ କେକେ ଆରି ନ୍ତୁଡ଼ା ତ୍ରିଗ୍‍ଡ୍ୟାଃ ଡାଚେ ମେଁ ଆମେଇଂକେ ମୁଆଃବାନ୍ ମାୟା ଡିଙ୍ଗ୍‍ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC1_10","074_1_10","ACT","1","10","10","ମେଁ ଆଡ଼ାତ୍ରା ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଡିଗ୍‍ ମେଇଂ ମୁଇଂ ଲୟରେ କିତଂଇନିକେ କେଲେଃଆର୍ଗେ । ତୁଲୁଏ ପାଟାଇ ସଃଲେକ୍ନେ ମ୍ୱାୟା ଙ୍ଗିରେ ଟାପ୍‍ନା ମେଇଙ୍ଗ୍ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ଚେ ତୁଆଁଚେ ବାସଙ୍ଗ୍‍କେ ");
INSERT INTO gaq_vpl VALUES ("AC1_11","074_1_11","ACT","1","11","11","“ଅ ଗାଲିଲୀୟଇଂ ମେଃନ୍‌ସା ଆକ୍‍ଅରିଆ ତୁଆଁଚେ କିତଂଇନିକେ କିକେ ପେଡିଙ୍ଗ୍‍କେ ? ଜିସୁ ପେବାନ୍‍ ୱେଚେ ସର୍‍ଗେନ୍ନିଆ କଲେଃକେ । ମାତର୍‍ ମେଁ ଡିରକମ୍‍ ସର୍‍ଗେ ୱେନେ ପେଇଂ ପେକେକେ ଟିକ୍‍ ଦେତ୍‍ରକମ୍‍ ଆଃ ମେଁ ବାରି ଆଁଣ୍ଡେ ପାଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC1_12","074_1_12","ACT","1","12","12","ମେଁ ଇଡ଼ିଙ୍ଗ୍‍ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂ ଜିତ କଣ୍ଡାବାନ୍‍ ଯିରୁସାଲାମ୍‌ ଆଣ୍ଡେ ଆର୍ଗେ । ଜିତ କଣ୍ଡା ସହର୍‍ବାନ୍ ମୁଇଂ କିଲମିଟର୍‍ ସ୍ଲ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC1_13","074_1_13","ACT","1","13","13","ଯିରୁସାଲାମ୍ ୱେଚେ ମେଇଂ ଲେଃଡିଂକ୍ନେ ଆଡ଼ାତ୍ରା ମହଲାନେ ବାକ୍ରାନ୍ନିଆ ଗାଆର୍କେ । ଆତେନ୍‌‍ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ ପିତର୍‍ ଜହନ୍‌ ଜାକୁବ୍‌, ଆଦ୍ରିୟ, ଫିଲିପ୍‌ପ, ଥୋମା, ବାର୍ଥଲମି, ମାତିଉ, ଆଲଫିନେ ଉଂଡେ ଜାକୁବ୍‌, ଦେସ୍‍ପ୍ରେମି ଶିମୋନ ଆରି ଜାକୁବ୍‌ନେ ଉଂଡେ ଜିଉଦା । ");
INSERT INTO gaq_vpl VALUES ("AC1_14","074_1_14","ACT","1","14","14","ମେଇଂ ଉଃଡ଼ିଉଃଡ଼ି ବେଲା ମୁଇଂ ଦଲ୍‍ ଡିଙ୍ଗ୍‍ଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ନ୍‍ସା ମୁଇଂନୁଗ୍‍ ରିସିଂ ଡିଂ ଆର୍ଗେ ଆରି ମେଇଂନେ ଏତେ ଜିସୁନେ ଇୟାଙ୍ଗ୍‍ ମରିୟମ୍‍ ଆରି ବିନ୍‍ବିନ୍‍ ସେଲାମ୍ବୁଏଃ ରେମୁଆଁଇଂ ଆରି ଜିସୁନେ ବୟାଁଇଂ ଡିଗ୍‍ ୱେଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC1_15","074_1_15","ACT","1","15","15","ଆତେନ୍‌ ଦିନା ଇଡ଼ିଙ୍ଗ୍‍ ପ୍ରାୟ୍‍ ମୁଇଂ ସହ ମୁଇଂକୁଡ଼ି ରୁଆ ବିସ୍‌ବାସି ବୟାଁଇଂନେ ମୁଇଂ କୁକପାର୍‌ନ୍ନିଆ ପିତର୍ ତୁଆଁଚେ ବାସଙ୍ଗ୍‍କେ: ");
INSERT INTO gaq_vpl VALUES ("AC1_16","074_1_16","ACT","1","16","16","“ବୟାଁ ଆରି ତନାଇଂ ମୁଡ଼ି ଜିଉଦା ଜିସୁକେ ସାନ୍‍ସା ବିରଦ୍‍ ରେମୁଆଁଇଂକେ ଗାଲି ଆସୁଏବି ବଗେ ମେଁ ବିସୟ୍‌ରେ ଦାଉଦ୍‌ ପବିତ୍ର ଆତ୍ମାନେ ବାନ୍‍ ବବିସତ୍‍ ଇଲ୍‍ଏଁ ଆଃଅଁ ବଆର୍ଗେ । ଦରମ୍‌ ସାସ୍ତର୍‌ ଗୁଆର୍‍କ୍ନେ ଆତେନ୍‌‍ ସାମୁଆଁ ପୁରନ୍‍ ଡିଙ୍ଗ୍‍ନେ ଦର୍‌କାର୍‌ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC1_17","074_1_17","ACT","1","17","17","ଡାଗ୍ଲା ମେଁ ନେଇଂନେ ବିତ୍ରେ ମୁଇଂଡା ଡାଗ୍‌ଚେ ଏଜାବଗେ ଆରି ଆକେନ୍ ସେବା ପଦ୍‌ନ୍ନିଆ ଟାନ୍ ବାଲେଃଆର୍‌ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC1_18","074_1_18","ACT","1","18","18","ମେଁନେ ଅଦର୍ମନେ କାମ୍ ବାନ୍‍ ଜିଉଦା ବାଲେକ୍ନେ ଡାବୁ ଏତେ ମୁଇଂ ଲିଜ ବିଆର୍‍ ବଆର୍ଗେ ବାରି ଆତେନ୍‌‍ ଲିଜନ୍ନିଆ ଲଃଚେ ମେଁ ଗୁଏକେ । ବାରି ମେଁନେ ସୁଲୁଏଃ ତେକ୍‍ପ୍ୟାଃଚେ ସୁଲେଃରେ ତାର୍‍ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC1_19","074_1_19","ACT","1","19","19","ଯିରୂଶାଲମ୍‌ନେ ରେମୁଆଁଇଂ ଆକେନ୍‍ ସାପା ମ୍ୟାଃଚେ ଆତେନ୍‌‍ ଲିଜକେ ମେଇଂନେ ବ୍ନାସାରେ “ଆକେଲ୍‌ ଦାମା” ବା “ମିଆଁ ଲିଜ” ଡାଗ୍‌ଚେ ମ୍ନି ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC1_20","074_1_20","ACT","1","20","20","ପିତର ବାସଙ୍ଗ୍‌ଡିଂକେ, “ଆକେନ୍‍ ବିସୟ୍‌ରେ ଗୀତସଂହିତା ବଇନ୍ନିଆ ଗୁଆର୍‍ ବକେ” “ମେଁନେ ଡୁଆ ରେମୁଆଁ ଗଣ୍ଡ୍‌ ଆଲେଲେ ଆତ୍‍ଅରିଆ ଜାଡିଗ୍‍ ଆବାସାଲେ” ବାରି ଡିଗ୍‍ ଗୁଆର୍‍ ବକେ; “ବିନ୍‍ ରେମୁଆଁ ମେଁନେ କାମ୍‍ନ୍ନିଆ ଗାଲେଃ ।” ");
INSERT INTO gaq_vpl VALUES ("AC1_21","074_1_21","ACT","1","21","21","“ତେସା ମାପ୍‌ରୁ ଜିସୁନେ ଗୁଏଚେ ତଡ଼୍ୟାକ୍ନେ ସାକି ଡିଙ୍ଗ୍‌ନ୍‌ସା ବାରି ମୁଇଂଜା ନେ ଏତେ ଲେଃନେ ଦର୍‌କାର୍‌ । ");
INSERT INTO gaq_vpl VALUES ("AC1_22","074_1_22","ACT","1","22","22","ଜିସୁ ଜହନ୍‌ ବାନ୍‌ ଣ୍ଡିଆଦିକ୍ୟା ବାକ୍ନେ ବେଲାବାନ୍‍ ଆରାମ୍‍ ଡିଙ୍ଗ୍‍ଚେ ନେ ଡାଗ୍ରାବାନ୍‍ ଗୁଏଚେ ତଡ଼ିଆନେ ଦିନା ଜାକ ଉଡ଼ି ବେଲା ମାପ୍‌ରୁ ଜିସୁ ନେ ଏତେ ଅଲେଙ୍ଗ୍‍ ଡିଙ୍ଗ୍‍ନେ ବେଲା ଆଡିନେ ରେମୁଆଁଇଂ ନେ ଦଲ୍‌ନ୍ନିଆ ଲେଃଆର୍‌କେ ମେଇଂନେ ବିତ୍ରେ ମୁଇଂଜାକେ ସାକି ଆଃଡିଙ୍ଗ୍‌ ପଡ଼େଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC1_23","074_1_23","ACT","1","23","23","ଆତ୍‍ବା ମେଇଂ ମ୍ବାୟାକେ ବା ଯୋସେଫ୍‌କେ ଆଜାକେ ବର୍ଶବା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ମ୍ୟାଃକେ ଆରି ଜାନେ ୱାନେ ମ୍ନି ଯୁସ୍ତ, ଆମେକେ ବାରି ମଥିୟସ୍‌କେ ମ୍ବାର୍‍ ବାଗ୍‍ ଆଡିଙ୍ଗ୍‍ଚେ ଦେକ୍‍ ରକମ୍‍ ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ଆର୍କେ ");
INSERT INTO gaq_vpl VALUES ("AC1_24","074_1_24","ACT","1","24","24","ବାରି ପାର୍‌ତନା ଡିଙ୍ଗ୍‌କେ, ଏ “ମାପ୍‌ରୁ ନା ସାପାରେନେ ଚିନ୍ତା ମ୍ୟାନାଡିଂକେ । ଜିଉଦା ମେଁ ନିଜେ ସ୍ରିବକ୍ନେ ଜାଗାନ୍ନିଆ ୱେନ୍‍ସା ଆକେନ୍‍ ସେବା ଆରି ପ୍ରେରିତ୍‍ ପଦବି ବାନ୍‍ ଆନ୍ତାର୍‌ ଲେଃକେ ");
INSERT INTO gaq_vpl VALUES ("AC1_25","074_1_25","ACT","1","25","25","ଜିଉଦା ପଦବିକେ ଗ୍ର‍ଅନ୍‌‍ ଡିଙ୍ଗ୍‍ନେସା ଆକେନ୍‍ ମ୍ୱାୟା ବିତ୍‍ରେ ବାନ୍‍ ନା ଆଜାକେ ସ୍ରି ନାବକେ, ଆତାନ୍‍ ଆସୁଏ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("AC1_26","074_1_26","ACT","1","26","26","ତେନ୍‌ ଇଡ଼ିଂ ମ୍ୱାୟା ସିସ୍‌ ବିତ୍‍ରେ ବାନ୍ ମୁଇଂଜାକେ ସ୍ରିନ୍‍ସା ଲେଟ୍‍ରିକ୍‍ ତ୍ଲାଗ୍‌ଆର୍କେ । ଲେଟ୍‍ରିକ୍‍ ତ୍ଲାଗ୍‍ନ୍ନିଆ ମଥିୟସ୍‌ନେ ମ୍ନିରେ ପୁଟେକେ, ଆତ୍‍ଅରିଆ ମେଁ ଗୋମୁଇଂ ପ୍ରେରିତ୍‌ଇଂ ଏତେ ମିସୁକେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_1","074_2_1","ACT","2","1","1","ପେଷ୍ଟିକସ୍‍ ଦିନା କିସ୍‍ଟ ବିସ୍‌ବାସି ସାପାରେ ମୁଇଂନୁଗ୍‍ ରିସିଙ୍ଗ୍‍ ଲେଃଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_2","074_2_2","ACT","2","2","2","ଉଲୁସ୍ତେ ସାରସାଗାଚେ ୱେଡ଼ିଆ ପାଙ୍ଗ୍‍ନେ ଇଲ୍‍ଏଁ ରକମ୍‍ କିତଂଇନି ଆଡ଼ାତ୍ରା ବାନ୍‍ ମୁଇଂ ଇଲ୍‍ଏଁ ଡିଙ୍ଗ୍‍କେ ଆରି ଆଣ୍ଡିନେ ଡୁଆନ୍ନିଆ ମେଇଂ କଲେଃଆର୍ଗେ, ଆତେନ୍‌‍ ଇଲ୍‍ଏଁ ଡୁଆ ବିତ୍‍ରେ ପାଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_3","074_2_3","ACT","2","3","3","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ କେକେ ଉଡ଼ି ସୁଗୁଆ ସୁଆ ଡୁଆକ୍ନେ ନ୍ଲିୟା ସାପାପାକା ବେପ୍ରେଚେ ଆତ୍‍ଅରିଆ ଲେକ୍ନେ ସାପାରେ ବିତ୍‍ରେ ଗାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_4","074_2_4","ACT","2","4","4","ମେଇଂ ସାପାରେ ପବିତ୍ର ଆତ୍ମାରେ ବପୁ ବାଆର୍‌କେ ଆରି ଆତ୍ମାନେ ଚାଲ୍‍ନାରେ ମେଇଂ ବିନ୍‍ ବିନ୍ ବ୍ନାସାରେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ନେ ମୁଲେ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_5","074_2_5","ACT","2","5","5","ଆକେନ୍ ବେଲା ପେଣ୍ଟିକଷ୍ଟ ପାଣ୍ଡୁଏଃ ପାଲନ୍ ଡିଙ୍ଗ୍‌ନେ ଉଦେସ୍‌ରେ କିତଂଇନି ଆଲ ଲେଆର୍‌କ୍ନେ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ବିନ୍‍ବିନ୍‍ ଦେସ୍‍ବାନ୍‍ ପାଙ୍ଗ୍‍ଲେକ୍ନେ ଜିଉଦି ବକ୍ତଇଂ ଆତେନ୍‌‍ବେଲା ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ୱେଚା ଲେଃଆର୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_6","074_2_6","ACT","2","6","6","ଆକେନ୍‍ ଇଲ୍‍ଏଁ ଅଁକ୍ନେ ଦାପ୍ରେ ମେଇଂନେ ବିତ୍‍ରେବାନ୍‍ ଗୁଲେରୁଆ ପାଙ୍ଗ୍‍ଚେ ରିସିଙ୍ଗ୍‍ ଆର୍କେ । ରେମୁଆଁଇଂ ବକୁଆ ଡିଙ୍ଗ୍‍ୱେଆର୍ଗେ ଡାଗ୍ଲା ମେଇଂ ନିଜେ ଆଣ୍ଡିନେ ବ୍ନାସାରେ ବ୍ନାଇର୍‍ ବାସଙ୍ଗ୍‍ଡିଂଆର୍‍ଗେ ସିସ୍‍ଇଂ ଡିଗ୍‍ ଆତେନ୍‌‍ ବ୍ନାସାରେ ବାଲିର୍‌ ବାତା ଡିଙ୍ଗ୍‍ନେ ଅଁଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_7","074_2_7","ACT","2","7","7","ଆକ୍‍ବା ଜିଉଦିଇଂ ବକୁଆ ଡିଙ୍ଗ୍‍ଚେ ମେଇଂ ବିତ୍‍ରେ ବାଲିର୍‍ବାତା ଆର୍କେ “କେଲାପା ଦେକ୍‍ରକମ୍‍ ବ୍ନାଇର୍‍ ବାସଙ୍ଗ୍‍ନେ ଆକେନ୍‍ ସାପା ରେମୁଆଁ ଗାଲିଲୀୟନେ ଣ୍ଡୁ କି ? ");
INSERT INTO gaq_vpl VALUES ("AC2_8","074_2_8","ACT","2","8","8","ତେଲା ନେ ସାପାରେ ଡିରକମ୍‍ ଆମେଇଂକେ ନେ ନିଜେ ନିଜେନେ ଜନମ୍ ତୁବନେ ବ୍ନାସାରେ ବ୍ନାଲିର୍‍ ବାସଙ୍ଗ୍‍ନେ ଅଁ ନେଲେକେ ? ");
INSERT INTO gaq_vpl VALUES ("AC2_9","074_2_9","ACT","2","9","9","ନେ ପାର୍‍ତିୟ ମାଦିୟ ଆରି ଏଲାମିୟ ବାରି ମେସପଟାମିୟା ଜିଉଦା ପ୍ରଦେସ୍ ଆରି କାପ୍ପାଦକିଆ ପନ୍ତ ଆରି ଆସିଆ ");
INSERT INTO gaq_vpl VALUES ("AC2_10","074_2_10","ACT","2","10","10","ଫ୍ରୁଗିଆ ଆରି ପଂପୁଲିୟା ମିସର୍‌ ଆରି କୁରୁଣୀ ଏରିଆ ଡାଗ୍ରାନେ ଲିବିଆ ଦେସ୍‍ନ୍ନିଆ ବାସା ଲେକ୍ନେ ରେମୁଆଁଇଂ ନେ ବାନ୍‍ ଉଡ଼ିରୁଆ ରୋମ୍‍ ନଗର୍‍ ବାନ୍‍ ପାଙ୍ଗ୍‍ଲେକ୍ନେ ଜିଉଦି ଆରି ଜିଉଦି ଦର୍ମ ଗ୍ର‍ଅନ୍‌‍ ଡିଙ୍ଗ୍‍ଚେ ବାସା ଲେଃଆର୍‌କ୍ନେ ରେମୁଆଁଇଂ; ");
INSERT INTO gaq_vpl VALUES ("AC2_11","074_2_11","ACT","2","11","11","ଆରି ଜିଉଦି ବାରି ଅଣଜିଉଦି ମନ୍‌ ପରିବର୍ତନ୍‌ ଡିଙ୍ଗ୍‌ଲେଃ ଆର୍କେ ଆରି କ୍ରିତ ଆରି ଆରବିୟ ଦେସ୍‍ନେ ରେମୁଆଁ ଜେ ନେ, ନେ ନିଜେ ନିଜେନେ ବ୍ନାସାରେ ଆକ୍ମେଇଂକେ ଇସ୍‍ପର୍‍ନେ ମ୍ନା ମ୍ନା କାମ୍ ଡିଙ୍ଗ୍‍କ୍ନେ ବ୍ନାଇର୍‍ ବାସଙ୍ଗ୍‍ନେ ଅଁନେଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC2_12","074_2_12","ACT","2","12","12","ମେଇଂ ସାପାରେ ବକୁଆ ଆରି ଆକ୍‍ଆନ୍ତ୍‍ ଡିଙ୍ଗ୍‍ଚେ ମେଇଂମେଇଂ ବିତ୍‍ରେ ସାଲିଆକୁନେ ଲାଗେକେ “ଆକ୍ମେନେ ଅର୍‍ତ ମେଁନେ ?” ");
INSERT INTO gaq_vpl VALUES ("AC2_13","074_2_13","ACT","2","13","13","ମାତର୍‍ ବିନ୍‍ ରେମୁଆଁଇଂ ଏଲ୍ୟାଚେ ବାସଙ୍ଗ୍‌ ଆର୍କେ “କ୍ମେଇଂ ମ୍ୱ୍ରେ ଅଙ୍ଗୁର୍‌ ରସ୍‌ ଉଗ୍‌ଚେ ବୁସା ଲେଃଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC2_14","074_2_14","ACT","2","14","14","ତେନ୍‌ ଇଡ଼ିଂ ବିନ୍‍ ଗୋମ୍ୱାର୍ କ୍ଲିଗ୍ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂ ଏତେ ପିତର୍‍ ତୁଆଁଚେ କିରଚେ ବାସଙ୍ଗ୍‍କେ, “ଏ ଜିଉଦି ରେମୁଆଁଇଂ ଆରି ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ବାସା ଡିଙ୍ଗ୍‍ଆର୍‍କ୍ନେ ବଦ୍ର ମଣ୍ଡଲି ନେଙ୍ଗ୍ ବ୍ନାଲିର୍‍ ଅଁପା, ନେଙ୍ଗ୍‍ ଆକେନ୍‍ ସାମୁଆଁ ଆଦ୍ରିଗ୍‍ଚେ ବାସଙ୍ଗ୍‍ମ୍ୱିଏ । ");
INSERT INTO gaq_vpl VALUES ("AC2_15","074_2_15","ACT","2","15","15","ପେ ଜା ଅନ୍‍ମାନ୍‍ ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍କେ, କିମେଇଂ ଉଗ୍‍ସାରେ । ଣ୍ଡୁ କିମେଇଂ ଉଗ୍‍ସାରେ ଣ୍ଡୁ ମାତର୍‍ ଏବେ ବେଲା ଞ୍ଜିର୍‍ ନଟା ଡିଙ୍ଗ୍‍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_16","074_2_16","ACT","2","16","16","ମାତର୍‍ ବାବବାଦି ଯୋୟେଲ୍‍ ଆଣ୍ଡିନେ ଗଟ୍‍ନାନେ ବିସୟ୍‌ରେ ବବିସତ୍‍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ବଗେ ଆକେନ୍‍ ଦେତ୍‍ରକମ୍‍ ମୁଇଂ ଗଟ୍‍ନା ।” ଯୋୟେଲ୍‍ ବାସଙ୍ଗ୍‍ବଗେ; ");
INSERT INTO gaq_vpl VALUES ("AC2_17","074_2_17","ACT","2","17","17","ଇସ୍‍ପର୍‍ ବାସଙ୍ଗ୍‍ମ୍ୟାଃକେ: “ଡାନେ ଦିନାକେଲା ଆକେନ୍‍ ସାପା ଗଟେଏ: ନେଙ୍ଗ୍‍ ସାପାରେନେ ଆଡ଼ାତ୍ରା ନେଙ୍ଗ୍‍ନେ ଆତ୍ମାକେ କିଗ୍ ମ୍ବିଏ । ପେନେ ଗୋ ଗିସିଆଇଂ ବାବବାନି ବାସଙ୍ଗ୍‍ଆର୍‍ଏ । ପେନେ ଙ୍ଗିରେଇଂ ଦିବ୍ୟ ଦର୍‍ସନ୍‍ ବାଆର୍‍ଏ ବାରି ପେନେ ମ୍ନାରେଇଂ ମୁସୁଡ଼ିଙ୍ଗ୍‍ କେଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC2_18","074_2_18","ACT","2","18","18","ଅଁ ନେଙ୍ଗ୍‍ନେ ଦାସ ଦାସୀଇଂ ଆଡ଼ାତ୍ରା ଆତେନ୍‌‍ବେଲା ନେଙ୍ଗ୍‍ ନେଙ୍ଗ୍‍ନେ ଆତ୍ମା କିଗ୍‍ ମ୍ୱିଏ; ମେଇଂ ନେଙ୍ଗ୍‍ନେ ବାବବାନି ବାସଙ୍ଗ୍‍ ଅଲେଙ୍ଗ୍‍ ଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC2_19","074_2_19","ACT","2","19","19","ନେଙ୍ଗ୍‍ କିତଂଇନି ଆଡ଼ାତ୍ରା ବୟ୍‍ଙ୍କାର୍‍ କାମ୍ ଣ୍ଡ୍ରାସୁଏଃଏ ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ ବୁନ୍ଦେ ବୟ୍‍ଙ୍କାର୍‍ ଚିନ୍ ଣ୍ଡ୍ରାସୁଏଃଏ । ମିଆଁ, ସୁଆ ଆରି କିତଙ୍ଗ୍‍ଇନି ମାଃସରେ ମଞ୍ଚ୍‌ପୁର୍‍ ବର୍‌ତି ଡିଙ୍ଗ୍‍ଏ; ");
INSERT INTO gaq_vpl VALUES ("AC2_20","074_2_20","ACT","2","20","20","ମାପ୍‌ରୁନେ ମ୍ନାଃ ଗୌରବ୍‍ମୟ୍‍ ଦିନ୍‌ ପାଙ୍ଗ୍‍ନେ ସେନୁଗ୍‍ ସ୍ନି ତାଙ୍ଗ୍‍କିଗ୍‍ଏ, ଆରି ଆର୍କେ ମିଆଁ ସୁଗୁଆ ଚି ତ୍ନାଏ । ");
INSERT INTO gaq_vpl VALUES ("AC2_21","074_2_21","ACT","2","21","21","ଆତେନ୍‌‍ ବେଲା ଜା ମାପ୍‌ରୁ ମ୍ନିରେ ରକ୍ୟା ବାନ୍‌ସା ୱାଆର୍‌ଏ, ମେଁ ଉଦାର୍‍ ବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC2_22","074_2_22","ACT","2","22","22","“ଏ ଇଶ୍ରାଏଲ୍‌ନେ ରେମୁଆଁଇଂ ଆକେନ୍‍ ସାପା ସାମୁଆଁ ଅଁପା ! ନାଜରିତିୟ ଜିସୁ ଗୁଲେ ଇରିୟାତୁଗ୍‌ନେ କାମ୍ ବୟ୍‍ଙ୍କାର୍‍ କାମ୍ ଆରି ଚିନ୍ ବାନ୍‍ ପେଡାଗ୍ର ଇସ୍‍ପର୍‍ନେ ପ୍ରେରିତ୍‌ ବାଏରେ ଡାଗ୍‍ଚେ ମ୍ୟାପେଲେଃକେ ମେଁ ବାନ୍‍ ଇସ୍‌ପର୍‌ ଜେ ପେ ବିତ୍‍ରେ ବାନ୍‍ ଆକେନ୍‍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‍ବକେ ଆକେନ୍‍ ପେ ନିଜେ ନିଜେ ମ୍ୟାଃପେଲେକେ; ");
INSERT INTO gaq_vpl VALUES ("AC2_23","074_2_23","ACT","2","23","23","ଆତେନ୍‌‍ ରେମୁଆଁ ଇସ୍‍ପର୍‍ନେ ତିଆର୍‌ ଆଡିଙ୍ଗ୍‍ବକ୍ନେ ବେଲା ବାରି ସିସେନେ ଗିଆନ୍‍ ଇସାବ୍‍ରେ ଆଃସାକେ, ପେ ଆମେକେ ଅଦାର୍‍ମିକ୍‍ଇଂନେ ନ୍ତି ବାନ୍‍ କୁରୁସ୍‍ ଆଡ଼ାତ୍ରା ଆଡେଚେ ବାଗୁଏ ପେବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_24","074_2_24","ACT","2","24","24","ମାତର୍‍ ଇସ୍‍ପର୍‍ ଆକେନ୍‍ ସାପା ଗଟେଏ ଡାଗ୍‍ଚେ ସେନୁଗ୍‍ ମ୍ୟାଃଲେଗେ । ଆତେନ୍‌‍ସା ମେଁ ଜିସୁକେ ଆଗୁଏକ୍ନେ ବନ୍ଦନ୍‌ବାନ୍‍ ଆଟିକ୍‍ଚିଚେ ଆମେକେ ବାରି ଆଃତଡ଼୍ୟା ବକେ, ଗୁଏନେ ଆମେକେ ଗାଗ୍‍ଚେ ବ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC2_25","074_2_25","ACT","2","25","25","ଦାଉଦ ମେଁ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‍ବଗେ ।” ନେଙ୍ଗ୍‍ କାଲାଆଃ ମାପ୍‌ରୁକେ ନେଙ୍ଗ୍‍ ସାର୍ମୁଆଁନ୍ନିଆ କେନ୍ଲେଃକେ । ମେଁ ଆନେଙ୍ଗ୍‍କେ ନିରାପଦ୍‍ରେ ବନ୍‍ସା ନେଙ୍ଗ୍‍ନେ ଇଞ୍ଚଙ୍ଗ୍‌ନ୍ତି ପାକା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_26","074_2_26","ACT","2","26","26","ତେସା ନେଙ୍ଗ୍‍ ଜିବନ୍‌ ସାର୍‍ଦାରେ ଲେଃକେ ଆରି ନେଙ୍ଗ୍‍ନେ ନ୍ଲିୟା ସାର୍‍ଦାରେ କଲ୍‍ବଲେ ଡିଙ୍ଗ୍‍କେ ଜଦି ଡିଗ୍‍ ନେଙ୍ଗ୍‍ ଗୁଏରେ ରକମ୍‍ ନ୍ଲେଃଏ ଆରି ନେଙ୍ଗ୍‍ନେ ଗାଗ୍‌ଡ଼େ ଡିଗ୍ ମେଁନେ ଆସାରେ ବ୍ରୁଆଏ ");
INSERT INTO gaq_vpl VALUES ("AC2_27","074_2_27","ACT","2","27","27","ଡାଗ୍ଲା ନା ନିଂନେ ଜିବନ୍‌କେ ନର୍କ କୁଣ୍ଡ୍‌ନ୍ନିଆ ନ୍ନାଆନ୍ତାର୍‍ ଣ୍ଡୁ; ନା ନାନେ ବିସ୍‍ବାସ୍‌ ସେବକକେ ଆତିବକ୍ନେ ଡାଗ୍ରା ମେଃଡିଗ୍‍ କ୍ୟତି ଆଡିଙ୍ଗ୍‍ନେସା ଆନ୍ତାର୍‍ ଆବି ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC2_28","074_2_28","ACT","2","28","28","ନା ଆନେଙ୍ଗ୍‍କେ ଜିବନ୍‍ନେ ଗାଲି ଆକେ ନାବକେ । ନା ପାଙ୍ଗ୍‍ନାଲେଲା ଆନେଙ୍ଗ୍‍ ଜାବର୍‌ ସାର୍‍ଦା ମିଲେଏ । ");
INSERT INTO gaq_vpl VALUES ("AC2_29","074_2_29","ACT","2","29","29","ଏ ଇସ୍ରାଏଲନେ ବୟାଁ ତନାଇଂ ପୁର୍ବ ପୁରୁସ୍‌ ଦାଉଦନେ ବିସୟ୍‌ରେ ନେଙ୍ଗ୍‍ ଆପେକେ କୁଲାକୁଲି ବାବ୍‍ରେ ବାସଙ୍ଗ୍‌ ୟାଏ ଜେ ମେଁ ଗୁଏକେ ଆରି ଆମେକେ ଆତି ଆର୍କେ ଆରି ମେଁନେ ଗୁଡ଼ୁମ୍‌ ଏଃଜାକ ନେଡାଗ୍ରା ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_30","074_2_30","ACT","2","30","30","ମେଁ ମୁଇଂ ବାବବାଦି ଲେଃଗେ । ତେସା ମେଁ ଆଡ଼ାତ୍ରା ଇସ୍‌ପର୍‌ନେ ପାର୍‌ମାନ୍ ଡିଂକ୍ନେ ସାମୁଆଁ ମ୍ୟାଃଲେଗେ । ଦାଉଦ୍‍ନେ ବଂସଦର୍‍ବାନ୍‍ ମୁଇଂଜାକେ ଇଃସାଙ୍ଗ୍‌ ଆଡିଙ୍ଗ୍‌ ଡାଗ୍‍ଚେ ଇସ୍‍ପର୍‍ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍‍ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_31","074_2_31","ACT","2","31","31","ଇସ୍‍ପର୍‍ ବବିସତ୍‍ରେ ମେଁନେ ଡିଙ୍ଗ୍‍ନେ ୱେଡିଂକେ ଦାଉଦ୍‍ ମ୍ୟାଃଚେ କିସ୍‌ଟ ମସିହନେ ଗୁଏଚେ ତଡ଼ିଆନେ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‍ବକେ; ମେଁ ଗୁଏଡିଙ୍ଗ୍‍ନେ ରେମୁଆଁଇଂନେ ନର୍କ କୁଣ୍ଡ୍‌ନ୍ନିଆ ଆଆଁନ୍ତାର୍‍କେ ଣ୍ଡୁ । ମେଁନେ ଗାଗ୍‌ଡ଼େ ଆତିବକ୍ନେ ଡାଗ୍ରା ଡିଗ୍‍ ଆର୍‍ବୁଗ୍‌କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC2_32","074_2_32","ACT","2","32","32","ଇସ୍‍ପର୍‍ ଆକେନ୍‍ ଜିସୁକେ ଗୁଏକ୍ନେ ବାନ୍‍ ଆତଡ଼ିଆ ବକେ । ନେ ସାପାରେ ଆକ୍ମେନେ ସାକି ନେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_33","074_2_33","ACT","2","33","33","ଜିସୁ ମେଁନେ ଆବା ଇସ୍‍ପର୍‍ନେ ଇଞ୍ଚଙ୍ଗ୍‍ତି ପାକା ତଃଡ଼୍ୟା ଲେଃକେ ଆରି ଆବାନେ ପାର୍‌ମାନ୍‌ ଡିଂକ୍ନେ ଇସାବ୍‍ରେ ମେଁ ବାନ୍‍ ପବିତ୍ର ଆତ୍ମା ବା ଲେଃକେ । ଏବେ ପେ ମେଁନେ କିକେ ପେଡିଙ୍ଗ୍‍କେ ଆରି ଅଁ ପେଡିଙ୍ଗ୍‍କେ ଆତେନ୍‌‍ ମେଁନେ ଦାନ୍‍ । ଆତେନ୍‌‍ ମେଁ ନେ ଆଡ଼ାତ୍ରା କିଗ୍‍ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_34","074_2_34","ACT","2","34","34","ଡାଗ୍ଲା ଦାଉଦ ନିଜେ କିତଂଇନି ୱେଆଲେଗେ; ମାତର୍‍ ମେଁ ନିଜେ ବାସଙ୍ଗ୍‍ବଗେ, ଇସ୍‍ପର୍‍ ନେଙ୍ଗ୍‍ନେ ମାପ୍‌ରୁକେ ବାସଙ୍ଗ୍‍କେ, ");
INSERT INTO gaq_vpl VALUES ("AC2_35","074_2_35","ACT","2","35","35","ନେଙ୍ଗ୍‍ ପେନେ ସତ୍ରୁଇଂକେ ପେନେ ଞ୍ଚବୁନ୍ଦେ ଡୁଙ୍ଗ୍‍ମାପାଙ୍ଗ୍‍ ଜାକ ପେ ନେଙ୍ଗ୍‍ନେ ଇଞ୍ଚଙ୍ଗ୍‍ନ୍ତି ପାକା କ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("AC2_36","074_2_36","ACT","2","36","36","“ଆତେନ୍‌‍ସା ଇଶ୍ରାୟେଲୀୟଇଂ ସାପାରେ ସତ୍‍ ବାବ୍‍ରେ ମ୍ୟାଃଆର୍‍ଲେ ଜେ ମୁଡ଼ି ଜିସୁକେ ପେଇଂ କୁରୁସ୍‌ନ୍ନିଆ ଆଡେଚେ ପେବାଗୁଏକେ ଇସ୍‍ପର୍‍ ଆମେକେ ଆଃ ମାପ୍‌ରୁ ଆରି କିସ୍‌ଟ ମସିହ ଆଡିଙ୍ଗ୍‍ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC2_37","074_2_37","ACT","2","37","37","ରେମୁଆଁଇଂ ଆକେନ୍‍ ସାପା ସାମୁଆଁ ଅଁଚେ ଜିବନ୍‌ ଦାଡ଼୍‍କେ ୱେକେ ଆରି ପିତର୍‍ ବାରି ବିନ୍‍ ପ୍ରେରିତ୍‌ଇଂ ସିସ୍‌ଇଂକେ ସାଲିଆକୁକେ “ବୟାଁଇଂ ନେ ସାପାରେ ମେଁ ନେଡିଙ୍ଗ୍‍ପା ?” ");
INSERT INTO gaq_vpl VALUES ("AC2_38","074_2_38","ACT","2","38","38","ପିତର୍‍ ଆମେଇଂକେ ଉତର୍‍ ବିକେ “ପେ ସାପାରେ ପାପ୍‍ କାମ୍ ବାନ୍‍ ମନ୍‍କେ ପରିବର୍ତନ୍‌ ଆଡିଙ୍ଗ୍‍ପା ପାପ୍‍ ବାନ୍‍ କେମା ବାନ୍‍ସା ଜିସୁ କିସ୍‌ଟନେ ମ୍ନିରେ ଡୁବନ୍‌ ଡୁଂଡଲାପା; ତେଲା ପେ ଇସ୍‍ପର୍‍ନେ ଦାନ୍‍ ପବିତ୍ର ଆତ୍ମାକେ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("AC2_39","074_2_39","ACT","2","39","39","ଡାଗ୍ଲା ଇସ୍‌ପର୍‌ନେ ପାର୍‌ମାନ୍‌ ଡିଂକ୍ନେ ପେ ଆଡ଼ାତ୍ରା ଆରି ପେନେ ଗୋ ଗିସିଆଇଂ ଆଡ଼ାତ୍ରା ଆରି ଇସ୍‍ପର୍‍ ବାନ୍‍ ପାଙ୍ଗ୍‍ଲେକ୍ନେ ରେମୁଆଁଇଂ ନ୍‌ସା ଆରି ସୁଲ ଲେଡିଙ୍ଗ୍‍କ୍ନେ ସାପା ରେମୁଆଁଇଂ ନ୍‌ସା ମାପ୍‌ରୁ ଦର୍‌କାର୍ ।” ");
INSERT INTO gaq_vpl VALUES ("AC2_40","074_2_40","ACT","2","40","40","ପିତର୍‍ ଆମେଇଂକେ ଗୁଲେ ସାମୁଆଁରେ ସାକି ବିଚେ ବାସଙ୍ଗ୍‌କେ “ଆକେନ୍‍ ଦଦ୍ୟା‍ ରେମୁଆଁଇଂନେବାନ୍ ନିଜେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("AC2_41","074_2_41","ACT","2","41","41","ମେଇଂନେ ବାନ୍‍ ଗୁଲେରୁଆ ମେଁନେ ବ୍ନାଲିର୍‍କେ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଚେ ଣ୍ଡିଆଃନ୍ନିଆ ଦିକ୍ୟା ଡୁଂଡନେ ମନ୍‌ ଡିଂଆର୍କେ । ଆରି ଆତେନ୍‌‍ ଦିନା ପ୍ରାୟ୍ ଞ୍ଜି ଅଜାର୍‍ ରେମୁଆଁ ମଣ୍ଡଲି ଏତେ କୁଡ଼େ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_42","074_2_42","ACT","2","42","42","ଆତେନ୍‌‍ ଦିନା ବାନ୍‍ ସିସ୍‌ଇଂ ଆମେଇଂକେ ଗ୍ୟାନ୍‌ ବିଆର୍‌କେ । ଆରି ମେଇଂ ନ୍ତୁଗ୍‌ ଚଙ୍ଗ୍‌ଉଗ୍‌ ବାରି ପାର୍‌ତନା ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ନେ ବାନ୍‌ ସାପାରେ ମିସୁଚେ ଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_43","074_2_43","ACT","2","43","43","ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ଗୁଲେ ବପୁନେ ଆରି ଇରିଆତୁଗ୍‍ ରକମ୍‍ନେ କାମ୍ ଡିଙ୍ଗ୍‍ଆର୍କେ ବାରି ସାପାରେ ଆକେନ୍‍ ଚିନ୍ କେଚେ କାବା ଡିଂଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_44","074_2_44","ACT","2","44","44","ବିସ୍‍ବାସିଇଂ ମେଇଂମେଇଂ ଏତେ କୁଡ଼େମାଡ଼େ ଆର୍କେ ବାରି କୁଡ଼େଚେ ମେଇଂନେ ସାପା ଲିଜବ୍ରି ଆବା ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_45","074_2_45","ACT","2","45","45","ମେଇଂ ନିଜେ ନିଜେନେ ଲେକ୍ନେଡିଗ୍‍ ଆରି ଣ୍ଡୁ ଣ୍ଡିଙ୍ଗ୍‍ ଲିଜବ୍ରିକେ ସଃଚେ ଲେକ୍ନେ ଲିଜବ୍ରି ସାପାରେନେ ମାବାନେ ଇସାବ୍‍ରେ ମେଇଂମେଇଂ ବିତ୍‍ରେ ବିଃଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC2_46","074_2_46","ACT","2","46","46","ମେଇଂ କାଲାଆଃ ମନ୍ଦିର୍‌ନ୍ନିଆ ମୁଇଂ କୁଦା ସୁଗୁଆ ମୁଇଂନ୍ନିଆ ରିସିଂ ଡିଂ ଆର୍କେ ବାରି ସାର୍‍ଦା ମନ୍‌ରେ ବାରି ସାଦୁରେ ");
INSERT INTO gaq_vpl VALUES ("AC2_47","074_2_47","ACT","2","47","47","ଇସ୍‍ପର୍‍କେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‍ଚେ ମୁଇଂଜା ବିନ୍‍ ରେମୁଆଁନେ ଡୁଆ ଅରିଆ ଉଗ୍‍ଚଙ୍ଗ୍‍ ଆର୍‍ ଡିଙ୍ଗ୍‍ଗେ । ବାରି ସାପା ରେମୁଆଁଇଂନେ ନିଜର୍‌ ଉଂଡେ ଡିଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌ ଆର୍‍ଗେ ବାରି, ମାପ୍‌ରୁ, ପରିତ୍ରାନ୍‍ ବ୍‍ବାଡିଙ୍ଗ୍‌କ୍ନେ ରେମୁଆଁଇଂକେ କାଲାଆଃ ମଣ୍ଡଲି ଏତେ ଆକୁଡ଼େ ଡିଡିଙ୍ଗ୍‌ଡିଙ୍ଗ୍‌ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_1","074_3_1","ACT","3","1","1","ମେସୁଆ ପିତର୍‍ ଆରି ଜହନ୍‌ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ନେ ବେଲା ଲମ୍‍ଡିଗ୍‍ ତିନ୍‍ଟା ବେଲା ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ନେ ମନ୍ଦିର୍‌ନ୍ନିଆ ୱେଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_2","074_3_2","ACT","3","2","2","ଆତ୍‍ଅରିଆ ମୁଇଂ “ସୁନ୍ଦର୍‍” ମ୍ନିକ୍ନେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ଡାଗ୍ରା ମୁଇଂ ରେମୁଆଁ ଲେଃଗେ । ମେଁ ଇୟାଙ୍ଗ୍‍ଡେନେ ସୁଲୁଏଃବାନ୍‍ ଆଃ ଚଟା ଡିଙ୍ଗ୍‍ଚେ ଜନମ୍‍ ପାଙ୍ଗ୍‍ଲେଗେ । ମନ୍ଦିର୍‌ନ୍ନିଆ ୱେଡିଂକ୍ନେ ରେମୁଆଁଇଂନେବାନ୍‍ ବିକ୍‍ ସାଲିଆନ୍‍ସା କାଲାଆଃ ମେଁ ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ଡାଗ୍ରା ଆମେକେ ଡୁଙ୍ଗ୍‍ଚେ ଆତ୍‍ଅରିଆ ଏବ ଡିଙ୍ଗ୍‍ଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_3","074_3_3","ACT","3","3","3","ପିତର୍‍ ଆରି ଜହନ୍‌କେ ମନ୍ଦିର୍‍ ବିତ୍‍ରେ ୱେନେ କେଚେ ମେଁ ଆତେନ୍‌‍ ମ୍ୱାୟାକେ ବିକ୍‍ ସାଲିଆକେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_4","074_3_4","ACT","3","4","4","ପିତର ବାରି ଜହନ୍‌ ମେଇଂ ଆଡ଼ାତ୍ରା ନିମାଣ୍ତା ବାବ୍‌ରେ କେକେ ପିତର୍‍ ବାସଙ୍ଗ୍‍କେ “ନେ ପାକା କେଲା !” ");
INSERT INTO gaq_vpl VALUES ("AC3_5","074_3_5","ACT","3","5","5","ତେସା ମେଁ ମେଇଂନେ ବାନ୍‍ ମେଃଡିଗ୍‍ ବାନେ ଆସାରେ ମେଇଂନେ ପାକା କିକେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_6","074_3_6","ACT","3","6","6","ମାତର୍‍ ପିତର୍‍ ଆମେକେ ବାସଙ୍ଗ୍‍କେ “ନେଙ୍ଗ୍‍ ଡାଗ୍ରା ସୁନା କି ରୁପା ଣ୍ଡୁ ମାତର୍‍ ମେଁନେ ଲେଃକେ ନେଙ୍ଗ୍‍ ଆନାକେ ବିଣ୍ଡିଂକେ: ନାଜରିତିୟ ଜିସୁ କିସ୍‌ଟନେ ମ୍ନିରେ ନେଙ୍ଗ୍‍ ଆଦେସ୍‍ ବିଣ୍ଡିଂକେ ତଃଡ଼ିଆଚେ ଅଲେଙ୍ଗ୍‍ !” ");
INSERT INTO gaq_vpl VALUES ("AC3_7","074_3_7","ACT","3","7","7","ଆକେନ୍‍ ବାସଙ୍ଗ୍‍ଚେ ମେଁ ଇଞ୍ଚଙ୍ଗ୍‍ନ୍ତି ସାଚେ ଆତଡ଼ିଆକେ । ଆତେନ୍‌‍ ଦାପ୍ରେ ଆତେନ୍‌‍ ରେମୁଆଁନେ ପାଦ୍‍ ଞ୍ଚ ଆରି ଞ୍ଚନେ ମାଣ୍ଡି ଗଟିଇଂ ଡାଟାମ୍‍ ଡିଙ୍ଗ୍‍କେ ");
INSERT INTO gaq_vpl VALUES ("AC3_8","074_3_8","ACT","3","8","8","ମେଁ ପୁଏଚେ ତୁଆଁକେ ଆରି ଅଲେଙ୍ଗ୍‍ନେ ମୁଲେକେ । ତେନ୍‌ଇଡ଼ିଂ ମେଁ ଅଲେଙ୍ଗ୍‍ ଅଲେଙ୍ଗ୍‌ ଆରି ପୁଏ ପୁଏଚେ ଇସ୍‍ପର୍‍ନେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‍ ଡିଙ୍ଗ୍‍ ମେଇଂ ଏତେ ମନ୍ଦିର୍‌ନ୍ନିଆ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_9","074_3_9","ACT","3","9","9","ଆତ୍‍ଅରିଆ ଲେକ୍ନେ ରେମୁଆଁ ସାପାରେ ଆମେକେ ଅଲେଙ୍ଗ୍‍ନେ ଆରି ଇସ୍‍ପର୍‍କେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‍ନେ କେକେ; ");
INSERT INTO gaq_vpl VALUES ("AC3_10","074_3_10","ACT","3","10","10","ଆମେକେ ମନ୍ଦିର୍‌ନେ ସୁନ୍ଦର୍‍ ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ଡାଗ୍ରା କଲେଃକ୍ନେ ବିକାରି ଡାଗ୍‍ଚେ ସାମୁଆଁ ଆର୍କେ ଆରି ମେଁ ଆଡ଼ାତ୍ରା ମେଁନେ ଗଟେ ଲେଃଗେ ସାପା ମ୍ୟାଃଚେ ମେଇଂ ଇରିୟାଃତୁଗ୍‌ଚେ କାବା ଡିଙ୍ଗ୍‌ୱେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_11","074_3_11","ACT","3","11","11","ଆତେନ୍‌‍ ରେମୁଆଁ ପିତର ଆରି ଜହନ୍‌ ଏତେ ଲେଃନେ କେଚେ ରେମୁଆଁଇଂ ବକୁଆ ଡିଙ୍ଗ୍‍ଚେ ଶଲୋମନ୍‌ନେ ପ୍ଲେଡ଼ିଆ ଡାଗ୍ରା ୱିର୍‍ ଡୁଂୱେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_12","074_3_12","ACT","3","12","12","ପିତର୍‌ ଆମେଇଂକେ କେଚେ ବାସଙ୍ଗ୍‍କେ “ଏ ଇଶ୍ରାଏଲ୍‌ନେ ବୟାଁଇଂ ପେ ମେସା ଆକ୍‍ଅରିଆ ବକୁଆ ଡିଙ୍ଗ୍‍ଚେ ନେପାକା ଦେକ୍‍ ରକମ୍‍ କେପେଲେକେ ? ପେ ମେଁନେ ବାବେ ପେଡିଙ୍ଗ୍‍କେ ଜେ ନେ ନିଜେ ବପୁରେ ଆରି ଇସ୍‍ପର୍‍ନେ ବକ୍ତିରେ ନେ ଆକେନ୍‍ ରେମୁଆଁକେ ଅଲେଙ୍ଗ୍‍ନେ ବପୁ ବିଃନେବକେ ? ");
INSERT INTO gaq_vpl VALUES ("AC3_13","074_3_13","ACT","3","13","13","ଅବ୍ରାହାମ୍‍ ଇସ୍‌ହାକ୍‍ ଆରି ଜାକୁବ୍‌ନେ ଇସ୍‌ପର୍‌ ନେନେ ନ୍ତା ଞ୍ଜାଇଂ ଇସ୍‍ପର୍‍ ମେଇଂନେ ସେବକ୍‌ ଜିସୁକେ ଗୌରବ୍‌ନିତ୍‌ ଆଡିଙ୍ଗ୍‍ବକେ; ଆତେନ୍‌‍ ଜିସୁକେ ପେଇଂ ଆଃସା ପେବିକେ ଆରି ଅନାବେଲା ପୀଲାତ ଆମେକେ ଆନ୍ତାର୍‌ ନ୍‌ସା ରାଜି ଡିଙ୍ଗ୍‍ଲେଗେ । ଆତେନ୍‌‍ବେଲା ଆମେକେ ପେ ପୀଲାତନେ ସାମ୍‍ନେ ଅବିସ୍‌ବାସ୍‌ ପେଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_14","074_3_14","ACT","3","14","14","ମେଁ ମୁଇଂ ଦାର୍‌ମିକ୍‌ ଆରି ପବିତ୍ର ରେମୁଆଁ; ମାତର୍‍ ପେ ଆମେକେ ଅବିସ୍‌ବାସ୍‌ ପେଡିଙ୍ଗ୍‍କେ ଆରି ମେଁ ବାଦୁଲ୍‍ ମୁଇଂ ରେମୁଆଁ ବାଗୁଏରେକେ ଆନ୍ତାର୍‍ନ୍‍ସା ପିଲାତକେ ପାର୍‍ତନା ପେଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_15","074_3_15","ACT","3","15","15","ଜା ଜିବନ୍‍ନେ ଗାଲି ଆସୁଏ ଡିଙ୍ଗ୍‍କ୍ନେ ରେମୁଆଁକେ ପେ ପେବାଗୁଏକେ ମାତର୍‍ ଇସ୍‍ପର୍‍ ଆମେକେ ଗୁଏକ୍ନେ ବାନ୍‍ ଆଃତଡ଼୍ୟା ବକେ । ନେ କ୍ମେନେ ସାକି ନେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_16","074_3_16","ACT","3","16","16","ଆକେନ୍‍ ମୁଡ଼ି ରେମୁଆଁକେ ପେ କିକେ ପେଡିଙ୍ଗ୍‍କେ ଆରି ସାମୁଆଁ ପେଲେକେ ମେଁ ଜିସୁ ମ୍ନିରେ ବପୁ ବାଚେ ଅଲେଙ୍ଗ୍‍ ଇଁୟାକେ । ଜିସୁନେ ମ୍ନିରେ ନେନେ ବିସ୍‌ବାସ୍‌ ଲେଃକେ । ଆରି ଜିସୁ ଆଡ଼ାତ୍ରା ଲେକ୍ନେ ବିସ୍‍ବାସ୍‍ ଆଃ ପୁରାପୁରି ବାବ୍‍ରେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‍ ବିକେ ଆରି ଆତେନ୍‌‍ ପେ କେପେଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC3_17","074_3_17","ACT","3","17","17","“ଅ ଇସ୍ରାଏଲନେ ବୟାଁଇଂ ଆରି ତନାଇଂ ପେ ଆରି ପେନେ ନେତାଇଂ ଜିସୁ ଆଡ଼ାତ୍ରା ମେଁନେ ପେଡିଙ୍ଗ୍‍କେ ଆତେନ୍‌‍ ମାମ୍ୟାଚେ ଡିଙ୍ଗ୍‍ପେବକେ ଆକେନ୍‍ ନେଙ୍ଗ୍‍ ମ୍ୟାଃନ୍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_18","074_3_18","ACT","3","18","18","ଇସ୍‌ପର୍‌ କିସ୍‌ଟ ଦୁକ୍‍ ବଗେନେ ବିସୟ୍‌ରେ ଅଃସେ ବାନ୍‍ ଆଃ ସାପା ସାମୁଆଁ ବାବବାଦିଇଂନେ ତୁମୁଆଃବାନ୍ ବାସଙ୍ଗ୍‍ ଆଡା ବଗେ । ଏବେ ପର୍‍ମେସର୍‍ ଆକେନ୍‍ ସାପା ଗଟ୍‌ନା ଆଃଗଟେ ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_19","074_3_19","ACT","3","19","19","ଆତେନ୍‌‍ସା ପେ ମନେ ଏତେଚେ ଇସ୍‌ପର୍‌ ପାକା ଆଣ୍ଡେ ପାଙ୍ଗ୍‍ଲା । ତେଲା ମେଁ ପେନେ ପାପ୍‍ କେମା ଡିଙ୍ଗ୍‍ଏ ");
INSERT INTO gaq_vpl VALUES ("AC3_20","074_3_20","ACT","3","20","20","ଦେକ୍‍ ରକମ୍‍ ପେଡିଙ୍ଗ୍‍ଲା ମାପ୍‌ରୁ ଆପେକେ ଆତ୍ମାନେ ସାନ୍ତି ବିଏ, ମେଁନେ ମନନିତ୍‌ କିସ୍‌ଟ ଜିସୁକେ ଡିଗ୍‍ ମେଁ ପେ ଡାଗ୍ରା ବେ ବିଃଏ । ");
INSERT INTO gaq_vpl VALUES ("AC3_21","074_3_21","ACT","3","21","21","ବାର୍‌ମୁଇଂତର୍‍ ସାପା କାମ୍ ଡିଙ୍ଗ୍‍ ଜାକ ଜିସୁ କିତଂଇନି ଲେଃ ପଡ଼େଏ । ଆକେନ୍‍ ସାମୁଆଁ ବିସୟ୍‌ରେ ଇସ୍‍ପର୍‍ ପୁର୍ବେକାଲ୍‍ନେ ପବିତ୍ର ବାବବାଦିଇଂ ବାନ୍‍ ବାସଙ୍ଗ୍‍ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_22","074_3_22","ACT","3","22","22","ମୋଶା ବାସଙ୍ଗ୍‍ବଗେ, ‘ମାପ୍‌ରୁ ଇସ୍‍ପର୍‍ ପେନେ ବୟାଁଇଂନେ ବିତ୍ରେବାନ୍ ପେ ନ୍‌ସା ନେଙ୍ଗ୍‌ ରକମ୍ ମୁଇଂ ବାବବାଦିକେ ବେଏ । ଆତେନ୍‌‍ ବାବବାଦି ପେ ବିତ୍‍ରେ ବାନ୍‍ ପାଙ୍ଗ୍‍ଏ । ମେଁ ନେଙ୍ଗ୍‍ ସୁଗୁଆ ଡିଙ୍ଗ୍‍ଏ । ମେଁ ମେଁନେ ବାସଙ୍ଗ୍‍ଏ ଆତେନ୍‌‍ ପେ ମାନେଃ ପଡ଼େଏ । ");
INSERT INTO gaq_vpl VALUES ("AC3_23","074_3_23","ACT","3","23","23","ମାତର୍ ଡେକ୍‌ରକମ୍ ଗଟେଏ ଜେ ମୁଡ଼ି ରେମୁଆଁ ଆତେନ୍‌ ବାବବାଦିନେ ସାମୁଆଁ ଆମାନେ ଆମେକେ ଇସ୍‌ପର୍‌ନେ ରେମୁଆଁଇଂନେବାନ୍ ବିନେ ଆଡିଂଚେ ବିନସ୍ଟ ଆଡିଂଏ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC3_24","074_3_24","ACT","3","24","24","ଏବେ ଜା ଗଟେ ଡିଙ୍ଗ୍‍କେ ଶାମୁୟେଲ୍‌ ଆରି ମେଁ ଇଡ଼ିଙ୍ଗ୍‍ ପାଙ୍ଗ୍‍ଲେକ୍ନେ ସାପା ବାବବାଦିଇଂ ଆତେନ୍‌‍ ବିସୟ୍‌ରେ ବାଲିର୍‍ ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC3_25","074_3_25","ACT","3","25","25","ବାବବାଦିଇଂନେ ସାର୍‌ମୁଆଁ ଇସ୍‌ପର୍‌ ଆଡିନେ ସାପା ପାର୍‌ମାନ୍‌ ଡିଙ୍ଗ୍‌ବକେ ଆତାନ୍‌ ପେଇଂ ନ୍‌ସା ଦର୍‌କାର୍‌ ବାରି ଇସ୍‍ପର୍‍ ପେଇଂନେ ଅଃସେ ନ୍ତା ଞ୍ଜା ଇଂନେ ଏତେ ଆଡିନେ ନିୟମ୍‌ ତିଆର୍‌ ଡିଙ୍ଗ୍‌ବକେ ପେଇଂ ଆତ୍‌ଅରିଆ ବାଗିଦାରି । ଇସ୍‍ପର୍‍ ଅବ୍ରାହାମ୍‍କେ ବାସଙ୍ଗ୍‌ବକେ ପେଇଂନେ ବଁସ୍‌କୁଲ୍‌ ଇଂ ବାନ୍‌ ନେଙ୍ଗ୍‌ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସାପା ଜାତିକେ ଆସିର୍‌ବାଦ୍‌ ଣ୍ତିଙ୍ଗ୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC3_26","074_3_26","ACT","3","26","26","ପର୍‍ମେସର୍‍ ଆପେକେ ଆସିର୍‌ବାଦ୍‌ ଡିଙ୍ଗ୍‍ନ୍‍ସା ସେନୁଗ୍‍ ନିଜେନେ ସେବକ୍‌ ଜିସୁକେ ବେବକେ । ପେ ଜେନ୍ତିକି ଦଦ୍ୟା‍ କାମ୍ ପେଡିଂ ଆତେନ୍‌‍ସା ମେଁ ଦେକ୍‍ରକମ୍‍ ବାସଙ୍ଗ୍‍ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC4_1","074_4_1","ACT","4","1","1","ପିତର୍‍ ଆରି ଯହନ୍‍ ରେମୁଆଁଇଂକେ ଦେକ୍‍ରକମ୍‍ ବୁଦି ବିଡିଙ୍ଗ୍‍ନେ ବେଲା ମନ୍ଦିର୍‍ନେ ଉଡ଼ିରୁଆ ପୁଜାରି ମନ୍ଦିର୍‍ ଉର୍‍ଣ୍ଡ୍ରେଇଂନେ ସେନାପତି ଆରି ଉଡ଼ିରୁଆ ସାଦୁକୀଇଂ ପିଙ୍ଗ୍‍ଚାଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_2","074_4_2","ACT","4","2","2","ମେଇଂ ରିସାଡିଙ୍ଗ୍‍ ୱେଲେଆର୍‌ଗେ ଡାଗ୍ଲା ପିତର୍‍ ଆରି ଯହନ୍‍ ରେମୁଆଁଇଂକେ ସିକ୍ୟା ବିଡିଙ୍ଗ୍‍ଗେ ଆରି ଜିସୁନେ ସାମୁଆଁ ସାଃଚେ ଗୁଏକ୍ନେ ରେମୁଆଁଇଂବାନ୍‍ ଗୁଏଚେ ତଃଡ଼୍ୟାନେ ବିସୟ୍‍ରେ ବାସଙ୍ଗ୍‍ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_3","074_4_3","ACT","4","3","3","ତେସା ମେଇଂ ଜେଲ୍‍କାନାନ୍ନିଆ ପିତର୍‍ ଆରି ଯହନ୍‍କେ ବନ୍ଦି ଆଡିଙ୍ଗ୍‍ବି ଆର୍କେ । ଆତେନ୍‌‍ ଦିନା ଜାବର୍‌ ଜିଲମ୍‍ ଡିଙ୍ଗ୍‍ ୱେଲେଲା ଆମେଇଂକେ ମାର୍‍ତଡ଼େ ଜାକ ଜେଲ୍‍କାନା ବିତ୍‍ରେ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_4","074_4_4","ACT","4","4","4","ମାତର୍‍ ଗୁଲେ ରୁଆ ମେଇଂନେ ବୁଦି ଦ୍ରିଗ୍‍ଚେ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ ଆରି ଙ୍ଗିରେଇଂନେ ସଂକ୍ୟା ମ୍ନାଚେ ପ୍ରାୟ୍ ମାଲ୍ ଅଜାର୍‍ ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_5","074_4_5","ACT","4","5","5","ମାର୍‍ତଡ଼େ ଜିଉଦି ନେତାଇଂ ମନ୍ଦିର୍‌ ବିନ୍‌ବିନ୍‌ ରେମୁଆଁଇଂ ବାରି ଦରମ୍‌ ଗୁରୁଇଂ ଯିରୁସାଲାମ୍‌ ମୁଇଂ ଅରିଆ ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_6","074_4_6","ACT","4","6","6","ମେଇଂ ହାନାନ କୟାଫା ଜହନ୍‌ ଆଲେକ୍‍ଜାଣ୍ତାର୍‍ ବାରି ମ୍ନା ପୁଜାରି ଡୁଆଣ୍ଡ୍ରେନେ ବିନ୍‍ରେକେ କୁଡ଼େ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_7","074_4_7","ACT","4","7","7","ମେଇଂ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂକେ ସାମ୍‍ନେ ଆତୁଆଁଚେ ସାଲିଆକୁଆର୍କେ, “ଜାନେ ବପୁରେ ବା ଜା ମ୍ନିରେ ଆକେନ୍‍ ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍ ?” ");
INSERT INTO gaq_vpl VALUES ("AC4_8","074_4_8","ACT","4","8","8","ପିତର୍ ପବିତ୍ର ଆତ୍ମାନେ ବପୁ ବାଚେ ଆମେଇଂକେ ଉତର୍‍ ବିକେ “ଜିଉଦି ଜାତିନେ ଇଃସାଙ୍ଗ୍‌ ଆରି ଦର୍ମ ନେତାଇଂ ! ");
INSERT INTO gaq_vpl VALUES ("AC4_9","074_4_9","ACT","4","9","9","ଜଦି ଏକେ ନେ ଆକେନ୍‍ ଚଟା ନ୍‍ସା ଡିଙ୍ଗ୍‍ ନେବକ୍ନେ ବଲ୍‍ କାମ୍ ବିସୟ୍‌ରେ ପେଇଂ ପ୍ରସ୍‌ନ ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍ ଆରି ମେଁ ଡିରକମ୍‍ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍କେ ଡାଗ୍‌ଚେ ମ୍ୟାଃନ୍‍ସା ଚାଏଁପେଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_10","074_4_10","ACT","4","10","10","ତେଲା ପେ ଆରି ଇଶ୍ରାୟେଲୀୟନେ ସାପା ମ୍ୟାନ୍‍ସା ଦର୍‍କାର୍‍ ଜେ ପେ ସାମ୍‍ନେଆ ତୁଆଁ ଲେକ୍ନେ ଆକେନ୍‍ ରେମୁଆଁ କେବଲ୍‍ ନାଜରିତିୟ ଜିସୁ କିସ୍‌ଟନେ ମ୍ନିନେ ବପୁରେ ପୁରାପୁରି ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍ଲେକେ । ଆତେନ୍‌‍ ଜିସୁକେ ପେ କୁରୁସ୍‌ନ୍ନିଆ ଆଡେଚେ ପେବାଗୁଏକେ । ମାତର୍‍ ଇସ୍‍ପର୍‍ ଆମେକେ ଗୁଏକ୍ନେ ବାନ୍ ଆତଡ଼ିଆବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_11","074_4_11","ACT","4","11","11","ଜିସୁନେ ବିସୟ୍‍ରେ ଆଃ ଦର୍ମସାସ୍ତର୍‌ନ୍ନିଆ ଗୁଆର୍‍ବକେ, ଆଣ୍ଡିନେ ବ୍ରିକେ ଡୁଆ ଆରେଡ୍ରେ ଆମେକେ ଦର୍‍କାର୍‍ ଣ୍ଡୁ ଡାଗ୍‍ଚେ ଜଗ୍‌ତ୍ଲାଗ୍‍ବଗେ । ମାତର୍‍ ଆତେନ୍‌‍ ବ୍ରି ଏକେ କନ୍‍ନେ ମୁଲ୍‌ ବ୍ରି ଡିଙ୍ଗ୍‍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_12","074_4_12","ACT","4","12","12","ଆମେ ଆନ୍ତାର୍‌ଲା ଆରି ଜାଡାଗ୍ରା ଉଦାର୍ ଣ୍ଡୁ; ଡାଗ୍ଲା ଜାନେ ବାନ୍ ଆନେକେ ଉଦାର୍‍ ବାନେ ଡିଂଏ କିତଂଇନି ଆଲ ରେମୁଆଁଇଂନେ ବିତ୍ରେବାନ୍ ଆରି ମେଃଡିଗ୍ ମ୍ନି ବିଆବକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC4_13","074_4_13","ACT","4","13","13","ପିତର ଆରି ଜହନ୍‌ ଅସିକିତ୍‍ ଆରି ସାଦାସିଦା ରେମୁଆଁ ଲେଃଗେ ଡାଗ୍‌ଚେ ମ୍ନାଃ କୁକପାର୍‌ନେ ସଦସ୍ୟଇଂ ମ୍ୟାଃଲେଆର୍ଗେ । ତେସା ମ୍ୱାୟା ସିସ୍‍ନେ ସାହାସ୍‍ କେଚେ ମେଇଂ ବକୁଆ ଡିଙ୍ଗ୍‍ୱେଆର୍ଗେ । ବାରି ମେଇଂ ମ୍ୟାଃଲେଆର୍ଗେ, ଆତେନ୍‌‍ ମ୍ୱାୟା ଜିସୁ ଏତେ ଲେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_14","074_4_14","ACT","4","14","14","ମାତର୍ ମେଇଂ ବିରଦ୍‍ ଡିଙ୍ଗ୍‍ଚେ ମେଃଡିଗ୍‍ ବାସଙ୍ଗ୍‍ ଆୟାଆର୍କେ ଣ୍ଡୁ; ଡାଗ୍ଲା ମେଁ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍ଲେକ୍ନେ ରେମୁଆଁକେ ପିତର୍‍ ଆରି ଯହନ୍‍ ଏତେ ତୁଆଁଲେକ୍ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_15","074_4_15","ACT","4","15","15","ମେଇଂ ସବାବାନ୍‍ ତାର୍‍ୱେ ନ୍‍ସା ଆଦେସ୍‍ ବିଃଆର୍‌କେ । ତେନ୍‌ ଇଡ଼ିଂ ନେତାଇଂ ମେଃ ଡିଙ୍ଗ୍‍ଆର୍‍ଏ, ଆତେନ୍‌‍ ବିସୟ୍‌ରେ ମେଇଂ ବିତ୍‍ରେ ବାଲିର୍‌ ବାତା ଡିଙ୍ଗ୍‍ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_16","074_4_16","ACT","4","16","16","ମେଇଂ ବାସଙ୍ଗ୍‍ଆର୍କେ “ନେ ଆକ୍ମେଇଂ ଆଡ଼ାତ୍ରା ମେଃ ନେଃଡିଂପା ? କିମେଇଂ ଡିଙ୍ଗ୍‍ବକ୍ନେ କାବା କାମ୍ ବିସୟ୍‍ରେ ଯିରୂଶାଲମ୍‌ନେ ସାପାରେ ମ୍ୟାଃଲେଆର୍ଗେ । ଆକେନ୍‍ ସତ୍‍କେ ନେ ଆରି ଅବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‍ ନେୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC4_17","074_4_17","ACT","4","17","17","ମାତର୍‍ ଆକେନ୍‍ ବ୍ନାଇର୍‍ ଜେନ୍ତିକି ରେମୁଆଁଇଂ ଡାଗ୍ରା ଜାବର୍‌ ଉଡ୍ରା ଆଡିଙ୍ଗ୍‍ ଆରି ଜିସୁନେ ମ୍ନିରେ ଜା ଡାଗ୍ରା ଡିଗ୍‍ ମେଃଡିଗ୍‍ ମାବାସଙ୍ଗ୍‍ ନ୍‌ସା ଆକ୍ମେଇଂକେ ନେ ସାବ୍‍ଦାନ୍‍ ଆଡିଙ୍ଗ୍‍ ନେବିପା ।” ");
INSERT INTO gaq_vpl VALUES ("AC4_18","074_4_18","ACT","4","18","18","ତେସା ମେଇଂ ପିତର୍‍ ଆରି ଯହନ୍‍କେ ବାର୍‌ମୁଇଂତର୍‍ ବିତ୍‍ରେ ୱାଆର୍କେ ଆରି ଅନାଡିଗ୍‍ ଜିସୁନେ ମ୍ନିରେ ମେଃଡିଗ୍‍ ସାମୁଆଁ ମାବାସଙ୍ଗ୍‍ ନ୍‍ସା ଆରି ସିକ୍ୟା ମାବିନ୍‍ସା ତରକ୍‍ ଆଡିଙ୍ଗ୍‍ବି ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_19","074_4_19","ACT","4","19","19","ମାତର୍‍ ପିତର ଆରି ଜହନ୍‌ ଆମେଇଂକେ ଉତର୍‍ ବିଃକେ, “ପର୍‍ମେସର୍‍ନେ ଆଦେସ୍‌ ଆନ୍ତାର୍‍ଚେ ପେନେ ଆଦେସ୍‌ ପାଲନ୍‍ ଡିଙ୍ଗ୍‍ନେ ନେନେ ଟିକ୍‌ କି ଣ୍ଡୁ, ଆତେନ୍‌‍ ପେ ବିଚାର୍‌ ଡିଙ୍ଗ୍‍ପା । ");
INSERT INTO gaq_vpl VALUES ("AC4_20","074_4_20","ACT","4","20","20","ନେ ମେଃନେ କେନେଲେକେ ଆରି ଅଁନେଲେକେ ଆତେନ୍‌‍ ରେମୁଆଁଇଂକେ ମାବାସଙ୍ଗ୍‍ଚେ ଲେଃନେୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC4_21","074_4_21","ACT","4","21","21","ଆତ୍‍ବା ମେଇଂ ରେମୁଆଁଇଂକେ କେଚେ ଆମେଇଂକେ ଡଣ୍ଡ୍‍ ବିନେ ମେଃଡିଗ୍‍ ଉପାୟ୍‍ ମାବାଚେ ଆମେଇଂକେ ଅଦିକ୍‍ ଆପ୍‍ଟଚେ ଆନ୍‍ତାର୍‍ବି ଆର୍କେ ତେସା ମେଃନେ ଗଟେ ଲେଃଗେ ଆତେନ୍‌‍ସା ରେମୁଆଁ ସାପାରେ ଇସ୍‍ପର୍‍ନେ ମ‍ଇମା ଡିଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_22","074_4_22","ACT","4","22","22","ମୁଡ଼ି ରେମୁଆଁ କାବା କାମ୍‍ରେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍ଲେଗେ ମେଁନେ ବୟସ୍‍ ଚାଲିସ୍‍ ମୁଆଃବାନ୍ ଅଦିକା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_23","074_4_23","ACT","4","23","23","ପିତର୍‍ ଆରି ଯହନ୍‍କେ ଆନ୍ତାର୍‍ବିନେ ସଙ୍ଗେ ସଙ୍ଗେ ମେଇଂନେ ଦଲ୍‍ନ୍ନିଆ ଆଣ୍ଡେ ୱିଗ୍‍ଗେ ଆରି ମ୍ନା ପୁଜାରି ଆରି ଦର୍ମ ନେତାଇଂ ମେଃନେ ବାସଙ୍ଗ୍‍ବଗେ ଆତେନ୍‌‍ ଆମେଇଂକେ ଆମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_24","074_4_24","ACT","4","24","24","ବିସ୍‍ବାସିଇଂ ସାପା ସାମୁଆଁ ଅଁକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ସାପାରେ ମୁଇଂନୁଗ୍‍ ରିସିଙ୍ଗ୍‍ଚେ ଇସ୍‍ପର୍‍ଡାଗ୍ରା ଆକେନ୍‍ ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ଆର୍କେ “ଏ ମାପ୍‌ରୁ ! କିତଂଇନି ମଞ୍ଚ୍‌ପୁର୍‌ କେଣ୍ଡିଆ ଆରି ଆତ୍‍ ଅରିଆ ଲେଡିଙ୍ଗ୍‍କ୍ନେ ସାପା କିଚି ତିଆର୍‍ ଡିଙ୍ଗ୍‍ ନାବକେ ! ");
INSERT INTO gaq_vpl VALUES ("AC4_25","074_4_25","ACT","4","25","25","ନେନେ ଅଃସେଣ୍ଡ୍ରେ ଦାଉଦ ନାନେ ସେବକ୍‌ ଲେଃଗେ । ମେଁ ପବିତ୍ର ଆତ୍ମାନେ ବାନ୍‍ ଆକେନ୍‍ ବ୍ନାଇର୍‍ ଗୁଆର୍‍ ବକେ ‘ଆକେନ୍‍ ଅଣଜିଉଦିଇଂ ମେଃନ୍‌ସା ୱିଙ୍ଗ୍‌ଆଃ ରିଙ୍ଗ୍‍ଆ ଡିଙ୍ଗ୍‍ ଆର୍‍ ଡିଙ୍ଗ୍‍କେ ? ଆକେନ୍‍ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ରେମୁଆଁଇଂ ମେଃନ୍‌ସା ପର୍‍ମେସର୍‍ ବିରଦ୍‍ରେ ଦଦ୍ୟା‍ ଚିନ୍ତା ବାବେ ଡିଙ୍ଗ୍‍ ଆର୍‍ଙ୍କେ ? ଆକେନ୍‍ ସାପା ଦର୍‌କାର୍‌ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC4_26","074_4_26","ACT","4","26","26","ମାପ୍‌ରୁନେ ବିରଦ୍‍ରେ ଆରି ମେଁନେ ମସିହନେ ବିରଦ୍‍ରେ ମଞ୍ଚ୍‌ପୁର୍‍ନେ ଇଃସାଙ୍ଗ୍‌ଇଂ ତୁଆଁ ଆର୍‍କେ ଆରି ସାସନ୍‍ ଡିଂଣ୍ଡ୍ରେ ମୁଇଂନ୍ନିଆ ରିସିଙ୍ଗ୍‍ ଆର୍କେ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC4_27","074_4_27","ACT","4","27","27","ଡାଗ୍ଲା ନାନେ ମୁଃଡ଼ି ପବିତ୍ର ଦାସ୍ ଜିସୁକେ ନାଁ ନାସ୍ରିକେ ପକ୍‌ରୁତ୍‌ରେ ଆକେନ୍‍ ନଗରିନ୍ନିଆ ହେରୋଦ ଆରି ପନ୍ତିୟ ପୀଲାତ ଅଣଜିଉଦି ଆରି ଇଶ୍ରାୟେଲୀୟନେ ରେମୁଆଁଇଂ ଏତେ କୁଡ଼େଚେ ପେବାନ୍‍ ବାଚେ ପେବକ୍ନେ ଜିସୁକେ ପେନେ ପବିତ୍ର ଦାସ୍‌ନେ ବିରଦ୍‍ରେ ଜଜ୍‌ନା ପେଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_28","074_4_28","ACT","4","28","28","ପେନେ ବପୁ ଆରି ପେନେ ଇକ୍‌ଚାରେ ଜା ସାପା ଆଃଗଟେ ନ୍‍ସା ପେ ତିଆର୍‍ ଆଡିଙ୍ଗ୍‍ ପେବଗେ ମେଇଂ ରିସିଙ୍ଗ୍‍ଚେ ଆତେନ୍‌‍ ସାପା ଡିଙ୍ଗ୍‍ନ୍‍ସା ଲାଗେ ପଡ଼େଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_29","074_4_29","ACT","4","29","29","ଅ ମାପ୍‌ରୁ, ଏବେ ମେଇଂ ଆନେକେ ଡିରକମ୍‌ ଦମକ୍‍ ବିବକେ, ନା ଆତେନ୍‌‍ ବିସୟ୍‌ରେ ଦ୍ରିଗ୍‍ ଆରି ଦାସ ଦାସୀଇଂକେ ବର୍‌କସ୍‌ ବାବ୍‌ରେ ନାନେ ବ୍ନାଇର୍‍ ବାସଙ୍ଗ୍‍ ଅଲେଙ୍ଗ୍‍ ନ୍‍ସା ବପୁ ବିଲା । ");
INSERT INTO gaq_vpl VALUES ("AC4_30","074_4_30","ACT","4","30","30","ନାନେ ବପୁ ଆନେକେ ଆସୁଏ ଜାଣ୍ଡେଃବାନ୍‌ କି ନେ ସାଆସ୍‍ରେ ନାନେ ପବିତ୍ର ଦାସ୍‌ ଜିସୁନେ ମ୍ନିରେ ରଗିଇଂକେ ନିମାଣ୍ଡା ଆଃଡିଙ୍ଗ୍‍ ନ୍‍ସା ଗୁଲେ ଚିନ୍ ଆସୁଏ ନ୍‍ସା ଆରି କାବା ରକମ୍‍ କାମ୍ ଡିଙ୍ଗ୍‍ ନେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC4_31","074_4_31","ACT","4","31","31","ପାର୍‌ତନା ଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଆଣ୍ଡିନ୍‍ ଡୁଆନ୍ନିଆ ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍ଗେ ଆତ୍‍ଅରିଆ ସାପାରେ ରିସିଙ୍ଗ୍‍ଲେ ଆର୍ଗେ । ଆତେନ୍‌‍ ଡୁଆ ଲିଗିର୍ ୱେକେ । ମେଇଂ ସାପାରେ ପବିତ୍ର ଆତ୍ମା ବାଚେ ପର୍‍ମେସର୍‍ନେ ସାମୁଆଁ ସାହାସ୍‍ରେ ବାସଙ୍ଗ୍‍ ଅଲେଙ୍ଗ୍‍ନ୍‍ସା ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_32","074_4_32","ACT","4","32","32","ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଲେ ଆର୍‍କ୍ନେ ରେମୁଆଁଇଂନେ ମୁଇଂ ମନ୍‌ ମୁଇଂ ଆତ୍ମାରେ ଲେଃଆର୍‌ଗେ । ମେଇଂନେ ବିତ୍‍ରେ ଜାଡିଗ୍‍ ମେଁ ଜିନିସ୍‌କେ ଡିଗ୍‍ ନିଜେନେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ ଆଡିଙ୍ଗ୍‍ ଆର୍‍ ଣ୍ଡୁ । ମେଇଂ ଡାଗ୍ରା ମେଁନେ ଲେଃଗେ ଆତ୍‍ଅରିଆ ସାପାରେନେ ବାଟା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_33","074_4_33","ACT","4","33","33","ମାପ୍‌ରୁ ଜିସୁ ଜା ସତ୍‍ରେ ଗୁଏଚେ ତଃଡ଼୍ୟା ଲେଃକେ ଆକେନ୍‍ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ମ୍ନା ବପୁରେ ସାକି ବିଆର୍‌କେ । ପର୍‍ମେସର୍‍ ସାପା ବିସ୍‍ବାସିଇଂକେ ଗୁଲେ ଅନୁଗ୍ର‍ଅ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_34","074_4_34","ACT","4","34","34","ମେଇଂନେ ବିତ୍‍ରେ ଆଜାକେ ଡିଗ୍‍ ଅବାବ୍‍ ଆଲେଗେ ଣ୍ଡୁ । ଜାନେ ଡୁଆ ବା ଲିଜ ଲେଃଗେ ମେଁ ଆତେନ୍‌‍ ସାପା ସଚେ ଡାବୁ ଡୁଂପାଙ୍ଗ୍‍ଚେ, ");
INSERT INTO gaq_vpl VALUES ("AC4_35","074_4_35","ACT","4","35","35","ମେଇଂ ଆତେନ୍‌‍ ସମ୍ପତିକେ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂନେ ଞ୍ଚଆଲ ବଡିଙ୍ଗ୍‍ଆର୍ଗେ । ସାପାରେକେ ନିଜେନେ ଉଡ଼ି ଦର୍‍କାର୍‍ ଅଃକେନ୍‌ ଇସାବ୍‍ରେ ଡାବୁ ବାଟା ବିଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_36","074_4_36","ACT","4","36","36","ଯସେପ୍‍ ମ୍ନିରେ ମୁଇଂ ବିସ୍‍ବାସ୍‍ ରେମୁଆଁ ଲେଃଗେ । ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ଆମେକେ “ବର୍ଣ୍ଣବା” ମ୍ନିରେ ୱାଡିଙ୍ଗ୍‍ ଆର୍ଗେ । ଆକେନ୍‍ ମ୍ନିନେ ଅର୍‌ତ “ସାଇଜ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେ” ମେଁ ସାଇପ୍ରସ୍‌ ମ୍ନିକ୍ନେ ଜାଗାନ୍ନିଆ ମୁଇଂ ଲେବୀୟ ବଂସନ୍ନିଆ ଜନମ୍ ଡିଙ୍ଗ୍‌ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC4_37","074_4_37","ACT","4","37","37","ଯସେପ୍‍ନେ ଇକୁଡ଼ା ଲିଜ ଲେଃଗେ । ମେଁ ଆମେକେ ସ ଜଗ୍‍ତ୍ଲାଗ୍‍ଚେ ସକ୍ନେ ସାପା ଡାବୁ ଡୁଂପାଙ୍ଗ୍‍ଚେ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂକେ ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_1","074_5_1","ACT","5","1","1","ହନନୀୟ ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁ ଆରି ମେଁନେ କୁନେଡ଼େ ଶଫୀରା ମେଇଂନେ ଲିଜ ବ୍ରି ସବିଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_2","074_5_2","ACT","5","2","2","ମାତର୍‍ କୁନେଣ୍ଡେନେ ଦନ୍‍ ସମ୍ପତି ଡୁଂୱେଚେ ହନନିୟା ସକ୍ନେ ଉଡ଼ି ଦନ୍‍ ନିଜେ ଆତ୍‍ଲା ବଚେ ବାକି ସାପା ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂକେ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_3","074_5_3","ACT","5","3","3","ପିତର୍ ଆମେକେ ବାସଙ୍ଗ୍‍କେ “ହନନୀୟ ନା ମେନ୍‌ସା ସ‍ଇତାନ୍‌ ନା ଜିବନ୍‌ ଅରିଆ ପୁରାପୁରି ବାବ୍‌ରେ ଅଦିକାର୍‌ ଡିଙ୍ଗ୍‌ବକେ ? ନେ ସାମୁଆଁ ସାଚେ ଲିଜ ବ୍ରି ସଃଚେ ଆତ୍‍ବା ବାନାଲେକ୍ନେ ଡାବୁବାନ୍‍ ଉଡ଼ି ସୁଗୁଆ ନା ଆତ୍‍ଲା ବଚେ ପବିତ୍ର ଆତ୍ମା ଡାଗ୍ରା ମିଚ୍‍ ନାବାସଙ୍ଗ୍‍କେ ? ");
INSERT INTO gaq_vpl VALUES ("AC5_4","074_5_4","ACT","5","4","4","ଦନ୍‍ ସମ୍ପତି ସନେ ସେନୁଗ୍‍ ଆତେନ୍‌‍ ନାନେ ଲେଃଗେ; ସନେ ଇଡ଼ିଙ୍ଗ୍‍ ଡିଗ୍‍ ଆତେନ୍‌‍ ମେଁନେ ନାନେ ଆଲେଗେ ? ତେଲା ନା ମେଃନ୍‌ସା ଦେକ୍‍ରକମ୍‍ କାମ୍ ଡିଙ୍ଗ୍‍ନ୍‍ସା ମନ୍‌ ନାବାବେକେ ? ନା ରେମୁଆଁଇଂକେ ନାଜଟେକେ ଣ୍ଡୁ ମାତର୍‍ ଇସ୍‍ପର୍‍ ଡାଗ୍ରା ମିଚ୍‍ ବାସଙ୍ଗ୍‍ ନାବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_5","074_5_5","ACT","5","5","5","ହନନୀୟ ଆକେନ୍‍ ସାମୁଆଁ ଅଁକ୍ନେ ଦାପ୍ରେ ତୁବଃନ୍ନିଆ ଲଃଚେ ଗୁଏଃୱେଗେ । ଆକେନ୍‍ ସାମୁଆଁ ଅଁଚେ ରେମୁଆଁଇଂ ଜାବର୍‌ ବୁଟମେଗ୍‌ ୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_6","074_5_6","ACT","5","6","6","ତେନ୍‌ ଇଡ଼ିଂ ଙ୍ଗିରେଇଂ ହନନିୟାନେ ଗୁଏକ୍ନେ ଗାଗ୍‍ଡ଼େକେ ପାଟାଇ ଏତେ ଡାଚେ ପାଦାପାକା ଡୁଂୱେଚେ ଆତି ବିଃଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_7","074_5_7","ACT","5","7","7","ଞ୍ଜି ଗଣ୍ଟା ଇଡ଼ିଙ୍ଗ୍‍ ହନନିୟାନେ କୁନେଣ୍ଡେ ପିଙ୍ଗ୍‍ଚାକେ । ମେଁ ଆକେନ୍‍ ଗଟ୍‍ନା ବିସୟ୍‍ରେ ମ୍ୟାଃଆଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_8","074_5_8","ACT","5","8","8","ପିତର୍‍ ଆମେକେ ସାଲିଆକୁକେ “ନା ଆରି ନା ଆଣ୍ଡା ଆଣ୍ଡିନେ ଲିଜ ବ୍ରି ପେସକେ ଆତେନ୍‌‍ ମେଁନେ ଅଃକେନ୍‍ ଦାମ୍‍ରେ ପେସକେ କି ?” ମେଁ ଉତର୍‍ ବିକେ “ଅଁଃ ଅଁ ଅଃତେନ୍‌‍ ଦାମ୍‍ରେ ସ ନେବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_9","074_5_9","ACT","5","9","9","ପିତର୍‍ ଆମେକେ ବାସଙ୍ଗ୍‍କେ, “ମାପ୍‌ରୁନେ ଆତ୍ମାକେ ପରିକ୍ୟା ଡିଙ୍ଗ୍‍ନେସା ନା ଆରି ନା ଆଣ୍ଡା ମେଃନ୍‌ସା ରାଜି ପେଡିଙ୍ଗ୍‍କେ ? ଜାଣ୍ଡେଇଂ ନା ଆଣ୍ଡାକେ ଆତି ଆର୍କେ ମେଇଂ ଏବେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ଡାଗ୍ରା ୱେଚାଆର୍ଗେ । ଆନାକେ ଡିଗ୍‍ ମେଇଂ ପାଦାପାକା ଗୁଃ ଡୁଂୱେଆର୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_10","074_5_10","ACT","5","10","10","ଆତେନ୍‌‍ ସେଲାମ୍ବୁଏଃ ଡିଗ୍‍ ମେଁନେ ଞ୍ଚବୁନ୍ଦେ ଲଃଚେ ଗୁଏଃୱେଗେ । ତେନ୍‌ ଇଡ଼ିଂ ଙ୍ଗିରେଇଂ ବିତ୍‍ରେ ପାଙ୍ଗ୍‍ଚେ ଆମେକେ ଗୁଏ ଲେକ୍ନେ କେଚେ ଆମେକେ ଡୁଙ୍ଗ୍‍ ରାଙ୍ଗ୍‌ୱେଆର୍‍ଗେ ଆରି ମେଁନେ ଆଣ୍ଡାଣ୍ଡେକେ ଆତିବକ୍ନେ ଡାଗ୍ରା ଆମେକେ ଆତି ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_11","074_5_11","ACT","5","11","11","ମଣ୍ଡଲିନେ ସାପା ବିସ୍‌ବାସି ଆରି ବିନ୍‍ ସାପା ରେମୁଆଁ ଜାଣ୍ଡେଇଂ ଆକେନ୍‍ ସାମୁଆଁ ଅଁ ଆର୍‍କେ ମେଇଂ ଜାବର୍‌ ବୁଟମେଗ୍‌ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_12","074_5_12","ACT","5","12","12","ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂନେ ନ୍ତି ବାନ୍‍ ରେମୁଆଁଇଂ ବିତ୍‍ରେ ଜାବର୍‌ ଚିନ୍ ଆରି କାବା କାମ୍‍ଇଂ ଡିଙ୍ଗ୍‍ଆର୍କେ । ଆରି ସାପା ମଣ୍ଡଲି ମୁଇଂ ଉଦେସ୍‍ରେ ଶଲୋମନ୍‌ନେ ମଣ୍ଡପ୍‌ନ୍ନିଆ ରିସିଙ୍ଗ୍‍ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_13","074_5_13","ACT","5","13","13","ମେଇଂ ଏତେ କୁଡ଼େଚେ ତୁଆଁ ନ୍‍ସା ଜାଡିଗ୍‍ ସାହାସ୍‍ ଆଡିଙ୍ଗ୍‍ଆର୍‌ଗେ ଣ୍ଡୁ । ସାପାରେ ପ୍ରେରିତ୍‌ଇଂକେ ମାଲେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_14","074_5_14","ACT","5","14","14","ଇସ୍‍ପର୍‍ଡାଗ୍ରା ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେଇଂ ଗୁଲେ ଙ୍ଗିରେ ଆରି ସେଲାମ୍ବୁଏଃ ମାପ୍‌ରୁନେ ଏତେ ଦଲ୍‍ନ୍ନିଆ କୁଡ଼େ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_15","074_5_15","ACT","5","15","15","ଆରି ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେଇଂ ଦିନ୍‍କେ ଦିନ୍‍ ମ୍ନାନେ ଲାଗେକେ । ତେସା ରେମୁଆଁଇଂ ରଗ୍‍ ସା ଲେଃକେଣ୍ଡ୍ରେଇଂକେ ଗାଲିଡାଗ୍ରା କଟ୍‌ନ୍ନିଆ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ ଆର୍କେ ଜେନ୍ତିକି ପିତର୍‍ନେ ଲୁଡ଼ିଆ ୱେ ୱିଗ୍ କେଲା ରଗ୍‍ ସାଃଲେକ୍ନେ ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଆତେନ୍‌‍ ଲୁଡ଼ିଆ ବାଏ ଆରି ଆତେନ୍‌‍ ଲୁଡ଼ିଆବାନ୍‍ ରଗିଇଂ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍ଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC5_16","074_5_16","ACT","5","16","16","ଯିରୂଶାଲମ୍‌ନେ ଡାଗ୍ରା ସହର୍‍ଇଂବାନ୍‍ ରେମୁଆଁଇଂ ମେଇଂନେ ରଗ୍‍ ସାଃଲେକ୍ନେ ରେମୁଆଁଇଂକେ ଆରି ଜାଣ୍ଡେଇଂକେ ବୁତ୍‌ ସାଲେଗେ ଆମେଇଂକେ ସାଚେ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ ଆର୍‍ ଡିଙ୍ଗ୍‍ଗେ ଆରି ମେଇଂ ସାପାରେ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍ଚେ ୱେଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_17","074_5_17","ACT","5","17","17","ତେନ୍‌ ଇଡ଼ିଂ ମ୍ନା ପୁଜାରି ଆରି ମେଇଂନେ ସାପା ରେମୁଆଁଗଣ୍ଡ୍‍ଇଂ ଆରି ସାଦୁକୀ ଦଲ୍‍ନେ ରେମୁଆଁଇଂ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂନେ ଆଡ଼ାତ୍ରା ଜାବର୍‌ ରିସାଡିଙ୍ଗ୍‍ଚେ ମେଇଂନେ ବିରଦ୍‍ରେ ତଡ଼ିଆ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_18","074_5_18","ACT","5","18","18","ମେଇଂ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂକେ ଗାଗ୍‍ଚେ ଡାଆଁ କ‍ଇଦ୍ ଡୁଆ ବିତ୍‍ରେ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_19","074_5_19","ACT","5","19","19","ମାତର୍‍ ମାପ୍‌ରୁନେ ମୁଇଂ ଦୁତ୍‍ ମିଡିଗ୍‍ବ ଆତେନ୍‌‍ ଜେଲ୍‍କାନାନେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ସାପା ରଃଚେ ଆମେଇଂକେ ଆତାର୍‍ ବିଚେ ବାସଙ୍ଗ୍‍କେ, ");
INSERT INTO gaq_vpl VALUES ("AC5_20","074_5_20","ACT","5","20","20","“ପେ ମନ୍ଦିର୍‌ନ୍ନିଆ ୱେଚେ ତୁଆଁପା ଆରି ରେମୁଆଁଇଂକେ ମାପ୍‌ରୁ ଜିସୁ ବିବକ୍ନେ ଆକେନ୍‍ ନୁଆଁ ଜିବନ୍‍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_21","074_5_21","ACT","5","21","21","ଆକେନ୍‍ ଅଁଚେ ପ୍ରେରିତ୍‌ଇଂ ଞ୍ଜିର୍‍ନୁଗ୍‍ ମନ୍ଦିର୍‍ ୱେଚେ ରେମୁଆଁଇଂକେ ବ୍ନାଇର୍‍ ଆଃ ଅଁକେ । ଆକେନ୍‍ ବେଲା ମ୍ନା ପୁଜାରି ଆରି ମେଇଂନେ ରେମୁଆଁଗଣ୍ଡ୍‍ଇଂ ଆତେନ୍‌‍ ମନ୍ଦିର୍‍ନେ ବିନ୍‍ ଡାଗ୍ରା ୱେଚାଚେ ଇଶ୍ରାୟେଲୀୟନେ ମ୍ନା ମ୍ନା ରେମୁଆଁଇଂକେ ମୁଇଂ କୁକପାର୍‍ ଆଃକ ନ୍‍ସା ୱାକେ । ମେଇଂ ପ୍ରେରିତ୍‌ଇଂ ଜେଲ୍‌କାନାବାନ୍‍ ୱାଡୁଂପାଙ୍ଗ୍‍ ନ୍‍ସା ଉଡ଼ିରୁଆକେ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_22","074_5_22","ACT","5","22","22","ମାତର୍‍ ଆତେନ୍‌‍ ଚାକ୍‍ରିଆରେଇଂ ଜେଲ୍‍କାନା ବିତ୍‍ରେ ପ୍ରେରିତ୍‌ଇଂକେ ମାଅବାଚେ ୱିଗ୍‌ଆର୍ଗେ ଆରି ମ୍ନା କୁକପାର୍‌ନ୍ନିଆ ଆମ୍ୟାଃଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_23","074_5_23","ACT","5","23","23","“ନେ ଜେଲ୍‌କାନା ବିତ୍‍ରେ ନିମାଣ୍ଡା ବାବ୍‍ରେ କୁଚି ତ୍ଲାଗ୍‍ବକ୍ନେ ନେକେକେ ଆରି ଉର୍‍ଣ୍ଡ୍ରେଇଂକେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ଡାଗ୍ରା ତୁଆଁ ଲେକ୍ନେ ଡିଗ୍‍ ନେକେକେ । ମାତର୍‍ ନେ ଅନାବେଲା ଜେଲ୍‌କାନା ରଃଚେ ନେକେକେ ଆତେନ୍‌‍ବେଲା ଆତ୍‍ ଅରିଆ ଜା ଡିଗ୍‍ ଆଲେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_24","074_5_24","ACT","5","24","24","ଆକେନ୍‍ ସାମୁଆଁ ଅଁଚେ ମନ୍ଦିର୍‍ନେ ମ୍ନାରେ ଆରି ମ୍ନା ପୁଜାରି ବକୁଆ ଡିଙ୍ଗ୍‍ୱେଆର୍ଗେ ଆରି “ଆକେନ୍‍ ଗଟ୍‍ନା ମେଃନେ ଡିଙ୍ଗ୍‍ଏ ଆକେନ୍‍ ବାବେଚେ ସାପାରେ ବୁଦିବାନା ଡିଙ୍ଗ୍‍ୱେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_25","074_5_25","ACT","5","25","25","ଟିକ୍‍ ଆତେନ୍‌‍ବେଲା ଆଃ ମୁଇଂଜା ପାଙ୍ଗ୍‍ଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‍କେ “କେଲାପା ! ପେ ଆଜାକେ ଜେଲ୍‍କାନା ବିତ୍‍ରେ ଗାଗ୍‍ଚେ ପେବକେ ମେଇଂ ମନ୍ଦିର୍‍ ଡାଗ୍ରା ତୁଆଁଚେ ରେମୁଆଁଇଂକେ ମାପ୍‌ରୁ ସାମୁଆଁ‍ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_26","074_5_26","ACT","5","26","26","ତେସା ସେନାପତି ଆତେନ୍‌‍ ଚାକ୍‍ରିଆରେଇଂକେ ୱା ଡୁଂୱେଚେ ପ୍ରେରିତ୍‌ଇଂକେ ୱା ଡୁଂପାଙ୍ଗ୍‍ଆର୍କେ । ମେଇଂ ପ୍ରେରିତ୍‌ଇଂକେ ଜର୍‍ ଜବର୍‍ ଦସ୍ତି ଆଡିଙ୍ଗ୍‍ଚେ ଡୁଙ୍ଗ୍‍ଆପାଙ୍ଗ୍‍ ଆର୍କେ ଣ୍ଡୁ ଡାଗ୍ଲା ମେଇଂ ବୁଟମେଗ୍ ଆର୍କେ । ଜଦି ମେଇଂ ଦେକ୍‍ରକମ୍‍ ଡିଙ୍ଗ୍‍ଆର୍‍ଏ ତେଲା ରେମୁଆଁଇଂ ଡିଙ୍ଗ୍‍ଏତ ଆମେଇଂକେ ବ୍ରି ଟୁଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC5_27","074_5_27","ACT","5","27","27","ମେଇଂ ପ୍ରେରିତ୍‌ଇଂକେ ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‌ଚେ ମ୍ନା କପାର୍‍ନେ ସେନୁଗ୍‍ ଆତୁଆଁଆର୍‍କେ । ମ୍ନା ପୁଜାରି ଆମେଇଂକେ ପ୍ରସ୍ନ ସାଲିଆକୁକେ ");
INSERT INTO gaq_vpl VALUES ("AC5_28","074_5_28","ACT","5","28","28","“ନେ ଆପେକେ ଜିସୁନେ ମ୍ନିରେ ବୁଦି ମାବିନ୍‍ସା କଡ଼ା ଆଦେସ୍‍ ବିନେବଗେ ମାତର୍‍ କେଲାପା ପେ ମେଃନେ ଡିଙ୍ଗ୍‍ପେବକେ ! ଯିରୂଶାଲମ୍‌ନେ ପିତୁର୍‍ପାକା ପେ ଆକେନ୍‍ ବୁଦି ଉଡ୍ରା ଆଡିଙ୍ଗ୍‍ ପେବକେ ବାରି ମେଁ ଗୁଏକ୍ନେନ୍‍ସା ପେ ଆନେକେ ଆନିନ୍ଦାନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍ ପେଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_29","074_5_29","ACT","5","29","29","ପିତର୍‍ ଆରି ବିନ୍‍ ସିସ୍‌ଇଂ ଉତର୍‍ ବିକେ “ନେ ଇସ୍‍ପର୍‍କେ ନେମାନେଏ ମାତର୍‍ ରେମୁଆଁଇଂକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC5_30","074_5_30","ACT","5","30","30","ପେ ଆଣ୍ଡିନ୍‍ ଜିସୁକେ କୁରୁସ୍‍ନ୍ନିଆ ଆଡେଚେ ବାଗୁଏ ପେବକେ ଆମେକେ ନେନେ ଅଃସେରେଇଂନେ ପର୍‍ମେସର୍‍ ଗୁଏକ୍ନେ ବାନ୍‍ ଆଃତଡ଼୍ୟା ବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_31","074_5_31","ACT","5","31","31","ଇଶ୍ରାୟେଲୀୟନେ ରେମୁଆଁଇଂକେ ମନେ ଏତେଚେ ପାପ୍‍ କେମା ବାନେ ସୁଜଗ୍‍ ବିନ୍‍ସା ଇସ୍‍ପର୍‍ ଆମେଇଂକେ ନେତା ଆରି ଆମ୍ବ୍ରଣ୍ଡ୍ରେ ଆଡିଙ୍ଗ୍‍ଚେ ଆତଡ଼ିଆବକେ ବାରି ମେଁନେ ନିଜେନେ ଇଞ୍ଚଙ୍ଗ୍‍ତି ପାକା ବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_32","074_5_32","ACT","5","32","32","ନେ ଆକେନ୍‍ ସାପା ସାମୁଆଁନ୍ନିଆ ସାକି ନେଲେକେ । ଆରି ଆଣ୍ଡିନେ ପବିତ୍ର ଆତ୍ମାକେ ଇସ୍‍ପର୍‍ ମେଁନେ ଆଦେସ୍‍ ମାନେଃମ୍ୟାଃକ୍ନେ ରେମୁଆଁଇଂକେ ଦାନ୍‍ ଡିଙ୍ଗ୍‍ବକେ ମେଁ ଡିଗ୍‍ ଆକେନ୍‍ ବିସୟ୍‍ରେ ସାକି ।” ");
INSERT INTO gaq_vpl VALUES ("AC5_33","074_5_33","ACT","5","33","33","ମ୍ନାଃ କୁକପାର୍‌ନେ ସଦସ୍ୟଇଂ ଆକେନ୍ ସାମୁଆଁ ଅଁଚେ ଏନ୍ତି ରିସାଡିଙ୍ଗ୍‍ଆର୍ଗେ ଜେ ମେଇଂ ସିସ୍‍ଇଂକେ ବାଗୁଏ ବିନ୍‍ସା ଚାଏ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_34","074_5_34","ACT","5","34","34","ମାତର୍‍ ମେଇଂନେ ବାନ୍‍ ଗମଲିଏଲ୍‍ ମ୍ନିକ୍ନେ ମୁଇଂ ସନ୍‌ମାନ୍‌ ବାଡିଂକ୍ନେ ରେମୁଆଁ ଫାରୁଶୀ ଦର୍ମ ଗୁରୁ ମ୍ନା କୁକପାର୍‍ନ୍ନିଆ ତୁଆଁଚେ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂକେ ବାଏରେ ଆତାର୍‍ନେସା ଆଦେସ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_35","074_5_35","ACT","5","35","35","ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‍କେ “ଏ ଇଶ୍ରାଏଲ୍‌ନେ ରେମୁଆଁଇଂ ପେ ଆକେନ୍‍ ରେମୁଆଁଇଂ ନ୍‍ସା ମେଁ ଡିଙ୍ଗ୍‍ନ୍‍ସା ଚାଏ ପେଡିଙ୍ଗ୍‍କେ ଆତେନ୍‌‍ସା ସାବ୍‍ଦାନ୍‍ ଲାଲାପା । ");
INSERT INTO gaq_vpl VALUES ("AC5_36","074_5_36","ACT","5","36","36","ଆକେନ୍‍ ସେନୁଗ୍‍ ଥିଉଦା ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁ ନିଜ୍‍କେ ନେଙ୍ଗ୍‍ଆ ମ୍ନା ଡାଗ୍‌ଚେ ବାବେଡିଙ୍ଗ୍‌ଗେ । ପ୍ରାୟ୍ ଅଁ ଅଜାର୍‍ ରେମୁଆଁ ମେଁ ପ୍ଲା ୱେଡିଂଗେ । ମାତର୍‍ ଆମେକେ ବାଗୁଏଃ ବିଃଲା ମେଁନେ ସାପା ସିସ୍‍ଇଂ ଚିନ୍‍ଚତର୍‍ ଡିଙ୍ଗ୍‍ଚେ ଲାଗ୍‍ଡଆର୍ଗେ । ଆରି ମେଁନେ ଦଲ୍‍ ଲପ୍‍ ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_37","074_5_37","ACT","5","37","37","ମେଁ ଇଡ଼ିଙ୍ଗ୍‍ ରେମୁଆଁ ଏଜେକ୍ନେ ବେଲା ଗାଲିଲୀୟ ଦେସ୍‍ନେ ଜିଉଦା ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁ ତାର୍‍କେ । ମେଁ ଡିଗ୍‍ ଉଡ଼ିରୁଆକେ ନିଜେନେ ସିସ୍‍ ଆଡିଙ୍ଗ୍‍କେ । ଆରି ଆମେକେ ଡିଗ୍‍ ବାଗୁଏଃ ବିଃଲା ମେଁ ପ୍ଲା ୱେଡିଂକ୍ନେ ସାପା ରେମୁଆଁଇଂ ଚିନ୍‍ଚତର୍‍ ଡିଙ୍ଗ୍‍ଚେ ଲାଗ୍‍ଡଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_38","074_5_38","ACT","5","38","38","ଏବେ ନେଙ୍ଗ୍‍ ଆପେକେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ପେ ଆକେନ୍‍ ରେମୁଆଁଇଂ ଆଡ଼ାତ୍ରା ମେଁ ଆଡିଙ୍ଗ୍‍ଚେ ଆମେଇଂକେ ଆନ୍ତାର୍‌ ବିଃପା । ଜଦି ମେଇଂନେ ଜଜ୍‌ନା ଆରି କାମ୍ ରେମୁଆଁଇଂନେ ବାନ୍‍ ଡିଙ୍ଗ୍‍ଲେଏ ତେଲା ଆତେନ୍‌‍ ଡିଗ୍‍ ସରାଃ ଡିଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC5_39","074_5_39","ACT","5","39","39","ମାତର୍‍ ଆକେନ୍‍ ଜଦି ପର୍‍ମେସର୍‍ ବାନ୍‍ ଡିଙ୍ଗ୍‍ଲେଏ ତେଲା ପେ ମେଇଂନେ କାମ୍ ବନ୍ଦ୍‍ ଆଡିଙ୍ଗ୍‍ ପେୟା ଣ୍ଡୁ । ପେ ନିଜେ ପର୍‍ମେସର୍‍ନେ ବିରଦ୍‍ରେ ରିଙ୍ଗ୍‍ନେ ପେକେଏ ।” ମ୍ନା କୁକପାର୍‌ନେ ରେମୁଆଁଇଂ ଗମଲିଏଲ୍‌ନେ ଆଦେସ୍‍ ମାନେଃଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_40","074_5_40","ACT","5","40","40","ଆରି ମେଇଂ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂକେ ବିତ୍‍ରେ ୱାଚେ ଆମେଇଂକେ ଚାବୁକ୍‍ ଏତେ ବଗ୍‍ଆର୍କେ ଆରି ଜିସୁନେ ମ୍ନିରେ ମେଃଡିଗ୍‍ ସାମୁଆଁ ମାବାସଙ୍ଗ୍‍ ନ୍‍ସା ଆଦେସ୍‍ ବିଚେ ଆନ୍ତ୍‍ତାର୍‍ବି ଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_41","074_5_41","ACT","5","41","41","ଆତ୍‍ବା ମେଇଂ ଆତେନ୍‌‍ ମ୍ନିନ୍‍ସା ଅପମାନ୍‍ ବଗେନ୍‍ସା ଜଗ୍ୟ ଡାଗ୍‌ଚେ ଗଣିତ ଡିଙ୍ଗ୍‍ଲେଗେ ଆତେନ୍‌‍ସା ମେଇଂ ସାର୍‍ଦା ଡିଙ୍ଗ୍‍ଚେ ମ୍ନାଃ କୁକପାର୍‌ବାନ୍‍ ତାର୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC5_42","074_5_42","ACT","5","42","42","ଆରି ମେଇଂ କାଲାଆଃ ମନ୍ଦିର୍‌ନ୍ନିଆ ଆରି ଡୁଆ ଡୁଆ ଆକେନ୍‍ ନିମାଣ୍ଡାସାମୁଆଁ ବିଆର୍‌କେ ଜେ ଜିସୁ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ କିସ୍‌ଟ । ମେଇଂ ବାସଙ୍ଗ୍‌‍ କାମ୍ ବିଲ୍‍କୁଲ୍‍ ବନ୍ଦ୍‍ ଆରାଡିଙ୍ଗ୍‍ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_1","074_6_1","ACT","6","1","1","ଆକେନ୍‍ ବେଲା ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂନେ ସଂକ୍ୟା ମ୍ନା ୱେଗେ । ଆତେନ୍‌‍ବେଲା ଗ୍ରୀକ୍‌ ବାସଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଜିଉଦିଇଂ ଏବ୍ରୀ ବାସାଣ୍ଡ୍ରେ ବାସଙ୍ଗ୍‍ନେ ଜିଉଦିଇଂନେ ବିରଦ୍‍ରେ ଦାବି ଡିଙ୍ଗ୍‍ଆର୍କେ । ମେଇଂନେ ଗୁଏସାଙ୍ଗ୍‍କୁଏଇଂକେ ଉଡ଼ି ଦର୍‍କାର୍‍ ଅଃତେନ୍‍ ଇସାବ୍‍ରେ ବଲେ ବାଟା ଆବିଲା ଦେକ୍‍ରକମ୍‍ ନିନ୍ଦା ଆଡିଙ୍ଗ୍‍ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_2","074_6_2","ACT","6","2","2","ଆତ୍‌ବିତ୍ରେ ଗୋମ୍ୱାର୍‍ ରୁଆ ସିସ୍‍ଇଂକେ ଡାଗ୍ରା ୱାଚେ ବାସଙ୍ଗ୍‌କେ, “ପର୍‍ମେସର୍‍ନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌‍ ଇସ୍‌ପର୍‌ନେ ବ୍ନାଲିର୍‌ ବାରି ସେବା ଡିଙ୍ଗ୍‌ନେ ଆବଚେ ବିନ୍‌ କାମ୍ ଡିଙ୍ଗ୍‌ନେ ଟିକ୍‌ ଣ୍ତୁ । ବଲେ ବାଟାନେ ଦିଆନ୍‍ ମାବିଚେ ବାସଙ୍ଗ୍‌‍ କାମ୍ ଚାଲେ ବନେ ନେଁ ମତରେ ବଲ୍‍ ଡିଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC6_3","074_6_3","ACT","6","3","3","ଆତେନ୍‌‍ସା ଏ ବୟାଁ ଆରି ତନାଇଂ ପେ ବିତ୍ରେବାନ୍‍ ଗୁ ରୁଆ ଙ୍ଗିରେକେ ବାଚେପା । ମେଇଂ ଜେନ୍ତିକି ରେମୁଆଁଇଂନେ ମୁଆଃବାନ୍ ନିମାଣ୍ଡା ଲେଃଏ ପବିତ୍ର ଆତ୍ମା ଆରି ବୁଦିରେ ତ୍ନ ଲେଃଏ । ନେ ଆମେଇଂକେ ଆକେନ୍‍ ସାପା ବିସୟ୍‍ରେ ଦାଇତ୍‍ ନେବିଏ । ");
INSERT INTO gaq_vpl VALUES ("AC6_4","074_6_4","ACT","6","4","4","ତେଲା ନେ ପାର୍‌ତନାରେ ଆରି ବାସଙ୍ଗ୍‌‌ କାମ୍‍ରେ ପୁରାପୁରି ବାବ୍‍ରେ ସମୟ୍‍ ବିନେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC6_5","074_6_5","ACT","6","5","5","ଆତନ୍‍ ଦଲ୍‍ନେ ସାପାରେ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂନେ ସାମୁଆଁରେ ରାଜି ଡିଙ୍ଗ୍‍ଆର୍କେ ଆରି ଆକେନ୍‍ କାମ୍‍ନ୍‍ସା ବିସ୍‌ବାସ୍‌ ଆରି ପବିତ୍ର ଆତ୍ମା ବାଲେଃକ୍ନେ ସ୍ତିଫାନ ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁକେ ଆରି ଫିଲିପ୍‌ପ, ପ୍ରକର, ନିକାନର, ତିମନ୍, ପାର୍ମନା ଆରି ଅଃସେ ଜିଉଦି ଦର୍ମ ଦିକ୍ୟା ଡିଙ୍ଗ୍‍ଲେକ୍ନେ ଆଣ୍ଟିୟକନେ ଆରି ଅଣଯିଉଦି ନୀକଲାୟକେ ବାଚେ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_6","074_6_6","ACT","6","6","6","ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ଆକେନ୍‍ ଗୁ ରୁଆ ଆତ୍‍ଲା ନ୍ତି ବଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_7","074_6_7","ACT","6","7","7","ଦେକ୍‍ରକମ୍‍ ପର୍‍ମେସର୍‍ନେ ସାମୁଆଁ ପିତୁର୍‍ପାକା ଉଡ୍ରାଡିଙ୍ଗ୍‍ୱେକେ । ଯିରୁସାଲାମ୍‌ନିଆ ସିସ୍‍ଇଂନେ ସଂକ୍ୟା ଜାବର୍‌ ଡିଙ୍ଗ୍‍ୱେଗେ । ଦେକ୍‍ରକମ୍‍କି ଜିଉଦି ପୁଜାରି ଇଂନେବାନ୍‍ ଗୁଲେରୁଆ ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‍ଆର୍କେ ଆରି ପାଲେ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_8","074_6_8","ACT","6","8","8","ସ୍ତିଫାନ ପର୍‍ମେସର୍‍ ବାନ୍‍ ଅନୁଗ୍ର‍ଅ ଆରି ବପୁ ବାଚେ ରେମୁଆଁଇଂ ଡାଗ୍ରା ବିନ୍‍ବିନ୍‍ ରକମ୍‍ କାବା କାମ୍ ଆରି ଚିନ୍ ଡିଙ୍ଗ୍‍ଡିଂଗେ ଆରି ଇସ୍‍ପର୍‍ନେ ବପୁରେ ପାରାମାନ୍‍ ବିଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_9","074_6_9","ACT","6","9","9","ମାତର୍ କୁରୁଣୀ ଆରି ଆଲେକ୍‍ଜାଣ୍ଡ୍ରିଆନେ ଚାକର୍‌ବାନ୍‌ ମୁକ୍‌ତି ବାଲେଃକ୍ନେ ଜିଉଦିଇଂକେ ଡୁଙ୍ଗ୍‌ୱେଚେ ରାସିଙ୍ଗ୍‌ବକ୍ନେ ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ଲେକ୍ନେ ଉଡ଼ିରୁଆ ରେମୁଆଁ । ବାରି କିଲିକିଆ ଆରି ଆସିଆ ଦେସ୍‍ନ୍ନିଆ ବାସାଲେଃକ୍ନେ ଉଡ଼ିରୁଆ ରେମୁଆଁନେ ତଡ଼ିଆଚେ ସ୍ତିଫାନ୍ ଏତେ ଜୁକ୍ତାଜୁକ୍ତି ଡିଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_10","074_6_10","ACT","6","10","10","ମାତର୍‍ ପବିତ୍ର ଆତ୍ମା ସ୍ତିପାନ୍‍କେ ଏନ୍ତି ଜ୍ଞାନ୍‍ ବିକେ ଜେ ଜା ଡିଗ୍‍ ମେଁନେ ବାସଙ୍ଗ୍‌ନେ ସାମୁଆଁକେ ଉଲ୍‌ଟା ସାମୁଆଁ ବାସଙ୍ଗ୍ ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC6_11","074_6_11","ACT","6","11","11","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ ଉଡ଼ିରୁଆକେ ଲାଞ୍ଚ୍‍ ବିଚେ ଆକେନ୍‍ ବାଲିର୍‌ନ୍‍ସା ବାସଙ୍ଗ୍‍ ଆର୍କେ “ନେ ଆମେକେ ମୋଶାନେ ଆରି ଇସ୍‍ପର୍‍ନେ ବିରଦ୍‍ରେ ଦଦ୍ୟା‍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ନେ ନେଅଁକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC6_12","074_6_12","ACT","6","12","12","ଦେକ୍‍ରକମ୍‍ ମେଇଂ ରେମୁଆଁଇଂକେ ଦର୍ମ ନେତାକେ ଆରି ଦରମ୍‌ ଗୁରୁଇଂକେ ଆଡେ ବିଃ ଆର୍ଗେ ଆରି ସ୍ତିପାନ୍‍କେ ସାଚେ ମ୍ନାଃ ବିଚାର୍‌ନ୍ନିଆ ଡୁଂୱେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_13","074_6_13","ACT","6","13","13","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ ମେଁ ବିରଦ୍‍ରେ ମିଚ୍‍ ସାକି ବାସଙ୍ଗ୍‍ ନ୍‍ସା ଉଡ଼ିରୁଆକେ ବିତ୍‍ରେ ଡୁଂପାଙ୍ଗ୍‍ ଆର୍କେ । ମେଇଂ ବାସଙ୍ଗ୍‍କେ “ଆକେନ୍‍ ରେମୁଆଁ କାଲାଆଃ ନେନେ ପବିତ୍ର ମନ୍ଦିର୍‍ ଆରି ମସାନେ ନିୟମ୍ ବିରଦ୍‍ରେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC6_14","074_6_14","ACT","6","14","14","ନାଜରିତିୟ ଜିସୁ ମନ୍ଦିର୍‍କେ ପାକ୍‍ଚି ବିଏ ଆରି ମୋଶାବାନ୍‍ ବାଲେଃକ୍ନେ ସାପା ନିୟମ୍‌ ବଦ୍ଲେ ବିଏ ଡାଗ୍‌ଚେ ଆକେନ୍‍ ରେମୁଆଁ ବାସଙ୍ଗ୍‍ନେ ନେ ଅଁନେଲେକେ !” ");
INSERT INTO gaq_vpl VALUES ("AC6_15","074_6_15","ACT","6","15","15","ଆତେନ୍‌‍ବେଲା ଆତ୍‍ଅରିଆ କଲେଃକ୍ନେ ସାପାରେ ମୁଇଂ ମୁଆଃରେ ସ୍ତିପାନ୍‍ପାକା କେଆର୍କେ ଜେ ମେଁନେ ସାର୍ମୁଆଃ କିତଂ ଦୁତ୍‍ନେ ସାର୍ମୁଆଃ ରକମ୍‍ ତ୍ନାଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_1","074_7_1","ACT","7","1","1","ମ୍ନା ପୁଜାରି ସ୍ତିପାନ୍‍କେ ସାଲିଆକୁକେ, “ଆକେନ୍‍ ମେଃନେ ସତ୍‍ ?” ");
INSERT INTO gaq_vpl VALUES ("AC7_2","074_7_2","ACT","7","2","2","ସ୍ତିପାନ୍‍ ଉତର୍‍ ବିଃକେ, “ଏ ନେଙ୍ଗ୍‍ନେ ବୟାଁ ଆରି ଆବାଇଂ, ଦୟା ଡିଙ୍ଗ୍‍ଚେ ଅଁପା, ନେନେ ଅଃସେଣ୍ଡ୍ରେ ଅବ୍ରାହାମ୍‍ ହାରଣନ୍ନିଆ ବାସା ନ୍‌ସା ୱେନେ ସେନୁଗ୍‍ ଗୌରବ୍‌ମୟ ଇସ୍‍ପର୍‍ ମେସପଟାମିୟାନ୍ନିଆ ଦର୍ସନ୍ ବିଚେ ଆମେକେ ବାସଙ୍ଗ୍‍କେ, ");
INSERT INTO gaq_vpl VALUES ("AC7_3","074_7_3","ACT","7","3","3","‘ନାନେ ରେମୁଆଗଣ୍ଡ୍‌ ଆରି ଦେସ୍‌କେ ଆନ୍ତାର୍‌ଚେ ନେଙ୍ଗ୍‍ ଆଣ୍ଡିନେ ଦେସ୍‌ ଣ୍ଡ୍ରାଃସୁଏଃଏ, ଆତେନ୍‍ ଦେସ୍‌ ୱେଲା ।’ ");
INSERT INTO gaq_vpl VALUES ("AC7_4","074_7_4","ACT","7","4","4","ତେସା ମେଁ କଲଦୀୟଇଂନେ ଦେସ୍‌ ଆନ୍ତ୍‍ତାର୍‍ଚେ ହାରଣନ୍ନିଆ ବାସା ନ୍‍ସା ୱେକେ । ଅବ୍ରାହାମ୍‍ନେ ଆବାଡ଼େ ଗୁଏକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ପେ ଏବେ ଆଣ୍ଡିନ୍‍ ଦେସ୍‌ନ୍ନିଆ ବାସା ପେଡିଙ୍ଗ୍‍କେ, ଇସ୍‍ପର୍‍ ଆମେକେ ଆତେନ୍‌‍ ଦେସ୍‌ନ୍ନିଆ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_5","074_7_5","ACT","7","5","5","ପର୍‍ମେସର୍‍ ଆମେକେ ମେଃଡିଗ୍‍ ଆବିକେ ଣ୍ଡୁ । ଦେକ୍‍ରକମ୍‍କି ମୁଇଂ ପୁଟ୍‍ ଜାଗା ଡିଗ୍‍ ଣ୍ଡୁ । ଆତେନ୍‌‍ବେଲା ମେଁନେ ମେଃଡିଗ୍‍ ଗୋ ଗିସିଆଃ ଆଲେଗେ ଣ୍ଡୁ । ପର୍‍ମେସର୍‍ ଆମେକେ ଆରି ମେଁନେ ବବିସତ୍‍ ଉଙ୍ଗ୍‌ଡେକେ ଆକେନ୍‍ ତୁବକେ ଅଦିକାର୍‍ ଡିଙ୍ଗ୍‍ନ୍‍ସା ମ୍ୱିଏ, ଡାଗ୍‍ଚେ ପାର୍‌ମାନ୍ ଡିଙ୍ଗ୍‍ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_6","074_7_6","ACT","7","6","6","ପର୍‍ମେସର୍‍ ଆମେକେ ଆକେନ୍‍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ବଗେ, ‘ନାନେ ଗୋ ଗିସିଆଇଂ ବିଦେସ୍‌ନ୍ନିଆ ୱେଚେ ଗତି କାମ୍ ଡିଙ୍ଗ୍‍ଆର୍‍ଏ । ଆରି ଆତ୍‍ଅରିଆ ଲେଃଡିଂକ୍ନେ ରେମୁଆଁଇଂ ଆମେଇଂକେ ୪୦୦ ମୁଆଁ ଜାକ ଦଦ୍ୟା‍ ବେବଆର୍‍ ଡିଙ୍ଗ୍‍ଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC7_7","074_7_7","ACT","7","7","7","ପର୍‍ମେସର୍‍ ବାସଙ୍ଗ୍‍କେ, ଜାଣ୍ଡେଇଂ ଆମେଇଂକେ ଚାକର୍‌ ଆଃଡିଂଚେ ବଆର୍‍କେ, ନେଙ୍ଗ୍‍ ଆତେନ୍‌‍ ରେମୁଆଁଇଂନେ ବିଚାର୍‌ ଣ୍ଡିଂଏ, ତେନ୍‌ଇଡ଼ିଂ ନାନେ ବଂସ ରେମୁଆଁଇଂ ଆତେନ୍‌‍ ଦେସ୍‍ବାନ୍‍ ପାଙ୍ଗ୍‍ଆର୍‍ଏ ଆରି ଆକେନ୍‍ ଜାଗାନ୍ନିଆ ନେଙ୍ଗ୍‍ନେ ପୁଜା ଡିଙ୍ଗ୍‍ଆର୍‍ଏ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC7_8","074_7_8","ACT","7","8","8","ତେନ୍‌ ଇଡ଼ିଂ ଇସ୍‍ପର୍‍ ଅବ୍ରାହାମ୍‍ ଏତେ ନିୟମ୍‌ ଚିନ୍‌ ରକମ୍‍ ପବିତ୍ର‌ ନିୟମ୍‍ ଆଃରେଆର୍କେ । ତେସା ମେଁନେ ଉଂଡେ ଇସ୍‌ହାକ୍‍ ଜନମ୍‍ନେ ମୁଇଂ ସାନ୍ତା ଇଡ଼ିଂ ଅବ୍ରାହାମ୍‍ ଆମେକେ ପବିତ୍ର ଆଡିଙ୍ଗ୍‍କେ; ଇସ୍‌ହାକ୍‍ ମେଁନେ ଉଂଡେ ଜାକୁବ୍‌କେ ବାରି ଜାକୁବ୍‌ ମେଁନେ ଗମ୍ୱାର୍‌ ଉଂଡେ ବାରି ନେ ଜାତିନେ ବିକ୍ୟାତ ଅସେନେ ନ୍ତା ଞ୍ଜାଃଇଂକେ ପବିତ୍ର ଡିଙ୍ଗ୍‌ଆର୍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_9","074_7_9","ACT","7","9","9","“ଜାକୁବ୍‌ନେ ଉଂଡେଇଂ ମେଇଂନେ ବୟାଁ ଯୋସେଫ୍‌କେ ରିସା ଡିଙ୍ଗ୍‍ଚେ ଆମେକେ ମିସର୍‌ ଦେସ୍‍ନେ ମୁଇଂ ଗତିରେ ରକମ୍‍ ସ ବିଃଆର୍କେ । ମାତର୍‍ ପର୍‍ମେସର୍‍ ଯୋସେଫ୍‌ ଏତେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_10","074_7_10","ACT","7","10","10","ମେଁ ଆମେକେ ସାପା ଦୁକ୍‍ କସ୍ଟବାନ୍‍ ରକ୍ୟା ଡିଙ୍ଗ୍‍କେ । ଉଡ଼ିବେଲା ଯସେପ୍‍ ମିସର୍‌ନେ ଇଃସାଙ୍ଗ୍‌ ଫାରୋଡାଗ୍ରା ପିଙ୍ଗ୍‍ଚାକେ ଇସ୍‍ପର୍‍ ଆମେକେ ଅନୁଗ୍ର‍ଅ ଆରି ଜ୍ଞାନ୍‍ ବିକେ ଆରି ଇଃସାଙ୍ଗ୍‌ ଯୋସେଫ୍‌କେ ମିସର୍‍ ଦେସ୍‍ନେ ସାସନ୍‌ ଡିଂଣ୍ଡ୍ରେ ଆରି ନିଜର୍‌ ସାପା ଡୁଆନେ ସାସନ୍‌ ଡିଂଣ୍ଡ୍ରେ ରକମ୍‍ ସ୍ରିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_11","074_7_11","ACT","7","11","11","ଆତେନ୍‌‍ବେଲା ସାପା ମିସର୍‍ଦେସ୍‍ ଆରି କିଣାନ ଦେସ୍‍ନ୍ନିଆ ମୁର୍‍ଡି ଡିଙ୍ଗ୍‍ଲା ରେମୁଆଁଇଂ ଜାବର୍‌ କସ୍ଟ ବାଆର୍‌କେ । ନେନେ ପୁର୍ବ ପୁରୁସ୍‍ଇଂକେ ଚଙ୍ଗ୍‍ନେ ମେଃଡିଗ୍‍ ଆମିଲେକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC7_12","074_7_12","ACT","7","12","12","ମିସର୍‍ନ୍ନିଆ ରୁକଃ ଲେକ୍ନେ କବର୍‍ ଅଁଚେ ଜାକୁବ୍‌ ପର୍‍ତୁମ୍‍ ମେଁ ଉଂଡେଇଂ ଆରି ଅଃସେରେଇଂକେ ଆତ୍‍ଅରିଆ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_13","074_7_13","ACT","7","13","13","ମେଇଂ ବାର୍‌ମୁଇଂତର୍‍ ୱେକ୍ନେ ବେଲା ଯୋସେଫ୍‌ ମେଁନେ ନିଜେନେ ବୟାଁଇଂ ଡାଗ୍ରା ଆସ୍ନାମୁଆଃକେ ଆରି ମିସର୍‌ନେ ଇଃସାଙ୍ଗ୍‌ ଫାରୋ ଯସେପ୍‍ନେ ଡୁଆ ବିସୟ୍‍ରେ ମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_14","074_7_14","ACT","7","14","14","ତେନ୍‌ ଇଡ଼ିଂ ଯୋସେଫ୍‌ ମେଁ ଆବାଡ଼େ ଜାକୁବ୍‌କେ ଆରି ମେଁ ଡୁଆନେ ପଞ୍ଚସ୍ତୁରି ରୁଆ ଜାତି କୁଟୁମ୍‍ ସାପାରେକେ ମିସର୍‍ ପାଙ୍ଗ୍‍ନ୍‍ସା କବର୍‌ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_15","074_7_15","ACT","7","15","15","ତେନ୍‌ଇଡ଼ିଂ ଜାକୁବ୍‌ ମିସର୍‍ଦେସ୍‍ ୱେକେ । ଆତ୍‍ଅରିଆ ମେଁ ଆରି ମେଁ ଉଂଡେଇଂ ଗୁଏ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_16","074_7_16","ACT","7","16","16","ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂନେ ଗୁଏକ୍ନେ ଗାଗ୍‍ଡ଼େକେ ସିକିମ୍‍ନ୍ନିଆ ଡୁଙ୍ଗ୍‍ୱେଚେ ରାଃଚ୍ୟାନ୍ନିଆ ଆତି ବିଃଆର୍କେ । ସିକିମ୍‍ନେ ଆକେନ୍‍ ରାଃଚ୍ୟାମ୍ୱ ଜାଗାକେ ଅବ୍ରାହାମ୍‍ ହାମୋରନେ ଉଂଡେଇଂବାନ୍‍ ଉଡ଼ି ରୁପା ଡାବୁ ବିଃଚେ ବିଆର୍‍ ବଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_17","074_7_17","ACT","7","17","17","“ଆତ୍‍ବା ମିସର୍‍ଦେସ୍‍ନେ ଇସ୍ରାଏଲ୍‍ ରେମୁଆଁଇଂନେ ସଂକ୍ୟା ମ୍ନାନେ ଲାଗେକେ । ପର୍‍ମେସର୍‍ ଅବ୍ରାହାମ୍‍କେ ଆଣ୍ଡିନ୍‍ସାପା ପାର୍‌ମାନ୍‌ ଡିଙ୍ଗ୍‍ବଗେ ଆତେନ୍‌‍ ସତ୍‍ ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_18","074_7_18","ACT","7","18","18","ଆତେନ୍‌‍ବେଲା ବାରି ମୁଇଂ ଇଃସାଙ୍ଗ୍‌ ମିସର୍‍ ଦେସ୍‍କେ ସାସନ୍‍ ଡିଙ୍ଗ୍‍ନେ ଆରାମ୍‍ ଡିଙ୍ଗ୍‍କେ । ମେଁ ଯୋଷେଫ୍‌କେ ମ୍ୟାଃଆଲେଃଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC7_19","074_7_19","ACT","7","19","19","ମେଁ ନେନେ ଅଃସେରେଇଂନେ ଆଡ଼ାତ୍ରା ନିସ୍ଟୁର୍‍ ଆରି ଦଦ୍ୟା‌ ବେବଆର୍‍ ଡିଙ୍ଗ୍‍କେ ମେଇଂନେ ଚିର୍‍ଲାଅଇଂକେ ବାଗୁଏଃ ନ୍‍ସା ଆରି ପାଦା ଜଗ୍‌ତ୍ଲାଗ୍‍ ନ୍‍ସା ଆମେଇଂକେ ବାଦ୍ୟ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_20","074_7_20","ACT","7","20","20","ଆକେନ୍‍ ବେଲା ମୋଶା ଜନମ୍‍ ଡିଙ୍ଗ୍‍କେ । ମେଁ ଇସ୍‍ପର୍‍ନେ ମ୍ମୁଆଃନ୍ନିଆ ଜାବର୍‌ ସୁନ୍ଦର୍ ଲେଃଗେ । ଆମେକେ ମେଁ ଆବାଡ଼େ ଡୁଆ ଞ୍ଜି ଆର୍କେ ଜାକ ଆବାଡ଼େନେ ଡୁଆ ଲାଲନ୍‍ ପାଲନ୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_21","074_7_21","ACT","7","21","21","ଆରି ଉଡ଼ିବେଲା ଆମେକେ ପାଦା ବେବିଆର୍ଗେ ଫାରୋ ଇଃସାଙ୍ଗ୍‌ନେ ଉଂଡେ ଆମେକେ ଡୁଙ୍ଗ୍‍ୱେଚେ ନିଜେନେ ଉଂଡେ ରକମ୍‍ ବିଃଚଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_22","074_7_22","ACT","7","22","22","ମୋଶା ମିସର୍‌ନେ ସାପା ଜ୍ଞାନ୍‍ରେ ବୁଦି ବାକେ ମେଁନେ ବ୍ନାଇର୍‍ ଆରି କାମ୍‍ରେ ମୁଇଂ ମ୍ନା ରେମୁଆଁ ରକମ୍‍ ଆସ୍ନାମୁଆକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_23","074_7_23","ACT","7","23","23","“ଆମେକେ ଚାଲିସ୍‍ ମୁଆଁ ବୟସ୍‍ ଡିଙ୍ଗ୍‍ଲା ମେଁ ନିଜେ ବୟାଁଇଂକେ ଆରି ଇଶ୍ରାୟେଲୀୟନେ ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଡିରକମ୍‍ ବେବଆର୍‍ ଡିଙ୍ଗ୍‍ବଆର୍ଗେ ଆତେନ୍‌‍ ମ୍ୟାଃ ନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_24","074_7_24","ACT","7","24","24","ମୋଶା ଆତ୍‍ଅରିଆ ମୁଇଂଜା ମିସର୍‌ନେ ମୁଇଂ ଜିଉଦି ଏତେ ଅନ୍ୟାୟ୍ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ନେ କେକେ । ତେସା ମେଁ ମୁଇଂ ଜିଉଦିରେକେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ନେ ୱେଚେ ମିସର୍‍ ରେମୁଆଁକେ ଡଣ୍ଡ୍‍ ବିକେ । ମେଁ ଆମେକେ ଦେକ୍‍ରକମ୍‍ ବଗ୍‌କେ ଜେ ମିସର୍‌ନେ ମୁଇଂଜା ଆତ୍‍ଅରିଆ ଗୁଏଃୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_25","074_7_25","ACT","7","25","25","ମୋଶା ଏତେକେ ଜେ ପର୍‍ମେସର୍‍ ମେଇଂନେ ଉଦାର୍ ନ୍‍ସା ଆମେଇଂକେ ଆକେନ୍‍ କାମ୍‍ନ୍ନିଆ ଆକୁଡ଼େ ବକେ ଆତେନ୍‌‍ ମେଇଂନେ ଯିଉଦିୟ ବୟାଁଇଂ ଦ୍ରିଗ୍‍ଆର୍‍ଏ ମାତର୍‍ ମେଇଂ ଆତେନ୍‌‍ ଆବୁଜେକେ ଣ୍ଡୁ ");
INSERT INTO gaq_vpl VALUES ("AC7_26","074_7_26","ACT","7","26","26","ଆମାର୍‍ତଡ଼େ ଆତେନ୍‌‍ ମ୍ୱାୟା ଯିଉଦି ରିଙ୍ଗ୍‍ୟା ଡିଙ୍ଗ୍‍ନେ କେକେ ଆରି ଆମେଇଂକେ ମେଁ ସାନ୍ତି ଆଃଡିଙ୍ଗ୍‍ନେସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍କେ । ମେଁ ବାସଙ୍ଗ୍‍କେ ‘ଅଁପା ପେ ମ୍ୱାୟା ତ ବୟାଁ ବୟାଁ । ପେ ମେସା ପେପେ ବିତ୍‍ରେ ଅନ୍ୟାୟ୍ ଡିଂପେଡିଙ୍ଗ୍‍କେ ?’ ");
INSERT INTO gaq_vpl VALUES ("AC7_27","074_7_27","ACT","7","27","27","ଆକେନ୍‍ ଅଁଚେ ଡୁଆଣ୍ଡ୍ରେ ଆଡ଼ାତ୍ରା ଅନ୍ୟାୟ୍ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ରେମୁଆଁ ମୋଶାକେ ଟମେଗ୍‍ଚେ ବାସଙ୍ଗ୍‍କେ ‘ଆନା ଜା ଆନେକେ ସାସନ୍‍ ଡିଂଣ୍ଡ୍ରେ ଆରି ବିଚାର୍ ଡିଙ୍ଗ୍‍ନ୍‍ସା ବେବକେ ?’ ମେଁ ସାଲିଆକୁକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_28","074_7_28","ACT","7","28","28","ତୁଗୁଆ ଣ୍ଡିଗ୍‍ ଡିରକମ୍‍ ମିସରିୟ ରେମୁଆଁକେ ନାବାଗୁଏକେ ଆନେଙ୍ଗ୍‍ ମେଁନେ ଦେତ୍‍ରକମ୍‍ ବାଗୁଏଃ ନ୍‍ସା ଚାଏଁ ନାଡିଙ୍ଗ୍‍କେ ? ");
INSERT INTO gaq_vpl VALUES ("AC7_29","074_7_29","ACT","7","29","29","ମୋଶା ଆକେନ୍‍ ଅଁଚେ ମିସର୍‍ବାନ୍‍ ଲାଗ୍‍ଡକେ ଆରି ମିଦିୟନ୍‍ ଦେସ୍‌ନ୍ନିଆ ବାସାକେ । ଆତ୍‍ଅରିଆ ମେଁନେ ମ୍ୱାକ୍ଲିକ୍‍ ଉଂଡେ ଜନମ୍‍ ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_30","074_7_30","ACT","7","30","30","ପାକାପାକି ଚାଲିସ୍‍ ମୁଆଁ ଡିଙ୍ଗ୍‍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ମୁଇଂ କିତଂ ଦୁତ୍‍ ସୀନୟ କଣ୍ଡା ଡାଗ୍ରା ଲେକ୍ନେ ବାଲିଲନ୍ନିଆ ମୁଇଂ ଲାଟାନ୍ନିଆ ସୁଆ ଆଡୁଆଚେ ମଶାକେ ଦର୍ସନ୍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_31","074_7_31","ACT","7","31","31","ମୋଶା ଆକେନ୍‍ କେଚେ ବକୁଆ ଡିଙ୍ଗ୍‍ୱେଗେ । ବାରି ଇଃକୁଡ଼ା ଆମେକେ ନିମାଣ୍ଡା ବାବ୍‍ରେ କେନ୍‍ସା ଲାଟା ଡାଗ୍ରା ୱେକେ । ମାତର୍ ମେଁ ମାପ୍‌ରୁନେ ସାମୁଆଁ ଅଁକେ: ");
INSERT INTO gaq_vpl VALUES ("AC7_32","074_7_32","ACT","7","32","32","“ନେଙ୍ଗ୍‍ ପେ ଅଃସେରେଇଂନେ ପର୍‍ମେସର୍‍ । ଅବ୍ରାହାମ୍‍ ଇସ୍‌ହାକ୍‍ ଆରି ଜାକୁବ୍‌ନେ ପର୍‍ମେସର୍‍ ।” ଆକେନ୍‍ ଅଁଚେ ମୋଶା ବୁଟଚେ ଜୁର୍‍କେ ଆରି ବାର୍‌ମୁଇଂତର୍‍ କେନ୍‍ସା ସାହାସ୍‍ ଡିଙ୍ଗ୍‍ଆୟାକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC7_33","074_7_33","ACT","7","33","33","ତେନ୍‌ ଇଡ଼ିଂ ମାପ୍‌ରୁ ଆମେକେ ବାସଙ୍ଗ୍‍କେ, “ନା ଞ୍ଚବାନ୍‍ ଜୁତା ତବି ଡାଗ୍ଲା ଆଣ୍ଡିନ୍‍ ଜାଗାନ୍ନିଆ ନା ତୁଆଁ ନାଲେଃକେ ଆତେନ୍‌‍ ପବିତ୍ର ତୁବଃ । ");
INSERT INTO gaq_vpl VALUES ("AC7_34","074_7_34","ACT","7","34","34","ନେଙ୍ଗ୍‍ ମିସର୍‍ଦେସ୍‍ନ୍ନିଆ ନେଙ୍ଗ୍‍ ରେମୁଆଁଇଂକେ ଆଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ସାପା ଦଦ୍ୟା‍ ବେବଆର୍‍ କିକେ ନ୍ଲେକେ । ନେଙ୍ଗ୍‍ ମେଇଂ ଅଃକ୍ନେ ଙକେ । ନେଙ୍ଗ୍‍ ଆମେଇଂକେ ରକ୍ୟା ଆଡିଙ୍ଗ୍‍ନେସା ଜାର୍‍ ନ୍ଲେକେ । ଆତେନ୍‌‍ସା ନା ପାଙ୍ଗ୍‍ଲା ନେଙ୍ଗ୍‍ ଆନାକେ ମିସର୍‍ ଦେସ୍‍ ମ୍ୱେଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_35","074_7_35","ACT","7","35","35","“ମୁଃଡ଼ି ମୋଶାକେ ମେଇଂ ଅମାନି ଡିଙ୍ଗ୍‍ଚେ ବାସଙ୍ଗ୍‍ବଗେ । ‘ଜା ଆନାକେ ସାସନ୍‍ କର୍ତା ଆରି ବିଚାର୍ ଡିଙ୍ଗ୍‍ଣ୍ଡ୍ରେ ଡାଗ୍‌ଚେ ବାଚେବକେ ?’ ଆତେନ୍‌‍ ମୋଶାକେ ଆଃ ଏବେ ପର୍‍ମେସର୍‍ ମେଇଂନେ ସାସନ୍‍ କର୍ତା ଆରି ମୁକ୍ତି ଦାତା ଆଡିଙ୍ଗ୍‍ଚେ ବେକେ । ମୁଡ଼ି କିତଂ ଦୁତ୍‍ ମୋଶାକେ ଲାଟା ବିତ୍‍ରେବାନ୍‍ ଦର୍‍ସନ୍‍ ବିବଗେ ଆତେନ୍‌‍ କିତଂ ଦୁତ୍‍ନେ ସାଇଜ୍ୟରେ ପର୍‍ମେସର୍‍ ମୋଶାକେ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_36","074_7_36","ACT","7","36","36","ତେସା ମୋଶା ମିସର୍‍ ଦେସ୍‌ନ୍ନିଆ ଆରି ଲୋହିତ‍ କେଣ୍ଡିଆଃନ୍ନିଆ ଗୁଲେ ରକମ୍‍ କାବାଡିଙ୍ଗ୍‍ନେ କାମ୍ ଆରି ଚିନ୍ ଆସୁଏଚେ ରେମୁଆଁଇଂକେ ମିସର୍‍ବାନ୍‍ ଆତାର୍‍ ଡୁଂପାଙ୍ଗ୍‍ଚେ ଚାଲିସ୍‍ ମୁଆଁ ଜାକ ବାଲିଲ ଅରିଆ ଆଅଲେଙ୍ଗ୍‍ ଡୁଂୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_37","074_7_37","ACT","7","37","37","ଆତେନ୍‌‍ ମୋଶା ଇଶ୍ରାୟେଲୀୟନେ ବୟାଁଇଂକେ ବାସଙ୍ଗ୍‍କେ ‘ପର୍‍ମେସର୍‍ ପେ ବିତ୍‍ରେବାନ୍‍ ନେଙ୍ଗ୍‍ ରକମ୍‍ ମୁଇଂ ବାବବାଦିକେ ତିଆର୍‍ ଆଡିଙ୍ଗ୍‍ଏ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC7_38","074_7_38","ACT","7","38","38","ଆତେନ୍‌‍ ମୋଶା ବାଲିଲ ଜାଗାନ୍ନିଆ ମୁଇଂଡାଗ୍ରା ରିସିଙ୍ଗ୍‍ ଲେକ୍ନେ ଇସ୍ରାଏଲ୍‍ଇଂ ଏତେ ଲେଃଗେ । ମେଁ ସୀନୟ କଣ୍ଡାଡାଗ୍ରା ନେଁ ଅଃସେଣ୍ଡ୍ରେଇଂ ଏଃତେ ଆରି ମେଁ ଏତେ ଅବାଲିର୍‌କ୍ନେ କିତଂ ଦୁତ୍‍ ଏତେ ଲେଃଗେ ଆରି ନେଡାଗ୍ରା ବାସଙ୍ଗ୍‍ ନ୍‍ସା ମେଁ ଇସ୍‍ପର୍‍ବାନ୍‍ ବ୍ରୁଆକ୍ନେ ବ୍ନାଇର୍‍ ବାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_39","074_7_39","ACT","7","39","39","“ମାତର୍‍ ନେନେ ଅଃସେଣ୍ଡ୍ରେଇଂ ଆମେକେ ମାନେନ୍‍ସା ରାଜି ଆଡିଙ୍ଗ୍‍ଆର୍କେ ଣ୍ଡୁ ।” ମେଇଂ ଆମେକେ ଗ୍ର‍ଅନ୍‌‍ ଡିଙ୍ଗ୍‍ନ୍‍ସା ମନା ଡିଙ୍ଗ୍‍କେ ଆରି ନିଜର୍‌ ନିଜର୍‌ ଜିବନ୍‌ନ୍ନିଆ ମିସର୍‍ନ୍ନିଆ ଆଣ୍ଡେ ୱେନ୍‍ସା ରାଜି ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_40","074_7_40","ACT","7","40","40","ମେଇଂ ହାରୋଣକେ ୱେଚେ ବାସଙ୍ଗ୍‍କେ, “ନେନେ ଗାଲି ଆସୁଏନ୍‍ସା ଉଡ଼ି ଦେବତାଇଂକେ ଆରେ ବିଲା । ଆନେକେ ମିସର୍‍ ଦେସ୍‌ବାନ୍‍ ଆଃତାର୍‍ଚେ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ବକ୍ନେ ଆତେନ୍‌‍ ମୋଶା ଆଣ୍ଡି ୱେଗେ ଆତେନ୍‌‍ ନେ ନେମ୍ୟାଃକେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_41","074_7_41","ACT","7","41","41","ଆତେନ୍‌‍ ବେଲା ମେଇଂ ମୁଇଂ ଉଂତିଆ ମୁର୍ତି ଆରେଚେ ଆତେନ୍‌‍ ମୁର୍ତି ସେନୁଗ୍‍ ଗ୍ୱାଗଃ ବିଆର୍‌କେ । ମେଇଂ ନିଜେ ନ୍ତିବାନ୍‍ ଆରେ ବକ୍ନେ ଜିନିସ୍‌କେ କେଚେ ଜାବର୍‌ ସାର୍‍ଦା ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_42","074_7_42","ACT","7","42","42","ମାତର୍‍ ପର୍‍ମେସର୍‍ ମେଇଂବାନ୍‍ ଲାଗ୍‌ଡକେ । ମେଁ ଆମେଇଂକେ କିତଂଇନିନେ ଚାଙ୍କୁଆ ଦେବତାଇଂକେ ପୁଜା ଡିଙ୍ଗ୍‍ନ୍‍ସା ଆନ୍ତାର୍‌ବିକେ । ଆକେନ୍‍ ବିସୟ୍‍ରେ ବାବବାଦିଇଂନେ ବଇନ୍ନିଆ ଗୁଆର୍‍ବକେ, “ଏ ଇଶ୍ରାୟେଲୀୟନେ ରେମୁଆଁଇଂ ପେ ୪୦ ମୁଆଁ ଜାକ ବାଲିଲ ଟିକ୍‍ରାନ୍ନିଆ ନେଙ୍ଗ୍‍ ଉଦେସ୍‍ରେ ପସୁ ଗ୍ୱାଃଗ ପେବଗେ ବାରି ଦୁପ୍‍ ଆଃମଁଃ ପେବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_43","074_7_43","ACT","7","43","43","ମାତର୍‍ ପେ ପୁଜା ଡିଙ୍ଗ୍‍ନ୍‍ସା ଆଣ୍ଡିନ୍‍ ମୁର୍ତିଇଂ ଆରେ ପେବଗେ ଆତେନ୍‌‍ ମାଲେଖନେ କୁଡ଼ିଆ ଆରି ଚାଙ୍କୁଆ ଦେବତା ରମ୍ପାନେ ପ୍ରତି ମୁର୍ତିକେ ଡୁଙ୍ଗ୍‍ରାଙ୍ଗ୍‍ୱେ ପେବଗେ । ଆତେନ୍‌‍ସା ନେଙ୍ଗ୍‍ ଆପେକେ ବାବିଲୋନ୍‍ ଦେସ୍‍ନେ ଇନୁମେତା ବେମ୍ୱିଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_44","074_7_44","ACT","7","44","44","“ନେନେ ଅଃସେରେଇଂନେ ପବିତ୍ର କୁଡ଼ିଆ ଡିଗ୍‍ ବାଲିଲ ଟିକ୍‍ରାନ୍ନିଆ ଲେଃଗେ । ପର୍‍ମେସର୍‍ ମୋଶାକେ ମୁଇଂ ନକ୍‍ସା ଆସୁଏକେ ବାରି ମେଁ କେଲେକ୍ନେ ନକ୍‍ସା ଇସାବ୍‍ରେ ଇସ୍‌ପର୍‌ନେ ଲେଃନେ ମୁଇଂ ସାକି କୁଡ଼ିଆ ଆରେନ୍‍ସା ଆମେକେ ବାସଙ୍ଗ୍‍ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_45","074_7_45","ACT","7","45","45","ଇଡ଼ିଙ୍ଗ୍‌ ନେନେ ଅସେଣ୍ଡ୍ରେଇଂ ମେଇଂନେ ଆବାଡ଼େଇଂବାନ୍ ବା ଲେଃଆର୍‌କ୍ନେ ଆତେନ୍‌ ତମ୍ବୁକେ ଯିହୋଶୂୟନେ ଏତେ ଡୁଙ୍ଗ୍‌ଡଚେ ବ‍ଆର୍‌ଗେ ଆରି ଇସ୍‍ପର୍‍ନେ ବାନ୍ ଡଲେଆର୍‌କ୍ନେ ବିନ୍ ଜାତି‍ଇଂନେ ଦେସ୍ ଦାଉଦନେ ବେଲା ଜାକ ଅଦିକାର୍ ଡିଂଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_46","074_7_46","ACT","7","46","46","ଦାଉଦ ଇସ୍‍ପର୍‍ନେ ମ୍ମୁଆଃନ୍ନିଆ ଅନୁଗ୍ର‍ଅ ବାଚେ । ଜାକୁବ୍‌ନେ ଆରି ଇସ୍‍ପର୍‍ନେସା ତମ୍ୱୁନେ ଡୁଆ ତିଆର୍ ଡିଙ୍ଗ୍‌ ନ୍‌ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_47","074_7_47","ACT","7","47","47","ମାତର୍‍ ଶଲୋମନ୍‌ ମେଁନ୍‌ସା ମୁଇଂ ମନ୍ଦିର୍‍ ଡୁଆ ଆରେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_48","074_7_48","ACT","7","48","48","“ମାତର୍‍ ସାପାଟୁ ମ୍ନା ପର୍‍ମେସର୍‍ ରେମୁଆଁଇଂନେ ବାନ୍‍ ଆରେ ବକ୍ନେ ମନ୍ଦିର୍‍ ଡୁଆନ୍ନିଆ ଆବାସା ଣ୍ଡୁ । ବାବବାଦି ଦେକ୍‍ରକମ୍‍ ଗୁଆର୍‍ ବକେ ");
INSERT INTO gaq_vpl VALUES ("AC7_49","074_7_49","ACT","7","49","49","ମାପ୍‌ରୁ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ ‘କିତଂଇନି ନେଙ୍ଗ୍‍ନେ ସିଂଆଁସନ ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ ନେଙ୍ଗ୍‍ନେ ଞ୍ଚ ବନେ ଜାଗା ପେ ନେଙ୍ଗ୍‍ସା ଡିରକମ୍‍ ମନ୍ଦିର୍‍ ପେରାରେଏ ? ନେଙ୍ଗ୍‍ ବିସ୍ରାମ୍‍ ଡୁଂଡନ୍‍ସା ଜାଗା ଆଣ୍ଡିଅରିଆ ? ");
INSERT INTO gaq_vpl VALUES ("AC7_50","074_7_50","ACT","7","50","50","ମନେ ବପା ଜେ ନେଙ୍ଗ୍‍ ଆକେନ୍‍ ସାପା ତିଆର୍‍ ଡିଙ୍ଗ୍‍ମ୍ୱକେ ?’” ");
INSERT INTO gaq_vpl VALUES ("AC7_51","074_7_51","ACT","7","51","51","ସ୍ତିପାନ୍‍ ବାସଙ୍ଗ୍‍କେ, “ପେ ଉଡ଼ି ଅମାନି, ପେନେ ଜିବନ୍‌ ଉଡ଼ି ଦଦିଆ । ପେ ମେଁନେ ସାମୁଆଁ ଅଁନ୍‍ସା ମନା ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍କେ । ପେ କାଲାଆଃ ପବିତ୍ର ଆତ୍ମାକେ ବିରଦ୍‍ ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍ । ପେ ସାପାରେ ପେନେ ନ୍ତା ଞ୍ଜାଇଂ ସୁଗୁଆ ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("AC7_52","074_7_52","ACT","7","52","52","ବାବବାଦିଇଂବାନ୍‍ ଆଜାକେ ଡିଗ୍‍ ପେନେ ନ୍ତା ଞ୍ଜାଇଂ ତାଡ଼ନା ଡିଙ୍ଗ୍‍ ଆଲେଃଗ୍ନେ ଲେଃଆର୍‌କେ ଲେଃ ? ଜାଣ୍ଡେଇଂ ଆତେନ୍‌‍ ଦାର୍‌ମିକ୍‌ ରେମୁଆଁ ପାଙ୍ଗ୍‍ନେ ବିସୟ୍‍ରେ ଅଃସେ ଆଃ ବାସଙ୍ଗ୍‍ବଗେ ଆମେଇଂକେ ମେଁଇଂ ବାଗୁଏ ଆର୍କେ; ଏବେ ପେ ଆମେକେ ବିରଦ୍‍ ରେମୁଆଁଇଂନେ ନ୍ତିନ୍ନିଆ ସର୍‍ପେଚେ ପେରାବାଗୁଏକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_53","074_7_53","ACT","7","53","53","ପେ ପର୍‍ମେସର୍‍ନେ ଦୁତ୍‍ବାନ୍‍ ମୋଶାକେ ବିବକ୍ନେ ନିୟମ୍‌ କାନୁନ୍‌ ବା ପେଲେକେ ତେଲାଡିଗ୍‍ ପେ ଆତେନ୍‌‍ ପେ ପାଲନ୍‍ ପେଡିଙ୍ଗ୍‍କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_54","074_7_54","ACT","7","54","54","ମ୍ନା କୁକପାର୍‌ନେ ରେମୁଆଁଇଂ ଆକେନ୍‍ ଅଁଚେ ସ୍ତିପାନ୍‍ ଆଡ଼ାତ୍ରା ଜାବର୍‌ ରିସା ଡିଙ୍ଗ୍‌ଚେ ଗ୍ନି ଗେରିଃଚି ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_55","074_7_55","ACT","7","55","55","ମାତର୍‍ ସ୍ତିପାନ୍‍ ପବିତ୍ର ଆତ୍ମା ବାଚେ କିତଂଇନି ତାଣ୍ଡେଚେ କେକେ । ଆତ୍‍ଅରିଆ ମେଁ ପର୍‍ମେସର୍‍ନେ ମ‍ଇମା କେକେ । ମେଁ ଜିସୁକେ ଗୌରବ୍‌ମୟ ପର୍‍ମେସର୍‍ନେ ଇଞ୍ଚନ୍ତିପାକା ତୁଆଁ ଲେକ୍ନେ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_56","074_7_56","ACT","7","56","56","ସ୍ତିପାନ୍‍ ବାସଙ୍ଗ୍‍କେ, “କେଲାପା ନେଙ୍ଗ୍‍ କିତଂଇନି ରଃନେ ଆରି ପର୍‍ମେସର୍‍ନେ ଇଞ୍ଚନ୍ତିପାକା ରେମୁଆଁ ଉଂଡେ ତୁଆଁ ଲେକ୍ନେ କେଣ୍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC7_57","074_7_57","ACT","7","57","57","କିରଚେ ମ୍ନା କୁକପାର୍‌ନେ ସଦସ୍ୟଇଂ ଆକେନ୍‍ ସାମୁଆଁ ମାଅଁନ୍‍ସା ନ୍ଲୁଗ୍‍ନ୍ନିଆ ନ୍ତି ତାଙ୍ଗ୍‍ଡା ଆର୍କେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଁଇଂ ଏକ୍‍ଜୁଟ୍‍ ଡିଙ୍ଗ୍‍ଚେ ସ୍ତିପାନ୍‍ ପାକା ୱିର୍‍ ଡୁଂପାଙ୍ଗ୍‍ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_58","074_7_58","ACT","7","58","58","ସଅର୍‍ ବାଏରେ ଆମେକେ ଗୁଃ ଡୁଂୱେଚେ ମେଁ ଆଡ଼ାତ୍ରା ବ୍ରି ଟୁଚେ ବାଗୁଏଆର୍କେ । ସାକିରେ ଶାଉଲ ମ୍ନିକ୍ନେ ମୁଇଂ ଙ୍ଗିରେ ଡାଗ୍ରା ମେଇଂନେ ସକା ପାଟାଇ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC7_59","074_7_59","ACT","7","59","59","ଉଡ଼ିବେଲା ମେଁଇଂ ସ୍ତିଫାନକେ ବ୍ରି ଏତେ ଡଆର୍‌ଡିଂଗେ, ଆତେନ୍‌‍ବେଲା ମେଁ ମାପ୍‌ରୁକେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ଚେ ବାସଙ୍ଗ୍‌କେ, “ଏ ମାପ୍‌ରୁ ଜିସୁ ନେଙ୍ଗ୍‍ନେ ଆତ୍ମାନେ ଗ୍ରଅନ୍‍ ଡିଙ୍ଗ୍‍ !” ");
INSERT INTO gaq_vpl VALUES ("AC7_60","074_7_60","ACT","7","60","60","ମେଁ ଡେଙ୍ଗାଚେ କିରଚେ ବାସଙ୍ଗ୍‍କେ, “ଏ ମାପ୍‌ରୁ ଆକେନ୍‍ ପାପ୍‍ ନ୍‍ସା ଆକ୍ମେଇଂକେ ବୁଲ୍‌ ଆସାଃଗେ ।” ଆକେନ୍‍ ବାସଙ୍ଗ୍‍ଚେ ମେଁ ଗୁଏଃୱେଗେ । ସ୍ତିପାନ୍ ଗୁଏନେ ଡଣ୍ଡ୍‍‌କେ ଶାଉଲ୍ ମୁଇଂ ଇକ୍‌ଚା ଡିଂବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_1","074_8_1","ACT","8","1","1","ଶାଉଲ ସ୍ତିଫାନ୍‌ନେ ଗୁଏନେ ଡାଗ୍ରା ରାଜି ଲେଃକେ । ଆତେନ୍‌‍ ଦିନାବାନ୍‍ ଯିରୂଶାଲମ୍‌ନେ ମଣ୍ଡଲି ଆଡ଼ାତ୍ରା ଜବର୍‌ କସ୍‌ଟ ଆରାମ୍‍ ଡିଙ୍ଗ୍‍କେ । ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂକେ ଆନ୍ତ୍‍ତାର୍‍ଚେ ବିନ୍‍ ସାପା ବିସ୍‍ବାସି ଜିଉଦା ପ୍ରଦେସ୍ ଆରି ସମରିଆ ଏରିଆ ଚିନ୍‍ଚତର୍‍ ଡିଙ୍ଗ୍‍ୱେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_2","074_8_2","ACT","8","2","2","ଉଡ଼ିରୁଆ ଇସ୍‍ପର୍‍ନେ ବକ୍ତଇଂ ସାରସାଗାଚେ ଅଁଚେ ସ୍ତିଫାନନେ ଗୁଏକ୍ନେ ଗାଗ୍‍ଡ଼େକେ ଆତିବି ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_3","074_8_3","ACT","8","3","3","ମାତର୍‍ ଶାଉଲ ମଣ୍ଡଲିକେ ଦଂସ ଆଡିଙ୍ଗ୍‍ ନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍କେ ଡୁଆ ଡୁଆ ୱେଚେ କିସ୍‌ଟ ବିସ୍‍ବାସ୍‍ ଙ୍ଗିରେ ସେଲାମ୍ବୁଏଃ ସାପାରେକେ ଗୁ ଡୁଂପାଙ୍ଗ୍‍ଚେ ଜେଲ୍‍କାନା ବିତ୍‍ରେ ଆଗାଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_4","074_8_4","ACT","8","4","4","ଚିନ୍‍ଚତର୍‍ ଡିଙ୍ଗ୍‍ଲେକ୍ନେ ବିସ୍‍ବାସିଇଂ ପିତୁର୍‌ ପାକା ୱେଚେ ନିମାଣ୍ଡାସାମୁଆଁ ବାସଙ୍ଗ୍‌‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_5","074_8_5","ACT","8","5","5","ସମରିଆନେ ମ୍ନା ନଗର୍ ୱେଚେ ଫିଲିପ୍‌ପ ଆତ୍‍ଅରିଆନେ ରେମୁଆଁଇଂ ଡାଗ୍ରା କିସ୍‌ଟନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_6","074_8_6","ACT","8","6","6","ଫିଲିପ୍‌ନେ ସାମୁଆଁ ଅଁଚେ ଆରି ମେଁନେ ଇରିୟାଃତୁଗ୍‌ କାମ୍ ଆରି ଚିନ୍ ସାପା କେଚେ ରେମୁଆଁଇଂ ମେଁ ଆଡ଼ାତ୍ରା ଜାବର୍‌ ଦ୍ୟାନ୍‍ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_7","074_8_7","ACT","8","7","7","ଗୁଲେ ରେମୁଆଁଇଂନେବାନ୍‍ ବୁତ୍‌ଇଂ ସାରସାଗାଚେ ତାର୍‍ୱେଆର୍କେ ଗୁଲେ ଇରିଃ ସାଃଲେକ୍ନେ ରଗି ଆରି ଚଟାଇଂ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_8","074_8_8","ACT","8","8","8","ଆକେନ୍‍ସା ଆତେନ୍‌‍ ନଗର୍‍ନ୍ନିଆ ଜାବର୍‌ ସାର୍‍ଦା ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_9","074_8_9","ACT","8","9","9","ଶିମୋନ ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁ ଏନ୍ ଅଃସେ ଆତାନ୍‌ ନଗର୍‌ନ୍ନିଆ ଜାଦୁ କାମ୍ ଡିଙ୍ଗ୍‌ଚେ ନିଜେକେ ମୁଇଂ ମ୍ନାଃରେମୁଆଁ ଡାଗ୍‌ ବାସଙ୍ଗ୍‌ଚେ ଶମିରୋଣୀୟ ଜାତିକେ କାବା ଆଡିଙ୍ଗ୍‌ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_10","074_8_10","ACT","8","10","10","ଇସ୍‍ପର୍‍ନେ ଆଣ୍ଡିନ୍‍ ବପୁକେ ମ୍ନା ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ମ୍ୟାଃକେ ଡାଆଁ ବାନ୍‍ ମ୍ନା ଜାକ ସାପାରେ କିମେ ଆତେନ୍‌‍ ରେମୁଆଁ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‍ଚେ ଆମେକେ ମାନେଃ ଡିଙ୍ଗ୍‍ଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_11","074_8_11","ACT","8","11","11","ଆତେନ୍‌‍ ଜାଦୁ ବିଦ୍ୟା ବପୁରେ ଗୁଲେଦିନା ସାଚେ ମେଁ ସମିରନିୟଇଂକେ ମେଁନେ ଞ୍ଚ ଆଲ ଆଡିଙ୍ଗ୍‍ବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_12","074_8_12","ACT","8","12","12","ମାତର୍‍ ଫିଲିପ୍‌ନେ ବାନ୍‍ ଇସ୍‍ପର୍‍ନେ ରାଜି ଆରି ଜିସୁ କିସ୍‌ଟନେ ବିସୟ୍‌ରେ ନିମାଣ୍ଡା ସାମୁଆଁ ବାସଙ୍ଗ୍‌କ୍ନେ ଅଁପା ଆତ୍‍ଅରିଆନେ ରେମୁଆଁଇଂନେ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‌ ପାଙ୍ଗ୍‍ଆର୍କେ ଆରି ଆତେନ୍‌‍ ଏରିଆନେ ସେଲାମ୍ବୁଏଃ ଆରି ଙ୍ଗିର୍‌ବଏଃ ସାପାରେ ଣ୍ଡିଆନ୍ନିଆ ଡୁବନ୍‌ ଡୁଂଡଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_13","074_8_13","ACT","8","13","13","ଆରି ଶିମୋନ୍‌ ନିଜେ ଆତେନ୍‌‍ ବ୍ନାଇର୍‍ ଅଁଚେ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍କେ । ଫିଲିପ୍‌ପବାନ୍‍ ଡିଙ୍ଗ୍‍ଲେଃକ୍ନେ କାବା କାମ୍ ଆରି ଇରିୟାତୁଗ୍‌ନେ କାମ୍ କେଚେ ମେଁ ଣ୍ଡିଆନ୍ନିଆ ଡୁବନ୍‌ ଡୁଂଡଚେ ଫିଲିପ୍‌ନେ ଏତେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_14","074_8_14","ACT","8","14","14","ସମରିଆନେ ରେମୁଆଁଇଂ ଇସ୍‍ପର୍‍ନେ ବ୍ନାଇର୍‍ ସାଆର୍କେ ଡାଗ୍‌ଚେ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ଲେଡିଙ୍ଗ୍‍କ୍ନେ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ଅଁଚେ ପିତର ଆରି ଜହନ୍‌କେ ମେଇଂ ଡାଗ୍ରା ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_15","074_8_15","ACT","8","15","15","ମେଇଂ ଆତ୍‍ଅରିଆ ୱେଚାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ସମିରନିୟ ବିସ୍‍ବାସିଇଂ ଜେନ୍ତିକି ପବିତ୍ର ଆତ୍ମା ବାଆର୍‍ଏ ଆତେନ୍‌‍ସା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_16","074_8_16","ACT","8","16","16","ଡାଗ୍ଲା ଆତେନ୍‌‍ ଜାକ ମେଇଂନେ ବାନ୍‍ ଜା ଆଡ଼ାତ୍ରା ଡିଗ୍‍ ପବିତ୍ର ଆତ୍ମା ଜାର୍‍ ଆଲେଗେ ଣ୍ଡୁ । ମେଇଂ ମାତର୍‍ ମାପ୍‌ରୁ ଜିସୁ କ୍ରିସ୍ଟନେ ମ୍ନିରେ ଣ୍ଡିଆନ୍ନିଆ ଡୁବନ୍‌ ଡୁଂଡ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_17","074_8_17","ACT","8","17","17","ପିତର୍‍ ଆରି ଜହନ୍‍ ମେଇଂ ଆଡ଼ାତ୍ରା ନ୍ତିବକ୍ନେ ଦାପ୍ରେ ମେଇଂ ପବିତ୍ର ଆତ୍ମା ବାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_18","074_8_18","ACT","8","18","18","ଶିମୋନ କେକେ ଜେ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ବିସ୍‍ବାସିଇଂନେ ଆଡ଼ାତ୍ର ନ୍ତି ବଲା ମେଇଂ ପବିତ୍ର ଆତ୍ମା ବାଆର୍‌କେ । ଆତେନ୍‌‍ କେଚେ ମେଁ ପିତର୍‍କେ ଆରି ଯହନ୍‍କେ ଡାବୁ ଜାଚେଚେ ବାସଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_19","074_8_19","ACT","8","19","19","“ନେଙ୍ଗ୍‍ ଅଲ୍‍ଗାରେ ଆଡ଼ାତ୍ରା ନ୍ତି ବଲା ମେଇଂ ଜେନ୍ତିକି ପବିତ୍ର ଆତ୍ମା ବାଆର୍‍ଏ ଆନେଙ୍ଗ୍‍ ଆତେନ୍‌‍ ବପୁ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("AC8_20","074_8_20","ACT","8","20","20","ମାତର୍‌ ପିତର୍‍ ଆମେକେ ବାସଙ୍ଗ୍‍କେ, “ନା ଏତେ ନାନେ ଡାବୁ କାଲାଆଃ ନ୍‍ସା ନସ୍ଟ ଡିଙ୍ଗ୍‍ଲେ ଡାଗ୍ଲା ନା ନାବାବେକେ ଜେ ଇସ୍‍ପର୍‍ନେ ଦାନ୍ ଡାବୁ ଏତେ ବିଆର୍‍ ଡିଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC8_21","074_8_21","ACT","8","21","21","ନେ କାମ୍‍ନ୍ନିଆ ନାନେ ମେଃଡିଗ୍‍ ବାଗ୍‍ ଣ୍ଡୁ । ଡାଗ୍ଲା ଇସ୍‍ପର୍‍ନେ ଆଡ଼ାତ୍ରା ନାନେ ଜିବନ୍‌ ସିଦା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC8_22","074_8_22","ACT","8","22","22","ତେସା ନାନେ ଜିବନ୍‌କେ ପରିବର୍ତନ୍‌ ଆଡିଙ୍ଗ୍‍ ଆରି ନାନେ ଆକେନ୍‍ ଦଦ୍ୟା‌ ଚିନ୍ତାବାନ୍‍ ଆଣ୍ଡେଚେ ମାପ୍‌ରୁକେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ । ଡିଙ୍ଗ୍‍ଏ ତ ପର୍‍ମେସର୍‍ ନାନେ ଜିବନ୍‍ନ୍ନିଆ ଲେକ୍ନେ ପାପ୍‍ ଚିନ୍ତାକେ କେମା ଡିଙ୍ଗ୍‍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("AC8_23","074_8_23","ACT","8","23","23","ନେଙ୍ଗ୍‍ କିକେ ଣ୍ଡିଙ୍ଗ୍‍କେ ଜେ ନା ମନ୍‍ ବିତ୍‍ରେ ଇର୍‍ସା ତ୍ନ ଲେଃକେ ଆରି ପାପ୍‍ ନା ଆଡ଼ାତ୍ରା ସାସନ୍‍ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC8_24","074_8_24","ACT","8","24","24","ଶିମୋନ ପିତର ଆରି ଜହନକେ ବାସଙ୍ଗ୍‍କେ, “ପେ ଜା ସାପା ପେବାସଙ୍ଗ୍‍କେ ଆତେନ୍‌‍ ଜେନ୍ତିକି ନେଙ୍ଗ୍‍ ଆଡ଼ାତ୍ରା ଆଗଟେ, ଆତେନ୍‌‍ସା ଦୟା ଡିଙ୍ଗ୍‍ଚେ ମାପ୍‌ରୁ ଡାଗ୍ରା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("AC8_25","074_8_25","ACT","8","25","25","ଦେକ୍‍ରକମ୍‍ ପିତର୍‍ ଆରି ଯହନ୍‍ ସାକି ବିଚେ ଆରି ମାପ୍‌ରୁନେ ବ୍ନାଲିର୍‍ ବାସଙ୍ଗ୍‌ଚେ ସମରିଆ ରେମୁଆଁ ଗୁଲେ ଇନି ନିମାଣ୍ଡାସାମୁଆଁ ବାସଙ୍ଗ୍‌‍ ଡିଙ୍ଗ୍‍ଚେ ଯିରୁସାଲାମ୍‌ ଆଣ୍ଡେ ୱେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_26","074_8_26","ACT","8","26","26","ମାପ୍‌ରୁନେ ମୁଇଂ ଦୁତ୍‍ ଫିଲିପ୍‌ପକେ ବାସଙ୍ଗ୍‍କେ “ତିଆର୍‍ ଡିଙ୍ଗ୍‍ ଦକିନ୍‍ ଦିଗ୍‍ପାକା ଆଣ୍ଡିନ୍‍ ଗାଲି ଯିରୂଶାଲାମ୍‌ବାନ୍‌ ଗଜ୍ଜା ପାକା ୱେଲେଃକେ ଆତାନ୍‌ ଗାଲି ପାକା ୱେଲା । ଆତାନ୍‌ ଆଃ ବାଲିଲ ।” ");
INSERT INTO gaq_vpl VALUES ("AC8_27","074_8_27","ACT","8","27","27","ପିଲିପ୍‍ପ ତିଆର୍‍ ଡିଙ୍ଗ୍‍ଚେ ତାର୍‍କେ । ଆତେନ୍‌‍ ଗାଲିପାକା ମୁଇଂ ଆଣ୍ଡାରିକେ ଅବାକେ । ଆତେନ୍‌‍ ଆଣ୍ଡାରି ଇତିଅପିଆବାନ୍‍ ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ମେଁ କୁସ୍‍ ଦେସ୍‍ ରେମୁଆଁଇଂନେ କାଣ୍ଡାକି ମ୍ନିକ୍ନେ ରାନିନେ ମୁଇଂ ମ୍ନା ପଦବିନ୍ନିଆ କାମ୍ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ମେଁ ମେଁନେ ସାପା ଦନ୍‍ ସମ୍ପତି ଆଡ଼ାତ୍ରା ଦାଇତ୍‍ରେ ଲେଃଗେ । ଆତେନ୍‌‍ ଆଣ୍ଡାରି ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ନ୍‍ସା ଯିରୁସାଲାମ୍‌ ୱେଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_28","074_8_28","ACT","8","28","28","ମେଁ ରତ୍‍ନ୍ନିଆ କଚେ ଆଣ୍ଡେ ୱିଗ୍‍ନେ ବେଲା ବାବବାଦି ଯିଶାଇୟନେ ଉଲିଆ ୱାସାର୍‌ଚେ ଲଃଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_29","074_8_29","ACT","8","29","29","ଆତେନ୍‌‍ବେଲା ପବିତ୍ର ଆତ୍ମା ଫିଲିପ୍‌ପକେ ବାସଙ୍ଗ୍‍କେ “ନା ଆତେନ୍‌‍ ରତ୍‍ଡାଗ୍ରା ୱେଚେ ଆତ୍‍ଅରିଆ ଲାଃଲା ।” ");
INSERT INTO gaq_vpl VALUES ("AC8_30","074_8_30","ACT","8","30","30","ଫିଲିପ୍‌ପ ରତ୍‍ଡାଗ୍ରା ୱିର୍‍ ଡୁଂୱେଚେ ମେଁ ଯିଶାଇୟ ବାବବାଦିନେ ସାସ୍ତର୍‌ ପଡ଼େନେ ଅଁକେ । ମେଁ ଆମେକେ ସାଲିଆକୁକେ, “ନା ମେଃନେ ପଡ଼େନାଡିଂକେ, ଆତେନ୍‌‍ ମେଃନେ ବୁଜେନାଡିଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("AC8_31","074_8_31","ACT","8","31","31","ଆତନ୍‍ ଆଣ୍ଡାରି ବାସଙ୍ଗ୍‍କେ, “ଜା ଡିଗ୍‍ ଆନେଙ୍ଗ୍‍କେ ଆଦ୍ରିଗ୍‍ ଆବିଲା ନେଙ୍ଗ୍‍ ଡିରକମ୍‍ ଦ୍ରିଗ୍‍ ୟାଏ ?” ମେଁ ଏତେ ରତ୍‍ଡାଗ୍ରା କୁକନ୍‍ସା ମେଁ ଫିଲିପ୍‌ପକେ ଗୁଆରି ଡିଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_32","074_8_32","ACT","8","32","32","ମେଁ ଦରମ୍‍ ସାସ୍ତର୍‌ନ୍ନିଆ ଆକେନ୍‍ ପାଟ୍‍ ଲଃଡିଂଗେ: “ଆମେକେ ମୁଇଂ ମେଣ୍ଡା ରକମ୍‍ ବାଗୁଏଃ ନ୍‍ସା ବାଗୁଏନେ ଜାଗାନ୍ନିଆ ଡୁଙ୍ଗ୍‍ ୱେଆର୍କେ । ମୁଇଂ ଉଂମେଣ୍ଡା ଡିରକମ୍‍ ଉଗ୍‌ବ ଚେଦକ ସାମ୍‍ନାନ୍ନିଆ ବୁଙ୍ଗ୍‍ ଡିଙ୍ଗ୍‍ଚେ ତୁଆଁ ମ୍ୟାକେ ଦେତ୍‍ରକମ୍‍ ମେଁ ବୁଙ୍ଗ୍‍ ଡିଙ୍ଗ୍‍ଚେ ତୁଆଁକେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_33","074_8_33","ACT","8","33","33","ମେଁ ଅପମାନ୍‍ ବାକେ ଆରି ନ୍ୟାୟ୍‍ବାନ୍‍ ବ୍ରୁଆକେ । ମେଁ ବଂସଇଂନେ ବିସୟ୍‍ରେ ଜା ମେଃଡିଗ୍‍ ବାସଙ୍ଗ୍‍ ଆୟାଆର୍‍ ଣ୍ଡୁ ଡାଗ୍ଲା ମଞ୍ଚ୍‌ପୁର୍‍ନ୍ନିଆ ମେଁନେ ଜିବନ୍‍ କାଲ୍‍ ଡା ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC8_34","074_8_34","ACT","8","34","34","ଆତେନ୍‌‍ ଆଣ୍ଡାରି ଫିଲିପ୍‌ପକେ ବାସଙ୍ଗ୍‍କେ, “ନେଙ୍ଗ୍‌ ଆନାକେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‌ଣ୍ତିଙ୍ଗ୍‌କେ । ବାବବାଦି ଜା ବିସୟ୍‌ରେ ଏନ୍ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ? ନାଁ ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌କେ ବାରି ଜା ବିସୟ୍‌ରେ ବାସଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("AC8_35","074_8_35","ACT","8","35","35","ଇଡ଼ିଙ୍ଗ୍‍ ଫିଲିପ୍‌ପ ଦରମ୍‌ ସାସ୍ତର୍‌ନେ ଆତେନ୍‌‍ ସାମୁଆଁବାନ୍‍ ମୁଲେଚେ ଜିସୁନେ ନିମାଣ୍ଡାସାମୁଆଁ ଜାକ ଆମେକେ ବାଲିର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_36","074_8_36","ACT","8","36","36","ମେଁଇଂ ଗାଲି ଗାଲି ୱେଡିଂକ୍ନେ ବେଲା ମୁଇଂ ଣ୍ଡିଆ ଲେକ୍ନେ ଜାଗାନ୍ତୁଗ୍‍ ୱେଚାଆର୍କେ । ଆତେନ୍‌‍ ଆଣ୍ଡାରି ବାସଙ୍ଗ୍‍କେ “କେଲା ଆକ୍‍ଅରିଆ ତ ଣ୍ଡିଆ ଲେଃକେ । ଏବେ ନେଙ୍ଗ୍‍ ଆକ୍‍ଅରିଆ ଡୁବନ୍‌ ଡୁଙ୍ଗ୍‍ଡଲା ମେଁନେ ଅସୁବିଦା ଡିଙ୍ଗ୍‍ଏ କି ?” ");
INSERT INTO gaq_vpl VALUES ("AC8_37","074_8_37","ACT","8","37","37","ଫିଲିପ୍‌ପ ବାସଙ୍ଗ୍‍କେ “ନା ଜଦି ସାପା ମନ୍‍ ଏତେ ବିସ୍‍ବାସ୍‍ ନାଡିଙ୍ଗ୍‍ଏ ତେଲା ଡିଙ୍ଗ୍‍ ନାୟାଏ । ଆତ୍‍ବା ମେଁ ଉତର୍‍ ବିକେ ଜିସୁ କିସ୍‌ଟ ଜେ ଇସ୍‍ପର୍‍ନେ ଉଂଡେ ଆକେନ୍‍ ନେଙ୍ଗ୍‍ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC8_38","074_8_38","ACT","8","38","38","ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ରତ୍‍କେ ଆତୁଆଁନ୍‍ସା ବାସଙ୍ଗ୍‍କେ । ଫିଲିପ୍‌ପ ଆରି ଆଣ୍ଡାରି ମ୍ୱାୟା ଣ୍ଡିଆନ୍ନିଆ ଗା ଆର୍କେ ବାରି ପିଲିପ୍‍ପ ଆମେକେ ଡୁବନ୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_39","074_8_39","ACT","8","39","39","ମେଁଇଂ ଣ୍ଡିଆ ବିତ୍‍ରେବାନ୍‍ ତିତାର୍‍ ପାଙ୍ଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ମାପ୍‌ରୁନେ ଆତ୍ମା ଫିଲିପ୍‌ପକେ ଡୁଙ୍ଗ୍‍ଡଗେ । ଆତେନ୍‌‍ ଆଣ୍ଡାରି ଆରି ଆମେକେ କିକେ ଆୟାକେ ଣ୍ଡୁ । ମେଁ ସାର୍‍ଦାରେ ମେଁ ଗାଲିପାକା ଅଲେଙ୍ଗ୍‍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC8_40","074_8_40","ACT","8","40","40","ଉଡ଼ି ଦିନା ଇଡ଼ିଙ୍ଗ୍‍ ଫିଲିପ୍‌ପ କେକେ ଜେ ମେଁ ଅସଦୋଦନ୍ନିଆ ପିଙ୍ଗ୍‍ଚାଲେକେ । ଆତ୍‍ବା ମେଁ କାଇସରିୟା ୱେକେ ଆରି ଗାଲି ଆଣ୍ଡେଙ୍ଗ୍‍ ଲେକ୍ନେ ସହର୍‍ନ୍ନିଆ ନିମାଣ୍ଡାସାମୁଆଁ ବାସଙ୍ଗ୍‌‍ ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_1","074_9_1","ACT","9","1","1","ଆକେନ୍‍ ବେଲା ଶାଉଲ ମାପ୍‌ରୁନେ ସିସ୍‍ଇଂକେ ବାଗୁଏଆର୍‍ଏ ଡାଗ୍‍ଚେ ଦମକ୍‍ ବିଚେ ମ୍ନା ପୁଜାରି ଡାଗ୍ରା ୱେକେ ");
INSERT INTO gaq_vpl VALUES ("AC9_2","074_9_2","ACT","9","2","2","ଦାମାସ୍କସ୍‌ନେ ପାର୍‌ତନା ଡୁଆଇଂ ଡାଗ୍ରା ମାପ୍‍ରୁନେ ଗାଲି ୱେଡିଂକ୍ନେ ସେଲାମ୍ବୁଏ ଆରି ଙ୍ଗିରେଇଂକେ ପେଅବାଲା ଗାଗ୍‍ଚେ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ସାଚେ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ନ୍‍ସା ମ୍ନା ପୁଜାରିବାନ୍‍ ଆଦେସ୍‌ ଉଲିଆ ସାଲିଆ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_3","074_9_3","ACT","9","3","3","ସାଉଲ୍‍ ଦାମାସ୍କସ୍‌ ସହର୍‍ ଡାଗ୍ରା ତେପିଙ୍ଗ୍‍ଚାକ୍ନେ ବେଲା ଉଲୁସ୍ତେ କିତଂଇନିବାନ୍‍ ମୁଇଂ ତାରାସ୍‍ ମେଁ ପିତୁର୍‍ପାକା ତାର୍କିଗ୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_4","074_9_4","ACT","9","4","4","ମେଁ ତୁବନ୍ନିଆ ଲଃଚେ ମୁଇଂ ସାମୁଆଁ ଅଁକେ “ଶାଉଲ ଶାଉଲ ନା ଆନେଙ୍ଗ୍‍କେ ମେଁସା ତାଡ଼ନା ଡିଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ ?” ");
INSERT INTO gaq_vpl VALUES ("AC9_5","074_9_5","ACT","9","5","5","ସାଉଲ୍‍ ବାସଙ୍ଗ୍‍କେ, “ମାପ୍‌ରୁ ନା ଜାଣ୍ଡେ ?” ମେଁ ବାସଙ୍ଗ୍‍କେ “ଆଜାକେ ନା ତାଡ଼ନା ଡିଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍ ନେଙ୍ଗ୍‍ ଆତେନ୍‌‍ ଜିସୁ । ");
INSERT INTO gaq_vpl VALUES ("AC9_6","074_9_6","ACT","9","6","6","ଏବେ ତଡ଼ିଆ ଆରି ସହର୍‍ନ୍ନିଆ ୱେଲା । ଆତ୍‍ଅରିଆ ଆନାକେ ମେଁ ଡିଙ୍ଗ୍‍ନେ ଆତେନ୍‌‍ ଆନାକେ ମୁଇଂଜା ବାସଙ୍ଗ୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC9_7","074_9_7","ACT","9","7","7","ସାଉଲ୍‍ ଏତେ ୱେଡିଂକ୍ନେ ରେମୁଆଁଇଂ କାବା ଡିଙ୍ଗ୍‍ଚେ ତୁଆଁ ଆର୍କେ । ମେଇଂ ଆକେନ୍‍ ସାମୁଆଁ ଅଁଆର୍କେ ମାତର୍‍ ଆଜାକେ ଡିଗ୍‍ ଆତ୍‍ଅରିଆ ଆକେଆର୍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC9_8","074_9_8","ACT","9","8","8","ବାରି ଶାଉଲ ତୁବବାନ୍‌ ତଡ଼୍ୟାଚେ ମ୍ମୁଆଃ କେକେ, ମାତର୍‍ ଆମେକେ ମେଃଡିଗ୍‍ ଆତ୍ନାକେ ଣ୍ଡୁ । ତେସା ରେମୁଆଁଇଂ ମେଁ ନ୍ତିକେ ସାଚେ ଦାମାସ୍କସ୍‌ ଜାକ ଡୁଂୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_9","074_9_9","ACT","9","9","9","ମେଁ ଜିର୍‍ସି ଜାକ ମେଃଡିଗ୍‍ କିକେ ଆୟାକେ ଣ୍ଡୁ ଆରି ଆତ୍‌ବାନ୍ ମେଃଡିଗ୍‍ ଆଚଙ୍ଗ୍‍ ଆଉଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_10","074_9_10","ACT","9","10","10","ଦାମାସ୍କସ୍‌ନ୍ନିଆ ହନନୀୟ ମ୍ନିକ୍ନେ ମୁଇଂ ସିସ୍ ରେମୁଆଁ ଲେଃଗେ । ମାପ୍‌ରୁ ଆମେକେ ଦର୍ସନ୍ ବିଚେ ବାସଙ୍ଗ୍‍କେ “ହନନୀୟ” ମେଁ ଉତର୍‍ ବିକେ “ଏ ମାପ୍‌ରୁ ବାସଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("AC9_11","074_9_11","ACT","9","11","11","ମାପ୍‌ରୁ ଆମେକେ ବାସଙ୍ଗ୍‍କେ “ତଡ଼ିଆ ବାରି ସିଦା ମ୍ନିକ୍ନେ ଗାଲି ସାଚେ ଜିଉଦାନେ ଡୁଆ ୱେଲା । ଆତ୍‍ଅରିଆ ତାର୍ଷିସ୍‌ବାନ୍ ପାଙ୍ଗ୍‍ଲେଃକ୍ନେ ଶାଉଲ ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁକେ ତୁର୍‍ । ଏବେ ମେଁ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_12","074_9_12","ACT","9","12","12","ହନନୀୟ ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁ ପାଙ୍ଗ୍‍ଚେ ନେଙ୍ଗ୍‍ ଆଡ଼ାତ୍ରା ନ୍ତି ବଲା ନେଙ୍ଗ୍‍ ମୁଆଁ କିକେ ୟାଏ ଡାଗ୍‍ଚେ ଦର୍ସନ୍ କିକେ ଲେଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC9_13","074_9_13","ACT","9","13","13","ହନନୀୟ ଉତର୍‍ ବିକେ, “ମାପ୍‌ରୁ ଆକେନ୍‍ ରେମୁଆଁ ଯିରୂଶାଲମ୍‌ନ୍ନିଆ ନାନେ ପବିତ୍ର ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଜାବର୍‌ ଅତ୍ୟାଚାର୍‍ ଡିଙ୍ଗ୍‍ବକେ । ଆକେନ୍‍ ବିସୟ୍‍ରେ ଗୁଲେରେ ଆନେଙ୍ଗ୍‍କେ ବାସଙ୍ଗ୍‍ ବଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_14","074_9_14","ACT","9","14","14","ଦମେସକନ୍ନିଆ ଉଡ଼ିରୁଆ ନା ମ୍ନିରେ ପାର୍‍ତନା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କେ ଆମେଇଂକେ ଗାଗ୍‍ନ୍‍ସା ମେଁ ମ୍ନା ପୁଜାରିଇଂନେ ବାନ୍‍ ଅଦିକାର୍‌ ବାଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC9_15","074_9_15","ACT","9","15","15","ମାପ୍‌ରୁ ଆମେକେ ବାସଙ୍ଗ୍‍କେ, “ୱେଲା ଯିଉଦି ଅଣଜିଉଦି ଇଃସାଙ୍ଗ୍‌ ଆରି ସର୍‌ତେ ଇଶ୍ରାୟେଲୀୟ ରେମୁଆଁଇଂନେ ସେନୁଗ୍‍ ନେଙ୍ଗ୍‍ ମ୍ନି ବାସଙ୍ଗ୍‍ ଅଲେଙ୍ଗ୍‍ ନ୍‍ସା ଆରି ନେଙ୍ଗ୍‍ନେ ସେବା କାମ୍ ଡିଙ୍ଗ୍‍ନ୍‍ସା ନେଙ୍ଗ୍‍ ଆମେକେ ସ୍ରି ମ୍ୱକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_16","074_9_16","ACT","9","16","16","ନେଙ୍ଗ୍‍ ମ୍ନିନ୍‌ସା ଆମେକେ ଉଡ଼ି କସ୍‍ଟ ବିଚେ ୱେନେ ପଡ଼େଏ ନେଙ୍ଗ୍‍ ଆମେକେ ନ୍ନାଃମ୍ୟାଃଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC9_17","074_9_17","ACT","9","17","17","ହନନୀୟ ଯିଉଦାନେ ଡୁଆ ୱେଚେ ଶାଉଲ ଆଡ଼ାତ୍ରା ନ୍ତି ବକେ ଆରି ବାସଙ୍ଗ୍‍କେ “ବୟାଁ ଶାଉଲ ! ମାପ୍‌ରୁ ଜିସୁ ନା ପାଙ୍ଗ୍‍ନେ ଗାଲି ଆନାକେ ଦର୍ସନ୍ ବିବଗେ ନା ଡିରକମ୍‍କି ବାରି ମୁଇଂତର୍‍ କିକେ ନାୟାଏ ଆରି ପବିତ୍ର ଆତ୍ମା ବା ନାୟାଏ ।” ଆତେନ୍‌‍ସା ମେଁ ଆନେଙ୍ଗ୍‍କେ ବେବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_18","074_9_18","ACT","9","18","18","ତେନ୍‍ ଦାପ୍ରେ ସାଉଲ୍‍ନେ ମ୍ମୁଆଃବାନ୍ ଆଃଡ଼ନେ ଚାଲି ରକମ୍‍ ମେଁ ଆଃଡ଼ା ବୁନ୍ଦେ ପୁଏଃଚଗ୍ ଲଃକେ । ଆରି ମେଁ କିକେ ୟାକେ । ବାରି, ମେଁ ତଡ଼ିଆଚେ ଡୁବନ୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_19","074_9_19","ACT","9","19","19","ବଲେ ଚଙ୍ଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ଆମେକେ ବପୁ ପାଙ୍ଗ୍‍କେ । ମେଁ ଦାମାସ୍କସ୍‌ ଇନିନ୍ନିଆ ସିସ୍‍ଇଂ ଏତେ ଉଡ଼ି ଗଣ୍ଟା ଦିନ୍‌ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_20","074_9_20","ACT","9","20","20","ତେନ୍‌ ଇଡ଼ିଂ ସାଉଲ୍‍ ସଏଡ଼ାଃ ଯିଉଦି ପାର୍‌ତନା ଡୁଆଇଂନ୍ନିଆ ୱେଚାଚେ ଆତ୍‍ଅରିଆ ଜିସୁନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‍କେ । ମେଁ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‍କେ “ଜିସୁ ପର୍‍ମେସର୍‍ନେ ଉଙ୍ଗ୍‌ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC9_21","074_9_21","ACT","9","21","21","ଆରି ଜାଣ୍ଡେଇଂ ମେଁ ସାମୁଆଁ ଅଁଆର୍କେ ମେଇଂ ସାପାରେ କାବା ଡିଙ୍ଗ୍‍ଚେ ବାସଙ୍ଗ୍‍ଆର୍କେ ଆକେନ୍‍ ମ୍ନି ସାଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ମ୍ୟାଃକ୍ନେ ରେମୁଆଁଇଂକେ ଜା ଯିରୂଶାଲମ୍‌ନ୍ନିଆ ତାଡ଼ନା ଡିଙ୍ଗ୍‍ଡିଂଗେ “ଆକେନ୍‍ ରେମୁଆଁ ମେଃନେ ମେଁ ଣ୍ଡୁ ଆରି ଆମେଇଂକେ ଗାଗ୍‍ଚେ ମ୍ନା ପୁଜାରିନେ ଡାଗ୍ରା ଡୁଂୱେ ନ୍‍ସା ଆକ୍‍ଅରିଆ ପାଙ୍ଗ୍‍ ଆଲେଃଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC9_22","074_9_22","ACT","9","22","22","ମାତର୍‍ ଶାଉଲନେ ବାସଙ୍ଗ୍‌‍ ଜାବର୍‌ ବପୁ ଲେଃଗେ ଜିସୁ ଜେ କିସ୍‌ଟ ବା ମସିହ ଆକେନ୍‍ ବିସୟ୍‍ରେ ମେଁନେ ପର୍‍ମାନ୍‍ ଅଃକେନ୍ ଜିଦ୍‍ ଲେଃଗେ ଜେ ଦାମାସ୍କସ୍‌ନ୍ନିଆ ବାସା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ଜିଉଦିଇଂ ମେଁନେ ମେଃଡିଗ୍‍ ବ୍ନାଲିର୍‍ରେ ଉତର୍‍ ବିଃ ଆଡିଙ୍ଗ୍‍ ଆର୍ଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC9_23","074_9_23","ACT","9","23","23","ଉଡ଼ିଦିନା ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଜିଉଦିଇଂ ମୁଇଂତୁଗ୍‍ ରିସିଙ୍ଗ୍‍ଚେ ଶାଉଲ୍‍କେ ବାଗୁଏ ନ୍‍ସା ଉପାୟ୍‍ ତୁର୍‍ଆର୍କେ ");
INSERT INTO gaq_vpl VALUES ("AC9_24","074_9_24","ACT","9","24","24","ଜିଉଦିଇଂ ଆମେକେ ବାଗୁଏ ନ୍‍ସା ସ୍ମି ମିଡିଗ୍‍ ନଗର୍‍ନେ ସାପା ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ଡାଗ୍ରା ଉର୍‍ ଆର୍‍ଡିଙ୍ଗଗେ । ମାତର୍‍ ଶାଉଲ ଆକେନ୍‍ ମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_25","074_9_25","ACT","9","25","25","ମାତର୍‍ ମେସୁଆ ମିଡିଗ୍‍ ବେଲା ସାଉଲ୍‍ନେ ସିସ୍‍ଇଂ ଆମେକେ ମୁଇଂ ମ୍ନା ଆଣ୍ଡ୍ରାନ୍ନିଆ ଆକଚେ କାନ୍ଥନେ ମୁଇଂ ରଃବକ୍ନେ ଗାଲିପାକା ବିଚେ ଆଲ ଆଃଜାର୍‍ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_26","074_9_26","ACT","9","26","26","ସାଉଲ୍‍ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ୱେଚାଚେ ସିସ୍‍ଇଂ ଏତେ କୁଡ଼େନ୍‍ସା ଚେସ୍‍ଟା ଡିଙ୍ଗ୍‍କେ ମାତର୍‍ ମେଁ ମୁଇଂ ସିସ୍‍ ଡାଗ୍‍ଚେ ମେଁଇଂ ବିଲ୍‍କୁଲ୍‍ ବିସ୍‍ବାସ୍‍ ଆଡିଙ୍ଗ୍‍ ଆର୍କେ ଣ୍ଡୁ । ସାପାରେ ଆମେକେ ବୁଟମେଗ୍ ଡିଙ୍ଗ୍‍ ଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_27","074_9_27","ACT","9","27","27","ମାତର୍‍ ଇଡ଼ିଙ୍ଗ୍ ବର୍ଣ୍ଣବା ଆମେକେ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂଡାଗ୍ରା ଡୁଂୱେଚେ ଦାମାସ୍କସ୍‌ ଗାଲିନ୍ନିଆ ସାଉଲ୍‍ ଡିରକମ୍‍ ମାପ୍‌ରୁନେ ଦର୍ସନ୍ ବାଲେଃଗେ ଆରି ମାପ୍‌ରୁ ଡିରକମ୍‍ ଆମେକେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ବଗେ ଆକେନ୍‍ ସାପା ବିସୟ୍‍ ଆମେଇଂକେ ଆଦ୍ରିଗ୍‍ଚେ ବାସଙ୍ଗ୍‍କେ । ଦାମାସ୍କସ୍‌ନ୍ନିଆ ଜିସୁନେ ମ୍ନିରେ ସାଉଲ୍‍ ଡିରକମ୍‍ ବାବ୍‍ରେ ବାସଙ୍ଗ୍‌‍ ଡିଙ୍ଗ୍‍ବଗେ ଆମେଇଂକେ ବଲ୍‍ ବାବ୍‍ରେ ଆଦ୍ରିଗ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_28","074_9_28","ACT","9","28","28","ତେନ୍‌ ଇଡ଼ିଂ ସାଉଲ୍‍ ପ୍ରେରିତ୍‌ ସିସ୍‍ଇଂ ଏତେ ଲେଃଚେ ଯିରୂଶାଲମ୍‌ନେ ସାପା ଏରିଆ ୱେଚେ ସାଆସ୍‌ରେ ମାପ୍‌ରୁନେ ମ୍ନିରେ ବାସଙ୍ଗ୍‌‍ ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_29","074_9_29","ACT","9","29","29","ଆକେନ୍‍ ସାପା ବିସୟ୍‌ରେ ମେଁ ଗ୍ରୀକ୍‌ ବାସଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଜିଉଦିଇଂ ଏତେ ବାଲିର୍‌ ବାତାକେ । ମାତର୍ ମେଇଂ ଆମେକେ ବାଗୁଏଃ ନ୍‍ସା ଚେସ୍‍ଟା ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_30","074_9_30","ACT","9","30","30","ବୟାଁଇଂ ଆକେନ୍‍ ମ୍ୟାଃଚେ ଆମେକେ କାଇସରିୟା ନଗର୍‍ନ୍ନିଆ ଡୁଙ୍ଗ୍‍ୱେଚେ ତାର୍ଷିସ୍‌ ନଗର୍‍ନ୍ନିଆ ବେବିଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_31","074_9_31","ACT","9","31","31","ଜିଉଦା ପ୍ରଦେସ୍ ଗାଲିଲୀ ଆରି ସମରିଆନ୍ନିଆ ଲେଡିଙ୍ଗ୍‍କ୍ନେ କିସ୍‌ଟିୟାନ୍‌ ମଣ୍ଡଲିଇଂ ନ୍‍ସା ଆତେନ୍‌‍ବେଲାନେ ଅବସ୍ତା ସାନ୍ତି ଲେଃଗେ ଆରି ପବିତ୍ର ଆତ୍ମାନେ ସାଇଜ୍ୟରେ ମେଇଂନେ ରେମୁଆଁ ସକ୍ୟା ଜାବର୍‌ ଡିଙ୍ଗ୍‍କେ ଆରି ମେଁଇଂ ସାହାସ୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । କିସ୍‍ଟାନ୍‍ ବିସ୍‍ବାସିଇଂ ମାପ୍‌ରୁକେ ବୁଟମେଗ୍‌ଚେ ବକ୍‌ତିରେ ବ୍ରୁଆ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_32","074_9_32","ACT","9","32","32","ପିତର୍‍ ଗୁଲେ ଏରିଆ ଅଲେଙ୍ଗ୍‍ ଅଲେଙ୍ଗ୍‌ ସାରାସାରି ଲୁଦ ନଗର୍‍ନ୍ନିଆ ଲେଡିଙ୍ଗ୍‍କ୍ନେ ସାଦୁଇଂନେ ଡାଗ୍ରା ପିଙ୍ଗ୍‍ଚାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_33","074_9_33","ACT","9","33","33","ଆତ୍‍ଅରିଆ ମେଁ ଏନିୟ ମ୍ନିକ୍ନେ ମୁଇଂ ପକ୍ଷାଗାତ୍‍ ରଗିକେ କେକେ । ମେଁ ତ୍ମାମୁଆଁ ଜାକ ସିଙ୍ଗ୍‌ଲାନ୍ନିଆ ଡୁଲେଗ୍‍ଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_34","074_9_34","ACT","9","34","34","ପିତର୍‍ ଆମେକେ ବାସଙ୍ଗ୍‍କେ, “ଏନିୟ, ଜିସୁ କିସ୍‌ଟ ଆନାକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‍ବକେ । ତଃଡ଼୍ୟାଃ ନାନେଁ ସିଙ୍ଗ୍‍ଲା ସଜେ ।” ଆକେନ୍‍ ବାସଙ୍ଗ୍‍କ୍ନେ ଦାପ୍ରେ ମେଁ ତଃଡ଼୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_35","074_9_35","ACT","9","35","35","ଆକେନ୍‍ କେଚେ ଲୁଦ ଆରି ଶାରୋଣନ୍ନିଆ ବାସା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ରେମୁଆଁଇଂ ମାପ୍‌ରୁନେ ପାକା ଆଣ୍ଡେଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_36","074_9_36","ACT","9","36","36","ଯାପ୍‌ପନ୍ନିଆ ଟାବୀଥା ତେମ୍ନିକ୍ନେ ମୁଇଂ ବିସ୍‌ବାସି ସେଲାମ୍ବୁଏଃ ବାସାଲେଃକେ । ମେଁନେ ଗ୍ରିକ୍‍ ମ୍ନି ଦର୍କାସ୍‌ ବା “ହରିଣି” ଲେଃଗେ । ମେଁ କାଲାଆଃ ଅର୍‍କିତ୍‍ ରେମୁଆଁଇଂକେ ଦାନ୍‍ ବିଡିଙ୍ଗ୍‍ଗେ ଆରି ସତ୍‍ କାମ୍ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_37","074_9_37","ACT","9","37","37","ପିତର୍‍ ଉଡ଼ିବେଲା ଲୁଦ ଇନି ଲେଃଗେ ଆତେନ୍‌‍ବେଲା ଟାବୀଥା ଆଃସାଃବାଚେ ଗୁଏକେ । ରେମୁଆଁଇଂ ମେଁନେ ଗାଗ୍‍ଡ଼େକେ ଗଡ଼ିଆଚେ ଡୁଆନେ ଆଡ଼ାତ୍ରା ମହଲାନେ ବାକ୍ରାନ୍ନିଆ ଆଲୁଏଗ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_38","074_9_38","ACT","9","38","38","ଯାପ୍‌ପନେ ବିସ୍‌ବାସିଇଂ ଅଁଆର୍କେ ଜେ ପିତର୍‍ ଲୁଦଇନି ଲେଃକେ । ଲୁଦ ଆରି ଯାପ୍‌ପ ଡାଗ୍ରା ଲେଃଗେ । ତେସା ମେଁଇଂ ମ୍ୱାୟାକେ ପିତର୍‍ ଡାଗ୍ରା ବାସଙ୍ଗ୍‍ ବେଃକେ, “ଦୟା ଡିଙ୍ଗ୍‍ଚେ ଜିଆଃ ନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("AC9_39","074_9_39","ACT","9","39","39","ପିତର ତିଆର୍‍ ଡିଙ୍ଗ୍‍ଚେ ଆରି ମେଇଂ ଏତେ ୱେକେ । ଆତ୍‍ଅରିଆ ମେଁ ୱେଚାକ୍ନେ ଦାପ୍ରେ ରେମୁଆଁଇଂ ଆମେକେ ଆଡ଼ାତ୍ରା ମହଲାନେ ବାକ୍ରାନ୍ନିଆ ଡୁଂୱେ ଆର୍କେ । ଆତ୍‍ଅରିଆ ଗୁଏସାଙ୍ଗ୍‍କୁଏଇଂ ଆମେକେ ପିତୁର୍‍ପାକା ୱାଚେ ଅଁ ଅଁଚେ ଦର୍କାସ୍‌ ବ୍ରୁଆ ଲେଃକେଲା ତଗ୍‍ବକ୍ନେ ସକା ସେକ୍‍ପୁଆ ଆରି ସକା ପାଟାଇ ପିତ୍‌ରକେ ଆକେ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_40","074_9_40","ACT","9","40","40","ପିତର୍‍ ସାପାରେକେ ବାକ୍ରା ବିତ୍‍ରେବାନ୍‍ ପାଦା ବେଚେ ଆଣ୍ଟୁମାଡ଼େଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍କେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ତର୍‍କାସ୍‍ନେ ଗୁଏକ୍ନେ ଗାଗ୍‌ଡ଼େପାକା ତାମୁଁଚେ ବାସଙ୍ଗ୍‍କେ “ଟାବୀଥା ତଃଡ଼୍ୟା !” ଆତ୍‍ବା ମେଁ ମ୍ମୁଆଃ କେକେ ଆରି ପିତର୍‍କେ କେଚେ ତଃଡ଼୍ୟା କକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_41","074_9_41","ACT","9","41","41","ପିତର୍‍ ମେଁନେ ନ୍ତି ସାଚେ ଆତଡ଼ିଆକେ ଆରି ବିସ୍‍ବାସିଇଂକେ ଆରି ଗୁଏସାଙ୍ଗ୍‍କୁଏଇଂକେ ବାକ୍ରାନ୍ନିଆ ୱାକେ ଆରି ଟାବୀଥା ମ୍ୱ୍ରଲେକ୍ନେ ଆସୁଏକେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_42","074_9_42","ACT","9","42","42","ଆକେନ୍‍ କବର୍‍ ଯାପ୍‌ପନେ ସାପାପାକା ଉଡ୍ରା ଡିଙ୍ଗ୍‍ୱେଗେ । ଆରି ଗୁଲେରୁଆ ମାପ୍‌ରୁକେ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC9_43","074_9_43","ACT","9","43","43","ପିତର୍‍ ଗୁଲେ ଦିନା ଜାକ ଯାପ୍‌ପନ୍ନିଆ ଶିମୋନ ମ୍ନିକ୍ନେ ମୁଇଂ ଚାମାର୍‌ନେ ଡୁଆନ୍ନିଆ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_1","074_10_1","ACT","10","1","1","କାଇସରିୟା ନଗର୍‍ନ୍ନିଆ କର୍ଣ୍ଣୀଲିୟ ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁ ଲେଃଗେ ମେଁ ଇଟାଲୀୟ ମ୍ନିକ୍ନେ ରୋମୀୟ ସନ୍ୟଦଲ୍‍ନେ ମୁଇଂ ସେନାପତି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_2","074_10_2","ACT","10","2","2","ମେଁ ମୁଇଂ ଦାର୍‍ମିକ୍‍ ରେମୁଆଁ ଆରି ମେଁ ଡୁଆନେ ସାପା ରେମୁଆଁ ଇସ୍‍ପର୍‍କେ ବୁଟ ଡିଙ୍ଗ୍‍ଆର୍ଗେ । ମେଁ ଅର୍‍କିତ୍‍ ରେମୁଆଁଇଂକେ ଜାବର୍‌ ଦାନ୍‍ ବିଡିଙ୍ଗ୍‍ଗେ ଆରି କାଲାଆଃ ଇସ୍‍ପର୍‍ ଡାଗ୍ରା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_3","074_10_3","ACT","10","3","3","ମୁଇଂଦିନା ସ୍ମି ପ୍ରାୟ୍ ଞ୍ଜି ଗଣ୍ଟା ବେଲା ମେଁ ମୁଇଂ ମୁସୁଡ଼ିଙ୍ଗ୍‌ ମାଣ୍ଡା ବାବ୍‍ରେ କେକେ ଜେ ଇସ୍‍ପର୍‍ନେ ଦୁତ୍‍ ପାଙ୍ଗ୍‍ଚେ ଆମେକେ ୱାଡିଙ୍ଗ୍‍କେ “କର୍ଣ୍ଣୀଲିୟ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_4","074_10_4","ACT","10","4","4","ମେଁ ବୁଟ୍‍ଚେ କିତଂ ଦୁତ୍‍ ପାକା ତାମୁଁଚେ ବାସଙ୍ଗ୍‍କେ, “ମାପ୍‌ରୁ ମେଁନେ ବାସଙ୍ଗ୍‍ନାଡିଙ୍ଗ୍‍କେ ?” କିତଂ ଦୁତ୍‍ ଉତର୍‍ ବିକେ “ଇସ୍‍ପର୍‍ ନାନେ ପାର୍‌ତନା ଆରି ଅର୍‍କିତ୍‍ ରେମୁଆଁଇଂକେ ଦାନ୍‍ ବିଃନାଡିଂକେ ଆତାନ୍‍ ଡିଗ୍‍ ମେଁ କେଲେକେ । ତେସା ମେଁ ଆନାକେ ମନେ ତ୍ଲାଗ୍‍ଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_5","074_10_5","ACT","10","5","5","“ଏବେ ଯାପ୍‌ପ ନଗର୍‍ନ୍ନିଆ ନାଁ ନାଁନେ ରେମୁଆଁଇଂକେ ବେଚେ ଶିମୋନ ମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁକେ ଆତ୍‍ବା ୱାଡୁଂ ପାଙ୍ଗ୍‍ଲାପା । ଆତେନ୍‌‍ ସିମନ୍‍ ପିତର୍‍ ମ୍ନିରେ ଡିଗ୍‍ ସ୍ନାମୁଆଁ । ");
INSERT INTO gaq_vpl VALUES ("AC10_6","074_10_6","ACT","10","6","6","ମେଁ ମ୍ନା କେଣ୍ଡିଆ ଆଡ଼ାଡାଗ୍ରା ବାସା ଡିଙ୍ଗ୍‍ମ୍ୟାଃକ୍ନେ ଶିମୋନ ମ୍ନିକ୍ନେ ମୁଇଂ ଚାମାର୍‌ନେ ଡୁଆନ୍ନିଆ ଲେଃଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_7","074_10_7","ACT","10","7","7","ଆକେନ୍‍ ବାସଙ୍ଗ୍‍ଚେ କିତଂ ଦୁତ୍‍ ଲାଗ୍‍ଡଗେ । ଆକେନ୍‍ ଇଡ଼ିଙ୍ଗ୍‍ କର୍ଣ୍ଣେଲିଅ ମେଁ ଡୁଆନେ ମ୍ୱାୟା ଗତିରେକେ ଆରି ଆମେକେ ସେବା ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ସନ୍ୟଇଂବାନ୍‍ ମୁଇଂ ଦାର୍‍ମିକ୍‍ ସନ୍ୟକେ ୱାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_8","074_10_8","ACT","10","8","8","ମେଁ ଆମେଇଂକେ ସାପା ସାମୁଆଁ ଆମ୍ୟାଃଚେ ଯାପ୍‌ପନ୍ନିଆ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_9","074_10_9","ACT","10","9","9","ମାର୍‍ତଡ଼େ ମେଁଇଂ ଯାପ୍‌ପ ନଗର୍‍ଡାଗ୍ରା ୱେଚାଆର୍କେ ଆତେନ୍‌‍ବେଲା ପିତର୍‍ ସ୍ମି ବାର୍‍ଟା ବେଲା ବ୍ଲେସାଂ ଆଡ଼ାତ୍ରା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ନ୍‍ସା ୱେଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_10","074_10_10","ACT","10","10","10","ଆମେକେ ଜାବର୍‌ କେଡ଼େସଃ ଡିଙ୍ଗ୍‍ଲା ମେଁ ଚଙ୍ଗ୍‍ନ୍‍ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ମେଁଇଂ ପିତର୍‍ ନ୍‍ସା ବଲେ ଡୁଏନେ ବେଲା ମେଁ ମୁଇଂ ମୁସୁଡ଼ିଙ୍ଗ୍‌ କେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_11","074_10_11","ACT","10","11","11","ମେଁ କେକେ ଜେ କିତଂଇନି ରଃୱେ ଲେଃକେ ଆରି ମୁଇଂ ମ୍ନା ତଗ୍‌ରିଆ ଅଁ କନ୍‍ ପାକାବାନ୍‍ ଆୱେଜଙ୍ଗ୍‍ଚେ ମଞ୍ଚ୍‌ପୁର୍‌ ଆଡ଼ାତ୍ରାପାକା ରେଃସ ଡୁଂପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_12","074_10_12","ACT","10","12","12","ଆତେନ୍‌‍ ବିତ୍‍ରେ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ନାନା ରକମ୍‍ନେ ପସୁ, ବଃଗିଡ଼ିଆ ଆରି କିତଂଇନିନେ ପ୍ଲିଗ୍‍ଇଂ ଲେଃଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_13","074_10_13","ACT","10","13","13","ଆରି ମେଁ ମୁଇଂ ଇଲ୍‍ଏଁ ଅଁକେ, “ପିତର୍‍ ତଃଡ଼୍ୟା ଆକେନ୍‍ ପସୁ ବିତ୍‍ରେବାନ୍‍ ଆଣ୍ଡିନେ ଡିଗ୍‍ ବାଗୁଏଃଚେ ଚଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_14","074_10_14","ACT","10","14","14","ମାତର୍‍ ପିତର୍‍ ବାସଙ୍ଗ୍‍କେ, “ଣ୍ଡୁ ମାପ୍‌ରୁ ନେଙ୍ଗ୍‍ ନାୟା ଣ୍ଡୁ ! ନେଙ୍ଗ୍‍ ଅଃନା ମେଃଡିଗ୍‍ ଅସୁଚି ଆରି ଅପବିତ୍ର ଜିନିସ୍‍ ନ୍ନାଚଙ୍ଗ୍‍କେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_15","074_10_15","ACT","10","15","15","ବାର୍‌ମୁଇଂତର୍‍ ମେଁ ଆକେନ୍‍ ଇଲ୍‍ଏଁ ଅଁକେ, “ପର୍‍ମେସର୍‍ ଆଜାକେ ପବିତ୍ର ଆଡିଙ୍ଗ୍‍ବକେ, ନା ଆମେକେ ଅଶୁଚି ଡାଗ୍‍ଚେ ଆବାସଙ୍ଗ୍‍ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_16","074_10_16","ACT","10","16","16","ଞ୍ଜିତର୍‍ ଦେତ୍‍ରକମ୍‍ ଡିଙ୍ଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଆତେନ୍‌‍ ତଗ୍‍ରିଆକେ କିତଂଇନି ଆଡ଼ାତ୍ରା ଆରି ଗୁରାଙ୍ଗ୍‍ଡକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_17","074_10_17","ACT","10","17","17","ପିତର୍‍ ମେଁନେ ମୁସୁଡ଼ିଙ୍ଗ୍‍ନେ ଅର୍‍ତ ବ୍ନାଇର୍‍ ଏତେଚେ କାବା ଡିଙ୍ଗ୍‍ୱେଗେ । ଆକେନ୍‍ ବେଲା କର୍ଣ୍ଣୀଲିୟ ଆଜାକେ ବେବଗେ ମେଁଇଂ ଶିମୋନନେ ଡୁଆ ତୁର୍‍ ଅଲେଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ ଆର୍ଗେ ମେଁଇଂ ପାଙ୍ଗ୍‍ଚେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ଡାଗ୍ରା ତୁଆଁ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_18","074_10_18","ACT","10","18","18","ମେଁଇଂ ସାଲିଆକୁକେ, ଶିମୋନ ଜାଣ୍ଡେ କି ପିତର୍‍ ଡାଗ୍‌ଚେ ଡିଗ୍‍ ସ୍ନାମୁଆଁ ମେଁ ଆକ୍‍ଅରିଆ କୁଲା ପାଙ୍ଗ୍‍ଲେକେ କି ? ");
INSERT INTO gaq_vpl VALUES ("AC10_19","074_10_19","ACT","10","19","19","ପିତର୍‍ ଆତେନ୍‌‍ ଜାକ ମୁସୁଡ଼ିଙ୍ଗ୍‍ନେ ଅର୍‍ତ ଦ୍ରିଗ୍‍ନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ ଅଃକେନ୍‍ ବେଲା ପବିତ୍ର ଆତ୍ମା ବାସଙ୍ଗ୍‍କେ “କେଲା ଆକ୍‍ଅରିଆ ଞ୍ଜିରୁଆ ରେମୁଆଁ ଆନାକେ ତୁର୍‍ଆର୍‍ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_20","074_10_20","ACT","10","20","20","ତଃଡ଼ିଆ ଆରି ଆଲ ଜାର୍‍ଲା । ଆତେନ୍‌‍ ରେମୁଆଁଇଂ ଏତେ ୱେନ୍‍ସା ମ୍ୱାର୍‌ମନ୍‌ ଆଡିଙ୍ଗ୍‍ଗେ ଡାଗ୍ଲା ନେଙ୍ଗ୍‍ ଆମେଇଂକେ ବେମ୍ୱକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_21","074_10_21","ACT","10","21","21","ପିତର୍‍ ଆଲ ଜାର୍‍ଚେ ଆତେନ୍‌‍ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‍କେ “ପେ ଆଜାକେ ତୁର୍‍ପେଡିଙ୍ଗ୍‍କେ ନେଙ୍ଗ୍‍ ଆତେନ୍‌‍ ରେମୁଆଁ । ପେ ମେଁସା ପାଙ୍ଗ୍‍ପେଲେକେ ?” ");
INSERT INTO gaq_vpl VALUES ("AC10_22","074_10_22","ACT","10","22","22","ମେଁଇଂ ଉତର୍‍ ବିକେ, “ସେନାପତି କର୍ଣ୍ଣୀଲିୟ ଆନେକେ ବେବକେ । ମେଁ ମୁଇଂ ଦାର୍‌ମିକ୍‌ ରେମୁଆଁ । ମେଁ ଇସ୍‍ପର୍‍କେ ବୁଟ ମ୍ୟାଃକେ ଆରି ଜିଉଦିଇଂ ସାପାରେ ଆମେକେ ସନ୍‍ମାନ୍‍ ବିଃମ୍ୟାକେ । ଆନାକେ ମେଁ ଡୁଆ ୱାଚେ ନାନେ ବ୍ନାଇର୍‍ ଅଁନ୍‍ସା ଇସ୍‍ପର୍‍ନେ ମୁଇଂ ଦୁତ୍‍ ଆମେକେ ଆଦେସ୍‌ ବିବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_23","074_10_23","ACT","10","23","23","ତେସା ପିତର୍‍ ଆମେଇଂକେ ବିତ୍‍ରେ ୱାକେ ଆରି ଆତେନ୍‌‍ ମିଡିଗ୍‍ ଆତ୍‍ଅରିଆ ଡୁଲେଗ୍‍ନ୍‍ସା ବାସଙ୍ଗ୍‍କେ । ଆମାର୍‍ତଡ଼େ ମେଁ ତିଆର୍‍ ଡିଙ୍ଗ୍‍ଚେ ମେଇଂ ଏତେ ୱେକେ । ଆରି ଯାପ୍‌ପନ୍ନିଆ ବାସା ଡିଙ୍ଗ୍‍ଆର୍କ୍ନେ ବୟାଁଇଂ ବିତ୍‍ରେ ବାନ୍‍ ଉଡ଼ିରୁଆ ମେଇଂ ଏତେ ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_24","074_10_24","ACT","10","24","24","ମାର୍‍ତଡ଼େ ମେଁଇଂ କାଇସରିୟାଡାଗ୍ରା ୱେଚାଆର୍କେ । ଆତ୍‍ଅରିଆ କର୍ଣ୍ଣୀଲିୟ ନିଜର୍‍ ସାଙ୍ଗଇଂ ଏତେ ଆରି ଡୁଆ ଡାଗ୍ରାନେ ବନ୍ଦୁ କୁଟୁମ୍‍ଇଂ ଏତେ ପିତର୍‍କେ ଉର୍‍ଲେ ଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_25","074_10_25","ACT","10","25","25","ପିତର୍‍ ବିତ୍‍ରେ ଗାନେ ବେଲା କର୍ଣ୍ଣୀଲିୟ ଆମେକେ ଅବାଚେ ମେଁ ଞ୍ଚ ବୁନ୍ଦେ ଲଃଚେ ସାର୍‌ଲକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_26","074_10_26","ACT","10","26","26","ମାତର୍‍ ପିତର୍‍ ଆମେକେ ଆଃତଡ଼ିଆଚେ ବାସଙ୍ଗ୍‍କେ, “ତଃଡ଼ିଆ ନେଙ୍ଗ୍‍ ଡିଗ୍‍ ନା ରକମ୍‍ ମୁଇଂ ରେମୁଆଁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_27","074_10_27","ACT","10","27","27","ପିତର କର୍ଣ୍ଣେଲିଅ ଏତେ ବାଲିର୍‌ ବାତା ଡିଙ୍ଗ୍‍ ବେଲା ଡୁଆ ବିତ୍‍ରେ ଗାଆର୍କେ ଆରି ଆତ୍‍ଅରିଆ ଗୁଲେ ରେମୁଆଁ ରିସିଙ୍ଗ୍‍ ଲେଃନେ କେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_28","074_10_28","ACT","10","28","28","ମେଁ ଆମେଇଂକେ ବାସଙ୍ଗ୍‍କେ “ପେ ମ୍ୟାଃପେଲେକେ ଜେ ମୁଡ଼ି ଜିଉଦି ଡିଗ୍‍ ବିନ୍‍ରେ ଏତେ କୁଡ଼େନେ ଆରି ବିନ୍‍ ଜାତିନେ ରେମୁଆଁଇଂନେ ଡୁଆ ୱେନେ ଜିଉଦି ରେମୁଆଁଇଂନେ ନିୟମ୍‌ନ୍ନିଆ ବିରଦ୍‍ । ମାତର୍‍ ମୁଡ଼ି ରେମୁଆଁ ଡିଗ୍‍ ଅପବିତ୍ର ଆରି ଅସୁଚି ମାବାସଙ୍ଗ୍‍ ନ୍‍ସା ଇସ୍‍ପର୍‍ ଆନେଙ୍ଗ୍‍କେ ଆସୁଏଃ ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_29","074_10_29","ACT","10","29","29","ତେସା ପେ ଅନାବେଲା ଆନେଙ୍ଗ୍‍କେ ପେୱାକେ ନେଙ୍ଗ୍‍ ମେଃଡିଗ୍‍ ଆପତି ମାଡିଙ୍ଗ୍‍ଚେ ମ୍ପାଙ୍ଗ୍‍କେ । ଆନେଙ୍ଗ୍‍ ଏବେ ବାସଙ୍ଗ୍‍ପା ପେ ମେଁସା ଆନେଙ୍ଗ୍‍କେ ୱାପେବଗେ ?” ");
INSERT INTO gaq_vpl VALUES ("AC10_30","074_10_30","ACT","10","30","30","କର୍ଣ୍ଣୀଲିୟ ବାସଙ୍ଗ୍‍କେ “ନେଙ୍ଗ୍‍ ଟିକ୍‍ ଅଁସି ଦିନା ସେନୁଗ୍‍ ନେଙ୍ଗ୍‍ ଡୁଆ ସ୍ମି ତିନ୍‍ଟା ବେଲା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଣ୍ଡିଙ୍ଗ୍‍ଗେ । ଆତେନ୍‌‍ ବେଲା ଉଲୁସ୍ତେ ମୁଇଂ କିତଂ ଦୁତ୍‍ ତାର୍‍କିଗ୍‌କ୍ନେ ସକା ସଃଲେକ୍ନେ ମୁଇଂ ରେମୁଆଁ ନେଙ୍ଗ୍‍ ସେନୁଗ୍‍ ତୁଆଁଚେ ବାସଙ୍ଗ୍‍କେ; ");
INSERT INTO gaq_vpl VALUES ("AC10_31","074_10_31","ACT","10","31","31","‘କର୍ଣ୍ଣୀଲିୟ ! ଇସ୍‍ପର୍‍ ନାନେ ପାର୍‌ତନା ଅଁଲେକେ ଆରି ନା ଅର୍‍କିତ୍‍ ରେମୁଆଁଇଂକେ ବିଃନାବକ୍ନେ ଦାନ୍‍ଡିଗ୍‍ ମନେ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_32","074_10_32","ACT","10","32","32","ତେସା ଯାପ୍‌ପନ୍ନିଆ ରେମୁଆଁ ବେଚେ ପିତର ମ୍ନିରେ ସ୍ନାମୁଁଆଃ ଶିମୋନକେ ଆକ୍‍ଅରିଆ ୱାପା । ମେଁ ମ୍ନା କେଣ୍ଡିଆ ଆଃଡ଼ାଃ ଚାମାର୍‌ ଶିମୋନନେ ଡୁଆନ୍ନିଆ ଲେଃଡିଂକେ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC10_33","074_10_33","ACT","10","33","33","ତେସା ନେଙ୍ଗ୍‍ ଆନାକେ ଜିଆ ଜିଆ ୱାନ୍‍ସା ମ୍ୱେକେ । ବଲ୍‍ ଡିଙ୍ଗ୍‍ଗେ ନା ଆକ୍‍ଅରିଆ ନାପାଙ୍ଗ୍‍କେ । ମାପ୍‌ରୁ ଆନାକେ ମେଃନେ ବାସଙ୍ଗ୍‍ ନ୍‌ସା ଆଦେସ୍‍ ବିବକେ ଆତେନ୍‌‍ ଦ୍ରିଗ୍‍ନ୍‍ସା ନେ ସାପାରେ ଆକ୍‍ଅରିଆ ଇସ୍‍ପର୍‍ନେ ସେନୁଗ୍‍ ଉର୍‍ଚେ ନେଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_34","074_10_34","ACT","10","34","34","ପିତର ବାସଙ୍ଗ୍‍ନେ ଆରାମ୍‍ ଡିଙ୍ଗ୍‍କେ “ନେଙ୍ଗ୍‍ ଏବେ ବୁଜେୟା ଣ୍ଡିଙ୍ଗ୍‍କେ ଜେ ପକ୍‌ରୁତ୍‌ରେ ଇସ୍‍ପର୍‍ନେ ମୁଆଃନ୍ନିଆ ସାପା ରେମୁଆଁ ସମାନ୍‍ । ମେଁ ଡାଗ୍ରା ମେଃଡିଗ୍‍ ବେଦବାବ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC10_35","074_10_35","ACT","10","35","35","ମୁଡ଼ି ରେମୁଆଁ ଡିଙ୍ଗ୍‍ଲେ ମାତର୍‍ ମାପ୍‍ରୁକେ ବୁଟଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଲା ଆରି ମେଁ ମୁଆଃନ୍ନିଆ ସତ୍‌କାମ୍‌ ଡିଙ୍ଗ୍‍ଲା ମାପ୍‌ରୁ ଆମେକେ ଗ୍ରଅନ୍‍ ଡିଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC10_36","074_10_36","ACT","10","36","36","ପେ ମ୍ୟାପେଲେଃକେ ଜେ ଇସ୍‍ପର୍‍ ଇଶ୍ରାୟେଲୀୟ ରେମୁଆଁଇଂନେ ଡାଗ୍ରା ଆଣ୍ଡିନେ ବ୍ନାଲିର୍‌ ବେବଗେ ଆତେନ୍‌‍ଆ ଜିସୁବାନ୍‍ ବାଲିର୍‌ବକ୍ନେ ସାନ୍ତିନେ ବ୍ନାଇର୍‍ । ଆତେନ୍‌‍ ଜିସୁ କିସ୍‌ଟ ଆଃ ସାପାରେନେ ମାପ୍‌ରୁ । ");
INSERT INTO gaq_vpl VALUES ("AC10_37","074_10_37","ACT","10","37","37","ଏନ୍ ଜିସୁ ସାପାରେନେ ମାପ୍‌ରୁ । ଜହନ୍‌ ମନ୍‌ବଦ୍‌ଲେଃ ନ୍‌ସା ବାରି ଣ୍ଡିଆଦିକ୍ୟାନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ଗାଲିଲୀବାନ୍‌ ଆରାମ୍‌ ଡିଙ୍ଗ୍‌ଚେ ସାପା ଜିଉଦା ପ୍ରଦେସ୍‌ନ୍ନିଆ ମେଃନେ ସାପା ଗଟ୍‍ନା ଗଟେକେ ଆତେନ୍‌ ସାପା ପେ ମ୍ୟାପେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_38","074_10_38","ACT","10","38","38","ପେ ନାଜରିତ ଜିସୁନେ ବିସୟ୍‌ରେ ମ୍ୟାଃପେଲେକେ । ଇସ୍‍ପର ଆମେକେ ପବିତ୍ର ଆତ୍ମା ଆରି ବପୁ ବିଚେ କିସ୍ଟରେ ଅବିସିକ୍ତ ଆଡିଙ୍ଗ୍‍ବଗେ । ଜିସୁ ସାପାପାକା ୱେଚେ ରେମୁଆଁଇଂକେ ଉପକାର୍‍ ଆଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ । ଆରି ସୟତାନ୍‌ ଗାଗ୍‍ଚେ ଲେକ୍ନେ ରେମୁଆଁଇଂକେ ନିମାଣ୍ଡା ଆଡିଙ୍ଗ୍‍କେ ମାତର୍‍ ଇସ୍‍ପର୍‍ ମେଁ ଏତେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_39","074_10_39","ACT","10","39","39","ଜିଉଦିଇଂନେ ଦେସ୍‍ନ୍ନିଆ ଆରି ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ମେଁ ଜା ସାପା କାମ୍ ଡିଙ୍ଗ୍‍କେ ନେ ଆତେନ୍‌‍ ସାପାନେ ସାକି ନେଲେଃକେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଁଇଂ ଆମେକେ କୁରୁସ୍‍ନ୍ନିଆ ଆଡେଚେ ବାଗୁଏଃ ବିଃଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_40","074_10_40","ACT","10","40","40","ମାତର୍‍ ଇସ୍‍ପର୍‍ ଜିର୍‌ସି ବିତ୍‍ରେ ଆମେକେ ଗୁଏକ୍ନେବାନ୍ ଆଃତଡ଼ିଆଚେ ରେମୁଆଁଇଂନେ ଡାଗ୍ରା ଆସୁଏକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_41","074_10_41","ACT","10","41","41","ମାତର୍‍ ଜିସୁ ସାପାରେକେ ଆରାସୁଏକେ ଣ୍ଡୁ । ଇସ୍‍ପର୍‍ ଜାଣ୍ଡେକେ ମେଁନେ ସାକି ରକମ୍‍ ପୁର୍‍ବେବାନ୍‍ ସ୍ରି ବଗେ ମେଇଂଆ ମାତର୍‌‍ ଆମେକେ କେଆର୍କେ ଆତେନ୍‌‍ ନେ ସାକି ନେଲେକେ । ଜିସୁ ଗୁଏଚେ ତଃଡ଼ିଆକ୍ନେ ବାନ୍‍ ନେ ମେଁ ଏତେ ଚଙ୍ଗ୍‍ଉଗ୍‍ ନେଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_42","074_10_42","ACT","10","42","42","ରେମୁଆଁଇଂ ଡାଗ୍ରା ନିମାଣ୍ଡା ସାମୁଆଁ ବାଲିର୍‌ ନ୍‌ସା ଆରି ଇସ୍‍ପର୍‍ ଜେ ଆମେକେ ମ୍ୱ୍ରରେକେ ଆରି ଗୁଏରେକେ ବିଚାର୍ ଡିଙ୍ଗ୍‍ନ୍‍ସା ବାଚେ ବକେ ଆକେନ୍‍ ସାମୁଆଁରେ ସାକି ବିନ୍‍ସା ମେଁ ଆନେକେ ଆଦେସ୍‍ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_43","074_10_43","ACT","10","43","43","ଜା ଡିଗ୍‍ ଆମେକେ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଏ ମେଁନେ ମ୍ନିନେ ବପୁରେ ମେଁନେ ପାପ୍‍ କେମା ବାଏ । ଆକେନ୍‍ ସାପା ବାବବାଦି ମେଁ ବିସୟ୍‍ରେ ସାକି ବିମ୍ୟାକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC10_44","074_10_44","ACT","10","44","44","ପିତର ଆକେନ୍‍ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ନେ ବେଲା ଜାଣ୍ଡେଇଂ ମେଁନେ ସାମୁଆଁ ଅଁଆର୍‍ଡିଂଗେ, ଆତେନ୍‌‍ ସାପାରେ ଆଡ଼ାତ୍ରା ପବିତ୍ର ଆତ୍ମା ପାଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_45","074_10_45","ACT","10","45","45","ଅଣଜିଉଦିଇଂନେ ଆଡ଼ାତ୍ରା ଡିଗ୍ ଇସ୍‍ପର୍‍ ମେଁନେ ପବିତ୍ର ଆତ୍ମା ଦାନ୍‍ ବିବକ୍ନେ କେଚେ ପିତର୍‍ ଏତେ ପାଙ୍ଗ୍‍ଲେଆର୍‌କ୍ନେ ଯାପ୍‌ପନେ ଜିଉଦି ବିସ୍‌ବାସିଇଂ ଡିଗ୍‍ ବକୁଆ ଡିଙ୍ଗ୍‍ୱେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_46","074_10_46","ACT","10","46","46","ମେଃଡାଗ୍‍ଲା ଯିଉଦି ବିସ୍‍ବାସିଇଂ ଇସ୍‍ପର୍‍କେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କ୍ନେ ଆରି ବିନ୍‍ ବ୍ନାସାରେ ବ୍ନାଇର୍‍ ବାସଙ୍ଗ୍‍ଡିଂଆର୍‌କ୍ନେ ଅଁଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC10_47","074_10_47","ACT","10","47","47","ପିତର ବାସଙ୍ଗ୍‌କେ, “ନେ ରକମ୍‍ ଆକେନ୍‍ ରେମୁଆଁଇଂ ଡିଗ୍‍ ପବିତ୍ର ଆତ୍ମା ବାଲେଆର୍କେ । ଡୁବନ୍‌ ଡୁଂଡନ୍‍ସା ଜା ମେଁନେ ଆମେଇଂକେ କସ୍‍ଟ ବିୟାଏ ?” ");
INSERT INTO gaq_vpl VALUES ("AC10_48","074_10_48","ACT","10","48","48","ତେସା ମେଁ ଆମେଇଂକେ ଜିସୁ କିସ୍‌ଟନେ ମ୍ନିରେ ଡୁବନ୍‌ ଡୁଙ୍ଗ୍‍ଡନ୍‍ସା ଆଦେସ୍‌ ବିକେ । ତେନ୍‌ ଇଡ଼ିଂ ରେମୁଆଁଇଂ ପିତର୍‍କେ ମେଇଂ ଏତେ ଉଡ଼ିଦିନା ସୁଗୁଆ ଲେଃନ୍‍ସା ବାସଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_1","074_11_1","ACT","11","1","1","ଅଣଜିଉଦିଇଂ ଡିଗ୍‍ ଇସ୍‍ପର୍‍ନେ ସାମୁଆଁ ଗ୍ରଅନ୍‍ ଡିଙ୍ଗ୍‍ଆର୍‍ଲେକେ ଡାଗ୍‍ଚେ ସିସ୍‌ଇଂ ଆରି ଜିଉଦା ପ୍ରଦେସ୍‌ନ୍ନିଆ ଲେଃଡିଂକ୍ନେ ବିନ୍‍ ବୟାଁଇଂ ଅଁଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_2","074_11_2","ACT","11","2","2","ତେସା ପିତର୍‍ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ୱେଚାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ପବିତ୍ର‌ ଡିଙ୍ଗ୍‍ଲେ ଆର୍‌କ୍ନେ ରେମୁଆଁଇଂ ଆମେକେ ବାଲିର୍‌ ବାତାଚେ ବାସଙ୍ଗ୍‍କେ ");
INSERT INTO gaq_vpl VALUES ("AC11_3","074_11_3","ACT","11","3","3","“ପେ ପବିତ୍ର ମାଡିଙ୍ଗ୍‍ଲେକ୍ନେ ରେମୁଆଁଇଂନେ ଡୁଆ ୱେପେଡିଙ୍ଗ୍‍କେ ଆରି ମେଇଂ ଏତେ ଚଙ୍ଗ୍‍ଉଗ୍‍ ପେଡିଙ୍ଗ୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC11_4","074_11_4","ACT","11","4","4","ମାତର୍‍ ମୁଲେବାନ୍‍ ମେଁ ମେଃନେ ଗଟେଲେଗେ, ପିତର୍‍ ଆମେଇଂକେ ସାପା ଗଟ୍‌ନାଇଂ ଆଦ୍ରିଗ୍‍ଚେ ବାଲିର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_5","074_11_5","ACT","11","5","5","“ନେଙ୍ଗ୍‍ ଯାପ୍‌ପ ନଗର୍‍ନ୍ନିଆ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍କେଲା ମୁଇଂ ମୁସୁଡ଼ିଙ୍ଗ୍‍ ଙ୍କେକେ । ମୁଇଂ ତଗ୍‌ରିଆ ଅଁକନ୍‍ ପାକା ସାଃଚେ କିତଂଇନିବାନ୍‍ ନେଙ୍ଗ୍‍ ପାକା ରେଃସଚେ ଜାର୍‍ନେ ନେଙ୍ଗ୍‍ ଙ୍କେକେ ଆତେନ୍‌‍ ନେଙ୍ଗ୍‍ ଡାଗ୍ରା ଅଟ୍‍କେ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_6","074_11_6","ACT","11","6","6","ନେଙ୍ଗ୍‍ ବଲ୍‍ ବାବ୍‍ରେ ଆତେନ୍‌‍ ବିତ୍‍ରେ ନିମାଣ୍ଡାଃ ଙ୍କେଲା ଆତେନ୍‌‍ ମଞ୍ଚ୍‌ପୁର୍‌ ବିତ୍‍ରେ ଅଁକ୍ଲିଗ୍ ଞ୍ଚଲେକ୍ନେ ପସୁ କଣ୍ଡାନେ ଜିବ୍‍ ଜନ୍ତୁ, ବଃଗିଡ଼ିଆ ଆରି କିତଂଇନିନେ ପ୍ଲିଗ୍‍ଇଂ ଲେଃଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_7","074_11_7","ACT","11","7","7","ତେନ୍‌ ଇଡ଼ିଂ ନେଙ୍ଗ୍‍ ମୁଇଂ ଇଲ୍‍ଏଁ ଙକେ ପିତର ! ତଃଡ଼୍ୟାଃ ଆରି ବାଗୁଏଃଚେ ଚଙ୍ଗ୍‍ । ");
INSERT INTO gaq_vpl VALUES ("AC11_8","074_11_8","ACT","11","8","8","ମାତର୍‍ ନେଙ୍ଗ୍ ଉତର୍‍ ମ୍ୱିକେ, ଣ୍ଡୁ ମାପ୍‌ରୁ ! ନେଙ୍ଗ୍‍ ନ୍ନାୟା ଣ୍ଡୁ । ଏ ଜାକ ମେଃଡିଗ୍‍ ଅସୁଚି ବା ଅପବିତ୍ର ବଲେ ନେଙ୍ଗ୍‍ ଅଃନା ନ୍ନାଚଙ୍ଗ୍‍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC11_9","074_11_9","ACT","11","9","9","କିତଂଇନି ବାନ୍‍ ବାର୍‌ମୁଇଂତର୍‍ ଆକେନ୍‍ ଇଲ୍‍ଏଁ ଡିଙ୍ଗ୍‍କେ ଇସ୍‍ପର୍‍ ଆଜାକେ ପବିତ୍ର ଆଡିଙ୍ଗ୍‍ବକେ ନା ଆମେକେ ଅଶୁଚି ଆବାବେଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC11_10","074_11_10","ACT","11","10","10","ଞ୍ଜିତର୍‍ ଦେକ୍‍ରକମ୍ ଡିଙ୍ଗ୍‍କେ ସାରାସାରି କେଲା ଆତେନ୍‌‍ ସାପା ଜିବ୍‌ଇଂକେ ବାରି କିତଂଇନି ଆଡ଼ାତ୍ରା ଗୁ ଡୁଂଡ ଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_11","074_11_11","ACT","11","11","11","ଟିକ୍‍ ଆତେନ୍‌‍ବେଲା କାଇସରିୟାବାନ୍‍ ନେଙ୍ଗ୍‍ଡାଗ୍ରା ଞ୍ଜିରୁଆ ରେମୁଆଁଇଂ ନେଙ୍ଗ୍‍ ଆଣ୍ଡିନ୍‍ ଡୁଆ ଲେଣ୍ଡିଂଗେ ଆତ୍‍ଅରିଆ ୱେଚାଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_12","074_11_12","ACT","11","12","12","ଆରି ମେଃଡିଗ୍‍ ମ୍ୱାର୍‌ମନ୍‌ ମାଡିଙ୍ଗ୍‍ଚେ ମେଇଂ ଏତେ ୱେନ୍‍ସା ପବିତ୍ର ଆତ୍ମା ଆନେଙ୍ଗ୍‍କେ ବାସଙ୍ଗ୍‍କେ । ବାରି ଯାପ୍‌ପନେ ତୁର୍‍ରୁଆ ବିସ୍‌ବାସି ବୟାଁ ଡିଗ୍‍ ନେଙ୍ଗ୍‍ ଏତେ କାଇସରିଆ ୱେଆର୍କେ ବାରି ନେ ସାପାରେ କର୍ଣ୍ଣେଲିଅଇଂନେ ଡୁଆ ନେୱେଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_13","074_11_13","ACT","11","13","13","କର୍ଣ୍ଣେଲିଅ ଡିରକମ୍‍ ମେଇଂ ଡୁଆ ମୁଇଂ କିତଂ ଦୁତ୍‍କେ କେକେ ଆତେନ୍‌‍ ସାପା ଆନେକେ ବାଲିର୍‍କେ । ଆକେନ୍‍ ଦୁତ୍‍ ଆମେଇଂକେ ବାସଙ୍ଗ୍‍କେ, “ଯାପ୍‌ପ ନଗର୍‍ ରେମୁଆଁ ବେଚେ ପିତର୍‍ ମ୍ନିରେ ସ୍ନାମୁଁଆଃ ଶିମୋନକେ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଲାପା । ");
INSERT INTO gaq_vpl VALUES ("AC11_14","074_11_14","ACT","11","14","14","ମେଁ ଆନାକେ ବାରି ପେ ଡୁଆ ଲେଡିଙ୍ଗ୍‍କ୍ନେ ରେମୁଆଁଇଂକେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଏ ଜାଣ୍ଡେଃବାନ୍‍ କି ପେ ସାପାରେ ଉଦାର୍‍ ପେବାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC11_15","074_11_15","ACT","11","15","15","ବାରି ନେଙ୍ଗ୍‍ ଉଡ଼ିବେଲା ସାମୁଆଁ ବାସଙ୍ଗ୍‍ନେ ଆରାମ୍‍ ଣ୍ଡିଙ୍ଗ୍‍କେ ପର୍‍ତୁମ୍‍ ପବିତ୍ର ଆତ୍ମା ଡିରକମ୍‍ ନେ ଆଡ଼ାତ୍ରା ଜାର୍‍ଲେଗେ ଦେତ୍‍ରକମ୍‍ ମେଇଂନେ ଆଡ଼ାତ୍ରା ଜାର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_16","074_11_16","ACT","11","16","16","ତେନ୍‌ଇଡ଼ିଂ ନେଙ୍ଗ୍‍ ମାପ୍‌ରୁନେ ଆକେନ୍‍ ସାମୁଆଁକେ ଇଏଁତେକେ: “ଜହନ୍‌ ଣ୍ତିଆନ୍ନିଆ ଡୁବନ୍‌ ବିକେ, ସତ୍‌ ମାତର୍‍ ପେ ପବିତ୍ର ଆତ୍ମାବାନ୍‍ ଡୁବନ୍‌ ପେବାଏ । ");
INSERT INTO gaq_vpl VALUES ("AC11_17","074_11_17","ACT","11","17","17","ମାପ୍‌ରୁ ଜିସୁ କିସ୍‌ଟନ୍ନିଆ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ପେଲେଗ୍‍ସା ପର୍‍ମେସର୍‍ ଆନେକେ ଡିରକମ୍‍ ପବିତ୍ର ଆତ୍ମା ଦାନ୍‍ ବିବକେ ଅଣଜିଉଦିଇଂକେ ଡିଗ୍‍ ଆତେନ୍‌‍ ଦାନ୍ ବିବକେ; ନେଙ୍ଗ୍‍ ଜାଣ୍ଡେଃ ଚେଃ ଇସ୍‍ପର୍‍ନେ ଆକେନ୍‍ କାମ୍‍କେ ପ୍ରତିରଦ୍‍ ଣ୍ଡିଙ୍ଗ୍‍ଏ !” ");
INSERT INTO gaq_vpl VALUES ("AC11_18","074_11_18","ACT","11","18","18","ମେଁଇଂ ଆକେନ୍‍ ଅଁକ୍ନେ ଇଡ଼ିଂ ଆରି ଜୁକ୍‌ତି ତର୍କ ମାଡିଙ୍ଗ୍‍ଚେ ଇସ୍‍ପର୍‍କେ ପ୍ରସଂସା ଡିଙ୍ଗ୍‍ଚେ ବାସଙ୍ଗ୍‍କେ “ତେଲା ଇସ୍‍ପର୍‍ ଅଣଜିଉଦିଇଂକେ ଡିଗ୍‍ ମନେ ଏତେ ନ୍‍ସା ବାରି ବ୍ରୁଆନ୍‍ସା ସୁଜଗ୍‍ ବିବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC11_19","074_11_19","ACT","11","19","19","ସ୍ତିଫାନ ଗୁଏକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଆଣ୍ଡିନେ ତାଡ଼ନା ଗଟେକେ ଆତେନ୍‌‍ସା ବିସ୍‍ବାସିଇଂ ସାପାପାକା ଚିନ୍‍ଚତର୍‍ ଡିଙ୍ଗ୍‍ୱେଆର୍‌କ୍ନେ ବେଲା ମେଇଂନେ ବାନ୍‍ ଉଡ଼ିରୁଆ ଜିଉଦିଇଂନେ ଡାଗ୍ରା ବାସଙ୍ଗ୍‌‌ଚେ ପୈନିକିଆ ସାଇପ୍ରସ୍ ବାରି ଆଣ୍ଟିୟକ ଜାକ ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_20","074_11_20","ACT","11","20","20","ଆକେନ୍‍ ବିସ୍‍ବାସିଇଂବାନ୍‍ ଉଡ଼ିରୁଆ ସାଇପ୍ରସ୍‌ ଆରି କୁରୁଣୀନେ ରେମୁଆଁ ଲେଃଗେ ମେଁଇଂ ଆଣ୍ଟିୟକନ୍ନିଆ ପାଙ୍ଗ୍‍ଚେ ଗ୍ରୀକ୍‌ ବାସଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଜିଉଦିଇଂ ଡିଗ୍‍ ମାପ୍‌ରୁ ଜିସୁ କିସ୍‌ଟନେ ନିମାଣ୍ଡାସାମୁଆଁ ବାସଙ୍ଗ୍‌‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_21","074_11_21","ACT","11","21","21","ଇସ୍‍ପର୍‍ନେ ବପୁ ମେଇଂ ଏତେ ଲେଃଗେ ତେସା ଗୁଲେ ରେମୁଆଁ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଚେ ମାପ୍‌ରୁନେ ପାକା ମନ୍‍ ଆଆଁଣ୍ଡେ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_22","074_11_22","ACT","11","22","22","ଉଡ଼ିବେଲା ଆକେନ୍‍ କବର୍‍ ଯିରୁସାଲାମ୍‌ ମଣ୍ଡଲିନ୍ନିଆ ୱେଚାକେ ମେଁଇଂ ବର୍ଣ୍ଣବାକେ ଆଣ୍ଟିୟକ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_23","074_11_23","ACT","11","23","23","ମେଁ ଆତ୍‍ଅରିଆ ୱେଚାଚେ ଇସ୍‍ପର୍‍ ଆତେନ୍‌‍ ରେମୁଆଁଇଂକେ ଡିଡି ରକମ୍‍ ଆସିର୍‍ବାଦ୍‍ ବିଃବକେ ଆତେନ୍‌‍ ଅନୁଗ୍ର‍ଅ କେଚେ ସାର୍‍ଦା ଡିଙ୍ଗ୍‍ଆର୍କେ ଆରି ଜେନ୍ତିକି ମେଇଙ୍ଗ୍‌ ଜିବନ୍‌ନ୍ନିଆ ମୁଇଙ୍ଗ୍‌ ମନ୍‌ରେ ମାପ୍‌ରୁ ଆଡ଼ାତ୍ରା ଡସେ ଲେଃଆର୍‍ଏ, ଆତେନ୍‌‍ସା ସାପାରେ ଆମ୍ଲେଡ଼ିଆକେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_24","074_11_24","ACT","11","24","24","ବର୍ଣ୍ଣବା ମୁଇଂ ଦାର୍‍ମିକ୍‍ ରେମୁଆଁ ଲେଃଗେ । ମେଁ ପବିତ୍ର ଆତ୍ମା ବାରି ବିସ୍‌ବାସ୍‌ରେ ତ୍ନ ଲେଃଗେ । ତେସା ଗୁଲେରୁଆ ବାସଙ୍ଗ୍‌‍କ୍ନେବାନ୍‍ ମାପ୍‌ରୁନ୍ନିଆ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_25","074_11_25","ACT","11","25","25","ତେନ୍‌ ଇଡ଼ିଂ ବର୍ଣ୍ଣବା ଶାଉଲକେ ତୁର୍‍ନ୍‍ସା ତାର୍ଷିସ୍‌ ନଗର୍‍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_26","074_11_26","ACT","11","26","26","ଆତ୍‍ଅରିଆ ଆମେକେ ଅବାଚେ ଆଣ୍ଟିୟକନ୍ନିଆ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଆର୍କେ । ଶାଉଲ ବାରି ବର୍ଣ୍ଣବା ଆତ୍‍ଅରିଆ ମୁଇଂ ମୁଆଁ ଜାକ ମଣ୍ଡଲିନେ ଏତେ ଲେଃଗେ ବାରି ଉଡ଼ିତର୍‍ ବିସ୍‌ବାସିଇଂନେ ଦଲ୍‍ ମେଇଂ ଡାଗ୍ରା ୱେଆର୍କେ ମେଁଇଂ ଆମେଇଂକେ ଅବାକେ ବାରି ଗୁଲେ ରେମୁଆଁକେ ବୁଦି ବିକେ । ଆକେନ୍‍ ଆଣ୍ଟିୟକନେ ବିସ୍‍ବାସିଇଂକେ ରେମୁଆଁଇଂ ପର୍‍ତୁମ୍‍ କିସ୍‌ଟିୟାନ୍‌ ଡାଗ୍‌ଚେ ମ୍ନି ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_27","074_11_27","ACT","11","27","27","ଆତେନ୍‌‍ବେଲା ଉଡ଼ିରୁଆ ବାବବାଦି ଯିରୂଶାଲାମ୍‌ବାନ୍‌ ଆଣ୍ଟିୟକନ୍ନିଆ ପାଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_28","074_11_28","ACT","11","28","28","ମେଇଂ ବିତ୍‍ରେ ବାନ୍‍ ଆଗାବ ମ୍ନିରେ ମୁଇଂ ରେମୁଆଁ ପବିତ୍ର ଆତ୍ମାନେ ବପୁରେ ତ୍ନଚେ ମଞ୍ଚ୍‌ପୁର୍‌ନ୍ନିଆ ମୁଇଂ ବୟ୍‍ଙ୍କାର୍‍ ମୁର୍‍ଡି ଡିଙ୍ଗ୍‍ ଡାଗ୍‍ଚେ ବବିସତ୍‍ ସାମୁଆଁ ଆଃଅଁକେ । ଆକେନ୍‍ ମୁର୍‍ଡି ଇଃସାଙ୍ଗ୍‌ କ୍ଲଡିୟସ୍‍ନେ ବେଲା ଗଟେଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_29","074_11_29","ACT","11","29","29","ଆତ୍‍ବା ସିସ୍‍ଇଂ ସାପାରେ ନିଜେନେ କେମତା ଇସାବ୍‍ରେ ଜିଉଦା ପ୍ରଦେସ୍‌ନ୍ନିଆ ବାସା ଡିଙ୍ଗ୍‍ଆର୍‍କ୍ନେ ବୟାଁଇଂନ୍‍ସା ସାଇଜ୍ୟ ବେନ୍‍ସା ଚିନ୍ତା ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC11_30","074_11_30","ACT","11","30","30","ମେଁଇଂ ସାପା ଡାବୁ ରାସିଙ୍ଗ୍‌ଚେ ଶାଉଲ ଆରି ବର୍ଣ୍ଣବାକେ ବିଆର୍‌କେ । ଶାଉଲ ଆରି ବର୍ଣ୍ଣବା ଆତେନ୍‌‍ ଡାବୁକେ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ମଣ୍ଡଲିନେ ସେବକଇଂନେ ଡାଗ୍ରା ଆତେନ୍‌‍ ବେବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_1","074_12_1","ACT","12","1","1","ଆକେନ୍‍ ବେଲା ଇଃସାଙ୍ଗ୍‌ ହେରୋଦ ମଣ୍ଡଲିନେ ଉଡ଼ିରୁଆ ରେମୁଆଁନେ ଆଡ଼ାତ୍ରା ଅତ୍ୟାଚାର୍‍ ଡିଙ୍ଗ୍‍ନେ ଆରାମ୍‍ ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_2","074_12_2","ACT","12","2","2","ମେଁ ଜହନ୍‌ନେ ବୟାଁ ଜାକୁବ୍‌କେ କାଣ୍ଡା ଏତେ ଆବାଗୁଏ ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_3","074_12_3","ACT","12","3","3","ଜିଉଦିଇଂକେ ଆତ୍‍ବା ସନ୍ତସ୍‍ କେଚେ ମେଁ ପିତର୍‍କେ ଡିଗ୍‍ ଗାଗ୍‍ନ୍‍ସା ୱେଆର୍କେ । ଆତେନ୍‌‍ ବେଲା ଖମିର ସୁନ୍ୟ ରୁଟିନେ ପାଣ୍ଡୁଏ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_4","074_12_4","ACT","12","4","4","ପିତର୍‍ ଆଗାଗ୍‍ଚେ କଇଦ୍‍ ଡୁଆନ୍ନିଆ ଲେଃଗେ ବାରି ଅଁଣ୍ଡ୍ରୁଆ ଅଁଣ୍ଡ୍ରୁଆ ମନ୍ତ୍ରିକେ ଡୁଂୱେଚେ ଅଁ ରାସି ମନ୍ତ୍ରି‍ଇଂ ଆମେକେ ଉର୍‍ ଲେଃଆର୍ଗେ । ଉଦାର୍‍ ପାଣ୍ଡୁଏ ଇଡ଼ିଙ୍ଗ୍‍ ରେମୁଆଁଇଂନେ ଡାଗ୍ରା ମେଁ ବିଚାର୍‍ ଡିଙ୍ଗ୍‍ନେ ହେରୋଦନେ ଉଦେସ୍‍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_5","074_12_5","ACT","12","5","5","ପିତର୍‍ କ‍ଏଦ୍‍ ଡୁଆ ଲେଃକେଲା ମଣ୍ଡଲିନେ ରେମୁଆଁଇଂ ମୁଇଂ ମନ୍‍ରେ ମେଁ ଆତ୍‍ଲା ଇସ୍‍ପର୍‍ ଡାଗ୍ରା ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_6","074_12_6","ACT","12","6","6","ଆଣ୍ଡିନ୍‍ଦିନା ହେରୋଦ ପିତର୍‍କେ ରେମୁଆଁଇଂନେ ସାମ୍‍ନେ ଡୁଂପାଙ୍ଗ୍‍ନ୍‍ସା ଜଜନା ଡିଙ୍ଗ୍‍ବଗେ ମେଁନେ ୱେକ୍ନେ ମିଡିଗ୍‍ ପିତର୍‍ ମ୍ୱାକିଲିଗ୍‍ ସିକ୍ଲି ଏତେ ଆଗାଗ୍‍ଚେ ମ୍ୱାୟା ସନ୍ୟଇଂନେ ମଜେ ଆଡୁଲେଗ୍‍କେ । କଇଦ୍‍ ଡୁଆନେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ଡାଗ୍ରା ଜାଗୁଆଲ୍‍ଇଂ ଉର୍‍ ଲେଃଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_7","074_12_7","ACT","12","7","7","ଟାପ୍‍ନା ମାପ୍‌ରୁନେ ମୁଇଂ ଦୁତ୍‍ ପାଙ୍ଗ୍‍ଚେ ତୁଆଁକେ ବାରି ଆତେନ୍‌‍ ବାକ୍ରା ଡୁଆ ତାରାସ୍‍ ବାଚେ ତାର୍‍କିଗ୍‍ ଡିଙ୍ଗ୍‍ୱେକେ । କିତଂ ଦୁତ୍ ପିତର୍‍ନେ ଜେବା ଡାଗ୍ରା ଜାର୍‍ଚେ ଆମେକେ ଡୁଲେଗ୍‍ଲେକ୍ନେ ବାନ୍‍ ରୁତୁଗ୍‍ଚେ ବାସଙ୍ଗ୍‍କେ “ଜିଆ ତଃଡ଼ିଆ !” ଜିଆ ଜିଆ ପିତର୍‍ନେ ନ୍ତିନ୍ନିଆ ଗାଗ୍‍ବକ୍ନେ ସିକ୍ଲିଇଂ ପୁଏଃଚଗ୍‌ ଲଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_8","074_12_8","ACT","12","8","8","ତେନ୍‍ ଇଡ଼ିଙ୍ଗ୍‍ କିତଂ ଦୁତ୍ ବାସଙ୍ଗ୍‍କେ “ନ୍‍ସା ଗାଗ୍‍ ଜୁତା ତାଙ୍ଗ୍‍ ।” ପିତର୍‍ ଆତେନ୍‌‍ ଡିଙ୍ଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ କିତଂ ଦୁତ୍‍ ବାସଙ୍ଗ୍‍କେ “ଗାଗ୍‍ଡ଼େନ୍ନିଆ ରାଗୁ କୁଇଚେ ନେଙ୍ଗ୍‍ନେ ପ୍ଲା ପାଙ୍ଗ୍‍ଲା ।” ");
INSERT INTO gaq_vpl VALUES ("AC12_9","074_12_9","ACT","12","9","9","କିତଂ ଦୁତ୍‍ ମେଁ ଡିଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଗେ ଆତେନ୍‌‍ ମୁଇଂ ସତ୍‍ ଗଟ୍‌ନା ଲେଃ ଣ୍ଡୁ ପିତର୍‍ ମ୍ୟାଃଆୟାକେ ଣ୍ଡୁ । ମେଁ ମୁସୁଡ଼ିଙ୍ଗ୍‍ କିକେ ଡିଙ୍ଗ୍‍କେ ଡାଗ୍‍ଚେ ବାବେକେ । ଏଲେଡିଗ୍‍ ପିତର୍‍ କଇଦ୍‍ ଡୁଆବାନ୍‍ ତାର୍‍ଚେ କିତଂ ଦୁତ୍‍ନେ ପ୍ଲା ୱେ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_10","074_12_10","ACT","12","10","10","ଉଡ଼ିବେଲା ମେଇଂ ପର୍‍ତୁମ୍‍ ବାରି ବାର୍‌ମୁଇଂ ଜାଗୁଆଲ୍‍ ଦଲ୍‍ଇଂକେ ବିଚେ ଆଣ୍ଡିନେ ଗାଲି ବିଚେ ନଗର୍‍ ୱେ ଡିଙ୍ଗ୍‍ଏ, ଆତେନ୍‌‍ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ଆର୍କେ ଆତେନ୍‌‍ବେଲା ଆତେନ୍‌‍ ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ମେଁ ମନ୍‍କେଆ ର୍ଣ୍ଣସାଙ୍ଗ୍‍ ରଃୱେଗେ ବାରି ମେଇଂ ତାର୍‍ୱେଚେ ମୁଇଂ ରାଜିନେ ମୁଣ୍ଡେସାଇ ଜାକ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍ ଉଲୁସ୍ତେ ଆତେନ୍‌‍ କିତଂ ଦୁତ୍‍ ମେଇଂନେ ବାନ୍‍ ମାୟା ଡିଙ୍ଗ୍‍ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_11","074_12_11","ACT","12","11","11","ଆତେନ୍‌‍ ବେଲା ପିତର୍‍ ଚେତା ବାଚେ ବାସଙ୍ଗ୍‍କେ, ମାପ୍‌ରୁ ଜେ ମେଁନେ ଦୁତ୍‍କେ ବେଚେ ହେରୋଦନେ ନ୍ତିବାନ୍‍ ବାରି ଜିଉଦି ରେମୁଆଁଇଂନେ ସାପା ଦଦ୍ୟା‍ ଚିନ୍ତାବାନ୍‍ ଆନେଙ୍ଗ୍‍କେ ରକ୍ୟା ଡିଙ୍ଗ୍‍ବକେ ଆକେନ୍‍ ସତେଆ ସତ୍‌ ଡାଗ୍‌ଚେ ନେଙ୍ଗ୍‍ ଏବେ ମ୍ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_12","074_12_12","ACT","12","12","12","ନିଜର୍‌ ପରିସ୍ଥିତି ବିସୟ୍‌ରେ ସଚେତନ୍‍ ଡିଙ୍ଗ୍‍ଚେ ମେଁ ଜହନ୍‌ ବାରି ମାର୍‌କନେ ଇୟାଙ୍ଗ୍‍ଡେ ମରିୟମ୍‍ନେ ଡୁଆ ୱେଆର୍କେ । ଆତ୍‍ଅରିଆ ଗୁଲେରୁଆ ମୁଇଂନୁଗ୍‍ ରିସିଙ୍ଗ୍‍ଚେ ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_13","074_12_13","ACT","12","13","13","ପିତର୍‍ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ନେ କାପାଟ୍‌କେ ଟକ୍‍ ଟକ୍ ବଗ୍‌କେ ରୋଦା ମ୍ନିକ୍ନେ ମୁଇଂ ଚାକର୍‌ବୁଏଃ କାପାଟ୍‍ ରଃନ୍‍ସା ପାଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_14","074_12_14","ACT","12","14","14","ମେଁ ପିତର୍‍ନେ ବ୍ନାଇର୍‍ ମ୍ୟାଃଚେ ଏନ୍ତି ସାର୍‍ଦାରେ ଡିଙ୍ଗ୍‍କେ ଜେ ମେଁ କାପାଟ୍‍ ମାରଃଚେ ବିତ୍‍ରେ ୱିର୍‍ ଡୁଂୱେଚେ ର୍ଣ୍ଣସାଙ୍ଗ୍‌ ଡାଗ୍ରା ପିତର୍‍ ତୁଆଁଲେକେ ଡାଗ୍‍ଚେ ବାସଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_15","074_12_15","ACT","12","15","15","ମେଇଂ ଆମେକେ ବାସଙ୍ଗ୍‍କେ, “ନା ବାଉଡ଼ି ଡିଙ୍ଗ୍‍ନାଲେକେ ।” ମାତର୍‍ “ଆକେନ୍‍ ସତ୍‍” ଡାଗ୍‍ଚେ ମେଁ ଡାଟାମ୍‍ରେ ବାସଙ୍ଗ୍‍ ନ୍‌ସା ଲାଗେକେ । ମେଇଂ ବାସଙ୍ଗ୍‍କେ “ମେଁ ସତ୍‍ରେ ପିତର୍‍ନେ ଦୁତ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("AC12_16","074_12_16","ACT","12","16","16","ପିତର୍‍ ପ୍ରେକ୍‍ପ୍ରେକ୍‍ କାପାଟ୍‍ନ୍ନିଆ ଟକ୍‍ ଟକ୍ ବଗ୍‍ଡିଙ୍ଗେ । ସାରାସାରି ମେଇଂ କାପାଟ୍‍ ରଃଚେ ଆମେକେ କେଚେ ବକୁଆ ଡିଙ୍ଗ୍‍ୱେଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_17","074_12_17","ACT","12","17","17","ମେଁ ନ୍ତିନ୍ନିଆ ଚିନା ବିଚେ ବୁଙ୍ଗ୍‍ ଲେନ୍‍ସା ବାସଙ୍ଗ୍‍କେ ବାରି ମାପ୍‌ରୁ ଆମେକେ ଡିରକମ୍‍ କଇଦ୍‍ ଡୁଆବାନ୍‍ ଆତାର୍‍ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍କେ ଆତେନ୍‌‍ ବିସୟ୍ ମେଇଂନେ ଡାଗ୍ରା ବାସଙ୍ଗ୍‍ବିକେ । ତେନ୍‌ ଇଡ଼ିଂ ଆକେନ୍‍ ସାପା ସାମୁଆଁ ଜାକୁବ୍‌ ବାରି ବିନ୍‍ ସାପା ବୟାଁଇଂକେ ଆଃମ୍ୟାଃନ୍‍ସା ଆଦେସ୍‍ ବିଚେ ମେଁ ଆତ୍‍ବା ବିନ୍‍ପାକା ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_18","074_12_18","ACT","12","18","18","ତୁଗୁଆ ମାର୍‍ତଡ଼େ ଞ୍ଜିର୍‍ ଡିଙ୍ଗ୍‍ଲା ପିତର୍‍ ଆଣ୍ଡି ୱେଗେ ଡାଗ୍‍ଚେ ଜାଗୁଆଲ୍‍ଇଂନେ ବିତ୍‍ରେ କିରମର ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_19","074_12_19","ACT","12","19","19","ହେରୋଦ ଆମେକେ ତୁର୍‍ନ୍‍ସା ଆଦେସ୍‍ ବିକେ । ମାତର୍‍ ମେଇଂ ଆମେକେ ଆଅବାକେ ଣ୍ଡୁ । ସାରାସାରି ଜାଗୁଆଲ୍‍ଇଂକେ ପ୍ରସ୍‌ନ ଡିଙ୍ଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ଆମେଇଂକେ ଗୁଏନେ ଡଣ୍ଡ୍‌ ବିନ୍‍ସା ଆଦେସ୍‍ ବିକେ । ଆକେନ୍‍ ଇଡ଼ିଙ୍ଗ୍‍ ହେରୋଦ ଜିଉଦା ପ୍ରଦେସ୍‌ବାନ୍‍ ୱେଚେ କାଇସରିୟା ଲେଃଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_20","074_12_20","ACT","12","20","20","ଆତେନ୍‌‍ ବେଲା ହେରୋଦ ସୋର ବାରି ସିଦନନେ ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଜାବର୍‌ ରିସା ଡିଙ୍ଗ୍‍ଲେଗେ । ମେଇଂ ଦଲ୍‍ ଦଲ୍‍ ଡିଙ୍ଗ୍‍ଚେ ଆମେକେ କେନ୍‍ସା ପାଙ୍ଗ୍ଆର୍କେ । ମେଇଂ ଇଃସାଙ୍ଗ୍‌ ଡୁଲେଗ୍‌ନେ ଡୁଆନେ ମୁଇଂ ଚାକ୍‌ରିଆ ବ୍ଲାଷ୍ଟସ୍‍ନେ ସାଇଜ୍ୟ ବାଆର୍‌କେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ ହେରୋଦ ଏତେ ସାନ୍ତିରେ ଲେନ୍‍ସା ବିକ୍‌ ସାଲ୍ୟାଃଆର୍କେ ଡାଗ୍ଲା ହେରଦନେ ରାଜ୍ୟବାନ୍ ମେଇଂନେ ଦେସ୍‍ନ୍ନିଆ ଚୁଚଙ୍ଗ୍‍ନେ ଜିନିସ୍‍ଇଂ ଡୁଂପାଙ୍ଗ୍‍ ଆର୍ ଡିଙ୍ଗ୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_21","074_12_21","ACT","12","21","21","ହେରୋଦ ମୁଇଂ କାମ୍ ଣ୍ଡୁନେ ଦିନା ଆମେଇଂକେ କେନ୍‍ସା ମନ୍‍ ପାଞ୍ଜେକେ । ଆତେନ୍‌‍ ଦିନା ମେଁ ଇଃସାଙ୍ଗ୍‌ ରକମ୍‍ନେ ସକା ସଃଚେ ବିଚାର୍‌ ଡୁଆନ୍ନିଆ କଚେ ରେମୁଆଁଇଂକେ ବାଲିର୍‌ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_22","074_12_22","ACT","12","22","22","ରେମୁଆଁଇଂ କିରଚେ ବାସଙ୍ଗ୍‍କେ, “ଆକେନ୍‍ ଇସ୍‌ପର୍‌ନେ ବ୍ନାଲିର୍‍ ରେମୁଆଁନେ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC12_23","074_12_23","ACT","12","23","23","ହେରୋଦ ନିଜେନେ ଆକେନ୍‍ ପ୍ରସଂସା ଅଁକେ ମାତର୍‍ ମେଁ ପର୍‍ମେସର୍‍କେ ମେଁନେ ସନ୍‍ମାନ୍‍ ଆରାଃମ୍ୟାକେ ଣ୍ଡୁ । ତେସା ମାପ୍‌ରୁନେ ମୁଇଂ ଦୁତ୍ ମାରିଆଃତୁଗ୍‍ ଆମେକେ ବଗ୍‌କେ ବାରି ମେଁନେ ଗାଗ୍‍ଡ଼େକେ ବିଂବିଂଇଂ ଚଙ୍ଗ୍‍ଆର୍କେ । ସାରାସାରି କେଲା ମେଁ ଗୁଏୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_24","074_12_24","ACT","12","24","24","ଆକେନ୍‍ ବେଲା ବିତ୍‍ରେ ଇସ୍‍ପର୍‍ନେ ସାମୁଆଁ ମ୍ନାଃଚେ ପିତୁର୍‍ ପାକା ବେପ୍ରେ ୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC12_25","074_12_25","ACT","12","25","25","ବର୍ଣ୍ଣବା ବାରି ଶାଉଲ ମେଇଂନେ ସେବା କାମ୍ ଆଡାଚେ ମାର୍‌କ ମ୍ନିରେ ସ୍ନାମୁଁଆଃ ଜହନ୍‌କେ ସାଚେ ଯିରୂଶାଲାମ୍‌ବାନ୍‌ ଆଣ୍ଡେ ୱିଗ୍‌ଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_1","074_13_1","ACT","13","1","1","ଆଣ୍ଟିୟକ ମଣ୍ଡଲିନ୍ନିଆ ଉଡ଼ିରୁଆ ବାବବାଦି ବାରି ସିକ୍ୟାଗୁରୁ ଲେଃଆର୍ଗେ । ଆକ୍ମେଇଂନେ ବାନ୍‍ ଲେଃଆର୍‌ଗେ, ବର୍ଣ୍ଣବା, ଶିମୋନ ଜାଣ୍ତେକେ ନିଗର ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ଆର୍‌ଏ, କୁରୁଣୀ ଇନିନେ ରେମୁଆଁ ଲୁସିଅସ୍‍, ମନହେମ, ମେଁ ରାଜ୍ୟପାଲ୍ ହେରୋଦନେ ପରିବାର୍‍ନ୍ନିଆ ମ୍ନାଲେଗେ । ବାରି ଶାଉଲ । ");
INSERT INTO gaq_vpl VALUES ("AC13_2","074_13_2","ACT","13","2","2","ମେଇଂ ମାପ୍‌ରୁନେ ସେବା ବାରି ଉପାସ୍‌ ଡିଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍ନେ ବେଲା ପବିତ୍ର ଆତ୍ମା ଆମେଇଂକେ ବାଲିର୍‍କେ “ନେଙ୍ଗ୍‍ ଆଣ୍ଡିନେ ସ୍ଲେନ୍‍ସା ବର୍ଣ୍ଣବା ବାରି ଶାଉଲ୍‌କେ ୱାମ୍ୱକେ, ଆତେନ୍‌‍ସା ଆମେଇଂକେ ନେଙ୍ଗ୍‍ସା ଅଲ୍‍ଗା ଆଡିଙ୍ଗ୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("AC13_3","074_13_3","ACT","13","3","3","ବାବବାଦିଇଂ ଉପାସ୍‌ ବାରି ପାର୍‌ତନା ଡିଙ୍ଗ୍‍ଚେ ଆତେନ୍‌‍ ମ୍ୱାୟାନେ ଆଡ଼ାତ୍ରା ନ୍ତି ବଚେ ଆମେଇଂକେ ବାସଙ୍ଗ୍‌ କାମ୍‍ରେ ବେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_4","074_13_4","ACT","13","4","4","ବର୍ଣ୍ଣବା ବାରି ସାଉଲ୍‍ ପବିତ୍ର ଆତ୍ମା ବାଚେ ସେଲୁକିଆ ଇନିନ୍ନିଆ ୱେଆର୍କେ । ଆତ୍‍ବା ମେଇଂ ଜାଆଜ୍‍ନ୍ନିଆ ଡେଃଚେ ସାଇପ୍ରସ୍ ଉପଦ୍ୱିପ୍‍ ପାକା ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_5","074_13_5","ACT","13","5","5","ଚାକ୍‍ରିଆରେଇଂ ସାଲାମି ସଅର୍‍ନ୍ନିଆ ୱେଚାଚେ ଜିଉଦି ପାର୍‌ତନା ଡୁଆଇଂନ୍ନିଆ ଇସ୍‍ପର୍‍ନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ଜହନ୍‌ ବାରି ମାର୍‌କ ମେଇଂ ଏତେ ଲେଃଚେ ସେବାକାମ୍‍ରେ ସଙ୍ଗ୍‍ତୁଡ଼୍‍ ଡିଙ୍ଗ୍‍ଆର୍‌ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_6","074_13_6","ACT","13","6","6","ମେଇଂ ସାଇପ୍ରସ୍‍ ଦ୍ୱିପ୍‍ ସାପାପାକା ଅଲେଙ୍ଗ୍‍ ଅଲେଙ୍ଗ୍‍ଚେ ପାଫନ୍ନିଆ ୱେଚାଚେ ମୁଇଂ ଗୁନିଆକେ କେକେ ମେଁ ମୁଇଂ ଜିଉଦି ରେମୁଆଁ ବାରି ମେଁନେ ମ୍ନି ବର୍‍ ଜିସୁ । ");
INSERT INTO gaq_vpl VALUES ("AC13_7","074_13_7","ACT","13","7","7","ମେଁ ଆତେନ୍‌‍ ସାସନ୍‍ କର୍‍ତା ସର୍ଗିୟସ ପାଉଲ୍‌ନେ ମୁଇଂ ବନ୍ଦୁ ଲେଃଗେ । ସର୍ଗିୟସ ମୁଇଂ ବୁଦିମାନ୍‍ ରେମୁଆଁ ଲେଃଗେ । ମେଁ ଇସ୍‍ପର୍‍ନେ ସାମୁଆଁ ଦ୍ରିଗ୍‍ନ୍‍ସା ରାଜି ଡିଙ୍ଗ୍‍ଚେ ବର୍ଣ୍ଣବା ବାରି ଶାଉଲକେ ୱାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_8","074_13_8","ACT","13","8","8","ମାତର୍‍ ଆତେନ୍‌‍ ମାୟାବି ଗ୍ରିକ୍‍ ବ୍ନାସାରେ ଆକ୍ମେନେ ମ୍ନି ଅଲିମା ବର୍ଣ୍ଣବାକେ ବାରି ଶାଉଲ୍‍କେ ଜାବର୍‌ କସ୍ଟ ବିକେ । ଡାଗ୍ଲା ଆତେନ୍‌‍ ସାସନ୍‍ କର୍ତାକେ କିସ୍ଟକେ ବିସ୍‌ବାସ୍‌ ଡିଙ୍ଗ୍‍ନେବାନ୍‍ ଅଲ୍‍ଗା ଆଡିଙ୍ଗ୍‍ନ୍‍ସା ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_9","074_13_9","ACT","13","9","9","ମାତର୍‍ ଶାଉଲ ଜାନେ ଅଲ୍‍ଗା ମ୍ନି ପାଉଲ୍‍, ପବିତ୍ର ଆତ୍ମା ବାଚେ ମାୟାବି ଅଲିମା ପାକା ମ୍ନା ମ୍ନା ଆଃମୁଆଁଚେ ବାସଙ୍ଗ୍‍କେ ");
INSERT INTO gaq_vpl VALUES ("AC13_10","074_13_10","ACT","13","10","10","“ଏ ସୟତାନ୍‌ନେ ଉଂଡେ ! ନା ସାପା ନିମାଣ୍ଡା ବିସୟ୍‍ରେ ସତ୍ରୁ ଡିଙ୍ଗ୍‍ଚେ ତଃଡ଼ିଆ ନାଡିଙ୍ଗ୍‍କେ ! ନା ସାପା ରକମ୍‍ନେ କାମ୍‍ନ୍ନିଆ ଡାଟ୍‌ ନାଲେଃକେ ବାରି କାଲାଆଃ ମାପ୍‌ରୁନେ ସତ୍‌ ଗାଲିକେ ସିଦା ଆଃଡିଙ୍ଗ୍‌ନେସା ନା କି ଚେସ୍‌ଟା ଡିଙ୍ଗ୍‌ନାଡିଙ୍ଗ୍‌ । ");
INSERT INTO gaq_vpl VALUES ("AC13_11","074_13_11","ACT","13","11","11","ଏବେ ନା ମାପ୍‌ରୁନେ ନ୍ତିବାନ୍‍ ଡଣ୍ଡ୍‍ ନାବାଏ । ନା କାନା ଡିଙ୍ଗ୍‍ଚେ ଉଡ଼ି ଗଣ୍ଟା ଜାକ ସ୍ମିକେଲା ତାର୍‍କିଗ୍‍ କେନାୟା ଣ୍ଡୁ ।” ଆତେନ୍‌‍ ଦାପ୍ରେ ଅଲିମାନେ ମ୍ମୁଆଃ ଜାବର୍‍ ତାଉଲଃନ୍ନିଆ ଗାଲେଃକେ ରକମ୍‍ ମେଁ ବାବେକେ ବାରି ମେଁନେ ନ୍ତି ସାଚେ ଆଃଅଲେଙ୍ଗ୍‍ ଡୁଂୱେନ୍‍ସା ମୁଇଂଜାକେ ତୁର୍‍ନ୍‍ସା ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_12","074_13_12","ACT","13","12","12","ଆକେନ୍‍ କେଚେ ସାସନ୍‍ କର୍ତାନେ ବିସ୍‍ବାସ୍‍ ଲାଗେକେ ଡାଗ୍ଲା ମେଁ ମାପ୍‌ରୁନେ ସିକ୍ୟା ଅଁଚେ ଇରିଆତୁଗ୍‍ ଡିଙ୍ଗ୍‍ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_13","074_13_13","ACT","13","13","13","ପାଉଲ୍‍ ବାରି ମେଁନେ ସାଙ୍ଗ୍‍ଡ଼େଇଂ ପାଫୋ ନଗର୍‍କେ ଆନ୍ତାର୍‍ଚେ ମ୍ନା କେଣ୍ଡିଆ ଗାଲିଆଡ଼ା ପଂପୁଲିୟାନେ ପର୍ଗାନ୍ନିଆ ପାଙ୍ଗ୍‍ଆର୍କେ । ମାତର୍‍ ଜହନ୍‌ ମାର୍‌କ ଆମେଇଂକେ ଆନ୍ତାର୍‍ଚେ ଯିରୁସାଲାମ୍‌ ପାଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_14","074_13_14","ACT","13","14","14","ମେଇଂ ପର୍ଗାବନ୍ ୱେଚେ ପିସିଦିଆନେ ଆଣ୍ଟିୟକନ୍ନିଆ ୱେଚାଆର୍କେ ବାରି ସାନ୍ତା କାଲା ପାର୍‌ତନା ଡୁଆଇଂନ୍ନିଆ ୱେଚେ କଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_15","074_13_15","ACT","13","15","15","ମସାନେ ନିୟମ୍‌ନ୍ନିଆ ବାରି ବାବବାଦିଇଂ ଗୁଆର୍‍କ୍ନେ ପଡ଼େକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ପାର୍‌ତନା ଡୁଆନେ ମ୍ନାନେତା ମେଇଂ ଡାଗ୍ରା ଆକେନ୍‍ ସାମୁଆଁ ବାଲିର୍‍ଚେ ବେଆର୍କେ “ବୟାଁଇଂ ଜଦି ରେମୁଆଁଇଂକେ ସାର୍‍ଦା ଆଡିଙ୍ଗ୍‍ନେ ରକମ୍‍ ପେନେ ଜଦି ମେଁନେ ଆମ୍ଲେଡ଼ିଆନେ ଆଦେସ୍‍ ବିନେ ଲେଃକେ, ତେଲା ବାସଙ୍ଗ୍‍ପା ।” ");
INSERT INTO gaq_vpl VALUES ("AC13_16","074_13_16","ACT","13","16","16","ପାଉଲ୍‍ ତଃଡ଼ିଆଚେ ରେମୁଆଁଇଂକେ ବୁଙ୍ଗ୍‍ ଲେନ୍‍ସା ନ୍ତି ଆରାତ୍ରା ଆଃତଡ଼ିଆଚେ ବାସଙ୍ଗ୍‍କେ: ଏ ଇଶ୍ରାଏଲ୍‌ନେ ରେମୁଆଁଇଂ ବାରି ଇସ୍‍ପର୍‍କେ ବୁଟଆର୍‍ ମ୍ୟାଃକ୍ନେ ରେମୁଆଁଇଂ ଦ୍ରିଗ୍‍ପା । ");
INSERT INTO gaq_vpl VALUES ("AC13_17","074_13_17","ACT","13","17","17","ଇଶ୍ରାୟେଲୀୟ ଜାତିନେ ଇସ୍‍ପର୍‍ ନେନେ ଅଃସେରେଇଂକେ ବାଚେ ବକେ ବାରି ମିସର୍‍ ଦେସ୍‌ନ୍ନିଆ ମେଇଂ ବାସାଡିଙ୍ଗ୍‌ କେଲା ମୁଇଂ ମ୍ନା ଜାତି ଆଡିଙ୍ଗ୍‍କେ । ଇସ୍‍ପର୍‍ ମେଁନେ ମ୍ନା ବପୁରେ ଆମେଇଂକେ ମିସର୍‍ବାନ୍‍ ଆତାର୍‍ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍କେ ");
INSERT INTO gaq_vpl VALUES ("AC13_18","074_13_18","ACT","13","18","18","ବାରି ଚାଲିସ୍‍ ମୁଆଁ ଜାକ ବାଲିଲଃନ୍ନିଆ ମେଇଂନେ ବେବଆର୍‌କେ ସାମ୍ବାଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_19","074_13_19","ACT","13","19","19","ପର୍‍ମେସର୍‍ କିଣାନନ୍ନିଆ ଗୁ କ୍ଲିଗ୍‍ ବଂସକେ ନସ୍ଟ ଆଡିଙ୍ଗ୍‍ଚେ ମେଁ ସ୍ରିକ୍ନେ ରେମୁଆଁଇଂକେ ଆତେନ୍‌ ଦେସ୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_20","074_13_20","ACT","13","20","20","ପାକାପାକି ଅଁଶହ ପଚାସ୍ ମୁଆଁ ବିତ୍‍ରେ ଆକେନ୍‍ ସାପା ଗଟ୍‍ନା ଗଟେୱେକେ । “ଏନ୍‍ ଇଡ଼ିଙ୍ଗ୍‍ ଶାମୁୟେଲ୍‌ ବାବବାଦି‍ଇଂନେ ବେଲା ଜାକ ଇସ୍‍ପର୍‍ ମେଇଂନେ ଆଡ଼ତ୍ରା ବିଚାର୍‌ କର୍ତାଇଂକେ ବାଚେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_21","074_13_21","ACT","13","21","21","ଉଡ଼ିବେଲା ମେଇଂ ମୁଇଂ ଇଃସାଙ୍ଗ୍‌କେ ଚାଏଁଆର୍‌କେ । ପର୍‍ମେସର୍‍ ଆମେଇଂକେ ଚାଲିସ୍‍ ମୁଆଁ ଜାକ ସାସନ୍‍ ଡିଙ୍ଗ୍‍ନ୍‍ସା ବେଞ୍ଜାମିନ ବଂସନେ କୀଶ୍‌ନେ ଉଂଡେ ଶାଉଲକେ ଇଃସାଙ୍ଗ୍‌ ଆଡିଙ୍ଗ୍‍ଚେ ବିକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC13_22","074_13_22","ACT","13","22","22","ତେନ୍‌ ଇଡ଼ିଂ ଇସ୍‍ପର୍‍ ଆମେକେ ଇଃସାଙ୍ଗ୍‌ ଗାଦିବାନ୍‍ ଆଜର୍‍ଚେ ଦାଉଦ୍‍କେ ମେଇଂନେ ଇଃସାଙ୍ଗ୍‌ ଆଡିଙ୍ଗ୍‍କେ । ଇସ୍‍ପର୍‍ ମେଁ ବିସୟ୍‍ରେ ସାକି ବିଃବଗେ “ନେଙ୍ଗ୍‍ ଡିରକମ୍‍ନେ ରେମୁଆଁଇଂକେ ବଲ୍‍ ବା ଣ୍ଡିଙ୍ଗ୍‍କେ ଜେଶୀନେ ଉଂଡେ ଦାଉଦକେ ବାନେଲେକେ, ମେଁ ନେନେ ମନ୍‌ ବିତ୍‌ରେନେ ବୁଜେନେ ରେମୁଆଁ; ମେଁ ସାପା ବିସୟ୍‌ରେ ନେନେ ଇକ୍‌ଚାରେ ସାପା କାମ୍ ଡିଙ୍ଗ୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC13_23","074_13_23","ACT","13","23","23","ଆକେନ୍‍ ଦାଉଦ୍‍ନେ ବଂସଦର୍‍ ଜିସୁକେ ଇସ୍‍ପର୍‍ ମେଁନେ ଆଦେସ୍‌ ଇସାବ୍‌ରେ ଇଶ୍ରାୟେଲୀୟ ଜାତିନେ ଆମ୍ବ୍ରଣ୍ଡ୍ରେ ଆଃଡିଙ୍ଗ୍‍ବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_24","074_13_24","ACT","13","24","24","ଜିସୁ ମେଁନେ କାମ୍ ଆରାମ୍‍ ଡିଙ୍ଗ୍‍କ୍ନେ ସେନୁଗ୍‍ ଜହନ୍‌ ଇଶ୍ରାୟେଲୀୟନେ ସାପା ରେମୁଆଁଇଂନେ ଡାଗ୍ରା ବାସଙ୍ଗ୍‌‍ ଡାଗ୍‍ଚେ ବାସଙ୍ଗ୍‍କେ, ଆମେଇଂକେ ପାପ୍‍ବାନ୍‍ ମନ୍‌ ବଦ୍‌ଲେଚେ ଣ୍ଡିଆଦିକ୍ୟା ଡୁଂଡ ପଡ଼େଏ । ");
INSERT INTO gaq_vpl VALUES ("AC13_25","074_13_25","ACT","13","25","25","ବାରି ଜହନ୍‌ ମେଁନେ ସେବା କାମ୍ ଆଃଡାନେ ସେନୁଗ୍‍ ରେମୁଆଁଇଂକେ ସାଲ୍ୟାକୁକେ ‘ନେଙ୍ଗ୍‍ ବିସୟ୍‍ରେ ପେନେ ବାବ୍‌ନା ମେଃନେ ? ପେ ଆଜାକେ ଉର୍‍ ପେଲେକେ ନେଙ୍ଗ୍‍ ମେଁ ଣ୍ଡୁ । ମାତର୍‍ ଦ୍ରିଗ୍‍ପା ! ନେଙ୍ଗ୍‍ ଇଡ଼ିଙ୍ଗ୍‍ ଜା ପାଙ୍ଗ୍‍ଡିଙ୍ଗ୍‍କେ ନେଙ୍ଗ୍‍ ମେଁନେ ଞ୍ଚବାନ୍‍ ଜୁତା ତୁତଃନ୍‍ସା ଡିଗ୍‍ ସକତ୍‌ ଣ୍ଡୁ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC13_26","074_13_26","ACT","13","26","26","ଅ ବୟାଁଇଂ ଅବ୍ରାହାମ୍ ବଂସନେ ଗୋଗିସିଆଃଇଂ ବାରି ପେ ବିତ୍‍ରେବାନ୍‍ ପର୍‍ମେସର୍‍କେ ବୁଟଚେ ଲେଃମ୍ୟାକ୍ନେ ରେମୁଆଁଇଂ ନେ ଡାଗ୍ରା ଏନ୍‌‍ ଉଦାର୍‍ ଡିଙ୍ଗ୍‍ନେ ସାମୁଆଁ ବେବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_27","074_13_27","ACT","13","27","27","ମାତର୍‍ ମେଁ ଜେ ଉଦାର୍‍ କର୍ତା ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ବାସା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଂକ୍ନେ ବାରି ମେଇଂନେ ନେତାଇଂ ଆତେନ୍‌‍ ମ୍ୟାଃ ଆଲେଃଆର୍‍ଗେ ଣ୍ଡୁ, ମେଇଂ କାଲାଆଃ ସାନ୍ତା କାଲା ବ୍ନାଲିର୍‍ ଆଦ୍ରିଗ୍‍ମ୍ୟାଃକ୍ନେ ବାବବାଦି‍ଇଂନେ ସାମୁଆଁନେ ଅର୍‍ତ ଦ୍ରିଗ୍‍ ଆଡିଂଆର୍‍ଗେ । ତେଲାଡିଗ୍‍ ଜିସୁକେ ଦସ୍‌ ବିଚେ ମେଇଂ ବାବବାଦି‍ଇଂନେ ସାମୁଆଁକେ ପୁରା ଆଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_28","074_13_28","ACT","13","28","28","ମେଇଂ ମେଁନେ ଗୁଏନେ ଡଣ୍ଡ୍‍ ବିନେ ମେଃଡିଗ୍‍ ଦସ୍‍ ମାବାଚେ ଆମେକେ ବାଗୁଏଃ ବିଃନ୍‍ସା ପିଲାତକେ ବାସଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_29","074_13_29","ACT","13","29","29","ମେଁ ବିସୟ୍‍ରେ ସାପା ଗୁଆର୍‍ ବକ୍ନେ ଗଟ୍‌ନାଇଂ ଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ମେଇଂ ଆମେକେ କୁରୁସ୍‍ବାନ୍‍ ବୁନ୍ଦେ ଆଜୁଆର୍‍ଚେ ଗୁଡ଼ୁମ୍‍ ଆରେଚେ ଆତିବିଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_30","074_13_30","ACT","13","30","30","ମାତର୍‍ ପର୍‍ମେସର୍‍ ଆମେକେ ଗୁଏକ୍ନେ ବାନ୍‍ ବାରି ମୁଇଂତର୍‍ ଆତଡ଼ିଆକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_31","074_13_31","ACT","13","31","31","ଗୁଲେସି ଜାକ ମେଁ ଏତେ ଗାଲିଲୀବାନ୍ ଯିରୁସାଲାମ୍‌ ୱେ ୱିଗ୍‍ ଡିଙ୍ଗ୍‍ଲେମ୍ୟାଃକ୍ନେ ରେମୁଆଁଇଂକେ ମେଁ ଆଃସୁଏଃକେ । ଏବେ ମେଇଂ ଇସ୍ରାଏଲ୍‍ ରେମୁଆଁଇଂନେ ଡାଗ୍ରା ମେଁନେ ସାକି ଲେଃଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_32","074_13_32","ACT","13","32","32","ନେନେ ନ୍ତା ଞ୍ଜାଇଂନେ ଡାଗ୍ରା ପାର୍‌ମାନ୍‌ ଡିଂକ୍ନେ ବିସୟ୍‌ରେ ନେ ଆପେକେ ଏନ୍ ନିମାଣ୍ଡାସାମୁଆଁ ଆଦ୍ରିଗ୍‍ ନେଡିଙ୍ଗ୍‍କେ ଜେ ");
INSERT INTO gaq_vpl VALUES ("AC13_33","074_13_33","ACT","13","33","33","ଇସ୍‌ପର୍‌ ଜିସୁକେ ଗୁଏକ୍ନେ ବାନ୍‌ ଆତଡ଼ିଆଚେ ମେଇଂନେ ଉଂଡେ ନେ ସାପାରେ ନେଇଂନେ ଆଡ଼ାତ୍ରା ଆତାନ୍‌ ପାର୍‌ମାନ୍‌ ସମାନ୍‌ ଆଡିଙ୍ଗ୍‌ ବକେ । ଦେକ୍‍ରକମ୍‍ ଦିତିୟ ଗୀତସଂହିତାନ୍ନିଆ ଗୁଆର୍‍ବକେ: ପେ ନେନେ ଉଂଡେ ଏକେ ନେ ଆପେକେ ଜନମ୍‌ ନେବକେ । ‘ନା ନେଙ୍ଗ୍‍ନେ ଉଂ ଏକେ ନେଙ୍ଗ୍‍ ନାନେ ଆବା ଣ୍ଡିଙ୍ଗ୍‍ଗେ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC13_34","074_13_34","ACT","13","34","34","ପର୍‍ମେସର୍‍ ଜିସୁକେ ଗୁଏକ୍ନେ ବାନ୍‍ ଆଃତଡ଼୍ୟାବକେ, ଜେନ୍ତିକି ମେଁନେ ଗାଗ୍‍ଡ଼େ ବାର୍‌ମୁଇଂତର୍‍ ମାଆତିଚେ ଚିନା ଆଡିଙ୍ଗ୍‍ । ଆକେନ୍‍ ବିସୟ୍‍ରେ ମେଁ ବାସଙ୍ଗ୍‍କେ ‘ନେଙ୍ଗ୍‍ ଦାଉଦ ଡାଗ୍ରା ପାର୍‌ମାନ୍ ଡିଂକ୍ନେ ଡିଙ୍ଗ୍‍ମ୍ବକ୍ନେ ପବିତ୍ର ବାରି ଅଃନାଡିଗ୍ ମାଗୁଞ୍ଚେନେ ଆସିର୍‍ବାଦ୍‍ ଆପେକେ ମ୍ବିଏ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC13_35","074_13_35","ACT","13","35","35","ସାସ୍ତର୍‌ନେ ବାର୍‌ମୁଇଂ ଜାଗାନ୍ନିଆ ଗୁଆର୍‍ବକେ, ‘ନା ନାନେ ବିସ୍‍ବାସ୍‌ ସେବକକେ ରାଃଚ୍ୟାନ୍ନିଆ ଚିନାବାନା ଡିଙ୍ଗ୍‍ନ୍‍ସା ଆନ୍ତାର୍‍ ନାବି ଣ୍ଡୁ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC13_36","074_13_36","ACT","13","36","36","ଦାଉଦ ମେଁନେ ସାସନ୍‍ କେଲା ଇସ୍‍ପର୍‍ନେ ଉଦେସ୍‍କେ ପୁରନ୍ ଡିଂଚେ ଇଡ଼ିଙ୍ଗ୍‍ ମେଁ ଗୁଏକେ ବାରି ନ୍ତା ଞ୍ଜାଇଂ ଏତେ ରାଃଚ୍ୟାମ୍ବନ୍ନିଆ ଆତି ଆର୍କେ । ମାତର୍‍ ମେଇଂନେ ଗାଗ୍‍ଡ଼େ ରାଚିଆମ୍ୱନ୍ନିଆ ଚିନାବାନା ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_37","074_13_37","ACT","13","37","37","ମାତର୍‍ ଇସ୍‍ପର୍‍ ଆଜାକେ ଗୁଏକ୍ନେ ବାନ୍ ଆତଡ଼ିଆକେ ମେଁ ମେଃଡିଗ୍‍ ରକମ୍‍ ଚିନା ବାନା ଆଡିଙ୍ଗ୍‍କେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC13_38","074_13_38","ACT","13","38","38","ଏ ବୟାଁଇଂ ପେ ସାପାରେ ସତ୍ ବାବ୍‌ରେ ମ୍ୟାନେ ଦର୍‌କାର୍ ଜେ ମୁଇଂ ମାପ୍‌ରୁ ଜିସୁନେବାନ୍ ନା ଡାଗ୍ରା ପାପ୍‍ କେମାନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‌ବ‍ଆର୍‌କେ । ମୋଶାନେ ନିୟମ୍‌ବାନ୍ ଉଦାର୍ ବା ଆୟାକ୍ନେ ସାପାରେ ଆତେନ୍‌ ଜିସୁନେ ଡାଗ୍ରା ବିସ୍‌ବାସ୍‌ ଡିଂନେ ବାନ୍ ଆଃ ଉଦାର୍ ବାଆର୍‌ଏ; ଆକେନ୍ ପେ ବୁଜେନେ ଦର୍‌କାର୍ । ");
INSERT INTO gaq_vpl VALUES ("AC13_39","074_13_39","ACT","13","39","39","ବାରି ମୋଶାନେ ନିୟମ୍‌ ବାନ୍‍ ଜା ସାପା ବିସୟ୍‍ରେ ପେ ମୁକ୍ତି ବାଚେ ଦାର୍‍ମିକ୍‍ ଗନିତ ଡିଙ୍ଗ୍‍ ପେୟାକେ ଣ୍ଡୁ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ମ୍ୟାଃକ୍ନେ ରେମୁଆଁ ସାପାରେ ମେବାନ୍‍ ଆତେନ୍‌‍ ସାପା ବିସୟ୍‍ରେ ମୁକ୍ତି ବାଚେ ଦାର୍‍ମିକ୍‍ ଗନିତ୍‍ ଡିଙ୍ଗ୍‍ଆର୍‍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_40","074_13_40","ACT","13","40","40","ସାବ୍‍ଦାନ୍‍ ବାବବାଦିଇଂ ମେଁ ବାସଙ୍ଗ୍‍ବଗେ ଆତେନ୍‌‍ ଜେନ୍ତିକି ପେ ବିତ୍‍ରେ ମାଗଟେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_41","074_13_41","ACT","13","41","41","‘ଏ ଅମାନି ରେମୁଆଁଇଂ ପେ ବକୁଆ ଡିଗ୍‍ ପେଡିଙ୍ଗ୍‍ଏ ବାରି ଇଡ଼ିଙ୍ଗ୍‍ ଗୁଏନ୍‍ସା ପେୱେଏ; ମାତର୍‍ ନେଙ୍ଗ୍‍ ପେ କେଲା ଦେକ୍‍ରକମ୍‍ ମୁଇଂ କାମ୍ ଣ୍ଡିଙ୍ଗ୍‍ଏ’ ଜାଡିଗ୍‍ ଆପେକେ ଆଦ୍ରିଗ୍‍ଚେ ବାସଙ୍ଗ୍‍ଲା ଡିଗ୍‍ ପେ ବିସ୍‍ବାସ୍‍ ପେଡିଙ୍ଗ୍‍ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC13_42","074_13_42","ACT","13","42","42","ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବା ପାର୍‍ତନା ଡୁଆ ଆନ୍ତାର୍‍ଚେ ୱେନେ ବେଲା ପାଙ୍ଗ୍‍ନେ ସାନ୍ତା କାଲା ଆଣ୍ଡେ ପାଙ୍ଗ୍‍ଚେ ଆକେନ୍‍ ସାପା ସାମୁଆଁ ବାରି ଅଦିକ୍‍ ଆଦ୍ରିଗ୍‍ ନ୍‍ସା ଆମେଇଂକେ ରେମୁଆଁଇଂ ଗୁଆରି ଡିଙ୍ଗ୍‌ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_43","074_13_43","ACT","13","43","43","ରେମୁଆଁଇଂ ପାର୍‌ତନା ଡୁଆନ୍ନିଆ କୁକପାର୍‍ ଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଜିଉଦି ରେମୁଆଁ ବାରି ଜିଉଦି ଦର୍ମ ଗ୍ରଅନ୍‍ ଡିଙ୍ଗ୍‍ଲେଆର୍‍କ୍ନେ ବିନ୍‍ ଜାତି ରେମୁଆଁଇଂ ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବାନେ ପ୍ଲା ୱେଆର୍କେ ସିସ୍‍ଇଂ ମେଇଂ ଏତେ ବାଲିର୍‍ବାତାଚେ ଇସ୍‍ପର୍‍ନେ ଅନୁଗ୍ର‍ଅରେ ଜିବନ୍‍ କାଟେ ନ୍‍ସା ଆମେଇଂକେ ବାସଙ୍ଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_44","074_13_44","ACT","13","44","44","ପାଙ୍ଗ୍‍ନେ ସାନ୍ତା କାଲା ସଅର୍‍ନେ ସାପାରେ ମାପ୍‌ରୁନେ ବ୍ନାଇର୍‍ ଦ୍ରିଗ୍‍ ନ୍‍ସା ରିସିଙ୍ଗ୍ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_45","074_13_45","ACT","13","45","45","ରେମୁଆଁ ଗଅଲି କେଚେ ଜିଉଦିଇଂ ରିସାଡିଙ୍ଗ୍‌ଆର୍କେ ବାରି ପାଉଲ୍‍ନେ ସାମୁଆଁରେ ବିରଦ୍‍ ଡିଙ୍ଗ୍‍ଚେ ଅପମାନ୍‍ ରକମ୍‍ନେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_46","074_13_46","ACT","13","46","46","ମାତର୍‍ ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବା ସାଆସ୍‍ରେ ବାସଙ୍ଗ୍‍ଆର୍କେ “ଇସ୍‍ପର୍‍ନେ ନିମାଣ୍ଡା ସାମୁଆଁ ପେ ଡାଗ୍ରା ପର୍‍ତୁମ୍‍ ବାସଙ୍ଗ୍‍ନେ ଦର୍‍କାର୍‍ ଲେଃଗେ । ମାତର୍‍ ପେ ମାଡାନେ ଜିବନ୍‍ ବାନ୍‍ସା ନିଜେକେ ଅଜଗ୍ୟ ବାବେଚେ ଆକ୍ମେକେ ମନା ଡିଂପେଡିଂକେସା ନେ ଆପେକେ ଆନ୍ତାର୍‍ଚେ ବିନ୍‍ ଅଣଜିଉଦି ରେମୁଆଁ ଡାଗ୍ରା ନେୱେଏ । ");
INSERT INTO gaq_vpl VALUES ("AC13_47","074_13_47","ACT","13","47","47","ମାପ୍‌ରୁ ଆନେକେ ଆକେନ୍ ଆଦେସ୍‌ ବିବକେ: ‘ନେଙ୍ଗ୍‍ ଆନାକେ ଅଣଜିଉଦି ରେମୁଆଁଇଂ ନ୍‌ସା ତାର୍‍କିଗ୍‍ସ ରକମ୍‍ ଆଡିଙ୍ଗ୍‍ମ୍ବକେ । ଡିଡିକି ସର୍‌ତେ ମଞ୍ଚ୍‌ପୁର୍‌ ଉଦାର୍ ବାଆର୍‌ଏ ।’” ");
INSERT INTO gaq_vpl VALUES ("AC13_48","074_13_48","ACT","13","48","48","ଅଣଜିଉଦି ରେମୁଆଁଇଂ ଆକେନ୍‍ ସାମୁଆଁ ଦ୍ରିଗ୍‍ଚେ ସାର୍‍ଦା ଡିଙ୍ଗ୍‍ଆର୍କେ ବାରି ମାପ୍‍ରୁନେ ସାମୁଆଁ ନ୍‍ସା ପ୍ରସଂସା ଡିଙ୍ଗ୍‌ଆର୍‌କେ । ଜାଣ୍ଡେଇଂ ମାଡାକ୍ନେ ଜିବନ୍‍ସା ପାଙ୍ଗ୍‍ଲେଆର୍ଗେ ଆତେନ୍‌‍ ରେମୁଆଁଇଂ ମାପ୍‌ରୁନ୍ନିଆ ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_49","074_13_49","ACT","13","49","49","ଆତେନ୍‌‍ ଏରିଆନେ ସାପା ଜାଗାନ୍ନିଆ ମାପ୍‌ରୁନେ ସାମୁଆଁ ବେପ୍ରେ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_50","074_13_50","ACT","13","50","50","ଜିଉଦିଇଂ ଜିଉଦି ଦର୍ମନେ ମ୍ନା ବଂସନେ ସେଲାମ୍ବୁଏଃ ରେମୁଆଁଇଂକେ ବାରି ଇନିନେ ମ୍ନାଃ ରେମୁଆଁଇଂକେ ରିସା ଡିଂଚେ ପୁଜା ଡିଙ୍ଗ୍ଆର୍କେ । ମେଇଂ ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବା ବିରଦ୍‍ରେ ବିନ୍‍ରେ ବାସଙ୍ଗ୍‍ବିଆର୍କେ । ମେଇଂ ଆମେଇଂକେ ତାଡ଼୍‍ନା ଡିଙ୍ଗ୍‍ନେ ଆରାମ୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ ବାରି ଆମେଇଂକେ ଆତେନ୍‌‍ ଏରିଆବାନ୍‍ ନୁଆଁ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_51","074_13_51","ACT","13","51","51","ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବା ଆତେନ୍‌ ରେମୁଆଁଇଙ୍ଗ୍‌ନେ ବିରଦ୍‍ରେ ନିଜେ ନିଜେନେ ଞ୍ଚନେ ଦୁଲି ପାଃଚେ ଇକନିୟ ଇନିନ୍ନିଆ ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC13_52","074_13_52","ACT","13","52","52","ଆଣ୍ଟିୟକନେ ବିସ୍‌ବାସିଇଂ ପବିତ୍ର ଆତ୍ମା ବାଚେ ବାରି ସାର୍‍ଦାରେ ଲେଃଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_1","074_14_1","ACT","14","1","1","ଇକନିୟ ଡିଗ୍‍ ଦେତୁଆ ଗଟ୍‌ନା ଗଟେକେ ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବା ପାର୍‌ତନା ଡୁଆଇଂ ଅରିଆ ୱେଚେ ଡେକ୍‌ରକମ୍ ବାବ୍‌ରେ ବାସଙ୍ଗ୍‌‌ ଡିଙ୍ଗ୍‍ଆର୍‍କେ ଜେ ଜାବର୍‌ ସଂକ୍ୟାରେ ଜିଉଦି ବାରି ଗ୍ରୀକ୍‌ ରେମୁଆଁଇଂ ଜିସୁ କିସ୍‌ଟ ଡାଗ୍ରା ବିସ୍‍ବାସ୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_2","074_14_2","ACT","14","2","2","ମାତର୍‍ ଅବିସ୍‍ବାସି ଜିଉଦିଇଂ ଅଣଜିଉଦି ରେମୁଆଁଇଂନେ ମନ୍‌କେ ଆତେନ୍‌‍ ବୟାଁଇଂନେ ବିରଦ୍‍ରେ ଦଦ୍ୟା‍ ବାବ୍‍ନା ଆଃମ୍ୟାଃଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_3","074_14_3","ACT","14","3","3","ତେଲାଡିଗ୍‍ ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବା ଆତ୍‍ଅରିଆ ଗୁଲେସି ଲେଃଆର୍କେ ବାରି ମାପ୍‌ରୁନେ ବ୍ନାଲିର୍‍ ସାଆସ୍‍ ସାଚେ ପର୍‌ଚାର୍‍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ଆମେଇଂକେ ବିଚେ ମାପ୍‌ରୁ ଚିନ୍ ଆରି କାବା ଡିଙ୍ଗ୍‍ନେ କାମ୍ ସାପା ଡିଙ୍ଗ୍‍କେ ବାରି ଅନୁଗ୍ର‍ଅନେ ବ୍ନାଲିର୍‍ ବିସୟ୍‌ରେ ସାକି ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_4","074_14_4","ACT","14","4","4","ଇନିନେ ରେମୁଆଁଇଂ ମ୍ୱାର୍‍ ବାଗ୍‍ ଡିଙ୍ଗ୍‍ ୱେଆର୍କେ । ଉଡ଼ିରୁଆ ଜିଉଦି ପାକା ବାରି ଉଡ଼ିରୁଆ ସିସ୍‌ଇଂପାକା । ");
INSERT INTO gaq_vpl VALUES ("AC14_5","074_14_5","ACT","14","5","5","ଅଣଜିଉଦି ବାରି ଜିଉଦି ରେମୁଆଁଇଂ ମେଇଂ ଏତେ ଦଦ୍ୟା‍ ବେବଆର୍‍ ଡିଙ୍ଗ୍‍ନେସା ବାରି ମେଇଂ ଆଡ଼ାତ୍ରା ବ୍ରି ଟୁନ୍‍ସା ନେତାଇଂ ଏତେ କୁଡ଼େଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_6","074_14_6","ACT","14","6","6","ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବା ଆକେନ୍‍ ମ୍ୟାଃଚେ ଲୁକାଅନିଆନେ ଲୁସ୍ତ୍ରା ବାରି ଦର୍ବୀ ଇନିନ୍ନିଆ ବାରି ଆତେନ୍‌‍ ପିତୁର୍‍ପାକା ଲେଃକ୍ନେ ଏରିଆପାକା ଲାଗ୍‍ଡଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_7","074_14_7","ACT","14","7","7","ବାରି ମେଇଂ ଆତ୍‍ଅରିଆ ମାପ୍‍ରୁନେ ନିମାଣ୍ଡାସାମୁଆଁ ପର୍‌ଚାର୍‍ ଆରାମ୍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_8","074_14_8","ACT","14","8","8","ଲୁସ୍ତ୍ରା ଇନିନ୍ନିଆ ମୁଇଂ ଜନମ୍‍ବାନ୍‍ ଚଟା ମୁଇଂଜା ଲେଃଗେ ମେଁ ଅଃନାଡିଗ୍ ଅଲେଙ୍ଗ୍‍ ୟା ଆଡିଂଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC14_9","074_14_9","ACT","14","9","9","ଆତ୍‍ଅରିଆ କଚେ ପାଉଲ୍‍ନେ ପର୍‌ଚାର୍ ଡିଙ୍ଗ୍‌ଡିଂକ୍ନେ ବ୍ନାଇର୍‍ ଅଁ ଡିଙ୍ଗ୍‍ଗେ । ପାଉଲ୍‍ ଆମେକେ ସାର୍‍ମୁଆଃ ସିଦା ଆଡିଙ୍ଗ୍‍ଚେ କେକେ ଜେ ମେଁ ନିମାଣ୍ଡା ଡିଙ୍ଗ୍‍ଇଁୟାଏ ଡାଗ୍‍ଚେ ମେଁନେ ବିସ୍‌ବାସ୍‌ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_10","074_14_10","ACT","14","10","10","ମେଁ ୱାସାର୍‍ଚେ ବାସଙ୍ଗ୍‍କେ “ପାଦ୍‍ଚ ନ୍ନିଆ ଲିଗ୍‌ଚେ ସିଦା ତୁଆଁ !” ଆତ୍‌ବାନ୍ ଆତେନ୍‌‍ ରେମୁଆଁ ପୁଏଟେଆଁଚେ ପିତୁର୍‍ ପାକା ଅଲେଙ୍ଗ୍‍ନେ ମୁଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_11","074_14_11","ACT","14","11","11","ଆତ୍‍ଅରିଆ ପାଙ୍ଗ୍‍ଲେ ଆର୍‍କ୍ନେ ରେମୁଆଁଇଂ ପାଉଲ୍‍ନେ ଆକେନ୍‍ କାମ୍ କେଚେ ମେଇଂନେ ଲୁକାୟନ୍ନିଆ ବ୍ନାସାରେ କିରଚେ ବାସଙ୍ଗ୍‍ଆର୍କେ “ଦେବ୍‍ତାଇଂ ରେମୁଆଁ ରୁପ୍‍ ସାଚେ ନେ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ଲେଃଆର୍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC14_12","074_14_12","ACT","14","12","12","ରେମୁଆଁଇଂ ବର୍ଣ୍ଣବାକେ ଜିଅସ୍‌ ମାପ୍‌ରୁ ଡାଗ୍‍ଚେ ବାସଙ୍ଗ୍‍ଆର୍କେ ବାରି ପାଉଲ୍‍ ମ୍ନା ବକ୍ତା ଡିଙ୍ଗ୍‍ଲେଃଲା ଆମେଇଂକେ ହେରମିସ୍‌ ବା ବୃହସ୍ପତ୍ତି ଦେବ୍‍ତା ଡାଗ୍‍ଚେ ବାସଙ୍ଗ୍‍ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_13","074_14_13","ACT","14","13","13","ଆତେନ୍‌‍ ସଅର୍‍ ସାମ୍‍ନେ ଆଃରେବକ୍ନେ ଜିଅସ୍‌ ମନ୍ଦିର୍‍ନେ ପୁଜାରି ସହର୍‌ନେ କାପାଟ୍ ଡାଗ୍ରା ଉଡ଼ିକ୍ଲିଗ୍‍ ଅରେଃକେ ସାରି ଆଚକ୍‌ଚେ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଆର୍କେ । ପୁଜାରି ବାରି ରେମୁଆଁଇଂ ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବାକେ ଆକେନ୍‍ ମାପ୍‍ରୁନେ ମ୍ନିରେ ଗୁଆଗନ୍‌ସା ଇକ୍‌ଚା ଡିଙ୍ଗ୍‍ଆର୍‍ଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_14","074_14_14","ACT","14","14","14","ମାତର୍‍ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ପାଉଲ୍‍ ବାରି ବର୍ଣ୍ଣବା ଆକେନ୍‍ ସାମୁଆଁ ଦ୍ରିଗ୍‍ଚେ ନିଜେନେ ସକା ପାଟାଇ ସେଗାର୍‍ ବିଆର୍‌କେ । ମେଁଇଂ ରେମୁଆଁଇଂନେ ପାକା ୱିର୍‍ ୱେଚେ କିରଚେ ବାସଙ୍ଗ୍‍ନେ ମୁଲେଆର୍କେ ");
INSERT INTO gaq_vpl VALUES ("AC14_15","074_14_15","ACT","14","15","15","“ଏ ରେମୁଆଁଇଂ ପେ ଦେକ୍‍ରକମ୍‍ ମେଁସା ଡିଙ୍ଗ୍‍ପେଡିଙ୍ଗ୍‍କେ ? ନେ ଡିଗ୍‍ ପେ ରକମ୍‍ ମୁଇଂ ରେମୁଆଁ । ନେ ଆପେକେ ମାପ୍‌ରୁ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ ନ୍‍ସା ପାଙ୍ଗ୍‍ନେଲେଃକେ । ଆପେକେ ଆକେନ୍ କାମ୍ ଣ୍ଡୁନେ ସାମୁଆଁବାନ୍ ସ୍ଲ ଲେଃଚେ ଜିବନ୍‌ ପର୍‌ମେସର୍‍ନ୍ନିଆ ମନ୍‌ ଆଆଁଣ୍ଡେ ନ୍‍ସା ନେ ପାଙ୍ଗ୍‌ନେ ଲେଃକେ । ଆତେନ୍‌ ପର୍‍ମେସର୍ କିତଂଇନି ଦର୍‌ତନି ଆରି ମ୍ନା କେଣ୍ଡିଆ ବାରି ଆତ୍ ଅରିଆ ଲେଃଡିଂକ୍ନେ ସାପା ବିସଏ ଆରେ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_16","074_14_16","ACT","14","16","16","ମେଁ ନିଜର୍‍ ଇକ୍‌ଚାରେ ନିଜେନେ ଗାଲି ୱେନ୍‍ସା ଇସ୍‍ପର୍‍ ରେମୁଆଁଇଂକେ ଆନ୍ତାର୍‍ ବିବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_17","074_14_17","ACT","14","17","17","ମାତର୍‍ ମେଁନେ ସାପା ନିମାଣ୍ଡା କାମ୍‌ବାନ୍ ମେଁ କାଲାଆଃ ମେଁନେ ନ୍ତିବାନ୍‍ ସୁଚନା ବିବକେ; ମେଁ କିତଂଇନିବାନ୍‍ ଣ୍ଡିଆ ଆଗୁର୍‍ଏ ଆରି ଟିକ୍‍ ବେଲା କିଆ ବିଃମ୍ୟାକେ ଚଙ୍ଗ୍‍ନେ ବିଃମ୍ୟାକେ ଆରି ସାର୍‍ଦାରେ ପେ ମନ୍‌ ଆତ୍ନ ମ୍ୟାଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC14_18","074_14_18","ACT","14","18","18","ଆକେନ୍‍ ସାପା ସାମୁଆଁ ବାଲିର୍‍ଚେ ବେକ୍ନେ ସିସ୍‍ଇଂ ମେଃଡିଗ୍‍ ଆନେଙ୍ଗ୍‍କେ ଗୁଆଗନ୍‌ସା ଆମେଇଂକେ ମନା ଡିଂ ୟାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_19","074_14_19","ACT","14","19","19","ପିସିଦିଆନେ ଆଣ୍ଟିୟୋଖ ଆରି ଇକନିୟବାନ୍‍ ଉଡ଼ିରୁଆ ଜିଉଦି ପାଙ୍ଗ୍‌ଲେଃଆର୍କେ ମେଁ ରେମୁଆଁଇଂକେ ୱେବାସଙ୍ଗ୍‌ଚେ ପାଉଲ୍‍କେ ବ୍ରି ଏତେ ଟୁଆର୍କେ । ମେଁ ଗୁଏୱେଗେ ଡାଗ୍‍ଚେ ବାବେଚେ ମେଇଂ ଆମେକେ ସହର୍‍ ବାଏରେ ଉର୍‍ଗୁଚେ ଡୁଂୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_20","074_14_20","ACT","14","20","20","ମାତର୍‍ ସିସ୍‍ଇଂ ପାଉଲ୍‍ନେ ପିତୁର୍‍ପାକା ଗେରେ ବିଲା ମେଁ ତଡ଼ିଆଚେ ସହର୍‍ ପାକା ଅଲେଙ୍ଗ୍‍ ୱେକେ । ତେନ୍‍ ମାର୍‍ତଡ଼େ ମେଁ ଆରି ବର୍ଣ୍ଣବା ଏତେ ଦର୍ବୀ ସହର୍‍ ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_21","074_14_21","ACT","14","21","21","ପାଉଲ୍‍ ଆରି ବର୍ଣ୍ଣବା ଦର୍ବୀ ସଅର୍‍ନ୍ନିଆ ମାପ୍‌ରୁ ସାମୁଆଁ ପର୍‌ଚାର୍‍ ଡିଂଆର୍କେ । ଗୁଲେରୁଆ ଜିସୁନେ ସିସ୍ ଡିଙ୍ଗ୍‍ଆର୍କେ । ଇଡ଼ିଙ୍ଗ୍‍ ବର୍ଣ୍ଣବା ଆରି ପାଉଲ୍‍ ଲୁସ୍ତ୍ରା ଇକନିୟ ଆରି ଆଣ୍ଟିୟୋଖ ଡାଗ୍ରା ଆଣ୍ଡେ ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_22","074_14_22","ACT","14","22","22","ମେଇଂ ସିସ୍‌ଇଂନେ ମନ୍‌କେ ସାନ୍‌ତି ଆଡିଙ୍ଗ୍‌କେ ବାରି ବିସ୍‌ବାସ୍‌ରେ ଡାଟ୍‌ ଲେଃନ୍‍ସା ଆମ୍ଲେଡ଼ିଆ ଆର୍କେ । ମେଇଂ ବୁଦି ବିଚେ ବାଲିର୍‍କେ “ଇସ୍‍ପର୍‍ନେ ରାଜିନ୍ନିଆ ଗାନ୍‍ସା ଆନେକେ ଜାବର୍‌ ଦୁକ୍‍ କସ୍ଟ ବାଚେ ଅଲେଙ୍ଗ୍‍ନେ ଡିଙ୍ଗ୍‌ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC14_23","074_14_23","ACT","14","23","23","ସାପା ମଣ୍ଡଲିନ୍ନିଆ ମ୍ନାନେତାଇଂକେ ସ୍ରି ଆର୍କେ । ମେଇଂ ଆକେନ୍‍ ଦର୍ମ ନେତା ନେତାଇଂନେ ଆତ୍‌ଲା ଉପାସ୍‌ ପାର୍‌ତନା ଡିଂଆର୍କେ । ଆକେନ୍‍ ଦର୍ମ ନେତା ନେତାଇଂ ମାପ୍‌ରୁ ଜିସୁ ଡାଗ୍ରା ବିସ୍‍ବାସ୍‍ ଡିଂ ବଆର୍‌କେ । ତେନ୍‍ସା ପାଉଲ୍‍ ଆରି ବର୍ଣ୍ଣବା ଆମେଇଂକେ ମାପ୍‌ରୁ ଡାଗ୍ରା ଅପେଃ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_24","074_14_24","ACT","14","24","24","ପିସିଦିଆ ବିଚେ ମେଇଂ ପଂପୁଲିୟାନ୍ନିଆ ପାଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_25","074_14_25","ACT","14","25","25","ଆତ୍‍ଅରିଆ ପର୍ଗାନ୍ନିଆ ପର୍‌ଚାର୍‍ ଡିଂଚେ ଆତ୍ତାଲିଆନୁଗ୍‍ ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_26","074_14_26","ACT","14","26","26","ଆତ୍‍ବା ମେଇଂ ଣ୍ଡିଆ ଗାଲି ବିଚେ ଆଣ୍ଟିୟକନ୍ନିଆ ପାଙ୍ଗ୍‌ଆର୍କେ । ଆକେନ୍‍ ଆଣ୍ଟିୟକନ୍ନିଆ ବିସ୍‌ବାସିଇଂ ଆମେଇଂକେ ଆକେନ୍‍ କାମ୍ ଡିଂନେସା ଇସ୍‍ପର୍‍ ଡାଗ୍ରା ଅନୁଗ୍ର‍ଅରେ ସମର୍‍ପିତ୍‍ ଡିଙ୍ଗ୍‌ଚେ ଆତେନ୍‌‍ ଜାଗାବାନ୍‍ ତାର୍‍ ଲେଃଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_27","074_14_27","ACT","14","27","27","ମେଇଂ ଆଣ୍ଟିୟକନ୍ନିଆ ୱେଚାଚେ ମଣ୍ଡଲିନେ ରେମୁଆଁଇଂକେ ରାସିଂକେ । ଇସ୍‍ପର୍‍ ମେଇଂ ଆଡ଼ାତ୍ରା ମେଁନେ ସାପା ଡିଂ ବଆର୍ଗେ ଆରି ବିନ୍‍ ଅଣଜିଉଦିଇଂନେ ବିସ୍‌ବାସ୍‌ ନ୍‍ସା ଡିରକମ୍‍ ଗାଲି ରଃବିଃ ବଗେ ଆତେନ୍‌‍ ସାପା ଆମେଇଂକେ ଆମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC14_28","074_14_28","ACT","14","28","28","ଆତ୍‍ଅରିଅ ବିସ୍‌ବାସିଇଂ ଏତେ ମେଁ ଗୁଲେସି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_1","074_15_1","ACT","15","1","1","ଜିଉଦା ପ୍ରଦେସ୍‌ବାନ୍‍ ଉଡ଼ିରୁଆ ରେମୁଆଁ ଆଣ୍ଟିଅକିଆନ୍ନିଆ ପାଙ୍ଗ୍‌ଚେ ମୋଶାନେ ନିୟମ୍‌ ଅନୁସାରେ ମେଇଂ ପବିତ୍ର‌ ଆଡିଙ୍ଗ୍‌ଲା ପରିତ୍ରାନ୍‍ ବା ଆୟାଆର୍‍ ଣ୍ଡୁ ଡାଗ୍‍ଚେ ବୟାଁଇଂକେ ସିକ୍ୟା ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_2","074_15_2","ACT","15","2","2","ଏନ୍‍ ବିସୟ୍‌ରେ ମେଇଂ ଏତେ ପାଉଲ୍‍ ଆରି ବର୍ଣ୍ଣବାକେ ଜବର୍‍ ଜୁକ୍ତାଜୁକ୍ତି ଡିଂଲା ଏନ୍‍ ଉପାୟ୍‍ ଡିଂଆର୍‍କେ ଜେ ପାଉଲ୍‍ ବର୍ଣ୍ଣବା ଆରି ଆଣ୍ଟିୟକିଆନେ ବାରି ଉଡ଼ିରୁଆ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ୱେଚେ ବେବ୍ନ ସିସ୍‌ଇଂ ଆରି ମଣ୍ଡଲିନେ ମ୍ନାରେଇଂ ଏତେ ଆକେନ୍‍ ବିସୟ୍‍ରେ ବୁଜା ସୁଜା ପେଡିଂଏ । ");
INSERT INTO gaq_vpl VALUES ("AC15_3","074_15_3","ACT","15","3","3","ମଣ୍ଡଲିଇଂ ଆମେଇଂକେ ଗାଲି ସାମୁଆଁରେ ବାଲିର୍‍ଚେ ବେବିକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ମେଇଂ ଫୈନିକୀୟା ଆରି ସମରିଆ ଗାଲି ୱେବେଲା ଅଣଜିଉଦିଇଂକେ ମନ୍‍ ବଦ୍‍ଲେଚେ ଇସ୍‍ପର୍‍ ଡାଗ୍ରା ପାଂଲେଆର୍କେ ଆତେନ୍‌‍ ବିସୟ୍‌ରେ ଆମ୍ୟାଃଆର୍କେ । ଆକେନ୍‍ କବର୍‍ ଅଁଚେ ବୟାଁଇଂ ଜାବର୍‌ ସାର୍‍ଦା ଡିଂଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_4","074_15_4","ACT","15","4","4","ଇଡ଼ିଙ୍ଗ୍‍ ମେଇଂ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ପିଙ୍ଗ୍‍ଚାଚେ ମଣ୍ଡଲି ବାରି ପ୍ରେରିତ୍‌ ସିସ୍‌ ଆରି ସେବକଇଂ ଆମେଇଂକେ ସାର୍ଲ ଆର୍କେ । ଇସ୍‍ପର୍‍ ମେଇଂନେବାନ୍‍ ଡିଂବକ୍ନେ କାମ୍ ବିସୟ୍‍ରେ ପାଉଲ୍‍ ଆରି ବର୍ଣ୍ଣବା ଆମେଇଂକେ ଆମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_5","074_15_5","ACT","15","5","5","ମାତର୍‍ ଫାରୁଶୀ ଦଲ୍‍ନେ ଉଡ଼ିରୁଆ ବିସ୍‍ବାସି ତଡ଼ିଆଚେ ବାସଙ୍ଗ୍‍ଆର୍କେ “ଅଣଜିଉଦିଇଂକେ ପବିତ୍ର‌ ଡିଂନେ ଆରି ମୋଶାନେ ନିୟମ୍‌ ମାନେନ୍‌ସା ଆମେଇଂକେ ଆଦେସ୍‍ ବିନେ ଦର୍‍କାର୍‍ ।” ");
INSERT INTO gaq_vpl VALUES ("AC15_6","074_15_6","ACT","15","6","6","ଏନ୍‍ ବିସୟ୍‌ରେ ବାଲିର୍ ବାତାନ୍‍ସା ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ଆରି ସେବକଇଂ ମୁଇଂତୁଗ୍‍ ରିସିଂ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_7","074_15_7","ACT","15","7","7","ଜାବର୍‌ ପର୍‍ ବାଲିର୍‍ ବାତାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ପିତର୍‍ ତୁଆଁଚେ ବାଲିର୍‍କେ “ବୟାଁ ଆରି ତନାଇଂ ପେ ମ୍ୟାଃ ପେଲେଃକେ ଜେ ଗୁଲେସି ଅଃସେ ଇସ୍‍ପର୍‍ ଅଣଜିଉଦିଇଂନେ ଡାଗ୍ରା ନିମାଣ୍ଡା ସାମୁଆଁ ପର୍‌ଚାର୍‍ ଡିଂଚେ ଆତ୍‍ବା ମେଇଂନେ ବିସ୍‍ବାସ୍‍ ଆଡିଂନେ ନ୍‍ସା ପେ ବିତ୍ରେବାନ୍‍ ଆନେଙ୍ଗ୍‍କେ ସ୍ରିବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_8","074_15_8","ACT","15","8","8","ବାରି ସାପାରେନେ ମନ୍‍ ବିତ୍ରେନେ ଚିନ୍ତା ମ୍ୟାଡିଂକ୍ନେ ଅନ୍ତର୍ଯ୍ୟାମି ଇସ୍‍ପର୍‍ ଆନେକେ ଡିରକମ୍‍ ପବିତ୍ର ଆତ୍ମା ବିବକେ ଅଣଜିଉଦିଇଂକେ ଡିଗ୍‍ ଦେତ୍‍ରକମ୍‍ ଦାନ୍‌ବିଚେ ମେଇଂକେ ପାକା ସାକି ବିଃବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_9","074_15_9","ACT","15","9","9","ବାରି ମେଁ ନେଁଡାଗ୍ରା ବାରି ମେଇଂନେ ବିତ୍‌ରେ ମେଃଡିଗ୍‌ ଏତ୍‌ ବିଚାର୍‌ ମାବଚେ ବିସ୍‌ବାସ୍‌ ଏତେ ମେଇଂନେ ଜିବନ୍‌କେ ପବିତ୍ର ଆଃଡିଙ୍ଗ୍‌ବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_10","074_15_10","ACT","15","10","10","ତେଲା ଆଣ୍ଡିନେ ରିଗ୍‌ନ ଡୁଂନେସା ନେନେ ଅସେନେ ନ୍ତା ଞ୍ଜାଇଂ ଆରି ନେ ଡିଗ୍ ମାନେଃ ନେୟାକେ ପେ ତ ଏବେ ବିସ୍‌ବାସିଇଂନେ ପ୍ଲା ଗାଗ୍‍ଡ଼େନ୍ନିଆ ଆତେନ୍‌‍ ଲାଦେ ବିଚେ ମେଁସା ଇସ୍‍ପର୍‍କେ ପରିକ୍ୟା ଡିଂନେନ୍‍ସା ଚାଏଁପେଡିଂକେ ? ");
INSERT INTO gaq_vpl VALUES ("AC15_11","074_15_11","ACT","15","11","11","ଣ୍ଡୁ ଏନ୍‍ ଟିକ୍‍ ଣ୍ଡୁ । ମେଇଂ ଆଣ୍ଡିନେ ବିସ୍‍ବାସ୍‍ ଡିଂଚେ ଉଦାର୍‍ ବାଲେଃଆର୍କେ, ନେ ଡିଗ୍‍ ଟିକ୍‍ ଦେତ୍‍ରକମ୍‍ ବିସ୍‍ବାସ୍‍ ଡିଂଚେ ମାପ୍‌ରୁ ଜିସୁନେ ଅନୁଗ୍ର‍ଅବାନ୍‍ ଉଦାର୍ ବାନେଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC15_12","074_15_12","ACT","15","12","12","ପାଉଲ୍‍ ଆରି ବର୍ଣ୍ଣବାନେବାନ୍‍ ଅଣଜିଉଦିଇଂନେ ବିତ୍‍ରେ ଇସ୍‍ପର୍‍ ଆଣ୍ଡିନେ ସାପା ଚିନ୍ ଆରି ଇରିଆତୁଗ୍‍ନେ ବିସୟ୍‍ ପୁରନ୍ ଡିଂବଗେ ମେଇଂନେବାନ୍‍ ମେଁନେ ସାମୁଆଁ ଅଁଚେ ଦଲ୍‍ନେ ସାପାରେ ବୁଙ୍ଗ୍‍ ଲେଃଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_13","074_15_13","ACT","15","13","13","ମେଇଂ ବାଲିର୍‍ ଆଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ଜାକୁବ୍‌ ବାଲିର୍‍କେ “ଅ ବୟାଁ ତନାଇଂ ନିଙ୍ଗ୍‍ ସାମୁଆଁ ଦ୍ରିଗ୍‍ପା ! ");
INSERT INTO gaq_vpl VALUES ("AC15_14","074_15_14","ACT","15","14","14","ଇସ୍‍ପର୍‍ ଡିରକମ୍‍ ଅନୁଗ୍ର‍ଅ ଆଡିଂଚେ ନିଜର୍ ମ୍ନିନ୍‌ସା ଅଣଜିଉଦିଇଂନେ ବିତ୍‍ରେ ଉଡ଼ିରୁଆକେ ମେଇଂନେସା ସ୍ରି ବକେ ଶିମୋନ ଆତେନ୍‌‍ ସାମୁଆଁ ଆବୁଜେ ବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_15","074_15_15","ACT","15","15","15","ବାବବାଦିଇଂନେ ସାମୁଆଁ ଆକେନ୍‍ ପୁରାପୁରି ବାବ୍‍ରେ ମିସୁ ଡିଂକେ । ଡିରକମ୍‍ କି ସାସ୍ତର୍‌ନିଆ ଗ୍ନୁଆର୍‍ ଲେଃକେ; ");
INSERT INTO gaq_vpl VALUES ("AC15_16","074_15_16","ACT","15","16","16","‘ମାପ୍‌ରୁ ବାଲିର୍‍ ଡିଂକେ ଏନ୍‍ ଇଡ଼ିଙ୍ଗ୍‌ ନେଙ୍ଗ୍‍ ଆଣ୍ଡେ ମ୍ପାଙ୍ଗ୍‍ଏ ଆରି ଦାଉଦ୍‍ନେ ତିପଗ୍‌ ଲେଃକ୍ନେ କୁଡ଼ିଆ ବାରି ମୁଇଂତର୍‍ ଣ୍ଡ୍ରାରେଏ’ ଆରି ମେଁନେ ଦଂସ ଡିଂକ୍ନେ ଜାଗା ବାରି ମୁଇଂତର୍‍ ଆରେଚେ ଣ୍ଡ୍ରା ତୁଆଁଏ । ");
INSERT INTO gaq_vpl VALUES ("AC15_17","074_15_17","ACT","15","17","17","ସାପା ରେମୁଆଁ ନେଙ୍ଗ୍‍ ଡାଗ୍ରା ପାଙ୍ଗ୍‍ଆର୍‍ଏ ଆଣ୍ଡିନେ ଅଣଜିଉଦିଇଂକେ ନେଙ୍ଗ୍‍ ଡାଗ୍ରା ଆମିସୁନ୍‍ସା ୱା ମ୍ୱକେ ମେଇଂ ସାପାରେ ମାପ୍‌ରୁନେ ଡାଗ୍‌ଚେ ବାସଙ୍ଗ୍‌ ଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC15_18","074_15_18","ACT","15","18","18","ମାପ୍‌ରୁ ଏନ୍‍ ସାମୁଆଁ ବାଲିର୍‍ବକେ ଜାଣ୍ଡେ କି ଅସେବାନ୍‍ ଆଃ ଆକେନ୍‍ ସାମୁଆଁ ମେଁ ବାଲିର୍‍ଚେ ଆଦ୍ରିଗ୍‍ବକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC15_19","074_15_19","ACT","15","19","19","ଜାକୁବ୍‌ ବାରି ଡିଗ୍‍ ବାଲିର୍‍କେ “ନେଙ୍ଗ୍‍ ବିଚାର୍‌ରେ ଆକେନ୍‌ନେ ଅଣଜିଉଦି‍ଇଂ ଇସ୍‍ପର୍‍ ଡାଗ୍ରା ଆଣ୍ଡେ ପାଙ୍ଗ୍‍ ଲେଃଆର୍କେ ନେ ଆମେଇଂକେ ଆରି ଅଇରାନ୍ ନେରାଡିଂ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC15_20","074_15_20","ACT","15","20","20","ମେଇଂ ଜେନ୍ତିକି ମୁର୍ତିକେ ମାନସିକ୍‍ ଡିଂବମ୍ୟାଃକ୍ନେ ମେଃଡିଗ୍‍ ଅପବିତ୍ର ଜିନିସ୍‌ ଆଚଙ୍ଗ୍‍ଆର୍ ଅଡ଼ାରେଗ୍‌‌ ପାପ୍‍ବାନ୍‍ ସ୍ଲ ଲେଃଆର୍‌ଏ ଲୁଗ ଆଲିଚେ ବାଗୁଏ ବଆର୍‍କ୍ନେ ପସୁନେ ଚିଲି ଆଚଙ୍ଗ୍‌ଆର୍, ଏନ୍‍ ସାପା ବିସୟ୍‌ରେ ବାଲିର୍‍ଚେ ମେଇଂନେ ଡାଗ୍ରା ମୁଇଂ ଚିଟି ଉଲିଆ ନେଗୁଆର୍‍ପା । ");
INSERT INTO gaq_vpl VALUES ("AC15_21","074_15_21","ACT","15","21","21","ଡାଗ୍ଲା ଅସେବାନ୍ ସାଚେ କାଲାଆଃ ସାନ୍ତା କାଲା ପାର୍‌ତନା ଡୁଆଇଂନ୍ନିଆ ମୋଶାନେ ନିୟମ୍‌ ଲଃଡିଂଆର୍କେ ଆରି ସାପା ସହର୍‍ନ୍ନିଆ ମେଁନେ ସାମୁଆଁ ପର୍‌ଚାର୍‍ ଡିଂଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC15_22","074_15_22","ACT","15","22","22","ଇଡ଼ିଙ୍ଗ୍‌ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ଆରି ମ୍ନାରେଇଂ ବାରି ମଣ୍ଡଲିନେ ସାପାରେ ଦଲ୍‍ନେ ଉଡ଼ିରୁଆକେ ସ୍ରିଚେ ପାଉଲ୍‍ ଆରି ବର୍ଣ୍ଣବା ଏତେ ଆମେଇଂକେ ଆଣ୍ଟିୟକନ୍ନିଆ ବେନ୍‌ସା ରାଜି ଡିଂଆର୍କେ । ବର୍ଶବା ମ୍ନିରେ ସ୍ନାମୁଆଃ ଜିଉଦା ଆରି ଶୀଲା ବିସ୍‍ବାସିଇଂନେ ବିତ୍‍ରେ ଜାବର୍‌ ସନ୍‍ମାନ୍‍ ବା ଡିଂଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_23","074_15_23","ACT","15","23","23","ବିସ୍‍ବାସିଇଂ ଆତେନ୍‌‍ ଚିଟି ଉଲିଆ ଆତେନ୍‌‍ ମ୍ୱାୟାନେ ନ୍ତିନ୍ନିଆ ବେଆର୍କେ । “ଆଣ୍ଟିୟକ ସିରିଆ ଆରି ସିଲିଷୀଆନେ ଅଣଜିଉଦିଇଂନେ ବିତ୍ରେବାନ୍‍ ପାଙ୍ଗ୍‍ଲେଃଆର୍‍କ୍ନେ ବୟାଁଇଂକେ ପ୍ରେରିତ୍‌ ସିସ୍‌ଇଂ ଆରି ସେବକଇଂ ସାର୍ଲ ଡିଂ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_24","074_15_24","ACT","15","24","24","ନେ ଅଁ ନେଲେଃକେ ଜେ ନେନେ ଦଲ୍‍ବାନ୍‍ ଉଡ଼ିରୁଆ ପେ ଡାଗ୍ରା ୱେଚେ ମେଃନେ ବାସଙ୍ଗ୍‍ବଆର୍କେ ଆତ୍‍ବା ମେଇଂ ଆପେକେ କସ୍ଟ ଆରି ମନ୍‌କେ ତେରେପେତେ ଆଡିଂବଆର୍କେ । ମାତର୍‍ ଏନ୍‍ ବିସୟ୍‍ରେ ନେ ଆମେଇଂକେ ମେଃଡିଗ୍‍ ଆଦେସ୍‍ ନେବିକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC15_25","074_15_25","ACT","15","25","25","ତେସା ନେ ସାପାରେ ମୁଇଂ ମନ୍‍ ଡିଂଚେ ଉଡ଼ିରୁଆ କବର୍‍ ବିଣ୍ଡ୍ରେକେ ସ୍ରିଚେ ପେ ଡାଗ୍ରା ବେନ୍‌ସା ରାଜି ଡିଂନେଲେଃକେ । ମେଇଂ ନେନେ ନିଜର୍ କୁଟୁମ୍‍ ବର୍ଣ୍ଣବା ଆରି ପାଉଲ୍ ଏତେ ୱେଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC15_26","074_15_26","ACT","15","26","26","ଏନ୍‍ କୁଟୁମ୍‍ଇଂ ମାପ୍‌ରୁ ଜିସୁ କିସ୍‌ଟନେ ସେବାରେ ନିଜେନେ ଜିବନ୍‍କେ ବିଃ ଜଗ୍‌ତ୍ଲାଗ୍‍ ବ‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_27","074_15_27","ACT","15","27","27","ନେ ଜିଉଦା ବାରି ଶୀଲାକେ ପେ ଡାଗ୍ରା ବେଡିଂକେ । ନେ ମେଃନେ ଗୁଆର୍‍ ନେବକେ ମେଇଂ ନିଜେ ନିଜେ ଆତେନ୍‌‍ ଆପେକେ ବାଲିର୍‍ଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC15_28","074_15_28","ACT","15","28","28","ଉଡ଼ିକ୍ଲିଗ୍‍ ଦର୍‍କାର୍‍ ପଡ଼େନେ ନିୟମ୍‍ ଆନ୍ତାର୍‍ଚେ ପେ ଆଡ଼ାତ୍ରା ବାରି ମେଃଡିଗ୍‍ ଲିଗିଙ୍ଗ୍‍ ମାଲାଦେ ନ୍‍ସା ନେ ପବିତ୍ର ଆତ୍ମାନେବାନ୍ ଆଦେସ୍‍ ବାନେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_29","074_15_29","ACT","15","29","29","ଆତେନ୍‌‍ ଉଡ଼ିକ୍ଲିଗ୍‍ ନିୟମ୍‍ ଡିଂଗେ; ମୁର୍ତ୍ତିଇଂନେ ଉଦେସ୍‍ରେ ବିବକ୍ନେ ମେଃଡିଗ୍‍ ଜିନିସ୍ ପେଚଙ୍ଗ୍‍ ଣ୍ଡୁ, ମିଆଁ ପେଉଗ୍‍ ଣ୍ଡୁ, ଲୁଗକେ ଆଲିଃଚେ ବାଗୁଏଃବକ୍ନେ ମେଃଡିଗ୍‍ ଜିବ୍‍ନେ ଚିଲି ପେଚଙ୍ଗ୍‍ ଣ୍ଡୁ ଆରି ଦଦ୍ୟା‌ ପାପ୍‌ବାନ୍‍ ସ୍ଲ ଲାଲାପା । ଏନ୍‍ ସାପା କାମ୍ ମାଡିଂଲା ପେନେ ମଙ୍ଗଲ୍‍ ଡିଂଏ । ନେନେ ସାର୍‌ଲ ସାପା ଗ୍ର‍ଅନ୍‌ ଡିଂପା ।” ");
INSERT INTO gaq_vpl VALUES ("AC15_30","074_15_30","ACT","15","30","30","ଆଣ୍ଡିନେ କବର୍‍ ବେଣ୍ଡ୍ରେଇଂ ବେବଆର୍‍କେ ମେଇଂ ଆଣ୍ଟିୟକନ୍ନିଆ ୱେଚେ ବିସ୍‍ବାସିଇଂନେ ସାପା ଦଲ୍‍କେ ମୁଇଂନୁଗ୍‍ ରାସିଂଚେ ଏନ୍‍ ଉଲିଆ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_31","074_15_31","ACT","15","31","31","ଆତ୍‍ ଅରିଆନେ ବିସ୍‍ବାସିଇଂ ଉଲିଆ ଡାଗ୍ରା ଗୁଆର୍‍ବକ୍ନେ ମ୍ଲେଡ଼ିଆ ସାମୁଆଁ ପଡ଼େଚେ ଆମ୍ଲେଡ଼ିଆ ଡିଂଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_32","074_15_32","ACT","15","32","32","ଜିଉଦା ବାରି ଶୀଲା ମେଇଂ ନିଜେ ବାବବାଦି ଲେଆର୍ଗେ ଆରି ମେଇଂ ଆଣ୍ଟିୟକନେ ବିସ୍‌ବାସି‍ଇଂକେ ଗୁଲେ ପର୍‍ ଜାକ ସାମୁଆଁ ବିଚେ ବୟାଁଇଂକେ ଆମ୍ଲେଡ଼ିଆଚେ ଡାଟ୍‍ ଆଡିଂଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_33","074_15_33","ACT","15","33","33","ଆତ୍‍ଅରିଆ ଉଡ଼ି ପର୍‍ ଜାକ ଲେଃକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଜାଣ୍ଡେ ଆମେଇଂକେ ବେବଆର୍ଗେ ମେଇଂ ଡାଗ୍ରା ଆଣ୍ଡେ ୱିଗ୍‍ନେସା ବୟାଁଇଂନେବାନ୍‍ ସାନ୍ତିରେ ୱିଗ୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_34","074_15_34","ACT","15","34","34","ମାତର୍‍ ଶିଲା ଆତ୍‍ଅରିଆ ଲେଃନ୍‍ସା ମନ୍‍ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_35","074_15_35","ACT","15","35","35","ପାଉଲ୍‍ ଆରି ବର୍ଣ୍ଣବା ଆଣ୍ଟିୟକନ୍ନିଆ ଉଡ଼ି ମୁଆଁ ଲେଃଚେ ଗୁଲେରୁଆ ଏତେ କୁଡ଼େଃମାଡ଼େଃଚେ ମାପ୍‌ରୁ ସାମୁଆଁ ବାସଙ୍ଗ୍‌‌ ଡିଂଆର୍କେ ଆରି ସିକ୍ୟା ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_36","074_15_36","ACT","15","36","36","ଉଡ଼ିସି ଇଡ଼ିଙ୍ଗ୍‍ ପାଉଲ୍‍ ବର୍ଣ୍ଣବାକେ ବାଲିର୍‍କେ “ଦୁବା ନେ ଆଣ୍ଡେ ନେୱିଗ୍‍ ସାପା ସଅର୍‍ନ୍ନିଆ ମୁଡ଼ି ବୟାଁଇଂକେ ମାପ୍‌ରୁନେ ସାମୁଆଁ ଆଦ୍ରିଗ୍‍ ନେଡିଂଗେ ଆମେଇଂକେ ନେଅବା ଆରି ମେଇଂ ଡିରକମ୍‍ ଲେଃଆର୍କେ ନେବୁଜେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC15_37","074_15_37","ACT","15","37","37","ବର୍ଣ୍ଣବା ମେଇଂ ଏତେ ଜହନ୍‌ ମାର୍‌କ ମ୍ନିକ୍ନେ ସ୍ନାମୁଆଁ ରେମୁଆଁକେ ଡୁଙ୍ଗ୍‍ ୱେନ୍‍ସା ରାଜି ଡିଂଲେଃଆର୍ଗେ ");
INSERT INTO gaq_vpl VALUES ("AC15_38","074_15_38","ACT","15","38","38","ମାତର୍‍ ପାଉଲ୍‍ ଆମେକେ ଡୁଂୱେନ୍‍ସା ରାଜି ଆଡିଂକେ ଣ୍ଡୁ; ମାତର୍‍ ମେଁ ସିସେବାନ୍‍ ପଂପୁଲିୟାନ୍ନିଆ ମେଇଂ ଏତେ ଏନ୍‍ କାମ୍‍ନ୍ନିଆ ମିସୁ ମାଲେଃଚେ ମେଇଂକେ ଆନ୍ତାର୍‍ଚେ ପାଙ୍ଗ୍‍ ଲେଃଆର୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_39","074_15_39","ACT","15","39","39","ତେନ୍‍ସା ଏନ୍‍ ବିସୟ୍‌ରେ ଜାବର୍‌ ଅଡ଼୍‌କା ଅଡ଼୍‌କି ଡିଂଚେ ମେଇଂ ମ୍ୱାୟା ଅଲ୍‍ଗା ଡିଂ ୱେଆର୍ଗେ । ବର୍ଣ୍ଣବା ମାର୍‌କକେ ସାଚେ ସାଇପ୍ରସ୍ ପାକା ଣ୍ଡିଆ ଗାଲି ବିଚେ ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_40","074_15_40","ACT","15","40","40","ମାତର୍‍ ପାଉଲ୍‍ ଶୀଲାକେ ସ୍ରିଚେ ଆରି ବୟାଁଇଂନେବାନ୍‍ ମାପ୍‌ରୁନେ ଅନୁଗ୍ର‍ଅରେ ସମର୍ପିତ ଡିଂଚେ ୱିଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC15_41","074_15_41","ACT","15","41","41","ମେଁ ମଣ୍ଡଲିଇଂକେ ଡାଟ୍‍ ଆଡିଂଚେ ସିରିଆ ଆରି କିଲିକିଆ ବିଚେ ୱିଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_1","074_16_1","ACT","16","1","1","ପାଉଲ୍‍ ଦର୍ବୀ ଆରି ଲୁସ୍ତ୍ରା ଇନି ପାକା ୱେଆର୍କେ । ଆତ୍‍ତେ ତିମତି ମ୍ନିକ୍ନେ ମୁଇଂ କିସ୍ଟାନ୍‍ ଲେଃଚେ ବ୍ରୁଆ ଡିଂଗେ । ମେଁ ମୁଇଂ କ୍ରିସ୍ଟ ବିସ୍‌ବାସି ଜିଉଦି ରେମୁଆଁ ସେଲାମ୍ବୁଏନେ ଉଂଡେ । ମାତର୍‍ ମେଁ ଆବାଡ଼େ ମୁଇଂ ଗ୍ରୀକ୍‌ ରେମୁଆଁ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_2","074_16_2","ACT","16","2","2","ଲୁସ୍ତ୍ରା ଆରି ଇକନିୟନ୍ନିଆ ଲେଃକ୍ନେ ବୟାଁଇଂ ବିତ୍‍ରେ ତିମତିନେ ମାଣ୍ଡା ମ୍ନି ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_3","074_16_3","ACT","16","3","3","ପାଉଲ୍‍ ମେଁ ଏତେ ତିମତିକେ ଡୁଙ୍ଗ୍‍ୱେନ୍‍ସା ଚାଏଁକେ ତେନ୍‍ସା ଆମେକେ ପବିତ୍ର ଆଡିଙ୍ଗ୍‍ଆର୍କେ । ଆକେନ୍‍ ଆଡିଙ୍ଗ୍‍ନେ ଡାଗ୍‌ଲା ତିମତିନେ ଆବାଡ଼େ ଗ୍ରୀକ୍‌ ରେମୁଆଁ ଲେଃଗେ ଡାଗ୍‍ଚେ ଆତେନ୍‌‍ ଏରିଆଇଂକେ ଲେଃଚେ ବ୍ରୁଆ ମ୍ୟାଃକ୍ନେ ଜିଉଦିଇଂ ମ୍ୟାଃଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_4","074_16_4","ACT","16","4","4","ବିନ୍‍ବିନ୍‍ ଇନିଇଂ ବିଚେ ୱେବେଲା ମେଁଇଂ ବିସ୍‍ବାସିଇଂକେ ଯିରୁସାଲାମ୍‌ ଡାଗ୍ରା ପ୍ରେରିତ୍‌ ସିସ୍‌ ଆରି ମ୍ନାରେଇଂ ଆଃରେକ୍ନେ ନିତି ନିୟମ୍‍ ସାପା ଆବୁଜେଚେ ତେନ୍‍ ସାପା ମାନେନେ ନ୍‍ସା ବାଲିର୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_5","074_16_5","ACT","16","5","5","ତେନ୍‍ସା ମଣ୍ଡଲିଇଂ ବିସ୍‌ବାସ୍‌ରେ ଆରି ବପୁ ଡିଂଆର୍‍କେ ବାରି ଦିନ୍‍କେ ଦିନ୍‍ ସଂକ୍ୟାରେ ଜବର୍‍ ଡିଂନେ ଲାଗେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_6","074_16_6","ACT","16","6","6","ପବିତ୍ର ଆତ୍ମା ଆମେଇଂକେ ଆସିଆ ପ୍ରଦେସ୍‍ ପାକା ପର୍‌ଚାର୍‍ ଡିଂନେ ଆଦେସ୍‌ ଆବି ଆର୍କେ ତେସା ମେଁଇଂ ଫ୍ରୁଗିଆ ଆରି ଗାଲାତିୟ ଏରିଆ ପାକା ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_7","074_16_7","ACT","16","7","7","ମିସିଆନେ ଏରିଆ ୱେଚାଚେ ବେଥିନିଆ ପ୍ରଦେସ୍‍ ପାକା ୱେନ୍‍ସା ତେଃତାର୍‍ ବେଲା ଜିସୁନେ ଆତ୍ମା ଆମେଇଂକେ ଆଦେସ୍‌ ଆବିକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC16_8","074_16_8","ACT","16","8","8","ତେନ୍‍ସା ମେଁଇଂ ମିସିଆ ବିତ୍‍ରେ ବିଚେ ଅଲେଙ୍ଗ୍‍ ୱେଚେ ତ୍ରୋୟାନ୍ନିଆ ୱେଚାଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_9","074_16_9","ACT","16","9","9","ତେନ୍ ମିଡିଗ୍‍ ପାଉଲ୍‍ ମୁଇଂ ମୁସୁଡ଼ିଙ୍ଗ୍ ବାକେ ଜେ ମାସିଦୋନିଆନେ ମୁଇଂ ରେମୁଆଁ ତୁଆଁଚେ ସାର୍ଲଚେ ବାଲିର୍‍ ଡିଙ୍ଗ୍‌କେ “ମାସିଦୋନିଆ ପାଙ୍ଗ୍‍ଚେ ଆନେକେ ସାଇଜ୍ୟ ଡିଂ !” ");
INSERT INTO gaq_vpl VALUES ("AC16_10","074_16_10","ACT","16","10","10","ପାଉଲ୍‍ ଆକେନ୍‍ ଦର୍ସନ୍ ବାକ୍ନେ ଦାପ୍ରେ ମାସିଦୋନିଆ ୱେନ୍‍ସା ନେ ତିଆର୍‍ ନେଡିଙ୍ଗ୍‍କେ ଡାଗ୍‍ଲା ନେ ସତ୍‍ ନେମ୍ୟାଃକେ ଇସ୍‍ପର୍‍ ଆତେନ୍‌‍ ରେମୁଆଁଇଂ ବିତ୍‍ରେ ନିମାଣ୍ଡା ସାମୁଆଁ ବାଲିର୍‍ନେ ନ୍‍ସା ଆନେକେ ୱାବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_11","074_16_11","ACT","16","11","11","ନେ ଜାଆଜ୍‍ ଏତେ ତ୍ରୋୟା ଆନ୍ତାର୍‍ଚେ ସାମଥ୍ରାକିପାକା ନେୱେକେ ଆରି ତେନ୍ ଞ୍ଜସ୍ମି ନିଆପଲ୍ଲିନ୍ନିଆ ନେୱେଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_12","074_16_12","ACT","16","12","12","ଆତ୍‍ବାନ୍‍ ନେ ମାସିଦୋନିଆ ଜିଲାନେ ମ୍ନା ଇନି ଫିଲିପ୍‌ପୀପାକା ନେୱେକେ । ଆକେନ୍‍ ଇନି ମୁଇଂ ରମିୟଇଂନେ ଲେଃଗେ । ନେ ଆତ୍‍ତେ ମାଲେ ସି ନେଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_13","074_16_13","ACT","16","13","13","ସାନ୍ତା କାଲା ସ୍ମି ଇନି ବାଏରେ ଲେଃକ୍ନେ ଲଣ୍ଡିଆ ଡାଗ୍ରା ନେୱେକେ । ନେ ନେଏତେକେ ଆତେନ୍‌‍ ଜିଉଦିଇଂ ମିସେଚେ ପାର୍‌ତନା ଡିଂନେସା ମୁଇଂ ଟାନ୍ ଲେଃଏ । ନେ ଆଲ ନେକକେ ଆରି ଆତ୍‍ତେ ରିସିଙ୍ଗ୍ ଲେଃକ୍ନେ ସେଲାମ୍ବୁଏଃ ରେମୁଆଁ ଏତେ ନେବାଲିର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_14","074_16_14","ACT","16","14","14","ମେଇଂ ବିତ୍‍ରେ ଥିୟଟିରା ସଅରନେ କଡ଼େଆଁ ପାଟାଇ ସୁସଡିଂକ୍ନେ ଲୁଦିଆ ତେମ୍ନିକ୍ନେ ମୁଇଂ ସେଲାମ୍ବୁଏଃ ଲେଃଗେ । ମେଁ ଇସ୍‍ପର୍‍କେ ପାର୍‌ତନା ଡିଂଡିଂଗେ ଆରି ପାଉଲ୍‍ ମେଃନେ ବାଲିର୍‍ ଡିଂଗେ ଆତେନ୍‌‍ ମାଣ୍ଡା ଦ୍ରିଗ୍‍ସାଚେ ମାନେଃ ନ୍‌ସା ମାପ୍‌ରୁ ମେଁନେ ଜିବନ୍‌ ରଃବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_15","074_16_15","ACT","16","15","15","ମେଁ ଆରି ମେଁନେ ଡୁଆଣ୍ଡ୍ରେ ସାପାରେ ଣ୍ଡିଆନ୍ନିଆ ଡୁବନ୍‌ ଡୁଂଡକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ଆମେକେ ସାର୍ଲଚେ ବାଲିର୍‍କେ “ମାପ୍‌ରୁନେ ଡାଗ୍ରା ସତ୍‌ରେ ନେଙ୍ଗ୍‌ନେ ବିସ୍‌ବାସ୍‌ ଲେଃକେ ଡାଗ୍‍ଚେ ଜଦି ପେ ବିଚାର୍‌ ଡିଙ୍ଗ୍‌ପେଡିଙ୍ଗ୍‌କେ ତେଲା ପାଙ୍ଗ୍‍ଚେ ନେଙ୍ଗ୍ ଡୁଆ ଲାଲାପା ।” ମେଁ ଦେକ୍‍ରକମ୍‍ ବାବ୍‍ରେ ମେଁ ଡୁଆ ୱେନ୍‍ସା ଆନେକେ ବାଲିର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_16","074_16_16","ACT","16","16","16","ମେସୁଆ ନେ ପାର୍‌ତନା ଜାଗା ୱେବେଲା ମୁଇଂ ଚାକର୍‌ବୁଏଃକେ ନେକୁଡ଼େକେ । ମେଁ ବିତ୍‍ରେ ଲେଃକ୍ନେ ବୁତ୍‌ ଆତ୍ମାନେ ବପୁ ଏତେ ମେଁ ଅସେନେ ସାମୁଆଁ ବାଲିର୍‍ ୟାଡିଙ୍ଗେ । ମେଁ ରେମୁଆଁଇଂନେ ବାଗ୍ୟ ଏଜାଚେ ମାଲିକ୍‍ଇଂନେସା ଜବର୍‍ ଡାବୁ ରାସିଙ୍ଗ୍‌ ଡିଙ୍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_17","074_16_17","ACT","16","17","17","ମେଁ ପାଉଲ୍‌ ଆରି ନେଇଂନେ ପ୍ଲା ପାଙ୍ଗ୍‍ଚେ ୱାସାର୍‍ଚେ ବାଲିର୍‍କେ, “ଆକେନ୍‍ ରେମୁଆଁଇଂ ସର୍‍ତେ ମ୍ୟାକ୍ନେ ଇସ୍‍ପର୍‍ନେ ସେବକ । ପେ ଡିଡି ଉଦାର୍‍ ପେବାଏ ଏନ୍ ସାମୁଆଁ ମେଇଂ ବାଲିର୍‍ଡିଙ୍ଗ୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC16_18","074_16_18","ACT","16","18","18","ସେଲାମ୍ବୁଏଃ ମାଲେ ସି ସାଚେ ଡେକୁଆ ଡିଙ୍ଗ୍‌କେ ସାରାସାରି ବେଲା ପାଉଲ୍‍ ଗିସେଚେ ପ୍ଲା ପାକା ପୁଏଚେ ବୁତ୍‌ ଆତ୍ମାକେ ଦମକ୍‍ ବିଚେ ବାଲିର୍‍କେ, “ଜିସୁ କିସ୍‌ଟନେ ମ୍ନିରେ ଆଦେସ୍‍ ବିଣ୍ଡିଂକେ ମେଁବାନ୍‍ ତାର୍‍ ଲାଗ୍‍ଡଲା” ଆତେନ୍‌‍ ବେଲା ପ୍ରେତଆତ୍ମା ମେଁବାନ୍‍ ତାର୍‍ ଲାଗ୍‍ଡକେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_19","074_16_19","ACT","16","19","19","ଉଡ଼ିବେଲା ମେଁନେ ମାଲିକ୍‍ଇଂ ଆକେନ୍‍ ସାପା କେଆର୍‍କେ । ମେଁଇଂ ମ୍ୟାଃଆର୍‍କେ ଜେ ମେଁଇଂ ଆରି ଆକେନ୍‍ ସେଲାବାନ୍‍ ଡାବୁ ରାସିଙ୍ଗ୍‌ନେ ଆସା ଣ୍ଡୁ । ତେସା ମେଇଙ୍ଗ୍ ପାଉଲ୍‍ ଆରି ଶୀଲାକେ ସାଚେ ଇନିନେ ମଜେ ଲେଃକ୍ନେ ରୋମୀୟ ମ୍ନାନେତା ଡାଗ୍ରା ୱା ଡୁଙ୍ଗ୍‌ପାଙ୍ଗ୍‍ଆର୍କେ ");
INSERT INTO gaq_vpl VALUES ("AC16_20","074_16_20","ACT","16","20","20","ରୋମିୟ ବିଚାର୍ ଡିଂଣ୍ଡ୍ରେ ଡାଗ୍ରା ବାସଙ୍ଗ୍‌ଆର୍କେ, “ଆକେନ୍‍ ରେମୁଆଁଇଂ ଜିଉଦି ମେଇଂ ନେଁ ଇନି ୱିଙ୍ଗ୍‌ଆ ଡିଙ୍ଗ୍ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_21","074_16_21","ACT","16","21","21","ମେଁଇଙ୍ଗ୍‌ନେ ନିୟମ୍‌ ବିରୁଦ୍‍ରେ ନିୟମ୍‌ ଆମ୍ୟାଃ ବିଃଡିଂଆର୍‍କେ । ନେ ରୋମୀୟ ରେମୁଆଁ ତେନ୍‍ସା ଆକେନ୍‍ ସାପା ନିୟମ୍‌ ଗ୍ର‍ଅନ୍‌‍ ଡିଂ ନେୟା ଣ୍ଡୁ ଆତେନ୍‌‍ଇଂ ନେ ମାନେଃ ନେୟା ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC16_22","074_16_22","ACT","16","22","22","ମାଲିକ୍‍ଇଂନେ ସାମୁଆଁ ସାଚେ ଆତ୍‍ତେ ଲେଃକ୍ନେ ରେମୁଆଁଇଂ ପାଉଲ୍‍ ଆରି ସିଲାନେ ବିରୁଦ୍‌ରେ ତଃଡ଼ିଆଆର୍କେ । ପାଉଲ୍‍ ଆରି ସିଲାଇଂନେ ସକା ପାଟାଇ ତଚେ ଆମେଇଂକେ ଡୁଡୁ ଏତେ ବଗ୍‍ନେ ନ୍‍ସା ମ୍ନାନେତା ଆଦେସ୍‍ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_23","074_16_23","ACT","16","23","23","ମେଇଂ ଜବର୍‍ ମାଡ୍‍ ଚଂକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ମେଇଂ କଏଦ୍‍ ଡୁଆନ୍ତୁଗ୍‍ ଆଗାଆର୍କେ ଆରି ଆମେଇଂକେ କୁଚି ତ୍ଲାଗ୍‍ଚେ ଉର୍‍ଲେଃ ନ୍‍ସା କଏଦ୍‍ ଜାଗ୍‍ୱାଲିଇଂକେ ଆଦେସ୍‍ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_24","074_16_24","ACT","16","24","24","ଆକେନ୍‍ ଆଦେସ୍‍ ବାଆର୍‍ଚେ କଏଦ୍‍ ଜାଗୁଆଲ୍‍ଇଂ ଆମେଇଂକେ ମୁଇଂ ବିତ୍‍ରେ ଡୁଆ ଆଗାଚେ ମେଁ ମେଇଂନେ ଞ୍ଚକେ ମ୍ନା କଟ୍‍ଲାନ୍ନିଆ ଗାଗ୍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_25","074_16_25","ACT","16","25","25","ସିଂତାର୍‍ବ ବେଲା ପାଉଲ୍‍ ଆରି ଶୀଲା ପାର୍‌ତନା ଡିଂଆର୍‍ଡିଂଗେ ଇସ୍‍ପର୍‍ନେ ମ୍ନିରେ ଅସ୍‍ମାର୍‍ ସାର୍‍ ଡିଂଆର୍‌ଗେ ଆରି କଏଦ୍‍ଇଂ ଆକେନ୍ ଅଁଡିଂଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_26","074_16_26","ACT","16","26","26","ମାରିଆଃତୁଗ୍‍ ମ୍ନା ବୁମିକମ୍ପ୍ ଡିଂକେ ଆରି ଜେଲ୍‌କାନାନେ ପାଣ୍ଡୁସନ୍ ବ୍ରି ଲାଜୁର୍‍ ବିକେ । ସାଙ୍ଗେ ସାଙ୍ଗେ ସର୍‍ତେ କାପାଟ୍‍ ରଃୱେଗେ ଆରି ସର୍‍ତେ ଜେଲ୍‌ଇଂନେ ସିକ୍ଲି ପଏଚଗ୍‍ ଲୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_27","074_16_27","ACT","16","27","27","କଇଦ୍‍ ଜାଗୁଆଲ୍‍ଇଂ ମ୍ବ୍ରିଆଚେ ତଡ଼ିଆଆର୍କେ ଆରି କଏଦ୍‍ ଡୁଆନେ କାପାଟ୍‍ ସର୍‍ତେ ରଃକ୍ନେ କେଚେ ବାବେଆର୍କେ ଜେ କଏଦ୍ଇଂ ଡଆର୍‍ଗେ; ତେନ୍‍ସା ମେଁ ମେଇଂନେ କାଣ୍ଡା ଆତାର୍‍ଚେ ଗୁଏଃ ନ୍‌ସା ଆରାମ୍‍ ଡିଂଆର୍‍ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_28","074_16_28","ACT","16","28","28","ମାତର୍‍ ପାଉଲ୍‍ ଜବର୍‍ ୱାସାର୍‍ଚେ ବାଲିର୍‍କେ “ପେ ମେଃଡିଗ୍‍ କେତି ଆଡିଂଗେପା । ନେ ସର୍‍ତେରେ ଆକ୍‍କେ ନେଲେଃକେ !” ");
INSERT INTO gaq_vpl VALUES ("AC16_29","074_16_29","ACT","16","29","29","କଏଦ୍‍ ଜାଗୁଆଲ୍‍ଇଂ କୁପିସ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଆର୍କେ ଆରି ବିତ୍‍ରେ ୱିର୍‍ଗାଚେ ବୁଟ ବୁଟଚେ ପାଉଲ୍‍ ଆରି ଶୀଲା ଞ୍ଚ ଆଲ ଲଃୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_30","074_16_30","ACT","16","30","30","ତେନ୍‍ ଇଡ଼ିଙ୍ଗ୍‌ ଆମେଇଂକେ ବାଏରେ ୱା ଡୁଂତାର୍‍ଚେ ସାଲିଆକୁଆର୍କେ, “ମାପ୍‌ରୁଇଂ ! ଉଦାର୍‍ ବାନ୍‍ସା ଆନେକେ ମେଃ ଡିଂ ପଡ଼େଏ ?” ");
INSERT INTO gaq_vpl VALUES ("AC16_31","074_16_31","ACT","16","31","31","ମେଇଂ ବାଲିର୍‍କେ “ମାପ୍‌ରୁ ଜିସୁକେ ବିସ୍‍ବାସ୍‍ ପେଡିଂଲା ପେନେ ଡୁଆଣ୍ଡ୍ରେ ସର୍‍ତେରେ ଉଦାର୍‍ ପେବାଏ” ");
INSERT INTO gaq_vpl VALUES ("AC16_32","074_16_32","ACT","16","32","32","ତେନ୍‍ ଇଡ଼ିଙ୍ଗ୍‌ ମେଇଂ ଆମେଇଂକେ ଆରି ମେଇଂ ଡୁଆନେ ବିନ୍‍ ସର୍‍ତେରେକେ ମାପ୍‌ରୁନେ ସାମୁଆଁ ବାଲିର୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_33","074_16_33","ACT","16","33","33","ମିଡିଗ୍‍ନେ ଆତେନ୍‌‍ ବେଲା କଏଦ୍‍ ଜାଗୁଆଲ୍‍ ଆମେଇଂକେ ଡୁଙ୍ଗ୍‍ୱେଚେ ମେଇଂନେ ଚିନାବାନା ସର୍‍ତେ ଚୁ ବିଆର୍‌କେ ବାରି ଡୁଆଣ୍ଡ୍ରେ ସର୍‍ତେରେ ଆତେନ୍‌‍ ବେଲା ଡୁବନ୍‌ ଡୁଂଡଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_34","074_16_34","ACT","16","34","34","ଆତେନ୍‌‍ ଇଡ଼ିଙ୍ଗ୍‌ ମେଁ ପାଉଲ୍‍ ଆରି ଶୀଲାକେ ମେଇଂ ଡୁଆ ୱା ଡୁଙ୍ଗ୍‍ୱିଗ୍‍ଚେ ଚଂନେ ବିଆର୍‌କେ । ଇସ୍‍ପର୍‍କେ ବିସ୍‍ବାସ୍‍ ଡିଂଲେଃକ୍ନେ ନ୍‍ସା ମେଁ ଆରି ମେଇଂ ଡୁଆନେ ସର୍‍ତେରେ ଜିବନ୍‍ ବିତ୍‍ରେ ସାର୍‍ଦା ଡିଂଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_35","074_16_35","ACT","16","35","35","ମାର୍‍ତଡ଼େ ଞ୍ଜିର୍‍ ରୋମୀୟ ନେତା ଚେଲାଇଂକେ ଆକେନ୍‍ ଆଦେସ୍‍ ବିଚେ ବେଆର୍କେ “ଆତେନ୍‌‍ ରେମୁଆଁଇଂକେ ଆନ୍ତାର୍‍ବିପା ।” ");
INSERT INTO gaq_vpl VALUES ("AC16_36","074_16_36","ACT","16","36","36","ତେନ୍‍ସା କଏଦ୍‍ ଜାଗୁଆଲ୍‍ ପାଉଲ୍‍କେ ବାଲିର୍‍କେ “ମ୍ନା ନେତା ଆନାକେ ଆରି ଶୀଲାକେ ଆନ୍ତାର୍‍ ବିନ୍‍ସା ବାଲିର୍‍ ବେବକେ । ଏନ୍‍ବେଲା ପେ ସାନ୍ତିରେ ଆକ୍‍ବାନ୍‍ ୱିଗ୍‍ ପେୟାଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC16_37","074_16_37","ACT","16","37","37","ତେଲା ପାଉଲ୍‍ ସନ୍ୟଇଂକେ ବାଲିର୍‍କେ “ମେଃଡିଗ୍‍ ବୁଲ୍ ଡିଂନେବଲା ଡିଗ୍‍ ମେଇଂ ରେମୁଆଁଇଂ ନ୍ତୁଗ୍‍ ଆନେକେ ବଗ୍‍କେ । ନେ ରୋମୀୟ ରେମୁଆଁ ଏଲେଣ୍ଡିଗ୍‍ ମେଇଂ ଆନେକେ ଗାଗ୍‍ ଆର୍କେ । ଅଃକେନ୍‍ ବେଲା ମେଇଂ ଆନେକେ ବୁଡ଼ିଚେ ଆନ୍ତାର୍‍ ବିନ୍‍ସା ଚାଏଁ ଡିଂଆର୍କେ । ନେ ଆକେନ୍‍ ଆଡିଂନେ ନେବିକେ ଣ୍ଡୁ । ରୋମୀୟ ନେତା ନିଜେ ଆକ୍‍କେ ପାଙ୍ଗ୍‍ଚେ ଆନେକେ ଆନ୍ତାର୍‍ ବିଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC16_38","074_16_38","ACT","16","38","38","ସନ୍ୟଇଂ ରୋମୀୟ ନେତାଇଂକେ ଆକେନ୍‍ ସାମୁଆଁ ବାଲିର୍‍ଆର୍କେ । ପାଉଲ୍‍ ଆରି ଶୀଲା ରୋମୀୟ ରେମୁଆଁ ଡାଗ୍‍ଚେ ଅଁଚେ ମେଁଇଂ ବୁଟମେଗ୍ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_39","074_16_39","ACT","16","39","39","ତେନ୍‍ ଇଡ଼ିଙ୍ଗ୍‍ ୱେଚେ ମେଇଂ ଡାଗ୍ରା ଗୁଆରି ଡିଙ୍ଗ୍‌ ଆର୍କେ ଆରି ମେଇଂକେ କଏଦ୍‍ ଡୁଆବାନ୍‍ ଆନ୍ତାର୍‍ଚେ ସହର ଆନ୍ତାର୍‍ ଡଲାପା ଡାଗ୍‍ଚେ ବାଲିର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC16_40","074_16_40","ACT","16","40","40","ପାଉଲ୍‍ ଆରି ଶୀଲା କଏଦ୍‍ ଡୁଆ ଆନ୍ତାର୍‍ଚେ ଲୁଦିଆନେ ଡୁଆ ୱେଆର୍କେ । ଆତ୍‍ତେ ମେଇଂ ବୟାଁଇଂ ଏତେ କୁଡ଼େଆର୍କେ ଆରି ମେଇଂକେ ସାର୍‌ଦା ଆଡିଂଚେ ଆତେନ୍‌‍ ଟାନ୍ ଆନ୍ତାର୍‍ଚେ ଲାଗ୍‌ଡଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_1","074_17_1","ACT","17","1","1","ପାଉଲ୍‍ ଆରି ଶୀଲା ଆମ୍ପିପଲି ଆରି ଆପଲ୍ଲୋନ୍ନିଆ ଗାଲି ବିଚେ ଥେସଲନିକୀକେ ପିଙ୍ଗ୍‍ଚା ଆର୍କେ । ଆତ୍‍ଅରିଆ ଜିଉଦିଇଂନେ ମୁଇଂ ପାର୍‌ତନା ଡୁଆଇଂ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_2","074_17_2","ACT","17","2","2","ପାଉଲ୍‍ ମେଇଂ ନିୟମ୍‍ ଅନୁସାରେ ମେଇଂନେ ଡାଗ୍ରା ୱେକେ ବାରି ଞ୍ଜିକ୍ଲିଗ୍‌ ସାନ୍ତା କାଲା ଜାକ ଦରମ୍‌ ସାସ୍ତର୍‌ନେ ବ୍ନାଲିର୍‌ ସାଚେ ଆମେଇଂକେ ଆଦେସ୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_3","074_17_3","ACT","17","3","3","ଦରମ୍‍ ସାସ୍ତର୍‌ ଗୁଆର୍‍ଚେ ଆରି ଆଃବୁଜେଚେ ପର୍‌ମାନ୍‍ ଡିଂକେ ଜେ କିସ୍‌ଟନେ ଦୁକ୍‌ବାନେ ଆରି ଗୁଏଚେ ତଡ଼ିଆନେ ଦର୍‌କାର୍ ଲେଃଗେ । ପାଉଲ୍‍ ବାଲିର୍‍କେ “ମୁଡ଼ି ଜିସୁନେ ସାମୁଆଁ ନେଙ୍ଗ୍‍ ବାଲିର୍‍ ଣ୍ଡିଂକେ ମେଁ ଆତେନ୍‌‍ ମସିହ ।” ");
INSERT INTO gaq_vpl VALUES ("AC17_4","074_17_4","ACT","17","4","4","ମେଇଂ ବିତ୍‍ରେ ଉଡ଼ିରୁଆ ଆକେନ୍‍ ଆବୁଜେଚେ ରାସିଙ୍ଗ୍‌ଚେ ପାଉଲ୍‍ ଆରି ଶୀଲାଇଂ ଏତେ କୁଡ଼େଆର୍କେ; ଡେତୁଆ ସତ୍‍ ପରମେସର୍‍କେ ପାର୍‌ତନା ଡିଂଆର୍‍ଡିଂକ୍ନେ ଗୁଲେ ଗ୍ରୀକ୍‌ ରେମୁଆଁ ବାରି ଗୁଲେ ନିମାଣ୍ଡା ସେଲାମ୍ବୁଏଃଇଂ ଡିଗ୍‍ ମେଇଂ ଏତେ ମିସୁଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_5","074_17_5","ACT","17","5","5","ଏଲେଡିଗ୍‍ ଜିଉଦିଇଂ ଇଂସା ଡିଂଆର୍କେ ଆରି ଉଡ଼ିରୁଆ ଦଦ୍ୟା‍ ରକମ୍‍ନେ ରେମୁଆଁଇଂକେ ରାସିଂଚେ ସର୍‍ତେ ଇନିପାକା ଆଅଁ ବିଆର୍‌କେ । ମେଇଂ ପାଉଲ୍ ଆରି ଶୀଲାକେ ତୁର୍‍ଚେ ରେମୁଆଁଇଂ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ ନ୍‍ସା ଜେସନ୍‍ ତେମ୍ନିକ୍ନେ ମୁଇଂ ରେମୁଆଁ ଡୁଆକେ ଗେରେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_6","074_17_6","ACT","17","6","6","ଏଲେଣ୍ଡିଗ୍‍ ଆତ୍‍ଅରିଆ ପାଉଲ୍ ଆରି ଶୀଲାକେ ମାଅବାଚେ ମେଇଂ ଜେସନ୍‍ ଆରି ବିନ୍‍ ଉଡ଼ିରୁଆ ବୟାଁଇଂକେ ଇନିବାନ୍‍ ଇନିନେ ନେତାଇଂ ଡାଗ୍ରା ଗୁ ଡୁଙ୍ଗ୍‍ୱେଚେ ୱାସାର୍‍ଚେ ବାଲିର୍‍ଆର୍କେ “ଏନ୍‍ ରେମୁଆଁଇଂ କ୍ଲିଗ୍‍ ମଞ୍ଚ୍‌ପୁର୍‌କେ ଉଲ୍‍ଟା ପାଲ୍‍ଟା ଆଃଡିଂଆର୍‍ଡିଂକେ ! ଏବେ ଆକ୍‍ମେଇଂ ନେଁ ଇନି ପାଙ୍ଗ୍‍ଲେଃ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_7","074_17_7","ACT","17","7","7","ଜେସନ୍‍ ଆମେଇଂକେ ମେଁ ଡୁଆ ବକେ । ଜିସୁନେ ମ୍ନିରେ ଆର୍‍ମୁଇଂଜା ଇଃସାଙ୍ଗ୍‌ ଲେଃକେ ଡାଗ୍‍ଚେ ବାଲିର୍‍ଚେ ମେଇଂ କାଇସରନେ ସର୍‍ତେ ନିଅମ୍‍ ମାନେଃ ଆଡିଂଆର୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC17_8","074_17_8","ACT","17","8","8","ଆକେନ୍‍ ସାମୁଆଁ ବାଲିର୍‍ଚେ ମେଇଂ ରେମୁଆଁକେ ଆରି ଇନି ନେତାଇଂ ବିତ୍‍ରେ ଜବର୍‍ ୱିଙ୍ଗ୍‍ଆଁରିଙ୍ଗ୍‌ଆ ତାର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_9","074_17_9","ACT","17","9","9","ଇନି ନେତାଇଂ ଜେସନ୍‍ ଆରି ବିସ୍‍ବାସିଇଂବାନ୍‍ ଡାବୁ ଡୁଙ୍ଗ୍‍ୱିଗ୍‍ଚେ ଆମେଇଂକେ ଜାମିନ୍‌ରେ ଆନ୍ତାର୍‍ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_10","074_17_10","ACT","17","10","10","ମିଡିଗ୍‌କ୍ନେ ଦାପ୍ରେ ବୟାଁଇଂ ପାଉଲ୍ ଆରି ଶୀଲାକେ ବେରିଆ ପାକା ବେବିଆର୍କେ । ମେଇଂ ଆତ୍‍ଅରିଆ ୱେଚାଚେ ଜିଉଦିଇଂନେ ପାର୍‌ତନା ଡୁଆ ଡାଗ୍ରା ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_11","074_17_11","ACT","17","11","11","ଥେସଲନିକୀନେ ରେମୁଆଁଇଂକେ ବାଦୁଲ୍‍ରେ ଆତ୍‍ନେ ରେମୁଆଁଇଂ ଜବର୍‍ ଦୟାବାନ୍‍ଣ୍ଡ୍ରେ ଲେଃଆର୍‍ଗେ । ମେଇଂ ଜବର୍‍ ସାର୍‍ଦାରେ ସିସ୍‍ଇଂନେ ପ୍ରସ୍‌ନ ଅଁଆର୍କେ ଆରି ପାଉଲ୍‍ନେ ସତ୍‍ ବ୍ନାଲିର୍‍ ମେଃନେ ଆତେନ୍‌‍ ମ୍ୟାନ୍‍ସା ଦିନ୍‍କେ ଦରମ୍‌ ସାସ୍ତର୍‌ ଲଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_12","074_17_12","ACT","17","12","12","ମେଇଂ ବିତ୍‍ରେ ଜବର୍‍ ବିସ୍‍ବାସ୍‍ ଡିଂଆର୍କେ । ଗୁଲେରେ ସମ୍ରାନ୍ତ ଗ୍ରୀକ୍‌ ସେଲାମ୍ୱୁଏଇଂ ଆରି ଙ୍ଗିର୍‌ବଏଃ ରେମୁଆଁଇଂ ଡିଗ୍‍ ବିସ୍‍ବାସ୍‍ ଡିଂଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_13","074_17_13","ACT","17","13","13","ଏଲେଣ୍ଡିଗ୍ ଉଡ଼ିବେଲା ଥେସଲନିକୀ ଜିଉଦିଇଂ ମ୍ୟାଃଆର୍କେ ଜେ ବେରିଆ ନ୍ତୁଗ୍‍ ଣ୍ଡିଗ୍‍ ପାଉଲ୍‍ ଇସ୍‍ପର୍‍ନେ ସାମୁଆଁ ବାଲିର୍‍ ଡିଂଆର୍‍କେ ମେଇଂ ଆତ୍‍ତେ ପାଙ୍ଗ୍‍ଚେ ୱିଙ୍ଗ୍‍ଆନେ ନ୍‍ସା ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_14","074_17_14","ACT","17","14","14","ଅଃତେନ୍‌ ବେଲା ବୟାଁଇଂ ପାଉଲ୍‍ଇଂକେ କେଣ୍ଡିଆ ଡାଗ୍ରା ବେବିଆର୍କେ; ମାତର୍ ଶୀଲା ଆରି ତିମତି ମ୍ୱାୟା ବେରିଆନ୍ତୁଗ୍‍ ଲେଃୱେଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_15","074_17_15","ACT","17","15","15","ପାଉଲ୍‍ଇଂକେ ଡୁଙ୍ଗ୍‍ୱେକ୍ନେ ରେମୁଆଁଇଂ ମେଁ ଏତେ ଆଥେନ୍‌ସ୍ ଜାକ ୱେଆର୍କେ । ଆତ୍‍ବାନ୍‍ ମେଇଂ ବେରିଆ ପାକା ଆଣ୍ଡେଚେ ଶୀଲା ଆରି ତିମତିଇଂକେ ବାଲିର୍‍ଆର୍କେ ମେଇଂ ଗିଆ ପାଉଲ୍‍ଇଂ ଏତେ ମିସୁ ବିଃପା ଡାଗ୍‍ଚେ ପାଉଲ୍‍ ଆଦେସ୍‌ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_16","074_17_16","ACT","17","16","16","ଆଥେନ୍‌ସ୍‌ନ୍ନିଆ ଶୀଲା ଆରି ତିମତିଇଂକେ ଉର୍‍ ଲେଃକ୍ନେ ବେଲା ଇନିନ୍ନିଆ ସଇତାନ୍‍ ମୁର୍‍ତିରେ ବର୍‍ତି ଡିଂଲେଃକ୍ନେ ପାଉଲ୍‍ କେଚେ ଜାବର୍‌ ଆତ୍ମାନ୍ନିଆ ଗାବ୍‌ରା ଡିଂୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_17","074_17_17","ACT","17","17","17","ତେନ୍‍ସା ମେଁ ପାର୍‌ତନା ଡୁଆ ନ୍ତୁଗ୍‍ ଜିଉଦିଇଂ ଏତେ ଇସ୍‍ପର୍‍ନେ ପାର୍‌ତନା ଡିଂଣ୍ଡ୍ରେ ଅଣଜିଉଦି‍ଇଂ ଏତେ ଆକେନ୍‍ ସାମୁଆଁ ଦିନ୍‍କେ ଅବାଲିର୍‍ ଆର୍କେ । ସହର୍‌ନେ ଚକ୍‍ଇଂ ଡାଗ୍ରା ୱେୱିଗ୍‍ ଡିଂଆର୍‌ଡିଂକ୍ନେ ରେମୁଆଁଇଂ ଏତେ ଆତେନ୍‌‍ ସାମୁଆଁ ଅବାଲିର୍‍ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_18","074_17_18","ACT","17","18","18","ଉଡ଼ିରୁଆ “ଏପିକ୍ୟୁରିଆନ୍ ଆରି ସ୍ତୋୟିକ୍” ପାଟ୍‍ ଗୁରୁଇଂ ଏତେ ମେଇଂନେ ଜୁକ୍ତାଜୁକ୍ତି ଡିଂଆର୍କେ । ମେଇଂ ବିତ୍‍ରେ ଉଡ଼ିରୁଆ ବାଲିର୍‍ଆର୍କେ “ଆକେନ୍‍ ନିର୍ବୁଦି ରେମୁଆଁ ମେଁନେ ବାଲିର୍‍ନେ ନ୍‌ସା ଚେସ୍‌ଟା ଡିଂଡିଂକେ ?” ବିନ୍‍ଣ୍ଡ୍ରେ ବାଲିର୍‍ଆର୍କେ “ବିଦେସ୍‍ନେ ଦେବ୍‍ତାଇଂନେ ବିସୟ୍‍ରେ ମେଁ ବାସଙ୍ଗ୍‌‌ ଡିଂନେ ସୁଗୁଆ ଜାନା ପଡ଼େଡିଂକେ ।” ଜିସୁ ଆରି ମେଁନେ ଗୁଏଃଚେ ତଃଡ଼୍ୟାଃକ୍ନେ ବିସୟ୍‍ରେ ପାଉଲ୍‍ ପର୍‌ଚାର୍ ଡିଂଡିଂକ୍ନେ ଅଁଚେ ମେଇଂ ଦେକ୍‍ ବାସଙ୍ଗ୍‍ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_19","074_17_19","ACT","17","19","19","ତେନ୍‍ସା ମେଇଂ ପାଉଲ୍‍ଇଂକେ ସା ଡୁଙ୍ଗ୍‍ୱେଆର୍କେ ଆରି ଆମେଇଂକେ ଏରିୟପାଗସ୍‍ ମ୍ନିକ୍ନେ ଇନି କୁକପାର୍‌ନ୍ତୁଗ୍‍ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ବାଲିର୍‍ଆର୍କେ “ପେ ଆଣ୍ଡିନେ ତ୍ମି ଗ୍ୟାନ୍‌ ନ୍‍ସା ବାଲିର୍‍ ପେଡିଙ୍ଗ୍‍କେ ତେନ୍‍ ସାମୁଆଁ ନେ ଣ୍ଡିଙ୍ଗ୍‍ ନେମ୍ୟାଏ । ");
INSERT INTO gaq_vpl VALUES ("AC17_20","074_17_20","ACT","17","20","20","ନା ବାଲିର୍‍ ନାଡିଂକ୍ନେ ଉଡ଼ି ସାମୁଆଁ ଆନେକେ କାବା ଲାଗେଡିଂକେ । ନେ ଆତେନ୍‌‍ ଅର୍ତ ମ୍ୟାନେ ଚାଏଁନେଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC17_21","074_17_21","ACT","17","21","21","ଆଥେନ୍‌ସ୍‌ନେ ରେମୁଆଁଇଂ ଆରି ଆତ୍‍ତେ ଲେଃଡିଂକ୍ନେ ବିଦେସୀଇଂ ତ୍ମି ସାମୁଆଁ ଅଁନ୍‍ସା ଆରି ବାଲିର୍‍ନ୍‌ସା ମାଣ୍ଡା ବଲ୍‍ବା ଡିଂଆର୍‌ଗେ । ଆକ୍‍କେ ମେଇଂ ଗୁଲୁଏ ପର୍ ଲେଃଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_22","074_17_22","ACT","17","22","22","ପାଉଲ୍‍ ଆରିୟପାଗସ୍‍ ସବା ସାମ୍‍ନେ ତୁଆଁଚେ ବାଲିର୍‍କେ “ଆଥେନ୍‌ସ୍‌ନେ ରେମୁଆଁଇଂ ପେ ସର୍‍ତେରେ ସାପା ଦରମ୍‍ କରମ୍‌ନ୍ନିଆ ଦରମ୍ ପେଲେଃକେ ଡାଗ୍‌ଚେ ନେ ଏତେ ନେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_23","074_17_23","ACT","17","23","23","ନେଙ୍ଗ୍‍ ପେନେ ଇନି ଅଲେଙ୍ଗ୍‍ ୱେବେଲା ପେନେ ପୁଜା ଜିନିସ୍ ଙ୍କେକେ ।” ମୁଇଂ ଜଗ୍ୟ ବେଦି ଆଡ଼ାତ୍ରା ଗୁଆର୍‍ବକ୍ନେ ମୁଇଂ ଇସ୍‍ପର୍‍ ଆଜାକେ ନେ ନେମ୍ୟାକେ ଣ୍ଡୁ ତେସା ପେ ମାମ୍ୟାଚେ ଆଜାକେ ପୁଜା ଡିଂ ପେଡିଂକେ ନେଙ୍ଗ୍‍ ମେଁନେ ସାମୁଆଁ ପେ ଡାଗ୍ରା ବାଲିର୍‍ଣ୍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_24","074_17_24","ACT","17","24","24","ଇସ୍‍ପର୍‍ ମଞ୍ଚ୍‌ପୁର୍‌ ଆରି ଆତ୍‍ଅରିଆ ଲେଃକ୍ନେ ସର୍‍ତେ ସାମୁଆଁ ଆଃରେକେ । ମେଁ କିତଂଇନି ଆରି ମଞ୍ଚ୍‌ପୁର୍‌ନେ ମାପ୍‌ରୁ । ରେମୁଆଁ ନ୍ତିରେ ଆଃରେକ୍ନେ ମନ୍ଦିର୍‍ଇଂ ଡାଗ୍ରା ମେଁ ଆଲେଃ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC17_25","074_17_25","ACT","17","25","25","ନେ ମେଇଂ ନ୍‍ସା ସ୍ଲେଚେ ଆମେଇଂକେ ବିଃ ୟାକେ ସୁଗୁଆ ମେଃଣ୍ଡିଗ୍‍ ସାମୁଆଁ ଆଚାଏଁ ଣ୍ଡୁ; ମାତର୍‍ ମେଁ ସର୍‍ତେରେ ଜିବନ୍‍, ଜିବନ୍‍ୱେଡ଼ିଆ ଆରି ସର୍‍ତେ ଦର୍‍କାର୍‍ନେ ବିସୟ୍ ବିବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_26","074_17_26","ACT","17","26","26","ମୁଇଂ ରେମୁଆଁବାନ୍‍ ମେଁ ସର୍‍ତେ ରେମୁଆଁ ବଂସକେ ଆଃରେବକେ ଆରି ମେଁନେ ସାମୁଆଁରେ ମେଇଂ ମଞ୍ଚ୍‌ପୁର୍‌ନେ ସର୍‍ତେ ଟାନ୍‍ନ୍ତୁଗ୍‍ ଲେଃଡିଂକେ । ଉଡ଼ିବେଲା ଜାଣ୍ଡେ ଆଣ୍ଡିଡାଗ୍ରା ଲେଃଏ ମୁଲେବାନ୍‍ ଇସ୍‍ପର୍‍ ଆତେନ୍‌‍ ତିଆର୍ ଡିଂବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_27","074_17_27","ACT","17","27","27","ମେଁନେ ଉଦେସ୍ ଲେଃଗେ ସାପାରେ ଡିଡିକି ଆମେକେ ତୁର୍‍ଚେ ଅବାଆର୍‍ଏ । ଏଲେଡିଗ୍‍ ବାସଙ୍ଗ୍‍ନେ ୱେଲା ଇସ୍‍ପର୍‍ ଜା ଡାଗ୍ରାବାନ୍‍ ଡିଗ୍‍ ସ୍ଲ ଆୱେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC17_28","074_17_28","ACT","17","28","28","ଡାଗ୍ଲା ନେ ମେଁ ଏତେ ଲେଃନେଡିଂକେ ମେଁ ଏତେ ଅଲେଙ୍ଗ୍‍ ନେଡିଂକେ ବାରି ମେଁ ଡାଗ୍ରା ନେଁନେ ଞ୍ଚିୟା ଲେଃକେ । ପେ ବିତ୍‍ରେବାନ୍‍ ଉଡ଼ିରୁଆ ଗୁଆର୍‍ରେ ଡିଗ୍‍ ଆକେନ୍‍ ବାଲିର୍‍ବକେ ଜେ “ନେ ଣ୍ଡିଗ୍‍ ମେଇଂନେ ଉଙ୍ଗ୍‍ଡେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC17_29","074_17_29","ACT","17","29","29","“ନେ ଇସ୍‍ପର୍‍ନେ ଉଂ ଡିଂନେଲେଃକେ ସା ରେମୁଆଁଇଂନେ କୁଲିବୁତିନ୍‍ସା ଆଃରେକ୍ନେ ମୁର୍‍ତି ଡାଗ୍‍ଚେ ବାବେ ଣ୍ଡୁ ବାରି ସୁନା ଡାବୁ କି ରୁପା ଡାବୁ କି ମୁଲ୍ୟବାନ୍ ବ୍ରି ସୁଗୁଆ ବୁଜେନେ ନେନେ ଟିକ୍ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC17_30","074_17_30","ACT","17","30","30","ରେମୁଆଁଇଂ ଇସ୍‍ପର୍‍କେ ଆମ୍ୟାକ୍ନେ ବେଲା ମେଁ ଦସ୍‍ ସା ଆବଗେ ଣ୍ଡୁ ଏଲେଣ୍ଡିଗ୍‍ ଏବେ ମେଁ ସର୍‍ତେ ପାକା ସର୍‍ତେରେକେ ମେଇଂନେ ପାପ୍‍ ଗାଲିବାନ୍‍ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ନ୍‍ସା ବାଲିର୍‍ ଡିଂଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_31","074_17_31","ACT","17","31","31","ମେଁ ମେସୁଆ ଆଃରେବକେ । ତେନ୍‍ କାଲା ମେଇଂନେ ସ୍ରିବ୍ନ ରେମୁଆଁଇଂ ଏତେ ସର୍‍ତେ ଦର୍‌ତନି ନ୍ୟାୟ୍‍ ବିଚାର୍‌ ଡିଂଏ । ତେନ୍‍ ରେମୁଆଁଇଂ ଗୁଏକ୍ନେବାନ୍ ଆଃତଡ଼ିଆକ୍ନେ ନ୍‍ସା ମେଁ ଆକେନ୍‍ ସାମୁଆଁନେ ସତ୍‌ ସାପାରେକେ ସାକି ବିଃବ‍ଆର୍‌କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC17_32","074_17_32","ACT","17","32","32","ପାଉଲ୍‍ବାନ୍‍ ଗୁଏଚେ ତଃଡ଼ିଆକ୍ନେବାନ୍‍ ତଡ଼୍ୟାକ୍ନେ ସାମୁଆଁ ଅଁଚେ ମେଇଂ ବିତ୍‍ରେ ଉଡ଼ିରୁଆ ଆମେଇଂକେ ଲୁଆଃଆର୍କେ, ଏଲେଡିଗ୍ ବିନ୍‍ ରେମୁଆଁ ବାଲିର୍‍କେ “ନାବାନ୍‍ ଆକେନ୍‍ ସାମୁଆଁକେ ନେ ବାରି ମୁଇଂତର୍‍ ଅଁନେ ଚାଏଁନେଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC17_33","074_17_33","ACT","17","33","33","ଦେତ୍‌ରକମ୍ ପାଉଲ୍ କୁକପାର୍‍ବାନ୍ ତାର୍ ଲାଗ୍‍ଡଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC17_34","074_17_34","ACT","17","34","34","ଡାୟୋନିସିଅସ୍‍ ମ୍ନିକ୍ନେ ଇନି କପାର୍‍ନେ ମୁଇଂ ରେମୁଆଁ ଦାମାରୀ ନାମ୍ନି ମୁଇଂ ସେଲାମ୍ବୁଏଃ ଆରି ଉଡ଼ିରୁଆ ବିସ୍‍ବାସ୍‍ ଡିଂଆର୍କେ ଆରି ମେଇଂ ଏତେ ମିସୁ ବିଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_1","074_18_1","ACT","18","1","1","ଆକେନ୍‍ ଇଡ଼ିଂ ପାଉଲ୍‍ ଆଥେନ୍‌ସ୍ ଆନ୍ତାର୍‍ଚେ କରିନ୍ଥ ପାକା ଲାଗ୍‍ଡଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_2","074_18_2","ACT","18","2","2","ଆତ୍‍ତେ ମେଁ ପନ୍ତସ୍‌ନ୍ନିଆ ଣ୍ଡିଆ କୁମାକ୍ନେ ବେଲା ଆକ୍ୱିଲା ତେମ୍ନିକ୍ନେ ମୁଇଂ ଜିଉଦିକେ କୁଡ଼େକେ ଇଃସାଙ୍ଗ୍‌ କ୍ଲଡିୟସ୍‍ ସର୍‍ତେ ଜିଉଦିଇଂକେ ରୋମ୍‍ ଆନ୍ତାର୍‍ନ୍‍ସା ବାଲିର୍‍ ବକ୍ନେନ୍‍ସା ମେଁ ଉଃଡ଼ି ଦିନ୍‍ ଆଲ ମେଁନେ କୁନେଃଡ଼େ ପ୍ରିସ୍କା ଏତେ ଇଟାଲୀବାନ୍‍ ପାଙ୍ଗ୍‍ଲେଃଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_3","074_18_3","ACT","18","3","3","ପାଉଲ୍‍ ଆମେଇଂକେ ଆସୁଏନ୍‍ସା ୱେଚେ ମେଇଂ ଏତେ ଲେଃୱେଆର୍‍କେ, ତେନ୍‍ସା ମେଃଣ୍ଡିଗ୍‍ ମେଇଂ ସୁଗା କୁଡ଼ିଆ ଆଃରେଚେ ବ୍ରୁଆ ଲେଃଡିଂଆର୍‍କେ । ଡାଗ୍ଲା ମେଇଂ ତମ୍ବୁ ଆରେଣ୍ଡ୍ରେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_4","074_18_4","ACT","18","4","4","ଜିଉଦି ବାରି ଗ୍ରୀକ୍‌ ରେମୁଆଁଇଂନେ ମନ୍‍କେ ମାପ୍‌ରୁ ଡାଗ୍ରା ବିସ୍‍ବାସ୍‍ ଆଡିଙ୍ଗ୍‍ଆର୍‍କ୍ନେ ନ୍‍ସା ସର୍‍ତେ ସାନ୍ତା କାଲା ମେଁ ପାର୍‌ତନା ଡୁଆନ୍ତୁଗ୍‍ ବାଲିର୍‌ ବାତା ଡିଂଆର୍‍ ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_5","074_18_5","ACT","18","5","5","ଶୀଲା ଆରି ତିମତି ମାସିଦୋନିଆବାନ୍‍ ୱିଗ୍‍କ୍ନେ ଇଡ଼ିଂ ପାଉଲ୍‍ ଜିଉଦିଇଂ ଡାଗ୍ରା ଜିସୁନେ ମାଣ୍ଡା ସାମୁଆଁ ବାଲିର୍‌ ନ୍‌ସା ଜବର୍‍ ଦିନ୍‍ ଲେଃଗେ । ବାରି ମେଁ ଜିସୁକେ କିସ୍‌ଟ ଡାଗ୍‍ଚେ ସାକି ବିଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_6","074_18_6","ACT","18","6","6","ଏଲେଣ୍ଡିଗ୍‍ ମେଇଂ ଉଡ଼ିବେଲା ଆମେଇଂକେ କସ୍‍ଟ ବିଃଆର୍‍କେ ଆରି ନାନା ରକମ୍‍ନେ ସାମୁଆଁ ବାଲିର୍‍ ଆର୍‍କେ ଗିତେନ୍‍ ବିରୁଦ୍‍ରେ ପାଉଲ୍‍ ନିଜେନେ ସକା ତାଣ୍ଡିଚେ ମେଁ ବାଲିର୍‍କେ “ଜଦି ପେ ନାସେ ପେୱେଏ ତେଲା ଆକେନ୍‍ ନେଂନେ ଦସ୍ ଣ୍ଡୁ । ନେଙ୍ଗ୍‍ ସାପା ଚେସ୍‍ଟା ଡିଂ ଆଡାମ୍ୱକେ । ନେଙ୍ଗ୍‍ ଏବାନ୍‍ ଅଣଜିଉଦିଇଂନେ ଡାଗ୍ରା ୱେଣ୍ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC18_7","074_18_7","ACT","18","7","7","ତେନ୍‍ସା ମେଁ ଆମେଇଂକେ ଆନ୍ତାର୍‍ଚେ ଇସ୍‍ପର୍‍ନେ ପାର୍‌ତନା ଡିଂମ୍ୟାଃକ୍ନେ ତିତସ୍‍ ଯୁସ୍ତ ତେମ୍ନିକ୍ନେ ମୁଇଂ ଅଣଜିଉଦିଇଂନେ ଡୁଆ ଲେଃୱେଆର୍‍ଗେ । ଯୁସ୍ତଇଂ ଡୁଆ ଇନି ପାର୍‌ତନା ଡୁଆ ଡାଗ୍ରା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_8","074_18_8","ACT","18","8","8","ପାର୍‌ତନା ଡୁଆନେ ମ୍ନାନେତା କ୍ରିସ୍‌ପସ୍ ଆରି ମେଇଂନେ ଡୁଆଣ୍ଡ୍ରେ ସର୍‍ତେରେ ମାପ୍‌ରୁ ଡାଗ୍ରା ବିସ୍‍ବାସ୍‍ ଡିଂ ଆର୍କେ ଆରି କରିନ୍ଥନେ ଆରି ଉଡ଼ିରୁଆ ପାଉଲ୍‍ନେ ଗ୍ୟାନ୍‌ ଅଁଚେ ବିସ୍‍ବାସ୍‍ ଡିଂଆର୍କେ ଆରି ଡୁବନ୍‌ ଡୁଂଡ ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_9","074_18_9","ACT","18","9","9","ମେଁସୁଆ ମିଡିଗ୍‍ ପାଉଲ୍‍ ମୁଇଂ ମୁଃସୁଡ଼ିଂ କେକେ ଜେ, ମୁସୁଡ଼ିଂନ୍ନିଆ ମାପ୍‌ରୁ ଆମେକେ ବାଲିର୍‍କେ, “ଆବ୍‍ଟଗେ, ବାଲିର୍‍ ବାସଙ୍ଗ୍‌ଲାଃଲା, ଆତ୍‍ବାନ୍‍ ବୁଂ ଆଲେଃଗେ ");
INSERT INTO gaq_vpl VALUES ("AC18_10","074_18_10","ACT","18","10","10","ଡାଗ୍‍ଲା ନେଙ୍ଗ୍‍ ପେ ଏତେ ନ୍‍ଲେଃକେ । ଜାଣ୍ଡେଡିଗ୍‍ ପେନେ କ୍ୟତି ଡିଂଆୟାଆର୍‍ ଣ୍ଡୁ, ଡାଗ୍‍ଲା ଆକେନ୍‍ ଇନିନ୍ନିଆ ନେଙ୍ଗ୍‍ନେ ଜବର୍‍ ରେମୁଆଁ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC18_11","074_18_11","ACT","18","11","11","ତେନ୍‍ସା ପାଉଲ୍‍ ଆତ୍‍ତେ ଇସ୍‍ପର୍‍ନେ ସାମୁଆଁ ବିସୟ୍‍ରେ ବୁଦି ବିଚେ ମେମୁଆଁ ଗୁ ଆର୍କେ ଲେଃଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_12","074_18_12","ACT","18","12","12","ଗାଲିୟୋ ଆଖାୟାନେ ରୋମୀୟ ସାସନ୍‌ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଲେଃକ୍ନେ ବେଲା ଜିଉଦିଇଂ ମୁଇଂତୁଗ୍‍ ରିସିଙ୍ଗ୍‍ଚେ ପାଉଲ୍‍କେ ସାଃଆର୍‍ଚେ ବିଚାର୍‌ ଡୁଆ ଡୁଙ୍ଗ୍‍ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_13","074_18_13","ACT","18","13","13","ମେଇଂ ବାଲିର୍‍କେ “ଆକେନ୍‍ ରେମୁଆଁନେ ନିୟମ୍‍ ବିରୁଦ୍‍ରେ ଇସ୍‍ପର୍‍ନେ ପାର୍‌ତନା ଡିଂନେନ୍‍ସା ରେମୁଆଁଇଂକେ ଆଃମ୍ୟାଃଡିଂଆର୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC18_14","074_18_14","ACT","18","14","14","ପାଉଲ୍‍ ମ୍ୱାଇର୍‍ଏ ଡାଗ୍‍କ୍ନେ ବେଲା ଗାଲିୟୋ ଜିଉଦିଇଂକେ ବାଲିର୍‍କେ, “ଜଦି ଆକ୍‍କେ ମେଃଡିଗ୍‍ ଦସ୍ ବା ଅପରାଦ୍‌ନେ ସାମୁଆଁ ଲେଃଏ, ତେଲା ନା ଆଡ଼ାତ୍ରା ବୁଂ ଲେଃଚେ ନା ସାମୁଆଁ ଅଁଚେ ବାଲିର୍‍ ବାତା ପାଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("AC18_15","074_18_15","ACT","18","15","15","ମାତର୍‍ ପେ ବିଦିନ୍ନିଆ ଗୁଆର୍‍ବକ୍ନେ ବ୍ନାଲିର୍‍ ଆରି ମ୍ନି ବିରୁଦ୍‌ରେ ଆକେନ୍‍ କିରମର ଡିଂଲେଃଗେସା ପେ ନିଜେ ନିଜେ ଆକ୍ମେନେ ସମାଦାନ୍‍ ଡିଂପା । ଏନ୍‍ ସାପା ବିସୟ୍‍ରେ ନେଙ୍ଗ୍‍ ମେଃଡିଗ୍‍ ବିଚାର୍‍ ନାଡିଂ ଣ୍ଡୁ ।” ");
INSERT INTO gaq_vpl VALUES ("AC18_16","074_18_16","ACT","18","16","16","ଅଃକେନ୍‍ ବାଲିର୍‍ଚେ ମେଁ ଆମେଇଂକେ ବିଚାର୍‌ ଡୁଆ ବେବିଃଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_17","074_18_17","ACT","18","17","17","ମେଇଂ ସର୍‌ତେରେ ପାର୍‌ତନା ଡୁଆନେ ମ୍ନାନେତା ସସ୍ଥିନାକେ ସାଚେ ବିଚାର୍‌ ଡୁଆ ଡାଗ୍ରା ବଗ୍‍ଆର୍‍କେ । ମାତର୍‍ ଗାଲିୟୋ ଅଃତେନ୍‍ ସାପା ସାମୁଆଁ ବିତ୍‍ରେ ମନ୍‌ ଆବିଃକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC18_18","074_18_18","ACT","18","18","18","ପାଉଲ୍‍ କରନ୍ଥିଅନେ ବୟାଁଇଂ ଏତେ ଗୁଲେଦିନା ବାସାକେ । ତେନ୍‌ ଇଡ଼ିଂ ଆମେଇଂକେ ଆନ୍ତାର୍‍ଚେ ପ୍ରିସ୍କା ବାରି ଆକ୍ୱିଲାଇଂ ଏତେ ସିରିଆ ପାକା ଣ୍ଡିଆ ଜା‍ଆଜ୍‌ନ୍ନିଆ ୱେଆର୍‍କେ । ସେଂକ୍ରିୟାବାନ୍‍ ଣ୍ଡିଆ ଗାଲି ବିଃଚେ ୱେନେ ବେଲା ମେଁନେ ନିୟମ୍‌ ଇସାବ୍‍ରେ ମେଁ ମେଁନେ ବାଆଃ ଆଃକୁଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_19","074_18_19","ACT","18","19","19","ମେଇଂ ଏଫିସିୟ ୱେଚାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ପାଉଲ୍‍ ପ୍ରିସ୍କିଲା ବାରି ଆକ୍ୱିଲାକେ ବେବିଃଆର୍‍କେ । ମେଁ ଆତ୍‍ଅରିଆନେ ପାର୍‌ତନା ଡୁଆ ଅରିଆ ୱେଚେ ଜିଉଦିଇଂ ଏତେ ଦର୍ମ ବିସୟ୍‍ରେ ବାଲିର୍‌ ବାତା ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_20","074_18_20","ACT","18","20","20","ରେମୁଆଁଇଂ ଆମେକେ ଆରି ଜାବର୍‌ ଦିନ୍‍ ଲେନ୍‍ସା ବାଲିର୍‌ ଆର୍‍କେ ମାତର୍‍ ମେଁ ରାଜି ଆଡିଂକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC18_21","074_18_21","ACT","18","21","21","ମେଁ ୱେକେଲା ବାଲିର୍‍କେ “ଜଦି ଇସ୍‍ପର୍‍ନେ ଇକ୍‌ଚା ଡିଂଏ, ତେଲା ନେଙ୍ଗ୍‍ ବାର୍‌ମୁଇଂତର୍‍ ପେ ଡାଗ୍ରା ମ୍ପାଙ୍ଗ୍‍ଏ ।” ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ଣ୍ଡିଆ ଗାଲି ବିଚେ ଏଫିସିୟବାନ୍‍ ତାର୍‍ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_22","074_18_22","ACT","18","22","22","କାଇସରିୟାନ୍ତୁଗ୍‍ ୱେଚାଚେ ଆତ୍‍ବାନ୍‍ ମେଁ ଯିରୁସାଲାମ୍‍ପାକା ୱେକେ ଆରି ମଣ୍ଡଲିଇଂକେ ସାର୍‍ଲଚେ ଆଣ୍ଟିୟକ ପାକା ୱେଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_23","074_18_23","ACT","18","23","23","ଆତ୍‍ତେ ଉଡ଼ିସି ଲେଃକ୍ନେ ଇଡ଼ିଂ ମେଁ ଆରି ଅଲେଙ୍ଗ୍‍ ଅଲେଙ୍ଗ୍‍ଚେ ଗାଲାତିୟ ଆରି ଫ୍ରୁଗିଆ ଏରିଆ ବିଚେ ୱେଆର୍କେ ଆରି ଗାଲିନ୍ନିଆ ବିସ୍‍ବାସିଇଂକେ ମେଇଂନେ ବିସ୍‌ବାସ୍‌ରେ ଡାଟ୍‍ ଡିଂନେସା ସାର୍‍ଦା ଆଡିଂଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_24","074_18_24","ACT","18","24","24","ଆପଲ୍ଲୋ ମ୍ନିକ୍ନେ ମୁଇଂ ଜିଉଦି ଆତ୍‍ଅରିଆ ଲେଃଗେ । ମେଁନେ ଜନମ୍‍ ଡିଂକ୍ନେ ଜାଗା ଆଲେକ୍‍ଜାଣ୍ଡ୍ରିଆ; ମେଁ ଏଫିସିୟ ସହର୍‍ନ୍ନିଆ ପାଂକେ । ମେଁ ମୁଇଂ ଜାବର୍‌ ନିମାଣ୍ଡାଃ ବକ୍ତା ଲେଃଗେ । ଦରମ୍‌ ସାସ୍ତର୍‌ନ୍ନିଆ ମେଁନେ ଜାବର୍‌ ଗିଆନ୍‍ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_25","074_18_25","ACT","18","25","25","ଆକେନ୍‍ ଜିସୁ ମାପ୍‌ରୁନେ ଗାଲି ବିସୟ୍‍ରେ ବୁଦି ବାଲେଃଗେ, ବାରି ଆତ୍ମାରେ ତଃଡ଼ିଆଚେ ଜିସୁନେ ବିସୟ୍‌ ପୁରାପୁରି ବାବ୍‌ରେ ବାସଙ୍ଗ୍‌ଚେ ବୁଦି ବିଃଡିଂଗେ ମାତର୍‍ ଏନ୍ ବିସୟ୍‌ରେ ମେଁ କେବଲ୍‍ ଜହନ୍‌ନେ ଣ୍ଡିଆଦିକ୍ୟା ବିସୟ୍‌ରେ ମ୍ୟାଃଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_26","074_18_26","ACT","18","26","26","ମେଁ ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ସାହାସ୍‍ ଏତେ ସାମୁଆଁ ବାଲିର୍‍କେ । ମାତର୍‍ ପ୍ରିସ୍କା ଆରି ଆକ୍ୱିଲା ମେଇଂନେ ସାମୁଆଁ ଅଁଚେ ଆମେଇଂକେ ନିଜର୍‍ ଡୁଆ ଡୁଂୱିଗ୍‍କେ ଆରି ଆତ୍‍ଅରିଆ ଆମେକେ ଇସ୍‍ପର୍‍ନେ ଗାଲି ସାମୁଆଁ ଆମେଇଂକେ ଆରି ନିମାଣ୍ଡା ବାବ୍‌ରେ ଆବୁଜେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_27","074_18_27","ACT","18","27","27","ମେଁ ଆଖାୟା ଦେସ୍‍ପାକା ୱେନ୍‍ସା ଇକ୍‌ଚା ଡିଂକ୍ନେନ୍‍ସା ବୟାଁଇଂ ଆମେଇଂକେ ସାର୍‍ଦା ବିଚେ ଆମେଇଂକେ ଗ୍ର‍ଅନ୍‌ ଡିଂନେନ୍‍ସା ସିସ୍‍ଇଂକେ ଗୁଆର୍‍କେ । ମେଁ ଏତେ ୱେଚାଚେ ଜାଣ୍ଡେ ବିସ୍‍ବାସ୍‍ ଡିଂଆର୍‍କେ ଇସ୍‍ପର୍‍ନେ ଅନୁଗ୍ର‍ଅ ଏତେ ମେଇଂନେ ଜବର୍‍ ସାଇଜ୍ୟ ଡିଂଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC18_28","074_18_28","ACT","18","28","28","ମେଁନେ ଡାଗ୍‍ଲା ଜିସୁ ଜେ କିସ୍‌ଟ ଆକେନ୍‍ ଦର୍ମସାସ୍ତର୍‌ ଏତେ ପର୍‌ମାନ୍‍ ଡିଂଚେ ମେଁ ବାଲିର୍‍ନେ ବପୁ ଏତେ ଜିଉଦିଇଂନେ ଜୁକ୍ତି ସର୍‍ଚେ ବନ୍ଦ୍‍ ଆଡିଂବି ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_1","074_19_1","ACT","19","1","1","ଆପଲ୍ଲୋ କରିନ୍ଥିନ୍ନିଆ ଲେଃକ୍ନେ ବେଲା ପାଉଲ୍‍ ମଜିରେନେ ଏରିଆ ବିଚେ ଅଲେଙ୍ଗ୍‍ ୱେଚେ ଏଫିସିୟ ଇନିପାକା ପାଙ୍ଗ୍‍ଚେ ଉଡ଼ିକ୍ଲିଗ୍‍ ସିସ୍‍ଇଂକେ କେକେ ");
INSERT INTO gaq_vpl VALUES ("AC19_2","074_19_2","ACT","19","2","2","ମେଇଂ ଆମେଇଂକେ ସାଲିଆକୁକେ ବିସ୍‍ବାସ୍‍ ଡିଂବେଲା ପେ ପବିତ୍ର ଆତ୍ମା ବାପେଲେଃକେ ? ମେଇଂ ଆମେକେ ବାଲିର୍‍ଆର୍କେ ଣ୍ଡୁ ପବିତ୍ର ଆତ୍ମା ଜେ ଲେଃକେ ଆତେନ୍‌‍ ଅଃନାଡିଗ୍ ଅଁ ନେଲେଃକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC19_3","074_19_3","ACT","19","3","3","ତେନ୍‍ସା ମେଁ ସାଲିଆକୁକେ ତେଲା ପେ ଆଣ୍ତିଅରିଆ ଡୁବନ୍‌ ଗ୍ର‍ଅନ୍ ପେଡିଂକେ ? ମେଇଂ ବାଲିର୍‍ଆର୍କେ “ଜହନ୍‌ନେ ଡୁବନ୍‌ ।” ");
INSERT INTO gaq_vpl VALUES ("AC19_4","074_19_4","ACT","19","4","4","ତେଲା ପାଉଲ୍‍ ବାଲିର୍‍କେ ଜହନ୍‌ ମନ୍‌ ବଦ୍‌ଲେଃନେ ଡୁବନ୍‌ନ୍ନିଆ ଡୁବନ୍‌ ବିଃକେ କ୍ମେ ଇଡ଼ିଂ ଜାଣ୍ଡେ ପାଙ୍ଗ୍‍ଆର୍‌ଏ, ମେଇଂ ଡାଗ୍ରା ବା ଜିସୁ ଡାଗ୍ରା ବିସ୍‍ବାସ୍‍ ଡିଂନେ ପଡ଼େଏ ଡାଗ୍‍ଚେ ରେମୁଆଁଇଂକେ ବାଲିର୍‍ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_5","074_19_5","ACT","19","5","5","ମେଇଂ ଆକେନ୍‍ ଅଁଚେ ମାପ୍‌ରୁ ଜିସୁ ମ୍ନିରେ ଡୁବନ୍‌ ଡିଂଆର୍କେ ");
INSERT INTO gaq_vpl VALUES ("AC19_6","074_19_6","ACT","19","6","6","ଆରି ପାଉଲ୍‍ ମେଇଂ ଆଡ଼ାତ୍ରା ନ୍ତିବଚେ ଆନ୍ତାର୍‍ ବିକେ ପବିତ୍ର ଆତ୍ମା ମେଇଂ ଆଡ଼ାତ୍ରା ଗାୱେଆର୍କେ ଆରି ମେଇଂ ବିନ୍‍ବିନ୍‍ ସାମୁଆଁରେ ବ୍ନାଲିର୍ ବାସଙ୍ଗ୍‌ନେ ବାରି ବାବବାନି ଡିଗ୍‍ ବାସଙ୍ଗ୍‌ସା ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_7","074_19_7","ACT","19","7","7","ମେଇଂ ସର୍‍ତେରେ ପାକାପାକି ଗମ୍ୱାର୍‍ରୁଆ ଙ୍ଗିରେ ଲେଃଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_8","074_19_8","ACT","19","8","8","ଇଡ଼ିଙ୍ଗ୍‌ ମେଁ ପାର୍‌ତନା ଡୁଆନ୍ନିଆ ଗାଚେ ଞ୍ଜି ଆର୍କେ ଜାକ ସାହାସ୍‍ ଏତେ ଇସ୍‍ପର୍‍ନେ ରାଜି ବିସୟ୍‌ରେ ବାଲିର୍‍ଚେ ବିସ୍‍ବାସ୍‍ ଆଡିଙ୍ଗ୍‌ନ୍‌ସା ଚେସ୍‌ଟା ଡିଂଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_9","074_19_9","ACT","19","9","9","ମାତର୍ ମେଇଂନେବାନ୍‍ ଉଡ଼ିରୁଆ କଟିନ୍ ମନ୍ ରେମୁଆଁ ଲେଃଆର୍‍ଗେ । ମେଇଂ ବିସ୍‌ବାସି ଆଡିଂଆର୍କେ ଣ୍ଡୁ । ମେଇଂ ଦଲ୍‍ନେ ସାପାରେ ସାମ୍‍ନାରେ ମାପ୍‍ରୁନେ ଗାଲି ସାମୁଆଁରେ ଜାବର୍‌ ଦଦିଆ ବ୍ନାଲିର୍‍ ବାଲିର୍‍ଆର୍କେ । ତେସା ପାଉଲ୍‍ ଆମେଇଂକେ ଆନ୍ତାର୍‍ଚେ ବିସ୍‍ବାସିଇଂକେ ସାଚେ କାଲାଆଃ ଟିରାନସ୍‍ ଡୁଆନ୍ନିଆ ବାଲିର୍‍ନେ ମୁଲେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_10","074_19_10","ACT","19","10","10","ଡେକୁଆ ମ୍ୱାର୍‍ ମୁଆଁ ଜାକ ୱେକେ; ଆତ୍‍ତେ ଆସିଆଣ୍ଡ୍ରେ ଜିଉଦି ଆରି ଗ୍ରୀକ୍‌ ରେମୁଆଁ ସର୍‍ତେ ମାପ୍‍ରୁନେ ସାମୁଆଁ ଅଁଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_11","074_19_11","ACT","19","11","11","ଆରି ଇସ୍‍ପର୍‍ ପାଉଲ୍‍ନେ ନ୍ତି ଏତେ ଆଡିଂକ୍ନେ ଇରିୟାତୁଗ୍‌ନେ କାମ୍ ଆଡିଂବି ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_12","074_19_12","ACT","19","12","12","ଡେକ୍‍ରକମ୍‍ ମେଁ ଗାଗ୍‍ଡ଼େବାନ୍‍ ଉର୍‌ମାଲ୍ ଆରି ସକା ରଗିଇଂ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଲା ମେଇଂ ଡାଗ୍ରା ରଗ୍‍ ଆନ୍ତାର୍‍ ୱେଡିଂଗେ ଆରି ଦୁଷ୍ଟ ଆତ୍ମାଇଂ ତାର୍‍ ଲାଗ୍‍ଡଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_13","074_19_13","ACT","19","13","13","ମାତର୍‍ ଅଲେଙ୍ଗ୍‍ ରେମୁଆଁ ଜିଉଦିଇଂ ବୁତୁଡ଼ିଆଇଂବାନ୍‍ ଉଡ଼ିକ୍ଲିଗ୍‍ ରେମୁଆଁଇଂ ଡିଗ୍‍ ଦୁଷ୍ଟ ଆତ୍ମା ସାକ୍ନେ ରେମୁଆଁଇଂ ଆଡ଼ାତ୍ରା ମାପ୍‌ରୁ ଜିସୁନେ ମ୍ନି ସାଚେ ସେଆଁରେ ଆଆନ୍ତାର୍‍ ନ୍‍ସା ଚେସ୍‍ଟା ଡିଂଆର୍କେ ମେଇଂ ବାଲିର୍‍ଆର୍କେ, “ମୁଡ଼ି ଜିସୁନେ ମ୍ନିରେ ପାଉଲ୍‍ ବାସଙ୍ଗ୍‌‌ଡିଂକେ, ନେଙ୍ଗ୍‍ ଆନାକେ ମେଁ ମ୍ନିରେ ଆଦେସ୍‍ ବିଣ୍ଡିଂକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC19_14","074_19_14","ACT","19","14","14","ଆରି ସ୍କେବା ମ୍ନିକ୍ନେ ମୁଇଂ ଜିଉଦି ରେମୁଆଁନେ ମ୍ନା ପୁଜାରିଇଂନେ ଗୁକ୍ଲିଗ୍‍ ଉଂଇଂ ଡେକୁଆ ଡିଂନେ ଚେସ୍‌ଟା ଡିଂଆର୍‍ଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_15","074_19_15","ACT","19","15","15","ଆତ୍‍ତେ ଦୁସ୍ଟ ଆତ୍ମାଇଂ ଉତର୍‍ ବିକେ, ନିଂ ଜିସୁକେ ମ୍ୟାନ୍ଲେଃକେ ଆରି ପାଉଲ୍‍କେ ଣ୍ଡିଗ୍ ମ୍ୟାନ୍ଲେଃକେ; ମାତର୍‍ ପେ ସାପାରେ ଜାଣ୍ଡେ ? ");
INSERT INTO gaq_vpl VALUES ("AC19_16","074_19_16","ACT","19","16","16","ଆତେନ୍‌‍ ବେଲା ଦୁସ୍ଟ ଆତ୍ମା ସାଲେଃକ୍ନେ ରେମୁଆଁ ମେଇଂ ଆଡ଼ାତ୍ରା ପୁଏଚେ ମେଁ ମ୍ୱାୟାକେ ଆଃଲଃଚେ ଆମେଇଂକେ ଏନ୍‍ତି ବଗ୍‍କେ ଜେ ମେଇଂ ନାଙ୍ଗ୍‍ଲାଚେ ଆରି ଚିନାବାନାଚେ ତେନ୍‍ ଡୁଆବାନ୍‍ ତାର୍‍ଚେ ଲାଗ୍‍ଡଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_17","074_19_17","ACT","19","17","17","ଆକେନ୍‍ ସାମୁଆଁ ଏଫିସିୟନ୍ନିଆ ବାସା ଡିଂଆର୍‌କ୍ନେ ରେମୁଆଁଇଂ ଜିଉଦି ଆରି ଗ୍ରୀକ୍‌ ରେମୁଆଁ ସର୍‍ତେରେ ମ୍ୟାଚେ ବୁଟମେଗ୍‌ ଆର୍କେ । ଆରି ମାପ୍‌ରୁ ଜିସୁନେ ମ୍ନି ମ୍ନା ଡିଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_18","074_19_18","ACT","19","18","18","ଆରି ବିସ୍‍ବାସିଇଂନେ ବିତ୍‍ରେବାନ୍ ଜବର୍‍ରେ ପାଙ୍ଗ୍‍ଚେ ନିଜର୍‍ ନିଜର୍‍ କାମ୍ ଆସୁଏଆର୍କେ ଆରି ବାଲିର୍‍ନେ ଆରାମ୍‍ ଡିଂଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_19","074_19_19","ACT","19","19","19","ଆରି ଜାଦୁ କାମ୍ ଡିଂନେ ଉଡ଼ିରୁଆ ନିଜର୍‍ ନିଜର୍‍ ବଇ ଡୁଂପାଙ୍ଗ୍‍ଚେ ମୁଇଂତୁଗ୍‍ ବଚେ ସର୍‍ତେରେ ସାମ୍‍ନେ ଆଃଗି ବିଃଆର୍କେ; ମେଇଂ ଆତେନ୍‌‍ ସର୍‍ତେନେ ଡାବୁ ହିସାବ୍‍ ଡିଂଚେ ଆତେନ୍‌‍ ପଚାସ୍‍ ଅଜାର୍‍ ଡାବୁ ଡାଗ୍‍ଚେ ଗୁଆର୍‌ଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_20","074_19_20","ACT","19","20","20","ଡେକ୍‍ରକମ୍‍ ମାପ୍‍ରୁନେ ସାମୁଆଁ ମ୍ନା ବପୁରେ ଉଡ୍ରାଡିଂନେ ଲାଗେକେ । ଆରି ଜିତେନେ ଲାଗେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_21","074_19_21","ACT","19","21","21","ଆକେନ୍‍ ସର୍‍ତେ ସାମୁଆଁ ଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ପାଉଲ୍‍ ମାସିଦୋନିଆ ଆରି ଆଖାୟା ବିଚେ ଯିରୁସାଲାମ୍‌ ପାକା ୱେନ୍‍ସା ମନେ ବାବେଆର୍କେ ଆତ୍‍ତେ ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ମେଁ ବାସଙ୍ଗ୍‌କେ “ଆନେଙ୍ଗ୍‍ ରୋମ୍‍ ପାକା ୱେନେ ପଡ଼େଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC19_22","074_19_22","ACT","19","22","22","ବାରି ଜାଣ୍ଡେଇଂ ମେଁନେ ସେବା ଡିଙ୍ଗ୍‌ନେ ଲେଃଆର୍‌କେ ମେଇଂ ବିତ୍‍ରେ ତିମତି ଆରି ଏରାଷ୍ଟ ଆକେନ୍‍ ମ୍ୱାୟାକେ ମାସିଦୋନିଆ ପାକା ବେବିଚେ ମେଁ ନିଜେ ଉଡ଼ି ମୁଆଁ ଜାକ ଆସିଆନ୍ତୁଗ୍‍ ଲେଃଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_23","074_19_23","ACT","19","23","23","ଅଃତେନ୍‍ ବିତ୍‌ରେ ଆକେନ୍‍ ମାପ୍‌ରୁ ଆସୁଏବକ୍ନେ ଗାଲି ସାମୁଆଁ ଡୁଙ୍ଗ୍‌ୱେଚେ ଏଫିସିନ୍ନିଆ ବୟଙ୍କାର୍ ମ୍ନା ୱିଙ୍ଗ୍‌ଆ ତଡ଼ିଆକେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_24","074_19_24","ACT","19","24","24","ଡାଗ୍‍ଲା ଦିମିତ୍ରିୟ ମ୍ନିକ୍ନେ ମୁଇଂ ରୁପାଆରେଣ୍ଡ୍ରେ ଆର୍ତ୍ତେମୀ ଦେବୀନେ ମନ୍ଦିର୍‌ନେ ରୁପା ମୁର୍‍ତି ଆରେଡିଂଆର୍‌ଗେ ଆକେନ୍‍ ବେପାର୍‌ବାନ୍ ଆଃରେଣ୍ଡ୍ରେ ଜବର୍‍ ଲାବ୍‍ ବାଡିଂଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_25","074_19_25","ACT","19","25","25","ମେଁ ଆମେଇଂକେ ଆରି ତେନ୍‍ ବେପାର୍‌ନେ ରେମୁଆଁଇଂକେ ୱାଚେ ବାଲିର୍‍କେ, “ଆଦେସ୍‌ଇଂ ଆକେନ୍‍ ବେପାର୍‌ବାନ୍ ନେ ଦନ୍‍ ନେବାଏ ଡାଗ୍‍ଚେ ପେ ମ୍ୟାପେଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_26","074_19_26","ACT","19","26","26","ଆରି ନ୍ତିଏତେ ଆରେକ୍ନେ ଦେବ୍‍ତାଇଂ ଇସ୍‍ପର୍‍ ଣ୍ଡୁ ଡାଗ୍‍ ବାଲିର୍‍ଚେ ‘ଆକେନ୍‍ ପାଉଲ୍‍ ମାତର୍‌‌ ଏଫିସିୟନ୍ନିଆ ଣ୍ଡୁ ମାତର୍‍ ସର୍‍ତେ ଆସିଆନ୍ନିଆ ଜବର୍‍ ରେମୁଆଁଇଂକେ ବାସଙ୍ଗ୍‌ ଡିଙ୍ଗ୍‌ଗେ ଆକେନ୍‍ ପେଇଂ କିକେ ପେଡିଙ୍ଗ୍‍କେ ଆରି ଅଁ ପେଡିଂକେ ।’ ");
INSERT INTO gaq_vpl VALUES ("AC19_27","074_19_27","ACT","19","27","27","ଆକ୍‍କେ ଜେ ମୁଇଂ ନେନେ ଆକେନ୍‍ ବେପାର୍‍ନେ ଦଦ୍ୟା‌ ମ୍ନି ଡିଂନେ ଲେଃକେ, ଆତେନ୍‌‍ ଣ୍ଡୁ ଏଲେଡିଗ୍‍ ଆଣ୍ଡିନେ ମହାଦେବୀ ଆର୍ତ୍ତେମୀଇଂକେ ସର୍‍ତେ ଆସିଆ ଆରି କ୍ଲିଗ୍‍ ଦର୍‌ତି ଜାକ ପୁଜା ଡିଂଆର୍‍ଡିଂକେ ମେଇଂନେ ମନ୍ଦିର୍‍ ଡିଗ୍ ଡାଆଁ ଡିଂଲେଃକ୍ନେ ଆରି ଆର୍ତ୍ତେମୀ ଦେବୀନେ ଇଜତ୍‌ ନସ୍ଟ ଡିଂଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC19_28","074_19_28","ACT","19","28","28","ଆକେନ୍‍ ସାମୁଆଁ ଅଁଚେ ମେଇଂ ଜବର୍‍ ଗିସେଚେ ୱାସାର୍‍ଚେ ବାଲିର୍‍କେ “ଏଫିସିୟଇଂନେ ଆର୍ତ୍ତେମୀ ମ୍ନା ଦେବୀ ମ୍ନା ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC19_29","074_19_29","ACT","19","29","29","ଅଃକେନ୍‍ରେ ଇନି ୱିଙ୍ଗ୍‍ଆଃରେ ବର୍‌ତି ଡିଂୱେଗେ ଆରି ମେଇଂ ରିସିଂଚେ ପାଉଲ୍‍ନେ ଏତେ ୱେଣ୍ଡ୍ରେ ମାସିଦୋନିଆନେ ଗାୟ ଆରି ଆରିଷ୍ଟାର୍ଖସ୍‌କେ ସାଚେ ଜବର୍ ୱିର୍‍ଚେ ଜୁଦ୍‌ ଟାନ୍‌ନ୍ନିଆ ୱିର୍‌ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_30","074_19_30","ACT","19","30","30","ଆକେନ୍‍ ପାଉଲ୍‍ ରେମୁଆଁଇଂନେ ବିତ୍‍ରେ ଗ୍‍ଗାନେ ଇକ୍‌ଚା ଡିଂକେ ଏଲେ ସିସ୍‍ଇଂ ଆମେକେ ଗ୍‍ଗାନେ ଆବିକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC19_31","074_19_31","ACT","19","31","31","ଆରି ଆସିଆନେ ମ୍ନା ଚାକ୍‍ରିଆଇଂ ବିତ୍‍ରେ ଡିଗ୍‍ ଉଡ଼ିରୁଆ ମେଇଂନେ ସାଙ୍ଗ ଲେଃଲା ରେମୁଆଁ ବେଚେ ଜୁଦ୍‌ ଟାନ୍‌ନେ କଣ୍ଡା ବିତ୍‍ରେ ମାବ୍‌ଟଚେ ଗ୍‍ଗାନ୍‍ସା ଆମେକେ ଗୁଆରି ଡିଙ୍ଗ୍‌ ଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_32","074_19_32","ACT","19","32","32","ଅଃତେନ୍‍ ବେଲା ଜାଣ୍ଡେ ଜାଣ୍ଡେ ଆକେନ୍‍ ସାମୁଆଁ ଜାଣ୍ଡେ ଜାଣ୍ଡେ ବା ଆତେନ୍‌‍ ସାମୁଆଁ ବାଲିର୍‍ଚେ ୱାସାର୍‍ ଡିଂ ଆର୍‍ଡିଂଗେ ମାତର୍‍ କୁକପାର୍‍ ୱିଙ୍ଗ୍‍ଆଃରେ ବର୍‌ତି ଡିଂୱେଗେ ଆରି ମେଇଂ ଜେ ମେଃନ୍‍ସା ମିସୁ ଲେଃଆର୍କେ ଆତେନ୍‌‍ ସାଃଗାରେ ମ୍ୟାଃ ଆଲେଃଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_33","074_19_33","ACT","19","33","33","ରେମୁଆଁଇଂ ବିତ୍‍ରେବାନ୍‍ ଉଡ଼ିରୁଆ ବାଲିର୍‍ଆର୍‍କେ ଜେ ଆଲେକ୍‍ଜାଣ୍ତାର୍‍କେ ଆଃକେନ୍‍ସା ଦାଇ, ଡାଗ୍ଲା ଜିଉଦିଇଂ ଆମେକେ ସେନୁଗ୍‍ ଆତୁଆଁ ବଆର୍‍ଗେ । ଆଲେକ୍‍ଜାଣ୍ଡାର୍‍ ନ୍ତି ଟେକେଚେ ଆମେଇଂକେ ବୁଂଲେନ୍‍ସା ଚିନା ବିକେ ଆରି ବିସ୍‍ବାସିଇଂକେ ଆକୁଡ଼େଚେ ବ୍ନାଲିର୍‍ ବିଚେ ଆଦ୍ରିଗ୍‍ନେସା ଚେସ୍‍ଟା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_34","074_19_34","ACT","19","34","34","ମାତର୍‍ ମେଁ ମୁଇଂ ଜିଉଦି ଡାଗ୍‍ଚେ ଉଡ଼ିବେଲା ମେଇଂ ମ୍ୟାଃଆର୍‍କେ, ଅଃତେନ୍‍ ବେଲା ସର୍‍ତେରେ ମୁଇଂତର୍‍କେ ମ୍ୱାର୍‍ ଗଣ୍ଟା ଜାକ ୱାସାର୍‍ ଆର୍‍କେ, ଏଫିସିୟଇଂନେ ଆର୍ତ୍ତେମୀ ମ୍ନାଃଦେବୀ ଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_35","074_19_35","ACT","19","35","35","ଇଡ଼ିଙ୍ଗ୍‌ ସହର୍‌ ଗୁମୁସ୍ତା ରେମୁଆଁ ସାପାରେକେ ଆବୁଜେଚେ ବାଲିର୍‍କେ ଅ ଏଫିସିୟ ରେମୁଆଁଇଂ ଏଫିସ ସହର୍‌ ଜେ ମ୍ନା ଦେବୀ ଆର୍ତ୍ତେମୀ ଆରି କିତଂଇନି ବାନ୍‍ ଲଲେକ୍ନେ ପ୍ରତିମାନେ ମନ୍ଦିର୍‍ନେ ପୁଜାରି ଆକେନ୍‍ ଜାଣ୍ଡେଃ ଆମ୍ୟାକେ ? ");
INSERT INTO gaq_vpl VALUES ("AC19_36","074_19_36","ACT","19","36","36","ଜାଣ୍ଡେଃ ଆକେନ୍‍ ମିଚ୍‍ ବାଲିର୍‍ ଆୟା ଣ୍ଡୁ । ତେନ୍‍ସା ପେ ସର୍‍ତେରେ ବୁଂବିପା ମେଃଡିଗ୍ ମାମ୍ୟାଃ କୁଟା ଆସ୍ଲେଗେପା । ");
INSERT INTO gaq_vpl VALUES ("AC19_37","074_19_37","ACT","19","37","37","ଏନ୍‍ ରେମୁଆଁଇଂ ମନ୍ଦିର୍‍ବାନ୍‍ ମେଃଡିଗ୍‍ ଆଡଙ୍ଗ୍‍ଗା ଆର୍‍କେ ଣ୍ଡୁ କି ଦେବିନେ ବିରୁଦ୍‌ରେ ମେଃଡିଗ୍‍ ନିନ୍ଦା ସାମୁଆଁ ଆବାଲିର୍‍ ଆର୍‍କେ ଣ୍ଡୁ ଏଲେଡିଗ୍‍ ନା ଆକ୍ମେଇଂକେ ସାଚେ ଡୁଂପାଂନାବ । ");
INSERT INTO gaq_vpl VALUES ("AC19_38","074_19_38","ACT","19","38","38","ତେନ୍‍ସା ଜଦି ଜାଣ୍ଡେନେ ବିରଦ୍‌ରେ ଦିମିତ୍ରିୟନେ ଆରି ମେଇଂନେ ସାଙ୍ଗ ସ୍ଲେରେନେ ମେଃଡିଗ୍‍ ସାମୁଆଁ ଲେଃଏ, ତେଲା ବିଚାର୍‍ ଡୁଆ ରଃବକେ ଆରି ସାସନ୍‍ ରେମୁଆଁଇଂ ଲେଃକେ; ମେଇଂ ନିଜର୍‍ ନିଜର୍‍ ବିରଦ୍‍ରେ ଅବାଲିର୍‍ ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC19_39","074_19_39","ACT","19","39","39","ଆରି ଜଦି ପେନେ ବିନ୍‍ ମେଣ୍ଡିଗ୍ ବାଲିର୍‍ନେ ଲେଃଏ, ତେଲା ନିୟମ୍‌ ଇସାବ୍‌ରେ ଡାଆଁ କୁକପାର୍‍ନ୍ନିଆ ମେଁନେ ନିଷ୍ପତି ଡିଂଏ । ");
INSERT INTO gaq_vpl VALUES ("AC19_40","074_19_40","ACT","19","40","40","ଏଲେ ଏକ୍ନେ ସତ୍‍ ୱିଙ୍ଗ୍‌ଆ ଡୁଙ୍ଗ୍‍ପାଙ୍ଗ୍‍ଚେ ନେ ବିରଦ୍‍ରେ ଅବାଲିର୍‍ନେ ଜାବର୍‌ କସ୍ଟ ଲେଃକେ; ନେ ଆକେନ୍‍ ୱିଙ୍ଗ୍‍ଆନେ ମେଃଣ୍ଡିଗ୍‍ କାରନ୍‍ ଆସୁଏ ନେୟା ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC19_41","074_19_41","ACT","19","41","41","ଏନ୍‍ ସାପା ବ୍ନାଲିର୍‍ ବାଲିର୍‍ଚେ ମେଁ ରେମୁଆଁଇଂକେ ଆବୁଂଚେ କୁକପାର୍‍ ଆଡାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_1","074_20_1","ACT","20","1","1","ତେନ୍‍ ୱିଙ୍ଗ୍‌ଆ ବୁଂକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ପାଉଲ୍‍ ସିସ୍‍ଇଂକେ ଡୁଆ ୱାଚେ ମେଇଂକେ ସାର୍‌ଦା ବିକେ ଆରି ମେଇଂବାନ୍‍ ୱିଗ୍‍ନେ ବାଲିର୍‍ଚେ ମାସିଦୋନିଆ ପାକା ୱେନ୍‍ସା ୱିଗ୍‍ ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_2","074_20_2","ACT","20","2","2","ତେନ୍‍ ସର୍‍ତେ ଏରିଆ ବିଚେ ଅଲେଙ୍ଗ୍‍ ୱିଗ୍‍ରେ ମେଁ ସିସ୍‍ଇଂକେ ଜବର୍‍ ସାର୍‌ଦା ଆଡିଙ୍ଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଗ୍ରୀସ୍ ପାକା ୱେ ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_3","074_20_3","ACT","20","3","3","ମେଁ ଆତ୍‍ତେ ଞ୍ଜିଆର୍କେ ଲେଃଚେ ଉଡ଼ିବେଲା ଜା‍ଆଜ୍‌ନ୍ନିଆ ଡେଃଚେ ସିରିଆ ପାକା ୱେନ୍‍ସା ଆରାମ୍‍ ଡିଙ୍ଗ୍‍ ଆର୍‍କେ ଅଃତେନ୍‍ ବେଲା ଜିଉଦିଇଂ ମେଇଂ ବିସୟ୍‍ରେ ବାଗୁଏଃ ନ୍‍ସା ମେଁ ମାସିଦୋନିଆ ବିଚେ ୱିଗ୍‍ନେସା ମନ୍‍ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_4","074_20_4","ACT","20","4","4","ବେରିୟାନ୍ନିଆ ବାସା ଲେଃକ୍ନେ ପୁରନେ ଉଙ୍ଗ୍‌ଡେ ସୋପାତ୍ର, ତେସଲନିକିୟନେ ଆରିଷ୍ଟାର୍ଖସ୍‌ ଆରି ସେକୁନ୍ଦ ଦର୍ବୀନେ ଗାୟ, ଆସିଆ ଦେସ୍‌ନେ ତୁଖିକ ଆରି ତ୍ରଫିମ ବାରି ତିମତି ମେଁ ଏତେ ୱେଆର୍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_5","074_20_5","ACT","20","5","5","ଆକ୍‍ମେଇଂ ସର୍‍ତେ ପର୍‍ତୁମ୍‍ ୱେଚେ ତ୍ରୋୟାନ୍ତୁଗ୍‍ ଆନେକେ ଉର୍‍ଡିଂଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_6","074_20_6","ACT","20","6","6","ଆରି କମିରସୁନ୍ୟ ରୁଟି ପାଣ୍ଡୁଏଃ ଇଡ଼ିଙ୍ଗ୍‌ ନେଁ ଜା‍ଆଜ୍‌ନ୍ତୁଗ୍‍ ଡେଃଚେ ଫିଲିପ୍‌ପୀବାନ୍‍ ନେୱିଗ୍‍କେ ଆରି ମାଲ୍‍ ଦିନ୍‍ ବିତ୍‍ରେ ତ୍ରୋୟାନ୍ତୁଗ୍‍ ମେଇଂ ଡାଗ୍ରା ନେପିଙ୍ଗ୍‌ଚାକେ; ଆତ୍‍ ଡାଗ୍ରା ନେ ଗୁ ଦିନ୍‍ ନେଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_7","074_20_7","ACT","20","7","7","ସାନ୍ତାନେ ମୁଲ୍‍ଦିନ୍‍ ଉଡ଼ିବେଲା ନେ ରୁଟି ପାକ୍‌ଚିନେ କୁଡ଼େ ନେଲେଃକେ ଅଃତେନ୍‍ ବେଲା ପାଉଲ୍‍ ମାର୍‍ତଡ଼େ ୱିଗ୍‍ଏ ଡାଗ୍‍କ୍ନେ ବେଲା ମେଇଂକେ ବାଲିର୍‍କେ ଆରି ସିଂତାର୍‍ବ ଜାକ ମ୍ନା ବାସଣ ବିକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_8","074_20_8","ACT","20","8","8","ଆଣ୍ଡିନେ ଆଡ଼ାତ୍ରା ମହଲାନେ ବାକ୍ରାନ୍ନିଆ ନେ ମିସୁ ନେଲେଃଗେ ଆତ୍‍ ଅରିଆ ଜବର୍‍ କୁପିସ ଲେଃଗେ ");
INSERT INTO gaq_vpl VALUES ("AC20_9","074_20_9","ACT","20","9","9","ଆରି ଇଉଟିକସ୍‌ ମ୍ନିକ୍ନେ ମୁଇଂ ଙ୍ଗିରେ ଜର୍‌କା ଆଡ଼ାତ୍ରା କଲେଃଗେ, ଆମେକେ ଜବର୍‍ ଲେମୁଆଃ ପାଂଡିଂଗେ; ଆରି ପାଉଲ୍‍ ଉପଦେସ୍‍ ଜବର୍‍ ଚ୍ଲେ ଆଡିଂବିଲା ମେଁ ଡୁଲେଗ୍‍ ବିଲା ଞ୍ଜି ମହଲାବାନ୍‍ ଆଲ ଲଃୱେଗେ ଆରି ଆମେକେ ଆଃତଡ଼ିଆ ବେଲା ମେଁ ଗୁଏଃୱେଗେ ଡାଗ୍‍ଚେ ମ୍ୟାଃଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_10","074_20_10","ACT","20","10","10","ଅଃତେନ୍‍ ବେଲା ପାଉଲ୍‍ ଆଲ ଜାର୍‍ଚେ ମେଁ ଆଡ଼ାତ୍ରା ଲଃଚେ ଆମେକେ କଣ୍ଡଚେ ବାଲିର୍‍କେ, “ଆଅଃଗେପା, ଡାଗ୍‍ଲା କିମେନ୍ତୁଗ୍‍ ଜିବନ୍‍ ଲେଃକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC20_11","074_20_11","ACT","20","11","11","ଇଡ଼ିଙ୍ଗ୍‌ ମେଁ ଆଡ଼ାତ୍ରା ୱେଚେ ରୁଟି ପାକ୍‍ଚିଚେ ଚଂଆର୍କେ ଆରି ତାରାନେ ଜାକ ମେଇଂ ଏତେ ଜବର୍‍ ବାଲିର୍‍ବାତାଚେ ତାର୍ ୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_12","074_20_12","ACT","20","12","12","ଆରି ମେଇଂ ଆତେନ୍‌‍ ଗଡ଼େଅକେ ଜିବନ୍‌ ଲେଃକ୍ନେ କେଚେ ମେଁ ଡୁଆ ଡୁଂୱେଆର୍‌କେ ଆରି ଜାବର୍‌ ସାନ୍ତି ବାଆର୍‌କେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_13","074_20_13","ACT","20","13","13","ମାତର୍‍ ନେ ସିସେ ଣ୍ଡିଆଃ ଜା‍ଆଜ୍‌ ନ୍ତୁଗ୍‍ ଡେଃଚେ ଆସସ୍‍ନ୍ତୁଗ୍ ନେୱେକେ ଆତ୍‍ବାନ୍‍ ନେ ପାଉଲ୍‍କେ ଡୁଙ୍ଗ୍‍ ୱେନ୍‍ସା ନେଏତେକେ ଡାଗ୍‍ଲା ମେଁ ନିଜେ ତୁବଃ ଅଲେଙ୍ଗ୍‍ଚେ ୱେନ୍‍ସା ଇକ୍‌ଚା ଡିଂକେ ଡେତୁଆ ଡିଂବ ଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_14","074_20_14","ACT","20","14","14","ଉଡ଼ିବେଲା ମେଁ ଆନେକେ ଆସସ୍‍ନ୍ନିଆ କୁଡ଼େକେ ନେ ଆମେକେ ଜା‍ଆଜ୍‌ନ୍ନିଆ ଆଃଡେଃଚେ ମିତିଲିନୀନ୍ତୁଗ୍ ନେପାଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_15","074_20_15","ACT","20","15","15","ଆରି ଆତ୍‍ବାନ୍‍ ଜା‍ଆଜ୍‌ ରଚେ ନେ ମାର୍‍ତଡ଼େ ଖିଅସ ଡାଗ୍ରା ନେୱେଚାକେ ମ୍ୱାର୍‍ ଦିନ୍‍କେ ସାମ୍‌ନ୍ନିଆ ଜା‍ଆଜ୍‌ ନେରାଚାକେ ଆରି ଦେକ୍‍କେ ଞ୍ଜଡ଼େ ମିଲୀଟସ୍ ନେୱେଚାକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_16","074_20_16","ACT","20","16","16","ମେଁନେ ଡାଗ୍‍ଲା ଆସିଆନ୍ନିଆ ଡିଡିରକମ୍‌ ପାଉଲ୍‍କେ ବେଲା କାଟେନେ ଆପଡ଼େ ଣ୍ଡୁ, ଆକେନ୍‍ସା ମେଁ ଏଫିସିୟ ଆନ୍ତାର୍‍ ୱିଗ୍‍ନେ ବାବେ ଡିଂକେ । ଜଦି ଡିଙ୍ଗ୍‌ପାରେ ତ ପେଣ୍ଟିକଷ୍ଟ କେଲା ଯିରୁସାଲାମ୍‌ ପାଙ୍ଗ୍‍ନ୍‍ସା ମେଁ ତେରେପେତେ ଡିଂଡିଂଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_17","074_20_17","ACT","20","17","17","ମିଲୀଟସ୍‌ବାନ୍‍ ମେଁ ଏଫିସିୟପାକା ରେମୁଆଁ ବେଚେ ମଣ୍ଡଲିନେ ମ୍ନାରେଇଂକେ ନିଜର୍‌ ନ୍ତୁଗ୍‍ ଡୁଆ ୱାଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_18","074_20_18","ACT","20","18","18","ମେଇଂ ପିଂଚାଲା ପାଉଲ୍‍ ବାଲିର୍‍କେ, “ଆସିଆ ପ୍ରଦେସ୍‍ନ୍ତୁଗ୍‍ ୱେଚାନେ ପର୍‍ତୁମ୍ ଦିନାବାନ୍‍ ନେଙ୍ଗ୍‍ ଡିରକମ୍‍ ପେଇଂ ବିତ୍‍ରେ ଜାବର୍‌ ବେଲା ପେ ଏତେ ଆକଟେ ମ୍ୱକେ । ଆତେନ୍‌‍ ପେ ମ୍ୟାଃପେଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_19","074_20_19","ACT","20","19","19","ମାପ୍‌ରୁ ଜିଉଦିଇଂନେ ଜଜ୍‌ନା ଆନେଙ୍ଗ୍‍ ଆଣ୍ଡିନେ ସାପା ଦୁକ୍‍ କସ୍‍ଟ ବଗେନେ ପଡ଼େଏ ଆତେନ୍‌‍ ବିତ୍‍ରେ ନେଙ୍ଗ୍‍ ଇସ୍‍ପର୍‍ନେ ସେବକ୍‍ ରକମ୍‍ ଅଁଚେ ଦରମ୍‍ ଏତେ ନେଙ୍ଗ୍‍ନେ କାମ୍ ଡିଂମ୍ୱକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_20","074_20_20","ACT","20","20","20","ପେ ମ୍ୟାଃ ପେଲେକେ ଜେ ନେଙ୍ଗ୍‍ ରେମୁଆଁଇଂନେ ଡାଗ୍ରା ବାସଙ୍ଗ୍‌ ଡିଂକେଲା ବାରି ପେ ଡୁଆଇଂଡାଗ୍ରା ବ୍ନାଲିର୍‍ ବାଲିର୍‍ ବେଲା ପେନେ ଉପ୍‍କାର୍‍ ଡିଂନେ ରକମ୍‍ ମେଃଡିଗ୍‍ ସାମୁଆଁ ବାଲିର୍‍ନେସା ମନା ଡିଂ ଆଡିଂଗେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC20_21","074_20_21","ACT","20","21","21","ଜିଉଦି ଆରି ଗ୍ରୀକ୍‌ ରେମୁଆଁ ସାପାରେକେ ନେଙ୍ଗ୍‍ ଚେତ୍‍ନା ସାମୁଆଁ ଆଦ୍ରିଗ୍‌ ଣ୍ଡିଂଗେ ଜେ ମେଇଂ ପାପ୍‍ ଗାଲିବାନ୍ ଆଣ୍ଡେ ପାଙ୍ଗ୍‌ଚେ ଇସ୍‍ପର୍‍ ଆଡ଼ାତ୍ରା ମନ୍‌ ବଦ୍‌ଲେଚେ ବାରି ମାପ୍‌ରୁ ଜିସୁ ଡାଗ୍ରା ବିସ୍‌ବାସ୍‌ ଡିଂଆର୍‍ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC20_22","074_20_22","ACT","20","22","22","ଏବେ କେଲା ନେଙ୍ଗ୍‍ ଆତ୍ମାନ୍ନିଆ ବାଦ୍ୟ ଡିଂଚେ ଯିରୁସାଲାମ୍‌ ପାକା ୱେ ଣ୍ଡିଂକେ ମେଁ ଆତ୍‌ତେ ନେଙ୍ଗ୍‍ସା ମେଃମେଃ ଡିଂଏ, ଆତେନ୍‌‍ ନେଙ୍ଗ୍‍ ନ୍ନାମ୍ୟାଃକେ ଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC20_23","074_20_23","ACT","20","23","23","ନେଙ୍ଗ୍‍ସା ଜା ସିକ୍ଲି ଏତେ ଆଗାଗ୍‍ଚେ ଆରି ଦୁକ୍‍ ବାଏ ଆକେନ୍‍ ପବିତ୍ର ଆତ୍ମା ଇନି ଇନି ଆନେଙ୍ଗ୍‍ ବାଲିର୍‌ ଅଲେଙ୍ଗ୍‍ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_24","074_20_24","ACT","20","24","24","ମାତର୍‍ ନେଙ୍ଗ୍‍ସା ନେଙ୍ଗ୍‍ ଜିବନ୍‍କେ ନେଙ୍ଗ୍‍ ଡାଆଁ ବାବେ ଣ୍ଡିଂକେ । ଇସ୍‍ପର୍‍ନେ ଅନୁଗ୍ର‍ଅ ବିସ‍ୟ୍‌ରେ ମାପ୍‌ରୁ ଜିସୁ ଆଣ୍ଡିନେ ବ୍ନାଲିର୍‌ ବାଲିର୍‍ନେସା ଆନେଙ୍ଗ୍‍ ଦାଇତ୍‍ ବିବକେ, ଆତେନ୍‌‍ ପୁରନ୍‍ ଆଡିଂଚେ ନେଙ୍ଗ୍‍ନେ ବାସଙ୍ଗ୍‌‌ କାମ୍ ଣ୍ଡ୍ରାଡାଏ, ଅଃକେନ୍‍ ଆଃ ନେଙ୍ଗ୍‍ନେ ଇକ୍‌ଚା ।” ");
INSERT INTO gaq_vpl VALUES ("AC20_25","074_20_25","ACT","20","25","25","ଆରି ଏବେ କେଲା ଜା ବିତ୍‍ରେ ନେଙ୍ଗ୍‍ ଇସ୍‍ପର୍‍ନେ ରାଜି ବିସୟ୍‌ରେ ବାଲିର୍‌ ବାଲିର୍‍ ଅଲେଙ୍ଗ୍‍ ଣ୍ଡିଂ ଡେକ୍‍ ରକମ୍‍ ଜେ ପେ ସର୍‍ତେ ଆରି ନେଙ୍ଗ୍‍ନେ ସାର୍‍ମୁଆଃ ପେକେ ଡାଗ୍‍ଚେ ମ୍ୟା ନ୍ଲେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_26","074_20_26","ACT","20","26","26","ଆକେନ୍‍ସା ନେଙ୍ଗ୍‍ ଜେ ସର୍‍ତେରେନେ ମିଆଁନେ ଦାଇତ୍‌ବାନ୍‍ ମ୍ବ୍ରକେ, ଆକେନ୍‍ ନେଙ୍ଗ୍‍ ଏକେ ଆପେକେ ସାକି ବିଣ୍ଡିଂ । ");
INSERT INTO gaq_vpl VALUES ("AC20_27","074_20_27","ACT","20","27","27","ନେଙ୍ଗ୍‍ ଇସ୍‍ପର୍‍ନେ ସର୍‍ତେ ସାମୁଆଁ ଆପେକେ ଆମ୍ୟାନ୍‍ସା ଇଡ଼ିଙ୍ଗ୍‌ ନ୍ନାଲେଗେଣ୍ଡୁ । ");
INSERT INTO gaq_vpl VALUES ("AC20_28","074_20_28","ACT","20","28","28","ପେନେ ନିଜର୍‍ ନିଜର୍‍ ସାମୁଆଁ ଆରି ଆଣ୍ଡିନେ ମଣ୍ଡଲିକେ ଇସ୍‍ପର୍‍ ନିଜର୍‍ ମିଆଁ ଏତେ ବିଆର୍‌ବକେ, ମେଇଂନେ ଆତେନ୍‌‍ ମଣ୍ଡଲିକେ ଲାଲନ୍‍ ପାଲନ୍‍ ଡିଂନେସା ପବିତ୍ର ଆତ୍ମା ଆତେନ୍‌‍ ସାପା ଗିମିଃ ମାନ୍ଦା ବିତ୍‍ରେ ଆପେକେ ନେତା ସୁଗୁଆ ଆତୁଆଁ ବକେ ମେଇଂ ବିସୟ୍‍ରେ କେଚେ ଲାଃଲାପା । ");
INSERT INTO gaq_vpl VALUES ("AC20_29","074_20_29","ACT","20","29","29","ନେଙ୍ଗ୍‍ ଉଁୱିଗ୍‌କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଙ୍କୁଇଂ ଜେ ପେ ବିତ୍‍ରେ ଗାଚେ ଗିମିଃ ମାନ୍ଦାଇଂକେ ଆଚିନାଆବାନା ଆର୍‌ଏ । ");
INSERT INTO gaq_vpl VALUES ("AC20_30","074_20_30","ACT","20","30","30","ଆରି ପେ ବିତ୍‍ରେ ଡିଗ୍‍ ରେମୁଆଁ ତଃଡ଼ିଆଚେ ସିସ୍‍ଇଂକେ ନିଜର୍‍ ନ୍‍ସା ପ୍ଲା ପାକା ଗୁଃ ଡୁଙ୍ଗ୍‌ୱେନେ ନ୍‍ସା ଉଲ୍‍ଟା ସାମୁଁଆଁଇଂ ବାଲିର୍‍କେ ଆକେନ୍‍ ନେଙ୍ଗ୍‍ ମ୍ୟାଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_31","074_20_31","ACT","20","31","31","ଏବେ ପେ ଉର୍‍ ଲାଃଲାପା ଆରି ନେଙ୍ଗ୍‍ ଞ୍ଜି ମୁଆଁ ଜାକ ଞ୍ଜିର୍‍ ଲମ୍‍ଡିଗ୍‍ ଡେଃମୁଁଆଃ ଆଲକ୍ନେ ଏତେ ସର୍‍ତେ ରେମୁଆଁ ଚେତା ବିନ୍‍ନେସା ଜେ ଇଡ଼ିଙ୍ଗ୍‌ ନ୍ନାଃଡିଂକେ, ଆକେନ୍‍ ମ୍ୟାଃଲାଃଲାପା । ");
INSERT INTO gaq_vpl VALUES ("AC20_32","074_20_32","ACT","20","32","32","ଏବେ ନେଙ୍ଗ୍‍ ଆପେକେ ଇସ୍‍ପର୍‍ନେ ଡାଗ୍ରା ଆରି ମେଁନେ ଅନୁଗ୍ର‍ଅନେ ସାମୁଆଁ ଡାଗ୍ରା ସର୍‍ପେ ବିଃ ଣ୍ଡିଙ୍ଗ୍‍କେ ମେଁ ଆପେକେ ବପୁ ଆଡିଂନେସା “ଆରି ପବିତ୍ର ଆଃଡିଙ୍ଗ୍‌ନେ ସାପାରେନେ ବିତ୍ରେ ଅଦିକାର୍‌ ବିନ୍‌ସା ଇକ୍‌ଚା ନ୍ଲେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_33","074_20_33","ACT","20","33","33","ନେଙ୍ଗ୍‍ ଜାନେ ରୁପା କି ସୁନା କି ସକାପାଟାଇ‍ ଲବ୍‍ ଡିଂନାଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_34","074_20_34","ACT","20","34","34","ଆକେନ୍‍ ମ୍ୱାର୍‍ ନ୍ତି ଜେ ନେଙ୍ଗ୍‍ନେ ଆରି ନେଙ୍ଗ୍‍ ସାଙ୍ଗାଡ଼ିଇଂନେ ଅବାବ୍‍ ପୁରନ୍‍ ଆଡିଂନ୍‌ସା ସେବା ମ୍ପାଡିଂ, ଆକେନ୍‍ ପେ ନିଜେ ମ୍ୟାଃପା । ");
INSERT INTO gaq_vpl VALUES ("AC20_35","074_20_35","ACT","20","35","35","ଡେକ୍‍ରକମ୍‍ ସ୍ଲେଚେ ବପୁ ଣ୍ଡୁ ଣ୍ଡ୍ରେକେ ସାଇଜ୍ୟ ନେଡିଂପା ଆରି ‘ବାନେ ବାନ୍ ବିବିଃନେ ଅରିଆ ଜବର୍‍ ସାର୍‌ଦା ଲେଃଏ’, ମାପ୍‌ରୁ ଜିସୁ ନିଜେ ଆକେନ୍‍ ମେଁ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ବକେ, ଆତେନ୍‌‍ ମନେ ଡିଂନେ ପେନ୍‍ସା ଜା ଦର୍‍କାର୍‍, ଆକେନ୍‍ ସର୍‍ତେ ବିସୟ୍‍ରେ ନେଙ୍ଗ୍‍ ଆପେକେ ଗାଲି ଆସୁଏଃମ୍ୱକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC20_36","074_20_36","ACT","20","36","36","ଆକେନ୍‍ ସର୍‍ତେ ସାମୁଆଁ ବାଲିର୍‌ଚେ ମେଁ ଞ୍ଚ ପାଙ୍ଗ୍‌ଚେ ସର୍‍ତେରେ ଏତେ ପାର୍‌ତନା ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_37","074_20_37","ACT","20","37","37","ଆରି ମେଇଂ ସର୍‍ତେରେ ଜବର୍‍ ଅଁଆର୍‍ଚେ ପାଉଲ୍‍କେ ଲୁଗ ସାଚେ ଆମେକେ ବୈନ୍ତା ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC20_38","074_20_38","ACT","20","38","38","ବାରି ମେଇଂ ମେଁନେ ସାର୍‍ମୁଆଃ ଆରି ଆକେ ଆର୍‍ ଣ୍ଡୁ ଡାଗ୍‍ଚେ ମେଁ ଆଣ୍ଡିନେ ସାମୁଆଁ ବାଲିର୍‍କେ ଜବର୍‍ ତେନ୍‍ସା ଦୁକ୍‍ ଡିଂ ଆର୍‍କେ ଇଡ଼ିଙ୍ଗ୍‌ ମେଇଂ ଆମେକେ ଣ୍ଡିଆଃ ଜା‍ଆଜ୍‌ ଜାକ ୱେଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_1","074_21_1","ACT","21","1","1","ମେଇଂନେ ବିଦାୟ୍‌ ଡୁଙ୍ଗ୍‍ଡଚେ ଇଡ଼ିଙ୍ଗ୍‌ ନେ ଜା‍ଆଜ୍‌ନ୍ନିଆ ଡେଃଚେ ସିଦା କୋସ୍‌ନ୍ନିଆ ନେପାଙ୍ଗ୍‍କେ ଆତେନ୍‌‍ ମାର୍‍ତଡ଼େ ରୋଡସ୍‌ନ୍ନିଆ ନେପିଙ୍ଗ୍‌ଚାକେ ବାରି ଆତ୍‍ବାନ୍‍ ପାତାରାନ୍ନିଆ ନେପାଙ୍ଗ୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_2","074_21_2","ACT","21","2","2","ଆତ୍‌ଅରିଆ ଫୈନିକୀୟା ପାକା ୱେଡିଂକ୍ନେ ମୁଇଂ ଣ୍ଡିଆ ଜା‍ଆଜ୍‌ନ୍ନିଆ ଡେଃଚେ ନେୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_3","074_21_3","ACT","21","3","3","ତେନ୍‍ ଇଡ଼ିଙ୍ଗ୍‌ ସାଇପ୍ରସ୍ ଇନି ତ୍ନାଡିଂକ୍ନେ ମୁଇଂ ଜାଗାନ୍ନିଆ ନେୱେଚାକେ । ଆତ୍‍ବାନ୍‍ ମେଃନେ ଦକିନ୍‌ ଦିଗ୍‍ ବିଚେ ନେ ସିରିଆପାକା ନେୱେକେ । ନେ ଟାୟର୍‌ ସହର୍‍ନ୍ନିଆ ଣ୍ଡିଆଃ ଜା‍ଆଜ୍‌ବାନ୍‌ ନେଜାର୍‌କେ ଡାଗ୍‌ଲା ଆକେନ୍ ଜା‍ଆଜ୍‌ବାନ୍ ଜିନିସ୍ ଆଜାର୍‌ନେ ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_4","074_21_4","ACT","21","4","4","ଆତ୍‍ଅରିଆ ନେ ଉଡ଼ିରୁଆ ବିସ୍‌ବାସିଇଂକେ କେଚେ ମେଇଙ୍ଗ୍‌ ଏତେ ମୁଇଂ ସାନ୍ତା ନେଲେଃଗେ । ପବିତ୍ର ଆତ୍ମାନେ ଆଦେସ୍‍ ବାଚେ ମେଇଂ ପାଉଲ୍‍କେ ଯିରୁସାଲାମ୍‌ ୱେନ୍‍ସା ମନା ଡିଂଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_5","074_21_5","ACT","21","5","5","ମାତର୍‍ ମେଇଂ ଏତେ ମୁଇଂ ସାନ୍ତା ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ନେ ଆମେଇଂକେ ଆନ୍ତାର୍‍ଚେ ନେନେ ଗାଲିପାକା ନେୱେକେ । ଆନେକେ ବିଦାୟ୍‌ ବିନ୍‍ସା ମେଇଂ ସାପାରେ ନିଜେନେ ସେଲାମ୍ବୁଏଃ ଆରି ଗଡ଼େଇଂ ଏତେ ସହର୍‍ ବାଏରେ ଲେକ୍ନେ ମ୍ନା କେଣ୍ଡିଆ ଆଡ଼ା ଜାକ ପାଙ୍ଗ୍‍ଆର୍କେ । ଆତ୍‍ଅରିଆ ନେ ସାପାରେ ଡେଙ୍ଗଚେ ପାର୍‌ତନା ନେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_6","074_21_6","ACT","21","6","6","ତେନ୍‌ ଇଡ଼ିଂ ନେ ଆମେଇଂକେ ବିଦାୟ୍‌ ବିଚେ ଣ୍ଡିଆଃ ଜା‍ଆଜ୍‌ନ୍ନିଆ ନେଗାକେ ଆରି ମେଇଂ ନିଜର୍ ଡୁଆ ୱିଗ୍‍ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_7","074_21_7","ACT","21","7","7","ନେ ଟାୟର୍‌ବାନ୍‍ ଜା‍ଆଜ୍‌ନ୍ନିଆ ଯାତ୍ରା ଡିଂଚେ ତାଲମେଇନ୍ନିଆ ନେପିଙ୍ଗ୍‍ଚାକେ ବାରି ବୟାଁଇଂକେ ସାର୍‍ଲଚେ ମୁଇଂ ଦିନା ମେଇଙ୍ଗ୍‌ ଏତେ ନେଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_8","074_21_8","ACT","21","8","8","ମାର୍‍ତଡ଼େ ନେ ଆତେନ୍‌‍ ଜାଗା ଆନ୍ତାର୍‍ଚେ କାଇସରିୟା ନେୱେଚାକେ । ଆତ୍‍ଅରିଆ ନେ ବାସଙ୍ଗ୍‌‌ ଡିଙ୍ଗ୍‌ଣ୍ଡ୍ରେ ଫିଲିପ୍‌ନେ ଡୁଆ ନେଲେଃଗେ ଯିରୁସାଲାମ୍‍ନ୍ନିଆ ସେବକ ରକମ୍‍ ମନନିତ୍‍ ଡିଙ୍ଗ୍‍ଲେକ୍ନେ ଗୁ ରୁଆବାନ୍‍ ମେଁ ମୁଇଂଜା ଲେଃଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_9","074_21_9","ACT","21","9","9","ମେଁନେ ଅଁଣ୍ଡ୍ରୁଆ ବିହେ ମାଡିକ୍ନେ ସେଲା ଇସ୍‍ପର୍‍ନେ ବାବବାନି ବାସଙ୍ଗ୍‍ଡିଂ ଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_10","074_21_10","ACT","21","10","10","ନେ ଆତ୍‍ଅରିଆ ଗୁଲେ ଦିନା ଲେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ଜିଉଦା ପ୍ରଦେସ୍‌ବାନ୍‍ ଆଗାବ ମ୍ନିକ୍ନେ ମୁଇଂ ବାବବାଦି ଆତ୍‍ଅରିଆ ପାଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_11","074_21_11","ACT","21","11","11","ମେଁ ନେଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ପାଉଲ୍‍ନେ ନ୍‌ସାନ୍ନିଆ ଗାଗ୍‍ନେ ତୁଆଲ୍‍ ଡୁଂଡଆର୍‍କେ, ଆତ୍‍ବା ମେଁ ନିଜେନେ ନ୍ତି ବାରି ଞ୍ଚ ଗାଗ୍‍ଚେ ବାଲିର୍‍କେ “ପବିତ୍ର ଆତ୍ମା ଆନେଙ୍ଗ୍‍କେ ଆମ୍ୟାଃଡିଂକେ ଜେ ଆକେନ୍‍ ତୁଆଲ୍‍ ଗାଗ୍‍ମ୍ୟାଃକ୍ନେ ଅଦିକାରିକେ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ଜିଉଦିଇଂ ଦେକ୍‍ରକମ୍‍ ଗାଗ୍‍ଚେ ଆମେକେ ଅଣଜିଉଦିଇଂନେ ନ୍ତି ଡାଗ୍ରା ସର୍‍ପେ ବିଃଆର୍‍ଏ ।” ");
INSERT INTO gaq_vpl VALUES ("AC21_12","074_21_12","ACT","21","12","12","ଏନ୍‍ ଅଁଚେ ନେ ଆରି ଆତ୍‍ଅରିଆ ଲେଃମ୍ୟାକ୍ନେ ବିନ୍‍ରେ ପାଉଲ୍‍କେ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ମାୱେନ୍‍ସା ଗୁଆରି ଡିଙ୍ଗ୍‌ ଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_13","074_21_13","ACT","21","13","13","ମାତର୍‍ ପାଉଲ୍ ଉତର୍‍ ବିକେ, “ପେ ଏନ୍‍ ମେଁ ଡିଂ ପେଡିଂକେ ମେଁସା ଦେକ୍‍ରକମ୍‍ ଅଁଚେ ନେଙ୍ଗ୍‍ ଜିବନ୍‌କେ ଦୁକ୍‍ ଆଃଡିଂପେଡିଂକେ ? ଜିସୁନେ ମ୍ନି ନ୍‌ସା ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ମାତର୍ ଗାଗ୍‌ ନ୍‌ସା ଣ୍ଡୁ ମାତର୍‍ ମାପ୍‌ରୁ ଜିସୁ ଆତ୍‍ଲା ଗୁଏଃନ୍‍ସା ଡିଗ୍‍ ନେଙ୍ଗ୍‍ ତିଆର୍‌ ଡିଂନ୍ଲେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC21_14","074_21_14","ACT","21","14","14","ନେ ଆମେକେ ଆଦ୍ରିଗ୍‍ ମାୟାଚେ ଆତ୍‍ବା ବୁଙ୍ଗ୍‍ ଲେଃଚେ ନେବାଲିର୍‌କେ, “ମାପ୍‍ରୁନେ ଇକ୍‌ଚା ପୁରନ୍‍ ଡିଂଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC21_15","074_21_15","ACT","21","15","15","ଆତ୍‍ଅରିଆ ଉଡ଼ିସି ୱେକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ନେ ନେନେ ଜିନିସ୍‍ ସାମାନ୍‍ଇଂ ସଜେଚେ ଯିରୁସାଲାମ୍‌ ପାକା ନେୱେକେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_16","074_21_16","ACT","21","16","16","କାଇସରିୟାନେ ଉଡ଼ିରୁଆ ସିସ୍‍ ଆରି ସାଇପ୍ରସ୍‌ନେ ମନାସୋନ ମ୍ନିକ୍ନେ ମୁଇଂ ବିସ୍‍ବାସି ଡିଗ୍‍ ନେ ଏତେ ୱେକେ । ମନାସୋନନେ ଡୁଆ ନେ ଲେଃନେ ନିୟମ୍‌ ଆର୍‍ମେ ବଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_17","074_21_17","ACT","21","17","17","ନେ ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ନେୱେଚାକେ ଆନେକେ ବୟାଁଇଂ ସାର୍‍ଦାରେ ସାର୍ଲ ଆମ୍ୟାଃଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_18","074_21_18","ACT","21","18","18","ତେନ୍‍ ମାର୍‍ତଡ଼େ ପାଉଲ୍‍ ନେ ଏତେ ଜାକୁବ୍‌କେ କେନ୍‍ସା ୱେଆର୍‍କେ; ସେବକ‍ଇଂ ଆତ୍‍ଅରିଆ ପିଙ୍ଗ୍‍ଚାଲେ ଆର୍‍ଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_19","074_21_19","ACT","21","19","19","ପାଉଲ୍‍ ଆମେଇଂକେ ଜୁଆର୍‌ ବେଟ୍‌ ଡିଙ୍ଗ୍‌ଚେ ମେଁନେ କାମ୍ ବାନ୍‍ ଇସ୍‍ପର୍‍ ଅଣଜିଉଦିଇଂନେ ବିତ୍‍ରେ ମେଁ ଡିଂବଗେ; ମେଁନେ ମୁଇଂ ପୁରାପୁରି ବାବ୍‍ରେ ଆମ୍ୟାଃବିଃଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_20","074_21_20","ACT","21","20","20","ମେଁନେ ସାମୁଆଁ ଦ୍ରିଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‍ ମେଇଂ ସାପାରେ ଇସ୍‍ପର୍‍କେ ପ୍ରସଂସା ଡିଂ ଆର୍‍କେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଇଂ ବାଲିର୍‍ ଆର୍କେ “ବୟାଁ ପାଉଲ୍‍ ନାଁ ତ କେନାଡିଂକେ, ଡିରକମ୍‍ ଏବେ ଅଜାର୍‍ ଅଜାର୍‍ ସଂକ୍ୟାରେ ଜିଉଦିଇଂ ମାପ୍‌ରୁ ଜିସୁ ଡାଗ୍ରା ବିସ୍‍ବାସ୍‍ ଡିଂଆର୍‍ଡିଂକେ ଆରି ମେଇଂ ନିୟମ୍‌ ଆଡ଼ାତ୍ରା ଡିଗ୍‍ ଜାବର୍‌ ସାର୍‌ଦାରେ ଲେଃଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_21","074_21_21","ACT","21","21","21","ମେଇଂ କବର୍‍ ବାଲେଃଆର୍‍କେ ଜେ ନା ଅଣଜିଉଦିଇଂନେ ଦେସ୍‍ନ୍ନିଆ ବାସା ଡିଂଆର୍‍କ୍ନେ ଜିଉଦିଇଂକେ ମୋଶାନେ ନିୟମ୍‌ ଆନ୍ତାର୍‍ନ୍‍ସା ଆସିକେ ପେଡିଂ । ପେ ଆମେଇଂକେ ମେଇଂନେ ଗଡ଼େଅଇଂନେ ପବିତ୍ର‍ ମାରାଃଡିଂନେ ନ୍‌ସା ଆରି ଜିଉଦିଇଂନେ ନିୟମ୍‌ଇଂ ମାମାନେଃ ନ୍‌ସା ଆଃସିକେ ପେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_22","074_21_22","ACT","21","22","22","ନା ଆକ୍‍ଅରିଆ ପିଙ୍ଗ୍‍ଚା ନେଲେଃକେ ଡାଗ୍‍ଚେ ମେଇଂ ଡିଲାଡିଗ୍‌ ଅଁ ଆର୍‍ଏ । ତେଲା ମେଃ ନେଡିଂଏ ? ");
INSERT INTO gaq_vpl VALUES ("AC21_23","074_21_23","ACT","21","23","23","ନେ ଚାଏଁ ନେଡିଂକେ ନା ମୁଇଂ କାମ୍‍ ଡିଂ । ଆକ୍‍ଅରିଆ ଲେକ୍ନେ ଅଁଣ୍ଡ୍ରୁଆ ରେମୁଆଁ ଇସ୍‍ପର୍‍ ଡାଗ୍ରା ନ୍ତି ଟେକେ ବଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_24","074_21_24","ACT","21","24","24","ମେଇଙ୍ଗ୍‌ ଏତେ ୱେଲା । ଶୁଚିକରଣ ନିୟମ୍‌ ପାଲନ୍‍ନିଆ ମେଇଙ୍ଗ୍‌ ଏତେ କୁଡ଼େଚେ ମେଇଂନେ ବାଆଃ କୁଆର୍‍ ନ୍‌ସା କର୍ଚ ବିଃପା । ଏନ୍‍ବାନ୍‍ ସାପାରେ ବାବେ ଆର୍‍ଏ ଜେ ମେଇଂ ପେ ବିସୟ୍‍ରେ ଜା ସାପା ଅଁଲେଃଆର୍କେ ଆତେନ୍‌‍ ମିଚ୍‍ । ମେଇଂ କେଆର୍‍ଏ ଜେ ପେ ନିଜର୍‍ ନିଜର୍‍ ଜିବନ୍‍ରେ ମସାନେ ନିୟମ୍‌ ମାନେଃଚେ ଚଲେ ପେଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_25","074_21_25","ACT","21","25","25","ନେ ଅଣଜିଉଦି ବିସ୍‍ବାସି ରେମୁଆଁଇଂକେ ଚିଟି ଉଲିଆ ଗୁଆର୍‍ନେଡିଂକେ ଜେ ନେନେ ନିସ୍ପତି ଇସାବ୍‍ରେ ମେଇଂ ମୁର୍ତ୍ତି ପୁଜାଅରିଆ ନ୍ତି ଟେକେବକ୍ନେ ଜିନିସ୍ ଆଚଂଆର୍‍ ଣ୍ଡୁ ମିଆଁ ଆଉଗ୍‍ଆର୍‍ ଣ୍ଡୁ, ଲୁଗଃ ଲିଃଗଚେ ଆଗୁଏବକ୍ନେ ପସୁନେ ଚିଲି ଆଚଂଆର୍‍ଲେ ଆରି ଦଦ୍ୟା‌ ପାପ୍‌ବାନ୍‌ ସ୍ଲ ଲେଃଆର୍‍ଲେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC21_26","074_21_26","ACT","21","26","26","ତେନ୍‍ ଆମାର୍‍ତଡ଼େ ପାଉଲ୍‍ ଆତେନ୍‌‍ ଅଁ ଣ୍ଡ୍ରୁଆ ଏତେ ଶୁଚିକରଣ ନିୟମ୍‌ ପାଲେ ଆର୍‍କେ । ତେନ୍‌ ଇଡ଼ିଂ ମେଁ ମନ୍ଦିର୍‍ନ୍ନିଆ ୱେଚେ ପବିତ୍ର ଡିଂନେ କାମ୍ ଅଃନା ଡାଏ ଆରି ଉଡ଼ି ବେଲା ଗିମିଃ ମିଆଁ ବିଃଆର୍‍ଏ, ଆତେନ୍‌‍ ଆମ୍ୟାଃଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_27","074_21_27","ACT","21","27","27","ପବିତ୍ର ଡିଂନେ କାମ୍‍ନେ ଗୁ ଦିନା ଡାକ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ଆସିଆ ପ୍ରଦେସ୍‍ନେ ଉଡ଼ିରୁଆ ଜିଉଦି ମନ୍ଦିର୍‍ନ୍ନିଆ ପାଉଲ୍‍କେ କେଆର୍‍କେ । ମେଇଂ ଆତ୍‍ଅରିଆ ମୁଇଂନୁଗ୍‍ ରିସିଂଲେକ୍ନେ ରେମୁଆଁଇଂକେ ଅବାଃଲିର୍‍ଚେ ପାଉଲ୍‍କେ ସାଃଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_28","074_21_28","ACT","21","28","28","ମେଇଂ କିରଚେ ବାଲିର୍‍ ଆର୍‍କେ “ଏ ଇଶ୍ରାଏଲ୍‌ନେ ବୟାଁଇଂ ଆନେକେ ସାଇଜ୍ୟ ଡିଂପା ! ଆକେନ୍‍ ରେମୁଆଁ ପିତୁର୍‍ପାକା ୱେଚେ ଇସ୍ରାଏଲ୍‍ନେ ରେମୁଆଁଇଂନେ ବିରଦ୍‌ରେ ମୋଶାନେ ନିୟମ୍‌ ଆରି ଏନ୍‍ ମନ୍ଦିର୍‍ ବିରଦ୍‌ରେ ଗ୍ୟାନ୍‌ ବିଣ୍ଡିଂ । ବାରି ଏବେ ମେଁ ଉଡ଼ିରୁଆ ଗ୍ରୀକ୍‌ ରେମୁଆଁଇଂକେ ମନ୍ଦିର୍‍ ଡାଗ୍ରା ଡୁଙ୍ଗ୍‍ପାଂଚେ ଏନ୍ ପବିତ୍ର ଜାଗାକେ ଅସୁଚି ଆଡିଂବ ଆର୍‍କେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC21_29","074_21_29","ACT","21","29","29","ମେଇଂ ସହର୍‍ନ୍ନିଆ ଏଫିସିୟନେ ତ୍ରଫିମକେ ପାଉଲ୍‍ ଏତେ କେଲେଃଗ୍‌ସା ବାବେଆର୍‍କେ ଜେ ପାଉଲ୍‍ ଆମେକେ ମନ୍ଦିର୍‍ନ୍ନିଆ ଡୁଂୱେବକେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_30","074_21_30","ACT","21","30","30","ଗୁଲେ ସହର୍‍ପାକା ଉଡ୍ରା ଡିଂୱେଗେ ରେମୁଆଁଇଂ ମୁଇଂ ମାଡ୍‌ରେ ୱିର୍‍ ଡୁଂୱେଆର୍‍କେ ଆରି ମେଇଂ ପାଉଲ୍‍କେ ସାଚେ ମନ୍ଦିର୍‍ ବାଏରେ ଉର୍‍ଗୁ ଡୁଂପାଙ୍ଗ୍‍ ଆର୍‍କେ ଆରି ଆତେନ୍‌‍ ଦାପ୍ରେ କାପାଟ୍‍ ସାପା ବନ୍ଦ୍ ଡିଂୱେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_31","074_21_31","ACT","21","31","31","ଆରି ମେଇଂ ଆମେକେ ବାଗୁଏଃ ବିଃନ୍‍ସା ଚେସ୍‌ଟା ଡିଂଆର୍‍କେ ଗୁଲେ ଯିରୁସାଲାମ୍‌ କିରମର ଡିଂଡିଂଗେ ଡାଗ୍‍ଚେ ସନ୍ୟଦଲ୍‍ନେ ମୁଇଂ ସ ସେନାପତିଇଂନେ ଡାଗ୍ରା କବର୍‍ ବିଆର୍‌କେ ");
INSERT INTO gaq_vpl VALUES ("AC21_32","074_21_32","ACT","21","32","32","ଆତ୍‍ବା ମେଁ ଆତେନ୍‌‍ ଦାପ୍ରେ ସନ୍ୟ ଆରି ମୁଇଂ ଶହନେ ନେତା ମୁଇଂସ ସନ୍ୟ‍ଇଂନେ ନେତା‍ଇଂକେ ସାଚେ ମେଇଂ ଡାଗ୍ରା ୱିର୍‍ ଡୁଂୱେଆର୍‍କେ । ମେଇଂ ମୁଇଂ ଶହ ସେନାପତି ଆରି ସନ୍ୟଇଂ କେଚେ ପାଉଲ୍‍କେ ବାରି ମାବଗ୍‍ଚେ ଆନ୍ତାର୍‍ ବିଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_33","074_21_33","ACT","21","33","33","ଆତେନ୍‌‍ବେଲା ମୁଇଂ ଶହ ସେନାପତି ଡାଗ୍ରା ପାଙ୍ଗ୍‌ଚେ ଆମେକେ ମ୍ୱାର୍‍ତି ସିକ୍ଲିଏତେ ଗାଗ୍‌ନ୍‌ସା ଆଦେସ୍‍ ବିଃଆର୍କେ ବାରି “ମେଁ ଜାଣ୍ଡେ ଆରି ମେଁ ମେଁ ଡିଙ୍ଗ୍‌ବକେ ?” ଡାଗ୍‍ଚେ ସାଲିଆକୁଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_34","074_21_34","ACT","21","34","34","ରେମୁଆଁ ଗହଲିବାନ୍‍ ଜା ଉଡ଼ି ରକମ୍‍ନେ ସାମୁଆଁ ବାଲିର୍‍ଚେ ୱାସାର୍‍ ଆର୍‍କେ ଦେକ୍‍ରକମ୍‍ କିରମର ଡିଂକେ ଜେ ସେନା ନେତା ସତ୍‍ ଗଟ୍‌ନା ମେଁନେ ମେଃଡିଗ୍‍ ବୁଜେ ଆୟାକେ ଣ୍ଡୁ । ତେସା ମେଁ ପାଉଲ୍‍କେ ସନ୍ୟ ଡୁଆ ବିତ୍‍ରେ ଡୁଂୱେନ୍‍ସା ସୈନିକ୍‌ଇଂକେ ଆଦେସ୍‍ ବିଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_35","074_21_35","ACT","21","35","35","ମେଇଂ ଆମେକେ ଡୁଂୱେଚେ ସନ୍ୟ ଡୁଆନେ ପାଆଚ୍‌ ଡାଗ୍ରା ୱେଚାନେ ବେଲା ଆମେକେ ଗେରେ ଲେକ୍ନେ ରେମୁଆଁଗଣ୍ଡ୍‌ଇଂ ଏନ୍ତି କିରମର ଡିଂଆର୍‍କେ ଜେ ସନ୍ୟଇଂ ପାଉଲ୍‍କେ ଡୁଙ୍ଗ୍‍ଚେ ଡୁଂଡଆର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_36","074_21_36","ACT","21","36","36","ରେମୁଆଁଇଂ ସାପାରେ ମେଁ ପ୍ଲା ପାଙ୍ଗ୍‌ଚେ ୱାସାର୍‍ଚେ ବାସଙ୍ଗ୍‍ଡିଂଆର୍‍ଗେ “ଆମେକେ ବାଗୁଏ ବିଃପା ।” ");
INSERT INTO gaq_vpl VALUES ("AC21_37","074_21_37","ACT","21","37","37","ସନ୍ୟଇଂ ପାଉଲ୍‍କେ ପ୍ରାସାଦ୍‌ ବିତ୍‍ରେ ଡୁଂୱେନେ ବେଲା ମେଁ ସେନାଇଂନେ ନେତାକେ ବାଲିର୍‍କେ, “ଆନା ନେଙ୍ଗ୍‍ ମେଁ ଡିଗ୍‍ ବାସଙ୍ଗ୍‌ ୟାଲେଃ ?” ସେନାଇଂନେ ନେତା ସାଲିଆକୁକେ, “ନା ତ ଗ୍ରୀକ୍‍ ବାସା ବାଲିର୍‍ ନାଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC21_38","074_21_38","ACT","21","38","38","ତେଲା ନା ମେଁନେ ଆତେନ୍‌‍ ମିସର୍‌ନେ ରେମୁଆଁ ଣ୍ଡୁ, ଜା ଉଡ଼ିମୁଆଁ ଅଃସେ ସର୍‍କାର୍‍ନେ ବିରୁଦ୍‌ରେ ଜୁଦ୍‌ ଡିଂବଗେ ଆରି ଅଁ ଅଜାର୍‍ ଡାକୁ ସାଚେ ବାଲିଲଃନ୍ନିଆ ୱେଲେଃଆର୍‍ଗେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC21_39","074_21_39","ACT","21","39","39","ପାଉଲ୍‍ ଉତର୍‍ ବିକେ “ସିଲିଷୀଆନେ ତାର୍ଷିସ୍‍ନ୍ନିଆ ଜନମ୍‍ ଡିଂଲେକ୍ନେ ନେଙ୍ଗ୍‍ ମୁଇଂ ଜିଉଦି ରେମୁଆଁ ମୁଇଂ ମ୍ନା ସହର୍‍ନେ ନାଗରିକ । ଏନ୍‍ ରେମୁଆଁଇଂକେ ଆଦ୍ରିଗ୍‍ଚେ ବାଲିର୍‍ ନ୍‌ସା ଦୟା ଡିଂଚେ ଆନେଙ୍ଗ୍‍ ଆଦେସ୍‌ ବିଲା ।” ");
INSERT INTO gaq_vpl VALUES ("AC21_40","074_21_40","ACT","21","40","40","ସେନାପତି ଆମେକେ ଆଦେସ୍‌ ବିଲା ପାଉଲ୍‍ ପାଆଚ୍‌ ଆଡ଼ାତ୍ରା ତୁଆଁଚେ ରେମୁଆଁଇଂକେ ବୁଙ୍ଗ୍‍ଲେଃ ନ୍‍ସା ନ୍ତି ଆତଡ଼ିଆଚେ ବାଲିର୍‍କେ । ମେଇଂ ବୁଙ୍ଗ୍‍କ୍ନେ ଇଡ଼ିଙ୍ଗ୍‌ ପାଉଲ୍‍ ଏବ୍ରୀ ବ୍ନାସାରେ ବାଲିର୍‍କେ । ");
INSERT INTO gaq_vpl VALUES ("AC22_1","074_22_1","ACT","22","1","1","“ବୟାଁ ବାରି ଡକ୍ରାରେଇଂ ପେ ସାର୍‍ମୁଆଃ ଡାଗ୍ରା ନିଜେ ପାକାବାନ୍‍ ନେଙ୍ଗ୍‍ ମେଃନେ ବାସଙ୍ଗ୍‍ଣ୍ଡିଂ ଅଃତେନ୍‍ ଦ୍ରିଗ୍‍ପା !” ");
INSERT INTO gaq_vpl VALUES ("AC22_2","074_22_2","ACT","22","2","2","ମେଇଙ୍ଗ୍‌ ଏତେ ମେଁ ଏବ୍ରୀ ବ୍ନାସାରେ ସାମୁଆଁ ବାସଙ୍ଗ୍‍ନେ ଅଁଚେ ମେଇଂ ବାରି ବୁଙ୍ଗ୍‍ ଆର୍‍ଗେ ଆରି ପାଉଲ୍‍ ବାଲିର୍‍ନେ ମୁଲେଃକେ । ");
INSERT INTO gaq_vpl VALUES ("AC22_3","074_22_3","ACT","22","3","3","“ନେଙ୍ଗ୍‍ ମୁଇଂ ଜିଉଦି ରେମୁଆଁ ସିଲିଷୀଆନେ ତାର୍ଷିସ୍‌ଡାଗ୍ରା ନେଙ୍ଗ୍‍ନେ ଜନମ୍‍ ମାତର୍‍ ନେଙ୍ଗ୍‍ ଯିରୁସାଲାମ୍‍ନ୍ନିଆ ଲାଲନ୍‍ ପାଲନ୍‍ ଡିଙ୍ଗ୍‍ନ୍ଲେଗେ ବାରି ଗମଲିଏଲ୍‍ନେ ମୁଇଂ ଗଡ଼େଅ ଲେଃଗେ । ନେନେ ନ୍ତା ଞ୍ଜାଇଂନେ ନିୟମ୍‌ ନେଙ୍ଗ୍‍ ସତ୍‍ ବାବ୍‍ରେ ସିକ୍ୟା ବାନ୍ଲେକେ ବାରି ପେ ରକମ୍‍ ଇସ୍‍ପର୍‍ଡାଗ୍‍ରା ଜାବର୍‌ ସାର୍‌ଦାରେ ନ୍ଲେଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC22_4","074_22_4","ACT","22","4","4","ନେଙ୍ଗ୍‍ ଆକେନ୍‍ ଗାଲି ତୁର୍‍ ଅଲେଙ୍ଗ୍‍ ମ୍ୟାଃକ୍ନେ ରେମୁଆଁଇଂନେ ଆଡ଼ାତ୍ରା ଅତ୍ୟାଚାର୍‍ ଡିଂଚେ ଆମେଇଂକେ ଜିବନ୍‍ରେ ବାଗୁଏ ବିମ୍ୱଗେ । ସେଲାମ୍ବୁଏଃ ଆରି ଙ୍ଗିରେ ସାପାରେକେ ବନ୍ଦି ଆଡିଂଚେ କ‍ଏଦ୍‍ ଡୁଆନ୍ନିଆ ଆଗା ନେବଗେ । ");
INSERT INTO gaq_vpl VALUES ("AC22_5","074_22_5","ACT","22","5","5","ନେଙ୍ଗ୍‍ନେ ଆକେନ୍‍ ସାମୁଆଁ ଜେ ସତ୍‍ ମ୍ନା ପୁଜାରି ବାରି ମ୍ନା କୁକପାର୍‍ନେ ସାପାରେ ଆକେନ୍‍ ସାକି ଲେଃଆର୍କେ । ଏନ୍‌‍ ରେମୁଆଁଇଂକେ ବନ୍ଦି ଆଡିଂଚେ ବାରି ସିକିଲି ଏତେ ଗାଗ୍‍ଚେ ଡଣ୍ଡ୍‍ ବିନ୍‍ସା ଯିରୁସାଲାମ୍‌ନ୍ନିଆ ସାଚେ ଡୁଙ୍ଗ୍‍ପାଂନେସା ନେଙ୍ଗ୍‍ ମ୍ନା ପୁଜାରିବାନ୍‍ ପରିଚୟ୍‌ ଉଲିଆ ଡୁଂୱେଚେ ଦାମାସ୍କସ୍‌ଡାଗ୍ରା ଲେକ୍ନେ ଜିଉଦି ବୟାଁଇଂଡାଗ୍ରା ଉଁୱେକେ ।” ");
INSERT INTO gaq_vpl VALUES ("AC22_6","074_22_6","ACT","22","6","6","“ନେଙ୍ଗ୍‍ ଯାତ୍ରା ଡିଂଚେ ଉଡ଼ିବେଲା ଦାମାସ୍କସ୍‌ଡାଗ୍ରା ଡିଂଣ୍ଡିଙ୍ଗ୍‍ଗେ ପ୍ରାୟ୍ ସ୍ମି ବେଲା କିତଂଇନିବାନ୍‍ ମୁଇଂ ତାର୍‍କିଗ୍‍ସ ଉଲୁସ୍ତେ ନେଙ୍ଗ୍‍ ପିତୁର୍‍ପାକା ତାର୍‍କିଗ୍‍ ଡିଂକେ । ");
INSERT INTO gaq_vpl VALUES ("AC22_7","074_22_7","ACT","22","7","7","ନେଙ୍ଗ୍‍ ତୁବଡାଗ୍ରା ମୁଗ୍‍ଚିଚେ ଲଃ ଙ୍ଗୁଏଃଏ ଆରି ନେଙ୍ଗ୍‍ ନ୍‌ସା ଏନ୍‍ ଇଲ୍‍ଏଁ ଙକେ, ‘ଶାଉଲ୍‍ ଶାଉଲ୍‍ ! ନା ମେଁସା ଆନେଙ୍ଗ୍‍ ଗୁର୍‌ନା ଡିଂନାଡିଂକେ ?’ ");
INSERT INTO gaq_vpl VALUES ("AC22_8","074_22_8","ACT","22","8","8","ନେଙ୍ଗ୍‍ ସାଲିଆଙ୍କୁକ୍‍କେ ‘ମାପ୍‌ରୁ ନାଁ ଜାଣ୍ଡେଃ ?’ ମେଁ ଆନେଙ୍ଗ୍‍କେ ବାଲିର୍‍କେ ନାଁ ଆଜାକେ ଗୁର୍‌ନା ଡିଂନାଡିଂକେ, ନେଙ୍ଗ